﻿USE sofia;
DROP TABLE IF EXISTS sofia.cuxNT_vpl;
CREATE TABLE cuxNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cuxNT_vpl WRITE;
INSERT INTO cuxNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chuū chí lista yeⁿ'e ndaata yeⁿ'e Jesucristo, ndíí na ndaata Abraham ndíí na ndaata David ndíí tiempo chi ch'iindiyáāⁿ Jesucristo. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham miiⁿ ch'iīndī daiya sa chi nguuvi Isaac. Isaac miiⁿ ní ch'iīndī daiya sa chi nguuvi Jacob. Jacob miiⁿ ní ch'iīndī daiya sa Judá ndúúcū tanáⁿ'ā 'díínu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá miiⁿ ní ndúúcū Tamar chi n'daataá yeⁿ'ē sa ch'iīndī daiyá yā chi cuates chi nguuvi Fares ndúúcū Zara. Fares miiⁿ ní ch'iīndī daiya sa Esrom. Esrom miiⁿ ní ch'iīndī daiya sa Aram. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram miiⁿ ní ch'iīndī daiya sa Aminadab. Aminadab miiⁿ ní ch'iīndī daiya sa Naasón. Naasón miiⁿ ní ch'iīndī daiya sa Salmón. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ndúúcū Rahab chi n'daataá yeⁿ'ē sa ní ch'iīndī daiyá yā Booz. Booz miiⁿ ndúúcū Rut chi n'daataá yeⁿ'ē sa ní ch'iīndī daiyá yā Obed. Obed miiⁿ ní ch'iīndī daiya sa Isaí. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí miiⁿ ní ch'iīndī daiya sa rey David. Rey David miiⁿ ní ch'iīndī daiyá yā Salomón taachi caneé yā ndúúcū n'daataá chi vmnááⁿ vmnaaⁿ ní n'daataá yeⁿ'e saⁿ'ā Urías. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón miiⁿ ní ch'iīndī daiya sa Roboam. Roboam miiⁿ ní ch'iīndī daiya sa Abías. Abías miiⁿ ní ch'iīndī daiya sa Asa. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa miiⁿ ní ch'iīndī daiya sa Josafat. Josafat miiⁿ ní ch'iīndī daiya sa Joram. Joram miiⁿ ní ch'iīndī daiya sa Uzías. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías miiⁿ ní ch'iīndī daiya sa Jotam. Jotam miiⁿ ní ch'iīndī daiya sa Acaz. Acaz miiⁿ ní ch'iīndī daiya sa Ezequías. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías miiⁿ ní ch'iīndī daiya sa Manasés. Manasés miiⁿ ní ch'iīndī daiya sa Amón. Amón miiⁿ ní ch'iīndī daiya sa Josías. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías miiⁿ ní ch'iīndī daiya sa Jeconías. Jeconías miiⁿ ndúúcū tanáⁿ'ā vi'i yā ch'iindiyáaⁿ yā taachi chiidá yā ndúúcū chɛɛcú yā ní preso yā ndúúcū tanáⁿ'ā 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel ní taachi cueⁿ'é yā na cyúúní na yáⁿ'āa Babilonia. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cuayiivi chi cho'ó yā na yáⁿ'āa Babilonia, Jeconías miiⁿ ní ch'iīndī daiya sa Salatiel. Salatiel miiⁿ ní ch'iīndī daiya sa Zorobabel. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel miiⁿ ní ch'iīndī daiya sa Abiud. Abiud miiⁿ ní ch'iīndī daiya sa Eliaquim. Eliaquim miiⁿ ní ch'iīndī daiya sa Azor. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor miiⁿ ní ch'iīndī daiya sa Sadoc. Sadoc miiⁿ ní ch'iīndī daiya sa Aquim. Aquim miiⁿ ní ch'iīndī daiya sa Eliud. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud miiⁿ ní ch'iīndī daiya sa Eleazar. Eleazar miiⁿ ní ch'iīndī daiya sa Matán. Matán miiⁿ ní ch'iīndī daiya sa Jacob. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob miiⁿ ní ch'iīndī daiya sa José, 'iiⁿ'yāⁿ chi isáⁿ'ā yeⁿ'e María. Ní daiya ta ní Jesús chi nguuvi Cristo. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","'Tíícā nducuéⁿ'ē ndaata yeⁿ'e Abraham ndíí rey David ní ndiichicúūuⁿ ndaata yeⁿ'é yā o generaciones. Ní ndíí rey David miiⁿ ndíí taachi cueⁿ'e nducyáácá 'iiⁿ'yāⁿ ndaata yeⁿ'e yā na país Babilonia ní ndiichicúūuⁿ ndaata yeⁿ'é yā. Ní ndíí taachi cheⁿ'e yā na yáⁿ'āa Babilonia ndíí taachi ndaā Cristo iⁿ'yéeⁿdi 'cūū ní ndiichicúūuⁿ ndaata yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","'Túúcā ch'iindiyáāⁿ Jesucristo. Taachí María miiⁿ chi chɛɛcu Jesús miiⁿ caⁿ'a yā chi 'caandavaacú yā ndúúcū José níícú taachi 'āā cuɛ́ɛ́ 'caandavaacú yā ndúúcū vi'ī, vɛ́ɛ́ 'áámá daiya yā chɛɛtí yā cucáávā Espíritu N'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José miiⁿ ní neⁿ'é yā 'caandavaacu yā ndúúcū María miiⁿ. Ní José miiⁿ ní nééné n'dai yā. Ní cuayiivi nguɛ́ɛ́ neⁿ'é yā 'caandavaacú yā ndúúcū táⁿ'ā cucáávā chi vɛ́ɛ́ dacua'a chɛɛtí yā. Ní nguɛ́ɛ́ neⁿ'é yā yaa'vi yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿya yeⁿ'e María chi nguɛ́ɛ́ n'daācā ti nguɛ́ɛ́ neⁿ'é yā chi María cuuví 'cuinaaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ní taachí José miiⁿ nacadíínuuⁿ yā chi cu'neeⁿ yā María miiⁿ, cuayiivi ní taachí cyaadu yā, 'áámá ángel yeⁿ'e Señor Ndyuūs che'enaáⁿ yā yeⁿ'é yā ní caⁿ'a yā chiī yā José miiⁿ: Díí, José, saⁿ'ā yeⁿ'e ndaata rey David, nguɛ́ɛ́ 'va'a di cuuví n'daataá yeⁿ'e di María, ti dacuá'ā yeⁿ'ē tá chi vɛ́ɛ́ chɛɛti tá nguɛ́ɛ́ yeⁿ'e 'iiⁿ'yāⁿ ti yeⁿ'ē Espíritu N'dai yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ní táⁿ'ā miiⁿ ní 'cuundiyáāⁿ daiya tá 'áámá saⁿ'ā 'lííⁿ. Díí ní cu'neeⁿ di chí ngúúví sá JESÚS caati cucáávā Jesús miiⁿ ní nadanguáⁿ'ai 'iiⁿ'yāⁿ yeⁿ'ē íⁿ'yeeⁿdí 'cūū ní nadich'ɛɛcú yā nuuⁿndi yeⁿ'e nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tanducuéⁿ'ē chuū ní 'tíícā chiī ndúúcū María ní 'íícú cuuvi cuaacu chí caⁿ'ā profeta yeⁿ'e nduudu yeⁿ'é Ndyuūs ndíí cuaaⁿ vmnaaⁿ, nduudu chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs 'tíícā: ");
INSERT INTO cuxNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Níícú n'diichí nī. Tá 'cūū 'áámá chí cuiinuu tá 'cuūndī daiya tá. Taachí 'cuundiyáāⁿ 'áámá daiya tá ní cu'neeⁿ chi duuchi Emanuel chí neⁿ'e caaⁿ'maⁿ Ndyuūs ndúúcū s'uūúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuayiivi miiⁿ ní taachi José miiⁿ nanduuchí yā, tuu'mi ní diíⁿ yā tan'dúúcā chi ngaⁿ'ā ángel yeⁿ'e Señor Ndyuūs níícú ch'iindivaacú yā ndúúcū María miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Naati José miiⁿ nguɛ́ɛ́ n'diichi sá María miiⁿ ndíí ch'iindiyaāⁿ daiya tá, ní José s'neeⁿ sá chi ngúúví dacua'āa miiⁿ dúúchí JESÚS. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Taachi Jesús ch'iindiyáaⁿ yā na yáāⁿ Belén yeⁿ'e yáⁿ'āa Judea, tiempo miiⁿ ní saⁿ'a Herodes miiⁿ ní rey yeⁿ'e yáⁿ'āa Judea. Ní n'duuví magos, 'iiⁿ'yāⁿ chi déénu ca yā yeⁿ'e 'ííⁿnyúⁿ ndiicá yaⁿ'áí yā ndíí cuaaⁿ ná ícan'daā 'yáⁿ'ā. Ní magos ndaa yā na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Magos ní ndaa yā nanááⁿ rey Herodes miiⁿ ní ntiinguuneeⁿ yā rey: ¿Tíí cánéé 'iiⁿ'yāⁿ chi rey yeⁿ'e 'iiⁿ'yāⁿ Israel chi 'niindiyáaⁿ yā? Nús'uū ní n'diichí 'nū 'áámá 'ííⁿnyúⁿ ch'ɛɛtɛ cuááⁿ ná ican'dáá 'yáⁿ'ā 'íícú chííⁿ chí cuchií 'nū. Níícú ndaá 'nū chí cu'téénú 'nū saⁿ'ā 'lííⁿ rey miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Taachí rey Herodes miiⁿ ch'iindiveéⁿ yā chuū, chistaⁿ'ā vaanicadíínūuⁿ yeⁿ'e yā. 'Tiicá ntúūⁿ nducyaaca 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén taachi ch'iindiveéⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ní rey Herodes miiⁿ ní nádaamá yā nducyaaca chiīdūu n'gɛɛtɛ́ chí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū Israel ndúúcū 'iiⁿ'yāⁿ chi ngi'cuééⁿ ley 'iiⁿ'yāⁿ yeⁿ'e Israel. Ní itiinguunéeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Tií 'niindiyáāⁿ Cristo? ");
INSERT INTO cuxNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā rey miiⁿ: 'Cuundiyáaⁿ yā na yáāⁿ Belén yeⁿ'e yáⁿ'āa Judea caati 'tíícā canéé nguūⁿ na libro yeⁿ'e Ndyuūs cucáávā saⁿ'a profeta: ");
INSERT INTO cuxNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Belén yeⁿ'e yáⁿ'āa Judá, ¿'áá nguɛ́ɛ́ yáāⁿ yeⁿ'e nī chi 'lííⁿ cá nguaaⁿ nducuéⁿ'ē yáāⁿ yeⁿ'e yáⁿ'āa Judá naachi 'iiⁿ'yāⁿ ndíí tiīiⁿ ngaⁿ'a ntiiⁿnyúⁿ yā? Nguɛ́ɛ́ chi 'tíícā, caati nguaaⁿ ndís'tiī chi yeⁿ'ē yáāⁿ Belén can'dáā 'áámá sáⁿ'ā chi ngaⁿ'ā ntiiⁿnyuⁿ sá yeⁿ'e nducyáácá 'iiⁿ'yāⁿ Israel chi judíos chi 'iiⁿ'yāⁿ s'eeⁿ chi Ndyuūs nndɛɛvɛ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tuu'mi ní rey Herodes yaa'vi n'dé'éí yā saⁿ'ā magos ní ntiinguuneeⁿ cá yā saⁿ'a s'eeⁿ: ¿Dɛ'ɛ̄ tiempo n'diichi nī 'ííⁿnyúⁿ miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ní rey miiⁿ ní caⁿ'a yā chii yā saⁿ'a s'eeⁿ: Ndís'tiī magos, cueⁿ'e nī na yáāⁿ Belén ní in'nuūⁿ n'daāca nī dacua'a 'lííⁿ miiⁿ. Ní taachí ndaaca nī dacua'a mííⁿ, nanguɛɛcunéeⁿ nī ní caaⁿ'maⁿ nī yeⁿ'é. Maaⁿ níícú 'úú ntúūⁿ ní cuuvi caⁿ'á cu'teenú dacua'a 'lííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Magos ní ch'iindiveéⁿ yā nduudu yeⁿ'e rey miiⁿ ní cúnaⁿ'a yā. Cuin'diichí nī. 'Ííⁿnyúⁿ chi 'iiⁿ'yāⁿ magos n'diīchi yā cuaaⁿ na ican'daa 'yáⁿ'ā, 'ííⁿnyúⁿ mííⁿ cueⁿ'é nanááⁿ yeⁿ'e magos taanduvɛ́ɛ́ ndaā ní cānee lugar naachi canéé dacua'a 'lííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ní taachi magos 'āā n'diichí yā 'ííⁿnyúⁿ miiⁿ, yéénú taaví yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ní taachi sndaá yā va'āī miiⁿ, n'diichí yā saⁿ'ā 'lííⁿ dacua'ā miiⁿ ndúúcū chɛɛcu sá María. Ní chíintii'yá yā nanááⁿ dacua'ā miiⁿ ní s'téénu yā. Taachi n'guaaⁿ yā caja naachi snéé regalos yeⁿ'e yā, tuu'mi ní ca'á yā yeⁿ'ē dacua'ā miiⁿ. Regalos ní 'dííⁿnguaāⁿ ndúúcū yáⁿ'ā chi n'dɛɛvɛ ngééⁿ ndúúcū mirra chí diītū taavi n'dai ngééⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Cuayiivi miiⁿ ní Ndyuūs yaa'vi yā magos na 'yúúdúyaaⁿ yeⁿ'e yā chí 'āā ntɛ́ɛ́ naⁿ'a yā nanááⁿ rey Herodes miiⁿ. Níícú magos cunaⁿ'a yā na vaacu yā na taama yúúní. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Taachi magos cunaⁿ'a yā, tuu'mi ní Ndyuūs dicho'ó yā 'áámá ángel níícú ángel miiⁿ ní ndaá yā nanááⁿ José miiⁿ taachi cyaadú yā ní caⁿ'a yā chii yā José: Díí José, nducueeⁿ di ní cuta'a di saⁿ'ā 'lííⁿ ní cueⁿ'e di cáanū di ndúúcū chɛɛcu sa ndíí yáⁿ'āa Egipto. Ní 'cuɛɛtinée nī miiⁿ ndíí taachi 'úú caaⁿ'máⁿ caati canéé chí rey Herodes miiⁿ ní nan'nuúⁿ yā saⁿ'ā 'lííⁿ chí 'caaⁿ'núⁿ yā saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José miiⁿ ní nanduuchí yā. 'Tiicá ntúūⁿ chɛɛcu sa. Ní sta'a yā saⁿ'ā 'lííⁿ miiⁿ ní nguiinū mííⁿ nūuⁿ cueⁿ'e yā ndúúcū chɛɛcu sa na yáⁿ'āa Egipto. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Níícú miiⁿ ch'ɛɛtinée yā ndíí chi ch'iī rey Herodes. Níícú cúúnú ca'a chííⁿ chí Señor Ndyuūs caⁿ'a yā na libro yeⁿ'e yā ndii cuááⁿ vmnaaⁿ cucáávā saⁿ'a profeta miiⁿ taachi caⁿ'a yā 'tíícā: Ná yáⁿ'āa Egipto 'caí daīyá. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Taachí rey Herodes miiⁿ tuumicadíínuuⁿ yā chi 'iiⁿ'yāⁿ magos chinnche'éí yā 'iiⁿ'yāⁿ, tuu'mi ní nduuvi taáⁿ n'dai yā. Ní rey miiⁿ ní caⁿ'a ntiiⁿnyuⁿ yā ní dichó'ó yā soldados chí ch'iiⁿ'nuⁿ yā nducyáácá dacua'āa chi saⁿ'ā ndíí cuaacu 'uūvī nduūyū chi vɛ́ɛ́ na yáāⁿ Belén ndúúcū tanáⁿ'ā yáāⁿ chí na niiⁿnuúⁿ. 'Tíícā rey miiⁿ diiⁿ cuenta yā ti cho'ōo 'uuvi nduūyū chi magos n'diichí yā 'ííⁿnyúⁿ ch'ɛɛtɛ miiⁿ yeⁿ'e nanguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tuu'mi ní cho'ōo chuū chi cuuvi cuaacu tan'dúúcā chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs cucáávā chi caⁿ'a saⁿ'ā profeta Jeremías cuááⁿ vmnaaⁿ 'túúcā: ");
INSERT INTO cuxNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Na yáāⁿ Ramá ch'iindiveéⁿ 'iiⁿ'yāⁿ chi ngɛɛcu yā ní n'gái yā ndúúcu 'áámá vaadī ya'ai ch'ɛɛtɛ́ cucáávā daiya yā chí ch'iī. N'daataá yeⁿ'ē Israel s'eeⁿ ngɛɛcu yā cucáávā daiya yā chi ch'iīⁿ'nūⁿ rey tan'dúúcā chi táⁿ'ā Raquel ngɛɛcu yā cucáávā daiya yā chí ch'iī. Ní nguɛ́ɛ́ chiī ndaacā n'daataa s'eeⁿ 'viich'ɛɛtíínūuⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cuayiivi taachí ch'iī rey Herodes miiⁿ, José miiⁿ ní 'āā canee yā na yáⁿ'āa Egipto. Tuu'mi ní Señor Ndyuūs dicho'o yā 'áámá ángel ní ángel che'enaáⁿ yā yeⁿ'é José taachi cyaadú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ní ángel miiⁿ caⁿ'a yā chii yā José: Díí José, nducueeⁿ di ní cuta'a di saⁿ'ā 'lííⁿ dacuá'āa ní cuinaⁿ'a di ndúúcū chɛɛcu sa na yáⁿ'āa Israel caati ch'iī 'iiⁿ'yāⁿ chí neⁿ'e yā 'caaⁿ'nuⁿ yā saⁿ'ā 'lííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tuu'mi ní José ncueeⁿ yā. 'Tiicá ntúūⁿ chɛɛcu sa. Ní sta'a yā saⁿ'ā 'lííⁿ miiⁿ ní cueⁿ'e yā ndúúcū chɛɛcu sa na yáⁿ'āa yeⁿ'e 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Taachí José miiⁿ ch'iindiveeⁿ yā chi saⁿ'ā Arquelao canéé lado yeⁿ'e rey Herodes chi chiida sa, tuu'mi ní José miiⁿ ní 'va'á yā chí caⁿ'a yā na yáⁿ'āa Judea chi yáⁿ'āa yeⁿ'e 'iiⁿ'yāⁿ Israel. Naati tan'dúúcā chi ángel che'enaáⁿ yeⁿ'e yā na 'yuudiyaaⁿ yeⁿ'e yā, cueⁿ'e yā yáⁿ'āa Galilea chi yáⁿ'āa yeⁿ'e 'iiⁿ'yāⁿ Israel ntúūⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ní ndaá yā na yáⁿ'āa mííⁿ ní cueⁿ'e yā ch'ɛɛtinee yā na yáāⁿ Nazaret yeⁿ'e yáⁿ'āa Galilea. Ní 'iicu cuuvi cuaacu chí caⁿ'a profetas vmnááⁿ vmnaaⁿ yeⁿ'e Jesús chi 'túúcā: Canéé chí cuuvi ngúúví yā 'iiⁿ'yāⁿ nazareno yā cucáávā chi cueⁿ'e yā na yáāⁿ Nazaret. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tiempo miiⁿ chiicá Juan chí cuɛɛ̄dínuūⁿniⁿ yā na lugar naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. Lugar miiⁿ chi yeⁿ'e yáⁿ'āa Judea ní mííⁿ ngaⁿ'a Juan nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan miiⁿ ní ngaⁿ'a yā chi 'túúcā: Ndís'tiī, ndaacadaamí nī yeⁿ'e chi diíⁿ nī chi nguɛ́ɛ́ n'dai caati 'āā ndaā niiⁿnuúⁿ nguuvi miiⁿ naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Níícú yeⁿ'e Juan 'cūū ní saⁿ'a profeta Isaías caⁿ'a yā yeⁿ'e yā vmnááⁿ vmnaaⁿ taachí caⁿ'a yā 'túúcā: 'Caandiveéⁿ nī. 'Áámá saⁿ'ā ngaⁿ'ā yuudu sa 'túúcā na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ: 'Cuundiyaáⁿ nī yúúní yeⁿ'ē Señor Ndyuūs caati cúchii yā. Nan'guáaⁿ nī yúúní cuaacu caavá yā. Didɛɛvɛ́ nī staava yeⁿ'é nī ní cuuvi cuaáⁿ nī 'iiⁿ'yāⁿ miiⁿ taachi ndaa yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Catecai Juan miiⁿ ní nin'dai ndúúcū yuūdū yeⁿ'ē 'iiti camello. Ní cinturón yeⁿ'ē sa ní diiⁿmaⁿ 'iiti. Níícú chí che'ē sa ní 'iiti langostas ndúúcū n̄'di'i yeⁿ'ē 'iiti 'yáaiⁿ chi vɛɛ cuɛɛti. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","N'deeé 'iiⁿ'yāⁿ can'daa yā chi 'caandiveéⁿ yā nduudu yeⁿ'é Juan miiⁿ. Ní can'daa yā yeⁿ'e yáāⁿ Jerusalén, yeⁿ'e yáⁿ'āa Judea, ní yeⁿ'e yáⁿ'āa chi cuaaⁿ 'diituú yeⁿ'ē yíícú Jordán. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'Iiⁿ'yāⁿ ní caⁿ'a yā nuuⁿndi yeⁿ'é yā nanááⁿ Ndyuūs níícú Juan miiⁿ ní chɛɛdínuūⁿnīⁿ sá 'iiⁿ'yāⁿ miiⁿ na yíícú Jordán miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Taachí Juan miiⁿ n'diīchī sa chi neené 'yaaⁿ 'iiⁿ'yāⁿ fariseos ndúúcū 'iiⁿ'yāⁿ saduceos neⁿ'é yā chi cuɛɛdínuūⁿnīⁿ sa 'iiⁿ'yāⁿ, Juan miiⁿ caⁿ'a sa chii sa 'iiⁿ'yāⁿ miiⁿ: Ndís'tiī tan'dúúcā cúú, 'tíícā ndís'tiī. ¿Du'ú chí 'cuééⁿ ndís'tiī chí cuuvi cáánu nī yeⁿ'e castigo taaⁿ chi cuchiī? ");
INSERT INTO cuxNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","N'daāca diíⁿ nī maaⁿ níícú 'cuuⁿ'míⁿ nī 'iiⁿ'yāⁿ chi 'āā ndaacadaamí nī yeⁿ'e nuuⁿndi yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ndís'tiī ní 'āā ntɛ́ɛ́ nadacádíínuuⁿ nī chi n'dai nī caati ndaata yeⁿ'e Abraham ndís'tiī. Naati 'úú ní ngaⁿ'á ngīi ndís'tiī chi Ndyuūs cuuvi diíⁿ yā chi tuūu s'tiī ní cuuvi daiya Abraham. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Cutíīiⁿ mííⁿ 'āā canéé na dii'yu yáⁿ'á. Nducyaaca yáⁿ'á chí nguɛ́ɛ́ n'dáacā ngii n'gui'i yeⁿ'ē canee chi 'caata yáⁿ'á mííⁿ ní cūnuuⁿ na yaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Úú ní cuaacu nííⁿnyúⁿ chí ngɛɛ̄dínuūⁿníⁿ ndís'tiī ndúúcū nuūⁿnīⁿ caati 'āā ndaacadaamí nī yeⁿ'e nuuⁿndi yeⁿ'e nī. Naati ndáá táámá 'iiⁿ'yāⁿ cuayiivi yeⁿ'e 'úú chi ch'ɛɛtɛ taavi cá poder yeⁿ'e yā nguɛ́ɛ́ ti 'úú. 'Úú ní nguɛ́ɛ́ neené n'dai 'úú chi cuuvi candɛɛ́ ndaacuú yeⁿ'e yā. 'Iiⁿ'yāⁿ miiⁿ ní n'dai taavi cá yā chi cuuvi 'úú. 'Iiⁿ'yāⁿ miiⁿ ní cuɛɛdínuūⁿniⁿ yā ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs ndúúcū yaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ní taachi ndaa 'iiⁿ'yāⁿ miiⁿ chi nguuvi Jesús diíⁿ yā tan'dúúcā 'áámá 'iiⁿ'yāⁿ chí didɛɛvɛ́ yā trigo 'tíícā diíⁿ yā ndúúcū 'iiⁿ'yāⁿ. Ní sta'á yā zaranda yeⁿ'e yā ní nadidaamá yā trigo na chɛɛti díínūuⁿ. Ní dɛɛcú miiⁿ ni'neeⁿ yaⁿ'a yā ná nguuchí yaⁿ'ā chi 'āā ntɛ́ɛ́ n'tuūvi. Dɛɛcú miiⁿ ní tan'dúúcā 'iiⁿ'yāⁿ chí nguɛ́ɛ́ i'téénu yā Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tuu'mi ní Jesús chiicá yā na yáⁿ'āa Galilea ní ndaá yā na yíícú Jordán naachi canee Juan chi Juan miiⁿ ní cuɛɛ̄dinúuⁿnīⁿ sa Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan miiⁿ ní nguɛ́ɛ́ 'cuuⁿ sa. Ní caⁿ'a sa chii sa Jesús miiⁿ: 'Úú ní neⁿ'é chi dii cuɛɛdínuūⁿnīⁿ di 'úú. ¿'Áá dii cuchiī di nanáaⁿ 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús nan'guɛɛcútaⁿ'a yā: Diiⁿ dí maaⁿ 'tíícā; ní diiⁿ yú tan'dúúcā chi Dendyuūs neⁿ'e yā chi diiⁿ yú. Tuu'mi ní Juan 'cuūⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuayiivi taachi 'āā chɛɛdínúuⁿnīⁿ Juan miiⁿ Jesús miiⁿ, tuu'mi ní Jesús ní nan'dáa yā na nuūⁿnīⁿ. Cuayiivi ní nanguaāⁿ nanguuvi. Ní Juan n'diichí sa Espíritu N'dai yeⁿ'é Ndyuūs miiⁿ chi tan'dúúcā paloma 'tíícā. Chiica yeⁿ'ē na va'ai chɛɛti nguuvi ní ndaā vmnaaⁿ yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tuu'mi ní n'giindiveéⁿ yā 'áámá nduudu yeⁿ'ē nanguuvi chí ngaⁿ'a: Saⁿ'a 'cūū Daiyá chí neⁿ'e taaví. Ní yeenú taaví cáávā sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tuu'mi ní Espíritu N'dai yeⁿ'é Ndyuūs candɛ́ɛ̄ Jesús miiⁿ ná yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ chi yááⁿn'guiinūuⁿ neⁿ'e sa chi Jesús diíⁿ yā nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús canée yā miiⁿ 'uūvū ngɛɛcu nguuvi ní 'uūvī ngɛɛcu n'gaaⁿ ní nguɛ́ɛ́ che'é yā. Ní cuayiivi ní cuiicú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yááⁿn'guiinūuⁿ ní ndaā sa nanááⁿ Jesús chí n'diichineeⁿ sa 'iiⁿ'yāⁿ. Ní caⁿ'ā sa: Dii Jesús, nduuti chi dii chi Daiya Dendyuūs dii, caaⁿ'maⁿ dí cuuvi dí tuūu 'cúū chi nduuví pan. Ní nduuvi pan ní cuuvi che'e di. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús miiⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: 'Túúcā canee nguūⁿ na libro yeⁿ'é Ndyuūs: Nguɛ́ɛ́ dámaāⁿ pan che'é 'iiⁿ'yāⁿ ní cunduūchi yā caati ndúúcū tanducuéⁿ'ē nduudu chi ngaⁿ'a Ndyuūs ní 'iiⁿ'yāⁿ cunduūchí yā nduuti chi cu'téénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tuu'mi ní yááⁿn'guiinūuⁿ miiⁿ candɛɛ sa Jesús na yáāⁿ Jerusalén chi yáāⁿ yeⁿ'e Ndyuūs. Ní chin'duu sá 'iiⁿ'yāⁿ na yáácú yeⁿ'e yaācū. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ní yááⁿn'guiinūuⁿ caⁿ'a sa chii sa Jesús: Nduuti chi dii chi Daiya Dendyuūs dii, cáávā di ndii 'múúⁿ ndii na yáⁿ'āa; caati 'túúcā canéé nguūⁿ na libro yeⁿ'é Ndyuūs: Ndyuūs dichó'o yā ángeles yeⁿ'e yā chi diiⁿ yā cuidado yeⁿ'ē di. Ní ángeles cundɛ́ɛ yā dii ndúúcū ta'á yā, ní nguɛ́ɛ́ cuuvi ya'ai ca'a di na tuūu. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús nán'guɛɛcútáⁿ'a yā: 'Tuucá ntúūⁿ canéé nguūⁿ na libro yeⁿ'é Ndyuūs: Nguɛ́ɛ́ diīⁿ di mar 'áámá cosa chi n'diichineeⁿ di Señor Ndyuūs yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tuu'mi candɛ́ɛ̄ yááⁿn'guiinūuⁿ miiⁿ Jesús miiⁿ na 'áámá yiīcū yáácú ní ch'iⁿ'i sa tanducuéⁿ'ē naciones yeⁿ'ē iⁿ'yeeⁿdí 'cūū ndúúcū chí ngaⁿ'á ntiiⁿnyuⁿ sa yeⁿ'ē ndúúcū dendú'ū chí n'gɛɛtɛ chi vɛ́ɛ́ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ní caⁿ'a sa chii sa Jesús miiⁿ: Tanducuéⁿ'ē chuū teé dii nduuti chi caantíí'ya dí nanaáⁿ ní cu'téénu di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā saⁿ'ā miiⁿ: Díí yááⁿn'guiinūuⁿ, cuvíi di nanaáⁿ caati 'túúcā canéé nguūⁿ na libro yeⁿ'e Dendyuūs: Cu'téénu di Señor Ndyuūs yeⁿ'ē di ni 'caandiveeⁿ di yeⁿ'e 'iiⁿ'yāⁿ mííⁿ nūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tuu'mi ní yááⁿn'guiinūuⁿ miiⁿ divíi sa yeⁿ'e Jesús, ní níndaā ángeles ní dichíí'vɛ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Taachi ch'iindiveéⁿ Jesús miiⁿ chi Juan chi ngɛɛdinuūⁿnīⁿ 'iiⁿ'yāⁿ canúúⁿ sá vácūū, nanguɛɛcunée yā cunaⁿ'a yā na yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Chiicá yā na yáāⁿ Nazaret ní ndaa yā canee yā na yáāⁿ Capernaum. Yáāⁿ miiⁿ ní niiⁿnuúⁿ na nuūⁿnīⁿ'yáⁿ'ā canee, ní canee na yáⁿ'āa yeⁿ'e Zabulón ndúúcū yáⁿ'āa yeⁿ'e Neftalí. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ní cuuvi cuaacu nduudu yeⁿ'e saⁿ'ā profeta Isaías chí caⁿ'a sa cuááⁿ vmnaaⁿ 'tíícā: ");
INSERT INTO cuxNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ná yáⁿ'āa yeⁿ'ē Zabulón ndúúcū na yáⁿ'āa yeⁿ'e Neftalí chi canéé na yúúní chi ngeⁿ'e ná nuūⁿnīⁿ'yáⁿ'ā ndúúcū na yáⁿ'āa chi canee taama lado yeⁿ'e yíícú chi nguuvi Jordán. Mííⁿ canéé yáⁿ'āa Galilea yeⁿ'e 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'ē ndaata 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","'Iiⁿ'yāⁿ chi snéé na maāiⁿ ti nguɛ́ɛ́ yeⁿ'e Ndyuūs, 'iiⁿ'yāⁿ s'eeⁿ n'diichí yā 'áámá dɛɛvɛ ch'ɛɛtɛ. Ní chiī dɛɛvɛ́ miiⁿ naachi sneé 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ndíí tuu'mi tucá'ā Jesús caⁿ'a yā nduudu cuaacu ní caⁿ'a yā: Ndaacadaamí nī yeⁿ'e nuuⁿndi yeⁿ'é nī caati tiempo chi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi 'āā ndaa niiⁿnuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Cuayiivi ní Jesús miiⁿ cachiicá yā cuaaⁿ 'diituú nuūⁿnīⁿ'yáⁿ'ā chí nguuvi Galilea, ní n'diichí yā na 'uuvī saⁿ'ā 'díínu sa vi'ī. 'Áámá saⁿ'a ní Simón Pedro nguuvi sa. Táámá saⁿ'ā ní 'diinu sa ní Andrés nguuvi sa. Saⁿ'ā s'uuⁿ ní n'gaa nuuⁿ sa yáanā yeⁿ'é 'yaācā miiⁿ na nuūⁿnīⁿ'yáⁿ'ā ti saⁿ'ā s'eeⁿ itungááⁿ sa 'yaācā na nuūⁿnīⁿ'yáⁿ'ā ti ntiiⁿnyuⁿ yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Cuchíi nī nduucú, ni 'úú ní diíⁿ chi in'nuúⁿ nī 'iiⁿ'yāⁿ chi cuuvi caⁿ'á yā nduucú. Ní tan'dúúcā chi tungaáⁿ nī 'yaācā yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā, 'tíícā in'nuúⁿ nī 'iiⁿ'yāⁿ chi caⁿ'á yā nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hora mííⁿ nūuⁿ ní saⁿ'ā s'eeⁿ s'neeⁿ sa yaānā yeⁿ'ē sa ni cueⁿ'e sa ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tuu'mi ní Jesús miiⁿ cueⁿ'e ca yā ní n'diichi yā taama 'uuvi saⁿ'ā chi 'diinu sá vi'ī chí nguuvi sa Jacobo ndúúcū Juan. Ní saⁿ'ā s'uuⁿ ní daiya Zebedeo. Ní snee sa na barco miiⁿ ndúúcū chiida yā Zebedeo miiⁿ ní n'diyaatá yā yáanā yeⁿ'e yā. Jesús 'cai yā Juan ndúúcū Jacobo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tuu'mí nūuⁿ ní saⁿ'ā s'uuⁿ ní s'neeⁿ sa barco miiⁿ ndúúcū chiida sa, ní cueⁿ'e saⁿ'ā s'uuⁿ ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús cachiīcá yā núúⁿmáⁿ ná yáⁿ'āa yeⁿ'e Galilea ní ngi'cueeⁿ yā na yaacū sinagogas na yáāⁿ yeⁿ'ē yáⁿ'āa miiⁿ. Ní caⁿ'á yā nduudu cuaacu yeⁿ'é naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Jesús miiⁿ ní diíⁿ yā chi nduūvā yeⁿ'é 'iiⁿ'yāⁿ yeⁿ'e nducuéⁿ'ē naaⁿ ca'áí ndúúcū 'iiⁿ'yāⁿ yeⁿ'e nducuéⁿ'ē chi ya'ai yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ní nducyáácá 'iiⁿ'yāⁿ yeⁿ'e núúⁿmáⁿ yáāⁿ yeⁿ'e yáⁿ'āa Siria ch'iindiveéⁿ yā yeⁿ'e Jesús miiⁿ. Ní candɛ́ɛ yā 'iiⁿ'yāⁿ chí ya'ai yeⁿ'ē, ndúúcū 'iiⁿ'yāⁿ chi n'deee nááⁿ ca'ai ndii yā, ndúúcū 'iiⁿ'yāⁿ chi canee yā ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ, ndúúcū 'iiⁿ'yāⁿ chí ndistáⁿ'ā vaanicádiīnūuⁿ yeⁿ'ē, ndúúcū 'iiⁿ'yāⁿ ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e yā. Ní Jesús diíⁿ yā chi nducyaaca 'iiⁿ'yāⁿ nduūvā yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Neené 'yaaⁿ 'iiⁿ'yāⁿ cueⁿ'é yā ndúúcū Jesús miiⁿ. 'Iiⁿ'yāⁿ s'eeⁿ ní yeⁿ'e yáⁿ'āa Galilea, ndúúcū distrito yeⁿ'ē Decápolis chi vɛ́ɛ́ ndííchi yáāⁿ yeⁿ'ē, ndúúcū yáāⁿ Jerusalén, ndúúcū yáⁿ'āa yeⁿ'e Judea, ndúúcū yáⁿ'āa chi snéé táámá lado yeⁿ'ē yíícú Jordán. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Taachi Jesús n'diichí yā chi n'deee n'dáí 'iiⁿ'yāⁿ cueⁿ'e yā ndúúcu yā tuu'mi ní Jesús cueⁿ'e yā 'áámá yiīcū. Taachi Jesús miiⁿ ch'iindí yā tuu'mi ní discípulos yeⁿ'e yā ní ndaa yā nanááⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús ní caⁿ'a yā ní ngi'cuéeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Dɛ'ɛ chúúcā n'daí 'iiⁿ'yāⁿ chi deenú yā na staava yeⁿ'é yā chi neⁿ'e deenu cá yā yeⁿ'e Ndyuūs, caati cuuvi yeⁿ'é yā yeⁿ'e naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chi ndaachi 'iinú yā cáávā chi i'téénu yā Ndyuūs maaⁿ, caati cuayiivi ní Ndyuūs ca'á yā 'viich'ɛɛtíinūuⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chi ndiicúuⁿ yā na staava yeⁿ'e yā, ti 'iiⁿ'yāⁿ s'eeⁿ cuuvi ndaācá yā dɛ'ɛ̄ chi cuuvi yeⁿ'e yā chi Ndyuūs caⁿ'a yā chi ca'a yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chí neⁿ'e ca yā diiⁿ yā chi n'daācā tan'dúúcā chi neⁿ'e Ndyuūs. Ní Ndyuūs cúnnee yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chi 'nuūⁿ ndīi ya'ai 'iinú yā cáávā tanáⁿ'ā 'iiⁿ'yāⁿ, caati Ndyuūs 'nuūⁿ ndīī ya'ai 'iinú ntúuⁿ yā cáávā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chi dɛɛvɛ staava yeⁿ'é yā, ti 'iiⁿ'yāⁿ s'eeⁿ ní snaaⁿ yā Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chi diiⁿ yā chi nguɛ́ɛ́ 'caa'vá 'iiⁿ'yāⁿ, ti tanáⁿ'ā 'iiⁿ'yāⁿ caaⁿ'máⁿ yā yeⁿ'é 'iiⁿ'yāⁿ chi daiyá Dendyuūs 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chi n'geenú yā ngii cáávā chi diíⁿ yā chííⁿ chi Ndyuūs neⁿ'é yā, caati vɛ́ɛ́ parte yeⁿ'e yā naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Dɛ'ɛ chúúcā n'dai ndís'tiī taachi 'iiⁿ'yāⁿ diíⁿ yā chi ndís'tiī 'cueenú nī cuuvi cucáávā 'úú, ní taachi 'iiⁿ'yāⁿ taáⁿ yā ndúúcū ndís'tiī ní n'deee n'dáí caaⁿ'máⁿ yā nduudu yaadi yeⁿ'e ndís'tiī cucáávā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cuuvi yeenu taaví nī caati cuuvi ndaācá nī chí ch'ɛɛtɛ yeⁿ'é nī ná va'ai chɛɛti nguuvi. 'Túúcā 'iiⁿ'yāⁿ can'daa yā ndíí cuaaⁿ vmnaaⁿ 'iiⁿ'yāⁿ profetas chi ndɛɛ́ yā nduudu yeⁿ'e Ndyuūs. Ní profetas ch'eenú yā chii. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús caⁿ'a yā: Ndís'tiī, nduuti chi i'téénu nī chi 'úú chí Cristo, tuu'mi ni ndís'tiī, tan'dúúcā yiīmā yeⁿ'ē yáⁿ'āa 'tiicá nī. Nduuti chí yiīmā nguɛ́ɛ́ n'daācā sabor yeⁿ'ē, ¿dɛ'ɛ̄ cuuvi diíⁿ nī? Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ dichíí'vɛ̄ yiīmā miiⁿ. 'Āā taanduu rá chí cungéē 'iiⁿ'yāⁿ na yáⁿ'āa ní n'diivi neeⁿ ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ndís'tiī chi i'téénu nī chi 'úú chí Cristo, tan'dúúcā dɛɛvɛ yeⁿ'e iⁿ'yeeⁿdí 'cūū 'tiicá nī, ti caⁿ'á nī ch'iⁿ'i nī dɛɛvɛ yeⁿ'é Ndyuūs nanááⁿ 'iiⁿ'yāⁿ. 'Áámá yáāⁿ chi canduūu na 'áámá yiīcū nguɛ́ɛ́ cúúví cunuuⁿ n'de'ēī. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ndíí nguɛ́ɛ́ ndúú 'iiⁿ'yāⁿ ra 'cuuⁿ'miⁿ yā 'áámá lámpara ní cu'nuúⁿ yā maaⁿ 'áámá caja; naati cun'duúⁿ yā na 'áámá mesa, ní íícú cuuví dɛɛvɛ yeⁿ'ē nducyaaca 'iiⁿ'yāⁿ chi snée yā chɛɛti va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tan'dúúcā 'áámá lámpara chí ngii ndɛɛvɛ, 'tíícā cuuvi n'daācā vida yeⁿ'é nī nanááⁿ 'iiⁿ'yāⁿ chi snée yā iⁿ'yeeⁿdí 'cūū. Ní 'íícú 'iiⁿ'yāⁿ s'eeⁿ cuuvi snaaⁿ yā ntiiⁿnyuⁿ chí n'daacā chi idiíⁿ nī. Ní 'iiⁿ'yāⁿ s'eeⁿ caaⁿ'máⁿ yā: Dɛ'ɛ chúúcā ch'ɛɛtɛ Ndyuūs chi Chiidá nī, Ndyuūs chi canée yā ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nguɛ́ɛ́ nadicádíínuuⁿ ndís'tiī chi 'úú chi Jesús ní cúchií chi divií ley yeⁿ'e Moisés ndúúcū nduudu yeⁿ'e profetas chi canéé nguūⁿ ndíí cuaaⁿ vmnaaⁿ. 'Úú nguɛ́ɛ́ ndaá chí divií ti ndaá chi dicuaācú yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ti cuaacu nííⁿnyúⁿ ngaⁿ'á ngīi ndís'tiī: Neⁿ'e chi canéé cá nanguuvi ndúúcū iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ cuuvi chó'ōo mar 'áámá punto 'lííⁿ ndíí nguɛ́ɛ́ ndúú mar 'áámá coma yeⁿ'e ndúúdú yeⁿ'e ley, nuuⁿmaⁿ neⁿ'e chi tanducuéⁿ'ē 'āā cuɛ́ɛ́ cuuvi cuaacu taanduvɛɛ chí canéé nguūⁿ na libro yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","'Tíícā 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi nguɛ́ɛ́ diíⁿ yā cumplir 'áámá mandamiento 'lííⁿ ní 'tíícā ngi'cueeⁿ yā 'iiⁿ'yāⁿ chi diíⁿ yā tan'dúúcā maáⁿ yā diiⁿ yā, 'lííⁿ 'lííⁿ cá nūuⁿ cuuvi tuneeⁿ yā naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi nguɛ́ɛ́ tan'dúúcā tanáⁿ'ā 'iiⁿ'yāⁿ. Naati 'iiⁿ'yāⁿ chi n'daāca idiíⁿ yā ní ngi'cueéⁿ yāⁿ 'iiⁿ'yāⁿ táácā chi cuuvi diiⁿ n'daacá yā, 'iiⁿ'yāⁿ miiⁿ cuuvi tuneeⁿ yā dendu'ū chi n'daacā ná va'ai chɛɛti nguuvi naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'Úú ní ngaⁿ'á ngií ndís'tiī: Nduuti chi ndís'tiī nguɛ́ɛ́ n'daācā ca idiíⁿ nī chi cuuvi 'iiⁿ'yāⁿ chi ngi'cueeⁿ ley ndúúcū 'iiⁿ'yāⁿ fariseos, tuu'mi ní ndís'tiī nguɛ́ɛ́ cuuví cundaa nī na va'ai chɛɛti nguuvi naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Maaⁿ ní ch'ííndiveéⁿ nī chí caⁿ'a yā chii yā 'iiⁿ'yāⁿ ndii cuááⁿ vmnaaⁿ chi 'túúcā: Nguɛ́ɛ́ 'caaⁿ'nuⁿ di 'iiⁿ'yāⁿ. Du'u chí 'caāⁿ'nūⁿ 'iiⁿ'yāⁿ vɛ́ɛ́ nuuⁿndi yeⁿ'e yā nguuvi chi Ndyuūs caaⁿ'maⁿ yā yeⁿ'e nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naati 'úú ní ngaⁿ'á ngií ndís'tiī 'tíícā: 'Āā du'ú nūuⁿ chi nduuvi taaⁿ yeⁿ'ē vi'i, vɛ́ɛ́ nuuⁿndi yeⁿ'e yā nguuvi chi Ndyuūs caaⁿ'maⁿ yā yeⁿ'ē nuūⁿndī. 'Āā du'ú nūuⁿ chi caaⁿ'maⁿ cuuvi vi'i 'tíícā: Dɛ'ɛ̄ chúúcā chɛɛchí tiīⁿ di, vɛ́ɛ́ nuuⁿndi yeⁿ'e yā nanááⁿ juez. 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi caaⁿ'maⁿ yā 'tíícā: Dɛ'ɛ̄ chúúcā zonzo dii, caⁿ'á yā na infierno naachi canéé 'áámá nguuchi yaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nduuti chi diiⁿ di tan'dúúcā costumbre yeⁿ'ē di ní ndɛɛ di ofrenda yeⁿ'ē di ní ca'a di Ndyuūs vmnááⁿ nátaī yeⁿ'e yaācū templo, ní hora mííⁿ nūuⁿ ninán'gaacu di chi vi'i di ní vɛ́ɛ́ vaadī 'caa'va yeⁿ'ē di ndúúcu sa; ");
INSERT INTO cuxNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tuu'mi ní cu'neeⁿ di ofrenda yeⁿ'ē di niiⁿnuúⁿ nátai. Ní cueⁿ'e di ntun'dáá n'dai di ndúúcū vi'i di. Cuayiivi ní cuuví nguɛɛcundíi di ní ca'a di ofrenda yeⁿ'ē di nátai. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tun'dáá n'dai di ndúúcū 'āā du'u nūuⁿ 'iiⁿ'yāⁿ chi taaⁿ yeⁿ'e di maāⁿnchɛɛ̄t́̄ɛ́ nūuⁿ taachi canúu di yúúní ndúúcu yā, 'aatiī caⁿ'a yā canguu yā dii nanááⁿ juez. Ní juez mííⁿ nca'a yā dii ta'ā policía. Ní policía miiⁿ ní cu'nuūⁿ sa dii vácūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngīi dii chi nguɛ́ɛ́ nan'daā di vácūū neⁿ'e chí nguɛ́ɛ́ 'cuiinu nadíí'vɛ̄ di tanducuéⁿ'ē chi can'diicu di. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","N'giindiveéⁿ nī chí caⁿ'a 'iiⁿ'yāⁿ yeⁿ'ē nuuⁿndi chi adulterio 'túúcā: Ndís'tiī chi n'giindivaacú nī, nguɛ́ɛ́ in'nuúⁿ nī n'daataá o isaⁿ'ā chi nguɛɛ yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naati 'úú, Jesús ní ngaⁿ'á ngií ndís'tiī 'tíícā: 'Āā du'ú nūuⁿ chí n'giīⁿnyūⁿ ndúúcū 'áámá saⁿ'ā o n'daataá ní neⁿ'e yā cuuvi n'dáí yā ndúúcū vi'ī, 'āā diiⁿ nuuⁿndí yā na staava yeⁿ'e yā tan'dúúcā chi 'āā 'tííca yā ndúúcū vi'i. Ní 'āā diíⁿ yā adulterio. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Chuū ngaⁿ'á: Nduuti chi nduutináaⁿ di lado tá cuaācú di diiⁿ chí diiⁿ di nuuⁿndī, 'caaca di nduutinaaⁿ di ní cun'dáa di. Ti n'dáacā ca chi cuuvi ndai di 'áámá parte yeⁿ'e cuerpo yeⁿ'ē di, nguɛ́ɛ́ ti tanducuéⁿ'ē cuerpo yeⁿ'ē di caⁿ'a na infierno. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndúúti chí ta'ā cuaācú di idiiⁿ chí diiⁿ dí nuuⁿndi, 'caaca di ní cun'dáa di. Ti n'dáácā ca chí cuuvi ndaī 'áámá parte yeⁿ'e cuerpo yeⁿ'ē di, nguɛ́ɛ́ ti núúⁿmáⁿ ch'ɛɛtɛ cuerpo yeⁿ'ē dii caⁿ'a na infierno. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tiempo chi chó'ōo 'iiⁿ'yāⁿ caⁿ'a yā 'túúcā: 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi 'tɛɛchi n'daataá yeⁿ'é yā, canéé chí ca'a yā 'áámá caaca yeⁿ'ē chí 'tɛɛchí vi'i yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naati 'úú ní ngaⁿ'á ngií ndís'tiī 'tíícā: Nduuti chi 'áámá saⁿ'ā chí 'tɛɛchi sá n'daataá yeⁿ'ē sa, nguɛ́ɛ́ cáávā chi vɛ́ɛ́ saⁿ'ā chí n'dai ndúúcu tá, tuu'mi ní diiⁿ sa chi n'daātāa cuuvi adulterio tá. 'Āā du'ú nūuⁿ saⁿ'ā chí 'caandavaacu sá ndúúcū n'daataa chi i'nééⁿ isaⁿ'ā yeⁿ'e ta táⁿ'ā, saⁿ'ā miiⁿ idiiⁿ ntúūⁿ sa nuuⁿndi chi adulterio. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ndís'tiī ní ch'iindiveéⁿ nī chí caⁿ'a yā chii yā 'iiⁿ'yāⁿ tiempo chi 'āā chó'ōo 'tuucā: Nguɛ́ɛ́ caaⁿ'maⁿ nī nduudu, “por Ndyuūs”, cáávā cosa chi cuaacu nííⁿnyúⁿ chí diíⁿ nī ní nguɛ́ɛ́ 'tíícā diiⁿ nī. Taachi caaⁿ'máⁿ nī nduudu, “por Ndyuūs”, diiⁿ cuaacú nī tan'dúúcā chi diíⁿ nī cáávā Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naati 'úú ní ngaⁿ'á ngií ndís'tiī: Nguɛ́ɛ́ caaⁿ'máⁿ nī nduudu, “por Ndyuūs”, yeⁿ'ē mar 'áámá naaⁿ. Ndíí nguɛ́ɛ́ caaⁿ'máⁿ nī nduudu, “cucáávā nanguuvi”, ti miiⁿ canéé trono yeⁿ'e Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ndíí nguɛ́ɛ́ ndúú caaⁿ'máⁿ nī nduudu, “cáávā yáⁿ'āa 'cūū”, ti chííⁿ chi banco 'lííⁿ yeⁿ'ē ca'a Ndyuūs; ndíí nguɛ́ɛ́ ndúú 'áámá nduudu, “cáávā yáāⁿ Jerusalén”, ti chiiⁿ chí yáāⁿ yeⁿ'ē Rey Ndyuūs chí ch'ɛɛtɛ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ndíí nguɛ́ɛ́ ndúú caaⁿ'máⁿ nī nduudu, “cáávā tiíⁿ nī”, ti nguɛ́ɛ́ cúúví diiⁿ nī chi cuuvi cuɛ́ɛ̄ naachi cuáíⁿ mar 'áámá yuūdū tiíⁿ nī. Ní nguɛ́ɛ́ cuuvi diíⁿ nī chi cuuvi cuáíⁿ naachi cuɛ́ɛ̄ mar 'áámá yuūdū tiíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Naati ndís'tiī caaⁿ'máⁿ nī, “'tíícā”, nduuti chi 'tíícā; o nduuti chi nguɛ́ɛ́ 'tíícā, tuu'mi ní caaⁿ'maⁿ nī, “nguɛɛ 'tíícā”, caati nduuti chi caaⁿ'máⁿ nī nduudu, “por Ndyuūs” o cáávā táámá yeⁿ'e chuū, tuu'mí ní nduudu miiⁿ ní nguɛ́ɛ́ n'daācā chi caaⁿ'maⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesús caⁿ'a yā: Ndís'tiī ní ch'iindiveéⁿ nī chí caⁿ'a 'iiⁿ'yāⁿ tiempo chi chó'ōo yeⁿ'e ley chi 'tíícā: Nduuti chi 'áámá 'iiⁿ'yāⁿ tun'dáa yā nduutinaaⁿ taama 'iiⁿ'yāⁿ, 'tiicá ntúūⁿ 'iiⁿ'yāⁿ miiⁿ ní cuuví tun'daá yā nduutináaⁿ 'iiⁿ'yāⁿ chí diiⁿ nduucú yā 'tíícā. Ní 'áámá 'iiⁿ'yāⁿ chí tun'dáa yā 'diiⁿ'yuⁿ táámá 'iiⁿ'yāⁿ, 'tiicá ntúūⁿ cuuví tun'daa yā 'diiⁿ'yuⁿ 'iiⁿ'yāⁿ chi diiⁿ nduucú yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naati 'úú ní ngaⁿ'á ngií ndís'tiī: Nguɛ́ɛ́ 'cuuⁿ'maⁿ nī ndúúcū 'iiⁿ'yāⁿ chi yaādii'yá yā. 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí 'cueⁿ'é yā tiicūnáaⁿ nī ti duuchineéⁿ yā yeⁿ'e nī 'cuuⁿ nī chi diíⁿ yā taama vmnéⁿ'ēe nduuti chi neⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ní nduuti chi 'aama 'iiⁿ'yāⁿ chi in'nuúⁿ yā vaadī 'caa'va ndúúcu nī, ní neⁿ'e yā divíi yā tiinuuⁿ yúudūu yeⁿ'e nī, ca'a ntúuⁿ nī cotón yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ní nduuti chi 'aama 'iiⁿ'yāⁿ chí cuuví yā ndís'tiī chi a fuerza canéé chí cándɛɛ nī chɛ́ɛ́dí yeⁿ'e yā tan'dúúcā 'uūvī kilómetros 'tíícā yaⁿ'ai ca candɛ́ɛ nī yeⁿ'e yā ndii cuūuⁿ kilómetros. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Taachí caaca 'iiⁿ'yāⁿ ndís'tiī 'āā dɛ'ɛ́ nūuⁿ cosa ca'a nī 'iiⁿ'yāⁿ cosa miiⁿ. Nguɛ́ɛ́ nguɛɛcundíi nī cuadáámí nī yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ndís'tiī ní ch'iindiveéⁿ nī chi caⁿ'a 'iiⁿ'yāⁿ tiempo chi 'āā chó'ōo: Dinéⁿ'e di 'iiⁿ'yāⁿ na niiⁿnuúⁿ vaacu dí. Nguɛ́ɛ́ dinéⁿ'e di 'iiⁿ'yāⁿ chí taáⁿ yā ndúúcu di. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naati 'úú ní ngaⁿ'á ngií ndís'tiī: Dinéⁿ'e nī 'iiⁿ'yāⁿ chi taaⁿ yā ndúúcu nī. N'dáácā caaⁿ'maⁿ nī yeⁿ'e 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'dáacā ngaⁿ'a yā yeⁿ'e nī. N'dáacā diíⁿ nī ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ neⁿ'e yā ndís'tiī. Caaⁿ'máⁿngua'á nī yeⁿ'e 'iiⁿ'yāⁿ chi 'cueⁿ'e ndís'tiī ní nguɛ́ɛ́ n'daācā idiíⁿ yā ndúúcu nī ní idiíⁿ yā chi ndís'tiī n'geenú nī ngii. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ní ndís'tiī ní 'cuuⁿ'miⁿ nī 'iiⁿ'yāⁿ s'eeⁿ chi ndís'tiī ní daiya Dendyuūs ndís'tiī. Chiida yú chi cánéé na va'ai chɛɛti nguuvi idiíⁿ yā chí ican'daa 'yáⁿ'ā naachi snéé 'iiⁿ'yāⁿ chí n'dai ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daācā diíⁿ yā. Ní Ndyuūs idiíⁿ yā chí ngeeⁿ cuūvī yeⁿ'é 'iiⁿ'yāⁿ chí n'daācā idiíⁿ yā ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daācā idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ndúúti chi ndís'tiī dinéⁿ'e nī 'iiⁿ'yāⁿ chi neⁿ'e yā ndís'tiī, ¿dɛ́'ɛ̄ premio chi ndaacá nī? ¿'Áá nguɛ́ɛ́ 'tiicá ntúūⁿ idiiⁿ 'iiⁿ'yāⁿ chi cobrador yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nduuti chi ndís'tiī diíⁿ nī saludar dámaāⁿ hermanos yeⁿ'e nī, ¿dɛ'ɛ̄ premio chi ndaacá nī? ¿'Áá nguɛ́ɛ́ 'tiicá ntúūⁿ idiīiⁿ 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'ē ndaata Israel chi nguɛ́ɛ́ i'téénu yā Ndyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","N'daācā n'dai ca diíⁿ ndís'tiī chi diíⁿ nī tan'dúúcā chi diiⁿ Dendyuūs, Chiida yú, chi canéé na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ndís'tiī nguɛ́ɛ́ diíⁿ nī dendu'ū chi n'daācā yeⁿ'e yaācū nanááⁿ 'iiⁿ'yāⁿ caati snaaⁿ yā chí diiⁿ nī chi nadacadiinúúⁿ yā chi ndís'tiī ní n'daāca nī. Nduuti chi 'túúcā idiíⁿ nī, tuu'mi ní Ndyuūs Chiida yú nguɛ́ɛ́ tée yā chi cuuvi yeⁿ'e nī yeⁿ'ē chi diíⁿ nī taachi ndaa nī ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Taachi ndís'tiī ca'a nī ofrenda yeⁿ'e nī, nguɛ́ɛ́ diīⁿ yuudú nī níícú nguɛ́ɛ́ cuuvi cadíínuuⁿ 'iiⁿ'yāⁿ. 'Tíícā idiiⁿ náⁿ'ā 'iiⁿ'yāⁿ chi 'uūvī naaⁿ 'uūvī cheendí yā taachi snée yā na yaācū sinagoga ndúúcū na cuaaⁿ cyúúní. Ní 'íícú 'iiⁿ'yāⁿ ní cuuvi snaaⁿ yā ní caaⁿ'maⁿ yā chi 'iiⁿ'yāⁿ s'eeⁿ ní nn'dai yā. Cuaacu nííⁿnyúⁿ 'úú ngaⁿ'á ngīi ndís'tiī, chi 'iiⁿ'yāⁿ s'eeⁿ ní vɛɛ chi 'āā ndaāca yā yeⁿ'e chi diiⁿ yā na iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Taachi ndís'tiī ní ca'á nī cosas chi inneé nī 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā, nguɛɛ ca'a nī chi tuumícádiinuuⁿ ta'ā 'cueé nī chi diiⁿ tá'ā cuaacú nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'Tíícā ca'a n'de'éí nī cosas miiⁿ yeⁿ'e nī ní 'iiⁿ'yāⁿ nguɛɛ cuuvi snaaⁿ yā; 'íícú Chiida yú chi cánéé ná va'ai chɛɛti nguuvi inaáⁿ yā chi nguɛ́ɛ́ n'diichi 'iiⁿ'yāⁿ s'eeⁿ. Ní Chiida yú tée yā chi cuuvi yeⁿ'e nī nanááⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Taachi ndís'tiī caaⁿ'maⁿngua'á nī, nguɛ́ɛ́ díiⁿ nī tan'dúúcā 'iiⁿ'yāⁿ chí 'uūvī naaⁿ 'uūvī cheendí yā, caati 'iiⁿ'yāⁿ s'eeⁿ inee yiinú yā chi n'gɛɛtíndii yā na yaācū sinagogas ndúúcū cuaaⁿ cyúúní ní 'íícú 'iiⁿ'yāⁿ ní snaaⁿ yā 'iiⁿ'yāⁿ s'eeⁿ. Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi 'iiⁿ'yāⁿ s'eeⁿ ní 'āā vɛ́ɛ́ chí cuuvi yeⁿ'é yā na iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ndís'tiī, taachi caaⁿ'maⁿngua'á nī, cundáa nī na cuarto 'lííⁿ yeⁿ'e va'ai yeⁿ'e nī ní n'gaadí nī cheendi va'āī cuarto 'lííⁿ miiⁿ. Ní caaⁿ'maⁿngua'á nī ndúúcū Chiida yú chí inaaⁿ n'de'ei yā. Ní Chiida yú ntée yā chi cuuvi yeⁿ'e nī nanááⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ní taachi caaⁿ'maⁿngua'á nī, nguɛ́ɛ́ dachííⁿ dachííⁿ caaⁿ'maⁿ nī tan'dúúcā chi diiⁿ náⁿ'ā 'iiⁿ'yāⁿ chi 'uūvī naaⁿ 'uūvī cheendí yā chi nguɛ́ɛ́ i'téénu yā Ndyuūs ní nguɛɛ yeⁿ'e ndaata Israel yā. Ní 'iiⁿ'yāⁿ s'eeⁿ nadicadíínuuⁿ yā chi Ndyuūs caⁿ'á yā 'caandiveéⁿ yā nduudu yeⁿ'é yā ti neené n'deēe nduudu ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nguɛ́ɛ́ diíⁿ nī tan'dúúcā chi idiiⁿ 'iiⁿ'yāⁿ s'eeⁿ ti Chiida yú 'āā déénu yā dendu'ū chi neⁿ'e nī taachi 'āā cuɛ́ɛ́ caaca nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ní taachi ndís'tiī caaⁿ'māⁿngua'á nī, 'túúcā caaⁿ'maⁿngua'á nī: N'diī Chiidá nducyaaca 'nū, n'diī chi caneé nī ná va'ai chɛɛti nguuvi. Dɛ'ɛ chúúcā dɛɛvɛ chi ngúúví nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Canéé chi ndaá tiempo naachi chí ngaⁿ'a ntiiⁿnyuⁿ nī. Cúúví tan'dúúcā chi n'diī neⁿ'e nī tan'dúúcā ná va'ai chɛɛti nguuvi 'tiicá ntúūⁿ na yáⁿ'āa 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tée nī chi cuuví che'é 'nū nguuví 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nadich'ɛɛcú nī nuuⁿndi yeⁿ'e 'nū tan'dúúcā chí nús'uu inadich'ɛɛcú 'nū yeⁿ'e 'iiⁿ'yāⁿ chi nguɛɛ n'daācā diíⁿ yā nduucú 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nguɛ́ɛ́ 'cuáaⁿ nī chi ndaā nanaáⁿ 'nū cosas chi chɛɛchi ca chi diiⁿ chi diíⁿ 'nū nuuⁿndi naati nadanguáⁿ'ai nī nús'uu yeⁿ'é nducuéⁿ'ē chi nguɛɛ n'daācā. Ti yeⁿ'é nī naachi ngaⁿ'a ntiiⁿnyúⁿ nī ndúúcū poder ndúúcū dɛɛvɛ chi n'dáí taavi ca yeⁿ'e nī ndúúcū nducuéⁿ'ē nduuyū cueⁿ'e daāⁿmaⁿ. 'Tíícā cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nduuti chi ndís'tiī nadich'ɛɛcú nī yeⁿ'e 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daācā idiíⁿ yā nduucú nī, tuu'mi ní Chiida yú chi cánéé yā ná va'ai chɛɛti nguuvi nadich'ɛɛcú ntúuⁿ yā yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ndúúti chi ndís'tiī nguɛ́ɛ́ nadich'ɛɛcú nī yeⁿ'e 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daācā idiíⁿ yā ndúúcu nī, 'tiicá ntúūⁿ Chiida yú nguɛ́ɛ́ nadich'ɛɛcú yā nuuⁿndi yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Taachi nguɛ́ɛ́ nga'dííⁿnúⁿ nī caati ngaⁿ'angua'á nī nguɛ́ɛ́ nduuví ndaachií naáⁿ nī tan'dúúcā 'iiⁿ'yāⁿ chi 'uūvī naaⁿ 'uūvī cheendí yā chí neⁿ'é yā chi tanáⁿ'ā 'iiⁿ'yāⁿ snaaⁿ yā. 'Iiⁿ'yāⁿ s'eeⁿ idivíi yā catecai vmnááⁿ yā ní 'cuuⁿ'míⁿ yā tanáⁿ'ā 'iiⁿ'yāⁿ chi nguɛ́ɛ́ nga'diiⁿnúⁿ yā. Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi 'iiⁿ'yāⁿ s'eeⁿ ní 'āā vɛ́ɛ́ chi ndaācā yeⁿ'e yā na iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Naati ndís'tiī, ní taachi nguɛ́ɛ́ nga'diiⁿnúⁿ nī, 'cuiīnī aceite tiíⁿ nī ní nááⁿnú nī naaⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ní nguɛ́ɛ́ 'cuuⁿ'míⁿ nī nanááⁿ 'iiⁿ'yāⁿ chi nguɛ́ɛ́ nge'é nī naati Chiida yú chi cánuuⁿ yā nán'de'ei snaáⁿ yā. Ní Chiida yú chi snáaⁿ yā chííⁿ chí diiⁿ nī taachi cánúúⁿ nī nán'de'ei ní tée yā nanááⁿ 'iiⁿ'yāⁿ dɛ'ɛ̄ chi cuuví yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Caⁿ'a Jesús: Ndís'tiī ní nguɛ́ɛ́ diíⁿ nī chí cuuvi 'cuiica nī ná iⁿ'yeeⁿdí 'cūū naachi vɛ́ɛ́ i'yɛ́ɛvɛ̄ chí di'tuuví tī ndúúcū che'e yáⁿ'āa chi tuuviī ní naachi vɛ́ɛ́ chi duucu ní diduucú sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Naati n'dáácā chí diíⁿ nī chi 'cuūndí yeⁿ'e nī ná va'ai chɛɛti nguuvi naachi nguɛ́ɛ́ vɛ́ɛ́ i'yɛ́ɛvɛ̄ chi di'tuūví tī ndíí nguɛ́ɛ́ ndúú che'e yáⁿ'āa chí tuuviī, ndíí nguɛ́ɛ́ ndúú cuuvi cundaā chi duucu ní diduucú sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Caati naachí canéé vaadī 'cuiica yeⁿ'é nī, miiⁿ canee staava yeⁿ'e nī chi nadicadiinúúⁿ nī yeⁿ'e tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Caⁿ'a Jesús chí chídɛɛvɛ yeⁿ'e cuerpo yeⁿ'e yú chííⁿ chí nduutináaⁿ yú. Ndúúti chi nduutinaáⁿ nī n'daācā, tuu'mi ní núúⁿmáⁿ nchɛɛtɛ cuerpo yeⁿ'e nī ní inaaⁿ chi dɛɛvɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ní nduuti chi nduutinaáⁿ nī nguɛ́ɛ́ n'dai, tuu'mi ní núúⁿmáⁿ nchɛɛtɛ cuerpo yeⁿ'é nī cunéé na maāiⁿ. 'Tíícā nduuti chí dɛɛvɛ chi cánee nduucú nī nguɛ́ɛ́ n'daācā, tuu'mi ní canée nī na maāiⁿ chi díítūu n'dáí. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi dichíí'vɛ yā 'uūvī 'iivi yā caati dinéⁿ'e yā 'aama yā ní nguɛɛ dinéⁿ'e yā taama yā. Ní n'dáacā nadicádíínuuⁿ yā yeⁿ'e 'aama yā ní nguɛ́ɛ́ n'daācā nadicádíínuuⁿ yā yeⁿ'e taama yā. Nguɛ́ɛ́ cuuvi in'nuúⁿ nī vaadī 'cuiica yeⁿ'é nī ní dichíí'vɛ nī 'iivú Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Chuū ngaⁿ'á ngií ndís'tiī: Nguɛ́ɛ́ nadicadíínuuⁿ nī yeⁿ'e vida yeⁿ'e maaⁿ nī, o yeⁿ'ē chi che'é nī, o yeⁿ'ē chi cu'u nī, ndíí nguɛ́ɛ́ ndúú cáávā chí neⁿ'e cuerpo yeⁿ'e nī chi 'cuɛɛtinúu nī. ¿'Áá nguɛ́ɛ́ yaⁿ'ai ca vida yeⁿ'e nī nguɛ́ɛ́ ti chi ngé'e nī? ¿'Áá nguɛɛ yaⁿ'ai ca chíí'vɛ̄ cuerpo yeⁿ'e nī nguɛ́ɛ́ ti catecai nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cuin'diichí nī 'yaada yeⁿ'ē nanguuvi. Nguɛ́ɛ́ ngiinú tī ndaata, ndíí nguɛ́ɛ́ ngii cosecha yeⁿ'e tī, ndíí nguɛ́ɛ́ ndúú ín'guain'daí tī yeⁿ'e tī. Chiida yú chi cánéé ná va'ai chɛɛti nguuvi ngá'a yā chi nge'e tī. ¿'Áá nguɛ́ɛ́ yaⁿ'ai cá chii'vɛ̄ ndís'tiī nguɛ́ɛ́ ti 'yaada? ");
INSERT INTO cuxNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Chɛɛ́ ndís'tiī chí nééné n'dai tiíⁿ nī cúúví iintiineeⁿ nī 'áámá yuūchí yeⁿ'ē chi yaācu nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Dɛ'ɛ̄ cáávā chí ínadicádíínuuⁿ nī yeⁿ'ē catecai nī? Nadacádíínuuⁿ nī yeⁿ'e naāndā cuɛ́ɛ̄ yeⁿ'ē cuɛɛti táácā chí n'giita. Nguɛ́ɛ́ diíⁿ ntiiⁿnyuⁿ ndíí nguɛ́ɛ́ ndúú idin'dáí hilo. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Naati 'úú ní ngaⁿ'á ngií ndís'tiī, chi rey Salomón miiⁿ ní ndúúcū tanducuéⁿ'ē catecaí yā chi n'dɛ́ɛ́vɛ́ n'dai ndii tuunu ngiī 'yáⁿ'ā naati nguɛ́ɛ́ neené n'dɛɛvɛɛ́ tan'dúúcā yeⁿ'e naāndā s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ndúútí chí Ndyuūs idiíⁿ yā cuidado yeⁿ'ē yáatā chi vɛɛ cuɛɛti chí maāⁿ ní canee ní cavyaaⁿ ní nti'ī ní n'nee yaⁿ'ā 'iiⁿ'yāⁿ. ¿'Áá nguɛ́ɛ́ diiⁿ cá Ndyuūs cuidado yeⁿ'e ndís'tiī, 'iiⁿ'yāⁿ chi duū'vīi i'téénu nī Ndyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nguɛ́ɛ́ nadicádíínuuⁿ ndís'tiī, ní caaⁿ'maⁿ nī 'tíícā: ¿Dɛ́'ɛ̄ che'é 'nū? o ¿dɛ'ɛ̄ cu'ú 'nū? o ¿dɛ́'ɛ̄ 'cuɛɛtinúu 'nū? ");
INSERT INTO cuxNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e ndaata Israel in'nuúⁿ yā dendu'ū chi 'túúcā. Chiida yú chi cánéé yā ná va'āī chɛɛti nguuvi déénu yā tanducuéⁿ'ē dendú'ū chi necesidades neⁿ'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Naati ndís'tiī ní canee chi in'nuúⁿ nī vmnááⁿ vmnaaⁿ yeⁿ'é naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ndúúcū vaadī cuaacu yeⁿ'é Ndyuūs, ní 'íícú tanducuéⁿ'ē dendu'ú 'cūū ní ntiineeⁿ yā yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nguɛ́ɛ́ nadicádíínuuⁿ nī yeⁿ'ē cavyaaⁿ caati cavyaaⁿ ní táámá nguuvi ndúúcū yeⁿ'ē, ní 'íícú nguuvi ní 'āā vɛ́ɛ́ nūuⁿ chi vɛ́ɛ́. Dámaāⁿ nadacádíínuuⁿ nī yeⁿ'ē maaⁿnguuvi, 'āā 'tiicá nūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús caⁿ'a yā: Ndís'tiī ní nguɛ́ɛ́ caaⁿ'maⁿ néeⁿ nī yeⁿ'e táámá 'iiⁿ'yāⁿ maaⁿ ní 'íícú Ndyuūs nguɛ́ɛ́ caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Caati ndúúti chí ndís'tiī caaⁿ'maⁿ nī nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ, 'tiicá ntúūⁿ Ndyuūs caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e nī. Nduuti chi n'deee n'dáí caaⁿ'máⁿ nī, 'tiicá ntúūⁿ caaⁿ'máⁿ Dendyuūs yeⁿ'e nī. Nduuti chi duu'ví nūuⁿ, 'tiicá ntúūⁿ Ndyuūs caaⁿ'máⁿ yā yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Dɛ'ɛ̄ cúúvī chi maaⁿ nch'ɛɛtɛ́ nūuⁿ n'gíínu nī nuūⁿndī chi diiⁿ tanáⁿ'ā 'iiⁿ'yāⁿ ní nguɛ́ɛ́ inaaⁿ nī nuuⁿndī ch'ɛɛtɛ chi diíⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Dɛ'ɛ̄ cúúví chí caaⁿ'máⁿ nī 'iiⁿ'yāⁿ yeⁿ'e chi diíⁿ yā chi nguɛɛ n'daācā nduuti chi ndís'tiī diíⁿ nī cosas chi nguɛ́ɛ́ n'daācā? 'Caandivéeⁿ nī. Vɛ́ɛ́ nuuⁿndi yeⁿ'é nī chi ch'ɛɛtɛ chi nguɛ́ɛ́ ndaacadaamí nī yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ndís'tiī 'iiⁿ'yāⁿ 'uūvī naaⁿ 'uuvī cheendi nī. Dííⁿ cā maáⁿ nī ndaacadaamí nī yeⁿ'e nuuⁿndi chi diíⁿ nī ní 'íícú cuuvi caaⁿ'máⁿ nī yeⁿ'e 'iiⁿ'yāⁿ chi canéé chí din'daācá yā ní ndaacadaamí yā yeⁿ'e nuuⁿndi chi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nguɛ́ɛ́ ca'a nī dendu'ū chí yeⁿ'e Ndyuūs 'yaānā s'eeⁿ ti 'yaānā s'eeⁿ cuuvi contra yeⁿ'e nī. Ní caⁿ'á tī che'e tī ndís'tiī chi pedazos cánéé nī. Nguɛ́ɛ́ 'cuíi nī cosas yeⁿ'e nī chi dichíí'vɛ̄ tan'dúúcā perlas nanááⁿ puercos ti cuuvi nanguɛɛcúndii tī ní ca'a ta'á tī ní ndís'tiī canée nī maaⁿ ca'a tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Caⁿ'a Jesús: Caacá nī Ndyuūs, ní Ndyuūs tée yā yeⁿ'e nī. In'nuúⁿ nī ní ndaāca nī. Yaa'ví nī cheendi va'āī ní nan'guaaⁿ yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Caati nducyaaca 'iiⁿ'yāⁿ chí ngiica Ndyuūs ní Ndyuūs ca'a yā yeⁿ'e yā. Ní nducyáácá 'iiⁿ'yāⁿ chí in'nuuⁿ yā, ní inndaaca yā. Ní nducyáácá 'iiⁿ'yāⁿ chí yaa'vi yā cheendi va'āī, ní nan'guaaⁿ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Chɛɛ́ yeⁿ'e ndís'tiī taachi caaca daiya nī 'aama pan, ca'a nī 'áámá tuūu? ");
INSERT INTO cuxNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O nduuti chi caaca daiyá nī 'áámá 'yaācā, ¿'áá ca'á nī 'áámá cúú? ");
INSERT INTO cuxNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nduuti chi ndís'tiī chi cúⁿncheeⁿ nī deenú nī ca'a nī cosa chi n'daācā daiya nī, ndii 'tɛɛ cá Chiida yú chi canée yā na va'ai chɛɛti nguuvi ca'á yā cosas chi n'dáácā n'dai cá 'iiⁿ'yāⁿ chi caaca yā Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Tíícā chi tanducuéⁿ'ē chi neⁿ'é nī chi diíⁿ 'iiⁿ'yāⁿ ndúúcu nī, chuū ntúūⁿ diíⁿ nī ndúúcū 'iiⁿ'yāⁿ. Chuū chi ley yeⁿ'e Moisés ndúúcū chi canéé nguūⁿ yeⁿ'e profetas s'uuⁿ ndíí cuááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Caⁿ'a Jesús: Cundáa nī chééndí va'āī chí 'tuucuú, tí cheendi va'ai ch'ɛɛ̄'nū ndúúcū yúúní ch'ɛɛ̄'nū, chiiⁿ chi candɛ́ɛ̄ 'iiⁿ'yāⁿ chí caⁿ'a yā na infierno. Nééné 'yaaⁿ 'iiⁿ'yāⁿ chí ndaa yā chééndí va'ai chi ch'ɛɛ̄'nū miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Naati chééndí va'āī 'tuucúū miiⁿ ní yúúní cuéēⁿ miiⁿ chi candɛ́ɛ̄ 'iiⁿ'yāⁿ chi caⁿ'a yā na vida cueⁿ'e daāⁿmaⁿ. Ní duu'ví 'iiⁿ'yāⁿ chí nndaāca yā chééndí va'āī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Caⁿ'a Jesús: Diíⁿ nī cuidado ndís'tiī yeⁿ'e 'iiⁿ'yāⁿ profetas chi falsos yā chi ngaⁿ'a yā chi ndɛɛ yā nduudu cuaacu yeⁿ'é Ndyuūs naati nguɛɛ 'tíícā. Taachi nndaa yā nanááⁿ ndís'tiī cuaaⁿ dáámí 'iiⁿ'yāⁿ miiⁿ tan'dúúcā catecai 'iiti cuūchī naati cuááⁿ chɛɛ̄ti yā tan'dúúcā 'yááⁿyāaⁿ ngaātáā chí taaⁿ tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ní yeⁿ'e chi diíⁿ yā tuumicádíínuuⁿ nī yeⁿ'e yā. ¿'Áá cuta'a 'iiⁿ'yāⁿ uvas yeⁿ'e yááⁿ? o ¿'áá cuta'a 'iiⁿ'yāⁿ n'guiidīi yaaⁿ nguuvi yeⁿ'e yááⁿ? Nguɛɛ 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","'Tíícā, nducyaaca yáⁿ'á chi n'dáí, n'daācā ngíí n'gui'i n'dáacā yeⁿ'ē, naati yáⁿ'á chi nguɛ́ɛ́ n'daācā ní nguɛ́ɛ́ n'dai n'gui'i yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Áámá yáⁿ'á chí n'dáacā nguɛ́ɛ́ 'cuūndi n'gui'i chí nguɛ́ɛ́ n'daācā, ndíí nguɛ́ɛ́ ndúú yeⁿ'e chi nguɛ́ɛ́ n'daācā 'cuūndī n'gui'i chi n'daācā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nducyaaca yáⁿ'á chi nguɛ́ɛ́ n'daācā ngií n'gui'i yeⁿ'ē, 'iiⁿ'yāⁿ ní 'cááca yā ní 'cuiī yā na yaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Tiicá ntúūⁿ ndís'tiī tuumicadíínuuⁿ nī yeⁿ'e 'iiⁿ'yāⁿ cáávā cosas chi diíⁿ yā yeⁿ'e chi n'daacā o yeⁿ'e chi nguɛ́ɛ́ n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesús ngaⁿ'a yā 'tíícā: Nguɛ́ɛ́ nducyaaca 'iiⁿ'yāⁿ chi ngaⁿ'á yā yeⁿ'ē 'úú: N'díí Señor, Señor, ní cuuví cundaa yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā, dámaāⁿ 'iiⁿ'yāⁿ chi diíⁿ yā tan'dúúcā chi neⁿ'e Chiidá chi canee yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nééné 'yaaⁿ 'iiⁿ'yāⁿ caaⁿ'maⁿ yā cuuvi yā 'úú nguuví yeⁿ'é juicio N'dií Señor, Señor, ¿'áá nguɛ́ɛ́ caⁿ'a 'nū nduudu cuaacu ndúúcū chi duuchí nī ní tun'dáa 'nū yááⁿn'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ ndúúcū chi duuchí nī? Ní nééné n'deēe vaadī n'gíínú idiíⁿ 'nū ndúúcū chi duuchí nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tuu'mi ní 'úú Cristo caaⁿ'máⁿ cuaacú cuuví 'iiⁿ'yāⁿ s'eeⁿ: 'Úú nguɛ́ɛ́ n'diichí tandií ndís'tiī. Cuvíi nī yeⁿ'ē 'úú, ndís'tiī chi nguɛ́ɛ́ n'daācā diíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ní caⁿ'a ntúūⁿ Jesús: 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi n'giindiveéⁿ yā ndúúdú 'cūū yeⁿ'é níícú idiíⁿ yā chɛɛ chi 'úú ngaⁿ'á, 'iiⁿ'yāⁿ miiⁿ ní tan'dúúcā 'áámá saⁿ'ā chí n'dɛ̄ɛ̄vɛɛ nadicádíínuuⁿ sa. Saⁿ'ā miiⁿ din'dái sa vaacu sá na 'áámá yáává. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Níícú chééⁿ cúúví naⁿ'ā ní ch'iita yíícú. Ní chéenū 'yúúné taaⁿ contra yeⁿ'é va'āī miiⁿ ní nguɛ́ɛ́ chindɛɛvɛ caatí n'daacā chééndii na yáává miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi n'giindiveéⁿ yā nduudú 'cūū yeⁿ'é ní nguɛ́ɛ́ idiíⁿ yā tan'dúúcā chi ngaⁿ'á, 'iiⁿ'yāⁿ miiⁿ ní tan'dúúcā 'aama saⁿ'ā chi nguɛ́ɛ́ n'daācā inadicádíínuuⁿ sa. Saⁿ'ā miiⁿ ní din'dái sa vaacu sa na yáⁿ'āa ndúútīi. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ní cheeⁿ cuuvī naⁿ'ā ní ch'iita yíícú miiⁿ. Ní chéenū 'yúúné taaⁿ contra yeⁿ'é va'āī miiⁿ ní va'āī chidɛɛvɛ ní ntuūvīi. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Taachí Jesús miiⁿ ch'iinu caⁿ'a yā ndúúdú 'cūū, 'iiⁿ'yāⁿ mííⁿ cheⁿ'e yiinú yā yeⁿ'e chííⁿ chí ngi'cueeⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Caati Jesús miiⁿ ngi'cueeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā 'áámá 'iiⁿ'yāⁿ chí déénu o 'áámá 'iiⁿ'yāⁿ chí ngaⁿ'a ntiiⁿnyúⁿ yā nguɛ́ɛ́ tan'dúúcā 'áámá maestro chi ngi'cueeⁿ ley yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Taachí Jesús cuch'eeⁿ yā na 'áámá yiīcū, nééné 'yaaⁿ 'iiⁿ'yāⁿ cueⁿ'é yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","N'diichí nī. Nanááⁿ Jesús ndaā 'áámá saⁿ'ā chi ndíí sa 'áámá ca'ai chi nguuvi lepra chí índuuti yuūtɛ̄ yeⁿ'ē sa. Ní chíntii'ya sa nanáaⁿ yā ní s'teenu sá ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: N'diī Señor, nduuti chi neⁿ'e nī, ní diíⁿ nī chi nduūvā yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús ní n'doó yā ta'á yā ní tuu'ví yā saⁿ'ā miiⁿ ní caⁿ'a yā chii yā saⁿ'ā: 'Úú neⁿ'é. Nduūvā yeⁿ'ē di. Tuu'mí nūuⁿ ndúuvā n'daācā yeⁿ'ē sa ní nduūvī dɛɛvɛ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tuu'mi ní Jesús ní caⁿ'a yā chii yā saⁿ'ā miiⁿ: Cuéⁿ'e di ní 'cuuⁿ'miⁿ dí cuerpo yeⁿ'ē di nanááⁿ chiiduú ní ca'a di ofrenda nanááⁿ Ndyuūs tan'dúúcā chí ngaⁿ'a na ley chi dinguuⁿ Moisés. 'Tíícā ní chiiduú caaⁿ'maⁿ cuaacú yā yeⁿ'ē di nanááⁿ nducyaaca 'iiⁿ'yāⁿ, ní nguɛ́ɛ́ 'cuuⁿ'miⁿ di yeⁿ'ē chí chiī ndúúcu di mar 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Taachí Jesús cáámá ndaa yā na yáāⁿ Capernaum, ndaā 'áámá saⁿ'ā capitán yeⁿ'e ndaata yeⁿ'e 'iiⁿ'yāⁿ romanos nguɛ́ɛ́ yeⁿ'e ndaata Israel. Ní ndaā sa nanááⁿ Jesús miiⁿ ní di'cuíítu sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ní caⁿ'a sa chii sa Jesús: N'dií Señor, mozo yeⁿ'é candíítí sá na cama ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'ē sa. Nééné ya'āī ngiītā sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús caⁿ'a yā chii yā saⁿ'ā: 'Úú ní caⁿ'á ní diíⁿ chí saⁿ'ā ní nduūvā yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Saⁿ'ā capitán nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa chii sa Jesús miiⁿ: N'dií Señor, 'úú nguɛ́ɛ́ neené n'dai 'úú chí cundaa nī chɛ́ɛ́tí va'āī yeⁿ'é. Dámaāⁿ chí caaⁿ'maⁿ núuⁿ nī ní saⁿ'ā mozo yeⁿ'é ndúuvā yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Úú ní saⁿ'ā chí vɛ́ɛ́ saⁿ'ā ndíí tiīiⁿ yeⁿ'é, ní ngaⁿ'ā ntiiⁿnyúⁿ yā yeⁿ'ē 'úú. 'Úú ntúūⁿ ní ngaⁿ'á ntiiⁿnyúⁿ yeⁿ'ē cien soldados chi maaⁿ poder yeⁿ'é. 'Úú ní ngaⁿ'á ngií 'aama sa: Cúnaⁿ'ā di, ní inaⁿ'ā sa. Ní ngaⁿ'á ngií taama sa: Cuchíi di, ní chii sa. Ní ngaⁿ'á ngií mozo chi diiⁿ mandado yeⁿ'é: Diiⁿ di ntiiⁿnyúⁿ 'cūū, ní diiⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Taachi Jesús ch'iindiveéⁿ yā chuū cheⁿ'é yiinú yā. Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ chi ndúúcu yā: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndis'tiī chí 'úú nguɛ́ɛ́ īndaacá 'iiⁿ'yāⁿ chi i'téénu n'dai yā mar 'áámá 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel tan'dúúcā saⁿ'á 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ní ngaⁿ'á ngií ndís'tiī, chi neené 'yaaⁿ yā chi caaca yā cuaaⁿ ná ícan'daa 'yáⁿ'ā ndúúcū cuaaⁿ na ngiiya 'yáⁿ'ā ní 'cuɛ̄ɛtɛ́ yā ná va'ai chɛɛti nguuvi ndúúcū Abraham, ndúúcū Isaac, ndúúcū Jacob. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Naati n'deee n'dáí daiyá 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel chí canéé chi 'cuɛɛtinée yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā ná va'ai chɛɛti nguuví, Ndyuūs tun'dáa yā 'iiⁿ'yāⁿ s'eeⁿ chuva'āī naachí maāiⁿ. Mííⁿ ní cuɛɛcu yā ní che'e 'diiⁿ'yuⁿ yā ti nguɛ́ɛ́ i'téénu yā Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā capitán miiⁿ: Cunaⁿ'ā di. Tan'dúúcā chi i'téénu di chi 'úú idiíⁿ chi nduūvā yeⁿ'e mozo yeⁿ'ē di, 'tíícā cuuví ndúúcū mozo yeⁿ'ē di. Ní hora mííⁿ nūuⁿ nduūvā yeⁿ'e mozo yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Cuayiivi ní ndaā Jesús ná va'ai yeⁿ'ē Pedro miiⁿ ní n'diichí yā chí indáⁿ'ā Pedro miiⁿ candiiti yā na cama. Ndɛɛ̄ 'iīⁿ'nūⁿ taáⁿ táⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús tuu'ví yā ta'ā tá ní 'iiⁿ'nūⁿ mííⁿ ní chivii. Tuu'mi ní táⁿ'ā miiⁿ ní nducueeⁿ tá ní diiⁿ ta mandado yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ ní ca'a ta chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Taachi chi 'da'a nguuvi miiⁿ, tuu'mi ní 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ ndaa yā chi ndɛ́ɛ yā 'yaaⁿ n'dáí 'iiⁿ'yāⁿ nanááⁿ Jesús. Ndɛɛ yā 'iiⁿ'yāⁿ chi snée yā ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ. Jesús caⁿ'a yā 'áámá nduudu nūuⁿ ní tun'dáa yā espíritus yeⁿ'e yááⁿn'guiinuuⁿ yeⁿ'e 'iiⁿ'yāⁿ. Ní diíⁿ yā chi nduuva yeⁿ'ē nducyáácá 'iiⁿ'yāⁿ s'eeⁿ chi ngííta yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","'Tíícā ní cuuví cuaacu chí caⁿ'a saⁿ'ā profeta Isaías ndíí cuaaⁿ vmnaaⁿ taachí caⁿ'a yā 'túúcā: 'Iiⁿ'yāⁿ maáⁿ yā sta'á yā ca'āī yeⁿ'e yú ní candɛ́ɛ yā vaadī ya'ai yeⁿ'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Taachi Jesús n'diichi yā nducyaaca 'iiⁿ'yāⁿ cuaaⁿ 'diitú yā caⁿ'a yā chii yā discípulos yeⁿ'e yā chí cho'ó yā táámá lado yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Áámá saⁿ'ā chi ngi'cueeⁿ ley ndaā sa nanááⁿ Jesús ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: N'dií Maestro, caⁿ'á ndúúcu nī 'āā tií nūuⁿ naachi cáⁿ'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: 'Yuunéēⁿ ní vɛ́ɛ́ yiivi yáává yeⁿ'e tī. 'Yáádá yeⁿ'ē nanguuvi vɛ́ɛ́ 'dɛ́ɛ́cɛ tī naati 'úú chi Saⁿ'ā chi Daiya Dendyuūs nguɛ́ɛ́ va'ai chi vaacú naachi cundiītí tiíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Táámá discípulo yeⁿ'é yā caⁿ'a sá chii sa Jesús: N'dii Señor, vmnááⁿ vmnaaⁿ tée nī lugar 'úú ti caⁿ'á 'cuūchí chiidá ní caⁿ'a yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús ngaⁿ'a yā ngii yā saⁿ'ā: Cuchíi di ndúúcū 'úú. Cu'neeⁿ dí 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu yā chí 'cuuchí yā tináⁿ'ā chi chiida di. Tí 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā tináⁿ'ā 'tííca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús sndaa yā na 'áámá barco ní discípulos yeⁿ'e yā cueⁿ'e yā ndúúcu yā ni sndaa yā na barco miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hora mííⁿ nūuⁿ ní ndaā 'áámá 'yúúné tááⁿ chí olas yeⁿ'e nuūⁿnīⁿ'yáⁿ'a miiⁿ ní ch'ɛɛtɛ cá chí ndaā nuūⁿnīⁿ chɛɛti barco miiⁿ. 'Tɛ́ɛ́ 'tɛ́ɛ́ nūuⁿ nguɛ́ɛ́ cánduūu ná barco. Jesús miiⁿ ní cyaadu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Discípulos yeⁿ'é yā ndaa yā nanááⁿ Jesús ní nanduūchí yā 'iiⁿ'yāⁿ miiⁿ ní ngaⁿ'a yā ngii yā Jesús: N'dii Señor, nadanguáⁿ'ai nī s'uūúⁿ caati 'cuūvi yú. 'Āā 'cuɛɛchi yú cuaaⁿ maaⁿ nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús caⁿ'a yā chii yā discípulos yeⁿ'é yā: ¿Dɛ'ɛ̄ cúúví chí 'va'á ni? Ndís'tiī ní dúú'vīi i'téénu nī. Tuu'mi ní Jesús nducueeⁿ yā ní yaa'vi yā 'yúúné mííⁿ ndúúcū nuūⁿnīⁿ'yáⁿ'ā chí cu'nééⁿ 'diīiⁿ. Ní hora mííⁿ nūuⁿ canee 'diīiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Discípulos ní cheⁿ'e yiinú yā ní caⁿ'a yā nguaaⁿ vi'ī: ¿Du'u sáⁿ'ā chi 'túúcā, ti ndii 'yúúné ndíí nuūⁿnīⁿ'yáⁿ'ā n'giindiveēéⁿ yeⁿ'ē sa? ");
INSERT INTO cuxNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Taachi Jesús ndúúcū discípulos yeⁿ'é yā cho'ó yā nuūⁿnīⁿ'yáⁿ'ā miiⁿ ní ndaá yā niiⁿnuúⁿ na yáⁿ'āa Gadara miiⁿ, snéé na 'uuvi saⁿ'ā chi snéé sa ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ ní nacan'dáa sa na yiivɛ yáává chi nguaaⁿ yáinyāⁿ. Ní nééné taaⁿ sa chi mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ngíí ngo'ó yā yúúní miiⁿ. Saⁿ'ā s'eeⁿ ní ndaa sa nanááⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ní 'cai yiicu sa: N'dii Jesús Daiya Dendyuūs, ¿dɛ́'ɛ̄ canéé yeⁿ'é nī ndúúcū nús'uu? ¿'Áá ndaá nī 'muuⁿ chi di'vaachí nī yeⁿ'ē nús'uu taachi 'āā cuɛ́ɛ́ cúúnú ca'a tiempo taachi Dendyuūs ca'a yā castigo? ");
INSERT INTO cuxNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ní naachi snéé saⁿ'ā s'eeⁿ ní yaⁿ'ai 'tɛ́ɛ́ na 'áámá yiīcū. Ní niiⁿnuúⁿ saⁿ'ā s'eeⁿ snéé 'yaaⁿ n'dáí puercos, chi nge'é tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ní espíritus yeⁿ'e yááⁿn'guiinūuⁿ miiⁿ ní di'cuíítu sa Jesús miiⁿ: N'diī Jesús, ndúúti chi tun'dáa nī nús'uu yeⁿ'e saⁿ'ā s'uuⁿ, 'cuáaⁿ nī chi cundaa 'nū chɛɛti puercos miiⁿya. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús miiⁿ caⁿ'a yā chii yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ: Cuéⁿ'e nī. Tuu'mi ní espíritus yeⁿ'e yááⁿn'guiinūuⁿ cán'daa sa ní cueⁿ'e sa chɛɛti puercos. Cuin'diichí nī. Nducyaaca puercos chéénu tī na yiīcū miiⁿ ní chingéé nuúⁿ tī nguááⁿ nuūⁿnīⁿ'yáⁿ'ā ní ch'íī nuúⁿ tī nguááⁿ nuūⁿnīⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Iiⁿ'yāⁿ chi diiⁿ cuidado puercos miiⁿ cunaⁿ'á yā ngéénu yā na yáāⁿ miiⁿ ní caⁿ'a yā tanducuéⁿ'ē chí chiī tan'dúúcā chí chó'ōo yeⁿ'e 'iiⁿ'yāⁿ chi snéé ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nducyaaca 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ cheⁿ'e yā n'diichi yā Jesús. Taachí ndaa yā naachi canéé Jesús miiⁿ, 'iiⁿ'yāⁿ s'eeⁿ ní di'cuíítu yā Jesús miiⁿ chí cuɛɛvíi yā yeⁿ'ē yáāⁿ vaacú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tuu'mi ní Jesús miiⁿ sndáa yā na barco, ní cueⁿ'é yā táámá lado yeⁿ'ē nuūⁿnīⁿ'yáⁿ'ā ní cueⁿ'e yā ní ndaa yā yáāⁿ vaacú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tuu'mi ní ndaā nanááⁿ Jesús 'iiⁿ'yāⁿ ní ndɛɛ yā 'áámá saⁿ'ā ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa. Candúu sa na 'áámá yiivɛ. Taachí Jesús miiⁿ tuumicadíínuuⁿ yā chi saⁿ'ā s'eeⁿ i'téénu sa yeⁿ'é yā, tuu'mi ní caⁿ'a yā chii yā saⁿ'a miiⁿ: Nduuví tiīnú di daiyá. 'Úú 'āā nadach'ɛɛcú nuuⁿndi yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tuu'mi ní náⁿ'ā saⁿ'ā s'eeⁿ chi ngi'cueeⁿ ley chi snee sa miiⁿ tucá'a sa nadacadíínuuⁿ sa nguaaⁿ maāⁿ sa: Sáⁿ'a 'cūū ní ngaⁿ'a taaⁿ sa contra yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús miiⁿ tuumicádiinuuⁿ yā vaanicadíínūuⁿ yeⁿ'ē sa ní caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: ¿Dɛ'ɛ̄ cuuvi chi nguɛ́ɛ́ n'daācā inadicádíínuuⁿ nī na staava yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Chɛɛ cá chi nguɛ́ɛ́ ngíⁿ'īi chi caaⁿ'máⁿ cuuví sáⁿ'a 'cūū: Nuuⁿndi yeⁿ'ē di nch'ɛɛcū o chi caaⁿ'máⁿ: Ndúcuééⁿ dí ní caaca dí? ");
INSERT INTO cuxNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Tíícā ngaⁿ'á chi ndís'tiī cadíínuuⁿ nī chi Saⁿ'ā chi Daiya Dendyuūs ní vɛ́ɛ́ poder yeⁿ'ē sa na iⁿ'yeeⁿdí 'cūū chi nadach'ɛɛcú sa nuuⁿndi yeⁿ'é 'iiⁿ'yāⁿ. Tuu'mi ní caⁿ'a yā chii yā saⁿ'ā ndúúcū ca'āī chi in'dúuví sá: Nducueeⁿ di ní nta'a di yiivɛ yeⁿ'e di ní cunaⁿ'ā di na vaacu di. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tuu'mi ní saⁿ'ā miiⁿ ní nducuééⁿ sá ní cúnaⁿ'ā sa na vaacu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Taachí 'iiⁿ'yāⁿ s'eeⁿ n'diichí yā chuū cheⁿ'e yiinú yā ní caⁿ'a yā: Dɛ'ɛ chúúcā ch'ɛɛtɛ Dendyuūs chí ca'á yā poder 'cūū saⁿ'ā iⁿ'yeeⁿdí cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús cho'ó yā miiⁿ, ní cachiicá yā ní n'diichí yā 'áámá saⁿ'ā chi nguuví sa Mateo. Mateo miiⁿ ní vɛɛ sa na cuarto naachi nadíí'vɛ̄ 'iiⁿ'yāⁿ yeⁿ'ē yáⁿ'āa yeⁿ'e yā. Jesús caⁿ'a yā chii yā saⁿ'ā: Díí, cuchíi di caⁿ'ā di nduucú. Ní Mateo miiⁿ nducueeⁿ sa ní cueⁿ'e sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Taachí Jesús vɛɛ yā na mesa ná va'āī yeⁿ'e Mateo miiⁿ, hora mííⁿ nééné 'yaaⁿ 'iiⁿ'yāⁿ publicanos chi cobradores chí inn'guɛɛ yā yeⁿ'e impuesto ndúúcū 'iiⁿ'yāⁿ nuūⁿndíī ní ndaa yā ní ch'ɛɛ̄tɛ́ yā na mesa ndúúcū Jesús ndúúcū discípulos yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Taachí 'iiⁿ'yāⁿ fariseos n'diichí yā chuū, caⁿ'a yā chii yā discípulos yeⁿ'e Jesús: ¿Dɛ'ɛ̄ cúúví chí nge'e maestro yeⁿ'e nī ndúúcū saⁿ'ā publicanos chi cobradores chí inn'guɛɛ yā yeⁿ'e impuesto ndúúcū 'iiⁿ'yāⁿ nuūⁿndíī? ");
INSERT INTO cuxNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Taachí Jesús ch'iindiveeⁿ yā chuū, caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ ngiitā nguɛ́ɛ́ neⁿ'e yā 'aama médico, dámaaⁿ 'iiⁿ'yāⁿ chí ngiītā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cueⁿ'e nī ní tuumicádiinuuⁿ nī dɛ'ɛ chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs ndúúcū chí neⁿ'ē caaⁿ'maⁿ chi 'tíícā: 'Úú neⁿ'é chi 'iiⁿ'yāⁿ nduuvi ya'āī 'iinú yā ndúúcū vi'ī. 'Úú ní nguɛ́ɛ́ neⁿ'é chi 'caaⁿ'nuⁿ yā 'iiti ní ca'á yā 'iiti tan'dúúcā ofrenda cucáávā 'úú. Ní 'úú ní nguɛ́ɛ́ cuchīi iⁿ'yeeⁿdí 'cūū chí yaa'ví 'iiⁿ'yāⁿ chi nadacádíínuuⁿ yā chi n'dááca yā ti nguɛ́ɛ́ dinuuⁿndí yā, naati 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā ní 'íícú ndaacadaamí yā yeⁿ'ē nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tuu'mi ní discípulos yeⁿ'e Juan chi chɛɛdínuūⁿniⁿ yā ndaá yā nanááⁿ Jesús miiⁿ ní caⁿ'a yā: N'diī Jesús, ¿dɛ'ɛ̄ cúúví chí nús'uu ndúúcū 'iiⁿ'yāⁿ fariseos nééné n'deee cuūví nguɛ́ɛ́ nga'diiⁿnúⁿ 'nū ní discípulos yeⁿ'e nī nga'dííⁿnúⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá cuuví 'cuɛɛtinéé 'iiⁿ'yāⁿ ndúúcū catecai 'cuáīⁿ tinaⁿ'ā taachí caⁿ'á yā naachi n'giindivaacu 'iiⁿ'yāⁿ neⁿ'e chí saⁿ'ā chi n'giīndīvaacu miiⁿ canéé sá? Naati ndaá nguuvi chí isaⁿ'ā yeⁿ'e yā ní cuavíi sa yeⁿ'é yā ti 'cuūvī sa; tuu'mi ní nguɛɛ ca'diiⁿnúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cúúví cuta'á yā 'áámá tiinūuⁿ ngai chi nguɛ́ɛ́ naaⁿnu yā chi n'dyaatá yā na catecai ndiicúū yeⁿ'e yā. Nduuti chi 'tíícā diíⁿ yā, caātā ndu'ū tiinūuⁿ ndiicúū. Ní cuuvi ch'ɛɛtɛ ca naachí ndíí nteeⁿ tiīnūuⁿ ndiicúū. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ndíí nguɛ́ɛ́ ndúú caaⁿ'yúⁿ 'iiⁿ'yāⁿ vino ngai chɛ́ɛ́tí bolsa yiiⁿmaⁿ ndiicúū tan'dúúcā chí diiⁿ 'iiⁿ'yāⁿ tiempo chi chó'ōo caati yiiⁿmaⁿ ndiicúū miiⁿ ní cúteeⁿ ní vino miiⁿ ní cungéē. Ní cuuvi ndáí yiiⁿmaⁿ. Caaⁿ'yúⁿ yā vino ngai chɛɛti bolsa yiiⁿmaⁿ ngai; ní cuaví'ī nduu 'uūví n'dáacā canéé yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Taachí Jesús miiⁿ ngaⁿ'a yā ndúúdu 'cūū, 'áámá saⁿ'ā chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yáacū sinagoga ndáa sa nanááⁿ Jesús, ní chiintii'ya sá ní chi'teenu sa. Ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: N'diī Jesús, miniiⁿyuⁿ ch'iī daiyá; naati cuchií nī ní cun'duu nī ta'a nī vmnaaⁿ yeⁿ'ē tá ní nnduuchi tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ní Jesús nducueeⁿ yā ní cueⁿ'e yā ndúúcū discípulos yeⁿ'e yā ní ndáa yā ndúúcū saⁿ'ā miiⁿ na vaacu sá. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tuu'mi ní 'áámá n'daataa chi canéé ndúúcū 'áámá ca'ai, chí ican'dáā yuuúⁿ yeⁿ'e cuerpo yeⁿ'ē tá 'āā ndiichúúví nduūyū ndaa niiⁿnuⁿ tá cuaaⁿ dáámí Jesús. Tuū'vi tá naachí ndɛɛtúú yeⁿ'e catecai Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ti taⁿ'ā miiⁿ maāⁿ tá nadicádiinuuⁿ tá 'tíícā: Ndúúti chi 'úú tuū'ví dámaaⁿ catecai yā, tuu'mi ní nduūvā yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tuu'mi ní Jesús nguɛɛcúndii yā ní n'diichi yā táⁿ'ā, ní caⁿ'a yā chii yā táⁿ'ā: Cúúví dítiīnú di, díí daiyá; 'āā nanduuvā yeⁿ'ē di ti i'téénu di 'úú. Hora mííⁿ nūuⁿ táⁿ'ā miiⁿ nánduūvā yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Taachí Jesús miiⁿ sndaa yā na va'ai yeⁿ'ē sáⁿ'ā chi ngaⁿ'a ntiiⁿnyuⁿ yā yeⁿ'e yáacū sinagoga tuu'mi ní n'diichí yā 'iiⁿ'yāⁿ chi i'tiiví yā flauta, ndúúcū 'iiⁿ'yāⁿ chi n'gai yā, ndúúcū 'iiⁿ'yāⁿ chi ngɛɛcú yā ní snéé yā naachi candíítí tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuvíi nī; ti ta'díí miiⁿ nguɛ́ɛ́ n'dii tá, cyaadu tá. 'Iiⁿ'yāⁿ s'eeⁿ ní ch'ííⁿnyuⁿneeⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Taachi tun'dáa yā 'iiⁿ'yāⁿ miiⁿ chɛɛti va'āī, Jesús ndaa yā va'āī ní sta'á yā ta'ā n'daataa 'lííⁿ miiⁿ, ní n'daata 'lííⁿ miiⁿ ní nducueeⁿ tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chuū chí diiⁿ Jesús ní ndōō fama miiⁿ nuuⁿmaⁿ ná yáāⁿ naachí chiī chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Taachi Jesús cho'ó yā yeⁿ'ē miiⁿ, ní 'uuvī saⁿ'ā chi ngueenááⁿ can'dáa sa 'iiⁿ'yāⁿ. 'Cai yiicú sá ní caⁿ'a sa: N'dií Daiya David, cunéé ya'ai 'iinu nī nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Taachi Jesús cueⁿ'é yā ndaa yā na va'ai tuu'mi ní ndaa ndúú 'uūvī saⁿ'ā ngueenááⁿ miiⁿ nanááⁿ Jesús. Jesús caⁿ'a yā chiī yā saⁿ'ā s'eeⁿ: ¿'Áá i'téénu nī chi 'úú cuuvi diíⁿ chi nanduūvā yeⁿ'é nī? Saⁿ'ā s'eeⁿ ní caⁿ'a sa: 'Tíícā Señor. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tuu'mi ní Jesús tuū'ví yā nduutinááⁿ saⁿ'ā s'eeⁿ ní caⁿ'a yā: 'Tíícā cuuví tan'dúúcā chi i'téénu nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nduutinááⁿ saⁿ'ā s'eeⁿ ní n'guaaⁿ ní nduuvā yeⁿ'ē sa. Ní Jesús caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Nguɛ́ɛ́ ca'a nī chi cadíínúuⁿ 'iiⁿ'yāⁿ yeⁿ'e chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Naati saⁿ'ā s'eeⁿ ní cueⁿ'e sa núúⁿmáⁿ ná yáⁿ'āa miiⁿ, ní caⁿ'a sa nducuéⁿ'ē chí Jesús miiⁿ diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Taachi Jesús ndúúcū 'iiⁿ'yāⁿ s'eeⁿ nan'daa yā na va'ai miiⁿ, ndaa saⁿ'ā s'eeⁿ nanááⁿ Jesús ní ndɛ́ɛ sa 'áámá 'díi'mī chi canee sa ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ní taachi Jesús miiⁿ tun'dáa yā espíritu yeⁿ'e yááⁿn'guiinūūⁿ miiⁿ, tuu'mi ní 'díí'mi miiⁿ ní chíí caⁿ'a sa. 'Iiⁿ'yāⁿ ní cheⁿ'e yiinú yā ní caⁿ'a yā: Nguɛ́ɛ́ in'diichí dendu'ū chi 'túúcā nguaaⁿ 'iiⁿ'yāⁿ yeⁿ'e Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Naati 'iiⁿ'yāⁿ fariseos caⁿ'a yā: Saⁿ'ā miiⁿ ní tun'dáa sa espíritu yeⁿ'e yááⁿn'guiinūuⁿ cáávā saⁿ'ā chi ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'e espíritus yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús cachiica yā nuuⁿmáⁿ na yáāⁿ n'gɛɛtɛ ndúúcū yaāⁿ n'gaiyáā, ní ngi'cueeⁿ yā na yáacū sinagogas yeⁿ'e 'iiⁿ'yāⁿ Israel. Ní ngaⁿ'a yā nduudu cuaacu yeⁿ'ē naachí Ndyuūs ngaⁿ'ā ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. Ní diíⁿ yā chi nduūvā yeⁿ'ē nducyaaca 'iiⁿ'yāⁿ yeⁿ'e nducuéⁿ'ē naaⁿ ca'ai yeⁿ'e yā ndúúcū 'iiⁿ'yāⁿ chi ya'ai yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ní taachi Jesús n'diichi yā nducyaaca 'iiⁿ'yāⁿ s'eeⁿ, tuu'mi ní yá'ai 'iinú yā caava 'iiⁿ'yāⁿ s'eeⁿ, ti iiⁿ'yāⁿ s'eeⁿ ndicúúnu yā ni snée yā tan'duucā 'iiti cuūchī chi nguɛ́ɛ́ du'ū chi idiiⁿ cuidado 'iiti. 'Tiicá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā discípulos yeⁿ'e yā: Cuaacu nííⁿnyúⁿ chí ngíí yeⁿ'ē nééné n'deēe chi diiⁿ yú cosechar naati 'iiⁿ'yāⁿ chí idiiⁿ ntiiⁿnyuⁿ nguɛ́ɛ́ 'yaaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Cáávā chuū cáácá nī Ndyuūs chí vɛ́ɛ́ cosecha yeⁿ'e yā chí dicho'ó yā mozos ní nadidáámá yā cosecha yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tuu'mi ní Jesús yaa'ví yā ndu'ū ndiichúúví discípulos yeⁿ'e yā chi ndaa yā nanáaⁿ yā. Ní Jesús miiⁿ ca'a yā poder discípulos chí tun'daá yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ, ní diíⁿ yā chi nduūvā yeⁿ'é 'iiⁿ'yāⁿ chi ngiitā yeⁿ'e nducuéⁿ'ē naaⁿ ca'ai yeⁿ'e yā ndúúcū 'iiⁿ'yāⁿ chi ya'ai yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","'Túúcā duūchi ndu'u ndiichúúví apóstoles; Simón chi nguuvi Pedro ndúúcū Andrés 'díinu sa, Jacobo ndúúcū Juan 'diinū sa chi daiya Zebedeo; ");
INSERT INTO cuxNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ndúúcū Felipe, ndúúcū Bartolomé, ndúúcū Tomás, ndúúcū Mateo chi sáⁿ'a publicano chi cobrador; ndúúcū Jacobo saⁿ'ā daiya Alfeo; ndúúcū Lebeo chi nguuvi Tadeo; ");
INSERT INTO cuxNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ndúúcū Simón yeⁿ'e yáⁿ'āa Caná; ndúúcū Judas Iscariote saⁿ'a miiⁿ chi cuayiivi ch'iⁿ'i sá du'u chí Jesús miiⁿ chi cuuvi 'caaⁿ'núⁿ ya 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús dicho'ó yā ndu'ū ndiichúúví apóstoles ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ taacā chi canee chi diíⁿ yā. Ní Jesús caⁿ'a yā: Nguɛɛ caⁿ'á nī cuaaⁿ yúúní yeⁿ'é 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ndaata yeⁿ'ē Israel chi judíos. Nguɛ́ɛ́ cundaa nī yáāⁿ vaacú 'iiⁿ'yāⁿ Samaritanos. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Naati ndís'tiī ní caⁿ'a nī nanááⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ tí 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā 'íítí cuuchi chi níndái tī na icyáⁿ'ā, 'tííca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ní taachi caⁿ'á nī 'túúcā caaⁿ'maⁿ nī nduudu cuaacu ní caaⁿ'maⁿ nī yeⁿ'ē naachí Dendyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi chí 'āā ndaa niiⁿnuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Diíⁿ nī chi nduūvā yeⁿ'é 'iiⁿ'yāⁿ chi ngíita. Diíⁿ nī chí nduuchi 'iiⁿ'yāⁿ chi n'díí chi tináⁿ'ā. Diíⁿ nī chi nduūvā ní nduuví dɛɛvɛ cuerpo yeⁿ'e 'iiⁿ'yāⁿ chi vɛ́ɛ́ vaadī ya'ai chi nguuvi lepra chi in'duuti yuūtɛ̄ yeⁿ'e yā. Ní diíⁿ nī chí divíi nī espíritus yeⁿ'ē yááⁿn'guiinūuⁿ chi snéé ndúúcū 'iiⁿ'yāⁿ. Ndís'tiī ndaacá nī poder 'cūū yeⁿ'é Dendyuūs, ní nguɛ́ɛ́ cuta'a nī tuumī cáávā chuū. Chuū chi diíⁿ nī ndúúcū 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi cún'di'i yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nguɛ́ɛ́ candɛ́ɛ nī 'dííⁿnguaaⁿ, ndíí nguɛ́ɛ́ ndúú 'dííⁿnguɛɛ, ndíí nguɛ́ɛ́ ndúú tuūmī cheēyé ra. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nguɛ́ɛ́ candɛ́ɛ nī morral yeⁿ'e nī cuaaⁿ cyúúní chi cáⁿ'a nī. Ndíí nguɛ́ɛ́ ndúú 'uūvī ra catecai nī candɛ́ɛ nī. Ndíí nguɛ́ɛ́ ndúú canduu ndaācuú yeⁿ'é nī, ndíí nguɛ́ɛ́ ndúú in'daacuú rá yeⁿ'e nī, ti 'iiⁿ'yāⁿ chi diíⁿ ntiiⁿnyuⁿ, na ntiiⁿnyúⁿ chi diíⁿ yā ní ndaācā chi ché'e yā ndúúcū necesidades chí neⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","'Āā tií nūuⁿ yáāⁿ n'gɛɛtɛ ndúúcu yáāⁿ n'gaiyaá naachí cundáa nī tíínguuneeⁿ nī du'ú 'iiⁿ'yāⁿ yeⁿ'ē yáāⁿ miiⁿ chí n'dai yā ní cunée nī na vaacú yā ndii n'dáá cá nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Taachí ndaá nī na vaacu 'iiⁿ'yāⁿ: Ndaí ndís'tiī, caaⁿ'máⁿ nī, tan'dúúcā costumbre yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ndúúti chi 'iiⁿ'yāⁿ yeⁿ'é va'āī miiⁿ n'dai yā tuu'mi ní vaadī 'diiíⁿ yeⁿ'e nī cunéé ndúúcu yā. Nduuti chi nguɛ́ɛ́ n'dai yā o nguɛ́ɛ́ vaadī 'diiíⁿ ndúúcu yā, nacan'dáa nī va'āī miiⁿ ndúúcū 'áámá nduudu n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nduuti chi 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ 'cuaaⁿ yā ndís'tiī ndíí nguɛ́ɛ́ ndúú 'caandiveeⁿ ra yā nduudu yeⁿ'e nī nan'dáa nī va'ai miiⁿ o yeⁿ'e yáāⁿ miiⁿ ní n'dáádi nī iyaācáa yeⁿ'e ca'á nī ti nguɛ́ɛ́ n'giindiveéⁿ yā yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cuaacu nííⁿnyúⁿ cuaacu nííⁿnyúⁿ ngaⁿ'á ngīi ndís'tiī chi taachi ndaá nguuvi chi Ndyuūs n'diichí yā nuuⁿndi yeⁿ'e yáāⁿ, castigo yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáaⁿ 'cūū cunncáā ca chí cuuví castigo yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Sodoma ndúúcū yáāⁿ Gomorra chi yáāⁿ s'eeⁿ yeⁿ'é 'iiⁿ'yāⁿ chi nguɛ́ɛ́ diíⁿ yā chi n'dai ndíí nguɛ́ɛ́ 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Cun'diichí nī. 'Úú ní dicho'ó ndís'tiī tan'dúúcā chi ndís'tiī ní 'iiti cuūchī náávtaⁿ'ā yeⁿ'ē 'yáaⁿyāaⁿ n'gaātáā, 'tiicá nī. Canéé chí diíⁿ nī chi listo nī tan'dúúcā 'aama cúú. Ní canéé chí din'daacá nī ní canéé manso nī tan'dúúcā 'áámá paloma. 'Tíícā diíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Candɛ́ɛ nī cuidado caati 'iiⁿ'yāⁿ s'eeⁿ ní nca'á yā ndís'tiī nanááⁿ 'iiⁿntyeⁿ'ē yeⁿ'e yaacū sinagoga. Ní cúúví 'cueⁿ'é yā ndís'tiī na yaacū sinagoga miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ní 'iiⁿ'yāⁿ s'eeⁿ candɛ́ɛ yā ndís'tiī nanááⁿ gobernadores ndúúcū nanááⁿ reyes cucáávā 'úú. Ní 'íícú ndís'tiī cuuví caaⁿ'máⁿ nī nduudu cuaacu yeⁿ'ē 'úú nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e ndaata Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ní taachi 'iiⁿ'yāⁿ nca'a yā ndís'tiī nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ, nguɛ́ɛ́ nadicádíínuuⁿ nī yeⁿ'e chi caaⁿ'máⁿ nī ti hora mííⁿ nūuⁿ ní Ndyuūs tée yā nduudu chí caaⁿ'máⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ti nguɛ́ɛ́ ndís'tiī chí caaⁿ'máⁿ nī naati Espíritu N'dai yeⁿ'é Ndyuūs Chiida yú. Espíritu miiⁿ caaⁿ'máⁿ yā cáávā ndís'tiī ti canée yā nduucú nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nguaaⁿ 'díínū sa caⁿ'a sa caaⁿ'maⁿ sa contra yeⁿ'ē ví'ī chi canéé chí 'cuūvī sa. 'Tiicá ntúūⁿ chiidá yā caⁿ'a yā caaⁿ'maⁿ yā contra yeⁿ'ē daiya yā chi canéé chí 'cuūvi yā. 'Tiicá ntúūⁿ daiyá yā ní caⁿ'á yā diiⁿ yā ndúúcū chiidá yā ti ndís'tiī candɛ́ɛ nī nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ní nducyáácá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi n'diichí yā ndís'tiī cucáávā 'úú ti cueⁿ'é nī nduucú. 'Iiⁿ'yāⁿ chi cuchɛ́ɛ yā tanducuéⁿ'ē chuū nducuéⁿ'ē nguuvi yeⁿ'é yā 'iiⁿ'yāⁿ miiⁿ chí nanguaⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Taachí 'iiⁿ'yāⁿ can'daá yā ndís'tiī chí neⁿ'e yā chi ndís'tiī 'cueenú nī cuuvi, na 'áámá yáāⁿ, tuu'mi ní caⁿ'ā nī cáánu nī ná taama yáāⁿ ti cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi Saⁿ'ā chí Daiya Ndyuūs miiⁿ nndaa sá taama vmnéⁿ'ēe vmnaaⁿ chí ndís'tiī cuuvi caaⁿ'maⁿ nī nduudu cuaacu yeⁿ'é nuuⁿmaⁿ na yáⁿ'āa Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mar 'áámá discípulo ní nguɛ́ɛ́ n'gɛɛtɛ ca ntiiⁿnyuⁿ sá chi cuuvi maestro yeⁿ'ē sa, ndíí nguɛ́ɛ́ ndúú mar 'áámá mozo ní ng'ɛɛtɛ ca sa chí cuuvi 'iivi sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","N'dáacā chí discípulo miiⁿ diiⁿ sa tan'dúúcā chi īdiiⁿ maestro yeⁿ'e sa ní mozo miiⁿ diiⁿ sa tan'dúúcā chi diiⁿ 'iivi sa. Ndúúti chi 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e va'ai chi nguuví Beelzebú chi yááⁿn'guiinūuⁿ, tuu'mi ní tanáⁿ'ā 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e familia yeⁿ'e Beelzebú miiⁿ cunncáā caⁿ'a yā caaⁿ'máⁿ yā yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e Beelzebú. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tuu'mi ní ndís'tiī nguɛ́ɛ́ 'va'á nī 'iiⁿ'yāⁿ ti nguɛ́ɛ́ 'áámá chí canúúⁿ n'de'ei chi nguɛ́ɛ́ cuuví snaaⁿ yú, ndíí nguɛ́ɛ́ ndúú canee 'áámá secreto chi 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi cadíínuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Iicu chiiⁿ chi 'úú ngaⁿ'á ngií ndís'tiī yeⁿ'e nduūdū n'de'ei chi nguɛ́ɛ́ ituumicádíínuuⁿ 'iiⁿ'yāⁿ, ndís'tiī caaⁿ'maⁿ nī nduudu chi túúmícádiinuuⁿ 'iiⁿ'yāⁿ. Níícú dɛ'ɛ chí ngaⁿ'á ngií ndís'tiī ní 'cuai nī ndii na yaacū yeⁿ'ē tiiⁿ va'āī ní túúmícádiinuuⁿ 'iiⁿ'yāⁿ nduudú 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nguɛ́ɛ́ 'va'á ni 'iiⁿ'yāⁿ chí 'caāⁿ'nūⁿ cuerpo yeⁿ'e nī ní nguɛ́ɛ́ cuuvi 'caaⁿ'núⁿ yā alma yeⁿ'e nī. Di'va'á ca nī Dendyuūs chí cuuvi 'caaⁿ'núⁿ yā alma yeⁿ'e nī ndúúcū cuerpo yeⁿ'e nī chí caⁿ'á nī na infierno. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿'Áá nguɛ́ɛ́ in'díícui yā na 'uūvī 'yaada cáávā 'aama tuūmī? Mar 'áámá 'yáádá s'ééⁿ nguɛ́ɛ́ 'cuuvá tī na yáⁿ'āa 'cūū núúⁿmáⁿ neⁿ'e chi nguɛ́ɛ́ déenu Ndyuūs Chiida yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Níícú nducyaaca yuudu tiíⁿ nī ní ndii dúúchɛ́ ndúúcū Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nguɛ́ɛ́ di'vá'a ndís'tiī caati ch'ɛɛtɛ cá nī chi cuuvi 'yaaⁿ n'dáí 'yaada. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","'Āā du'ú nūuⁿ chí ngaⁿ'a chi iintiiⁿnaaⁿ 'úú nanááⁿ 'iiⁿ'yāⁿ, 'úú ntúūⁿ ní caāⁿ'máⁿ chi iintiiⁿnaáⁿ 'iiⁿ'yāⁿ s'eeⁿ nanááⁿ Chiidá chi canée yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Āā du'ú nūuⁿ chí caāⁿ'máⁿ chi nguɛ́ɛ́ in'diichi 'úú nanááⁿ 'iiⁿ'yāⁿ, 'úú ntúūⁿ ní caāⁿ'máⁿ chi nguɛ́ɛ́ in'diichí 'iiⁿ'yāⁿ s'eeⁿ nanááⁿ chiidá chi canée yā na va'āī chɛɛti nguuví. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nguɛ́ɛ́ nadicádíínuuⁿ nī chi 'úú, Jesús, ndaá chi ndɛɛ́ vaadī 'diīiⁿ 'iiⁿ'yāⁿ na iⁿ'yeeⁿdí 'cūū. Nguɛ́ɛ́ ndaá chi ndɛɛ́ vaadī 'diīíⁿ caati ndɛɛ́ vaadī 'caa'va ní tan'dúúcā chi candɛɛ́ 'áámá machete chi 'caāiⁿ nduu 'uuvī lados. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tí ndaá chí 'iiⁿ'yāⁿ ní nguɛ́ɛ́ cuuvi n'diichí yā chiidá yā, ní n'daataá nguɛ́ɛ́ cuuvi n'diichi tá chɛɛcu tá, n'daataá nguɛ́ɛ́ cuuvi n'diichi ntúūⁿ tá indáⁿ'a tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Caati 'áámá 'áámá yā ní enemigos yā yeⁿ'e yā ví'i na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","'Iiⁿ'yāⁿ chí neⁿ'e cá yā chiidá yā o chɛɛcu yā nguɛ́ɛ́ ti 'úú, nguɛ́ɛ́ neene n'dai yā chi cuuvi yeⁿ'é 'iiⁿ'yāⁿ. 'Iiⁿ'yāⁿ chí neⁿ'e cá yā daiyá yā saⁿ'ā o daiyá yā n'daataá nguɛ́ɛ́ ti 'úú, nguɛ́ɛ́ neene n'dai yā chi cuuvi yeⁿ'é 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ní 'iiⁿ'yāⁿ chí nguɛ́ɛ́ neⁿ'e yā 'cueenú yā cuuvi cucáávā 'úú chi tan'dúúcā chi cuta'á yā cruz yeⁿ'e yā ní caⁿ'a yā nduucú, nguɛ́ɛ́ neené n'dai yā chi cuuvi yeⁿ'é 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","'Iiⁿ'yāⁿ chi neⁿ'e cá yā vida yeⁿ'e yā cáávā cosas chi vɛ́ɛ́ ná iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ ti 'úú, tuu'mi ní táámá vida ní dindaí yā. 'Iicú 'iiⁿ'yāⁿ chí dindaí yā vida yeⁿ'e yā na iⁿ'yeeⁿdí 'cūū cucáávā 'úú, ti diíⁿ yā chi 'úú neⁿ'é ní ndaacá yā táámá vida yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","'Iiⁿ'yāⁿ chi 'cuaaⁿ yā ndís'tiī, 'cuaaⁿ yā 'úú. 'Iiⁿ'yāⁿ chi n'gúuⁿ yā 'úú, n'gúuⁿ yā 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Iiⁿ'yāⁿ chi n'gúuⁿ yā 'áámá saⁿ'a profeta caati profeta miiⁿ chií yā lado yeⁿ'e Ndyuūs 'iiⁿ'yāⁿ ní cuta'á yā premio chí ndaacā yeⁿ'ē chi tunééⁿ 'iiⁿ'yāⁿ chi profeta. 'Iiⁿ'yāⁿ chí n'gúuⁿ yā 'áámá 'iiⁿ'yāⁿ chí n'dai caati 'iiⁿ'yāⁿ miiⁿ ni n'dai yā, 'iiⁿ'yāⁿ ní cuta'á yā premio chí tunééⁿ 'iiⁿ'yāⁿ chi n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi ca'a 'áámá vaso nuūⁿnīⁿ 'iichɛ 'áámá 'iiⁿ'yāⁿ caati i'téénu yā 'úú, cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi vɛ́ɛ́ premio yeⁿ'e 'iiⁿ'yāⁿ miiⁿ chi cuuvi ndaāca yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Taachí Jesús ch'íínú chii yā ndu'u ndiichúúví discípulos yeⁿ'e yā táácā chí canéé chi diíⁿ yā tuu'mi ní Jesús chiicá yā yáāⁿ miiⁿ ní cueⁿ'é yā na tanáⁿ'ā yáāⁿ s'eeⁿ chí ca'cueeⁿ yā ní caaⁿ'maⁿ yā nduudu cuaacu yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan chí chɛɛdínuūⁿnīⁿ sa 'iiⁿ'yāⁿ canúúⁿ sá vácūū. Ní taachí ch'iindiveeⁿ sá taacā idiiⁿ Jesús miiⁿ, tuu'mi ní dichó'o sa ná 'uuvi discípulos yeⁿ'e sa nanááⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ní 'iiⁿ'yāⁿ s'eeⁿ ndáa yā ní ntiinguuneeⁿ yā Jesús miiⁿ: ¿'Áá n'diī chi Cristo chi canee chí ndaa o cunee ngíínú 'nū taama yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús miiⁿ nán'guɛɛcútaⁿ'a yā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Ndís'tiī cúnaⁿ'a nī ní cuuvi nī Juan miiⁿ yeⁿ'é dendu'ū chí inaaⁿ nī ndúúcū chí n'giindiveeⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Iiⁿ'yāⁿ chi ngueenááⁿ ní inaaⁿ yā, 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii ngiicá ní ngiicá yā, 'iiⁿ'yāⁿ chí ndíí ca'ai lepra chí in'duuti yuūtɛ̄ yeⁿ'e yā ní nduuva dɛɛvɛ yeⁿ'é yā, 'iiⁿ'yāⁿ chi chɛɛtúū ní n'giindiveéⁿ yā, 'iiⁿ'yāⁿ chi n'díí ní nnduuchí yā yeⁿ'e nguaaⁿ tináⁿ'ā, níícú 'iiⁿ'yāⁿ chi ndaachíī snee yā ch'iindiveéⁿ yā nduudu cuaacu yeⁿ'é Ndyuūs chi nadanguáⁿ'ai 'iiⁿ'yāⁿ ti 'iiⁿ'yāⁿ candɛɛ yā nduudu cuaacu miiⁿ nanáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dɛ'ɛ̄ chúúcā n'dai 'iiⁿ'yāⁿ chi nguɛ́ɛ́ cunncáā ch'ɛɛnú yā 'úú ndúúcū nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Taachi cuinaⁿ'a yā 'iiⁿ'yāⁿ s'eeⁿ, Jesús tucá'a yā caⁿ'a yā chii yā 'iiⁿ'yāⁿ yeⁿ'e Juan chí chɛɛdínuūⁿnīⁿ miiⁿ: ¿Dɛ'ɛ̄ cheⁿ'e ndís'tiī n'diichi nī na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ? ¿'Áá 'áámá ndúú chí n'giīdī 'yúúné? ");
INSERT INTO cuxNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O ¿dɛ'ɛ̄ tuu'mi cheⁿ'e nī n'diichí nī? ¿'Áá 'áámá saⁿ'ā chi cánuuⁿ sa catecáí n'dai sa? Cuin'diichí nī. 'Iiⁿ'yāⁿ chi snúuⁿ yā catecai n'dai yā snee yā ná va'ai yeⁿ'ē rey. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tuu'mi ní ¿dɛ́'ɛ̄ cheⁿ'é nī n'diichi nī? ¿'Áá 'aama profeta chi ngaⁿ'a nduudu cuaacu yeⁿ'e Ndyuūs? 'Tíícā nduudu cuaacu. Ní 'úú ní ngaⁿ'á ngīi ndís'tiī 'tíícā. Cheⁿ'é nī n'diichi nī 'áámá 'iiⁿ'yāⁿ chí ch'ɛɛtɛ ca yā chí cuuvi profeta. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Chuū cánéé nguūⁿ yeⁿ'e Juan miiⁿ náⁿ libro yeⁿ'é Ndyuūs ndii cuááⁿ vmnaaⁿ: Cuin'diichí nī. 'Úú ní dicho'ó 'áámá saⁿ'ā chí caaⁿ'maⁿ sa nduudu cuaacu yeⁿ'é nanáaⁿ di. Saⁿ'ā miiⁿ ní nuūⁿ'nūⁿ cuaacú sa yúúní cáávā di. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: Nguááⁿ nducyaaca 'iiⁿ'yāⁿ chi n'giindiyáaⁿ yā yeⁿ'ē n'daataá nguɛ́ɛ́ taama yā chi ch'ɛɛtɛ ca yā ti Juan miiⁿ chí chɛɛdínuūⁿnīⁿ sa. Naati 'iiⁿ'yāⁿ chi ndiicuúⁿ ca yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā ní ch'ɛɛtɛ ca yā nguɛ́ɛ́ ti Juan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Caati ndíí tiempo chi ch'iindiyaāⁿ Juan chi chɛɛdínuūⁿnīⁿ sa ndíí maaⁿ yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā ndúúcū 'iiⁿ'yāⁿ chi yeⁿ'é Ndyuūs ní n'geenu cá yā ngii. Ní 'iiⁿ'yāⁿ chi nguⁿ'u yā contra yeⁿ'e Ndyuūs neⁿ'e yā caaⁿ'maⁿ ntiiⁿnyúⁿ yā yeⁿ'e naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ní nducyaaca 'iiⁿ'yāⁿ profetas ndúúcū ley yeⁿ'e Moisés ngaⁿ'ā nduudu cuaacu yeⁿ'é naachi Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā ndíí tiempo chi ndaā Juan miiⁿ ná iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ndúúti chi ndís'tiī neⁿ'e nī 'caandiveeⁿ nī nduudu yeⁿ'e profetas ndúúcū nduudu yeⁿ'e ley miiⁿ, tuu'mi ní cadíínuuⁿ nī chi Juan miiⁿ ní saⁿ'ā chí profeta Elías dinguuⁿ yā chi canéé chí ndaa sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ndís'tiī chi vɛ́ɛ́ veéⁿ nī 'caandiveeⁿ nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Dɛ'ɛ́ tan'dúúcā 'iiⁿ'yāⁿ chi snéé yā na iⁿ'yeeⁿdí 'cūū maaⁿ? 'Iiⁿ'yāⁿ s'eeⁿ tan'dúúcā saⁿ'ā n'gaiyáā chí n'gɛɛ̄tɛɛ nii'vɛ̄ɛ̄ ní duūchi sa ní n'gai sa compañeros yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ní ngaⁿ'a sa: 'Tiiví 'nū flauta cáávā baile naati nguɛ́ɛ́ inde'éí nī. Ní chiita 'nū canción chi ndaachií tan'dúúcā canciones cáávā tináⁿ'ā naati nguɛ́ɛ́ chɛɛ̄cu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan chi chɛɛdínuūⁿnīⁿ sa ndaā sa. Nguɛ́ɛ́ che'e sa pan, nguɛ́ɛ́ chi'i sa vino ní ndís'tiī ngaⁿ'á nī chí saⁿ'ā miiⁿ ní canee sa ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Úú ní ndaá, 'úú chí Saⁿ'ā chi Daiyá Ndyuūs 'úú. Ní nge'é ní ngi'í. Tuu'mi ní ndís'tiī ngaⁿ'a nī yeⁿ'é: Cuin'dííchí nī. 'Áámá saⁿ'ā chí n'deēe n'dáí nge'e sa ní ngi'i taavi sá vino. Ní ngaⁿ'á nī chi 'úú ní saⁿ'ā chi n'dai ndúúcū 'iiⁿ'yāⁿ publicanos chi cobradores chí inn'guɛɛ yā yeⁿ'e yáⁿ'āa ndúúcū 'iiⁿ'yāⁿ chi dinuuⁿndi yā. Nducyaaca 'iiⁿ'yāⁿ deenu yā chí vaadī deenu miiⁿ ní yeⁿ'é Ndyuūs. Ní 'iiⁿ'yāⁿ ch'iⁿ'í yā vaadī deenu miiⁿ cáávā dendu'ū chi n'daācā chi diíⁿ yā ti yeⁿ'é Ndyuūs 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús tucá'a yā diíⁿ yā regañar 'iiⁿ'yāⁿ s'eeⁿ na yáāⁿ s'eeⁿ naachi diiⁿ yā nééné n'deēe vaadī n'giinu ti 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ 'āā cuɛ́ɛ́ ndaacadaamí yā yeⁿ'ē núúⁿndí yeⁿ'e yā. Ní ngaⁿ'a yā 'tíícā: ");
INSERT INTO cuxNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Dɛ'ɛ̄ chúúcā ya'āī yeⁿ'é ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Corazín. Dɛ'ɛ̄ chúúcā ya'āī yeⁿ'ē ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Betsaida ti ndúúti chi chiī vaadī n'giinu na yáāⁿ Tiro ndúúcū yáāⁿ Sidón tan'dúúcā chí chiī nguaaⁿ ndís'tiī, tuu'mi ní 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa s'eeⁿ 'āā 'naaⁿ tiempo ndaacadaamí yā yeⁿ'e nuuⁿndi yeⁿ'é yā. Ní ch'iⁿ'í yā 'iiⁿ'yāⁿ tan'dúúcā costumbre yeⁿ'é yā chi neené ya'ai yā. Ní ch'ɛɛtinúuⁿ yā catecaí yā yeⁿ'e chi díínūuⁿ ní ch'ɛɛtɛ́ yā nguaaⁿ yaiyáā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Úú ngaⁿ'á ngií ndís'tiī ti nguuvi chí Ndyuūs caaⁿ'máⁿ yā nuuⁿndi yeⁿ'é 'iiⁿ'yāⁿ nguɛ́ɛ́ ya'āī ca 'cueenú yā cuuvi 'iiⁿ'yāⁿ yeⁿ'ē yáⁿ'āa Tiro ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Sidón nguɛ́ɛ́ ti ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Capernaum, ¿'áá cuuvi caⁿ'á nī na va'ai chɛɛti nguuvi? Nguɛ́ɛ́ cuuvi. Caⁿ'á nī infierno ti nguɛ́ɛ́ i'téénu nī nduudu cuaacu yeⁿ'é ndúúcū vaadī n'giinu chi diiⁿ Ndyuūs. Ndúúti chi chiī vaadī n'giinu na yáāⁿ Sodoma tan'dúúcā chí chiī nguaaⁿ ndís'tiī tuu'mi ní 'iiⁿ'yāⁿ yeⁿ'e yáaⁿ 'cūū 'āā i'téénu yā. Ní yáaⁿ 'cūū 'āā canéé ndíí maaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'Úú ngaⁿ'á ngií ndís'tiī ti nguuvi chi Ndyuūs caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ nguɛ́ɛ́ ya'āī ca 'cueenú yā cuuvi 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Sodoma nguɛ́ɛ́ ti ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ní tiempo miiⁿ ní Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'e yā ní caⁿ'a yā: N'diī Chiidá chi 'iiví nī yeⁿ'ē va'ai chɛɛti nguuvi ndúúcū yáⁿ'āa 'cúū, 'úú ca'á gracias n'diī caati snuuⁿ n'dé'ei nī nduudu 'cūū yeⁿ'e 'iiⁿ'yāⁿ chi déénu ca yā ndúúcū 'iiⁿ'yāⁿ chi n'deee n'dáí tuumicádíínuuⁿ yā, ní ca'a nī chí cadíínuuⁿ 'iiⁿ'yāⁿ chi ndiicúuⁿ yā chi nguɛ́ɛ́ n'deee cá déénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Tíícā diíⁿ nī Chiidá ti 'tíícā neⁿ'e nī chi n'daācā diiⁿ nī ti n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: Chiidá ní teé yā 'úú tanducuéⁿ'ē dendu'ū. Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ deenu yā táácā 'áámá n'dyáⁿ'ā Daiya Dendyuūs, dámaāⁿ Chiidá yā. Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ deenu yā táácā Dendyuūs Chiida yú, dámaāⁿ 'áámá n'dyáⁿ'ā Daiyá yā ndúúcū 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi Daiyá Ndyuūs neⁿ'é yā 'cuuⁿ'miⁿ yā Chiida yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cuchíi nī nanáaⁿ 'úú, ndís'tiī, chi vɛ́ɛ́ n'deēe n'dáí cuidado yēⁿ'e nī chi tan'dúúcā 'áámá carga yeⁿ'é nī ní 'úú ní diíⁿ chí ntaavi'tuunúúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ní diíⁿ nī tan'dúúcā chi can'dɛ́ɛ nī yugo yeⁿ'é chi 'tííca. 'Cueeⁿ nī yeⁿ'ē 'úú caati 'úú ní ndiicúūⁿ 'úú ní nééné n'dai staava yeⁿ'é, tuu'mi ní ndaācá nī vaadī ntaavi'tuunúuⁿ yeⁿ'e alma yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Caati yugo yeⁿ'é chí teé ndís'tiī nguɛ́ɛ́ ngiⁿ'īi. Candɛ́ɛ nī chɛɛdí yeⁿ'é ní nguɛ́ɛ́ cuuví n'gii yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Áámá nguuvi sábado chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ Israel, Jesús cueⁿ'e yā ndúúcū discípulos yeⁿ'e yā cuaaⁿ naachí 'iiⁿ'yāⁿ 'āā n̄dííⁿ ntiiⁿnyúⁿ yā ní mííⁿ ní vɛ́ɛ́ trigo. Discípulos yeⁿ'e Jesús miiⁿ chii cuiicú yā ní sta'á yā trigo ní che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Iiⁿ'yāⁿ fariseos n'diichí yā chuū, ní caⁿ'a yā chii yā Jesús miiⁿ: Cuin'diichí nī, discípulos yeⁿ'e nī ní nguɛ́ɛ́ diíⁿ yā tan'dúúcā chí ngaⁿ'a ley yeⁿ'e nguuvi chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá nguɛ́ɛ́ n'geeⁿ nī táácā diīiⁿ David miiⁿ ndúúcū 'iiⁿ'yāⁿ chi cueⁿ'e ndúúcu sa taachi chii cuiicú yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David miiⁿ sndáa yā ná yáacū yeⁿ'e Ndyuūs ní sta'á yā pan chi canéé na mesa yeⁿ'ē nátai. Ní che'é yā ní ca'a yā chi che'e 'iiⁿ'yāⁿ chi nduucú yā. Pan miiⁿ dámaāⁿ chiiduú s'eeⁿ cuuvi che'é yā. Ní tan'dúúcā chí ngaⁿ'a na ley miiⁿ nguɛ́ɛ́ canéé chí che'e rey David ní nguɛ́ɛ́ cánéé chí che'é 'iiⁿ'yāⁿ chi ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿'Áá nguɛ́ɛ́ n'geeⁿ ndís'tiī na ley yeⁿ'e Moisés chi diīiⁿ chííduú s'eeⁿ? Nguɛ́ɛ́ ntaavi'tuunúúⁿ yā yeⁿ'e ntiiⁿnyuⁿ yeⁿ'e yaācū tíínūuⁿ nguuvi chi ntaavi'tuunúuⁿ 'iiⁿ'yāⁿ. Chiidu s'eeⁿ nguɛ́ɛ́ diíⁿ yā tan'dúúcā chí ngaⁿ'a ley yeⁿ'e Moisés ní nguɛ́ɛ́ nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'Úú ngaⁿ'á ngīi ndís'tiī chi vɛ́ɛ́ 'áámá 'iiⁿ'yāⁿ chi ch'ɛɛtɛ ca yā chi yaācū templo ní canee yā ndúúcū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ndís'tiī nguɛ́ɛ́ déénu nī dɛ'ɛ chi neⁿ'e caaⁿ'maⁿ chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs yeⁿ'e chuū: Neⁿ'é chi 'iiⁿ'yāⁿ ya'āī 'iinú yā 'iiⁿ'yāⁿ caavā 'úú. Nguɛ́ɛ́ neⁿ'é chi 'caaⁿ'nuⁿ yā 'iiti ní tée yā 'iiti caavā ofrenda yeⁿ'ē 'úú. Nduuti chí cadíínuuⁿ nī tuu'mi ní nguɛ́ɛ́ diíⁿ nī condenar 'iiⁿ'yāⁿ chi nguɛ́ɛ́ nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Tíícā Saⁿ'ā chi Daīyá Dendyuūs miiⁿ vɛ́ɛ́ ntúūⁿ poder yeⁿ'e sa yeⁿ'e nguuvi chí ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cuayiivi ní Jesús cheⁿ'e yā na yáacū sinagoga yeⁿ'é 'iiⁿ'yāⁿ yeⁿ'e yaāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Cuin'diichí nī. Miiⁿ ní canéé 'áámá saⁿ'ā chi ntí'i ta'ā sa. Snéé 'iiⁿ'yāⁿ miiⁿ chi tiinguunéeⁿ yā Jesús miiⁿ ní caⁿ'a yā: ¿'Áá canéé na ley yeⁿ'e yú chí nduuvā yeⁿ'é 'iiⁿ'yāⁿ nguuvi chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ? Chuū ní caⁿ'a yā ti neⁿ'é yā cuuvi caaⁿ'maⁿ yā núúⁿndí yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dú'u 'aama saⁿ'ā nguaaⁿ ndís'tiī chi vɛ́ɛ́ 'áámá 'iiti cuūchī yeⁿ'ē sa? Ní ndúúti chi cun'daa nuúⁿ tī na 'áámá yiivi yáⁿ'āa nguuvi chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ, ¿'áá nguɛ́ɛ́ ntuun'dáa sa 'iiti nguuvi miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿'Áá nguɛ́ɛ́ yaⁿ'ai ca chiī'vɛ̄ 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ti 'áámá 'iiti cuūchī? 'Tíícā diiⁿ yú chí n'daācā nguuvi chí ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tuu'mi ní Jesús caⁿ'a yā chii yā saⁿ'ā chí ya'āī yeⁿ'ē sa: N'doo dí ta'a di. Saⁿ'ā miiⁿ ní n'doō sá ta'ā sa ní ta'ā sa nduūvī n'dáácā tan'dúúcā taama. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'Iiⁿ'yāⁿ fariseos nan'dáa yā chɛɛti yaācū ní nduuvidaamá yā chí caⁿ'a yā contra yeⁿ'e Jesús miiⁿ ti neⁿ'é yā 'caaⁿ'núⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Taachí Jesús chicadíínuuⁿ yā chuū nan'daa yā miiⁿ. Neené 'yaaⁿ 'iiⁿ'yāⁿ cueⁿ'e yā ndúúcū Jesús miiⁿ ní Jesús miiⁿ idiíⁿ yā chi nduūvā yeⁿ'e nducyáácá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ caaⁿ'maⁿ yā cuuví yā tanáⁿ'ā 'iiⁿ'yāⁿ du'u yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ní 'iicu cuaacu chí profeta Isaías miiⁿ caⁿ'a yā ndii cuááⁿ vmnaaⁿ taachí dinguuⁿ yā 'tíícā. Ndyuūs ngaⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sáⁿ'a 'cūū ni idichíí'vɛ̄ 'úú. 'Úú chínndɛɛ̄vɛ́ saⁿ'á 'cūū chi neⁿ'é ní neene yeenú ndúúcu sa. 'Úú ní cu'neéⁿ Espíritu N'dai yeⁿ'é vmnááⁿ yeⁿ'e sa. Saⁿ'á 'cūū caaⁿ'maⁿ sa yeⁿ'e ley yeⁿ'é nanááⁿ nducyáácá naciónes na iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nguɛ́ɛ́ 'cuuⁿ'maⁿ sa ndíí nguɛ́ɛ́ ndúú 'cuāi ra sa. Mar 'áámá 'iiⁿ'yāⁿ na yúúní nguɛ́ɛ́ 'caandiveéⁿ yā nduudú yeⁿ'e sa ti nguɛ́ɛ́ caaⁿ'maⁿ yúúdu sa cuaaⁿ na yúúní. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Saⁿ'á 'cūū nginnee sa 'iiⁿ'yāⁿ chi vɛ́ɛ́ ca cuidados yeⁿ'e yā, 'iiⁿ'yāⁿ chi tan'dúúcā 'áámá taaⁿ ndúú chí 'aa ndɛɛ̄tuú 'tɛɛ 'tɛ́ɛ́, 'tiicá yā. Ndíí nguɛ́ɛ́ ndúú chí ntuūvi sa 'aama mecha yeⁿ'e quinque chí ican'dáā ca 'yaāⁿ'míⁿ yeⁿ'e. Ndíí nguɛ́ɛ́ candɛ́ɛ sa nduudu cuaacu yeⁿ'é Ndyuūs ndii taachi a fuerza 'āā cuɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi cuchɛɛ sa ndúúcū vaadī cuaacu miiⁿ yeⁿ'e tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ní 'íícú nducyáácá 'iiⁿ'yāⁿ yeⁿ'e naciones yeⁿ'e iⁿ'yeeⁿdí 'cūū cūnee ngíínú yā yeⁿ'e saⁿ'á 'cūū chi cu'téénu yā yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tuu'mi ní 'iiⁿ'yāⁿ ndaa yā nanááⁿ Jesús ní ndɛ́ɛ yā 'áámá saⁿ'ā chi canee sa ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'ē chi ngueenáaⁿ sa ndúúcū chi nguɛ́ɛ́ ngii ngaⁿ'a sa. Jesús miiⁿ diíⁿ yā chi nduūvā yeⁿ'ē sa. Ní saⁿ'ā chi ngueenáaⁿ miiⁿ ní inaaⁿ sa ní ngíí ngaⁿ'ā sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nducyaaca 'iiⁿ'yāⁿ ngeⁿ'e yiinú yā ní ngaⁿ'a yā: ¿'Áá sáⁿ'a 'cūū Daiya 'iiⁿ'yāⁿ chí ndaataá yeⁿ'ē David? ");
INSERT INTO cuxNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ní taachi 'iiⁿ'yāⁿ fariseos ch'iindiveéⁿ yā chuū ní caⁿ'a yā: Sáⁿ'a 'cūū nitun'dáa sa espíritu yeⁿ'e yááⁿn'guiinūuⁿ cáávā Beelzebú, chí Satanás chí ngaⁿ'ā ntiiⁿnyuⁿ sa yeⁿ'e espíritus yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús miiⁿ déénu yā chi nadacadíínūuⁿ 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Áámá gobierno chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yáⁿ'āa chi vɛ́ɛ́ 'uūvī partido yā chí nguⁿ'u yā 'áámá yā ndúúcū taama yā, tuu'mi ní nguɛɛ cuuvi 'naaⁿ chi 'iiⁿntyéⁿ'e yā. Ní nducuéⁿ'ē yáⁿ'āa o va'ai naachi 'iiⁿ'yāⁿ vɛ́ɛ́ 'uūvī vaanīcadíínūuⁿ yeⁿ'e yā nguɛ́ɛ́ cuuvi nduuvidaamá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","'Tiicá ntúūⁿ nduuti chi yááⁿn'guiinūuⁿ tun'dáa sa espíritus yeⁿ'e yááⁿn'guiinūuⁿ vɛ́ɛ́ 'uūvī vaanicádiinūuⁿ yeⁿ'ē sa ní cuáácú chi nguⁿ'u sa yeⁿ'ē maaⁿ sa ní vɛ́ɛ́ 'uūvī partido yeⁿ'e sa ní 'cuiinu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ndís'tiī ní ngaⁿ'a nī chi 'úú itun'daá espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ ndúúcū poder yeⁿ'e Beelzebú chi Satanás chí ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'e espíritus yeⁿ'e yááⁿn'guiinūuⁿ. Ndúúti chi 'tíícā tuu'mi ní, ¿ndúúcū du'ū rá poder yeⁿ'ē tun'daá 'iiⁿ'yāⁿ chi ndúúcu nī espíritu yeⁿ'e yááⁿn'guiinūuⁿ? Chííⁿ chí diiⁿ 'iiⁿ'yāⁿ chi ndúúcu nī n'giⁿ'i yā chi nguɛ́ɛ́ 'tíícā chi ngaⁿ'á nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ndúúti chi 'úú itun'daá espíritus yeⁿ'e yááⁿn'guiinūuⁿ cáávā poder yeⁿ'e Espíritu N'dai yeⁿ'e Dendyuūs, cuaacu nííⁿnyúⁿ naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ndaā nanááⁿ ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mar 'áámá 'iiⁿ'yāⁿ nguɛɛ cuuví cundaa yā va'ai yeⁿ'e 'aama saⁿ'ā chi vɛ́ɛ́ fuerzas yeⁿ'e sa ní divíi yā chi vɛɛ yeⁿ'e sa. ¿Canéé chí cachiichí yā saⁿ'a vmnááⁿ vmnaaⁿ? Cuayiivi ní cuuví diíⁿ yā tun'dáa yā dendu'ū chi snúūⁿ va'ai yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ canée yā lado yeⁿ'é, 'iiⁿ'yāⁿ miiⁿ canée yā contra yeⁿ'é. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ dáámá diíⁿ yā cosechar nduucú, tuu'mi ní diíⁿ yā tan'dúúcā chi ingée tanducuéⁿ'ē cosecha. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Chííⁿ chí nduudu cuaacu chí 'úú ngaⁿ'á ngií ndís'tiī: Tanducuéⁿ'ē nuuⁿndi chí diíⁿ 'iiⁿ'yāⁿ ndúúcū nduudu taaⁿ chí nguɛ́ɛ́ n'dáacā chí ngaⁿ'a yā contra yeⁿ'e Ndyuūs, Ndyuūs nadach'ɛɛcú yā yeⁿ'e yā. Naati 'iiⁿ'yāⁿ chi ngaⁿ'a yā nduudu taaⁿ chí nguɛ́ɛ́ n'dáacā chi contra yeⁿ'e Espíritu N'dai yeⁿ'e Ndyuūs ní nguɛ́ɛ́ nch'ɛɛ̄cū yēⁿ'e yā maaⁿ ní tiempo chi cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Āā du'ú nūuⁿ chí caaⁿ'maⁿ nduudu chí nguɛ́ɛ́ n'dáacā contra yeⁿ'e Saⁿ'ā chi Daiyá Ndyuūs ní cuuvi nach'ɛɛcu yeⁿ'e yā. Naati 'iiⁿ'yāⁿ chí nguɛ́ɛ́ n'daācā ngaⁿ'a yā contra yeⁿ'e Espíritu N'dai yeⁿ'e Ndyuūs ní nguɛ́ɛ́ cuuvi nach'ɛɛ̄cū yeⁿ'e yā ndíí nguɛ́ɛ́ ndúú na iⁿ'yeeⁿdí 'cūū ndíí nguɛ́ɛ́ ndúú táámá iⁿ'yeeⁿdi chí cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","'Tiicá ntúūⁿ caⁿ'a Jesús: Ndúúti chi vɛ́ɛ́ 'áámá yáⁿ'á chi n'dáacā yeⁿ'é nī tuu'mi ní cuuvi n'gui'i n'dáacā yeⁿ'ē. Níícú ndúutī chi vɛ́ɛ́ 'áámá yáⁿ'á chí nguɛ́ɛ́ n'daācā yeⁿ'é nī nguɛɛ n'dáacā cuuvi n'gui'i yeⁿ'ē. Cáávā n'gui'i yeⁿ'e yáⁿ'á ituumicadíínuuⁿ yā táácā yáⁿ'á nduuti chí n'dai o nduuti chí nguɛ́ɛ́ n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ndís'tiī, tan'dúúcā ndaata yeⁿ'ē cúú 'tiicá nī. ¿Táácā ngaⁿ'a nī cosas chi n'daācā ní idiíⁿ nī chi nguɛɛ n'daācā? Ti chííⁿ chi ngaⁿ'a nī ndúúcū cheendí nī ngiica na staava yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Saⁿ'ā chi n'dáí idiiⁿ sa dendú'ū chi n'daācā chi nadacadíínuuⁿ sa na staava yeⁿ'e sa chi n'daācā. Saⁿ'a chi cunncáā idiiⁿ sa tanducuéⁿ'ē chi nguɛɛ n'daācā nadacadíínuuⁿ sa caati staava yeⁿ'e sa nguɛ́ɛ́ n'dáacā. Nduudu chi ngaⁿ'ā sa ngiica sa yeⁿ'ē chi ndiituú na staava yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naati 'úú ní ngaⁿ'á ngií ndís'tiī: Nducuéⁿ'ē nduudu chi nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chíí'vɛ̄ chi 'iiⁿ'yāⁿ ngaⁿ'a yā, nducyááca yā ní cánéé chí nca'á yā cuenta yeⁿ'e nduudu chi nguɛɛ n'daācā chi caⁿ'a yā nguuvi chí Ndyuūs caaⁿ'maⁿ yā yeⁿ'e nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ti cáávā nduudu yeⁿ'e nī chi n'daācā nduuví n'dai nī ní 'iicu cáávā nduudu yeⁿ'é nī nduuti chi nguɛ́ɛ́ n'dáacā cuuví nī castigo. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tuu'mi ní n'duuvi maestros yeⁿ'e ley ndúúcū n'duuvi saⁿ'ā fariseos ngaⁿ'a sá ngii sa Jesús miiⁿ ní caⁿ'a sa: N'dií maestro, néⁿ'e 'nū snaaⁿ 'nū 'áámá señal chi diíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús nán'guɛɛcútaⁿ'a yā yeⁿ'e saⁿ'ā s'eeⁿ ní caⁿ'a yā: 'Iiⁿ'yāⁿ cunncáā ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu yā Ndyuūs neⁿ'e yā snaaⁿ yā señal naati señal nguɛ́ɛ́ snaaⁿ yā. Dámaaⁿ snaaⁿ yā señal yeⁿ'e profeta Jonás chi ndíí cuaaⁿ vmnaaⁿ canee nguūⁿ na libro yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ti tan'dúúcā Jonás canúúⁿ sá chɛɛti 'yaācā ch'ɛɛtɛ 'iīnū nguuvi 'iīnū n'gaaⁿ 'tíícā canee chí cūnee Saⁿ'ā chi Daiyá Ndyuūs mááⁿ yáⁿ'āa 'cúū 'iīnū nguuvi 'iīnū n'gaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na nguuvi yeⁿ'e juicio 'iiⁿ'yāⁿ chí ch'ɛɛtinée yā na yáāⁿ chi nguuvi Nínive nducuéeⁿ yā contra yeⁿ'e 'iiⁿ'yāⁿ chi snéé maaⁿnguuvi taachí Ndyuūs caaⁿ'máⁿ yā yeⁿ'ē nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ, ní cuuví yā condenado. 'Tíícā tí 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Nínive ní ndaacadaamí yā taachi profeta Jonás miiⁿ ndii cuááⁿ vmnaaⁿ caⁿ'a sá nduudu cuaacu yeⁿ'e Ndyuūs. Cuin'diichí nī 'áámá saⁿ'ā chi ch'ɛɛtɛ ca nguɛ́ɛ́ tí profeta Jonás miiⁿ canee sa 'muuⁿ na lugar 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Tiicá ntúūⁿ nguuvi yeⁿ'e juicio n'daataá reina chí tiempo chi chó'ōo ngaⁿ'ā ntiiⁿnyuⁿ tá yeⁿ'e lado yeⁿ'e Sur caⁿ'a tá nducueeⁿ tá contra yeⁿ'e 'iiⁿ'yāⁿ chi snée yā maaⁿnguuvi taachi Ndyuūs caāⁿ'máⁿ yā nuuⁿndi yeⁿ'é 'iiⁿ'yāⁿ. Ní táⁿ'ā miiⁿ ní diīⁿ tá condenar 'iiⁿ'yāⁿ chi snée yā maaⁿnguuvi ti táⁿ'ā miiⁿ ndaā tá ndíí na yaⁿ'ai taaví yeⁿ'ē yáⁿ'āa. Ní ngiica tá ní ch'iindiveeⁿ tá yeⁿ'ē vaadī deenu yeⁿ'e rey Salomón. Cuin'dííchí nī 'áámá saⁿ'ā chi ch'ɛɛtɛ ca vaadī deenu yeⁿ'e sa canee sa 'muuⁿ nguɛ́ɛ́ ti Salomón miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Caⁿ'a Jesús: Taachí espíritu yeⁿ'e yááⁿn'guiinūuⁿ nacan'daa na 'áámá saⁿ'ā cachiica na yáⁿ'āa cuūⁿmáⁿ naachi nguɛɛ ch'ɛɛtinéé 'iiⁿ'yāⁿ ní n'nuūuⁿ naachi cuuvi ntaavi'tuunúuⁿ ní nguɛ́ɛ́ ndaācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tuu'mi ní espíritu yeⁿ'e yááⁿn'guiinūuⁿ ngaⁿ'a: Nanguɛɛcuneeé na vaacú naachi chiīcá. Taachí nguɛɛ̄cūnéee ní ndaā na vaacu miiⁿ ndaācā saⁿ'a miiⁿ ní tan'dúúcā 'aama va'āī chi n'dai ní nduuvi dɛɛvɛ́ ndúúcū nducuéⁿ'e na lugar yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tuu'mi ní espíritu miiⁿ cueⁿ'e ní in'nuuⁿ tá ná ndɛɛ̄chɛ̄ espíritus chi cunncáā ca chí cuuví maāaⁿ. Ní ndaā espíritu miiⁿ ndúúcū ndɛ̄ɛchɛ̄ espíritus ní ch'ɛɛtinée na saⁿ'ā miiⁿ. Cuayiivi ní n'geenu sa ngiī taavi ca ní cunncáā ca canee sa nguɛ́ɛ́ ti vmnaaⁿ. 'Tiicá ntúūⁿ 'cueenú yā cuuvi 'iiⁿ'yāⁿ chi snée yā maaⁿ ti nguɛɛ n'dáacā idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Taachí Jesús miiⁿ índeé yā ndúúcū 'iiⁿ'yāⁿ, tuu'mi ní ndaā niiⁿnuúⁿ chɛɛcú yā ndúúcū 'díínu yā ní snée yā chuva'āī. Ní neⁿ'e yā ndeé yā ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Áámá 'iiⁿ'yāⁿ caⁿ'a yā chii yā Jesús miiⁿ: N'diī Jesús, cuin'dííchí nī. Chɛɛcú nī ndúúcū 'díinu nī snée yā chuva'āī ní neⁿ'e yā ndee yā ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā saⁿ'a miiⁿ: ¿Dú'ū chí chɛɛ̄cú miiⁿ? o ¿dú'ū chí 'diinú miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ní n'doó yā ta'á yā naachi snéé discípulos ní caⁿ'a yā: Cuin'diichí nī, 'iiⁿ'yāⁿ s'ūuⁿ ní tan'dúúcā chí chɛɛcú ndúúcū 'diīnú, 'tííca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tí 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi diíⁿ yā tan'dúúcā chi neⁿ'e Chiidá chi canée yā ná va'ai chɛɛti nguuvi tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ chí 'diinú ndúúcū vi'í ndúúcū chɛɛcú. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nguuvi miiⁿ Jesús can'dáa yā va'āī miiⁿ ní ch'iīndi yā niiⁿnuúⁿ ná nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ní nééné n'deēe 'iiⁿ'yāⁿ ndúúvidaamá yā naachi canéé Jesús. Tuu'mi ní Jesús ndaa yā na 'áámá barco ní ch'iīndí yā. Nducyáácá 'iiⁿ'yāⁿ snée yā 'diituu núuⁿnīⁿ naachi vɛɛ yáⁿ'āa ndúútiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ní Jesús caⁿ'a yā nééné n'deēe nááⁿ ndúúcū parábolas chí ejemplos tan'dúúcā dendu'ū chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū. Ní caⁿ'a yā chuū: 'Áámá saⁿ'ā chi ngiīnū ndaata can'dáa sa chiīnū sa ndaata. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Taachí chiīnū sa, 'áámá duutu ndaata mííⁿ ní chiiya cyúúní. Ndaā 'yaadá ni ch'iinu che'e tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Náⁿ'ā duutu ndaata miiⁿ ní chiiya na tuūu naachi nguɛ́ɛ́ ch'ɛɛtɛ yáⁿ'āa. Maaⁿnchɛɛtɛ́ nūuⁿ can'dáā ti nguɛ́ɛ́ ch'ɛɛtɛ yáⁿ'āa yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Can'dáā 'yáⁿ'ā ní yaata miiⁿ ní ti'i ti nguɛ́ɛ́ dii'yu yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Iicu náⁿ'ā duutu ndaata miiⁿ ní chiiya nguaaⁿ yááⁿ. Yááⁿ miiⁿ ní ch'iita ní di'vaāchí yeⁿ'ē yaata miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Iicu náⁿ'ā duutu ndaata miiⁿ ní chiiya na yáⁿ'āa n'dáacā ní n'dáacā chiī cosecha yeⁿ'ē. 'Áámá ní chiī 'áámá ciento yeⁿ'ē, taama ní chiī 'iīnū ngɛɛcu yeⁿ'ē, ni táámá ní chiī ndíícú ndiichi yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Iiⁿ'yāⁿ chi vɛ́ɛ́ veéⁿ yā ní 'caandiveéⁿ yā nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tuu'mi ní discípulos ndaá yā nanááⁿ Jesús miiⁿ ní caⁿ'a yā chii yā Jesús: ¿Dɛ'ɛ cáávā chi ndúúcū ejemplos ngi'cueeⁿ nī 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: 'Āā ndís'tií nūuⁿ ndaācā chicadíínuuⁿ nī dendu'ū chi canúúⁿ n'de'ei yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ná va'ai chɛɛti nguuvi, naatí tanáⁿ'ā 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ canéé chí cadíínuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","'Iiⁿ'yāⁿ chi vɛ́ɛ́ yeⁿ'e yā Ndyuūs ca'a cá yā ní n'deēe cá cuuvi yeⁿ'e yā. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ vɛ́ɛ́ yeⁿ'e yā, 'áárá chí dúú'ví nūuⁿ chi nadacádíínuuⁿ yā chi vɛ́ɛ́ yeⁿ'e yā chuū ní Ndyuūs ndivíi yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Cáávā chííⁿ chí ngaⁿ'á ngií 'iiⁿ'yāⁿ ndúúcū ejemplos caati inaaⁿ yā naati n'gɛɛtinée yā tan'dúúcā chi nguɛ́ɛ́ inaaⁿ yā. Ní n'giindiveéⁿ yā naati n'gɛɛtinee yā tan'dúúcā chi nguɛ́ɛ́ n'giindiveéⁿ yā ndíí nguɛ́ɛ́ ndúú tuumicadiinuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ní 'íícú cuuvi cuaacu yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ chííⁿ chi caⁿ'a profeta Isaías ndii cuááⁿ vmnaaⁿ taachi caⁿ'a yā 'túúcā ní canéé nguūⁿ na libro yeⁿ'e Ndyuūs: Ndúúcū veéⁿ yā 'caandiveéⁿ yā ni nguɛɛ tuumicadíínuuⁿ yā; ní snaaⁿ yā ní nguɛ́ɛ́ ca'a yā cuenta yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Caati staava yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní chɛɛchi. Ndúúcū veéⁿ yā n'giindiveéⁿ yā naati nguɛ́ɛ́ tuumicadíínuuⁿ yā n'daācā. 'Iiⁿ'yāⁿ s'eeⁿ ní n'gaadí yā nduutinaaⁿ yā caati nguɛ́ɛ́ snaaⁿ yā ndúúcū nduutinaáⁿ yā; ní nguɛ́ɛ́ 'caandiveéⁿ yā ndúúcū veéⁿ yā, ndii nguɛɛ ndúú ituumicadiinúúⁿ yā ndúúcū staava yeⁿ'é yā, ndii nguɛ́ɛ́ ndúú ndaacadaamí yā yeⁿ'ē nuuⁿndi yeⁿ'e yā chi 'úú cuuví nadich'ɛɛ̄cú nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Dɛ'ɛ chúúcā n'dai ndís'tiī ti vɛ́ɛ́ nduutinaaⁿ nī chí inaaⁿ nī ní veéⁿ nī chí n'giindiveéⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ti cuaacu nííⁿnyúⁿ 'úú Jesús ngaⁿ'á ngií ndís'tiī chi neené 'yaaⁿ 'iiⁿ'yāⁿ profetas ndúúcū 'iiⁿ'yāⁿ chí n'dai neⁿ'é yā snaaⁿ yā chííⁿ chí ndís'tiī inaaⁿ nī naati nguɛ́ɛ́ n'diichi yā. Neⁿ'e yā 'caandiveéⁿ yā chííⁿ chí ndís'tiī n'giindiveéⁿ nī naati nguɛ́ɛ́ ch'iindiveéⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","'Caandiveeⁿ ndís'tiī ejemplo yeⁿ'e saⁿ'ā chí ngiīnū ndaata. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","'Iiⁿ'yāⁿ chi n'giindiveéⁿ yā nduudu yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē va'ai chɛɛti nguuvi ní nguɛ́ɛ́ ituumicadíínuuⁿ yā, 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā duutu ndaata chí chiiya cuaaⁿ cyúúní. Ndaa yááⁿn'guiinūuⁿ ní sta'ā sa nduudu yeⁿ'é Ndyuūs chi canéé na staava yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndaata chí chiiya nguaaⁿ tuūu ní tan'dúúcā 'iiⁿ'yāⁿ chí n'giindiveéⁿ yā nduudu yeⁿ'é Ndyuūs. Ní taachí n'giindiveéⁿ yā nduudu miiⁿ ní yeenú n'dai yā, ");
INSERT INTO cuxNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","naati nguɛ́ɛ́ 'áámá cānee na staava yeⁿ'é yā ní nguɛ́ɛ́ 'nááⁿ tiempo cūnee. Taachí n'géénu yā ngii ti 'iiⁿ'yāⁿ cán'daa yā 'iiⁿ'yāⁿ s'eeⁿ cáávā nduudu yeⁿ'é Ndyuūs, tuu'mí nūuⁿ divíi yā nduudu miiⁿ ní nguɛ́ɛ́ canée na staava yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndaata chí chiiya nguaaⁿ yááⁿ ní tan'dúúcā 'iiⁿ'yāⁿ chi ch'iindiveéⁿ yā nduudu miiⁿ naati neⁿ'e cá yā nducuéⁿ'ē yeⁿ'ē iⁿ'yeeⁿdí 'cūū ndúúcū chi vɛ́ɛ́. Ní nginnche'éí yā 'iiⁿ'yāⁿ. Ní vaadī 'cuiica miiⁿ di'vaachií yeⁿ'ē nduudu miiⁿ ní diiⁿ chí nguɛ́ɛ́ dichíí'vɛ̄ nduudu miiⁿ na vida yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ndaata chí chiiya na yáⁿ'āa n'dáacáā chííⁿ chí tan'dúúcā 'iiⁿ'yāⁿ chí n'giindiveéⁿ yā nduudu yeⁿ'é Ndyuūs ní tuumicadiinúúⁿ yā ní i'téénu yā nduudu miiⁿ. Ní n'daācā idiíⁿ yā. Ní nduudu miiⁿ tan'dúúcā chi chiī 'aama ciento yeⁿ'ē o chi chiī 'iīnū ngɛɛcu yeⁿ'ē o chi chiī ndiicú ndiichi yeⁿ'ē. 'Tíícā chii cosecha yeⁿ'ē nduudu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús miiⁿ ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuuví ndís'tiī táámá ejemplo. Ní caaⁿ'máⁿ yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē na va'ai chɛɛti nguuvi ní tan'dúúcā 'áámá saⁿ'ā chí ngiīnū sa ndaata yeⁿ'e trigo chi n'daācā na campo yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Taachí mozos cyaadu sa, tuu'mi ní saⁿ'ā chi enemigo yeⁿ'ē sa ndaā sa ni chiīnū sa 'daaⁿ'nuⁿ trigo na campo yeⁿ'e saⁿ'ā miiⁿ nguaaⁿ trigo chi n'daācā miiⁿ, ní cúnaⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Taachí can'daa yaata yeⁿ'ē ní chiī trigo, tuu'mi ní can'daā nguuvi 'daaⁿ'nuⁿ trigo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tuu'mi ní mozos chi idiiⁿ sa ntiiⁿnyuⁿ na campo miiⁿ ndaa sa nanááⁿ saⁿ'a chi 'iivi yeⁿ'e campo miiⁿ ní caⁿ'a sa chii sa 'iivi: N'dií Señor, ¿'áá nguɛ́ɛ́ chiīnū ndaata yeⁿ'e trigo chi n'daācā na campo yeⁿ'e nī? ¿Tií chiīcā ndaata 'daaⁿ'nuⁿ trigo? ");
INSERT INTO cuxNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Saⁿ'ā 'iivi miiⁿ ní caⁿ'a sa chii sa mozos chi idiiⁿ ntiiⁿnyuⁿ: 'Áámá saⁿ'ā enemigo yeⁿ'é niīnū sa. Mozos ní caⁿ'a sa chii sa 'iivi sa: ¿'Áá neⁿ'e nī chi caⁿ'a 'nū ní tiicu 'nū yaātā miiⁿ chi nguɛ́ɛ́ n'daācā? ");
INSERT INTO cuxNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'Iivi miiⁿ ní caⁿ'a sa chii sa mozos chi idiiⁿ ntiiⁿnyuⁿ: Nguɛ́ɛ́ tiīcū di 'daaⁿ'nuⁿ trigo miiⁿ caati cuuví tiicú ntúuⁿ di trigo chí n'daācā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ca'a di lugar chi dáámá 'cuiita ndíí taachi ndaa tiempo yeⁿ'e cosecha miiⁿ, tuu'mi ní 'úú caaⁿ'máⁿ cuūví 'iiⁿ'yāⁿ chi 'caacá yā trigo miiⁿ chi 'caacá yā vmnááⁿ vmnaaⁿ 'daaⁿ'nuⁿ trigo miiⁿ ní dichiichí yā caadī ticuaá ní 'neeⁿ yaⁿ'a yā. 'Cuiinu maaⁿ ní nandɛ́ɛ yā trigo miiⁿ ní 'cuíi yā chɛɛti díínūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Táámá ejemplo Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi ní tan'dúúcā 'aama nduutií yeⁿ'e yiivɛ̄ ntíí'yāa chi 'áámá saⁿ'ā sta'ā sa ní chiīnū sa na yáⁿ'āa yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndaata yiivɛ̄ ntíí'yāa 'cūū ní 'liiⁿ ca nguɛ́ɛ́ ti tanducuéⁿ'ē ndaata. Taachí n'giita yaātā miiⁿ, tuu'mi ní ch'ɛɛtɛ ca chi cuuvi tanáⁿ'ā yaātā. Ní chiī yáⁿ'á. Ní ndaá 'yáádá yeⁿ'ē nanguuvi ní din'dái tī 'dɛɛcɛ tī na dúuⁿnɛ̄ yáⁿ'á miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Táámá ejemplo Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē na va'ai chɛɛti nguuvi ní tan'dúúcā 'áámá tááⁿ levadura yeⁿ'e pan. 'Áámá n'daataá sta'a tá levadura miiⁿ ní chistaⁿ'ā tá nguaaⁿ 'iīnū medida yeⁿ'e harina ndíí chí nan'guiita tanducuéⁿ'ē yaāchī yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tanducuéⁿ'ē chuū ngi'cueeⁿ Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ ndúúcū ejemplos. Ni nduuti chi nguɛ́ɛ́ ndúúcū ejemplos yeⁿ'e chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cuū, nguɛ́ɛ́ ngi'cueeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ní 'iicu cuuvi cuaacu chí caⁿ'a profeta ndii cuááⁿ vmnaaⁿ taachí caⁿ'a yā 'túúcā. Ní canéé nguūⁿ ná libro yeⁿ'é Ndyuūs 'túúcā: Caaⁿ'máⁿ ndúúcū ejemplos. Ca'cueéⁿ dendu'ū chi canúúⁿ n'de'ei ndíí taachi Ndyuūs din'dái yā iⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tuu'mi ní Jesús yaa'vi yā 'iiⁿ'yāⁿ s'eeⁿ chi cunaⁿ'á yā na vaacú yā. Jesús ntúūⁿ cunaⁿ'a yā ní sndaa yā 'áámá va'ai. Discípulos yeⁿ'e yā nndaa yā nanááⁿ Jesús, ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: N'diī, Jesús, ca'cuéeⁿ nī chí neⁿ'e caāⁿ'maⁿ ejemplo yeⁿ'e 'daaⁿ'nuⁿ trigo chi vɛ́ɛ́ nguaaⁿ trigo na campo. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Iiⁿ'yāⁿ chi ngiīnu ndaata chi trigo chi n'dáacā, 'iiⁿ'yāⁿ miiⁿ chí Saⁿ'ā chí Daiya Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Campo miiⁿ ní tan'dúúcā iⁿ'yeeⁿdí 'cūū. Ndaata chi n'dáacā miiⁿ ní tan'dúúcā nducyáácá 'iiⁿ'yāⁿ chi daiya Ndyuūs ní yeⁿ'ē naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Yaātā yeⁿ'e ndaata chi nguɛ́ɛ́ n'daācā ní tan'dúúcā 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daācā idiíⁿ yā, 'iiⁿ'yāⁿ s'eeⁿ chi daiya yááⁿn'guiinūūⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Saⁿ'ā chi chiinū sa 'daaⁿ'nuⁿ trigo miiⁿ ní tan'dúúcā maāⁿ yááⁿn'guiinūuⁿ. Ní cosecha yeⁿ'ē miiⁿ ní tan'dúúcā chí 'cuiinu iⁿ'yeēⁿdī. Saⁿ'ā s'eeⁿ chi ita'a sa cosecha miiⁿ ní tan'dúúcā ángeles. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tan'dúúcā chí tiīcú yā 'daaⁿ'nuⁿ trigo ní nadidáámá yā ní 'neeⁿ yaⁿ'a yā, 'tíícā cuuvi tiempo taachi 'cuiīnū iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Saⁿ'ā chi Daiya Ndyuūs ní dichó'o yā ángeles yeⁿ'e yā chi nadidáámá yā 'iiⁿ'yāⁿ chí yeⁿ'ē naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Niicú tun'dáa yā nducyaaca 'iiⁿ'yāⁿ chi diíⁿ yā chi náⁿ'a yā idiiⁿ nuuⁿndí yā ndúúcū 'iiⁿ'yāⁿ chi idiiíⁿ chi nguɛɛ n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ní cu'nuúⁿ yā 'iiⁿ'yāⁿ na nguuchí yaⁿ'ā. Mííⁿ 'iiⁿ'yāⁿ s'eeⁿ ní cuɛɛcú yā ní che'e 'diiⁿ'yúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tuu'mi ní 'iiⁿ'yāⁿ chi n'dáí nanááⁿ Ndyuūs cuuvi dɛɛvɛ́ yā ngii tan'dúúcā 'yáⁿ'ā taachi 'āā snée yā naachi Ndyuūs Chiidá yā ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. Ndís'tiī chi vɛ́ɛ́ veéⁿ nī 'caandiveéⁿ nī nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Caⁿ'a ca Jesús miiⁿ táámá ejemplo: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē va'ai chɛɛti nguuvi ní tan'dúúcā vaadī 'cuiica chí canúúⁿ n'de'ei na 'áámá campo. 'Áámá saⁿ'ā ní ndaācā sa vaadī 'cuiica miiⁿ ní cunuuⁿ n'dé'ei ntúūⁿ sa lugar miiⁿ. Yeenú taavi sa. Cunaⁿ'a sa ní n'diicui sa tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē sa ni cuái sa campo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","'Tiicá ntúūⁿ. Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi ní tan'dúúcā 'áámá saⁿ'ā chí n'diicui sa chí in'nuuⁿ sa perlas chi yaⁿ'ai taavi chíí'vɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Taachí ndaācā sa 'áámá perla chi n'dɛɛvɛɛ́ ní yaⁿ'ai taavi chíí'vɛ, tuu'mi ní cuinaⁿ'ā sa ní n'diicui sa tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē sa níícú cuai sa perla miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","'Tiicá ntuūⁿ. Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi ní tan'dúúcā 'áámá yaānā chí saⁿ'ā n'gaa nuúⁿ sa na nuūⁿnīⁿ'yáⁿ'ā ní ita'āa nducuéⁿ'ē naaⁿ 'yaācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Taachí 'āā ndiituú yaānā miiⁿ, intun'dáa yā cuaaⁿ 'diituú nuūⁿnīⁿ'yáⁿ'ā miiⁿ. Ní n'daaviyaí yā ní nan'guaáⁿ yā 'yáacā chi n'daācā. N'giī yā 'iiti 'cuɛ́ɛ́tɛ̄ɛ. Ní 'iiti chi nguɛ́ɛ́ n'dáacā miiⁿ nginngée yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Tíícā cuuvi taachi 'cuiīnū iⁿ'yeeⁿdí 'cūū. Nandaā ángeles ní tun'dáa yā 'iiⁿ'yāⁿ chí n'dai yā nguaaⁿ 'iiⁿ'yāⁿ chí nguɛɛ n'dáacā idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ní 'cuíi yā 'iiⁿ'yāⁿ chí nguɛ́ɛ́ n'daācā ná nguuchi yaⁿ'ā. Mííⁿ 'iiⁿ'yāⁿ s'eeⁿ cueⁿ'e daāⁿmaⁿ cuɛɛcú yā ní cueⁿ'e daāⁿmaⁿ ché'é 'diiⁿ'yuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús tiinguuneeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá tuumicádíínuuⁿ ndís'tiī tanducuéⁿ'e dendu'ū chí 'túúcā? 'Iiⁿ'yāⁿ s'eeⁿ ní n'guɛɛcútaⁿ'a yā: 'Tíícā Señor. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Áámá 'aama maestro yeⁿ'ē ley chí'neeⁿ yā yeⁿ'e naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi, maestro miiⁿ ní cuuví yā tan'dúúcā 'áámá patrón chi vɛ́ɛ́ vaadī 'cuiica yeⁿ'e sa na va'ai yeⁿ'ē sa. Ní deenu sa táácā tun'dáa sa yeⁿ'e vaadī 'cuiica yeⁿ'ē sa dendu'ū cosa chi ngaī ndúúcū cosa chi ndiicúū. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Taachí Jesús miiⁿ ch'íínú caⁿ'á yā nduudu 'cūū, cueⁿ'é yā yeⁿ'ē miiⁿya. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ní ndaá yā yáāⁿ vaacú yā chi nguuvi Nazaret ní ngi'cueeⁿ yā yaācū sinagoga miiⁿ. 'Iiⁿ'yāⁿ s'eeⁿ ní cheⁿ'e yiinú yā yeⁿ'e chi chi'cueeⁿ Jesús. Ní ngaⁿ'a yā: ¿Tií ndiicaá vaadī déenu yeⁿ'ē saⁿ'á 'cūū? ¿Táácā cuuvi diiⁿ sa vaadī n'giinu chí idiiⁿ sa? ");
INSERT INTO cuxNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sáⁿ'a 'cūū chí daiya 'viichiyáⁿ'ā ní María nguūvī chɛɛcu sa. Ni 'díinū sa ní Jacobo, ndúúcū José, ndúúcū Simón, ndúúcū Judas. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ví'i ntúuⁿ sa snee yā ndúúcu yú. ¿Tií ndiicaá tanducuéⁿ'ē vaadī deenú 'cūū chí ngí'cuééⁿ sa? ");
INSERT INTO cuxNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ní cáávā chuū 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ cunncáā caⁿ'a yā yeⁿ'e Jesús miiⁿ, ní nguɛ́ɛ́ i'téénu yā yeⁿ'e yā. Naati Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Nguɛ́ɛ́ vɛ́ɛ́ mar 'áámá profeta chi candɛɛ nduudu yeⁿ'é Ndyuūs chí 'iiⁿ'yāⁿ yeⁿ'ē yáāⁿ vaacú yā ndúúcū 'iiⁿ'yāⁿ na vaacu yā dinéⁿ'e yā profeta miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesús miiⁿ nguɛ́ɛ́ neené n'deēe vaadī n'giinu diíⁿ yā miiⁿ caati 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ s'téénu yā yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tiempo 'cūū saⁿ'a rey Herodes, chi gobernador yeⁿ'e yáⁿ'āa Galilea, ch'iindiveeⁿ sá tan'dúúcā chi 'iiⁿ'yāⁿ ngaⁿ'a yā yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ní rey miiⁿ caⁿ'a sa chii sa mozos yeⁿ'ē sa: Sáⁿ'ā Jesús 'cūū ní Juan chí ngɛɛdínuūⁿnīⁿ chí nnduuchi sá yeⁿ'ē nguaaⁿ tináⁿ'ā. Ní cáávā chuū vɛ́ɛ́ poder yeⁿ'ē sa chi idiiⁿ sa vaadī n'giinu. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Rey Herodes miiⁿ ní 'iiⁿ'yāⁿ chi caⁿ'a ntiiⁿnyúⁿ yā chi soldados sta'a sa Juan miiⁿ ní cāchiichí sa Juan ndúúcū cadenas ní chi'nuuⁿ sa Juan vácūū. 'Tíícā diíⁿ rey miiⁿ cucáávā n'daataá yeⁿ'e yā chi nguuvi Herodías ti vmnááⁿ vmnaaⁿ n'daataá miiⁿ ní n'daataá yeⁿ'ē Felipe chi 'díínu rey miiⁿ. Ní divíi rey miiⁿ táⁿ'ā miiⁿ yeⁿ'e Felipe. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","'Tíícā diíⁿ rey ndúúcū Juan chi ngɛɛdínuūⁿnīⁿ ti Juan miiⁿ ngaⁿ'a sá ngii sa Herodes miiⁿ chi tan'dúúcā chi ngaⁿ'a na ley, nguɛ́ɛ́ canee chí cuuvi n'daataá yeⁿ'é yā n'daataá miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Rey Herodes miiⁿ ní neⁿ'e yā 'caaⁿ'nuⁿ yā Juan miiⁿ, naati 'va'á yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ; ti 'iiⁿ'yāⁿ s'eeⁿ ní s'téénu yā chí Juan miiⁿ ní 'iiⁿ'yāⁿ profeta chi dichó'o Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Taachí 'iiⁿ'yāⁿ diíⁿ yā 'viicu yeⁿ'ē cumpleaños yeⁿ'e Herodes miiⁿ, n'daataá 'lííⁿ daiya táⁿ'ā Herodías miiⁿ nde'ei tá naavtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. Ní rey Herodes miiⁿ ní chiī yeenú yā chi nde'ei tá ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Dii, n'daataá 'lííⁿ. 'Úú ngaⁿ'á ndúúcū nduudu, “por Dios”, chi teé dii 'āā dɛ'ɛ́ nūuⁿ chí neⁿ'e di. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Chɛɛcu tá ni caⁿ'a yā chīi yā n'daataa 'lííⁿ miiⁿ dɛ'ɛ̄ chí caaca tá. Ní n'daata 'lííⁿ caⁿ'a ta chii tá rey miiⁿ: N'diī rey, tée nī 'úú tiīⁿ Juan chi ngɛɛdínuūⁿnīⁿ cu'nuúⁿ chɛɛtī 'áámá cu'u. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tuu'mi ní rey Herodes miiⁿ s'neeⁿ ndaachii yiinú yā; naati rey miiⁿ caati 'āā caⁿ'a yā ndúúcū nduudu, “por Dios”, ní ch'iindiveéⁿ 'iiⁿ'yāⁿ chi snée yā ndúúcu yā na mesa miiⁿ, caⁿ'a yā chí 'āā ca'a núúⁿ yā chííⁿ chí ngiica táⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Caⁿ'a ntiiⁿnyúⁿ yā chí 'caātā daandu Juan chi ngɛɛdinuūⁿnīⁿ chi canúuⁿ sa vácuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ní ndɛɛ sa tiiⁿ yā miiⁿ sn'núúⁿ chɛɛti cu'u ní ca'a sa n'daata 'lííⁿ miiⁿ. Ní táⁿ'ā miiⁿ ní ca'a tá chɛɛcu tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tuu'mi ní discípulos yeⁿ'e Juan chi ngɛɛdínuūⁿnīⁿ ndaá yā ní sta'á yā cuerpo yeⁿ'e Juan miiⁿ ní ch'iīchi yā. Ní cheⁿ'e yā chīi yā Jesús miiⁿ tan'dúúcā chí chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Taachí Jesús miiⁿ ch'iindiveéⁿ yā chuū, cueⁿ'é yā ní sndáa yā na 'áámá barco, ní cueⁿ'e yā na 'áámá lugar cuɛɛti naachi nguɛ́ɛ́ 'iiⁿ'yāⁿ. Taachí 'iiⁿ'yāⁿ s'eeⁿ ch'iindiveéⁿ yā chuū, can'dáa yā yeⁿ'e yáāⁿ s'eeⁿ ní cueⁿ'e yā ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ní taachí Jesús miiⁿ nan'dáa yā ná barco miiⁿ, n'diichí yā n'deee n'dáí 'iiⁿ'yāⁿ, ní nnee ya'ai 'iinu yā 'iiⁿ'yāⁿ s'eeⁿ. Ní diíⁿ yā chi nduūvā yeⁿ'é 'iiⁿ'yāⁿ chi ngíitā chi ndaā ndúúcū 'iiⁿ'yāⁿ chi candɛɛ yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ní taachí 'āā chiinu discípulos yeⁿ'e Jesús miiⁿ ndaá yā nanááⁿ Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: 'Āā chi chíínū maaⁿ, ní 'muuⁿ nguɛ́ɛ́ n'gɛɛtinéé 'iiⁿ'yāⁿ. Yaa'ví nī 'iiⁿ'yāⁿ s'tíī chí caⁿ'á yā cuááⁿ na yáāⁿ n'gaiyáā ní cuái yā chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús caⁿ'a yā chīi yā discípulos: 'Iiⁿ'yāⁿ s'tíī nguɛ́ɛ́ cánéé chí náⁿ'a yā. Ndís'tiī ca'a nī chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Discípulos ní caⁿ'a yā: Nguɛ́ɛ́ tunééⁿ chi che'e yā. Dámāāⁿ nyuⁿ'u panes ndúúcū na 'uūvī 'yaācā vɛ́ɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús caⁿ'a yā chii yā discípulos: Candɛ́ɛ nī panes ndúúcū 'yaācā 'muuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Cuayiivi ní Jesús chii yā 'iiⁿ'yāⁿ s'eeⁿ chí ch'ɛɛtɛ́ yā ná yaātā miiⁿ. Jesús ní sta'á yā nduu nyúⁿ'ú panes miiⁿ ndúúcū 'uūvī 'yaaca ní n'diichí yā nanguuvi ní ca'a yā gracias Ndyuūs Chiidá yā. Cuayiivi ní n'deee yā panes ní ca'a yā discípulos yeⁿ'e yā. Discípulos miiⁿ ní ca'a yā 'iiⁿ'yāⁿ chi snéé miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nducyáácá yā che'e yā ní chiitu 'iiⁿ'yāⁿ. Ní discípulos nān'guaáⁿ yā chí nángaāva panes yeⁿ'e miiⁿ ndúúcū 'yaācā miiⁿ ní chiitu tá ndiichúúví 'cuɛɛ̄tɛ̄ɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","'Iiⁿ'yāⁿ chí che'ē miiⁿ nyuⁿ'u mil ngii yā, ndii nguɛ́ɛ́ chiduūchɛ n'daataá, ndíí nguɛ́ɛ́ ndúú da'caīyāa ra. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Cuayiivi ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā chi cundaa yā na barco ní caⁿ'á yā táámá 'díítuú nuūⁿnīⁿ'yáⁿ'ā, 'naaⁿ chi Jesús miiⁿ diíⁿ yā despedir yeⁿ'é 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesús diíⁿ yā despedir yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ ní divíi yā yeⁿ'e yā ní cuchɛɛ yā na 'áámá yiīcū ní caⁿ'angua'á yā. Taachí chiī 'da'a, 'āā dámaaⁿ Jesús canée yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Barco miiⁿ ní 'āā cánduūu naavtaⁿ'ā yeⁿ'ē nuūⁿnīⁿ'yáⁿ'ā miiⁿ naachi olas yeⁿ'e nuūⁿnīⁿ miiⁿ neⁿ'e 'cuuchii na yaānūuⁿ yeⁿ'e nuūⁿnī miiⁿ. 'Yúúné ní ngeēnū taaⁿ ní diitu n'dáí n'geⁿ'e na barco miiⁿ. Ní barco miiⁿ nguɛ́ɛ́ ngii ngíícá. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Taachi 'da'a ca táámá nguuvi tan'dúúcā n'gɛɛcu cuūuⁿ o n'gɛɛcu nyuⁿ'u, Jesús ndaá yā nanááⁿ discípulos ní ngíícá yā cuaaⁿ vmnaaⁿ nuūⁿnīⁿ'yáⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Taachí discípulos ní n'diichí yā Jesús miiⁿ chi ngiicá yā cuaaⁿ vmnaaⁿ nuūⁿnīⁿ'yáⁿ'ā miiⁿ ní dii'yá yā chiī. Ní chistaⁿ'a vaanicadiinūuⁿ yeⁿ'é yā. Ní 'cai yā: Chuū ní 'áámá bulto. Ní caⁿ'á yā ndúúcū vaadī 'va'a. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Cuayiivi miiⁿ ní Jesús yaa'ví yā discípulos ní caⁿ'a yā: Ndís'tiī cúúví ditiinú nī caati 'úú. Nguɛ́ɛ́ di'va'á nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tuu'mi ní Pedro nán'guɛɛcútaⁿ'a sa ní caⁿ'a sa: N'dií Señor, ndúúti chí n'diī caaⁿ'maⁿ ntiiⁿnyúⁿ nī chi caⁿ'á naachi canee nī ní caacá cuaaⁿ vmnaaⁿ nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús miiⁿ ní caⁿ'a yā chii yā: Pedro, cuchíi di. Pedro miiⁿ ní nan'dáa sa na barco miiⁿ ni tucá'a sa ngiica sa cuaaⁿ vmnaaⁿ nuūⁿnīⁿ miiⁿ. Ní cueⁿ'ē sa naachi canéé Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Taachí Pedro miiⁿ n'diichi sa 'yúúné taaⁿ miiⁿ di'vá'a sa ní 'āā tucá'ā chɛɛchi sa nguaaⁿ nuūⁿnīⁿ miiⁿ. Tuu'mi ní 'cáí yiicu sa ní caⁿ'a sa: Señor, nadanguáⁿ'ai nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hora mííⁿ nūuⁿ, Jesús miiⁿ n'doó yā ta'a yā ní sta'á yā ta'a Pedro ní caⁿ'a yā chii yā Pedro: Dii saⁿ'ā chi dúú'vīi i'téénu di, ¿dɛ'ɛ̄ cúúví chí nadi'uūvī di staava yeⁿ'ē di ní nguɛ́ɛ́ i'téénu di? ");
INSERT INTO cuxNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ní taachí Jesús ndúúcū Pedro sndáa yā na barco miiⁿ, canee 'diiíⁿ 'yúúné mííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tuu'mi ní discípulos chi snúuⁿ yā na barco miiⁿ ní ndaá yā nanááⁿ Jesús ní s'téénu yā 'iiⁿ'yāⁿ. Ní caⁿ'a yā: N'diī Jesús, cuaacu nííⁿnyúⁿ chí Daiya Ndyuūs n'dii. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tááchí ch'iinu cho'ó yā táámá lado yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā miiⁿ ní ndaá yā na yáⁿ'āa Genesaret. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'Iiⁿ'yāⁿ s'eeⁿ yeⁿ'e yáⁿ'āa miiⁿ taachi tuumicádíínuuⁿ yā chí Jesús canée yā miiⁿ, tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ caⁿ'á yā ní chii yā 'iiⁿ'yāⁿ yeⁿ'e núúⁿmáⁿ cuaaⁿ yáāⁿ n'gaiyáā chi snéé niiⁿnuúⁿ chi Jesús canée yā miiⁿ. Níícú 'iiⁿ'yāⁿ s'eeⁿ cándɛ́ɛ yā nducyaaca 'iiⁿ'yāⁿ chi ngííta yā nanááⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ní 'iiⁿ'yāⁿ s'eeⁿ di'cuíítu yā Jesús miiⁿ chi 'cuáaⁿ yā chi 'iiⁿ'yāⁿ s'eeⁿ tuu'ví yā naachi n'dɛ́ɛ́tií yeⁿ'ē catecái yā. Ní nducyaaca 'iiⁿ'yāⁿ chí tuu'ví yā catecai Jesús miiⁿ ní nduūvā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tuu'mi ní duu'vi maestros chi ngi'cueeⁿ ley ndúúcū 'iiⁿ'yāⁿ fariseos chi chiicá yā yáāⁿ Jerusalén ndaá yā nanááⁿ Jesús miiⁿ, ní caⁿ'a yā chiī yā 'iiⁿ'yāⁿ: ");
INSERT INTO cuxNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Dɛ'ɛ̄ cúúví chí discípulos yeⁿ'e nī nguɛ́ɛ́ diíⁿ yā tan'dúúcā costumbre yeⁿ'ē 'iiⁿ'yāⁿ ndiicúū? ¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ inaaⁿnu yā ta'á yā taachi 'āā cuɛ́ɛ́ che'e yā pan? ");
INSERT INTO cuxNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chiī yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí ndís'tiī ní nguɛ́ɛ́ diíⁿ nī tan'dúúcā chi ngaⁿ'a ley yeⁿ'é Ndyuūs ní diíⁿ nī tan'dúúcā costumbre yeⁿ'ē 'iiⁿ'yāⁿ ndiicúū? ");
INSERT INTO cuxNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ti Ndyuūs ní ca'á yā ley yeⁿ'e yā ní caⁿ'a yā: Diíⁿ nī honrar chiidá nī ndúúcū chɛɛcú nī. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ n'dáacā ngaⁿ'a yā yeⁿ'e chiidá yā o yeⁿ'ē chɛɛcú yā ní 'cuūvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Naati ndis'tiī ní ngaⁿ'a nī chi 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí caaⁿ'máⁿ yā cuuvi yā chiidá yā ndúúcū chɛɛcú yā 'tíícā: Nducuéⁿ'ē chi teé n'diī maaⁿ ní ca'á lado yeⁿ'é Ndyuūs caava ofrenda yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'Iiⁿ'yāⁿ 'āā ntɛ́ɛ́ idiíⁿ yā chi neⁿ'é yā chiida yā ndúúcū chɛɛcú yā. 'Tíícā caavā costumbre yeⁿ'é nī diíⁿ nī chi 'āā ntɛ́ɛ́ idichíí'vɛ̄ ley yeⁿ'é Ndyuūs yeⁿ'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ndís'tiī 'uūvī naaⁿ 'uuvi cheendí nī. N'daācā caⁿ'a profeta Isaías miiⁿ yeⁿ'é nī taachi caⁿ'a sa ndíí vmnaaⁿ ní canéé nguūⁿ na libro yeⁿ'e Ndyuūs 'tííca: ");
INSERT INTO cuxNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Iiⁿ'yāⁿ s'uuⁿ ní i'téénu yā 'úú ndúúcū nduudu yeⁿ'e yā, naati staava yeⁿ'é yā yaⁿ'ai canee yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ dichíí'vɛ̄ chi i'téénu yā 'úú, caati chi ngi'cueeⁿ yā ní ley yeⁿ'e saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús n'gai yā n'deee n'dáí 'iiⁿ'yāⁿ chí ndaa yā nanáaⁿ yā. Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Caandivéeⁿ nī ní tuumicadíínuuⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nguɛ́ɛ́ tanducuéⁿ'ē chi nge'e saⁿ'ā chi ndaā cheendi saⁿ'ā idivaatí saⁿ'ā naati nduudu chí ican'daā cheendi saⁿ'ā, chííⁿ chí diiⁿ chí vɛ́ɛ́ nuūⁿndī yeⁿ'ē saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tuu'mi ní discípulos yeⁿ'e Jesús ndaá yā nanáaⁿ yā ní caⁿ'a yā chii yā Jesús miiⁿ: ¿'Áá nguɛ́ɛ́ déénu nī chí 'iiⁿ'yāⁿ fariseos taachí ch'iindiveéⁿ yā nduudú 'cūū nduuvi taáⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Naatí Jesús miiⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: Taanduvɛ́ɛ́ yaāta chi nguɛ́ɛ́ chiīchi Chiidá chi canéé yā na va'ai chɛɛti nguuvi canee chí tiīcūu ndii díí'yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","'Āā s'nééⁿ rá 'iiⁿ'yāⁿ s'eeⁿ chi tan'dúúcā 'iiⁿ'yāⁿ chi ngueenááⁿ chi candɛ́ɛ yā táámá 'iiⁿ'yāⁿ chi ngueenááⁿ ndúúcu yā. Nduuti chi 'áámá 'iiⁿ'yāⁿ chi ngueenááⁿ candɛ́ɛ yā táámá 'iiⁿ'yāⁿ chi ngueenááⁿ ndúúcu yā, nduu 'uuví yā cungéē nuúⁿ yā na yiivi yáⁿ'āⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tuu'mi ní Pedro miiⁿ ní nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa chii sa Jesús miiⁿ: Cúúví nī nús'uu dɛ'ɛ néⁿ'é caāⁿ'māⁿ ejemplo 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús caⁿ'a yā: ¿'Áá 'tiicá ntúūⁿ nguɛ́ɛ́ ituumicadíínuuⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿'Áá nguɛ́ɛ́ ituumicadíínuuⁿ nī chi tanducuéⁿ'ē chí indaā cheendi saⁿ'ā ngeⁿ'e chɛɛ̄tī sa ní cungéē cuaaⁿ chuva'āī? ");
INSERT INTO cuxNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Naati nduudu chi ícan'daa cheendi sa chí níngiica na staava yeⁿ'ē sa, chuū idiīiⁿ chi vɛ́ɛ́ núúⁿndí yeⁿ'ē sáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Caati yeⁿ'e na staava yeⁿ'e 'iiⁿ'yāⁿ ngiicá dendú'ū chi nguɛ́ɛ́ n'dáacā chi inadicádíínuuⁿ yā. Chuū ní inadicádiinúúⁿ yā yeⁿ'ē chi 'caāⁿ'nuⁿ yā 'iiⁿ'yāⁿ, ndúúcū yeⁿ'ē chi caⁿ'á yā ndúúcū isaⁿ'ā o n'daataá chi nguɛ́ɛ́ yeⁿ'e yā, ndúúcū chi n'diichí yā 'aama saⁿ'ā o n'daataá chi duuchí vi'ī, ndúúcū yeⁿ'ē chi ididuucú yā, ndúúcū yeⁿ'ē chi testigo yā ní caaⁿ'máⁿ yā nduudu yaadi, ndúúcū yeⁿ'ē chi caaⁿ'maⁿ taáⁿ yā contra yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dendú'u 'cūū chi ídiīiⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'ē sa naati chi che'e sa taachi nguɛ́ɛ́ naaⁿnú sa ta'a sa, chiiⁿ ní nguɛ́ɛ́ idinuuⁿndi sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús chiicá yā yeⁿ'ē yáāⁿ miiⁿ ní cueⁿ'e yā na yáⁿ'āa yeⁿ'e Tiro ndúúcū Sidón. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Cuin'dííchí nī. 'Áámá n'dáátāa yeⁿ'e yáⁿ'āa Canaán chí can'daā tá yeⁿ'e yáāⁿ vaacu tá. N'gaī yiicu tá ní ngaⁿ'a tá ngii tá Jesús miiⁿ: N'dií Señor chi Daiya David, nnéé ya'ai 'iinu nī 'úú. 'Áámá espíritu yeⁿ'e yááⁿn'guiinūuⁿ idindú'ū taaví táⁿ'ā daīyá. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús nguɛ́ɛ́ nan'guɛɛcútaⁿ'a yā yeⁿ'ē tá. Tuu'mi ní discípulos yeⁿ'ē Jesús miiⁿ ndaá yā nanáaⁿ yā ní di'cuíítu yā Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: N'diī Jesús, diíⁿ nī despedir yeⁿ'ē ta ti táⁿ'a 'cūū ní n'gaī tá cūchiitá cuaaⁿ daami yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: Dendyuūs dicho'ó yā 'úú cucáávā 'iiⁿ'yāⁿ yeⁿ'e Israel chi tan'dúúcā 'iiti cuūchī chí nindáí, 'tiicá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tuu'mi ní taⁿ'ā miiⁿ ndaā ta nanááⁿ Jesús ní chiintiī'ya tá ní caⁿ'a tá chii tá 'iiⁿ'yāⁿ: N'dií Señor, cunneé nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús miiⁿ ní nan'guɛɛcútaⁿ'á yā yeⁿ'ē tá ní caⁿ'a yā chii yā táⁿ'ā: Nguɛ́ɛ́ n'daācā chí divií pan yeⁿ'ē daiyá 'nū ní ca'á chi che'e 'yaānā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Táⁿ'ā miiⁿ ní caⁿ'ā ta: 'Tíícā Señor, naati 'yáanā miiⁿ ngé'e tī yeⁿ'ē cheeyéē chi ngéē yeⁿ'ē na mesa yeⁿ'ē 'iiví tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tuu'mi ní Jesús miiⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā táⁿ'ā: Dií n'daataá, dɛ́'ɛ chúúcā ch'ɛɛtɛ vaadī i'téénú yeⁿ'ē di. Cuuví ndúúcu di tan'dúúcā chi neⁿ'ē di. Daiya tá miiⁿ ní hora mííⁿ nūuⁿ nduuva yeⁿ'ē ta. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús chiicá yā yeⁿ'ē yáⁿ'āa miiⁿ ní ndaá yā 'diituú nuūⁿnīⁿ'yáⁿ'ā Galilea. Cuayiivi ní cuchɛ́ɛ yā ná yiīcū miiⁿ ní ch'iīndi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nééné 'yaaⁿ 'iiⁿ'yāⁿ ndaā niiⁿnuúⁿ yā nanááⁿ Jesús miiⁿ ní ndɛ́ɛ yā 'iiⁿ'yāⁿ chi ngaā yó'ōo, ndúúcū 'iiⁿ'yāⁿ chi ngueenááⁿ, ndúúcū 'iiⁿ'yāⁿ 'díi'mī, ndúúcū 'iiⁿ'yāⁿ chi ló'ō ta'á yā o ca'a yā, ndúúcū 'yaaⁿ n'dáí 'iiⁿ'yāⁿ chi vɛ́ɛ́ cá tanáⁿ'ā ca'ai chi ndíi yā. Ní s'neeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ nanááⁿ Jesús miiⁿ. Ní Jesús diíⁿ yā chi nduūvā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nducyáácá 'iiⁿ'yāⁿ cheⁿ'e yiinú yā taachí n'diichi yā chí 'iiⁿ'yāⁿ 'díi'mī ní ngíí ngaⁿ'a, ní 'iiⁿ'yāⁿ chi ló'ō ta'á yā o ca'a yā nduuva yeⁿ'e yā, ní 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii ngiicá, ngiica yā; ní 'iiⁿ'yāⁿ ngueenááⁿ, inaaⁿ yā; ní tucá'a yā caⁿ'a yā: Dɛ'ɛ̄ chúúca ch'ɛɛtɛ Ndyuūs yeⁿ'e 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús 'caí yā discípulos yeⁿ'é yā ní caⁿ'a yā chii yā discípulos: Ya'áí cáávā 'iiⁿ'yāⁿ s'tíī ti 'āā 'iīnū nguuvī snée yā nduucú ní 'muuⁿ ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi che'e yā. Nguɛ́ɛ́ neⁿ'é nadicho'ó 'iiⁿ'yāⁿ chi nguɛ́ɛ́ che'e yā. 'Áátiī cuuví cúúnu yā cuaaⁿ cyúúní chi náⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tuu'mi ní discípulos yeⁿ'e yā caⁿ'a yā chīi yā Jesús: ¿Tií cáⁿ'a 'nū nguaí 'nū pan chi n'deee n'dáí chi ché'é nducyaaca 'iis'tíī na lugar 'cūū naachi nguɛɛ ch'ɛɛtinéé 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús caⁿ'a yā chii yā discípulos: ¿'Áá 'yaaⁿ ca pan yeⁿ'é nī vɛɛ? Discípulos caⁿ'a yā: Ndɛɛ̄chɛ̄ panes ndúúcū n'duuvi 'yaācā n'gaiyáā vɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús ca'a yā orden 'iiⁿ'yāⁿ s'eeⁿ chí 'cuɛɛtɛ́ yā na yáⁿ'āa miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tuu'mi ní Jesús sta'á yā ndu'ū ndɛɛ̄chɛ̄ panes miiⁿ ndúúcū 'yaācā miiⁿ. Ní ca'a yā gracias Ndyuūs cáávā panes miiⁿ. Ní n'dee yā panes miiⁿ ní ca'a yā discípulos yeⁿ'e yā. Ní discípulos ní ca'a yā 'iiⁿ'yāⁿ chi snéé miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nducyááca yā che'e yā ní chiitu 'iiⁿ'yāⁿ. Discípulos ní nān'guaáⁿ yā chí nángaāva ní chiitu tá ndɛɛ̄chɛ̄ 'cuɛ́ɛ́tɛ̄ɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","'Iiⁿ'yāⁿ chí che'e yā miiⁿ ní taanduu cuūuⁿ mil ngii sáⁿ'ā. Nguɛ́ɛ́ diduuchɛ yā n'daataá ndíí nguɛ́ɛ́ ndúú da'caīyāa. ");
INSERT INTO cuxNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tuu'mi ní Jesús yaa'ví yā 'iiⁿ'yāⁿ s'eeⁿ chi cunaⁿ'á yā. Ní Jesús ndaá yā na barco miiⁿ ní cueⁿ'e yā na yáⁿ'āa yeⁿ'e Magdala. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","'Iiⁿ'yāⁿ fariseos ndúúcū 'iiⁿ'yāⁿ saduceos ndaá yā nanááⁿ Jesús chí neⁿ'e n'diichíneeⁿ yā Jesús. Ní chiica yā Jesús 'áámá vaadī n'giinu yeⁿ'ē va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Naati Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Taachí ngii chíinū ní nanguuvi ní ndíí cuá'āa, ndís'tiī ní ngaⁿ'á nī chi n'dáacā diīiⁿ tiempo. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ní cuááⁿ ná nguɛɛtyaaⁿ taachí meēeⁿ ngíí cuá'aá, ndís'tiī ngaⁿ'a nī chi nguɛ́ɛ́ n'dáacā diīiⁿ tiempo maaⁿ. Ndís'tiī 'uūvī naaⁿ 'uūvī cheendí nī chi déénu nī dɛ'ɛ̄ chi cúúví yeⁿ'ē nanguuvi naati nguɛ́ɛ́ tuumicadíínuuⁿ nī dɛ'ɛ̄ chi cuuvi tiempo 'cūū ndúúcū señales chí inaaⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'Iiⁿ'yāⁿ chi cunncáā idiíⁿ yā ndúúcū 'iiⁿ'yāⁿ chí nguɛ́ɛ́ i'téénu yā Ndyuūs 'iiⁿ'yāⁿ miiⁿ néⁿ'e yā snaaⁿ yā 'áámá vaadī n'giinu naati señal miiⁿ nguɛ́ɛ́ ndaāca yā. Dámaāaⁿ cánéé señal yeⁿ'e profeta Jonás chi ndíí cuaaⁿ vmnaaⁿ chi canéé nguuⁿ na libro yeⁿ'e Ndyuūs. Jesús s'néeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ ní cueⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Discípulos yeⁿ'e Jesús ndaá yā táámá lado yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā ní chinaáⁿ yā chi cāndɛɛ yā pan. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús ca'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cundɛ́ɛ̄ ndís'tiī cuidado yeⁿ'e levadura yeⁿ'e 'iiⁿ'yāⁿ fariseos ndúúcū 'iiⁿ'yāⁿ saduceos ti levadura miiⁿ ní chiiⁿ chí chi'cueeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Discípulos ní tuca'á yā caⁿ'a yā nguaaⁿ maaⁿ yā. ¿'Áá chi nguɛ́ɛ́ ndɛɛ yú pan chiiⁿ chi 'tíícā ngaⁿ'a yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús miiⁿ tuumicadíínuuⁿ yā yeⁿ'ē chí inadicádiinūuⁿ discípulos ní caⁿ'a yā chii yā discípulos: ¿Dɛ'ɛ̄ cúúví chí inadacádíínuuⁿ nī 'túúcā na staava yeⁿ'é nī chi cáávā chi nguɛ́ɛ́ ndɛɛ nī pan? Ndís'tiī ní dúú'vīi i'téénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿'Áá nguɛ́ɛ́ ituumicádíínuuⁿ nī, ndii nguɛɛ ndúú inan'gaacú nī yeⁿ'ē nyuⁿ'u panes chí che'e nyuⁿ'u mil saⁿ'ā? ni ¿'áá n'deēe 'cuɛ́ɛ́tɛ̄ɛ ca panes nángaāva? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿'Áá ndíí nguɛ́ɛ́ nduu inan'gaacú nī yeⁿ'ē ndɛɛ̄chɛ̄ panes chí che'ē cuūuⁿ mil saⁿ'ā? ni ¿'áá n'deēe 'cuɛ́ɛ́tɛ̄ɛ ca panes nángaāva? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Dɛ'ɛ cuuvi chi nguɛɛ ituumicádiinuuⁿ nī chi nguɛ́ɛ́ cáávā pan miiⁿ chi caⁿ'á chí cundɛɛ nī cuidado yeⁿ'e levadura yeⁿ'e 'iiⁿ'yāⁿ fariseos ndúúcū 'iiⁿ'yāⁿ saduceos? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tuu'mi ní discípulos tuumicadíínuuⁿ yā chi Jesús miiⁿ nguɛ́ɛ́ caⁿ'a yā chii yā chi discípulos nguɛ́ɛ́ cundɛɛ yā cuidado yeⁿ'e levadura yeⁿ'e pan ti yeⁿ'e chí chi'cueeⁿ 'iiⁿ'yāⁿ fariseos ndúúcū 'iiⁿ'yāⁿ saduceos. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús ndaá yā yeⁿ'e yáⁿ'āa yeⁿ'e Cesarea yeⁿ'e yáⁿ'āa yeⁿ'e Filipo ní itiinguuneéⁿ yā discípulos yeⁿ'e yā ní caⁿ'a yā: ¿Du'ú 'úú ngaⁿ'a 'iiⁿ'yāⁿ yeⁿ'ē 'úú chi Saⁿ'ā chi Daiya Dendyuūs 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Discípulos ní caⁿ'a yā: Náⁿ'a yā ní ngaⁿ'a yā chí díí chí Juan chí chɛɛdinuūⁿnīⁿ díí. Náⁿ'a yā ní ngaⁿ'a yā chí díí chí profeta Elías miiⁿ díí. Níícú náⁿ'a yā ní ngaⁿ'a yā chi díí profeta Jeremías o 'āā du'ú nūuⁿ profeta. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús caⁿ'a yā chii yā discípulos: ¿Du'ū 'úú ngaⁿ'a ndís'tiī? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro miiⁿ nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa: N'diī ní Cristo chi Daiya Dendyuūs chi cánduuchī cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tuu'mi ní Jesús miiⁿ nan'guɛɛcútaⁿ'a yā yeⁿ'ē sa ní caⁿ'a yā: Dɛ'ɛ̄ chúúcā n'dai dii Simón, daiya Jonás, ti 'úú nguɛ́ɛ́ ch'iⁿ'í dii ndii nguɛɛ nduu táámá 'iiⁿ'yāⁿ, naati Chiidá chi canée yā ná va'ai chɛɛti nguuvi ch'iⁿ'í yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'Úú ntúūⁿ ngaⁿ'á ngií dii chi dii ní nguuvi Pedro dii ní nguuvi di neⁿ'e caaⁿ'maⁿ tuūu. Ní vmnaaⁿ 'áámá tuūu ch'ɛɛtɛ́ 'cūū chí neⁿ'e caaⁿ'maⁿ Cristo, ní 'úú din'daí yaācū yeⁿ'é. Ní ndíí mar 'áámá poder yeⁿ'e yááⁿn'guiinūuⁿ nguɛ́ɛ́ cuuvi din'nú'u tuūu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'Úú teé dii, Pedro, poder tan'dúúcā chi teé dii llaves yeⁿ'e va'ai chɛɛti nguuvi yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā 'tíícā diíⁿ. Ní tanducuéⁿ'ē chi cachiichí di na iⁿ'yeeⁿdi 'cūū cuchiichi ntúūⁿ ná va'ai chɛɛti nguuvi. Ní tanducuéⁿ'ē chi n'gúuⁿ di na iⁿ'yeeⁿdí 'cūū 'cuaāⁿ ntúūⁿ ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tuu'mi ní Jesús ca'á yā chii yā discípulos yeⁿ'e yā chi nguɛ́ɛ́ caaⁿ'maⁿ yā cuuvi yā mar 'áámá 'iiⁿ'yāⁿ chi Jesús miiⁿ chi Cristo yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuu'mi ní Jesús miiⁿ tucá'a yā chi'cueeⁿ yā discípulos yeⁿ'e yā. 'Úú cánéé chi caⁿ'á na yáāⁿ Jerusalén ní cánéé chí 'cueenu taaví cuuvi nééné n'deēe dendu'ū yeⁿ'é 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'ā ntiiⁿnyuⁿ yeⁿ'e yaācū miiⁿ, ndúúcū chiiduú n'gɛɛtɛ́, ndúúcū yeⁿ'e maestros yeⁿ'e ley. Cuayiivi ní 'iiⁿ'yāⁿ s'eeⁿ 'caaⁿ'núⁿ yā 'úú. Ní 'cuūví. Ndiichi ndii 'íínú nguuvi ní 'úú nduūchí yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tuu'mi ní Pedro miiⁿ ní cueⁿ'e sa ndúúcū Jesús 'áámá lado ní caⁿ'a sa chii sa Jesús: N'diī Señor, nguɛ́ɛ́ 'cuáaⁿ nī Ndyuūs 'iivi yú ndii mar 'áámá naaⁿ chi cuuvi chuū ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'e Pedro miiⁿ ní caⁿ'a yā chii yā saⁿ'ā: Divíi di nanaáⁿ, dii chi tan'dúúcā yááⁿn'guiinūuⁿ. Dii ní nguɛ́ɛ́ nadicádíínuuⁿ di tan'dúúcā Ndyuūs nadicadíínuuⁿ yā ti nadicádíínuuⁿ di yeⁿ'e dendú'ū yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: Nduuti chi 'áámá 'iiⁿ'yāⁿ néⁿ'e yā caⁿ'á yā nduucú, canéé chi cu'neeⁿ maáⁿ yā tanducuéⁿ'ē dendu'ū chi vɛ́ɛ́ yeⁿ'e yā ní cuta'á yā cruz yeⁿ'e yā chi tan'dúúcā chi 'cueenu taaví yā cuuvi cucáávā 'úú. Ní 'íícú caⁿ'a yā nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tí nducyáácá 'iiⁿ'yāⁿ chi neⁿ'e yā nadanguáⁿ'ai maáⁿ yā vida yeⁿ'e yā na iⁿ'yeeⁿdí 'cūū ní dindaí yā táámá vida yeⁿ'e yā nanááⁿ Ndyuūs. Ní nducyáácá 'iiⁿ'yāⁿ chi dindaí yā vida yeⁿ'e yā cucáávā 'úú ní nandaācá yā táámá vida yeⁿ'e yā nanááⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Dɛ'ɛ dichíí'vɛ̄ yeⁿ'e saⁿ'ā ndúúti chi diiⁿ sa ganar nducuéⁿ'ē chi vɛ́ɛ́ núúⁿmáⁿ iⁿ'yeeⁿdí 'cūū ní dindaí sa alma yeⁿ'e sa? ¿'Áá n'deēe cuuvi nadíí'vɛ sa 'áámá 'iiⁿ'yāⁿ cucáávā alma yeⁿ'e sa? ");
INSERT INTO cuxNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Naati 'úú chí Saⁿ'á chi Daiya Dendyuūs 'úú ní ndaá ndúúcū dɛɛvɛ ch'ɛɛtɛ n'dai yeⁿ'e Chiidá chi canée yā na va'ai chɛɛti nguuvi. Ní ndaá ndúúcū ángeles yeⁿ'é. Tuu'mi ní 'úú diíⁿ chi nadíí'vɛ ca'áámá ca'áámá yā tuunu tuunu ca chi n̄diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi vɛ́ɛ́ náⁿ'a nī chi snée nī 'muuⁿ chi nguɛ́ɛ́ 'cuūvi nī taanduvɛ́ɛ́ ndíí snaaⁿ nī Saⁿ'a chi Daiya Dendyuūs ndaa sá chi caaⁿ'maⁿ ntiiⁿnyuⁿ sa yeⁿ'e tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chó'ōo jaāⁿ nguuvi, ní Jesús candɛ́ɛ yā Pedro ndúúcū Jacobo ndúúcū Juan chi 'díínū Jacobo. Ní Jesús cueⁿ'é yā ndúúcū saⁿ'ā s'eeⁿ na 'áámá yiīcū yaacu. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ní Jesús n̄'dáaⁿ yā cuerpo yeⁿ'e maáⁿ yā nanááⁿ saⁿ'ā s'eeⁿ. Ní chín'gai naaⁿ yā tan'dúúcā 'yáⁿ'ā 'iicu catecai yā ní nduuvi cuɛ́ɛ̄ tan'dúúcā dɛɛvɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Cuin'diichí nī. Tuu'mí nūuⁿ che'enaāaⁿ Moisés ndúúcū profeta Elías. 'Iiⁿ'yāⁿ s'eeⁿ chi n'díí ndíí cuaaⁿ vmnaaⁿ ní nndeé yā ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tuu'mi ní Pedro caⁿ'a sá chii sa Jesús: Señor, dɛ'ɛ chúúcā n'dáacā yeⁿ'e yú chí 'cuɛɛtinée yú 'muuⁿ. Ndúútī chí neⁿ'é nī din'daí 'nū ná 'iīnū va'ai n'gaiyáā, 'áámá ní yeⁿ'é n'diī, táámá ní yeⁿ'e Moisés, táámá ní yeⁿ'e profeta Elías. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Taachí Pedro ngaⁿ'a sá chuū, 'áámá meēeⁿ cuɛ́ɛ̄ chí ngii yáⁿ'āa ndii sn'díī 'iiⁿ'yāⁿ s'eeⁿ ní discípulos ch'iindiveéⁿ yā 'áámá nduudu ná meēeⁿ miiⁿ chí ngaⁿ'ā: Sáⁿ'a 'cūū Daiyá chí neⁿ'e taaví ní yeenú cáávā sáⁿ'a 'cūū. 'Cu'neeⁿ veéⁿ nī yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Taachí discípulos ch'iindiveéⁿ yā nduudu 'cūū candiitín'dii yā ní dii'yaa n'dái yā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tuu'mi ní Jesús miiⁿ ndaa niiⁿnuúⁿ yā ní tuu'ví yā discípulos ní caⁿ'a yā: Nducueeⁿ nī. Nguɛ́ɛ́ 'va'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Taachí nducueeⁿ discípulos 'āā ntɛ́ɛ́ n'diichí yā du'ū vɛɛ caati 'āā dámaāaⁿ Jesús miiⁿ n'diichi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Taachi nangua'á yā yeⁿ'e yiīcū miiⁿ ní na yúúní naachí cunaⁿ'a yā, Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ cuuví yā mar 'áámá 'iiⁿ'yāⁿ yeⁿ'e chi n'diichí yā ndíí taachi Saⁿ'ā chi Daiya Ndyuūs nduuchí yā yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tuu'mi ní discípulos ntiinguunéeⁿ yā Jesús ní caⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chí ngaⁿ'a maestros yeⁿ'e ley chi canéé chí profeta Elías miiⁿ nndaa sa vmnaaⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús miiⁿ nán'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā discípulos: Cuaacu nííⁿnyúⁿ profeta Elías miiⁿ nndaá sá vmnááⁿ vmnaaⁿ ní 'cuundiyāaⁿ sa tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Naati 'úú ní ngaⁿ'á ngií ndís'tiī chi profeta Elías miiⁿ ní 'āā ndaá yā. Ní 'iiⁿ'yāⁿ s'uuⁿ nguɛ́ɛ́ tuumicadíínuuⁿ yā yeⁿ'e yā du'u chi Elías miiⁿ naati diíⁿ yā ndúúcū Elías miiⁿ tan'dúúcā chi neⁿ'e yā ní n'geenu sá ngii. 'Tiicá ntúūⁿ Saⁿ'ā chi Daiyá Ndyuūs 'cueenu sá cuuvi yeⁿ'e 'iiⁿ'yāⁿ s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tuu'mi ní discípulos tuumicádíínuuⁿ yā chí Jesús ngaⁿ'a yā ngii yā discípulos yeⁿ'e Juan chi chɛɛdínuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Taachí ndaá Jesús ndúúcū discípulos yeⁿ'e yā naachi snéé n'deee n'dáí 'iiⁿ'yāⁿ, tuu'mi ní ndaā 'áámá saⁿ'ā nanááⁿ Jesús ní chiintii'ya sá ní caⁿ'a sá: ");
INSERT INTO cuxNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Señor, nnéé ya'ai 'iinú nī daiyá ti sta'a ataques daiyá ní neené n'geenu sá ngii. Nééné n'deee cuūvi in'dáa nuūⁿ sa na yaⁿ'ā ní 'āā neené n'deēe cuūví chí in'dáa nuūⁿ sa nguaaⁿ nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ní 'āā chi nguú saⁿ'ā nanááⁿ discípulos yeⁿ'e nī naati nguɛ́ɛ́ ngii diíⁿ yā chi nduūvā yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā saⁿ'ā: Ndís'tiī 'iiⁿ'yāⁿ chi nguɛɛ i'téénu nī ndíí nguɛ́ɛ́ ndúú idiiⁿ n'daacá nī. ¿'Áá 'naaⁿ tiempo cánéé chi cuneé ndúúcu nī? ¿'Áá 'naaⁿ cuchɛɛ́ ndúúcū ndís'tiī? Candɛ́ɛ nī 'muuⁿ saⁿ'ā 'dííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús miiⁿ yaa'vi neeⁿ yā espíritu yeⁿ'e yááⁿn'guiinūuⁿ ní espíritu miiⁿ nan'dáa yeⁿ'e saⁿ'ā 'dííⁿ miiⁿ ní tuu'mí nūuⁿ ndúuvā yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tuu'mi ní discípulos ní ndaa yā nanááⁿ Jesús na 'áámá lado naachi nguɛ́ɛ́ snéé 'iiⁿ'yāⁿ ní caⁿ'a yā chii yā Jesús: ¿Dɛ'ɛ̄ cúúví chí nús'uū nguɛ́ɛ́ chiī tun'dáa 'nū espíritu yeⁿ'e yááⁿn'guiinūuⁿ miiⁿ yeⁿ'e saⁿ'ā 'díí? ");
INSERT INTO cuxNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús miiⁿ ní caⁿ'a yā chii yā discípulos: Nguɛ́ɛ́ ch'ɛɛtɛ vaadī i'téénu yeⁿ'e nī. Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi nduuti chi vɛ́ɛ́ vaadī i'téénú yeⁿ'e nī ní tan'dúúcā 'áámá duuti yeⁿ'é yiīvɛ̄ ntíi'yaá chi 'lííⁿ ca cuuvi nī yiīcū 'cúū: Yiīcū, cuvíi ndii 'muuⁿ ni cuéⁿ'é ndíí taama lugar. Ní yiīcū ní caⁿ'ā. Tanducuéⁿ'ē cuuvi diíⁿ nī nduuti chi cuaacu chi i'téénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Naati tanducuéⁿ'ē espíritus yeⁿ'e yááⁿn'guiinūuⁿ chi 'túúcā nguɛ́ɛ́ nan'daā yeⁿ'e 'iiⁿ'yāⁿ chi 'tiicá nūuⁿ caati dámaāⁿ ndúúcū chi ngaⁿ'angua'a yā ndúúcū chi nguɛɛ 'āā ca'diiⁿnúⁿ yā nguuvi chi ngaⁿ'angua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Taachi 'iiⁿ'yāⁿ s'eeⁿ snée yā na yáⁿ'āa Galilea Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: Saⁿ'ā chi Daiya Ndyuūs ní 'iiⁿ'yāⁿ canéé chi ca'a yā saⁿ'ā na tá'ā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ní 'iiⁿ'yāⁿ 'caaⁿ'nuⁿ yā saⁿ'ā miiⁿ naati saⁿ'a miiⁿ ndii chííⁿ ndii 'íínú nguuvi nduuchi sa yeⁿ'e nguaaⁿ tináⁿ'ā. Discípulos ní s'neeⁿ ndaachi yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Taachí ndaa Jesús ndúúcū discípulos yeⁿ'e yā na yáāⁿ Capernaum, 'iiⁿ'yāⁿ s'eeⁿ chi indaaca tuumī yeⁿ'e yaācū templo ní ndaá yā nanááⁿ Pedro miiⁿ. Ní caⁿ'a yā chii yā saⁿ'ā: ¿'Áá nguɛ́ɛ́ nadíí'vɛ̄ maestro yeⁿ'é nī tuūmī chi cáávā yeⁿ'ē yaācū templo? ");
INSERT INTO cuxNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro miiⁿ ní caⁿ'ā sa chi 'tíícā va. Taachí sndaa yā va'ai yeⁿ'e sa Jesús miiⁿ caⁿ'a yā ndúúcū Pedro: ¿Táácā chi ngíí yeⁿ'e di, díí Simón Pedro? ¿Du'ú nadíí'vɛ̄ impuestos yeⁿ'ē yáⁿ'āa nanááⁿ reyes yeⁿ'ē iⁿ'yeeⁿdí 'cūū? ¿'Áá daiya 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa naachi rey ngaⁿ'a ntiiⁿnyúⁿ yā nadíí'vɛ sa o 'iiⁿ'yāⁿ chi cuchii táámá lado? ");
INSERT INTO cuxNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro miiⁿ nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa chii sa Jesús: 'Iiⁿ'yāⁿ chi chiica táámá lado nadíí'vɛ yā. Jesús caⁿ'a yā chii yā Pedro: Daiya 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa naachi rey ngaⁿ'a ntiiⁿnyúⁿ yā miiⁿ ní nguɛ́ɛ́ canéé chí nadíí'vɛ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Nguɛ́ɛ́ neⁿ'e yú chi nduuvi taaⁿ yā. Maaⁿ ní cueⁿ'e di ná nuūⁿnīⁿ'yáⁿ'ā ní ca'nuuⁿ di 'áámá gancho yeⁿ'ē 'yaacā nguaaⁿ nuūⁿnīⁿ. 'Yaācā chí ndaācā di vmnááⁿ vmnaaⁿ cutá'a di ní nn'guaaⁿ di cheendí tī. Mííⁿ ní ndaāca di 'aama tuūmī. Ndúúcū tuūmī miiⁿ ní caⁿ'a di cá'ā di yeⁿ'ē 'úú ndúúcū yeⁿ'e maaⁿ di chí nadíí'vɛ yú yeⁿ'e yaācū templo. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nguuvi mííⁿ discípulos yeⁿ'e Jesús ndaá yā nanáaⁿ yā ní caⁿ'a yā chii yā Jesús: N'diī Jesús, ¿du'u cá chi ch'ɛɛtɛ cá naachi Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā na va'ai chɛɛti nguuvi? ");
INSERT INTO cuxNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús 'cai yā 'áámá saⁿ'ā 'lííⁿ ní ch'ííndi yā saⁿ'ā 'lííⁿ náávtaⁿ'a yeⁿ'e discípulos. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ní caⁿ'a yā: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī. Ndúúti chi ndís'tiī nguɛ́ɛ́ diíⁿ nī tan'dúúcā 'áámá saⁿ'ā 'lííⁿ nguɛ́ɛ́ cuuvi ndaa nī naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","'Tíícā 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi ndiicúūⁿ maáⁿ yā tan'dúúcā saⁿ'a 'lííⁿ 'cūū, 'iiⁿ'yāⁿ 'cúū chi ch'ɛɛtɛ ca yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi 'cuaáⁿ yā 'áámá saⁿ'ā 'lííⁿ ndúúcū chi duuchí, tuu'mi ní 'cuaáⁿ yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ní caⁿ'a Jesús: 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi diíⁿ yā chí 'áámá chɛɛ chí n'gaiyáā chi i'téénu yā 'úú dinuuⁿndí yā n'daācā ca cáávā 'iiⁿ'yāⁿ miiⁿ chi 'iiⁿ'yāⁿ s'eeⁿ cāchiichí yā 'áámá tuūu yúúdú chí íngúú 'iiⁿ'yāⁿ na daandú yā ní canuúⁿ yā 'iiⁿ'yāⁿ miiⁿ naachi yáanūuⁿ yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā ní 'iiⁿ'yāⁿ miiⁿ cun'dáá nuúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dɛ'ɛ chúúcā ndaachií yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū cáávā dendu'ū chi 'túúcā chi diiⁿ chí cuuvá yā na nuuⁿndi. 'Āā vɛ́ɛ́ nūuⁿ cosas chi 'tíícā naati dɛ'ɛ chúúcā ndaachií yeⁿ'e 'iiⁿ'yāⁿ chi diíⁿ yā chi táámá 'iiⁿ'yāⁿ cuuva yā na nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ní nduuti chi ta'a di o ca'a di idiīiⁿ chí dinuuⁿndí nī, 'caacá nī ta'a di o ca'a di ní divíi di. N'dáacā ca chi ndaa di ló'ō ta'a di o ló'ō ca'a di na vida cueⁿ'e daāⁿmaⁿ ní nguɛ́ɛ́ chi caⁿ'a di ndúúcū 'uūvi ta'a di o nduu 'uūvi ca'a di na infierno naachí nguuchi yaⁿ'ā chí 'áámá cūnee. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nduutí chí nduutináaⁿ di idiīiⁿ chi idinuuⁿndí di, tun'dáa di ní divíi di. N'daācā ca chí cunee di ndúúcū 'áámá nduutináaⁿ di nguɛ́ɛ́ ti chí cunee di ndúúcū nduu 'uūvi nduutináaⁿ di ní caⁿ'a di ná nguuchi yaⁿ'ā chí 'áámá cānee cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ní caⁿ'a Jesús: Tandii ra diíⁿ nī ndúúcū mar 'áámá da'caiyāa n'gaiyáā ní diíⁿ nī chi cuuvi dinuuⁿndí nī. Nguɛ́ɛ́ cunncáā diíⁿ nī yeⁿ'ē ti 'úú ngaⁿ'á ngií ndis'tiī chi ángeles yeⁿ'ē da'caīyaá snée yā ná va'ai chɛɛti nguuvi nanááⁿ Chiidá ni īnaaⁿ yā cucáávā da'caīyaá. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ti Saⁿ'ā Daiyá Ndyuūs miiⁿ ní ndaa sa chi nadinguáⁿ'ai sa chííⁿ chí níndáí. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Dɛ'ɛ̄ inadicádiinuuⁿ ndís'tiī? Nduuti chi 'áámá saⁿ'ā vɛ́ɛ́ 'áámá ciento 'iiti cuūchī yeⁿ'ē sa ní cuuvi ndáí 'áámá tī ¿'áá nguɛ́ɛ́ cū'neeⁿ sa 'iiti chí cuūⁿ ngɛɛcú ndítiiⁿ'yuⁿ cuúⁿ tī ní caⁿ'a sa cuááⁿ yiīcū miiⁿ ní cun'nuuⁿ sa 'áámá 'iiti chi nindáí miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndúúti chí ndaācā sa 'iiti, cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī ti yeenú taavi sa cáávā 'iiti chi níndai nguɛ́ɛ́ ti ndu'ū chí cuūⁿ ngɛɛcú ndítiiⁿ'yuⁿ cuúⁿ tī chi nguɛ́ɛ́ chi nindaí tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Tíícā Chiidá yú chi canée yā ná va'ai chɛɛti nguuvi nguɛ́ɛ́ neⁿ'e yā chi mar 'áámá chi n'gaiyáā s'ūuⁿ cuuvi ndáí. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","'Tiicá ntúūⁿ ngaⁿ'á ngií ndís'tiī: Ndúúti chi 'díínū di diiⁿ sa chi nguɛ́ɛ́ n'daācā ndúúcu di, cueⁿ'e di ní ndee di ndúúcu sa nguaaⁿ maáⁿ nī yeⁿ'e chi nguɛɛ n'daācā chi diiⁿ sa. Nduuti chi cu'neeⁿ veeⁿ sa yeⁿ'e di, 'āā nan'dáā n'daí di ndúúcū 'díínū di. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Naati nduuti chi nguɛ́ɛ́ cu'neeⁿ veeⁿ sa yeⁿ'e di 'cuai di ná 'uūvi o 'iīnu 'iiⁿ'yāⁿ. Ní chīi yā na 'uūvi yā o na 'iīnu yā chi 'caandiveéⁿ yā tanducuéⁿ'ē chí caaⁿ'maⁿ di ní vɛ́ɛ́ testigos yeⁿ'é di tan'dúúcā chi canéé nguūⁿ na ley. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ndúúti chi 'díinu di nguɛ́ɛ́ cu'nēēⁿ veeⁿ sa yeⁿ'é yā ndúúcu yeⁿ'e di cúúví dí 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē 'iiⁿ'yāⁿ chi i'téénu yā Ndyuūs. Ndúúti chi 'díinu di miiⁿ nguɛ́ɛ́ cu'nēēⁿ veeⁿ sa yeⁿ'é 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e 'iiⁿ'yāⁿ chi i'téénu yā Ndyuūs, cu'neeⁿ di 'díinū di tan'dúúcā 'áámá 'iiⁿ'yāⁿ ndiica yáⁿ'áí chi nguɛ́ɛ́ yeⁿ'ē ndaata yeⁿ'e di o tan'dúúcā chi 'aama saⁿ'ā chi inn'guɛɛ sa yeⁿ'ē yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: Tanducuéⁿ'ē chi nguɛ́ɛ́ 'cuaaⁿ nī chi 'iiⁿ'yāⁿ diíⁿ yā na iⁿ'yeeⁿdí 'cūū Ndyuūs chi canéé ná va'ai chɛɛti nguuvi nguɛ́ɛ́ 'cuaaⁿ ntuúⁿ yā. Tanducuéⁿ'ē chi 'cuáaⁿ nī chi 'iiⁿ'yāⁿ diíⁿ yā na iⁿ'yeeⁿdí 'cūū Ndyuūs chi canéé ná va'ai chɛɛti nguuvi 'cuaaⁿ ntuúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Taama vmnéⁿ'ēe ngaⁿ'á ngií ndís'tiī: Nduuti chi ná 'uūvi ndís'tiī nduuvidaamá nī ná yáⁿ'āa 'cūū yeⁿ'e 'āā dɛ'ɛ́ nūuⁿ chi caacá nī yeⁿ'ē Chiidá chi canée yā na va'ai chɛɛti nguuvi, Chiidá tée yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tiī naachí snéé 'uūvī o 'iīnu 'iiⁿ'yāⁿ chi nduuvidaama yā cucáávā chi duuchí, miiⁿ caneé nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tuu'mi ní ndaā Pedro miiⁿ nanááⁿ Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: N'dií Señor, ¿'áá n'deēe cuūví caneé chí nádich'ɛɛ̄cú yeⁿ'ē 'diīnú chi nguɛ́ɛ́ n'daācā idiiⁿ sa nduucú? ¿'Áá ndɛɛ̄chɛ̄ cuūví? ");
INSERT INTO cuxNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús caⁿ'a yā chii yā Pedro: Nguɛ́ɛ́ ngaⁿ'á ngií dii chi ndɛɛ̄chɛ̄ cuuvi tiī 'iīnū ngɛɛcu ndiichi veces chi ndɛɛ̄chɛ̄ ngaⁿ'á ngií dii. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ní caⁿ'a Jesús: 'Tíícā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ná va'ai chɛɛti nguuvi ní tan'dúúcā 'áámá rey chí neⁿ'e yā tun'dáa yā cuenta ndúúcū mozos yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Taachí neⁿ'e yā tuca'a yā tun'daa yā cuenta, candɛ́ɛ yā 'áámá mozo yeⁿ'é rey nanáaⁿ yā chi can'diicū sa n'deee n'dáí mil tuūmī. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mozo miiⁿ ní nguɛ́ɛ́ cuuvi diiⁿ sá nadíí'vɛ̄ sa. Tuu'mi ní rey chi 'iiví sa caⁿ'a yā chii yā táámá mozo miiⁿ chí n'diicui sa mozo ndúúcū n'daatāá yeⁿ'ē sa ndúúcū daiya sa ndúúcū tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē sa ní nadíí'vɛ̄ mozo miiⁿ chi can'díícū sa yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tuu'mi ní mozo miiⁿ candiitin'díī sa nanááⁿ 'iivi sa ní di'cuíítu sa 'iiⁿ'yāⁿ ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: N'dií Señor, cunee ngíínú nī 'áámá tiempo ní 'úú ní nadíí'vɛ́ tanducuéⁿ'ē yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","'Iivi sa miiⁿ ní nneé ya'ai 'iinu yā saⁿ'ā ní caⁿ'a yā chii yā saⁿ'ā: Cunaⁿ'ā di ní 'āā ntɛ́ɛ́ cun'diīcū di yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sáⁿ'a 'cūū cuínaⁿ'a sa ní nan'daā sa ní ndaācā sa mozo chi daama idiiⁿ sa ntiiⁿnyuⁿ ndúúcū sa. Táámá mozo miiⁿ can'díícu ntúūⁿ sa 'aama ciento tuūmī yeⁿ'ē sa. Ní mozo miiⁿ chita'ā sa daandu sáⁿ'ā miiⁿ ní tucá'a sa chiī sa yaācū sa ní caⁿ'a sa: Nadíí'vɛ̄ di chi can'díícu di. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tuu'mi ní mozo miiⁿ candiitín'diī sa nanáaⁿ sa ní caⁿ'a sa chii sa: Cunee ngíínú dí 'tɛ́ɛ́ ní nadii'vɛ́ yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Naati saⁿ'ā miiⁿ nguɛ́ɛ́ 'cuūⁿ sa. Cheⁿ'e sa chiica sa nuūⁿndī yeⁿ'e mozo miiⁿ ndúúcū sa ní s'nuúⁿ yā mozo vácūū ndíí nadíí'vɛ̄ sa chi cán'díícū sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tanáⁿ'ā mozos ndúúcū sa n'diichi yā chi chiī ní s'neeⁿ ndaachi yiinú yā. Ní cheⁿ'e yā nanááⁿ 'iivi yā ní caⁿ'a yā chii yā 'iiví yā tanducuéⁿ'ē chí chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tuu'mi ní 'iiví mozos 'cai yā mozo 'cūū chi ndaa sa nanáaⁿ yā. Ní caⁿ'a yā chii yā mozo miiⁿ: Dii mozo, nguɛ́ɛ́ n'daācā di. Tanducuéⁿ'ē chí can'díícū di yeⁿ'é 'āā chií dii chi 'āā ntɛ́ɛ́ nadíí'vɛ̄ di ti di'cuíítu di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿'Áá nguɛ́ɛ́ nnee ya'āī 'iinu di mozo ndúúcū di tan'dúúcā chi 'úú nneé ya'ai 'iinú dii? ");
INSERT INTO cuxNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tuu'mi ní nduuvi taáⁿ 'iivi sa ní chiicá yā nuūⁿndī yeⁿ'ē sa. Ní cueⁿ'e sa vácūū chi ch'eⁿ'é yā saⁿ'ā ní miiⁿ canee sa ndii nadíí'vɛ̄ sa tanducuéⁿ'ē chi can'díícū sa yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'Tiicá ntúūⁿ Chiidá chi canéé na va'ai chɛɛ̄ti nguuvi 'tíícā diíⁿ yā ndúúcū ndís'tiī nduuti chi ndís'tiī ní nguɛ́ɛ́ nadich'ɛɛcú nī ndúúcū nuuⁿmaⁿ staava yeⁿ'e nī yeⁿ'e 'áámá 'áámá 'díínu nī yeⁿ'e chi nguɛ́ɛ́ n'daācā n̄diíⁿ yā ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Taachí Jesús ch'íínú caⁿ'a yā ndúúdú 'cūū chiicá yā na yáⁿ'āa Galilea ní cueⁿ'e yaⁿ'ai cá yā na yáⁿ'āa yeⁿ'e Judea chi táámá lado yeⁿ'e yíícú Jordán. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nééné 'yaaⁿ 'iiⁿ'yāⁿ cueⁿ'é yā n'daa yā Jesús miiⁿ ní Jesús diíⁿ yā chi nduūvā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ chi ngiītā. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tuu'mi ní 'iiⁿ'yāⁿ fariseos ndaá yā nanááⁿ Jesús miiⁿ ti neⁿ'é yā chi n'diichíneeⁿ yā Jesús miiⁿ. Ní ngaⁿ'a yā ngiī yā 'iiⁿ'yāⁿ: N'diī Jesús, ¿'áá canéé ná ley chí saⁿ'ā ní cu'neeⁿ sa n'daataá yeⁿ'ē sa chi nguɛ́ɛ́ ch'ɛɛtɛ dɛ'ɛ̄ chi n̄diiⁿ tá? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús miiⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá nguɛ́ɛ́ n'geeⁿ nī naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs naachí ngaⁿ'ā chi Ndyuūs din'dái yā taanduvɛ́ɛ́ cosas ndíí cuááⁿ vmnaaⁿ ní din'dái yā saⁿ'ā ndúúcū n'daataá? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ní caⁿ'a yā: Chííⁿ chí saⁿ'ā cu'neeⁿ sá chiida sa ndúúcū chɛɛcu sá ní ndūūvidaama sa ndúúcū n'daataá yeⁿ'ē sa ní nduu 'uuví yā ní nduūvī 'aama yā nduucū vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tuu'mi ní 'āā ntɛ́ɛ́ 'uuvī ngii yā tí 'āā 'aama núúⁿ yā. Chííⁿ chí Ndyuūs nádaama yā, 'iiⁿ'yāⁿ nguɛɛ cánéé chí idivíi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Iiⁿ'yāⁿ fariseos caⁿ'a yā chii yā Jesús: ¿Dɛ'ɛ cáávā chi Moisés caⁿ'a ntiiⁿnyuⁿ sa chí ca'á yā carta chí i'tɛɛchi vi'i yā ní cu'neéⁿ yā n'daataá yeⁿ'e yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ fariseos: Moisés miiⁿ ní 'cuūⁿ sa chi s'neeⁿ saⁿ'ā n'daataá yeⁿ'e sa cucáávā chi staava yeⁿ'e sa ní nééné chɛɛchi. Naati cuááⁿ vmnaaⁿ naachí chi nga'a, nguɛɛ 'tíícā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'Úú ní ngaⁿ'á ngií ndís'tiī chí 'āā du'ú nūuⁿ saⁿ'ā chi cu'neeⁿ sa n'daataá yeⁿ'ē sa ndúúti chi nguɛ́ɛ́ cáávā chí cueⁿ'e tá ndúúcū taama saⁿ'ā ní saⁿ'ā miiⁿ cunee sa ndúúcū taama tá, vɛ́ɛ́ nuūⁿndī yeⁿ'ē sa. Sáⁿ'ā chi 'caandavaacu sa ndúúcū n'daataá chi s'neeⁿ tá isaⁿ'ā yeⁿ'ē tá, vɛ́ɛ́ ntúūⁿ nuuⁿndi yeⁿ'ē sa chi adulterio. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tuu'mi discípulos yeⁿ'e Jesús ní caⁿ'a yā chii yā Jesús: Ndúúti chi saⁿ'ā miiⁿ cú'neeⁿ sa n'daataá yeⁿ'ē sa tuu'mi ní n'daācā ca chi nguɛ́ɛ́ 'caandavaacu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā discípulos: Nguɛ́ɛ́ nducyaaca 'iiⁿ'yāⁿ cuuvi deenu yā chuū naati 'āā dámaāⁿ 'iiⁿ'yāⁿ chí Ndyuūs nca'a yā chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vɛ́ɛ́ 'yaaⁿ razones chi nguɛ́ɛ́ 'caandavaacu saⁿ'ā. Vɛ́ɛ́ saⁿ'a chí ndii taachi n'giindiyáaⁿ sa yeⁿ'ē chɛɛcu sa 'āā nguɛ́ɛ́ cuuvi 'caandavaacu sa. Ní vɛ́ɛ́ ntúūⁿ saⁿ'ā eunucos chi 'iiⁿ'yāⁿ idiíⁿ yā chi nguɛ́ɛ́ cuuvi 'caandavaacu sa. Vɛ́ɛ́ ntúūⁿ saⁿ'ā chi maaⁿ sa nguɛ́ɛ́ neⁿ'e sa 'caandavaacu sa cáávā chi diiⁿ sa ntiiⁿnyuⁿ yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Nduuti chi 'iiⁿ'yāⁿ cuuvi ca'cueeⁿ yā nduudú 'cūū tuu'mi ní 'āā deenú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tuu'mi ní ndaa 'iiⁿ'yāⁿ chi ndɛɛ yā da'cáíyāa nanááⁿ Jesús. Ní 'íícú Jesús miiⁿ cun'du'ú yā ta'a yā vmnááⁿ yeⁿ'ē da'caīyāa s'eeⁿ ní caⁿ'angua'á yā yeⁿ'ē dá'caīyāa. Discípulos yaa'vi néeⁿ yā 'iiⁿ'yāⁿ chí índaa ndúúcū dá'caīyāa. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús miiⁿ ní caⁿ'a yā chii yā discípulos: 'Cuaáⁿ nī chí chiī da'caīyāa nanaáⁿ. Nguɛ́ɛ́ caaca taaⁿ nī yeⁿ'ē da'caiyāa s'tíī ti naachí Ndyuūs chi canéé na va'ai chɛɛti nguuvi ngaⁿ'a ntiiⁿnyúⁿ yā ní yeⁿ'ē da'caiyāa s'tíī. 'Tííca chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ch'iinu chin'du'ū ta'á yā vmnaaⁿ yeⁿ'ē da'caiyāa s'eeⁿ ní chiicá yā lugar miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tuu'mi ní ndaā 'áámá saⁿ'ā 'dííⁿ nanááⁿ Jesús miiⁿ ní caⁿ'a sa chii sa Jesús: N'diī maestro chí n'dai, ¿dɛ'ɛ̄ chi n'dáacā chi cuuví diíⁿ ní cuuví ndaācá vida cueⁿ'e daāⁿmaⁿ chi cuuvi yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús caⁿ'a yā chii yā saⁿ'ā 'dííⁿ miiⁿ: ¿Dɛ'ɛ̄ cúúví chí ngaⁿ'ā di chi n'dai 'úú? Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ n'dai yā ti dámaáⁿ Ndyuūs. Naati ndúúti chi neⁿ'e di cundaā di na va'ai chɛɛti nguuvi naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā, idiiⁿ di tan'dúúcā chi ngaⁿ'a mandamientos. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Saⁿ'ā 'dííⁿ mííⁿ ní caⁿ'a sa: ¿Chɛɛ́ chííⁿ? Jesús caⁿ'a yā: Nguɛ́ɛ́ 'caāⁿ'nūⁿ di. Nguɛ́ɛ́ caⁿ'a di ndúúcū 'aama n'daatáá chi nguɛ́ɛ́ yeⁿ'ē di. Nguɛ́ɛ́ diduucú di. Nguɛ́ɛ́ caaⁿ'maⁿ di nduudu yaadi yeⁿ'é mar 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Dinéⁿ'e di chɛɛcu di ndúúcū chiida di. Dinéⁿ'e di 'iiⁿ'yāⁿ na niiⁿnuúⁿ vaacú di tan'dúúcā chi neⁿ'e di maāⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Saⁿ'ā 'dííⁿ miiⁿ ní caⁿ'ā sa: Tanducuéⁿ'ē chuū 'āā idiíⁿ ndíí taachi saⁿ'ā 'lííⁿ 'úú. ¿Dɛ'ɛ̄ cá indai yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús caⁿ'a yā chii yā saⁿ'ā: Ndúúti chi neⁿ'e di chi cúúví n'dai ca di tuu'mi ní cueⁿ'e di ní n'diicui di tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē di ní ca'a di 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā. Tuu'mi ní ndaācā chi vɛ́ɛ́ vaadī 'cuiica yeⁿ'ē ná va'ai chɛɛti nguuvi chi cuuví yeⁿ'ē di. Ní cuchíi di ní caⁿ'a di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Taachí saⁿ'ā 'dííⁿ miiⁿ ch'iindiveeⁿ sa chuū, cunáⁿ'a sa ní s'neeⁿ ndaachi yiinú sa ti neené 'cuiica sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chí ngíⁿ'īi chí cundaā 'áámá saⁿ'ā 'cuiica naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Táámá cosa ngaⁿ'á ngií ndís'tiī chi 'ááma iti camello chí ch'ɛɛtɛ ca nguɛ́ɛ́ ti 'yuudūu 'tiicá tī, nguɛ́ɛ́ ngíⁿ'īi ca chi cho'ó tī na nduutinááⁿ 'iini chi cheendi va'ai 'lííⁿ nguɛ́ɛ́ ti 'áámá 'iiⁿ'yāⁿ 'cuiica cu'téénu yā Ndyuūs ní cundáa yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Taachí ch'iindiveéⁿ discípulos yeⁿ'é yā chuū, nééné nadicádíínuuⁿ yā ní caⁿ'a yā nguááⁿ maaⁿ yā: ¿Du'u cuuví nanguaⁿ'āī? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús ch'íínu yā discípulos ní caⁿ'a yā: Saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū ní nguɛ́ɛ́ cuuví diiⁿ sa chuū naati Ndyuūs cuuví diíⁿ yā tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tuu'mi ní Pedro miiⁿ ní nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa chii sa Jesús: N'diī Señor, cuin'diichí nī. Nús'ūū ní sn'néeⁿ 'nū tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'é 'nū ní cuchií 'nū ndúúcū n'diī. ¿Dɛ'ɛ́ ndaācā yeⁿ'é 'nū? ");
INSERT INTO cuxNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús caⁿ'a yā chii yā discípulos: Cuaacu nííⁿnyúⁿ, ngaⁿ'á ngií ndís'tiī, chi tiempo chí cuchiī taachí nducuéⁿ'ē nduuví ngai ní Saⁿ'a chi Daiyá Dendyuūs 'cuūndī sa na trono yeⁿ'ē sa ndúúcū dɛɛvɛ ch'ɛɛtɛ yeⁿ'e maaⁿ sa ní 'cuai sa ndís'tiī chi cueⁿ'e nī ndúúcu sa. Ní ndís'tiī ní 'cuɛɛtɛ́ nī na ndiichuuvi tronos ní diíⁿ nī juzgar ndu'u ndiichúúví ndaata yeⁿ'e 'iiⁿ'yāⁿ Israel chi judíos yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Āā du'ú nūuⁿ chi cu'neeⁿ ná vaacu yā o 'díínu yā o ví'i yā o chiidá yā o chɛɛcú yā o n'daataá yeⁿ'e yā o daiya yā o yáⁿ'āa yeⁿ'e yā cáávā chi duuchí, 'iiⁿ'yāⁿ miiⁿ ndaāca cá yā táámá ciento más cá. Ní Ndyuūs ca'á yā 'iiⁿ'yāⁿ miiⁿ vida cueⁿ'e daāⁿmaⁿ yeⁿ'e yā ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nééné 'yaaⁿ 'iiⁿ'yāⁿ chi maaⁿ snée yā cuááⁿ chi vmnaaⁿ ní 'iiⁿ'yāⁿ s'eeⁿ 'cuɛɛtinée yā cuaaⁿ chi cuayiivi ní nééné 'yaaⁿ 'iiⁿ'yāⁿ chi maaⁿ snée yā cuaaⁿ chi cuayiivi ní 'iiⁿ'yāⁿ s'eeⁿ 'cuɛɛtinée yā cuaaⁿ chi vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Caⁿ'a Jesús: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e na va'ai chɛɛti nguuvi ní tan'dúúcā 'áámá dueño chi vɛ́ɛ́ yáⁿ'āa yeⁿ'e yā. Dueño miiⁿ ní can'dáa yā cuaaⁿ ná nguɛɛtiyaaⁿ chí in'nuuⁿ yā mozos chi diiⁿ ntiiⁿnyuⁿ naachi vɛ́ɛ́ díí'yú uvas yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ní indeé yā ndúúcū mozos taaca chi nadíí'vɛ yā mozos. Ní caⁿ'a yā chi ca'a yā 'aama caadi plata nguuvi miiⁿ ní dicho'ó yā mozos miiⁿ chi diiⁿ sa ntiiⁿnyuⁿ naachi vɛ́ɛ́ díí'yú uvas yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Dueño miiⁿ can'dáa yā na vaacu yā taandúú cuááⁿ nááⁿ n'gɛɛcú nuuuⁿ nguɛɛtiyaaⁿ ní cuéⁿ'e yā cuaaⁿ nii'vɛ̄ɛ̄ ní n'diichi yā ta n'duuvi sáⁿ'ā chi snée sa chi nguɛ́ɛ́ ndaācā ntiiⁿnyuⁿ yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ní caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Ndís'tiī, cuéⁿ'e nī diíⁿ nī ntiiⁿnyuⁿ yeⁿ'é naachi vɛ́ɛ́ díí'yú uvas yeⁿ'é. 'Úú ní nadíí'vɛ́ ndís'tiī tan'dúúcā chí tuumicadiinúúⁿ chí n'daācā. Saⁿ'ā s'eeⁿ ní cueⁿ'e sa diiⁿ sa ntiiⁿnyúⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ní can'dáá ntuuⁿ yā taandúú cuááⁿ naaⁿ ingyáⁿ'ā. 'Tiicá ntúūⁿ cun'daa yā táánduu cuaaⁿ nááⁿ n'gɛɛcú 'íínú chiīnū, 'tiicá ntúūⁿ diíⁿ yā n'nuúⁿ yā mozos chi diiⁿ sa ntiiⁿnyuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ní taandúū n'gɛɛcu juⁿ'u chiīnū cueⁿ'e ntúuⁿ yā ní ndaācá yā taanduu 'uuvi saⁿ'ā chi nguɛ́ɛ́ índaācā ntiiⁿnyuⁿ yeⁿ'e sā. Ní caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí ndís'tiī snée nī 'muuⁿ ní núúⁿmáⁿ nguuvi chi nguɛ́ɛ́ ntiiⁿnyuⁿ chi idiíⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Saⁿ'ā s'eeⁿ caⁿ'a sa: Ti mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ tee yā ntiiⁿnyuⁿ yeⁿ'é 'nū. Dueño miiⁿ caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Ndís'tiī, cueⁿ'é nī diíⁿ nī ntiiⁿnyuⁿ naachi vɛ́ɛ́ díí'yú uvas yeⁿ'é ní nadii'vɛ́ ndís'tiī tan'dúúcā chi ituumicádiīnúúⁿ chi n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Taachí cueⁿ'e yā 'yáⁿ'āa, dueño miiⁿ naachí vɛ́ɛ́ díí'yú uvas miiⁿ caⁿ'a yā chii yā saⁿ'a chi ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'e mozos: 'Cuai dí mozos ní nadíí'vɛ̄ di mozos chi ndaa sa cuayiivi. 'Cuiinu maaⁿ ní nadíí'vɛ̄ di mozos chi ndaa sā cuayiivi. 'Cuiinu maaⁿ ní nadíí'vɛ̄ di mozos chi ndaa sā cuayiivi 'tɛɛ 'tɛ́ɛ́. 'Cuiinu maaⁿ ní nadíí'vɛ̄ di mozos chi ndaa sā vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ndaa mozos chi cheⁿ'e sā na ntiiⁿnyuⁿ miiⁿ taanduu na n'gɛɛcú juⁿ'u chiīnū ní nadíí'vɛ̄ sa mozos. 'Áámá 'áámá sā ndaāca sā 'áámá caadi plata yeⁿ'é sā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Taachí ndaa mozos chi cheⁿ'e sā vmnaaⁿ ná ntiiⁿnyuⁿ miiⁿ, nadacádiinuuⁿ sā n'deēe cá tuūmī ndaāca sā. Mozos ntúūⁿ ndaāca sā 'áámá caadi tuūmī yeⁿ'e sā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Taachí nadíí'vɛ sā mozos ní neené n'deee caⁿ'a mozos yeⁿ'e dueño yeⁿ'e naachi vɛ́ɛ́ díí'yú uvas miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mozos ní caⁿ'a sa: Sáⁿ'a s'tīī ti 'āā 'ai chiīnū ndaā sa ní 'áámá hora nūuⁿ diiⁿ sa ntiiⁿnyuⁿ ní dáámá nūuⁿ nadíí'vɛ nī sáⁿ'a s'tīī ndúúcū nús'uū. Nús'uū ní diíⁿ 'nū ntiiⁿnyuⁿ ní ch'ɛɛtinée 'nū na 'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Dueño miiⁿ ní nan'guɛɛcútaⁿ'á yā ní caⁿ'a yā chii yā 'áámá chɛɛ mozos: Ndís'tiī saⁿ'ā chí n'dai nduucú, nguɛ́ɛ́ nduuví taaⁿ di nduucú. Nguɛ́ɛ́ cunncáā idiíⁿ nduucú ndís'tiī. ¿'Áá nguɛ́ɛ́ ndeé ndúúcu nī chí nadii'vɛ́ ndís'tiī 'áámá caadi plata ní 'āā canéé yiinú nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cuta'á nī chí tunééⁿ ndis'tiī ní cunaⁿ'a nī. 'Úú ní nadicádiīnúúⁿ chí nadii'vɛ́ mozos chí ndaā sa cuayiivi tan'dúúcā chí nadii'vɛ́ ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿'Áá nguɛ́ɛ́ cuuvi diiⁿ 'úú tan'dúúcā chi neⁿ'é ndúúcū tuūmī yeⁿ'é? ¿'Áá ngíí nguee nī ti 'úú ní n'daí? ");
INSERT INTO cuxNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","'Túúcā 'iiⁿ'yāⁿ chi snéé cuááⁿ vmnááⁿ 'cuɛɛtinée yā ndii cuaaⁿ cuayiivi. 'Iiⁿ'yāⁿ chi snéé cuayiivi ní 'cuɛɛtinée yā cuáaⁿ vmnaaⁿ ti nééné 'yaaⁿ n'deeé 'iiⁿ'yāⁿ chi 'cai Ndyuūs naati duu'vīi 'iiⁿ'yāⁿ chi ndɛɛvɛ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús cuchɛɛ yā na yáāⁿ Jerusalén ní cueⁿ'é yā ndúúcū ndu'ū ndiichúúví discípulos yeⁿ'é yā 'áámá lado. Ní Jesús caⁿ'a yā chii yā discípulos taachi ngiicá yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ndís'tiī ní maaⁿ ní cuchɛɛ yú na yáāⁿ Jerusalén miiⁿ. 'Úú chi Saⁿ'ā chi Daiya Dendyuūs 'iiⁿ'yāⁿ s'eeⁿ nca'á yā 'úú tá'āa chiiduú n'gɛɛtɛ́ ndúúcū maestros chí ngi'cueeⁿ ley. 'Iiⁿ'yāⁿ s'eeⁿ ní diíⁿ yā condenar 'úú ní 'cuūví. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ní nca'a yā 'úú ta'a 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ndaata yeⁿ'e 'iiⁿ'yāⁿ Israel. 'Iiⁿ'yāⁿ s'eeⁿ ní 'cááⁿnyuⁿneeⁿ yā 'úú ní 'cueⁿ'e yā 'úú ní cu'neeⁿnga'á yā 'úú. Ní 'úú chí Saⁿ'ā chi Daiya Ndyuūs miiⁿ nanduuchí ndiichi ndii 'íínú nguuvi yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tuu'mi ní ndaā n'daataá yeⁿ'e saⁿ'ā Zebedeo nanááⁿ Jesús miiⁿ ndúúcū daiya tá ní chiintii'ya tá nanááⁿ Jesús miiⁿ ní dich'ɛɛtɛ tá 'yā ní chiica ta 'áámá favor. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús ní caⁿ'a yā: ¿Dɛ́'ɛ neⁿ'ē di? Táⁿ'ā miiⁿ ní caⁿ'a tá: Taachí ndaa di naachí caaⁿ'maⁿ ntiiⁿnyuⁿ di, caaⁿ'maⁿ ntiiⁿnyuⁿ di chi ndúú 'uūvī saⁿ'ā daiyá 'cuɛɛtɛ sa 'diituu dí, 'aama sa ní lado tá cuaacu di ní taama sa ní lado tá 'cuée di. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tuu'mi ní Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: Nguɛ́ɛ́ déénu nī dɛ'ɛ̄ chi ngiica nī. ¿'Áá cuuvi diiⁿ nī chí cú'u nuúⁿ nī yeⁿ'e chi n'geeⁿ yeⁿ'e vaso chi yeⁿ'ē chi 'cueenú cuuvi? ¿'Áá cuuvi cuta'á nī maaⁿ ngɛɛ̄dínuūⁿnīⁿ chi cuta'á? Juan ndúúcū Jacobo miiⁿ ní ngaⁿ'a yā chi cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús miiⁿ caⁿ'a yā chiī yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ canéé chí cu'ú nī yeⁿ'e vaso yeⁿ'é yeⁿ'e chi 'cueenú cuuvi ní canéé chí cuta'á nī chí chɛɛ̄dínuūⁿnīⁿ chi 'úú ita'á. Naati nguɛ́ɛ́ tunééⁿ 'úú chí ca'á du'ū chi 'cuundi lado tá cuaācú o lado tá 'cuēe. Lugar 'cūū ní Ndyuūs ca'á yā 'iiⁿ'yāⁿ chi Ndyuūs 'cuundiyaáⁿ yā cáávā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Taachí ndu'u ndííchí discípulos ch'iindiveéⁿ yā chuū, nduuvi taáⁿ yā yeⁿ'e nduu 'uūvi discípulos chí daiya saⁿ'ā Zebedeo. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tuu'mi ní Jesús yaa'ví yā discípulos ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Āā deenu ndís'tiī chí 'iiⁿ'yāⁿ yeⁿ'e naciones chi ngaⁿ'a ntiiⁿnyuⁿ vɛɛ poder yeⁿ'é yā nguaaⁿ 'iiⁿ'yāⁿ yeⁿ'e naciones yeⁿ'é yā. Ní 'iiⁿ'yāⁿ chi n'gɛɛtɛ cá yeⁿ'ē naciones ní ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e tanáⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Naati nguɛ́ɛ́ 'tíícā cuuvi nguaaⁿ ndis'tiī. Saⁿ'ā chí neⁿ'e sa cúúví ch'ɛɛtɛ sa nguaaⁿ ndís'tiī canéé chí dichíí'vɛ sa ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Saⁿ'ā chi neⁿ'e sa cūnee cuaaⁿ vmnaaⁿ ca yeⁿ'e ndís'tiī canéé chí dichíí'vɛ ca sa ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Naati Saⁿ'ā chi Daiya Ndyuūs nguɛ́ɛ́ ndaā sa chi 'ííⁿ'yāⁿ dichíí'vɛ yā saⁿ'ā ti maāⁿ sa dichíí'vɛ sa 'iiⁿ'yāⁿ, ní chi ca'a sa vida yeⁿ'ē maaⁿ sa tan'dúúcā chi precio yeⁿ'ē nuuⁿndi cáávā chi nadanguaⁿ'ai yā 'yaaⁿ n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Taachí Jesús ndúúcū discípulos yeⁿ'é yā can'daa yā yeⁿ'e yáāⁿ Jericó nééné 'yaaⁿ 'iiⁿ'yāⁿ can'dáa yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","'Uuvi saⁿ'ā chi ngueenááⁿ chi vɛɛ̄tɛ sa niiⁿnuúⁿ cyúúní taachí ch'iindiveeⁿ sa chi Jesús cho'ó yā miiⁿ, 'cai yiicú sa ní caⁿ'a sa: N'diī Señor, Daiya David, nneé ya'ai 'iinu nī nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nééné 'yaaⁿ 'iiⁿ'yāⁿ yaa'vi neeⁿ yā saⁿ'a s'eeⁿ chi cunēē 'diiiⁿ cheendi sa naati saⁿ'a s'eeⁿ ní n'gaī yiicú cá sa: N'dii Señor, Daiya David, nnéé ya'āī 'iinu nī nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús miiⁿ cheendii yā ní 'cai yā saⁿ'ā s'eeⁿ ní caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: ¿Dɛ'ɛ̄ neⁿ'é nī chi 'úú diíⁿ ndúúcu nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Saⁿ'ā s'eeⁿ ní caⁿ'a sa: N'diī Señor, diíⁿ nī chí snaaⁿ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tuu'mi ní Jesús, Daiya David, nnéé ya'ai 'íínu yā saⁿ'ā s'eeⁿ ní tuu'ví yā nduutináaⁿ sa. Ní hora mííⁿ nūuⁿ nduutináaⁿ sa nnguaaⁿ ní chiī snaaⁿ sa. Saⁿ'ā s'eeⁿ ní cueⁿ'e sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Taachi Jesús ndaa niiⁿnuúⁿ yā na yáāⁿ Jerusalén ní ndaa yā ná yiīcū chi nguuvi Olivos chí yeⁿ'ē yáāⁿ 'lííⁿ chi nguuvi Betfagé, dichó'o yā na 'uūvī discípulos yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ní caⁿ'a yā chii yā discípulos: Cueⁿ'e nī na yáāⁿ 'lííⁿ chi canéé niiⁿnuúⁿ. Miiⁿ ní ndaaca nī 'áámá burra chí n'dɛɛ̄chiichí tī ndúúcū daiya tī. Ndís'tiī ní n'daatí nī 'iiti ní candɛ́ɛ nī 'iiti 'muuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ní ndúúti chi 'áámá 'iiⁿ'yāⁿ yaa'vi yā ndís'tiī yeⁿ'e 'iiti miiⁿ, caaⁿ'maⁿ nī cuuvi nī 'iiⁿ'yāⁿ ti Señor yeⁿ'e yú neⁿ'e yā 'iiti miiⁿ. Ní 'iiⁿ'yāⁿ miiⁿ caama nadīcho'ó yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tanducuéⁿ'ē 'túúcā chiī ní 'iicu cuuví cuaacu chí caⁿ'a profeta chi ndɛɛ yā nduudu yeⁿ'é Ndyuūs ndii cuááⁿ vmnaaⁿ taachí dinguúⁿ yā chuū na libro yeⁿ'e Ndyuūs: ");
INSERT INTO cuxNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cuuví nī 'iiⁿ'yāⁿ chi snée yā na yáāⁿ Sión 'tíícā. Cun'diichí nī, Rey yeⁿ'e nī cuchií yā nanáaⁿ nī. Rey miiⁿ ní ndiicuúⁿ yā ní canduú yā burra 'lííⁿ. Ní burra 'lííⁿ ní daiya 'iitī chi candéé. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Discípulos cueⁿ'e yā ní diíⁿ yā tan'dúúcā chi Jesús miiⁿ dichó'o yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ní candɛɛ yā burra miiⁿ ndúúcū daiyá tī. Ní sn'duú yā cotón yeⁿ'é yā vmnááⁿ yeⁿ'ē burra 'lííⁿ. Ní Jesús miiⁿ ní canduú yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","'Iiⁿ'yāⁿ chí n'deee n'dáí n'doo yā cotón yeⁿ'é yā cuaaⁿ cyúúní. Tanáⁿ'a yā ch'iica yā dúuⁿnɛ̄ yáⁿ'á ní n'doo yā cuaaⁿ cyúúní. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Iiⁿ'yāⁿ chí cueⁿ'e yā cuááⁿ vmnaaⁿ ndúúcū 'iiⁿ'yāⁿ chi cueⁿ'e yā cuaaⁿ dáámí yā tucá'a yā 'cai yiicú yā, ní caⁿ'a yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ n'dai 'iiⁿ'yāⁿ chi Daiya rey David. Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chí cuchii ndúúcū chi duuchi Señor miiⁿ. Dich'ɛɛtɛ yú Ndyuūs chi snée ná va'ai chɛɛ̄tī nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Taachí Jesús miiⁿ sndaa yā na yáāⁿ Jerusalén nducyáácá 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ tuumicadíínuuⁿ yā ní caⁿ'a yā nguaaⁿ maaⁿ yā: ¿Du'u rá sáⁿ'a 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'Iiⁿ'yāⁿ mííⁿ ngaⁿ'a yā: Sáⁿ'a 'cūū saⁿ'a profeta Jesús chí cuchiī sá cuaaⁿ na yáāⁿ Nazaret yeⁿ'e yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús miiⁿ sndáa yā ná yaācū templo yeⁿ'é Ndyuūs ní tun'dáa yā nducyaaca 'iiⁿ'yāⁿ chí in'diicui yā ndúúcū 'iiⁿ'yāⁿ chi ngái yā na yaācū miiⁿ. Ní chɛɛcundaa yā mesas yeⁿ'e 'iiⁿ'yāⁿ chi n̄'dáaⁿ yā tuūmī yeⁿ'e 'iiⁿ'yāⁿ. Ní chɛɛcú yā sillas yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ chi in'diicui yā 'yáádá palomas. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Na libro yeⁿ'e Ndyuūs naachi canéé nguūⁿ 'túúcā ngaⁿ'a: Vá'ai yeⁿ'é canéé chi duuchi va'ai naachi 'iiⁿ'yāⁿ caaⁿ'maⁿngua'á yā, naati ndís'tiī ní diíⁿ nī chí yiivi yáává yeⁿ'e 'iiⁿ'yāⁿ chi díduucu. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ní chɛɛti yaācū miiⁿ ndaá nanááⁿ Jesús 'iiⁿ'yāⁿ chi ngueenááⁿ ndúúcū 'iiⁿ'yāⁿ chi ngaā yó'ōo, ní Jesús miiⁿ diíⁿ yā chí nduūvā yeⁿ'e nducyaaca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Naati chiiduu n'gɛɛtɛ́ɛ̄ ndúúcū maestros yeⁿ'e ley nduuvi taáⁿ yā taachí n'diichi yā chi 'tíícā idiiⁿ Jesús miiⁿ ní ch'iindiveéⁿ yā chuū. Ní saⁿ'ā dá'caīyāa n'gai sa ní caⁿ'a sa: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ saⁿ'ā chi Daiya rey David miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ní 'iiⁿ'yāⁿ s'eeⁿ caⁿ'a yā chii yā Jesús miiⁿ: ¿'Áá n'giindiveéⁿ nī chí saⁿ'ā da'caīyāa ngaⁿ'ā sa? Jesús caⁿ'a yā: N'giindiveéⁿ. ¿'Áá nguɛ́ɛ́ n'geeⁿ ndís'tiī Nduudu yeⁿ'e Ndyuūs naachi canéé nguūⁿ? Ní ngaⁿ'a 'túúcā: 'Āā diiⁿ di chi da'caīyaá ndúúcū dacua'aá caata yā chi n'daāca n'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesús ní nan'daa yā yeⁿ'e yaācū miiⁿ. Ní nan'daa yā yeⁿ'e yáāⁿ miiⁿ ní cueⁿ'e yā na yáāⁿ 'lííⁿ chi nguuvi Betania. Ní mííⁿ canee yā nguīinū miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chídɛ́ɛ́vɛ́ táámá nguuvi, ní Jesús ndaa ntúuⁿ yā ná yáāⁿ miiⁿ ní chiī cuiicú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Cuaaⁿ cyúúní ní n'diichi yā 'áámá yáⁿ'á yeⁿ'e n'guíídīi yaaⁿ nguuvi niiⁿnuúⁿ cyúúní, ní cueⁿ'e yā naachí cutá'a yā n'guiidīi miiⁿ, ní nguɛ́ɛ́ ndaaca yā n'gui'i yeⁿ'ē, dámaāⁿ tá'āa. Ní Jesús caⁿ'a yā chii yā yáⁿ'á 'túúcā: Dii yáⁿ'á, 'āā ntɛ́ɛ́ nguɛɛcunéé 'cuūndī n'gui'i yeⁿ'ē di. Tuu'mí nūuⁿ yaⁿ'á miiⁿ nti'i. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Taachí discípulos n'diichí yā chuū, ngeⁿ'ē yiinú yā yeⁿ'ē ní caⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chi maāⁿnchɛɛtɛ́ nuūuⁿ nti'i n'guíídīi yaaⁿ nguuvi? ");
INSERT INTO cuxNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús nán'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā discípulos: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, ndúúti chi ndís'tiī i'téénu nī ní nguɛ́ɛ́ n'deēe nadicádíínuuⁿ nī, nguɛ́ɛ́ dámaāⁿ chuū cuuvi diíⁿ nī yeⁿ'ē n'guíídīi yaaⁿ nguuvi naati cuuvi diíⁿ nī ndúúcū yiīcū 'lííⁿ 'cūū chí caaⁿ'maⁿ nī cuuvi nī: Dii yiīcū, cuvíi dí 'múúⁿ ní cueⁿ'e di cundáá nuūⁿ di ná nuūⁿnīⁿ'yáⁿ'ā, ní cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tanducuéⁿ'ē chi caaca nī naachí caaⁿ'maⁿngua'á nī, ndúúti chí cu'téénu nī, ní ndaācā yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Taachí Jesús miiⁿ ndaá yā chɛɛti yaācū templo miiⁿ, chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū ndaá yā nanááⁿ Jesús miiⁿ taachí ngi'cueeⁿ yā, ní caⁿ'a yā chii yā Jesús: ¿Du'ú 'ííⁿntyeⁿ'ē ngaⁿ'a yā chi 'túúcā idiíⁿ nī? ¿Du'ú 'iiⁿ'yāⁿ tee yā poder chi caaⁿ'maⁿ ntiiⁿnyúⁿ nī 'túúcā? ");
INSERT INTO cuxNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Nan'guɛɛcútaⁿ'a Jesús miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Úú ntúūⁿ ní intiinguuneéⁿ ndís'tiī. Nduuti chi nan'guɛɛcútaⁿ'a nī yeⁿ'é, tuu'mi ní cuuví ndís'tiī du'ú 'iiⁿntyeⁿ'ē tee yā poder 'úú chi idiíⁿ dendú'u chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yeⁿ'ē chí chɛɛdinúuⁿnīⁿ Juan, ¿tií chiīcā? ¿'Áá yeⁿ'e Ndyuūs chi canéé na va'ai chɛɛti nguuvi o yeⁿ'e saⁿ'ā iⁿ'yeeⁿdí 'cūū? Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ndeé yā nguááⁿ maáⁿ yā ní caⁿ'a yā: Nduuti chi caaⁿ'maⁿ yú chi yeⁿ'ē nanguuvi, tuu'mi ní Jesús caaⁿ'maⁿ yā cuuvi yā s'uūuⁿ: ¿Dɛ'ɛ̄ cuuvíī chi nguɛ́ɛ́ s'teenu nī yeⁿ'e chi ngaⁿ'a Juan miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ní nduuti chi caaⁿ'maⁿ yú chi yeⁿ'e saⁿ'ā iⁿ'yeeⁿdí 'cūū, 'va'a yú 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ ti nducyaaca yā ní déénu yā chi Juan chí chɛɛdínuūⁿnīⁿ ní 'aama profeta yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ní nan'guɛɛcútaⁿ'a yā yeⁿ'e Jesús miiⁿ ní caⁿ'a yā: Nguɛ́ɛ́ déénu 'nū. Jesús miiⁿ ní caⁿ'a ntúuⁿ yā: 'Tiicá ntúūⁿ 'úú ní nguɛ́ɛ́ cuuví ndís'tiī du'u 'ííⁿntyeⁿ'ē tee yā poder 'úú chí idiíⁿ chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús caⁿ'a yā: ¿Dɛ'ɛ̄ inadacadiinúúⁿ ndís'tiī yeⁿ'e chuū? Caⁿ'á caaⁿ'máⁿ ndúúcū ndís'tiī yeⁿ'e 'áámá saⁿ'ā chi vɛ́ɛ́ 'uūvī daiya sa. Ndaā sa nanááⁿ 'áámá daiya sa ní caⁿ'a sa: Díí daiyá, cuéⁿ'é di ní diiⁿ dí ntiiⁿnyuⁿ naachi vɛ́ɛ́ díí'yú uvas yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Daiya sa ní nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa: Nguɛ́ɛ́ neⁿ'é. Ch'iinu maaⁿ ní nadicádíínuuⁿ sa chi nguɛ́ɛ́ n'daācā diiⁿ sa ní cuéⁿ'e sa diiⁿ sa ntiiⁿnyuⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ní cueⁿ'e ntúuⁿ saⁿ'ā miiⁿ ní yaa'vi sa táámá daiya sa, ni 'tiicá ntúūⁿ caⁿ'a sa chii sa daiya sa. Ní daiya sa mííⁿ nán'guɛɛcútaⁿ'ā sa ní caⁿ'a sa: 'Tíícā, n'diī chiidá, caⁿ'á. Naati nguɛ́ɛ́ cueⁿ'e sa diiⁿ sa ntiiⁿnyuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Dɛ'ɛ̄ inadicadiinuuⁿ ndís'tiī? Naachi 'uūvī daiya yā ¿chɛɛ chí diīiⁿ tan'dúúcā chi neⁿ'e chiidá yā? 'Iiⁿ'yāⁿ s'eeⁿ caⁿ'a yā: Saⁿ'ā chi yaa'ví yā vmnaaⁿ. Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi 'iiⁿ'yāⁿ chí inn'guɛ́ɛ́ yeⁿ'e impuestos ndúúcū n'daataá chi vɛ́ɛ́ cá saⁿ'ā yeⁿ'e tá caⁿ'á yā vmnaaⁿ yeⁿ'é nī naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ti Juan chi chɛɛdínuūⁿnīⁿ ndaā sa vmnááⁿ ndís'tiī. Chiica sá na 'áámá yúúní cuaacu ní ngaⁿ'a sa yeⁿ'e yúúní cuaacu yeⁿ'e Ndyuūs ní nguɛ́ɛ́ s'téénu nī yeⁿ'ē sa. Naati saⁿ'ā publicanos chí inn'guɛ́ɛ́ yeⁿ'e impuestos ndúúcū n'daataá chi vɛ́ɛ́ saⁿ'ā s'ee ndúúcu tá s'téénu yā nduudu yeⁿ'e sa. Ndís'tiī, taachí n'diichí nī chuū chí 'āā diiⁿ Juan, nguɛ́ɛ́ ndaacadaamí nī yeⁿ'e nuuⁿndi yeⁿ'é nī ní nguɛ́ɛ́ s'téénu nī chiiⁿ chi ngaⁿ'a Juan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tuu'mi ní caⁿ'a Jesús: 'Caandiveéⁿ nī táámá ejemplo chi 'tɛɛ nguɛɛ dáámá. Canéé 'áámá 'iiⁿ'yāⁿ chi vɛ́ɛ́ yáⁿ'āa yeⁿ'e yā ní chiīnu yā dii'yu yeⁿ'e uvas na yáⁿ'āa yeⁿ'e yā. Ní din'dái yā 'áámá cheeⁿ yeⁿ'ē yáⁿ'á 'lííⁿ núúⁿmáⁿ cuaaⁿ 'diituú. Din'dái yā 'aama tanque naachi cuuví tun'dáa yā nuūⁿnīⁿ yeⁿ'e uvas miiⁿ. Ní din'dái yā 'áámá torre nguaaⁿ dii'yu uvas naachi mozos yeⁿ'e yā 'cuɛɛtinéeⁿ sa diiⁿ sa cuidado n'gui'i uvas miiⁿ. Dueño miiⁿ ca'a yā yáⁿ'āa yeⁿ'e yā saⁿ'ā s'eeⁿ chi diiⁿ sa ntiiⁿnyuⁿ miiⁿ ní cueⁿ'e yā táámá país. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Taachí snuū ca'a yeⁿ'ē tiempo yeⁿ'e n'gui'i uvas miiⁿ chí túúmá yā, dueño dicho'ó yā mozos yeⁿ'e yā chí saⁿ'ā s'eeⁿ nca'a sa n'gui'i uvas yeⁿ'e yáⁿ'āa, parte yeⁿ'e n'gui'i chi tuneeⁿ dueño. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Saⁿ'ā chí diiⁿ ntiiⁿnyuⁿ na yáⁿ'āa miiⁿ sta'a sa mozos. 'Áámá ní ch'eⁿ'e sa, táámá ní ch'iiⁿ'nuⁿ sa ní táámá ní chiītuu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dueño miiⁿ dicho'ó yā taandúú 'uūvī mozos, 'āā vi'í mozos chí cheⁿ'ē vmnaaⁿ. 'Tiicá ntúūⁿ diiⁿ sa ndúúcū mozos. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Cuayiivi mííⁿ dichó'o yā daiya yā ti dueño miiⁿ ní ngaⁿ'a yā: Saⁿ'ā s'eeⁿ ní diiⁿ sa honrar daiyá. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Taachí saⁿ'ā s'eeⁿ chi diiⁿ sa ntiiⁿnyuⁿ yeⁿ'e yáⁿ'āa miiⁿ n'diichi sa daiya dueño miiⁿ, caⁿ'a sa nguááⁿ maaⁿ sa: Sáⁿ'a 'tīī chi cuuví yeⁿ'ē sa yáⁿ'āa 'cūū. 'Caaⁿ'nuⁿ yú sáⁿ'ā miiⁿ ní ndúúcū chi vɛ́ɛ́ naaⁿ chi cuuví yeⁿ'ē sa ní cuuví yeⁿ'ē yú. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ní sta'ā sa daiya dueño miiⁿ ní tun'daa sa saⁿ'ā 'áámá lado yeⁿ'e chéēⁿ yeⁿ'e díí'yú uvas miiⁿ ní ch'iiⁿ'nuⁿ sa saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Taachí ndaā dueño yeⁿ'e díí'yú uvas ¿dɛ'ɛ̄ diíⁿ yā ndúúcū saⁿ'ā chí ídiīiⁿ ntííⁿnyuⁿ na yáⁿ'āa yeⁿ'é ya? ");
INSERT INTO cuxNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Dueño miiⁿ ní 'caaⁿ'núⁿ yā saⁿ'ā chi cúúncheeⁿ sa diiⁿ sa. Ní ca'á yā yáⁿ'āa yēⁿ'e yā naachi vɛ́ɛ́ díí'yú uvas táámá 'iiⁿ'yāⁿ chi diíⁿ yā ntiiⁿnyuⁿ na yáⁿ'āa miiⁿ, 'iiⁿ'yāⁿ chí ntée yā uvas chí tuneéⁿ yā na tiempo yeⁿ'ē n'gui'i. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá nguɛ́ɛ́ n'geēⁿ ndís'tiī naachi canéé nguūⁿ na libro yeⁿ'e Ndyuūs chí ngaⁿ'a 'túúcā: Tuūu chí 'iiⁿ'yāⁿ chi idin'dái yā va'ai sta'á yā ní ch'ɛɛ̄cú yā 'áámá lado ti nguɛ́ɛ́ neⁿ'e yā. Tuūú 'cūū tuūú ch'ɛɛtɛ ní dichíí'vɛ̄ ca ní canéé tuūu ch'ɛɛtɛ́ esquina yeⁿ'é va'āī. Chuū ní Señor Ndyuūs diíⁿ yā. Chuū ní 'áámá chí ngeⁿ'e yiinu yú taachí inaaⁿ yú yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chííⁿ chí 'túúcā nga'á ngií ndís'tiī, chí naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā divíi yā yeⁿ'ē ndís'tiī ní ca'á yā táámá 'iiⁿ'yāⁿ chi ca'á yā n'gui'i chí tuneeⁿ lado yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí cun'dáá nduú yā vmnaaⁿ na tuūu 'cúū ní caātū 'ííní yeⁿ'e yā. Naati 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí cun'dáá nduūu tuūu 'cúū vmnaaⁿ yeⁿ'e yā, 'cuíínú ndúúví yuūni yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Taachí 'iiⁿ'yāⁿ chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ fariseos ch'iindiveéⁿ yā chuū, 'iiⁿ'yāⁿ s'eeⁿ tuumicadíínuuⁿ yā chi yeⁿ'é yā ngaⁿ'a Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nadicádíínuuⁿ yā taācā chi cuta'á yā Jesús miiⁿ naatí 'va'a yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ tí 'iiⁿ'yāⁿ s'eeⁿ i'téénu yā Jesús miiⁿ tan'dúúcā chi 'áámá profeta chí ngaⁿ'a nduudu yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús tuca'á yā ndee yā taama vmnéⁿ'ēe ndúúcū ejemplos, ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē va'ai chɛɛti nguuvi tan'dúúcā 'áámá rey chí chiica yā 'viicu chí ch'iindivaacu saⁿ'a daiya yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ní dichó'o yā mozos yeⁿ'e yā chí yaa'vi sa 'iiⁿ'yāⁿ chí ndíi yā invitado naati 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ néⁿ'e yā caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ní dichó'o yā tan'duuvi mozos ní caⁿ'a yā chii yā mozos: Caaⁿ'maⁿ nī cuuvi nī 'iiⁿ'yāⁿ chí ndíi yā invitado 'tíícā. 'Āā vɛ́ɛ́ yaāaⁿ comida miiⁿ. 'Āā ch'iīⁿ'núⁿ i'tiindu yeⁿ'é ní 'iiti chi 'viichɛɛ́. Tanducuéⁿ'ē 'āā vɛ́ɛ́ yaāaⁿ. Cuchií nī 'viicu. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Naatí 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ diiⁿ yā cuenta. 'Áámá yā ní cueⁿ'e yā cuɛ́ɛ́tí yeⁿ'e yā. Taama yā ní cueⁿ'e yā negocio yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tanáⁿ'a yā ní sta'á yā mozos. Cuⁿ'u yā ndúúcū sa ní ch'iiⁿ'nuⁿ yā mozos. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Taachi rey miiⁿ ch'iindiveéⁿ yā chuū, ndúúvi taaⁿ yā. Ní dichó'o yā soldados yeⁿ'é yā ní caⁿ'a ntiiⁿnyúⁿ yā chí 'caaⁿ'nuⁿ sá 'iiⁿ'yāⁿ chí ch'iiⁿ'nuⁿ yā mozos yeⁿ'é yā. Ní 'neeⁿ yaⁿ'ā sa yáāⁿ vaacú 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tuu'mi ní caⁿ'a yā chii yā mozos yeⁿ'é yā: Cuaacu nííⁿnyúⁿ 'viicu miiⁿ ní 'āā vɛ́ɛ́ yaāáⁿ caavā 'iiⁿ'yāⁿ chi chii yā invitado naati nguɛ́ɛ́ n'dai taaví yā chí cuchii yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Maaⁿ ní cueⁿ'e nī na yúúní chí can'daā yeⁿ'e yáⁿ'āa yáāⁿ ní diíⁿ nī invitar 'iiⁿ'yāⁿ chí chii yā na 'viicu, 'iiⁿ'yāⁿ chí ndaāca nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mozos ní can'daa sa ní cueⁿ'e sa cuaaⁿ cyúúní ní nadaama sa nducyaaca 'iiⁿ'yāⁿ chí ndaāca sa, 'iiⁿ'yāⁿ chí cúúncheeⁿ yā ndúúcū 'iiⁿ'yāⁿ chí n'dai yā. Ní ndaā nducyaacá 'iiⁿ'yāⁿ s'eeⁿ chi mozos 'cai sa ní n'deēe n'dáí 'iiⁿ'yāⁿ ndaá yā 'viicu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ní rey miiⁿ cheⁿ'e yā n'diichi yā 'iiⁿ'yāⁿ chí ndii yā invitado ní ndaācá yā 'áámá saⁿ'ā chi nguɛ́ɛ́ cánúúⁿ sá catecai sa yeⁿ'ē naachi n'giindivaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ní caⁿ'a yā chii yā saⁿ'ā: N'diī amigo, ¿taācá chi ndāa nī 'muuⁿ chi nguɛ́ɛ́ canúuⁿ nī catecai nī yeⁿ'ē chí n'giindivaacú 'iiⁿ'yāⁿ? Saⁿ'ā miiⁿ ní nguɛ́ɛ́ nan'guɛɛcútaⁿ'a sa yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tuu'mi ní rey miiⁿ caⁿ'a yā chii yā mozos yeⁿ'e yā: 'Caāchiichí nī ca'a sa ndúúcū ta'a sa ní divíi nī saⁿ'ā ndii 'múúⁿ ní 'cuɛɛcú nī saⁿ'ā cuaaⁿ chuvá'āī na maāiⁿ. Mííⁿ cuɛɛcu sa ní ché'é 'diiⁿ'yuⁿ sa cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesús caⁿ'a ntúuⁿ yā chuū: Nééné 'yaaⁿ yā chí Ndyuūs 'cuai yā naati duu'ví yā chi Ndyuūs ndɛɛvɛ́ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tuu'mi ní 'iiⁿ'yāⁿ fariseos cueⁿ'é yā ní nduuvidaamá yā. Ní ndeé yā nguaaⁿ maáⁿ yā táácā cuuvi diíⁿ yā chi Jesús miiⁿ cástaⁿ'a nduudú yeⁿ'e yā chi caaⁿ'máⁿ yā 'áámá nduudu yaadi. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ní fariseos dicho'ó yā 'iiⁿ'yāⁿ yeⁿ'e yā ndúúcū 'iiⁿ'yāⁿ yeⁿ'e Herodes miiⁿ chí caaⁿ'máⁿ yā Jesús: N'diī maestro, déénu 'nū chí n'diī ní 'áámá saⁿ'ā chí n'dai. N'diī ní diíⁿ nī chí n'dáácā. Ní cuaacu nííⁿnyúⁿ ngi'cueeⁿ nī yúúní yeⁿ'e Ndyuūs. Ní nguɛ́ɛ́ 'va'a nī 'iiⁿ'yāⁿ ti nguɛ́ɛ́ indɛɛ́ nī cuidado tááca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Maaⁿ ní cúúví nī nús'uu: ¿Dɛ'ɛ̄ inadacádíínuuⁿ nī? ¿'Áá canéé nguūⁿ na ley chí nadíí'vɛ 'nū emperador César tuūmī yeⁿ'é 'nū o nguɛ́ɛ́? ");
INSERT INTO cuxNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús tuumicádíínuuⁿ yā chí 'iiⁿ'yāⁿ s'eeⁿ ní diíⁿ yā chi nguɛ́ɛ́ n'daācā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí neⁿ'e nī n'diichineéⁿ nī 'úú? Ndís'tiī ní vɛɛ 'uūvī chí nadacadíínuuⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tée nī tuūmī chi nadíí'vɛ nī yeⁿ'e impuesto. 'Iiⁿ'yāⁿ s'eeⁿ ní ch'iⁿ'i yā 'áámá tuūmī Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Du'u nááⁿ chi canéé ná tuūmī? ¿Du'ū chi ngúúví cánéé nguūⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Naaⁿ emperador César cānee. Ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Nca'a nī tuūmī emperador César chííⁿ chí yeⁿ'ē sa ní ca'a nī Ndyuūs chí yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Taachí ch'iindiveéⁿ yā chuū, cheⁿ'e yiinu yā ní cueⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nguuvi miiⁿ 'iiⁿ'yāⁿ saduceos ndaá yā nanááⁿ Jesús miiⁿ. 'Iiⁿ'yāⁿ saduceos ngaⁿ'a yā chí nguɛ́ɛ́ índuuchi 'iiⁿ'yāⁿ yeⁿ'ē nguaaⁿ tináⁿ'ā. Ní ntiinguunéeⁿ yā Jesús, ");
INSERT INTO cuxNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ní caⁿ'a yā: N'diī maestro, Moisés miiⁿ caⁿ'a sá chi 'āā du'ú nūuⁿ saⁿ'ā chí 'cuūvī sa ní nguɛ́ɛ́ ch'iīndī daiya n'daataá yeⁿ'ē sa tuu'mi ní 'diīnū sa 'caandavaacu sa ndúúcū n'daataá mííⁿ. Ní saⁿ'ā miiⁿ ní 'cuūndī daiya sá lado yeⁿ'ē 'díínu tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Maaⁿ ní vɛ́ɛ́ ndɛɛ̄chɛ̄ sáⁿ'a nūuⁿ yeⁿ'ē chɛɛcú sa yeⁿ'ē chiidá sa. Sáⁿ'ā vmnaaⁿ miiⁿ ní ch'iindivaacu sa ní ch'iī sa. Ní nguɛ́ɛ́ daiya n'daataá yeⁿ'ē sa. Ní canee n'daataá yeⁿ'ē sa. Ní 'díínu sa ní canee sá ndúúcū tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","'Tiicá ntúūⁿ chó'ōo yeⁿ'ē ndii chiiⁿ ndii 'uuvi saⁿ'ā. 'Tiicá ntúūⁿ chó'ōo yeⁿ'e saⁿ'ā chi ndii 'iīnū. 'Tiicá ntúūⁿ chó'ōo yeⁿ'ē saⁿ'a s'eeⁿ nduu ndɛɛ̄chɛ̄ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndíí ná ch'iinú ní ch'iī ntúūⁿ n'daataá miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Taachí nduuchi 'iiⁿ'yāⁿ yeⁿ'e nguaaⁿ tináⁿ'ā, naachí ndɛɛ̄chɛ̄ saⁿ'ā s'eeⁿ ní ¿chɛɛ sa chí n'daataá yeⁿ'ē sa táⁿ'ā caati nducyaaca sá canee sá ndúúcu tá? ");
INSERT INTO cuxNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tuu'mi ní Jesús miiⁿ ní nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī ní nguɛ́ɛ́ n'daācā nadicádiinuuⁿ nī, ti nguɛ́ɛ́ déénu nī taacā ngaⁿ'a na libro yeⁿ'é Ndyuūs naachi canéé nguūⁿ. Ndíí nguɛ́ɛ́ ndúú déénu nī poder yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ti naachí nduuchi 'iiⁿ'yāⁿ yeⁿ'e nguaaⁿ tináⁿ'ā, nguɛ́ɛ́ 'caandavaacú yā. Ndíí nguɛ́ɛ́ ca'a ra yā chí 'caandavaacu daiya yā ti cuuví yā tan'dúúcā ángeles chi dichíí'vɛ̄ Ndyuūs chi canée yā na va'ai chɛɛtí nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Naati yeⁿ'ē chí nduuchi yā yeⁿ'e nguaaⁿ tináⁿ'ā, ¿'áá nguɛ́ɛ́ n'geeⁿ nī chi maáⁿ Ndyuūs caⁿ'a yā yeⁿ'ē taachí caⁿ'a yā 'túúcā?: ");
INSERT INTO cuxNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Úú ní Ndyuūs yeⁿ'ē Abraham ndúúcū Isaac ndúúcū Jacob. Ndyuūs miiⁿ ní nguɛ́ɛ́ Ndyuūs yeⁿ'e tináⁿ'ā ti yeⁿ'é 'iiⁿ'yāⁿ chi snduuchi. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Taachí nducyaaca 'iiⁿ'yāⁿ ch'iindiveéⁿ yā chuū, cheⁿ'e yiinú yā yeⁿ'ē nduudu yeⁿ'e Jesús miiⁿ tan'dúúcā chi ngi'cueeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tuu'mi ní saⁿ'ā fariseos taachí ch'iindiveéⁿ yā yeⁿ'e chi Jesús diíⁿ yā, 'iiⁿ'yāⁿ saduceos 'āā ntɛ́ɛ́ caⁿ'a yā ndúúcū Jesús miiⁿ, fariseos miiⁿ nduuvidaamá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Áámá saⁿ'a fariseo abogado chí ngi'cueeⁿ sa chí ngaⁿ'ā ley miiⁿ neⁿ'e sa n'diichinééⁿ sa Jesús ní ntiinguunééⁿ sa 'iiⁿ'yāⁿ. Ní caⁿ'a sá chii sa Jesús: ");
INSERT INTO cuxNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","N'diī Maestro, ¿chɛɛ́ mandamiento chí ch'ɛɛtɛ n'dai ca yeⁿ'ē na ley yeⁿ'ē Moisés? ");
INSERT INTO cuxNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús caⁿ'a yā chii yā saⁿ'ā: Dinéⁿ'e di Señor Ndyuūs yeⁿ'ē di ndúúcū núúⁿmáⁿ stáává yeⁿ'ē di ndúúcū núúⁿmáⁿ alma yeⁿ'ē di ndúúcū núúⁿmáⁿ vaanicadíínūuⁿ yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Chuū chí vmnaaⁿ ní ch'ɛ́ɛ́tɛ̄ ca chi cuuvi tanáⁿ'ā mandamientos. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndiichi ndii 'úúví tan'dúúcā chi vmnááⁿ vmnaaⁿ: Dinéⁿ'e di 'iiⁿ'yāⁿ na niiⁿnuúⁿ vaacú di tan'dúúcā chí neⁿ'e dí maāⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yeⁿ'ē ndúú 'uūvī mandamientos miiⁿ canee tanducuéⁿ'ē yeⁿ'e ley Moisés miiⁿ ndúúcū nduudu chí ngaⁿ'a profetas ndii cuááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Taachí 'iiⁿ'yāⁿ fariseos ndiidáámá yā Jesús ntiinguuneeⁿ yā fariseos, ");
INSERT INTO cuxNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ nadicádíínuuⁿ ndís'tiī yeⁿ'e Cristo? ¿Du'ū daiyá 'iiⁿ'yāⁿ 'cúū? Ní fariseos caⁿ'a yā chii yā: Daiya David miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ní Jesús caⁿ'a yā chii yā fariseos: ¿Táácā cuuvi David miiⁿ na espíritu yeⁿ'e sa ní caⁿ'a sa chi Cristo ní Señor? Ní caⁿ'a yā chuū: ");
INSERT INTO cuxNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Caⁿ'a Señor Ndyuūs miiⁿ chii yā Señor Cristo yeⁿ'é: 'Cuūndi di lado tá cuaacú chi lado yeⁿ'e honor ndíí 'úú cu'neéⁿ 'iiⁿ'yāⁿ chi contra yeⁿ'ē di cuaaⁿ ndii yā na ca'a di tan'dúúcā chi enimigos ní 'áámá banco 'lííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Maaⁿ ní nduuti chi David miiⁿ caⁿ'á yā yeⁿ'e Cristo chi Señor yeⁿ'é yā, ¿táácā cuuvi chiī chi Señor miiⁿ ní daiya David 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi nan'guɛɛcútaⁿ'a yā yeⁿ'ē mar 'áámá. Ndíí nguuvi miiⁿ s'neeⁿ naaⁿ yā ntiinguuneeⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús yaa'vi yā 'iiⁿ'yāⁿ ndúúcū discípulos yeⁿ'e yā ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Maestros chi ngí'cueeⁿ ley ndúúcū 'iiⁿ'yāⁿ fariseos, 'iiⁿ'yāⁿ s'uuⁿ deenu n'dai yā ní ngi'cueéⁿ yā ní caaⁿ'maⁿ cuaacú yā ley yeⁿ'e Moisés. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'Tiicá ntúūⁿ cu'téénu ndís'tiī ní diíⁿ nī tan'duucā 'iiⁿ'yāⁿ s'eeⁿ ngaⁿ'a yā, naati nguɛ́ɛ́ diíⁿ nī tan'dúúcā 'iiⁿ'yāⁿ s'eeⁿ idiíⁿ yā tí 'iiⁿ'yāⁿ s'eeⁿ ní ngaⁿ'a yā yeⁿ'e ley naati nguɛ́ɛ́ 'tíícā idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'Iiⁿ'yāⁿ s'eeⁿ ní diíⁿ yā tan'dúúcā chi 'caachiichí yā chɛɛdi chi n'gii taaví chi 'iiⁿ'yāⁿ nguɛ́ɛ́ cuchɛ́ɛ yā ní ngaⁿ'á yā chi 'iiⁿ'yāⁿ canéé chí cuchɛ́ɛ yā. Naati 'iiⁿ'yāⁿ s'eeⁿ maáⁿ yā ndíí nguɛ́ɛ́ neⁿ'é yā 'neeⁿ nduutitá'a yā chi tuu'vi yā chɛɛdi miiⁿ ní diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","'Iiⁿ'yāⁿ s'eeⁿ ní idiíⁿ yā nducuéⁿ'ē ntiiⁿnyuⁿ yeⁿ'e yā caati tanáⁿ'ā 'iiⁿ'yāⁿ snáaⁿ yā ní n'diichí yā táácā idiíⁿ yā. Neⁿ'é yā candɛɛ yā chi canéé nguuⁿ chi yeⁿ'ē Nduudu yeⁿ'e Ndyuūs ní s'neeⁿ yā 'áámá caja 'lííⁿ ní dich'iichí yā 'áámá yiiⁿmaⁿ ní s'neeⁿ yā maaⁿ ta'a yā ní nchɛɛtɛ́ yā. Ní n'gɛɛ̄ti núuⁿ yā vestido yeⁿ'e yā chí n'geē 'nūuⁿ ca. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Iiⁿ'yāⁿ s'eeⁿ ní neⁿ'e yā 'cuundí yā sillas chí yeⁿ'e 'iiⁿ'yāⁿ ch'ɛɛtɛ taachi caⁿ'á yā 'áámá 'viicu chí che'é yā. Ní neⁿ'e yā 'cuundí yā sillas yeⁿ'e honor chi vmnááⁿ vmnaaⁿ ná yáacu sinagogas. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ní neⁿ'e yā chí tanáⁿ'ā 'iiⁿ'yāⁿ diiⁿ n'daacá yā ní diiⁿ yā saludar 'iiⁿ'yāⁿ taachi sneé yā cuaaⁿ nii'vɛ̄ɛ̄ ní neⁿ'e yā chi 'iiⁿ'yāⁿ caaⁿ'máⁿ yā, maestro, maestro, taachi diíⁿ yā saludar 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Naati ndís'tiī ní nguɛ́ɛ́ neⁿ'e nī chí caaⁿ'maⁿ 'iiⁿ'yāⁿ yeⁿ'e nī maestro ti 'áámá 'iiⁿ'yāⁿ nūuⁿ chí maestro ní 'iiⁿ'yāⁿ miiⁿ chí Cristo. Ní nducyaaca ndís'tiī ní hermanos yeⁿ'e nī vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nguɛ́ɛ́ caaⁿ'maⁿ nī yeⁿ'ē mar 'áámá 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa 'cúū: N'diī chiiduú padre, ti dámaāⁿ 'áámá chi Chiida yú chí Ndyuūs chi canéé na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndíí nguɛ́ɛ́ ndúú caaⁿ'maⁿ rá yā yeⁿ'e nī: Maestro, ti 'áámá chi maestro yeⁿ'e nī chi Cristo. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","'Iiⁿ'yāⁿ chi ch'ɛɛtɛ ca yā yeⁿ'é nī canee chi dichíí'vɛ yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ní 'iiⁿ'yāⁿ chi diíⁿ yā chi cuuví ch'ɛɛtɛ maáⁿ yā, 'iiⁿ'yāⁿ miiⁿ cuuví ndiicuúⁿ yā. 'Iiⁿ'yāⁿ chi idiíⁿ yā chí maáⁿ yā ndiicuúⁿ yā, cuuví ch'ɛɛtɛ́ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Naati dɛ'ɛ chúúcā ya'ai yeⁿ'é ndis'tiī, maestros chi ngi'cueeⁿ ley ndúúcū 'iiⁿ'yāⁿ fariseos, ndís'tiī 'uūvī naaⁿ 'uūvī cheendí nī, ti nguɛ́ɛ́ ngi'cueeⁿ nī yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū. Ndíí nguɛ́ɛ́ ndúú maaⁿ ndís'tiī cundáa nī va'ai chɛɛti nguuvi. Ndíí nguɛ́ɛ́ n'guúⁿ nī tanáⁿ'ā 'iiⁿ'yāⁿ chí neⁿ'e ndaá yā chí cūndaa yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Dɛ'ɛ chúúcā ya'ai yeⁿ'ē ndís'tiī, 'iiⁿ'yāⁿ chi dingúūⁿ ní ngi'cueeⁿ nī ley ndúúcū 'iiⁿ'yāⁿ fariseos, ti ndís'tiī 'uūvī nááⁿ 'uūvī cheendí nī, ti ndivíi nī va'ai yeⁿ'ē n'daataá nguá'āa. Ní nééné n'deēe ngaⁿ'a nī taachi ngaⁿ'angua'á nī nanááⁿ nducyaaca 'iiⁿ'yāⁿ. 'Úú ngaⁿ'á chi ch'ɛɛtɛ ca castigo yeⁿ'e nī nguuvi yeⁿ'e juicio. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Dɛ'ɛ chúúcā ya'ai yeⁿ'ē ndís'tiī, maestros chi ngi'cueeⁿ ley ndúúcū ndís'tiī 'iiⁿ'yāⁿ fariseos ti ndís'tiī 'uūvī naaⁿ 'uūvī cheendí nī. Ndís'tiī ní chiicá nī ndíí yáⁿ'āa yaⁿ'ai táámá lado nuūⁿnīⁿ'yáⁿ'ā ní diíⁿ nī chi 'áámá 'iiⁿ'yāⁿ i'téénu yā tan'dúúcā ndís'tiī. Ní taachí 'iiⁿ'yāⁿ cu'téénu yā tan'dúúcā ndís'tiī neⁿ'é nī, idiíⁿ nī chi 'iiⁿ'yāⁿ miiⁿ ní 'uūvī tanto cuuví yā yeⁿ'ē daiya infierno nguɛ́ɛ́ ti chi ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Dɛ'ɛ chúúcā ya'ai yeⁿ'e ndís'tiī, chi ngi'cueéⁿ nī tan'dúúcā 'iiⁿ'yāⁿ chi ngueenááⁿ. Dɛ'ɛ inadacádíínuuⁿ ndís'tiī. Nduuti chi 'áámá 'iiⁿ'yāⁿ caⁿ'a yā chi diíⁿ yā 'áámá cosa ní 'cuaí yā, “cáávā yaācū templo”, tuu'mi ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nacádíínuuⁿ nī yeⁿ'e chuū, naati nduuti chi 'iiⁿ'yāⁿ 'cuai yā, “cáávā 'diiⁿnguaaⁿ” chi vɛ́ɛ́ chɛɛti yaācū templo miiⁿ, tuu'mi ní 'iiⁿ'yāⁿ miiⁿ canee cuuⁿmiⁿ chi diíⁿ yā chi caaⁿ'máⁿ yā chi caⁿ'a yā chi diiⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ndís'tiī ní 'iiⁿ'yāⁿ chi nguɛɛ deenu ti tan'dúúcā 'iiⁿ'yāⁿ ngueenááⁿ 'tiicá nī. ¿Chɛɛ cá ch'ɛɛtɛ ca? ¿'Áá 'dííⁿnguāāⁿ miiⁿ o yáacū miiⁿ chí diīiⁿ chi didɛɛvɛ 'dííⁿnguāāⁿ miiⁿ cucááva Ndyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","'Tiicá ntúūⁿ ndís'tiī: Ndúúti chi 'áámá 'iiⁿ'yāⁿ caⁿ'a yā chi diíⁿ yā 'áámá cosa, ní n'gaí yā, “cáávā nátai”, nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nacadíínuuⁿ nī yeⁿ'ē. Naati ndúúti chi 'iiⁿ'yāⁿ n'gaí yā, “cáávā ofrenda” chi candúú vmnááⁿ yeⁿ'ē nátaī, tuu'mi ní 'iiⁿ'yāⁿ miiⁿ canee cúúⁿmíⁿ chi diíⁿ yā chi caⁿ'a yā chi diiⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ndís'tiī ní tan'dúúcā 'iiⁿ'yāⁿ chi chɛɛchí tiīiⁿ o 'iiⁿ'yāⁿ chi ngueenááⁿ, 'tiicá nī ti ¿chɛɛ́ ca chi ch'ɛɛtɛ ca? ¿'Áá ofrenda miiⁿ o nátaī chi diīiⁿ chí ofrenda miiⁿ ní didɛɛvɛ cucáávā Ndyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'Tíícā. 'Iiⁿ'yāⁿ chí n'gai yā, “cáávā nataī”, n'gai yā cáávā nátaī ndúúcū tanducuéⁿ'ē chi cánduū nátaī. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","'Iiⁿ'yāⁿ chí n'gaí yā, “cáávā yaācū templo”, nguɛ́ɛ́ dámaāⁿ ngaⁿ'a yā cáávā yaācū templo miiⁿ naati cáávā maáⁿ Ndyuūs chi canéé na yaācū templo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Iiⁿ'yāⁿ chi n'gaí yā, “cáávā va'ai chɛɛti nguuvi”, n'gaí yā cáávā trono yeⁿ'e Ndyuūs ní cáávā Ndyuūs chi vɛ́ɛ yā na trono miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Dɛ'ɛ chúúcā ya'ai yeⁿ'e ndís'tii, maestros chi ngi'cueéⁿ yā ley ndúúcū 'iiⁿ'yāⁿ fariseos, ndis'tiī 'uuvi naaⁿ 'uūvī cheendí nī. Ndís'tiī ní nga'á nī Ndyuūs 'áámá ndiichi parte yeⁿ'e yaātā chí yiivií, ndúúcū yaāta anís, ndúúcū yaātā comino. Ní ndís'tiī ní s'néeⁿ nī 'aama lado cosas chi n'gɛɛtɛ ca yeⁿ'e na ley, chííⁿ chí n'diichí nī nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ ndúúcū vaadī cuaacu ndúúcū vaadī ya'ai 'iinu ndúúcū vaadī i'téénu. Chuū canee chi diíⁿ nī ní diíⁿ nī táámá naaⁿ dendu'ū. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ndís'tiī 'iiⁿ'yāⁿ chi tan'dúúcā chi ngueenááⁿ chi candɛɛ nī 'iiⁿ'yāⁿ. Diíⁿ nī tan'dúúcā chi i'yaáⁿ nī 'áámá 'yaācū yeⁿ'ē nuūⁿnīⁿ chi cu'ú nī naati cu'ú nī 'iiti camello chi ch'ɛɛtɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Dɛ'ɛ chúúcā ya'ai yeⁿ'ē ndís'tiī, maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ fariseos, ndís'tiī ní 'uūvī naaⁿ 'uūvī cheendí nī, ti inadɛɛvɛ́ nī cuaaⁿ daami yeⁿ'e vaso ndúúcū cu'u, chi tan'dúúcā cuerpo yeⁿ'e maáⁿ nī, naati cuááⁿ chɛɛ̄tí nī ní ndiituú ndúúcū chi diduucú nī ndúúcū tanducuéⁿ'ē chi nguɛɛ n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","'Caandiveéⁿ nī ndís'tiī 'iiⁿ'yāⁿ fariseos chi tan'dúúcā chí ngueenááⁿ. Diiⁿ cá nī chi didɛɛvɛ́ nī chí cuaaⁿ chɛɛti vaso ní 'tiicá ntúūⁿ cu'u, tuu'mi ní cuuvi dɛɛvɛ́ nī cuaaⁿ chuváⁿ'āī vaso miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Dɛ'ɛ̄ chúúcā ya'ai yeⁿ'e ndís'tiī, maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ fariseos, ndis'tiī 'uuvi naaⁿ 'uūvī cheendí nī, ti ndís'tiī ní tan'dúúcā yaīnyāⁿ 'cuɛ́ɛ̄ chí cuaaⁿ daami mííⁿ n'dɛɛvɛɛ́ chí nneⁿ'ē yaāchī caaca, ti cuaacu nííⁿnyúⁿ cuááⁿ chɛɛ̄tī miiⁿ ndiituú 'iini yeⁿ'ē tináⁿ'ā ndúúcū taanduvɛ́ɛ́ cosas chí vaati. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Tíícā ndís'tiī ti cuaacu nííⁿnyúⁿ n'giⁿ'i nī 'iiⁿ'yāⁿ chi ndís'tiī ní saⁿ'ā chi n'dai ndís'tiī naati cuaaⁿ chɛɛ̄tí nī ndiituú ndúúcū nduudu yaadi ndúúcū nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Dɛ'ɛ chúúcā ya'ai yeⁿ'ē ndís'tiī, maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ fariseos, 'iiⁿ'yāⁿ 'uūvī naaⁿ 'uūvī cheendí nī, ti idin'dái nī yaīnyāⁿ yeⁿ'ē profetas ní n'dɛɛvɛ nī yaīnyāⁿ yeⁿ'e 'iiⁿ'yāⁿ chí n'dai taachi snēe yā iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ndís'tiī ní ngaⁿ'á nī 'tíícā: Ndúúti chi nús'uu ch'ɛɛtinée 'nū tiempo chí ch'ɛɛtinéé chiidá 'nū cuááⁿ vmnaaⁿ, nguɛ́ɛ́ chinnee 'nū ch'iīⁿ'núⁿ 'nū profetas taachi cungéē yuūuⁿ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'Tíícā ndís'tiī ní ngaⁿ'á nī nduudu cuaacu yeⁿ'ē maáⁿ nī ti ndís'tiī ní dáíyá 'iiⁿ'yāⁿ chí ch'iiⁿ'nuⁿ yā profetas. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ndís'tiī ní canéé chí diíⁿ nī tan'dúúcā chiidá nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ndís'tiī ní tan'dúúcā cúú 'tíícā ndáátá yeⁿ'e nī. ¿Táácā cuuvi nguáⁿ'ai nī yeⁿ'e castigo yeⁿ'e infierno? ");
INSERT INTO cuxNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cáávā chuū 'úú ní dicho'ó nanááⁿ ndís'tiī profetas chi candɛɛ yā Nduudu yeⁿ'é Ndyuūs, ndúúcū 'iiⁿ'yāⁿ chi déenū, ndúúcū 'iiⁿ'yāⁿ chi ngi'cueeⁿ ley. N'dúúví 'iiⁿ'yāⁿ s'eeⁿ ní ndís'tiī ní chita'á nī 'iiⁿ'yāⁿ ní chi'neeⁿnga'á nī 'iiⁿ'yāⁿ. Tá n'duuvi yā ní ch'eⁿ'é nī 'iiⁿ'yāⁿ na yaācū sinagogas yeⁿ'e nī ní can'dáa nī 'iiⁿ'yāⁿ ndii na 'áámá yáāⁿ táámá yáāⁿ chí ch'eenú yā chii. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ní ndís'tiī ní ca'á nī cuenta yeⁿ'ē nducuéⁿ'e yuūúⁿ yeⁿ'e 'iiⁿ'yāⁿ chí n'dai chí 'iiⁿ'yāⁿ yeⁿ'é nī ch'iiⁿ'núⁿ yā 'iiⁿ'yāⁿ na yáⁿ'āa 'cūū ndii yuūúⁿ yeⁿ'ē Abel chí saⁿ'ā n'dai ndii yuūúⁿ yeⁿ'e Zacarías daiya saⁿ'ā Berequías chí ndís'tiī ch'iiⁿ'nuⁿ nī náávtaⁿ'ā yeⁿ'ē yaācū miiⁿ ndúúcū nátaī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: Castigo yeⁿ'ē tanducuéⁿ'ē chuū canee vmnaaⁿ 'iiⁿ'yāⁿ chi snée yā maaⁿ tiempo 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ní ngaⁿ'a Jesús: Ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén, ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén, chí ch'iīⁿ'núⁿ nī 'iiⁿ'yāⁿ profetas ní chi chiītuú nī 'iiⁿ'yāⁿ chi Ndyuūs dicho'ó yā nanáaⁿ nī. Nééné n'deēe 'cuūví neⁿ'é nadaamá daiya nī tan'dúúcā tú'ū chi inadáámá tī daiya tī maaⁿ ngɛɛchi tī ní nguɛ́ɛ́ 'cuuⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ndís'tiī, n'diichí nī. Ndyuūs chi'neeⁿ yā ndís'tiī ndúúcū vaacú nī dámaāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ti 'úú ní ngaⁿ'á ngií ndís'tiī, ti ndii maaⁿ ní 'āā ntɛ́ɛ́ snaaⁿ nī 'úú ndíí ndaā tiempo taachí caaⁿ'maⁿ nī: Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chí cuchii yā ndúúcū chi duuchi Señor chí Daiyá Dendyuūs miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Taachí Jesús miiⁿ nan'dáa yā yeⁿ'e yaācū templo cueⁿ'é yā. Discípulos yeⁿ'é yā ní ndaa yā nanáaⁿ yā ní n'giⁿ'i yā Jesús miiⁿ va'ai s'eeⁿ yeⁿ'e yaācū templo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús miiⁿ ní n'guɛɛcútaⁿ'a yā ní caⁿ'a yā: ¿'Áá inaaⁿ ndís'tiī nducyáácá chuū? Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi nguɛ́ɛ́ cunee tuūu cuaaⁿ vmnaaⁿ yeⁿ'e ví'ī chí nguɛ́ɛ́ ntuuvií. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús vɛ́ɛ yā ná yiīcū chí nguuvi Olivos. Discípulos ndaa yā nanááⁿ yā taachi caneé yā damáaⁿ yā ní caⁿ'a yā chii yā Jesús: Cúúví nī nús'uu tií cuaⁿ'ā cuuví chuū. ¿Dɛ'ɛ señal 'cuuⁿ'miⁿ nī taachi 'āā ndaa nī taama vmnéⁿ'ēe ní taachí 'cuiinu iⁿ'yeeⁿdī? ");
INSERT INTO cuxNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'e yā ní caⁿ'a yā: Cundɛ́ɛ nī cuidado chí mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cannche'éí yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","'Yááⁿ n'dáí 'iiⁿ'yāⁿ ndáa yā ndúúcū chi duuchí ní caaⁿ'maⁿ yā 'tíícā: 'Úú chi Cristo 'úú. Ní cannche'éí yā 'yaaⁿ n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ní 'caandiveéⁿ nī chi vɛ́ɛ́ caandaá ní 'caandiveéⁿ nī chi 'cuūndī caandaá. Cundɛ́ɛ nī cuidado chi 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ castaⁿ'a vaanicádiinúúⁿ yeⁿ'e nī ti canéé chi chííⁿ nducuéⁿ'ē dendu'ū chi 'túúcā cuuvi, naatí 'āā cuɛ́ɛ́ chí 'āā 'cuiinu iⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ti 'áámá nación 'cuuⁿ'maⁿ ndúúcū taama nación, ní 'áámá rey ndúúcū nducuéⁿ'e país naachi ngaⁿ'a ntiiⁿnyuⁿ yā contra yeⁿ'e taama rey ndúúcū nducuéⁿ'e país naachi chi ngaⁿ'a ntiiⁿnyuⁿ yā. Ndaá tiempos chi cuiicu ndúúcū tiempos chi 'iiⁿ'yāⁿ 'cueenú yā cuuvi cáávā chi ya'ai yeⁿ'é yā, ní ndúúcū tiempos chí inuⁿ'u yáⁿ'āa n'deee cuááⁿ n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Taachí cuuví dendú'ū chí 'túúcā ní chīi tuu'mi ní cáámá cúūⁿnga'a vaādī ya'ai. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ní nca'a yā ndís'tiī na ta'a 'iiⁿ'yāⁿ chí 'cueenu nī cuuvi ní 'caaⁿ'núⁿ yā ndís'tiī. Ní nducyáácá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuaaⁿ yā ndís'tiī caavā chi ngaⁿ'a nī chi duuchí. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ní tiempo miiⁿ neené 'yaaⁿ 'iiⁿ'yāⁿ chi 'āā i'téénu yā yeⁿ'e 'úú ní 'cueenú yā cuuvi. Ní 'áámá yā caaⁿ'máⁿ yā contra yeⁿ'e taama yā chi i'téénu yā. Ní 'āā ntɛ́ɛ́ neⁿ'é yā vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ní nééné 'yaaⁿ 'iiⁿ'yāⁿ profetas falsos chí nguɛ́ɛ́ ngaⁿ'a yā nduudu cuaacu yeⁿ'é Ndyuūs ndaa yā ní cannche'éí yā 'yaaⁿ n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ní cáávā chi 'iiⁿ'yāⁿ neené dinuuⁿndí yā. 'Āā ntɛ́ɛ́ neⁿ'e yā 'áámá yā táámá yā vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Iiⁿ'yāⁿ chi cuchɛ́ɛ yā ní 'áámá i'téénu yā yeⁿ'é Ndyuūs ndii tiempo chi 'cuūvi yā ní nguáⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ní nduūdū cuaacú 'cūū chi ngai yeⁿ'é naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā 'iiⁿ'yāⁿ canéé chí caaⁿ'maⁿ yā nanááⁿ nducuéⁿ'ē iⁿ'yeeⁿdī. Ní nduudu cuaacu yeⁿ'é Ndyuūs ní cūnee chi 'caandiveéⁿ 'iiⁿ'yāⁿ yeⁿ'e tanducuéⁿ'ē nación yeⁿ'e núúⁿmáⁿ iⁿ'yeeⁿdī tuu'mi ní ndaa chi 'cuiinu iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Taachí ndís'tiī snaaⁿ nī tanducuéⁿ'ē chi cunncáā ca tan'dúúcā chí dinguuⁿ profeta Daniel ndii cuááⁿ vmnaaⁿ taachi cheendíí yā na cuaaⁿ chi santo tuu'mi ní ndís'tiī ndúúcū 'iiⁿ'yāⁿ chí n'geeⁿ yā túúmícádíínuuⁿ yā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ní tiempo yeⁿ'e chúū, 'iiⁿ'yāⁿ chi snée yā na yáⁿ'āa Judea cáánu yā caⁿ'á yā cuaaⁿ yiīcū. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ní 'iiⁿ'yāⁿ chi sndúu yā tiíⁿ va'āī nguɛ́ɛ́ ngua'áí yā chí cuta'á yā 'tɛɛ chi snúūⁿ chɛɛti va'āī ti cáánu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","'Iiⁿ'yāⁿ chi canée yā cuɛɛti nguɛ́ɛ́ nguɛɛcundíi yā na vaacu yā chi cuta'á yā tiīnuuⁿ yeⁿ'e yā ti cáánu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dɛ'ɛ chúúcā ya'ai yeⁿ'ē n'daataá chí vɛ́ɛ́ daiya tá chɛɛti tá ndúúcū n'daataá chi ngiicu dacua'āa yeⁿ'ē tá nguuvi s'eeⁿ chi cáánu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Caaⁿ'maⁿngua'á nī chi taachí ndaa nguuvi chí cáánu nī, nguɛ́ɛ́ tiempo chi 'iichɛ ndíí nguɛ́ɛ́ ndúú nguuvi sábado chí ntaavi'tuunúúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tuu'mi ní ndaá nguuvi chi nééné 'cueenu cá nī cuuvi chi nguɛ́ɛ́ n'diichi nī, ndíí nguɛ́ɛ́ ndúú ndíí naachi chinga'ā yeⁿ'e iⁿ'yeeⁿdī, ndíí mááⁿ, ndíí nguɛ́ɛ́ ndúú snaaⁿ ra nī cuayiivi. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ndúúti chí Ndyuūs nguɛ́ɛ́ 'āā diduu'ví yā tiempo chi 'cueenu cá nī cuuvi mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ nguaⁿ'ai yā. Naati cáávā 'iiⁿ'yāⁿ chí Ndyuūs dɛɛvɛ yā, Ndyuūs diduu'ví yā tiempo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tuu'mi ní ndúútī chi 'áámá 'iiⁿ'yāⁿ caaⁿ'maⁿ yā cuuvi yā ndís'tiī: Cuin'diichí nī, 'muuⁿ canee Cristo, o cuin'diichí nī, miiⁿ canéé Cristo miiⁿya, nguɛ́ɛ́ cu'teenú nī 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ti ndaá 'yaaⁿ n'dáí 'iiⁿ'yāⁿ chí ngaⁿ'á yā chi Cristo yā naati nguɛ́ɛ́ Cristo 'iiⁿ'yāⁿ s'eeⁿ. Ndaá 'yaaⁿ n'dáí profetas falsos chi nguɛ́ɛ́ caaⁿ'máⁿ yā nduudu cuaacu yeⁿ'é Ndyuūs. Ní 'iiⁿ'yāⁿ s'eeⁿ idiíⁿ yā señales chí n'gɛɛtɛ ndúúcū vaadī n'giinu. Ní cannche'éí yā 'iiⁿ'yāⁿ ndíí 'iiⁿ'yāⁿ chi Ndyuūs ndɛɛvɛ yā nduuti chi cuuví yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'Caandiveéⁿ nī. Āā ndíí vmnaaⁿ, 'āā ngaⁿ'á ngií chuū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ndúúti chi 'iiⁿ'yāⁿ caaⁿ'maⁿ yā cuuvi yā ndís'tiī 'tíícā: Cuin'diichí nī, Cristo canée yā na yáⁿ'āa cuūⁿmáⁿ, nguɛ́ɛ́ caⁿ'á nī miiⁿ. O nduuti chi caaⁿ'máⁿ yā: Cuin'diichí nī, Cristo canée yā ná 'aama cuarto chɛɛti va'ai, nguɛ́ɛ́ cu'téénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tan'dúúcā 'cuai chí ngiiya cuááⁿ naachi ican'daa 'yáⁿ'ā ní inaaⁿ yú ndíí taachi ndaā cuaaⁿ na ngiiya 'yáⁿ'ā, 'tiicá ntúūⁿ cuuvi taachí 'úú nndaá, 'úú chi Saⁿ'ā chi Daiya Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tí 'āā tií nūuⁿ naachi candiiti cuerpo yeⁿ'e tináⁿ'ā, mííⁿ nduuvidaama luutí. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús caⁿ'a yā: Tuu'mi ní taachi 'cuiinu 'cueenu yā cuuvi ni chó'ōo tiempo miiⁿ, tuu'mi ní 'yáⁿ'ā ní cuuví maāiⁿ, ní 'iiyū miiⁿ ní nguɛ́ɛ́ cunuūⁿ dɛɛvɛ. 'Iiⁿnyuⁿ ní cun'daā yeⁿ'ē nanguuvi ní nanguuvi ní nuⁿ'u ndúúcū poder yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tuu'mi ní snaáⁿ yā señales nanguuvi chi yeⁿ'e Saⁿ'ā chi Daiya Ndyuūs. Ní nducyáácá 'iiⁿ'yāⁿ yeⁿ'e nducuéⁿ'ē nación yeⁿ'ē iⁿ'yeeⁿdī ní cuɛɛcú yā ní snaaⁿ yā chí ndaá Saⁿ'ā chi Daiya Ndyuūs na meēéⁿ yeⁿ'ē nanguuvi ndúúcū poder yeⁿ'e yā ndúúcū chídɛɛvɛ́ n'dai yeⁿ'e maáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Taachí dichó'o yā ángeles yeⁿ'e yā, tuu'mí nūuⁿ áámá yā ní di'cuɛɛcú yā trompeta yeⁿ'e yā. Ní ángeles miiⁿ nadáámá yā 'iiⁿ'yāⁿ chi yeⁿ'e Cristo chí Cristo ndɛɛvɛ yā yeⁿ'ē cuaaⁿ núúⁿmáⁿ yáⁿ'āa 'cūū ndii 'áámá 'diituú ndii táámá 'diituú yeⁿ'ē nanguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Cuayiivi miiⁿ ní Jesús caⁿ'a yā: 'Cueéⁿ nī ejemplo yeⁿ'ē yáⁿ'á yeⁿ'e n'guíídīi yaaⁿ nguuvi taachí ínnguaaⁿnu duūⁿnɛ̄ n'gaiyáā ní ican'daā tá'āā 'āā déénu nī chi 'āā cuchii yáāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","'Tiicá ntúūⁿ, ndís'tiī, taachí snaaⁿ nī tanducuéⁿ'ē chúū, 'āā deenú nī chi 'āā cháā ndaa Saⁿ'ā chi Daiya Dendyuūs. Ní 'āā neené niiⁿnuúⁿ cánéé tiempo chi ndaa sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi 'iiⁿ'yāⁿ chi snée yā maaⁿ nguɛ́ɛ́ 'cuūvi yā neⁿ'e chi 'āā cuɛ́ɛ́ cuuvi tanducuéⁿ'ē chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nanguuvi ndúúcū yáⁿ'āa 'cūū chó'ōo naati nduudu yeⁿ'é nguɛɛ chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Naati nguuvi miiⁿ ndúúcū hora miiⁿ taachí ndaa Saⁿ'ā chi Daiya Dendyuūs, nguɛɛ vɛ́ɛ́ mar 'áámá 'iiⁿ'yāⁿ chi deenú yā yeⁿ'ē, ndíí nguɛ́ɛ́ ndúú ángeles yeⁿ'e va'ai chɛɛti nguuvi, ti dámaaⁿ Ndyuūs Chiidá deenú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Tan'dúúcā chí chiī tiempo chi 'āā chó'ōo taachi canéé Noé miiⁿ tiempo taachi chó'ōo diluvio, 'tíícā cuuvi taachí ndaā Saⁿ'ā chi Daiya Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ní tiempo taachi 'āā cuɛ́ɛ́ chó'ōo diluvio chi cueeⁿ taaⁿ cuūvī, 'iiⁿ'yāⁿ ní ngé'e yā, ní ngi'i yā, ní n'giindivaacu yā, ní nga'a yā daiya yā chí n'giindivaacu, ndíí nguuvi chi Noé miiⁿ sndaa yā na arca chi barco ch'ɛɛtɛ ca chí din'dái yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ní 'iiⁿ'yāⁿ yeⁿ'e tiempo yeⁿ'e Noé nguɛ́ɛ́ s'neeⁿ veéⁿ yā ndíí taachi cheeⁿ taaⁿ cuūvī ní ch'iīnū nducyáácá 'iiⁿ'yāⁿ ti ch'īi yā. 'Tiicá ntúūⁿ cuuvi taachí ndaa Saⁿ'ā chi Daiya Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tuu'mi ní nguuvi taachi nndaa Daiya Ndyuūs snéé 'uūvī saⁿ'ā na cuɛɛti. 'Aama saⁿ'ā ní Cristo candɛ́ɛ yā saⁿ'ā, taama saⁿ'ā ní cūnee sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ní na 'uūvī n'daataá snee ta ingúú tá 'áámá va'aī naachi inguú yā. 'Aama tá ní candɛɛ yā táⁿ'ā, taama ta ní cūnee ta. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndís'tiī cundɛ́ɛ nī cuidado, ti nguɛɛ déénu nī dɛ'ɛ̄ hora chi nndaá Señor yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Naati déénu nī chuū. Ndúúti chi saⁿ'ā n'dai chi vaacu sa miiⁿ déénu sa dɛ'ɛ̄ hora ndaa chí duucu tuu'mi ní canduuchi sa. Ní nguɛ́ɛ́ ca'a sa lugar chí diduucú yā chi vɛ́ɛ́ chɛɛti vaacu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Chííⁿ chí ndís'tiī ní 'cuɛɛtinéé yaaⁿ nī ti Saⁿ'ā chi Daiya Ndyuūs miiⁿ ndaa yā hora chi ndís'tii nguɛ́ɛ́ déénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Caⁿ'a Jesús: ¿Du'ú dueño caⁿ'a yā ntiiⁿnyuⁿ chi s'nee yā vmnaaⁿ yeⁿ'e va'ai yeⁿ'é yā nduuti chi nguɛ́ɛ́ 'aama mayordomo chi n'daācā n'dai ní deenu sa ní ca'a sa chi che'e mozos yeⁿ'é yā hora chi che'e sa? ");
INSERT INTO cuxNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Dɛ'ɛ chúúcā n'dai mayordomo miiⁿ chí diíⁿ sa ntiiⁿnyuⁿ taachi dueño miiⁿ ní ndāa yā ní ndaaca yā mayordomo chí diiⁿ sa tan'dúúcā chi neⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chí dueño miiⁿ cu'néeⁿ yā mayordomo miiⁿ chí caaⁿ'maⁿ ntiiⁿnyuⁿ sa yeⁿ'ē chí vɛ́ɛ́ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ndúúti chi mayordomo miiⁿ ní nguɛ́ɛ́ n'dáacā idiiⁿ sá ní 'íícú nacádíínuuⁿ sa na staava yeⁿ'ē sa chi dueño cuuvi 'náaⁿ yā ní ndaa yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ní tucá'a sa ch'eⁿ'e sa mozos chi idiiⁿ sa ntiiⁿnyuⁿ ndúúcu sa ní ngé'e sa ní ngi'i sa ndúúcū amigos yeⁿ'e sa ní cuu'vi sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dueño miiⁿ ní ndaá yā nguuvi chi nguɛɛ canéé ngíínú sa ní hora chi nguɛɛ deenu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ní dueño miiⁿ ní ca'á yā 'aama castigo ch'ɛɛtɛ mayordomo miiⁿ. Ní 'caacá yā mayordomo chi cheeyēī ní cu'neeⁿ yā mayordomo miiⁿ chuva'āī ndúúcū 'iiⁿ'yāⁿ 'uuvi nááⁿ 'uūvī cheendi yā. Lugar miiⁿ ní cuɛɛcu sa ní che'e 'diiⁿ'yuⁿ sa cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús caⁿ'a yā taama ejemplo: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi tan'dúúcā ndiichi n'daataa chi cuíínuú chi sta'á yā lámparas yeⁿ'e yā ní can'dáa yā. Ní cueⁿ'e yā ndaāca yā saⁿ'ā chi 'caandavaacú sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ní nyuⁿ'u yā candɛ́ɛ̄ n'daāca yā cuidado ti lista yā. Tá nyuⁿ'u yā nguɛ́ɛ́ candɛ́ɛ yā cuidado ní diíⁿ yā tan'dúúcā chi n'daataá tonta yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","N'daataa chi cuíínuú chi nguɛ́ɛ́ candɛɛ yā cuidado, candɛ́ɛ yā lámparas yeⁿ'e yā ní nguɛ́ɛ́ candɛɛ yā petróleo yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ní nyuⁿ'u yā ní candɛɛ n'daacá yā cuidado, candɛɛ yā botellas yeⁿ'e petróleo ndúúcu yā ndúúcū lámparas yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ní chi'naaⁿ saⁿ'ā miiⁿ chi ndaa sa chi 'caandavaacu sa. Ní taachi 'āā cuɛ́ɛ́ ndaa sa, n'daataá s'eeⁿ chi ndaā yááⁿ nááⁿ yā ní ch'ɛɛti yaadú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Chí maⁿ'ā yaaⁿ, ch'iindiveéⁿ yā 'áámá nduudu chí 'caī. Ní ngaⁿ'a yā: Ndaa sáⁿ'ā chi 'caandavaacu sa. Can'dáa nī ní diíⁿ nī recibir saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tuu'mi ní nducyaaca chi cuíínuú s'ééⁿ nducueeⁿ yā ní nuuⁿ'mí yā lámparas yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chi cuíínuú chi nguɛ́ɛ́ lista yā caⁿ'a yā chii yā chi cuíínuú chi lista yā: Tée nī 'tɛ́ɛ́ petróleo yeⁿ'é nī nús'uu ti lámparas yeⁿ'é 'nū 'āā cháā 'āā n'tuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Chí cuíínuú chi candɛɛ yā petróleo n'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā tanáⁿ'a yā: Nguɛ́ɛ́ cuuvi teé 'nū ndís'tiī. Nús'uū ní neⁿ'e cá 'nū petróleo chi candɛɛ́ 'nū ní 'íícú 'áátiī nguɛ́ɛ́ cuuvi falta yeⁿ'e yú. N'dáaca ca yeⁿ'e ndís'tiī chi caⁿ'a nī naachí in'diicuí yā petróleo ní cuái nī yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Neⁿ'e chi n'daātā s'eeⁿ chi nguɛɛ lista yā cueⁿ'e yā cuái yā petróleo miiⁿ, saⁿ'ā chi 'caandavaacu sa ndaa sa ní chi cuíínuú chi candɛɛ n'daacá yā cuidado cueⁿ'é yā ndúúcū saⁿ'ā naachí n'giindivaacu 'iiⁿ'yāⁿ. Ní saⁿ'ā miiⁿ nan'gaādí sá cheendi va'āī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Cuayiivi miiⁿ ní ndaā tanáⁿ'ā chi cuíínuú s'eeⁿ ní caⁿ'a yā: N'diī Señor, Señor, nan'guaaⁿ nī yeⁿ'é 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naati saⁿ'ā miiⁿ chi 'caandavaacu sa ní nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: Cuaacu nííⁿnyúⁿ nga'á ngií ndís'tiī, 'úú ní nguɛ́ɛ́ n'diichí ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Maaⁿ ní nducyaaca ndís'tiī candɛ́ɛ nī cuidado ti nguɛ́ɛ́ déénu nī dɛ'ɛ̄ nguuvi o dɛ'ɛ̄ hora chi Saⁿ'ā chi Daiya Dendyuūs nndaa sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tuu'mi ní caⁿ'a Jesús: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā na va'ai chɛɛti nguuvi tan'dúúcā 'áámá saⁿ'ā chi caⁿ'ā yaⁿ'áí yā ndii táámá yáⁿ'āa ní 'cai yā mozos yeⁿ'e yā ní nca'a yā mozos miiⁿ dendú'ū chi vɛ́ɛ́ yeⁿ'e yā, chi diiⁿ sa cuidado yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Aama mozo ní ca'a yā nyuⁿ'u mil caadi, táámá mozo ní 'uūvī mil caadi, táámá mozo ní 'aama mil caadi. Ní ca'a yā 'áámá 'áámá mozo tan'dúúcā chi chɛɛ sa. Ní cueⁿ'ē yaⁿ'áí yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mozo chí sta'ā nyuⁿ'u mil caadi cunaⁿ'ā sa ní diīⁿ sa negocio ndúúcū tuumī miiⁿ. Ní ndaācā sa tá nyuⁿ'u mil caadi yeⁿ'e daiya túumī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Tiicá ntúūⁿ mozo chí sta'a sa ná 'uūvī mil caadi miiⁿ ndaācā sa ná 'uūvī mil caadi yeⁿ'ē daiya tuumi miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mozo chi sta'ā sa 'aama mil caadi cheⁿ'e sa ní s'neeⁿ sa tuūmī miiⁿ chɛɛti 'áámá 'cuutií cuéeé ní ch'ii sa maaⁿ yáⁿ'āa. 'Tíícā chinuuⁿ n'dé'ei sa tuumī yeⁿ'e 'iiví sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chi 'naáⁿ ní ndaā 'iivi mozos miiⁿ ní tun'dáa yā cuenta ndúúcū mozos. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ndaā mozo chi nca'a yā nyuⁿ'u mil caadi nanáaⁿ yā. Ndɛ́ɛ sa ta nyuⁿ'u mil caadi yeⁿ'ē daiya tuūmī miiⁿ. Ní caⁿ'a sa chii sa 'iiví sa: N'diī señor, nyuⁿ'u mil caadi tee nī 'úú. 'Ííngaā. Ndaācá ta nyuⁿ'u mil caadi daiya tuūmī yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Iivi mozo miiⁿ ní caⁿ'a yā chii yā saⁿ'ā: Dii mozo yeⁿ'é chí n'daācā ní n'dai, n'daācā n'dai n̄díiⁿ di. Maaⁿ ti 'āā n'daācā diiⁿ di ndúúcū chí duū'vi, maaⁿ ní caaⁿ'maⁿ ntiiⁿnyuⁿ di yeⁿ'e n'deēe cá teé dii. Cho'o di cuaaⁿ chɛɛti va'āī ní cueⁿ'e daāⁿmaⁿ cuuvi yeenú di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ndaā ntúūⁿ nanáaⁿ yā mozo chi nca'a yā na 'uūvī mil caadi. Mozo miiⁿ ní caⁿ'a sa chii sa 'iivi sa: N'diī señor, 'ūūvi mil caadi tee nī 'úú. 'Ííngaā tuumi yeⁿ'e nī. Ndaācá ta na 'uuvi mil caādī daiya tuūmī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Iivi sá caⁿ'a yā chii yā saⁿ'ā: Díí mozo yeⁿ'é chi n'daācā ní n'dai, ní n'daācā idiiⁿ di. Nguɛ́ɛ́ ch'ɛɛtɛ teé dii ní n'daācā diíⁿ di. Maaⁿ ní caaⁿ'maⁿ ntiiⁿnyuⁿ yeⁿ'e n'deēe ca chi teé dii. Cho'o di cuaaⁿ chɛɛti va'āī ní cueⁿ'e daāⁿmaⁿ cuuvi yeenú di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ndaa nanáaⁿ yā mozo chí nca'á yā 'áámá mil cáádí, ní caⁿ'a sa chii sa 'iivi sa: N'diī Señor, deenú tí n'diī ní chɛɛchí nī, ní diíⁿ nī cosechar ndúúcū tuumī yeⁿ'é nī chi nguɛ́ɛ́ ngiinu nī, ní 'naaⁿ trigo ngaáⁿ nī naachí nguɛ́ɛ́ ngiinu nī ti yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chííⁿ chí diíⁿ ti 'va'á. Ní cheⁿ'é ní s'nuuⁿ n'de'eí tuūmī yeⁿ'e nī na 'áámá yiivi yáává maaⁿ yáⁿ'āa. 'Ííngaā tuūmī yeⁿ'e nī chi tee nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Iivi sa mííⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā mozo miiⁿ: Díí mozo chi nguɛɛ n'dáacā ní 'daān'dī dii. Ní nguɛ́ɛ́ n'dáacā ídiīiⁿ. Díí ní déénu di chí ntā'a cosecha naachi nguɛ́ɛ́ n̄diíⁿ ntiiⁿnyuⁿ ní nn'guaáⁿ trigo naachi nguɛ́ɛ́ ngiinú ti yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Dɛ'ɛ̄ cúúví chi nguɛ́ɛ́ s'neeⁿ di tuūmī yeⁿ'é na banco? Ní taachi 'úú ndaá cuuvi ntee di tuūmī yeⁿ'é ndúúcū daiya tuūmī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Iivi miiⁿ caⁿ'a yā ndúúcū 'iiⁿ'yāⁿ chi snéé miiⁿ: N'diī, divíi nī tuūmī yeⁿ'ē sa ní ca'a nī tuūmī mozo chi ndɛɛ̄ ndiichi mil caadi. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ti 'iiⁿ'yāⁿ chi vɛ́ɛ́ yeⁿ'e yā, ní ndaācā ca yeⁿ'e yā. Ní 'iiⁿ'yāⁿ miiⁿ n'deēe cá vɛɛ yeⁿ'e yā. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā, ta 'lííⁿ duū'vi chi vɛ́ɛ́ yeⁿ'e yā ní divíi yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mozo chi nguɛɛ dichíí'vɛ̄ ní cuta'á nī ní cu'nuuⁿ nī cuaaⁿ chuva'āī ná maaíⁿ. Mííⁿ cuɛɛcu sa ní che'e 'dííⁿ'yúⁿ sá cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ní caⁿ'a Jesús: Taachí ndaa Saⁿ'ā chi Daiyā Dendyuūs tan'dúúcā Rey chí ch'ɛɛtɛ ca ní n'dɛɛvɛ taavi ndúúcū tanducuéⁿ'ē ángeles yeⁿ'e yā, tuu'mi ní saⁿ'ā miiⁿ 'cuūndi sa na trono yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ní nduuvidaama nanááⁿ Rey miiⁿ 'iiⁿ'yāⁿ yeⁿ'e nducyaaca naciones ní Rey miiⁿ divíi yā 'iiⁿ'yāⁿ, 'áámá yā yeⁿ'e táámá yā tan'dúúcā chi 'iiⁿ'yāⁿ pastor chi idiiⁿ yā cuidado yeⁿ'e 'iiti cuūchī divíi yā chiivu nguaaⁿ 'iiti cuūchī. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ní cu'neeⁿ yā 'iiti cuūchī lado tá cuaacú yā ní chiivú miiⁿ lado ta 'cueé yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tuu'mi ní Rey miiⁿ caaⁿ'máⁿ yā cuuvi yā 'iiⁿ'yāⁿ lado ta cuaacu yā: Ndís'tiī chi Chiidá ngaⁿ'a yā yeⁿ'e nī n'dáí taavi nī. Cuchíi nī. 'Ííngaā parte chi ituneeⁿ ndís'tiī yeⁿ'ē naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní nguaiⁿn'dai yā yeⁿ'ē ndís'tiī ndíí taachi Ndyuūs 'āā cuɛ́ɛ́ din'dái yā iⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tí taachí cuiīcú, ní tee nī chi che'é. Ní taachí chi yaācá, ní tee nī chí chi'í. Ní taachí canuúⁿ yúúní tan'dúúcā 'iiⁿ'yāⁿ chí ndiicá yā táámá yáāⁿ, ndís'tiī 'cuúⁿ nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ní taachi 'āā ntɛ́ɛ́ catecaí, ní tee nī catecaí. Ní taachi chíítā 'úú, dicuéénaaⁿ nī 'úú. Ní taachi cheⁿ'é vácūū, ní ndaa nī n'diichi nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tuu'mi ní 'iiⁿ'yāⁿ chi n'dáí yā nan'guɛɛcútaⁿ'a ní caⁿ'a yā cuuvi yā 'iiⁿ'yāⁿ: N'diī señor, ¿tií cuaⁿ'ā n'diichí 'nū n'diī chí cuiicu nī ní tee 'nū chi che'é nī, o yaacá nī ní tee 'nū chi chi'i nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tií cuaⁿ'ā n'diichí 'nū n'diī cuaaⁿ cyúúní ní nta'á 'nū n'diī na vaacú 'nū, o nguɛ́ɛ́ catecaí nī ní tee 'nū catecai nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O ¿tií cuaⁿ'ā n'diichí 'nū n'diī chi ngííta nī o vácūū canuuⁿ nī, ní níndaá 'nū nanáaⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Rey miiⁿ ní nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'uuⁿ: Cuaacu nííⁿnyúⁿ 'úú ngaⁿ'á ngií ndís'tiī, ti taachi diíⁿ nī 'tíícā ndúúcū 'áámá hermano 'áárá chi ndíícúúⁿ cá yā, tuu'mi ní 'tiicá ntúūⁿ diíⁿ nī nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tuu'mi ní Rey caaⁿ'maⁿ ntúuⁿ yā cuuvi yā 'iiⁿ'yāⁿ chi snée lado ta 'cueé yā: Cuvíi nī yeⁿ'ē 'úú, ndís'tiī, 'iiⁿ'yāⁿ condenado chi nguɛ́ɛ́ n'daācā idiíⁿ nī. Ní caⁿ'a nī ná nguuchi yaⁿ'ā chí 'áámá ngiichi cueⁿ'e daāⁿmaⁿ. Lugar 'cūū ní n'dai cááva yááⁿn'guiinūuⁿ ndúúcū ángeles yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tí taachí cuiicú, nguɛ́ɛ́ tee nī chi che'é. Chiī yaācá, ndíí nguɛ́ɛ́ ndúú tee nī chi chi'í. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Canuúⁿ yúúní, ndíí nguɛ́ɛ́ ndúú 'cuúⁿ nī 'úú. 'Āā ntɛ́ɛ́ catecaí, ndíí nguɛ́ɛ́ ndúú tee nī catecaí. Chíítā 'úú ní canuúⁿ vácūū, ndíí nguɛ́ɛ́ ndúú dicuéénaaⁿ nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: N'diī señor, ¿tií cuáⁿ'ā n'diichí 'nū n'diī chi cuiicú nī, o yaācá nī, o canúuⁿ nī yúúní, o nguɛɛ catecai nī, o ngííta nī, o vácūū cánuuⁿ nī, ní nguɛ́ɛ́ dichíí'vɛ 'nū n'diī? ");
INSERT INTO cuxNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tuu'mi ní Rey miiⁿ nan'guɛɛcútaⁿ'a yā ní caaⁿ'maⁿ yā cuuvi yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, tan'dúúcā chi nguɛ́ɛ́ diíⁿ nī ndúúcū 'áámá chi ndíícúúⁿ cá 'tiicá ntúūⁿ 'úú, nguɛ́ɛ́ diíⁿ nī nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā na 'áámá castigo chi 'áámá canee ní 'iiⁿ'yāⁿ chí n'dáí yā caⁿ'á yā ná vida cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Taachí Jesús ch'iinu caⁿ'a yā tanducuéⁿ'ē nduudú 'cūū, caⁿ'a yā chii yā discípulos yeⁿ'e yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","'Āā déénu ndís'tiī ná 'uūvī nguuvi maaⁿ cuūvā 'viicu yeⁿ'ē pascua. 'Íícu 'úú Saⁿ'ā chi Daiya Dendyuūs 'úú ní 'iiⁿ'yāⁿ nca'a yā 'úú ní cu'nééⁿnga'a yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tuu'mi ní chiiduú n'gɛɛtɛ ndúúcū maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ ndiicúū s'eeⁿ chí ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'é yaācū nduuvidaamá yā na palacio yeⁿ'ē chiiduú ch'ɛɛtɛ́ ca chí nguuvi Caifás. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ní ndeé yā taācā cuuvi cannche'éí yā Jesús ní cuta'á yā 'iiⁿ'yāⁿ ní 'caaⁿ'núⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ní caⁿ'a yā: Nguɛ́ɛ́ diiⁿ yú nguuvi 'viicu ti 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ didáⁿ'a yā ní diíⁿ yā vaadī 'caa'va ndúúcū nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús canée yā na yáāⁿ Betania ná va'ai yeⁿ'e Simón chi canéé ca'ai lepra chi in'duuti yuūtɛ̄ yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ní ndaā 'áámá n'daataá nanááⁿ Jesús miiⁿ chi ndɛ́ɛ̄ tá 'áámá frasco tuūu alabastro chi s'néēⁿ aceite perfume chí yaⁿ'ai n'dai chíí'vɛ̄. Ní ch'eēndáa ta perfume miiⁿ na tíīⁿ Jesús taachí vɛɛ yā na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ní discípulos taachi n'diichí yā chūū nduuvi taáⁿ yā. Ní caⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chí chingéē aceite 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Cuuví n'diicui ta chuū ti yaⁿ'ai n'dai chíí'vɛ̄ chuū ní ca'a tá tuūmī miiⁿ 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús tuumicadíínuuⁿ yā chi discípulos ngaⁿ'a yā 'tíícā, ní caⁿ'a yā chii yā discípulos: ¿Dɛ'ɛ cúúví chí n'gaa'va nī ndúúcū n'daataá 'tíī? Táⁿ'a 'tīī n'dáacā diiⁿ tá nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ti 'iiⁿ'yāⁿ chi nguɛ́ɛ́ vɛ́ɛ́ yeⁿ'é yā ní 'áámá cánée yā nduucú nī, naati 'úú ní nguɛ́ɛ́ 'aama cuneé nduucú nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Taachi tá 'tīī ch'eēndáā ta perfume vmnááⁿ cuerpo yeⁿ'é, ndaā ta 'úú tí taachí 'cuūví 'āā canee listo cuerpo yeⁿ'é chí 'cuɛɛ̄chí. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chí 'āā tií nūuⁿ chi caaⁿ'máⁿ yā ndúúdú ngai yeⁿ'e chi nanguaⁿ'ai 'iiⁿ'yāⁿ na núúⁿmáⁿ iⁿ'yeēⁿdī, caaⁿ'maⁿ ntuúⁿ yā chi tá 'tīī diiⁿ tá chuū ní n'gaacu yā yeⁿ'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tuu'mi ní 'áámá discípulo yeⁿ'ē naachi ndiichúúví yā chí nguuvi sa Judas Iscariote, cheⁿ'e sá nanááⁿ chiiduú n'gɛɛtɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ tée nī 'úú ní 'cuuⁿ'míⁿ ndís'tiī du'u chi Jesús? 'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chi nadii'vɛ́ yā Judas miiⁿ ndiīcū ndiichi caadi 'dííⁿnguɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ndíí tuu'mí nūuⁿ in'nuuⁿ yíínú Judas miiⁿ dɛ'ɛ̄ tiempo ní táácā chí nca'a sa Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nguuvi vmnááⁿ vmnaaⁿ yeⁿ'e 'viicu pascua, nguuvi yeⁿ'e pan chi nguɛ́ɛ́ levadura yeⁿ'ē, discípulos ní ndaa yā nanááⁿ Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: ¿Tií neⁿ'e nī chi in'nuúⁿ 'nū chi che'e nguiīnū yú mááⁿ yeⁿ'e 'viicu yeⁿ'e pascua? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Níícú Jesús caⁿ'a yā chii yā discípulos: Cueⁿ'é nī na yáāⁿ Jerusalén ni ndaacá nī 'áámá saⁿ'ā ní caaⁿ'maⁿ nī cuuvi nī saⁿ'ā: Maestro yeⁿ'e yú caⁿ'a yā 'túúcā: Tiempo yeⁿ'e chí 'cuūví 'āā snee niiⁿnuúⁿ ní neⁿ'é diíⁿ 'viicu yeⁿ'e pascua ndúúcū discípulos yeⁿ'é na va'ai yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Discípulos diíⁿ yā tan'dúúcā chi Jesús dicho'ó yā chi diiⁿ yā. Ní in'nuúⁿ yā chi che'e yā yeⁿ'e 'viicu yeⁿ'e pascua. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Taachi 'āā chii chiīnū miiⁿ, Jesús ch'iindi yā na mesa ndúúcū ndu'u ndiichúúví discípulos. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ní taachí vɛɛtɛ́ yā ní nge'e yā Jesús caⁿ'a yā: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi 'áámá chɛ́ɛ́ ndís'tiī dií nī entregar 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Discípulos s'neeⁿ ndaachi yiinú yā. 'Áámá 'áámá yā ní tucá'á yā caⁿ'a yā: N'dií Señor, ¿'áá 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tuu'mi ní Jesús nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: 'Iiⁿ'yāⁿ chi nduucú ní di'caandá yā pan yeⁿ'é yā na cú'ú 'cūū nduucú, 'iiⁿ'yāⁿ 'cúū ní nca'a yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Cuaacu nííⁿnyúⁿ cuuvi ndúúcū Saⁿ'ā chi Daiya Dendyuūs tan'dúúcā chi canéé nguūⁿ yeⁿ'ē sa na libro yeⁿ'é Ndyuūs, naati dɛ'ɛ chúúcā ya'āī yeⁿ'e saⁿ'ā chí nca'a sa 'úú chí Saⁿ'ā chi Daiya Dendyuūs. N'dáacā ca yeⁿ'ē sa nduutī chi nguɛ́ɛ́ ch'iīndiyáaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tuu'mi ní Judas, saⁿ'a chi neⁿ'e nca'a sa Jesús, ní caⁿ'a sa: ¿'Áá 'úú, Maestro? Jesús caⁿ'a yā chii yā Judas: Díí, ngaⁿ'a di 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Taachí 'iiⁿ'yāⁿ s'uuⁿ nge'e yā, Jesús miiⁿ sta'á yā pan ní ca'á yā gracias Ndyuūs cáávā pan miiⁿ. Ní n'deé yā pan ní ca'a yā discípulos yeⁿ'e yā. Ní caⁿ'a yā: Cuta'á nī, che'e nī pan caati tan'dúúcā cuerpo yeⁿ'é 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ní Jesús sta'á yā taza ndúúcū jugo yeⁿ'e uvas ní ca'á yā gracias Ndyuūs cáávā nuūⁿnīⁿ uvas miiⁿ, ní ca'a yā discípulos yeⁿ'e yā. Ní caⁿ'a yā: Nducyaaca ndís'tiī, cu'u nī nuūⁿnīⁿ uvas yeⁿ'e taza 'cūū, ");
INSERT INTO cuxNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ti jugo nuūⁿnīⁿ uvas miiⁿ ní tan'dúúcā yuūuⁿ yeⁿ'é ní yeⁿ'ē compromiso chi ngai yeⁿ'é. Yuūú yeⁿ'é chi cungéē cáávā 'yaaⁿ n'dai 'iiⁿ'yāⁿ, 'tíícā. Yuūúⁿ yeⁿ'é chííⁿ chi nch'ɛɛ̄cú nuuⁿndi yeⁿ'e nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'Úú ní ngaⁿ'á ngií ndís'tiī chí 'āā ntɛ́ɛ́ cu'ú jugo nuūⁿnīⁿ yeⁿ'ē uvas na iⁿ'yeeⁿdí 'cūū ndii nguuvi chi cu'ú ndúúcū ndís'tiī naachi Chiidá ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Taachí ch'iinu chiita yā 'áámá canción yeⁿ'é Ndyuūs nan'dáa yā va'āī ní cueⁿ'é yā na yiīcū chi nguuvi Olivos. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos: Nducyáácá ndís'tiī cuuví 'cuináaⁿ nī yeⁿ'e 'úú maaⁿnguíinū. Caati ngaⁿ'a naachi canéé nguūⁿ na libro yeⁿ'é Dendyuūs 'túúcā: 'Úú Ndyuūs 'nuūcá'ai ní 'caaⁿ'núⁿ saⁿ'ā chí idiiⁿ sa cuidado 'iiti cuūchī, ní 'iiti s'eeⁿ ní caⁿ'á 'múúⁿ caⁿ'á miiⁿ tī ní cuuví ndai tī. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Taachí 'úú nduuchí nguaaⁿ tináⁿ'ā, caⁿ'á vmnaaⁿ yeⁿ'e ndís'tiī na yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tuu'mi ní Pedro miiⁿ ní nan'guɛɛcútaⁿ'a sa ní caⁿ'a sa chii sa Jesús: 'Áárá chi nducyaaca yā cuuví 'cuinaaⁿ yā cáávā n'diī 'úú nguɛ́ɛ́ cuuví 'cuinaáⁿ mar 'aamá naaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tuu'mi ní Jesús caⁿ'a yā chii yā Pedro: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií dii chi maaⁿnguíinū taachi 'āā cuɛ́ɛ́ 'cuaī túsaⁿ'ā, dii ní 'āā 'iinū cuuvi cueeⁿdiītū di yeⁿ'ē 'úú chi nguɛ́ɛ́ in'diichi di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naati Pedro miiⁿ caⁿ'a sa: Ndúúti chi canéé chí 'cuūví nduucú nī maestro ní 'cuūví. Nguɛ́ɛ́ caaⁿ'máⁿ chi nguɛ́ɛ́ n'diichí n'diī. Ní nducyaaca discípulos ní 'tiicá ntúūⁿ caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tuu'mi ní ndaā Jesús ndúúcū discípulos yeⁿ'é yā na 'áámá cuaaⁿ chi nguuvi Getsemaní ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: 'Cuɛɛtɛ́ nī 'muuⁿ. 'Úú ní caⁿ'a niiⁿnuúⁿ miiⁿ ní caaⁿ'maⁿngua'á. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús miiⁿ cueⁿ'e yā ndúúcū Pedro ndúúcū nduu 'uuvi saⁿ'ā daiya Zebedeo. Tuu'mi ní Jesús s'neeⁿ ndaachi yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'uuⁿ: Alma yeⁿ'é ní nééné ndaachí yiīnú chi ya'āī chí 'cuūví. 'Cuɛɛtinée nī 'muuⁿ ní 'cuɛɛti nduuchí nī nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús ní cueⁿ'é yā ta 'lííⁿ cuááⁿ vmnaaⁿ. Candiitin'dii yā ní caⁿ'angua'a yā ní caⁿ'a yā: N'diī Chiidá, ndúúti chi cuuvi, nguɛ́ɛ́ diíⁿ nī chi 'cueenú cuuvi prueba 'cūū naati nguɛ́ɛ́ cuuvi tan'dúúcā chi 'úú neⁿ'é naati tan'dúúcā chi n'diī neⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tuu'mí nūuⁿ ndaá yā naachi snéé discípulos yeⁿ'e yā ní ndaāca yā 'iiⁿ'yāⁿ chi stiyaadú yā. Ní caⁿ'a yā chii yā Pedro: ¿'Áá 'tíícā nguɛ́ɛ́ íchɛ́ɛ́ dí chi induūchi dí nduucú 'áámá hora? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ndís'tiī ní candɛ́ɛ nī cuidado ní caaⁿ'maⁿngua'á nī níícú nguɛ́ɛ́ diíⁿ nī nuuⁿndi. Cuaacu nííⁿnyúⁿ espíritu yeⁿ'e nī neⁿ'e diiⁿ n'daacáā naati cuerpo yeⁿ'é nī 'āā dūūvā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús cheⁿ'e chi ndii 'úúví cuuvi ní caⁿ'angua'á yā ní caⁿ'a yā: N'diī Chiidá, ndúútī chi neⁿ'é nī, diíⁿ nī chi nguɛ́ɛ́ 'cueenú cuuvi prueba 'cuu chi n'daācā tuu'mi ní 'tíícā diíⁿ nī, naati cuuvi tan'dúúcā chi neⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jesús nndaa ntuuⁿ yā táámá vmnéⁿ'ēe naachi snéé discípulos yeⁿ'é yā ní ndaaca ntúuⁿ yā 'iiⁿ'yāⁿ stiyaadú yā ti 'iiⁿ'yāⁿ s'eeⁿ 'āā ntɛ́ɛ́ ichɛɛ yā nduutináaⁿ yā chi yaāⁿnnáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesús miiⁿ ní nguɛ́ɛ́ yaa'vi yā discípulos ní s'neeⁿ yā 'iiⁿ'yāⁿ chí stiyaadú yā. Ní cueⁿ'e ntúuⁿ yā ní caⁿ'angua'á ntúuⁿ yā ndii chii ndiiⁿ 'íínú cuuvi ní caⁿ'a ntuuⁿ yā tan'dúúcā chi 'āā ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Cuayiivi ní ndaa ntuuⁿ yā nanááⁿ discípulos ní cáⁿ'a yā chii yā discípulos: 'Cuɛɛtiyaadú nī ní ntaavi'tuunúúⁿ nī. Cuin'diichí nī tī 'āā ndaā hora yeⁿ'e 'úú chí Saⁿ'ā chi Daiya Dendyuūs. 'Iiⁿ'yāⁿ nca'a yā 'úú tá'a saⁿ'ā s'eeⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e sā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nducueeⁿ ndís'tiī ní cúⁿ'u yú. 'Āā cuchii niiⁿnuúⁿ saⁿ'ā chi nca'a 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","'Naaⁿ chí Jesús indeé yā, ndaā Judas miiⁿ, 'áámá saⁿ'ā yeⁿ'ē ndu'u ndiichúúví discípulos. Ní nééné 'yaaⁿ 'iiⁿ'yāⁿ ndaá yā ndúúcū Judas miiⁿ ndúúcū machetes 'uūvī lados 'caāiⁿ ndúúcū yáⁿ'á. Chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū s'eeⁿ chí ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū dichó'o yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas miiⁿ chi nca'a sá Jesús 'iiⁿ'yāⁿ s'eeⁿ, ca'a sa 'áámá seña ní 'túúcā caⁿ'a sa: 'Iiⁿ'yāⁿ chi 'úú chi'neeⁿ cheendí, 'iiⁿ'yāⁿ miiⁿ chí 'iiⁿ'yāⁿ chi cuta'a nī chi preso yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tuu'mi ní Judas miiⁿ ní ndaa sa nanááⁿ Jesús miiⁿ ní caⁿ'a sa: Tavacho'onoó nī, n'diī Maestro. Ní 'neeⁿ cheendi sá Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús miiⁿ ní caⁿ'a yā chii yā Judas: Díí, amigo yeⁿ'é, ¿dɛ'ɛ̄ cáávā chi cuchiī di? Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ní ndaa yā nanááⁿ Jesús miiⁿ ní sta'á yā Jesús ní candɛ́ɛ yā 'iiⁿ'yāⁿ preso. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Naati 'áámá saⁿ'ā chi canéé sá ndúúcū Jesús miiⁿ ní tun'dáa sa machete 'uūvī lados 'caāiⁿ ná chɛɛ̄tī vaacu ní 'nuūcá'ai sa 'áámá mozo yeⁿ'ē chiiduú ch'ɛɛtɛ́ ca ní ch'iica sa veēeⁿ mozo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tuu'mi ní Jesús caⁿ'a yā chii yā saⁿ'ā: 'Nuūⁿ di machete 'uūvī lados 'caāiⁿ yeⁿ'ē di vaacu. Nducyaaca 'iiⁿ'yāⁿ chi ita'á yā machete 'uūvī lados 'caāiⁿ ní ndúúcū machete 'uūvī lados 'caāiⁿ 'cuūvī. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿'Áá nguɛ́ɛ́ déénú dí chi 'úú cuuví caaⁿ'maⁿnguā'á ní caacá Chiidá ní miⁿnííⁿyúⁿ miⁿniiⁿyuⁿ cho'ó yā nanááⁿ 'úú taanduu ngo'oó ndiichúúví taāⁿ ángeles ní chiidá cuuvi diíⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Naati maaⁿ ní nduuti chi diíⁿ chuu ¿táácā cuuvi cúúnú ca'a naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs, chi canéé chí cuuvi 'tíícā? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Hora miiⁿ Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí can'daa nī ndúúcū machetes 'uūvī lados 'caāiⁿ ndúúcū yáⁿ'á s'eeⁿ tan'dúúcā chi 'úú 'iiⁿ'yāⁿ chi duucu 'úú chi sta'á nī 'úú? Nguuvi nguuvi ch'iindí ndúúcū ndís'tiī na yaācū templo ní ngi'cueeⁿ ndís'tiī ní nguɛ́ɛ́ sta'á nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tanducuéⁿ'ē chuū cuuví ní cúúnú ca'a yeⁿ'ē chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs cáávā profetas ndii cuááⁿ vmnaaⁿ. Tuu'mi ní nducyaaca discípulos s'néeⁿ yā Jesús miiⁿ ní chéénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","'Iiⁿ'yāⁿ chi sta'á yā Jesús miiⁿ candɛɛ yā 'iiⁿ'yāⁿ miiⁿ nanááⁿ chiiduú ch'ɛɛtɛ́ ca chí nguuvi Caifás. Mííⁿ nduuvidáámá maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ ndiicúū s'eeⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro miiⁿ cueⁿ'e ntúuⁿ sa ní n'dáa yaⁿ'ai sa cuaaⁿ dáámí Jesús ndíí chuva'āī yeⁿ'ē va'ai ch'ɛɛtɛ yeⁿ'ē chiiduú ch'ɛɛtɛ cá. Ní ndaa sa na patio ní ch'iīndī sa ndúúcū policías chi diíⁿ yā cuidado yeⁿ'e va'āī miiⁿ. Pedro neⁿ'e sa snaaⁿ sa táácā chi diíⁿ yā ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū s'eeⁿ chí ngaⁿ'a ntiiⁿnyuⁿ yā yeⁿ'e yaācū ndúúcū nducyaaca 'iiⁿ'yāⁿ chí ngaⁿ'a ntiiⁿnyuⁿ yā in'nuúⁿ yā 'áámá testigo chi nguɛ́ɛ́ ngaⁿ'a cuaacu yeⁿ'ē Jesús miiⁿ. Ní 'íícú cuuvi nca'a yā Jesús miiⁿ chí 'cuuvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Nguɛ́ɛ́ ndaaca yā mar 'áámá naaⁿ taācā chí 'caaⁿ'nuⁿ yā Jesús miiⁿ. 'Áárá chi neené 'yaaⁿ 'iiⁿ'yāⁿ caⁿ'a yā nduudu yaadi yeⁿ'e Jesús miiⁿ. Cuayiivi miiⁿ ní ndaa ntúūⁿ tanaaⁿ 'uūvī testigos chí ngaⁿ'a yā nduudu yaadi. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Testigos ní caⁿ'a yā: Sáⁿ'a 'cūū ní caⁿ'a sa: 'Úú ní cuuvi diíⁿ chuū. Natuūví yáacū templo 'cūū chi yeⁿ'é Ndyuūs naati chɛɛtī 'iīnū nguuvi nadan'daí. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Chiiduú ch'ɛɛtɛ cá miiⁿ ní ncueeⁿ yā ní caⁿ'a yā chii yā Jesús: ¿'Áá nguɛ́ɛ́ nan'guɛɛcútaⁿ'a nī mar 'áámá nduudu yeⁿ'e dɛ'ɛ̄ chí ngaⁿ'a 'íís'tiī yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Naati Jesús nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ caⁿ'a yā. Tuu'mi ní chiiduú ch'ɛɛtɛ cá miiⁿ caⁿ'a yā: 'Úú ní n'gaí, “por Ndyuūs chi canduuchí”. Cuuvi nī nús'uu ndúúti chi n'diī chí Cristo, Daiya Ndyuūs chi cánduuchi. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús miiⁿ ní caⁿ'a yā chii yā chiiduú ch'ɛɛtɛ cá miiⁿ: 'Úú tan'dúúcā chi n'dīī ngaⁿ'a nī. Ngaⁿ'á ca ngií ndís'tiī, chí ndii maaⁿ snaaⁿ nī Saⁿ'á chi Daiya Ndyuūs 'cuūndī sa lado yeⁿ'e honor yeⁿ'é Ndyuūs chi vɛ́ɛ́ tanducuéⁿ'ē poder yeⁿ'é yā ní ndaa sa na meēeⁿ yeⁿ'ē nanguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tuu'mi ní chiiduú ch'ɛɛtɛ cá miiⁿ chíín'cuúⁿ yā catecai yā ní caⁿ'a yā: Sáⁿ'a 'cūū ní ngaⁿ'ā sa contra yeⁿ'é Ndyuūs. ¿Dɛ'ɛ̄ ca diiⁿ yú testigos chi in'nuuⁿ yú? Cuin'dííchí nī. Maaⁿ ní ndís'tiī ní n'giindiveéⁿ nī táácā ngaⁿ'a sa contra yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Dɛ'ɛ̄ nadacádíínuuⁿ ndís'tiī? 'Iiⁿ'yāⁿ s'eeⁿ ní nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: Vɛ́ɛ́ nuuⁿndi yeⁿ'e sa chi canéé chí 'cuūvī sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tuu'mi ní ca'a nee daiⁿ yā naaⁿ Jesús miiⁿ ní ch'eⁿ'é yā Jesús. Ní n'gaadi yā nduutináaⁿ sa ndúúcū tiinūuⁿ. Ní tanáⁿ'a yā ch'eⁿ'é yā 'iiⁿ'yāⁿ ndúúcū ta'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: N'dii chi Cristo, cuuví nī nús'uu, ¿du'ū chí ch'eⁿ'é n'diī? ");
INSERT INTO cuxNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro miiⁿ ní vɛɛ sa na patio yeⁿ'e va'āī ch'ɛɛtɛ chiiduú ch'ɛɛtɛ cá ní ndaa niiⁿnuúⁿ 'áámá táⁿ'ā chi canéé caadi 'iīyū. Ní táⁿ'ā miiⁿ ní caⁿ'ā tá chii tá Pedro miiⁿ: Diī ntúūⁿ ni canee di ndúúcū Jesús yeⁿ'e yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Naati Pedro miiⁿ ní chééⁿdiītu sa nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a sa: Nguɛɛ deenú chí ngaⁿ'ā di. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ní taachí ndaā Pedro miiⁿ cheendi va'āī yeⁿ'e patio miiⁿ, táámá táⁿ'ā chi canéé caadi 'iiyu n'diichi ntuūⁿ tá saⁿ'ā miiⁿ ní caⁿ'a tá chii tá 'iiⁿ'yāⁿ chi snéé miiⁿ: 'Tiicá ntúūⁿ sáⁿ'a 'cūū ní canee sa ndúúcū Jesús yeⁿ'e yáāⁿ Nazaret. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro miiⁿ ní cheeⁿdiītu ntúūⁿ sa, ndíí túúnú 'caī sa, “por Ndyuūs”. Ní caⁿ'a sa: 'Úú ní nguɛ́ɛ́ in'diichí sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cuayiivi 'tɛɛ 'tɛ́ɛ́ ní 'iiⁿ'yāⁿ chi snée yā cuaaⁿ na niiⁿnuúⁿ miiⁿ ndaa yā nanááⁿ Pedro miiⁿ. Ní caⁿ'a yā chii yā Pedro: Cuaacu nííⁿnyúⁿ dii ntúūⁿ ní cachiica dí ndúúcū 'iiⁿ'yāⁿ s'eeⁿ ti tan'dúúcā chi ngaⁿ'a di ní n'giⁿ'i di yeⁿ'e di chi dii ní nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tuu'mi ní Pedro miiⁿ ní tucá'a sa caⁿ'a taaⁿ sa, ní 'caī sa, “por Ndyuūs”, ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ miiⁿ: Nguɛ́ɛ́ in'diichí sáⁿ'a 'cūū. Tuu'mí nūuⁿ 'caī tusáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tuu'mi nūuⁿ ní Pedro miiⁿ ní n'gaācū sa nduudu yeⁿ'é Jesús taachí caⁿ'a yā 'túúcā: Taachi 'āā cuɛ́ɛ́ 'cuaī tusáⁿ'ā, 'āā cheeⁿdiītū di 'iīnū cuuvi chi nguɛ́ɛ́ n'diichi di 'úú. Ní Pedro miiⁿ ní can'daa sa na lugar 'cūū ní chɛɛcu taaví sa ti ya'ai staava yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Taachí 'āā chīdɛɛvɛ, nducyáácá chiiduú n'gɛɛtɛ ndúúcū 'iiⁿ'yāⁿ ndiicúū chí ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū nduuvidaamá yā chí ndeé yā taācā diíⁿ yā ndúúcū Jesús miiⁿ ni nca'a yā 'iiⁿ'yāⁿ chi 'cuūvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ní n'dɛɛ́chiichí yā Jesús miiⁿ ní candɛ́ɛ yā ní nca'a yā Jesús miiⁿ Poncio Pilato, 'iiⁿ'yāⁿ gobernador. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tuu'mi ní Judas miiⁿ, saⁿ'a chí nca'a Jesús miiⁿ, taachí n'diīchī sa chí Jesús miiⁿ chií yā condenado chi 'cuuví yā, ndaacadaamí sá yeⁿ'e nuuⁿndi chí diīⁿ sa. Ní cheⁿ'e sa nanááⁿ chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū ní nca'a sa ndu'ū ndiicu ndííchí caadi 'diiⁿnguɛɛ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ s'eeⁿ: 'Úú ní diíⁿ 'áámá nuuⁿndi. Ncā'á 'áámá 'iiⁿ'yāⁿ chi nguɛ́ɛ́ nuuⁿndi yeⁿ'e yā. 'Iiⁿ'yāⁿ s'eeⁿ caⁿ'a yā: ¿Dɛ́'ɛ̄ ínneeⁿ nús'uū chiiⁿ? Chuū chí maaⁿ di can'díícu di. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tuu'mi ní Judas chingée sa tuūmī miiⁿ chɛɛti yaācū ní cunaⁿ'a sa. Ní dicuái yaacu sa maaⁿ sa. Ní Judas ní ch'iī sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chiiduú n'gɛɛtɛ́ n'guáaⁿ yā tuūmī ní caⁿ'a yā: Na ley miiⁿ ní ngaⁿ'ā chi nguɛ́ɛ́ 'cuiī yú túúmi 'cūū na caja yeⁿ'e ofrendas yeⁿ'e yaācū, ti túúmi 'cūū ní túumī yeⁿ'ē yuūúⁿ yeⁿ'e 'aama 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ch'iinu chuū ní nduuvidaama yā chi cái yā 'áámá tááⁿ yáⁿ'āa ndúúcū tuūmī chí cuuvi panteón cáávā 'iiⁿ'yāⁿ chi snúúⁿ yúúní. Miiⁿya yaⁿ'āa chi nguuvi Alfarero chi neⁿ'e caaⁿ'maⁿ yáⁿ'āa yeⁿ'e chi 'iiⁿ'yāⁿ din'dái 'cuūtīí cueēe. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Chííⁿ chí yáⁿ'āa chi panteón cánéé chí dúúchí ndíí mááⁿ, Yáⁿ'āa yeⁿ'e Yuūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Tíícā ní cuunúū ca'a chi profeta Jeremías caⁿ'a yā chuū ndii cuááⁿ vmnaaⁿ taachí dinguúⁿ yā na libro yeⁿ'é Ndyuūs 'tíícā: Ní sta'á yā ndu'ū ndiicu ndííchí caadi 'diiⁿnguɛɛ. Tuūmī miiⁿ ní saⁿ'ā s'eeⁿ canéé yiinu sa chi ca'a sa Judas cucáávā chi ch'iīⁿ'nūⁿ sa Cristo. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ní ca'a yā tuūmī miiⁿ yeⁿ'e yáⁿ'āa chí nguuvi Alfarero, tan'dúúcā Señor yeⁿ'e yú caⁿ'a yā chii yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús chééndii yā nanááⁿ gobernador Pilato ní gobernador íntíínguuneeⁿ yā 'iiⁿ'yāⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: ¿'Áá díí chí Rey yeⁿ'e 'iiⁿ'yāⁿ Israel chi judíos? Jesús caⁿ'a yā chii yā gobernador: N'diī ngaⁿ'a cuaacú nī ti 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū chí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū caⁿ'a yā chi vɛ́ɛ́ nuuⁿndi yeⁿ'e Jesús naati Jesús miiⁿ ní nguɛ́ɛ́ nan'guɛɛcútaⁿ'a yā mar 'áámá nduudu. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tuu'mi ní Pilato miiⁿ caⁿ'a yā chii yā Jesús: ¿'Áá nguɛ́ɛ́ n'giindiveeⁿ di tanducuéⁿ'e chí ngaⁿ'a yā yeⁿ'ē di? ");
INSERT INTO cuxNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Naati Jesús miiⁿ nguɛ́ɛ́ nan'guɛɛcútaⁿ'a yā mar 'áámá nduudu. Tuu'mi ní gobernador miiⁿ cheⁿ'e yiinu taavi yā yeⁿ'e Jesús ní nguɛ́ɛ́ déénu yā táácā nadacádíínuuⁿ yā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maaⁿ ní ngúúví 'viicu miiⁿ vɛ́ɛ́ 'áámá costumbre chi gobernador miiⁿ canéé chí ín'dɛ́ɛ́chí yā 'áámá saⁿ'ā chi canúuⁿ sa vácūū 'viicu yeⁿ'e pascua 'aama saⁿ'ā chi preso sa chi 'iiⁿ'yāⁿ Israel neⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ní canúuⁿ 'aama saⁿ'ā vácūū chi nguuvi Barrabás. Nducyáácá 'iiⁿ'yāⁿ ní déénu yā táácā idiiⁿ Barrabás miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ní taachi 'iiⁿ'yāⁿ yeⁿ'ē yáāⁿ Jerusalén miiⁿ nduuvidaamá yā, gobernador Pilato miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Du'ū neⁿ'e nī chi 'úú n'dɛɛchií? ¿'Áá neⁿ'e nī Barrabás o Jesús chi nguuvi Cristo chi 'úú caⁿ'á libre 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato miiⁿ ní deenu yā chi cáávā vaadī ngueee 'iiⁿ'yāⁿ s'eeⁿ nca'a yā Jesús chi preso yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Taachí Pilato miiⁿ ní vɛɛ yā na silla yeⁿ'e juez miiⁿ, n'daataá yeⁿ'e yā ní dichó'o tá 'áámá 'iiⁿ'yāⁿ chi caⁿ'a yā chii yā Pilato miiⁿ nduudú 'cūū: Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ diíⁿ nī ndúúcū saⁿ'ā n'dáí 'cūū ti taachí cyaadú nééné n'deēe ch'eenú chii taachí ch'iīnú cáávā sáⁿ'a 'tīī. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Naati chiiduú n'gɛɛtɛ ndúúcū 'iiⁿ'yāⁿ ndiicúū chí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū nééné n'deēe caⁿ'a yā chii yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ chi caaⁿ'maⁿ yā chi Pilato miiⁿ n'dɛ́ɛ́chii yā Barrabás miiⁿ ní 'cuūvī Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gobernador miiⁿ caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Naachí na 'uuvi yā ní chɛɛ́ yā chi neⁿ'e nī chi n'dɛɛ̄chií? 'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Barrabás. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ diíⁿ ndúúcū Jesús chi nguuvi yā Cristo? Nducyaaca yā nan'guɛɛcútaⁿ'a yā ní 'cai yā: Cu'nééⁿnga'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gobernador miiⁿ caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ nuuⁿndi yeⁿ'e yā vɛɛ? Naati 'iiⁿ'yāⁿ s'eeⁿ ní n'gáí yiicú yā ní caⁿ'a yā: Cu'nééⁿnga'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Taachi Pilato miiⁿ n'diichí yā chi nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi diíⁿ yā ndúúcū 'iiⁿ'yāⁿ ti yuudu n'dáí ca n'gai yā, tuu'mi ní sta'á yā nuūⁿnīⁿ ní naaⁿnu yā ta'a yā nanááⁿ nducyaaca 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ. Ní ngaⁿ'a yā: Limpia canéé 'úú yeⁿ'ē asunto 'cūū. 'Úú ní nguɛ́ɛ́ nuuⁿndi yeⁿ'é chi 'cuūvī sáⁿ'a 'cūū ti n'dai sa. Ndís'tiī deenu nī táácā diiⁿ nī ndúúcu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nducyaaca 'iiⁿ'yāⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: Yuuúⁿ yeⁿ'ē sáⁿ'a 'cūū 'āā cūnee dáámí rá 'nū ndúúcū daiya 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tuu'mi ní Pilato miiⁿ ní n'dɛɛ̄chii yā Barrabás miiⁿ ní caⁿ'a ntiiⁿnyuⁿ yā chi soldados ch'eⁿ'é yā Jesús. Ch'íínú ch'eⁿ'e yā ní nca'a Pilato miiⁿ Jesús miiⁿ 'iiⁿ'yāⁿ chi cu'neeⁿnga'á yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tuu'mi ní soldados romanos yeⁿ'e gobernador can'dɛ́ɛ sa Jesús na vaacuyáāⁿ yeⁿ'e gobernador ní nducyáácá soldados nduuvidaama sa nanááⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ní divíi sa catecaī vmnaaⁿ Jesús ní s'nuuⁿ sa tíínūuⁿ morado cuá'āa Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ní s'nuuⁿ sa tiiⁿ Jesús 'áámá corona chi ndeenyú ndúúcū yaaⁿ. Ní sn'duuⁿ sa 'áámá taaⁿ ndúú ná ta'ā cuaacú Jesús. Tuu'mi ní chiīntii'ya sa nanááⁿ Jesús miiⁿ ní ch'ííⁿnyuⁿneeⁿ sa 'iiⁿ'yāⁿ. Ní caⁿ'a sa: Cūnduuchí nī n'diī Rey yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ní ca'a nee daiⁿ sa cuerpo yeⁿ'ē Jesús ní sta'a sa 'áámá tááⁿ ndúú chí ndɛɛ sa ní ch'eⁿ'e sa tiiⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ch'íínú ch'iīⁿnyuⁿneeⁿ sa Jesús miiⁿ ní ndivíi sa tíínūuⁿ yā chi morado cuá'āa ní chi'nuuⁿ sa catecai yā. Ní candɛɛ sa Jesús chi cu'nééⁿnga'a sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Taachí can'daa yā ní cueⁿ'e yā na yúúní naachi cu'nééⁿnga'á yā ndaaca yā 'áámá saⁿ'ā yeⁿ'e yáāⁿ Cirene chí nguuvi sa Simón. Ní a fuerza soldados di'cuiītu sa Simón 'cūū chí candɛ́ɛ sa cruz yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ní taachi ndaá yā na táámá lado yeⁿ'e yáāⁿ Jerusalén lugar chi nguuvi Gólgota chí neⁿ'e caaⁿ'maⁿ, Lugar yeⁿ'ē 'Iini Nga'ai Tiīiⁿ, ");
INSERT INTO cuxNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","saⁿ'ā ca'a sa Jesús vinagre ndístaⁿ'a ndúúcū nuuⁿníⁿ yeⁿ'ē yáatā yaāa cáávā chi nguɛɛ cueenu cá cuuvi Jesús chí chi'i Jesús miiⁿ. Taachí Jesús n'diichineeⁿ yā, nguɛ́ɛ́ 'cuuⁿ yā chi'i yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Taachí 'āā s'neeⁿnga'a sa Jesús, soldados ní tun'dáa sa suertes na catecai Jesús miiⁿ chi ca'a sa 'áámá sa nduūcū taama sa. Ní 'iicu cúúnúú ca'a tan'dúúcā chí caⁿ'a profeta ndii cuááⁿ vmnaaⁿ ní canéé nguúⁿ na libro yeⁿ'é Ndyuūs 'túúcā: Tun'daá yā suerte na catecai Jesús miiⁿ ní nca'á yā nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Miiⁿ ch'ɛɛ̄tɛ̄ɛ soldados ní diiⁿ sa cuidado 'iiⁿ'yāⁿ chi s'nééⁿnga'a. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ni 'áámá nduudu naaⁿ tíīⁿ cruz miiⁿ chi canéé nguūⁿ 'túúcā: Jesús miiⁿ chi Rey yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel. Ní nduudu miiⁿ ngaⁿ'ā dɛ'ɛ cáávā chi ch'iī Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tuu'mi ní miiⁿ ntúūⁿ s'neeⁿnga'á yā ndúúcū Jesús miiⁿ 'uūvī chi duucu, 'áámá ní lado ta cuaacú yā, taama ní lado tá 'cuee yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","'Iiⁿ'yāⁿ chí cho'ó yā naachi canee cruz miiⁿ ch'iiⁿnyuⁿneeⁿ yā Jesús miiⁿ. Ní idiⁿ'núⁿ'u yā tiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ní caⁿ'a yā: N'diī chi ngaⁿ'á nī chi maáⁿ nī cuuvi nada'tuūví nī yaācū templo ní chɛɛ̄tī 'iīnū nguuvi nadan'dái nī, nadinguáⁿ'āī maáⁿ nī maaⁿ. Ndúúti chi Daiya Dendyuūs n'diī, nch'éeⁿ nī yeⁿ'ē na cruz. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Tiicá ntúūⁿ chiiduú n'gɛɛtɛ ndúúcū 'iiⁿ'yāⁿ fariseos chí dingúuⁿ yā ní ngi'cueeⁿ ley, ndúúcū 'iiⁿ'yāⁿ ndiicúū chí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū templo ch'ííⁿnyuⁿneeⁿ yā Jesús miiⁿ ní ngaⁿ'a yā yeⁿ'e yā: ");
INSERT INTO cuxNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tanáⁿ'ā 'iiⁿ'yāⁿ ní nadinguáⁿ'ai yā naati nguɛ́ɛ́ cuuvi maaⁿ yā nguáⁿ'ai yā. Ndúúti chi 'iiⁿ'yāⁿ miiⁿ ní Rey yeⁿ'e 'iiⁿ'yāⁿ Israel maaⁿ ní nch'éeⁿ yā yeⁿ'e na cruz ní cu'téénu 'nū 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jesús miiⁿ ní i'téénu yā Ndyuūs. Maaⁿ ní Ndyuūs nadinguáⁿ'ai yā 'iiⁿ'yāⁿ nduuti chí cuaacu chí 'cuaáⁿ yā 'iiⁿ'yāⁿ. 'Iiⁿ'yāⁿ ngaⁿ'á yā 'tíícā ti Jesús ngaⁿ'a yā: 'Úú ní daiya Dendyuūs 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","'Tiicá ntúūⁿ ch'iīⁿnyuⁿneeⁿ chí duucu s'eeⁿ chi s'nééⁿnga'a sa dáámá ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ndíí maⁿ'a nguuvi miiⁿ ndíí taanduū n'gɛɛcu 'iinu chiīnū chíí maāiⁿ núúⁿmáⁿ iⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","'Āā táánduū n'gɛɛcu 'iinu, Jesús 'caī yiicú yā: Elí, Elí, ¿lama sabactani? Nduudu hebreo 'cūū ní neⁿ'ē caaⁿ'maⁿ Ndyuūs yeⁿ'é, Ndyuūs yeⁿ'é, ¿dɛ'ɛ̄ cuuvi chi s'neéⁿ nī 'úú damaáⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","N'duuvi 'iiⁿ'yāⁿ chi snée yā 'miiⁿ taachí ch'iindiveéⁿ yā chí caⁿ'a Jesús miiⁿ ní caⁿ'a yā: Sáⁿ'a 'cūū n'gaī sa profeta Elías. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hora mííⁿ nūuⁿ 'áámá chɛ́ɛ́ 'iiⁿ'yāⁿ s'eeⁿ chéⁿ'e yā ngeenu yā sta'a yā 'áámá esponja ní di'caāndá yā ndúúcū vinagre ní s'neeⁿ yā esponja miiⁿ na 'áámá tááⁿ ndúú ní ca'a yā chí chi'i Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tanáⁿ'a yā ní ngaⁿ'a yā: 'Āā canee ra yā. N'diichi yú ¿'áá chiī Elías miiⁿ nadinguáⁿ'ai yā 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Naati Jesús miiⁿ 'caī ntúuⁿ yā taama vmnéⁿ'ēe ní maaⁿ yā nca'a yā espíritu yeⁿ'e yā na ta'a Ndyuūs ní ch'īi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hora mííⁿ nūuⁿ chi ch'iī Jesús, cortina yeⁿ'e yaācū templo s'teeⁿ naavtáⁿ'ā ndii cuaaⁿ 'niiⁿnuúⁿ ndíí cuááⁿ ndiiyā. Ní n'nuⁿ'u yáⁿ'āa ní tuūu ní índee. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tuu'mi ní yáinyāⁿ s'eeⁿ ní nguaaⁿ ní nééné 'yaaⁿ cuerpos yeⁿ'e 'iiⁿ'yāⁿ chi n'díí chi i'téénu yā Ndyuūs ndii cuááⁿ vmnaaⁿ nan'dáa yā chɛɛti yaīnyāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ní 'iiⁿ'yāⁿ s'uuⁿ chi 'āā n'dii miiⁿ taachi 'āā nduuchi Jesús miiⁿ yeⁿ'ē nguaaⁿ tináⁿ'ā 'iiⁿ'yāⁿ s'uuⁿ ní nan'daa yā chɛɛti yaīnyāⁿ s'eeⁿ ní cueⁿ'e yā cachiica yā na yáāⁿ Jerusalén chi Ndyuūs dɛɛvɛ yā. Ní 'yaaⁿ n'dáí 'iiⁿ'yāⁿ chinaáⁿ yā 'iiⁿ'yāⁿ chi 'āā n'dii. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Saⁿ'a capitán ndúúcū soldados chi snée yā ndúúcu yā ní diíⁿ yā cuidado yeⁿ'e cuerpo yeⁿ'e Jesús taachi s'neeⁿ yā na cruz. Soldados miiⁿ, taachi n'diichí yā chi n'nuⁿ'u yáⁿ'āa ndúúcū dendu'ū chí chiī, neené di'va'á yā ní caⁿ'a yā: Cuaacu nííⁿnyúⁿ, sáⁿ'a 'cūū ní Daiya Dendyuūs saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","'Yaaⁿ n'dáí n'daataá snéé yaⁿ'ai yā ní n'gíínu yā tanducuéⁿ'ē chi chó'ōo yeⁿ'e Jesús. N'daataá s'eeⁿ cachiica yā ndúúcū Jesús ndii na yáⁿ'āa yeⁿ'e Galilea ní dichíí'vɛ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ní nguaaⁿ n'daataá s'eeⁿ, miiⁿ canéé ta María Magdalena ndúúcū María chi chɛɛcu Jacobo ndúúcū José. Ní canéé ntúuⁿ tá chɛɛcuú da'cáíyā yeⁿ'e sáⁿ'ā Zebedeo. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Taachí chiīnu nguuvi miiⁿ ndaā 'áámá saⁿ'ā chi nguuvi José chi yeⁿ'ē yáāⁿ Arimatea. Saⁿ'ā miiⁿ ní 'cuiica sa ní discípulo yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sáⁿ'a 'cūū ní cheⁿ'e sa nanááⁿ Pilato miiⁿ ní chiica sa cuerpo yeⁿ'e Jesús miiⁿ. Tuu'mi ní Pilato caⁿ'a ntiiⁿnyúⁿ yā chí caⁿ'a capitán yeⁿ'e soldados chi ca'á yā cuerpo yeⁿ'e Jesús miiⁿ José miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tuu'mi ní José sta'ā sa cuerpo yeⁿ'e Jesús ní ch'ɛɛ̄cū sa 'áámá sábana dɛɛvɛ tan'dúúcā chi costumbre yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ní s'nuūⁿ sa cuerpo yeⁿ'e Jesús na 'áámá yáinyāⁿ yeⁿ'e maaⁿ sa chí ngai chi maaⁿ sa nííⁿnuⁿ sa na 'aama yaava. Ch'íínú ch'iīchi sa cuerpo yeⁿ'e Jesús, s'neeⁿ sa 'áámá tuūu chi nééné ch'ɛɛtɛ naachí níndaa yā yeⁿ'e cheendi yaīnyāⁿ miiⁿ. Ní cunáⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mííⁿ vɛ́ɛ́ María Magdalena ndúúcū táámá María niiⁿnuúⁿ ná yainyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chó'ōo nguuvi chi in'nuúⁿ yā yeⁿ'e 'viicu yeⁿ'e pascua ní chidɛɛvɛ táámá nguuvi chi sábado ní chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ fariseos ní nduuvidaamá yā ní cheⁿ'e yā nanááⁿ Pilato miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ní caⁿ'a yā chii yā Pilato: N'diī Pilato, n'gaacú 'nū chí saⁿ'ā chi n'diī chí chinnche'ei sa taachí canee sa iⁿ'yeeⁿdí 'cūū ní caⁿ'a sa 'túúcā: 'Cuíinū 'iinu nguuvi ní nduūchí nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Maaⁿ ní dichó'o nī soldados chí diiⁿ yā cuidado yáinyāⁿ miiⁿ ndíí 'cuiinu 'iīnū nguuvi. ¿'Áátīī ndaá discípulos yeⁿ'e yā n'gaaⁿ ní diīⁿ iduucú yā cuerpo yeⁿ'e Jesús? Ní caaⁿ'maⁿ yā cuuvi yā 'iiⁿ'yāⁿ chi sáⁿ'ā miiⁿ ní nanduuchi sá yeⁿ'e nguaaⁿ tináⁿ'ā. Ní cunncáā ca nduudu yaadi miiⁿ nguɛ́ɛ́ ti chi 'āā chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Ingaā 'áámá taaⁿ soldados. Cueⁿ'e nī ní diiⁿ nī cuidado yáinyāⁿ miiⁿ tan'dúúcā chi déénu nī chi n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ní cheⁿ'e yā yáinyāⁿ miiⁿ ní diíⁿ yā cuidado yáinyāⁿ miiⁿ. S'neeⁿ yā 'áámá sello na tuūu ch'ɛɛtɛ́ ní s'neeⁿ yā soldados chí diiⁿ sa cuidado yáinyāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Chó'ōo nguuvi sábado chi ntaavi'tuunúúⁿ yā ní chidɛɛvɛ táámá nguuvi chi domingo, nguuvi chi ngaⁿ'a yú chi nguuvi vmnááⁿ vmnaaⁿ yeⁿ'e ndɛɛtɛ̄, ní tá María Magdalena ndúúcū taama tá María cheⁿ'e ta n'diīchī tá na yaīnyāⁿ yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ní nééné díítūu nuⁿ'u yáⁿ'āa ti 'aama ángel yeⁿ'e Señor Ndyuūs chiiya yā yeⁿ'ē va'ai chɛɛti nguuvi. Ní taachi ndaa yā, divíi yā tuūu ch'ɛɛtɛ miiⁿ yeⁿ'e cheendi yaīnyāⁿ ní ch'iindi yā vmnaaⁿ yeⁿ'e tuūú miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angel miiⁿ tan'dúúcā chi inááⁿ 'cuai 'tíícā máaⁿ yā chi dɛɛvɛ yā. Ní catecai yā ní cuɛ́ɛ̄ tan'duucā yaāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldados chí idiiⁿ yā cuidado yáinyāⁿ miiⁿ in'dúúví yā chi 'va'a yā. Ní nduuví yā tan'dúúcā chí ch'īi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naati ángel miiⁿ caⁿ'a yā chii yā n'daataá s'eeⁿ: Nguɛ́ɛ́ 'va'a ndís'tiī; ti 'úú ní deenú ti in'nuúⁿ nī Jesús chí cā'neeⁿnga'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Āā ntɛ́ɛ́ 'iiⁿ'yāⁿ miiⁿ ti nduuchi yā yeⁿ'ē nguaaⁿ tináⁿ'ā tan'dúúcā chi caⁿ'a yā. Cuchíi nī ní n'diichí nī naachí cānuuⁿ cuerpo yeⁿ'e Señor miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cuayiivi ní ngaⁿ'a ángel chii yā n'daataá s'eeⁿ: Cuinaⁿ'a núuⁿ nī maāⁿnchɛɛ̄tɛ́ ní caaⁿ'máⁿ nī cuuvi nī discípulos yeⁿ'e yā chí nduuchi Jesús miiⁿ yeⁿ'e nguaaⁿ tináⁿ'ā. Cuin'diichí nī. Jesús miiⁿ caⁿ'a yā vmnááⁿ ndís'tiī na yáⁿ'āa Galilea. Mííⁿ snaaⁿ nī 'iiⁿ'yāⁿ. Chúū chí ngaⁿ'á ngií ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tuu'mi ní n'daata s'ééⁿ nan'dáa yā chɛɛti yáinyāⁿ miiⁿ ní dii'yá yā chiī ní duuvi yeenú yā. N'daata s'ééⁿ ní cueⁿ'e yā ngéenū yā ní caⁿ'a yā chii yā discípulos yeⁿ'e Jesús tan'dúúcā chí n'diichí yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tuu'mi ní taachi cueⁿ'é yā chi yaa'ví yā discípulos cuin'diichí nī, Jesús miiⁿ ndaá yā chí nndaacá yā n'daata s'eeⁿ ní caⁿ'a yā: Tavacho'onoó nī ndís'tiī n'daata s'eeⁿ. Ní n'daata s'eeⁿ ní ndáá niiⁿnúⁿ yā Jesús miiⁿ ní túmaⁿ'a yā ca'a Jesús miiⁿ ní s'téénu yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tuu'mi ní Jesús caⁿ'a yā chii yā n'daataá s'ééⁿ: Nguɛ́ɛ́ 'va'a nī. Cuéⁿ'e nī cuuví nī hermanos yeⁿ'é chi n'diichí nī 'úú. Ní hermanos caⁿ'a yā na yáⁿ'āa Galilea ní miiⁿ snaáⁿ yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nchó'ōo n'daata s'uuⁿ cunaⁿ'á yā ní n'duuvi soldados chi diíⁿ yā cuidado yeⁿ'e yáinyāⁿ cheⁿ'é yā na yáāⁿ Jerusalén ní caⁿ'a yā chii yā chiiduú n'gɛɛtɛ yeⁿ'é tánducueⁿ'ē chí chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chiiduú n'gɛɛtɛ nadidaamá yā ndúúcū 'iiⁿ'yāⁿ ndíícuū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū. Ní nduuvidaamá yā ní nééné n'deēe túumī ca'a yā soldados. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ní caⁿ'a yā chii yā soldados: Ndís'tiī ní 'túúcā caaⁿ'maⁿ nī: Taachi yaaⁿ stiyaadú 'nū discípulos yeⁿ'e Jesús ndaá yā ní diduucú yā cuerpo yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ní nduuti chi gobernador 'caandíveéⁿ yā chííⁿ chí ndís'tiī caaⁿ'maⁿ nī, nús'uu yaa'vi neeⁿ 'nū 'iiⁿ'yāⁿ ní nguaⁿ'āī ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Soldados ní sta'á yā tuūmī miiⁿ ní diíⁿ yā tan'dúúcā chi chiiduú n'gɛɛtɛ caⁿ'á yā chii yā soldados. Chííⁿ chí ndii maaⁿ ní 'iiⁿ'yāⁿ yeⁿ'e ndaataá Israel ngaⁿ'á yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ndu'ū ndiicháámá discípulos cueⁿ'é yā na yáⁿ'āa Galilea ní ndaá yā ná yiīcū naachí Jesús miiⁿ dichó'o yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Taachí discípulos n'diichí yā Jesús miiⁿ, s'téénu yā 'iiⁿ'yāⁿ 'áárá chí náⁿ'a yā ní 'uūvī vaanicádiinūuⁿ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ní ndaa niiⁿnúⁿ yā ní yaa'vi yā discípulos ní caⁿ'a yā: Chiidá ní tee yā 'úú nducuéⁿ'e poder chí caaⁿ'maⁿ ntiiⁿnyúⁿ na va'āī chɛɛti nguuvi ndúúcū na iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Maaⁿ ní cueⁿ'e nī ni ca'cueéⁿ nī nuuⁿmaⁿ naciones, ní cuuvi nī discípulos yeⁿ'é. 'Iiⁿ'yāⁿ chi i'téénú yā nduudu cuaacu yeⁿ'é, ndís'tiī cuɛɛdínuūⁿniⁿ nī 'iiⁿ'yāⁿ miiⁿ ndúúcū chi duuchi Ndyuūs Chiida yú, ndúúcū Daiya yā, ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cá'cueeⁿ nī 'iiⁿ'yāⁿ s'eeⁿ chí diíⁿ yā tanducuéⁿ'ē dendu'ū chi 'úú ngaⁿ'á ngií ndís'tiī. Ní cadíínuuⁿ nī chi 'úú ní caneé ndúúcū ndís'tiī nducuéⁿ'ē tiempo ndíí ntuuví iⁿ'yeēⁿdī. 'Tíícā cuuvi.");
INSERT INTO cuxNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","'Túúcā chí ngaⁿ'a nduudu ngai yeⁿ'e Jesucristo chí Daiya Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","'Iiⁿ'yāⁿ profeta Isaías miiⁿ chí ngaⁿ'a nduudu yeⁿ'é Ndyuūs ndíí cuááⁿ vmnaaⁿ dinguúⁿ yā tan'dúúcā chí caⁿ'a Ndyuūs, 'tíícā: 'Úú dicho'ó 'aama 'iiⁿ'yāⁿ chi caaⁿ'máⁿ yā nduudu yeⁿ'é nanááⁿ ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","'Iiⁿ'yāⁿ miiⁿ ní caⁿ'a yā ndúúdú ngai na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. Ní caⁿ'a yā: Cuundiyaáⁿ nī yúúní yeⁿ'e Señor Ndyuūs caati cuchii yā. Nan'guáaⁿ nī yúúní cuaacu caavá yā Didɛɛvɛ́ nī staava yeⁿ'é nī ní cuuvi 'cuaáⁿ nī 'iiⁿ'yāⁿ miiⁿ taachi ndaa yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Tíícā Juan miiⁿ ní chɛɛdínuūⁿnīⁿ sa 'iiⁿ'yāⁿ s'eeⁿ na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. Ní caⁿ'a cuáácú sá chi 'iiⁿ'yāⁿ ndaacadáámí yā yeⁿ'ē nuuⁿndi yeⁿ'é yā ní cuɛɛdínúuⁿnīⁿ sa 'iiⁿ'yāⁿ chi n'giindiveéⁿ yā nduudu yeⁿ'e sa, naati Ndyuūs nadich'ɛɛcú yā nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ní n'deee 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Judea ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén can'dáa yā chí 'caandiveéⁿ yā chí ngaⁿ'a Juan miiⁿ. Ní taachi 'iiⁿ'yāⁿ s'eeⁿ caⁿ'a yā nuuⁿndi yeⁿ'é yā nanááⁿ Ndyuūs níícú Juan miiⁿ ní chɛɛdínuūⁿnīⁿ sa 'iiⁿ'yāⁿ miiⁿ na yíícú Jordán. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Catecai Juan miiⁿ ní nín'dai ndúúcū yuūdū yeⁿ'e 'iiti camello. Ní cinturón yeⁿ'ē sa ní dííⁿmáⁿ 'iiti. Ní chí che'ē sa ní 'iiti langostas ndúúcū n̄'di'i yeⁿ'ē 'iití 'yáaiⁿ chi vɛ́ɛ́ cuɛɛti. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan miiⁿ ngaⁿ'a sa nduudu cuaacu yeⁿ'é Ndyuūs. Ní caⁿ'a sa: Cuayiivi yeⁿ'e 'úú cuchii 'áámá 'iiⁿ'yāⁿ chí ch'ɛɛtɛ taavi cá poder yeⁿ'é yā nguɛ́ɛ́ ti 'úú. 'Úú ní nguɛ́ɛ́ neené n'dai 'úú chí cuuví diíⁿ n'daatií yííⁿmáⁿ yeⁿ'ē ndaacuú yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Úú ní ngɛɛ̄dínuūⁿníⁿ ndís'tiī ndúúcū nuūⁿnīⁿ naati 'iiⁿ'yāⁿ miiⁿ ní cuɛɛ̄dinuūⁿniⁿ yā ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nguuvī s'eeⁿ Jesús miiⁿ chiicá yā yeⁿ'e yáāⁿ Nazaret yeⁿ'e yáⁿ'āa Galilea ní ndaá yā na yíícú Jordán. Ní Juan miiⁿ ní chɛɛdínuūⁿnīⁿ sa Jesús miiⁿ na yíícú Jordán. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Taachi Jesús can'daa yā na nuūⁿnīⁿ miiⁿ, cuin'diichí nī. N'diichí yā chí nanguaāⁿ nanguuvi ní Espíritu N'dai yeⁿ'é Ndyuūs ní cuch'ééⁿ vmnaaⁿ yeⁿ'é yā tan'dúúcā 'áámá paloma 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ch'iindiveéⁿ Jesús 'áámá nduudu chi chiīcā yeⁿ'ē nánguuvi chi caⁿ'a: Díí Daiyá chi neⁿ'e taaví ní yeenú taavi cáávā dii. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Cuayiivi miiⁿ ní Espíritu N'dai yeⁿ'é Ndyuūs candɛ́ɛ̄ Jesús na 'áámá yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesús miiⁿ ní canée yā miiⁿ 'uuvi ngɛɛcu nguuvi naachi vɛ́ɛ́ 'iiti chi taaⁿ. Ní yááⁿn'guiinūuⁿ miiⁿ ní n'diichineeⁿ sa Jesús chi diíⁿ yā nuuⁿndi naati nguɛ́ɛ́ dinuuⁿndí yā. Níícú ángeles ndaá yā ní diíⁿ yā cuidado Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cuayiivi taachi s'nuúⁿ yā Juan chi chɛɛdinuūⁿnīⁿ 'iiⁿ'yāⁿ vácūū, Jesús miiⁿ ndāa yā na yáⁿ'āa Galilea, ní caⁿ'a yā nduudu cuaacu chí ngai yeⁿ'e naachi Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús miiⁿ ní caⁿ'a yā: 'Āā snuū ca'a tiempo naachí ngaⁿ'a ntiiⁿnyuⁿ Ndyuūs ní 'āā ndaā niiⁿnuúⁿ. Nandaacadaamí nī yeⁿ'ē nuuⁿndi yeⁿ'é nī ní cu'teenú nī nduudu cuaacu chi ngai chi yeⁿ'e Cristo. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús miiⁿ ní cachiicá yā cuaaⁿ 'diituú nuūⁿnīⁿ'yáⁿ'ā chi nguuvi Galilea, taachí n'diichí yā Simón ndúúcū 'díínū sa Andrés. Sáⁿ'ā s'eeⁿ ní saⁿ'ā chi itungaáⁿ 'yaācā, ní ngīī sa yaānā yeⁿ'ē sa chɛɛti nuūⁿnīⁿ'yáⁿ'ā ti saⁿ'ā s'eeⁿ itungáaⁿ sa 'yaācā na nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ní Jesús ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: Cuchíi nī, caⁿ'á nī nduūcú ní 'úú ní diíⁿ chi in'nuúⁿ nī 'iiⁿ'yāⁿ chi cuuvi caⁿ'á yā nduucú. Ní tan'dúúcā chi ndís'tiī tungaáⁿ nī 'yaācā yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā 'tíícā ngaⁿ'a nī ndúúcū 'iiⁿ'yāⁿ chi caⁿ'á yā nduūcú. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hora mííⁿ nūuⁿ saⁿ'a s'uuⁿ s'neeⁿ sa yaānā yeⁿ'ē sa ni cueⁿ'e sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tuu'mi Jesús miiⁿ ní cueⁿ'é yā 'tɛɛ 'tɛ́ɛ́ ní ndaacá yā saⁿ'a chi nguuvi Jacobo ndúúcū Juan chi 'diinū sa. Saⁿ'ā s'eeⁿ ní daiya Zebedeo ní snee sa na 'aama barco ní n'diyaata sá yaānā yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús 'caí yā saⁿ'ā s'eeⁿ. Saⁿ'ā s'eeⁿ ní nan'dáa sa na barco naachi snée sa ndúúcū chiida sa n'diyaata sá yaānā yeⁿ'ē sa. Ní s'neeⁿ sa chiida sa Zebedeo ndúúcū mozos yeⁿ'e yā ní cueⁿ'e sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús miiⁿ ní ndaá yā na yáāⁿ Capernaum ndúúcū saⁿ'ā s'eeⁿ. Ní ca'áámá ca'áámá sábado, nguuvi chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ s'eeⁿ, Jesús cueⁿ'é yā na yaacū sinagoga ní chi'cueeⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","'Iiⁿ'yāⁿ s'eeⁿ ngeⁿ'e yiinu yā yeⁿ'e chí Jesús ngaⁿ'a yā; tí ngí'cueeⁿ yā tan'dúúcā 'iiⁿ'yāⁿ chi ngaⁿ'ā ntiiⁿnyúⁿ yā, nguɛ́ɛ́ tan'dúúcā 'áámá maestro yeⁿ'ē ley. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ní chɛɛti yaacū sinagoga mííⁿ canéé 'áámá saⁿ'ā chi vɛ́ɛ́ espíritu yeⁿ'e yááⁿn'guiinūuⁿ ndúúcu sa. Ní espíritu miiⁿ n'gai yeⁿ'ē sā: ");
INSERT INTO cuxNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","N'diī Jesús yeⁿ'e yáāⁿ Nazaret, cu'néeⁿ nī nús'uu. ¿Dɛ́'ɛ̄ canéé yeⁿ'é 'nū nduucú nī? ¿'Áá ndaá nī chi di'cuiīnú nī nús'uu? 'Úú ní n'diichí du'ú n'diī. N'diī ní 'iiⁿ'yāⁿ chí n'dai chi daiya Dendyuūs n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús miiⁿ ní yaa'vi néeⁿ yā espíritu yeⁿ'e yááⁿn'guiinūuⁿ, ní caⁿ'a yā: Dii espíritu n'gáádí dí cheendi di, níícú nan'dáa di yeⁿ'e saⁿ'á tīī. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuu'mi ní espíritu yeⁿ'e yááⁿn'guiinūuⁿ diīíⁿ chí chitá'āa 'áámá ataque sáⁿ'a 'cūū. Ní 'cai yiicú espíritu miiⁿ, ní nan'daā espíritu miiⁿ ná cuerpo yeⁿ'e sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ní nducyáácá 'iiⁿ'yāⁿ cheⁿ'e yiinu yā yeⁿ'e chuū ní tiingūūneeⁿ yā nguaaⁿ maaⁿ yā ndúúcū vi'ī: ¿Dɛ́'ɛ̄ chuū? ¿Dɛ́'ɛ̄ chí ngai chí ngi'cueeⁿ 'ííⁿ'yaⁿ 'cúū? 'Ííⁿ'yaⁿ 'cúū ní vɛ́ɛ́ poder ca yeⁿ'é yā ní ngíí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē espíritus yeⁿ'e yááⁿn'guiinūuⁿ ní n'giindivééⁿ espíritus yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Maāⁿnch'ɛɛtɛ́ nuūuⁿ nducyaaca 'iiⁿ'yāⁿ n'giindiveéⁿ yā yeⁿ'e chi diiⁿ Jesús miiⁿ, 'iiⁿ'yāⁿ yeⁿ'e núúⁿmáⁿ ná yáⁿ'āa yeⁿ'e yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Taachí n'daā Jesús na yaacū sinagoga Jesús miiⁿ ní cueⁿ'e yā ndúúcū Jacobo, ndúúcū Juan ná vaacu Simón ndúúcū Andrés. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","N'daataá chí indáⁿ'ā Simón miiⁿ ní ngííta yā. Ndɛ́ɛ̄ 'ííⁿ'nūuⁿ 'iiⁿ'yāⁿ miiⁿ ní candiití yā. Ní 'iiⁿ'yāⁿ na vaacu yā caⁿ'a yā chii yā Jesús miiⁿ chí n'daataá miiⁿ ní ngííta yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tuu'mi ní Jesús miiⁿ ní ndaa yā nanááⁿ n'daataá mííⁿ ní sta'á yā ta'ā tá ní nadicuéeⁿ yā táⁿ'ā. Níícú chiviī 'iiⁿ'nūuⁿ miiⁿ hora miiⁿ taachi nadicuéeⁿ yā n'daataa miiⁿ, ní tucá'a tá diíⁿ tá mandados yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cuayiivi taachí 'āā chiiya 'yáⁿ'ā ní 'āā 'da'a miiⁿ, 'iiⁿ'yāⁿ s'eeⁿ ní ndaa yā nanááⁿ Jesús miiⁿ ndúúcū nducyaaca 'iiⁿ'yāⁿ chí ngííta yā ndúúcū 'iiⁿ'yāⁿ chi vɛ́ɛ́ espíritus yeⁿ'e yááⁿn'guiinūuⁿ ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ní nducyáácá 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ ní ndaá yā na cheendi va'āī naachi canéé Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ní Jesús miiⁿ ní diíⁿ yā chi nanduuva yeⁿ'e 'yaaⁿ n'dáí 'iiⁿ'yāⁿ chi vɛ́ɛ́ n'deee nááⁿ n'dai ca'ai yeⁿ'é yā. Ní divíi yā n'deee n'dáí espíritus yeⁿ'e yááⁿn'guiinuuⁿ yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ. Nguɛ́ɛ́ 'cuúⁿ yā chi espíritus s'uuⁿ caāⁿ'maⁿ, caati espíritus s'uuⁿ ní deenu du'ū chí Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Táámá nguɛɛtiyaaⁿ 'da'ā ca, Jesús miiⁿ ní ncuéeⁿ yā ní can'dáa yā na yáāⁿ Jerusalén miiⁿ ní cueⁿ'e yā 'áámá lado yeⁿ'e yáāⁿ miiⁿ naachi nguɛ́ɛ́ 'iiⁿ'yāⁿ ní miiⁿ caaⁿ'maⁿngua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón miiⁿ ndúúcū tanáⁿ'ā compañeros yeⁿ'ē sa cheⁿ'e yā n'nuúⁿ yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Taachí ndaaca yā Jesús miiⁿ, tuu'mi ní caⁿ'a yā chii yā Jesús: N'diī Jesús, nducyáácá 'iiⁿ'yāⁿ in'nuúⁿ yā n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Caⁿ'ā yú tanáⁿ'ā yáāⁿ chi snéé na niiⁿnuúⁿ, ní 'tiicá ntúūⁿ caaⁿ'maⁿ yú nduudu cuaacu yeⁿ'é Ndyuūs miiⁿ ti cáávā chuu chi cuchií. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesús miiⁿ ní cachiicá yā núúⁿmáⁿ yáāⁿ cuaaⁿ na yáⁿ'āa Galilea. Ní ngaⁿ'a yā nduudu cuaacú yeⁿ'é Ndyuūs miiⁿ na yáacū sinagogas yeⁿ'e yáāⁿ s'eeⁿ. Ní divíi yā espíritus yeⁿ'e yaaⁿn'giinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Áámá saⁿ'ā chi canéé ca'ai chí ín'duuti yuutɛ̄ yeⁿ'ē sa ndaa sa nanááⁿ Jesús, ti neⁿ'e sa caaca sa 'áámá favor yeⁿ'é yā. Ní chíintii'ya sa ní caⁿ'a sa: N'diī Jesús, ndúútī chi n'diī neⁿ'e nī, diíⁿ nī chí nduūvā yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ní nduuvi ya'āī 'íínu yā saⁿ'ā miiⁿ, ní tuu'ví yā saⁿ'ā ndúúcū ta'a yā ní caⁿ'a yā: Táácā nguɛ́ɛ̄. 'Úú neⁿ'é. Dii saⁿ'ā, 'āā nduuvá yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Taachí caⁿ'a Jesús 'tuucā, chivii ca'ai chi in'duuti yuutɛ yeⁿ'ē sa ní nduūvā yeⁿ'ē sa, ní dɛɛvɛ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tuu'mi ní Jesús miiⁿ ní yaa'vi yā saⁿ'ā miiⁿ chí cunaⁿ'a sa na vaacu sa, naatí néé ca'á yā cuidado saⁿ'a miiⁿ ní yaa'ví yā saⁿ'a miiⁿ: ");
INSERT INTO cuxNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Díí, cun'dííchí dí, nguɛ́ɛ́ cuuvi di mar 'áámá 'iiⁿ'yāⁿ chi nanduūvā yeⁿ'e di. Cueⁿ'e di ní 'cuuⁿ'miⁿ di maaⁿ cuerpo yeⁿ'e di nanááⁿ chiiduú chi nduūvā yeⁿ'ē di. Ní ca'a di ofrenda tan'dúúcā chi ngaⁿ'a ley yeⁿ'e Moisés miiⁿ cáávā chi nduūvā yeⁿ'ē di ní cáávā chi dɛɛvɛ cuerpo yeⁿ'ē di. 'Tíícā nducyáácá 'iiⁿ'yāⁿ snaaⁿ yā chí 'āā nduuvá yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tuu'mi ní saⁿ'ā miiⁿ ní cunaⁿ'a sa ní caⁿ'a sa chii sa n'deee n'dáí 'iiⁿ'yāⁿ tan'dúúcā chi chiī ndúúcu sa. Ní cáávā chi diiⁿ sa 'túúcā, Jesús miiⁿ ní 'āā ntɛ́ɛ́ cheⁿ'e nguūvi yā mar 'áámá yáāⁿ, ti 'iiⁿ'yāⁿ s'eeⁿ snaaⁿ yā 'iiⁿ'yāⁿ. Ní Jesús cueⁿ'é yā yeⁿ'e yáāⁿ miiⁿ, ní cachiicá yā 'áámá lado yeⁿ'e yáāⁿ s'eeⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ; naati 'iiⁿ'yāⁿ yeⁿ'e nducuéⁿ'ē yáāⁿ ní n'dáa yā chi n'diichi yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cho'ōo nguuvi s'uuⁿ, Jesús miiⁿ ní nguɛɛcunée yā nndaa yā na yáāⁿ Capernaum. Ní 'iiⁿ'yāⁿ ngaⁿ'a yā chi Jesús canéé yā na va'ai miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Maaⁿnch'ɛɛtɛ́ nūuⁿ na va'ai naachi canéé Jesús miiⁿ nduuvidaamá 'yaaⁿ n'dáí 'iiⁿ'yāⁿ, ní 'āā ntɛ́ɛ́ tunéé cheendi va'āī miiⁿ chí ch'ɛɛti núūⁿ 'iiⁿ'yāⁿ s'eeⁿ. Ní Jesús miiⁿ ngaⁿ'a yā nduudu yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tuu'mi ní ndaā na cuūuⁿ sáⁿ'ā ndɛɛ yā 'áámá saⁿ'ā ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nguɛ́ɛ́ chii sndaa yā naachi canéé Jesús miiⁿ ti neené n'deēe 'iiⁿ'yāⁿ snúuⁿ yā. Cuchɛ́ɛ yā cuaaⁿ tiíⁿ va'ai ni nadivíi yā na n'duuvi táátá tiíⁿ va'āī miiⁿ. Ch'íínú n'guaaⁿ yā miiⁿya dichó'o yā saⁿ'ā ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa na yiivɛ yeⁿ'ē sa ní ndɛɛ̄ sa naachi cheendii Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Taachi Jesús n'diichí yā chi 'iiⁿ'yāⁿ s'eeⁿ vɛ́ɛ́ vaadī i'téénu nanáaⁿ yā, caⁿ'a yā chii yā saⁿ'ā ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa: Díí, daiyá, núúⁿndí yeⁿ'ē dī 'úú ní nch'ɛɛ̄cú. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","N'duuvi maestros yeⁿ'e ley miiⁿ chí vɛɛtɛ́ yā miiⁿ, nadacádíínuuⁿ yā 'tíícā na staava yeⁿ'é ya. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Dɛ'ɛ̄ cúúví chí 'tíícā ngaⁿ'a sáⁿ'a 'tīī? Ngaⁿ'a sa yeⁿ'e dendu'ū chi nguɛ́ɛ́ n'daācā chi contra yeⁿ'e Ndyuūs, ti mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuví diíⁿ yā nadach'ɛɛcú yā nuūⁿndī yeⁿ'e 'iiⁿ'yāⁿ, ti dámaaⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús miiⁿ ní deenu yā dɛ'ɛ̄ chi nadacádíínuuⁿ saⁿ'ā s'eeⁿ, ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: ¿Dɛ'ɛ̄ cúúví chí 'tíícā nadacádíínuuⁿ ndís'tiī na staava yeⁿ'é nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿'Áá nguɛ́ɛ́ ngiⁿ'īi ca chi caaⁿ'máⁿ cuuvi saⁿ'a ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa: Nuuⁿndi yeⁿ'ē di ní 'āā nchɛɛcú yeⁿ'ē di, o 'úú caaⁿ'máⁿ: Ndúcuééⁿ di, ní nadīcuéeⁿ di yiivɛ yeⁿ'ē di ní caaca di? ");
INSERT INTO cuxNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ní caāvā chi ndís'tiī inaáⁿ nī chuū, níícú cadiinuuⁿ nī chi Saⁿ'ā chi Daiya Dendyuūs ní vɛ́ɛ́ poder yeⁿ'é yā na iⁿ'yeeⁿdí 'cūū chi nadach'ɛɛcú ya nuuⁿndi. Tuu'mi ní caⁿ'a yā chii yā saⁿ'ā ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa: ");
INSERT INTO cuxNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Díí saⁿ'ā, nducuéeⁿ di, ní nadacuéeⁿ di yiivɛ yeⁿ'e di ní cunaⁿ'a di na vaacu di. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Saⁿ'a chi ngiītā miiⁿ nducueeⁿ sa, ní nadacuéeⁿ sa yiivɛ yeⁿ'e sa, ní nan'daa sa miiⁿ. Ní nducyaaca 'iiⁿ'yāⁿ n'diichí yā chuū ní cheⁿ'e yiinú yā ní dich'ɛɛtɛ́ yā Ndyuūs. Ní ngaⁿ'a yā: Mar 'áámá vmnéⁿ'ēe nguɛ́ɛ́ n'diichi yú dendu'ū chi 'tuucā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Cuayiivi Jesús miiⁿ cheⁿ'e yā cuaaⁿ 'díítuú nuūⁿnīⁿ'yáⁿ'ā. Ní taachi nducyaaca 'iiⁿ'yāⁿ ndaá yā nanáaⁿ yā, ní Jesús miiⁿ ní chí'cuéeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ní taachi cachiicá Jesús miiⁿ, n'diichí yā 'áámá saⁿ'ā chi nguuvi Leví, chi daiya Alfeo. Vɛ́ɛ́ sá naachi vɛ́ɛ́ 'iiⁿ'yāⁿ chi ínn'guɛɛ yeⁿ'e impuestos. Ní Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: Díí saⁿ'ā, cuchíi di caⁿ'ā di nduucú. Tuu'mi ní Leví miiⁿ nducueeⁿ sa ní cueⁿ'e sa ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tuu'mi ní Leví miiⁿ diiⁿ sa invitar Jesús miiⁿ chí caⁿ'á yā na vaacu sa ní che'e yā ndúúcū sa. Neené 'yaaⁿ 'iiⁿ'yāⁿ chi ínn'guɛɛ yeⁿ'e impuestos ndúúcū 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā ndaā ntúuⁿ yā. Ní 'yaaⁿ n'dáí yā ch'ɛɛtɛ́ yā na mesa daama ndúúcū Jesús ndúúcū discípulos yeⁿ'e yā ti neené 'yaaⁿ 'iiⁿ'yāⁿ chi cueⁿ'e yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ní taachi maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ fariseos n'diichí yā chi Jesús ní nge'e yā ndúúcū nducyaaca 'iiⁿ'yāⁿ s'eeⁿ, tuu'mi ní caⁿ'a yā chii yā discípulos yeⁿ'e Jesús: ¿Dɛ'ɛ̄ cúúví chí maestro yeⁿ'é nī vɛ́ɛ yā nge'e yā ní ngi'i yā ndúúcū 'iiⁿ'yāⁿ chí inn'guɛɛ yeⁿ'e impuestos ndúúcū 'iiⁿ'yāⁿ nuuⁿndi? ");
INSERT INTO cuxNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Taachí Jesús ch'iindiveéⁿ yā chuū, tuu'mi ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ ngííta yā nguɛ́ɛ́ neⁿ'e yā 'aama médico. Dámaaⁿ 'iiⁿ'yāⁿ chí ngiitā neⁿ'e yā chi cuuvi yíícú yā. 'Úú ní nguɛ́ɛ́ cuchií chi yaa'ví 'iiⁿ'yāⁿ chi nadacadiinúúⁿ yā chi ch'ɛɛtɛ maaⁿ yā chi nguɛ́ɛ́ dinuuⁿndí yā caati chí yaa'ví 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","'Áámá tiempo taachi discípulos yeⁿ'e Juan miiⁿ ndúúcū fariseos ca'diinúⁿ yā, náⁿ'ā 'iiⁿ'yāⁿ ndaa yā nanááⁿ Jesús miiⁿ ní ntiinguunéeⁿ yā Jesús: ¿Dɛ'ɛ̄ cuuvi chí ca'diinúⁿ discípulos yeⁿ'e Juan miiⁿ ndúúcū 'iiⁿ'yāⁿ fariseos miiⁿ naati discípulos yeⁿ'é nī nguɛ́ɛ́ ca'diinúⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús nan'guɛɛcútaⁿ'a yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá ca'diinúⁿ 'iiⁿ'yāⁿ chi ndií yā invitado naachí n'giindivaacu 'iiⁿ'yāⁿ 'naaⁿ chi sáⁿ'ā chi n'giindivaacu sa canéé sá ndúúcu yā? Ndúúti chi canéé saⁿ'ā chi n'giindivaacu sa miiⁿ, nguɛ́ɛ́ cuuví ca'diinúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Naati cuchii tiempo taachí ch'iī saⁿ'ā chi n'giindivaacu sa tuu'mi ní cuuvi ca'diinúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuta'á yā 'áámá tááⁿ tiinūuⁿ ngaī chi 'āā nguɛ́ɛ́ naaⁿnu yā chi 'iindi'yaatá yā yeⁿ'ē na catecai ndiicúú yeⁿ'e yā. Ndúúti chi diíⁿ yā 'tíícā, maáⁿ tiinūuⁿ ngaī miiⁿ ní cáancuūⁿ cú'teeⁿ tiinūuⁿ ndiicúú miiⁿ. Níícú cuuví ch'ɛɛtɛ ca naachí ndíí n'teeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","'Tiicá ntuūⁿ mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ caaⁿn'yúⁿ yā vino ngai na bolsa yííⁿmáⁿ ndiicúū yeⁿ'e vino tan'dúúcā chi diīiⁿ 'iiⁿ'yāⁿ ndiicúū. Nduuti chi diíⁿ yā 'tíícā vino ngai miiⁿ ní di'cuūní yííⁿmáⁿ ndiicúū miiⁿ ní cuuvi ndai vino miiⁿ ndúúcū yííⁿmáⁿ. Chííⁿ chi vino miiⁿ canéé chi 'cueēⁿ na bolsa yííⁿmáⁿ ngai. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Áámá nguuvi chí sábado chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ Israel Jesús miiⁿ ndúúcū discípulos yeⁿ'é yā cho'ó yā 'áámá campo naachi vɛ́ɛ́ trigo ní discípulos yeⁿ'é yā ní tucá'a yā tiicú yā yááⁿ miiⁿ yeⁿ'e trigo taachi cho'ó yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tuu'mi ní 'iiⁿ'yāⁿ fariseos ní caⁿ'a yā chii yā Jesús miiⁿ: N'diī cuin'dííchí nī, ¿dɛ́'ɛ̄ cúúví chí diíⁿ discípulos yeⁿ'e nī chi nguɛɛ canéé chi diiⁿ yú nguuvi chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Naati Jesús miiⁿ ní caⁿ'a yā chii yā saⁿ'ā fariseos: ¿'Áá nguɛ́ɛ́ n'geēⁿ ndís'tiī chi diiⁿ David miiⁿ ndúúcū 'iiⁿ'yāⁿ chi cachiica ndúúcu yā taachi cuiicu yā? ");
INSERT INTO cuxNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David miiⁿ ní sndáa yā ná yáacū yeⁿ'é Ndyuūs taachi saⁿ'ā chi nguuvi Abiatar ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'ē chiiduú ch'ɛɛtɛ ca. Ní David che'é yā panes yeⁿ'e nátai yeⁿ'é Ndyuūs chi dámaāⁿ chiiduú s'eeⁿ cuuvi che'é yā. Ní David miiⁿ ca'a yā pan miiⁿ 'iiⁿ'yāⁿ chi snéé ndúúcu yā. Ní che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: Nguuvi chi ntaavi'tuunúúⁿ yā canéé chí cuuví yeⁿ'e saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū naati nguɛ́ɛ́ saⁿ'ā chi cuuvi yeⁿ'ē nguuvi chi ntaavi'tuunúuⁿ saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cáávā chuū chííⁿ chí Saⁿ'ā chi Daiyá Dendyuūs cuuví caaⁿ'maⁿ ntiiⁿnyúⁿ ntúuⁿ sa yeⁿ'ē nguuvi chi ntaavi'tuunúuⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús miiⁿ ní chindáā ntúuⁿ yā na yáacū sinagoga. Ní miiⁿ canee 'áámá saⁿ'ā ndúúcū ta'ā sa chi ntí'i. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Iiⁿ'yāⁿ fariseos ní neⁿ'é yā n'diichi yā nduuti chi Jesús miiⁿ chi ndúuvā yeⁿ'ē saⁿ'ā miiⁿ caati nguuvi sábado chi ntaavi'tuunúuⁿ 'iiⁿ'yāⁿ. Ní fariseos cuuví caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tuu'mi ní Jesús miiⁿ ngaⁿ'a yā ngii yā saⁿ'ā chí ntí'i ta'ā sa miiⁿ: Nducuééⁿ dí ní cueendii di naavtaⁿ'a yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús miiⁿ ní ntiinguuneeⁿ yā saⁿ'ā s'eeⁿ ní caⁿ'a yā: ¿Dɛ́'ɛ̄ diiⁿ yú nguuvi chi ntaavi'tuunúuⁿ yú? ¿'Áá cuuvi chi diiⁿ yú cosas chi n'daācā o cosas chi nguɛ́ɛ́ n'daācā? ¿'Áá n'daācā chí nguaⁿ'āī yú vida yeⁿ'e 'iiⁿ'yāⁿ o chi 'caaⁿ'nūⁿ yú 'iiⁿ'yāⁿ? 'Iiⁿ'yāⁿ s'eeⁿ ní ch'ɛɛtinéé 'diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tuu'mi ní Jesús miiⁿ ní n'diichi yuudú yā saⁿ'ā s'eeⁿ ní s'neeⁿ ndaachi yiinú yā ti nguɛ́ɛ́ neⁿ'e cu'téénu sá yeⁿ'e yā. Ní Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: N'doō di ta'a di. Ní saⁿ'ā miiⁿ n'doō sa ta'ā sa, ní ta'ā sa ní nduūvā n'daacā tan'dúúcā taama. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tuu'mi ní can'dáā 'iiⁿ'yāⁿ fariseos ní ndeé yā ndúúcū 'iiⁿ'yāⁿ yeⁿ'e Herodes ní 'íícú n'diichí yā táácā diíⁿ yā ní 'íícú cuuvi 'caaⁿ'núⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús miiⁿ ndúúcū discípulos yeⁿ'e yā cueⁿ'é yā cuaaⁿ na 'díítuú nuūⁿnīⁿ'yáⁿ'ā. Nééné 'yaaⁿ 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Galilea ndúúcū yáⁿ'āa Judea cheⁿ'e yā can'dáa yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Taachi 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Galilea chicadíínuuⁿ yā yeⁿ'é dendu'ū chi n'gɛɛtɛ n'dai chi Jesús diíⁿ yā, nééné 'yaaⁿ 'iiⁿ'yāⁿ ndaa yā n'diichi yā Jesús miiⁿ. 'Iiⁿ'yāⁿ s'eeⁿ ní 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Judea, ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén, ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Idumea, ndúúcū 'iiⁿ'yāⁿ yeⁿ'e táámá 'diituú yíícú Jordán, ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Tiro ndúúcū yáⁿ'āa Sidón. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cáávā chi ndaā n'deee n'dáí 'iiⁿ'yāⁿ, Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā chi cu'nee yaáⁿ yā 'áámá barco yeⁿ'e yā, níícú cuuví cuchɛ́ɛ yā barco miiⁿ chi 'yaaⁿ n'dáí 'iiⁿ'yāⁿ nguɛ́ɛ́ 'cuɛɛti núūⁿ chiichi yā yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ní Jesús diíⁿ yā chi 'yaaⁿ n'dáí 'iiⁿ'yāⁿ nduūvā yeⁿ'e yā. Ní nducyáácá 'iiⁿ'yāⁿ chi ngiitā neⁿ'é yā tuu'ví yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ní 'iiⁿ'yāⁿ chi canee yā ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ, espíritu miiⁿ diīiⁿ chi 'iiⁿ'yāⁿ s'uuⁿ ndaa yā nanááⁿ Jesús ní espíritu ní 'cai yeⁿ'e 'iiⁿ'yāⁿ: Díí ní Saⁿ'a chi Daiya Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús caⁿ'a yuudu yā espíritu s'uuⁿ 'túúcā: Nguɛ́ɛ́ caaⁿ'maⁿ dí du'u 'iiⁿ'yāⁿ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Cuayiivi miiⁿ ní Jesús cuchɛ́ɛ yā na 'áámá yiīcū, naachí yaa'ví yā 'iiⁿ'yāⁿ chí neⁿ'e yā, ní 'iiⁿ'yāⁿ s'eeⁿ ndáa yā nanááⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ní nduuvidaamá ndu'ū ndiichúúví discípulos chi canee yā ndúúcu yā. Ní dicho'ó yā 'iiⁿ'yāⁿ s'eeⁿ chí caaⁿ'máⁿ yā nduudú yeⁿ'e Ndyuūs chi nduudu cuaacu yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ní Jesús ca'a yā poder discípulos yeⁿ'e yā chí cuuvi diíⁿ yā chí nduūvā yeⁿ'e 'iiⁿ'yāⁿ ní chí divíi yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","'Iiⁿ'yāⁿ s'eeⁿ ní ndiichúúví discípulos: Simón, chí duuchi ntúuⁿ sa Pedro, ");
INSERT INTO cuxNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ndúúcū Jacobo ndúúcū Juan 'diinū sa ní 'uūvī sáⁿ'a s'eeⁿ chi daiya Zebedeo, ní saⁿ'ā s'eeⁿ ní Jesús s'neeⁿ yā nguuvi sa Boanerges chi neⁿ'e caaⁿ'maⁿ Daiya Dɛɛvɛ́; ");
INSERT INTO cuxNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","tanáⁿ'a yā ní nguuvi Andrés, ndúúcū Felipe, ndúúcū Bartolomé, ndúúcū Mateo, ndúúcū Tomas, ndúúcū Jacobo chi daiya Alfeo, ndúúcū Tadeo, ndúúcū táámá Simón chi yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Canaan, ");
INSERT INTO cuxNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ndúúcū Judas Iscariote, saⁿ'ā chi cuayiivi mííⁿ ch'iⁿ'i sá du'u chi Jesús miiⁿ chi cuuvi 'caaⁿ'núⁿ yā 'yā. Ní Jesús ndúúcū ndiichuuvi discípulos yeⁿ'e yā cueⁿ'e yā ní sndaa yā na 'áámá va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cuayiivi ní Jesús cueⁿ'e yā na vaacu yā. Táámá vmnéⁿ'ēe nééné n'deēe 'iiⁿ'yāⁿ ndaa yā nanááⁿ Jesús miiⁿ chi nguɛ́ɛ́ vɛ́ɛ́ yaāⁿ chí che'e yā pan. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Taachí 'iiⁿ'yāⁿ yeⁿ'e familia yeⁿ'e Jesús chicadíínuuⁿ yā yeⁿ'e Jesús, yeⁿ'e chi 'iiⁿ'yāⁿ ngaⁿ'a yā chi Jesús ní nduuví loco yā, ndaa yā chi nandɛ́ɛ yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","'Tiicá ntúūⁿ maestros chí ngi'cueeⁿ ley chí chiicá yā yeⁿ'e na yáāⁿ Jerusalén ní caⁿ'a yā: Sáⁿ'a 'cūū canéé sá ndúúcū espíritu chi nguuvi Beelzebú chi Satanás chí ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'e espíritus yeⁿ'e yááⁿn'guiinūuⁿ, ní cáávā poder yeⁿ'e espíritu miiⁿ chí tun'daá yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tuu'mi ní Jesús miiⁿ ní yaa'vi yā 'iiⁿ'yāⁿ s'eeⁿ ní s'neeⁿ yā 'áámá ejemplo. Ni caⁿ'a yā: ¿Táácā cuuví diiíⁿ yááⁿn'guiinūuⁿ divíi sa yááⁿn'guiinūuⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ndúúti chi 'áámá gobernador chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yáāⁿ naachi vɛ́ɛ́ 'uūvī partido chi n'guⁿ'u ná 'aamá yā ndúúcū yeⁿ'e taama yā 'iiⁿntyéⁿ'ē miiⁿ nguɛ́ɛ́ cuuvi 'nááⁿ yā chí 'iiⁿntyéⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ndúúti chi n'deēe nadacádíínuuⁿ yā na 'áámá familia chi vɛ́ɛ́ partido yeⁿ'ē, familia miiⁿ ní nguɛ́ɛ́ cuuvi nduuvidáámá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","'Tiicá ntúūⁿ, ndúúti chi yááⁿn'guiinūuⁿ diiⁿ sa contra yeⁿ'e maaⁿ sa, nguɛ́ɛ́ cuuví cūnee sa ti chúū diīiⁿ chí 'cuiinu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi cundaa yā na vaacu 'áámá saⁿ'ā chí vɛ́ɛ́ fuerzas yeⁿ'ē sa ní divíi yā dendu'u yeⁿ'ē sa. Canéé chí caāchiichí yā saⁿ'ā vmnááⁿ vmnaaⁿ. Cuayiivi ní cuuvi diíⁿ yā divíi yā dendu'ū chi snúūⁿ va'ai yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nduudu cuaacu 'úú ngaⁿ'á ngií ndís'tiī. Tanducuéⁿ'e nuuⁿndi chí diíⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū ndúúcū nduudu taaⁿ chi 'iiⁿ'yāⁿ s'eeⁿ ngaⁿ'a yā contra yeⁿ'e Ndyuūs, Ndyuūs nadich'ɛɛcú yā nuuⁿndí yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Naati 'iiⁿ'yāⁿ chi ngaⁿ'a yā nduudu taaⁿ chi nguɛɛ n'dáacā yeⁿ'e Espíritu N'dai yeⁿ'é Ndyuūs, ní nguɛ́ɛ́ nch'ɛɛ̄cū yeⁿ'é yā maaⁿ ní tiempo chi cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","'Tíícā Jesús ngaⁿ'a yā ti náⁿ'ā 'iiⁿ'yāⁿ ngaⁿ'a yā chi Jesús mííⁿ ní vɛ́ɛ́ espíritu yeⁿ'e yááⁿn'guiinūuⁿ nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cuayiivi ní ndaā chɛɛcuú Jesús miiⁿ ndúúcū 'díínu yā, ní ch'ɛɛtinée yā cuaaⁿ chuva'āī. Ní dichó'o yā 'áámá saⁿ'ā chi yaa'vi sa Jesús chi cuchií yā nanáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","'Yááⁿ 'iiⁿ'yāⁿ ní vɛɛtɛ́ yā cuaaⁿ 'diituú Jesús miiⁿ ní caⁿ'a yā: Chɛɛcú nī ndúúcū 'diinú nī ní in'nuúⁿ yā n'diī cuaaⁿ chuva'āī. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús miiⁿ ní caⁿ'a yā chii yā saⁿ'ā miiⁿ: ¿Dú'ū chí chɛɛcú miiⁿ? o ¿dú'ū chí 'diinú miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tuu'mi ní Jesús n'gíínu yā 'iiⁿ'yāⁿ chí vɛɛtɛ́ yā cuaaⁿ 'diitúú yā ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ s'eeⁿ: N'diichí nī. 'Iiⁿ'yāⁿ chi snée yā nduucú miiⁿ, 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā chí chɛɛcú ndúúcū 'diinú. ");
INSERT INTO cuxNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ní 'āā du'ú nūuⁿ chi diīiⁿ chiiⁿ chi Ndyuūs neⁿ'e yā chi diíⁿ yā, 'iiⁿ'yāⁿ s'eeⁿ chíí vi'í, 'iiⁿ'yāⁿ s'eeⁿ chíí 'diinú, ndúúcū chɛɛcú. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Taama vmnéⁿ'ēe Jesús miiⁿ ní tucá'a yā chi'cueeⁿ yā cuaaⁿ 'diituú nuūⁿnīⁿ'yáⁿ'ā. Ní nduuvidáámá n'deee n'dáí 'iiⁿ'yāⁿ naachi canéé Jesús miiⁿ ndíí 'āā ntɛ́ɛ́ lugar chí cuééndii Jesús. Ní chindáa yā na 'aama barco chi canuuⁿ vmnaaⁿ nuūⁿnīⁿ'yáⁿ'ā miiⁿ. Ní miiⁿ ch'iīndí yā chi ca'cueeⁿ yā. Nducyáácá 'iiⁿ'yāⁿ ch'ɛɛtinée yā na 'diituú nuūⁿnīⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","N'deēe n'dáí parábolas caⁿ'a Jesús 'iiⁿ'yāⁿ s'eeⁿ chi ejemplos chi tan'dúúcā dendu'u chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū. Ní taachí ngi'cueeⁿ yā caⁿ'a yā ndúúcū 'iiⁿ'yā s'eeⁿ 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ndís'tiī ní 'caandiveéⁿ nī chuū. 'Áámá saⁿ'ā chi ngiīnū ndaāta ní cuéⁿ'e sá cuūnū sa ndaata miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Taachi chiīnū sa ní 'áámá duutu ndaata mííⁿ chiiya na 'diituú yúúní ní ndaā 'yáádá ní che'e tī. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Náⁿ'ā duutu ndaata ní chiiya nguaaⁿ tuūú naachi nguɛ́ɛ́ dáana n'deēe yáⁿ'āa vɛ́ɛ́. Duutu ndaata miiⁿ núúⁿ cān'daa tí yáⁿ'āa miiⁿ nguɛɛ daanáá yáanūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ní taachi can'daā yaatū miiⁿ ní ti'i caati nguɛ́ɛ́ yaānūuⁿ snúū díí'yú. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Náⁿ'ā duutu ndaata miiⁿ chiiya nguaaⁿ yááⁿ. Yááⁿ s'eeⁿ ní ch'iīta ní di'vaāchi yéⁿ'ē. Chííⁿ chí ndaata miiⁿ ní nguɛ́ɛ́ dichií'vɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Náⁿ'ā duutu ndaata mííⁿ na yáⁿ'āa n'dáacā chiiyā. Can'dáā ní ch'iita n'deee n'dáí cosecha yeⁿ'ē. N'duuvi ní ch'ɛɛtinéé tanduu ndiicu ndiichi ndaata yeⁿ'ē. Tan'duuvi ní 'iīnū ngɛɛcu ndiichi ndaata yeⁿ'ē ní tan'duuvi ní 'áámá ciento ndaata yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī chi vɛ́ɛ́ veéⁿ nī, 'caandiveéⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Cuayiivi taachí nduūvī dámaáⁿ yā ndaa nanááⁿ Jesús náⁿ'ā 'iiⁿ'yāⁿ chi snéé niiⁿnúⁿ yā ndúúcū ndiichúúví discípulos ní ntiinguunéeⁿ yā Jesús: ¿Dɛ'ɛ̄ neⁿ'e caaⁿ'maⁿ ejemplo 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī ní canéé chí cadiinuuⁿ nī chi canúúⁿ n'de'ei yeⁿ'é naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Naati tanáⁿ'ā 'iiⁿ'yāⁿ chi nguɛ́ɛ́ sneé yā nduucú, 'úú ní ngaⁿ'á ngií tanducuéⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ ndúúcū ejemplos. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Níícú 'iiⁿ'yāⁿ s'eeⁿ snaaⁿ yā naati ch'ɛɛtinée yā tan'dúúcā chí nguɛ́ɛ́ inaaⁿ yā, ní 'caandiveéⁿ yā naati ch'ɛɛtinée yā tan'dúúcā chi nguɛ́ɛ́ 'caandiveéⁿ yā, ni nguɛɛ tuumicadíínuuⁿ yā. Ndíí nguɛ́ɛ́ ndaacadáámí yā ní cu'téénu yā Ndyuūs ní nch'ɛɛ̄cū nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: ¿'Áá nguɛ́ɛ́ ituumicadíínuuⁿ nī yeⁿ'ē ejemplo 'cūū? ¿Táácā, túú'mí, cádíínuuⁿ nī yeⁿ'ē tanáⁿ'ā ejemplo? ");
INSERT INTO cuxNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","'Iiⁿ'yāⁿ chí ngiinú yā ndaata miiⁿ tan'dúúcā 'iiⁿ'yāⁿ chi candɛɛ yā nduudu cuaacu yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","N'dúúví 'iiⁿ'yāⁿ ní tan'duūcā ndaata chí chiiya cyúúní mííⁿ, 'tiicá yā ch'iindiveéⁿ yā nduudu yeⁿ'é Ndyuūs. Ní cuayiivi taachí ch'iindivéeⁿ yā, chiī yááⁿn'guiinūuⁿ ní divíi sa nduudu chi ch'iindiveéⁿ yā chi canéé na staava yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tán'duuvi yā ní tan'dúúcā ndaata chí chiiya nguaaⁿ tuūú, 'tiicá yā. N'giindiveéⁿ yā nduudu cuaacu yeⁿ'é Ndyuūs ní yeenú n'daí yā nduūcū. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Naati nguɛ́ɛ́ 'áámá cānee na staava yeⁿ'e yā ní nguɛ́ɛ́ 'nááⁿ tiempo cūnee. Taachi ndaa tiempo chi 'cueenu yā cuuvi o neⁿ'e chi n'gííⁿnyuⁿneeⁿ 'iiⁿ'yāⁿ yeⁿ'é yā cáávā nduudu cuaacu miiⁿ, 'āā ntɛ́ɛ́ candii yā chí n'daacā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tán'duuvi yā ní tan'dúúcā ndaata chí chiiya nguaaⁿ yááⁿ miiⁿ, 'tiicá yā. N'giindiveeⁿ n'daacá yā nduudu cuaacu yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Naati neené neⁿ'e cá yā dendu'ū yeⁿ'e iⁿ'yeeⁿdí 'cūū ndúúcū chi vɛ́ɛ́. Ní nginnche'éí yā 'iiⁿ'yā. Ní 'iiⁿ'yāⁿ s'eeⁿ ní dineⁿ'e yā cosas chi vɛ́ɛ́ yeⁿ'e taama 'iiⁿ'yā. Tanducuéⁿ'ē chuū ní ndaá ní di'vaachií yeⁿ'e nduudu cuaacu yeⁿ'é Ndyuūs. Ní diiíⁿ chi nguɛ́ɛ́ dichíí'vɛ nduudu miiⁿ na vida yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Naati tán'duuvi yā ní tan'dúúcā ndaata chi chiiya na yáⁿ'āa n'daacā, 'tiicá yā. N'giindiveéⁿ yā nduudu cuaacu yeⁿ'é Ndyuūs ní i'teenu n'daaca yā, ní vɛ́ɛ́ n'gui'i yeⁿ'ē. N'duuví yā ní tan'dúúcā ndaata chi chiī ndiīcū ndiichi yeⁿ'ē yeⁿ'e 'aama 'aama. N'duuví yā tan'dúúcā chí chiī 'iinu ngɛɛcu ndiichí yeⁿ'ē, o tan'dúúcā chi chiī 'aama ciento yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Tiicá ntúūⁿ caⁿ'a Jesús táámá ejemplo chi 'tɛ́ɛ́ nguɛ́ɛ́ dáámá. ¿'Áá ndɛɛ yā 'áámá lámpara chí cu'neeⁿ yā maaⁿ 'aama caja o maaⁿ 'aama cama? ¿'Áá nguɛ́ɛ́ cu'neeⁿ yā lámpara miiⁿ na yaacu, 'íícú 'iiⁿ'yāⁿ cuuvi snaaⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mar 'áámá cosa chí canúúⁿ n'de'ei nguɛ́ɛ́ cunee chi nguɛ́ɛ́ snaaⁿ 'iiⁿ'yāⁿ, ndíí nguɛ́ɛ́ ndúú 'áámá cosa chi cánúúⁿ n'de'ei chi nguɛ́ɛ́ cadíínuuⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Du'ū chi vɛ́ɛ́ veéⁿ ní 'caandiveéⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ní Jesús caⁿ'a ntúuⁿ yā 'iiⁿ'yāⁿ s'eeⁿ: Cunndɛ́ɛ̄ ndís'tiī cuidado yeⁿ'e chi n'giindiveéⁿ nī. Ndúúcū caādī chi ndís'tiī idiíⁿ nī juzgar 'iiⁿ'yāⁿ, caadi mííⁿ ntúū Dendyuūs idiíⁿ yā juzgar ndís'tiī. Ní n'deēe cá n'daācā yeⁿ'ē ndís'tiī taachi Ndyuūs idiíⁿ yā juzgar ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","'Iiⁿ'yāⁿ chi vɛ́ɛ́ yeⁿ'e yā Ndyuūs ca'a cá yā 'yā. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ ca yeⁿ'e yā, Ndyuūs ndivíi yā 'tɛ́ɛ́ chi 'āā vɛ́ɛ́ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús caⁿ'a ntúuⁿ yā: Naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní tan'dúúcā 'áámá saⁿ'ā chi ngiīnu sa ndaata na yáⁿ'āa yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Saⁿ'ā miiⁿ ngiīnū sa ndaata na yáⁿ'āa. Ni chii maāíⁿ ní cyaadú sa ní nducueeⁿ sa taachí chidɛɛvɛ. Cuayiivi ní cho'ōo nguūvī cho'ōo n'gááⁿ ní ndaata miiⁿ ní can'daa ní ch'iita naati saⁿ'ā miiⁿ ní nguɛ́ɛ́ deenu sa táácā ch'iita. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yáⁿ'āa miiⁿ ngii maāⁿ yéⁿ'ē. Vmnááⁿ vmnaaⁿ ican'dáā ta'ā n'gaiyáā. Cuayiivi ní can'daā yááⁿ miiⁿ yeⁿ'e. Cuayiivi ní n'giita ní ngii trigo chí ndiitūu n'daāca na yááⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Taachí trigo miiⁿ 'āā ntí'i, tuu'mi ní ngeⁿ'e 'iiⁿ'yāⁿ chí yeⁿ'ē ní n'giica yā, ti 'āā snuū ca'a chí 'caātā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús miiⁿ ní ca'a ntúuⁿ yā: ¿Dɛ'ɛ́ tan'dúúcā naachí ngaⁿ'a ntiiⁿnyuⁿ Ndyuūs miiⁿ? o ¿dɛ'ɛ́ nduucū chi nadīdáámá yú? ");
INSERT INTO cuxNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Chuū tan'dúúcā nduutií yeⁿ'e yiivɛ̄ ntíí'yāa chi 'lííⁿ cá yeⁿ'ē tanducuéⁿ'ē nduutií chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū. Chííⁿ chi chiinu 'iiⁿ'yāⁿ na yáⁿ'āa yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Taachí 'āā niīnú yā ndaata miiⁿ ní ngíí n'gɛɛtɛ yeⁿ'ē tanducuéⁿ'ē yaātā. Ní dúuⁿnɛ̄ miiⁿ ní n'gɛɛtɛ n'dáí ngii chi 'yáádá ngíí í'neeⁿ tī 'dɛ́ɛ́cɛ tī na 'cuutí yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","'Tíícā ngi'cueeⁿ Jesús 'iiⁿ'yāⁿ s'eeⁿ nduudu cuaacu yeⁿ'é Ndyuūs ndúúcū n'deee n'dáí ejemplos tan'dúúcā chuū, tanducuéⁿ'ē chi cuuvi cadiinuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ní ngaⁿ'a yā ngii yā nducyaaca 'iiⁿ'yāⁿ ndúúcū ejemplos, naati taachi canee yā dámaāⁿ ndúúcū discípulos yeⁿ'e yā tanducuéⁿ'ē miiⁿ n'giⁿ'i yā discípulos yeⁿ'e yā dɛ'ɛ chí neⁿ'e caaⁿ'maⁿ ejemplos chi 'āā caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Taachi chi'da'á nguuvi miiⁿ, Jesús miiⁿ ngaⁿ'a yā ngii yā discípulos yeⁿ'e yā: Caⁿ'ā yú táámá 'diituú nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tuu'mi ní s'neeⁿ yā miiⁿ ní discípulos ní candɛ́ɛ yā Jesús miiⁿ na barco chí 'āā canéé na 'diituú nuūⁿnīⁿ'yáⁿ'ā ní cueⁿ'é yā. Miiⁿ ntúūⁿ canéé tanáⁿ'ā barcos. Ní 'iiⁿ'yāⁿ yeⁿ'e tanáⁿ'ā barcos cueⁿ'é ntúūⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tuu'mi ní chéenū 'áámá 'yúúné taaⁿ ní nuūⁿnīⁿ'yáⁿ'ā miiⁿ sndaa yaacú. Ní sndaā yaanūuⁿ barco miiⁿ, ní chiitūu nuūⁿnīⁿ barco naachi canéé Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ní Jesús miiⁿ ní cyáádu yā cuaaⁿ 'diituú barco miiⁿ, ní candiitinee yā na cojín. Ní discípulos ní nanduūchí yā Jesús miiⁿ ní caⁿ'a yā chii yā: N'dii Maestro, ¿'áá nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ inee nī chi 'cuūvi yú? ");
INSERT INTO cuxNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tuu'mi ní Jesús miiⁿ ní nducueeⁿ yā ní yaa'vi yā 'yúúné miiⁿ ní caⁿ'a yā chii yā nuūⁿnīⁿ'yáⁿ'ā miiⁿ 'túúcā: 'Diiíⁿ nūuⁿ cunee di. Hora mííⁿ nūuⁿ 'yúúné miiⁿ ní canee 'diiíⁿ ní nducuéⁿ'ē canee 'diīíⁿ 'diīíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tuu'mi ní Jesús miiⁿ ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: ¿Dɛ́'ɛ̄ cuuvi tátiī 'va'a nī? ¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ cu'téénu cá nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ní discípulos yeⁿ'é yā neené dii'yá yā chiī, ní ngaⁿ'a yā ngii yā nguaaⁿ maáⁿ yā ndúúcū vi'ī: ¿Du'u rá 'iiⁿ'yāⁿ 'cúū, chí ndii 'yúúné ndíí nuūⁿnīⁿ'yáⁿ'ā ch'iindiveéⁿ yeⁿ'e yā? ");
INSERT INTO cuxNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús ndúúcū discípulos ndaa yā na táámá lado 'diituú nuūⁿnīⁿ'yáⁿ'ā miiⁿ yeⁿ'e yáⁿ'āa chi nguuvi Gadara. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tuu'mi ní Jesús nan'daá yā na barco miiⁿ, ní ndaa 'áámá saⁿ'ā chi canéé ndúúcū espíritus yeⁿ'ē yááⁿn'guiinūuⁿ. Ní ngiicá sa ná vaacu sa chi 'áámá yiivi yáává chi canéé nguaaⁿ yaīnyāⁿ ní ndaa sa nanááⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Saⁿ'ā miiⁿ ní mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ chi cuuví cuta'á yā saⁿ'ā ní cachiichí yā saⁿ'ā, ndii nguɛ́ɛ́ ndúúcū cadenas. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nééné n'deēe cuuví 'iiⁿ'yāⁿ s'eeⁿ cachiichí yā saⁿ'ā miiⁿ ndúúcū cadenas ca'a sa ndúúcū ta'ā sa, náátí ch'iica sa cadenas miiⁿ, ní dicheēyéi sa cadenas miiⁿ. Ní mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ichɛ́ɛ yā ndúúcu sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cuéⁿ'é daāⁿmaⁿ cachiica sá n'gaī sa cuaaⁿ ná yiīcū ndúúcū cuaaⁿ nguaaⁿ yáinyāⁿ ndíí nguuvi ndíí n'gaaⁿ, ní 'nuu cá'ai maāⁿ sa sáⁿ'ā ndúúcū tuūu. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ní taachi n'diichi yáⁿ'áí sa Jesús miiⁿ, cueⁿ'e sa ngéénu sā nanáaⁿ yā ní chiīntii'ya sa nanáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ní caⁿ'a sa chii sa Jesús miiⁿ ní 'cáí yiicu sá: ¿Dɛ'ɛ̄ cuuvi chi ndaa nī nanaáⁿ, n'dii Jesús, Daiya Dendyuūs chi canee yā na va'ai chɛɛti nguuvi? Ngiicá cáávā chi dúúchí Ndyuūs chi nguɛ́ɛ́ tée nī vaadī 'caa'va 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Saⁿ'ā miiⁿ ní caⁿ'a sa chuū caati Jesús miiⁿ ní caⁿ'a yā chiī yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ: Ndís'tiī, nan'dáa nī yeⁿ'e sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús miiⁿ tiinguuneeⁿ yā saⁿ'ā: ¿Dɛ'ɛ̄ nguuví dí? Ní espíritus yeⁿ'e yááⁿn'guiinūuⁿ chi canéé ndúúcū sáⁿ'a 'cūū nan'guɛɛcútaⁿ'a sa: Legión nguūví, caati neené 'yaaⁿ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ní espíritus neené di'cuíítuū ca Jesús miiⁿ chi nguɛ́ɛ́ tun'dáa yā espíritus chi caⁿ'ā yaⁿ'ai yeⁿ'e yáⁿ'āa miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ní neené n'deēe puercos nge'e tī cuaaⁿ na nííⁿnúⁿ yiīcū miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ní espíritus yeⁿ'e yááⁿn'guiinūuⁿ idi'cuiitu Jesús: N'dii, dicho'ó nī nús'uu chi caⁿ'a 'nū chɛɛti puercos miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tuu'mi ní Jesús ní ca'a yā permiso, ní espíritus yeⁿ'e yááⁿn'guiinūuⁿ chínan'dáa sa yeⁿ'e saⁿ'ā miiⁿ chí ndáa sa chɛɛti puercos. Ní vɛ́ɛ́ tan'duu 'uūvi mil puercos miiⁿ. Ní taachi espíritus yeⁿ'e yááⁿn'guiinūuⁿ sndáa sa chɛɛti puercos tuu'mi ní cheenu nducyaaca tī ní chingéé nuúⁿ tī chɛɛti yaāi miiⁿ. Ní chingée tī nguaaⁿ nuuⁿniⁿ'yáⁿ'ā. Ní chiitu nuūⁿnīⁿ veéⁿ tī duutu tī cheendi tī ní ch'ii tī nguaaⁿ nuūⁿnīⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'Iiⁿ'yāⁿ chi idiiⁿ cuidado puercos cueⁿ'e yā ngéenu yā chi cuuvi yā 'iiⁿ'yāⁿ ná yáāⁿ miiⁿ ndúúcū 'iiⁿ'yāⁿ chi snéé na cuɛɛ̄tí chí chiī miiⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ can'daa yā n'diichi yā chí chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Taachí ndaa yā niiⁿnuúⁿ nanááⁿ Jesús miiⁿ, ní taachí n'diichí yā saⁿ'ā chi canéé sá ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ chi maaⁿ ní vɛɛ sa 'diīiⁿ ndúúcū catecai sa ní 'āā n'daācā sa tuu'mi ní dí'va'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","'Iiⁿ'yāⁿ s'eeⁿ chi n'diichí yā chi diiⁿ Jesús miiⁿ, ní caⁿ'a yā chii yā táácā chiī ndúúcū saⁿ'ā miiⁿ chi canéé sá ndúúcū espíritus yeⁿ'e yááⁿn'guiinuūⁿ, ní tan'duucā chí chiī ndúúcū puercos. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ di'cuíítu yā Jesús miiⁿ chi cáⁿ'a yā táámá lado yeⁿ'e yáāⁿ miiⁿya. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús cueⁿ'e yā. Ní taachi ndaa yā na barco miiⁿ ndaa saⁿ'ā chi vmnaaⁿ canéé sá ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ. Ní saⁿ'ā miiⁿ chiica sa Jesús chi caⁿ'a sa ndúúcu yā na barco miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús ní nguɛ́ɛ́ 'cuuⁿ yā naatí caⁿ'a yā: Cunaⁿ'a dí ná vaacu di ndúúcū 'iiⁿ'yāⁿ yeⁿ'ē di, ní cuuvi di 'iiⁿ'yāⁿ chi ch'ɛɛtɛ n'dai dendu'ū chi Señor 'iivú Ndyuūs miiⁿ diíⁿ yā ndúúcū dii, ní tan'dúúcā Señor 'iivú Ndyuūs miiⁿ chí nduuvi ya'āī 'iinú yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Saⁿ'ā miiⁿ ní cunaⁿ'ā sa, ní tucá'a sa chii sa 'iiⁿ'yāⁿ nuuⁿmaⁿ yáāⁿ cuaaⁿ 'diituú chi nguuvi Decápolis yeⁿ'e dendu'ū chí n'gɛɛtɛ n'dai chi Jesús diíⁿ yā ndúúcu sa. Ní nducyaaca yā che'e yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Taachí Jesús miiⁿ nanguɛɛcunée yā ní cho'ó yā táámá lado yeⁿ'ē nuūⁿnūⁿ'yáⁿ'ā ní ndaa yā na yáⁿ'āa 'diituú nuūⁿnīⁿ'yáⁿ'ā, neené n'deēe 'iiⁿ'yāⁿ ndaa yā naachi Jesús canee yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ní ndaā 'áámá saⁿ'ā chí nguuvi sa Jairo, saⁿ'a chi ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'e yáacū sinagoga. Taachí n'diichi sa Jesús miiⁿ candiitin'díi sa na ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ní neené di'cuíítu sa Jesús miiⁿ ní caⁿ'a sa: Daiyá ní neⁿ'ē 'cuūvi tá. Cuchíi nī ní cún'du'u tá'a nī vmnaaⁿ yeⁿ'ē tá, ní cuuví nduūvā yeⁿ'e tá ní nguɛ́ɛ́ 'cuūvi tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tuu'mi ní Jesús miiⁿ ní cuéⁿ'e yā ndúúcu sa. Neené 'yaaⁿ 'iiⁿ'yāⁿ can'daa yā Jesús ní nééné chiiⁿ'nu chiichí yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ní nguaaⁿ nducyaaca 'iiⁿ'yāⁿ miiⁿ canéé 'áámá n'daataá chí ngíitā tá, chí 'āā ndiichúúví nduūyū canee tá ndúúcū ca'ai chí nguuvi nguuvi ngee yuuúⁿ yeⁿ'e cuerpo yeⁿ'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nééné n'geenu tá ngii ndúúcū médicos, ní 'āā ch'iinu diīⁿ tá gastar tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē tá, naati nguɛ́ɛ́ du'ū vɛɛ dichií'vɛ̄ yeⁿ'ē tá ti dáyíícándíí cá ca'ai yeⁿ'ē ta cuaaⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","'Āā ch'iindiveeⁿ tá yeⁿ'e Jesús miiⁿ chi diíⁿ yā chi nduūvā yeⁿ'e 'iiⁿ'yāⁿ chi ngiitā. Ní cueⁿ'e tá nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ cuaaⁿ daamí Jesús ní tuū'vi tá catecai yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Caati nadicádíínuuⁿ tá maāⁿ tá 'tíícā. Ndúútī chí dámaāⁿ tuū'ví catecai yā, ní nduūvā yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hora mííⁿ nūuⁿ chi tuū'vi tá catecai Jesús miiⁿ 'tíícā canéé naaⁿ chí ngɛɛ̄ yuuúⁿ yeⁿ'ē tá. Ní chicadiinuuⁿ tá na cuerpo yeⁿ'e tá chí 'āā nduūvā yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tuu'mi ní Jesús miiⁿ tuumicádíínuuⁿ yā chí 'āā nduūvā yeⁿ'ē 'áámá 'iiⁿ'yāⁿ ndúúcū poder yeⁿ'é yā. Ní nguɛɛcundíi yā ní n'diichi yā náávtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ ní ntiinguuneeⁿ yā: ¿Du'u túu'vīi catecaí? ");
INSERT INTO cuxNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tuu'mi ní discípulos yeⁿ'e yā caⁿ'a yā: Cuin'diichí nī 'iiⁿ'yāⁿ chí i'nūuⁿ chiichí yā s'uūúⁿ miiⁿ ní maaⁿ ní ntiinguuneeⁿ nī: ¿Du'u tuū'vīi 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naati Jesús ní nguɛɛcúndii yā n'giinu yā 'áámá lado taama lado, ní 'iicu cuuvi snaaⁿ yā du'ū tuu'vī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tuu'mi ní n'daataá miiⁿ, ní in'duuvi tá chi 'va'ā tá. Deenū tá dɛ'ɛ̄ chí chiī. Cheⁿ'e tá ní chiīntii'ya tá nanááⁿ Jesús. Ní caⁿ'a tá chii tá 'iiⁿ'yāⁿ tanducuéⁿ'ē chi nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús ngaⁿ'a yā ngii yā táⁿ'ā: Díí daiyá, nduūvā yeⁿ'ē dí cáávā chi i'téénu di 'úú. Díí 'diīíⁿ nūuⁿ cunáⁿ'a di, ní ndúuvā yeⁿ'ē di yeⁿ'ē ca'ai chi ndii di. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ngaⁿ'a Jesús miiⁿ ndúúcū táⁿ'ā miiⁿ, taachí ndaa yā ná va'ai yeⁿ'e saⁿ'ā Jairo chi ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'ē 'iiⁿ'yāⁿ na yáacū sinagoga miiⁿ. Ní 'iiⁿ'yāⁿ yeⁿ'ē va'ai miiⁿ ní caⁿ'a yā Jairo: Daiya dí 'āā n'diī tá. ¿Dɛ́'ɛ̄ cuuví chi idindú'ū ca di maestro? ");
INSERT INTO cuxNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Naati Jesús miiⁿ, ní ch'iindiveéⁿ yā chí caⁿ'á yā yeⁿ'ē saⁿ'ā chí ngaⁿ'a ntiiⁿnyuⁿ sa. Ní caⁿ'a yā chii yā saⁿ'ā miiⁿ chi ngaⁿ'ā ntiiⁿnyuⁿ sa yeⁿ'e 'iiⁿ'yāⁿ na yáacū sinagoga: Nguɛ́ɛ́ 'va'a di naati cu'téénu dí. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús nguɛ́ɛ́ 'cuuⁿ yā nducyaaca 'iiⁿ'yāⁿ chi cueⁿ'e ca yā cuaaⁿ chɛɛti va'ai ndúúcu yā, ti dámaāⁿ Pedro, ndúúcū Jacobo, ndúúcū Juan, saⁿ'ā 'diinū Jacobo. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Taachí ndaa yā va'ai yeⁿ'e sáⁿ'ā chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yaācū sinagoga miiⁿ, n'diichí yā 'iiⁿ'yāⁿ. Ní ch'iindiveéⁿ yā chí n'gai yā ní ngɛɛcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tuu'mi ní taachi sn'daa yā cuaaⁿ chɛɛti va'āī miiⁿ, caⁿ'a yā: ¿Dɛ'ɛ̄ tátiī yuudu idiíⁿ nī? ¿Dɛ'ɛ̄ cúúví chí ngɛɛcu nī? Tá'díīⁿ nguɛ́ɛ́ n'dii tá, tí cyaadu tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Iiⁿ'yāⁿ s'eeⁿ ní n'gíiⁿnyūⁿneeⁿ yā yeⁿ'e Jesús miiⁿ. Tuu'mi ní Jesús miiⁿ diíⁿ yā chi can'daā nducyaaca yā. Ní Jesús can'dɛɛ yā chiida tá ndúúcū chɛɛcu tá ndúúcū discípulos chi canéé ndúúcu yā ní sndaa yā naachi candíítí ta'dííⁿ chí n'dii tá ní tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ní sta'á yā ta'ā tá ní caⁿ'a yā: Talita cumi, chi neⁿ'e caāⁿ'maⁿ na nduudu yeⁿ'e yú, díí n'daata 'lííⁿ, 'úú ngaⁿ'á ngií dii, ndúúcueeⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Hora mííⁿ nūuⁿ ta'dííⁿ miiⁿ ní nduucueēⁿ tá ní cachiīca tá. N'daata 'lííⁿ miiⁿ ní ngii tá ndiichuuvi nduūyū. Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ cueⁿ'e yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús mííⁿ yaa'vi yuudú yā 'iiⁿ'yāⁿ chi nguɛ́ɛ́ caaⁿ'maⁿ yā cuuvi yā chííⁿ mar 'áámá 'iiⁿ'yāⁿ. Ní caⁿ'a Jesús chi ca'a yā yuūndū chi che'e n'daata 'lííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús ní ndaācá yā miiⁿ ní cunaⁿ'á yā na yáāⁿ Nazaret chi yáāⁿ vaacú yā, ní discípulos yeⁿ'e yā ní cueⁿ'e yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Taachí ndaā nguuvi sábado chí ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ, Jesús tucá'a yā chi'cueeⁿ yā na yaācū sinagoga miiⁿ. Nééné 'yaaⁿ 'iiⁿ'yāⁿ ch'iindiveéⁿ yā chi caⁿ'a Jesús, ní cheⁿ'e yiinú yā. Ní caⁿ'a yā: ¿Tíí ch'eēⁿ sáⁿ'a 'cūū tanducuéⁿ'ē chuū? ¿Dɛ'ɛ́ vaadī déénú chí ca'a yā 'iiⁿ'yāⁿ miiⁿ, ndúúcū vaadī n'giinu chi diíⁿ yā chūū? ");
INSERT INTO cuxNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿'Áá nguɛ́ɛ́ sáⁿ'a 'cūū daiya saⁿ'ā 'viichiyáⁿ'á miiⁿ, daiya María miiⁿ, saⁿ'ā chí 'diínū Jacobo, ndúúcū José, ndúúcū Judas, ndúúcū Simón, ndúúcū ví'i yā chi snée yā miiⁿ nguaaⁿ s'uūuⁿ? Cáávā chi yeⁿ'e yáāⁿ miiⁿ chííⁿ chi nguɛ́ɛ́ s'teenu yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'tíī: Nducyáácá 'iiⁿ'yāⁿ dinéⁿ'e yā profetas naati nguɛ́ɛ́ dinéⁿ'e yā 'áámá profeta yeⁿ'ē yáāⁿ vaacú yā. Ní nguɛ́ɛ́ dinéⁿ'e 'iiⁿ'yāⁿ yeⁿ'é yā ndúúcū 'iiⁿ'yāⁿ na vaacu yā profeta miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesús ní nguɛ́ɛ́ chidiíⁿ yā mar 'áámá vaadī n'giinú miiⁿ, dámaaⁿ chi sn'duú yā ta'a yā vmnaaⁿ yeⁿ'e n'duuvi 'iiⁿ'yāⁿ chí ngíítā ní nduūvā yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ní cheⁿ'e yiinu Jesús tí 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ s'téénu yā. Cuayiivi miiⁿ ní Jesús cachiicá yā cuaaⁿ na yáāⁿ na niiⁿnuúⁿ ní ngi'cueeⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ní Jesús yaa'vi yā ndu'ū chi ndiichuuvi discípulos, ní tucá'a yā dicho'o yā 'iiⁿ'yāⁿ 'uuvi yā 'áámá 'áámá yáāⁿ. Ní ca'a yā poder discípulos chi tun'dáa yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ní caⁿ'a yā chii yā discípulos chi nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ candɛ́ɛ yā chi cuuví yeⁿ'ē yúúní yeⁿ'e yā, dámaāⁿ in'daacuú. Nguɛ́ɛ́ canéé chí candɛ́ɛ yā ndii mar 'áámá moral, ndíí nguɛ́ɛ́ ndúú pan ra, ndíí nguɛ́ɛ́ ndúú tuūmī ra na bolsa. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Cunúúⁿ ca'a yā ndaacuú ndaachíī, ní 'áámá nūuⁿ catecai yā, nguɛ́ɛ́ 'uūvī. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ní caⁿ'a Jesús: Ndís'tiī, taachi cúndaa nī chɛɛti 'áámá va'āī, 'cuɛɛtinée nī miiⁿ taanduvɛ́ɛ́ ndii taachí nan'dáa nī yeⁿ'e yáāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nduuti chi ndaá nī 'áámá yáāⁿ ní 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ 'cuaáⁿ yā 'cuɛɛtinée nī miiⁿ, ndíí nguɛ́ɛ́ ndúú neⁿ'e ra yā chi 'caandiveéⁿ yā yeⁿ'e nī, tuu'mi ní nan'dáa nī yeⁿ'ē yáāⁿ miiⁿ. Ní n'dáádi nī yaācáā yeⁿ'ē ca'a nī. Chuū ní 'áámá señal chi 'cuuⁿ'miⁿ nī chi nguɛ́ɛ́ n'daācā idiíⁿ yā ti contra yeⁿ'é nī. Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi nguuvi yeⁿ'e juicio duu'vi cá castigo yeⁿ'é 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Sodoma ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Gomorra, chi ndíí cuááⁿ vmnaaⁿ, ní nguɛ́ɛ́ ti 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ naachí nguɛ́ɛ́ 'cuúⁿ yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tuu'mi ní discípulos ican'dáa yā, chí caⁿ'a yā nduudu cuaacu yeⁿ'é Ndyuūs yeⁿ'ē chí ndaacadáámí 'iiⁿ'yāⁿ yeⁿ'e nuuⁿndi yeⁿ'e yā. Ní chi n̄'daaⁿ yā chí cuuvi 'cuɛɛtinéé n'daāca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","'Tuucá ntúūⁿ discípulos divíi yā neené n'deee espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ. Ní ch'ii yā aceite n'deee n'dáí 'iiⁿ'yāⁿ chi ngíitā ní nduūvā yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodes ch'iindiveéⁿ ntúuⁿ yā chuū chi núúⁿmáⁿ íⁿ'yeēⁿdī miiⁿ ní ch'iindiveéⁿ yā chí diiⁿ Jesús miiⁿ. Rey Herodes mííⁿ caⁿ'a yā: 'Āā nduūchi Juan chi ngɛɛdínuūⁿnīⁿ nguaaⁿ tináⁿ'ā, chííⁿ chí saⁿ'ā ní vɛ́ɛ́ taavi poder yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Naⁿ'a 'iiⁿ'yāⁿ ní ngaⁿ'a yā: Jesús miiⁿ ní Elías chi profeta ndíí vmnaaⁿ. Naⁿ'a 'iiⁿ'yāⁿ ní ngaⁿ'a yā: Jesús miiⁿ ní 'áámá profeta tan'dúúcā profetas chi ch'ɛɛtinéé ndii cuaaⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Taachí Herodes miiⁿ ch'iindiveéⁿ yā chuū, tuu'mi ní caⁿ'a yā: Juan sáⁿ'a 'cūū, chi 'úú chi caⁿ'a ntiiⁿnyúⁿ chi chiicá yā daandu sá ní 'āā nduuchi sa yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ti Herodes miiⁿ caⁿ'a ntiiⁿnyúⁿ yā soldados chí sta'a sa Juan ní chiicā chiichi sa ndúúcū cadenas ní chi'nuuⁿ sa saⁿ'ā vácūū cáávā n'daataá Herodías. Táⁿ'ā miiⁿ chí chiī n'daataá yeⁿ'ē Felipe cuááⁿ vmnaaⁿ ní canéé tá ndúúcū sa. Ní Felipe miiⁿ ní 'diinu Herodes. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan miiⁿ ní caⁿ'a sa chii sa Herodes miiⁿ: N'diī rey nguɛ́ɛ́ canéé chi cunee nī ndúúcū n'daataá yeⁿ'ē 'diinu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","N'daataá yeⁿ'e Herodes miiⁿ nguɛ́ɛ́ canee yiīnū tá ndúúcū chi caⁿ'a Juan miiⁿ. Ní neⁿ'e tá 'caaⁿ'nuⁿ tá Juan miiⁿ naati nguɛ́ɛ́ ngii diiⁿ tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes miiⁿ ní deenu yā chi Juan ní n'dai sa ní yeⁿ'e Ndyuūs saⁿ'ā miiⁿ. Ní rey miiⁿ 'va'á yā Juan miiⁿ. Chííⁿ chi nguɛ́ɛ́ n'guuⁿ rey miiⁿ chi táⁿ'ā miiⁿ diiⁿ daño tá ndúúcū Juan. Ní rey miiⁿ s'neeⁿ veéⁿ yā n'daacā ní ch'iindiveéⁿ yā yeⁿ'ē nduudu Juan 'áárá chi nguɛ́ɛ́ tuumicadiinúuⁿ yā nducuéⁿ'ē chi ngaⁿ'a Juan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Naati n'daataá yeⁿ'e rey miiⁿ nguuvi tá Herodías ní ndaāca tá táácā chi diiⁿ tá. Herodes miiⁿ diíⁿ yā 'áámá 'viicu nguuvi cumpleaños yeⁿ'é yā. Diíⁿ yā 'áámá 'viicu yeⁿ'ē chi nge'é yā chi che'é 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ, ndúúcū saⁿ'ā s'eeⁿ chi 'neéⁿ vmnaaⁿ yeⁿ'e soldados, ndúúcū 'iiⁿ'yāⁿ yuudu yeⁿ'ē yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ní taachí nge'e yā n'daatāa 'lííⁿ daiya táⁿ'ā Herodías miiⁿ sndaā tá naachi nge'e yā. Ní nde'ei tá. Rey Herodes ndúúcū 'iiⁿ'yāⁿ chi snée yā ndúúcu sa chiī yeenú yā chi nde'ei tá. Ní miiⁿ caⁿ'a yā chii yā n'daataa 'lííⁿ miiⁿ: Dii, n'daataa 'lííⁿ, caaca di 'úú chí neⁿ'e dí ní 'úú ní teé dii. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ní caⁿ'a yā, “por Ndyuūs” chi ca'a yā n'daatāa 'lííⁿ miiⁿ 'āā dɛ'ɛ́ nūuⁿ chi neⁿ'e tá, 'áárá chí ná maⁿ'a yeⁿ'ē yáⁿ'āa chi ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","N'daatāa 'lííⁿ mííⁿ ní can'daā tá ní caⁿ'a tá chii tá chɛɛcu tá: Mamá, ¿dɛ́'ɛ̄ caacá? Ní chɛɛcu tá ní caⁿ'a yā chii yā tá'ā: Caaca di tíīⁿ Juan chi chɛɛdínuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maaⁿnchɛɛ̄tɛ́ nūuⁿ sndaā ta'dííⁿ miiⁿ naachi canúúⁿ rey miiⁿ, ní caⁿ'ā tá: Neⁿ'é chi maaⁿnguuví nūuⁿ teé nī 'úú chɛɛti 'áámá cu'u tiīiⁿ Juan chí chɛɛdínuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tuu'mi ní rey miiⁿ ní s'neeⁿ ndaachi nuúⁿ yā naati cáávā chi caⁿ'a yā, “por Ndyuūs”, ni cáávā 'iiⁿ'yāⁿ chi snée yā ndúúcū rey miiⁿ, nguɛ́ɛ́ chi diiⁿ nuuⁿ yā cheeⁿdiitú yā yeⁿ'ē chi ngiica ta'dííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hora mííⁿ nūuⁿ caⁿ'a ntiiⁿnyuⁿ rey miiⁿ 'áámá soldado chí cheⁿ'e sa 'caāca sa daandu Juan chí chɛɛdínuūⁿnīⁿ ní nguaī sa tiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Soldado miiⁿ ní cheⁿ'e sa ná vácūū ní ch'iica sá daaⁿndu Juan miiⁿ. Ní sn'nuuⁿ sa tiīiⁿ Juan miiⁿ chɛɛti 'áámá cu'u. Ní ndɛɛ soldado miiⁿ ní ca'a sa ta'dííⁿ miiⁿ. Ní ta'dííⁿ miiⁿ ní ca'a tá chɛɛcu tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Taachí discípulos yeⁿ'e Juan miiⁿ ch'iindiveéⁿ yā chuū, cheⁿ'é yā chi nguai yā cuerpo yeⁿ'e Juan miiⁿ. Ní candɛ́ɛ yā chí 'cuuchi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Cuayiivi miiⁿ ní apóstoles ní nduuvidaamá yā ndúúcū Jesús miiⁿ ní caⁿ'a yā chii yā Jesús tanducuéⁿ'ē chí dīiⁿ yā, ndúúcū chí chi'cueeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús caⁿ'a yā chii yā apóstoles: Cuchíi nī, ní caⁿ'a yú ntaavi'tuunúuⁿ yú na 'aama lugar chi 'aama lado yeⁿ'e yáāⁿ naachi nguɛ́ɛ́ 'iiⁿ'yā. Ngaⁿ'a yā 'tíícā, caati n'deee n'dáí 'iiⁿ'yāⁿ indaá yā nanááⁿ Jesús ndúúcū n'deee n'dáí 'iiⁿ'yāⁿ chí inaⁿ'a, ndíí maaⁿ rá chi nge'e yā, nguɛ́ɛ́ ngii. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tuu'mi ní Jesús miiⁿ ndúúcū apóstoles yeⁿ'e yā cueⁿ'é yā dámaáⁿ yā na 'áámá barco na 'áámá lugar chi nguɛ́ɛ́ snéé 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Naati nééné 'yaaⁿ 'iiⁿ'yāⁿ n'diichí yā Jesús ndúúcū apóstoles, ní déénu yā du'u yā ní taachí cueⁿ'e yā. Ní nducuéⁿ'ē 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ s'eeⁿ cueⁿ'e yā chiicá yā na yáⁿ'āa naachi ndaá Jesús ní vmnaaⁿ cá ndaa yā. Ní cuayiivi ndaa Jesús miiⁿ ndúúcū apóstoles yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Taachí Jesús nan'dáa yā na barco, n'diichí yā neené n'deeé 'iiⁿ'yāⁿ ní neené ya'ai 'iinú yā 'iiⁿ'yāⁿ s'eeⁿ, ti sneé yā tan'dúúcā 'iiti cuūchī chi nguɛ́ɛ́ du'ū chí idiiⁿ cuidado 'iiti, 'tííca yā. Ní Jesús tucá'a yā chi'cueeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ n'deee n'dáí dendu'ū. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Taachí chi chiīnū, discípulos yeⁿ'é yā ní ndaá yā nanáaⁿ yā ní caⁿ'a yā: N'dii Jesús, 'āā chiīnū ní mar 'áámá 'iiⁿ'yāⁿ nguɛɛ snée yā na yáⁿ'āa 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yaa'ví nī 'iiⁿ'yāⁿ, ní caⁿ'á yā yáāⁿ n'gaiyáā ndúúcū yaāⁿ n'gɛɛtɛ chi snéé na niiⁿnuúⁿ ní cuái yā pan, ti nguɛ́ɛ́ ndɛ́ɛ yā chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naati Jesús ní nan'guɛɛcútaⁿ'a yā yeⁿ'e yā ní caⁿ'a yā: Ndís'tiī, ca'á nī che'e yā. Discípulos ní caⁿ'a yā: ¿'Áá cuuvi diiⁿ nús'uu chi caⁿ'a 'nū cuái 'nū 'uuvi ciento caadi pan, ní ca'á 'nū che'e yā? ");
INSERT INTO cuxNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús caⁿ'a yā chii yā discípulos: ¿'Áá n'deee panes yeⁿ'ē ndís'tiī vɛɛ? Cuéⁿ'e nī n'diichi nī. Taachí 'āā n'diichí yā, tuu'mi ní yaa'ví yā: Vɛ́ɛ́ nyuⁿ'u panes ndúúcū 'uuvī 'yaācā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tuu'mi ní caⁿ'a ntiiⁿnyuⁿ Jesús chí ch'ɛɛtɛ́ 'iiⁿ'yāⁿ s'eeⁿ caadi cuááⁿ caadi cuááⁿ naachí vɛɛ yuuni cueēe. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ní naachí ch'ɛɛtɛ yā 'áámá ciento yā ní naachi ch'ɛ́ɛ́tɛ̄ɛ tá 'uūvī ngɛɛcu ndiichí yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tuu'mi ní Jesús miiⁿ ní sta'á yā ndu'ū nyuⁿ'u panes miiⁿ ndúúcū 'uuvi 'yáacā. Ní chɛɛnaaⁿ yā nanguuvi ní ca'a yā gracias Ndyuūs cáávā pan miiⁿ ndúúcū 'yaācā. Ni ch'iinu ní n'dee yā panes miiⁿ ní nca'a yā discípulos yeⁿ'e yā chi ca'a yā che'e 'iiⁿ'yāⁿ s'eeⁿ. Discípulos ca'a yā nducyaaca 'iiⁿ'yāⁿ s'eeⁿ 'yaācā miiⁿ ndúúcū pan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nducyáácá yā che'e yā ní chiitu 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ní nanngaáⁿ yā chí ningaavā miiⁿ ní chiitu ndiichúúví 'cuɛɛ̄tɛ̄ɛ ndúúcū chí ningaāva miiⁿ yeⁿ'e pan ndúúcū 'yaācā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nducyaaca saⁿ'ā chí che'ē sa panes miiⁿ ní ngii nyuⁿ'u mil sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tuu'mi ní caⁿ'a Jesús chii yā discípulos yeⁿ'e yā chí cundaa yā na barco miiⁿ ní ndaá yā táámá lado yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā miiⁿ vmnaaⁿ yēⁿ'e yā chí caⁿ'a yā na yáāⁿ Betsaida, nuuⁿmaⁿ neⁿ'e chi Jesús diíⁿ yā despedir 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Taachí Jesús diíⁿ yā despedir yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ, cueⁿ'é yā na yiīcū miiⁿ chi caaⁿ'maⁿngua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Taachí chii 'da'a miiⁿ, barco miiⁿ ndúúcū discípulos 'āā cachíícá vmnaaⁿ yeⁿ'ē nuūⁿnīⁿ'yáⁿ'ā miiⁿ ní náávtaⁿ'a nuūⁿnīⁿ'yáⁿ'ā miiⁿ canéé. Ní 'āā dámaāⁿ Jesús miiⁿ canee yā na yáⁿ'āa miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ní Jesús n'diichí yā chi discípulos ní ch'eenu yā chiī chí diíⁿ yā chí chiica barco miiⁿ ti 'yúúné miiⁿ ní contra yeⁿ'ē naachí cachiica barco miiⁿ. Na nguɛɛtiyaaⁿ 'da'a ca, Jesús ndaa yā nanááⁿ discípulos, ní ngiicá yā vmnaaⁿ nuūⁿnīⁿ miiⁿ. Ní neⁿ'é yā cho'o daamá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Taachí discípulos yeⁿ'e yā n'diichí yā Jesús chi ngiica yā cuaaⁿ vmnaaⁿ nuūⁿnīⁿ miiⁿ, discípulos nadacádíínuuⁿ yā chi 'áámá bulto ch'ɛɛtɛ ní 'cai yiicu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ti nducyáácá discípulos n'diichí yā Jesús, ní dii'yá yā chiī. Naati Jesús ní yaa'ví yā 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Ndís'tiī saⁿ'ā, nguɛ́ɛ́ 'va'á nī ti 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ní Jesús miiⁿ cuchɛ́ɛ yā na barco miiⁿ naachi snúuⁿ discípulos. Ní canéé 'diīíⁿ 'yúúné. Ní discípulos nadicádíínuuⁿ yā. Dɛ'ɛ chúúcā ch'ɛɛtɛ Ndyuūs. Ní che'e yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vaanicadíínūuⁿ yeⁿ'e discípulos ní chɛɛchí caati nguɛ́ɛ́ tuumicádíínuuⁿ yā vaadī n'giinu yeⁿ'e panes miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cho'ó barco miiⁿ ndúúcu yā táámá lado yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā miiⁿ ní ndaá yā ná yáⁿ'āa Genesaret, naachí cachiichí yā barco miiⁿ cuaaⁿ 'diituú nuūⁿnīⁿ'yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ní taachi nacan'daa yā na barco miiⁿ, 'iiⁿ'yāⁿ s'eeⁿ chi 'āā ndaá yā miiⁿ ní ntiinaáⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ní 'iiⁿ'yāⁿ s'eeⁿ caⁿ'á yā chii yā 'iiⁿ'yāⁿ yeⁿ'e núúⁿmáⁿ cuaaⁿ na yáāⁿ n'gaiyáā chi snéé niiⁿnuúⁿ chi Jesús canée yā. Ní 'iiⁿ'yāⁿ s'eeⁿ chinguai yā 'iiⁿ'yāⁿ chi ngíítā. Ní tuca'a yā ndaa yā ndúúcū 'iiⁿ'yāⁿ chi ngíítā na cama yeⁿ'é yā ní candɛɛ yā 'iiⁿ'yāⁿ nanááⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ní 'āā dɛ'ɛ́ nūuⁿ lugar naachí cueⁿ'e Jesús miiⁿ, nduuti chi na yáāⁿ n'gaiyáā, o na yáāⁿ n'gɛɛtɛ, o na campo, 'iiⁿ'yāⁿ ní í'neeⁿ yā 'iiⁿ'yāⁿ chi ngíitā cuaaⁿ cyúúní. Ní di'cuíítu yā Jesús chi ca'á yā lugar 'iiⁿ'yāⁿ chi ngíítā chi cuuví tuu'ví yā maaⁿ rá naachí ndɛɛtií yeⁿ'ē catecai Jesús. Ní nducyaaca 'iiⁿ'yāⁿ chí tuū'ví yā tiinūuⁿ yeⁿ'e yā, nduūvā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tuu'mi ní 'iiⁿ'yāⁿ fariseos ndúúcū n'duuvi maestros yeⁿ'e ley n'daa yā na yáāⁿ Jerusalén, ní ndaa yā nanááⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Iiⁿ'yāⁿ s'eeⁿ ní n'diichí yā chí discípulos yeⁿ'e Jesús miiⁿ ngé'e yā ndúúcū ta'a yā chí vaatíī, ní vɛɛ nuuⁿndi yeⁿ'e yā ti nguɛ́ɛ́ inaaⁿnu yā ta'a yā taachí āā cuɛ́ɛ́ che'e yā tan'duucā chi ngaⁿ'a ley yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chúū chii caati 'iiⁿ'yāⁿ fariseos ndúúcū nducyáácá 'iiⁿ'yāⁿ Israel candíi yā costumbres yeⁿ'é 'iiⁿ'yāⁿ ndiicúú s'eeⁿ chi nguɛ́ɛ́ che'e yā ndúúti chi nguɛ́ɛ́ n'deēe cuuví nnaaⁿnú yā ta'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Taachí indáa yā nii'vɛ̄ɛ̄, nguɛ́ɛ́ che'e yā nduuti chi nguɛ́ɛ́ nnaaⁿnu yā ta'a yā n'deēe cuūví. Vɛ́ɛ́ cá costumbres chi 'iiⁿ'yāⁿ s'eeⁿ icandiica yā, chi nnaaⁿnu yā vasos chi n'geē chí ngi'i yā, ndúúcū jarros, ndúúcū taza yeⁿ'e cūū, ndúúcū mesas. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tuu'mi ní 'iiⁿ'yāⁿ fariseos ndúúcū maestros yeⁿ'e ley miiⁿ itiinguunéeⁿ yā Jesús: ¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ candíí discípulos yeⁿ'e nī costumbres yeⁿ'e 'iiⁿ'yāⁿ ndiicúú s'eeⁿ? Nge'é yā ndúúcū ta'a yā chi vaatíī. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús nan'guɛɛcútaⁿ'a yā: N'dáacā caⁿ'a profeta Isaías miiⁿ ndii cuááⁿ vmnaaⁿ yeⁿ'e ndís'tiī chí 'uūvī naaⁿ 'uūvī cheendí nī. Chuū caⁿ'a yā taachí dingúuⁿ yā 'túúcā: 'Iiⁿ'yāⁿ s'uúⁿ ní dich'ɛɛtɛ́ yā 'úú ndúúcū cheendi yā, naati staava yeⁿ'e yā yaⁿ'āī canee yeⁿ'e 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ dichíí'vɛ̄ chí diiⁿ yā chi dich'ɛɛtɛ́ yā 'úú, ti chííⁿ chí ngi'cueeⁿ yā ní ley yeⁿ'e saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Naati ndís'tiī ní chi'néeⁿ nī leyes yeⁿ'e Ndyuūs ní candíi nī costumbres yeⁿ'e saⁿ'ā yeⁿ'ē iⁿ'yeeⁿdí 'cūū. Chííⁿ chi neené n'deee cuūví nnaaⁿnu yā jarros ndúúcū vasos naachi ngi'i nuúⁿ yā, ndúúcū chí diíⁿ yā ndúúcū neené n'deēe cá dendu'ū. Tanducuéⁿ'ē chuū ní nguɛ́ɛ́ dichíí'vɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'Tíícā caⁿ'a Jesús chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī ní cándii nī costumbres maáⁿ nī ní cáávā chuū i'neéⁿ nī 'áámá lado ley yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés caⁿ'a yā ley 'cūū: Diíⁿ nī honrar chiidá nī ndúúcū chɛɛcú nī ní 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'dáacā ngaⁿ'a yā yeⁿ'e chiidá yā o yeⁿ'ē chɛɛcú yā canéé chi 'cuūvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Naati ndís'tiī ní ngaⁿ'a nī chí nga'a nī permiso 'aama saⁿ'ā chí caaⁿ'maⁿ sá cuuvi sa chiida sa o chɛɛcu sa, 'tíícā: 'Úú ní nguɛ́ɛ́ cuuvi nneé n'diī, caati nducuéⁿ'ē chi yeⁿ'é ní Corbán. (Nduudu Corbán miiⁿ ní neⁿ'e caaⁿ'maⁿ chi ca'á yā Ndyuūs.) ");
INSERT INTO cuxNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ndúúti chi saⁿ'ā ngaⁿ'a sa 'túúcā, tuu'mi ní ndís'tiī ngaⁿ'a nī chi 'āā ntɛ́ɛ́ nga'a nī lugar chi cunnee sá chiida sá ndúúcū chɛɛcu sá. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ndís'tiī ní diíⁿ nī chi 'āā ntɛ́ɛ́ dichíí'vɛ̄ Nduudu yeⁿ'é Ndyuūs cáávā costumbre chi ngo'ó yeⁿ'ē 'áámá nī taama nī. Nééné n'deēe dendú'ū diíⁿ nī tan'dúúcā chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Caⁿ'a ntúūⁿ Jesús chii yā 'iiⁿ'yāⁿ taama vmnéⁿ'ēe ní caⁿ'a yā: Cu'neeⁿ veeⁿ nducyaaca nī yeⁿ'é, ní tuumicadiinuuⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mar 'áámá dendu'ū chi nge'e saⁿ'ā chi 'āā cuɛ́ɛ́ che'e sa cuuví diīiⁿ chi 'āā ntɛ́ɛ́ dɛɛvɛ sa. Chííⁿ chi nadicádíínuuⁿ saⁿ'a na staava yeⁿ'ē sa ní ican'daā na staava yeⁿ'ē sa chííⁿ idiīíⁿ chi 'āā ntɛ́ɛ́ dɛɛvɛ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ndís'tiī chi vɛ́ɛ́ veéⁿ nī, 'caandiveéⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Taachí Jesús s'neeⁿ yā 'iiⁿ'yāⁿ miiⁿ ní sndaa yā va'ai yeⁿ'é discípulos yeⁿ'e yā, discípulos yeⁿ'é yā ní itiinguuneeⁿ yā: ¿Dɛ'ɛ néⁿ'é caaⁿ'maⁿ ejemplo 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ní caⁿ'a Jesús chii yā discípulos: ¿'Áá 'tiicá ntuūⁿ ndís'tiī nguɛ́ɛ́ ituumicadíínuuⁿ nī? ¿'Áá nguɛ́ɛ́ deenu nī chi tanducuéⁿ'ē chi nge'e saⁿ'ā ní cungɛ́ɛ cuaaⁿ chuva'āī ní nguɛ́ɛ́ cuuví diīiⁿ chí saⁿ'ā miiⁿ ní vaati sa, ");
INSERT INTO cuxNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ti nguɛ́ɛ́ indaā na staava yeⁿ'ē sa naati na chɛɛ̄tī sa? Ní cuayiivi mííⁿ nan'daā na cuerpo yeⁿ'ē sa. 'Tíícā ní nducuéⁿ'ē chi ngé'é saⁿ'ā ní dɛɛvɛ. Ní nguɛ́ɛ́ diīiⁿ chi dinuuⁿndí yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ní caⁿ'a Jesús: Chííⁿ chí can'daā na staava yeⁿ'ē sa chííⁿ chi diiiⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ti chiiⁿ cuaaⁿ chɛɛ̄tī sáⁿ'ā chí neⁿ'e caaⁿ'maⁿ chi yeⁿ'ē na staava yeⁿ'ē sa, ican'dáā yeⁿ'ē vaanicadíínūuⁿ yeⁿ'e sa chi nguɛ́ɛ́ n'daācā. Nadacadíínuuⁿ yā yeⁿ'e chi caⁿ'a sa ndúúcū 'aama n'daataá o isáⁿ'ā chi nguɛ́ɛ́ yeⁿ'e yā, ndúúcū yeⁿ'e chi n'diichí yā 'áámá saⁿ'ā o n'daataá ní duuchinééⁿ vi'i yā, ní ndúúcū chi 'caaⁿ'núⁿ yā 'iiⁿ'yāⁿ, ");
INSERT INTO cuxNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ndúúcū yeⁿ'ē chi ididuucú yā, ndúúcū yeⁿ'e chi neⁿ'e yā cosas chi vɛ́ɛ́ yeⁿ'ē taama yā, ndúúcū yeⁿ'ē dendú'ū chi yeⁿ'e yááⁿn'guiinūuⁿ, ndúúcū yeⁿ'e chi nginnche'éí yā 'iiⁿ'yāⁿ, ndúúcū vicios, ndúúcū n'daataá chi caⁿ'ā tá ndúúcū n'daataá chi duuchinee tá vi'ī, ndúúcū yeⁿ'ē sáⁿ'ā chi caⁿ'a sa ndúúcū saⁿ'ā chi duuchinee sa vi'ī, ndúúcū yeⁿ'ē chi n'diichí yā cosas chi nguɛ́ɛ́ n'daācā, ndúúcū yeⁿ'ē chi caaⁿ'maⁿ taáⁿ yā contra yeⁿ'e Ndyuūs, ndúúcū yeⁿ'e chi dich'ɛɛtɛ́ maáⁿ yā 'iiⁿ'yāⁿ, ndúúcū nduudu chi nadicádíínuuⁿ yā tan'duucā chi loco yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tanducuéⁿ'ē dendú'u 'cūū chi nguɛ́ɛ́ n'daācā ican'daā yeⁿ'ē na staava yeⁿ'é yā. Chííⁿ chi diīiⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nan'dáā Jesús miiⁿ ní cunaⁿ'a yā na yáⁿ'āa Tiro ndúúcū Sidón. Ní chindáa yā na 'áámá va'ai. Ní nguɛ́ɛ́ neⁿ'é yā chi 'iiⁿ'yāⁿ s'eeⁿ cadíínuuⁿ yā naachi cánéé yā naati nguɛ́ɛ́ chii canúúⁿ n'de'ei yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Maaⁿnchɛɛtɛ́ tuumicadiinuuⁿ 'áámá n'daataá chi vɛ́ɛ́ 'áámá n'daataá 'lííⁿ daiya tá chi cánéé ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ. N'daata miiⁿ ní ndaā tá ní chiintii'yā tá ná ca'a Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","N'daata mííⁿ ní nguɛ́ɛ́ yeⁿ'ē ndaata yeⁿ'e 'iiⁿ'yāⁿ Israel naati yeⁿ'e ndaataá yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Sirofenicia. Ndaā tá ní chiica tá Jesús miiⁿ chí tun'dáa yā espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'ē n'daataá 'lííⁿ daiya tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Naati Jesús miiⁿ ní caⁿ'a yā chii yā n'daataá miiⁿ: Ca'a di lugar chi che'e daiyá 'iiⁿ'yāⁿ Israel vmnááⁿ vmnaaⁿ ti nguɛ́ɛ́ cánéé chí divií pan yeⁿ'e daiyá 'nū ní ca'á 'nū chi che'e 'yaānā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Táⁿ'ā miiⁿ ní nan'guɛɛcútaⁿ'ā tá: 'Tíícā, Señor, naati 'yaānā chi snée tī maaⁿ mesa miiⁿ nge'é tī cheeyéī pan chi ngéē yeⁿ'ē da'caīyāá. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tuu'mi ní Jesús miiⁿ ní caⁿ'a yā chii yā táⁿ'ā: Dii n'daataá n'daācā ngaⁿ'a di. 'Āā cuuví naⁿ'a di. Espíritu yeⁿ'e yááⁿn'guiinūuⁿ 'āā nan'dáā yeⁿ'ē daiya di. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Taachí ndaā tá na vaacu tá, n'daataá 'lííⁿ miiⁿ yeⁿ'ē tá canee tá na cama ní candiiti tá. Ní espíritu yeⁿ'e yááⁿn'guiinūuⁿ ní 'āā nan'dáā yeⁿ'ē n'daata 'lííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús nan'daa ntuuⁿ yā yeⁿ'e yáⁿ'āa Tiro ndúúcū yáⁿ'āa Sidón ndúúcū na yáāⁿ s'eeⁿ yeⁿ'e yáⁿ'āa Decápolis. Ní ndaa yā na yáⁿ'āa chi 'díítūu nuūⁿnīⁿ'yáⁿ'ā Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Miiⁿ ní ndaā 'iiⁿ'yāⁿ ndúúcū 'áámá saⁿ'ā chi chɛɛtúū chi nguɛ́ɛ́ ngii ngaⁿ'ā sa n'dáacā. Ní chiicá sá Jesús chi cun'duú yā ta'a yā vmnaaⁿ yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús candɛ́ɛ yā saⁿ'ā miiⁿ 'áámá lado naachi 'āā ntɛ́ɛ́ snée 'iiⁿ'yāⁿ ní tingúúⁿ ndutá'a yā na veeⁿ sá ní chiīdaiⁿ yā ní s'neeⁿ nduta'á yā na ch'iiya sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ní ch'íínu yā nanguuvi, ní nndaa niiⁿnúⁿ yā ní caⁿ'a yā: Efata, chi neⁿ'e caaⁿ'maⁿ na nduudu yeⁿ'é, n'guaaⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ndúúcū chuū ní n'guaaⁿ veeⁿ sá ndúúcū ch'iiya sa ní nduūvā yeⁿ'ē sa. Ní 'āā chí caⁿ'a n'dáacā sā. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ cuuvi yā mar 'áámá 'iiⁿ'yāⁿ. 'Áárá chi neené ca'a cuidado yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ cuuvi yā 'iiⁿ'yāⁿ, 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā n'deee n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ní 'iiⁿ'yāⁿ s'eeⁿ ní neene cheⁿ'e yiinú yā, ní caⁿ'a yā: 'Iiⁿ'yāⁿ miiⁿ ní tanducuéⁿ'ē idin'daacá yā, ndíí 'iiⁿ'yāⁿ chi chɛɛtúū ní idiíⁿ yā chí n'giindiveéⁿ yā. Ní 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngaⁿ'á yā ní diíⁿ yā chí ngíí ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tiempo 'cūū neené 'yááⁿ 'iiⁿ'yāⁿ nduuvidaama yā ndúúcū Jesús. Nguɛ́ɛ́ dɛ'ɛ̄ chi ca'á yā chí che'e 'iiⁿ'yāⁿ s'uuⁿ. Tuu'mi Jesús 'caí yā discípulos yeⁿ'e yā, ní caⁿ'á yā chii yā discípulos: ");
INSERT INTO cuxNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","'Úú ní ya'áí cáávā 'iiⁿ'yāⁿ s'tíī, tí 'āā 'iinu nguūvī snée yā nduucú na lugar 'cūū ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi che'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ndúúti chi nadicho'ó 'iiⁿ'yāⁿ na vaacu yā ní nguɛ́ɛ́ che'é yā, 'áátiī cuuvi cúúnú yā cuaaⁿ cyúúní chi naⁿ'a yā ti náⁿ'a yā ní yaⁿ'āī ndiicá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Discípulos ní nan'guɛɛcútaⁿ'a yā: ¿Taacá ca'á nī chi ché'é 'iiⁿ'yāⁿ na lugar naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús miiⁿ ntiinguunéeⁿ yā discípulos: ¿'Áá n'deee cá panes yeⁿ'é nī vɛ́ɛ́? Discípulos ní caⁿ'a yā: Tá ndɛɛ̄chɛ̄ vɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tuu'mi ní chii Jesús 'iiⁿ'yāⁿ s'eeⁿ chi 'cuɛɛtɛ́ yā na yáⁿ'āa miiⁿ. Ní Jesús sta'á yā ndɛɛ̄chɛ̄ panes miiⁿ. Ca'á yā gracias Ndyuūs cáávā panes miiⁿ. Ní n'dee yā panes miiⁿ ní ca'á yā discípulos yeⁿ'é yā. Ní discípulos ca'á yā che'e 'iiⁿ'yāⁿ s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vɛ́ɛ́ ntúūⁿ n'duuvi 'yaācā. Jesús sta'á yā 'yaācā ní ca'á yā gracias Ndyuūs cáávā 'yaācā ní ca'a yā discípulos chi ca'a ntúuⁿ yā 'yaācā 'iiⁿ'yāⁿ s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nducyaaca 'iiⁿ'yāⁿ che'e yā ní chiitu 'iiⁿ'yāⁿ. Ní nin'guaáⁿ yā tá ndɛɛ̄chɛ̄ 'cuɛɛ̄tɛ̄ɛ chí nángaava. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","'Iiⁿ'yāⁿ chi che'e yā ní ngii yā tan'dúú cuūuⁿ mil 'iiⁿ'yāⁿ. Tuu'mi ní Jesús miiⁿ ní diíⁿ yā despedir yeⁿ'é 'iiⁿ'yāⁿ s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ní Jesús ndaa yā na 'aama barco ndúúcū discípulos yeⁿ'e yā ní cueⁿ'é yā na yáⁿ'āa chi nguuvi Dalmanuta. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tuu'mi ní ndaā 'iiⁿ'yāⁿ fariseos ní tucá'a yā caⁿ'a yā n'deee n'dáí ndúúcū Jesús. Neⁿ'é yā n'diichi yā táacā caaⁿ'maⁿ Jesús. Chiica yā Jesús 'áámá vaadī n'giinu yeⁿ'ē na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús nandaa yiinú yā tí ndaachíī 'iinu yā na staava yeⁿ'é yā, ní caⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chí ngiica 'iiⁿ'yāⁿ s'uuⁿ 'áámá señal yeⁿ'ē vaadī n'giinu? 'Úú ngaⁿ'á cuaacu chi nguɛ́ɛ́ ca'á mar 'áámá señal 'iiⁿ'yāⁿ s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cuayiivi chi caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'uuⁿ chuū, Jesús nanguɛɛcunée yā sndaa yā na barco miiⁿ. Ní cueⁿ'e yā taama lado nuūⁿnīⁿ'yáⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Discípulos chinaáⁿ yā chi candɛɛ yā chi che'e yā, naati ndɛ́ɛ yā 'aama n'dyáⁿ'ā pan ndúúcū 'iiⁿ'yāⁿ s'eeⁿ na barco miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tuu'mi ní Jesús caⁿ'á yā chii yā discípulos: Cuin'diichí nī, cundɛ́ɛ nī cuidado yeⁿ'e levadura yéⁿ'e 'iiⁿ'yāⁿ fariseos ndúúcū levadura yeⁿ'e rey Herodes. Levadura miiⁿ ní chííⁿ chí diíⁿ yā chi nguɛ́ɛ́ n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Discípulos ní tucá'a yā caⁿ'a yā nguaaⁿ maáⁿ yā: ¿'Áá chi nguɛɛ ndɛɛ́ yú pan chiiⁿ chi 'tiicā ngaⁿ'a yā? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús miiⁿ ní déénu yā chí ngaⁿ'ā discípulos nguaaⁿ maáⁿ yā ní caⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chí ngaⁿ'a nī chi cáávā chi nguɛ́ɛ́ ndɛɛ́ nī pan? ¿'Áá cuɛ́ɛ́ tuumicadiinúúⁿ nī? ¿'Áá cuɛ́ɛ́ i'téénu nī na staava yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿'Áá nguɛ́ɛ́ inaaⁿ ndís'tiī ndúúcū nduutináaⁿ nī, ndíí nguɛ́ɛ́ ndúú n'giindiveeⁿ rá nī ndúúcū veéⁿ nī? ¿'Áá nguɛ́ɛ́ inan'gaacú nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Taachí n'deé ndu'u nyuⁿ'u panes miiⁿ chí che'e nyuⁿ'u mil 'iiⁿ'yāⁿ, ¿'áá n'deēe 'cuɛ́ɛ́tɛ̄ɛ ca pan nángaāva? ¿'Áá nin'guaáⁿ nī? 'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Ta ndiichuuví. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ní caⁿ'a Jesús: Taachí ca'á ndɛɛ̄chɛ̄ panes miiⁿ che'e cuūuⁿ mil 'iiⁿ'yāⁿ, ¿'áá n'deēe 'cuɛɛ̄tɛ̄ɛ ca nin'guaáⁿ nī? Discípulos ní caⁿ'á yā: Tá ndɛɛ̄chɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tuu'mi ní Jesús caⁿ'a yā: ¿'Áá cuɛ́ɛ́ tuumicadiinúúⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Cuayiivi miiⁿ mí ndaā Jesús ndúúcū discípulos yeⁿ'e yā na yáāⁿ Betsaida. Náⁿ'ā 'iiⁿ'yāⁿ ní ndɛ́ɛ yā 'áámá chi ngueenááⁿ nanááⁿ Jesús ní ngiicá yā Jesús chi tuu'vi yā 'iiⁿ'yāⁿ chi ngueenááⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús sta'á yā ta'ā chi ngueenááⁿ ní tun'dáa yā 'iiⁿ'yāⁿ 'áámá lado yeⁿ'e yáāⁿ 'lííⁿ miiⁿ. S'neeⁿ yā nuuⁿnīⁿ daíⁿ yā na nduutinááⁿ sa ní snduu tá'a yā vmnaaⁿ yeⁿ'e saⁿ'āⁿ miiⁿ ní itiinguunéeⁿ yā saⁿ'ā ndúúti chi 'āā inaaⁿ sa 'tɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chi ngueenááⁿ miiⁿ ní ch'iinu sa, ní caⁿ'ā sa: Inaáⁿ 'áámá saⁿ'ā tan'dúúcā chi 'áámá yáⁿ'ā 'tíícā saⁿ'ā, naati ngiicá sá. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tuu'mi ní Jesús miiⁿ ní sn'duu ntúuⁿ yā ta'a yā na nduutináaⁿ saⁿ'ā miiⁿ. Saⁿ'ā miiⁿ ní ch'íínu n'daācā sa ní nduuvī n'dai nduutináaⁿ sa. 'Āā tanducuéⁿ'ē inaaⁿ n'dáacā sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tuu'mi ní Jesús miiⁿ dichó'o yā saⁿ'ā chí cuinaⁿ'a sa na vaacu sa. Ní caⁿ'a yā: Díí, nguɛ́ɛ́ cundaā di núúⁿmáⁿ na yáāⁿ miiⁿ ní cuuvi di chuū mar 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cuayiivi miiⁿ Jesús ndúúcū discípulos yeⁿ'é yā cheⁿ'é yā na yáāⁿ s'eeⁿ yeⁿ'e yáⁿ'āa Cesarea ndúúcū yáāⁿ s'eeⁿ yeⁿ'e yáⁿ'āa Filipo. Taachí snúuⁿ yā yúúní ntiinguuneeⁿ Jesús miiⁿ discípulos yeⁿ'e yā, ní caⁿ'a yā: ¿Du'ū 'úú ngaⁿ'a 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Discípulos nan'guɛɛcútaⁿ'a yā: Náⁿ'ā 'iiⁿ'yāⁿ ní ngaⁿ'a yā chi díí chí Juan chi chɛɛdínuūⁿnīⁿ díí. Náⁿ'a yā ní ngaⁿ'a yā chi díí chí profeta Elías díí. Náⁿ'a yā ní ngaⁿ'a yā chi díí chí 'áámá profeta díí. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tuu'mi ni Jesús ntiinguunéeⁿ yā discípulos: ¿Du'ū 'úú ngaⁿ'á ndís'tiī? Tuu'mi ní Pedro miiⁿ ní caⁿ'ā sa: N'diī chí Cristo chi yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús ní caⁿ'a yā chí nguɛ́ɛ́ cuuvi yā mar 'áámá 'iiⁿ'yāⁿ chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tuu'mi ní Jesús tuca'á yā chi'cueeⁿ yā yeⁿ'ē Saⁿ'ā chi Daiya Dendyuūs. Ní neené 'cueenu sa cuuvi. 'Iiⁿ'yāⁿ chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'ā ntiiⁿnyuⁿ yeⁿ'ē yáacu miiⁿ ndúúcū maestros yeⁿ'e ley, 'āā ntɛ́ɛ́ neⁿ'e yā saⁿ'ā. Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi 'caaⁿ'núⁿ yā saⁿ'ā, naati saⁿ'ā miiⁿ ní chɛɛti 'iīnū nguuvi nduuchi sa yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","'Úú ní ngaⁿ'á cuaācú chuū. Tuu'mi ní Pedro miiⁿ ní cueⁿ'e sa ndúúcū Jesús 'áámá lado ní tucá'a sa yaa'vi neeⁿ sa Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Naati Jesús nan'guɛɛcundií yā ní n'diichí yā discípulos ní yaa'vi neeⁿ yā Pedro ní caⁿ'a yā: Díí, Pedro, tan'dúúcā yááⁿn'guiinūuⁿ, 'tíícā dii. Cuvíi di yeⁿ'ē 'úú, ti dii ní nguɛ́ɛ́ nadicádíínuuⁿ di tan'dúúcā Ndyuūs nadicádiinuuⁿ yā, ti nadicádíínuuⁿ di yeⁿ'e dendu'ū yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tuu'mi ní Jesús yaa'ví yā discípulos yeⁿ'e yā ndúúcū tanáⁿ'ā 'iiⁿ'yāⁿ, ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'uuⁿ: Ndúúti chi 'áámá 'iiⁿ'yāⁿ neⁿ'e yā caⁿ'a yā nduucú, canéé chi cu'nééⁿ maáⁿ yā tanducuéⁿ'e dendu'ū chi vɛ́ɛ́ yeⁿ'e yā ní cuta'á yā cruz yeⁿ'é yā chí tan'dúúcā chi 'cueenu taaví yā cuuvi cucáávā 'úú 'iicu caⁿ'á yā nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tí nducyáácá 'iiⁿ'yāⁿ chi neⁿ'e yā nadanguáⁿ'āī yā vida yeⁿ'e maáⁿ yā na iⁿ'yeeⁿdí 'cūū ní dindaí taama vida yeⁿ'é yā nanááⁿ Ndyuūs. Ní nducyáácá 'iiⁿ'yāⁿ chi dindaí yā vida yeⁿ'e yā cucáávā 'úú ní cucáávā nduudu cuaacu chí nguaⁿ'ai 'iiⁿ'yāⁿ, tuu'mi ní nandaacá yā vida yeⁿ'e yā nanááⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Dɛ'ɛ̄ dichíí'vɛ̄ yeⁿ'e saⁿ'ā ndúúti chi diiⁿ sa ganar nducuéⁿ'ē chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū ní dindaí sa alma yeⁿ'ē sa? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿'Áá n'deēe cuuvi nadíí'vɛ sa 'áámá 'iiⁿ'yāⁿ cucáávā alma yeⁿ'ē sa? ");
INSERT INTO cuxNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Nduuti chi 'áámá 'iiⁿ'yāⁿ cuuvi 'cuináaⁿ yā yeⁿ'e 'úú ndúúcū nduudu yeⁿ'é nanááⁿ 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā, ní nguɛ́ɛ́ n'daācā idiíⁿ yā, 'tiicá ntúūⁿ 'úú chi Saⁿ'a chi Daiyá Ndyuūs, cuuví 'cuinaáⁿ yeⁿ'e yā taachi ndaá ndúúcū dɛɛvɛ ch'ɛɛtɛ n'dai yeⁿ'ē Chiidá ndúúcū ángeles chí dɛɛvɛ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ ngaⁿ'á, chi vɛ́ɛ́ ná'a nī chi snée nī 'muuⁿ chi nguɛ́ɛ́ 'cuuví nī taanduvɛ́ɛ́ ndii snaaⁿ nī naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē chi ndaa yā ndúúcū poder yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cho'ó jaāⁿ nguuvi, ní Jesús candɛ́ɛ yā Pedro, ndúúcū Jacobo, ndúúcū Juan. Ní cheⁿ'e yā ndúúcū 'iiⁿ'yāⁿ s'eeⁿ na 'áámá yiīcū yaacu. Ní miiⁿ ní Jesús n̄'daaⁿ yā cuerpo yeⁿ'e yā nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Catecai yā nguɛɛcundáā ngii n'gai ní cuɛ́ɛ̄ tan'dúúcā nieve. Mar 'áámá 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ cuuvi naáⁿnú yā 'áámá tíínūuⁿ táátiī cuɛ́ɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ní che'enaāaⁿ sáⁿ'ā profeta Elías ndúúcū Moisés, 'iiⁿ'yāⁿ s'eeⁿ chí ch'iī ndíí cuááⁿ vmnaaⁿ. Ní ndeé yā ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tuu'mi ní Pedro miiⁿ ní caⁿ'a sá chii sá Jesús: N'dií Maestro, dɛ'ɛ chúúcā n'daācā yeⁿ'e yú chi 'cuɛɛtinée yú 'muuⁿ. Din'dái 'nū 'iīnū va'ai 'lííⁿ: 'Áámá yeⁿ'é nī, táámá yeⁿ'e Moisés, táámá yeⁿ'e profeta Elías. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Discípulos ní di'yáá yā chiī. Ní Pedro miiⁿ nguɛɛ deenu sa dɛ'ɛ̄ chi ngaⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tuu'mi ní ndaā vmnááⁿ yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ 'áámá meēeⁿ ní sn'dii 'iiⁿ'yāⁿ s'eeⁿ. Ní discípulos ch'iindiveéⁿ yā 'áámá nduudu chi ngaⁿ'a nguaaⁿ meēeⁿ miiⁿ chí ngaⁿ'ā: Sáⁿ'a 'cūū Saⁿ'ā Daiyá chí neⁿ'e n'dáí. Cu'neeⁿ veéⁿ nī yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hora mííⁿ nūuⁿ, taachi discípulos n'diichí yā, 'āā ntɛ́ɛ́ du'ū vɛɛ snéé ndúúcu yā, 'āā dámaāⁿ Jesús miiⁿ nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Taachí nangua'á yā yeⁿ'e yiīcū miiⁿ na yúúní miiⁿ naachi cunaⁿ'a yā Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ caaⁿ'máⁿ yā yeⁿ'e chi n'diichi yā, ndíí taachi Saⁿ'a chi Daiya Ndyuūs nduuchi sa yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Cáávā chuū nanguáín'daí yā chi canúúⁿ n'de'ei nguaaⁿ maáⁿ yā, naati ntiinguunéeⁿ yā nguaaⁿ maáⁿ yā ¿dɛ'ɛ̄ chi 'túúcā chi nduuchi sa yeⁿ'ē nguaaⁿ tináⁿ'ā? ");
INSERT INTO cuxNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tuu'mi ní discípulos ntiinguunéeⁿ yā Jesús ní caⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chí ngaⁿ'ā maestros yeⁿ'e ley chí Elías miiⁿ canéé chi ndaa vmnaaⁿ sa? ");
INSERT INTO cuxNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús miiⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā discípulos: Cuaacu nííⁿnyúⁿ chí Elías miiⁿ 'āā ndaá sá vmnááⁿ vmnaaⁿ ní diiⁿ sa n'nɛɛ sa tanducuéⁿ'ē yeⁿ'é Ndyuūs. ¿Dɛ'ɛ́ ngaⁿ'ā naachi canéé nguūⁿ na libro yeⁿ'e Ndyuūs yeⁿ'e Saⁿ'ā chí Daiya Ndyuūs? Ngaⁿ'a chí canéé chi 'cueenu sá cuuvi ní 'iiⁿ'yāⁿ s'eeⁿ diíⁿ yā despreciar saⁿ'ā ní nguɛ́ɛ́ neⁿ'e yā saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Naati maaⁿ ní ngaⁿ'á chi 'āā ndaā profeta Elías miiⁿ ní 'iiⁿ'yāⁿ s'eeⁿ 'āā diíⁿ yā chi neⁿ'e yā ndúúcū sa, tan'dúúcā chí ngaⁿ'a naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs yeⁿ'ē chi canéé chi chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cuayiivi mííⁿ Jesús ndaa yā naachi snéé discípulos yeⁿ'e yā. N'diichí yā neené n'deee 'iiⁿ'yāⁿ cuaaⁿ 'diituú discípulos yeⁿ'é yā. Vɛ́ɛ́ ntúūⁿ maestros yeⁿ'e ley miiⁿ chí ndeé yā n'deēe n'dáí ndúúcū discípulos. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ní taachi n'dííchi nducyaaca yā Jesús miiⁿ cueⁿ'e yiinu yā ní ngéénu yā ní ndáa yā nanááⁿ Jesús chí diíⁿ yā saludar Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tuu'mi ní Jesús ntiinguuneeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ́ ngaⁿ'a nī ndúúcū 'iiⁿ'yāⁿ s'tíī? ");
INSERT INTO cuxNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Áámá chɛ́ɛ́ 'iiⁿ'yāⁿ s'eeⁿ chi snée yā miiⁿ nn'guaacútaⁿ'a yā: N'dií Maestro, ndɛɛ́ 'aama daiyá, chi canéé sá ndúúcū 'áámá espíritu yeⁿ'e yááⁿn'guiinūuⁿ chí diiⁿ chi nguɛ́ɛ́ ngíí ngaⁿ'ā sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Āā tií nūuⁿ naachi canéé sá espíritu 'cūū ní sta'a sáⁿ'ā ní n'gɛɛ̄cu sáⁿ'ā ná yáⁿ'āa. Ní saⁿ'ā miiⁿ ní ican'dáā yáīⁿ cuaaⁿ cheendi sa. Ní n'gɛɛcu r'iīi 'dííⁿ'yúⁿ sá. Chííⁿ chí neené nduuví duūvā sa. 'Āā ngií discípulos yeⁿ'e nī chí tun'dáa yā espíritu yeⁿ'e yááⁿn'guiinūuⁿ, naati nguɛ́ɛ́ cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī, 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu nī. ¿Áá 'naaⁿ tiempo canéé chí cuneé ndúúcū ndís'tiī? ¿Áá 'naaⁿ tiempo canéé chí cuchɛɛ́ ndúúcu nī? Candɛ́ɛ nī 'muuⁿ saⁿ'ā 'dííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Cheⁿ'e yā nguai yā saⁿ'ā 'dííⁿ miiⁿ. Ní taachí n'diichi espíritu yeⁿ'e yááⁿn'guiinūuⁿ Jesús miiⁿ, yááⁿn'guiinūuⁿ miiⁿ chindɛɛvɛ saⁿ'a 'dííⁿ miiⁿ. Chɛɛcu ndáā sa ní n'gee yáīⁿ cuááⁿ cheendi sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tuu'mi ní Jesús ntiinguunéeⁿ yā chiida saⁿ'ā 'dííⁿ: ¿'Áá 'naaⁿ canee sa ndúúcū ca'ai 'cūū? Chiida sa miiⁿ ní caⁿ'a yā: Ndii chi 'lííⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nééné n'deēe cuuví espíritu yeⁿ'e yááⁿn'guiinūuⁿ miiⁿ ní n'gaanuuⁿ sáⁿ'ā nguaaⁿ nguuchi yáⁿ'ā ní nguaaⁿ nuūⁿnīⁿ va, chí neⁿ'e 'caāⁿ'nūⁿ saⁿ'ā. N'diī Jesús, ndúúti chi cúúví diiⁿ nī 'tɛɛ dɛ'ɛ̄ chi cunnee nī nús'uu, ní nuuⁿ nnee ya'āī 'iinú nī nús'uu ní cunnee nī nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: Nduuti chi cuuvi cu'téénu di, tuu'mi ní tanducuéⁿ'ē ní cuuvi cáávā 'iiⁿ'yāⁿ chi i'téénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tuu'mi ní chiida sa nééné 'caī ní ngɛɛcú yā. Ní caⁿ'a yā: 'Úú cu'teenú. Cunnee nī 'úú ní cuuvi cu'teenú ca. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Taachí Jesús n'diichí yā chi neené n'deēe 'iiⁿ'yāⁿ nduuvidaamá yā, ngaⁿ'a diitú yā ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ ní caⁿ'a yā: Dii espíritu chi diiⁿ chi nguɛ́ɛ́ ngii ngaⁿ'a ní nguɛ́ɛ́ n'giindiveéⁿ 'úú cuuví dii chi nan'dáa di yeⁿ'e cuerpo yeⁿ'e saⁿ'ā 'dííⁿ 'cūū, ní 'āā ntɛ́ɛ́ nguɛɛcunée di cundaā di na cuerpo yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Espíritu miiⁿ ní chindɛɛvɛ saⁿ'ā 'dííⁿ miiⁿ ní chɛɛ̄cundáa saⁿ'ā taama vmnéⁿ'ēe ní nan'daā yeⁿ'ē sa. S'neeⁿ saⁿ'ā 'dííⁿ miiⁿ tan'dúúcā chi ch'ii sa. Taachí 'iiⁿ'yāⁿ s'uuⁿ n'diichí yā saⁿ'ā 'dííⁿ miiⁿ neené 'yaaⁿ yā caⁿ'a yā chi n'díí sá. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naati Jesús miiⁿ ní sta'á yā ta'ā sa, ní nadicuéeⁿ yā saⁿ'ā. Saⁿ'ā 'díí miiⁿ ní chééndii sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cuayiivi ní Jesús sndaa yā na 'áámá va'ai, ní discípulos yeⁿ'e yā ntiinguunéeⁿ yā Jesús taachi snée yā 'áámá lado: ¿Dɛ'ɛ̄ cúúví chí nús'uu nguɛ́ɛ́ chitun'dáa 'nū espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e saⁿ'ā 'dííⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ní Jesús caⁿ'a yā: Espíritu 'cūū chí 'túúcā nguɛ́ɛ́ nan'daā yeⁿ'e 'iiⁿ'yāⁿ chi 'tiicá nūuⁿ caati dámaāⁿ chí ngaⁿ'angua'á yā ndúúcū chi nguɛ́ɛ́ 'āā ca'diinú yā nguuvi chi ngaⁿ'angua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Taachí can'daā Jesús ndúúcū discípulos na yáāⁿ miiⁿ, cho'ó yā na yáⁿ'āa Galilea. Jesús miiⁿ nguɛ́ɛ́ neⁿ'e yā chi cadiinuuⁿ mar 'áámá 'iiⁿ'yāⁿ chi canee yā miiⁿ, ");
INSERT INTO cuxNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ti Jesús miiⁿ ní ngi'cueeⁿ yā discípulos yeⁿ'e yā chi Saⁿ'a chí Daiya Dendyuūs miiⁿ ní canéé chí ca'a yā sáⁿ'ā na ta'āa 'iiⁿ'yāⁿ. Ní canéé chi 'caaⁿ'núⁿ yā saⁿ'ā. Ní taachí 'āā 'cuuví sa chɛɛtí 'iinū nguuvi canéé chí nduuchi sa yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naati discípulos ní nguɛ́ɛ́ túúmícádíínuuⁿ yā chi ngaⁿ'a Jesús. Ní 'va'a yā chí ntíínguuneeⁿ yā yeⁿ'e chúū. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tuu'mi ní ndaa Jesús ndúúcū discípulos yeⁿ'e yā na yáāⁿ Capernaum; ní taachí ndaa yā 'áámá va'ai, Jesús ntiinguuneéⁿ yā discípulos: ¿Dɛ'ɛ́ ngaⁿ'a ndís'tiī cuaaⁿ cyúúní? ");
INSERT INTO cuxNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Discípulos ní 'āā ntɛ́ɛ́ caⁿ'á yā mar 'áámá ti cuaaⁿ cyúúní mííⁿ ntíínguuneeⁿ vi'i yā chɛɛ́ ca yā chí ch'ɛɛtɛ ca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tuu'mi ní Jesús miiⁿ ch'iindí yā ní yaa'ví yā ndiichúúví discípulos yeⁿ'é yā chi cuchii yā nanáaⁿ yā. Ní cāⁿ'a yā: Ndúúti chi 'áámá ndís'tiī neⁿ'e nī cuuví nī cuááⁿ vmnaaⁿ, canéé chí cuuví nī ndii cuayiivi yeⁿ'ē nducyáácá yā ní ndiicuuⁿ ca nī. Ní canéé chí dichíí'vɛ̄ nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tuu'mi ní Jesús sta'á yā 'áámá saⁿ'ā 'lííⁿ ní s'neeⁿ yā naavtáⁿ'ā yeⁿ'e discípulos. Ní sta'á yā saⁿ'a 'lííⁿ miiⁿ ní ca'nuúⁿ yā saⁿ'ā. Ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: ");
INSERT INTO cuxNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","'Iiⁿ'yāⁿ chí 'cuaáⁿ yā saⁿ'ā 'lííⁿ 'túúcā, nduūcū chi duuchí, 'iiⁿ'yāⁿ miiⁿ ní 'cuaáⁿ yā 'úú. 'Iiⁿ'yāⁿ chí 'cuaáⁿ yā 'úú, nguɛ́ɛ́ dámaāⁿ 'úú cuaáⁿ yā, naati 'cuaáⁿ ntúuⁿ yā 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tuu'mi ní Juan miiⁿ ní caⁿ'a sa chii sa Jesús: N'dií Maestro, n'diichí 'nū 'áámá saⁿ'ā chi divíi sa espíritus yeⁿ'e yáán'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ ndúúcū chi dúúchí nī, naati sáⁿ'ā miiⁿ ní nguɛ́ɛ́ cachiicá sá ndúúcū nús'uu. Nguɛ́ɛ́ 'cuúⁿ 'nū chi diiⁿ sa 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús caⁿ'a yā chii yā discípulos: Ndís'tiī 'cuáaⁿ nī chi diiⁿ sa 'túúcā; ti nguɛ́ɛ́ vɛ́ɛ́ mar 'áámá 'iiⁿ'yāⁿ chi diíⁿ yā vaadī n'giinu ndúúcū chi duuchí, ní cuayiivi cúúví caaⁿ'máⁿ yā chi 'úú ní nguɛ́ɛ́ n'daācā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ti 'iiⁿ'yāⁿ chi nguɛ́ɛ́ idiíⁿ yā contra yeⁿ'e s'uūuⁿ, ní yeⁿ'é yā favor yeⁿ'ē yú. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi tée yā ndís'tiī 'áárá chi 'áámá vaso nuūⁿnīⁿ ndúúcū chi duuchí, ti ndís'tiī yeⁿ'e Cristo ndís'tiī, cuaacu nííⁿnyúⁿ 'iiⁿ'yāⁿ miiⁿ ní vɛ́ɛ́ chí ndaācā chi cuuvi yeⁿ'e yā ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tuu'mi ní caⁿ'a Jesús: 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi diíⁿ yā chi 'áámá chɛɛ chi n'gaiyáā chi i'téénu yā 'úú diíⁿ yā nuuⁿndi, n'daācā ca cáávā 'iiⁿ'yāⁿ miiⁿ chi 'iiⁿ'yāⁿ s'eeⁿ cāchiichí yā 'áámá tuūu yúúdú chí inguú 'iiⁿ'yāⁿ na daandu yā ní canuúⁿ yā 'iiⁿ'yāⁿ miiⁿ naachí yaānuúⁿ yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ní ndúúti chi ta'ā di idiīiⁿ chí dinuuⁿndi di, n'daacā ca chí 'caaca di ta'a di ní divíi di. N'daacā ca chí ndaā di ndúúcū 'aama ta'á nūuⁿ di ná vida cueⁿ'e daāⁿmaⁿ, ní nguɛ́ɛ́ chi caⁿ'ā di ndúúcū 'uūvī ta'a di na infierno, naachí nguūchī yaⁿ'ā miiⁿ ní nguɛ́ɛ́ ín'tuūvī. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Lugar miiⁿ naachi nguɛ́ɛ́ n'giī n'daāa ní nguuchi yaⁿ'ā miiⁿ ní 'āā ntɛ́ɛ́ n'tuūvī. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ndúúti chi ca'a di idiīiⁿ chí dinuuⁿndi di 'caaca ntúuⁿ di ní divíi di. N'daacā ca chí ndaa di lo'ō di na vida cueⁿ'e daāⁿmaⁿ miiⁿ, nguɛ́ɛ́ ti chí caⁿ'ā di ndúúcū 'uuvī ca'a di na infierno naachí nguuchi yáⁿ'ā miiⁿ chi nguɛ́ɛ́ ín'tuūvī. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Lugar miiⁿ ní naachi nguɛ́ɛ́ n'gii n'daāa ní nguuchi yáⁿ'ā miiⁿ 'āā ntɛ́ɛ́ ín'tuūvī. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ndúúti chi nduutináaⁿ di diīiⁿ chí idinuuⁿndí di, tuu'mi ní tun'dáa di; ti n'dáácā ca chi ndáa di ndúúcū 'áámá nduutináaⁿ naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā, nguɛ́ɛ́ ti chi caⁿ'a di ndúúcū nduu 'uuvi nduutináaⁿ di na infierno, ");
INSERT INTO cuxNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","naachi n'daāa mííⁿ nguɛ́ɛ́ n'gií tī ní nguuchi yáⁿ'ā miiⁿ 'āā ntɛ́ɛ́ ín'tuūvī tan'díí nūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ti nducyaaca 'iiⁿ'yāⁿ chi i'téénu yā canéé chí n'diichi néeⁿ yā 'cueenú yā cuuvi tan'dúúcā chi cho'ó ná nguuchi yaⁿ'ā, ní tanducuéⁿ'ē 'iiti chi 'iiⁿ'yāⁿ 'caaⁿ'núⁿ yā cáávā ofrenda yeⁿ'é Ndyuūs, diíⁿ yā preparar 'iiti miiⁿ ndúúcū yiīmā. ");
INSERT INTO cuxNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yiīmā ní n'dai. Ní nduuti chi nguɛɛ ndaācā sabor yeⁿ'ē, ¿dɛ́'ɛ̄ cuuvi diíⁿ nī, ní cuuvi nndaācā sabor yeⁿ'ē? Ndís'tiī cuneé nī tan'dúúcā chi yiīmā, 'tííca cuneé nī, ní canéé n'daaca nī 'aama nī taama nī ndúúcū vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús can'daa yā yeⁿ'e yáāⁿ Capernaum, ní cueⁿ'e yā na yáⁿ'āa Judea ndúúcū yáⁿ'āa chi canee táámá lado yeⁿ'ē yíícú Jordán. Miiⁿ ní nduuvidaama ntúuⁿ 'iiⁿ'yāⁿ naachi canéé Jesús miiⁿ. Jesús tuca'a yā chi'cueeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā costumbre yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tuu'mi ní n'duuvi 'iiⁿ'yāⁿ fariseos ndaá yā nanááⁿ Jesús ti neⁿ'é yā n'diichíneeⁿ yā Jesús miiⁿ. Ní ntiinguunéeⁿ yā Jesús ndúúti chi n'daācā chí saⁿ'ā n'tɛɛchi sá n'daataá yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús miiⁿ ní nan'guɛɛcútaⁿ'a yā: ¿Dɛ́'ɛ caⁿ'a Moisés chii sa ndís'tiī na ley yeⁿ'e yú? ");
INSERT INTO cuxNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseos ní caⁿ'a yā chii yā Jesús: Moisés miiⁿ ní 'cuūⁿ sa chi ca'a sá n'daataa miiⁿ 'áámá caaca yéⁿ'e chí i'tɛɛchi vi'i yā. Tuu'mi ní cu'neeⁿ sa táⁿ'ā sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tuu'mi ní Jesús caⁿ'a yā chii yā fariseos: Moisés miiⁿ tee sa mandamiento 'cūū, ndís'tiī, caati ndís'tiī ní neené chɛɛchi staava yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Naati ndíí cuaaⁿ vmnaaⁿ, taachi Ndyuūs din'dái yā tanducuéⁿ'ē dendu'ū, din'dái yā sáⁿ'ā ndúúcū n'daataá. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Chííⁿ chi saⁿ'ā miiⁿ cun'nééⁿ sa chiida sa ndúúcū chɛɛcu sá ní ndūūvidaama sa ndúúcū n'daataá yeⁿ'ē sa, ");
INSERT INTO cuxNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ní nduu 'uuví yā ní nduūvī 'aama yā ndúúcū ví'ī. Chííⁿ chí 'āā ntɛ́ɛ́ 'uūvi yā tí 'āā 'aama núúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chííⁿ chí saⁿ'ā miiⁿ nguɛ́ɛ́ canee chí nadivíi sa chí Ndyuūs nadaamá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cuayiivi miiⁿ taachí 'āā snée Jesús ndúúcū discípulos yeⁿ'e yā chɛɛtí 'áámá va'āī, miiⁿ discípulos nguɛɛcunée yā ntiinguuneeⁿ yā Jesús yeⁿ'e nduudu 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús caⁿ'a yā chiī yā discípulos: Saⁿ'ā chi cu'neeⁿ sá n'daataá yeⁿ'ē sa ní 'caandivaacu sa ndúúcū táámá n'daataá, saⁿ'ā miiⁿ ní idinuuⁿndi sa chi vɛ́ɛ́ táámá n'daataá yēⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ní ndúúti chi 'áámá n'daataá cu'neeⁿ ta isáⁿ'ā yeⁿ'e tá ní 'caandivaacu tá ndúúcū táámá saⁿ'ā, 'tiicá ntúūⁿ n'daataá miiⁿ idinuuⁿndi tá chi vɛ́ɛ́ taama isáⁿ'ā yeⁿ'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ níndɛɛ́ yā da'caīyāa nanááⁿ Jesús, chi Jesús tuu'ví yā da'caīyāa miiⁿ; naati discípulos ní yaa'vi néeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ chí ndɛ́ɛ̄ da'caīyāa s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Taachí Jesús n'diichi yā chuū, yaa'vi néeⁿ yā ní caⁿ'a yā chiī yā discípulos: 'Cuaaⁿ nī chiī da'caīyāa nanaáⁿ, ní nguɛ́ɛ́ ndivíi nī yeⁿ'é, ti na va'ai chɛɛti nguuvi naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní yeⁿ'ē da'caīyāa s'tíī, 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, 'iiⁿ'yāⁿ chi nguɛ́ɛ́ cu'téenu yā yeⁿ'e naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā tan'dúúcā chi i'teenú 'aama dá'caiyāa, nguɛ́ɛ́ cuuví cundaa yā naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ní Jesús sta'á yā da'caīyāa miiⁿ ní ca'nuú yā ní di'viicú yā. Ní s'neeⁿ yā sn'duū tá'a yā vmnaaⁿ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Taachí Jesús candií yā yúúní yeⁿ'é yā, ndaā 'áámá sáⁿ'ā. Ngeenu sa nanááⁿ Jesús ní chííntii'ya sa nanáaⁿ yā ní ntíínguuneēⁿ sa: N'diī Maestro chí n'dáí nī, ¿dɛ'ɛ diíⁿ ní ndaacá vida cueⁿ'e daāⁿmaⁿ chi cuuvi yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús caⁿ'a yā chii yā saⁿ'ā: ¿Dɛ'ɛ̄ cúúví chí ngaⁿ'ā dí chí n'dai 'úú? Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ n'dai yā tí dámaaⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dii ní deenu di chí canéé nguūⁿ na ley chí 'tuucā: Nguɛ́ɛ́ caⁿ'a di ndúúcū tááma n'daataá chi nguɛ́ɛ́ yeⁿ'e di. Nguɛ́ɛ́ 'caāⁿ'nuⁿ di. Nguɛ́ɛ́ diduucú di. Nguɛ́ɛ́ caaⁿ'maⁿ nduudu yaadi yeⁿ'ē mar 'áámá 'iiⁿ'yāⁿ. Nguɛ́ɛ́ cannche'ei di 'iiⁿ'yāⁿ. Dinéⁿ'e di chiida di ndúúcū chɛɛcu di. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Saⁿ'ā miiⁿ ní nan'guɛɛcútaⁿ'ā sa: N'diī Maestro, tanducuéⁿ'ē chuū 'āā idiíⁿ ndíí taachi saⁿ'ā 'lííⁿ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ní ch'iinu yā saⁿ'ā 'dííⁿ ní dinéⁿ'e yā saⁿ'ā. Ní caⁿ'a yā: Vɛ́ɛ́ táámá chi indáí yeⁿ'ē di. Cuéⁿ'é dí n'diīcuí dí tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē di, ní ca'a di 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā. Tuu'mi ní ndaācā chi vɛ́ɛ́ vaadi 'cuiica yeⁿ'e na va'ai chɛɛti nguuvi chi cuuvi yeⁿ'ē di. Tuu'mi ní cutá'a di cruz yeⁿ'ē di chi yeⁿ'ē chi 'cueenu di cuuvi ní cuchii di ní caⁿ'a di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Naatí taachi ch'iindiveeⁿ sá chuū, nééné s'neeⁿ ya'āī 'iinu sa ní neene ndaachi 'iinú sa. Ní cunaⁿ'a sa ti neené 'cuiica sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tuu'mi ní Jesús ch'iinu yā cuaaⁿ 'diitúú yā ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: Dɛ'ɛ̄ chúúcā ngíⁿ'īi chi cundaā 'iiⁿ'yāⁿ 'cuiica naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Discípulos ní nge'e yiinu yā yeⁿ'e nduudu yeⁿ'e yā; naati Jesús ní caⁿ'a ntúuⁿ yā: Ndís'tiī daiyá, dɛ'ɛ chúúcā ngíⁿ'īi chi 'iiⁿ'yāⁿ chi idinéⁿ'e ca yā chi vɛ́ɛ́ yeⁿ'e yā chí cundaa yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nguɛ́ɛ́ ngíⁿ'īi cá chi 'áámá 'iiti camello, chi ch'ɛɛtɛ cá nguɛ́ɛ́ ti 'yúúdūu chi cho'ó tī na nduutinááⁿ 'iini, chi cheendi va'ai 'lííⁿ nguɛ́ɛ́ ti 'áámá 'iiⁿ'yāⁿ 'cuiica i'téénu yā Ndyuūs ní cundáa yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Taachí discípulos ch'iindiveéⁿ yā chuū, nadicádíínuuⁿ taavi ca yā ní nguaaⁿ maaⁿ yā ntíínguunéeⁿ yā vi'ī. Tuu'mi ní ngaⁿ'a yā: ¿Du'ú cuuví nanguaⁿ'āī? ");
INSERT INTO cuxNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús miiⁿ ch'iinu yā discípulos ní caⁿ'a yā: Saⁿ'ā iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ cuuvi diiⁿ sa chuū, naati Ndyuūs cuuvi diíⁿ yā caati nanááⁿ Ndyuūs nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi nguɛ́ɛ́ cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tuu'mi ní Pedro miiⁿ tuca'a sa caⁿ'a sa ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: Nús'uu ní s'neéⁿ 'nū tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'é 'nū, ní cuchií 'nū nduucú nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús nan'guɛɛcútaⁿ'a yā: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī. 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí cu'neéⁿ yā vaacu yā, o 'díínu yā, o ví'ī, o chɛɛcú yā, o chiidá yā, o n'daataá yeⁿ'é yā, o daiya yā, o yáⁿ'āa yeⁿ'e yā, cáávā 'úú ní cáávā chi candɛɛ yā nduudu chi nguaⁿ'ai 'iiⁿ'yāⁿ, ");
INSERT INTO cuxNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cuta'á yā na iⁿ'yeeⁿdí 'cūū 'áámá ciento cúúví cá chí n'deee ca dendu'ū yeⁿ'e va'ai s'eeⁿ ndúúcū 'díínu yā ndúúcū 'cɛɛ'vɛ yā ndúúcū vi'i yā, ndúúcū chiidá yā, ndúúcū chɛɛcú yā, ndúúcū daiya yā, ní yeⁿ'ē yáⁿ'āa yeⁿ'e yā. Ní canéé chí n'géénú yā ngii chí 'iiⁿ'yāⁿ idiíⁿ yā naati ná iⁿ'yeēⁿdī chí cuchiī ndaācā vida cueⁿ'e daāⁿmaⁿ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nééné 'yaaⁿ 'iiⁿ'yāⁿ chí maaⁿ snée yā cuaaⁿ vmnaaⁿ 'iiⁿ'yāⁿ s'eeⁿ 'cuɛɛtinée yā cuaaⁿ chi cuayiivi. Ní neené 'yaaⁿ 'iiⁿ'yāⁿ chi maaⁿ snée yā cuaaⁿ chí cuayiivi, 'iiⁿ'yāⁿ s'eeⁿ 'cuɛɛtinée yā vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús ndúúcū discípulos yeⁿ'e yā snúúⁿ yā yúúní ní cuchɛɛ yā na yáāⁿ Jerusalén. Jesús cueⁿ'é yā vmnááⁿ discípulos. Ní discípulos nadicádíínuuⁿ yā ní cueⁿ'e yiinú yā ní 'va'á yā. Tuu'mi ní Jesús miiⁿ nguɛɛcunée yā ní yaa'vi ndiichúúví discípulos yeⁿ'e yā ní tuca'a yā caⁿ'a yā chii yā discípulos yeⁿ'e chi canéé chi 'cuūví yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ní caⁿ'a yā Cun'diichí nī, caa yú na yáāⁿ Jerusalén, naachí 'úú chi Saⁿ'a chí Daiya Dendyuūs miiⁿ ní 'iiⁿ'yāⁿ nca'a yā 'úú chiiduú n'gɛɛtɛ ndúúcū maestros yeⁿ'e ley. Ní 'iiⁿ'yāⁿ s'eeⁿ caacá yā yeⁿ'e 'úú chí 'cuūví. Ní nca'á yā 'úú 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ndaata yeⁿ'ē Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ní 'caaⁿnyuⁿ néeⁿ yā 'úú. Ní 'cueⁿ'é yā 'úú ní ca'a neeⁿ daiⁿ yā 'úú. 'Cuiinu chuū ní 'caaⁿ'núⁿ yā 'úú. Naati ndiichi ndii 'íínú nguuví miiⁿ, nduuchí yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tuu'mi ní Jacobo ndúúcū Juan, chí daiya Zebedeo, ndaá yā nanááⁿ Jesús miiⁿ ní caⁿ'a sa: N'diī Maestro, neⁿ'é 'nū chi diíⁿ nī 'áámá favor chí ngiica 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tuu'mi ní Jesús ntiinguuneéⁿ yā: ¿Dɛ'ɛ̄ neⁿ'e nī chi diíⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tuu'mi ní caⁿ'a sa chii sa Jesús miiⁿ: 'Cuááⁿ dí chi 'cuɛɛ̄tɛ́ 'nū 'áámá 'nū lado tá cuaācú di ní táámá 'nū ní lado tá 'cueēe di taachi 'āā ndaá hora yeⁿ'e chi ngaⁿ'a ntiiⁿnyuⁿ dí yeⁿ'e nducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tuu'mi ní Jesús miiⁿ caⁿ'a yā: Ndís'tiī nguɛ́ɛ́ déénu nī dɛ'ɛ̄ chi ngiica nī. ¿'Áá cuuvi diiⁿ di cu'u nuúⁿ nī yeⁿ'ē chí n'geēⁿ chɛɛti vaso chi yeⁿ'e chi 'cueenú cuuvi? ¿'Áá cuuvi cuta'á nī maaⁿ chi ngɛɛdínuūⁿnī chi cuta'á? ");
INSERT INTO cuxNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Juan ndúúcū Jacobo miiⁿ ní nan'guɛɛcútaⁿ'a yā: Cuuvi diíⁿ 'nū. Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ canéé chí cu'ú nī yeⁿ'e vaso chi yeⁿ'e chi 'cueenú cuuvi ní canéé chi cuta'á nī chi ngɛɛ̄dínuūⁿnīⁿ chi 'úú ita'á. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Caati nguɛ́ɛ́ ituneeⁿ 'úú chi ca'á du'ū chi 'cuūndī lado tá cuaacú o lado ta 'cueēé. Lugar 'cūū ní Ndyuūs ca'á yā 'iiⁿ'yāⁿ chi Ndyuūs diíⁿ yā 'cundiyaáⁿ yā cáávā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Taachí ch'iindiveéⁿ ndu'u ndiichí discípulos chuū, nduuvi taáⁿ yā ndúúcū Jacobo ndúúcū Juan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús ní yaa'vi yā discípulos ní caⁿ'a yā: Tan'dúúcā chi ndís'tiī deenu nī, 'iiⁿ'yāⁿ chí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e naciones vɛ́ɛ́ poder yeⁿ'é yā nguaaⁿ 'iiⁿ'yāⁿ yeⁿ'e nación yeⁿ'e yā ní 'iiⁿ'yāⁿ chí n'gɛɛtɛ cá yeⁿ'ē naciones ngaⁿ'a ntiiⁿnyúⁿ yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Naati nguaaⁿ ndís'tiī, nguɛɛ 'tíícā. 'Iiⁿ'yāⁿ chi neⁿ'e cuuvi ch'ɛɛtɛ yā nguaaⁿ ndís'tiī canéé chi dichíí'vɛ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'Āā du'ú nūuⁿ ndís'tiī chi neⁿ'e nī cunee nī cuaaⁿ vmnaaⁿ yeⁿ'e ndís'tiī canéé chí dichíí'vɛ nī nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naati Sáⁿ'ā chi Daiya Dendyuūs nguɛ́ɛ́ ndaā sa chi 'iiⁿ'yāⁿ dichíí'vɛ yā saⁿ'ā, ti maaⁿ sa dichíí'vɛ sa nducyaaca 'iiⁿ'yāⁿ, ní ca'a sa vida yeⁿ'e maāⁿ sa tan'dúúcā precio yeⁿ'ē nuuⁿndi cáávā chí nanguaⁿ'ai yā n'deee n'daí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tuu'mi ní ndaā Jesús ndúúcū discípulos na yáāⁿ Jericó. Ní taachí can'daa yā yáāⁿ Jericó ndúúcū 'yaaⁿ n'dáí 'iiⁿ'yāⁿ 'áámá sáⁿ'ā chí ngueenááⁿ chi nguuvi Bartimeo, daiya Timeo, vɛ́ɛ́ sá niiⁿnuúⁿ cyúúní ní ngiica sá limosnas. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ní taachí ch'iindiveeⁿ sa chí Jesús yeⁿ'e yáāⁿ Nazaret cho'o yā miiⁿ, saⁿ'a ngueenááⁿ miiⁿ tuca'a sa 'caī sa ní caⁿ'a sa: Jesús, Daiya David, nnéé ya'āī 'iinú nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nééné 'yaaⁿ yā yaa'vi neeⁿ yā saⁿ'ā miiⁿ chí cunēē 'díiiⁿ sa cheendí sa, naati saⁿ'ā miiⁿ ní n'gaī yiicú cá sá: N'diī Daiya David, nnéé ya'āī 'iinu nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tuu'mi ní Jesús cheendii yā ní caⁿ'a yā: Yaa'vi nī saⁿ'ā chi cuchii sa 'muuⁿ. Ní cheⁿ'é yā ní chii yā saⁿ'ā chi ngueenááⁿ miiⁿ: Canéé diitu di ní cáániīcū di ndúcueeⁿ di ti Jesús n'gaí yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tuu'mi ní sn'dáa sa cotón yeⁿ'ē sa ní nadacueeⁿ sa ní chéⁿ'é sa ndaā sa nanááⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tuu'mi ní Jesús ntiinguunéeⁿ yā saⁿ'ā: ¿Dɛ'ɛ̄ neⁿ'é di chi diíⁿ ndúúcū dii? Sáⁿ'ā chi ngueenááⁿ miiⁿ ní caⁿ'a sa: N'diī Maestro diíⁿ nī chi snaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús caⁿ'a yā: Cunaⁿ'ā di. 'Āā inaaⁿ di, ti s'téénu di. Hora 'cūū nūuⁿ chi ngueenááⁿ miiⁿ ní snaaⁿ sa ní cueⁿ'e sá ndúúcū Jesús miiⁿ na yúúní. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Taachí Jesús ndúúcū discípulos ndaa yā niiⁿnuúⁿ na yáāⁿ Jerusalén, ndaa yā na yáāⁿ Betfagé, ndúúcū yáāⁿ Betania, niiⁿnuúⁿ na yiīcū chi nguuvi Olivos. Ní Jesús dichó'o yā na 'uūvī discípulos yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ní caⁿ'a yā: Cuéⁿ'e nī na yáāⁿ 'lííⁿ chi canéé niiⁿnuúⁿ ní taachí ndaa nī miiⁿ ndaaca nī 'áámá burro n'dɛɛ̄chiīchí tī. Burro miiⁿ ní mar 'áámá 'iiⁿ'yāⁿ 'āā cuɛ́ɛ́ cunduú yā 'iiti. N'daatí nī 'iiti ní candɛ́ɛ nī 'iiti 'múúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ndúúti chi 'áámá 'iiⁿ'yāⁿ tíínguuneeⁿ yā ndís'tiī: ¿Dɛ'ɛ̄ cúúví chí 'tíícā idiíⁿ nī? Caaⁿ'maⁿ nī cuuvi nī 'iiⁿ'yāⁿ tí Señor yeⁿ'e yú neⁿ'e yā 'iiti miiⁿ. Ní caama nadicho'ó yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","'Iiⁿ'yāⁿ s'eeⁿ ní 'tíícā cheⁿ'e yā, ní ndaāca yā burro miiⁿ n'dɛ́ɛ́chiīchí tī na cyúúní niiⁿnuúⁿ cheendiva'āī. Ní n'daātí yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","N'dúúví 'iiⁿ'yāⁿ chi snée yā miiⁿ ní caⁿ'a yā chii yā discípulos: ¿Dɛ'ɛ̄ idiíⁿ nī? ¿Dɛ'ɛ̄ cúúví chí in'daatí nī burro? ");
INSERT INTO cuxNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tuu'mi ní discípulos ní nan'guɛɛcútaⁿ'a yā tan'dúúcā chi Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ. Ní 'cuuⁿ yā chi discípulos cueⁿ'e yā ndúúcū burro miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tuu'mi ní cueⁿ'e yā ndaá yā ndúúcū burro miiⁿ nanááⁿ Jesús miiⁿ. Ní sn'duú yā cotón yeⁿ'e yā vmnááⁿ yeⁿ'ē burro miiⁿ ní Jesús canduú yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Taachí 'āā cueⁿ'e yā cuaaⁿ cyúúní miiⁿ, nééné 'yaaⁿ 'iiⁿ'yāⁿ n'doó yā cotón yeⁿ'e yā cuaaⁿ cyúúní miiⁿ. Taná'a yā ch'iicá yā dúuⁿnɛ̄ yáⁿ'á ní chintaaví yā cuaaⁿ cyúúní. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nééné 'yaaⁿ ca yā chí cueⁿ'e yā cuááⁿ vmnaaⁿ miiⁿ yeⁿ'e Jesús ndúúcū 'yaaⁿ n'daí yā chí cuchii yā cuaaⁿ daami yā 'caí yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Ndyuūs. Ndyuūs di'viicú yā 'iiⁿ'yāⁿ chi cuchii yā ndúúcū chi dúúchí Señor miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dɛ'ɛ̄ chúúcā n'dai naachi ngaⁿ'a ntiiⁿnyuⁿ Ndyuūs. Cúchiī tiempo maaⁿ chí tan'dúúcā yeⁿ'ē chiida yú David ngaⁿ'a ntiiⁿnyúⁿ yā ndii cuááⁿ vmnaaⁿ. Hosanna. Nduudu miiⁿ ní nduudu Israel chi neⁿ'e caaⁿ'maⁿ na nduudu yeⁿ'e yú, chi ch'ɛɛtɛ n'dai Ndyuūs chí canéé na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","'Tíícā sndaā Jesús na yáāⁿ Jerusalén. Ní ndaá yā na yaacū templo yeⁿ'ē yáāⁿ Jerusalén miiⁿ. Ch'íínu yā tanducuéⁿ'ē dendu'ū nuuⁿmáⁿ cuaaⁿ 'diituú yā. Cueⁿ'e ntúuⁿ yā na yáāⁿ Betania ndúúcū ndu'ū ndiichuuví discípulos caati 'āā chi chiiⁿnū. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chidɛɛvɛ táámá nguuvi miiⁿ, taachí Jesús ndúúcū discípulos yeⁿ'é yā can'daa yā na yaāⁿ Betania, Jesús miiⁿ chí cuiicu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ní n'diichi yaⁿ'áí yā 'áámá yáⁿ'á yeⁿ'e n'guíídīi yaaⁿ nguuvi chi vɛ́ɛ́ tá'āa. Ní cueⁿ'é yā n'diichi yā chí 'áá snéé n'gui'i yeⁿ'ē. N'diichí yā chi nguɛ́ɛ́ ndaācā n'gui'i yeⁿ'ē ti ta'á nūuⁿ, ti nguɛ́ɛ́ tiempo yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā yáⁿ'á mííⁿ, 'túúcā: Dii yáⁿ'á, mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ché'e yā n'gui'i yeⁿ'ē di, tanducuéⁿ'ē tiempo. Discípulos yeⁿ'e yā ch'iindiveéⁿ yā tanducuéⁿ'ē chi caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Cuayiivi mííⁿ 'iiⁿ'yāⁿ s'eeⁿ ndaá yā na yáāⁿ Jerusalén miiⁿ. Taachí Jesús ndaá yā na yáacū templo miiⁿ, tucá'a yā tun'dáa yā 'iiⁿ'yāⁿ na yaācū miiⁿ, 'iiⁿ'yāⁿ chi in'diicui yā ndúúcū 'iiⁿ'yāⁿ chi ngai yā. Ch'ɛɛcundáa yā mesas yeⁿ'e 'iiⁿ'yāⁿ chi n̄'dáaⁿ yā tuūmī. Ní ch'ɛɛcundáa yā sillas yeⁿ'e 'iiⁿ'yāⁿ chí in'diicui yā palomas. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ní diíⁿ yā chí 'āā ntɛ́ɛ́ candɛ́ɛ 'iiⁿ'yāⁿ na yaācū miiⁿ mar 'áámá cosa. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ní chi'cuéeⁿ yā 'iiⁿ'yāⁿ ní caⁿ'a yā: Naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs ní 'túúcā ngaⁿ'ā: Va'ai yeⁿ'é canéé chí duuchi va'ai naachi caaⁿ'maⁿngua'á 'iiⁿ'yāⁿ yeⁿ'ē nducuéⁿ'ē nación. Naati ndís'tiī ní diíⁿ nī chí yiivɛ yáává yeⁿ'e 'iiⁿ'yāⁿ chí diduucu. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chiiduú n'gɛɛtɛ chí ngaⁿ'a ntiiⁿnyuⁿ ndúúcū maestros yeⁿ'e ley ch'iindiveéⁿ yā chuū, ní tucá'a yā n'nuuⁿ yiinú yā taacā chi 'caaⁿ'nuⁿ yā Jesús, naati 'va'á yā 'iiⁿ'yāⁿ. Ní nducyaaca 'iiⁿ'yāⁿ ngeⁿ'e yiinú yā yeⁿ'ē chi ngi'cueeⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Taachí chi 'da'a, Jesús miiⁿ can'dáa yā na yáāⁿ Jerusalén miiⁿ ní cueⁿ'é yā táámá yáāⁿ 'lííⁿ chi niiⁿnuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chidɛɛvɛ táámá nguuvi, ní Jesús ndúúcū discípulos cho'ó yā na yúúní ní n'diichí yā 'áámá yáⁿ'á n'guíídii yaaⁿ nguuvi chí 'āā ntí'i ndii díí'yú yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tuu'mi ní Pedro miiⁿ ní nn'gaacu sa chi 'āā chó'ōo ní caⁿ'a sa chii sa Jesús miiⁿ: N'dii Maestro, cuin'diichí nī. N'guíídīi chi nguɛ́ɛ́ n'daācā caⁿ'a nī yeⁿ'ē 'āā ntí'i. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús miiⁿ nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: Ndís'tiī, cuuvi cūnee chi vɛ́ɛ́ confianza yeⁿ'e nī ndúúcū Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi caaⁿ'máⁿ yā cuuvi yā yiīcū 'cúū 'tíícā: Dii yiīcū, cuvíi di 'muuⁿ ní cundaā di nguaaⁿ nuūⁿnīⁿ'yáⁿ'ā. Ní nduuti chi nguɛ́ɛ́ 'uūvī vaanicádiīnūuⁿ yeⁿ'e yā ní i'téénu yā chi chííⁿ chi ngaⁿ'á yā chí cuuví cuaacu, tuu'mi ní cuuvi 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chííⁿ chí maaⁿ ngaⁿ'á ngií ndís'tiī: Tanducuéⁿ'ē chi ndís'tiī ngiicá nī Ndyuūs taachi ngaⁿ'angua'á nī, nduuti chi cu'téénu nī chí ndaācā yeⁿ'e nī, tuu'mi ní tanducuéⁿ'ē ní ndaāca nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ní taachí ngaⁿ'angua'á nī, nduuti chi 'áámá 'iiⁿ'yāⁿ idinuuⁿndí yā contra yeⁿ'é nī, nadach'ɛɛcú nī yeⁿ'e yā, 'tiicá ntúūⁿ Chiida yú chi canée yā na va'ai chɛɛti nguuvi nádich'ɛɛcú yā nuuⁿndi yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ndúúti ndís'tiī nguɛ́ɛ́ nadich'ɛɛcú nī nuuⁿndi yeⁿ'é 'iiⁿ'yāⁿ, 'tiicá ntúūⁿ Chiida yú chi canée yā na va'ai chɛɛti nguuvi nguɛ́ɛ́ nadich'ɛɛcú yā nuuⁿndi yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tuu'mi ní Jesús ndúúcū discípulos nndaa yā na yáāⁿ Jerusalén. Taachí Jesús chiicá yā na yaācū templo, chiiduú n'gɛɛtɛ ndúúcū maestros chi ngi'cuéeⁿ ley ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'e yaācū miiⁿ chindaá yā n'diichí yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ní ntiinguuneeⁿ yā Jesús: ¿Du'ú 'iiⁿntyeⁿ'ē diīⁿ nduucú nī chuū? O ¿du'ū tee poder dii chí idiiⁿ nī chuū? ");
INSERT INTO cuxNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús nan'guɛɛcútaⁿ'a yā: 'Úú ntúūⁿ ní tiinguuneéⁿ ndís'tiī, ní ndúúti chi cuuví n'guɛɛcútaⁿ'a nī yeⁿ'é, tuu'mi ní cuuví ndís'tiī du'ú 'iiⁿntyeⁿ'ē tee yā poder 'úú chi idiíⁿ dendú'u 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Chí ngɛɛ̄dínuuⁿnīⁿ Juan miiⁿ ¿tií chiīcā chiī? ¿'Áá yeⁿ'e sáⁿ'ā iⁿ'yeeⁿdí 'cūū o yeⁿ'ē va'ai chɛɛti nguuvi? Nan'guɛɛcútaⁿ'a nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tuu'mi ní tucá'a yā caⁿ'a yā nguááⁿ maáⁿ yā ní caⁿ'a yā chii yā vi'ī: ¿Taacá caaⁿ'maⁿ yú? Ndúúti chí caaⁿ'maⁿ yú chí yeⁿ'ē nanguuvi, 'iiⁿ'yāⁿ miiⁿ ní nan'guɛɛcútaⁿ'a yā yeⁿ'ē yú 'tíícā: ¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ i'téénu nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ní ndúúti chi caaⁿ'maⁿ yú, chí yeⁿ'ē saⁿ'ā iⁿ'yeeⁿdí 'cūū tuu'mi ní 'va'a yú 'iiⁿ'yāⁿ s'eeⁿ caati nducyáácá 'iiⁿ'yāⁿ deenu yā chi Juan chi chɛɛdínuūⁿnīⁿ miiⁿ ní 'áámá profeta chí cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ní nan'guɛɛcútaⁿ'a yā yeⁿ'e Jesús miiⁿ ní caⁿ'a yā: Nguɛ́ɛ́ cuuví nī n'diī. 'Tíícā caⁿ'a yā chiī yā Jesús: Nguɛ́ɛ́ deenú 'nū. Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Tiicá ntúūⁿ 'úú nguɛ́ɛ́ cuuví ndís'tiī du'ú 'iiⁿntyéⁿ'ē idiiⁿ ndúúcū chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús miiⁿ tucá'a yā caⁿ'a yā 'iiⁿ'yāⁿ s'eeⁿ ndúúcū ejemplos chi 'tɛ́ɛ́ nguɛ́ɛ́ dáámá. Ní caⁿ'a yā: Vɛ́ɛ́ 'áámá 'iiⁿ'yāⁿ chí chiīnu yā díí'yú uvas na yáⁿ'āa yeⁿ'é yā. Ní din'dái yā 'áámá cheēⁿ yeⁿ'ē yáⁿ'āa 'lííⁿ. Ní din'dái yā 'áámá tanque naachí cuuvi tun'dáa yā nuūⁿnīⁿ yeⁿ'e uvas miiⁿ. Ní din'dái yā 'áámá torre nguaaⁿ yáⁿ'āa uvas naachi mozos yeⁿ'é yā 'cuɛɛtinée sa diiⁿ sa cuidado n'gui'i uvas miiⁿ. Cuayiivi ní ca'a ya yáⁿ'āa miiⁿ mozos chi diíⁿ yā ntiiⁿnyuⁿ yeⁿ'e yáⁿ'āa, ní cueⁿ'e yáⁿ'áí yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Taachí ndaā tiempo yeⁿ'e cosecha yeⁿ'e uvas miiⁿ, dueño miiⁿ dichó'o yā 'aama mozo yeⁿ'é yā nanááⁿ mozos chi idiíⁿ sa ntiiⁿnyu yeⁿ'e yáⁿ'āa yeⁿ'é yā chi nguai nca'a sa n'gui'i uvas parte yeⁿ'e cosecha chí ítuneeⁿ dueño miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mozo miiⁿ ní cueⁿ'e sa, naati mozos ní sta'a sa mozo miiⁿ ní ch'eⁿ'e sa ní nadacho'o sa mozo miiⁿ ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ ca'a sa mozo. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tuu'mi ní dueño yeⁿ'ē yáⁿ'āa miiⁿ nguɛɛ̄cunée yā dichó'o yā taama mozo. Mozos ní chiī tuu sa mozo miiⁿ ní 'nuūca'ai sa tiīⁿ sa ní chii taaⁿ sa saⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dueño yeⁿ'e yáⁿ'āa miiⁿ dichó'o yā táámá mozo. Mozo miiⁿ, mozos chi diiⁿ ntiiⁿnyuⁿ na yáⁿ'āa miiⁿ ch'iiⁿ'nuⁿ sa. Cuayiivi miiⁿ ní 'yaaⁿ n'dáí mozos dichó'o yā. Mozos ní náⁿ'a mozos miiⁿ ní ch'eⁿ'e sa saⁿ'ā, tanáⁿ'ā sa ní mozos miiⁿ ch'iiⁿ'nuⁿ sa saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Cánéé cá daiya yā chí neⁿ'e taavi yā. Cuayiivi mííⁿ ní dueño miiⁿ dichó'o yā daiya yā ní nadicadíínuuⁿ yā 'tíícā. Saⁿ'ā daiyá ní diiⁿ sa honrar daiyá. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Naati mozos chi idiíⁿ sa ntííⁿnyuⁿ na yáⁿ'āa yeⁿ'é yā caⁿ'a sa nguaaⁿ maaⁿ sa: Sáⁿ'a 'cūū chi canee chi cuuví yeⁿ'ē sa yá'āa herencia 'cūū. 'Caāⁿ'nuⁿ yú saⁿ'ā ní cúúví yeⁿ'ē yú yáⁿ'āa ndúúcū chi vɛ́ɛ́ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'Tíícā ní sta'a sa saⁿ'ā ní ch'iiⁿ'nuⁿ sa saⁿ'ā ní tun'daa sa cuerpo yeⁿ'ē sa 'áámá lado yeⁿ'e yáⁿ'āa miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tuu'mi ní Jesús ntiinguuneeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ ra diīiⁿ dueño yeⁿ'ē yáⁿ'āa 'cúū? Ndaá yā ní 'caāⁿ'núⁿ yā mozos chi idiiⁿ ntiiⁿnyuⁿ, ní ca'á yā yáⁿ'āa tánaⁿ'a 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿'Áá nguɛ́ɛ́ n'geeⁿ ndís'tiī naachi canéé nguūⁿ na libro yeⁿ'e Ndyuūs? Ngaⁿ'a 'túúcā: Tuūu chi 'iiⁿ'yāⁿ din'dái yā va'ai miiⁿ ní sta'á yā ní ch'ɛɛcú yā 'áámá lado ti nguɛ́ɛ́ neⁿ'e yā. Tuūu 'cúū chí tuūu ch'ɛɛtɛ ní canéé tuūu ch'ɛɛtɛ yeⁿ'ē na esquina yeⁿ'e va'ai. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chuū ní Señor Ndyuūs diíⁿ yā, chuū ní 'áámá cosa chí ngeⁿ'e yiinu yú taachi inaaⁿ yú yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ nadacádíínuuⁿ yā chi cuta'á yā Jesús miiⁿ ní diíⁿ yā preso 'iiⁿ'yāⁿ ti déénu yā chi Jesús miiⁿ caⁿ'a yā ejemplo 'cūū chi 'tɛ́ɛ́ nguɛ́ɛ́ dáámá chi yeⁿ'e yā. Naati 'va'á yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿya, ní s'néeⁿ yā Jesús ní cueⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cuayiivi miiⁿ 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū dicho'ó yā 'iiⁿ'yāⁿ yeⁿ'e Herodes ndúúcū n'duuvi 'iiⁿ'yāⁿ fariseos nanááⁿ Jesús miiⁿ. Ní neⁿ'é yā chi Jesús castáⁿ'a yā nduudu yeⁿ'e yā ní caaⁿ'máⁿ yā 'áámá nduudu yaadi. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","'Iiⁿ'yāⁿ s'eeⁿ ndaá yā nanááⁿ Jesús miiⁿ, ní caⁿ'a yā: N'diī Maestro, déénu 'nū chí n'dii ní ngaⁿ'a nī nduudu cuaacu ní nguɛ́ɛ́ diíⁿ nī cuenta yeⁿ'e chí ngaⁿ'a 'iiⁿ'yāⁿ yeⁿ'ē. Ní nguɛ́ɛ́ ndɛɛ́ nī cuidado táácā idinááⁿ 'iiⁿ'yāⁿ iⁿ'yeeⁿdí 'cūū naati ngi'cueeⁿ nī ndúúcū nduudu cuaacu yúúní yeⁿ'é Ndyuūs. ¿'Áá canéé chí nadíí'vɛ 'nū na emperador César tuūmī yeⁿ'e recaudación yeⁿ'e yáⁿ'āa o nguɛ́ɛ́? ");
INSERT INTO cuxNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús miiⁿ ní déénu yā chi nguɛ́ɛ́ n'daācā chí 'iiⁿ'yāⁿ s'eeⁿ diíⁿ yā. Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chi neⁿ'é nī chí castaⁿ'á nī nduudu yeⁿ'é? Candɛ́ɛ nī 'áámá tuūmī, chi snaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Iiⁿ'yāⁿ ndɛɛ́ yā tuūmī. Ní Jesús miiⁿ n'diichí yā ní tiinguuneeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dú'u naaⁿ chuū? ¿Du'ū chí duuchi canéé nguūⁿ? 'Iiⁿ'yāⁿ s'eeⁿ ní n'guɛɛcútaⁿ'a yā: Nááⁿ emperador César cānee. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tuu'mi Jesús miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Nca'á nī tuūmī yeⁿ'e recaudación o impuestos chi yeⁿ'e emperador César miiⁿ chííⁿ chí yeⁿ'ē sa, ní nca'a nī Ndyuūs chí yeⁿ'é yā. 'Iiⁿ'yāⁿ s'eeⁿ ní cueⁿ'e yiinú yā yeⁿ'ē chí n'guɛɛcútaⁿ'a Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tuu'mi ní ndaā n'duuvi 'iiⁿ'yāⁿ saduceos nanááⁿ Jesús. 'Iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ s'teenu yā chí tináⁿ'ā ní nduuchi yā. Ní ntiinguuneeⁿ yā Jesús chuū: ");
INSERT INTO cuxNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","N'dií Maestro, Moisés miiⁿ ní s'neeⁿ nguuⁿ yā yeⁿ'e s'uuúⁿ tí chuū: Nduuti chi 'áámá saⁿ'ā 'cuūvī sa ní cu'neeⁿ sa n'daataá yeⁿ'ē sa ní nguɛ́ɛ́ daiya sa, tuu'mi ní 'díínu sā cuuví 'caandavaacu sá ndúúcū n'daataá miiⁿ. Ní saⁿ'ā miiⁿ ní 'cuūndī daiya sa lado yeⁿ'ē 'díínū tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Áámá saⁿ'ā vɛ́ɛ́ ndɛɛ̄chɛ̄ 'díínū sa ndúúcū sa. Saⁿ'ā miiⁿ chí vmnááⁿ vmnaaⁿ ch'iidivaacu sá ní ch'iī sa ní nguɛ́ɛ́ ch'iīndī daiya sa ndúúcú n'daataá yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Saⁿ'ā ndii chííⁿ ndii 'úúví mííⁿ ch'iindivaacu sa ndúúcū n'daataá yeⁿ'ē tináⁿ'ā ní saⁿ'ā miiⁿ ch'iī ntúuⁿ sa ní nguɛ́ɛ́ ch'iindi daiya sá ndúúcū n'daata miiⁿ. 'Tiicá ntúūⁿ ch'ɛɛnu saⁿ'ā ndii chííⁿ ndii 'íínú. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ndu'ū ndɛɛ̄chɛ sá ch'iindivaacu sá ndúúcu tá ní mar 'áámá sá nguɛ́ɛ́ s'neeⁿ sa daiya sa ndúúcu tá. Cuayiivi ní ch'iī ntúūⁿ n'daataá miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tuu'mi ní taachí nduuchí yā nguaaⁿ tináⁿ'ā, ¿chɛɛ́ yā chí n'daataá yeⁿ'é yā taⁿ'ā miiⁿ, caati ndu'u ndɛɛ̄chɛ yā ch'iindivaacú yā ndúúcu tá? ");
INSERT INTO cuxNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Tuu'mi ní Jesús mííⁿ nan'guɛɛcútaⁿ'a yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī ní nguɛ́ɛ́ déénu nī chí ngaⁿ'a nī, ti nguɛ́ɛ́ n'diichí nī naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs yeⁿ'é chuū, ndíí nguɛ́ɛ́ ndúú n'diichi rá nī poder yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Taachí 'iiⁿ'yāⁿ nanduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā, ndíí nguɛ́ɛ́ ndúú n'daataá rá, ndíí nguɛ́ɛ́ ndúú saⁿ'ā rá 'caandavaacu sa. 'Iiⁿ'yāⁿ s'eeⁿ 'cuɛɛtinée yā tan'dúúcā ángeles yeⁿ'ē va'ai chɛɛti nguuvi chi nguɛ́ɛ́ ch'iindivaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chuū chi yeⁿ'ē tináⁿ'ā miiⁿ chí nanduuchi yā nguaaⁿ tináⁿ'ā, ¿'áá nguɛ́ɛ́ n'geēⁿ ndís'tiī na libro yeⁿ'é Ndyuūs chí dinguuⁿ Moisés tan'dúúcā Ndyuūs yaa'ví yā Moisés, ndíí taachi canee sa nanááⁿ yáⁿ'á 'lííⁿ chí ngiichi? Ní 'túúca caⁿ'a Ndyuūs chii yā Moisés miiⁿ: 'Úú ní Ndyuūs yeⁿ'e Abraham, ndúúcū Isaac, ndúúcū Jacob. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ndyuūs miiⁿ nguɛ́ɛ́ Ndyuūs yeⁿ'ē tináⁿ'ā ti yeⁿ'e 'iiⁿ'yāⁿ chi snduuchi. Chííⁿ chí ndís'tiī nguɛ́ɛ́ déénu nī chi ngaⁿ'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","'Áámá maestro yeⁿ'e ley chí ch'iindiveéⁿ yā chí ndeē 'iiⁿ'yāⁿ saduceos s'eeⁿ, déénu yā chi Jesús miiⁿ nan'guɛɛcútaⁿ'a n'daaca yā. 'Iiⁿ'yāⁿ miiⁿ ní ntiinguuneeⁿ yā Jesús: ¿Chɛɛ́ mandamiento chi canee nguūⁿ chí ch'ɛɛtɛ n'dai ca? ");
INSERT INTO cuxNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús nan'guɛɛcútaⁿ'a yā: Mandamiento vmnááⁿ vmnaaⁿ miiⁿ ní chuū: 'Caandiveéⁿ nī, ndís'tiī 'iiⁿ'yāⁿ yeⁿ'e Israel miiⁿ, Señor Ndyuūs yeⁿ'ē yú ní 'áámá n'dyáⁿ'ā Señor miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Canéé chí dineⁿ'é nī Señor Ndyuūs yeⁿ'é nī ndúúcū nuuⁿmaⁿ staava yeⁿ'é nī, ndúúcū nuuⁿmaⁿ alma yeⁿ'e nī, ndúúcū nuuⁿmaⁿ vaanicadíínūuⁿ yeⁿ'e nī, ndúúcū nducuéⁿ'ē fuerzas yeⁿ'e nī. Chuū chi mandamiento chi vmnááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mandamiento chí canéé nguūⁿ chi ndii chííⁿ ndii 'úúví mííⁿ tan'dúúcā chi vmnááⁿ vmnaaⁿ 'āā 'tiicá ntúūⁿ: Dinéⁿ'e di 'iiⁿ'yāⁿ na niiⁿnuúⁿ vaacú di tan'dúúcā chi neⁿ'e dí maāⁿ di. Nguɛ́ɛ́ 'áámá mandamiento chí canéé nguūⁿ chí ch'ɛɛtɛ ca nguɛ́ɛ́ ti mandamientos s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tuu'mi ní maestro yeⁿ'e ley caⁿ'a yā chii yā Jesús miiⁿ: N'diī Maestro, cuáácú ngaⁿ'a nī. Cuaacu nííⁿnyúⁿ chí ngaⁿ'a nī chi vɛɛ 'aama n'dyáⁿ'ā Ndyuūs. Nguɛ́ɛ́ táámá 'āā tanduu rá 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Níícú 'iiⁿ'yāⁿ canéé chi dinéⁿ'e yā Ndyuūs ndúúcū nuuⁿmaⁿ staava yeⁿ'e yā, ndúúcū nuuⁿmaⁿ vaanicadíínūuⁿ yeⁿ'e yā, ndúúcū nuuⁿmaⁿ alma yeⁿ'e yā, ndúúcū tanducuéⁿ'ē fuerzas yeⁿ'e yā. Ní dineⁿ'e yā 'iiⁿ'yāⁿ na niiⁿnuúⁿ vaacú yā tan'dúúcā chi neⁿ'é yā maáⁿ yā. Chuū chi n'daācā ca nguɛ́ɛ́ ti n'giiⁿ'núⁿ 'iiti chí nga'a yā 'iiti lado yeⁿ'e ofrenda yeⁿ'é Ndyuūs ní yeⁿ'é tanducuéⁿ'ē ofrenda chí ngicyáⁿ'ā nátai. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tuu'mi ní taachi ch'iindiveeⁿ Jesús tan'dúúcā chi n'guɛɛcutaⁿ'a cuaacu sa chí caⁿ'a sa, Jesús caⁿ'a yā chiī yā saⁿ'ā miiⁿ: Nguɛ́ɛ́ yaⁿ'ai canee di yeⁿ'ē naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā. Cuayiivi miiⁿ ní 'iiⁿ'yāⁿ 'āā ntɛɛ candii cá yā ntiinguuneeⁿ ca yā Jesús mar 'áámá. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús ngi'cueeⁿ yā chɛɛti yaācū templo ní ngaⁿ'a yā: ¿Dɛ'ɛ̄ cúúví chí maestros yeⁿ'e ley ngaⁿ'á yā chi Cristo miiⁿ ní daiya David? ");
INSERT INTO cuxNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Caati maaⁿ David miiⁿ caⁿ'a sá taachi yaa'vi Espíritu N'dai yeⁿ'é Ndyuūs chuū chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs: Señor miiⁿ caⁿ'a yā chiī yā Señor yeⁿ'é: 'Cuundi dí lado ta cuaācú chi lado yeⁿ'e honor, ndíí taachi 'úú cu'neéⁿ 'iiⁿ'yāⁿ chí contra yeⁿ'ē di ndiī cuaaⁿ ndiiya maaⁿ ca'ā di tan'dúúcā chi 'aama banco 'lííⁿ, 'tiicá yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David miiⁿ ngaⁿ'a sa chuū yeⁿ'e Señor yeⁿ'é yā. Maaⁿ ní ¿táácā cuuví chiī chí Cristo miiⁿ ní daiya David miiⁿ? Nééné n'deēe 'iiⁿ'yāⁿ ch'iindiveéⁿ yā yeⁿ'e Jesús ndúúcū vaadī yeenú. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús ngaⁿ'a yā chuū taachi ngi'cueeⁿ yā: Cundɛ́ɛ di cuidado yeⁿ'e maestros yeⁿ'e ley. 'Iiⁿ'yāⁿ s'eeⁿ ní n'gɛɛ̄tinéé yiinú yā chí n'geenūu catecai yā. Ní taachi chiicá yā cuaaⁿ cyúúní neⁿ'e yā chí 'iiⁿ'yāⁿ diíⁿ yā saludar 'yā ndúúcū respeto n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ní neⁿ'é yā sillas vmnááⁿ vmnaaⁿ yeⁿ'e honor taachí 'cuundí yā na yaācū sinagogas ndúúcū lugar chi ch'ɛɛtɛ taachi cheⁿ'e yā naachi vɛ́ɛ́ 'viicu chi che'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ní ndivíi yā va'ai yeⁿ'ē n'daataá nguá'āa. Ní 'íícú cuunuuⁿ n'dé'ei yā chí idiíⁿ yā miiⁿ nduucú nééné n'deēe ngaⁿ'angua'á yā. 'Iiⁿ'yāⁿ s'eeⁿ ní ch'ɛɛtɛ ca castigo yeⁿ'é yā nguuvi yeⁿ'e juicio. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","'Áámá vmnéⁿ'ēe Jesús vɛ́ɛ yā na yáacū templo niiⁿnuúⁿ na cajas naachí 'iiⁿ'yāⁿ n'gíi yā ofrendas. N'gíínu yā tan'dúúcā chi diíⁿ 'iiⁿ'yāⁿ táácā n'gíi yā tuumī lado yeⁿ'e ofrenda na cajas. N'diichí yā chi 'yaaⁿ n'dáí 'iiⁿ'yāⁿ 'cuiica neené n'deēe tuūmī ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tuu'mi ní ndaā 'áámá n'daataá nguá'āa chí neene ndaachíí canee tá. Táⁿ'ā miiⁿ ní s'nuūⁿ tá na caja miiⁿ na 'uūvī centavos chi cobre. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tuu'mi ní Jesús yaa'vi yā discípulos yeⁿ'e yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chí n'daataá nguá'āa 'cúū ch'ɛɛtɛ ca nga'ā tá, nguɛ́ɛ́ ti tanáⁿ'a yā chí s'nuúⁿ yā tuūmī na cajas. ");
INSERT INTO cuxNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tí 'iiⁿ'yāⁿ s'eeⁿ ní nga'a yā yeⁿ'e chí ngaava yeⁿ'e yā; naati n'daataá mííⁿ ní neené ndaachíī canee tá ní ca'ā tá tanducuéⁿ'ē chí yeⁿ'ē tá chi che'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Taachí Jesús miiⁿ nan'dáa yā yaācū templo miiⁿ 'áámá discípulo yeⁿ'e yā ní caⁿ'a yā chii yā Jesús: N'dií Maestro, n'diichí nī dɛ'ɛ̄ chúúcā n'gɛɛtɛ tuūu s'eeⁿ ní dɛ'ɛ chúúcā n'gɛɛtɛ va'ai s'eeⁿ yeⁿ'e yaācū templo. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús nán'guɛɛcútaⁿ'a yā: ¿'Áá inaaⁿ nī va'ai templo? 'Muuⁿ ní nguɛ́ɛ́ cunee mar 'áámá tuūu cuaaⁿ vmnááⁿ yeⁿ'e vi'ī ti tanducuéⁿ'ē ní cundɛɛvɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tuu'mi ní cheⁿ'é yā 'áámá yiīcū chi nguuvi Olivos, chi canéé niiⁿnuúⁿ na yaācū templo miiⁿ. Ní taachi Jesús vɛɛ́ yā miiⁿ, Pedro ndúúcū Jacobo, ndúúcū Juan, ndúúcū Andrés ndaa yā nanáaⁿ yā chi caⁿ'a n'de'ei yā 'áámá nduudu ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ní caⁿ'a yā: N'diī Señor, néⁿ'e 'nū chi cuuví nī nús'uu ¿tií cuaⁿ'ā cuuví chuū? ¿Dɛ'ɛ̄ senal 'cuuⁿ'míⁿ nī nús'uu yeⁿ'e tiempo chi cuuvi tanducuéⁿ'ē 'túúcā? ");
INSERT INTO cuxNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús nan'guɛɛcútaⁿ'a yā: Cundɛ́ɛ nī cuidado chí mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cannche'éí yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ti nééné 'yááⁿ 'iiⁿ'yāⁿ chii yā ndúúcū chi duuchí ní cannche'éí yā 'iiⁿ'yāⁿ ní caaⁿ'máⁿ yā: 'Úú Cristo 'úú. 'Iiⁿ'yāⁿ s'eeⁿ ní cannche'éí yā 'yaaⁿ n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Taachi ndís'tiī 'caandiveéⁿ nī caandaá ní 'iiⁿ'yāⁿ 'va'a yā chí chiī caandaá nguɛ́ɛ́ idii'yá nī cuuvi ti 'tíícā canéé chi cuuvi. Naati chiiⁿ ní 'āā 'cuɛ́ɛ́ tiempo chi ntuuvií íⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ti 'áámá nación ní 'cuuⁿ'maⁿ ndúúcū táámá nación ni 'áámá gobierno ní 'cuuⁿ'maⁿ yā ndúúcū táámá gobierno. Ní nééné n'deee cuaaⁿ nuⁿ'u yáⁿ'āa. Ní ndaā vaadī 'cuiicu ndúúcū dendu'ū chi di'vaachií. Taachí cuuví dendu'ū chi 'túúcā ní chiiⁿ ní cáámá cuunngá'á vaadī ya'ai. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Diíⁿ nī cuidado maáⁿ nī ndís'tiī ti 'iiⁿ'yāⁿ nca'a yā ndís'tiī tá'āa 'iiⁿntyéⁿ'ē. Tuu'mi ní 'cueⁿ'é yā ndís'tiī na yaācū sinagogas. Ndís'tiī ni canee chi caⁿ'á nī nanááⁿ 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yā ndúúcū reyes cáávā ntiiⁿnyuⁿ yeⁿ'é. Ní 'íícú cuuvi caaⁿ'máⁿ nī yeⁿ'é ní 'caandiveéⁿ yā nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Taachí 'āā cuɛ́ɛ́ ndaa chí 'cuiinu iⁿ'yeēⁿdī, nduudu cuaacu 'cūū canéé chi caaⁿ'maⁿ nanááⁿ nducyaaca 'iiⁿ'yāⁿ yeⁿ'e naciones yeⁿ'e núúⁿmáⁿ íⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Taachí candɛ́ɛ yā ndís'tiī chi nca'a yā ndís'tiī vmnááⁿ 'iiⁿntyéⁿ'ē, nguɛ́ɛ́ nadicádíínuuⁿ nī yeⁿ'ē chi caaⁿ'maⁿ nī. Nguɛ́ɛ́ diiⁿ núúⁿ yiiⁿnuⁿ nī yeⁿ'ē. Caaⁿ'maⁿ nī tan'dúúcā Espíritu N'dai yeⁿ'é Ndyuūs caaⁿ'maⁿ cuuvi ndís'tiī hora miiⁿ; ti nguɛ́ɛ́ ndís'tiī chi caaⁿ'máⁿ nī ti Espíritu N'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ní yeⁿ'e tiempo miiⁿ nguaaⁿ 'díínu yā nca'a vi'i yā chí 'cááⁿ'núⁿ yā 'iiⁿ'yāⁿ. Ní 'íícú chiidá yā ní ca'a yā daiya yā. Ní daiya yā ní ca'a yā chiidá yā ndúúcū chɛɛcú yā ní 'caaⁿ'núⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nducyáácá 'iiⁿ'yāⁿ nguɛ́ɛ́ cunee yiinú yā chi ndís'tiī diíⁿ nī ntiiⁿnyuⁿ caavā 'úú. Naati 'iiⁿ'yāⁿ chi cuchɛ́ɛ yā ní 'aama canée yā ndúúcū chi i'teenu yā yeⁿ'e Ndyuūs ndíí tiempo chi 'cuūvi yā ní nnguáⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Taachí ndís'tiī 'āā snaaⁿ nī dendu'ū chi 'túúcā chi saⁿ'ā profeta Daniel dinguúⁿ yā na libro yeⁿ'e Ndyuūs tiempo chi chó'ōo tuu'mi ní 'iiⁿ'yāⁿ chi snée yā na yáⁿ'āa Judea canéé chi caⁿ'á yā caanu yā ná yiīcū n'gɛɛtɛ. ('Iiⁿ'yāⁿ chi 'cueēⁿ chuū canéé chi cuuvi deenú yā yeⁿ'e chuū.) ");
INSERT INTO cuxNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nguuvi miiⁿ ní ndúúti chi 'áámá 'iiⁿ'yāⁿ canduú yā tiíⁿ va'āī ní nguɛ́ɛ́ cuuvi núúⁿ nch'eeⁿ yā ní ndaa yā va'ai ní tun'dáa yā dendu'ū yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ní ndúúti chi 'áámá 'iiⁿ'yāⁿ canée yā na campo, ní nguɛ́ɛ́ cuuvi núú ndaa yā va'ai yeⁿ'e yā ní nta'a yā cotón yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dɛ'ɛ chúúcā yaⁿ'ai yeⁿ'e n'daataá chi vɛ́ɛ́ daiya tá chɛɛti tá ndúúcū n'daataá chí ngiicu dacuá'āa yeⁿ'e tá nguuvi chi cáánu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ndís'tiī, caaca nī Ndyuūs chi nguɛ́ɛ́ chó'ōo chuū tiempo chi 'iichɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ti nguuvi miiⁿ ní nééné 'cueenu 'iiⁿ'yāⁿ cuuvi tan'dúúcā chi mar 'áámá vmnéⁿ'ēe 'āā cuɛ́ɛ́ cuuvi 'tíícā ndíí taachí Ndyuūs din'dái yā íⁿ'yeēⁿdī. 'Āā ntɛ́ɛ́ ndúú cuayiivi ra chí snaaⁿ yā dendu'ū chi 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ndúúti chi Señor miiⁿ nguɛ́ɛ́ nadidúú'vi yā tiempo miiⁿ mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ nnguaⁿ'ai yā. Naati n̄diiⁿ nadidúú'vi yā cáávā 'iiⁿ'yāⁿ chi yeⁿ'é yā ti 'iiⁿ'yāⁿ miiⁿ Señor ndɛɛvɛ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tuu'mi ní ndúútī chi 'áámá 'iiⁿ'yāⁿ caaⁿ'maⁿ yā cuuvi yā ndís'tiī: Cuín'dííchí nī, 'íngaā Cristo miiⁿ, o cuín'dííchí nī, miiⁿ canee Cristo miiⁿya, nguɛ́ɛ́ cu'téénu nī 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ti ndaá 'iiⁿ'yāⁿ chi cristos chi falsos yā ndúúcū 'iiⁿ'yāⁿ chi profetas chi falsos yā. Ní diíⁿ yā señales ndúúcū vaadī n'giinu. Ní 'íícú cuuvi cannche'éí yā 'iiⁿ'yāⁿ, ndíí 'iiⁿ'yāⁿ chí Ndyuūs ndɛɛvɛ yā ndúútī chi chuū cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Naati ndís'tiī ní 'cuɛɛtinéé yaaⁿ nī. Ngaⁿ'á ngií ndís'tiī tanducuéⁿ'ē chuū 'nááⁿ chí 'āā cuɛ́ɛ́ ndaa. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Cho'ōo chúū ní nguuvi miiⁿ chi 'cueenu nī cuuvi, 'yáⁿ'āa miiⁿ ní cúúví maāiⁿ ní 'iīyū miiⁿ ní 'āā ntɛ́ɛ́ cuuví dɛɛvɛ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","'Iiⁿnyuⁿ miiⁿ ní cun'dáa yeⁿ'ē nanguuvi ní nducuéⁿ'ē chi vɛ́ɛ́ nanguuvi ní nuⁿ'u. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tuu'mi ní snaaⁿ yā Saⁿ'ā chi Daiya Ndyuūs chí ndaa sa nguaaⁿ meēeⁿ ndúúcū poder yeⁿ'ē sa chí ch'ɛɛtɛ taavi ní ndɛɛvɛ́ n'dai ngíí n'gai maāⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Tuu'mi ní Ndyuūs dicho'ó yā ángeles yeⁿ'e yā chí nadidáámá 'iiⁿ'yāⁿ yeⁿ'é yā chi Ndyuūs ndɛɛvɛ yā yeⁿ'ē núúⁿmáⁿ íⁿ'yeeⁿdī, ndii na yáⁿ'āa nducuéⁿ'ē n'dai yeⁿ'e yáⁿ'āa ndúúcū ndii na nducueⁿ'e nanguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Maaⁿ ní 'cueéⁿ nī yeⁿ'e ejemplo yeⁿ'e n'guíídīi yaaⁿ nguuvi: Taachí inguaaⁿnu duūⁿnɛ̄ n'gaiyáā ní ican'daā tá'āa, 'āā déénu nī chí 'āā cuchiī tiempo yaāáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'Tiicá ntúūⁿ taachi snaaⁿ ndís'tiī chi cuuvi dendú'ū chi 'túúcā, 'āā deenú nī chí 'āā sneeⁿ niiⁿnuⁿ tiempo chi ndaā Saⁿ'ā chi Daiya Ndyuūs. Ní 'āā nééné niiⁿnuúⁿ cánee tiempo 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: 'Iiⁿ'yāⁿ s'eeⁿ chi snée yā maaⁿ 'āā cuɛ́ɛ́ 'cuūví yā neⁿ'e chi 'āā cuɛ́ɛ́ cuuví tanducuéⁿ'ē chuū. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nánguuvi ndúúcū ná yáⁿ'āa 'cūū ní chó'ōo, naati nduudu yeⁿ'é nguɛ́ɛ́ cho'oó. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Naati yeⁿ'ē nguuvi miiⁿ ndúúcū hora miiⁿ nguɛ́ɛ́ vɛ́ɛ́ mar 'áámá 'iiⁿ'yāⁿ chi deenu yeⁿ'ē. Ndíí nguɛ́ɛ́ ndúú ángeles, yeⁿ'e va'ai chɛɛti nguuvi ndíí nguɛ́ɛ́ ndúú Sáⁿ'ā chi Daiya Dendyuūs deenú yā yeⁿ'ē. Dámaāⁿ Chiida yú chi canée yā na va'ai chɛɛti nguuvi deenu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chííⁿ chí ndís'tiī ní 'cuɛɛtinéé yaaⁿ nī. Dicuéénaaⁿ nī ní caaⁿ'maⁿngua'á nī, ti nguɛ́ɛ́ déénu nī tií cuaⁿ'ā ndaa hora miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ejemplo chuū tan'dúúcā 'áámá 'iiⁿ'yāⁿ chí caⁿ'a yā yaⁿ'ai. Taachi 'āā cuɛ́ɛ́ can'dáa yā na vaācu yā, caⁿ'a yā chii yā mozos yeⁿ'é yā chí ca'a yā ntiiⁿnyuⁿ 'áámá 'áámá mozo yeⁿ'ē sa. Ní cuuvi yā saⁿ'ā chí idiiⁿ cuidado yeⁿ'e cheendi va'āī miiⁿ chi cunéé yaaⁿ sa. Ní cueⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Maaⁿ ní ndís'tiī 'cuɛɛtinéé yaáⁿ nī, ti nguɛ́ɛ́ déénu nī tií cuaⁿ'ā ndaa dueño yeⁿ'e va'āī miiⁿ. Nguɛ́ɛ́ déénu nī nduuti chi ndaá yā n'gaaⁿ, o yaaⁿ chɛɛtɛ, o taachí 'cuaī tú'u, o cuaaⁿ na nguɛɛtiyaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'Áá tiī dácanaaⁿ ndaá yā ní nndaāca yā ndís'tiī chí styaadu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chííⁿ chí ngaⁿ'á ngií ndís'tiī, ní ngií nducyaaca 'iiⁿ'yāⁿ: 'Cuɛɛtinéé yaáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ná 'uūvī nguūvī ní cuuvā 'viicu yeⁿ'e pascua chi 'viicu yeⁿ'ē pan chi nguɛ́ɛ́ levadura yeⁿ'ē. Chiiduú n'gɛɛtɛ ndúúcū maestros yeⁿ'e ley 'nuúⁿ yā taacā chi cuuvi cannche'éí yā Jesús ní cuta'á yā 'iiⁿ'yāⁿ ní 'caaⁿ'núⁿ yā 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naati caⁿ'a yā: Nguɛ́ɛ́ diiⁿ yú nguuvi 'viicu tí 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ didáⁿ'a yā ní diíⁿ yā vaadī 'caa'va ndúúcū nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús canee yā na yáāⁿ Betania na vaacu Simón chi canéé sá ndúúcū ca'ai chi nguuvi lepra chi in'duuti cuerpo yeⁿ'ē sa. Taachí Jesús miiⁿ vɛɛ́ yā na mesa, ndaā 'áámá n'daataá nanáaⁿ yā. Táⁿ'ā miiⁿ ní ndɛɛ̄ tá 'áámá frasco yeⁿ'e alabastro ndiituú ndúúcū aceite perfume yeⁿ'e nardo chí ndɛɛvɛ ngeeⁿ ní neené ya'ai chíí'vɛ̄. Ní 'cuūⁿ tá frasco miiⁿ ní ch'eendáa tá aceite miiⁿ na tiīⁿ Señor Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","N'duuvi discípulos chi snée yā miiⁿ nduuvi táaⁿ yā ní caⁿ'a yā nguaaⁿ maaⁿ yā: ¿Dɛ'ɛ̄ cuuví chí chingéeⁿ ta aceite 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ti cuuvi n'diicui yú ní ngo'o 'iinū ciento caadi ní cuuvi ca'a yú 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā. Ní nduuvi taáⁿ yā ndúúcu tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naati Jesús miiⁿ ní caⁿ'a yā: 'Āā canee ra tá. Nguɛ́ɛ́ yaa'vi nī táⁿ'ā. ¿Dɛ'ɛ̄ cúúví chi yaa'ví nī táⁿ'ā? Tá 'tiī ní n'daācā idiiⁿ tá nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā ní 'aama ca cánée yā ndúúcu nī. Ní ndís'tiī ní cuuvi din'daacá nī nduucú yā taachi neⁿ'e nī; naati 'úú nguɛ́ɛ́ 'aama cuneé ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tá 'cūū ní diīⁿ tá tan'dúúcā chi ch'iī tá perfume cuerpo yeⁿ'é maaⁿ chi 'āā cuɛ́ɛ́ 'cuūví, 'tíícā diiⁿ tá. Ní 'āā nnee 'cuiī ta chuū 'úú taachí 'āā cuɛ́ɛ́ 'cuɛɛchí. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: 'Āā tií nūuⁿ chí 'iiⁿ'yāⁿ caaⁿ'máⁿ yā nduudu ngai yeⁿ'é yeⁿ'ē chi nanguaⁿ'ai 'iiⁿ'yāⁿ na núúⁿmáⁿ íⁿ'yeeⁿdī caaⁿ'maⁿ ntuúⁿ yā chi diīⁿ n'daataá 'cūū ní n'gaacú yā yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tuu'mi ní Judas Iscariote, 'áámá chɛ́ɛ́ 'iiⁿ'yāⁿ naachi ndiichuuvi discípulos, cheⁿ'e sá nanááⁿ chiiduú n'gɛɛtɛ. Ní ngaⁿ'a sa táácā chi cuuvi nca'ā sa Jesús miiⁿ ná ta'a 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Taachí 'iiⁿ'yāⁿ s'eeⁿ ch'iindiveéⁿ yā chuū, neené yeenú yā, ní caⁿ'a yā chi ca'a yā tuumī Judas miiⁿ cáávā chuū. Judas ní in'nuuⁿ sa dɛ'ɛ̄ hora chi nca'a sa 'iiⁿ'yāⁿ s'eeⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ndaā nguuvi vmnááⁿ vmnaaⁿ yeⁿ'e 'viicu chi che'é yā pan chi nguɛ́ɛ́ levadura yeⁿ'ē, 'viicu taachi n'giiⁿ'núⁿ yā 'iiti cuūchī yeⁿ'e pascua miiⁿ. Ní discípulos yeⁿ'e Jesús miiⁿ ntiinguuneéⁿ yā Jesús: ¿Tií neⁿ'e di chi caⁿ'á 'nū in'nuúⁿ 'nū chi che'e nguiīnū yú yeⁿ'e 'viicu pascua? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tuu'mi ní Jesús dicho'ó yā na 'uūvī discípulos yeⁿ'e yā, ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: Ndís'tiī cueⁿ'é nī yáāⁿ Jerusalén. Miiⁿ ní nndaacá nī 'áámá sáⁿ'ā chí ndɛ́ɛ́ sa 'áámá 'cuuti cuéeé nuūⁿnīⁿ. Can'dáa nī saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Naachí ndaa sa va'ai miiⁿ, ní cuuví nī sáⁿ'ā chi yeⁿ'ē va'ai miiⁿ: Maestro yeⁿ'e yú ngaⁿ'a yā 'tíícā: ¿Tiī canéé cuarto naachi che'e nguiinuú yeⁿ'e pascua ndúúcū discípulos yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tuu'mi ní ch'iⁿ'i yā 'áámá cuarto ch'ɛɛtɛ ná ndiichi ndii 'úúví piso miiⁿ chi 'áá vɛ́ɛ́ yaāaⁿ. Miiⁿ ní in'nuúⁿ nī chi che'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Discípulos cueⁿ'e yā ní ndaa yā ná yáāⁿ Jerusalén miiⁿ ní ndaāca yā tanducuéⁿ'ē tan'duucā chi Jesús ngaⁿ'a yā. Ní 'iiⁿ'yāⁿ s'eeⁿ in'nuúⁿ yā chí che'e nguiīnú yā yeⁿ'e 'viicu yeⁿ'e pascua miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Taachí 'āā chiī chiīnū mííⁿ ndaā Jesús ndúúcū ndiichuuvi discípulos yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Taachí vɛɛtɛ́ yā na mesa miiⁿ chi che'e yā Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chi 'áámá chɛ́ɛ́ ndís'tiī chi nge'é nī nduucú diíⁿ nī entregar 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tuu'mi ní discípulos ní s'nee ndaachi núúⁿ yā ní tuca'a yā tiinguunéeⁿ yā Jesús ca'áámá ca'áámá yā: ¿'Áá 'úú? Ní táámá yā ngaⁿ'a ntúuⁿ yā: ¿'Áá 'úú rá? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús nan'guɛɛcútaⁿ'a yā: 'Áámá chɛɛ naachi ndiichúúví chí di'caāndá yā pan yeⁿ'é yā na cú'ú 'cūū nduucú caⁿ'á yā diiⁿ yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cuaacu, chi Saⁿ'ā chí Daiya Dendyuūs caⁿ'a sa 'cueenú sa cuuvi tan'dúúcā chi ngaⁿ'a yeⁿ'é yā naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs. Dɛ'ɛ chúúcā ya'ai yeⁿ'e saⁿ'ā chi nca'a sa 'úú chi Saⁿ'ā chi Daiya Ndyuūs. N'dáácā ca yeⁿ'ē sa ndúúti chi nguɛɛ ch'iindiyaāⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Taachí vɛɛtɛ́ yā nge'e yā, tuu'mi ní Jesús sta'á yā pan, ní nca'a yā gracias Ndyuūs cáávā pan miiⁿ. Ní n'deé yā pan ní ca'a yā discípulos. Ní caⁿ'a yā: Che'é nī pan caati tan'dúúcā cuerpo yeⁿ'é 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ní Jesús sta'á yā taza ndúúcū nuūⁿnīⁿ yeⁿ'e uvas. Ní taachi nca'a yā gracias Ndyuūs, ca'a yā discípulos yeⁿ'é yā. Ní caⁿ'a yā. Nducyaaca ndís'tiī cu'ú nī nuūⁿnīⁿ uvas yeⁿ'e taza 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Nuūⁿnīⁿ uvas miiⁿ tan'dúúcā yuūuⁿ yeⁿ'é, ní yeⁿ'e 'áámá compromiso chi ngai yeⁿ'é. Yuūuⁿ yeⁿ'é chí cungeeⁿ ní cáávā 'yaaⁿ n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī, chí 'āā ntɛ́ɛ́ cu'ú nuūⁿnīⁿ yeⁿ'e uvas na iⁿ'yeeⁿdí 'cūū ndíí nguuvi chi cu'ú naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Taachí ch'iinu chiita yā himno, chi canción yeⁿ'e Ndyuūs nan'dáa yā va'āī ní cueⁿ'é yā na yiīcū chi nguuvi Olivos. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos: Nducyaaca ndís'tiī cuuví 'cuinaáⁿ nī yeⁿ'ē 'úú maaⁿnguíinū caati ngaⁿ'a naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs 'túúcā: 'Nuūcá'ai yā 'caaⁿ'núⁿ yā saⁿ'ā chi idiiⁿ sa cuidado 'iiti cuūchī ní 'iiti cuūchī s'eeⁿ ní caⁿ'á 'muuⁿ caⁿ'á miiⁿ tī. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Taachi 'úú nduuchí yeⁿ'e nguaaⁿ tináⁿ'ā, caⁿ'á vmnaaⁿ yeⁿ'é ndís'tiī na yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tuu'mi ní Pedro miiⁿ ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: 'Áárá chí nducyaaca yā cuuví 'cuinaáⁿ yā, 'úú ní nguɛ́ɛ́ cuuví 'cuinaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tuu'mi ní Jesús ní caⁿ'a yā chiiya Pedro: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií dii chi maaⁿnguiinu taachi 'āā cuɛ́ɛ́ 'cuaī tusáⁿ'ā 'uūvī cuuvi, 'iinū cuuvi cueeⁿdíítu di ngaⁿ'a di yeⁿ'ē 'úú chi nguɛ́ɛ́ in'diichi di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naati Pedro miiⁿ ní cheeⁿdiītū caⁿ'a sa: 'Áárá chí 'cuūví ndúúcu nī, Maestro, nguɛ́ɛ́ ngaⁿ'á chi nguɛ́ɛ́ in'diichí N'diī. Ní nducyaaca discípulos ní 'tiicá ntúūⁿ caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tuu'mi ní ndaá yā na 'áámá jardín chi nguuvi Getsemaní, ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: 'Cuɛɛtɛ́ nī 'muuⁿ, neⁿ'e chi 'úú caⁿ'á caaⁿ'māⁿngua'á. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ní Jesús candɛ́ɛ yā Pedro, ndúúcū Jacobo, ndúúcū Juan. Ní neené nadicádiinuuⁿ Jesús ní nééné s'neeⁿ ndaachí yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Alma yeⁿ'é neené ndaachi yiinú chi ya'āī chi 'cuūví. 'Āā snéé núúⁿ nī 'muuⁿ, ní nguɛ́ɛ́ 'cuɛɛti yaadú nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tuu'mi ní Jesús cueⁿ'e yā ta 'lííⁿ cuááⁿ vmnaaⁿ, ní candiitín'dii yā na yáⁿ'āa ní caⁿ'angua'á yā ní caⁿ'a yā: N'diī Chiidá, ndúúti chi cuuví ní nguɛ́ɛ́ diíⁿ nī yeⁿ'e chi 'cueenú cuuvi yeⁿ'e prueba 'cūū chi canéé chi cuuvī hora chí cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tuu'mi ní naachí caⁿ'angua'á yā ní caⁿ'a yā: N'diī Chiidá, n'diī cuuvi diíⁿ nī tanducuéⁿ'ē. Nadinguáⁿ'ai nī 'úú yeⁿ'e chi 'cueenú cuuvi prueba 'cūū. Naati nguɛ́ɛ́ cuuví tan'dúúcā chi 'úú neⁿ'é, naati tan'dúúcā chí n'diī neⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tuu'mi ní ndaa ntúuⁿ yā naachi snee discípulos yeⁿ'é yā, ní ndaāca yā discípulos chí stiyaadú yā. Ni Jesús caⁿ'a yā chiī yā Pedro miiⁿ: Díí Simón, ¿Áá cyaadu di? ¿'Áá nguɛ́ɛ́ ichɛɛ̄ di cánduuchi di mar 'áámá hora? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ndís'tiī 'cuɛɛti nduuchí nī ní caaⁿ'maⁿngua'á nī ní nguɛ́ɛ́ diíⁿ nī nuuⁿndi. Cuaacu nííⁿnyúⁿ espíritu yeⁿ'e nī neⁿ'e diīiⁿ n'daacáā, naati cuerpo yeⁿ'é nī ní 'āā duūvā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tuu'mi ní Jesús cueⁿ'e ntúuⁿ yā ní ngaⁿ'angua'a yā, ní caⁿ'a ntúuⁿ yā tan'dúúcā chí caⁿ'a yā vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ní nguɛɛcunée yā ndaa ntúuⁿ yā naachi snéé discípulos, ní ndaaca ntúuⁿ yā 'iiⁿ'yāⁿ s'eeⁿ stiyaadú yā. Ní 'āā ntɛ́ɛ́ ngii ichɛɛ yā ndúúcū yaaⁿ ti nduutináaⁿ yā chi yaaⁿ náaⁿ yā. Ní 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ déénu yā chí n'guɛɛcútaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cueⁿ'é yā ndii chiiⁿ ndii 'íínú cuuvi, ní ngaⁿ'angua'á yā. Ní taachi ndaa yā naachi snee discípulos, caⁿ'a yā: Ndís'tiī 'cuɛɛtiyaadú nī ní ntaavi'tuunúúⁿ nī. 'Āā tiiní cā. 'Āā ndaā hora chi 'iiⁿ'yāⁿ nca'a yā 'úú Saⁿ'ā chi Daiya Dendyuūs na tá'ā saⁿ'ā s'eeⁿ chi dinuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nducueeⁿ ndís'tiī ní cuⁿ'ū yú. 'Āā cuchiī niiⁿnuúⁿ saⁿ'ā chí nca'a 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Naaⁿ chi Jesús indée yā ndaa Judas chi saⁿ'ā 'áámá yeⁿ'ē ndiichuuvi discípulos. Ní ndaa sa ndúúcū n'deee n'dáí 'iiⁿ'yāⁿ ndúúcū machete 'uūvī lados 'caāiⁿ ndúúcū yáⁿ'á. Chiiduú n'gɛɛtɛ ndúúcū maestros yeⁿ'e ley, ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū dichó'o yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas miiⁿ chí nca'a sa Jesús 'iiⁿ'yāⁿ s'eeⁿ, ní ca'a sa 'aama seña. Ní caⁿ'a sa 'túúcā: 'Iiⁿ'yāⁿ chi 'úú chi'neeⁿ cheendí, 'iiⁿ'yāⁿ miiⁿ chíí. Cuta'á nī 'iiⁿ'yāⁿ ní candɛɛ́ nī 'iiⁿ'yāⁿ ní din'daacá nī seguro 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Taachí ndaā Judas nanááⁿ Jesús ní caⁿ'a sa: N'dií Maestro, Maestro. Ní 'neeⁿ cheendi sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tuu'mi ní sta'á yā Jesús ní candɛ́ɛ yā preso 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naati 'áámá chɛ́ɛ́ 'iiⁿ'yāⁿ chi snéé miiⁿ itun'dáa yā machete chi 'uuvi lados 'caāiⁿ yeⁿ'e yā ní 'nuucá'ai yā mozo yeⁿ'e chiiduú ch'ɛɛtɛ ca ní ch'iica sa veēeⁿ mozo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tuu'mi ní Jesús caⁿ'a yā chii yā nducyaaca 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá can'daā ndís'tiī ndúúcū machete chi 'uūvī lados 'caāiⁿ ndúúcū yáⁿ'á chí cuta'á nī 'úú tan'dúúcā chi 'úú 'áámá duucu 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nguuvi nguuvi caneé na yáacū templo miiⁿ nguaaⁿ ndís'tiī chi ngi'cueéⁿ ní ndís'tiī ní nguɛɛ sta'á nī 'úú. Chúū canéé chí cuuvi ní cuuvi cunnuū ca'ā naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tuu'mi ní nducyaaca discípulos s'néeⁿ yā Jesús miiⁿ dámaáⁿ yā ní cheenu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naati 'áámá saⁿ'ā 'dííⁿ ndaā sa ní cueⁿ'e sa ndúúcū 'iiⁿ'yāⁿ s'eeⁿ. Ndɛɛcu sa 'áámá n'dyáⁿ'ā sábana. 'Áámá yā sta'á yā saⁿ'a 'díí miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Naati saⁿ'ā 'dííⁿ miiⁿ ní s'neeⁿ sa sábana ní cueⁿ'ē sa dácaa yuūcú sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tuu'mi ní candɛ́ɛ yā Jesús miiⁿ nanááⁿ chiiduú ch'ɛɛtɛ ca. Ní miiⁿ nduuvidaamá yā nducyaaca chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū ndúúcū maestros yeⁿ'e ley. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro miiⁿ ní cueⁿ'ē yaⁿ'ai sa n'dáa sa Jesús miiⁿ. Ní ndaa sa ndii chuva'āī yeⁿ'e va'ai chiiduú ch'ɛɛtɛ ca ní ch'iīndī sa ndúúcū policías ní in'taavi cuutú sa dáámá ndúúcu yā ti miiⁿ ní ngiichi yaⁿ'ā yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chiiduú n'gɛɛtɛ ndúúcū nducyaaca yā chí nduuvidaama in'nuúⁿ yā 'áámá prueba contra yeⁿ'e Jesús miiⁿ chí diíⁿ yā condenar Jesús chi 'caaⁿ'núⁿ yā Jesús; naati nguɛ́ɛ́ ndaaca yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Neené 'yaaⁿ 'iiⁿ'yāⁿ ngaⁿ'a yā nduudu yaadi yeⁿ'e Jesús miiⁿ naati mar 'áámá yā nguɛ́ɛ́ dáámá ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","N'duuví yā ní ncueeⁿ yā ní caⁿ'a yā nduudu yaadi, ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Nús'uu ní ch'iindiveéⁿ 'nū chí Jesús caⁿ'a yā 'túúcā: 'Úú ní nadituūví yáacu 'cūū chi saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū din'dái sa. Ní chɛɛti 'iinū nguuvi nadin'daí taama chi nguɛ́ɛ́ saⁿ'ā iⁿ'yeeⁿdí 'cūū din'dái sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Naati nguɛ́ɛ́ nduuvidáámá nduudu yā yeⁿ'e chí ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tuu'mi ní chiiduú ch'ɛɛtɛ ca chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e tanáⁿ'ā chiidūu, ndúcueeⁿ yā nguaaⁿ nducyáácá 'iiⁿ'yāⁿ s'eeⁿ ní ntiinguuneeⁿ yā Jesús miiⁿ: ¿'Áá nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nan'guɛɛcútaⁿ'a nī? ¿Dɛ'ɛ̄ chí ngaⁿ'á yā yeⁿ'e nī? ¿Dɛ'ɛ́ ngaⁿ'a nī maáⁿ nī yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús mííⁿ 'āā ntɛ́ɛ́ caⁿ'a yā. Ní nguɛ́ɛ́ n'guɛ́ɛ́cútaⁿ'a yā yeⁿ'ē mar 'áámá. Chiiduú ch'ɛɛtɛ ca miiⁿ ntiinguunééⁿ ntúuⁿ yā Jesús, ní caⁿ'a yā: ¿'Áá dii Cristo, Daiya Dendyuūs chí n'dai taavi? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Tíícā 'úú. Ndís'tiī ní caⁿ'a nī snaaⁿ nī Saⁿ'ā chi Daiya Dendyuūs chí 'cuūndī sa lado yeⁿ'e honor yeⁿ'é Ndyuūs chí vɛ́ɛ́ tanducuéⁿ'ē poder yeⁿ'e yā. Ní ndaa sa nguaaⁿ meēéⁿ yeⁿ'ē nanguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tuu'mi ní chiiduú ch'ɛɛtɛ ca chíín'cuūⁿ sa catecai sa, ní caⁿ'ā sa: ¿Dɛ'ɛ̄ ca diiⁿ yú testigos chí n'nuuⁿ yú? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","'Āā ch'iindiveéⁿ nī dendu'ū chi ngaⁿ'ā sa contra Ndyuūs. ¿Táácā tuumicadíínuuⁿ nī? Nducyaaca 'iiⁿ'yāⁿ ngaⁿ'a yā chi condenado Jesús chi 'cuuví yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tuu'mi ní n'duuví yā ní ca'a nee daíⁿ yā Jesús ní n'gaadí yā nduutináaⁿ yā ndúúcū tíínūuⁿ. Ní policías ndúúcū ta'á yā ch'eⁿ'e yā naaⁿ Jesús. Ní caⁿ'a yā: Caaⁿ'maⁿ dí ¿du'ū ch'eⁿ'e dii? ");
INSERT INTO cuxNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro miiⁿ ní canee sa chuva'ai cuaaⁿ ndiiyā. Ní ndaā 'áámá n'daataá chí diíⁿ mandado yeⁿ'ē chiiduú ch'ɛɛtɛ ca nanááⁿ Pedro miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ní n'diichi tá chí in'taavi cúutū sa na yaⁿ'ā. Ní cānee táⁿ'ā miiⁿ ní ch'iīnu tá Pedro. Tuu'mi ní caⁿ'a tá: Diī ntúūⁿ di canee dí ndúúcū Jesús yeⁿ'e yáāⁿ Nazaret. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naati Pedro miiⁿ cheeⁿdiītū sa, ní caⁿ'ā sa: 'Úú ní nguɛ́ɛ́ in'diichí 'iiⁿ'yāⁿ, ndíí nguɛ́ɛ́ deenú chí ngaⁿ'ā di. Ní can'dáa sa cuaaⁿ chuva'āī naachi indaa yā. Tuu'mi ní 'caī tusáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Táⁿ'ā chi idiiⁿ mandado miiⁿ ch'íínú ntuūⁿ ta sáⁿ'ā, ní caⁿ'a tá chiī tá 'iiⁿ'yāⁿ chi snée yā miiⁿ: Sáⁿ'a 'cūū 'áámá chɛ́ɛ́ saⁿ'ā chi cachiica ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Naati Pedro miiⁿ ní nnguɛɛ̄cunée sa cheeⁿdíítu sa. Cuayiivi miiⁿ ní 'iiⁿ'yāⁿ chi snée yā miiⁿ ní caⁿ'a ntúuⁿ yā Pedro: Cuaacu chí dii ní dáámá chi cachiica di ndúúcū Jesús ti dii ní yeⁿ'ē yáⁿ'āa Galilea, ní nduudu yeⁿ'ē di tan'dúúcā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tuu'mi ní Pedro miiⁿ ní 'caa'va sa, ní cunncáā caⁿ'ā sa. Ní 'cái sa “por Ndyuūs”: Nguɛ́ɛ́ n'diichí 'ííⁿ'yaⁿ 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tuu'mi ní túsaⁿ'ā miiⁿ 'cai ntúuⁿ tī ndii 'úúví cuuvi. Ní Pedro miiⁿ ní n'gaācu sa chi Jesús caⁿ'a yā chii yā saⁿ'ā: 'Naaⁿ chi 'āā cuɛ́ɛ́ 'cuaī túsaⁿ'ā 'uūvī cuuvi, 'āā 'íínú cuuvi cheeⁿdiītu di chí ngaⁿ'a di chi nguɛ́ɛ́ n'diīchi di 'úú. Taachi nádicādíínuuⁿ sa chuū, ní chɛɛ̄cū sa. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Taachí chidɛɛvɛ, chiiduú n'gɛɛtɛ́ ní nduuvi daamá yā ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū, ndúúcū maestros yeⁿ'e ley, ndúúcū nducyaaca 'iiⁿ'yāⁿ n'gɛɛtɛ. Ní ndɛɛ̄ chiichí yā Jesús ní candɛ́ɛ yā 'iiⁿ'yāⁿ nanááⁿ gobernador Pilato. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tuu'mi ní Pilato miiⁿ intiinguuneeⁿ yā Jesús: ¿'Áá díí Rey yeⁿ'e 'iiⁿ'yāⁿ Israel s'eeⁿ chi judíos? Ní Jesús nan'guɛɛcútaⁿ'a yā: N'diī ngaⁿ'a cuaacú nī ti 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chiiduú n'gɛɛtɛ ní neené n'deee nááⁿ chi ngaⁿ'á yā contra yeⁿ'e Jesús naati Jesús nguɛ́ɛ́ nan'guɛɛcútaⁿ'a yā yeⁿ'ē mar 'áámá. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tuu'mi ní Pilato miiⁿ ní nan'guɛɛcunée yā ntiinguunéeⁿ yā Jesús miiⁿ: ¿'Áá nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nán'guɛɛcútaⁿ'á nī? 'Cuin'dííchí nī yeⁿ'é tanducuéⁿ'ē chí nguɛ́ɛ́ n'daacā ngaⁿ'á yā yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Naati Jesús miiⁿ ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nan'guɛɛcútaⁿ'á yā. Chííⁿ chí Pilato miiⁿ cheⁿ'e yiinú yā ní nguɛ́ɛ́ déénu yā dɛ'ɛ̄ nadicádíínuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Canéé 'áámá costumbre yeⁿ'e 'iiⁿ'yāⁿ Israel s'eeⁿ chí n'dɛɛchi yā 'áámá saⁿ'ā chi canuuⁿ vácūū nguuvi 'viicú yeⁿ'e pascua. 'Áámá saⁿ'ā chi preso sa chi 'iiⁿ'yāⁿ Israel neⁿ'e yā, 'tíícā canee chí diīiⁿ Pilato miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ní canuuⁿ 'áámá saⁿ'ā vácūū chí nguuvi Barrabás ndúúcū ta n'duuvi saⁿ'ā chi 'niiⁿ'nuⁿ sa 'iiⁿ'yāⁿ taachi 'āā diiⁿ caandá yā contra gobierno miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ní 'iiⁿ'yāⁿ Israel s'eeⁿ ní ndaa yā nanááⁿ Pilato miiⁿ, ní chiica yā chi Pilato ní diíⁿ yā tan'dúúcā costumbre yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ní Pilato miiⁿ nan'guɛɛcútaⁿ'a yā: ¿'Áá neⁿ'e nī chí n'dɛɛ̄chí Rey yeⁿ'ē 'iiⁿ'yāⁿ Israel? ");
INSERT INTO cuxNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tí Pilato miiⁿ deenu yā chí chiiduú n'gɛɛtɛ nca'á yā Jesús miiⁿ cáávā vaadī ngueēé. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Naati chiiduú n'gɛɛtɛ chinuú yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén chí caaca yā Barrabás ti n'dáacā chí n'dɛɛchii yā saⁿ'ā chi nguuvi Barrabás. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tuu'mi ní Pilato miiⁿ intiinguunéeⁿ yā: ¿Dɛ'ɛ́ neⁿ'e nī chi diíⁿ ndúúcū 'iiⁿ'yāⁿ chí ndís'tiī ngaⁿ'a nī Rey yeⁿ'e 'iiⁿ'yāⁿ Israel? ");
INSERT INTO cuxNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'Iiⁿ'yāⁿ s'eeⁿ nan'guɛɛcútaⁿ'a yā ní 'cai yiicú yā: Cu'neeⁿnga'á nī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ chi nguɛ́ɛ́ n'daacā n̄díiⁿ sáⁿ'a 'cūū? Naati 'iiⁿ'yāⁿ s'eeⁿ ní nan'guɛɛcúnée yā 'cai yā: Cu'neeⁿnga'á nī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Tuu'mi ní Pilato miiⁿ chi nguɛ́ɛ́ neⁿ'e yā chi nduuvi táaⁿ 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'é yā, n'dɛɛchii sá Barrabás miiⁿ. Cuayiivi ní caⁿ'a ntiiⁿnyuⁿ sa chi 'cueⁿ'é yā Jesús miiⁿ. Ch'iinu ch'eⁿ'é yā Jesús miiⁿ ní nca'a sa Jesús miiⁿ 'iiⁿ'yāⁿ chí cu'nééⁿnga'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tuu'mi ní soldados romanos candɛ́ɛ sa Jesús vaacuyáāⁿ na cuarto yeⁿ'e palacio miiⁿ chi nguuvi Pretorio, ní yaa'ví yā tanáⁿ'ā soldados ní nduuvidaamá yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ní s'nuúⁿ yā catecai morado cuá'āa Jesús miiⁿ. Ní s'nuúⁿ yā tiiⁿ Jesús miiⁿ 'áámá corona chi ndeenyú ndúúcū yaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tuu'mi ní tucá'a yā 'cai yā: Cunduuchi nī n'diī, Rey yeⁿ'e 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ní ch'eⁿ'é yā tiíⁿ yā ndúúcū 'áámá taaⁿ nduu. Ní ca'a nee dáiⁿ yā Jesús ní nchiīntii'yá yā nanáaⁿ yā, ní diíⁿ yā honrar 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ch'iinu ch'iiⁿnyuⁿnéeⁿ yā yeⁿ'e Jesús 'tííca, ndivíi yā catecai chi morada ní 'nuuⁿ 'nuūⁿ ntúuⁿ yā catecai maáⁿ yā. Cuayiivi tun'dáa yā Jesús ní s'neeⁿnga'á yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Áámá saⁿ'ā yeⁿ'e yáⁿ'āa Cirene chi nguuvi sa Simón, chí chiidá Alejandro ndúúcū Rufo, ndáa sa cheⁿ'e sa cuɛɛti. Taachí cho'o sa cyúúní miiⁿ, soldados a fuerza di'cuíítu yā saⁿ'ā chi candɛɛ sa cruz yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ní candɛ́ɛ yā Jesús 'áámá lado yeⁿ'e yáāⁿ Jerusalén na lugar chi nguuvi Gólgota chi neⁿ'e caaⁿ'maⁿ nduudu yeⁿ'e yú, Lugar ní 'Iini Nga'ai Tiīíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ní ca'á yā chí chi'i Jesús vino chi staⁿ'a yā ndúúcū yaātā yaāa chi nguuvi mirra, naati Jesús nguɛ́ɛ́ chi'i yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tuu'mi ní chi'neeⁿnga'á yā Jesús. Ní soldados ní tun'dáa yā suertes yeⁿ'é yā ndúúcū na catecai Jesús miiⁿ, ní n'diichí yā chɛɛ̄ chí candɛɛ̄ 'aama 'aama yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","N'gɛɛcú nuuⁿ yeⁿ'ē ngɛɛtiyaaⁿ miiⁿ taachí s'neeⁿnga'á yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ni s'néeⁿ yā 'áámá letrero na tiīiⁿ cruz yeⁿ'e Jesús miiⁿ. Ní letra chi cánéé nguūⁿ na tabla miiⁿ ní ngaⁿ'ā yeⁿ'e nuūⁿndī yeⁿ'e yā. Ní cánéé nguūⁿ chuū: Rey yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dáámá ndúúcū Jesús s'neeⁿnga'á yā 'uūvī sáⁿ'ā chí duucu. 'Áámá ní lado tá cuaacú yā táámá ní lado ta 'cueé yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Tíícā ní chi cuaacu naachi canéé nguūⁿ na libro yeⁿ'é Ndyuūs 'tíícā: Chídidúúchɛ́ yā ndúúcū 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","'Iiⁿ'yāⁿ chí ngo'ó yā nanááⁿ cruz miiⁿ cunncáā ngaⁿ'a yā yeⁿ'ē Jesús. Idi'núⁿ'u yā tiiⁿ yā ní cunncáa n'dai cheendi yā ní ngaⁿ'a yā: Díí chí ndiītuū'ví di yaācū ní nadacueéⁿ di chɛɛti 'iīnū nguuvi, ");
INSERT INTO cuxNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nadanguáⁿ'āī maāⁿ di. Dii ní nch'eeⁿ di na cruz. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","'Tiicá ntúūⁿ chiiduú n'gɛɛtɛ ndúúcū maestros yeⁿ'e ley duuchinéeⁿ yā Jesús. Ní ngaⁿ'a yā nguaaⁿ maáⁿ yā: 'Iiⁿ'yāⁿ miiⁿ nadinguáⁿ'ai yā táámá 'iiⁿ'yāⁿ naati maaⁿ ní nguɛ́ɛ́ ngíí nadinguáⁿ'ai yā maáⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ndúúti chi 'iiⁿ'yāⁿ miiⁿ chí Cristo miiⁿ snaaⁿ yú 'iiⁿ'yāⁿ nch'éeⁿ yā na cruz maaⁿ. Tuu'mi ní cu'téénu yú. Ní ndíí 'iiⁿ'yāⁿ chi ca'neeⁿnga'á yā daama ndúúcū Jesús miiⁿ ní cunncáā ngaⁿ'a yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Taachí chii maⁿ'a nguuvi miiⁿ chi maāíⁿ núúⁿmáⁿ íⁿ'yeeⁿdī ndii ná n'gɛɛcu 'íínú chiīnū. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","'Āā táánduū n'gɛɛcu 'iinu Jesús miiⁿ ní 'cai yiicú yā: Eloi, Eloi, ¿lama sabactani? (chí neⁿ'e caaⁿ'maⁿ nduudu yeⁿ'ē yú: N'dií Ndyuūs yeⁿ'é, n'dií Ndyuūs yeⁿ'é, ¿dɛ'ɛ̄ cuuvi chí s'neé nī maaⁿ 'úú dámaáⁿ?) ");
INSERT INTO cuxNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","N'dúú'ví 'iiⁿ'yāⁿ chi snee yā miiⁿ ní ch'iindiveéⁿ yā ní caⁿ'a yā: 'Caandiveéⁿ nī, n'gaí yā yeⁿ'e profeta Elías miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ní ndaā 'áámá soldado ngeenu yā ní taachi chiītu 'áámá esponja yeⁿ'e vinagre s'néeⁿ yā esponja miiⁿ na 'áámá ndúú ní ca'a yā chí chi'i Jesús. Ní caⁿ'a yā: 'Āā canee rá yā. N'diichi yú nduuti chi 'áá chiī profeta Elías miiⁿ ní nádich'eēⁿ sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tuu'mi ní Jesús 'cai yiicú yā ní ch'iī. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ní cortinas yeⁿ'e yaācū templo chiī 'uuvi taāⁿ, steēⁿ naavtáⁿ'ā ndíí cuááⁿ 'niiⁿnúⁿ ndíí cuááⁿ ndiiyā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ní 'áámá saⁿ'ā romano chí ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'ē cien soldados chééndii sa nanááⁿ Jesús miiⁿ. Taachí n'diīchī sa ní ch'iindiveēⁿ sa taacá 'cai Jesús ní taacá ch'īi yā, soldado miiⁿ ní caⁿ'a sa: Cuaacu nííⁿnyúⁿ chí sáⁿ'a 'cūū ní Dáíyá Dendyuūs saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Snée ntúūⁿ n'duuvi n'daataá n'giinu yaⁿ'ai tá. Ní ndúúcū n'daata s'eéⁿ mííⁿ canee ta María yeⁿ'e yáāⁿ Magdala, ndúúcū tá María chi chɛɛcuú José ndúúcū Jacobo chí nguuvi Menor, ndúúcū n'daataá chi nguuvi Salomé. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","N'daata s'ééⁿ ní can'dáa yā Jesús miiⁿ ní dichíí'vɛ yā Jesús taachi cachiicá yā yáⁿ'āa Galilea. Ní neené 'yaaⁿ ca n'daataá snée yā miiⁿ, n'daataá chí ngaⁿ'a yā daama ndúúcū Jesús miiⁿ na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Taachí chiinū nguuvi miiⁿ chi viernes chí ch'iindiyaáⁿ yā cáávā 'viicu pascua miiⁿ nguuvi chí cuuvi dɛɛvɛ nguuvi chi ntaavi'tuunúúⁿ yā 'iiⁿ'yāⁿ, ");
INSERT INTO cuxNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ndaā José yeⁿ'e yáāⁿ Arimatea. Saⁿ'ā miiⁿ ní saⁿ'a ch'ɛɛtɛ yeⁿ'e Junta Ch'ɛɛtɛ yeⁿ'e 'iiⁿ'yāⁿ Israel. Ní cunee ngiinu sa nguuvi chi Ndyuūs ndaa yā ni ngaⁿ'a ntiiⁿnyuⁿ yā. Ní ndúúcū valor ndaā sa nanááⁿ gobernador Pilato miiⁿ. Ní caⁿ'a sa Pilato miiⁿ chí nca'a yā cuerpo yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato miiⁿ ní cueⁿ'e yiinú yā chí 'āā ch'iī Jesús miiⁿ ní yaa'vi yā saⁿ'ā chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e soldados chi cuchii sa nanáaⁿ yā. Taachí ndaa sa ní 'iicu tiinguuneeⁿ yā saⁿ'ā: ¿'Áá cuaacu chi ch'iī Jesús? ");
INSERT INTO cuxNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Taachí soldado centurión miiⁿ ngaⁿ'a sa chi cuaacu, tuu'mi ní Pilato miiⁿ ca'a yā orden chi ca'a sa cuerpo yeⁿ'e Jesús miiⁿ José miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Cuayiivi ní José cái sa 'áámá sábana chi fina ní nadīcheeⁿ sa cuerpo miiⁿ ní sta'a sa ní ch'ɛɛ̄cū sa cuerpo miiⁿ ná sábana miiⁿ. Ch'iinu maaⁿ ní s'nuūⁿ sa chɛɛti 'áámá yáinyāⁿ ní nííⁿnuúⁿ canee 'áámá tuūu ch'ɛɛtɛ́. Ní s'nuúⁿ yā tuūu ch'ɛɛtɛ cheendi yáinyāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Tá María Magdalena ndúúcū María chi chɛɛcuú José cueⁿ'é yā ní n'diichí yā naachí ch'ɛɛ̄chi Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Taachi chó'ōo sábado, nguuvi chi ntaavi'tuunúúⁿ yā, María yeⁿ'e yáāⁿ Magdala, ndúúcū María chí chɛɛcuú Jacobo, ndúúcū n'daata chi Salomé cai yā perfumes chi cueendái yā vmnááⁿ yeⁿ'ē cuerpo yeⁿ'ē Jesús miiⁿ ní cueⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Neené tyaaⁿ yeⁿ'ē nguuvi vmnááⁿ vmnaaⁿ yeⁿ'é ndɛɛ̄tɛ chi domingo taachí can'dáá 'yáⁿ'ā n'daatā s'eeⁿ ndaá yā na yáinyāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ní ngāⁿ'a yā nguááⁿ maáⁿ yā: ¿Du'ū ndivíi tuūu yeⁿ'ē yú taachí ndaā yú cheendi yáinyāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Taachí ndaa yā, tuu'mi ní n'diichi yā chi tuūu ch'ɛɛtɛ́ n'dai miiⁿ 'āā ntɛ́ɛ́ canéé na lugar yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ní taachí ndáa yā chɛɛti yáinyāⁿ, miiⁿ n'diichí yā 'áámá saⁿ'ā 'dííⁿ vɛɛ sa lado tá cuaācú ní canúúⁿ sá catecai ch'éenūu sa ní cuɛ́ɛ̄. Ní n'daata s'eeⁿ dii'yá yā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sáⁿ'ā miiⁿ ní caⁿ'ā sa: Nguɛ́ɛ́ dii'yá nī cuuvi. Ndís'tiī ní in'nuúⁿ nī cuerpo yeⁿ'e Jesús yeⁿ'e yáāⁿ Nazaret, 'iiⁿ'yāⁿ chí iiⁿ'yāⁿ s'eeⁿ ca'nééⁿnga'a yā. Nááti 'iiⁿ'yāⁿ miiⁿ ní 'āā ndúúchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā ní nguɛ́ɛ yā 'muuⁿ. Cuin'diichí nī naachí canuúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ndís'tiī cuinaⁿ'á nī ní cuuvi nī discípulos yeⁿ'e yā, ndúúcū Pedro, chi Jesús miiⁿ ní caⁿ'á yā vmnááⁿ ndís'tiī na yáⁿ'āa Galilea. Mííⁿ snaáⁿ nī 'iiⁿ'yāⁿ tan'dúúcā chi Jesús caⁿ'a yā chii yā ndís'tiī ndúúcū tanáⁿ'ā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","N'daata s'eeⁿ ní cunaⁿ'á yā ngeenu yā yeⁿ'e na yáinyāⁿ, ti neené cueⁿ'e yiinú yā ní yiinduuví yā. Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ caⁿ'á yā chii yā mar 'áámá 'iiⁿ'yāⁿ, ti 'va'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Taachí Jesús nduuchi yā chidɛɛvɛ nguuvi domingo chi nguuvi vmnááⁿ vmnaaⁿ yeⁿ'e ndɛɛ̄tɛ̄ miiⁿ, vmnááⁿ vmnaaⁿ che'enaáⁿ yā nanááⁿ María Magdalena, n'daataá chí nn'divií yā ndɛɛ̄chɛ̄ espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'ē ta. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Táⁿ'ā miiⁿ ní caⁿ'a tá ní chii tá 'iiⁿ'yāⁿ chí chiicá yā ndúúcū Jesús miiⁿ. Ní ngɛɛcú 'iiⁿ'yāⁿ s'eeⁿ chí neené ndaachií yiinu yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ní taachí 'iiⁿ'yāⁿ s'eeⁿ ch'iindiveéⁿ yā chi Jesús miiⁿ nduuchi yā yeⁿ'e nguaaⁿ tináⁿ'ā ní chí táⁿ'ā miiⁿ n'diichi tá Jesús, nguɛ́ɛ́ s'teenú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Cho'ōo chúū, ní Jesús che'enaáⁿ yā yeⁿ'ē 'uuvi 'iiⁿ'yāⁿ chi cueⁿ'é yā na yúúní. Ní Jesús diíⁿ yā tan'dúúcā chi nguɛɛ déénu yā yeⁿ'e chi chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ní cuayiivi 'iiⁿ'yāⁿ s'eeⁿ ní cúnaⁿ'á yā ní caⁿ'a yā chii yā tanáⁿ'ā discípulos. 'Tiicá ntúūⁿ discípulos ní nguɛ́ɛ́ s'teenú yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Chiī ch'íinū nguuvi domingo miiⁿ, ní Jesús che'enaáⁿ yā yeⁿ'ē ndu'ū ndiicháámá discípulos yēⁿ'e yā, taachi 'iiⁿ'yāⁿ s'eeⁿ vɛɛ̄tɛ́ yā na mesa. Ní Jesús tuūvi iinú yā ndúúcu yā ti discípulos nguɛ́ɛ́ s'teenu yā ní chɛɛchi staava yeⁿ'é yā ti discípulos nguɛ́ɛ́ s'teenú yā 'iiⁿ'yāⁿ chi ngaⁿ'a yā chí n'diichí yā Jesús chí 'āā nduuchí yā yeⁿ'ē nguaaⁿ tínáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ní caⁿ'a yā chii yā discípulos: Cuéⁿ'e nī núúⁿmáⁿ nación yeⁿ'e íⁿ'yeeⁿdī ní caaⁿ'máⁿ nī ndúúdú cuaacu yeⁿ'ē chí nanguáⁿ'ai yā nanááⁿ nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","'Iiⁿ'yāⁿ chí i'teenú yā ní ngɛɛdínuúⁿniⁿ yā, ní nanguaⁿ'ai yā yeⁿ'e nuuⁿndi yeⁿ'e yā. Naati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu yā cuuví yā condenado. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Níícú señales yeⁿ'e poder miiⁿ canéé ndúúcū 'iiⁿ'yāⁿ chi i'téénu yā 'úú. Ndúúcū chi duūchí tun'daá yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ ní cuuví caⁿ'á yā táámá davaacu chí ngai. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ní nduuti chi cuta'á yā ndúúcū ta'a yā 'áámá cúú ní nguɛ́ɛ́ dɛ'ɛ̄ daño diíⁿ tī ndúúcu yā. Ní nduuti chi cu'ú yā dɛ'ɛ̄ chí veneno miiⁿ nguɛ́ɛ́ diiⁿ daño 'iiⁿ'yāⁿ. Ní cun'duú yā ta'a yā vmnaaⁿ yeⁿ'ē 'iiⁿ'yāⁿ chi ngíítā ní 'iiⁿ'yāⁿ s'eeⁿ ní nduūvā yēⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ch'íínú caⁿ'a Señor Jesús ndúúdú 'cūū ndúúcū discípulos yēⁿ'e yā ní cundáa yā na va'ai chɛɛti nguuvi. Ní ch'iindí yā lado yeⁿ'e honor yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Discípulos ní cueⁿ'e yā, ní caⁿ'a yā nduudu cuaacu yeⁿ'ē chí nanguaⁿ'ai yā ndu'ū cuaaⁿ. Maaⁿ Señor Jesucristo ngiinnee yā discípulos 'íícú canee n'daācā ndúúdú yeⁿ'e yā cáávā señales ndúúcū vaadī n'giinu chi diíⁿ yā. 'Tíícā chiī.");
INSERT INTO cuxNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nééné 'yaaⁿ 'iiⁿ'yāⁿ nguaaⁿ s'uuúⁿ neⁿ'é yā idingúuⁿ yā dendú'ū chí chiī, chííⁿ chi s'uuúⁿ deenu yú chi nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","'Tíícā tan'dúúcā chi 'iiⁿ'yāⁿ s'eeⁿ n'diichí yā tanducuéⁿ'ē ndíí taachí chi nga'ā, 'iiⁿ'yāⁿ s'eeⁿ ní chi'cueeⁿ yā s'uuúⁿ. 'Iiⁿ'yāⁿ s'eeⁿ candɛ́ɛ yā nduudu cuaacu yeⁿ'é Ndyuūs ní ngaⁿ'á yā nduudu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'Úú, Lucas, idinguúⁿ yeⁿ'é díí Teófilo cáávā chi deenú chi díí ní n'dai di. 'Tiicá ntúūⁿ 'úú ní nadicádiinúúⁿ chi idinguúⁿ yeⁿ'ē di tanducuéⁿ'ē chí chiī. Diiⁿncā n'diichí tanducuéⁿ'ē ndúúcū cuidado ndíí taachí nga'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'Túúcā idinguúⁿ ní tuumicadíínuuⁿ di chɛɛ chí nduudu cuaacu yeⁿ'ē dendú'ū chi 'iiⁿ'yāⁿ chi'cuéeⁿ yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tiempo miiⁿ chi 'iiⁿ'yāⁿ Herodes miiⁿ chí chīi yā rey yeⁿ'e yáⁿ'āa Judea, canéé 'áámá chiiduú chi nguuví yā Zacarías. Chiiduú miiⁿ ní yeⁿ'e grupo yeⁿ'e Abías. Ní n'daataá yeⁿ'e Zacarías ní nguuvi tá Elisabet. Ní Elisabet miiⁿ ní yeⁿ'e ndaata yeⁿ'e Aarón. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ndúú 'uuví yā ní n'dai taaví yā nanááⁿ Ndyuūs. 'Iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ diíⁿ yā chi nguɛ́ɛ́ n'daacā ndúúcū 'iiⁿ'yāⁿ caati s'neeⁿ veéⁿ yā nducuéⁿ'ē nduudu chi ngaⁿ'a 'iivú Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ daiyá yā, ti Elisabet miiⁿ nguɛ́ɛ́ taaví yā daiyá yā. Ní nduu 'uuví yā ní 'āā ndiicú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","'Áámá nguuvi, taachi tuneeⁿ turno yeⁿ'e grupo yeⁿ'e Zacarías chi diiⁿ ntiiⁿnyuⁿ yeⁿ'e chiiduú chi dichíí'vɛ yā na yáacū templo yeⁿ'é Ndyuūs, 'tíícā diíⁿ Zacarías ntiiⁿnyuⁿ yeⁿ'e chiiduú nanááⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ní tan'dúúcā costumbre yeⁿ'e chiiduú s'eeⁿ, tuneeⁿ Zacarías miiⁿ chí cunndaa yā na yáacū templo yeⁿ'e Ndyuūs ní 'neeⁿ yaⁿ'a yā incienso. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ní nducyaaca 'iiⁿ'yāⁿ snée yā cuaaⁿ chuva'āī yáacū templo ní ngaⁿ'angua'á yā neⁿ'e chi ngiichi incienso chɛɛti yaācū templo. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías miiⁿ canee yā na yaacū. Ní che'enaāaⁿ yeⁿ'e Zacarías miiⁿ 'áámá ángel chi Ndyuūs dichó'o yā. Ní ángel mííⁿ chééndii yā lado tá cuaacu yeⁿ'ē nátai naachi n'giichi incienso miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ní taachi Zacarías miiⁿ n'diichí yā ángel miiⁿ 'āā ntɛ́ɛ́ deenú yā dɛ'ɛ̄ chi diíⁿ yā ní dii'ya taaví yā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naati ángel miiⁿ ní caⁿ'a yā: N'diī Zacarías, nguɛ́ɛ́ 'va'á nī, ti Ndyuūs ní ch'iindiveéⁿ yā chí caⁿ'angua'á nī. Ní 'cuūndiyáāⁿ 'áámá daiya n'daataá yeⁿ'é nī Elisabet miiⁿ, ní cu'neéⁿ nī nguuvi sa Juan. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ní cuuvi yeenu taaví nī cáávā saⁿ'ā 'lííⁿ. Ní 'yaaⁿ n'dáí 'iiⁿ'yāⁿ cuuvi yeenú yā cáávā chi 'cuundiyaāⁿ dacua'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Caati daiyá nī miiⁿ ní cuuvi ch'ɛɛtɛ sa nanááⁿ Ndyuūs. Nguɛ́ɛ́ cu'u sa vino ndíí nguɛ́ɛ́ ndúú cu'u sa dɛ'ɛ̄ vɛɛ chi cuuvi cuū'vī sa. 'Āā canee sa ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs ndíí taachi 'āā cuɛ́ɛ́ 'cuundiyaāⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Saⁿ'ā miiⁿ ní diiⁿ sa chi 'yaaⁿ taavi ca daiyā 'iiⁿ'yāⁿ Israel nguɛɛcuneé yā ní i'téénu yā Ndyuūs yeⁿ'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Daiyá nī, Juan 'cūū, ní caⁿ'a sa vmnaaⁿ yeⁿ'ē Señor Jesucristo. Ní canee sa ndúúcū espíritu ndúúcū poder tan'dúúcā chi canee profeta Elías ndii cuááⁿ vmnaaⁿ. Saⁿ'ā miiⁿ ní diiⁿ sa chi 'cuɛɛtinéé n'daācā 'iiⁿ'yāⁿ chi n'gɛɛtɛ ndúúcū daiya yā. Níícú 'iiⁿ'yāⁿ cuuvi cu'téénu yā tan'dúúcā Ndyuūs neⁿ'é yā chi cu'téénu yā, ní tan'dúúcā tanáⁿ'ā 'iiⁿ'yāⁿ chi n'dai i'téénu yā. Ní 'tíícā caⁿ'a sa diiⁿ sa chi 'iiⁿ'yāⁿ s'eeⁿ 'cuɛɛtinéé yaáⁿ yā chi cuuvi cu'téénu yā Señor Jesús taachi ndaa yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tuu'mi ní Zacarías miiⁿ ní tiinguunéeⁿ yā ángel miiⁿ: ¿Táácā cu'teenú chi ngaⁿ'a nī? caati 'úú ní 'āā ndiīcúú 'úú, 'tiicá ntúūⁿ n'daataá yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angel miiⁿ n'guɛɛcútáⁿ'a yā ní caⁿ'á yā: 'Úú ángel chi nguuvi Gabriel chi caneé chi diíⁿ ntiiⁿnyuⁿ nanááⁿ Ndyuūs. Dendyuūs dichó'o yā 'úú. Ní 'úú yaa'ví n'diī ní cuuví nduudu n'dáí 'cūū n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Maaⁿ ní cuuvi 'díi'mi nī ní 'āā ntɛ́ɛ́ cuuvi caaⁿ'máⁿ nī ndii chó'ōo chúū taachi cunuuⁿ ca'ā tiempo yeⁿ'ē, ti nguɛ́ɛ́ chi'teenú nī nduudu yeⁿ'é taachi ngaⁿ'á chi chuū chí cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Neⁿ'e chí chiī chuū, 'iiⁿ'yāⁿ s'eeⁿ chi snée yā chuva'ai yáacū templo chi snéé ngiinu yā Zacarías miiⁿ cueⁿ'e yíínú yā chí Zacarías miiⁿ ní chi'naáⁿ yā chɛɛti yaacū templo yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Taachi Zacarías miiⁿ ní nan'dáa yā chɛɛti yaācū 'āā ntɛ́ɛ́ ngii ngaⁿ'a yā. 'Iiⁿ'yāⁿ s'eeⁿ ní tuumicadíínuuⁿ yā chi vɛ́ɛ́ 'áámá visión chi n'diichí Zacarías miiⁿ taachí canée yā chɛɛtí yaācū templo. Zacarías miiⁿ díta'á yā dɛ'ɛ̄ chi neⁿ'e caaⁿ'máⁿ yā ti chiī 'díi'mí yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Taachí ch'iīnū turno chi 'áámá ndɛɛtɛ yeⁿ'e servicio chi diiⁿ yā ntiiⁿnyuⁿ chɛɛti yaacū templo Zacarías miiⁿ ní cunaⁿ'á yā na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cho'ō tiempo 'cūū ní n'daataá yeⁿ'é yā chi Elisabet miiⁿ ní ch'iindi dácua'a yeⁿ'é yā ní 'áámá canúuⁿ ta na vaacu ta nyuⁿ'u 'iīyū. Ní neené nacadíínuuⁿ ta. Ní ngaⁿ'a ta maaⁿ ta: ");
INSERT INTO cuxNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Chuū chi Señor Ndyuūs miiⁿ ní diíⁿ yā nduucú na nguuví 'cūū ní diíⁿ yā chi 'āā ntɛ́ɛ́ 'cuinaáⁿ nanááⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Cuayiivi chí ch'íínú jaaⁿ 'iiyū chi Elisabet miiⁿ ch'iindi dácua'a yeⁿ'e tá ní Ndyuūs dicho'ó yā ángel Gabriel taama vmnéⁿ'ēe. Ní cueⁿ'é yā na 'áámá yáāⁿ chi nguuvi Nazaret chi yeⁿ'ē yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ndyuūs dicho'ó yā ángel Gabriel miiⁿ nanááⁿ 'áámá n'daataá chi cuiinú chi nguuvi tá María. María miiⁿ ní caⁿ'á yā chi 'caandavaacú yā ndúúcū 'aama saⁿ'ā chi nguuvi José. Saⁿ'á 'cuū ní yeⁿ'e ndaata yeⁿ'e rey David chi ndíí tiempo chi 'āā chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel miiⁿ ní sndaa yā naachi canéé María ní caⁿ'a yā: N'diī, María, yeenú taavi nī chi Ndyuūs neⁿ'e taaví yā n'diī. Señor Ndyuūs caneé yā ndúúcū n'diī. Ndyuūs di'viicu cá yā n'diī nguaaⁿ nducyaaca n'daataá yeⁿ'ē iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Taachi María miiⁿ ch'iindiveéⁿ yā chuū, cueⁿ'ē yiinú yā ní chistaⁿ'a vaadī cadíínuuⁿ yeⁿ'é yā yeⁿ'e nduudu yeⁿ'e ángel miiⁿ. Ní nadicádiinuuⁿ yā: ¿Dɛ́'ɛ̄ neⁿ'e caaⁿ'maⁿ nduudú 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tuu'mí ángel miiⁿ ní caⁿ'a yā: N'diī, María, nguɛ́ɛ́ 'va'a nī, ti vɛ́ɛ́ taavi favor yeⁿ'é nī nanááⁿ Ndyuūs, ti Ndyuūs dineⁿ'é yā n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ní cuuvi daiyá nī ní 'cuūndī 'áámá saⁿ'ā daiyá nī, ní cuuvi nguuví yā JESÚS. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Daiyá nī cuuvi ch'ɛɛtɛ n'daí yā ní 'iiⁿ'yāⁿ s'eeⁿ ngaⁿ'á yā chi daiyá nī ní Daiyá Dendyuūs chi ch'ɛɛtɛ taavi ca. Ní Señor Ndyuūs caⁿ'a yā diíⁿ yā chi daiyá nī ní cuuví yā rey lado yeⁿ'e rey David tan'dúúcā nguuvi chí 'āā cho'oó. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ní caaⁿ'maⁿ ntiiⁿnyúⁿ yā yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e Israel cueⁿ'e daāⁿmaⁿ. Ní naachi caaⁿ'maⁿ ntiiⁿnyúⁿ yā ní 'áámá cūnee. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tuu'mi ní María caⁿ'á yā chii yā ángel: ¿Taaca cuuví chuū, ti 'úú ní nguɛ́ɛ́ isaⁿ'ā yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel miiⁿ ní nan'guɛɛcútaⁿ'á yā: Ndúúcū poder yeⁿ'é Ndyuūs chi canéé na va'ai chɛɛti nguuvi Espíritu N'dai yeⁿ'é Ndyuūs ní ndaá yā vmnaaⁿ yeⁿ'é n'diī. Ní cu'neéⁿ yā 'daaⁿ'núⁿ yā tan'dúúcā meēéⁿ vmnaaⁿ yeⁿ'é n'diī ní 'iicu cuuvi chó'ōo yeⁿ'é nī chí dacua'ā 'lííⁿ chi 'cuundiyaāⁿ miiⁿ 'tíícā cunée yā yeⁿ'é Ndyuūs ní cuuvi nguuví yā 'iiⁿ'yāⁿ chi dɛɛvɛ chi Daiya Dendyuūs 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ní n'diichí nī. Prima yeⁿ'e nī chí nguuví Elisabet miiⁿ, 'cuundii ntúūⁿ 'áámá daiyá yā maaⁿ chí 'āā ndiicú yā. 'Āā jaaⁿ 'iiyu daiyá yā chɛɛtí yā, n'daataa miiⁿ chí 'iiⁿ'yāⁿ s'eeⁿ ngaⁿ'a yā chi nguɛɛ 'cuūndī daiya yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","'Tíícā diiⁿ Ndyuūs caati 'iivú Ndyuūs cuuvi diíⁿ yā tanducuéⁿ'ē chi neⁿ'é yā diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tuu'mi ní María miiⁿ ní caⁿ'á yā: 'Úú criada chi ngaⁿ'ā ntiiⁿnyuⁿ 'iivú Ndyuūs yeⁿ'é. Maaⁿ ní Ndyuūs diíⁿ yā nduucú tan'dúúcā chí caⁿ'a yā chi diíⁿ yā. Taachi ch'iinu caⁿ'a yā chuū, ángel miiⁿ ní cunaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nguuvi s'eeⁿ María miiⁿ nūuⁿ cueⁿ'é yā na yúúní ní ndāa yā na yáāⁿ Judá. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ní ndāa yā na vaacu Zacarías miiⁿ ní yaa'ví yā Elisabet. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Taachi Elisabet miiⁿ ch'iindiveéⁿ yā nduudu yeⁿ'e María dacuá'āá miiⁿ ní nuⁿ'u chɛɛti Elisabet miiⁿ. Ní Elisabet mííⁿ chiitu Espíritu N'dai yeⁿ'é Ndyuūs táⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ní caⁿ'a yā ndúúcū nduudu díítuú: Dɛ'ɛ̄ chúúcā n'dai n'diī nguaaⁿ nducyaaca n'daataá. Ní n'dai taavi daiyá nī chí 'cuūndi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Du'ū 'úú chí ndaā chɛɛcu Señor Ndyuūs yeⁿ'é chí yaa'ví yā 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ti taachí ch'iindiveéⁿ nduudu yeⁿ'e nī, dacua'ā yeⁿ'é nuⁿ'u chɛɛ̄tí tan'dúúcā chi yeenu taavi yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dɛ'ɛ̄ chúúcā n'dai dii chí chi'téénu di caati cúúví cuaacu tan'dúúcā chi Señor Ndyuūs caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tuu'mi María ní caⁿ'a yā: Alma yeⁿ'é i'teenú taavi Ndyuūs ní dich'ɛɛtɛ́ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ní staava yeⁿ'é ní yeenú n'dai chi i'teenú Ndyuūs. Ní Ndyuūs nadinguáⁿ'ai yā 'úú yeⁿ'e nuuⁿndi yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ti Ndyuūs n'diichí yā 'úú chi pobre 'úú ní dichii'vɛ́ Ndyuūs, ti ndíí maaⁿ nducyáácá 'iiⁿ'yāⁿ caaⁿ'maⁿ yā yeⁿ'e 'úú: Dɛ'ɛ chúúcā n'dai 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ti Ndyuūs chi vɛ́ɛ́ taaví poder yeⁿ'é yā diíⁿ yā nduucú cosas chí ch'ɛɛtɛ n'dai. Ní Ndyuūs ní dɛɛ̄vɛ̄ taaví yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ní Ndyuūs ya'ai 'iinu taaví yā caavā nducyaaca 'iiⁿ'yāⁿ chi i'téénu yā yeⁿ'e yā tiempo chi chó'ōo, 'tiicá ntúūⁿ tiempo maaⁿ, ní 'tiicá ntúūⁿ tiempo chi cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dendyuūs 'āā diiⁿ yā vaadī n'dai ch'ɛɛtɛ ndúúcū poder yeⁿ'é yā, níícú diíⁿ yā ganar yeⁿ'e staava yeⁿ'é 'iiⁿ'yāⁿ chi dich'ɛɛtɛ́ yā maáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ndyuūs divíi yā 'iiⁿntyéⁿ'ē chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e trono yeⁿ'é yā, ní dich'ɛɛtɛ́ yā 'iiⁿ'yāⁿ ndiicúúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndyuūs ca'á yā cosas chi n'dai taavi 'iiⁿ'yāⁿ chí ch'iindiveéⁿ yā yeⁿ'e yā. Ní nguɛ́ɛ́ diíⁿ yā dɛ'ɛ̄ vɛɛ cáávā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ neⁿ'é yā chi Ndyuūs nneé yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ndyuūs chinneé yā s'uuúⁿ chi 'iiⁿ'yāⁿ yeⁿ'e Israel ti dichíí'vɛ yú 'iiⁿ'yāⁿ. Ní nn'gaacú yā yeⁿ'e s'uuúⁿ ní nduuvi ya'áí taaví yā yeⁿ'e s'uuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ndyuūs cueⁿ'e daāⁿmaⁿ idiíⁿ yā tan'dúúcā chi caⁿ'a yā 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'e yú, ní ndúúcū chiida yú Abraham ndúúcū 'iiⁿ'yāⁿ yeⁿ'é yā ndíí cuaaⁿ vmnaaⁿ. 'Túúcā ngaⁿ'a María miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tuu'mi ní María miiⁿ canée yā ndúúcū Elisabet tan'dúúcā 'íínú 'iiyū. Cuayiivi ní cunaⁿ'á yā na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Taachí snuū ca'ā 'iīyū yeⁿ'e dacua'ā miiⁿ, Elisabet miiⁿ ch'iindiyaāⁿ 'áámá daiya yā chi saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Iiⁿ'yāⁿ na niiⁿnuúⁿ va'āī ndúúcū 'iiⁿ'yāⁿ yeⁿ'é yā yeenú n'dai yā ndúúcu yā taachí ch'iindiveéⁿ yā chi Ndyuūs ní ya'ai taaví yā Elisabet miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ch'iinū dacua'ā 'lííⁿ niiⁿníⁿ nguuvi, ní 'iiⁿ'yāⁿ ndāa yā na vaacú Elisabet chi diiⁿ yā circuncidar dacua'ā miiⁿ. Níícú 'iiⁿ'yāⁿ s'eeⁿ neⁿ'é yā cu'neeⁿ yā chi cuuvi nguuvi sá Zacarías tan'dúúcā chi nguuvi chiida sa Zacarías. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Naati chɛɛcu sa mííⁿ caⁿ'a yā: Nguɛ́ɛ́ 'tíícā. Juan cuuvi ngúúví sá. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tuu'mi caⁿ'a 'iiⁿ'yāⁿ s'eeⁿ chíi yā chɛɛcu sá miiⁿ: ¿Dɛ́'ɛ cáávā? Mar 'áámá 'iiⁿ'yāⁿ yeⁿ'e nī nguɛ́ɛ́ nguuví yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ndúúcū chi ditá'a yā ntiinguunéeⁿ yā chiida sa taacā néⁿ'e yā chi cuūvī ngúúví sá. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías miiⁿ ní 'neeⁿ ta'á yā naachi canee 'áámá caaca ní dingúuⁿ yā chuū: Chí Juan duuchi sa. Tuu'mi ní nducyaaca 'iiⁿ'yāⁿ ní cueⁿ'e yiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Caati hora mííⁿ nūuⁿ, Zacarías miiⁿ nacan'dáā nduudu yeⁿ'e yā. Níícū tuu'mi tuca'á yā caⁿ'a yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ní nducyáácá 'iiⁿ'yāⁿ niiⁿnuúⁿ va'aī 'dii'ya taavi cá yā chiī. Ní yeⁿ'e chi chó'ōo, chuū ní caⁿ'a nducyáácá 'iiⁿ'yāⁿ na yáāⁿ chi snúūⁿ cuaaⁿ yaⁿ'āī yeⁿ'e chi snéé na yiīcū s'eeⁿ yeⁿ'e yáⁿ'āa Judea. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ní nducyáácá 'iiⁿ'yāⁿ chi cadiinuuⁿ yā yeⁿ'e chuū ní nacádiinuuⁿ yā na staava yeⁿ'e yā. Ní caⁿ'a yā 'áámá yā ndúúcū taama yā: ¿Dɛ'ɛ̄ cuuvi ndúúcū dacua'a 'lííⁿ chi 'tíícā? Caati 'tíícā Dendyuūs miiⁿ ní canéé ndúúcū dacua'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, chiídāa dacua'āa miiⁿ, chiitúú 'iiⁿ'yāⁿ ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs ní caⁿ'a Zacarías nduudu chí caⁿ'a Ndyuūs chí caaⁿ'máⁿ yā. Ní caⁿ'a yā tan'dúúcā 'áámá profeta chi candɛɛ nduudu yeⁿ'é Ndyuūs: ");
INSERT INTO cuxNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dɛ'ɛ̄ chúúcā n'dai Señor Ndyuūs yeⁿ'e 'iiⁿ'yāⁿ Israel chi ndāa yā nanaaⁿ s'uuúⁿ chi nadinguáⁿ'ai yā s'uuúⁿ, ní yeⁿ'é yā s'uuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ní tee yā s'uūúⁿ 'áámá 'iiⁿ'yāⁿ chi nééné vɛɛ poder yeⁿ'e yā chi nadinguáⁿ'ai yā s'uūúⁿ chi 'iiⁿ'yāⁿ miiⁿ yeⁿ'e ndaata yeⁿ'e rey David chi dichíí'vɛ̄ Ndyuūs ndíí cuaaⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ní Ndyuūs diíⁿ yā chí cuaacu tan'dúúcā chi caⁿ'a yā cáávā nduudu yeⁿ'e profetas chí caⁿ'a yā tiempo chi 'āā 'naaⁿ n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ní caⁿ'a yā chi Ndyuūs nadinguáⁿ'ai yā s'uuúⁿ yeⁿ'e 'iiⁿ'yāⁿ chi taáⁿ yā yeⁿ'e yú. Ní nadinguáⁿ'ai yā s'uuúⁿ yeⁿ'e nducyáácá 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii n'diichí yā s'uuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ní neene ya'ai 'iinú Ndyuūs 'iiⁿ'yāⁿ yeⁿ'e yú ndíí cuaaⁿ vmnaaⁿ, ní nan'gaacú yā yeⁿ'ē chi caⁿ'a yā chi diiⁿ yā chi n'daacā ndii cuááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Chuū ní compromiso chi Ndyuūs caⁿ'ā cuaacu yā ndúúcū chiida yú Abraham chi tee yā s'uuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Taachi Ndyuūs nadanguáⁿ'ai yā s'uuúⁿ yeⁿ'e 'iiⁿ'yāⁿ chi nduuvi tááⁿ yā yeⁿ'ē yú, diíⁿ yā 'túúcā caati dichíí'vɛ̄ yú Ndyuūs ní nguɛ́ɛ́ nduūcū vaadī 'va'a. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Tanducuéⁿ'ē vida yeⁿ'e yú ní dichíí'vɛ yú Ndyuūs, ní diiⁿ yú tan'dúúcā 'iiⁿ'yāⁿ chi dɛɛvɛ ní n'dai nanááⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Díí, saⁿ'ā 'lííⁿ chi daiyá, cūnee chi dúúchí dí profeta yeⁿ'é Ndyuūs chi ch'ɛɛtɛ n'dai chi canéé na va'ai chɛɛti nguuví caati caⁿ'ā di cuááⁿ vmnaaⁿ yeⁿ'e Señor Jesucristo. Ní 'cuūndiyāaⁿ di 'iiⁿ'yāⁿ s'eeⁿ chi 'cuɛɛtinéé ngiinu yā taachi ndaa Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ní diiⁿ di chi 'iiⁿ'yāⁿ cadiinúúⁿ yā yeⁿ'e chí nguaⁿ'ai yā yeⁿ'e nuuⁿndi yeⁿ'e yā ní Ndyuūs nadich'ɛɛcú yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ní cucáávā Ndyuūs yeⁿ'ē yú nééné ya'ai 'iinú yā s'uuúⁿ tee yā 'áámá dɛɛvɛ yeⁿ'e yā s'uuúⁿ, dɛɛvɛ chi chiīcā yeⁿ'e va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ní chi dɛɛvɛ miiⁿ chíi Ndyuūs ní cuuvi dɛɛvɛ́ yā yeⁿ'e nducyaaca 'iiⁿ'yāⁿ chi snée yā na maāiⁿ ndúúcū nuuⁿndi yeⁿ'é yā. Ní Ndyuūs nacandɛ́ɛ yā s'uuúⁿ na yúúní yeⁿ'e vaadī 'diīíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ní saⁿ'ā 'lííⁿ ní ch'iita sa ní 'āā deenū sa ní ditiīnú sa na espíritu yeⁿ'ē sa. Ní taachi 'āā ch'ɛɛtɛ sa, saⁿ'ā miiⁿ ní cueⁿ'e sa cuɛɛti ní canee sa miiⁿ ndii ndaa tiempo taachi caⁿ'a sa nduudu cuaacu yeⁿ'é Ndyuūs nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e Israel. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nguuvi s'eeⁿ emperador Augusto César caⁿ'a ntiiⁿnyúⁿ yā chi 'cuɛɛtinéé nguūⁿ nducyaaca 'iiⁿ'yāⁿ yeⁿ'e núúⁿmáⁿ yáⁿ'āa naachi caⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ní taachi Cirenio ní gobernador yā yeⁿ'e yáⁿ'āa Siria, 'āā diíⁿ yā chuū chí n'gɛɛtinéé nguuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ní nducyaaca 'iiⁿ'yāⁿ snaⁿ'a yā na yáāⁿ naachi ch'iindiyáaⁿ yā ní ca'a yā chi ngúúví yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","'Tíícā chiī José miiⁿ ní n'dāa yā na yáāⁿ Nazaret miiⁿ yeⁿ'ē yáⁿ'āa Galilea ní ndaá yā na yaāⁿ Belén yeⁿ'e yáⁿ'āa Judea. Yáāⁿ miiⁿ ní duuchi Yáaⁿ yeⁿ'e David caati José miiⁿ ní na ndaata yeⁿ'ē rey David miiⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Cueⁿ'e José miiⁿ ndúúcū María ti chiida tá ndúúcū chɛɛcu tá dīiⁿ yā prometer chi 'caandavaacu tá ndúúcū José miiⁿ. María miiⁿ ní vɛ́ɛ́ daiya tá chɛɛti tá. Miiⁿ ní ndaá yā ca'a yā ngúúví yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Taachi miiⁿ snée yā, snuū ca'a nguuví yeⁿ'ē María miiⁿ chi 'cuundiyaāⁿ daiya yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Miiⁿ ch'iindiyaāⁿ saⁿ'a 'lííⁿ, daiya tá chi vmnááⁿ vmnaaⁿ, ní chɛɛcú yā tíínūuⁿ saⁿ'a 'lííⁿ, ní sn'diití yā saⁿ'ā 'lííⁿ miiⁿ naachi snúúⁿ 'iiti. Ní ch'ɛɛtinee yā miiⁿ caati nguɛ́ɛ́ ndaacá yā va'āī chi n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ná campo yeⁿ'ē yáāⁿ Belén miiⁿ vɛ́ɛ́ 'iiⁿ'yāⁿ chi snéé cuidado 'iiti cuūchī. Ní n'gɛɛtí nduuchí yā n'gaaⁿ na cuɛɛti cucáávā 'iiti cuūchī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ní n'gaāⁿ miiⁿ 'áámá ángel chi Señor Ndyuūs dichō'o yā che'enaáⁿ yā nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ chi snéé cuidado 'iiti cuūchī. Ní chi dɛɛvɛ ch'ɛɛtɛ n'dai yeⁿ'é Ndyuūs chiiya nanáaⁿ yā ní 'dii'yā n'dái yā chii. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angel miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī, nguɛɛ 'va'á nī ti 'úú nindɛɛ́ 'áámá nduudu chí n'dai níícú cuuvi yeenu taavi ndís'tiī ndúúcū nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tí maaⁿ ní na yáāⁿ yeⁿ'e David ch'iindiyáāⁿ cááva ndís'tiī 'áámá saⁿ'a 'lííⁿ chi nadanguáⁿ'ai yā 'iiⁿ'yāⁿ yeⁿ'ē nuuⁿndi yeⁿ'e yā. Saⁿ'ā 'lííⁿ mííⁿ ní CRISTO chi Señor chi Ndyuūs dicho'ó yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ní deenú nī chi cuaacu ndúúcū señal 'cūū. Ndís'tiī ní nndaaca nī dacua'ā mííⁿ ndɛɛcu tíínūu ní candiiti sa na lugar naachí snúúⁿ 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hora mííⁿ nūuⁿ n'deee n'dáí ángeles yeⁿ'ē va'ai chɛɛti nguuvi che'enaáⁿ yā naachi canéé ángel miiⁿ. Angeles ní ngaⁿ'a yā chi ch'ɛɛtɛ n'dai Ndyuūs miiⁿ. 'Tíícā ngaⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ch'ɛɛtɛ n'dáí Ndyuūs chi canée na va'ai chɛɛti nguuvi. Ni vɛ́ɛ́ vaadī 'diīíⁿ na yáⁿ'āa nguaaⁿ 'iiⁿ'yāⁿ chi cunéé n'daacā n'dai ti snée yā ndúúcū favor yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cho'ōo chúū ní ángeles s'eeⁿ cunaⁿ'á yā va'ai chɛɛti nguuvi. Saⁿ'a chi snéé cuidado 'iiti cuūchī miiⁿ caⁿ'a sa chii sa vi'ī: Cú'u yú maaⁿ na yáāⁿ Belén ní n'diichi yú chuū chi Señor Ndyuūs miiⁿ chii yā s'uūúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Maaⁿnch'ɛɛtɛ́ nūuⁿ cueⁿ'e yā. Ní ndaacá yā María ndúúcū José, ndúúcū saⁿ'ā 'lííⁿ dacua'a miiⁿ cándiiti sa na lugar naachi snúūⁿ 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ní taachi n'diichí yā saⁿ'ā 'lííⁿ mííⁿ, caⁿ'a yā chii yā 'iiⁿ'yāⁿ tan'dúúcā ángel caⁿ'a yā chii yā maáⁿ yā yeⁿ'é dacua'a miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nducyáácá 'iiⁿ'yāⁿ chi ch'iindiveéⁿ yā chuu chí caⁿ'a 'iiⁿ'yāⁿ chi snéé cuidado 'iiti cuūchī cueⁿ'ē yiinu taaví yā yeⁿ'e chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Naati María miiⁿ ní nguain'dai yā nducuéⁿ'ē chuū na staava yeⁿ'e tá. Ní nacadíínuuⁿ yā dɛ'ɛ̄ cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'Iiⁿ'yāⁿ chi snéé cuidado 'iiti cuūchī cuínaⁿ'a yā ní ngaⁿ'a yā chi ch'ɛɛtɛ n'dai Dendyuūs. Ní s'téénu yā Ndyuūs yeⁿ'e tanducuéⁿ'ē chi ch'iindiveéⁿ yā ní n'diichi yā ti tan'dúúcā chi ángel miiⁿ caⁿ'á yā chii yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ch'iinu dacua'ā miiⁿ nííⁿníⁿ nguuvi ní ndaā nguuvi chi diíⁿ yā circuncidar dacua'ā miiⁿ. Ní s'néeⁿ yā chi nguuvi JESÚS, tan'dúúcā chi caⁿ'a ángel miiⁿ cuááⁿ vmnaaⁿ ndíí taachi 'āā cuɛ́ɛ sa chɛɛti María. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Taachí snuū ca'a niiⁿniⁿ nguuvi chi 'aama n'daataá ní canéé dɛɛvɛ taachi vɛ́ɛ́ dacua'a 'lííⁿ yeⁿ'e tá tan'dúúcā chi canéé nguūⁿ na ley yeⁿ'e Moisés, tuu'mi ní José ndúúcū María candɛ́ɛ yā dacua'ā miiⁿ na yáāⁿ Jerusalén. Candɛ́ɛ yā chi diíⁿ yā presentar dacua'ā miiⁿ nanááⁿ Señor 'iivú Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","'Tíícā caⁿ'a yā diíⁿ yā ti canéé nguūⁿ na ley yeⁿ'e 'iiví Ndyuūs chi tanducuéⁿ'ē dacuá'āa, chi vmnááⁿ vmnaaⁿ chi 'cuundiyáāⁿ yeⁿ'ē chɛ́ɛ́cūu chi sáⁿ'ā canéé lado yeⁿ'é Ndyuūs. 'Tííca chiiⁿ chi diíⁿ yā chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ní cheⁿ'e yā ca'a yā ofrenda yeⁿ'e 'áámá n'daataá chi 'cuundiyáāⁿ daiya tá tan'dúúcā chi ngaⁿ'a ley yeⁿ'e Señor 'iivú Ndyuūs. Ofrenda miiⁿ ní ná 'uūvī 'yaada palomas o na 'uūvī 'yaada pichones. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na yáāⁿ Jerusalén miiⁿ canee 'aama saⁿ'ā chi nguuvi sa Simeón. Sáⁿ'a 'cūū ní nééné n'dai sa ní chiⁿ'i sá chi i'téénu sa Ndyuūs, ní yeⁿ'é Ndyuūs saⁿ'ā. Canéé Espíritu N'dai yeⁿ'é Ndyuūs ndúúcū sa. Ní cánéé ngiinu sa 'áámá 'iiⁿ'yāⁿ chi nadanguáⁿ'āī 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu N'dai yeⁿ'é Ndyuūs chīi yā saⁿ'á 'cūū chi nguɛ́ɛ́ canéé chi 'cuūvī sa neⁿ'e chí 'āā cuɛ́ɛ́ n'diichi sá Cristo chi Señor Ndyuūs dichó'ó yā íⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ní Espíritu N'dai yeⁿ'é Ndyuūs canéé ndúúcū Simeón miiⁿ. Ní diiiⁿ guiar Simeón miiⁿ. Ní cueⁿ'é yā na yaācū templo taachi José miiⁿ ndúúcū María ndāa yā na yaacū templo ndúúcū saⁿ'a 'lííⁿ Jesús miiⁿ. Ní 'íícú cuuvi diíⁿ yā presentar dacua'a miiⁿ nanááⁿ Ndyuūs tan'dúúcā chi ngaⁿ'a ley miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Tuu'mi ní Simeón miiⁿ ca'nuúⁿ yā Jesús ní caⁿ'a yā chi ch'ɛɛtɛ n'dai Dendyuūs. 'Túúcā caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Maaⁿ ní n'diī Señor Ndyuūs, diíⁿ nī chi cuaacu tan'dúúcā chi ngaⁿ'ā nduudu yeⁿ'e nī. Maaⁿ ní diíⁿ nī chí cuuví 'cuūví nduucú n'dai, 'úú chí dichii'vɛ́ n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Caati 'āā n'diichí ndúúcū nduutinaáⁿ 'iiⁿ'yāⁿ chi dichó'o nī chi inadanguáⁿ'āī nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'Iiⁿ'yāⁿ miiⁿ chííⁿ chí s'néeⁿyaáⁿ nī chi cáávā nducyaaca 'iiⁿ'yāⁿ chí nadanguáⁿ'ai yā 'iiⁿ'yāⁿ yeⁿ'e nuuⁿndí yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Iiⁿ'yāⁿ miiⁿ chí dɛɛvɛ ní cuuví dɛɛvɛ yeⁿ'ē nducyaaca 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'ē ndaata Israel. Ní ca'a yā honor 'iiⁿ'yāⁿ yeⁿ'e nī chi 'iiⁿ'yāⁿ Israel yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José ndúúcū María ngeⁿ'e yiinu yā yeⁿ'e chi Simeón ngaⁿ'a yā yeⁿ'e saⁿ'ā 'lííⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón miiⁿ di'viicú yā María ndúúcū José. Ní caⁿ'a yā chii yā chɛɛcu sa María: 'Caandiveéⁿ nī. Saⁿ'ā 'lííⁿ 'cūū ndaā sa chi neené 'yaaⁿ 'iiⁿ'yāⁿ na yáⁿ'āa nguɛ́ɛ́ i'téénu yā ní 'tiicá ntúūⁿ 'yaaⁿ 'iiⁿ'yāⁿ cu'téénu yā. Ní saⁿ'a 'lííⁿ 'cūū 'áámá seña ti nééné 'yaaⁿ 'iiⁿ'yāⁿ caaⁿ'maⁿ yā contra yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chuū ní diīiⁿ chi 'iiⁿ'yāⁿ cuuvi cádiinuuⁿ yā yeⁿ'e ca'áámá cā'aama 'iiⁿ'yāⁿ taacā nadicádiinuuⁿ yā na staava yeⁿ'e yā. Chuū ní tan'dúúcā 'áámá machete 'uūvī lados 'caāiⁿ chi cho'ōo alma yeⁿ'e n'diī María. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ná yaacú templo 'cūū, mííⁿ ntúūⁿ canee 'áámá n'daataá n'dai chi nguuvi Ana. Ní ngaⁿ'a tá dendu'ū chi cuchiī. N'daataá miiⁿ ní daiya Fanuel, chí yeⁿ'e ndaataá yeⁿ'e Aser. Ní Ana miiⁿ 'āā neené ndiicúú ta. Ch'iindivaacu tá taachi 'lííⁿ tá ní ndɛɛ̄chɛ̄ ndúuyū nūuⁿ cánee tá ndúúcū isaⁿ'ā yeⁿ'e tá. Maaⁿ ní 'āā n'daataá nguá'ā tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","'Āā cuūuⁿ ngɛɛcú cuūuⁿ nduuyúū chi nduuví tá n'daataá nguá'āa. 'Áámá canee tá na yáacū templo yeⁿ'é Ndyuūs ní canée tá ndíí nguuvi ndii n'gaaⁿ ní dichíí'vɛ tá Ndyuūs. Ní ndii nguɛɛ nga'diinú tá ti dámaāⁿ chí ngaⁿ'āngua'a tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Hora mííⁿ nūuⁿ Ana miiⁿ cheⁿ'e tá yaacū templo ní ndee tá nduucú Dendyuūs, 'tíícā ngaⁿ'a ta: N'dii, Ndyuūs teé gracias n'dii cáávā dacua'a 'lííⁿ miiⁿ. Cuayiivi ní caⁿ'a ta chiī ta nducyáácá 'iiⁿ'yāⁿ chi canéé ngiinu 'áámá 'iiⁿ'yāⁿ chi nadinguáⁿ'ai yā 'iiⁿ'yāⁿ Israel yā yeⁿ'ē saⁿ'ā 'lííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Taachi José ndúúcū María ch'iinu diíⁿ yā nducuéⁿ'ē chi ngaⁿ'a ley yeⁿ'e Señor Dendyuūs, tuu'mi ní cueⁿ'e ntuúⁿ yā ndúúcū saⁿ'ā 'lííⁿ na yáāⁿ vaacú yā chi nguuvi Nazaret yeⁿ'e yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Saⁿ'ā 'lííⁿ Jesús miiⁿ ngiita sa ní ngii ditiīnu sa. Nééné deenu sa. Ní Ndyuūs di'viīcú taavi cá yā saⁿ'ā 'lííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nduuyu nduuyu taachi ndaā tiempo yeⁿ'e 'viicu yeⁿ'e pascua, tuu'mi ní chiida Jesús ndúúcū chɛɛcu sa ngeⁿ'e yā yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ní taachi Jesús chii yā ndiichúúví nduūyū, 'iiⁿ'yāⁿ s'eeⁿ cueⁿ'e ntúuⁿ yā na yáāⁿ Jerusalén ndúúcū Jesús miiⁿ tan'dúúcā chi 'āā ngeⁿ'e yā nduuyu nduuyu cáávā 'viicú mííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cho'ōo 'viicú miiⁿ, ní José ndúúcū María miiⁿ ní cunaⁿ'a yā. Nguɛ́ɛ́ tuumicadíínuuⁿ yā chi saⁿ'ā 'lííⁿ Jesús miiⁿ canee sá na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'Iiⁿ'yāⁿ s'eeⁿ ní nadicadíínuuⁿ yā chi Jesús miiⁿ ní cunaⁿ'a sa ndúúcū 'iiⁿ'yāⁿ parientes yeⁿ'e yā. 'Iiⁿ'yāⁿ s'eeⁿ núúⁿmáⁿ nguuvi ní chiica yā. Tuu'mi nan'nuúⁿ yā Jesús nguaaⁿ 'iiⁿ'yāⁿ yeⁿ'e yā ndúúcū 'iiⁿ'yāⁿ chi n'dai nduucú yā, ");
INSERT INTO cuxNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","naati nguɛ́ɛ́ ndaacá yā saⁿ'ā 'lííⁿ Jesús miiⁿ. Ní nguɛɛcunée yā snaⁿ'a yā na yáāⁿ Jerusalén miiⁿ chi n'nuúⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ndíí ch'iinu 'iīnū nguuvi ní ndaacá yā Jesús na yáacū templo. Vɛ́ɛ́ sá ndúúcū maestros chí ngi'cuéeⁿ yā ley. Jesús miiⁿ ní í'neeⁿ veeⁿ sa chí ngaⁿ'a yā ní tiinguuneeⁿ sá maestros yeⁿ'e chi ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nducyáácá 'iiⁿ'yāⁿ chi n'giindiveéⁿ yā chí ngaⁿ'ā saⁿ'a 'lííⁿ Jesús miiⁿ ngeⁿ'e yíínú yā yeⁿ'e sa chi déénu sa ní nan'guɛɛcútaⁿ'ā sa chí ítiingúúneeⁿ yā saⁿ'a 'lííⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Taachí chíídá sá ndúúcū chɛɛcu sa n'diichí yā Jesús miiⁿ cueⁿ'e yiinú yā yeⁿ'ē sa. Tuu'mi ní chɛɛcu sa ní caⁿ'á yā chiī yā saⁿ'ā 'lííⁿ: Díí, daiyá, ¿dɛ'ɛ̄ cuuvi chi 'tíícā diīⁿ di nduucú 'nū? Cuin'dííchí dí. Chiida di ndúúcū 'úú ya'āī n'dai staava yeⁿ'é 'nū 'íícú chiicá 'nū in'nuúⁿ 'nū dii. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tuu'mi ní nan'guɛɛcútaⁿ'ā sa yeⁿ'é yā: ¿Dɛ́'ɛ̄ vɛɛ? ¿Dɛ́'ɛ̄ cúúví chi in'nuúⁿ nī 'úú? ¿'Áá nguɛ́ɛ́ deenu ndís'tiī chi 'úú ní canéé chí cūneé ndúúcū dendu'ū yeⁿ'e Chiidá? ");
INSERT INTO cuxNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ tuūmīcadiinúúⁿ yā nduudu chí caⁿ'a daiyá yā Jesús miiⁿ chii sá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tuu'mi ní cunaⁿ'a Jesús nduucú yā na yáāⁿ Nazaret miiⁿ ní 'neeⁿ veeⁿ sa yeⁿ'e yā. Chɛɛcu sa miiⁿ ní nadacadiinúúⁿ yā tanducuéⁿ'ē na staava yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús miiⁿ ní n'giita sa ndúúcū n'deee n'dáí vaadī deenu, níícú vɛ́ɛ́ favor yeⁿ'ē sa nanááⁿ Ndyuūs ní nanááⁿ 'iiⁿ'yāⁿ na iⁿ'yeeⁿdí 'cūū. Níícú 'āā ngɛɛ́nū nduuyu yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Saⁿ'a chi nguuvi Tiberio César, 'āā ndíítiiⁿ'yuⁿ nduūyū chi ngaⁿ'a ntiiⁿnyúⁿ yā chi emperador yā. Ní saⁿ'ā chi nguuvi Poncio Pilato, ní gobernador yā yeⁿ'e yáⁿ'āa Judea. Saⁿ'ā chi nguuvi Herodes ní rey yā yeⁿ'e yáⁿ'āa Galilea. 'Íícú 'diīnū Herodes miiⁿ chi nguuvi Felipe ní rey yā yeⁿ'ē yáⁿ'āa Iturea ndúúcū yáⁿ'āa Trachonite Ní saⁿ'ā chi nguuvi Lisanias ní rey yā yeⁿ'e yáⁿ'āa Abilinia. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ní saⁿ'a Anás ndúúcū Caifás, saⁿ'ā s'uuⁿ ní chiiduú n'gɛɛtɛ ca yeⁿ'e yaācū yeⁿ'e 'iiⁿ'yāⁿ Israel. Tiempo miiⁿ ní Ndyuūs ní ca'á yā 'áámá nduudu n'dai Juan, chí daiya Zacarías. Juan miiⁿ canee sa na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan miiⁿ ní cachiī ca sa nducuéⁿ'ē yáⁿ'āa chi snéé niiⁿnuúⁿ ná yíícú Jordán. Ní Juan miiⁿ chii sá 'iiⁿ'yāⁿ chi canéé chi cuɛɛdínuūⁿniⁿ yā níícú ndaacadaamí yā yeⁿ'ē nuuⁿndi yeⁿ'é yā, níícú Ndyuūs nadich'ɛɛ̄cú yā nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chuū ní chiī tan'dúúcā chi profeta Isaías dingúuⁿ yā ndii cuaaⁿ vmnaaⁿ na libro yeⁿ'e Ndyuūs yeⁿ'ē: 'Caandiveeⁿ yú nduudu yeⁿ'ē 'áámá 'iiⁿ'yāⁿ chi caaⁿ'máⁿ yā yuudū na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ ní caⁿ'a yā 'tuuca: Cuundiyaáⁿ nī yúúní yeⁿ'e Señor Ndyuūs caati cuchii yā; nan'guáaⁿ nī 'aama yúúní cuaacu caavá yā. Didɛɛvɛ́ nī staava yeⁿ'é nī ní cuuvi 'cuaáⁿ nī 'iiⁿ'yāⁿ miiⁿ taachi ndaa yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Naachi yaanúū ní nduūtī, núúⁿmáⁿ icyaⁿ'ā ndúúcū nducyaaca yiīcū nduuví neⁿ'e, yúúní 'cuéē nduuvī cuaacu, yúúní chi nguɛ́ɛ́ neⁿ'e ní nduuví neⁿ'e. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nducyaaca 'iiⁿ'yāⁿ snaaⁿ yā 'iiⁿ'yāⁿ yeⁿ'e Ndyuūs, 'iiⁿ'yāⁿ chí nadinguáⁿ'ai yā nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan miiⁿ ní ngaⁿ'a sá ngii sa 'iiⁿ'yāⁿ chí ndaá yā chí cuɛɛdínuūⁿnīⁿ sa 'iiⁿ'yāⁿ: Ndís'tiī ní tan'dúúcā cúú 'tíícā ndís'tiī. ¿Du'ú chi 'cueeⁿ ndís'tiī chi cuuvi cáánu nī yeⁿ'e castigo taaⁿ chí cúchiī? ");
INSERT INTO cuxNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Diíⁿ nī dendu'ū chi n'dáacā maaⁿ níícú 'cuuⁿ'mí nī 'iiⁿ'yāⁿ chí 'āā ndaacadaamí nī yeⁿ'e nuuⁿndi yeⁿ'é nī. Nguɛɛ tucá'a nī caaⁿ'maⁿ nī nguaaⁿ maaⁿ nī chi Abraham miiⁿ ní chiidá nī caati 'úú ngaⁿ'á ngīi ndís'tiī chi Ndyuūs ní cuuvi diíⁿ yā chi tuūu s'eeⁿ ní chi cuuvi daiya Abraham. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ní cutiīiⁿ mííⁿ ní 'āā canéé na dii'yu yáⁿ'á. Nducyaaca yáⁿ'á chi nguɛ́ɛ́ ngii n'gui'i n'daacā yeⁿ'ē canee chi 'caaca yáⁿ'á mííⁿ ní cūnuuⁿ na yaⁿ'ā. 'Tiicá ntúūⁿ Ndyuūs diíⁿ yā juzgar nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Iiⁿ'yāⁿ s'uuⁿ ntiinguuneeⁿ yā Juan miiⁿ: ¿Dɛ'ɛ̄ cuuví diíⁿ 'nū? ");
INSERT INTO cuxNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan miiⁿ ní nan'guɛɛ̄cútaⁿ'ā sa: 'Iiⁿ'yāⁿ chi 'uuvī catecai yā, canéé chi ca'a yā 'áámá catecai 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā. 'Iiⁿ'yāⁿ chi vɛ́ɛ́ chi nge'e yā, canéé chi ca'a yā 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ndaá ntúūⁿ 'iiⁿ'yāⁿ chi inn'guɛɛ yeⁿ'e yáⁿ'āa chi Juan miiⁿ cuɛɛdínuūⁿnīⁿ sa 'iiⁿ'yāⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ caⁿ'a yā chii yā Juan: N'dií, maestro, ¿dɛ'ɛ̄ cuuví diíⁿ 'nū? ");
INSERT INTO cuxNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan miiⁿ ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: Nguɛ́ɛ́ caaca nī chi mar 'aama ndo'o tan'dúúcā chí ngaⁿ'a na ley. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tuu'mi ní soldados tiinguunééⁿ sá Juan: Nús'uu, ¿dɛ'ɛ̄ cuuvi diíⁿ 'nū? Ní Juan caⁿ'a sa chii sa 'iiⁿ'yāⁿ: Nguɛ́ɛ́ diduucú nī yeⁿ'ē mar 'áámá 'iiⁿ'yāⁿ. Nguɛ́ɛ́ cunncáā caaⁿ'maⁿ nī yeⁿ'ē tanáⁿ'ā 'iiⁿ'yāⁿ. Níícú 'cuɛɛtinéé nī ndúúcū vaadi yeenú ndúúcū chi inadíí'vɛ yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","'Iiⁿ'yāⁿ s'uuⁿ snee yiinu yā Juan ní nducyaaca yā ní nadicádíínuuⁿ yā na staava yeⁿ'e yā chi ¿'áá nguɛ́ɛ́ Juan chí Cristo? ");
INSERT INTO cuxNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tuu'mi ní Juan miiⁿ ní caⁿ'a sa chii sa nducyaacá yā: Cuaacu nííⁿnyúⁿ 'úú ní ngɛɛdínuūⁿníⁿ ndúúcū nuūⁿnīⁿ; naati cuayiivi cuchiī taamá yā chí n'dáácā n'dai ca ndúúcū poder yeⁿ'é yā chí ch'ɛɛtɛ taavi nguɛ́ɛ́ ti 'úú. Ní 'úú ní nguɛ́ɛ́ n'daācā ca chi cuuvi diíⁿ n'daatií yííⁿmáⁿ yeⁿ'e ndaacuú yeⁿ'é yā. 'Iiⁿ'yāⁿ miiⁿ ní cuɛɛdínuūⁿniⁿ yā ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs ndúúcū yaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","'Iiⁿ'yāⁿ miiⁿ ndɛ́ɛ yā ní diiⁿ yā tan'dúúcā 'iiⁿ'yāⁿ chi didɛɛvɛ́ yā trigo. 'Tíícā diíⁿ yā ndúúcū 'iiⁿ'yāⁿ. Ndáa yā ndúúcū zaranda na ta'a yā. Naachí nadɛɛvɛ́ yā trigo miiⁿ, divíi yā trigo miiⁿ ní nguain'dai yā chɛɛti díínūuⁿ. Ní 'neeⁿ yáⁿ'a yā dɛɛcú miiⁿ na nguuchí yaⁿ'ā chí 'āā ntɛ́ɛ n'tuūvi. Dɛɛcú miiⁿ ní tan'dúúcā 'iiⁿ'yāⁿ chí nguɛ́ɛ́ i'téénu yā Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","'Túúcā ní ndúúcū n'deee n'dáí ca chi caⁿ'ā Juan miiⁿ, caⁿ'a sá chi 'cueeⁿ sa nduudu n'dai chí ngai 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tiempo miiⁿ Juan miiⁿ ní yaa'vi neeⁿ sa rey Herodes miiⁿ chi canéé sá ndúúcū n'daataá yeⁿ'ē 'díinū sa ní yeⁿ'e tanducuéⁿ'ē chi nguɛɛ n'daācā chi diíⁿ yā. N'daataá miiⁿ ní nguuvi tá Herodías. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tuu'mi ní rey Herodes miiⁿ ní diíⁿ yā táámá nuuⁿndi chi ch'ɛɛtɛ ca ní s'nuūⁿ chiichí yā Juan vácūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cuayiivi taachí Juan ngɛɛdínuūⁿniⁿ yā n'deee n'dáí 'iiⁿ'yāⁿ, chɛɛ̄dinúūⁿniⁿ ntúūⁿ yā Jesús miiⁿ. Ní taachi Jesús miiⁿ ngaⁿ'angua'á yā nánguuvi ní nánguaāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ní ndaā Espíritu N'dai yeⁿ'é Ndyuūs vmnaaⁿ yeⁿ'é yā tan'dúúcā 'áámá paloma. Ní 'iiⁿ'yāⁿ s'eeⁿ ch'iindivéeⁿ yā 'áámá nduudu yeⁿ'ē va'ai ch'ɛɛti nguuvi chí ngaⁿ'ā: Díí, daiyá chi neⁿ'e taaví ní yeenú taavi cáávā dii. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús miiⁿ ní chií yā ndíícú ndiichi ndúuyū taachí tucá'a yā ntííⁿnyúⁿ yeⁿ'é yā. Ndaata yeⁿ'e Jesús ní 'tíícā: 'Iiⁿ'yāⁿ nadicádíínuuⁿ yā chi Jesús miiⁿ ní daiya José. José miiⁿ ní daiya Elí. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí miiⁿ ní daiya Matat. Matat miiⁿ ní daiya Leví. Leví miiⁿ ní daiya Melqui. Melqui miiⁿ ní daiya Jana. Jana miiⁿ ní daiya José. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José miiⁿ ní daiya Matatías. Matatías miiⁿ ní daiya Amós. Amós miiⁿ ní daiya Nahum. Nahum miiⁿ ní daiya Esli. Esli miiⁿ ní daiya Nagai. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai miiⁿ ní daiya Maat. Maat miiⁿ ní daiya Matatías. Matatías miiⁿ ní daiya Semei. Semei miiⁿ ní daiya José. José miiⁿ ní daiya Judá. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá miiⁿ ní daiya Joana. Joana miiⁿ ní daiya Resa. Resa miiⁿ ní daiya Zorobabel. Zorobabel miiⁿ ní daiya Salatiel. Salatiel miiⁿ ní daiya Neri. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri miiⁿ ní daiya Melqui. Melqui miiⁿ ní daiya Adi. Adi miiⁿ ní daiya Cosam. Cosam miiⁿ ní daiya Elmodam. Elmodam miiⁿ ní daiya Er. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er miiⁿ ní daiya Josué. Josué miiⁿ ní daiya Eliezar. Eliezar miiⁿ ní daiya Jorim. Jorim miiⁿ ní daiya Matat. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat miiⁿ ní daiya Leví. Leví miiⁿ ní daiya Simeón. Simeón miiⁿ ní daiya Judá. Judá miiⁿ ní daiya José. José miiⁿ ní daiya Jonán. Jonán miiⁿ ní daiya Eliaquim. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim miiⁿ ní daiya Melea. Melea miiⁿ ní daiya Mainán. Mainán miiⁿ ní daiya Matata. Matata miiⁿ ní daiya Natán. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán miiⁿ ní daiya David. David miiⁿ ní daiya Isaí. Isaí miiⁿ ní daiya Obed. Obed miiⁿ ní daiya Booz. Booz miiⁿ ní daiya Salmón. Salmón miiⁿ ní daiya Naasón. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón miiⁿ ní daiya Aminadab. Aminadab miiⁿ ní daiya Aram. Aram miiⁿ ní daiya Esrom. Esrom miiⁿ ní daiya Fares. Fares miiⁿ ní daiya Fares. Fares miiⁿ ní daiya Judá. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá miiⁿ ní daiya Jacob. Jacob miiⁿ ní daiya Isaac. Isaac miiⁿ ní daiya Abraham. Abraham miiⁿ ní daiya Taré. Taré miiⁿ ní daiya Nacor. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor miiⁿ ní daiya Serug. Serug miiⁿ ní daiya Ragau. Ragau miiⁿ ní daiya Peleg. Peleg miiⁿ ní daiya Heber. Heber miiⁿ ní daiya Sala. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala miiⁿ ní daiya Cainán. Cainán miiⁿ ní daiya Arfaxad. Arfaxad miiⁿ ní daiya Sem. Sem miiⁿ ní daiya Noé. Noé miiⁿ ní daiya Lamec. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec miiⁿ ní daiya Matusalén. Matusalén miiⁿ ní daiya Enoc. Enoc miiⁿ ní daiya Jared. Jared miiⁿ ní daiya Mahalaleel. Mahalaleel miiⁿ ní daiya Cainán. ");
INSERT INTO cuxNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán miiⁿ ní daiya Enós. Enós miiⁿ ní daiya Set. Set miiⁿ ní daiya Adán. Adán miiⁿ ní yeⁿ'e Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús ní ndiituú yeⁿ'e Espíritu N'dai yeⁿ'é Ndyuūs 'iiⁿ'yāⁿ ní n'daa yā na yíícú Jordán. Espíritu N'dai yeⁿ'e Ndyuūs candɛ́ɛ yā Jesús na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Uūvī ngɛɛcu nguuvi caneé yááⁿn'guiinūuⁿ nanááⁿ Jesús miiⁿ chí n'diichineeⁿ sa 'iiⁿ'yāⁿ. Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ che'é Jesús nguuvi s'eeⁿ. Cuayiivi mííⁿ chiī cuiicú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tuu'mi ní yááⁿn'guiinūuⁿ caⁿ'a sa chii sa Jesús: Dii Jesús, ndúútí chi dii chi Daiya Dendyuūs dii caaⁿ'maⁿ dí cuuvi dí tuūu 'cúū chi nduuví pan. Ní nduuví pan ní cuuvi che'e di. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús nan'guɛɛcútáⁿ'a yā: 'Túúcā cánéé nguūⁿ ná libro yeⁿ'é Dendyuūs: Nguɛ́ɛ́ dámaāⁿ pan chɛ'ɛ́ 'iiⁿ'yāⁿ ní cunduūchí yā caati ndúúcū tanducuéⁿ'ē nduudu chi ngaⁿ'á Ndyuūs cunduuchí yā nduuti chi cu'téénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yááⁿn'guiinūuⁿ candɛ́ɛ sa Jesús na 'áámá yiīcū yáácú. Maaⁿ nch'ɛɛtɛ́ nūuⁿ ch'iⁿ'i sa Jesús tanducuéⁿ'ē naciones yeⁿ'ē íⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tuu'mi ní yááⁿn'guiinūuⁿ caⁿ'a sa chii sa Jesús. 'Úú ní teé dii nuuⁿmaⁿ iⁿ'yeeⁿdí 'cuū chi cuuví yeⁿ'ē di chi caaⁿ'maⁿ ntííⁿnyuⁿ dí yeⁿ'ē ndúúcū nuuⁿmáⁿ ch'ɛɛtɛ naciones 'cūū ndúúcū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'ē caati poder 'cūū yeⁿ'é. 'Āā du'ú nūuⁿ chi neⁿ'é chííⁿ chí ca'á. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ndúútī chi caantii'ya di nanaáⁿ níícú cu'téénu di 'úú cuuví yeⁿ'ē di tanducuéⁿ'ē chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: Dii yááⁿn'guiinūuⁿ cuvíi di nanaáⁿ caati 'túúcā canéé nguūⁿ na libro yeⁿ'e Dendyuūs: Cu'téénu di Señor Ndyuūs yeⁿ'ē di, ní dámaāⁿ 'caandiveeⁿ di yeⁿ'é 'iiⁿ'yāⁿ mííⁿ nūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Cuayiivi candɛ́ɛ yááⁿn'guiinūuⁿ Jesús miiⁿ na yáāⁿ Jerusalén ní cuchɛɛ sá ndúúcu yā na yáácú yeⁿ'ē yáacū templo. Ní caⁿ'a sa: Nduuti chi dii chi Daiya Dendyuūs dii, cáávā di ndii 'múúⁿ ndii na yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Caati 'túúcā canéé nguūⁿ cuááⁿ vmnaaⁿ na libro yeⁿ'é Ndyuūs: Ndyuūs dichó'o yā ángeles yeⁿ'e yā chi diíⁿ yā cuidado yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ní ángeles cundɛ́ɛ yā dii ndúúcū ta'á yā, ní nguɛ́ɛ́ cuuvi ya'ai ca'a di na tuūu. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús miiⁿ nán'guɛɛcútaⁿ'a yā: 'Tuucá ntúūⁿ canéé nguūⁿ na libro yeⁿ'é Ndyuūs: Nguɛ́ɛ́ diiⁿ di mar 'áámá cosa chí n'diichineeⁿ di Señor Ndyuūs yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Taachí ch'iinu chi diiⁿ yááⁿn'guiinūuⁿ chi n'diichineeⁿ sa Jesús divíi sa yeⁿ'é yā 'áámá tiempo. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús miiⁿ nnguɛɛcúnée yā na yáⁿ'āa Galilea ní canéé poder yeⁿ'e Espíritu N'dai yeⁿ'e Ndyuūs ndúúcu yā. Nducyáácá 'iiⁿ'yāⁿ chicadíínuuⁿ yā na nuuⁿmáⁿ na yáⁿ'āa cuaaⁿ 'diituú yeⁿ'e chi n'daācā n'dai idiíⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ní Jesús ngi'cueeⁿ yā na yaācū sinagogas yeⁿ'e 'iiⁿ'yāⁿ Israel yeⁿ'e nducuéⁿ'ē yáāⁿ ní nducyaaca 'iiⁿ'yāⁿ idich'ɛɛtɛ́ yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ndaá Jesús na yáāⁿ Nazaret naachí ch'iita yā. Ní tan'dúúcā chi costumbre yeⁿ'é yā, nguuvi sábado chí ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel ndáa yā na yaācū sinagoga miiⁿ ní Jesús chééndii yā ní ch'eeⁿ yā yeⁿ'e libro yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ní nan'guáaⁿ yā libro miiⁿ naachi ngaⁿ'a yeⁿ'ē profeta Isaías. Taachí nan'guaaⁿ yā libro miiⁿ, ndaacá yā naachi canéé nguūⁿ chúū: ");
INSERT INTO cuxNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Espíritu yeⁿ'é Ndyuūs canée yā nduucú, tí Espíritu N'dai yeⁿ'é Ndyuūs ndɛɛvɛ́ yā 'úú chi 'úú ní caaⁿ'máⁿ nduudu chí ngai yeⁿ'é Ndyuūs nanááⁿ 'iiⁿ'yāⁿ chí ndaachíī sneeⁿ ndúúcū nuuⁿndi yeⁿ'e yā. Dicho'ó yā 'úú chi diíⁿ chi nduūvā yenⁿ'e 'iiⁿ'yāⁿ chi yaⁿ'ai staava yeⁿ'e yā, ní caaⁿ'máⁿ chi nánguaⁿ'ai 'iiⁿ'yāⁿ yeⁿ'e nuuⁿndi yeⁿ'é yā chi tan'duucā chi ca'á libertad 'iiⁿ'yāⁿ chi snúūⁿ vácūū, ní diíⁿ chi inaaⁿ 'iiⁿ'yāⁿ cosa chi n'daacā chi nguɛ́ɛ́ déénu yā yeⁿ'ē caati maaⁿ canee yā tan'dúúcā 'iiⁿ'yāⁿ chi ngueenááⁿ, 'tiicá yā. Ní nadan'guaí 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daacā idiiⁿ ndúúcu yā caati cuuvi n'daacā idiiⁿ ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ní caaⁿ'máⁿ yeⁿ'e tiempo chi n'dai taavi chi Ndyuūs ndɛɛvɛ́ yā chi caaⁿ'máⁿ, yeⁿ'ē vaadī n'dai taavi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tuu'mi ní Jesús nan'gaadí yā libro yeⁿ'é Ndyuūs ní nanca'a yā 'iiⁿ'yāⁿ chi diíⁿ yā ntiiⁿnyuⁿ yeⁿ'e yaācū sinagoga miiⁿ. Ní cuayiivi Jesús ch'iindí yā. Nducyaaca 'iiⁿ'yāⁿ snee yā n'gíínu yā yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús tucá'a yā caⁿ'a yā 'iiⁿ'yāⁿ s'eeⁿ: Maaⁿ cunuuⁿ ca'a chuū chi canee nguūⁿ cuááⁿ vmnaaⁿ chi yeⁿ'e ndís'tiī, chuū chi ch'iinu ch'iindiveéⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nducyáácá 'iiⁿ'yāⁿ n'dáácā ngaⁿ'a yā yeⁿ'e Jesús. Ngeⁿ'e yíínú yā yeⁿ'ē nduudu chí n'dai chí ngaⁿ'a Jesús miiⁿ ní ngaⁿ'a yā: ¿'Áá nguɛ́ɛ́ sáⁿ'a 'cūū daiya José? ");
INSERT INTO cuxNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ní caⁿ'a Jesús miiⁿ: Ndís'tiī ní cuuví nī nduudu 'cūū 'úú. N'diī 'iiⁿ'yāⁿ chi déénu nī diiⁿ yiicú nī 'iiⁿ'yāⁿ, diiⁿ yiicú maáⁿ nī n'diī. Tanducuéⁿ'ē chi ch'iindiveéⁿ 'nū chi diíⁿ nī na yáāⁿ Capernaum, 'tiicá ntúūⁿ diíⁿ nī 'muuⁿ yáāⁿ vaacú nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Naati 'uu ní caⁿ'á chií ndís'tiī: Cuaacu nííⁿnyúⁿ mar 'áámá profeta ní nguɛ́ɛ́ ngíí inee yā na yáāⁿ vaacú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngīi ndís'tiī: Tiempo chi chó'ōo neené 'yaaⁿ n'daataá nguá'āa vɛɛ tá nguaaⁿ 'iiⁿ'yāⁿ Israel taachi profeta Elías cāneé yā iⁿ'yeeⁿdí 'cūu ní 'āā ntɛ́ɛ́ cheeⁿ cuuvi 'iinu ndúuyū canéé maⁿ'a tiempo miiⁿ. Ní ch'iīdī cuiicu nuuⁿmáⁿ yáⁿ'āa yeⁿ'e 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ní Ndyuūs nguɛ́ɛ́ dichó'o yā Elías miiⁿ nanááⁿ nducyaaca n'daataá nguá'āa, dámaāⁿ 'áámá n'daataá nguá'āa yeⁿ'e táámá nación. Ní canee tá na yáāⁿ Sarepta chi niiⁿnuúⁿ na yáⁿ'āa Sidón. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ní tiempo taachi canéé profeta Eliseo na iⁿ'yeeⁿdí 'cūū, 'tiicá ntúūⁿ nééné 'yaaⁿ 'iiⁿ'yāⁿ ndúúcū ca'ai chi lepra chí in'duuti yúutɛ̄ yeⁿ'e yā naati nguɛ́ɛ́ nducyaaca 'iiⁿ'yāⁿ s'eeⁿ nduuva yeⁿ'e yā, dámaāⁿ saⁿ'ā Naamán yeⁿ'e táámá nación chi yeⁿ'e yáⁿ'āa Siria. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Taachí 'iiⁿ'yāⁿ ch'iindiveéⁿ yā chuū nducyaaca yā na yaācū sinagoga miiⁿ neené nduuvi taaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ní ch'ɛɛti ndii yā tí neⁿ'é yā tun'daa yā Jesús cuaaⁿ chuva'āī yáāⁿ miiⁿ ní candɛ́ɛ yā Jesús miiⁿ ndii na yaacu n'dai yeⁿ'e yiīcū chi yaacú ca yeⁿ'e yáāⁿ miiⁿ. Ní 'iicu cuuví cun'dáa yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Naati nguɛ́ɛ́ cuuví diíⁿ yā ti Jesús miiⁿ ní cho'ó yā náávtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní cunaⁿ'a yā na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Cuayiivi Jesús nangua'áí yā na yáāⁿ Capernaum yeⁿ'e yáⁿ'āa Galilea ní miiⁿ ngi'cueeⁿ yā 'iiⁿ'yāⁿ nguuvi sábado chi nguuvi chí ntaavi'tuunúúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ní 'iiⁿ'yāⁿ na yáāⁿ miiⁿ ngeⁿ'e yiinú yā yeⁿ'e chi ngi'cueeⁿ Jesús, ti ngi'cueéⁿ yā ndúúcū poder tan'dúúcā 'áámá 'iiⁿ'yāⁿ chí ngaⁿ'ā ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ní taachi snee Jesús na yaacu sinagoga mííⁿ canee 'áámá saⁿ'ā ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ. Espíritu miiⁿ diiⁿ chi saⁿ'ā miiⁿ neené yuudu 'caī sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ní espíritu miiⁿ ní caⁿ'ā: N'diī, Jesús, yeⁿ'e yáāⁿ Nazaret, cu'néeⁿ nī nús'uu. ¿Dɛ́'ɛ̄ canee yeⁿ'é 'nū nduucú nī? ¿'Áá ndāa nī chi di'cuiīnú nī nús'uu? 'Úú n'diichí du'ú n'diī. N'diī ní 'Iiⁿ'yāⁿ chí N'dai chi Daiya Dendyuūs n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús ní yaa'vineeⁿ yā ní caⁿ'a yā: Dii espíritu n'gáádí dí cheendi di ní nan'dáa di yeⁿ'e sá 'tīī. Tuu'mi ní espíritu yeⁿ'e yááⁿn'guiinūuⁿ chíndɛɛ̄vɛ sa sáⁿ'a 'cūū náávtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní nan'daā sa yeⁿ'e sáⁿ'a 'cūū. Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ diīⁿ sa ndúúcū sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nducyaaca yā ní ngeⁿ'e yiinú yā ní ngaⁿ'a yā ngii yā vi'ī: ¿Dɛ́'ɛ̄ nduudu chi 'túúca? 'Iiⁿ'yāⁿ 'cúū ngaⁿ'a ntiiⁿnyúⁿ yā espíritu yeⁿ'e yááⁿn'guiinūuⁿ ndúúcū poder tan'dúúcā 'áámá 'iiⁿntyéⁿ'ē. Ngaⁿ'á yā chí nan'daā espíritu yeⁿ'e yááⁿn'guiinūuⁿ ní nacan'daā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ní nducyaaca 'iiⁿ'yāⁿ ngaⁿ'a yā yeⁿ'e Jesús miiⁿ nducuéⁿ'ē cuaaⁿ nducuéⁿ'ē yáāⁿ cuááⁿ 'diituú. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tuu'mi ní Jesús miiⁿ nan'dáa yā yaācū sinagoga miiⁿ ní ndaa yā va'ai yeⁿ'ē Simón Pedro. Ní indáⁿ'ā Simón Pedro miiⁿ ndɛ́ɛ̄ 'aama 'iiⁿ'nūⁿ taaⁿ n'daataá ní 'iiⁿ'yāⁿ yeⁿ'e vaacu tá di'cuíítu yā Jesús miiⁿ chi cunée yā ní nanduūvā yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús can'dii yā naachi canéé n'daataa miiⁿ ní caⁿ'a yā chi cuavii 'iiⁿ'nūⁿ miiⁿ. Hora miiⁿ 'iiⁿ'nūⁿ miiⁿ chivii yeⁿ'ē tá. N'daataa miiⁿ ní hora miiⁿ ncueeⁿ nuuⁿ tá ní diiⁿ tá mandados yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ ní ca'a tá chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Taachí chiiya 'yáⁿ'ā, 'yááⁿ n'dáí 'iiⁿ'yāⁿ ndɛ́ɛ yā 'iiⁿ'yāⁿ chi ngiitā nanááⁿ Jesús. Nééné n'deee naaⁿ ca'ai ndii yā. Jesús miiⁿ ní yiin'duu tá'a yā vmnaaⁿ ca'áámá ca'áámá 'iiⁿ'yāⁿ ní 'tíícā nduuvā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ní yeⁿ'ē 'yaaⁿ 'iiⁿ'yāⁿ chi ngííta yā yinan'dáā espíritus yeⁿ'e yááⁿn'guiinūuⁿ chi 'caí yā ní ngaⁿ'a yā: N'diī ní Daiya Dendyuūs n'diī. Tuu'mi ní Jesús miiⁿ ní yaa'vineeⁿ yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ ní nguɛ́ɛ́ 'cuúⁿ yā chí caaⁿ'maⁿ sa ti espíritus yeⁿ'e yááⁿn'guiinūuⁿ ní deenu sá chí Jesús miiⁿ chi Cristo. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chidɛɛvɛ táámá nguuvi Jesús miiⁿ ní cueⁿ'e yā chuva'ai yáāⁿ miiⁿ na 'áámá lugar naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'e yáāⁿ miiⁿya in'nuúⁿ yā Jesús ní ndaá yā naachi canéé Jesús miiⁿ. Ní di'cuiitú yā chi nguɛ́ɛ́ cuvii Jesús yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naati Jesús miiⁿ ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ s'eeⁿ: Canéé chííⁿ chi 'úú ní caaⁿ'máⁿ yeⁿ'e nduudu ngai yeⁿ'ē naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā, nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e tanáⁿ'ā yáāⁿ ti yeⁿ'ē chúū chí Dendyuūs dicho'ó yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ní Jesús miiⁿ cueⁿ'é yā yáāⁿ ndíí yáāⁿ yeⁿ'e yáⁿ'āa Galilea ní ngaⁿ'á yā nduudu yeⁿ'é Ndyuūs na yaācū sinagogas naachi cueⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'Áámá tiempo taachi Jesús canée yā niiⁿnuúⁿ ná nuūⁿnīⁿ'yáⁿ'ā chi nguuvi Genesaret, nééné 'yaaⁿ 'iiⁿ'yāⁿ ndaá yā nanáaⁿ yā ní chiitu yā chi cuuvi 'caandiveéⁿ yā nduudu yeⁿ'e Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús n'diichi yā ná 'uūvī barcos chi snéé nííⁿnuúⁿ na nuūⁿnīⁿ'yáⁿ'ā. 'Iiⁿ'yāⁿ chi itungaaⁿ 'yaācā miiⁿ 'āā nan'daá yā na barco s'eeⁿ ní cueⁿ'é yā naaⁿnú yā yáanā yeⁿ'e 'yaācā na nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tuu'mi Jesús sndáa yā na 'áámá barco chi yeⁿ'e Simón Pedro miiⁿ ní chii yā Simón Pedro chí 'āā caⁿ'a rá barco miiⁿ ndíí niiⁿnuúⁿ 'diituú nuūⁿnīⁿ miiⁿ. Tuu'mi ní Jesús ch'iindii yā na barco miiⁿ ní chi'cueeⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Taachi Jesús ch'iinu chi'cueeⁿ yā 'iiⁿ'yāⁿ, tuu'mi ní caⁿ'a yā chii yā Simón: Cueⁿ'e di ndúúcū barco ndíí ná yáanūuⁿ ní 'caanuuⁿ dí yaanā yeⁿ'e di nguaaⁿ nuūⁿnīⁿ ní tungaáⁿ dí 'yaācā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón miiⁿ ní nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā chii yā Jesús: N'dii Maestro, 'āā núúⁿmáⁿ yaaⁿ ch'ɛɛti nduuchí 'nū ní diíⁿ ntiiⁿnyúⁿ 'nū ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ ndaāca 'nū; naati ndúúcū nduudu yeⁿ'e nī 'caanuúⁿ 'nū yaānā yeⁿ'é 'nū chɛɛti nuūⁿnīⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Taachi 'caanuúⁿ yā yaānā miiⁿ chiitu 'yaācā chɛɛti yaānā miiⁿ chí yaānā miiⁿ ndiituú nūuⁿ chííteeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tuu'mi ní dita'a yā yeⁿ'ē tanáⁿ'a 'iiⁿ'yāⁿ chi snúuⁿ yā chɛɛti taamá barco miiⁿ chí caⁿ'a yā ní cunneé yā Simón. 'Iiⁿ'yāⁿ s'eeⁿ ní ndaa yā ní chiitu 'yaācā nduu 'uuvi barcos chí nduu 'uuvi barcos neⁿ'e 'cuɛɛchi ndii mááⁿ nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Taachi Simón Pedro n'diichí yā chuū chííntii'yá yā nanááⁿ Jesús miiⁿ ní caⁿ'a yā chii yā Jesús miiⁿ: N'diī Señor, 'úú nguɛ́ɛ́ n'daācā 'úú chí cuchií nanááⁿ n'diī, ti 'úú ní 'iiⁿ'yāⁿ nuūⁿndī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón Pedro miiⁿ ní nééné ngeⁿ'e yiinú yā. 'Tiicá ntúūⁿ 'iiⁿ'yāⁿ chi snée yā ndúúcū sa ngeⁿ'e yiinú yā cáávā yeⁿ'ē chi diiⁿ Jesús chi 'iiⁿ'yāⁿ s'eeⁿ itúngaáⁿ yā 'yaācā chi 'yaaⁿ taaví tī. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","'Tiicá ntúūⁿ Jacobo ndúúcū Juan, chi daiya Zebedeo, chi dáámá diiⁿ yā ntiiⁿnyuⁿ ndúúcū Simón, dii'yá yā chiī. Ní Jesús caⁿ'a yā chii yā Simón: Díí, Simón, nguɛ́ɛ́ 'va'a di; ndii maaⁿ ní tan'dúúcā chi ituungaaⁿ di 'yaācā yeⁿ'e nuūⁿnīⁿ, 'tíícā maaⁿ ní 'úú idiíⁿ chi in'nuuⁿ dí 'iiⁿ'yāⁿ chi cuuvi caⁿ'á yā nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Taachi ndaa yā ndúúcū barco miiⁿ niiⁿnuúⁿ 'diitúú nuūⁿnīⁿ, tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ s'neeⁿ yā ntiiⁿnyuⁿ yeⁿ'é yā ndúúcū barco miiⁿ ndúúcū nducuéⁿ'ē chi snúūⁿ chɛɛti barco miiⁿ ní cueⁿ'e yā ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Taachi Jesús miiⁿ ndaa yā na 'áámá yáāⁿ ní canée yā miiⁿ, ndaa nanááⁿ Jesús 'áámá saⁿ'ā chi ndii sa 'áámá ca'ai chi nguuvi lepra chi ín'duuti yuūtɛ̄ yeⁿ'ē sa. Taachí saⁿ'ā miiⁿ n'diichi sa Jesús miiⁿ, chííntii'ya sa can'diī sa ndii na yáⁿ'āa nanááⁿ Jesús miiⁿ. Ní chiica sa Jesús: N'dií Señor, ndúúti chi n'diī neⁿ'e nī, ní diíⁿ nī chí nduūvā yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tuu'mi ní Jesús miiⁿ n'doo ta'á yā ní tuu'ví yā saⁿ'ā ní caⁿ'a yā: 'Úú ní neⁿ'é chi nduūvā yeⁿ'ē di. Tuu'mí nūuⁿ ndúuvā yeⁿ'ē sa ní nduūvī dɛɛvɛ sá. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ní Jesús caⁿ'a yā chiī yā saⁿ'ā miiⁿ: Nguɛ́ɛ́ cuuvi di mar 'áámá 'iiⁿ'yāⁿ chi nduuva yeⁿ'ē di. Cueⁿ'e di ní 'cuuⁿ'miⁿ di maaⁿ cuerpo yeⁿ'e di nanááⁿ chiiduú. Ní ca'a di nanááⁿ Ndyuūs ofrenda yeⁿ'ē di yeⁿ'e chi nanduuva yeⁿ'ē di tan'dúúcā chi ngaⁿ'a ley yeⁿ'e Moisés. Ní 'iicu cadíínuúⁿ nducyaaca 'iiⁿ'yāⁿ chi nduūvā yeⁿ'e di. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yeⁿ'e chí diíⁿ Jesús miiⁿ dándoō ca, ní neené 'yaaⁿ 'iiⁿ'yāⁿ ndaa yā chi 'caandiveéⁿ yā nduudu yeⁿ'e Jesús miiⁿ. Ní Jesús diíⁿ yā chi nduūvā yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús cueⁿ'e yā na lugar naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ chi caaⁿ'maⁿngua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","'Áámá nguuvi Jesús ní ngi'cueeⁿ yā 'iiⁿ'yāⁿ ní miiⁿ vɛ́ɛ̄ 'iiⁿ'yāⁿ fariseos chi dingúuⁿ leyes ndúúcū maestros chí ngi'cueeⁿ ley. 'Iiⁿ'yāⁿ s'eeⁿ ní ngiicá yā yeⁿ'e táámá yáāⁿ ní yeⁿ'ē nducyáácá yaāⁿ yeⁿ'e yáⁿ'āa Galilea ndúúcū yáⁿ'āa Judea, níícú yeⁿ'e yáāⁿ Jerusalén. Jesús miiⁿ cuuvi diíⁿ yā chí nduūvā 'iiⁿ'yāⁿ s'eeⁿ ti poder yeⁿ'e Ndyuūs canéé nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tuu'mi ní ndaa ntúūⁿ n'duuvi saⁿ'ā chi n'diichí yā Jesús. Ní saⁿ'ā s'eeⁿ ní ndɛɛ yā 'áámá saⁿ'ā ndúúcū ca'āī chi in'dúuví cuerpo yeⁿ'e sa na 'áámá camilla. Ní n̄diíⁿ yā chi ndaā saⁿ'ā miiⁿ chɛɛti va'āī nanááⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Nguɛ́ɛ́ ndaāca yā taacā cundáa yā ndúúcū saⁿ'a miiⁿ ti neené n'deeé 'iiⁿ'yāⁿ snuuⁿ yā. Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ní chɛɛ yā tiíⁿ va'āī ni divíi yā n'duuvi táátá tiíⁿ va'āī. Ní di'cua'áí yā saⁿ'ā na yiivɛ naachi candíítí saⁿ'ā miiⁿ nanááⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Taachí Jesús miiⁿ tuumicadíínuuⁿ yā chi vɛ́ɛ́ vaadī i'teenu yeⁿ'é saⁿ'ā s'eeⁿ caⁿ'a yā chiī yā saⁿ'ā: Díí saⁿ'ā, 'úú nadach'ɛɛcú nuuⁿndí yeⁿ'e di. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Tuu'mi ní 'iiⁿ'yāⁿ chi ngi'cueeⁿ ley ndúúcū 'iiⁿ'yāⁿ fariseos tuca'a yā nadicadíínuuⁿ yā ní caⁿ'a yā: ¿Du'u sáⁿ'a 'cūū chi duuchineeⁿ yā yeⁿ'e Ndyuūs? ¿Du'ū nadich'ɛɛcu nuuⁿndi yeⁿ'ē yú? Dámaaⁿ Ndyuūs cuuvi diíⁿ yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús tuūmicadiinúúⁿ yā chi nadicádíínuuⁿ 'iiⁿ'yāⁿ s'eeⁿ. Tuu'mi ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī, ¿dɛ́'ɛ̄ cúúví chí 'tíícā inadicádíínuuⁿ ndís'tiī na staava yeⁿ'é nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Chɛɛ cá nguɛ́ɛ́ ngíⁿ'īi chi caaⁿ'máⁿ: 'Āā nuuⁿndi yeⁿ'e di ní nch'ɛɛ̄cū o ndúúncuééⁿ dí ní caaca dí? ");
INSERT INTO cuxNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Túúcā caⁿ'á chií saⁿ'ā chi ndís'tiī cuuvi déénu nī ti 'úú ní Saⁿ'a chi Daiyá Dendyuūs 'úú. Ní vɛ́ɛ́ poder iⁿ'yeeⁿdí 'cūū chi inadach'ɛɛ̄cú nuuⁿndi. Tuu'mi ní Jesús caⁿ'a yā chiī yā saⁿ'a miiⁿ: Ncueeⁿ di, nta'a di yiivɛ yeⁿ'ē di ní cunaⁿ'ā di na vaacu di. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tuu'mi ní saⁿ'ā miiⁿ chí ndii chi ca'āī sa 'āā ndúúvā yeⁿ'ē sa ní sta'ā sa yiivɛ yeⁿ'ē sa naachi cándiiti sa ní ngaⁿ'a sa: Dɛ'ɛ chúúcā ch'ɛɛtɛ Dendyuūs. Ní cunaⁿ'ā sa naavtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nducyáácá 'iiⁿ'yāⁿ cheⁿ'e yiinú yā ní neene di'va'á yā ní caⁿ'a yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Dendyuūs. Ní caⁿ'a yā: Maaⁿ ní n'diichi yú dendu'ū chi nguɛ́ɛ́ ta nn'diichi yú chi caⁿ'a yiinu yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cho'ōo chúū, ní Jesús miiⁿ can'daa yā cachiicá yā ní n'diichi yā 'áámá saⁿ'ā chí ínn'guɛɛ yeⁿ'ē impuestos yeⁿ'e yáⁿ'āa chí nguuvi sa Leví. Saⁿ'ā miiⁿ ní vɛɛ sa naachí n'gɛɛtɛɛ́ saⁿ'ā chí ínn'guɛɛ yeⁿ'ē impuestos. Jesús miiⁿ ní yaa'ví yā: Dii, sáⁿ'ā, cuchíi di caⁿ'a di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tuu'mi ní s'neeⁿ sá ntiiⁿnyuⁿ yeⁿ'ē sa ndúúcū nducuéⁿ'ē dendu'ū ní ndúcueeⁿ sá ní cueⁿ'ē sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Saⁿ'a Leví miiⁿ caⁿ'a ntiiⁿnyuⁿ sá chí in'nuūuⁿ 'áámá comida ch'ɛɛtɛ n'dai na vaacu sa. Na vaacu sa miiⁿ vɛ́ɛ́ 'yááⁿ saⁿ'ā chí inn'guɛɛ yeⁿ'e impuestos ndúúcū tanáⁿ'ā saⁿ'ā. Nducyaaca yā ní vɛɛ̄tɛ́ yā ndúúcū Leví na mesa miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tuu'mí maestros chi ngi'cueeⁿ ley miiⁿ ndúúcū 'iiⁿ'yāⁿ fariseos chi diíⁿ yā ley cunncáā caⁿ'a yā yeⁿ'e discípulos yeⁿ'e Jesús ní caⁿ'a yā: ¿Dɛ́'ɛ̄ cúúví chí ndís'tiī ndúúcū Jesús nge'é nī ní ngi'i nī ndúúcū 'iiⁿ'yāⁿ chí inn'guɛɛ yeⁿ'e impuestos ndúúcū 'iiⁿ'yāⁿ nuuⁿndi? Chuū nguɛ́ɛ́ n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús ní n'guɛɛcútaⁿ'a yā: 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ ngiitā nguɛ́ɛ́ neⁿ'e yā chi cuuvi yíícú yā. Dámaāⁿ 'iiⁿ'yāⁿ chi ngiitā neⁿ'e yā chi cuuvi yíícú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'Úú nguɛ́ɛ́ cuchií chi yaa'ví 'iiⁿ'yāⁿ chi nadacadiinúúⁿ yā chi n'dááca yā chi nguɛ́ɛ́ dinuuⁿndí yā naati 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā ní 'íícú ndáácádáámí yā yeⁿ'e nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ tiingūūnéeⁿ yā Jesús: ¿Dɛ́'ɛ̄ cúúví chí discípulos yeⁿ'e Juan chi ngɛɛdínuūⁿnīⁿ ndúúcū discípulos yeⁿ'e fariseos nééné n'deēe cuūví ní ca'diiⁿnúⁿ yā ní ngaⁿ'angua'á yā ní discípulos yeⁿ'e nī ní nge'e yā ní ngi'i yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: ¿Chɛɛ yeⁿ'ē maáⁿ nī cuuvi diíⁿ nī chi nguɛ́ɛ́ che'e 'iiⁿ'yāⁿ chí nandaa naachi n'giindivaacu saⁿ'ā neⁿ'e chi canéé saⁿ'ā chi n'giindivaacu sa miiⁿ ndúúcu yā? Nguɛ́ɛ́ cuuvi nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Naati ndaá nguuvi chí 'cuūvī sā ní 'āā ntɛ́ɛ́ sa ndúúcu yā, tuu'mi ní 'iiⁿ'yāⁿ ca'diiⁿnúⁿ yā nguuvi miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Caⁿ'a ntúūⁿ Jesús chii yā 'iiⁿ'yāⁿ táámá ejemplo chí 'tɛɛ nguɛɛ daama: Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ 'caaca yā 'áámá 'taaⁿ tiinūuⁿ ngai chi nguɛ́ɛ́ 'āā naaⁿnu yā chí n'dyaatá yā 'áámá catecaí yā ndicúū caati tiinūuⁿ ngai miiⁿ ní cū'teeⁿ tíínūuⁿ ndiicúú. Ní ndiicúú miiⁿ nguɛ́ɛ́ n'daacā dinááⁿ diīiⁿ naachi nn'dyaatá ndúúcū chi ngai miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'Tiicá ntúūⁿ mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ca'nuúⁿ yā vino ngai chɛɛti bolsa dííⁿmáⁿ 'iiti chi ndiicúū tan'dúúcā chi diiⁿ 'iiⁿ'yāⁿ ndiicúū ti vino ngai miiⁿ ní chó'ōo yaadi yeⁿ'ē ní diiⁿ chi 'cááncuūⁿ yííⁿmáⁿ ndiicúū. Ní vino miiⁿ ní cungéē ndíí yííⁿmáⁿ miiⁿ tuuvií. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cáávā chuū ca'nuúⁿ yā vino ngai miiⁿ chɛɛti bolsa dííⁿmáⁿ ngai ní nduu 'uuvi ní n'daācā canee yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mar 'áámá 'iiⁿ'yāⁿ chí ngi'i yā vino ndiicúū neⁿ'é yā cu'u yā vino ngai cuayiivi caati ngaⁿ'a yā chi vino chi ndiicúū chííⁿ chí n'dai nguɛ́ɛ́ ti vino ngai. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","'Áámá nguuvi sábado chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ Israel, Jesús cho'ó yā ndúúcū discípulos yeⁿ'é yā 'áámá campo naachi vɛ́ɛ́ trigo. Discípulos yeⁿ'e yā ní sta'á yā trigo ní chii yā tiīiⁿ ndúúcū ta'á yā ní che'e yā trigo. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tuu'mi ní n'duuvi fariseos caⁿ'a yā chiī yā discípulos yeⁿ'e Jesús: ¿Dɛ'ɛ̄ cúúví chí ndís'tiī diíⁿ nī cosas chi nguɛ́ɛ́ canee chi diíⁿ nī ti contra yeⁿ'e ley yeⁿ'e nguuvi chi cánéé chí ntaavi'túúnúūuⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús nan'guɛɛcútaⁿ'a yā: ¿'Áá nguɛ́ɛ́ n'geēⁿ ndís'tiī na libro yeⁿ'é Ndyuūs tan'duucā chi diiⁿ rey David ndúúcū 'iiⁿ'yāⁿ chi snéé ndúúcu yā taachi cuīīcu yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David sndáa yā yaācū ndúúcū 'iiⁿ'yāⁿ chi snéé ndúúcu yā ní David sta'a yā pan chi canéé nátaī yeⁿ'e Ndyuūs ní che'e yā ní ca'á yā chi che'e 'iiⁿ'yāⁿ chi snéé ndúúcu yā. David miiⁿ nguɛ́ɛ́ canee chi che'e yā pan ndúúcū 'iiⁿ'yāⁿ chi snéé ndúúcu yā ti dámaāⁿ chiiduú s'eeⁿ canee chi che'e yā pan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Úú ní Saⁿ'ā chi Daiya Dendyuūs ní 'úú ngií ngaⁿ'á ntiiⁿnyuⁿ yeⁿ'e nguuvi chí ntaavi'tuunuúⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Táámá nguuvi sábado chi ntaavi'tuunúuⁿ 'iiⁿ'yāⁿ Israel, Jesús miiⁿ ní ndaa yā na yaācū sinagoga ní chi'cueeⁿ yā 'iiⁿ'yāⁿ. Mííⁿ canee 'áámá saⁿ'ā chi ntí'i ta'a sa ta cuaācú sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ fariseos ngeenu yā Jesús miiⁿ caati neⁿ'e yā n'diichi yā nduuti chi idiiⁿ Jesús chí nduuva yeⁿ'e sa nguuvi chi intaavi'tuūnúúⁿ yā, ni 'tíícā cuuvi caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Naati Jesús miiⁿ déénu yā yeⁿ'ē chi nadicádiinuuⁿ 'iiⁿ'yāⁿ ní caⁿ'a yā chii yā saⁿ'a chi ntí'ī 'áámá ta'ā sa: Dií saⁿ'ā, nducueeⁿ dí ní cuééndii di náávtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. Saⁿ'ā miiⁿ ní cuééndiī sa náávtaⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Úú intiinguuneéⁿ ndís'tiī. ¿Dɛ'ɛ̄ chí cuuvi diiⁿ yú nguuvi chi ntaavi'tuūnúúⁿ 'iiⁿ'yāⁿ? ¿'Áá diiⁿ yú cosas chi n'daacā o cosas chi nguɛ́ɛ́ n'daacā? ¿'Áá n'daacā chí nanguaⁿ'āī yú vida yeⁿ'e 'iiⁿ'yāⁿ o 'caaⁿ'nuⁿ yú 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús ch'iinu yā nducyaaca 'iiⁿ'yāⁿ chi snée yā cuaaⁿ 'diitú yā ní caⁿ'a yā chii yā saⁿ'ā: N'doo di ta'ā di. Saⁿ'ā miiⁿ ní n'doo ta'ā sa ní ta'ā sa mííⁿ 'āā nduūvā yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Iiⁿ'yāⁿ s'eeⁿ ní n'duuvi taaⁿ n'daí yā ní yaa'vi yā vi'i: ¿Dɛ́'ɛ diiⁿ yú chi cuuvi tun'daa yú nuuⁿndi yeⁿ'e Jesús miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nguuvi s'eeⁿ Jesús cueⁿ'e yā 'áámá yiīcū chi caaⁿ'maⁿngua'á yā ní Jesús miiⁿ ní núúⁿmáⁿ yaaⁿ caⁿ'angua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ní taachí chidɛɛvɛ Jesús yaa'vi yā discípulos yeⁿ'e yā ní ndɛɛvɛ yā ndiichúúví 'iiⁿ'yāⁿ yeⁿ'e nguaaⁿ discípulos s'uuⁿ ní caⁿ'a yā chi ndiichúúví 'iiⁿ'yāⁿ s'eeⁿ chi apóstoles. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","'Iiⁿ'yāⁿ s'eeⁿ ní 'túúcā nguuvi yā: Simón chi nguuvi ntúuⁿ yā Pedro; ndúúcū Andrés chi 'díinū Simón Pedro miiⁿ, ndúúcū Jacobo, ndúúcū Juan, ndúúcū Felipe, ndúúcū Bartolomé, ");
INSERT INTO cuxNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ndúúcū Mateo, ndúúcū Tomás, ndúúcū Jacobo chi saⁿ'a daiya Alfeo, ndúúcū Simón chi nguuvi sa Zelote, ");
INSERT INTO cuxNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ndúúcū Judas chi 'díinū Jacobo ndúúcū Judas Iscariote chi cuayiivi chiⁿ'i sá du'ū chí Jesús miiⁿ chi cuuvi 'caaⁿ'núⁿ yā 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús nangua'áí yā yeⁿ'e yiīcū miiⁿ ndúúcū apóstoles yeⁿ'é yā ní ndúúcū n'deēe n'dáí discípulos yeⁿ'e yā ní cueⁿ'e yā 'áámá yáⁿ'āa chi yúúdūu. Ní canee ntúūⁿ nduucú yā n'deee n'dáí 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Judea ndúúcū yáāⁿ Jerusalén ní yeⁿ'e yáāⁿ s'eeⁿ 'diituú nuūⁿnīⁿ'yáⁿ'ā ní yeⁿ'e yáⁿ'āa Tiro ndúúcū yáⁿ'āa Sidón. 'Iiⁿ'yāⁿ s'eeⁿ ní 'āā ndāa yā chi 'caandiveéⁿ yā yeⁿ'ē chi ngi'cueeⁿ Jesús miiⁿ. Ní 'iiⁿ'yāⁿ chi ngííta yā neⁿ'é yā chi Jesús diiⁿ chi nduūvā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ní 'iiⁿ'yāⁿ chi snée yā ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ ní Jesús diiⁿ yā chi nacan'dáā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní ch'ɛɛnuu chiī yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ nduuvā yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ni nducyáácá 'iiⁿ'yāⁿ chi ngiītā neⁿ'e yā tuu'vi yā Jesús miiⁿ ti vɛ́ɛ́ cá poder yeⁿ'e yā chi diiⁿ yā chi nanduūvā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tuu'mi ní Jesús n'diichí yā discípulos yeⁿ'e yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Dɛ́'ɛ chúúcā n'dai ndís'tiī chi nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ yeⁿ'e nī ti yeⁿ'ē ndís'tiī cuuví naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Dɛ'ɛ̄ chúúcā n'dai ndís'tiī chi 'cueeⁿ cá nī libro yeⁿ'é Ndyuūs chi n'daācā ca canee staava yeⁿ'é nī. Dɛ'ɛ chúúcā n'dai ndís'tiī chi maaⁿ ní nngɛɛcu nī nanááⁿ Ndyuūs ti neⁿ'e diíⁿ nī nducuéⁿ'ē chi cuaacu ti Ndyuūs ya'āī 'iinú yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Dɛ'ɛ̄ chúúcā n'dai ndís'tiī taachi 'iiⁿ'yāⁿ yeⁿ'ē iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ cuuvi snaaⁿ yā ndís'tiī ní taachi 'iiⁿ'yāⁿ s'eeⁿ cuvíi yā yeⁿ'e ndís'tiī. Ní cunncáā diíⁿ yā ndúúcū ndís'tiī. Ní 'āā ntɛ́ɛ́ neⁿ'e yā 'caandiveéⁿ yā chi duuchí nī. Caaⁿ'máⁿ yā chi nguɛ́ɛ́ n'daaca ndís'tiī cucáávā 'úú chi Saⁿ'ā chi Daiyá Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ndís'tiī canéé chí yeenú n'dai nī ní nguuvi miiⁿ cuuví yeenú n'dai ca nī caati Ndyuūs tée yā chi cuuvi yeⁿ'é nī dendu'ū chi ch'ɛɛtɛ n'dai taachi ndaa nī na va'ai chɛɛti nguuvi. Ti ndii cuááⁿ vmnaaⁿ 'tiicá ntúūⁿ idiíⁿ 'iiⁿ'yāⁿ cosas chi nguɛ́ɛ́ n'daācā ndúúcū 'iiⁿ'yāⁿ profetas chi candɛ́ɛ yā nduudu yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Dɛ'ɛ chúúcā ndaachiī yeⁿ'ē ndís'tiī chi vɛ́ɛ́ cá yeⁿ'e nī caati 'āā yeenú nī yeⁿ'e nducuéⁿ'ē yeⁿ'ē iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Dɛ'ɛ chúúcā ndaachiī yeⁿ'e ndís'tiī chi nadacádíínuuⁿ nī chí n'daācā canee nī nanááⁿ Dendyuūs ní nguɛ́ɛ́ n'giindiveéⁿ nī nduudu yeⁿ'é Ndyuūs ti cuayiivi naachi neⁿ'é nī 'caandiveéⁿ nī ní nguɛ́ɛ́ cuuví 'caandiveéⁿ nī. Dɛ'ɛ̄ chúúcā ndaachiī yeⁿ'e ndís'tiī chi maaⁿ ní n'gííⁿnyuⁿ nī ti cuayiivi ní cuɛɛcú nī ti ndaāchīi nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dɛ'ɛ̄ chúúcā ndaachiī yeⁿ'e ndís'tiī taachi nducyaaca 'iiⁿ'yāⁿ caaⁿ'maⁿ n'daācā yeⁿ'e nī. Caati ndíí cuááⁿ vmnaaⁿ 'tíícā ngaⁿ'a 'iiⁿ'yāⁿ yeⁿ'e 'iiⁿ'yāⁿ profetas chi falso yā ní nguɛ́ɛ́ profetas yeⁿ'é Ndyuūs, ní nguɛ́ɛ́ candɛɛ yā nduudu yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","'Úú, Jesús, ní ngaⁿ'á ngīi ndís'tiī chi n'giindiveéⁿ nī nduudu chi ngaⁿ'á: Dinéⁿ'e ntúūⁿ nī 'iiⁿ'yāⁿ 'áárá chi taāⁿ yā yeⁿ'e nī. Ní diiⁿ n'daacá nī ntúūⁿ ndúúcū 'iiⁿ'yāⁿ 'áárá chi nguɛ́ɛ́ neⁿ'e yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Di'viicú nī 'iiⁿ'yāⁿ 'áárá chi caⁿ'a cunncáa yā ndúúcu nī. Ní caaⁿ'maⁿngua'a nī caavā 'iiⁿ'yāⁿ 'áárá chi nguɛ́ɛ́ n'daacā diíⁿ yā ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nduuti chi 'áámá 'iiⁿ'yāⁿ duuchineeⁿ yā yeⁿ'e nī ní n'geⁿ'e yā 'áámá tiicuaa náaⁿ nī, 'cuúⁿ nī chi diíⁿ yā táámá vmnéⁿ'ēe nduuti chi neⁿ'é yā. 'Iiⁿ'yāⁿ chi divíi yā cotón yeⁿ'e nī, ca'ā ntúuⁿ nī catecai nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi caaca yā cosa yeⁿ'é nī caavā necesidades yeⁿ'e yā, ca'á nī. 'Iiⁿ'yāⁿ chi cuta'á yā chi yeⁿ'e nī, 'āā ntɛ́ɛ́ nguɛɛcunée nī ndaaca nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Tan'dúúcā chi ndís'tiī neⁿ'e nī chi tanáⁿ'ā saⁿ'ā miiⁿ n'dáacā diiⁿ sa nduucú nī, 'tiicá ntúūⁿ diiⁿ ndís'tiī ndúúcū saⁿ'ā s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ndúúti chi ndís'tiī dinéⁿ'e nī 'iiⁿ'yāⁿ chi neⁿ'e ndís'tiī, ¿dɛ́'ɛ̄ chi n'daacā idiíⁿ nī? Caati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daācā, 'tiicá ntúúⁿ idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ndúúti chi ndís'tiī n'daacā idiíⁿ nī ndúúcū 'iiⁿ'yāⁿ chi din'daācā nduucú nī, ¿dɛ́'ɛ chi n'daacā idiíⁿ nī? Caati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daacā, 'tiicá ntuūⁿ idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Tiicá ntúūⁿ, nduuti chi diíⁿ nī prestar chiiⁿ chi yeⁿ'é nī 'iiⁿ'yāⁿ ní cunee ngiinú nī chi 'iiⁿ'yāⁿ miiⁿ caⁿ'á yā tee yā chiiⁿ chi yeⁿ'é nī, ¿dɛ́'ɛ̄ cuuvi chi 'iiⁿ'yāⁿ tée yā gracias ndís'tiī? 'Tiicá ntúūⁿ idiiⁿ 'iiⁿ'yāⁿ chi nguɛɛ n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ndís'tiī dineⁿ'é nī 'iiⁿ'yāⁿ s'eeⁿ chi taáⁿ yā yeⁿ'e nī. 'Tíícā din'daacá nī ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii n'diichí yā ndís'tiī. Diíⁿ nī prestar cosa chi yeⁿ'é nī ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nadacadiinuuⁿ cá nī yeⁿ'ē. Ní Ndyuūs tée yā ndís'tiī cosas chi dendu'ū chi ch'ɛɛtɛ ca yeⁿ'é yā taachi caⁿ'a nī na va'ai chɛɛti nguuvi ní cuuví ndís'tiī daiyá Dendyuūs chi ch'ɛɛtɛ taavi ca. 'Tíícā Ndyuūs tée yā cosas chí n'daaca 'iiⁿ'yāⁿ chi cunncáā chi nguɛ́ɛ́ caaⁿ'máⁿ yā: N'dii Ndyuūs gracias. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Tiicá ntúūⁿ yá'ai 'iinú nī cááva 'iiⁿ'yāⁿ tan'dúúcā Chiidá nī Ndyuūs ya'áí 'iinú yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nguɛ́ɛ́ caaⁿ'máⁿ nī nuuⁿndī yeⁿ'é 'iiⁿ'yāⁿ ní Ndyuūs ní nguɛ́ɛ́ caaⁿ'maⁿ ntúuⁿ yā yeⁿ'é nī. Nguɛ́ɛ́ diíⁿ nī condenar 'iiⁿ'yāⁿ ní Ndyuūs nguɛ́ɛ́ diíⁿ yā condenar ndís'tiī. Nadich'ɛɛcú nī nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ ní Ndyuūs nadich'ɛɛcú yā nuuⁿndi yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ca'á n'daacá nī 'iiⁿ'yāⁿ chi vɛ́ɛ́ necesidades yeⁿ'é yā ní 'íícú Ndyuūs tée yā ndís'tiī ní dicaadi n'dááca yā chi cúúnú chiichi ndíí tuunu cungéē na morral yeⁿ'é nī, caati Ndyuūs dicaadí yā ndís'tiī ndúúcū maaⁿ caadi chí dicaadí nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ngii yā 'iiⁿ'yāⁿ s'eeⁿ 'áámá ejemplo yeⁿ'e 'áámá nduudu chi 'tɛ́ɛ́ nguɛɛ daama. ¿'Áá cúúví diiⁿ 'áámá chi ngueenááⁿ candɛɛ̄ táámá chi ngueenááⁿ? ¿'Áá nguɛɛ cun'dáá nūuⁿ nduu 'uuví yā na yiivi yáⁿ'āa? ");
INSERT INTO cuxNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","'Áámá discípulo miiⁿ ní nguɛ́ɛ́ ch'ɛɛtɛ cá yā nguɛ́ɛ́ ti maestro yeⁿ'e yā. 'Āā du'ú nūuⁿ chí neⁿ'e cuuvi Maestro, canee chí 'cuiinu 'cueeⁿ yā din'daaca yā ní cuuví yā tan'dúúcā maestro yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Táácā cuuví chi maaⁿ nch'ɛɛtɛ́ nūuⁿ n'gíínu nī nuūⁿndī chi diiⁿ tanáⁿ'ā 'iiⁿ'yāⁿ ní nguɛ́ɛ́ inaaⁿ nī nuuⁿndī ch'ɛɛtɛ chi diíⁿ ni. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nguɛ́ɛ́ n'daacā chi caaⁿ'máⁿ nī 'iiⁿ'yāⁿ yeⁿ'e chi diíⁿ yā chi nguɛ́ɛ́ n'daacā nduuti chi ndís'tiī diiⁿ nī cosas chi nguɛɛ n'daacā. N'daacā ca chi ndaacadaamí nī yeⁿ'ē nuuⁿndi chi diiⁿ nī ní 'íícú cuuvi caaⁿ'máⁿ nī yeⁿ'e 'iiⁿ'yāⁿ chi canéé chí din'daacá yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","N'gui'i yeⁿ'e yáⁿ'á chi n'dai, n'daacā chi cuuví n'gui'i yeⁿ'ē ní yáⁿ'á chi nguɛ́ɛ́ n'dai ní nguɛ́ɛ́ n'daacā n'gui'i yeⁿ'ē. Naati yáⁿ'á chi nguɛ́ɛ́ n'daacā nguɛ́ɛ́ cuuvi n'gui'i chí n'daacā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","'Tíícā ti tuunu tuunu ca yáⁿ'á n'giⁿ'i n'gui'i yeⁿ'ē. Nguɛ́ɛ́ n'giichi yā yaaⁿ chi 'cuūndī n'guíídīi yaaⁿ nguuvi yeⁿ'ē, ndíí nguɛ́ɛ́ ndúú tuūⁿmá yā uvas yeⁿ'ē dii'yu nduuti yaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","'Tiicá ntúūⁿ saⁿ'ā chi n'dai idiiⁿ sa dendu'ū chí n'daacā chi nadacadíínuuⁿ sa na staava yeⁿ'ē sa chí n'daacā. Saⁿ'ā chí cunncáā idiiⁿ sa tanducuéⁿ'ē chi nadacadíínuuⁿ sa na staava yeⁿ'ē sa caati staava yeⁿ'ē sa nguɛ́ɛ́ n'daaca. Nduudu chi ngaⁿ'ā sa ngiica yeⁿ'e chi ndiituu na staava yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Caⁿ'a ntúūⁿ Jesús: ¿Dɛ'ɛ cúúví chí ndís'tiī ngaⁿ'á nī ngiiⁿ nī 'úú: N'diī, Señor yeⁿ'é, n'diī, Señor yeⁿ'é, ní nguɛ́ɛ́ 'caandiveéⁿ nī chi ngaⁿ'á? ");
INSERT INTO cuxNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","'Úú cuuví ndís'tiī, du'ū 'iiⁿ'yāⁿ chí chiī nanaáⁿ ní n'giindiveēⁿ nduudu yeⁿ'é ní n'daacā idiíⁿ yā tan'dúúcā chi ngaⁿ'á, ");
INSERT INTO cuxNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","'iiⁿ'yāⁿ miiⁿ tan'dúúcā 'áámá saⁿ'ā chí din'dái sa vaacu sá. Chiinú yáanūuⁿ n'daaca sá ní s'nuūⁿ sa cimiento yeⁿ'ē vmnaaⁿ 'áámá yáává. Ní taachi chiiya 'áámá cuuvi naⁿ'ā ní ch'iita yíícú ní diītūu n'dáí cheⁿ'ē nuūⁿnīⁿ miiⁿ. Ní nuūⁿnīⁿ miiⁿ nguɛ́ɛ́ cuuvi diīiⁿ di'núⁿ'u va'āī miiⁿ ti n'daacā candúūu na yáává miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ch'iindiveéⁿ yā nduudu yeⁿ'é ní nguɛ́ɛ́ idiíⁿ yā tan'dúúcā chi ngaⁿ'á 'iiⁿ'yāⁿ miiⁿ tan'dúúcā 'áámá saⁿ'ā chi din'dái sa vaacu sa na yaⁿ'á ndúútīi ní nguɛ́ɛ́ ndúúcū cimiento. Ní díítūu n'dai cheⁿ'é nuūⁿnīⁿ miiⁿ ní va'āī miiⁿ maaⁿnch'ɛɛtɛ́ nūuⁿ chindɛɛvɛ ní cunncáā ntuūvīi va'āī miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Taachí Jesús ch'íínú ngi'cueeⁿ yā 'iiⁿ'yāⁿ, tuu'mi ní cueⁿ'é yā na yaāⁿ Capernaum. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ná yáāⁿ miiⁿya canéé 'áámá saⁿ'ā capitán romano yeⁿ'ē soldados. Ní na vaacu capitán miiⁿ cánéé 'áámá saⁿ'ā mozo chi idiiⁿ mandado yeⁿ'ē sa. Nééné neⁿ'e sa mozo yeⁿ'ē sa ni nééné ya'āī 'iinu sa ti mozo ní neené ya'āī ngíítā sa. 'Āā cháā 'cuūvī sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Taachi capitán miiⁿ ch'iindiveeⁿ sa chi Jesús miiⁿ diíⁿ yā vaadī n'giinu, capitán miiⁿ dicho'o sa n'dúúví 'iiⁿ'yāⁿ Israel chi caaⁿ'maⁿ ntiiⁿnyúⁿ yā na yaacū yeⁿ'e 'iiⁿ'yāⁿ Israel chi 'iiⁿ'yāⁿ s'eeⁿ di'cuíítu yā Jesús miiⁿ chi caⁿ'a yā na vaacu sa ní diíⁿ yā chi nduūvā yeⁿ'e mozo yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Iiⁿ'yāⁿ s'eeⁿ cueⁿ'e yā nanááⁿ Jesús miiⁿ. Ní di'cuíítu yā Jesús, ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ: N'diī Jesús, 'caandiveéⁿ nī caati capitán yeⁿ'é 'nū ní neené n'dai yā chi diíⁿ nī chí nduūvā yeⁿ'e mozo yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Caati capitán romano miiⁿ ní idinéⁿ'e yā 'iiⁿ'yāⁿ yeⁿ'e yú chi yeⁿ'e ndaata Israel, ní din'dái yā yáacū sinagoga yeⁿ'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tuu'mi ní Jesús miiⁿ cueⁿ'e yā ndúúcū 'iiⁿ'yāⁿ s'eeⁿ. Ní taachi 'āā cháā ndaa niiⁿnuúⁿ yā ná va'ai yeⁿ'ē sa, capitán miiⁿ dicho'o sa n'duuvi amigos yeⁿ'e sa chi caaⁿ'máⁿ yā cuuvi yā Jesús mii: N'diī, Señor, nguɛ́ɛ́ tuuviīnúuⁿ nī ti 'úú nguɛ́ɛ́ neené n'dai 'úú chi cundaa nī chɛɛti va'ai yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Maaⁿ ní deenú chi mar 'áámá 'iiⁿ'yāⁿ ní neené n'dai chi cuuvi ndaá nanáaⁿ nī. Dámaāⁿ chi caaⁿ'maⁿ ntiiⁿnyuⁿ núúⁿ nī ní nduūvā yeⁿ'e mozo chi diiⁿ mandado yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Āā dɛ'ɛ nuūⁿ chi caaⁿ'maⁿ ntiiⁿnyúⁿ nī yeⁿ'ē tuu'mi ní cuuvī chó'ōo. 'Tiicá ntúūⁿ 'úú ní vɛ́ɛ́ 'iiⁿ'yāⁿ chí ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'é. 'Úú ní capitán ní ngaⁿ'a ntiiⁿnyúⁿ yeⁿ'e soldados chi canee maaⁿ poder yeⁿ'é. Ngaⁿ'á ngií 'áámá sa: Cunaⁿ'a di, ní inaⁿ'a sa. Ní ngaⁿ'á ngií taama sa: Cuchíi di, ní chii sa. Ní ngaⁿ'á ngií mozo chi diiⁿ mandado yeⁿ'é: Diiⁿ di ntiiⁿnyúⁿ cūū, ní diiⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ní taachí Jesús ch'iindiveéⁿ yā nduudu yeⁿ'ē sa chi ngaⁿ'a amigos yeⁿ'e capitán miiⁿ chéⁿ'é yiinu yā yeⁿ'e capitán. Ní nguɛɛcundíi yā n'diichi yā 'iiⁿ'yāⁿ chi snée yā cuaaⁿ daami yā ní caⁿ'a yā. 'Úú ní ngaⁿ'á ngií ndís'tiī: 'Úú nguɛ́ɛ́ indaacá mar 'áámá 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel chi i'teenú n'dai cá yā Ndyuūs tan'dúúcā capitán miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Taachí ndaa 'iiⁿ'yāⁿ s'eeⁿ va'ai chi capitán miiⁿ dichó'o sa, 'iiⁿ'yāⁿ s'eeⁿ n'diichí yā chí mozo miiⁿ chi nééné ngííta sa ní 'āā nduuvá yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Cuayiivi, Jesús miiⁿ cheⁿ'e yā na yáāⁿ Naín ndúúcū discípulos yeⁿ'e yā ndúúcū 'yaaⁿ n'dáí 'iiⁿ'yāⁿ chi cueⁿ'e ndúúcu yā. Ní chúū chiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Taachí Jesús ndaá yā niiⁿnuúⁿ ná cheendi va'āī yeⁿ'e yaāⁿ miiⁿ, n'diichí yā chi ndɛɛ̄ 'iiⁿ'yāⁿ 'áámá caja tináⁿ'ā canuúⁿ yúúní chí cueⁿ'e yā cuɛɛchi yā. Tináⁿ'ā miiⁿ 'áámá n'dyáⁿ'ā sa yeⁿ'ē chɛɛcú sá. Ní n'daata miiⁿ ní n'daataá ngua'a yā. Ní neené 'yaaⁿ 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ snee yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Taachí Jesús n'diichi yā n'daataá miiⁿ, nééné ya'ai 'iinú yā n'daataá ní caⁿ'a yā chii yā n'daataá miiⁿ: Nguɛ́ɛ́ cuɛɛcú di. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tuu'mi ní Jesús miiⁿ ní cueⁿ'e ndaa yā ní tuu'ví yā caja yeⁿ'e tinaⁿ'ā. Ní 'iiⁿ'yāⁿ chi ndɛ́ɛ yā caja miiⁿ ch'ɛɛtindii yā. Ní Jesús caⁿ'a yā: Saⁿ'ā 'dííⁿ 'úú yaa'ví dii, nducueeⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tuu'mi ní 'nuūⁿndi saⁿ'ā 'dííⁿ chi n'dii ní tucá'a sa ndeē sa. Ní Jesús miiⁿ ní nca'á yā saⁿ'a 'dííⁿ chɛɛcu sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nducyaaca 'iiⁿ'yāⁿ di'va'á yā yeⁿ'e chi n'diichi yā ní caⁿ'a yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Ndyuūs. Ní caⁿ'a yā chi 'áámá profeta ch'ɛɛtɛ ndāa yā nguaaⁿ nús'uu chí Ndyuūs dicho'ó yā caati ya'ai 'iinú yā yeⁿ'ē s'uuúⁿ chi nación yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'Tíícā ngaⁿ'a 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'e Jesús miiⁿ. Ní caⁿ'a yā chuū núúⁿmáⁿ na yáⁿ'āa Judea ndúúcū nuuⁿmáⁿ yáāⁿ cuaaⁿ 'diituú. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Discípulos yeⁿ'e Juan chi ngɛɛ̄dínuūⁿnīⁿ caⁿ'a yā chii yā Juan miiⁿ yeⁿ'é tanducuéⁿ'ē dendu'ū chi diiⁿ Jesús. Tuu'mí Juan miiⁿ yaa'vi yā 'uuvi discípulos yeⁿ'e yā nanáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ní dichó'o yā discípulos s'eeⁿ chí ntiinguuneeⁿ yā Jesús miiⁿ chuū: ¿'Áá n'diī Cristo chi canéé chí ndaā o 'āā cūnee ngíínú 'nū taama yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Discípulos yeⁿ'e Juan miiⁿ cueⁿ'e yā ní ndaá yā nanááⁿ Jesús miiⁿ ní caⁿ'a yā chii yā Jesús: N'diī Señor, Juan chí ngɛɛdínuūⁿnīⁿ dichó'o yā nús'uu chí ntííngúúneeⁿ 'nū n'diī: ¿'Áá n'diī chi canéé chí ndaā o 'āā cūnee ngíínú 'nū taama yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tiempo miiⁿ Jesús diíⁿ yā chi nnduūvā yeⁿ'e 'yaaⁿ n'dai 'iiⁿ'yāⁿ yeⁿ'ē ca'ai chi ndíi yā ní yeⁿ'e ca'ai chi vɛ́ɛ́ espíritu yeⁿ'e yááⁿn'guiinūuⁿ ndúúcu yā. 'Tiicá ntúūⁿ diíⁿ yā chi snaaⁿ 'iiⁿ'yāⁿ chi ngueenááⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tuu'mi Jesús nán'guɛɛcútaⁿ'a yā yeⁿ'e nduu 'uuvi discípulos yeⁿ'e Juan miiⁿ ní caⁿ'a yā: Ndís'tiī, cunaⁿ'a nī ní cuuvi nī Juan miiⁿ yeⁿ'e nducuéⁿ'ē chi n'diichi nī ndúúcū chi n'giindiveéⁿ nī. 'Iiⁿ'yāⁿ chi ngueenááⁿ ní inaaⁿ yā, 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii ngíícá yā ní ngiica yā, 'iiⁿ'yāⁿ chí ndíí ca'ai chí lepra chi in'duuti yuūtɛ̄ yeⁿ'é yā ní nduuva yeⁿ'é yā, 'iiⁿ'yāⁿ chi chɛɛtúū ní n'giindiveéⁿ yā, 'iiⁿ'yāⁿ chi n'díí ní nnduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā, ní 'iiⁿ'yāⁿ chi ndaachíī snee yā 'úú ní ngaⁿ'á nanáaⁿ yā nduudu yeⁿ'é Ndyuūs, nduudu ngai chí yeⁿ'ē chí nanguaⁿ'āī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dɛ'ɛ̄ chúúcā n'dai 'iiⁿ'yāⁿ chi nguɛ́ɛ́ cunncáā ch'eenú yā 'úú ndúúcū nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Taachi cueⁿ'e discípulos yeⁿ'e Juan chi dicho'ō Juan miiⁿ, tuu'mi ní Jesús tucá'a yā caⁿ'a yā chii yā 'iiⁿ'yāⁿ chi snee yā ndúúcu yā yeⁿ'e Juan chi ngɛɛdínuūⁿnīⁿ miiⁿ: ¿Dɛ'ɛ cheⁿ'e nī n'diichi nī na yáⁿ'āa cuuⁿmaⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ? ¿'Áá 'áámá ndúú chí idin'núⁿ'u 'yúúné? Nguɛɛ 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Du'ú cheⁿ'e nī n'diichi nī tuu'mi? ¿'Áá 'aama saⁿ'ā chi canúuⁿ sa catecai n'dai sa? Deenu nī chi 'iiⁿ'yāⁿ chi n'daācā catecai yā nguɛ́ɛ́ n'geenu yā ngii ní snée yā na va'ai yeⁿ'ē rey. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Du'ú cheⁿ'é nī n'diichí ni tuu'mi? ¿'Áá 'áámá profeta chí ngaⁿ'a nduudu cuaacu yeⁿ'é Ndyuūs? 'Úú ní ngaⁿ'á ngií ndís'tiī chi 'tíícā. Cheⁿ'é nī n'diichí nī 'áámá 'iiⁿ'yāⁿ ch'ɛɛtɛ ca yā nguɛ́ɛ́ ti tanáⁿ'ā profetas. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Chuū canéé nguūⁿ yeⁿ'e Juan miiⁿ na libro yeⁿ'é Ndyuūs ndii cuááⁿ vmnaaⁿ: Cun'diichí nī. 'Úú ní dicho'ó 'áámá saⁿ'ā chi caaⁿ'maⁿ sā nduudu cuaacu yeⁿ'é nanááⁿ dii. Ní saⁿ'ā miiⁿ ní 'cuundiyaáⁿ sa yúúní cáávā dii. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Úú ní ngaⁿ'á ngií ndís'tiī chi nguaaⁿ nducyaaca saⁿ'ā chi ch'iindiyaāⁿ sa na iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ táámá saⁿ'ā chi ch'ɛɛtɛ ca sa ti 'āā Juan miiⁿ chí chɛɛdínuūⁿnīⁿ sa. Naati 'iiⁿ'yāⁿ chi ndiicuúⁿ ca yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní ch'ɛɛtɛ cá yā nguɛ́ɛ́ ti Juan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Neené n'dai 'iiⁿ'yāⁿ ndúúcū 'iiⁿ'yāⁿ chí inn'guɛɛ yeⁿ'ē yáⁿ'āa ch'iindiveéⁿ yā nduudu chi ngaⁿ'a Jesús. Ní 'iiⁿ'yāⁿ s'eeⁿ chi'téénu yā nduudu yeⁿ'e Juan miiⁿ ní diíⁿ yā tan'duucā Ndyuūs neⁿ'e yā. Ní Juan miiⁿ chɛɛdínuūⁿniⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naati 'iiⁿ'yāⁿ fariseos miiⁿ ndúúcū maestros yeⁿ'e ley, 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ neⁿ'e yā Juan ndíí nguɛ́ɛ́ s'téénu yā nduudu yeⁿ'e Juan miiⁿ. Ní nguɛ́ɛ́ chɛɛdinuūⁿniⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús miiⁿ caⁿ'a yā chiī yā 'iiⁿ'yāⁿ: ¿Dɛ́'ɛ̄ cuuví nadidaamá ndúucu tan'dúúcā 'iiⁿ'yāⁿ chi snéé yā na iⁿ'yeeⁿdí 'cūū maaⁿ? ¿Dɛ'ɛ́ tan'duucá yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","'Iiⁿ'yāⁿ s'eeⁿ tan'dúúcā saⁿ'ā ngaiyáā chí n'gɛɛ̄tɛɛ sa nii'vɛ̄ɛ̄ ní duūchī sa ndúúcū vi'i ní n'gai sa compañeros yeⁿ'e sa. Ní ngaⁿ'á sa ngii sa vi'ī: Tiiví 'nū flauta cáávā baile ní nguɛ́ɛ́ nde'éí nī. Ngiita 'nū canciones chí ndaachií ní nguɛ́ɛ́ chɛɛ̄cu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ní ndaā Juan chí ngɛɛdínuūⁿnīⁿ chí 'aama 'iiⁿ'yāⁿ chi nguɛ́ɛ́ che'e yā pan ní nguɛ́ɛ́ chi'i yā vino ní ndís'tiī ní ngaⁿ'a nī yeⁿ'e yā: Juan miiⁿ ní cánée yā ndúúcū espíritu yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Úú ní ndaá, 'úú Saⁿ'ā chi Daiya Dendyuūs 'úú. Ní nge'é ní ngi'í ní ndís'tiī ngaⁿ'a nī yeⁿ'e 'úú: 'Cuin'dííchí nī, 'iiⁿ'yāⁿ chi n'deēe nge'é yā ní yaāⁿ n'dáí ngi'í taaví yā vino. Ní ngaⁿ'a ntuúⁿ nī chi 'úú 'áámá amigo yeⁿ'e 'iiⁿ'yāⁿ chi ínn'guɛɛ yeⁿ'e yáⁿ'āa ndúúcū 'iiⁿ'yāⁿ chi diiⁿ nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Caati nducyaaca 'iiⁿ'yāⁿ deenu yā chi vaadī deenu miiⁿ ní yeⁿ'e Ndyuūs. Ní 'iiⁿ'yāⁿ ch'iⁿ'í yā vaadī deenu miiⁿ cáávā dendu'ū chi n'daācā chi diíⁿ yā ti yeⁿ'e Ndyuūs 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","'Áámá saⁿ'ā fariseo di'cuíítu sa Jesús chi ché'é yā ná váácu sá. Tuu'mi ní Jesús sndaa yā ná va'ai yeⁿ'e saⁿ'ā fariseo miiⁿ ní ch'iindi yā na mesa ndúúcū sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tuu'mi ní 'áámá n'daataá chi vɛ́ɛ́ nuuⁿndi yeⁿ'e ta chí canee tá yeⁿ'e yáāⁿ miiⁿ, taachí chicádíínuuⁿ tá chi Jesús miiⁿ canée yā na va'áí yeⁿ'e saⁿ'ā fariseo ní vɛɛ yā na mesa, n'daataá mííⁿ ndaa ta ní ndɛ́ɛ ta 'áámá caja yeⁿ'ē aceite perfume. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","N'daataa mííⁿ chííntii'ya tá na ca'a Jesús ní ngɛɛcu tá. Ní ndúúcū nuūⁿnīⁿ nduutináaⁿ tá naaⁿnu tá ca'a yā ní nadīdɛɛ̄vɛ tá ca'a yā ndúúcū yuūdū tiīⁿ tá. Ní 'neeⁿcheendi ta ca'a yā ní chiī tá aceite perfume ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Taachí sáⁿ'ā fariseo miiⁿ n'dííchi sa chi diiⁿ n'daataá miiⁿ, tuu'mi nadīcádíínuuⁿ sa ní caⁿ'ā sa nguááⁿ maāⁿ sa 'tíícā: Ndúútī chi sáⁿ'a 'cūū profeta sa, tuu'mi ní deēnū sa du'ū n'daātaa 'cúū chi ituu'vī tá saⁿ'ā ti vɛ́ɛ́ nuuⁿndi yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā saⁿ'a fariseo miiⁿ: Dii, Simón, vɛ́ɛ́ dɛ'ɛ̄ chi cuuví dii. Simón miiⁿ ní n'guɛɛcútaⁿ'a sa ní caⁿ'a sa: Maestro, caaⁿ'maⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús caⁿ'a yā ejemplo 'cūū: 'Uūvī 'iiⁿ'yāⁿ can'díícu yā yeⁿ'e 'áámá saⁿ'ā. 'Áámá yā ní can'díícu yā nyuⁿ'u ciento caadi, taama yā ní 'uūvī ngɛɛcu ndiichi caadi. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Naati 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ tuūmī miiⁿ yeⁿ'e yā chí nadíí'vɛ yā. 'Āā ntɛ́ɛ́ ndaaca yā tuūmī. Sáⁿ'ā chí chinnee miiⁿ ní nadach'ɛɛcú sa yeⁿ'ē ndúú 'uuvi sa. Maaⁿ ní cuuvi di 'úú, ¿chɛɛ̄ cá saⁿ'ā s'eeⁿ neⁿ'e cá yā 'iiⁿ'yāⁿ miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón miiⁿ nan'guɛɛcútaⁿ'a yā: 'Úú inadacádiinúúⁿ chi dinéⁿ'e ca yā saⁿ'ā chí n'deēe ca can'díícū miiⁿ. Jesús nan'guaacútaⁿ'a yā: N'daācā inadacadíínuuⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tuu'mi ní nguɛɛcundíī Jesús naachi canéé n'daataá mííⁿ ní caⁿ'a yā chii yā Simón: ¿'Áá ínaaⁿ di chi diiⁿ n'daātāa 'cúū? 'Úú indaá na vaacu di ní nguɛ́ɛ́ tee di nuūⁿnīⁿ chi naaⁿnú ca'á tan'dúúcā costumbre yeⁿ'ē yú naati n'daātāa 'cúū ní cheendáa tá nuūⁿnīⁿ nduutinaaⁿ tá ca'á ní nadidɛɛvɛ tá ca'á ndúúcū 'yuūdū tiīⁿ ta. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Taachí ndaá ní nguɛ́ɛ́ 'neeⁿcheendi di 'úú tan'dúúcā costumbre yeⁿ'e yú naati n'daātāa 'cúū 'áámá i'neeⁿcheendi tá ca'á, ndíí taachi sndaá. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ndíí nguɛ́ɛ́ ndúú cheendáa di aceite perfume tiíⁿ tan'dúúcā costumbre yeⁿ'e yú naati n'daātāa 'cúū cheendaa tá aceite perfume na ca'á chi diiⁿ tá honrar 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chuū ngaⁿ'á ngií, dii Simón; ti tanducuéⁿ'e nuuⁿndi chi n'deēe n'dáí yeⁿ'e tá nadach'ɛɛcú yeⁿ'ē tá caati neené neⁿ'e ta 'úú, ní diiⁿ tá 'túúcā cáávā chi nadach'ɛɛcú yeⁿ'ē tá. Ní 'iiⁿ'yāⁿ chí duū'vī neⁿ'e yā 'úú ní duū'vī nadich'ɛɛcú yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tuu'mi Jesús caⁿ'á yā chiī yā táⁿ'ā: Díí n'daataá 'úú nadich'ɛɛcú nuuⁿndi yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'Iiⁿ'yāⁿ chi vɛɛ̄tɛ́ yā na mesa miiⁿ tucá'a yā caⁿ'a yā chiī yā vi'ī: ¿Du'u sáⁿ'ā chuū chi nadicadíínuuⁿ sa chí cuuvi nadīch'ɛɛcu sa nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tuu'mí Jesús miiⁿ caⁿ'a yā chiī yā n'daataá míí: Cáávā chi i'téénu di 'úú, n̄diiⁿ chí nanguáⁿ'ai di. Maaⁿ ní cunaⁿ'ā di ndúúcū vaadī 'diīíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Cuayiivi miiⁿ, ní cheⁿ'e Jesús nuuⁿmáⁿ yáāⁿ n'gɛɛtɛ ndúúcū nuuⁿmáⁿ yáāⁿ 'lííⁿ ní ngaⁿ'a yā nduudu cuaacu yeⁿ'é Ndyuūs yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Ní ndu'u ndiichúúví apóstoles yeⁿ'e Jesús miiⁿ cueⁿ'e yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","'Tiicá ntúūⁿ n'duuvi n'daataá chi Jesús diíⁿ yā chi nanduūvā yeⁿ'e ca'ai yeⁿ'e yā ní chi diíⁿ yā chi nacan'dáā espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e náⁿ'ā n'daataa s'eeⁿ. Ní nguaaⁿ n'daataa s'eeⁿ canee María yeⁿ'e yáāⁿ Magdala. N'daata miiⁿ ní Jesús diíⁿ yā chi nán'daā ndɛɛ̄chɛ̄ espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'ē ta. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Cueⁿ'e ntúūⁿ Juana chi n'daataa yeⁿ'e saⁿ'ā chi nguuvi Chuza chí ngaⁿ'a ntiiⁿnyuⁿ sá yeⁿ'e cosas yeⁿ'e rey Herodes, ndúúcū táⁿ'ā Susana, ndúúcū 'yaaⁿ n'dáí ca n'daataá chí ca'a tá tuumī yeⁿ'ē tá ní cuaī tá 'āā dɛ'ɛ́ nūuⁿ chi neⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Taachí nduuvidaama 'yaaⁿ n'dáí 'iiⁿ'yāⁿ chi chiica yā yeⁿ'e 'yaaⁿ n'dai yáāⁿ tuu'mi ní ndaa yā nanááⁿ Jesús. Ní Jesús yaa'vi yā 'iiⁿ'yāⁿ s'eeⁿ ndúúcū 'áámá ejemplo tan'dúúcā 'áámá dendu'ū chi vɛ́ɛ́ iⁿ'yééⁿdi 'cūū. Ní caⁿ'a yā 'tíícā: ");
INSERT INTO cuxNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","'Áámá saⁿ'ā chi cuūnū ndaata mííⁿ cuéⁿ'e sa cuūnū sa. Taachí chiīnū sa 'áámá duutu ndaata chiiya 'diituú cyúúní ní ch'iinca'a 'iiⁿ'yāⁿ ní 'yaada ní che'e tī. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Duutu ndaata ní chiiya naachi vɛ́ɛ́ n'deee n'dáí tuūu. Taachí can'daā, ní ti'i ti nguɛ́ɛ́ ya'ai yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Duutu ndaata ní chiiya nguaaⁿ yááⁿ. Yááⁿ miiⁿ chi dáámá ch'iita ndúúcū yaatá ní di'vaāchí yeⁿ'ē vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Náⁿ'ā duutu ndaata ní chiiya na yáⁿ'āa n'dáacā ní taachí can'daā n'deee n'dáí cosecha chii yeⁿ'ē. Ní yeⁿ'ē 'áámá ndaata ní chiī 'aama ciento ndaata yeⁿ'ē. Taachí Jesús caⁿ'a yā nduudú 'cūū, yuūdū n'dáí caⁿ'a yā, ní caⁿ'a yā: Ndís'tiī chi vɛ́ɛ́ veéⁿ nī, ní 'caandiveéⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tuu'mi ní discípulos yeⁿ'e Jesús caⁿ'a yā chii yā Jesús: ¿Dɛ́'ɛ̄ néⁿ'é caaⁿ'maⁿ nduudú 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús miiⁿ ní caⁿ'a yā: Ndís'tiī ní maaⁿ ní cuuvi déénu nī chí cánuuⁿ n'de'ei yeⁿ'e Ndyuūs naachi ngaⁿ'a ntiiⁿnyúⁿ yā naati 'úú ní ngaⁿ'á ndúúcū nduudu chí 'tɛɛ nguɛɛ dáámá. Ní taachi 'iiⁿ'yāⁿ s'eeⁿ snaaⁿ yā nguɛ́ɛ́ cuuvi snaaⁿ n'daaca yā, ní taachí 'caandiveeⁿ yā nguɛ́ɛ́ tuumicadíínuuⁿ yā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Chuū chí neⁿ'e caāⁿ'māⁿ ejemplo miiⁿ. Ndaata miiⁿ ní chííⁿ chi tan'dúúcā nduudu yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Duutu ndaata chí chiiya ná 'diītūu cyúúní, chííⁿ chi tan'dúúcā nduudu cuaacu yeⁿ'é Ndyuūs chí 'iiⁿ'yāⁿ ch'iindiveeⁿ yā. Daacá nūuⁿ ndaa yááⁿn'guiinuuⁿ miiⁿ ní divíi sa nduudu miiⁿ na staava yeⁿ'e 'iiⁿ'yāⁿ ti nguɛ́ɛ́ cuuvi cu'téénu yā ní nguɛ́ɛ́ ndúú cuuví nnguaⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndaata chí chiiya nguaaⁿ tuūu chi nguɛ́ɛ́ dii'yu yeⁿ'ē ni tan'dúúcā nduudu cuaacu yeⁿ'é Ndyuūs chi 'iiⁿ'yāⁿ n'giindiveeⁿ yā ní yeenú taavi yā. Cánéé yā tan'dúúcā 'áámá milpa chi nguɛ́ɛ́ vɛ́ɛ́ dii'yu yeⁿ'ē. 'Iiⁿ'yāⁿ s'eeⁿ ni 'áámá tiempo nūuⁿ i'téénu yā ní taachí ndaa nguuvi chí chííⁿnyúⁿnééⁿ 'iiⁿ'yāⁿ yeⁿ'e yā chi 'cuináaⁿ yā cáávā nduudu miiⁿ ní 'iiⁿ'yāⁿ s'eeⁿ divíi yā nduudu miiⁿ na staava yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dúútú ndaata chí chiiya nguaaⁿ yááⁿ tan'dúúcā nduudu cuaacu yeⁿ'é Ndyuūs chi 'iiⁿ'yāⁿ ch'iindiveeⁿ yā. Ní 'iiⁿ'yāⁿ s'eeⁿ damáāⁿ nadacadiinúúⁿ yā yeⁿ'e vaadī 'cuiica ndúúcū dendu'ū chi idi'vaachí yeⁿ'e iⁿ'yeeⁿdí 'cūū ndúúcū dendu'ū chi vicio yeⁿ'e yā. Nducuéⁿ'ē di'vaachi nduudu miiⁿ ní diiⁿ chi nguɛ́ɛ́ dichíí'vɛ nduudu miiⁿ na vida 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Duutu ndaata chí chiiya na yáⁿ'āa n'dáacā chííⁿ chí tan'dúúcā nduudu cuaacu yeⁿ'é Ndyuūs chi 'iiⁿ'yāⁿ ch'iindiveéⁿ yā ní din'daacá yā ndúúcū 'viich'ɛɛtíínūuⁿ. Ní i'téénu yā nduudu miiⁿ na staava yeⁿ'é yā. Ní ch'iⁿ'í yā tanáⁿ'ā 'iiⁿ'yāⁿ chi i'téénu yā nduudu cuaacu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ní Jesús chi'cueeⁿ yā 'túúcā: 'Áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ngi'i yā 'áámá lámpara ní cu'nuuⁿ yā maaⁿ 'áámá 'cuɛ́ɛ́tɛ̄ɛ o cu'nuúⁿ yā maaⁿ 'áámá cama ti cu'nuúⁿ yā na 'áámá mesa ní 'iiⁿ'yāⁿ chi cundáa yā ní snaaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","'Tiicá ntúūⁿ, nducuéⁿ'ē chi nguɛ́ɛ́ deenu 'iiⁿ'yāⁿ yeⁿ'e chi cunúúⁿ n'de'ei nguɛ́ɛ́ cunee chi nguɛ́ɛ́ snaaⁿ yā. Ní nguɛ́ɛ́ chi cunúúⁿ n'de'ei chi nguɛɛ cadíínuuⁿ 'iiⁿ'yāⁿ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Caandiveeⁿ n'daacá nī cáávā chi cuuvi deenu nī ti 'iiⁿ'yāⁿ chi vɛ́ɛ́ yeⁿ'e yā ní Ndyuūs ca'a cá yā ní n'deēe cá cuuvi yeⁿ'e yā. Ní 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā 'áárá chi dúú'ví nūuⁿ chi nadacádiinúúⁿ yā chi vɛ́ɛ́ yeⁿ'e yā, chuū ní Ndyuūs divíi yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tuu'mi ní 'díínu Jesús ndúúcū chɛɛcú yā neⁿ'e yā ndaá yā nanááⁿ Jesús naati nguɛ́ɛ́ cuuvi ndaa yā caati neené 'yaaⁿ n'dai 'iiⁿ'yāⁿ snéé yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ní 'áámá 'iiⁿ'yāⁿ cueⁿ'e yā nanááⁿ Jesús ní caⁿ'a yā: N'diī Jesús, chɛɛcú nī ndúúcū 'díínu nī snée yā cuaaⁿ chuva'āī ní neⁿ'e yā snaaⁿ yā n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'ee: 'Iiⁿ'yāⁿ chí n'giindiveéⁿ yā nduudu yeⁿ'é Ndyuūs ní i'téénu yā 'iiⁿ'yāⁿ, 'iiⁿ'yāⁿ s'eeⁿ chíí chɛɛcú ní 'iiⁿ'yāⁿ s'eeⁿ chíí 'diinú. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chúū chiī. 'Áámá nguuvi Jesús miiⁿ sndaa yā na 'áámá barco ndúúcū discípulos yeⁿ'e yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cho'o yú táámá 'díítuú nuūⁿnīⁿ'yáⁿ'ā. Ní cueⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Taachí chiica yā na barco miiⁿ, Jesús miiⁿ ní cyaadu yā. Chéenū 'aama 'yúúné taaⁿ ní diiⁿ chí chindaā nuūⁿnīⁿ chɛɛti barco miiⁿ ti barco miiⁿ neⁿ'e 'cuɛɛchi nguááⁿ nuūⁿnīⁿ. Ní discípulos 'va'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tuu'mi ní discípulos s'eeⁿ ndaa yā naachi canéé Jesús miiⁿ ní nadin'duuchí yā 'iiⁿ'yāⁿ ní caⁿ'a yā: N'dii Maestro, n'dii Maestro, 'cuɛɛchi yú nguááⁿ nuūⁿnīⁿ. Taachi Jesús miiⁿ nduuchi yā, tuu'mi ní caⁿ'a yā chi cūnéé 'diīiⁿ 'yúúné miiⁿ ndúúcū nūuⁿnīⁿ, ní canéé 'diīiⁿ. Tuu'mi ní 'āā ntɛ́ɛ́ chéenū 'yúúné miiⁿ ní canéé 'diiíⁿ ní n'daacā cueⁿ'e yā ndúúcū barco miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús ní caⁿ'a yā: ¿Dɛ'ɛ cúúvī chi nguɛ́ɛ́ cu'téénu cá nī? Discípulos ní 'va'a n'daí yā ní cheⁿ'e yiinú yā ní ngaⁿ'a yā ngii yā vi'ī: ¿Du'u sáⁿ'a 'cūū chí ngaⁿ'ā ntiiⁿnyuⁿ sa yeⁿ'ē 'yúúné ndúúcū nuūⁿnīⁿ ní n'giindiveéⁿ yeⁿ'ē sa? ");
INSERT INTO cuxNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesús ndúúcū discípulos yeⁿ'e yā cueⁿ'e yā na yáⁿ'āa Gadara. Yáⁿ'āa miiⁿ ní canee 'diituú nuūⁿnīⁿ'yáⁿ'ā Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Taachí Jesús nacan'dáa yā na barco miiⁿ ní ndaa yā na yáⁿ'āa, ndaā niiⁿnuúⁿ Jesús miiⁿ 'áámá saⁿ'ā yeⁿ'e yáⁿ'āa miiⁿ. 'Āā 'naaⁿ tiempo canéé sá ndúúcū espíritus yeⁿ'e yááⁿn'guiinūuⁿ. Nguɛ́ɛ́ catecai sa ndíí nguɛ́ɛ́ ndúú canúúⁿ rá sá va'āī ti na yiivi yáává cānuuⁿ sa. Ní ndaā sa ní ndaāca sa Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ní taachi sáⁿ'a 'cūū n'dííchi sa Jesús miiⁿ chiintii'ya sá nanáaⁿ yā ní 'caī yiicú sa: N'dii Jesús, Daiya Ndyuūs chi ch'ɛɛtɛ n'dai poder yeⁿ'e nī, ¿dɛ'ɛ̄ diíⁿ nī nduucú? 'Úú di'cuiitú n'diī chi nguɛ́ɛ́ diíⁿ nī chi diíⁿ sufrir. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","'Túúcā caⁿ'a sa ti Jesús caⁿ'a ntiiⁿnyúⁿ yā chí nan'daā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e sáⁿ'ā miiⁿ. 'Āā nééné 'naaⁿ tiempo chi espíritus ichɛ́ɛ́ ndúúcū saⁿ'ā miiⁿ. 'Iiⁿ'yāⁿ s'eeⁿ yeⁿ'e yáāⁿ miiⁿ ní ngaā chiichí yā saⁿ'ā miiⁿ ndúúcū cadenas naati ch'iica sá cadenas ní espíritu yeⁿ'e yááⁿn'guiinūuⁿ candɛ́ɛ sa saⁿ'ā naachi nguɛ́ɛ́ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tuu'mi ní Jesús tiinguunéeⁿ yā saⁿ'ā miiⁿ: ¿Dɛ́'ɛ̄ nguuvi di? Saⁿ'ā miiⁿ ní caⁿ'a sa: Legión nguūví. 'Tíícā ngaⁿ'a 'iiⁿ'yāⁿ yeⁿ'ē sa ti neené 'yaaⁿ espíritus yeⁿ'e yááⁿn'guiinūuⁿ canee ndúúcu sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ní espíritus idi'cuíítū Jesús chi nguɛ́ɛ́ dichó'o yā na abismo chi canéé cuaaⁿ maaⁿ yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ní niiⁿnuúⁿ ná snée yā nééné n'deēe cuuchí vɛɛ tī 'cuɛɛti miiⁿ chi in'nuúⁿ ti chi ché'e ti. Ní espíritus di'cuíitū Jesús miiⁿ chí ca'á yā lugar chi cundáā chɛɛ̄tī cuuchí s'eeⁿ. Jesús miiⁿ ní 'cuúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tuu'mi ní espíritus yeⁿ'e yááⁿn'guiinūuⁿ nan'dáā na cuerpo yeⁿ'e saⁿ'ā miiⁿ ní sndaā na cuerpo yeⁿ'e cuuchi s'eeⁿ. Ní 'iiti s'eeⁿ ní chéénu tī na yiivi yaavā yeⁿ'e yiīcū miiⁿ ní chingéé nuúⁿ tī nguaaⁿ nuūⁿnīⁿ ní ch'íī nuúⁿ tī nguaaⁿ nuūⁿnīⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","'Iiⁿ'yāⁿ chi idiiⁿ cuidado cuuchí s'eeⁿ taachí n'diichí yā chuū, cueⁿ'é yā ngéénu yā ní cuuvi yā 'iiⁿ'yāⁿ na yáāⁿ ndúúcū 'iiⁿ'yāⁿ chi snéé na 'cuɛɛti nducuéⁿ'ē chi chiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ ní cheⁿ'e yā n'diichi yā chi chiī. Ndaá yā nanááⁿ Jesús miiⁿ ní n'diichí yā saⁿ'a chi nacan'daā espíritus yeⁿ'e yááⁿn'guiinūuⁿ. Saⁿ'ā miiⁿ ní vɛ́ɛ́ sa na ca'a Jesús. Canúúⁿ sá catecai sa ní 'āā n'daāca idiiⁿ sa. 'Iiⁿ'yāⁿ s'eeⁿ ní dii'yá yā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ní 'iiⁿ'yāⁿ s'eeⁿ chi n'diichí yā nducuéⁿ'ē chi chó'ōo caⁿ'a yā 'iiⁿ'yāⁿ chi caama ndaa yā táácā espíritus yeⁿ'e yááⁿn'guiinūuⁿ nan'dáā na cuerpo yeⁿ'e saⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tuu'mi ní nducyáácá 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Gadara di'cuíítu yā Jesús chi cuɛɛvíi yā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ti neené 'va'á yā. Tuu'mi ní Jesús ndaa yā barco miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ní saⁿ'ā chí nān'daa espíritus yeⁿ'e yááⁿn'guiinūuⁿ di'cuíítu sa Jesús miiⁿ chi cundáa sa na barco miiⁿ ndúúcu yā. Jesús yaa'vi yā saⁿ'a miiⁿ ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Cunaⁿ'ā di ná vaacu di ní caaⁿ'maⁿ di cuuvi di 'iiⁿ'yāⁿ dendu'ū chí ch'ɛɛtɛ n'dai chí Ndyuūs diíⁿ yā ndúúcū di. Saⁿ'ā miiⁿ ní cunaⁿ'a sa ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ núúⁿmáⁿ na yáāⁿ dendú'ū chi ch'ɛɛtɛ n'dai chí Jesús diíⁿ yā ndúúcū sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Taachí Jesús cueⁿ'e yā cho'o yā táámá 'diituú nuūⁿnīⁿ'yáⁿ'ā, ní ndaa yā yáāⁿ miiⁿ, 'iiⁿ'yāⁿ 'cuúⁿ yā Jesús ndúúcū vaadī yeenú ti n'deee n'daí 'iiⁿ'yāⁿ ní snee ngiinu yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Miiⁿ cánéé 'aama saⁿ'a chí nguuvi sa Jairo. Saⁿ'a miiⁿ ngaⁿ'a ntiiⁿnyuⁿ sa yeⁿ'ē yaācū sinagoga ní ndaā sa nanááⁿ Jesús ní chiintii'ya sa na ca'a Jesús miiⁿ. Ní di'cuíítú sa 'iiⁿ'yāⁿ chi cundáa yā na vaācū sa, ");
INSERT INTO cuxNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","caati 'áámá n'dyáⁿ'ā daiya sa 'āā 'nááⁿ tá tan'duu ndiichúúví nduūyū tá 'āā cháá 'cuuvi tá. Taachí cueⁿ'e Jesús miiⁿ neené n'deee 'iiⁿ'yāⁿ cueⁿ'e yā ndúúcu yā ní ndii tuunúúⁿ ngɛɛnúū chiichi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ canéé 'áámá n'daataá chí 'āā ndiichúúví ndúuyū canee tá ndúúcū 'áámá ca'āī chi ngéē yuuúⁿ yeⁿ'e cuerpo yeⁿ'ē ta. 'Āā diiⁿ tá gastar ndúúcū médicos tanducuéⁿ'ē chi vɛɛ yeⁿ'ē tá. Mar 'áámá médico nguɛ́ɛ́ ngii diyiicú yā táⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ndaā niiⁿnuⁿ tá cuaaⁿ daami Jesús ní tuū'vi tá naachi n'dɛɛ tií yeⁿ'e catecai Jesús miiⁿ. Tuu'mí nūuⁿ caneé naaⁿ chi ingéē yuuúⁿ yeⁿ'e cuerpo yeⁿ'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tuu'mi ní Jesús miiⁿ caⁿ'a yā: ¿Du'u tuū'vi 'úú? Nducyáácá 'iiⁿ'yāⁿ ní caⁿ'a yā: Nguɛɛ 'úú. Pedro miiⁿ ní caⁿ'a sa: N'dii Maestro, 'iiⁿ'yāⁿ miiⁿ ní i'nuuⁿ chiichí yā n'diī ní táácā chi ngaⁿ'a nī: ¿Du'ú tuū'vī 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús caⁿ'a yā: Vɛ́ɛ́ du'ū chi tuū'vī 'úú. 'Úú ní deenú chi ndúúcū poder yeⁿ'é nduūvā yeⁿ'e 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Taachi n'daata mííⁿ tuumicádiinuuⁿ tá chi Jesús deenú yā in'duuví n'dai tá ní ndaā tá nanááⁿ Jesús miiⁿ ní chiintiī'yā ta nanáaⁿ yā. Ní caⁿ'a cuaacu tá nanááⁿ nducyáácá 'iiⁿ'yāⁿ dɛ'ɛ̄ cáávā chí tuū'vi tá catecai Jesús. Ní hora mííⁿ nūuⁿ chí tuu'vi ta nduūvā yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús miiⁿ ní caⁿ'a yā: Díí, daiyá, cáávā chi i'teenú di 'úú, ní nduūvā yeⁿ'ē di. Maaⁿ ní cunaⁿ'a di na vaacu di ndúúcū vaadī 'diīíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ní taachi Jesús ngaⁿ'a yā chuū ndaā 'áámá saⁿ'ā yeⁿ'e na vaacu saⁿ'ā chí ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'ē yaācū sinagoga. Ndaā sa nanááⁿ Jairo ní caⁿ'a sa: 'Āā ch'iī daiya di. 'Āā ntɛ́ɛ́ yaa'vi di Maestro. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús miiⁿ ch'iindiveéⁿ yā nduudu 'cūū ní caⁿ'a yā: Nguɛ́ɛ́ 'va'ā di. Cu'téénu di 'úú ní nanduūchi ta yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tuu'mi ní Jesús sndaa yā na vaacu Jairo. Nguɛ́ɛ́ 'cuuⁿ yā chi nducyaaca 'iiⁿ'yāⁿ sndaá yā ndúúcu yā cuaaⁿ chɛɛti va'āī miiⁿ, dámaāⁿ Pedro ndúúcū Jacobo, ndúúcū Juan, ndúúcū chɛɛcu n'daata 'lííⁿ, ndúúcū chiida tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nducyaaca yā cuaaⁿ chuva'āī ch'ɛɛtinée yā ní ngɛɛcu yā ní n'gai yā ti ya'áí yā caavā tá. Ní Jesús caⁿ'a yā: Nguɛ́ɛ́ cuɛɛcú nī. Nguɛ́ɛ́ n'diī tá ti cyaadu tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","'Iiⁿ'yāⁿ s'eeⁿ ní taachi n'giindiveéⁿ yā nduudu yeⁿ'e Jesús miiⁿ ch'ííⁿnyuⁿneeⁿ yā yeⁿ'e Jesús miiⁿ ti 'āā deenú yā chí 'āā n'diī tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tuu'mi ní Jesús ndaa yā cuaaⁿ chɛɛti va'āī ní sta'á yā ta'ā tá ní caⁿ'a yuudú yā: Dii, ta'dííⁿ, nducueeⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hora mííⁿ nūuⁿ espíritu yeⁿ'ē ta'dííⁿ mííⁿ nnguɛɛcunéé ndúúcū ta. Tuu'mí nūuⁿ nducueⁿē tá. Jesús caⁿ'a ntiiⁿnyúⁿ yā chí ca'á yā chi che'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chiida tá ndúúcū chɛɛcu tá neené ngeⁿ'e yiinu yā ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ cuuví nī chi nnduuchi tá yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús yaa'ví yā ndu'u ndiichúúví discípulos yeⁿ'é yā ní ca'a yā poder. Ní caⁿ'a yā chí tun'dáa yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ ní diíⁿ yā chí nduūvā yeⁿ'é 'iiⁿ'yāⁿ chi ngíitā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ní Jesús dichó'o yā discípulos chí caaⁿ'maⁿ yā nduudu n'dai yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní diíⁿ yā chi nduuvā yeⁿ'e 'iiⁿ'yāⁿ chi ngíitā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: Ndís'tiī nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ candɛ́ɛ nī cuaaⁿ cyúúní. Nguɛ́ɛ́ ndúú in'daacuú, ndíí nguɛ́ɛ́ ndúú morral, ndíí nguɛ́ɛ́ ndúú pan ra, ndíí nguɛ́ɛ́ ndúú tuūmī ra, ndíí nguɛ́ɛ́ nduu candɛ́ɛ nī 'uūvī catecai. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ní 'āā tií nūuⁿ va'ai naachi ndaa nī 'cuɛɛtinée nī miiⁿ ní ndíí taachi ndaá nī ndíí taachi nan'dáa nī yeⁿ'e yaāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ní naachi ndaa nī 'áámá yáāⁿ ní 'iiⁿ'yāⁿ nguɛ́ɛ́ 'cuaáⁿ yā ndís'tiī, tuu'mi ní nan'dáa nī yeⁿ'e yáāⁿ miiⁿ ní n'dáádi nī yaācáā yeⁿ'e ca'a nī. Chuū ní 'áámá señal chi 'cuuⁿ'míⁿ nī chi nguɛ́ɛ́ n'daacā idiíⁿ yā ti contra yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Discípulos ican'dáa yā ní cheⁿ'é yā nuuⁿmáⁿ cuaaⁿ yáāⁿ s'eeⁿ ní nduu cuááⁿ ní ngaⁿ'a yā nduudu ngai yeⁿ'é Ndyuūs, nduudu chi nanguaⁿ'āī 'iiⁿ'yāⁿ. Ní diíⁿ yā chi nduūvā yeⁿ'é 'iiⁿ'yāⁿ chi ngiītā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ch'iindiveeⁿ rey Herodes tanducuéⁿ'ē chí Jesús miiⁿ idiíⁿ yā ní 'āā ntɛɛ déénu yā dɛ'ɛ̄ nadicadíínuuⁿ yā. Ní vɛ́ɛ́ 'uūvī vandiicádiinúúⁿ yā caati náⁿ'ā 'iiⁿ'yāⁿ ní ngaⁿ'a yā chi Jesús chi Juan miiⁿ chí nduuchi yā yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Náⁿ'a yā ní ngaⁿ'a yā chi profeta Elías miiⁿ ní 'āā che'enaáⁿ yā. Náⁿ'a yā ní ngaⁿ'a yā chi 'áámá profeta chí n'díi yā ndíí yeⁿ'e tiempo chí 'āā 'naaⁿ nandúúchi yā yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ní rey Herodes miiⁿ ní caⁿ'a yā: 'Úú caⁿ'ā ntiiⁿnyúⁿ chi 'chiītá daandu saⁿ'ā chi Juan chi chɛɛdínuūⁿnīⁿ sa. ¿Dú'ū chi saⁿ'ā miiⁿ chi ch'iindiveéⁿ tanducuéⁿ'ē yeⁿ'ē sa? 'Úú neⁿ'é cadiinúúⁿ ní neⁿ'é snaáⁿ sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Taachi discípulos ndaá yā naachí canee Jesús, tuu'mi ní caⁿ'a yā Jesús tanducuéⁿ'e chi diiⁿ yā. Cuayiivi ní Jesús cueⁿ'é yā ndúúcū discípulos yeⁿ'e yā nííⁿnuúⁿ na yáāⁿ Betsaida ní cueⁿ'é yā cuɛɛti yeⁿ'ē yáāⁿ miiⁿya. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Taachí 'iiⁿ'yāⁿ cadíínuuⁿ yā yeⁿ'e Jesús miiⁿ, cueⁿ'é yā n'dáa yā 'iiⁿ'yāⁿ. Ní Jesús 'cuuⁿ yā 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. Ní diíⁿ yā chi nduūvā yeⁿ'é 'iiⁿ'yāⁿ chí ngiita yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Taachí chi chiīnū, ndu'u chi ndiichúúví yā ndaá yā nanááⁿ Jesús ní caⁿ'a yā chii yā Jesús: Yaa'vi nī 'iiⁿ'yāⁿ s'eeⁿ chí caⁿ'a yā cuaaⁿ yáāⁿ s'eeⁿ, ní cuaaⁿ yáāⁿ 'lííⁿ naachi snéé 'iiⁿ'yāⁿ ní vɛ́ɛ́ naachi 'cuɛɛtinée yā ní ndaaca yā chí che'e yā, ti nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ naachi snée yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús caⁿ'a yā chii yā discípulos: Ndís'tiī ní ca'a nī chi che'e yā. Discípulos ní caⁿ'a yā: 'Āā ntɛ́ɛ́ n'deēe yeⁿ'é 'nū vɛ́ɛ́ ti táá nyuⁿ'u nūuⁿ pan ndúúcū 'uūvī 'yaācā. Nguɛ́ɛ́ cuuvi diíⁿ 'nū cuái 'nū chi che'e nducyaaca 'iiⁿ'yāⁿ s'tíī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Miiⁿ ní snéé taanduu nyuⁿ'u mil saⁿ'ā. Tuu'mi ní Jesús miiⁿ caⁿ'á yā chii yā discípulos yeⁿ'e yā: Caaⁿ'maⁿ ntiiⁿnyúⁿ nī 'iiⁿ'yāⁿ s'eeⁿ chí 'cuɛɛtɛ́ yā 'uūvī ngɛɛcu ndiichí yā 'aama 'áámá cuaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Tíícā diíⁿ discípulos ní ch'ɛɛtɛ́ nducyaaca 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tuu'mi ní Jesús miiⁿ sta'á yā ndu'u nyuⁿ'u pan ndúúcū nduu 'uuví 'yaācā. Ní 'iicu n'diichí yā nanguuvi ní ca'á yā gracias Dendyuūs cáávā pan ndúúcū 'yaācā miiⁿ. Cuayiivi ní Jesús n'deé yā pan ndúúcū 'yaācā ní ca'a yā discípulos yeⁿ'e yā. Ch'iinu ní discípulos ca'a ntúuⁿ yā 'iiⁿ'yāⁿ s'eeⁿ chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Che'e nducyaaca yā ní chiituú 'iiⁿ'yāⁿ. Cuayiivi ní discípulos nan'gaáⁿ yā chí ningaavā ní chiituú tá ndiichuuvi 'cuɛɛ̄tɛ̄ɛ chí ningaāvā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","'Áámá nguuvi taachí Jesús ndúúcū discípulos yeⁿ'é yā canée yā 'aama lado ní ngaⁿ'āngua'á yā, tuu'mi ní Jesús itiinguunéeⁿ yā discípulos: ¿Du'ū 'úú ngaⁿ'a 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Iiⁿ'yāⁿ s'eeⁿ ní n'guɛɛcútaⁿ'a yā: Náⁿ'a yā ní ngaⁿ'a yā chi díí Juan chi chɛɛ̄dínuūⁿnīⁿ sa díí. Náⁿ'a yā ní ngaⁿ'a yā chi díí ní profeta Elías díí; ní náⁿ'a yā ní ngaⁿ'a ntuúⁿ yā chí díí ní 'aama profeta chi 'āā 'naaⁿ tiempo chi n'dii ní nnduuchí yā yeⁿ'e nguaaⁿ tinaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús miiⁿ ní caⁿ'a yā: Ndís'tiī, tuu'mi, ¿du'ū 'úú ngaⁿ'a nī? Tuu'mi ní Simón Pedro nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: N'diī chí Cristo yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús chii yā 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ cuuvi yā chuū mar 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tuu'mi ní Jesús caⁿ'a yā: Cánéé chí 'úú chí Saⁿ'ā chi Daiyá Ndyuūs n'deee n'dáí 'cueenú cuuvi ní 'íícú saⁿ'ā ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'ē yaācū ndúúcū chiiduú n'gɛɛtɛ chi ngaⁿ'a ntiiⁿnyúⁿ yā ndúúcū maestros yeⁿ'e ley ní nguɛ́ɛ́ neⁿ'e yā snaaⁿ yā 'úú chí Saⁿ'ā chi Daiya Ndyuūs. Ní canéé chi 'caaⁿ'núⁿ yā 'úú. Ní 'úú nduuchí yeⁿ'ē nguaaⁿ tináⁿ'ā ndii 'cuíínú 'iīnū nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Cuayiivi ní Jesús ngaⁿ'a yā ngii yā nducyáácá 'iiⁿ'yāⁿ: Ndúútí chi 'áámá 'iiⁿ'yāⁿ neⁿ'e yā caⁿ'a yā nduucú, canéé chí cu'nééⁿ maáⁿ yā tanducuéⁿ'ē dendu'ū chi vɛ́ɛ́ yeⁿ'e yā, ní nguuvi nguuvi cuta'á yā cruz yeⁿ'e yā chí tan'dúúcā chi 'cueenu taaví yā cuuvi cucáávā 'úú ní caⁿ'a yā nduūcú. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Caati nducyaaca 'iiⁿ'yāⁿ chi neⁿ'e cá yā nadanguáⁿ'ai yā vida yeⁿ'e maaⁿ yā na iⁿ'yeeⁿdí 'cūū dindaí yā táámá vida yeⁿ'e yā nanááⁿ Ndyuūs. Ní nducyaaca 'iiⁿ'yāⁿ chi dindaí yā vida yeⁿ'e yā cucáávā 'úú ndaāca yā táámá vida yeⁿ'é yā nanááⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Dɛ'ɛ dichíí'vɛ̄ saⁿ'ā ndúúti chi diiⁿ sa ganar nducuéⁿ'ē chi vɛ́ɛ́ na iⁿ'yeeⁿdí 'cūū ní diíⁿ sa chi dindaí sa vida cueⁿ'e daāⁿmaⁿ chi táámá vida yeⁿ'e yā ní idituuví sa maāⁿ vida yeⁿ'e sa? ");
INSERT INTO cuxNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ní 'iiⁿ'yāⁿ chi cuuvi 'cuináaⁿ yā yeⁿ'ē 'úú nanááⁿ 'iiⁿ'yāⁿ ndúúcū nduudu yeⁿ'é tuu'mi ní 'úú chi Saⁿ'a chi Daiya Dendyuūs cuuví 'cuinaáⁿ yeⁿ'é 'iiⁿ'yāⁿ 'cúū taachi 'úú ndaá taama vmnéⁿ'ēe tan'dúúcā Rey ndúúcū poder yeⁿ'ē Chiidá ndúúcū poder yeⁿ'ē maáⁿ ní ndúúcū ángeles. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Úú ngaⁿ'a cuaacú ndúúcū ndís'tiī, chi vɛɛ náⁿ'a nī chi snee nī 'muuⁿ chi nguɛ́ɛ́ 'cuūvi nī taanduvɛ́ɛ́ ndíí snaaⁿ nī yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ch'íínú nííⁿníⁿ nguuvi chí Jesús caⁿ'a yā nduudu 'cūū, Jesús cueⁿ'e yā ndúúcū Pedro, ndúúcū Juan ndúúcū Jacobo ní chɛɛ yā na yiīcū chí caaⁿ'maⁿngua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ní taachi Jesús ngaⁿ'angua'á yā, n̄'dááⁿ naaⁿ yā ní catecai yā nduuvī cuɛ́ɛ̄ ní ngii n'gaī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ní tuu'mí nūuⁿ che'enaāaⁿ na 'uuvi saⁿ'ā ndúúcū Jesús. Saⁿ'ā s'eeⁿ chiiⁿ Moisés ndúúcū profeta Elías chí 'āā 'naaⁿ tiempo chi n'dīi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nduu 'iinú yā ní na chidɛɛvɛ chi ngíí n'gai yeⁿ'ē va'ai chɛɛti nguuvi snée yā. Ní ngaⁿ'a yā yeⁿ'ē chí 'cuūvī Jesús ní 'cueenu taaví yā na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","N'dáá rá chí cyaadu Pedro ndúúcū Juan ndúúcū Jacobo nadacueéⁿ yā ní n'diichi yā chí ngíí n'gai naaⁿ Jesús ndúúcū saⁿ'ā s'eeⁿ chi canee ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ní taachí Elías ndúúcū Moisés chivíi yā yeⁿ'e Jesús ní 'āā cuɛ́ɛ́ caⁿ'a yā, tuu'mi ní Pedro miiⁿ ní caⁿ'a yā chiī yā Jesús: N'dií Maestro, dɛ'ɛ chúúcā n'daācā yeⁿ'e yú chi 'cuɛɛtinée yú 'muuⁿ. Ní din'dái 'nū 'iīnū va'ai n'gaiyáā; 'áámá yeⁿ'e nī, 'áámá yeⁿ'ē Moisés, ni 'áámá yeⁿ'ē Elías. Pedro miiⁿ ní nguɛ́ɛ́ déénu yā dɛ'ɛ̄ chí ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ní neⁿ'e chi ngaⁿ'a Pedro miiⁿ ndaā 'áámá meēeⁿ ní sn'díī 'iiⁿ'yāⁿ s'eeⁿ ní 'va'a yā chi ndaa meēeⁿ vmnaaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tuu'mi ní ch'iindiveéⁿ yā 'áámá nduudu chí ngaⁿ'ā nguaaⁿ meēeⁿ: Sáⁿ'a 'cūū ní Daīyá chí neⁿ'e taaví. Cu'neeⁿ veéⁿ nī nducuéⁿ'ē chi ngaⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ch'íínú ch'iindiveéⁿ yā nduūdū miiⁿ ní discípulos n'diichí yā chi Jesús miiⁿ caneé yā dámaaⁿ yā nduucú yā. Ní discípulos ch'ɛɛtinee 'diīiⁿ cheendí yā nguuvi s'eeⁿ ní nguɛ́ɛ́ chii yā mar 'áámá 'iiⁿ'yāⁿ yeⁿ'ē chí n'diichi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Táámá nguuvi cuayiivi, 'iiⁿ'yāⁿ s'eeⁿ ní nangua'á yā yeⁿ'e yiīcū miiⁿ ní nééné 'yaaⁿ 'iiⁿ'yāⁿ can'dáa yā na yáāⁿ ní cueⁿ'é yā chí ndaacá yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tuu'mi ní 'áámá saⁿ'ā chi canéé ndúúcū 'iiⁿ'yāⁿ s'eeⁿ 'cái sa: N'dií Maestro di'cuíítūu n'diī chí snaaⁿ nī daiyá tí 'áámá n'dyáⁿ'ā daiyá. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ti 'áámá espíritu yeⁿ'e yááⁿn'guiinūuⁿ ita'a saⁿ'ā ní ndááca naāaⁿ nn'gaī sa ní 'caí diitú sa ní ican'daā yáīⁿ cuaaⁿ cheendi sa ní n'deee n'dáí tiempo chi nééné taaⁿ idiiⁿ espíritu yeⁿ'e yááⁿn'guiinūuⁿ ndúúcū sa ní nguɛ́ɛ́ ngii vii espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ní 'āā diíⁿ 'cuíítuú discípulos yeⁿ'e nī chi divií yā espíritu miiⁿ yeⁿ'ē daiyá naati nguɛ́ɛ́ cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús nan'guɛɛcútaⁿ'a yā: Ndís'tiī, 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu nī ndíí nguɛ́ɛ́ ndúú idiiⁿ n'daacá nī. ¿'Áá 'naaⁿ tiempo canéé chí cuneé ndúúcū ndis'tiī? ¿'Áá 'naaⁿ tiempo ní canéé chí cuchɛɛ́ ndúúcū ndis'tiī? Ní ngaⁿ'a yā ngii yā sáⁿ'ā miiⁿ: Cuchíi di nanaáⁿ ndúúcū daiya di. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Taachí saⁿ'ā 'dííⁿ miiⁿ ndaa niiⁿnuúⁿ sá nanááⁿ Jesús miiⁿ, espíritu yeⁿ'e yááⁿn'guiinūuⁿ miiⁿ chindɛɛ̄vɛ saⁿ'ā 'díí miiⁿ ní ch'ɛɛcundáā saⁿ'ā. Ní Jesús yaa'vinéeⁿ yā espíritu yeⁿ'e yááⁿn'guiinūuⁿ chí divíī yeⁿ'e saⁿ'a 'dííⁿ miiⁿ, ní nanduūvā yeⁿ'ē sa. Tuu'mi ní Jesús nca'á yā saⁿ'ā 'dííⁿ miiⁿ chiida sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nducyáácá 'iiⁿ'yāⁿ ngeⁿ'e yiinu yā yeⁿ'ē poder yeⁿ'e Dendyuūs chí ch'ɛɛtɛ n'dai. Ní taachi nducyaaca yā cheⁿ'e yiinu yā yeⁿ'e tanducueⁿ'ē chí diīⁿ Jesús miiⁿ, Jesús caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ní chii yā discípulos yeⁿ'e yā: 'Caandiveéⁿ nī n'daācā yeⁿ'e tanducuéⁿ'ē nduudu chi caaⁿ'máⁿ ní nguɛ́ɛ́ cuuvi naáⁿ nī yeⁿ'ē. 'Úú Saⁿ'ā chi Daiya Ndyuūs 'úú ní 'iiⁿ'yāⁿ canee chí naca'a yā 'úú ta'ā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Discípulos ní nguɛ́ɛ́ tuumicádiinuuⁿ yā nduudu chi ngaⁿ'a Jesús. Canúúⁿ n'de'ei nduudú 'cūū yeⁿ'e yā. Ní nguɛ́ɛ́ túúmícádiinuuⁿ yā. Ní 'va'á yā chi ntiinguuneeⁿ yā Jesús dɛ'ɛ̄ neⁿ'e caaⁿ'maⁿ nduudú 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tuu'mi ní discípulos yeⁿ'e yā tucá'a yā caⁿ'a yā ndúúcū vi'ī: ¿Du'ū ca chi ch'ɛɛtɛ ca nguaaⁿ s'uūúⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús tuumicadíínuuⁿ yā táácā chi discípulos nadicádiinuuⁿ yā na staava yeⁿ'e yā ní sta'á yā 'áámá saⁿ'ā 'lííⁿ ní s'neeⁿ yā saⁿ'ā nanáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi 'cuaaⁿ yā saⁿ'ā 'lííⁿ 'cūū ndúúcū chi duuchí 'cuaáⁿ yā 'úú. 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi 'cuaáⁿ yā 'úú 'cuaáⁿ yā 'iiⁿ'yāⁿ chi dichó'o yā 'úú. 'Iiⁿ'yāⁿ chí ndiicuuⁿ ca yā nguaaⁿ ndis'tiī ní 'iiⁿ'yāⁿ 'cúū, ní ch'ɛɛtɛ ca yā nguaaⁿ ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tuu'mi ní Juan caⁿ'a yā chii yā Jesús: N'dií, Maestro, 'āā n'diichí 'nū 'áámá saⁿ'ā chi divíi sa espíritus yeⁿ'ē yááⁿn'guiinūuⁿ yeⁿ'e 'iiⁿ'yāⁿ ndúúcū chi duuchí nī; ní nguɛ́ɛ́ cuúⁿ 'nū ti nguɛ́ɛ́ canee sa ndúúcu yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús caⁿ'a yā chii yā Juan: 'Cuaáⁿ nī chi diiⁿ sa 'túúcā; ti 'iiⁿ'yāⁿ chi nguɛ́ɛ́ diíⁿ yā contra yeⁿ'e s'uūúⁿ, 'iiⁿ'yāⁿ miiⁿ snée yā favor yeⁿ'ē yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Taachi snuū ca'a nguuvi miiⁿ chí Jesús miiⁿ canéé chí caⁿ'á yā na va'ai chɛɛti nguuvi, Jesús 'āā deenú yā dɛ'ɛ̄ chi diíⁿ yā ní cueⁿ'e yā ndúúcū valor na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ní dicho'ó yā na 'úúví saⁿ'ā vmnááⁿ yeⁿ'e yā. Saⁿ'ā s'eeⁿ ní cueⁿ'ē sa ní sndaā sa na 'áámá yáāⁿ yeⁿ'e yáⁿ'āa Samaria chi in'nuuⁿ sa nááchí 'cuɛɛtinée yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ní 'iiⁿ'yāⁿ samaritanos nguɛ́ɛ́ 'cuuⁿ yā Jesús miiⁿ ti chicadiinuuⁿ yā chi Jesús caⁿ'a yā yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Taachí discípulos yeⁿ'e yā n'giindiveéⁿ yā chuū, Jacobo ndúúcū Juan caⁿ'a yā: N'dií, Señor, ¿'áá neⁿ'e nī chí caaⁿ'maⁿ ntiiⁿnyuⁿ yú chi cun'geēⁿ yaⁿ'ā yeⁿ'ē nanguuvi ní di'cuiīnú yú 'iiⁿ'yāⁿ 'muuⁿ tan'dúúcā chi diiⁿ profeta Elías miiⁿ tiempo chi chó'ōo caati 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ neⁿ'é yā 'cuaāⁿ yā s'uūúⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Tuu'mi ní Jesús miiⁿ yaa'vineeⁿ yā Jacobo ndúúcū Juan ní caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Ndís'tiī ní nguɛ́ɛ́ tuumicádiinuuⁿ nī dɛ'ɛ espíritu yeⁿ'ē chi ngaⁿ'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","'Úú, ní Saⁿ'ā chi Daiyá Ndyuūs. 'Úú ní nguɛ́ɛ́ cúchií chí dindaí vida yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ naati chí nadinguaⁿ'aí vida yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. Tuu'mi ní cho'ó yā yáāⁿ miiⁿ ní cueⁿ'e yā táámá yáāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Taachi snúuⁿ yā yúúní, 'áámá saⁿ'ā ní caⁿ'a sa chii sa Jesús miiⁿ: N'dií, Señor, caⁿ'á nduucú nī 'āā tií nūuⁿ naachi caⁿ'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: 'Yuunéē ni vɛ́ɛ́ yiivi yáává yeⁿ'e tī ní 'yaada ní vɛ́ɛ́ 'dɛ́ɛ́cɛ tī; naati 'úú, Saⁿ'ā chi Daiya Dendyuūs, nguɛ́ɛ́ mar 'áámá cuaaⁿ naachi cundiītí tiíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ní caⁿ'a yā chii yā 'áámá saⁿ'ā: Cuchíi nī nduucú. Ní saⁿ'ā miiⁿ ní caⁿ'a sa: N'diíⁿ Señor, tée nī lugar 'úú ti caⁿ'á 'cuūchí chiidá ní caⁿ'ā yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús caⁿ'a yā: Cu'neeⁿ dí 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu yā chi 'cuūchí yā tinaⁿ'ā yeⁿ'e yā ti 'iiⁿ'yāⁿ s'eeⁿ chi tan'dúúcā tinaⁿ'ā miiⁿ, 'tiicá yā. Dii ní cueⁿ'e di ní caaⁿ'maⁿ di nduudu yeⁿ'é Ndyuūs yeⁿ'e naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tuu'mi ní táámá saⁿ'ā caⁿ'a sa chii sa Jesús miiⁿ: N'dií, Señor, 'úú neⁿ'é caⁿ'á nduucú nī naati tée nī lugar 'úú ti caⁿ'á yaa'ví 'iiⁿ'yāⁿ chi snúuⁿ yā ndavaacú chi caⁿ'á ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús caⁿ'a yā chii yā saⁿ'ā miiⁿ: 'Āā du'ú nūuⁿ saⁿ'ā chi cuūndū tá'a sa na laatú ní 'cuíínu sa cuaaⁿ dáámí sá, nguɛ́ɛ́ dichíí'vɛ̄ sa chi cuuvi sa caⁿ'a sa nduucú ní diiⁿ sa ntiiⁿnyuⁿ yeⁿ'é naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Cuiinú chúū ní Jesús nandɛɛvɛ yā tá 'iīnū ngɛɛcu ndiichi discípulos yeⁿ'e yā ní dichó'o yā cá'uūvī ca'uuví yā. Ní cueⁿ'e yā cuááⁿ vmnaaⁿ yeⁿ'e Jesús cuaaⁿ nducyáácá yáāⁿ ndúúcū nduu cuaaⁿ naachi Jesús canéé chi cáⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ní Jesús ngaⁿ'a yā ngiī yā 'iiⁿ'yāⁿ s'eeⁿ: 'Cuaacu nííⁿnyúⁿ chi nééné n'deēe cosecha vɛ́ɛ́ chi nééné n'deēe 'iiⁿ'yāⁿ chi canéé chi 'caandiveeⁿ yā nduudu yeⁿ'é Ndyuūs naati saⁿ'ā chi idiiⁿ ntiiⁿnyuⁿ nguɛ́ɛ́ 'yaaⁿ sa. Cáávā chuū di'cuíítu nī 'iiví Ndyuūs chí dichó'o yā 'iiⁿ'yāⁿ chi caaⁿ'maⁿ yā nduudu cuaacu yeⁿ'é Ndyuūs ní nadacuéeⁿ yā cosecha yeⁿ'é Ndyuūs. Cosecha miiⁿ ní tan'dúúcā 'iiⁿ'yāⁿ chi cu'téénu yā Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ndís'tiī cueⁿ'e nī caati 'úú dicho'ó ndís'tiī chi ndís'tiī ní caⁿ'a nī tan'dúúcā 'iiti cuūchī caⁿ'a tī nguaaⁿ lobos. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nguɛ́ɛ́ candɛ́ɛ nī bolsa ndúúcū tuūmī, ndíí nguɛ́ɛ́ nduu morral, ndíí nguɛ́ɛ́ ndúú ndaacuú yeⁿ'e nī. Ní taachi diíⁿ nī saludar 'iiⁿ'yāⁿ cuaaⁿ cyúúní, ní nguɛ́ɛ́ cuuvi 'naaⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ní tanducuéⁿ'ē va'āī chi ndaá nī caaⁿ'máⁿ nī vmnááⁿ vmnaaⁿ 'túúcā: Cuneé 'iiⁿ'yāⁿ yeⁿ'e va'áí 'cūū ndúúcū vaadī 'diīíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ní nduuti chi 'iiⁿ'yāⁿ ní ndiicúuⁿ yā na va'ai miiⁿ, tuu'mi ní vaadī 'diīíⁿ cunéé ndúúcu yā. Ní nduuti chi nguɛ́ɛ́ vɛ́ɛ́ 'iiⁿ'yāⁿ ndiicúūⁿ na va'ai miiⁿ, vaadī 'diīíⁿ nguɛ́ɛ́ cunéé ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Cuɛɛtinée núúⁿ nī va'āī naachí 'iiⁿ'yāⁿ 'cuaáⁿ yā ndís'tiī. Che'é nī ní cu'u nī chi tée yā caati 'iiⁿ'yāⁿ chi idiiⁿ ntíiⁿnyuⁿ canéé chi nduuvi 'íí'vɛ yā. Ndís'tiī nguɛ́ɛ́ caⁿ'a nī nduu va'āī nduu va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Āā tií nūuⁿ yáāⁿ naachi cūndaa nī ní 'iiⁿ'yāⁿ mííⁿ 'cuaáⁿ yā, che'é nī 'āā dɛ'ɛ́ nūuⁿ chi tée yā chi che'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Idiíⁿ nī chi índuūvā yeⁿ'é 'iiⁿ'yāⁿ chi ngiītā chi sneé yā na yáāⁿ. Ní cuuvi nī 'iiⁿ'yāⁿ yeⁿ'ē naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní 'āā ndaā niiⁿnuúⁿ naachi snée yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Naati 'āā tií nūuⁿ yáāⁿ naachi ndaá nī ní 'iiⁿ'yāⁿ ní nguɛ́ɛ́ 'cuáaⁿ yā ndís'tiī, tuu'mi ní can'daa nī cuaaⁿ cyúúní ní caaⁿ'maⁿ nī 'túúcā: ");
INSERT INTO cuxNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ndíí yaācáā yeⁿ'ē yáaⁿ 'cūū chí caī na ca'á 'nū n'dáádi 'nū ti nguɛ́ɛ́ cu'teenu nī yeⁿ'é 'nū. Naati cadíínuuⁿ nī chuū chi yeⁿ'ē naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní 'āā ndaā niiⁿnuúⁿ naachi snée nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'Úú, Jesús, ngaⁿ'á ngií ndís'tiī chi nguuvi taachi Ndyuūs caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ, castigo yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ s'tiī ní diītu cá ní nguɛ́ɛ́ ti chi cuuvi yeⁿ'e 'iiⁿ'yāⁿ chi nguɛ́ɛ́ din'daācā yeⁿ'e yáāⁿ Sodoma. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Caⁿ'a Jesús: Dɛ'ɛ̄ chúúcā ya'ai yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Corazín. Dɛ'ɛ̄ chúúcā ya'ai yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Betsaida. Ti ndúútī chi 'iiⁿ'yāⁿ na yáⁿ'āa Tiro ndúúcū 'iiⁿ'yāⁿ na yáⁿ'āa Sidón n'diichí yā vaadī n'giinu chí chiī nguaaⁿ ndís'tiī, 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa s'eeⁿ 'āā 'naaⁿ ndaācādaamí yā yeⁿ'ē nuuⁿndi yeⁿ'e yā. Ní ch'ɛɛtinúuⁿ yā catecai yā tan'dúúcā díínūuⁿ ní ch'ɛɛtɛ́ yā nguaaⁿ yaiyáā tan'dúúcā costumbre yeⁿ'e 'iiⁿ'yāⁿ miiⁿ ndíí vmnaaⁿ taachi chiⁿ'i yā chi neené yaⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cáávā chuū ní 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Tiro ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Sidón 'duū'vī cá castigo yeⁿ'é yā nguɛ́ɛ́ ti yeⁿ'e ndís'tiī taachí ndaā nguuvi chí Ndyuūs caaⁿ'maⁿ yā nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ndís'tiī, 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Capernaum, neⁿ'é nī diíⁿ nī chi maáⁿ nī n'gɛɛtɛ́ nī naati caⁿ'á nī na infierno. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Iiⁿ'yāⁿ chí n'giindiveéⁿ yā nduudu yeⁿ'ē ndis'tiī ní nduudu yeⁿ'ē 'úú n'giindiveéⁿ yā. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ neⁿ'e yā ndís'tiī, nguɛɛ neⁿ'e yā 'úú. Ní nguɛ́ɛ́ neⁿ'e yā Ndyuūs ti 'iiⁿ'yāⁿ miiⁿ dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nguɛɛcuunéé ndu'ū 'iīnū ngɛɛcu ndííchí discípulos ndúúcū vaadī yeenú. Ní caⁿ'a yā: N'dií, Señor, espíritus yeⁿ'e yááⁿn'guiinūuⁿ n'giindiveeⁿ sa yeⁿ'e 'nū chi caaⁿ'maⁿ ntiiⁿnyúⁿ 'nū ndúúcū chiduuchí nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús caⁿ'a yā: Cuáácú 'úú ní inaáⁿ yááⁿn'guiinūuⁿ tan'dúúcā chi sn'daā sa yeⁿ'ē nánguuvi tan'dúúcā 'cuai. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ní Jesús caⁿ'a yā chiī yā discípulos yeⁿ'e yā: 'Úú ní teé poder ndís'tiī chí cunnca'á nī cúú ndúúcū 'iiti dáⁿ'āi, níícu cuchɛ́ɛ nī ndúúcū 'iiⁿ'yāⁿ chi contra yeⁿ'e nī. Ní nguɛ́ɛ́ du'ū vɛɛ cuuvi cuchɛ́ɛ́ yeⁿ'e ndís'tiī. Ní nguɛ́ɛ́ idiiⁿ daño ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ndís'tiī nguɛ́ɛ́ ngii yeenú nī taachi caaⁿ'máⁿ nī ntiiⁿnyuⁿ yeⁿ'ē espíritus yeⁿ'e yááⁿn'guiinūuⁿ ní n'giindiveēⁿ yeⁿ'e nī naati yeenú nī chi canéé nguūⁿ chi dúúchí nī na libro yeⁿ'é Ndyuūs na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hora mííⁿ nūuⁿ Jesús yeenú n'dai yā cáávā Espíritu N'dai yeⁿ'é Ndyuūs ní caⁿ'a yā: N'diī, Chiidá, 'úú ní teé gracia n'diī chi 'iiví nī yeⁿ'e va'ai chɛɛti nguuvi ndúúcū yáⁿ'āa 'cúū caati snuuⁿ n'dé'ei nī nduudú 'cūū yeⁿ'e 'iiⁿ'yāⁿ chi déénu ca yā ndúúcū 'iiⁿ'yāⁿ chi n'deēe n'dáí túúmícádíínuuⁿ yā. Ní ca'á nī chi cadíínūuⁿ 'iiⁿ'yāⁿ chi ndiicúuⁿ yā chí nguɛ́ɛ́ n'deēe cá déénu yā caati 'tíícā neⁿ'e nī diiⁿ nī ti n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","N'diī Chiidá, 'āā tee nī tanducuéⁿ'ē 'úú. Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ déénu yā du'ū chi 'aama n'dyaⁿ'ā Daiya Dendyuūs, dámaaⁿ n'dii Chiidá. Mar 'aama 'iiⁿ'yāⁿ nguɛ́ɛ́ déénu yā du'ū chi n'dii Chiidá dámaāⁿ 'áámá n'dyaⁿ'ā daiyá nī, ndúúcū 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi Daiyá Dendyuūs neⁿ'é yā 'cuuⁿ'míⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tuu'mi ní Jesús ngaⁿ'a yā ngii yā discípulos yeⁿ'e yā: Dɛ'ɛ chúúcā n'dai ndís'tiī chí ngii naaⁿ nī dendu'ū chi ndís'tiī n'gíínu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","'Úú ní ngaⁿ'á ngií ndís'tiī chi neené 'yaaⁿ profetas ndúúcū reyes chi yeⁿ'ē ndii cuááⁿ vmnaaⁿ néⁿ'e yā snaaⁿ yā chí ndís'tiī ínaaⁿ nī naati nguɛ́ɛ́ n'diichí yā. Ní neⁿ'é yā 'caandiveeⁿ yā chí ndís'tiī n'giindiveéⁿ nī naati nguɛ́ɛ́ ch'iindiveéⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'Áámá maestro yeⁿ'e ley chi neⁿ'e sa n'diichineeⁿ sa Jesús ndaa sa nanáaⁿ yā ní ntiinguuneeⁿ sa Jesús: N'dií, Maestro, ¿dɛ'ɛ̄ chi canee chi diíⁿ chí ndáácāa vida cueⁿ'e daāⁿmaⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús nan'guɛɛcútaⁿ'a yā: ¿Taacā canéé nguuⁿ na ley yeⁿ'é chuū? ¿Dɛ'ɛ̄ tuumicadiinuuⁿ di yeⁿ'e ley yeⁿ'e chuū? ");
INSERT INTO cuxNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Maestro yeⁿ'e ley miiⁿ nan'guɛɛcútaⁿ'ā sa: 'Túúcā canéé nguūⁿ: Dinéⁿ'e di Señor Ndyuūs yeⁿ'ē di ndúúcū núúⁿmáⁿ staava yeⁿ'ē di, ndúúcū núúⁿmáⁿ alma yeⁿ'ē di, ndúúcū tanducuéⁿ'ē fuerzas yeⁿ'ē di, ndúúcū tanducuéⁿ'ē vaadī cadíínūuⁿ yeⁿ'ē di. Ní dinéⁿ'e di nducyaaca 'iiⁿ'yāⁿ na niiⁿnuúⁿ va'āī yeⁿ'e di tan'dúúcā chí neⁿ'e di maāⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús nan'guɛɛcútaⁿ'a yā: N'dáácā nan'guɛɛcútaⁿ'ā di. Diiⁿ di chuū, ní cunduūchi di cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Saⁿ'ā miiⁿ neⁿ'e sa cunéé n'daāca sa ní caⁿ'a sa chii sa Jesús: ¿Dú'ū chi 'iiⁿ'yāⁿ chi canéé chí neⁿ'é chi niiⁿnuúⁿ va'āī yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tuu'mi ní Jesús miiⁿ nán'guɛɛcútaⁿ'ā yeⁿ'ē sa ndúúcū 'áámá cuento chi ejemplo chi 'tíícā: 'Áámá saⁿ'ā ngua'āī sa yeⁿ'ē yáāⁿ Jerusalén miiⁿ ní cúnaⁿ'a sa na yáāⁿ Jericó. Taachi canúúⁿ sá yúúní 'iiⁿ'yāⁿ duucu ní sta'á yā saⁿ'ā miiⁿ ní divíi yā ndii catecai sa ní ch'eⁿ'e yā saⁿ'ā ndíí chi ya'āī ca yeⁿ'ē sa ní 'tɛɛ 'tɛ́ɛ́ nguɛ́ɛ́ ch'ii sa ní cunaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tuu'mi ní 'áámá chiiduú cho'ó yā yúúní miiⁿ ní taachi n'diichi yā saⁿ'ā miiⁿ, divíi yā cuááⁿ 'diituú yúúní ní cho'ó yā ní cueⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Tiicá ntúūⁿ saⁿ'ā levita chi chiiduú chi diiⁿ ntiiⁿnyuⁿ yeⁿ'e nátai cho'ó yā naachi candíítí saⁿ'ā miiⁿ. N'diichí yā saⁿ'ā miiⁿ ní divíi yā cuaaⁿ 'diituú yúúní. Ní cho'ó yā ní cueⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Cuayiivi ní 'áámá saⁿ'ā yeⁿ'e yáⁿ'āa Samaria cho'ō sa yúúní miiⁿ. Taachí ndaa niiⁿnuúⁿ sa naachi candíítí saⁿ'ā miiⁿ, n'diīchi sa saⁿ'ā nnee ya'āī 'iinu sa saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ní ndaā sa naachi candíítí saⁿ'ā miiⁿ ní idiiⁿ yiīcú sá naachi ya'āī ndúúcū aceite ndúúcū vino ní ch'ɛɛcu sa tíínūuⁿ naachí ya'āī yeⁿ'ē sa. Ní sn'duū sa saⁿ'ā 'yúudūu yeⁿ'e sa ní candɛɛ̄ sa saⁿ'ā na yáāⁿ. Ní 'nuūⁿ sa 'áámá va'ai naachí cuuvi cu'neeⁿ sa saⁿ'ā miiⁿ naachi 'iiⁿ'yāⁿ diíⁿ yā cuidado saⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chidɛɛvɛ táámá nguuvi, taachi neⁿ'e caⁿ'a sa tun'dáa sa na 'uūvī caadi yeⁿ'e bolsa ní ca'ā sa saⁿ'ā vaacu miiⁿ. Ní caⁿ'a sa chii sa saⁿ'ā: N'diī, diíⁿ nī cuidado saⁿ'ā, ti 'āā taa vɛ́ɛ́ nūuⁿ chi diíⁿ nī gastar ndúúcū sa, taachí nguɛɛcuneé nadíí'vɛ́ yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Maaⁿ ní Jesús ntiinguunéeⁿ yā saⁿ'ā miiⁿ: Naachi 'iinū saⁿ'ā s'eeⁿ ¿chɛɛ sá chi saⁿ'ā chi neⁿ'e sa saⁿ'ā na niiⁿnuúⁿ ya'āī chi 'nuū cá'ai chi duucu miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Saⁿ'ā miiⁿ ní caⁿ'ā sa: Saⁿ'ā chi nnee ya'āī 'iinu sa. Tuu'mi ní Jesús miiⁿ caⁿ'a yā: Díí, cueⁿ'e di, ní diiⁿ ntúuⁿ di 'túúcā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Cuayiivi ní cueⁿ'e Jesús na 'áámá yáāⁿ 'lííⁿ ní ndaa yā na vaacu 'áámá n'daataá chi nguuvi tá Marta. Ní 'cuūⁿ tá chi canee yā na vaacu tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ní Marta miiⁿ ní vɛ́ɛ́ 'aama ví'i yā chi nguuvi tá María. Ní María miiⁿ ch'iīndī tá ná ca'a Señor Jesús miiⁿ, ní n'giindiveeⁿ tá nduudu chí chi'cueeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta miiⁿ ní nééné n'deēe ntiiⁿnyuⁿ idiīⁿ tá ní ndaā tá nanááⁿ Jesús ní caⁿ'a tá: N'dií Señor, ¿'áá nguɛ́ɛ́ inadicádiinūūⁿ yeⁿ'é chi dámaaáⁿ n'nééⁿ vi'í 'úú chí diíⁿ mandado? Cuuvi nī táⁿ'ā ní cunnee tá 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús caⁿ'a yā: Dii, Marta, Marta, nééné n'deēe dendu'ū chi nadicádíínuuⁿ di yeⁿ'ē déndu'ū chí idi'vaachií. ");
INSERT INTO cuxNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vɛ́ɛ́ 'áámá nūuⁿ dendu'ū chi n'daacā ca. Tá María miiⁿ ndɛɛvɛ tá chí n'daācā ca. Ní chuū nguɛ́ɛ́ ndivíí 'iiⁿ'yāⁿ yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Áámá vmnéⁿ'ēe ní Jesús ngaⁿ'angua'á yā 'áámá cuaaⁿ, ní taachí ch'iinu caⁿ'angua'á yā, discípulos yeⁿ'e yā caⁿ'a yā chii yā Jesús: N'dií Señor, ca'cuéeⁿ nī nús'uu taacá chi cuuvi caaⁿ'maⁿngua'á 'nū tan'dúúcā chi Juan chi chɛɛdínuūⁿnīⁿ chi'cueeⁿ yā discípulos yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tuu'mi ní Jesús caⁿ'a yā chiī yā discípulos yeⁿ'e yā: Taachí ndís'tiī caaⁿ'maⁿngua'á nī 'túúcā caaⁿ'maⁿ nī: N'diī, chi Chiidá 'nū chi canéé na va'ai chɛɛti nguuvi. N'daācā n'dai chi 'iiⁿ'yāⁿ dich'ɛɛtɛ́ yā n'diī. Cuchiī tiempo chi ngaⁿ'a ntiiⁿnyúⁿ nī yeⁿ'e tanducuéⁿ'ē. Cúúví tan'dúúcā chi n'diī neⁿ'e nī tan'dúúcā ná va'ai chɛɛti nguuvi, 'tiicá ntuūⁿ ná yáⁿ'āa 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tée nī chi cuuvi che'é 'nū maaⁿnguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nadich'ɛɛcú nī nuuⁿndi yeⁿ'é 'nū, tan'dúúcā chi nús'ūū nadach'ɛɛcú 'nū yeⁿ'e 'iiⁿ'yāⁿ chi nguɛɛ n'daācā diíⁿ yā nduucú 'nū. Nguɛ́ɛ́ 'cuááⁿ nī chi ndaā nanaáⁿ 'nū cosas chi chɛɛchi ca chi diiⁿ chi diíⁿ 'nū nuuⁿndi naati cunneé nī nús'uu chi nguɛ́ɛ́ diíⁿ 'nū nuuⁿndi ní cuchɛɛ́ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tuu'mi ní Jesús caⁿ'a yā 'áámá ejemplo. ¿Du'ú ndís'tiī chi vɛ́ɛ́ amigo yeⁿ'e nī ní caⁿ'á nī nduu vaacu amigo ná maⁿ'a yaaaⁿ ní caaⁿ'máⁿ nī: N'dií amigo, teé nī 'iinū panes yeⁿ'e nī 'úú, ");
INSERT INTO cuxNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","caati 'áámá amigo yeⁿ'é chi canuuⁿ sa yúúní ndaā sa na vaacú ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi ca'á chi che'e sa? ");
INSERT INTO cuxNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ní 'iiⁿ'yāⁿ chi canúuⁿ yā va'ai miiⁿ nán'guɛɛcútaⁿ'a yā: Nguɛ́ɛ́ diíⁿ ndu'ú nī 'úú. 'Āā nduudí cheendi va'āī ní dá'caīyáā yeⁿ'é ní candiití yā nduucú na cama. 'Úú nguɛ́ɛ́ cuuví nducueéⁿ ní teé n'diī chiiⁿ chi neⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesús ngaⁿ'á yā: 'Úú ngaⁿ'á ngií ndís'tiī. 'Áárá chi nguɛ́ɛ́ nducueeⁿ amigo yeⁿ'ē sa chi ca'a yā pan saⁿ'ā miiⁿ cááva chi amigo yeⁿ'ē sa, naati nducueeⁿ yā ní ca'a yā amigo miiⁿ ti amigo miiⁿ nguɛ́ɛ́ 'cuinaaⁿ sa chi ngiica sa n'deee n'dáí vueltas. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ní 'úú ní ngaⁿ'á ngií ndís'tiī: Cáácá nī ní Ndyuūs ní tée yā yeⁿ'é nī, in'nuúⁿ nī ní ndaāca nī, 'yááví nī cheendi va'āī ní nan'guaaⁿ yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nducyáácá 'iiⁿ'yāⁿ chi ngiica yā Ndyuūs ní Ndyuūs ca'á yā yeⁿ'e yā. Ní nducyáácá 'iiⁿ'yāⁿ chi in'nuúⁿ yā ní ínndaaca yā. Ní nducyáácá 'iiⁿ'yāⁿ chi yaa'vi yā cheendi va'ai, ní nan'guaaⁿ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Maaⁿ ní chɛɛ́ ndís'tiī chi vɛ́ɛ́ daiya nī, ndúúti chi daiya nī caaca pan, ¿'áá ca'á nī lado yeⁿ'e pan 'áámá túūu? O ndúútí chi caaca daiyá nī 'aama 'yaācā, ¿'áá ca'a nī lado yeⁿ'e 'yaācā miiⁿ ní 'áámá cúú? ");
INSERT INTO cuxNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ndúútí chi caaca 'áámá dūtu'u, ¿'áá ca'á nī lado yeⁿ'e dūtu'u 'áámá 'iitidaⁿ'āi? ");
INSERT INTO cuxNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ndúúti chi ndís'tiī chi cúnncheeⁿ nī déénu nī ca'a nī dendu'ū chi n'dáacā daiya nī, tuu'mi ní Chiidá nī chi canéé na va'ai chɛɛti nguuvi n'deēe cá cá'a yā caati cá'a yā Espíritu N'dai yeⁿ'é Ndyuūs 'iiⁿ'yāⁿ chí caaca yā chiida yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús miiⁿ tun'daa yā yeⁿ'ē 'áámá saⁿ'ā 'lííⁿ 'áámá espíritu yeⁿ'e yááⁿn'guiinūuⁿ chi diiⁿ chi nguɛ́ɛ́ ngii ngaⁿ'ā sa. Ní taachí nan'daa espíritu yeⁿ'e yááⁿn'guiinūuⁿ saⁿ'ā 'díí'mī miiⁿ, ní caⁿ'a sa. Níícú 'iiⁿ'yāⁿ s'eeⁿ n'diichí yā chuū ní chéⁿ'é yiinú yā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Náⁿ'ā 'iiⁿ'yāⁿ ní caⁿ'a yā: Sáⁿ'a 'cūū ní nitun'dáa sa espíritu yeⁿ'e yááⁿn'guiinūuⁿ cáávā poder yeⁿ'ē Beelzebú chi Satanas chí ngaⁿ'ā ntiiⁿnyuⁿ sa yeⁿ'e espíritus yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tanáⁿ'a yā ní neⁿ'e n'diichineeⁿ yā Jesús ní ngiica yā Jesús chi diíⁿ yā 'áámá señal yeⁿ'ē na va'ai chɛɛti nguuvi chi cuuvi n'diichí yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesús déénu yā chi nacádíínuuⁿ 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Áámá gobernador chi ngaⁿ'ā ntiiⁿnyúⁿ yā yeⁿ'e yáⁿ'āa naachi vɛ́ɛ́ 'uuvī partido yā chi nguⁿ'u 'aamá yā ndúúcū táámá yā, tuu'mi ní nguɛ́ɛ́ cuuvi 'naaⁿ tiempo chi 'iiⁿntyéⁿ'ē yā. 'Tiicá ntúūⁿ naachi 'áámá familia yā ndúútí chi n'deēe nadacadíínuuⁿ yā chi vɛ́ɛ́ partido yeⁿ'e familia miiⁿ nguɛɛ cuuvi nduuvidaamá yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'Tiicá ntúūⁿ nduuti chi yááⁿn'guiinūuⁿ 'cuuⁿ'maⁿ sa ndúúcū maaⁿ sa, ¿táácā canee naachí ngaⁿ'ā ntiiⁿnyuⁿ sa? Caaⁿ'máⁿ nī 'úú: ¿Dɛ'ɛ̄ cáávā chi ngaⁿ'a ndís'tiī chi caavā yááⁿn'guiinūuⁿ chi duuchi Beelzebú chi Satanás itun'daá espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nduuti chi 'úú idivií espíritus yeⁿ'e yááⁿn'guiinūuⁿ cáávā Beelzebú, tuu'mi ní 'iiⁿ'yāⁿ ndúúcu nī ní ¿du'ū poder itun'dáa yā espíritus yeⁿ'e yááⁿn'guiinūuⁿ? Chiiⁿ chi diiⁿ 'iiⁿ'yāⁿ chi ndúúcu nī n'giⁿ'í yā chi nguɛɛ 'tíícā chi ngaⁿ'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ndúúti chi cáávā poder yeⁿ'é Ndyuūs 'úú itun'daá espíritus yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ, tuu'mi ní cuaacu nííⁿnyúⁿ chi naachi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā nndaā nanááⁿ ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Taachi saⁿ'ā dítiīnú diiⁿ cuidado sa ná vaacu sa ndúúcū íngaatu, tuu'mi ní na vaacu sa canéé seguro. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Taachí ndaa táámá saⁿ'ā chí vɛ́ɛ́ fuerzas yeⁿ'e sa ní ichɛɛ sa nduucú yā ní idivíi sa tanducuéⁿ'ē íngaatu yeⁿ'é yā chi ngii chɛɛtinúuⁿ yā yeⁿ'e va'āī miiⁿ tuu'mi ní diiⁿ sa repartir íngaatu s'eeⁿ ndúúcū compañeros yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ canée yā lado yeⁿ'é, 'iiⁿ'yāⁿ miiⁿ ní canée yā contra yeⁿ'é. 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ daama diíⁿ cosechar nduucú tuu'mi ní diíⁿ yā tan'dúúcā chi ingéē tanducuéⁿ'ē cosecha. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Caⁿ'a Jesús: Taachí espíritu yeⁿ'e yááⁿn'guiinūuⁿ nacan'daa na 'áámá saⁿ'ā, cachiica na yáⁿ'āa cuuⁿmaⁿ naachi nguɛ́ɛ́ ch'ɛɛtinee 'iiⁿ'yāⁿ ní in'nuūuⁿ naachi cuuvi ntaavi'tuunuuⁿ ní nguɛ́ɛ́ ndaācā. Tuu'mi espíritu miiⁿ nadicádíínuuⁿ ní ngaⁿ'a: Nanguɛɛcuneé na vaacú naachi chiicá. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Taachí nndaa na vaacu miiⁿ ndaācā chi saⁿ'ā miiⁿ tan'dúúcā 'áámá va'ai chi 'āā dɛ́ɛ́vɛ́ n'dai ndúúcū nducuéⁿ'e na lugar yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tuu'mi ní espíritu miiⁿ cueⁿ'e ní in'nuūⁿ tá ndɛɛ̄chɛ̄ espíritus chi cunncáā ca chí cuuví maāaⁿ. Ní ndaā espíritus ní ch'ɛɛtinée na saⁿ'ā miiⁿ. Cuayiivi ní n'geenu sa ngiī ca ní cunncáā ca canéé sá nguɛ́ɛ́ ti cuááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Taachí Jesús ngaⁿ'a yā dendú'u 'cūū 'áámá n'daataá 'caī yuudu tá nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ: Dɛ'ɛ̄ chúúcā n'dai n'daataá chi ch'iindiyáaⁿ nī ní ntaavi tá n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús ní caⁿ'a yā: N'daacā ca yeⁿ'e 'iiⁿ'yāⁿ chi n'giindiveéⁿ yā nduudu yeⁿ'é Ndyuūs, ní i'téénu yā nduudu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Taachí nduuvidaama 'iiⁿ'yāⁿ ndúúcū Jesús, Jesús tucá'a yā caⁿ'a yā nduudu miiⁿ: 'Iiⁿ'yāⁿ chi vɛ́ɛ yā ngúúví 'cūū nééné cúnncheeⁿ yā. In'nuúⁿ yā señales naati nguɛ́ɛ́ ndaācā táámá señal caati dámaāaⁿ snaaⁿ yā señal chi diiⁿ Ndyuūs ndúúcū profeta Jonás tiempo chi 'āā chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tan'dúúcā Ndyuūs diíⁿ yā señal ndúúcū profeta Jonás yeⁿ'e 'iiⁿ'yāⁿ na yáāⁿ Nínive, 'tiicá ntuūⁿ Saⁿ'ā chi Daiya Ndyuūs cuuvi cunée yā lado yeⁿ'e señal tiempo 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Taachi ndaá nguuvi yeⁿ'e juicio chi Ndyuūs caaⁿ'máⁿ yā yeⁿ'ē nuuⁿndi yeⁿ'é 'iiⁿ'yāⁿ, n'daataá reina chi tiempo chi chó'ōo ngaⁿ'a ntiiⁿnyuⁿ tá yeⁿ'ē lado yeⁿ'e sur chi caⁿ'a ta ní nducueeⁿ tá contra yeⁿ'e 'iiⁿ'yāⁿ chi snée yā maaⁿnguuvi. Ní táⁿ'ā miiⁿ ní diiⁿ tá condenar 'iiⁿ'yāⁿ chi snée yā maaⁿnguuvi caati táⁿ'ā miiⁿ yaⁿ'āī n'dai ngiica tá chi neⁿ'e tá ch'iindivee tá yeⁿ'ē vaadī deenu yeⁿ'e rey Salomón. Maaⁿ ní 'muuⁿ canéé 'áámá yā chi ch'ɛɛtɛ ca vaadī deenu yeⁿ'é yā nguɛ́ɛ́ ti rey Salomón. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","'Iiⁿ'yāⁿ chi ch'ɛɛtinéé na yáāⁿ Nínive ndii cuááⁿ vmnaaⁿ nducueeⁿ yā ní caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ chi snée yā maaⁿ caati 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Nínive ndaacadaamí yā yeⁿ'ē nuuⁿndi yeⁿ'é yā cáávā nduudu yeⁿ'e Ndyuūs chi caⁿ'a profeta Jonás miiⁿ. 'Tíícā caⁿ'á yā diíⁿ yā nguuvi chi Jesús caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ. 'Caandiveéⁿ nī. 'Múúⁿ ní vɛ́ɛ́ 'áámá saⁿ'ā chi ch'ɛɛtɛ ca sa nguɛ́ɛ́ ti profeta Jonás. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Caⁿ'a Jesús: Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cunuuⁿ n'dé'ei yā 'aama lámpara chí ngiichi ní nguɛ́ɛ́ ndúú i'nuūⁿ ra yā maaⁿ 'aama caja naati s'nuúⁿ yā na 'áámá mesa ní 'iiⁿ'yāⁿ chí cundaa yā ní snaaⁿ yā dɛɛvɛ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ndúútináaⁿ yú chiiⁿ chí tan'dúúcā 'aama lámpara yeⁿ'ē cuerpo yeⁿ'e yú. Taachí n'daí nduutináaⁿ nī 'tiicá ntúūⁿ n'daí cuerpo yeⁿ'é nī ní inaaⁿ chí dɛɛvɛ. Naati taachí nguɛɛ n'daacā nduutináaⁿ nī tan'dúúcā lámparas chi nguɛ́ɛ́ ngiichi ní 'tiicá ntúūⁿ cuerpo yeⁿ'e nī cunee ná maāiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","N'diichi nī, cundɛɛ́ nī cuidado nduutináaⁿ nī chí dɛɛvɛ yeⁿ'e cuerpo yeⁿ'é nī chí nguɛ́ɛ́ canee nī na maāiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Tiicá ntúūⁿ inaaⁿ n'dááca nī ní nguɛ́ɛ́ maāiⁿ naachi canee nī nduuti chi candɛ́ɛ nī cuidado nduutinaaⁿ nī. Ní vɛ́ɛ́ dɛɛvɛ nanáaⁿ nī tan'dúúcā 'áámá lámpara ngiichi ní naáⁿ nī chí dɛɛvɛ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Taachí Jesús miiⁿ ch'iinu cāⁿ'a yā chuū, 'áámá saⁿ'ā fariseo ndaa sá nanááⁿ Jesús ní di'cuíítu sa Jesús chí ché'e yā ndúúcū sa. Ní cueⁿ'e yā ndúúcū sa. Ní ndaa yā na vaacu sa ní chɛɛtɛ́ yā na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Taachí ndaa tiempo chi che'e yā ní saⁿ'a fariseo miiⁿ n'diichi sa chi nguɛ́ɛ́ naāⁿnū Jesús ta'á yā, (tan'dúúcā costumbre yeⁿ'e 'iiⁿ'yāⁿ Israel) tuu'mi ní cueⁿ'ē yiinu sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ní Señor Jesús caⁿ'a yā chii yā saⁿ'a fariseo: Díí ndúúcū tanáⁿ'ā saⁿ'ā fariseos inadɛ́ɛ́vɛ́ nī cuāāⁿ daami vaso ndúúcū cu'u chi tan'dúúcā cuerpo yeⁿ'e nī naati cuááⁿ chɛɛ̄tī chi tan'dúúcā staava yeⁿ'é nī ndiituú ndúúcū vaadī 'caa'va ndúúcū dendú'ū chi nguɛɛ n'daacā. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ndís'tiī chi chɛɛchi tiíⁿ nī, ¿'áá nguɛ́ɛ́ deenú nī chi Ndyuūs din'dái yā 'iiⁿ'yāⁿ ndúúcū staava yeⁿ'é yā ndúúcū cuerpo yeⁿ'e yā, ní neⁿ'é yā 'iiⁿ'yāⁿ chi nadɛɛvɛ́ cuerpo yeⁿ'é yā ndúúcū staava yeⁿ'e yā ndúúcū taanduvɛ́ɛ́ chí vɛɛ chɛɛti cuerpo yeⁿ'é yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ndís'tiī canéé chi ca'á nī limosnas yeⁿ'é nī ndúúcū nuuⁿmaⁿ staava yeⁿ'é nī caati chuū ní cosa chi n'daācā. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Dɛ'ɛ chúúcā ya'āī yeⁿ'e ndís'tiī 'iiⁿ'yāⁿ fariseos caati nadicádíínuuⁿ nī chi n'daāca nī chi diíⁿ nī chi ngaⁿ'ā ley yeⁿ'é Ndyuūs ti ca'a nī Ndyuūs décima chi ndiichi parte yeⁿ'e nducuéⁿ'ē cosecha yeⁿ'e nī chi yiivií ndúúcū 'iicudaáⁿ ndúúcū tanducuéⁿ'ē yaātā ngaiyáā. Nguɛ́ɛ́ vɛ́ɛ́ vaadī neⁿ'e yeⁿ'é Ndyuūs ndúúcu nī ndíí nguɛ́ɛ́ diíⁿ nī dendu'ū chi cuaacu. Canéé chi diíⁿ nī tanducuéⁿ'ē chi ngaⁿ'ā ley yeⁿ'é Ndyuūs ní dinéⁿ'e nī nducyaaca 'iiⁿ'yāⁿ ní ca'á nī décima dendu'ū. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Dɛ'ɛ chúúcā ya'āī yeⁿ'e ndís'tiī chí neⁿ'e nī 'cuɛɛtɛ́ nī na silla yeⁿ'e 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū sinagogas. Ní ndís'tiī neⁿ'é nī chi 'iiⁿ'yāⁿ diíⁿ yā saludar ndís'tiī taachi snée nī na yúúní. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Dɛ'ɛ chúúcā ya'āī yeⁿ'e ndís'tiī chi ngi'cueeⁿ nī ley ndúúcū 'iiⁿ'yāⁿ fariseos. Ndís'tiī ngaⁿ'a nī chi n'daacā idiíⁿ nī ní nguɛ́ɛ́ n'daacā idiíⁿ nī. Ndís'tiī ní tan'dúúcā 'áámá yáinyāⁿ chi 'iiⁿ'yāⁿ nguɛ́ɛ́ inaaⁿ yā ní nguɛ́ɛ́ déénu yā yeⁿ'ē ní chiicá yā vmnááⁿ yeⁿ'e yáinyāⁿ, 'tiicá nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tuu'mi ní nan'guɛɛcútaⁿ'a 'áámá abogado, chi maestros yeⁿ'e ley. N'diī, Maestro, taachí ngaⁿ'a nī chuū, ídiiⁿ nī chí induuvi táaⁿ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naati Jesús caⁿ'a yā: Dɛ'ɛ chúúcā ya'āī ntúūⁿ yeⁿ'e ndís'tiī, abogados, maestros yeⁿ'e ley. Ndís'tiī idiíⁿ nī n'deee cá leyes chí chɛɛchi cá ní nga'a nī tan'dúúcā chi chɛɛ̄dī chi saⁿ'ā nguɛ́ɛ́ cuuvi candɛ́ɛ sa. Ní ndís'tiī ní ndii mar 'áámá ta'a nī ní nguɛ́ɛ́ ituu'ví nī chɛ́ɛ́dí miiⁿ. Ní nguɛ́ɛ́ diíⁿ nī, ní nguɛ́ɛ́ nginnee nī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Dɛ'ɛ chúúcā ya'āī yeⁿ'e ndís'tiī chi nadin'dái nī yaīnyāⁿ yeⁿ'e saⁿ'ā profetas chi 'āā candɛ́ɛ yā nduudu yeⁿ'é Ndyuūs tiempo chi 'āā chó'ōo. Ní 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'é nī ndii cuááⁿ vmnaaⁿ ch'iiⁿ'nuⁿ yā saⁿ'ā profetas. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cuaacu nííⁿnyúⁿ chí ndís'tiī ní n'giⁿ'i nī chi yeenú nī yeⁿ'e chi 'iiⁿ'yāⁿ yeⁿ'e nī ndii cuááⁿ vmnaaⁿ ti cuaacu nííⁿnyuⁿ 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'e nī ch'iiⁿ'núⁿ yā saⁿ'ā profetas ní maaⁿ ní ndís'tiī idin'dái nī yaīnyāⁿ yeⁿ'e profetas. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ní cáávā chuū ní cáávā chi Ndyuūs deenú yā tanducuéⁿ'ē, Ndyuūs caⁿ'a yā 'tíícā: 'Úú dicho'ó profetas ndúúcū apóstoles ní náⁿ'a yā 'caaⁿ'núⁿ yā 'iiⁿ'yāⁿ ní tanáⁿ'a yā can'dáa yā 'iiⁿ'yāⁿ ní diíⁿ yā chi 'iiⁿ'yāⁿ s'eeⁿ n'geenú yā ngii. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndyuūs caⁿ'á yā diíⁿ yā castigar 'iiⁿ'yāⁿ chi maaⁿ snéé iⁿ'yeeⁿdí 'cūū ti 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'é yā ch'iīⁿ'núⁿ yā profetas ndíí tiempo taachí Ndyuūs din'dái yā íⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ní ndii tiempo taachi ch'iīⁿ'nuⁿ yā Abel ní chingéē yuuúⁿ yeⁿ'e sa, ndíí taachi ch'iīⁿ'nuⁿ yā Zacarías miiⁿ naavtaⁿ'ā yeⁿ'ē nátai ndúúcū yeⁿ'é yaacu templo. Chuū ní ngaⁿ'á ngií ndís'tiī, caati Ndyuūs caⁿ'á yā diiⁿ yā castigar 'iiⁿ'yāⁿ chi maaⁿ snee iⁿ'yeeⁿdí 'cūū cáávā yuuúⁿ yeⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Dɛ'ɛ chúúcā ya'āī yeⁿ'e ndís'tiī chi 'cuéeⁿ nī ley ní nguɛ́ɛ́ ca'cueeⁿ nī chi cadíínúúⁿ 'iiⁿ'yāⁿ vaadī deenu yeⁿ'é Ndyuūs, ní nguɛ́ɛ́ diíⁿ nī tan'dúúcā chi deenu nī chi canéé chi diíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Taachí Jesús ch'iinu caⁿ'a yā dendu'u 'cūū, tuu'mi ní maestros yeⁿ'e ley ndúúcū 'iiⁿ'yāⁿ fariseos nduuvi taáⁿ yā yeⁿ'e Jesús ní tucá'a yā itiinguunéeⁿ yā n'deee n'dáí ní caⁿ'a yā chii yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ní n'diichineeⁿ yā Jesús ndúúcū nduudu yeⁿ'e yā. Ní canéé ngiinu yā Jesús miiⁿ chi cucáávā nduudu yeⁿ'e yā ní Jesús cásta'a yā vaanicadíínūuⁿ yeⁿ'e yā ní caⁿ'a yā nduudu chi nguɛ́ɛ́ cuaacu. Ní 'íícú cuuvi caaⁿ'máⁿ yā nuuⁿndi yeⁿ'é Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tuu'mi ní neené 'yaaⁿ 'iiⁿ'yāⁿ nduuvidaama yā chi tá tīī n'deee 'iiⁿ'yāⁿ miiⁿ chingúúⁿndai yā 'aamá yā taamá yā. Tuu'mi ní Jesús miiⁿ tucá'a yā caⁿ'a yā chiī yā discípulos yeⁿ'e yā: Diíⁿ nī cuidado yeⁿ'e chi ca'cueeⁿ 'iiⁿ'yāⁿ fariseos ti tan'dúúcā levadura yeⁿ'e pan. Nguɛ́ɛ́ diiⁿ n'daaca yā yeⁿ'e chi ngi'cueeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ti nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi nin'díī naaⁿ chi nguɛ́ɛ́ cuuvi nánguaāⁿ naaⁿ. Ní nguɛ́ɛ́ 'áámá dendú'ū chi cánúuⁿ n'de'ei chi nguɛ́ɛ́ cuuvi cadíínuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Tiicá ntúūⁿ dendu'ū chí ngaⁿ'a n'de'ei ndís'tiī, tuu'mi ní 'iiⁿ'yāⁿ ní 'caandiveéⁿ yā. Ní chííⁿ chí ndís'tiī ngaⁿ'a nī ndúúcū 'iiⁿ'yāⁿ chɛɛti va'āī tuu'mi ní 'iiⁿ'yāⁿ caaⁿ'maⁿ yā cuuvi yā nducyáácá 'iiⁿ'yāⁿ ndíí na yaacū yeⁿ'e va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Caⁿ'a Jesús: Ndís'tiī chi n'dai nduucú, 'úú ngaⁿ'á ngií ndís'tiī chi nguɛ́ɛ́ 'va'á nī 'iiⁿ'yāⁿ chí 'caaⁿ'nuⁿ yā cuerpo yeⁿ'e 'iiⁿ'yāⁿ, ti 'āā ntɛ́ɛ́ cuuvi diíⁿ yā cosa chi nguɛ́ɛ́ n'daacā ca ti chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","'Úú ní cuuví ndís'tiī du'ū chi diíⁿ 'va'á nī: Ndís'tiī ní 'va'á nī Ndyuūs chi taachí 'āā n'dií 'iiⁿ'yāⁿ, Ndyuūs cuuví diíⁿ yā 'caanuúⁿ yā 'iiⁿ'yāⁿ infierno. 'Túúcā ngaⁿ'á ngií ndís'tiī 'iiⁿ'yāⁿ miiⁿ chí di'va'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿'Áá nguɛ́ɛ́ in'diicuí yā na 'uūvī 'yáádā cáávā 'uūvī taaⁿ tuūmī? Ndyuūs ní nguɛ́ɛ́ ngiinaáⁿ yā mar 'áámá 'yáádá. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Níícú ndíí nducyaaca yuūdū tiīⁿ ndís'tiī ndii dúúchɛ́ ndúúcū Ndyuūs. Cáávā chuū nguɛ́ɛ́ 'va'á ndís'tiī. ¿'Áá nguɛ́ɛ́ ya'ai ca chíí'vɛ ndís'tiī nguɛ́ɛ́ ti 'aama 'yáádá? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Caⁿ'a Jesús: 'Úú ngaⁿ'á ngií ndís'tiī chi nducyaaca 'iiⁿ'yāⁿ chi ngaⁿ'a yā chi yeⁿ'ē 'úú nguaaⁿ 'iiⁿ'yāⁿ 'tiicá ntúūⁿ 'úú Saⁿ'ā chi Daiya Ndyuūs caaⁿ'máⁿ nanááⁿ ángeles yeⁿ'é Ndyuūs chi 'iiⁿ'yāⁿ s'eeⁿ ní yeⁿ'e 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Nducyaaca 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngaⁿ'a yā chi yeⁿ'ē 'úú nguaaⁿ 'iiⁿ'yāⁿ 'tiicá ntúūⁿ 'úú Sáⁿ'ā chi Daiya Ndyuūs caaⁿ'máⁿ nanááⁿ ángeles yeⁿ'é Ndyuūs chi 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ yeⁿ'e 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nducyáácá 'iiⁿ'yāⁿ chí caⁿ'a yā nduudu taaⁿ chi nguɛ́ɛ́ n'daacā chi contra yeⁿ'e 'úú chi Sáⁿ'ā chi Daiya Dendyuūs, Ndyuūs nadach'ɛɛcú yā yeⁿ'e yā. Nducyáácá 'iiⁿ'yāⁿ chi caⁿ'á yā nduudu taaⁿ chi nguɛ́ɛ́ n'daacā chi contra yeⁿ'e Espíritu N'dai yeⁿ'é Ndyuūs, Ndyuūs nguɛ́ɛ́ nadach'ɛɛcú yā yeⁿ'e yā. Ndíí nguɛ́ɛ́ ndúú iⁿ'yeeⁿdí 'cūū, ndíí nguɛ́ɛ́ ndúú táámá iⁿ'yeeⁿdi chi cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Taachí 'iiⁿ'yāⁿ ndɛ́ɛ yā ndís'tiī na yaācū sinagogas nanááⁿ 'iiⁿntyéⁿ'ē ndúúcū jueces, nguɛ́ɛ́ nadicádíínuuⁿ nī dɛ'ɛ̄ chí nan'guɛɛcútaⁿ'a nī o dɛ'ɛ̄ chi caaⁿ'maⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Espíritu N'dai yeⁿ'e Ndyuūs cuuvi ndís'tiī hora mííⁿ nūuⁿ dɛ'ɛ̄ chi caaⁿ'maⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","'Áámá saⁿ'ā caⁿ'a sa ngii sa Jesús: N'dií, Maestro, cuuví nī 'diinú chi ntée sa vaadī n'gua'aá yeⁿ'ē chiidá 'nū cuuvi yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús miiⁿ ní caⁿ'a yā chiī yā saⁿ'ā: N'dii, sáⁿ'ā, ¿du'ú s'neēⁿ 'úú vmnaaⁿ yeⁿ'ē n'dii tan'dúúcā juez chi nca'á chi cuuvi yeⁿ'é nī yeⁿ'ē 'taa chi vɛ́ɛ́ yeⁿ'ē chiidá nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","'Úú ní ngaⁿ'á ngií nducyáácá ndís'tiī: Cuin'diichí nī ní cundɛ́ɛ nī cuidado yeⁿ'e chi neⁿ'é nī yeⁿ'e vaadī 'cuiica caati 'iiⁿ'yāⁿ nguɛ́ɛ́ ndaaca yā vida cueⁿ'e daāⁿmaⁿ cáávā chi vɛ́ɛ́ n'deee n'dáí yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chiī yā ejemplo 'cūū 'iiⁿ'yāⁿ: 'Áámá saⁿ'ā 'cuiica vɛ́ɛ́ yáⁿ'āa yeⁿ'ē sa chi neené n'deee chiīnu sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sáⁿ'ā miiⁿ ní nadicádíínuuⁿ sa ní caⁿ'ā sa: ¿Táácā diíⁿ ti nguɛ́ɛ́ cuescomate ch'ɛɛtɛ naachi nadidaamá cosecha yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ní caⁿ'a sa: 'Túúcā diíⁿ. Cúndɛɛvɛ́ cuescomate yeⁿ'é ní n̄diiⁿ taama chi ch'ɛɛtɛ́ ca ní miiⁿ nadaamá tanducuéⁿ'ē cosecha yeⁿ'é ndúúcū dendú'ū yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tuu'mi ní caaⁿ'máⁿ māaⁿ cuuví alma yeⁿ'é. Dii alma yeⁿ'é dɛ'ɛ chúúcā n'dai dii. Nééné n'deēe vɛɛ yeⁿ'ē di chi nguáín'daí chí 'nááⁿ n'dai cuchɛ́ɛ́. Maaⁿ ní ntaavi'tuunúūⁿ cuché'é, cu'u, ní cuuvi yéénú. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Naatí Ndyuūs caⁿ'a yā chii yā saⁿ'ā: Díí saⁿ'ā chi chɛɛchi tiiⁿ di. Maaⁿnguiinú 'cūū caⁿ'a di 'cuūvī di. Ní chííⁿ chí nnguáín'daī di chi vaadī 'cuiica yeⁿ'ē di, ¿du'ū cuuvi yeⁿ'ē? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ní Jesús ngaⁿ'a yā: 'Tíícā 'iiⁿ'yāⁿ chi nguain'dai yā chi vɛ́ɛ́ yeⁿ'e maáⁿ yā cáávā maaⁿ yā naati 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ vɛ́ɛ́ yeⁿ'é yā nanááⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús ngaⁿ'a yā ngii yā discípulos yeⁿ'e yā: Cáávā chuū chí ngaⁿ'á ngií ndís'tiī. Nguɛ́ɛ́ nadicádiinuuⁿ nī yeⁿ'e vida yeⁿ'e maaⁿ nī yeⁿ'ē chí nge'e nī cáávā vida yeⁿ'e nī ndii nguɛɛ ndúú cáávā catecaí nī yeⁿ'ē cuerpo yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vida ní ya'ai ca chíí'vɛ̄ nguɛ́ɛ́ ti chi nge'é nī. Ní cuerpo ní ya'ai ca chíí'vɛ̄ nguɛ́ɛ́ ti catecaí nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nadicádíínuuⁿ nī yeⁿ'e 'yaādā chí nguuvi tī cuervos. 'Yaada s'eeⁿ ní nguɛ́ɛ́ ngiīnu tī ndaata; ndíí nguɛ́ɛ́ ndúú ingii cosecha yeⁿ'é tī chi che'e tī; ndíí nguɛ́ɛ́ ndúú vɛ́ɛ́ ra vaacú tī chí nguain'dai tī; ndíí nguɛ́ɛ́ ndúú cuescomates yeⁿ'e tī. Ní Ndyuūs nga'a yā chi nge'e tī. ¿'Áá yaⁿ'ai ca chii'vɛ̄ ndís'tiī nguɛ́ɛ́ tí 'yaada s'eeⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Du'u 'áámá chɛ́ɛ́ ndís'tiī cuuví cundɛɛ́ nī cuidado ní n'deee n'dáí nacadiinúúⁿ nī ní ntiinee nī maⁿ'a metro yeⁿ'ē chí yaacu nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndúúti chi nguɛɛ cuuvi diíⁿ nī chuū chi 'lííⁿ ¿dɛ'ɛ̄ cúúví chi indɛɛ́ nī cuidado ní n'deee n'dáí nadicadíínuuⁿ nī yeⁿ'e dendu'ū chi n'gɛɛtɛ cá? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Cuin'diichí nī naāndā táácā n'giita. Nguɛ́ɛ́ din'dái tíínūuⁿ, ndíí nguɛ́ɛ́ ndúú idin'dáí hilo. 'Úú ngaⁿ'á ngií n'dís'tiī ti rey Salomón canúuⁿ yā catecái yā chi n'dɛɛvɛɛ́ n'dai yeⁿ'e rey nguɛ́ɛ́ neené n'dɛɛvɛɛ́ tan'dúúcā 'áámá naāndā s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nduuti chi Ndyuūs nga'a yā catecai n'daacā naāndā chi maaⁿ ní snéé cuɛɛti ní cavyaaⁿ ní nti'ī ní 'iiⁿ'yāⁿ 'neeⁿ yáⁿ'a yā, n'deēe cá Ndyuūs tée yā ndís'tiī ti Ndyuūs diíⁿ yā cuidado yeⁿ'e ndís'tiī chi dúu'vīi i'téénu nī Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndís'tiī ní nguɛ́ɛ́ in'nuúⁿ nī chi che'e nī o cu'ú nī. Nguɛ́ɛ́ nadicádíínuuⁿ nī yeⁿ'ē ní 'cuɛɛtinéé 'diiíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ti 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e ndaata Israel o judíos in'nuúⁿ yā tanducuéⁿ'ē dendu'ú 'cūū. Naati ndís'tiī ni vɛ́ɛ́ 'aama Chiidá nī chi 'āā déénu yā yeⁿ'e tanducuéⁿ'ē dendu'ū chi necesidades yeⁿ'e ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Vmnááⁿ vmnaaⁿ ndís'tiī ní cánéé chí in'nuúⁿ nī Ndyuūs ní yeⁿ'e nducuéⁿ'ē yeⁿ'e chi Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā, ní 'íícú Ndyuūs tée yā ndís'tiī tánducueⁿ'ē déndu'ū. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Caⁿ'a Jesús: Ndís'tiī chi tan'dúúcā 'iiti cuūchī yeⁿ'é 'tiicá nī. Nguɛ́ɛ́ 'va'á nī ti Ndyuūs Chiida yú neⁿ'é yā tée yā ndís'tiī dendu'ū yeⁿ'e naachí ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Cuin'díícui nī chi vɛ́ɛ́ yeⁿ'e nī ní ca'á nī 'iiⁿ'yāⁿ chi nguɛ́ɛ́ vɛ́ɛ́ yeⁿ'e yā. Diiⁿ n'daacá nī caati cuuvi yeⁿ'é nī vaadī 'cuiica yeⁿ'ē va'ai chɛɛti nguuvi naachi 'iiⁿ'yāⁿ duucu nguɛ́ɛ́ cuuvi cundaa yā, ndii nguɛɛ nduu í'yɛ́ɛvɛ̄ cuuvi di'tuuví tī. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Caati naachi canéé vaadī 'cuiica yeⁿ'é nī, miiⁿ canee staava yeⁿ'é nī chí nadicadiinúúⁿ nī yeⁿ'e nducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","'Cuɛɛtinee chiichi n'daācā ndúúcū catecai nī. Cuɛɛchiichí nī paño chɛɛ̄ti nī 'íícú candɛɛ nī lámparas yeⁿ'e nī chí ngiichi. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'Cuɛɛtinéé ndís'tiī tan'dúúcā 'áámá saⁿ'ā chí snéé ngiinu sa chí ndaa patrón yeⁿ'ē sa naachi n'giindivaacú 'iiⁿ'yāⁿ. Ní maaⁿ nda'ai sa cheendi va'āī ní taachi ndaá yā chi di'cuɛɛcú yā tuu'mí nūuⁿ nn'guaāⁿ sa yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dɛ'ɛ̄ chúúcā n'dai mozos chi diiⁿ mandado ní taachi ndaa Señor miiⁿ ní ndaaca yā mozos chí snduuchí yā. Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi Señor miiⁿ ní cuɛɛchiichí n'daacá yā paño chɛɛ̄ti yā. Ní Señor miiⁿ ní diíⁿ yā chi mozos 'cuɛɛtɛ sa na mesa. Tuu'mi ní Señor miiⁿ 'cuíi yā cu'u che'e mozos. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Áárá chi Señor miiⁿ ndaa yā maⁿ'a yaaaⁿ o taachi 'āā cuɛ́ɛ́ chidɛɛvɛ nguuvi ní ndaacá yā mozos chí snduuchi sa. Dɛ'ɛ chúúcā n'dai mozos ti snduuchí yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ndís'tiī ní cadíínuuⁿ nī chuū. Ndúúti chi 'iiⁿ'yāⁿ vaacu déénu yā dɛ'ɛ̄ hora chí ndaa chí duucu, cuaacu nííⁿnyúⁿ 'cuɛɛtí nduuchí yā ní nguɛ́ɛ́ 'cuaaⁿ yā chí duucu na vaacú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Tiicá ntúūⁿ ndís'tiī 'cuɛɛtinéé yaáⁿ nī ti hora chi nguɛ́ɛ́ inacádiinuuⁿ nī 'úú chi Saⁿ'ā chi Daiyá Dendyuūs ní ndaá taama vmnéⁿ'ēe. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tuu'mi ní Pedro miiⁿ ní caⁿ'a yā chii yā Jesús: N'dií, Señor, ¿'áá caⁿ'a nī ejemplo 'cūū caavā nús'uu o caavā nducyaaca 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús miiⁿ ní caⁿ'a yā: ¿Du'ú dueño ca'a yā ntiiⁿnyuⁿ chi s'neeⁿ yā vmnaaⁿ yeⁿ'ē va'ai yeⁿ'e yā 'áámá mayordomo nduuti chi nguɛɛ ca'a sa chi che'e mozos yeⁿ'é yā hora chi che'e sa? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dɛ'ɛ chúúcā n'dai mayordomo chi diiⁿ sa ntiiⁿnyuⁿ taachí dueño miiⁿ ní ndaa yā ní nandaaca yā mayordomo chi diiⁿ sa tan'dúúcā chi neⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi dueño miiⁿ ní cu'néeⁿ yā mayordomo miiⁿ chi caaⁿ'maⁿ ntiiⁿnyuⁿ sa yeⁿ'ē tanduvɛ́ɛ́ chi vɛɛ yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ndúúti chi mayordomo miiⁿ nadicádiinuuⁿ sa na staava yeⁿ'e sa chí dueño cuuvi 'náaⁿ yā nndaa yā tuu'mi ní tuca'a sa 'cueⁿ'e sa mozo ndúúcū n'daataá chi snéé caadi 'iiyū ní nge'e sa ní ngi'i sa ndúúcū amigos yeⁿ'e sa ní cuu'vi sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tuu'mi ní dueño miiⁿ ní ndáa yā nguuvi chi mayordomo nguɛ́ɛ́ cānee ngíínu sa ní 'áámá hora chi nguɛ́ɛ́ déénu sa. Ní dueño miiⁿ ca'á yā castigo ch'ɛɛtɛ ca mayordomo miiⁿ tan'dúúcā chi Ndyuūs ca'a yā castigo 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu yā 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mayordomo chi deenu sa chí neⁿ'e dueño yeⁿ'e sa naati nguɛ́ɛ́ vɛ́ɛ́ yaaⁿ sa ndíí nguɛ́ɛ́ ndúú diiⁿ sa chi ngaⁿ'a dueño yeⁿ'e sa cuuvi sa castigado ndúúcū neené n'deee cuūví 'cueⁿ'é yā saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Naati mayordomo chi nguɛ́ɛ́ déénu sa taacā neⁿ'e dueño yeⁿ'e sa chi diiⁿ sa, ní diiⁿ sa chi nguɛ́ɛ́ n'daacā chi cuuví sa castigado, tuu'mi ní cuuvi sa castigado ndúúcū 'tɛ́ɛ́ nūuⁿ cuūví cueⁿ'é yā saⁿ'ā. 'Āā du'ú nūuⁿ saⁿ'ā chí n'deeé nga'a dueño yeⁿ'e sa, dueño miiⁿ ní n'deēe cá caaca yā cuenta yeⁿ'ē chi diiⁿ sa. 'Iiⁿ'yāⁿ chi nga'a n'deēe cá táámá yā, 'iiⁿ'yāⁿ miiⁿ n'deēe cá caaca yā cuenta yeⁿ'e chi diiⁿ taamá yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","'Úú Jesús ní ndāa chi cu'neéⁿ yaⁿ'ā ná iⁿ'yeeⁿdí 'cūū. Dɛ'ɛ̄ ca neⁿ'é diíⁿ nduuti chí 'āā ngiichi. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Canéé chí 'úú 'cueenú cuuvi n'deee n'dáí ní neⁿ'é chi 'cueenú cuuvi ndíí taachi 'āā cuuví cuaacu tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿'Áá nadicadíínuuⁿ nī chi 'úú ndaá chi ndɛɛ́ vaadī 'diīíⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū? 'Úú ní ngaⁿ'á ngií ndís'tiī chi nguɛ́ɛ́ cuaacu caati ndɛɛ́ vaadī 'caa'va, ní 'iiⁿ'yāⁿ 'caa'vá yā ndúúcū táámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ndíí tiempo miiⁿ ndíí tiempo chi cuchiī, nduuti chi nyuⁿ'u 'iiⁿ'yāⁿ na 'áámá va'āī ndúúcū vaadī 'caa'va 'cuɛɛtinée yā, 'iinu yā ní caⁿ'a yā contra yeⁿ'ē na 'uuvi yā ní 'uuvi yā ní caⁿ'a yā contra yeⁿ'ē ná 'iinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Saⁿ'ā chi vɛ́ɛ́ daiya sa ní 'caa'va sa ndúúcū daiya sa, 'íícú daiya sa ní 'caa'vá sa ndúúcū chiidá sa. Ní 'áámá n'daataá nguɛ́ɛ́ cuuvi n'diichi tá daiya tá, 'íícú daiya ntúūⁿ tá nguɛ́ɛ́ cuuvi n'diichi tá chɛɛcu tá. Ní taⁿ'ā indá'ā tá ní 'caa'vá yā ndúúcū dicuūnú ta, ní dicuūnú ta ní 'caa'vá yā ndúúcū táⁿ'ā indá'a tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","'Tiicá ntúūⁿ ngaⁿ'a Jesús ngii yā 'iiⁿ'yāⁿ: Taachí ndís'tiī inaaⁿ nī méēeⁿ chi íneeⁿ naachí ngiiya 'yáⁿ'ā, tuu'mi ní ngaⁿ'a nī chi 'cueeⁿ cúúvī. Ní 'tíícā ngii. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ní taachí ngéenū 'yúúné cuááⁿ ndiiyā ngaⁿ'a nī chi cuuvi yáāaⁿ 'iicu ní ngii. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ndís'tiī chí 'uūvī naaⁿ 'uūvī cheendi nī déénu nī taaca canéé nánguuvi ndúúcū na yaⁿ'á, taachi ndaā 'íí'nūuⁿ ni taachi cuuvi 'cueeⁿ cuuvi. ¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ déénu nī yeⁿ'e señales chí inaaⁿ nī yeⁿ'e tiempo 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tuu'mi ní caⁿ'a Jesús: ¿Dɛ́'ɛ̄ cúúví chí nguɛ́ɛ́ indɛ́ɛ̄ ndís'tiī cuidado chɛɛ chi n'daācā chi diíⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Taachi caⁿ'á nī ndúúcú sáⁿ'ā chi táāⁿ ndúúcu nī nanááⁿ juez, n'diichí nī chi indee nī ndúúcū vi'ī cuaaⁿ cyúúní ní diíⁿ nī chi 'cuɛɛtinéé n'dááca nī ndúúcū vi'ī ni 'iicu nguɛ́ɛ́ caⁿ'a nī nanááⁿ juez. Ní juez miiⁿ nca'á yā ndís'tiī ta'ā policía, ní policía miiⁿ ní cu'nuūⁿ sá ndís'tiī vácūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Úú ngaⁿ'á ngīi ndís'tiī ti nguɛ́ɛ́ nan'dáa nī vácūū neⁿ'e chí nguɛ́ɛ́ 'cuiinu nadíí'vɛ̄ tanducuéⁿ'ē chi ndiicuí nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ndáa n'duuvi saⁿ'ā nanááⁿ Jesús ní caⁿ'a sa chii sa Jesús tan'dúúcā chi diiⁿ gobernador Pilato. Ca'a yā orden chí ch'iīⁿ'nuⁿ sa n'dúúví 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Galilea ní staⁿ'a yā yuuúⁿ yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ndúúcū yuuúⁿ yeⁿ'ē 'iiti chi 'āā 'nííⁿ'núⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ chi ca'a yā ofrenda yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá nadicádíínuuⁿ ndís'tiī chi 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'e yáⁿ'āa Galilea ch'eenu yā 'tíícā ti vɛ́ɛ́ ca nuuⁿndi yeⁿ'e yā nguɛ́ɛ́ ti tanáⁿ'ā 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Galilea? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Úú ngaⁿ'á ngií ndís'tiī: Nguɛ́ɛ́ 'tíícā. Ndúúti chi ndís'tiī nguɛ́ɛ́ ndaacadaamí nī yeⁿ'ē nuuⁿndi yeⁿ'e nī, tuu'mi ní nducyaaca ndís'tiī 'cuūvi ntúuⁿ nī cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Dɛ'ɛ̄ nadicádíínuuⁿ ndís'tiī yeⁿ'é ndu'ū ndítiiⁿ'yu 'iinu 'iiⁿ'yāⁿ chi ndíí cuaaⁿ vmnaaⁿ sndaā nduūu torre na yáāⁿ Siloé vmnááⁿ yā ní nducyáácá yā ch'iī yā? ¿'Áá nadicádíínuuⁿ ndís'tiī chi 'iiⁿ'yāⁿ s'eeⁿ vɛ́ɛ́ ca nuūⁿndī yeⁿ'e yā nguɛ́ɛ́ ti tanáⁿ'a yā chi snée yā na yáāⁿ Jerusalén? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Úú ní ngaⁿ'á ngií ndís'tiī chi nguɛ́ɛ́ 'tíícā. Nduuti chi ndís'tiī ntúūⁿ nguɛ́ɛ́ ndaacadaamí nī yeⁿ'e nuuⁿndi yeⁿ'é nī, tuu'mi ní nducyaaca ndís'tiī 'cuūvi nī cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tuu'mi ní Jesús caⁿ'a yā ejemplo 'cūū: 'Áámá saⁿ'ā ní catá'āī 'áámá yáⁿ'á yeⁿ'ē n'guíídīi yaaⁿ nguuvi yeⁿ'e sa naachi vɛ́ɛ́ yáⁿ'āa chɛɛti chéēⁿ yeⁿ'ē sa. Chó'ōo tiempo ní cheⁿ'e sa in'nuuⁿ sa n'gui'i yeⁿ'e yáⁿ'á yeⁿ'e sa ní nguɛ́ɛ́ ndaācā sa n'gui'i yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tuu'mi ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ chi diíⁿ yā ntiiⁿnyuⁿ yeⁿ'e yáⁿ'āa yeⁿ'e sa: 'Āā 'iinu nduūyū chí ichīi ní nguɛ́ɛ́ indaāca n'gui'ī na yáⁿ'á 'cūū. 'Caaca nī yáⁿ'á. ¿Dɛ'ɛ cuuvi chi yáⁿ'á di'vaachi na yáⁿ'āa naachi snéé yáⁿ'á 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naati saⁿ'ā chi idiiⁿ ntiiⁿnyuⁿ na yaⁿ'ā miiⁿ nán'guɛɛcútaⁿ'ā sa: N'dií, señor, 'āā canéé rá nduuyú 'cūū ní 'úú nadidɛɛvɛ́ yáⁿ'á yeⁿ'ē ní ca'á taavi abono yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ní nduuti chi 'cuūndī n'gui'i yeⁿ'ē ní n'daacā. Nduuti chi nguɛ́ɛ́, ní 'caaca nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nguuvi sábado chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ, Jesús ngi'cueeⁿ yā na 'áámá yaācū sinagoga. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Miiⁿ ní canéé 'áámá n'daataá chí 'āā ndítiiⁿ'yu 'iinu ndúuyū chí ndii n'guuti ta cáávā chi diiⁿ espíritu yeⁿ'e yááⁿn'guiinūuⁿ 'tíícā ndúúcū ta. Ndíí mar 'áámá naaⁿ nguɛ́ɛ́ ngií ndaa cuaacú ta. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Taachí Jesús n'diichí yā n'daata miiⁿ yaa'ví yā táⁿ'ā ní caⁿ'a yā chiī yā táⁿ'ā: N'dií, n'daataá, ¿'áá neⁿ'e nī chi nduuvi cuaacú nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús sn'duú yā ta'a yā vmnaaⁿ yeⁿ'e n'daātā miiⁿ. Tuu'mí nūuⁿ ndaā cuaacu n'daataá mííⁿ ní n'daataá mííⁿ ní ngaⁿ'a yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Iiⁿ'yāⁿ chí ngaⁿ'ā ntiiⁿnyúⁿ yā yeⁿ'ē yaacu sinagoga nduuvi taáⁿ yā ti Jesús miiⁿ ní diyiicú yā n'daataá mííⁿ nguuvi chi 'iiⁿ'yāⁿ ntaavi'tuunúúⁿ yā. Ní ngaⁿ'a yā ngii yā nducyaaca 'iiⁿ'yāⁿ: Jaāⁿ nguuví nūuⁿ canee chi diiⁿ 'iiⁿ'yāⁿ ntiiⁿnyuⁿ ní nguuvi s'eeⁿ 'iiⁿ'yāⁿ cuuvi chií yā nanááⁿ Jesús miiⁿ ní cuuvi diiⁿ yiicú yā 'iiⁿ'yāⁿ s'eeⁿ, naati nguɛ́ɛ́ cuuvi diíⁿ yā 'tíícā nguuvi chi ntaavi'túúnūuⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tuu'mi ní Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'ē sa: Ndís'tiī saⁿ'ā 'uūvī naaⁿ 'uūvī cheendí nī, ¿'áá nguɛ́ɛ́ in'daatíī ndís'tiī 'iiti yeⁿ'e nī naachi snéé 'ii'yu tī ní ngeⁿ'é nī nga'a nī nuūⁿnīⁿ 'iiti nguuvi chi ntaavi'tuunúuⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","N'daataa 'cūū ní yeⁿ'ē ndaata yeⁿ'e Abraham. 'Āā ndítiiⁿ'yu 'iinu nduūyū ncachiichí yááⁿn'guiinūuⁿ táⁿ'ā. ¿'Áá nguɛ́ɛ́ canee chi n'daatií táⁿ'ā miiⁿ yeⁿ'e ca'ai nguuvi chi ntaaví'tuunúúⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Taachí Jesús miiⁿ caⁿ'a yā chuū, taanduvɛ́ɛ yā chi taaⁿ yā yeⁿ'e yā ní 'cuináaⁿ yā. Nducyáácá 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿya yeenú n'dai yā yeⁿ'é tanducuéⁿ'ē dendu'ū chí n'gɛɛtɛ chí diiⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús caⁿ'a yā: ¿Dɛ'ɛ̄ tan'dúúcā naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā? ¿Dɛ'ɛ̄ nadídaamá nduūcū? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tan'dúúcā nduutií yeⁿ'ē yiīvɛ̄ ntíí'yaá chi 'áámá saⁿ'ā ní sta'ā sa ní chiīnū sa na yáⁿ'āa yeⁿ'ē sa. Yaāta miiⁿ ní ch'iīta tan'dúúcā 'áámá yáⁿ'á ch'ɛɛtɛ. 'Yáádá yeⁿ'ē nanguuvi din'dái tī 'dɛɛcɛ́ tī na dúuⁿnɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús ní caⁿ'a ntúūⁿ yā: ¿Dɛ'ɛ̄ tan'dúúcā naachí Ndyuūs ngaⁿ'ā ntiiⁿnyúⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tan'dúúcā 'aama tááⁿ levadura yeⁿ'e pan chi 'áámá n'daataá chistaⁿ'ā tá nguaaⁿ 'iinū medidas harina ndíí chí nan'guiita tanducuéⁿ'ē yaāchī yéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Taachi Jesús canúúⁿ yā yúúní chi cho'ó yā na yáāⁿ Jerusalén cueⁿ'é yā tanáⁿ'ā yáāⁿ n'gɛɛtɛ ndúúcū yáāⁿ n'gaiyáā ní ngi'cueeⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tuu'mi ní 'áámá saⁿ'ā ndaā sa nanáaⁿ yā ní ntiinguuneeⁿ sa: N'dií, Señor, ¿'áá duū'ví 'iiⁿ'yāⁿ chí nnguaⁿ'ai yā? Jesús miiⁿ ní caⁿ'a yā chii yā saⁿ'ā miiⁿ: ");
INSERT INTO cuxNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Diíⁿ nī tanducuéⁿ'ē chi cuuví nī chi cundaá nī cheendi va'āī 'tuucuú caati ngaⁿ'á ngií ndís'tiī chi nééné 'yaaⁿ 'iiⁿ'yāⁿ neⁿ'e yā cundaá yā cheendi va'ai 'tuucuú chi candɛ́ɛ̄ naachi Ndyuūs nadanguaⁿ'ai yā 'iiⁿ'yāⁿ naati nguɛ́ɛ́ cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Taachi 'iiⁿ'yāⁿ yeⁿ'e va'ai nducueeⁿ yā ní n'gaadí yā cheendi va'āī yeⁿ'ē ndís'tiī, tuu'mi ní ndís'tiī snee nī cuaaⁿ chuva'āī. Ní di'cuɛɛcú nī cheendi va'āī ní caaⁿ'máⁿ nī: Señor, Señor, nn'guaáⁿ nī yeⁿ'e 'nū. 'Iiⁿ'yāⁿ yeⁿ'e va'ai ní nan'guɛɛcutaⁿ'a yā: Nguɛ́ɛ́ in'diichí ndís'tiī ndii nguɛɛ deenú tiī ndiicá nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'Áárá chí ndís'tiī ni tucá'a nī caaⁿ'maⁿ nī 'tíícā: Che'é 'nū ní chi'i 'nū ndúúcu nī taachi n'diī ní chi'cueeⁿ nī 'iiⁿ'yāⁿ na yúúní yeⁿ'e yáāⁿ vaacú 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'Iiⁿ'yāⁿ yeⁿ'e va'ai miiⁿ ní caaⁿ'maⁿ yā cuuvi yā 'iiⁿ'yāⁿ s'eeⁿ: 'Úú ngaⁿ'á ngií ndís'tiī ti nguɛ́ɛ́ in'diichí ndís'tiī ndíí nguɛ́ɛ́ deenú tií ndiica nī. Cueevii nī yeⁿ'é nducyaaca ndís'tiī ti nguɛ́ɛ́ n'daācā idiíⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Cuaacu chi ndís'tiī snaaⁿ nī chiida yú s'eeⁿ Abraham, ndúúcū Isaac, ndúúcū Jacob, ndúúcū nducyaaca profetas chi ndii cuááⁿ vmnaaⁿ snée yā naachí Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ. Ní ndís'tiī ní 'cuɛɛtinée nī cuááⁿ chuva'āī. Miiⁿ ní cuɛɛcú nī ní che'é nī 'diiⁿ'yúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","'Iiⁿ'yāⁿ s'eeⁿ chii yā yeⁿ'e nducuéⁿ'ē cuaaⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū ní ndaa yā nanááⁿ Ndyuūs. Chii yā ndíí cuaaⁿ na ican'dáā 'yáⁿ'ā, ndii cuaaⁿ na ngiiya 'yáⁿ'ā, ndíí cuaaⁿ 'nííⁿnúⁿ, ndíí cuaaⁿ ndiiya, ní 'cuɛɛtɛ́ yā na mesa yeⁿ'e banquete naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tuu'mi ní náⁿ'ā 'iiⁿ'yāⁿ chi n'gɛɛtɛ chi ngaⁿ'a ntiiⁿnyúⁿ yā maaⁿ na iⁿ'yeeⁿdí 'cūū ní cuuvi ndiicuuⁿ cá yā naachi snéé Ndyuūs ní naⁿ'a 'iiⁿ'yāⁿ chi ndiicuuⁿ cá maaⁿ na iⁿ'yeeⁿdí 'cūū ní cuuvi n'gɛɛtɛ́ yā naachi snéé Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nguuví 'cuú nūuⁿ 'áámá chɛ́ɛ́ 'iiⁿ'yāⁿ fariseos ndáa yā nanááⁿ Jesús ní caⁿ'a yā: N'diī, Jesús, cueⁿ'e nī ti rey Herodes neⁿ'é yā 'caaⁿ'núⁿ yā n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naati Jesús caⁿ'a yā chiī yā 'iiⁿ'yāⁿ s'eeⁿ: Cunaⁿ'á nī nanááⁿ rey miiⁿ ní caaⁿ'maⁿ nī cuuvi nī: N'diī rey, tan'dúúcā 'yuūnéē, 'tiicá nī. Cuin'diichí nī, Jesús miiⁿ ngaⁿ'á yā 'túúcā: 'Úú itun'daá espíritu yeⁿ'e yááⁿn'guiinūuⁿ yeⁿ'é 'iiⁿ'yāⁿ ní diíⁿ chi nduūvā yeⁿ'e 'iiⁿ'yāⁿ maaⁿnguuvi ndúúcū cavyaaⁿ, tuu'mi ní 'cuiinu ntiiⁿnyuⁿ yeⁿ'é damáíⁿ. 'Tíícā canee chi diíⁿ ná 'iīnū nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Naati 'úú ní canéé chi caacá cuaaⁿ cyúúní ní diíⁿ ntiiⁿnyuⁿ yeⁿ'é maaⁿ ndúúcū cavyaaⁿ ndúúcū damáíⁿ, caati nguɛ́ɛ́ canéé chí 'cuuvī 'áámá saⁿ'ā profeta ch'ɛɛtɛ chi diiⁿ ntiiⁿnyuⁿ yeⁿ'é Ndyuūs 'áámá lado yeⁿ'e yáāⁿ Jerusalén ti na yáāⁿ Jerusalén chi 'caaⁿ'núⁿ yā saⁿ'ā profetas. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén: Ndís'tiī chi 'muuⁿ n'giiⁿ'nuⁿ nī 'iiⁿ'yāⁿ profetas ní ngíítuú nī 'iiⁿ'yāⁿ chi Ndyuūs dicho'ó yā chi ndɛɛ yā nduudu yeⁿ'é yā. Ní Jesús caⁿ'a yā: Neené n'deēe cuūví neⁿ'é nadaamá daiyá 'iiⁿ'yāⁿ yáāⁿ Jerusalén miiⁿ tan'dúúcā 'áámá tú'u nadaamá tī daiya tī mááⁿ ngɛɛ̄chi tī, ní nguɛ́ɛ́ 'cuúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","'Túúcā caⁿ'a yā: N'diichí ndís'tiī. Vaacú nī cu'nééⁿ maāaⁿ. Ní ngaⁿ'á ngií ndís'tiī chi 'āā ntɛ́ɛ́ snaaⁿ nī 'úú ndíí ndáá tiempo chi caaⁿ'maⁿ nī yeⁿ'é: Dɛ'ɛ chúúcā n'dai 'iiⁿ'yāⁿ chí cuchii yā ndúúcū chi duuchi Señor 'iivú Ndyuūs ti 'iiⁿ'yāⁿ yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","'Áámá sábado, nguuvi chi ntaavi'túúnuuⁿ 'iiⁿ'yāⁿ, Jesús sndaa yā ní cheⁿ'e yā 'áámá va'ai yeⁿ'e 'áámá saⁿ'ā fariseo chi ngaⁿ'a ntiiⁿnyuⁿ sa. Ní tanáⁿ'ā saⁿ'ā fariseos canee ngiinu sa Jesús dɛ'ɛ̄ chi caⁿ'á yā chi diiⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tuu'mi ní ndaā nanááⁿ Jesús 'áámá saⁿ'ā chí ngiītā ní ndiituú núúⁿmáⁿ ch'ɛɛtɛ sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús caⁿ'a yā chii yā maestros yeⁿ'e ley ndúúcū saⁿ'ā fariseos: ¿'Áá 'cuaaⁿ ley miiⁿ chí cuuví diíⁿ chi nduūvā yeⁿ'e 'iiⁿ'yāⁿ nguuvi chí ntaavi'tuunúúⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Saⁿ'ā s'eeⁿ ní 'diiiⁿ 'diiíⁿ ch'ɛɛtinee sa ní nguɛ́ɛ́ nan'guɛɛcutaⁿ'a sa. Tuu'mi ní Jesús sta'á yā ta'a saⁿ'ā chi ndiituú ní diíⁿ yā chi nduūvā yeⁿ'e saⁿ'ā miiⁿ. Ni yaa'vi yā saⁿ'ā chi cunaⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cuayiivi ní Jesús yaa'vi yā saⁿ'ā s'eeⁿ ní caⁿ'a yā: ¿Chɛɛ̄ ndís'tiī ndúúti chi 'áámá burro o 'áámá itiindu yeⁿ'e nī cun'dáá nuúⁿ tī na 'áámá viini ní nguɛ́ɛ́ tuu'mí nūuⁿ ntun'dáa nī 'iiti 'áárá chí nguuvi chi ntaavi'tuunuúⁿ 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Saⁿ'ā s'eeⁿ nguɛ́ɛ́ chiī nan'guɛɛcútaⁿ'a sa cucáávā nduudu chi ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Taachí Jesús n'diichí yā táácā diiⁿ 'iiⁿ'yāⁿ chi invitados chi ndɛɛvɛ yā silla yeⁿ'e mesa chi lugar chí n'daacā ca, tuu'mi ní caⁿ'a yā 'áámá ejemplo chi 'tɛɛ nguɛɛ dááma ndúúcū 'iiⁿ'yāⁿ chi diiⁿ yā invitados. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Ngaⁿ'a yā 'tíícā. Taachi 'áámá 'iiⁿ'yāⁿ diíⁿ yā invitar dii naachí n'giindivaacu 'iiⁿ'yāⁿ nguɛ́ɛ́ 'cuūndī di na silla vmnááⁿ vmnaaⁿ caati cuuvi ndaa táámá 'iiⁿ'yāⁿ invitado chi ch'ɛɛtɛ́ yā nguɛ́ɛ́ ti dii. Ní silla miiⁿ ní caava 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ní taachí ndaa 'iiⁿ'yāⁿ chi ch'ɛɛtɛ ca yā, tuu'mi ní 'iiⁿ'yāⁿ chi diíⁿ yā invitar di ndaa yā nanáaⁿ di ní caaⁿ'máⁿ yā cuuvi yā dii: Cu'neeⁿ di lugar 'cūū yeⁿ'e 'iiⁿ'yáⁿ 'cūū. Tuu'mi ní cuuví 'cuináaⁿ di ní 'cuūndī di na silla n'díí naaⁿ n'giinu. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Taachí 'iiⁿ'yāⁿ diíⁿ yā invitar dii caⁿ'a di 'cuūndī di na silla ndíí naaⁿ n'giinu. Ní taachi ndaá nanááⁿ dii 'iiⁿ'yāⁿ chi diíⁿ yā invitar dii, tuu'mi ní caaⁿ'máⁿ yā cuuvi yā dii: Díí sáⁿ'ā chi n'dai nduucú, caaca dí cuaaⁿ 'niiⁿnuⁿ. Ní 'āā n'daacā cuuvi yeⁿ'ē di nanááⁿ 'iiⁿ'yāⁿ chi vɛɛtɛ́ yā na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","'Iiⁿ'yāⁿ chi dich'ɛɛtɛ́ maáⁿ yā táámá 'iiⁿ'yāⁿ ní diíⁿ yā chi ndiicuuⁿ yā. Ní 'iiⁿ'yāⁿ chi maaⁿ yā diiⁿ chi ndiicuuⁿ yā tááma 'iiⁿ'yāⁿ ní diíⁿ yā chi ch'ɛɛtɛ́ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tuu'mi ní Jesús ngaⁿ'á yā ngii yā saⁿ'ā chi diīⁿ invitar 'iiⁿ'yāⁿ s'eeⁿ: Dii taachí in'nuuⁿ di chí che'e nguaiⁿ di o chi che'e nguíinū di, nguɛ́ɛ́ 'cuai di 'iiⁿ'yāⁿ chi n'dai ndúúcu di, ndíí nguɛ́ɛ́ ndúú ví'i rā di, ndíí nguɛ́ɛ́ ndúú 'iiⁿ'yāⁿ yeⁿ'ē di, ndíí nguɛ́ɛ́ ndúú 'iiⁿ'yāⁿ na niiⁿnuúⁿ va'āī yeⁿ'ē di chi 'cuííca yā caati 'iiⁿ'yāⁿ s'uuⁿ ní diíⁿ ntúuⁿ yā invitar dii chi che'e di nduucú yā. 'Tíícā ní nadíí'vɛ yā diiⁿ cáávā chi ca'a di chi che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naatí taachi idin'dái di 'aama comida n'dai, 'cuai dí 'iiⁿ'yāⁿ chi ndaachí snee yā, ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii ngiicá yā, ndúúcū chi ngaī yó'o, ndúúcū 'iiⁿ'yāⁿ chi ngueenáaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ní caaⁿ'maⁿ 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'ē di: Dɛ'ɛ chúúcā n'dai di. Ti 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ nteé yā dii. Naati Ndyuūs nadíí'vɛ yā dii taachí ndaa nguuvi chi 'iiⁿ'yāⁿ chi n'dai nduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Taachi 'áámá 'iiⁿ'yāⁿ chi vɛ́ɛ yā na mesa miiⁿ ch'iindiveéⁿ yā chuū, caⁿ'a yā chii yā Jesús: Dɛ'ɛ chúúcā n'dai chi caⁿ'á yā che'e yā pan naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tuu'mi ní Jesús caⁿ'a yā ejemplo 'cūū: 'Áámá saⁿ'ā ca'ā sa chi din'dái yā 'áámá chi che'e nguíinū 'yaaⁿ 'iiⁿ'yāⁿ, ní idiiⁿ sa invitar n'deee n'dáí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ní taachi 'āā chaa che'e nguiinú yā dicho'o yā 'áámá mozo chi caⁿ'a sa cuuvi sa 'iiⁿ'yāⁿ chi ndii yā invitado: Cuchíi nī. 'Āā vɛ́ɛ́ tanducuéⁿ'ē chí che'e nguiinu yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nducyaaca yā ní tucá'a yā caⁿ'a yā 'tíícā: Ch'ɛɛtinúuⁿ nī yeⁿ'é. Ní 'áámá saⁿ'ā ní caⁿ'ā sa: Cáámá ch'iīnū 'caí 'áámá finca ní cánéé chí caⁿ'á n'diīchí finca, chiiⁿ chi ch'ɛɛtinúuⁿ nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Táámá yā ní caⁿ'a yā: 'Caí nyuⁿ'u yáandā itiindu ní neⁿ'é diíⁿ ntiiⁿnyuⁿ ndúúcu tī. Ngiicá favor. Ch'ɛɛtinúuⁿ nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Táámá yā ní caⁿ'a yā: Cáámá ch'iinu ch'iindivaacú chi chiiⁿ nguɛ́ɛ́ cuuvi caⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Taachí nguɛɛcunéé mozo, caⁿ'a sa chuū chii sa 'iivi sa. Tuu'mi ní 'iivi miiⁿ nduuvi taáⁿ yā ní caⁿ'a yā chii yā mozo miiⁿ: Cueⁿ'e di cuaaⁿ níí'vɛ̄ɛ̄ ndúúcū cuaaⁿ cyúúní yeⁿ'e yáāⁿ ní candɛ́ɛ di 'iiⁿ'yāⁿ ndaachíī, ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii ngiicá yā, ndúúcū 'iiⁿ'yāⁿ chi ngaī yó'o, ndúúcū 'iiⁿ'yāⁿ chi ngueenáāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Sáⁿ'ā mozo ní cueⁿ'ē sa. Cuayiivi ní ndaā sa ní caⁿ'ā sa chiī sa 'iivi sa: N'dií, señor, 'āā diíⁿ tan'dúúcā chí ngaⁿ'a nī ní vɛ́ɛ́ cá lugar chi 'cuɛɛ̄tɛɛ́ 'iiⁿ'yāⁿ na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Caⁿ'a señor miiⁿ chiī yā saⁿ'ā mozo miiⁿ: Cueⁿ'e di cuaaⁿ cyúúní n'gɛɛtɛ ndúúcū yúúní chi vɛ́ɛ́ chi neēeⁿ cuááⁿ 'diītū ní di'cuíítu di 'iiⁿ'yāⁿ chí chii yā na vaacú ní 'íícú cuuvi diituú na vaacú. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ti 'úú ní ngaⁿ'á ngīi ndís'tiī chi mar 'áámá saⁿ'ā chí diíⁿ invitar saⁿ'ā vmnaaⁿ nguɛ́ɛ́ 'cuúⁿ ndáa sa che'ē nguiinú sa nduucú na mesa yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cuayiivi mííⁿ nééné n'deee 'iiⁿ'yāⁿ cueⁿ'e yā ndúúcū Jesús. Ní Jesús miiⁿ ní caⁿ'a yā chiī yā 'iiⁿ'yāⁿ s'eeⁿ 'áámá ejemplo: ");
INSERT INTO cuxNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ndúúti chi 'áámá 'iiⁿ'yāⁿ neⁿ'e ca yā chiidá yā o chɛɛcú yā o n'daataá yeⁿ'e yā o daiya yā o 'díínu yā o vi'i yā o vida yeⁿ'ē maáⁿ yā nguɛ́ɛ́ ti 'úú chi Jesús, nguɛ́ɛ́ cuuvi discípulo yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Āā du'ú nūuⁿ chi caⁿ'a yā nduucú ní nguɛ́ɛ́ ndɛ́ɛ yā cruz yeⁿ'e yā chi tan'dúúcā nducuéⁿ'ē chi 'cueenu taavi yā cuuvi cucáávā 'úú nguɛ́ɛ́ cuuvi discípulo yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","¿'Áá chɛɛ́ nūuⁿ 'áámá ndís'tiī taachí neⁿ'e nī din'dái nī 'áámá torre, ¿'áá nguɛ́ɛ́ n'gɛɛtɛ́ nī ní ididuuchɛ́ nī? ¿'Áá n'deēe diíⁿ nī gasto ndúúti chi tu'néé chí'vɛɛ yeⁿ'e nī chí 'cuiinu din'dái nī torre yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ní nduuti chi cu'nuúⁿ nī cimientos yeⁿ'ē torre ní cuayiivi nguɛ́ɛ́ cuuvi din'daí nī torre yeⁿ'e nī, tuu'mi ní nducyaaca yā chi snaaⁿ yā 'cáíⁿnyūⁿneeⁿ yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Iiⁿ'yāⁿ s'eeⁿ ní caaⁿ'maⁿ yā: Sáⁿ'a 'cūū tucá'a sa din'dái sa ní nguɛ́ɛ́ ch'iinu di'cuiīnú sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ní Jesús ngaⁿ'a yā 'tíícā: ¿Du'ú rey ndúúti chi canee chi diíⁿ yā caandaá ndúúcū táámá rey, 'áá nguɛ́ɛ́ n'giindi yā ndúúcū táámá saⁿ'ā ní ididuuchɛ́ yā? Nduuti chi tunééⁿ ndiicu mil soldados ní 'iicu ndúúcū chuú nūuⁿ cuuvi 'cuuⁿ'maⁿ yā ndúúcū soldados chi ndiichi mil yeⁿ'ē táámá rey. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ní nduuti chi nguɛ́ɛ́ cuchɛɛ yā, taachi cuchií yā táámá rey ndúúcū soldados yeⁿ'e yā chi diíⁿ yā caandaá ní canéé yaⁿ'ai ca yā miiⁿ tuu'mi ní rey miiⁿ dicho'ó yā 'iiⁿ'yāⁿ chi candɛ́ɛ̄ nduudu miiⁿ. Ní 'iicu caaca yā taama rey chi 'cuɛɛtinéé 'diiíⁿ yā. Ní nguɛ́ɛ́ diíⁿ yā caandaá ndúúcū rey yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Tiicá ntúūⁿ. 'Āā chɛɛ́ nūuⁿ ndís'tiī nduuti chi nguɛ́ɛ́ cu'nee nī tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'e nī, nguɛ́ɛ́ cuuví cuuvi ndís'tiī discípulos yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesús ngaⁿ'a yā: Yiima ní n'dai. Nduuti chí nguɛ́ɛ́ n'daācā sabor yeⁿ'ē, ¿dɛ'ɛ́ ca'ā sabor yeⁿ'ē? ");
INSERT INTO cuxNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nguɛ́ɛ́ dichíí'vɛ̄, ndii nguɛɛ cáávā yáⁿ'āa, ndii nguɛɛ ndúú naachi vɛ́ɛ́ abono, caati canangée yā yiima miiⁿ. 'Iiⁿ'yāⁿ chi vɛ́ɛ́ veéⁿ yā, 'caandiveéⁿ yā yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nducyáácá saⁿ'ā chí ínn'guɛɛ sa yeⁿ'e yáⁿ'āa ndúúcū 'iiⁿ'yāⁿ nuuⁿndi ndaá yā nanááⁿ Jesús chí 'caandiveéⁿ yā nduudu yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Cáávā chuū 'iiⁿ'yāⁿ fariseos ndúúcū maestros chi ngi'cueeⁿ ley ngaⁿ'a yā n'de'ei yā nguááⁿ maáⁿ yā contra yeⁿ'e Jesús. 'Túúca ngaⁿ'á yā: Jesús miiⁿ n'gúuⁿ yā chí ndaá nanáaⁿ yā 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā. Ní 'iiⁿ'yāⁿ miiⁿ ngé'e yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tuu'mi ní Jesús miiⁿ ní caⁿ'a yā 'aama chi 'tɛ́ɛ́ nguɛɛ daama ndúúcū 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Chɛɛ́ ndís'tiī ndúúti chi vɛ́ɛ́ 'áámá ciento 'iiti cuūchī yeⁿ'e nī ní nduuti chí 'áámá chɛɛ 'iiti s'uuⁿ cuuví ndái tī, ¿'áá nguɛ́ɛ́ cu'nee nī ndu'u chí cuūⁿ ngɛɛcú nditiiⁿ'yú cuuúⁿ tī na 'cuɛ́ɛ́tí? Ní caⁿ'á nī in'nuúⁿ nī 'iiti chi nindáí mííⁿ ndíí taachí nndaacá nī 'iiti miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ní taachí ndaacá nī 'iiti miiⁿ cun'duú nī 'iiti ná 'diimi nī ní candɛ́ɛ nī 'iiti cuūchī miiⁿ naachi canéé tanáⁿ'ā 'iiti cuūchī. Ní yeenú n'dai nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ní taachi nndaa nī na vaacu nī, tuu'mi ní nadidaama nī 'iiⁿ'yāⁿ chi n'dai ndúúcu nī ndúúcū 'iiⁿ'yāⁿ na niiⁿnuúⁿ na va'ai yeⁿ'e nī. Ní caaⁿ'maⁿ nī cuuvi nī, 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī cuuvi yeenú n'dai nī nduucú ní di'viicu yú ti 'āā n'daacá 'iiti cuūchī yeⁿ'é chi nīndaí. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Tuu'mi ní Jesús ngaⁿ'á ntúuⁿ yā, 'úú ngaⁿ'á ngīi ndís'tiī: 'Tíícā vɛ́ɛ́ vaādī yeenú taavi na va'ai chɛɛti nguuvi yeⁿ'ē 'áámá 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā ní ndaacadaami yā yeⁿ'ē nuuⁿndi yeⁿ'e yā nguɛ́ɛ́ ti yeⁿ'ē cuūⁿ ngɛɛcú nditiiⁿ'yu cuūuⁿ 'iiⁿ'yāⁿ chi n'dai chi nguɛ́ɛ́ canee cuumi chi ndaacadaami yā yeⁿ'ē nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ní caⁿ'a Jesús: Du'u 'áámá n'daataá chi vɛ́ɛ́ ndiichi cáádí yeⁿ'ē ta nduuti chi dindai tá 'áámá ¿'áá 'cuuⁿ'miⁿ tá lámpara ní n'daaca tá va'āī, ní in'nuuⁿ tá ndúúcū cuidado taanduvɛ́ɛ́ ndíí ndaācā ta tuūmī miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Taachí ndaācā tá nadaama tá 'iiⁿ'yāⁿ chi n'dai ndúúcu ta ndúúcū 'iiⁿ'yāⁿ na niiⁿnuúⁿ va'ai yeⁿ'e ta ní caⁿ'a tá: Cuuvi yeenú nī nduucú ní di'viicu yú ti 'āā ndaācá 'áámá cáádí yeⁿ'é chí chindāi miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","'Úú ngaⁿ'á ngií ndís'tiī caati 'tiicá ntúūⁿ vɛ́ɛ́ vaadī yeenú nguaaⁿ ángeles yeⁿ'é Ndyuūs cucáávā 'áámá 'iiⁿ'yāⁿ nuuⁿndi chí nandaacadaamí yā yeⁿ'ē nuuⁿndi yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ngaⁿ'a ntúuⁿ yā ejemplo 'cūū: 'Áámá saⁿ'ā vɛ́ɛ́ 'uūvī daiya sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Saⁿ'ā n'gaiyáā daiya sa chi 'lííⁿ ca miiⁿ caⁿ'a sá chii sá chiida sa: N'diī, chiidá, tée nī parte chi ituneeⁿ 'úú yeⁿ'e vaādi ngua'aá yeⁿ'e nī. Chiida sa ní nacaⁿ'á yā ní nca'a yā saⁿ'ā chi parte yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nguɛ́ɛ́ chi 'naaⁿ, saⁿ'ā 'lííⁿ ca miiⁿ ní nadīdaamá sá tanducuéⁿ'ē déndu'ū yeⁿ'ē sa. Ní cueⁿ'e yaⁿ'ai sa táámá país. Mííⁿ ch'iinu diiⁿ sa gastar tanducuéⁿ'ē ti diiⁿ sa nducuéⁿ'ē chi nguɛɛ n'daacā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ní taachi ch'iinu tuūmī yeⁿ'ē sa tanducuéⁿ'ē chi ca'a chiida sa, ndaā 'áámá cuiicu ch'ɛɛtɛ na país miiⁿ. Sáⁿ'ā miiⁿ ní ch'eenū n'dai sa chiī caati nguɛ́ɛ́ chí che'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Saⁿ'ā miiⁿ ní ndaā sa nanááⁿ 'áámá 'iiⁿ'yāⁿ yeⁿ'e país miiⁿ. Ní caⁿ'a sa chi neⁿ'e sa diiⁿ sa ntiiⁿnyuⁿ. 'Iiⁿ'yāⁿ miiⁿ ní caⁿ'a yā chii yā saⁿ'a miiⁿ chi cueⁿ'e sa tan'dúúcā mozo yeⁿ'é yā ní diiⁿ sa cuidado cuūchí s'eeⁿ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Saⁿ'ā miiⁿ ní nacádiinuuⁿ sa chí neⁿ'ē sa che'e sa chi yeⁿ'ē cuuchí s'eeⁿ caati mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ ca'a yā dɛ'ɛ̄ vɛɛ saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tuu'mi ní n'gaācu sa ní caⁿ'ā sa nguaaⁿ maaⁿ sa: N'deee n'dáí mozos yeⁿ'e chiidá chí nge'e yā pan ní neené n'deee chí nge'e yā vɛɛ, 'iicu 'muuⁿ 'úú ní idiíⁿ ntiiⁿnyuⁿ ní neⁿ'ē 'cuūvi chi cuiicú. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","N'daa cá 'muuⁿ. Naⁿ'á n'diichí chiidá ní caaⁿ'máⁿ cuuví 'iiⁿ'yāⁿ: N'diī chiidá vɛ́ɛ́ nuūⁿndī yeⁿ'é nanááⁿ Ndyuūs chi canéé na va'ai chɛɛti nguuvi ní nanááⁿ n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Āā ntɛ́ɛ́ n'dai ca 'úú chi tuneeⁿ 'úú chi caaⁿ'maⁿ nī chi daiya nī 'úú. Cu'neéⁿ nī 'úú tan'dúúcā 'aama mozo yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tuu'mi ní cunaⁿ'ā sa ndaā sa nanááⁿ chiīdā sa. Taachi indái ca nndaa sa, tuu'mi ní chiida sa ní n'diichí yā saⁿ'ā ní nnee ya'āī 'iinú yā saⁿ'ā. Chiida sa ní cueⁿ'e yā ngeenu yā naachi canéé sá ní tumaⁿ'á yā daiyá yā ní tuu'vi yā cheendi sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Daiya yā miiⁿ ní caⁿ'a sa chii sa chiida sa: N'diī, chiidá, vɛ́ɛ́ nuuⁿndi yeⁿ'é nanááⁿ Ndyuūs chi canee na va'ai chɛɛti nguuvi ndúúcū nanááⁿ n'diī. 'Āā n'tɛ́ɛ́ n'dai ca 'úú chí ituneeⁿ 'úú chi caaⁿ'máⁿ nī chi daiya nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Naati chiida sa mííⁿ ní caⁿ'a yā chii yā mozos yeⁿ'e yā: Dii mozos, maaⁿ nch'ɛɛtɛ́ nūu tun'dáa di tíinūuⁿ chí n'dai ca ní cu'nuúⁿ di saⁿ'ā daiyá. Ní ca'a di chiīnūta'āa cunuuⁿ ta'ā sa ndúúcū ndaacuú chi cunuuⁿ ca'ā sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cuéⁿ'e di canguaiⁿ di itiindu 'lííⁿ chi 'viichɛɛ́. Ní 'caaⁿ'nuⁿ di 'iiti chi che'é 'nū. Ní diíⁿ 'nū 'viicu. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ti sáⁿ'a 'cūū daiyá cueⁿ'e sa yaⁿ'ai ní 'āā tan'dúúcā chi n'dií sá. Maaⁿ ní navaacunée sa ní nduuchi sa. Ní tan'dúúcā chí nīndáí sá ní ndaācā sa. Ní 'iiⁿ'yāⁿ s'eeⁿ ní yeenú taavi yā ní diíⁿ yā 'áámá 'viicu. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ní saⁿ'ā daiyá yā chí vmnaaⁿ canee sa cuɛɛti. Ní taachí ndaā nííⁿnūuⁿ sa ná va'ai, ch'iindiveeⁿ sa chí itiivi saⁿ'ā flauta ní 'iiⁿ'yāⁿ nde'ei yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tuu'mi ní saⁿ'ā miiⁿ ní 'caī sa 'aama mozo ní itiinguuneeⁿ sa mozo miiⁿ dɛ'ɛ̄ chi vɛ́ɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mozo miiⁿ ní caⁿ'ā sa chii sa 'iiⁿ'yāⁿ: 'Āā ndáā 'díinu nī. Ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ yeⁿ'ē sa. Ní chiidá nī ní caⁿ'a ntiiⁿnyuⁿ yā chí ch'iī itiindu 'lííⁿ chi 'viichɛ. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Saⁿ'ā miiⁿ ní nduuvi taaⁿ sa. Nguɛ́ɛ́ 'cuuⁿ sa nndaā sa va'āī. Tuu'mi ní chiida sa miiⁿ ní cun'dáa yā va'āī ní di'cuíítu yā daiya yā chí nuūⁿ ndaā sa va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naati saⁿ'ā miiⁿ ní nán'guɛɛcútaⁿ'ā sa yeⁿ'e chiida sa: 'Āā 'naaⁿ n'dáí idichíí'vɛ̄ 'úú n'diī, ní diíⁿ tanducuéⁿ'ē chi ngaⁿ'a nī ní mar 'áámá vmnéⁿ'ēe nguɛ́ɛ́ tee nī mar 'áámá 'iiti cuūchī 'lííⁿ chi 'caaⁿ'núⁿ ní diíⁿ 'viicu. Ní 'úú cuuvi yeenú ndúúcū amigos yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naatí taachi ndaā daiya nī sáⁿ'a 'cūū, 'nííⁿnuúⁿ 'tuū'vī sa tanducuéⁿ'ē chí vaadī n'guá'āa yeⁿ'ē sa ndúúcū n'daataa s'eeⁿ chi vɛ́ɛ́ saⁿ'ā s'eeⁿ yeⁿ'e. Ní ngaⁿ'a ntiiⁿnyúⁿ nī chi mozos ch'iiⁿ'núⁿ yā itiindu 'lííⁿ chi 'viichɛɛ́ chi che'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tuu'mi ní chiida sa miiⁿ caⁿ'a yā chii yā saⁿ'ā: Díí, daiyá, 'áámá canee di nduucú ní tanducuéⁿ'ē dendu'ū chiī yeⁿ'é ní yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Canéé chí diiⁿ yú 'viicu ti saⁿ'ā 'diinu di chi 'úú nacadiinú chi tan'duucā chi 'āā n'dií sá ní nduuchí sa. 'Āā nindáa sa na vaacu yú ní maaⁿ ní ndaācā yú saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ní caⁿ'a ntúuⁿ yā chii yā discípulos yeⁿ'e yā: 'Áámá dueño 'cuiica s'nééⁿ 'áámá mayordomo yeⁿ'ē yáⁿ'āa yeⁿ'e yā. Náⁿ'ā mozos ndaa sa nanááⁿ dueño ní tun'dáá nuuⁿndi sa yeⁿ'ē mayordomo miiⁿ ní ngaⁿ'ā sa dɛ'ɛ̄ chi diiⁿ mayordomo chi nguɛɛ n'daācā ndúúcū dendu'ū chi yeⁿ'ē dueño. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tuu'mi ní dueño miiⁿ ní yaa'vi yā mayordomo yeⁿ'e yáⁿ'āa ní caⁿ'a yā chii yā sáⁿ'ā: N'diī, ¿dɛ'ɛ 'túúcā n'giindiveéⁿ yeⁿ'e nī? Teé nī cuenta 'úú yeⁿ'ē ntiiⁿnyuⁿ chi diíⁿ nī tí 'āā ntɛ́ɛ́ cuuví nī mayordomo. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Saⁿ'ā mayordomo yeⁿ'e yáⁿ'āa miiⁿ nadicádíinuuⁿ sa 'túúcā: ¿Taācā diíⁿ maaⁿ caati dueño yeⁿ'e yáⁿ'āa ndivíi yā 'úú yeⁿ'e chi mayordomo 'úú yeⁿ'ē ntiiⁿnyuⁿ? Nguɛ́ɛ́ ditiīnu 'úú chí diíⁿ ntiiⁿnyuⁿ chi n'gii ní nduuti chi caācá limosnas, 'cuinaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","'Āā deenú dɛ'ɛ̄ chi diíⁿ ní taachi 'āā ntɛ́ɛ́ ngaⁿ'a ntiiⁿnyúⁿ yeⁿ'e mayordomo tuu'mi ní amigos yeⁿ'é 'cuaáⁿ yā 'úú na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tuu'mi ní mayordomo miiⁿ yaa'vi sa nducyáácá 'iiⁿ'yāⁿ chí cán'díícu yā yeⁿ'e dueño yeⁿ'e yáⁿ'āa yeⁿ'e yā ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ vmnááⁿ vmnaaⁿ: ¿'Áá n'deēe cán'díícu di yeⁿ'e dueño? ");
INSERT INTO cuxNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Saⁿ'ā miiⁿ ní caⁿ'a sa: 'Úú can'diicú 'áámá ciento toneles aceite. Tuu'mi ní mayordomo miiⁿ ní caⁿ'a sa saⁿ'ā: Cuta'a dí caaca naachi canéé nguūⁿ yeⁿ'ē di. Cuundi dí ní n'nee nguūⁿ di 'uūvī ngɛɛcu ndiichí toneles aceite. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ch'iinu maaⁿ ní caⁿ'a sa chii sa taama saⁿ'ā: Díí, ¿'áá n'deēe cán'díícu di? Saⁿ'ā miiⁿ ní caⁿ'a sa: 'Úú can'diicú 'áámá ciento maquilas yeⁿ'ē trigo. Tuu'mi ní mayordomo miiⁿ caⁿ'a sa: Cuta'a dí caaca naachi canéé nguūⁿ yeⁿ'ē di ní 'neeⁿ ngūuⁿ di cuūuⁿ ngɛɛcú maquilas. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tuu'mi ní dueño miiⁿ tuumicádiinuuⁿ yā yeⁿ'ē mayordomo chi nguɛ́ɛ́ n'daacā ní chuuné listo sa ndúúcū asuntos yeⁿ'ē sa. Ní dueño mííⁿ caⁿ'a yā chii yā saⁿ'ā: Tiempo miiⁿ sáⁿ'ā chi snéé iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ n'daaca sa ní neene listo ca sa ndúúcū asuntos yeⁿ'ē sa ndúúcū vaadī 'cuiica chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ ti 'iiⁿ'yāⁿ chi diíⁿ yā chiiⁿ chi Ndyuūs neⁿ'e yā chi snée yā na dɛɛvɛ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Cáávā chuū 'úú ní ngaⁿ'á ngií ndís'tiī: Ndúúcū vicios yeⁿ'e vaadi 'cuiica chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū diíⁿ nī n'daācā ndúúcū 'iiⁿ'yāⁿ ti vɛ́ɛ́ amigos yeⁿ'e nī caati taachi 'cuūvi nī 'iiⁿ'yāⁿ s'eeⁿ chi nnee nī ní ngaⁿ'á yā: N'dai ndís'tiī ¿'áá cuuvi ndaa nī na va'ai chɛɛti nguuvi 'tíícā? ");
INSERT INTO cuxNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","'Iiⁿ'yāⁿ chi n'daacā idiíⁿ yā ndúúcū cosas chi 'lííⁿ 'tiicá ntúūⁿ n'daacā idiíⁿ yā ndúúcū cosas chi n'deee n'dáí ní n'gɛɛtɛ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nduuti chi ndís'tiī nguɛ́ɛ́ n'daacā idiíⁿ nī ndúúcū tuūmī chi vɛ́ɛ́ íⁿ'yeeⁿdí 'cūū, ¿du'ú 'iiⁿ'yāⁿ cuuvi teé yā ndís'tiī ntiiⁿnyuⁿ yeⁿ'é Ndyuūs chi ntiiⁿnyuⁿ yeⁿ'ē vaadi 'cuiica chi vɛ́ɛ́ chi yeⁿ'é Ndyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ndúúti chi ndís'tiī nguɛɛ n'daacā idiíⁿ nī ndúúcū dendu'ū chi vɛ́ɛ́ yeⁿ'e taamá yā, ¿du'ú 'iiⁿ'yāⁿ tée yā chi vɛ́ɛ́ yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mar 'áámá saⁿ'ā nguɛ́ɛ́ cuuvi diiⁿ sa mandados yeⁿ'e 'uūvī 'iivi sa; ti neⁿ'e ca sa 'aama yā nguɛ́ɛ́ ti taama yā, o n'daacā ca diiⁿ sa ntiiⁿnyuⁿ yeⁿ'ē 'aama yā nguɛ́ɛ́ ti taama yā. Ndís'tiī ní nguɛ́ɛ́ cuuvi dichíí'vɛ̄ Ndyuūs nduuti chi neⁿ'e ca nī vaadī 'cuiica chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","'Iiⁿ'yāⁿ fariseos n'giindiveéⁿ ntúuⁿ yā dendu'ū chi 'túúcā ngaⁿ'a Jesús miiⁿ ní 'iiⁿ'yāⁿ s'eeⁿ dinéⁿ'e n'dai yā tuūmī ní yaa'vi neeⁿ yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús miiⁿ ní caⁿ'a yā chiī yā 'iiⁿ'yāⁿ fariseos: Ndís'tiī ní nadicádiinuuⁿ nī chi ndís'tiī ní 'iiⁿ'yāⁿ n'dai ndís'tiī nanááⁿ saⁿ'ā iⁿ'yeeⁿdí 'cūū naati Ndyuūs ní n'diichí yā staava yeⁿ'e ndís'tiī. Chííⁿ chí 'iiⁿ'yāⁿ nadicádiinuuⁿ yā chí ch'ɛɛtɛ ca, chiiⁿ chi Ndyuūs diíⁿ yā cuenta chi nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ley yeⁿ'e Moisés ndúúcū chííⁿ chí chi'cueeⁿ profetas canee nanááⁿ ndís'tiī ndíí taachi ndaā Juan chi chɛɛdínuūⁿnīⁿ na iⁿ'yeeⁿdí 'cūū. Ndíí tiempo miiⁿ 'iiⁿ'yāⁿ caⁿ'a yā nduudú n'dai chí ngai yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní nducyáácá 'iiⁿ'yāⁿ neⁿ'e yā cu'téénu yā nduudu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ngíⁿ'īi ca chí 'cuiīnu nanguuvi ndúúcū na yáⁿ'āa nguɛ́ɛ́ ti 'cuiīnū 'áámá letra 'lííⁿ yeⁿ'e ley. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'Āā du'ú nūuⁿ sáⁿ'ā chí cū'neeⁿ sa n'daataá yeⁿ'ē sa ní 'caandivaacu sá ndúúcū taama tá diiⁿ nuuⁿndí sa. Sáⁿ'ā chi cunee sá ndúúcū n'daataá chi s'neeⁿ tá isaⁿ'ā yeⁿ'ē tá 'āā dinuuⁿndí ntúuⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Caⁿ'a Jesús: Tiempo chi chó'ōo canéé 'áámá saⁿ'ā 'cuiica chí 'nuuⁿ sa catecai n'dai sa ní diiⁿ sá 'viicu. Ní nge'e sa cosas chi n'dai nguuvi nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Canéé ntúūⁿ 'áámá saⁿ'ā chi nguuvi sa Lázaro chí ngiica limosnas. Ní diituú n'duu'vi núúⁿmáⁿ chɛɛtɛ sa. Ní vɛɛ sa cheendi va'āī yeⁿ'é saⁿ'ā 'cuiica miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Saⁿ'ā miiⁿ ní neⁿ'e sa che'e sa cosas chi ingéē yeⁿ'e mesa yeⁿ'e saⁿ'a 'cuiicá miiⁿ. Ndaā 'yaānā s'eeⁿ naachi vɛ́ɛ sa ní yaā'vi née tī naachí ya'āī yeⁿ'e Lázaro miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cuayiivi miiⁿ ní ch'iī Lázaro. Ángeles yeⁿ'é Ndyuūs candɛ́ɛ yā Lázaro naachi canéé chiida yú Abraham na lugar paraíso chi yeⁿ'e 'iiⁿ'yāⁿ chi n'dáí. Ch'iī ntúūⁿ saⁿ'a 'cuiica miiⁿ ní ch'iichi yā saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Taachi sáⁿ'ā 'cuiica miiⁿ ch'eenu sa chiī na infierno n'diichi sa cuaaⁿ 'niiⁿnuⁿ ní n'diichi sa chiida yú Abraham ndúúcū Lázaro miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tuu'mi ní 'caī saⁿ'ā 'cuiica miiⁿ: N'dií, chiidá Abraham, inneé ya'ai 'iinú nī 'úú, ní dichó'o nī Lázaro chi di'caandá yā tiī nduuti tá'ā nguaaⁿ nuūⁿnīⁿ ní cun'duú yā na ch'iīyá ní di'caanda ch'iīyá ti neené n'geenú ngii ná nguuchi yaⁿ'ā 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham miiⁿ ní caⁿ'a yā chiī yā saⁿ'ā: Díí, daiyá, n'gaacú di tí taachí canee dí iⁿ'yeēⁿdī miiⁿ ch'iīndī ndii n'deee n'dáí chi n'daācā yeⁿ'ē di. Lázaro miiⁿ nguɛ́ɛ́ vɛɛ yeⁿ'ē sa naati maaⁿ ní 'muuⁿ ní vɛ́ɛ́ 'viich'ɛ̄ɛ̄tíínūuⁿ yeⁿ'ē sa ní díí ní 'cuéénú dí cuuvi miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mííⁿ vɛ́ɛ́ 'áámá yííví yáⁿ'āa chi neene ch'ɛɛtɛ nguaaⁿ nús'uu ndúúcū ndís'tiī. 'Iiⁿ'yāⁿ chí neⁿ'e yā chó'o yā ndii 'muuⁿ ndíí naachi snéé ndís'tiī nguɛ́ɛ́ cúúví diíⁿ yā. Ndíí nguɛ́ɛ́ ndúú 'iiⁿ'yāⁿ chi snée yā taa nguɛ́ɛ́ cuuví cho'o yā ní ndaá yā naachi snée 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tuu'mi ní saⁿ'ā 'cuiica mííⁿ ngaⁿ'ā sa: N'diī, chiidá Abraham, idi'cuíitú n'diī chí dichó'o nī Lázaro iⁿ'yeēⁿdī ndii vaacu chiidá, ");
INSERT INTO cuxNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ti vɛ́ɛ́ nyuⁿ'u 'diinú chi saⁿ'ā miiⁿ ní Lázaro cuuvi sa 'diinú chi nguɛ́ɛ́ ndaa yā lugar 'cūū chí 'cueenu yā cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham miiⁿ ní caⁿ'a yā chii yā saⁿ'a: Canee nguūⁿ na libro yeⁿ'é Ndyuūs naachi canee nguūⁿ yeⁿ'e Moisés miiⁿ ndúúcū profetas ní cuuví yā 'iiⁿ'yāⁿ chi 'caandiveéⁿ yā yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tuu'mi ní saⁿ'ā 'cuiica miiⁿ ní caⁿ'ā sa: N'diī, chiidá Abraham, nguɛ́ɛ́ n'giindiveéⁿ yā yeⁿ'e yā. Ndúúti chi 'áámá 'iiⁿ'yāⁿ chi 'āā n'dii caⁿ'a yā nanááⁿ 'diinú, tuu'mi ní 'caandiveéⁿ yā yeⁿ'é 'iiⁿ'yāⁿ miiⁿ ní ndaacadaamí yā yeⁿ'ē nuuⁿndi chi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham miiⁿ ní caⁿ'a yā chii yā saⁿ'a 'cuiica: Ndúúti chi nguɛ́ɛ́ cu'téénu yā chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs yeⁿ'e Moisés ndúúcū 'iiⁿ'yāⁿ profetas ndíí cuááⁿ vmnaaⁿ, nguɛ́ɛ́ cu'téénu ntúuⁿ yā yeⁿ'é 'iiⁿ'yāⁿ 'cúū chi cuuví yā 'iiⁿ'yāⁿ s'eeⁿ 'áárá chí 'iiⁿ'yāⁿ 'cúū ncuéeⁿ yā yeⁿ'e nguaaⁿ tinaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: Cuaacu nííⁿnyúⁿ chi vɛ́ɛ́ dɛ'ɛ cáávā chí diīíⁿ chí 'iiⁿ'yāⁿ dinuuⁿndi yā naati dɛ'ɛ chúúcā ya'ai yeⁿ'e 'iiⁿ'yāⁿ chi diíⁿ yā chi taama 'iiⁿ'yāⁿ dinuuⁿndi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","N'daacā ca chí cuuvi 'túúcā ndúúcū 'iiⁿ'yāⁿ miiⁿ. 'Iiⁿ'yāⁿ s'eeⁿ caāchiichí yā 'áámá tuūu yúúdú chi inguúⁿ 'iiⁿ'yāⁿ na daandu 'iiⁿ'yāⁿ miiⁿ ní 'caanuú yā 'iiⁿ'yāⁿ miiⁿ naachi yáānūuⁿ yeⁿ'ē nuuⁿni'yáⁿ'ā ní nguɛ́ɛ́ cuuvi diiⁿ 'iiⁿ'yāⁿ miiⁿ chi taama da'caiyáā idinuuⁿndi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cundɛ́ɛ ndís'tiī cuidado. Ndúúti 'díínu nī dinuuⁿndí sa contra yeⁿ'e 'aama nī, yaa'vi neéⁿ nī saⁿ'ā. Ndúútī chi ndaacadaami sa yeⁿ'ē nuuⁿndi yeⁿ'ē sa nadich'ɛɛcú nī yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Áárá chí ndɛɛ̄chɛ̄ cuuvi idinuuⁿndí sa contra yeⁿ'e nī 'áámá nguuvi ní ndɛɛ̄chɛ̄ cuuvi ndaa sa nanááⁿ ndís'tiī ní caaⁿ'maⁿ sa cuuvi sá ndís'tiī: Ndaacadaāmí yeⁿ'ē nuuⁿndi yeⁿ'é, tuu'mi ní nadich'ɛɛ̄cu nī yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apóstoles caⁿ'a yā chii yā Señor Jesús: N'diī, Señor, diíⁿ nī chi nús'uu cuuvi cu'téénu cá 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tuu'mi Jesús caⁿ'a yā chii yā apóstoles: Ndúútí chi ndís'tiī duu'vi i'téénu nī, tuu'mi ní vaadī i'teenu yeⁿ'é nī ní tan'dúúcā 'áámá nduutí yeⁿ'ē yiīvɛ̄ ntíí'yaá. Ní cuuvi caaⁿ'maⁿ nī 'tíícā ndúúcū yáⁿ'á: Díí yáⁿ'á cuvíi dí 'muuⁿ ní cueⁿ'e di ná nuūⁿnīⁿ'yáⁿ'ā. Ní 'caandiveeⁿ yáⁿ'á miiⁿ yeⁿ'e dii. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ngaⁿ'a Jesús: Du'u ndís'tiī ndúútī chi vɛɛ 'áámá mozo chi di'cuūndú 'iiti o diiⁿ sa cuidado 'iiti cuūchī yeⁿ'e nī taachi nguɛɛcunée sa yeⁿ'e campo miiⁿ, ¿'áá hora mííⁿ nūuⁿ caaⁿ'maⁿ nī cuuvi nī saⁿ'ā?: Cho'o di 'cuūndī di na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿'Áá nguɛ́ɛ́ vmnááⁿ vmnaaⁿ caaⁿ'maⁿ nī cuuvi nī mozo miiⁿ 'tíícā?: N'nuuⁿ di chi che'e nguiīnu yú. Ní 'cuiinduū di yeⁿ'é na mesa, 'cuiī di ní 'úú cu'ú che'é. 'Cuiinu che'é 'cuiinu cu'ú tuu'mi ní dii cuuvi ché'e di cu'u di. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿'Áá aama patrón nca'a yā gracias mozo miiⁿ ti diiⁿ sa mandados chi cāⁿ'a patrón yeⁿ'ē sa? Nguɛ́ɛ́ diíⁿ yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'Tiicá ntúūⁿ, ndís'tiī, taachí 'cuiinu diíⁿ nī tanducuéⁿ'ē ntiiⁿnyuⁿ chí ngaⁿ'á Ndyuūs ndís'tiī, tuu'mi ní caaⁿ'maⁿ nī 'tiicā: Ndyuūs, nús'uu ní mozos yeⁿ'e nī naati nús'uu ní diíⁿ 'nū dámaāaⁿ chi canee chi diíⁿ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Taachí Jesús miiⁿ canúuⁿ yā yúúní chí cueⁿ'e yā na yáāⁿ Jerusalén, cho'ó yā naavtaⁿ'ā yeⁿ'e na 'uuvī yáⁿ'āa chi Samaria ndúúcū Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ní taachí Jesús sndaa yā 'áámá yáāⁿ 'lííⁿ snéé ndiichi saⁿ'ā chí induuti yuūtɛ̄ yeⁿ'ē sa chi ndii sa ca'ai lepra. Ndaā sa nanááⁿ Jesús miiⁿ ní ch'ɛ́ɛ́tíndii yaⁿ'ai sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ní 'cai sa: N'diī, 'iivú Jesús, nnéé ya'ai 'iinu nī nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Taachí Jesús n'diichi yā saⁿ'ā s'eeⁿ, tuu'mi ní yaa'vi yā: Ndís'tiī, cueⁿ'e nī ní 'cuuⁿ'miⁿ nī nanááⁿ chiiduú s'eeⁿ. Ch'íínú caⁿ'a Jesús ndúúdú 'cūū saⁿ'ā s'eeⁿ ní nduuvá yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tuu'mí 'áámá chɛ́ɛ́ saⁿ'ā s'eeⁿ taachí n'diichi yā chi 'āā nduuvá yeⁿ'e yā, nguɛɛcunée yā ní cheⁿ'e yā naachi canéé Jesús miiⁿ ní caⁿ'a yuudu yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ní chiintii'yá yā nanááⁿ Jesús ní chi snaaⁿ na yáⁿ'āa, ní ca'a yā gracias 'iiⁿ'yāⁿ. Saⁿ'ā miiⁿ ní 'áámá saⁿ'ā yeⁿ'e yáⁿ'āa Samaria. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tuu'mi ní Jesús miiⁿ caⁿ'a yā: ¿'Áá nguɛɛ ndiichi saⁿ'ā chí nduūvā yeⁿ'ē sa? Ta nuuⁿ sa, ¿tii snéé sa? ");
INSERT INTO cuxNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿'Áá nguɛɛ táámá yā chí canéé chi caaⁿ'maⁿ yā chi ch'ɛɛtɛ Dendyuūs? Dámaāⁿ saⁿ'ā miiⁿ chi canuuⁿ yúúní chi ca'a sa gracias. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tuu'mi ní Jesús caⁿ'a yā chii yā saⁿ'ā chi ngiīta miiⁿ: Nducueeⁿ dí. Cúnaⁿ'ā di. 'Āā nanduuva yeⁿ'ē di caati i'téénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Taachí 'iiⁿ'yāⁿ fariseos intíínguúneeⁿ yā Jesús miiⁿ: ¿Tií cua'a ndáá naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā? Jesús miiⁿ ní nan'guɛɛcútaⁿ'a yā: Naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā nguɛ́ɛ́ ndaa tan'dúúcā 'áámá manera chi ndís'tiī cunee ngiinú nī yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ní nguɛ́ɛ́ ndúú 'iiⁿ'yāⁿ caaⁿ'maⁿ ra yā 'tíícā: 'Muuⁿ canee o miiⁿ canee ti Ndyuūs 'āā ngaⁿ'a ntiiⁿnyúⁿ yā nguaaⁿ ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos yeⁿ'e yā: Tiempo miiⁿ ndaa nguuvi taachi ndís'tiī neⁿ'e nī snaaⁿ nī taachi canéé Saⁿ'ā chi Daiya Dendyuūs, naati nguɛ́ɛ́ snaaⁿ nī saⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ní 'iiⁿ'yāⁿ caaⁿ'maⁿ yā cuuvi yā nduudu yaadi ndís'tiī: 'Muuⁿ canéé Saⁿ'a chi Daiya Dendyuūs, o miiⁿ canee sa. Nguɛ́ɛ́ caⁿ'a nī ndíí nguɛ́ɛ́ ndúú can'dáa nī 'iiⁿ'yāⁿ cuayiivi. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tan'dúúcā chi inaaⁿ yú chí ngéⁿ'é 'cuai maaⁿ nchɛɛtɛ́ nūuⁿ ngiiyā, 'tiicá ntúūⁿ cuuvi taachi 'úú chi Saⁿ'ā chi Daiya Dendyuūs ndaá nguuvi miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Naati vmnááⁿ vmnaaⁿ 'úú chi Saⁿ'ā chi Daiya Ndyuūs ní neené 'cueenú cuuvi. Ní 'iiⁿ'yāⁿ chi maaⁿ snéé iⁿ'yeeⁿdí 'cūū diíⁿ yā condenar 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tan'dúúcā chi canee tiempo chi 'āā chó'ōo taachí canee saⁿ'ā Noé iⁿ'yééⁿdi 'cūū, 'tiicá ntúūⁿ cuuvi tiempo yeⁿ'ē Saⁿ'a chi Daiyā Dendyuūs taachi ndaa sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tiempo yeⁿ'e Noé 'iiⁿ'yāⁿ s'eeⁿ ngé'e yā ngi'i yā ní n'gííndivaacu yā. Ní ca'a yā daiya yā chí n'giindivaacu ndii nguuvi chi Noé sndaá yā na arca. Tuu'mi ní chee taaⁿ cuūvī ní chiitu iⁿ'yeeⁿdí 'cūū ndúúcū nuūⁿnīⁿ ní ch'iī nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'Tiicá ntúūⁿ chiī tiempo chi 'āā chó'ōo taachi canee saⁿ'a Lot iⁿ'yeeⁿdí 'cūū. 'Iiⁿ'yāⁿ s'eeⁿ nge'e yā ngi'i yā. Ngai yā ní n'diicui yā. Ní ngiinú yā ní idin'dái yā vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Taachi can'daā saⁿ'ā Lot miiⁿ ná yáāⁿ Sodoma chi cheeⁿ nguuchi yaⁿ'ā ndúúcū azufre chí tuūú chí ngiichi chí yeⁿ'e nanguuvi. Cáávā chuū ch'iī nducyaaca 'iiⁿ'yāⁿ na yáāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Tíícā cuuvi nguuvi miiⁿ taachi 'úú Saⁿ'ā chi Daiya Dendyuūs ndaá taama vmnéⁿ'ēe. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ní nguūvī chi ndaá, taachí 'iiⁿ'yāⁿ chi snée yā tiíⁿ va'āī n'daacā ca chi 'iiⁿ'yāⁿ miiⁿ ní nguɛ́ɛ́ nch'éeⁿ yā ní cuta'a yā dendu'ū chi vɛ́ɛ́ yeⁿ'e yā chɛɛtí va'āī. 'Tiicá ntúūⁿ 'iiⁿ'yāⁿ chi snée yā cuɛɛti n'daacā ca chi nguɛ́ɛ́ naⁿ'a yā nduvaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Nan'gáácú nī tan'dúúcā chí ch'iī n'daataá yéⁿ'ē saⁿ'ā Lot. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí neⁿ'e cá yā vida yeⁿ'e yā nguɛ́ɛ́ ti 'úú, dindaí yā táámá vida yeⁿ'e yā. 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi dichíí'vɛ yā 'úú ní díndaí yā vida yeⁿ'e maáⁿ yā cucáávā 'úú, ní nndaacá yā táámá vida yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Úú ngaⁿ'á ngií ndís'tiī chi nguiīnū miiⁿ 'uuvi yā chi ndiiti yā na 'áámá cama, 'aama yā ní ndaā naáⁿ ní taama yā ní canée yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Níícú naachi 'uuvi n'daataá daama snee ta ingúu tá, 'aama ta ní ndaā naáⁿ tá ní taama tá ní canee ta. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Naachí 'uūvi yā snée yā cuɛɛti, 'áámá yā ni ndaā naáⁿ yā, níícú taama yā ní canee yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Taachí 'iiⁿ'yāⁿ s'eeⁿ ch'iindiveéⁿ yā chuū itinguuneéⁿ Jesús: Señor, ¿tií cuuví chuū? Jesús miiⁿ ní caⁿ'a yā yeⁿ'e tiempo miiⁿ: Naachi candiití cuerpo yeⁿ'e tináⁿ'ā, miiⁿ ní nduuvidaamá luutí ní che'e tī, tuu'mi ní cuuví chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús caⁿ'a yā 'aama ejemplo chi 'tɛ́ɛ́ nguɛ́ɛ́ daama yeⁿ'e chi 'iiⁿ'yāⁿ canéé chi caaⁿ'maⁿngua'á yā cuéⁿ'é daāⁿmaⁿ nguɛ́ɛ́ ndúúcū vaadī 'daan'di. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ ejemplo 'cūū: Canéé 'áámá juez na 'aama yáāⁿ chí nguɛ́ɛ́ 'va'a sa Dendyuūs. Ní ndíí nguɛ́ɛ́ ndúú idiiⁿ rá yā respetar 'iiⁿ'yāⁿ chi ch'iindiveéⁿ yā asuntos yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Canéé ntúūⁿ na yáāⁿ miiⁿ 'áámá n'daataa nguá'āa chi ndaa yā nguuvi nguuvi nanááⁿ juez miiⁿ ní ngiica tá justicia juez yeⁿ'e 'iiⁿ'yāⁿ chi taaⁿ ndúúcu tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Juez miiⁿ ní nguɛ́ɛ́ 'cuuⁿ yā 'naaⁿ tiempo naati cuayiivi nadicádiinuuⁿ yā: 'Áárá chi nguɛ́ɛ́ 'va'á Dendyuūs ndíí nguɛ́ɛ́ ndúú idiiⁿ rá respetar 'iiⁿ'yāⁿ, ");
INSERT INTO cuxNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","naati n'daata nguá'āa 'cūū nééné ididú'ū ta 'úú ní maaⁿ ní caⁿ'á diíⁿ n'daacā ndúúcū tá chi 'āā ntɛ́ɛ́ candiī tá dindú'u ta ti 'cuiinu paciencia yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Naati Señor miiⁿ caⁿ'a yā: 'Caandiveéⁿ nī chi ngaⁿ'ā juez chi nguɛ́ɛ́ n'daacā táácā idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿'Áá Ndyuūs nguɛɛ nnee ntúuⁿ yā 'iiⁿ'yāⁿ chí ndɛɛvɛ yā, 'iiⁿ'yāⁿ chí caaⁿ'maⁿngua'á yā ndii nguuvi ndíí n'gaaⁿ ní Ndyuūs diíⁿ yā castigar 'iiⁿ'yāⁿ chi contra yeⁿ'e 'iiⁿ'yāⁿ chí ndɛɛvɛ yā? ¿'Áá cuuvi 'naaⁿ Ndyuūs chi cunnee yā 'iiⁿ'yāⁿ? Nguɛ́ɛ́ 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Úú ní ngaⁿ'á ngií ndís'tiī chi Ndyuūs maaⁿ nch'ɛɛtɛ́ nadanguáⁿ'ai yā 'iiⁿ'yāⁿ. Naati taachi 'úú chi Saⁿ'ā chi Daiya Dendyuūs ndaá, ¿'áá nndaaca ntuúⁿ 'iiⁿ'yāⁿ chi i'téénu yā Ndyuūs ná iⁿ'yeeⁿdí 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús caⁿ'a yā ejemplo 'cūū chi 'tɛ́ɛ́ nguɛ́ɛ́ dáámá caava n'dúúví 'iiⁿ'yāⁿ chí idin'gɛɛtɛ́ maáⁿ yā ní nguɛ́ɛ́ diíⁿ yā respetar tanáⁿ'ā 'iiⁿ'yāⁿ. Ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Na 'úúví saⁿ'ā cheⁿ'e sa yáacū templo chí caaⁿ'maⁿngua'ā sa. 'Aama sa ní saⁿ'ā fariseo, taama sa ní saⁿ'ā chí inn'guɛɛ yeⁿ'e yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Saⁿ'ā fariseo chí ndii sa ní 'túúcā caⁿ'angua'a sa: N'dií Señor, nteé gracias n'diī ti 'úú ní nguɛ́ɛ́ tan'dúúcā tanáⁿ'ā saⁿ'a 'cūū. 'Úú nguɛ́ɛ́ ididuucú, nguɛ́ɛ́ yáádíí'yā 'úú, nguɛ́ɛ́ caⁿ'á ndúúcū taama n'daataá chi nguɛɛ n'daataá yeⁿ'é, nguɛ́ɛ́ idiíⁿ tan'dúúcā chí idiíⁿ saⁿ'a 'cūū chí inn'guɛɛ sa yeⁿ'ē yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'Úú ní nguɛ́ɛ́ nga'diiⁿnúⁿ 'uūvī cuuvi 'áámá ndɛɛtɛ taachi caaⁿ'maⁿngua'á. 'Úú ní teé décima yeⁿ'e tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'é chi lado yeⁿ'e Ndyuūs chiiⁿ chi tunéeⁿ Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Naati saⁿ'ā chí inn'guɛɛ yeⁿ'e yáⁿ'āa yaⁿ'ai canee sa ní nguɛ́ɛ́ neⁿ'e sa snaaⁿ sa nánguuvi. Dámaāⁿ chí n'geⁿ'e sá niiⁿnuⁿ sa ní ngaⁿ'ā sa: N'dií Ndyuūs, ya'ai 'iinu nī 'úú, ti 'úú 'iiⁿ'yāⁿ nuūⁿndī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Úú ngaⁿ'á ngií ndís'tiī: Sáⁿ'a 'cūū cúnaⁿ'ā sá ndavaacu sa ní Ndyuūs nadich'ɛɛcú yā nuuⁿndi yeⁿ'ē sa. Saⁿ'ā fariseo miiⁿ nguɛ́ɛ́ 'tíícā. 'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí dich'ɛɛtɛ́ maāaⁿ, cuuví yā ndicúūⁿ nanááⁿ Ndyuūs. Ní 'iiⁿ'yāⁿ chí nguɛ́ɛ́ dich'ɛɛtɛ́ maáⁿ yā 'iiⁿ'yāⁿ, Ndyuūs dich'ɛɛtɛ́ yā 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","'Iiⁿ'yāⁿ ní candɛɛ yā da'cáíyāa nanááⁿ Jesús ní 'iicu Jesús tuu'ví yā da'cáíyāa. Taachí discípulos yeⁿ'e Jesús n'diichi yā chuū, yaa'vi née yā 'iiⁿ'yāⁿ s'eeⁿ chí indáa yā ndúúcū dá'caiyāa. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tuu'mi ní Jesús yaa'vi yā discípulos yeⁿ'e yā ní caⁿ'a yā: 'Cuááⁿ nī chí dá'caīyaá chii yā nanaáⁿ. Nguɛ́ɛ́ 'caaca taaⁿ nī caati naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā ní yeⁿ'e 'iiⁿ'yāⁿ chi ndiicuúⁿ yā tan'dúúcā dá'caiyāa. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī: 'Iiⁿ'yāⁿ chi nguɛ́ɛ́ cu'téénu yā Ndyuūs tan'dúúcā 'áámá dá'caiyāa i'téénu yā nguɛ́ɛ́ cuuví ndaa yā naachí ngaⁿ'a ntiiⁿnyuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","'Áámá saⁿ'ā chí ngaⁿ'ā ntiiⁿnyuⁿ sa itíínguuneeⁿ sa Jesús miiⁿ: N'dií, Maestro chí n'dai, ¿dɛ'ɛ̄ cuuvi diíⁿ ní ndaācá vida cueⁿ'e daāⁿmaⁿ chi cuuvi yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús ní caⁿ'a yā chii yā saⁿ'ā: ¿Dɛ'ɛ̄ cúúví chí ngaⁿ'a di ngii di 'úú chi 'úú n'daí 'úú? Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ n'dai yā, dámaāⁿ Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dii ní déénu di chi canéé nguūⁿ na ley 'tíícā: Nguɛ́ɛ́ 'caāⁿ'nūⁿ di; nguɛ́ɛ́ caⁿ'a di ndúúcū táámá n'daataá chi nguɛɛ yeⁿ'ē di; nguɛɛ diduucú di; nguɛ́ɛ́ caaⁿ'maⁿ di nduudu yaadi ndúúcū mar 'áámá 'iiⁿ'yāⁿ; dinéⁿ'e di ch'ɛɛcu di ndúúcū chiida di. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Saⁿ'ā miiⁿ n'guɛɛcútaⁿ'ā sa ní caⁿ'ā sa: Tanducuéⁿ'ē chuū 'āā idiíⁿ taachi saⁿ'ā 'lííⁿ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Taachí Jesús ch'iindiveéⁿ yā chuū, caⁿ'a yā chii yā saⁿ'ā: Vɛ́ɛ́ 'áámá cosa nūuⁿ chi canéé chí diiⁿ di. N'diicui dí tanducueⁿ'ē chi vɛ́ɛ́ yeⁿ'ē di ní ca'a di 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā, ní nndaācā chi vɛ́ɛ́ vaadī 'cuiica na va'ai chɛɛti nguuvi chi cuuvi yeⁿ'ē di. Ní cuchíi di ní caⁿ'a di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Taachí saⁿ'ā miiⁿ ch'iindiveeⁿ sá chuū, neené s'neeⁿ ndaachií yiinú sa, ti neené 'cuiica sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ní taachí Jesús n'diichi yā saⁿ'ā miiⁿ chi neené s'neeⁿ ndaachi yiinú sa, tuu'mi ní caⁿ'a yā: Dɛ'ɛ̄ chúúcā ngíⁿ'īi chí cundaa 'iiⁿ'yāⁿ chi 'cuiica naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ní tan'dúúcā ejemplo 'cūū 'tíícā. Nguɛ́ɛ́ ngiⁿ'īi cá yeⁿ'e 'áámá 'iiti camello chí ch'ɛɛtɛ cá ti 'yúúdūu chí cho'ó tī nduutinááⁿ 'iini chi cheendi va'ai 'lííⁿ nguɛ́ɛ́ ti 'aama saⁿ'ā chi 'cuiica i'téénu sa Ndyuūs ní cundáa sa na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Taachi discípulos n'giindiveéⁿ yā chuū, caⁿ'a yā: ¿Du'ū cuuví nánguaⁿ'āī? ");
INSERT INTO cuxNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ní Jesús caⁿ'a yā: Saⁿ'ā iⁿ'yeeⁿdí 'cūū nguɛ́ɛ́ ngíí diiⁿ sa chuū naati Ndyuūs cuuvi diíⁿ yā tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tuu'mi ní Pedro miiⁿ ní caⁿ'a yā: Señor, cuin'dííchí nī. Nús'uu ní s'neeⁿ 'nū chi vɛ́ɛ́ yeⁿ'é 'nū, ní cuchií 'nū ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús miiⁿ ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií ndís'tiī chi 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí cu'nee yā vaacu yā, o chiidá yā, o chɛɛcú yā, o 'díínu yā, o n'daatáa yeⁿ'e yā, o daiya yā, cáávā chi diíⁿ yā ntiiⁿnyuⁿ yeⁿ'é naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā, ");
INSERT INTO cuxNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","'iiⁿ'yāⁿ miiⁿ n'deēe ca ndaācā yeⁿ'e yā ná iⁿ'yeeⁿdí 'cūū. Ní cuayiivi ní ndaacá yā vida cueⁿ'e daāⁿmaⁿ ná va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús cueⁿ'e yā 'áámá lado ndúúcū ndu'ū ndiichúúví discípulos yeⁿ'e yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Maaⁿ ní caⁿ'ā yú na yáāⁿ Jerusalén ní miiⁿ cúnuuⁿ ca'a tanducuéⁿ'ē chi profetas dingúuⁿ yā ndíí cuááⁿ vmnaaⁿ yeⁿ'e 'úú chi Saⁿ'ā chi Daiya Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ní 'iiⁿ'yāⁿ s'eeⁿ diíⁿ yā entregar 'úú 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e ndaata Israel. Ní 'iiⁿ'yāⁿ s'uuⁿ ní dūūchinéeⁿ yā 'úú ní diiⁿ taaⁿ yā nduucú níícú ca'a neeⁿ daíⁿ yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","'Cuíínú 'cueⁿ'é yā 'úú ní 'caaⁿ'núⁿ yā 'úú naati 'cuíínū 'iīnū nguuvi ní nnduūchí yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Discípulos s'eeⁿ nguɛ́ɛ́ tuumicádíínuuⁿ yā yeⁿ'é dendū'u 'cūū ti canúúⁿ n'de'ei yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. Nguɛ́ɛ́ tuumicádíínuuⁿ yā dɛ'ɛ̄ chi caⁿ'a Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Taachí Jesús ndaā niiⁿnuúⁿ yā na yáāⁿ Jericó, 'áámá saⁿ'ā ngueenááⁿ vɛ́ɛ́ sa niiⁿnuúⁿ cyúúní. Ngiica sá limosnas. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sáⁿ'a 'cūū tááchí ch'iindiveeⁿ sa chí cho'ó n'deēe n'dáí 'iiⁿ'yāⁿ, itiinguunééⁿ sá: ¿Dɛ́'ɛ̄ chí chiī? ");
INSERT INTO cuxNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ní 'iiⁿ'yāⁿ caⁿ'a yā chii yā saⁿ'ā chi ngueenááⁿ chí chó'ōo Jesús chí yeⁿ'ē yáāⁿ Nazaret. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tuu'mi ní saⁿ'ā nguéénaaⁿ miiⁿ 'caī sa: N'dií Jesús, Daiya David, nneé ya'ai 'iinu nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'Iiⁿ'yāⁿ chi cueⁿ'e vmnaaⁿ yeⁿ'e Jesús ngaⁿ'a yā ngii yā saⁿ'ā miiⁿ chí 'āā ntɛ́ɛ́ 'cuaī sa, naati saⁿ'ā miiⁿ ní n'gaī yiicu ca sa: N'diī, Daiya David, nnéé ya'ai 'iinu nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tuu'mi ní Jesús miiⁿ chééndii yā ní caⁿ'a yā chi canguai yā saⁿ'a chi nguɛ́ɛ́ inaaⁿ. Taachí saⁿ'ā miiⁿ ndaā sa nanááⁿ Jesús, Jesús miiⁿ ní itiinguunéeⁿ yā saⁿ'ā: ");
INSERT INTO cuxNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Dɛ'ɛ̄ neⁿ'e di chi diíⁿ ndúúcū dii? Saⁿ'ā miiⁿ ní caⁿ'ā sa: Señor, diíⁿ nī chi snāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús caⁿ'a yā chii yā saⁿ'ā: Cáávā chi i'téénu di nduūvā yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tuu'mí nūuⁿ snaāⁿ sa ní cuéⁿ'e sa ndúúcū Jesús. Ní ngaⁿ'a sa: Dɛ'ɛ chúúcā ch'ɛɛtɛ Ndyuūs. Ní nducyaaca 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ chí n'diichí yā chuū ní caⁿ'a yā: Dɛ'ɛ̄ chúúcā ch'ɛɛtɛ Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Taachí Jesús sndaa yā na yáāⁿ Jericó, cánúuⁿ yā yúúní ní cho'ó yā náávtaⁿ'ā yáāⁿ Jericó miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na yáāⁿ miiⁿ canee 'áámá saⁿ'ā chí 'cuiica sa chi nguuvi sa Zaqueo. Saⁿ'ā miiⁿ, ní saⁿ'ā ndíí tiīiⁿ yeⁿ'é 'iiⁿ'yāⁿ chí inn'guɛɛ yeⁿ'e impuestos yeⁿ'e yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Saⁿ'a miiⁿ ní neⁿ'e sa snaaⁿ sa chɛɛ́ yā chi Jesús miiⁿ naati nguɛ́ɛ́ ngiī inaaⁿ sa ti neené n'deēe 'iiⁿ'yāⁿ ti nguɛ́ɛ́ yaacu sá. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tuu'mi ní cueⁿ'e sa ngéenú sa cuááⁿ vmnaaⁿ ní cuchɛɛ sá 'áámá tiiⁿ yáⁿ'á sicómoro caati cuuvi sa snaaⁿ sa 'iiⁿ'yāⁿ, ti Jesús miiⁿ canee chi cho'ó yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Taachí Jesús miiⁿ ndaá yā miiⁿ, n'diichí yā Zaqueo miiⁿ, ní caⁿ'a yā chii yā saⁿ'ā: Díí, Zaqueo, maaⁿ nch'ɛɛtɛ́ nūuⁿ nch'ééⁿ dí ti maaⁿ ní neⁿ'é cuneé na vaacu dí. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tuu'mí ní Zaqueo miiⁿ maaⁿ nch'ɛɛtɛ́ nūuⁿ nch'eēⁿ sa ní 'cuuⁿ sa chí cueⁿ'e Jesús miiⁿ ndúúcu sa na vaacu sa. Ní yeenú taavi sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Taachí 'iiⁿ'yāⁿ n'diichí yā chuū, nducyaaca yā ní neené n'deēe caⁿ'a yā. Ní caⁿ'a yā chí Jesús miiⁿ ní chinndaá yā chí cunee yā ndúúcū 'aama saⁿ'ā chi vɛ́ɛ́ nuuⁿndī yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tuu'mi ní taachi ch'iindiveeⁿ Zaqueo chuū, chééndii sa nanááⁿ Jesús miiⁿ ní caⁿ'a sá chii sa 'iiⁿ'yāⁿ: Señor, 'caandiveéⁿ nī yeⁿ'é. Ná maⁿ'a chi vɛ́ɛ́ yeⁿ'é ca'á 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā. Ndúúti chi dɛ'ɛ̄ ndivií yeⁿ'ē 'áámá 'iiⁿ'yāⁿ, tuu'mi ní n'guɛɛcuneé cuūuⁿ tanto yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús caⁿ'a yā chiī yā saⁿ'ā: Maaⁿ ní nnguá'āī 'iiⁿ'yāⁿ yeⁿ'e va'ai Zaqueo yeⁿ'e nuuⁿndi yeⁿ'e yā ti Zaqueo miiⁿ ní yeⁿ'e ndaata Abraham. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ti 'úú chí Saⁿ'ā chi Daiya Dendyuūs ní ndaá chí in'nuúⁿ ní 'úú nadinguaⁿ'áí 'iiⁿ'yāⁿ chi nindáí ndúúcū nuūⁿndī yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Taachí Jesús miiⁿ 'āā canéé niiⁿnúⁿ yā na yáāⁿ Jerusalén, 'iiⁿ'yāⁿ chí ch'iindiveéⁿ yā chuū nadicádíínuuⁿ yā chí 'āā maáⁿ nūuⁿ ndaá naachi Ndyuūs ngaⁿ'a ntiiⁿnyuⁿ yā. Tuu'mi ní Jesús miiⁿ ní caⁿ'a yā 'áámá ejemplo. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Áámá saⁿ'ā chí n'dai chí yeⁿ'e familia chi ngaⁿ'ā ntiiⁿnyuⁿ cueⁿ'e sa na 'aama país chí yaⁿ'ai chí cunéé sa rey yeⁿ'ē país miiⁿ. Cueⁿ'e sa ní cuayiivi nguɛɛcunée sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Taachi 'āā cháā caⁿ'ā sa, yaa'vi sa ndiichi saⁿ'ā mozos yeⁿ'ē sa ní ca'a sa 'áámá cáádí 'diiⁿnguāaⁿ 'áámá 'áámá mozo yeⁿ'ē sa. Ní caⁿ'a sa chii sa mozos: Diíⁿ nī negocio ndúúcū tuumí 'cūū nuuⁿmaⁿ neⁿ'e chí caⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'Iiⁿ'yāⁿ yeⁿ'e país chí yaⁿ'ai nguɛ́ɛ́ neⁿ'e yā saⁿ'a miiⁿ ní nguɛ́ɛ́ neⁿ'é yā chi cuuví rey yeⁿ'é yā saⁿ'ā. Dichó'o yā n'duuvi 'iiⁿ'yāⁿ chí caaⁿ'maⁿ ya 'túúcā: Nguɛ́ɛ́ neⁿ'e 'nū chí saⁿ'á 'cūū ní cúuví sá rey yeⁿ'ē nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Saⁿ'ā miiⁿ chi rey chi ngaⁿ'a ntiiⁿnyúⁿ yā cueⁿ'e yā ní nguɛɛcunée yā ndāā yā na vaacu yā. Dichó'o sa 'iiⁿ'yāⁿ chi yaa'ví yā mozos chí ca'a sa tuumī miiⁿ chí ndaa sa nanáaⁿ yā ní cuuvi cadíínuuⁿ yā, ¿'áá n'deēe daiyā tuumi ndaacá 'aama 'aama yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ndaa saⁿ'ā chi vmnááⁿ vmnaaⁿ ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ: N'diī, señor, yeⁿ'e 'aama caadi 'dííⁿnguāaⁿ yeⁿ'e nī, daiya túumī miiⁿ diiⁿ ganar ndiichi caadi 'dííⁿnguāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Iiⁿ'yāⁿ 'cuiica miiⁿ ní caⁿ'a yā chii yā mozo miiⁿ: Díí, n'daacā idiiⁿ di; ní díí 'áámá mozo chi n'dai. Tan'dúúcā chi n'daacā chí diīⁿ di ndúúcū chi 'tɛ́ɛ́ chi teé dii maaⁿ ní díí ní caaⁿ'maⁿ ntiiⁿnyuⁿ di yeⁿ'ē ndiichi yáāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Cuayiivi ndaā táámá sá ní caⁿ'ā sa: N'diī, señor, yeⁿ'e 'aama caadi 'dííⁿnguāaⁿ yeⁿ'e nī, daiya tuūmī miiⁿ diiⁿ ganar nyuⁿ'u cáádí 'dííⁿnguāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Tuu'mi ní caⁿ'a 'iiⁿ'yāⁿ 'cuiica miiⁿ chii yā mozo 'cūū: 'Tiicá ntuūⁿ dii ní caaⁿ'maⁿ ntiiⁿnyuⁿ di yeⁿ'ē nyuⁿ'u yáāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ndaā táámá mozo ní caⁿ'ā sa chii sa 'iiⁿ'yāⁿ 'cuiica miiⁿ: N'diī, señor, ingáā tuumī yeⁿ'e nī chí cachiīchí na pañuelo ní chi'neeⁿ n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Úú ní 'va'á n'diī ti neené chɛɛchí n'diī chí nanguai nī cosas naachi nguɛ́ɛ́ idiíⁿ nī ntiiⁿnyuⁿ ní ndúúcū tuūmī yeⁿ'é nī diíⁿ nī cosechar naachi nguɛ́ɛ́ niiⁿnuⁿ nī ti yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tuu'mi ní 'iiⁿ'yāⁿ 'cuiica miiⁿ caⁿ'a yā chii yā mozo miiⁿ: Díí, mozo chi nguɛ́ɛ́ n'daacā idiiⁿ di, cáávā nduudu chi ngaⁿ'a di canee di condenado. Dii ní déénu di chi chɛɛ̄chi 'úú ní nanangaáⁿ chi nguɛ́ɛ́ yeⁿ'é ni idiíⁿ cosechar chi nguɛ́ɛ́ diíⁿ ntiiⁿnyuⁿ ti yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ s'nuūⁿ di tuūmī yeⁿ'é na banco? Maaⁿ níícú taachi nindaá ni cuta'á tuūmī yeⁿ'é ndúúcū daiya. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tuu'mi ní 'iiⁿ'yāⁿ 'cuiica caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chi snée yā miiⁿ: Divíi nī tuūmī yeⁿ'ē sa ní ca'á nī saⁿ'a chi vɛ́ɛ́ n'diichí caadi 'dííⁿnguāaⁿ yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: N'diī, señor, saⁿ'ā miiⁿ ní 'āā vɛ́ɛ́ ndiichi cáádí 'dííⁿnguāaⁿ yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Iiⁿ'yāⁿ 'cuiica nan'guɛɛcútaⁿ'a yā ní caⁿ'a yā: 'Úú ní ngaⁿ'á ngií ndís'tiī chi 'iiⁿ'yāⁿ chi vɛ́ɛ́ yeⁿ'e yā cuta'a cá yā chi cuuvi yeⁿ'e yā naati 'iiⁿ'yāⁿ chi dúú'vī vɛɛ yeⁿ'e yā 'tɛ́ɛ́ chí vɛ́ɛ́ yeⁿ'e yā ní 'iiⁿ'yāⁿ ndivíi yā yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Tiicá ntúūⁿ, 'iiⁿ'yāⁿ chi nguɛ́ɛ́ neⁿ'e n'diichí yā chi táaⁿ yā nduucú, ní nguɛ́ɛ́ neⁿ'e yā chi 'úú cuuvi rey yeⁿ'e yā, tuu'mi ní candɛ́ɛ nī 'iiⁿ'yāⁿ s'eeⁿ nanaáⁿ 'muuⁿ ní 'caaⁿ'nuⁿ nī 'iiⁿ'yāⁿ 'muuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ch'íínú caⁿ'a yā chuū, Jesús cueⁿ'e yā cuááⁿ vmnaaⁿ ní cueⁿ'é yā ní ndaa yā na yáāⁿ Jerusalén. Cuayiivi cueⁿ'e ntúūⁿ discípulos yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Taachí ndaā niiⁿnúⁿ yā yeⁿ'e yáāⁿ Betfagé ndúúcū yáāⁿ Betania niiⁿnuúⁿ naachi canee yiīcū chi nguuvi Olivos, tuu'mi ní Jesús dichó'o yā ná 'uūvī discípulos yeⁿ'e yā vmnaaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ní Jesús caⁿ'a 'túúcā: Cueⁿ'e nī na yáāⁿ 'lííⁿ chi canéé niiⁿnuúⁿ ní taachí cundaá nī yáāⁿ miiⁿ nndaacá nī 'áámá burro 'lííⁿ chí n'dɛ́ɛ́chiichí tī. Mar 'áámá 'iiⁿ'yāⁿ 'āā cuɛ́ɛ́ cunduú yā 'iiti. N'daatí nī 'iiti ní candɛ́ɛ nī 'iiti 'muuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ní nduuti chi 'áámá 'iiⁿ'yāⁿ tiinguuneeⁿ yā 'túúcā: Ndís'tiī, ¿dɛ'ɛ̄ cúúví chí n'daatí nī 'iiti? 'Túúcā nan'guɛɛcútaⁿ'a nī chi Señor yeⁿ'e yú ní neⁿ'e yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Discípulos chi dicho'ó Jesús cueⁿ'e yā ní ndaāca yā 'iiti tan'dúúcā chi Jesús miiⁿ caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Taachí n'daātí yā burro 'lííⁿ miiⁿ, 'iiví tī ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí in'daatí nī burro 'lííⁿ yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ní 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Señor yeⁿ'e yú ní neⁿ'e yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tuu'mi ní candɛ́ɛ yā 'iiti nanááⁿ Jesús. 'Iiⁿ'yāⁿ s'eeⁿ sn'dúu yā cotón yeⁿ'e yā vmnááⁿ yeⁿ'e tī ní Jesús canduú yā 'iiti miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ní taachí Jesús cho'ó yā cyúúní miiⁿ, 'iiⁿ'yāⁿ s'uuⁿ ní n'doo yā cotón yeⁿ'e yā cuaaⁿ cyúúní mííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Taachí Jesús ndaa niiⁿnúⁿ yā naachi nga'áí yúúní mííⁿ yeⁿ'ē yiīcū chí nguuvi Olivos, nducyáácá discípulos yeⁿ'e yā ní yeenú taavi yā. Ní tuca'á yā caⁿ'a yā chi ch'ɛɛtɛ n'dai Ndyuūs cucáávā chi vaadī n'giinu chi n'diichí yā chi Jesús diíⁿ yā. Níícú diītūu n'dai 'cai yā ti yeenu taaví yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ní 'cai yā: Dɛ'ɛ̄ chúúcā n'dai Rey chí cuchii yā ndúúcū chi duuchi Señor Ndyuūs. Ní cuneé vaadī 'diīiⁿ ná va'ai chɛɛti nguuvi. Ní caⁿ'á yā ndúúcū vaadī yeenú. Dɛ'ɛ̄ ch'ɛɛtɛ ca n'dai Ndyuūs chi dɛɛvɛ́ n'daí yā ndúúcū poder yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tuu'mi ní n'duuvi 'iiⁿ'yāⁿ fariseos chi snée yā nguaaⁿ 'iiⁿ'yāⁿ caⁿ'a yā chii yā Jesús miiⁿ: N'diī, Maestro, yaa'vi neeⁿ 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ caaⁿ'maⁿ yā tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús miiⁿ ní nán'guɛɛcútaⁿ'a yā yeⁿ'e fariseos ní caⁿ'a yā: Ndúúti chi 'iiⁿ'yāⁿ s'uuⁿ ní 'tíícā nguɛ́ɛ́ caaⁿ'maⁿ yā, tuu'mi ní tuūu miiⁿ ní caaⁿ'maⁿ 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Taachí ndaa niiⁿnúⁿ yā chí n'diichí yā yáāⁿ Jerusalén miiⁿ, tuu'mi ní Jesús chɛɛcú yā cucáávā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ ti ya'ai 'iinu yā caavā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ní caⁿ'a yā 'túúcā: Ndís'tiī, 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén, nduuti chi incheenaáⁿ nī yeⁿ'ē nguuví 'cūū chi cuuvi nanguaⁿ'ai nī tuu'mi ní 'úú cuuví teé ndís'tiī vaadī 'diīíⁿ. Naati maaⁿ ní Ndyuūs canuuⁿ n'de'éí yā yeⁿ'e nī ní nguɛ́ɛ́ cuuvi deenu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ti ndaá nguuvi taachí 'iiⁿ'yāⁿ chi taaⁿ ndúúcu nī chééndii yā núúⁿmáⁿ 'diituú yáāⁿ yeⁿ'e nī ní nguɛ́ɛ́ cuuví cáánu nī yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ní diíⁿ yā chi cundɛɛ nī ti nguɛɛ cuchɛɛ́ nī ndúúcu yā. Ní 'caaⁿ'núⁿ yā nducyaaca ndís'tiī ndúúcū daiyá nī, ní dituuví yā yáāⁿ Jerusalén yeⁿ'e nī ti 'iiⁿ'yāⁿ nguɛ́ɛ́ deenu yā chi tiempo maaⁿ ní nguuvi chi Ndyuūs s'neéⁿ yā chi cuuvi nanguaⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tuu'mi ní Jesús sndaá yā na yaācū templo ní tucá'a yā tun'dáa yā nducyaaca 'iiⁿ'yāⁿ chi in'diicui yā ní ngái ntúuⁿ yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Túúcā canéé nguūⁿ na libro yeⁿ'é Ndyuūs: Yáacū yeⁿ'é ní naachi caaⁿ'maⁿngua'a 'iiⁿ'yāⁿ naati ndís'tiī ní diíⁿ nī tan'dúúcā chi yiivɛ yaava yeⁿ'ē 'iiⁿ'yāⁿ chí diduucu. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús miiⁿ nguuvi nguuvi ngi'cueeⁿ yā ná yáacū templo; naati 'iiⁿ'yāⁿ chiiduú n'gɛɛtɛ́, ndúúcū 'iiⁿ'yāⁿ chi ngi'cueeⁿ ley, ndúúcū 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yáāⁿ miiⁿ nduuvidaamá yā ti neⁿ'é yā n'diichí yā táácā chi cuuvi 'caaⁿ'núⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Nguɛ́ɛ́ indaacá yā táácā chi 'caaⁿ'núⁿ yā Jesús, ti nducyáácá 'iiⁿ'yāⁿ s'nee veeⁿ n'daacá yā yeⁿ'ē chi ngí'cueeⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Áámá nguuvi taachí Jesús miiⁿ ngí'cueeⁿ yā chɛɛti yaācū templo ní ngi'cueeⁿ yā nduudu chí ngai yeⁿ'e Ndyuūs, ndaā nanááⁿ Jesús miiⁿ chiiduú n'gɛɛtɛ́ ndúúcū maestros yeⁿ'e ley, ndúúcū 'iiⁿ'yāⁿ ndiicúū chí ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ní ntiinguunéeⁿ yā Jesús: ¿Du'ú caⁿ'a ntiiⁿnyuⁿ chi ca'cueeⁿ nī déndu'ū chi 'tuucā? O ¿du'ú 'iiⁿntyéⁿ'ē tee yā orden chi diíⁿ ni 'tíícā? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tuu'mi ní Jesús miiⁿ nan'guɛɛcútaⁿ'a yā: 'Úú ntúūⁿ ní ntiinguuneéⁿ 'áámá ndís'tiī. Nan'guɛɛcútaⁿ'a nī yeⁿ'é: ");
INSERT INTO cuxNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Dú'u ca'a orden Juan chi chɛɛdínuūⁿniⁿ yā 'iiⁿ'yāⁿ? ¿'Áá yeⁿ'e Ndyuūs o saⁿ'a iⁿ'yeeⁿdí 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","'Iiⁿ'yāⁿ s'eeⁿ nduuvidaamá yā ní caⁿ'a yā nguaaⁿ maaⁿ yā: Ndúúti chi caaⁿ'maⁿ yú chí yeⁿ'e Ndyuūs, Jesús miiⁿ ní cuuvi yā s'uūúⁿ: ¿Dɛ'ɛ̄ cuuvi chi nguɛ́ɛ́ chi'téénu nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nduuti chí caaⁿ'maⁿ yú chí yeⁿ'e saⁿ'ā íⁿ'yeeⁿdí 'cūū, nducyaaca 'iiⁿ'yāⁿ ní cuiituú yā s'uūuⁿ ti 'iiⁿ'yāⁿ s'eeⁿ nadicádíínuuⁿ yā chi cuaacu nííⁿnyúⁿ Juan miiⁿ ní 'áámá profeta chi Ndyuūs dicho'ó yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ nan'guɛɛcútaⁿ'a yā yeⁿ'e Jesús chi nguɛ́ɛ́ déénu yā tií ndiicá yeⁿ'ē chí ngɛɛdínuūⁿnīⁿ Juan miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndíí nguɛ́ɛ́ ndúú 'úú ra cuuví ndís'tiī du'u 'iiⁿntyéⁿ'ē tee yā orden 'úú chí idiíⁿ chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús tucá'a yā caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ 'áámá ejemplo chi 'tɛ́ɛ́ nguɛ́ɛ́ dáámá: 'Áámá saⁿ'ā chiīnū sa díí'yú uvas ná yáⁿ'āa yeⁿ'ē sa. Dueño miiⁿ ca'a yā n'duuvi saⁿ'ā chi idiiⁿ sa ntiiⁿnyuⁿ ní nadíí'vɛ yā saⁿ'ā. Ní chiica yā yáāⁿ vaacú yā ni cueⁿ'e yā chí cuuvi 'náaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Taachí ndaā tiempo yeⁿ'e cosecha yeⁿ'e uvas miiⁿ, dueño miiⁿ dichó'o yā 'aama mozo yeⁿ'é yā chi cueⁿ'e sa cuta'a sa parte yeⁿ'e cosecha chi tuneeⁿ dueño miiⁿ. 'Iiⁿ'yāⁿ chí idiiⁿ ntiiⁿnyuⁿ yeⁿ'e yáⁿ'āa ch'eⁿ'é yā mozo ní nadichó'o yā mozo miiⁿ. Ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ ca'a yā mozo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dueño nguɛɛcunée yā dichó'o yā táámá mozo nanááⁿ saⁿ'ā chi idiiⁿ ntiiⁿnyuⁿ na yáⁿ'āa yeⁿ'e yā. 'Tiicá ntúūⁿ nguɛ́ɛ́ n'daacā diiⁿ sa ndúúcū mozo miiⁿ. Ch'éⁿ'é sa saⁿ'a ní nadicáánu sa saⁿ'ā miiⁿ. Ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ ca'a sa saⁿ'ā mozo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dueño yeⁿ'e yáⁿ'āa miiⁿ nguɛɛcunéé ntúuⁿ yā dicho'ó yā táámá mozo nanááⁿ 'iiⁿ'yāⁿ chi idiiⁿ ntiiⁿnyuⁿ na yáⁿ'āa yeⁿ'e yā naati 'nuucá'a sa saⁿ'a ní nadicaanu sa saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tuu'mī ní dueño yeⁿ'e yáⁿ'āa miiⁿ caⁿ'a yā: ¿Táácā diíⁿ? Dicho'ó saⁿ'ā daiyá chi neⁿ'e taaví. ¿'Áá nguɛ́ɛ́ taachí snaaⁿ sa saⁿ'ā diiⁿ sa honrar saⁿ'ā daiyá? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Iiⁿ'yāⁿ chi idiiⁿ ntiiⁿnyuⁿ na yáⁿ'āa miiⁿ taachí n'diichi sa saⁿ'ā daiya dueño yeⁿ'e yáⁿ'āa miiⁿ nadicádiinuuⁿ sa ní caⁿ'a sa chii sa vi'ī: Sáⁿ'a 'cuu chi cuuví yeⁿ'ē sa yáⁿ'āa 'cūū. 'Caāⁿ'nuⁿ yú saⁿ'ā ni yáⁿ'āa ndúúcū chi vɛ́ɛ́ naaⁿ cuuvi yeⁿ'e yú. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tuu'mí tun'dáa sa saⁿ'ā daiya dueño 'áámá lado yeⁿ'e chéeⁿ yeⁿ'e díí'yú uvas ní ch'iiⁿ'nuⁿ sa saⁿ'ā. Jesús caⁿ'a yā: Maaⁿ ní, ¿dɛ'ɛ̄ diíⁿ dueño yeⁿ'e yáⁿ'āa nduucú saⁿ'ā s'eeⁿ chi diiⁿ 'tíícā? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Dueño miiⁿ taachi ndaa yā ni divíi yā saⁿ'ā chi idiiⁿ ntiiⁿnyuⁿ na yáⁿ'āa yeⁿ'é yā ní 'caaⁿ'núⁿ yā saⁿ'ā s'eeⁿ. Ní ca'á yā yáⁿ'āa miiⁿ yeⁿ'e yā táámá 'iiⁿ'yāⁿ. Taachí 'iiⁿ'yāⁿ fariseos ch'iindiveéⁿ yā chuū, tuu'mi ní caⁿ'a yā: N'daacā chi Ndyuūs nguɛ́ɛ́ 'cuaaⁿ yā chi 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús ch'iinú yā 'iiⁿ'yāⁿ s'eeⁿ, ní caⁿ'a yā: ¿Dɛ'ɛ̄ neⁿ'e caaⁿ'maⁿ nduudu chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs chi 'tuucā? Tuūu ch'ɛɛtɛ́ chí 'iiⁿ'yāⁿ chi din'dái yā va'āī miiⁿ ní sta'á yā ní ch'ɛɛ̄cú yā 'áámá lado, ní tuūu 'cúū chí tuūu ch'ɛɛtɛ miiⁿ dichíí'vɛ ca ní canéé tuūu ch'ɛɛtɛ́ yeⁿ'e esquina yeⁿ'e va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","'Āā du'ú nūuⁿ 'iiⁿ'yāⁿ chí cun'daa nduú yā vmnaaⁿ na tuūu 'cúū ní caātū 'ííní yeⁿ'e yā. Naati 'āā du'ú nūuⁿ 'iiⁿ'yāⁿ chi cun'dáá nduūu tuūu 'cúū vmnaaⁿ yeⁿ'e yā, 'cuíínú ndúúví yuūni yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","'Iiⁿ'yāⁿ chiiduú n'gɛɛtɛ́ ndúúcū maestros yeⁿ'e ley neⁿ'é yā cuta'á yā Jesús ní diíⁿ yā chi preso yā naati di'va'a yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ. Tuu'mí nūuⁿ tuumicádiinuuⁿ yā chi Jesús miiⁿ caⁿ'a yā ejemplo 'cūū chi 'tɛ́ɛ́ nguɛ́ɛ́ dáámá ní yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tuu'mi ní dichó'o yā 'iiⁿ'yāⁿ chí 'cueenuúⁿ Jesús miiⁿ. 'Iiⁿ'yāⁿ s'eeⁿ ní ndaacá yā táácā chi cástaⁿ'a yā nduudu Jesús miiⁿ chi Jesús cuuví caaⁿ'máⁿ yā 'aama nduudu yaadi. 'Tíícā ní cuuvi dichó'o yā Jesús nanááⁿ gobernador. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Chiiⁿ chí 'iiⁿ'yāⁿ s'eeⁿ ní ntiinguunéeⁿ yā Jesús nduudú 'cūū: N'dií, maestro, déénu 'nū chí ngaⁿ'a nī ní ngi'cueeⁿ nī chiiⁿ chi n'daacā. Ní nguɛ́ɛ́ diíⁿ nī juzgar 'iiⁿ'yāⁿ tan'dúúcā chi n'gee nī chi n'daacā o nguɛ́ɛ́, naati ngi'cueeⁿ nī yúúní yeⁿ'e Ndyuūs ndúúcū nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Maaⁿ ní cuuví nī chuū: ¿'Áá n'daacā chí nadíí'vɛ 'nū emperador César tuūmī yeⁿ'e yáⁿ'āa o nguɛ́ɛ́? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús tuumicadíínuuⁿ yā chí 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ n'daacā chi diíⁿ yā ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí neⁿ'e nī castaⁿ'á nī nduudu yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","'Cuuⁿ'miⁿ nī 'áámá tuumī. Jesús n'diichí yā tuūmī ní caⁿ'a yā: ¿Du'ū naaⁿ ndɛ́ɛ̄ tuūmī miiⁿ? ¿Du'ū chi nguuví canee ngúūⁿ naaⁿ? Tuu'mi ní saⁿ'a s'uuⁿ nan'guɛɛcútaⁿ'ā sa: Naaⁿ emperador César cānee. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Nca'a nī tuūmī emperador César miiⁿ chííⁿ chi yeⁿ'é yā ní ca'á nī Ndyuūs chííⁿ chi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Nguɛ́ɛ́ cuuvi diíⁿ yā chistaⁿ'a mar 'áámá nduudu yeⁿ'e Jesús miiⁿ ní cheⁿ'e yiinú yā yeⁿ'ē chí nan'guɛɛcútaⁿ'ā Jesús. Ní 'āā ntɛ́ɛ́ caⁿ'a yā mar 'áámá. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Cuayiivi ní n'duuvi 'iiⁿ'yāⁿ saduceos ndaa yā nanááⁿ Jesús. Saduceos nguɛ́ɛ́ s'téénu yā chí nduuchi tináⁿ'ā. Ní caⁿ'a yā chii yā Jesús: ");
INSERT INTO cuxNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","N'dií, Maestro, Moisés dingúuⁿ yā na ley 'tíícā: Ndúúti chi 'áámá saⁿ'ā 'cuuvi sa ní cu'neeⁿ sa n'daataá yeⁿ'ē sa ní nguɛ́ɛ́ daiya tá, tuu'mi ní 'díínu sa cuuvi 'caandavaacu sa ndúúcū n'daataá miiⁿ ní 'cuundi daiya sa lado yeⁿ'e 'díinū tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maaⁿ ní vɛ́ɛ́ ndɛɛ̄chɛ̄ 'díínu yā. Saⁿ'ā vmnaaⁿ mííⁿ canee sa ndúúcū n'daataá yeⁿ'ē sa ní ch'īi sa. Nguɛ́ɛ́ ch'ɛɛtinéé daiya sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Saⁿ'ā 'díínu sa ndiichi ndii 'úúví canee sá ndúúcū n'daataá yeⁿ'ē tináⁿ'ā. 'Diinu sa miiⁿ ch'iī ntúūⁿ saⁿ'ā miiⁿ. Nguɛ́ɛ́ ch'ɛɛtinée ntuūⁿ daiya sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Saⁿ'ā 'diīnū sa ndiichi ndii 'íínú canéé ntúuⁿ sa ndúúcū n'daataá mííⁿ. 'Tiicá ntúūⁿ ch'īi sa ní nguɛ́ɛ́ ch'ɛɛtinée ntúūⁿ daiya sa. Nduu ndɛɛ̄chɛ yā ch'ɛɛtinée yā ndúúcū n'daataá mííⁿ ní ca'áámá ca'áámá yā ch'īi yā ní nguɛ́ɛ́ ch'ɛɛtinéé mar 'áámá daiya yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cuayiivi miiⁿ ní ch'iī n'daataá mííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Taachí ndaā nguuvi chi nduuchi 'iiⁿ'yāⁿ chi n'díí, ¿chɛɛ́ saⁿ'ā s'eeⁿ n'daataá yeⁿ'ē sa táⁿ'ā? Tí nduu ndɛɛ̄chɛ yā ch'ɛɛtinée yā ndúúcū n'daataá mííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tuu'mi ní Jesús miiⁿ nan'guɛ́ɛ́cútaⁿ'a yā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: 'Iiⁿ'yāⁿ chi snée yā iⁿ'yeeⁿdí 'cūū n'giindivaacu yā ní 'iiⁿ'yāⁿ yeⁿ'e yā nga'a yā chi n'gíindivaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'Iiⁿ'yāⁿ chi túneeⁿ chi ndaá yā na táámá iⁿ'yeēⁿdī, taachi nduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā, na yáⁿ'āa miiⁿya ní nguɛɛ 'caandavaacu yā, ndíí nguɛ́ɛ́ ndúú chi ca'a 'iiⁿ'yāⁿ yeⁿ'e yā chi 'caandavaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yáⁿ'āa miiⁿya 'āā ntɛ́ɛ́ 'cuūvi yā ti daama yā ndúúcū ángeles. 'Iiⁿ'yāⁿ s'eeⁿ chi daiya Ndyuūs tí induuchi yā yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ndíí cuaaⁿ vmnaaⁿ ndíí taachi maaⁿ Moisés miiⁿ dingúuⁿ yā yeⁿ'ē yáⁿ'á 'lííⁿ chí ngiichi iteé cadíínuuⁿ yú caati tináⁿ'ā ninduuchi yā. Ní Moisés miiⁿ ngaⁿ'á yā chi Señor Ndyuūs miiⁿ ní Ndyuūs yeⁿ'e Abraham, ndúúcū Isaac, ndúúcū Jacob. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti Ndyuūs ní nguɛ́ɛ́ Ndyuūs yeⁿ'e tináⁿ'ā ti yeⁿ'e 'iiⁿ'yāⁿ chí snduuchí yā. Caati nanááⁿ Ndyuūs miiⁿ nducyaaca 'iiⁿ'yāⁿ ní snduuchí yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tuu'mi ní n'duuvi maestros chi ngi'cueeⁿ ley caⁿ'a yā chii yā Jesús miiⁿ: N'dií, Maestro, n'daacā ngaⁿ'a nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Iiⁿ'yāⁿ s'eeⁿ 'āā ntɛ́ɛ́ neⁿ'e yā ntiinguuneeⁿ ca yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī, ¿táácā chí ngaⁿ'a nī chi Cristo miiⁿ ní daiya David? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Maāⁿ David miiⁿ ní ngaⁿ'a yā na libro yeⁿ'é Ndyuūs chi Salmos 'túúcā: Caⁿ'a Señor Ndyuūs chiī yā Señor yeⁿ'é: 'Cuundi di lado tá cuaācū yeⁿ'é chi lado yeⁿ'e honor, ");
INSERT INTO cuxNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ndíí taachi 'úú cu'neéⁿ 'iiⁿ'yāⁿ chi enemigos chi contra yeⁿ'ē di cuaaⁿ ndii yā ca'a di tan'dúúcā chi 'aama banco 'lííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ndúúti chi David miiⁿ caⁿ'a yā chi Cristo miiⁿ ní Señor yeⁿ'e yā, ¿táácā cuuvi chiī chi Cristo miiⁿ ní daiya David? ");
INSERT INTO cuxNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nducyáácá 'iiⁿ'yāⁿ n'giindiveéⁿ yā taachi Jesús caⁿ'a yā ndúúcū discípulos yeⁿ'e yā ní tuca'á yā caⁿ'a yā chuū: ");
INSERT INTO cuxNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Diíⁿ nī cuidado, ndís'tiī, yeⁿ'é maestros chi ngi'cueeⁿ ley. 'Iiⁿ'yāⁿ s'eeⁿ ní neⁿ'e yā 'cuɛɛti núuⁿ yā catecai n'geēnúú yā, ní neⁿ'e yā chi ndís'tiī ní diíⁿ nī saludar 'iiⁿ'yāⁿ s'eeⁿ taachi snée yā nii'vɛɛ ní neⁿ'é yā chi diíⁿ nī respetar 'iiⁿ'yāⁿ s'eeⁿ. Ní neⁿ'e yā 'cuɛɛtɛ́ yā na sillas vmnááⁿ vmnaaⁿ yeⁿ'ē honor ná yaacū sinagogas ní sillas yeⁿ'e honor yeⁿ'e 'viicu naachi ché'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'Iiⁿ'yāⁿ s'eeⁿ ní ndivíi yā va'ai yeⁿ'e n'daataá nguá'āa. Ní nééné n'deēe ngaⁿ'angua'á yā ní neⁿ'e yā chi snaaⁿ tanáⁿ'ā 'iiⁿ'yāⁿ chi diiⁿ yā 'tíícā. 'Iiⁿ'yāⁿ s'eeⁿ ní neene ch'ɛɛtɛ ca castigo yeⁿ'e yā nguuvi yeⁿ'e juicio. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús snée yā na yaācu templo ní n'diichi yā chi 'iiⁿ'yāⁿ 'cuiica ngii yā ofrendas yeⁿ'e yā na cajas naachí inúūⁿ ofrendas. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","N'diichí ntúuⁿ yā 'áámá n'daataá nguá'āa chí neene ndaachíí cānee tá. Táⁿ'ā miiⁿ ní s'nuūⁿ tá chɛɛti caja miiⁿ 'uūvī centavos chi cobre. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús miiⁿ ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuaacu nííⁿnyuⁿ 'úú ngaⁿ'á ngií ndís'tiī chí n'daataá nguá'āa 'cūū ch'ɛɛtɛ ca tuūmī chiī tá, nguɛ́ɛ́ ti tanáⁿ'ā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tí 'iiⁿ'yāⁿ s'eeⁿ ní nga'a yā yeⁿ'ē chí nngaāva yeⁿ'e yā chi cuuvi ofrenda yeⁿ'e Ndyuūs; naati n'daataá 'cūū chí neené ndaachíī canee tá ní ca'ā tá tanducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'e ta chi che'e tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Náⁿ'ā 'iiⁿ'yāⁿ ní ngaⁿ'a yā yeⁿ'e yaācū templo miiⁿ chi yaāva canéé ndúúcū tuūu n'dɛɛ̄ cheeⁿ ndúúcū adornos yeⁿ'ē regalos chí lado yeⁿ'e ofrenda. Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ");
INSERT INTO cuxNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ndís'tiī ní inaaⁿ nī dendú'ū chi 'túúcā. Ndáá nguuvi taachí nadituuví yā yaācū miiⁿ ní 'āā ntɛ́ɛ́ cūnee tuūu cuaaⁿ vmnááⁿ yeⁿ'e vi'ī chi nguɛ́ɛ́ ntuuvií. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ntiinguunéeⁿ yā Jesús miiⁿ: N'diī, Maestro, ¿tií cuaⁿ'ā cuuví chuū? ¿Dɛ'ɛ̄ señal 'cuuⁿ'míⁿ nī taachi 'āā cuuvi chi 'tiicā? ");
INSERT INTO cuxNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús caⁿ'a yā: Cundɛ́ɛ nī cuidado chi 'iiⁿ'yāⁿ nguɛ́ɛ́ cannche'éí yā ndís'tiī caati neené n'deēe 'iiⁿ'yāⁿ chií yā caaⁿ'máⁿ yā ndúúcū chi duuchí 'tííca: 'Úú chí Cristo; ní 'āā snéé nguuvi chi 'cuiīnū íⁿ'yeēⁿdī. Naati ndís'tiī, nguɛ́ɛ́ caⁿ'á nī ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ní taachí 'caandiveéⁿ nī chi vɛɛ caandaá ní 'iiⁿ'yāⁿ 'cuuⁿ'maⁿ yā contra yeⁿ'e taama yā nguɛ́ɛ́ dii'yá nī cuuvi. Tanducuéⁿ'ē chuū canéé chí cuuvi vmnááⁿ vmnaaⁿ naati 'āā cuɛɛ 'cuiīnū iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tuu'mi ní Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Áámá nación ní 'cuuⁿ'máⁿ contra yeⁿ'e taama nación ní 'iiⁿ'yāⁿ yeⁿ'e 'áámá país ní 'cuuⁿ'máⁿ yā contra yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e taama país. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ní n'deēe cuuvi nuⁿ'u taaⁿ yáⁿ'āa, ndúúcū tiempos chi 'cuūndī cuiicu, ndúúcū ca'ai taaⁿ n'deēe cuaaⁿ n'dai, ní 'iiⁿ'yāⁿ snaaⁿ yā dendu'ū chí vaadī n'giinu yeⁿ'ē va'ai chɛɛti nguuvi ní dii'yá yā cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ni taachi 'āā cuɛ́ɛ́ cuuvi tanducuéⁿ'ē dendu'ū chi 'túúcā, 'iiⁿ'yāⁿ ní cuiítuú yā ndís'tiī ní cuta'á yā ndís'tiī chí presos nī. Ní nca'á yā ndís'tiī 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yaācū sinagogas ní 'cuii yā ndís'tiī vácūū. Cuayiivi ní candɛ́ɛ yā ndís'tiī nanááⁿ 'iiⁿ'yāⁿ reyes ndúúcū gobernadores cáávā chí ngaⁿ'a nī chí duuchí. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chuū 'cueenu ndís'tiī cuuvi ti cueⁿ'é nī nduucú ní nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ cuuvi caaⁿ'máⁿ nī nduudu cuaacu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Cundɛ́ɛ n'daaca nī cuidado ná staava yeⁿ'e nī ní nguɛ́ɛ́ nadacádíínuuⁿ nī vmnaaⁿ yeⁿ'e taācā nán'guɛɛcútaⁿ'a nī yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ti hora mííⁿ nūuⁿ 'úú ní yaa'ví ndís'tiī nduudu chi caaⁿ'máⁿ nī. Ní teé ndís'tiī vaadī deenu yeⁿ'é ní 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ cuchɛɛ yā ndúúcū ndís'tiī, ndíí nguɛ́ɛ́ ndúú cuuvi caaⁿ'maⁿ yā contra yeⁿ'ē ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Naati chiidá nī, ndúúcū 'díínu nī, ndúúcū 'iiⁿ'yāⁿ yeⁿ'e nī, ndúúcū amigos yeⁿ'e nī ní caaⁿ'máⁿ yā contra yeⁿ'e ndís'tiī chí 'iiⁿ'yāⁿ 'caaⁿ'núⁿ yā náⁿ'ā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ní nducyaaca 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi n'diichí yā ndís'tiī cucáávā 'úú ti cueⁿ'é nī nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naati mar 'áámá yuūdū tiíⁿ nī nguɛ́ɛ́ cuuví ndáí. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nduuti chí ndís'tiī ngiinū ngiinū cuchɛ́ɛ nī na staava yeⁿ'é nī ní 'cuɛɛtinéé n'daāca nī, tuu'mi ní ndáá nguuvi chi ndaaca nī vida cueⁿ'e daāⁿmaⁿ yeⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Taachi ndís'tiī snaaⁿ nī soldados nuuⁿmaⁿ ndííví yā yáāⁿ Jerusalén, tuu'mi ní cadiinuuⁿ nī chi yáāⁿ Jerusalén miiⁿ 'āā ntuvií. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tuu'mi ní n'daacā chi 'iiⁿ'yāⁿ chi snée yā na yáⁿ'āa Judea caⁿ'á yā cáánu yā cuaáⁿ yiīcū. Ní 'iiⁿ'yāⁿ chi snée yā na yáāⁿ Jerusalén miiⁿ ní nan'dáa yā miiⁿ. Ní 'iiⁿ'yāⁿ chi snée yā campo nguɛ́ɛ́ nguɛɛcunee nndaa yā na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ti nguuvi s'eeⁿ ní nguuví chí cuchiī 'cueenú yā cuuvi cáávā nuuⁿndí yā. Níícú canéé chí cuuvi cuaacu tanducuéⁿ'ē chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Naati dɛ'ɛ̄ chúúcā ya'āī yeⁿ'e n'daataá chi vɛ́ɛ́ daiya tá chɛɛti tá ndúúcū n'daataá chí ngiicú da'cua'āa daiya tá nguuvi chi cáánu yā. Ní 'iiⁿ'yāⁿ miiⁿ nééné 'cueenu yā cuuvi na yáⁿ'āa 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ní 'yááⁿ 'iiⁿ'yāⁿ ní 'cuūvi yā ndúúcū machete 'uūvī lados 'caāiⁿ taachi diíⁿ yā caandaá. Ní candɛɛ yā 'yaaⁿ 'iiⁿ'yāⁿ chi presos yā ní caⁿ'á yā ndíí nducyaaca países. Níícú yáāⁿ Jerusalén miiⁿ cūnee ndúúcū 'iiⁿ'yāⁿ gentiles chi 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'ē ndaata Israel ní 'iiⁿ'yāⁿ s'eeⁿ canéé yā na yáⁿ'āa miiⁿ ndíí tiempo chi Ndyuūs 'cuaaⁿ yā 'iiⁿ'yāⁿ gentiles cuuvi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tuu'mi ní Ndyuūs 'cuuⁿ'miⁿ yā ndúúcū vaadī n'giinu señales ná yáⁿ'āa, ndúúcū ná 'ii'yu, ndúúcū na 'ííⁿnyúⁿ. Nééné ya'āī 'cueenu 'iiⁿ'yāⁿ yeⁿ'e tanáⁿ'ā naciones ni nducyaaca 'iiⁿ'yāⁿ dii'ya cá yā cuuvi. Ní nguɛ́ɛ́ déénu yā taacā chi idiiⁿ yā cucáávā chi 'yuudu n'dai 'cuɛɛcu nuūⁿnīⁿ'yáⁿ'ā ní can'dáí yaacu nuūⁿnīⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","'Iiⁿ'yāⁿ s'eeⁿ cuuvi cúúnu yā chí 'va'á yā ndúúcū dendu'ū chí ndaa vmnááⁿ yáⁿ'āa 'cúū ní cucáávā nducuéⁿ'ē nanguuvi ní 'nuⁿ'u. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tuu'mi ní 'iiⁿ'yāⁿ snááⁿ yā 'úú chi Saⁿ'ā chi Daiya Dendyuūs chi ndaá na 'áámá meēeⁿ ndúúcū poder ch'ɛɛtɛ yeⁿ'é ndúúcū chi dɛɛvɛ́ n'dai yeⁿ'e maáⁿ cuerpo yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Taachí cunga'ā tanducuéⁿ'ē chuū cu'neeⁿ diitú nī na staava yeⁿ'é nī tí ndaā nguuvi chí nnguaⁿ'āī ndís'tiī ní canéé niiⁿnuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Úú ní ngaⁿ'á ngií ndís'tiī 'áámá ejemplo: Cuin'diichí nī yáⁿ'á yeⁿ'e n'guíídīi yaaⁿ nguuvi ndúúcū nducyaaca yáⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Taachí snaaⁿ nī chi 'āā ndaa tá'āa yáⁿ'á mííⁿ, tuu'mi ní 'āā deenú nī ti 'āā snee niiⁿnuúⁿ tiempo chi cuchiī yáāaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'Tiicá ntúūⁿ cuuvi taachi snaaⁿ nī dendu'ū chuū chi ngaⁿ'á, 'āā deenú nī chí naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā 'āa snee niiⁿnuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Úú ngaⁿ'á ngií ndís'tiī, chi cuaacu nííⁿnyúⁿ 'iiⁿ'yāⁿ chi snée yā maaⁿ 'āā cuɛ́ɛ́ 'cuuví yā nenⁿ'e chi 'āā cuɛ́ɛ́ cuuví tanducuéⁿ'ē chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nanguuvi ndúúcū yáⁿ'āa ní chó'ōo naati nduudu yeⁿ'é nguɛ́ɛ́ chó'ōo. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Ndís'tiī ní cundɛ́ɛ nī cuidado chi staava yeⁿ'e nī nguɛ́ɛ́ nduuvi chɛɛchí ndúúcū vicios chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū. Nguɛ́ɛ́ nadicádiinúúⁿ ca nī yeⁿ'e chi che'é nī o cu'ú nī o yeⁿ'ē n'deee yeⁿ'e vida yeⁿ'e nī ti nguuvi miiⁿ ní dácanaāⁿ ndaá nanááⁿ yeⁿ'e ndís'tiī. Ní canéé chi canéé listo nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ti nguuvi s'eeⁿ ní ndaa nanááⁿ ndís'tiī ndúúcū 'iiⁿ'yāⁿ chi snée yā iⁿ'yeeⁿdí 'cūū ní nducyaacá yā ní 'cueenú yā cuuvi tí ndaā nguuvi s'eeⁿ tan'dúúcā 'áámá tuūvī dácanaāⁿ índuudi. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","'Cuɛɛti nduuchí nī ní caaⁿ'maⁿngua'á nī nguuvi nguuvi chi cuuví nnguaⁿ'ai nī yeⁿ'e dendu'ū vaadī ya'ai chi cuchiī. Ní cuuvi ndaa nī nanááⁿ 'úú, Saⁿ'ā chi Daiya Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nguuvi nguuvi Jesús miiⁿ ngí'cueeⁿ yā na yáacū templo ní n'gaaⁿ ní nn'daa yā ná yiīcū 'lííⁿ chi nguuvi Olivos. ");
INSERT INTO cuxNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ní nguuvi nguuvi cuaaⁿ ná nguɛɛtiyaaⁿ ní nducyaaca 'iiⁿ'yāⁿ ndaa yā na yaācū templo nanááⁿ Jesús miiⁿ chí 'caandiveéⁿ yā nduudu yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Āā snee niiⁿnuúⁿ nguuví yeⁿ'e 'viicu yeⁿ'e pascua chi 'viicu chi che'é yā pan chi nguɛ́ɛ́ levadura yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ní 'iiⁿ'yāⁿ chiiduú n'gɛɛtɛ́ ndúúcū maestros yeⁿ'e ley nduuvidaamá yā ní ngaⁿ'á yā taacā chi cuuví 'caaⁿ'núⁿ yā Jesús naati 'va'á yā 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Espíritu yeⁿ'e yááⁿn'guiinūuⁿ sndáa na staava yeⁿ'e saⁿ'ā chi nguuvi Judas Iscariote chi 'aama discípulo yeⁿ'e Jesús naachí ndiichuuvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas miiⁿ cheⁿ'e sa nanááⁿ chiiduú n'gɛɛtɛ́ ndúúcū capitanes ní yaa'vi sá 'iiⁿ'yāⁿ táácā chi cuuví diiⁿ sa chi naca'a sa Jesús miiⁿ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Iiⁿ'yāⁿ s'eeⁿ ní yeenú n'dai yā ní nduuvidaamá yā chí ca'a yā tuūmī Judas miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas sta'a sa tuūmī ní caⁿ'a sa. Nadacádiinuuⁿ sa táácā cuuvi nta'a sa Jesús miiⁿ na ta'a 'iiⁿ'yāⁿ s'eeⁿ manera chi 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ nguɛ́ɛ́ ntuumicadiinúúⁿ yā yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndaā nguuvi yeⁿ'e pascua, 'viicu chi nducyaaca 'iiⁿ'yāⁿ che'e yā pan chi nguɛ́ɛ́ levadura yeⁿ'ē. Nguuvi miiⁿ ní 'iiⁿ'yāⁿ 'caaⁿ'núⁿ yā 'áámá 'iiti cuūchī 'lííⁿ chí sacrificio yeⁿ'e pascua. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús dicho'ó yā Pedro miiⁿ ndúúcū Juan ní caⁿ'a yā chii yā 'uuvi yā: Cuéⁿ'é nī ní n'nuúⁿ nī naachi che'e nguiīnū yú yeⁿ'e 'viicu yeⁿ'e pascua. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā Jesús miiⁿ: ¿Tií neⁿ'e nī chi in'nuúⁿ 'nū chi che'e nguiīnū yú? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús n'guɛɛcútaⁿ'a yā: Taachí cundaa nī na yáāⁿ Jerusalén miiⁿ ndaāca nī 'áámá saⁿ'ā chi ndɛ́ɛ sa 'cuuti cuéé nuūⁿnīⁿ. Caⁿ'á nī ndúúcu sa ndíí ná va'ai naachi ndaā sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ní caaⁿ'máⁿ nī cuuvi nī saⁿ'ā chi va'ai yeⁿ'ē miiⁿ: N'diī, señor Maestro yeⁿ'e yú ngaⁿ'á yā 'túúcā: ¿Tií cánéé cuarto chi che'é nguiinú yeⁿ'e pascua ndúúcū discípulos yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Saⁿ'ā miiⁿ ní 'cuuⁿ'miⁿ sa ndís'tiī 'áámá cuarto ch'ɛɛtɛ yeⁿ'e va'āī chí ndii 'uūvī piso ní 'aa vɛ́ɛ́ yaāaⁿ. Miiⁿ in'nuúⁿ nī chi che'e yú yeⁿ'e pascua. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Apóstoles ní cueⁿ'e yā ní ndaaca yā tanducuéⁿ'ē tan'dúúcā chi Jesús ngaⁿ'a yā ngii yā, ní n'nuúⁿ yā chí che'e yā yeⁿ'e pascua. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Taachí ndaā snuū ca'a hora chi che'e nguiinú yā, Jesús miiⁿ ndúúcū apóstoles yeⁿ'e yā ch'ɛɛtɛ́ yā na mesa chi che'e nguiinú yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Dɛ'ɛ chúúcā neⁿ'é che'é ndúúcū ndís'tiī 'viicu yeⁿ'e pascua 'cūū neⁿ'e chí 'āā 'cuɛ́ɛ́ 'cuūví. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Caati ngaⁿ'á ngií ndís'tiī ti 'úú ní 'āā ntɛ́ɛ́ che'é ndúúcu nī táámá 'viicu pascua ndíí taachi cuuvi cuaacu chi neⁿ'e caaⁿ'maⁿ yeⁿ'ē naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tuu'mi ní Jesús sta'á yā taza ndúúcū vino ní ca'a yā gracias Ndyuūs. Ní caⁿ'a yā chii yā apóstoles yeⁿ'e yā: Cuta'á nī chuū ní cu'u nī nguaaⁿ nducyaaca nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ti 'úú ní ngaⁿ'á ngií ndís'tiī, chi 'āā ntɛ́ɛ́ cu'ú jugo yeⁿ'e uvas, ndii ndaá nguuvi yeⁿ'e naachí Ndyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tuu'mi ní sta'a Jesús pan miiⁿ ní ca'a yā gracias Ndyuūs. Ní n'deé yā ní ca'a yā apóstoles ní caⁿ'a yā: Chuū chi tan'dúúcā cuerpo yeⁿ'é 'tíícā. Ní teé lugar 'iiⁿ'yāⁿ chi 'caaⁿ'núⁿ yā 'úú cáávā ndís'tiī. Diíⁿ nī chuū taachi n'gaacú nī yeⁿ'e 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'Tiicá ntúūⁿ diíⁿ yā ndúúcū taza. Taachí ch'íínú che'e yā ní caⁿ'a yā: Jugo yeⁿ'e uvas yeⁿ'e taza chí cuuvi cuaacu ní chuū tan'dúúcā chi yuūuⁿ yeⁿ'é chí cungéē cáávā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Maaⁿ ní saⁿ'ā chí naca'ā 'úú vɛɛ sa ndúúcu yú na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Saⁿ'ā chi Daiya Dendyuūs chí 'úú cuaacu nííⁿnyúⁿ caⁿ'a sa 'cuūvī sa tan'dúúcā chi neⁿ'e Dendyuūs. Dɛ'ɛ chúúcā ya'ai yeⁿ'ē saⁿ'ā chí naca'ā sa 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tuu'mi ní apóstoles tucá'a yā ntiingūūneeⁿ vi'i yā: ¿Du'u ra chí diiⁿ chuū? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tuu'mi ní apóstoles tuca'a yā caⁿ'a yā nguaaⁿ maaⁿ yā chɛɛ́ yā chi ch'ɛɛtɛ ca yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chiī yā 'iiⁿ'yāⁿ s'eeⁿ: Reyes yeⁿ'e tanáⁿ'ā naciones ngaⁿ'a ntiiⁿnyuⁿ yā tan'dúúcā chi 'iivi chɛɛchi ní 'iiⁿ'yāⁿ yeⁿ'e naciones ní ngaⁿ'a yā chi rey yeⁿ'e yā n'daacā idiíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Naati nguaaⁿ ndís'tiī nguɛ́ɛ́ 'tíícā. 'Iiⁿ'yāⁿ chi ch'ɛɛtɛ ca nguaaⁿ ndis'tíi canéé chi diíⁿ yā tan'dúúcā saⁿ'ā da'caiyāa chi diiⁿ mandados. 'Iiⁿ'yāⁿ chí ngaⁿ'a ntiiⁿnyúⁿ yā nguaaⁿ ndís'tiī canee chi diíⁿ yā tan'dúúcā 'áámá 'iiⁿ'yāⁿ chi dichíí'vɛ̄ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Chɛɛ̄ cá yā chi ch'ɛɛtɛ́ yā. ¿'Áá 'iiⁿ'yāⁿ chí n'giindí yā na mesa o 'iiⁿ'yāⁿ chi n'giī chi cho'o chi cu'u? ¿'Áá nguɛ́ɛ́ 'iiⁿ'yāⁿ chí n'giīndi na mesa? N'diichí nī. 'Úú ní canee nguaaⁿ ndís'tiī tan'dúúcā 'iiⁿ'yāⁿ ndíícuūⁿ chi dīchíí'vɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ndís'tiī ní ch'ɛɛtinée nī nduucú nguuvi nguuvi taachi 'úú n'geenú ngii tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ní tan'dúúcā Chiidá tee yā 'úú naachí ngaⁿ'ā ntiiⁿnyúⁿ 'tiicá ntúūⁿ 'úú ní teé ndís'tiī 'áámá chi caaⁿ'maⁿ ntiiⁿnyúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ní ndís'tiī 'cuɛɛtɛ́ nī na mesa nduucú chi che'é nī ní cu'ú nī naachi 'úú ngaⁿ'á ntiiⁿnyuⁿ. Ní 'cuɛɛtɛ́ nī na sillas yeⁿ'e juez ní n'diichí nī nuuⁿndi yeⁿ'ē ndichúúví ndaata yeⁿ'e 'iiⁿ'yāⁿ Israel chi judíos. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús yaa'ví yā Pedro ní caⁿ'a yā: N'dii, Simón Pedro, Simón Pedro, cuin'diichí nī ti yááⁿn'guiinūuⁿ ngiicá sa yeⁿ'e ndís'tiī chí cuuvi diiⁿ sa. N'diichineeⁿ sa ndís'tiī tan'dúúcā 'iiⁿ'yāⁿ ndáádi yā trigo 'tíícā diiⁿ sa. Ní vɛ́ɛ́ permiso yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Naati 'úú ní ngaⁿ'angua'á cáávā dii, Pedro, chi cu'téénu ca di. Ní taachi ndaacadaamí di yeⁿ'ē nuuⁿndi yeⁿ'e di ní cu'téénu ca di tuu'mi ní cunnee di tanáⁿ'ā hermanos yeⁿ'e di chi cu'téénu cá yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón caⁿ'a yā chii yā Jesús miiⁿ: Señor, 'āā vɛ́ɛ́ yaáⁿ chí caⁿ'á nduucú nī ndíí vácūū; ní ndúúti chi 'cuuví nī, 'úú ní 'cuuví ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús caⁿ'a yā chii yā Pedro: Ngaⁿ'á ngií dii chi tusáⁿ'ā ní nguɛ́ɛ́ 'cuai tī ndíí taanduvɛ́ɛ́ cueeⁿdiitú di 'iīnū cuuvi yeⁿ'e 'úú chi nguɛ́ɛ́ in'diichi di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tuu'mi ní Jesús itiinguunéeⁿ yā apóstoles: Taachí dicho'ó ndís'tiī nguɛ́ɛ́ cándɛɛ nī bolsa yeⁿ'e tuumi nī, ndíí nguɛ́ɛ́ ndúú morral yeⁿ'e nī, ndíí nguɛ́ɛ́ ndúú ndaacuú yeⁿ'e nī, ¿'áá vɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi chii faltar yeⁿ'e nī? Apóstoles ní caⁿ'a yā: Nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ní Jesús caⁿ'a yā: Maaⁿ ní ndís'tiī chi vɛ́ɛ́ bolsa yeⁿ'e nī, candɛɛ nī. 'Tiicá ntúūⁿ ndís'tiī chi vɛ́ɛ́ morral yeⁿ'e nī, candɛɛ nī. Ndís'tiī chi nguɛ́ɛ́ 'aama machete 'uūvī lados 'caāiⁿ yeⁿ'e nī, n'diicuí nī cotón yeⁿ'e nī ní cuái nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ti ngaⁿ'á ngií ndís'tiī chi canéé chí cuuvi cuaacú tanducuéⁿ'ē chi canéé nguūⁿ yeⁿ'é: Ní 'iiⁿ'yāⁿ caⁿ'a yā chi vɛ́ɛ́ nuūⁿndī yeⁿ'e 'úú tan'dúúcā tanáⁿ'ā 'iiⁿ'yāⁿ chi vɛ́ɛ́ nuuⁿndi yeⁿ'e yā. Tí tanducuéⁿ'ē chi canéé nguūⁿ yeⁿ'e 'úú canéé chí cuuvi cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tuu'mi ní discípulos ní caⁿ'a yā: N'diī, Señor, íngáā na 'uuvi machete 'uūvi lados 'caāiⁿ. Jesús ní caⁿ'a yā: Ndúúcū stíī 'āā vɛ́ɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cuayiivi ní can'daā Jesús tan'dúúcā costumbre yeⁿ'e yā ní cueⁿ'é yā na yiīcū yeⁿ'e Olivos. Ní discípulos yeⁿ'e yā cueⁿ'é yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ní taachí ndaa yā na lugar miiⁿ, tuu'mi ní Jesús miiⁿ ní caⁿ'a yā chii yā discípulos yeⁿ'e yā: Ndís'tiī caaⁿ'maⁿngua'á nī chí yááⁿn'giinūuⁿ nguɛ́ɛ́ n'diichineeⁿ sa ndís'tiī chi diíⁿ nī nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús ní cueⁿ'e yā yeⁿ'e discípulos yeⁿ'e yā tanduu naaⁿ chi naachi ndaá 'áámá tuūu chi ngii ya ní Jesús caantii'yá yā ní caⁿ'angua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ní caⁿ'a yā: N'diī, Chiidá, ndúútí chí neⁿ'e nī ní divíi nī yeⁿ'e chi canee chi 'cueenú cuuvi yeⁿ'e prueba 'cūū. Naati nguɛ́ɛ́ cuuví tan'dúúcā chi 'úú neⁿ'é naati tan'dúúcā chí n'diī neⁿ'e nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ní che'enaāaⁿ 'áámá ángel yeⁿ'ē nanguuvi ní ca'á yā fuerzas Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ti neené ya'ai Jesús miiⁿ ní ndiituu n'dai ca ngáⁿ'angua'á yā. Ní nuuⁿniⁿyaaⁿ yeⁿ'e yā tan'dúúcā yuuúⁿ chí ndii na yáⁿ'āa ingéē. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nducueeⁿ yā naachí ngaⁿ'angua'á yā ní ndaa yā nanááⁿ discípulos yeⁿ'e yā ní ndaaca yā chi styaadú yā, ti discípulos ní neené ndaachi núúⁿ yā ti ya'ai yā cáávā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tuu'mi ní Jesús caⁿ'a yā chii yā discípulos: ¿Dɛ'ɛ̄ cúúví chí styaadú nī? Nducuéeⁿ nī ní caaⁿ'maⁿngua'á nī ní yááⁿn'guiinūuⁿ nguɛ́ɛ́ n'diichineeⁿ sa ndís'tiī chi diíⁿ nī nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Taachí Jesús indée yā neené n'deee 'iiⁿ'yāⁿ ndaa yā ní saⁿ'ā chi nguuvi Judas miiⁿ chi 'áámá chɛ́ɛ́ naachí ndiichuuvi discípulos yeⁿ'é yā cueⁿ'é yā vmnááⁿ yeⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ ní ndaa niiⁿnuúⁿ yā Jesús miiⁿ chi 'neeⁿcheendí yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tuu'mi ní Jesús miiⁿ ní caⁿ'a yā chiī yā saⁿ'ā: Díí, Judas, ¿'áá ndúúcū 'áámá beso ínaca'a di 'úú chí Saⁿ'ā chi Daiya Ndyuūs 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Discípulos chi snée yā ndúúcū Jesús taachí snaaⁿ yā chi cuuvi, tuu'mi ní caⁿ'a yā chii yā Jesús: N'dií, Señor, ¿'áá 'caaca taaⁿ 'nū ndúúcū machete 'uūvī lados 'caāiⁿ yeⁿ'ē yú? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tuu'mi ní 'áámá chɛ́ɛ́ discípulos 'nuūcá'ai yā 'áámá mozo yeⁿ'ē chiiduú ch'ɛɛtɛ́ ca ní ch'iica yā veeⁿ sa lado tá cuaācú sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ní Jesús caⁿ'a yā: 'Āā ntɛ́ɛ́ 'cuuⁿ'miⁿ dí. 'Āā snéé ra yā. Ní Jesús tuu'ví yā veeⁿ sa ní nduūvā yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Cuayiivi ní Jesús caⁿ'a yā chii yā chiiduú n'gɛɛtɛ ndúúcū soldados chi capitanes chi diīⁿ sa cuidado yaācū templo ndúúcū 'iiⁿ'yāⁿ ndicúū chí ngaⁿ'ā ntiiⁿnyúⁿ yā yeⁿ'e yaācū chi ndaa yā ndúúcū Judas miiⁿ: ¿'Áá ndaā ndís'tiī ndúúcū machetes 'uūvī lados 'caāiⁿ ndúúcū yáⁿ'á yeⁿ'e soldados tan'dúúcā chi caⁿ'a nī cutá'a nī 'áámá chi duūcū? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Taachí caneé ndúúcū ndís'tiī nguuvi nguuvi ná yaācū templo nguɛ́ɛ́ neⁿ'é nī cuta'á nī 'úú. Naati maaⁿ ní hora 'cūū chí yeⁿ'ē ndís'tiī ti hora taachí maāiⁿ miiⁿ, chííⁿ chi yááⁿn'guiinūuⁿ ngaⁿ'a ntiiⁿnyuⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ sta'a yā Jesús miiⁿ ní candɛ́ɛ yā Jesús va'ai yeⁿ'ē chiiduú ch'ɛɛtɛ́ ca. Pedro miiⁿ ní ndáá yaⁿ'ai sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Náⁿ'ā 'iiⁿ'yāⁿ tiivií yā yaⁿ'ā náávtaⁿ'ā chuva'ai ní ch'ɛɛ̄tɛ́ yā cuaaⁿ 'diituú yaⁿ'ā miiⁿ chi dicuutú yā. Pedro miiⁿ ní ch'iīndi sa ntúuⁿ sa ndúúcū 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tuu'mi ní 'áámá táⁿ'ā chí cánéé caadi 'iīyū, n'diichī tá Pedro miiⁿ chí vɛɛ sa 'diituú na yaⁿ'ā. Ní n'giinu n'dai tá saⁿ'ā ní caⁿ'a tá: Sáⁿ'a 'cūū ní canee sa ndúúcū 'iiⁿ'yāⁿ chi preso yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro miiⁿ ní caⁿ'a sa chii sa n'daātā miiⁿ: 'Úú nguɛ́ɛ́ in'diichí 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Cuayiivi miiⁿ ní 'aama saⁿ'ā n'diichi n'dai sa ní caⁿ'a sa chii sa Pedro miiⁿ: Dii, ní ndúúcū di nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ. Pedro miiⁿ ní caⁿ'a sa chiī sa saⁿ'ā miiⁿ: Nguɛɛ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cho'ōo 'áámá hora, ni táámá yā ní caⁿ'a yā: Cuaacu nííⁿnyúⁿ sáⁿ'a 'cūū ní canéé sa ndúúcū 'iiⁿ'yāⁿ chi preso yā ti sáⁿ'a 'cūū ní yeⁿ'ē yáⁿ'āa Galilea ntúūⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro miiⁿ ní caⁿ'ā sa chii sa saⁿ'ā miiⁿ: Díí, sáⁿ'ā, nguɛ́ɛ́ deenú chi ngaⁿ'ā di. Taachí Pedro miiⁿ 'āā cuɛ́ɛ́ 'cuiinu sa caⁿ'a sa chúū, tusáⁿ'ā miiⁿ ní 'cai tī. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tuu'mi ní Jesús miiⁿ nguɛɛcundíi yā ní n'diichi yā Pedro. Pedro miiⁿ nán'gaācū sa nduudu chí caⁿ'a Jesús miiⁿ chii yā saⁿ'ā 'túúcā: 'Āā 'iinu cúúví caaⁿ'maⁿ dí chi nguɛ́ɛ́ n'diichi di 'úú, taachi 'āā cuɛ́ɛ́ 'caī 'áámá vmnéⁿ'ēe tusáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tuu'mi ní Pedro miiⁿ ní can'dáa sa cuaaⁿ va'ai, ní chɛɛcu taaví sa ti ya'ai staava yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sáⁿ'ā s'eeⁿ chi diiⁿ cuidado Jesús miiⁿ chííⁿnyuⁿneeⁿ sa Jesús miiⁿ ní ch'eⁿ'e sá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ní n'gaadi sa nduutináaⁿ yā ndúúcū 'aama tíínuuⁿ. Tuu'mi ní ch'eⁿ'e sá naaⁿ Jesús ní ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ: Dii, caaⁿ'maⁿ di, ¿du'ú ch'eⁿ'ē dii? ");
INSERT INTO cuxNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ní neene cunncáā nduudu ngii sá Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Taachí chidɛɛvɛ táámá nguuvi, 'yaaⁿ n'dáí 'iiⁿ'yāⁿ ndiicúū yeⁿ'e yáāⁿ miiⁿ chi ngaⁿ'a ntiiⁿnyuⁿ yā yeⁿ'e yaācū, ndúúcū chiiduú n'gɛɛtɛ́, ndúúcū maestros chi ngi'cueéⁿ ley miiⁿ candɛ́ɛ yā Jesús nanááⁿ 'iiⁿntyéⁿ'ē yeⁿ'e yaācū templo. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mííⁿ íntiinguunéeⁿ yā Jesús: ¿'Áá díí chí Cristo? Jesús miiⁿ nan'guɛɛcutaⁿ'a yā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ: Ndúúti chi caaⁿ'máⁿ chi 'tíícā, ní nguɛ́ɛ́ cu'téénu nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nduuti chi 'úú ntiinguuneéⁿ ndís'tiī, nguɛ́ɛ́ n'guɛɛcútaⁿ'a nī yeⁿ'é, ndíí nguɛ́ɛ́ ndúú n'dɛɛchi ra nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Naati hora chi cuchiī ní Saⁿ'ā chi Daiya Ndyuūs ní 'cuūndi sa lado yeⁿ'e honor yeⁿ'é Ndyuūs chí vɛ́ɛ́ tanducuéⁿ'ē poder yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tanducuéⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ caⁿ'a yā: ¿'Áá dii Daiya Dendyuūs miiⁿ? Ní Jesús ní caⁿ'a yā: Ndís'tiī maáⁿ nī ngaⁿ'a nī chi 'úú ní 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: ¿Dɛ'ɛ̄ cá nduudu cuaacu yeⁿ'e 'iiⁿ'yāⁿ chí neⁿ'e yú? Tí maāⁿ yú ch'iindiveeⁿ cuaacú yú nduudu chí caⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tuu'mi ní nducyaaca 'iiⁿ'yāⁿ ní candɛɛ yā Jesús miiⁿ nanááⁿ gobernador Pilato. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ní tuca'a yā caⁿ'a yā nuuⁿndi yeⁿ'ē Jesús miiⁿ ní caⁿ'a yā: Inndaacá 'nū sáⁿ'a 'cūū chi diiⁿ sa chí 'iiⁿ'yāⁿ nguɛ́ɛ́ i'téénu yā chi ngaⁿ'a ley yeⁿ'é 'nū. Ní nguɛ́ɛ́ neⁿ'e sa chí nadíí'vɛ 'nū yeⁿ'e yáⁿ'āa emperador César tan'dúúcā chi ngaⁿ'a ley yeⁿ'é nī. Ní sáⁿ'a 'cūū ní ngaⁿ'ā sa chí maāⁿ sa chi Cristo, chí Rey yeⁿ'é 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tuu'mi ní saⁿ'ā Pilato miiⁿ ní itiinguunéeⁿ sa Jesús: ¿'Áá diī chi Rey yeⁿ'e 'iiⁿ'yāⁿ Israel s'eeⁿ? Jesús nan'guɛɛcútaⁿ'a yā: N'diī ngaⁿ'á cuaacú nī ti 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato miiⁿ ní caⁿ'a yā chii yā chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿ'yāⁿ s'eeⁿ: 'Úú nguɛ́ɛ́ inndaacá mar 'áámá nuuⁿndi yeⁿ'e sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Iiⁿ'yāⁿ s'eeⁿ ní diitu n'dáí 'cai yā: Sáⁿ'a 'cūū ní idiiⁿ sa chi 'iiⁿ'yāⁿ n'gɛ́ɛ́cú cheendi yā nguaaⁿ maaⁿ yā ndúúcū chí ngi'cueeⁿ yā ní ngi'cueeⁿ yā nuuⁿmáⁿ yáⁿ'āa Judea ndíí na yáⁿ'āa yeⁿ'ē Galilea ndii 'muuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tuu'mi ní Pilato, taachi ch'iindiveéⁿ yā chi Jesús cheⁿ'e yā ndii yáⁿ'āa yeⁿ'e Galilea, ní ntiinguuneéⁿ yā Jesús nduuti chi yeⁿ'e yáⁿ'āa yeⁿ'e Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ní taachí Pilato ch'iindiveeⁿ sa chi Jesús miiⁿ ní yeⁿ'ē yáⁿ'āa Galilea yeⁿ'e yáⁿ'āa naachi rey Herodes ngaⁿ'a ntiiⁿnyúⁿ yā, Pilato miiⁿ ngaⁿ'a ntiiⁿnyúⁿ yā chi Jesús caⁿ'a yā nanááⁿ rey Herodes tii canée yā na yáāⁿ Jerusalén nguuvi miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Taachí rey Herodes n'dííchi sa Jesús miiⁿ, neené yeenú sa ti 'āā 'nááⁿ n'dai tiempo néⁿ'é sá snaaⁿ sa Jesús. Tí nééné n'deēe 'nááⁿ chí ch'iindiveeⁿ sa yeⁿ'é yā ní canéé ngíínú sá chí snaaⁿ sa 'áámá vaadī n'giinu chi diíⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nééné n'deēe 'naaⁿ chí ntiingūūneeⁿ sa Jesús miiⁿ, naati nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nan'guɛɛcútaⁿ'a Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tuu'mi ní miiⁿ canee ntuuⁿ chiiduú n'gɛɛtɛ́ ndúúcū maestros chí ngi'cuéeⁿ ley miiⁿ chí n'deēe 'nááⁿ n'dai ngaⁿ'a yā chí nuuⁿndi yeⁿ'ē Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tuu'mi ní Herodes ndúúcū soldados yeⁿ'e yā chi'nuuⁿ yā 'áámá tiīnūuⁿ n'dáí tan'dúúcā catecai rey Jesús miiⁿ ní chiiⁿnyuⁿneeⁿ yā Jesús miiⁿ ní cunncáā caⁿ'a yā yeⁿ'e Jesús miiⁿ. Cuayiivi ní dicho'o ntúuⁿ yā Jesús nanááⁿ Pilato miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndíí nguuvi miiⁿ tuu'mi ní Pilato ndúúcū Herodes naaⁿ n'daá n'dai yā ndúúcū vi'ī ti cuááⁿ vmnaaⁿ ní nguɛ́ɛ́ n'diichí yā vi'ī. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tuu'mi ní Pilato nduuvidaamá yā chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿntyéⁿ'e ndúúcū nducyaaca 'iiⁿ'yāⁿ yeⁿ'ē yáāⁿ Jerusalén miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndís'tiī ní ndaá nī chi 'cúúⁿ nī sáⁿ'a 'cūū chí diiⁿ sa chi 'iiⁿ'yāⁿ ní nguɛ́ɛ́ n'gɛɛtinéé 'diīiⁿ yā ndúúcū chi ngi'cueeⁿ sa. Taachí intiinguuneéⁿ saⁿ'ā nanááⁿ ndís'tiī nguɛ́ɛ́ nindaācá mar 'áámá nuuⁿndi yeⁿ'ē sa chí ngaⁿ'a ndís'tiī yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ndíí nguɛ́ɛ́ ndúú rey Herodes miiⁿ ndaāca yā nuuⁿndi yeⁿ'ē sáⁿ'a 'cūū chi canéé chí 'cuūvi sa ti Herodes 'āā dicho'ó yā sáⁿ'a 'cūū nanaáⁿ. Sáⁿ'a 'cūū nguɛɛ diiⁿ sa nuuⁿndi ch'ɛɛtɛ chi 'cuūvi sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Maaⁿ ní diíⁿ 'cueⁿ'é saⁿ'ā miiⁿ ní cuáyííví n'dɛɛchí saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Canéé 'áámá costumbre yeⁿ'é nī chí gobernador canee chi n'dɛɛchi yā 'áámá preso 'viicu pascua ní gobernador Pilato miiⁿ ní canée yā diiⁿ yā 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nducyáácá 'iiⁿ'yāⁿ 'cai yā: N'dɛɛchii nī saⁿ'ā chí ngúúví Barrabás. Ni 'āā 'cuuvi rá sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás miiⁿ canúúⁿ sá vácūū chi diiⁿ sa chi 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ ní 'cuuⁿ'míⁿ yā contra yeⁿ'e gobierno ní ch'iīⁿ'nuⁿ sa 'áámá tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gobernador Pilato miiⁿ ní neⁿ'e sa n'dɛɛchi sa Jesús, ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ s'eeⁿ taama vmnéⁿ'ēe chi n'dɛɛchi sá Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Naati 'iiⁿ'yāⁿ s'eeⁿ 'cai ntúuⁿ yā: Cu'nééⁿnga'á nī saⁿ'ā, cu'nééⁿnga'á nī saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Gobernador Pilato miiⁿ ní caⁿ'a ntúuⁿ yā ndii chiiⁿ ndii 'íínú cuuvi: ¿Dɛ́'ɛ̄ chi nguɛ́ɛ́ n'dáacā n̄dííⁿ sáⁿ'a 'cūū? 'Úú nguɛ́ɛ́ inndaācá mar 'áámá núúⁿndí ch'ɛɛtɛ yeⁿ'ē sa chi 'cuūvi sa. 'Úú ní ca'á orden chi ch'eⁿ'é yā sáⁿ'a 'cūū ní n'dɛɛchí sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Iiⁿ'yāⁿ s'eeⁿ chi canndīi cá yā 'cai yā chí chiica yā chí cu'neeⁿngá'āa Jesús miiⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ ndúúcū chiiduú n'gɛɛtɛ́ diituú n'dáí ca 'cai yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tuu'mi ní gobernador Pilato miiⁿ ní ca'a yā orden chi diíⁿ yā tan'dúúcā chí neⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ní n'dɛɛchi yā saⁿ'ā chi nguuvi Barrabás miiⁿ chi canúúⁿ vácūū. Sáⁿ'ā miiⁿ ní diiⁿ sa chi 'cuuⁿ'míⁿ 'iiⁿ'yāⁿ yeⁿ'e Israel contra yeⁿ'e gobierno ní 'niiⁿ'nuⁿ sa 'áámá tináⁿ'ā. Sáⁿ'a 'cūū chi chiica 'iiⁿ'yāⁿ s'eeⁿ chi n'dɛɛchí yā saⁿ'ā. Ní nca'a yā Jesús miiⁿ chí soldados cu'neeⁿnga'a sa tan'dúúcā chi neⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Taachí cueⁿ'e yā cuaaⁿ cyúúní miiⁿ ndúúcū Jesús miiⁿ, soldados sta'á yā 'áámá saⁿ'ā yeⁿ'e yáⁿ'āa Cirene chi nguuvi sa Simón. Saⁿ'ā miiⁿ ní yúúní canuuⁿ sa chi cueⁿ'e sa cuɛɛti. Soldados a fuerza di'cuíítu yā Simón miiⁿ chi candɛ́ɛ sa cruz yeⁿ'e Jesús miiⁿ ní cueⁿ'e sa cuaaⁿ daami Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Nééné 'yaaⁿ 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ cueⁿ'e yā n'dáa yā Jesús miiⁿ ndúúcū n'daataá chí diituu ngɛɛcu yā ní ya'ai yā cáávā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús miiⁿ ní ch'íínu yā n'daataá s'ééⁿ ní caⁿ'a yā chii yā táⁿ'ā s'eeⁿ: Ndís'tiī, daiya 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén, nguɛ́ɛ́ cuɛɛcú nī cáávā 'úú, naati cuɛɛcú nī cáávā maáⁿ nī ní caavā daiya nī. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ti ndaá nguuvi chí caaⁿ'maⁿ 'iiⁿ'yāⁿ: ¿Dɛ'ɛ̄ chúúcā n'dai n'daataá chi nguɛ́ɛ́ ncuuvi daiya tá ní n'daataá chi nguɛ́ɛ́ ntaavi daiya tá ní n'daataá chi nguɛ́ɛ́ daiya tá chi ca'a ta daiya tá chí chiicu? ");
INSERT INTO cuxNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ tucá'a yā caⁿ'a yā 'tuucā: Díí yiīcū cun'daá nduú nī vmnaaⁿ yeⁿ'é 'nū. Caⁿ'a ntúuⁿ yā chii yā yiīcū n'gaiyáā: Cun'díí neeⁿ dí nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Caati ndúúti chi 'iiⁿ'yāⁿ chi taaⁿ yā 'caaca yā yáⁿ'á cueeé chi tan'dúúcā 'úú, ¿'áá nguɛ́ɛ́ caniicu cá yā 'caaca yā yáⁿ'á chí cuuⁿmaⁿ chi tan'dúúcā ndís'tiī? 'Tíícā ngaⁿ'a Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nguuvi miiⁿ ní candɛ́ɛ ntúuⁿ yā na 'uuvi saⁿ'ā chí n'giiⁿ'nuⁿ 'iiⁿ'yāⁿ chi cu'neeⁿnga'a yā saⁿ'ā s'eeⁿ dáámá ndúúcū Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Taachí ndaa yā lugar yeⁿ'ē 'áámá yiīcū 'lííⁿ chí nguuvi Calavera, miiⁿya chi'nééⁿnga'a yā Jesús miiⁿ ndúúcū nduu 'uūví saⁿ'ā chi n'giiⁿ'núⁿ 'iiⁿ'yāⁿ, 'áámá sa lado ta cuaacú Jesús miiⁿ, ni táámá sá lado tá 'cueé yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tuu'mi ní taachi snée yā i'neeⁿnga'á yā, Jesús miiⁿ caⁿ'a yā: N'diī, Chiidá, nadich'ɛɛcú nī yeⁿ'e saⁿ'ā s'uuⁿ caati nguɛɛ déénu sá dɛ'ɛ̄ chi 'túúcā idiiⁿ sa. Tuu'mi ní soldados tun'dáa sa suerte na catecai Jesús chí ca'ā sa 'áámá sá ndúúcū taama sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","'Iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén miiⁿ snée yā n'giinu yā níícú 'iiⁿntyeⁿ'ē n'giiⁿnyuⁿneéⁿ yā Jesús miiⁿ. Ní ngaⁿ'a yā ngii yā yeⁿ'e Jesús: Sáⁿ'a 'cūū ní nadanguáⁿ'ai sa tanáⁿ'ā 'iiⁿ'yāⁿ. ¿Dɛ'ɛ̄ cuuvi chi nguɛ́ɛ́ nadinguáⁿ'ai maāⁿ sa saⁿ'ā nduuti chi saⁿ'ā miiⁿ chi Cristo chi Ndyuūs dicho'ó yā? ");
INSERT INTO cuxNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","'Tiicá ntúūⁿ soldados n'giiⁿnyuⁿneeⁿ sa Jesús miiⁿ. Cheⁿ'e niiⁿnúⁿ yā ní ca'a yā vinagre. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ní caⁿ'a yā chii yā Jesús miiⁿ: Ndúúti chi díí chi Rey yeⁿ'e 'iiⁿ'yāⁿ Israel, nadanguáⁿ'ai maāⁿ di díí. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ní canéé nguūⁿ na tiīⁿ cruz yeⁿ'e Jesús miiⁿ nduudu griego ndúúcū nduudu latín ndúúcū nduudu hebreo, chí ngaⁿ'a: Sáⁿ'a 'cūū Rey yeⁿ'ē 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","'Áámá chɛɛ saⁿ'ā chi vɛ́ɛ́ nuuⁿndi yeⁿ'ē sa chi ca'nééⁿnga'a yā 'áámá lado yeⁿ'e Jesús cunncáā caⁿ'a sa ní caⁿ'a sa chii sa Jesús: Ndúúti chi dii chi Cristo miiⁿ nadinguáⁿ'ai di maaⁿ di ní nadinguáⁿ'ai ntuuⁿ di nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Táámá saⁿ'ā chi cu'nééⁿnga'a yā táámá lado yeⁿ'e Jesús 'caa'va sa ndúúcū sáⁿ'a 'cūū ní caⁿ'a sa chii sa saⁿ'ā: Díí ¿'áá nguɛ́ɛ́ 'va'a di Ndyuūs? Dii ní dáámá condenado ndúúcū nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","S'uúⁿ ní cuaacu nííⁿnyúⁿ n'geenu yú ngii ti vɛ́ɛ́ nuuⁿndi yeⁿ'ē yú chi nadíí'vɛ̄ yú nuuⁿndi yeⁿ'e yú naati sáⁿ'a 'cūū nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ nuuⁿndi diíⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Saⁿ'ā miiⁿ ní caⁿ'a sa chii sa Jesús miiⁿ: N'diī, Jesús, n'gaacú nī yeⁿ'ē 'úú taachí ndaá nī naachi caaⁿ'maⁿ ntiiⁿnyuⁿ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tuu'mi ní Jesús miiⁿ caⁿ'a yā chiī yā saⁿ'ā: Cuaacu nííⁿnyúⁿ ngaⁿ'á ngií dii, ti maaⁿ ní cunee di nduucú na lugar chi nguuvi paraíso. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Taachí chii maⁿ'a nguuvi chii maāiⁿ núúⁿmáⁿ íⁿ'yeeⁿdi ndíí taanduū n'gɛɛcu 'íínú chiīnū. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","'Yáⁿ'ā ní nduuvi maāíⁿ ní cortina yeⁿ'e yaācū templo nda'ai náávtáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tuu'mi ní Jesús miiⁿ 'cai yā: N'diī, Chiidá, na ta'á nī cu'neéⁿ espíritu yeⁿ'é. Ch'íínú caⁿ'a yā chuū, ní Jesús ch'īi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Taachí saⁿ'ā chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e soldados romanos n'diichi sa chí ch'iī Jesús, tuu'mi ní caⁿ'a sa: Dɛ'ɛ chúúcā ch'ɛɛtɛ Ndyuūs. Cuaacu nííⁿnyúⁿ sáⁿ'a 'cūū saⁿ'ā chi nguɛ́ɛ́ nuuⁿndi yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nducyáácá 'iiⁿ'yāⁿ chí cheⁿ'e yā ní n'diichi yā chí chiī, nguɛɛcundíi yā ch'eⁿ'e niiⁿnuⁿ yā taachi cueⁿ'é yā vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ní nducyáácá 'iiⁿ'yāⁿ chi n'diichí yā Jesús miiⁿ, ndúúcū n'daataá chí cheⁿ'e ndúúcū Jesús miiⁿ ndii yáⁿ'āa yeⁿ'e Galilea, ch'ɛɛtinéé yaⁿ'ai yā ch'íínu yā dendu'ū chi 'túúcā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Vɛ́ɛ́ 'áámá saⁿ'ā chí n'dai ní n'daacā sa chi ngúúví sá José. Sáⁿ'ā miiⁿ ní saⁿ'ā ch'ɛɛtɛ yeⁿ'é 'iiⁿntyéⁿ'ē ch'ɛɛtɛ yeⁿ'é 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Saⁿ'ā miiⁿ ní yeⁿ'e yáāⁿ Arimatea chi yáⁿ'āa yeⁿ'e 'iiⁿ'yāⁿ Israel. Ní saⁿ'ā nguɛ́ɛ́ ndúúvídaama sa ndúúcū tanáⁿ'ā 'iiⁿntyeⁿ'ē ti nguɛ́ɛ́ canee yiinú sa ndúúcū chi diíⁿ yā. Tí saⁿ'ā miiⁿ canee ngíínú sá tiempo chi Ndyuūs ndaa yā iⁿ'yeeⁿdí 'cūū ní ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ní cueⁿ'e sa ndaa sa nanááⁿ gobernador Pilato ní chiica sa cuerpo yeⁿ'e Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cuayiivi taachi José ndivíi sa cuerpo yeⁿ'e Jesús na cruz ní ch'ɛɛ̄cu sa áámá sábana na cuerpo yeⁿ'e yā tan'dúúcā costumbre yeⁿ'e 'iiⁿ'yāⁿ Israel ní ch'iichi sa na 'áámá yáinyāⁿ ngai chi din'dái yā chɛɛti yiivi yaava naachí mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ nnúuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nguuvi miiⁿ ní nguuvi viernes chi 'iiⁿ'yāⁿ ch'iindiyaáⁿ yā tanducuéⁿ'ē cáávā 'viicu pascua ní cáávā nguuvi chi cuchiī chi sábado chi nguuvi chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","N'daata s'eeⁿ chí can'daa Jesús ndii na yáⁿ'āa Galilea, cueⁿ'e tá ní n'diichi tá yáinyāⁿ ní táácā canuúⁿ cuerpo yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ní taachí n'daataá s'eeⁿ ndaa tá vaacu tá, n'nuuⁿ tá perfumes ndúúcū pomadas chi n'dɛɛvɛ́ ngeeⁿ. Ní nguuvi cuayiivi, ní nguuvi sábado chi ntaavi'tuunúúⁿ 'iiⁿ'yāⁿ tan'dúúcā chi ngaⁿ'a ley yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nguuvi domingo chi maaⁿ ní nguuvi vmnááⁿ vmnaaⁿ yeⁿ'ē ndɛɛtɛ, tyaaⁿ n'dáí cueⁿ'e n'daataá s'ééⁿ ní cueⁿ'e yā ndúúcū tanáⁿ'ā n'daataá. Candɛ́ɛ yā especias chi dɛɛvɛ́ ngeéⁿ chí 'āā vɛ́ɛ́ yaáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Taachí ndāa yā na yáinyāⁿ miiⁿ, 'āā ntɛ́ɛ́ tuūú ch'ɛɛtɛ́ miiⁿ na cheendi yáinyāⁿ ti caneé 'aama lado. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tuu'mi ní taachí sndaa yā chɛɛti yáinyāⁿ miiⁿ, nguɛ́ɛ́ ndaacá yā cuerpo yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Taachí n'diichí yā chuū, ní dii'yá yā chiī, tuu'mi ní neēéⁿ na 'uuvi saⁿ'ā 'diituú yā ndúúcū catecai chi dɛɛvɛ́ ngii. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ní n'daataá s'eeⁿ dii'ya n'dai yā chiī ní n'diichí yā ndii na yáⁿ'āa. Saⁿ'ā s'eeⁿ ní caⁿ'a sa: ¿Dɛ'ɛ̄ cuuví chí in'nuúⁿ nī 'iiⁿ'yāⁿ chi candúúchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Iiⁿ'yāⁿ miiⁿ ní 'āā ntɛ́ɛ́ canée yā 'muuⁿ. 'Āā nnduuchi yā nguaaⁿ tináⁿ'ā. N'gáácú nī yeⁿ'ē nduudu chí caⁿ'a yā taachi canée yā ndúúcu nī na yáⁿ'āa Galilea taachí 'āā cuɛ́ɛ́ 'cuūvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ní Jesús miiⁿ ní caⁿ'a yā chiī yā ndís'tiī: 'Úú Saⁿ'a chi Daiya Ndyuūs ní 'iiⁿ'yāⁿ canéé chí nca'á yā 'úú ta'ā 'iiⁿ'yāⁿ chi dinuuⁿndí yā. Ní 'iiⁿ'yāⁿ s'eeⁿ cu'neeⁿnga'á yā 'úú; naati ndiichi ndii 'íínú nguuvi 'úú nduuchí yeⁿ'e nguaaⁿ tinaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tuu'mi ní n'daata s'eeⁿ n'gaacu tá yeⁿ'ē nduudu yeⁿ'ē Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ní cueⁿ'e tá yeⁿ'e yáinyāⁿ ní cunaⁿ'ā ta ní caⁿ'ā tá chiī tá ndu'u ndiicháámá apóstoles ndúúcū tanáⁿ'ā 'iiⁿ'yāⁿ chi snée yā miiⁿya. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","N'daata s'eeⁿ chi caⁿ'a ta chii tá apóstoles ní ta María yeⁿ'e yáāⁿ Magdala, ndúúcū ta Juana, ndúúcū tá María chí chɛɛcuú Jacobo, ndúúcū tanáⁿ'ā n'daata s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apóstoles ní nadicadiinúúⁿ yā chi táⁿ'ā s'eeⁿ ní loca tá cáávā chi ngaⁿ'a tá. Ní nguɛ́ɛ́ s'téénu yā nduudu yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tuu'mi ní Pedro miiⁿ ní ncueeⁿ sa ní cueⁿ'e sa ngéenū sa na yáinyāⁿ. Taachí ndaā sa, tuu'mi ní n'diichi núúⁿ sa chɛɛti yaīnyāⁿ ní 'āā dámaāⁿ sábanas canee miiⁿ. Saⁿ'ā ní cueⁿ'e yiinu sá yeⁿ'e chi chó'ōo ní cunaⁿ'ā sa na vaacu sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nguuvi mííⁿ nūuⁿ, 'uuvi saⁿ'ā s'eeⁿ cueⁿ'é yā 'áámá yáāⁿ 'lííⁿ chí nguuvi Emaús chi canee taanduū ndiichúúví kilómetros yeⁿ'e yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ní taachí cueⁿ'e yā cuaaⁿ cyúúní ní índeé yā yeⁿ'e tanducueⁿ'ē dendu'ū chí chiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'Nááⁿ chí índeé yā ní itiinguuneeⁿ vi'i yā, maaⁿ Jesús miiⁿ ndaa niiⁿnúⁿ yā ní cueⁿ'é yā ndúúcū 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Taachí n'diichí yā Jesús miiⁿ nguɛ́ɛ́ iintiinaaⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ índeé ndís'tiī? ¿Dɛ'ɛ̄ cuuví tátiī ndaachi yiinú nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Saⁿ'ā chi nguuvi Cleofas nan'guɛɛcútaⁿ'a yā. ¿'Áá díí, 'áámá n'dyáⁿ'ā dii chi canuuⁿ di yúúní na yáāⁿ Jerusalén chi nguɛ́ɛ́ déénu di dɛ'ɛ́ chiī nguuvi s'eeⁿ na yáāⁿ Jerusalén miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tuu'mi ní Jesús caⁿ'a yā chiī yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ́ chiī yáāⁿ miiⁿya? 'Iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Jesús yeⁿ'e yáāⁿ Nazaret, chi 'áámá saⁿ'ā profeta ní diíⁿ yā 'áámá ntiiⁿnyuⁿ n'dai ndúúcū poder. Ní diíⁿ yā n'deee n'dáí vaadī n'giinu ní ngaⁿ'a yā nduudu yeⁿ'é Ndyuūs nanááⁿ Ndyuūs ní nanááⁿ nducyaaca 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Chiiduú n'gɛɛtɛ́ ndúúcū 'iiⁿntyéⁿ'ē yeⁿ'ē yú tun'dáa nuuⁿndi yeⁿ'e Jesús ní nca'a yā Jesús 'iiⁿ'yāⁿ ní caⁿ'a yā chí 'cuuvi yā. Níícú s'neeⁿnga'á yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nús'uu ní snéé yúúní 'nū ní cunee ngiinú 'nū chí sáⁿ'a 'cūū ní nadinguáⁿ'ai sa 'iiⁿ'yāⁿ yeⁿ'é nación Israel chi nación yeⁿ'é 'nū. Maaⁿ ní 'iīnū nguuvi chí chiī chuū. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ní ná n'duuvi n'daataá chí chiicá yā dáámá nduucú 'nū cheⁿ'é yā tyaaⁿ na yáinyāⁿ ní cueⁿ'e yíínú 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ní ndaá yā nanaáⁿ 'nū ní caⁿ'a yā chi nguɛ́ɛ́ ndaaca yā cuerpo yeⁿ'e Jesús miiⁿ. Ní n'diichí yā n'duuvi ángeles chí caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ chí Jesús miiⁿ 'āā nduuchí yā yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ni cheⁿ'é n'duuvi saⁿ'ā chi chiicá nduucú 'nū na yáinyāⁿ ní ndaāca sa tan'dúúcā chi ngaⁿ'a n'daataá s'eeⁿ naati nguɛ́ɛ́ n'diichi sa Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tuu'mi ní Jesús caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Dɛ'ɛ̄ chúúcā vaadicadíínūuⁿ yeⁿ'e ndís'tiī ndúúcū staava yeⁿ'e nī chí chɛɛchi chí nguɛ́ɛ́ s'téénu nī tanducuéⁿ'ē chi caⁿ'a saⁿ'ā profetas. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿'Áá nguɛ́ɛ́ canee nguūⁿ na libro yeⁿ'é Ndyuūs chi Cristo miiⁿ canéé chí 'cueenú yā cuuvi cosas chi 'túúcā ní cuayiivi mííⁿ cunaⁿ'á yā ná va'ai chɛɛti nguuvi? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tucá'a Jesús caⁿ'a yā yeⁿ'e tanducuéⁿ'ē chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs ndíí taachí dinguuⁿ Moisés ndúúcū chi dingúūⁿ nducyaaca profetas. Ní ngaⁿ'a Jesús yeⁿ'e chí dinguúⁿ yā yeⁿ'ē Cristo ndíí cuááⁿ vmnaaⁿ yeⁿ'e chi canéé chi chó'ōo yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tuu'mi ní taachi ndaá yā na yáāⁿ 'lííⁿ chi cueⁿ'e yā, Jesús miiⁿ ní diíⁿ yā chi candiicá ca yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Saⁿ'ā s'eeⁿ di'cuíítu sa Jesús chi canee yā ndúúcū sa, ní caⁿ'a sa chii sa Jesús: N'diī cuneé nī nduucú 'nū, ti cuuvi chíinū yeⁿ'e nī. 'Āā cuɛ́ɛ́ cuuvī 'da'ā. Tuu'mi ní Jesús cueⁿ'e yā ndúúcū saⁿ'ā s'eeⁿ cuaaⁿ chɛɛti va'āī ní canée yā ndúúcu sa. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Taachí Jesús miiⁿ vɛɛ yā na mesa ní che'é yā ndúúcū 'iiⁿ'yāⁿ s'eeⁿ, tuu'mi ní sta'á yā pan ní caⁿ'angua'á yā ní ca'a yā gracias Ndyuūs caavā pan miiⁿ. Ní n'dee yā pan ní ca'a yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tuu'mi nūuⁿ saⁿ'ā s'eeⁿ iintiinaaⁿ sa Jesús miiⁿ, naati Jesús ndaanaáⁿ yā yeⁿ'e saⁿ'ā s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ní saⁿ'ā s'eeⁿ ngaⁿ'a sa ngiī sa vi'ī: ¿'Áá nguɛ́ɛ́ chicadiinuuⁿ yú na staava yeⁿ'e yú chi ya'ai taachi snúuⁿ yú yúúní taachí índeé yā ndúúcu yú, ní ngi'cueéⁿ yā nduudu yeⁿ'é Ndyuūs s'uuúⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hora mííⁿ nūuⁿ nducueeⁿ sa ní cunaⁿ'á sa na yáāⁿ Jerusalén. Ní ndaaca sa ndu'ū ndiicháámá apóstoles ndúúvídaama yā ndúúcū tanáⁿ'ā 'iiⁿ'yāⁿ chi snée yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'Iiⁿ'yāⁿ s'eeⁿ ní ngaⁿ'a yā nguaaⁿ maáⁿ yā: Cuaacu nííⁿnyúⁿ Jesús nduuchi yā nguaaⁿ tináⁿ'ā ní che'enaáⁿ yā yeⁿ'e Simón. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tuu'mi ní 'uuvi saⁿ'ā s'eeⁿ ní caⁿ'a yā táácā chiī yúúní chi cueⁿ'e yā. Tiī ní iintiinaáⁿ Jesús miiⁿ taachí n'deé yā pan. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Taachí saⁿ'a s'eeⁿ ngaⁿ'a sa chuū, Jesús miiⁿ ní cheⁿ'e naáⁿ yā naavtaⁿ'a 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'á yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuuví 'diīíⁿ ndúúcū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tuu'mi ní 'iiⁿ'yāⁿ s'eeⁿ dii'yá yā chiī ti nadicádíínuuⁿ yā chí n'diichi yā 'aama espíritu. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naati Jesús miiⁿ caⁿ'á yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ cúúví chí dii'yá nī chiī? ¿Dɛ'ɛ̄ cúúví chí 'tíícā nadacádíínuuⁿ nī na staava yeⁿ'e nī? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cuin'diichí nī ta'á ndúúcū ca'á. 'Úú maáⁿ chuū. Cuituu'ví nī 'úú. Cuin'diichí nī. 'Úú nguɛ́ɛ́ 'aama espíritu tan'dúúcā chí nadacádíínuuⁿ nī. 'Áámá espíritu nguɛ́ɛ́ 'iini ní nguɛ́ɛ́ yuūtɛ̄ tan'dúúcā chi inaaⁿ ndís'tiī chi vɛ́ɛ́ yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Taachi Jesús caⁿ'a yā nduudú 'cūū, ch'iⁿ'i yā ta'a yā ndúúcū ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Naati 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ s'téénu yā ti yeenú n'dai yā ní ngeⁿ'e yiinu yā. Ní cáávā chuū Jesús caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: ¿'Áá nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ 'muuⁿ chi che'e yú? ");
INSERT INTO cuxNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tuu'mi ní ca'a yā 'áámá tááⁿ 'yaācā ndúúcū 'aama taaⁿ va'ai ndi'i. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Cristo miiⁿ ní sta'a yā ní che'e yā nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Ndúúdú 'cūū caⁿ'á taachi caneé ndúúcū ndís'tiī. Canéé chí cúúví cuaacu tanducuéⁿ'ē dendu'ū chi canéé nguūⁿ yeⁿ'ē 'úú na libro yeⁿ'é Ndyuūs chi canéé nguūⁿ na ley yeⁿ'ē Moisés ndúúcū yeⁿ'e profetas ndúúcū yeⁿ'e salmos. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tuu'mi ní Jesucristo diiⁿ yā chi tuumicadiinuuⁿ 'iiⁿ'yāⁿ s'eeⁿ chi canéé nguūⁿ na libro yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Tíícā canéé yeⁿ'ē 'úú chí Cristo 'úú. 'Tíícā canee chi 'cueenú cuuvi ní 'cuūví. Ní nduuchí yeⁿ'e nguaaⁿ tináⁿ'ā ndii chíí ndii 'íínú nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ní 'iiⁿ'yāⁿ s'eeⁿ canéé chí caaⁿ'maⁿ yā nduudu miiⁿ chi ndaacadaami 'iiⁿ'yāⁿ yeⁿ'ē nuuⁿndi yeⁿ'e yā vmnaaⁿ núúⁿmáⁿ na yáāⁿ ní Ndyuūs nadach'ɛɛcú yā nuuⁿndi yeⁿ'e yā cáávā chi duuchí. Ní vmnááⁿ vmnaaⁿ nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén. Cuayiivi yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e núúⁿmáⁿ naciones yeⁿ'e íⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ndís'tiī ní cuuví nī testigos yeⁿ'e chuū ti n'diichí nī chuū ní canéé chí caaⁿ'máⁿ nī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Cuin'diichí nī. 'Úú dicho'ó Espíritu N'dai yeⁿ'é Ndyuūs chi caⁿ'ā Chiidá chi ndaā nanááⁿ ndís'tiī. 'Cuɛɛtinéé nuúⁿ nī na yáāⁿ Jerusalén ndíí chí ndaāca nī poder yeⁿ'e Ndyuūs, poder chí cuchiī yeⁿ'ē cuaaⁿ 'nííⁿnúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cheⁿ'e Jesús ndúúcū 'iiⁿ'yāⁿ s'eeⁿ na yáāⁿ 'lííⁿ Betania ní di'viicú yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Taachí ch'iinu di'viicú yā 'iiⁿ'yāⁿ s'eeⁿ, cueⁿ'é yā yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ ní cundaa yā va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Cuayiivi 'iiⁿ'yāⁿ s'eeⁿ dich'ɛɛtɛ́ yā Ndyuūs ní cunaⁿ'a ntuúⁿ yā na yáāⁿ Jerusalén. Ní neené yeenu taavi yā. ");
INSERT INTO cuxNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ní 'áámá chɛɛtinée yā na yaācū templo ní ngaⁿ'á yā chí ch'ɛɛtɛ Ndyuūs. Ní i'téénu yā Ndyuūs. 'Tíícā chiī.");
INSERT INTO cuxNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cuááⁿ nááchí chínga'a 'āā ngaⁿ'a Dendyuūs ndúúcū Nduudu, ní Nduudu mííⁿ 'āā ngaⁿ'ā ndúúcū Dendyuūs, ní Nduudu miiⁿ ní Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Chuū chíí naachi chínga'a ndúúcū Dendyuūs miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tanducuéⁿ'ē chi vɛɛ ní cucáávā 'iiⁿ'yāⁿ miiⁿ din'dái yā chi vɛ́ɛ́. Nduuti chi nguɛ́ɛ yā, nguɛ́ɛ́ vɛ́ɛ́ mar 'aama cosa chi vɛ́ɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","'Iiⁿ'yāⁿ miiⁿ canéé ndúúcū vida cueⁿ'e daāⁿmaⁿ ní vida miiⁿ ní dɛɛvɛ yeⁿ'e 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Níícú dɛɛvɛ chīdɛɛvɛ́ na maaíⁿ, chí maaiⁿ mííⁿ 'iiⁿ'yāⁿ nguɛɛ tuumicadíínuuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dendyuūs nidichó'o yā 'áámá saⁿ'ā, chi nguuvi sa Juan. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Saⁿ'ā miiⁿ ndaa sa chí caⁿ'a sa nduudu cuaacu. Ní caaⁿ'máⁿ sá nduudu cuaacu yeⁿ'e chi dɛɛvɛ caati nducyaacá yā cu'téénu yā cáávā saⁿ'ā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nguɛ́ɛ́ saⁿ'ā miiⁿ chi dɛɛvɛ; naati chi ngaⁿ'ā sa nduudu cuaacu yeⁿ'ē dɛɛvɛ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Chííⁿ chí nduudu cuaacu chí dɛɛvɛ. Chííⁿ nga'ā dɛɛvɛ yeⁿ'ē nducyáácá yā chi sneé yā íⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","'Iiⁿ'yāⁿ miiⁿ chi dɛɛvɛ ní canéé yā iⁿ'yeeⁿdí 'cūū, ní din'dái yā iⁿ'yeeⁿdī, ní 'iiⁿ'yāⁿ yeⁿ'e íⁿ'yeēⁿdī nguɛ́ɛ́ n'diichi yā 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ndaá yā caavā ndaata yeⁿ'é yā 'íícú 'iiⁿ'yāⁿ yeⁿ'é yā nguɛ́ɛ́ 'cuúⁿ yā chi canēe yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nducyáácá 'iiⁿ'yāⁿ chi 'cuúⁿ yā chi 'iiⁿ'yāⁿ miiⁿ canée yā nduucú yā, Ndyuūs ca'a yā poder 'iiⁿ'yāⁿ miiⁿ chi cuuvi daiya Dendyuūs 'iiⁿ'yāⁿ, 'iiⁿ'yāⁿ chi i'téénu yā chi ngúúví yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nguɛ́ɛ́ cuuvi yā daiya yā cáávā yuūúⁿ, ní nguɛ́ɛ́ caava yuūtɛ̄, ní nguɛ́ɛ́ caavā isáⁿ'ā, caati cáávā 'iivú Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Níícú Nduudu miiⁿ ní ch'iindiyáaⁿ yā tan'dúúcā s'uuúⁿ ní canée yā ndúúcū s'uuúⁿ. N'dáí taavi yā ndúúcū favor ndúúcū nduudu cuaacu. Ní n'diichi yú poder yeⁿ'é yā, poder tan'dúúcā yeⁿ'ē 'áámá n'dyáⁿ'ā yeⁿ'ē Chiidá yā chi Dendyuūs miiⁿ. Ndiituú taaví yā ndúúcū favor ndúúcū nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan caⁿ'a sa nduudu cuaacu yeⁿ'é yā ní 'caī sa ní ngaⁿ'ā sa yeⁿ'e 'iiⁿ'yāⁿ 'cúū: 'Iiⁿ'yāⁿ chi cuchií yā cuaaⁿ daamí ní vmnaaⁿ cá yā yeⁿ'ē 'úú caati 'āā 'naaⁿ cá yā niicu 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Níícú nducyaaca yú ita'a yú favor ndúúcū favor yeⁿ'ē Jesús chi ndiituú yā ndúúcū favor. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Caati vɛ́ɛ́ ley miiⁿ cucáávā Moisés ca'a yā naati vɛ́ɛ́ favor ndúúcū nduudu cuaacu cucáávā Jesucristo ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ n'diichí yā Dendyuūs miiⁿ. Jesús 'áámá n'dyáⁿ'ā yeⁿ'ē Chiidá yā chi canéé nduucú yā, Jesús mííⁿ diíⁿ yā chi 'iiⁿ'yāⁿ deenú yā yeⁿ'ē Chiidá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Taachi 'iiⁿ'yāⁿ Israel yeⁿ'e yáāⁿ Jerusalén dichó'o yā chiiduú s'eeⁿ ndúúcū 'iiⁿ'yāⁿ levitas s'eeⁿ ní ndaá yā nanááⁿ Juan miiⁿ chí itiinguunéeⁿ yā: ¿Díí, du'ū dii? chuū chi nduudu cuaacu chi n'guɛɛcútaⁿ'ā Juan. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ní Juan miiⁿ ntumiiⁿnúⁿ yā ní nguɛ́ɛ́ cheēⁿdiitú yā ní caⁿ'a cuaacú yā: Nguɛ́ɛ́ 'úú chi Cristo. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ní natiinguunéeⁿ yā saⁿ'ā: ¿Du'ū dii, tuu'mi? ¿'Áá díí profeta Elías? Ngaⁿ'ā Juan: Nguɛ́ɛ́ 'úú. Ní natiinguunéeⁿ yā saⁿ'ā: ¿'Áá díí chi profeta? Ngaⁿ'ā ntúuⁿ sa: Nguɛ́ɛ́ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ngaⁿ'ā ntúuⁿ yā ngii yā saⁿ'ā: ¿Du'ū di, tuu'mi? Ní 'tíícā caaⁿ'máⁿ 'nū cuuvi 'nū 'iiⁿ'yāⁿ chi dichó'o yā nús'uu. ¿Dɛ'ɛ́ ngaⁿ'ā di yeⁿ'e maāⁿ di? ");
INSERT INTO cuxNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tuu'mí caⁿ'a Juan: 'Úú nduudu chi caⁿ'a na yáⁿ'āa naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ: Nan'guáaⁿ nī yúúní cuaacu yeⁿ'é Dendyuūs, tan'dúúcā chi ngaⁿ'a profeta Isaías miiⁿ naachi canéé nguūⁿ na libro yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","'Íícú 'iiⁿ'yāⁿ s'eeⁿ chi ndaá yā miiⁿ ní 'iiⁿ'yāⁿ yeⁿ'ē fariseos. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Níícú ntiinguuneéⁿ yā saⁿ'ā ní ngaⁿ'a yā ngii yā saⁿ'ā: ¿Dɛ'ɛ̄ cúúví chí ngɛɛdinúuⁿnīⁿ di, ndúúti chi dii nguɛ́ɛ́ Cristo dii, ní nguɛ́ɛ́ Elías dii, ní nguɛ́ɛ́ profeta 'cūū dii? ");
INSERT INTO cuxNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Níícú Juan nan'guɛɛcútaⁿ'a yā yeⁿ'é yā ní caⁿ'a ya: 'Úú ní ngɛɛdinúuⁿnīⁿ ndúúcu nuūⁿnīⁿ; naati nguaaⁿ ndís'tiī ní canéé 'áámá yā ní nguɛ́ɛ́ ináaⁿ nī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'Iiⁿ'yáⁿ 'cūū chi cuchii cuayiivi ní vmnaaⁿ ca yā yeⁿ'ē 'úú. Niicu 'úú nguɛɛ n'dai 'úú, chi cuuvi diíⁿ n'daatiīí yííⁿmáⁿ yeⁿ'e ndaacuú yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Cosa 'cūū chi chiī ná yáⁿ'āa Betábara na táámá lado yeⁿ'e yíícú Jordán, naachi Juan chɛ́ɛ́dinuūⁿnīⁿ sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chi dɛɛvɛ táámá nguuvi ní Juan n'diichi sa Jesús ndaá yā naachi canee sa, níícú ngaⁿ'ā sa: Cun'diichí nī. 'Íngaā Jesucristo chi nguuví yā 'Ííti Cuūchī yeⁿ'é Dendyuūs chi nadivíí yā nuūⁿndī yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e íⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Chuū chi ngaⁿ'á yeⁿ'é yā: Cuchii 'áámá saⁿ'ā cuayiivi yeⁿ'e 'úú níícú 'āā vmnaaⁿ sa yeⁿ'ē 'úú, caati 'āā 'naaⁿ ca sa niicu 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'Úú ní nguɛ́ɛ́ n'diichí 'iiⁿ'yāⁿ naati deenú chi snaaⁿ 'iiⁿ'yāⁿ Israel 'yā. Cáávā chuū 'úú cuchií ní ngɛɛdinuūⁿníⁿ ndúúcū nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan mííⁿ ní ngaⁿ'ā sa nduudu cuaacu: 'Úú ní n'diichí Espíritu N'dai yeⁿ'e Dendyuūs chi cuch'ééⁿ nanguuvi tan'dúúcā paloma ní ndaa vmnaaⁿ yeⁿ'é yā ní canéé yā ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'Úú nguɛ́ɛ́ n'diichí 'iiⁿ'yāⁿ miiⁿ naati 'iiⁿ'yāⁿ chi dichó'o yā 'úú chí ngɛɛdinuūⁿníⁿ ndúúcū nuūⁿníⁿ, 'iiⁿ'yāⁿ miiⁿ chi ngaⁿ'a yā ngii yā 'úú: Du'ū chí n'diichí di chi ndɛɛ̄ Espíritu N'dai yeⁿ'e Ndyuūs ní canée yā nduucú yā, 'iiⁿ'yáⁿ 'cūū chi ngɛɛdinúuⁿnīⁿ ndúúcū Espíritu N'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'Úú ní n'diichí ní ngaⁿ'a cuaacú chi chuū chi Daiya Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chi dɛɛvɛ táámá nguuvi canéé ntuūⁿ Juan ndúúcū 'uuvi discípulos yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ní inaaⁿ sa Jesús miiⁿ chi cachiicá yā cuaaⁿ miiⁿ. Ní ngaⁿ'ā sa: N'diichí nī. 'Íngaā Jesucristo chi nguuví yā 'Ííti Cuūchī yeⁿ'é Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ndúú 'uuvī discípulos yeⁿ'e Juan chi ch'iindiveéⁿ yā chiiⁿ chi ngaⁿ'ā sa, ní cueⁿ'é yā ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nguɛɛcundíī Jesús ní n'diichí yā chi n'dáa yā 'yā. Ní ngaⁿ'a yā ngiī yā 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ́'ɛ in'nuuⁿ di? Ngaⁿ'ā 'iiⁿ'yāⁿ s'eeⁿ ngii yā 'yā: Rabí (nduudu mííⁿ neⁿ'e caaⁿ'maⁿ chi Maestro), ¿tií canééⁿ vaacu dí? ");
INSERT INTO cuxNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Tuu'mi ngaⁿ'a yā ngīi yā saⁿ'ā: Cuchií nī níícú n'diichí nī. Ní ndaá yā ní n'diichí yā tii canée yā. Ní ch'ɛɛtinée yā nduucú yā nguuvi miiⁿ caati 'āā tandúú n'gɛɛcú cuūúⁿ chiīnū. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ní yeⁿ'e 'uuví yā chi ch'iindiveéⁿ yā yeⁿ'ē Juan ní cueⁿ'é yā ndúúcū Jesús. 'Áámá saⁿ'ā miiⁿ ní nguuvi sa Andrés 'diīnū Simón Pedro. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ni Andrés miiⁿ nndaacá sa maaⁿ 'díínu sa Simón ní ngaⁿ'a sa ngii sa sáⁿ'ā: Nndaaca 'nū Mesías miiⁿ (neⁿ'e caaⁿ'maⁿ nduudu miiⁿ chí Cristo). ");
INSERT INTO cuxNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ní candɛɛ̄ sa Simón nanááⁿ Jesús. Ní taachi Jesús miiⁿ n'gíínu yā saⁿ'ā miiⁿ, ní ngaⁿ'á yā: Díí Simón Pedro, daiya Jonás miiⁿ. Mááⁿ ní cu'neeⁿ yú chi duuchi Cefas (nduudu mííⁿ neⁿ'ē caaⁿ'maⁿ tuūú). ");
INSERT INTO cuxNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chi dɛ́ɛ́vɛ́ táámá nguuvi Jesús neⁿ'é yā caⁿ'a yā na yáⁿ'āa Galilea, ní cueⁿ'é yā. Ndaaca yā Felipe ní ngaⁿ'a yā ngii yā saⁿ'ā: Cuchíi di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ní yáāⁿ vaacú Felipe ní yeⁿ'ē yáāⁿ Betsaida ní dáámá yáāⁿ vaacú sa ndúúcū Andrés ndúúcū Pedro. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe mííⁿ nndaaca sá Natanael, níícú ngaⁿ'ā sa ngii sa sáⁿ'ā: 'Āā nndaacá 'nū Jesús daiya José yeⁿ'e yáāⁿ Nazaret. Dingúūⁿ Moisés yeⁿ'ē 'iiⁿ'yáⁿ 'cūū na ley, ní dingúūⁿ profetas yeⁿ'e 'iiⁿ'yáⁿ 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ní ngaⁿ'a Natanael: ¿'Áá vɛ́ɛ́ cosa chi n'daacā na yáāⁿ Nazaret? Ní ngaⁿ'ā Felipe miiⁿ: Cuchíi di ní n'diichi di. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús miiⁿ ní n'diichí yā Natanael chi cuchii sa nanáaⁿ yā. Ní ngaⁿ'á yā yeⁿ'ē sa: N'dííchí nī 'áámá saⁿ'ā chi cuaacu nííⁿnyúⁿ yeⁿ'ē ndaata Israel miiⁿ. Ní nguɛ́ɛ́ nginnche'ei sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ngaⁿ'a Natanael ngii sa 'iiⁿ'yāⁿ: ¿Tíí n'diichi di 'úú? Ní ngaⁿ'ā Jesús ngií yā saⁿ'ā: Taachi 'āā cuɛ́ɛ́ yaa'ví Felipe dii ní taachi canéé dí maaⁿ yáⁿ'á yeⁿ'e n'guíídīi yaaⁿ nguuvi, 'āā n'diichí díí. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ní nan'guɛɛcutáⁿ'ā Natanael miiⁿ ni ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ: Maestro, n'diī chí Daiya Dendyuūs miiⁿ. N'diī chí Rey yeⁿ'e Israel. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ní ngaⁿ'a Jesús ngii yā saⁿ'ā: ¿'Áá cáávā chí ngaⁿ'á ngií dii chi n'diichí dii maaⁿ n'guíídīi yaaⁿ nguuvi chi 'āā i'teenu di 'úú? Ch'ɛɛtɛ n'dai ca n'diichí dí dendú'ū nguɛ́ɛ́ ti chúū. ");
INSERT INTO cuxNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ní ngaⁿ'á yā ngii yā saⁿ'ā: Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngii dii. Ngúúví maaⁿ ní ngúúví chí cuíchiī cunéé chí n'diichi di chí nanguaāⁿ nanguuvi níícú ángeles yeⁿ'é Dendyuūs miiⁿ ní ngɛɛ yā ní ngua'á yā nanááⁿ Saⁿ'ā chi Daiya Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chiī ndii chííⁿ ndii 'íínú nguuvi miiⁿ ní ch'iindivaacú 'áámá 'iiⁿ'yāⁿ na yáāⁿ Caná yeⁿ'ē yáⁿ'āa Galilea. Ní miiⁿ cánéé chɛɛcú Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ní idiíⁿ yā invitar Jesús ndúúcū discípulos yeⁿ'é yā nááchí ch'iindivaacú 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ní ch'iinu vino yeⁿ'é yā. Ní chɛɛcú Jesús ngaⁿ'á yā ngii yā Jesús: 'Āā ntɛ́ɛ́ vino yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ní ngaⁿ'ā Jesús ngii yā chɛɛcú yā: ¿Dɛ'ɛ̄ caneé yeⁿ'é ndúúcū dii n'dataá? 'Āā cuɛ́ɛ́ ndaa hora yeⁿ'é miⁿniiⁿyuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Chɛɛcú yā miiⁿ ngaⁿ'á yā ngiī yā saⁿ'ā s'eeⁿ chi diiⁿ mandado: Dii sáⁿ'ā s'eeⁿ, diiⁿ di tan'dúúcā chi Jesús caaⁿ'máⁿ yā cuuví yā ndis'tíī. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Miiⁿ snéé níyaaⁿ 'cuutií n'gɛɛtɛ chi nin'dai ndúúcū tuūu chí ngɛɛ nuūⁿnīⁿ. 'Iiⁿ'yāⁿ naaⁿnú yā 'cuutií s'eeⁿ tan'dúúcā costumbre yeⁿ'e 'iiⁿ'yāⁿ Israel. 'Aama 'aama 'cuutií ch'ɛɛtɛ tunéēⁿ nn'geēⁿ nduuvi cuūuⁿ ngɛɛcu ndii 'áámá ciento litros yeⁿ'e nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ní ngaⁿ'a Jesús ngii yā saⁿ'ā chi idiiⁿ mandado: Diīcuutú nī ndúúcū nuūⁿnīⁿ 'cuutií n'gɛɛtɛ chí nin'dai ndúúcū tuūu. Ní 'iiⁿ'yāⁿ s'eeⁿ diīcuutú yā ndiituú n'dai ndúúcū nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ní ngaⁿ'á Jesús ngii yā saⁿ'ā s'eeⁿ chi idiiⁿ mandado: Tun'dáa nī naachi s'néēⁿ nuūⁿnīⁿ, ní tun'dáa nī nuūⁿnīⁿ, ni candɛ́ɛ nī nanááⁿ 'iiⁿ'yāⁿ chi chééⁿ ndii vmnaaⁿ yeⁿ'e 'viicū. Ní candɛ́ɛ yā ch'iⁿ'í yā na 'iiⁿ'yāⁿ chí chéeⁿndii vmnaaⁿ yeⁿ'e 'viicū. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ní taachi 'iiⁿ'yāⁿ chí chééⁿndii vmnaaⁿ yeⁿ'e 'viicū canéé yiinú yā nuūⁿnīⁿ chi 'āā ndii vino naati nguɛ́ɛ́ déénú yā tii ngiica vino miiⁿ. Naati 'iiⁿ'yāⁿ chi idiiⁿ mandado ní déénú yā caati cheⁿ'é yā nguai yā nuūⁿnīⁿ. Tuu'mi ní yaa'ví yā saⁿ'ā chi n'giindivaacu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ní ngaⁿ'á yā ngii yā saⁿ'ā chi n'giindivaacu: Tanducuéⁿ'ē saⁿ'ā miiⁿ dííncā vino chi n'dai ca nga'a sa vmnaaⁿ 'iiⁿ'yāⁿ. Ní taachi 'āā ndiitú yeⁿ'é yā, tuu'mi nnga'a sa vino chí nguɛ́ɛ́ n'dai ngi'i. Naati dii ní nnguaīn'dai di vino chi n'dai ndíí maaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chiiⁿ ní vmnááⁿ vmnaaⁿ señal chí diīⁿ Jesús ná yáāⁿ Caná yeⁿ'e yáⁿ'āa Galilea. Ní ch'iⁿ'i yā poder yeⁿ'é yā. Ní discípulos yeⁿ'é yā chi'teenú sa 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cho'o chuū ní cuinaⁿ'á Jesús ndúúcū chɛɛcú yā, ndúúcū 'díínu yā ndúúcū discípulos yeⁿ'é yā na yáāⁿ Capernaum. Ní duu'vī nguuví canéé yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ní 'āā snee niiⁿnuúⁿ nguuví chi ndaā 'viīcū yeⁿ'ē pascua yeⁿ'ē 'iiⁿ'yāⁿ Israel, ní cuchɛɛ Jesús na yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ní ndaacá yā chɛɛti cheendi chéēⁿ yáacu templo 'iiⁿ'yāⁿ s'eeⁿ chi ch'ɛɛtɛ́ yā n'diicuí yā 'itiindu ndúúcū 'iiti 'cuūchī ndúúcū palomas, ní ndaacá yā 'iiⁿ'yāⁿ chi inn̄'daaⁿ tuūmī. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Taachí Jesús din'dái yā cuerda ní dichó'o yā nducyáácá 'iiⁿ'yāⁿ chuva'āī cheendi cheēⁿ yaācū templo miiⁿ, ndúúcū 'iiti 'cuūchi s'eeⁿ ndúúcū 'itiindu s'ééⁿ. Ní ch'iinu ngéé yā tuūmī yeⁿ'é 'iiⁿ'yāⁿ s'eeⁿ chi inn̄'daaⁿ tuūmī ní chingúúⁿndaa yā mesas yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Níícú ngaⁿ'a Jesús ngii yā saⁿ'ā chi n'diicuí palomas: Divíi nī chuū 'muuⁿ ni nguɛ́ɛ́ diíⁿ nī va'āī yeⁿ'e Chiidá va'ai chi n'diicui 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Tuu'mí ní n'gaacu discípulos yeⁿ'é yā yeⁿ'e chi cánéé nguūⁿ na libro yeⁿ'e Ndyuūs chi vaādī n'diitɛ́ yeⁿ'ē vaacu di, ní di'cuiinú 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Níícú 'iiⁿ'yāⁿ Israel nan'guɛɛcutaⁿ'á yā ní caⁿ'a yā Jesús: ¿Dɛ'ɛ̄ señal chí cu'neeⁿ di nús'uū chi vɛ́ɛ́ poder yeⁿ'ē di chi diiⁿ di 'túúcā? ");
INSERT INTO cuxNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Nan'guɛɛcútaⁿ'ā Jesús ní caⁿ'a yā: Nadtuuví nī yáácū templo 'cūū ní 'iīnū nguuvi 'úú nadācueéⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tuu'mi caⁿ'a 'iiⁿ'yāⁿ Israel: Ch'ɛɛti na 'uūvī ngɛɛcu jaaⁿ ndúuyū chi n'dai yáácū templo 'cūū. Níícú dii, ¿'áá na 'iīnū nguuvi neⁿ'e di nādācueeⁿ di? ");
INSERT INTO cuxNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Naati Jesús caⁿ'a yā yeⁿ'ē yaācū templo chi cuerpo yeⁿ'ē maáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Taachi Jesús nanduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā tuu'mi discípulos yeⁿ'é yā nan'gaacú yā chí caⁿ'a yā chuū. Ní i'téénu yā chí canéé nguūⁿ na libro yeⁿ'é Dendyuūs ndúúcū nduudu chi ngaⁿ'a Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Taachi Jesús canée yā yáāⁿ Jerusalén, nguuvi 'viicú yeⁿ'e pascua neené 'yaáⁿ yā chi'téénu yā Jesús caati 'āā n'diichí yā señales chi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Naati maaⁿ Jesús miiⁿ ní nguɛ́ɛ́ ngíí chɛɛtinuúⁿ yā 'iiⁿ'yāⁿ s'eeⁿ caati déénú Jesús yeⁿ'e nducyáácá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ní nguɛ́ɛ́ neⁿ'é yā chi ndii 'áámá 'iiⁿ'yāⁿ caaⁿ'maⁿ cuaacu yeⁿ'e saⁿ'ā ti deenú yā dɛ'ɛ chi canéé ndúúcū saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Níícú canee 'áámá sáⁿ'ā yeⁿ'ē fariseos chi nguuvi sa Nicodemo. Saⁿ'ā miiⁿ, saⁿ'ā chi chééⁿndii vmnááⁿ 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sáⁿ'a 'cūū nndaa sa nanááⁿ Jesús nguiīnū miiⁿ. Níícú ngaⁿ'a sa ngii sá 'iiⁿ'yāⁿ: N'diī Maestro, déénú 'nū chi ndaá nī yeⁿ'é Dendyuūs chi lado yeⁿ'e maestro caati mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi diíⁿ yā señales chi idiíⁿ nī ndúúti chi nguɛ́ɛ́ canee Dendyuūs ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús ní nan'guɛɛcútaⁿ'á yā ní ngaⁿ'a yā ngii yā saⁿ'ā: Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií dii, du'ū chi nguɛ́ɛ́ nguɛɛcundíī 'cundiyaāⁿ táámá vmnéⁿ'ēe nguɛ́ɛ́ cuuví n'diichí yā naachi 'iivú Dendyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ní ngaⁿ'ā Nicodemo ngii sa Jesús: ¿Táácā nanguɛɛcundíī 'áámá 'iiⁿ'yāⁿ saⁿ'ā ndiicúū 'cuundiyáaⁿ ntuúⁿ yā? ¿Táácā cuuví nuuⁿ ndáá ntuúⁿ yā na chɛɛti chɛɛcú yā ní 'cuundiyáaⁿ ntuúⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús ngaⁿ'a yā ngii yā saⁿ'ā: Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií dii, du'ū chi nguɛ́ɛ́ 'cuundiyáaⁿ yā cáávā nuūⁿnīⁿ ní cáávā Espíritu N'dai yeⁿ'e Ndyuūs nguɛ́ɛ́ cuuvi cundáa yā naachi canéé 'iivú Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Du'u chí ch'iindiyáāⁿ yeⁿ'e 'iiⁿ'yāⁿ, 'iiⁿ'yāⁿ canee ndúúcū. Níícú du'ū chi ch'iindiyáāⁿ yeⁿ'ē Espíritu, espíritu canee ndúúcū. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nguɛ́ɛ́ caⁿ'ā yiinu di chí ngaⁿ'á ngií dii chí nducyaaca 'iiⁿ'yāⁿ cánéé chí 'cuundiyáāⁿ ntúuⁿ yā taama. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","'Yúúné ní na neⁿ'e miiⁿ ngéenū. Níícú n'giindiveeⁿ di chi ngeēnū. Ní nguɛ́ɛ́ déénu di tií chiīcā tií caⁿ'ā. 'Tíícā nducyáácá 'iiⁿ'yāⁿ chi 'niindiyáaⁿ yā yeⁿ'e Espíritu N'dai yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ní nan'guɛɛcútaⁿ'ā Nicodemo yeⁿ'é yā ní ngaⁿ'a sa ngii sa Jesús: ¿Táácā cuuví chuū? ");
INSERT INTO cuxNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nan'guɛɛcútaⁿ'ā Jesús ní ngaⁿ'á yā ngiī yā sáⁿ'ā: ¿'Áá díí maestro yeⁿ'ē 'iiⁿ'yāⁿ Israel ní nguɛ́ɛ́ deenu di chuū? ");
INSERT INTO cuxNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií dii chi déénu 'nū chii chi ngaⁿ'a 'nū. Níícú chi n'diichí 'nū chii chi ngaⁿ'a cuaacu 'nū ní nguɛ́ɛ́ n'diichí 'nu chii chi ngaⁿ'ā cuaacu 'nū. Níícú nguɛ́ɛ́ 'caandiveeⁿ di chi caaⁿ'maⁿ 'nū nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nduuti chi ngaⁿ'á cosa chi vɛ́ɛ́ iⁿ'yeeⁿdí 'cūū niicu nguɛ́ɛ́ i'téénu dí, ¿táácā cu'téénu di nduuti chi caaⁿ'máⁿ cosa chi vɛ́ɛ́ na va'ai chɛɛti nguūvī? ");
INSERT INTO cuxNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ndii 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ chɛɛ yā na va'ai chɛɛti nguuvi nduuti chi nguɛ́ɛ́ 'iiⁿ'yāⁿ chi ch'eēⁿ yeⁿ'e va'ai chɛɛti nguuvi. 'Iiⁿ'yāⁿ miiⁿ, Sáⁿ'ā chi Daiya Dendyuūs, chi canéé na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tan'dúúcā Moisés miiⁿ chinadācuéeⁿ sa cúú na yáⁿ'āa cuūⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ 'tíícā canee chí nicueēⁿ Saⁿ'a chi Daiyá Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Caati nducyaaca 'iiⁿ'yāⁿ chi cu'téénu yā 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi ndái yā caati cunduuchí yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Caati chuū dínéⁿ'e Dendyuūs 'iiⁿ'yāⁿ yeⁿ'e íⁿ'yeēⁿdī chí dichó'o yā 'aama n'dyáⁿ'ā Daiya yā, caati nducyáácá 'iiⁿ'yāⁿ chí cu'téénu yā 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi ndái yā. Níícú cunduuchí yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Caati Dendyuūs ní dicho'ó yā Daiyá yā iⁿ'yeeⁿdī chi Daiyá yā nguɛ́ɛ́ diiⁿ yā juzgar 'iiⁿ'yāⁿ chi snéé iⁿ'yeeⁿdī, naati chi cuchii yā nadanguáⁿ'ai yā 'iiⁿ'yāⁿ yeⁿ'e íⁿ'yeeⁿdī cááva yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Du'u chi i'téénu 'iiⁿ'yāⁿ nguɛ́ɛ́ condenado yā, niicu du'u chi nguɛ́ɛ́ i'téénu 'iiⁿ'yāⁿ 'āā condenado yā caati nguɛ́ɛ́ chi'teenu chi nduuchi 'áámá n'dyáⁿ'ā yeⁿ'ē Chiidá yā chi Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Níícú chuú ní condenación. Chí dɛɛvɛ 'cūū ndaá iⁿ'yeeⁿdí 'cūū naati saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū dinéⁿ'e sa na maaiⁿ nguɛ́ɛ́ ti chí dɛɛvɛ caati diiⁿ sa chí nguɛ́ɛ́ n'daacā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Caati nducyáácá 'iiⁿ'yāⁿ chi diíⁿ yā chi nguɛɛ n'daacā, nguɛ́ɛ́ dinéⁿ'e yā chí dɛɛvɛ. Ní nguɛɛ indaá yā chi dɛɛvɛ miiⁿ caati nguɛ́ɛ́ neⁿ'e yā chi cuuvi déénú 'iiⁿ'yāⁿ ní caaⁿ'maⁿ 'iiⁿ'yāⁿ chí nuuⁿndí yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Naati 'iiⁿ'yāⁿ chi diíⁿ yā ntiiⁿnyuⁿ chi n'daacā, índaá yā naachi chí dɛɛvɛ caati 'iiⁿ'yāⁿ snáaⁿ yā ntiiⁿnyuⁿ yeⁿ'é yā chi yeⁿ'ē Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Cho'ōo chúū, ndaā Jesús ndúúcū discípulos yeⁿ'é yā na yáⁿ'āa Judea. Ní cunée yā ndúúcū 'iiⁿ'yāⁿ s'eeⁿ. Níícú Jesús chɛɛdinúūⁿniⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ní Juan mííⁿ ngɛɛdinuūⁿnīⁿ ntúuⁿ yā na yáāⁿ Enón niiⁿnuúⁿ na yaāⁿ Salim ti mííⁿ neené vɛɛ ca nuūⁿnīⁿ. Ní ndaā 'iiⁿ'yāⁿ ní chɛɛ̄dinúūⁿniⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Caati Juan miiⁿ 'āā cuɛ́ɛ́ cunúuⁿ yā vácūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Discípulos yeⁿ'ē Juan ch'ɛɛcu cheendí yā ndúúcū 'iiⁿ'yāⁿ Israel yeⁿ'é táácā 'iiⁿ'yāⁿ nduuvi dɛɛvɛ́ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Níícú nndaa sá nanááⁿ Juan ní ngaⁿ'a sa ngiī sa saⁿ'ā: Dii, Maestro, 'iiⁿ'yāⁿ chi canéé ndúúcu di na táámá lado yeⁿ'ē yíícú Jordán 'iiⁿ'yāⁿ chí díí caaⁿ'maⁿ cuaacu di yeⁿ'é yā; n'diichi di, 'iiⁿ'yāⁿ miiⁿ ngɛɛdinuūⁿniⁿ yā. Niicu nducyáácá 'iiⁿ'yāⁿ ndaa yā nanáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nan'guɛɛcútaⁿ'ā Juan ní caⁿ'a sa: Nguɛ́ɛ́ cúúví cuta'a 'iiⁿ'yāⁿ dɛ'ɛ̄ vɛɛ nduuti chi nguɛ́ɛ́ cuchiī yeⁿ'e va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ndís'tiī testigo yeⁿ'é chi caⁿ'á: 'Úú ní nguɛ́ɛ́ Cristo 'úú, caati dichó'o Dendyuūs 'úú vmnaaⁿ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Du'ū chi vɛ́ɛ́ n'daataá yeⁿ'e yā, 'iiⁿ'yāⁿ miiⁿ ní isáⁿ'ā yeⁿ'ē tá. Amigo yeⁿ'ē isáⁿ'ā miiⁿ ní 'iiⁿ'yāⁿ chi cánéé ndúúcu yā ní n'giindiveéⁿ yā yeⁿ'é yā. Yeenú taavi yā cáávā nduudu yeⁿ'ē isáⁿ'ā miiⁿ. 'Tíícā vaadi yeenu yeⁿ'é ní 'áámá ndiītuú taaví ca. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","'Iiⁿ'yāⁿ miiⁿ ní canéé chi ch'ɛɛtɛ́ yā, niicu 'úú dánduu'vi 'lííⁿ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Du'ū chí nndaā yeⁿ'ē va'ai chɛɛti nguuvi ch'ɛɛtɛ ca yeⁿ'ē nducyaaca 'iiⁿ'yāⁿ. Du'ū chi yeⁿ'e yáⁿ'āa ní yeⁿ'ē yáⁿ'āa ni ngaⁿ'a yeⁿ'ē cosas yeⁿ'ē yáⁿ'āa. 'Iiⁿ'yāⁿ chi nndáa yā yeⁿ'ē va'ai chɛɛti nguuvi, ch'ɛɛtɛ cá yā yeⁿ'ē nducyáácá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","'Iiⁿ'yāⁿ miiⁿ ngaⁿ'a cuaacú yā yeⁿ'ē chi n'diichí yā ndúúcū chi ch'iindiveéⁿ yā ní mar 'áámá 'iiⁿ'yāⁿ ní nguɛ́ɛ́ neⁿ'é yā 'caandiveéⁿ yā nduudu cuaacu yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","'Iiⁿ'yāⁿ chi n'gúuⁿ yā nduudu cuaacu yeⁿ'e Jesús nduuvidaamá yā ndúúcu yā ní ngaⁿ'a yā chi Dendyuūs miiⁿ chi cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Du'ū chí Dendyuūs dichó'o yā, 'iiⁿ'yāⁿ miiⁿ ngáⁿ'a yā nduudu yeⁿ'e Dendyuūs miiⁿ, caati Dendyuūs nga'a yā 'iiⁿ'yāⁿ Espíritu N'dai yeⁿ'e Ndyuūs nguɛ́ɛ́ ndúúcū caadi. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dendyuūs Chiida yú dinéⁿ'e yā Daiyá yā. Níícú tanducuéⁿ'ē dendu'ū ca'á yā ta'ā Daiyá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","'Iiⁿ'yāⁿ chi i'téénu yā Daiya Dendyuūs miiⁿ canée yā ndúúcū vida cueⁿ'e daāⁿmaⁿ. Naati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ i'téénu yā Daiya Dendyuūs miiⁿ nguɛ́ɛ́ snaaⁿ yā vida cueⁿ'e daāⁿmaⁿ miiⁿ naati caⁿ'á yā cuta'á yā castigo yeⁿ'e Dendyuūs chi diituú n'dai. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tááchí Jesús ituumicádiinuuⁿ yā 'tíícā chi saⁿ'ā fariseos ch'iindiveeⁿ sa chííⁿ chí Jesús diíⁿ yā ní chí chɛɛdinuūⁿniⁿ yā 'yaaⁿ ca 'iiⁿ'yāⁿ ní vɛ́ɛ́ 'yaaⁿ ca discípulos yeⁿ'é yā nguɛ́ɛ́ ti Juan miiⁿ; ");
INSERT INTO cuxNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","'áárá chí nguɛ́ɛ́ Jesús chi ngɛɛdinuūⁿniⁿ yā caati discípulos yeⁿ'e yā ngɛɛdinuūⁿniⁿ yā; ");
INSERT INTO cuxNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús s'néeⁿ yā yáⁿ'āa Judea ní cheⁿ'e ntuúⁿ yā yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ni canéé chi cho'ó yā yáⁿ'āa Samaria. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ní ndaá yā na 'áámá yáāⁿ yeⁿ'ē Samaria chi nguuvi Sicar, niiⁿnuúⁿ ná yáⁿ'āa chí ca'a Jacob yeⁿ'ē daiya sa José. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ní mííⁿ canéé vaacunuūⁿnīⁿ yeⁿ'ē Jacob. Jesús chicúúⁿnu yā chi ngiica yā ní ch'iindí yā niiⁿnuúⁿ na vaacunuūⁿnīⁿ. Ní 'āā tanduu n'gɛɛcu ndiichuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ndaā 'áámá n'daataá yeⁿ'ē yáⁿ'āa Samaria chi sta'a tá nuūⁿnīⁿ. Ní Jesús caⁿ'a yā chii yā táⁿ'ā: Díí n'daataá, téé dí tíí nuūⁿnīⁿ cu'ú. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Discípulos yeⁿ'é yā cueⁿ'ē sa yáāⁿ Sicar chi cuaī sa chi che'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ní n'daataá yeⁿ'ē yáⁿ'āa Samaria ngaⁿ'a tá ngii tá Jesús: ¿Táácā chi ngiica di nuūⁿnīⁿ chi cu'u di 'úú ti dii ní 'iiⁿ'yāⁿ Israel dii niicu 'úú yeⁿ'ē yáⁿ'āa Samaria 'úú? Saⁿ'ā Israel s'eeⁿ ní nguɛ́ɛ́ n'diichi sa 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Samaria. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ní n'guɛɛcútaⁿ'a Jesús, ní ngaⁿ'a yā ngii yā táⁿ'ā: Ndúúti chí n'diichi di regalo yeⁿ'e Dendyuūs miiⁿ, ní du'ū chí ngaⁿ'ā ngii dii, tee di nuūⁿnīⁿ cu'ú, tuu'mi ní caaca di nuūⁿnīⁿ yeⁿ'é yā. Ní 'iiⁿ'yāⁿ miiⁿ caⁿ'a yā teé yā nuūⁿnīⁿ chi cu'u di, nuūⁿnīⁿ chi diiⁿ chi canduuchi 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","N'daataa mííⁿ ní ngaⁿ'a tá ngii tá Jesús: Señor, nguɛ́ɛ́ dɛ'ɛ̄ chi cuta'á nduucú nī tíí vaacunuūⁿnīⁿ yáanūuⁿ. ¿Tií cuuvi canguaí nuūⁿnīⁿ yeⁿ'é nī chi diiⁿ chi canduuchi 'iiⁿ'yāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿'Áá vmnaaⁿ ca n'diī yeⁿ'ē chiida 'nū Jacob? 'Iiⁿ'yāⁿ miiⁿ din'dái yā vaacunuūⁿniⁿ 'cūū cáávā nús'uu. 'Múúⁿ sta'á yā nuūⁿnīⁿ ndúúcū daiya yā ndúúcū 'iiti yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nan'guɛɛcútaⁿ'a Jesús ngaⁿ'a yā ngii yā táⁿ'ā: Nducyáácá 'iiⁿ'yāⁿ chi ngi'i yā nuūⁿniⁿ 'cūū canéé chi cuuvi yaaca ntúuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Naati du'ú 'iiⁿ'yāⁿ chi cú'u yā nuūⁿnīⁿ chi 'úú chi ca'á, 'āā ntɛ́ɛ́ cuuvi yaacá yā. Nuūⁿnīⁿ chi 'úú ca'á 'iiⁿ'yāⁿ mííⁿ, nuūⁿnīⁿ miiⁿ tan'dúúcā chí cuuvi nduucú yā 'áámá vaacunuūⁿnīⁿ chi ngáāa nuūⁿnīⁿ miiⁿ yeⁿ'é yā caavā vida cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","N'daataá miiⁿ ní ngaⁿ'a tá ngii tá Jesús: Dii Señor, tée nī 'úú nuūⁿniⁿ 'cūū. Cu'ú ní 'aa ntɛ́ɛ́ cuuvi yaacá, ní 'aa ntɛ́ɛ́ chií cuta'á nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús ngaⁿ'a yā ngii yā táⁿ'ā: Cuéⁿ'é dí ní cananguaī di isaⁿ'ā yeⁿ'ē di. Ní cuchii di ndúúcū sa 'muuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","N'guɛɛcútaⁿ'a n'daataa mííⁿ ní ngaⁿ'a tá ngii tá 'iiⁿ'yāⁿ: Nguɛ́ɛ́ isaⁿ'ā yeⁿ'é. Ngaⁿ'a Jesús ngii yā táⁿ'ā: N'daacā chi ngaⁿ'a di chi nguɛ́ɛ́ isaⁿ'ā yeⁿ'e di. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Caati nyuⁿ'u isaⁿ'ā canéé ndúúcū dii, ní saⁿ'ā chi canéé ndúúcū dii miⁿniiⁿyuⁿ nguɛ́ɛ́ isaⁿ'ā yeⁿ'e di. Chiiⁿ chuū ní ngaⁿ'ā cuaacú dí. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ngaⁿ'a n'daataá ngii ta Jesús: N'diī Señor, deenú chi n'diī ní 'áámá profeta n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chiida 'nū ní diíⁿ yā adorar ná cuɛ́ɛ́tí 'cūū naati 'iiⁿ'yāⁿ Israel chi judíos ngaⁿ'ā ntuuⁿ yā chí na yáāⁿ Jerusalén chi cánéé chi diíⁿ yā adorar Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ní ngaⁿ'ā Jesús ngii yā táⁿ'ā: N'daataá, cu'téénu di 'úú. Ndaā hora taachi ní nguɛ́ɛ́ cuɛɛti 'cūū ní nguɛ́ɛ́ yáāⁿ Jerusalén 'iiⁿ'yāⁿ diíⁿ yā adorar Chiida yú. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ndís'tiī ní diíⁿ nī adorar chi nguɛ́ɛ́ deenú nī. Nús'uū ní idiíⁿ 'nū adorar chi déénu 'nū naati vaadī nguaⁿ'ai ndaā lado yeⁿ'e 'áámá 'iiⁿ'yāⁿ chi nadanguáⁿ'āī ní yeⁿ'e 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Naati hora miiⁿ ní cúchiī níícú hora miiⁿ ní ndaā, taachi cuaacu nííⁿnyúⁿ 'iiⁿ'yāⁿ s'eeⁿ diíⁿ yā adorar Dendyuūs Chiida yú ndúúcū chidɛɛvɛ yeⁿ'é yā ndúúcū vaadī cuaacú. Caati 'tíícā Chiida yú mííⁿ in'nuúⁿ yā 'iiⁿ'yāⁿ chi diíⁿ yā adorar 'yā ni cu'téénu yā 'yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dendyuūs ní Espíritu 'yā. Ní 'iiⁿ'yāⁿ cánéé chi diíⁿ yā adorar 'yā cánéé chi diíⁿ yā adorar 'yā ndúúcū chidɛɛvɛ yeⁿ'é yā ndúúcū vaadī cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","N'daataá mííⁿ ngaⁿ'a ta ngiī ta Jesús: Deenú chí Mesías canéé chí ndaá chi duuchi Cristo. Taachí 'iiⁿ'yāⁿ miiⁿ ndaá yā, tuu'mí caaⁿ'maⁿ yā nducuéⁿ'ē cosas. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ní ngaⁿ'a Jesús ngii yā táⁿ'ā: 'Úú chi Cristo chi indeé ndúúcu di. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Taachí indeé yā ndúúcū n'daataá mííⁿ, ndáa discípulos yeⁿ'é yā. Ní cueⁿ'e yíínú sá chi indeé yā ndúúcū n'daataá miiⁿ. Mar 'áámá saⁿ'ā nguɛ́ɛ́ natiinguuneeⁿ sa Jesús: ¿Dɛ'ɛ̄ iⁿ'nuuⁿ di? ¿Dɛ'ɛ̄ cuuvi chi ndee di ndúúcu tá? ");
INSERT INTO cuxNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ní n'daataá mííⁿ ní s'neeⁿ tá 'cuuti cuéeé yeⁿ'e tá ní cueⁿ'ē tá ná yáāⁿ miiⁿ. Ní caⁿ'a tá chii tá 'iiⁿ'yāⁿ s'eeⁿ: ");
INSERT INTO cuxNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Cuchií nī ní n'diichí nī 'áámá saⁿ'ā chi caⁿ'a sa chii sa 'úú tanducuéⁿ'ē chi n̄diíⁿ. ¿'Áá nguɛ́ɛ́ 'iiⁿ'yāⁿ miiⁿ chi Cristo? ");
INSERT INTO cuxNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ní 'iiⁿ'yāⁿ s'eeⁿ can'dáa yā na yáāⁿ miiⁿ. Cueⁿ'e yā n'diichí yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ní taachi cueⁿ'ē n'daataa mííⁿ na yáāⁿ tuu'mi ní discípulos yeⁿ'é yā ngaⁿ'a sa ngii sá Jesús: N'diī Maestro, che'é nī yuūndū nduucú 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ni Jesús miiⁿ ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: 'Úú ní vɛ́ɛ́ 'áámá comida yeⁿ'é chi che'é. Ndís'tiī nguɛ́ɛ́ déénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Níícú discípulos ngaⁿ'a sa ngii sa vi'ī: ¿'Áá ndaā 'iiⁿ'yāⁿ chi cuú yā chí che'é yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ní ngaⁿ'a Jesús ngiī yā saⁿ'ā s'eeⁿ: Comida yeⁿ'é chííⁿ chí cuuví diíⁿ tan'dúúcā chí neⁿ'ē 'iiⁿ'yāⁿ chi dichó'o yā 'úú. Ní di'cuiinú ntiiⁿnyuⁿ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ngaⁿ'a ndis'tiī: ¿'Áá nguɛ́ɛ́ vɛ́ɛ́ cá tá cuūuⁿ 'iīyū taachi ndaá tiempo yeⁿ'ē cosecha? N'diichí nī. 'Úú ngaⁿ'á ngií ndís'tiī: N'diichí nī cuaaⁿ 'niiⁿnuⁿ. Snaáⁿ nī cuɛ́ɛ́tí yeⁿ'é nī. 'Āā ndaa nguuvi chi diíⁿ nī cosechar. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","'Iiⁿ'yāⁿ chi nadacuéeⁿ yā cosecha vɛɛ chii'vɛ̄ɛ yeⁿ'é yā. Ní vɛ́ɛ́ n'gui'i yeⁿ'é yā chi cūnee cueⁿ'e daāⁿmaⁿ. Níícú 'iiⁿ'yāⁿ chí niīnu yā ndúúcú 'iiⁿ'yāⁿ chi nadacuéeⁿ yā cosecha ní nduu 'uuví yā yeenú taaví yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Caati chuū chi cuaacu nííⁿnyúⁿ chi nduudu cuaacu: 'Áámá 'iiⁿ'yāⁿ ní ngīīnu yā ni táámá yā ní nadacuéeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'Úú nidicho'ó ndís'tiī ní nadacuéeⁿ nī cosecha chi nguɛ́ɛ́ n̄diíⁿ nī ntiiⁿnyuⁿ. Táámá yā diíⁿ yā ntiiⁿnyuⁿ. Ní ndís'tiī chi ndaá nī tuu'ví nī ntiiⁿnyuⁿ n̄diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ni neené 'yaaⁿ 'iiⁿ'yāⁿ samaritanos yeⁿ'ē yáāⁿ miiⁿ s'teenú yā Jesús cucáávā nduudu yeⁿ'e n'daātāa miiⁿ chí caⁿ'a yā nduudu cuaacu: 'Iiⁿ'yāⁿ mííⁿ ní caⁿ'a yā chii yā 'úú tanducuéⁿ'ē cosa chi n̄diíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ndaa saⁿ'ā samaritanos nanááⁿ Jesús. Di'cuíítu sa 'iiⁿ'yāⁿ chi canée yā ndúúcu sa. Ní canée yā miiⁿ 'uuvi nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Neené 'yaaⁿ cá yā s'teenú yā cucáávā nduudu yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Níícú 'iiⁿ'yāⁿ s'eeⁿ ngaⁿ'a yā ngii yā n'daataá miiⁿ: 'Āā ntɛ́ɛ́ cu'teenú 'nū caavā chi ch'iindiveéⁿ 'nū chi cuaacu nííⁿnyúⁿ nguɛ́ɛ́ dámaaⁿ yeⁿ'e chi ngaⁿ'ā di. Caati maáⁿ 'nū n'diichí 'nū ní ch'iindiveéⁿ 'nū chi cuaacu nííⁿnyúⁿ chi 'iiⁿ'yáⁿ 'cūū nguuvi Cristo chi inadan'guáⁿ'ai yā 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ch'íínú 'uuvi nguuvi ní Jesús cueⁿ'é yā yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Caatí maaⁿ Jesús miiⁿ caⁿ'a cuaacú yā chi 'iiⁿ'yāⁿ nguɛ́ɛ́ diíⁿ yā honrar 'áámá 'iiⁿ'yāⁿ profeta taachi ngaⁿ'a yā yáāⁿ vaacú yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ní ndaá yā yáⁿ'āa Galilea ní 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Galilea miiⁿ tuu'mi di'cuúⁿ yā chi caneé yā. 'Āā n'diichí yā tanducuéⁿ'ē chi diíⁿ yā na yáāⁿ Jerusalén, nguuvi yeⁿ'e 'viicu yeⁿ'e pascua, caati 'iiⁿ'yāⁿ s'uúⁿ cheⁿ'e ntuúⁿ yā 'viicu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ndaa ntúūⁿ Jesús na yáāⁿ Caná yeⁿ'e yáⁿ'āa Galilea naachi din'dái yā vino ndúúcú nuūⁿnīⁿ. Mííⁿ canéé 'áámá rey yeⁿ'e yáāⁿ Capernaum. Ngiītā 'áámá daiya rey miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","'Iiⁿ'yáⁿ 'cūū mííⁿ ch'iindiveéⁿ yā chí ndaā Jesús yeⁿ'ē yáⁿ'āa Judea na yáⁿ'āa Galilea. Cheⁿ'é yā nanááⁿ Jesús ní di'cuíítu yā 'yā chi caⁿ'a yā n'diichí yā daiya sa chi nanduūvā yeⁿ'ē caati 'aa cháā 'cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tuu'mi ní ngaⁿ'ā Jesús ngii yā saⁿ'ā: Ndúúti chi nguɛ́ɛ́ snaaⁿ di señales ndúúcū milagros chi vaadī n'giinu nguɛ́ɛ́ cu'téénu di. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","'Iiⁿ'yāⁿ yeⁿ'e rey ngaⁿ'á yā ngii yā Jesús: Señor, cú'u yú caati 'āā cuɛ́ɛ́ 'cuūvī saⁿ'ā 'lííⁿ yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ngaⁿ'ā Jesús ngii yā 'iiⁿ'yāⁿ: Cúnaⁿ'a di, daiya dí cánduuchi sa. Ní saⁿ'ā miiⁿ ní chi'téénu sa nduudu chí caⁿ'ā Jesús miiⁿ. Ní cuinaⁿ'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Taachi 'āā ndaa niiⁿnuúⁿ vaacu sa 'iiⁿ'yāⁿ chí idiiⁿ mandado yeⁿ'ē sa can'dáa yā n'diichi yā saⁿ'ā. Ní ngaⁿ'a yā ngii yā saⁿ'ā: Daiyá nī miiⁿ candúúchi sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tuu'mi ní itiinguunéeⁿ sa 'iiⁿ'yāⁿ s'eeⁿ: ¿Dɛ'ɛ̄ hora naachi cuaáⁿ yeⁿ'ē sa? Níícú ngaⁿ'a yā ngii yā saⁿ'a: 'Iicu taachi n'gɛɛcu 'áámá ní ch'iinu 'iⁿ'nūúⁿ miiⁿ sáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tuu'mi ní chiida saⁿ'ā 'lííⁿ miiⁿ tuumicádíínuuⁿ yā chi hora miiⁿ chi ngaⁿ'a Jesús ngii yā: Daiya dí ní cánduuchi sa. Ní 'iiⁿ'yāⁿ miiⁿ ndúúcū nducyaaca familia yeⁿ'e yā s'téénu yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Chuū ndii 'úúví señal chí Jesús diíⁿ yā cuayiivi chi ndáa yā yeⁿ'e yáⁿ'āa Judea ndii yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Chó'ōo tanducuéⁿ'ē cosa 'túúcā. Vɛ́ɛ́ 'áámá 'viicu yeⁿ'ē 'iiⁿ'yāⁿ Israel. Níícu Jesús cuchɛ́ɛ yā yáāⁿ Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Mííⁿ canéé 'áámá viini ch'ɛɛtɛ niiⁿnuⁿ cheendi chéēⁿ, cuaaⁿ naachí indáa yā ndúúcū 'iiti cuūchī chí n'diicui yā na yáāⁿ Jerusalén. Viini ch'ɛɛtɛ miiⁿ nguuvi Betesda na nduudu hebreo. Vɛ́ɛ́ nyuⁿ'u corredor nuuⁿmaⁿ ndiivi viini ch'ɛɛtɛ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Na corredor miiⁿ ndiitú ndúúcū n'deēe n'dáí 'iiⁿ'yāⁿ ngíitā; 'iiⁿ'yāⁿ ngueenááⁿ, ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ ngii ngiicá yā, ndúúcū 'iiⁿ'yāⁿ chí ntí'ī ta'á yā o ca'a yā. 'Iiⁿ'yāⁿ miiⁿ canéé ngíínú yā chí in'nuⁿ'u nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Caati vɛɛ tiempo chi 'áámá ángel nch'eéⁿ yā níícú idi'núⁿ'u yā nuūⁿnīⁿ chi snéē ná viini ch'ɛɛtɛ. Ní cuayiivi 'iiⁿ'yāⁿ chi ndáa yā vmnááⁿ vmnaaⁿ chɛɛtí viini mííⁿ nanduuva yeⁿ'é yā yeⁿ'ē 'āā dɛ'ɛ́ nūuⁿ ca'āī chi ndii yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ní miiⁿ canéé 'áámá sáⁿ'ā ndiicú nditiiⁿ'yuⁿ 'iinu ndúuyū chí ngiītā sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Taachí Jesús n'diichí yā saⁿ'ā chi candíítí sá, níícú 'āā deenú yā chí 'āā 'naáⁿ ngíítā sa, tuu'mi ní ngaⁿ'a yā ngiī yā saⁿ'ā: ¿'Áá néⁿ'é dí chí nduūvā yeⁿ'ē di? ");
INSERT INTO cuxNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ní saⁿ'ā chi ngiītā miiⁿ nan'guɛɛcútaⁿ'ā sa yeⁿ'é yā: Señor, nguɛ́ɛ́ mar 'áámá saⁿ'ā chi cu'nuūⁿ sa 'úú chɛ́ɛ́ti viinī taachi í'nuⁿ'u nuūⁿnīⁿ. Caati taachí ndaá, 'āā ndáā taamá yā chɛɛtí viīnī. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ní ngaⁿ'a Jesús ngii yā saⁿ'ā: Nacuéeⁿ di. Nadacuéeⁿ di yiivɛ yeⁿ'ē di ní cúnaⁿ'a di. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tuu'mí nūuⁿ nduūvā yeⁿ'ē sa. Ní nadacuéeⁿ sa yiivɛ yeⁿ'ē sa. Ní cunaⁿ'a sá. Ní nguuvi miiⁿ ní sábado nguuvi chí ntaavi'tuunúuⁿ 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Níícú 'iiⁿ'yāⁿ Israel ngaⁿ'a yā ngiī yā saⁿ'ā chí 'āā nanduuvá yeⁿ'ē sa: Caati maaⁿ ní sábado miiⁿ, tan'dúúcā chi caⁿ'a ley, nguɛ́ɛ́ cuuví nandɛ́ɛ di yiivɛ yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ní n'guɛɛcútaⁿ'ā sa yeⁿ'é yā: 'Iiⁿ'yāⁿ chi diíⁿ yā chi nduuvā yeⁿ'é, 'iiⁿ'yāⁿ miiⁿ ní ngaⁿ'a yā ngii yā 'úú: Nadacuéeⁿ di yiivɛ yeⁿ'ē di. Ní cuinaⁿ'a di. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tuu'mi ní tiinguunééⁿ 'iiⁿ'yāⁿ Israel saⁿ'ā: ¿Du'ú chi 'tíícā ngaⁿ'ā ngii di: Nadacuéeⁿ di yiivɛ yeⁿ'e di, ní cuinaⁿ'a di? ");
INSERT INTO cuxNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Níícú saⁿ'ā chi 'āā nduuvá yeⁿ'ē sa nguɛ́ɛ́ déénú sá du'ū 'iiⁿ'yāⁿ miiⁿ, caati Jesús divíi yā yeⁿ'e saⁿ'ā miiⁿ. Ní neené n'deēe 'iiⁿ'yāⁿ snée yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Cuayiivi Jesús nandaacá yā saⁿ'ā na yáácū templo. Ní ngaⁿ'a Jesús ngii yā saⁿ'ā: Cun'dííchí dí maaⁿ 'āā nduuvá yeⁿ'ē di. 'Aa ntɛ́ɛ́ diiⁿ di nuuⁿndi niicu nguɛ́ɛ́ cuta'āa táámá ca'ai chi más cā taaⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tuu'mí saⁿ'ā miiⁿ cunaⁿ'ā sa ní caⁿ'a sa chii sa 'iiⁿ'yāⁿ Israel chi Jesús chi diíⁿ yā chi ndúúvā yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ni cáávā chuū ní can'dáā 'iiⁿ'yāⁿ Israel Jesús miiⁿ chí neⁿ'é sa 'caaⁿ'núⁿ sa 'iiⁿ'yāⁿ caati diíⁿ yā cosa chi 'tíícā miiⁿ nguuvi chi sábado chi ntaavi'túúnuuⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús nan'guɛɛcútaⁿ'a yā yeⁿ'ē sa: Chiidá ni ndíí maaⁿ chí idiiⁿ cá yā ntiiⁿnyuⁿ. Ní 'úú idiíⁿ ntiiⁿnyuⁿ dendu'ū. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tuu'mi ní 'iiⁿ'yāⁿ Israel neⁿ'e taaví sa 'caaⁿ'núⁿ sa Jesús, caati nguɛ́ɛ́ damaāⁿ chi nguɛ́ɛ́ diíⁿ yā cumplir chi ngaⁿ'ā na ley yeⁿ'e sábado, caati ngaⁿ'á yā chi Dendyuūs Chiidá yā, ní diíⁿ yā chi nduuvidáámá yā ndúúcū Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nan'guɛɛcutaⁿ'á Jesús ní ngaⁿ'a yā ngii yā saⁿ'ā: Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ chí ngaⁿ'á ngií ndis'tiī chi nguɛ́ɛ́ cuuvi diiⁿ Daiyá Dendyuūs mar 'áámá cosa dámaāaⁿ ndúútī chi nguɛ́ɛ́ n'diichí yā chi diiⁿ Chiidá yā. Caati tanducuéⁿ'ē chi diiⁿ Chiidá yā, 'tiicá ntúūⁿ diiⁿ Daiyá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Caati Dendyuūs Chiidá ní dinéⁿ'e yā 'úú chi Daiya yā. Ní n'giⁿ'i yā 'úú tanducuéⁿ'e dendu'ū chi diíⁿ yā. Niicu Chiidá n'giⁿ'i cá yā 'úú ntiiⁿnyuⁿ n'gɛɛtɛ ca nguɛ́ɛ́ tii chuū. Níícú ndis'tiī caⁿ'a yíínú nī yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tan'dúúcā Chiidá nadacuéeⁿ yā 'iiⁿ'yāⁿ chí 'āā n'dii ní nga'a yā vida yeⁿ'é yā, 'tiicá ntúūⁿ 'úú Daiyá yā ní nadacuéeⁿ 'iiⁿ'yāⁿ chi 'āā n'díí ní nga'á vida 'iiⁿ'yāⁿ miiⁿ chi neⁿ'é nga'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Caati Chiidá nguɛ́ɛ́ diíⁿ yā juzgar mar 'aama 'iiⁿ'yāⁿ naatí ca'á yā 'úú chi Daiya yā chi diíⁿ juzgar tanducuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Caati tanducuéⁿ'ē 'iiⁿ'yāⁿ diíⁿ yā honrar 'úú chi Daiyá yā tan'dúúcā tanducuéⁿ'ē 'iiⁿ'yāⁿ diíⁿ yā honrar Chiidá. Du'ū chi nguɛ́ɛ́ idiíⁿ yā honrar 'úú chi Daiyá Dendyuūs ní nguɛ́ɛ́ idiíⁿ yā honrar Chiidá chi dicho'ó yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndis'tiī: 'Iiⁿ'yāⁿ chi n'giindiveéⁿ yā nduudu chi ngaⁿ'á, ní i'téénu yā yeⁿ'e 'iiⁿ'yāⁿ chi dicho'ō 'úú, vɛ́ɛ́ vida cueⁿ'e daāⁿmaⁿ yeⁿ'é yā. Niicu nguɛ́ɛ́ condenado yā. Nguɛ́ɛ́ canee yā dácaā yeⁿ'ē chi n'gii caati vɛ́ɛ́ vida cueⁿ'e daāⁿmaⁿ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī: Cuchii hora ní hora miiⁿ chuū taachi 'iiⁿ'yāⁿ s'eeⁿ chi 'āā n'dií yā, 'caandiveéⁿ yā nduudu yeⁿ'e 'úú chi Daiyá Dendyuūs. 'Iiⁿ'yāⁿ chí i'teenu yā nduudu yeⁿ'é cunduuchí yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tan'dúúcā Chiidá vɛ́ɛ́ vida yeⁿ'ē maáⁿ yā, 'tiicá ntúūⁿ ca'a yā 'úú chi Daiya yā vida yeⁿ'ē maáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'Tíícā ca'á yā poder 'úú chi diíⁿ juzgar 'iiⁿ'yāⁿ caati 'úú Saⁿ'ā chi Daiya Dendyuus 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nguɛ́ɛ́ caⁿ'ā yiinu di yeⁿ'ē chúū, caati cuchii hora taachi nducyáácá 'iiⁿ'yāⁿ chi chinúu yā maaⁿ yaⁿ'āa 'caandiveéⁿ yā nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ní nadacuéeⁿ yā yeⁿ'ē nguaaⁿ tináⁿ'ā. 'Iiⁿ'yāⁿ chi diíⁿ yā chi n'daacā, ní caⁿ'á yā cuneé yā ndúúcū vida cueⁿ'e daāⁿmaⁿ yeⁿ'é yā. Ní 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daacā idiíⁿ yā, caⁿ'á yā na condenación. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ní caⁿ'a Jesús: 'Úú ní damaáⁿ ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ cuuvi diíⁿ. Tan'dúúcā chi n'giindiveéⁿ, 'tíícā diíⁿ juzgar. Ní chi diíⁿ juzgar ní cuaacu caati nguɛ́ɛ́ in'nuúⁿ chi neⁿ'é maáⁿ naati chi neⁿ'e maāⁿ Chiidá chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ndúútī chi yeⁿ'é māaⁿ chi ngaⁿ'á cuaacu ní nguɛ́ɛ́ cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Táámá 'iiⁿ'yāⁿ chi diíⁿ yā caaⁿ'maⁿ cuaacú yā yeⁿ'ē 'úú. 'Úú ní deenú tīi chí ngaⁿ'a yā yeⁿ'ē 'uú chi cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ní ndís'tiī ní dichó'o nī 'iiⁿ'yāⁿ s'eeⁿ nanááⁿ Juan. Ní Juan miiⁿ caⁿ'a sa nduudu cuaacu yeⁿ'e 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Caati 'úú nguɛ́ɛ́ ita'á nduudu cuaacu yeⁿ'ē sáⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū naati ngaⁿ'á tanducuéⁿ'ē chuū caati ndís'tiī ní cuuvi nanguáⁿ'ai nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Níícú Juan chi chɛɛdínuūⁿniⁿ yā 'iiⁿ'yāⁿ miiⁿ tan'dúúcā 'áámá chi dɛɛvɛ ngiichi ní ngíí n'gai, 'tííca yā. Ní ndís'tiī ní dinéⁿ'e nī vaadī yeenú yeⁿ'é nī 'áámá tiempo ndúúcū chi dɛɛvɛ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Naati 'úú ní ngaⁿ'á nduudu cuaacu chi ch'ɛɛtɛ ca chi caⁿ'a Juan miiⁿ caati ntiiⁿnyuⁿ chi teē Chiidá 'úú, ní chuū idiíⁿ. Tan'dúúcā maāⁿ ntiiⁿnyuⁿ chi diíⁿ ní ngaⁿ'ā nduudu cuaacu yeⁿ'é chi Chiidá dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Níícú maaⁿ Chiidá chi dichó'o yā 'úú ngaⁿ'a yā nduudu cuaacu yeⁿ'ē 'úú. Ndís'tiī mar 'áámá vmnéⁿ'ēe nguɛ́ɛ́ n'giindiveéⁿ nī nduudu yeⁿ'e chiidá, ndíí nguɛ́ɛ́ ndúú n'diichí nī 'iiⁿ'yāⁿ taacá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ní ndis'tiī ní nguɛ́ɛ́ 'áámá canée nī ndúúcū nduudu yeⁿ'é yā caati ndís'tiī nguɛ́ɛ́ s'téénu nī chi 'úú ní 'iiⁿ'yāⁿ chi Dendyuūs dichó'o yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","In'nuúⁿ nī naachi cánéé nguūⁿ na libro yeⁿ'e Ndyuūs, níícú cadiinúúⁿ nī chi vɛ́ɛ́ vida cueⁿ'e daāⁿmaⁿ yeⁿ'é nī. Ní mííⁿ ngaⁿ'ā cuaacu yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ndis'tiī nguɛ́ɛ́ neⁿ'é nī chii nī nanaáⁿ tiī cuūvī vida cueⁿ'e daāⁿmaⁿ yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","'Úú ní nguɛ́ɛ́ cuta'á honra yeⁿ'e saⁿ'ā yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Naati 'úú ideenú táácā ndís'tiī ní nguɛ́ɛ́ neⁿ'é nī Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'Úú ní cuchií ndúúcū chi duuchi Chiidá. Ní nguɛ́ɛ́ 'cuaaⁿ nī ndís'tiī 'úú. Ndúúti chi taamá yā cuchií yā ndúúcū nduudu yeⁿ'e maáⁿ yā, tuu'mi ní 'cuaáⁿ nī 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Táácā cu'téénú ndís'tiī chi diíⁿ nī honrar 'áámá nī yeⁿ'ē taamá nī ní nguɛ́ɛ́ neⁿ'é nī chi Dendyuūs diíⁿ yā honrar n'diī? ");
INSERT INTO cuxNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nguɛ́ɛ́ nadacadíínuuⁿ ndis'tiī chi 'úú ngaⁿ'á nuuⁿndi yeⁿ'e ndís'tiī nanááⁿ Chiidá. Vɛ́ɛ́ 'áámá 'iiⁿ'yāⁿ chi ngaⁿ'a nuuⁿndi yeⁿ'e ndís'tiī chi Moisés chi 'iiⁿ'yāⁿ chi i'téénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ndúúti chi ndís'tiī chi'téénu nī yeⁿ'e Moisés miiⁿ tuu'mi ní cu'téénu nī 'úú caati yeⁿ'ē 'úú chi dingúuⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ndúúti chi nguɛ́ɛ́ i'téénu nī chi dingúūⁿ Moisés, ¿tááca cu'téénu nī nduudu yeⁿ'ē 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cho'o cosa chuū, ní cueⁿ'e Jesús taama lado yeⁿ'ē nuuⁿniⁿ'yáⁿ'ā Galilea chi nguuvi ntúūⁿ Tiberias. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nééné n'deēe 'iiⁿ'yāⁿ cueⁿ'e yā n'dáa yā Jesús caati n'diichí yā señales yeⁿ'é yā chi diíⁿ yā ndúúcū 'iiⁿ'yāⁿ chi ngiītā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ní cuchɛɛ Jesús 'áámá cuɛɛti ní mííⁿ ch'iīndí yā ndúúcū discípulos yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ní chinee niiⁿnuúⁿ nguuví yeⁿ'e pascua yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tuu'mí n'diichi Jesús cuaaⁿ 'niiⁿnuúⁿ níícú snaaⁿ yā chí n'deee n'dáí 'iiⁿ'yāⁿ cuchií yā nanáaⁿ yā. Ní Jesús ngaⁿ'a yā ngii yā Felipe: ¿Tií caⁿ'a yú cuaī yú pan chi che'e 'iiⁿ'yāⁿ s'tíī? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ní chuū Jesús ngaⁿ'a yā ti diíⁿ yā probar saⁿ'ā miiⁿ táácā diiⁿ sá maāⁿ sa, caati Jesús maáⁿ yā deenú yā dɛ'ɛ̄ chi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nan'guɛɛcútaⁿ'a Felipe miiⁿ yeⁿ'é yā: Ndúúcū nyuⁿ'u ciento caadi tuūmī chi caⁿ'á nguaí pan nguɛ́ɛ́ tunééⁿ chí cuta'á 'iiⁿ'yāⁿ s'tiī 'aama taaⁿ chí che'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","'Áámá discípulo yeⁿ'é yā chí ngúúví Andrés chi 'díínu yā Simón Pedro, ngaⁿ'a sá ngii sa Jesús: ");
INSERT INTO cuxNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","'Áámá saⁿ'ā 'lííⁿ chi canee 'muuⁿ ndɛ́ɛ sa nyuⁿ'u panes cebada ndúúcū na 'uuvi 'yaācā n'gaiyáā. ¿Dɛ'ɛ̄ tunééⁿ chuū chi che'e 'iiⁿ'yāⁿ s'tíī? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tuu'mi ní nan'guɛɛcútaⁿ'ā Jesús miiⁿ ngaⁿ'a yā ngii yā saⁿ'ā: Cúúví nī 'iiⁿ'yāⁿ s'tiī ní 'cuɛɛtɛ́ núúⁿ yā. Nééné vɛ́ɛ́ yuune lugar miiⁿ níícú ch'ɛɛtɛ 'áámá número tan'duucā nyuⁿ'u mil saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ní Jesús miiⁿ sta'á yā panes miiⁿ níícú taachi ngaⁿ'a yā ngii yā: Gracias N'dii Ndyuūs, tucá'a yā ca'a yā discípulos, ní discípulos ní ca'á yā 'iiⁿ'yāⁿ chi vɛɛ̄tɛ́ miiⁿ. 'Tiicá ntúūⁿ diiⁿ Jesús ndúúcū 'yaācā. Ní 'iiⁿ'yāⁿ miiⁿ sta'á yā 'yaācā. Sta'á yā nducuéⁿ'ē chi neⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Taachi 'āā ntɛɛ vɛ́ɛ́ chi neⁿ'e yā, Jesús ngaⁿ'a yā ngii yā discípulos yeⁿ'é yā: Nadicuéeⁿ di nducuéⁿ'ē tááⁿ panes chi nángaāva caati nguɛ́ɛ́ cuuvi ndáí dɛ'ɛ̄ vɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nadicuéeⁿ yā tanducuéⁿ'ē taaⁿ panes chi nángaāva. Níícú chiitu ndiichúúví 'cuɛɛtɛ̄ɛ naachi nyuⁿ'u pan cebada chi ningaāva naachí che'ē 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Taachi n'diichi 'iiⁿ'yāⁿ s'eeⁿ señal chi diiⁿ Jesús miiⁿ tuu'mi ní ngaⁿ'a yā ngii yā vi'ī: Cuaacu nííⁿnyúⁿ 'iiⁿ'yāⁿ 'cúū chi profeta chi canee chi ndaá yā iⁿ'yééⁿdi 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Taachí tuumicádíínuuⁿ Jesús chi 'iiⁿ'yāⁿ s'eeⁿ neⁿ'é yā cuta'á yā 'yā ní cu'néeⁿ yā 'yā lado yeⁿ'ē rey tuu'mi ní cueⁿ'é máaⁿ yā na 'áámá cuɛɛtī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","'Āā chii chíínū miiⁿ ní cueⁿ'e discípulos yeⁿ'é yā na nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ní chi ndaa yā 'áámá barco ní cueⁿ'é yā ná nuūⁿnīⁿ'yáⁿ'ā. Ní 'āā ntɛ́ɛ́ ndaá yā na yáāⁿ Capernaum. 'Āā chii 'da'a ní nguɛ́ɛ́ ndáā Jesús naachi snée yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ní cho'ō 'aama 'yúúné taaⁿ ní nadācuééⁿ n'dai nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Taachí 'āā cueⁿ'é yā tanduu nyuⁿ'u candúū nyaaⁿ kilómetros, tuu'mí n'diichí yā chi cúchiī Jesús miiⁿ. Ngiicá yā cuaaⁿ vmnaaⁿ nuūⁿnīⁿ. Ní taachi 'aa cháá ndaa Jesús niiⁿnuúⁿ na barco miiⁿ discípulos dii'yā sá chiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ní Jesús ngaⁿ'a yā ngiī yā saⁿ'ā s'eeⁿ: Nguɛ́ɛ́ 'va'ā ndís'tiī ti 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tuu'mí ngaⁿ'a sá ngii sa Jesús: Cho'ó nī cuaaⁿ chɛɛti barco. Yeenú n'dai sa chi sndaā Jesús na barco. 'Āā nuúⁿ ndaa barco miiⁿ na yáⁿ'āa naachí cuéⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chi dɛɛvɛ táámá nguuvi ní 'iiⁿ'yāⁿ chi snéé yā táámá lado yeⁿ'e nuūⁿnīⁿ'yáⁿ'ā n'diichí yā 'áámá barco nūuⁿ, barco miiⁿ chi 'āā cueⁿ'ē discípulos. Ní n'diichí yā chi nguɛ́ɛ́ cueⁿ'e Jesús ndúúcū discípulos yeⁿ'é yā. Ní discípulos yeⁿ'é yā cuinaⁿ'á yā dámaáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tan'duuvi barcos yeⁿ'ē Tiberias ndaā niiⁿnuúⁿ na lugar naachi ch'ɛɛtɛ́ yā chi che'é yā pan 'iicū cuayiivi chi Jesús ngāⁿ'a yā: Gracias n'dii Dendyuūs Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Taachí 'iiⁿ'yāⁿ n'diichi yā chi nguɛ́ɛ́ Jesús miiⁿ ndíí nguɛ́ɛ́ ndúú discípulos yeⁿ'é yā, tuu'mi ní chi ndaá yā chɛɛti barcos. Ní cueⁿ'é yā na yáāⁿ Capernaum. N'nuūⁿ yā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Taachí 'iiⁿ'yāⁿ s'eeⁿ ndaacá yā Jesús táámá lado yeⁿ'ē nuūⁿnīⁿ'yáⁿ'ā tuu'mi ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ: N'diī Maestro, ¿tíí cuaⁿ'a ndaá nī 'muuⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Nan'guɛɛcútaⁿ'a Jesús yeⁿ'e yā ní ngaⁿ'a yā ngii yā: Ndís'tiī, cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ nguɛ́ɛ́ in'nuúⁿ nī 'úú ti n'diichí nī chi diíⁿ señales naati chí teé pan, ní che'é nī ní chiitu ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nguɛ́ɛ́ diíⁿ nī ntiiⁿnyuⁿ yeⁿ'e comida chi chó'ōo ti yeⁿ'e comida chí cunéé cueⁿ'e daāⁿmaⁿ, chɛɛ chi tee Saⁿ'ā chi Daiya Dendyuūs ndís'tiī caati Dendyuūs Chiidá ca'á yā poder Daiyá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tuu'mi ní ngaⁿ'a saⁿ'ā s'eeⁿ ngii sá 'iiⁿ'yāⁿ: ¿Taacā diíⁿ 'nū chi cuuví diíⁿ 'nū ntiiⁿnyuⁿ chi ntiiⁿnyuⁿ yeⁿ'é Dendyuūs miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Nan'guɛɛcutáⁿ'ā Jesús yeⁿ'ē sa ní ngaⁿ'á yā ngii yā saⁿ'ā: Chuū chi ntiiⁿnyuⁿ yeⁿ'e Dendyúūs miiⁿ chi cu'téénu di yeⁿ'ē 'iiⁿ'yāⁿ chi Ndyuūs dichó'o yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tuu'mí ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ: ¿Dɛ'ɛ señal chí cu'neeⁿ nī chí snaáⁿ 'nū, ní cu'téénu 'nū n'diī? ¿Dɛ'ɛ ntiiⁿnyuⁿ idiíⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Chiida yú ní che'é yā yuūndū maná na yáⁿ'āa naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ tan'dúúcā chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs 'tíícā: Yuūndū yeⁿ'ē nanguuvi Ndyuūs ca'á yā chi che'é 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nan'guɛɛcutáⁿ'ā Jesús yeⁿ'ē sa: Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndis'tiī: Nguɛ́ɛ́ teé yā Moisés miiⁿ yuūndū chi maná chi yeⁿ'ē nanguuvi, naati Chiidá teé yā n'diī pan chi cuaacu nííⁿnyúⁿ chí yeⁿ'e va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Caati pan chi yeⁿ'é Dendyuūs ní 'iiⁿ'yāⁿ miiⁿ chi inch'eéⁿ yā yeⁿ'e va'ai chɛɛti nguuvi ní nga'á yā vida cueⁿ'e daāⁿmaⁿ yeⁿ'ē 'iiⁿ'yāⁿ yeⁿ'eⁿ íⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tuu'mi ní ngaⁿ'ā sa ngii sa Jesús: Señor, tée nī pan 'cūū nús'uu cueⁿ'é daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús ngaⁿ'a yā ngii yā saⁿ'ā: 'Úú ní tan'dúúcā pan 'tíícā 'úú ni ca'á vida cueⁿ'e daāⁿmaⁿ. Du'u chi chii nanaáⁿ nguɛ́ɛ́ cúúví cuiicú yā. Ní du'ū chi cu'teenu 'úú 'āā ntɛ́ɛ́ cuuví yaacá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Naati 'úú ni ngaⁿ'á ndis'tiī: 'Āā n'diichí nī 'úú, níícú ndíí nguɛ́ɛ́ s'téénu nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tanducuéⁿ'ē 'iiⁿ'yāⁿ chi itée Chiidá 'úú, 'iiⁿ'yāⁿ s'tíī cuchiī nanaáⁿ. Du'ū chí chiī nanaáⁿ nguɛ́ɛ́ tun'daá 'iiⁿ'yāⁿ chuva'aī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Caati 'úú chiicá yeⁿ'ē na va'ai chɛɛtɛ nguuvi ní nguɛ́ɛ́ diíⁿ chi 'úú neⁿ'é maáⁿ, caatí diíⁿ chi neⁿ'e maāaⁿ 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Chuu chi neⁿ'ē Chiidá chi dichó'o yā 'úú, caati 'úú ní nguɛ́ɛ́ nindaí mar 'áámá yeⁿ'ē tanducuéⁿ'ē chi tee yā 'úú. 'Úú ní nadin'duuchí tanducuéⁿ'ē 'iiⁿ'yāⁿ yeⁿ'e nguaaⁿ tináⁿ'ā nguuvi chi 'cuiīnū iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chuū chi neⁿ'e 'iiⁿ'yāⁿ chi dichó'o yā 'úú: Nducyaaca 'iiⁿ'yāⁿ chi n'diichí yā Daiya Ndyuūs, ní i'téénu yā 'iiⁿ'yāⁿ, vɛ́ɛ́ vida cueⁿ'e daāⁿmaⁿ yeⁿ'é yā. Niicu 'úú ní nadicueéⁿ 'iiⁿ'yāⁿ s'eeⁿ nguuvi chi 'cuiīnū iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tuu'mí ngaⁿ'ā 'iiⁿ'yāⁿ Israel yeⁿ'é yā: Nguɛ́ɛ́ n'daacā chi ngaⁿ'a yā: 'Úú tan'dúúcā pan chi cuch'ééⁿ nanguuvi, 'tíícā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ní ngaⁿ'a yā: ¿'Áá nguɛ́ɛ́ sáⁿ'a 'cūū chi Jesús daiya José? Ní n'diichi yú chiidá yā ndúúcū chɛɛcú yā. ¿Taacā chi ngaⁿ'ā sa: 'Úú chi cuch'eéⁿ yeⁿ'e na va'ai chɛɛti nguuvi? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ní Jesús nan'guɛɛcútaⁿ'á yā yeⁿ'ē sa, ní ngaⁿ'a yā ngií yā saⁿ'ā: Nguɛ́ɛ́ caaⁿ'máⁿ ndís'tiī nguááⁿ maáⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi ndaá yā nanaáⁿ ndúútī chi Chiidá chi dichó'o yā 'úú nguɛ́ɛ́ nndɛ́ɛ yā 'iiⁿ'yāⁿ. 'Úú nadan'duuchí 'yā nguuvi chi 'cuiīnū iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Canéé nguūⁿ na libro yeⁿ'ē Ndyuūs naachi ngaⁿ'a profetas 'tíícā: Dendyuūs ca'cueeⁿ yā nducyaaca yā. Nducyaaca 'iiⁿ'yāⁿ chi ch'iindiveéⁿ yā yeⁿ'ē Chiidá ní 'āā cueéⁿ yā yeⁿ'ē Chiidá, cuchií yā nanááⁿ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mar 'áámá 'iiⁿ'yāⁿ 'āā n'diichí yā Chiidá, dámaaⁿ Cristo chi yeⁿ'e Dendyuūs ti Daiyá Ndyuūs. 'Iiⁿ'yāⁿ 'cúū dámaāⁿ n'diichí yā Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngīi ndis'tíī: Du'ū chi i'téénu yā 'úú cunduuchí yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Úú tan'dúúcā pan chi canduuchi, 'tíícā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Chiidá nī che'é yā pan maná na yáⁿ'āa naachi nguɛ́ɛ́ 'iiⁿ'yāⁿ ní ch'iī yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Chúū chi pan chi cuch'ééⁿ na va'ai chɛɛti nguuvi caatí 'iiⁿ'yāⁿ chi che'é yā yeⁿ'ē nguɛ́ɛ́ 'cuūvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Úú tan'dúúcā pan chi canduuchi chi cuch'eéⁿ na va'ai chɛɛti nguuvi. Du'u 'iiⁿ'yāⁿ chi ché'e yā pan 'cūū, cunduuchí yā cueⁿ'e daāⁿmaⁿ. Níícú pan miiⁿ chi 'úú caⁿ'á ní yuūtɛ̄ yeⁿ'é maáⁿ. Chuū chi ca'á cáávā vida yeⁿ'é 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tuu'mi ní 'iiⁿ'yāⁿ Israel ch'ɛɛcu cheendí sá nguaaⁿ maāⁿ sa: ¿Táácā cuuvi tée sá cuerpo yeⁿ'ē sa chi che'é 'nū? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tuu'mí ngaⁿ'a Jesús ngii yā saⁿ'ā: Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndis'tiī: Nduuti chi nguɛ́ɛ́ che'e nī cuerpo yeⁿ'e Saⁿ'ā chi Daiya Dendyuūs ní nduuti chi nguɛ́ɛ́ cu'ú nī yuuúⁿ yeⁿ'ē sa, nguɛɛ cūnee vida cueⁿ'e daāⁿmaⁿ ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Du'u chi che'e cuerpo yeⁿ'é ni cu'u yuuúⁿ yeⁿ'é, cunéé vida cueⁿ'e daāⁿmaⁿ ndúúcū. Níícú 'úú nadicueéⁿ 'iiⁿ'yāⁿ s'eeⁿ nguuvi chi 'cuiīnū iⁿ'yeeⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Caati cuerpo yeⁿ'é, cuaacu nííⁿnyúⁿ yuūtɛ̄ chi che'e yā. Ní yuuúⁿ yeⁿ'é, cuaacu nííⁿnyúⁿ chi yuuúⁿ chi cu'u yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Du'u chí che'e cuerpo yeⁿ'é ní cu'ú yuuúⁿ yeⁿ'é cunee yā nduucú, ní 'úú cuneé ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tan'dúúcā chi Chiidá canduuchí yā ní dichó'o yā 'úú, ní 'úú canduuchí cáávā 'iiⁿ'yāⁿ miiⁿ. 'Tiicá ntúūⁿ 'iiⁿ'yāⁿ chi che'e yā 'úú, 'iiⁿ'yāⁿ miiⁿ ní cunduuchi ntúúⁿ yā cáávā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Chúū pan chi cuch'eéⁿ yeⁿ'ē na va'ai chɛɛti nguuvi. Nguɛ́ɛ́ tan'dúúcā pan maná chi che'ē chiidá nī miiⁿ tiempo chi 'āā chó'ōo ní ch'īi yā. Du'u chi che'e pan 'cūū cunduuchí yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chuū chí caⁿ'a Jesús na yáacū sinagoga taachi cueⁿ'é yā na yáāⁿ Capernaum. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tuu'mi n'deee n'dáí discípulos yeⁿ'é yā taachi ch'iindiveéⁿ yā chuū ní caⁿ'a yā: Chɛɛchí 'tɛ́ɛ́ nduudu 'cūū. ¿Du'ū rá 'caandiveeⁿ rá? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Taachí déénú maāⁿ Jesús chi discípulos yeⁿ'é yā indeē sa nguááⁿ maāⁿ sa yeⁿ'e chúū tuu'mi ní ngaⁿ'á yā ngii yā saⁿ'ā s'eeⁿ: ¿'Áá chuū chi nguɛɛ ineéⁿ nūuⁿ ndís'tiī? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Dɛ'ɛ̄ ca diíⁿ ndis'tiī, taachí n'diichí nī Saⁿ'ā chí Daiya Dendyuūs chí ch'ee sa na va'ai chɛɛti nguuvi naachí canéé sa vmnááⁿ vmnaaⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu chuū chí nga'a vida yeⁿ'é 'iiⁿ'yāⁿ ní 'iiⁿ'yāⁿ canéé ndúúcū espíritu yeⁿ'é yā. Yuūtɛ̄ miiⁿ nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ idiīiⁿ. Nduudu chi ngaⁿ'á ngií ndis'tiī, ní yeⁿ'ē espíritu ní ca'a vida 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Vɛ́ɛ́ n'duuvi ndís'tiī chi nguɛ́ɛ́ i'téénú nī. Caati Jesús ndíí cuaaⁿ vmnaaⁿ 'āā deenú yā du'ū 'iiⁿ'yāⁿ s'eeⁿ chi nguɛ́ɛ́ cu'téénu yā, níícú du'ū 'iiⁿ'yāⁿ chí diíⁿ yā entregar 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ní Jesús ngaⁿ'a yā: Cáávā chuū chi ngaⁿ'á ngií ndís'tiī, caati mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuchií yā nanaáⁿ ndúúti chi nguɛ́ɛ́ cáávā chi Dendyúūs 'cuúⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ndii tuu'mi, neené 'yaaⁿ discípulos yeⁿ'é yā ndaacadáámí sá ní 'āā ntɛ́ɛ́ cachiica sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tuu'mí ní ngaⁿ'a Jesús ngii yā saⁿ'ā chi ndiichúúví: ¿'Áá neⁿ'é nī ntuūⁿ ndís'tiī ndaacadáámí nī yeⁿ'é? ");
INSERT INTO cuxNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tuu'mi ní nan'guɛɛcútaⁿ'ā Simón Pedro: Señor, ¿du'u chí caⁿ'ā ndúúcu 'nū? N'diī ní canée nī ndúúcū nduudu yeⁿ'ē vida cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nús'uu i'téénu 'nū ní deenú 'nū chi n'diī chi Cristo, Daiya Dendyúūs chi canduuchi cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ní Jesús nan'guɛɛcútaⁿ'á yā: ¿'Áá nguɛ́ɛ́ 'úú chí ndɛɛvɛ́ ndís'tiī ndiichúúví nī? Ní 'áámá chɛ́ɛ́ ndís'tiī ni yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ní ngaⁿ'a yā yeⁿ'e Judas Iscariote, daiya Simón caati sáⁿ'a 'cūū chi canee chí diiⁿ sa entregar 'iiⁿ'yāⁿ. Saⁿ'ā miiⁿ 'áámá sá yeⁿ'ē naachi ndiichúúví sá. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cho'ōo tanducuéⁿ'ē chuū, Jesús cachiicá yā na yáⁿ'āa Galilea. Nguɛ́ɛ́ neⁿ'é yā cuchiicá yā na yáⁿ'āa Judea caati saⁿ'ā Israel s'eeⁿ canéé ngiinu sa chí 'caaⁿ'núⁿ sa Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ní 'āā chinee niiⁿnuúⁿ nguuvi 'viicu yeⁿ'ē va'āī chi 'neeⁿ n'daí yā arco yeⁿ'ē testamento yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tuu'mí ní ngaⁿ'a 'díínu yā ngii yā 'iiⁿ'yāⁿ: Nan'dáa di 'múúⁿ ní cueⁿ'e di na yáⁿ'āa Judea caati discípulos yeⁿ'ē di cuuví snaaⁿ yā dendu'ū ntiiⁿnyuⁿ chí idiiⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Caati ndii 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ diíⁿ yā 'áámá chi canúúⁿ n'de'ei. Níícú maáⁿ yā ní neⁿ'é yā chi 'iiⁿ'yāⁿ n'diichí yā 'yā. Ndúúti chí dii chí diiⁿ di cosa chi 'tíícā tuu'mi ní 'cuuⁿ'miⁿ di maāⁿ di nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ní mar 'áámá 'díínu yā nguɛ́ɛ́ chi'teenú yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tuu'mí ngaⁿ'a Jesús ngii yā saⁿ'ā: 'Aa ntɛ́ɛ́ vɛ́ɛ́ chi 'aacu hora yeⁿ'é, caati tiempo yeⁿ'é nī 'āā canéé. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Iiⁿ'yāⁿ yeⁿ'ē iⁿ'yéeⁿdī cuuvi n'diichí yā ndis'tiī. Nguɛ́ɛ́ cuuvi n'diichí yā 'úú caati 'úú ní ngaⁿ'á cuaacú chɛɛ chi nguɛ́ɛ́ n'daacā idiiⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yééⁿdi 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ndís'tiī caⁿ'a nī 'viicú 'cūū. 'Úú ní nguɛɛ caⁿ'á maaⁿnguuvi, caati 'āā cuɛ́ɛ́ cunuūⁿ ca'a hora yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Taachi ch'iinu caⁿ'a yā chii yā nduudú 'cūū 'díínu yā, tuu'mi Jesús canée ca yā yáⁿ'āa Galilea. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Taachi cueⁿ'é saⁿ'a 'díínu yā 'viicu, 'tiicá ntúūⁿ miiⁿ ní cueⁿ'é Jesús cuayiivi. Nguɛ́ɛ́ ch'iⁿ'í yā chi Jesús miiⁿ. Cheⁿ'e n'de'ei núuⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tuu'mi ní saⁿ'a Israel s'eeⁿ ní in'nuuⁿ sa 'iiⁿ'yāⁿ na 'viicu miiⁿ. Ní ngaⁿ'a sa: ¿Tíí cánéé 'iiⁿ'yāⁿ miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","'Iiⁿ'yāⁿ yáāⁿ miiⁿ neené n'deēe ngaⁿ'a yā yeⁿ'é yā. N'duuví yā ngaⁿ'a yā: 'Iiⁿ'yāⁿ miiⁿ n'dai taavi yā. Ta n'duuví yā ngaⁿ'a yā: Nguɛ́ɛ́, caati nginnche'éí yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mar 'áámá saⁿ'ā chí cheⁿ'e sa 'viicu nguɛ́ɛ́ caⁿ'a sa yeⁿ'é yā ti 'va'a sa 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chí maⁿ'ā 'viicu, tuu'mi ní Jesús cuchɛɛ́ yā chɛɛti yáacū templo ní chi'cueeⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Níícú saⁿ'a Israel ngeⁿ'e yiinu sa ní ngaⁿ'ā sa: ¿Táácā déénu sáⁿ'a 'cūū letras caati sáⁿ'a 'cūū nguɛɛ 'néeⁿ sa? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","N'guɛɛcútaⁿ'a Jesús ní caⁿ'a yā: Chiiⁿ chí ngi'cueéⁿ chi deenú ní nguɛ́ɛ́ yeⁿ'é, ti yeⁿ'e 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ndúuti chi 'iiⁿ'yāⁿ neⁿ'é yā diíⁿ yā voluntad yeⁿ'é Dendyuūs, tuu'mi ní deenú yā chi ngi'cueéⁿ nduuti chi yeⁿ'é Dendyuūs o nduuti chi 'úú ngaⁿ'á yeⁿ'ē maáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","'Iiⁿ'yāⁿ chí ngaⁿ'a yā yeⁿ'ē maáⁿ yā in'nuúⁿ yā poder yeⁿ'ē maáⁿ yā. Naati 'iiⁿ'yāⁿ chi in'nuúⁿ yā poder yeⁿ'e 'iiⁿ'yāⁿ chi dichó'o yā 'yā, 'iiⁿ'yāⁿ miiⁿ ní cuaacú yā. Ní nguɛ́ɛ́ chi nguɛ́ɛ́ cuaacu nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿'Áá nguɛ́ɛ́ ca'a Moisés ndís'tiī yeⁿ'ē ley? Ní mar áámá ndís'tiī nguɛ́ɛ́ idiíⁿ nī chi ngaⁿ'a ley miiⁿ. ¿Dɛ'ɛ̄ cáávā chí neⁿ'e 'caaⁿ'nuⁿ ndís'tiī 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","N'guɛɛcutáⁿ'ā 'iiⁿ'yāⁿ ní caⁿ'a yā Jesús: Yááⁿn'guiinūūⁿ canéé ndúúcū di. ¿Du'ū idiiⁿ núúⁿ yiinu chi neⁿ'é 'caaⁿ'nūⁿ dii? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús ní n'guɛɛcutáⁿ'a yā ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ: Diíⁿ 'áámá ntiiⁿnyuⁿ ní nducyaaca ndís'tiī ngeⁿ'e yiinu nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Cuaacu chi Moisés miiⁿ tee sa ley yeⁿ'e circuncisión ndís'tiī. (Nguɛ́ɛ́ chííⁿ yeⁿ'ē Moisés miiⁿ chi yeⁿ'ē chiidá nī.) Ni sábado chi nguuvi chí 'iiⁿ'yāⁿ Israel ntaavi'tuunúúⁿ yā, ndís'tiī idiíⁿ nī circuncidar saⁿ'ā 'lííⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ndúúti chi cuaáⁿ nī chi diíⁿ yā circuncidar saⁿ'ā 'lííⁿ nguuvi sábado caati ley yeⁿ'ē Moisés canéé chi diíⁿ nī cumplir, ¿dɛ'ɛ̄ induuvi táaⁿ nī nduucú caati sábado idiíⁿ chi nduūvā n'dáacā yeⁿ'e 'áámá saⁿ'ā? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nguɛ́ɛ́ diíⁿ nī juzgar tan'dúúcā chi nadacadíínuuⁿ nī naati diíⁿ nī juzgar chi cuaacu ndúúcū chi n'daí miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tuu'mí ngaⁿ'a n'duuví 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén: ¿'Áá nguɛ́ɛ́ 'iiⁿ'yāⁿ 'cúū chí neⁿ'e 'caaⁿ'núⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","N'diichí nī. Jesús nguɛ́ɛ́ 'va'á yā ngaⁿ'a yā nanááⁿ nducyáácá 'iiⁿ'yāⁿ. Ní nguɛ́ɛ́ du'ū vɛɛ 'iiⁿ'yāⁿ ngaⁿ'a yā ngii yā 'yā. ¿'Áá cuaacu nííⁿnyúⁿ chí 'iiⁿ'yāⁿ n'gɛɛtɛ chi ngaⁿ'ā ntiiⁿnyúⁿ yā ní déénú yā chi 'iiⁿ'yāⁿ 'cúū chi cuaacu nííⁿnyúⁿ chi Cristo? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","'Iiⁿ'yāⁿ 'cúū deenu yú tií ndiicá yā naati taachi ndiicá Cristo miiⁿ, mar 'áámá 'iiⁿ'yāⁿ nguɛɛ deenú yā tií ndiicá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tuu'mi ní ngaⁿ'a yuudu Jesús taachí chi'cueeⁿ yā na yáacu templo ní ngaⁿ'a yā: Ndís'tiī, ní 'āā n'diichí nī 'úú. Ní 'āā deenú nī tiī yáāⁿ yeⁿ'é. Níícú 'úú ní nguɛ́ɛ́ cuchií yeⁿ'ē maáⁿ, naati 'iiⁿ'yāⁿ chi dichó'o yā 'úú ní cuaacú yā. Ndís'tiī nguɛ́ɛ́ n'diichí nī 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Naati 'úú ní n'diichí 'iiⁿ'yāⁿ miiⁿ caati 'úú ndiicá yeⁿ'é yā, ní 'iiⁿ'yāⁿ miiⁿ dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tuu'mi ní idiiⁿ núuⁿ yiinu 'iiⁿ'yāⁿ chi cuta'á yā Jesús naati mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ che'ē ta'á yā Jesús, caati 'āā cuɛ́ɛ́ ndaa hora yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Níícú 'yaaⁿ n'dáí 'iiⁿ'yāⁿ yeⁿ'e 'iiⁿ'yāⁿ chi snéē miiⁿ chi'téénu yā Jesús. Ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ s'eeⁿ: Taachi ndaá Cristo miiⁿ, ¿'áá nguɛ́ɛ́ cuuvi diíⁿ yā más cā señales chi diiⁿ sáⁿ'a 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Tuu'mi ní saⁿ'ā fariseos ch'iindiveeⁿ sa yeⁿ'e 'iiⁿ'yāⁿ chi neené n'deee ngaⁿ'a yā 'túúcā yeⁿ'é Jesús miiⁿ. Chiiduú n'gɛɛtɛ́ ndúúcū saⁿ'ā fariseos dicho'ó yā policías chi cuta'a sa Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tuu'mi ní Jesús ngaⁿ'a yā ngiī yā saⁿ'ā s'eeⁿ: 'Āā ntɛɛ 'nááⁿ cuneé ndúúcū ndis'tíī ní naⁿ'á n'diichí 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","In'nuúⁿ nī 'úú ní 'āā ntɛ́ɛ́ ndaacá nī 'úú. Ní naachi 'úú caneé, ndís'tiī ní nguɛ́ɛ́ cuuvi ndaa nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tuu'mi ní ngaⁿ'a 'iiⁿ'yāⁿ Israel nguaaⁿ maáⁿ yā: ¿Tií cáⁿ'ā 'iiⁿ'yāⁿ 'cúū chi nguɛ́ɛ́ nindaaca yú 'iiⁿ'yāⁿ? ¿'Áá caⁿ'á yā n'diichi 'iiⁿ'yāⁿ Israel chi cueⁿ'é yā 'muuⁿ cueⁿ'é yā miiⁿyā nguaaⁿ 'iiⁿ'yāⁿ chi nguɛɛ yeⁿ'e ndaata Israel ní ca'cueéⁿ yā 'iiⁿ'yāⁿ miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Dɛ'ɛ̄ chi ntúūⁿ ngaⁿ'ā Jesús: In'nuúⁿ nī 'úú ní nguɛ́ɛ́ nindaāca nī 'úú; ní naachi 'úú caneé, nguɛ́ɛ́ cuuvi cundaā ndís'tiī? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ngúúví chí ch'iīnū 'viicu ch'ɛɛtɛ miiⁿ, Jesús cheendii yā caⁿ'ā diitú yā: Du'u chí yaaca chiī nanaáⁿ ní 'úú ca'á chi cu'u yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Du'ū chi i'teenu 'uú, vɛ́ɛ́ vida yeⁿ'é yā. Ní vida canéé tan'dúúcā 'áámá yíícú nuūⁿnīⁿ chi ca'a vida cueⁿ'e daāⁿmaⁿ 'iiⁿ'yāⁿ miiⁿ. Chuū canee nguūⁿ na libro yeⁿ'e Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ní chuū ngaⁿ'á yā yeⁿ'ē Espíritu N'dai yeⁿ'e Ndyuūs. 'Iiⁿ'yāⁿ chi cu'téénu yā Jesús canéé chi cuta'á yā Espíritu N'dai yeⁿ'e Ndyuūs. Ní Dendyuūs nguɛ́ɛ́ ca'a yā Espíritu N'dai yeⁿ'e yā ti Jesús miiⁿ ní 'āā cuɛ́ɛ́ cheⁿ'é yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tuu'mí ní neené 'yaaⁿ 'iiⁿ'yāⁿ taachí ch'iindiveéⁿ yā chuū ngaⁿ'a yā: Cuaacu nííⁿnyúⁿ 'iiⁿ'yāⁿ 'cúū chi profeta. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ta n'duuví yā ngaⁿ'a yā: 'Iiⁿ'yāⁿ 'cúū chi Cristo. Naati n'duuví yā ngaⁿ'a yā: ¿'Áá yeⁿ'ē yáⁿ'āa Galilea chí cánéé chí ndaa Cristo? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿'Áá nguɛ́ɛ́ ngaⁿ'ā naachi canéé nguūⁿ na libro yeⁿ'e Ndyuūs chi Cristo ní cuchií yā yeⁿ'ē ndaata yeⁿ'ē rey David, ní yeⁿ'e yáāⁿ 'lííⁿ Belén, yáāⁿ chi chiica David miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tuu'mí neene vɛɛ división nguaaⁿ 'iiⁿ'yāⁿ cucáávā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","N'duuvi 'iiⁿ'yāⁿ neⁿ'e yā cuta'á yā Jesús naati mar 'áámá saⁿ'ā miiⁿ nguɛ́ɛ́ tuu'vi sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Policías ndaa sa nanááⁿ chiiduú n'gɛɛtɛ́ ndúúcū saⁿ'a fariseos. Ní 'iiⁿ'yāⁿ s'eeⁿ ní ngaⁿ'a yā ngiī yā policías: ¿Dɛ'ɛ̄ cuuvi chi nguɛ́ɛ́ candɛɛ́ nī saⁿ'ā? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policías n'guɛɛcutáⁿ'a yā 'iiⁿ'yāⁿ: Mar 'áámá saⁿ'ā nguɛ́ɛ́ ngaⁿ'a sa tan'dúúcā chi ngaⁿ'ā 'iiⁿ'yāⁿ 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tuu'mí saⁿ'ā fariseos n'guɛɛcutaⁿ'a sa policías: ¿'Áá nginnche'éí yā ntúūⁿ ndis'tiī? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿'Áá i'teenu n'duuví 'iiⁿ'yāⁿ chi caⁿ'ā ntiiⁿnyuⁿ yā o saⁿ'ā fariseos nduudu Jesús miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","'Iiⁿ'yāⁿ chí nguɛ́ɛ́ déénu yā chi cánéé nguūⁿ na ley, 'āā condenado 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Sáⁿ'ā miiⁿ nguuvi Nicodemo chi 'āā ndaa nanááⁿ Jesús n'gaaⁿ, saⁿ'ā miiⁿ canée sa ndúúcu yā. Tuu'mí ngaⁿ'a Nicodemo ngii sa 'iiⁿ'yāⁿ: ");
INSERT INTO cuxNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿'Áá ley yeⁿ'ē yú cuuvi caaⁿ'maⁿ nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ, ndúúti chi nguɛ́ɛ́ n'diichi di 'iiⁿ'yāⁿ, ní 'caandiveeⁿ dí yeⁿ'e 'iiⁿ'yāⁿ ní túúmícádíínuuⁿ di chi diíⁿ yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nan'guɛɛcutáⁿ'a yā ní ngaⁿ'a yā ngii yā saⁿ'ā: ¿'Áá 'iiⁿ'yāⁿ yeⁿ'e yáⁿ'āa Galilea ntúūⁿ dii? In'núúⁿ dí níícú n'diichi di chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs caati yeⁿ'ē yáⁿ'āa Galilea mar 'áámá vmnéⁿ'ēe nguɛ́ɛ́ can'dáā 'áámá profeta. ");
INSERT INTO cuxNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ní cunaⁿ'a nducyaacá yā na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús miiⁿ ní cueⁿ'e yā cuɛ́ɛ́tí chi nguuvi Olivos. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tyaaⁿ tyaaⁿ chi dɛɛvɛ táámá nguuvi ndáa ntúuⁿ yā yaācū templo. Nuuⁿmáⁿ yáāⁿ 'iiⁿ'yāⁿ ndaá yā nanáaⁿ yā. Ch'iindí yā ní ca'cueéⁿ yā 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tuu'mi ní ndaā n'duuvi saⁿ'ā chi ngi'cueeⁿ ley ndúúcū n'duuvi saⁿ'ā fariseos. N'dɛ́ɛ sa nanááⁿ Jesús 'áámá n'daataá chi cyaadu tá ndúúcū 'aama saⁿ'ā chi 'āā 'niinivaacu. Níícú chi canee sa chi nuuⁿ sa táⁿ'ā náávtaⁿ'ā yeⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ngaⁿ'a saⁿ'ā s'eeⁿ: Maestro, n'daataá 'cūū ní tunéé 'nū táⁿ'ā ndúúcū táámá saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Naachi cánéé nguuⁿ ley yeⁿ'ē Moisés miiⁿ ní ngaⁿ'ā chí cuíítuú 'nū n'daataá chi 'tíícā. N'dīī túú'mi, ¿dɛ'ɛ̄ ngaⁿ'a n'diī? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chuū ngaⁿ'ā saⁿ'ā s'eeⁿ chi neⁿ'e sá n'diichi sa táácā diiⁿ Jesús 'iicu tun'dáá nuuⁿndi sa yeⁿ'é yā. Jesús ní can'dii yā ní dingúuⁿ yā na yáⁿ'āa miiⁿ ndúúcū nduutita'á yā. Diíⁿ yā tan'dúúcā chi nguɛ́ɛ́ ch'iindiveéⁿ yā yeⁿ'ē 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Taachí nitiinguunééⁿ ntuūⁿ sáⁿ'ā 'iiⁿ'yāⁿ, tuu'mí nanguaacundii yā ni ngaⁿ'a yā ngii yā: Du'ū ndís'tiī chi nguɛ́ɛ́ nuuⁿndi yeⁿ'é nī, cuta'á nī vmnááⁿ vmnaaⁿ 'áámá túūu ní ca'á nī táⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Can'díí ntuuⁿ yā ní dingúūⁿ ntúuⁿ yā ná yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'Iiⁿ'yāⁿ chi ch'iindiveéⁿ yā chuu tuumicádíínuuⁿ yā chi vɛ́ɛ́ nuuⁿndi yeⁿ'é yā. Ní ca'áámá ca'áámá inan'daá yā, 'iiⁿ'yāⁿ ndiicúū 'āā ndíí ná ch'iinuu maaⁿ. Nan'daā nducyáácá yā. Ní 'aa dámaāⁿ Jesús canee yā ndúúcū táⁿ'ā chi canéé naavtaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nacueeⁿ Jesús ní n'diichí yā 'āā ntɛ́ɛ́ du'ū vɛɛ ti 'āā dámaāⁿ n'daataá miiⁿ. Ní ngaⁿ'a yā ngii yā táⁿ'ā: Dii n'daataá, ¿tií canéé 'iiⁿ'yāⁿ chi tun'dáá nuuⁿndi yā yeⁿ'ē di? ¿'Áá ndii 'áámá 'iiⁿ'yāⁿ nguɛɛ ngaⁿ'a yā nuuⁿndi yeⁿ'ē di? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","N'daata mííⁿ ní ngaⁿ'ā tá: Señor, mar 'áámá 'iiⁿ'yāⁿ. Tuu'mi ní Jesús ngaⁿ'á yā ngii yā táⁿ'ā: 'Úú nguɛ́ɛ́ caaⁿ'máⁿ nuūⁿndī yeⁿ'ē di. Cunaⁿ'ā di ní 'āā ntɛ́ɛ́ diiⁿ nuuⁿndí di. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Cuayiivi Jesús ní ngaⁿ'ā ntúuⁿ yā ngii yā 'iiⁿ'yāⁿ: 'Úú tan'dúúcā dɛɛvɛ yeⁿ'e iⁿ'yeeⁿdí 'cūū, 'tíícā 'úú. Du'u chi can'daā 'úú nguɛ́ɛ́ caⁿ'a yā na maaíⁿ caati cunée yā ndúúcū chi dɛɛvɛ yeⁿ'ē vida. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tuu'mi ní ngaⁿ'ā saⁿ'ā fariseos ngii sa Jesús: Dii ní yeⁿ'ē maaⁿ di nduudu cuaacu chí ngaⁿ'ā di. Nduudu chí ngaⁿ'ā di nguɛ́ɛ́ nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nan'guɛɛcútaⁿ'ā Jesús ngaⁿ'a yā ngii yā saⁿ'ā: 'Úú ní ngaⁿ'á nduudu cuaacu yeⁿ'é maáⁿ. Nduudu chi ngaⁿ'á ní nduudu cuaacu miiⁿ. Deenú tií ndiicá ní tiī caⁿ'á. Naati ndís'tiī nguɛ́ɛ́ déénu nī tií ndiicá ní nguɛ́ɛ́ déénú nī tiī caⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ndís'tiī ní ngaⁿ'a nī nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ dacaā 'iiⁿ'yāⁿ. Naati 'úú nguɛ́ɛ́ ngaⁿ'á nuuⁿndi yeⁿ'ē mar 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ndúúti chi 'úú ngaⁿ'á nuuⁿndi yeⁿ'e 'iiⁿ'yāⁿ, nduudu yeⁿ'é ní nduudu cuaacu chii, caati 'úú ní nguɛɛ damaāáⁿ ti 'úú ní ndúúcū Chiidá chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Caati naachi canéé nguūⁿ na ley yeⁿ'é nī naachi ngaⁿ'ā na 'uuvi 'iiⁿ'yāⁿ, chii chi nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'Úú chi ngaⁿ'á nduudu cuaacu yeⁿ'é māaⁿ. Ní Chiidá chi dichó'o yā 'úú ngaⁿ'á yā nduudu cuaacu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tuu'mí ngaⁿ'ā sáⁿ'ā s'eeⁿ ngii sa Jesús: ¿Tií canéé Chiida di? Nan'guɛɛcútaⁿ'ā Jesús: Nduuti chi nguɛ́ɛ́ 'āā n'diichi nī 'úú, ndíí nguɛ́ɛ́ ndúú 'āā n'diichi nī Chiidá. Ndúúti chi 'āā n'diichi nī 'úú, 'tiicá ntúūⁿ 'āā n'diichi nī Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ndúúdú 'cūū ngaⁿ'ā Jesús taachi canée yā naachi snúūⁿ cajas yeⁿ'e ofrendas. Tuu'mi ní taachí ngi'cueéⁿ yā chɛɛti yáácū templo mar 'áámá 'iiⁿ'yāⁿ inátuu'vi yā Jesús caati 'āā 'cuɛ́ɛ́ cunuūⁿ ca'a hora yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ngaⁿ'a ntúuⁿ yā ngii yā saⁿ'ā: 'Úú ní caⁿ'á ní ndís'tiī in'nuúⁿ nī 'úú. Ná nuuⁿndi yeⁿ'é nī 'cūūvi nī. Naachi 'úú caⁿ'á ndís'tiī ní nguɛ́ɛ́ cuuvi ndaá nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tuu'mi saⁿ'ā Israel s'eeⁿ ngaⁿ'a sa: ¿'Áá 'caaⁿ'nuⁿ maáⁿ yā 'iiⁿ'yāⁿ caati ngaⁿ'a yā: Naachi 'úú caⁿ'á, ndís'tiī nguɛ́ɛ́ cuuvi ndaa nī? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tuu'mi ní Jesús ngaⁿ'a yā ngiī yā saⁿ'ā: Ndís'tiī ní yeⁿ'ē cuaaⁿ ndiiyā ndís'tiī niicu 'úú ní yeⁿ'ē cuaaⁿ 'niiⁿnuⁿ 'úú. Ndís'tiī ní yeⁿ'e iⁿ'yeeⁿdí 'cūū ndís'tiī naati 'úú ní nguɛ́ɛ́ yeⁿ'ē iⁿ'yeeⁿdí 'cūū 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Caavā chúū chi ngaⁿ'á ngií ndís'tiī chi 'cuūvi nī na nuuⁿndi yeⁿ'e nī. Ndúúti chi nguɛ́ɛ́ cu'téénu nī chi 'úú chi Cristo miiⁿ tuu'mi ní na nuuⁿndi yeⁿ'é nī ní 'cuūvi nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ni ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ: ¿Díí du'ū dii? Tuu'mi ní Jesús ngaⁿ'a yā ngíi yā saⁿ'ā: Tan'dúúcā nūuⁿ chí ngaⁿ'á ndii cuaaⁿ vmnaaⁿ, 'tíícā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nééné n'deēe dendú'ū chi canéé chí caāⁿ'máⁿ ndúúcū ndis'tíī ní diíⁿ juzgar ndis'tiī. 'Iiⁿ'yāⁿ chi dichó'o yā 'úú, 'iiⁿ'yāⁿ mííⁿ chí cuaacu yā. Chííⁿ chí n'giindiveéⁿ yeⁿ'e yā, chiiⁿ ngaⁿ'á na iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","'Iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ tuumicádíínuuⁿ yā chi 'iiⁿ'yāⁿ miiⁿ ní ngaⁿ'á yā yeⁿ'ē Chiidá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tuu'mí ngaⁿ'ā Jesús ngiī yā saⁿ'ā: Taachí nadacuéeⁿ nī Saⁿ'ā chi Daiya Dendyuūs, tuu'mi ní cuuvi déénu nī chi 'úú. Nguɛ́ɛ́ du'ū vɛɛ chi diíⁿ chi yeⁿ'ē maáⁿ naati Chiidá chi'cueé yā 'úú. Ní chííⁿ chí ngaⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ní 'iiⁿ'yāⁿ chi dichó'o yā 'úú canée yā nduucú. Chiidá ní nguɛ́ɛ́ chi'neeⁿ yā 'úú dámaáⁿ. Naati 'úú ní diíⁿ tanducuéⁿ'ē chi neⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Taachí ngaⁿ'á Jesús chuū nééné 'yaaⁿ 'iiⁿ'yāⁿ chi'téénu yā yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tuu'mí ngaⁿ'ā Jesús ngiī yā saⁿ'ā Israel seⁿ'e chi i'téénu sa 'yā: Ndúúti chi ndís'tiī cunée nī ndúúcū nduudu yeⁿ'é tuu'mi ní cuaacu chí ndis'tiī discípulos yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ní n'diichí nī nduudu cuaacu. Ní caavā nduudu cuaacú miiⁿ ndís'tiī nanguáⁿ'ai nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nan'guɛɛcútaⁿ'ā saⁿ'ā yeⁿ'é yā: Nús'uu ní ndaata yeⁿ'ē Abraham. Níícú mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ dichii'vɛ 'nū. ¿Táácā chí ngaⁿ'a di chi ndís'tiī ní canee chí nanguáⁿ'ai nī? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús ní nan'guɛɛcutáⁿ'a yā yeⁿ'ē sa: Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī chi nducyáácá 'iiⁿ'yāⁿ chi diíⁿ yā nuuⁿndi, 'iiⁿ'yāⁿ s'tíī dichíí'vɛ yā yeⁿ'ē nuuⁿndi. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","'Iiⁿ'yāⁿ chi diiⁿ mandado yeⁿ'ē 'iiví yā nguɛ́ɛ́ 'áámá ineéⁿ yā ndúúcū familia yeⁿ'e 'iiví yā naati daiya 'iiví miiⁿ ní 'áámá cuneéⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ndúúti chi Daiyá yā nadinguáⁿ'ai yā, cuaacu nííⁿnyúⁿ chí ndís'tiī ní nínguaⁿ'ai nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","'Úú deenú chi ndís'tiī chi ndaata yeⁿ'é Abraham. Naati dinúúⁿ yiinu nī chí neⁿ'e 'caaⁿ'núⁿ nī 'úú, caati nduudu yeⁿ'é nguɛ́ɛ́ ngii neé ndúúcū ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Chiiⁿ chi n'diichí ndúúcū Chiidá, chiiⁿ chi 'úú ngaⁿ'á. Ndís'tiī ní diíⁿ nī chi n'diichí nī chiidá nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","'Iiⁿ'yāⁿ s'eeⁿ nan'guɛɛcutáⁿ'a yā yeⁿ'é yā ní ngaⁿ'á yā: Chiidá 'nū Abraham. Ngaⁿ'a Jesús ngíi yā saⁿ'ā: Nduuti chi daiya Abraham ndís'tiī tuu'mi ní ntiiⁿnyuⁿ yeⁿ'ē sa idíiⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Naati maaⁿ ní idinúuⁿ yiinu nī chi 'caaⁿ'nuⁿ nī 'úú, caati 'úú saⁿ'ā chi ngaⁿ'a nduudu cuaacu chi ch'iindiveéⁿ yeⁿ'ē Dendyuūs. Abraham nguɛ́ɛ́ diiⁿ sa chuū. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ndís'tiī ní diíⁿ nī ntiiⁿnyuⁿ yeⁿ'e chiidá nī. Tuu'mi ní ngaⁿ'a sa ngii sa Jesús: Nús'uū nguɛ́ɛ́ ch'iindiyáaⁿ 'nū yeⁿ'ē daiya sa saⁿ'ā cyúúní. Canéé 'áámá chiidá 'nū chi Dendyuūs miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tuu'mi ní ngaⁿ'a Jesús ngiī yā saⁿ'ā s'eeⁿ: Ndúúti chi chiidá nī chi Dendyuūs miiⁿ cuaacu nííⁿnyúⁿ chi dinéⁿ'e nī 'úú, caati 'úú ní yeⁿ'é Dendyuūs chiicá ní ndaá. Ní nguɛ́ɛ́ ndaá yeⁿ'é maáⁿ ti Ndyuūs maáⁿ yā dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Dɛ'ɛ cuuvi chi nguɛɛ n'gúuⁿ nī nduudu yeⁿ'é? Ti nguɛɛ n'giindiveéⁿ nī nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ndís'tiī ní yááⁿn'guiinūuⁿ chiidá nī. Ndís'tiī ní neⁿ'é nī diíⁿ nī tanducuéⁿ'ē chi neⁿ'ē chiida nī. Yááⁿn'guiinūuⁿ chí n'giīⁿ'nūⁿ 'āā canéé núuⁿ yā ndíí naachi nga'ā. Nguɛ́ɛ́ 'áámá caneé yā na nduudu cuaacu ti nguɛ́ɛ́ nduudu cuaacu nduucú yā. Taachí yááⁿn'guiinuuⁿ ngaⁿ'ā sa nduudu yaadi yeⁿ'ē maaⁿ sa ngaⁿ'a sa ti saⁿ'ā yeⁿ'ē nduudu yaadi ní chiida nduudu yaadi sáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Naati 'úú ní ngaⁿ'á nduudu cuaacu ní nguɛ́ɛ́ i'téénu nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Du'ú yeⁿ'ē ndís'tiī ngaⁿ'a chi idiíⁿ nuuⁿndi? Ní nduutī chi 'úú ní ngaⁿ'á nduudu cuaacu, ¿dɛ'ɛ̄ chi nguɛ́ɛ́ i'téénu nī 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Du'u chí yeⁿ'ē Dendyuūs miiⁿ nduudu yeⁿ'ē Dendyuūs n'giindiveéⁿ yā. Chiiⁿ chí ndís'tiī ní nguɛ́ɛ́ n'giindiveéⁿ nī ti nguɛ́ɛ́ yeⁿ'é Dendyuūs ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tuu'mi ní nan'guɛɛcútaⁿ'ā saⁿ'a Israel s'eeⁿ ní ngaⁿ'a sa ngii sa Jesús: ¿'Áá nguɛ́ɛ́ cuaacu ngaⁿ'ā nús'uū chi samaritano dii, ní cánéé dí ndúúcū yááⁿn'guiinūuⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nan'guɛɛcútaⁿ'ā Jesús: 'Úú nguɛ́ɛ́ cánéé ndúúcū yááⁿn'guiinūuⁿ. 'Úú diíⁿ honrar Chiidá. Ndís'tiī nguɛ́ɛ́ i'téénu nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Úú ní nguɛ́ɛ́ in'nuúⁿ honra yeⁿ'é māaⁿ. Vɛ́ɛ́ 'iiⁿ'yāⁿ chi in'nuúⁿ yā honra yeⁿ'é ní diíⁿ yā juzgar 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī: Du'u chí n'giindiveēⁿ nduudu yeⁿ'é nguɛ́ɛ́ n'diichí yā vaadī n'gii taanduvɛ́ɛ́ nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tuu'mi ní saⁿ'a Israel s'eeⁿ ngaⁿ'ā sa ngii sa Jesús: Maaⁿ ní tuumicádíínuuⁿ 'nū yeⁿ'ē di. Canee di ndúúcū yááⁿn'guiinūuⁿ. Abraham miiⁿ ní ch'iī ndúúcū profetas 'iicu díí ní ngaⁿ'ā di: Du'u chi n'giindiveēⁿ nduudu yeⁿ'é nguɛ́ɛ́ n'diichíneéⁿ yā vaadī n'gii taanduvɛ́ɛ́ nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿'Áá vmnaaⁿ ntuūⁿ ca dii yeⁿ'ē chiida yú Abraham chi ch'īi yā ní yeⁿ'e profetas chí ch'īi yā? ¿Du'ū nadacádiinuuⁿ di chi máāⁿ di? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nan'guɛɛcútaⁿ'ā Jesús: Ndúúti chi 'úú diíⁿ honrar māaⁿ tuu'mi ní honra yeⁿ'é ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ. Chiidá mííⁿ chi idiíⁿ yā honrar 'úú. Ní yeⁿ'e chiidá chí ngaⁿ'ā ndís'tíī chi Dendyuūs yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ní nguɛ́ɛ́ 'āā n'diichí nī 'iiⁿ'yāⁿ naati 'úú 'āā nin'diichí 'iiⁿ'yāⁿ. Ndúúti chi ngaⁿ'á chi nguɛ́ɛ́ nin'diichí 'iiⁿ'yāⁿ tan'dúúcā chí yaadi ndís'tiī, 'tíícā ntúúⁿ 'úú. Caati 'āā n'diichí 'iiⁿ'yāⁿ ní n'giindiveéⁿ nduudu yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Chiidá nī Abraham yéénú taavi sa chi 'āā n'diichī sa nguuvī yeⁿ'é. Ní 'āā n'diīchī sa. Ní yéénú taavi sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tuu'mi ní ngaⁿ'a 'iiⁿ'yāⁿ Israel s'eeⁿ: ¿'Áá 'āā cuɛ́ɛ́ cuuvi 'uuvi ngɛɛcu ndiichi nduūyū ní 'āā n'diichi di Abraham? ");
INSERT INTO cuxNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ní ngaⁿ'a Jesús ngiī yā saⁿ'a: Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī chi 'úú vmnááⁿ vmnaaⁿ chi Abraham. ");
INSERT INTO cuxNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tuu'mi ní saⁿ'ā s'eeⁿ sta'á sa tuūu chi ca'a sa Jesús, naati Jesús ní canúúⁿ n'de'éi yā ní nan'dáa yā chɛɛti yáacū templo ní cho'ó yā náavtaⁿ'á yā 'ííⁿ'yāⁿ s'eeⁿ. Ní cunaⁿ'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Níícú taachi cho'ōo Jesús ní n'diichí yā 'áámá saⁿ'ā chi ngueēe nduutináaⁿ sa ndíí taachí ch'iindiyáaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Níícú discípulos yeⁿ'é yā ntiinguuneeⁿ yā Jesús ní ngaⁿ'a yā ngiī yā 'iiⁿ'yāⁿ: N'dii Maestro, ¿du'u dínuūⁿndí? ¿'Áá chiida sa ndúúcū chɛɛcu sa vɛɛ nuuⁿndi yeⁿ'é yā? ¿'Áá maaⁿ sa 'tíícā sa chí ngueēé nduutináaⁿ sa taachí ch'iindiyáaⁿ sa? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Nan'guɛɛcútaⁿ'ā Jesús ní nguɛ́ɛ́ ndúú sáⁿ'a cūū ní nguɛ́ɛ́ chiida sa ndúúcū chɛɛcu sa vɛɛ nuuⁿndí yeⁿ'é yā chi ngueēe nduutináaⁿ sa. 'Tíícā saⁿ'ā ní 'cuuⁿ'miⁿ chi diiⁿ Déndyuūs miiⁿ nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Cánéé chí diíⁿ ntiiⁿnyuⁿ chi idiiⁿ 'iiⁿ'yāⁿ chi dicho'ó yā 'úú neⁿ'e chi vɛ́ɛ́ nguuvi. Ndaá chi cuuvi 'da'a taachi mar 'áámá 'iiⁿ'yāⁿ ní nguɛ́ɛ́ diíⁿ yā ntiiⁿnyuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nuuma neⁿ'e chí cuneé iⁿ'yeēⁿdī 'úú chi cuneé tan'dúúcā dɛɛvɛ yeⁿ'ē iⁿ'yeēⁿdī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Taachí níngaⁿ'a yā chuū chiīdaiⁿ yā na yáⁿ'āa níícú in'dái yā inchɛɛtí ndúúcū nuuⁿniⁿ daíⁿ yā. Níícú s'néeⁿ yā nchɛɛtí nduutináaⁿ saⁿ'ā ngueenááⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ní ngaⁿ'a yā: Cúnaⁿ'ā dí. Nááⁿnú dí nduutináaⁿ di na cheendi yíívɛ yeⁿ'ē Siloé. (Nduudu miiⁿ neⁿ'e caaⁿ'maⁿ Dichó'o Yā.) Tuu'mi ní cunaⁿ'ā sa ní naāⁿnu sa ní nguɛɛcundíi sa 'āā inaaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tuu'mi ní 'iiⁿ'yāⁿ na nííⁿnúⁿ va'ai yeⁿ'ē sa ndúúcū 'iiⁿ'yāⁿ chi 'āā ndíí vmnaaⁿ n'diichí yā saⁿ'ā chi ngueenáaⁿ ní ngaⁿ'a yā: ¿'Áá nguɛ́ɛ́ sáⁿ'a 'cūū n'giīndī ngiica limosna? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","N'duuví yā ngaⁿ'a yā: Sáⁿ'a 'cūū. Ta n'duuví yā ní ngaⁿ'a yā: Tan'dúúcā saⁿ'ā miiⁿ, 'tíícā saⁿ'ā. Saⁿ'ā miiⁿ ngaⁿ'a sa: 'Úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ngaⁿ'a yā ngiī yā saⁿ'ā: ¿Taaca nínguaaⁿ nduutináaⁿ di? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","N'guɛɛcútaⁿ'ā sa ní ngaⁿ'ā sa: Saⁿ'ā chi nguuvi Jesús miiⁿ din'dái sa nchɛɛtí ní chi'neeⁿ sa nduutinaáⁿ. Ní ngaⁿ'ā sa ngii sa 'úú: Cueⁿ'e di cheendi yiivɛ nuūⁿnīⁿ yeⁿ'ē Siloé. Naaⁿnu di nduutináaⁿ di. Níícú cheⁿ'é, ní naāⁿnu nduutinaáⁿ, ní 'āā inaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tuu'mi ní ngaⁿ'a yā ngiī yā saⁿ'ā: ¿Tii canéé saⁿ'ā miiⁿ? Tuu'mí ngaⁿ'ā sa: Nguɛ́ɛ́ deenú. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuu'mi ní candɛ́ɛ yā saⁿ'ā chi ngueenaáⁿ ndíí cuaaⁿ vmnaaⁿ nanááⁿ saⁿ'ā fariseos. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ni sábado miiⁿ nguuvi chí ntaavi'túúnuuⁿ 'iiⁿ'yāⁿ Israel chi Jesús idin'dái yā nchɛɛtí mííⁿ. Ní nin'guáaⁿ yā nduutinaaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tuu'mi ní ntiinguuneeⁿ ntúuⁿ yā fariseos: ¿Táácā 'āā inaaⁿ di? Tuu'mi ní ngaⁿ'ā sa: S'néeⁿ yā nchɛɛtí na nduutinaáⁿ, níícú naāⁿnú. Maaⁿ ní inaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tuu'mi ní 'áámá saⁿ'ā fariseo ngaⁿ'a sa: Sáⁿ'a 'cūū ní nguɛ́ɛ́ yeⁿ'é Dendyuūs saⁿ'ā caati nguɛ́ɛ́ diiⁿ sa nguuvi sábado tan'dúúcā chi ngaⁿ'a ley yeⁿ'e yú. Ta n'duuvi sa ngaⁿ'a sa: ¿Táácā saⁿ'ā chi vɛ́ɛ́ nuuⁿndi yeⁿ'ē sa diiⁿ sa señales chi 'tuucā? 'Uuvi nuúⁿ díiⁿ sa vaanicadíínuūⁿ yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nguɛɛcundíí ntúuⁿ sa ní ngaⁿ'a sa ngii sa saⁿ'ā chi ngueenáaⁿ sa: Díí, ¿dɛ'ɛ́ ngaⁿ'a di yeⁿ'ē saⁿ'a chí nan'guaaⁿ nduutináaⁿ di? Saⁿ'ā miiⁿ ngaⁿ'ā sa: 'Iiⁿ'yāⁿ miiⁿ profeta. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Saⁿ'a Israel s'eeⁿ nguɛ́ɛ́ i'téénu sa yeⁿ'e saⁿ'ā chí chingueēnáaⁿ sa ní inaaⁿ sa ndíí 'cai yā chiida sa ndúúcū chɛɛcu sa yeⁿ'ē sáⁿ'ā chí 'āā inaaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ní ntiinguunééⁿ saⁿ'ā s'eeⁿ 'iiⁿ'yāⁿ, ní ngaⁿ'ā sa: ¿'Áá sáⁿ'a 'cūū daiyá nī, saⁿ'ā chi ngaⁿ'ā ndís'tiī chí ch'iindiyáaⁿ sa 'āā ngueenáaⁿ sa? ¿Tááca chi maaⁿ inaaⁿ sa? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nan'guɛɛcutáⁿ'a yā chiida sa ndúúcū chɛɛcu sa ní ngaⁿ'a yā 'iiⁿ'yāⁿ: Déénu 'nū daiya 'nū saⁿ'á 'cūū 'āā ngueeé nduutináaⁿ sa taachi ch'iindiyáaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Maaⁿ ní inaaⁿ sa. Nguɛ́ɛ́ déénu 'nū táácā ínaaⁿ sa. Du'ú yā chi nin'guaaⁿ yā nduutináaⁿ sa nús'uu nguɛ́ɛ́ déénu 'nū. Saⁿ'ā tii 'āā 'naaⁿ sa, ntiingúúneeⁿ nī saⁿ'ā. Saⁿ'ā tii caaⁿ'maⁿ sa yeⁿ'ē maaⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chuū chi nan'guɛɛcutáⁿ'a sa chiida sa ndúúcū chɛɛcu sa, caati 'va'á yā 'iiⁿ'yāⁿ Israel s'eeⁿ. Caati 'iiⁿ'yāⁿ Israel s'eeⁿ 'āā indeē sa chi du'ū chi caaⁿ'maⁿ chi Mesías chí Cristo miiⁿ chuū ní tun'daa yā chɛɛti yaācū. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chii chi 'tíícā caⁿ'ā chiida sa ndúúcū chɛɛcu sa: Sáⁿ'ā 'caa 'āā 'nāaⁿ sa. Ntííngúúneeⁿ nī saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","'Tíícā ní 'caī ntúuⁿ yā saⁿ'ā chí ngueenááⁿ níícú ngaⁿ'a yā ngiī yā saⁿ'ā: Dii, ní ca'a di honra Dendyuūs. Nús'uu deenu 'nū chí sáⁿ'a 'cūū vɛ́ɛ́ nuuⁿndi yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tuu'mi ní nan'guɛɛcutáⁿ'a sa ní caⁿ'ā sa: Ndúúti chi nuuⁿndi yā o nguɛ́ɛ́ nuuⁿndi yā nguɛ́ɛ́ deenú. 'Áámá chi deenú chi ngueeé nduutinaáⁿ ní maaⁿ ní ināaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ní ngaⁿ'ā ntúuⁿ yā ngii yā saⁿ'ā: ¿Dɛ́'ɛ̄ diíⁿ yā ndúúcū dii? ¿Táácā 'āā inaaⁿ di? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nan'guɛɛcutáⁿ'a sa yeⁿ'é yā: 'Āā ngaⁿ'á ngií ndís'tiī ní nguɛ́ɛ́ ch'iindiveéⁿ nī. ¿Dɛ'ɛ̄ cúúví chi neⁿ'ē ntúuⁿ nī 'caandiveéⁿ nī? ¿'Áá neⁿ'é nī ntúuⁿ ndís'tiī chi cuuvi discípulos yeⁿ'é yā ndís'tiī? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ní 'caa'vá yā ndúúcu sa ní caⁿ'a yā: Díí, chí discípulo yeⁿ'é yā dii, naati nús'uū discípulos yeⁿ'ē Moisés nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nús'uu ní déénu 'nū chi Dendyuūs ní yaa'vi yā Moisés naati nguɛ́ɛ́ déénu 'nū tií ndiica sáⁿ'a 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nan'guɛɛcutáⁿ'a saⁿ'ā miiⁿ ní caⁿ'a sa: Chuū ní cuaacu ní cosa chi 'āā ngeⁿ'e yiinu yú caati ndís'tiī nguɛ́ɛ́ déénu nī tií ndiicá yā ní nn'guaaⁿ yā nduutinaáⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ní deenu yú chi Dendyuūs ní nguɛ́ɛ́ n'giindiveé yā yeⁿ'e 'iiⁿ'yāⁿ nuuⁿndi. Du'ú 'iiⁿ'yāⁿ chi neⁿ'ē Dendyuūs níícú idiíⁿ yā chiiⁿ chi neⁿ'ē Dendyuūs, tuu'mi ní Dendyuūs mííⁿ nn'giindiveéⁿ yā yeⁿ'ē 'iiⁿ'yāⁿ 'cúū. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ní taachi chi nga'ā iⁿ'yeeⁿdí 'cūū, nguɛ́ɛ́ ch'iindiveeⁿ yú chi mar 'áámá 'iiⁿ'yāⁿ nn'guaaⁿ yā nduutinaáⁿ 'iiⁿ'yāⁿ chi ngueenááⁿ ndíí ch'iindiyáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ndúúti chi 'iiⁿ'yāⁿ 'cúū chi nguɛ́ɛ́ yeⁿ'é Dendyuūs 'iiⁿ'yāⁿ, tuu'mi ní nguɛ́ɛ́ du'ū vɛɛ cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nan'guɛɛcútaⁿ'ā 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā chii yā saⁿ'ā: Dii ní na nuuⁿndi ch'iindiyáaⁿ di. ¿'Áá dii ngi'cuééⁿ dí nús'uū? Ní tun'daa yā saⁿ'a chɛɛti yaācū. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús ch'iindiveéⁿ yā chi 'āā tun'dáa yā saⁿ'ā chiva'āī yaacu templo. Taachi nindaaca yā saⁿ'ā ní ngaⁿ'a yā ngii yā saⁿ'ā: ¿'Áá i'téénu dí Daiya Dendyuūs miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tuu'mi ní nan'guɛɛcutáⁿ'a sa ní caⁿ'a sa: Señor, ¿du'ū mííⁿ, ní 'tíícā cu'teenú? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ní ngaⁿ'a Jesús ngii yā saⁿ'ā: In'diichi dí 'iiⁿ'yāⁿ ní 'iiⁿ'yāⁿ miiⁿ ní 'iiⁿ'yāⁿ chi indeé yā ndúúcū di. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tuu'mi ní ngaⁿ'ā sa ngii sa Jesús: Señor, cu'teenú n'diī. Ní diiⁿ sa adorar yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ní ngaⁿ'ā Jesús: 'Úú nindaá iⁿ'yeeⁿdí 'cūū chí caaⁿ'máⁿ nuuⁿndi yeⁿ'é 'iiⁿ'yāⁿ caati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ inaáⁿ yā ní naáⁿ yā. Ní 'iiⁿ'yāⁿ chí cuuvi inaáⁿ yā cuuvi ngueenáaⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","N'duuvi 'iiⁿ'yāⁿ fariseos chi canée yā ndúúcu yā ch'iindiveéⁿ yā chuū ní caⁿ'á yā Jesús: ¿'Áá ngueēe ntúuⁿ nduutináaⁿ 'nū tuu'mi? ");
INSERT INTO cuxNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tuu'mi ní ngaⁿ'a Jesús ngii yā saⁿ'ā s'eeⁿ: Ndúúti ngueenáaⁿ nī nguɛ́ɛ́ nuuⁿndi yeⁿ'e nī. Naati maaⁿ ní ngaⁿ'a nī: Inaaⁿ 'nū. Chiiⁿ chi nuuⁿndi yeⁿ'é nī 'áámá cunéé nūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī: Du'u chi nguɛ́ɛ́ indaā cuaaⁿ cheendi chéēⁿ yeⁿ'ē 'iiti cuūchī naati ngɛ'ɛ́ yā na chéēⁿ táámá lado, tuu'mi ní 'iiⁿ'yāⁿ 'cúū duucú yā ní diduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Du'ú 'iiⁿ'yāⁿ chi indáa yā cuaaⁿ cheendi chéēⁿ miiⁿ, 'iiⁿ'yāⁿ miiⁿ ineenaáⁿ yā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","'Iiⁿ'yāⁿ ineenaáⁿ yā cheendi chéēⁿ ní inin'guaáⁿ yā cheendi chéēⁿ caavā 'iiⁿ'yāⁿ miiⁿ ní 'iití cuūchī n'giindiveéⁿ tī nduudu yeⁿ'é yā. Ní n'gaí yā duuchi 'iiti cuūchī yeⁿ'é yā. Ní n'daá tī saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Taachi intuun'dáa yā tanducuéⁿ'ē 'iiti yeⁿ'é yā cuaaⁿ dáámí cheēⁿ candɛ́ɛ tī vmnaaⁿ yeⁿ'é tī. Níícú 'iiti cuūchī cueⁿ'é tī cuayiivi 'iiví tī. Caati 'caandiveéⁿ tī nduudu yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Nguɛ́ɛ́ can'dáa tī 'iiⁿ'yāⁿ chi nguɛ́ɛ́ 'iiví tī níícú ngéenu tī yeⁿ'é yā caati nguɛ́ɛ́ 'caandiveéⁿ tī nduudu yeⁿ'é yā chi nguɛ́ɛ́ 'iiví tī 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Chuū cuenta chi caⁿ'a Jesús 'iiⁿ'yāⁿ ní 'iiⁿ'yāⁿ miiⁿ nguɛ́ɛ́ tuumicadíínuuⁿ yā dɛ'ɛ̄ chí caⁿ'ā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nguɛɛcúndíí ntuūⁿ Jesús ní ngaⁿ'a yā: Cuaacu nííⁿnyúⁿ, cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī: 'Úú tan'dúúcā cheendi cheēⁿ naachi cho'ō 'iiti cuūchī. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tanducuéⁿ'ē 'iiⁿ'yāⁿ chí ndaá yā vmnaaⁿ yeⁿ'ē 'úú, 'iiⁿ'yāⁿ s'eeⁿ ní duucu yā ní diduucúū ntúuⁿ yā. Caati nguɛ́ɛ́ ch'iindiveéⁿ yā 'iiti cuūchī miiⁿ yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Úú tan'dúúcā cheendi cheēⁿ 'úú. Du'ú 'iiⁿ'yāⁿ chí indaā caavā yeⁿ'é, ninguaⁿ'ai yā. Ní can'dáa yā. Ní nndaa ntuúⁿ yā. Ní ndaacá yā chi che'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Duucú mííⁿ taachi ndaa sa miiⁿ, iduucu sa. Ní n'giiⁿ'nuⁿ sa ní nadi'tuuvi sa. 'Úú nindāa chí ca'á vida níícú ca'á vida chi yeenú taavi yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","'Úú 'iivi 'iiti cuūchī chi n'dai taaví. 'Iiví 'iiti cuūchī chi n'dai taaví yā, nga'á yā vida yeⁿ'e maáⁿ yā caavā 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","'Iiⁿ'yāⁿ chí canee naáⁿ 'iiti cuūchī chi nguɛ́ɛ́ yeⁿ'é yā 'iiti ní nguɛ́ɛ́ 'iiví tī 'iiⁿ'yāⁿ. Taachí ináaⁿ yā yááⁿyāaⁿ ngaātáa chi cuchií tī ní cu'néeⁿ yā 'iiti cuūchī ní ngeⁿ'e yā ngéénu yā. Ní yááⁿyāaⁿ ngaātáa cúchií tī miiⁿ ní cuta'á tī 'iiti cuūchī ní 'iiti cuūchī miiⁿ idii'yáa tī ngii ní ngéénu tī. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā 'iiti ngéénu yā caati nguɛ́ɛ́ yeⁿ'é yā 'iiti. Ní nguɛ́ɛ́ idiíⁿ yā cuidado 'iiti cuūchī. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","'Úú 'iivi n'dai taavi 'iiti cuūchī. Ní canúnaáⁿ 'iiti cuūchī yeⁿ'é. Ní 'iiti cuūchī yeⁿ'é ní canúnaáⁿ tī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Tan'dúúcā chi Chiidá in'diichí yā 'úú, 'tíícā 'úú in'diichí Chiidá. Ní nga'á vida yeⁿ'é cucaava 'iiti cuūchī. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Vɛ́ɛ́ ntúūⁿ ta n'duuvi 'iiti cuūchī yeⁿ'é chi nguɛ́ɛ́ yeⁿ'ē cheēndī chéeⁿ 'cūū 'iiti. 'Iiti miiⁿ ntúūⁿ ní cánéé chí candɛɛ́ 'iiti. Ní 'caandiveéⁿ tī chí caāⁿ'máⁿ níícú 'áámá cheēⁿ nduuví tī ní 'áámá nūuⁿ 'ííví 'iiti. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Caavā chiiⁿ chí neⁿ'e Chiidá 'úú caati 'úú ca'á vida yeⁿ'e maáⁿ chi ní nanguɛɛcundíí ntuúⁿ cuta'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuvi 'caaⁿ'núⁿ yā 'úú naati 'úú ca'á vida yeⁿ'e maáⁿ. Cuuví diíⁿ cu'neéⁿ vida yeⁿ'é ní cuuví diíⁿ cuta'á. Chuū mandamiento chi diíⁿ chi ngaⁿ'ā Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ch'ííndi ntúūⁿ vaadī 'caa'va nguaaⁿ náⁿ'ā 'iiⁿ'yāⁿ Israel s'eeⁿ cáávā nduudú 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Nééné 'yaaⁿ 'iiⁿ'yāⁿ Israel caⁿ'a yā chuū: Canée yā ndúúcū yááⁿn'guiinūuⁿ ní nguɛɛ nndɛɛ́ yā vaanicadiinúúⁿ yeⁿ'é yā. ¿Dɛ'ɛ̄ cúúví chí n'giindiveéⁿ nī yeⁿ'e yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tá n'duuví yā ní ngaⁿ'a yā: Ndúúdú 'cāā ní nguɛ́ɛ́ yeⁿ'ē 'iiⁿ'yāⁿ chi canéé ndúúcū yááⁿn'guiinūuⁿ. ¿'Áá cúúví nán'guaaⁿ yááⁿn'guiinūuⁿ nduutinaáⁿ 'iiⁿ'yāⁿ chi ngueenáāⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ch'iindī 'víícú yeⁿ'ē dedicación na yáāⁿ Jerusalén tiempo chi 'iichɛɛ. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Níícú Jesús cachiicá yā chɛɛti yaācū templo na corredor chi nguuvi Salomón. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","'Iicu saⁿ'a Israel s'eeⁿ ní cheⁿ'e sa nduuvidaama sa nanáaⁿ yā ní caⁿ'a sa chii sa Jesús: ¿Tií cuaⁿ'ā castaⁿ'ā di chídɛɛvɛ yeⁿ'e 'nū? Ndúúti chi dii chi Cristo miiⁿ, caaⁿ'maⁿ cuaacú dí cuuvi dí nús'uū. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nan'guɛɛcútaⁿ'a Jesús yeⁿ'ē sa: 'Āā ngií ndís'tiī ní nguɛ́ɛ́ i'teenu nī. Ntiiⁿnyuⁿ chi diíⁿ ndúúcū chi dúúchī Chiidá, chuū ngaⁿ'ā nduudu cuaacu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ndís'tiī nguɛ́ɛ́ i'téénu nī caati nguɛ́ɛ́ 'iiti cuūchī yeⁿ'é ndís'tiī, tan'duucā 'āā ngaⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Iiti cuūchī yeⁿ'é n'giindiveéⁿ tī nduūdū yeⁿ'é ní 'úú in'diichí ntúuⁿ 'iitī. Ní 'iitī miiⁿ can'daa tī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Úú ní nga'á vida cueⁿ'e daāⁿmaⁿ yeⁿ'é tī ní nguɛ́ɛ́ 'cūūvi ti. Ni mar 'áámá 'iiⁿ'yāⁿ cuuví cuta'á yā 'iiti s'eeⁿ taachí 'āā canéé ta'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Chiidá chi tée yā 'iiⁿ'yāⁿ s'eeⁿ 'úú vmnaáⁿ yā yeⁿ'ē nducyáácá 'iiⁿ'yāⁿ. Mar 'áámá 'iiⁿ'yāⁿ cuuví cuta'á yā taachi 'āā canéé ta'ā Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'Úú ndúúcū Chiidá 'áámá núúⁿ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tuu'mi ní sta'ā ntúūⁿ saⁿ'a Israel s'eeⁿ túūu chi neⁿ'e ca'a sa Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nan'guɛɛcútaⁿ'a Jesús 'iiⁿ'yāⁿ: Nééné n'deēe n'daacā ntiiⁿnyuⁿ chí n'giⁿ'i yeⁿ'ē Chiidá. ¿Chɛ́ɛ́ ntiiⁿnyuⁿ chi nguɛ́ɛ́ innéé yiinú ndís'tiī chi ngiituú nī 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nan'guɛɛcútaⁿ'ā saⁿ'a Israel s'eeⁿ ní ngaⁿ'ā sa ngii sá Jesús: Nguɛ́ɛ́ caavā ntiiⁿnyuⁿ n'daacā chi ngiituú 'nū dii naati cáávā chi ngaⁿ'ā di chi nguɛ́ɛ́ n'daacā, ní caati dii chí saⁿ'ā iⁿ'yeeⁿdí 'cūū ní diiⁿ di chi Dendyuūs dii. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Nan'guɛɛcútaⁿ'a Jesús yeⁿ'ē sa: ¿'Áá nguɛ́ɛ́ cánéé nguūⁿ na ley 'tíícā: 'Úú ningaⁿ'á chi ndyuūs s'eeⁿ ndís'tiī? ");
INSERT INTO cuxNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ndúúti chí ngaⁿ'á yā chi 'iiⁿ'yāⁿ miiⁿ ní ndyuús s'eeⁿ, 'iiⁿ'yāⁿ chi sta'á yā nduudu yeⁿ'e Dendyuūs níícú naachi cánéé nguūⁿ canéé chí cuuvi cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Chiidá indɛɛvɛ nuúⁿ yā 'úú ní dicho'ó yā 'úú iⁿ'yeeⁿdí 'cūū. ¿'Áá ndís'tiī ní ngaⁿ'a nī chi nguɛ́ɛ́ n'daacā yeⁿ'é chi 'úú nduuvidaamá ndúúcū Dendyuūs caati caⁿ'á chi 'úú Daiya Dendyuūs 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nduuti chi nguɛ́ɛ́ diíⁿ ntiiⁿnyuⁿ yeⁿ'ē Chiidá, nguɛ́ɛ́ cu'téénu di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Naati ndúútī chi diíⁿ ntiiⁿnyuⁿ miiⁿ 'áárá chi nguɛ́ɛ́ i'téénu di 'úú, cu'téénu di na ntiiⁿnyuⁿ chi diíⁿ. 'Iicu cuuvi deenu di ní cu'téénu di chi Chiidá canee nduucú níícú 'úú ní canéé ndúúcū Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ní neⁿ'e ntuuⁿ sa cuta'a sa Jesús, naati Jesús miiⁿ ní nan'dáa yā na ta'a sa s'uuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Níícú nguɛɛcúndii yā taama lado yeⁿ'ē yíícú Jordán na yáⁿ'āa miiⁿ naachi vmnááⁿ vmnaaⁿ nachɛɛdinúuⁿnīⁿ Juan. Níícú canée yā miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Níícú nééné 'yaaⁿ 'iiⁿ'yāⁿ ndaá yā nanáaⁿ yā, ní ngaⁿ'á yā: Nduudu cuaacu tii Juan miiⁿ ní 'áámá señal nguɛ́ɛ́ diiⁿ sa naati tanducuéⁿ'ē chi caⁿ'ā Juan yeⁿ'é yā, chuū nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Níícú nééné 'yaaⁿ 'iiⁿ'yāⁿ miiⁿ ní chi'téénu yā Jesús na yáⁿ'āa miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Vɛ́ɛ́ 'áámá sáⁿ'ā ngiītā sa chi nguuvi sa Lázaro na yáāⁿ Betania. Yáāⁿ miiⁿ vaacú tá María nduucū ví'i tá Marta. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Niicu tá María ní vi'i ta Lázaro. N'daataa miiⁿ ch'eendái tá aceite Jesús ní nātí'ī tá ca'a yā ndúúcū yuūdū tiīⁿ tá. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Vi'ī sa miiⁿ ní dichó'o ta 'áámá 'iiⁿ'yāⁿ chi yaa'ví yā yeⁿ'ē Jesús miiⁿ chi caⁿ'a yā: Señor, n'diichí nī. Saⁿ'ā chi néⁿ'e nī ní ngíítā sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Taachi ch'iindiveeⁿ Jesús chuū, ní caⁿ'a yā: Ca'āī miiⁿ ní nguɛ́ɛ́ ca'āī chi 'cuūvi sa, naati ca'āī chi diiⁿ honrar Dendyuūs, níícú cuuví yā honrar Daiyá Dendyuūs caava ca'ai 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Niicu Jesús ní ya'āī 'iinu yā Marta ndúúcū vi'i tá María ndúúcū vi'ī tá Lázaro. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Taachí Jesús ch'iindiveéⁿ yā chi ngiitā saⁿ'ā miiⁿ canée yā tá 'uuvi nguuvi lugar naachi canée yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cho'o 'uuvi nguuvi ngaⁿ'a Jesús ngii yā discípulos yeⁿ'é yā: Cuⁿ'u ntuūⁿ yú na yáⁿ'āa Judea. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ní discípulos ní ngaⁿ'á yā ngiī yā 'iiⁿ'yāⁿ: N'dii Maestro, ngiituūu 'iiⁿ'yāⁿ Israel s'eeⁿ n'diī. ¿'Áá neⁿ'e ntúuⁿ nī caⁿ'ā ni miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nan'guɛɛcútaⁿ'ā Jesús: ¿'Áá nguɛ́ɛ́ ndɛɛ̄ nguuvi ndiichúúví hora? 'Iiⁿ'yāⁿ chi chiicá yā nguuvi nguɛ́ɛ́ indɛɛ̄ ca'a yā tii inaaⁿ yā chí dɛɛvɛ yeⁿ'é iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","'Iiⁿ'yāⁿ chí ngiica na maāiⁿ indɛɛ̄ ca'á yā, ti nguɛ́ɛ́ chi dɛɛvɛ ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Caⁿ'a yā chuū, ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ: Lázaro amigo yeⁿ'e yú cyaadu sa. Caⁿ'á nanduūchí saⁿ'ā chi cyaadu sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Tuu'mí caⁿ'á discípulos yeⁿ'é yā: Señor, ndúútī chi cyaadu sa ní 'āā ninguaⁿ'āī sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Chuū ngaⁿ'ā Jesús miiⁿ yeⁿ'ē vaadī n'dii yeⁿ'ē Lázaro níícú 'iiⁿ'yāⁿ s'eeⁿ ní cadíínuuⁿ yā chi ngaⁿ'a yā chi cyaadu n'dai Lázaro. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tuu'mi ní Jesús caⁿ'a cuaacú yā: Lázaro miiⁿ ch'iī sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'Úú ní yeenú cáávā ndís'tiī chi nguɛ́ɛ́ caneé miiⁿ ní 'íícú cu'téénú nī. Naati caⁿ'ā yú n'diichi yú saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuu'mi ní caⁿ'ā Tomás, saⁿ'ā chi duuchi Dídimo chi Gemelo ní ngaⁿ'a sa ngii sa saⁿ'ā s'eeⁿ chi discípulos ndúúcū sa: Cúⁿ'u ntúúⁿ s'uúⁿ ní 'cuūvī yú ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Taachi ndaā Jesús miiⁿ ní 'āā cuūⁿ nguuví n'dii Lázaro canúúⁿ sa na chɛɛtī yáinyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ní yáāⁿ Betania 'āā niiⁿnuúⁿ ná yáāⁿ Jerusalén tan'dúúcā 'iinu kilómetro. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Neené 'yaaⁿ 'iiⁿ'yāⁿ ndaá yā na vaacu Marta ndúúcū María chí nica'á yā 'viichɛɛtínūuⁿ n'daata s'eeⁿ yeⁿ'ē vi'i yā Lázaro. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tuu'mi ní Marta miiⁿ taachí ch'iindiveéⁿ yā chí ndaā Jesús miiⁿ can'dáa yā chuva'ai ní nandaaca yā 'iiⁿ'yāⁿ. Naati María miiⁿ canúuⁿ yā chɛɛti va'ai. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ní Marta miiⁿ ní ngaⁿ'a yā ngii yā Jesús: Señor, ndúúti chi canée nī ndúúcu 'nū nguɛ́ɛ́ ch'iī vi'í. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Naati maaⁿ deenú chí tanducuéⁿ'ē chí caaca di Dendyuūs miiⁿ ní tée yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tuu'mí ngaⁿ'a Jesús ngii yā Marta: Nnduuchi ntuūⁿ ví'i di. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta ngaⁿ'a ta ngii ta Jesús: 'Úú ní deenú chí nduuchi ntúūⁿ sa ní nacueeⁿ sa nguuvi chi 'cuiinu iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ní ngaⁿ'a Jesús ngiī yā táⁿ'ā: 'Úú chí nanduuchi niicu 'úú teé vida yeⁿ'é yā. Du'ū chi i'téénū 'úú 'aara n'díi yā, 'tíícā nduuchi yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ní nducyáácá 'iiⁿ'yāⁿ chi vɛ́ɛ́ vida yeⁿ'e yā chi i'téénu yā 'úú, nguɛ́ɛ́ 'cuūvi yā cueⁿ'e daāⁿmaⁿ. ¿'Áá i'teenu di chuū? ");
INSERT INTO cuxNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tuu'mi ní Marta ngaⁿ'a yā: I'teenú Señor. 'Úú i'teenú dii chi Cristo Daiya Dendyuūs chi ndaá nī iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Taachi Marta ch'iinu caⁿ'a ta chuū cueⁿ'e tá ní yaa'vi n'dé'ei ta vi'i María ní ngaⁿ'a ta: Dii María, Maestro caneé yā ní n'gai yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Taachi María ch'iindiveeⁿ ta chuū ní ncueeⁿ ta ngééniicu tá ní ndaa ta nanááⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús miiⁿ 'āā cuɛ́ɛ́ nindáa yā yaaⁿ miiⁿ. Naati canée yā miiⁿ naachi nandaaca María 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tuu'mi ní 'iiⁿ'yāⁿ Israel s'eeⁿ chi snée yā na vaacu tá ndúúcū tá ní inca'á yā 'viichɛɛtíínūu María. Taachi n'diichí yā chi María miiⁿ ní nnicueeⁿ tá ngééniicu tá, tuu'mi ní can'dáa yā cuaaⁿ chuva'āī. 'Iiⁿ'yāⁿ s'eeⁿ cueⁿ'é yā ndaá yā ní ngaⁿ'a yā: Táⁿ'ā 'cáā ní caⁿ'a tá na yáinyāⁿ. Caⁿ'a tá cuɛɛcu ta. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María miiⁿ taachi ndaa ta nanááⁿ Jesús ní n'diichi ta 'iiⁿ'yāⁿ ní chiin'tiiya tá ná ca'ā Jesús. Ní ngaⁿ'a ta ngii ta Jesús: Señor, ndúúti chi caneé nī 'muuⁿ, ní nguɛ́ɛ́ ch'iī vi'í. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tuu'mi ní taachi n'diichi Jesús miiⁿ chí ngɛɛcu María ndúúcū 'iiⁿ'yāⁿ Israel s'eeⁿ chi ndaá yā ndúúcū María ngɛɛcu ntuúⁿ yā ní neené yaⁿ'āī 'iinu Jesús ndii Espíritu yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ní ngaⁿ'a yā: ¿Tíí s'neeⁿ yā saⁿ'ā? Ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ: Señor, cuchíi nī ní n'diichí nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ní chɛɛ̄cu Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tuu'mi ní 'iiⁿ'yāⁿ Israel s'eeⁿ ní caⁿ'a yā: Cún'dííchí nī tan'dúúcā chi dinéⁿ'e yā saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ní n'duuví 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: ¿'Áá nguɛ́ɛ́ ngii diiⁿ 'iiⁿ'yāⁿ 'cúū chi inin'guaáⁿ yā nduutináaⁿ 'iiⁿ'yāⁿ chi ngueenááⁿ, nguɛ́ɛ́ cuuvi diíⁿ yā chi saⁿ'a 'cūū nguɛ́ɛ́ ní ch'ii sa? ");
INSERT INTO cuxNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ní Jesús neené ya'ai 'iinu ntuúⁿ yā maáⁿ yā ní ndaá yā na yáinyāⁿ. Ní yáinyāⁿ miiⁿ 'áámá yiivi yáává. Níícú canee 'aama túūu vmnaaⁿ yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ngaⁿ'ā Jesús miiⁿ: Ndivíi nī túūu. Marta vi'i saⁿ'ā chi ch'iī ngaⁿ'a ta ngii ta Jesús miiⁿ: Señor, 'āā ngeéⁿ sá. 'Āā cuūúⁿ nguuvi n'dii sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús ní ngaⁿ'a yā ngiī yā Marta: ¿'Áá nguɛ́ɛ́ ngií dii chi nduuti chi cu'téénú dí tuu'mi ní n'diichi di poder yeⁿ'ē Dendyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tuu'mi ní ndivíi yā túūu naachí canéé tináⁿ'ā. Níícú Jesús ní n'diichí yā cuaaⁿ 'niiⁿnuⁿ ní caⁿ'a yā: N'diī Chiidá, 'úú ca'á gracias n'diī Dendyuūs chí n'giindiveéⁿ nī yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'Úú ní deenú chi 'āā cueⁿ'e daaⁿmáⁿ nūuⁿ n'giindiveéⁿ nī yeⁿ'é ti cáávā 'iiⁿ'yāⁿ chi snéē nanaáⁿ cuuvi cu'téénu yā chi n'diī dicho'ó nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ní ch'iinú caⁿ'a yā chuū nééné yuudu caⁿ'a yā: Lázaro, cuchíi di. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Saⁿ'ā chi n'dii miiⁿ ní nan'dáa sa. Nandɛ́ɛ́cú sá ndíí ta'ā sa ndíí ca'ā sa ndúúcū cintas tiinūuⁿ. Ndɛɛcuú nuuⁿmáⁿ cuerpo yeⁿ'ē sa ndii naaⁿ sa. Níícú pañuela canee naaⁿ sa. Tuu'mí ngaⁿ'a Jesús mííⁿ 'iiⁿ'yāⁿ: Nn'daatíi nī saⁿ'ā ní 'āā naⁿ'ā sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nééné 'yaaⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ chi ndaá yā ndúúcū María ní n'diichí yā chi diīⁿ Jesús miiⁿ chi'teenú yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Taná'a yā ní cheⁿ'é yā nanááⁿ saⁿ'ā fariseos ní chii yā saⁿ'ā s'eeⁿ chí diiⁿ Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tuu'mi ní saⁿ'ā chiiduú n'gɛɛtɛ́ ndúúcū saⁿ'ā fariseos nduuvidaamá yā ndeé yā. Ní ngaⁿ'a yā: ¿Dɛ'ɛ̄ diiⁿ yú? Tií sáⁿ'a 'cūū caati neené n'deē chí n'giⁿ'i sa señales nanáaⁿ yú. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndúúti chi cu'nee yú saⁿ'ā chi 'tííca nūuⁿ nducyáácá yā ní cu'téénu yā saⁿ'ā. Ní ndaa saⁿ'ā romanos ní ndivíi yā lugar yeⁿ'ē yáacū yeⁿ'ē yú ndúúcū nación yeⁿ'ē yú. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Áámá chɛ́ɛ́ saⁿ'ā s'eeⁿ chi nguuvi Caifás miiⁿ, saⁿ'ā chi chiiduú ch'ɛɛtɛ ca yeⁿ'ē nduuyu miiⁿ caⁿ'a sa chii sa saⁿ'ā s'eeⁿ: Ndís'tiī ní nguɛ́ɛ́ du'ū vɛɛ deenú nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ní nguɛ́ɛ́ nacádiinúúⁿ nī chi 'áámá saⁿ'ā 'cuūvī sa yeⁿ'e nducyaacá yā níícú nguɛ́ɛ́ ti nación yeⁿ'ē yú cuuvi ndái. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chuū ní nguɛ́ɛ́ caⁿ'a yā yeⁿ'ē maáⁿ yā caati 'iiⁿ'yāⁿ miiⁿ chiiduú ch'ɛɛtɛ́ ca yeⁿ'ē nduuyu miiⁿ. Caⁿ'ā cuaacú sa chi cuchiī chi 'cuūvī Jesús cáávā nación 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ní Jesús nduuvidaamá yā nguɛ́ɛ́ damaāⁿ 'iiⁿ'yāⁿ nación miiⁿ naati ndúúcū tanáⁿ'ā daiyá Dendyuūs miiⁿ chi snéé 'muuⁿ chi snéé miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","'Tííca ndíí tuu'mi ndeé yā chi 'caaⁿ'nuⁿ yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tuu'mi ní 'aa ntɛ́ɛ́ cuchiica nguuvi Jesús nguaaⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ naati cueⁿ'é yā na 'áámá yáāⁿ niiⁿnuúⁿ yáⁿ'āa cuuⁿmáⁿ naachi nguɛ́ɛ́ ch'ɛɛtinéé 'iiⁿ'yāⁿ chi nguuvi Efraín. Ní canée yā miiⁿ ndúúcū discípulos yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ní 'viicu pascua yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ 'āā chi néé niiⁿnuúⁿ nguuvi. Nééné 'yaaⁿ yā cuchɛ́ɛ yā yeⁿ'e yáāⁿ yeⁿ'é yā na yáāⁿ Jerusalén, vmnaaⁿ tiempo yeⁿ'ē 'viicu pascua. Ní 'iiⁿ'yāⁿ s'eeⁿ didɛɛvɛ́ yā vida yeⁿ'é yā tan'dúúcā costumbre yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ní in'nuúⁿ yā Jesús miiⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ indeé yā ndúúcū vi'ī naachi caneé yā chɛɛti yaācū templo taacā chí ngii yeⁿ'ē ndís'tiī: ¿'Áá nguɛ́ɛ́ chii Jesús 'viicu? ");
INSERT INTO cuxNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","'Iiⁿ'yāⁿ chiiduú n'gɛɛtɛ́ ndúúcū saⁿ'ā fariseos 'āā s'néeⁿ yā caaca 'tíícā. Ndúúti du'ū chi déénú tií canéé Jesús miiⁿ caaⁿ'maⁿ yeⁿ'ē chiiduú n'gɛɛtɛ́ níícú cuta'á yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Níícú indaá cá taaⁿ jááⁿ nguuvi chi ndaa 'viicu yeⁿ'ē pascua. Ndaā Jesús yáāⁿ Betania naachi canee Lázaro, saⁿ'ā chi 'āā ch'ii ní n'duuchí ntuūⁿ Jesús miiⁿ saⁿ'ā yeⁿ'e nguaaⁿ 'iiⁿ'yāⁿ chi n'dii. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ní miiⁿ ca'a yā chi che'e nguiīnū Jesús. Marta miiⁿ ní n'gii yā cu'u na mesa. Ní Lázaro miiⁿ vɛɛ sa ndúúcū Jesús na mesa. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tuu'mi ní sta'ā María miiⁿ 'áámá libre yeⁿ'ē aceite perfume yeⁿ'ē nardo nūuⁿ chi yaⁿ'ai chii'vɛ̄. Ní cheēndáa tá ca'a Jesús miiⁿ. Ní ndúúcū yuūndū tiīⁿ tá miiⁿ nadɛɛvɛ tá ca'ā Jesús miiⁿ. Niicu nuuⁿmáⁿ ch'ɛɛtɛ chɛɛti va'āī cheēⁿ perfume yeⁿ'e aceite miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","'Áámá chɛ́ɛ́ discípulo yeⁿ'é yā chi nguuvi Judas Iscariote chi daiya Simón chi saⁿ'ā chi canéé chí diíⁿ sa entregar Jesús, ngaⁿ'a sa: ");
INSERT INTO cuxNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Dɛ'ɛ̄ cúúví chí nguɛ́ɛ́ n'diīcuī yú aceite 'cūū ndúúcū ndɛɛ̄chɛ̄ ciento caadi canéé 'uūvī ngɛɛcu ndiichi centavo ní ca'a yú 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ní caⁿ'a sa chuū ní nguɛ́ɛ́ chi ya'āī sa 'iiⁿ'yāⁿ chi ndaachíī snée yā, naati cáávā chi duucu sa. Ní ndɛɛ̄ sa bolsa miiⁿ snúúⁿ tuūmī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tuu'mi ní ngaⁿ'ā Jesús: 'Āā canéé 'nū tá, taachi n'dai tá chuū cáávā nguuvi chi caⁿ'á 'cuɛɛchí. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Caati 'iiⁿ'yāⁿ chi nguɛ́ɛ́ yeⁿ'e yā 'āā canee núúⁿ nī nduucú yā cueⁿ'e daāⁿmaⁿ, naati 'úú ní nguɛ́ɛ́ 'áámá cuneé núúⁿ nduucú nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tuu'mí neené 'yaaⁿ 'iiⁿ'yāⁿ yeⁿ'ē 'iiⁿ'yāⁿ Israel tuumicadíínuuⁿ yā chi Jesús miiⁿ ní cunée yā na yáāⁿ Betania. Ní níndaá yā nguɛɛ cáávā damaāⁿ chi neⁿ'e n'diichí yā Jesús miiⁿ ti neⁿ'e n'diichí yā Lázaro, saⁿ'ā chi 'āā n'dii ní nduuchi. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Saⁿ'ā s'eeⁿ chi chiiduú n'gɛɛtɛ́ nduuvidááma yā chi neⁿ'é 'caaⁿ'nuⁿ ntúuⁿ yā Lázaro. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ti nééné 'yaaⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ ngeⁿ'e yā ní i'téénu yā Jesús miiⁿ caavā Lázaro. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chi dɛɛvɛ táámá nguuvi ni neené 'yaaⁿ 'iiⁿ'yāⁿ ndaá yā 'viicu taachi ch'iindiveéⁿ yā chi Jesús miiⁿ ndaa yā Jerusalén. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Sta'á yā n'duuvi tiicuáá yííⁿyúⁿ ní can'daa yā Jesús. Ní ndaacá yā Jesús ní 'caī yā: Hosanna. N'dáí taavi 'iiⁿ'yāⁿ chi cuchíi yā ndúúcū chi dúúchí Señor chi Rey yeⁿ'ē Israel ntúūⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ní ndaācā Jesús 'aama burro 'lííⁿ ni canduú yā 'iiti tan'dúúcā chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs 'tíícā: ");
INSERT INTO cuxNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Táⁿ'ā daiya Sión nguɛ́ɛ́ 'va'a di. N'dííchí dí, cuchii Rey yeⁿ'ē di. Canduú yā 'aama daiya burro. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dɛ'ɛ ndúúcū chi 'tuucā nguɛ́ɛ́ tuumicadiinúúⁿ yā discípulos yeⁿ'é yā nguuvi miiⁿ. Taachi Jesús cánéé yā na va'ai chɛɛti nguuvi tuu'mi ní discípulos yeⁿ'e yā nn'gaacú yā tanducuéⁿ'ē dɛ'ɛ̄ chi canee nguūⁿ yeⁿ'é yā, 'íícú diíⁿ yā dɛ'ɛ̄ ndú'ū chi 'túúcā. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","'Iiⁿ'yāⁿ chi canée yā ndúúcū Jesús ngaⁿ'a cuáácú yā: Taachí yaa'ví yā Lázaro na yáinyāⁿ ní nnduuchi sa nguaaⁿ tinaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Cáávā chuū ní n'daā 'yaaⁿ 'iiⁿ'yāⁿ caati n'giindiveéⁿ yā chi Jesús ní diíⁿ yā señal miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Saⁿ'ā fariseos ní ngaⁿ'a sa nguaaⁿ maāⁿ sa: Inaaⁿ nī ti nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ idiiⁿ nī aprovechar yeⁿ'e asunto 'cūū. N'dííchí nī. Núúⁿmaⁿ iⁿ'yeēⁿdi ní caⁿ'ā can'dáā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","'Iicu vɛ́ɛ́ 'iiⁿ'yāⁿ griegos chí chɛɛ yā yeⁿ'ē 'viīcū miiⁿ ní diíⁿ yā adorar. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","'Iiⁿ'yāⁿ s'uúⁿ ndaá yā nanááⁿ Felipe yeⁿ'ē yáāⁿ Betsaida chi yeⁿ'ē yáⁿ'āa Galilea. Ní di'cuutú yā 'iiⁿ'yāⁿ, ní ngaⁿ'a yā ngii yā 'iiⁿ'yāⁿ: Señor, neⁿ'é 'nū n'diichí 'nū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ndaā Felipe miiⁿ ni ngaⁿ'a yā ngii yā chuū Andrés. Tuu'mi ní Andrés ndúúcū Felipe ngaⁿ'a yā ngii yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tuu'mi ní Jesús nan'guɛɛcutáⁿ'a yā, ní ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: Hora mííⁿ cuchiī taachi Saⁿ'ā chi Daiya Dendyuūs cánéé chi caⁿ'á yā na va'ai chɛɛti nguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī: Nduuti chi 'áámá trigo nguɛ́ɛ́ cuuvā na yáⁿ'āa ní 'cuūvī damaāaⁿ canee. Naati ndúúti chi trigo 'cuūvī neené n'deee nduuví trigo 'cúuⁿndī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Du'u chí neⁿ'e vida yeⁿ'é yā na iⁿ'yeeⁿdí 'cūū n'dái yā vida yeⁿ'e yā cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Du'u 'iiⁿ'yāⁿ chi dichíí'vɛ yā 'úú ní chii yā can'daa yā 'úú, naachi 'úú chi caneé, mííⁿ ntúūⁿ snée 'iiⁿ'yāⁿ chi dichíí'vɛ̄ 'úú. Nduuti 'áámá 'iiⁿ'yāⁿ chi dichii'vɛ́ yā 'úú, Chiidá ní diíⁿ yā honrar 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ní caⁿ'a Jesús: Maaⁿ ní neené ndístaⁿ'ā alma yeⁿ'é. ¿Dɛ'ɛ́ caāⁿ'maⁿ? N'diī Chiidá, ¿'áá nadanguáⁿ'ai nī 'úú yeⁿ'e hora 'cūū? Cáávā chuū chi cuchií hora 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","N'diī Chiidá, ch'iⁿ'i nī poder yeⁿ'e chi duuchi yeⁿ'é nī. Tuu'mi ní cuchii 'áámá nduudu yeⁿ'ē nanguuvi chi ngaⁿ'a: 'Úú ní 'āā ch'iⁿ'i poder yeⁿ'é ní cuuvi 'cuuⁿ'míⁿ poder yeⁿ'é ntúuⁿ taama vmnéⁿ'ēe. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","'Iiⁿ'yāⁿ chi chinée yā miiⁿ ní ch'iindiveéⁿ yā 'áámá nduudu ní ngaⁿ'a yā: Daavi miiⁿ. Ta n'dúúvi yā ní ngaⁿ'a yā: Angel yaa'ví yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Nan'guɛɛcútaⁿ'ā Jesús ní caⁿ'a yā: Nguɛ́ɛ́ ndaā nduudu 'cūū caavā 'úú, ti cáávā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maaⁿ ní vɛ́ɛ́ chí diiⁿ juzgar 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū. Maaⁿ ní 'aama saⁿ'ā chi ch'ɛɛtɛ yeⁿ'é iⁿ'yeeⁿdi 'cūū 'cuɛɛcú yā cuaaⁿ chuva'āī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ndúúti chi 'úú chí ncueéⁿ yeⁿ'ē yáⁿ'āa 'cūū tuu'mi candɛɛ́ nducyaacá yā nanáaⁿ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ní chuū ngaⁿ'a Jesús ngii yā 'iiⁿ'yāⁿ chí ngaⁿ'á yā dɛ'ɛ́ vaadī n'gii 'cuuví yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nan'guɛɛcútaⁿ'ā 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'é yā: Nús'uū ní n'giindiveéⁿ 'nū chi canéé nguūⁿ na libro yeⁿ'e Ndyuūs chi Cristo cuneé yā cueⁿ'e daāⁿmaⁿ. ¿Táácā chi ngaⁿ'ā dii, cánéé chí níncueeⁿ Saⁿ'ā chi Daiya Dendyuūs? ¿Du'ū chi Saⁿ'ā chi Daiya Dendyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tuu'mí ngaⁿ'a Jesús ngii yā 'iiⁿ'yāⁿ s'eeⁿ: 'Tɛ́ɛ́ nūuⁿ chi canéé chi dɛɛvɛ nanáaⁿ nī. Cúchiicá nī naachi canéé chi dɛɛvɛ neⁿ'e chi canéé chi dɛɛvɛ nduucú nī, ní nguɛ́ɛ́ ndaā maāíⁿ naachí canée yā. 'Iiⁿ'yāⁿ chí cachiicá yā na maāíⁿ nguɛ́ɛ́ deenú yā tií caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Naachi canéé chi dɛɛvɛ ndúúcu nī cu'téénu nī chi dɛɛvɛ miiⁿ ní cuuvi daiya chi dɛɛvɛ ndís'tiī. Chuū caⁿ'a Jesús, ní cueⁿ'e yā ní canúúⁿ n'de'ei yā maáⁿ yā yeⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nééné ch'iⁿ'i Jesús señales dendu'ū nanáāⁿ 'iiⁿ'yāⁿ s'eeⁿ naati nguɛ́ɛ́ chi'teenú yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","'Iicu cuuví cuaacu chí caⁿ'ā saⁿ'ā profeta Isaías naachí canéé nguūⁿ na libro yeⁿ'e Ndyuūs 'tíícā: Señor, ¿du'ū i'teenu chí ngaⁿ'a yā? ¿Du'ū n'diichi chi n'giⁿ'i yā poder yeⁿ'e Señor? ");
INSERT INTO cuxNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Cáávā chuū chi nguɛ́ɛ́ i'téénu yā chi táámá vmnéⁿ'ēe caⁿ'a Isaías naachí ndii nguūⁿ na libro yeⁿ'e Ndyuūs 'tíícā: ");
INSERT INTO cuxNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nan'gaadí yā nduutinaáⁿ 'iiⁿ'yāⁿ s'eeⁿ ní diīⁿ chɛɛchí yā staava yeⁿ'é yā, caati nguɛ́ɛ́ inaáⁿ yā ndúúcū nduutináaⁿ yā, ní nguɛ́ɛ́ deenú yā yeⁿ'ē staava yeⁿ'é yā, ndíí nguɛ́ɛ́ ndúú cu'téénu yā, ni 'úú diyiicú 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chuū caⁿ'a Isaías miiⁿ taachí n'diichi sa Dendyuūs ndúúcū poder yeⁿ'é yā ní caⁿ'a sa yeⁿ'e yā ní 'āā dinguūⁿ sa yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Caavā yeⁿ'ē nducuéⁿ'ē chuū nééné 'yaaⁿ 'iiⁿ'yāⁿ chí n'gɛɛtɛ ca chi'téénu yā Jesús naati nguɛ́ɛ́ ntumiiⁿnúⁿ yā chi chi'téénu yā ti 'va'a yā chi nan'daa yā yaācū cáávā saⁿ'ā fariseos. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Caati neⁿ'é ca yā honra yeⁿ'e saⁿ'ā iⁿ'yeeⁿdí 'cūū, nguɛ́ɛ́ ti honra yeⁿ'ē Dendyuūs miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Naati Jesús ní caⁿ'a yuudú yā: Du'ū chi i'téénu 'úú, nguɛ́ɛ́ 'úú i'téénu yā ti 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Du'ú 'iiⁿ'yāⁿ chi inaaⁿ yā 'úú, inaaⁿ yā 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'Úú tan'dúúcā dɛɛvɛ ní ndaá iⁿ'yeeⁿdí 'cūū. Ní 'iicu nducyáácá 'iiⁿ'yāⁿ chi cu'téénu yā 'úú nguɛ́ɛ́ cunee yā ndúúcū maāíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","'Iiⁿ'yāⁿ chi n'giindiveéⁿ yā nduudu yeⁿ'é ní nguɛ́ɛ́ i'téénu yā nduudu yeⁿ'é, 'úú nguɛ́ɛ́ diíⁿ juzgar 'iiⁿ'yāⁿ miiⁿ. Caatí nguɛ́ɛ́ ndaá diíⁿ juzgar 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū, ti ndaá chi nadanguaⁿ'áí 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Du'ū chi nguɛ́ɛ́ neⁿ'ē 'úú, ní nguɛ́ɛ́ n'gúuⁿ yā nduudu yeⁿ'é. Vɛ́ɛ́ 'iiⁿ'yāⁿ chi diíⁿ yā juzgar 'iiⁿ'yāⁿ s'eeⁿ nguuvi chi 'cuiinu iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Caati 'úú nguɛ́ɛ́ ngaⁿ'á yeⁿ'e maáⁿ. Chiidá chi dichó'o yā 'úú, 'iiⁿ'yāⁿ mííⁿ teé yā nduudu cuaacu chi ngaⁿ'á ní yeⁿ'ē chi canéé chí caaⁿ'máⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'Úú deenú chi cucáávā nduudu cuaacu yeⁿ'é yā cúnduuchi yú cueⁿ'e daāⁿmaⁿ. 'Tíícā ngaⁿ'ā 'úú, tan'dúúcā chi ngaⁿ'a Chiidá ngii yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ní vmnááⁿ vmnaaⁿ 'viicu yeⁿ'e pascua 'āā deenu Jesús chi hora 'āā cuɛ́ɛ́ ndaa chi cho'ó yā yeⁿ'e iⁿ'yeeⁿdí 'cūū chí ndaá yā nanááⁿ Chiidá yā. Tan'dúúcā chi dineⁿ'e Jesús 'iiⁿ'yāⁿ yeⁿ'é yā chi snée yā iⁿ'yeeⁿdí 'cūū, 'āā dinéⁿ'e núúⁿ yā 'iiⁿ'yāⁿ ndii cuááⁿ ná ch'iinu. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ch'íínú che'e nguiinú yā. Yááⁿn'guiinūuⁿ 'āā s'neeⁿ sa na staava yeⁿ'ē Judas Iscariote chi daiya Simón chi canéé chi diíⁿ yā entregar Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Déénú Jesús chí tanducuéⁿ'ē ní ca'a Chiidá yā ta'a daiyá yā ní chí nan'dáa yā yeⁿ'é Dendyuūs ní duu'vī tiempo tuu'mí naⁿ'á yā nanááⁿ Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nadacuéeⁿ yā naachi chi che'e nguiinú yā ní ndivíi yā catecaí yā. Ní sta'á yā 'aama toalla chɛɛcu vmnaaⁿ cuerpo yeⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ní ch'iinuúⁿ yā nuūⁿnīⁿ chɛɛti tina ní tucá'a yā naaⁿnu yā ca'a discípulos. Ní natí'i yā ndúúcū toalla chi ndɛɛcú yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ndaá yā naachi canéé Simón Pedro ní sáⁿ'a 'cūū ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ: Señor, ¿'áá n'diī ntúūⁿ naaⁿnú nī ca'á? ");
INSERT INTO cuxNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nan'guɛɛcútaⁿ'ā Jesús ní ngaⁿ'a yā ngii yā saⁿ'ā: 'Úú ní chi diíⁿ nguɛ́ɛ́ deenu di maaⁿ naati cadíínuuⁿ di cuayiivi. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ngaⁿ'ā Pedro ngii sa 'iiⁿ'yāⁿ: N'diī, nguɛ́ɛ́ nááⁿnú nī ca'á mar 'áámá tiempo. Nan'guɛɛcútaⁿ'ā Jesús yeⁿ'ē sa: Ndúúti chi nguɛɛ naaⁿnú yeⁿ'ē di nguɛ́ɛ́ 'áámá parte yeⁿ'ē di nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Tuu'mi ní ngaⁿ'a Simón Pedro: Señor, nguɛ́ɛ́ dámaāⁿ ca'á ti ndii ta'á ntúūⁿ ndúúcū tiíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tuu'mi ní ngaⁿ'a Jesús ngii yā saⁿ'ā: Du'u chí chiīnē nguɛ́ɛ́ neⁿ'ē sa chi naaⁿnu sa cuerpo yeⁿ'e sa ti dámaāⁿ ca'a sa caati tanducuéⁿ'ē cuerpo yeⁿ'ē sa ní dɛɛvɛ. Ndís'tiī ní 'āā dɛɛvɛ́ nī 'āā n'dáá rá chí nguɛ́ɛ́ nducyaaca nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ti deenú yā du'u chí diíⁿ entregar 'iiⁿ'yāⁿ ní cáávā chííⁿ chi caⁿ'a yā: Nguɛ́ɛ́ nducyaacá nī dɛɛvɛ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Taachí ch'iinu naaⁿnú yā ca'a discípulos, ní sta'á yā catecaí yā nguɛɛcundíí ntuúⁿ yā 'cuundi yā. Ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: ¿'Áá déénú nī dɛ'ɛ̄ chi idiíⁿ nduucú nī? ");
INSERT INTO cuxNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ndís'tiī ngaⁿ'a nī chi 'úú ni Maestro, chi 'úú ni Señor. N'daācā ngaⁿ'a nī caati 'tíícā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'Úú ní Señor yeⁿ'é nī, 'úú ni Maestro yeⁿ'é nī. 'Úú inaaⁿnú ca'a nī. Ndís'tiī canéé nī ntúūⁿ chi naaⁿnu nī 'aama nī ca'a taama nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Caneéⁿ chi diíⁿ chuū. Tan'dúúcā chi 'úú chi diíⁿ 'tíícá nī ntúūⁿ diiⁿ ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī: 'Iiⁿ'yāⁿ chí diiⁿ mandado nguɛ́ɛ́ 'āā 'naaⁿ ca yā chi 'iiⁿ'yāⁿ chí ngaⁿ'a ntiiⁿnyūⁿ yeⁿ'é yā. Ndíí nguɛ́ɛ́ ndúú 'iiⁿ'yāⁿ chi dicho'ó yā nguɛ́ɛ́ 'āā 'naaⁿ cá yā chi 'iiⁿ'yāⁿ chi dicho'ó yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nduuti chi deenu nī taanduvɛ́ɛ́ dendu'ū ní yeenu taaví nī ndúúti chi diíⁿ nī chuū. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nguɛ́ɛ́ ngaⁿ'á yeⁿ'ē nducyaaca ndis'tiī. 'Úú ní deenú 'iiⁿ'yāⁿ chí ndɛɛvɛ́. Ní 'iicu canéé chi cuuví cuaacu chí canéé nguūⁿ. Du'ū chi nge'é pan nduucú, canéé chi caⁿ'á yā contra yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndíí maaⁿ 'āā ngaⁿ'á 'aara chi 'āā cuɛ́ɛ́ cuuvi niiⁿnuúⁿ. Taachi 'āā cho'ōo chuū cuuví cu'téénu nī chi 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ 'úú ngaⁿ'á ngií ndís'tiī: 'Iiⁿ'yāⁿ chi 'cuáaⁿ yā 'iiⁿ'yāⁿ chi 'úú dicho'ó 'cuáaⁿ yā 'úú. Ní 'iiⁿ'yāⁿ chi 'cuáaⁿ yā 'úú 'cuáaⁿ yā 'iiⁿ'yāⁿ chi dicho'ó yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Taachí ngaⁿ'a Jesús chuū ya'ai 'iinú yā na espíritu yeⁿ'é yā ní caⁿ'a cuaacú yā: Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī chi 'áámá chɛ́ɛ́ ndís'tiī diíⁿ nī entregar 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tuu'mi discípulos n'gíínú yā na 'áámá yā na táámá yā. Nguɛ́ɛ́ tuumicádiinúúⁿ yā du'u yeⁿ'ē chi ngaⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","'Áámá discípulo, chi nééné neⁿ'é Jesús, candíítí neeⁿ yā na nííⁿnúⁿ Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro ca'a yā señas saⁿ'á 'cūū ní ngaⁿ'a yā saⁿ'ā chí natiingúúneeⁿ sa yeⁿ'ē sáⁿ'ā chi ngaⁿ'a Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Níícú taachi candiití neeⁿ yā nííⁿnúⁿ Jesús, tuu'mí ngaⁿ'á yā: Señor, ¿du'ū chii? ");
INSERT INTO cuxNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nan'guɛɛcútaⁿ'ā Jesús: Caⁿ'á di'caandá pan ní ca'á 'iiⁿ'yāⁿ ní 'iiⁿ'yāⁿ miiⁿ chííⁿ. Ní di'caandá yā pan ní ca'á yā Judas Iscariote, daiya Simón. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ch'íínú che'e sa pan miiⁿ ní yááⁿn'guiinūuⁿ ndaa sa na staava yeⁿ'ē sa. Tuu'mí Jesús ní ngaⁿ'a yā ngii yā saⁿ'ā: Chíí chi neⁿ'e di diiⁿ dí miiⁿ, diiⁿ núúⁿ yiiⁿnu nuuⁿ di. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Naati mar 'áámá 'iiⁿ'yāⁿ chi vɛ́ɛ́ na mesa miiⁿ nguɛ́ɛ́ tuumicadiinúúⁿ yā dɛ'ɛ̄ chúú chí 'tíícā caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","N'duuví yā nnacadíínuuⁿ yā chi caati Judas ndɛ́ɛ sa bolsa chi Jesús ní 'āā ngaⁿ'a yā ngii yā saⁿ'ā: Cuái di chi neⁿ'e yú yeⁿ'e 'viicu o cuica'a dí 'tɛɛ 'iiⁿ'yāⁿ chi ndaachíī snée yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ch'iinú che'é yā pan can'daā núuⁿ Judas chuva'ai ní 'āā chi 'da'a. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Taachí Judas miiⁿ can'daā sa miiⁿ tuu'mi ní ngaⁿ'ā Jesús: Maaⁿ ní canéé chí cuuvi ch'ɛɛtɛ Saⁿ'ā chi Daiya Dendyuūs. Ní Dendyuūs miiⁿ canéé chi ch'ɛɛtɛ ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ndúúti chi Dendyuūs canéé chi ch'ɛɛtɛ yā, 'tiicá ntúūⁿ diíⁿ yā chi ch'ɛɛtɛ maáⁿ yā. Ní 'cuiinu ní diíⁿ yā chi ch'ɛɛtɛ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","N'diī daiya n'gaiyaá 'tɛ́ɛ́ 'tɛ́ɛ́ nuúⁿ cuneé ndúúcū ndis'tiī. In'nuúⁿ nī 'úú tan'dúúcā chi 'úú chi ngaⁿ'á ngií 'iiⁿ'yāⁿ Israel s'eeⁿ: Naachi 'úú caⁿ'á ndís'tiī ní nguɛ́ɛ́ cuuvi ndaá nī. 'Tíícā ngaⁿ'á ndis'tiī maaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'Áámá ley ngai iteé ndis'tiī chi diiⁿ yá'āī 'iinu nī vi'ī 'aama nī taama nī tan'dúúcā chi idiíⁿ yá'āī 'iinú ndis'tíī. 'Tiicá ntúūⁿ diyá'ai 'iinú nī vi'ī 'aama nī taama nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Íícú chúū tuumicadiinuuⁿ nducyaaca 'iiⁿ'yāⁿ chi ndís'tiī ní discípulos yeⁿ'é ndúúti chi neⁿ'é nī 'áámá nī taama nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tuu'mí ngaⁿ'ā Simón Pedro ngii sa Jesús: Señor, ¿tií cáⁿ'a di? Nan'guɛɛcútaⁿ'ā Jesús miiⁿ: Naachi 'úú caⁿ'á nguɛ́ɛ́ cuuví chiī ndís'tiī can'dáa nī 'úú. Naati canéé chí chii nī can'dáa nī 'úú cuayiivi. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tuu'mí ngaⁿ'ā Pedro miiⁿ: Señor, ¿dɛ'ɛ̄ cuuví chi 'āā ntɛɛ cuuví chi can'daá dii maaⁿ? Vida yeⁿ'é cu'neéⁿ lugar yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nan'guɛɛcútaⁿ'ā Jesús miiⁿ: ¿'Áá 'cuūvī di lado yeⁿ'e 'úú? Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií dii chi nguɛ́ɛ́ 'cai tusáⁿ'ā taachí nguɛ́ɛ́ cueeⁿdíitū di 'úú 'iinū cuuvi vuelta. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Caⁿ'a Jesús: Nguɛ́ɛ́ ndii 'úúví staava yeⁿ'é nī. Cu'téénu nī Dendyuūs. Cu'téénu nī 'úú dendu'ū. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na vaacu Chiidá vɛ́ɛ́ taavi naachi 'cuɛɛtinée yú. Ndúúti chí nguɛ́ɛ́ nduudu cuaacu, tuu'mi ní 'úú nguɛ́ɛ́ caaⁿ'máⁿ 'tiicā. Caⁿ'á nanguain'daí naachi 'cuɛɛtinée ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndúúti chi naⁿ'á ní nnguain'daí 'áámá cuaaⁿ yeⁿ'ē ndís'tiī chi 'cuɛɛtineé ndis'tiī, cuchii ntuúⁿ táámá vmnéⁿ'ēe ní candɛɛ́ māaⁿ ndís'tiī. Naachí cuneé miiⁿ ndís'tiī ní 'cuɛɛtinée nī ntúuⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ní déénú nī naachi caⁿ'á mííⁿ, ní n'diichí nī yúúní. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tuu'mi ní ngaⁿ'a Tomás ngii sa Jesús: Señor, nguɛ́ɛ́ déénu 'nū tií caⁿ'á nī. ¿Táácā n'diichí 'nū yúúní? ");
INSERT INTO cuxNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús nan'guɛɛcutáⁿ'a yā yeⁿ'e sa: 'Úú tan'dúúcā yúúní, 'úú ngaⁿ'á nduudu cuaacu, 'úú teé vida. Nguɛ́ɛ́ du'ū vɛɛ ndaá nanááⁿ Chiidá ndúúti chi nguɛɛ cáávā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ndúúti chí n'diichí nī 'úú in'diichí nī ntúuⁿ Chiidá. Ní ndii maaⁿ ní n'diichí nī 'iiⁿ'yāⁿ. Ní n'diichí nī ntúuⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tuu'mí ngaⁿ'a Felipe miiⁿ ngii sa 'iiⁿ'yāⁿ: Señor, 'cuuⁿ'miⁿ nī Chiida yú ní 'cuɛɛtinée 'nū ndúúcū vaadī yeenú. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús ní ngaⁿ'a yā ngii yā saⁿ'ā: Dii Felipe, 'naaⁿ n'dáí ntúūⁿ caneé ndúúcū ndis'tiī ní ¿'áá nguɛ́ɛ́ nin'diichi di 'úú, Felipe? Du'ú 'iiⁿ'yāⁿ chi n'diichí yā 'úú, n'diichí yā Chiidá. ¿Táácā caaⁿ'maⁿ di: 'Cuuⁿ'miⁿ nī Chiida yú? ");
INSERT INTO cuxNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿'Áá nguɛ́ɛ́ i'téénu di chi 'úú ní caneé ndúúcu Chiidá ní Chiidá caneé yā nduucú? Nduudu chi ngaⁿ'á nanááⁿ ndís'tiī nguɛ́ɛ́ ngaⁿ'á yeⁿ'é maáⁿ ti yeⁿ'ē Chiidá chi canée yā nduucú. 'Iiⁿ'yāⁿ miiⁿ diíⁿ yā ntiiⁿnyuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cu'téénu di 'úú ti 'úú caneé ndúúcū Chiidá ní Chiidá mííⁿ canée yā nduucú, o cu'téénu di 'úú cáávā ntiiⁿnyuⁿ chi diíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndis'tiī: Du'ū chi i'teenu 'úú, ní ntiiⁿnyuⁿ chi 'úú idiíⁿ, 'tiicá ntúūⁿ diíⁿ yā. Ní ch'ɛɛtɛ ca ntiiⁿnyuⁿ nidiíⁿ yā nguɛ́ɛ́ ti chuū caati 'úú ní caⁿ'á nanááⁿ Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ní tanducuéⁿ'ē chi caaca nī Chiidá ndúúcū chi duuchí, chuū 'úú idiíⁿ niicu Chiidá miiⁿ ní 'cuuví 'cuuⁿ'míⁿ yā poder caavā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ndúúti chi dɛ'ɛ̄ chi caaca nī ndúúcū chi duuchí, 'úú ní diíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ndúúti chi neⁿ'e nī 'úú, diíⁿ nī chi ngaⁿ'a ley yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","'Úú di'cuíītu Chiidá ní teé yā taama yā chi teé yā poder ndis'tiī. Ní cuneé yā ndúúcu nī cueⁿ'e daāⁿmaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Espíritu ngaⁿ'a yā vaadī cuaacu. Chiiⁿ chi nguɛ́ɛ́ 'cuúⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī caati nguɛ́ɛ́ 'iiⁿ'yāⁿ s'eeⁿ inaaⁿ yā ní nguɛ́ɛ́ ntúūⁿ ní n'diichí yā Espíritu miiⁿ. Naati ndís'tiī n'diichí nī ti Espíritu miiⁿ canéé ndúúcū ndís'tiī ní cunéé ntúūⁿ yeⁿ'ē ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nguɛ́ɛ́ cu'neéⁿ ndís'tiī da'caiya nguá'āa. Ndaá nanaáⁿ ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","'Tɛɛ 'tɛ́ɛ́ nūuⁿ 'āā ntɛ́ɛ́ snaāⁿ iⁿ'yeēⁿdī 'úú. Ndís'tiī ní snaáⁿ nī 'úú. Caati 'úú ní canduūchí, ní ndís'tiī canduuchi ntuúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tuu'mí nguuvi miiⁿ ní canéé chi n'diichí nī 'úú chi caneé ndúúcū Chiidá. Ní ndís'tiī canée nī nduucú. Ní 'úú caneé ndúúcu nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Du'ú 'iiⁿ'yāⁿ chi canée yā ndúúcū ley yeⁿ'é ní diíⁿ yā tan'dúúcā chi ngaⁿ'a ley yeⁿ'é, 'iiⁿ'yāⁿ miiⁿ chi neⁿ'é yā 'úú. Ní 'iiⁿ'yāⁿ chi neⁿ'é yā 'úú, Chiidá neⁿ'e ntúuⁿ yā 'iiⁿ'yāⁿ miiⁿ ní 'úú ní neⁿ'é ntuúⁿ 'iiⁿ'yāⁿ miiⁿ. Ní 'úú 'cuuⁿ'míⁿ maáⁿ nanááⁿ 'iiⁿ'yāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tuu'mí ngaⁿ'ā Judas ngii sá Jesús (nguɛ́ɛ́ saⁿ'ā Judas Iscariote): Señor, ¿dɛ'ɛ vɛ́ɛ́ chi 'cuuⁿ'míⁿ nī nanááⁿ nús'uu ní nguɛ́ɛ́ nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī? ");
INSERT INTO cuxNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Nan'guɛɛcútaⁿ'ā Jesús ní caⁿ'a yā: Dú'ū 'iiⁿ'yāⁿ chi neⁿ'e yā 'úú, nduudu yeⁿ'é n'giindiveéⁿ yā. Ní Chiidá mííⁿ neⁿ'é yā 'iiⁿ'yāⁿ. Ní ndaá 'nū nanáaⁿ yā. Ní ndaāca 'nū naachi 'cuɛɛtinée 'nū nduucú yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Du'u 'iiⁿ'yāⁿ chi nguɛ́ɛ́ neⁿ'é yā 'úú ní nguɛ́ɛ́ n'giindiveéⁿ yā nduudu yeⁿ'é. Nduudu chí n'giindivéeⁿ nī nguɛ́ɛ́ yeⁿ'é caati yeⁿ'ē Chiidá chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Chuū ngaⁿ'á taachi caneé ndúúcū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'Iiⁿ'yāⁿ chi tée yā poder s'uuúⁿ, 'iiⁿ'yāⁿ miiⁿ ní Espíritu N'dai yeⁿ'e Ndyuūs. Chuū chi dichó'ó Chiidá ndúúcū chi duuchí. 'Iiⁿ'yāⁿ mííⁿ ca'cueeⁿ yā ndís'tiī tanducuéⁿ'ē dendu'ū. Ní nin'gaacú yā ndís'tiī tanducuéⁿ'ē chi caⁿ'á nanááⁿ ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Chí cunee 'diiíⁿ cu'neéⁿ ndúúcū ndís'tiī. Chi cu'neéⁿ 'diiíⁿ yeⁿ'é māaⁿ teé ndis'tiī. Nguɛ́ɛ́ tan'dúúcā chi iⁿ'yeēⁿdī teē chi 'úú teé ndis'tiī. Nguɛ́ɛ́ 'cuūndi daānā yeⁿ'e staava yeⁿ'é nī, ndíí nguɛ́ɛ́ ndúú 'va'a rá nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ch'iindiveéⁿ nī chi 'úú ngaⁿ'á: Caⁿ'á ní cuchii ntūuⁿ nanááⁿ ndís'tiī. Ndúúti chí neⁿ'é nī 'úú, tuu'mi ní cuaacu nííⁿnyúⁿ chi yeenú taavi nī ti ngaⁿ'á chi caⁿ'á nanááⁿ Chiidá. Ní Chiidá vmnaaⁿ cá yā ní chi cuuvi 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Maaⁿ ní ngaⁿ'á yeⁿ'e chi cuuvi, ní 'iicu taachi chó'ōo chuū cuuvi cu'téénu nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Āā ntɛ́ɛ́ 'yaaⁿ caⁿ'á ndúúcū ndis'tiī caati ndaa saⁿ'ā chi 'iiⁿntyéⁿ'ē yeⁿ'e iⁿ'yeēⁿdí 'cūū. Ní nguɛ́ɛ́ du'ū vɛɛ canéé yeⁿ'é yā nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","'Iicu cuuví cu'téénú 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī chi 'úú neⁿ'é Chiidá. Ní tan'dúúcā chi Chiidá ca'á yā mandamiento 'úú 'tíícā chi diíⁿ. Ncueeⁿ yú ní caⁿ'a yú maaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Caⁿ'a Jesús: 'Úú tan'dúúcā dii'yu dúnde'e chi cuaacu, ní Chiidá diíⁿ yā cuidado yeⁿ'e dii'yu dúnde'e. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tanducuéⁿ'e duuⁿnē yeⁿ'é chi nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ n'gui'i yeⁿ'ē 'caacá yā ní divíi yā. Ní nducuéⁿ'ē duuⁿnē chi vɛ́ɛ́ n'gui'i yeⁿ'ē ní didɛɛvɛ́ yā 'iicu cuuví n'deēe ca n'gui'i yeⁿ'ē. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ndís'tiī 'āā dɛɛvɛ́ nī cáávā nduudu chí ngaⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ndís'tiī cunée nī nduucú ní 'úú cuneé ndúúcu nī. Tan'dúúcā duúⁿne nguɛ́ɛ́ 'cuɛɛtinéē n'gui'i yeⁿ'ē nduūtī chi nguɛɛ canéé na dii'yu dúnde'e, 'tiicá ntúūⁿ ndis'tiī nduuti chi nguɛ́ɛ́ cunée nī nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","'Úú tan'dúúcā dii'yu dúnde'e ní ndís'tiī ní dúuⁿnē. 'Iiⁿ'yāⁿ chi canée yā nduucú ní 'úú caneé nduucú yā, 'iiⁿ'yāⁿ miiⁿ nééné n'deee n'gui'i candɛ́ɛ yā. Ndúútī chi nguɛ́ɛ́ 'úú nduucú yā ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ cuuvi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Du'u 'ííⁿ'yāⁿ chi nguɛɛ canée yā nduucú cun'dáa yā tan'dúúcā dúúⁿne chi nguɛ́ɛ́ n'gui'i yeⁿ'ē ní ntí'i. Ní 'iiⁿ'yāⁿ ita'á yā ní ngii yā na yaⁿ'ā. Ní ngiichi. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ndúúti chi canée nī nduucú, ní nduudu yeⁿ'é canéé nduucú nī, caaca nī tanducuéⁿ'ē chi neⁿ'é nī ní cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Taachi candɛɛ́ nī n'deēe n'dáí n'gui'i yeⁿ'é nī, ní ch'iⁿ'í nī chi discípulos yeⁿ'é tuu'mi ní ndúúcū chuū ní ch'iⁿ'í nī poder Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tan'dúúcā chi neⁿ'e Chiidá 'úú 'tiicá ntúūⁿ 'úú neⁿ'é ndís'tiī. Cunée nī ndúúcū vaadī neⁿ'e yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ndúúti chi diíⁿ nī tan'dúúcā chi ngaⁿ'a ley yeⁿ'é, tuu'mi cunée nī ndúúcū vaadī neⁿ'e yeⁿ'é. Ní chuū tan'dúúcā chi 'úú idiíⁿ nducuéⁿ'ē chi ngaⁿ'a ley yeⁿ'ē Chiidá ní caneé ndúúcū vaadī neⁿ'e yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Dendú'ū chi 'tuucā ngaⁿ'á. Níícú vaadī yeenú yeⁿ'é cunee nduucú nī. Ní vaadī yeenú yeⁿ'é nī diīⁿ cumplir. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Chuū ley yeⁿ'é chi dineⁿ'é nī vi'ī 'aama nī taama nī tan'dúúcā chi 'úú neⁿ'é ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mar 'áámá saⁿ'ā nguɛ́ɛ́ vaadī neⁿ'e chi ch'ɛɛtɛ cá yeⁿ'ē chi 'cuuvi 'áámá saⁿ'ā caavā amigo yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ndís'tiī ní amigos yeⁿ'é ndís'tiī ndúúti chi diíⁿ nī cosa chi 'úú ngaⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Āā ntɛ́ɛ́ caaⁿ'máⁿ chi ndis'tiī ní mozos yeⁿ'é ti mozos nguɛɛ deenu sa dɛ'ɛ̄ chi diiⁿ 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē sa. Naati ngaⁿ'á chi ndís'tiī ní amigos yeⁿ'é ti tanducuéⁿ'ē chi n'giindiveéⁿ yeⁿ'ē Chiidá, ngaⁿ'á ngií ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ndís'tiī nguɛ́ɛ́ ndɛɛvɛ nī 'úú, naati 'úú nindɛɛvɛ́ ndís'tiī. Ní 'neéⁿ ndís'tiī caati cuuvi candɛ́ɛ nī n'gui'i. Ní n'gui'i yeⁿ'e nī 'áámá cūnee. Ní tanducuéⁿ'ē chi caaca nī Chiidá ndúúcū chi duuchí, 'iiⁿ'yāⁿ miiⁿ ní tée yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Chuū ní ngaⁿ'á ndis'tiī chi dinéⁿ'e nī vi'ī 'áámá nī táámá nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ndúúti chi 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī nguɛ́ɛ́ neⁿ'e yā ndís'tiī 'āā déénu nī chi vmnááⁿ vmnaaⁿ nguɛ́ɛ́ neⁿ'e yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ndúúti chi canée nī ní diíⁿ nī cosas ndúúcū 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī, 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī dinéⁿ'e yā ndís'tiī, naati ndís'tiī nguɛ́ɛ́ yeⁿ'ē iⁿ'yeēⁿdī ndís'tiī. Ndɛɛvɛ́ ndís'tiī vmnaáⁿ yeⁿ'ē chi din'dái iⁿ'yeēⁿdī. Cáávā chuū chi iⁿ'yeēⁿdī nguɛ́ɛ́ neⁿ'e ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","N'gaacu nī yeⁿ'e nduudu chi 'úú ngaⁿ'á ngií ndis'tiī: Nguɛ́ɛ́ vmnaaⁿ ca 'iiⁿ'yāⁿ chi diiⁿ mandado ti 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyuⁿ. Ndúúti chi 'iiⁿ'yāⁿ s'tíī ní can'daa yā 'úú 'tiicá ntúūⁿ can'daa yā ndís'tiī. Nduuti chi diíⁿ yā tan'dúúcā chi ngaⁿ'á 'tiicá ntúūⁿ diíⁿ yā tan'dúúcā chi ngaⁿ'á nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tanducuéⁿ'ē chuū diíⁿ yā ndúúcū ndis'tiī caavā chi duuchí ti nguɛ́ɛ́ n'diichí yā 'iiⁿ'yāⁿ chi dichó'o yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ndúúti chi nguɛ́ɛ́ ndaá ndíí nguɛ́ɛ́ ndúú yaa'ví rá 'iiⁿ'yāⁿ tuu'mi 'iiⁿ'yāⁿ ní nguɛ́ɛ́ déénu yā chi vɛ́ɛ́ nuuⁿndi yeⁿ'é yā. Maaⁿ ní nguɛ́ɛ́ mar 'áámá yā chi cuuvi caaⁿ'máⁿ yā chi nguɛ́ɛ́ vɛ́ɛ́ nuuⁿndi yēⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ neⁿ'é yā 'úú 'tiicá ntúūⁿ Chiidá mííⁿ ní nguɛ́ɛ́ neⁿ'e yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ndúúti chi 'úú nguɛ́ɛ́ diíⁿ nguaaⁿ yā ntiiⁿnyūⁿ chi mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ diíⁿ yā, nguɛ́ɛ́ déénú yā chi vɛ́ɛ́ nuuⁿndi yēⁿ'e yā. Naati maaⁿ ní n'diichí yā 'úú, ní nguɛ́ɛ́ neⁿ'é yā 'úú ndúúcū Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Iicu cuuví cuaacu nduudu chi canéé nguūⁿ na ley yēⁿ'e yā: Nguɛ́ɛ́ dɛ'ɛ̄ caavā chi nguɛɛ neⁿ'é yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Naati taachi ndaá yā 'iiⁿ'yāⁿ chi Espíritu N'dai yeⁿ'e Dendyuūs ní tée yā poder s'uuúⁿ. Ní 'úú ní dicho'ó Espíritu N'dai chi yeⁿ'ē Chiidá. Espíritu N'dai yeⁿ'e Dendyuūs ní cuaacu ní cuchii yeⁿ'ē Chiidá. Espíritu miiⁿ caaⁿ'maⁿ cuaacú yā yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","'Iicu ndís'tiī ní caaⁿ'maⁿ cuaacú nī yeⁿ'ē 'úú caati canée nī nduucú ndii cuááⁿ naachi chi nga'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Caⁿ'a Jesús: Chuū ngaⁿ'á ngií ndis'tiī 'iicu nguɛ́ɛ́ nduuvi taáⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","'Iiⁿ'yāⁿ ní 'cuɛɛcú yā ndís'tiī cuaaⁿ chuva'āī yaācū. Ní taachí ndaá hora chi 'caaⁿ'núⁿ yā ndís'tiī, nacádiinúúⁿ yā chi n'daacā idiíⁿ yā ntiiⁿnyuⁿ yeⁿ'é Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ní 'iiⁿ'yāⁿ s'tíī ní 'tíícā idiíⁿ yā ti nguɛɛ n'diichí yā Chiidá, ndii nguɛ́ɛ́ nduu 'úú ra. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Maaⁿ ní ngaⁿ'á ngií chuū ndis'tiī caati taachí ndaa hora miiⁿ n'gáácú nī ti 'úú ní 'āā caⁿ'á. Chuū ni nguɛ́ɛ́ caⁿ'á ndíí cuaaⁿ vmnaaⁿ ti 'úú caneé ndúúcū ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Caⁿ'a Jesús: Naati maaⁿ ní caⁿ'á n'diichí 'iiⁿ'yāⁿ chi dichó'ō 'úú. Ní mar 'áámá ndís'tiī nguɛ́ɛ́ ntiinguuneéⁿ nī 'úú: ¿Tíí caⁿ'a nī? ");
INSERT INTO cuxNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chiiⁿ chi caⁿ'á chi 'túúcā, ní nééné chii ndaāchií staava yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","'Úú ngaⁿ'á nduudu cuaacu miiⁿ: N'daacā cáávā ndís'tiī chi caⁿ'á. Ndúútī chi 'úú nguɛ́ɛ́ caⁿ'á tuu'mi ní Espíritu N'dai yeⁿ'e Dendyuūs chi tée yā poder ndís'tiī nguɛ́ɛ́ ndai yā nanááⁿ ndís'tiī. Ndúútī chi 'úú caⁿ'á ní 'úú dicho'ó 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Taachí 'iiⁿ'yāⁿ miiⁿ ní ndāa yā, ní caaⁿ'máⁿ yā ndúúcū 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī yeⁿ'ē nuuⁿndi, ní yeⁿ'ē vaadī cuaacu, ní yeⁿ'ē 'iiⁿ'yāⁿ chi diiⁿ juzgar. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Caaⁿ'máⁿ yā yeⁿ'ē nuuⁿndi chi nguɛ́ɛ́ i'téénu yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Caaⁿ'máⁿ yā yeⁿ'e vaadī cuaacu chi 'úú caⁿ'á nanááⁿ Chiidá ní 'āā ntɛ́ɛ́ n'diichí yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Caaⁿ'máⁿ yā nuuⁿndi yeⁿ'e 'áámá 'iiⁿntyeⁿ'ē ch'ɛɛtɛ yeⁿ'e iⁿ'yeeⁿdí 'cūū 'āā canéé juzgado sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nééné n'deee dendu'ū chi vɛ́ɛ́ chi cuuví ndis'tiī naati maaⁿ ní nguɛɛ cuuví cūnee ná vaanicadiinūuⁿ yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Taachí ndaá Espíritu yeⁿ'é vaadī cuaacu, 'iiⁿ'yāⁿ miiⁿ ní ca'cuéeⁿ yā ndís'tiī na tanducuéⁿ'ē vaadī cuaacu. Ni nguɛ́ɛ́ caaⁿ'máⁿ yā yeⁿ'ē maáⁿ yā ti caaⁿ'máⁿ yā tanducuéⁿ'ē chi n'giindiveéⁿ yā. Ní ch'iⁿ'i yā ndis'tiī dɛ'ɛ̄ chí cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","'Iiⁿ'yāⁿ miiⁿ ní ch'iⁿ'í yā poder yeⁿ'é ti cuta'á yā poder yeⁿ'e 'úú ní ch'iⁿ'í yā ndis'tiī. Ní cuuvi cádiinúúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'ē Chiidá, chuū ní yeⁿ'é. Cáávā chuū ngaⁿ'á chi Espíritu yeⁿ'e vaadī cuaacu cuta'á yā yeⁿ'ē 'úú ní ch'iⁿ'í yā ndís'tiī. Ní cádiinúúⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Caⁿ'a Jesús: Taa 'lííⁿ ní 'āā ntɛ́ɛ́ snaáⁿ nī 'úú. Taama vmnéⁿ'ee, taa 'lííⁿ ní snaáⁿ nī 'úú ti 'úú ní caⁿ'á nanááⁿ Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tuu'mí caⁿ'a n'duuvi discípulos yeⁿ'é yā ngii yā 'áámá yā táámá yā: ¿Dɛ'ɛ chi 'tíícā ngaⁿ'a yā ngiī yā s'uuúⁿ taaⁿ 'lííⁿ ní 'āā ntɛ́ɛ́ chinaáⁿ nī 'úú ní taama vmneⁿ'ēe taaⁿ 'lííⁿ ní chinaáⁿ nī 'úú, ti 'úú ní caⁿ'á nanááⁿ Chiidá? ");
INSERT INTO cuxNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tuu'mi ní ngaⁿ'a yā. ¿Dɛ'ɛ chi 'tíícā taaⁿ 'lííⁿ? Nguɛ́ɛ́ tuumicadiinuuⁿ yú. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ní tuumicádíínuuⁿ Jesús chi neⁿ'e ntiinguuneeⁿ saⁿ'ā s'eeⁿ, ní ngaⁿ'a yā: ¿'Áá ntííngúúneeⁿ vi'í nī chi 'túúcā caⁿ'á chií taaⁿ 'lííⁿ ní 'āā ntɛ́ɛ́ chi naaⁿ nī 'úú, ní taama vmnéⁿ'ēe, taa 'lííⁿ ní chi naáⁿ nī 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cuaacu nííⁿnyú cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndis'tiī: Maaⁿ ní cuɛɛcu nī ní ya'ai nī. Ní iⁿ'yeēⁿdī ní cuuvi yeenú naati ndís'tiī ní chi n̄'daaⁿ chi yá'ai nī ndúúcū vaadī yeenú. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","N'daataá chí canee chi 'āā 'cuundiyáāⁿ daiyā tá, vɛ́ɛ́ vaadī ya'ai yeⁿ'ē ta, ti 'āā chɛ́ɛ́ ndaa hora yeⁿ'ē tá. Taachí 'āā vɛ́ɛ́ daiya tá 'āā ntɛ́ɛ́ n'gaacu tá yeⁿ'e vaadī ya'ai yeⁿ'ē tá chi yeenú tá chi vɛ́ɛ́ 'áámá daiya tá yeⁿ'é iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'Tiicá ntúūⁿ ndís'tiī ní canéé vaadī ndaachií nanáaⁿ nī. Naati taama vmnéⁿ'ēe ní n'diichí ntuúⁿ ndís'tiī. Ní cuneé nī vaadī yeenú na staava yeⁿ'é nī. Ní mar 'áámá 'iiⁿ'yāⁿ ní nguɛ́ɛ́ divíi yā vaadī yeenú yeⁿ'é ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ní nguuvi miiⁿ nguɛ́ɛ́ ntiinguunéeⁿ nī du'ū vɛɛ yeⁿ'é. Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií ndís'tiī chi tanducuéⁿ'ē chi caaca nī Chiidá ndúúcū chi duuchí ní Chiidá tée yā ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ndii maaⁿ nguɛ́ɛ́ du'ū vɛɛ ngiica nī ndúúcū chi duuchí. Caaca nī ní Chiidá tée yā ndís'tiī. Ní vaadī yeenú yeⁿ'é nī cuuvi yeenu taavi. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Chuū chi ngaⁿ'á ndúúcū cuentas yeⁿ'é ndúúcū ndís'tiī. Maaⁿ ní ndaa hora chi 'āā ntɛ́ɛ́ caⁿ'á yeⁿ'é ndis'tiī ndúúcū cuentas naati caaⁿ'máⁿ cuaacu yeⁿ'ē Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nguuvi miiⁿ ní caaca nī ndúúcū chi duuchí. Ní 'úú nguɛ́ɛ́ ngaⁿ'á chi 'úú nídi'cuíítú Chiidá cáávā ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Maaⁿ Chiidá neené neⁿ'é yā ndís'tiī caati ndís'tiī neⁿ'é nī 'úú. Ní i'teenu nī chi 'úú chiicá yeⁿ'ē Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Chiicá yeⁿ'ē Chiidá ní ndaá iⁿ'yeēⁿdí 'cūū. Cu'neeⁿ ntuúⁿ iⁿ'yeēⁿdī. Ní naⁿ'á n'diichí Chiidá. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tuu'mí ngaⁿ'a discípulos yeⁿ'é yā: Cun'dííchí dí maaⁿ ní ngaⁿ'ā cuaacu di nguɛ́ɛ́ ndúúcū cuentas. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Maaⁿ ní tuumicadiinúúⁿ 'nū chi deenú nī tanducuéⁿ'ē dendu'ū. Ní nguɛ́ɛ́ canee ngiinú nī chi ntiinguuneeⁿ 'iiⁿ'yāⁿ n'diī. Cáávā chuū i'teenú 'nū chi chiica nī yeⁿ'é Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Nan'guɛɛcútaⁿ'ā Jesús: ¿'Áá i'téénu nī maaⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cun'diichí nī. Hora miiⁿ ní cuchiī. Ní 'āā ndaā chí caⁿ'ā 'muuⁿ caⁿ'ā miiⁿ ndís'tiī na vaacú nī. Ní cu'neéⁿ nūuⁿ nī 'úú dámaaáⁿ. Naati nguɛ́ɛ́ canee dámaaáⁿ ti Chiidá canée yā nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chuū ni ngaⁿ'á ngií ndis'tiī chi cucáávā 'úú canee 'diiíⁿ nī. Iⁿ'yeēⁿdī ní 'cueenú nī cuuvi. Cuuvi ch'ɛɛ̄tiinúu nī. 'Úú ní chichɛɛ́ ndúúcū iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chuū caⁿ'a Jesús ní n'diichí yā cuaaⁿ nanguuvi ní caⁿ'a yā: N'diī Chiidá, hora yeⁿ'é ní 'āā ndaā. Diíⁿ nī dich'ɛɛtɛ́ nī Daiya nī. 'Tiicā ntúūⁿ 'úú chi Daiya nī cuuvi dich'ɛɛtɛ́ n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tan'dúúcā chi tee nī poder 'úú chi Daiya nī yeⁿ'e dɛ'ɛ̄ chi diíⁿ nducyaaca 'iiⁿ'yāⁿ cáávā chí ca'á vida cueⁿ'e daāⁿmaⁿ 'iiⁿ'yāⁿ chi tee nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Chuū chi vida cueⁿ'e daāⁿmaⁿ chí n'diichí yā n'diī chi 'áámá n'dyaⁿ'ā Dendyuūs chi cuaacu nííⁿnyúⁿ chí Dendyuūs ndúúcū Jesucristo chí dichó'o nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","'Úú ní dich'ɛɛtɛ́ n'diī na yáⁿ'āa 'cūū. 'Āā ch'iinú diíⁿ ntiiⁿnyuⁿ chi teé nī chi diíⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maaⁿ ní n'diī, Chiidá, dich'ɛɛtɛ́ nī 'úú, n'diī ndúúcū maáⁿ nī, ndúúcū poder chi caneé nduucú maáⁿ taachi 'āā 'cuɛ́ɛ́ cunee iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ngaⁿ'a cuaacú yeⁿ'ē chi duuchi yeⁿ'é nī nanááⁿ saⁿ'ā s'eeⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū chi teé yā 'úú. Saⁿ'ā s'eeⁿ yeⁿ'é nī. Ní teé nī 'úú. Ní n'giindiveéⁿ yā nduudu yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Maaⁿ ní déénú yā chi tanducuéⁿ'ē dendu'ū chi teé nī 'úú ní yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ti ndúúdú chi teé nī 'úú ní caⁿ'á nanááⁿ 'iiⁿ'yāⁿ ní 'iiⁿ'yāⁿ s'eeⁿ ní n'giindiveéⁿ yā nduudu miiⁿ. Ní deenu cuaacu yā chi chiīcá nanááⁿ n'diī. Ní i'téénu yā chi n'diī dicho'ó nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","'Úú ngiicá caavā 'iiⁿ'yāⁿ s'eeⁿ. Nguɛ́ɛ́ nidi'cuíítu cáávā iⁿ'yeēⁿdī ti cáávā 'iiⁿ'yāⁿ chi teé nī 'úú, ti yeⁿ'é n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ní taanduvɛ́ɛ́ dendu'ū yeⁿ'é ní yeⁿ'é nī. Ní taanduvɛ́ɛ́ dendu'ū yeⁿ'é nī ní yeⁿ'é. Ní chuū ch'iⁿ'i poder yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ní 'āā ntɛ́ɛ́ cūneé iⁿ'yeēⁿdī naati 'iiⁿ'yāⁿ s'eeⁿ snée yā iⁿ'yeēⁿdī. 'Úú ní cuchií nanáaⁿ nī. N'diī Chiidá chi dɛɛvɛ, diíⁿ nī cuidado 'iiⁿ'yāⁿ chi teé nī 'úú ndúúcū chi duuchí nī. Ní chi cuuví 'áámá yā tan'dúúcā s'uuúⁿ ní 'áámá yú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Taachí caneé ndúúcū 'iiⁿ'yāⁿ iⁿ'yeēⁿdī ní dīiⁿ cuidado 'iiⁿ'yāⁿ ndúúcū chi duuchi nī, 'iiⁿ'yāⁿ chi nteé nī 'úú. 'Úú ní dīiⁿ cuidado 'iiⁿ'yāⁿ ní mar 'áámá yā nguɛ́ɛ́ chindāi yā. 'Áámá nūuⁿ saⁿ'ā daiya yááⁿn'guiinūuⁿ chindai sa. Ní 'iicu naachi cánéé nguūⁿ ní cúúví cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Naati maaⁿ ní cuchií nanáaⁿ nī. Ní ngaⁿ'á chuū taachi cuneé iⁿ'yeēⁿdí 'cūū caati vaadī yeēnu yeⁿ'é canéé nduucú yā, ní cuuvi yeenú taavi yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'Úú ní ca'á 'iiⁿ'yāⁿ nduudu yēⁿ'e nī. Iⁿ'yeēⁿdī nguɛ́ɛ́ dinéⁿ'e 'iiⁿ'yāⁿ ti nguɛ́ɛ́ yeⁿ'e iⁿ'yeēⁿdī 'iiⁿ'yāⁿ. 'Tiicá ntúūⁿ nguɛ́ɛ́ yeⁿ'e iⁿ'yeēⁿdī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nguɛ́ɛ́ di'cuíítūu chi ndivíi nī 'iiⁿ'yāⁿ yeⁿ'ē íⁿ'yeēⁿdī. Diíⁿ nī cuidado 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'e yááⁿn'guiinūuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nguɛ́ɛ́ yeⁿ'e iⁿ'yeēⁿdī 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā chi nguɛ́ɛ́ yeⁿ'e iⁿ'yeēⁿdī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Diíⁿ nī didɛɛvɛ́ nī 'iiⁿ'yāⁿ cucáávā nduudu cuaacu yeⁿ'é nī. Nduudu yeⁿ'é nī ní nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tan'dúúcā chi dicho'ó nī 'úú iⁿ'yeēⁿdī 'tiicā ntúūⁿ dicho'ó 'iiⁿ'yāⁿ s'eeⁿ iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cáávā 'iiⁿ'yāⁿ s'eeⁿ 'úú māaⁿ didɛɛvɛ́ maáⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ cuuví yā dɛɛvɛ na nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nguɛ́ɛ́ di'cuiituú dámaaⁿ caavā 'iiⁿ'yāⁿ miiⁿ ti cáávā 'iiⁿ'yāⁿ chi cu'téénu yā 'úú cáávā nduudu yeⁿ'ē 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ní nducyaaca yā ní 'áámá nūuⁿ cuuví yā tan'dúúcā n'diī canée nī nduucú, ní caneé nduucú nī. Níícú 'iiⁿ'yāⁿ s'eeⁿ ní canéé ntúuⁿ yā 'áámá nūuⁿ ndúúcu yú. Ní 'iicu cu'téénú 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī chi n'diī dicho'ó nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ní poder chi tée nī 'úú, miiⁿ ni ca'á 'iiⁿ'yāⁿ. Ní 'áámá nūuⁿ cuuví yā tan'dúúcā chi 'áámá nus'ūu. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","'Úú ní ndúúcū 'iiⁿ'yāⁿ s'eeⁿ. Ní n'diī ní ndúúcū 'úú. Níícú 'áámá nūuⁿ chi n'daacā cuuví yā. Ní iⁿ'yeēⁿdī ní cuuvi deenu chi dicho'ó nī 'úú ní chí dinéⁿ'e nī 'iiⁿ'yāⁿ s'eeⁿ tan'dúúcā chi neⁿ'é nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","N'diī Chiidá, 'iiⁿ'yāⁿ s'eéⁿ chi teé nī 'úú, neⁿ'é chi naachi 'úú cuneéⁿ, 'iiⁿ'yāⁿ s'eéⁿ cūnée yā nduucú. Ní cuuvi n'diichí yā poder yeⁿ'é chi teé nī 'úú caati n'diī ní neⁿ'é nī 'úú ndii taachi 'āā 'cuɛ́ɛ́ iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","N'diī Chiidá chi dɛɛvɛ, 'aa ntɛ́ɛ́ rá chi iⁿ'yeēⁿdī nguɛ́ɛ́ n'diichí n'diī 'úú n'diichí n'diī. Ní 'iiⁿ'yāⁿ s'tíī ní deenú yā chi n'diī dichó'o nī 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'Úú ní ngaⁿ'á yeⁿ'e chi duuchí nī, ní caⁿ'á ngāⁿ'aⁿ yeⁿ'e chi duuchí nī. Níícú maaⁿ vaadī neⁿ'e chi néⁿ'e nī 'úú cuuvi cunéé ndúúcu yā. Ní 'úú caneé ndúúcu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Taachí Jesús caⁿ'á yā chuū, can'dáa yā ndúúcū discípulos yeⁿ'é yā táámá lado yíícú 'lííⁿ chi nguuvi Cedrón naachi canéé 'áámá cheēⁿ yeⁿ'e naāndā. Ní miiⁿ sndaā Jesús ndúúcū discípulos yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas chí diiⁿ sa entregar Jesús ní n'diichi ntúūⁿ saⁿ'ā na cheēⁿ miiⁿ ti 'āā cánéé n'deee cuuví nduuvidáámá yā Jesús ndúúcū discípulos yeⁿ'é yā na cheēⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Saⁿ'ā chiiduú n'gɛɛtɛ́ ndúúcū saⁿ'ā fariseos teé yā Judas Iscariote soldados ndúúcū policías ní Judas cueⁿ'e sa ndúúcū 'aama taaⁿ soldados ndúúcū policías. Ndaa yā na cheēⁿ miiⁿ ndúúcū lámparas, ndúúcū antorchas, ndúúcū armas. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Naati Jesús chi déénú yā tanducuéⁿ'ē dendu'ū chí cuchiī, cueⁿ'e yā ní ndaa yā nanáaⁿ 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: ¿Du'u in'nuúⁿ nī? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ní nan'guɛɛcutáⁿ'a sa yeⁿ'e yā: Jesús yeⁿ'ē yáāⁿ Nazaret miiⁿ. Tuu'mí ngaⁿ'a Jesús ngií yā 'iiⁿ'yāⁿ s'eeⁿ: 'Úú 'iiⁿ'yāⁿ miiⁿ. Canée ntúūⁿ Judas miiⁿ, saⁿ'ā chí diíⁿ nca'a sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Taachí Jesús caⁿ'a yā: 'Úú 'iiⁿ'yāⁿ miiⁿ, tuu'mi ní saⁿ'ā s'eeⁿ ndaacadaamí yā ní ch'ɛɛtindiití yā na yáⁿ'āa. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Nan'guɛɛcúnéé ntuúⁿ yā tiinguuneeⁿ yā: ¿Du'u ra in'nuúⁿ nī? Ní 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: Jesús yeⁿ'ē yáāⁿ Nazaret miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nan'guɛɛcútaⁿ'ā Jesús: 'Āā ngaⁿ'á ngií ndís'tiī chi 'úú. Ndúúti chi 'úú chi in'nuúⁿ nī, 'cuáaⁿ nī chi naⁿ'a 'iiⁿ'yāⁿ s'tíī. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ní cuuvi cuaacu chi 'úú chi caⁿ'á: 'Iiⁿ'yāⁿ chí teé nī 'úú, mar 'áámá yā nguɛ́ɛ́ chi ndai yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tuu'mi Simón Pedro chi ndɛ́ɛ sa espada ní tun'dáa sa ní 'nuūcá'ai sa ní ch'iica sa veeⁿ sa lado tá cuaacu yeⁿ'ē sáⁿ'ā chi diiⁿ mandado yeⁿ'e chiiduú ch'ɛɛtɛ ca. Ní saⁿ'ā miiⁿ ní nguuvi sa Malco. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tuu'mí Jesús ngaⁿ'a yā ngiī yā Pedro: N'nuūⁿ dí espada vaacu. Prueba chí teē Chiidá 'úú, ¿'áá nguɛ́ɛ́ cánéé chí 'cueenú cuuvi yeⁿ'ē? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tuu'mi ní 'iiⁿ'yāⁿ yeⁿ'ē 'áámá taaⁿ soldado ndúúcū soldado chi yuudu ndúúcū policías yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ ní sta'á sa Jesús ní cachiichí sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ní candɛ́ɛ sa vmnááⁿ vmnaaⁿ nanááⁿ saⁿ'ā chi nguuvi Anás, tii sáⁿ'ā miiⁿ ní nchaⁿ'ā ndiīcú Caifás miiⁿ. 'Iiⁿ'yāⁿ miiⁿ ní chiiduú ch'ɛɛtɛ́ ca nduuyu miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ní Caifás miiⁿ ca'a sá consejo saⁿ'ā Israel s'eeⁿ chi canéé chí 'cuūvī 'aama saⁿ'ā cáávā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ní n'daā Simón Pedro Jesús miiⁿ ní táámá discípulos. Ní chiiduú ch'ɛɛtɛ́ ca n'diichí yā discípulos miiⁿ chí sndaá sa ndúúcū Jesús corredor yeⁿ'ē va'ai yeⁿ'ē chiiduú ch'ɛɛtɛ́ ca miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Naati Pedro miiⁿ canéé sá cuaaⁿ dáámí cheendi va'āī. Ní can'dáā taama discípulo chi chiiduú ch'ɛɛtɛ́ ca n'diichí yā 'iiⁿ'yāⁿ. Ní yaa'ví yā n'daataá chi canéé cheendi va'āī. Ní diiⁿyúⁿ yā Pedro mííⁿ chɛɛti va'āī. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tuu'mi ní n'daataá chi diiⁿ mandado chí canéé cheendi va'āī ngaⁿ'a tá: ¿'Áá nguɛ́ɛ́ díí ntúūⁿ 'áámá discípulo yeⁿ'ē saⁿ'a 'cūū? Tuu'mí Pedro ngaⁿ'ā sa: Nguɛ́ɛ́ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ní chééndii saⁿ'ā chi dichíí'vɛ̄ ndúúcū policías, saⁿ'ā miiⁿ tiivi sa yaⁿ'ā yeⁿ'e yíyūu ti 'áámá 'iichɛɛ. Saⁿ'ā miiⁿ nga'a tavii'nu sa. Ní canée nī ntúūⁿ Pedro ndúúcu sa. Ni chéendii sa nga'a tavii'nu sa ca'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ní chiiduú ch'ɛɛtɛ́ cá miiⁿ nítiinguuneeⁿ sa Jesús yeⁿ'e discípulos yeⁿ'é yā ndúúcū yeⁿ'e chi Jesús chi'cueéⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús nan'guɛɛcutáⁿ'a yā yeⁿ'ē sa: 'Úú ní ngaⁿ'á cuaacú nanááⁿ 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeēⁿdī. 'Úú ní chi'cueéⁿ na yaācū sinagogas ní na yaacū templo ntúūⁿ naachí nduuvidaama nducyaaca 'iiⁿ'yāⁿ Israel s'eeⁿ ní nguɛ́ɛ́ dɛ'ɛ̄ vɛɛ chi ngaⁿ'a n'de'éí. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Dɛ'ɛ̄ tííngúúnéeⁿ di 'úú? Tííngúúnéeⁿ dí 'iiⁿ'yāⁿ chi ch'iindiveéⁿ yā chí caⁿ'á chií 'iiⁿ'yāⁿ. N'diichi nī. 'Iiⁿ'yāⁿ s'eeⁿ déénú yā chi caⁿ'á. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Taachí Jesús ch'iinu caⁿ'á yā chuū, 'áámá policía chi canéé miiⁿ ch'éⁿ'e sá Jesús, ní caⁿ'a sa: ¿'Áá 'tíícā nan'guɛɛcutáⁿ'a di yeⁿ'ē chiiduú ch'ɛɛtɛ ca? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nan'guɛɛcútaⁿ'ā Jesús: Ndúúti chi nguɛɛ n'daacā chi ngaⁿ'á caaⁿ'maⁿ di dɛ'ɛ̄ chi nguɛɛ n'daacā chi ngaⁿ'á. Ndúúti chi n'daacā, ¿dɛ'ɛ̄ cuuvi chi n'geⁿ'ē di 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás miiⁿ ní dichó'o sa Jesús ch'ɛɛchiichí yā nanááⁿ saⁿ'ā chi nguuvi Caifás miiⁿ, saⁿ'ā chi chiiduú ch'ɛɛtɛ́ cá miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Chééndii Simón Pedro miiⁿ ní nga'a tavii'nu sa saⁿ'ā. Ní ngaⁿ'a yā ngii yā saⁿ'ā: ¿'Áá nguɛ́ɛ́ 'tíícā chi díí ní discípulo yeⁿ'é yā? Pedro cheeⁿdíítu sa ní ngaⁿ'ā sa: Nguɛ́ɛ́ 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","'Áámá saⁿ'ā chi diiⁿ mandado yeⁿ'ē chiiduú ch'ɛɛtɛ́ cá ní saⁿ'ā miiⁿ ní 'iiⁿ'yāⁿ yeⁿ'e saⁿ'ā chi chiica Pedro miiⁿ veeⁿ sa. Ngaⁿ'a sa ngii sa saⁿ'ā: ¿'Áá nguɛ́ɛ́ n'diichí dii chɛɛti chéēⁿ naāndā miiⁿ ndúúcu yā? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Taama vmnéⁿ'ēe ní cheeⁿdiitú táaⁿ Pedro: Nguɛ́ɛ́ 'úú. Ní miⁿniiⁿyu miⁿniiⁿyu ní tusaⁿ'ā chiita tī. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ní candɛ́ɛ sa Jesús miiⁿ tyaaⁿ tyaaⁿ yeⁿ'ē nanááⁿ Caifás miiⁿ ndii naachi canéé cuarto yeⁿ'ē juzgado. Ní 'iiⁿ'yāⁿ s'eeⁿ ní nguɛ́ɛ́ chi ndaá yā cuaaⁿ chɛɛti va'ai ch'ɛɛtɛ miiⁿ cáávā chi nguɛ́ɛ́ neⁿ'e yā chi cuneedáámí yā nuuⁿndi taachi ché'e yā nguiinú yeⁿ'ē pascua. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Tuu'mi ní can'daā Pilato chuva'aī nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a sa: ¿Dɛ'ɛ̄ nuuⁿndi yeⁿ'ē saⁿ'a 'cūū vɛɛ? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nan'guɛɛcutáⁿ'a yā ní caⁿ'á yā 'iiⁿ'yāⁿ: Ndúúti chi saⁿ'a 'cūū chi nguɛɛ du'ū vɛɛ diiⁿ sa, nguɛ́ɛ́ teé 'nū saⁿ'ā n'diī. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tuu'mi ní ngaⁿ'ā Pilato ngii sa 'iiⁿ'yāⁿ s'eeⁿ: Cuta'á nī 'iiⁿ'yāⁿ. Ní n'diichí yā dɛ'ɛ̄ nuuⁿndi yeⁿ'e yā vɛ́ɛ́ tan'dúúcā chi canéé na ley yeⁿ'é nī. Níícú 'iiⁿ'yāⁿ Israel s'eeⁿ ní caⁿ'a yā: Nús'uu ní nguɛ́ɛ́ cánéé chí 'caaⁿ'nuⁿ 'nū mar 'áámá 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ní cuuví cuaacu chi caⁿ'a Jesús miiⁿ. Ní caⁿ'a yā chí cadiinuuⁿ 'iiⁿ'yāⁿ dɛ'ɛ́ vaadī n'gii 'cuuvi yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nííⁿnuuⁿ ndáá ntúūⁿ Pilato cuarto yeⁿ'ē juzgado. Ní 'cáí sa Jesús miiⁿ ní caⁿ'a yā: ¿'Áá díí chi Rey yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ chi judíos? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nan'guɛɛcútaⁿ'ā Jesús: ¿'Áá ngaⁿ'a dii chuū yeⁿ'e maāⁿ di o 'iiⁿ'yāⁿ 'cúū ch'iⁿ'i yā ní ngaⁿ'a yā n'diī yeⁿ'ē 'úú? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato miiⁿ ní n'guɛɛcutáⁿ'a sa: ¿'Áá 'úú chi saⁿ'a Israel 'úú? 'Iiⁿ'yāⁿ yeⁿ'e nación yeⁿ'ē di ndúúcū chiiduú n'gɛɛtɛ́ nteé yā dii 'úú. ¿Dɛ'ɛ̄ n̄diíⁿ di? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nan'guɛɛcútaⁿ'ā Jesús: Cuaaⁿ naachi 'úú chi 'iiⁿntyeⁿ'e nguɛ́ɛ́ canéé iⁿ'yeeⁿdí 'cūū. Ndúúti chi yeⁿ'ē iⁿ'yeeⁿdí 'cūū naachi caaⁿ'maⁿ ntiiⁿnyúⁿ tuu'mi ní 'iiⁿ'yāⁿ chi diiⁿ mandado yeⁿ'é ní 'cuuⁿ'maⁿ yā cáávā 'úú ni nguɛ́ɛ́ nica'á yā 'úú 'iiⁿ'yāⁿ Israel s'eeⁿ. Maaⁿ ní cuaaⁿ naachi 'úú chi 'iiⁿntyeⁿ'e nguɛ́ɛ́ yeⁿ'ē iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tuu'mi ngaⁿ'a Pilato ngii sa 'iiⁿ'yāⁿ: Tuu'mi, ¿'áá díí chi rey miiⁿ? Nan'guɛɛcútaⁿ'ā Jesús: Díí ngaⁿ'ā di chi rey 'úú ní 'tíícā 'úú. 'Úú ní cáávā chuū ch'iindiyaáⁿ, ní cáávā chuū chi ndaá iⁿ'yeeⁿdí 'cūū, caavā chi caaⁿ'maⁿ cuaacú yeⁿ'ē nduudu cuaacu. Nducyáácá 'iiⁿ'yāⁿ chi yeⁿ'ē vaadī cuaacu miiⁿ, n'giindiveéⁿ yā nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Tuu'mí ngaⁿ'ā Pilato: ¿Chɛɛ chí vaadī cuaacu? Taachí caⁿ'a Pilato chúū ní can'dáá ntuúⁿ sa nanááⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ ní caⁿ'a sa 'iiⁿ'yāⁿ Israel s'eeⁿ: 'Úú ní nguɛ́ɛ́ ndaācá mar 'áámá nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Naati cáávā costumbre yeⁿ'e ndís'tiī ní 'úú caneecúúⁿmíⁿ chí ín'dɛɛchí 'áámá saⁿ'ā chi preso sa 'viicu yeⁿ'e pascua. ¿'Áá neⁿ'é nī chi in'dɛɛchí Rey yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tuu'mi ní 'cai ntúūⁿ nducyaaca yā, ní ngaⁿ'a yā: Nguɛ́ɛ́ 'iiⁿ'yáⁿ 'cūū ti Barrabás. Níícú saⁿ'ā Barrabás miiⁿ ní neené duucu sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tuu'mi ní sta'āa Pilato Jesús miiⁿ ni ch'eⁿ'e sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ní soldados ní din'dáa sa 'áámá corona yeⁿ'ē yááⁿ ní chi n'duu sá na tiíⁿ yā. Ní chi'nuúⁿ sa 'áámá catecai morado 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ní caⁿ'a sa: Nééné 'nááⁿ cānee di íⁿ'yeēⁿdi, dii, Rey yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e Israel. Ní n'geⁿ'é sa 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tuu'mí can'dáa ntuūⁿ Pilato chuva'āī. Ní caⁿ'ā sa chii sa 'iiⁿ'yāⁿ s'eeⁿ: Cuin'diichí nī, tun'daá 'iiⁿ'yāⁿ chuva'āī niicu tuumicadiinúúⁿ nī chi nguɛ́ɛ́ n'diichí mar 'áámá nuuⁿndi yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ní can'daā Jesús chuva'āī. Can'dɛ́ɛ yā corona yeⁿ'e yááⁿ ndúúcū catecai morado yā. Ní ngaⁿ'a Pilato miiⁿ: Cun'dííchí nī saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Taachí n'diichí yā 'iiⁿ'yāⁿ tuu'mi ní chiiduú n'gɛɛtɛ́ ndúúcū policías n'gaī yiicu sa: Cu'nééⁿnga'á nī 'iiⁿ'yāⁿ. Cu'nééⁿnga'á nī 'iiⁿ'yāⁿ. Tuu'mi ngaⁿ'ā Pilato ngii yā 'iiⁿ'yāⁿ s'eeⁿ: Cuta'a ndis'tiī 'iiⁿ'yāⁿ, ní cu'nééⁿnga'á nī 'iiⁿ'yāⁿ, ti 'úú ní nguɛ́ɛ́ indaacá mar 'áámá nuuⁿndi yēⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nan'guɛɛcútaⁿ'ā 'iiⁿ'yāⁿ Israel s'eeⁿ: Nús'uū ní cánéé ley yeⁿ'é 'nū. Ní tan'dúúcā chi ngaⁿ'a ley miiⁿ canee chi 'cuuvī caati caⁿ'a yā chi maáⁿ yā Daiya Dendyuūs 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Taachí ch'iindiveeⁿ Pilato chuū dii'yā ca sá chiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Chindáa ntuūⁿ sa cuarto yeⁿ'ē juzgado ní caⁿ'á yā chii yā Jesús: ¿Tií 'iiⁿ'yāⁿ dii? Naati Jesús ní nguɛ́ɛ́ caⁿ'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tuu'mi ní caⁿ'a Pilato Jesús: Dii, ¿'áá nguɛɛ ngaⁿ'ā di yeⁿ'é? ¿'Áá nguɛ́ɛ́ deenu di chi 'úú ní cúúví caaⁿ'maⁿ ntiiⁿnyúⁿ chi cu'nééⁿnga'á nī dii, ní cuuvi n'tɛɛchí ntúuⁿ dii? ");
INSERT INTO cuxNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nan'guɛɛcútaⁿ'ā Jesús miiⁿ: Nguɛ́ɛ́ du'ū vɛɛ cuuvi diiⁿ di ndúúcū 'úú ndúúti chi nguɛ́ɛ́ du'ū vɛɛ ndii ca'a yeⁿ'ē di yeⁿ'ē va'ai chɛɛti nguuvi. 'Iiⁿ'yāⁿ chi tee yā 'úú chi preso 'úú nanáá n'diī, 'iiⁿ'yāⁿ miiⁿ dich'ɛɛtɛ ca nuuⁿndi yēⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ndíí tuu'mi ní neⁿ'e Pilato n'tɛɛchi sa 'iiⁿ'yāⁿ. Naati 'iiⁿ'yāⁿ Israel s'eeⁿ n'gai yiicú yā ní ngaⁿ'a yā: Ndúúti chi saⁿ'á 'cūū n'tɛɛchi di, nguɛ́ɛ́ dii amigo yeⁿ'ē César. Nducyáácá 'iiⁿ'yāⁿ chi ngaⁿ'a yeⁿ'é yā chi maáⁿ yā rey ngaⁿ'a yā contra César. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tuu'mí Pilato, taachi ch'iindiveeⁿ sa chuū, candɛ́ɛ sa Jesús chuva'āī. Ní ch'iindi sa ná silla yeⁿ'e juzgado chi nguuvi Enlosado, ní nduudu hebreo neⁿ'e caaⁿ'maⁿ Gabata. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ní nguuvi chi diíⁿ yā ntiiⁿnyuⁿ yeⁿ'ē 'viicu yeⁿ'ē pascua, tan'dúúcā ndiichúúví na nguuvi. Tuu'mí ngaⁿ'a Pilato 'iiⁿ'yāⁿ Israel s'eeⁿ: Cuin'diichí nī Rey yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Naati 'iiⁿ'yāⁿ s'eeⁿ 'caí yā diitú yā: Divíi nī 'iiⁿ'yāⁿ, divíi nī 'iiⁿ'yāⁿ, cu'nééⁿnga'á nī 'iiⁿ'yāⁿ. Tuu'mí ngaⁿ'a Pilato: ¿'Áá rey yeⁿ'é nī chi cu'nééⁿnga'á nī? Tuu'mí nan'guɛɛcútaⁿ'ā saⁿ'ā chiiduú n'gɛɛtɛ́: Nguɛ́ɛ́ rey yēⁿ'e 'nū caati 'āā César nuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tuu'mi ní Pilato ca'á yā Jesús miiⁿ 'iiⁿ'yāⁿ s'eeⁿ ní 'iicu cu'nééⁿnga'á yā. Ní 'iiⁿ'yāⁿ s'eeⁿ sta'á yā Jesús miiⁿ ní candɛ́ɛ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ní Jesús candɛ́ɛ yā cruz yēⁿ'e yā. Ní can'dáa yā na lugar chi 'áámá lado yeⁿ'e yáāⁿ Jerusalén chi nguuvi Calavera chi lugar 'Iini Nga'ai Tiīiⁿ, 'iicu nduudu hebreo neⁿ'e caaⁿ'maⁿ Gólgota. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Naachí cu'nééⁿnga'á yā Jesús ndúúcū taa na 'uuví yā. 'Áámá yā 'áámá 'áámá lado 'iicu Jesús miiⁿ ní naavtáⁿ'ā canuúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ní 'neeⁿ Pilato miiⁿ 'áámá letra chi n'duu sá nanááⁿ cruz ní canéé nguūⁿ miiⁿ, Jesús yeⁿ'ē yaāⁿ Nazaret, Rey yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'e Israel. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ní neené 'yaaⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ ch'eéⁿ yā letra 'cūū ti nááchí cu'nééⁿnga'a yā Jesús miiⁿ niiⁿnuúⁿ na yáāⁿ Jerusalén miiⁿ. Canéé nguūⁿ miiⁿ na nduudu hebreo ndúúcū nduudu griego ndúúcū nduudu latín. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ní ngaⁿ'a saⁿ'ā chiiduú n'gɛɛtɛ́ yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ ngii sa Pilato: Nguɛ́ɛ́ 'neeⁿ di Rey yeⁿ'ē 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'e Israel naati maáⁿ yā ngaⁿ'a yā: 'Úú Rey yeⁿ'e 'iiⁿ'yāⁿ yeⁿ'e Israel 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nan'guɛɛcútaⁿ'ā Pilato saⁿ'ā miiⁿ: Chiiⁿ 'neéⁿ 'āā 'neéⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Taachi soldados chi'neeⁿnga'ā sa Jesús, sta'á sa catecai yā ní diīⁿ sa repartir catecai yā. Niicu 'áámá 'áámá tááⁿ catecai yā 'aama soldado. Abrigo catecai yā miiⁿ nguɛ́ɛ́ n'deenyú ndii 'nííⁿnúⁿ ndíí cuaaⁿ ndiiya. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ní caⁿ'a sa nguaaⁿ maáⁿ sa: Nguɛ́ɛ́ 'canuu cuūⁿ yú naati tun'daī yú suerte yeⁿ'ē yú nduūcū. Du'ú yeⁿ'ē cuuvi. Ní 'iicu cuuví cuaacu naachí canee nguūⁿ chi ngaⁿ'ā: Nca'á yā catecaí nguaaⁿ maáⁿ yā, ní na catecaí ch'ií yā suerte. Ní soldados ní diiⁿ sa chuū. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ní chɛɛcuú Jesús miiⁿ canée yā niiⁿnuúⁿ ná cruz yeⁿ'e Jesús ndúúcū vi'ī chɛɛcuú yā chi nguuvi María chi n'daataá yeⁿ'ē Cleofas, ndúúcū María Magdalena. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Taachí n'diichi Jesús chɛɛcú yā ndúúcū discípulos chi ya'āī 'iinú yā chi caneé niiⁿnuúⁿ tuu'mi ní Jesús ngaⁿ'á yā ngiī yā chɛɛcú yā: N'diī n'daataá, cun'dííchí nī daiya nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tuu'mi ní ngaⁿ'a yā ngiī yā discípulo: Cun'diichi di, 'ííngaā chɛɛcu di. Ndíí tuu'mi ní discípulo miiⁿ ní dichɛɛcú yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Cho'ó tanducueⁿ'ē chuū ní déénú Jesús chi tanducuéⁿ'ē dendu'ū ní 'āā chii cuaacu. Niicu naachi canéé nguūⁿ níícú cuuvi cuaacu. Ngaⁿ'a Jesús: Yaacá. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mííⁿ canéé 'áámá vaso ndiitu vinagre. Tuu'mi ní 'áámá soldado dicuutu yā 'áámá esponja ndúúcū vinagre. Ní chi'neeⁿ yā na áámá yáⁿ'á hisopo. Ní s'neeⁿ yā na cheendi Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Taachí Jesús chi'i yā vinagre, caⁿ'a yā: Ch'íínú tanducuéⁿ'ē dendu'ū. Ní nadicua'á yā tiiⁿ yā chi n'nééⁿ maáⁿ yā espíritu yēⁿ'e yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tuu'mi ní caati nguuvi viernes chi diíⁿ yā ntiiⁿnyuⁿ yeⁿ'ē 'viicu pascua miiⁿ, ní 'iiⁿ'yāⁿ Israel s'eeⁿ di'cuíítu sa Pilato chi 'cúuⁿmāⁿ sa 'ííní ca'a saⁿ'ā s'eeⁿ ní candɛ́ɛ sa cuerpo yeⁿ'é yā. Caati nguɛ́ɛ́ neⁿ'é sa chi canée cuerpo yeⁿ'é yā na cruz nguuvi sábado miiⁿ caatí sábado ní nguuvi ch'ɛɛtɛ yeⁿ'e 'viicu pascua. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ní ndaā soldados ní ndaa sa nanááⁿ saⁿ'ā chi vmnááⁿ vmnaaⁿ. 'Tíícā 'cuúⁿ sa ca'a sa. 'Tíícā 'cuúⁿ ntúūⁿ sa ca'ā taama sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Naati taachí ndaa sa nanááⁿ Jesús miiⁿ, ní caati n'diichí yā chi 'āā n'dii Jesús nguɛ́ɛ́ 'cuúⁿ sa ca'a yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Naati 'áámá soldado n'da'ai sa tiicuá Jesús ndúúcū 'aama lanza ní can'daā yuuúⁿ ndúúcū nuūⁿnīⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","'Iiⁿ'yāⁿ chí n'diichí yā ngaⁿ'á yā nduudu cuaacu. Níícú chiiⁿ chi ngaⁿ'á yā. Miiⁿ ní cuaacu chííⁿ. 'Iicu déénu yā chi ngaⁿ'á yā nduudu cuaacu níícú ndís'tiī ntúūⁿ ní cu'teenú nī. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Níícú chuū cho'ōo ní cúúví cuaacu chi canée nguūⁿ na libro yeⁿ'e Ndyuūs: Mar 'áámá 'iini yeⁿ'é yā nguɛ́ɛ́ 'cúúⁿ sa. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ní taama naachi canéé nguūⁿ ní ngaⁿ'ā: N'diichí yā 'iiⁿ'yāⁿ chi cho'ōo nééⁿ tiicuá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cho'ōo chuū. José yeⁿ'ē yáāⁿ Arimatea chi 'áámá discípulo yeⁿ'e Jesús n'de'ei n'de'éí nūuⁿ ti 'va'a sa 'iiⁿ'yāⁿ Israel s'eeⁿ, di'cuíítu sa Pilato miiⁿ chi cuuví candɛɛ sa cuerpo yeⁿ'ē Jesús. Ní 'cuūⁿ Pilato saⁿ'ā miiⁿ. Tuu'mi ní ndaā sa ní nadivíi sa cuerpo yeⁿ'ē Jesús miiⁿ ní candɛ́ɛ sa cuerpo miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ndaa ntúūⁿ Nicodemo, saⁿ'ā chi vmnaaⁿ indaá sá nanááⁿ Jesús miiⁿ 'aama n'gaaⁿ, ní ndɛ́ɛ sa 'áámá perfume chi ndístaⁿ'ā perfume yeⁿ'ē mirra ndúúcū áloes. Ngíí tanduu 'áámá ciento libras. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Sta'á yā cuerpo yeⁿ'e Jesús ní ch'ɛɛcú yā ná tiīnūuⁿ ndúúcū perfume miiⁿ, tan'dúúcā costumbre yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ taachí n'giichí yā tinaⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ní lugar miiⁿ naachi chi'neeⁿnga'a yā, miiⁿ canéé 'áámá chéēⁿ naāndā. 'Íícú chɛɛti chéēⁿ miiⁿ canéé 'áámá yáinyāⁿ ngai. Mar 'áámá 'iiⁿ'yāⁿ nguɛ́ɛ́ in'nuúⁿ yā chɛɛti. ");
INSERT INTO cuxNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Cáávā chi nguuvi viernes chi ch'iindiyaáⁿ yā yeⁿ'e 'viicú yeⁿ'e pascua yeⁿ'ē 'iiⁿ'yāⁿ Israel s'eeⁿ, s'nuúⁿ yā cuerpo Jesús miiⁿ chɛɛti yáinyāⁿ miiⁿ chi canee niiⁿnuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'Áámá domingo chi nguuvi vmnááⁿ vmnaaⁿ yeⁿ'e ndɛɛtɛ̄ miiⁿ tá María Magdalena nééné 'da'a ca ndaā tá na yáinyāⁿ. Ní n'diichi tá tuūu miiⁿ chi ndiiviī na yáinyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tuu'mi ní n'daataá ngéenū tá nanááⁿ Simón Pedro ndúúcū táámá discípulo, 'iiⁿ'yāⁿ chi dinéⁿ'e taavi yā Jesús. Tuu'mí ngaⁿ'ā tá ngii tá saⁿ'ā s'eeⁿ: 'Āā ndiivíi yā Jesús miiⁿ ná chɛɛti yáinyāⁿ, ní nguɛ́ɛ́ deenu yú tií n'néeⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ní can'dáā Pedro miiⁿ ndúúcū taama discípulo ní ndaá yā na yáinyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ngéénū, ngéénū nduu 'uuví yā. Táámá discípulo diitu cá chéénu sa nguɛ́ɛ́ ti Pedro, ní ndaá vmnaaⁿ sa na yáinyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Can'díi sa ní n'diichi sa. Ní n'diichi sá chi 'aa dámaaⁿ tiīnūuⁿ miiⁿ snúūⁿ naati nguɛ́ɛ́ chi ndaa sa chɛɛti yáinyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simón miiⁿ ní sndaā sa chɛɛti yáinyāⁿ. Ní n'diichi sa tiīnūuⁿ miiⁿ naachi snúuⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Niicu pañuelo ch'ɛɛtɛ ca tiīiⁿ nguɛ́ɛ́ dáámá tiīnūuⁿ lino. Ndɛ́ɛ́tií nduu cánéé táámá cuaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tuu'mi ní sndaa ntúūⁿ táámá discípulo chi ndaā vmnááⁿ vmnaaⁿ ná yáinyāⁿ ní n'diichí yā ní chi'téénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tii nguɛ́ɛ́ déénu yā chi canéé nguūⁿ chí Jesús miiⁿ cuuví nduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ní nguɛɛcundií discípulos na vaacu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Naati tá María canee ta chúva'āī yáinyāⁿ. Neené ngɛɛcu tá. Ní di'cua'áí naaⁿ tá n'diichi tá chɛɛti yáinyāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ní n'diichī tá na 'uuvi ángeles ndúúcū catecaí yā cuɛ́ɛ̄. 'Áámá ángel miiⁿ vɛɛ yā cuaaⁿ tiīⁿ naachi canúúⁿ cuerpo Jesús miiⁿ ní táámá yā vɛɛ yā cuaaⁿ ndiiya. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ní caⁿ'á yā: Díí n'daataá, ¿dɛ'ɛ̄ cúúví chí ngɛɛcu di? Tuu'mí ngaⁿ'a tá: Caati candɛ́ɛ yā Señor yeⁿ'é, ní nguɛ́ɛ́ deenú tií s'néeⁿ yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Taachi caⁿ'a tá chuū, ndaacadaami tá. Ní n'diichi ta Jesús chi canée yā miiⁿ naati nguɛ́ɛ́ deenu tá chi Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tuu'mí ngaⁿ'a Jesús ní ngii yā táⁿ'ā: Díí n'daataá, ¿dɛ'ɛ̄ cúúví chí ngɛɛcu di? ¿Du'ū in'nuuⁿ di? 'Iicu n'daataá miiⁿ ní nacadíínuuⁿ tá chi 'iiⁿ'yāⁿ 'cúū ní 'iiⁿ'yāⁿ chi diiⁿ cuidado yeⁿ'ē chéēⁿ yeⁿ'e naāndā miiⁿ. Ní caⁿ'a tá: Señor, ndúúti chi dii candɛ́ɛ di 'iiⁿ'yāⁿ cuuvi di 'úú tií chi'neeⁿ dí 'iiⁿ'yāⁿ ni 'úú ní candɛɛ́ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tuu'mi ngaⁿ'a Jesús miiⁿ: María. Nguɛɛcundíí ntuūⁿ ta ní ngaⁿ'ā ta: Raboni. (Nduudu 'cūū neⁿ'e caaⁿ'maⁿ, Maestro.) ");
INSERT INTO cuxNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Tuu'mí ngaⁿ'a Jesús: Nguɛ́ɛ́ tuū'vī di 'úú caati 'āā cuɛ́ɛ́ caⁿ'á nanááⁿ Chiidá. Naati dii, cuéⁿ'e di n'diichi di hermanos yeⁿ'e yú ní caaⁿ'maⁿ di cuuvi di 'iiⁿ'yāⁿ: Caⁿ'á nanááⁿ Chiidá ní nanááⁿ Chiida yú, nanááⁿ Ndyuūs yeⁿ'é ní nanááⁿ Ndyuūs yeⁿ'é yú. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Cheⁿ'e tá María Magdalena nanááⁿ discípulos ní caⁿ'a tá chi n'diichi tá Jesús miiⁿ. Caⁿ'a tá chii tá discípulos nduudu chi Jesús miiⁿ caⁿ'a yā chii yā táⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Chii chí nguiīnū yeⁿ'e maāⁿ nguuvi domingo mííⁿ, nguuvi vmnááⁿ vmnaaⁿ yeⁿ'ē ndɛɛtɛ miiⁿ ní naachi snúūⁿ discípulos ní nduudí cheendi va'āī miiⁿ caati 'va'á yā 'iiⁿ'yāⁿ Israel s'eeⁿ. Ndaa Jesús miiⁿ. Ní canée yā naavtaⁿ'ā 'iiⁿ'yāⁿ s'eeⁿ. Ní caⁿ'a yā: Cuuvi 'diiíⁿ ndúúcū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Taachí caⁿ'a yā chuū, ní ch'iⁿ'i yā ta'á yā ndúúcū tiicuáá yā. Ní discípulos yeenú taaví yā chí n'diichí yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tuu'mí ngaⁿ'ā ntúūⁿ Jesús ngii yā 'iiⁿ'yāⁿ: Cuuvi 'diiíⁿ ndúúcū ndís'tiī. Tan'dúúcā chi dichó'o Chiidá 'úú, 'tiicá ntúūⁿ 'úú dicho'ó ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Taachí caⁿ'a yā chuū tiivineeⁿ yā 'iiⁿ'yāⁿ ní caⁿ'a yā: Cuta'á nī Espíritu N'dai yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","'Iiⁿ'yāⁿ chi ndís'tiī nadich'ɛɛcú nī nuūⁿndī yeⁿ'é yā, ní 'āā nach'ɛɛcu yeⁿ'é yā. 'Iiⁿ'yāⁿ chíí nguɛ́ɛ́ nadich'ɛɛcu nī nuuⁿndi yeⁿ'é yā, 'āā nguɛ́ɛ́ nach'ɛɛ̄cu yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Naati Tomás 'áámá discípulo chi nguuvi Dídimo chi Gemelo nguɛ́ɛ́ cúnéé sá ndúúcū saⁿ'ā s'eeⁿ taachi Jesús miiⁿ ndaá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Chíí tan'duuvi discípulos miiⁿ ngaⁿ'a yā ngii yā saⁿ'ā: N'diichí 'nū Señor miiⁿ. Saⁿ'ā miiⁿ ní ngaⁿ'a sa ngii sá 'iiⁿ'yāⁿ s'eeⁿ: 'Úú ní nguɛ́ɛ́ cu'teenú ndúúti chi nguɛ́ɛ́ n'diichí, ní nguɛ́ɛ́ tiinguú nduutita'á naachí ch'ɛɛchi clavos, ní tiinguú ta'á ná tiicuáá yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ch'iinu niiní nguuvi vɛɛtɛ ntúūⁿ discípulos snée yā chɛɛti va'āī. Mííⁿ canéé Tomás ndúúcu yā. Ní nduudí cheendi va'āī miiⁿ. Ndaa ntúūⁿ Jesús miiⁿ. Ní canúuⁿ yā naavtaⁿ'ā ní caⁿ'a yā: Cuuvi 'diiíⁿ ndúúcū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tuu'mí ní Jesús ngaⁿ'a yā ngiī yā Tomás miiⁿ: Tiingúú nduutitá'a di 'muuⁿ ní n'diichi di ta'á. Ní tiingúú ta'a di ndii 'muuⁿ ní tiingúú ta'ā di tiicuáá. Ní nguɛ́ɛ́ chí nguɛ́ɛ́ cu'téénu dí, canéé chi cu'téénu dí. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuu'mi ní Tomás miiⁿ ní caⁿ'ā sa: N'diī Señor yeⁿ'é. N'diī Dendyuūs yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tuu'mi ní ngaⁿ'a Jesús miiⁿ: Tomás, díí ní chi'téénu di tiī n'diichi di 'úú. N'daí 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'diichi yā 'úú ní chi'téénu yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ní nééné n'deēe ca señales chi ch'iⁿ'i Jesús nanááⁿ discípulos yeⁿ'é yā chi nguɛ́ɛ́ canéé nguūⁿ na libro 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Naati chuū ní canéé nguūⁿ níícú cuuvi cu'téénu di chi Jesús miiⁿ chi Cristo chi Daiya Dendyuūs. Ní chi cu'téénu di 'iiⁿ'yāⁿ ní cunee ndúúcū vida cueⁿ'e daāⁿmaⁿ cáávā chi duuchi yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Cuayiivi chi cho'ōo chuū chiináāaⁿ ntúūⁿ maaⁿ Jesús miiⁿ yeⁿ'ē discípulos yeⁿ'é yā niiⁿnuúⁿ ná yaana nuuⁿniⁿ'yáⁿ'ā chi nguuvi Tiberias ní 'túúcā chiinaáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ndidaama yā Simón Pedro ndúúcū Tomás miiⁿ chi nguuvi Dídimo chi Gemelo, ndúúcū Natanael saⁿ'ā yeⁿ'e yáāⁿ Caná yeⁿ'ē yáⁿ'āa Galilea, ndúúcū na 'úúví saⁿ'ā daiya Zebedeo ndúúcū táá na 'uuvi discípulos yeⁿ'e Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tuu'mí ngaⁿ'a Simón Pedro: Caⁿ'á tungaáⁿ 'yaācā. Tuu'mí ngaⁿ'ā 'iiⁿ'yāⁿ s'eeⁿ ngii yā saⁿ'ā: Caⁿ'ā ntúuⁿ nús'uu ndúúcu di. Ní cueⁿ'e yā ní chindáa yā na 'áámá barco. Nguiīnū miiⁿ nguɛ́ɛ́ sta'á yā mar 'áámá tī. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Chi dɛɛvɛ táámá nguuvi, Jesús ní caneé yā cuaaⁿ 'diitú yā yaana nuuⁿniⁿ'yáⁿ'ā naati discípulos nguɛ́ɛ́ túúmicadíínuuⁿ yā chi Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ní caⁿ'a yā chii yā saⁿ'ā s'eeⁿ: Ndís'tiī, saⁿ'ā n'gaiyáāⁿ ¿'áá vɛ́ɛ́ chi tungaaⁿ di chi che'e yú? Nan'guɛɛcutáⁿ'a yā yeⁿ'e yā: Nguɛ́ɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Tuu'mi ní ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: Ca'nuúⁿ nī yaāna lado ta cuaacu yeⁿ'ē barco miiⁿ ní ndaacá nī. Tuu'mi ní chi'nuúⁿ yā yaāna tií ní 'āā ntɛɛ ngii dííⁿ yā tun'dáa yā chi neené tááⁿ n'gii 'yaācā. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tuu'mi ní discípulo chi neené diya'āī 'íínu Jesús ngaⁿ'ā sa ngii sa Pedro: Señor miiⁿ 'iiⁿ'yāⁿ s'tíī. Ní Simón Pedro, taachi ch'iindiveeⁿ sa chi Jesús miiⁿ nuⁿnuúⁿ sá catecai sa ti dámaāⁿ ngáaⁿ sa, ní chindáa sa chɛɛti yaana nuūⁿnīⁿ'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ni tanduu 'uuvi discípulos ndaá yā ndúúcū barco ti nguɛ́ɛ́ dáanā yaⁿ'āī chi chinée yā yeⁿ'e yáⁿ'āa miiⁿ ti tandúú na cuūúⁿ ngɛɛcu ndiichi metros. Ngíí n'daā yā yaāna yeⁿ'e 'yaāca. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Taachí n'cheéⁿ yā yáⁿ'āa miiⁿ n'diichí yā n'giichi yáⁿ'ā. Ní 'áámá 'yaācā nduú tī nanááⁿ nduucyáⁿ'ā. Ní n'diichí yā pan. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tuu'mí ngaⁿ'a Jesús ngiī yā saⁿ'ā: Teé nī ta n'duuvi 'yaācā chí caama sta'á nī maaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Cuchɛɛ Simón Pedro ní nandɛ́ɛ sa yaāna na yáⁿ'āa miiⁿ ndiituú 'yaācā n'gɛɛtɛ́, ngii 'áámá ciento 'uuvī ngɛɛcu n'diichi 'íínú, ní yaāna miiⁿ nguɛ́ɛ́ chi teēⁿ n'dáá rá chi n'deee taaví 'yaācā. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tuu'mi Jesús ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: Cuchií nī ca'diinú nī. Mar 'áámá discípulo miiⁿ nguɛ́ɛ́ tiinguuneéⁿ yā 'iiⁿ'yāⁿ: ¿Du'u rá díí? Ti 'āā deenú yā chi Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ndaā Jesús miiⁿ ní sta'á yā pan ní ca'a yā 'iiⁿ'yāⁿ. 'Tíícá nī ntúūⁿ diíⁿ yā ndúúcū 'yaāca. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","'Āā chií 'iinu cuuvi chi n'geenaāaⁿ Jesús yeⁿ'ē discípulos yeⁿ'é yā taachí 'āā nnduuchi yā nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Taachí ch'iinu ca'diinú yā, Jesús ngaⁿ'a yā ngii yā Simón Pedro: Simón, díí daiya Jonás, ¿'áá neⁿ'e ca di 'úú, nguɛ́ɛ́ ti chuū? Tuu'mí ngaⁿ'a sa ngii sa Pedro: 'Tííca, Señor, n'diī ní déénú nī chi neⁿ'é n'dīī. Ngaⁿ'a yā ngii yā saⁿ'ā: Ca'á di 'iiti cuūchi 'lííⁿ yeⁿ'é chí che'é tī. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús ní ntiinguuneeⁿ ntuúⁿ yā yeⁿ'e saⁿ'ā naachi ndii 'uuvi cuuvi: Simón, díí daiya Jonás, ¿'áá neⁿ'e di 'úú? Nan'guɛɛcútaⁿ'a sa yēⁿ'e yā: 'Tííca, Señor, n'diī ní déénú nī chi neⁿ'é n'dīī. Tuu'mí ngaⁿ'a yā ngii yā saⁿ'ā: Ca'á dí 'iiti cuūchī yeⁿ'é chi che'é tī. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tuu'mí ngaⁿ'a yā ngii yā saⁿ'ā naachi ndii chííⁿ ndii 'íínú cuuvi: Simón, dii saⁿ'ā daiya Jonás, ¿'áá neⁿ'e di 'úú? Canéé ndaachi yiinú Pedro chí 'āā naachi ndii chííⁿ ndii 'íínú cuuvi yaa'ví yā saⁿ'ā: ¿'Áá neⁿ'e di 'úú? Tuu'mí ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ: Señor, n'diī déénú nī tanducuéⁿ'ē dendu'ū. Maaⁿ ní deenu nī chi neⁿ'é n'diī. Tuu'mí ngaⁿ'a Jesús ngii yā saⁿ'ā: Ca'á dí 'iiti cuūchi yeⁿ'é, chi che'é tī. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cuaacu nííⁿnyúⁿ cuāācū niiⁿnyuⁿ ngaⁿ'á ngií dii: Taachi saⁿ'ā 'lííⁿ dii in'nuuⁿ canúúⁿ dí catecai di ní cheⁿ'e di naachi neⁿ'e di. Naati taachí 'āā cuuvi ndiicú di ndoo tá'a di ni táámá 'iiⁿ'yāⁿ in'nuúⁿ yā catecai di ní candɛ́ɛ yā dii naachi nguɛ́ɛ́ neⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ní chuū Jesús caⁿ'a yā ní ngá'a yā chi cádiinuuⁿ sa dɛ'ɛ́ vaadī n'giī diīiⁿ honrar Dendyuūs miiⁿ. Ch'iinu caⁿ'a yā chuū, tuu'mí ngaⁿ'a yā ngiī yā Simón Pedro: Can'dáa di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nguɛɛcundíī Pedro miiⁿ n'diichi sá discípulo chi dineⁿ'é Jesús, discípulo chi cueⁿ'e sa ndúúcū Jesús. Sáⁿ'ā chi candiitínee sa 'iiⁿ'yāⁿ taachi 'āā caama chi che'e nguiinú yā. Ní 'āā caⁿ'a yā chii yā saⁿ'ā: Señor, ¿du'ū chi canéé chí diiⁿ entregar n'diī? ");
INSERT INTO cuxNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Taachi Pedro miiⁿ n'diichi sa discípulo miiⁿ tuu'mí ngaⁿ'a yā ngii yā Jesús: Señor, ¿dɛ'ɛ idiiⁿ sáⁿ'ā tíī? ");
INSERT INTO cuxNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tuu'mí ngaⁿ'ā Jesús ngii yā saⁿ'ā: Ndúúti chi 'úú chi neⁿ'é chi cunee sá ndii taachi nindaá, ¿dɛ'ɛ́ ineeⁿ di chííⁿ? Díí can'dáa di 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Caāvā nduudu 'cūū tuumicadiinuuⁿ vi'ī s'eeⁿ chi discípulo miiⁿ nguɛ́ɛ́ canéé chi 'cuūvī sa. Naati Jesús ní nguɛ́ɛ́ caⁿ'á yā chi nguɛ́ɛ́ 'cuūvī sa, naati Jesús caⁿ'a yā: Ndúúti chi 'úú chi neⁿ'é chi cunee sá ndii taachi nindaá, ¿dɛ'ɛ́ ineeⁿ di chííⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Saⁿ'á 'cūū discípulo chi ngaⁿ'ā cuaacu sa yeⁿ'ē chúū. Ní idingúuⁿ sa chuū. Ní deenu yú chi chiiⁿ chi ngaⁿ'a sa ní nduudu cuaacu ní cuaacu nííⁿnyúⁿ chi nduudu cuaacu. ");
INSERT INTO cuxNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Neené n'deēe n'dáí cosa chi diíⁿ Jesús miiⁿ. Ndúúti chi canéé nguūⁿ 'áámá 'áámá cosa 'úú nadacadíinúúⁿ chi maaⁿ rá iⁿ'yeēⁿdí 'cūū nguɛ́ɛ́ tunééⁿ libros chi canéé nguūⁿ yeⁿ'e chuū. 'Tíícā chiī.");
INSERT INTO cuxNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Dii Teófilo, taachí vmnááⁿ vmnaaⁿ dinguúⁿ yeⁿ'e di, caⁿ'á yeⁿ'e tanducuéⁿ'ē chi 'túúcā diiⁿ Jesús ní ca'cueéⁿ yā, ");
INSERT INTO cuxNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ndii nguuvi chí cunaⁿ'ā Jesús va'ai chɛɛti nguuvi. Vmnááⁿ vmnaaⁿ chi cunaⁿ'ā Jesús miiⁿ ch'íínú ca'a yā orden yeⁿ'é yā apóstoles caava Espíritu N'dai yeⁿ'e Ndyuūs. Jesús ndɛɛvɛ́ yā ní dichó'o yā apóstoles. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús ch'eenú yā chiī ní ch'īi yā. Cuayiivi taachi 'āā ch'īi yā nééné n'deee nááⁿ chííⁿ ch'iⁿ'i maáⁿ yā yeⁿ'é yā tan'dúúcā chí 'āā cuɛɛ̄ 'cuūvi yā vmnááⁿ apóstoles caati apóstoles cuuvi déénu yā chi cánduuchi ntuuⁿ yā. Canée yā ndúúcū apóstoles yeⁿ'é yā 'uuvi ngɛɛcu nguuvi ní caⁿ'a yā yeⁿ'ē chi Dendyuūs ngaⁿ'a ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Taachí ndii dáámá yā tuu'mi ní Jesús caⁿ'a ntiiⁿnyúⁿ yā apóstoles. Nguɛ́ɛ́ náⁿ'a nī yeⁿ'e yáāⁿ Jerusalén naati cunee ngíínú nī yeⁿ'ē chi caⁿ'a Chiida yú chi tée yā. Chuū chi 'āā ch'iindiveéⁿ nī yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan cuaacu nííⁿnyúⁿ chi ndúúcū nuūⁿnīⁿ chɛɛdinuūⁿnīⁿ sa naati ndís'tiī ní cuɛɛdinuūⁿniⁿ nī ndúúcū Espíritu N'dai yeⁿ'e Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tuu'mi ní saⁿ'a chi ndúúvídáámá nitiinguunéeⁿ yā 'iiⁿ'yāⁿ ní ngaⁿ'á yā: Señor Jesús, ¿'áá nadicuééⁿ ntuuⁿ nī taama saⁿ'ā Israel chí caaⁿ'maⁿ ntiiⁿnyuⁿ sa yeⁿ'e 'iiⁿ'yāⁿ Israel maaⁿ nguuví 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ní ngaⁿ'a Jesús ngiī yā 'iiⁿ'yāⁿ: Nguɛ́ɛ́ ituneeⁿ ndís'tiī chi cadíínuuⁿ nī dɛ'ɛ tiempo o dɛ'ɛ nguuvi yeⁿ'ē chuū chí Chiida yú s'neeⁿ yā na poder yeⁿ'e maáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Naati cuta'á nī poder chi diitú nī taachi 'āā ndaa Espíritu N'dai yeⁿ'e Ndyuūs vmnaaⁿ yeⁿ'é nī. Ní ndís'tiī ní caaⁿ'máⁿ nī nduudu cuaacu yeⁿ'é na yáāⁿ Jerusalén ndii nuuⁿmaⁿ yáⁿ'āa Judea, ndii yáⁿ'āa Samaria, ndii núúⁿmáⁿ iⁿ'yeēⁿdī. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ní ch'íínú caⁿ'a yā chuū taachi n'diichi saⁿ'ā s'eeⁿ Jesús cuchɛ́ɛ yā ní che'enaāⁿ sa 'iiⁿ'yāⁿ ná meēeⁿ. Ní 'āā ntɛ́ɛ́ snaaⁿ saⁿ'a s'eeⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ní saⁿ'ā s'eeⁿ ní n'gíínú sá nanguuvi. Taachí 'āā cuchɛ́ɛ Jesús, n'diichi sa na 'uuvi saⁿ'ā chi ángel chineē ndúúcu sa ndúúcū catecai cuɛ́ɛ̄ sa. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","'Úuvi 'iiⁿ'yāⁿ miiⁿ ní ngaⁿ'a yā ngii yā saⁿ'ā s'eeⁿ: Ndís'tiī saⁿ'a yeⁿ'e yáⁿ'āa Galilea, ¿dɛ'ɛ n'gíínú nī nanguuvi? Maāⁿ Jesús chí cunaⁿ'a yā yeⁿ'e ndís'tiī nanguuvi 'tíícā ndaa túuⁿ yā tan'dúúcā chí n'diichí nī 'iiⁿ'yāⁿ cuinaⁿ'á yā nanguuvi. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Can'dáa yā ná yiīcū 'lííⁿ chi nguuvi Olivos chi canéé niiⁿnuⁿ ná yáāⁿ Jerusalén ní ndáá yā na yáāⁿ Jerusalén. Distancia 'cūū chí ngaⁿ'a ley chi cuuvi caacá yā sábado nguuvi chi ntaavi'tuunuúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ndaá yā na yáāⁿ miiⁿ. Chɛɛ́ yā na cuarto yaacu naachi cānee Pedro, ndúúcū Jacobo, ndúúcū Juan, ndúúcū Andrés, ndúúcū Felipe, ndúúcū Tomás, ndúúcū Bartolomé, ndúúcū Mateo, ndúúcū Jacobo dáiyā saⁿ'ā chi nguuvi Alfeo, ndúúcū Simón Zelote, ndúúcū Judas chi 'diīnū Jacobo. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nducyáácá 'iiⁿ'yāⁿ s'eeⁿ ndúúcū n'daata s'eeⁿ ndúúcū María chi chɛɛcu Jesús ndúúcu 'díínu Jesús nduuvidaamá yā ní 'áámá vaādī cadiinúúⁿ yeⁿ'é yā ní ngaⁿ'angua'á yā ní di'cuiitú yā Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","'Iiⁿ'yāⁿ chi nduuvídaama miiⁿ ngíi yā tan'dúúcā 'áámá ciento canee ndiicú yā. Hora miiⁿ nacueéⁿ Pedro naavtaⁿ'a yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ chi i'téénu yā Cristo ní caⁿ'a sa: ");
INSERT INTO cuxNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ndís'tiī hermanos, canee cuuⁿmiⁿ chí cuuvi cuaacu Escritura chí Espíritu N'dai yeⁿ'e Ndyuūs caⁿ'a David cuaaⁿ vmnaāⁿ ní David miiⁿ dinguúⁿ yā yeⁿ'e Judas. Judas miiⁿ ch'iⁿ'i sá du'u chí Jesús. Maaⁿ níícú chiī chita'á yā Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas miiⁿ ní ndúúcū nús'uu ní diiⁿ sa ntiiⁿnyuⁿ ndúúcū nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Sáⁿ'a miiⁿ ní cái sa 'áámá tááⁿ yáⁿ'āa ndúúcū tuūmī yeⁿ'ē nuuⁿndi yeⁿ'ē sa. Ní chin'daā sa dácaā n'díi sa ní nda'ai naavtaⁿ'a cuerpo yeⁿ'ē sa ní tanducueⁿ'ē ngɛɛti sa ch'iinu cān'daa. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nducyáácá 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Jerusalén chicadíínuuⁿ yā chuū. Ní yáⁿ'āa miiⁿ ní 'tíícā canee chi duuchi Acéldama davaacu yeⁿ'é yā chí neⁿ'e caaⁿ'maⁿ campo yeⁿ'ē yuūúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ti canéé nguūⁿ na libro yeⁿ'e Ndyuūs naachi chi duuchi Salmos: Naachí navaacu sa mííⁿ nduuvi díyáaí. Ndíí nguɛ́ɛ́ 'iiⁿ'yāⁿ chi 'cuɛɛtinée yā miiⁿ. Níícú canéé nguūⁿ: Cuta'a taamá yā ntiiⁿnyuⁿ yeⁿ'e saⁿ'ā ndíí tiīiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","'Iiⁿ'yāⁿ sáⁿ'ā miiⁿya canee cuuⁿmiⁿ chi canéé yā ndúúcu 'nū nducueⁿ'e tiempo chi Señor Jesús canéé yā ndúúcu 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","'Iiⁿ'yāⁿ miiⁿ canee cuuⁿmiⁿ chi canéé yā ndúúcu 'nū taachi tucá'a yā chɛɛdinuūⁿnīⁿ Juan ndíí nguuvi chi Jesús cunaⁿ'á yā cuaaⁿ 'niiⁿnuⁿ nanguuvi. 'Túúcā canee cuuⁿmiⁿ chi 'áámá yā caaⁿ'maⁿ yā ndúúcū nús'uu nduudu cuaacu yeⁿ'ē chí nduuchi Jesús ngaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ní 'neeⁿ ndutá'a yā ná 'uuvi 'iiⁿ'yāⁿ. 'Áámá saⁿ'ā miiⁿ ní nguuvi sa José Barsabás chi nguuvi Justo ndúúcū taama saⁿ'ā miiⁿ chi nguuvi sa Matías. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ní caⁿ'angua'á yā ní caⁿ'a yā: N'diī, Señor Ndyuūs, chi n'diichi nī staava yeⁿ'ē nducyáácá yā, 'cuuⁿ'míⁿ nī nús'uu 'áámá chɛ́ɛ́ sáⁿ'ā s'ūuⁿ chí 'āā ndɛɛvɛ́ nī. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Níícú cunee ndúúcū sa ntiiⁿnyuⁿ ndúúcū apóstoles lado yeⁿ'e Judas. Ní diiⁿ sa ntiiⁿnyuⁿ yeⁿ'ē Judas ntiiⁿnyuⁿ chi nguɛ́ɛ́ diīⁿ sa cumplir cucáávā nuuⁿndi yeⁿ'ē sa. 'Tíícā ní Judas cúnaⁿ'a sa na lugar naachí tuneeⁿ saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Níícú dinguúⁿ yā na 'úúví caaca ndúúcū 'uuvī chi nguuví 'iiⁿ'yāⁿ, José miiⁿ ndúúcū Matías. Ní tun'dáá yā 'áámá chi nguuvi Matías ní Matías miiⁿ tuneeⁿ. Ní nduuvidaama sa chíí ndicháámá apóstoles chi 'iiⁿ'yāⁿ chi dichó'ó Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nducyáácá yā nduuvidaamá yā taachi ndaā nguuvi yeⁿ'e Pentecostés chi 'viicu yeⁿ'e cosecha. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tuu'mí nūuⁿ tucá'ā ch'ɛ́ɛ̄cu ruuⁿ cuchiī nanguuvi tan'dúúcā 'áámá 'yúúné tááⁿ chí ngéenū. Ch'iindiveéⁿ yā ruūⁿ miiⁿ chí chíítú va'āī naachi snée yā miiⁿ. Ní 'iiⁿ'yāⁿ s'uúⁿ vɛɛtɛ́ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ní che'enaāáⁿ n'deee n'dai cosas tan'dúúcā ch'ííyā yeⁿ'e yaⁿ'ā n'gaiyáā. Ní ch'ɛɛtɛ ndúūu vmnaaⁿ yeⁿ'ē 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Níícú canée yā nducyááca yā chiitu ndúúcū Espíritu N'dai yeⁿ'e Ndyuūs. Níícú Espíritu N'dai miiⁿ diíⁿ yā chi tucá'a yā caⁿ'a yā táámá naaⁿ davaacu s'eeⁿ tan'dúúcā nduudu chí ca'ā Espíritu N'dai miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tuu'mi ní na yáāⁿ Jerusalén ch'ɛɛtinéé 'iiⁿ'yāⁿ yeⁿ'e Israel chi saⁿ'ā chí i'téénú Dendyuūs yeⁿ'ē nducyaaca naciones yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Taachí ndaā chí 'ɛɛcu ruuⁿ mííⁿ nduuvidaamá n'deee n'dáí yā ní chidáanā yeⁿ'é yā ti ca'áámá ca'áámá yā ch'iindiveéⁿ yā chi ngaⁿ'ā davaacu yeⁿ'e maáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nducyáácá yā 'áámá cheⁿ'e yiinu yā ní 'áámá nínacadíínuuⁿ yā, ní ngaⁿ'á yā: N'diichí nī, ¿'áá nguɛ́ɛ́ yeⁿ'ē yáⁿ'āa Galilea nducyaaca saⁿ'ā s'eeⁿ chí ngaⁿ'ā sa? ");
INSERT INTO cuxNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿'Taacā chííⁿ n'giindiveeⁿ yú nduudu yeⁿ'ē yú tan'dúúcā naachí ch'iindiyaāⁿ yú? ");
INSERT INTO cuxNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Vɛ́ɛ́ 'iiⁿ'yāⁿ yeⁿ'e país Partia, 'iiⁿ'yāⁿ país Media, país Elam, ndúúcū 'iiⁿ'yāⁿ chi snée yā na país Mesopotamia, 'iiⁿ'yāⁿ yáⁿ'āa Judea, yáⁿ'āa Capadocia, yáⁿ'āa Ponto, yáⁿ'āa Asia, ");
INSERT INTO cuxNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","'iiⁿ'yāⁿ yáⁿ'āa Frigia ndúúcū país Panfilia, país Egipto, yáⁿ'āa s'eeⁿ yeⁿ'e Africa chi canee cuaāⁿ 'diituú 'áámá lado cuaaⁿ yeⁿ'ē yáⁿ'āa Cirene, ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ Roma chí snée yā miiⁿ. Tan'dúúcā ntúūⁿ 'iiⁿ'yāⁿ Israel s'eeⁿ 'tiicá ntúūⁿ 'iiⁿ'yāⁿ chi 'āā maaⁿ 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Níícú 'iiⁿ'yāⁿ isla Creta, ndúúcū 'iiⁿ'yāⁿ país Arabia snée yā miiⁿ. Nducyaaca yú n'giindiveeⁿ yú davaacu yeⁿ'e yú. Ngaⁿ'á yā yeⁿ'ē chi ch'ɛɛtɛ taavi cá yeⁿ'é Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nducyaacá yā ní 'áámá cheⁿ'é yeⁿ'é yā, ní n̄diiiⁿ 'uuví yā vaanicadiinuuⁿ yeⁿ'é yā. Ní ngaⁿ'á yā 'aamá yā ndúúcū taamá yā: ¿'Dɛ́'ɛ́ neⁿ'e caaⁿ'maⁿ chuū? ");
INSERT INTO cuxNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Tanáⁿ'a yā ní sta'á yā tan'dúúcā 'áámá duuchi ní ngaⁿ'a yā: 'Āā chi'í yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tuu'mi ní Pedro mííⁿ cheendii sa ndúúcū ndiicháámá yā ní caⁿ'a yuudu sá ní ngaⁿ'a sā ngii sa 'iiⁿ'yāⁿ: Ndís'tiī saⁿ'ā s'eeⁿ yeⁿ'e Israel ndúúcū nducyaaca chi snée yā na yáāⁿ Jerusalén. Ní cánéé chi 'cuuⁿ'míⁿ ndís'tiī ní tumicadíínuuⁿ nī chuū. Ní 'caandiveéⁿ nī nduudu yeⁿ'ē 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sáⁿ'ā s'uuⁿ nguɛ́ɛ́ cúú'ví sá tan'dúúcā chí nadacádiinúúⁿ ndís'tiī caati maaⁿ ní n'gɛɛcu nuuⁿ 'yáⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Chuū canéé nguūⁿ na libro yeⁿ'e Ndyuūs naachi caⁿ'a profeta Joel chi ngaⁿ'a chi cuchiī: ");
INSERT INTO cuxNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ndyuūs ní caⁿ'a yā taachi ndaā nguuvi cuayiivi chí cuchiī, chi teé Espíritu yeⁿ'é vmnaaⁿ nducyaacá 'iiⁿ'yāⁿ. Ní daiyá nī saⁿ'ā ndúúcū daiyá nī n'daataá caaⁿ'máⁿ yā nduudu yeⁿ'é. Ní saⁿ'ā n'gaiyáā n'deēe nááⁿ chi 'cuuⁿ'míⁿnáāaⁿ yeⁿ'ē sa. Ní 'iiⁿ'yāⁿ ndiicúū yeⁿ'é nī n'deee nááⁿ chi 'cuíínu yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Tíícā yeⁿ'e nguuvi miiⁿ, 'úú teé Espíritu yeⁿ'é vmnaaⁿ yeⁿ'e saⁿ'ā chí dichíí'vɛ̄ 'úú ndúúcū n'daataa chí dichíí'vɛ̄ 'úú. Ní caaⁿ'maⁿ yā nduudu yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Níícú 'cuuⁿ'míⁿ vaadi n'giinu yeⁿ'é cuaaⁿ 'niiⁿnuⁿ nanguuvi, ndúúcū señales yeⁿ'é cuaaⁿ ndiiyā na yáⁿ'āa, ndúúcū yuūúⁿ, ndúúcū yaⁿ'ā, ndúúcū yaaⁿ'mi, ");
INSERT INTO cuxNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'iicu 'yáⁿ'ā miiⁿ nduuvi maāiⁿ. Níícú 'iiyū mííⁿ ndúúví yuūúⁿ, taachi 'aa cuɛ́ɛ́ ndaa nguuví yeⁿ'ē Señor. Nguuvi miiⁿ ch'ɛɛtɛ ní chi 'cuuⁿ'miⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Níícú nducyaaca 'iiⁿ'yāⁿ chi caaca: Señor 'iivú, ní Ndyuūs nanguáⁿ'ai yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ndís'tiī saⁿ'ā yeⁿ'e 'iiⁿ'yāⁿ Israel, 'caandiveéⁿ nī nduudu 'cūū: Jesús yeⁿ'e yáāⁿ Nazaret ní 'áámá saⁿ'ā chi Dendyuūs n'diichí yā chi n'daācā sa nguaaⁿ ndís'tiī. Ní Dendyuūs diíⁿ yā vaadī n'gíínú ndúúcū señales ndúúcū ntiiⁿnyuⁿ ch'ɛɛtɛ cáávā saⁿ'ā miiⁿ nguaaⁿ ndís'tiī tan'dúúcā ndís'tiī deenú nī. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Sáⁿ'a 'cūū Ndyuūs ní ca'a yā saⁿ'ā cáávā voluntad yeⁿ'e maaⁿ yā tan'dúúcā chi déénú n'dai yā ndíí vmnaaⁿ. Ndís'tiī ní chiicá nī chi sta'á yā sáⁿ'a 'cūū chi'neéⁿnga'á yā saⁿ'ā. Ní ch'iiⁿ'núⁿ yā saⁿ'ā cucáávā 'iiⁿ'yāⁿ s'eeⁿ chí nguɛ́ɛ́ n'daacā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sáⁿ'a 'cūū Ndyuūs nadacuéeⁿ yā saⁿ'ā yeⁿ'ē nguaaⁿ tináⁿ'ā. Sáⁿ'a 'cūū nguɛ́ɛ́ cuuví cunée sa nguaaⁿ tináⁿ'ā. Cáávā chuū ní Dendyuūs nadacuéeⁿ yā saⁿ'ā nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David caⁿ'a sá yeⁿ'e sáⁿ'a 'cūū: Ti cueⁿ'e daāⁿmaⁿ inaáⁿ Señor 'iivú Ndyuūs vmnááⁿ yeⁿ'é. Ní canée yā lado yeⁿ'e honor, ní mar 'aamá 'iiⁿ'yāⁿ nguɛ́ɛ́ cuuví di'vaachí yā 'úú. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Cáávā chuū caaⁿ'máⁿ ndúúcū 'áámá vaadī yeenú yeⁿ'ē staava yeⁿ'é ndúúcū vaadī yeenú yeⁿ'e cheendí. 'Iicu cuerpo yeⁿ'é 'intaavi'tuunúūuⁿ ndúúcū chi canee ngiinú yeⁿ'é Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ti nguɛ́ɛ́ cu'néeⁿ nī alma yeⁿ'é na lugar Hades chi lugar yeⁿ'ē alma. Ní nguɛ́ɛ́ 'cuaaⁿ nī 'úú chi daiyá nī 'úú chi 'iiⁿ'yāⁿ chi nguɛ́ɛ́ nuuⁿndi 'úú chí choō cuerpo yeⁿ'é. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Diíⁿ nī chí n'diichí chí yúúní cuaacu yeⁿ'e vida. N'diī dích'ɛɛtɛ́ nī vaadi yeenú 'úú ti caneé nī nduucú. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ndís'tiī vi'í, cuuví caaⁿ'maⁿ cuaacú ndís'tiī yeⁿ'e chiida yú David. Ch'īi yā ní ních'ɛɛchí yā na yáinyāⁿ. Ní yáinyāⁿ yeⁿ'é yā canee ndúúcu yú ndii nguuví 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Saⁿ'a miiⁿ saⁿ'ā profeta miiⁿ chi ngaⁿ'a nduudu yeⁿ'e Dendyuūs. Ní deenū sa chi Ndyuūs ngaⁿ'a cuaacú yā ndúúcū nduudu cuaacu chi 'áámá 'iiⁿ'yāⁿ chí cuchiī na ndaata yeⁿ'é yā. Ní Dendyuūs nadacuéeⁿ yā Cristo chi 'cuundi yā na trono yeⁿ'é yā ni caaⁿ'maⁿ ntiiⁿnyúⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David déénu sa chi cuaaⁿ vmnaaⁿ ní caⁿ'a sa chi Cristo nanduuchí yā yeⁿ'ē nguaaⁿ tináⁿ'ā. Nguɛ́ɛ́ cunee alma yeⁿ'é yā na lugar Hades chi lugar yeⁿ'ē alma ní nguɛ́ɛ́ yúutɛ yeⁿ'é yā chí choo. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ndyuūs nadin'duuchí yā Jesús yeⁿ'e nguaaⁿ tináⁿ'ā ní cáávā 'iiⁿ'yāⁿ miiⁿ nducyaaca 'nū cuuví caaⁿ'maⁿ 'nū nduudu cuaacu yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Tíícā Jesús canée yā ná yaacu na lado yeⁿ'e honor yeⁿ'e Dendyuūs ní diíⁿ yā recibir yeⁿ'ē Chiidá yā miiⁿ yeⁿ'e chi caⁿ'ā Chiidá yā chí ca'a yā Espíritu N'dai. Chuū ní Jesús teé yā ndís'tiī ní inaáⁿ nī ní n'giindiveéⁿ nī. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ti David miiⁿ nguɛ́ɛ́ cuchɛɛ sa nanguuvi; ti maāⁿ sa ngaⁿ'a sa: Caⁿ'a Señor chií yā Señor yeⁿ'é: 'Cuundi dí lado yeⁿ'e honor, ");
INSERT INTO cuxNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ndíí cu'neéⁿ 'iiⁿ'yāⁿ chi táaⁿ yā yeⁿ'e di chi tun'dáá n'dai di ndúúcu yā ní cunée yā na poder yeⁿ'ē di. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Cuaacu niiⁿnyuⁿ cádiinuuⁿ nducyáácá 'iiⁿ'yāⁿ yeⁿ'e ndaata Israel chí Jesús chi ndís'tiī ní chi'néeⁿnga'á nī 'iiⁿ'yāⁿ, Ndyuūs diíⁿ yā chi Señor ní Cristo yā ní 'iiⁿ'yāⁿ ch'ɛɛtɛ taavi. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Taachí ch'iindiveéⁿ yā chuū ní nééné ya'ai chiī staava yeⁿ'é yā. Ní caⁿ'a yā chii yā 'iiⁿ'yāⁿ s'eeⁿ Pedro ndúúcū taa na 'uuvi apóstoles: Ndís'tiī saⁿ'ā vi'í, ¿dɛ'ɛ̄ diíⁿ 'nū? ");
INSERT INTO cuxNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro miiⁿ ngaⁿ'a sa ngii sa 'iiⁿ'yāⁿ s'eeⁿ: Nguɛɛcúndií nī yeⁿ'ē nuuⁿndi yeⁿ'é nī ní cuɛɛdinúuⁿnīⁿ ca'áámá ca'áámá nī cucáávā chi chi duuchi Jesús. Níícú Ndyuūs nadach'ɛɛcú yā nuuⁿndí yeⁿ'e ndís'tiī; ni cuta'á nī chi tee Ndyuūs miiⁿ chi Espíritu N'dai yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Caati Espíritu N'dai caⁿ'ā Chiida yú chi teé yā cucáávā ndís'tiī ndúúcū daiya nī ní cucáávā nducyaaca 'iiⁿ'yāⁿ chi snée yā yaⁿ'ai, ni cucááva nducyaaca 'iiⁿ'yāⁿ chi 'cuaī Señor 'iivú Ndyuūs yeⁿ'ē yú 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro miiⁿ ngaⁿ'á yā nduudu cuaacu nanááⁿ na 'uuví yā ndúúcū n'deee taaví nduudu ní ngaⁿ'a diitú yā 'iiⁿ'yāⁿ s'eeⁿ ní ngaⁿ'a yā: Nanguáⁿ'ai nī yeⁿ'e 'iiⁿ'yāⁿ chi nguɛ́ɛ́ n'daacā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","'Tíícā 'iiⁿ'yāⁿ chi 'cuúⁿ yā nduudu yēⁿ'e yā chɛɛdinúūⁿniⁿ yā, ní chi 'yaáⁿ yā nguuvi miiⁿ tan'dúúcā 'iiⁿnūⁿ mil 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ní 'áámá caneé yā ndúúcū chí chi'cueeⁿ apóstoles ní nduuvidaama yā ní n'dee yā pan ní caⁿ'angua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ní vaadī 'va'a níndaā nanááⁿ nducyaaca yā. Nééné n'deēe vaadī n'giinu ndúúcū señales chí diíⁿ apóstoles chí dichó'ó Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ní nducyaacá yā chi i'téénu yā nduuvidaama yā. Ní nducuéⁿ'ē chi vɛ́ɛ́ yeⁿ'é yā canéé yeⁿ'ē nducyaaca yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ní n'diicuí yā yáⁿ'āa yeⁿ'é yā ndúúcū chi vɛɛ yeⁿ'e yā ní nga'a yā 'tɛ́ɛ́ 'tɛ́ɛ́ nducyáácá 'iiⁿ'yāⁿ tuunu tuunu cá chi ngi'vaachí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Áámá ninduuvidaamá yā na yáacu nguuvi nguuvi. Ní ninduuvidaamá yā ní yeenú taaví yā staava yeⁿ'é yā ndúúcū 'áámá vaanicadiinúúⁿ yeⁿ'e yā taachi n'deé yā pan ní taachí che'é yā na vaacú yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'Iiⁿ'yāⁿ miiⁿ dich'ɛɛtɛ́ yā Dendyuūs. Ní vɛ́ɛ́ favor yeⁿ'é yā ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ. Ní Señor Ndyuūs nguuvi nguuvi idi'yáaⁿ yā 'iiⁿ'yāⁿ chí i'teenú yā 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro mííⁿ ndúúcū Juan dáámá cueⁿ'e yā cuchɛɛ yā na yaacū templo cuaaⁿ nan'gɛɛcú 'ííⁿnúⁿ chiīnu, hora chi caⁿ'angua'á yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ní ná'a yā ndɛ́ɛ yā 'áámá saⁿ'ā chi ndii dúúvá sá ndíí chɛɛti chɛɛcu sa. Saⁿ'ā miiⁿ ni ngúúví ngúúví i'néeⁿ yā saⁿ'ā cheendi yaācū chi nguuvi Hermosa o N'dɛɛvɛɛ́. Saⁿ'a miiⁿ ngiica sa limosna 'iiⁿ'yāⁿ chi ngeⁿ'e yaācū templo. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Sáⁿ'a 'cūū taachi n'diīchī sa Pedro ndúúcū Juan chí chindáa yā yáacū ch'ɛɛtɛ, chiica sá limosna 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro ndúúcū Juan ch'ɛɛtinée yā ch'íínu yā saⁿ'ā miiⁿ, ní caⁿ'á yā chii yā saⁿ'ā: Cun'diichi dí nús'uu. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Tuu'mi ní saⁿ'ā miiⁿ ch'íínu sa 'iiⁿ'yāⁿ s'eeⁿ chi canee ngíínu sá dɛ'ɛ̄ ca'á yā saⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Naati Pedro miiⁿ caⁿ'á yā: Nguɛ́ɛ́ tuūmī 'dííⁿnguɛɛ yeⁿ'é ni nguɛ́ɛ́ 'diiⁿnguāaⁿ yeⁿ'é chí canéé yeⁿ'é chi teé dii, cucáávā Jesucristo yeⁿ'e yáāⁿ Nazaret miiⁿ, nacuééⁿ dī ní caaca di. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ní sta'á yā ta'ā sa lado tá cuaācū sa ní nadacuéeⁿ yā saⁿ'ā. Hora mííⁿ nūuⁿ ní ndaā dítiīnú ca'a sa ndúúcū 'ííní ruundi ca'a sa. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ní caī yaācú sa, ní chééndii sá, ní chiīcā sa. Sndáa sa ndúúcū Pedro ndúúcū Juan chɛɛti yaācū templo miiⁿ. Ngiica sá ní ngáí yaācú sa ní i'téénu sá Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Núúⁿmáⁿ yáāⁿ 'iiⁿ'yāⁿ n'diichí yā saⁿ'ā chi ngiica sa ní i'téénu sa Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ní nntíínaaⁿ yā chi saⁿ'ā miiⁿ chi saⁿ'ā chi n'giīndī cheendi yaācū templo chi nguuvi Hermosa, ní ngiica sa limosnas. Ní cheⁿ'e yiinu yā ní 'iiⁿ'yāⁿ s'eeⁿ dii'yá yā chiī chi 'tíícā nanduuvá yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Saⁿ'ā chí nguɛɛ ngiica ní chi nduūvā yeⁿ'ē sa sta'ā sa Pedro ndúúcū Juan ní nuuⁿmaⁿ yáaⁿ yā ngeⁿ'e yiinú yā 'iiⁿ'yāⁿ. Ní cueⁿ'é yā na corredor chi nguuvi Salomón chi 'áámá corredor yeⁿ'e yaācū ch'ɛɛtɛ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Taachi Pedro n'diichi sa 'iiⁿ'yāⁿ s'uúⁿ Pedro nan'guɛɛcútáⁿ'a sa yeⁿ'é 'iiⁿ'yāⁿ yáāⁿ: Ndís'tiī saⁿ'ā yeⁿ'e Israel, ¿dɛ'ɛ̄ cuuvi chi ngeⁿ'e yiinú nī yeⁿ'e chúū? O ¿dɛ'ɛ cuuví chi n'gíínu nī nús'uū? ¿'Áá caava chi diitú 'nū o chí n'dáí 'nū chi diíⁿ 'nū chi ngíícá sáⁿ'a 'cūū? ");
INSERT INTO cuxNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ndyuūs yeⁿ'e saⁿ'ā s'eeⁿ, Abraham ndúúcū Isaac ndúúcū Jacob ní Ndyuūs yeⁿ'ē chiida yú, Ndyuūs diíⁿ yā honrar Daiyá yā Jesús. Ndís'tiī ní ca'á nī 'iiⁿ'yāⁿ miiⁿ ní cheeⁿdiitú nī nanááⁿ Pilato miiⁿ taachi Pilato neⁿ'é yā ca'á yā libertad yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ndís'tiī ní cheeⁿdiitú nī chi Jesús chí n'daaca yā, Jesús chí n'dai taaví yā, ní chiica nī chi canéé libre 'áámá saⁿ'ā chi 'nííⁿ'núⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ní ch'iiⁿ'nuⁿ nī Jesús chi cā'a yā vida yeⁿ'e 'iiⁿ'yāⁿ. 'Iiⁿ'yāⁿ miiⁿ ní nadin'dūūchí Dendyuūs 'iiⁿ'yāⁿ yeⁿ'ē nguaaⁿ tináⁿ'ā ní nús'uú caaⁿ'maⁿ cuaacú 'nū yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sáⁿ'a 'cūū chi nguɛɛ ngiica chi ndís'tiī inaáⁿ nī ní n'diichí nī, sáⁿ'a 'cūū ní ditiinú sa cucáávā chi i'téénu sa Jesús. Ndúúcū vaadī i'téénú chi ca'a Jesús, sáⁿ'a 'cūū 'āā nduuvī n'dáí sá tan'dúúcā chi n'diichī nducyaacá ndis'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Naati maaⁿ ní, ndís'tiī vi'í, deenú chí ndís'tiī dīiⁿ nī chuū cucáávā chi nguɛɛ déénu nī tan'dúúcā chi díīⁿ 'iiⁿ'yāⁿ s'eeⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","'Tíícā Dendyuūs ní snuūⁿ ca'a chi caⁿ'a yā vmnááⁿ vmnaaⁿ cáávā cheendi nducyaaca profetas chi n'dai chí caⁿ'a nduudu yeⁿ'e Dendyuūs yeⁿ'e chi Cristo Daiyá yā. Ní cánéé chí Cristo ní 'cueenú yā cuuvi. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'Tíícā maaⁿ ní nacadíínuuⁿ nī ní ndaacadáámí nī yeⁿ'ē nuuⁿndi yeⁿ'é nī ní cu'téénú nī. Níícú Ndyuūs nadivíi yā nuuⁿndi yeⁿ'é nī. Níícú ndaa tiempo chí ntaavi'tuunúúⁿ nī nanááⁿ Señor 'iivú Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ndyuūs ní ndɛɛvɛ́ yā Jesucristo ndíí vmnaaⁿ níícú caⁿ'a yā chi dichó'o yā Jesucristo tan'dúúcā chi caⁿ'a yā ndíí cuááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cuaacu nííⁿnyúⁿ chi 'iiⁿ'yāⁿ miiⁿ canee cúúⁿmíⁿ chi canéé yā va'āī chɛɛti nguuvi ndíí taachi ndáá nguuvi chi Dendyuūs diíⁿ yā taanduvɛ́ɛ́ dendú'ū chi Dendyuūs caⁿ'á yā vmnááⁿ vmnaaⁿ cucáávā cheendi profetas yeⁿ'e yā. Profetas chi n'dai caⁿ'a yā chi cuchiī ndíí cuááⁿ vmnaaⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Caati Moisés miiⁿ ní caⁿ'a yā chii yā chiida yú s'eeⁿ ndíí vmnaaⁿ: Señor Ndyuūs yeⁿ'ē yú nadacuéeⁿ yā 'áámá profeta nguaaⁿ 'iiⁿ'yāⁿ yeⁿ'ē yú tan'dúúcā 'úú. Ní yeⁿ'é 'iiⁿ'yāⁿ miiⁿ 'caandiveéⁿ nī yeⁿ'ē taanduvɛ́ɛ́ dendu'ū chi caaⁿ'maⁿ yā ndúúcū ndís'tiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ní cuuví chí nducyaaca yā chi nguɛ́ɛ́ 'caandiveéⁿ yā yeⁿ'e 'iiⁿ'yāⁿ profeta miiⁿ canéé chí can'dáa yā yeⁿ'ē nguaaⁿ 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tanducuéⁿ'e profetas ní ndii tiempo yeⁿ'e Samuel ndii tiempo chi cuchíī 'yaaⁿ n'dáí yā ní caⁿ'a yā, ní 'āā caⁿ'a ntúuⁿ yā yeⁿ'ē nguuvi 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ndís'tiī daiya profetas chí caⁿ'a nduudu yeⁿ'é Dendyuūs ní yeⁿ'e compromiso chí Dendyuūs caⁿ'a cuaacú yā ndúúcū chiida yú s'eeⁿ ní caⁿ'a yā chii yā Abraham: Ná ndaatá yeⁿ'ē di cuchiī 'áámá saⁿ'ā cuayiivi, caati sáⁿ'ā miiⁿ cúúví di'viicú sa tanducuéⁿ'ē 'iiⁿ'yāⁿ yeⁿ'e iⁿ'yeeⁿdí 'cūū. ");
INSERT INTO cuxNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ndyuūs nadicuéeⁿ yā Daiyá yā vmnááⁿ vmnaaⁿ cáávā ndís'tiī. Ní dichó'ó yā 'iiⁿ'yāⁿ miiⁿ chí di'viīcú yā ndís'tiī chi 'áámá 'áámá nī ndaacadaamí nī yeⁿ'ē nuuⁿndí yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Taachi Pedro ndúúcū Juan yaa'ví yā nanaaⁿ 'iiⁿ'yāⁿ miiⁿ chí nduuvidáámá yā tuu'mí ndaá nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ chiiduú s'eeⁿ yeⁿ'é Israel ndúúcū soldados ndíí tiīiⁿ yeⁿ'ē soldados chi diiⁿ cuidado yeⁿ'e yáacū templo yeⁿ'e 'iiⁿ'yāⁿ Israel ndúúcū 'ii'yāⁿ saduceos chi nguɛ́ɛ́ i'teenú yā chi nnduuchí 'iiⁿ'yāⁿ yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","'Iiⁿ'yāⁿ s'eeⁿ miiⁿ ya'āī chíī yeⁿ'e staava yeⁿ'é yā taachi ch'iindiveéⁿ yā chííⁿ chi Pedro ndúúcū Juan caⁿ'a yā chí chi'cuéeⁿ yā 'iiⁿ'yāⁿ yáāⁿ miiⁿ. Ní caⁿ'a yā chí Dendyuūs nadacuéeⁿ yā 'iiⁿ'yāⁿ s'eeⁿ yeⁿ'e nguaaⁿ tináⁿ'ā cucáávā Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ch'íinū nguuvi mííⁿ ní 'iiⁿ'yāⁿ s'eeⁿ chita'á yā Pedro ndúúcū Juan ní chinuúⁿ yā saⁿ'a s'eeⁿ vácūū ndíí chidɛɛvɛ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Naati nguaaⁿ tanducuéⁿ'e yā neené 'yaaⁿ yā chi ch'iindiveéⁿ yā ní n'deee taaví yā chi chi'teenú yā, ní 'iiⁿ'yāⁿ s'eeⁿ ní ngii yā taanduu nyuⁿ'u mil. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chidɛɛvɛ táámá nguuvi miiⁿ nduuvidaamá na yáāⁿ Jerusalén 'iiⁿ'yāⁿ s'eeⁿ chí ngaⁿ'ā ntiiⁿnyuⁿ ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'ē yáacū ndúúcū maestros yeⁿ'e ley, ");
INSERT INTO cuxNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ndúúcū chiiduú ch'ɛɛtɛ cá yeⁿ'ē Israel chi nguuvī Anás, ndúúcū Caifás, ndúúcū Juan, ndúúcū Alejandro, ndúúcū nducyáácá 'iiⁿ'yāⁿ yeⁿ'e familia chiiduú ch'ɛɛtɛ cá yeⁿ'e Israel. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ní ch'iinú yā Juan ndúúcū Pedro naavtaⁿ'ā, ní ntiinguunééⁿ yā saⁿ'ā s'eeⁿ: ¿Dɛ'ɛ̄ poder, o dɛ'ɛ̄ duuchí 'iiⁿ'yāⁿ chi teē poder chi diíⁿ nī chuū? ");
INSERT INTO cuxNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tuu'mi ní Pedro miiⁿ ní diituú Espíritu N'dai yeⁿ'e Ndyuūs 'iiⁿ'yāⁿ caⁿ'a yā chii yā saⁿ'a: Ndís'tiī 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē yáacū yeⁿ'ē 'iiⁿ'yāⁿ Israel; ");
INSERT INTO cuxNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ndúúti chi ndís'tiī maaⁿ ní diíⁿ nī juzgar nús'uu yeⁿ'e saⁿ'ā chi ngiītā miiⁿ ní n'daacá 'nū ndúúcū sa, ní sáⁿ'a 'cūū miiⁿ nanduuva yeⁿ'ē sa, ");
INSERT INTO cuxNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","cadíínuuⁿ nducyaaca ndís'tiī ndúúcū nducyáácá 'iiⁿ'yāⁿ yeⁿ'ē Israel miiⁿ chi sáⁿ'a 'cūū chi canéé sá ndúúcu yú nanduuvá yeⁿ'ē sa cucáávā Jesucristo yeⁿ'ē yáāⁿ Nazaret. 'Iiⁿ'yāⁿ miiⁿ ndís'tiī ní s'nééⁿnga'á nī 'iiⁿ'yāⁿ ní Dendyuūs nadicuéeⁿ yā 'iiⁿ'yāⁿ yeⁿ'e nguaaⁿ tináⁿ'ā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús tan'dúúcā tuūu 'cúū chi ndís'tiī 'iiⁿ'yāⁿ chi din'dáī va'ai ní nguɛ́ɛ́ canee yiinú nī, naati maaⁿ ní Ndyuūs chi cu'néeⁿ yā tuuú 'cūū yeⁿ'ē lado tuūu ch'ɛɛtɛ́ yeⁿ'ē esquina yeⁿ'e va'ai. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Vɛ́ɛ́ dámaāⁿ 'áámá n'dyáⁿ'ā sáⁿ'a 'cūū chi cuuvi nadanguáⁿ'ai sa 'aa du'ú nūuⁿ 'iiⁿ'yāⁿ. Neⁿ'e chi nguɛ́ɛ́ ndúúcū 'iiⁿ'yāⁿ miiⁿ nguɛ́ɛ́ nínguaⁿ'āī yú, ti nguɛ́ɛ́ táámá 'iiⁿ'yāⁿ ná iⁿ'yeeⁿdí 'cūū chi nadanguáⁿ'ai yā s'uuúⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Tuu'mi ní taachí n'diichi yā chi Juan ndúúcū Pedro ditiinú taavi sa, nguɛ́ɛ́ di'vá'a sa ní cudéénu yā chi nguɛ́ɛ́ saⁿ'ā chi deenu sa letra ti tonto sa, cheⁿ'e yiinú yā chiī. Ní deenú yā chi saⁿ'ā s'eeⁿ ch'ɛɛtinéé sa ndúúcū Jesús. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Taachí n'diichí yā chi chééndii saⁿ'ā chi 'āā nnduuvá yeⁿ'ē ndúúcū 'iiⁿ'yāⁿ s'eeⁿ nguɛ́ɛ́ ngíí ngaⁿ'a yā contra yeⁿ'e sa. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tuu'mi ngaⁿ'á 'iiⁿ'yāⁿ s'eeⁿ ngii yā saⁿ'ā s'eeⁿ miiⁿ chí nacan'dáa sa nguaaⁿ 'iiⁿ'yāⁿ s'eeⁿ. Ní 'iiⁿ'yāⁿ s'eeⁿ chí nndeé yā nguaaⁿ maáⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ní ngaⁿ'a yā: ¿Dɛ'ɛ̄ diiⁿ yú ndúúcū saⁿ'ā s'eeⁿ? Cuaacu nííⁿnyúⁿ chi vɛɛ 'aama señal caavā saⁿ'ā s'eeⁿ diiⁿ sa 'tíícā ní cadíínuuⁿ nducyaaca yā na yáāⁿ Jerusalén miiⁿ. Ní nguɛ́ɛ́ cuuvi 'cuɛɛcutáⁿ'a yú yeⁿ'e chúū. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Naati chi 'aa ntɛ́ɛ́ caaⁿ'maⁿ sa chi 'yaaⁿ cá chuū nguaaⁿ yáāⁿ, tuu'mi ní 'iiⁿ'yāⁿ chi ngaⁿ'a ntiiⁿnyúⁿ yā yeⁿ'ē yáāⁿ miiⁿ ngaⁿ'a yā: Yáá'ví yúúdu yú yeⁿ'e saⁿ'ā s'eeⁿ chí 'aa ntɛ́ɛ́ caaⁿ'maⁿ sa mar 'áámá yeⁿ'e Jesús ndii mááⁿ ndíí nguuvi chi cuchiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ní 'cai yā saⁿ'ā s'eeⁿ ní caⁿ'a yúúdú yā chii yā saⁿ'ā s'eeⁿ chi 'āā ntɛ́ɛ́ caaⁿ'maⁿ sa ní 'aa ntɛ́ɛ́ ca'cuéeⁿ sa yeⁿ'ē Jesús miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Naati Pedro ndúúcū Juan nán'guɛɛcutáⁿ'a sa yeⁿ'e yā ní caⁿ'ā sa yeⁿ'e yā: Canéé chí tuumicadiinuuⁿ nī nanááⁿ Dendyuūs. ¿'Áá canéé chi cu'téénu 'nū yeⁿ'e ndís'tiī vmnááⁿ vmnaaⁿ o cu'teenú 'nū yeⁿ'ē Dendyuūs? ");
INSERT INTO cuxNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ti nguɛ́ɛ́ cuuvi chi 'aa ntɛ́ɛ́ caaⁿ'máⁿ nús'uū dɛ'ɛ chí n'diichi 'nū o chííⁿ chí ch'iindiveéⁿ 'nū. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tuu'mi ní taachi yaa'vi yuudú yā saⁿ'ā s'eeⁿ ní nadichó'o yā saⁿ'ā s'eeⁿ cáávā nducyáácá yā i'téénu yā Dendyuūs cucáávā chíí 'āā chiī. Ní nguɛ́ɛ́ indaacá yā mar 'áámá nuuⁿndi ch'ɛɛtɛ yeⁿ'e saⁿ'ā s'eeⁿ chi cuuvi diíⁿ yā castigar saⁿ'ā s'eeⁿ cáávā chí 'va'á yā 'iiⁿ'yāⁿ yáāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Níícú diíⁿ yā 'áámá milagro ndúúcū saⁿ'ā miiⁿ chí nduūvā yeⁿ'ē sa. Saⁿ'ā miiⁿ 'āā ngo'o sá 'uūvī ngɛɛcu nduūyū yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Taachí 'āā nduuví yā libre cueⁿ'é yā nanááⁿ compañeros yeⁿ'é yā. Tuu'mi ní caⁿ'á yā nducuéⁿ'ē chi ncaⁿ'a chiiduú n'gɛɛtɛ́ yeⁿ'e Israel ndúúcū 'iiⁿ'yāⁿ ndiicúū chi ngaⁿ'a ntiiⁿnyuⁿ yeⁿ'e yáacū. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ní 'iiⁿ'yāⁿ s'eeⁿ ní taachí ch'iindiveéⁿ yā chuū, nduuvidaamá yā ní caⁿ'a yā ndúúcū Dendyuūs: N'díī, Señor Dendyuūs chi ch'ɛɛtɛ n'dai ca, n'diī 'iiⁿ'yāⁿ chi din'dái nī nanguuvi ndúúcū yáⁿ'āa ndúúcū nuūⁿnīⁿ'yáⁿ'ā ndúúcū tanducuéⁿ'ē chi vɛ́ɛ́. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Caati ndúúcū cheendi David, saⁿ'ā chi n'diī chí 'āā diiⁿ mandado yeⁿ'é nī ní 'āā caⁿ'a nī: ¿Dɛ'ɛ̄ cuchíí chi rebelde 'iiⁿ'yāⁿ chi nguɛ́ɛ́ 'iiⁿ'yāⁿ yeⁿ'ē ndaata Israel? Níícú 'iiⁿ'yāⁿ yeⁿ'ē naciones miiⁿ inacádiinúúⁿ yā cosa chi nguɛ́ɛ́ dichii'vɛ̄. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nduuvidaamá reyes yeⁿ'ē yáⁿ'āa 'cúū, 'íícú saⁿ'ā n'gɛɛtɛ chí ngaⁿ'ā ntiiⁿnyúⁿ yā nduuvidaamá yā contra yeⁿ'e Señor Dendyuūs, ndúúcū Cristo yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Maaⁿ ní cuaacu nííⁿnyúⁿ chí nduuvidaamá yā Herodes ndúúcū Poncio Pilato, ndúúcū 'iiⁿ'yāⁿ chi nguɛ́ɛ́ 'iiⁿ'yāⁿ yeⁿ'ē ndaata Israel ndúúcū 'iiⁿ'yāⁿ yeⁿ'e Israel na yáaⁿ 'cūū contra yeⁿ'e Jesús chi Daiya nī chi n'dai. Ní n'dií ca'á nī ntiiⁿnyuⁿ chi diíⁿ yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","'Iiⁿ'yāⁿ miiⁿ diíⁿ yā chi cuuvi tan'dúúcā chi neⁿ'é nī vmnááⁿ vmnaaⁿ chí cuuvi 'tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Maaⁿ ní n'diī Señor, n'diichí nī chi tan'dúúcā chi chiiduú n'gɛɛtɛ́ yeⁿ'ē Israel ngaⁿ'a taáⁿ yā ndúúcū nús'uu. N'diī Señor, teé nī nús'uu chi idiiⁿ mandado yeⁿ'é nī chí nguɛ́ɛ́ 'va'á 'nū ní caaⁿ'máⁿ 'nū nduudu yeⁿ'é nī. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ch'íⁿ'í maáⁿ nī chi diitú nī chí 'iiⁿ'yāⁿ diíⁿ yā chi nánduūvā yeⁿ'e 'iiⁿ'yāⁿ, ní diíⁿ yā señales ndúúcū vaadī n'giinu cucáávā Daiyá nī chi Jesús chi n'dai taavi. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Taachí ch'iinu caⁿ'ángua'á yā naachi nduuvidáámá yā, nuⁿ'u va'āī miiⁿ. Ní nducyaaca yā ní chiitu Espíritu N'dai yeⁿ'e Ndyuūs 'iiⁿ'yāⁿ. Nguɛ́ɛ́ 'va'á yā chí caⁿ'a yā nduudu yeⁿ'e Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","'Iiⁿ'yāⁿ n'deee n'dáí chí chi'téénu yā nduuvidaamá yā ní 'áámá staava yeⁿ'é yā, 'áámá alma yeⁿ'é nducyaaca yā. Mar 'áámá 'iiⁿ'yāⁿ nguɛɛ caⁿ'a yā chi yeⁿ'é yā dendu'ū chi vɛɛ yeⁿ'é yā ti nducuéⁿ'ē chi vɛ́ɛ́ ní yeⁿ'ē nducyááca yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apóstoles chi dichó'ó Ndyuūs ngaⁿ'á yā nduudu cuaacu ndúúcū poder ch'ɛɛtɛ yeⁿ'ē Señor Jesús chi nadacuéeⁿ yā yeⁿ'e nguaaⁿ tináⁿ'ā. Níícú favor ch'ɛɛtɛ taavi cá yeⁿ'é Dendyuūs cánéé nanááⁿ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mar 'áámá 'iiⁿ'yāⁿ nguɛɛ ngii 'vaachí yā. Nducyáácá 'iiⁿ'yāⁿ chi vɛ́ɛ́ yeⁿ'ē chiidá yā chí yeⁿ'e yā ndúúcū dendu'u yeⁿ'é yā ín'diicuí yā. Ní ndɛ́ɛ yā chi ndāāca yā chi n'diicui yā chiiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ní 'neeⁿ yā na ca'a apóstoles chi dichó'ó Dendyuūs. Ní nga'á yā ca'áámá 'iiⁿ'yāⁿ tuunu tuunu ca ngii 'vaachí 'iiⁿ'yāⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tuu'mi ní José, ní 'iiⁿ'yāⁿ chi s'neeⁿ apóstoles chi duuchi Bernabé (chi neⁿ'e caaⁿ'maⁿ, 'Iiⁿ'yāⁿ chi ngaⁿ'a 'viich'ɛɛtíínūuⁿ). José miiⁿ 'iiⁿ'yāⁿ yeⁿ'e ndaata yeⁿ'e levita ní ch'iindiyáaⁿ yā na isla Chipre. ");
INSERT INTO cuxNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","'Iiⁿ'yāⁿ miiⁿ vɛ́ɛ́ 'áámá vaadī ngua'aá yeⁿ'é yā. N'diicui yā ní ndɛ́ɛ yā tuumi yeⁿ'ē miiⁿ, ní s'néeⁿ yā na ca'a apóstoles chi dichó'ó Ndyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Vɛ́ɛ́ 'áámá saⁿ'ā chi nduuvi sa Ananías ndúúcū Safira n'daataá yeⁿ'ē sa chi n'diicui sá 'áámá vaadī ngua'aá yeⁿ'ē sa. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nguɛ́ɛ́ tanducuéⁿ'ē tuumi chi sta'a sa yeⁿ'e yáⁿ'āa ndɛɛ sa, ní n'daatáá yeⁿ'ē sa chicadíínúúⁿ tá chuū. Saⁿ'ā miiⁿ ní 'tɛ́ɛ́ nūu ndɛ́ɛ sa chi 'neeⁿ sa na ca'ā apóstoles chi dichó'ó Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tuu'mí ngaⁿ'ā Pedro miiⁿ: Díí, Ananías, ¿dɛ'ɛ̄ cuuví chi yááⁿn'guiinūuⁿ chistaⁿ'a sa na staavá yeⁿ'ē di, ní nguɛ́ɛ́ caⁿ'a cuaacú dí nanááⁿ Espíritu N'dai yeⁿ'e Ndyuūs, ní nguɛ́ɛ́ ndɛ́ɛ di tanducuéⁿ'ē tuumī yeⁿ'ē yáⁿ'āa miiⁿ? ");
INSERT INTO cuxNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'Naaⁿ chi cánéé ta'ā di, ¿'áá nguɛ́ɛ́ yeⁿ'ē di? Ni taachi 'āā n'dīīcuī di, ¿'áá nguɛ́ɛ́ yeⁿ'ē di dendu'ū? ¿Dɛ'ɛ cúúví chí chi'neeⁿ di na staava yeⁿ'ē di? Nguɛ́ɛ́ caⁿ'a di nduudu yaadi miiⁿ ná saⁿ'ā iⁿ'yeeⁿdí 'cūū naati nanááⁿ Dendyuūs. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Taachi Ananías ch'iindiveeⁿ sa nduudú 'cūū sndɛɛvɛ sá ní ch'iī sa. Ní nducyááca yā chi ch'iindiveéⁿ yā chuū dii'yā taaví yā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ní saⁿ'ā da'cáiyāa chi s'nééⁿ miiⁿ nadicuéeⁿ sa 'iiⁿ'yāⁿ, ní ch'ɛɛcu sa tíínūuⁿ 'iiⁿ'yāⁿ, ní tun'dáa sa 'iiⁿ'yāⁿ chuva'āī. Ní ch'iichi sá 'iiⁿ'yāⁿ na panteón. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Cho'ōo tan'dúúcā 'iiⁿnūⁿ hora chi ndáā n'daataá yeⁿ'ē sa chɛɛti yaācū. Táⁿ'a 'cūū ní nguɛ́ɛ́ deenū tá dɛ'ɛ̄ chi chiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tuu'mi ní Pedro ngaⁿ'a sa ngii sa táⁿ'ā: Cuuvi di 'úú, ¿'áá n'deēe tuumí sta'a di yeⁿ'e yáⁿ'āa miiⁿ chí n'diicui sa? Ní tá miiⁿ ní caⁿ'a tá: 'Tíícā. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro miiⁿ ngaⁿ'a sa ngii sa táⁿ'ā: ¿Dɛ'ɛ̄ cáávā chi diiⁿ di ndúúcū isaⁿ'a yeⁿ'ē di chi chinnche'ei dí Espíritu yeⁿ'e Señor 'iivú Ndyuūs? N'diichí dí. 'Iiⁿ'yāⁿ chi cheⁿ'e chí n'guuchi isaⁿ'ā yeⁿ'ē di sneé yā cheendi yaācū ní canéé chí tun'dáa ntúuⁿ yā dii. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tuu'mi ní chi nndɛɛvɛ́ túūⁿ tá 'cūū na ca'a Pedro ní ch'iī tá. Taachi ndáa saⁿ'ā s'eeⁿ yáacū ní nndaaca sa táⁿ'a 'āā n'dii ntúūⁿ tá. Ní tun'dáa nī ntúūⁿ saⁿ'ā da'caiyāa s'eeⁿ táⁿ'ā. Ní ch'iichi sa táⁿ'ā niiⁿnuúⁿ ná yáinyāⁿ yeⁿ'ē saⁿ'a yeⁿ'ē tá. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nducyáácá 'iiⁿ'yāⁿ yeⁿ'ē yáacū ndúúcū 'iiⁿ'yāⁿ chi ch'iindiveéⁿ yā chuū neené dii'yá yā chiī. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Cáávā ta'a apóstoles neené n'deee nááⁿ señales ndúúcū vaadī n'giinu s'eeⁿ diíⁿ yā na yáāⁿ miiⁿ. Ní nducyáácá yā 'áámá nduuvidaamá yā corredor chi nguuvi Salomón yeⁿ'e yaācū templo yeⁿ'e 'iiⁿ'yāⁿ Israel. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","'Iiⁿ'yāⁿ chi nguɛ́ɛ́ nduuvidaamá yā ndúúcū 'iiⁿ'yāⁿ yeⁿ'e yáacū 'va'á yā chi nduuvidāāma yā nduucú yā. Naati 'iiⁿ'yāⁿ yeⁿ'e yáāⁿ miiⁿ diiⁿ yā honrar 'iiⁿ'yāⁿ yeⁿ'e yáacū. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","'Iiⁿ'yāⁿ chi i'téénú Señor 'iivú Ndyuūs chi 'yaaⁿ cá yā tan'dúúcā chi 'yaaⁿ sáⁿ'ā 'tiicá ntúūⁿ n'daataá; ");
INSERT INTO cuxNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","tun'dáa yā 'iiⁿ'yāⁿ s'eeⁿ chi ngííta miiⁿ cyuuni. Ní sn'duú yā 'iiⁿ'yāⁿ na cama, ní sn'duú yā 'iiⁿ'yāⁿ na colchones, ti taachi cho'o Pedro miiⁿ ní 'aa cunee 'cuutií yeⁿ'ē Pedro miiⁿ vmnaaⁿ yeⁿ'ē 'áámá chɛɛ 'iiⁿ'yāⁿ s'eeⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Níícú 'iiⁿ'yāⁿ yáāⁿ na niiⁿnuúⁿ mííⁿ neené 'yáaⁿ yā ndaá yā yáāⁿ Jerusalén ndúúcū 'iiⁿ'yāⁿ chi ngiítā ndúúcū 'iiⁿ'yāⁿ chí sta'ā 'yúúné chí nguɛ́ɛ́ n'dāācā yeⁿ'e yááⁿn'guiinūuⁿ. Nducyáácá yā nduuva yeⁿ'é yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tuu'mi ní chiiduú ch'ɛɛtɛ ca yeⁿ'e Israel ndúúcū 'iiⁿ'yāⁿ chi snée yā ndúúcu yā chi yeⁿ'ē saduceo s'eeⁿ chi nguɛ́ɛ́ i'téénu yā chi nduuchi 'iiⁿ'yāⁿ nguaaⁿ tináⁿ'ā diíⁿ yā contra yeⁿ'e 'iiⁿ'yāⁿ s'eeⁿ. Ní diíⁿ ngueé yā. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ní sta'á yā apóstoles chi dichó'ó Ndyuūs ní s'nuúⁿ yā saⁿ'ā s'eeⁿ vácūū yeⁿ'e yáāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Naati 'áámá ángel yeⁿ'e Señor 'iivú Dendyuūs miiⁿ ní nn'guaaⁿ yā cheendi vácūū miiⁿ n'gaaⁿ, ní tun'dáa yā 'iiⁿ'yāⁿ s'eeⁿ ní caⁿ'a yā: ");
INSERT INTO cuxNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Cunaⁿ'á nī, ní 'cueetíndií nī na yáacū templo ní caa'maⁿ nī tanducuéⁿ'ē nduudu yeⁿ'e vida ngaí 'cūū nanááⁿ nducyaaca 'iiⁿ'yāⁿ yeⁿ'ē yáāⁿ miiⁿ. ");
INSERT INTO cuxNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Taachí ch'iindiveéⁿ yā chuū ní sndaa yā yaācū templo miiⁿ tyaaⁿ tyaaⁿ ní ca'cueeⁿ yā. 'Naaⁿ chi snée yā chɛɛti yaācū miiⁿ ní nduuvidáámá chiiduú