﻿USE sofia;
DROP TABLE IF EXISTS sofia.cutNT_vpl;
CREATE TABLE cutNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cutNT_vpl WRITE;
INSERT INTO cutNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tuhca̱ cochi nda̱ta yahn Dihvo vo Jesucristo. Ihyan ndico yahn ye ne, David ma̱n, Abraham ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Da̱ya Abraham ne, Isaac. Da̱ya Isaac ne, Jacob. Da̱ya Jacob ne, Judá nduco dihno se. ");
INSERT INTO cutNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Da̱ya Judá nduco Tamar ne, Fares ma̱n, Zara ma̱n. Da̱ya Fares ne, Esrom. Da̱ya Esrom ne, Aram. ");
INSERT INTO cutNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Da̱ya Aram ne, Aminadab. Da̱ya Aminadab ne, Naasón. Da̱ya Naasón ne, Salmón. ");
INSERT INTO cutNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Da̱ya Salmón nduco Rahab ne, Booz. Da̱ya Booz nduco Rut ne, Obed. Da̱ya Obed ne, Isaí. ");
INSERT INTO cutNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Da̱ya Isaí ne, rey David. Da̱ya rey David nduco nda̱hta yahn Urías ne, Salomón. ");
INSERT INTO cutNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Da̱ya Salomón ne, Roboam. Da̱ya Roboam ne, Abías. Da̱ya Abías ne, Asa. ");
INSERT INTO cutNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Da̱ya Asa ne, Josafat. Da̱ya Josafat ne, Joram. Da̱ya Joram ne, Uzías. ");
INSERT INTO cutNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Da̱ya Uzías ne, Jotam. Da̱ya Jotam ne, Acaz. Da̱ya Acaz ne, Ezequías. ");
INSERT INTO cutNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Da̱ya Ezequías ne, Manasés. Da̱ya Manasés ne, Amón. Da̱ya Amón ne, Josías. ");
INSERT INTO cutNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Da̱ya Josías ne, Jeconías nduco dihno se. Ta̱hn min che din sanda̱do yahn Babilonia preso ihyan nación yahn Israel, quenda se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cuahn che chenan ihyan chahn nación yahn Babilonia, chihndeya̱n Salatiel, da̱ya Jeconías. Da̱ya Salatiel ne, Zorobabel. ");
INSERT INTO cutNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Da̱ya Zorobabel ne, Abiud. Da̱ya Abiud ne, Eliaquim. Da̱ya Eliaquim ne, Azor. ");
INSERT INTO cutNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Da̱ya Azor ne, Sadoc. Da̱ya Sadoc ne, Aquim. Da̱ya Aquim ne, Eliud. ");
INSERT INTO cutNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Da̱ya Eliud ne, Eleazar. Da̱ya Eleazar ne, Matán. Da̱ya Matán ne, Jacob. ");
INSERT INTO cutNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Da̱ya Jacob ne, José, ihyan min che chihneva̱co nduco María, chaco Dihvo vo Jesucristo. Dihvo vo ne, a ihyan min che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ri ndichecun ihyan ndico che cochi rihco nda̱ta ye nde cuahn che quenan Abraham iyehnse nde nda̱ ro che quenan David. Me nde ro che quenan David ne, te ndichecun ihyan ndico nde nda̱ ro che chahtenan ihyan nación yahn Israel preso nación yahn Babilonia. Me nde ro min ne, te ndichecun ihyan ndico nde nda̱ ro che chihndeya̱n Dihvo vo Jesucristo, ihyan min che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tuhca̱ chi che chihndeya̱n Dihvo vo Jesucristo: Chaco ye, María ne, a va ndudo yahn ye che cahneva̱co ye nduco José. Numanahn che metah cahneva̱co ye ne, nduco vederihquentiyon yahn Vaco Ndah yahn Dendiohs nda̱ca da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nducote ndah ihyan José ne, cuahn che checadino ye che quenun da̱ya María ne, hua nahn ye che cora vedecuihno yahn ihyan min. Chemin che chihco da̱ma ino ye che decuihno ye ndudo yahn ye nduco vih, tin dema̱n no ye, ca̱va che hua cadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ate ndihchero ye va̱n ya̱hnde yahn ye a̱ma ángel yahn Dihvo vo Dendiohs, ne ra̱hn ángel me ri ye ihyan: ―José, nda̱ta yahn David, hua dehve rahque, co cahnevaque nduco María. Hua ndeh ndedecadine, te che quenun da̱ya ye ne, a nduco vederihquentiyon yahn Vaco Ndah yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Cuahn che cuhndeya̱n decua̱h me ne, cuaconehn che duche JESUS, te a ihyan min che ndedevahn ye ihyan yahn ye, ca̱va che hua conda ihyan chahn, din nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tihca̱ chi nducuahn chemin ca̱va che conahn che chihquentiyon Dihvo vo Dendiohs, dirun ihyan profeta tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","A̱ma nda̱hta ntuhco ne, conun da̱ya ye. Cuahn che cuhndeya̱n ne, conan che duche Emanuel. Che tihca̱ duche ne, conahn che Dendiohs nduco ye uvo. ");
INSERT INTO cutNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuahn che ntuche José ne, dinahn ye nduhca̱ che chihquentiyon ángel me ihyan, ne chihneva̱co ye nduco María. ");
INSERT INTO cutNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ate metah conan cuma ye ihyan nde chuh ro che chihndeya̱n decua̱h me. Cuahn che chihndeya̱n decua̱h me ne, JESUS chaconahn ye che duche. ");
INSERT INTO cutNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Chihndeya̱n Dihvo vo Jesucristo ya̱n Belén, esta̱do yahn Judea, cuahn che quenan rey Herodes rihquentiyon ye esta̱do min. Ta̱hn min ne, o ino ihyan devano che chica ye ya̱hn yahn cua̱hn na̱n che riquenda̱h ya̱hn ne, nda̱ ye ya̱n Jerusalén, ");
INSERT INTO cutNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ne tumerune ye: ―¿Ti quenan rey yahn ihyan nación yahn Israel che a chihndeya̱n ye ne? A devano nuhn che a va ye, te a ndihchero nuhn iyon che rihco ro che a chihndeya̱n ye. Chemin che cochi nuhn ndeva nuhn yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cuahn che checadino rey Herodes che tihca̱ ne, a̱ma ndeh ndedecadino se. Namin nducoya̱ca ihyan ya̱n Jerusalén a̱ma ndeh ndedecadino ye. ");
INSERT INTO cutNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tuhme chihquentiyon rey me che ndo da̱ma chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ne tumerune se ti va ca̱de che cuhndeya̱n ihyan che dechuh Dendiohs, ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ndahconan ihyan chahn, ne ra̱hn ye ri ye sa̱hn: ―Ya̱n Belén, esta̱do yahn Judea, va ca̱de che cuhndeya̱n ye, te dirun ihyan profeta tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ya̱n Belén, esta̱do yahn Judea ne, co cuande va̱n ya̱n rahte yahn esta̱do min, te min va che cuhndeya̱n ihyan ndina̱n che din ye cuda̱do ihyan yahn Dendiohs, ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Chihno min ne, cua̱hn ndeh cah rey me ihyan devano chahn, ne tumerune se ihyan deh ro niyon che chihnde ro iyon me. ");
INSERT INTO cutNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tuhme chihquentiyon se ihyan chahn, ne ra̱hn se: ―Cuahn nchuhn ya̱n Belén, tumerune ndah ne ti quenan decua̱h me, ne cuahn che a nta̱ca ne ne, checu ne ndudo yáhn ca̱va che namin cá̱hn ndevá yavena̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Chihno chihcovan ihyan chahn che ra̱hn rey me ne, quendi ye cuahn ye. Tuhme iyon me ne, quenda̱hna̱n cuahn nde nda̱ cua̱co na̱n che quendite decuah me, ne min quendihco. ");
INSERT INTO cutNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cuahn che ndihchero ihyan chahn che quendihco iyon me min ne, a̱ma chi yeno ye. ");
INSERT INTO cutNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chenda̱ ye chete vah, ne cuahn che ndihchero ye lihn me nduco chaco Mariá ne, chehntihya ye ndeva ye yavena̱n. Tuhme na̱hne ye yave na̱n che chenun tume yahn ye, ne tenda̱h ye diya̱hngua̱n ma̱n, cuhn ma̱n, nundeda̱n che duche mirra ma̱n, ca̱h ye co yahn lihn me. ");
INSERT INTO cutNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chihno min ne, ca̱h Dendiohs che checadino ihyan chahn va̱n ya̱hnde yahn ye che metah ndaconan ye na̱n quenun Herodes, ne chemin che chahconan ye yune, cona̱hn ye ya̱n va̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cuahn che a cona̱hn ihyan devano chahn ne, ndihchero José va̱n ya̱hnde yahn ye a̱ma ángel yahn Dihvo vo Dendiohs, ne ra̱hn ángel me ri ye ihyan: ―Cuiquenda sa̱hn dihn nduco chaco se, ne codin vi, cuehn cua̱hn nación yahn Egipto. Min conen nde ro che ca̱hcantiyón che ndaconen, te Herodes ne, nuhn se sa̱hn dihn me ca̱va che ca̱hno se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ndeta̱hno quenda José sa̱hn dihn me nduco chaco se chete ra̱hn, cuahn ye cua̱hn nación yahn Egipto. ");
INSERT INTO cutNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Min chahtenan ye nde nda̱ ro che chih Herodes. Tihca̱ chi ca̱va che conahn ndudo che ca̱h Dendiohs, dirun ihyan profeta tuhca̱: “Nde nación yahn Egipto quendá Da̱yá.” ");
INSERT INTO cutNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cuahn che tumacadino Herodes che chahcota̱hn ihyan devano chahn yahn se ne, a̱ma chi ta̱n se, ne dechuh se sanda̱do ya̱n Belén ma̱n, ya̱n che nino min ma̱n, che chihno se nducoya̱ca decua̱h cha̱hn, nde checa̱hya che a ri o nduyo, te a tih va ro che ndihchero ihyan devano chahn iyon me. ");
INSERT INTO cutNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nduco tihca̱ chinahn ndudo che dirun ihyan profeta Jeremías tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","A̱ma rah ra̱n ihyan ma̱n, a̱ma raco ye ma̱n, anduhneca̱ ndete che ma̱n Raquel raco ye ca̱va da̱ya ye. Hua nda̱ca ye vedechahtino, te a chihno chihno se da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cuahn che a chih Herodes ne, min nación yahn Egipto ndihchero José va̱n ya̱hnde yahn ye, a̱ma ángel yahn Dihvo vo Dendiohs, ne ra̱hn ángel me ri ye ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Cuendiquenda sa̱hn dihn me nduco chaco se, ne conahn nación yahn Israel, te a chih sa̱hn che nahn ca̱hno se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tuhme ndiquenda José sa̱hn dihn me nduco chaco se, ne ndaconan ye nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ate checadino José che Arquelao rihquentiyon se menun chida se esta̱do yahn Judea, ne hua chihquino ye quenan ye esta̱do min. Tuhme ca̱h Dendiohs che checadino ye va̱n ya̱hnde yahn ye, ne cuahn ye esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Min quenan ye a̱ma ya̱n che duche Nazaret. Tihca̱ chi ca̱va che conahn nduhca̱ che dirun ihyan profeta yahn Dihvo vo Jesucristo tuhca̱: “Nazareno ca̱hma ihyan yahn ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ta̱hn min ne, nda̱ Juan Bautista esta̱do yahn Judea, ya̱hn na̱n che metah duhva. Min cahndudo ye ");
INSERT INTO cutNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ne ra̱hn ye: ―Cuento ino nchuhn nunde yahn ne, te Dendiohs, ihyan min che va ye vahchetero ne, a nun cuahn ca̱hcantiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","A yahn Jua̱n che dirun ihyan profeta Isaías tuhca̱: Cuahndudo a̱ma ihyan ya̱hn na̱n che metah duhva, ne ca̱hma ye tuhca̱: “Cuihcoya̱n nchuhn chedave yahn ne ca̱va che nevahnecun ne Dihvo vo.” ");
INSERT INTO cutNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Tino yahn Jua̱n ne, ndiya nduco yudo yahn camello, ne quenan chete ye a̱ma ima. Reh ye a̱ma na̱n ya̱hcada̱hn ma̱n, rih ye nedih yahn che va va̱n chano ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ihyan ya̱n Jerusalén ma̱n, ihyan che vate ye ta̱ma te o ya̱n esta̱do yahn Judea ma̱n, chihto ico Jordán ma̱n ne, rahn ye rihnevan ye che rahndudo Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Rentuma ino ye nunde yahn ye, ne rehdenune Jua̱n ihyan, min ico Jordán. ");
INSERT INTO cutNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A̱ma ya̱hn sa̱hn fariseo ma̱n, sa̱hn saduceo ma̱n, renda̱ se ca̱va che cuehdenune Jua̱n sa̱hn. Ate rihya ye sa̱hn: Nchuhn ne, nduhchan cu ta̱n tihchan ne. ¿Duh te cuande nchuhn che din nun ino ne ca̱va che ndevahn ne yahn castigo yahn Dendiohs che va che co ne? ");
INSERT INTO cutNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cuahtenan nchuhn nduhca̱ che rahtenan ihyan che rento ino ye nunde yahn ye numacuahn chedave yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hua ndere ndonan ma̱n ne nchuhn che nda̱ta yahn Abraham nchuhn, te ndete che nahn Dendiohs che ndere co ya̱hn nda̱ta yahn ihyan min ne, nde tu che tuhchan co din ye che nda̱conda̱ ihyan che co cuande ye na̱n nda̱ta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ma̱n ne, anduhneca̱ ndete che a va ya̱n cu tin ca̱va che ca̱ta dihyoduto ya̱hn. Nducuahn ya̱hn che hua cochihve ndute yahn ne, ca̱ta, conun va̱coya̱hn. Atihnoca̱ co nduco nchuhn che hua cochihve che redin ne, te va che co ne castigo. ");
INSERT INTO cutNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’U ne, rehdenuné nchuhn ca̱va che co ro che a nto ino ne nunde yahn ne. Ate a nun cochi ta̱ma ihyan che tahque yudo vederihquentiyon quenan cuma ye che co u, che nde hua rigonun chihvé ca̱va che co mozo yahn ye. Ihyan min ne, din ye che conun Vaco Ndah yahn Dendiohs ihyan ma̱n, din ye castigo ihyan nunde ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nduhca̱ che retive ya̱to ihyan trigo, rih ndah ye, ne renedin da̱ma ye da̱che ya̱ma yahn, rihquiya̱hn ye ne, tihca̱ a nun techeca̱de ihyan min yahn nducoya̱ca ihyan. Ihyan che ndah ihyan ye na̱n Dendiohs ne, quenda ye ihyan vahchetero, ne ihyan che duhtuno ihyan ye ne, dechuh ye ihyan va̱n ruchiya̱hn che hua nda̱ ro che ntoh. ");
INSERT INTO cutNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ta̱hn min ne, chica Dihvo vo Jesucristo esta̱do yahn Galilea, nda̱ ye ico Jordán na̱n quenan Jua̱n ca̱va che cuehdenune ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ate ra̱hn Jua̱n ri ye ihyan: ―U che rendotenán ndih ca̱va che cuehdenune ne u, ¿ta̱ca̱ che u cuehdenuné ndih? ");
INSERT INTO cutNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Nahn che cuehdenune u, te redin yahn che dinahn vo nducuahn vederihquentiyon yahn Dendiohs. Tuhme chehdenune Jua̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chihno chedenune Dihvo vo ne, ndiquenda̱ ye va̱n nune. Ura min ndihchero ye Vaco Ndah yahn Dendiohs che chica vahchetero. Deca̱ ro icui deca̱ ro, ne chiya, quenun ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tuhme chenun a̱ma ndudo che chica vahchetero che ra̱hn tuhca̱: ―Sa̱hnguh che Da̱yá. Yahinó sa̱hn. A̱ma yenó che va se. ");
INSERT INTO cutNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Chihno min ne, din Vaco Ndah yahn Dendiohs che cuahn Dihvo vo a̱ma cua̱n, ya̱hn na̱n che metah duhva, ca̱va che tumarande chundah ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Min quenan ye chete che o raco ro, ne hua cheh ye. Chihno min ne, chi cuico ye. ");
INSERT INTO cutNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tuhme chahn nda̱ chundah, ne ra̱hn se ri se ihyan: ―Ndete che Da̱ya Dendiohs ndih ne, codin ne che tu che tuhchan ne, nda̱conda̱ pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ate ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―A ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Ndiyu dema̱n pa̱n che rendotenan ihyan, te namin rendotenan ye ndudo yahn Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Chihno min ne, quenda se ihyan nde tin ya̱co yahn ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ra̱hn se ri se ihyan: ―Ndete che Da̱ya Dendiohs ndih ne, ca̱va ne muhn, co ne nde ndiya̱hn, te a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: Ca̱hcantiyon Dendiohs ángel yahn ye che din ye cuda̱do ndih, ca̱va che hua dehva co yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Namin ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Hua tumerende Dihve Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Chihno min ne, quenda chundah me ihyan a̱ma tin ico ya̱co, ne na̱hma se ihyan nducuahn vederihquentiyon che va iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ra̱hn se ri se ihyan: ―Ndete che cahntihya ne ná̱n, ndeva ne yavená̱n ne, té nducuahn vederihquentiyon che ta̱hchan ndih. ");
INSERT INTO cutNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ate ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Cuavi ná̱n, chundah, te a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Cuendeva yavena̱n Dihve Dendiohs. A ihyan min no codinehn yahn ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tuhme chihcoma̱n chundah me ihyan, ne nda̱ ángel chinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Cuahn che checadino Dihvo vo che quenun Jua̱n va̱coya̱hn ne, cona̱hn ye esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ate hua quenan ye ya̱n Nazaret. Tahque ndah ye ne, cuahn ye quenan ye ya̱n Capernaum, ya̱hn yahn Zabulón ma̱n, Neftalí ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tihca̱ chi ca̱va che conahn nduhca̱ che dirun ihyan profeta Isaías tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ya̱hn yahn Zabulón ma̱n, Neftalí ma̱n, chihto yune che rahn na̱n vine ma̱n, ta̱ma la̱do yahn ico Jordán ma̱n, esta̱do yahn Galilea, ya̱n va̱co ihyan ta̱ma nación ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","min ne, anduhneca̱ ndete che man na̱n che vate ihyan. Ate nda̱ ro che anduhneca̱ ndete che condihco dave na̱n ye. Ihyan che vate ye min ne, ca̱hnda yahn ye anduhneca̱ ndete che a vate ye ta̱h vederih. Ate nda̱ ro che anduhneca̱ ndete che co dave yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","A nde ta̱hn min cana̱n Dihvo vo rahndudo ye, ne ra̱hn ye: ―Cuento ino nchuhn nunde yahn ne, te Dendiohs, ihyan min che va ye vahchetero, a nun cuahn ca̱hcantiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","A̱ma yune ne, quechica Dihvo vo chihto vine yahn Galilea. Ndihchero ye o ihyan reta̱h ya̱hca, Simón Pedro ma̱n, dihno ye Andrés ma̱n. Ura min ne, rentihyon ihyan chahn ya̱na chete vine me ca̱va che cota̱h ye ya̱hca. ");
INSERT INTO cutNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tuhme ra̱hn ye ri ye ihyan chahn: ―Cuhn vo conduco nchuhn u, ne ndotenan che din da̱ma ne ya̱hca ne, cacuáhn nchuhn ca̱va che din da̱ma ne ihyan, conduco ye u. ");
INSERT INTO cutNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ndeta̱hno chihcoma̱n ihyan chahn ya̱na yahn ye, ne cuahn ye nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tah cuahn ca̱na na̱n me ne, ndihchero ye o da̱ya Zebedeo, Jacobo ma̱n, Jua̱n ma̱n. Chenun ye chete ba̱rco nduco chida ye, renta̱hyon nan ye ya̱na yahn ye. Namin ya̱hve Dihvo vo ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ne ndeta̱hno chihcoma̱n ye chida ye ma̱n, ba̱rco me ma̱n, cuahn ye nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Chihno min ne, quechica Dihvo vo numacuahn ya̱n yahn Galilea, ricuahn ye nduh cua̱n ya̱co yahn ihyan nación yahn Israel. Rahndudo ye nduhca̱ che rihquentiyon Dendiohs ihyan yahn ye, ne redin ye che rendoyahn ihyan cah. ");
INSERT INTO cutNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nde numachahte nación yahn Siria chetuhn ndudo yahn vederihno che redin ye, ne a̱ma chengu ihyan ihyan cah yahn ye, ihyan che rih dihca ye ma̱n, ihyan che ndi cheche ye ma̱n, ne din Dihvo vo che ndoyahn ye. Namin ihyan che chenun vaco chihnga̱ ihyan ne, ndetenda̱h Dihvo vo vaco chihnga̱ chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A̱ma ya̱hn ihyan chinduco ye ihyan, ihyan esta̱do yahn Galilea ma̱n, ihyan esta̱do yahn Judea ma̱n, ihyan ya̱n Decápolis ma̱n, ihyan ya̱n Jerusalén ma̱n, ihyan che vate ye ta̱ma la̱do lco Jordán ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Cuahn che ndihchero Dihvo vo che a̱ma ya̱hn ihyan chenun ye min ne, cocha ye a̱ma tingüete, chihnde ye. Tuhme ndo da̱ma ihyan che ritahno ye ihyan na̱n ye, ");
INSERT INTO cutNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ne chicuahn ye ihyan chahn tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ihyan che ri nda̱che ye yahn che chendihco ye nunde ne, ndah ro yahn ye, te cuahtenan ye vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ihyan che ra̱n ye ne, ndah ro yahn ye, te neca̱h Dendiohs vedechahtino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ihyan che necun ye ne, ndah ro yahn ye, te cuahtenan ye iyehnse nduhca̱ che neca̱h Dendiohs ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ihyan che a̱ma nahn ye che runeca̱de cuahtenan ye ne, ndah ro yahn ye, te conan Dendiohs ihyan ca̱va che conahn nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ihyan che renan va̱hino ye ihyan chena̱hn ne, ndah ro yahn ye, te conan va̱hino Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ihyan che hua chendihco ye nunde ne, ndah ro yahn ye, te ndeva Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ihyan che riya̱hve ye ihyan ca̱va che ndo ya̱n ye nduco vih ne, ndah ro yahn ye, te nedin da̱ya Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ihyan che redin ta̱n ihyan nduco ye yahn che runeca̱de vatechica ye ne, ndah ro yahn ye, te rihquentiyon Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ndah ro yahn nchuhn cuahn che ca̱hma ta̱n ihyan nduco ne ma̱n, din ta̱n ye nduco ne ma̱n, ndere ca̱hma nunde ye yahn ne ma̱n, yahn che ritahno ne u. ");
INSERT INTO cutNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cuahn che tihca̱ cuahno co ne ne, co yeno ne, te ndeva Dendiohs nchuhn, cuahtenan ne vahchetero. A devano ne te a tihca̱ chahno chi ihyan profeta che chahte ye a ra̱hn me, din ta̱n ihyan nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ima ne, a̱ma richihve, ate ndete che neca̱n, che metah chihn dihne ne, ametah cochihve. Va che cahtera ihyan, condinun condina̱hno ye. Chemin che nahn che din nchuhn cuda̱do vederihquentiyon che chenan cuma ne. ");
INSERT INTO cutNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nduhca̱ che richihve ya̱hn che ri ro dave na̱n ihyan muhn iyehnse ne, tihca̱ richihve nchuhn ca̱va nducoya̱ca ihyan, te a devano ne vederihquentiyon yahn Dendiohs. Ya̱n ne, rihco ihyan a̱ma tin ico, te nahn ye che ndah co ro. ");
INSERT INTO cutNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Namin cuahn che nahn ya̱hn ihyan a̱ma ya̱hn ne, rihco ye na̱n che ya̱co ca̱va che co ro dave na̱n ihyan che chenun ye chete vah. Hua rihco ndeh ye ma̱n a̱ma cajón. ");
INSERT INTO cutNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Namin nchuhn ne, nahn che runeca̱de cuahtechica ne ca̱va che cua cuande nducoya̱ca ihyan, ne ndeva ye yavena̱n Chida ne che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Cuedevano nchuhn che ndá̱ ndiyu ca̱va che cuahcotá̱hn yahn ley che dirun Moisés ma̱n, ndudo che dirun ihyan profeta ma̱n, te ca̱va che ca̱h cuandé ihyan deh conahn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Cua̱co rá̱hn rí nchuhn te numanahn che metah cuihno vahchetero ma̱n, iyehnse ma̱n ne, hua condanan nde a̱ma ndudo na̱n ley min. Nde nducuahn che hua nduh rigonun chihve che ra̱hco ihyan ne, va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chemin che adecoduhno ihyan che cahnevi ye a̱ma na̱n vederihquentiyon yahn, andahre hua nduh rigonun chihve che ra̱hco ye, ne tihca̱ cacuahn ye ihyan chena̱hn ne, ihyan min ne, hua nduh rigonun chihve ye vahchetero na̱n che rihquentiyon Dendiohs. Ate ihyan che dinahn ye nducuahn, ne tihca̱ cacuahn ye ihyan chena̱hn ne, a̱ma rigonun chihve ye vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Rá̱hn rí nchuhn te ndete che hua nde tahque runeca̱de cuahtechica ne che co sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, nde hua co cuahtenan ne vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Nchuhn ne, a devano ne te ihyan ndico yahn ne chicuahn ye tuhca̱: “Hua cahne ihyan, te adecoduhno ihyan che ca̱hno ye vih ne, va che co ye castigo.” ");
INSERT INTO cutNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ate u ne, rá̱hn rí nchuhn te adecoduhno ihyan che co ta̱n ye nduco ihyan chena̱hn ne, va che co ye castigo. Adecoduhno ihyan che ca̱hva ye nduco ihyan chena̱hn ne, va che ndo da̱ma ihyan ndina̱n, din ye castigo ihyan. Adecoduhno ihyan che ca̱hma ye co ye ta̱ma ca ihyan che nahn dave yahn ne, ca̱hnda yahn ye, te nduco nunde min ne, codin che conun ye va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Chemin che rá̱hn rí nchuhn te andahre a nda̱ ne na̱n ta nduco vedino che ca̱h ne Dendiohs, ate ndete che ura min nta̱ tin ne che va nunde yahn ne na̱n ihyan ne, ");
INSERT INTO cutNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","cuihco ndah ne vedino me chihto na̱n ta, ne dinoca ca̱hn ne nda̱ca ne che nchahco nunde ihyan min, cuenedin ndah ne ndudo nduco ye. Tuhme co ca̱h ne vedino yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Me ndete che va ihyan che nahn ca̱ca nunde ye yahn nchuhn ne, codin nun ino ne cuenedin ndah ne ndudo nduco ye numanahn che metah ca̱ca nunde ye yahn ne, te ndete che hua ne, ca̱hco ye nchuhn ta̱h intiyahn. Intiyahn ne, ca̱hcantiyon ye policía che tihyon se nchuhn va̱coya̱hn, ");
INSERT INTO cutNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ne cua̱co rá̱hn rí nchuhn te min cuahtenun ne nde cuihno nedihve ne nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nchuhn ne, a devano ne te ihyan ndico yahn ne chicuahn ye tuhca̱: “Hua ndere conen nduco nda̱hta che hua nihneva̱co ndoque.” ");
INSERT INTO cutNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ate u ne, rá̱hn rí nchuhn te adecoduhno ihyan che ndihchero ye a̱ma nda̱hta, ne ndedecadino ye che nahn conan ye nduco te ne, nduco chemin a quendihco ye nunde nduco te na̱n Dendiohs, te anduhneca̱ ndete che a quenan ye nduco te. ");
INSERT INTO cutNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Ndete che ca̱va a̱ma ndutina̱n nchuhn adeche denda ne, cuahtendihco ne nunde ne, hua tumaca̱h ne yahn. Codin ne cuande anduhneca̱ ndete che a tico ne chaconda̱h ne, te tahque ndah che conda a̱ma ndutina̱n ne yodemin ca che cuahtenun ne va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndete che ca̱va a̱ma ta̱h nchuhn adeche denda ne, cuahtendihco ne nunde ne, hua tumaca̱h ne yahn. Codin ne cuande anduhneca̱ ndete che a chihca ne chaconda̱h ne, te tahque ndah che conda a̱ma ta̱h ne yodemin ca che cuahtenun ne va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Nchuhn ne, a devano ne te chicuahn ihyan ndico yahn ne tuhca̱: “Adecoduhno ihyan che nahn tehche ye nda̱hta yahn ye ne, va che dirun ye a̱ma ca̱ca, ca̱h ye ta̱hn na̱n che ca̱hco ro ye che a ntehche ye ta̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ate u ne, rá̱hn rí nchuhn te co tehche ihyan nda̱hta yahn ye atena̱n ndete che conan te nduco ta̱ma cha̱hn, te ndete che ndere tehche ye ta̱hn ne, cuahn che cuhnde te nduco ta̱ma se ne, a ma̱n ye quendihco ye nunde. Namin adecoduhno ihyan che cahneva̱co ye nduco a̱ma nda̱hta che ntehche incha̱hn te ta̱hn ne, condihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Nchuhn ne, a devano ne te chicuahn ihyan ndico yahn ne tuhca̱: “Hua ndere cah ndudo yehn Dihve Dendiohs, te va che dinehn nducuahn ndudo yehn che cah.” ");
INSERT INTO cutNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ate u ne, rá̱hn rí nchuhn te hua ca̱h ne ndudo yahn ne, ntihyon ya̱n ne Dendiohs. Namin hua ntihyon ya̱n ne vahchetero, te min quenan ye rihquentiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nde hua ntihyon ya̱n ne muhn iyehnse, te quenan ye numachahte. Nde hua ntihyon ya̱n ne Jerusalén, te ya̱n yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nde hua ntihyon ya̱n ne tin ne, te nde a̱ma yudo tin ne ne, metah vederihquentiyon yahn ne che ca̱hcantiyon ne che ndacorun color yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cuahn che ca̱h ne ndudo yahn ne ne, hua ntihyon ya̱n ne nde a̱ma na̱n dehtenduh. A̱ma no ndudo ca̱hma ne, a tihca̱, a o hua tihca̱, te che rentihdenan ca ne ndudo ca̱va che cotahno ihyan ne, chundah rihquentiyon se chemin. ");
INSERT INTO cutNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Nchuhn ne, a devano ne te chicuahn ihyan ndico yahn ne tuhca̱: “Adecodehno nunde che din ihyan ne, a nunde min no va che nuhnde menun yahn ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ate u ne, rá̱hn rí nchuhn te hua da̱ma co ne nduco ihyan che din ta̱n ye nduco ne. Ndete che va ihyan che cuahn ye a̱ma la̱do va̱cona̱n ne ne, ndotenan che da̱ma co ne nduco ye ne, cuahnecun ne che cuahn ye ta̱ma la̱do. ");
INSERT INTO cutNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ndete che va ihyan che ca̱ca nunde ye yahn ne, nahn cahnevi cahteca ne ne, ca̱h ne nde cahteca tu yahn ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ndete che ta̱hn nun sanda̱do nchuhn yune, ca̱hcantiyon se che quendehde ne chede yahn se nduhneva che rihquentiyon ley ne, nde chuhnan ca cuiquendehde ne yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Adecoduhno ihyan che ca̱ca ye dehtenduh yahn nchuhn, a nahn yahn ye, o nahn tumanan no ye ne, ca̱h ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Nchuhn ne, a devano ne te chicuahn ihyan ndico yahn ne tuhca̱: “Codin yahine ihyan che yahino ye di, ne codin tan nduco ihyan che redin ta̱n ye ndoque.” ");
INSERT INTO cutNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ate u ne, rá̱hn rí nchuhn: Codin yahino ne ihyan che rendihche ta̱n ye nchuhn ma̱n, cuica ne Dendiohs che din ye che ndah nduco ihyan che ra̱hva ye yahn ne ma̱n, ihyan che rihya ye nchuhn ma̱n, ihyan che redin ta̱n ye nduco ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ndete che tihca̱ din nchuhn ne, da̱ma ri ne nduco Chida ne che va ye vahchetero, te ihyan min ne, redin ye che rendihco dave yahn ya̱hn ma̱n, redin ye che ran co ma̱n, ca̱va che ndah yahn ihyan che ndah ihyan ye ma̱n, ihyan che duhtuno ihyan ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ndete che atena̱n ihyan che yahino ye nchuhn din yahino ne ne, ¿dehra cochihve yahn ne?, te nde sa̱hn rica tume ca̱de iyo tihca̱ redin se. ");
INSERT INTO cutNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Namin ndete che atena̱n combiero yahn ne neca̱h ne Dendiohs ihyan ne, ¿dehra cochihve yahn ne?, te nde ihyan che hua devano ye che va Dendiohs tihca̱ redin ye. ");
INSERT INTO cutNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nchuhn ne, nahn che runeca̱de ne nduhca̱ che runeca̱de Chida ne che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Cuihco nchuhn cuda̱do che hua din ne dehtenduh che ndah atena̱n ca̱va che ndihchero ihyan, te ndete che ca̱va che ndeva ihyan yavena̱n ne che tihca̱ din ne ne, nde hua cochihve yahn ne na̱n Chida ne che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chemin che cuahn che din ne vedeva̱hino ne, co din ne cuande che hua cadino nde a̱ma ihyan. Hua da̱ma co ne nduco sa̱hn che o na̱n o chende se che redin se vedeva̱hino na̱n nducoya̱ca ihyan, chete ya̱co ma̱n, cua̱hn yune ma̱n. Sa̱hn chahn ne, tihca̱ redin se ca̱va che ndonan ihyan sa̱hn, ate cua̱co rá̱hn rí nchuhn te nde hua cochihve yahn se na̱n Dendiohs che tihca̱ redin se. ");
INSERT INTO cutNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Ndaconan rá̱hn rí nchuhn te cuahn che din ne vedeva̱hino ne, co din ne cuande che hua cadino nde a̱ma ihyan, ca̱va che Chida ne che rendihche ye nducuahn che redin ne ne, nda̱hco menun ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Nchuhn ne, cuahn che cova̱h ne ne, hua din ne nduhca̱ che redin sa̱hn che o na̱n o chende se che renan ino se rahtendi se reva̱h se chete ya̱co ma̱n, cua̱hn yune ma̱n, na̱n che co ndihchero nducoya̱ca ihyan sa̱hn. Cua̱co rá̱hn rí nchuhn te nde hua cochihve yahn se na̱n Dendiohs che tihca̱ redin se. ");
INSERT INTO cutNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cuahn che cova̱h nchuhn ne, codin ne cuande che hua va̱n ya̱hn ihyan. Tahque ndah che dema̱n ne cova̱h ne chete vah na̱n che dema̱n Chida ne cahnevan ye. Cuedevano ne te rendihchero ye nchuhn, ne nda̱hco menun ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Cuahn che cova̱h nchuhn ne, hua din ne nduhca̱ che redin ihyan che hua devano ye che va Dendiohs. A̱ma ndeh reva̱h ye na̱n dehtenduh che redin ye dendiohs yahn ye, te ra̱hco ye te nduco che a̱ma ndeh reva̱h ye ne, cahnevan dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Hua da̱ma co ne nduco ye na̱n che reva̱h ne, te Chida ne ne, nde ura che ametah ca̱ca ne ihyan ne, a devano ye nducuahn dehtenduh che rendotenan ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chemin che cova̱h nchuhn tuhca̱: Chida nuhn che va ne vahchetero, Rica nuhn ndih che din ne che ndeva nducoya̱ca ihyan yavena̱n ne, co devano ye che metah nde a̱ma nunde na̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Rica nuhn ndih che cuana̱n ca̱hcantiyon ne nuhn. Nahn nuhn che dinahn ihyan iyehnse vederihquentiyon yahn ne nduhca̱ che redinahn ángel che vate ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cuete ne che cheh nuhn ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cuenchahco ne nunde yahn nuhn nduhca̱ che renchahco ma̱n nuhn yahn ihyan che redin ta̱n ye nduco nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Cuendedevahn ne nuhn ta̱h chundah, hua cuahnecun ne che tumarande se nuhn. Tihca̱, te a ndih che rihquentiyon ne cuahn da̱ma. A̱ma yudo vederihquentiyon quenan cuma ne. Tihca̱ co. ");
INSERT INTO cutNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Cuedevano nchuhn te ndete che nchahco ne yahn ihyan che redin ta̱n ye nduco ne ne, namin Chida ne che va ye vahchetero nchahco ye nunde yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ate ndete hua nchahco ne yahn ihyan ne, namin Chida ne che va ye vahchetero ne, hua nchahco ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Nchuhn ne, cuahn che cuahte ne ya̱hte ne, hua din ne nduhca̱ che redin sa̱hn che o na̱n o chende se. Sa̱hn chahn ne, ndih ra̱n va̱cona̱n se ca̱va che cadino ihyan che vate se ya̱hte. Cua̱co rá̱hn rí nchuhn te nde hua cochihve yahn se na̱n Dendiohs che tihca̱ redin se. ");
INSERT INTO cutNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cuahn che cuahte nchuhn ya̱hte ne, cua̱hco na̱n ne ma̱n, cuih ne ca̱ca tin ne ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ca̱va che nde hua cadino ihyan che vate ne ya̱hte. Chida ne a devano ye, te rendihchero ye nchuhn, ne nda̱hco menun ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Hua cua̱hcora̱n nchuhn ca̱va vedecuihca che a chemin no din da̱ma ne. Hua regu, te rine iteduhn ma̱n, reh dache ma̱n, renda̱ sa̱hn duco, riquenda se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tahque ndah ne, codin nun ino ne ca̱va che cuahtenan ne vahchetero, te chemin ne, anduhneca̱ a̱ma vedecuihca che hua redetoh iteduhn ma̱n, hua reh dache ma̱n, hua riquenda sa̱hn duco ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nahn che tihca̱ din nchuhn. A devano ne te na̱n che va vedecuihca ne, a yahn chemin no che rendedecadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","’Ndutina̱n nchuhn ne, nduhca̱ a̱ma ya̱hn che richihve yahn ne che ri ro na̱n ne. Ndete che ndah ndutina̱n ne ne, ndah ro na̱n ne. Ate ndete che hua ne, anduhneca̱ ndete che man na̱n che vate ne. Atihnoca̱ vederendedecadino yahn ne, te ndete che cochihve ne, conahn ndah ne vederihquentiyon yahn Dendiohs. Ate ndete che cuahcota̱hn ne vederihquentiyon yahn ye ne, hua cochihve vederendedecadino yahn ne, ne anduhneca̱ ndete che a̱ma man na̱n che vate ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nde a̱ma ihyan ne, hua co cuahtenan cuma ye o dihve ye da̱mandahn, te din yahino ye a̱ma, ne ca̱hcoma̱n ye ta̱ma, o dinahn ye yahn a̱ma, ne cuahcota̱hn ye yahn ta̱ma. Atihnoca̱ nchuhn, te hua co din yahino ne Dendiohs ndete che yahino ne vedecuihca. ");
INSERT INTO cutNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Rá̱hn rí nchuhn: Hua cua̱hcora̱n ne deh cheh ne ma̱n, deh cuh ne ma̱n, ti nda̱ca ne tino che cuahtenun ne ma̱n. A Dendiohs che deco ye nchuhn iyehnse, ne te ye che cheh ne ma̱n, tino che cuahtenun ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cua cuande nchuhn. Ya̱hda ne, andahre hua rendotenan che din te nduhca̱ che redin ihyan che rino ye nda̱ta ma̱n, rentumanan ye ndute nda̱ta ma̱n, rih ndah ye ma̱n, ate Chida ne che va ye vahchetero ne, redin ye che renda̱ca te che reh te. Cuedevano ne te tahque redin ye cuda̱do nchuhn che co ite chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nde a̱ma nchuhn, andahre a̱ma ndedecadino ne, ate hua co din ma̱n ne che cuihta ne ma̱hn metro. ");
INSERT INTO cutNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Nde hua redin yahn che ndedecadino nchuhn ti ngua ne tino che cuahtenun ne. Cua cuande ne. Na̱nda ne, hua rendotenan che din nduhca̱ che redin ihyan che redin ye ntiyon ma̱n, riya ye tino ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ne rá̱hn rí nchuhn te nde rey Salomón andahre a̱ma chahte vederihquentiyon quenan cuma ye, ate tahque ndah chan ro na̱nda che co tino che quenun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nchuhn che ndeh rendedecadino ne ca̱va ne, nducote redin Dendiohs che a̱ma ndah chan ro na̱nda andahre a̱ma o ro ra regu, cuedevano ne te tahque redin ye cuda̱do nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chemin che hua nahn che a̱ma ndedecadino ne deh cheh ne ma̱n, deh cuh ne ma̱n, ti ngua ne tino yahn ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ihyan che nde hua devano che va Dendiohs ne, a̱ma rendedecadino ye yahn dehtenduh chemin chan. Ate nchuhn ne, va Chida ne vahchetero che redin ye cuda̱do nchuhn, ne a devano ye yahn dehtenduh che rendotenan ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mena̱n vihca cuahnecun ne che ca̱hcantiyon ye nchuhn ma̱n, runeca̱de cuahtechica ne nduhca̱ che nahn ye ma̱n, ne te ye nducuahn dehtenduh chemin chan che rendotenan ne. ");
INSERT INTO cutNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chemin che hua ndedecadino nchuhn ta̱ca̱ cuahno co ne caviya̱n deman, te queri a̱ma ro ne, va vedera̱hn yahn ne, ne hua redin yahn che cua̱hcora̱n ne ta̱ca̱ cuahno co ne. ");
INSERT INTO cutNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Hua nda̱hchenan nchuhn ihyan ca̱va che hua din Dendiohs castigo nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nduhca̱ che nda̱hchenan ne ihyan ne, tihca̱ cua cuande Dendiohs nchuhn, din ye castigo nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ndete che nda̱hchenan ne a̱ma ihyan yahn dehtenduh che hua nda̱hca̱ redin ye, ate nde hua retumacadino ne che va dehtenduh che tahque chihnga̱ redin ma̱n ne ne, anduhneca̱ ndete che a̱ma vihto quenun ndutina̱n ne nde hua retumacadino ne yahn, ate renda̱hchenan ne ihyan che quenun a̱ma ya̱ca ndutina̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndete che ya̱hve ne a̱ma ihyan che hua nda̱hca̱ redin ye cuahn che nde tahque chihnga̱ redin ma̱n ne ne, anduhneca̱ ndete che ca̱hma ne co ne ihyan che tenda̱h ne ya̱ca che quenun ndutina̱n ye cuahn che quenun a̱ma vihto ndutina̱n ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ndete che tihca̱ din nchuhn ne, o na̱n o chende ne. Nahn che dinoca ca̱hcoma̱n ne dehtenduh che tahque chihnga̱ redin ne, tuhme cona̱n yahn ne che ya̱hve ne ihyan che ca̱hcoma̱n ye dehtenduh che hua nda̱hca̱ redin ye. ");
INSERT INTO cutNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Nde hua redin yahn che ndere ya̱hve nchuhn ihyan che cheche chedave yahn ye ca̱va che nevahnecun ye ndudo ndah yahn Dendiohs, te dena̱n co ta̱n ye nduco ne ma̱n, duche rino ye ndudo me ma̱n. Ndete che ndere ya̱hve ne ihyan chemin chan ne, anduhneca̱ ndete che ca̱h ne dehtenduh che ndah ya̱hna, ne dena̱n co ta̱n te, cua te nchuhn ma̱n, anduhneca̱ ndete che cahneta̱ve ne tu diya̱hn na̱n cuche, ne condinun condina̱hno te ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","’Cuica nchuhn dehtenduh che nahn ne Dendiohs, ne te ye nchuhn. Tihca̱, te anduhneca̱ che redin ma̱n ne. Cuahn che rica ne dehtenduh combiero yahn ne ne, rete ye. Cuahn che renuhn ne dehtenduh ne, renda̱ca ne. Cuahn che riya̱hve ne chende va̱co ihyan ne, rena̱hne ye. ");
INSERT INTO cutNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Nde a̱ma nchuhn ne, hua rahcota̱hn ne yahn da̱ya ne cuahn che rica che cheh. Ndete che rica pa̱n ne, hua rihquino ne reca̱h ne tu. ");
INSERT INTO cutNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ndete che rica yute ya̱hca ne, hua reca̱h ne a̱ma cu. ");
INSERT INTO cutNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nchuhn ne, andahre duhtuno ihyan ne ne, reca̱h ne dehtenduh che ndah da̱ya ne. Rá̱hn rí nchuhn te Chida ne che va ye vahchetero ne, nde tahque nun te ye dehtenduh che ndah cuahn che ca̱ca ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Codin nchuhn che ndah nduco ihyan nduhca̱ che nahn ne che din ye nduco ne, te tihca̱ rihquentiyon na̱n ley che dirun Moisés ma̱n, libro che dirun ihyan profeta ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","’Andahre a̱ma va̱hche cuahno nchuhn, ate codin ne fuerza ca̱hcoma̱n ne vedeyeno yahn ma̱n ne, codinahn ne vederihquentiyon yahn Dendiohs, ca̱va che co tuno ne vahchetero. Rá̱hn rí nchuhn te neve ra ihyan che tuno ye min, ne anduhneca̱ ndete che a̱ma tuhco chendevah na̱n che conda̱ ye ma̱n, a̱ma va̱hche yune na̱n che chuh ye ma̱n. Me ihyan che riquendi ye vedeyeno yahn ma̱n ye ne, a̱ma ya̱hn ye. Ihyan chahn ne, anduhneca̱ ndete che a̱ma chahte chendevah na̱n che renda̱ ye ma̱n, a̱ma nda̱hca̱ yune na̱n che rechuh ye ma̱n, ate cuahn che cuhnde ca̱de yahn ye ne, co ye castigo, cuahtenun ye va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Rá̱hn rí nchuhn che ca̱hco ne cuda̱do yahn sa̱hn che redin ca̱ se che Dendiohs dechuh ye sa̱hn. Sa̱hn chahn ne, redin ca̱ se che a̱ma necun se, ate a̱ma duhtuno ihyan se. ");
INSERT INTO cutNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nchuhn ne, ca̱hco ne cuda̱do nducuahn che redin se, ne tumacadino ne duh ihyan se. A devano nchuhn te ndiyu na̱n ya̱hn ya̱n che ri uva, nde huane na̱n chano ya̱n che ri higo. ");
INSERT INTO cutNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ya̱hn nda̱ta che ndah ne, ndah ndute yahn, ne ya̱hn che hua ndah ne, hua ndah ndute yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Atihnoca̱ sa̱hn chahn, te na̱n ntiyon yahn se ne, tumacadino nchuhn ndete che numa cua̱co vatechica se o rihncheh se. Nducuahn ya̱hn che hua ndah ndute yahn ne, rihca ihyan, rihquiya̱hn ye. Atihnoca̱ sa̱hn chahn, te va che co se castigo, cuahtenun se va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Hua nducoya̱ca ihyan che ra̱hn ye yáhn che Dihve ye u, cuahtenan ye vahchetero, te atena̱n ihyan che dinahn ye vederihquentiyon yahn Chidá, ihyan min che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Cuahn che cuhnde ca̱de yahn nducoya̱ca ihyan ne, a̱ma ya̱hn ihyan ca̱hma ye yáhn: “Dihve nuhn, nuhn ne, din nuhn ntiyon yahn ne, ntihyon ya̱n nuhn ndih, ne nduco chemin ndetenda̱h nuhn vaco chihnga̱ ma̱n, din nuhn a̱ma ndeh na̱n vederihno ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ate ca̱hmá có sa̱hn chahn: “Ndiyu ihyan yáhn nchuhn. Cuahn ne a̱ma la̱do. Nchuhn ne, duhtuno ihyan ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Adecoduhno ihyan che rihcovan ye ndudo che tuhchan che ricuáhn, ne dinahn ye ne, ihyan min ne, nduhca̱ a̱ma ihyan che vivo ye che chihno ye va̱co ye, chihco ye na̱me yahn na̱n ya̱va. ");
INSERT INTO cutNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chihno min ne, a̱ma chi yudo, chan co na̱hn ma̱n, chihta ico ma̱n, chano yune ma̱n. Chuh nune na̱n nti vah me, ate hua dehva chi yahn, te chiche nti na̱n ya̱va. ");
INSERT INTO cutNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Me adecoduhno ihyan che rihnevan ye ndudo che tuhchan che ricuáhn, ne hua dinahn ye ne, ihyan min ne, nduhca̱ a̱ma ihyan tundo che chihno ye va̱co ye ma̱n ya̱hndute. ");
INSERT INTO cutNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chihno min ne, a̱ma chi yudo, chan co na̱hn ma̱n, chano yune ma̱n, chihta ico ma̱n. Chuh nune na̱n nti vah me, ne quenda. ");
INSERT INTO cutNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cuahn che chihno chicuahn Dihvo vo ne, a̱ma chahn ino ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","te numacuahn vederihquentiyon yahn Dendiohs chicuahn ye, ndlyu nduhca̱ che ricuahn sa̱hn devano ley che dlrun Moisés. ");
INSERT INTO cutNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuahn che ndaconan Dihvo vo che chahn ye tingüete me ne, a̱ma ya̱hn ihyan nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ura min nda̱ a̱ma sa̱hn che ndi se cah che recha̱ yute, chehntihya se na̱n ye, ne ra̱hn se ri se ihyan: ―Dihvé, ndete che nahn ne ne, co din ne che ndoyáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tuhme nahn ta̱h ye sa̱hn, ne ra̱hn ye: ―Ta̱ca̱ hua. Náhn. Ma̱n ne, a ndoyehn. Ndeta̱hno che ra̱hn ye tihca̱ ne, ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tuhme ra̱hn ye ri ye sa̱hn: ―Culhque cuda̱do. Hua cahme nduco nde a̱ma ihyan ta̱ca̱ chi che ndoyehn. Tahque ndah ne, cuehn na̱n chidocuya̱n, ndihchero ye di, ne cah vedino nduhca̱ che chihquentiyon Moisés ca̱va che co devano nducoya̱ca ihyan che a ndoyehn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Cuahn che chenda̱ Dihvo vo ya̱n Capernaum ne, a̱ma capitá̱n yahn Roma, chica se favor ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ne ra̱hn se: ―Dihvé, sa̱hn deca̱hya yáhn ne, ndi cheche se, ametah cocha se. ");
INSERT INTO cutNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ra̱hn Dihvo vo ri ye sa̱hn: ―Cuhn vo ndoque, dín che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ate ra̱hn sa̱hn capitá̱n me ri se ihyan: ―Dihvé, hua denduh ne ndih ca̱va no u, te u ne, ndiyu ihyan che redin yahn che ca̱hn ne ndeva̱có. Nduco a̱ma ndudo che ca̱hma ne ne, ndoyahn sa̱hn deca̱hya yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tihca̱, te namin u ne, va ihyan che nte ye vederihquentiyon quenan cumá, ne vate sanda̱do yáhn. Cuahn che rihquentiyón a̱ma se che ca̱hn se ne, rahn se. Cuahn che rihquentiyón ta̱ma che chi se ne, rechi se. Adecodehno che rihquentiyón sa̱hn deca̱hya yáhn ne, redinahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","A̱ma cuahn ino Dihvo vo che tihca̱ ra̱hn se, ne ra̱hn ye nduco ihyan che nduco ye: ―Cua̱co rá̱hn rí nchuhn te nde va̱n ihyan nación yahn Israel ne, hua nda̱cá nde a̱ma ihyan che a̱ma ritahno ye nduhca̱ sa̱hnguh. ");
INSERT INTO cutNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Rá̱hn rí nchuhn te a̱ma ya̱hn ihyan numachahte iyehnse conduco ye Abraham ma̱n, Isaac ma̱n, Jacob ma̱n, cuahtenan ye nduco vih vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ate ihyan che tahque redin yahn che cuahtenan ye vahchetero na̱n che rihquentiyon Dendiohs ne, ndotenan che cuahtenan ye min ne, dechuh Dendiohs ihyan cua̱hn chevah na̱n che man, ne min cuahtenun ye, cuaco ye ma̱n, cheh dihyon ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tuhme ra̱hn ye ri ye capitá̱n me: ―Conahn ndevaque, ne nduhca̱ che chitehne ne, tihca̱ conahn ndoque. Me sa̱hn deca̱hya me ne, a ura min no ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","A̱ma yune ne, chahn Dihvo vo Jesucristo ndeva̱co Pedro, ne inda̱hn Pedro ne, quendite ye, ndi ye cah ihno. ");
INSERT INTO cutNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nahn ta̱h ye ta̱h ihyan min, ne ndoyahn ye, chavi cah ihno me. Tuhme necuan ye, ne ca̱h ye, cheh ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ro min, cuahn che chi da̱h ne, a̱ma ya̱hn ihyan nda̱ ye na̱n Dihvo vo, nda ye ihyan cah ma̱n, ihyan che chenun vaco chihnga̱ ihyan ma̱n. Dihvo vo ne, nduco a̱ma ndudo no ndetenda̱h ye vaco chihnga̱ chahn. Namin din ye che ndoyahn ihyan cah chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tihca̱ chi ca̱va che conahn nduhca̱ che dirun ihyan profeta Isaías tuhca̱: “Ma̱n ye cahnevi ye cah yahn ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cuahn che ndihchero Dihvo vo che a̱ma ya̱hn ihyan nduco ye ne, chihquentiyon ye ihyan apóstol yahn ye che cuahtenun ye chete a̱ma ba̱rco, chuh ye nduco vih ta̱ma la̱do viche yahn vine yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ura min a̱ma sa̱hn devano ley che dirun Moisés chahn nda̱ se na̱n Dihvo vo, ne ra̱hn se ri se ihyan: ―Ihyan Ricuahn, nahn conducó ndih adecotino che ca̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Yuhne ne, va ive va̱co te, ne ya̱hda ne, va na̱n che rahte te, ate u che rinducó nducoya̱ca ihyan ne, metah nde na̱n che condité. ");
INSERT INTO cutNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tuhme ta̱ma sa̱hn che rinduco se ihyan ne, ra̱hn se ri se ihyan: ―Dihvé, cuahnecun ne che conán na̱n chidá nde nda̱ ro che coh ye. Cuhché ihyan, tuhme conducó ndih. ");
INSERT INTO cutNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ate ndahconan Dihvo vo yahn se: ―Di ne, nahn che condoque u. Hua ndedecadine ca̱va chemin. Ihyan che anduhneca̱ ndete che a ndih ye na̱n Dendiohs ne, ihyan chahn co cuhche ye tena̱hn yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chihno min ne, chenda̱ Dihvo vo chete ba̱rco me nduco ihyan apóstol yahn ye, cuahn ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ura min cana̱n rano yuhne ta̱n, a̱ma rendedecuan nune na̱n vine me nde a renda̱ chete ba̱rco me. Me Dihvo vo ne, quiya̱do ye. ");
INSERT INTO cutNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tuhme ndedetuhche ihyan apóstol chahn ihyan, ne ra̱hn ye: ―Dihve nuhn, ¡cuendedevahn ne nuhn!, te cuehchenun nuhn va̱n nune. ");
INSERT INTO cutNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ndahconan Dihvo vo: ―¿Dehco che a̱ma va̱h nchuhn? ¿Ta̱ca̱ che hua numa ino ne ritahno ne? Tuhme necuan ye, chihco dihn ye yuhne me ma̱n, vine me ma̱n, ne nuhnde dihn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nduco neve se va̱n ihyan chahn, ne ra̱hn se: ―¿Duhra ihyan cuh che nde yuhne ma̱n, nde vine ma̱n, redinahn che rihquentiyon ye? ");
INSERT INTO cutNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Cuahn che nda̱ Dihvo vo ta̱ma la̱do viche yahn vine me, ya̱hn yahn ya̱n Gadara ne, nda̱ o sa̱hn che chenun vaco chihnga̱ sa̱hn, che chica se va̱n ya̱yan na̱n che chenun tena̱hn. A̱ma redin ta̱n se che nde a̱ma ihyan hua rihquino ye chuh ye yune nino na̱n che chenun se. ");
INSERT INTO cutNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A̱ma yudo na̱n se ra̱hn se: ―Jesús, Da̱ya Dendiohs, ¿dehco che renun menda̱hn ne yune yahn nuhn? ¿Ta̱ca̱ che cochi ne din ne che chuhrihn nuhn?, te ametah nda̱ ro yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nino min ne, redin ihyan cuda̱do a̱ma ya̱hn cuche. ");
INSERT INTO cutNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Vaco chihnga̱ chahn ne, chica favor Dihvo vo, ne ra̱hn ri ihyan: ―Ndete che ndetenda̱h ne nuhn ne, cuahnecun ne che conda̱ nuhn cuche sih. ");
INSERT INTO cutNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ra̱hn Dihvo vo ri ye vaco chihnga̱ chahn: ―Cuahn nchuhn. Tuhme ndiquenda̱h vaco chihnga̱ chahn sa̱hn, ne chenda̱ cuche chahn. Nducoya̱ca cuche chahn ne, cochahn te rano te na̱n ndava, cheranun te chete vine me, chihno chih te. ");
INSERT INTO cutNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sa̱hn che redin cuda̱do cuche chahn ne, a̱ma dihya se chi, ne cona̱hn se rano se cua̱hn viya̱n me. Nda̱ se min ne, neco se ihyan nduhca̱ che chihno chih cuche chahn ma̱n, deh chi yahn sa̱hn che chenun vaco chihnga̱ chahn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tuhme chahn nducoya̱ca ihyan ya̱n na̱n che quenun Dihvo vo, ne chica ye favor ihyan che nda̱ca ye min, na̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chihno me min ne, chenda̱ Dihvo vo chete ba̱rco, tuche ye vine me, nta̱ ye ya̱n va̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Min nda̱ ihyan na̱n ye, nda ye a̱ma sa̱hn che ndi cheche se quendite se na̱n yundo. Cuahn che ndihche Dihvo vo nduhca̱ che ritahno ihyan chahn ne, ra̱hn ye ri ye sa̱hn che ndi cheche me: ―Da̱yá, hua dehve rahque, a ndaque vederenchahco ca̱va nunde yehn. ");
INSERT INTO cutNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Min chenun va̱n a̱ma o sa̱hn devano ley che dirun Moisés, ne rendedecadino se: “Sa̱hn tih ne, ducherino se Dendiohs che tihca̱ ra̱hn se.” ");
INSERT INTO cutNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ndeta̱hno checadino Dihvo vo che tihca̱ rendedecadino sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―¿Dehco che chihnga̱ rendedecadino nchuhn? ");
INSERT INTO cutNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ndete che ca̱hmá có sa̱hnguh: “A nchahcó nunde yehn” ne, nde hua co devano ne ndete che va vederihquentiyon yáhn, o hua. Ate ndete che ca̱hmá có sa̱hn: “Cuenecuen, ne cuique” ne, co devano ne. ");
INSERT INTO cutNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Chemin che ca̱va che cadino ne che u che rinducó nducoya̱ca ihyan ne, quenan cumá vederihquentiyon che nchahcó nunde yahn ihyan ne, condihche ne. Tuhme ra̱hn ye nduco sa̱hn che ndi cheche me: ―Cuenecuen, cotah yundo yehn, conahn ndevaque. ");
INSERT INTO cutNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndeta̱hno necuan sa̱hn min, ne cona̱hn se ndeva̱co se. ");
INSERT INTO cutNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nducoya̱ca ihyan che chenun ye min ne, dihya ye chi, ne ndeva ye yavena̱n Dendiohs yahn che neca̱h ye vederihquentiyon min Dihvo vo ca̱va che ndah yahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Cuahn che chica Dihvo vo min, cuahn ye ne, ndihchero ye a̱ma ihyan che duche ye Mateo. Ihyan min ne, quenan ye ntiyon che rica ye tume ca̱de iyo, ne ra̱hn ye ri ye ihyan: ―Cuhn vo, condoque u. Tuhme necuan Mateo, cuahn ye chinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A̱ma yune ne, reh Dihvo vo nduco ihyan apóstol yahn ye. Namin nduco a̱ma ya̱hn sa̱hn rica tume ca̱de iyo ma̱n, ya̱hn ca sa̱hn nunde ma̱n, vate se reh se nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ndihchero a̱ma o sa̱hn fariseo, ne ra̱hn se ri se ihyan apóstol chahn: ―¿Dehco che tihca̱ redin Ihyan Ricuahn yahn nchuhn che reh ye da̱ma nduco sa̱hn rica tume ca̱de iyo ma̱n, sa̱hn nunde chena̱hn ma̱n? ");
INSERT INTO cutNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","13","Chihnevan Dihvo vo che tihca̱ ra̱hn se, ne ra̱hn ye ri ye sa̱hn: ―Ihyan cah che rendotenan ye sa̱hn doctor, ndiyu ihyan che hua cah ye. Atihnoca̱ u, te ndá̱ ca̱va che conán ihyan nunde, nto ino ye nunde yahn ye, ndiyu ca̱va ihyan metah nunde yahn ye che ra̱hco ye. Che va che din nchuhn ne, cuahn ne dinahn ne vederihquentiyon yahn Dendiohs che tuhca̱: “Tahque náhn che cuahtenan cuma nchuhn vedeva̱hino che co che ca̱hno ne ite, co te vedino ná̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ura min ne, nda̱ a̱ma o ihyan che rinduco ye Jua̱n Bautista, ne ra̱hn ye ri ye Dihvo vo: ―Nuhn nduco sa̱hn fariseo cuahn da̱ma rahte nuhn ya̱hte. ¿Dehco che ihyan che rinduco ye ndih hua rahte ye ya̱hte ne? ");
INSERT INTO cutNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ndahconan Dihvo vo yahn ye: ―Ihyan che rinduco ye sa̱hn rihneva̱co ne, hua rahtera̱n ye. Ate ndete che quenda ihyan sa̱hn ne, cuahtera̱n ye. Atihnoca̱ ihyan che rinduco ye u, te ma̱n ro cuh ne, metah deh cuande che cuahte ye ya̱hte. Ate cuahn che nda̱ ro che quenda sa̱hn nunde u ne, tuhme che cua̱co, cuahte ye ya̱hte. ");
INSERT INTO cutNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Hua redin yahn che ndahcheta̱hn vo costumbre ndico nduco vederihquentiyon ra. Nde a̱ma ihyan hua reneca̱hnan ye a̱ma ndi tino ra na̱n tino ndico, te ndete che tihca̱ din ye ne, ndeva doh tino ra me, ne nde tahque co chahte na̱n nte yahn tino ndico me. ");
INSERT INTO cutNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Namin nde a̱ma ihyan hua rih ye vino ra chete ima ndico, te ndete che tihca̱ din ye ne, condan ima ndico me, cora vino me, ne conda nduh che o. Chemin che va che cuih ihyan vino ra chete ima ra ca̱va che hua dehva co yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Numanahn che rente ca Dihvo vo nduco ihyan chahn ne, nda̱ a̱ma sa̱hn ndina̱n. Chehntihya se na̱n ye, ne ra̱hn se ri se ihyan: ―Ta̱hn da̱yá ne, a chih te cade mena̱n lihn. Cuhn vo nduco ne, nahn ta̱h ne ta̱hn, ne ndaconan conan te. ");
INSERT INTO cutNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tuhme necuan ndi Dihvo vo, ne cuahn ye nduco se nduco ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ura min nda̱ a̱ma ta̱hn nda̱hta che a ri ndichio nduyo che cah te, rendora te yun ro ro. Chahn nda̱ te cuahn veda̱me Dihvo vo, ne nahn ta̱h te tino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tihca̱ din te, te ndedecadino te: “Mare tino yahn ye nahn tá̱h, ne ndoyáhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ndaconan ye ndihchero ye ta̱hn, ne ra̱hn ye: ―Da̱yá, hua dehve rahque. Nducote chitehne ne, a ndoyehn. A ura min no ndoyahn te. ");
INSERT INTO cutNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Cuahn che nda̱ Dihvo vo va̱co sa̱hn ndina̱n me ne, ndihchero ye che a chenan sa̱hn retive ndo ra̱n ma̱n, a̱ma ndito ihyan rah ra̱n ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ra̱hn ye ri ye ihyan chahn: ―Cona̱hn nchuhn, te ta̱hn dihn ne, hua dehve ndih te, quiya̱do te. Ate chihyon nan ihyan chahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chihquentiyon ye che ndiquenda̱h vah ihyan chahn, tuhme chenda̱ ye na̱n che quendite ta̱hn dihn me. Cheta̱h ye ta̱h te, ne necuan te. ");
INSERT INTO cutNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nducoya̱ca ihyan che vate ye numachahte ya̱hn min ne, checadino ye yahn vederihno min. ");
INSERT INTO cutNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Cuahn che cona̱hn Dihvo vo ne, cuahn o sa̱hn na̱n ve cua̱hn veda̱me ye rah se: ―Da̱ya David, ¡conan va̱hino ne nuhn! ");
INSERT INTO cutNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cuahn che nta̱ ye, ndonda̱ ye chete vah ne, chenda̱ vah sa̱hn na̱n ve chahn, chahn nda̱ se na̱n ye, ne tumerune ye sa̱hn: ―¿A ritahno nchuhn che co dín che co ro na̱n ne ne? Ndahconan se yahn ye: ―Dihve nuhn, ritahno nuhn che co din ne che co ro na̱n nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tuhme nahn ta̱h ye ndutina̱n se, ne ra̱hn ye ri ye sa̱hn: ―Conahn nduco nchuhn nduhca̱ che ritahno ne. ");
INSERT INTO cutNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A ndeta̱hno chi ro na̱n sa̱hn chahn. Tuhme a̱ma ca̱h ye cuda̱do sa̱hn, ne ra̱hn ye ri ye sa̱hn: ―Condi nchuhn ca̱hma ne nduco nde a̱ma ihyan ta̱ca̱ chi che chi ro na̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ate cade nda̱ca se min, cana̱n nte se nduco ihyan, ne chetuhn ndudo yahn vederihno min va̱n ihyan che vate ye numachahte ya̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cade ndiquenda̱h sa̱hn chahn vah ne, nda̱ a̱ma o ihyan, nda ye a̱ma sa̱hn lihme che quenun a̱ma vaco chihnga̱ sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ndetenda̱h Dihvo vo vaco chihnga̱ me, ne ndeta̱hno ndiquenda̱h ca̱hn se, cana̱n rente se. A̱ma cuahn ino ihyan, ne ra̱hn ye: ―Nde menahn ametah conahn vederihno che tuhchan muhn nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ate sa̱hn fariseo ne, ra̱hn se: ―Ihyan tih ne, quenan cuma ye vederihquentiyon yahn chundah, ne nduco chemin rendetenda̱h ye vaco chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chihno min ne, quechica Dihvo vo nduh cua̱n ya̱n rahte ma̱n, ya̱n ca̱hya ma̱n, ricuahn ye chete ya̱co yahn ihyan nación yahn Israel. Rahndudo ye ndudo yahn vederihquentiyon yahn Dendiohs, ne redin ye che rendoyahn nducoya̱ca ihyan cah. ");
INSERT INTO cutNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nduh cua̱n na̱n che quechica ye ne, a̱ma ya̱hn ihyan. A̱ma quenan va̱hino ye ihyan, te ametah duh che cacuahn vederihquentiyon yahn Dendiohs ihyan. Nduhca̱ itecuche che metah ihyan che din ye cuda̱do ite, tihchan ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tuhme ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―Cua̱co rá̱hn rí nchuhn te a̱ma ya̱hn ihyan che nahn cahnevan ye ndudo yahn Dendiohs, ate ihyan che rahndudo ye ne, a̱ma doh ri ye. Anduhneca̱ ndete che a̱ma va ndute nda̱ta ate ihyan che redin ye ntiyon ne, a̱ma doh ri ye. ");
INSERT INTO cutNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Chemin che cuica nchuhn Dendiohs ca̱va che dechuh ye ihyan che cuahndudo ye ndudo yahn ye, cahnevan ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chihno min ne, nedin da̱ma Dihvo vo nduh che ndichio ihyan apóstol yahn ye, ne ca̱h ye vederihquentiyon ihyan ca̱va che ndetenda̱h ye vaco chihnga̱ ma̱n, din ye che ndoyahn ihyan cah, adecodehno cah che ndi ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Va̱n ihyan chahn ne, nduco a̱ma ihyan che duche ye Simón Pedro, ihyan min che tahque mena̱n vihca va̱n nducoya̱ca ye. Namin nduco Andrés, dihno Simón ma̱n, Jacobo nduco dihno ye, Jua̱n, che da̱ya Zebedeo ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe ma̱n, Bartolomé ma̱n, Tomás ma̱n, Mateo, ihyan min che rica ye tume ca̱de iyo ro mena̱n ma̱n, Jacobo, da̱ya Alfeo ma̱n, Lebeo, che namin duche ye Tadeo ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ta̱ma Simón, ihyan min che chinduco ye partido yahn sa̱hn cananista ro mena̱n ma̱n, Judas Iscariote, ihyan min che neca̱h ye Dihvo vo adive ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dechuh Dihvo vo ihyan che ndichio chahn, chihquentiyon ye ihyan tuhca̱: ―Hua cuahndudo nchuhn va̱n ihyan ta̱ma nación, nde huane va̱n ihyan nación yahn Samaria. ");
INSERT INTO cutNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Tahque ndah ne, cuahndudo ne va̱n ihyan nación yahn Israel, ihyan chahn che a ndihcoma̱n ye Dendiohs. Ihyan chahn ne, anduhneca̱ itecuche che a chinda te. ");
INSERT INTO cutNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cuahndudo nchuhn te Dendiohs, ihyan min che va ye vahchetero ne, a nun ca̱hcantiyon ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Codin nchuhn che ndoyahn ihyan che ndi ye cah che recha̱ yute ma̱n, ihyan che ndi ye adecodehno cah ma̱n, condedetuhche ne ihyan che a ndih ye ma̱n, cuendetenda̱h ne vaco chihnga̱ ma̱n. Nchuhn ne, denda̱ca ne vederihquentiyon cuh, ne hua cua ne chihve yahn ihyan che conan ne. ");
INSERT INTO cutNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Hua quenda nchuhn tume, ");
INSERT INTO cutNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nde hua quenda ne dino ma̱n, nda̱co ma̱n, inda̱hco ma̱n, atena̱n tino che chenun no ne. Tihca̱, te ihyan redin ntiyon ne, redin yahn che na̱n ntiyon che redin ye quenda̱h nducuahn che rendotenan ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Cuahn che nda̱ nchuhn a̱ma ya̱n ne, cuenuhn ne a̱ma ihyan che ndah ihyan ye, ne cuahtenan ne ndeva̱co ye nde ro che nda̱ca ne ya̱n min. ");
INSERT INTO cutNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuahn che conda̱ nchuhn ne, ca̱hma ne co ne ihyan che va̱co min: “Dendiohs din yahino ye nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ndete che rihneva̱hn che conahn nduco ihyan nduhca̱ che ca̱hma ne, conahn, ate ndete che hua ne, hua. ");
INSERT INTO cutNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Me ndete che ihyan che va̱co min, o ihyan ya̱n min, hua nevahnecun ye nchuhn, nde hua ca̱hcovan ye che ca̱hma ne ne, conda̱ca ne min, conda̱hde ne yune ya̱hn che chenan ca̱h ne ca̱va che tumacadino ye che hua nda̱hca̱ din ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Cua̱co rá̱hn rí nchuhn te nda̱ ro che cuhnde ca̱de yahn nducoya̱ca ihyan ne, tahque chuhrihn ihyan ya̱n min che co ihyan che chahte ye ya̱n Sodoma ma̱n, ya̱n Gomorra ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Cuedevano nchuhn te dechúh nchuhn va̱n ihyan che a̱ma duhtuno ye. Anduhneca̱ ndete che va̱n lobo dechúh itecuche. Nahn che rino na̱n nchuhn ma̱n, necun ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cuihco nchuhn cuda̱do, te ca̱ca nunde ihyan yahn ne na̱n intiyahn ma̱n, cuahn ye nchuhn chete ya̱co ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Quenda ye nchuhn na̱n gobernador ma̱n, na̱n rey ma̱n, ca̱ca nunde ye yahn ne yahn che ritahno ne u. Min ca̱h ne ndudo yahn ne nduhca̱ che ritahno ne u, ne nduco tihca̱ cadino ihyan chahn ma̱n, ihyan nación chena̱hn ma̱n, yahn vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cuahn che conahn ne, hua ndedecadino ne ta̱ca̱ ca̱hmanan ne nchuhn, te nda̱ ura min ne, te Dendiohs ndudo che ca̱hma ne. ");
INSERT INTO cutNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tihca̱, te ndiyu nchuhn che ndedecadino ne deh che va che ca̱hma ne, te Chida ne Dendiohs ne, te vaco ye ndudo che ca̱hma ne. ");
INSERT INTO cutNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Nda̱ ro min ne, a̱ma cuahte ca̱hnda ihyan nduco vih. Na̱hn ye ne, ca̱ca ye che ca̱hno se dihno ye, na̱hn ye ne, ca̱ca ye che ca̱hno se indihte yahn ye, na̱hn ye ne, ca̱ca ye che ca̱hno se da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nducoya̱ca ihyan co ta̱n ye nduco nchuhn yahn che ritahno ne u. Ate adecoduhno ihyan che quenda̱h ye vedechahtino nde cuihno vedeyah min ne, ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cuahn che din ta̱n ihyan nduco nchuhn a̱ma ya̱n ne, cuahn ne ta̱ma ya̱n. Cua̱co rá̱hn rí nchuhn te u che rinducó nducoya̱ca ihyan ne, ndaconan chí cuahn che nde metah conan cuahtechica ne nducuahn ya̱n yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","25","’Ihyan che rahn ne, hua chenan ino ye che tahque nda̱hca̱ cuahno ye che co ihyan ricuahn yahn ye. Tahque ndah ne, rihco da̱ma ino ye che cuahno ye nduhca̱ che a rahno ihyan ricuahn yahn ye. Namin ihyan redin ntiyon ne, hua chenan ino ye che tahque nda̱hca̱ cuahno ye che co patrón yahn ye. Tahque ndah ne, rihco da̱ma ino ye che cuahno ye nduhca̱ che rahno patrón yahn ye. U che rihquentiyón nchuhn, nducote renda̱hchenan ihyan u, ra̱hn ye te quenan cumá vederihquentiyon yahn chundah, tahque ca nchuhn, nde tahque nda̱hchenan ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Nducote a devano nchuhn te tihca̱ va che cuahno co ne ne, hua din va̱h ne ihyan. Cuedevano ne te nducuahn che ri cuahn ndeh ne, va che cadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nducuahn che rá̱hn nduco nchuhn cua̱hn dema̱n vo ne, cuahndudo ne, ca̱h ne che cadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hua din va̱h ne ihyan che nahn ca̱hno ye nchuhn, te cuihno min ne, ametah dehva che co din ye. Tahque ndah ne, codin va̱h ne Dendiohs, te ihyan min ne, co dechuh ye nchuhn va̱n ruchiya̱hn, co ne castigo cua̱hn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ihyan ne, rino ye ya̱hda ca̱hya anduhneca̱ ndete che nde hua rigonun chihve te, te ra ye a̱ma centa̱vo no na̱n che o te. Ate nde a̱ma ya̱hda lihn ne, hua coh te ndete che Chida nchuhn che va ye vahchetero hua cuahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Me nchuhn ne, tahque nda cuande ye nchuhn. Nde yudo tin ne nedin cuande ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chemin che hua cua ne cuda̱do. Tahque rigonun chihve ne che co ya̱hda ca̱hya. ");
INSERT INTO cutNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Nducoya̱ca ihyan che numa ino ye ritahno ye u na̱n ihyan iyehnse ne, numacuahn vedeyeno ndevá ihyan na̱n Chidá che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ate ihyan che cua̱conda̱h veda̱me ye u ne, cua̱conda̱h veda̱mé ihyan na̱n Chidá che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","’Hua ndedecadino nchuhn che ma̱n che ndá̱ ne, hua cuahte ca̱hnda ihyan, te ihyan che ritahno ye u ne, cuahte ca̱hnda ihyan nduco ye. Ihyan ne, cuahte ca̱hnda ye nduco chida ye ma̱n, ta̱hn ca̱hya ne, cuahte ca̱hnda te nduco chaco te ma̱n, ta̱hn decuno ihyan ne, cuahte ca̱hnda te nduco inda̱hn te ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tihca̱ va che cuahte ca̱hnda ihyan va̱n ihyan yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ihyan che hua rihco da̱ma ino ye cotahno ye u, yahn che hua nahn ye che co ta̱n indihte yahn ye nduco ye ne, ihyan chahn ne, nde hua redin yahn che din cuandé ihyan va̱n ihyan yáhn. Namin ihyan che hua rihco da̱ma ino ye cotahno ye u, yahn che hua nahn ye che co ta̱n da̱ya ye nduco ye ne, nde hua redin yahn che din cuandé ihyan va̱n ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Adecoduhno ihyan che rihco da̱ma ino ye cotahno ye u andahre nde va che conan ya̱h ye na̱n cruz, atena̱n ihyan min redin yahn che din cuandé ihyan va̱n ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ihyan che cuaconda̱h veda̱me ye u, che nahn ndedevahn ma̱n ye ihyan ne, conda ye, ne ihyan che hua cuaconda̱h veda̱me ye u ne, andahre ca̱hno se ihyan, ate cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Ihyan che renevahnecun ye nchuhn ne, a u renevahnecun ye, ne ihyan che renevahnecun ye u ne, a Ihyan che dechuh ye u renevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ihyan che renevahnecun ye a̱ma ihyan che rahndudo ye ndudo yahn Dendiohs yahn che redin ye ntiyon min ne, ndeva Dendiohs a̱ma ta̱ma ye. A namin no tun ihyan che renevahnecun ye a̱ma ihyan che ndah ihyan ye ne, ndeva Dendiohs a̱ma ta̱ma ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ihyan che ritahno ye u ne, hua nduh rigonun chihve ye che la̱do yahn ihyan, ate adecoduhno ihyan che ca̱h ye andahre a̱ma va̱so nune, cuh ihyan chahn ne, nda̱hco menun Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Cuahn che chihno ca̱h cuande Dihvo vo nduh che ndichio ihyan apóstol yahn ye ne, chica ye min cuahn ye, cacuahn ye ma̱n, cuahndudo ye ma̱n, nduh cua̱n ya̱n che nino min. ");
INSERT INTO cutNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ta̱hn min ne, quenun Jua̱n Bautista va̱coya̱hn, ne cuahn che checadino ye yahn dehtenduh che redin Dihvo vo ne, dechuh ye o ihyan che rinduco ye ihyan na̱n Dihvo vo, ");
INSERT INTO cutNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","tumerune ye: ―¿A ndih ihyan che a va ca̱de chi ye ndedevahn ye ihyan iyehnse, o coma̱n va che chi ihyan min ne? ");
INSERT INTO cutNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Cuahn nchuhn cuengo ne Jua̱n nducuahn che rendihchero ne ma̱n, rihnevan ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ca̱h ne che cadino ye nduhca̱ che redín che ri ro na̱n ihyan che ve ma̱n ye ma̱n, redín che rica ihyan che neneva doh ca̱h ye ma̱n, redín che rendoyahn ihyan che ndi ye cah che recha̱ yute ma̱n, redín che ihyan che chato ye rihnevan ma̱n, redín che rentuche ihyan che a ndih ye ma̱n, rahndudó ndudo ndah yahn Dendiohs, rihnevan ihyan che ri nda̱che ye yahn nunde yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rá̱hn rí nchuhn te a̱ma ndah ro yahn ihyan che riquendi ye numa ino ye ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Cuahn che a cona̱hn ihyan chahn ne, cana̱n rente Dihvo vo nduco ihyan che chenun ye min yahn Jua̱n, ne ra̱hn ye: ―¿Duh che chahn nchuhn chendihchero ne min ya̱hn ne na̱n che metah duhva ne? A devano ne te ndiyu a̱ma ihyan che ran do ye, che anduhneca̱ a̱ma nduco che a muhn a min redecuehte yuhne. ");
INSERT INTO cutNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Duh chahn nchuhn chendihchero ne ne? A devano ne te ndiyu a̱ma ihyan che a̱ma ninevaca tino ndah, te ihyan chemin chan ne, ndeva̱co rey chenun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A devano nchuhn te chahn ne, chendihchero ne a̱ma ihyan profeta. Cua̱co rá̱hn rí nchuhn te ihyan min che tahque chahte vederihquentiyon quenan cuma ye va̱n ihyan profeta. ");
INSERT INTO cutNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","A yahn ihyan min che ra̱hn Dendiohs, ndirun na̱n Ndudo yahn ye tuhca̱: Dechúh a̱ma se numanahn che metah cahn, ca̱hcoya̱n se chedave yahn ihyan ca̱va che a vate ya̱n ye cuahn che nda. ");
INSERT INTO cutNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Cua̱co rá̱hn rí nchuhn te va̱n nducoya̱ca ihyan che chahte ye iyehnse nde a ra̱hn me nde meniyon ne, Jua̱n Bautista che tahque chahte vederihquentiyon quenan cuma ye. Ate va̱n ihyan che renevahnecun ye vederihquentiyon che nda̱hco ca̱de Dendiohs ne, nde ihyan che tahque doh vederihquentiyon quenan cuma ye ne, tahque chahte vederihquentiyon yahn ye che co vederihquentiyon che quenan cuma Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Nde ro che cana̱n Jua̱n ntiyon yahn ye nde meniyon ne, a̱ma redin nun ino ihyan ca̱va che tuno ye vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moisés ma̱n, nducoya̱ca ihyan profeta, nde na̱n che cana̱n, nde nda̱ Jua̱n Bautista ma̱n, dirun ye yahn vederihquentiyon ra che nda̱hco ca̱de Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Cuedevano nchuhn te che ndirun na̱n Ndudo yahn Dendiohs che ndaconan chi tun Elías ne, a Jua̱n Bautista nda̱ ye, dinahn vederihquentiyon min, andahre hua nahn cotahno ne. ");
INSERT INTO cutNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nducoya̱ca nchuhn ne, cuihcovan ndah ne che tihca̱ rá̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","’Nchuhn che vate ne ma̱n ro cuh ne, nduhchan sa̱hn ca̱hya che reduche se ndihve, tihchan ne. Sa̱hn chahn ne, ra̱hn se ri se combiero yahn se: “Tive nuhn curetive, ate hua ca̱h yeno nchuhn, ndeh ne. Chita ra̱n nuhn, ate hua chaco ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nduhchan sa̱hn chahn, tihchan ne, te nda̱ Jua̱n Bautista, ne a̱ma va̱h na̱n cheh na̱n chih ye, ne ra̱hn nchuhn te quenun vaco chihnga̱ ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A namin no tun cuahn che nda̱ u che rinducó nducoya̱ca ihyan. Réh ma̱n, ríh ma̱n, da̱ma nduco ihyan che rahte vihco ye, ne ra̱hn ihyan: “Sa̱hn tih ne, a̱ma reh se ma̱n, a̱ma rih se ma̱n, rinduco se sa̱hn rica tume ca̱de iyo ma̱n, sa̱hn nunde chena̱hn ma̱n.” Renda̱hchenan ihyan ntiyon che redin nuhn, ate hua dehve din yahn, te ihyan che renahn ye ne, a devano ye che vededevano yahn Dendiohs ne, chemin che tahque ndah. ");
INSERT INTO cutNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Chihno min ne, nte Dihvo vo yahn ihyan ya̱n na̱n che tahque din ye vederihno, te ihyan chahn ne, hua nahn nto ino ye nunde yahn ye. Ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Nchuhn ihyan ya̱n Corazín ma̱n, ihyan ya̱n Betsaida ma̱n, ¡a̱ma vedin nchuhn!, te ndete che ihyan ya̱n Tiro ma̱n, ihyan ya̱n Sidón ma̱n, ndihchero ye vederihno che ndihchero nchuhn ne, a metah ro nto ino ye nunde yahn ye, chahtenun ye tino ndere, chahtera̱n ye va̱n iya. ");
INSERT INTO cutNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Rá̱hn ri nchuhn te nda̱ ro che cuhnde ca̱de yahn nducoya̱ca ihyan ne, nde tahque chahte castigo co nchuhn che co ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Me nchuhn ihyan ya̱n Capernaum ne, a̱ma redin ya̱de ne anduhneca̱ ndete che nde vahchetero tuno ne che ra̱hco ne, ate va che ca̱hn ne va̱n ruchiya̱hn, te ndete che ya̱n Sodoma dín vederihno nduhca̱ che dín ya̱n va̱co ne ne, chitahno ihyan chahn, ne vate ca ye nde meniyon. ");
INSERT INTO cutNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Rá̱hn rí nchuhn te ro che cuhnde ca̱de yahn nducoya̱ca ihyan ne, tahque chahte castigo co nchuhn che co ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tuhme cova̱h Dihvo vo, ne ra̱hn ye: ―Chida má̱n, ndih che rihquentiyon ne vahchetero ma̱n, iyehnse ma̱n, rendevá yavena̱n ne, te a ihyan che necun ye ca̱h ne che cadino ye vededevano yahn ne, ndiyu ihyan che a̱ma devano ye che ra̱hco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tihca̱ Chidá, te tihca̱ nahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tuhme rá̱hn Dihvo vo ri ye ihyan che chenun ye min: ―Chidá ne, nda̱hco ye vederihquentiyon tá̱h che ca̱hcantiyón nducuahn dehtenduh. Nde a̱ma ihyan hua rendihche ye u, te atena̱n Chidá che rendihche ye u. Namin nde a̱ma ihyan hua rendihche ye Chidá, te atena̱n u, nduco ihyan che má̱n ricuáhn ihyan ta̱ca̱ ye, che rendihche nuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nducoya̱ca nchuhn che rechuhrihn ne, hua va ma̱n chedave yahn ne, cochahtino ne u, ne dín che cuahtema̱n chedave yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Codinahn ne vederihquentiyon yáhn, ne cuiquendi ne yune yáhn, te u ne, necún. Tuhme cuahtema̱n chedave yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tihca̱ din nchuhn, te hua va̱hche ca̱va ne che dinahn ne vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chihno a̱ma o ro min, a̱ma ro che rahtetuhno ihyan ne, chuh Dihvo vo na̱n va chenda̱ta yahn ihyan, ne ihyan apóstol ne, chi cuico ye, ne tuhn ye indo trigo, cheh ye ndute yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ndihchero a̱ma o sa̱hn fariseo, ne ra̱hn se ri se Dihvo vo: ―Condihche ne ihyan apóstol yahn ne. Hua nda̱hca̱ che tihca̱ redin ye ma̱n ro cuh, te ma̱n ne, ro che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ate ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―A ndihchenan nchuhn na̱n Ndudo yahn Dendiohs nduhca̱ che din David ro min cuahn che chi cuico ye nduco combiero yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Chenda̱ ihyan chahn chete ya̱co, cheh ye pa̱n che ndi vedino na̱n Dendiohs andahre pa̱n chemin chan ne, atena̱n chidocuya̱n co cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Namin a devano nchuhn nduhca̱ che rihquentiyon ley che dirun Moisés. Hua dehve nunde che redin chidocuya̱n ntiyon chete ya̱co ro che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nducote va vederihquentiyon che din chidocuya̱n ntiyon chete ya̱co ro che rahtetuhno ihyan ne, cuedevano ne te hua dehve nunde che tihca̱ redin ihyan apóstol yáhn ro che rahtetuhno ihyan, te vederihquentiyon che quenan cumá ne, tahque chahte che co vederihquentiyon min. ");
INSERT INTO cutNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nchuhn ne, nde hua renahn ne ndudo yahn Dendiohs che ndirun tuhca̱: “Tahque náhn che cuahtenan cuma nchuhn vedeva̱hino che co che ca̱hno ne ite, co te vedino ná̱n.” Ndete che renahn nchuhn ndudo min ne, nde hua ndere ca̱hma nunde ne yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Cuedevano ne te u che rinducó nducoya̱ca ihyan ne, rihquentiyón nde nducuahn che redin ihyan ro che rahtetuhno ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chuh Dihvo vo min, ne chenda̱ ye chete a̱ma ya̱co yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Min quenun a̱ma sa̱hn che ndi cuma a̱ma ta̱h se. Namin min chenun a̱ma o sa̱hn fariseo, ne nducote nahn ca̱ca nunde se yahn Dihvo vo ne, tumerune se ihyan: ―¿A rihquentiyon na̱n Ndudo yahn Dendiohs che co din vo che ndoyahn ihyan ro che rahtetuhno vo ne? ");
INSERT INTO cutNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Ndete che va itecuche yahn nchuhn ne conda̱hnun te chete veh ico ro che rahtetuhno ihyan ne, ndeta̱hno ca̱hn ne ndetenda̱h ne ite. ");
INSERT INTO cutNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nducote tahque rigonun chihve a̱ma ihyan che co itecuche ne, chemin che co conan vo ihyan andahre ro che rahtetuhno vo. ");
INSERT INTO cutNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tuhme ra̱hn ye ri ye sa̱hn min: ―Cua̱condihque tah. Chacondihco ta̱h se, ne ndo ndah nduhca̱ ta̱h se che ta̱ma me. ");
INSERT INTO cutNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ndeta̱hno quenda̱h vah sa̱hn fariseo chahn rentuhno se nduco vih ta̱ca̱ ca̱hno se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Checadino Dihvo vo che tihca̱ rentuhno se, ne chica ye min, cuahn ye. A̱ma ya̱hn ihyan cuahn ye nduco ye, ne din ye che ndoyahn nducoya̱ca ihyan che cah ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chihquentiyon Dihvo vo che hua ca̱hma ihyan chahn che a ihyan min che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tihca̱ din ye ca̱va che conahn ndudo che ra̱hn Dendiohs yahn ye, dirun ihyan profeta Isaías tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Sa̱hnguh che redin se ntiyon yáhn, a má̱n tenda̱hnún sa̱hn. A̱ma yahinó sa̱hn, a̱ma yenó ca̱va se. Dín che conun Vacó sa̱hn, ne cuahndudo se va̱n ihyan nación chena̱hn nduhca̱ che va che techeca̱dé yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hua cuhma chende se nduco ihyan, nde huane cuah nun se na̱n ye, ca̱hya se ihyan. Hua cochica se yune viya̱n cuahndudo se. ");
INSERT INTO cutNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hua ca̱h nda̱che nduh se ihyan che nda̱che ri ye yahn nunde yahn ye. Tahque ndah se ne, neca̱h se vedechahtino ihyan. Tihca̱ quendi se nde conan ca̱hcantiyon se numachahte iyehnse, ");
INSERT INTO cutNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ne ihyan nación chena̱hn ne, cochahtino ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chihno min ne, nda̱ ihyan na̱n Dihvo vo, nda ye a̱ma sa̱hn che quenun vaco chihnga̱ sa̱hn. Sa̱hn min ne, nde ve se nde lihme se. Ndetenda̱h Dihvo vo vaco chihnga̱ me, ne chi ro na̱n se ma̱n, chi ca̱hn se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chahn ino nducoya̱ca ihyan, ne ra̱hn ye: ―¿A din ndete che ihyan cuh che da̱ya David ne? ");
INSERT INTO cutNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ate chihnevan a̱ma o sa̱hn fariseo, ne ra̱hn se: ―Ihyan tih ne, quenan cuma ye vederihquentiyon yahn chundah, ne nduco chemin rendetenda̱h ye vaco chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","A checadino Dihvo vo che tihca̱ ra̱hn se, ne ra̱hn ye ri ye sa̱hn: ―Ndete ihyan che vate ye rihquentiyon ye cuahtecuhma ye va̱n ma̱n ye nduco vih ne, hua co quendi ye ca̱hcantiyon ye. Ndete intiyahn ya̱n cuahtecuhma ye va̱n ma̱n ye nduco vih ne, hua co quendi ye ca̱hcantiyon ye. Ndete ihyan che chenun ye a̱ma vah cuahtecuhma ye va va̱n ma̱n ye nduco vih ne, hua co quendi ye cuahtenun da̱ma ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A namin no tun chundah. Ndete che ndetenda̱h se vaco chihnga̱ yahn se ne, anduhneca̱ ndete che cuhma se nduco ihyan yahn se, ne hua co quendi vederihquentiyon yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nchuhn ne, ra̱hn ne che nduco vederihquentiyon yahn chundah che rendetendá̱h vaco chihnga̱, ate sa̱hn che rinduco se nchuhn ne, nducote rendotenan se duh che conan sa̱hn ca̱va che ndetenda̱h se vaco chihnga ne, co ca̱hma se co se nchuhn che hua cua̱co che ra̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Cuedevano nchuhn te a nduco vederihquentiyon yahn Vaco Ndah yahn Dendiohs rendetendá̱h vaco chihnga̱. Nduco chemin ne, a ndero ndi che a rihquentiyon Dendiohs va̱n nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’A̱ma sa̱hn dito ne, atena̱n ndete che dechiche ihyan sa̱hn co conda̱ ye chete va̱co se, duco ye yahn se. U ne, anduhneca̱ ndete che tihca̱ dín nduco chundah, nda̱hco ndiyá vederihquentiyon yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Ihyan che hua rinduco ye u ne, anduhneca̱ ndete che ta̱n ye nducó. Ntiyon che redín ne, anduhneca̱ ndete che renedin da̱má ndute nda̱ta, ne ihyan che hua rinduco ye u ne, anduhneca̱ ndete che rihtera ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Nducote ra̱hn nchuhn yáhn che quenan cumá vederihquentiyon yahn chundah ne, chemin che rá̱hn rí nchuhn che va vederenchahco ca̱va ihyan adecodehno nunde yahn ye ma̱n, che chihnga̱ ca̱hma ye ma̱n, ate ihyan che renda̱hchenan ye Vaco Ndah yahn Dendiohs ne, metah vederenchahco ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Adecoduhno ihyan che nda̱hchenan ye u che rinducó nducoya̱ca ihyan ne, va vederenchahco ca̱va ye, ate ihyan che nda̱hchenan ye Vaco Ndah yahn Dendiohs ne, hua nda̱ca ye vederenchahco. ");
INSERT INTO cutNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ya̱hn nda̱ta ne, a na̱n ndute yahn rihnde ro ndete che ndah o hua ndah. Ya̱hn nda̱ta che ndah ndute yahn ne, ya̱hn ndah, ne ya̱hn nda̱ta che chihnga̱ ndute yahn ne, hua ndah. Cua cuande nchuhn yahn ejemplo cuh, te hua redin yahn che nda̱hchenan ne vederihquentiyon che quenan cumá cuahn che a ro na̱n ne che ntiyon cochihve redín. ");
INSERT INTO cutNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","35","¡A̱ma duhtuno ihyan nchuhn! A ndero ndi na̱n ndudo yahn ne. Ihyan che ndah ihyan ye ne, runeca̱de na̱n ndudo yahn ye, ne ihyan che duhtuno ihyan ye ne, chihnga̱ ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Rá̱hn rí nchuhn te ca̱va nducuahn ndudo chihnga̱ che ra̱hn ihyan ne, va che din Dendiohs castigo ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ihyan che runeca̱de ndudo yahn ye ne, hua co ye castigo, ne ihyan che chihnga̱ ndudo yahn ye ne, co ye castigo. ");
INSERT INTO cutNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tuhme ra̱hn a̱ma o sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n: ―Ihyan Ricuahn, nahn nuhn che din ne a̱ma vederihno ndihchero nuhn ca̱va che co devano nuhn che Dendiohs dechuh ye ndih. ");
INSERT INTO cutNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Ihyan che vate ye ma̱n ro cuh ne, a̱ma duhtuno ihyan ye ma̱n, rahcota̱hn ye yahn Dendiohs ma̱n. Nahn ndihchero ye vederihno, ate atena̱n a̱ma vederihno nduhca̱ che chinahn nduco ihyan profeta Jonás nda̱ca ndihchero ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","A̱ma ite ndico che quenun te va̱n nuniya̱hn ne, ca tuhn te ihyan min, ne quenun ye chete te ino ro ino ya̱n. Atihnoca̱ u che rinducó nducoya̱ca ihyan va che conún ma̱n ya̱hn ino ro ino ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Rá̱hn rí nchuhn te cuahn che nda̱ ro che techeca̱de Dendiohs yahn nducoya̱ca ihyan ne, necuan ihyan ya̱n Nínive, nda̱hco ndiya ye nchuhn, te ihyan chahn ne, nto ino ye nunde yahn ye cuahn che cahndudo ihyan profeta Jonás ndudo yahn Dendiohs, ate nchuhn ne, nde hua rihcovan ne ndudo yáhn andahre tahque chahte vederihquentiyon quenan cumá che co ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Namin ta̱hn reina che va te cua̱hn ya̱hn ndiya ne, nda̱hco ndiya te nchuhn nda̱ ro min, te ta̱hn min ne, a̱ma yahn chica te, chihnevan te vedevano yahn Salomón, ate nchuhn ne, nde hua rihcovan ne ndudo yáhn andahre tahque chahte vederihquentiyon quenan cumá che co ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Cuahn che rendiquenda̱h vaco chihnga̱ a̱ma ihyan ne, rechica ya̱hn na̱n che metah duhva, renuhn na̱n che conan tahn. Ate cuahn che hua renda̱ca ne, ");
INSERT INTO cutNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","rendaconan, conun ihyan na̱n che a ndiquenda̱h, te ihyan min ne, a nduhca̱ a̱ma vah che va ma̱n, nde tuno ntache ma̱n, necuco ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tuhme rahn regua te ndache combiero yahn che tahque duhtuno ca che co ma̱n, ne rahtenun ihyan min, redin che tahque chuhrihn ye che co ro mena̱n. Tihca̱ cuahno co ihyan che duhtuno ihyan ye che vate ye ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Numanahn che rente ca Dihvo vo nduco ihyan chahn ne, nda̱ chaco ye nduco dihno ye, rinuhn ye ihyan. Chahtendi ye cua̱hn chevah, nahn nte ye nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ra̱hn ihyan ri ye Dihvo vo: ―Nda̱ chaco ne nduco dihno ne, vatendi ye cua̱hn chevah, nahn nte ye nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ate ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan che ra̱hn ye nduco ye: ―Ta̱ca̱ hua. Ihyan ca̱h che chacó ma̱n, ihyan sih che dihnó ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tuhme na̱hma Dihvo vo ihyan che rinduco ye ihyan, ne ra̱hn ye: ―Namin ihyan chuhn ne, anduhneca̱ chacó ma̱n, anduhneca̱ dihnó ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","te nducoya̱ca ihyan che redinahn ye vederihquentiyon yahn Chidá che va ye vahchetero ne, ihyan chahn ne, anduhneca̱ chacó ma̱n, anduhneca̱ cahvé ma̱n, anduhneca̱ dihnó ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ro min ne, quenda̱h vah Dihvo vo cuahn ye chihto vine, ne min chihnde ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","A̱ma ya̱hn ihyan chi da̱ma ye na̱n ye, nde quenan cuma che chihnde ye chete a̱ma ba̱rco che va na̱n vine. ");
INSERT INTO cutNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chicuahn Dihvo vo a̱ma ndeh na̱n dehtenduh ihyan chahn nduco ejemplo. Cana̱n ye tuhca̱: ―A̱ma yune ne, cuahn a̱ma ihyan retuhdo ye ndute nda̱ta. ");
INSERT INTO cutNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cuahn che tuhdo ye ne, chera neve ndute chihto yune, ne nda̱ ya̱hda cheh te. ");
INSERT INTO cutNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Te neve ndute ne, chera va̱n roh, ne nducote hua ya̱no ya̱hn min ne, ndeta̱hno quenda̱h. ");
INSERT INTO cutNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ate cuahn che chi ihno ne, chihno tih, yahn che hua ya̱no nda dihyoduto. ");
INSERT INTO cutNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Te neve ndute ne, chera va̱n chano ya̱n. Ate cuahn che quenda̱h ne, chendih, ne chenun ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Te neve ndute ne, chera na̱n che dema̱n ya̱hn, ne a̱ma ndah chi yahn; na̱hn ne, chi a̱ma ciento yahn, na̱hn ne, chi ino raco yahn, ne na̱hn ne, chi ndico ndiche yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nducoya̱ca nchuhn ne, condedecadino ndah ne ca̱va che tumacadino ne deh conahn. ");
INSERT INTO cutNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tuhme chahn nda̱ ihyan apóstol na̱n Dihvo vo, ne tumerune ye ihyan: ―Dihve nuhn, ¿deh cuande che nduco ejemplo rente ne nduco ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Nduhca̱ che rihquentiyon Dendiohs ne, nde hua devano ihyan, ate nchuhn ne, din Dendiohs che cadino ne yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tihca̱ te, ihyan che chenahn ye ne, din Dendiohs che conahn ndah ye, ne ihyan che hua ndah chenahn ye ne, nde cona̱n ye tah che chenahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Chemin che nduco ejemplo rahndudó, rihnevan ye, ca̱va che cahnevan no ye ate hua conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tihca̱ rinahn nduco ye nduhca̱ che dirun ihyan profeta Isaias tuhca̱: Ihyan sih ne, rihnevan ye ate hua renahn ye ma̱n, rendihchero ye ate anduhneca̱ ndete che hua ri ro na̱n ye ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","te a̱ma cheche nda̱conda̱ chedave yahn ye, ndi i ye, anduhneca̱ ndete che hua rihnevan ye ma̱n, anduhneca̱ ndete che hua ro na̱n ye ma̱n, anduhneca̱ ndete che hua retumacadino ye ma̱n. Tihca̱ ri yahn ye, te a va che hua neca̱hco ye u, ne hua nchahcó ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Me nchuhn ne, a̱ma ndah ro yahn ne, te renahn ne vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Cua̱co rá̱hn rí nchuhn te nde a ra̱hn me ne, a̱ma ya̱hn ihyan profeta ma̱n, ihyan che runeca̱de ye ma̱n ne, a̱ma chenan ino ye che ndihchero ye che rendihchero nchuhn ma̱n, che cahnevan ye che rihnevan ne ma̱n, ate hua chinahn nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Cuihcovan nchuhn. Tuhca̱ conahn ejemplo yahn ihyan che retuhdo ye ndute nda̱ta me. ");
INSERT INTO cutNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ndute nda̱ta che chera chihto yune me ne, nduhca̱ ihyan che rihnevan ye ndudo yahn vederihquentiyon yahn Dendiohs, ne hua renun ino ye, te ndeta̱hno che rihnevan ye ne, renda̱ chundah, redin se che rina̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndute che chera va̱n roh me ne, nduhca̱ ihyan che rihnevan ye ndudo, ne numacuahn vedeyeno renevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ate ihyan chahn ne, nduhca̱ chenda̱ta che metah cota̱h ya̱no dihyoduto ne, tihchan ye, te cuahn che rechuhrihn ye o redin ta̱n ihyan nduco ye yahn che renevahnecun ye ndudo me ne, ndeta̱hno rihcoma̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndute che chera va̱n chano ya̱n me ne, nduhca̱ ihyan che rihnevan ye ndudo me, ate a̱ma rendedecadino ye ca̱va ntiyon yahn ye ma̱n, rihncheh ma̱n ye ihyan che a̱ma nahn yahn ye vedecuihca ma̱n, ne chemin che hua ri redin ndudo me che ndah nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Me ndute che chera na̱n che dema̱n ya̱hn me ne, nduhca̱ ihyan che rihnevan ye ndudo me, ne renahn ye. Ihyan chahn ne, nduhca̱ chenda̱ta che chi a̱ma ciento yahn ma̱n, chi ino raco yahn ma̱n, chi ndico ndiche yahn ma̱n ne, tihchan ye, te reca̱h yune ye che redin ndudo me che ndah nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chihno min ne, nte Dihvo vo ta̱ma ejemplo, chihnevan ihyan chahn. Ra̱hn ye: ―Ca̱hmá có nchuhn nduhca̱ vederihquentiyon yahn Dendiohs. A̱ma ihyan ne, tuhdo ye trigo na̱n ya̱hn ya̱hn ye, ");
INSERT INTO cutNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ate chete ra̱hn, ura che vateya̱do ihyan ne, chahn a̱ma sa̱hn che hua ri rendihche se ihyan, ne tuhdo se ndute yahn chano ya̱n va̱n trigo me. ");
INSERT INTO cutNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Cuahn che a chendudo cuiyon ya̱ma trigo me ne, chihnde ro chano ya̱n me va̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tuhme chahn sa̱hn redin ntiyon, chengo se dihve se: “Dihve nuhn, uvo ne, trigo tuhdo vo min. ¿Ta̱ca̱ che a̱ma quenda̱h chano ya̱n ne? ");
INSERT INTO cutNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: “A̱ma sa̱hn che hua ri rendihche se u ne, chahn se tuhdo se ndute chano ya̱n.” Tuhme tumerune se ihyan: “¿A nahn ne che tico nuhn chano ya̱n me ne?” ");
INSERT INTO cutNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: “Hua tico ne chano ya̱n me, te dena̱n nde nduco trigo tico ne. ");
INSERT INTO cutNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tahque ndah ca̱hcoma̱n vo che cuihta da̱ma nduco vih nde nda̱ ro che co cuma trigo me. Tuhme dechúh ihyan che tico ye chano ya̱n me, din ticua ye, cuih ye va̱coya̱hn. Cuihno min ne, din da̱ma ye trigo me, cuih ndah ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Namin nte Dihvo vo ejemplo cuh: ―Vederihquentiyon yahn Dendiohs ne, nduhca̱ a̱ma ndute mosta̱za che chihche ihyan na̱n ya̱hn yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndute mosta̱za ne, andahre chemin che tahque ca̱hya va̱n nducuahn ndute, ate cuahn che rihta ne, ri rahte ya̱hn yahn che nde ya̱hda redin ndahque te va̱n dune. ");
INSERT INTO cutNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nte Dihvo vo ta̱ma ejemplo: ―Vederihquentiyon yahn Dendiohs ne, nduhca̱ tahsihn ya̱ che chihcheta̱hn a̱ma nda̱hta va̱n ndeh ya̱che pa̱n, ne quendih va̱n nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nducuahn ndudo che cahndudo Dihvo vo, chihnevan ihyan ne, dema̱n nduco ejemplo, ");
INSERT INTO cutNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ca̱va che conahn nduhca̱ che dirun ihyan profeta, tuhca̱: Cuahndudó dema̱n ejemplo. Cacuáhn ihyan yahn dehtenduh che nde hua devano ihyan numacuahn ro nde ro che chihnde iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chihno min ne, ndedechuh Dihvo vo nducoya̱ca ihyan, ne ndonda̱ ye vah nduco ihyan apóstol yahn ye. Tuhme ra̱hn ihyan chahn ri ye ihyan: ―Te cuande ne nuhn deh conahn ejemplo yahn chano ya̱n me. ");
INSERT INTO cutNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ndahconan Dihvo vo, ne ca̱h cuande ye ihyan chahn: ―Ihyan che retuhdo ndute nda̱ta me ne, u che rinducó nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ya̱hn me ne, iyehnse. Ndute nda̱ta me ne, ihyan che renevahnecun ye vederihquentiyon yahn Dendiohs. Chano ya̱n me ne, ihyan che rihquentiyon chundah. ");
INSERT INTO cutNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sa̱hn che tuhdo ndute yahn chano ya̱n me ne, chundah. Ro che ndo da̱ma trigo me ne, a ro che cuhnde ca̱de yahn nducoya̱ca ihyan. Ihyan che nedin da̱ma ye trigo me ne, ángel. ");
INSERT INTO cutNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nduhca̱ che ndo da̱ma chano ya̱n me, conun va̱coya̱hn me ne, tihca̱ cuahno co ihyan che duhtuno ihyan ye cuahn che cuhnde ca̱de yahn nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nda̱ ro min ne, u che rinducó nducoya̱ca ihyan ne, dechúh ángel yáhn numachahte na̱n che rihquentiyón, nedin da̱ma ye nducoya̱ca ihyan nunde, mena̱n vihca ihyan che retihyon yune ye ihyan chena̱hn che rahtendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cuih ángel chahn ihyan nunde chahn va̱n ruchiya̱hn. Min cuaco ye ma̱n, cheh dihyon ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Me ihyan che redinahn ye vederihquentiyon yahn Dendiohs, ihyan min che Chida ye ne, quenda̱h yavena̱n ye, cuahtenan ye vahchetero na̱n che rihquentiyon ihyan min. Nducoya̱ca nchuhn, condedecadino ndah ne yahn che renté nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Vederihquentiyon yahn Dendiohs ne, nduhca̱ a̱ma vedecuihca che quenun ndeh ma̱n ya̱hn. A̱ma se ne, nta̱ca se vedecuihca me, ne a min no ndaconan tihyon ndeh se. A̱ma chi yeno se, ne chahn se ndihcue se nducuahn dehtenduh yahn se, ne ca se ya̱hn na̱n che quenun vedecuihca me. ");
INSERT INTO cutNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","’Vederihquentiyon yahn Dendiohs ne, nduhca̱ a̱ma tu diya̱hn che a̱ma nda̱hca̱ ma̱n, che a̱ma yahn chihve ma̱n. Ndihchero a̱ma se che ra se tu chemin chan, ne chahn se ndihcue se nducuahn dehtenduh yahn se, ne ca se tu me. ");
INSERT INTO cutNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Vederihquentiyon yahn Dendiohs ne, nduhca̱ a̱ma ya̱na che reta̱h ya̱hca che tihyon ihyan chete nuniya̱hn, ne cheta̱h ye nducoya̱ca na̱n ya̱hca. ");
INSERT INTO cutNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cuahn che a chito ya̱na me ne, ndetenda̱h ye cua̱hn chihto nuniya̱hn. Min tenda̱hnun ye ya̱hca che ndah te, chih ye ite chete cuahte, ne chihtera ye ite che hua cochihve te. ");
INSERT INTO cutNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tihca̱ va che co ro che techeca̱de Dendiohs yahn nducoya̱ca ihyan. Cuahtechica ángel din vi ye ihyan che duhtuno ihyan ye va̱n ihyan che ndah ye, ");
INSERT INTO cutNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ne cuih ye ihyan che duhtuno ihyan chahn va̱n ruchiya̱hn. Min cuaco ma̱n, cheh dihyon ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tuhme tumerune Dihvo vo ihyan chahn: ―¿A renahn nchuhn nducuahn che renté ne? Ndahconan ihyan chahn, ne ra̱hn ye: ―Ta̱ca̱ hua, Dihve nuhn, renahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―Nducoya̱ca ihyan che retuno ye vederihquentiyon yahn Dendiohs ne, ri ye nduhca̱ ihyan cuihca che retenda̱h ye dehtenduh che ra ma̱n, dehtenduh che ndico ma̱n, va̱n vedecuihca yahn ye, te ihyan chahn ne, a̱ma ndeh na̱n vededevano chenan cuma ye. ");
INSERT INTO cutNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Cuahn che a chihno cahndudo Dihvo vo ejemplo chemin chan ne, chica ye min. ");
INSERT INTO cutNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nta̱ ye ya̱n na̱n che chihta ye, ne chahn ye chete ya̱co chicuahn ye. A̱ma chahn ino ihyan ya̱n min, ne ra̱hn ye: ―¿Ti chehua sa̱hn tih vededevano che ricuahn se? ¿Ta̱ca che ri redin se vederihno? ");
INSERT INTO cutNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Sa̱hn tih che da̱ya vihcheya̱hn me. Chaco se ne, María. Dihno se ne, Jacobo ma̱n, José ma̱n, Simón ma̱n, Judas ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Namin ta̱hn cahve se ne, muhn vate te. ¿Tira chehua se che tihca̱ ricuahn se? ");
INSERT INTO cutNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ihyan chahn ne, hua nevahnecun ye Dihvo vo. Chemin che ra̱hn Dihvo vo ri ye ihyan: ―Ihyan profeta ne, atena̱n ya̱n va̱co ihyan che renevahnecun ye ihyan, te ihyan ya̱n va̱co ye ma̱n, ihyan ndeva̱co ye ma̱n ne, renda̱hchenan ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Dihvo vo ne, atena̱n a̱ma o vederihno din ye min yahn che hua chitahno ihyan chahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ta̱hn min ne, Herodes gobernador yahn Galilea ne, checadino se yahn Dihvo vo Jesucristo, ");
INSERT INTO cutNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ne ra̱hn se ri se sa̱hn che rinan se sa̱hn na̱n che rihquentiyon se: ―Ihyan che redin ye vederihno ne, Jua̱n Bautista. A ntuche ye va̱n tena̱hn, ne chemin che quenan cuma ye vederihquentiyon che redin ye vederihno. ");
INSERT INTO cutNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tihca̱ ra̱hn se, te sa̱hn min din se preso Jua̱n, chihquentiyon se sanda̱do che dechiche se cadena ihyan, tihyon se ihyan va̱coya̱hn. Tihca̱ din se, te tihca̱ nahn Herodías ta̱hn nda̱hta yahn dihno se Felipe. ");
INSERT INTO cutNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jua̱n ne, a ra̱hn ye ri ye Herodes: ―Hua redin yahn che conan come ta̱hn tih nduhca̱ nda̱hta yehn. ");
INSERT INTO cutNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nahn ca̱hno Herodes Jua̱n, ate va̱h se ihyan ya̱n, te nducoya̱ca ye ritahno ye che Dendiohs dechuh ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ate ro che vihco duche Herodes ne, ndeh ta̱hn da̱ya Herodías na̱n ihyan che vate ye min, ne a̱ma quenan ino Herodes. ");
INSERT INTO cutNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Numacuahn vedeyudo ca̱h se ndudo yahn se ta̱hn che adecodehno che ca̱ca te ne, ca̱h se ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nducote a nchinun chaco te ta̱hn ne, ra̱hn te ri te sa̱hn: ―Te ne tin Jua̱n Bautista u chete a̱ma cuh. ");
INSERT INTO cutNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","A̱ma chi ra̱n Herodes che tihca̱ ra̱hn te, ate nducote a ca̱h se ndudo yahn se ta̱hn na̱n nducoya̱ca ihyan che vate min ne, dinahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Chihquentiyon se sanda̱do che chahn se chete va̱coya̱hn, chihca ya̱n se da̱ndo Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ndaconan se, nda se tin Jua̱n chete a̱ma cuh. Ca̱h se ta̱hn, ne neca̱h te chaco te. ");
INSERT INTO cutNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tuhme nda̱ ihyan che rinduco ye Jua̱n, ne quenda ye ihyan chihche ye ihyan. Chihno min ne, chahn ye chengo ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cuahn che checadino Dihvo vo che chihno se Jua̱n ne, chica ye min, quenun ye chete a̱ma ba̱rco cuahn ye a̱ma cua̱n, ya̱hn na̱n che metah duhva. Ate checadino ihyan che cuahn ye, ne chica ye viya̱n, rica ca̱h ye, cuahn ye quendi ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cuahn che ndiquenda̱h Dihvo vo chete ba̱rco me ne, ndihchero ye che a̱ma ya̱hn ihyan ndi da̱ma ye. Quenan va̱hino ye ihyan chahn, ne din ye che ndoyahn ihyan cah che nduco ye min. ");
INSERT INTO cutNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cuahn che a chi chino ne, chahn nda̱ ihyan apóstol na̱n Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Muhn ne, ya̱hn na̱n che metah duhva. Ava̱ne ne, a chino cuahn. Cuendedechuh ne ihyan sih ca̱va che ca̱hn ye ti tenduh ya̱n, cua ye che cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Metah deh cuande che ndedechúh ihyan. Ca̱h nchuhn cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ate ra̱hn ihyan chahn ri ye ihyan: ―Atena̱n uhn ra pa̱n nduco o ya̱hca va yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ra̱hn ye ri ye ihyan chahn: ―Cuahn nchuhn ngua ne. ");
INSERT INTO cutNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tuhme chihquentiyon Dihvo vo che cuahte nducoya̱ca ihyan na̱n yune. Cheta̱h ye nduh che uhn pa̱n me nduco o ya̱hca me quetuhma ye. Chenihyon na̱n ye na̱n ro, neca̱h ye nundihve cuahn Dendiohs, ne ndeh ye pa̱n me, ca̱h ye ihyan apóstol chahn ca̱va che cuih ye va̱n nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Cheh nducoya̱ca ihyan chahn nde na̱n che chito ihyan. Chihno min ne, nedin da̱ma ihyan apóstol chahn che nga̱va, ne decuto ye ndichio cuahte. ");
INSERT INTO cutNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ihyan che cheh ye ne, ri ye uhn mil che dema̱n ihyan cha̱hn, ava̱ne ihyan nda̱hta ma̱n, checa̱hya ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chihno min ne, chihquentiyon Dihvo vo ihyan apóstol che cuahtenun ye chete ba̱rco me, tuche ye ta̱ma la̱do viche yahn vine me numanahn che ndedechuh ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cuahn che chihno ndedechuh ye ihyan chahn ne, cocha ye a̱ma tingüete dema̱n ye ca̱va che cova̱h ye. Cuahn che a chi ra̱hn me ne, quenan ca ye min dema̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Numanahn min ne, a nde ma̱hn vine me cuahn ihyan apóstol chahn nduco ba̱rco me. A̱ma rechi yuhne cua̱hn na̱n cuahn ba̱rco me, ne a̱ma rahn nune vine me. ");
INSERT INTO cutNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cuahn che a nino co dave ne, nda̱ nino Dihvo vo cua̱hn na̱n cuahn ba̱rco me, rica ye na̱n nune. ");
INSERT INTO cutNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cuahn che ndihchero ihyan apóstol chahn ihyan che rica ye na̱n nune me ne, a̱ma dihya ye chi nde tuno cah va̱h ye, ne ra̱hn ye: ―¡Nga̱ a̱ma vaco chihnga̱, cochi ta̱n! ");
INSERT INTO cutNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ate ya̱hve Dihvo vo ihyan chahn, ne ra̱hn ye: ―Hua va̱h nchuhn, te a u che cochí. ");
INSERT INTO cutNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tuhme ra̱hn Pedro ri ye ihyan: ―Dihvé, ndete che ndih ne, cuahnecun ne che ca̱cá na̱n nune, chí na̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ndahconan Dihvo vo, ne ra̱hn ye: ―Cochi. Tuhme cuahn Pedro, rica ye na̱n nune cua̱hn na̱n che cochi Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ate nducote a̱ma ri yudo na̱n vine me ne, chenda̱ vedeva̱h ihyan. Ndeta̱hno cana̱n rehchenun ye va̱n nune, ne cah ye: ―Dihvé, ¡cuendedevahn ne u! ");
INSERT INTO cutNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Cheta̱h Dihvo vo ta̱h ye, ne ra̱hn ye ri ye ihyan: ―Di ne, hua numa ine ritehne. ¿Dehco che ndeh rendedecadine? ");
INSERT INTO cutNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cuahn che chenda̱ ye chete ba̱rco me nduco vih ne, chehuan yuhne me. ");
INSERT INTO cutNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tuhme ihyan che chenun ye chete ba̱rco me ne, chehntihya ye na̱n Dihvo vo ne ra̱hn ye: ―Cua̱co niyon te ndih che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cuahn che a tuche ihyan chahn vine me ne, nda̱ ye ya̱n Genesaret. ");
INSERT INTO cutNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ndeta̱hno nchana̱n ihyan ya̱n min Dihvo vo, chacotuhn ye ndudo numacuahn ya̱hn min. A̱ma chengu ihyan ihyan cah yahn ye na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chica ihyan chahn favor ihyan che cuahnecun ye che nahn ta̱h ihyan cah chahn mare tino yahn ye, ne nducoya̱ca ye che nahn ta̱h ye ne, ndoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chihno min ne, a̱ma o sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés che chica se ya̱n Jerusalén ma̱n, chahn nda̱ se na̱n Dihvo vo, ne ra̱hn se ri se ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Hua nda̱hca̱ che rahcota̱hn ihyan apóstol yahn ne vederihquentiyon yahn ihyan ndico, te reh ye nde hua rena̱no ye ta̱h ye nduhca̱ che chihco ca̱de ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn chahn: ―Me nchuhn ne, hua nda̱hca̱ che rahcota̱hn ne vederihquentiyon yahn Dendiohs, riquendi ne costumbre yahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dendiohs ne, rihquentiyon ye tuhca̱: “Codin yahine chide ma̱n, cheque ye ma̱n.” Namin rihquentiyon ye: “Ihyan che ca̱hva ye yahn indihte yahn ye ne, va che ca̱hno ihyan ya̱n ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ate nchuhn ne, retihyon yune ne ihyan che ca̱hma ye co ye indihte yahn ye: “Hua co conán nchuhn, te nducuahn che va yáhn ne, a cá̱h ndudo yáhn che co vedino na̱n Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nduco tihca̱ ne, retihyon yune ne ihyan che cuaconda̱h veda̱me ye indihte yahn ye. Renda̱hco ndiya nchuhn vederihquentiyon yahn Dendiohs, ricuahn ne costumbre yahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡O na̱n o chende nchuhn! Redinahn niyon ne nduhca̱ che ra̱hn Dendiohs, dirun ihyan profeta Isaías tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ihyan sih ne, dendudo no che rendeva ye yavená̱n, ate nde tah hua ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nde tah hua richihve che rendeva ye yavená̱n, te ricuahn ye vederihquentiyon yahn ma̱n ye, redin ca̱ ye che vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tuhme cah Dihvo vo nducoya̱ca ihyan chahn na̱n ye, ne ra̱hn ye: ―Cuihcovan nchuhn ma̱n, conahn tin ne ma̱n, che ca̱hmá. ");
INSERT INTO cutNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Che chendihco ihyan nunde ne, ndiyu ca̱va dehtenduh che reh ye, te ca̱va ndudo chihnga̱ che rente ye. ");
INSERT INTO cutNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tuhme chahn nda̱ ihyan apóstol, ne ra̱hn ye ri ye ihyan: ―¿A tumacadino ne che chi yudo yahn sa̱hn fariseo sih yahn ndudo che tihca̱ ra̱hn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Nducuahn vederihquentiyon che ndiyu ma̱n Chidá che va ye vahchetero chihco ca̱de ye ne, va che cuihno anduhneca̱ a̱ma ya̱hn che retico ihyan nde dihyoduto. ");
INSERT INTO cutNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Din ca ma̱n se, te sa̱hn sih ne, anduhneca̱ sa̱hn na̱n ve che quendanan se sa̱hn na̱n ve chena̱hn, cora nun nducoya̱ca se chete ive ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ra̱hn Pedro ri ye Dihvo vo: ―Te cuande ne nuhn deh conahn che nte ne yahn che chendihco ihyan nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ndahconan Dihvo vo, ne ra̱hn ye: ―¿Ta̱ca̱ che namin nduco nchuhn hua renahn ne? ");
INSERT INTO cutNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿A hua devano ne te nducuahn che reh ihyan ne, va̱cochendereh yahn ye renun? Chemin ne, rechuh cua̱hn chete ye, ne rendiquenda̱h. ");
INSERT INTO cutNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ate ndudo chihnga̱ che rente ihyan ne, rente ye yahn che chihnga̱ rendedecadino ye, ne nduco chemin chendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tihca̱, te na̱n vederendedecadino yahn ihyan reconan che chihnga̱ rendedecadino ye ma̱n, che rihno ye vih ma̱n, che rahtenan ye nduco nda̱hta che hua nihneva̱co nduco ye ma̱n, che reduco ye ma̱n, che rihncheh ye ma̱n, ndere ricueh da̱me ye nunde ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nunde chemin chan redin che rinda ihyan. Ate che cheh ihyan andahre hua rena̱no ye ta̱h ne, ndiyu nunde chemin. ");
INSERT INTO cutNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chica Dihvo vo min, ne cuahn ye ya̱hn yahn ya̱n Tiro nduco ya̱n Sidon, ");
INSERT INTO cutNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ne a̱ma ta̱hn nda̱ta yahn ihyan cananea, che va te ya̱hn min ne, cuahn te cua̱hn na̱n cuahn ye, ca rica te ca ra̱hn te numa dito te: ―Dihvé, Da̱ya David, conan va̱hino ne u. Ta̱hn da̱yá ne, quenun a̱ma vaco chihnga̱ ta̱hn, ne a̱ma rechuhrihn te. ");
INSERT INTO cutNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ate hua tumeca̱h ye yahn te. Tuhme ra̱hn ihyan apóstol ri ye ihyan: ―Cotumaca̱h ne ta̱hn, te a̱ma rah te cochi te cua̱hn veda̱mo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tuhme ndahconan Dihvo vo, ne ra̱hn ye: ―Dendiohs ne, dechuh ye u ca̱va che conán ihyan nación yahn Israel che a ndinda ye, din nune yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ate ta̱hn min ne, chahn nda̱ te, chehntihya te na̱n ye, ne ra̱hn te ri te ihyan: ―Dihvé, ¡cuinan ne u! ");
INSERT INTO cutNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ra̱hn ye ri ye ta̱hn: ―Hua redin yahn che conán di, te anduhneca̱ ndete che cahneví pa̱n che va che cheh ihyan nación yáhn, cá̱h ya̱hna. ");
INSERT INTO cutNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ndahconan te, ne ra̱hn te: ―Dihvé, cua̱co che ra̱hn ne. Ate ya̱hna ne, namin reh te, te rendeva̱hn te da̱che che ra ma̱n mesa yahn dihve te. Nducote tihca̱ ne, ricá favor ndih che conan ne tah u. ");
INSERT INTO cutNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tuhme ra̱hn ye ri ye ta̱hn: ―Da̱ya, ¡a̱ma numa ine ritehne! Conahn ndoque nduhca̱ che rique. A ura min no ndiquenda̱h vaco chihnga̱ me ta̱hn da̱ya te. ");
INSERT INTO cutNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nda̱ca Dihvo vo min ne, nta̱ ye chihto vine yahn Galilea. Tuhme cocha ye a̱ma tingüete, ne min chihnde ye. ");
INSERT INTO cutNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A̱ma ya̱hn ihyan chi da̱ma ye na̱n ye. Nda ihyan chahn a̱ma ya̱hn ihyan cah, ihyan che cueh ca̱h ye ma̱n, ihyan che neneva doh ta̱h ye ma̱n, ihyan che ve na̱n ye ma̱n, ihyan che lihme ye ma̱n, ya̱hn ca ihyan che ndi ye ta̱ma te o na̱n cah ma̱n, ne din Dihvo vo che ndoyahn nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A̱ma chahn ino ihyan che ndihchero che ndoyahn nducoya̱ca ihyan cah chahn, ne ndeva ye yavena̱n Dendiohs, ihyan min che nda cuande ye ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Chihno min ne, cah Dihvo vo ihyan apóstol yahn ye, ne ra̱hn ye ri ye ihyan: ―A̱ma renan va̱hino ihyan sih, te a ino ro che chenan ye nduco vo, ne metah dehva che cheh ye. Hua nahn ndedechúh ihyan che diya chete ye, te dena̱n cota̱h cuno ihyan cua̱hn yune. ");
INSERT INTO cutNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ra̱hn ihyan apóstol chahn ri ye ihyan: ―Ate muhn ya̱hn na̱n che metah duhva. ¿Ti ngua vo che ca̱h vo cheh ihyan sih?, te a̱ma ya̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tumerune ye ihyan chahn: ―¿Ta̱va pa̱n va yahn nchuhn ne? Ndahconan ihyan chahn: ―Va ndache pa̱n yahn nuhn ma̱n, a̱ma o ya̱hca ca̱hya ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tuhme chihquentiyon Dihvo vo che chahte nducoya̱ca ihyan ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Cheta̱h ye nduh che ndache pa̱n chahn nduco ya̱hca chahn, quetuhma ye, ne neca̱h ye nundihve cuahn Dendiohs. Tuhme ndeh ye, ca̱h ye ihyan apóstol chahn ca̱va che cuih ye va̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Cheh nducoya̱ca ihyan chahn nde na̱n che chito ihyan. Chihno min ne, nedin da̱ma ye cheyahn che nga̱va, ne decuto ye ndache cuahte. ");
INSERT INTO cutNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ihyan che cheh ye ne, ri ye cun mil che dema̱n ihyan cha̱hn, ava̱ne ihyan nda̱hta ma̱n, checa̱hya ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Chihno min ne, ndedechuh Dihvo vo ihyan chahn, ne quenun ye chete a̱ma ba̱rco, cuahn ye cua̱hn ya̱hn yahn ya̱n Magdala. ");
INSERT INTO cutNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A̱ma o sa̱hn fariseo nduco sa̱hn saduceo ne, chahn se chendihchero se Dihvo vo. Sa̱hn chahn ne, retumarande se ihyan, ne chica se che din ye a̱ma vederihno, ndihchero se, ca̱va che co devano se che Dendiohs dechuh ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Cuahn che a ri chino ne, ndete che cua̱h na̱n ro ne, ra̱hn nchuhn te nda̱hca̱ din ro. ");
INSERT INTO cutNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Me vateya̱n ne, ndete che cua̱h na̱n ro ma̱n, man ma̱n ne, ra̱hn ne te cuan co. Nchuhn ne, ¡o na̱n o chende ne! A̱ma ndah nda cuande ne ta̱ca̱ ri na̱n ro, ate hua retumacadino ne yahn vederihno che redin Dendiohs ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ihyan che vate ye ma̱n ro cuh ne, ama duhtuno ihyan ye, nde hua retumaca̱h ye Dendiohs. Rica ye vederihno ndihchero ye, ate atena̱n a̱ma vederihno nduhca̱ vederihno che din Dendiohs nduco ihyan profeta Jonás nda̱ca ndihchero ye. Chihno ra̱hn ye chemin ne, chihcoma̱n ye sa̱hn chahn, ne chica ye min. ");
INSERT INTO cutNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuahn che tuche ihyan chahn vine me ne, nta̱ tin ihyan apóstol chahn che hua nda ye pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ura min ra̱hn Dihvo vo nduco ye: ―Cuihco nchuhn cuda̱do. Hua tumaca̱h ne yahn ya̱ yahn sa̱hn fariseo ma̱n, sa̱hn saduceo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tuhme ndedecadino ihyan chahn, ne ra̱hn va̱n ma̱n ye nduco vih: ―Tihca̱ ra̱hn ye ri ye uvo yahn che hua quenda vo pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Checadino Dihvo vo che hua chenahn ihyan chahn che ra̱hn ye. Deyahn che hua nda ye pa̱n ndedecadino ye. Chemin che ra̱hn ye ri ye ihyan chahn: ―¿Dehco che rendedecadino nchuhn che hua nda ne pa̱n? ¿Ta̱ca̱ che hua numa ino ne ritahno ne? ");
INSERT INTO cutNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ta̱ca̱ che hua renahn ne, nde hua rahtenun ino ne vederihno che rendihchero ne? Cuahn che cá̱h, cheh uhn mil ihyan nduco uhn pa̱n me ne, ¿ta̱ca̱ che hua chahtenun ino ne che nde ca̱de cuahte che nga̱va nedin da̱ma ne? ");
INSERT INTO cutNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A namin no tun cuahn che cá̱h, cheh cun mil ihyan nduco ndache pa̱n me ne, ¿ta̱ca̱ che hua chahtenun ino ne che nde ca̱de cuahte che nga̱va nedin da̱ma ne? ");
INSERT INTO cutNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ta̱ca̱ che hua chenahn nchuhn che ndiyu yahn pa̱n che rá̱hn nduco ne? Rá̱hn nduco ne che ca̱hco ne cuda̱do yahn ya̱ yahn sa̱hn fariseo ma̱n, sa̱hn saduceo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tuhme chenahn ihyan chahn che a yahn ndudo che ricuahn sa̱hn chahn che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cuahn che nda̱ Dihvo vo ya̱hn yahn ya̱n Cesarea de Filipo ne, tumerune ye ihyan apóstol yahn ye: ―U che rinducó nducoya̱ca ihyan, ¿deh ra̱hn ihyan yáhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ndahconan ihyan chahn: ―Na̱hn ihyan ne, ra̱hn ye te ndih che Jua̱n Bautista. Na̱hn tun ye ne, ra̱hn ye te ndih che Elías. Na̱hn tun ye ne, ra̱hn ye te ndih che Jeremías o ta̱ma cha ihyan profeta che chahte ye a ra̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tuhme tumerune ye ihyan chahn: ―Me nchuhn ne, ¿deh ra̱hn ne yáhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ndahconan Simón Pedro, ne ra̱hn ye ri ye ihyan: ―Ndih ne, a ihyan che va ca̱de che chi ye ndedevahn ye ihyan iyehnse, a ndih che Da̱ya Dendiohs, ihyan min che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ra̱hn Dihvo vo ri ye ihyan: ―Ndah ro yehn, Simón, da̱ya Jonás, te a ma̱n Chidá che va ye vahchetero te ye checadine, ndiyu ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rá̱hn rí di te redin yahn che doche Pedro, te che tihca̱ doche ne, conahn che a̱ma ndudo redin. Cuahto min quendi ihyan yáhn, ne nde vederihquentiyon yahn chundah hua co nda̱hco ndiya ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","U ne, té vederihquentiyon di ca̱va che conan va̱n ihyan che rihquentiyon Dendiohs. Cha che ca̱h yone che din ye ma̱n, cha che ca̱hca tan che hua din ye ma̱n ne, Dendiohs ne, ca̱h dito ye ndudo yehn. ");
INSERT INTO cutNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tuhme ra̱hn Dihvo vo nduco ihyan apóstol chahn che hua ca̱hma ye nduco nde a̱ma ihyan che a ma̱n ye che va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nde ta̱hn min cana̱n Dihvo vo ca̱h ye che checadino ihyan apóstol yahn ye te va che ca̱hn ye ya̱n Jerusalén, ne min a̱ma chuhrihn ye. Ndo da̱ma intiyahn ma̱n, chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, din ta̱n se nduco ye, nde ca̱hno se ihyan. Ate cuihno ino ro ne, ntuche ye. ");
INSERT INTO cutNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tuhme quenda Pedro ihyan a̱ma la̱do, ne cana̱n riya̱hve ye ihyan, ne ra̱hn ye: ―Dihvé, hua nda̱hca̱ che ca̱hco menda̱hn ne ndih ca̱va che tihca̱ cuahno co ne. ");
INSERT INTO cutNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ndaconan Dihvo vo ndihchenun ye na̱n Pedro. Chihya ye ihyan, ne ra̱hn ye: ―Di chundah, cuehn va̱ne, te redin vahche yáhn. Di ne, hua devene cha che rihquentiyon Dendiohs. Atena̱n che rihquentiyon ihyan iyehnse devene. ");
INSERT INTO cutNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tuhme ra̱hn Dihvo vo ri ye ihyan apóstol chahn: ―Adecoduhno ihyan che nahn co cuande ye va̱n ihyan yáhn ne, va che ca̱hcoma̱n ye vedeyeno ma̱n ye. Andahre va che conan ya̱h ye na̱n a̱ma cruz, ate va che ca̱hco menda̱hn ihyan, conduco ye u. ");
INSERT INTO cutNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tihca̱, te ihyan che hua nahn ca̱hco menda̱hn ye ihyan ca̱va che conduco ye u ne, va che conda ye, ne ihyan che ca̱hco menda̱hn ye ihyan ne, andahre din ta̱n ihyan nduco ye, ca̱hno ye ihyan, ate ndevahn ye, cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Hua cochihve yahn ihyan andahre nedin da̱ma ye nducuahn vedecuihca che va iyehnse ndete che chemin din che denda ye, ne hua co cuahtenan ye vahchetero. Ndete che tihca̱ ne, metah deh nduco nedihve ye ca̱va che ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Va che conahn chemin, te u che rinducó nducoya̱ca ihyan ne, va che chí numacuahn vederihquentiyon yahn Chidá nduco ángel yáhn, ne techeca̱dé yahn nducoya̱ca ihyan, nda̱hco menún yahn queri a̱ma ye tunoca che nedin ye, ndahtenan ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Cua̱co rá̱hn rí nchuhn te a̱ma o ihyan che chenun ye muhn ne, vate ca ye iyehnse nda̱ ro min, ne ndihchero ye u che rinducó nducoya̱ca ihyan cuahn che ndá̱ numacuahn vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chihno a̱n ro min ne, quenda Dihvo vo Pedro ma̱n, Jacobo nduco dihno ye Jua̱n ma̱n, ne cuahn ye nduco ihyan chahn a̱ma tingüete ya̱co, ");
INSERT INTO cutNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ne min ndo diya̱hn ye na̱n ihyan chahn. Yavena̱n ye ma̱n, tino yahn ye ma̱n ne, a̱ma diya̱hn ro nduhca̱ na̱n ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ura min ndihchero ihyan apóstol chahn Moisés nduco Elías che rente ye nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Tuhme ra̱hn Pedro ri ye Dihvo vo: ―Dihve nuhn, a̱ma nda̱hca̱ che cuahtenan vo muhn. Ndete che nahn ne ne, dendah nuhn ino vache vah; a̱ma na̱n che conun ne, ta̱ma na̱n che conun Moisés, ne ta̱ma na̱n che conun Elías. ");
INSERT INTO cutNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Numanahn che ra̱hn ca Pedro ne, quendihco a̱ma man tuno diya̱hn ro na̱n che chenun ihyan chahn, ne va̱n man me ne, chenun a̱ma ndudo che ra̱hn tuhca̱: ―Sa̱hnguh che Da̱yá. Yahinó sa̱hn. A̱ma yenó ca̱va se. Che ca̱hma se ne, chemin che codinahn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Cuahn che chihnevan ihyan apóstol chahn ndudo me ne, a̱ma dihya ye chi, ne chahteta̱ve ndih ye ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tuhme chahn nda̱ Dihvo vo na̱n ihyan chahn, nahn ta̱h ye ihyan, ne ra̱hn ye ri ye ihyan: ―Cuenecuan nchuhn. Hua dihya ne co. ");
INSERT INTO cutNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cuahn che ndo nihyon na̱n ye ne, ametah ndihchero ye ihyan che o chahn, a dema̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ura che cuenchahn ye cuete me ne, chihquentiyon Dihvo vo ihyan chahn, ne ra̱hn ye: ―Hua ca̱hma nchuhn nduco nde a̱ma ihyan yahn vederihno che ndihchero ne, nde ro che u che rinducó nducoya̱ca ihyan ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tuhme tumerune ihyan apóstol chahn Dihvo vo, ne ra̱hn ye: ―¿Deh cuande che ra̱hn sa̱hn devano ley che dirun Moisés che dinoca Elías va che chi ye ne? ");
INSERT INTO cutNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Cua̱co che va che chi Elías, nda̱hco ca̱de ye nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ate rá̱hn rí nchuhn te a nda̱ Elías, ne ihyan ne, hua nevahnecun ye ihyan. Tahque ndah ye ne, din ta̱n ye nduco ye. Namin u che rinducó nducoya̱ca ihyan ne, va che chuhríhn, din ta̱n ihyan nducó. ");
INSERT INTO cutNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tuhme tumacadino ihyan apóstol chahn che rente ye yahn Jua̱n Bautista anduhneca̱ ndete che a ihyan min che Elías. ");
INSERT INTO cutNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuahn che nta̱ ihyan chahn na̱n che chenun ihyan chena̱hn ne, chahn nda̱ a̱ma se, chehntihya se na̱n Dihvo vo, ne ra̱hn se ri se ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Dihvé, conan va̱hino ne sa̱hn da̱yá, te ndi se cah rih dihca, ne a̱ma rechuhrihn se. A̱ma ndeh yune cuahn che rinuhn yahn se ne, renda̱hnun se va̱coya̱hn ma̱n, va̱n nune ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A checú sa̱hn na̱n ihyan apóstol yahn ne, ate hua chi din ye che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tuhme ra̱hn Dihvo vo: ―Nchuhn che vate ne ma̱n ro cuh ne, duhtuno ihyan nchuhn ma̱n, hua ritahno ne ma̱n. Nchuhn ne, a hua nda̱ ro che co ne ihyan. ¿A cuahn da̱ma quendá̱h vedechahtino nduco ne, che ra̱hco ne? Checú ne sa̱hn muhn. ");
INSERT INTO cutNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sa̱hn dihn me ne, quenun a̱ma vaco chihnga̱ sa̱hn. Cuahn che nda̱ se na̱n ye ne, chihquentiyon ye che ndiquenda̱h vaco chihnga̱ me, ne ndeta̱hno ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ura che a dema̱n ye ne, tumerune ihyan apóstol chahn Dihvo vo: ―¿Dehra cuande che hua chi ndetenda̱h nuhn vaco chihnga̱ me ne? ");
INSERT INTO cutNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Nchuhn ne, nde hua ritahno ne, te cua̱co rá̱hn rí nchuhn te ndete che ritahno ne mare tahsihn ne, ca̱hcantiyon ne a̱ma ico che ca̱ca na̱n che va, ne cuhnde ta̱ma cuahn, ne dinahn. Ndete che ritahno ne ne, adecodehno che ca̱ca ne ne, conahn nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Rá̱hn rí nchuhn te ca̱va che ndetenda̱h vo vaco chihnga̱ chemin chan ne, va che cova̱h vo ma̱n, cuahto vo ya̱hte ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Numanahn che quechica Dihvo vo nduco ihyan apóstol yahn ye esta̱do yahn Galilea ne, ra̱hn ye ri ye ihyan chahn: ―U che rinducó nducoya̱ca ihyan ne, va che neca̱h ihyan u ta̱h sa̱hn nunde, ");
INSERT INTO cutNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ne ca̱hno se u. Ate cuihno ino ro ne, ntuché va̱n tena̱hn. A̱ma chi nda̱che ihyan chahn yahn che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuahn che nda̱ ihyan chahn ya̱n Capernaum ne, chahn sa̱hn che rica se tume ca̱de iyo yahn ya̱co, tumerune se Pedro: ―¿A hua renedihve ihyan ricuahn yahn nchuhn tume ca̱de iyo yahn ya̱co ne? ");
INSERT INTO cutNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ndahconan Pedro, ne ra̱hn ye ri ye sa̱hn: ―Ta̱ca̱ hua, renedihve ye. Ndonda̱ Pedro chete vah ne, mena̱n vihca tumerune Dihvo vo ihyan: ―Deh rahn Simón, ihyan che rihquentiyon ye ne, ¿duh rica ye tume ca̱de iyo ne? ¿A ihyan nación yahn ye o ihyan ta̱ma nación ne? ");
INSERT INTO cutNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ndahconan Pedro, ne ra̱hn ye ri ye ihyan: ―Rica ye ihyan ta̱ma nación. Ra̱hn Dihvo vo ri ye ihyan: ―Tuhme ne, ihyan nación yahn ye ametah va che nedihve ye. ");
INSERT INTO cutNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ate ca̱va che hua din vo che co ta̱n nde a̱ma ihyan ne, cuehn na̱n vine, ne cotihyen cu ra ya̱hca. Ite che cua te ne, cuentah chende te, ne min ntaque a̱ma tume. Nduco chemin cuenedihve ca̱de iyo yáhn ma̱n, yehn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chihno min ne, ndo da̱ma ihyan apóstol chahn na̱n Dihvo vo, ne tumerune ye ihyan: ―¿Duh che tahque cona̱n va̱n ihyan che rihquentiyon Dendiohs ne? ");
INSERT INTO cutNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tuhme cah Dihvo a̱ma lihn, chihno ye menda̱hn, ");
INSERT INTO cutNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ne ra̱hn ye ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te ndete che hua nto ino ne nunde yahn ne, co ne nduhca̱ checa̱hya che tuhchan che necun ne, hua co cuahtenan ne vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cuedevano ne te adecoduhno ihyan che necun ye nduhca̱ lihn cuh ne, ihyan min che tahque cona̱n ye va̱n ihyan che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Namin cuedevano ne te adecoduhno ihyan che nevahnecun ye a̱ma ihyan yáhn che necun ye nduhca̱ lihn cuh ne, a u nevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Adecoduhno ihyan che tihyon yune ye ihyan yáhn che cuahtendihco ye nunde ne, a̱ma chahte castigo va che co ye. Tahque nda̱hca̱ ca̱va ye ndete che ca̱ca ya̱hto ihyan a̱ma tu yudo chahte da̱ndo ye, ne cuaconda̱hnun ye ihyan va̱n nuniya̱hn, yudomin ca che tihyon yune ye ihyan yáhn che cuahtendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Cheva̱h ihyan ihyense!, te a ca̱de no che va che cuahtendihco ye nunde. Ate ¡tahque vedin ihyan che tihyon yune ye ihyan che cuahtendihco ye nunde! ");
INSERT INTO cutNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ndete che renda̱ yahn ne che cuahtendihco ne nunde, ne va che dinahn ne nduco ta̱h ne o nduco ca̱h ne ne, tahque ndah che din ne cuande anduhneca̱ ndete che a chihca ne, chaconda̱h ne, te tahque nda̱hca̱ yahn ne ndete che co cuahtenan ne vahchetero andahre yuhche ne, yudomin ca che ndah ta̱h ne, ndah ca̱h ne, cuahtenun ne va̱n ruchiya̱hn cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ndete che ca̱va ndutina̱n ne renda̱ yahn ne che cuahtendihco ne nunde ne, tahque ndah che din ne cuande anduhneca̱ ndete che a tico ne, chaconda̱h ne, te tahque ndah yahn ne ndete che co cuahtenan ne vahchetero andahre hua ro na̱n ne, yudomin ca che ndah ndutina̱n ne, cuahtenun ne va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Cuihco nchuhn cuda̱do che hua nda̱hchenan ne nde a̱ma ihyan che necun ye nduhca̱ checa̱hya che tuhchan, te ángel yahn ne, cuahn da̱ma chenan ye na̱n Chidá che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tihca̱, te u che rinducó nducoya̱ca ihyan ne, ndá̱ ndedeváhn ihyan che a ndinda ye, nedin nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Rá̱hn rí nchuhn te a̱ma ihyan che va a̱ma ciento itecuche yahn ye ne, ndete che conda a̱ma te va̱n chano ne, ca̱hcoma̱n ye ite che chena̱hn chahn va̱n chano na̱n che redin ye cuda̱do ite, ne ca̱hn ye quenuhn ye ite che chinda me. ");
INSERT INTO cutNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cuahn che nta̱ca ye ite ne, cua̱co rá̱hn rí nchuhn te nde tahque co yeno ye ca̱va ite min che co ca̱va ite che chena̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tihca̱ Chida nchuhn che va ye vahchetero, te hua nahn ye che conda nde a̱ma ihyan che necun ye nduhca̱ checa̱hya che tuhchan. ");
INSERT INTO cutNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Ndete che a̱ma ihyan che namin ritahno ye din ta̱n ye nduco a̱ma cha nchuhn ne, coya̱hve ne ihyan cua̱hn dema̱n ne nduco vih. Ndete che nto ino ye nunde yahn ye ne, a ndedevahn ne ihyan yahn castigo che va che co ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ate ndete che hua tumaca̱h ye che ca̱hma ne ne, conuhn ne a̱ma o testigo ca̱va che nduco ihyan chahn ya̱hve ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ate ndete che nde nduco tihca̱ hua tumaca̱h ye ne, ca̱hma ne nduco ihyan ndiya̱co ca̱va che va̱n nducoya̱ca ne ya̱hve ne ihyan. Ate ndete che hua tumaca̱h ye ne, co din ne cuande anduhneca̱ ndete che nde hua devano ye che va Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Cua̱co rá̱hn rí nchuhn te nducuahn che nte ca̱de ne ne, ca̱h dito Dendiohs ndudo yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Namin rá̱hn rí nchuhn te ndete che co da̱ma ndudo a̱ma o ne, ca̱ca ne deh che nahn ne Chidá che va ye vahchetero ne, te ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Te ye nchuhn, te na̱n che ndo da̱ma o ino ihyan ndeva ye yavená̱n ne, min quenún va̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tuhme chahn nda̱ Pedro, ne ra̱hn ye ri ye Dihvo vo: ―Dihvé, ¿a ndeh yune va che nchahcó yahn ihyan che quendi ye din ta̱n ye nducó ne? ¿A nde ndache yune ne? ");
INSERT INTO cutNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Ndiyu atena̱n ndache yune, te a nduh va ndeh yune che din ta̱n ye ne, a tih va ndeh yune va che nchehque yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Vederihquentiyon yahn Dendiohs ne, nduhca̱ a̱ma rey che tenda̱h cuande ye yahn sa̱hn che redin ntiyon nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cuahn che cana̱n tenda̱h cuande ye ne, nda̱ a̱ma se tenda̱h cuande ye yahn se, ne quendihco ndeh se yahn ye, tenduh ndiche mil tume diya̱hngua̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nducote metah deh nduco che nedihve se ne, chihquentiyon ye sa̱hn deca̱hya yahn ye che ndihcue se sa̱hn ma̱n, ndihcue se nda̱hta yahn se ma̱n, da̱ya se ma̱n, nducuahn dehtenduh yahn se ma̱n, ca̱va che ndutonun tah che quendihco se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tuhme chehntihya se na̱n rey me, ne ra̱hn se: “Dihvé, codin chahtino ne yáhn, ne nedihvé yahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Quenan va̱hino ye sa̱hn, ne numacuahn vedeyeno tehche ino ye nducuahn che quendihco se. ");
INSERT INTO cutNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ate ura che cona̱hn se nta̱ca se a̱ma combiero yahn se che quendihco ye ino cun ca̱de yahn se. Dihno se da̱ndo ye, ne ra̱hn se ri se ihyan: “Cuenedihve che quendihque yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Chehntihya ye na̱n se, ne ra̱hn ye: “Codin chahtine yáhn, ne nedihvé yehn.” ");
INSERT INTO cutNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ate hua cahnecun se. Tahque ndah se ne, chahn se chica nunde se yahn ye, ne quenun ye va̱coya̱hn nde chihno nedihve ye yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ndihchero combiero yahn se che tihca̱ din se, ne a̱ma chi ta̱n ye, chahn ye chengo ye rey me. ");
INSERT INTO cutNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tuhme tahve rey me che chehua sa̱hn, ne chihya ye sa̱hn: “Di ne, a̱ma duhtuno ihyan di. U ne, nchahcó yehn yahn nducuahn che quendihque yáhn, te chique favor u. ");
INSERT INTO cutNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ta̱ca̱ che hua tihca̱ quenan va̱hine combiero yehn nduhca̱ che quenan va̱hinó di?” ");
INSERT INTO cutNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Numacuahn vedeta̱n chihquentiyon ye che conun se va̱coya̱hn nde chihno nedihve se che quendihco se. ");
INSERT INTO cutNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Quendi Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Namin nchuhn, ndete che hua nchahco ne yahn vih numacuahn chedave yahn ne ne, cuahno ne nduhca̱ che chahno sa̱hn min, te Chidá che va ye vahchetero ne, hua nchahco ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Cuahn che chihno nte Dihvo vo ne, chica ye min esta̱do yahn Galilea, cuahn ye esta̱do yahn Judea, ta̱ma la̱do viche ico Jordán, ");
INSERT INTO cutNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ne a̱ma ya̱hn ihyan cuahn ye nduco ye. Cuahn che nda̱ ye min ne, din ye che ndoyahn ihyan cah. ");
INSERT INTO cutNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tuhme nda̱ a̱ma o sa̱hn fariseo che nahn tumarande se ihyan, ne tumerune se: ―¿A co tehche ihyan nda̱hta yahn ye ca̱va adecodehno ne? ");
INSERT INTO cutNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―A devano nchuhn nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Cuahn che dendah Dendiohs iyehnse ne, dendah ye ihyan cha̱hn ma̱n, ihyan nda̱hta ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Namin ndirun tuhca̱: “Ihyan cha̱hn ne, ca̱hcoma̱n ye indihte yahn ye, ne cahneva̱co ye, conan cuma ye nda̱hta yahn ye. Ihyan chahn ne, din yahn ye vih anduhneca̱ ndete che a̱ma no ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nducote tihca̱ ne, ametah din ye cuande che o ye, te anduhneca̱ ndete che a̱ma no ye. Nducote a ma̱n Dendiohs nahn ye che cuahtenan cuma ihyan chahn vih ne, hua redin yahn che tehche ye vih. ");
INSERT INTO cutNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ra̱hn sa̱hn chahn ri se ihyan: ―Ndete che tihca̱ ne, ¿deh cuande che ca̱h yune Moisés che tehche ihyan nda̱hta yahn ye, dirun ye a̱ma ca̱ca ca̱h ye ta̱hn? ");
INSERT INTO cutNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ra̱hn Dihvo vo ri ye sa̱hn: ―Yahn che cheche chedave yahn ihyan ne, chemin che ca̱h yune Moisés che tehche ye nda̱hta yahn ye. Ate Dendiohs ne, hua tihca̱ chihco ca̱de ye cuahn che dendah ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","U ne, rá̱hn rí nchuhn te ihyan che ndere tehche ye nda̱hta yahn ye ndiyu yahn nunde che quenan te nduco ta̱ma cha̱hn, ne cahneva̱co ye nduco ta̱ma te ne, redin duche yahn ye che nihneva̱co ye. Namin sa̱hn che cahneva̱co se nduco ta̱hn che ntehche incha̱hn te ta̱hn ne, condihco se nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tuhme ra̱hn ihyan apóstol ri ye Dihvo vo: ―Ndete che tihca̱ va ca̱de yahn ihyan cha̱hn ne, tahque ndah ye che nde hua cahneva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Hua nducoya̱ca ihyan co dinahn ye yahn chemin, te atena̱n ihyan che neca̱h Dendiohs vederihquentiyon ihyan che co dinahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Vate cha̱hn che hua numa ye, te a tihchan ye nde rahteya̱n ye. Namin vate ye che hua numa ye yahn che ihyan redin yoh ye ihyan. Namin vate ye che hua rahtenan cuma ye nda̱hta ca̱va che hua co va̱hche yahn ye na̱n ntiyon yahn Dendiohs. Ihyan che retumacadino che co dinahn ye che cuahtema̱n ye ne, nda̱hca̱ che dinahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Chihno min ne, nda̱ ihyan, nda ye checa̱hya yahn ye ca̱va che nahn ta̱h Dihvo vo, ne cova̱h ye ca̱va. Ate ihyan apóstol ne, ra̱hva ye nduco ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―Hua ca̱hca ta̱n nchuhn che chi checa̱hya sih ná̱n, te a ndi cuande va̱n ihyan che necun ye che cuahtenan ye vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chihno ra̱hn ye chemin ne, nahn ta̱h ye checa̱hya chahn, cova̱h ye ca̱va. Tuhme chica ye min, cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ura min nda̱ a̱ma sa̱hn yuno na̱n Dihvo vo, ne ra̱hn se: ―Ihyan Ricuahn Ndah, ¿deh ndah che dín ca̱va che conán vahchetero ne? ");
INSERT INTO cutNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Nde hua redin yahn che cahme, Ihyan Ricuahn Ndah, te atena̱n Dendiohs ne, ihyan min che ndah ye. Ca̱va che conen vahchetero ne, codinehn vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tumerune se ihyan: ―¿Cha vederihquentiyon me ne? Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Vederihquentiyon che tuhca̱: “Hua cahne ihyan ma̱n, hua din duche yehn che nihnevaque ma̱n, hua doque ma̱n, hua ndere ca̱hma nonde yahn ihyan ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cuendeva yavena̱n chide ma̱n, cheque ma̱n, codin yahine nducoya̱ca ihyan nduhca̱ che yahino man di ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ra̱hn se ri se ihyan: ―Nducuahn vederihquentiyon che tihca̱ ne, redináhn nde ro che lihn ca u. ¿A va ca che dináhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ra̱hn Dihvo vo ri ye sa̱hn: ―Che cuahtenan ihyan vahchetero ne, tahque rigonun chihve che co vedecuihca. Ca̱va che hua co va̱hche yehn che tone min ne, cuendihcue dehtenduh yehn che va, ne cuinen ihyan cheva̱h. Tuhme cochi condoque u. ");
INSERT INTO cutNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nducote a̱ma cuihca se ne, hua quenan ino se che tihca̱ ra̱hn Dihvo vo nduco se, ne a̱ma chi ra̱n se cona̱hn se. ");
INSERT INTO cutNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tuhme ra̱hn Dihvo vo nduco ihyan apóstol: ―Cua̱co rá̱hn rí nchuhn te a̱ma va̱hche ca̱va ihyan cuihca che conda̱ ye vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ndaconan rá̱hn rí nchuhn te nde a̱ma ihyan cuihca ne, hua co conda̱ ye vahchetero na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Che ra̱hn ye chemin ne, a̱ma cuahn ino ihyan apóstol chahn, ne ra̱hn ye va̱n ma̱n ye nduco vih: ―Ndete che tihca̱ ne, nde a̱ma ihyan hua co ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chaconan Dihvo vo ndihchero ye ihyan chahn, ne ra̱hn ye: ―Che tin dema̱n ihyan ne, hua conda̱ ye vahchetero. Atena̱n Dendiohs co din ye che min tuno ihyan, te Dendiohs ne, ri redin ye nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tuhme ra̱hn Pedro ri ye ihyan: ―Dihve nuhn, me nuhn che chihcoma̱n nuhn nducuahn, chinduco nuhn ndih ne, ¿deh co nduco nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te cuahn che a nuhnde ca̱de nducuahn, ne u che rinducó nducoya̱ca ihyan cuhndé na̱n che rihquentiyón numacuahn vedeyudo ne, namin nchuhn che rinduco ne u ne, cuahte ne techeca̱de ne yahn nduh che ndichio nda̱ta yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Namin adecoduhno ihyan che va che ca̱hcoma̱n ye dehtenduh yahn ye ma̱n, ihyan yahn ye ma̱n, ca̱va che co conduco ye u ne, nuhnde menun a̱ma ciento yahn queri a̱ma che ca̱hcoma̱n ye, a va̱co ye, a dihno ye, a cahve ye, a chida ye, a chaco ye, a nda̱hta yahn ye, a da̱ya ye, a ya̱hn yahn ye, ate nunde menun a̱ma ciento yahn queri a̱ma che ca̱hcoma̱n ye. Ava̱ne ne, conan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nda̱ ro min ne, ndiyu yahn che a ra̱hn chitahno ihyan che tahque quenda̱h yavena̱n ye, nde huane yahn che cade chitahno ye che hua nduh quenda̱h yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Vederihquentiyon yahn Dendiohs ne, nduhca̱ a̱ma patrón che chahn ye a̱ma vatiya̱n chenuhn ye mozo ca̱va che tuhn se uva yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nda̱ca ye neve se, ne nte ca̱de ye nduco se che din se ntiyon ca̱de ro, ne dechuh ye sa̱hn na̱n ntiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chahn tun ye tenduh na̱n rahco nun vatiya̱n, ne nta̱ca ye te neve se che vatechica se cua̱hn ndihve, metah ntiyon din se. ");
INSERT INTO cutNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ra̱hn ye ri ye sa̱hn: “Cuahn nchuhn codin ne ntiyon yáhn, conduco ne sa̱hn chena̱hn che a chenan se min, ne nedihvé nchuhn nduhva che redin yahn.” “A,” ra̱hn se, ne cuahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chahn tun ye tenduh na̱n ma̱hn ya̱hn. Nta̱ca ye te neve se, dechuh ye sa̱hn na̱n ntiyon me. Chahn tun ye tenduh na̱n rahco ino. Nta̱ca ye te neve se, ne namin dechuh ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ndaconan chahn tun ye tenduh na̱n rahco uhn, ne nta̱ca ye te neve se, ne ra̱hn ye ri ye sa̱hn: “¿Dehco che hua din nchuhn ntiyon ma̱n ro ne?” ");
INSERT INTO cutNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ndahconan se, ne ra̱hn se ri se ihyan: “Hua din nuhn ntiyon, te hua nda̱ca ntiyon din nuhn.” Ra̱hn ye ri ye sa̱hn: “Cuahn nchuhn din ne ntiyon yáhn tuhme, ne nedihvé nchuhn nduhca̱ che redin yahn.” “A,” ra̱hn se, ne cuahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Chi chino me ne, ra̱hn ye ri ye mandador yahn ye: “Cuenedin dame sa̱hn mozo sih, ne cuenedihve yahn se, cuanan nduco sa̱hn che nda̱ adive cuahn.” ");
INSERT INTO cutNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Cuahn che chenda̱ sa̱hn che a nde na̱n rahco uhn a chino cana̱n din se ntiyon ne, ndonda̱ ta̱h se chihve yahn se yahn numa ro. ");
INSERT INTO cutNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nde na̱n chihnonan yahn ne, chenda̱ sa̱hn che din se ntiyon numa ro, ne ndedecadino se che tahque ndahva nedihve ye sa̱hn, ate a da̱ma no nedihve ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cuahn che ndihchero se che a da̱ma no nevihve sa̱hn nduco sa̱hn chena̱hn chahn ne, ra̱hn nunde se nduco patrón yahn se, ");
INSERT INTO cutNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ne ra̱hn se ri se ihyan: “Sa̱hn sih che atena̱n a̱ma ura no din se ntiyon ne, ¿deh cuande che da̱ma nedihve ne sa̱hn nduco nuhn che chahtenun nuhn va̱n ya̱n numa ro, din nuhn ntiyon?” ");
INSERT INTO cutNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: “A devanó che redín. A numa nedihvé yahn nchuhn nduhca̱ che a nte ca̱de vo. ");
INSERT INTO cutNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","A nedihvé yahn nchuhn. Tahque ndah ne ne, cona̱hn ne. A má̱n va vedeyeno che tihdená̱n, nedihvé yahn sa̱hn chuhn. U ne, codín nduhca̱ che náhn nduco tume yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nchuhn ne, hua cuande yahn ne che quenan cumá vedeva̱hino nduco se.” ");
INSERT INTO cutNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Atihnoca̱ no tun ro che cuhnde ca̱de yahn nducoya̱ca ihyan, te ndiyu che a ra̱hn chitahno ihyan che tahque quenda̱h yavena̱n ye, nde huane che a cade chitahno ye che hua nduh quenda̱h yavena̱n ye. Tihca̱, te va̱n nducoya̱ca ihyan che nahn Dendiohs che cotahno ye ne, atena̱n neve ra ye che tenda̱hnun Dendiohs ihyan ca̱va che ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cuahn che a quenun yune Dihvo vo cuahn ye ya̱n Jerusalén ne, quenda ye nduh che ndichio ihyan apóstol devavih, ne ra̱hn ye ri ye ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―A devano nchuhn, che ma̱n ne, chenun yune vo, cuhn vo ya̱n Jerusalén. U che rinducó nducoya̱ca ihyan ne, neca̱h ihyan u ta̱h chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ne cuih nunde se yáhn ca̱va che ca̱hno ihyan u. ");
INSERT INTO cutNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Neca̱h se u ta̱h sa̱hn ta̱ma nación ca̱va che din duche yahn se u ma̱n, cuahn se u ma̱n, nahn ya̱h se u ma̱n. Ate cuihno ino ro ne, ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chihno min ne, chahn nda̱ nda̱hta yahn Zebedeo nduco nduh che o da̱ya ye, Jacobo ma̱n, Jua̱n ma̱n. Chehntihya ye na̱n Dihvo vo, ne chica ye favor ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tumerune Dihvo vo ihyan: ―¿Deh nehn ne? Ra̱hn ihyan nda̱hta me: ―Ricá ndih che cuahnecun ne che cuahte nduh che o da̱yá da̱ma nduco ne cuahn che a va ne na̱n rihquentiyon ne. A̱ma se ne, cuhnde se la̱do ta̱h cua̱co ne, ne ta̱ma se ne, cuhnde se la̱do ta̱h cueh ne. ");
INSERT INTO cutNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ate ra̱hn Dihvo vo ri ye ihyan chahn: ―Nchuhn ne, nde hua renahn ne deh che rica ne. ¿A cocha ne chuhrihn ne nduhca̱ che va che a̱ma chuhríhn ne? Ndahconan ihyan chahn, ne ra̱hn ye: ―Ta̱ca̱ hua. Cocha nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co te va che chuhrihn nchuhn nduhca̱ che va che a̱ma chuhríhn, ate che cuahte ne chihto ná̱n ne, ndiyu u che ca̱hcantiyón, te a Chidá che ca̱hcantiyon ye, ne a ma̱n ye devano ye cha ihyan che cuahte ye chihto ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Chihnevan ihyan apóstol chena̱hn chahn, ne chi ta̱n ye nduco ihyan che o chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tuhme cah Dihvo vo nducoya̱ca ye, ne ra̱hn ye ri ye ihyan: ―Nchuhn ne, a devano ne te ihyan ndina̱n yahn queri a̱ma nación ne, a̱ma yudo rihquentiyon ye, ne sa̱hn che rinan se ihyan ne, rendinun rendina̱hno se ihyan yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Ate va̱n nchuhn ne, hua co tihca̱, te adecochano ne che nahn cona̱n ne ne, va che co ne nduhca̱ a̱ma mozo, conan ne vih. ");
INSERT INTO cutNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","U che rinducó nducoya̱ca ihyan ne, cuiquendi ne yune yáhn, te u ne, ndá̱, ndiyu ca̱va che conan ihyan u, ate ca̱va che conan má̱n ihyan, ne ca̱hco mendá̱hn u ca̱va che ndedeváhn a̱ma ya̱hn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuahn che chica Dihvo vo ya̱n Jericó nduco ihyan apóstol yahn ye ne, a̱ma ya̱hn ihyan nduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chihto yune vate o sa̱hn na̱n ve, ne cuahn che chihnevan se che a nda̱ nino Dihvo vo ne, riya̱hve se ihyan numa dito se: ―Dihve nuhn, Da̱ya David, ¡conan va̱hino ne nuhn! ");
INSERT INTO cutNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ra̱hva ihyan nduco se ca̱va che cuahtedihn chende se, ate nde tahque yudo na̱n se ra̱hn se: ―Dihve nuhn, Da̱ya David, ¡conan va̱hino ne nuhn! ");
INSERT INTO cutNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tuhme chan ndi Dihvo vo. Cah ye sa̱hn, ne tumerune ye sa̱hn: ―¿Deh nahn nchuhn che dín ca̱va ne ne? ");
INSERT INTO cutNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ndahconan se, ne ra̱hn se ri se ihyan: ―Dihve nuhn, nahn nuhn ne che din ne che co ro na̱n nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Quenan va̱hino ye sa̱hn, ne nahn ta̱h ye ndutina̱n se. Ndeta̱hno chi ro na̱n nduh che o se, ne cuahn se chinduco se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cuahn che a nda̱ nino ihyan chahn ya̱n Jerusalén ne, nda̱ ye chihto a̱ma ya̱n lihn che duche Betfagé, nino cuete Olivo. Min tahve Dihvo vo o ihyan apóstol yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ne ra̱hn ye ri ye ihyan: ―Cuahn nchuhn viya̱n, ne min nta̱ca ne a̱ma burro che quenan chiche te, nduco te da̱ya te. Cuenta̱hte ne ite, ne cuiquenda ne ite. ");
INSERT INTO cutNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ndete che va duh ihyan che ca̱hma ye deh din ne burro tih, renta̱hte ne ite ne, ca̱hma ne co ne ihyan: “Dihve nuhn nahn ye ite, ne ndeta̱hno ndedechuh ye ite.” ");
INSERT INTO cutNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tihca̱ chi ca̱va che conahn nduhca̱ che dirun ihyan profeta tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ca̱hma nchuhn co ne ihyan che vate ye ya̱n Jerusalén: “Condihchero nchuhn che cochi Rey yahn ne. A̱ma necun ye, ne quendudo ye a̱ma burro lihn.” ");
INSERT INTO cutNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Dinahn ihyan apóstol chahn che chihquentiyon Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chehua ye burro me nduco da̱ya te, ne tihde ye tino yahn ye da̱me te. Cocha Dihvo vo ite, ne quendi ye cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A̱ma ya̱hn ihyan nduco ye, ne na̱hn ye ne, renta̱ve ye tino yahn ma̱n, na̱hn ye ne, renta̱ve ye ya̱ta cue ma̱n, rendedecuco ye numa yune cua̱hn na̱n che cuahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nducoya̱ca ihyan che nda̱hna̱n ye ma̱n, ihyan che chenan ive ye ma̱n ne, a̱ma yeno ye, ne rah ye tuhca̱: ―¡Ndeva vo yavena̱n ihyan cuh che quenan cuma ye vederihquentiyon che quenan cuma ihyan ndico yahn ye David! ¡Dechuh Dihvo vo Dendiohs ihyan! ¡Ndeva vo yavenan Dendiohs! ");
INSERT INTO cutNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cuahn che chenda̱ Dihvo vo ya̱n Jerusalén ne, cana̱n nducoya̱ca ihyan ndo da̱ma ye. A̱ma vari ye, ne na̱hn ye tumerune ye: ―¿Duh ihyan tih che nda̱ ye ne? ");
INSERT INTO cutNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na̱hn ye ne, ndahconan: ―Ihyan cuh che profeta Jesucristo che chica ye ya̱n Nazaret, esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chenda̱ Dihvo vo chete ya̱co, ne ndetenda̱h vah ye nducoya̱ca sa̱hn che chenun se min rendihcue se ma̱n, ra se ma̱n. Chi muhn chi min ye mesa yahn sa̱hn che rendahcorun se tume ma̱n, silla yahn sa̱hn che rendihcue se icui ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ne ra̱hn ye ri ye sa̱hn: ―Na̱n ndudo yahn Dendiohs ne, ndirun tuhca̱: “Ya̱co yáhn ne, ca̱va che cuahtenun ihyan cova̱h ye”, ate nchuhn ne, nedin ne anduhneca̱ vah na̱n che rendo da̱ma sa̱hn duco. ");
INSERT INTO cutNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chihno min ne, chahn nda̱ a̱ma o sa̱hn na̱n ve ma̱n, sa̱hn che cueh ca̱h ma̱n, na̱n Dihvo vo min chete ya̱co, ne din ye che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nducoya̱ca checa̱hya che chenun min ne, a̱ma yeno, ne rah tuhca̱: ―¡Ndeva vo yavena̱n ihyan cuh che quenan cuma ye vederihquentiyon nduhca̱ che quenan cuma David! Chidocuya̱n ndina̱n nduco sa̱hn devano ley che dirun Moisés ne, a̱ma chi ta̱n se che din Dihvo vo vederihno ma̱n, che rah checa̱hya chahn rendeva yavena̱n ye ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ne ra̱hn se ri se ihyan: ―¿Ta̱ca̱ che reca̱h yune ne che tihca̱ rendeva checa̱hya sih yavena̱n ne? Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Reca̱h yuné, te a tihca̱ va che conahn. A devano nchuhn te a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Chihco ca̱de ne che checa̱hya ma̱n, decua̱h ma̱n ne, ndeva yavena̱n ne nduhca̱ che redin yahn.” ");
INSERT INTO cutNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chihcoma̱n ye sa̱hn chahn, ne chica ye min. Cuahn ye ya̱n Betania, ne min quenan ye vino min. ");
INSERT INTO cutNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chi dave ta̱ma ro me, ura che quenun yune Dihvo vo che cuahn tun ye ya̱n Jerusalén ne, chi cuico ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ndihchero ye a̱ma ya̱hn higo chihto yune, ne chahn ye ndihchero ye ndete che chenan ndute yahn. Ate metah nde a̱ma ndute yahn, dema̱n ya̱ta chenan. Tuhme din dine ye ya̱hn me, ne ra̱hn ye: ―Ametah ndaconan co ndute yehn. A ura min no tih ya̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cuahn che ndihchero ihyan apóstol chahn che tih ya̱hn me ne, a̱ma cuahn ino ye, ne tumerune ye Dihvo vo: ―¿Ta̱ca̱ che ndeta̱hno tih ya̱hn higo ca̱h ne? ");
INSERT INTO cutNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te ndete che ritahno ne ma̱n, hua rihco yahn ino ne ma̱n ne, nde vederihno che tahque rahte co din ne. Co ca̱hcantiyon ne ico tih che ca̱hn conda̱hnun va̱n nuniya̱hn, ne dinahn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ndete che ritahno ne ne, nducuahn che ca̱ca ne Dendiohs ne, conahn nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ura che nda̱ Dihvo vo ne, chenda̱ ye chete ya̱co, ne cana̱n ricuahn ye. Numanahn min ne, chahn nda̱ chidocuya̱n ndina̱n nduco sa̱hn intiyahn, ne tumerune se ihyan: ―¿Duh te vederihquentiyon ndih che din ne dehtenduh che tihchan ne? ");
INSERT INTO cutNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Namin va a̱ma na̱n che tumeruné nchuhn. Dinoca ndahconan ne chemin, tuhme có nchuhn duh te vederihquentiyon che tihca̱ redín: ");
INSERT INTO cutNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Duh dechuh Jua̱n che chehdenune ye, a Dendiohs o ihyan iyehnse ne? Ate cana̱n rentuhno se va̱n ma̱n se nduco vih: ―Ndete che ca̱hmo vo che Dendiohs dechuh ye Jua̱n ne, ca̱hma ye co ye uvo: “¿Me dehco che hua chitahno nchuhn che cahndudo ye tuhme?” ");
INSERT INTO cutNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Me ndete che ca̱hmo vo che ihyan iyehnse dechuh ye ihyan ne, co ta̱n ihyan ya̱n nduco vo, te nducoya̱ca ye ritahno ye che Ndudo yahn Dendiohs cahndudo ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tahque ndah se ne, ra̱hn se ri se Dihvo vo: ―Hua devano nuhn. Tuhme ra̱hn ye ri sa̱hn: ―Namin u ne, hua có nchuhn duh te vederihquentiyon che tihca̱ redín. ");
INSERT INTO cutNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Quendi Dihvo vo, ne ra̱hn ye ri ye sa̱hn ndina̱n chahn: ―Nté a̱ma ejemplo, cahnevan nchuhn. A̱ma ihyan ne, vate o da̱ya ye, ne ra̱hn ye ri ye a̱ma se: “Ma̱n ro ne, cuehn ton uva yuhn vo.” ");
INSERT INTO cutNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ndahconan se, ne ra̱hn se: “Hua cá̱hn.” Ate adive ne, nto ino se che tihca̱ ra̱hn se, ne cuahn se din se ntiyon che chihquentiyon chida se. ");
INSERT INTO cutNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Numanahn min ne, ra̱hn ye nduco sa̱hn che ta̱ma me che ca̱hn se din se ntiyon min. Sa̱hn min ne, ra̱hn se ri se ihyan: “Ta̱ca̱ hua, chidá, cá̱hn.” Ate hua dinahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Cha sa̱hn chahn dinahn se che chihquentiyon chida se ne? Ndahconan sa̱hn ndina̱n chahn, ne ra̱hn se: ―Sa̱hn che ya̱hve ye mena̱n me. Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Cua̱co rá̱hn rí nchuhn te nduhca̱ sa̱hn che hua dinahn me ne, tihchan nchuhn, te rahcota̱hn ne yahn vederihquentiyon yahn Dendiohs. Vederihquentiyon yahn ye ne, tahque nun dinahn sa̱hn rica tume ca̱de iyo ma̱n, ta̱hn ndere vatechica ma̱n, che co nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jua̱n Bautista ne, chicuahn ye ihyan nduhca̱ che runeca̱de cuahtechica ye, ne nevahnecun sa̱hn chahn ma̱n, ta̱hn chahn ma̱n, ate nchuhn ne, chahcota̱hn ne, nde hua nto ino ne andahre ndihchero ne che nevahnecun ihyan nunde chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Cuihnevan nchuhn ta̱ma ejemplo: A̱ma ihyan ne, chihche ye dihyo uva na̱n ya̱hn yahn ye, ne din ye chahn yahn ma̱n, dendah ye a̱ma tanque na̱n che cuhno ye nune yahn uva me ma̱n, chahto ye a̱ma chete na̱n che din ye cuda̱do ntiyon min ma̱n. Cuahn che chihno chihco tahn ye nducuahn ne, nda̱hco ye chenda̱ta me ta̱h a̱ma o sa̱hn che din se ntiyon nduco. Tuhme chica ye min, cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cuahn che a nda̱ ro che a rine uva ne, dechuh ye sa̱hn deca̱hya yahn ye ca̱va che necahn ma̱hn sa̱hn chahn uva me nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ate sa̱hn redin ntiyon chahn ne, tumanga̱n se sa̱hn deca̱hya chahn yahn ye, ne a̱ma se ne, chahn se sa̱hn, ne ta̱ma se ne, chihno se sa̱hn, ne ta̱ma se ne, ca̱h se tu sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ndaconan dechuh ye tahque ya̱hn sa̱hn deca̱hya yahn ye, ne a namin no tun din ta̱n sa̱hn redin ntiyon chahn nduco se anduhneca̱ che din se mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Na̱n chihnonan yahn ne, dechuh ye sa̱hn da̱ya ye, te ra̱hco ye te nevahnecun sa̱hn chahn sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ate cuahn che ndihchero sa̱hn chahn da̱ya ye ne, ntuhno se nduco vih, ne ra̱hn se: “Sa̱hn tih che cuhnde ta̱h se ntiyon cuh. Ca̱hno vo sa̱hn, ne cahnevi vo yahn se.” ");
INSERT INTO cutNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tumanga̱n sa̱hn chahn sa̱hn, quenda se sa̱hn cua̱hn chihto, ne chihno se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tuhme ra̱hn Dihvo vo ri ye sa̱hn ndina̱n chahn: ―Cuahn che nda̱ dihve chenda̱ta me ne, ¿deh din ye nduco sa̱hn redin ntiyon chahn ne? ");
INSERT INTO cutNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ndahconan sa̱hn chahn, ne ra̱hn se ri se ihyan: ―Numacuahn vedeta̱n decuihno ye sa̱hn chahn, ne ca̱h ye chenda̱ta me ta̱ma te o sa̱hn redin ntiyon che necahn ma̱hn se ndute nda̱ta me nduco ye nda̱ ro yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Namin ra̱hn Dihvo vo ri ye sa̱hn ndina̱n chahn: ―A devano nchuhn nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: Tu che hua quenan ino sa̱hn vihcherahto ne, chemin che tahque chichihve. Chemin ne, a ma̱n Dendiohs chihco ca̱de ye, ne a̱ma nda̱hca̱ che tihca̱ din ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Nducote raconda̱h veda̱me nchuhn u ne, a rendo da̱ma ne nduco sa̱hn vihcherahto chahn. Chemin che cahnevi Dendiohs vederihquentiyon yahn ye che va ta̱h ne, ne nda̱hco ye ta̱h ihyan che dinahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Che raconda̱h veda̱me ihyan u ne, anduhneca̱ ndete che conda̱h ndudo ye na̱n ya̱va, nda̱ca yah ye, ne ihyan che dín castigo ihyan ne, anduhneca̱ ndete che conda̱h ndudo a̱ma ya̱va ihyan, cuihno ndeh ye. ");
INSERT INTO cutNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Chidocuya̱n ndina̱n chahn ma̱n, sa̱hn fariseo chahn ma̱n ne, chenahn se che a yahn se che nte Dihvo vo ejemplo me. ");
INSERT INTO cutNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chemin che nahn tumanga̱n se ihyan, ate hua chihquino se. Va̱h se ihyan ya̱n, te nducoya̱ca ye ritahno ye che Dendiohs dechuh ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Quendi Dihvo vo, ne nte ye ta̱ma ejemplo, chihnevan sa̱hn chahn: ");
INSERT INTO cutNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Vederihquentiyon yahn Dendiohs ne, a nahn nduhca̱ a̱ma rey che din ye vihco decahneva̱co da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dechuh ye sa̱hn deca̱hya yahn ye ngua se ihyan che a ndiya̱hve ye che conduco ye na̱n vihco me, ate hua chahn ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ndaconan dechuh ye ta̱ma te o sa̱hn deca̱hya yahn ye, ne ra̱hn ye nduco se: “Ca̱hma nchuhn co ne ihyan chahn che a chihnó itenine, ne a va ya̱n che cheh ye. Din nun ino ye chi ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ate a namin no tun hua tumaca̱h ihyan chahn. A̱ma ye ne, cuahn ye na̱n ya̱hn yahn ye, ta̱ma ye ne, cuahn ye na̱n ntiyon yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ne ihyan chena̱hn ne, tumanga̱n ye sa̱hn deca̱hya chahn, chahn ye sa̱hn, nde chihno ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tuhme a̱ma chi ta̱n rey me, ne dechuh ye sanda̱do yahn ye chihno se ihyan chahn, chihquiya̱hn se ya̱n va̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chihno min ne, ra̱hn ye nduco sa̱hn deca̱hya yahn ye: “A va ya̱n nducuahn ca̱va che cuana̱n vihco. Ate ihyan chahn ne, a̱ma duhtuno ihyan ye, nde hua rihneva̱hn che chi ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tahque ndah ne, cuahn nchuhn cua̱hn yune viya̱n, muhn min na̱n che ri da̱ma ihyan, ne coya̱hve ne nducoya̱ca ihyan che nta̱ca ne ca̱va che chi ye conduco ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dinahn sa̱hn deca̱hya chahn, ne quenda se quendihconahn nducoya̱ca ihyan che nta̱ca se, hua tumaca̱h se ta̱chan ihyan ye. Nduco tihca̱ ne, a̱ma ya̱hn ihyan chito vah ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tuhme chenda̱ rey me chete vah me, ne ndihchero ye a̱ma sa̱hn che nduco se min. Hua quenun se tino nduhca̱ che rahtenun ihyan che rahn ye na̱n rihneva̱co ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ne ra̱hn ye ri ye sa̱hn: “Amigo, ¿ta̱ca̱ che chenda muhn?, te hua quenon tino che redin yahn che conon.” Sa̱hn min ne, nde na̱n che ca̱hma se metah. ");
INSERT INTO cutNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tuhme chihquentiyon rey me sa̱hn che rinan se na̱n vihco me: “Cuiquiya̱hto nchuhn nde ta̱h nde ca̱h sa̱hn tih, cuetenda̱h vah ne sa̱hn, cuaconda̱hnun ne sa̱hn na̱n che man. Min cuaco se ma̱n, cheh dihyon se ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tuhme ra̱hn Dihvo vo ri ye sa̱hn ndina̱n chahn: ―Tihca̱, te a̱ma ya̱hn ihyan riya̱hve Dendiohs che cuatenan ye vahchetero, ate a̱ma doh ihyan che co cuahtenan ye min. ");
INSERT INTO cutNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tuhme cona̱hn sa̱hn fariseo chahn, ne ntuhno se nduco vih ca̱va che nuhn ino se ta̱ca̱ co ca̱ca nunde se yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dechuh se a̱ma o combiero yahn se nduco ta̱ma te o sa̱hn partido yahn Herodes, ne ra̱hn se ri se Dihvo vo: ―Ihyan Ricuahn, ndih ne, ndudo cua̱co che rente ne ma̱n, ricuahn ne numa cua̱co vederihquentiyon yahn Dendiohs ma̱n, nde hua renda̱hchenan ne ihyan, te da̱ma no rendihche ne nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Deh ra̱hn ne: ¿A redin yahn che nedihvo vo ca̱de iyo che rica emperador yahn Roma o hua ne? ");
INSERT INTO cutNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Dihvo vo ne, a devano ye che retumarande sa̱hn chahn ihyan, ne ra̱hn ye ri ye sa̱hn: ―Nchuhn ne, o na̱n o chende ne. ¿Dehco che retumarande ne u? ");
INSERT INTO cutNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Cuete ne a̱ma tume che renedihve nduco ne ca̱de iyo, ndihcheró. Na̱hme se a̱ma tume chemin chan ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ndihchero ye tume me, ne tumerune ye sa̱hn: ―¿Duh ihyan che quenan yavena̱n ye ma̱n, che duche ye ma̱n, na̱n tume cuh ne? ");
INSERT INTO cutNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ndahconan se, ne ra̱hn se: ―Emperador yahn Roma. Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Cha che rihquentiyon emperador ne, condinahn nchuhn, ne cha che rihquentiyon Dendiohs ne, namin codinahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","A̱ma cuahn ino se che tihca̱ ra̱hn ye, ne cona̱hn se nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A ro min no chahn a̱ma o sa̱hn saduceo chendihchero se Dihvo vo. Sa̱hn chahn ne, hua ritahno se che va che ntuche tena̱hn, ne chemin che ra̱hn se ri se ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ihyan Ricuahn, Moisés ne, dirun ye te ndete che coh incha̱hn a̱ma nda̱hta che hua nda̱ca da̱ya ye ne, va che cahneva̱co dihno tena̱hn me nduco ta̱hn min ca̱va che ca̱hco nda̱ta se menun dihno se. ");
INSERT INTO cutNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A̱ma yune ne, chahte ndache sa̱hn ya̱n va̱co nuhn che dihno se vih. Chihneva̱co sa̱hn mena̱n me, ne cuahn che chih se ne, hua nda̱ca se nde a̱ma da̱ya se nduco nda̱hta yahn se. Chemin che chihneva̱co ta̱ma dihno se nduco ta̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ate namin chih se, ne hua nda̱ca da̱ya se nduco te. Atihnoca̱ nde chenan chih nduh che ndache se che chahtenan cuma se ta̱hn min. Nde a̱ma se hua nda̱ca da̱ya se nduco te. ");
INSERT INTO cutNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nde na̱n chihnonan yahn ne, namin chih ta̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nducote nduh che ndache sa̱hn chahn chahtenan cuma se ta̱hn min ne, nda̱ ro che ntuche tena̱hn ne, ¿cha se che incha̱hn te ne? ");
INSERT INTO cutNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Nchuhn ne, hua ritahno ne che va che ntuche tena̱hn, te hua renahn ne Ndudo yahn Dendiohs, nde huane vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nda̱ ro che ntuche tena̱hn ne, ametah cuahtenan cuma ihyan vih, nde huane ihyan nda̱hta, nde huane ihyan cha̱hn. Ro min ne, ndo ye nduhca̱ ángel che vate ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Me yahn che va che ntuche tena̱hn ne, a ndero ndi che nde hua renahn nchuhn Ndudo yahn Dendiohs che ndirun, na̱n che ra̱hn ye tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“U che Dendiohs yahn Abraham ma̱n, yahn Isaac ma̱n, yahn Jacob ma̱n.” Che tihca̱ ra̱hn ye ne, a ndero ndi che a ihyan min che Dendiohs yahn nducoya̱ca ihyan, ihyan che vate ca ye ma̱n, ihyan che a ndih ye ma̱n, te na̱n ihyan min ne, chenduche nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nducoya̱ca ihyan che chihnevan ye che tihca̱ ra̱hn Dihvo vo ne, a̱ma cuahn ino ye yahn vededevano yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Checadino sa̱hn fariseo chahn che nda̱hco ndiya Dihvo vo sa̱hn saduceo chahn, ne ndo da̱ma se, na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Va̱n sa̱hn chahn quenun a̱ma sa̱hn devano ley che dirun Moisés, ne ca̱va che tumarande se Dihvo vo ne, tumerune se ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Ihyan Ricuahn, ¿cha vederihquentiyon na̱n ley yahn Dendiohs che tahque mena̱n vihca ne? ");
INSERT INTO cutNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―“Codin yahine Dihve Dendiohs numacuahn chedave yehn ma̱n, numa ine ma̱n, numacuahn vederendecadino yehn ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Vederihquentiyon min che mena̱n vihca. ");
INSERT INTO cutNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Namin va ta̱ma vederihquentiyon yahn ye, che a nahn da̱ma che tuhca̱: “Codin yahine nducoya̱ca ihyan nduhca̱ che yahino man di.” ");
INSERT INTO cutNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Na̱n nduh che o vederihquentiyon che tuhchan ne, rendo da̱ma nducuahn che dirun Moisés ma̱n, ihyan profeta ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Numanahn che ndi da̱ma ca sa̱hn fariseo chahn ne, ");
INSERT INTO cutNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","tumerune Dihvo vo sa̱hn: ―Ihyan che va ca̱de che chi ye ndedevahn ye ihyan iyehnse ne, ¿deh ra̱hn nchuhn yahn ye ne? ¿Duh da̱ya ihyan min ne? Ndahconan se, ne ra̱hn se: ―Ihyan min ne, da̱ya David. ");
INSERT INTO cutNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tuhme ra̱hn ye ri ye sa̱hn: ―Ndete che atena̱n da̱ya David ihyan min ne, ¿ta̱ca̱ che din Vaco Ndah yahn Dendiohs che nevahnecun David ihyan nduhca̱ Dihve ye?, dirun ye tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ra̱hn Dihvo vo Dendiohs ri ye Dihvé: “Cuihnde chihto ná̱n, la̱do ta̱h cua̱có, numanahn che nda̱hco ndiyá ihyan che hua ri rendihche di ca̱va che nevahnecun ye di.” ");
INSERT INTO cutNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Nducote ma̱n David dirun ye che ihyan min che Dihve ye ne, hua cua̱co che atena̱n da̱ya ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nde a̱ma sa̱hn chahn hua nta̱quino se deh che ndahconan se yahn ye, ne nde ro min ametah chihquino se tumerune ca se dehtenduh ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tuhme ra̱hn Dihvo vo nduco ihyan che chenun ye min ma̱n, ihyan apóstol yahn ye ma̱n, tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, nta̱h se ntiyon che ricuahn se ley min. ");
INSERT INTO cutNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cuenevahnecun nchuhn che ricuahn se, ate hua quendi ne yune yahn se, te sa̱hn chahn ne, a vih ricuahn se, ne a vih redin se. ");
INSERT INTO cutNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A̱ma ndeh na̱n rihquentiyon se che dinahn ihyan, ate ma̱n se ne, nde tah hua redinahn se. ");
INSERT INTO cutNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nducuahn che redin se ne, atena̱n ca̱va che cuhnde ro vederihquentiyon che chenan cuma se. Tahque rahno cinta che chenan chata se ma̱n, reche se ma̱n, tahque rahno tino che chenun se ma̱n, che co ihyan chena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Renan ino se rahte se na̱n silla che rahte ihyan ndina̱n na̱n vihco ma̱n, chete ya̱co ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Namin renan ino se che numacuahn vedenecun neca̱h ihyan Dendiohs sa̱hn va̱n ihyan ma̱n, ca̱hma ye ihyan ricuahn yahn se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ate nchuhn ne, hua ca̱hma ne ihyan ricuahn yahn vih, te nducoya̱ca ne ne, dihno ne vih, ne va a̱ma no Ihyan Ricuahn yahn ne, ihyan min che va ca̱de che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hua ca̱hma ne chida ne yahn ihyan iyehnse, te va a̱ma no Chida ne, ihyan min che va ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Namin hua ca̱hma nchuhn ihyan ndina̱n yahn vih, te va a̱ma no Ihyan ndina̱n yahn ne, ihyan min che va ca̱de che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ihyan che cona̱n ye va̱n nchuhn ne, co ye nduhca̱ deca̱hya yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tihca̱, te ihyan che renda̱hco ndiya ye ihyan chena̱hn, nahn cona̱n ye ne, nuhnde ndiya ye, ne ihyan che nda̱hco ndiya ma̱n ye ihyan ne, cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te redin va̱hche ne yahn ihyan che nahn nevahnecun ye vederihquentiyon yahn Dendiohs. Hua renevahnecun ma̱n ne, nde hua retihyon yune ne ihyan che nevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun che Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te rehnevi ne dehtenduh yahn nda̱hta va̱h, ne ca̱va che hua cuhnde ro vede idihya yahn ne ne, a̱ma ra̱hn reva̱h ne redin ca̱ ne. Nducote tihca̱ redin ne ne, tahque chahte castigo va che co ne che co ihyan chena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te a̱ma nahn ne che co ya̱hn ihyan che cotahno ye da̱ma nduco ne. Ate cuahn che renda̱ca ne a̱ma ye ne, retihyon yune ne ihyan che a̱ma duhtuno ihyan nda̱conda̱ ye, che nde tahque redin yahn che co ye castigo va̱n ruchiya̱hn che co ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Nchuhn ne, anduhneca̱ sa̱hn na̱n ve che nahn quendanan se sa̱hn na̱n ve nduco se. ¡Cheva̱h nchuhn!, te ricuahn ne ihyan: “Ndete che ca̱h ne ndudo yahn ne che ntihyon ya̱n ne ya̱co ne, andahre hua dinahn ne dehve din yahn. Ate ndete ca̱h ne ndudo yahn ne che ntihyon ya̱n ne diya̱hngua̱n che va chete ya̱co ne, chemin che cua̱co, quenan cuma che dinahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tundo nchuhn! ¡Hua renahn ne! Tahque rigonun chihve ya̱co, te min ri vihco diya̱hngua̱n che va chete. ");
INSERT INTO cutNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Namin ricuahn ne: “Ndete che ca̱h ne ndudo yahn ne che ntihyon ya̱n ne na̱n ta ne, andahre hua dinahn ne dehve din yahn. Ate ndete che ca̱h ne ndudo yahn ne che ntihyon ya̱n ne vedino che va na̱n ta ne, chemin che cua̱co, quenan cuma che dinahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tundo nchuhn! ¡Hua renahn ne! Tahque rigonun chihve na̱n ta, te min ri vihco vedino che va mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tihca̱, te cuahn che reca̱h ihyan ndudo yahn ye che rentihyon ya̱n ye na̱n ta ne, nde nduco nducuahn che va mena̱n ne, rentihyon ya̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Namin cuahn che reca̱h ye ndudo yahn ye che rentihyon ya̱n ye ya̱co ne, nde Dendiohs rentihyon ya̱n ye, te a ya̱co yahn ye chemin. ");
INSERT INTO cutNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Namin cuahn che reca̱h ye ndudo yahn ye che rentihyon ya̱n ye vahchetero ne, nde Dendiohs rentihyon ya̱n ye, te a ihyan min che rihquentiyon min. ");
INSERT INTO cutNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te renedihve ne riya yahn ive ma̱n, yahn anís ma̱n, yahn comino ma̱n, ate vederihquentiyon yahn Dendiohs che tahque mena̱n vihca ne, hua retumaca̱h ne yahn, te hua runeca̱de vatechica ne ma̱n, hua chenan cuma ne vedeva̱hino ma̱n, hua ritahno ne ma̱n. Che nahn ne, che quendihconahn dinahn ne vederihquentiyon yahn Dendiohs, hua ca̱hcoma̱n ne nde a̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nchuhn ne, anduhneca̱ sa̱hn na̱n ve che nahn quendanan se sa̱hn na̱n ve nduco se. A̱ma rendecadino ne yahn dehtenduh che nde hua nduh rigonun chihve, ate che tahque rigonun chihve ne, nde hua retumaca̱h ne yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te nchuhn ne, anduhneca̱ va̱so ma̱n, cuh ma̱n, che dave cua̱hn veda̱me, ate cua̱hn chete ne, ndito dehtenduh che chihnga̱. Tihchan nchuhn, te na̱n ihyan ne, redin ca̱ ne che ndah ihyan ne, ate che cua̱co ne, reduco ne ma̱n, redin idihya ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nchuhn sa̱hn fariseo che hua renahn ne, che ra̱hco ne che retihyon yune ne ihyan che quendi ye yune yahn Dendiohs, dinoca cuento ino ne nunde yahn ne, cuihcoma̱n ne dehtenduh che chihnga̱ redin ne, tuhme che cua̱co dave yavena̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te redin ca̱ ne che a̱ma ndah ihyan ne, ate a̱ma duhtuno ihyan ne. ");
INSERT INTO cutNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tihchan nchuhn, te andahre ra̱hco ihyan che a̱ma ndah ihyan ne, ate o na̱n o chende ne ma̱n, a̱ma duhtuno ihyan ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡o na̱n o chende ne! ¡Cheva̱h nchuhn!, te rahto ne ya̱yan yahn ihyan profeta ma̱n, rendedecuco ne ya̱yan yahn ihyan che runeca̱de chahtenan ye iyehnse ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ne ndere ra̱hn ne nduco vih: “Ndete che uvo che a vato vo ro che chihno ihyan ndico yuhn vo ihyan profeta chahn ne, hua da̱ma chi vo nduco ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nduco ndudo che tihca̱ ra̱hn ne ne, rihco ro ne che da̱ma ne nduco ihyan chahn che chihno ye ihyan profeta. ");
INSERT INTO cutNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Cuiquendi ne yune yahn ihyan ndico yahn ne ca̱va che din numa ne ntiyon che cana̱n ye! ");
INSERT INTO cutNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nchuhn ne, nduhca̱ cu ta̱n tihchan ne. Nde hua co ndevahn ne yahn castigo che va che co ne va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chemin che va ca che dechúh ihyan che cuahndudo ye Ndudo yahn Dendiohs ma̱n, ihyan devano ma̱n, ihyan ricuahn ma̱n. Ate nchuhn ne, ca̱hno ne a̱ma o ye, ne ta̱ma te o ye ne, conahn ya̱h ye ihyan. Ta̱ma te o ye ne, cuahn ne ihyan chete ya̱co ma̱n, quenda̱h ne ihyan nduh ya̱n nduh ya̱n ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nduco tihca̱ cuehda̱me nchuhn yun yahn nducoya̱ca tena̱hn che nde hua chendihco ye nunde che chihno ihyan ndico yahn ne nde a ra̱hn me, cana̱n nduco yun yahn Abel nde yun yahn Zacarías, da̱ya Berequías, che chihno ne menda̱hn yahn ya̱co nduco na̱n ta. ");
INSERT INTO cutNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ra̱hn cua̱có rí nchuhn te nducuahn nunde min ne, ndehda̱me nducoya̱ca nchuhn che vate ne ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nchuhn ihyan ya̱n Jerusalén che rihno ne ihyan profeta ma̱n, reca̱h ne tu ihyan che redechuh Dendiohs rahndudo ye ye ndudo yahn ye va̱n ne ma̱n, a̱ma ndeh yune ndá̱ che nahn nedin da̱má nchuhn, dín cuda̱do nchuhn nduhca̱ che redin chaco tuh cuda̱do da̱ya te ma̱n reche te, ate hua nevahnecun ne. ");
INSERT INTO cutNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cuedevano nchuhn te ya̱n va̱co ne ne, cuhndema̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Rá̱hn rí nchuhn te ametah ndaconan ndihchero ne u nde nda̱ ro che ca̱hma ne tuhca̱: “Ndeva vo yavena̱n ihyan cuh che dechuh Dihvo vo Dendiohs ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ndiquenda̱h Dihvo vo chete ya̱co che a na̱hn ye. Ura min ndo da̱ma ihyan apóstol yahn ye, ne na̱hme ye ya̱co me ihyan, rente ye nduhca̱ che a̱ma nda̱hca̱ ndahto. ");
INSERT INTO cutNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Cueneca̱hco nchuhn che ndihchero ne chete che tihchan tih. Cua̱co rá̱hn rí nchuhn te nda̱ ro che cuihno ndora, metah nuhnde nde o tu che ndahto vih. ");
INSERT INTO cutNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chihno min ne, cuahn Dihvo vo nduco ihyan apóstol cuete Olivo. Cuahn che a chenun ye min ne, chahn ihyan apóstol chahn na̱n va Dihvo vo, ne ra̱hn ye ri ye ihyan deva vih: ―Nahn nuhn che te cuande ne nuhn, ticua̱hn conahn che ra̱hn ne me. ¿Deh vederihno co ro cuahn che ndaconan chi tun ne ma̱n, cuahn che nto iyehnse ma̱n ne? ");
INSERT INTO cutNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Cuihco nchuhn cuda̱do ca̱va che nde a̱ma ihyan hua cahncheh ye nchuhn, ");
INSERT INTO cutNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","te va che nda̱ a̱ma ya̱hn se din ca̱ se che chenan cuma se vederihquentiyon yáhn, ne ca̱hma se che a ma̱n se ihyan che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. A̱ma ya̱hn ihyan cahncheh se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ro min ne, cahnevan ne che a muhn a min va ca̱nda ma̱n, che cuana̱n ca̱nda ma̱n, ate hua cua ne cuda̱do, te a tihca̱ va che co. Cuedevano ne te andahre a̱ma ca̱hnda ro min, ate condah ca che nto iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ihyan a̱ma nación ne, cuhma ye nduco ihyan ta̱ma nación ma̱n, a muhn a min cuhnde cuico ma̱n, cuhnde cah ma̱n, nuhn ya̱hn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nducuahn vedeyah chemin chan ne, cade na̱n che cuana̱n che chuhrihn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Nda̱ ro min ne, ca̱ca nunde ihyan yahn nchuhn, din ta̱n ye nduco ne, nde ca̱hno ye nchuhn. Nducoya̱ca ihyan iyehnse ndihche ta̱n ye nchuhn yahn che ritahno ne u. ");
INSERT INTO cutNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Cuahn che tihca̱ co ne, a̱ma ya̱hn ihyan ca̱hcoma̱n ye che ritahno ye, ne ndihche ta̱n ye vih ma̱n, ca̱ca nunde ye yahn vih ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","A muhn a min quenda̱h a̱ma ya̱hn sa̱hn che din ca̱ se che Dendiohs dechuh ye sa̱hn, ne cahncheh se a̱ma ya̱hn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","A̱ma duhtuno nda̱conda̱ ihyan che nde ihyan che ndah ihyan ye ametah cuahtenan cuma ye vedeyahino nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ate ihyan che quendi ye cotahno ye nde cuihno nducuahn vedeyah min ne, ihyan chahn che ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Me ndudo ndah yahn vederihquentiyon yahn Dendiohs ne, cuahndudo ihyan numachahte iyehnse, nde conan cadino nducoya̱ca ihyan yahn nducuahn nación, tuhme che nto iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ihyan profeta Daniel ne, dirun yahn a̱ma na̱n che a̱ma chihnga̱ che redetohnan. Condedecadino ndah ne yahn. Cuahn che ndihchero ne che a nti chemin chete ya̱co cua̱hn na̱n ta ne, ");
INSERT INTO cutNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nducoya̱ca ihyan che vate ye esta̱do yahn Judea ne, tahque ndah che ndeta̱hno ca̱no ye cua̱hn ico ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ihyan che chenun ye tin vah yuto yahn ye ro min ne, tahque ndah che hua condah ye conda̱ ye chete vah ca̱va che cota̱h ye dehtenduh yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Me ihyan che chenan ye viya̱ta ne, tahque ndah che a nde min no ca̱no ye, hua tihyon ye ura na̱hn ye viya̱n ca̱va tino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Cheva̱h nda̱hta che adeche cuacoya̱hn te ro min ma̱n, ta̱hn che reta̱ve te decua̱h ma̱n! ");
INSERT INTO cutNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cova̱h nchuhn cuica ne Dendiohs che hua ro iche co venecuino min, nde huane ro che rahte tuhno ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","te ro min che cuahno ihyan venecuino che hua nahno ihyan nde ro che cana̱n iyehnse, nde metah ndaconan cuahno ye adive. ");
INSERT INTO cutNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ndete Dendiohs din ye che ra̱hn cuhnde venecuino min ne, nde a̱ma ihyan hua ndevahn ye. Ate hua cuahnecun ye che ra̱hn cuhnde ca̱va che co ndevahn ihyan yahn ye che a tenda̱hnun ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Nda̱ ro min ne, ndete che ca̱hma ihyan co ye nchuhn: “Condihche nchuhn, muhn quenun ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse,” o “Condihche ne, min quenun ye” ne, hua cotahno ne, ");
INSERT INTO cutNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","te a̱ma ya̱hn se cahnecheh se ihyan, din ca̱ se che a sa̱hn chahn che a va ca̱de che ndedevahn se ihyan iyehnse ma̱n, che Dendiohs dechuh ye sa̱hn ma̱n. Va̱n vederihncheh yahn se ne, din se vederihno, cahncheh se nde ihyan che a tenda̱hnun Dendiohs ndete che co. ");
INSERT INTO cutNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","A mena̱n vihca rete cuandé nchuhn ca̱va che a devano ne. ");
INSERT INTO cutNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chemin che ndete che ca̱hma ihyan co ye nchuhn: “Min ya̱hn na̱n che metah duhva quenan ye” ne, hua ca̱hn ne. O ndete che ca̱hma ye: “Condihche ne, muhn chete vah quenun ye” ne, hua cotahno ne. ");
INSERT INTO cutNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","A devano ne te cuahn che riya cuah ne, hua renun ndeh, te rahn dave yahn numachahte, ne rendihchero nducoya̱ca ihyan. A tihnoca̱ co cuahn che, u che rinducó nducoya̱ca ihyan, ndaconan chí, te cadino nde ca̱hya nde cune ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ro min ne, hua chuh ya nde a̱ma ihyan nunde, te nducoya̱ca ye va che co ye castigo. ");
INSERT INTO cutNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Cuahn che a conan chuh vedeyah chemin chan ne, co man na̱n ya̱hn ma̱n, na̱n iyo ma̱n, a cora iyon ma̱n, ne nducuahn che nihnde ca̱de na̱n ro ne, nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tuhme cuhnde ro vederihno na̱n ro, ca̱hco ro che u che rinducó nducoya̱ca ihyan ne, a ndá̱. Cuaco nducoya̱ca ihyan iyehnse, ne ndihchero ye u che ndá̱ va̱n man numacuahn vederihquentiyon chahte yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tuhme a̱ma yudo cuah trompeta, ne tahvé ángel yáhn che nedin da̱ma ye ihyan yáhn che a tenda̱hnún che vate ye numachahte iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Cua cuande nchuhn nduhca̱ che ri nduco ya̱hn higo. A devano ne te cuahn che reneca̱hno ya̱n ne, a cochi nino ro ihno. ");
INSERT INTO cutNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Atihnoca̱ cuahn che a rendihchero nchuhn che a rinahn dehtenduh che tuhchan che rá̱hn rí nchuhn ne, cuedevano ne te a nda̱ nino ro che nto iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Cua̱co rá̱hn rí nchuhn te ihyan che vate ye ma̱n ro cuh ne, vate ca ye cuahn che a conahn nducuahn dehtenduh chemin chan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iyehnse ma̱n, na̱n ro ma̱n ne, va che cuihno, ate ndudo yáhn ne, hua nda̱ ro che cuihno, te va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Me yahn che conahn chemin ne, hua duh devano deh ro ma̱n, deh ura ma̱n, nde ángel che chenan ye vahchetero ma̱n, nde Da̱ya Dendiohs ma̱n, hua devano ye. Atena̱n Dendiohs Chida che devano ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Anduhneca̱ che chahno ihyan ro che quenan Noé iyehnse ne, tihca̱ cuahno ihyan ro che, u che rinducó nducoya̱ca ihyan, ndaconan chi tún. ");
INSERT INTO cutNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Ihyan chahn ne, vate ye vedeyeno yahn ma̱n ye, reh ye ma̱n, rih ye ma̱n, rihneva̱co ye ma̱n, redeca̱hneva̱co ye da̱ya ye ma̱n. A cuda̱do min vate ye nde nda̱ ro che chenda̱ Noé chete arca. Nde hua tumacadino ye cuahn a cana̱n chan cona̱hn, chito nune iyehnse, ne chihno chih nducoya̱ca ye. A chemin no tun ro che, u che rinducó nducoya̱ca ihyan, ndaconan chi tún, te ihyan nunde ne, nde tah hua ndedecadino ye yahn. ");
INSERT INTO cutNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nda̱ ro min ne, andahre da̱ma redin o ihyan ntiyon chenan ye viya̱ta, ate a̱ma ye ne, quenda ángel ihyan, ne ta̱ma ye ne, ca̱hcoma̱n ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","A namin no tun, andahre da̱ma chenun o ihyan nda̱hta, rengu ye, ate a̱ma ye ne, quenda ángel ihyan, ne ta̱ma ye ne, ca̱hcoma̱n ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Cuahteya̱n nchuhn, te u che Dihve ne ne, hua devano ne deh ura ndá̱. ");
INSERT INTO cutNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cua cuande nchuhn ejemplo cuh: Ndete che a̱ma patrón devano ye deh ura nda̱ sa̱hn duco ne, cuhndeya̱n ye, ne hua cuahnecun ye che duco se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Atihnoca̱ nchuhn, nahn che cuahteya̱n ne, te u che rinducó nducoya̱ca ihyan ne, dena̱n ndá̱ ura che nde hua vate ne cuda̱do. ");
INSERT INTO cutNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Cuihnevan nchuhn ejemplo cuh: Chihnde sa̱hn deca̱hya che nda̱hca̱ vederendecadino yahn se ma̱n, redinahn se ma̱n. A̱ma yune ne, chihco patrón yahn se ntiyon ta̱h se che din se cuda̱do mozo yahn ye, ca̱hca cheh se sa̱hn nduhca̱ che redin yahn, ne chica ye min, cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A̱ma ndah ro yahn sa̱hn min ndete che redinahn se nde nda̱ ro che ndaconan dihve se. ");
INSERT INTO cutNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Cua̱co rá̱hn rí nchuhn te ndete che tihca̱ ne, nda̱hco dihve se vederihquentiyon ta̱h se che din se cuda̱do nducuahn che va yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ate ndete che ndedecadino se che hua nun ndaconan dihve se, ");
INSERT INTO cutNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ne cuana̱n din ta̱n se nduco mozo yahn ye ma̱n, cheh se ma̱n, cuh se ma̱n, nduco sa̱hngoh ma̱n ne, ");
INSERT INTO cutNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","dena̱n nta̱ patrón yahn se ura che nde tah hua va se cuda̱do. ");
INSERT INTO cutNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tuhme din ye castigo sa̱hn, cuahno se nduhca̱ che rahno sa̱hn che o na̱n o chende se, co se castigo yah va̱n ruchiya̱hn. Min cuaco se ma̱n, cheh dihyon se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Nda̱ ro min ne, ihyan che rihquentiyon Dendiohs ihyan ne, cuahno ye nduhca̱ che chahno chi ndiche ta̱hn ca̱hya che cheta̱h te candil yahn te, ne chahn te na̱n vihco rihneva̱co ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Uhn ta̱hn chahn ne, vivo te, ne te uhn te ne, hua cuda̱do te. ");
INSERT INTO cutNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ta̱hn che hua cuda̱do chahn ne, hua quenda̱ te aceite devavih ca̱va che tuno yahn te. ");
INSERT INTO cutNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Me ta̱hn che vivo chahn ne, decuto te candil yahn te, nde quenda ca te aceite devavih. ");
INSERT INTO cutNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nducote a̱ma rendah sa̱hn rihneva̱co me ne, nda̱ ya̱hnde na̱n te, ne chahteya̱do te. ");
INSERT INTO cutNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tenduh na̱n ma̱hn ya̱n me ne, ya̱hve ihyan ta̱hn, ne ra̱hn ye: “A cochi sa̱hn rihneva̱co. Cuahteya̱n nchuhn ca̱va che conduco ne sa̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Necuan nduh che ndiche ta̱hn chahn, cana̱n renda̱hco ya̱n te candil yahn te. ");
INSERT INTO cutNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tuhme ra̱hn ta̱hn che hua cuda̱do chahn ri te combiero yahn te: “Te nchuhn tah aceite yahn ne nuhn, te a rentoh candil yahn nuhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ndahconan ta̱hn che vivo chahn, ne ra̱hn te: “Hua co te nuhn nchuhn, te ndete che te nuhn ne, hua tuno nde ca̱va ma̱n nuhn. Tahque ndah nchuhn ne, cuahn ne cua ne na̱n che rendihcue ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ate numanahn che cuahn ta̱hn che hua cuda̱do chahn ca te aceite ne, nda̱ sa̱hn rihneva̱co me, chenda̱ se vah. Ta̱hn che vateya̱n chahn ne, namin chenda̱ te, ne ndude chendevah. ");
INSERT INTO cutNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chihno min ne, nta̱ ta̱hn chena̱hn chahn, ne cana̱n riya̱hve te: “Dihve nuhn, cona̱hne ne chendevah conda̱ nuhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ate ndahconan sa̱hn rihneva̱co me, ne ra̱hn se ri se ta̱hn: “Cua̱co rá̱hn te nde hua rendihché duh nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chihno nte Dihvo vo ejemplo me ne, ra̱hn ye: ―Cua cuande nchuhn ejemplo me, ne cuahteya̱n ne, te u che rinducó nducoya̱ca ihyan ne, hua devano ne deh ro ma̱n, deh ura ma̱n, che ndaconan chí. ");
INSERT INTO cutNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ihyan che rihquentiyon Dendiohs ihyan ne, anduhneca̱ sa̱hn deca̱hya yahn a̱ma patrón. Cuahn che va che ca̱hn patrón yahn se ya̱hn yahn ne, nedin da̱ma ye sa̱hn, ne chihco ye tume ta̱h queri a̱ma se ca̱va che din se ntiyon nduco. ");
INSERT INTO cutNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A̱ma se ne, chihco ye uhn mil ta̱h se, ta̱ma se ne, chihco ye o mil ta̱h se, ta̱ma se ne, chihco ye a̱ma mil ta̱h se. Tunoca co din queri a̱ma se ntiyon ne, a tihva tume chihco ye ta̱h se, tuhme cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sa̱hn che chihnde ta̱h uhn mil me ne, din se ntiyon nduco, ne nda̱ca se te uhn mil na̱n ntiyon che din se. ");
INSERT INTO cutNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Namin sa̱hn che chihnde ta̱h o mil me ne, din se ntiyon nduco, ne nda̱ca se te o mil na̱n ntiyon che din se. ");
INSERT INTO cutNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ate sa̱hn che chihnde ta̱h a̱ma mil ne, tihyon ndeh se tume me ma̱n ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Chi ra̱hn me ne, nta̱ patrón yahn sa̱hn chahn, ne ndetenda̱h cuande ye nduco se. ");
INSERT INTO cutNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mena̱n vihca nda̱ sa̱hn che chihnde ta̱h uhn mil me, ne ra̱hn se ri se ihyan: “Dihvé, uhn mil te ne u, ne dín ntiyon nduco, nda̱cá te uhn mil na̱n ntiyon che dín. Condo ta̱h ne che uhn mil me yahn ne nduco uhn mil che quendudona̱n yahn.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ra̱hn patrón yahn se ri ye sa̱hn: “Nda̱hca̱ din. Di ne, redinehn ndudo yehn. Tah ra tume té di, ne nda̱hca̱ din ntiyon nduco. Ma̱n ne, tahque ndeh ca ca̱hcó tah. Conen ná̱n, ne cuahte vo vedeyeno.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chihno min ne, nda̱ sa̱hn che chihnde ta̱h o mil me, ne ra̱hn se ri se ihyan: “Dihvé, o mil te ne u, ne dín ntiyon nduco, nda̱cá te o mil na̱n ntiyon che dín. Condo ta̱h ne che o mil me yahn ne nduco te o mil che quendudona̱n yahn.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ra̱hn patrón yahn se ri ye sa̱hn: “Nda̱hca̱ din. Di ne, redinehn ndudo yehn. Tah ra tume té di, ne nda̱hca̱ din ntiyon nduco. Ma̱n ne, tahque ndeh ca ca̱hcó tah. Conen ná̱n, ne cuahte vo vedeyeno.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chihno min ne, nda̱ sa̱hn che chihnde ta̱h a̱ma mil me, ne ra̱hn se ri se ihyan: “Dihvé, a rendihché ndih che a̱ma cheche chedave yahn ne, ne renedin ndeh ne da̱ya tume yahn ne renda̱ca ne. ");
INSERT INTO cutNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Chemin che hua chihquinó dín ntiyon nduco tume yahn ne, ne tahque ndah tihyón ma̱n ya̱hn. Ma̱n ne, nga̱ yahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: “Di ne, duhtuno ihyan di ma̱n, da̱hnde ma̱n. A devene che cheche chedave yáhn, che renedin ndéh da̱ya tume yáhn renda̱cá. ");
INSERT INTO cutNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Dehco che hua chehn chihque na̱n ba̱nco, ne ma̱n che ndaconán ne, ndonda̱ tá̱h nduco da̱ya?” ");
INSERT INTO cutNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tuhme ra̱hn ye ri ye a̱ma o sa̱hn deca̱hya yahn ye: “Cuehnevi nchuhn tume che nda sa̱hn tih, ne coca̱h ne sa̱hn che va ta̱h ndiche mil. ");
INSERT INTO cutNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tihca̱, te ihyan che va yahn ye ne, ndonda̱ ta̱h ca ye nde nga̱va yahn ye, ate ihyan che tah ra yahn ye ne, nde cuavi tahsihn che va yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma̱n ne, cota̱h ne sa̱hn tih che hua cochihve se, ne cuih nun ne sa̱hn cua̱hn chevah na̱n man. Atihnoca̱ cuahno nducoya̱ca ihyan che duhtuno ihyan ye, te va che co ye castigo yah va̱n ruchiya̱hn. Min cuaco ye ma̱n, cheh dihyon ye ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Cuahn che u che rinducó nducoya̱ca ihyan ndaconan chí numacuahn vederihquentiyon yáhn nduco nducoya̱ca ángel yáhn ne, techeca̱dé numacuahn vedeyudo. ");
INSERT INTO cutNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tuhme ihyan yahn nducuahn nación ne, ndo da̱ma ye ná̱n, ne ca̱hco víh a̱ma ta̱ma ye, nduhca̱ che rihco vih ihyan itecuche va̱n chiva̱to. ");
INSERT INTO cutNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ihyan che ndah ihyan ye ne, ca̱hco víh ihyan la̱do ta̱h cua̱có, ne ihyan che duhtuno ihyan ye ne, ca̱hco víh ihyan la̱do ta̱h cuéh. ");
INSERT INTO cutNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ca̱hmá có ihyan che vate ndi ye la̱do ta̱h cua̱có: “Nchuhn che redin Chidá che ndah nduco ne ne, cochi ne, cuahtenan ne vahchetero na̱n che rihquentiyon ye. Min ne, a ndihcoya̱n ye ca̱va ne nde ro che dendah ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Rineva̱hn che cuahtenan nchuhn min, te cuahn che chi cuicó ne, te ne che chéh ma̱n, cuahn che chi ya̱cá ne, te ne nune chíh ma̱n, cuahn che quechicá ya̱n va̱co ne ne, nevahnecun ne u ndeva̱co ne ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","cuahn che chi cuah tino yáhn ne, te ne tino quenún ma̱n, cuahn che chi cáh ma̱n, cuahn che quenún va̱coya̱hn ma̱n ne, chahn ne chendihchero ne u ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tuhme ndahconan ihyan chahn, ne ca̱hma ye co ye u: “Dihve nuhn, co ndiyu nuhn che chinan nuhn ndih cuahn che rendotenan ne che ra̱hn ne. Hua te nuhn cheh ne ma̱n, hua te nuhn nune chih ne ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","hua nevahnecun nuhn ndih ndeva̱co nuhn ma̱n, hua te nuhn tino quenun ne ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","hua chahn nuhn chendihchero nuhn ndih ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ndahconán, ne ca̱hmá có ihyan: “Cua̱co rá̱hn rí nchuhn te che chinan ne ihyan che ritahno ye u, andahre hua nduh rigonun chihve ye che ra̱hco ihyan ne, anduhneca̱ ndete che a má̱n chinan ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Me ihyan che vatendi ye la̱do ta̱h cuéh ne, ca̱hmá có ihyan: “Nchuhn che a ndinda ne ne, cuavi ne ná̱n, cuahn ne va̱n ruchiya̱hn che a va ya̱n ca̱va chundah nduco ángel yahn se. Min cuahtenun ne cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Hua co ndevá nchuhn, te hua chahtenan cuma ne vedeva̱hino. Chi cuicó, ne hua te ne chéh ma̱n, chi ya̱cá, ne hua te ne nune chíh ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","quechicá ya̱n va̱co ne, ne hua nevahnecun ne u ndeva̱co ne ma̱n, chi cuah tino yáhn, ne hua te ne tino quenún ma̱n. Chi cáh ma̱n, quenún va̱coya̱hn ma̱n, ne hua chahn ne chendihchero ne u.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tuhme ca̱hma ihyan chahn co ye u: “Dihve nuhn, ¿ticua̱hn chi cuico ne ma̱n, chi ya̱ca ne ma̱n, quechica ne ya̱n va̱co nuhn ma̱n, chi cuah tino yahn ne ma̱n, chi cah ne ma̱n, quenun ne va̱coya̱hn ma̱n, ne hua chinan nuhn ndih ne?” ");
INSERT INTO cutNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ndahconán, ne ca̱hmá có ihyan chahn: “Cua̱co rá̱hn rí nchuhn te nducote chaconda̱h veda̱me ne ihyan che ritahno ye u, ndedecadino ne che nde hua rigonun chihve ye ne, anduhneca̱ ndete che a u chaconda̱h veda̱me ne.” ");
INSERT INTO cutNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tuhme dechúh ihyan chahn cuahtenun ye va̱n ruchiya̱hn, co ye castigo, ne ihyan yáhn ne, ndevá ihyan, ne cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuahn che a chihno nte Dihvo vo nducuahn dehtenduh che tuhchan ne, ra̱hn ye ri ye ihyan apóstol yahn ye: ");
INSERT INTO cutNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Nchuhn ne, a devano ne te cuihno o ro ma̱n ne, a vihco ro yudo. U che rinducó nducoya̱ca ihyan ne, va che din se preso u, nahn ya̱h se u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tuhme chidocuya̱n ndina̱n ma̱n, sa̱hn ndina̱n yahn ihyan nación yahn Israel ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, ndo da̱ma se chevah va̱co Caifás, chidocuya̱n che tahque ndina̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Min ntuhno se deh vedema̱yon din se ca̱va che co din se preso Dihvo vo, ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nte ca̱de se che cuahtenan rino se nde chuh vihco ca̱hno se ihyan, te che menda̱hn vihco ne, necuan ihyan ya̱n numacuahn vedeta̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","A̱ma ro min ne, quenan Dihvo vo ya̱n Betania, va̱co Simón, ihyan min che chi ye cah che recha̱ yute ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ura che va ye na̱n mesa reh ye ne, nda̱ a̱ma ta̱hn nda̱hta, nda te a̱ma fra̱sco che ndindah nduco a̱ma na̱n tu che duche alabastro. Fra̱sco me ne, ndito a̱ma na̱n nuneda̱n che a̱ma yahn chihve. Chahn nda̱ te na̱n va Dihvo vo, ne chacota̱hme te nuneda̱n me tin ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","9","Ndihchero ihyan apóstol chahn, ne chi yudo yahn ye, ne ra̱hn ye: ―Hua nda̱hca̱ che redin ta̱hn tih che ndere retoh te nuneda̱n tih, te a̱ma yahn chihve. Tahque nda̱hca̱ din te ndete che ndihcue te, ca̱va che nda̱ca tume conan te ihyan cheva̱h. ");
INSERT INTO cutNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Chihnevan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―¿Dehco che yudo ri yahn nchuhn che tihca̱ din ta̱hnguh?, te nda̱hca̱ che tihca̱ din te ca̱vá. ");
INSERT INTO cutNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ihyan cheva̱h ne, cuahn da̱ma chenun ye va̱n nchuhn, ne conan ne ihyan adecodehno ura che nahn ne, ate u ne, hua cuahn da̱ma conán nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Che chacota̱hme te nuneda̱n u ne, chihcoya̱n te u ca̱va che cuhche ihyan u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Cua̱co rá̱hn rí nchuhn te adecotino che cuahndudo ihyan ndudo ndah yahn Dendiohs numachahte iyehnse ne, ntihyon ya̱n ye nduhca̱ che din te ca̱va che cadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Chihno min ne, Judas Iscariote, a̱ma cha sa̱hn che namin nduco se ndi cuande se va̱n nduh che ndihchio ihyan apóstol chahn ne, chahn se na̱n chidocuya̱n ndina̱n chahn, ");
INSERT INTO cutNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ne ra̱hn se ri se sa̱hn: ―¿Ta̱va nedihve nchuhn u ca̱va che nté Jesucristo ta̱h ne? Tuhme ca̱h sa̱hn ndina̱n chahn ndico ndiche tume diya̱hngua sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nde ura min cana̱n rinuhn ino se a̱ma ura che nda̱hca̱ ca̱va che neca̱h se Dihvo vo ta̱h sa̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Cuahn che a cade a̱ma ro cana̱n vihco ro yudo me, ro che reh ihyan pa̱n che hua nduco ya̱ yahn ne, tumerune ihyan apóstol chahn Dihvo vo: ―¿Ti nahn ne che ca̱hcoya̱n nuhn ca̱va che cheh vino ne che cuande yahn vihco ro yudo ne? ");
INSERT INTO cutNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Cuahn nchuhn viya̱n, va̱co a̱ma ihyan, ne ca̱hma ne co ne ihyan tuhca̱: “Ra̱hn Ihyan Ricuahn yuhn vo te a nda̱ nino ura che ca̱hno se ihyan, ne va̱co ne chihco ca̱de ye che cheh vino ye nduco ihyan apóstol yahn ye ma̱n vihco ro yudo.” ");
INSERT INTO cutNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Dinahn ihyan apóstol chahn nduhca̱ che ra̱hn Dihvo vo, ne chihcoya̱n ye che cheh vino ye nduco vih che cuande yahn ro yudo. ");
INSERT INTO cutNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cuahn che chi vino me ne, chihnde Dihvo vo na̱n mesa cheh vino ye nduco nduh che ndichio ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Numanahn che reh ye ne, ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te a̱ma cha ne ndihcue ndeh ne u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tuhme a̱ma chi nda̱che ihyan chahn, ne cana̱n ca a̱ma ca a̱ma ye ra̱hn ye ri ye Dihvo vo: ―Dihvé, ate co ndiyu u che tihca̱ dín. ");
INSERT INTO cutNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―A̱ma cha nchuhn che reh ne da̱ma nducó chete a̱ma cuh ne, ndihcue ndeh ne u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","U che rinducó nducoya̱ca ihyan ne, va che conahn nducó nducuahn che a ndirun na̱n Ndudo yahn Dendiohs. Ate ¡cheva̱h sa̱hn che ndihcue ndeh se u! Tahque ndah ro yahn se ndete che nde hua chihndeya̱n se. ");
INSERT INTO cutNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Tuhme Judas, sa̱hn min che ndihcue ndeh se ihyan ne, ra̱hn se ri se ihyan: ―Ihyan Ricuahn, ndiyu u che tihca̱ dín. Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Ta̱ca̱ hua, di. ");
INSERT INTO cutNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Numanahn che reh ye ne, cheta̱h Dihvo vo pa̱n, ne neca̱h ye nundihve cuahn Dendiohs. Tuhme ndeh ye, ca̱h ye ihyan chahn, ne ra̱hn ye ri ye ihyan: ―Pa̱n cuh ne, yute yáhn, cocheh nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chihno min ne, cheta̱h ye a̱ma va̱so vino, ne neca̱h ye nundihve cuahn Dendiohs. Tuhme ca̱h ye ihyan chahn, ne ra̱hn ye: ―Cuih nducoya̱ca nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Chu ne, yun yáhn che dito yahn vederihquentiyon ra che nda̱hco ca̱de Dendiohs. Cora yun yáhn, ne nduco chemin a̱ma ya̱hn ihyan nda̱ca ye vederenchahco ca̱va nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Rá̱hn rí nchuhn te ametah ndaconan cúh vino yahn uva nde nda̱ ro che nedin ra Chidá nducuahn dehtenduh. Tuhme ndaconan cuh vo nduco nchuhn na̱n che rihquentiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chihno chita ye himno che a va ndi rita ye ne, cuahn ye cua̱hn cuete Olivo. ");
INSERT INTO cutNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Ma̱n vino ne, ca̱hcoma̱n nducoya̱ca nchuhn u. Conahn Ndudo yahn Dendiohs che ndirun tuhca̱: “Cuahnecún che ca̱hno se ihyan che redin ye cuda̱do itecuche, ne cuihno ca̱no te.” ");
INSERT INTO cutNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ate cuahn che a ntuché va̱n tena̱hn ne, cá̱hn esta̱do yahn Galilea tahque mena̱n ca che co nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Tuhme ra̱hn Pedro ri ye Dihvo vo: ―Andahre nducoya̱ca ihyan sih ca̱hcoma̱n ye ndih, ate u ne, hua ca̱hcomá̱n ndih. ");
INSERT INTO cutNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ra̱hn Dihvo vo ri ye ihyan: ―Cua̱co rá̱hn rí di te ma̱n vino cuh, numanahn che metah cuah tuh ne, ca̱hme ino yune che hua rendihche u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ra̱hn Pedro ri ye Dihvo vo: ―Andahre quenan cuma che cóh da̱ma nduco ne, ate hua ca̱hmá che hua rendihché ndih. ―Atihnoca̱ ra̱hn nducoya̱ca ihyan apóstol chahn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Cuahn che nda̱ Dihvo vo a̱ma cua̱n na̱n che duche Getsemaní ne, rá̱hn ye rí ye ihyan apóstol yahn ye: ―Cuahte nchuhn muhn numanahn che cá̱hn ta̱n ca̱na, cová̱h. ");
INSERT INTO cutNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tume quenda ye Pedro nduco nduh che o da̱ya Zebedeo, ne cuahn ye ca̱na na̱n me. Nda̱ ye min ne, cana̱n a̱ma chi nda̱che ye, ");
INSERT INTO cutNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ne ra̱hn ye ri ye ihyan chahn: ―A̱ma nda̱che rí anduhneca̱ ndete che a cóh che ri nda̱ché. Cuahtenan nchuhn muhn, ne cuahtenduche ne, conduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tuhme cuahn Dihvo vo tah cuahn ca̱na na̱n me, quendih ye ndiya̱hn, cova̱h ye, ne ra̱hn ye: ―Chida má̱n, ndete che co ne, cuahnecun ne che hua chuhríhn nduhca̱ che a va ca̱de. Ate co din ne nduhca̱ che nahn ma̱n ne, ndiyu nduhca̱ che náhn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tuhme ndaconan ye na̱n che vate ihyan apóstol yahn ye. Nta̱ca ye ihyan chahn che vateya̱do ye, ne ra̱hn ye ri ye Pedro: ―¿A nde mare a̱ma ura, hua chicha nchuhn chahtenduche ne, conduco ne u ne? ");
INSERT INTO cutNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cuahtenduche ne, cova̱h ne ca̱va che hua dinahn ne yahn chundah cuahn che tumarande se nchuhn. Cua̱co te a chihco da̱ma ino ne che cocha ne che tumarande se nchuhn, ate anduhneca̱ ndete che ndi i ne, ne hua richa ne. ");
INSERT INTO cutNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ndaconan cuahn Dihvo vo, cova̱h ye na̱n che chi o yune, ne ra̱hn ye: ―Chida má̱n, ndete che hua co che cahnevi ne che va che chuhríhn ne, co nduhca̱ che nahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ndaconan tun ye, ne nta̱ca ye ihyan chahn che vateya̱do ye, te anduhneca̱ ndete che nda vih ndutina̱n ye che a̱ma nahn cuahteya̱do ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chihcoma̱n ye ihyan chahn ne, cuahn tun ye cova̱h ye na̱n che chi ino yune, ne a chemin no cova̱h ye ta̱ma yune. ");
INSERT INTO cutNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tuhme ndaconan ye na̱n che chenun ihyan chahn, ne ra̱hn ye ri ye ihyan: ―Ma̱n che cua̱co ne, cuahteya̱do nchuhn. U che rinducó nducoya̱ca ihyan ne, a nda̱ ura che neca̱h se u ta̱h sa̱hn nunde. ");
INSERT INTO cutNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cuenecuan nchuhn, cuhn vo. Quendi yuno vo sa̱hn che ndihcue ndeh se u, te a cochi nino se. ");
INSERT INTO cutNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nde metah cuihno ca̱hma Dihvo vo cuahn che a nda̱ Judas Iscariote, sa̱hn min che namin nduco se ndi cuande se va̱n nduh che ndichio ihyan apóstol chahn. Nduco se a̱ma ya̱hn se, sa̱hn che nda espa̱da ma̱n, sa̱hn che nda ya̱hn ma̱n. Sa̱hn chahn che dechuh chidocuya̱n ndinan ma̱n, intiyahn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, sa̱hn min che ndihcue ndeh se Dihvo vo ne, a nente ca̱de se nduco sa̱hn chahn tuhca̱: ―Ihyan che tená̱n ihyan ne, a ihyan min. Co din nchuhn preso ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ndeta̱hno chahn nda̱ se na̱n Dihvo vo, ne ra̱hn se ri se ihyan: ―Necuma ndih, Ihyan Ricuahn yáhn. Tuhme tena̱n se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ra̱hn Dihvo vo ri ye sa̱hn: ―Amigo yáhn, codin nome ntiyon che cochi. Tuhme tumanga̱n sa̱hn chahn Dihvo vo, din se preso ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","A̱ma cha ihyan apóstol che nduco Dihvo vo ne, ndetenda̱h ye espa̱da yahn ye, ne chahn ye sa̱hn deca̱hya yahn chidocuya̱n ndina̱n, chaconda̱h ye revan se. ");
INSERT INTO cutNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tuhme ra̱hn Dihvo vo ri ye ihyan min: ―Cuentihyon ndah espa̱da yehn. A devene te duh ihyan che ca̱hno ye nduco espa̱da ne, nduco espa̱da va che coh ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Cuedevene te co ca̱cá Chidá, ne ndeta̱hno dechuh ye a̱ma ya̱hn ángel, ndedevahn ye u. ");
INSERT INTO cutNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ate hua dín tihca̱, te a ndirun na̱n Ndudo yahn ye che a tihca̱ va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Chihno min ne, ra̱hn Dihvo vo ri ye sa̱hn che din se preso ihyan: ―Ro ro quenún che chete ya̱co va̱n nchuhn chicuáhn, ¿dehco che hua min din ne preso u? ¿Ta̱ca̱ che muhn cochi ne, nda ne espa̱da ma̱n, ya̱hn ma̱n, din ne preso u, anduhneca̱ ndete che sa̱hn duco u? ");
INSERT INTO cutNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ate tihca̱ va che cuahnó ca̱va che conahn Ndudo yahn Dendiohs che dirun ihyan profeta. Me ihyan apóstol chahn ne, chihcoma̱n ye Dihvo vo, chihno chano ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sa̱hn che din se preso Dihvo vo ne, quenda se ihyan na̱n Caifás, chidocuya̱n che tahque ndina̱n. Min nto da̱ma intiyahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro ne, quendi ye Dihvo vo diyahn diyahn nde nda̱ ye chevah va̱co chidocuya̱n che tahque ndina̱n, ne min chihnde ye da̱ma nduco sa̱hn policía chahn, te nahn cadino ye deh co nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Chidocuya̱n ndina̱n ma̱n, sa̱hn intiyahn ma̱n ne, rinuhn ino se a̱ma nunde che ndere cacueh da̱me se Dihvo vo ca̱va che co ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ate nde a̱ma nunde hua chi chicueh da̱me se ihyan, andahre a̱ma ya̱hn se ndere chica nunde se yahn ye. Chihno min ne, nda̱ te o se che ndere chica nunde se yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ne ra̱hn se: ―Ihyan tih ne, ra̱hn ye te co ndahtera ye ya̱co, ne chete che ino ro ne, na̱hno ye. ");
INSERT INTO cutNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tuhme necuan ndi chidocuya̱n che tahque ndina̱n me, ne ra̱hn ri ye Dihvo vo: ―¿Dehco che hua rendahconen yahn sa̱hn sih che tihca̱ rica nunde se yehn? ");
INSERT INTO cutNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ate Dihvo vo ne, nde a̱ma hua ra̱hn ye. Tuhme ra̱hn chidocuya̱n ndina̱n me ri ye ihyan: ―Numacuahn vederihquentiyon yahn Dendiohs che va ye vahchetero ne, ricá di che ca̱hma cuaque co nuhn ndete che di che Da̱ya Dendiohs, ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―A u, nduhca̱ che ra̱hn ne. Namin cuedevano nchuhn che u che rinducó nducoya̱ca ihyan ne, ndihchero ne u che vá la̱do ta̱h cua̱co Dendiohs, ihyan min che a̱ma yudo vederihquentiyon quenan cuma ye. Namin ndihchero ne che chí va̱n man. ");
INSERT INTO cutNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ndeta̱hno chihngun chidocuya̱n ndina̱n me cahteca ye, te ra̱hco ye che ducherino Dihvo vo Dendiohs che tihca̱ ndahconan ye. Tuhme ra̱hn ye: ―¿Dehca din vo testigo ne? ¡Ducherino se Dendiohs! A ma̱n nchuhn chihnevan ne nduhca̱ che ra̱hn se. ");
INSERT INTO cutNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ma̱n ne, ¿deh ra̱hn nchuhn ne? Ndahconan sa̱hn intiyahn chahn, ne ra̱hn se: ―Sa̱hn tih ne, quendihco se nunde, ne quenan cuma che coh se. ");
INSERT INTO cutNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tuhme ca̱hnun dan se va̱cona̱n ye, ne chahn se ihyan. Na̱hn se ne, chahn se vacona̱n ye, ");
INSERT INTO cutNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ne ra̱hn se ri se ihyan: ―Di che rahn che Dendiohs dechuh ye di, ndedevehn ihyan iyehnse, cahme duh chahn di. ");
INSERT INTO cutNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Numanahn min ne, va Pedro cua̱hn chevah me. Chahn nda̱ a̱ma ta̱hn deca̱hya yahn chidocuyan ndina̱n me na̱n ye, ne ra̱hn te ri te ihyan: ―Namin di ne, chindoque Jesús yahn esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ate ra̱hn Pedro ri ye ta̱hn na̱n nducoya̱ca ihyan: ―Nde hua devanó deh yahn che tihca̱ rahn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tah cuahn adive ne, cuahn ye cua̱hn nino chendevah. Ndihchero ta̱ma te ihyan, ne ra̱hn te ri te sa̱hn che chenun se min: ―Namin sa̱hn tih ne, chinduco se Jesús yahn ya̱n Nazaret. ");
INSERT INTO cutNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ndahconan Pedro ta̱ma yune, ne ra̱hn ye: ―Nde muhn nde na̱n Dendiohs, hua rendihché duh ihyan che ra̱hn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Namena̱n me ne, chahn nda̱ sa̱hn che chenun se min na̱n ye, ne ra̱hn se ri se ihyan: ―Cua̱co niyon che chindoque ihyan ca̱h, te a ndero ndi nde na̱n ndudo yehn. ");
INSERT INTO cutNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ndaconan ntihyon ya̱n ye Dendiohs, nde ra̱hva ye, ne ra̱hn ye: ―Hua rendihché duh ihyan ca̱h che ra̱hn nchuhn. A ura min no cah a̱ma tuh. ");
INSERT INTO cutNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Neca̱hco Pedro ndudo che ra̱hn Dihvo vo ri ye ihyan tuhca̱: “Numanahn che metah cuah tuh ne, cahme ino yune che hua rendihche u.” Tuhme ndiquenda̱h ye, ne a̱ma chaco ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Chi dave ta̱ma ro me ne, nducoya̱ca chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n ne, ntuhno se nduco vih ca̱va che ca̱hno se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Dechiche se ihyan, ne quenda se ihyan, neca̱h se ihyan ta̱h gobernador Pila̱to. ");
INSERT INTO cutNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cuahn che checadino Judas che a va che ca̱hno sa̱hn chahn Dihvo vo ne, ndo yah se, ne chahn se neca̱h se nduh che ndico ndiche tume diya̱hngua me ta̱h chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n, ne ra̱hn se ri se sa̱hn: ");
INSERT INTO cutNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","―U ne, quendihcó nunde na̱n Dendiohs, te nda̱hcó ta̱h nchuhn a̱ma ihyan che nde a̱ma nunde hua quendihco ye ca̱va che ca̱hno ne ihyan. Ndahconan sa̱hn chahn, ne ra̱hn se ri se Judas: ―Ta̱n condihche ta̱ca̱ din. Nuhn ne, hua cuande yahn nuhn chemin. ");
INSERT INTO cutNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tuhme a min chete ya̱co ndunan Judas tume me sa̱hn chahn, ne chahn se tihyon se ihyo da̱ndo se, chihno ma̱n se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nedin da̱ma chidocuya̱n ndina̱n chahn tume me, ne ra̱hn se nduco vih: ―Nduhca̱ che rihquentiyon ley ne, hua co nedin da̱mo vo tume cuh nduco tume vedino, te chu ne, tume yahn yun. ");
INSERT INTO cutNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ndeta̱hno nte ca̱de se nduco vih, ne ca se a̱ma ndi ya̱hn nduco tume min ca̱va che nda̱ca na̱n che cuehche ihyan nación chena̱hn. Ro mena̱n me ne, duche ya̱hn min Ya̱hn yahn Sa̱hn che Redendah Chite Ya̱hn, ");
INSERT INTO cutNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ate nde ro min ne, nuhnde duche Ya̱hn yahn Yun. ");
INSERT INTO cutNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Tihca̱ chinahn Ndudo yahn Dendiohs che dirun ihyan profeta Jeremías tuhca̱: “Nduhca̱ che chihco ca̱de Dihvo vo Dendiohs ne, ndico ndiche tume diya̱hngua chihco ihyan nación yahn Israel che rigonun chihve ihyan min. Toh ihyan chahn tume me, ca ye ya̱hn che duche Ya̱hn yahn Sa̱hn che Redendah Chite Ya̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Cuahn che a nti Dihvo vo na̱n gobernador ne, tumerune se ihyan: ―¿A ndih che Rey yahn ihyan nación yahn Israel ne? Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―U, a nduhca̱ che rahn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n ne, cana̱n a̱ma rica nunde se yahn Dihvo vo, ate nde a̱ma hua ndahconan ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tuhme ra̱hn Pila̱to ri se ihyan: ―¿Dehco che hua rendahconan ne che rica nunde sa̱hn sih yahn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A namin no tun nde a̱ma ndudo hua ndahconan ye yahn se, ne a̱ma chahn ino se. ");
INSERT INTO cutNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Va a̱ma costumbre che nduyo nduyo che renda̱ vihco ro yudo ne, va che nta̱hte gobernador a̱ma preso, adecochano sa̱hn che ca̱ca ihyan ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ta̱hn min ne, va a̱ma sa̱hn preso che a̱ma duhtuno ihyan se, duche se Barrabás. ");
INSERT INTO cutNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","Ura min ne, a̱ma ndo da̱ma ihyan ya̱n, ne nducote tumacadino Pila̱to che redin ve chidocuya̱n ndina̱n chahn yahn Dihvo vo, rica nunde se yahn ye ne, chemin che tumerune se: ―¿Cha preso nahn nchuhn che nta̱hté, a Jesús che ra̱hn ne che Cristo ye o Barrabás ne? ");
INSERT INTO cutNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Numanahn min ne, dechuh nda̱hta yahn se ndudo, ra̱hn te tuhca̱: “Ihyan tih ne, nde a̱ma nunde hua quendihco ye. Condi din tan nduco ye, te icuino ne, a̱ma chihnga̱ chihnó che va che conahn a̱ma venecuino ndete che din tan nduco ye.” ");
INSERT INTO cutNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Me chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n ne, chicha yahn se chinun se ihyan ya̱n che ca̱ca ye Pila̱to che nta̱hte se Barrabás ma̱n, che ca̱hcantiyon se che coh Dihvo vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ndaconan tumerune Pila̱to ihyan chahn, ne ra̱hn se: ―Tuhme ne, ¿cha preso nahn nchuhn che nta̱hté ne? Ndahconan ihyan ya̱n chahn, ne ra̱hn ye: ―Cuenta̱hte ne Barrabás. ");
INSERT INTO cutNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tuhme tumerune se ihyan chahn: ―Me Jesús che ra̱hn nchuhn che Cristo ye, ¿deh din nduco ye ne? Ndahconan nducoya̱ca ihyan chahn, ne ra̱hn ye: ―Cuihquentiyon ne che conan ya̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ra̱hn Pila̱to ri se ihyan chahn: ―¿Ta̱ca̱ che conan ya̱h ye?, te hua quendihco ye nde a̱ma nunde. Ate nde tahque dito cah ihyan chahn: ―Cuihquentiyon ne che cona̱n ya̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ndihchero Pila̱to te hua rendo ndudo ihyan chahn. Tahque ndah nde tahque vari chende ca ye, ne tahve se che chehua nune. Na̱no se ta̱h se na̱n nducoya̱ca ye, ca̱hco ro se che hua nahn cuehda̱me se nunde min, ne ra̱hn se: ―Ihyan cuh ne, hua quendihco ye nde a̱ma nunde. U ne, hua náhn che conan ya̱h ye, ate co nduhca̱ che nahn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ra̱hn nducoya̱ca ihyan chahn: ―Cuihquentiyon ne che conan ya̱h ye. Nuhn nduco da̱ya nuhn cuehda̱me nuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tuhme nta̱hte Pila̱to Barrabás nduhca̱ che nahn ihyan chahn, ne chihquentiyon se sanda̱do yahn se che chahn se Dihvo vo. Chihno min ne, tahve se sa̱hn che quenda se ihyan, cuaconahn ya̱h se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Quenda sanda̱do chahn Dihvo vo chete pala̱cio, ne nedin da̱ma se nducoya̱ca combiero yahn se na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chehnevi se tino mena̱n yahn ye, ne tihyon se a̱ma tino cua̱h ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Denda se a̱ma corona ya̱n, tihyon se tin ye, ne ca̱h se a̱ma nducodi quetuhma ye ta̱h cua̱co ye. Chihno min ne, chehntihya se na̱n ye redin duche yahn se ihyan, ne ra̱hn se ri se ihyan: ―Rendeva nuhn yavena̱n ne, Rey yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Reca̱hnan dan se ihyan ma̱n, reta̱h se nduco me rahn se tin ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Chihno che din duche yahn se ihyan tihca̱ ne, chehnevi se tino cua̱h me, ndaconuhn se tino yahn ma̱n ye ihyan. Tuhme quenda se ihyan na̱n che nahn ya̱h se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cuahn che a chenun yune se ne, ta̱hn nun se a̱ma ihyan ya̱n Cirene che duche ye Simón, ne chihquentiyon se ihyan che quenda ye cruz na̱n che conan ya̱h Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nda̱ se a̱ma cuete che duche Gólgota, che conahn Cuete Ine Tin Tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Min ca̱h se vino che ndihcheta̱hn nduco da̱h ite, cuh Dihvo vo, ate dechihn ye, ne hua chih ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cuahn che a chihno nahn ya̱h sanda̱do chahn Dihvo vo ne, tenda̱h se suerte yahn se cha sa̱hn quenda̱h yahn se che co yahn se tino yahn ye. Tihca̱ chinahn Ndudo yahn Dendiohs che dirun ihyan profeta tuhca̱: “Tenda̱h se suerte yahn se cha sa̱hn quenda̱h yahn se che co yahn se tino yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chihno min ne, chahtenan se cuda̱do ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tin cruz ne, chaconahn letra na̱n che ndirun nunde yahn ye tuhca̱: “Ihyan cuh che Jesús, Rey yahn ihyan nación yahn Israel.” ");
INSERT INTO cutNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Namin chenan ya̱h o sa̱hn duco chihto na̱n ye, a̱ma se la̱do ta̱h cua̱co ye, ne ta̱ma se la̱do ta̱h cueh ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ihyan che rechuh ye min ne, redin duche yahn ye ihyan, rahco tin ye, ne ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―Di che rahn che ndahtere ya̱co, ne nahne chete ino ro, cuendedevahn man di. Ndete che Da̱ya Dendiohs di ne, cuenchehn na̱n cruz tih. ");
INSERT INTO cutNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chidocuya̱n ndina̱n ma̱n, sa̱hn intiyahn ma̱n, sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, namin nda̱hchenan se Dihvo vo, ne ra̱hn se va̱n ma̱n se nduco vih: ");
INSERT INTO cutNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ndedevahn se ta̱ma ca ihyan, ate ma̱n se ne, hua ri rendedevahn se sa̱hn. Ndete che cua̱co che Rey yahn ihyan nación yahn Israel sa̱hn ne, nchahn se na̱n cruz ca̱va che cotahno vo sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ra̱hn se te ndichahtino se Dendiohs ma̱n, che Da̱ya ye sa̱hn ma̱n. Ma̱n ne, ndihchero vo ndete che cua̱co che yahino ye sa̱hn, ndedevahn ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nde sa̱hn duco che chenan ya̱h se da̱ma nduco ye ne, nda̱hchenan se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ro min ne, chi man numachahte iyehnse, cana̱n nde inguiya̱hn, ne quendi nde na̱n rahco ino a chino. ");
INSERT INTO cutNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ura min a̱ma dito cah Dihvo vo, ne ra̱hn ye: ―Elí, Elí, ¿lama sabactani? ―che conahn tuhca̱: Dendiohs yáhn, Dendiohs yáhn, ¿dehco che chihcoma̱n ne u ne? ");
INSERT INTO cutNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na̱hn sa̱hn che chenun se min ne, chihnevan se che tihca̱ ra̱hn ye, ne ra̱hn se: ―Rah se ihyan profeta Elías. ");
INSERT INTO cutNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ndeta̱hno chahn a̱ma se, rano se, chehua se a̱ma na̱n che deca̱ cuche deca̱, ne deca̱hnda se nduco vino che a nchuhnan yahn. Dechiche se tin a̱ma nduco, ca̱h se che tihve Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ate sa̱hn chena̱hn chahn ne, ra̱hn se: ―Cuihcoman sa̱hn. Ndihchero vo ndete che chi Elías ndedevahn ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ura min ne, a̱ma dito cah Dihvo vo ta̱ma yune, ne chih ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ndeta̱hno chendan tino che quendihco chete ya̱co. Chica nde ya̱co, chiya nde ndiya̱hn, ndo o ndi. Namin a̱ma nuhn ya̱hn ma̱n, ndah ya̱va ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","na̱ne ya̱yan ma̱n, ne ntuche a̱ma ya̱hn tena̱hn che chitahno ye Dendiohs cuahn che chahtenan ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ihyan chahn ne, nde ro che ntuche Dihvo vo, chihnde ro ye ya̱n Jerusalén, ya̱n yahn Dendiohs, ne a̱ma ya̱hn ihyan ndihchero ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Me sa̱hn capitá̱n nduco sanda̱do yahn se che chenan se cuda̱do Dihvo vo ne, a̱ma dihya se chi che nuhn ya̱hn ma̱n, che chinahn vederihno chena̱hn ma̱n, ne ra̱hn se: ―Cua̱co niyon te a ihyan cuh che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A̱ma ya̱hn ihyan nda̱hta vatendi ye a̱ma la̱do rendihche ye Dihvo vo. Ihyan chahn che chinan ye ihyan na̱n ntiyon yahn ye, ne chinduco ye ihyan cuahn che chica ye esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Va̱n ihyan chahn ne, nduco María yahn ya̱n Magdala ma̱n, María, ihyan nda̱hta yahn Zebedeo, ihyan min che chaco Jacobo nduco José ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cuahn che a chi chino ne, nda̱ a̱ma ihyan cuihca yahn ya̱n Arimatea, che duche ye José. Ihyan min ne, namin ritahno Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Chahn ye na̱n Pila̱to, chica ye permiso ca̱va che cuhche ye Dihvo vo. Tuhme chihquentiyon Pila̱to sanda̱do yahn se che neca̱h se Dihvo vo ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chahn ye, ndedevah ye Dihvo vo, chacotuhma ye ihyan nduco a̱ma tino cua, ");
INSERT INTO cutNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ne chacondihte ye ihyan chete a̱ma ya̱yan ra che ndihquentiyon ye che ndindah na̱n ya̱va ca̱va ma̱n ye. Chihno min ne, neca̱hde ye chende ya̱yan me nduco a̱ma tu chahno, ne cona̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Min chihto ya̱yan me, va María yahn ya̱n Magdala nduco María che ta̱ma me. ");
INSERT INTO cutNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ta̱ma ro me, a ro che rahtetuhno ihyan ne, chahn chidocuya̱n ndina̱n nduco sa̱hn fariseo na̱n Pila̱to, ");
INSERT INTO cutNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ne ra̱hn se ri se sa̱hn: ―Ihyan ndina̱n yahn nuhn, neca̱hco nuhn nduhca̱ che ra̱hn sa̱hn rihncheh min te cuino ino ro che coh se ne, ntuche se va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chemin che cochi nuhn ndihchero nuhn ndih che co cuda̱do ya̱yan yahn se nde cuihno ino ro. Ndete che hua ne, dena̱n ca̱hn sa̱hn apóstol yahn se, ndetenda̱h se sa̱hn chete ra̱hn quenda se sa̱hn, ne ca̱hma se che ntuche se va̱n tena̱hn, nde tahque cahncheh se ihyan che co ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ra̱hn Pila̱to ri se sa̱hn: ―Nga̱ sanda̱do chenun se min. Cuiquenda nchuhn sa̱hn, cuahtenan se cuda̱do ya̱yan me nduhca̱ che nahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tuhme chahn sa̱hn chahn, chaconahn se sello chende ya̱yan me, ne chaconahn se sanda̱do chahn, din se cuda̱do. ");
INSERT INTO cutNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ta̱ma ro me, ro che ndeva ndate ne, cuahn María yahn ya̱n Magdala nduco María che ta̱ma me vatiya̱n da̱hca na̱n ya̱yan me. ");
INSERT INTO cutNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Adena̱n chiya a̱ma ángel yahn Dihvo vo Dendiohs, chehnevi ye tu che ndi chendevah yahn ya̱yan me, ne chihnde ye mena̱n. Numanahn min ne, a̱ma dito nuhn ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angel me ne, a̱ma diya̱hn ro ye, ne tino yahn ye ne, a̱ma cua nduhca̱ che ro ihve. ");
INSERT INTO cutNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ndihchero sanda̱do chahn ángel me, ne a̱ma dihya se chi, nde tuno ndoh se che va̱h se. Va̱n canedihya min ne, nde chih yute se ma̱n, nde chi i se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ra̱hn ángel me ri ye ihyan nda̱hta chahn: ―Hua dihya nchuhn co. A devanó che nda̱ ne ndihchero ne Dihvo vo Jesucristo, ihyan min che quenan ya̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Metah ye muhn, te a ntuche ye va̱n tena̱hn nduhca̱ che a ra̱hn ye ro mena̱n. Cochi ne ndihchero ne chete ya̱yan na̱n che quendite ye. Metah ye min. ");
INSERT INTO cutNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tuhme cuahn ne tenun tenun no ca̱hma ne co ne ihyan apóstol yahn ye che a ntuche ye va̱n tena̱hn, ne ca̱hn ye esta̱do yahn Galilea tahque mena̱n ca che co nchuhn. Min ndihchero ne ihyan. A chemin no che va che có nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ihyan nda̱hta chahn ne, quenun ca canedihya ihyan, te a̱ma dihya ye chi. Tuhme cona̱hn ye rano ye, a̱ma yeno ye, quengo ye ndudo yahn ihyan apóstol. ");
INSERT INTO cutNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ura min chihnde ro Dihvo vo na̱n ihyan chahn, ne neca̱h ye Dendiohs ihyan. Tuhme chahn nda̱ ihyan chahn na̱n ye, ne chehntihya ye chahtemahn ye ca̱h ye, ndeva ye yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Hua dehve ra̱hco nchuhn. Cuahn ne co ne ihyan apóstol yáhn che cá̱hn esta̱do yahn Galilea, ne min ndihchero ye u. ");
INSERT INTO cutNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Numanahn che cuahn ihyan nda̱hta chahn ne, chena̱hn a̱ma o sanda̱do che chenan se cuda̱do ya̱yan me, chengo se chidocuya̱n ndina̱n chahn nducuahn che chi. ");
INSERT INTO cutNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Chidocuya̱n ndina̱n chahn ne, ntuhno se nduco sa̱hn intiyahn, ne a̱ma ndeh tume ca̱h se sanda̱do chahn, ne ra̱hn se ri se sa̱hn: ");
INSERT INTO cutNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","―Nchuhn ne, ca̱hma ne te chete ra̱hn numanahn che vateya̱do ne ne, nda̱ apóstol yahn sa̱hn min, ndetenda̱h se sa̱hn, quenda se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Me ndete che cadino gobernador ne, ca̱hmanan nuhn nchuhn, ne hua dehva co yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cheta̱h sanda̱do chahn tume me, ne chacotuhn se ndudo nduhca̱ che ca̱h cuande chidocuya̱n chahn sa̱hn, ne chihnde ndudo me va̱n ihyan nación yahn Israel nde ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Me ihyan apóstol chahn ne, cuahn ye esta̱do yahn Galilea, tingüete na̱n che a ra̱hn Dihvo vo nduco ye ro mena̱n me. ");
INSERT INTO cutNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Min ndihchero ye Dihvo vo, ne ndeva ye yavena̱n ye. Ate a̱ma o ye ne, ra̱hco ye te ndiyu ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tuhme chahn nda̱ Dihvo vo na̱n ihyan chahn, ne ra̱hn ri ye ihyan: ―U ne, nducote nda̱hco Dendiohs nducuahn vederihquentiyon che va vahchetero ma̱n, iyehnse ma̱n, tá̱h ne, ");
INSERT INTO cutNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","chemin che rihquentiyón nchuhn che ca̱hn ne nducuahn nación, cacuahn ne ihyan ca̱va che cotahno ye u. Cuehdenune ne ihyan numacuahn vederihquentiyon yahn Dendiohs Chida ma̱n, Dendiohs Da̱ya ma̱n, Vaco ndah yahn Dendiohs ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Namin cuicuahn ne ihyan che dinahn ye nducuahn che a chihquentiyón nchuhn. Cuedevano ne te hua ca̱hcomá̱n nchuhn, te conducó nchuhn ro ro, nde ro che nto iyehnse. Tihca̱ co.");
INSERT INTO cutNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Tuhca̱ cana̱n ndudo ndah yahn Dihvo vo Jesucristo, Da̱ya Dendiohs: ");
INSERT INTO cutNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ihyan profeta Isaías dirun ye tuhca̱: Ra̱hn Dendiohs ri ye Da̱ya ye: “Dechúh a̱ma sa̱hn che cuahndudo se ndudo yáhn numanahn che metah cahn, ca̱va che ca̱hcoya̱n se ihyan che nevahnecun ye di. ");
INSERT INTO cutNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sa̱hn min ne, conan se ya̱hn na̱n che metah duhva, ne ndo da̱ma ihyan, cahnevan ye ndudo yahn se. Ca̱hma se tuhca̱: Cuihcoya̱n nchuhn chedave yahn ne, te a cochi Dihvo vo.” ");
INSERT INTO cutNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ndudo min ne, chinahn cuahn che cana̱n Jua̱n Bautista rahndudo ye min ya̱hn na̱n che metah duhva. Ra̱hn ye ri ye ihyan che rahn ye rihnevan ye: ―Cuento ino nchuhn nunde yahn ne, cuedenune ne ca̱va che nchahco Dendiohs yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ihyan ya̱n Jerusalén ma̱n, ihyan ya̱n chena̱hn esta̱do yahn Judea ma̱n, a̱ma ya̱hn ye rahn ye rihnevan ye che rahndudo Jua̱n. Rentuma ino ihyan chahn nunde yahn ye, ne rehdenune Jua̱n ihyan ico Jordán. ");
INSERT INTO cutNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jua̱n ne, quenun ye a̱ma tino che ndindah nduco yudo yahn ite che duche te camello, ne quenan chete ye a̱ma ima. Reh ye ya̱hcada̱hn, ne rih ye nedih yahn che va va̱n chano. ");
INSERT INTO cutNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rahndudo ye tuhca̱: ―Caviya̱n deman ne, nda̱ a̱ma ihyan che tahque yudo vederihquentiyon quenan cuma ye che co u. U ne, nde hua rigonun chihvé na̱n ihyan min ca̱va che conán ihyan na̱n ntiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","U ne, atena̱n rehdenuné nchuhn, ate ihyan min ne, din ye che conun Vaco Ndah yahn Dendiohs nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ta̱hn min ne, chica Dihvo vo ya̱n Nazaret, esta̱do yahn Galilea, nda̱ ye na̱n che quenun Jua̱n, ne chehdenune Jua̱n ihyan ico Jordán. ");
INSERT INTO cutNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cuahn che a ndiquenda̱h Dihvo vo va̱n nune ne, ndihchero ye che ndondah vahchetero, ne nduhca̱ che ro a̱ma icui ne, tihca̱ chi ro Vaco Ndah yahn Dendiohs, chiya, quenun ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chihnevan ye a̱ma ndudo che chica vahchetero che ra̱hn: ―Di che Da̱yá. Yahinó di. A̱ma yenó ndoque. ");
INSERT INTO cutNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Chihno min ne, din Vaco Ndah yahn Dendiohs che cuahn Dihvo vo ya̱hn na̱n che metah duhva. ");
INSERT INTO cutNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Min quenan ye chete che o raco ro, ne chundah, sa̱hn min che duche se Satanás ne, retumarande se ihyan. Quenun Dihvo vo na̱n che vate ite chano, ne nda̱ ángel, chinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Adive che chaconuhn sanda̱do Jua̱n Bautista va̱coya̱hn ne, cona̱hn Dihvo vo esta̱do yahn Galilea, ne min rahndudo ye ndudo ndah yahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ra̱hn ye: ―A tuno ro. Ma̱n ne, a nun ca̱hcantiyon Dendiohs chedave yahn ihyan. Cuento ino nchuhn nunde yahn ne. Cuitahno ne ndudo ndah yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A̱ma ro che quechica Dihvo vo cua̱hn chihto vine yahn Galilea ne, ndihchero ye Simón nduco dihno se, Andrés. Sa̱hn chahn ne, sa̱hn reta̱h ya̱hca, ne ura min ne, rih se ya̱na yahn se chete vine me. ");
INSERT INTO cutNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tuhme ra̱hn ye ri ye sa̱hn: ―Cuhn vo nduco nchuhn. Cuinduco ne u, ne nduhca̱ che redin ne ntiyon reta̱h ne ya̱hca ne, tihca̱ cacuáhn nchuhn ntiyon che cuacotuhn ne ndudo yáhn, ca̱va che cotahno ihyan u, conduco ye u. ");
INSERT INTO cutNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ndeta̱hno chihcoma̱n sa̱hn chahn ya̱na yahn se, ne cuahn se chinduco se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tah cuahn ca̱na na̱n min ne, nta̱ca ye o da̱ya Zebedeo, Jacobo nduco Jua̱n. Chenun se chete ba̱rco, renta̱hyon nan se ya̱na yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ya̱hve ye sa̱hn, ne chihcoma̱n se chida se Zebedeo chete ba̱rco me nduco mozo yahn ye, ne cuahn se chinduco se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Adive ne, nda̱ Dihvo vo ya̱n Capernaum nduco sa̱hn chahn. Ndate ndate, ro che rahtetuhno ihyan ne, rahn Dihvo vo ya̱co yahn ihyan nación yahn Israel, ricuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rahn ino nducoya̱ca ihyan che rihnevan ye che ricuahn Dihvo vo, te tumacadino ye che quenan cuma ye vederihquentiyon che tahque chahte che co che quenan cuma sa̱hn devano ley che dirun Moisés. ");
INSERT INTO cutNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Min chete ya̱co me ne, quenun a̱ma sa̱hn che quenun vaco chihnga̱ sa̱hn. Cah se: ");
INSERT INTO cutNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Ndih, Jesús yahn ya̱n Nazaret, ¿dehco che reca̱hdenun ne yune yahn nuhn? ¿Ta̱ca̱ che cochi ne decuihno ne nuhn? A devanó duh ndih. Ndih ne, ihyan ndah che a va ca̱de che dechuh Dendiohs ca̱va che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dihvo vo ne, chihco yudo ye yahn vaco chihnga̱ me, ne ra̱hn ye: ―¡Cuihnde dihn chende! ¡Cuendiquendah sa̱hn tih! ");
INSERT INTO cutNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuhme din vaco chihnga̱ me che a̱ma rendoh sa̱hn min. A̱ma cah, ne ndiquenda̱h sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Rahn ino nducoya̱ca ihyan che chenun ye min, ne tumerune vih ye: ―¿Deh che ri ne? ¿Deh conahn ndudo ra che ricuahn ihyan tih ne? ¡A̱ma chahte vederihquentiyon quenan cuma ye! ¡Rihquentiyon ye nde vaco chihnga̱ che chenun ihyan che ndiquenda̱h, ne redinahn yahn ye! ");
INSERT INTO cutNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nduco tihca̱ ne, ndudo yahn vederihno che redin Dihvo vo ne, a̱ma nun chetuhn numachahte esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cuahn che ndiquenda̱h Dihvo vo chete ya̱co me ne, cuahn ye nduco Jacobo ma̱n, Jua̱n ma̱n, ndeva̱co Simón nduco Andrés. ");
INSERT INTO cutNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Inda̱hn Simón ne, quendite ye, neta̱h cah ihno ihyan. Ihyan ndeva̱co ye ne, ra̱hn ye ri ye Dihvo vo che cah ye. ");
INSERT INTO cutNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tuhme chahn nda̱ Dihvo vo, ne cheta̱h ye ta̱h ihyan min, ndedecuan ye ihyan. Ndeta̱hno chavi ihno me yahn ye, ne ca̱h ye, cheh ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cuahn che a chi chino me, ura che a chehche ya̱hn ne, ihyan viya̱n ne, quenda ye a̱ma ya̱hn ihyan cah ma̱n, ihyan che chenun vaco chihnga̱ ihyan ma̱n, na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A nahn nducoya̱ca ihyan ya̱n ne, ndo da̱ma ye chendevah. ");
INSERT INTO cutNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Din Dihvo vo che ndoyahn ihyan cah chahn, che a̱ma ndeh na̱n cah ndi ye, ne ndetenda̱h ye vaco chihnga̱ che chenun ihyan. Ate hua ca̱h yune ye che ca̱hma duh ihyan ye, te a devano che Da̱ya Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A̱ma vatiya̱n da̱hca, ura che metah co dave ndah ne, necuan Dihvo vo, cuahn ye cua̱hn chihto ya̱n, ne min cova̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Tah cuahn adive ne, cuahn Simón nduco combiero yahn ye, quenuhn ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cuahn che nta̱ca ye ihyan ne, ra̱hn ye ri ye ihyan: ―A̱ma ya̱hn ihyan nahn ndihchero ye ndih. ");
INSERT INTO cutNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ate ra̱hn Dihvo vo ri ye ihyan chahn: ―Cuhn vo nduco nchuhn ta̱ma te o ya̱n che nino ca̱va che cuahndudó min, te ca̱va chemin che cochí. ");
INSERT INTO cutNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tuhme cuahn Dihvo vo nduco ihyan chahn numachahte esta̱do yahn Galilea. Rahndudo ye chete ya̱co yahn ihyan nación yahn Israel, ne rendetenda̱h ye vaco chihnga̱ che chenun ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","A̱ma yune ne, a̱ma sa̱hn che ndi se cah che recha̱ yute ne, cuahn nda̱ se na̱n Dihvo vo. Chehntihya se na̱n ye, ne ra̱hn se: ―Ndete che nahn ne ne, co din ne che ndoyáhn. ");
INSERT INTO cutNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Dihvo vo ne, quenan va̱hino ye sa̱hn. Nahn ta̱h ye sa̱hn, ne ra̱hn ye: ―Ta̱ca̱ hua. Conán di. Ma̱n ne, a ntoyehn. ");
INSERT INTO cutNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ndeta̱hno chavi cah che recha̱ yute se me, ne ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tuhme ndedechuh ye sa̱hn cua̱hn ndeva̱co se. A̱ma ca̱h ye cuda̱do sa̱hn, ne ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Condihche. Condicate cahme nduco nde a̱ma ihyan ta̱ca̱ chi che ndoyehn. Tahque ndah ne, cuehn na̱n chidocuya̱n, ndihche ye di, ne cah vedino che ndihquentiyon Moisés, ca̱va che codevano nducoya̱ca ihyan che a ntoyehn. ");
INSERT INTO cutNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sa̱hn min ne, cona̱hn se, ate hua dinahn se. Cana̱n rente se nduhca̱ che chahno se chi, ne a̱ma chetuhn ndudo me, nde ametah chi chenda̱ Dihvo vo nde a̱ma ya̱n ura che co nchana̱n ihyan viya̱n ihyan. Tahque ndah ye ne, quechica ye a̱ma la̱do, ya̱hn na̱n che metah duhva. Ate ata̱noca̱ nduh, min rahn ihyan yahn nducuahn ya̱n rendihchero ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Chihno neve ro ne, chenda̱ tun Dihvo vo ya̱n Capernaum, ne ihyan ya̱n min ne, checadino ye che quenun ye a̱ma cua̱n vah. ");
INSERT INTO cutNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ndeta̱hno ndo da̱ma a̱ma ya̱hn ye nde na̱n che cuahtendi ye chendevah ametah. Rahndudo Dihvo vo Ndudo yahn Dendiohs, rihnevan ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ura min ne, nda̱ cun ihyan, nda ye a̱ma sa̱hn che ndi cheche se. ");
INSERT INTO cutNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ate nducote a̱ma ya̱hn ihyan chenun ye min ne, hua chi chuh ye chendevah, chenda̱ ye nduco se na̱n Dihvo vo. Tuhme nda ye sa̱hn tin vah, ne min ntihne ye a̱ma ndi ima vah cua̱hn na̱n che quenun Dihvo vo. Cuahn che ndahcondah ye a̱ma ive na̱n ima vah ne, ndedevah ye yundo na̱n che quendite combiero yahn ye, nda̱ se na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cuahn che ndihchero Dihvo vo nduhca̱ che ritahno ihyan chahn ne, ra̱hn ye ri ye sa̱hn: ―Da̱yá, a nchahcó nunde yehn. ");
INSERT INTO cutNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Min vate a̱ma o sa̱hn devano ley che dirun Moisés, ne rendedecadino se: ");
INSERT INTO cutNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Dehra cuande che tihca̱ ra̱hn sa̱hn tih?, te reducherino se Dendiohs che tihca̱ ra̱hn se. Ametah nde a̱ma ihyan iyehnse che co nchahco ye nunde, atena̱n Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ndeta̱hno checadino Dihvo vo che tihca̱ rendedecadino sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―¿Dehco che tihca̱ rendedecadino nchuhn? ");
INSERT INTO cutNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Co ra̱hco ne che tahque ndah che ca̱hmá có sa̱hn che necuan se, cota̱h se yundo yahn se, ne ca̱ca se, che co che ca̱hmá che a nchahcó nunde yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ma̱n ne, ca̱va che cadino nchuhn te, u che rinducó nducoya̱ca ihyan, va vederihquentiyon yáhn ca̱va che nchahcó nunde yahn ihyan muhn iyehnse cuh ne, condihche ne. Tuhme ra̱hn ye ri ye sa̱hn che ndi cheche me: ");
INSERT INTO cutNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Rá̱hn rí di, cuenecuen, cotah yundo yehn, ne conahn ndevaque. ");
INSERT INTO cutNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ndeta̱hno necuan se, cheta̱h se yundo yahn se, ne cona̱hn se. Chuh se menda̱hn yahn nducoya̱ca ihyan che chenun ye min, ne a̱ma rahn ino ye. Rendeva ye yavena̱n Dendiohs numacuahn vedeyeno, ne ra̱hn ye: ―Nde a̱ma yune hua ndihchero vo vederihno che tuhca̱. ");
INSERT INTO cutNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Cuahn tun Dihvo vo cua̱hn chihto vine yahn Galilea, ne a̱ma ya̱hn ihyan rahn ye rendo da̱ma ye na̱n ye. Min ricuahn Dihvo vo ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cua̱hn na̱n che chuh Dihvo vo ne, ndihchero ye Leví, da̱ya Alfeo. Va se na̱n mesa na̱n che rica se tume ca̱de iyo. Ra̱hn ye ri ye sa̱hn: ―Cuhn vo, condoque u. Ndeta̱hno necuan se, chinduco se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A̱ma yune cuahn che va Dihvo vo chete va̱co Leví ne, reh ye na̱n mesa nduco ihyan che rahn nduco ye. A̱ma ya̱hn sa̱hn nunde, chenun va̱n sa̱hn rica tume ca̱de iyo ma̱n, vate se nduco ye, te a̱ma ya̱hn ri se che chinduco se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sa̱hn devano ley che dirun Moisés ma̱n, sa̱hn fariseo ma̱n ne, ndihchero se che reh Dihvo vo, rih ye da̱ma nduco nducoya̱ca sa̱hn nunde chahn, ne ra̱hn se ri se ihyan che rahn nduco ye: ―Hua nda̱hca̱ che reh sa̱hn ricuahn yahn nchuhn, rih se da̱ma nduco sa̱hn rica tume ca̱de iyo ma̱n, sa̱hn nunde chena̱hn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cuahn che chihnevan Dihvo vo che tihca̱ ra̱hn sa̱hn chahn ne, ra̱hn ye ri ye sa̱hn: ―Ihyan che hua cah ye ne, hua rendotenan ye sa̱hn doctor. Ate ihyan che cah ye ne, rendotenan ye sa̱hn. Atihnoca̱ u, te ndá̱, conán ihyan nunde ca̱va che nto ino ye nunde yahn ye, ndiyu ca̱va ihyan che metah nunde yahn ye che ra̱hco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","A̱ma yune ne, sa̱hn fariseo ma̱n, sa̱hn che rahn nduco Jua̱n Bautista ma̱n ne, rahte se ya̱hte. Ro min ne, cuahn a̱ma o ihyan, ne ra̱hn ye ri ye Dihvo vo: ―¿Dehco che hua rahte sa̱hn che rahn nduco ne ya̱hte?, te sa̱hn fariseo ma̱n, sa̱hn che rahn nduco Jua̱n Bautista ma̱n ne, rahte se ya̱hte. ");
INSERT INTO cutNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―A devano nchuhn te ihyan che nduco ye sa̱hn rihneva̱co ne, hua rahte ye ya̱hte. Ate ndete che dena̱n nda̱ sa̱hn che ta̱n se nduco se, nda se sa̱hn ne, tuhme cuahte ye ya̱hte. Atihnoca̱ ihyan che rinduco ye u, te numanahn che nducó ihyan ne, metah deh cuande che cuahte ye ya̱hte. Ate cuahn che nda̱ sa̱hn che hua ri rendihche se u, nda se u ne, tuhme che cua̱co, cuahte ye ya̱hte. ");
INSERT INTO cutNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Ndete che nedin da̱ma nchuhn ndudo ra che ricuáhn nduco costumbre ndico yahn ne ne, anduhneca̱ ndete che neca̱hnan ne a̱ma ndi tino ra na̱n a̱ma tino ndico. Ndete che tihca̱ din ne ne, cuahn che ndeva doh tino ra me ne, nde tahque ndeh tino ndico me. ");
INSERT INTO cutNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","’Namin anduhneca̱ ndete che cuih ne vino ra chete ima ndico, te din vino me che condan ima ndico me, ne conda nde vino me ma̱n, nde ima me ma̱n. Chemin che vino ra ne, nahn che cuih ihyan chete ima ra. ");
INSERT INTO cutNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A̱ma ro che rahtetuhno ihyan ne, chuh Dihvo vo na̱n va chenda̱ta. Nducote chi cuico ihyan apóstol yahn ye ne, tico ye a̱ma o indo trico, reh ye ndute yahn. ");
INSERT INTO cutNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ndihchero a̱ma o sa̱hn fariseo che tihca̱ din ye, ne ra̱hn se ri se Dihvo vo: ―Condihche ne. ¿Deh cuande che tihca̱ redin sa̱hn che rahn se nduco ne?, te ma̱n ne, ro che rahtetuno ihyan, ne a ndihquentiyon Dendiohs che hua din vo ntiyon ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Anduhneca̱ ndete che hua rendihchenan nchuhn na̱n Ndudo yahn Dendiohs nduhca̱ che din David ro che quenan Abiatar chidocuya̱n che tahque ndina̱n. Chi cuico ye, ne ametah che cheh ye. Chemin che chenda̱ ye chete ya̱co, ne cheh ye pa̱n che va min. Namin ca̱h ye, cheh combiero yahn ye. Pa̱n chemin chan ne, a ndi vedino na̱n Dendiohs, ne a nihnde ca̱de che hua co cheh nde a̱ma ihyan, atena̱n chidocuya̱n. Ate nde nduco nduh ne, hua quendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Quendi Dihvo vo, ne ra̱hn ye nduco sa̱hn chahn: ―Chihco Dendiohs ro che cuahtetuhno ihyan ca̱va che ndah yahn ihyan, ndiyu ca̱va che ndere ndeva ye ro min. ");
INSERT INTO cutNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Cuedevano nchuhn te a u che rinducó nducoya̱ca ihyan che rihquentiyón nde nducuahn che redin ihyan ro che rahtetuhno ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ta̱ma ro che rahtetuhno ihyan ne, chenda̱ Dihvo vo chete ya̱co, ne min quenun a̱ma sa̱hn che ndi cuma ta̱h se. ");
INSERT INTO cutNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Namin min chenun a̱ma o sa̱hn fariseo, nahn ndihchero se ndete che din Dihvo vo che ndoyahn sa̱hn min ro che rahtetuhno ihyan, ca̱va che ca̱ca nunde se yahn ye che rahcota̱hn ye yahn ley che dirun Moisés. ");
INSERT INTO cutNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ra̱hn Dihvo vo ri ye sa̱hn che ndi cuma ta̱h me: ―Cuenecuen. Cuandi menda̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tuhme tumerune ye sa̱hn chahn: ―¿A nda̱hca̱ che ndah din vo ro che rahtetuhno ihyan, o din vo che hua ndah ne? ¿A conan vo ihyan, o ca̱hcoma̱n vo ihyan che coh ye ne? Ate hua nta̱quino se deh che ndahconan se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Chi ta̱n Dihvo vo, ne chaconan ye ndihchero ye sa̱hn chahn. A̱ma chi ra̱n ye yahn che cheche chedave yahn se. Tuhme ra̱hn ye ri ye sa̱hn min: ―Cuacondihque tah. Chacondihco ta̱h se, ne ndeta̱hno ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","A ura min no ndiquenda̱h sa̱hn fariseo chahn chete ya̱co me, ne ndo da̱ma se nduco sa̱hn che chinduco se Herodes, ntuhno se nduco vih ta̱ca̱ din se che ca̱hno se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Adive ne, cuahn Dihvo vo nduco ihyan apóstol yahn ye chihto vine yahn Galilea, ne a̱ma ya̱hn ihyan che vate ye esta̱do yahn Galilea cuahn ye da̱ma nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Namin ihyan che vate ye esta̱do yahn Judea ma̱n, ihyan che vate ye ya̱n Jerusalén ma̱n, ihyan che vate ye ya̱hn yahn Idumea ma̱n, ihyan che vate ye ta̱ma la̱do ico Jordán ma̱n, ihyan che vate ye nino ya̱n Tiro ma̱n, ya̱n Sidón ma̱n ne, a̱ma ya̱hn ye checadino ye yahn vederihno che redin Dihvo vo, ne rahn ye rendihchero ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nducote a̱ma chida̱ma ihyan ne, ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye che ca̱hcoya̱n ye a̱ma ba̱rco na̱n che conun ye, te a̱ma ndito ca̱hche ihyan na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A nedin Dihvo vo che ndoyahn a̱ma ya̱hn ihyan chahn, ne chemin che nducoya̱ca ihyan cah che chenun ye min ne, nde tuno regunda̱ vih ye che nahn nahn ta̱h ye ihyan ca̱va che ndoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Namin nduco ihyan che chenun vaco chihnga̱ ihyan, ne rahn nda̱ ye na̱n Dihvo vo, rendave ye ndiya̱hn, ne ra̱hn ye ri ye ihyan numa dito ye: ―Ndih che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ate Dihvo vo ne, a̱ma chihco yudo ye yahn vaco chihnga̱ chahn che hua ca̱hma duh ihyan ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chihno min ne, cocha Dihvo vo a̱ma tingüete. Min ya̱hve ye ihyan che nahn ye, ne nda̱ ihyan chahn na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Va̱n ihyan chahn tenda̱hnun ye ndichio ihyan che conduco ye ihyan ma̱n, che dechuh ye ihyan, cuahndudo ye ndudo yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Namin ca̱h ye vederihquentiyon, cuahtenan cuma ihyan chahn ca̱va che ndetenda̱h ye vaco chihnga̱ che chenun ihyan ma̱n, ca̱va che din ye che ndoyahn ihyan ca̱h ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Va̱n nducoya̱ca ihyan che tenda̱hnun ye ne, nduco a̱ma ihyan che duche ye Simón. Chaconahn Dihvo vo che duche ihyan min Pedro. ");
INSERT INTO cutNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ta̱ma ye ne, duche ye Jacobo, da̱ya Zebedeo. Ta̱ma ye ne, duche ye Jua̱n, dihno Jacobo. Ihyan che o chahn ne, chaconahn Dihvo vo che duche ye Boanerges, che nahn ca̱hma Ihyan che doh ino ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ta̱ma te o ye ne, duche ye Andrés ma̱n, Felipe ma̱n, Bartolomé ma̱n, Mateo ma̱n, Tomás ma̱n, Jacobo, che da̱ya Alfeo ma̱n, Tadeo ma̱n, ta̱ma Simón, ihyan min che chinduco ye partido yahn Cananeo ro mena̱n me ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Va̱n ihyan chahn ne, namin nduco a̱ma se che duche se Judas Iscariote. A sa̱hn min che ndihcue ndeh se Dihvo vo adive. Chihno min ne, cona̱hn Dihvo vo nduco ihyan apóstol che ndichio chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Cuahn che a nta̱ ye ne, ndaconan ndo da̱ma a̱ma ya̱hn ihyan, che nde hua rinun yahn ye che cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cuahn che checadino ihyan yahn ye che nde metah rinun yahn che cheh ye ne, cuahn ye quengua ye ihyan, te ra̱hco ye te ametah va cua̱co dave yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A̱ma o sa̱hn devano ley che dirun Moisés, che chica se ya̱n Jerusalén ne, ra̱hn se yahn Dihvo vo: ―Ihyan tih ne, quenan cuma ye vederihquentiyon yahn chundah, sa̱hn min che ndina̱n se yahn vaco chihnga̱. Chemin che ri rendetenda̱h ye vaco chihnga̱ che chenun ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tuhme ya̱hve Dihvo vo sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―A devano nchuhn che ndiyu chundah che rendetenda̱h se vaco chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","’Ihyan che vate ye rihquentiyon ye ne, ndete che cuahtecuhma ye va̱n ma̱n ye nduco vih ne, hua co quendi ye ca̱hcantiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A namin no tun ihyan che chenun ye a̱ma vah ne, ndete che cuahtecuhma ye va̱n ma̱n ye nduco vih ne, hua co quendi ye cuahtenun ye min nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A namin no tun chundah ne, ndete che cuhma se nduco vaco chihnga̱ che rihquentiyon se ne, cuihno vederihquentiyon yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Namin ca̱h Dihvo vo a̱ma ejemplo sa̱hn chahn, ra̱hn ye: ―A̱ma sa̱hn duco che conda̱ se chete va̱co ihyan che detino ye ne, atena̱n che dechiche se ihyan, tuhme co duco se yahn ye. Tihca̱ ra̱hn ye te anduhneca̱ ndete che a dechiche ye chundah, nda̱hco ndiya ye vederihquentiyon yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Quendi Dihvo vo ra̱hn ye: ―Cua̱co rá̱hn rí nchuhn te nducuahn nunde che rahtendihco ihyan, nde nducuahn che chihnga̱ ra̱hn ye ne, co nchahco Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ate ihyan che ducherino ye Vaco Ndah yahn Dendiohs ne, ametah nchahco cuahno Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tihca̱ ra̱hn Dihvo vo, te sa̱hn chahn ne, ra̱hn se te quenun vaco chihnga̱ ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Chihno min ne, nda̱ chaco Dihvo vo nduco dihno ye. Chahtendi ye cua̱hn chevah, ne dechuh ye che cah ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ihyan che vate ye chihto na̱n Dihvo vo ne, ra̱hn ye ri ye ihyan: ―Chaco ne nduco dihno ne, vatendi ye cua̱hn chevah, rinuhn ye ndih. ");
INSERT INTO cutNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co te ihyan min che chacó ma̱n, ihyan chahn che dihnó ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tuhme chaconan ye rendihchero ye ihyan che vate ye cuahn chihto na̱n ye, ne ra̱hn ye: ―Nducoya̱ca ihyan che chenun ye muhn ne, rihnó ihyan anduhneca̱ ndete che chacó ma̱n, anduhneca̱ ndete che dihnó ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","te adecoduhno ihyan che runeca̱de cochica ye nduhca̱ che nahn Chidá ne, rihnó ihyan anduhneca̱ ndete che dihnó ma̱n, anduhneca̱ ndete che cahvé ma̱n, anduhneca̱ ndete che chacó ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ta̱ma yune cuahn che ricuahn Dihvo vo chihto vine yahn Galilea ne, a̱ma ya̱hn ihyan chida̱ma ye chihto na̱n ye. Nducote a̱ma chito ihyan ne, chemin che chenda̱ Dihvo vo chete a̱ma ba̱rco che va min, cuahn ye ino cun metro cuahn chihto, ne quendi ye ricuahn ye. Nducoya̱ca ihyan che chida̱ma ye ne, vatendi ye ndiya̱hn chihto vine me, rihnevan ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Dihvo vo ne, a̱ma ndeh na̱n dehtenduh chicuahn ye ihyan chahn nduco ejemplo. Tuhca̱ ra̱hn ye ri ye ihyan chahn: ");
INSERT INTO cutNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Cuihcovan nchuhn. Cuahn a̱ma ihyan, retuhdo ye ndute nda̱ta. ");
INSERT INTO cutNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cuahn che retuhdo ye ne, chera neve ndute chihto yune, ne nda̱ ya̱hda, cheh te. ");
INSERT INTO cutNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chera te neve ndute na̱n che tah ra ya̱hn chenun va̱n tu. Chemin ne, nun quenda̱h, te hua ndeh ya̱hn chendih. ");
INSERT INTO cutNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ate cuahn che quenda̱h ya̱hn ne, yuche ya̱n, ne nducote metah cota̱h ya̱no dihyoduto ne, chihno tih. ");
INSERT INTO cutNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Te neve ndute ne, chera va̱n chano ya̱n. Chendih chano ya̱n me, ne hua chi yahn. ");
INSERT INTO cutNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ate ndute che chera na̱n ya̱hn ndah ne, a̱ma ndah chi. A̱ma o duto ne, chi ndico ndiche ndute yahn. Ta̱ma te o ne, chi ino raco yahn. Ta̱ma te o ne, chi a̱ma ciento yahn. ");
INSERT INTO cutNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Nducoya̱ca nchuhn, condedecadino ndah ne ca̱va che conahn ne ejemplo min. ");
INSERT INTO cutNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Adive cuahn che a nahn nducoya̱ca ihyan chihno cona̱hn ye ne, quenan Dihvo vo nduco nduh che ndichio ihyan apóstol yahn ye ma̱n, nduco te neve ihyan ma̱n. Chica ihyan chahn che ca̱h cuande ye ihyan yahn ejemplo min. ");
INSERT INTO cutNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ra̱hn Dihvo vo ri ye ihyan: ―Cade te Dendiohs che co devano nchuhn yahn vederihquentiyon yahn ye. Ate ihyan che hua rinduco ye u ne, ricuáhn ihyan dema̱n nduco ejemplo, ");
INSERT INTO cutNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ca̱va che ndihchero no ye, ate anduhneca̱ ndete che hua rona̱n ye ma̱n, cahnevano no ye, ate hua conahn ye ma̱n. Nduco tihca̱ ne, hua nto ino ye nunde yahn ye, ne hua nchahco Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Nducote hua chenahn nchuhn ejemplo min ne, ¿ta̱ca̱ co conahn ne ejemplo chena̱hn che va che nté? ");
INSERT INTO cutNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ihyan che retuhdo ye ndute nda̱ta me ne, nduhca̱ ihyan che rahndudo ye Ndudo yahn Dendiohs, rihnevan a̱ma ya̱hn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A̱ma o ihyan chahn ne, ndeta̱hno renda̱ chundah, ne redin se che rina̱n ye ndudo che a chihnevan ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ndute nda̱ta che chera va̱n tu me ne, nduhca̱ ndudo me che rihnevan ta̱ma te o ihyan che renevahnecun ye numacuahn vedeyeno. ");
INSERT INTO cutNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ate nduhca̱ a̱ma chenda̱ta che hua rengu, che metah cota̱h ya̱no dihyoduto ne, tihchan ihyan chahn, te hua riquendi ye. Cuahn che rechuhrihn ye, o ndere redin ihyan nduco ye ca̱va ndudo me ne, ndeta̱hno rihcoma̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A namin no tun ndute che chera va̱n chano ya̱n me ne, nduhca̱ ndudo me che rihnevan ta̱ma te o ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","A̱ma rendedecadino ihyan chahn yahn ntiyon yahn ye ro ro ma̱n, rihncheh ma̱n ye ihyan ca̱va vedecuihca che va iyehnse cuh ma̱n, nahn co yahn ye a̱ma ndeh na̱n dehtenduh che va ma̱n. Chemin che hua ri redin ndudo me che ndah nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ate ndute che chera na̱n ya̱hn ndah me ne, nduhca̱ ndudo me che rihnevan ta̱ma te o ihyan. Nduhca̱ a̱ma chenda̱ta che ri ndico ndiche ndute yahn, nduhca̱ ta̱ma che ri ino raco yahn, nduhca̱ ta̱ma che ri a̱ma ciento yahn ne, tihca̱ redin ndudo me che ndah nduco ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Namin nte Dihvo vo ta̱ma ejemplo. Ra̱hn ye ri ye ihyan: ―Nde a̱ma ihyan hua renahn ya̱hn ye candil ca̱va che tihyon ye ma̱n cajón, o ma̱n yundo. Renahn ya̱hn ye ca̱va che ca̱hco ye na̱n che co ro dave numacuahn chete vah. ");
INSERT INTO cutNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A tihnoca̱ nducuahn ndudo che chenun ndeh che la̱do yahn ihyan, te andahre hua renahn ye meniyon, ate nda̱ ro che va che conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nducoya̱ca nchuhn, condedecadino ndah ne deh conahn ejemplo cuh. ");
INSERT INTO cutNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Quendi Dihvo vo rente ye nduco ihyan chahn, ne ra̱hn ye: ―Cuihco nchuhn cuda̱do, te nahn che nduco cuda̱do cahnevan ne Ndudo yahn Dendiohs. Ihyan che cahnevan ye nduco cuda̱do ne, ndah conahn ye, nde tahque ndeh ca vededevano ca̱h Dendiohs che conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tihca̱, te ihyan che devano ye vededevano yahn Dendiohs ne, nde tahque ndeh ca ca̱h Dendiohs che codevano ye. Ate ihyan che hua devano ye ne, nde cona̱n ye dehtenduh che rihnevan ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Quendi Dihvo vo rente ye nduco ihyan chahn, ne ra̱hn ye: ―Nduhca̱ ndute nda̱ta che rino a̱ma ihyan ne, tihca̱ vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ihyan min ne, riya̱do ye vino, ne ro ne, renecuan ye. Andahre hua devano ye ta̱ca̱ va chenda̱ta yahn ye, ate chemin ne, riquenda̱h, ne rihta. ");
INSERT INTO cutNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ya̱hn me ne, redin che ri yahn. Mena̱n ne, riquenda̱h ya̱ta yahn, ne adive ne, riquenda̱h ya̱ma yahn. Tuhme ri ndute yahn. ");
INSERT INTO cutNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cuahn che a cuma ne, ndeta̱hno ca̱hca ihyan, te a nda̱ ro yahn. ");
INSERT INTO cutNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Nté ta̱ma ejemplo ca̱va che codevano nchuhn ta̱ca̱ vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nduhca̱ ndute nda̱ta che duche mosta̱za che rino ihyan ne, tihca̱ vederihquentiyon yahn Dendiohs. Chemin ne, tahque ca̱hya che co ta̱ma na̱n ndute nda̱ta che va iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ate adive che rehche ne, rihta nde tahque ri chahte che co ta̱ma na̱n chenda̱ta. A̱ma rihta nde ri redin ya̱hda ndaque te va̱n dune. ");
INSERT INTO cutNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nduco ndeh na̱n ejemplo nduhca̱ ejemplo chahn ne, ricuahn Dihvo vo Ndudo yahn Dendiohs ihyan chahn nduhneva che co conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dema̱n nduco ejemplo ricuahn ye. Ate cuahn che a dema̱n ye nduco ihyan apóstol yahn ye ne, reca̱h cuande ye ihyan chahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ro min cuahn che chi man ne, ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―Cuhn vo nduco nchuhn viche la̱do ca̱h. ");
INSERT INTO cutNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tuhme chihcoma̱n ihyan chahn nducoya̱ca ihyan che chenun ye min, ne chahtenun ye chete ba̱rco na̱n che quenun Dihvo vo, cuahn ye nduco vih. Namin cuahn ta̱ma te o ba̱rco nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ura min cana̱n a̱ma rano yuhne, ne ndedecuan nune vine me. Chenda̱ nune chete ba̱rco me, nde a rito. ");
INSERT INTO cutNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Dihvo vo ne, quenun ye cua̱hn ca̱h ba̱rco me, quiya̱do ye, queta ye a̱ma alma̱da. Ndedetuhche ihyan chahn ihyan, ne ra̱hn ye ri ye ihyan: ―Ihyan Ricuahn, ¿a hua cuande yahn ne che ndere coh vo muhn? ");
INSERT INTO cutNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tuhme necuan Dihvo vo, chihco dihn ye yuhne me, ne ra̱hn ye ri ye vine me: ―Cuihnde dihn. Ngüen. Ndeta̱hno chehuan yuhne me, ne a̱ma quendite dihn vine me. ");
INSERT INTO cutNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ra̱hn Dihvo vo ri ye ihyan chahn: ―¿Dehco che redihya nchuhn ri? ¿A hua ritahno ne? ");
INSERT INTO cutNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tuhme a̱ma rahn ino ihyan chahn, ne ra̱hn ye ri ye vih: ―¿Duhra ihyan cuh che nde yuhne, nde vine, redinahn che rihquentiyon ye? ");
INSERT INTO cutNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nda̱ Dihvo vo nduco ihyan apóstol yahn ye ta̱ma la̱do viche vine me, ya̱hn yahn ya̱n Gadara. ");
INSERT INTO cutNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cuahn che ndiquenda̱ ye chete ba̱rco me ne, nda̱ a̱ma sa̱hn che chenun vaco chihnga̱ sa̱hn, chica se na̱n ya̱yan. ");
INSERT INTO cutNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Min na̱n ya̱yan che va̱co se. Nde a̱ma ihyan hua co dechiche ye sa̱hn, nde huane nduco cadena. ");
INSERT INTO cutNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","A̱ma ndeh yune redechiche ihyan ta̱h se ma̱n, ca̱h se ma̱n, ate rihno rendeh se cadena. Nde a̱ma ihyan hua richa ye ca̱hco dihn ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nde ro nde ra̱hn rechica se va̱n chano ma̱n, na̱n ya̱yan ma̱n, rah se ma̱n, renun yah ma̱n se sa̱hn nduco tu ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ate ro min cua̱hn che nda̱ Dihvo vo ne, china̱n se ihyan, ne cuahn se rano se chehntihya se na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Numa dito se cah se: ―Jesús, Da̱ya Dendiohs che a̱ma yudo ye, ¿dehco che reca̱hdenun ne yune yáhn? Nde muhn nde na̱n Dendiohs, ca̱hmá có ndih che hua din ne che chuhríhn. ");
INSERT INTO cutNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tihca̱ ra̱hn se, te Dihvo vo ne, a chihco yudo ye vaco chihnga̱ chahn, ne ra̱hn ye: ―Vaco chihnga̱, ¡cuendiquenda̱h nchuhn! ¡Cuihcoma̱n ne sa̱hn tih! ");
INSERT INTO cutNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Tumerune ye sa̱hn: ―¿Deh doche ne? Ndahconan se yahn ye: ―Legión duché, te a̱ma ya̱hn ri nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tuhme a̱ma rica se che hua dechuh ye vaco chihnga̱ chahn a̱ma la̱do. ");
INSERT INTO cutNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Min nino va̱n chano ne, chenan a̱ma ya̱hn cuche reh te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A̱ma rica vaco chihnga̱ chahn ihyan: ―Cuedechuh ne nuhn ca̱va che conda̱ nuhn cuche sih. ");
INSERT INTO cutNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ca̱h yune Dihvo vo, ne ndiquenda̱h vaco chihnga̱ chahn sa̱hn min, ne chenda̱ cuche chahn. Tuhme nduh che o mil cuche chahn ne, cochahn te rano te, cheranun te chete vine me, ne chih nducoya̱ca te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sa̱hn che redin se cuda̱do cuche chahn ne, dihya se chi, ne chano se. Cuahn se, ngu se ndudo yahn ihyan che vate ye viya̱n ma̱n, ra̱ncho ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tuhme cuahn ihyan chahn ndihchero ye deh che chi. Cuahn che nda̱ ye na̱n Dihvo vo ne, ndihchero ye sa̱hn che chenun vaco chihnga̱ sa̱hn ro mena̱n me. Min va se, a ntonun se tino yahn se. A va cua̱co dave yahn se, ne dihya ye chi. ");
INSERT INTO cutNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tuhme ihyan che ndihchero ye deh che chi ne, neca̱h cuande ye ihyan che nda̱ chahn, deh che chi yahn sa̱hn min ma̱n, deh che chi yahn cuche chahn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tuhme cana̱n ihyan chahn rica ye Dihvo vo che nda̱ca ye ya̱n min, na̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuahn che chenda̱ Dihvo vo chete ba̱rco me che na̱hn ye ne, rica sa̱hn min ihyan che ca̱h yune ye che conduco se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ate hua ca̱h yune ye, ne ra̱hn ye ri ye sa̱hn: ―Conahn cua̱hn ndevaque na̱n che chenan ihyan yehn. Cahme co ihyan yahn vederihno chahte che din Dihve Dendiohs ndoque ma̱n, nduhca̱ che quenan va̱hino ye di ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tuhme cona̱hn se ya̱n va̱co se nino ya̱n Decápolis. A̱ma rente se yahn vederihno chahte che din Dihvo vo nduco se, ne a̱ma chahn ino nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cuahn che nta̱ Dihvo vo la̱do cuh yahn vine me ne, ndo da̱ma a̱ma ya̱hn ihyan na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ura min ne, nda̱ a̱ma sa̱hn ndina̱n yahn ya̱co che duche se Jairo. Cuahn che ndihchero se Dihvo vo ne, cuahn se chehntihya se na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Chica se favor ihyan, ne ra̱hn se: ―Ta̱hn dihn da̱yá, a̱ma tahn ndi te, adeche coh te. Cuhn vo nduco ne, nahn ta̱h ne ta̱hn ca̱va che ndoyahn te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tuhme cuahn Dihvo vo nduco se, ne a̱ma ya̱hn ihyan nduco ye ihyan, nde tuno chi chiche cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Min va̱n ihyan chahn ne, nduco a̱ma nda̱hta che cah te. Rendora te yun ro ro. A ri ndichio nduyo che quenan cah min ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A̱ma dico sa̱hn doctor ta̱hn, ate ndere rechuhrihn te, te hua ndoyahn te. Chihno toh te nducuahn yahn te che va, ate nde tahque ri dito cah yahn te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A chihnevan ta̱hn min che rente ihyan yahn vederihno che redin Dihvo vo, ne din te fuerza che nda̱ te va̱n ihyan. Chahn nda̱ te cua̱hn veda̱me Dihvo vo, ne nahn ta̱h te tino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tihca̱ din te, te ra̱hco te: “Ndete che co ca̱de nahn tá̱h a mare tino yahn ye ne, ndoyáhn.” ");
INSERT INTO cutNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ndeta̱hno chehuan cah yahn te, ne checadino te che a ndoyahn te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tuhme checadino Dihvo vo che chinahn a̱ma vederihno, ne ndaconan ye tumerune ye: ―¿Duh nahn ta̱h tino yáhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ra̱hn ihyan apóstol yahn ye ri ye ihyan: ―A rendihchero ne te a̱ma ndito ca̱hche ihyan na̱n ne. ¿Dehco che tumerune ne: “Duh nahn ta̱h tino yahn ne?” ");
INSERT INTO cutNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ate raconan muhn raconan min Dihvo vo, rendihchero ye cua̱hn chihto na̱n ye duh che nahn ta̱h tino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ta̱hn min ne, nde tuno rendoh te che va̱h te. Chahn nda̱ te, chehtihya te na̱n ye, ne neca̱h cuande te ihyan nducuahn che chahno te chi. ");
INSERT INTO cutNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ra̱hn ye ri ye ta̱hn: ―Da̱yá, nducote chitehne ne, a ndoyehn. A co nahn ndevaque ndete che nehn. Hua dehve rahque, te a ndoyehn. ");
INSERT INTO cutNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nde metah cuihno ca̱hma Dihvo vo cuahn che nda̱ a̱ma o ihyan ndeva̱co Jairo, ne ra̱hn ye ri ye sa̱hn: ―A chih ta̱hn da̱ya ne. Ametah deh cuande che denduh ne Ihyan Ricuahn ca̱va che ca̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Chihnevan Dihvo vo che ra̱hn ihyan chahn, ate hua tumaca̱h ye. Ra̱hn ye ri ye Jairo: ―Hua te co ran. Cuitehne che co conán di. ");
INSERT INTO cutNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tuhme quendi ye cuahn ye nduco Jairo, ne atena̱n Pedro ma̱n, Jacobo ma̱n, Jua̱n che dihno Jacobo ma̱n, cahnecun ye che cuahn ye nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Cuahn che nda̱ Dihvo vo va̱co Jairo ne, ndihchero ye che a̱ma ya̱hn ihyan chenun ye min, raco ye ma̱n, rah ra̱n ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tuhme chenda̱ ye chete vah, ne ra̱hn ye ri ye ihyan chahn: ―¿Dehco che a̱ma rah ra̱n nchuhn ma̱n, raco ne ma̱n?, te ta̱hn dihn tih ne, dehve ndih te, te quiya̱do te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ate chihyon nan ihyan chahn ihyan. Tuhme ndetenda̱h vah Dihvo vo nducoya̱ca ye, ne cuahn ye nduco chida ta̱hn dihn me ma̱n, chaco te ma̱n, ihyan che nduco ye ma̱n, chenda̱ ye nduco vih na̱n che quendite te. ");
INSERT INTO cutNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Cheta̱h ye ta̱h te, ne ra̱hn ye deva̱co yahn ye: ―Talita cumi ―che nahn ca̱hma: Ta̱hn dihn, cuenecuen. ");
INSERT INTO cutNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ta̱hn dihn me ne, a ri te ndichio nduyo. Ndeta̱hno necuan te, cana̱n rica te, ne a̱ma cuahn ino ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A̱ma chihco yudo Dihvo vo che hua duhva ca̱hma che ndedetuhche ye ta̱hn, ne ra̱hn ye ri ye indihte yahn te che ca̱h ye, cheh te. ");
INSERT INTO cutNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Chica Dihvo vo ya̱n Capernaum, ne cona̱hn ye ya̱n va̱co ye Nazaret nduco ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A̱ma ro che rahtetuhno ihyan ne, chenda̱ ye chete ya̱co, chicuahn ye. A̱ma ya̱hn ihyan chihnevan ye che ricuahn ye, ne a̱ma rahn ino ye. Ra̱hn ye va̱n ma̱n ye nduco vih: ");
INSERT INTO cutNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","―Ihyan tih che vicheya̱hn me. María che chaco ye. Jacobo ma̱n, José ma̱n, Judas ma̱n, Simón ma̱n, a sa̱hn chahn che dihno ye. Muhn ya̱n va̱co vo vate ta̱hn cahve ye. Nducote a rendihche ihyan Dihvo vo che min chihta ye ne, chemin che hua nevahnecun ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Numachahte va vedeyahino nduco ihyan profeta. Ate ihyan ya̱n va̱co ye ma̱n, ihyan yahn ye ma̱n ne, hua yahino ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nducote cheche chedave yahn ihyan ya̱n chahn ne, a̱ma o no vederihno din Dihvo vo ya̱n min. Nahn ta̱h ye a̱ma o ihyan cah, din ye che ndoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Rahn ino Dihvo vo yahn che hua chitahno ihyan ya̱n va̱co ye ihyan. Chihno min ne, cuahn ye nduh ya̱n nduh ya̱n che nino, quendi ye ricuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dihvo vo Jesucristo ne, cah ye nduh che ndichio apóstol chahn na̱n ye. Dechuh ye ihyan ca̱de o ca̱de o ye queri a̱ma ya̱n. Din ye che cuahtenan cuma ihyan chahn vederihquentiyon, ca̱va che cuahn che ta̱hn nun ye ihyan che chenun vaco chihnga̱ ihyan ne, ndetenda̱h ye vaco chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Chihquentiyon ye che quenda ihyan chahn inda̱hco yahn ye ma̱n, che tihyon ca̱h ye nda̱co yahn ye ma̱n, che conun ye a̱ma no cahteca ye ma̱n. Ate dehtenduh chena̱hn ne, hua co quenda ye, nde huane dino ma̱n, nde huane pa̱n ma̱n, nde huane tume ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Namin ra̱hn Dihvo vo ri ye ihyan chahn: ―Adecotino va̱co ihyan na̱n che nevahnecun ye nchuhn ne, min cuahtenan ne nde tuno ro che nda̱ca ne ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ihyan ya̱n che hua ntumanecun ye nchuhn ma̱n, che hua ca̱hcovan ye che cuahndudo ne ma̱n ne, conda̱ca ne ya̱n va̱co ye, ne conda̱hde ne ya̱ca che chenan ca̱h ne, ca̱va che tihca̱ na̱hme ne ihyan che hua nda̱hca̱ redin ye. Cua̱co rá̱hn rí nchuhn te cuahn che a nda̱ ro che techeca̱de Dendiohs nunde yahn nducoya̱ca ihyan ne, tahque chuhrihn ihyan chahn che co ihyan ya̱n Sodoma ma̱n, ihyan ya̱n Gomorra ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tuhme cuahn ihyan chahn rahndudo ye che nahn che nto ino ihyan nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Namin retenda̱h ye a̱ma ya̱hn vaco chihnga̱ che chenun ihyan, ne racota̱hme ye aceite a̱ma ya̱hn ihyan cah, redin ye che rendoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ro min ne, a̱ma rente ihyan yahn vederihno che redin Dihvo vo, ne checadino rey Herodes. Tuhme ra̱hn rey me: ―A ntuche Jua̱n Bautista va̱n tena̱hn. A ihyan min che redin ye vederihno che tihchan. ");
INSERT INTO cutNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na̱hn ihyan ne, ra̱hn ye te ihyan profeta Elías che quechica ye. Na̱hn tun ihyan ne, ra̱hn ye: ―Ihyan ca̱h ne, a̱ma ihyan profeta nduhca̱ ihyan profeta che chahte ye a ra̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ate hua chitahno Herodes che rente ihyan chahn, ne ra̱hn se: ―Ihyan ca̱h ne, Jua̱n Bautista ihyan. A ihyan ca̱h che chihquentiyón sanda̱do che chihca ya̱n se da̱ndo ye. Ma̱n ne, a ntuche ye va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tihca̱ ra̱hn rey me, te a ma̱n se chihquentiyon se sanda̱do che din se preso Jua̱n, chaconuhn se ihyan va̱coya̱hn, dechiche se ihyan nduco cadena. Tihca̱ chahno chi Jua̱n, te tihca̱ nahn Herodías, ta̱hn nda̱hta yahn Felipe, sa̱hn min che dihno rey me. Rey me ne, ndere quenan se nduco te. ");
INSERT INTO cutNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","A ra̱hn Jua̱n ri ye rey me: ―Hua nda̱hca̱ redin ne che quenan ne nduco nda̱hta yahn dihno ne. ");
INSERT INTO cutNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nducote tihca̱ ra̱hn Jua̱n ri ye rey me ne, chemin che a̱ma nahn ca̱hno Herodías ihyan. Ate hua chi chihno te ihyan ura min. ");
INSERT INTO cutNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes ne, renevahnecun se Jua̱n, te a devano se te ihyan min ne, ihyan ndah ye, ndiyu ihyan nunde ye. Chemin che hua rahnecun se che ca̱hno te ihyan. Cuahn che rihnevan rey me che rente Jua̱n ne, andahre hua ndah renahn se, ate rihnevan se numacuahn vedeyeno. ");
INSERT INTO cutNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ate nda̱ a̱ma ro che nda̱hca̱ chahno Herodías chi. Din rey me vihcoduche se, ne reca̱h se reh nducoya̱ca intiyahn yahn se ma̱n, ihyan ndina̱n yahn sanda̱do yahn se ma̱n, ihyan na̱hn che vate ye esta̱do yahn Galilea ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ura che a vate vihco ye ne, chenda̱ ta̱hn da̱ya Herodías, ndeh te, ne rey me nduco ihyan che vate ye reh ye nduco vih ne, a̱ma ca̱h yeno ihyan. Tuhme ra̱hn rey me ri se ta̱hn: ―Cuique adecodehno che nehn, ne té di. ");
INSERT INTO cutNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ca̱h se ndudo yahn se ta̱hn, ne ra̱hn se: ―Adecodehno che nehn, andahre ma̱hn va na̱n che rihquentiyón, té di. ");
INSERT INTO cutNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ndiquenda̱h te, ne cuahn te ca̱carune te chaco te, ne ra̱hn te: ―¿Deh ca̱cá? Ndahconan chaco te: ―Cuique tin Jua̱n Bautista. ");
INSERT INTO cutNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ndeta̱hno chenda̱ tun te na̱n che quenun rey me, ne ra̱hn te ri te sa̱hn: ―Ma̱n ne, náhn che te ne u meniyon tin Jua̱n Bautista chete a̱ma cuh. ");
INSERT INTO cutNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tuhme a̱ma chi ra̱n rey me. Ate nducote a ca̱h se ndudo yahn se ta̱hn na̱n nducoya̱ca ihyan che vate ye min nduco se ne, chemin che dinahn se ndudo yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A ura min no chihquentiyon se a̱ma sanda̱do che ca̱hn se ngua se tin Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chahn sanda̱do me va̱coya̱hn, chihca ya̱n se da̱ndo Jua̱n. Quenda se tin ye chete a̱ma cuh, ne ca̱h se ta̱hn. Ta̱hn min ne, quenda te ca̱h te chaco te. ");
INSERT INTO cutNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cuahn che checadino ihyan che chinduco ye Jua̱n te a chih ye ne, chahn ye chengua ye ihyan, ne chihche ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Adive ne, ndaconan ihyan apóstol chahn, ndo da̱ma ye nduco Dihvo vo, ne neca̱h cuande ye ihyan nducuahn che din ye ma̱n, nducuahn che chicuahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Cuhn vo nduco nchuhn a̱ma cua̱n na̱n che dema̱n, cuahtetuhno vo tah. Tihca̱ ra̱hn ye, te a̱ma ya̱hn ihyan, ihyan che renda̱ ye ma̱n, ihyan che rena̱hn ye ma̱n, ne nde che cheh ye hua rinun yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tuhme quenun Dihvo vo chete a̱ma ba̱rco nduco ihyan apóstol chahn, ne cuahn ye a̱ma cua̱n na̱n che metah duhva. ");
INSERT INTO cutNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ate a̱ma ya̱hn ihyan ndihchero ye che cuahn ye, ne nchana̱n ye ihyan. Tuhme chica ihyan chahn ya̱n va̱co ye, ne rica ca̱h ye, cuahn ye cua̱hn na̱n che cuahn Dihvo vo, nde tahque nun nda̱ ye min. ");
INSERT INTO cutNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuahn che ndiquenda̱h Dihvo vo chete ba̱rco me ne, a̱ma ya̱hn ihyan ndida̱ma ye. Quenan va̱hino ye ihyan chahn, te nduhca̱ itecuche che metah duh che redin cuda̱do ite ne, tihchan ye. Tuhme cana̱n Dihvo vo, chicuahn ye ihyan a̱ma ndeh na̱n dehtenduh. ");
INSERT INTO cutNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cuahn che a chi chino me ne, nda̱ ihyan apóstol chahn na̱n Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Muhn ne, ya̱hn na̱n che metah duhva, ne ma̱n ne, a chi chino. ");
INSERT INTO cutNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cuedechuh ne ihyan sih cua̱hn ya̱n che nino, ca̱va che cua ye che cheh ye, te muhn ne, metah deh che cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ra̱hn Dihvo vo ri ye ihyan: ―Nchuhn coca̱h ne, cheh ihyan sih. ―Tumerune ihyan chahn ihyan: ―Nahn o ciento tume denario che cua nuhn pa̱n, cheh ihyan sih. ¿A nahn ne che tihca̱ din nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―¿Ta̱va pa̱n va yahn nchuhn? Cuahn ne quendihchero ne. Cuahn che ndihchero ihyan chahn ne, ra̱hn ye ri ye ihyan: ―Va uhn pa̱n nduco o ya̱hca. ");
INSERT INTO cutNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dechuh Dihvo vo ihyan apóstol chahn che ca̱hma ye nduco nducoya̱ca ihyan che cuahte ye na̱n yune cue, coda̱ma ye a̱ma a̱ma cua̱n nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tihca̱ dinahn ye, ne a̱ma o cua̱n ne, chahte a̱ma ciento ye, ne ta̱ma te o cua̱n ne, chahte o raco ndiche ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tuhme cheta̱h Dihvo vo nduh che uhn pa̱n chahn nduco o ya̱hca chahn. Cha ya̱co na̱n ye na̱n ro, ne ca̱h ye nundihve cuahn Dendiohs. Tuhme ndeh ye pa̱n chahn, ne ca̱h ye ihyan apóstol, ca̱va che ca̱h ye, cheh nducoya̱ca ihyan chahn. Namin ya̱hca chahn ne, ndeh Dihvo vo, ne cheh nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Cheh ndah nducoya̱ca ihyan chahn nde na̱n che chito ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Adive ne, nedin da̱ma ihyan apóstol chahn nducuahn pa̱n che nga̱va, ne chi ndichio cuahte. Namin nedin da̱ma ye che nga̱va yahn ya̱hca chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Va̱n nducoya̱ca ihyan che cheh ye ne, nduco uhn mil ihyan cha̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ndeta̱hno dechuh Dihvo vo Jesucristo ihyan apóstol che conda̱ ye chete ba̱rco me, chuh ye ta̱ma la̱do viche ca̱h, cua̱hn na̱n ya̱n Betsaida. Tuhme ndedechuh ye nducoya̱ca ihyan chena̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cuahn che ndedechuh ye ihyan chahn ne, cuahn ye a̱ma tingüete ca̱va che cova̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cuahn che chi man me ne, a nde menda̱hn vine me cuahn ba̱rco me nduco ihyan apóstol chahn. Dihvo vo ne, a dema̱n ye quenan ye tingüete me. ");
INSERT INTO cutNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ndihchero ye che a̱ma chi cuno ihyan chahn che rica̱hca ye ba̱rco me, te cua̱n na̱n che rechi yuhne cuahn ye. Adive, ura che a nino co dave ne, cuahn Dihvo vo, rica ye na̱n vine me, nde a nahn chuhnan ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Cuahn che ndihchero ihyan chahn che rica Dihvo vo na̱n vine me ne, ra̱hco ye te co vaco chihnga̱ cochi, nde tuno cah ye che va̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nducoya̱ca ihyan chahn ne, ndihchero ye che cochi Dihvo vo na̱n nune, ate nducote hua nchana̱n ye ihyan ne, a̱ma dihya ye chi. Ndeta̱hno ra̱hn Dihvo vo ri ye ihyan chahn: ―Hua dihya nchuhn co, te a u che cochí. Hua dehve ra̱hco ne. ");
INSERT INTO cutNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tuhme chenda̱ ye chete ba̱rco me na̱n che chenun ihyan chahn. Ndeta̱hno chehuan yuhne me, ne a̱ma rahn ino ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","A̱ma rahn ino ye, te nducote cheche chedave yahn ye ne, metah cuihno conahn ye yahn vederihno che din Dihvo vo nduco pa̱n chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cuahn che a chuh Dihvo vo nduco ihyan apóstol chahn ta̱ma la̱do viche ca̱h ne, nda̱ ye ya̱hn yahn Genesaret, ne dechiche ihyan chahn ba̱rco me chihto vine me. ");
INSERT INTO cutNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cuahn che a ndiquenda̱ Dihvo vo chete ba̱rco me ne, ndeta̱hno nchana̱n ihyan ya̱n min ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tuhme cuahn ihyan chahn rano ye numachahte chihto ya̱n, ne cana̱n ye retecheca̱n ye ihyan cah yahn ye nduco yundo, regu ye ihyan cua̱hn na̱n che quenun Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Adecotino na̱n che renda̱ Dihvo vo, andahre ya̱n ca̱hya ma̱n, andahre ya̱n rahte ma̱n, andahre viya̱ta ma̱n, min racondihte ihyan chahn ihyan cah yahn ye chihto yune. Rica ihyan chahn che ca̱h yune Dihvo vo cuaconahn ta̱h ihyan cah chahn andahre chihto tino yahn ye. Nducoya̱ca ihyan cah che chaconahn ta̱h ye tino yahn ye ne, ndeta̱hno ndoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés che chica se ya̱n Jerusalén ma̱n ne, ndo da̱ma se na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","5","Sa̱hn chahn nduco nducoya̱ca ihyan nación yahn Israel chena̱hn ne, riquendi se costumbre che chihco ihyan ndico yahn se che rena̱no se ta̱h se ura che cheh se ma̱n, ura che renda̱ se che rahn se ndihve ma̱n. Ra̱hco se te nduco tihca̱ ne, redinahn se che rihquentiyon Dendiohs. Namin rena̱no se va̱so ma̱n, ja̱rro ma̱n, dehtenduh chena̱hn che retoh se ma̱n. Ndihchero se che reh ihyan apóstol, ne hua rena̱no ye ta̱h ye nduhca̱ costumbre yahn se, ne ra̱hn se ri se Dihvo vo: ―¿Dehco che hua rena̱no ihyan apóstol yahn ne ta̱h ye ura che reh ye nduhca̱ che chihco ca̱de ihyan ndico yuhn vo ne? ");
INSERT INTO cutNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―¡O na̱n o chende nchuhn! Riquenda̱h cua̱co nduhca̱ che dirun ihyan profeta Isaías yahn ne tuhca̱: Dendudo no che ra̱hn sa̱hn sih che ritahno se Dendiohs, te hua cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nde hua cochihve che rendeva se yavena̱n Dendiohs, te ricuahn se costumbre yahn ma̱n se, redin ca̱ se che vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tihca̱ redin nchuhn. Rihcoma̱n ne vederihquentiyon yahn Dendiohs, ne riquendi ne costumbre yahn ma̱n ne. Rena̱no ne ja̱rro ma̱n, va̱so ma̱n, a̱ma ndeh na̱n ca dehtenduh che tihchan redin ne. ");
INSERT INTO cutNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’¡A̱ma vivo nchuhn che ra̱hco ne! Riquendi ne costumbre yahn ma̱n ne, ne rihcoma̱n ne vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés ne, dirun ye tuhca̱: “Cuendeva yavena̱n chide ma̱n, yavena̱n cheque ma̱n.” Namin dirun ye: “Adecoduhno ihyan che ca̱hva ye yahn chida ye o ca̱hva ye yahn chaco ye ne, quenan cuma che ca̱hno ihyan ya̱n ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ate ndotenan che quendi nchuhn vederihquentiyon min ne, ricuahn ne ihyan che ca̱hma ye co ye indihte yahn ye: “Hua co conán nchuhn, te nducuahn che va yáhn ne, a ndihco mendá̱hn che co vedino na̱n Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Adecoduhno ihyan che ca̱hma ye tihca̱ ne, redin nchuhn fuerza ihyan che dinahn ye, ne hua rahnecun ne che conan ye indihte yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","¡A̱ma ndeh na̱n ca dehtenduh che tuhchan redin nchuhn! Rihcoma̱n ne vederihquentiyon yahn Dendiohs, ne riquendi ne costumbre yahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nedin da̱ma Dihvo vo ihyan, ne ra̱hn ye: ―Cuihcovan ndah nchuhn ca̱va che conahn ne che ca̱hmá nduco ne: ");
INSERT INTO cutNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nducuahn che chihnga̱ che riquenda̱h chete chedave yahn ihyan ne, a ca̱va chemin che chendihco ye nunde, ndiyu ca̱va dehtenduh che reh ye. ");
INSERT INTO cutNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Cuihcovan ndah ne ca̱va che conahn ne! ");
INSERT INTO cutNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Cuahn che chica Dihvo vo min, ndonda̱ ye vah ne, chica ihyan apóstol ihyan che ca̱h cuande ye ihyan deh conahn che nte ye me. ");
INSERT INTO cutNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ra̱hn ye ri ye ihyan chahn: ―Namin nchuhn da̱ma ri ne nduco ihyan sih, te hua renahn ne. Nducuahn che reh ihyan ne, ndiyu ca̱va chemin che chendihco ye nunde, ");
INSERT INTO cutNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","te va̱cochendereh yahn ye rahn, ndiyu chete chedave yahn ye. Tihca̱ chicuahn Dihvo vo che ndiyu ca̱va dehtenduh che reh ihyan che chendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Quendi ye, ne ra̱hn ye: ―Nducuahn che chihnga̱ che rendedecadino ihyan ma̱n, che redin ye ma̱n ne, a ca̱va chemin che chendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Chete chedave yahn ihyan riquenda̱h che chihnga̱ rendedecadino ye ma̱n, reduco ye ma̱n, rihno vih ye ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","rahtenan ye nduco ihyan che hua nihneva̱co ye nduco ye ma̱n, nahn yahn ye dehtenduh yahn ihyan ma̱n, rihncheh ye ma̱n, duhtuno ihyan ye ma̱n, ndere ihyan ye ma̱n, ve ye ma̱n, ya̱de ye ma̱n, nine ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nducuahn dehtenduh chemin chan ne, reconan chete chedave yahn ihyan, ne a ca̱va chemin che chendihco ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chica Dihvo vo min, ne cuahn ye cua̱hn ya̱hn yahn ya̱n Tiro ma̱n, Sidón ma̱n. Cuahn che nda̱ ye ne, nda̱ca ye a̱ma vah na̱n che conan ye. Hua nahn ye che cadino ihyan che min quenan ye, ate a ca̱de no che checadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Min va a̱ma ta̱hn dihn che quenun vaco chihnga̱ ta̱hn. Ndeta̱hno che checadino chaco te che nda̱ Dihvo vo ne, chahn te na̱n quenan ye, ne chehntihya te na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ta̱hn min ne, ndiyu ta̱hn nación yahn Israel, te ta̱hn ta̱ma nación. A min Sirofenicia ya̱n va̱co te. Chica te Dihvo vo che ndetenda̱h ye vaco chihnga̱ che quenun ta̱hn dihn yahn te. ");
INSERT INTO cutNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ate ra̱hn Dihvo vo ri ye ta̱hn: ―Ihyan yáhn ne, a̱ma rendotenan ye che conán ihyan. Ndete che conán di ne, anduhneca̱ ndete che cahneví pa̱n che reh checa̱hya, cá̱h, cheh ya̱hna. ");
INSERT INTO cutNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ndaconan te, ne ra̱hn te ri te ihyan: ―Dihvé, cua̱co che ra̱hn ne. Ate ya̱hna ne, rahtenun te ma̱n mesa, ne renda̱ca da̱che chende checa̱hya reh te. ");
INSERT INTO cutNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tuhme ra̱hn ye ri ye ta̱hn: ―Nda̱hca̱ ndaconen. Co nahn. Vaco chihnga̱ me ne, a ndiquenda̱h ta̱hn daye. ");
INSERT INTO cutNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cona̱hn te, ne cuahn che nta̱ te ndeva̱co te ne, nta̱ca te da̱ya te che quendite te na̱n yundo. A ntiquenda̱h vaco chihnga̱ me ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Chihno neve ro ne, nda̱ca Dihvo vo ya̱hn yahn Tiro, nchuh ye ya̱n Sidón ma̱n, te neve ya̱n ca̱hya che nino ya̱n Decápolis ma̱n, ne nta̱ ye na̱n va vine yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Min nda̱ a̱ma o ihyan, nda ye a̱ma sa̱hn che nde chato se ma̱n, nde lihme se ma̱n, ne chica ye Dihvo vo che nahn ta̱h ye sa̱hn, din ye che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Quenda Dihvo vo sa̱hn a̱ma la̱do, ne terun ye ndutita̱h ye iverevan se ma̱n, nahn ta̱h ye chihya se nduco nunedan ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chenihyon na̱n ye cua̱hn na̱n ro, ne chena̱hn ino ye che chi nda̱che ye, ne ra̱hn ye: ―¡Efata! ―che nahn ca̱hma: ¡Condah! ");
INSERT INTO cutNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ndeta̱hno chihnevan se ma̱n, ndiquenda̱h ca̱hn se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tuhme chihquentiyon Dihvo vo che hua ca̱hma ihyan chahn ta̱ca̱ chi che ndoyahn sa̱hn min. Ate cuahn che rihquentiyon ye che hua ca̱hma ihyan ne, nde tahque racotuhn ca ihyan ndudo. ");
INSERT INTO cutNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","A̱ma rahn ino nducoya̱ca ihyan, ne ra̱hn ye: ―¡A̱ma nda̱hca̱ nducuahn che redin ihyan cuh! Nde ihyan che chato ye ne, redin ye che ri rihnevan ye, ne ihyan che lihme ye ne, redin ye che ri rente ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ta̱hn min ne, a̱ma ya̱hn ihyan ndida̱ma ye na̱n Dihvo vo, ne ametah che cheh ye. Tuhme cah Dihvo vo ihyan apóstol, ne ra̱hn ye ri ye ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Renan va̱hinó ihyan sih, te a ino ro che chenan ye nducó, ne ma̱n ne, ametah che cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ndete che ndedechúh ihyan che hua cheh ye ne, condave cuno ye cua̱hn yune, te na̱hn ye ne, yahn ya̱n va̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tuhme ra̱hn ihyan chahn ri ye ihyan: ―Ate ¿deh ca̱h vo, cheh ye?, te muhn ne, metah dehva. ");
INSERT INTO cutNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Tumerune Dihvo vo ihyan chahn: ―¿Ta̱va pa̱n va yahn nchuhn ne? Ndahconan ye: ―Ndache pa̱n va yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tuhme chihquentiyon Dihvo vo che cuahte nducoya̱ca ihyan ndiya̱hn. Cheta̱h ye nduh che ndache pa̱n chahn, ne cuahn che a neca̱h ye nundihve cuahn Dendiohs ne, ndeh ye. Tuhme ca̱h ye pa̱n me ihyan apóstol chahn ca̱va che ca̱h ye, cheh nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Namin va neve ya̱hca ca̱hya, ne ndaconan ca̱h Dihvo vo nundihve cuahn Dendiohs. Tuhme dechuh ye ihyan apóstol chahn, ca̱va che ca̱h ye ya̱hca me, cheh nducoya̱ca ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Cheh nducoya̱ca ye nde na̱n che chito ihyan. Chihno min ne, nedin da̱ma ihyan apóstol chahn nducuahn che nga̱va, ne chito ndache cuahte. ");
INSERT INTO cutNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ihyan che cheh ye ne, ri tenduh cun mil ihyan. Tuhme ndedechuh Dihvo vo ihyan chahn, ");
INSERT INTO cutNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ne chenda̱ ye chete a̱ma ba̱rco nduco ihyan apóstol yahn ye, cuahn ye nduco vih cua̱hn ya̱hn yahn ya̱n Dalmanuta. ");
INSERT INTO cutNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Cuahn che nda̱ ye min ne, nda̱ neve sa̱hn fariseo, ne cana̱n rente se nduco Dihvo vo, retumarande se ihyan. Chica se che ca̱ca ye Dendiohs che conahn a̱ma vederihno, ndihchero se. ");
INSERT INTO cutNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A̱ma chena̱hn ino Dihvo vo che chi nda̱che ye ca̱va se, ne ra̱hn ye ri ye sa̱hn: ―Ihyan che vate ye ma̱n ro cuh ne, hua nda̱hca̱ che retumarande ye Dendiohs, rica ye a̱ma vederihno ndihchero ye. Cua̱co rá̱hn rí nchuhn te Dendiohs ne, hua tumaca̱h ye yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tuhme chihcoma̱n ye sa̱hn chahn, ne ndonda̱ ye chete ba̱rco me, tuche ye ta̱ma la̱do viche yahn vine me. ");
INSERT INTO cutNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ihyan apóstol ne, china̱n ye, hua quenda ye deh che cheh ye. Atena̱n a̱ma pa̱n nda ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cuihco nchuhn cuda̱do. Hua tumaca̱h ne yahn ya̱ yahn sa̱hn fariseo ma̱n, ya̱ yahn Herodes ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tuhme cana̱n rente ihyan chahn nduco vih: ―Tihca̱ ra̱hn ye, yahn che hua nda vo pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Checadino Dihvo vo che tihca̱ rente ihyan chahn. Ate nducote a ra̱hn ye yahn ndudo che ricuahn sa̱hn chahn ndiyu yahn pa̱n ne, chemin che chihya ye ihyan: ―¿Dehco che ra̱hn nchuhn yahn che hua nda ne pa̱n? ¿A hua retumacadino nchuhn? ¿Dehco che a̱ma cheche chedave yahn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿A nduhneca̱ ndete che hua ro na̱n ne? ¿A nduhneca̱ ndete che hua rihnevan ne? ¿A hua reneca̱hco ne? ");
INSERT INTO cutNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cuahn che chihcachéh uhn mil ihyan nduco uhn pa̱n ne, ¿ta̱va cuahte pa̱n che nga̱va nedin da̱ma ne ne? Ndahconan ihyan chahn, ne ra̱hn ye: ―Ndichio cuahte nedin da̱ma nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Namin no tun cuahn che chihcachéh cun mil ihyan nduco ndache pa̱n ne, ¿ta̱va cuahte pa̱n che nga̱va nedin da̱ma ne ne? Ndahconan ihyan chahn, ne ra̱hn ye: ―Ndache cuahte nedin da̱ma nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tuhme ra̱hn ye ri ye ihyan chahn: ―Me ¿ta̱ca̱ che hua renahn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ura che nda̱ Dihvo vo nduco ihyan apóstol yahn ye ya̱n Betsaida ne, nda̱ a̱ma o ihyan na̱n ye, nda ye a̱ma sa̱hn na̱n ve, ne chica ye Dihvo vo che cuaconahn ta̱h ye sa̱hn, din ye che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tuhme cheta̱h ye ta̱h sa̱hn na̱n ve me, quenda ye sa̱hn cua̱hn chihto ya̱n. Nahn ye nunedan ye ndutina̱n se, ne tumerune ye sa̱hn ndete che a ro na̱n se. ");
INSERT INTO cutNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Sa̱hn min ne, ndihchero se cua̱hn chihto na̱n se, ne ra̱hn se ri se ihyan: ―A ri ro ná̱n ihyan che vatechica ye. Ate nduhca̱ che ro ya̱hn rahte, tihca̱ ro ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nahn ta̱h ye ndutina̱n se ta̱ma yune, ne ndeta̱hno a chi ro na̱n ndah se. ");
INSERT INTO cutNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tuhme ndedechuh ye sa̱hn cua̱hn ndeva̱co se, ne ra̱hn ye ri ye sa̱hn: ―Hua conda ya̱n tih, nde hua cahme nduco nde a̱ma ihyan sih ta̱ca̱ chi che ndoyehn. ");
INSERT INTO cutNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chihno min ne, quenda Dihvo vo ihyan apóstol yahn ye, cuahn ye nduco vih na̱n ya̱n ca̱hya cua̱hn chihto ya̱n Cesarea de Filipo. Cuahn che chenun ye yune ne, tumerune ye ihyan chahn: ―¿Duh u, ra̱hn ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ndahconan ihyan chahn yahn ye: ―A̱ma o ihyan ne, ra̱hn ye te ndih ne, Jua̱n Bautista. Ta̱ma te o ye ne, ra̱hn ye te ndih ne, Elías. Ta̱ma te o ye ne, ra̱hn ye te ndih ne, a̱ma cha ihyan profeta. ");
INSERT INTO cutNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tuhme tumerune ye ihyan chahn: ―Me nchuhn, ¿deh ra̱hn ne yáhn ne? Ndahconan Pedro, ne ra̱hn ye ri ye ihyan: ―A ndih che a va ca̱de che chi ne ndedevahn ne ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ate ra̱hn Dihvo vo ri ye ihyan chahn che hua ca̱hma ye chemin nduco nde a̱ma ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tuhme ca̱h cuande Dihvo vo ihyan apóstol yahn ye, ne ra̱hn ye: ―U che rinducó nducoya̱ca ihyan ne, va che a̱ma chuhríhn. Intiyahn ma̱n, chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, co ta̱n se nducó, ne ca̱hno se u. Ate cuihno ino ro ne, va che ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nduco chemin ne, ca̱h cuande ndah Dihvo vo ihyan chahn nduhca̱ che cuahno co ye. Tuhme quenda Pedro ihyan a̱ma la̱do, ne ya̱hve ye ihyan ca̱va che hua ca̱h yune ye che tihca̱ cuahno co ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ate chaconan Dihvo vo ndihchero ye ihyan apóstol chena̱hn, ne chihya ye Pedro: ―Di ne, ¡nduhca̱ chundah, di! ¡Cuehn a̱ma la̱do! ¡Hua din vahche yáhn!, te di ne, ihyan iyehnse di, nde hua renehn che nahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ura min ne, cah Dihvo vo ihyan apóstol ma̱n, ihyan che chenun nduco ye ma̱n, ne ra̱hn ye ri ye ihyan: ―Adecoduhno ihyan che nahn conduco ye u ne, va che ca̱hcoma̱n ye vedeyeno yahn ma̱n ye. Hua co che dendudo no conduco ye u, te va che ca̱hco menda̱hn ye ihyan ca̱va che conduco ye u, andahre conahn ya̱h ye na̱n a̱ma cruz ca̱vá. ");
INSERT INTO cutNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tihca̱, te adecoduno ihyan che hua nahn ca̱hco menda̱hn ye ihyan ca̱va che conduco ye u ne, va che conda ye. Me adecoduhno ihyan che conduco ye u numacuahn chedave yahn ye ne, hua dehve din yahn andahre ca̱hno sa̱hn nunde ihyan yahn che ritahno ye u ma̱n, ndudo ndah yáhn ma̱n, te ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Andahre nedin da̱ma ihyan nducuahn vedecuihca che va iyehnse, ate ¿dehra cochihve yahn ye ndete che va che conda ye?, ");
INSERT INTO cutNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","te hua cochihve vedecuihca na̱n Dendiohs ca̱va che ndevahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tihca̱, te adecoduhno ihyan che co cuihna̱n ye ca̱va u ma̱n, ca̱va ndudo yáhn ma̱n, na̱n ihyan nunde che rahcota̱hn ye yahn Dendiohs ne, namin u che rinducó nducoya̱ca ihyan ne, co cuihná̱n ca̱va ye ro che numacuahn vederihquentiyon yahn Chidá ndá̱ nduco ángel ndah. ");
INSERT INTO cutNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Quendi Dihvo vo ra̱hn ye nduco ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te a̱ma o ihyan che chenun ye muhn nduco vo ne, vate ca ye iyehnse nda̱ ro che numacuahn vedeyudo conahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chihno a̱n ro me ne, quenda Dihvo vo Pedro ma̱n, Jacobo ma̱n, Jua̱n ma̱n, cuahn ye nduco vih a̱ma tingüete. Min ndo diya̱hn ye na̱n ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tino yahn ye ne, a̱ma ndo cua nduhca̱ ihve, nde tuno diya̱hn ro. Nde a̱ma ihyan rena̱n che vate ye muhn iyehnse cuh ne, hua co din ye che tihca̱ ndo cua. ");
INSERT INTO cutNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","A dena̱n chihnde ro Elías nduco Moisés, ne ndihchero ihyan chahn che rente ye nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Tuhme ra̱hn Pedro ri ye Dihvo vo: ―Ihyan ricuahn yáhn, a̱ma nda̱hca̱ che chenan vo muhn. Dendah nuhn ino vache vah. A̱ma na̱n che cuhnde ne, ta̱ma na̱n che cuhnde Moisés, ne ta̱ma na̱n che cuhnde Elías. ");
INSERT INTO cutNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tihca̱ ra̱hn ye, te a̱ma dihya ihyan chahn chi, nde hua renta̱quino ye deh che ca̱hma ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ura min chiya a̱ma man, quendihco na̱n che chenun ihyan chahn. Va̱n man me ne, chenun a̱ma ndudo che ra̱hn tuhca̱: ―Sa̱hnguh che Da̱yá. Yahinó sa̱hn. Che ca̱hma se ne, chemin che codinahn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","A dena̱n cuahn che ndihchero ihyan chahn ne, ametah duhva. A dema̱n Dihvo vo nti ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ura che cuenchan ihyan chahn cuete me ne, ra̱hn Dihvo vo ri ye ihyan: ―Hua ca̱hma nchuhn nduco nde a̱ma ihyan yahn vederihno che ndihchero ne nde nda̱ ro che u che rinducó nducoya̱ca ihyan ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Dinahn ihyan chahn che ra̱hn Dihvo vo, chahtenun ino ye vederihno min, ne retumerune vih ye: ―¿Dehra conahn ndudo che tihca̱ ra̱hn ye che ntuche ye va̱n tena̱hn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Numanahn che chenun yune ca ye ne, tumerune ye Dihvo vo: ―¿Deh cuande che ra̱hn sa̱hn devano ley che dirun Moisés che Elías va che chi ye mena̱n ne? ");
INSERT INTO cutNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ndahconan Dihvo vo, ne ra̱hn ye: ―Cua̱co te va che chi Elías mena̱n, ne nda̱hco ca̱de ye nducuahn. Ate, ¿a renahn ne nduhca̱ che ndirun yáhn na̱n Ndudo yahn Dendiohs?, te a ndirun te u che rinducó nducoya̱ca ihyan ne, va che chuhríhn ma̱n, va che nda̱hchenan ihyan u ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ate rá̱hn rí nchuhn te a nda̱ Elías, ne din ta̱n ihyan nduco ye nduhca̱ che a ndirun yahn ye na̱n Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cuahn che nta̱ Dihvo vo na̱n che chenun ihyan apóstol chena̱hn ne, ndihchero ye che a̱ma ndito ihyan. Sa̱hn devano ley che dirun Moisés ne, rahteruhn chende se nduco ihyan apóstol. ");
INSERT INTO cutNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ndeta̱hno che ndihchero ihyan che chenun ye min Dihvo vo ne, cuahn ino nducoya̱ca ye, ne aderano ye chahn ye neca̱h ye Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tumerune Dihvo vo ihyan apóstol chahn: ―¿Deh cuande che rahteruhn chende sa̱hn sih nduco nchuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tuhme chenda̱ menda̱hn a̱ma ihyan che quenun ye va̱n ihyan chahn, ne ra̱hn ye ri ye Dihvo vo: ―Ihyan Ricuahn yáhn, hua te u ne, ndá̱ ndevah, te ra̱hcó te muhn quenun ne. Ndá sa̱hn da̱yá che quenun a̱ma vaco chihnga̱ sa̱hn, nedin che ndi lihme se. ");
INSERT INTO cutNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Adecotino che rinuhn yahn se ne, redin vaco chihnga̱ me che rendava se. Riche yan chende se ma̱n, reh dihyon se ma̱n, ri cheche se ma̱n. U ne, chicá ihyan apóstol yahn ne che ndetenda̱h ye vaco chihnga̱ me sa̱hn, ate hua chi ndetenda̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Tuhme ra̱hn Dihvo vo: ―¡A̱ma rendedecadinó ca̱va nchuhn! ¿Dehco che hua ritahno ne? ¿Ticua̱hn ca̱hcoma̱n ne vedenine yahn ne, co ne ihyan? Cuahn ne nguan ne sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tuhme chehua ihyan chahn sa̱hn dihn me, ne cuahn che checadino vaco chihnga̱ me che a ihyan min che Dihvo vo Jesucristo ne, din che nuhn yahn sa̱hn dihn me, ne chendava se. Racondihte ya̱hn se ma̱n, riche yan chende se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tumerune Dihvo vo chida se: ―¿A ra̱hn che tihca̱ ri yahn se ne? Ndahconan chida se, ne ra̱hn ye: ―Nde ro che lihn se. ");
INSERT INTO cutNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","A̱ma ndeh yune redin vaco chihnga̱ me che renda̱hnun se va̱coya̱hn ma̱n, va̱n nune ma̱n, che nahn ca̱hno sa̱hn. Ate ndete che co ndetenda̱h ne vaco chihnga̱ me sa̱hn ne, conan va̱hino ne nuhn, cuinan ne nuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ra̱hn Dihvo vo ri ye chida sa̱hn dihn me: ―Ndete che ritehne ne, adecodehno che caque ne, conahn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ndeta̱hno ra̱hn chida sa̱hn dihn me numa dito ye: ―Ritahnó. Ate cuenan ne u ca̱va che tahque ndah cotahnó. ");
INSERT INTO cutNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ndihchero Dihvo vo che a̱ma rida̱ma ihyan, ne numacuahn vedeyudo chihquentiyon ye vaco chihnga̱ me, ne ra̱hn ye: ―Vaco chihnga̱ che redin che nde lihme nde chato sa̱hn dihn tih, rihquentiyón di che ndiquendah, ca̱hcoman sa̱hn. Ametah ndaconen conda sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tuhme cah vaco chihnga̱ me, din che a̱ma chih dihca sa̱hn dihn me, ndiquenda̱h sa̱hn. Chih ta̱hn sa̱hn dihn me, quendite dihn se, ne a̱ma ya̱hn ihyan ra̱hn ye che a chih se. ");
INSERT INTO cutNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ate cheta̱h Dihvo vo ta̱h se, ndedecuan ye sa̱hn, ne chandi se. ");
INSERT INTO cutNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chihno min ne, cona̱hn Dihvo vo, ne cuahn che a ndonda̱ ye vah ne, tumerune ihyan apóstol chahn ihyan devavih, ne ra̱hn ye: ―¿Deh cuande che hua chi ndetenda̱h nuhn vaco chihnga̱ me ne? ");
INSERT INTO cutNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Ca̱va che ndetenda̱h vo vaco chihnga̱ chemin chan ne, nahn che cova̱h vo ma̱n, cuahte vo ya̱hte ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chihno min ne, chica ihyan chahn min cuahn ye. Chuh ye esta̱do yahn Galilea, ate hua nahn Dihvo vo che cadino nde a̱ma ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","te ricuahn ye ihyan apóstol yahn ye. Ra̱hn ye ri ye ihyan chahn: ―U che rinducó nducoya̱ca ihyan ne, din se preso u, ne ca̱hno se u. Ate cuihno ino ro ne, ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hua chenahn ihyan chahn ndudo che tihca̱ ra̱hn Dihvo vo, ne va̱hino ye tumerune ye ihyan deh conahn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Cuahn che nda̱ ihyan chahn ya̱n Capernaum ne, ndonda̱ ye vah. Tuhme tumerune Dihvo vo ihyan apóstol chahn, ne ra̱hn ye: ―¿Deh che a̱ma rente nchuhn yune ura che cochi vo ne? ");
INSERT INTO cutNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ate hua ndahconan ihyan chahn yahn ye, te rente ye nduco vih cha ye che tahque cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tuhme chihnde Dihvo vo, ne cah ye nduh che ndichio ihyan chahn na̱n ye, ne ra̱hn ye: ―Adecoduhno nchuhn che nahn cona̱n ne ne, va che nda̱hco ndiya ma̱n ne nchuhn, co ne anduhneca̱ deca̱hya yahn combiero yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tuhme cah ye a̱ma lihn, chihno ye menda̱hn. Cheta̱h ye lihn me quenuhn ye, ne ra̱hn ye ri ye ihyan chahn: ");
INSERT INTO cutNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Adecoduhno ihyan che renevahnecun ye ihyan yáhn che necun ye nduhca̱ checa̱hya che tuhchan ne, a u renevahnecun ye. Me ihyan che renevahnecun ye u ne, Ihyan che dechuh ye u renevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Chihno min ne, ra̱hn Jua̱n ri ye Dihvo vo: ―Ihyan Ricuahn yáhn, ndihchero nuhn a̱ma ihyan che rentiyon ya̱n ye ndih, ne nduco tihca̱ rendetenda̱h ye vaco chihnga̱. Ate hua ca̱h yune nuhn che quendi ye, te hua nduco ye uvo. ");
INSERT INTO cutNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Hua ca̱hca ta̱n nchuhn che tihca̱ redin ye, te nde a̱ma ihyan che redin ye vederihno nduco vederihquentiyon yáhn, hua chihnga̱ ra̱hn ye yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tihca̱, te ihyan che hua ta̱n ye nduco vo ne, rinan ye uvo. ");
INSERT INTO cutNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Adecoduhno ihyan che te ye andahre a̱ma va̱so nune, cuh ne yahn che rinduco ne u ne, cua̱co rá̱hn rí nchuhn te nda̱hco menun Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Adecoduhno ihyan che tihyon yune ye a̱ma ihyan yáhn che necun ye nduhca̱ checa̱hya che tuhchan che condihco ye nunde ne, tahque nda̱hca̱ ca̱va ihyan min che dechiche ihyan a̱ma tu yudo chahte da̱ndo ye, cua̱conda̱hnun ye ihyan va̱n nuniya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Ndete che renda̱ yahn ne che cuahtendihco ne nunde, ne nduco ta̱h ne va che dinahn ne ne, tahque ndah che din ne cuande anduhneca̱ ndete che a chihca ya̱n ne ta̱h ne, te tahque nda̱hca̱ yahn ne che cuahtenan ne vahchetero andahre yuhche ta̱h ne, yudomin ca che numa ne cuahtenun ne va̱n ruchiya̱hn che riche cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Min ne, hua rintoh cuahno ya̱hn, nde hua rih nda̱h che reh te ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ndete che renda̱ yahn ne che cuahtendihco ne nunde, ne nduco ca̱h ne va che dinahn ne ne, tahque ndah che din ne cuande anduhneca̱ ndete che a chihca ya̱n ne ca̱h ne, te tahque nda̱hca̱ yahn ne che cuahtenan ne vahchetero andahre yuhche ca̱h ne, yudomin ca che numa ne cuahtenun ne va̱n ruchiya̱hn che riche cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Min ne, hua rintoh cuahno ya̱hn, nde hua rih nda̱h che reh te ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ndete che ndutina̱n ne ndi che va che cuahtendihco ne nunde ne, codin ne cuande anduhneca̱ ndete che a tico ne, te tahque nda̱hca̱ yahn ne che cuahtenan ne vahchetero andahre metah ndutina̱n ne, yudomin ca che numa ne cuahtenun ne va̱n ruchiya̱hn ");
INSERT INTO cutNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","na̱n che hua rintoh cuahno ya̱hn, nde hua rih nda̱h che reh te ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Nducoya̱ca ihyan che ritahno ye u ne, va che chuhrihn ye ca̱va che quenda̱h ndah ye, ne ndeva Dendiohs ihyan. Nducuahn vedino che reca̱h ihyan Dendiohs ne, richihve ndete che dave chedave yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ima ne ndah, ate ndete che neca̱n dine yahn ne, ametah cochihve. A namin nchuhn, te nahn che runeca̱de ne ma̱n, nahn che nda̱hca̱ cuahtenan ne nduco vih ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Chica Dihvo vo ya̱n Capernaum, ne cuahn ye cua̱hn esta̱do yahn Judea, ya̱hn viche la̱do ca̱h yahn ico Jordán, ne ndaconan ndo da̱ma a̱ma ya̱hn ihyan na̱n ye. Ricuahn ye ihyan chahn nduhca̱ che redin ye ro ro. ");
INSERT INTO cutNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A̱ma ro min ne, nda̱ a̱ma o sa̱hn fariseo, ca̱va che tumarande se Dihvo vo. Tumerune se ihyan ndete che ndihquentiyon Dendiohs che co tehche ihyan nda̱hta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ndahconan ye yahn se, ne tumerune ye sa̱hn: ―¿Deh rihquentiyon ley che dirun Moisés ne? ");
INSERT INTO cutNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ndahconan se, ne ra̱hn se ri se ihyan: ―Na̱n ley che dirun Moisés ne, ndirun che nduco che dendah ihyan a̱ma acta ne, co tehche ye nda̱hta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ra̱hn Dihvo vo ri ye sa̱hn: ―Tihca̱ dirun ye yahn che duhtuno ihyan nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ate cuahn che dendah Dendiohs iyehnse ne, dendah ye cha̱hn ma̱n, nda̱hta ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ne chihquentiyon ye che va che ca̱hcoma̱n ihyan chida ye ma̱n, chaco ye ma̱n, ca̱va che conan cuma ye nda̱hta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nduco tihca̱ ne, conan cuma vih ye anduhneca̱ ndete che a̱ma no ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Chemin che cuahn che cahneva̱co ihyan ne, anduhneca̱ ndete che din da̱ma Dendiohs ihyan, ne ndihquentiyon ye che hua tehche vih ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cuahn che a ndonda̱ Dihvo vo vah ne, tumerune ihyan apóstol deh conahn che ra̱hn ye me. ");
INSERT INTO cutNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ra̱hn ye ri ye ihyan chahn: ―Adecoduhno ihyan che tehche ye nda̱hta yahn ye, ne cahneva̱co tun ye nduco ta̱ma nda̱hta ne, din duche yahn ye che nihneva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Adecoduhno ihyan nda̱hta che tehche ye incha̱hn ye, ne cahneva̱co tun ye nduco ta̱ma cha̱hn ne, namin din duche yahn ye che nihneva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","A̱ma yune ne, nda̱ ihyan, nda ye checa̱hya yahn ye na̱n Dihvo vo ca̱va che nahn ta̱h ye, ne ca̱ca ye Dendiohs ca̱va. Ate ihyan apóstol ne, ra̱hva ye nduco ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ndihchero Dihvo vo che tihca̱ redin ihyan apóstol chahn, ne chi yudo yahn ye, ne ra̱hn ye: ―Ca̱h yune nchuhn che chi checa̱hya ná̱n. Hua ca̱hdenun ne, te atena̱n ihyan che necun ye nduhca̱ checa̱hya chuhn, co nevahnecun ye che ca̱hcantiyon Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Cua̱co rá̱hn rí nchuhn te adecoduhno ihyan che hua dinahn ye che rihquentiyon Dendiohs nduhca̱ che redinahn a̱ma lihn ne, ihyan min ne, hua co conan ye na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tuhme cheta̱h Dihvo vo checa̱hya chahn, quenuhn ye. Nahn ta̱h ye, ne chica ye Dendiohs ca̱va. ");
INSERT INTO cutNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cuahn che a quenun yune Dihvo vo cuahn ye ne, nda̱ a̱ma se rano se. Chehntihya se na̱n ye, ne tumerune se ihyan: ―Ihyan Ricuahn ndah, ¿deh va che dín ca̱va che conán vahchetero numacuahn ro ne? ");
INSERT INTO cutNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―¿Dehco che rahn che ndah u ne? Metah nde a̱ma ihyan che ndah ye. Atena̱n Dendiohs, ihyan min che ndah ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A devene vederihquentiyon yahn ye: “Hua din duche yehn che nihnevaque. Hua cahne ihyan. Hua doque. Hua cahme ndudo cuahnde. Hua cahncheh ihyan. Cuendeva yavena̱n chide ma̱n, yavena̱n cheque ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ra̱hn se ri se ihyan: ―Ihyan Ricuahn, nde ro che lihn u ne, redináhn nducuahn vederihquentiyon min. ");
INSERT INTO cutNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tuhme ndihchero Dihvo vo sa̱hn numacuahn vedeyahino, ne ra̱hn ye: ―Va ta̱ma na̱n che va che din. Cuehn condihcue nducuahn che va yehn, ne cuinen ihyan cheva̱h ca̱va che conen vahchetero numacuahn ro. Tuhme cochi condoque u, andahre nahn ya̱hn ihyan di na̱n a̱ma cruz. ");
INSERT INTO cutNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ate a̱ma chi ra̱n se che tihca̱ ra̱hn ye, yahn che a̱ma cuihca se. Tahque ndah se ne, ca se yune yahn se cona̱hn se. ");
INSERT INTO cutNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tuhme chaconan Dihvo vo ndihchero ye ihyan apóstol yahn ye, ne ra̱hn ye: ―¡A̱ma va̱hche ca̱va ihyan che nevahnecun ye vederihquentiyon yahn Dendiohs! ");
INSERT INTO cutNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Chahn ino ihyan apóstol chahn che tihca̱ ra̱hn Dihvo vo. Ate ndaconan ra̱hn tun ye: ―Da̱yá, ¡a̱ma va̱hche ca̱va ihyan che yahino ye vedecuihca ca̱va che nevahnecun ye vederihquentiyon yahn Dendiohs! ");
INSERT INTO cutNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nde hua co nevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ate nde tahque cuahn ino ihyan chahn che tihca̱ ra̱hn Dihvo vo, ne ra̱hn ye va̱n ma̱n ye nduco vih: ―Ndete che tihca̱ ne, nde a̱ma ihyan hua co ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ndihchero ye ihyan chahn, ne ra̱hn ye: ―Che la̱do yahn ihyan ne, hua co. Ate che la̱do yahn Dendiohs ne, co, te Dendiohs ne, ri redin ye nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tuhme tumerune Pedro: ―¿Ta̱ca̱ co yahn nuhn tuhme ne? Chihcoma̱n nuhn nducuahn yahn nuhn, ne chinduco nuhn ndih. ");
INSERT INTO cutNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Cua̱co rá̱hn rí nchuhn te vate ihyan che a chihcoma̱n ye dehtenduh yahn ye ca̱va u nduco ndudo ndah yahn Dendiohs. A chihcoma̱n ye va̱co ye ma̱n, dihno ye ma̱n, cahve ye ma̱n, chida ye ma̱n, chaco ye ma̱n, ihyan nda̱hta yahn ye ma̱n, da̱ya ye ma̱n, ya̱hn yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ma̱n ro cuh ne, nta̱ca ihyan chahn a̱ma ciento queri a̱ma che chihcoma̱n ye. Andahre che va̱co ye ma̱n, dihno ye ma̱n, cahve ye ma̱n, chaco ye ma̱n, da̱ya ye ma̱n, ya̱hn yahn ye ma̱n. Rechuhrihn ye, ate adive ne, conan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ate nda̱ ro che cuhnde ca̱de yahn nducoya̱ca ihyan ne, a̱ma ya̱hn ihyan che rivahn che quenda̱h ndah ye ne, hua quenda̱h ndah ye, ne ihyan che nde hua ro che quenda̱h ndah ye ne, quenda̱h ndah ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Quendi Dihvo vo cuahn ye ya̱n Jerusalén, ne nda̱hna̱n ye yahn ihyan apóstol yahn ye. Namin cuahn a̱ma ya̱hn ihyan cua̱hn veda̱me ye. Ihyan apóstol ne, a̱ma cuahn ino ye che cuahn Dihvo vo ya̱n Jerusalén na̱n che ca̱hnda yahn ye, ne ihyan chena̱hn ne, a̱ma va̱hino ye. Tuhme quenda Dihvo ihyan apóstol chahn a̱ma la̱do, ne ca̱h cuande ye ihyan nducuahn che va che cuahno co ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ra̱hn ye: ―Condihche nchuhn. Uvo ne, a chenun yuno vo cuahn vo ya̱n Jerusalén. U che rinducó nducoya̱ca ihyan ne, neca̱h sa̱hn nunde u ta̱h chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n. Sa̱hn chahn ne, ca̱hco ca̱de se che ca̱hno se u, ne nda̱co se u ta̱h sa̱hn ta̱ma nación ");
INSERT INTO cutNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","che din duche yahn se u ma̱n, ca̱hnan dan se u ma̱n, cuahn se u ma̱n, nde ca̱hno se u ma̱n. Ate cuihno ino ro ne, ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tuhme nda̱ nduh che o da̱ya Zebedeo, Jacobo nduco Jua̱n, ne ra̱hn ye ri ye Dihvo vo: ―Ihyan Ricuahn, rica nuhn a̱ma favor ndih. ");
INSERT INTO cutNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tumerune Dihvo vo: ―¿Deh nahn nchuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ndahconan ihyan chahn, ne ra̱hn ye: ―Cuahn che cuhnde ne ca̱hcantiyon ne ne, te yune ne che cuhnde a̱ma cha nuhn la̱do ta̱h cua̱co ne, ne ta̱ma cha nuhn ne, la̱do ta̱h cueh ne. ");
INSERT INTO cutNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ate ra̱hn Dihvo vo ri ye ihyan chahn: ―Nde hua devano nchuhn deh che rica ne. ¿A cocha ne chuhrihn ne nduhca̱ che va che chuhríhn ne? ¿A cocha ne che ca̱hno se nchuhn nduhca̱ che va che ca̱hno se u ne? ");
INSERT INTO cutNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ndahconan ihyan chahn, ne ra̱hn ye: ―Ta̱ca hua. Cocha nuhn. Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co te chuhrihn nchuhn nduhca̱ che chuhríhn. Namin ca̱hno se nchuhn nduhca̱ che ca̱hno se u. ");
INSERT INTO cutNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ate che cuahte ihyan la̱do ta̱h cua̱có ma̱n, la̱do ta̱h cuéh ma̱n ne, ndiyu u che ca̱hcantiyón, te Dendiohs che ca̱hcantiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Checadino ihyan apóstol chena̱hn chahn, ne chi ta̱n ye nduco Jacobo ma̱n, Jua̱n ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ate nedin da̱ma Dihvo vo nducoya̱ca ihyan chahn na̱n ye, ne ra̱hn ye ri ye ihyan: ―Nchuhn ne, a devano ne te ihyan che rihquentiyon ye nducuahn nación ne, a̱ma yudo rihquentiyon ye, ne sa̱hn che rinan se ihyan ne, rendinun rendina̱hno se ihyan yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Ate hua co tihca̱ va̱n nchuhn. Tahque ndah ne, duh ihyan che nahn cona̱n ye va̱n nchuhn ne, co ye nduhca̱ a̱ma sa̱hn deca̱hya yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tihca̱, te nde u che rinducó nducoya̱ca ihyan ne, hua ndá̱ ca̱va che dín deca̱hya yáhn ihyan. Tahque ndah ne, ca̱va che conan má̱n ihyan, nde ca̱hco mendá̱hn u, cóh, ca̱va che ndedeváhn a̱ma ya̱hn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nda̱ Dihvo vo nduco ihyan apóstol yahn ye ya̱n Jericó. Cuahn che nda̱ca ye min ne, a̱ma ya̱hn ihyan nduco ye ihyan. Chihto yune ne, va a̱ma sa̱hn na̱n ve che duche se Bartimeo, da̱ya Timeo. Min va se rica se che din ihyan vedeva̱hino nduco se. ");
INSERT INTO cutNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Cuahn che chihnevan se che a cochi nino Dihvo vo Jesucristo, ihyan min che chihta ye ya̱n Nazaret ne, cana̱n rica se favor ihyan, ne ra̱hn se numa dito se: ―Jesús, Da̱ya David, ¡cuenan va̱hino ne u! ");
INSERT INTO cutNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","A̱ma ya̱hn ihyan ra̱hn ye ri ye sa̱hn che cuhnde dihn chende se. Ate nde tahque yudo na̱n ca se ra̱hn se: ―Da̱ya David, ¡cuenan va̱hino ne u! ");
INSERT INTO cutNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Chan Dihvo vo, ne ra̱hn ye: ―Cuahn nchuhn chehua ne sa̱hn. Chahn ihyan, ne ra̱hn ye nduco se: ―Dehve raque. Cuenecuen, te rah ye di. ");
INSERT INTO cutNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tuhme chi se a̱ma la̱do tino che rendiche se, ne necuan se aderano se cuahn se na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Tumerune ye sa̱hn: ―¿Deh nehn che dín ndoque ne? Ndahconan se yahn ye: ―Ihyan Ricuahn, náhn che din ne che co ro ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tuhme ra̱hn ye ri ye sa̱hn: ―Co nahn. Nducote chitehne ne, a ndoyehn. Ndeta̱hno chi ro na̱n se, ne cuahn se nduco Dihvo vo cua̱hn na̱n che cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Cuahn che cuahn nino Dihvo vo ya̱n Jerusalén, chihto ya̱n Betfagé nduco ya̱n Betania na̱n Cuete Olivo ne, tahve ye o ihyan apóstol yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ne ra̱hn ye ri ye ihyan: ―Cuahn nchuhn ya̱n lihn ca̱h. Min na̱n che conda̱ ne ne, nta̱ca ne a̱ma burro lihn che nchiche te, che nde a̱ma ihyan ametah condudo ye ite. Cuenta̱hte ne ite, quenda ne ite muhn. ");
INSERT INTO cutNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ndete che va duh che tumerune nchuhn: “¿Dehco che tihca̱ redin nchuhn ne?”, cuendahconan ne yahn ye: “Hua te Dihve nuhn ne, nahn ye ite. Ate ndeta̱hno ndedechuh ye ite.” ");
INSERT INTO cutNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Cuahn ihyan chahn, ne nta̱ca ye burro me. Nchiche te chihto yune, nino a̱ma chendevah, ne nta̱hte ye ite. ");
INSERT INTO cutNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Min vatendi a̱ma o se, ne ra̱hn se ri se ihyan chahn: ―¿Deh din nchuhn burro tih, renta̱hte ne ite ne? ");
INSERT INTO cutNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ndahconan ye yahn se nduhca̱ che ca̱h cuande Dihvo vo ihyan, ne ca̱h yune se che cona̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Quenda ihyan chahn burro me na̱n Dihvo vo. Tihde ye tino yahn ye da̱me te, ne quendudo Dihvo vo ite. ");
INSERT INTO cutNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","A̱ma ya̱hn ihyan nta̱h ye tino yahn ye, chehnta̱ve ye yune na̱n che chuh Dihvo vo. Ihyan chena̱hn ne, chihca ye ya̱ta cue, ne chehnta̱ve ye numa yune. ");
INSERT INTO cutNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nducoya̱ca ihyan, ihyan che nda̱hna̱n ye ma̱n, ihyan che chenan ive ye ma̱n ne, a̱ma rah yeno ye, ne ra̱hn ye: ―¡Ndeva vo yavena̱n Dihvo vo Dendiohs! ¡Ndeva vo yavena̱n ihyan cuh che dechuh ye ihyan! ");
INSERT INTO cutNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡A̱ma ndah ro yuhn vo, te cochi ye quenan cuma ye vederihquentiyon yahn ihyan ndico yuhn vo David! ¡Ndeva vo yavena̱n Dendiohs che va ye vahchetero! ");
INSERT INTO cutNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cuahn che nda̱ Dihvo vo ya̱n Jerusalén ne, chenda̱ ye chete ya̱co chahte, ndihchero ye nducuahn che va min. Nducote a chi chino ne, ndaconan ye ya̱n Betania nduco nduh che ndichio ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ta̱ma ro me ura che chica Dihvo vo ya̱n Betania ne, chi cuico ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","China̱n ye a̱ma ya̱hn higo che chenan ya̱ta yahn, ne cuahn ye ndihchero ye ndete che chenan ndute yahn. Ate dema̱n ya̱ta yahn chenan. Ametah ndute yahn, te hua ro yahn. ");
INSERT INTO cutNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tuhme din dine ye ya̱hn higo me, ne ra̱hn ye: ―Ametah ndaconan co ndute yehn, cheh ihyan. Chihnevan ihyan apóstol che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nda̱ ihyan chahn ya̱n Jerusalén, ne cuahn che chenda̱ Dihvo vo chete ya̱co ne, ndetenda̱h vah ye ihyan che rendihcue ye ma̱n, ihyan che ra ye ma̱n, chenun ye chete ya̱co me. Chi muhn chi min ye mesa yahn sa̱hn che rendevahcorun se tume ma̱n, silla yahn sa̱hn che rendihcue se icui ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ne ametah ca̱h yune ye che chenda̱ nde a̱ma ihyan chete ya̱co me che nda ye dehtenduh. ");
INSERT INTO cutNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ra̱hn ye ri ye ihyan che chenun ye min: ―A ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Ya̱co yáhn ne, ca̱va che cova̱h ihyan nducuahn nación.” Ate nchuhn ne, nedin ne anduhneca̱ vah na̱n che rendo da̱ma sa̱hn duco. ");
INSERT INTO cutNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Chihnevan chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ne rinuhn ino se ta̱ca̱ din se che ca̱hno se Dihvo vo, te va̱h se ihyan ya̱n yahn che nducoya̱ca ye rihcovan ye che ricuahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cuahn che chi man me ne, nda̱ca Dihvo vo min, cona̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chi dave ta̱ma ro me, ura che a chenun yune ye ne, ndihchero ye che a nihno ntih ya̱hn higo me. ");
INSERT INTO cutNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tuhme neca̱hco Pedro, ne ra̱hn ye ri ye Dihvo vo: ―Ihyan Ricuahn, condihche ne ya̱hn higo che din dine ne me ne, a ntih. ");
INSERT INTO cutNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Nahn che cotahno nchuhn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Cua̱co rá̱hn rí nchuhn te adecoduhno ihyan che ca̱hma ye co ye ico ca̱h che ca̱hn conda̱hnun va̱n nuniya̱hn, ndete che hua o ndedecadino ye ma̱n, cotahno ye che conahn nduhca̱ che ra̱hn ye ma̱n ne, va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Chemin che rá̱hn rí nchuhn te nducuahn che ca̱ca ne ura che cova̱h ne ne, cuihco ne chedave yahn ne Dendiohs, ne dinahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Cuahn che cova̱h nchuhn, ndete che vate ihyan che nedin ta̱n ye nduco ne ne, cuenchahco ne yahn ye, ca̱va che Chida ne che va ye vahchetero ne, nchahco ye nunde yahn ne. Ate ndete che hua nchahco nchuhn yahn ihyan ne, Dendiohs hua nchahco ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Cuahn che nda̱ ihyan chahn ya̱n Jerusalén ne, cuahn Dihvo vo ya̱co. Ura che quenun ye min ne, chahn nda̱ chidocuya̱n ndina̱n ma̱n, sa̱hn intiyahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ne tumerune se ihyan: ¿Deh vederihquentiyon quenan come ne? ¿Duh chihquentiyon di che tihca̱ redin ne? ");
INSERT INTO cutNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn chahn: Namin u ne, va a̱ma na̱n che tumeruné nchuhn. Cuendahconan ne yáhn, tuhme có nchuhn deh vederihquentiyon quenan cumá che tihca̱ redín: ");
INSERT INTO cutNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿A Dendiohs dechuh ye Jua̱n che chehdenune ye ihyan, o che nahn ma̱n ye ne? Cuendahconan nchuhn yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tuhme cana̱n rente se va̱n ma̱n se nduco vih: Ndete che ca̱hmo vo che Dendiohs dechuh ye Jua̱n ne, ca̱hma se co se uvo: “¿Dehco che hua chitahno nchuhn tuhme ne?” ");
INSERT INTO cutNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ate, ¿a ca̱hmo vo che ndiyu Dendiohs dechuh ye ihyan ne? Hua chihquino se ra̱hn se tihca̱, te va̱h se ihyan ya̱n yahn che nducoya̱ca ye ritahno ye che Dendiohs dechuh ye Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Chemin che ra̱hn se ri se Dihvo vo: ―Hua devano nuhn. Tuhme ra̱hn ye ri ye sa̱hn: ―Namin u ne, hua có nchuhn deh vederihquentiyon quenan cumá che tihca̱ redín. ");
INSERT INTO cutNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Quendi Dihvo vo, ne nte ye a̱ma ejemplo, chihnevan sa̱hn chahn. Ra̱hn ye: ―A̱ma ihyan ne, chihche ye dihyo uva na̱n ya̱hn yahn ye, ne dendah ye chan yahn ma̱n, dendah ye a̱ma tanque na̱n che cuhno ye nune yahn uva me ma̱n, chahto ye a̱ma chete ya̱co ca̱va che din ye cuda̱do chenda̱ta me ma̱n. ’Nda̱co ye ntiyon me ta̱h a̱ma o sa̱hn che din se ntiyon nduco ca̱va che necahn ma̱hn se nduco ye. Tuhme chica ye min, cuahn yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Cuahn che a rine ndute me ne, dechuh ye a̱ma sa̱hn deca̱hya yahn ye ca̱va che ca̱ca se sa̱hn chahn ma̱hn va che va che co yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ate cheta̱h sa̱hn chahn sa̱hn, chahn se sa̱hn, ne ndedechuh se sa̱hn diya ta̱h se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Dechuh ye ta̱ma se, ate chihya sa̱hn chahn sa̱hn, ca̱h se tu sa̱hn, nuhn yah se tin se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Dechuh ye ta̱ma se, ne chihno sa̱hn chahn sa̱hn. Adive ne, ya̱hn se dechuh ye. A̱ma o se ne, chahn sa̱hn chahn sa̱hn, ne ta̱ma te o se ne, chihno sa̱hn chahn sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Chihno min ne, ametah duhva che dechuh ye, atena̱n a̱ma sa̱hn da̱ya ye che a̱ma yahino ye sa̱hn. Dechuh ye sa̱hn, ra̱hco ye che nevahnecun sa̱hn chahn sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ate cuahn che nda̱ se min ne, ra̱hn sa̱hn chahn va̱n ma̱n se nduco vih: “Sa̱hn tih che nuhnde ta̱h se ntiyon cuh. Ca̱hno vo sa̱hn, ne co yuhn vo.” ");
INSERT INTO cutNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tuhme cheta̱h sa̱hn chahn sa̱hn, chihno se sa̱hn, ne chaconda̱h se sa̱hn cua̱hn chihto me. ");
INSERT INTO cutNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tuhme ra̱hn Dihvo vo ri ye sa̱hn ndina̱n chahn: ―A devano nchuhn te ihyan che dihve ntiyon me ne, hua nchahco ye yahn sa̱hn chahn. Nda̱ ye ne, decuihno ye sa̱hn, ne ca̱h ye ya̱hn me ta̱ma te o se, din se ntiyon nduco. ");
INSERT INTO cutNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Quendi Dihvo vo, ne ra̱hn ye ri ye sa̱hn chahn: ―A ndero ndi che hua renahn nchuhn Ndudo yahn Dendiohs che ndirun tuhca̱: Tu che chaconda̱h sa̱hn vicherahto ne, chemin che nde tahque chichihve. ");
INSERT INTO cutNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dihvo vo Dendiohs chihquentiyon ye chemin, ne a̱ma nda̱hca̱ che tihca̱ din ye. ");
INSERT INTO cutNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Chenahn sa̱hn chahn che a yahn se che nte Dihvo vo ejemplo me, ne nahn din se preso ihyan. Ate hua chihquino se, te va̱h se ihyan ya̱n. Tahque ndah chihcoma̱n se ihyan, cona̱hn se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Adive dechuh chidocuya̱n ndina̱n chahn a̱ma o sa̱hn fariseo nduco a̱ma o sa̱hn partido yahn Herodes ca̱va che tumarande se Dihvo vo, ne ca̱ca nunde se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nda̱ sa̱hn chahn na̱n ye, ne ra̱hn se ri se ihyan: ―Ihyan Ricuahn, devano nuhn che ndih ne, cua̱co ra̱hn ne, te da̱ma no rendihche ne nducoya̱ca ihyan ma̱n, numa cua̱co ricuahn ne vederihquentiyon yahn Dendiohs ma̱n. Ca̱hma ne co ne nuhn: ¿A rihquentiyon Dendiohs che nedihvo vo tume ca̱de iyo yahn César, o hua ne? ");
INSERT INTO cutNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Devano Dihvo vo te o na̱n o chende sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―¿Dehco che retumarande nchuhn u ne? Te ne a̱ma tume, ndihcheró. ");
INSERT INTO cutNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ca̱h se a̱ma tume, ndihchero ye. Tuhme tumerune ye sa̱hn: ―¿Duh ihyan yavena̱n ye che quenan na̱n tume cuh ma̱n, duh ihyan che quenan che duche ye ma̱n ne? Ndahconan se, ne ra̱hn se ri se ihyan. ―Yahn César. ");
INSERT INTO cutNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Cha che rihquentiyon César ne, codinahn nchuhn. Cha che rihquentiyon Dendiohs ne, namin codinahn ne. A̱ma cuahn ino sa̱hn chahn yahn ndudo che tihca̱ ndahconan ye. ");
INSERT INTO cutNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sa̱hn saduceo ne, hua ritahno se che va che ntuche tena̱hn. A̱ma yune ne, nda̱ a̱ma o se na̱n Dihvo vo, ne ra̱hn se ri se ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Ihyan Ricuahn, na̱n ley che dirun Moisés ne, rihquentiyon te ndete che coh incha̱hn a̱ma nda̱hta che hua vate da̱ya se ne, va che cahneva̱co dihno se nduco te ca̱va che nda̱ca da̱ya se nduco te, ne nduco tihca̱ hua cuihno nda̱ta yahn dihno se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","A̱ma yune ne, chahte ndache se che dihno se vih. Sa̱hn che mena̱n ne, chihneva̱co se nduco a̱ma ta̱hn. Ate chih se, ne hua chihco se nde a̱ma da̱ya se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Chihneva̱co ta̱ma dihno se nduco te, ne cuahn che chih se ne, namin hua chihco se nde a̱ma da̱ya se. Atihnoca̱ chahno chi ta̱ma se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nduh che ndache sa̱hn chahn chihneva̱co se nduco te, ate chih nducoya̱ca se. Nde a̱ma se hua chihco se da̱ya se. Na̱n che chihnonan yahn ne, namin chih ta̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nda̱ ro che ntuche tena̱hn ne, nducote nduh che ndache sa̱hn chahn chihneva̱co se nduco te ne, ¿cha se che incha̱hn te ne? ");
INSERT INTO cutNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Nchuhn ne, nde hua devano ne Ndudo yahn Dendiohs ma̱n, vederihquentiyon yahn ye ma̱n, ne chemin che hua cua̱co che ricuahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cuedevano ne te cuahn che ntuche tena̱hn ne, metah cahneva̱co ye, nde metah decahneva̱co ye ihyan yahn ye, te co ye nduhca̱ ángel che vate ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Me yahn che va che ntuche tena̱hn ne, anduhneca̱ ndete che metah ndihchenan nchuhn che dirun Moisés yahn ro min cuahn che quenun Dendiohs chihto ya̱hn lihn che riche, ne ra̱hn ye ri ye ihyan: “U che Dendiohs yahn Abraham ma̱n, Isaac ma̱n, Jacob ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dendiohs ne, Dendiohs yahn nducoya̱ca ihyan, ihyan che vate ye iyehnse ma̱n, ihyan che a nda̱ca ye muhn ma̱n. Hua cua̱co che a̱ma yune rihnonan yahn ihyan cuahn che rih ye nduhca̱ che ra̱hco nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nduco a̱ma sa̱hn devano ley che dirun Moisés quenun se min rihnevan se, ne tumacadino se che nda̱hca̱ ndahconan Dihvo vo yahn sa̱hn chahn. Chahn nda̱ se na̱n ye, ne tumerune se ihyan: ―¿Cha vederihqueniyon yahn Dendiohs che tahque mena̱n vihca ne? ");
INSERT INTO cutNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ndahconan ye yahn se, ne ra̱hn ye: ―Vederihquentiyon yahn Dendiohs che tahque mena̱n vihca ne, tuhca̱: “Nchuhn ihyan nación yahn Israel, cuihnevan ne. Va a̱ma no Dendiohs, ihyan min che Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Codin yahino nchuhn ihyan numacuahn chedave yahn ne ma̱n, numa ino ne ma̱n, numacuahn vederendedecadino yahn ne ma̱n, numacuahn fuerza yahn ne ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Va ta̱ma vederihquentiyon yahn ye che a nahn da̱ma: “Codin yahino nchuhn nducoya̱ca ihyan nduhca̱ che yahino ma̱n ne nchuhn.” A vederihquentiyon che tuhchan che tahque mena̱n vihca va̱n nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tuhme ra̱hn sa̱hn min ri se Dihvo vo: ―Ihyan Ricuahn, a̱ma nda̱hca̱ ra̱hn ne. Cua̱co ra̱hn ne te va a̱ma no Dendiohs. Ametah ta̱ma ye nduhca̱ ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Me che numacuahn chedave yuhn vo ma̱n, numacuahn vederendedecadino yuhn vo ma̱n, numacuahn fuerza yuhn vo ma̱n, din yahino vo Dendiohs ma̱n, din yahino vo nducoya̱ca ihyan nduhca̱ che yahino ma̱n vo uvo ma̱n ne, tahque rigonun chihve che co nducuahn vedino che reca̱h vo ma̱n, che rihquiya̱hn vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Checadino Dihvo vo che numacuahn vededevano ndahconan sa̱hn min, ne ra̱hn ye ri ye sa̱hn: ―Ametah yahn renda che ca̱hcantiyon Dendiohs di. Nduco ndudo che ndahconan Dihvo vo ne, nde a̱ma ihyan ametah chihquino ye tumerune ca ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ura che ricuahn Dihvo vo chete ya̱co ne, ra̱hn ye: ―Ihyan che a va ca̱de che dechuh Dendiohs ihyan, ndedevahn ye ihyan iyehnse ne, ¿dehco che ra̱hn sa̱hn devano ley che dirun Moisés te da̱ya David ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Din Vaco Dendiohs che dirun ma̱n David tuhca̱: Ra̱hn Dihvé Dendiohs ri ye Dihvé: “Cuihnde muhn la̱do ta̱h cua̱có numanahn che nda̱hco ndiyá ihyan che hua ri rendihche ye di, nevahnecun ye di.” ");
INSERT INTO cutNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ihyan che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse ne, nducote dirun ma̱n David che Dihve ye ihyan ne, ¿ta̱ca̱ che da̱ya ye ihyan tuhme ne? A̱ma ya̱hn ihyan chenun ye min, ne a̱ma yeno ye rihnevan ye che ricuahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Quendi Dihvo vo ricuahn ye, ne ra̱hn ye nduco ihyan: ―Cuihco nchuhn cuda̱do, ne hua da̱ma co ne nduco sa̱hn devano ley che dirun Moisés, sa̱hn chahn che vatechica se chenun se cahteca chahno se. A̱ma renan ino se che nevahnecun ihyan sa̱hn, neca̱h ye Dendiohs sa̱hn cua̱hn ndihve. ");
INSERT INTO cutNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chete ya̱co ne, renan ino se cuahte se na̱n che rahte ihyan ndina̱n. Na̱n vihco ne, renan ino se cuahte se na̱n che tahque ndeva ihyan yavena̱n se. ");
INSERT INTO cutNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rehnevi se dehtenduh yahn nda̱hta va̱h, ne ca̱va che hua cuhnde ro vede idihya yahn se ne, a̱ma ra̱hn reva̱h se, redin ca̱ se che ndah ihyan se. Sa̱hn chahn ne, tahque chahte castigo din Dendiohs sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","A̱ma yune ne, va Dihvo vo chete ya̱co, nino na̱n va yave yahn tume vedino, ne ndihchero ye che renda̱ ihyan, rih ye tume chete. A̱ma ya̱hn ihyan cuihca ne, a̱ma ndeh tume rih ye chete. ");
INSERT INTO cutNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ura min nda̱ a̱ma nda̱hta va̱h, ne chih ye o tume ca̱hya che a̱ma doh chihve. ");
INSERT INTO cutNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tuhme cah Dihvo vo ihyan apóstol yahn ye, ne ra̱hn ye ri ye ihyan: ―Cua̱co rá̱hn rí nchuhn te nda̱hta va̱h ca̱h ne, tahque rigonun chihve vedino yahn ye na̱n Dendiohs che co vedino yahn ihyan chena̱hn sih. ");
INSERT INTO cutNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nducoya̱ca ihyan sih ne, chih ye che nga̱va yahn ye. Ate nda̱hta ca̱h ne, va̱n vedecheva̱h yahn ye ne, chih ye nducuahn che va yahn ye. Nde che va che toh ye ne, chih ye. ");
INSERT INTO cutNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuahn che ndiquenda̱h Dihvo vo chete ya̱co chahte me ne, ra̱hn a̱ma cha ihyan apóstol ri ye ihyan: ―Ihyan Ricuahn, condihche ne tah. ¡A̱ma nda̱hca̱ ya̱co ma̱n, tu che ndahto ma̱n! ");
INSERT INTO cutNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―¿A rahn ine che a̱ma nda̱hca̱ ya̱co? Rá̱hn rí di te va che ndora, nde o tu che ndahto vih ne, hua cota̱ve. ");
INSERT INTO cutNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tah cuahn adive ne, cuahn ihyan chahn Cuete Olivo na̱n che rendihche cua̱co ya̱co chahte me. Numanahn che va Dihvo vo ne, chahn nda̱ Pedro ma̱n, Jacobo ma̱n, Jua̱n ma̱n, Andrés ma̱n, ne tumerune ye ihyan: ");
INSERT INTO cutNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―¿Ticua̱hn conahn che ra̱hn ne ri ne nuhn yahn ya̱co me ne? ¿Deh va che co ro cuahn che a cochi nino che conahn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ndahconan Dihvo vo, ne ra̱hn ye: ―Cuihco nchuhn cuda̱do che hua cahncheh nde a̱ma ihyan nchuhn, ");
INSERT INTO cutNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","te nda̱ a̱ma ya̱hn se, cahncheh se ihyan, din ca̱ se che a vederihquentiyon yáhn chenan cuma se. Ca̱hma queri a̱ma se te a sa̱hn chahn che a va ca̱de che dechuh Dendiohs, ndedevahn se ihyan iyehnse, ne a̱ma ya̱hn ihyan cahncheh se. ");
INSERT INTO cutNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Cuahn che cahnevan nchuhn che rente ihyan che cuana̱n ca̱nda ma̱n, che a va ca̱nda ma̱n ne, hua dihya ne co, te a tihca̱ va che co. Ate che nto iyehnse ne, condah ca. ");
INSERT INTO cutNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ihyan a̱ma nación ne, cuahtecuhma ye nduco ihyan ta̱ma nación ma̱n, a muhn a min necuan ca̱nda ma̱n, nuhn ya̱hn ca̱hnguh cua̱hnga̱h ma̱n, cuhnde cuico ma̱n. Ate vedeyah chemin chan ne, cade cuana̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Cuihco nchuhn cuda̱do, te neca̱h ihyan nchuhn ta̱h intiyahn, cuih nunde ye yahn ne ma̱n, cuahn ye nchuhn chete ya̱co ma̱n. Va che quenda ihyan nchuhn na̱n gobernador ma̱n, rey ma̱n, yahn che rahndudo ne ndudo yáhn. Min va che ca̱hma ne nduhca̱ che ritahno ne u. ");
INSERT INTO cutNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ate numanahn che ametah nto iyehnse ne, va che conan cuahndudo ihyan ndudo ndah yahn Dendiohs numachahte iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Me cuahn che neca̱h ihyan nchuhn ta̱h intiyahn, cuih nunde ye yahn ne ne, hua ndedecadino ne ta̱ca̱ ca̱hma ne, te a Vaco Dendiohs te ndudo che ca̱hma ne. Ndiyu va̱n vededevano yahn ma̱n ne quenda̱h che ca̱hma ne. ");
INSERT INTO cutNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nda̱ ro min ne, a̱ma din ta̱n ihyan nduco vih. Na̱hn ye ne, ca̱ca ye che ca̱hno se dihno ye, na̱hn ye ne, ca̱ca ye che ca̱hno se da̱ya ye, na̱hn ye ne, ca̱ca ye che ca̱hno se indihte yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nducoya̱ca ihyan ndihche ta̱n ye nchuhn yahn che ritahno ne u, ate ndete che cocha ne nducuahn vedeyah chemin chan ne, ndevahn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Dirun ihyan profeta Daniel yahn a̱ma na̱n che a̱ma chihnga̱ ma̱n, che redetohnan ma̱n. Cuahn che ndihchero nchuhn che a nti na̱n che hua redin yahn che cuandi ne, tahque ndah che cuano ihyan che vate ye esta̱do yahn Judea, cuahtenun ndeh ye va̱n icoya̱hn. (Nda̱hca̱ che conahn tin ihyan cuahn che ndihchenan ye na̱n Ndudo yahn Dendiohs na̱n che ra̱hn yahn chemin). ");
INSERT INTO cutNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ro min ne, ihyan che vate ye tin vah yuto ne, ndeta̱hno nchan ye ca̱no ye. Hua redin yahn che condah ca ye chete vah, cota̱h ye dehtenduh yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Me ihyan che chenun ye viya̱ta ne, a min no ca̱ca ye, te hua conun yahn ye che na̱hn ye viya̱n, quengua ye tino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Cheva̱h ihyan nda̱hta che chenun da̱ya ye nda̱ ro min ma̱n, ihyan nda̱hta che reta̱ve ye ma̱n! ");
INSERT INTO cutNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nahn che cova̱h nchuhn, ca̱ca ne Dendiohs ca̱va che conan ye nchuhn, ne hua ro iche va che ca̱no ne, ");
INSERT INTO cutNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","te ro min ne, a̱ma yah cuahno ihyan che hua nahno ye nde ro che dendah Dendiohs iyehnse nde meniyon. ");
INSERT INTO cutNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ndete che cuahnecun Dendiohs che ra̱hn cuhnde vedeyah min ne, nde a̱ma ihyan hua ndevahn ye. Ate ca̱va che hua chuhnan chuhrihn ihyan che tenda̱hnun ye ne, a chihco ca̱de ye che hua ra̱hn cuhnde vedeyah min. ");
INSERT INTO cutNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Nda̱ ro min ne, ndete che ca̱hma ihyan co ye nchuhn: “Condihchero ne. Muhn quenun ihyan min che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse”, o ca̱hma ye: “Condihchero ne. Min quenan ye” ne, hua cotahno ne. ");
INSERT INTO cutNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Va che nda̱ ihyan che ndere ca̱hma ye che a ihyan chahn che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse. Namin va che nda̱ ihyan che din ca̱ ye che cuahndudo ye Ndudo yahn Dendiohs. Din ihyan chahn vederihno ca̱va che cahncheh ye, ndete che co ne, nde ihyan che a tenda̱hnun Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Cuihco nchuhn cuda̱do. A riya̱hvé nchuhn numanahn che metah conahn ca̱va che cuahteya̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Cuahn che cuihno vedeyah chemin chan ne, co man iyehnse. Cuihno dave yahn ya̱hn ma̱n, iyo ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","cora iyon ma̱n, nuhn nducuahn che a nihnde ca̱de na̱n ro ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tuhme ndihchero nducoya̱ca ihyan che u che rinducó nducoya̱ca ihyan ne, ndá̱ va̱n man numacuahn vederihquentiyon chahte yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dechúh ángel yáhn numachahte iyehnse, nedin da̱ma ye nducoya̱ca ihyan che a tenda̱hnún. ");
INSERT INTO cutNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Cua cuande nchuhn nduhca̱ che rineve ya̱hn higo. Cuahn che reneca̱hno ya̱n, rendo tu ya̱ta yahn ne, a devano ne te a cuana̱n ro ihno. ");
INSERT INTO cutNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Atihnoca̱ cuahn che ndihchero nchuhn che a conahn nducuahn dehtenduh che a rá̱hn rí nchuhn, te nduco chemin codevano ne te a dena̱n ndá̱. ");
INSERT INTO cutNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Cua̱co rá̱hn rí nchuhn te nde metah conan coh ihyan che vate ye ma̱n ro cuh ne, a conahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na̱n ro ma̱n, iyehnse ma̱n ne, va che cuihno. Ate ndudo yáhn ne, hua chuh ya, te va che conahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ate hua duh devano deh ro ma̱n, deh ura ma̱n, che conahn. Nde ángel che vate ye vahchetero hua devano ye. Nde u che Da̱ya Dendiohs ne, hua devanó. Atená̱n Dendiohs Chida che devano ye. ");
INSERT INTO cutNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Cuahteya̱n nchuhn ma̱n, cova̱h ne ma̱n, te hua devano ne ticua̱hn conahn. ");
INSERT INTO cutNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","U che rinducó nducoya̱ca ihyan ne, nduhca̱ a̱ma ihyan che quenda̱h ye cuahn ye na̱n yahn. Ihyan min ne, chihco ye ntiyon che din queri a̱ma mozo yahn ye ma̱n, chihquentiyon ye sa̱hn che redin cuda̱do chendevah che cuhndeya̱n se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Cuahteya̱n nchuhn, te nduhca̱ che hua devano sa̱hn chahn deh ura ndaconan dihve se ne, namin hua devano nchuhn deh ura ndaconan chí. ¿A ndá̱ ura che cuehche ya̱hn ne? ¿A ndá̱ na̱n ma̱hn ya̱n ne? ¿A ndá̱ ura che co dave ne? Hua devano ne. ");
INSERT INTO cutNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chemin che nahn che cuahteya̱n ne, ne a decodehno ura che ndaconán ne, nta̱cá nchuhn che vateya̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Che rá̱hn rí nchuhn ne, namin rá̱hn ca̱va ihyan chena̱hn: ¡Cuahteya̱n nducoya̱ca ne! ");
INSERT INTO cutNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","O ro ca renda che nda̱ ro yudo, vihco cuahn che reh ihyan nación yahn Israel pa̱n che hua nduco ya̱ yahn ne, chidocuya̱n ndina̱n nduco sa̱hn devano ley che dirun Moisés ne, rentuhno se deh vederihncheh din se ca̱va che co din se preso Dihvo vo, ne ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Rente ca̱de se va̱n ma̱n se nduco vih: ―Hua ca̱hno vo sa̱hn mena̱hn vihco, te a̱ma nto da̱ma ihyan, ne necuan ye numacuahn vedeta̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Cuahn che quenan Dihvo vo ya̱n Betania, va̱co Simón, sa̱hn min che chi se cah che recha̱ yute ro mena̱n me, ura che va ye reh ye na̱n mesa ne, nda̱ a̱ma ihyan nda̱hta, nda ye a̱ma fra̱sco che ndindah nduco a̱ma na̱n tu che duche alabastro. Chenun chete fra̱sco me a̱ma na̱n che dema̱n nuneda̱n che duche nardo, a̱ma yahn chihve. Cun ye chende fra̱sco me, ne chacota̱hme ye nuneda̱n me tin Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Va̱n ihyan che chenun min ne, nduco a̱ma o se che hua chahtenan ino se che tihca̱ din ihyan nda̱hta me, ne ra̱hn nun se na̱n ye va̱n ma̱n se nduco vih: ―¿Dehco che ndere redetoh ta̱hn tihn nuneda̱n tih? ");
INSERT INTO cutNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tahque ndah ndete che ndihcue te, cua te nchuh ca ino ciento tume denario, ne conan te ihyan cheva̱h. Nde chihya se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tuhme ra̱hn Dihvo vo ri ye sa̱hn chahn: ―¿Dehco che ri ta̱n nchuhn nduco ihyan nda̱hta tih? Nda̱hca̱ che tihca̱ din ye ca̱vá. ");
INSERT INTO cutNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ihyan cheva̱h ne, cuahn da̱ma chenun ye va̱n nchuhn, ne adehno ro che nahn ne ne, co conan ne ihyan. Ate u ne, hua conán va̱n nchuhn numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ihyan nda̱hta tih ne, din ye nducuahn che tuno ta̱h ye, te chacota̱hme ye u, ne nduco tihca̱ chihcoya̱n ye u ca̱va che co cuhche ihyan u. ");
INSERT INTO cutNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Cua̱co rá̱hn rí nchuhn te numachahte iyehnse che cuahndudo ihyan ndudo ndah yahn Dendiohs ne, ntihyon ya̱n ye nduhca̱ che din ihyan nda̱hta tih nducó. ");
INSERT INTO cutNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, a̱ma cha sa̱hn che nduco se chi cuande se va̱n ihyan apóstol che ndichio chahn ne, chahn se nte ca̱de se nduco chidocuya̱n ndina̱n chahn ca̱va che neca̱h se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","A̱ma chi yeno chidocuya̱n chahn che tihca̱ ra̱hn se, ne ca̱h se ndudo yahn se che ca̱h se tume sa̱hn. Tuhme nuhn ino se ta̱ca̱ din se che neca̱h se ihyan ta̱h sa̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ro che cana̱n vihco che reh ihyan nación yahn Israel pa̱n che hua nduco ya̱ yahn ma̱n, rihno ye itecuche ca̱hya, ri te vedino yahn ro yudo ma̱n ne, tumerune ihyan apóstol Dihvo vo: ―¿Ti nahn ne che ca̱hn nuhn ca̱hcoya̱n nuhn che cheh ne che cuande yahn ro yudo ne? ");
INSERT INTO cutNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tuhme tahve Dihvo vo o ihyan chahn, ne ra̱hn ye ri ye ihyan: ―Cuahn nchuhn viya̱n, ne min nta̱ca ne a̱ma sa̱hn che nda se a̱ma cuhtenune. Cuiquendi ne sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nda̱ ne vah che ndonda̱ se ne, ca̱hma ne co ne ihyan che va̱co min: “Nahn cadino Ihyan Ricuahn ti va cua̱rto na̱n che cheh vino ye nduco ihyan apóstol yahn ye che cuande yahn ro yudo.” ");
INSERT INTO cutNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tuhme na̱hma ye nchuhn a̱ma cua̱rto chahte che va nde ya̱co na̱n che a vateya̱n dehtenduh. Min chihcoya̱n nchuhn che chuh vino vo. ");
INSERT INTO cutNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Cuahn ihyan che o chahn viya̱n me, ne nta̱ca ye vah me nduhca̱ che ra̱hn Dihvo vo. Min chihcoya̱n ye che cheh vino ye nduco vih che cuande yahn ro yudo. ");
INSERT INTO cutNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cuahn che chi man me ne, nda̱ Dihvo vo nduco nduh che ndichio ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Cuahn che a vate ye reh ye nduco vih na̱n mesa ne, ra̱hn Dihvo vo ri ye ihyan: ―Cua̱co rá̱hn rí nchuhn te a̱ma cha ne che reh ne da̱ma nducó ne, ndihcue ndeh ne u. ");
INSERT INTO cutNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tuhme chi ra̱n ihyan chahn, ne ca a̱ma ca a̱ma ye ra̱hn ye ri ye Dihvo vo: ―Ate co ndiyu u che tihca̱ dín. ");
INSERT INTO cutNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ndahconan Dihvo vo, ne ra̱hn ye. ―A̱ma cha nchuhn che da̱ma reh ne nducó chete cuh cuh che tihca̱ din ne. ");
INSERT INTO cutNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Cua̱co te u che rinducó nducoya̱ca ihyan ne, va che conahn nducó nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs. Ate ¡cheva̱h sa̱hn che ndihcue ndeh se u! Tahque ndah ndete che hua chihndeya̱n se. ");
INSERT INTO cutNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Numanahn che reh vino ihyan chahn ne, cheta̱h Dihvo vo pa̱n, ne neca̱h ye nundihve cuahn Dendiohs. Tuhme ndeh ye, ca̱h ye, cheh ihyan chahn, ne ra̱hn ye ri ye ihyan: ―Cocheh nchuhn pa̱n cuh. Chu ne, yute yáhn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Namin cheta̱h ye a̱ma va̱so vino, ne cuahn che a neca̱h tun ye nundihve cuahn Dendiohs ne, ca̱h ye, chih nducoya̱ca ihyan chahn, ");
INSERT INTO cutNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ne ra̱hn ye ri ye ihyan: ―Chu ne, yun yáhn. Chu che dito yahn ndudo ra che nda̱hco ca̱de Dendiohs. Ma̱n ne, va che cora ca̱va a̱ma ya̱hn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Cua̱co rá̱hn rí nchuhn te ametah ndaconan cúh nune yahn uva nde nda̱ ro che nuhnde ca̱de nducuahn quenuma ra, ne quenún na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chihno che chita ihyan chahn himno ne, cuahn ye cua̱hn Cuete Olivo. ");
INSERT INTO cutNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tuhme ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―Ma̱n vino cuh ne, ca̱hcoma̱n nducoya̱ca nchuhn u nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Cuahnecun Dendiohs che ca̱hno se ihyan che redin cuda̱do itecuche, ne cuihno cotuhn te.” ");
INSERT INTO cutNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ate cuahn che ntuché va̱n tena̱hn ne, cá̱hn esta̱do yahn Galilea tahque mena̱n ca che co nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Tuhme ra̱hn Pedro ri ye Dihvo vo: ―Andahre che ca̱hcoma̱n nducoya̱ca ihyan sih ndih ne, ate u ne, hua ca̱hcomá̱n ndih. ");
INSERT INTO cutNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ra̱hn Dihvo vo ri ye ihyan: ―Cua̱co rá̱hn rí di te ma̱n ya̱n cuh ne, numanahn che metah cuah o co tuh ne, a ino yune cahme che hua rendihche u. ");
INSERT INTO cutNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ate tahque yudo na̱n Pedro ra̱hn ye: ―Andahre va che cóh da̱ma nduco ne, ate hua ca̱hcomá̱n ndih. Atihnoca̱ ra̱hn ihyan apóstol chena̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nda̱ ihyan chahn a̱ma cua̱n na̱n che duche Getsemaní, ne ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―Cuahte nchuhn muhn numanahn che cá̱hn cová̱h. ");
INSERT INTO cutNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tuhme quenda ye Pedro ma̱n, Jacobo ma̱n, Jua̱n ma̱n, cuahn ye nduco vih. Ura min cana̱n a̱ma chi nda̱che ye, ne a̱ma chuhrihn ye che rendedecadino ye. ");
INSERT INTO cutNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ra̱hn ye ri ye ihyan chahn: ―Adeche cóh che a̱ma nda̱che rí. Cuahtenan rino nchuhn muhn, cuahtenduche ne. ");
INSERT INTO cutNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tuhme cuahn Dihvo vo tahque ca̱na na̱n min, chendih ye ndiya̱hn, ne chica ye Dendiohs che ndete che cuahnecun ye ne, hua chuhrihn ye nduhca̱ che a va ca̱de. ");
INSERT INTO cutNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ra̱hn ye: ―Chida má̱n, ndih ne, ri redin ne nducuahn che nahn ne. Cuahnecun ne che hua chuhríhn nduhca̱ che a va ca̱de. Chemin che ricá ndih, ate hua co nduhca̱ che náhn, co nduhca̱ che nahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tuhme ndaconan ye na̱n che chenun ihyan apóstol chahn. Nta̱ca ye ihyan che vateya̱do ye, ne ra̱hn ye ri ye Pedro: ―Simón, ¿a nde a̱ma ura hua chi quendoche? ");
INSERT INTO cutNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cuahtenduche nchuhn ma̱n, cova̱h ne ma̱n, ca̱va che hua dinahn ne che tumarande chundah nchuhn. Ndiyu che rahcota̱hn ne yáhn, ate anduhneca̱ ndete che ndi i ne. ");
INSERT INTO cutNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ndaconan cuahn tun ye, ne a chemin no chica ye Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cuahn che ndaconan ye ne, a namin no vateya̱do ihyan chahn, anduhneca̱ ndete che nda vih ndutina̱n ye che nahn cuahteya̱do ye, ne hua devano ye deh che ndahconan ye. ");
INSERT INTO cutNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cuahn che nta̱ Dihvo vo na̱n che chi ino yune ne, ra̱hn ye ri ye ihyan chahn: ―A chahteya̱do nchuhn. A tuno ura che neca̱h se u che rinducó nducoya̱ca ihyan ta̱h sa̱hn nunde. ");
INSERT INTO cutNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","A cochi sa̱hn che ndihcue ndeh se u. Cuenecuan nchuhn, quendi yuno vo sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nde metah cuihno ca̱hma Dihvo vo cuahn che nda̱ Judas, a̱ma cha sa̱hn che chi cuande se va̱n ihyan apóstol che ndichio chahn. Nduco se a̱ma ya̱hn sa̱hn che nda espa̱da ma̱n, sa̱hn che nda ya̱hn ma̱n, sa̱hn chahn che dechuh chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, sa̱hn min che ndihcue ndeh se Dihvo vo ne, a nte ca̱de se nduco sa̱hn chahn tuhca̱: ―A ihyan che tená̱n ihyan ne, a ihyan min codin nchuhn preso ihyan. Cuihco ne cuda̱do che hua ca̱no ye. ");
INSERT INTO cutNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ndeta̱hn nda̱ se ne, ra̱hn se ri se Dihvo vo: ―¡Ihyan Ricuahn! ¡Ihyan Ricuahn! Tuhme tena̱n se ihyan, ");
INSERT INTO cutNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ne din sa̱hn chahn preso ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","A̱ma cha ihyan apóstol chahn ne, ndetenda̱h ye espa̱da yahn ye, ne chahn ye a̱ma sa̱hn deca̱hya yahn chidocuya̱n che tahque ndina̱n, chaconda̱h ye revan se. ");
INSERT INTO cutNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Nchuhn ne, cochi ne nda ne espa̱da ma̱n, nda ne ya̱hn ma̱n, din ne preso u nduhca̱ sa̱hn duco. ");
INSERT INTO cutNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A va̱n nchuhn quenún ro ro, ricuáhn chete ya̱co, ne hua din ne preso u. Ate ma̱n ne, nda̱ ne, te a tihca̱ va che conahn nducó nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ura min chihcoma̱n ihyan apóstol chahn Dihvo vo, ne chihno chano ye. ");
INSERT INTO cutNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cuahn a̱ma sa̱hn yuno cua̱hn na̱n che cuahn Dihvo vo, ndacotuma se a̱ma tino chahte. Cheta̱h sa̱hn chahn sa̱hn, ");
INSERT INTO cutNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ate ndairun se tino me, ne deva̱ne se chano se. ");
INSERT INTO cutNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Quenda sa̱hn chahn Dihvo vo na̱n chidocuya̱n che tahque ndina̱n, ne min ndo da̱ma nducoya̱ca chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Cuahn Pedro diyahn diyahn cua̱hn na̱n che quenda sa̱hn chahn Dihvo vo nde nda̱ ye chevah va̱co chidocuya̱n che tahque ndina̱n me. Min quenun ye va̱n sa̱hn nda̱hco chahn, reca̱h ihno ye ihyan chihto va̱coya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Chidocuya̱n ndina̱n chahn nduco sa̱hn intiyahn chahn ne, renuhn ino se deh nunde cacueh da̱me se Dihvo vo, ca̱va che co ca̱hno se ihyan, ate hua nda̱ca se nde a̱ma. ");
INSERT INTO cutNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A̱ma ya̱hn se ndere rih nunde se yahn Dihvo vo, ate hua chi da̱ma ndudo yahn se nduco vih, te hua cua̱co che ra̱hn nde a̱ma se. ");
INSERT INTO cutNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Necuan a̱ma o se, ne ndere chih nunde se yahn Dihvo vo, ne ra̱hn se tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Nuhn chihnevan nuhn che ra̱hn sa̱hn tih: “U ndahterá ya̱co cuh che ndahto ihyan, ne chete che ino ro ne, na̱hnó ta̱ma che hua nduhca̱ ya̱co che rahto ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ate nde nduco nduh ne, hua chida̱ma ndudo yahn se nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tuhme necuan chidocuya̱n che tahque ndina̱n me, ne ra̱hn ye ri ye Dihvo vo: ―¿Dehco che hua rendahconen yahn sa̱hn sih che a̱ma rica nunde se yehn? ");
INSERT INTO cutNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ate nde a̱ma hua ra̱hn Dihvo vo. Tuhme tumerune chidocuya̱n che tahque ndina̱n me: ―¿A di che Da̱ya Dendiohs, ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse ne? ");
INSERT INTO cutNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ndahconan Dihvo vo, ne ra̱hn ye: ―A u chemin. Cuedevano ne te u che rinducó nducoya̱ca ihyan ne, ndihchero ne u che vá la̱do ta̱h cua̱co Dendiohs, ihyan min che a̱ma yudo vederihquentiyon yahn ye. Namin ndihchero ne u che ndá̱ va̱n man. ");
INSERT INTO cutNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tuhme chidocuya̱n che tahque ndina̱n me ne, ndeh ye tino yahn ye, ne ra̱hn ye: ―¿Dehca din vo testigo ne? ");
INSERT INTO cutNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","A ma̱n nchuhn chihnevan ne ndudo che ra̱hn se, ducherino se Dendiohs. Nchuhn ca̱hma ne che co. Ra̱hn nducoya̱ca sa̱hn chahn te redin yahn che ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tuhme a̱ma o se ne, ca̱hnan dan se Dihvo vo. Dechiche se na̱n ye, chahn se ihyan, ne ra̱hn se ri se ihyan: ―Cahme co nuhn duh chahn di. Namin sa̱hn policía ne, chahn se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Numanahn min ne, quenun ca Pedro chevah me. Ura min nda̱ a̱ma ta̱hn deca̱hya yahn chidocuya̱n che tahque ndina̱n me, ");
INSERT INTO cutNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ne ndihchero te Pedro che reca̱h ihno ye ihyan chihto va̱coya̱hn. Chahn nino te ndihchero ndah te ihyan, ne ra̱hn te ri te ihyan: ―Namin di ne, chindoque Jesús yahn ya̱n Nazaret. ");
INSERT INTO cutNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ate ra̱hn Pedro ri ye ta̱hn: ―Nde hua rendihché duh ihyan che rahn yahn ye. Tuhme cuahn ye cua̱n chendevah, ne ura min cah menahn tuh. ");
INSERT INTO cutNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ndihchero ta̱hn min ihyan ta̱ma yune, ne ra̱hn te ri te sa̱hn che chenun se min: ―Sa̱hnguh ne, namin chinduco se sa̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ate ra̱hn Pedro ta̱ma yune te hua cua̱co. Tah cuahn adive me ne, ra̱hn sa̱hn che chenun se min ri se ihyan: ―Cua̱co che chindoque sa̱hn sih, te nde na̱n ndudo yehn ro yehn che sa̱hn Galilea di. ");
INSERT INTO cutNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tuhme ra̱hva Pedro, ne ra̱hn ye ri ye sa̱hn chahn: ―Nde muhn nde na̱n Dendiohs, rá̱hn rí nchuhn te hua rendihche duh ihyan che ra̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ura min cah o co tuh, ne neca̱hco Pedro che ra̱hn Dihvo vo ri ye ihyan tuhca̱: “Ura che ametah cuah o co tuh ne, cahmé ino yune te hua rendihche u.” Ndedecadino ye yahn chemin, ne chaco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cuahn che a chi dave ne, ndo da̱ma chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ne dechiche se Dihvo vo, quenda se ihyan, neca̱h se ihyan ta̱h Pila̱to. ");
INSERT INTO cutNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pila̱to ne, tumerune se Dihvo vo: ―¿A di che rey yahn ihyan nación yahn Israel ne? Ndahconan ye yahn se: ―U, nduhca̱ che rahn. ");
INSERT INTO cutNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Chidocuya̱n ndina̱n chahn ne, a̱ma rih nunde se yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ndaconan tumerune Pila̱to ihyan, ne ra̱hn se: ―¿Dehco che hua ndahconen yahn sa̱hn sih?, te a̱ma rih nunde se yehn. ");
INSERT INTO cutNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ate nde a̱ma ndudo hua ndahconan Dihvo vo yahn se, ne a̱ma rahn ino se. ");
INSERT INTO cutNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Va a̱ma costumbre che nduyo nduyo che renda̱ ro yudo ne, renta̱hte Pila̱to a̱ma preso, adecoduhno che nahn ihyan ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Min va̱coya̱hn ne, chenun sa̱hn preso che chi se contra yahn gobierno, chahtecuhn se nduco ye, chihno se ihyan yahn ye. Va̱n sa̱hn chahn ne, nduco a̱ma se che duche se Barrabás. ");
INSERT INTO cutNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ro min nda̱ a̱ma ya̱hn ihyan na̱n Pila̱to, ne chica ye che nta̱hte se a̱ma preso nduhca̱ che redin se nduyo nduyo. ");
INSERT INTO cutNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Tumerune Pila̱to yahn ihyan chahn: ―¿A nahn nchuhn che nta̱hte rey yahn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tihca̱ ra̱hn se, te a checadino se te che ri ve chidocuya̱n ndina̱n chahn yahn Dihvo vo, ne chemin che neca̱h se ihyan ta̱h se. ");
INSERT INTO cutNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ate chidocuya̱n ndina̱n chahn ne, chinun se ihyan ya̱n che tahque nda̱hca̱ che ca̱ca ye che nta̱hte Pila̱to Barrabás. ");
INSERT INTO cutNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tuhme tumerune tun Pila̱to ihyan chahn: ―¿Me deh nahn nchuhn che dín nduco sa̱hnguh che ra̱hn ne che rey yahn ne? ");
INSERT INTO cutNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ndahconan ihyan chahn, ne ra̱hn ye numacuahn vedeta̱n: ―¡Conahn ya̱h ne sa̱hn! ");
INSERT INTO cutNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tumerune tun Pila̱to ihyan chahn: ―¿Dehco? ¿Deh nunde quendihco se? Ate ndaconan cah ihyan chahn: ―¡Conahn ya̱h ne sa̱hn! ");
INSERT INTO cutNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nducote nahn Pila̱to che co yeno ihyan chahn ne, nta̱hte se Barrabás. Tuhme chahn se Dihvo vo, ne neca̱h se ihyan ta̱h sanda̱do ca̱va che nahn ya̱h se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Quenda sanda̱do chahn Dihvo vo chevah yahn pala̱cio me, ne nedin da̱ma se nducoya̱ca combiero yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Chaconuhn se a̱ma tino mora̱do ihyan, ne dendah se a̱ma corona ya̱n, tihyon se tin ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chihno min ne, redin ca̱ se che renevahnecun se ihyan, ne rah se: ―¡Ndeva nuhn yavena̱n rey yahn ihyan nación ya̱hn Israel! ");
INSERT INTO cutNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chahn se tin ye nduco a̱ma nducodi, ne ca̱hnan dan se ihyan. Chehntihya se na̱n ye, redin ca̱ se che rendeva se yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chihno che din duche yahn se ihyan ne, chehnevi se tino mora̱do me, ne ntihyon se tino yahn ma̱n ye ihyan. Tuhme quenda se ihyan na̱n che nahn ya̱h se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ura min ne, chuh Simón, a̱ma ihyan ya̱n Cirene, nahn ye viya̱ta. Ihyan min che chida Alejandro ma̱n, Rufo ma̱n. Din sanda̱do chahn fuerza ihyan, ne quenda ye cruz na̱n che nahn ya̱h se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Quenda sanda̱do chahn Dihvo vo a̱ma cua̱n na̱n che duche Gólgota, che nahn ca̱hma Cuete Ine Tin Tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Min ca̱h se vino che ndihcheta̱hn nduco a̱ma na̱n ico che duche mirra, cuh Dihvo vo. Ate hua chih ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Cuahn che a chihno nahn ya̱h sanda̱do chahn ihyan ne, din se sortear tino yahn ye cha sa̱hn quenda̱h yahn se che co yahn se. ");
INSERT INTO cutNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na̱n raco nun vatiya̱n nahn ya̱hn se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Nunde yahn ye che ndirun, chaconahn se na̱n cruz ne, ra̱hn tuhca̱: “Ihyan cuh che Rey yahn ihyan nación yahn Israel.” ");
INSERT INTO cutNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Namin nahn ya̱h se o sa̱hn duco, a̱ma se la̱do ta̱h cua̱co ye, ne ta̱ma se la̱do ta̱h cueh ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nduco tihca̱ chinahn nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Din cuande se ihyan va̱n sa̱hn nunde.” ");
INSERT INTO cutNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ihyan che rechuh ye min ne, ra̱hva ye yahn Dihvo vo, rahco tin ye, ne ra̱hn ye: ―Di che rahn che ndahtere ya̱co, ne chete che ino ro nahne, ");
INSERT INTO cutNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡cuendedevahn man di, cuenchehn na̱n cruz tih! ");
INSERT INTO cutNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Namin chidocuya̱n ndina̱n chahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, din duche yahn se ihyan, ne ra̱hn se va̱n ma̱n se nduco vih: ―Ndedevahn se ta̱ma ca ihyan, ate ma̱n se ne, hua ri rendedevahn se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ndete che cua̱co che sa̱hn tih ihyan min che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse ma̱n, rey yahn ihyan nación yahn Israel ma̱n ne, nda̱hca̱ che nchahn se na̱n cruz, ndihchero vo, ca̱va che cotahno vo. Nde sa̱hn che chenan ya̱h se da̱ma nduco ye ne, ra̱hva se nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Cuahn che a chi inguiya̱hn ne, chi man iyehnse, chengu nde na̱n rahco ino. ");
INSERT INTO cutNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ura min cah Dihvo vo numa dito ye: ―Eloi, Eloi, ¿lama sabactani? ―che nahn ca̱hma: Dendiohs yáhn, Dendiohs yáhn, ¿dehco che chihcoma̱n ne u? ");
INSERT INTO cutNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chihnevan a̱ma o sa̱hn che chenun min, ne ra̱hn se: ―Cuihnevan nchuhn. Rah se ihyan profeta Elías. ");
INSERT INTO cutNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tuhme aderano a̱ma se, deca̱hnda se a̱ma esponja nduco vinagre. Chacotah se esponja me tin a̱ma nduco, nahn se chende ye ca̱va che tihve ye, ne ra̱hn se: ―Cuahtenan rino vo, ne ndihchero vo ndete che chi Elías ndedevah ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ate a̱ma dito cah Dihvo vo, ne chih ye. ");
INSERT INTO cutNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ura min nde tino chahte che quendihco chete ya̱co, chica nde ya̱co, chiya nde ndiya̱hn, ne ndo o ndi. ");
INSERT INTO cutNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Sa̱hn capitá̱n che nti se chihto na̱n Dihvo vo ne, chihnevan se che cah ye ma̱n, ndihchero se nduhca̱ che chih ye ma̱n, ne ra̱hn se: ―Cua̱co niyon te ihyan cuh che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Min vatendi a̱ma o ihyan nda̱hta a̱ma la̱do, rendihchero ye. A̱ma ye ne, duche María yahn ya̱n Magdala. Ta̱ma ye ne, duche María che chaco José, ihyan min che mena̱n ye yahn dihno ye Jacobo. Ta̱ma ye ne, duche Salomé. ");
INSERT INTO cutNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ihyan nda̱hta chahn ne, chinduco ye Dihvo vo, chinan ye ihyan cuahn che quechica ye esta̱do yahn Galilea. Namin ya̱hn ca ihyan nda̱hta che nda̱ ye nduco Dihvo vo ya̱n Jerusalén chenun ye min. ");
INSERT INTO cutNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","José yahn ya̱n Arimatea ne, a̱ma ihyan ndina̱n yahn nación yahn Israel. Ihyan min ne, quenan ino ye che a nun ca̱hcantiyon Dendiohs. Nducote a ro min che víspera yahn ro che rahtetuhno ihyan ne, din nun ino ye chahn ye na̱n Pila̱to, ne chica ye sa̱hn che cuahnecun se che cuhche ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pila̱to ne, a̱ma cuahn ino se che ra̱hn ihyan min che a chih Dihvo vo. Tuhme cah se capitá̱n me, ne tumerune se sa̱hn ndete che cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ra̱hn capitá̱n me ri se sa̱hn te cua̱co, ne cahnecun se che ca̱hn ye, cuhche ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tuhme chahn José, ca ye a̱ma tino cua, quenda ye. Ndedevah ye Dihvo vo, chahcotuma ye tino me ihyan, chacondihte ye ihyan chete a̱ma ya̱yan che ndindah na̱n ya̱va, ne neca̱hde ye chende ya̱yan me nduco a̱ma tu chahno. ");
INSERT INTO cutNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María yahn ya̱n Magdala ma̱n, María che chaco José ma̱n ne, chahn ye ndihchero ye na̱n che quenun Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Cuahn che a chuh ro che rahtetuhno ihyan ne, María yahn ya̱n Magdala ma̱n, Salomé ma̱n, María che chaco Jacobo ma̱n ne, ca ye nuneda̱n ca̱va che ca̱hn ye na̱n ya̱yan, cuacota̱hme ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ro min ne, ro che ndeva ndate. Ura che a quenda̱h ya̱hn ne, nda̱ ye na̱n ya̱yan me, ");
INSERT INTO cutNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ne ra̱hn ye va̱n ma̱n ye nduco vih: ―¿Ta̱ca̱ che metah duh che cahnevi tu che ntude nduco chende ya̱yan me? ");
INSERT INTO cutNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ate cuahn che ndihchero ye ne, a ndavi tu ndico me che ntude nduco chende ya̱yan me. ");
INSERT INTO cutNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chenda̱ ihyan chahn chete ya̱yan me, ne ndihchero ye a̱ma ángel che va ye la̱do ta̱h cua̱co, ndacotuma ye a̱ma tino cua chahte, ne dihya ihyan chahn chi. ");
INSERT INTO cutNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tuhme ra̱hn ángel me ri ye ihyan: ―Hua dihya nchuhn co. Nchuhn ne, rinuhn ne Jesús yahn ya̱n Nazaret, ihyan min che quenan ya̱h ye. Ate ametah ye muhn. A ntuche ye. Condihche ne ta̱n na̱n che chacondihte ye ihyan; ametah ye. ");
INSERT INTO cutNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cuahn nchuhn ngo ne Pedro ma̱n, ihyan apóstol chena̱hn ma̱n, te ca̱hn Dihvo vo esta̱do yahn Galilea tahque mena̱n che co nchuhn. Min ndihchero ne ihyan nduhca̱ che a ra̱hn ye ri ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nda̱ca ihyan nda̱hta chahn na̱n ya̱yan me, cona̱hn ye rano ye, nde tuno rendoh ye che dihya ye chi, ate hua ra̱hn ye nduco nde a̱ma ihyan che chahno chi ye, te va̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cuahn che a ntuche Dihvo vo vatiya̱n ro che ndeva ndate ne, chihnde ro ye mena̱n vihca na̱n María yahn ya̱n Magdala, ihyan min che chenun ndache vaco chihnga̱ ihyan ro mena̱n me, ndetenda̱h Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chahn ihyan min chengo ye ihyan apóstol. Ihyan chahn ne, ra̱n ye ma̱n, raco ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ate hua chitahno ye che ra̱hn ihyan nda̱hta me che ntuche Dihvo vo ma̱n, che ndihchero ye ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chihno min ne, chihnde ro Dihvo vo na̱n o ihyan che chinduco ye ihyan ura che chenun yune ye cona̱hn ye. Ate a nta̱corun Dihvo vo, ametah nduhca̱ ye ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tuhme chahn ihyan chahn chengo ye ihyan chena̱hn che chinduco ye Dihvo vo. Ate a namin no tun, te hua chitahno ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Adive ne, chihnde ro Dihvo vo na̱n ihyan apóstol che ndichia̱ma chahn ura che vate ye reh ye na̱n mesa. Chihya ye ihyan chahn yahn che hua chitahno ye che ra̱hn ihyan che a ndihchero ye ihyan che a ntuche ye. ");
INSERT INTO cutNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Namin ra̱hn Dihvo vo ri ye ihyan: ―Cuahn nchuhn numachahte iyehnse, cuahndudo ne ndudo ndah yahn Dendiohs, cahnevan nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ihyan che cotahno ye ma̱n, cuedenune ye ma̱n ne, ndevahn ye. Ate ihyan che hua cotahno ye ne, conda ye. ");
INSERT INTO cutNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ihyan che ritahno ye ne, din ye vederihno. Numacuahn vederihquentiyon yáhn ndetenda̱h ye vaco chihnga̱ ma̱n, ca̱hma ye ta̱ma te o na̱n deva̱co ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","nahn ta̱h ye ihyan cah, ne din ye che ndoyahn ye ma̱n. Namin ndete che dena̱n cota̱h ye a̱ma cu ta̱n, o cuh ye veneno ne, hua dehva co yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Chihno nte Dihvo vo nduco ihyan chahn ne, din Dendiohs che cona̱hn ye vahchetero, chihnde ye la̱do ta̱h cua̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Me ihyan apóstol ne, chahtechica ye numachahte, cahndudo ye ndudo ndah yahn Dendiohs. Rinan Dihvo vo ihyan, ne redin ye che renahn nducoya̱ca ihyan che cua̱co ndudo che rahndudo ihyan chahn yahn vederihno che redin ye. Tihca̱ chi.");
INSERT INTO cutNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","A̱ma ya̱hn ihyan, dirun ye rine quenan yahn dehtenduh che chi va̱n uvo, ");
INSERT INTO cutNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","nduhca̱ che a rente ihyan che, nde ro che cana̱n, ndihchero ma̱n ye ma̱n, cahndudo ye Ndudo yahn Dendiohs ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ndih Teófilo che yahinó ndih, namin ra̱hcó che nda̱hca̱ che tihca̱ dín. Chemin che ndeh nduyo nedin da̱má nduco cuda̱do, ndudo yahn queri a̱ma che chi. Ma̱n ne, a dirún yahn ne nducuahn chemin, ");
INSERT INTO cutNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ca̱va che codevano ndah ne te cua̱co ndudo che chicuahn ihyan ndih. ");
INSERT INTO cutNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cuahn che quenan Herodes rey yahn Judea ne, chihnde a̱ma chidocuya̱n che duche ye Zacarías, nda̱ta yahn Abías. Ihyan nda̱hta yahn ye ne, duche ye Elisabet, nda̱ta yahn Aarón. ");
INSERT INTO cutNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nduh che o ye ne, ndah ihyan ye, ne redinahn ye nducuahn che rihquentiyon Dihvo vo Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ate metah da̱ya ye, te Elisabet ne, hua renda̱ca da̱ya ye. Ava̱ne ne, nduh che o ye ne, a ndico ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","A̱ma yune ne, quenda̱h yahn chidocuya̱n che combiero yahn Zacarías che cova̱h ye na̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chidocuya̱n chahn ne, ro ro redin ye sortear deh ntiyon din queri a̱ma ye, ne ro min ne, quenda̱h yahn Zacarías che conda̱ ye chete ya̱co chahte yahn Dihvo vo, ca̱hcoya̱hn ye cuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ura che riche cuhn me ne, reva̱h nducoya̱ca ihyan ya̱n, chenun ye cua̱hn chevah. ");
INSERT INTO cutNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tuhme chihndero a̱ma ángel che dechuh Dendiohs, chandi ye na̱n Zacarías la̱do ta̱h cua̱co yahn na̱n ta. ");
INSERT INTO cutNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cuahn che ndihchero Zacarías ángel me ne, a̱ma dihya ye chi. ");
INSERT INTO cutNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ate ra̱hn ángel me ri ye ihyan: ―Zacarías, hua dihye co, te a chihnevan Dendiohs che chique. Ma̱n ne, nda̱hta yehn Elisabet ne, nda̱ca a̱ma sa̱hn da̱ya te, ne conehn che duche se, Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A̱ma co yene, ne namin co yeno a̱ma ya̱hn ihyan che cuhndeya̱n se, ");
INSERT INTO cutNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","te daye ne, chahte vederihquentiyon ca̱h Dendiohs, conan cuma se. Hua cuh se vino, nde hua cuh se nde a̱ma na̱n nune che din che cocoh se. Conun Vaco Ndah yahn Dendiohs sa̱hn nde ro che ametah cuhndeya̱n se. ");
INSERT INTO cutNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A̱ma ya̱hn ihyan nación yahn Israel, din se che ndaconan cotahno ye Dihve ye Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nda̱ se tahque mena̱n ca che co Dihvo vo, conan cuma se vederihquentiyon nduhca̱ che quenan cuma Elías, ca̱va che ndoya̱n ihyan nduco indihte yahn ye ma̱n, ca̱va che cotahno ihyan Ndudo yahn Dendiohs nduhca̱ che ritahno ihyan che ndah ihyan ye na̱n Dendiohs ma̱n. Tihca̱ ca̱hcoya̱n se chedave yahn a̱ma ya̱hn ihyan, ca̱va che nevahnecun ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chiquerune Zacarías ángel me: ―¿Ta̱ca̱ cotahnó che ra̱hn ne ne?, te u ne, a indihte u. Namin ihyan nda̱hta yáhn, a indihte ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ndahconan ángel me yahn ye: ―U ne, Gabriel che redináhn che rihquentiyon Dendiohs. Ma̱n ye tahve ye u, ca̱va che ca̱hmá ndoque ndudo ndah cuh. ");
INSERT INTO cutNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndudo che a rá̱hn ndoque ne, va che conahn, ate nducote hua chitehne ne, co lihme di, ne hua co nte nde nda̱ ro che cuhndeya̱n daye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Numanahn min ne, ihyan ya̱n chahn ne, chenan rino ye, ne rahn ino ye che a̱ma rendah Zacarías chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Cuahn che ndiquenda̱h ye ne, redin ta̱h redin na̱n ye, te chi lihme ye. Tuhme chenahn ihyan chahn che ndihchero ye a̱ma vederihno chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Cuahn che chihno ndate che quenan Zacarías ntiyon min ne, cona̱hn ye ndeva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chuh neve ro min ne, a quenun da̱ya ihyan nda̱hta yahn ye Elisabet. Ihyan min ne, quenun ye vah; hua chahn ye nde a̱ma cua̱n chete che uhn iyo, ne ndedecadino ye: ");
INSERT INTO cutNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Dihvé Dendiohs din ye vederihno cuh nducó. Ma̱n ne, ametah co cuihná̱n na̱n ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Chihno te a̱n iyo ne, tahve tun Dendiohs ángel Gabriel, cuahn ye a̱ma ya̱n lihn che duche Nazaret, esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nda ye ndudo che dechuh Dendiohs yahn a̱ma nda̱hta ntuco che duche ye María. Nda̱hta me ne, a va ndudo yahn ye che cahneva̱co ye nduco José, a̱ma ihyan che nda̱ta yahn David. ");
INSERT INTO cutNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Cuahn che nda̱ ángel me na̱n che quenun nda̱hta me ne, ra̱hn ye ri ye ihyan: ―Necuma di. Dendiohs ne, yahino ye di, ne nduco ye di. A tenda̱hnun ye di va̱n nducoya̱ca nda̱hta. ");
INSERT INTO cutNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cuahn che chihnevan ye che ra̱hn ángel me ne, cuahn ino ye, ne ndedecadino ye: “¿Dehra cuande che tihca̱ ra̱hn ye nducó?” ");
INSERT INTO cutNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tuhme ra̱hn ángel me ri ye ihyan: ―María, dehve rahque, te Dendiohs ne, yahino ye di. ");
INSERT INTO cutNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ma̱n ne, nda̱ca a̱ma daye, ne conehn che duche ye, JESUS. ");
INSERT INTO cutNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ihyan min ne, a̱ma chahte vederihquentiyon conan cuma ye, te Da̱ya Dendiohs che a̱ma yudo ye ihyan. Dihvo vo Dendiohs ne, nda̱hco ye vederihquentiyon che quenan cuma David ta̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ca̱hcantiyon ye ihyan nación yahn Israel, ne hua cuihno vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tuhme chiquerune María ángel me: ―¿Ta̱ca̱ co conahn che ra̱hn ne ne?, te u ne, ametah cahneva̱có. ");
INSERT INTO cutNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ndahconan ángel me yahn ye: ―Co Vaco Ndah yahn Dendiohs, conun di, ne nduco vederihquentiyon yahn Dendiohs conahn. Chemin che daye che cuhndeya̱n ne, Da̱ya Ndah yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A ndihche che din Dendiohs nduco ta̱hn vih Elisabet. Andahre a ndico te, ne hua renda̱ca da̱ya te, ate ma̱n ne, quenun da̱ya te a chi a̱n iyo, ");
INSERT INTO cutNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","te Dendiohs ne, nducuahn che nahn ye ne, rinahn. ");
INSERT INTO cutNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tuhme ra̱hn María: ―Conahn nduhca̱ che ra̱hn ne, te u ne, renevahnecún che rihquentiyon Dihvé Dendiohs. Chihno min ne, cona̱hn ángel me. ");
INSERT INTO cutNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A̱ma o ro min ne, cuahn María a̱ma ya̱n che va cua̱hn icoya̱hn, esta̱do yahn Judea. ");
INSERT INTO cutNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nda̱ ye min ne, min chenda̱ ye chete va̱co Zacarías, ne neca̱h ye Dendiohs Elisabet. ");
INSERT INTO cutNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ndeta̱hn chihnevan Elisabet che neca̱h María Dendiohs ihyan ne, nuhn decua̱h yahn ye che quenun chete ye, ne chiya Vaco Ndah yahn Dendiohs, quenun ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ra̱hn ye: ―Va̱n nducoya̱ca nda̱hta ne, a tenda̱hnun Dendiohs di. Namin a tenda̱hnun ye daye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Di che co chaco Dihvé. ¿Ta̱ca̱ che man cochi quendihchero u? ");
INSERT INTO cutNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ndeta̱hno che nte Dendiohs u ne, nuhn da̱yá che quenun cheté che chi yeno. ");
INSERT INTO cutNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Ndah ro yehn che chitehne!, te conahn ndoque ndudo che dechuh Dihvo vo Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tuhme ra̱hn María: Numacuahn chedave yáhn, rendeva yavena̱n Dihvé Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","A̱ma yenó nduco ye, te ndedevahn ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Andahre a̱ma cheva̱h u na̱n ye, ate neca̱hco ye u. Ma̱n ne, nducoya̱ca ihyan ca̱hma ye te ndah ro yáhn, ");
INSERT INTO cutNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","te Dendiohs, ihyan min che a̱ma yudo vederihquentiyon yahn ye din ye vederihno nducó. Ihyan min che cua̱co, runeca̱de ye na̱n nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Numacuahn ro renan va̱hino ye nducoya̱ca ihyan che renevahnecun ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ihyan min ne, redin ye vederihno rahte. Renda̱hco ndiya ye ihyan che ya̱de ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Rehnevi ye vederihquentiyon yahn ihyan che ndina̱n ye, ne redin ye che rina̱n ihyan che necun ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Rinan ye ihyan che renevahnecun ye Ndudo yahn ye, ne rihcoma̱n ye ihyan che ra̱hco ye che nde hua rendotenan ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Redin ye cuda̱do ihyan nación yahn Israel, ne renan va̱hino ye ihyan, ");
INSERT INTO cutNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","nduhca̱ che ca̱h ye ndudo yahn ye indihte yuhn vo Abraham nduco nducoya̱ca nda̱ta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tenduh ino iyo quenan María va̱co Elisabet, tuhme cona̱hn ye ndeva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cuahn che tuno ro yahn Elisabet ne, chihndeya̱n da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nducoya̱ca ihyan nino ndeva̱co ye nduco ihyan yahn ye ne, a devano ye te a̱ma quenan va̱hino Dendiohs ihyan, ne chi yeno ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chi nine ro ne, cuahn ihyan ca̱va che conahn ye seña decua̱h me, ne nahn conahn ye che duche se Zacarías, nduhca̱ che duche chida se. ");
INSERT INTO cutNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ate ra̱hn chaco se. ―Hua, te Jua̱n conan che duche se. ");
INSERT INTO cutNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ra̱hn ihyan chahn: ―¿Dehco ne?, te ametah nde a̱ma ihyan yahn nchuhn che tihca̱ duche ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tuhme din ta̱h ye che tumerune ye chida se ta̱ca̱ nahn ye che conan che duche se. ");
INSERT INTO cutNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Din ta̱h chida se, chica ye na̱n che dirun ye, ne chaconahn ye: “Jua̱n duche se.” Tuhme cuahn ino ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","A ura min no nuhnde ca̱va chihya Zacarías, ndiquenda̱h ca̱hn ye, ne cana̱n ndeva ye numacuahn vedeyeno yavena̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nde tahque cuahn ino ihyan chahn chi, ne chetuhn ndudo me numachahte esta̱do yahn Judea. ");
INSERT INTO cutNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nducoya̱ca ihyan che checadino ye ne, rente ye nduco vih: ―¡A̱ma chahte ntiyon conan cuma sa̱hn dihn ca̱h! Tihca̱ ra̱hn ye, te Dendiohs ne, nduco ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Chiya Vaco Ndah yahn Dendiohs, quenun Zacarías, ne cahndudo ye: ");
INSERT INTO cutNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ndeva vo yavena̱n Dihvo vo Dendiohs yahn Israel, te ndedevahn ye uvo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Va̱n nda̱ta yahn David, ihyan min che dinahn ye ndudo yahn ye ne, a tenda̱hnun ye a̱ma ihyan che ndedevahn ye uvo numacuahn vederihquentiyon yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","nduhca̱ che ca̱h ye ndudo yahn ye ro mena̱n, cahndudo ihyan ndah che profeta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tihca̱ ndedevahn ye uvo na̱n nducoya̱ca ihyan che hua ri rendihche ye uvo. ");
INSERT INTO cutNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Renan va̱hino ye indihte yuhn vo, ne redinahn ye ndudo ndah yahn ye che chihco ca̱de ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ndudo min che ca̱h ye indihte yuhn vo Abraham, ");
INSERT INTO cutNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","che ndedevahn ye uvo na̱n ihyan che hua ri rendihche ye uvo, ca̱va che numa ino vo ndeva vo yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Numacuahn ro che cuahtenan vo iyehnse cuh ne, nahn che dave chedave yuhn vo na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Di, da̱ya má̱n, cuahndode ndudo yahn Dendiohs, ihyan min che a̱ma yudo vederihquentiyon yahn ye. Cahn tahque mena̱n ca che co Dihvo vo, cahcoyan chedave yahn ihyan, ca̱va che nevahnecun ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Cah, checadino ihyan che ndedevahn Dendiohs uvo yahn ye, te nchahco ye nunde yuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dendiohs yuhn vo ne, a̱ma quenan va̱hino ye ihyan iyehnse. Chemin che ca̱ca Da̱ya ye vahchetero, ");
INSERT INTO cutNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ndedevahn ye ihyan che ca̱hnda yahn ye che vate ye ta̱h vederih, din ye che nda̱hca̱ cuahtenan ye. ");
INSERT INTO cutNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Me sa̱hn dihn me ne, chihta se, ne chi chahte vededevano yahn se. Quechica se ya̱hn na̱n che metah duhva, nde nda̱ ro che cana̱n cahndudo se ndudo yahn Dendiohs, chihnevan ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ta̱hn min ne, chihquentiyon emperador Augusto César che conan ca̱ca nducoya̱ca ihyan che vate ye numachahte na̱n che rihquentiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Quenan Cirenio gobernador yahn Siria, ne cade ro min cana̱n raconahn ca̱ca se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nducoya̱ca ihyan, adecotino che chenan ye ne, va che ca̱hn ye, conan ca̱ca ye ya̱n na̱n che chica nda̱ta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José ne, chica ye ya̱n Nazaret, esta̱do yahn Galilea, cuahn ye ya̱n Belén, esta̱do yahn Judea, ya̱n va̱co David, te nda̱ta yahn David ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Min va che conan ca̱ca ye. Namin min va che conan ca̱ca María, ihyan min che va ndudo yahn ye che cahneva̱co ye nduco vih. Ihyan min ne, a nun cuhndeya̱n da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cuahn che chenan ye Belén ne, nda̱ ro yahn María che cuacoya̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Min chihndeya̱n da̱ya ye che mena̱n, ne chahcotuma ye decua̱h me nduco tino. Nducote hua nda̱ca ye nde a̱ma vah ne, chahtenan ye a̱ma va̱co yuhdo. Chete a̱ma inguhto na̱n che reh nun yuhdo, min din dave ye na̱n che chacondihte ye decua̱h me. ");
INSERT INTO cutNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nino ya̱n Belén vatenduche a̱ma o ihyan, redin ye cuda̱do itecuche yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nahmin ne, nda̱ a̱ma ángel che dechuh Dihvo vo Dendiohs na̱n ihyan chahn. Adena̱n chiya dave na̱n che chenun ye, ne a̱ma dihya ye chi. ");
INSERT INTO cutNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ate ra̱hn ángel me ri ye ihyan: ―Hua dihya nchuhn co, te cochí, checú a̱ma ndudo ndah, ne a̱ma co yeno nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ma̱n ro cuh ne, min ya̱n va̱co David chihndeya̱n a̱ma decua̱h. A decua̱h min che Dihvo vo CRISTO, ihyan min che ndedevahn ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Codevano nchuhn te cua̱co ndudo che rí nchuhn, te nta̱ca ne decua̱h me, ndacotuma tino, quendite chete va̱co yuhdo. ");
INSERT INTO cutNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Adena̱n nda̱ a̱ma ya̱hn ángel che chica ye vahchetero, chinduco ye ángel me, ndeva ye yavena̱n Dendiohs, ne ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Nda̱hca̱ che ndeva nducoya̱ca ihyan numacuahn vedeyeno yavena̱n Dendiohs, ihyan min che va ye vahchetero! Muhn iyehnse cuh ne, nducoya̱ca ihyan che yeno Dendiohs nduco ye ne, din Dendiohs che nda̱hca̱ cuahtenan ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Cuahn che cona̱hn ángel chahn vahchetero ne, ihyan che redin ye cuda̱do itecuche ne, ra̱hn ye: ―Cuhn vo nduco vih ya̱n Belén, quendihchero vo vederihno che chi, nduhca̱ che dechuh Dendiohs ndudo yuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndeta̱hno cuahn ihyan chahn, ne nta̱ca ye María nduco José nduco decua̱h me che quendite chete va̱co yuhdo. ");
INSERT INTO cutNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cuahn che ndihchero ihyan chahn decua̱h me ne, rente ye nduhca̱ che ra̱hn ángel me yahn decua̱h me. ");
INSERT INTO cutNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nducoya̱ca ihyan che chihnevan ye che rente ihyan chahn ne, a̱ma rahn ino ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María ne, quenun ino ye nducuahn che rente ihyan chahn, ne ndeva ye ndudo me chete chedave yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tuhme cona̱hn ihyan chahn, rendeva ye numacuahn vedeyeno yavena̱n Dendiohs, te a chinahn nducuahn ndudo che dechuh Dendiohs yahn ye, ne a ma̱n ye chihnevan ye ma̱n, ndihchero ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chi nine ro me ne, nahn ye seña decua̱h me, ne chaconahn ye che duche JESUS, a nduhca̱ che ra̱hn ángel me ri ye María nde ro mena̱n cuahn che ametah conun da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés ne, dirun ye te ihyan nda̱hta che cuacoya̱hn ye ne, hua co conda̱ ye chete ya̱co, nde tuno ro che a ndihco ca̱de Dendiohs. María ne, quenan rino ye nde tuno ro min, tuhme cuahn ye nduco José ya̱n Jerusalén, quenda ye decua̱h me, ca̱va che na̱hma ye na̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tihca̱ din ye, te a nihnde ca̱de na̱n ley yahn Dendiohs: “Nducoya̱ca checa̱hya cha̱hn che rahteya̱n mena̱n ne, va che ca̱hco vih ihyan, ca̱va che din ntiyon yahn Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Namin ndihco ca̱de Dendiohs te nducoya̱ca ihyan nda̱hta che cuhndeya̱n da̱ya ye ne, va che ca̱h ye o icui, o o pichón ca̱hya, ca̱va che co te vedino, ne ca̱h María vedino min. ");
INSERT INTO cutNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ro min ne, min ya̱n Jerusalén va a̱ma ihyan che duche ye Simeón. Ihyan min ne, ndah ihyan ye na̱n Dendiohs, ne quenun Vaco Ndah yahn Dendiohs ihyan. Quenan rino ye ro che ndedevahn Dendiohs ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ca̱h Vaco Ndah yahn Dendiohs, che checadino ye te hua coh ye nde nda̱ ro che ndihchero ma̱n ye ihyan min che dechuh Dihvo vo Dendiohs, ca̱va che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Din Vaco Dendiohs che cuahn Simeón ya̱co chahte, ne ura min nda̱ José nduco María ca̱va che na̱hma ye decua̱h me na̱n Dendiohs nduhca̱ che a nihnde ca̱de na̱n ley che dirun Moisés. ");
INSERT INTO cutNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón ne, cheta̱h ye decua̱h me, quenuhn ye. Ndeva ye numacuahn vedeyeno yavena̱n Dendiohs, ne ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Dihvé Dendiohs, ma̱n ne, a co nda̱cá iyehnse cuh. Hua dehva ra̱hcó, te a chinahn ndudo che te ne, checadinó. ");
INSERT INTO cutNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","A ndihchero má̱n decua̱h cuh yahn ne che ndedevahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","A dechuh ne ca̱va che ndedevahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ma̱n che cua̱co codevano ihyan ta̱ma nación Ndudo yahn ne, ne ndeva nducoya̱ca ihyan yavena̱n ihyan yahn ne, ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José nduco María ne, a̱ma chahn ino ye yahn ndudo che tihca̱ ra̱hn Simeón yahn decua̱h me. ");
INSERT INTO cutNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tuhme chica Simeón Dendiohs ca̱va ihyan chahn, ne ra̱hn ye nduco María: ―Condihche. Cuahn che cuihta decua̱h cuh che dechuh Dendiohs ne, a̱ma ya̱hn ihyan co ta̱n ye nduco. Chemin che va̱n ihyan nación yahn Israel ne, a̱ma ya̱hn ihyan ndevahn ye, ne a̱ma ya̱hn ye conda ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nduco tihca̱ cuhnde ro vederendedecadino yahn queri a̱ma ye. Me di ne, va che choh a̱ma vedeyah chahte. ");
INSERT INTO cutNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Min chete ya̱co quenun a̱ma indihte nda̱hta che duche ye Ana. Ihyan min ne, rahndudo ye Ndudo yahn Dendiohs. Fanuel duche chida ye, nda̱ta yahn Aser. Chihno ndache nduyo che chihneva̱co ye ne, chih incha̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ro min ne, a cun raco cun nduyo ye. Ro ma̱n, vino ma̱n, quenun ye chete ya̱co, reva̱h ye ma̱n, rihnde ye ya̱hte ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nda̱ ye ura min, ne neca̱h ye nundihve cuahn Dendiohs. Cahndudo ye yahn decua̱h me, chihnevan a̱ma ya̱hn ihyan che chenan rino ye ro che ndedevahn Dendiohs ihyan ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José nduco María ne, dinahn ye nducuahn che ndihco ca̱de Dendiohs, tuhme cona̱hn ye ya̱n va̱co ye Nazaret, esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dihvo vo Jesucristo ne, rihta ye, ne a̱ma va vededevano yahn ye. Dendiohs ne, a̱ma yahino ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nduyo nduyo, ro che renda̱ vihco ro yudo ne, rahn José nduco María ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cuahn che chi Dihvo vo ndichio nduyo ne, cuahn tun ihyan chahn vihco me. ");
INSERT INTO cutNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chuh vihco me ne, cona̱hn ye, nde hua devano ye te quenan ca Dihvo vo min ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ra̱hco ye te co va̱n ihyan che a cona̱hn ye chinduco ye, ne rinuhn ye ihyan va̱n ihyan yahn ye ma̱n, ihyan rendihche ye ma̱n. A numa ro vatechica ye, ");
INSERT INTO cutNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ate nducote hua nta̱ca ye ihyan ne, ndaconan tun ye ya̱n Jerusalén, rinuhn ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nde na̱n che chi ino ro che rinuhn ye ihyan ne, nta̱ca ye ihyan chete ya̱co va̱n sa̱hn devano ley che dirun Moisés. Min quenun ye, rihnevan ye che rente sa̱hn chahn ma̱n, retumarune ye sa̱hn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Namin sa̱hn chahn ne, retumarune se ihyan, ne a̱ma rahn ino se yahn che a̱ma va vededevano yahn ye ma̱n, yahn ndudo che rendahconan ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cuahn che ndihchero José nduco María che min quenun ye ne, a̱ma chahn ino ye, ne ra̱hn María: ―Da̱yá, ¿dehco che tihca̱ din nduco nuhn?, te u nduco chide, a̱ma chuhrihn nuhn, rendedecadino nuhn cave, rinuhn nuhn di. ");
INSERT INTO cutNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ndahconan Dihvo vo yahn ye: ―¿Dehco che rinuhn nchuhn u? ¿A hua devano te na̱n ntiyon yahn Chidá va che conán? ");
INSERT INTO cutNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ate hua chenahn ihyan chahn deh cuande che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tuhme cona̱hn ye nduco ihyan chahn ya̱n va̱co ye, Nazaret. Quendi redinahn ye che ra̱hn ihyan chahn, ne quenun ino María nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Dihvo vo ne, chihta ye, ne chi chahte vededevano yahn ye. Nda̱hca̱ quenan ye na̱n Dendiohs ma̱n, na̱n ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cuahn che chi ntihyon nduyo che quenan Tiberio César emperador ne, Poncio Pila̱to quenan se gobernador yahn Judea. Herodes quenan se gobernador yahn Galilea, ne dihno Herodes che duche se Felipe, quenan se gobernador yahn Iturea nduco Traconite. Lisanías quenan se gobernador yahn Abilinia. ");
INSERT INTO cutNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás nduco Caifás che chidocuya̱n che tahque ndina̱n. Nduyo min quechica Jua̱n, da̱ya Zacarías, ya̱hn na̱n che metah duhva. Min ca̱h Dendiohs che checadino ye ndudo che cuahndudo ye. ");
INSERT INTO cutNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chihto ico Jordán cana̱n rahndudo Jua̱n che nto ino ihyan nunde yahn ye ma̱n, che cuedenune ye ma̱n, ca̱va che nchahco Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tihca̱ chinahn nduhca̱ che dirun ihyan profeta Isaías tuhca̱: Cuahndudo a̱ma se min ya̱hn na̱n che metah duhva tuhca̱: “Cuihcoya̱n nchuhn chedave yahn ne, te a nun nda̱ Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ihyan che redendah ye yune che nda̱hca̱ ne, rendedecuto ye ya ma̱n, rihtera ye ico ma̱n, cuete ma̱n, renedin cua̱co ye na̱n che cueh ma̱n, renda̱hco nahn ye na̱n che chihnga̱ ma̱n. Tihca̱ va che ca̱hcoya̱n ihyan chedave yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","te codevano nducoya̱ca ihyan che ndedevahn Dendiohs ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ra̱hn Jua̱n ri ye ihyan che renda̱ ye ca̱va che cuedenune ye: ―Nchuhn ne, nduhca̱ cu ta̱n tihchan ne. Hua ra̱hco ne che nduco che cuedenune ne a ndevahn ne yahn castigo yahn Dendiohs che va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Va che nto ino nchuhn nunde yahn ne ma̱n, nda̱hca̱ cuahtenan ne na̱n Dendiohs ma̱n. Hua ndere ra̱hco ne che cochihve yahn ne che nda̱ta yahn Abraham nchuhn, te hua redinahn ne. Ndete che nahn Dendiohs che ndere co ya̱hn nda̱ta yahn Abraham ne, andahre na̱n tu che tuhchan, co ndedecuan ca ye nda̱ta yahn ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nduhca̱ che rihca ihyan ya̱hn nda̱ta che hua richihve ndute yahn, riquiya̱hn ye ne, tihca̱ a nun techeca̱de Dendiohs yahn nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tuhme tumerune ihyan: ―¿Deh va che din nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ndahconan Jua̱n yahn ye: ―Ihyan che va o tino yahn ye ne, va che ca̱h ye a̱ma yahn ihyan che metah yahn ye, ne ihyan che va che reh ye ne, va che conan ye ihyan che metah che cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Namin nda̱ a̱ma o sa̱hn rica tumeca̱diyo ca̱va che cuedenune se, ne tumerune se: ―Ihyan Ricuahn, ¿deh va che din nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ndahconan Jua̱n yahn se: ―Hua ca̱ca nchuhn tumeca̱diyo che tahque ndeh che co che rihquentiyon ley. ");
INSERT INTO cutNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Namin a̱ma o sanda̱do ne, tumerune se: ―Nuhn, ¿deh va che din nuhn ne? Ndahconan Jua̱n yahn se: ―Hua duco nchuhn. Hua ndere cuih nunde ne yahn ihyan. Cuahtenan ne vedeyeno nduco tume che renevihve nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A̱ma ya̱hn ihyan rendedecadino ye yahn Jua̱n, ne reca̱h yeno ye chedave yahn ye, te ra̱hco ye te co a ihyan min che va ca̱de che chi ye, ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ate ra̱hn Jua̱n ri ye nducoya̱ca ihyan: ―Ndiyu u. Cochi ta̱ma ihyan che tahque chahte vederihquentiyon yahn ye che co u. U ne, nde hua redin yahn che co mare a̱ma sa̱hn deca̱hya yahn ye. U ne, rehdenuné ihyan, ate ihyan min ne, din ye che conun Vaco Ndah yahn Dendiohs nchuhn ma̱n, din ye castigo ihyan nunde ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cuahn che retiveya̱to ihyan trigo ne, reneva̱hn ye ndute yahn, rih ndah ye. Ate da̱cheya̱ma yahn ne, renedin da̱ma ye, rihquiya̱hn ye. Atihnoca̱ ihyan min, te a nun techeca̱de ye yahn nducoya̱ca ihyan. Ihyan che ndah ihyan ye na̱n Dendiohs ne, quenda ye ihyan vahchetero, ne ihyan che hua ndah ye ne, dechuh ye ihyan va̱n ruchiya̱hn che hua rintoh. ");
INSERT INTO cutNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nduco a̱ma ndeh ndudo che tuhchan, rahndudo Jua̱n, ricuahn ye ihyan ndudo ndah yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jua̱n ne, riya̱hve ye gobernador Herodes yahn che quenan se nduco Herodías, nda̱hta yahn dihno se Felipe. Namin riya̱hve ye sa̱hn yahn nducuahn nunde yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chemin che chihquentiyon se che quenun Jua̱n va̱coya̱hn, ne nduco chemin decuihta nduh se nunde yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cuahn che chihno chedenune a̱ma ya̱hn ihyan nación yahn Israel ne, nda̱ Dihvo vo, chedenune ye. Chihno min ne, nahmin che reva̱h ye ne, ndondah vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nduhca̱ che ro a̱ma icui ne, tihca̱ chi ro Vaco Ndah yahn Dendiohs, chiya, quenun ihyan. Tuhme chihnevan ye a̱ma ndudo che chica vahchetero che ra̱hn: ―Di che Da̱yá. Yahinó di. A̱ma yenó ndoque. ");
INSERT INTO cutNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","A ta̱hn min che cana̱n Dihvo vo, redin ye ntiyon yahn ye. A ri ye tenduh ndico ndiche nduyo. Nde na̱n che cana̱n ne, dendah Dendiohs Adán. Da̱ya Adán ne, Set. Da̱ya Set ne, Enós. Da̱ya Enós ne, Cainán. Da̱ya Cainán ne, Mahalaleel. Da̱ya Mahalaleel ne, Jared. Da̱ya Jared ne, Enoc. Da̱ya Enoc ne, Matusalén. Da̱ya Matusalén ne, Lamec. Da̱ya Lamec ne, Noé. Da̱ya Noé ne, Sem. Da̱ya Sem ne, Arfaxad. Da̱ya Arfaxad ne, Cainán. Da̱ya Cainán ne, Sala. Da̱ya Sala ne, Heber. Da̱ya Heber ne, Peleg. Da̱ya Peleg ne, Ragau. Da̱ya Ragau ne, Serug. Da̱ya Serug ne, Nacor. Da̱ya Nacor ne, Taré. Da̱ya Taré ne, Abraham. Da̱ya Abraham ne, Isaac. Da̱ya Isaac ne, Jacob. Da̱ya Jacob ne, Judá. Da̱ya Judá ne, Fares. Da̱ya Fares ne, Esrom. Da̱ya Esrom ne, Aram. Da̱ya Aram ne, Aminadab. Da̱ya Aminadab ne, Naasón. Da̱ya Naasón ne, Salmón. Da̱ya Salmón ne, Booz. Da̱ya Booz ne, Obed. Da̱ya Obed ne, Isaí. Da̱ya Isaí ne, David. Da̱ya David ne, Natán. Da̱ya Natán ne, Matata. Da̱ya Matata ne, Mainán. Da̱ya Mainán ne, Melea. Da̱ya Melea ne, Eliaquim. Da̱ya Eliaquim ne, Jonán. Da̱ya Jonán ne, José. Da̱ya José ne, Judá. Da̱ya Judá ne, Simeón. Da̱ya Simeón ne, Leví. Da̱ya Leví ne, Matat. Da̱ya Matat ne, Jorim. Da̱ya Jorim ne, Eliezer. Da̱ya Eliezer ne, Josué. Da̱ya Josué ne, Er. Da̱ya Er ne, Elmodam. Da̱ya Elmodam ne, Cosam. Da̱ya Cosam ne, Adi. Da̱ya Adi ne, Melqui. Da̱ya Melqui ne, Neri. Da̱ya Neri ne, Salatiel. Da̱ya Salatiel ne, Zorobabel. Da̱ya Zorobabel ne, Resa. Da̱ya Resa ne, Joana. Da̱ya Joana ne, Judá. Da̱ya Judá ne, Semei. Da̱ya Semei ne, Matatías. Da̱ya Matatías ne, Maat. Da̱ya Maat ne, Nagai. Da̱ya Nagai ne, Esli. Da̱ya Esli ne, Nahum. Da̱ya Nahum ne, Amós. Da̱ya Amós ne, Matatías. Da̱ya Matatías ne, José. Da̱ya José ne, Jana. Da̱ya Jana ne, Melqui. Da̱ya Melqui ne, Leví. Da̱ya Leví ne, Matat. Da̱ya Matat ne, Elí. Da̱ya Elí ne, José. Tihca̱ cochi nda̱ta yahn José. Nducoya̱ca ihyan ne, ra̱hco ye te Dihvo vo Jesucristo ne, da̱ya José ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Dihvo vo ne, quenun Vaco Ndah yahn Dendiohs ihyan, ne chica ye min ico Jordán. Din Vaco Dendiohs che cuahn ye ya̱hn na̱n che metah duhva. ");
INSERT INTO cutNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Min quenan ye o raco ro, ne chundah ne, retumarande se ihyan. Nducuahn ro min ne, hua cheh ye, ne chihno min ne, chi cuico ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tuhme ra̱hn chundah me ri se ihyan: ―Ndete che Da̱ya Dendiohs ndih ne, cuihquentiyon ne tu cuh che ndaconda̱ pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ndahconan Dihvo vo yahn se: ―Na̱n Ndudo yahn Dendiohs a ndirun: “Ndiyu dema̱n nduco pa̱n co conun ico ihyan, te namin rendotenan ye Ndudo yahn Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tuhme quenda chundah me Dihvo vo a̱ma tingüete ya̱co, ne venchahteno na̱hma se ihyan nducuahn vederihquentiyon che va iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ra̱hn se ri se ihyan: ―U té nducuahn vederihquentiyon che tihchan ndih, ndete che dinahn ne che ca̱hmá, te u va tá̱h nducuahn, ne adecoduhno ihyan che náhn ne, co cá̱h ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ndete che cahntihya ne ná̱n, ndeva ne yavená̱n ne, co yahn ne nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ra̱hn Dihvo vo ri ye sa̱hn: ―Cuehn va̱ne chundah, te na̱n Ndudo yahn Dendiohs a ndirun: “Cuendeva yavena̱n Dihve Dendiohs, ne a ihyan min no codinehn che ca̱hma ye.” ");
INSERT INTO cutNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tuhme quenda se ihyan tin ya̱co chahte yahn ya̱n Jerusalén, ne ra̱hn se ri se ihyan: ―Ndete che Da̱ya Dendiohs ndih ne, ca̱va ne muhn. ");
INSERT INTO cutNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Hua dehva co yahn ne, te a ndirun na̱n Ndudo yahn Dendiohs: Dechuh Dendiohs ángel yahn ye ca̱va che conduco ye ndih, ");
INSERT INTO cutNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","din ye cuda̱do ndih ca̱va che hua dehva co yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ra̱hn Dihvo vo ri ye sa̱hn: ―Namin na̱n Ndudo yahn Dendiohs a ndirun: “Hua tumarende Dihve Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Cuahn che chihno tumarande chundah me Dihvo vo ne, cona̱hn se. Quenan rino se nde nda̱ a̱ma ro che nda̱hca̱ ca̱va se. ");
INSERT INTO cutNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Dihvo vo ne, quenan cuma ye vederihquentiyon yahn Vaco Ndah yahn Dendiohs, ne cona̱hn ye esta̱do yahn Galilea. Nducuahn ya̱n ne, a̱ma chetuhn ndudo yahn vederihquentiyon che quenan cuma ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ricuahn ye chete ya̱co, ne rendeva nducoya̱ca ihyan yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nda̱ Dihvo vo ya̱n Nazaret na̱n che chihta ye, ne rahn ye ya̱co ndate ndate, ro che rahte tuhno ihyan. A̱ma ro ne, chenda̱ ye chete ya̱co, ne chandi ye ca̱va che cuahndudo ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Sa̱hn che redin cuda̱do ya̱co me ne, ca̱h se ca̱ca che dirun ihyan profeta Isaías ihyan. Cuahn che nta̱ ye ca̱ca me ne, cahndudo ye na̱n che ndirun tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Vaco Dihvé Dendiohs ne, quenun u. Dechuh Dendiohs u, ca̱va che cacuáhn ndudo ndah yahn ye, cahnevan nducoya̱ca ihyan che necun ye ma̱n, ca̱va che cuahndudó che va ye vedeyeno che nchahco ye yahn ihyan che nto ino ye nunde yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Dín che co ro na̱n ihyan che hua ro na̱n ye ma̱n, ndedeváhn ihyan che yah rahno ye, redin nunde yahn ye ma̱n, cuahndudó nduhca̱ che yahino Dihvo vo Dendiohs ihyan iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chihno min ne, ndechetihve Dihvo vo ca̱ca me, neca̱h ye sa̱hn che redin cuda̱do ya̱co me, ne chihnde ye. Nducoya̱ca ihyan che chenun ye chete ya̱co me ne, vateya̱n ye numacuahn vedenecun. ");
INSERT INTO cutNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tuhme ra̱hn ye: ―Ma̱n ro cuh ne, a chinahn ndudo che chihno cahndudó, chihnevan nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chi yeno nducoya̱ca ihyan nduco Dihvo vo, ne rahn ino ye yahn ndudo ndah che rente ye. Ate cana̱n tumerune ye va̱n ma̱n ye nduco vih: ―¿A ndiyu sa̱hn tih che da̱ya José me? ");
INSERT INTO cutNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co te nahn ca̱hma nchuhn nducó ndudo cuh: “Doctor, tahque ndah che codique man di. Codin muhn ya̱n vaque vederihno nduhca̱ che din min ya̱n Capernaum.” ");
INSERT INTO cutNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Quendi Dihvo vo, ne ra̱hn ye: ―Cua̱co rá̱hn rí nchuhn te nde a̱ma ihyan profeta, hua renevahnecun ihyan ya̱n va̱co ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ro mena̱n me ne, a̱ma chihnde cuico, te hua chan co ino nduyo quenan ma̱hn. Ro min ne, a̱ma vate nda̱hta va̱h nación yahn Israel, ne andahre min quenan ihyan profeta Elías, ");
INSERT INTO cutNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ate hua dechuh Dendiohs ihyan, ca̱va che conan ye nde a̱ma nda̱hta va̱h chahn. Tahque ndah ye ne, dechuh ye ihyan, ca̱va che conan ye a̱ma nda̱hta va̱h yahn ta̱ma nación che va te ya̱n Sarepta, nino ya̱n Sidón. ");
INSERT INTO cutNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ta̱ma yune ne, a nación yahn Israel, vate a̱ma ya̱hn ihyan che ndi ye cah che recha̱ yute. Min quenan profeta Eliseo, ne namin hua din ye che ndoyahn nde a̱ma ihyan chahn. Ate din ye che ndoyahn a̱ma sa̱hn nación yahn Siria che duche se Naamán, andahre sa̱hn ta̱ma nación se. ");
INSERT INTO cutNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cuahn che chihnevan ihyan che chenun ye chete ya̱co me che tihca̱ ra̱hn Dihvo vo ne, a̱ma chi ta̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ndeta̱hno necuan ihyan chahn, ne quenda ye ihyan numacuahn vedeta̱n cua̱hn chihto ya̱n na̱n a̱ma tin ya̱va ya̱co ca̱va che deca̱va ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ate hua chi din ihyan chahn tihca̱, te chuh Dihvo vo va̱n nducoya̱ca ye, ne cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nda̱ Dihvo vo Jesucristo ya̱n Capernaum, esta̱do yahn Galilea, ne ndate ndate, ro che rahte tuhno ihyan, ricuahn ye chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ihyan che rihnevan ye che ricuahn Dihvo vo ne, a̱ma rahn ino ye, te numacuahn vederihquentiyon yahn ye ricuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A̱ma yune ne, chenda̱ Dihvo vo chete ya̱co me, ne min quenun a̱ma sa̱hn che quenun vaco chihnga̱ sa̱hn. A̱ma dito cah se: ");
INSERT INTO cutNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ndih, Jesús yahn ya̱n Nazaret, ¿dehco che reca̱hdenun ne yune yahn nuhn? ¿A cochi ne che decuihno ne nuhn ne? U devano duh ndih. Ndih che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Chihquentiyon Dihvo vo vaco chihnga̱ me: ―¡Cuenedihn chende! ¡Cuendiquendah sa̱hn tih! Ndeta̱hno din vaco chihnga̱ me che chendave sa̱hn min na̱n nducoya̱ca ihyan che chenun ye min. Ate hua dehva chi yahn se, ne ndiquenda̱h sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nducoya̱ca ye ne, a̱ma dihya ye chi, ne rente ye va̱n ma̱n ye nduco vih: ―¡Ama chahte vederihquentiyon quenan cuma ihyan tih! ¡Nde vaco chihnga̱ redinahn ndudo yahn ye, ne rendiquenda̱h! ");
INSERT INTO cutNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Numachahte esta̱do yahn Galilea, chetuhn ndudo yahn vederihno che redin Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Chihno min ne, ndiquenda̱h Dihvo vo chete ya̱co me, ne cuahn ye ndeva̱co Simón. Inda̱hn Simón ne, quendihte ye, ndi ye cah ihno. Chica ihyan ndeva̱co ye Dihvo vo che din ye che ndoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Chahn nda̱ ye na̱n ihyan min, ne chihquentiyon ye che cuavi cah me. Ndeta̱hno ndoyahn ihyan min, ne necuan ye, ca̱h ye, cheh Dihvo vo nduco combiero yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ura che a chehche ya̱hn ne, quenda ihyan nducoya̱ca ihyan cah yahn ye che ndeh na̱n cah ndi ye, cuahn ye na̱n Dihvo vo. Nahn ta̱h ye queri a̱ma ihyan cah chahn, ne ndoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Va̱n ihyan cah chahn ne, nduco a̱ma ya̱hn ihyan che chenun vaco chihnga̱ ihyan, ne ndetenda̱h Dihvo vo vaco chihnga̱ chahn. Cuahn che rendiquenda̱h ne, rah: ―Ndih che Da̱ya Dendiohs. Ate chihco yudo Dihvo vo vaco chihnga̱ chahn, ne hua ca̱h yune ye che ca̱hma duh ihyan ye, te a devano che a ihyan min che a va ca̱de che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ta̱ma ro cuahn che a chi dave ne, cuahn Dihvo vo a̱ma cua̱n na̱n che metah duhva, ne min cuahn ihyan ya̱n, quenuhn ye ihyan. Nta̱ca ihyan chahn ihyan, ne ra̱hn ye nduco ye che hua nda̱ca ye min, te nahn ihyan chahn che conan ca ye. ");
INSERT INTO cutNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ate ra̱hn Dihvo vo ri ye ihyan: ―Va che cá̱hn ya̱n chena̱hn, cacuáhn ndudo ndah yahn vederihquentiyon yahn Dendiohs, te a ca̱va chemin che cochí. ");
INSERT INTO cutNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tuhme quechica ye nduh ya̱n nduh ya̱n, esta̱do yahn Galilea, ricuahn ye chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A̱ma yune ne, nti Dihvo vo chihto vine yahn Galilea, ne a̱ma chi da̱ma ihyan na̱n ye, ca̱va che cahnevan ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ndihchero Dihvo vo che vate o ba̱rco na̱n nune chihto vine me. Ihyan che reta̱h ya̱hca ne, a ndiquenda̱h ye chete ba̱rco chahn, ne ura min ne, rena̱no ye ya̱na yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Cuahn Dihvo vo, ne chenda̱ ye chete ba̱rco che yahn Simón, ne chica ye favor ihyan che caca̱hca ye ba̱rco yahn ye na̱n che hua nino cuahn chihto vine me. Tuhme chihnde ye chete ba̱rco me, ne cana̱n chicuahn ye ihyan che ndi da̱ma ye min. ");
INSERT INTO cutNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuahn che chihno chicuahn ye ne, ra̱hn ye ri ye Simón: ―Cuicahque ba̱rco cuh cua̱hn na̱n che ya̱no nune, ne cuih ya̱na yehn ca̱va che cotah ya̱hca. ");
INSERT INTO cutNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ndahconan Simón yahn ye: ―Ihyan Ricuahn, a numa ya̱n din nuhn ntiyon, ne nde a̱ma ya̱hca hua cheta̱h nuhn. Ate nducote a ndih che rihquentiyon ne ne, cuíh ya̱na. ");
INSERT INTO cutNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tihca̱ din ihyan chahn, ne a̱ma chito ya̱hca nde a cana̱n rendan ya̱na me. ");
INSERT INTO cutNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tuhme din ta̱h ihyan chahn yahn combiero yahn ye che chenun ye ba̱rco che ta̱ma me, ca̱va che chi ye conan ye ihyan. Nda̱ ihyan chahn, ne va̱n nducoya̱ca ye decuto ye ya̱hca nduh che o ba̱rco chahn, nde tuno adeche cuehchenun va̱n nune. ");
INSERT INTO cutNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cuahn che ndihchero Simón che tihca̱ chi ne, chehntihya ye na̱n Dihvo vo, ne ra̱hn ye: ―Dihvé, u ne, ndiyu ihyan che co cochí na̱n ne, te u ne, ihyan nunde u. ");
INSERT INTO cutNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tihca̱ ra̱hn ye, te cuahn ino ye nduco nducoya̱ca ihyan chahn yahn vederihno che din Dihvo vo che a̱ma ya̱hn ya̱hca nda̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Namin cuahn ino nduh che o da̱ya Zebedeo che duche ye Jacobo ma̱n, Jua̱n ma̱n. Ihyan chahn che combiero yahn Simón. Ate ra̱hn Dihvo vo ri ye Simón: ―Dehve rahque, te nduhca̱ che redin ntiyon che retah ya̱hca ne, ma̱n ne, tihca̱ din ntiyon, din dame ihyan ca̱va che conduco ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tuhme ndetenda̱h ihyan chahn ba̱rco chahn va̱n nune, ne chihcoma̱n ye ntiyon yahn ye ma̱n, dehtenduh yahn ye ma̱n, ne cuahn ye, chinduco ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A̱ma yune ne, quenan Dihvo vo a̱ma cua̱n ya̱n, ne nda̱ a̱ma sa̱hn che ndi se cah che recha̱ yute. Cuahn che ndihchero se Dihvo vo ne, cuahn se, chehntihya se na̱n ye. Chica se favor ihyan, ne ra̱hn se: ―Dihvé, a devanó te co din ne che ndoyáhn, ndete che nahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nahn ta̱h Dihvo vo sa̱hn, ne ra̱hn ye: ―¿Ta̱ca̱ hua? Náhn. Ma̱n ne, a ndoyehn. Chihno ra̱hn ye chemin ne, a ndeta̱hno ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tuhme chihquentiyon ye sa̱hn che hua ca̱hma se nduco nde a̱ma ihyan ta̱ca̱ chi che ndoyahn se. Ra̱hn ye ri ye sa̱hn: ―Nducote a ndoyehn ne, cuehn na̱n chidocuya̱n, ne cah vedino che ndihquentiyon Moisés, ca̱va che ndihchero nducoya̱ca ihyan che a ntoyehn. ");
INSERT INTO cutNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A̱ma nun chetuhn ndudo yahn vederihno che tihca̱ din Dihvo vo, ne a̱ma ya̱hn ihyan ri da̱ma ye ro ro, ca̱va che cahnevan ye che ricuahn Dihvo vo ma̱n, ca̱va che din Dihvo vo che ndoyahn ihyan che cah ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ura va ne, rahn Dihvo vo dema̱n ye na̱n che metah duhva, ne min reva̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A̱ma ro cuahn che ricuahn Dihvo vo ne, min vate sa̱hn fariseo nduco sa̱hn devano ley che dirun Moisés che chica se nducuahn ya̱n yahn Judea ma̱n, ya̱n Jerusalén ma̱n, ca̱va che cahnevan se che ricuahn ye. Dihvo vo ne, redin ye che rendoyahn ihyan cah, te quenan cuma ye vederihquentiyon yahn Dihvo vo Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ura min nda̱ a̱ma o ihyan, nda ye a̱ma sa̱hn che ndi cheche se, quendite se na̱n yundo. Nahn conda̱ ihyan chahn nduco se chete vah, ca̱va che condihte ye sa̱hn na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ate hua chi chuh ihyan chahn nduco se chendevah, te a̱ma ya̱hn ihyan ndito ye min. Tuhme cocha ye tin vah me, ne ntihne ye a̱ma ndi ima vah. Nde min ndedevah ye yundo na̱n che quendite se cua̱hn chete vah na̱n nducoya̱ca ihyan. Nduco tihca̱ nda̱ se na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ndihche Dihvo vo nduhca̱ che ritahno ihyan chahn, ne ra̱hn ye ri ye sa̱hn che ndi cheche me: ―A nchahcó nunde yehn. ");
INSERT INTO cutNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sa̱hn fariseo chahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, rendedecadino se: “¿Duh sa̱hn tih che redin duche yahn se Dendiohs?, te nde a̱ma ihyan hua co nchahco ye nunde, atena̱n Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ate a devano Dihvo vo che tihca̱ rendedecadino sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―¿Dehco che tihca̱ rendedecadino nchuhn? ");
INSERT INTO cutNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Deh che tahque nda̱hca̱ ca̱hmá: “A nchahcó nunde yehn,” o ca̱hmá: “cuenecuen, cuique”? ");
INSERT INTO cutNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ate ca̱va che cadino nchuhn te u che rinducó nducoya̱ca ihyan ne, va vederihquentiyon yáhn ca̱va che nchahcó nunde yahn ihyan muhn iyehnse cuh ne, condihche ne. Tuhme ra̱hn ye ri ye sa̱hn che ndi cheche me: ―Rihquentiyón di. Cuenecuen, cotah yundo yehn, conahn ndevaque. ");
INSERT INTO cutNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ndeta̱hno necuan se, cheta̱h se yundo yahn se, ne numacuahn vedeyeno rendeva se yavena̱n Dendiohs. Chuh se menda̱hn yahn nducoya̱ca ihyan che chenun ye min, ne cona̱hn se ndeva̱co se. ");
INSERT INTO cutNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rahn ino nducoya̱ca ihyan chahn, ne rendeva ye numacuahn vedeyeno yavena̱n Dendiohs, ne ra̱hn ye: ―Ma̱n che cua̱co ne, ndihchero vo vederihno. ");
INSERT INTO cutNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Cuahn che chica Dihvo vo min ne, ndihchero ye a̱ma sa̱hn rica tume ca̱de iyo che duche se Leví, va se na̱n che rica se tume. Ra̱hn ye ri ye sa̱hn: ―Cuhn vo ndoque, condoque u. ");
INSERT INTO cutNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ndeta̱hno chihcoma̱n se ntiyon yahn se ma̱n, nducuahn che va yahn se ma̱n, ne necuan se, cuahn se, chinduco se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Adive ne, chihquentiyon Leví che chindah comida ndeva̱co se, ne ca̱h se, cheh Dihvo vo nduco a̱ma ya̱hn ihyan, chenun va̱n a̱ma ya̱hn sa̱hn rica tume ca̱de iyo. ");
INSERT INTO cutNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","A̱ma o sa̱hn fariseo nduco sa̱hn devano ley che dirun Moisés ne, chi yudo yahn se, ne tumerune se ihyan apóstol yahn Dihvo vo: ―¿Dehco che tihca̱ redin nchuhn che reh ne, rih ne da̱ma nduco sa̱hn nunde ma̱n, nduco sa̱hn rica tume ca̱de iyo ma̱n ne? ");
INSERT INTO cutNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ndahconan Dihvo vo yahn sa̱hn chahn: ―Ihyan che hua cah ye ne, hua rendotenan ye sa̱hn doctor, ate ihyan che cah ye ne, nahn ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Atihnoca̱ u, te ndá̱ ca̱va ihyan nunde ca̱va che nto ino ye nunde yahn ye, ndiyu ca̱va ihyan che ra̱hco ye che metah nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tuhme tumerune sa̱hn chahn Dihvo vo: ―¿Dehco che sa̱hn che rahn nduco Jua̱n Bautista nduco sa̱hn che rahn nduco sa̱hn fariseo ne, a̱ma rahte se ya̱hte ma̱n, reva̱h se ma̱n, ne sa̱hn che rahn ndoque ne, reh se ma̱n, rih se ma̱n, ro ro ne? ");
INSERT INTO cutNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ndahconan Dihvo vo yahn se: ―A devano nchuhn te ihyan che nduco ye sa̱hn rihneva̱co ne, hua rahte ye ya̱hte. ");
INSERT INTO cutNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ate ndete che cuavi sa̱hn min ne, tuhme che cua̱co ne, cuahte ye ya̱hte. ");
INSERT INTO cutNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Namin nte ye ta̱ma te o ejemplo, chihnevan sa̱hn chahn: ―Nde a̱ma ihyan ne, hua rendeh ye a̱ma tino ra ca̱va che neca̱hnan ye a̱ma tino ndico. Ndete che tihca̱ din ye ne, din ye che conda tino ra me. Ava̱ne ne, a̱ma ndi tino ra na̱n tino ndico ne, chihnga̱ ro, te hua da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Namin nde a̱ma ihyan hua rih ye vino ra chete ima ndico, te redin vino che rendan ima, ne rinda vino ma̱n, ima ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Chemin che nahn che cuih ihyan vino ra chete ima ra, ca̱va che hua dehva co yahn vino ma̱n, ima ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ihyan che rih ye vino ndico ne, hua nahn cuh ye che ra, te ra̱hn ye te tahque ndah rihn vino ndico. ");
INSERT INTO cutNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A̱ma ro che rahte tuhno ihyan ne, chuh Dihvo vo na̱n va chenda̱ta. Ihyan apóstol yahn ye ne, tico ye indo trigo, ne rendihvenun ta̱h ye, reh ye ndute yahn. ");
INSERT INTO cutNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tuhme ra̱hn a̱ma o sa̱hn fariseo ri se ihyan chahn: ―¿Dehco che tihca̱ redin nchuhn?, te a va ca̱de che hua co din vo ntiyon ro che rahte tuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―¿A hua ndihchenan nchuhn che ndirun na̱n Ndudo yahn Dendiohs nduhca̱ che din David ro che chi cuico ye nduco combiero yahn ye? ");
INSERT INTO cutNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","A devano ne nduhca̱ che chenda̱ ye chete ya̱co yahn Dendiohs, ne cheh ye pa̱n che va min, ne ca̱h ye, cheh ihyan che nduco ye. Ate nduco nduh hua quendihco ye nunde, andahre pa̱n chemin chan, a ndi vedino yahn Dendiohs, ne atena̱n chidocuya̱n co cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Quendi Dihvo vo ra̱hn ye nduco sa̱hn chahn: ―U che rinducó nducoya̱ca ihyan ne, rihquentiyón nde nducuahn che redin ihyan ro che rahte tuhno ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ta̱ma ro che rahte tuhno ihyan ne, chenda̱ Dihvo vo chete a̱ma ya̱co, chicuahn ye. Min quenun a̱ma sa̱hn che ndi cuma ta̱h cua̱co se. ");
INSERT INTO cutNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sa̱hn devano ley che dirun Moisés ma̱n, sa̱hn fariseo ma̱n ne, rihno se Dihvo vo ndete che din ye che ndoyahn sa̱hn min ro che rahte tuhno ihyan, ca̱va che cuih nunde se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A devano Dihvo vo che rendedecadino sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn che ndi cuma ta̱h me: ―Cuenecuen, cuandi menda̱hn. Necuan sa̱hn min, chandi se. ");
INSERT INTO cutNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tuhme ra̱hn ye ri ye sa̱hn chahn: ―Ma̱n ne, tumerune nchuhn: ¿Deh din vo ro che rahte tuhno ihyan ne? ¿A din vo che ndah, o din vo che hua ndah ne? ¿A ca̱h yune vo che coh ihyan, o ndedevahn vo ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Chaconan ye, ndihchero ye nducoya̱ca sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn che ndi cuma ta̱h me: ―Cuacondihque tah. Chacondihco ta̱h se, ne ndeta̱hno ndoyahn ta̱h se. ");
INSERT INTO cutNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","A̱ma chi ta̱n sa̱hn chahn, ne rente se va̱n ma̱n se nduco vih deh din se nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ta̱hn min ne, cuahn Dihvo vo a̱ma cuete, ne min cova̱h ye numa ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cuahn che chi dave ne, nedin da̱ma ye ihyan che rinduco ye ihyan, ne tenda̱hnun ye ndichio ihyan chahn ca̱va che co ye apóstol. ");
INSERT INTO cutNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","A̱ma ihyan chahn ne, Simón, ne chaconahn Dihvo vo che duche ye Pedro. Ihyan chena̱hn ne, Andrés, dihno Simón ma̱n, Jacobo ma̱n, Jua̱n ma̱n, Felipe ma̱n, Bartolomé ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo ma̱n, Tomás ma̱n, Jacobo, da̱ya Alfeo ma̱n, Simón Zelote ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, dihno Jacobo ma̱n. Namin nduco a̱ma se Judas Iscariote, sa̱hn min che ndihcue ndeh se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cuenchahn Dihvo vo cuete me, ne ndo ye a̱ma ya ico nduco ihyan chahn. Namin a̱ma ya̱hn ihyan che vate ye esta̱do yahn Judea ma̱n, ya̱n Jerusalén ma̱n, chihto ya̱n Tiro nduco Sidón ma̱n, ndo da̱ma ye min nduco ye. Nda̱ nducoya̱ca ihyan chahn, te nahn cahnevan ye che ricuahn Dihvo vo ma̱n, nahn ye che din Dihvo vo che ndoyahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Namin ndetenda̱h Dihvo vo vaco chihnga̱ che chenun ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ihyan che cah ye ne, nahn nahn ta̱h ye Dihvo vo yahn che quenan cuma ye vederihquentiyon chahte, ne nducoya̱ca ihyan che tihca̱ redin ye ne, ndeta̱hno rendoyahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tuhme ndihchero Dihvo vo Jesucristo ihyan che rinduco ye ihyan, ne ra̱hn ye ri ye ihyan: ―Nchuhn che cheva̱h ne ma̱n, che necun ne ma̱n ne, ndah ro yahn ne, te ndi cuande ne va̱n ihyan yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ndah ro yahn nchuhn che nahn cahnevan ne Ndudo yahn Dendiohs, te din ye conahn ne. ’Ndah ro yahn nchuhn che nda̱che ri ne, te din Dendiohs che co yeno ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ndah ro yahn nchuhn cuahn che ca̱va u che rinducó nducoya̱ca ihyan, co ta̱n ihyan nduco ne ma̱n, hua co ndihche ye nchuhn ma̱n, ca̱hva ye nduco ne ma̱n, ndere ca̱hma ye te duhtuno ihyan ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ro che tihca̱ din ihyan nduco ne ne, nda̱hca̱ che ca̱h yeno ne chedave yahn ne, te cuahn che nda̱ ne vahchetero ne, a va ya̱n che ndah ca̱va ne. Nda̱hca̱ che neca̱hco ne te ihyan ndico yahn ihyan ta̱n chahn ne, a tihca̱ din ye nduco ihyan profeta. ");
INSERT INTO cutNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ate yah rí ca̱va ihyan cuihca, te atena̱n ma̱n ro cuh che vate ye vedeyeno. ");
INSERT INTO cutNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Yah rí ca̱va ihyan che hua rendotenan ye Ndudo yahn Dendiohs che ra̱hco ye, te nda̱ ro che ndotenan ye. ’Yah rí ca̱va ihyan che yeno ye, te nda̱ ro che co ra̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Yah rí ca̱va ihyan che ra̱hn nducoya̱ca ihyan che ndah ihyan ye, te ihyan ndico yahn ihyan chahn tihca̱ ra̱hn ye yahn ihyan che din ca̱ ye che profeta ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Rá̱hn rí nchuhn: codin yahino ne ihyan che hua ri rendihche ye nchuhn. Codin ne che ndah nduco ihyan che ta̱n ye nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ndah ca̱hma ne yahn ihyan che ra̱hva ye nduco ne, cova̱h ne ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ndete che va ihyan che din ta̱n ye nduco ne ne, hua da̱ma co ne nduco ye. Ndete che nahn cahnevi ihyan tino rendiche nchuhn ne, tahque ndah cuahnecun ne che cahnevi ye nde cahteca ne che co che cuhma ne nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Adecoduhno ihyan che ca̱ca ye dehtenduh yahn ne, coca̱h ne, ne ihyan che cahnevi ye deh che va yahn ne ne, hua nda̱ca ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nduhca̱ che nahn nchuhn che ndah din nducoya̱ca ihyan nduco ne ne, tihca̱ codin ne che ndah nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Ndete che din yahino nchuhn dema̱n ihyan che yahino ye nchuhn ne, ¿dehra cochihve yahn ne? Nde ihyan che duhtuno ihyan ye ne, tihca̱ redin ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ndete che dema̱n ihyan che ndah ihyan ye nduco nchuhn, ndah din ne nduco ye ne, ¿dehra cochihve yahn ne? Nde ihyan che duhtuno ihyan ye ne, tihca̱ redin ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ndete che dema̱n ihyan che co nedihve ye yahn nchuhn, ca̱h ne, tumanan ye ne, ¿dehra cochihve yahn ne? Nde ihyan che duhtuno ihyan ye ne, tihca̱ reca̱h ye, retumanan combiero yahn ye che co nedihve ye yahn vih. ");
INSERT INTO cutNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ate nchuhn ne, codin yahino ne nde ihyan che hua ri rendihche ye nchuhn. Codin ne che ndah. Coca̱h nchuhn, tumanan ihyan, nde hua cuahtenan rino ne che nevihve yahn ne. Ndete che tihca̱ din nchuhn ne, Dendiohs, ihyan min che a̱ma yudo vederihquentiyon yahn ye ne, nda̱hco menun ndahva ye yahn ne, nedin da̱ya ye nchuhn, te ihyan min ne, ndah ye nde nduco ihyan che duhtuno ihyan ye ma̱n, ihyan che nde hua reneca̱h ye nundihve cuahn ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nduhca̱ che renan va̱hino Chida nchuhn nducoya̱ca ihyan ne, tihca̱ codin ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Hua nda̱hchenan nchuhn ihyan, ne hua conan cuma che techeca̱de Dendiohs yahn ne yahn nunde min, din ye castigo nchuhn. Cuenchahco ne yahn ihyan, ne nchahco Dendiohs yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Codin nchuhn che ndah nduco ihyan, ne din Dendiohs che ndah nduco ne, nde tihdena̱n ca ye nda̱hco menun ye yahn ne. Tihca̱, te nduhca̱ che redin ne nduco ihyan ne, atihnoca̱ nda̱hco menun Dendiohs yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tuhme nte Dihvo vo ejemplo cuh, chihnevan ihyan chahn: ―A devano nchuhn te a̱ma sa̱hn na̱n ve hua co quendanan se ta̱ma sa̱hn na̱n ve, te coranun nduh che o se ive ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tahque devano ihyan ricuahn che co a̱ma sa̱hn che rahn. Ate cuihno cuahn sa̱hn min ne, anduhneva che devano ihyan ricuahn yahn se ne, tihca̱ codevano se. Hua chuhnan vededevano yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Ndete che rihco nchuhn cuda̱do nunde yahn ta̱ma ca ihyan, ne hua retumaca̱h ne nunde yahn ma̱n ne ne, anduhneca̱ ndete che ndihchero ne a̱ma iya̱ca che quenun ndutena̱n ye, ate nde hua retumacadino ne che quenun a̱ma vihto ndutena̱n ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndete che tihca̱ ne, o na̱n o chende ne. Nde hua quena̱n yahn ne che ca̱hma ne co ne ihyan: “Conán di ca̱va che hua condihque nunde”, te nde hua retumacadino ne che tahque chihnga̱ redin ma̱n ne. Tahque ndah che dinoca ca̱hcoma̱n ne che chihnga̱ redin ne, tuhme co conan ne ihyan ca̱va che runeca̱de cochica ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ya̱hn nda̱ta che ndah ne, ndah ndute yahn, ne ya̱hn nda̱ta che hua ndah ne, hua ndah ndute yahn. ");
INSERT INTO cutNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A̱ma ya̱hn nda̱ta ne, ro deh ya̱hn cuahn che ri ndute yahn. Ndute higo ne, hua retun ihyan tin ya̱hn ya̱n, nde hua retun ye uva na̱n dihyo ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ihyan che ndah ye ne, redin ye dehtenduh che ndah, te ndah chedave yahn ye, ne ihyan che hua ndah ye ne, redin ye dehtenduh che hua ndah, te hua ndah chedave yahn ye. Na̱n ndudo yahn ihyan ne, rihcoro nduhca̱ ihyan ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Dehco che ra̱hn nchuhn ri ne u: “Dihve nuhn, Dihve nuhn ne”?, te hua redinahn ne che rihquentiyón. ");
INSERT INTO cutNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Adecoduhno ihyan che renda̱ ye ná̱n ma̱n, che rihnevan ye che rá̱hn ma̱n, che redinahn ye che rihquentiyón ma̱n ne, ca̱hmá có nchuhn duh nduhca̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ihyan min ne, nduhca̱ ihyan che chihno ye va̱co ye, ne ya̱no chino ye nde na̱n ya̱va, ne min chihco ye name yahn. Cuahn che chihta ico ne, a̱ma dito chahn nune na̱n vah me. Ate hua chi quenda nune vah me, te na̱n ya̱va va name yahn. ");
INSERT INTO cutNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Me ihyan che rihnevan ye ndudo yáhn, ne hua redinahn ye ne, ihyan min ne, nduhca̱ ta̱ma ihyan che chihno ye va̱co ye, nde hua chihco ye name yahn. Cuahn che chihta ico ne, a̱ma dito chahn nune na̱n vah me. Ndora vah me, ne chihno chinda. ");
INSERT INTO cutNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cuahn che chihno chicuahn Dihvo vo ihyan chahn ne, cuahn ye ya̱n Capernaum. ");
INSERT INTO cutNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","A̱ma capitá̱n che va ye ya̱n min ne, va sa̱hn deca̱hya yahn ye che a̱ma yahino ye sa̱hn, ne cheta̱h cah sa̱hn. A̱ma tahn ndi se, adeche coh se. ");
INSERT INTO cutNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Cuahn che checadino capitá̱n me yahn Dihvo vo che redin ye vederihno ne, dechuh ye a̱ma o ihyan ndina̱n yahn ihyan nación yahn Israel, ca̱va che ca̱ca ye favor ihyan che ca̱hn ye, ne din ye che ndoyahn sa̱hn deca̱hya me. ");
INSERT INTO cutNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Chahn ihyan chahn na̱n Dihvo vo, ne a̱ma chica ye favor ihyan, ne ra̱hn ye: ―Capitá̱n ca̱h ne, nda̱hca̱ che conan ne ihyan, ");
INSERT INTO cutNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","te yahino ye nación yuhn vo, ne chihno ye a̱ma ya̱co yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tuhme cuahn Dihvo vo nduco ihyan chahn. Cuahn che a nda̱ nino ye ne, dechuh capitá̱n me ndudo nduco a̱ma o amigo yahn ye, ra̱hn ye tuhca̱: ―Dihvé, hua denduh ne ndih ca̱va no u, che chi ne nde chete va̱có. ");
INSERT INTO cutNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A devanó te u ne, ndiyu ihyan che co chí na̱n ne. Nde na̱n che cochi ne, cuihquentiyon ne, ne ndoyahn sa̱hn deca̱hya yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Che ca̱hcantiyon ne ne, a devanó te va che conahn, te namin u ne, va ihyan che te ye vederihquentiyon quenan cumá, ne vate sanda̱do yáhn. Rihquentiyón a̱ma se che ca̱hn se, ne rahn se, ne rihquentiyón ta̱ma se che chi se, ne rechi se, ne nducuahn che rihquentiyón sa̱hn deca̱hya yáhn ne, redinahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yahn che tihca̱ ra̱hn capitá̱n me ne, cuahn ino Dihvo vo, ne chaconan ye, ndihchero ye ihyan che nduco ye, ne ra̱hn ye: ―Cua̱co rá̱hn rí nchuhn te nde numachahte nación yuhn vo ne, hua renda̱cá ihyan che tihca̱ a̱ma ritahno ye. ");
INSERT INTO cutNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Cuahn che ndaconan ihyan che chahn ye ntiyon yahn capitá̱n me ne, nta̱ca ye sa̱hn che adeche coh me che a ntoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chihno min ne, Dihvo vo nduco ihyan apóstol yahn ye ma̱n, a̱ma ya̱hn ca ihyan ma̱n, cuahn ye a̱ma ya̱n che duche Naín. ");
INSERT INTO cutNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cuahn che nda̱ ye viya̱n me ne, ta̱hn nun ye ihyan che cuahn ye cuhche ye a̱ma tena̱hn da̱ya a̱ma nda̱hta va̱h. A̱ma ndiya̱hn ra sa̱hn dihn min yahn nda̱hta va̱h me, ne a̱ma ya̱hn ihyan nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cuahn che ndihche Dihvo vo nda̱hta va̱h me ne, quenan va̱hino ye ta̱hn, ne ra̱hn ye ri ye ta̱hn: ―Hua cueque. ");
INSERT INTO cutNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tuhme chahn nda̱ ye, ne ca̱h ta̱h ye yave yahn tena̱hn me, ne sa̱hn che nda se yave me ne, chahtendi rino se. Ra̱hn ye ri ye tena̱hn me: ―¡Cuenecuen! ");
INSERT INTO cutNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ndeta̱hno necuan sa̱hn dihn che a ndih me, ne cana̱n rente se. Tuhme neca̱h Dihvo vo sa̱hn chaco se. ");
INSERT INTO cutNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A̱ma cuahn ino nducoya̱ca ihyan, ne rendeva ye numacuahn vedeyeno yavena̱n Dendiohs, ne ra̱hn ye: ―Nda̱ a̱ma profeta va̱n uvo, ihyan yahn Dendiohs. ¡A̱ma chahte vederihquentiyon quenan cuma ye! Dechuh Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A̱ma chetuhn ndudo yahn vederihno che din Dihvo vo numachahte esta̱do yahn Judea ma̱n, nduh cua̱n na̱n che nino min ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ihyan che rinduco ye Jua̱n Bautista ne, ra̱hn ye ri ye ihyan yahn nducua̱hn vederihno che redin Dihvo vo. Tuhme cah Jua̱n o ihyan chahn, ");
INSERT INTO cutNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ne dechuh ye ihyan ca̱va che tumerune ye Dihvo vo, a ihyan min niyon ihyan che a va ca̱de che dechuh Dendiohs ihyan, ndedevahn ye ihyan iyehnse, o cuahtenan rino ye ta̱ma ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nda̱ ihyan chahn na̱n Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Jua̱n Bautista ne, dechuh ye nuhn, tumerune nuhn ndih: ¿A ndih ihyan che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse, o cuahtenan rino nuhn ta̱ma ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ura min din Dihvo vo che ndoyahn a̱ma ya̱hn ihyan cah ma̱n, din ye che chi ro na̱n ihyan che ve na̱n ye ma̱n, ndetenda̱h ye vaco chihnga̱ che chenun ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tuhme ndahconan ye yahn ihyan chahn che dechuh Jua̱n: ―Cona̱hn nchuhn, cueneca̱h cuande ne Jua̱n yahn nducuahn che ndihchero ne ma̱n, che chihnevan ne ma̱n. Ihyan che ve na̱n ye ne, redín che ri ro na̱n ye. Ihyan che ndi cheche ca̱h ye ne, redín che rica ye. Ihyan che ndi ye cah che recha̱ yute ne, redín che rendoyahn ye. Ihyan che a ndih ye ne, rendedetuhché ihyan. Ihyan che necun ye ne, ricuáhn ndudo ndah yahn Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ndah ro yahn ihyan che ritahno ye che dechuh Dendiohs u. ");
INSERT INTO cutNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Cuahn che cona̱hn ihyan chahn ne, rente Dihvo vo nduco ihyan che chenun ye min yahn Jua̱n, ne ra̱hn ye: ―¿Deh che chahn nchuhn, ndihchero ne min ya̱hn na̱n che metah duhva? ¿A a̱ma nduco che ra yuhne? ");
INSERT INTO cutNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Duh che chahn nchuhn, ndihchero ne tuhme? ¿A a̱ma sa̱hn che ninevaca se nduco tino ndah? A devano nchuhn te sa̱hn che renevaca se nduco tino ndah ma̱n, rahte se vihco ma̱n ne, sa̱hn chahn ne, chete va̱co rey chenun se. ");
INSERT INTO cutNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tuhme ne, ¿duhra che chahn nchuhn, ndihchero ne? ¿A ndiyu a̱ma profeta? Cua̱co niyon, te ihyan min ne, tahque chahte vederihquentiyon che quenan cuma ye che co ihyan profeta chena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","A yahn ihyan min che a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: Condihche, dechúh a̱ma sa̱hn tahque mena̱n ca che co di, cuahndudo se ndudo yáhn. Ca̱hcoya̱n se chedave yahn ihyan, ca̱va che nevahnecun ye di. ");
INSERT INTO cutNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Rá̱hn rí nchuhn te va̱n nducoya̱ca ihyan iyehnse ne, Jua̱n Bautista che tahque chahte vederihquentiyon che quenan cuma ye. Ate ihyan che tahque necun ye va̱n ihyan che rihquentiyon Dendiohs ne, tahque ndah ro yahn ye che co ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cuahn che tihca̱ ra̱hn Dihvo vo ne, a̱ma ya̱hn ihyan ya̱n, nde sa̱hn rica tumeca̱diyo, ndeva ye yavena̱n Dendiohs, te chahn ye, chehdenune Jua̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ate sa̱hn fariseo nduco sa̱hn devano ley che dirun Moisés ne, chahcota̱hn se che rihquentiyon Dendiohs, te hua chahn se che chehdenune Jua̱n sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tuhme ra̱hn Dihvo vo: ―¿Deh ca̱hmá yahn nchuhn che vate ne ma̱n ro cuh ne? ");
INSERT INTO cutNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nchuhn che vate ne ma̱n ro cuh ne, nduhchan sa̱hn ca̱hya che ra̱hn se ri se combiero yahn se: “Tive nuhn cu retive, ne hua ndeh nchuhn. Cah ra̱n nuhn nduhca̱ che rah ra̱n ihyan na̱n ndih tena̱hn, ne hua chaco nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tihchan nchuhn, te nda̱ Jua̱n Bautista, ne hua cheh ye pa̱n, nde hua chih ye vino, ne ra̱hn ne te quenun vaco chihnga̱ ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nda̱ u che rinducó nducoya̱ca ihyan, ne réh ma̱n, ríh ma̱n, ne ra̱hn nchuhn: “Nga̱ a̱ma se, ne a̱ma reh se ma̱n, a̱ma rih se vino ma̱n, rinduco se ihyan nunde ma̱n, sa̱hn rica tumeca̱diyo ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ate dehve din yahn che tihca̱ ra̱hn nchuhn, te nducoya̱ca ihyan devano, renahn ye te vededevano yahn Dendiohs ne, chemin che richihve. ");
INSERT INTO cutNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A̱ma sa̱hn fariseo ne, ya̱hve se Dihvo vo che cheh ye nduco se, ne cuahn ye ndeva̱co se. ");
INSERT INTO cutNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A̱ma ta̱hn nunde che va te ya̱n min ne, checadino te che min chete va̱co sa̱hn fariseo me va Dihvo vo, reh ye. Tuhme nda̱ te, nda te a̱ma fra̱sco nuneda̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chahn nda̱ te, ne chehntihya te na̱n Dihvo vo. A̱ma raco te, ne cana̱n te redeca̱hnda te ca̱h ye nduco nune ndutena̱n te. Rendedetih te nduco yudo tin te. Retena̱n te ca̱h ye, ne chacota̱hma te nuneda̱n me. ");
INSERT INTO cutNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ndihche sa̱hn fariseo me, ne ndedecadino se: “Ta̱hn tih ne, chihnga̱ ihyan te. Ndete che cua̱co che profeta ihyan tih ne, cadino ye duh ihyan te.” ");
INSERT INTO cutNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tuhme ra̱hn Dihvo vo ri ye sa̱hn fariseo me: ―Simón, nté a̱ma ejemplo, cahneven. Ndahconan Simón: ―Ihyan Ricuahn, cuente ne, cahneván. ");
INSERT INTO cutNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ra̱hn ye: ―O se ne, quendihco se yahn a̱ma ihyan. A̱ma se ne, quendihco se uhn ciento, ne ta̱ma se ne, quendihco se o raco ndiche. ");
INSERT INTO cutNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nducote metah dehva yahn sa̱hn chahn ne, hua chi nedihve se yahn ye. Ate nchahco ye yahn nduh che o se. Ma̱n ne, cahme co u: ¿Cha sa̱hn chahn che tahque yahino se ihyan min ne? ");
INSERT INTO cutNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ndahconan Simón: ―Ra̱hcó te sa̱hn che tahque ndeh quendihco se yahn ye. Ra̱hn Dihvo vo ri ye Simón: ―Nda̱hca̱ rahn. ");
INSERT INTO cutNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chaconan ye, ndihchero ye nda̱hta me, ne tuhme ra̱hn ye ri ye Simón: ―¿A chihque cuda̱do nduhca̱ che din nda̱hta tih ne? Chendá̱ chete vaque, ne hua te nune ca̱va che ntu cá̱h, ate nda̱hta tih ne, deca̱hnda te cá̱h nduco nune ndutena̱n te, ne ndedetih te nduco yudo tin te. ");
INSERT INTO cutNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Di ne, hua tenan u che nevahnecon u, ate nda̱hta tih ne, nde ura che ndá̱ ndevaque, nde meniyon ne, hua reguan te retena̱n te cá̱h. ");
INSERT INTO cutNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hua chih aceite tín, ate nda̱hta tih ne, chacota̱hma te nuneda̱n cá̱h. ");
INSERT INTO cutNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Chemin che rá̱hn rí di te nducote a̱ma va vedeyahino yahn te ne, codevene te va vederenchahco ca̱va te, andahre a̱ma quendihco te nunde. Ate ihyan che nda̱ca ye vederenchahco yahn tah sihn che quendihco ye ne, hua chahte vedeyahino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tuhme ra̱hn Dihvo vo ri ye nda̱hta me: ―A nchahcó nunde yehn. ");
INSERT INTO cutNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nducoya̱ca ihyan che vate ye min, reh ye nduco Dihvo vo ne, ndedecadino ye: “¿Duhra sa̱hn tih che ra̱hco se che renchahco se nunde yahn ihyan?” ");
INSERT INTO cutNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ate ra̱hn Dihvo vo ri ye nda̱hta me: ―Yahn che chitehne ne, ndaque vederenchahco. Conahn. Dehve rahque. ");
INSERT INTO cutNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chihno min ne, quechica Dihvo vo nduh ya̱n nduh ya̱n, ricuahn ye ndudo ndah yahn vederihquentiyon yahn Dendiohs. Nduco ye nduh che ndichio apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Namin nduco ye ya̱hn ihyan nda̱hta che ndetenda̱h ye vaco chihnga̱ che chenun ihyan ma̱n, ihyan nda̱hta che din ye che ndoyahn ye ma̱n. Va̱n nda̱hta chahn nduco María yahn ya̱n Magdala, ihyan min che chenun ndache vaco chihnga̱ ro mena̱n, ndetenda̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Namin nduco Jua̱na, nda̱hta yahn Chuza, a̱ma sa̱hn ndina̱n yahn rey Herodes. Nduco Susa̱na ma̱n, nduco ya̱hn ca nda̱hta che chinan ye Dihvo vo nduco tume yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","A̱ma ya̱hn ihyan yahn queri a̱ma ya̱n, ndo da̱ma ye na̱n Dihvo vo, ne nte ye ejemplo cuh, chihnevan ihyan chahn: ");
INSERT INTO cutNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Cuahn a̱ma ihyan, retuhdo ye ndute nda̱ta yahn ye. Cuahn che retuhdo ye ne, chera neve ndute chihto yune. Chemin ne, chendinun ihyan, ne nda̱ ya̱hda, ne cheh te. ");
INSERT INTO cutNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Te neve ndute ne, chera na̱n tu. Cuahn che quenda̱h ne, tih yahn che ndo cuma ya̱hn na̱n tu me. ");
INSERT INTO cutNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Te neve ndute ne, chera va̱n chano ya̱n. Chihta da̱ma nduco chano ya̱n chahn, ne quenun ma̱n chenda̱ta me. ");
INSERT INTO cutNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Te neve ndute ne, chera na̱n ya̱hn ndah, ne quenda̱h, ne chi yahn, ca̱de ciento queri a̱ma. Chihno nte ye ejemplo me ne, tuhme a̱ma dito ra̱hn ye: ―Nducoya̱ca nchuhn, ¡cuendedecadino ndah ne yahn ejemplo me! ");
INSERT INTO cutNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tuhme tumerune ihyan apóstol chahn ihyan: ―¿Deh conahn ejemplo che nte ne me ne? ");
INSERT INTO cutNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ra̱hn ye ri ye ihyan chahn: ―Nchuhn ne, te Dendiohs che conahn ne yahn vederihquentiyon yahn ye. Ate ihyan chena̱hn sih ne, renté nduco ye dema̱n nduco ejemplo, ca̱va che ndihchero no ye, ne hua nchana̱n ye, cahnevan no ye, ne hua conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Tuhca̱ conahn ejemplo me: Ndute nda̱ta me ne, nduhca̱ Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ndute che chera chihto yune me ne, nduhca̱ ndudo che rihnevan a̱ma o ihyan, ne ndeta̱hno renda̱ chundah, ne rehnevi se Ndudo me chete chedave yahn ye, ca̱va che hua cotahno ye, ne hua ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndute che chera na̱n tu me ne, nduhca̱ Ndudo che rihnevan ta̱ma te o ihyan, ne renevahnecun ye numacuahn vedeyeno. Ate nduhca̱ chenda̱ta che metah cua ya̱no dihyoduto tihchan ye, te cuahn che rechuhrihn ye, o redin ta̱n ihyan nduco ye ca̱va Ndudo me ne, ndeta̱hno rihcoma̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndute che chera va̱n chano ya̱n me ne, nduhca̱ Ndudo che rihnevan ta̱ma te o ihyan, ate a̱ma rendedecadino ye yahn ntiyon yahn ye ro ro ma̱n, nahn yahn ye vedecuihca che va iyehnse cuh ma̱n, nahn quendi ye vedeyeno yahn ma̱n ye ma̱n. Chemin che hua ri redin Ndudo me che ndah nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ate ndute che chera na̱n ya̱hn ndah me ne, nduhca̱ Ndudo che rihnevan ta̱ma te o ihyan, ne renevahnecun ye numacuahn chedave yahn ye, ne riquendi ye. Ihyan chahn che redin Ndudo yahn Dendiohs che ndah nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Quendi Dihvo vo ricuahn ye: ―Nde a̱ma ihyan ne, hua renahn ya̱hn ye a̱ma candil ca̱va che ca̱hco ndeh ye ma̱n cajún, o ma̱n yundo. Rihco ye na̱n che ya̱co, ca̱va che co ro dave yahn ihyan che renda̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tihca̱ nducuahn che rá̱hn rí nchuhn cuahn che a dema̱n vo ne, va che cuahndudo nchuhn, cahnevan ihyan. Nducuahn che rá̱hn, andahre a̱ma rihn ca̱va che conahn ihyan, ate conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Chemin che cuihnevan ndah nchuhn ndudo che rá̱hn, te ihyan che ndah renahn ye ne, nde tahque ndah ca conahn ye, ne ihyan che hua ndah renahn ye ne, va che cona̱n ye nde tah sihn che chenahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nda̱ chaco Dihvo vo nduco dihno ye, ne hua chi chenda̱ ihyan chahn na̱n che quenun ye, te a̱ma ya̱hn ihyan chenun ye min. ");
INSERT INTO cutNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tuhme ra̱hn ihyan ri ye Dihvo vo: ―Chaco ne nduco dihno ne, vatendi ye cua̱hn chevah, nahn ndihchero ye ndih. ");
INSERT INTO cutNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ra̱hn ye ri ye ihyan chahn: ―Ihyan che rihnevan ye Ndudo yahn Dendiohs, ne redinahn ye ne, a ihyan chahn che rendihché ihyan nduhca̱ chacó ma̱n, nduhca̱ dihnó ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","A̱ma yune ne, chenda̱ Dihvo vo chete a̱ma ba̱rco nduco ihyan apóstol yahn ye, ne ra̱hn ye: ―Cuhn vo nduco nchuhn ta̱ma la̱do viche ca̱h. Tuhme cuahn ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ura che cuahn ye nduco vih ne, quiya̱do Dihvo vo, ne cana̱n rano yuhne ta̱n, nde a rito nune chete ba̱rco me, adeche cuehchenun chete vine me. ");
INSERT INTO cutNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Chahn ihyan chahn, ndedetuhche ye Dihvo vo, ne ra̱hn ye: ―¡Ihyan Ricuahn! ¡Ihyan Ricuahn! ¡Cuentuche ne, te adeche cuehchenun vo va̱n nune! Necuan Dihvo vo, ne chihco dihn ye yuhne ta̱n me, ne quendite dihn vine me. ");
INSERT INTO cutNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tuhme tumerune ye ihyan chahn: ―¿A hua ritahno nchuhn? Ate ihyan chahn ne, a̱ma rahn ino ye, a̱ma redihya ye ri, ne retumarune vih ye: ―¿Duhra ihyan cuh?, te nde yuhne, nde vine, redinahn che rihquentiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chihno min ne, nda̱ ihyan chahn ya̱n Gadara, a̱ma ya̱n che va ta̱ma la̱do viche yahn vine yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ndeta̱hn che ndiquenda̱h Dihvo vo chete ba̱rco me ne, nda̱ a̱ma sa̱hn ya̱n min na̱n ye. Sa̱hn min ne, a ra̱hn cuahn che chenun vaco chihnga̱ sa̱hn. Deva̱ne se, quechica se, nde hua quenun se va̱co se, te na̱n rehche tena̱hn ne, min quenan se. ");
INSERT INTO cutNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Cuahn che ndihchero se Dihvo vo ne, chahn nda̱ se, chehntihya se na̱n ye, ne cah se: ―Jesús, Da̱ya Dendiohs che a̱ma yudo vederihquentiyon yahn ye, ¿dehco che reca̱hdenun ne yune yáhn? Ricá favor ndih che hua din ne che chuhríhn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tihca̱ ra̱hn se, te Dihvo vo ne, a chihquentiyon ye vaco chihnga̱ chahn che ndiquenda̱h sa̱hn. A̱ma ndeh yune cuahn che retumanga̱n vaco chihnga̱ chahn sa̱hn ne, redechiche ihyan sa̱hn nduco cadena, ate rihno rendeh se cadena me, ne riquenda vaco chihnga̱ chahn sa̱hn va̱n chano. ");
INSERT INTO cutNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dihvo vo ne, tumerune ye sa̱hn: ―¿Deh doche ne? Ndahconan se: ―Legión duché. Tihca̱ duche se yahn che a̱ma ya̱hn vaco chihnga̱ chenun sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","A̱ma chica vaco chihnga̱ chahn favor ihyan che hua dechuh ye va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Min nino va̱n chano ne, chenan a̱ma ya̱hn cuche, reh te. A̱ma chica vaco chihnga̱ chahn che ca̱h yune ye che conda̱ chete cuche chahn, ne ca̱h yune ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tuhme ndiquenda̱h vaco chihnga̱ chahn sa̱hn min, ne chenda̱ cuche chahn. Cuche chahn ne, cochahn te, rano te na̱n ndava, ne cheranun te chete vine me, cuahn ico te. ");
INSERT INTO cutNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuahn che ndihchero sa̱hn che redin cuda̱do cuche chahn che tihca̱ chi ne, chano se. Cuahn se, chengo se ihyan viya̱n ma̱n, ihyan ra̱ncho ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tuhme cuahn ihyan viya̱n ndihchero ye deh che chi. Cuahn che nda̱ ihyan chahn na̱n che quenun Dihvo vo ne, ndihchero ye sa̱hn min che a ntiquenda̱h vaco chahn sa̱hn. Va se chihto na̱n Dihvo vo, quenun se tino yahn se. A va cua̱co dave yahn se, ne dihya ihyan chahn chi. ");
INSERT INTO cutNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tuhme ihyan che ndihchero ye ne, rente ye nduco ihyan che nda̱ chahn ta̱ca̱ chi che ndiquenda̱h vaco chihnga̱ chahn sa̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nducoya̱ca ihyan che vate ye ya̱hn yahn ya̱n Gadara, a̱ma dihya ye chi. Chemin che ra̱hn ye ri ye Dihvo vo che nda̱ca ye ya̱n min. Tuhme chenda̱ Dihvo vo chete ba̱rco, cona̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sa̱hn che a ntiquenda̱h vaco chahn sa̱hn ne, a̱ma rica se Dihvo vo che ca̱h yune ye che conduco se ihyan. Ate hua ca̱h yune ye, ne ra̱hn ye ri ye sa̱hn: ");
INSERT INTO cutNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Conahn cua̱hn ndevaque, ne cuente yahn vederihno chahte che din Dendiohs ndoque. Tuhme cona̱hn se, ne chacotuhn se ndudo numacuahn viya̱n me yahn vederihno chahte che din Dihvo vo nduco se. ");
INSERT INTO cutNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cuahn che ndaconan Dihvo vo viche la̱do cuh yahn vine me ne, a̱ma ya̱hn ihyan nevahnecun ye ihyan numacuahn vedeyeno, te nducoya̱ca ye ne, chenan rino ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ura min nda̱ a̱ma sa̱hn ndina̱n yahn ya̱co, duche se Jairo, ne chehntihya se na̱n Dihvo vo, chica se favor ihyan, ca̱va che ca̱hn ye va̱co se, ");
INSERT INTO cutNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","te va a̱ma ndiya̱hn ra ta̱hn dihn yahn se, a ri te tenduh ndichio nduyo. Cheta̱h cah ta̱hn, adeche coh te. Tuhme cuahn Dihvo vo, ne nde hua ri che ca̱ca ye, te a̱ma ya̱hn ihyan nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Min va̱n ihyan chahn, nduco a̱ma nda̱hta che cah te, rendora te yun ro ro. A ri ndichio nduyo che quenan cah me ta̱hn, ne a chihno nducuahn yahn te che va che renedihve te sa̱hn doctor. Ate nde a̱ma se hua chi dico se ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Chahn nda̱ te cua̱hn veda̱me Dihvo vo, nahn ta̱h te tino yahn ye, ne ndeta̱hno cheguan rahn yun me ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tuhme tumerune Dihvo vo: ―¿Duh nahn ta̱h tino yáhn ne? Nducoya̱ca ye ra̱hn ye te ndiyu ihyan chahn. Pedro nduco combiero yahn ye ne, ra̱hn ye: ―Ihyan Ricuahn, a̱ma ya̱hn ihyan chenun chiche ye chihto na̱n ne, ¿dehco che retumerune ne duh nahn ta̱h tino yahn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ate ra̱hn Dihvo vo: ―Va duh che nahn ta̱h tino yáhn, te checadinó che ndoyahn a̱ma ihyan nduco vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ndihche nda̱hta me che a checadino Dihvo vo, ne chahn nda̱ te, chehntihya te na̱n ye, nde tuno rendoh te. Tuhme neca̱h cuande te ihyan na̱n nducoya̱ca ihyan ya̱n deh cuande che nahn ta̱h te tino yahn ye ma̱n, nduhca̱ che ndeta̱hno ndoyahn te ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ra̱hn Dihvo vo ri ye ta̱hn: ―Da̱yá, yahn che chitehne ne, a ndoyehn. Dehve rahque. Co conahn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nde metah cuihno ca̱hma Dihvo vo cuahn che nda̱ a̱ma ihyan ndeva̱co Jairo, ne ra̱hn ye: ―A chih ta̱hn dihn da̱ya ne. Ametah deh cuande che quenda ne Ihyan Ricuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Chihnevan Dihvo vo, ne ra̱hn ye ri ye Jairo: ―Hua co ran. Cuitehne che co conán di, ne ta̱hn dihn daye ne, ndaconan conan te. ");
INSERT INTO cutNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Cuahn che nda̱ ye ndeva̱co se ne, hua ca̱h yune ye che chenda̱ nducoya̱ca ihyan nduco ye, dema̱n Pedro ma̱n, Jacobo ma̱n, Jua̱n ma̱n, nduco chida ta̱hn dihn me ma̱n, nduco chaco te ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Rah ra̱n nducoya̱ca ihyan ma̱n, raco ye ma̱n, ca̱va ta̱hn dihn me. Ate ra̱hn Dihvo vo: ―Hua cuaco nchuhn, te ta̱hn dihn tih ne, dehve ndih te, te quiya̱do te. ");
INSERT INTO cutNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ate riyon nan ihyan chahn ihyan, te a devano ye te ta̱hn dihn me ne, a ndih te. ");
INSERT INTO cutNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tuhme cheta̱h Dihvo vo ta̱h te, ne a̱ma dito ra̱hn ye: ―Ta̱hn dihn, ¡cuenecuen! ");
INSERT INTO cutNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nta̱ vaco ta̱hn dihn me, ne ndeta̱hno necuan te. Chihquentiyon Dihvo vo che ca̱h ihyan chahn, cheh te. ");
INSERT INTO cutNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chida te nduco chaco te ne, a̱ma cuahn ino ye. Ate chihquentiyon Dihvo vo ihyan chahn che hua ca̱hma ye nduco nde a̱ma ihyan, che ndedetuhche ye ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","A̱ma yune ne, din da̱ma Dihvo vo nduh che ndichio ihyan apóstol yahn ye, ne ca̱h ye vederihquentiyon ihyan chahn ca̱va che ndetenda̱h ye vaco chihnga̱ ma̱n, din ye che ndoyahn ihyan cah ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Dechuh ye ihyan chahn che ca̱hn ye cuahndudo ye ndudo ndah yahn vederihquentiyon yahn Dendiohs ma̱n, din ye che ndoyahn ihyan cah ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chihquentiyon ye ihyan chahn: ―Hua dehva quenda nchuhn cua̱hn yune. Nde inda̱hco, nde dino, nde pa̱n, nde tume, hua quenda ne. A cahteca no ne che chenun ne; hua quenda ne ta̱ma. ");
INSERT INTO cutNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Adecotino va̱co ihyan che conda̱ nchuhn ne, min cuahtenan ne nde tuno ro che nda̱ca ne ya̱n min. ");
INSERT INTO cutNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na̱n che hua ntumanecun ihyan nchuhn ne, cuendiquenda̱h ne ya̱n min, ne conda̱hde ne yune ya̱hn che chenan ca̱h ne, ca̱va che cadino ihyan chahn te hua nda̱hca̱ din ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tuhme cuahn ihyan chahn nducuahn ya̱n, rahndudo ye ndudo ndah yahn Dendiohs ma̱n, redin ye che rendoyahn ihyan cah ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Checadino rey Herodes yahn vederihno che redin Dihvo vo, ate hua devano ye duh ihyan min yahn che na̱hn ihyan ne, ra̱hn ye te Jua̱n Bautista ntuche ye va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Te na̱hn ihyan ne, ra̱hn ye te profeta Elías nuhnde ro ye. Na̱hn tun ihyan ne, ra̱hn ye te a̱ma cha ihyan profeta che chahte ye a ra̱hn me, ntuche ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tuhme ra̱hn Herodes: ―Jua̱n ne, u dechúh che chica ya̱n sanda̱do da̱ndo ye. ¿Duhra ihyan ca̱h che rihneván che rente ihyan yahn ye tuhme ne? Chemin che nahn ndihchero ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cuahn che ndaconan ihyan apóstol chahn ne, neca̱h cuande ye Dihvo vo yahn nducuahn che din ye na̱n che chahtechica ye. Tuhme quenda Dihvo vo ihyan chahn a̱ma cua̱n na̱n che metah duhva nino ya̱n Betsaida. ");
INSERT INTO cutNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ate checadino ihyan ya̱n, ne a̱ma ya̱hn ye cuahn ye quendi ye Dihvo vo. Cuahn che nda ye na̱n che quenun Dihvo vo ne, chicuahn Dihvo vo ihyan chahn yahn vederihquentiyon yahn Dendiohs, ne din ye che ndoyahn ihyan che cah ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cuahn che a chi chino ne, ndo da̱ma nduh che ndichio apóstol chahn na̱n Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Cuedechuh ne ihyan sih ya̱n che nino ma̱n, na̱n ra̱ncho ma̱n, ca̱va che cua ye che cheh ye ma̱n, nda̱ca na̱n che cuahtenan ye ma̱n, te muhn na̱n che chenan vo ne, metah dehva. ");
INSERT INTO cutNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Ca̱h nchuhn, cheh ihyan sih. Ra̱hn ihyan chahn ri ye Dihvo vo: ―Uhn ra pa̱n nduco o ya̱hca va yahn nuhn, atena̱n che ca̱hn nuhn, cua nuhn che cheh nducoya̱ca ihyan sih. ");
INSERT INTO cutNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ihyan chahn ne, ri ye tenduh uhn mil che dema̱n ihyan cha̱hn. Tuhme ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―Cuihquentiyon nchuhn che co da̱ma ihyan sih, cuahte ye ca̱de o raco ndiche ye queri a̱ma cua̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tihca̱ din ihyan chahn, ne chahte nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tuhme cheta̱h Dihvo vo nduh che uhn pa̱n me nduco o ya̱hca chahn, ne chenihyon na̱n ye na̱n ro, neca̱h ye nundihve cuahn Dendiohs. Ndeh ye, ne ca̱h ye ihyan apóstol ca̱va che ca̱h ye, cheh ihyan che ndi da̱ma chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Cheh nducoya̱ca ihyan chahn nduhva che rica chedave yahn ye. Chihno min ne, nedin da̱ma ye che nga̱va, ne chi ndichio cuahte. ");
INSERT INTO cutNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A̱ma ro ne, quenan Dihvo vo nduco ihyan apóstol yahn ye, ne ma̱n ye reva̱h ye a̱ma la̱do. Chihno min ne, tumerune ye ihyan chahn: ―¿Duh u, ra̱hn ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ndahconan ihyan chahn: ―Na̱hn ihyan ne, ra̱hn ye te ndih ne, Jua̱n Bautista. Na̱hn ye ne, ra̱hn ye te ndih ne, Elías. Na̱hn tun ye ne, ra̱hn ye te ndih ne, a̱ma cha ihyan profeta che chahte ye a ra̱hn me, ntuche ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tuhme tumerune Dihvo vo ihyan chahn: ―Me nchuhn, ¿deh ra̱hn ne yáhn ne? Ndahconan Pedro: ―A ndih che a va ca̱de che dechuh Dendiohs, ndedevahn ne ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tuhme chihquentiyon Dihvo vo ihyan chahn che hua nuhnde ye che a ihyan min che a va che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Quendi ye ra̱hn ye: ―U che rinducó nducoya̱ca ihyan ne, va che a̱ma chuhríhn. Intiyahn ma̱n, chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, nda̱hchenan se u, ne ca̱hno se u. Ate cuihno ino ro ne, ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chihno min ne, ra̱hn ye nduco nducoya̱ca ihyan: ―Adecoduhno ihyan che nahn conduco ye u ne, va che ca̱hcoma̱n ye vedeyeno yahn ma̱n ye. Andahre nahn ya̱h se ihyan na̱n cruz, ate va che conduco ye u ro ro. ");
INSERT INTO cutNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tihca̱, te adecoduhno ihyan che ca̱hcoma̱n ye u che nahn ndedevahn ma̱n ye ihyan ne, ihyan min ne, conda ye. Ate ihyan che ca̱hco menda̱hn ye ihyan, coh ye ca̱va u ne, ihyan min che cua̱co ne, ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nde tah hua cochihve che nedin da̱ma ihyan nducuahn vedecuihca che va iyehnse ndete che conda ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Adecoduhno ihyan che co cuihna̱n ye ca̱va u nduco ndudo yáhn ne, tihca̱ u che rinducó nducoya̱ca ihyan ne, co cuihná̱n ca̱va ihyan min ro che ndá̱ nduco ángel ndah numacuahn vederihquentiyon yáhn ma̱n, numacuahn vederihquentiyon yahn Chidá ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Cua̱co rá̱hn rí nchuhn te o ino ihyan che chenun ye muhn ne, hua coh ye nde nda̱ ro che ndihchero ye che conahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Chihno tenduh nine ro che tihca̱ ra̱hn Dihvo vo ne, quenda ye Pedro ma̱n, Jacobo ma̱n, Jua̱n ma̱n, ne cocha ye a̱ma tingüete ca̱va che cova̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Numanahn che reva̱h ye ne, ndo diya̱hn ye. Tino yahn ye ne, a̱ma ndo cua, a̱ma diya̱hn ro. ");
INSERT INTO cutNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Adena̱n chihnde ro o nda̱co, rente ye nduco Dihvo vo. Ihyan chahn ne, Moisés nduco Elías. ");
INSERT INTO cutNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Quendihco dave yahn vahchetero, ne rente ihyan chahn nduco Dihvo vo yahn che va che ca̱hno sa̱hn nunde ihyan min ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro nduco combiero yahn ye ne, a̱ma rendave ya̱hnde ye. Cuahn che ntah ndutina̱n ye ne, ndihchero ye che a̱ma ndo diya̱hn Dihvo vo. Namin ndihchero ye ihyan che o chahn che chenun ye min nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ura che a na̱hn Moisés nduco Elías ne, ra̱hn Pedro ri ye Dihvo vo: ―Ihyan Ricuahn, ¡nda̱hca̱ che cuahtenan vo muhn! Dendah nuhn ino vache vah, a̱ma na̱n che cuhnde ne, ne ta̱ma na̱n che cuhnde Moisés, ne ta̱ma na̱n che cuhnde Elías. Nde hua devano Pedro deh che ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Numanahn che ra̱hn ye ne, chiya a̱ma man, ne a̱ma dihya ihyan chahn chi che chenun ye va̱n man me. ");
INSERT INTO cutNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Va̱n man me ne, chihnevan ihyan chahn ndudo che ra̱hn Dendiohs: ―Sa̱hn tih che Da̱yá. Yahinó sa̱hn. Che ca̱hma se ne, chemin che codinahn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chihno che chihnevan ihyan chahn ndudo me ne, a dema̱n Dihvo vo nti ye. Ta̱hn min ne, hua ra̱hn ihyan chahn nduco nde a̱ma ihyan yahn vederihno che ndihchero ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ta̱ma ro me ne, cuenchahn ihyan chahn cuete me, ne a̱ma ya̱hn ihyan chahn ye, chendi yune ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Va̱n ihyan chahn ne, ra̱hn a̱ma se numa dito: ―Ihyan Ricuahn, conan va̱hino ne u. Condihchero ne ca̱va sa̱hn dihn yáhn, te a̱ma ndiya̱hn ra se yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A̱ma vaco chihnga̱ retumanga̱n sa̱hn, ne adena̱n rah se. A̱ma dito rendoh se, riche yan chende se. Rihno renuhn yah sa̱hn, ne hua nahn ca̱hcoma̱n sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A chicá favor ihyan apóstol yahn ne che ndetenda̱h ye vaco chihnga̱ me sa̱hn, ate hua chi ndetenda̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ndahconan Dihvo vo: ―¡A̱ma yah rí ca̱va nchuhn, ihyan nunde che hua ritahno ne! ¿A numacuahn ro conán nduco nchuhn? ¿Ta̱va ro va che cochá nduco ne? Cuehn, ngua daye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ura che nda̱ sa̱hn dihn me ne, tumanga̱n vaco chihnga̱ me sa̱hn, ne chendava se ndiya̱hn, rih dihca se. Ate ndetenda̱h Dihvo vo vaco chihnga̱ me, ne neneca̱h ye sa̱hn chida se. ");
INSERT INTO cutNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nducoya̱ca ihyan ne, a̱ma rahn ino ye yahn vederihno chahte che tihca̱ din Dendiohs. Namin nducoya̱ca ye rahn ino ye yahn nducuahn vederihno che redin Dihvo vo. Ra̱hn Dihvo vo nduco ihyan apóstol yahn ye: ");
INSERT INTO cutNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ndah conun ino nchuhn ndudo che rá̱hn nduco ne. U che rinducó nducoya̱ca ihyan ne, va che neca̱h se u ta̱h sa̱hn nunde. ");
INSERT INTO cutNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ate hua chenahn ihyan chahn che ra̱hn ye, te va̱hche yahn ye ca̱va che conahn ye, ne va̱h ye tumerune ye deh conahn ndudo min. ");
INSERT INTO cutNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ihyan apóstol chahn ne, rente ye va̱n ma̱n ye nduco vih, cha ye che tahque cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Checadino Dihvo vo che tihca̱ rendedecadino ihyan chahn, ne cheta̱h ye a̱ma lihn. Chehndi ye na̱n ye, ");
INSERT INTO cutNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ne ra̱hn ye nduco ihyan chahn: ―Adecoduhno ihyan che nevahnecun ye lihn cuh che cuande yáhn ne, u nevahnecun ye. Adecoduhno ihyan che nevahnecun ye u ne, Ihyan che dechuh ye u nevahnecun ye. Adecoduhno ihyan che tahque necun ye va̱n nducoya̱ca nchuhn ne, ihyan min che tahque ndina̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tuhme ra̱hn Jua̱n ri ye Dihvo vo: ―Ihyan Ricuahn, ndihchero nuhn a̱ma ihyan che, nduco che ra̱hn no ye che duche ne ne, rendetenda̱h ye vaco chihnga̱. Ate hua ca̱h yune nuhn che quendi ye, te hua nduco ye uvo. ");
INSERT INTO cutNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ra̱hn Dihvo vo ri ye Jua̱n: ―Hua ca̱hca ta̱n nchuhn che tihca̱ redin ye, te ihyan che hua ta̱n ye nduco vo ne, rinan ye uvo. ");
INSERT INTO cutNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Cuahn che a nda̱ nino ro che va che na̱hn Dihvo vo vahchetero ne, chihco da̱ma ino ye, ne cuahn ye ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dechuh mena̱n ye a̱ma o ihyan apóstol a̱ma cua̱n ya̱n yahn Samaria, ca̱va che nuhn ihyan chahn na̱n che conan ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ate ihyan ya̱n min ne, hua nevahnecun ye Dihvo vo, te a devano ye te ya̱n Jerusalén ca̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cuahn che ndihchero Jacobo nduco Jua̱n che tihca̱ ne, ra̱hn ye: ―Dihve nuhn, nduhca̱ che chihquentiyon ihyan profeta Elías che chera ya̱hn che chica na̱n ro, ne chiche a̱ma ya̱hn ihyan ne, ¿a nahn ne che tihca̱ din vo, ne cuihno cuco ihyan ya̱n tih ne? ");
INSERT INTO cutNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Chaconan Dihvo vo, ndihchero ye ihyan chahn, ne chihya ye ihyan: ―Nchuhn ne, nde hua devano ne ti rica vedeta̱n yahn ne che tihca̱ ra̱hn ne, ");
INSERT INTO cutNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","te u che rinducó nducoya̱ca ihyan ne, ndá̱ ca̱va che ndedeváhn ihyan, ndiyu ca̱va che decuihnó ihyan. Tuhme chuh da̱ma ye, cuahn ye ta̱ma ya̱n nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cuahn che a chenun yune ihyan chahn ne, ra̱hn a̱ma se ri se Dihvo vo: ―Dihvé, conducó ndih adecotino che ca̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ra̱hn Dihvo vo ri ye sa̱hn: ―Yuhne ne, va ive va̱co te; ya̱hda ne, va na̱n che rahte te, ate u che rinducó nducoya̱ca ihyan ne, metah nde na̱n che conditenán. ");
INSERT INTO cutNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ta̱ma se ne, ra̱hn Dihvo vo ri ye sa̱hn: ―Cuhn vo, condoque u. Ndahconan se yahn ye: ―Dihvé, te yune ne che conán na̱n chidá nde nda̱ ro che coh ye. Cuhché ihyan, tuhme conducó ndih. ");
INSERT INTO cutNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ra̱hn Dihvo vo ri ye sa̱hn: ―Cuihcoman ihyan che hua ritahno ye u, te anduhneca̱ ndete che a ndih ye na̱n Dendiohs. Ihyan chahn co cuhche ye tena̱hn yahn ye. Me di ne, cuehn cuahndode ndudo yahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ra̱hn ta̱ma se ri se Dihvo vo: ―Dihvé, cá̱hn conducó ndih, ate te yune ne che dinoca cá̱hn ca̱hmá nduco ihyan yáhn che chenun ye ndeva̱có, te va che ca̱hcomá̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ra̱hn Dihvo vo ri ye sa̱hn: ―Nduhca̱ che hua cochihve ntiyon yahn ihyan che ndaconan ye cua̱hn veda̱me ye ura che rih rine ye nduco curuhnya̱hn ne, tihca̱ hua cochihve che hua riquendi ihyan vederihquentiyon yahn Dendiohs cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chihno min ne, tenda̱hnun Dihvo vo te ino raco ndiche ihyan che rinduco ye ihyan, ne dechuh ye ihyan chahn ca̱de o ye queri a̱ma ya̱n cua̱hn na̱n che va che chuh ma̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ra̱hn ye ri ye ihyan chahn: ―Nduhca̱ che ndeh ndute nda̱ta cuahn che a̱ma riyahn ne, tihca̱ a̱ma ya̱hn ihyan che nahn cahnevan ye Ndudo yahn Dendiohs. Chemin che cuica nchuhn Dihvo vo Dendiohs che dechuh ca ye ihyan che cuahndudo ye Ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cuahn nchuhn, te u dechúh nchuhn nduhca̱ che ca̱hn itecuche va̱n lobo. ");
INSERT INTO cutNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Hua quenda ne dino. Nde tume, nde nda̱co, hua quenda ne. Nde hua cuahtendi ne yune ca̱va che neca̱h ne Dendiohs nde a̱ma ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Cuahn che conda̱ nchuhn a̱ma vah ne, ca̱hma ne: “Dendiohs nduco ye nchuhn, hua dehve ra̱hco ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ndete che min quenun a̱ma ihyan che necun ye ne, conahn nduco ye nduhca̱ che ca̱hma nchuhn. Ndete che hua ne, hua conahn. ");
INSERT INTO cutNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cuahtenan nchuhn vah na̱n che nevahnecun ye nchuhn, ne cocheh ne ma̱n, cuih ne ma̱n, deh che reh ye te ye, cheh ne, te na̱n che redin ihyan ntiyon ne, a min va che quenda̱h che cheh ye. Hua ca̱hn nchuhn nduh vah nduh vah. ");
INSERT INTO cutNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Cuahn che nda̱ nchuhn adecotino ya̱n na̱n che nevahnecun ye nchuhn ne, cocheh ne adecodehno che ca̱hco ye na̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Codin nchuhn che ndoyahn ihyan cah che vate ye min, ne ca̱hma ne nduco nducoya̱ca ihyan: “Vederihquentiyon yahn Dendiohs ne, a va va̱n nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ate adecotino ya̱n che nda̱ nchuhn na̱n che hua nevahnecun ye nchuhn ne, cuahn che ndiquenda̱h ne cua̱hn yune ne, ca̱hma ne: ");
INSERT INTO cutNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nde yune ya̱hn yahn ya̱n va̱co nchuhn che quenan ca̱h nuhn ne, nda̱hde nuhn yahn che hua chitahno ne. Ate cuedevano nchuhn te vederihquentiyon yahn Dendiohs ne, a va va̱n ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Rá̱hn rí nchuhn te ro che techeca̱de Dendiohs yahn ihyan ne, tahque chuhrihn ca ihyan ya̱n min che co ihyan ya̱n Sodoma. ");
INSERT INTO cutNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Ihyan ya̱n Corazín, ¡yah rí ca̱va nchuhn! Ihyan ya̱n Betsaida, ¡yah rí ca̱va nchuhn!, te ndete che ihyan ya̱n Tiro nduco ihyan ya̱n Sidón ndihchero ye vederihno che ndihchero nchuhn ne, ametah ro nto ino ihyan chahn nunde yahn ye, chahtenun ye tino ndere ma̱n, chahte ra̱n ye va̱n iya ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ate nda̱ ro che techeca̱de Dendiohs yahn ihyan ne, nchuhn che tahque chuhrihn ne che co ihyan ya̱n Tiro nduco ihyan ya̱n Sidón. ");
INSERT INTO cutNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Namin nchuhn, ihyan ya̱n Capernaum, a̱ma ya̱de ne ma̱n, a̱ma nahn cona̱n ne ma̱n, ate va che cuahtenun ne va̱n ruchiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Me nchuhn che rinduco ne u ne, ihyan che renevahnecun ye nchuhn ne, u renevahnecun ye. Ihyan che hua renevahnecun ye nchuhn ne, u hua renevahnecun ye. Ihyan che hua renevahnecun ye u ne, hua renevahnecun ye Ihyan che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ihyan che ino raco ndiche chahn che dechuh Dihvo vo ne, nta̱ ye. A̱ma yeno ye, ne ra̱hn ye: ―Dihve nuhn, nde vaco chihnga̱ ne, redinahn yahn nuhn yahn vederihquentiyon che te ne, chenan cuma nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co, te u ne, ndihcheró sa̱hn chundah che nduhca̱ che riya cuah, rica se na̱n ro, renda̱h se nde ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","U té vederihquentiyon, chenan cuma nchuhn, ne nda̱hco ndiya ne vederihquentiyon yahn chundah. Andahre condinun ne cu ta̱n ma̱n, itedahn ma̱n, ate hua dehva co yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nchuhn ne, nde hua nduh co yeno ne che redinahn vaco chihnga̱ che rihquentiyon ne. Tahque co yeno ne yahn che a chenan ca̱ca ne vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ura min ne, din Vaco Dendiohs che a̱ma chi yeno Dihvo vo, ne cova̱h ye: ―Chida má̱n, ndih che dendah ne vahchetero ma̱n, iyehnse ma̱n. U rendevá numacuahn vedeyeno yavena̱n ne, te chihco ndeh ne vededevano yahn ne na̱n ihyan che ra̱hco ye che a̱ma devano ye, ne ca̱h ne, chi devano ihyan che necun ye. Chidá, tihca̱ din ne, te tihca̱ nahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tuhme ra̱hn ye ri ye ihyan che nduco ye: ―Chidá ne, nda̱hco ye nducuahn dehtenduh tá̱h. Nde a̱ma ihyan hua rendihche ye duh che Da̱ya Dendiohs. Ate Chidá ne, rendihche ye u, te u che Da̱ya ye. Nde a̱ma ihyan hua rendihche ye Chidá, atena̱n u, Da̱ya ye ma̱n, ihyan che tenda̱hnún ihyan ma̱n, rendihche nuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chaconan ye ndihchero ye ihyan che rinduco ye ihyan, ne deva vih ra̱hn ye nduco ye: ―Nchuhn ne, a̱ma ndah ro yahn ne, ");
INSERT INTO cutNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","te rá̱hn rí nchuhn te a̱ma ya̱hn ihyan profeta ma̱n, rey ma̱n, che chahte ye a ra̱hn me, chenan ino ye che ndihchero ye che rendihchero nchuhn, ate hua nda̱ca ndihchero ye. Chenan ino ye che cahnevan ye che rihnevan nchuhn, ate hua nda̱ca chihnevan ye. ");
INSERT INTO cutNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","A̱ma sa̱hn devano ley che dirun Moisés ne, ca̱va che tumerande se Dihvo vo ne, tumerune se ihyan: ―Ihyan Ricuahn, ¿deh va che dín ca̱va che conán vahchetero numacuahn ro ne? ");
INSERT INTO cutNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tumerune Dihvo vo sa̱hn: ―¿Deh che ndirun na̱n ley che dirun Moisés ne? ¿Ta̱ca̱ renehn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ndahconan se: ―“Codin yahine Dihve Dendiohs numacuahn chedave yehn ma̱n, numa ine ma̱n, numacuahn fuerza yehn ma̱n, numacuahn vederendedecadino yehn ma̱n. Namin codin yahine nducoya̱ca ihyan nduhca̱ che yahine man di.” ");
INSERT INTO cutNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tuhme ra̱hn ye ri ye sa̱hn: ―Nda̱hca̱ ndahconen. Ndete che tihca̱ din ne, conen vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ate nducote hua nahn se che cora vedecuihno yahn se ne, tumerune se Dihvo vo: ―¿Duh ihyan che din yahinó me ne? ");
INSERT INTO cutNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ndahconan Dihvo vo yahn se nduco ejemplo cuh: ―A̱ma ihyan ne, chica ye ya̱n Jerusalén, cuahn ye yune che renda̱ ya̱n Jericó. Min ta̱hn nun sa̱hn duco ihyan, ne chahn se ihyan, chehnevi se nde tino yahn ye. Nuhn yah se ihyan, ne chacondihte se ihyan, ndih ta̱hn ye, ne cona̱hn se. ");
INSERT INTO cutNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ura min chuh a̱ma chidocuya̱n na̱n che quendite ihyan che nta̱ca yah me, ne chahconan ye yune, chuh ye cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Namena̱n me ne, chuh ta̱ma chidocuya̱n, a̱ma levita, ihyan che redin cuda̱do na̱n ta. Ndihchero ye che quendite ihyan che nta̱ca yah me, ne namin chahconan ye yune, chuh ye cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ate chihno min ne, nda̱ a̱ma sa̱hn nación yahn Samaria na̱n che quendite ihyan che nta̱ca yah me, ne quenan va̱hino se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chahn nda̱ se, ne dico se ihyan, chih se aceite nduco vino, ne dechiche se nduh cua̱n na̱n yah yahn ye. Tuhme tihde se ihyan da̱me yuhdo che ra se, ne quenda se ihyan a̱ma vah, ne min din se cuda̱do ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ta̱ma ro me, ura che a ca̱hn se ne, tenda̱h se tume, ca̱h se sa̱hn che va̱co min, ne ra̱hn se ri se vih: “Codin cuda̱do ihyan cuh, ne cuahn che ndaconán ne, nedihvé yehn ta̱va ca tume che toh nduco ye.” ");
INSERT INTO cutNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tuhme tumerune Dihvo vo sa̱hn: ―¿Cha ihyan che ino chahn che din yahino ye ihyan che nuhn yah sa̱hn duco chahn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ndahconan se yahn ye: ―Sa̱hn che din se vedeva̱hino nduco ye tahque yahino se ihyan. Tuhme ra̱hn ye ri ye sa̱hn: ―Nda̱hca̱ ndahconen. Namin di ne, codin yahine nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Chihno min ne, chahn Dihvo vo a̱ma ya̱n lihn, va̱co a̱ma nda̱hta che duche te Marta. ");
INSERT INTO cutNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ne, va a̱ma ta̱hn coh te che duche te María. Ta̱hn min ne, chihnde te na̱n Dihvo vo, rihnevan te ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ate Marta ne, a̱ma va ntiyon yahn te, ne chahn te na̱n Dihvo vo, ne ra̱hn te ri te ihyan: ―Dihvé, ¿a hua rihco ne cuda̱do che ta̱hn cóh ne, rihcoma̱n te u nduco ntiyon yahn nuhn? Ca̱hma ne co ne ta̱hn che conan te u. ");
INSERT INTO cutNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ndahconan Dihvo vo yahn te: ―Marta, Marta, di ne, a̱ma rendedecadine yahn ntiyon yehn. ");
INSERT INTO cutNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ate va a̱ma na̱n che tahque cochihve. María ne, tenda̱hnun te cha che tahque ndah, ne hua duhva cahnevi yahn te. ");
INSERT INTO cutNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A̱ma yune ne, reva̱h Dihvo vo, ne cuahn che a chihno cova̱h ye ne, ra̱hn a̱ma ihyan apóstol ri ye ihyan: ―Dihve nuhn, cuicuahn ne nuhn, cova̱h nuhn nduhca̱ che chicuahn Jua̱n Bautista ihyan che chinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cuahn che cova̱h nchuhn ne, ca̱hma ne tuhca̱: Chida nuhn che va ne vahchetero, nda̱hca̱ che ndeva nducoya̱ca ihyan yavena̱n ne. Nda̱hca̱ che ca̱hcantiyon ne nducoya̱ca ihyan. Nduhca̱ che rinahn nducuahn che nahn ne vahchetero ne, tihca̱ conahn muhn iyehnse cuh. ");
INSERT INTO cutNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cuete ne che cheh nuhn ma̱n nduhca̱ che rete ne ro ro. ");
INSERT INTO cutNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cuenchahco ne nunde yahn nuhn, te namin nuhn ne, renchahco nuhn yahn nducoya̱ca ihyan che rendihco ye yahn nuhn. Hua cuahnecun ne che tumerande chundah nuhn. Cuendedevahn ne nuhn yahn nducuahn che chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tuhme quendi Dihvo vo, ne ra̱hn ye: ―Ndete che na̱n ma̱hn ya̱n, ca̱hn a̱ma cha nchuhn va̱co amigo yahn ne, ne ca̱hma ne nduco ye: “Combiero, teche ne o ino pa̱n, tumenán, ");
INSERT INTO cutNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","te a̱ma amigo yáhn nda̱ ye ndeva̱có, ne metah dehva che cá̱h cheh ye”, ");
INSERT INTO cutNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿a ndahconan ye nde chete vah tuhca̱ ne?: “Hua dendoh u, te a quendité na̱n yundo nduco checa̱hya yáhn, ne chendevah ne, a ntude. Hua co necuán té che rique.” ");
INSERT INTO cutNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Rá̱hn rí nchuhn te andahre hua necuan ye, te ye ca̱va che amigo yahn ne ihyan, ate ndete che quendi ne ca̱ca ne ihyan ne, necuan ye te ye nducuahn che nahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","10","Namin rá̱hn rí nchuhn: Cuica ne dehtenduh che nahn ne Dendiohs, ne te ye nchuhn. Tihca̱, te nducoya̱ca ihyan che rica ye ne, rendonda̱ ta̱h ye. Ihyan che renuhn ye ne, renda̱ca ye. Ihyan che riya̱hve ye ne, rena̱ne chendevah ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ndete che ca̱ca da̱ya a̱ma cha nchuhn pa̱n ne, ¿a ca̱h ne a̱ma tu? O ndete che ca̱ca da̱ya nchuhn ya̱hca, ¿a ca̱h ne a̱ma cu? ");
INSERT INTO cutNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O ndete che ca̱ca da̱ya nchuhn a̱ma dute tuh ne, ¿a ca̱h ne a̱ma itedahn? ");
INSERT INTO cutNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Andahre duhtuno ihyan nchuhn, ate devano ca̱h ne dehtenduh che ndah da̱ya ne. ¿A ndiyu tahque nun te Chida nchuhn che va ye vahchetero Vaco Ndah yahn ye nchuhn cuahn che ca̱ca ne? ");
INSERT INTO cutNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","A̱ma yune ne, ndetenda̱h Dihvo vo vaco chihnga̱ che quenun a̱ma se, nedin che ndi lihme se. Cuahn che a ndiquenda̱h vaco chihnga̱ me ne, a chi ca̱hn sa̱hn min, ne a̱ma cuahn ino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ate na̱hn se ne, ra̱hn se: ―Sa̱hn tih ne, rendetenda̱h se vaco chihnga̱, te quenan cuma se vederihquentiyon yahn chundah, sa̱hn min che ndina̱n se yahn vaco chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na̱hn tun se che nahn tumerande se Dihvo vo ne, rica se che din ye a̱ma vederihno che ca̱ca vahchetero, ndihchero se. ");
INSERT INTO cutNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ate devano Dihvo vo deh che rendedecadino sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―Ndete ihyan che vate ye rihquentiyon ye, cuahtecuhma ye va̱n ma̱n ye nduco vih ne, hua co quendi ye ca̱hcantiyon ye. Namin ihyan che chenun ye a̱ma vah, ndete che cuahtecuhma ye va̱n ma̱n ye nduco vih ne, hua co quendi ye, cuahtenun da̱ma ye. ");
INSERT INTO cutNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Namin chundah, ndete che cuhma se nduco ihyan yahn se ne, ¿ta̱ca̱ co quendi ca̱hcantiyon se? Tihca̱ tumeruné nchuhn, te ra̱hn ne te nduco vederihquentiyon yahn chundah, rendetendá̱h vaco chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ndete che rendetendá̱h vaco chihnga̱ nduco vederihquentiyon yahn chundah ne, tuhme ¿duhra rinan combiero yahn nchuhn che rendetenda̱h se vaco chihnga̱? Ma̱n sa̱hn chahn ca̱hma se co se nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ate ndete che nduco vederihquentiyon yahn Dendiohs rendetendá̱h vaco chihnga̱ ne, codevano nchuhn te vederihquentiyon yahn Dendiohs ne, a va va̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Cuahn che a̱ma sa̱hn dito va che redin nduco se cuda̱do va̱co se ne, nducuahn dehtenduh yahn se ne, nda̱hca̱ va. ");
INSERT INTO cutNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ate ndete che nda̱ ta̱ma ihyan che tahque dito ye che co sa̱hn min ne, nda̱hco ndiya ye sa̱hn, cahnevi ye nducuahn dehtenduh che redin nduco se cuda̱do va̱co se, ne necahn ma̱hn ye nduco combiero yahn ye nducuahn che cahnevi ye yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ihyan che hua rinduco ye u ne, ta̱n ye nducó. Ihyan che hua redin ye ntiyon nducó ne, redetohnan ye ntiyon che redín. ");
INSERT INTO cutNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Cuahn che a ndiquenda̱h vaco chihnga̱ a̱ma ihyan ne, rechica na̱n ya̱hn cuma, renuhn na̱n che conun. Ndete che hua renda̱ca na̱n che conun ne, rendedecadino: “Na̱hn tún na̱n che ndiquendá̱h.” ");
INSERT INTO cutNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Cuahn che rendaconan ne, renta̱ca ihyan min nduhca̱ a̱ma vah che nda̱hca̱ nto dave nde tuno necuco. ");
INSERT INTO cutNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tuhme rahn regua te ndache vaco che tahque chihnga̱, ne renda̱ ihyan min, ne tahque rechuhrihn ye che co ro mena̱n me. ");
INSERT INTO cutNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ura che ra̱hn Dihvo vo dehtenduh che tuhchan ne, a̱ma dito ra̱hn a̱ma nda̱hta va̱n ihyan: ―¡Ndah ro yahn ihyan nda̱hta che chacoya̱hn ye ndih ma̱n, che ta̱ve ye ndih ma̱n! ");
INSERT INTO cutNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Dihvo vo ne, ra̱hn ye: ―Tahque ndah ro yahn ihyan che rihnevan ye Ndudo yahn Dendiohs ma̱n, redinahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cuahn che a̱ma ndo da̱ma ihyan ne, ra̱hn Dihvo vo: ―Nchuhn che vate ne ma̱n ro cuh ne, duhtuno ihyan ne, rica ne vederihno. Ate vederihno ne, hua nda̱ca ndihchero ne. Atena̱n a̱ma vederihno nduhca̱ vederihno che din Dendiohs nduco Jonás, nda̱ca ndihchero ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nduhca̱ che ndihchero ihyan ya̱n Nínive vederihno che din Dendiohs nduco Jonás ne, tihca̱ conahn a̱ma vederihno nduco u che rinducó nducoya̱ca ihyan, ndihchero nchuhn che vate ne ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nda̱ ro che techeca̱de Dendiohs yahn nducoya̱ca ihyan ne, necuan reina che va te cua̱hn ya̱hn ndiya, ca̱ca nunde te yahn nchuhn che vate ne ma̱n ro cuh, te ta̱hn min ne, chica te ya̱hn yahn, ne nda̱ te, chihnevan te vededevano yahn Salomón. Ate u che tahque chahte vederihquentiyon yáhn che co Salomón, muhn quenún va̱n nchuhn, nde hua retumaca̱h ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nda̱ ro che techeca̱de Dendiohs yahn nducoya̱ca ihyan ne, necuan ihyan ya̱n Nínive, ca̱ca nunde ye yahn nchuhn che vate ne ma̱n ro cuh, te ihyan chahn ne, nto ino ye nunde yahn ye cuahn che cahndudo Jonás. Ate u che tahque chahte vederihquentiyon yáhn che co Jonás, muhn quenún va̱n nchuhn, nde hua retumaca̱h ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Nde a̱ma ihyan hua rihco ye a̱ma ya̱hn ma̱n a̱ma cajún, ate rihco ye na̱n che ya̱co ca̱va che co ro dave yahn ihyan che renda̱ ye. Tihca̱ ndudo yáhn, te hua co conun ndeh. ");
INSERT INTO cutNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ndutena̱n nchuhn ne, nduhca̱ a̱ma ya̱hn che redin che ri ro na̱n ne. Chedave yahn ne ne, nduhca̱ a̱ma ya̱hn che redin che ri renahn ne. Ndete che ndah chedave yahn ne ne, conahn ndah ne. Ate ndete hua ndah ne, nde hua conahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chemin che nahn che ca̱hco nchuhn cuda̱do chedave yahn ne ca̱va che ndah conahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ndete che tihca̱ ca̱hco ne cuda̱do ne, chedave yahn ne ne, nduhca̱ a̱ma ya̱hn ndah che din che conahn ndah ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cuahn che chihno ra̱hn Dihvo vo ne, ya̱hve a̱ma sa̱hn fariseo ihyan che ca̱hn ye va̱co se, cheh ye nduco se. Chenda̱ ye va̱co se, ne cuahn che nda̱ ura ne, chihnde ye na̱n mesa. ");
INSERT INTO cutNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ndihchero sa̱hn fariseo me che hua na̱no ye ta̱h ye nduhca̱ costumbre yahn se, ne a̱ma cuahn ino se chi. ");
INSERT INTO cutNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ra̱hn ye ri ye sa̱hn: ―Nchuhn sa̱hn fariseo ne, a̱ma rena̱no ne va̱so ma̱n, cuh ma̱n. Ate chete chedave yahn ma̱n ne ne, ndito vede idihya ma̱n, nducuahn che chihnga̱ ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Hua renahn nchuhn! ¿A hua devano nchuhn te Dendiohs che dendah ye ihyan ne, tahque nahn ye che dave chedave yahn ihyan che co cua̱hn mena̱n ye? ");
INSERT INTO cutNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Cuedin nchuhn vedeva̱hino numacuahn chedave yahn ne. Tuhme co ro che dave yavena̱n ne na̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Nchuhn sa̱hn fariseo, ¡yah rí ca̱va ne!, te dema̱n riya yahn ive ma̱n, aruda ma̱n, dehtenduh ya̱ta ma̱n, reca̱h ne. Ate vederihquentiyon yahn Dendiohs ma̱n, vedeyahino yahn ye ma̱n, andahre chemin che tahque rigonun chihve ne, rihcoma̱n ne. Nduhca̱ che redinahn ne yahn riya ne, tihca̱ codinahn ne yahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Nchuhn sa̱hn fariseo, ¡yah rí ca̱va ne!, te renan ino ne cuahte ne chete ya̱co na̱n silla che rahte ihyan ndina̱n. Namin renan ino ne che nevahnecun ihyan nchuhn, nte ye Dendiohs nchuhn cua̱hn ndihve. ");
INSERT INTO cutNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Nchuhn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ¡yah rí ca̱va ne! ¡O na̱n o chende ne! Nchuhn ne, nduhca̱ ya̱yan che a nincheh, che vatechica ihyan mena̱n nde hua devano ye che ya̱yan, tihchan ne. ");
INSERT INTO cutNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tuhme ra̱hn a̱ma sa̱hn devano ley che dirun Moisés: ―Ihyan Ricuahn, cuahn che tihca̱ ra̱hn ne ne, nde nuhn, chihnga̱ riya yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ate ra̱hn Dihvo vo ri ye sa̱hn: ―Namin nchuhn, sa̱hn devano ley che dirun Moisés, ¡yah rí ca̱va ne!, te reca̱h rihn nduh ne ihyan nduco dehtenduh che nentihdenan ne, rihquentiyon ne che va che dinahn ye. Ate ma̱n ne ne, nde tah hua rinan ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Yah rí ca̱va nchuhn!, te rahto ne ya̱yan yahn ihyan profeta che ma̱n indihte yahn ne, chihno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nchuhn ne, devano ne che din indihte yahn ne, ne da̱ma ri ne nduco ye, te ihyan chahn chihno ye, ne nchuhn rahto ne ya̱yan. ");
INSERT INTO cutNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’A yahn che tihca̱ redin nchuhn che ra̱hn Dendiohs numacuahn vededevano yahn ye: “Dechúh ihyan profeta ma̱n, ihyan apóstol ma̱n, ne ca̱hno se na̱hn ihyan chahn, ne na̱hn ye ne, din ta̱n se nduco ye.” ");
INSERT INTO cutNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Dendiohs va che techeca̱de ye yahn ihyan che vate ye ma̱n ro cuh, te ndehde da̱me ye yun yahn nducoya̱ca ihyan profeta che chihno ihyan nde na̱n che cana̱n iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ndehde da̱me ye nde yun yahn Abel, nde yun yahn Zacarías, che chihno se ihyan menda̱hn yahn na̱n ta nduco ya̱co chahte. Tihca̱ rá̱hn rí nchuhn, te yun yahn nducoya̱ca ihyan chahn ne, va che nedihve ihyan che vate ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Nchuhn, sa̱hn devano ley che dirun Moisés, ¡yah rí ca̱va ne!, te vededevano che chihcoro Dendiohs ne, nchuhn ne, rihco ndeh ne. Nde hua riquendi ma̱n nchuhn, nde hua rahnecun ne che quendi ihyan chena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cuahn che ra̱hn Dihvo vo dehtenduh che tuhchan ne, sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, chi ta̱n se nduco ye, ne a̱ma ndeh na̱n dehtenduh retumerune se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nduco tihca̱ ne, retumarande se ihyan, te nahn se che ca̱hma ye a̱ma ndudo che hua nda̱hca̱, ca̱va che co ca̱ca nunde se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ura min ne, a̱ma ya̱hn ihyan ndo da̱ma ye nde tuno raconda̱ vih ye. Tuhme ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―Cuihco nchuhn cuda̱do nduco ndudo che ricuahn sa̱hn fariseo, te o na̱n o chende se, ne ndudo yahn se ne, rendih nduhca̱ che rendih ya̱ yahn pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nducuahn che va cua̱hn ndeh ne, va che cuhnde ro. Namin nducuahn che ri cua̱hn ndeh ne, va che cadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tihca̱, te che rente nchuhn cua̱hn dema̱n ne nduco vih ne, va che cadino nducoya̱ca ihyan. Namin che ra̱hn nchuhn cua̱hn chete vah ne, va che cuahndudo ihyan nde tin vah yuto. ");
INSERT INTO cutNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ate nchuhn amigo yáhn, rá̱hn rí nchuhn te hua din va̱h ne sa̱hn che rihno se ihyan, te cuihno min ne, ametah dehva co din se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","U có nchuhn duh che din va̱h ne. Codin va̱h ne Ihyan che co cahnevi ye vedevihche yahn ne, ne cuihno min ne, va vederihquentiyon yahn ye che dechuh ye nchuhn va̱n ruchiya̱hn. A Ihyan min che codin va̱h nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ya̱hda ca̱hya ne, nde hua rigonun chihve te, rendihcue ihyan uhn te, ra ye co tume ca̱hya, ate Dendiohs ne, nda cuande ye ite. ");
INSERT INTO cutNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nde yudo tin queri a̱ma nchuhn ne, nda cuande ye. Huate va̱h nchuhn, te tahque rigonun chihve nchuhn che co a̱ma ya̱hn ya̱hda ca̱hya. ");
INSERT INTO cutNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Rá̱hn rí nchuhn te adecoduhno ihyan che renevahnecun ye u na̱n nducoya̱ca ihyan ne, u che rinducó nducoya̱ca ihyan ne, ndevá ihyan min na̱n nducoya̱ca ángel yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ate ihyan che hua renevahnecun ye u na̱n nducoya̱ca ihyan ne, hua ndevá ihyan min na̱n ángel yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Adecoduhno ihyan, andahre chihnga̱ ca̱hma ye yahn u che rinducó nducoya̱ca ihyan, co ca nda̱ca ye vederenchahco. Ate ihyan che ca̱hva ye yahn Vaco Ndah yahn Dendiohs ne, ametah nchahco cuahno Dendiohs ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Cuahn che quenda se nchuhn chete ya̱co ma̱n, na̱n juez ma̱n, na̱n intiyahn ma̱n ne, hua ndedecadino nchuhn deh ca̱hma ne, o ta̱ca̱ ca̱hma ne, ");
INSERT INTO cutNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","te ura min ne, Vaco Ndah yahn Dendiohs te cuande nchuhn deh che ca̱hma ne. ");
INSERT INTO cutNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ra̱hn a̱ma se ri se Dihvo vo: ―Ihyan Ricuahn, ca̱hma ne co ne sa̱hn dihnó che cahma̱hn se nducó dehtenduh che chihco indihte yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ate ra̱hn Dihvo vo ri ye sa̱hn: ―Nda̱co, ndiyu juez u ca̱va che ca̱hcantiyón che cahma̱hn nchuhn dehtenduh yahn ne nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tuhme ra̱hn ye ri ye nducoya̱ca ihyan: ―Cuihco nchuhn cuda̱do, ne hua din yahino ne vedecuihca che va iyehnse cuh, te andahre a̱ma va vedecuihca yahn ihyan, ate ndiyu nduco chemin co ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tuhme nte Dihvo vo ejemplo cuh: ―Chihnde a̱ma sa̱hn cuihca, ne a̱ma nduyo ne, a̱ma chi chenda̱ta yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tuhme ndedecadino se: “Ma̱n ne, ¿ta̱ca̱ dín?, te ametah ti na̱n che cuih ndáh ndute nda̱ta yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tuhca̱ dín. Ntihné nducuahn vahya̱ca yáhn, ne ca̱hnó che tahque rahte. Min cuih ndáh nducuahn ndute nda̱ta yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A̱ma va vedecuihca yáhn ca̱va ndeh nduyo. Ma̱n ne, cuhnde táhn, chéh ma̱n, cúh ma̱n, co yenó ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ate ra̱hn Dendiohs ri ye sa̱hn: “Hua renehn. Ma̱n ya̱n cuh, va che coh. A̱ma nedin dame vedecuihca, ate ma̱n ne, nde hua devene duh che ndah yahn.” ");
INSERT INTO cutNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quendi Dihvo vo, ne ra̱hn ye: ―Tihchan ihyan che renedin da̱ma ye vedecuihca ca̱va ma̱n ye, ate na̱n Dendiohs ne, ametah dehva yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ra̱hn Dihvo vo nduco ihyan apóstol yahn ye: ―Chemin che rá̱hn rí nchuhn. Hua cua̱hcora̱n ne ta̱ca̱ din ne che nda̱ca cheh ne, nde hua cua̱hcora̱n ne ca̱va tino yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Vedevihche yahn nchuhn ne, tahque quenun ya̱n che co che reh ne, ne ma̱n nchuhn ne, tahque chenun ya̱n ne che co tino che rahtenun ne. ");
INSERT INTO cutNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Condihche nchuhn chihnda. Nde hua rino te nda̱ta, nde metah na̱n che cuih ndah te deh che cheh te, ate Dendiohs ne, rihquecheh ye ite. ¡Tahque rigonun chihve nchuhn che co ya̱hda! ");
INSERT INTO cutNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Duh nchuhn che andahre a̱ma rendedecadino ne, co tihdenan ne ma̱hn metro che ya̱co ne? ");
INSERT INTO cutNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndete che hua ri redin nchuhn cha che hua va̱hche, ¿dehco che a̱ma rendedecadino ne yahn dehtenduh chena̱hn? ");
INSERT INTO cutNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Condihche nchuhn ta̱ca̱ rihta na̱nda. Nde hua renda̱hyon, nde hua ra̱h cuche, ate rá̱hn rí nchuhn te tahque nda̱hchan ro na̱nda che co tino che quenun Salomón, andahre a̱ma chahte vederihquentiyon quenan cuma ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dendiohs ne, redin ye che riya na̱nda viya̱ta andahre a̱ma ro rihnde, ne ta̱ma ro ne, rih di. ¿A ndiyu tahque redin ye cuda̱do nchuhn? ¿Dehco che a̱ma doh ritahno ne tuhme? ");
INSERT INTO cutNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chemin che hua ca̱h rihn ma̱n ne nchuhn che rendedecadino ne deh cheh ne ma̱n, deh cuh ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ihyan iyehnse ne, a̱ma rendedecadino ye yahn nducuahn dehtenduh che tuhchan. Ate nchuhn ne, va Chida ne vahchetero, ne a devano ye che rendotenan ne nducuahn dehtenduh che tuhchan. ");
INSERT INTO cutNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dinoca cuahnecun nchuhn che ca̱hcantiyon Dendiohs nchuhn. Tuhme nducuahn dehtenduh che tuhchan ne, nde tihdena̱n ca ye te ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Nchuhn che doh ri ne, che rinduco ne u, huate va̱h ne, te Chida ne ne, nahn ca̱hcantiyon ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Condihcue nchuhn dehtenduh che va yahn ne, ne codin ne vedeva̱hino nduco. Codin nchuhn che ndah ca̱va che ndeva ne che ndah vahchetero. Chemin ne, nduhca̱ a̱ma vedecuihca che hua co cahnevi sa̱hn duco ma̱n, hua co detoh iteduhn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tihca̱, te cha vedecuihca che va yahn nchuhn ne, a yahn chemin che rendedecadino ne. ");
INSERT INTO cutNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Cuahn che rahn a̱ma ihyan vihco na̱n che rihneva̱co ihyan ne, rahtenun sa̱hn deca̱hya yahn ye cuda̱do vah. Vateya̱n se ca̱va che ndeta̱hno che nta̱ dihve se ya̱hve ye ne, aderano se na̱hne se chendevah. ");
INSERT INTO cutNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ndah ro yahn sa̱hn deca̱hya che vateya̱n se ura che nta̱ dihve se. Cua̱co rá̱hn rí nchuhn te ma̱n ye cua̱condihte ye mesa, ne ca̱hco ye sa̱hn che cheh se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Andahre na̱n ma̱hn ya̱n, o a nino co dave nta̱ ye, ndete che nta̱ca ye sa̱hn che vateya̱n se ne, ndah ro yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Cuedevano nchuhn te ndete che devano a̱ma ihyan deh ura nda̱ sa̱hn duco ne, cuhndeya̱n ye, ne hua ca̱h yune ye che conda̱ se chete va̱co ye, duco se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nchuhn ne, tihca̱ cuahteya̱n ne, te u che rinducó nducoya̱ca ihyan ne, adena̱n ndá̱ ura che nde tah hua vate ne cuda̱do. ");
INSERT INTO cutNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tuhme tumerune Pedro: ―Dihvé, ¿a rente ne ejemplo cuh yahn dema̱n nuhn, o yahn nducoya̱ca ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ndahconan Dihvo vo: ―¿Cha sa̱hn deca̱hya che ca̱hco dihve se ntiyon ta̱h se ca̱va che ca̱hcantiyon se va̱co ye ma̱n, ca̱hcacheh se mozo yahn ye ma̱n? ¿A ndiyu sa̱hn che redinahn se ma̱n, che rino na̱n se ma̱n? ");
INSERT INTO cutNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ndah ro yahn sa̱hn che nta̱ca dihve se sa̱hn che redinahn se ntiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Cua̱co rá̱hn rí nchuhn te ca̱hco dihve sa̱hn min ntiyon ta̱h se ca̱va che din se cuda̱do nducuahn ntiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ate ndete che ra̱hco a̱ma cha sa̱hn deca̱hya te hua nun nta̱ dihve se, ne cuana̱n redin ta̱n se, rahn se sa̱hn mozo yahn ye ma̱n, ta̱hn mozo yahn ye ma̱n, reh se ma̱n, rih se ma̱n, ricoh se ma̱n ne, ");
INSERT INTO cutNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nta̱ dihve se ro che hua quenan rino se, ura che hua devano se, ne din ye castigo sa̱hn nduhca̱ che redin ihyan castigo sa̱hn che hua redinahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Sa̱hn deca̱hya che a devano se dehtenduh che nahn dihve se, ne hua dinahn se ne, a̱ma chahte castigo co se. ");
INSERT INTO cutNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ate sa̱hn deca̱hya che hua devano se, ne din se dehtenduh che hua nda̱hca̱ ne, hua nduh chahte castigo co se. Adecoduhno ihyan che chahte ntiyon conda̱ ta̱h ye ne, ndahva ndehde da̱me ye, ne ihyan che nde tahque chahte ntiyon conda̱ ta̱h ye ne, nde tahque ndeh ca ndehde da̱me ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ca̱va u ne, cuahte ca̱nda ihyan va̱n ma̱n ye nduco vih anduhneca̱ ndete che a chíh ya̱hn muhn iyehnse cuh, ne ¡a̱ma náhn ndete a riche! ");
INSERT INTO cutNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","U ne, va che a̱ma chuhríhn, ne ¡a̱ma yah náhn ndete che a conahn! ");
INSERT INTO cutNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿A ra̱hco nchuhn che ndá̱ muhn iyehnse cuh ca̱va che nda̱hca̱ cuahtenan ihyan nduco vih? Rá̱hn rí nchuhn te hua, te ndá̱ ca̱va che cuahte ca̱nda ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cuana̱n nde meniyon, ndete che uhn ihyan chenun ye a̱ma vah ne, ino ye co ta̱n ye nduco o ye. ");
INSERT INTO cutNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ihyan cha̱hn ne, co ta̱n ye nduco sa̱hn da̱ya ye, ne sa̱hn da̱ya ye ne, co ta̱n se nduco chida se. Ihyan nda̱hta ne, co ta̱n ye nduco ta̱hn da̱ya ye, ne ta̱hn da̱ya ye ne, co ta̱n te nduco chaco te. Namin co ta̱n ihyan nda̱hta nduco ta̱hn decuno ye, ne ta̱hn decuno ye ne, co ta̱n te nduco inda̱hn te. ");
INSERT INTO cutNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Quendi Dihvo vo, ne ra̱hn ye nduco nducoya̱ca ihyan: ―Cuahn che rendihchero nchuhn che renecuan man cua̱hn na̱n che rehche ya̱hn ne, ndetahno ra̱hn ne te cuan co, ne tihca̱ ri. ");
INSERT INTO cutNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Namin cuahn che rano yuhneya̱hn ne, ra̱hn nchuhn te cuhnde ihno, ne tihca̱ ri. ");
INSERT INTO cutNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡O na̱n o chende nchuhn! Devano nchuhn cuahn che co ihno ma̱n, cuahn che cuan co ma̱n. ¿Dehco che hua devano ne deh ri ro cuh che vate ne? ");
INSERT INTO cutNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Dehco che hua rendedecadino ma̱n nchuhn cha che tahque ndah din ne na̱n Dendiohs? ");
INSERT INTO cutNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Numanahn che ca̱hn a̱ma cha nchuhn na̱n intiyahn nduco sa̱hn che ta̱n se nduco ne ne, codin nun ino ne, cuenedin ndah ne ndudo nduco se cua̱hn yune, ca̱va che hua quenda se ndih na̱n juez, ne neca̱h ye ndih ta̱h policía ca̱va che tihyon se ndih va̱coya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Rá̱hn rí ndih te ndete che hua nedin ndah ne ndudo nduco se ne, hua ndiquenda̱h ne va̱coya̱hn nde cuihno nedihve ne nducuahn che quendihco ne. ");
INSERT INTO cutNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ura min ne, min chenan neve ihyan, ne neca̱h cuande ye Dihvo vo nduhca̱ che chahno sa̱hn esta̱do yahn Galilea chi, che chihquentiyon Pila̱to sanda̱do che chihno se sa̱hn, ura che rihno se ite che co te vedino na̱n ta. ");
INSERT INTO cutNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tumerune Dihvo vo ihyan chahn: ―¿A ra̱hco nchuhn che sa̱hn Galilea chahn che tihca̱ chih se, tahque chendihco se nunde va̱n nducoya̱ca ihyan Galilea? ");
INSERT INTO cutNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Rá̱hn rí nchuhn te hua. Ndete che hua nto ino nchuhn nunde yahn ne ne, va che conda nducoya̱ca ne. ");
INSERT INTO cutNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Namin, ¿a ra̱hco nchuhn che ihyan che ntihyon ino chahn che chenda̱h ndudo torre yahn Siloé, tahque chendihco ye nunde va̱n nducoya̱ca ihyan ya̱n Jerusalén? ");
INSERT INTO cutNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Rá̱hn rí nchuhn te hua. Ndete che hua nto ino nchuhn nunde yahn ne ne, conda nducoya̱ca ne. ");
INSERT INTO cutNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Namin nte Dihvo vo ejemplo cuh: ―A̱ma ihyan ne, ndihche ye a̱ma ya̱hn higo va̱n ya̱hn nda̱ta yahn ye, ne a̱ma yune ne, chahn ye chinuhn ye ndute yahn, ne hua nda̱ca ye, te hua ri yahn. ");
INSERT INTO cutNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tuhme ra̱hn ye ri ye sa̱hn che redin cuda̱do ya̱hn nda̱ta chahn: “A ino nduyo che rendá̱ rinúhn ndute yahn ya̱hn tih, ne hua dehva renda̱cá. Cuihque, te ¿dehco che ndere rehnevi fuerza yahn ya̱hn na̱n che nti?” ");
INSERT INTO cutNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ate sa̱hn che redin cuda̱do min ne, ra̱hn se: “Dihvé, cuahnecun ne che cuandi ca ya̱hn tih ta̱ma nduyo, ne nda̱hco ca̱vá ya̱hn yahn, ne cuahto ya̱hn ndah duto. ");
INSERT INTO cutNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","A huane co ndute yahn. Ate ndete che a hua co yahn ne, tuhme ca̱hcá nduhca̱ che ra̱hn ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A̱ma ro che rahte tuhno ihyan ne, quenun Dihvo vo chete a̱ma ya̱co, ricuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Min quenun a̱ma nda̱hta che a ri ntihyon ino nduyo che hua ri che ndo cua̱co te. Ruhte da̱me te, nedin a̱ma vaco chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cuahn che ndihchero Dihvo vo ta̱hn ne, cah ye ta̱hn, ne ra̱hn ye: ―Nda̱hta, a ndevahn di. Ametah chuhrihn. ");
INSERT INTO cutNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tuhme nahn ta̱h ye ta̱hn, ne ndeta̱hno ndo cua̱co te, ne cana̱n te rendeva te yavena̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ate sa̱hn ndina̱n yahn ya̱co me ne, chi ta̱n se nduco Dihvo vo yahn che din ye che ndo cua̱co ta̱hn min ro che rahte tuhno ihyan. Ra̱hn se nduco ihyan che chenun ye min: ―Va a̱n ro che din vo ntiyon. Adecodehno ro chemin chan co chi nchuhn ca̱va che din ye che ndoyahn ne, ate ndiyu ro che rahte tuhno vo. ");
INSERT INTO cutNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tuhme ndahconan Dihvo vo yahn se: ―Di ne, ¡o na̱n o chende! Ndete che chenan chiche itenine, o burro yehn chete va̱co te, ¿a hua nta̱hte ite ro che rahte tuhno ihyan ca̱va che ca̱hn te cuh te nune? ");
INSERT INTO cutNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Nda̱hta cuh ne, nda̱ta yahn Abraham ta̱hn nduhca̱ di, ne a ntihyon ino nduyo redin chundah che rechuhrihn te. ¿A hua redin yahn che ndedeváhn ta̱hn andahre ro che rahte tuhno ihyan? ");
INSERT INTO cutNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cuahn che tihca̱ ra̱hn Dihvo vo ne, a̱ma chi cuihna̱n nducoya̱ca sa̱hn che hua ri rendihche se ihyan. Ate nducoya̱ca ihyan ya̱n ne, a̱ma yeno ye yahn vederihno rahte che redin Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tuhme ra̱hn Dihvo vo: ―¿Deh nduhca̱ vederihquentiyon yahn Dendiohs? ¿Deh nduhca̱, ca̱hmá che tihca̱ vederihquentiyon yahn ye? ");
INSERT INTO cutNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Chemin ne, nduhca̱ ndute yahn mostaza che chino a̱ma se na̱n ya̱hn yahn se. Quenda̱h ndute me, ne chihta. Chi chahte nde ya̱hda redin ndahque te va̱n dune. ");
INSERT INTO cutNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Namin ra̱hn Dihvo vo: ―¿Deh nduhca̱, ca̱hmá che tihca̱ vederihquentiyon yahn Dendiohs? ");
INSERT INTO cutNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Chemin ne, nduhca̱ ya̱ yahn pa̱n che ndahcheta̱hn a̱ma nda̱hta va̱n ndeh yune pa̱n, din che chihta nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Quendi Dihvo vo cuahn ye ya̱n Jerusalén, ne rechuh ye ya̱n ca̱hya ma̱n, ya̱n rahte ma̱n, ricuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A̱ma se ne, tumerune se ihyan: ―Dihvé, ¿a ya̱hn ihyan che ndevahn ye ne? Ndahconan ye: ");
INSERT INTO cutNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Nduhca̱ che redin nun ino ihyan che conda̱ ye chendevah che tuhco ne, tihca̱ codin nun ino nchuhn che ndevahn ne. Ate rá̱hn rí nchuhn te a̱ma ya̱hn ihyan nahn ndevahn ye, ne hua co. ");
INSERT INTO cutNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cuihno che necuan a̱ma ihyan, neca̱hde ye chendevah va̱co ye ne, ndete che ura min nda̱ nchuhn ya̱hve ne: “Dihve nuhn, cona̱hne ne chendevah” ne, ihyan min ne, ndahconan ye yahn ne: “Hua rendihché nchuhn, nde hua devanó ti cochi ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tuhme andahre ca̱hma ne: “Da̱ma cheh da̱ma chih nuhn nduco ne, ne ndih che chicuahn ne ndihve yahn ya̱n va̱co nuhn”, ");
INSERT INTO cutNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ate ihyan min ne, ndahconan ye yahn ne: “A rá̱hn rí nchuhn te hua rendihché nchuhn, nde hua devanó ti cochi ne. Nchuhn ne, chihnga̱ ihyan ne. Cuavi ne ta̱n, cuahn ne va̱ne, nde hua nahn ndihcheró nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tuhme che cua̱co, cuaco nchuhn ma̱n, cheh dihyon ne ma̱n, te ndihchero ne Abraham ma̱n, Isaac ma̱n, Jacobo ma̱n, nducoya̱ca ihyan profeta ma̱n, che ndi da̱ma ye na̱n che rihquentiyon Dendiohs, ate nchuhn ne, cua̱hn chevah vatendi ne. ");
INSERT INTO cutNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Namin ndo da̱ma ihyan, ca̱ca ye numachahte iyehnse, ne cuahte ye, cheh ndah ye na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tuhme ne, na̱hn ihyan che nda̱hna̱n ye ma̱n ro cuh ne, cuahtenan ive ye, ne na̱hn ye che chenan ive ye ma̱n ne, quenda̱hna̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ura min ne, nda̱ neve sa̱hn fariseo, ne ra̱hn se ri se Dihvo vo: ―Conda̱ca ne muhn cona̱hn ne, te nahn ca̱hno Herodes ndih. ");
INSERT INTO cutNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ndahconan ye yahn sa̱hn chahn: ―Cuahn nchuhn, ne ca̱hma ne co ne yuhne min: “Condihche, u ne, rendetendá̱h vaco chihnga̱, ne redín che rendoyahn ihyan cah ma̱n ro cuh ma̱n, caviya̱n ma̱n, deman ma̱n. Tuhme cuihno dín nityon cuh yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ate va che quendí yune yáhn ma̱n ro cuh ma̱n, caviya̱n ma̱n, deman ma̱n, te ya̱n Jerusalén ne, a min va ndi che rihno se nducoya̱ca ihyan profeta. ");
INSERT INTO cutNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Nchuhn ihyan ya̱n Jerusalén, che rihno ne ihyan profeta ma̱n, reca̱h ne tu ihyan che redechuh Dendiohs ma̱n, ¡a̱ma ndeh yune ndá̱, te nahn nedin da̱má nchuhn nduhca̱ che renedin da̱ma chaco tuh da̱ya te ma̱n reche te, ate hua cahnecun ne! ");
INSERT INTO cutNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Condihche nchuhn, te ya̱co yahn ne ne, cuhnde ma̱n, ne rá̱hn rí nchuhn te ametah ndaconan ndihchero ne u nde nda̱ ro che ca̱hma ne yáhn: “Ndeva vo yavena̱n ihyan cuh che cochi ye menun Dihvo vo Dendiohs.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A̱ma ro che rahte tuhno ihyan ne, chahn Dihvo vo, cheh ye ndeva̱co a̱ma sa̱hn ndina̱n yahn sa̱hn fariseo. Combiero yahn se ne, rihno se Dihvo vo, nahn ndihchero se deh din ye. ");
INSERT INTO cutNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Min quenun a̱ma sa̱hn che ndi se cah ntito, ne chahn nda̱ se na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Tumerune Dihvo vo sa̱hn fariseo chahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n: ―¿A nihnde ca̱de che co din vo che ndoyahn ihyan cah ro che rahte tuhno ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ate hua ndahconan sa̱hn chahn. Tuhme cheta̱h ye ta̱h sa̱hn ntito me, din ye che ndoyahn se, ne ndedechuh ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chihno min ne, ra̱hn ye nduco sa̱hn chahn: ―Ndete che conda̱hnun a̱ma burro, o a̱ma itenine yahn nchuhn chete veh ico ne, ¿a hua ndetenda̱h nchuhn ite andahre ro che rahte tuhno ihyan? ");
INSERT INTO cutNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ate hua chi ndahconan sa̱hn chahn nde a̱ma ndudo. ");
INSERT INTO cutNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cuahn che ndihche Dihvo vo nduhca̱ che retenda̱hnun sa̱hn chahn na̱n che cuahte se ne, nte ye ejemplo cuh: ");
INSERT INTO cutNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ro che ya̱hve ihyan a̱ma cha nchuhn che ca̱hn ne na̱n vihco che rihneva̱co ye ne, hua cuhnde ne na̱n silla mena̱n, te dena̱n ndiya̱hve ye a̱ma ihyan che tahque redin yahn che cuhnde ye min. ");
INSERT INTO cutNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ndete che tihca̱ ne, ura che a va ne ne, ca̱hma ihyan che va̱co me co ye ndih: “Cuavi ne ta̱n, cuhnde amigo yáhn.” Tuhme cora vedecuihno yahn ne, ne necuan ne ca̱hn ne cuhnde ne na̱n che rahte ihyan che denda̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cuahn che ya̱hve ihyan ndih ne, tahque ndah cuahn ne, cuihnde ne na̱n silla che rahte ihyan che denda̱h, ne cuahn che nda̱ ihyan che va̱co ne, ca̱hma ye nduco ne: “Amigo, cuihnde na̱n silla mena̱n.” Tihca̱ quenda̱h yavena̱n ne na̱n ihyan che vate ye min. ");
INSERT INTO cutNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tihca̱, te ihyan che rendeva ma̱n ye yavena̱n ye ne, nuhnde ndiya ye, ne ihyan che necun ye ne, cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Namin ra̱hn Dihvo vo nduco sa̱hn fariseo che va̱co me: ―Cuahn che yahve ihyan ca̱va che cah, cheh ye ne, hua yahve amigo yehn ma̱n, dihne ma̱n, ihyan yehn ma̱n, ihyan cuihca che vate ye nino ndevaque ma̱n, te ihyan chahn ne, co nda̱hco menun ye yehn. ");
INSERT INTO cutNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cuahn che cah, cheh ihyan ne, tahque ndah coyahve ihyan cheva̱h ma̱n, ihyan che ndi cheche ye ma̱n, ihyan che cueh ca̱h ye ma̱n, ihyan che ve na̱n ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ndete che tihca̱ din ne, ndah ro yehn, te ihyan chahn ne, hua co nda̱hco menun ye yehn. Ate cuahn che ndedetuhche Dendiohs tena̱hn che ndah ihyan ye na̱n ye ne, ro min nda̱hco menun Dendiohs yehn. ");
INSERT INTO cutNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Chihnevan a̱ma sa̱hn che nduco se va se reh se, ne ra̱hn se ri se Dihvo vo: ―Ndah ro yahn ihyan che cuahte ye cheh ye na̱n che rihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tuhme nte Dihvo vo ejemplo cuh: ―A̱ma ihyan ne, ya̱hve ye a̱ma ya̱hn se che ca̱hn se cheh vino se ndeva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ura che a quendihte mesa ne, dechuh ye sa̱hn deca̱hya yahn ye che ca̱hma se nduco sa̱hn chahn: “Ca̱hn nchuhn, te a va ya̱n nducuahn.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ate nducoya̱ca se ne, cana̱n chica se che din chahtino ye yahn se. A̱ma se ne, ra̱hn se: “Cade cá a̱ma ndi ya̱hn, ne va che cá̱hn ndihcheró. Cahme co ihyan, ne din chahtino ye yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ta̱ma se ne, ra̱hn se: “Cá uhn ya̱nda itenine ruhnya̱hn, ne va che cá̱hn ndihchenán ite na̱n ntiyon. Cahme co ihyan, ne din chahtino ye yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ta̱ma se ne, ra̱hn se: “Cade chihneva̱có, ne chemin che cahme co ihyan te hua co cá̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ndaconan sa̱hn deca̱hya me, ne neco se dihve se nduhca̱ che ra̱hn sa̱hn chahn. Chi ta̱n dihve se, ne ra̱hn ye ri ye sa̱hn deca̱hya me: “Cuehn tenun tenun no cua̱hn ndihve ma̱n, cua̱hn yune ma̱n, ne ihyan cheva̱h ma̱n, ihyan che ndi cheche ye ma̱n, ihyan che cueh ca̱h ye ma̱n, ihyan che ve na̱n ye ma̱n, quenda ihyan muhn ndeva̱có.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cuahn che ndaconan sa̱hn deca̱hya me ne, ra̱hn se: “Dihvé, a dináhn che ra̱hn ne, ate va ca na̱n che cuahte ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ra̱hn dihve se ri ye sa̱hn: “Cuehn cua̱hn yune ma̱n, tinduh cua̱hn chihto ma̱n, ne codin fuerza ihyan che chi ye ca̱va che cuto ihyan va̱có. ");
INSERT INTO cutNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Rá̱hn te nde a̱ma sa̱hn che ya̱hvé mena̱n ne, hua cheh vino se che ndihcoyá̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A̱ma ya̱hn ihyan cuahn ye nduco Dihvo vo. Chaconan ye, ne ra̱hn ye ri ye ihyan chahn: ");
INSERT INTO cutNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Adecoduhno ihyan che nahn conduco ye u ne, va che ca̱hcoma̱n ye chida ye ma̱n, chaco ye ma̱n, nda̱hta yahn ye ma̱n, da̱ya ye ma̱n, dihno ye ma̱n, cahve ye ma̱n, vida yahn ma̱n ye ma̱n, ca̱va che co conduco ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ihyan che hua nahn chuhrihn ye ca̱va u ne, hua co conduco ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Adecoduhno nchuhn che ca̱hno ne a̱ma vah, ¿a hua dinoca retenda̱h cuande ne ta̱va nahn ca̱va che tuno vah me? ");
INSERT INTO cutNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ndete che ca̱hco ne name yahn vah me, ate hua cocha ne tuno ne, nducoya̱ca ihyan che ndihche ye ne, ca̱hyon nan ye, ");
INSERT INTO cutNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ne ca̱hma ye: “Sa̱hn tih ne, cana̱n rihno se a̱ma vah, ne hua chicha se tuno.” ");
INSERT INTO cutNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Namin a̱ma rey che va che ca̱hn ye cuhma ye nduco ta̱ma rey, ¿a hua dinoca rihnde ye, rendedecadino ye ndete che nduco ndiche mil sanda̱do yahn ye cocha ye cuhma ye nduco ta̱ma rey che cochi ye nduco ndico mil sanda̱do? ");
INSERT INTO cutNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Me ndete che rihn che hua cocha ye ne, cuahn che yahn ca cochi rey che cuhma nduco ye ne, dechuh ye sa̱hn che ca̱hn se menun ye, ca̱hma se nduco rey min ca̱va che cuhnde dihn ye, ne hua cuhma ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tihca̱, te adecoduhno nchuhn che hua ca̱hcoma̱n ne nducuahn yahn ne che va ne, hua co conduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ima ne, ndah. Ate ndete che cuihno dine yahn ne, ¿dehra nduco ndo dine? ");
INSERT INTO cutNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Va che cora, te hua cochihve, nde ca̱va che cota̱ve ndiya̱hn, nde ca̱va che cuahto duto chenda̱ta. Nducoya̱ca nchuhn, ¡cuendedecadino ndah ne deh conahn ejemplo cuh! ");
INSERT INTO cutNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Rahn nducoya̱ca sa̱hn rica tumeca̱diyo ma̱n, sa̱hn nunde chena̱hn ma̱n, na̱n Dihvo vo che nahn cahnevan se ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yahn chemin che ri yudo yahn sa̱hn fariseo ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ne ra̱hn se yahn Dihvo vo: ―Sa̱hn tih ne, rinduco se sa̱hn nunde, ne reh se da̱ma nduco se. ");
INSERT INTO cutNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tuhme nte Dihvo vo ejemplo cuh nduco sa̱hn chahn: ");
INSERT INTO cutNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ndete che a̱ma cha nchuhn va a̱ma ciento itecuche yahn ne, me ndete che conda a̱ma te ne, ¿a hua ca̱hcoma̱n ne ite che cun raco ntihyon cun chahn viya̱ta, ne ca̱hn ne, quenuhn ne ite che chinda me, nde na̱n che nta̱ca ne ite? ");
INSERT INTO cutNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cuahn che a nta̱ca ne ite ne, numacuahn vedeyeno tihde dihme ne ite, ndiquenda ne ite. ");
INSERT INTO cutNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cuahn che nta̱ ne ne, nedin da̱ma ne ihyan nino ndeva̱co ne ma̱n, ihyan rendihche ne ma̱n, ne ca̱hma ne nduco ye: “Cuahte yeno vo nduco nchuhn, te itecuche yáhn che chinda te ne, a nta̱cá ite.” ");
INSERT INTO cutNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Rá̱hn rí nchuhn te tihca̱ tahque cuhnde vedeyeno vahchetero ca̱va a̱ma ihyan nunde che nto ino ye nunde yahn ye che co ca̱va cun raco ntihyon cun ihyan che ra̱hco ye che nde hua nahn che nto ino ye. ");
INSERT INTO cutNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Ndete che a̱ma nda̱hta che va ndiche tume diya̱hngua yahn te, ne conda a̱ma ne, ¿a hua nahn ya̱hn te candil, ndache te vah, nuhn te tume me nde na̱n che nta̱ca te? ");
INSERT INTO cutNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Cuahn che nta̱ca te ne, nedin da̱ma te ihyan nino ndeva̱co te nduco ihyan rendihche te, ne ca̱hma te co te ihyan: “Cuahte yeno vo nduco nchuhn, te a nta̱cá tume yáhn che chinda.” ");
INSERT INTO cutNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Rá̱hn rí nchuhn te tihca̱ co yeno ángel yahn Dendiohs ca̱va a̱ma ihyan nunde che nto ino ye nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Quendi Dihvo vo, ne nte ye ta̱ma ejemplo: ―A̱ma nda̱co ne, chahte o da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sa̱hn che ive me ne, ra̱hn se ri se chida se: “Chidá, te ne vedecuihca che va che ca̱hco ne yáhn.” Tuhme cahma̱hn chida se vedecuihca yahn ye, ne ca̱h ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chihno neve ro ne, chihcoya̱n se dehtenduh yahn se, ne cuahn se na̱n ya̱hn yahn. Min chihno toh se tume yahn se, ndere quechica se. ");
INSERT INTO cutNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cuahn che a chihno toh se tume yahn se ne, a̱ma chihnde cuico ya̱hn na̱n che quenan se, ne cana̱n a̱ma yah chahno se. ");
INSERT INTO cutNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chica se ntiyon din se a̱ma ihyan che ya̱n va̱co ye min, ne dechuh ye sa̱hn, din se cuda̱do cuche yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nde dehtenduh dima che reh cuche chahn a̱ma nahn cheh se, ate nde dehtenduh chemin chan, hua renda̱ca reh se. ");
INSERT INTO cutNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Tuhme neca̱hco se, ne ndedecadino se: “A̱ma ya̱hn ihyan redin ntiyon chenan ye va̱co chidá, ne a̱ma va che reh ye. Me u ne, muhn quenán, adeche coh cuicó. ");
INSERT INTO cutNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tahque ndah che ná̱hn yahn chidá, ne ca̱hmá có ihyan: Chidá, quendihcó nunde, nde na̱n Dendiohs, nde na̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ametah redin yahn che ca̱hma ne da̱ya ne yáhn. Ma̱n ne, có nduhca̱ a̱ma mozo yahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tuhme ndonun yune se, cona̱hn se yahn chida se. ’Yahn ca va che nta̱ se, ne ndihchero chida se sa̱hn. Quenan va̱hino ye sa̱hn, ne chahn ye rano ye, chahtema̱hn ye sa̱hn, tena̱n ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ra̱hn se ri se ihyan: “Chidá, quendihcó nunde, nde na̱n Dendiohs, nde na̱n ne. Ametah redin yahn che ca̱hma ne da̱ya ne yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ate chida se ne, ra̱hn ye ri ye sa̱hn deca̱hya yahn ye: “Tenun tenun no cuetenda̱h nchuhn tino che tahque ndah, conun se ma̱n, chineta̱h che conun ta̱h se ma̱n, nda̱co che conun ca̱h se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cuahn nchuhn, ngua ne a̱ma itenine che vihche te, ne cuihno ne ite. Chuh vo ite, ne din vo vihco, ");
INSERT INTO cutNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","te sa̱hn da̱yá cuh ne, a ndih se che ra̱hcó, ate ma̱n ne, ndaconan se. A dendá sa̱hn, ate ma̱n ne, a nta̱cá sa̱hn.” Tuhme cana̱n ihyan chahn vihco vedeyeno. ");
INSERT INTO cutNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Sa̱hn da̱ya ye che mena̱n me ne, quenan se viya̱ta, ne cuahn che nta̱ nino se ndevah ne, chihnevan se che retive ihyan ma̱n, rendeh ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tuhme cah se a̱ma sa̱hn deca̱hya yahn chida se, ne tumerune se sa̱hn deh che ri min. ");
INSERT INTO cutNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ndahconan se: “A nta̱ sa̱hn dihno ne, ne hua dehva chahno se chi. Chemin che chihquentiyon chida ne che coh a̱ma itenine che vihche te.” ");
INSERT INTO cutNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Chi ta̱n sa̱hn che mena̱n me, nde hua nahn ndonda̱ se vah. Tuhme quenda̱h chida se, chica ye favor sa̱hn che ndonda̱ se vah. ");
INSERT INTO cutNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ate ndahconan se yahn ye: “U ne, cuahn da̱ma redín ntiyon nduco ne, ne hua rahcotá̱hn yahn ne. Nde a̱ma yune hua te ne amare a̱ma chiva̱to lihn ca̱va che cheh yenó nduco amigo yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ate cuahn che ndaconan sa̱hn da̱ya ne tih che ndere toh se tume yahn ne nduco nda̱hta che ndere vatechica te ne, chihquentiyon ne che chih a̱ma itenine vihche ca̱va se.” ");
INSERT INTO cutNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Tuhme ndahconan chida se: “Da̱yá, di ne, cuahn da̱ma quenen nducó, ne nducuahn dehtenduh yáhn ne, a yehn. ");
INSERT INTO cutNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ate nda̱hca̱ che ca̱h yeno vo chedave yuhn vo, din vo a̱ma vihco vedeyeno, te sa̱hn dihne ne, a ndih se che ra̱hcó, ate ma̱n ne, nta̱ se. A denda vo sa̱hn, ate ma̱n ne, nta̱ca vo sa̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Namin nte Dihvo vo ejemplo cuh nduco ihyan apóstol yahn ye: ―Chihnde a̱ma ihyan cuihca che quenan a̱ma sa̱hn che redin se cuda̱do ntiyon yahn ye, ne chahn ihyan nuhnde ye sa̱hn na̱n ye che ndere reta̱h se dehtenduh yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Tuhme cah ye sa̱hn, ne ra̱hn ye ri ye sa̱hn: “¿Deh chu che renuhnde ihyan di ná̱n? Cuente cuende u yahn ntiyon che quenen, te cahneví ntiyon che va tah.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tuhme ndedecadino se: “¿Ta̱ca̱ dín ma̱n?, te dihvé ne, cahnevi ye ntiyon che va tá̱h. Hua co dín ntiyon dito, ne ndete che ndere ca̱cá chéh ne, cuihná̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A nta̱ tín ta̱ca̱ dín ca̱va che nevahnecun ihyan u va̱co ye cuahn che a cahnevi dihvé ntiyon che va tá̱h.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tuhme cah se queri a̱ma ihyan che chendihco ye yahn dihve se. Tumerune se a̱ma ye: “¿Ta̱va quendihque yahn dihvé ne?” ");
INSERT INTO cutNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ndahconan ihyan min yahn se: “A̱ma ciento barril aceite quendihcó yahn ye.” Ra̱hn se ri se ihyan: “Ti va niyon che quenan ca̱ca. Cuihnde, ne menchahte no cuahconehn caque o raco ndiche.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Chihno min ne, tumerune se ta̱ma ye: “Di, ¿ta̱va quendihque yahn dihvé ne?” Ndahconan ye yahn se: “Quendihcó a̱ma ciento ca̱de trigo yahn ye.” Tuhme ra̱hn se ri se ihyan: “Nga̱ ca̱ca yehn. Cuahconehn cun raco.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Cuahn che checadino dihve ntiyon me ne, ndeva ye yavena̱n sa̱hn min che ndere reta̱h se dehtenduh yahn ye, yahn che a̱ma vivo se. Tuhme ra̱hn Dihvo vo: ―Ma̱n ro cuh ne, ihyan nunde ne, tahque vivo ye che co ihyan che riquendi ye vederihquentiyon Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Chemin che rá̱hn rí nchuhn: Cotoh ne vedecuihca andahre chihnga̱, ne nduco chemin nda̱ca amigo yahn ne, ca̱va che nda̱ ro che coh ne ne, co cuahtenan ne vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Ihyan che hua reduco ye va̱n tah sihn che redin ye cuda̱do ne, namin hua reduco ye andahre che ndeh, ne ihyan che reduco ye va̱n tah sihn che redin ye cuda̱do ne, namin reduco ye ndete che ndeh. ");
INSERT INTO cutNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ndete che hua toh nchuhn vedecuihca che va ta̱h ne ca̱va che din ne che ndah ne, ¿duhra te ntiyon yahn Dendiohs, din ne? ");
INSERT INTO cutNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ndete che hua redin nchuhn cuda̱do dehtenduh yahn ihyan che rihco ye ta̱h ne ne, ¿duhra te dehtenduh che co yahn ma̱n ne? ");
INSERT INTO cutNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nde a̱ma ihyan hua co conan cuma ye o dihve ye, te tahque din yahino ye a̱ma che co ta̱ma, ne quendi ye nduco a̱ma, ne ca̱hcoma̱n ye ta̱ma. Hua co din yahino nchuhn Dendiohs ndete che yahino ne vedecuihca. ");
INSERT INTO cutNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Rihnevan sa̱hn fariseo che chenun se min che tihca̱ rente Dihvo vo, ne riyon nan se ihyan, te yahino se vedecuihca. ");
INSERT INTO cutNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tuhme ra̱hn ye ri ye sa̱hn: ―Nchuhn ne, redin ca̱ ne che ndah ihyan ne na̱n ihyan. Ate Dendiohs ne, a devano ye duh ihyan nchuhn. Va deh che a̱ma richihve che ra̱hco ihyan, ate na̱n Dendiohs ne, hua richihve. ");
INSERT INTO cutNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Ley che dirun Moisés nduco ndudo che dirun ihyan profeta ne, chihnde nde nda̱ ro che nda̱ Jua̱n Bautista. Nde ta̱hn min ne, rahndudo ihyan yahn vederihquentiyon yahn Dendiohs, ne a̱ma ya̱hn ihyan redin nun ino ye che nahn dinahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Tahque nun nto iyehnse che co che cuavi a̱ma chenelihn na̱n vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Adecoduhno ihyan che tehche ye nda̱hta yahn ye, ne cahneva̱co ye nduco ta̱ma te ne, din duche yahn ye che nihneva̱co ye. Namin ihyan che cahneva̱co ye nduco a̱ma ta̱hn che ntehche incha̱hn te ta̱hn ne, din duche yahn ye che nihneva̱co te. ");
INSERT INTO cutNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Namin nte Dihvo vo ejemplo cuh: ―Chihnde a̱ma sa̱hn cuihca che renun se dema̱n cuahno tino ndah, ne a̱ma va dema̱n cuahno che ndah reh se ro ro. ");
INSERT INTO cutNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ta̱hn min ne, namin chihnde a̱ma ihyan cheva̱h che duche ye Lázaro, ne a̱ma ndechendih yute ihyan. Quendite ye chendevah yahn sa̱hn cuihca me, ");
INSERT INTO cutNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ne a̱ma nahn cheh ye andahre da̱che che ra ma̱n mesa yahn se. Nde ya̱hna renda̱ te, riyavenan te na̱n yah yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cuahn che nda̱ ro che chih ihyan cheva̱h me ne, quenda ángel ihyan vahchetero, ne min quenan Abraham. Adive ne, chih sa̱hn cuihca me, ne chihche ihyan sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Cuahn che rechuhrihn se va̱n ruchiya̱hn ne, chenihyon na̱n se, ne a̱ma yahn ndihchero se Abraham. Namin ndihchero se Lázaro che quenan ye min. ");
INSERT INTO cutNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tuhme cah se: “Chidá Abraham, conan va̱hino ne u. Cuedechuh ne Lázaro, deca̱hnda ye tin nduteta̱h ye va̱n nune, ca̱va che ndedevan ye chihyá, te a̱ma rechuhríhn muhn va̱n ruchiya̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ndahconan Abraham yahn se: “Da̱yá, cuenecahque te a̱ma nda̱hca̱ chehne cuahn che quenen iyehnse, ate Lázaro ne, a̱ma yah chahno ye. Ma̱n ne, a̱ma nda̱hca̱ quenan ye muhn, ate di ne, rechuhrihn ta̱n na̱n che quenon. ");
INSERT INTO cutNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ava̱ne ne, a nihnde ca̱de che ihyan che chenan ye muhn, andahre nahn ca̱hn ye ta̱n, ate hua co chuh ye. Namin ihyan che chenun ye ta̱n ne, hua co chuh ye, chi ye muhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tuhme ra̱hn sa̱hn cuihca me: “Chidá Abraham, ricá ndih, codin ne favor, cuedechuh ne Lázaro che ca̱hn ye va̱co chidá, ");
INSERT INTO cutNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","co ye uhn sa̱hn dihnó che vate se min, ca̱va che hua chi se muhn na̱n che rechuhrihn ihyan nunde.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ra̱hn Abraham ri ye sa̱hn: “Min va ley che dirun Moisés ma̱n, ndudo che dirun ihyan profeta ma̱n, rahndudo ihyan. A ndudo min va che dinahn se.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tuhme ra̱hn sa̱hn cuihca me: “Chidá Abraham, hua retumaca̱h se yahn chemin. Ate ndete che ntuche a̱ma ihyan che a ndih ye, ca̱hn ye, ya̱hve ye sa̱hn ne, tuhme che cua̱co, nto ino se nunde yahn se.” ");
INSERT INTO cutNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ate ra̱hn Abraham ri ye sa̱hn cuihca me: “Ndete che hua ritahno se yahn che dirun Moisés nduco che dirun ihyan profeta ne, namin hua cotahno se, andahre che ntuche a̱ma ihyan che a ndih ye, ca̱hn ye, ya̱hve ye sa̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―A ca̱de no che va dehtenduh che din che cuahtendihco ihyan nunde, ate ¡yah rí ca̱va adecoduhno ihyan che din ye che cuahtendihco ihyan chena̱hn nunde! ");
INSERT INTO cutNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tahque nda̱hca̱ ca̱va ihyan min che dechiche ihyan a̱ma tu yudo da̱ndo ye, ne cuaconda̱hnun ye ihyan va̱n nuniya̱hn, che co che din ye che condihco a̱ma cha ihyan chuhn che necun ye nunde. ");
INSERT INTO cutNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuihco nchuhn cuda̱do. ’Cuahn che din ta̱n a̱ma ihyan nduco nchuhn ne, coya̱hve ne ihyan nduco ndah. Ndete che nto ino ye che tihca̱ din ye ne, cuenchahco ne yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Andahre ndache yune che a̱ma ro din ta̱n a̱ma ihyan nduco nchuhn, ate ndete che namin ndache yune rendaconan ye, ne ra̱hn ye: “Yah rí che tihca̱ dín”, tuhme ne, cuenchahco ne yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ihyan apóstol ne, ra̱hn ye ri ye Dihvo vo: ―Cuenan ne nuhn ca̱va che cotahno ndah nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Ndete che ritahno nchuhn amare tah sihn, co ca̱hcantiyon ne ya̱hn tih: “Cuavi ta̱n, cuehn, cuandi va̱n nuniya̱hn”, ne dinahn yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Ndete che va a̱ma mozo yahn nchuhn che ruhn se ya̱hn, o redin se cuda̱do itenine, ura che ndaconan se che chahn se viya̱ta, ¿a ndeta̱hno ca̱hma ne co ne sa̱hn tuhca̱?: “Cuechoh, cuihnde na̱n mesa, cheh.” ");
INSERT INTO cutNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿A ndiyu tahque ndah che ca̱hcantiyon ne sa̱hn tuhca̱?: “Cuedendah comida, cuihqueyan na̱n mesa, cuihque cuda̱do nahmin che cheh vinó. Cuihno cheh vinó, tuhme cheh vine.” ");
INSERT INTO cutNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Cuihno din se nducuahn che chihquentiyon ne, ¿a va che neca̱h ne nundihve cuahn sa̱hn ne? Hua. ");
INSERT INTO cutNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Namin cuahn che a cuihno din nchuhn nducuahn che a va ca̱de che din ne ne, tahque ndah che ca̱hma ne co ne Dihve ne: “Nuhn ne, mozo nuhn. Nde hua nahn che nte ne nundihve cuahn nuhn, te atena̱n ntiyon che chihquentiyon ne ne, a chemin no che din nuhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cuahn che cuahn Dihvo vo ya̱n Jerusalén ne, chuh ye na̱n che rivah esta̱do yahn Galilea nduco nación yahn Samaria. ");
INSERT INTO cutNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ura che a nda̱ nino ye a̱ma ya̱n lihn ne, nda̱ ndiche sa̱hn che ndi se cah che recha̱ yute. ");
INSERT INTO cutNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Cah se: ―Dihve nuhn, Jesús, ¡conan va̱hino ne nuhn! ");
INSERT INTO cutNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Cuahn che ndihchero ye sa̱hn chahn ne, ra̱hn ye ri ye sa̱hn: ―Cuahn nchuhn na̱n chidocuya̱n. Dinahn sa̱hn chahn, ne nahmin che cuahn se ne, ndoyahn nducoya̱ca se. ");
INSERT INTO cutNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tuhme a̱ma se ne, cade ndihchero se che a ndoyahn se ne, ndaconan se, ne a̱ma rendeva se yavena̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chehntihya se numacuahn vedenecun na̱n Dihvo vo, ne neca̱h se nundihve cuahn ihyan. Sa̱hn min ne, sa̱hn ta̱ma nación se. Samaria nación yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Tuhme tumerune Dihvo vo: ―¿A ndiyu ri ndiche sa̱hn chahn che ndoyahn se? ¿Tiya sa̱hn che nun chahn? ");
INSERT INTO cutNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿A dema̱n sa̱hn ta̱ma nación cuh che ndaconan se, ndeva se yavena̱n Dendiohs? ");
INSERT INTO cutNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Chihno min ne, ra̱hn ye ri ye sa̱hn: ―Dehve rahque. Cuenecuen. Conahn, te nducote chitehne ne, a ndoyehn. ");
INSERT INTO cutNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tumerune sa̱hn fariseo Dihvo vo ticua̱hn cuana̱n vederihquentiyon yahn Dendiohs, ne ndahconan ye yahn se: ―Vederihquentiyon yahn Dendiohs ne, hua cuana̱n nduhca̱ che chenan rino nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nde a̱ma ihyan hua co ye nchuhn: “Muhn va”, o “min va”, te Dendiohs ne, a nda̱hco ca̱de ye vederihquentiyon yahn ye va̱n nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ―U che rinducó nducoya̱ca ihyan ne, nda̱ ro che a̱ma nahn nchuhn che ndaconán, ate hua nda̱ca ndihchero ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ndere ca̱hma ihyan co ye nchuhn: “Nga̱ ihyan che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse, quenun ye muhn”, o “nga̱ ye, quenan ye min.” Hua tumeca̱h nchuhn, nde hua ca̱hn ne, ndihchero ne. ");
INSERT INTO cutNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Chemin che rí nchuhn te nduhca̱ che rendihchero ihyan che riya cuah, ri ro dave numachahte ne, tihca̱ ndihchero ihyan u che rinducó nducoya̱ca ihyan, ro che ndá̱. ");
INSERT INTO cutNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ate dinoca va che a̱ma chuhríhn, te ihyan che vate ye ma̱n ro cuh ne, hua co ndihche ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nduhca̱ che chahno ihyan chi ro che quenan Noé iyehnse ne, tihca̱ cuahno ihyan co ro che u che rinducó nducoya̱ca ihyan, ndá̱. ");
INSERT INTO cutNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ihyan che vate ye ro min ne, reh ye ma̱n, rih ye ma̱n, rihneva̱co ye ma̱n, redeca̱hnova̱co ye ma̱n, nde nda̱ ro che chenda̱ Noé chete arca, ne chan cona̱hn, chito nune iyehnse, chihno chih ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Atihnoca̱ chi cuahn che quenan Lot iyehnse. Ihyan che vate ye ro min ne, reh ye ma̱n, rih ye ma̱n, ra ye ma̱n, rendihcue ye ma̱n, rino ye nda̱ta ma̱n, rihno ye vah ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ate nda̱ ro che chica Lot ya̱n Sodoma ne, chera ya̱hn che chica na̱n ro, ne chihno chih ihyan ya̱n min. ");
INSERT INTO cutNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Tihca̱ co ro che u che rinducó nducoya̱ca ihyan, ndá̱. ");
INSERT INTO cutNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nda̱ ro min ne, ihyan che vate ye tin vah yuto ne, tahque ndah che hua conda̱ ye chete vah, cota̱h ye dehtenduh yahn ye. Namin ihyan che chenun ye viya̱ta ne, tahque ndah che hua ndaconan ye viya̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cueneca̱hco nchuhn nduhca̱ che chahno chi ihyan nda̱hta yahn Lot. ");
INSERT INTO cutNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Adecoduhno ihyan che nahn ndedevahn ma̱n ye ihyan ne, ihyan min ne, conda ye, ne adecoduhno ihyan che ca̱hco menda̱hn ye ihyan, coh ye ca̱va u ne, ihyan min ne, ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Rá̱hn rí nchuhn te vino min ne, adecotino che vateya̱do o ihyan na̱n yundo ne, a̱ma ye ne, quendá ihyan, ne ta̱ma ye ne, ca̱hcomá̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Namin adecotino che chenun o ihyan nda̱hta, rengu ye ne, a̱ma ye ne, quendá ihyan, ne ta̱ma ye ne, ca̱hcomá̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Adecotino che chenan o se viya̱ta ne, a̱ma se ne, quendá sa̱hn, ne ta̱ma se ne, ca̱hcomá̱n sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tuhme tumerune ihyan chahn: ―Dihve nuhn, ¿ti che conahn chemin ne? Ndahconan Dihvo vo yahn ye: ―Adecotino che vate ihyan nunde ne, a min va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nte Dihvo vo a̱ma ejemplo, chihnevan ihyan chahn, ca̱va che cadino ye te va che cova̱h ye cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ra̱hn ye: ―A̱ma cua̱n ya̱n ne, chihnde a̱ma juez che nde hua ritahno se Dendiohs, nde hua retumaca̱h se yahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Namin chihnde a̱ma nda̱hta va̱h ya̱n min, ne ndeh yune rahn te na̱n juez min, ne ra̱hn te: “Cochí rica nundé yahn a̱ma ihyan che hua ri rendihche ye u.” ");
INSERT INTO cutNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Chuh ro, ne hua tumeca̱h juez me, techeca̱de se yahn te. Ate adive ne, ndedecadino se: “Andahre hua ritahnó Dendiohs, nde hua retumacá̱h yahn ihyan, ");
INSERT INTO cutNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ate nducote ta̱hn nda̱hta va̱h tih a̱ma renda̱ te redenduh te u ne, techeca̱dé yahn te, ca̱va che hua quendi te denduh te u.” ");
INSERT INTO cutNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tuhme ra̱hn Dihvo vo: ―Cuihco nchuhn cuda̱do nduhca̱ che ndedecadino juez me, andahre duhtuno ihyan se. ");
INSERT INTO cutNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿A ndiyu tahque nun conan Dendiohs ihyan che a tenda̱hnun ye? Dendiohs ne, hua rechuhrihn ye, andahre nde ro nde ra̱hn, reva̱h ihyan na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cua̱co rá̱hn rí nchuhn te Dendiohs ne, nun conan ye ihyan yahn ye. U che rinducó nducoya̱ca ihyan ne, ¿a nda̱cá ihyan che ritahno ye u ro che ndá̱ ne? ");
INSERT INTO cutNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nte Dihvo vo ejemplo cuh ca̱va ihyan ya̱de che renda̱hchenan ye ihyan chena̱hn. Ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―O se ne, chenda̱ se chete ya̱co, cova̱h se. A̱ma se ne, sa̱hn fariseo, ne ta̱ma se ne, sa̱hn rica tume ca̱de iyo. ");
INSERT INTO cutNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Sa̱hn fariseo me ne, chandi se reva̱h se tuhca̱: “Dendiohs, nundihve cuahn ndih che din ne che u ne, ndiyu nduhca̱ ihyan chena̱hn, te rahtendihco ye nunde ma̱n, reduco ye ma̱n, redin duche yahn ye che nihneva̱co ye ma̱n. U ne, ndiyu nduhca̱ sa̱hn rica tume ca̱de iyo tih. ");
INSERT INTO cutNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","U ne, o yune rihnde ya̱hté che a̱ma ndate, ne rihcó riya yahn nducuahn che va yáhn na̱n ne, nduhca̱ che a ndihco ca̱de ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ate sa̱hn rica tume ca̱de iyo me ne, nde hua rihquino se ca̱hn nda̱ se na̱n ta, nde hua nahn ndonihyon na̱n se yahn che cuihna̱n se. Chendih se, chahn se ticua se, ne ra̱hn se: “Dendiohs, ¡cuenan va̱hino ne u!, te a̱ma quendihcó nunde na̱n ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Cua̱co rá̱hn rí nchuhn te sa̱hn che necun me ne, a nchahco Dendiohs yahn se, ne cona̱hn se. Ate sa̱hn che ya̱de me ne, hua nta̱ca se vederenchahco. A tihca̱ va ca̱de, te adecoduhno ihyan che rendeva ma̱n ye yavena̱n ye ne, co cuihna̱n ye na̱n Dendiohs, ne adecoduhno ihyan che necun ye ne, ndeva Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A̱ma ro ne, nda̱ ihyan, nda ye checa̱hya yahn ye ca̱va che nahn ta̱h Dihvo vo, cova̱h ye ca̱va. Ate ihyan apóstol ne, hua nahn ca̱h yune ye che ca̱hn nda̱ ihyan chahn na̱n Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Tuhme cah Dihvo vo ihyan apóstol chahn na̱n ye, ne ra̱hn ye: ―Hua ca̱hdenun nchuhn yune yahn checa̱hya che chi ná̱n, te dema̱n ihyan che necun ye nduhca̱ checa̱hya sih renevahnecun ye che rihquentiyon Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Cua̱co rá̱hn rí nchuhn te adecoduhno ihyan che hua necun ye nduhca̱ checa̱hya ne, hua co nevahnecun ye vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A̱ma sa̱hn ndina̱n ne, tumerune se Dihvo vo: ―Ihyan Ricuahn Ndah, ¿deh va che dín ca̱va che conán vahchetero numacuahn ro ne? ");
INSERT INTO cutNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ndahconan ye: ―¿Dehco che rahn che ndah u? Metah nde a̱ma ihyan che ndah ye, atena̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A devene vederihquentiyon yahn Dendiohs: “Hua cahne ihyan. Hua din doche yehn che nihnevaque. Hua doque. Hua cahme ndudo cuahnde. Cuendeva yavena̱n chide ma̱n, cheque ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ra̱hn se ri se ihyan: ―Nducuahn vederihquentiyon cuh ne, redináhn nde ro che lihn u. ");
INSERT INTO cutNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Chihnevan Dihvo vo che tihca̱ ra̱hn se, ne ra̱hn ye ri ye sa̱hn: ―Va ca ta̱ma na̱n che va che din. Condihcue nducuahn che va yehn, ne cuinen ihyan cheva̱h ca̱va che co conen vahchetero. Tuhme cochi, condoque u. ");
INSERT INTO cutNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cuahn che chihnevan se che tihca̱ ra̱hn ye ne, a̱ma chi nda̱che se, te a̱ma cuihca se. ");
INSERT INTO cutNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ndihchero Dihvo vo che a̱ma chi nda̱che se, ne ra̱hn ye: ―Ihyan cuihca ne, ¡a̱ma va̱hche ca̱va ye che nevahnecun ye che rihquentiyon Dendiohs ihyan! ");
INSERT INTO cutNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nde hua co nevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ihyan che chihnevan ye che tihca̱ ra̱hn Dihvo vo ne, ra̱hn ye: ―¿Duhra ihyan co ndevahn ye tuhme? ");
INSERT INTO cutNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ndahconan Dihvo vo yahn ye: ―Nducuahn che hua co din ihyan ne, Dendiohs ne, ri redin ye. ");
INSERT INTO cutNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tuhme ra̱hn Pedro: ―Ndihche ne, a chihcoma̱n nuhn nducuahn che va yahn nuhn, ne chinduco nuhn ndih. ");
INSERT INTO cutNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te adecoduhno ihyan che rihcoma̱n ye a va̱co ye ma̱n, a indihte yahn ye ma̱n, a dihno ye ma̱n, a ihyan nda̱hta yahn ye ma̱n, a da̱ya ye ma̱n, ca̱va che co nevahnecun ye che rihquentiyon Dendiohs ihyan ne, ");
INSERT INTO cutNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ihyan min ne, tahque ndeh ca nuhnde menun yahn ye ma̱n ro cuh, ne adive ne, conan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nedin da̱ma Dihvo vo nduh che ndichio ihyan apóstol yahn ye, ne ra̱hn ye ri ye ihyan: ―Ma̱n ne, cuhn vo nduco nchuhn ya̱n Jerusalén. U che rinducó nducoya̱ca ihyan ne, min va che chuhríhn nduhca̱ che dirun ihyan profeta nde ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Neca̱h ihyan u ta̱h sa̱hn ta̱ma nación, din duche yahn se u ma̱n, din ta̱n se nducó ma̱n, ca̱hnan dan se u ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Cuihno cuahn se u ne, ca̱hno se u. Ate cuihno ino ro ne, ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ihyan chahn ne, hua chenahn ye che tihca̱ ra̱hn Dihvo vo, te va̱hche ri yahn ye ca̱va che conahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ura che cuahn nino Dihvo vo ya̱n Jericó ne, a̱ma sa̱hn na̱n ve ne, va se chihto yune, rica se che din ihyan vedeva̱hino nduco se. ");
INSERT INTO cutNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nducote a̱ma rechuh ihyan yune ne, tumerune se deh ri. ");
INSERT INTO cutNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ra̱hn ihyan ri ye sa̱hn: ―A ta̱n cochi Jesús yahn ya̱n Nazaret. ");
INSERT INTO cutNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tuhme ra̱hn se numa dito se: ―Jesús, Da̱ya David, ¡conan va̱hino ne u! ");
INSERT INTO cutNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ihyan che nda̱hna̱n ye ne, ra̱hn ye ri ye sa̱hn che cuhnde dihn chende se. Ate nde tahque yudo na̱n se ra̱hn se: ―Da̱ya David, ¡conan va̱hino ne u! ");
INSERT INTO cutNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tuhme chandi Dihvo vo, ne tahve ye che chehua sa̱hn. Cuahn che nda̱ se na̱n ye ne, tumerune ye sa̱hn: ");
INSERT INTO cutNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Deh nehn che dín ndoque ne? Ndahconan se yahn ye: ―Dihvé, codin ne che co ro ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Nducote chitehne ne, a co ro nan. ");
INSERT INTO cutNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ndeta̱hno chi ro na̱n se, ne cuahn se nduco Dihvo vo, rendeva se numacuahn vedeyeno yavena̱n Dendiohs. Namin nducoya̱ca ihyan che ndihchero ye vederihno me ne, rendeva ye numacuahn vedeyeno yavena̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nahmin che chuh Dihvo vo Jesucristo menda̱hn ya̱n Jericó ne, ");
INSERT INTO cutNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","quenan rino a̱ma sa̱hn cuihca che duche se Zaqueo. Sa̱hn min ne, ndina̱n se yahn sa̱hn rica tumeca̱diyo. ");
INSERT INTO cutNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Quenan rino se, te nahn ndihchero se Dihvo vo, duh ihyan chemin. Ate hua ri che ndihchero se ihyan, te a̱ma ya̱hn ihyan nduco ye. Ava̱ne ne, a̱ma ca̱hya ca̱h se. ");
INSERT INTO cutNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tuhme cuahn se, rano se tahque nde ca̱na ca na̱n che va che chuh ye. Cocha se tin a̱ma ya̱hn che duche sicómoro ca̱va che tuno se, ndihchero se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cuahn che a nda̱ Dihvo vo min ne, china̱n ye sa̱hn, ne ra̱hn ye ri ye sa̱hn: ―Zaqueo, codin nun ine, cuenchehn ta̱n, te ma̱n va che conán ndevaque. ");
INSERT INTO cutNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tuhme aderano se cuenchahn se, nevahnecun se ihyan numacuahn vedeyeno. ");
INSERT INTO cutNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ihyan che ndihche ye chemin ne, a̱ma ra̱hn ta̱n ye yahn Dihvo vo che cuahn ye va̱co a̱ma sa̱hn nunde. ");
INSERT INTO cutNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tuhme chandi Zaqueo na̱n nducoya̱ca ihyan chahn, ne ra̱hn se ri se Dihvo vo: ―Dihvé, ma̱hn va vedecuihca yáhn, nahn cá̱h ihyan cheva̱h, ne ndete che va ihyan che ndere chehneví dehtenduh yahn ye ne, va vedeyenó che necá̱h cun ndi nduhva che chehneví yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ra̱hn Dihvo vo: ―Ma̱n ne, ndevahn sa̱hnguh, te chitahno se nduhca̱ che chitahno Abraham. Namin ndevahn ihyan ndeva̱co se. ");
INSERT INTO cutNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","U che rinducó nducoya̱ca ihyan ne, ndá̱, núhn ihyan che chinda ye, din nunde yahn ye, ca̱va che ndedeváhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Cuahn che nda̱ nino Dihvo vo ya̱n Jerusalén ne, ihyan che rihnevan ye che rente ye ne, ra̱hco ye te a nun cuana̱n vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tuhme nte Dihvo vo ejemplo cuh: ―A̱ma sa̱hn, nda̱ta yahn ihyan ndina̱n ne, cuahn se ya̱hn yahn na̱n va rey ca̱va che ca̱h ye vederihquentiyon, conan cuma se. ");
INSERT INTO cutNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ro che ametah ca̱hn se ne, nedin da̱ma se ndiche sa̱hn deca̱hya yahn se, ne din duche se tume, ca̱h se queri a̱ma sa̱hn chahn, ne ra̱hn se: “Codin nchuhn ntiyon nduco tume cuh numanahn che cá̱hn.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ihyan ya̱n va̱co se ne, hua ri rendihche ye sa̱hn, ne cuahn che a chuh se cuahn se ne, dechuh ye a̱ma o ihyan ca̱va che ca̱hma ye nduco rey min: “Hua nahn nuhn sa̱hnguh ca̱va che ca̱hcantiyon se nuhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Cuahn che ndaconan se ne, a quenan cuma se vederihquentiyon. Nedin da̱ma tun se ca a̱ma ca a̱ma sa̱hn deca̱hya chahn che va ta̱h se tume me ca̱va che neca̱h cuande se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nda̱ a̱ma se, ne ra̱hn se: “Dihvé, tume yahn ne ne, a chi ndiche ca̱de yahn queri a̱ma ca̱de che te ne u.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ndahconan dihve se: “Nda̱hca̱ din. Di ne, sa̱hn deca̱hya ndah. Nducote nda̱hca̱ din ntiyon nduco tume andahre tah, ma̱n ne, ca̱hcó ntiyon tah ca̱va che cahquentiyen ndiche ya̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nda̱ ta̱ma se, ne ra̱hn se: “Dihvé, tume yahn ne ne, a chi uhn ca̱de yahn queri a̱ma ca̱de che te ne u.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ndahconan dihve se: “Namin di ne, ca̱hcó ntiyon tah ca̱va che cahquentiyen uhn ya̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nda̱ ta̱ma se, ne ra̱hn se: “Dihvé, nga̱ tume yahn ne, chihco ndáh. ");
INSERT INTO cutNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Hua dín ntiyon nduco yahn che vá̱h dendá tume yahn ne na̱n ntiyon, te ndih ne, a̱ma dito na̱n ne. A ndihché ndih nduhca̱ che reta̱h nduh ne tume che renda̱ca na̱n ntiyon che redin ihyan nduco tume yahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tuhme ra̱hn dihve se: “¡A̱ma duhtuno ihyan di! Nduco ndudo che tihca̱ rahn, a tumecadinó duh ihyan di. A devene che a̱ma dito ná̱n, che reta̱h ndúh tume che renda̱ca na̱n ntiyon che redin ihyan nduco tume yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Dehco che hua cah tume yáhn, din ta̱ma ihyan ntiyon nduco?, te ndete che tihca̱ din ne, ma̱n che ntá̱, nda̱cá tume yáhn nduco da̱ya.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Tuhme ra̱hn dihve se ri se ihyan che chenun ye min: “Cuehnevi nchuhn tume che nda sa̱hn tih, ne coca̱h ne sa̱hn che ca̱hcantiyon ndiche ya̱n me.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ndahconan ihyan chahn: “Dihve nuhn sa̱hn min ne, a va yahn se.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ate ra̱hn dihve se: “Dehve din yahn, te ihyan che ndeh va yahn ye ne, nde tahque ndeh ca ndonda̱ ta̱h ye, ne ihyan che doh yahn ye va ne, nde cuavi tah yahn ye che va. ");
INSERT INTO cutNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Namin ihyan che hua ri rendihche ye u, che hua nahn ye che ca̱hcantiyón ihyan ne, cuahn nchuhn, ngua ne ihyan, ne cuihno ne ihyan muhn ná̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chihno nte Dihvo vo ejemplo me ne, quenda̱hna̱n ye, quendi ye cuahn ye ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cuahn che nda̱ nino ye ya̱n Betfagé nduco ya̱n Betania, na̱n che duche Cuete Olivo ne, dechuh ye o ihyan apóstol yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ne ra̱hn ye ri ye ihyan: ―Cuahn nchuhn ya̱n che va viche la̱do ca̱h. Nda̱ nchuhn min ne, nta̱ca ne a̱ma burro che nde a̱ma ihyan ametah condudo ye ite. Cuenta̱hte ne ite, quenda ne ite muhn. ");
INSERT INTO cutNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ndete che ca̱carune ihyan nchuhn: “¿Dehco che renta̱hte nchuhn ite?”, cuendahconan ne yahn ye: “Huate, Dihve nuhn nahn ye ite.” ");
INSERT INTO cutNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cuahn ihyan chahn, ne nta̱ca ye burro me a nduhca̱ che ra̱hn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cuahn che renta̱hte ye burro me ne, ra̱hn ihyan che dihve te: ―¿Dehco che renta̱hte nchuhn burro tih? ");
INSERT INTO cutNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ndahconan ihyan chahn: ―Huate, Dihve nuhn nahn ye ite. ");
INSERT INTO cutNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tuhme quenda ye ite na̱n quenan Dihvo vo. Tihde ye tino yahn ye da̱me burro me, ne quendudo Dihvo vo ite. ");
INSERT INTO cutNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Rehnta̱ve ihyan chahn tino yahn ye yune cua̱hn na̱n che cuahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cuahn che cuahn nino ye na̱n che renchahn yune Cuete Olivo ne, nducoya̱ca ihyan che rinduco ye ihyan ne, chi yeno ye, ne cana̱n ndeva ye numacuahn vedeyeno yavena̱n Dendiohs yahn nducuahn vederihno che ndihchero ye. A̱ma rah yeno ye, ne ra̱hn ye: ");
INSERT INTO cutNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","―¡Ndeva vo yavena̱n rey cuh che cochi ye menun Dihvo vo Dendiohs! ¡Ndoya̱n Dendiohs, ihyan min che va ye vahchetero! ¡Numacuahn vedeyeno ndeva vo yavena̱n ye! ");
INSERT INTO cutNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tuhme a̱ma o sa̱hn fariseo che nduco se va̱n ihyan chahn ne, ra̱hn se ri se Dihvo vo: ―Ihyan Ricuahn, cuihquentiyon ne ihyan sih che cuahte dihn chende ye. ");
INSERT INTO cutNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ndahconan ye yahn se: ―Rá̱hn rí nchuhn te ndete che cuahte dihn chende ihyan sih ne, tu che cheta̱va ta̱n ne, va che cuah yeno. ");
INSERT INTO cutNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cuahn che nda̱ ye na̱n che a chi ro ya̱n Jerusalén ne, chaco ye che yah ri ye ca̱va ihyan ya̱n min. ");
INSERT INTO cutNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tuhme ra̱hn ye: ―A̱ma nda̱hca̱ ndete che devano nchuhn te a ma̱n nda̱ ro ndah yahn ne che ndevahn ne. Ate hua devano ne, te hua te Dendiohs che co devano ne. ");
INSERT INTO cutNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sa̱hn che ta̱n se nduco nchuhn ne, nda̱ ro che cuahte se trinchera, techendive se ya̱n yahn nchuhn, cuahtecuhma se nduco ne. Hua te yune se che ca̱no ne, ");
INSERT INTO cutNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ne ca̱hno se nchuhn, cuihno ndahtera se ya̱n yahn ne. Nde o tu che ndahto vih hua cota̱ve. Tihca̱ castigo va che co ne, te ma̱n che dechuh Dendiohs u ca̱va che ndah yahn ne ne, hua tumaca̱h ne. ");
INSERT INTO cutNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tuhme chenda̱ Dihvo vo chete ya̱co chahte, ne cana̱n ndetenda̱ vah ye nducoya̱ca sa̱hn che rendihcue se ma̱n, ra se ma̱n, min chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ra̱hn ye ri ye sa̱hn: ―A ndirun na̱n Ndudo yahn Dendiohs: “Ya̱co yáhn ne, ya̱co na̱n che reva̱h ihyan”, ate nchuhn ne, nedin ne nduhca̱ va̱co sa̱hn duco. ");
INSERT INTO cutNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ricuahn Dihvo vo ro ro chete ya̱co me. Chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, sa̱hn intiyahn ma̱n, renuhn ino se ta̱ca̱ co ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ate hua renta̱ca ino se ta̱ca din se, te nducoya̱ca ihyan ne, renevahnecun ye numacuahn vedeyeno che ricuahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A̱ma ro ne, ricuahn Dihvo vo chete ya̱co ma̱n, rahndudo ye ndudo ndah yahn Dendiohs ma̱n. Ura min nda̱ chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, sa̱hn intiyahn ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ne tumerune se ihyan: ―¿Deh vederihquentiyon quenan come che tihca̱ redin ne? ¿Duh te vederihquentiyon di ne? ");
INSERT INTO cutNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ndahconan Dihvo vo yahn se: ―Namin u, va a̱ma na̱n che tumeruné nchuhn. Condahconan ne yáhn: ");
INSERT INTO cutNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿A chehdenune Jua̱n che cuande yahn Dendiohs, o chehdenune ye che cuande yahn ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ndedecadino sa̱hn chahn, ne ra̱hn se va̱n ma̱n se nduco vih: ―Ndete che ca̱hma vo che cuande yahn Dendiohs ne, ndahconan se yuhn vo: “¿Dehco che hua ritahno nchuhn tuhme?” ");
INSERT INTO cutNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A namin no ndete che ca̱hma vo che cuande yahn ihyan. Necuan nducoya̱ca ihyan ya̱n, ca̱h ye tu uvo, te devano cua̱co ye te Jua̱n ne, profeta ye. ");
INSERT INTO cutNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chemin che tahque ndah ra̱hn sa̱hn chahn te hua devano se. ");
INSERT INTO cutNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ra̱hn Dihvo vo ri ye sa̱hn: ―Namin u, hua ca̱hmá có nchuhn deh vederihquentiyon va tá̱h che tihca̱ redín. ");
INSERT INTO cutNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tuhme nte Dihvo vo ejemplo cuh, chihnevan ihyan che chenun ye min: ―A̱ma ihyan ne, chihche ye dihyo uva, ne ca̱h ye chenda̱ta me a̱ma o sa̱hn che din se ntiyon nduco ca̱va che cahma̱hn se nduco ye. Chica ye min, ne cuahn ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Cuahn che nda̱ ro che a rine ndute me ne, dechuh ye a̱ma sa̱hn deca̱hya yahn ye ca̱va che nda̱ca se ma̱hn va ndute nda̱ta me sa̱hn chahn. Ate chahn se sa̱hn deca̱hya me, ne ndedechuh se sa̱hn, diya ta̱h se. ");
INSERT INTO cutNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Dechuh ye ta̱ma sa̱hn deca̱hya yahn ye, ne din ta̱n sa̱hn chahn nduco se, chahn se sa̱hn, ne namin ndedechuh se sa̱hn, diya ta̱h se. ");
INSERT INTO cutNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Dihve chenda̱ta me ne, ndaconan dechuh ye ta̱ma sa̱hn deca̱hya yahn ye. Namin chahn sa̱hn chahn sa̱hn, chi nun se sa̱hn cua̱hn chevah. ");
INSERT INTO cutNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tuhme ndedecadino ihyan che dihve chenda̱ta me: “¿Ta̱ca̱ dín? Tahque ndah dechúh sa̱hn da̱yá che yahinó. ¿A huane nevahnecun sa̱hn chahn sa̱hn cuahn che nda̱ se min?” ");
INSERT INTO cutNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ate cuahn che ndihchero sa̱hn chahn sa̱hn ne, ra̱hn se va̱n ma̱n se nduco vih: “Sa̱hnguh che co yahn se vedecuihca cuh. Ca̱hno vo sa̱hn ca̱va che co yuhn vo.” ");
INSERT INTO cutNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tuhme quenda sa̱hn chahn sa̱hn cua̱hn chihto na̱n va chenda̱ta me, ne chihno se sa̱hn. Ra̱hn Dihvo vo ri ye ihyan chahn: ―¿Deh din ihyan che dihve chenda̱ta me nduco sa̱hn chahn? ");
INSERT INTO cutNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ca̱hn ye, ne decuihno ye sa̱hn. Tuhme ca̱h ye chenda̱ta me ta̱h ta̱ma ca ihyan che din ye ntiyon nduco. Nducote chihnevan sa̱hn fariseo che chenun se min ne, ra̱hn se: ―¡Tahque ndah ndete che hua cuahnecun Dendiohs che tihca̱ co! ");
INSERT INTO cutNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ate ndihchero Dihvo vo sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―¿Tuhme deh conahn che ndirun na̱n Ndudo yahn Dendiohs tuhca̱?: Tu che hua quenan ino sa̱hn che rahto vah ne, chemin che tahque chichihve. ");
INSERT INTO cutNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ihyan che cotahno ye u ne, anduhneca̱ ndete che conda̱h ndudo ye na̱n tu me, nda̱ca yah ye. Me ihyan che hua cotahno ye u ne, anduhneca̱ ndete che conda̱h ndudo tu me ihyan, cuihnonan yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A ura min no, chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, ran dito se che nahn cota̱h se Dihvo vo, te tumacadino se che a yahn se che nte ye ejemplo me. Ate hua dehva din se, te va̱h se ihyan ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tuhme dechuh se a̱ma o se che din ca̱ se che ndah ihyan se, ca̱va che tumerande se ihyan, din se che ca̱hma ye a̱ma ndudo che hua nda̱hca̱. Tihca̱ din se, te nahn ca̱ca nunde se yahn ye na̱n gobernador. ");
INSERT INTO cutNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ra̱hn sa̱hn chahn ri se ihyan: ―Ihyan Ricuahn, a devano nuhn te ndah ndudo che rente ne ma̱n, ricuahn ne ma̱n. Da̱ma no rendihche ne nducoya̱ca ihyan, ne ricuahn ne numa cua̱co nduhca̱ che nahn Dendiohs che cuahtechica ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ca̱hma ne co ne nuhn: ¿a redin yahn che nedihvo vo tume ca̱de iyo yahn César, o hua? ");
INSERT INTO cutNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","A devano Dihvo vo te o na̱n o chende sa̱hn chahn, ne ra̱hn ye ri ye sa̱hn: ―¿Dehco che retumarande nchuhn u? ");
INSERT INTO cutNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Cona̱hma ne a̱ma tume u. Cuahn che ndihchero ye tume me ne, tumerune ye sa̱hn: ―¿Duh yavena̱n ma̱n, duh che duche ma̱n, quenan na̱n tume cuh ne? Ndahconan sa̱hn chahn: ―César. ");
INSERT INTO cutNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tuhme ra̱hn ye ri ye sa̱hn: ―Cha che rihquentiyon César ne, codinahn nchuhn, ne cha che rihquentiyon Dendiohs ne, namin codinahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hua chi tumerande se ihyan nduco nde a̱ma ndudo na̱n ihyan ya̱n. Cuahn ino se chi yahn che tihca̱ ndahconan ye, ne chahte dihn chende se. ");
INSERT INTO cutNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chihno min ne, nda̱ a̱ma o sa̱hn saduceo. Sa̱hn chahn ne, hua ritahno se che va che ntuche tena̱hn. Ra̱hn se ri se Dihvo vo: ");
INSERT INTO cutNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Ihyan Ricuahn, na̱n ley che dirun Moisés ne, rihquentiyon tuhca̱: “Ndete che coh a̱ma se che hua nda̱ca da̱ya se nduco nda̱hta yahn se ne, va che cahneva̱co dihno se nduco te, ca̱va che hua cuihno nda̱ta yahn dihno se.” ");
INSERT INTO cutNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","A̱ma yune ne, chahte ndache se che dihno se vih. Sa̱hn che mena̱n me ne, chihneva̱co se nduco a̱ma nda̱hta. Ate hua no ra̱hn me ne, chih se, ne hua nda̱ca da̱ya se nduco te. ");
INSERT INTO cutNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chihneva̱co a̱ma dihno se nduco te, ne namin chih se, ne hua nda̱ca da̱ya se nduco te. ");
INSERT INTO cutNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Tihca̱ queri a̱ma sa̱hn chahn, nduh che ndache se, chihneva̱co se nduco te, ate chih nducoya̱ca se nde a̱ma se hua nda̱ca da̱ya se nduco te. ");
INSERT INTO cutNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Adive ne, chih nda̱hta me. ");
INSERT INTO cutNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nda̱ ro che ntuche tena̱hn ne, nducote nduh che ndache se chihneva̱co se nduco ta̱hn min ne, ¿cha se che nda̱hta yahn se ta̱hn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tuhme ndahconan Dihvo vo: ―Ihyan che vate ye ma̱n ro cuh ne, rihneva̱co ye ma̱n, redeca̱hnova̱co ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ate nda̱ ro che ntuche tena̱hn ne, ihyan che ndevahn ye ne, metah cahneva̱co ye, nde metah deca̱hnova̱co ye, ");
INSERT INTO cutNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","te ametah ndaconan coh ye. Nducote ntuche ihyan chahn va̱n tena̱hn ne, nedin da̱ya Dendiohs ihyan, ne nduhca̱ ángel ne, tihca̱ co ye. ");
INSERT INTO cutNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yahn che va che ntuche tena̱hn ne, ma̱n Moisés dirun ye yahn cuahn che riche ya̱hn ya̱n me: “Dihvo vo Dendiohs ne, Dendiohs yahn Abraham ma̱n, Isaac ma̱n, Jacob ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dendiohs ne, Dendiohs yahn nducoya̱ca ihyan, ihyan che chenduche ye ma̱n, ihyan che a ndih ye ma̱n, te na̱n ye ne, chenduche nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tuhme ra̱hn a̱ma o sa̱hn devano ley che dirun Moisés ri se Dihvo vo: ―Ihyan Ricuahn, cua̱co niyon ra̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nduco chemin ne, ametah chihquino se tumerune ca se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ra̱hn Dihvo vo ri ye sa̱hn chahn: ―¿Dehra cuande che rente ihyan te ihyan che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ne, Da̱ya David ihyan? ");
INSERT INTO cutNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ma̱n David a dirun ye na̱n libro yahn Salmo: Ra̱hn Dihvé Dendiohs ri ye Dihvé: “Cuihnde muhn la̱do ta̱h cua̱có, ");
INSERT INTO cutNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","numanahn che nda̱hco ndiyá ihyan che hua ri rendihche ye di.” ");
INSERT INTO cutNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nducote dirun David te ihyan min che Dihve ye ne, ¿ta̱ca̱ che da̱ya ye tuhme? ");
INSERT INTO cutNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Na̱n nducoya̱ca ihyan che chenun ye min ne, ra̱hn Dihvo vo ri ye ihyan apóstol yahn ye: ");
INSERT INTO cutNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Cuihco nchuhn cuda̱do nduco sa̱hn devano ley che dirun Moisés, te renan ino se cuahtechica se, chenun se cahteca chano se ma̱n, renan ino se che neca̱h ihyan Dendiohs sa̱hn cua̱hn ndihve numacuahn vedenecun ma̱n, chete ya̱co ma̱n, na̱n vihco ma̱n ne, renan ino se cuahte se na̱n che tahque ndeva ihyan yavena̱n se ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nde dehtenduh che va yahn nda̱hta va̱h ne, rehnevi se, ne a̱ma ra̱hn reva̱h se, redin ca̱ se che ndah ihyan se. Sa̱hn chahn che tahque chahte castigo din Dendiohs sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Cuahn che quenun Dihvo vo Jesucristo chete ya̱co ne, ndihchero ye nduhca̱ che rih ihyan cuihca tume chete yave yahn tume vedino. ");
INSERT INTO cutNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Namin ndihchero ye che chih a̱ma nda̱hta va̱h o tume ca̱hya chete yave me. ");
INSERT INTO cutNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tuhme ra̱hn Dihvo vo: ―Cua̱co rá̱hn rí nchuhn te na̱n Dendiohs ne, tahque rigonun chihve vedino yahn nda̱hta va̱h ca̱h che co vedino yahn ihyan chena̱hn sih, ");
INSERT INTO cutNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","te nducoya̱ca ye ne, chih ye che nga̱va yahn ye. Ate nda̱hta va̱h ca̱h ne, va̱n vedecheva̱h yahn ye ne, chih ye nde che va che toh ye. ");
INSERT INTO cutNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ra̱hn a̱ma o ihyan te ya̱co chahte ne, a̱ma nda̱hchan tu che ndahto ma̱n, dehtenduh vedino che necuco ma̱n. Tuhme ra̱hn Dihvo vo: ");
INSERT INTO cutNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Nducuahn dehtenduh che ta̱hchan ca̱h che rendihchero nchuhn ne, nda̱ ro che hua cota̱ve da̱ma nde o tu che ndahto vih. ");
INSERT INTO cutNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tumerune ihyan chahn: ―Ihyan Ricuahn, ¿ticua̱hn conahn che ra̱hn ne me ne? ¿Deh vederihno co ran cuahn che a nun conahn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ra̱hn Dihvo vo: ―Cuihco nchuhn cuda̱do che hua cahncheh nde a̱ma ihyan nchuhn, te a̱ma ya̱hn sa̱hn rihncheh nda̱ se, ne ca̱hma queri a̱ma se te a ma̱n se ihyan min che a va ca̱de che dechuh Dendiohs, ndedevahn ye ihyan iyehnse. Namin ca̱hma se: “A cochi nino ro.” Ate rá̱hn rí nchuhn che hua tumaca̱h ne yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cuahn che cahnevan nchuhn che va ca̱nda ma̱n, che rahteruhn ihyan nduco vih ma̱n ne, hua dehve dihya nchuhn co, te a tihca̱ va che co mena̱n vih. Ate ro min ne, ametah conahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","’Va̱n nación ne, cuana̱n canda, ne cuahtecuhma a̱ma ihyan che rihquentiyon ye nduco ta̱ma ye. ");
INSERT INTO cutNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","A̱ma nuhn ya̱hn ma̱n, ne cua̱hnguh cua̱hnga̱h ne, a̱ma cuhnde cuico ma̱n, cah ma̱n. Na̱n ro ne, cuhnde ro vederihno rahte, ne a̱ma dihya ihyan co. ");
INSERT INTO cutNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ate cuahn che ametah conahn nducuahn che tihchan ne, co ta̱n ihyan nduco nchuhn ma̱n, din ye preso nchuhn ma̱n, quenda ye nchuhn ya̱co ma̱n, cuih ye nchuhn va̱coya̱hn ma̱n. Yahn che rinduco nchuhn u ne, quenda ye nchuhn na̱n rey ma̱n, gobernador ma̱n, ndere ca̱ca nunde ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tihca̱ cuahno nchuhn ca̱va che nda̱ca yune che cuahndudo ne ndudo yáhn, cahnevan ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nde hua ndedecadino nchuhn ta̱ca̱ ndahconan ne yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","te u ca̱hmá có nchuhn ndudo che ca̱hma ne ma̱n, té vededevano yáhn che conan cuma ne ma̱n, nde hua co ndahconan ye yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nde indihte yahn nchuhn ma̱n, dihno ne ma̱n, ihyan yahn ne ma̱n, ihyan rendihche ne ma̱n, neca̱h ye nchuhn. A̱ma o nchuhn ne, ca̱hno ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nducoya̱ca ihyan ne, hua co ndihche ye nchuhn yahn che rinduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ate nde a̱ma yudo tin nchuhn ne, hua conda. ");
INSERT INTO cutNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ndete che quenda̱h ne vedechahtino va̱n nducuahn vedeyah min ne, ndevahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Cuahn che ndihchero nchuhn che a ntechendive sanda̱do ya̱n Jerusalén ne, codevano ne te a nda̱ ro che cuihno ya̱n min. ");
INSERT INTO cutNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tuhme ihyan che vate ye esta̱do yahn Judea ma̱n, ya̱n Jerusalén ma̱n ne, tahque ndah che ca̱no ye, ca̱hn ye va̱n icoya̱hn. Ihyan che chenan ye viya̱ta ne, tahque ndah che hua ndaconan ye viya̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ro min ne, co ihyan castigo, din nunde yahn ye ca̱va che conahn nducuahn che a chenan ca̱ca. ");
INSERT INTO cutNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Cheva̱h ihyan nda̱hta che chenun da̱ya ye ro min ma̱n, che reta̱va ye da̱ya ye ma̱n!, te a̱ma chahte castigo co ihyan ya̱n min, ne a̱ma cuhnde vedeyah iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Na̱hn ye ne, ca̱hno se ihyan nduco espa̱da, ne na̱hn ye ne, quenda se ihyan ta̱ma nación ca̱va che din ye ntiyon. Sa̱hn ta̱ma nación ne, condinun condina̱hno se ya̱n Jerusalén nde tuno ro che ndihco ca̱de Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Tuhme cuhnde ro vederihno yahn Dendiohs na̱n ya̱hn ma̱n, iyo ma̱n, iyon ma̱n. Muhn iyehnse cuh ne, a̱ma cuhnde vedeyah nducuahn nación, nde hua devano ihyan deh che din ye che va̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Condave cuno ihyan che rendedecadino ye yahn nducuahn vedeyah che cochi ca, te nde nducuahn che va ca̱de na̱n ro ne, nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tuhme ndihchero ihyan u che rinducó nducoya̱ca ihyan, che ndá̱ va̱n man numacuahn vederihquentiyon chahte yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cuahn che cuana̱n conahn dehtenduh che tuhchan ne, ca̱h yeno nchuhn chedave yahn ne, te a cochi nino ro che ndevahn ne. ");
INSERT INTO cutNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Namin nte Dihvo vo ejemplo cuh: ―Condihche nchuhn nduhca̱ che ri yahn ya̱hn higo ma̱n, ya̱hn chena̱hn che rendaconun ya̱ta yahn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cuahn che a reneca̱hno ya̱n ne, a devano nchuhn te a cochi nino ro ihno. ");
INSERT INTO cutNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Namin cuahn che a rinahn dehtenduh che tuhchan ne, cuedevano nchuhn te a nun cuana̱n vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Cua̱co rá̱hn rí nchuhn te cuahn che ametah coh ihyan che vate ye ma̱n ro cuh ne, a conahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Iyehnse ne, cuihno. Ate ndudo yáhn ne, hua cuihno; va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cuihco nchuhn cuda̱do. Hua denda ne ura yahn ne che dema̱n che cheh ne ma̱n, che cocoh ne ma̱n, che ndedecadino ne yahn ntiyon yahn ne ma̱n, ca̱va che nda̱ ro min ne, vateya̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Vedeyah che tuhchan ne, a dena̱n conahn numachahte iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ro ro ne, cuahteya̱n nchuhn ma̱n, cova̱h ne ma̱n, ca̱va che co ndevahn ne yahn vedeyah che tuhchan ma̱n, ca̱va che vateya̱n ne ro che u che rinducó nducoya̱ca ihyan, ndá̱. ");
INSERT INTO cutNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ro ne, ricuahn Dihvo vo chete ya̱co chahte, ne vino ne, rahn ye renan ye a̱ma cua̱n na̱n che duche Cuete Olivo. ");
INSERT INTO cutNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nducoya̱ca ihyan ya̱n, rahn ye ya̱co vatiya̱n vatiya̱n, rihnevan ye che ricuahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Cuahn che a cochi nino vihco ro yudo, ro che reh ihyan pa̱n che ametah ya̱ yahn ne, ");
INSERT INTO cutNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, renuhn ino se ta̱ca ca̱hno se Dihvo vo ca̱va che hua cadino ihyan ya̱n, te va̱h se che co ta̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Chenda̱ chundah Judas Iscariote, a̱ma cha sa̱hn che chi cuande se va̱n ihyan che ndichio chahn, ");
INSERT INTO cutNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ne chahn se na̱n chidocuya̱n ndina̱n ma̱n, sa̱hn ndina̱n yahn policía che redin se cuda̱do ya̱co chahte ma̱n, ne ra̱hn se te co neca̱h se Dihvo vo ta̱h sa̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Chi yeno sa̱hn chahn, ne nte ca̱de se nduco se che ca̱h se tume sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ca̱h Judas ndudo yahn se sa̱hn chahn, ne nuhn ino se ta̱ca̱ co neca̱h se Dihvo vo ca̱va che hua cadino ihyan ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nda̱ vihco ro yudo, ro che reh ihyan pa̱n che ametah ya̱ yahn. Ro min ne, nihnde ca̱de che rihno ihyan a̱ma itecuche lihn ca̱va che co te vedino. ");
INSERT INTO cutNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Dihvo vo ne, dechuh ye Pedro nduco Jua̱n, ne ra̱hn ye: ―Cuahn nchuhn, cuihcoya̱n ne che chuh vo che cuande yahn ro yudo. ");
INSERT INTO cutNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tumerune ihyan chahn: ―¿Ti nahn ne che ca̱hcoya̱n nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ndahconan Dihvo vo: ―Ura che conda̱ nchuhn viya̱n ne, nta̱ca ne a̱ma sa̱hn che nda se a̱ma cuhtenune. Quendi nchuhn sa̱hn min nde vah na̱n che conda̱ se, ");
INSERT INTO cutNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ne ca̱hma ne co ne ihyan che va̱co ye min: “Dechuh Ihyan Ricuahn nuhn che tumerune nuhn ndih: ¿Ti va cua̱rto na̱n che cheh ye nduco ihyan apóstol yahn ye che cuande yahn ro yudo ne?” ");
INSERT INTO cutNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Tuhme na̱hma ye a̱ma cua̱rto chahte nchuhn che a va ya̱n. Min cuihcoya̱n nchuhn che chuh vo nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Chahn ihyan chahn, ne nta̱ca ye nducuahn che ra̱hn Dihvo vo ri ye ihyan, ne chihcoya̱n ye che cheh ye che cuande yahn ro yudo. ");
INSERT INTO cutNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cuahn che nda̱ ura che cheh ye ne, chihnde Dihvo vo na̱n mesa nduco ihyan apóstol yahn ye, ");
INSERT INTO cutNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ne ra̱hn ye ri ye ihyan chahn: ―A̱ma nahn chéh nduco nchuhn che cuande yahn ro yudo numanahn che ametah ca̱hno se u, ");
INSERT INTO cutNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","te rá̱hn rí nchuhn te ametah ndaconan chéh, nde nda̱ ro che conahn nducó che ndihco ca̱de Dendiohs, ne conán na̱n che rihquentiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tuhme cheta̱h ye a̱ma va̱so vino, neca̱h ye nundihve cuahn Dendiohs, ne ra̱hn ye: ―Cota̱h nchuhn, cuih ne nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Rá̱hn rí nchuhn te ametah ndaconan cúh vino yahn uva, nde nda̱ ro che conahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Cheta̱h ye pa̱n me, ne neca̱h ye nundihve cuahn Dendiohs. Tuhme ndeh ye, ca̱h ye ihyan chahn, ne ra̱hn ye: ―Che tuhca̱ redín ne, conahn che cuahnecún che ca̱hno ihyan u ca̱va che ndevahn nchuhn. Tihca̱ cheh nchuhn ca̱va che ca̱hco ran ne che reneca̱hco ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chihno cheh vino ye ne, ndaconan cheta̱h ye va̱so vino me, ne ra̱hn ye: ―Chu ne, yun yáhn che reca̱h dito ndudo ra che nda̱hco ca̱de Dendiohs. Va che cora ca̱va nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Meniyon ne, sa̱hn che neca̱h se u ne, da̱ma reh se nducó. ");
INSERT INTO cutNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Cua̱co te ca̱hno ihyan u che rinducó nducoya̱ca ihyan, nduhca̱ che a nihnde ca̱de. Ate yah rí ca̱va sa̱hn che neca̱h se u. ");
INSERT INTO cutNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tuhme cana̱n tumerune vih ihyan chahn cha ye che tihca̱ din ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chihno min ne, rente ihyan apóstol nduco vih cha ye che tahque cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―Adecoduhno rey ne, a̱ma yudo rihquentiyon ye nación yahn ye, ne sa̱hn intiyahn ne, rendeva ihyan yavena̱n se. ");
INSERT INTO cutNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ate va̱n nchuhn ne, hua co tihca̱, te cha nchuhn che tahque quenun ya̱n ne ne, co ne nduhca̱ a̱ma sa̱hn yuno, ne cha nchuhn che tahque ndina̱n ne ne, co ne nduhca̱ a̱ma mozo. ");
INSERT INTO cutNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Condedecadino ne duh che tahque ndina̱n. ¿A ihyan che va ye na̱n mesa, reh ye, o sa̱hn deca̱hya che redin se cuda̱do numanahn che reh ye? ¿A ndiyu ihyan che va ye na̱n mesa, reh ye che tahque ndina̱n ye? Ate condihche nchuhn. U ne, nduhca̱ a̱ma ihyan che redin ye ntiyon yahn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ro ro che chuhríhn ne, a nchuhn che chinduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chemin che nduhca̱ che te Chidá vederihquentiyon, quenan cumá ne, namin té vederihquentiyon, cuahtenan cuma ne ");
INSERT INTO cutNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ca̱va che chuh vo ma̱n, cuh vo ma̱n, da̱ma nduco vih, ro che ca̱hcantiyón, ne cuahte ne techeca̱de ne yahn ihyan nación yahn Israel, nduh che ndichio nda̱ta yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Namin ra̱hn Dihvo vo ri ye Pedro: ―Simón, Simón, cuihque cuda̱do, te chundah ne, chica se Dendiohs ca̱va che tumerande se nchuhn nde na̱n che nda̱hco ndiya se nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ate u ne, cová̱h cave ca̱va che hua a̱ma yune no ca̱hcoman. Cuahn che ndaconen cotehne ne, cueneca̱h yan chedave yahn ihyan che ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ndahconan Simón, ne ra̱hn ye: ―Dihvé, va vedeyenó che conducó ndih, andahre conún va̱coya̱hn nduco ne ma̱n, andahre cóh da̱ma nduco ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ate ra̱hn Dihvo vo ri ye ihyan: ―Pedro, rá̱hn rí di te ura che ametah cuah tuh ne, cahme ino yune te hua rendihche u. ");
INSERT INTO cutNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tuhme ra̱hn Dihvo vo nduco nducoya̱ca ihyan chahn: ―Cuahn che dechúh nchuhn che nde dino, nde morral, nde inda̱co, hua quenda ne ne, ¿deh chinda yahn ne ne? Ndahconan ye: ―Hua dehva chinda yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Ate ma̱n ne, ndete che va dino yahn nchuhn, cuiquenda ne, ndete che va morral, cuiquenda ne. Cha nchuhn che ametah espa̱da yahn ne ne, cuendihcue ne tino rendiche ne, cua ne a̱ma. ");
INSERT INTO cutNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Rá̱hn rí nchuhn te va che conahn ndudo cuh che a ndirun yáhn: “Ca̱hma ihyan te ihyan min ne, ihyan nunde ye.” Nducuahn che a ndirun che va che cuahno có ne, va che conahn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tuhme ra̱hn ihyan chahn: ―Dihve nuhn, nga̱ o espa̱da, va yahn nuhn. Ndahconan ye: ―Nduco sih ne, a va. ");
INSERT INTO cutNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Chihno min ne, cuahn Dihvo vo Cuete Olivo nduhca̱ che a rahn ye, ne cuahn ihyan apóstol nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cuahn che nda̱ ye min ne, ra̱hn ye nduco ihyan chahn: ―Cova̱h nchuhn ca̱va che hua dinahn ne cuahn che tumarande chundah nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tuhme chihco rino Dihvo vo ihyan chahn, ne cuahn ye ca̱na na̱n me. Min chehntihya ye, cova̱h ye, ");
INSERT INTO cutNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ne ra̱hn ye: ―Chida má̱n, ndete che nahn ne ne, cuehnevi ne che va che chuhríhn. Ate hua co nduhca̱ che náhn. Co nduhca̱ che nahn ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tuhme nda̱ a̱ma ángel che chica ye vahchetero, ne neca̱h ya̱n ye chedave yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","A̱ma chuhrihn ye che rendedecadino ye, ne tahque dito cova̱h ye. A̱ma chi ye nuneya̱n nduhca̱ yun, ne ra nde ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Chihno cova̱h ye ne, ndaconan ye na̱n che chenun ihyan apóstol chahn, ne nta̱ca ye ihyan che vateya̱do ye, te a̱ma ndi cuno ye che ra̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tuhme ra̱hn ye ri ye ihyan: ―¿Dehco che vateya̱do nchuhn? Cuenecuan ne, cova̱h ne ca̱va che hua dinahn ne cuahn che tumarande chundah nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nde ametah cuihno ca̱hma ye cuahn che nda̱ a̱ma ya̱hn sanda̱do nduco sa̱hn policía che redin se cuda̱do ya̱co chahte, ne nda̱hna̱n Judas, a̱ma cha sa̱hn che chi cuande se va̱n ihyan che ndichio chahn. Chahn nda̱ sa̱hn min na̱n Dihvo vo ca̱va che tena̱n se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Judas, ¿a nahn tenan u, ne nduco tihca̱ necah u che rinducó nducoya̱ca ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Cuahn che ndihchero ihyan apóstol che tihca̱ ri ne, tumerune ye ihyan: ―Dihve nuhn, ¿a cuahn nuhn sa̱hn sih nduco espa̱da ne? ");
INSERT INTO cutNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","A̱ma cha ihyan chahn ne, chahn ye a̱ma sa̱hn deca̱hya yahn chidocuya̱n che tahque ndina̱n, chaconda̱h ye revan se la̱do ta̱h cua̱co se. ");
INSERT INTO cutNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ate ra̱hn Dihvo vo: ―Hua cuhma nchuhn. Tuhme nahn ta̱h ye revan sa̱hn min, ne ndonan. ");
INSERT INTO cutNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ra̱hn Dihvo vo ri ye chidocuya̱n ndina̱n ma̱n, sa̱hn ndina̱n yahn policía che redin cuda̱do ya̱co ma̱n, sa̱hn intiyahn ma̱n: ―¿A cochi nchuhn nduco espa̱da ma̱n, nduco ya̱hn ma̱n, din ne preso u nduhca̱ sa̱hn duco? ");
INSERT INTO cutNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ro ro quenún chete ya̱co chahte va̱n nchuhn, ne hua din ne preso u. Ate ma̱n ne, nda̱ ura yahn ne, ura che rihquentiyon chundah. ");
INSERT INTO cutNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tuhme din sa̱hn chahn preso Dihvo vo, quenda se ihyan va̱co chidocuya̱n che tahque ndina̱n. Cuahn Pedro diyahn diyahn, quendi ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Din sa̱hn chahn a̱ma va̱coya̱hn chevah, ne vatendi se, reca̱h ihno se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tuhme ndihchero a̱ma ta̱hn deca̱hya che nduco Pedro, nti ye min. Ndihchero ndah te ihyan, ne ra̱hn te: ―Sa̱hnguh ne, chinduco se sa̱hn preso ca̱h. ");
INSERT INTO cutNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ndahconan Pedro, ne ra̱hn ye ri ye ta̱hn: ―Nde hua rendihché ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Namena̱n me ne, ndihchero ta̱ma se ihyan, ne ra̱hn se: ―Namin di, ndoque va̱n sa̱hn che rinduco se sa̱hnga̱h. Ndahconan Pedro: ―Ndiyu u. ");
INSERT INTO cutNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chihno tenduh a̱ma ura ne, ra̱hn ta̱ma se: ―Cua̱co te sa̱hnguh ne, chinduco se sa̱hnga̱h, te sa̱hn Galilea se. ");
INSERT INTO cutNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ndahconan Pedro: ―Nde hua devanó deh che rahn. Nde ametah cuihno ca̱hma Pedro, ne cah tuh. ");
INSERT INTO cutNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tuhme chaconan Dihvo vo, ndihchero ye Pedro, ne neca̱hco ye nduhca̱ che ra̱hn Dihvo vo: “Ura che ametah cuah tuh ne, cahme ino yune te hua rendihche u.” ");
INSERT INTO cutNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tuhme ndihquenda̱ Pedro, ne a̱ma chaco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sa̱hn che redin se cuda̱do Dihvo vo ne, redin duche yahn se ihyan, ne rahn se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Dechiche se a̱ma tino na̱n ye. Rahn se ihyan, ne ra̱hn se: ―Cahme duh che chahn di. ");
INSERT INTO cutNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A̱ma ndeh na̱n ca dehtenduh ra̱hn se, din duche yahn se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cuahn che a chi dave me ne, ndo da̱ma chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, sa̱hn intiyahn ma̱n, ne quenda se Dihvo vo na̱n che cuhnde ca̱de yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Min tumerune se ihyan: ―¿A di ihyan che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ne? Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Ndete che ca̱hmá có nchuhn te u ne, nde hua cotahno ne. ");
INSERT INTO cutNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ndete che va deh che tumeruné ne, nde hua ndahconan ne yáhn. ");
INSERT INTO cutNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ate u che rinducó nducoya̱ca ihyan ne, a nun cuhndé la̱do ta̱h cua̱co Dendiohs, ihyan min che a̱ma yudo vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tumerune nducoya̱ca sa̱hn chahn: ―¿A di che Da̱ya Dendiohs tuhme ne? Ndahconan ye yahn se: ―A u. A ma̱n nchuhn ra̱hn ne meniyon. ");
INSERT INTO cutNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tuhme ra̱hn se: ―¿Dehca din vo testigo? Nduco ndudo che tihca̱ ra̱hn se ne, a va. A ma̱n vo chihnevan vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tuhme necuan nducoya̱ca se, quenda se Dihvo vo na̱n Pila̱to. ");
INSERT INTO cutNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Cana̱n ndere rica nunde se yahn ye, ne ra̱hn se: ―Nta̱ca nuhn sa̱hnguh che rinun se ihyan che hua nedihve ye tumeca̱diyo yahn César. Ava̱ne ne, ra̱hn se te ma̱n se che rey ma̱n, ihyan che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tuhme tumerune Pila̱to ihyan: ―¿A di che rey yahn nación yahn Israel ne? Ndahconan Dihvo vo: ―U, nduhca̱ che rahn. ");
INSERT INTO cutNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ra̱hn Pila̱to ri se chidocuya̱n ndina̱n nduco nducoya̱ca ihyan: ―Hua renda̱cá nde a̱ma nunde yahn sa̱hnguh. ");
INSERT INTO cutNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ate quendi sa̱hn chahn rica nunde se, ne ra̱hn se: ―Numacuahn nación yahn nuhn, nde esta̱do yahn Galilea nde muhn, ndedecuan se ihyan nduco ndudo che ricuahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuahn che chihnevan Pila̱to che ra̱hn se yahn Galilea ne, tumerune se ndete che min ya̱n va̱co Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cuahn che checadino se te min ya̱n va̱co ye ne, dechuh ye ihyan na̱n Herodes, te sa̱hn min che rihquentiyon se min, ne quenan se ya̱n Jerusalén ro min. ");
INSERT INTO cutNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","A̱ma chi yeno Herodes cuahn che ndihchero se Dihvo vo, te a ra̱hn che nahn ndihchero se ihyan. Nducote rihnevan se che a̱ma rente ihyan yahn Dihvo vo ne, quenan rino se che din ye a̱ma vederihno, ndihchero se. ");
INSERT INTO cutNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A̱ma ndeh na̱n che tumerune se, ate nde hua ndahconan Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chidocuya̱n ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n ne, ndevana̱n se, ndere rica nunde se yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tuhme Herodes nduco sanda̱do yahn se ne, din duche yahn se Dihvo vo. Tihyon se a̱ma tino ndah ihyan, ne ndedechuh se ihyan na̱n Pila̱to. ");
INSERT INTO cutNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ro mena̱n ne, ta̱n Pila̱to nduco Herodes, ate nde ro min ne, ndoya̱n se nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nedin da̱ma Pila̱to chidocuya̱n ndina̱n ma̱n, sa̱hn intiyahn ma̱n, ihyan ya̱n ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ne ra̱hn se: ―Nchuhn ne, nda ne sa̱hnguh ná̱n, rica nunde ne yahn che ndedecuan se ihyan ya̱n. Ate tumeruné sa̱hn na̱n nchuhn yahn dehtenduh che rica nunde ne yahn se, ne metah nde a̱ma nunde yahn se. ");
INSERT INTO cutNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Dechúh nchuhn nduco se na̱n Herodes, ne namin hua nta̱ca se nde a̱ma nunde yahn se. Cua̱co te hua dehva din se ca̱va che ca̱hno vo sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tahque ndah cuáhn sa̱hn, nta̱hté sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nduyo nduyo che renda̱ vihco ro yudo ne, va che nta̱hte se a̱ma preso. ");
INSERT INTO cutNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ate cah nducoya̱ca ihyan: ―¡Cuihno ne sa̱hn tih! ¡Cuenta̱hte ne Barrabás! ");
INSERT INTO cutNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás ne, quenun se va̱coya̱hn, te ndedecuan se ihyan ya̱n che cuhma ye nduco gobierno ma̱n, chihno se sanda̱do yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ndaconan ra̱hn Pila̱to te nahn nta̱hte se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ate cah tun ihyan chahn: ―¡Cuenahn ya̱h ne sa̱hn! ¡Cuenahn ya̱h ne sa̱hn! ");
INSERT INTO cutNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ndaconan ra̱hn Pila̱to nde na̱n che chi ino yune: ―¿Dehra nedin sa̱hnguh? Hua co ca̱hno vo sa̱hn, te metah nde a̱ma nunde yahn se. Tahque ndah dín castigo sa̱hn, ne nta̱hté sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ate quendi ihyan chahn rah ye, rica ye che conan ya̱h Dihvo vo. A̱ma quendi chidocuya̱n ndina̱n nduco ihyan chahn rah ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tuhme ca̱h yune Pila̱to che co nduhca̱ che rica ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nta̱hte se sa̱hn che quenun va̱coya̱hn me nduhca̱ che nahn ye, ne chihquentiyon se sanda̱do che nahn ya̱h se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Cuahn che quenda sanda̱do chahn Dihvo vo ne, chihquentiyon se a̱ma ihyan ya̱n Cirene che duche ye Simón, che cuenchi ye nahn ye viya̱ta, che ntihde dihme ye cruz, quendi ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A̱ma ya̱hn ihyan ya̱n ma̱n, ihyan nda̱hta che raco ye ma̱n, rah ra̱n ye ma̱n, cuahn ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ndihchero Dihvo vo ihyan nda̱hta chahn, ne ra̱hn ye ri ye ihyan: ―Nchuhn ihyan ya̱n Jerusalén, hua cuaco ne ca̱va u. Cuaco ne ca̱va ma̱n ne ma̱n, ca̱va da̱ya ne ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","te nda̱ ro che ca̱hma ihyan: “Ndah ro yahn ihyan nda̱hta che hua rahcoya̱n ye ma̱n, ihyan nda̱hta che hua renda̱ca da̱ya ye ma̱n, ihyan nda̱hta che hua reta̱ve ye ma̱n.” ");
INSERT INTO cutNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ro min ne, ca̱hma ihyan co ye ico ma̱n, cuete ma̱n: “Conda̱h ndudo nchuhn nuhn, cuedendeh ne nuhn.” ");
INSERT INTO cutNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Nducote numacuahn vedeta̱n ca̱hno se u che ametah nunde yáhn ne, nda̱ ro min ne, tahque nun ca̱hno se ihyan nunde. ");
INSERT INTO cutNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Namin quenda se o sa̱hn nunde ca̱va che ca̱hno se sa̱hn da̱ma nduco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cuahn che nda̱ se na̱n che duche Cuete Ine Tin Tena̱hn ne, nahn ya̱h se Dihvo vo da̱ma nduco sa̱hn nunde chahn. A̱ma se ne, quenan ya̱h se la̱do ta̱h cua̱co ye, ne ta̱ma se la̱do ta̱h cueh ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cova̱h Dihvo vo: ―Chida má̱n, cuenchahco ne yahn ihyan sih, te nde hua devano ye deh che redin ye. Sanda̱do chahn ne, din se sortear tino yahn ye, cha sa̱hn quenda̱h yahn se che co yahn se queri a̱ma. ");
INSERT INTO cutNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ihyan ya̱n chahn ne, vatendi ye, rendihchero ye. Sa̱hn intiyahn ne, riyon nan se Dihvo vo, ne ra̱hn se: ―Ta̱ma ca ihyan ne, ndedevahn se. Ndete che sa̱hn tih che a va ca̱de che dechuh Dendiohs, ndedevahn se ihyan iyehnse ne, ¿dehco che hua ndedevahn ma̱n se sa̱hn? ");
INSERT INTO cutNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Namin redin duche yahn sanda̱do chahn ihyan, reca̱h se vinagre, cuh ye, ");
INSERT INTO cutNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ne ra̱hn se ri se ihyan: ―Ndete che di che rey yahn nación yahn Israel ne, cuendedevahn man di. ");
INSERT INTO cutNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tin cruz ne, ndirun ndudo griego ma̱n, ndudo latín ma̱n, ndudo hebreo ma̱n, tuhca̱: “Nga̱ Rey yahn nación yahn Israel.” ");
INSERT INTO cutNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A̱ma cha sa̱hn nunde chahn che quenan ya̱h se ne, riyon nan se ihyan, ne ra̱hn se: ―Ndete a di ihyan che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ne, cuendedevahn man di ma̱n, cuendedevahn nuhn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ate sa̱hn che ta̱ma me ne, ra̱hva se nduco vih, ne ra̱hn se: ―Namin di, ¿a hua vah Dendiohs, andahre quenan yah nduhca̱ che quenan ya̱h ye? ");
INSERT INTO cutNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Uvo ne, a redin yahn che rechuhrihn vo, te renedihvo vo nunde yuhn vo. Ate ihyan cuh ne, nde a̱ma nunde hua quendihco ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Tuhme ra̱hn se ri se Dihvo vo: ―Cuahn che a va ne, rihquentiyon ne ne, cueneca̱hco ne u, ne conan va̱hino ne u. ");
INSERT INTO cutNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ndahconan Dihvo vo yahn se: ―Cua̱co rá̱hn rí di te nde a ma̱n ro cuh conen nducó vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ura che a chi ma̱hn ya̱hn ne, a̱ma chi man numachahte iyehnse nde na̱n rahco ino a chino, ");
INSERT INTO cutNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","te chih ya̱hn. Tino che quendihco chete ya̱co chahte ne, nde, ndo o ndi. ");
INSERT INTO cutNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tuhme cah Dihvo vo: ―Chida má̱n, nda̱hcó chedave yáhn ta̱h ne. Chihno ra̱hn ye tihca̱ ne, chih ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nducote ndihchero sa̱hn ndina̱n yahn sanda̱do che tihca̱ chi ne, ndeva se yavena̱n Dendiohs, ne ra̱hn se: ―Cua̱co niyon te ihyan tih ne, metah nde a̱ma nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nducoya̱ca ihyan che chenun ye min, ndihchero ye che tihca̱ chi ne, yah ri ye, ne cona̱hn ye, rahn ye ticua ye. ");
INSERT INTO cutNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ate nducoya̱ca ihyan che a rendihche ye Dihvo vo ma̱n, ihyan nda̱hta che chinduco ye Dihvo vo nde esta̱do yahn Galilea ma̱n ne, yahn no chahtendi ye, ndihchero ye che tihca̱ chi. ");
INSERT INTO cutNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","A̱ma ihyan ya̱n Arimatea, esta̱do yahn Judea, che duche ye José che nduco ye va̱n ihyan ndina̱n yahn nación yahn Israel ne, ndah ihyan ye na̱n Dendiohs ma̱n, na̱n ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Namin quenan rino ye che conahn vederihquentiyon yahn Dendiohs. Ihyan min ne, hua chi da̱ma ndudo yahn ye nduco combiero yahn ye, chih nunde se yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Chahn ihyan min na̱n Pila̱to, ne chica ye sa̱hn che ca̱h yune se che cuhche ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tuhme chahn ye, ndedevah ye ihyan. Chahcotuma ye a̱ma tino ihyan, ne chacondihte ye ihyan chete a̱ma ya̱yan ra, che ndindah na̱n a̱ma ya̱va. ");
INSERT INTO cutNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ro min ne, víspera yahn ro yudo, a cuana̱n ro che rahte tuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ihyan nda̱hta chahn che chica ye esta̱do yahn Galilea nduco Dihvo vo ne, chahn nduco ye, ne ndihchero ye na̱n va ya̱yan ma̱n, ta̱ca̱ chacondihte ye Dihvo vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Cuahn che ndaconan ihyan nda̱hta chahn ne, ca ye yuneda̱n ma̱n, nuneda̱n ma̱n, ne nducote a cana̱n ro che rahte tuhno ihyan ne, chahte tuhno ye nduhca̱ che a va ca̱de. ");
INSERT INTO cutNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A̱ma vatiya̱n da̱hca, ro che ndeva ndate ne, cuahn ihyan nda̱hta chahn nduco ta̱ma te o ihyan nda̱hta, quenda ye yuneda̱n ma̱n, nuneda̱n ma̱n, che a ndihcoya̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cuahn che nda̱ ye na̱n ya̱yan me ne, ndihchero ye che a ndavi tu che ndechendih chende. ");
INSERT INTO cutNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chenda̱ ye chete ya̱yan me, ate hua nta̱ca ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A̱ma dihya ye chi che tihca̱, ne numanahmin ne, adena̱n china̱n ye o ángel, vatendi ye, chenun ye tino che a̱ma diya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tuhme nde tahque dihya ihyan nda̱hta chahn chi, ne chendih ye, nde ametah nahn ndonihyon na̱n ye che va̱h ye. Ra̱hn ángel chahn nduco ye: ―¿Dehco che va̱n tena̱hn renuhn nchuhn a̱ma ihyan che quenduche ye? ");
INSERT INTO cutNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Metah ye muhn, te a ntuche ye. Cueneca̱hco nchuhn cuahn che nduco ca ne ihyan esta̱do yahn Galilea, nduhca̱ che ra̱hn ye ri ye nchuhn: ");
INSERT INTO cutNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“U che rinducó nducoya̱ca ihyan ne, va che neca̱h se u ta̱h sa̱hn nunde ca̱va che nahn ya̱h se u. Ate cuihno ino ro ne, ntuché.” ");
INSERT INTO cutNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tuhme nta̱ tin ihyan nda̱hta chahn che tihca̱ ra̱hn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Nda̱ca ye na̱n ya̱yan me, cona̱hn ye, ne neca̱h cuande ye ihyan apóstol che ndichia̱ma chahn ma̱n, ihyan chena̱hn che nduco ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María yahn ya̱n Magdala ma̱n, Jua̱na ma̱n, María che chaco Jacobo ma̱n, nduco ihyan nda̱hta chena̱hn chahn ne, a ihyan chahn che neca̱h cuande ye ihyan apóstol che tihca̱ chi. ");
INSERT INTO cutNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ate ihyan apóstol chahn ne, hua chitahno ye, ne ra̱hco ye te co hua va cua̱co dave yahn ihyan nda̱hta chahn che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tuhme necuan Pedro, cuahn ye rano ye na̱n ya̱yan me. Nda̱ ye min ne, ndihchero ye che a dema̱n tino che chacotuma Dihvo vo quendite min. A̱ma cuahn ino ye che tihca̱, ne cona̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A ro min no ne, cuahn o ihyan chahn a̱ma ya̱n lihn che duche Emaús, ri tenduh ndichio da̱hno che renda̱ ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Numanahn che chenun yune ihyan chahn ne, rente ye nduco vih yahn nducuahn che chi. ");
INSERT INTO cutNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ura min nda̱ ma̱n Dihvo vo na̱n ihyan chahn, ne cuahn ye da̱ma nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ate hua nchana̱n ihyan chahn ihyan, te a tihca̱ va ca̱de che hua nchana̱n ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tumerune Dihvo vo ihyan chahn: ―¿Deh che rente nchuhn va̱n ma̱n ne nduco vih che a̱ma ra̱n ne ne? ");
INSERT INTO cutNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A̱ma cha ihyan chahn che duche ye Cleofas ne, ndahconan ye: ―¿A dema̱n ndih che ta̱ma ya̱n cochi ne, che hua devano ne dehtenduh che chi ya̱n Jerusalén ro cuh? ");
INSERT INTO cutNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tumerune Dihvo vo: ―¿Deh chi min ne? Tuhme ndahconan ihyan chahn yahn ye: ―A̱ma ndeh na̱n dehtenduh chahno chi Jesús yahn ya̱n Nazaret. Ihyan min ne, a̱ma ihyan profeta che quenan cuma ye vederihquentiyon chahte na̱n Dendiohs ma̱n, na̱n ihyan ma̱n, che din ye vederihno ma̱n, chicuahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Chidocuya̱n ndina̱n ma̱n, sa̱hn intiyahn ma̱n ne, chih nunde se yahn ye, ne neca̱h se ihyan ta̱h sa̱hn che nahn ya̱h se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nuhn ne, chenan ino nuhn che a ihyan min che ndedevahn ye ihyan nación yuhn vo, Israel. Ma̱n ne, a chi ino ro che chihno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ava̱ne ne, a̱ma rendedecadino nuhn, te a̱ma o ihyan nda̱hta che chinduco ye nuhn ne, chahn ye na̱n ya̱yan ura che chi dave, ");
INSERT INTO cutNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ate hua nta̱ca ye ihyan min chete ya̱yan me. Cuahn che ndaconan ye ne, ra̱hn ye te ndihchero ye ángel. Angel chahn ne, ra̱hn ye te a ntuche ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tuhme chahn a̱ma o combiero yahn nuhn na̱n ya̱yan me, ne nta̱ca ye nduhca̱ che ra̱hn ihyan nda̱hta chahn, ate hua ndihchero ye ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―¡A̱ma tuntu nchuhn! ¡Ta̱ca che hua renahn ne nduhca̱ che dirun ihyan profeta! ");
INSERT INTO cutNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A ndiyu a nihnde ca̱de che ihyan che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ne, chuhrihn ye dehtenduh che tuhchan ma̱n, nda̱ ye vahchetero ma̱n? ");
INSERT INTO cutNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Tuhme ca̱h cuande ye ihyan chahn Ndudo yahn Dendiohs, cana̱n ye nde che dirun Moisés ma̱n, che dirun nducoya̱ca ihyan profeta ma̱n, yahn nduhca̱ che cuahno ye co. ");
INSERT INTO cutNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nda̱ ihyan chahn ya̱n lihn me, ne din ca̱ Dihvo vo che nahn chuh da̱ma ye, ca̱hn ye tahque yahn ca. ");
INSERT INTO cutNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ate din ihyan chahn fuerza ihyan che conan ye min, te a chi chino. Tuhme chenda̱ ye chete vah, chinduco ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ura che chahte ye, cheh vino ye ne, cheta̱h Dihvo vo pa̱n, neca̱h ye nundihve cuahn Dendiohs, ne ndeh ye, ca̱h ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ura min nchana̱n ihyan chahn te a ihyan min che Dihvo vo, ne adena̱n no chehna̱n ihyan chahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tuhme ra̱hn ye nduco vih: ―¿A ndiyu yeno chedave yuhn vo numanahn che rente ye nduco vo ma̱n, ricuahn ye uvo Ndudo yahn Dendiohs ma̱n, cua̱hn yune? ");
INSERT INTO cutNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ndeta̱hno ndaconan ihyan chahn ya̱n Jerusalén, ne nta̱ca ye ihyan apóstol che ndichia̱ma chahn che ndi da̱ma ye nduco ihyan chena̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ihyan che ndi da̱ma ye min ne, rente ye va̱n ma̱n ye nduco vih: ―Cua̱co che ntuche Dihvo vo, te chihnde ro ye na̱n Simón. ");
INSERT INTO cutNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tuhme neca̱h cuande ihyan che o chahn nduhca̱ che chahno ye chi cua̱hn yune ma̱n, nduhca̱ che nchana̱n ye Dihvo vo ura che ndeh ye pa̱n ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Numanahn che rente ihyan chahn yahn dehtenduh che tihchan ne, adena̱n china̱n ye Dihvo vo che nti ye menda̱hn. Ra̱hn ye ri ye ihyan chahn: ―Dehve ra̱hco nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Dihya ihyan chahn chi, ra̱hco ye te co a̱ma vaco ndihchero ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ate ra̱hn Dihvo vo ri ye ihyan: ―¿Dehco che a̱ma va̱h nchuhn ma̱n, ndeh rendedecadino ne ma̱n? ");
INSERT INTO cutNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Condihche ne ya̱hvetá̱h ma̱n, cá̱h ma̱n, te a u che ntí na̱n ne. Conahn ta̱h ne u, ne condihche ne te va yute yáhn ma̱n, va ine yáhn ma̱n, ndiyu a̱ma vaco nduhca̱ che rendedecadino ne. ");
INSERT INTO cutNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chihno ra̱hn ye chemin ne, na̱hma ye ya̱hveta̱h ye ma̱n, ca̱h ye ma̱n, ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ate nducote a̱ma cuahn ino ihyan chahn ma̱n, a̱ma yeno ye ma̱n ne, nde ametah cotahno ye. Chemin che tumerune Dihvo vo ihyan chahn: ―¿A va deh che chuh vo muhn ne? ");
INSERT INTO cutNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tuhme ca̱h ihyan chahn a̱ma ndi ya̱hca ndiyuche nduco a̱ma ndi va̱conedih yahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Cheh ye ma̱n, chih ye ma̱n, na̱n ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ra̱hn ye ri ye ihyan chahn: ―Cuahn che nduco cá nchuhn ne, a te cuandé nchuhn te va che conahn nducuahn che nihnde ca̱de che cuahno có, nduhca̱ che a ndirun na̱n ley che dirun Moisés ma̱n, nduhca̱ che dirun ihyan profeta ma̱n, nduhca̱ che ndirun na̱n libro yahn Salmo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Tuhme din Dihvo vo che chenahn ihyan chahn Ndudo yahn Dendiohs, ");
INSERT INTO cutNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ne ra̱hn ye: ―A tihca̱ va che conahn nducó nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs. U che a va ca̱de che chí, ndedeváhn ihyan iyehnse ne, a tihca̱ nihnde ca̱de che ca̱hno se u nduhca̱ a chi. Namin a nihnde ca̱de che cuihno ino ro ne, ntuché va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Va che dechúh ihyan, cuahndudo ye muhn ya̱n Jerusalén ma̱n, nde nducuahn nación ma̱n, che nto ino ihyan nunde yahn ye ca̱va che nchahco Dendiohs yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","A nchuhn che ndihchero ne nducuahn dehtenduh che tihca̱ chinahn, ne va che cuahndudo ne. ");
INSERT INTO cutNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Condihche nchuhn. Nduhca̱ che a te Chidá ndudo yahn ye ne, u dechúh Vaco Ndah yahn ye, conun nchuhn. Cuahtenan rino nchuhn muhn ya̱n Jerusalén nde nda̱ ro che cuahtenan cuma ne vederihquentiyon yahn Vaco Ndah yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Cuahn Dihvo vo nduco ihyan chahn nde ya̱n Betania. Chenihyon ta̱h ye, ne chica ye Dendiohs ca̱va ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tuhme chica ye min, ne conda̱ ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ndeva ihyan chahn yavena̱n Dihvo vo, ne cona̱hn ye ya̱n Jerusalén, a̱ma yeno ye. ");
INSERT INTO cutNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Min chete ya̱co chahtenun ye ro ro, rendeva ye yavena̱n Dendiohs numacuahn vedeyeno. Tihca̱ chi.");
INSERT INTO cutNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cuahn che metah cuhnde iyehnse ne, a va a̱ma ihyan che duche ye Ndudo yahn Dendiohs. Ihyan min ne, nduco ye Dendiohs Chida, ne Dendiohs ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nde na̱n che cana̱n nducuahn ne, a nduco ye Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A nduco ye Dendiohs dendah ye nducuahn. Ndendi ndendita che va ne, a nduco ye dendah ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ihyan min ne, a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse, ne anduhneca̱ dave yahn ya̱hn che ri ro dave na̱n ihyan ne, tihca̱ ihyan min, te chicuahn ye ndudo yahn Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Quechica ye va̱n ihyan nunde, chicuahn ye ihyan, ne andahre nahn nda̱hco ndiya ihyan chahn vederihquentiyon yahn ye, ate hua chicha ye, te vederihquentiyon yahn ye ne, anduhneca̱ dave yahn ya̱hn che rendihco dave na̱n che man. ");
INSERT INTO cutNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A̱ma yune ne, tenda̱hnun Dendiohs a̱ma ihyan che duche ye Jua̱n, ");
INSERT INTO cutNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ca̱h ye vederihquentiyon ihyan che cuahndudo ye ndudo yahn ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse, ca̱va che cahnevan nducoya̱ca ihyan, ne cotahno ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jua̱n ne, ndiyu ma̱n ye che ndedevahn ye ihyan iyehnse, te vederihquentiyon che quenan cuma ye ne, che cuahndudo ye yahn ihyan min che a va ca̱de che chi ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ro che quechica Jua̱n cahndudo ye ne, a cochi nino ro che cuana̱n ntiyon yahn ihyan min che cacuahn ye nducoya̱ca ihyan iyehnse nduhca̱ che nahn Dendiohs che runeca̱de cuahtechica ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ihyan min che duche ye Ndudo yahn Dendiohs ne, nda̱ ye iyehnse, ne andahre nduco ye Dendiohs dendah ye iyehnse, ate ihyan iyehnse ne, chaconda̱h veda̱me ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nda̱ ye muhn iyehnse cuh che dendah ma̱n ye, ate ihyan nación yahn ye ne, chaconda̱h veda̱me ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Me ihyan che nevahnecun ye ihyan, chitahno ye ihyan ne, numacuahn vederihquentiyon yahn ye, nda̱hco ye ihyan chahn ta̱h Dendiohs, nedin da̱ya ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ihyan chahn ne, chi da̱ya Dendiohs ihyan, ndiyu ca̱va nda̱ta yahn ye, nde huane yahn che tihca̱ nahn indihte yahn ye, te ma̱n Dendiohs nedin da̱ya ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ihyan min che duche ye Ndudo yahn Dendiohs ne, ndo ye nduhca̱ ihyan iyehnse, ne quechica ye neve nduyo va̱n nuhn. Ndihchero nuhn che a̱ma yudo vederihquentiyon quenan cuma ye, ne tumacadino nuhn che Da̱ya Dendiohs Chida ihyan. Metah nde a̱ma ihyan nduhca̱ ye. A̱ma chahte vedeyahino quenan cuma ye ma̱n, dema̱n ndudo cua̱co chicuahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A̱ma yune ne, ra̱hn Jua̱n yahn ihyan min tuhca̱: ―A ihyan tih che renté yahn ye ro mena̱n me cuahn che rá̱hn rí nchuhn che cochi a̱ma ihyan che tahque chahte vederihquentiyon quenan cuma ye che co u, te a va ye nde ro che metah cuhnde iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ihyan min ne, numacuahn vederihquentiyon chahte yahn ye, redin yahino ye nducoya̱co vo. ");
INSERT INTO cutNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ihyan min ne, Dihvo vo Jesucristo, che dechuh Dendiohs ihyan, chicuahn ye Ndudo yahn ye ma̱n, yahn vedeyahino yahn ye ma̱n, ne chemin ne, tahque yudo che co vederihquentiyon che dirun Moisés. ");
INSERT INTO cutNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nde a̱ma ihyan, hua ndihche ye Dendiohs Chida. Ate Dihvo vo Jesucristo, ihyan min che Da̱ya ma̱n ye, che a̱ma yahino ye ne, a ihyan min che chicuahn ye uvo ta̱ca̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","A̱ma yune ne, sa̱hn ndina̱n yahn nación yahn Israel che vate se ya̱n Jerusalén ne, dechuh se a̱ma o chidocuya̱n ndina̱n ma̱n, sa̱hn levita che redin se cuda̱do na̱n ta ma̱n, che chahn se tumerune se Jua̱n deh vederihquentiyon quenan cuma ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jua̱n ne, ra̱hn cua̱co ye ri ye sa̱hn chahn: ―U ne, ndiyu ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tumerune se ihyan: ―¿Duh ndih tuhme ne? ¿A ndih che profeta Elías ne? Ndahconan Jua̱n yahn se: ―Ndiyu u. Tumerune tun se ihyan: ―Tuhme, ¿a ndih ihyan profeta che a va ca̱de che chi ye ne? Ndahconan Jua̱n yahn se: ―Ndiyu u. ");
INSERT INTO cutNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ndaconan tumerune se ihyan: ―¿Deh vederihquentiyon quenan cuma ne ne?, te va che neca̱h cuande nuhn ihyan ndina̱n yahn nuhn che tahve ye nuhn. ¿A hua co ca̱hma ne co ne nuhn deh ntiyon quechica ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ndahconan Jua̱n yahn se: ―Ntiyon che quechicá ne, che rahndudó ya̱hn na̱n che metah duhva nduhca̱ che dirun ihyan profeta Isaías tuhca̱: “Cuihcoya̱n nchuhn chedave yahn ne ca̱va che nevahnecun ne Dihvo vo cuahn che nda̱ ye.” ");
INSERT INTO cutNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sa̱hn ndina̱n che dechuh se sa̱hn chahn ne, fariseo se. ");
INSERT INTO cutNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ra̱hn se ri se Jua̱n: ―Nducote ndiyu ndih ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse, nde huane Elías, nde huane profeta min ne, ¿deh cuande che rehdenune ne ihyan tuhme? ");
INSERT INTO cutNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ndahconan Jua̱n, ne ra̱hn ye ri ye sa̱hn: ―Ntiyon che quechicá ne, che rihcoyá̱n chedave yahn ihyan ca̱va che nevahnecun ye Dihvo vo, ne chemin che rehdenuné ihyan. Ihyan min ne, quechica ye nación yuhn vo, ne nde hua rendihche nchuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A va ye nde ro che metah cuhnde iyehnse, ne a va ca̱de che chi ye tah cuahn adive che co u. U ne, nde hua rigonun chihvé ca̱va che có mare a̱ma sa̱hn deca̱hya yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ro min ne, quenan Jua̱n rehdenune ye a̱ma cua̱n na̱n che duche Betábara, chihto ico Jordán, la̱do cua̱hn na̱n che riquenda̱h ya̱hn. Min che chahn sa̱hn chahn tumerune se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ta̱ma ro me ne, nda̱ nino Dihvo vo, ne cuahn che ndihchero Jua̱n ihyan ne, ra̱hn ye ri ye ihyan che chenun ye min: ―Condihche nchuhn. A ihyan tih che dechuh Dendiohs ihyan. Nduhca̱ a̱ma itecuche lihn che co te vedino ca̱va nunde yahn ihyan ne, tihca̱ ye, ca̱hco menda̱hn ye ihyan coh ye, nedihve ye nunde yahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","A ihyan tih che renté yahn ye ro min cuahn che tuhca̱ rá̱hn: “Cochi a̱ma ihyan che tahque chahte vederihquentiyon quenan cuma ye che co u, te a va ye nde ro che metah cuhnde iyehnse.” ");
INSERT INTO cutNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ro mena̱n me ne, nde hua devanó che a ihyan tih, ihyan che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. Ate nducote a devanó che va che chi ye ne, chemin che rehdenuné ihyan nación yuhn vo Israel, ca̱va che cuahteya̱n ye, ne nevahnecun ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Namin ra̱hn Jua̱n ri ye ihyan chahn: ―Ndihcheró Vaco Ndah yahn Dendiohs, nduhca̱ a̱ma icui, chiya, ne quenun ihyan tih. ");
INSERT INTO cutNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ro mena̱n me ne, nde hua devanó duh ihyan che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse, ate Dendiohs, ihyan min che dechuh ye u ca̱va che cuehdenuné ihyan ya̱n ne, ra̱hn ye ri ye u: “Ihyan che ndihchero che co Vaco Ndah yáhn, conun ihyan ne, a ihyan min che din ye che conun Vaco Ndah yáhn ihyan yáhn.” ");
INSERT INTO cutNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma̱n ne, a ndihché ihyan, ne rá̱hn rí nchuhn te Da̱ya Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ta̱ma ro me ne, a min tun quenan Jua̱n nduco o ihyan che rinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ura min ne, ndihchero ye che chuh Dihvo vo, ne ra̱hn Jua̱n ri ye ihyan chahn: ―A ihyan tih che dechuh Dendiohs. Nduhca̱ a̱ma itecuche lihn che co te vedino ca̱va nunde yahn ihyan ne, tihca̱ ye, te ca̱hco menda̱hn ye ihyan coh ye, nedihve ye nunde yahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chihnevan ihyan che o chahn che tihca̱ ra̱hn ye, ne cuahn ye cua̱hn na̱n cuahn Dihvo vo ca̱va che conduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ndaconan Dihvo vo, ndihchero ye ihyan chahn, ne tumerune ye: ―¿Deh renuhn nchuhn? Ndahconan ihyan chahn yahn ye: ―Ihyan Ricuahn, nuhn ne, cochi nuhn, te nahn ndihchero nuhn ti va̱co ne. ");
INSERT INTO cutNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cuhn vo nduco nchuhn, ndihchero ne. Tuhme cuahn ihyan chahn nduco ye na̱n che quenan ye, ne nducote a ri tenduh na̱n rahco cun a chino ura min ne, chahtenan ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","A̱ma cha ihyan chahn ne, duche ye Andrés, dihno Simón Pedro. ");
INSERT INTO cutNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ihyan min ne, cuahn che nda̱ca ye min ne, dinoca chahn ye chinuhn ye dihno ye Simón, ne cuahn che nta̱ca vih ye ne, ra̱hn ye ri ye ihyan: ―Nta̱ca nuhn ihyan min che Mesías. Ihyan nación yahn Israel ne, ra̱hn ye “Mesías” yahn ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ndeta̱hno quenda ye dihno ye na̱n quenan Dihvo vo, ne cuahn che nda̱ ye ne, ra̱hn Dihvo vo ri ye ihyan: ―Di ne, doche Simón, da̱ya Jonás, ate ma̱n ne, nda̱hcó che doche Cefas ―che nahn ca̱hma Pedro. ");
INSERT INTO cutNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cuahn che a chi cun ro min ne, ta̱hn nun Dihvo vo a̱ma ihyan che duche ye Felipe, ne ra̱hn ye ri ye ihyan: ―Cuhn vo, condoque u. Tuhme cuahn Dihvo vo nduco ihyan che rinduco ye ihyan esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe ne, ya̱n Betsaida ya̱n va̱co ye. Da̱ma ya̱n va̱co ye nduco Andrés ma̱n, Pedro ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ura che cuahn Felipe ne, chinuhn ye a̱ma amigo yahn ye che duche ye Natanael, ne ra̱hn ye ri ye ihyan: ―Nta̱ca nuhn ihyan min che dirun Moisés ma̱n, ihyan profeta ma̱n, yahn ye. Ihyan min ne, duche ye Jesús da̱ya José. Nazaret ya̱n va̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ra̱hn Natanael ri ye Felipe: ―¿Ta̱ca̱ che ya̱n min quenda̱h a̱ma ihyan che cochihve ye? Ndahconan Felipe yahn ye: ―Cuhn vo ndoque, ne ndihchero man. ");
INSERT INTO cutNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Cuahn che nda̱ ihyan chahn min ne, nte Dihvo vo yahn Natanael, ne ra̱hn ye: ―Ihyan cuh che cua̱co ne, redin yahn che ca̱hmo vo yahn ye che ihyan nación yahn Israel ihyan, te hua o na̱n o chende ye. ");
INSERT INTO cutNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Cuahn ino Natanael, ne ra̱hn ye: ―¿Ta̱ca̱ che a rendihche ne u? Ndahconan Dihvo vo yahn ye: ―Ndihcheró di nde ura che metah ya̱hve Felipe di, ura che ve min ma̱n ya̱hn higo me, ne a checadinó nduhca̱ ihyan di. ");
INSERT INTO cutNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Tuhme ra̱hn Natanael ri ye ihyan: ―Ihyan Ricuahn, ndih che Da̱ya Dendiohs, ndih che Rey yahn nación yuhn vo Israel. ");
INSERT INTO cutNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ra̱hn Dihvo vo ri ye ihyan: ―Chitehne u, yahn che rá̱hn rí di che ndihcheró di ma̱n ya̱hn higo me ma̱n, yahn che checadinó nduhca̱ ihyan di ma̱n, ate rá̱hn rí di te nde hua ca̱hn ine ca̱va chemin, te coma̱n ndihchero vederihno che tahque rahte ca. ");
INSERT INTO cutNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Namin ra̱hn ye ri ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te cuhnde ro vederihquentiyon chahte yahn Dendiohs che te ye quenan cumá, ne anduhneca̱ ndete che condah vahchetero, ndihchero ne u che rinducó nducoya̱ca ihyan, che cuahn cochi ángel yahn ye ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cuahn che a co ino ro che chinduco Felipe ma̱n, Natanael ma̱n, Dihvo vo ne, chihnde a̱ma vihco che rihneva̱co ihyan, a̱ma ya̱n che duche Caná, esta̱do yahn Galilea. Chaco Dihvo vo ne, a quenan ye min. ");
INSERT INTO cutNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Namin Dihvo vo nduco ihyan che rinduco ye ihyan ne, ya̱hve ihyan che redin vihco me ihyan ca̱va che ca̱hn ye conduco ye. ");
INSERT INTO cutNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cade menda̱hn vihco me ne, a chihno vino, ne ra̱hn chaco Dihvo vo ri ye ihyan: ―A chihno vino yahn ihyan sih. ¿A hua conen tah ihyan? ");
INSERT INTO cutNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ate ra̱hn Dihvo vo ri ye ihyan: ―Chacó, metah deh cuande che ca̱hma ne nducó yahn vino, te metah nda̱ ura che cuhnde ro vederihquentiyon che quenan cumá. ");
INSERT INTO cutNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tuhme ra̱hn chaco ye ri ye sa̱hn che chenan se rinan se na̱n vihco me: ―Codinahn nchuhn nducuahn che ca̱hcantiyon ye. ");
INSERT INTO cutNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Min vate a̱n chite rahte che dema̱n tu ndi ndah. Chite chemin chan ne, che retoh ihyan nación yahn Israel, rih ye nune che rena̱no ye dehtenduh ca̱va che co vihco nduhca̱ costumbre yahn ye. Queri a̱ma chite chemin chan ne, rahn tenduh a̱ma ciento litro nune. ");
INSERT INTO cutNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Cuedecuto nchuhn nune chite che tihchan vate ta̱n. Cuahn che a chihno decuto nahn se chite chahn ne, ");
INSERT INTO cutNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Ma̱n ne, cuetenda̱h nchuhn tah, ne ca̱h ne nda̱co ndihte. Dinahn sa̱hn chahn, ");
INSERT INTO cutNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ne ca̱h se nda̱co ndihte me, dechihn ye. Nune me ne, a nta̱conda̱ vino, nde hua devano nda̱co ndihte me ti chica, atena̱n sa̱hn chahn. Tuhme cah ye sa̱hn che rihneva̱co me, ");
INSERT INTO cutNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne ra̱hn ye ri ye sa̱hn: ―Nducoya̱ca ihyan che redin ye vihco ne, dinoca vino ndah reca̱h ye, ne cuahn che a ya̱ ndih ihyan ne, reca̱h ye vino ndere. Me di ne, ¿dehra cuande che denderen che redin, nde ma̱n tendah vino ndah? ");
INSERT INTO cutNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tihca̱ chi che cana̱n din Dihvo vo vederihno, min ya̱n Caná, esta̱do yahn Galilea, chihco ro ye che a̱ma yudo vederihquentiyon che quenan cuma ye, ne ihyan che rinduco ye ihyan ne, chitahno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chihno min ne, cuahn Dihvo vo ya̱n Capernaum nduco chaco ye ma̱n, dihno ye ma̱n, ihyan chahn che rinduco ye ihyan ma̱n, ne min chahtenan ye nduco vih neve ro. ");
INSERT INTO cutNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Cuahn che a nda̱ nino vihco ro yudo che renun va̱n ihyan nación yahn Israel ne, cuahn Dihvo vo ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Cuahn che nda̱ ye min ne, cuahn ye chete ya̱co chahte, ne min chenun sa̱hn che rendihcue itenine ma̱n, sa̱hn che rendihcue itecuche ma̱n, sa̱hn che rendihcue icui ma̱n. Namin min chenun sa̱hn che rendahcorun tume, vate se na̱n mesa yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tuhme din chine ye a̱ma ndi ihyo, ne nduco chemin ndetenda̱h ye sa̱hn chahn chete ya̱co, nde nduco itenine yahn se ma̱n, itecuche yahn se ma̱n. Me sa̱hn che rendahcorun tume chahn ne, chih muhn chih min ye mesa yahn se, chihtera ye tume me ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Me sa̱hn che rendihcue icui chahn ne, ra̱hn ye ri ye sa̱hn: ―¡Cuahn nchuhn cua̱hn chevah nduco dehtenduh yahn ne! ¡Hua tuma ne ya̱co yahn Chidá ca̱va che ndihcue ne dehtenduh yahn ne! ");
INSERT INTO cutNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ura min ne, nta̱ tin ihyan che rinduco ye ihyan nduhca̱ che a ndirun yahn ye na̱n Ndudo yahn Dendiohs tuhca̱: “¡A̱ma yahinó ya̱co yahn ne! ¡Hua cuahnecún che ndere din ihyan, cuahtenun ye chete!” ");
INSERT INTO cutNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sa̱hn ndina̱n yahn nación yahn Israel che redin se cuda̱do min ne, ra̱hn se ri se Dihvo vo: ―Codin a̱ma vederihno, ndihchero nuhn, cuhnde ro deh vederihquentiyon che quenan come che tihca̱ redin. ");
INSERT INTO cutNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ra̱hn ye ri ye sa̱hn: ―Ndete che ndahtera nchuhn ya̱co cuh ne, cuihno ino ro ne, nedin numá. ");
INSERT INTO cutNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tuhme ra̱hn se ri se ihyan: ―O raco a̱n nduyo chendah ihyan, che dendah ye ya̱co cuh, ¿a rahque che nduco ino ro no nedin nome? ");
INSERT INTO cutNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sa̱hn chahn ne, hua chenahn se. Ra̱hco se che yahn ya̱co che nti min che tihca̱ ra̱hn ye. Ate ra̱hn ye yahn ma̱n ye, ndiyu yahn ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nda̱ ro che ndedetuhche Dendiohs ihyan va̱n tena̱hn ne, tuhme nta̱ tin ihyan apóstol yahn ye yahn che tihca̱ ra̱hn ye, ne chitahno ye Ndudo yahn Dendiohs, chenahn ye che nduco ndudo che tihca̱ ra̱hn ye ne, conahn che va che ntuche ye va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Numanahn che quenan Dihvo vo ya̱n Jerusalén ro yudo me ne, a̱ma ya̱hn ihyan chitahno ye ihyan, yahn vederihno che din ye. ");
INSERT INTO cutNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ate Dihvo vo ne, hua chichahtino ye ihyan chahn, te a devano ye nduhchan ihyan iyehnse, rendacorun ye vederendedecadino yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hua rendotenan ye che ca̱hma ihyan nduco ye ta̱chan ye, te a ma̱n ye devano ye deh che rendedecadino queri a̱ma ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Chihnde a̱ma ihyan, partido yahn fariseo, che duche ye Nicodemo. Ihyan min ne, nduco ye va̱n ihyan ndina̱n yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tuma ye a̱ma vino, chahn ye chendihchero ye Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Ihyan Ricuahn, a devano nuhn che Dendiohs dechuh ye ndih ca̱va che cacuahn ne nuhn, te nde a̱ma ihyan hua co din ye vederihno che redin ne, ndete che hua nduco Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―Cua̱co rá̱hn rí ndih te ca̱va che nedin yahn Dendiohs ihyan, ca̱hcantiyon ye ihyan ne, va che cuahteya̱n ye quenuma ra. ");
INSERT INTO cutNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Cuahn ino Nicodemo chi, ne ra̱hn ye ri ye ihyan: ―¿Ta̱ca̱ chemin? ¿Ta̱ca̱ co ndonun a̱ma ihyan che a ndico ye chete chaco ye ca̱va che ndaconan cuhndeya̱n ye? ");
INSERT INTO cutNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Cua̱co rá̱hn rí ndih te ne, atena̱n ihyan che din Vaco Ndah yahn Dendiohs che ndacorun vederendedecadino yahn ye, ndo ye ihyan ra, cuedenune ye ne, atena̱n ihyan chahn che nedin yahn Dendiohs ihyan, ca̱hcantiyon ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Da̱ya ihyan iyehnse ne, ihyan nunde. Ate ihyan che redin Vaco Ndah yahn Dendiohs che rendacorun vederendedecadino yahn ye, rendo ye ihyan ra ne, quenun Vaco Ndah yahn Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hua ca̱hn ino ne yahn che rá̱hn rí ndih: “Nducoya̱ca ihyan, nahn che ndacorun vederendedecadino yahn ye, ndo ye ihyan ra.” ");
INSERT INTO cutNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yuhne ne, rano muhn min, ne andahre rihnevan ne, ate hua devano ne ticua̱hn rechi, nde huane ticua̱hn rahn. Atihnoca̱ Vaco Ndah yahn Dendiohs, te hua devano ne ta̱ca̱ redin che rendacorun vederendedecadino yahn ihyan, rendo ye ihyan ra. ");
INSERT INTO cutNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tuhme tumerune Nicodemo ihyan: ―¿Ta̱ca̱ che ra̱hn ne?, te hua renáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ra̱hn Dihvo vo ri ye ihyan: ―¿Ta̱ca̱ che ihyan ricuahn yahn ihyan nación yahn Israel ndih, ne hua renahn ne che rá̱hn nduco ne? ");
INSERT INTO cutNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Cua̱co rá̱hn rí ndih te nuhn ne, ra̱hn nuhn ri nuhn nchuhn yahn dehtenduh che devano nuhn ma̱n, che a ntihche nuhn ma̱n, ate nchuhn ne, hua ritahno ne. ");
INSERT INTO cutNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nducote hua ritahno nchuhn che renté nduco ne yahn dehtenduh che ri iyehnse ne, tahque hua cotahno ne ndete che nté nduco ne yahn vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nde a̱ma ihyan iyehnse ne, hua nahn ye vahchetero, ca̱va che co nte ye yahn. Atena̱n u che rinducó nducoya̱ca ihyan, te min chicá, ne min va che ndaconán. ");
INSERT INTO cutNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nduhca̱ che chaconahn Moisés cu che nta̱ve ye me tin a̱ma ya̱hn min ya̱hn na̱n che metah duhva ne, tihca̱ u che rinducó nducoya̱ca ihyan ne, va che cuaconahn ya̱h ihyan u na̱n a̱ma cruz, ");
INSERT INTO cutNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ca̱va che ndevahn nducoya̱ca ihyan che cotahno ye u, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Tihca̱, te a̱ma yahino Dendiohs ihyan iyehnse, ne andahre a̱ma ndiya̱hn ra Da̱ya ye, ate chihco menda̱hn ye ihyan, ca̱va che nducoya̱ca ihyan che cotahno ye ihyan min ne, ndevahn ye, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dechuh Dendiohs Da̱ya ye muhn iyehnse cuh, ndiyu ca̱va che din ye castigo ihyan iyehnse, ate ca̱va che cotahno ihyan iyehnse ihyan min, ndedevahn ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ihyan che ritahno ye Da̱ya Dendiohs ne, hua co ye castigo. Ate ihyan che hua ritahno ye ne, a vate menda̱hn ye che co ye castigo, te hua ritahno ye Da̱ya ma̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ihyan che hua ritahno ye Da̱ya Dendiohs ne, a vate menda̱hn che co ye castigo, te nda̱ ihyan min muhn iyehnse cuh, chicuahn ye Ndudo yahn Dendiohs, ate ihyan chahn ne, tahque yeno ye che quendi ye cuahtendihco ye nunde, ne chemin che hua chitahno ye. ");
INSERT INTO cutNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nducoya̱ca ihyan che riquendi ye rahtendihco ye nunde ne, rahcota̱hn ye yahn Ndudo yahn Dendiohs. Hua renevahnecun ye, te hua nahn ye che cuhnde ro nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ate ihyan che runeca̱de vatechica ye ne, renevahnecun ye Ndudo yahn Dendiohs, ca̱va che cuhnde ro che rinduco Dendiohs ihyan na̱n dehtenduh che redin ye. ");
INSERT INTO cutNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chihno min ne, cuahn Dihvo vo nduco ihyan che rinduco ye ihyan, esta̱do yahn Judea. Min chahtenan ye neve ro, ne chida̱ma ihyan, chedenune ye. ");
INSERT INTO cutNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Ro min ne, metah din se preso Jua̱n, ne quenan ye a̱ma cua̱n na̱n che duche Enón, nino ya̱n Salim, rehdenune ye ihyan che renda̱ ye, te min ne, a̱ma va nune. ");
INSERT INTO cutNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ta̱hn min ne, nda̱ a̱ma o sa̱hn ndina̱n yahn nación yahn Israel, ne chahtecuhn chende se nduco ihyan che rinduco ye Jua̱n, nda̱hchenan se che redenune ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tuhme chahn ihyan chahn chengo ye Jua̱n: ―Ihyan Ricuahn, ihyan che nduco ne cuahn che quenan ne viche la̱do ca̱h yahn ico Jordán, che nte ne yahn ye nduco nuhn ne, ma̱n ne, rehdenune ye ihyan, ne a̱ma ya̱hn ihyan rinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ra̱hn Jua̱n ri ye ihyan: ―Queri a̱ma vo ne, a ma̱n Dendiohs ndihco ye ta̱h vo ntiyon che redin vo. ");
INSERT INTO cutNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","A ra̱hn cua̱có rí nchuhn te ndiyu u, ihyan che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse, te ntiyon che ndihco Dendiohs tá̱h ne, che ca̱hcoyá̱n chedave yahn ihyan ca̱va che nevahnecun ye ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na̱n vihco che rihneva̱co ihyan ne, a̱ma ri yeno nda̱co ndihte cuahn che ndihchero ye che yeno sa̱hn che cahneva̱co se, te a devano ye te nda̱hca̱ rinahn ntiyon che quenan ye. Atihnoca̱ u, te a̱ma ri yenó yahn che a̱ma ri ya̱hn ihyan rinduco ye ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ihyan min ne, a va ca̱de che co chahte ntiyon yahn ye, ne u ne, a va ca̱de che cuihno ntiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Dihvo vo ne, chica ye vahchetero, ne ndina̱n ye yahn nducoya̱co vo. Ihyan iyehnse ne, rahndudo ye dema̱n yahn dehtenduh che ri iyehnse cuh. ");
INSERT INTO cutNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ihyan min ne, rahndudo ye yahn dehtenduh che ri vahchetero, che ndihche ye ma̱n, chihnevan ye ma̱n, ate atena̱n a̱ma o ra ihyan ritahno ye. ");
INSERT INTO cutNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ihyan che ritahno ye ne, reca̱h dito ye Ndudo yahn Dendiohs che rahndudo ihyan min, rihco ro ye che cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","A Dendiohs dechuh ye ihyan min, din ye che quenun Vaco Ndah yahn ye ihyan, quenan cuma ye nducuahn vederihquentiyon yahn. Chemin che numacuahn vederihquentiyon min rahndudo ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dendiohs Chida ne, yahino ye ihyan min che Da̱ya ye, nda̱hco ye nducuahn vederihquentiyon ta̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ihyan che ritahno ye ihyan min che Da̱ya Dendiohs ne, cuahtenan ye vahchetero numacuahn ro. Ate ihyan che hua ritahno ye ihyan min ne, hua nda̱ca vahchetero cuahtenan ye. Tahque ndah ne, a̱ma yah castigo din Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ta̱hn min ne, a̱ma ya̱hn ihyan rinduco ye Dihvo vo, redenune ye, ne checadino sa̱hn fariseo che tahque ya̱hn ihyan rinduco ye Dihvo vo che co Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ndiyu ma̱n Dihvo vo che rehdenune ye ihyan chahn, te ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nducote hua nahn Dihvo vo che co yudo yahn sa̱hn chahn, yahn che a̱ma ya̱hn ihyan rinduco ye ihyan ne, chica ye min esta̱do yahn Judea, cona̱hn ye esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yune cua̱hn na̱n che cuahn ye ne, chuh nación yahn Samaria. ");
INSERT INTO cutNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","A̱ma ro, tenduh na̱n inguiya̱hn ne, nda̱ ye chihto a̱ma ya̱n yahn Samaria che duche Sicar, na̱n ya̱hn yahn Jacob che chihco ye yahn da̱ya ye José. Min va a̱ma pozo nune che duche Pozo yahn Jacob, ne nducote ndi cuno Dihvo vo ne, cuahn ye chihnde ye chihto pozo me. ");
INSERT INTO cutNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ihyan apóstol yahn ye ne, cuahn ye viya̱n me cua ye dehtenduh che cheh ye nduco vih. Ura min ne, nda̱ a̱ma ta̱hn ya̱n min na̱n pozo me tenda̱h te nune, ne ra̱hn Dihvo vo ri ye ta̱hn: ―¿A hua te tah nune, cúh? ");
INSERT INTO cutNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Cuahn ino te, ne ra̱hn te ri te ihyan: ―¿Ta̱ca̱ che rica ne nune cuh ne u?, te ndih ne, ihyan nación yahn Israel ndih, ne u ne, ihyan nación yahn Samaria u. (Tihca̱ ra̱hn te, te ihyan nación yahn Israel ne, nde hua rente ye nduco ihyan nación yahn Samaria.) ");
INSERT INTO cutNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tuhme ra̱hn Dihvo vo ri ye ta̱hn: ―Nde hua renehn yahn vedeyahino yahn Dendiohs, nde hua devene duh u che ricá nune di, te ndete che devene ne, man caque nune u, nune min che vedevihche yahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ra̱hn te ri te ihyan: ―Pozo cuh ne, a̱ma ya̱no, ne ndih ne, nde hua nda ne deh che tenda̱h nduco ne nune, ¿ti ra ngua ne nune che ra̱hn ne che te ne u? ");
INSERT INTO cutNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ihyan ndico yahn nuhn Jacob, chino ye pozo cuh, chichihve yahn ma̱n ye ma̱n, yahn da̱ya ye ma̱n, yahn ite nda̱ta yahn ye ma̱n, ne ma̱n ne, nuhnde ta̱h nuhn. ¿A ra̱hco ne che tahque rigonun chihve ne che co ihyan min? ");
INSERT INTO cutNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ra̱hn ye ri ye ta̱hn: ―Nducoya̱ca ihyan che cuh ye nune tih ne, ndaconan co ya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ate ihyan che cuh ye nune che cá̱h ne, ametah ndaconan co ya̱ca ye, te nune min ne, hua nda̱ ro che tihnan, ne din che cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tuhme ra̱hn te ri te ihyan: ―Te ne nune che ra̱hn ne me, cúh, ca̱va che ametah ndaconan co ya̱cá, ne hua conan cuma che chí tendá̱h na̱n pozo cuh. ");
INSERT INTO cutNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ra̱hn ye ri ye ta̱hn: ―Cuehn ngua inchahn, tuhme cochi nduco se. ");
INSERT INTO cutNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","18","Ndahconan te yahn ye: ―Metah inchá̱hn. Tuhme ra̱hn ye ri ye ta̱hn: ―Cua̱co rahn che metah inchahn, te ro mena̱n ne, uhn inchahn nenan come, ate sa̱hn che quenan come ma̱n ne, ndere quenen nduco se. ");
INSERT INTO cutNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cuahn che chihnevan te che tihca̱ ra̱hn ye ne, ra̱hn te ri te ihyan: ―Che tihca̱ ra̱hn ne ri ne u ne, a ndero ndi che ihyan profeta ndih. ");
INSERT INTO cutNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ihyan ndico yahn nuhn ne, muhn cuete cuh rechi ye rendeva ye yavena̱n Dendiohs, ne nchuhn ihyan nación yahn Israel ne, ra̱hn ne te min ya̱n Jerusalén va che ndeva vo yavena̱n ye. ¿Cha che cua̱co ne? ");
INSERT INTO cutNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ndahconan ye yahn te: ―Cuedevene te ndiyu dema̱n cuete cuh, nde huane dema̱n ya̱n Jerusalén ndeva ihyan yavena̱n Dendiohs Chida, te a nda̱ ro che, adecotino che chenan ihyan ne, a min no co ndeva ye yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nchuhn, ihyan nación yahn Samaria ne, nde hua devano ne ta̱ca̱ va ca̱de che ndeva ihyan yavena̱n Dendiohs. Ate nuhn ihyan nación yahn Israel ne, a devano nuhn, te a va̱n nda̱ta yahn nuhn, quenda̱h ihyan che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","A nda̱ ro che ihyan che redin yahn che ca̱hmo vo che rendeva ye yavena̱n Dendiohs Chida ne, rendeva ye yavena̱n ye numacuahn chedave yahn ye ma̱n, numa cua̱co ma̱n, te ihyan min ne, nahn ye che tihca̱ ndeva ihyan yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dendiohs ne, a̱ma Vaco, ne ihyan che rendeva ye yavena̱n ye ne, nahn che ndeva ye numacuahn chedave yahn ye ma̱n, numa cua̱co ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ra̱hn te ri te ihyan: ―A devanó che va che chi ihyan min che Mesías, che a va ca̱de che ndedevahn ye ihyan iyehnse, ne cuahn che nda̱ ye ne, te cuande ye uvo yahn nducuahn. ");
INSERT INTO cutNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ra̱hn ye ri ye ta̱hn: ―A u, ihyan min, che renté ndoque. ");
INSERT INTO cutNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ura min nta̱ ihyan apóstol yahn ye, ne cuahn ino ihyan chahn che rente ye nduco a̱ma nda̱hta, ate nde a̱ma ye hua chihquino ye tumerune ye ihyan deh chica ye ta̱hn ma̱n, deh yahn che rente ye nduco te ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tuhme chihco te cuhte yahn te min, cona̱hn te, ne ra̱hn te ri te ihyan viya̱n: ");
INSERT INTO cutNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Cochi nchuhn ndihchero ne a̱ma ihyan che ra̱hn ye ri ye u nducuahn che nedín. Co a ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tuhme cuahn ihyan ya̱n quendihchero ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Numanahn min ne, ra̱hn ihyan apóstol yahn ye ri ye ihyan: ―Ihyan Ricuahn, ¿a hua cheh inguiya̱hn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―U ne, va a̱ma comida yáhn, che nde hua devano nchuhn yahn. ");
INSERT INTO cutNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ate hua chenahn ihyan chahn deh conahn che tihca̱ ra̱hn ye, ne rente ye va̱n ma̱n ye nduco vih: ―¿A va duh che checu che cheh ye, che tihca̱ ra̱hn ye? ");
INSERT INTO cutNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tuhme ra̱hn ye ri ye ihyan chahn: ―Che dináhn na̱n ntiyon yahn Dendiohs, ihyan min che dechuh ye u ne, chemin che vedeyeno yáhn, anduhneca̱ a̱ma comida yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nchuhn ne, ra̱hn ne te renda ca te cun iyo ca̱va che ndeva̱hn ihyan ndute nda̱ta. Ate u ne, rá̱hn rí nchuhn te, nde meniyon ne, a̱ma ya̱hn ihyan vateya̱n ye ca̱va che ca̱hcovan ye Ndudo yahn Dendiohs che cuahndudo ne. ");
INSERT INTO cutNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na̱n ntiyon yahn ihyan ne, na̱hn cua̱n ne, a̱ma ye rino ye ndute nda̱ta, ne ta̱ma ye rendeva̱hn ye cuahn che a ri yahn. Atihnoca̱ na̱n ntiyon yahn Dendiohs, te na̱hn cua̱n ne, a̱ma ye rana̱n ye rahndudo ye Ndudo yahn Dendiohs, ne ta̱ma ye riquendi ye, tuhme ritahno ihyan. Ihyan che ritahno ye ne, rendevahn ye, ne cuahtenan ye vahchetero numacuahn ro. Me ihyan che redin ye ntiyon min, ihyan che rahndudo ye mena̱n ma̱n, ihyan che rahndudo ye cuahn che a ritahno ihyan ma̱n ne, rahte yeno a̱ma ta̱ma ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nducote tihca̱ ne, riquenda̱h cua̱co ndudo che tuhca̱ rente ihyan: “A̱ma ye rino ye ndute nda̱ta, ne ta̱ma ye rendeva̱hn ye cuahn che a ri yahn.” ");
INSERT INTO cutNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","U ne, dechúh nchuhn, cuahndudo ne Ndudo yahn Dendiohs na̱n che a vih ihyan nedin ye ntiyon, ne ndonda̱ ta̱h ne ntiyon min quendi ne. ");
INSERT INTO cutNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A̱ma ya̱hn ihyan ya̱n min, rente ta̱hn min nduco ye yahn che ra̱hn Dihvo vo ri ye ta̱hn nducuahn che nedin te, ne chitahno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chemin che cuahn che nda̱ ihyan ya̱n chahn na̱n Dihvo vo ne, ya̱hve ye ihyan che conan ye min. Quenan ye ya̱n min o ro, ");
INSERT INTO cutNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ne nde tahque ya̱hn ca ihyan chitahno ye ihyan cuahn che chihnevan ye che rahndudo ye. ");
INSERT INTO cutNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tuhme ra̱hn ihyan ya̱n chahn ri ye ta̱hn min: ―Chitahno nuhn ihyan min, yahn che nte yahn ye nduco nuhn. Ate ma̱n ne, tahque chichahtino nuhn ihyan, te chihnevan ma̱n nuhn che rahndudo ye. A devano cua̱co nuhn te a ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chihno nduh che o ro min ne, chica Dihvo vo ya̱n min cuahn ye cua̱hn esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nducote ma̱n ye ra̱hn ye te atena̱n ihyan ta̱ma ya̱n che renevahnecun ye ihyan profeta, ndiyu ihyan ya̱n va̱co ye ne, chemin che cuahn ye min. ");
INSERT INTO cutNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Cuahn che nda̱ ye ne, ihyan che vate ye min ne, a̱ma nevahnecun ye ihyan, te namin chahn ihyan chahn ya̱n Jerusalén vihco ro yudo, ne ndihchero ye vederihno che din ye min. ");
INSERT INTO cutNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Cuahn che quechica ye min esta̱do yahn Galilea ne, nda̱ tun ye ya̱n Caná, ya̱n min na̱n che din ye vederihno, din ye che nda̱conda̱ vino nune me. Numanahn che quenan ye ya̱n min ne, nda̱ a̱ma sa̱hn ndina̱n che va se ya̱n Capernaum, rinuhn se ihyan. Sa̱hn min ne, a̱ma cah sa̱hn dihn yahn se, adeche coh se, ne chemin che, cuahn che checadino se che a ndaconan Dihvo vo che chahn ye esta̱do yahn Judea ne, chahn se ya̱hve se ihyan. Chica se favor ihyan che ca̱hn ye ndeva̱co se, din ye che ndoyahn da̱ya se. ");
INSERT INTO cutNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Nchuhn ne, nde hua cotahno ne ndete che hua ndihchero ne vederihno. ");
INSERT INTO cutNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ate ra̱hn se ri se ihyan: ―Co din favor, ne cuhn vo nduco ne, te adeche coh da̱yá. ");
INSERT INTO cutNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tuhme ra̱hn ye ri ye sa̱hn: ―Co ndaconen conahn, te sa̱hn daye ne, a ndoyahn se. Chitahno se che ra̱hn ye, ne cona̱hn se. ");
INSERT INTO cutNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ura che a nta̱ nino se ndeva̱co se ne, chahn a̱ma o mozo yahn se chendi yune se sa̱hn, ne ra̱hn se ri se sa̱hn: ―Sa̱hn dihn yahn ne, a ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tumerune se sa̱hn chahn deh ura cana̱n chihnde dihn yahn da̱ya se. Ndahconan sa̱hn chahn yahn se: ―Ico, na̱n rahco a̱ma a chino, chavi ihno che neta̱h sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tuhme nta̱ tin sa̱hn ndina̱n me che a ura min ra̱hn Dihvo vo nduco se che a ndoyahn da̱ya se, ne chemin che chitahno se ihyan nduco nducoya̱ca ihyan yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nduco chemin chi o yune che din Dihvo vo vederihno esta̱do yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cuahn che quenan ca Dihvo vo esta̱do yahn Galilea ne, quenun a̱ma vihco yahn ihyan nación yahn Israel min ya̱n Jerusalén, ne cuahn Dihvo vo vihco me. ");
INSERT INTO cutNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A̱ma chendevah yahn chete che ndacoriya ya̱n min ne, duche Chendevah yahn Itecuche. Nino chendevah min ne, va a̱ma tanque nune che duche Betesda, che deva̱co hebreo. Chihto tanque me ne, chendihco uhn corredor, ");
INSERT INTO cutNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ne min chenun a̱ma ya̱hn ihyan che ve na̱n ye ma̱n, ihyan che neneva doh ca̱h ye ma̱n, ihyan che ndi cheche ye ma̱n, chenan rino ye ura che nuhn nune me. ");
INSERT INTO cutNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yahn quenun riya a̱ma ángel, rendahcheta̱hn ye nune me, ne ihyan che conun conda̱ ye va̱n nune me ura che cuihno ndahcheta̱hn ne, ndoyahn ye, adecodehno che ndi yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Min quendite a̱ma sa̱hn che a ri ndico ntihyon ino nduyo che ndi cheche se. ");
INSERT INTO cutNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nda̱ Dihvo vo min, ne ndihchero ye sa̱hn. Checadino ye che a ra̱hn cuahn ndi cheche se, ne tumerune ye sa̱hn: ―¿A nehn che ndoyehn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ndaconan se yahn ye: ―Ta̱ca̱ hua. Nahn che ndoyáhn, ate metah duh ihyan che quenda ye u va̱n nune ura che nuhn. Queri a̱ma yune che redín fuerza, nahn conda̱ va̱n nune ne, ta̱ma ca ihyan rechuhnan ye u, renda̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Cuenecuen, condo tah yundo yehn, ne cuique. ");
INSERT INTO cutNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","A ndeta̱hno ndoyahn sa̱hn min, ndo ta̱h se yundo yahn se, ne cana̱n rica se. Ro min ne, a̱ma ro che rahtetuhno ihyan, ");
INSERT INTO cutNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ne a̱ma o sa̱hn ndina̱n yahn nación yahn Israel ne, ra̱hn se ri se sa̱hn che ndoyahn me: ―Ma̱n ne, ro che rahtetuhno vo. Hua redin yahn che din ntiyon, quenohn yundo yehn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ndahconan sa̱hn min, ne ra̱hn se ri se sa̱hn chahn: ―Hua te, a ma̱n ihyan che din ye che ndoyáhn, chihquentiyon ye che quenúhn yundo yáhn, ne ca̱cá. ");
INSERT INTO cutNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tuhme tumerune sa̱hn chahn sa̱hn: ―¿Duh ihyan min che chihquentiyon ye che quenohn yundo yehn, caque ne? ");
INSERT INTO cutNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ate sa̱hn min ne, nde hua devano se che a Dihvo vo Jesucristo che din ye che ndoyahn se, te a̱ma ya̱hn ihyan chenun ye min, ne ndeta̱hno chenda̱ ye va̱n ihyan, cheh na̱n se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Adive ne, ndihchero Dihvo vo sa̱hn, quenun se chete ya̱co, ne ra̱hn ye ri ye sa̱hn: ―Cuihcoven che ca̱hmá có di. Ma̱n che a ndoyehn ne, ametah ndaconen condihque nunde ca̱va che hua cota̱h ta̱ma cah di, din che tahque chuhrihn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tuhme chahn sa̱hn min, chengo se sa̱hn ndina̱n chahn che a Dihvo vo che din ye che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nducote a ro che rahtetuhno ihyan redin Dihvo vo che rendoyahn ihyan cah ne, chemin che din ta̱n sa̱hn chahn nduco ye, nahn ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","A̱ma yune ne, ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Chidá ne, cuahn da̱ma redin ye che ndah ca̱va ihyan, ne u ne, riquendí yune yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Che tihca̱ ra̱hn ye ne, nde tahque chi ta̱n sa̱hn ndina̱n chahn, nahn ca̱hno se ihyan, te cuahn che ra̱hn ye te a Dendiohs che Chida ye ne, ra̱hco se te duche rino ye ihyan, nahn co ye da̱ma nduhca̱ ihyan min. Ava̱ne ne, nducote redin Dihvo vo che rendoyahn ihyan cah, andahre ro che rahtetuhno ihyan ne, ra̱hco se te rahcota̱hn ye che rihquentiyon ley nduhca̱ che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tuhme ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Cua̱co rá̱hn rí nchuhn te hua co dín nde a̱ma na̱n ntiyon che ndiyu ntiyon yahn Chidá. Nducuahn che redin ye ne, namin redín. ");
INSERT INTO cutNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chidá ne, yahino ye u, ne ma̱n ye nduco ye u redin ye nducuahn vederihno. Nde va ca vederihno che tahque rahte che din ye, ne a̱ma ca̱hn ino nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Cuahn che má̱n náhn ne, nde ndedetuhché tena̱hn, nduhca̱ che redin Chidá. ");
INSERT INTO cutNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Chidá ne, nda̱hco ye vederihquentiyon yahn ye tá̱h, ca̱va che techeca̱dé yahn nducoya̱ca ihyan, ");
INSERT INTO cutNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","te nahn ye che ndeva ihyan yavená̱n nduhca̱ che rendeva ihyan yavena̱n ye. Ihyan che hua rendeva ye yavená̱n ne, namin hua rendeva ye yavena̱n Chidá, ihyan min che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Cua̱co rá̱hn rí nchuhn te ihyan che rihcovan ye ndudo yáhn, ne ritahno ye ihyan min che dechuh ye u ne, cuahtenan ye vahchetero numacuahn ro. Ihyan chahn ne, hua conda ye, te ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Cua̱co rá̱hn rí nchuhn te nducoya̱ca ihyan nunde ne, anduhneca̱ ndete che a ndih ye na̱n Dendiohs. Ma̱n ne, a nda̱ ro che cahnevan ye ndudo yáhn, ne nducoya̱ca ye che cotahno ye ne, ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tihca̱, te Chidá ne, quenan cuma ye vederihquentiyon ca̱va che ndedevahn ye ihyan iyehnse, ne nda̱hco ye vederihquentiyon min tá̱h. ");
INSERT INTO cutNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Namin nda̱hco ye vederihquentiyon tá̱h ca̱va che techeca̱dé yahn ihyan iyehnse, te a u che rinducó nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hua ca̱hn ino nchuhn che tihca̱ rá̱hn, te nda̱ ro che, nducoya̱ca tena̱hn ne, cahnevan ye ndudo yáhn, ");
INSERT INTO cutNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ne ntuche ye. Ihyan che ndah din ye chahtenan ye iyehnse ne, cuahtenan ye vahchetero, ne ihyan che hua ndah din ye ne, co ye castigo. ");
INSERT INTO cutNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Che tin demá̱n ne, hua co dín nde a̱ma na̱n dehtenduh. Retecheca̱dé nduhca̱ che rihquentiyon Dendiohs Chida u, ne nducuahn che retecheca̱dé ne, numa cua̱co, te a ndudo yahn ihyan min ndiyu ndudo yahn má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Cuahn che rendonán vederihquentiyon che quenan cumá ne, nde hua richihve che renté, che ra̱hco nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ate che rendonan Dendiohs vederihquentiyon yáhn ne, a ndero ndi che cua̱co, te ihyan min ne, cua̱co nducuahn che ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nchuhn ne, tahve ne sa̱hn che tumerune se Jua̱n, ne ndudo che ndahconan ye yahn ne yahn vederihquentiyon che quenan cumá ne, cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","U ne, hua rendotenan che ihyan iyehnse ca̱hma nan ye u, ate ntihyon yá̱n ndudo che ndahconan ye yahn ne, ca̱va che cotahno ne u, ne ndevahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jua̱n ne, nduhca̱ a̱ma ya̱hn che din che chi ro dave na̱n ne neve ro, te chicuahn ye nchuhn yahn vederihquentiyon yáhn, ne quenan ino ne. ");
INSERT INTO cutNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ate vederihno che redín ne, tahque rihco ro che quenan cumá vederihquentiyon che co ndudo che ra̱hn Jua̱n yáhn, te ca̱va chemin ne, a ndero ndi che a Dendiohs Chida dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Namin, andahre hua nihnevan nchuhn ndudo yahn Dendiohs Chida, nde hua ntihche ne ihyan, ate rihco ro ye va̱n nchuhn, che ma̱n ye dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Me nchuhn ne, raconda̱h veda̱me ne ndudo yahn ye, te hua ritahno ne u che ma̱n ye dechuh ye. ");
INSERT INTO cutNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Rendihchenan ne Ndudo yahn ye nduco cuda̱do, te ra̱hco ne te ndudo min din che ndevahn ne, ne cuahtenan ne vahchetero numacuahn ro. Ate nde hua retumacadino ne che a na̱n Ndudo min ndirun yahn vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hua nahn cotahno ne u ca̱va che ndevahn ne, cuahtenan ne vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’U ne, hua rendotenán che ndeva nchuhn yavená̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ava̱ne ne, a rendihché nduhchan ihyan nchuhn, ne a devanó che hua yahino ne Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","U ne, ma̱n Chidá dechuh ye u, ne nchuhn ne, raconda̱h veda̱me ne u. Ate ndete che nda̱ ta̱ma sa̱hn che ricuahn se vededevano yahn ma̱n se ne, sa̱hn min che cua̱co nevahnecun ne sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ta̱ca̱ co cotahno nchuhn Dendiohs?, te ndotenan che nuhn ino ne dinahn ne, ca̱va che co yeno ye nduco ne ne, renan ino ne rendeva a̱ma ta̱ma ne yavena̱n vih. ");
INSERT INTO cutNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ndiyu u che ca̱hco ró nunde yahn nchuhn na̱n Chidá, te a ley che dirun Moisés, che a̱ma ndichahtino nchuhn ne, a chemin che renuhnde nunde yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ndete che ritahno nchuhn che dirun Moisés ne, namin cotahno ne u, te ihyan min dirun ye yahn vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ate nducote hua ritahno ne ndudo che dirun ye ne, chemin che nde hua co cotahno ne ndudo yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chihno min ne, cuahn Dihvo vo ta̱ma la̱do viche yahn vine yahn Galilea, na̱n che duche Tiberias. ");
INSERT INTO cutNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nducote rendihchero ihyan vederihno che redin ye che rendoyahn ihyan cah ne, chemin che a̱ma ya̱hn ihyan cuahn ye nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Cuahn che nda̱ Dihvo vo min ne, cocha ye a̱ma tingüete chihnde ye nduco ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ro min ne, a nda̱ nino vihco ro yudo yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cuahn che ndihchero Dihvo vo che a̱ma ya̱hn ihyan nda̱ ye chida̱ma ye min ne, tumerune ye Felipe: ―¿Ti cuhn vo cua vo che cheh nducoya̱ca ihyan sih ne? ");
INSERT INTO cutNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Dihvo vo ne, a dera̱hn ye tihca̱ che nahn cadino ye deh ca̱hma Felipe, te ma̱n ye ne, a devano ye ta̱ca̱ din ye che ca̱hcacheh ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ndahconan Felipe yahn ye: ―Andahre o ciento tume diya̱hngua quenda vo che cua vo pa̱n ne, nde hua tuno ca̱va che nda̱ca tahsihn, cheh queri a̱ma ihyan sih. ");
INSERT INTO cutNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tuhme ta̱ma ihyan apóstol, ihyan min che duche ye Andrés, dihno Simón Pedro ne, ra̱hn ye ri ye Dihvo vo: ");
INSERT INTO cutNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Muhn quenun a̱ma sa̱hn dihn che nda se uhn pa̱n che ndindah nduco cebada ma̱n, o ya̱hca ma̱n. Ate ra̱hcó che dehra cochihve chemin ca̱va ihyan sih, te a̱ma ya̱hn ri ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ra̱hn Dihvo vo: ―Ca̱hma nchuhn co ne nducoya̱ca ihyan sih che cuahte ye. A̱ma va chano ca̱hya min, ne chahte ihyan chahn na̱n chano me. Che dema̱n ihyan cha̱hn ne, ri tenduh uhn mil ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tuhme cheta̱h Dihvo vo pa̱n me, ne neca̱h ye nundihve cuahn Dendiohs. Chihno min ne, ca̱h ye ihyan apóstol yahn ye ca̱va che ca̱h ye cheh nducoya̱ca ihyan. Namin cheta̱h ye ya̱hca me. Atihnoca̱ din ye, ne cheh nducoya̱ca ihyan nde na̱n che chito ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cuahn che a chenan cheh ihyan ne, ra̱hn Dihvo vo ri ye ihyan apóstol: ―Cuendeva̱hn nchuhn nducuahn che nga̱va ca̱va che hua cora. ");
INSERT INTO cutNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ndeva̱hn ihyan chahn nducuahn, ne chito ndichio cuahte cheyahn pa̱n me che nga̱va. ");
INSERT INTO cutNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nducote ndihchero ihyan vederihno min che din Dihvo ne, ra̱hn ye: ―Cua̱co niyon te ihyan cuh, ihyan profeta che a va ca̱de che chi ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Checadino Dihvo vo che nahn quenda ihyan chahn ihyan nduco fuerza, ca̱va che co ye rey yahn ye, ne chemin che ndiquenda̱h ye va̱n ye, cuahn ye dema̱n ye ta̱ma tingüete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cuahn che a chi da̱h ne, cuenechahn ihyan apóstol chahn cuahn chihto vine me. ");
INSERT INTO cutNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chahtenun ye chete a̱ma ba̱rco che va min, ne cuahn ye ta̱ma la̱do viche me, cua̱hn ya̱n Capernaum. A man, ne Dihvo vo ne, a hua renta̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ura min ne, cana̱n rano yuhne ta̱n, ne a̱ma rendedecuan nune vine me. ");
INSERT INTO cutNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","A cuahn ihyan chahn nduco ba̱rco me tenduh a̱n mil metro, cuahn che ndihchero ye Dihvo vo, che a nda̱ nino ye, rica ye na̱n nune vine me, ne a̱ma dihya ye chi. ");
INSERT INTO cutNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―A u che ntá̱. ¡Condi nchuhn dihya ne co! ");
INSERT INTO cutNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Chenda̱ Dihvo vo chete ba̱rco me, ne a̱ma yeno ihyan chahn, netumanecun ye ihyan. Nduco venchahte no nda̱ ba̱rco me na̱n che cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Me ihyan che chahtenan ye ta̱ma la̱do viche yahn vine me ne, tumacadino ye chi dave ta̱ma ro me, che ihyan apóstol chahn ne, chahtenun ye chete a̱ma ndiya̱hn ra ba̱rco che va min, cuahn ye, ne Dihvo vo ne, hua cuahn ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Numanahn che chenan ye min ne, nda̱ neve ba̱rco che chica ya̱n Tiberias, ne chan chihto vine, nino na̱n che cheh ye pa̱n che ca̱h Dihvo vo a a̱ma ro me. ");
INSERT INTO cutNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nducote ndihchero ihyan chahn che ametah Dihvo vo min, nde huane ihyan apóstol yahn ye ne, chahtenun ye chete ba̱rco chahn, cuahn ye ya̱n Capernaum, quenuhn ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cuahn che a tuche ihyan chahn vine me, nda̱ ye na̱n che quenun Dihvo vo, ne tumerune ye ihyan: ―Ihyan Ricuahn, ¿deh ura nda̱ ne muhn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ate ra̱hn Dihvo vo ri ye ihyan: ―Cua̱co rá̱hn rí nchuhn te rinuhn ne u, yahn che chihcachéh nchuhn nde na̱n che chito nchuhn, ndiyu yahn che chenahn ne yahn vederihno che dín. ");
INSERT INTO cutNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hua cua̱hcora̱n nchuhn dema̱n yahn dehtenduh che reh ne, te chemin ne, rihno. Tahque ndah ne ne, codinun ino ne, cuihcovan ne ndudo yáhn, ca̱va che ndevahn ne, ne cuahtenan ne vahchetero numacuahn ro. Ndudo yáhn ne, anduhneca a̱ma comida che ngu cuahn da̱ma yahn ne. Tihca̱, te u che rinducó nducoya̱ca ihyan ne, nda̱hco Dendiohs Chida vederihquentiyon tá̱h, ca̱va che ndedeváhn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tuhme tumerune ihyan chahn Dihvo vo: ―¿A va vederihquentiyon yahn Dendiohs che va che dinahn nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Che nahn Dendiohs ne, che cotahno nchuhn u che ma̱n ye dechuh ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ndaconan tumerune ihyan chahn Dihvo vo: ―¿Deh vederihno co din ne, ndihchero nuhn, ca̱va che cotahno nuhn ndih ne? ¿Deh ntiyon nda ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ihyan ndico yahn nuhn ne, cheh ye pa̱n che duche maná, min ya̱hn na̱n che metah duhva nduhca̱ che ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Ca̱h Dendiohs pa̱n che chica vahchetero, cheh ye.” ");
INSERT INTO cutNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn: Pa̱n che chica vahchetero ne, ndiyu Moisés che ca̱h ye ihyan, te a Chidá. Namin rete ye nchuhn ta̱ma na̱n pa̱n che tahque ndah che chica vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pa̱n min che ca̱h Dendiohs ne, chica vahchetero, ne nduco chemin rendevahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tuhme ra̱hn ihyan chahn ri ye Dihvo vo: ―Te ne pa̱n che ra̱hn ne me nuhn ro ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ra̱hn Dihvo vo ri ye ihyan chahn: ―A u che anduhneca̱ pa̱n ca̱va ihyan che ritahno ye u, te rendedeváhn ihyan, ne cuahtenan ye vahchetero. Che reh ihyan ma̱n, che rih ye ma̱n ne, hua retumanan ihyan cuahn da̱ma. Ate vedeyahino yáhn ca̱va ihyan che ritahno ye u, ne hua nda̱ ro che cuihno. ");
INSERT INTO cutNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ate nchuhn ne, hua ritahno ne u, andahre rendihchero ne u, nduhca̱ che a rá̱hn rí nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nducoya̱ca ihyan che retenda̱hnun Chidá ca̱va che cotahno ye u ne, ritahno ye u, ne hua raconda̱h veda̱mé ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tihca̱, te u ne, chicá vahchetero, dechuh Chidá u, ca̱va che dináhn che nahn ye, ndiyu che nahn má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Chidá ne, dechuh ye u, ne nahn ye che ndedeváhn nducoya̱ca ihyan che ma̱n ye tenda̱hnun ye ca̱va che cotahno ye u. Namin nahn ye che ndedetuhché ihyan chahn ro che cuihno iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chidá ne, nahn ye che nducoya̱ca ihyan che ndihchero ye u che Da̱ya ye, ne cotahno ye u ne, ndedetuhché ihyan ro che cuihno iyehnse, ne cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nducote ra̱hn Dihvo vo yahn ma̱n ye, che anduhneca̱ pa̱n che chica vahchetero ca̱va ihyan iyehnse ne, chemin che nda̱hchenan sa̱hn ndina̱n yahn nación yahn Israel chahn ihyan, ");
INSERT INTO cutNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ne rente se va̱n ma̱n se nduco vih: ―Ihyan tih che Jesús, che da̱ya José me. Uvo ne, a rendihcho vo chida ye ma̱n, chaco ye ma̱n, ¿me dehco che ra̱hn ye che vahchetero chica ye? ");
INSERT INTO cutNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tuhme ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Hua nda̱hchenan nchuhn u. ");
INSERT INTO cutNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cuedevano ne te nde a̱ma ihyan hua co cotahno ye u, ndete che hua ma̱n Chidá tenda̱hnun ye ihyan. Nducoya̱ca ihyan che cotahno ye u ne, ndedetuhché ihyan ro che cuihno iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na̱n libro che dirun ihyan profeta ne, tuhca̱ ra̱hn: “Dendiohs ne, din ye che conahn nducoya̱ca ihyan.” Chemin che nducoya̱ca ihyan che redinahn ye yahn Dendiohs Chida ne, ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nde a̱ma ihyan iyehnse ne, hua ntihche ye Dendiohs Chida. Atena̱n u che rendihché ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Cua̱co rá̱hn rí nchuhn te ihyan che ritahno ye u ne, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","U ne, anduhneca̱ pa̱n ca̱va ihyan iyehnse, te rendedeváhn ihyan, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ihyan ndico yahn nchuhn ne, cheh ye pa̱n che duche maná min ya̱hn na̱n che metah duhva, ate pa̱n min ne, metah vederihquentiyon yahn ca̱va che ndevahn ye, cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Ate ihyan che cheh ye pa̱n che chica vahchetero ne, cuahtenan ye vahchetero numacuahn ro. Pa̱n min ne, redin che rendevahn ihyan. Adecoduhno ihyan che cheh ye ne, ndevahn ye, ne cuahtenan ye vahchetero numacuahn ro. Che rá̱hn yahn pa̱n min ne, rá̱hn yahn má̱n, te va che ca̱hco mendá̱hn u cóh, ca̱va che ndedeváhn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tuhme a̱ma ndeh rente sa̱hn ndina̱n chahn va̱n ma̱n se nduco vih, ne ra̱hn se: ―¿Ta̱ca̱ che ra̱hn ihyan tih che covahn ye pa̱n, ca̱va che chuh vo ihyan? ");
INSERT INTO cutNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ra̱hn Dihvo vo ri ye sa̱hn: ―Cua̱co rá̱hn rí nchuhn te, u che rinducó nducoya̱ca ihyan ne, ca̱va che ndevahn ne ne, va che cotahno ne u ma̱n, cochahtino ne yun yáhn che cora ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ihyan che cotahno ye u, ne cochahtino ye yun yáhn che cora ne, ndedetuhché ihyan ro che cuihno iyehnse, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tihca̱, te ca̱va che co ndevahn ihyan ne, va che ca̱hco mendá̱hn u, cora yun yáhn ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ihyan che cotahno ye u, ne cochahtino yun yáhn che corá ne, conduco ye u, ne dín cuda̱do ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Dendiohs Chida ne, hua nda̱ ro che cuihno ye. A ihyan min che dechuh ye u, ne vedeyeno yáhn ne, che richahtinó ihyan. Me ihyan che richahtino ye u ne, ndedeváhn ihyan, cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","U ne, anduhnca̱ pa̱n che chica vahchetero, ca̱va ihyan iyehnse. Pa̱n che duche maná, che cheh ihyan ndico yahn nchuhn ne, metah vederihquentiyon yahn ca̱va che ndevahn ihyan, cuahtenan ye vahchetero. Ate ihyan che cochahtino ye u ne, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chete ya̱co, min ya̱n Capernaum, che tihca̱ chicuahn Dihvo vo sa̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Chihno chicuahn Dihvo vo ndudo min ne, nde ihyan che rinducó ye ihyan ne, a̱ma ya̱hn ye ra̱hn ye: Ndudo che tihca̱ ricuahn ye ne, a̱ma va̱hche. Nde a̱ma ihyan hua co nevahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Checadino Dihvo vo che hua chahtenan ino ihyan chahn ndudo che chicuahn ye, ne ra̱hn ye ri ye ihyan: ―Nducote hua chahtenan ino nchuhn ndudo che tihca̱ ricuáhn ne, ");
INSERT INTO cutNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","nde tahque hua cuahtenan ino ne ndete che ndihchero ne u che rinducó nducoya̱ca ihyan, che ná̱hn vahchetero na̱n che chicá. ");
INSERT INTO cutNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Vaco Ndah yahn Dendiohs che redin che rendevahn ihyan. U ne, ca̱hco mendá̱hn u cóh, nedihvé nunde yahn ihyan iyehnse, ate a Vaco Ndah yahn Dendiohs che redin che rendevahn ye. Ndudo che renté nduco nchuhn ne, renté numacuahn vederihquentiyon yahn Vaco Ndah yahn Dendiohs, ca̱va che ndevahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ate hua nducoya̱ca nchuhn ritahno ne. Tihca̱ ra̱hn Dihvo vo, te a devano ye nde ro mena̱n, duhtenduh ihyan che hua ritahno ye ihyan ma̱n, sa̱hn che va che ndihcue ndeh se ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Namin ra̱hn ye: ―Rá̱hn rí nchuhn te ihyan che ma̱n Chidá tenda̱hnun ye ihyan ne, atena̱n ihyan chahn che co cotahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","A̱ma ya̱hn ihyan che chinduco ye Dihvo vo ro mena̱n ne, chihcoma̱n ye ihyan nde ro min, ametah chinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tuhme tumerune Dihvo vo nduh che ndichio ihyan apóstol yahn ye: ―Namin nchuhn ne, ¿a nahn ca̱hcoma̱n ne u ne? ");
INSERT INTO cutNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ndahconan Simón Pedro, ne ra̱hn ye: ―Dihve nuhn, metah nde ta̱ma ihyan che cochahtino nuhn ca̱va che ndevahn nuhn, atena̱n ndih. Ndudo che ricuahn ne ne, retihyon yune ihyan che ndevahn ye, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nuhn ne, a ritahno nuhn ndih, ne a devano cua̱co nuhn te ndih che Da̱ya Dendiohs, che hua nda̱ ro che cuihno vederihquentiyon yahn ye ma̱n, ndih, ihyan min che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ra̱hn Dihvo vo ri ye ihyan chahn: ―A devano nchuhn che a má̱n tenda̱hnún nduh che ndichio ne, ate nde nduco nduh ne, rihquentiyon chundah a̱ma cha nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Che tihca̱ ra̱hn Dihvo vo ne, ra̱hn ye yahn da̱ya Simón, sa̱hn min che duche se Judas Iscariote, te sa̱hn min va che ndihcue ndeh se ihyan, andahre nduco se ndi cuande se va̱n ihyan apóstol chahn. ");
INSERT INTO cutNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Quendi Dihvo vo quechica ye esta̱do yahn Galilea. Hua nahn conan ye esta̱do yahn Judea, te sa̱hn ndina̱n yahn nación yahn Israel che vate se min ne, nahn ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ro min ne, a nda̱ nino vihco yahn vah cue che redin ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tuhme ra̱hn dihno Dihvo vo ri ye ihyan: ―Cuique muhn, cuehn ya̱n Jerusalén ca̱va che namin ihyan che vate ye min, che ritahno ye di ne, ndihchero ye vederihno che redin. ");
INSERT INTO cutNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tihca̱, te cuahn che nahn vo che cadino ihyan yahn ntiyon che redin vo ne, va che ca̱hco ro vo. Chemin che tahque ndah, cuehn min, din vederihno na̱n che tahque ya̱hn ihyan rendo da̱ma ye. ");
INSERT INTO cutNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tihca̱ ra̱hn dihno ye, te nde ihyan chahn ne, hua ritahno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Metah nda̱ ura che cá̱hn, ate nchuhn ne, adecodehno ura che nahn ne, co ca̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nchuhn ne, hua ta̱n ihyan nunde nduco ne, ate u che cua̱co ne, ta̱n ye nducó, te renevíh nunde yahn ye va̱cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cuahn nchuhn vihco. U ne, hua cá̱hn meniyon, te metah nda̱ ura che cá̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","Chihno min ne, quenan ca Dihvo vo esta̱do yahn Galilea, ne cuahn dihno ye. Adive ne, cuahn che a chihno cuahn nducoya̱ca ihyan vihco me ne, tuhme cuahn ye dema̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sa̱hn ndina̱n yahn nación yahn Israel ne, rinuhn ndudo se ti quenan Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","A̱ma ya̱hn ihyan ne, rente ye yahn Dihvo vo. Na̱hn ye ne, ra̱hn ye: “Ihyan min ne, ndah ihyan ye.” Ate na̱hn ye ne, ra̱hn ye: “Hua ndah ihyan ye, te rihncheh ye ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nducoya̱ca ihyan ne, cua̱hn ndeh rente ye yahn Dihvo vo, yahn che va̱h che cadino sa̱hn ndina̱n yahn nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Cuahn che a menda̱hn vihco me ne, chenda̱ Dihvo vo chete ya̱co, cana̱n ricuahn ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Me sa̱hn ndina̱n chahn ne, a̱ma rahn ino se che a̱ma nda̱hca̱ ricuahn ye, ne ra̱hn se: ―¿Ti chehua ihyan tih che tihca̱ ricuahn ye?, te hua nahn ye escuela che rahn ihyan ricuahn. ");
INSERT INTO cutNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ra̱hn Dihvo vo ri ye sa̱hn: ―Che ricuáhn ne, ndiyu che cuande yahn má̱n, te che cuande yahn Dendiohs, ihyan min che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ihyan che nahn dinahn ye che rihquentiyon Dendiohs ne, conahn ye te che ricuáhn ne, che cuande yahn Dendiohs, ihyan min che dechuh ye u, ndiyu che cuande yahn má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ihyan che ricuahn ye vededevano yahn ma̱n ye ne, che nahn ye ne, che ndeva ihyan yavena̱n ye. Ate ihyan che ricuahn ye ca̱va che quenda̱h yavena̱n ihyan che dechuh ye ihyan ne, ricuahn ye numa cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés ne, dirun ye ley, chihco ye yahn nchuhn, ate nde a̱ma ne hua redinahn ne. Tahque ndah ne ne, nahn ca̱hno ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ndahconan ihyan chena̱hn, ne ra̱hn ye ri ye ihyan: ―Co quenun vaco chihnga̱ ndih, ne chemin che tihca̱ ra̱hn ne. ¿Duh nahn ca̱hno ndih? ");
INSERT INTO cutNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Yahn a̱ma vederihno che dín ro che rahtetuhno ihyan ne, a̱ma rahn ino nducoya̱ca nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés ne, dirun ye yahn ley che renan seña nchuhn, nduhca̱ che chihquentiyon Dendiohs ihyan ndico yahn ye. Chemin che raconahn ne seña checa̱hya, andahre ro che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nducote raconahn ne seña checa̱hya, andahre ro che rahtetuhno ihyan ca̱va che hua cuahcota̱hn ne yahn ley min ne, ¿me dehco che ri ta̱n ne nducó, yahn che ro che rahtetuhno ihyan dín che ndoyahn a̱ma sa̱hn che rechuhrihn se? ");
INSERT INTO cutNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ndotenan che nda̱hchenan nchuhn ne, cuendedecadino ndah ne, ne tumacadino ne che nda̱hca̱ redín. ");
INSERT INTO cutNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","A̱ma o ihyan che vate ye ya̱n min che a devano ye che nahn ca̱hno se Dihvo vo ne, retumerune vih ye: ―¿A ndiyu ihyan tih che rinuhn se ihyan, che nahn ca̱hno se ihyan ne? ");
INSERT INTO cutNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ma̱n ne, nga̱ ye, quenun ye ta̱n ricuahn ye, ne hua duhva retumaca̱h ihyan, ca̱va che co ye preso. A din ndete che, a nduco ihyan ndina̱n yuhn vo, ritahno ye che ihyan tih, che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ate ndiyu ihyan tih chemin, te uvo ne, a devano vo ti chica ye. Cuahn che nda̱ ihyan min ne, nde a̱ma ihyan hua co devano ye ticua̱hn quenda̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Dihvo vo ne, chihnevan ye che tihca̱ rente ihyan chahn. Tuhme a̱ma dito ra̱hn ye: ―Nchuhn ne, ra̱hn ne che a rendihche ne u ma̱n, a devano ne ti chicá ma̱n, ate ndere ra̱hn ne chemin. Ndiyu che cuande yahn má̱n che cochí, te cochí che cuande yahn Chidá, ihyan min che quenan cuma ye vederihquentiyon che a̱ma chahte, ihyan min che nde hua rendihche ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","U ne, a rendihché ihyan, te a na̱n ye quenán, ne a ma̱n ye dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Cuahn che chihnevan sa̱hn ndina̱n chahn che tihca̱ ra̱hn ye ne, nahn din se preso ihyan, ate nde a̱ma se, hua chihquino se din se preso ihyan, te ro min ne, metah nda̱ ro yahn ye che ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Va̱n ihyan chahn ne, a̱ma ya̱hn ihyan chitahno ye ihyan, ne ra̱hn ye: ―A ihyan cuh che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse, te ¿a chi ta̱ma ye che tahque din ca ye vederihno che co ihyan cuh? ");
INSERT INTO cutNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Checadino sa̱hn fariseo che rendonan ihyan ya̱n Dihvo vo. Chemin che nte ca̱de se nduco chidocuya̱n ndina̱n, ne dechuh se policía yahn ya̱co, ngua se ihyan, co ye preso. ");
INSERT INTO cutNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Cuahn che nda̱ se ne, ra̱hn Dihvo vo: ―Conan cá te neve ro nduco nchuhn, tuhme ná̱hn na̱n Ihyan che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nda̱ ro min ne, nuhn nchuhn u, ate hua nta̱ca ne u, te hua co ca̱hn ne na̱n che conán. ");
INSERT INTO cutNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tuhme rente sa̱hn chahn va̱n ma̱n se nduco vih, ne ra̱hn se: ―¿Ti ra conan ihyan tih che ra̱hn ye che hua nta̱ca vo ihyan? ¿A ndihco ye che ca̱hn ye va̱n ihyan nación yuhn vo che chenan ye nación chena̱hn? ¿A min conan ye, cacuahn ye ihyan nación chena̱hn chahn? ");
INSERT INTO cutNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Deh conahn che tihca̱ rahn ye che nuhn vo ihyan, ne hua nta̱ca vo ihyan, te hua co cuhn vo na̱n che conan ye? ");
INSERT INTO cutNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ro vihco chahte me ne, chandi Dihvo vo na̱n nducoya̱ca ihyan, ne cahndudo ye: ―Adecoduhno ihyan che ya̱ca ye ne, chi ye ná̱n, cá̱h nune, cuh ye. ");
INSERT INTO cutNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs ne, ihyan che cotahno ye u ne, cuahtenan cuma ye vederihquentiyon, anduhneca̱ a̱ma nune che hua retihnan. ");
INSERT INTO cutNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Che tihca̱ ra̱hn Dihvo vo ne, ca̱h ye, checadino ihyan, che ihyan che cotahno ye ihyan ne, conun Vaco Ndah yahn Dendiohs ihyan. Ro min ne, ametah co Vaco Ndah yahn Dendiohs, te metah na̱hn Dihvo vo vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cuahn che a chihno ca̱h cuande Dihvo vo ihyan ne, na̱hn ihyan ne, ra̱hn ye: ―Cua̱co niyon che ihyan tih, ihyan profeta che a va ca̱de che chi ye. ");
INSERT INTO cutNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Na̱hn ye ne, ra̱hn ye: ―Ihyan tih ne, a ma̱n ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. Ate na̱hn ihyan ne, ra̱hn ye: ―Hua cua̱co chemin, te ihyan min che a va ca̱de che chi ye ne, ndiyu esta̱do yahn Galilea quenda̱h ye, ");
INSERT INTO cutNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","te na̱n Ndudo yahn Dendiohs ne, a ndirun che ihyan min ne, na̱n nda̱ta yahn rey David quenda̱h ye ma̱n, cuhndeya̱n ye ya̱n Belén, ya̱n va̱co David ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tihca̱ chi che a vih ra̱hn a̱ma, a vih ra̱hn ta̱ma ihyan chahn, yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Va̱n ihyan chahn ne, chenun a̱ma o se che nahn din se preso Dihvo vo, ate hua chihquino se. ");
INSERT INTO cutNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sa̱hn policía chahn ne, ndaconan se na̱n che chenun sa̱hn fariseo ma̱n, chidocuya̱n ndina̱n ma̱n. Tuhme ra̱hn se ri se sa̱hn policía chahn: ―¿Dehco che hua quenda nchuhn ihyan min? ");
INSERT INTO cutNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ndahconan sa̱hn policía chahn, ne ra̱hn se: ―Hua quenda nuhn ihyan, te nde a̱ma yune hua nihnevan nuhn che ricuahn ihyan nduhca̱ che ricuahn ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ra̱hn sa̱hn fariseo chahn ri se sa̱hn: ―Namin nchuhn ne, co a ca̱h yune ne che chihnecheh ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Cuedevano ne, te nde a̱ma nuhn, hua ritahno nuhn ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sa̱hn ya̱n sih ne, hua devano se ley che dirun Moisés, ne chemin che ndinda se. ");
INSERT INTO cutNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Va̱n sa̱hn ndina̱n chahn ne, ndi cuande a̱ma ihyan fariseo che duche ye Nicodemo. A ihyan min che chahn ye a̱ma vino, chendihchero ye Dihvo vo. Ihyan min ne, ra̱hn ye ri ye combiero yahn ye: ");
INSERT INTO cutNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ley che riquendi vo ne, rihquentiyon che hua co ca̱hmo vo che a ndinda a̱ma ihyan numanahn che metah cadino cua̱co vo deh nunde yahn ye va. ");
INSERT INTO cutNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ndaconan se yahn Nicodemo, ne ra̱hn se: ―¿A namin nduco di chique esta̱do yahn Galilea? Condihchenen na̱n Ndudo yahn Dendiohs, ne cadine te nde a̱ma ihyan profeta hua quenda̱h ye min. ");
INSERT INTO cutNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chihno min ne, cona̱hn queri a̱ma se ndeva̱co se. ");
INSERT INTO cutNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Chihno chicuahn Dihvo vo ihyan chahn ne, cuahn ye Cuete Olivo. ");
INSERT INTO cutNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chi dave ta̱ma ro me ne, nda̱ tun ye, ne chenda̱ ye chete ya̱co. Ndo da̱ma nducoya̱ca ihyan na̱n ye, ne chihnde ye, ndevana̱n ricuahn ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tuhme nda̱ sa̱hn devano ley che dirun Moisés ma̱n, sa̱hn fariseo ma̱n, nda se a̱ma ta̱hn nda̱hta che va incha̱hn te, che nta̱ca ihyan ta̱hn, ura che quendite te nduco chihyo te. Chihno se ta̱hn menda̱hn, ");
INSERT INTO cutNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ne ra̱hn se ri se Dihvo vo: ―Ihyan Ricuahn, ta̱hn tih ne, nta̱ca ihyan ta̱hn, ura che quendite te nduco chihyo te. ");
INSERT INTO cutNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na̱n ley che dirun Moisés ne, rihquentiyon che ca̱hno nuhn ta̱hn che tihchan sih, nduco tu. ¿Me ndih, deh ra̱hn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tihca̱ ra̱hn sa̱hn chahn, te retumarande se Dihvo vo, renuhn ino se ta̱ca̱ co ca̱ca nunde se yahn ye. Ate Dihvo vo ne, nde hua tumaca̱h ye yahn se, ne cana̱n dirun ye ndiya̱hn, nduco ndutita̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Quendi se retumarune se ihyan. Na̱n mena̱n ne, ndevandi cua̱co ye, ne ra̱hn ye ri ye sa̱hn: ―Adecochano nchuhn che metah nunde yahn ne ne, ca̱h ne tu ta̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chihno ra̱hn ye ne, ndaconan ndondih ye, ne quendi ye redirun ye ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Chi cuihna̱n sa̱hn chahn che tihca̱ ra̱hn ye ri ye sa̱hn, te a devano se te chendihco se nunde, ne cana̱n ndiquenda̱h vah ca a̱ma ca a̱ma se, cona̱hn se, mena̱n vihca sa̱hn che tahque ndico chahn. Cuahn che a chihno cona̱hn se ne, a dema̱n ta̱hn nda̱hta me, nti te min. ");
INSERT INTO cutNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tuhme ndevandi cua̱co Dihvo vo, ne tumerune ye ta̱hn: ―¿Tiya sa̱hn chahn che rih nunde se yehn ne? ¿A nde a̱ma se hua quendi se rih nunde se yehn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ndaconan te yahn ye, ne ra̱hn te: ―Hua Dihvé, nde a̱ma se. Tuhme ra̱hn ye ri ye ta̱hn: ―U ne, nchahcó nunde yehn. Ma̱n ne, conahn. Ametah ndaconan ndere cochique condihque nunde. ");
INSERT INTO cutNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ta̱ma yune ne, ricuahn Dihvo vo ihyan, ne ra̱hn ye: ―U ne, anduhneca̱ a̱ma ya̱hn che ri ro dave na̱n ihyan iyehnse. Chemin che ihyan che ritahno ye u ne, conahn ye ndudo yáhn, ne ndedeváhn ihyan, cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tuhme ra̱hn sa̱hn fariseo chahn ri se ihyan: ―Ndih ne, rendonan ma̱n ne ndih. Chemin ne, hua cochihve yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Ndudo che renté ne, cua̱co, andahre ra̱hn nchuhn che rendonan má̱n u, te u ne, devanó ti chicá ma̱n, ti ná̱hn ma̱n. Ate nchuhn ne, hua devano ne ti chicá nde huane ti ná̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nchuhn ne, ra cuande ne ihyan nduhca̱ costumbre yahn ne, renda̱hchenan ne ihyan. Ate u ne, hua renda̱hchenán nde a̱ma ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Me cuahn che retecheca̱dé ne, retecheca̱dé numa cua̱co, te retecheca̱dé da̱ma nduco Chidá, ihyan min che dechuh ye u, ndiyu demá̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na̱n ley che rendihchenan nchuhn ne, rihquentiyon che, cuahn che va o testigo che ra vih ndudo yahn ye, ra̱hn ye che cua̱co ne, va che cotahno vo che ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","U ne, rá̱hn ndudo cua̱co yahn ntiyon yáhn. Me Chidá che dechuh ye u ne, namin ra̱hn ye yahn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tuhme tumerune sa̱hn chahn ihyan, ne ra̱hn se: ―¿Ti va chida ne ne? Ndahconan ye yahn se, ne ra̱hn ye: ―Nchuhn ne, hua renahn ne yahn vederihquentiyon che quenan cumá, nde hua rendihche ne Chidá. Nducote hua renahn ne yahn vederihquentiyon che quenan cumá ne, chemin che hua rendihche ne Chidá. ");
INSERT INTO cutNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Tihca̱ chicuahn Dihvo vo chete ya̱co, na̱n che va yave yahn tume vedino. Ate nde a̱ma sa̱hn chahn, hua din se preso ihyan, yahn che metah nda̱ ura che ndihco ca̱de Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ndaconan ra̱hn Dihvo vo ta̱ma yune nduco ihyan tuhca̱: ―U ne, ná̱hn, ne nchuhn ne, nuhn ne u, ate hua nta̱ca ne u. Conda ne, din nunde yahn ne, te na̱n che ná̱hn ne, hua co nda̱ ne. ");
INSERT INTO cutNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tuhme ra̱hn sa̱hn ndina̱n chahn va̱n ma̱n se nduco vih: ―¿A ca̱hno ma̱n ihyan tih ihyan, che tihca̱ ra̱hn ye che na̱n che ca̱hn ye ne, hua co nda̱ vo ne? ");
INSERT INTO cutNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ra̱hn Dihvo vo ri ye sa̱hn: ―Nchuhn ne, ihyan iyehnse nchuhn. Ate u ne, vahchetero chicá. ");
INSERT INTO cutNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Chemin che rá̱hn rí nchuhn che conda ne, din nunde yahn ne. Tihca̱, te ndete che hua cotahno ne che u, ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse ne, conda ne, din nunde yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tuhme tumerune sa̱hn chahn ihyan: ―¿Duh ndih ne? Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―A rá̱hn rí nchuhn nde a ra̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","A̱ma ndeh na̱n dehtenduh va che có nchuhn ma̱n, nevíh nunde yahn ne va̱cona̱n ne ma̱n. Ihyan che dechuh ye u ne, riquenda̱h cua̱co che ra̱hn ye. Me u ne, a ndudo yahn ye che ricuáhn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ate sa̱hn chahn ne, hua chenahn se che a yahn Dendiohs Chida che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Chemin che ra̱hn ye ri ye sa̱hn: ―Cuahn che cuaconahn ya̱h nchuhn u che rinducó nducoya̱ca ihyan ne, tuhme tumacadino ne yahn vederihquentiyon che quenan cumá. Namin tumacadino ne che hua ricuáhn che cuande yahn má̱n, te ricuáhn ndudo che a ma̱n Chidá te cuande ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tihca̱, te Chidá ne, dechuh ye u, ne rinduco ye u. Hua rihcoma̱n ye u, te cuahn da̱ma redináhn nducuahn che renan ino ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cuahn che chihno ra̱hn Dihvo vo nducuahn ndudo chemin chan ne, a̱ma ya̱hn ihyan chitahno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Ndete che quendi nchuhn numa ino ne cotahno ne ndudo che ricuáhn nchuhn ne, tuhme che cua̱co conduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ava̱ne ne, conahn ne ndudo yáhn, ne ndo ne libre. ");
INSERT INTO cutNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ndahconan ihyan chahn ne, ra̱hn ye ri ye Dihvo vo: ―Nuhn ne, nda̱ta yahn Abraham nuhn, ne nde a̱ma yune hua ntihcue ihyan nuhn. ¿Me ta̱ca̱ che ra̱hn ne che ndo nuhn libre ne? ");
INSERT INTO cutNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cua̱co rá̱hn rí nchuhn te nducoya̱ca ihyan che vatechica ye vedeyeno yahn ma̱n ye, rahtendihco ye nunde ne, anduhneca̱ ndete che hua libre ye, te hua co ca̱hcoma̱n ye nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Nchuhn ne, nduhca̱ sa̱hn deca̱hya yahn ihyan che hua redin cuande ye va̱n da̱ya ye ne, tihchan nchuhn na̱n Dendiohs. Ate u ne, Da̱ya ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chemin che, cuahn che ndedeváhn ihyan ne, ametah deh che ndedecadino ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A devanó che nda̱ta yahn Abraham nchuhn. Ate hua renevahnecun ne ndudo yáhn, ne chemin che nahn ca̱hno ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","U ne, ricuáhn nchuhn ndudo che rete cuande Chidá u, ne nchuhn ne, redin ne dehtenduh che nahn chida ne. ");
INSERT INTO cutNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ndahconan ihyan chahn yahn Dihvo vo, ne ra̱hn ye: ―Nuhn ne, Abraham che chida nuhn. Ate ra̱hn ye ri ye ihyan chahn: ―A ndere redin chida nchuhn Abraham, te hua riquendi ne yune yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","U ne, ra̱hn cua̱có rí nchuhn ndudo che a ma̱n Dendiohs rete cuande ye u, ate nchuhn ne, nahn ca̱hno ne u. Abraham ne, ndiyu chemin che din ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nchuhn ne, cuahto redin chida ne, cuahto redin ma̱n ne. Ra̱hn ihyan chahn ri ye Dihvo vo: ―Nuhn ne, Dendiohs che Chida nuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ra̱hn Dihvo vo ri ye ihyan chahn: ―A ndere redin Chida nchuhn Dendiohs. Hua cua̱co che ra̱hn ne, ne chemin che hua ri rendihche ne u. Ndiyu che cuande yahn má̱n che cochí, te a ma̱n Dendiohs dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yahn che hua renevahnecun nchuhn ndudo yáhn ne, chemin che hua renahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nchuhn ne, chundah che chida ne, sa̱hn min che redinahn ne yahn se. Sa̱hn min ne, rihquentiyon se sa̱hn rihno ihyan nde ro che chihnde iyehnse. Cuahn da̱ma rihncheh se, te chemin che ntiyon yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","U ne, ricuáhn ndudo cua̱co, ate nducote ndi nino ne vederihncheh ne, chemin che hua ritahno ne che rá̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nde a̱ma nchuhn ne, hua co ca̱hma ne che va nunde yáhn. Ndudo cua̱co che ricuáhn, ne redin yahn che cotahno ne. ");
INSERT INTO cutNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","A ndero ndi ihyan che yahn Dendiohs ihyan, te rihcovan ye Ndudo yahn ye. Ate nchuhn ne, ndiyu yahn Dendiohs nchuhn, ne chemin che hua nahn ca̱hcovan ne Ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tuhme ra̱hn sa̱hn ndina̱n chahn ri se Dihvo vo: ―Ra̱hn cua̱co nuhn ri nuhn ndih che ndere ihyan ndih, nduhca̱ ihyan nación yahn Samaria ma̱n, quenun vaco chihnga̱ ndih ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ra̱hn Dihvo vo ri ye sa̱hn chahn: ―U ne, rendevá yavena̱n Chidá. Ate nchuhn ne, renda̱hchenan ne u, ne chemin che ndere ra̱hn ne che quenun vaco chihnga̱ u. ");
INSERT INTO cutNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","U ne, hua rendonan má̱n u. Ate va Chidá che rendeva ye yavená̱n, ne ihyan min che retecheca̱de ye. ");
INSERT INTO cutNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Cua̱co rá̱hn rí nchuhn te ihyan che rihcovan ye che ricuáhn ne, cuahtenan ye cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tuhme ra̱hn se ri se Dihvo vo: ―Ma̱n ne, a devano cua̱co nuhn che quenun vaco chihnga̱ ndih, yahn che tihca̱ ra̱hn ne. Abraham ma̱n, nducoya̱ca ihyan profeta ma̱n ne, chih ye. Me ndih ne, ra̱hn ne te ihyan che ca̱hcovan ye ndudo che ricuahn ne ne, cuahtenan ye cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿A tahque rigonun chihve ndih che co chida nuhn Abraham, che ra̱hco ne? Ihyan min ma̱n, nducoya̱ca ihyan profeta ma̱n ne, chih ye. ¿Duh ndih, che ra̱hco ne? ");
INSERT INTO cutNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ra̱hn Dihvo vo ri ye sa̱hn: ―Ndete che rendonan má̱n u ne, nde hua cochihve yáhn. Chidá, ihyan min che ra̱hn nchuhn che Dendiohs yahn ne ne, a ihyan min che rendeva ye yavená̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","U ne, rendihché ihyan, ate nchuhn ne, hua rendihche ne ihyan. Rendihché ihyan, ne redináhn che rihquentiyon ye. Cua̱co che rá̱hn, ndiyu nduhca̱ nchuhn che ndere ra̱hn ne che rendihche ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ihyan ndico yahn nchuhn, Abraham ne, a̱ma chi yeno ye cua̱hn che checadino ye che va che chí iyehnse, ne nde tahque chi yeno ye cuahn che a chinahn. ");
INSERT INTO cutNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tuhme ra̱hn se ri se Dihvo vo: ―Nde mare o raco ndiche nduyo metah co ndih, ¿ta̱ca̱ che ndihchero ne Abraham? ");
INSERT INTO cutNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ra̱hn Dihvo vo ri ye sa̱hn: ―Cua̱co rá̱hn rí nchuhn te u ne, a vá nde ro che metah cuhndeya̱n Abraham. ");
INSERT INTO cutNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tuhme cheta̱h sa̱hn chahn tu, che ca̱h se Dihvo vo. Ate cheh na̱n se ihyan, ne ndiquenda̱h ye chete ya̱co me. Chuh ye va̱n nducoya̱ca se, cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","A̱ma ro ne, ndihchero Dihvo vo a̱ma sa̱hn che ve na̱n se nde ro che chihndeya̱n se. ");
INSERT INTO cutNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ihyan apóstol yahn ye ne, tumerune ye ihyan: ―Ihyan Ricuahn, ¿dehco che ve na̱n sa̱hn tih ne? ¿A ca̱va nunde yahn indihte yahn se, o ca̱va nunde yahn ma̱n se ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ndahconan Dihvo vo yahn ihyan chahn, ne ra̱hn ye: ―Ndiyu ca̱va nunde yahn indihte yahn se, nde huane ca̱va nunde yahn ma̱n se. Ve na̱n se ca̱va che cuhnde ro vederihquentiyon yahn Dendiohs, tumacadino ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","U ne, va che din nun inó dináhn ntiyon yahn Ihyan che dechuh ye u numanahn che quenan cá iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Numacuahn ro che quenán muhn ne, ricuáhn Ndudo yahn Dendiohs ihyan ca̱va che netah ndutina̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chihno ra̱hn ye chemin ne, din ye tah nchete nduco nunedan ye, ne chacota̱hme ye ndutina̱n sa̱hn na̱n ve me. ");
INSERT INTO cutNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tuhme ra̱hn ye ri ye sa̱hn: ―Cuehn conane nan na̱n nune che duche Siloé ―che tihca̱ duche nune me ne, conahn “Nune Rica.” Cuahn sa̱hn na̱n ve me, ne cuahn che na̱no se na̱n se na̱n nune me ne, chi ro na̱n se. ");
INSERT INTO cutNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Cuahn che nta̱ se ne, ra̱hn ihyan nino ndeva̱co se ma̱n, ihyan che rendihche ye sa̱hn ma̱n: ―¿A ndiyu sa̱hn tih che rica se che din ihyan vedeva̱hino nduco se ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Na̱hn ihyan ne, ra̱hn ye: ―Sa̱hn tih chemin. Na̱hn tun ihyan ne, ra̱hn ye: ―Ndiyu sa̱hn tih chemin, ate tihca̱ ro se. Ra̱hn ma̱n se: ―A u chemin. ");
INSERT INTO cutNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tumerune ihyan sa̱hn: ―¿Me ta̱ca̱ chi che chi ro nan ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ndahconan se, ne ra̱hn se: ―Ihyan min che duche ye Jesús, din ye nchete, chacota̱hme ye ndutiná̱n, ne tahve ye u, cháhn na̱nó ná̱n na̱n nune Siloé. Chihno na̱nó ná̱n ne, ndeta̱hno chi ro ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tumerune ihyan chahn sa̱hn: ―¿Ti quenan ihyan min ne? Ndahconan se, ne ra̱hn se: ―Hua devanó. ");
INSERT INTO cutNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuhme quenda ihyan sa̱hn min na̱n sa̱hn fariseo. ");
INSERT INTO cutNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ro che din Dihvo vo che chi ro na̱n sa̱hn min ne, ro che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Chemin che tumerune sa̱hn fariseo chahn sa̱hn ta̱ca̱ chi che chi ro na̱n se. Ndahconan se, ne ra̱hn se ri se sa̱hn chahn: ―Chacota̱hme Jesús nchete ndutiná̱n, ne na̱nó ná̱n nduhca̱ che ra̱hn ye, ne ndeta̱hno chi ro ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tuhme ra̱hn a̱ma o sa̱hn fariseo chahn: ―Sa̱hn che tihca̱ din me ne, ametah yahn Dendiohs che tihca̱ redin se, te hua renevahnecun se ro che rahtetuhno ihyan. Ate ta̱ma te o se ne, ra̱hn se: ―Ndete che hua yahn Dendiohs sa̱hn ne, ¿ta̱ca̱ redin se vederihno tuhme? Nduco tihca̱ ne, hua cavih ndudo yahn se nduco vih, ");
INSERT INTO cutNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ne ndaconan tumerune se sa̱hn min: ―Me di, ¿deh rahn yahn sa̱hn min che din se che chi ro nan ne? Ndahconan se, ne ra̱hn se ri se sa̱hn chahn: ―U ne rá̱hn te ihyan min ne, a̱ma ihyan profeta. ");
INSERT INTO cutNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ate sa̱hn chahn ne, hua nahn cotahno se che ve na̱n sa̱hn min ro mena̱n. Chemin che tahve se chehua indihte yahn sa̱hn min, ");
INSERT INTO cutNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ne tumerune se ihyan: ―¿A nchuhn da̱ya ne sa̱hnguh ne? ¿A cua̱co che ve na̱n se cuahn che chihndeya̱n se ne? ¿Me ta̱ca̱ chi che chi ro na̱n se ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ndahconan indihte yahn sa̱hn min: ―Sa̱hnguh che da̱ya nuhn, ne ve na̱n se cuahn che chihndeya̱n se. ");
INSERT INTO cutNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ate hua devano nuhn ta̱ca̱ chi che chi ro na̱n se, nde hua devano nuhn duh ihyan din ye che chi ro na̱n se. Tumerune nchuhn sa̱hn. A va nduyo yahn se, ne ma̱n se co nte cuande se nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Indihte yahn sa̱hn min ne, tihca̱ ra̱hn ye, te va̱hino ye, yahn che a checadino ye te sa̱hn ndina̱n chahn ne, a ntuhno se che ndetenda̱h se adecoduhno ihyan chete ya̱co, ndete che cotahno ye che Dihvo vo ne, a ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Chemin che ra̱hn ihyan chahn ri ye sa̱hn ndina̱n chahn che tumerune se ma̱n sa̱hn da̱ya ye te a va nduyo yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tuhme ndaconan cah sa̱hn ndina̱n chahn sa̱hn min, ne ra̱hn se ri se sa̱hn: ―Codin ca̱va Dendiohs, ne cahme co nuhn cha che cua̱co, te nuhn ne, devano nuhn te sa̱hn min che din se che chi ro nan ne, sa̱hn nunde se. ");
INSERT INTO cutNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ndahconan sa̱hn min, ne ra̱hn se ri se sa̱hn chahn: ―U ne, hua devanó a ihyan nunde ye o hua. Ate devanó che ro mena̱n me ne, ve ná̱n, ne ihyan min din ye che chi ro ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ndaconan tumerune sa̱hn chahn sa̱hn: ―¿Ta̱ca̱ din se che chi ro nan ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ndahconan sa̱hn min, ne ra̱hn se ri se sa̱hn chahn: ―A rá̱hn rí nchuhn, ne hua ritahno ne. ¿Deh ndah co yahn ne che ndaconán ca̱hma tún ne? ¿A nduco ne nahn cotahno ne ihyan min ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ra̱hva sa̱hn chahn nduco sa̱hn min, ne ra̱hn se ri se sa̱hn: ―Di ne, ndichahtine sa̱hn min. Ate nuhn ne, ndichahtino nuhn Moisés. ");
INSERT INTO cutNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","A devano nuhn te Moisés ne, a ma̱n Dendiohs ca̱h ye ntiyon ihyan. Ate sa̱hn che rahn me ne, nde hua devano nuhn ti chica se. ");
INSERT INTO cutNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ndahconan sa̱hn min, ne ra̱hn se ri se sa̱hn chahn: ―A̱ma rahn inó yahn nchuhn, che ra̱hn ne che hua devano ne ti chica ihyan min, te u ne, din ye che chi ro ná̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A devano cua̱co vo te Dendiohs ne, hua rihcovan ye yahn ihyan nunde, ate rihcovan ye yahn ihyan che renevahnecun ye ihyan ma̱n, redinahn ye vederihquentiyon yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nde a̱ma yune hua nihnevan vo yahn a̱ma ihyan che co din ye che co ro na̱n ihyan na̱n ve. ");
INSERT INTO cutNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ihyan min ne, Dendiohs dechuh ye ihyan, ne chemin che redin ye vederihno. Ndete che hua ne, hua dehva co din ye. ");
INSERT INTO cutNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ra̱hn sa̱hn chahn ri se sa̱hn min: ―Di ne, a̱ma sa̱hn nunde di nde ro che chihneyan. ¿Ta̱ca̱ che nahn cacuehn nuhn ne? Chihno ra̱hn se chemin ne, ndetenda̱h se sa̱hn chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Checadino Dihvo vo che ndetenda̱h sa̱hn ndina̱n chahn sa̱hn min chete ya̱co, ne cuahn che nta̱ca ye sa̱hn ne, tumerune ye sa̱hn: ―¿A ritehne Da̱ya Dendiohs ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ra̱hn se ri se ihyan: ―Dihvé, ca̱hma ne co ne u duh ihyan min ca̱va che cotahnó ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―A u chemin, che renté ndoque. Ma̱n ne, a ndihche u. ");
INSERT INTO cutNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tuhme chehntihya se na̱n Dihvo vo, ne ra̱hn se ri se ihyan: ―Dihvé, ritahnó ndih. ");
INSERT INTO cutNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Namin ra̱hn Dihvo vo: ―U ne, ndá̱ iyehnse cuh ca̱va che techeca̱dé yahn nducoya̱ca ihyan. Ihyan che hua devano ye Ndudo yahn Dendiohs ne, cacúahn ihyan, ne ihyan che devano ye che ra̱hco ye ne, cuhnde ro yahn ye che nde hua devano ye. ");
INSERT INTO cutNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","A̱ma o sa̱hn fariseo che chenun se min ne, chihnevan se che tihca̱ ra̱hn ye, ne ra̱hn se ri se ihyan: ―¿A namin nuhn, ra̱hn ne yahn nuhn che hua devano nuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Ndete che hua devano nchuhn ne, nde hua chendihco ne nunde. Ate nducote a ma̱n nchuhn ra̱hn ne te a devano ne ma̱n, nducote rahcota̱hn ne ma̱n ne, chemin che chendihco ne nunde. ");
INSERT INTO cutNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Quendi Dihvo vo, ne ra̱hn ye: ―Cua̱co rá̱hn rí nchuhn te sa̱hn duco ne, hua̱ renda̱ se cua̱hn chendevah yahn chan na̱n chenun itecuche, te renda̱ se cua̱hn chihto chan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ate ihyan che redin ye cuda̱do itecuche ne, renda̱ ye cua̱hn chendevah yahn chan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Sa̱hn che redin cuda̱do chendevah ne, rena̱hne se, ne renda̱ ye. Ra̱hn ye che duche queri a̱ma te, ne rah ye ite. Cuahn che rah ye ite ne, rechi te, ne retenda̱h ye ite chete chan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cuahn che a retenda̱h ye nducoya̱ca te chete chan ne, riquenda̱hna̱n ye yahn te, ne riquendi te ihyan, te ndi nino te ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ate hua riquendi te sa̱hn che hua rendihche te. Tahque ndah te ne, rano te yahn se, yahn che hua rendonahn te ndudo yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Dihvo vo ne, nte ye ejemplo cuh ca̱va sa̱hn chahn, ate hua chenahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","9","Quendi Dihvo vo, ne ra̱hn ye ri ye sa̱hn chahn: ―Cua̱co rá̱hn rí nchuhn te, nduhca̱ che richihve chendevah yahn chan ca̱va che co chuh itecuche ne, tihca̱ u ca̱va ihyan yáhn. Ihyan che ritahno ye u ne, ndevahn ye, ne cuahtenan ye vahchetero. Ihyan chahn ne, anduhneca̱ itecuche che hua ndere vatechica ma̱n te, che rendonda̱ te chete chan, ri te cuda̱do ma̱n, riquenda̱h te rahn te reh te ma̱n. Nducoya̱ca sa̱hn rihncheh che chahte se ro che metah ndá̱, redin ca̱ se che Ndudo yahn Dendiohs rahndudo se ne, anduhneca̱ sa̱hn duco, tihchan se, ne ihyan yahn Dendiohs ne, hua rihcovan ye ndudo yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Sa̱hn duco ne, renda̱ se ca̱va che ca̱hno se ihyan ma̱n, duco se ma̱n, cuihno denda se ihyan ma̱n. Ate u ne, ndá̱ ca̱va che ndedeváhn ihyan, ne a̱ma nda̱hca̱ cuahno ye, cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nduhca̱ a̱ma ihyan che ndah redin ye cuda̱do itecuche yahn ye nde ndihco menda̱hn ye ihyan ca̱va che ndedevahn ye ite ne, tihca̱ u, te ndah redín cuda̱do ihyan yáhn, nde ca̱hco mendá̱hn u cóh, ca̱va che ndedeváhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ate nducoya̱ca sa̱hn mozo che redin se ntiyon min ne, nducote ndiyu yahn se itecuche ne, hua cuda̱do se. Cuahn che renda̱ lobo ne, rihcoma̱n se itecuche che nduco se, ne rano se. Tuhme reta̱h lobo ite, ne rihno rano ite chena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Rano se, te ndiyu dihve itecuche sa̱hn, ne hua redin se cuda̱do ite numa ino se. ");
INSERT INTO cutNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’U ne, anduhneca̱ a̱ma ihyan che ndah redin ye cuda̱do itecuche yahn ye. Chidá ne, rendihche ye u, ne u ne, rendihché ihyan. U ne, nda cuandé ihyan yáhn, ne ma̱n ye ne, richahtino ye u. U ne, nde ca̱hco mendá̱hn u cóh, ca̱va che ndedeváhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Namin vate ca ihyan che nedin yáhn ihyan, ndedeváhn ihyan. Ma̱n ne, vatechica va̱ne ye, ate nevahnecun ye u, ne ndo da̱ma ye va̱n ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Chidá ne, yahino ye u, te ca̱hco mendá̱hn u cóh, ca̱va che ndedeváhn ihyan iyehnse. Cuihno min ne, va che ntuché. ");
INSERT INTO cutNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nde a̱ma ihyan ne, hua co ca̱hno ye u, ndete che hua má̱n ca̱hco mendá̱hn u. Va vederihquentiyon yáhn ca̱va che ca̱hco mendá̱hn u cóh. Namin va vederihquentiyon yáhn che ntuché. Vederihquentiyon min che te Chidá u. ");
INSERT INTO cutNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cuahn che chihno ra̱hn Dihvo vo ndudo chemin chan, chihnevan sa̱hn ndina̱n chahn ne, ndevana̱n se, a vih ra̱hn a̱ma a vih ra̱hn ta̱ma se. ");
INSERT INTO cutNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","A̱ma ya̱hn se ne, ra̱hn se: ―Nde hua tumaca̱h nchuhn che ra̱hn sa̱hn tih, te quenun vaco chihnga̱ sa̱hn, ne hua va cua̱co dave yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ate na̱hn tun se ne, ra̱hn se: ―Adecoduhno ihyan che quenun vaco chihnga̱ ihyan ne, hua tihca̱ runeca̱de rente ye. Ava̱ne ne, hua co din ye che co ro na̱n ihyan na̱n ve. ");
INSERT INTO cutNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ro min ne, ro iche, ne ta̱hn min redin ihyan vihco yahn ya̱co, min ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Dihvo vo ne, quechica ye ndiya̱co me ma̱n corredor che duche Corredor yahn Salomón. ");
INSERT INTO cutNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndo da̱ma sa̱hn ndina̱n chahn na̱n ye, ne ra̱hn se ri se ihyan: ―Ndete che ndih, ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse ne, ca̱hma cua̱co no ne co ne nuhn. Hua nda̱hca̱ che rihco ndeh ne. ");
INSERT INTO cutNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―A rá̱hn rí nchuhn, ne hua ritahno ne. Nduco vederihno che redín numacuahn vederihquentiyon yahn Chidá ne, a ndero ndi che a u chemin. ");
INSERT INTO cutNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ate nchuhn ne, hua ritahno ne, te hua ndi cuande ne va̱n ihyan yáhn, nduhca̱ che a rá̱hn rí nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ihyan yáhn ne, rihcovan ye ndudo yáhn, ne rinduco ye u. Me u ne, nda cuandé ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Rendedeváhn ihyan, ne cuahtenan ye vahchetero numacuahn ro. Hua duhva co din che conda ye, te u nda cuandé ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ma̱n Chidá tenda̱hnun ye ihyan chahn ca̱va che cotahno ye u. Ihyan min che tahque chahte vederihquentiyon yahn ye, ne nducote namin nda cuande ye ihyan ne, chemin che hua duhva co din che conda ye. ");
INSERT INTO cutNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","U nduco Chidá ne, a̱ma no vederihquentiyon yahn nuhn ma̱n, a̱ma no vederendedecadino yahn nuhn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Cuahn che tihca̱ ra̱hn Dihvo vo ne, ndaconan cheta̱h sa̱hn ndina̱n chahn tu che ca̱h se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tuhme ra̱hn ye ri ye sa̱hn: ―Numacuahn vederihquentiyon yahn Chidá, a̱ma ndeh na̱n dehtenduh che ndah nedín na̱n nchuhn. Ate nchuhn ne, de tu nahn ca̱h ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ndahconan sa̱hn chahn ne, ra̱hn se ri se ihyan: ―Ndiyu yahn dehtenduh che redin ne che ca̱h nuhn tu ndih, ate yahn che duche rino ne Dendiohs che tihca̱ ra̱hn ne. A ndero ndi che ihyan iyehnse ndih, ne ra̱hn ne te a̱ma no vederihquentiyon quenan cuma ne nduco Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tuhme ra̱hn Dihvo vo ri ye sa̱hn chahn: ―Na̱n ley che riquendi nchuhn ne, ndirun che ra̱hn Dendiohs yahn ihyan tuhca̱: “Nchuhn ne, menun Dendiohs nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","36","A devano nchuhn te cha che ndirun na̱n Ndudo yahn Dendiohs ne, hua co ca̱hmo vo che hua cua̱co. Nducote a ma̱n Dendiohs ra̱hn ye yahn ihyan che rihnde ta̱h ye Ndudo yahn ye te menun Dendiohs ihyan ne, chemin che nde tah hua nda̱hca̱ che tihca̱ ra̱hn ne che duche rinó Dendiohs, che rá̱hn che u che Da̱ya ye ma̱n, che tenda̱hnun ye u, dechuh ye u muhn iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Cuentah nchuhn ndutina̱n ne, condihchero ne. Ndete che numacuahn vederihquentiyon yahn Chidá, redín vederihno, tuhme cotahno ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Nducote redín vederihno numacuahn vederihquentiyon yahn ye ne, cotahno ne u, andahre hua nahn cotahno ne yahn ndudo che ricuáhn. Tuhme tumacadino ne che rinduco Dendiohs Chida u. ");
INSERT INTO cutNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chihco da̱ma ino sa̱hn chahn ta̱ma yune che nahn din se preso ihyan, ate ndiquenda̱h ye va̱n se, ne din vi ye. ");
INSERT INTO cutNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tuhme cuahn ye cua̱hn chihto ico Jordán, ne min quenan ye, la̱do cua̱hn na̱n che riquenda̱h ya̱hn, cua̱hn na̱n che quenan Jua̱n Bautista chehdenune ye ihyan ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","A̱ma ya̱hn ihyan rahn ye, rendihchero ye Dihvo vo, ne ra̱hn ye: ―Jua̱n Bautista ne, andahre hua din ye nde a̱ma vederihno, ate nducuahn che ra̱hn ye yahn ihyan cuh ne, cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ihyan che chahn ye min ne, a̱ma ya̱hn ye chitahno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","3","Ya̱n Betania ne, chihnde a̱ma ihyan che duche ye Lázaro. Ihyan min ne, chahte o cahve ye; a̱ma ye ne, duche ye María, ne ta̱ma ye ne, duche ye Marta. A ihyan che duche María me che chacota̱hme ye nuneda̱n ca̱h Dihvo vo, ne ndi cuma ye nduco yudo tin ye. A̱ma yune ne, cheta̱h cah Lázaro, ne a̱ma tahn ndi ye. Tuhme tahve nduh che o cahve ye ndudo yahn Dihvo vo, ne ra̱hn ye: ―Dihve nuhn, amigo yahn ne Lázaro ne, cheta̱h cah ihyan, ne a̱ma tahn ndi ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Cuahn che chihnevan Dihvo vo ne, ra̱hn ye: ―Cah min ne, andahre din che coh ye, ate chemin ne, ca̱va che cuhnde ro vederihquentiyon chahte yahn Dendiohs, ne ndeva ihyan yavena̱n ye ma̱n, ndeva ye yavena̱n u che Da̱ya ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Andahre a̱ma yahino Dihvo vo ihyan chahn, Lázaro ma̱n, María ma̱n, Marta ma̱n ne, ");
INSERT INTO cutNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","cuahn che nda̱ ndudo yahn ye che cah Lázaro ne, chendah ca ye te o ro min na̱n che quenan ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chihno min ne, ra̱hn ye ri ye ihyan apóstol yahn ye: ―Ndaconan cuhn vo nduco nchuhn esta̱do yahn Judea. ");
INSERT INTO cutNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tuhme ra̱hn ihyan chahn ri ye ihyan: ―Ihyan Ricuahn, cade chuh neve ro che nahn ca̱hno sa̱hn ndina̱n chahn ndih nduco tu, ne ma̱n ne, ¿a rihco ne che ca̱hn tun ne min ne? ");
INSERT INTO cutNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ra̱hn ye ri ye ihyan chahn: ―Ndichio ura che a̱ma ro, ne cuahn che ro vatechica vo ne, hua renda ca̱h vo, te ro na̱n vo yahn che quendihco dave yahn ya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ate ndete che vino vatechico vo ne, conda ca̱h vo yahn che man ro. ");
INSERT INTO cutNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chihno min ne, ra̱hn ye ri ye ihyan chahn: ―Amigo yuhn vo Lázaro ne, quiya̱do ye, ate cá̱hn ndedetuhché ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ra̱hn ihyan chahn ri ye ihyan: ―Dihve nuhn, ndete che cheta̱h ya̱hnde ihyan ne, ametah nduh dito ri yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Dihvo vo ne, hua ra̱hn cua̱co ye che a chih Lázaro, ne chemin che ra̱hco ihyan apóstol chahn che quiya̱do ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tuhme ra̱hn cua̱co ye ri ye ihyan chahn: ―Lázaro ne, a chih ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tahque nda̱hca̱ che hua quenán min ro che chih ye, te nduco tihca̱ ne, tahque ndah ro yahn nchuhn, ca̱va che cotahno ne. Ma̱n ne, cuhn vo quendihchero vo ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás, ihyan min che nta̱hco ihyan che duche ye “Cua̱hche” ne, ra̱hn ye ri ye ihyan apóstol chena̱hn chahn: ―Cuhn vo nduco nchuhn, conduco vo Dihvo vo, andahre va che coh vo da̱ma nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cuahn che nda̱ Dihvo vo ya̱n Betania ne, a cun ro che quenun Lázaro chete ya̱yan. ");
INSERT INTO cutNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania ne, nino nduco ya̱n Jerusalén, ri tenduh o kilómetro quenan ma̱hn, ");
INSERT INTO cutNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ne a̱ma ya̱hn sa̱hn ndina̱n yahn nación yahn Israel, chahn se chendihchero se Marta ma̱n, María ma̱n, ca̱va che neca̱h se vedechahtino ihyan, yahn che chih cahve ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cuahn che checadino Marta che a nda̱ nino Dihvo vo ne, cuahn ye quendi yune ye ihyan. Numanahn min ne, quenun María vah. ");
INSERT INTO cutNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ura che a ta̱hn nun Marta Dihvo vo ne, ra̱hn ye ri ye ihyan: ―Dihvé, ndete che muhn quenan ne ro che chi dito yahn cahvé ne, nde hua chih ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ate dehve din yahn, te ndih ne, adecodehno che ca̱ca ne Dendiohs ne, cuahnecun ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ra̱hn Dihvo vo ri ye Marta: ―Quehve ne, ndaconan conan se. ");
INSERT INTO cutNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ra̱hn Marta ri ye Dihvo vo: ―Cua̱co che ndaconan conan ye, cuahn che ntuche tena̱hn, ro che cuihno iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tuhme ra̱hn Dihvo vo ri ye Marta: ―Che ntuche tena̱hn ma̱n, che cuahtenan ye vahchetero ma̱n ne, a u che rihquentiyón. Ihyan che ritahno ye u ne, andahre coh ye ne, ntuche ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nducoya̱ca ihyan che ritahno ye u ne, hua conda ye, te cuahtenan ye vahchetero cuahn da̱ma. ¿A ritehne chemin ne? ");
INSERT INTO cutNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ra̱hn Marta ri ye Dihvo vo: ―Ta̱ca̱ hua, Dihvé. Ritahnó. Namin ritahnó che a ndih che Da̱ya Dendiohs ma̱n, a ndih che a va ca̱de che chi ne ndedevahn ne ihyan iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chihno ra̱hn Marta ne, cuahn ye ngua ye coh ye María, ne ra̱hn ye deco deco ri ye ihyan: ―Nda̱ Ihyan Ricuahn, ne rah ye di. ");
INSERT INTO cutNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ndeta̱hno necuan María, ne cuahn ye na̱n che quenun Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Dihvo vo ne, ametah conda̱ ye viya̱n, te quenan rino ye yune na̱n che nta̱ca Marta ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Sa̱hn ndina̱n chahn che chenan se va̱co María reneca̱h se vedechahtino ihyan ne, ndihchero se che aderano ye necuan ye cuahn ye, ne cuahn se nduco ye. Ra̱hco se te cuahn ye na̱n ya̱yan, cuaco ye ca̱va cahve ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Cuahn che nda̱ María na̱n Dihvo vo ne, chehntihya ye, ne ra̱hn ye: ―Ndete che muhn quenan ne ro che chi dito yahn cahvé ne, nde hua chih ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María ne, a̱ma raco ye. Namin sa̱hn chahn ne, raco se. Ndihchero Dihvo vo, ne a̱ma chi nda̱che ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tumerune ye ihyan chahn: ―¿Ti chihche nchuhn tena̱hn me ne? Ra̱hn ihyan chahn ri ye ihyan: ―Dihve nuhn, cuhn vo nduco ne, ndihchero ne. ");
INSERT INTO cutNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Namin chaco Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tuhme ra̱hn a̱ma o sa̱hn chahn: ―Condihche nchuhn. A ndero ndi che a̱ma yahino ye tena̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ta̱ma te o se ne, ra̱hn se: ―Ihyan tih ne, din ye che chi ro na̱n sa̱hn na̱n ve me. ¿Ta̱ca̱ che hua din ye che ndoyahn Lázaro, ne hua chih ye? ");
INSERT INTO cutNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Dihvo vo ne, a̱ma chi nda̱che ye, ne cuahn nda̱ ye na̱n ya̱yan me. Ya̱yan me ne, ndindah na̱n a̱ma ya̱va, ne a̱ma tu chahno ndi chendevah yahn. ");
INSERT INTO cutNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ra̱hn Dihvo vo: ―Cuehnevi nchuhn tu chende ya̱yan. Cona̱hne ne. Tuhme ra̱hn Marta ri ye Dihvo vo: ―Dihvé, co a ran tena̱hn, te a chihno cun ro che chih ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ate ra̱hn Dihvo vo ri ye Marta: ―A rá̱hn rí di te ndete che ritehne ne, tumacadine vederihquentiyon chahte yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tuhme chehnevi ihyan chahn tu me. Chenihyon na̱n Dihvo vo na̱n ro, ne cova̱h ye tuhca̱: ―Chidá, renté nundihve cuahn ndih yahn che rihcovan ne che revá̱h. ");
INSERT INTO cutNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A devanó te cuahn da̱ma che revá̱h ne, rihcovan ne, ate tihca̱ rá̱hn ca̱va che ndah yahn ihyan che chenun ye muhn, ca̱va che cotahno ye che a ndih dechuh ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Chihno cova̱h ye ne, ra̱hn ye a̱ma dito: ―Lázaro, ¡cuendiquendah ta̱n! ");
INSERT INTO cutNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ndeta̱hno ntuche ihyan min, ndiquenda̱h ye chete ya̱yan. Deva ndacotuma ye tino, nde ta̱h nde ca̱h ye ma̱n, na̱n ye ma̱n. Ra̱hn Dihvo vo ri ye ihyan chahn: ―Cuenta̱hte nchuhn tino che ndacotuma ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Sa̱hn ndina̱n chahn che chahn se chinduco se María cuahn che chih cahve ye ne, ndihchero se vederihno che din Dihvo vo, ne a̱ma ya̱hn se chitahno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ate na̱hn se ne, chahn se chengo se sa̱hn fariseo yahn vederihno che din ye, ndedetuhche ye Lázaro. ");
INSERT INTO cutNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tuhme ndo da̱ma sa̱hn fariseo chahn ma̱n, chidocuya̱n ndina̱n ma̱n, nduco nducoya̱ca sa̱hn ndina̱n yahn nación yahn Israel, nte ca̱de se, ne ra̱hn se: ―¿Ta̱ca̱ din vo?, te ihyan min ne, a̱ma redin ye vederihno. ");
INSERT INTO cutNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndete che ca̱hcoma̱n vo che quendi ye ne, nducoya̱ca ihyan cotahno ye ihyan, ne dena̱n chi sa̱hn ndina̱n yahn Roma, cuihno ndahtera se ya̱co yuhn vo ma̱n, cuihno ca̱hno se ihyan nación yuhn vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ate Caifás, ihyan min che chidocuya̱n che tahque ndina̱n nduyo min ne, ra̱hn ye ri ye sa̱hn chahn: ―Nchuhn ne, nde hua devano ne. ");
INSERT INTO cutNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nde tah hua retumacadino ne, te tahque nda̱hca̱ yuhn vo, che coh a̱ma no ihyan ca̱va ihyan nación yuhn vo yudomin ca che coh nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás ne, ndiyu che ndedecadino ma̱n ye che tihca̱ ra̱hn ye. Nducote ihyan min ndina̱n ye nduyo min ne, ca̱h Dendiohs, checadino ye, ne chemin che ra̱hn ye che va che coh Dihvo vo Jesucristo, ca̱va che ndedevahn ye ihyan nación yahn Israel ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","nducoya̱ca ihyan yahn Dendiohs che chenan ye muhn min numachahte iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tihca̱ chi, che nde ro min, chihco ca̱de sa̱hn ndina̱n chahn che ca̱hno se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Chemin che ametah quechica ro Dihvo vo va̱n ihyan. Tahque ndah ye ne, chica ye esta̱do yahn Judea, ne cuahn ye a̱ma cua̱n, nino ya̱hn na̱n che metah duhva, chihto a̱ma ya̱n che duche Efraín. Min quenan ye nduco ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A cochi nino vihco ro yudo yahn ihyan nación yahn Israel, ne a̱ma ya̱hn ihyan rica ye ya̱n va̱co ye, rahn ye ya̱n Jerusalén a̱ma o ro numanahn che metah cuana̱n vihco me, ca̱va che ndo dave ye nduhca̱ costumbre yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rinuhn ihyan chahn Dihvo vo, ne a̱ma retumarune vih ye ura che chenun ye chete ya̱co: ―Nchuhn, a hua devano ne, ¿a chi ye vihco ne? ");
INSERT INTO cutNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sa̱hn fariseo ma̱n, chidocuya̱n ndina̱n ma̱n ne, a ndihquentiyon se che adecoduhno ihyan che devano ye ti quenan Dihvo vo ne, ca̱hma ye co ye sa̱hn, ca̱va che din se preso ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Te a̱n ro ca renda che nda̱ ro yudo me, ne cuahn Dihvo vo ya̱n Betania, quendihchero ye Lázaro, ihyan min che ndedetuhche ye ihyan va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Va̱co Lázaro din ihyan chahn a̱ma vihco ca̱va Dihvo vo, ne ca̱h ye, cheh vino ye. Marta ne, chihnta̱ve ye che cheh ihyan chahn, ne Lázaro ma̱n, Dihvo vo ma̱n, vate ye nduco ihyan chena̱hn na̱n mesa. ");
INSERT INTO cutNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ura min nda̱ María, nda ye tenduh ma̱hn litro nuneda̱n ndah, che duche nardo. Chemin ne, a̱ma yahn chihve. Chacota̱hme ye ca̱h Dihvo vo, ne nedin cuma ye nduco yudo tin ye. Numacuahn chetevah me quendihco chan da̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tuhme a̱ma sa̱hn che ndi cuande se va̱n ihyan apóstol chahn, che duche se Judas Iscariote, da̱ya Simón, sa̱hn min che va che ndihcue ndeh se Dihvo vo ne, ra̱hn se: ");
INSERT INTO cutNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Nuneda̱n tih ne, rigonun chihve tenduh ino ciento tume diya̱hngua, ¿ta̱ca̱ che hua ndihcue ta̱hn tih, nda̱ca che conan te ihyan cheva̱h? ");
INSERT INTO cutNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ne, ndiyu che yahino se ihyan cheva̱h che tihca̱ ra̱hn se, te yahn che duco se. Nducote sa̱hn min ndi se tesorero va̱n ihyan apóstol chahn ne, renda̱ca yune che reduco se. ");
INSERT INTO cutNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Hua ca̱hca tan che tihca̱ redin te. Chehdenda̱ te nuneda̱n me u, ca̱va che cuhndeyá̱n che conún chete ya̱yan. ");
INSERT INTO cutNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ihyan cheva̱h ne, cuahn da̱ma chenun ye va̱n nchuhn, ne co conan ne ihyan cuahn che nahn ne. Ate u ne, hua cuahn da̱ma conán nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A̱ma ya̱hn ihyan nación yahn Israel, checadino ye che ya̱n Betania quenan Dihvo vo, ne cuahn ye quendihchero ye ihyan. Namin nahn ndihchero ye Lázaro, ihyan min che ndedetuhche Dihvo vo ihyan va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Tuhme ntuhno chidocuya̱n ndina̱n chahn che namin nduco Lázaro ca̱hno se ihyan, ");
INSERT INTO cutNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","te a ca̱va Lázaro che a̱ma ya̱hn ihyan nación yahn Israel rihcoma̱n ye sa̱hn, ritahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A̱ma ya̱hn ihyan nda̱ ye vihco ro yudo, ya̱n Jerusalén. Chi dave ta̱ma ro me ne, checadino ye che va che nda̱ Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tuhme chihca ye iyon, quenda ye, ne cuahn ye quendi yune ye Dihvo vo. Cuahn che ta̱hn nun ye ihyan ne, chenda̱ ye viya̱n rah yeno ye: ―¡Ndeva vo yavena̱n Dihvo vo Dendiohs! ¡Ndeva vo yavena̱n ihyan cuh che dechuh ye! ¡Ndeva vo yavena̱n ihyan cuh che Rey yahn nación yuhn vo Israel! ");
INSERT INTO cutNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Dihvo vo ne, nda̱ca ye a̱ma burro lihn, quendudo ye ite, te a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Nchuhn ihyan ya̱n Jerusalén, hua dehva ra̱hco ne. Condihche ne. Cochi Rey yahn ne, quendudo ye a̱ma burro lihn. ");
INSERT INTO cutNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ro mena̱n ne, hua chenahn ihyan apóstol yahn dehtenduh che tuhchan, ate adive cuahn che a cona̱hn Dihvo vo vahchetero ne, tuhme chenahn ye che nducuahn che chahno chi Dihvo vo ne, a ndirun yahn na̱n Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ihyan che ndihchero ye vederihno che din Dihvo vo, ndedetuhche ye Lázaro va̱n tena̱hn ne, rente ye yahn. ");
INSERT INTO cutNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chahn ino ihyan yahn vederihno me, ne chemin che a̱ma ya̱hn ye chahn ye chendi yune ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tuhme rente sa̱hn fariseo chahn va̱n ma̱n se nduco vih: ―Condihche nchuhn. A chihnonan yahn ntiyon yuhn vo, te nducoya̱ca ihyan ne, a chinduco ye ihyan ca̱h. ");
INSERT INTO cutNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Va̱n ihyan che chahn ye vihco min ya̱n Jerusalén, ndeva ye yavena̱n Dendiohs ne, nduco neve sa̱hn nación yahn Grecia. ");
INSERT INTO cutNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Sa̱hn chahn ne, chahn nda̱ se na̱n a̱ma ihyan ya̱n Betsaida, esta̱do yahn Galilea, duche ye Felipe, ne ra̱hn se ri se ihyan: ―Codin ne favor, ne quenda ne nuhn na̱n Jesús, te nahn ndihchero nuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe ne, chahn ye ra̱hn ye nduco Andrés, ne cuahn nduh che o ye, ya̱hve ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―U che rinducó nducoya̱ca ihyan ne, adecodehno ura ná̱hn vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cua̱co rá̱hn rí nchuhn te ca̱va che co yahn a̱ma ndute trigo, ndo ndeh ne, va che cuehche ndiya̱hn. Ndete che hua cuehche ne, hua co ndeh. ");
INSERT INTO cutNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ihyan che nahn ndedevahn ma̱n ye ihyan ne, denda ye ihyan. Ate ihyan che rihco menda̱hn ye ihyan muhn iyehnse ne, cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Duh ihyan che nahn din ye ntiyon yáhn ne, va che ca̱hco da̱ma ino ye conduco ye u. Ihyan che redin ye ntiyon yáhn ne, cuahtenan ye vahchetero nducó, ne din Chidá che quenda̱h yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Ma̱n ne, a̱ma rá̱n. Ate ndotenan che ca̱hmá có Chidá che ndedevahn ye u, cahnevi ye che va che chuhríhn ne, tahque ndah ca̱hco da̱ma inó, te a ca̱va che chuhríhn che cochí. ");
INSERT INTO cutNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Chidá, ca̱hmá có ihyan: “Vá vedeyeno che dináhn nducuahn che chihquentiyon ne, ca̱va che quenda̱h yavena̱n ne.” Tuhme chenun a̱ma ndudo che chica vahchetero, che ra̱hn: ―A dín che quenda̱h yavená̱n. Ma̱n ne, dín che quenda̱h yavená̱n ta̱ma yune. ");
INSERT INTO cutNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Chihnevan ihyan che chenun ye min, ne na̱hn ye ne, ra̱hn ye che chine da̱ve. Na̱hn tun ye ne, ra̱hn ye te co a̱ma ángel ya̱hve ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Ndudo che chihnevan nchuhn ne, a ca̱va ma̱n ne, ndiyu ca̱va u. ");
INSERT INTO cutNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","A nda̱ ura che cuhnde ca̱de yahn ihyan iyehnse, ne chundah, sa̱hn min che rihquentiyon se iyehnse ne, nda̱hco ndiya Dendiohs sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Cuedevano nchuhn te cuahn che conan yá̱h, dín che cotahno ihyan numachahte iyehnse u. ");
INSERT INTO cutNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Che tihca̱ ra̱hn ye ne, ra̱hn ye nduhca̱ che va che coh ye. ");
INSERT INTO cutNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ra̱hn ihyan chahn ri ye ihyan: ―A devano nuhn te na̱n Ndudo yahn Dendiohs ne, a ndirun che ihyan che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse ne, hua nda̱ ro che cuihno vederihquentiyon yahn ye. ¿Ta̱ca̱ che ra̱hn ne che ndih che rinduco ne nducoya̱ca ihyan, conan ya̱h ne? ¿Duh ndih tuhme ne? ");
INSERT INTO cutNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Conan cá te neve ro nduco nchuhn, cacuáhn nchuhn. Cuihcovan ne ndudo yáhn, ca̱va che runeca̱de cuahtechica ne, ne co ndevahn ne, te ihyan che hua runeca̱de vatechica ye ne, nde hua devano ye ti nda̱ ti tuno ye. ");
INSERT INTO cutNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Cuitahno nchuhn u, numanahn che quenán nduco ne, ca̱va che co ne ihyan runeca̱de. Chihno ra̱hn Dihvo vo chemin ne, chihcoma̱n ye ihyan chahn, ne cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Andahre a̱ma din Dihvo vo vederihno va̱n ihyan chahn ne, hua chitahno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Hua chitahno ye, te va che conahn nduco ye, nduhca̱ che dirun ihyan profeta Isaías tuhca̱: Dihvé, neve cuahn ra ihyan che ritahno ye ndudo che rahndudo nuhn. Neve cuahn ra ihyan che tumacadino ye vederihquentiyon yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tihca̱ chi che hua chi chitahno ihyan chahn. Namin dirun ihyan profeta Isaías tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dendiohs ne, deche ye ndutina̱n ihyan chahn ma̱n, din cheche ye chedave yahn ye ma̱n, ca̱va che hua nchana̱n ye ma̱n, hua conahn ye ma̱n, ne hua cotahno ye Dihvo vo, ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tihca̱ dirun ihyan profeta Isaías yahn vederihquentiyon chahte yahn Dihvo vo, te chinahn a̱ma vederihno nduco ye, ndihchero ye vederihquentiyon min. ");
INSERT INTO cutNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Andahre tihca̱ ne, a̱ma ya̱hn ihyan nación yahn Israel chitahno ye Dihvo vo. Nde sa̱hn ndina̱n chahn, chitahno neve se. Ate hua chihco ro se che ritahno se ihyan, yahn che va̱h se che cahnevi sa̱hn fariseo chahn vederihquentiyon yahn se chete ya̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Hua chihco ro se che ritahno se Dihvo vo, te tahque renan ino se che quenda̱h yavena̱n se na̱n ihyan iyehnse che co na̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","A̱ma yune cuahn che rahndudo Dihvo vo ne, a̱ma dito ra̱hn ye: ―Ihyan che ritahno ye u ne, namin ritahno ye Dendiohs Chida, ihyan min che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ihyan che rendihche ye u ne, retumacadino ye ta̱ca̱ ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","U ne, ndá̱ muhn iyehnse, ricuáhn Ndudo yahn Dendiohs, ca̱va che ihyan che cotahno ye u ne, ndevahn ye, ne runeca̱de cuahtenan ye. ");
INSERT INTO cutNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ate ihyan che rihnevan ye ndudo yáhn, ne hua redinahn ye ne, ndiyu che nahn má̱n che dín castigo ihyan, te ndá̱ ca̱va che ndedeváhn ihyan iyehnse, ndiyu dema̱n che dín castigo ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ihyan che raconda̱h veda̱me ye u, ne hua rihcovan ye ndudo yáhn ne, va che co ye castigo ro che cuihno iyehnse, tunoca che hua dinahn ye ndudo che ricuáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tihca̱, te Dendiohs Chida, ihyan min che dechuh ye u ne, a ndudo che rihquentiyon ye che renté ma̱n, che rahndudó ma̱n, ndiyu dehtenduh che ri yeno má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A devanó te che rihquentiyon Chidá ne, che cuahtenan ihyan vahchetero cuahn da̱ma. Chemin che rahndudó nduhca̱ che rihquentiyon ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cuahn che a ta̱ma ro ra renda che cuana̱n vihco ro yudo me ne, nducote a devano Dihvo vo che a nda̱ ro che nda̱ca ye iyehnse, ne na̱hn ye na̱n Dendiohs Chida ne, chihco ro ye nduhca̱ che a̱ma yahino ye ihyan yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Chundah ne, a nde mena̱n ca̱hn nun se chete chedave yahn Judas Iscariote, da̱ya Simón, nduhca̱ che ndihcue ndeh se Dihvo vo. Nducote Dihvo vo ne, a devano ye che a ma̱n Dendiohs Chida nda̱hco ye nducuahn vederihquentiyon ta̱h ye ma̱n, na̱n ihyan min chica ye ma̱n, min na̱hn ye ma̱n ne, ura che chihno cheh vino ye nduco ihyan apóstol yahn ye ne, necuan ye na̱n mesa. Chehnevi ye tino tu che quenun ye, ne cheta̱h ye a̱ma toalla, chacondihco ye yutora̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Namin cheta̱h ye cu che rena̱no nun ye ta̱h ye, ne chih ye nune. Tuhme cana̱n rena̱no ye ca̱h ihyan apóstol yahn ye, ne renedin cuma ye nduco toalla me. ");
INSERT INTO cutNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cuahn che nda̱ ye na̱n va Simón Pedro ca̱va che na̱no ye ca̱h ye ne, ra̱hn ihyan min ri ye ihyan: ―Dihvé, ¿ta̱ca̱ che ndih na̱no ne cá̱h ne? ");
INSERT INTO cutNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Ma̱n ne, hua renehn deh conahn che tihca̱ redín, ate adive ne, conehn. ");
INSERT INTO cutNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ate ra̱hn Simón Pedro ri ye Dihvo vo: ―U ne, hua nda̱ ro che na̱no ne cá̱h. Ra̱hn Dihvo vo ri ye ihyan: ―Ndete che hua na̱nó cah ne, ametah din cuandé di va̱n ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ra̱hn Simón Pedro ri ye Dihvo vo: ―Dihvé, ndete che tihca̱ ne, cona̱no ne ndiyu dema̱n cá̱h, te namin cona̱no ne tá̱h ma̱n, tín ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ate ra̱hn Dihvo vo ri ye ihyan: ―Ihyan che a dave ye ne, a de ca̱h ye rendotenan che ntu. Nchuhn ne, a dave ne, andahre hua nducoya̱ca ne. ");
INSERT INTO cutNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ra̱hn ye te hua dave nducoya̱ca ihyan chahn, yahn che a devano ye te a̱ma cha sa̱hn che chi cuande se va̱n ihyan chahn ndihcue ndeh se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Chihno na̱no Dihvo vo ca̱h ihyan chahn ne, ndonun ye tino tu yahn ye, ne ndaconan chihnde ye na̱n mesa. Tuhme ra̱hn ye ri ye ihyan chahn: ―¿A chenahn nchuhn deh conahn che na̱nó ca̱h ne? Ca̱hmá có nchuhn deh conahn che tihca̱ na̱nó ca̱h ne. ");
INSERT INTO cutNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nchuhn ne, renevahnecun ne u, ra̱hn ne te a u che Dihve ne ma̱n, Ihyan Ricuahn yahn ne ma̱n, ne cua̱co che ra̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Cua cuande nchuhn. Andahre u che Dihve ne ma̱n, Ihyan Ricuahn yahn ne ma̱n, ate na̱nó ca̱h ne. Tihca̱ quenan cuma che din yahino a̱ma ta̱ma ne vih, na̱no ne ca̱h vih. ");
INSERT INTO cutNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Chihcó ejemplo cuh ca̱va che quendi ne. ");
INSERT INTO cutNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Cua̱co rá̱hn rí nchuhn te nde a̱ma mozo hua tahque chahte vederihquentiyon yahn se che co patrón yahn se. Namin nde a̱ma sa̱hn che rahn ntiyon hua tahque chahte vederihquentiyon yahn se che co ihyan che redechuh ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ndete che chenahn nchuhn yahn ejemplo che chihcó yahn ne, ne dinahn ne ne, a̱ma ndah ro yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Che tuhca̱ rá̱hn ne, hua ca̱va nducoya̱ca nchuhn. U ne, ndiyu che hua tumacadinó duh nduh nchuhn che tenda̱hnún nchuhn, ate va che conahn Ndudo yahn Dendiohs che a ndirun tuhca̱: “Sa̱hn che da̱ma reh da̱ma rih se nducó ne, sa̱hn min che din ta̱n se nducó.” ");
INSERT INTO cutNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Rá̱hn rí nchuhn ndudo cuh ma̱n che ametah conahn, ca̱va che cuahn che a conahn ne, cotahno ne te a u che a va ca̱de che chí ndedeváhn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Cua̱co rá̱hn rí nchuhn te adecoduhno ihyan che nevahnecun ye ihyan che dechúh ihyan ne, a u renevahnecun ye. Me ihyan che renevahnecun ye u ne, renevahnecun ye Dendiohs Chida, ihyan min che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chihno ra̱hn Dihvo vo chemin ne, a̱ma chi ra̱n ye, ne ra̱hn cua̱co ye: ―Cua̱co rá̱hn rí nchuhn te a̱ma cha nchuhn ndihcue ndeh ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ihyan apóstol chahn ne, a ndere rendihchenun ye na̱n vih, rendedecadino ye duh yahn che ra̱hn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A̱ma ihyan apóstol che a̱ma yahino Dihvo vo ihyan ne, da̱ma va ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Din ta̱h Simón Pedro yahn ye, ca̱va che tumerune ye Dihvo vo duh yahn che ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tuhme cuahn nda̱ ca ye na̱n Dihvo vo, ne tumerune ye ihyan: ―Dihvé, ¿duh yahn che ra̱hn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Deca̱hndá a̱ma ndi pa̱n, ne sa̱hn che cá̱h, cheh se ne, a sa̱hn min. Tuhme deca̱hnda Dihvo vo a̱ma ndi pa̱n, ne ca̱h ye, cheh Judas Iscariote, da̱ya Simón. ");
INSERT INTO cutNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ndeta̱hno che cheta̱h Judas pa̱n me ne, quenun chundah chete chedave yahn se. Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Cha che ndihque che din ne, codin no ndeta̱hno. ");
INSERT INTO cutNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nde a̱ma ihyan che vate ye na̱n mesa ne, hua chenahn ye deh cuande che tihca̱ ra̱hn Dihvo vo ri ye Judas. ");
INSERT INTO cutNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nducote sa̱hn min ndi se tesorero yahn ihyan chahn ne, chemin che na̱hn ye ne, ndedecadino ye, te co ra̱hn Dihvo vo nduco se che cua se dehtenduh che nahn yahn vihco, o che ca̱h se tume ihyan cheva̱h. ");
INSERT INTO cutNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ura min ne, a man, ne cuahn che chihno cheh Judas pa̱n me ne, quenda̱h vah se cuahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Cuahn che a chuh Judas cuahn se ne, ra̱hn Dihvo vo: ―Ma̱n ne, u che rinducó nducoya̱ca ihyan ne, na̱n dehtenduh che cuahno có ne, cuhnde ro vederihquentiyon chahte yáhn. Namin cuhnde ro vederihquentiyon chahte yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nducote u che rinducó nducoya̱ca ihyan, ca̱hco ró vederihquentiyon chahte yahn Dendiohs ne, namin Dendiohs ne, ca̱hco ro ye vederihquentiyon chahte yáhn, ne a nun cuahn ca̱hco ro ye. ");
INSERT INTO cutNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Da̱yá che yahinó nchuhn, a te neve ro ra che quenán nduco ne. Nchuhn ne, nuhn ne u, ate anduhneca̱ che rá̱hn nduco sa̱hn ndina̱n chahn ne, tihca̱ rá̱hn nduco ne ma̱n, te na̱n che ná̱hn ne, hua co ca̱hn ne quenuhn ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ca̱hcó a̱ma vederihquentiyon ra ca̱va nchuhn. Chemin ne, che din yahino a̱ma ta̱ma ne vih, nduhca̱ che yahino má̱n nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ndete che din yahino a̱ma ta̱ma ne vih ne, tumacadino nducoya̱ca ihyan che ritahno ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro ne, tumerune ye Dihvo vo: ―Dihvé, ¿ti che na̱hn ne ne? Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Na̱n che ná̱hn ne, hua co condoque u ma̱n, ate adive ne, condoque u. ");
INSERT INTO cutNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tuhme ra̱hn Pedro ri ye ihyan: ―Dihvé, ¿dehco che hua co conducó ndih ma̱n?, te nde vá vedeyeno che ca̱hco mendá̱hn u, andahre ca̱hno ihyan u ca̱va ne. ");
INSERT INTO cutNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ate ra̱hn Dihvo vo ri ye ihyan: ―Ndere rahn che ve vedeyeno che ca̱hco mendahn di, ca̱va u. Cua̱co rá̱hn rí di te numanahn che metah cuah tuh ne, cahme ino yune te hua rendihche u. ");
INSERT INTO cutNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Hua ndeh ndedecadino nchuhn. Codin chahtino ne Dendiohs. Namin codin chahtino ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Va̱co Chidá ne, a̱ma va na̱n che cuahtenan ihyan. Ndete che hua tihca̱ ne, a ra̱hn cá rí nchuhn. Cá̱hn ca̱hcoyá̱n na̱n che cuahtenan ne. ");
INSERT INTO cutNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cuahn che a cháhn chihcoyá̱n na̱n che cuahtenan nchuhn ne, chi tún ndichecuá nchuhn ca̱va che cuahtenan ne da̱ma nducó na̱n che conán. ");
INSERT INTO cutNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nchuhn ne, a devano ne ti ná̱hn. Namin a devano ne ta̱ca̱ tuno ne min. ");
INSERT INTO cutNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ra̱hn Tomás ri ye Dihvo vo: ―Dihvé, nducote hua devano nuhn ti che na̱hn ne ne, nde hua codevano nuhn ta̱ca̱ che co tuno nuhn min. ");
INSERT INTO cutNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ra̱hn Dihvo vo ri ye ihyan: ―A u che retihyon yuné ihyan, a u che ricuáhn ndudo cua̱co, a u che rendedeváhn ihyan. Atena̱n ca̱va u che co cuahtenan ihyan na̱n Dendiohs Chida. ");
INSERT INTO cutNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ndete che a tumacadino nchuhn yahn vederihquentiyon che quenan cumá ne, namin tumacadino ne duh che Chidá. Ma̱n ne, a tumacadino ne duh che Chidá, anduhneca̱ ndete che a ndihchero ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tuhme ra̱hn Felipe ri ye Dihvo vo: ―Dihvé, codin ne che co ndihchero nuhn Dendiohs Chida, ne nduco chemin ne, a cochahtino nuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ndahconan Dihvo vo, ne ra̱hn ye: ―Felipe, ametah ro che rinducó nchuhn, me ¿ta̱ca̱ che hua retumacadine yahn vederihquentiyon yáhn? Ihyan che rendihchero ye u ne, anduhneca̱ ndete che rendihchero Dendiohs Chida. Ametah deh cuande che caque u che dín che ndihchero nchuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Che tihca̱ rahn ne, rihque ro che hua devene che u ne, rinducó Chidá, ne rinduco ma̱n ye u. Ndudo che ricuáhn nchuhn ne, ndiyu che cuande yahn má̱n, te che cuande yahn Chidá. A ihyan min che rinduco ye u, redin ye che rinahn ntiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cuitahno nchuhn che u ne, rinducó Chidá, ne ma̱n ye rinduco ye u. Me ndete che hua co cotahno ne chemin che dendudo renté nduco ne ne, cuitahno ne yahn vederihno che redín. ");
INSERT INTO cutNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Cua̱co rá̱hn rí nchuhn te ihyan che ritahno ye u ne, namin din ye vederihno nduhca̱ che redín, nde vederihno che tahque rahte din ye. Tihca̱, te u ne, ná̱hn na̱n Dendiohs Chida, ");
INSERT INTO cutNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ne nducuahn che ca̱ca nchuhn ihyan che cuande yáhn ne, u che Da̱ya ye ne, dín che conahn nduco ne, ca̱hco ró che a̱ma chahte vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","U dín che conahn nduco nchuhn adecodehno che ca̱ca ne che cuande yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Ndete che yahino nchuhn u ne, codinahn ne che rihquentiyón. ");
INSERT INTO cutNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nducote va che ná̱hn ne, ca̱cá favor Chidá, ne dechuh ye Vaco Ndah yahn ye conduco nchuhn cuahn da̱ma, nda̱ca vedechahtino yahn ne. A Vaco Ndah yahn ye redin che renahn ihyan cha che cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ihyan nunde ne, hua co conduco Vaco Ndah yahn Dendiohs ihyan, te hua retumacadino ye vederihquentiyon yahn. Ate nchuhn ne, retumacadino ne, te rinduco Vaco ye nchuhn, ne conun nchuhn cuahn da̱ma. ");
INSERT INTO cutNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hua a̱ma yune ca̱hcomá̱n nchuhn, te ndaconan conducó nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cuihno neve ro ne, ametah ndaconan ndihchero ihyan iyehnse u, ate nchuhn ne, tumacadino ne che quendí conducó nchuhn, ne cuahtenan ne vahchetero, te u ne, vá ca̱va ne. ");
INSERT INTO cutNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tuhme tumacadino ne te u ne, rinducó Chidá. Me nchuhn ne, ndichahtino ne u, ne rinducó nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ihyan che renahn ye, ne redinahn ye che rihquentiyón ne, rihco ro ye che yahino ye u. Chidá ne, yahino ye ihyan che yahino ye u, ne namin u ne, yahinó ihyan, ne rinducó ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","A̱ma ihyan apóstol che duche ye Judas, ndiyu Judas Iscariote ne, tumerune ye Dihvo vo: ―Dihvé, ¿dehco che ra̱hn ne che conduco ne nuhn, ne hua conduco ne ihyan iyehnse ne? ");
INSERT INTO cutNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Ihyan che yahino ye u ne, redinahn ye che rihquentiyón. Ihyan chahn ne, yahino Chidá ihyan ma̱n, rinduco ye ihyan ma̱n. Namin u ne, rinducó ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ihyan che hua yahino ye u ne, hua redinahn ye che rihquentiyón. Ndudo che ricuáhn nchuhn ne, a ndudo yahn Chidá, ihyan min che dechuh ye u, ndiyu ndudo yahn má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Rete cuandé nchuhn nducuahn ndudo che tuhchan numanahn che quenan cá nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ava̱ne ne, Vaco Ndah yahn Dendiohs, che dechuh ye che cuande yáhn, ca̱va che nte vedechahtino nchuhn ma̱n, conan nchuhn ma̱n ne, din che conahn nchuhn nducuahn ma̱n, ntihyon ya̱n nducuahn che te cuandé nchuhn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ma̱n ne, Dendiohs conduco ye nchuhn. Dín che a̱ma nda̱hca̱ cuahtenan ne, cuahte dihn chedave yahn ne, ne chemin ne, hua co din nde a̱ma ihyan iyehnse. Hua ndeh ndedecadino nchuhn, nde huane dihya ne co. ");
INSERT INTO cutNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A chihnevan nchuhn che rá̱hn rí nchuhn che ná̱hn, ne ndaconán conducó nchuhn. Ndete che cua̱co che yahino nchuhn u ne, nde tuno chi yeno ne che rá̱hn rí nchuhn che ná̱hn na̱n Chidá, te Ihyan min ne, tahque chahte vederihquentiyon yahn ye che co u. ");
INSERT INTO cutNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A nde ma̱n no rá̱hn rí nchuhn, ca̱va che cuahn che a conahn ne, cotahno ne che a na̱n ihyan min che ná̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ametah tuno ura yáhn che quendi cá te cuandé nchuhn, te a cochi nino ura che conahn che nahn chundah, sa̱hn min che rihquentiyon se iyehnse cuh. Sa̱hn min ne, metah nde a̱ma vederihquentiyon yahn se ná̱n, ");
INSERT INTO cutNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ate cuahnecún che conahn nduhca̱ che nahn se, ca̱va che codevano ihyan iyehnse che yahinó Chidá, ne redináhn che rihquentiyon ye. Ma̱n ne, ca̱co vo muhn, cuhn vo nduco nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’U ne, anduhneca̱ dihyo uva ndah. Me Chidá ne, anduhneca̱ ihyan che redin ye cuda̱do dihyo uva. ");
INSERT INTO cutNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Dune dihyo uva che hua ri yahn ne, rihca ye. Ate dune che ri yahn ne, rihca ndudo ye ma̱n, renedin dave ye ma̱n, ca̱va che tahque co yahn. Anduhneca̱ ndete che tihca̱ redin Chidá nduco ihyan che ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nchuhn ne, anduhneca̱ dihyo uva che a nedin davé, tihchan ne, yahn che a chicuáhn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cuiquendi ne cochahtino ne u, ne u ne, quendí nda cuandé nchuhn. Ndete che nda riya a̱ma dune dihyo uva ne, ametah co yahn, te ametah nda na̱n duto. Cuihco nchuhn cuda̱do ca̱va che hua cuahno co ne tihca̱. Ndete che hua quendi ne cochahtino ne u ne, co ne nduhca̱ dune dihyo uva che a metah ri ndute yahn, yahn che ametah nda na̱n duto. ");
INSERT INTO cutNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’U ne, anduhneca̱ duto dihyo uva. Me nchuhn ne, anduhneca̱ dune. Nchuhn che nda cuandé nchuhn, ne ndete che quendi ne cochahtino ne u ne, co ne nduhca̱ dune dihyo uva che a̱ma ri yahn. Ate che tin dema̱n nchuhn ne, hua dehva co din ne, te hua ndichahtino ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Duh nchuhn che hua cochahtino ne u ne, cuaconda̱h veda̱mé nchuhn, co ne nduhca̱ a̱ma dune dihyo uva che a nta̱h. Dune chemin chan ne, retih, ne renedin da̱ma ihyan rihquiya̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Ndete che quendi nchuhn cochahtino ne u ma̱n, quendi ne dinahn ne che a chicuáhn nchuhn ma̱n ne, cuica ne deh che nahn ne, ne conahn nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chidá ne, riquenda̱h yavena̱n ye cuahn che a̱ma nda̱hca̱ redin nchuhn ntiyon. Nduco tihca̱ ne, rihco ro ne che numa cua̱co rinduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nduhca̱ che yahino Chidá u ne, tihca̱ yahinó nchuhn. Cuiquendi ne, cochahtino ne u, ne quendí din yahinó nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","U ne, redináhn vederihquentiyon yahn Chidá, ne cuahn da̱ma yahino ye u. Namin nchuhn ne, ndete che dinahn ne che rihquentiyón ne, quendí din yahinó nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Tihca̱ ricuáhn nchuhn ca̱va che a̱ma co yeno ne nduhca̱ che yeno má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Vederihquentiyon yáhn ca̱va nchuhn ne, che din yahino a̱ma ta̱ma ne vih nduhca̱ che yahino má̱n nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Vedeyahino che tahque chahte che co cuahtenan cuma ihyan ne, che ca̱hco menda̱hn ye ihyan coh ye, ndedevahn ye amigo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nchuhn ne, amigo yáhn nchuhn, ndete che dinahn ne che rihquentiyón nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ihyan ne, hua reneca̱h cuande ye mozo yahn ye dehtenduh che redin ye. Ate nchuhn ne, amigo yáhn nchuhn. Hua rinó nchuhn nduhca̱ mozo yáhn, ne chemin che chicuáhn nchuhn nducuahn che te cuande Chidá u. ");
INSERT INTO cutNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ndiyu nchuhn che tenda̱hnun ne u. A má̱n che tenda̱hnún nchuhn, ne chihquentiyón nchuhn che din ne ntiyon yáhn, ntiyon min che cochihve numacuahn ro. Nduco tihca̱ ne, din Chidá che conahn nduco ne, nducuahn che ca̱ca ne ihyan che cuande yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma̱n ne, ndaconan rihquentiyón nchuhn che din yahino a̱ma ta̱ma ne vih. ");
INSERT INTO cutNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Nchuhn ne, a devano ne che din ta̱n ihyan iyehnse nducó. Chemin che nde hua ca̱hn ino ne cuahn che din ta̱n ye nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nchuhn ne, hua da̱ma ri ne nduco ihyan nunde. Chemin che hua yahino ye nchuhn nduhca̱ che yahino ye combiero yahn ye. U ne, a tenda̱hnún nchuhn va̱n ye, ne redin ta̱n ye nduco ne, yahn che ametah da̱ma ri ne nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cueneca̱hco nchuhn ndudo che a rá̱hn rí nchuhn tuhca̱: “Nde a̱ma mozo yahn ihyan ne, hua tahque yudo se che co ma̱n ye.” Ihyan che redin ta̱n ye nducó ne, namin din ta̱n ye nduco nchuhn. Me ihyan che redinahn ye yahn ndudo che ricuáhn ne, namin nevahnecun ye ndudo che cacuahn nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Va che chuhrihn nchuhn nducuahn vedeta̱n yahn ihyan, yahn che rinduco ne u. Din ta̱n ye nduco ne, te hua rendihche ye Chidá, ihyan min che dechuh ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Nducote ndá̱, chicuáhn ihyan, ne hua chitahno ye ne, chemin che tahque chihta nunde yahn ye, nde na̱n che ca̱hma ye metah. ");
INSERT INTO cutNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ihyan che hua ri rendihche ye u ne, namin hua ri rendihche ye Chidá. ");
INSERT INTO cutNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Vederihno che nde a̱ma ihyan hua nedin ye ne, dín va̱n ye, ate nde nduco nduh ne, rendihche ta̱n ye u ma̱n, rendihche ta̱n ye Chidá ma̱n, ne chemin che nde tahque chihta nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tihca̱ va che co ca̱va che conahn ndudo yahn Dendiohs che a ndirun tuhca̱: “Andahre nde a̱ma nunde yáhn metah, ate din ta̱n ihyan nducó.” ");
INSERT INTO cutNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’A Vaco Ndah yahn Dendiohs che rete vedechahtino nchuhn ma̱n, che rete duto ndudo yahn ndudo ndah yahn ye ma̱n. Dechúh, ne cuahn che nda̱ ne, te duto ndudo yahn ndudo yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Namin nchuhn ne, ca̱h ne duto ndudo yahn ndudo yáhn, te chinduco ne u nde ro che cana̱n ntiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Rete cuandé nchuhn yahn dehtenduh che cuahno co ne, ca̱va che hua nda̱ca da̱ma ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sa̱hn ta̱n chahn ne, ndetenda̱h se nchuhn chete ya̱co, ne nda̱ ura che adecoduhno sa̱hn che ca̱hno se nchuhn ne, nde tuno ndedecadino se che a ntiyon yahn Dendiohs che redin se. ");
INSERT INTO cutNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tihca̱ din se, te hua rendihche se Chidá ma̱n, u ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cuahn che nda̱ ura che conahn nduco nchuhn tihca̱ ne, cueneca̱hco ne te a rá̱hn rí nchuhn. ’Ro mena̱n ne, hua te cuandé nchuhn yahn ndudo cuh, yahn che quenan cá muhn iyehnse nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ate ma̱n ne, ná̱hn na̱n Ihyan che dechuh ye u, ne nde a̱ma nchuhn hua retumarune ne u ti che ná̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tahque ndah ne, a̱ma chi ra̱n ne che tihca̱ rá̱hn nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ra̱hn cua̱có rí nchuhn te ta̱hque ndah ca̱va ne che ná̱hn, te atena̱n nduco tihca̱ co dechúh Vaco Ndah Yahn Dendiohs, nte vedechahtino nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cuahn che nda̱ ne, din che conahn ihyan che chendihco ye nunde ma̱n, din che conahn ye che runeca̱de u ma̱n, din che conahn ye che Dendiohs ne, techeca̱de ye yahn ye, din ye castigo ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Conahn ye che chendihco ye nunde yahn che hua ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Conahn ye che runeca̱de u, te ná̱hn na̱n Chidá, nda̱cá va̱n nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Conahn ye che Dendiohs ne, techeca̱de ye yahn ye, din ye castigo ihyan, te chundah, sa̱hn min che quenan cuma se vederihquentiyon muhn iyehnse ne, a techeca̱de ye yahn se, ne va che din ye castigo sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’A̱ma va ca ndudo che cacuáhn nchuhn ate meniyon ne, hua tuno vederendedecadino yahn ne che conahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A Vaco Ndah yahn Dendiohs che reca̱h duto ndudo yahn ndudo ndah yahn ye. Cuahn che nda̱ ne, te cuande nchuhn yahn ndudo min. Ndiyu tin dema̱n che tihca̱ din, te a Dendiohs che rihquentiyon che tihca̱ din. Namin te cuande nchuhn nde yahn dehtenduh che coma̱n cochi che co. ");
INSERT INTO cutNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ndeva yavená̱n, te a vederihquentiyon yáhn che te cuande nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tihca̱, te nducuahn vederihquentiyon yahn Chidá ne, va tá̱h. Chemin che rá̱hn che Vaco Ndah yahn ye ne, a vederihquentiyon yáhn che te cuande nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’A tah ra che quenán nduco nchuhn, te ná̱hn na̱n Dendiohs Chida. Ate adive tah cuahn ne, ndaconan ndihchero ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tuhme retumerune vih na̱hn ihyan apóstol chahn va̱n ma̱n ye nduco vih: ―Ra̱hn ye che cuihno neve ro ne, ametah ndihchero vo ihyan ma̱n, che adive tah cuahn ne, ndaconan ndihchero vo ihyan ma̱n, che a na̱hn ye na̱n Dendiohs Chida ma̱n. ¿Dehra conahn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Dehra conahn che ra̱hn ye che cuihno neve ro me ne? Hua renahn vo deh conahn che tihca̱ ra̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Dihvo vo ne, checadino che hua chenahn ihyan chahn, ne nahn tumerune ye ihyan. Tuhme ra̱hn ye ri ye ihyan: ―U ne, rá̱hn rí nchuhn che cuihno neve ro ne, ametah ndihchero ne u, ne adive tah cuahn ne, ndaconan ndihchero ne u. ¿A yahn chemin che a̱ma retumerune vih ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Cua̱co rá̱hn rí nchuhn che a̱ma co nda̱che ne, nde a̱ma cuaco ne. Numanahn min ne, ihyan nunde ne, a̱ma co yeno ye. Ate cuavi vedera̱n yahn ne, ne co yeno ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A̱ma nda̱hta, cuahn che a nda̱ ura yahn te che cuacoya̱hn te ne, ri ra̱n te, yahn che ra yah chete te. Ate cuahn che a chacoya̱hn te decua̱h yahn te ne, nde metah reneca̱hco te yahn vedeyah me, yahn che a̱ma yeno te che a va decua̱h yahn te. ");
INSERT INTO cutNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nduhca̱ vedera̱n min che hua rengu ne, tihca̱ vedera̱n yahn nchuhn, te cuahn che ndaconan conducó nchuhn ne, a̱ma co yeno ne, nde hua duhva co din che co ra̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Nda̱ ro min ne, nde a̱ma na̱n dehtenduh ametah ndotenan che ca̱ca ne u che te cuandé nchuhn. Cua̱co rá̱hn rí nchuhn te nducuahn dehtenduh che nahn ne ne, co ca̱ca ne Chidá che cuande yáhn, ne din ye che conahn nduco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Nde meniyon ne, nde a̱ma na̱n dehtenduh hua rica nchuhn Ihyan che cuande yáhn. Ma̱n ne, cuica ne nducuahn dehtenduh che nahn ne, ne din ye che conahn nduco ne, ca̱va che a̱ma co yeno ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ricuáhn nchuhn dema̱n nduco ejemplo, ate nda̱ ro che ametah cacuáhn nchuhn nduco ejemplo, te tahque ndah ne, ca̱hma cua̱có có nchuhn yahn vederihquentiyon yahn Chidá. ");
INSERT INTO cutNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ro min ne, nducuahn dehtenduh che ca̱ca ne Dendiohs Chida che cuande yáhn ne, metah ndotenan che u ca̱cá favor ihyan che conahn nduco ne, ");
INSERT INTO cutNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","te yahino ye nchuhn, ne ma̱n ye din ye che conahn nduco ne. Yahino ye nchuhn yahn che yahino ne u ma̱n, yahn che ritahno ne che ma̱n ye dechuh ye u ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","U ne, chicá na̱n Dendiohs Chida, ndá̱ muhn iyehnse. Ma̱n ne, a nun nda̱cá muhn, ne na̱hn tún na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tuhme ra̱hn ihyan apóstol yahn ye ri ye ihyan: ―Ma̱n che cua̱co ne, ra̱hn cua̱co ne nduco nuhn. Ametah nduco ejemplo rete cuande ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","A ndero ndi che devano ne nducuahn dehtenduh nde hua rendotenan che ca̱ca ihyan ndih che ca̱h cuande ne ihyan. Chemin che ritahno nuhn che Dendiohs dechuh ye ndih. ");
INSERT INTO cutNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Ma̱n ne, a ritahno nchuhn u numa ino ne. ");
INSERT INTO cutNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ate a cochi nino ura che ca̱no ne, ca̱hn muhn ca̱hn min ne, ca̱hcoma̱n ne u. Ate hua demá̱n, te nduco Dendiohs Chida u. ");
INSERT INTO cutNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nducuahn dehtenduh chemin chan ne, rete cuandé nchuhn ca̱va che cochahtino ne u, ne cuahte dihn chedave yahn ne. Cuedevano ne te va che chuhrihn ne, din ta̱n ihyan nunde nduco ne, ate hua dehva ra̱hco ne, te va che nda̱hco ndiyá chundah nduco ihyan yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Chihno che tihca̱ ra̱hn Dihvo vo nduco ihyan apóstol yahn ye ne, chenihyon na̱n ye na̱n ro, ne cova̱h ye tuhca̱: ―Chidá, nda̱ nino ura che va che chuhríhn. Cuendeva ne yavená̱n ca̱va che namin u ne, ndevá yavena̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tihca̱, te ndih ne, chihco ne vederihquentiyon tá̱h che ca̱hcantiyón nducoya̱ca ihyan iyehnse ma̱n, che ndedeváhn nducoya̱ca ihyan che tenda̱hnun ne che cotahno ye u, ne cuahtenan ye vahchetero numacuahn ro ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Atena̱n ndih che Dendiohs, ne ihyan che nevahnecun ye ndih ma̱n, u che dechuh ne ma̱n ne, atena̱n ihyan chahn che cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’U ne, ndevá yavena̱n ne muhn iyehnse. Namin dináhn ntiyon che chihquentiyon ne che dín. ");
INSERT INTO cutNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chidá, ma̱n ne, cuendeva ne u, ne codin ne che cuhnde ro vederihquentiyon yuhn vo nduhca̱ ro mena̱n cuahn che metah cuhnde iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ihyan che tenda̱hnun ne va̱n ihyan nunde ca̱va che cotahno ye u ne, a ca̱h cuandé ihyan che Dendiohs ndih. Ihyan chahn ne, ihyan yahn ne, ne din ne che chitahno ye u, nevahnecun ye ndudo ndah yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma̱n ne, a devano ye te nducuahn vederihquentiyon che quenan cumá ne, a ndih te ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chicuáhn ihyan ndudo yahn ne che nda̱hco ne tá̱h, ne nevahnecun ye. A checadino ndah ye, ne chitahno ye che a ma̱n ne dechuh ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ricá ndih ca̱va ihyan chuhn che tenda̱hnun ne che cotahno ye u, te ihyan yahn ne ihyan. Ndiyu ca̱va ihyan nunde che ricá. ");
INSERT INTO cutNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nducoya̱ca ihyan yáhn ne, yahn ne ihyan. Namin nducoya̱ca ihyan yahn ne ne, yáhn ihyan, ne a ca̱va ihyan chahn che ndeva ihyan yavená̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’U ne, nda̱cá muhn iyehnse, ne nchí ca̱va che conán nduco ne. Ate ihyan chuhn ne, cuahtenan ca ye iyehnse. Chidá che va ne vahchetero, numacuahn vederihquentiyon yahn ne, codin ne cuda̱do ihyan che tenda̱hnun ne che cotahno ye u, ca̱va che a̱ma ndudo co no ye nduhca̱ uvo. ");
INSERT INTO cutNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Numanahn che quenán muhn iyehnse nduco ihyan chuhn che tenda̱hnun ne che cotahno ye u ne, numacuahn vederihquentiyon yahn ne, dín cuda̱do ihyan. Hua chinda nde a̱ma ye, atena̱n a̱ma sa̱hn che a ndinda se, ca̱va che conahn nduhca̱ che a ndirun na̱n Ndudo yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Ma̱n ne, nchí na̱n ne. Ate numanahn che quenan cá muhn ihyense ne, tihca̱ ricá ndih ca̱va che co yeno ihyan chuhn, nduhca̱ che yeno má̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Chicuáhn ndudo yahn ne ihyan chuhn, ne ihyan nunde ne, rendihche ta̱n ye ihyan yahn che ametah da̱ma ri ye nduco ye, nduhca̱ che u ne, hua da̱ma rí nduco ihyan nunde. ");
INSERT INTO cutNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ricá ndih ca̱va ihyan chuhn. Ndiyu ca̱va che ndeta̱hno ndeva ne ihyan, ate che ndedevahn ne ihyan ta̱h chundah. ");
INSERT INTO cutNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nduhca̱ che ndiyu ihyan nunde u ne, namin ihyan chuhn ne, ametah da̱ma ri ye nduco ihyan nunde. ");
INSERT INTO cutNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Numacuahn vederihquentiyon yahn Ndudo yahn ne, Ndudo min che redin che renahn ihyan cha che cua̱co ne, cuihco vih ne ihyan chuhn ca̱va ma̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nduhca̱ che te ne ntiyon u, dechuh ne u va̱n ihyan nunde ne, tihca̱ cá̱h ntiyon ihyan chuhn, dechúh ihyan va̱n ihyan nunde. ");
INSERT INTO cutNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A ca̱va ihyan chuhn che ca̱hco mendá̱hn u cóh, ca̱va che cotahno ye ndudo ndah yahn ne, ne runeca̱de cuahtenan ye. ");
INSERT INTO cutNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ricá ndih, ndiyu dema̱n ca̱va ihyan chuhn, te namin ca̱va ihyan che cotahno ye u adive, yahn che cahnevan ye ndudo che cuahndudo ihyan chuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Chidá, nduhca̱ u nduco ne ne, a̱ma no vederendedecadino yuhn vo ne, ricá ndih che din ne che a̱ma ndudo no co nducoya̱ca ye, cochahtino ye uvo. Nahn che a̱ma ndudo no co nducoya̱ca ye, ca̱va che cotahno ihyan iyehnse che ndih dechuh ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Vederihquentiyon che te ne u ne, namin cá̱h ihyan chuhn, ca̱va che a̱ma ndudo no co ye, nduhca̱ che u nduco ndih ne, a̱ma no vederendedecadino yuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ndih ne, rinduco ne u, ne u ne, rinducó ihyan chuhn, ca̱va che a̱ma ndudo no co ye. Nduco tihca̱ ne, tumacadino ihyan nunde che dechuh ne u ma̱n, yahino ne ihyan chuhn nduhca̱ che yahino ne u ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Chidá, ihyan chuhn che tenda̱hnun ne ca̱va che co nduco ye u ne, náhn che cuahtenan ye nducó na̱n che conán, ca̱va che tumacadino ye yahn vederihquentiyon che numacuahn vedeyahino yahn ne nda̱hco ne tá̱h nde ro che metah cuhnde iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Chidá che va ne vahchetero, ihyan nunde ne, hua rendihche ye ndih, ate u ne, rendihché ndih. Me ihyan chuhn ne, a devano ye che ndih dechuh ne u. ");
INSERT INTO cutNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A ca̱h cuandé ihyan chuhn yahn vederihquentiyon yahn ne, ne conduco cá ihyan, quendí ca̱h cuandé ihyan, ca̱va che, nduhca̱ che yahino ne u ne, tihca̱ din yahino ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Chihno ra̱hn Dihvo vo dehtenduh che tuhchan ne, chica ye min nduco ihyan apóstol yahn ye, cuahn ye ta̱ma la̱do viche a̱ma ya che duche Cedrón. A̱ma cua̱n min ne, va ya̱hn nda̱ta, ne min chenda̱ ye nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, sa̱hn min che a rihco ca̱de se che ndihcue ndeh se Dihvo vo ne, namin a rendihche se min, te a̱ma ndeh yune chahn Dihvo vo nduco ihyan apóstol yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nducote a rendihche se min ne, hua chi va̱hche yahn se, ne chahn cua̱co no se na̱n che quenun Dihvo vo. Nduco se a̱ma ya̱hn sanda̱do ma̱n, policía yahn ya̱co ma̱n, che dechuh chidocuya̱n ndina̱n nduco sa̱hn fariseo. Sanda̱do chahn ma̱n, policía ma̱n ne, nda se espa̱da ma̱n, linterna ma̱n. Cuahn che a nda̱ nino sa̱hn chahn ne, ");
INSERT INTO cutNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","nducote a devano Dihvo vo nducuahn che va che cuahno co ye ne, quenda̱h ye va̱n ihyan apóstol yahn ye ne, tumerune ye sa̱hn: ―¿Duh rinuhn nchuhn ne? ");
INSERT INTO cutNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ndahconan sa̱hn chahn, ne ra̱hn se ri se ihyan: ―Jesús yahn ya̱n Nazaret, rinuhn nuhn. Ra̱hn ye ri ye sa̱hn: ―A u che rá̱hn nduco nchuhn. Judas, sa̱hn min che ndihcue ndeh se Dihvo vo ne, min quenun se va̱n sa̱hn chahn. ");
INSERT INTO cutNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Cuahn che ra̱hn Dihvo vo ri ye sa̱hn chahn che a ihyan min che rinuhn se ne, chica da̱ma nducoya̱ca se, ne chera se nde ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tuhme ndaconan tumerune Dihvo vo sa̱hn: ―¿Duh rinuhn nchuhn ne? Ra̱hn se ri se ihyan: ―Jesús yahn ya̱n Nazaret rinuhn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ra̱hn ye ri ye sa̱hn: ―A rá̱hn rí nchuhn te a u che rá̱hn nduco ne. Nducote u che rinuhn ne ne, cuahnecun ne che na̱hn ihyan chuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tihca̱ chi ca̱va che conahn nduhca̱ che ra̱hn ma̱n Dihvo vo tuhca̱: “Ihyan che tenda̱hnun Dendiohs Chida ca̱va che conduco ye u ne, hua chinda nde a̱ma ye.” ");
INSERT INTO cutNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedro ne, nda ye a̱ma espa̱da. Ndetenda̱h ye, ne chahn ye a̱ma sa̱hn deca̱hya yahn chidocuya̱n che tahque ndina̱n che duche se Malco, ne chaconda̱h ye revan se la̱do ta̱h cua̱co se. ");
INSERT INTO cutNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ate ra̱hn Dihvo vo ri ye Pedro: ―Cuentihyen ndah espa̱da tih chete va̱co. Va che chuhríhn nducuahn che a ndihco ca̱de Dendiohs Chida. ");
INSERT INTO cutNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sanda̱do chahn nduco sa̱hn ndina̱n yahn se ma̱n, sa̱hn policía yahn ya̱co ma̱n ne, chi ihyo se Dihvo vo, din se preso ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Quenda se ihyan ndeva̱co Anás, incha̱hn ndico Caifás, chidocuya̱n che tahque ndina̱n ye nduyo min. ");
INSERT INTO cutNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás ne, a ihyan min che ra̱hn ye ri ye sa̱hn ndina̱n yahn nación yahn Israel, che tahque nda̱hca̱ che a̱ma no ihyan coh ye ca̱va nducoya̱ca ihyan nación yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro nduco ta̱ma ihyan apóstol ne, cuahn ye diyahn diyahn cua̱hn na̱n cuahn Dihvo vo. Ihyan apóstol che ta̱ma me ne, a rendihche chidocuya̱n ndina̱n me ihyan, ne chemin che chi chenda̱ ye ura che nda̱ Dihvo vo, quenun ye na̱n che ri chevah va̱co chidocuya̱n ndina̱n me. ");
INSERT INTO cutNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ate Pedro ne, chandi ye cua̱hn chevah me. Tuhme quenda̱h ihyan apóstol che ta̱ma me, ne ya̱hve ye ta̱hn che redin cuda̱do chendevah me, ne quenda ye Pedro cua̱hn chete me. ");
INSERT INTO cutNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ta̱hn che redin cuda̱do chendevah me ne, tumerume te Pedro: ―¿A ndiyu nduco di rindoque ihyan ca̱h ne? Ndahconan Pedro ne, ra̱hn ye ri ye ta̱hn: ―Hua. Hua rinducó ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nducote a̱ma iche vino min ne, sa̱hn deca̱hya yahn chidocuya̱n ma̱n, sa̱hn policía ma̱n, ndihco se a̱ma va̱coya̱hn, ne vatendi se reca̱h ihno se sa̱hn. Namin Pedro ne, nduco ye sa̱hn chahn, nti ye chihto va̱coya̱hn me, reca̱h ihno ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Chicarune chidocuya̱n che tahque ndina̱n me Dihvo vo, duh nduh ihyan che rinduco ye ihyan ma̱n, deh che ricuahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ra̱hn Dihvo vo ri ye chidocuya̱n me: ―U ne, cuahn da̱ma chicuáhn va̱n nducoya̱ca ihyan, chete ya̱co chahte ma̱n, ya̱co ca̱hya ma̱n, na̱n che rendo da̱ma nducoya̱ca ihyan nación yahn Israel. Dehve chicuáhn cua̱hn ma̱n cua̱hn ndeh. ");
INSERT INTO cutNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ndotenan che u ca̱carune ne ne, cuicarune ne ihyan che chicuáhn. Ihyan chahn ca̱hma ye co ye ndih deh che chicuáhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cuahn che tihca̱ ra̱hn Dihvo ne, chahn a̱ma sa̱hn policía yahn ya̱co va̱cona̱n ye, ne ra̱hn se ri se ihyan: ―¿Dehco che tihca̱ ndahconen yahn chidocuya̱n ndina̱n? ");
INSERT INTO cutNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ra̱hn Dihvo vo ri ye sa̱hn: ―Ndete che hua tihca̱ che rá̱hn ne, cahme ti quenan che hua nda̱hca̱ rá̱hn. Ate ndete che nda̱hca̱ rá̱hn ne, hua nda̱hca̱ din che chehn u. ");
INSERT INTO cutNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tuhme ndedechuh Anás Dihvo vo, nchiche ihyo ye, ta̱h Caifás, chidocuya̱n che tahque ndina̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Numanahn min ne, nti Pedro reca̱h ihno ye ihyan chihto va̱coya̱hn, ne tumerune sa̱hn che chenun min ihyan: ―¿A ndiyu nduco di rindoque ihyan ca̱h ne? Ndahconan Pedro yahn se: ―Hua. Hua rinducó ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tuhme a̱ma sa̱hn deca̱hya yahn chidocuya̱n che tahque ndina̱n, sa̱hn vih sa̱hn che chaconda̱h Pedro revan me ne, ra̱hn se ri se Pedro: ―¿Ta̱ca̱ hua?, te u ne, ndihcheró di nduco ye min va̱n ya̱hn nda̱ta me. ");
INSERT INTO cutNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ndaconan ra̱hn Pedro che hua rendihche ye Dihvo vo, ne ura min cah tuh. ");
INSERT INTO cutNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tuhme quenda sa̱hn ndina̱n chahn Dihvo vo, chica se va̱co Caifás, ne nda̱ se nduco ye na̱n pala̱cio yahn gobernador. Ura min ne, a chi dave. Sa̱hn chahn ne, hua chenda̱ se chete pala̱cio me, te ra̱hco se te ca̱hnda yahn se, ne hua co conduco se, ro yudo me. ");
INSERT INTO cutNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nducote hua chenda̱ se ne, quenda̱h Pila̱to, ne tumerune se sa̱hn: ―¿Deh yahn che rica nunde nchuhn yahn ihyan cuh ne? ");
INSERT INTO cutNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ndahconan sa̱hn chahn, ne ra̱hn se: ―A che a duhtuno ihyan sa̱hn tih, ne chemin che checu nuhn sa̱hn ta̱h ne. ");
INSERT INTO cutNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tuhme ra̱hn Pila̱to ri se sa̱hn chahn: ―Cuiquenda nchuhn ihyan, cotecheca̱de ma̱n ne yahn ye nduhca̱ che rihquentiyon ley yahn ne. Ndahconan sa̱hn chahn, ne ra̱hn se: ―Ate nuhn ihyan nación yahn Israel ne, metah vederihquentiyon yahn nuhn ca̱va che ca̱hno nuhn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nduco tihca̱ ne, cana̱n chinahn che ra̱hn Dihvo vo nduhca̱ che va che ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ndaconan ndonda̱ Pila̱to chete pala̱cio, ne cah se Dihvo vo, tumerune se ihyan: ―¿A ndih che Rey yahn ihyan nación yahn Israel ne? ");
INSERT INTO cutNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ra̱hn Dihvo vo ri ye sa̱hn: ―¿A che rendedecadine man che tihca̱ retumerone, o a ihyan ra̱hn ye ri ye di ne? ");
INSERT INTO cutNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ndahconan Pila̱to, ne ra̱hn se: ―U ne, ndiyu ihyan nación yahn Israel u. Sa̱hn nación yahn ne ma̱n, chidocuya̱n ndina̱n ma̱n, checu se ndih tá̱h. ¿Deh din ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tuhme ra̱hn Dihvo vo ri ye sa̱hn: ―Ndiyu iyehnse cuh che rihquentiyón. Chemin che ihyan che rinduco ye u ne, hua cuhn ye ca̱va che ndedevahn ye u ta̱h sa̱hn sih. ");
INSERT INTO cutNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ra̱hn Pila̱to ri se ihyan: ―¿A Rey ndih tuhme ne? Ndahconan ye, ne ra̱hn ye ri ye sa̱hn: ―Rey u, nduhca̱ che rahn. U ne, ndá̱ iyehnse cuh, chihndeyá̱n, ca̱va che cuahndudó ndudo cua̱co. Nducoya̱ca ihyan che renevahnecun ye ndudo cua̱co ne, rihcovan ye che rahndudó. ");
INSERT INTO cutNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ra̱hn Pila̱to ri se ihyan: ―¿Deh ndudo cua̱co che tihca̱ ra̱hn ne yahn ne? Chihno ra̱hn Pila̱to chemin ne, quenda̱h se ta̱ma yune, ne ra̱hn se ri se sa̱hn ndina̱n chahn: ―Ihyan cuh ne, nde a̱ma nunde yahn ye metah. ");
INSERT INTO cutNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Nchuhn ne, va costumbre yahn ne che nta̱hté adecoduhno preso che nahn ne vihco ro yudo. ¿A nahn ne che nta̱hté ihyan cuh che Rey yahn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tuhme ndaconan cah sa̱hn chahn: ―¡Sa̱hn tih ne, hua! ¡Cuenta̱hte ne Barrabás! Me Barrabás ne, a̱ma sa̱hn duco. ");
INSERT INTO cutNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tuhme chihquentiyon Pila̱to che chahn sanda̱do Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sanda̱do chahn ne, dendah se a̱ma corona ya̱n, tihyon se tin Dihvo vo, ne tihyon se a̱ma tino mora̱do ihyan, nduhca̱ tino che rahtenun rey. ");
INSERT INTO cutNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Chihno min ne, ndo da̱ma se na̱n ye, ne redin ca̱ se che rendeva se yavena̱n ye. Rah se: ―¡Ndeva vo yavena̱n Rey yahn ihyan nación yahn Israel! Namin chahn se va̱cona̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Quenda̱h tun Pila̱to, ne ra̱hn se ri se sa̱hn ndina̱n chahn: ―Condihche nchuhn. Ndetendá̱h ihyan meniyon ca̱va che codevano ne te metah nde a̱ma nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Quenda̱h Dihvo vo, quenun tin ye corona ya̱n me ma̱n, quenun ye tino mora̱do me ma̱n. Tuhme ra̱hn Pila̱to ri se sa̱hn chahn: ―¡Nga̱ ye! ¡Condihchero nchuhn ihyan! ");
INSERT INTO cutNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cuahn che ndihchero chidocuya̱n ndina̱n chahn ma̱n, sa̱hn policía ma̱n, Dihvo vo ne, numacuahn vedeta̱n cah se: ―¡Cuaconahn ya̱h ne sa̱hn! ¡Cuaconahn ya̱h ne sa̱hn! Ra̱hn Pila̱to ri se sa̱hn: ―Cuiquenda ma̱n nchuhn ihyan, cuaconahn ya̱h ne ihyan, te u ne, a techeca̱dé yahn ye, ne a devanó te metah nde a̱ma nunde yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ndahconan sa̱hn chahn, ne ra̱hn se ri se Pila̱to: ―Sa̱hn tih ne, va che coh se, te tihca̱ rihquentiyon ley yahn nuhn yahn che ra̱hn se che Da̱ya Dendiohs sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Cuahn chihnevan Pila̱to che tihca̱ ra̱hn sa̱hn chahn ne, nde tahque dihya se chi. ");
INSERT INTO cutNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ndaconan ndonda̱ se chete pala̱cio yahn se, ne tumerune se Dihvo vo: ―¿Ti ya̱n va̱co ne ne? Ate Dihvo vo ne, nde hua ndahconan ye yahn se. ");
INSERT INTO cutNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tuhme ra̱hn se ri se ihyan: ―¿Dehco che hua rendahconan ne yáhn? ¿A hua devano ne te va vederihquentiyon yáhn? Co nda̱hcó libre ndih ndete che náhn. Namin co ca̱hcantiyón che conan ya̱h ne. ");
INSERT INTO cutNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ndahconan Dihvo vo, ne ra̱hn ye ri ye sa̱hn: ―Nde a̱ma vederihquentiyon, hua co conan come ná̱n, ndete che Dendiohs hua te ye di. Chemin che sa̱hn che checu se u tah ne, tahque chendihco se nunde che co di. ");
INSERT INTO cutNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A nde ura min rinuhn ino Pila̱to ta̱ca̱ co nda̱hco se libre Dihvo vo, ate sa̱hn ndina̱n chahn ne, cah se yahn se: ―Ndete che nda̱hco ne libre sa̱hn tih ne, ¡hua amigo yahn ne emperador ndih!, te adecoduhno ihyan che nahn co ye rey ne, redin va̱hche ye yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cuahn che chihnevan Pila̱to che tihca̱ ra̱hn sa̱hn chahn ne, chihquentiyon se che ndiquenda̱h Dihvo vo, ne chihnde se na̱n che retecheca̱de se, na̱n che duche Gabata che deva̱co hebreo, che conahn tuhca̱: “Na̱n Che Chenun Tu.” ");
INSERT INTO cutNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ura min ne, ri tenduh na̱n ma̱hn ya̱hn, ne a ta̱ma ro me che ro yudo. Tuhme ra̱hn Pila̱to ri se sa̱hn ndina̱n chahn: ―¡Nga̱ Rey yahn nchuhn! ");
INSERT INTO cutNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ate sa̱hn chahn ne, rah se: ―¡Cuedecuihno ne sa̱hn! ¡Cuedecuihno ne sa̱hn! ¡Cuaconahn ya̱h ne sa̱hn! Ra̱hn Pila̱to ri se sa̱hn chahn: ―¿Ta̱ca̱ che cuaconahn yá̱h Rey yahn ne? Ate sa̱hn chicocuya̱n ndina̱n chahn ne, ndahconan se, ne ra̱hn se ri se Pila̱to: ―Nuhn ne, atena̱n emperador che rey yahn nuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nduco ndudo che tihca̱ ra̱hn se ne, nda̱hco Pila̱to Dihvo vo ta̱h se ca̱va che conan ya̱h ye, ne quenda se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Quenda se Dihvo vo, ne quenda ye cruz na̱n che va che conan ya̱h ye, cuahn ye a̱ma cua̱n na̱n che duche Cuete Ine Tin Tena̱hn, ne che deva̱co hebreo ne, duche Gólgota. ");
INSERT INTO cutNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Min chaconahn ya̱h se Dihvo vo da̱ma nduco o se, a̱ma se a̱ma a̱ma la̱do chihto na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Dirun Pila̱to a̱ma letrero, ne chihquentiyon se che quenan tin cruz. Ndirun tuhca̱: “Ihyan cuh che Jesús yahn ya̱n Nazaret, Rey yahn ihyan nación yahn Israel.” ");
INSERT INTO cutNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A̱ma ya̱hn sa̱hn nación yahn Israel ndihchenan se che tihca̱ ndirun, te na̱n che chaconahn ya̱h se Dihvo vo ne, nino viya̱n me. Letrero me ne, ndirun deva̱co hebreo ma̱n, griego ma̱n, latín ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Chidocuya̱n ndina̱n chahn ne, ra̱hn se ri se Pila̱to: ―Hua nda̱hca̱ che dirun ne “Rey yahn ihyan nación yahn Israel.” Tahque ndah ne, codirun ne “Ihyan cuh ne, ra̱hn ye che ma̱n ye che Rey yahn ihyan nación yahn Israel.” ");
INSERT INTO cutNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ate Pila̱to ne, ra̱hn se ri se sa̱hn: ―Che dirún ne, a tihca̱ conan, ametah nda̱hcorún. ");
INSERT INTO cutNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cuahn che a chihno chaconahn ya̱h sanda̱do chahn Dihvo vo ne, cahn ma̱hn se tino yahn ye va̱n cun se. Namin cheta̱h se cahteca tu yahn ye, ne nducote chemin ne, hua nta̱hyon te ndiya ne, ");
INSERT INTO cutNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","25","chemin che ra̱hn se nduco vih: ―Tahque ndah ne, hua ndeh vo, ne tenda̱h vo suerte yuhn vo ca̱va che cadino vo cha uvo che quenda̱h yuhn vo che co yuhn vo. Tihca̱ din se, ne chinahn nduhca̱ che ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Cahn ma̱hn se tino yáhn nduco vih, ne tenda̱h se suerte cha sa̱hn quenda̱h yahn se che co yahn se tino tu yáhn.” Chihto cruz na̱n che quenan ya̱h Dihvo vo ne, nti chaco ye ma̱n, coh chaco ye María, nda̱hta yahn Cleofas ma̱n, María yahn ya̱n Magdala ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Cuahn che ndihchero Dihvo vo chaco ye ma̱n, a̱ma ihyan apóstol, ihyan min che a̱ma din yahino ye ma̱n, che vatendi ye min ne, ra̱hn ye ri ye chaco ye: ―Chacó, nga̱ da̱ya ne, nti se ta̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Namin ra̱hn ye ri ye ihyan apóstol me: ―Nga̱ cheque, nti ye ta̱n. Nde ro min ndeva ihyan apóstol min chaco Dihvo vo ndeva̱co ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chihno min ne, nducote a devano Dihvo vo che a chinahn nducuahn ne, ca̱va che conan conahn nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs ne, ra̱hn ye: ―Ya̱ca rí. ");
INSERT INTO cutNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Va a̱ma ja̱rro min ndito vino. Tuhme chaconahn sa̱hn chahn a̱ma esponja tin a̱ma nduco che duche hisopo, ne deca̱hnda se esponja me nduco vino me, chaconahn se chende Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tihve ye vino me, ne ra̱hn ye: ―Ma̱n ne, a chinahn nducuahn. Tuhme chendih ye, ne chih ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A ta̱ma ro me che vihco ro yudo, ne chemin che hua nahn chidocuya̱n ndina̱n chahn che cuahtendihco tena̱hn na̱n cruz ro che rahtetuhno ihyan, te a̱ma yudo ro min. Chemin che chica se Pila̱to che dechuh se sanda̱do che ca̱hn se, ndeh se ine dihma ihyan che chenan ya̱h chahn, ne ndedevah se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tuhme tahve Pila̱to sanda̱do, chahn se, ndeh se ine dihma a̱ma sa̱hn che quenan ya̱h chihto na̱n Dihvo vo. Chihno min ne, ndeh se ine dihma sa̱hn che ta̱ma me. ");
INSERT INTO cutNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Me cuahn che chahn nda̱ se na̱n che quenan ya̱h Dihvo vo ne, ndihchero se che a ndih ye. Chemin che ametah ndeh se ine dihma ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ate nde nduco nduh ne, ca̱h a̱ma sanda̱do la̱nza ticua ye nino van chete ye, ne quenda̱h yun ma̱n, nune ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","U che dirún ca̱ca cuh ne, cua̱co ndudo che dirún, te má̱n ndihcheró che tihca̱ chi. Dirún yahn ca̱va che namin nchuhn ne, cotahno ne. ");
INSERT INTO cutNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tihca̱ chahno chi Dihvo vo ca̱va che conahn nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs tuhca̱: “Hua ndeh se nde a̱ma ine yahn ye.” ");
INSERT INTO cutNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Namin chinahn nduhca̱ che a ndirun ta̱ma cua̱n na̱n Ndudo yahn Dendiohs tuhca̱: “Cuahtendi se, ndihchero se ihyan che ca̱h se la̱nza.” ");
INSERT INTO cutNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Chihno min ne, a̱ma ihyan ya̱n Arimatea che duche ye José, che chitahno ye Dihvo vo cua̱hn ndeh yahn che va̱h ye chidocuya̱n ndina̱n chahn ne, chica ye Pila̱to ca̱va che ca̱h yune se che ndedevah ye Dihvo vo, quenda ye ihyan, cuhche ye ihyan. Ca̱h yune Pila̱to, ne chahn José quenda ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo, ihyan min che chahn ye vino chendihchero ye Dihvo vo ne, namin chahn ye nduco José, ne quenda ye ndico ndiche kilo nuneda̱n che ndindah nduco mirra ma̱n, áloes ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ndedevah ihyan chahn Dihvo vo, ne chacota̱hme ye nuneda̱n me tino, chahcotuma ye Dihvo vo nduhca̱ costumbre yahn ihyan nación yahn Israel che rihche ye tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nino na̱n che nahn ya̱h se Dihvo vo ne, va a̱ma cua̱n na̱n che va ya̱hn nda̱ta. Min va a̱ma ya̱yan ra na̱n che nde a̱ma tena̱hn metah conun ye. ");
INSERT INTO cutNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Min chaconuhn ihyan chahn Dihvo vo yahn che nino ri, te a cuana̱n ro che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ro che ndeva ndate ne, chahn María yahn ya̱n Magdala vateya̱n da̱hca, na̱n ya̱yan na̱n che quenun Dihvo vo, ne cuahn che nda̱ ye ne, a ndavi tu chahno che ndechendih chende ya̱yan me. ");
INSERT INTO cutNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tuhme cona̱hn ye rano ye na̱n che quenun Simón Pedro nduco ta̱ma ihyan apóstol, ihyan min che a̱ma din yahino Dihvo vo, ne ra̱hn ye ri ye ihyan chahn: ―Ndetenda̱h ihyan Dihvo vo chete ya̱yan, ne hua devano nuhn ti quenda ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ndeta̱hno cuahn Pedro nduco ihyan apóstol che ta̱ma me na̱n ya̱yan. ");
INSERT INTO cutNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A̱ma rano nduh che o ye cuahn ye, ate ihyan che ta̱ma me ne, tahque dito chano ye che co Pedro, ne tahque mena̱n ca nda̱ ye na̱n ya̱yan me. ");
INSERT INTO cutNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ndihchenun ye chete ya̱yan me, ne ndihchero ye tino che chahcotuma ihyan Dihvo vo che cheta̱ve min, ate hua chenda̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Numanahn min ne, nda̱ Simón Pedro, ne chenda̱ ye chete ya̱yan me. Namin ndihchero ye tino chahn che cheta̱ve min. ");
INSERT INTO cutNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ava̱ne ne, tino che chacotuma tin Dihvo vo ne, ndechetive, quendite a̱ma la̱do. ");
INSERT INTO cutNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tuhme chenda̱ ihyan apóstol che ta̱ma me chete ya̱yan, ne ndihchero ye nduhca̱ che chi, ne chitahno ye. ");
INSERT INTO cutNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ro min ne, metah conahn ihyan chahn che a ndirun na̱n Ndudo yahn Dendiohs nduhca̱ che va che ntuche Dihvo vo va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Chihno min ne, ndaconan ihyan apóstol chahn na̱n che chenun ye. ");
INSERT INTO cutNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Numanahn min ne, ndaconan María, ne chihnde ye chihto ya̱yan me, raco ye. Ura che raco ye ne, ndihchenun ye chete ya̱yan me, ");
INSERT INTO cutNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ne ndihchero ye o ángel chenun ye tino cua, vate ye na̱n che chacondihte ihyan Dihvo vo. A̱ma ye cua̱hn na̱n che chi nihno tin Dihvo vo, ne ta̱ma ye ne, cua̱hn ndiya ca̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tumerune ángel chahn ihyan: ―¿Deh cuande che reque ne? Ndahconan María, ne ra̱hn ye ri ye ángel chahn: ―Racó yahn che quenda ihyan Dihvé, ne hua devanó ti chengu ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cade chihno ra̱hn ye chemin cuahn che ndaconan ye, ne ndihchero ye Dihvo vo che nti ye min, ate hua devano ye che ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tuhme tumerune Dihvo vo ihyan, ne ra̱hn ye: ―¿Deh cuande che reque ne? ¿Duh rinohn ne? María ne, ra̱hco ye te co sa̱hn che redin cuda̱do ya̱hn nda̱ta me, ne ra̱hn ye: ―Ndete che ndih quenda ne Dihvé ne, ca̱hma ne co ne u ti chengu ne ihyan, ca̱va che cá̱hn quenguá ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―¡María! Ndaconan María, ne ra̱hn ye deva̱co yahn ye, hebreo, ri ye Dihvo vo: ―¡Raboni! ―che nahn ca̱hma Ihyan Ricuahn. ");
INSERT INTO cutNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ra̱hn Dihvo vo ri ye ihyan: ―Hua nahn tah u, te metah na̱hn na̱n va Chidá. Tahque ndah ne, cuehn ngo ihyan apóstol yáhn che ná̱hn na̱n va Chidá, ihyan min che Chida nchuhn ma̱n, Dendiohs yáhn ma̱n, Dendiohs yahn ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tuhme chahn María chego ye ihyan apóstol chahn che ndihchero ye Dihvo vo ma̱n, nduhca̱ che ra̱hn ye ri ye ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A ro min no cuahn che a chi man ne, ndi da̱ma ihyan apóstol chahn, ne neneca̱hde ye vah na̱n che chenun ye yahn che va̱h ye sa̱hn ndina̱n yahn ihyan nación yahn Israel. Ura min ne, adena̱n chenda̱ Dihvo vo vah, chandi ye menda̱hn, ne ra̱hn ye: ―Dendiohs din yahino ye nchuhn. Hua dehve ra̱hco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chihno ra̱hn Dihvo vo chemin ne, na̱hme ye ta̱h ye na̱n che nchuh cla̱vo ma̱n, ticua ye ma̱n, ihyan chahn, ne a̱ma chi yeno ye ndihchero ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ndaconan ra̱hn Dihvo vo ri ye ihyan chahn: ―Dendiohs din yahino ye nchuhn. Hua dehve ra̱hco ne. Namin ra̱hn ye ri ye ihyan chahn: ―Nduhca̱ che dechuh Chidá u ne, namin dechúh nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tuhme tivenan ye ihyan chahn, ne ra̱hn ye ri ye ihyan: ―Conun Vaco Ndah yahn Dendiohs nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ndete che nchahco ne nunde yahn adecoduhno ihyan ne, a nda̱ca ye vederenchahco. Me ndete che hua ne, a hua nda̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A̱ma ihyan apóstol chahn che duche ye Tomás, ihyan min che nta̱hco ihyan che duche ye “Cua̱hche” ne, metah ye ro che nda̱ Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Cuahn che nta̱ ye ne, ra̱hn ihyan chena̱hn chahn ri ye ihyan: ―A ntuche Dihvo vo. A ndihchero nuhn ihyan. Ate ra̱hn Tomás ri ye ihyan chahn: ―Atena̱n che terún ndutitá̱h ya̱hveta̱h ye na̱n che nchuh cla̱vo ma̱n, ticua ye na̱n che nchuh la̱nza ma̱n, tuhme cotahnó che a ntuche ye. ");
INSERT INTO cutNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chihno nine ro ne, nto da̱ma tun ihyan apóstol chahn chete a̱ma vah, ne ro min ne, nduco Tomás quenun ye min. Andahre ntude chendevah ne, chenda̱ Dihvo vo chandi ye menda̱hn, ne ra̱hn ye: ―Dendiohs din yahino ye nchuhn. Hua dehve ra̱hco ne. ");
INSERT INTO cutNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tuhme ra̱hn ye ri ye Tomás: ―Condihchero ya̱hvetá̱h, ne cueteron ndutitah. Namin cueteron ndutitah ticuá. Cuitehne, che a ntuché. Hua o ndedecadine. ");
INSERT INTO cutNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tuhme ra̱hn Tomás ri ye Dihvo vo: ―¡Ndih che Dihvé ma̱n, Dendiohs yáhn ma̱n! ");
INSERT INTO cutNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ra̱hn Dihvo vo ri ye ihyan: ―Tomás, ma̱n ne, ritehne yahn che ndihchero u. Ndah ro yahn ihyan che andahre hua rendihchero ye u, ate ritahno ye u. ");
INSERT INTO cutNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Dihvo vo Jesucristo ne, a̱ma ndeh na̱n ca vederihno din ye na̱n ihyan apóstol yahn ye che hua ndirun na̱n ca̱ca cuh. ");
INSERT INTO cutNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Me nducuahn che ndirun ne, ca̱va che cotahno nchuhn che Dihvo vo Jesucristo ne, a ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse ma̱n, a ihyan min che Da̱ya Dendiohs ma̱n, ne nduco che cotahno ne ihyan ne, ndevahn ne, cuahtenan ne vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chihno min ne, nda̱ Dihvo vo na̱n che chenun ihyan apóstol yahn ye, chihto vine yahn Galilea nino ya̱n Tiberias. Tuhca̱ chi: ");
INSERT INTO cutNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nto da̱ma ihyan apóstol chahn, Simón Pedro ma̱n, Tomás, ihyan min che nta̱hco ihyan che duche ye “Cua̱hche” ma̱n, Natanael yahn ya̱n Caná, esta̱do yahn Galilea ma̱n, nduh che o sa̱hn da̱ya Zebedéo ma̱n, nduco te o ihyan apóstol ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ra̱hn Simón Pedro ri ye ihyan chahn: ―Cá̱hn cotá̱h ya̱hca. Ra̱hn ihyan chahn ri ye ihyan: ―Namin nuhn ne, ca̱hn nuhn nduco ne. Tuhme cuahn ye, ne chahtenun ye a̱ma ba̱rco che va na̱n vine me, ate numa ya̱n min ne, nde a̱ma ya̱hca hua cheta̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cuahn che a cochi ri dave ne, nda̱ Dihvo vo chihto vine me, ate ihyan apóstol chahn ne, hua nchana̱n ye che ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tuhme ra̱hn ye ri ye ihyan chahn: ―Nchuhn sa̱hn ca̱hya, ¿a hua nda̱ca ne nde a̱ma ya̱hca ne? Ndahconan ihyan chahn, ne ra̱hn ye ri ye ihyan: ―Nde a̱ma te hua nda̱ca nuhn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ra̱hn ye ri ye ihyan chahn: ―Cotihyon nchuhn ya̱na yahn ne la̱do ta̱h cua̱co ba̱rco, ne nda̱ca ne ite. Tihca̱ din ihyan chahn, ne cuahn che ndetenda̱h ye ya̱na me ne, nde hua richa ye che a̱ma ndito ya̱hca. ");
INSERT INTO cutNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tuhme a̱ma ihyan apóstol, ihyan min che a̱ma din yahino Dihvo vo ihyan ne, ra̱hn ye ri ye Pedro: ―¡A Dihvo vo che nda̱ ye ta̱n! Ndeta̱hno che chihnevan Simón Pedro yahn Dihvo vo ne, ndonun ye tino mena̱n yahn ye, ne ca̱ nun ye va̱n nune che ca̱hn ye na̱n che va ye. ");
INSERT INTO cutNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Na̱n chenun ihyan apóstol chena̱hn chahn nduco chihto vine ne, ri tenduh a̱ma ciento metro. Chica̱hca ye ba̱rco me nde min, chihnda̱ ye ya̱na me, ndito ya̱hca. ");
INSERT INTO cutNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuahn che ndiquenda̱h ye chete ba̱rco me ne, ndihchero ye che va a̱ma va̱coya̱hn, a̱ma chenun nducoya̱hn, ne quendudo a̱ma ya̱hca na̱n nducoya̱hn me, riyuche te. Namin va pa̱n. ");
INSERT INTO cutNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ra̱hn Dihvo vo ri ye ihyan chahn: ―Te nchuhn neve ya̱hca che cade cheta̱h ne. ");
INSERT INTO cutNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Chenda̱ Simón Pedro chete ba̱rco me, ne chihnda̱ ye ya̱na me, ndetenda̱h ye va̱n nune. Chenun dema̱n ya̱hca rahte, ri a̱ma ciento quenan o raco ndiche ino te. Andahre a̱ma ya̱hn te, ate hua chendan ya̱na me. ");
INSERT INTO cutNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tuhme ra̱hn Dihvo vo ri ye ihyan chahn: ―Cochi nchuhn, cahdino ne. Ihyan apóstol chahn ne, a devano ye che Dihvo vo, ne chemin che nde hua chihquino ye tumerune ye ihyan duh ihyan ye. ");
INSERT INTO cutNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chahn nda̱ Dihvo vo, ne cheta̱h ye pa̱n me ma̱n, ya̱hca me ma̱n, ne ca̱h ye, cheh ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A ro min chi ino yune che chendihchero Dihvo vo ihyan apóstol yahn ye cuahn che a ntuche ye va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cuahn che a chihno cahdino ihyan chahn ne, tumerune Dihvo vo Pedro: ―Simón, da̱ya Jonás, ¿a tahque yahine u che co ihyan chuhn ne? Ndahconan Simón Pedro yahn ye: ―Ta̱ca̱ hua, Dihvé. Yahinó ndih. A ma̱n ne devano ne. Ra̱hn Dihvo vo ri ye ihyan: ―Tuhme ne, codin cuda̱do ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ndaconan tumerune ye ihyan, chi o yune: ―Simón, da̱ya Jonás, ¿a yahine u ne? Ndahconan Pedro yahn ye: ―Ta̱ca̱ hua, Dihvé. Yahinó ndih. A ma̱n ne devano ne. Ra̱hn Dihvo vo ri ye ihyan: ―Tuhme ne, codin cuda̱do ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ndaconan tumerune ye ihyan, chi ino yune: ―Simón, da̱ya Jonás, ¿a yahine u ne? Nducote a nde ino yune che tumerune ye Pedro ndete che a yahino ye ihyan ne, chi nda̱che ye, ne ra̱hn ye: ―Dihvé, a ma̱n ne devano ne nducuahn. A devano ne che yahinó ndih. Ra̱hn Dihvo vo ri ye ihyan: ―Tuhme ne, codin cuda̱do ihyan yáhn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Cua̱co rá̱hn rí di te cuahn che deca̱hya di ne, rendonon man tino yehn, ne rehn ti che nahn cahn. Ate cuahn che a co ndico di ne, ntah reche, ne ta̱ma ca ihyan ntihyon ye tino yehn di, ne quenda ye di na̱n che hua nahn cahn. ");
INSERT INTO cutNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Che tihca̱ ra̱hn Dihvo vo ri ye Pedro ne, conahn nduhca̱ che va che ca̱hco menda̱hn ye ihyan na̱n ntiyon yahn Dendiohs, ca̱hno se ihyan. Tuhme ra̱hn Dihvo vo ri ye Pedro: ―¡Cuindoque u! ");
INSERT INTO cutNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ura che cuahn ye ne, ndaconan Pedro, ne ndihchero ye che cuahn nduco ihyan apóstol min che a̱ma din yahino Dihvo vo, ihyan min che da̱ma chihnde ye nduco Dihvo vo cuahn che cheh vino ye me, ne tumerune ye duh che ndihcue ndeh ihyan. ");
INSERT INTO cutNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tuhme tumerune Pedro Dihvo vo: ―Dihvé, me ihyan tih ne, ¿deh co yahn ye ne? ");
INSERT INTO cutNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ndahconan Dihvo vo, ne ra̱hn ye ri ye ihyan: ―Ndete che u náhn che conan ye iyehnse nde ro che ndaconan chí ne, di ne, hua cuande yehn chemin. Cuindoque u. ");
INSERT INTO cutNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Chemin che chihnde ndudo va̱n dihno vo che ihyan apóstol min ne, hua nda̱ ro che coh ye. Ate Dihvo vo ne, ndiyu che ra̱hn ye che hua coh ihyan min, te ra̱hn ye te ndete che nahn ye che conan ihyan min nde ro che chi tun ye ne, hua cuande yahn Pedro chemin. ");
INSERT INTO cutNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A ihyan apóstol min che dirun ye ca̱ca cuh, ne a devano vo che nducuahn che dirun ye ne, cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A̱ma ndeh na̱n ca dehtenduh che din Dihvo vo Jesucristo. Ndete che corun queri a̱ma na̱n dehtenduh che din ye ne, ra̱hcó te cuto libro numachahte iyehnse, nde hua tuno na̱n che conun. Tihca̱ chi.");
INSERT INTO cutNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ndih Teófilo che yahinó ndih, na̱n ca̱ca che dendáh mena̱n ne, a dirún a̱ma ndeh na̱n dehtenduh che din Dihvo vo Jesucristo ma̱n, che chicuahn ye ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","nde nda̱ ro che cona̱hn ye vahchetero. Cuahn che ametah na̱hn ye vahchetero ne, numacuahn vederihquentiyon yahn Vaco Ndah yahn Dendiohs, ca̱h ye ntiyon che va che din ihyan apóstol yahn ye che a tenda̱h nun ye. ");
INSERT INTO cutNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Adive che chihno se Dihvo vo ne, ntuche ye, ne ma̱n ye nda̱ ye ndeh yune, chinduco ye ihyan chahn chete che o raco ro. Nduco chemin ne, chenahn ihyan chahn te cua̱co che quenduche ye, ne ca̱h cuande ye ihyan chahn yahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Cuahn che nduco ca ye ihyan apóstol chahn ne, ra̱hn ye ri ye ihyan: ―Hua nda̱ca nchuhn ya̱n Jerusalén. Conan rino ne nde nda̱ ro che conahn che ndihco ca̱de Dendiohs Chida che co Vaco Ndah yahn ye. A yahn chemin che renté nduco ne nde ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Cua̱co te Jua̱n ne, chehdenune ye ihyan, ate nchuhn ne, cuihno neve ro ne, conun Vaco Ndah yahn Dendiohs nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ta̱hn min cuahn che ndida̱ma ihyan chahn ne, tumerune ye Dihvo vo: ―Dihve nuhn, ¿a ma̱n ro cuh che nda̱hco ca̱de ne che ca̱hcantiyon ma̱n nación yahn Israel ne? ");
INSERT INTO cutNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ndahconan ye, ne ra̱hn ye ri ye ihyan chahn: ―Hua cuande yahn nchuhn che cadino ne deh ro, o deh ura che conahn che ma̱n Dendiohs Chida a ndihco ca̱de ye. ");
INSERT INTO cutNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ate chu che cuande yahn ne. Cuahn che co Vaco Ndah yahn Dendiohs, conun nchuhn ne, conan cuma ne vederihquentiyon. Tuhme cua̱cotuhn ne ndudo yáhn ya̱n Jerusalén ma̱n, numacuahn esta̱do yahn Judea ma̱n, nación yahn Samaria ma̱n, nde numachahte iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chihno ra̱hn Dihvo vo chemin ne, nahn min che rendihchero ihyan chahn ne, conda̱ ye vahchetero. Tuhme quendihco a̱ma man, ne chehna̱n ihyan chahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Numanahn che vatendi ca ye, rihno ye che conda̱ Dihvo vo na̱n ro ne, adena̱n nda̱ o ángel, chenun ye tino cua. ");
INSERT INTO cutNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ra̱hn ye ri ye ihyan chahn: ―Nchuhn, sa̱hn Galilea, ¿dehco che rihno cua̱hn na̱n ro ne? Ma̱n Dihvo vo che nda̱ca ye va̱n nchuhn, din Dendiohs che cona̱hn ye vahchetero ne, nduhca̱ che ndihchero ne che cona̱hn ye, tihca̱ ndaconan chi tun ye. ");
INSERT INTO cutNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Chihno min ne, nda̱ca ihyan chahn min na̱n che duche Cuete Olivo, ne cona̱hn ye ya̱n Jerusalén. Nino yune min, nuhneva che nihnde ca̱de na̱n ley yahn Dendiohs che co ca̱ca ihyan ro che rahte tuhno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cuahn che nta̱ ihyan chahn viya̱n me ne, chenda̱ ye a̱ma vah, cocha ye na̱n o cuahto, cua̱rto na̱n che rahtenun ye. Va̱n ihyan chahn ne, nduco Pedro ma̱n, Jacobo ma̱n, Jua̱n ma̱n, Andrés ma̱n, Felipe ma̱n, Tomás ma̱n, Bartolomé ma̱n, Mateo ma̱n, Jacobo, che da̱ya Alfeo ma̱n, Simón Zelote ma̱n, Judas, che dihno Jacobo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ro ro ne, rendo da̱ma nducoya̱ca ihyan chahn nduco dihno Dihvo vo ma̱n, chaco ye, María ma̱n, ya̱hn ca ihyan nda̱hta ma̱n, reva̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A̱ma ro min ne, chandi Pedro na̱n ihyan che ritahno ye Dihvo vo, che ri ye tenduh a̱ma ciento quenan ndico, ne cahndudo ye: ");
INSERT INTO cutNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nchuhn dihnó, a va che conahn ndudo che din Vaco Ndah yahn Dendiohs che dirun David yahn Judas, che quenda̱hna̱n se yahn sa̱hn che din se preso Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Sa̱hn min ne, chi cuande se va̱n nuhn, din se ntiyon nduco nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tume che nda̱ca se yahn nunde yahn se ne, ca a̱ma ndi ya̱hn. Chihno min ne, chenda̱h se, denderen se, ne chendan se, chihno chetuhn rehte se ndiya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Cuahn che checadino ihyan ya̱n Jerusalén yahn chemin ne, chaconahn ye che duche ya̱hn min, Acéldama, deva̱co yahn ye, che nahn ca̱hma Ya̱hn Yahn Yun. ");
INSERT INTO cutNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","A ndirun na̱n libro yahn Salmo tuhca̱: Cuhnde ma̱n va̱co se. Nde a̱ma ihyan hua conun ye min. Namin a ndirun: Conan ta̱ma ihyan menun se, ndonda̱ ta̱h ye ntiyon che quenan cuma se. ");
INSERT INTO cutNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Chemin che a̱ma cha ihyan che namin chinduco ye Dihvo vo numacuahn ro che quechica ye, ");
INSERT INTO cutNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","nde ro che chehdenune Jua̱n ihyan, nde nda̱ ro che din Dendiohs che cona̱hn ye vahchetero ne, va che co cuande ye va̱n nuhn, ca̱va che cua̱cotuhn ye ndudo yahn che a ntuche Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ntihyon ya̱n ihyan chahn o ihyan. A̱ma ye ne, José Barsabás, che namin duche ye Justo, ne ta̱ma ye ne, Matías. ");
INSERT INTO cutNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tuhme cova̱h nducoya̱ca ye: ―Dihve nuhn, a ndih che rendihche ne chedave yahn nducoya̱ca ihyan. Cona̱hma ne nuhn cha ihyan che o chuhn, nahn ne ");
INSERT INTO cutNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","che co ye apóstol, conan ye menun Judas, din ye ntiyon che denda se, din nunde yahn se, te a cuahn se na̱n che redin yahn che conun se. ");
INSERT INTO cutNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tuhme din ihyan chahn sortear, ne quenda̱h yahn Matías che co ye apóstol, co cuande ye va̱n ihyan che ndichia̱ma chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cuahn che nda̱ vihco Pentecostés ne, nto da̱ma ihyan apóstol nduco nducoya̱ca ihyan chahn che ritahno ye Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Adena̱n chahco chine na̱n ro nduhca̱ yuhne ta̱n che a̱ma rano, ne chito chete vah na̱n che chenun ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ndihchero ye che deca̱ ro ruchiya̱hn ro chetuhn, ne chiya tin queri a̱ma ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tuhme quenun Vaco Ndah yahn Dendiohs nducoya̱ca ihyan chahn, din che ra̱hn ye ta̱ma te o na̱n deva̱co. ");
INSERT INTO cutNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A̱ma ya̱hn ihyan nda̱ta yahn Israel che redinahn ye che nihnde ca̱de na̱n ley yahn Dendiohs ne, chica ye numachahte iyehnse, ne chenan ye ya̱n Jerusalén ro min. ");
INSERT INTO cutNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cuahn che chihnevan ye che chine ne, ndo da̱ma ye, ne a̱ma rahn ino ye, te queri a̱ma ye ne, chihnevan ye deva̱co yahn ma̱n ye che rente ihyan che chenun ye chete vah. ");
INSERT INTO cutNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","A̱ma rahn ino ihyan chahn, ne ra̱hn ye va̱n ma̱n ye nduco vih: ―¿A ndiyu ihyan Galilea nducoya̱ca ihyan sih che tihca̱ rente ye? ");
INSERT INTO cutNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ta̱ca̱ che rente ye deva̱co yahn queri a̱ma vo che rente vo ya̱n va̱co vo? ");
INSERT INTO cutNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Va̱n nducoya̱co vo ne, nduco ihyan ya̱hn yahn Partia ma̱n, Media ma̱n, Elam ma̱n, Mesopotamia ma̱n, Judea ma̱n, Capadocia ma̱n, Ponto ma̱n, Asia ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia ma̱n, Panfilia ma̱n, Egipto ma̱n, Africa che nde tahque yahn ca va che co ya̱n Cirene ma̱n. Namin nduco ihyan ya̱n Roma ma̱n. Na̱hn vo ne, ihyan nación yahn Israel, ne na̱hn vo ne, ihyan ta̱ma nación che ritahno vo da̱ma nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Namin nduco ihyan ya̱hn yahn Creta ma̱n, Arabia ma̱n. Rahndudo ihyan sih ndudo yahn vederihno che redin Dendiohs, rihnevan queri a̱ma vo deva̱co yahn ma̱n vo. ");
INSERT INTO cutNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A̱ma rahn ino nducoya̱ca ye, ne tumerune vih ye: ―¿Deh conahn che tihca̱ ri ne? ");
INSERT INTO cutNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ate na̱hn ihyan chahn ne, duche rino ye, ne ra̱hn ye: ―Coh ihyan sih, ne chemin che tihca̱ redin ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Tuhme necuandi Pedro nduco ihyan apóstol che ndichia̱ma chahn, ne cahndudo ye: ―Nchuhn, ihyan nación yahn Israel nduco nducoya̱ca ne che vate ne ya̱n Jerusalén, cua cuande ne ma̱n, cuihcovan ndah ne che ca̱hmá ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hua dehve coh nuhn nduhca̱ che ra̱hn nchuhn, te meniyon ne, coma̱n rahco nun vatiya̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Che rendihchero nchuhn ne, a yahn chemin che dirun ihyan profeta Joel tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ra̱hn Dendiohs: “Cuahn che a nahn tuno ro che conahn che a ndihco ca̱dé ne, dechúh Vacó, ca̱va che conun ihyan iyehnse. Da̱ya nchuhn ne, cuahndudo ye ndudo yáhn ma̱n, ihyan deca̱hya ne, ndihchero ye vederihno va̱n ya̱hnde yahn ye ma̱n, ihyan ndico ne, ca̱hno ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ro min ne, dechúh Vacó ca̱va che conun ihyan che redin ye ntiyon yáhn, ne cuahndudo ye ndudo yáhn. ");
INSERT INTO cutNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Na̱n ro ma̱n, ndiya̱hn ma̱n, dín vederihno, ne cuhnde ro yun ma̱n, ya̱hn ma̱n, ya̱hme ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","U che Dihve nducoya̱ca ihyan ne, cuahn che ametah nda̱ ro che techeca̱dé ne, na̱n ya̱hn ne, co man, ne iyo ne, ndo nduhca̱ yun. Ro min ne, ro che a̱ma yudo, ro che ca̱hco ró che a̱ma chahte vederihquentiyon yáhn. ");
INSERT INTO cutNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tuhme nducoya̱ca ihyan che cuah ye u che Dihve ye ne, ndedeváhn ihyan.” ");
INSERT INTO cutNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Nchuhn, ihyan nación yahn Israel, cuihcovan ndah ne che ca̱hmá: Dendiohs ne, dechuh ye Jesús yahn ya̱n Nazaret va̱n nchuhn, ne ma̱n nchuhn devano cua̱co ne, te numacuahn vederihquentiyon yahn Dendiohs, din ye vederihno, ndihchero ne. ");
INSERT INTO cutNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Cuahn che nda̱ ye ta̱h nchuhn ne, nduhca̱ che a ndihco ca̱de Dendiohs nde ro mena̱n ne, din nchuhn preso ihyan, neca̱h ne ihyan ta̱h sa̱hn nunde. Nahn ya̱h se ihyan, ne chihno se ihyan nduhca̱ che nahn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ate ndedetuhche Dendiohs ihyan, chehnevi ye ihyan ta̱h vederih, te hua co che nda̱hco ndiya vederih ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Hua co che conan ye ta̱h vederih cuahn da̱ma, te a yahn ye che dirun David tuhca̱: Dihvé, cuahn da̱ma rendihché ndih che nduco ne u. Quenan ne la̱do ta̱h cua̱có, ca̱va che hua dihya nun inó co. ");
INSERT INTO cutNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Chemin che chi yenó, ne ndevá yavena̱n ne numacuahn vedeyeno. Recá̱h vedechahtino chedave yáhn, ");
INSERT INTO cutNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","te u che yahino ne ne, hua ca̱hcoma̱n ne u va̱n tena̱hn, nde hua cuahnecun ne che conún chete ya̱yan cuahn da̱ma, cha̱ u. ");
INSERT INTO cutNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tihyon yune ne u nduhca̱ che nda̱hca̱ conán na̱n ne. A̱ma yenó yahn che nduco ne u. ");
INSERT INTO cutNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Nchuhn dihnó, cua̱co te chih indihte yuhn vo David ma̱n, che chehche ye ma̱n, che va ya̱yan yahn ye nde meniyon ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ihyan min ne, profeta ye, ne numacuahn vedeyudo ne, ca̱h Dendiohs ndudo yahn ye che va̱n nda̱ta yahn ye ne, quenda̱h ihyan min che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse, nuhnde ta̱h ye vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ne, anduhneca̱ ndete che ndihchero ye che ntuche ihyan min che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse, ne chemin che dirun ye che hua conun ihyan min va̱n tena̱hn ma̱n, che hua cha̱ ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ma̱n ne, Dendiohs ne, a ndedetuhche ye Dihvo vo Jesucristo, ne nuhn ne, devano cua̱co nuhn yahn. ");
INSERT INTO cutNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nducote ndedetuhche Dendiohs Chida ihyan min numacuahn vederihquentiyon yahn ye ma̱n, nducote dinahn ye ndudo che neca̱h ye che dechuh ye Vaco Ndah yahn ye ma̱n ne, chemin che redin ihyan min vederihno che rendihchero nchuhn ma̱n, rihnevan ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A yahn ihyan min che nda̱ ye vahchetero che dirun David tuhca̱, ndiyu yahn ma̱n ye: Dihve Dendiohs ne, ra̱hn ye ri ye Dihvé: “Cuihnde muhn la̱do ta̱h cua̱có, ");
INSERT INTO cutNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","numanahn che nda̱hco ndiyá ihyan che hua ri rendihche ye di, ndeva ye yavenan.” ");
INSERT INTO cutNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Nducote tihca̱ ne, codevano cua̱co nducoya̱ca ihyan nación yahn Israel te a Jesús, ihyan min che nahn ya̱h nchuhn ne, nda̱hco Dendiohs vederihquentiyon ta̱h ye che ndedevahn ye ihyan iyehnse ma̱n, che co ye Dihve nducoya̱ca ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuahn che chihnevan ihyan chahn che tihca̱ cahndudo Pedro ne, a̱ma chi ra̱n ye, ne tumerune ye Pedro nduco ihyan apóstol chena̱hn chahn: ―Dihno nuhn, ¿deh va che din nuhn ma̱n ne? ");
INSERT INTO cutNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ndahconan Pedro, ne ra̱hn ye ri ye ihyan: ―Queri a̱ma nchuhn, cuento ino ne nunde yahn ne, ne cuah ne Dihvo vo Jesucristo, cuedenune ne, ca̱va che nchahco Dendiohs nunde yahn ne, ne din ye che conun Vaco Ndah yahn ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tihca̱, te a neca̱h Dihvo vo Dendiohs ndudo min ca̱va nducoya̱ca ihyan che tenda̱hnun ye, nchuhn ma̱n, da̱ya ne ma̱n, nda̱ta yahn ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Cuahn che chihno cahndudo Pedro ndudo cuh nduco ndeh na̱n ca ndudo che tuhchan ne, ya̱hve ye ihyan chahn, ne ra̱hn ye: ―Cuendedevahn ne nchuhn va̱n ihyan nunde che vate ye ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tuhme ihyan che nevahnecun ye ndudo yahn ye ne, chedenune ye, ne ro min ne, tenduh ino mil ihyan chitahno ye Dihvo vo, chinduco ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nducoya̱ca ye ne, riquendi ye che ricuahn ihyan apóstol chahn, ne rendo da̱ma ye nduco vih ma̱n, reva̱h ye ma̱n, rendeh ye pa̱n nduhca̱ che chihquentiyon Dihvo vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A̱ma rahn ino nducoya̱ca ihyan ya̱n, te a̱ma redin ihyan apóstol chahn vederihno. ");
INSERT INTO cutNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nducoya̱ca ihyan che ritahno ye Dihvo vo ne, a̱ma no vederendedecadino yahn ye nduco vih, ne rihco menda̱hn ye dehtenduh yahn ye ca̱va nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Cuahn che va vedereta̱hn yahn combiero yahn ye ne, rendihcue ye ya̱hn yahn ye ma̱n, dehtenduh yahn ye ma̱n, ne reca̱h ye tume me queri a̱ma ihyan chahn tunoca va vedereta̱hn yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ro ro rendo da̱ma ye ya̱co chahte, ne ndeva̱co ye ne, reh ye nduco vih, ne rendeh ye pa̱n nduhca̱ che chihquentiyon Dihvo vo. Chenan cuma ye vedeyeno ma̱n, vedenecun ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rendeva ye yavena̱n Dendiohs numacuahn vedeyeno, ne nda̱hca̱ chenan ye na̱n nducoya̱ca ihyan. Ro ro ne, rendedevahn Dihvo vo Dendiohs ihyan, rinduco ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","A̱ma ro na̱n rahco ino a chino, ura che reva̱h ihyan ne, cuahn Pedro nduco Jua̱n ya̱co chahte. ");
INSERT INTO cutNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A̱ma chende ya̱co me ne, duche Hermosa, ne a̱ma sa̱hn che neneva doh ca̱h se nde ro che chihndeya̱n se ne, va se min. Ro ro riquenda ihyan sa̱hn, ne min rihco ye sa̱hn ca̱va che ca̱ca se ihyan che renda̱ ye ya̱co che din ye vedeva̱hino nduco se. ");
INSERT INTO cutNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cuahn che ndihchero se Pedro nduco Jua̱n che nda̱ ye chende ya̱co me ne, chica se che din ye vedeva̱hino nduco se. ");
INSERT INTO cutNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ndihchero ihyan chahn sa̱hn, ne ra̱hn Pedro ri ye sa̱hn: ―Condihchero nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Sa̱hn min ne, va ya̱n se, rendihchero se ihyan, te ra̱hco se te ca̱h ye tume sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ate ra̱hn Pedro ri ye sa̱hn: ―Metah diya̱hngua̱n yáhn, nde hua ne diya̱hngua, ate co conán di. Nduco vederihquentiyon yahn Jesucristo yahn ya̱n Nazaret, cuenecuen, ne cuique. ");
INSERT INTO cutNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Cheta̱h Pedro ta̱h cua̱co se, ndedecuan ye sa̱hn, ne ndeta̱hno nuhnde ca̱va da̱ndoca̱h se, ne ndo cua̱co ca̱h se. ");
INSERT INTO cutNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tuhme nde tuno ca̱ ya̱co se, cana̱n rica se. Chenda̱ se chete ya̱co nduco ihyan chahn, ra̱ ya̱co se che yeno se ma̱n, rendeva se yavena̱n Dendiohs numacuahn vedeyeno ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nducoya̱ca ihyan che chenun ye min ne, ndihche ye che rica se ma̱n, chihnevan ye che rendeva se yavena̱n Dendiohs ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ne a̱ma rahn ino ye ma̱n, redihya ye ri ma̱n, yahn vederihno me, te a rendihche ye te a sa̱hn min che rihnde se chende ya̱co Hermosa, rica se che din ihyan vedeva̱hino nduco se. ");
INSERT INTO cutNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sa̱hn che a ndoyahn me ne, nda ca se ta̱h Pedro ma̱n, Jua̱n ma̱n, chenun ye ma̱n corredor che duche Salomón. Nducote a̱ma rahn ino ihyan che chenun ye chete ya̱co ne, aderano ye, ndo da̱ma ye min. ");
INSERT INTO cutNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cuahn che ndihchero Pedro che a̱ma chito ihyan min ne, cahndudo ye: ―Nchuhn, ihyan nación yahn Israel, ¿dehco che a̱ma rahn ino ne? ¿Dehco che a̱ma rendihchero ne nuhn? ¿A ra̱hco ne che nduco vederihquentiyon yahn ma̱n nuhn, o che a̱ma ndah ihyan nuhn, din nuhn che ndoyahn sa̱hnguh? ");
INSERT INTO cutNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Hua, te Dendiohs yahn indihte yuhn vo Abraham ma̱n, Isaac ma̱n, Jacob ma̱n ne, a ihyan min che din ye vederihno cuh, ca̱va che ndeva ye yavena̱n da̱ya ye Jesucristo che neca̱h nchuhn ta̱h Pila̱to. Pila̱to ne, nahn nta̱hte ye ihyan, ate nchuhn ne, hua cahnecun ne. ");
INSERT INTO cutNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ndotenan che ca̱ca nchuhn che nta̱hte ye ihyan min che ndah ye na̱n Dendiohs ne, chica ne che nta̱hte ye a̱ma sa̱hn rihno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tihca̱ chihno nchuhn ihyan min che quenan cuma ye vederihquentiyon che din ye che cuahtenan ihyan vahchetero numacuahn ro. Ate Dendiohs ne, ndedetuhche ye ihyan va̱n tena̱hn, ne yahn chemin ne, nuhn devano cua̱co nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nduco vederihquentiyon yahn Dihvo vo Jesucristo ne, ndoyahn sa̱hnguh che a ntihche nchuhn sa̱hn, te chitahno se ihyan. Chitahno se ihyan, ne chemin che ndoyahn se nduhca̱ che rendihchero ne. ");
INSERT INTO cutNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nchuhn dihno, u devanó te va̱n vedetundo yahn ne nduco ihyan ndina̱n yahn ne, chihno ne Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ate nde ro mena̱n me ne, a ndihco ca̱de Dendiohs che va che chuhrihn ihyan min yahn ye che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse. Yahn chemin ne, a dirun ihyan profeta, ne tihca̱ chinahn. ");
INSERT INTO cutNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ma̱n ne, cuento ino nchuhn nunde yahn ne ma̱n, cuah ne Dendiohs ma̱n, ca̱va che nchahco ye yahn ne ma̱n, din ye che cuahte dihn chedave yahn ne ma̱n, neca̱h ya̱n ye chedave yahn ne ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Va che dechuh tun ye Dihvo vo Jesucristo, ihyan min che a va ca̱de che chi ye, ndedevahn ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ate ma̱n ro cuh ne, va che conan ca ye vahchetero nde nda̱ ro che cuihno nda̱hco ca̱de Dendiohs nducuahn, nduhca̱ che ca̱h ye ndudo yahn ye, dirun ihyan profeta ndah yahn ye a ra̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","A chinahn nduhca̱ che ra̱hn Moisés ri ye indihte yuhn vo tuhca̱: “Dihvo vo Dendiohs ne, tenda̱h nun ye a̱ma ihyan profeta va̱n nda̱ta yahn nchuhn nduhca̱ che tenda̱h nun ye u. Codinahn ne nducuahn che ca̱hma ihyan min, ");
INSERT INTO cutNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","te nducoya̱ca ihyan che hua dinahn ye che ca̱hma ye ne, conda ye va̱n ihyan nación yuhn vo.” ");
INSERT INTO cutNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Nducoya̱ca ihyan profeta, nde Samuel, nde nducoya̱ca ye che chahte ye adive ne, namin dirun ye yahn ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A ca̱va nchuhn che dirun ihyan chahn, ne che ndah yahn ne che nte ca̱de Dendiohs nduco ihyan ndico yuhn vo nduhca̱ che ca̱h ye ndudo yahn ye Abraham tuhca̱: “Ca̱va ihyan, nda̱ta yehn, dín che ndah nduco nducoya̱ca ihyan iyehnse.” ");
INSERT INTO cutNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Cuahn che a ndedetuhche Dendiohs Da̱ya ye ne, mena̱n vih ca dechuh ye ihyan va̱n nchuhn, ca̱va che din ye che ndah nduco ne, ne ca̱hcoma̱n ne nunde yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nde ametah cuihno cuahndudo Pedro ma̱n, Jua̱n ma̱n, cuahn che nda̱ chidocuya̱n ndina̱n chahn ma̱n, sa̱hn saduceo ma̱n, sa̱hn ndina̱n yahn policía che redin se cuda̱do ya̱co ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yudo ri yahn sa̱hn chahn yahn che Pedro nduco Jua̱n ne, ricuahn ye ihyan ya̱n che a ntuche Dihvo vo Jesucristo, ne chemin che va che ntuche tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tuhme quenda se ihyan chahn, chih se ihyan va̱coya̱hn nde ta̱ma ro me, te ura min ne, a chino. ");
INSERT INTO cutNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ate ya̱hn ihyan che chihnevan ye che ricuahn ihyan chahn ne, chitahno ye Dihvo vo Jesucristo, ne ihyan chahn nduco ihyan che a chitahno ye Dihvo vo nde ro mena̱n me ne, ri ye tenduh uhn mil che dema̱n ihyan cha̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ta̱ma ro me ne, min ya̱n Jerusalén ndo da̱ma nducoya̱ca sa̱hn ndina̱n yahn nación yahn Israel ma̱n, sa̱hn intiyahn ma̱n, sa̱hn devano ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Namin nduco Anás, chidocuya̱n che tahque ndina̱n ma̱n, Caifás ma̱n, Jua̱n ma̱n, Alejandro ma̱n, nducoya̱ca ihyan che nda̱ta yahn chidocuya̱n ndina̱n chahn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tuhme tahve sa̱hn chahn che ngua Pedro ma̱n, Jua̱n ma̱n, chahtendi ye menda̱hn, ne chiquerune se ihyan: ―¿Duh te nchuhn vederihquentiyon che redin ne dehtenduh che tihchan ne? ");
INSERT INTO cutNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tuhme numacuahn vederihquentiyon yahn Vaco Ndah yahn Dendiohs, ndahconan Pedro, ne ra̱hn ye ri ye sa̱hn: ―Nchuhn, sa̱hn ndina̱n ma̱n, sa̱hn intiyahn yahn nación yuhn vo ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma̱n che riquerune ne yahn vederihno che chinahn nduco sa̱hnguh che nenevadoh ca̱h se ma̱n, ta̱ca̱ chi che ndoyahn se ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ca̱hma nuhn na̱n nchuhn ca̱va che codevano nducoya̱ca ihyan nación yuhn vo. Sa̱hnguh che nti se muhn na̱n nducoya̱ca nchuhn ne, a ntoyahn se nduco vederihquentiyon yahn Jesucristo yahn ya̱n Nazaret. A ihyan min che nahn ya̱h nchuhn, ate Dendiohs ne, ndedetuhche ye ihyan va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nduhca̱ sa̱hn rahto vah che chaconda̱h se tu che tahque cochihve yahn se ne, tihchan nchuhn, te hua nevahnecun ne ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nde a̱ma ihyan hua co ndedevahn ye uvo, te atena̱n ihyan min che va ta̱h ye vederihquentiyon che ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Cuahn che ndihche sa̱hn ndina̱n chahn che hua va̱h Pedro ma̱n, Jua̱n ma̱n, che rente ye numa ino ye ne, nducote a devano se te ihyan chahn ne, nda̱ta yahn ihyan cheva̱h ihyan ma̱n, hua devano ye ca̱ca ma̱n ne, a̱ma cuahn ino se, ne tumacadino se che chinduco ye Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ava̱ne ne, sa̱hn che ndoyahn me ne, min nti se nduco ihyan chahn. Chemin che nde na̱n che ca̱hma sa̱hn ndina̱n chahn metah. ");
INSERT INTO cutNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tuhme chihquentiyon se che ndiquenda̱h vah ihyan chahn, numanahn che nte ca̱de se nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ra̱hn se: ―¿Deh din vo nduco sa̱hn chuhn ne?, te nducoya̱ca ihyan che vate ye ya̱n Jerusalén, a devano ye yahn vederihno me, ne hua co ca̱hma vo che hua cua̱co. ");
INSERT INTO cutNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma̱n ne, ca̱va che hua quendi cotuhn ndudo yahn vederihno me ne, nahn dihyo vo sa̱hn, ne ametah quendi se ca̱hma se nduco nde a̱ma ihyan yahn vederihquentiyon yahn Jesús min. ");
INSERT INTO cutNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tuhme cah sa̱hn ndina̱n chahn ihyan, ne chihquentiyon se che ametah quendi ye cacuahn ye vederihquentiyon yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ate ndahconan ihyan chahn, ne ra̱hn ye ri ye sa̱hn: ―Condedecadino ma̱n nchuhn. Na̱n Dendiohs ne, ¿a nda̱hca̱ che hua dinahn nuhn che rihquentiyon ye, ca̱va che dinahn nuhn yahn ne ne? ");
INSERT INTO cutNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Va che dinahn nuhn yahn Dendiohs, te yahn nducuahn che ndihchero nuhn ma̱n, chihnevan nuhn ma̱n ne, va che ca̱hma nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tuhme nahn dihya sa̱hn ndina̱n chahn ihyan, ne ndedechuh se ihyan, cona̱hn ye. Hua chihquino se din se castigo ihyan yahn che rendeva nducoya̱ca ihyan ya̱n yavena̱n Dendiohs yahn vederihno che chinahn. ");
INSERT INTO cutNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sa̱hn che chinahn vederihno nduco me, ndoyahn se ne, a ri se nchuh o raco nduyo. ");
INSERT INTO cutNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro nduco Jua̱n ne, cuahn che nda̱ca ye na̱n chidocuya̱n ndina̱n chahn ma̱n, sa̱hn intiyahn chahn ma̱n ne, cona̱hn ye na̱n che chenun combiero yahn ye, ne neca̱h cuande ye ihyan nducuahn che ra̱hn se ri se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chihno neca̱h cuande ye ihyan ne, cova̱h nducoya̱ca ye tuhca̱: ―Dihve nuhn, Dendiohs, ndih che dendah ne na̱n ro ma̱n, iyehnse ma̱n, nuniya̱hn ma̱n, nducuahn che va ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Numacuahn vederihquentiyon yahn Vaco Ndah yahn ne ne, ca̱h cuande ne ihyan yahn ne David, ne dirun ye tuhca̱: ¿Dehco che rendedecadino ihyan nación yahn Israel yahn dehtenduh che hua cochihve? ¿Dehco che renecuan ihyan nación chena̱hn, ri ta̱n ye nduco Dendiohs? ");
INSERT INTO cutNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nducoya̱ca rey che vate ye iyehnse ne, necuan ye, ne nducoya̱ca ihyan che rihquentiyon ye ne, ndo da̱ma ye, ca̱va che cuhma ye nduco Dihvo vo Dendiohs ma̱n, ihyan yahn ye che a va ca̱de che chi ye, ndedevahn ye ihyan iyehnse ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tihca̱ chinahn, te muhn ya̱n cuh ne, ndo da̱ma Herodes ma̱n, Poncio Pila̱to ma̱n, sa̱hn nación yahn Israel ma̱n, sa̱hn nación chena̱hn ma̱n, ca̱va che chihno se Da̱ya Ndah yahn ne, Jesucristo, ihyan min che nda̱hco ne vederihquentiyon ta̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Nduco tihca̱ chenun ca̱h nducuahn che a ndihco ca̱de ne. ");
INSERT INTO cutNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Dihve nuhn, ma̱n ne, condihche ne nduhca̱ che renahn dihya sa̱hn sih nuhn. Cuete ne vedechahtino nuhn ca̱va che numa ino nuhn cuahndudo nuhn Ndudo yahn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Numacuahn vederihquentiyon yahn ne ne, codin ne che ndoyahn ihyan cah ma̱n, che cuhnde ro vederihno ma̱n, che cuande yahn Da̱ya Ndah yahn ne, Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuahn che chihno cova̱h ihyan chahn ne, nuhn ya̱hn na̱n che chenun ye. Vaco Ndah yahn Dendiohs ne, quenun nducoya̱ca ye, ne rahndudo ye Ndudo yahn Dendiohs numa ino ye. ");
INSERT INTO cutNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nducoya̱ca ihyan che ritahno ye Dihvo vo Jesucristo ne, a̱ma no vederendedecadino yahn ye nduco vih. Nde a̱ma ye ne, hua rihco vih ye dehtenduh yahn ye, te ndihco menda̱hn ye ca̱va nducoya̱ca ye. ");
INSERT INTO cutNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Numacuahn vederihquentiyon yahn Dendiohs rahndudo ihyan apóstol chahn che ntuche Dihvo vo Jesucristo, ne a̱ma rinan Dendiohs nducoya̱ca ihyan chahn, redin ye che chenan cuma ye vedeyahino nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nde a̱ma ihyan chahn ne, hua rindanan dehtenduh che nahn ye, te ihyan che va ya̱hn yahn ye ma̱n, o vah yahn ye ma̱n ne, rendihcue ye, ne riquenda ye tume me, ");
INSERT INTO cutNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","reneca̱h ye ihyan apóstol chahn ca̱va che reca̱h ihyan chahn queri a̱ma ihyan tunoca vedereta̱hn yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Tihca̱ din a̱ma ihyan, ya̱hn yahn Chipre, che duche ye José, nda̱ta yahn chidocuya̱n Levita. Ihyan apóstol ne, chaconahn ye che duche ye Bernabé, che nahn ca̱hma ihyan che reneca̱h ya̱n ye chedave yahn ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ihyan min ne, ndihcue ye a̱ma ya̱hn yahn ye, ne neca̱h ye tume me ihyan apóstol chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ate hua tihca̱ din a̱ma sa̱hn che duche se Ananías nduco nda̱hta yahn se Safira. Namin ndihcue se a̱ma ya̱hn yahn se, ");
INSERT INTO cutNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ne chihco vih se tah tume yahn. Quenda se tume chena̱hn me, din ca̱ se che a nducuahn, ne neca̱h se ihyan apóstol chahn. Ta̱hn nda̱hta yahn se ne, a devano te chemin. ");
INSERT INTO cutNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Tuhme ra̱hn Pedro ri ye sa̱hn: ―Ananías, ¿dehco che dinehn che chinun chundah di ne?, te nahn cahncheh Vaco Ndah yahn Dendiohs, chihco vih tah tume yahn ya̱hn che ndihcue. ");
INSERT INTO cutNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nde a̱ma ihyan hua din ye fuerza di ca̱va che ndihcue ya̱hn yehn, nde huane che checo tume che ca yahn muhn. ¿Dehco che tihca̱ ndedecadine?, te nunde yahn vederihncheh yehn ne, quendihque na̱n Dendiohs, ndiyu dema̱n na̱n ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cuahn che chihnevan Ananías ndudo cuh ne, chenda̱h se, ne chih se. Nducoya̱ca ihyan che checadino ye che tihca̱ chi ne, a̱ma dihya ye chi. ");
INSERT INTO cutNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nda̱ a̱ma o sa̱hn deca̱hya, ne chahcotuma se tino sa̱hn, quenda se sa̱hn, chihche se sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chihno tenduh ino ura ne, nda̱ ta̱hn nda̱hta me, nde hua devano te deh che chi. ");
INSERT INTO cutNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tumerune Pedro ta̱hn: ―¿A cua̱co che tuhva tume ca nchuhn yahn ya̱hn yahn ne ne? Ndahconan te: ―Cua̱co. Nduco tihva. ");
INSERT INTO cutNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tuhme ra̱hn Pedro ri ye ta̱hn: ―¿Dehco che tihca̱ din nchuhn, che ntuhno ne ca̱va che tumarande ne Vaco Ndah yahn Dihvo vo Dendiohs? A ta̱n cuenchi sa̱hn che chahn se chihche se inchahn. Ma̱n ne, namin quenda se di, cuhche se di. ");
INSERT INTO cutNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ndeta̱hno chenda̱h ta̱hn min, ne chih te na̱n Pedro. Cuahn che nta̱ sa̱hn deca̱hya chahn ne, a ndih te, ne quenda se ta̱hn chihche se ta̱hn da̱ma nduco incha̱hn te. ");
INSERT INTO cutNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nducoya̱ca ihyan che ritahno ye Dihvo vo Jesucristo, nde ihyan chena̱hn ne, checadino ye che tihca̱ chi, ne a̱ma dihya ye chi. ");
INSERT INTO cutNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A̱ma redin ihyan apóstol vederihno na̱n ihyan, ne nducoya̱ca ihyan che ritahno ye Dihvo vo Jesucristo ne, rendo da̱ma ye ya̱co chahte, ma̱n corredor che duche Salomón. ");
INSERT INTO cutNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ihyan ya̱n ne, a̱ma renevahnecun ye ihyan chahn, ne andahre va̱hino ye, conda̱ va̱n ye min, ");
INSERT INTO cutNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ate a̱ma ya̱hn ye, nde nda̱hta, nde cha̱hn ye, chitahno ye Dihvo vo, ne chinduco ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Quendi tihca̱ nde nda̱ ro cuahn che a̱ma riquenda ihyan ihyan cah yahn ye nduco yundo, renta̱ve ye chihto yune, ca̱va che cuahn che chuh Pedro ne, amare da̱hno ye conan a̱ma o ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Namin rica ihyan ya̱n che nino, renda̱ ye ya̱n Jerusalén, nda ye ihyan cah yahn ye nduco ihyan che chenun vaco chihnga̱ ihyan, ne ihyan cah chahn ne, rendoyahn ye, ne ihyan che chenun vaco chihnga̱ ihyan ne, rendiquenda̱h. ");
INSERT INTO cutNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tuhme chidocuya̱n che tahque ndina̱n nduco sa̱hn saduceo che rinduco se ihyan ne, chi ta̱n se, din vedeve. ");
INSERT INTO cutNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Din se preso ihyan apóstol chahn, ne chih se ihyan va̱coya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ate a̱ma ángel yahn Dendiohs ne, na̱hne ye va̱coya̱hn me vino, ne ndetenda̱h ye ihyan chahn, ne ra̱hn ye ri ye ihyan: ");
INSERT INTO cutNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cuahn nchuhn chete ya̱co chahte, cuahndudo ne na̱n ihyan vederihquentiyon che rendahcorun Dendiohs ihyan, rendedevahn ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Dinahn ihyan chahn, ne ta̱ma ro tiya̱n ndita ne, chenda̱ ye chete ya̱co me, cahndudo ye. Numanahmin ne, chidocuya̱n che tahque ndina̱n nduco sa̱hn che rinduco se ihyan ne, nedin da̱ma ye nducoya̱ca sa̱hn ndina̱n yahn nación yahn Israel ma̱n, sa̱hn intiyahn ma̱n. Tuhme tahve ye che chehua ihyan apóstol che chenun ye va̱coya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ate cuahn che nda̱ sa̱hn policía va̱coya̱hn me ne, metah ihyan chahn, ne ndaconan se, chengu se ndudo. ");
INSERT INTO cutNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ra̱hn se: ―Va̱coya̱hn ne, ndah ntude, ne sanda̱do chahn ne, chenan se cuda̱do chendevah. Ate cuahn che na̱hne nuhn chende va̱coya̱hn me ne, metah duhva. ");
INSERT INTO cutNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Cuahn che chihnevan chidocuya̱n che tahque ndina̱n ma̱n, sa̱hn ndina̱n yahn policía che redin cuda̱do ya̱co ma̱n, chidocuya̱n ndina̱n chahn ma̱n ne, retumerune vih se nde ti nda̱, nde ti tuno che tihca̱ ri. ");
INSERT INTO cutNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ura min ne, nda̱ a̱ma se, ne ra̱hn se ri se sa̱hn chahn: ―Sa̱hn che chih nchuhn va̱coya̱hn ne, chete ya̱co chenun se, ricuahn se. ");
INSERT INTO cutNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tuhme cuahn sa̱hn ndina̱n me nduco policía yahn se, chehua se ihyan apóstol chahn nduco ndah. Hua din ta̱n se nduco ye, te va̱h se che ca̱h ihyan ya̱n tu sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cuahn che nta̱ se ne, chengu se ihyan na̱n sa̱hn ndina̱n chahn. Tuhme ra̱hn chidocuya̱n che tahque ndina̱n me ri ye ihyan apóstol chahn: ");
INSERT INTO cutNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Nuhn ne, numacuahn vedeyudo chihquentiyon nuhn che hua quendi nchuhn cacuahn ne vederihquentiyon yahn sa̱hn min. Ate hua dinahn ne, te a ndacotuhn ne ndudo che ricuahn ne numachahte ya̱n Jerusalén. Ava̱ne ne, ricueh da̱me ne nuhn che nuhn chihno nuhn sa̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Tuhme Pedro nduco ihyan apóstol chena̱hn chahn ne, ndahconan ye: ―Nuhn ne, quenan cuma che dinahn nuhn vederihquentiyon yahn Dendiohs, te chemin che tahque yudo che co vederihquentiyon yahn ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nchuhn ne, nahn ya̱h ne Jesucristo na̱n a̱ma cruz, chihno ne ihyan, ate Dendiohs yahn indihte yuhn vo ne, ndedetuhche ye ihyan, ");
INSERT INTO cutNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ne chihco ye ihyan la̱do ta̱h cua̱co ye, nda̱hco ye vederihquentiyon ta̱h ye che cona̱n ye ma̱n, ndedevahn ye ihyan iyehnse ma̱n, ca̱va che nto ino ihyan nación yahn Israel nunde yahn ye, ne nda̱ca ye vederenchahco. ");
INSERT INTO cutNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nuhn ne, racotuhn nuhn ndudo yahn dehtenduh che tuhchan numacuahn vederihquentiyon yahn Vaco Ndah yahn Dendiohs, che redin Dendiohs che renun ihyan che redinahn ye ndudo yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cuahn che chihnevan sa̱hn ndina̱n chahn che tihca̱ ra̱hn ihyan apóstol ne, a̱ma chi ta̱n se, ne nahn ca̱hno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ate va̱n sa̱hn chahn ne, nduco a̱ma ihyan fariseo che duche ye Gamaliel. Ihyan min ne, ihyan devano ley che dirun Moisés, ne a̱ma renevahnecun ihyan ya̱n ihyan. Chandi ye, ne chihquentiyon ye che ndiquenda̱h vah ihyan apóstol chahn mena̱n lihn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tuhme ra̱hn ye ri ye combiero yahn ye: ―Nchuhn, ihyan ndina̱n yahn nación yuhn vo Israel, cuihco ne cuda̱do deh che rihco ne che din ne nduco ihyan sih. ");
INSERT INTO cutNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cueneca̱hco ne te ametah ra̱hn me che necuan Teudas, chinun se ihyan che va ta̱h se a̱ma vederihquentiyon, ne chinduco tenduh cun ciento ihyan sa̱hn. Ate chihno sanda̱do sa̱hn, chihno chano nducoya̱ca ihyan che chinduco ye sa̱hn, ne min chihnonan yahn se. ");
INSERT INTO cutNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Adive ne, ro che renan ca̱ca ihyan ne, necuan Judas yahn esta̱do yahn Galilea, ne a̱ma ya̱hn ihyan chinduco ye sa̱hn. Ate namin chihno sanda̱do sa̱hn, ne chihno chano ihyan che chinduco ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chemin che tahque nda̱hca̱ che hua ca̱hdenun nchuhn yune yahn ihyan sih, te ndete che vederihquentiyon yahn ma̱n ye che ricuahn ye ne, va che cuihno. ");
INSERT INTO cutNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ate ndete che vederihquentiyon yahn Dendiohs che ricuahn ye ne, hua co decuihno nchuhn. Ava̱ne ne, ndete che tihca̱ ne, ca̱hnda yahn ne, te redin va̱hche ne yahn vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Quenan ino nducoya̱ca sa̱hn ndina̱n chahn che ra̱hn ihyan min, ne cah se ihyan apóstol chahn, chahn se ihyan. Chihquentiyon se che ametah ndaconan cacuahn ye vederihquentiyon yahn Dihvo vo, ne ndedechuh se ihyan, cona̱hn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nda̱ca ihyan apóstol chahn na̱n sa̱hn ndina̱n chahn, ne a̱ma yeno ye, te ca̱h yune Dendiohs che chuhrihn ye ca̱va Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Quendi ihyan apóstol chahn chicuahn ye vederihquentiyon yahn Dihvo vo ro ro, chete ya̱co ma̱n, va̱co ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ta̱hn min ne, a̱ma ri ya̱hn ihyan che ritahno ye Dihvo vo Jesucristo. Ihyan che rente ye deva̱co griego ne, chica nunde ye yahn ihyan che rente ye hebreo, te ura che rih ye dehtenduh che cheh ihyan ne, hua ndahva reca̱h ye nda̱hta va̱h che rente ye griego. ");
INSERT INTO cutNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","3","Tuhme nedin da̱ma ihyan apóstol che ndichio chahn nducoya̱ca ihyan che ritahno ye Dihvo vo, ne ra̱hn ye: ―Dihno nuhn, hua nda̱hca̱ che ca̱hcoma̱n nuhn che rahndudo nuhn Ndudo yahn Dendiohs, din nuhn ntiyon che cuih nuhn che cheh nchuhn. Chemin che va̱n nchuhn ne, cuetenda̱hnun ne ndache ihyan che quenun Vaco Ndah yahn Dendiohs ihyan ma̱n, che chenan ino vo ihyan ma̱n, che nda̱hca̱ vederendedecadino yahn ye ma̱n, ne ihyan chahn ne, nda̱hco nuhn ntiyon cuh ta̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Me nuhn ne, quendi nuhn cova̱h nuhn ma̱n, cacuahn nuhn Ndudo yahn Dendiohs ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Chahtenan ino ihyan chahn, ne tenda̱hnun ye Esteban, a̱ma ihyan che numa ino ye ritahno ye Dihvo vo Jesucristo ma̱n, che quenun Vaco Ndah yahn Dendiohs ihyan ma̱n. Namin tenda̱hnun ye Felipe ma̱n, Prócoro ma̱n, Nicanor ma̱n, Timón ma̱n, Parmenas ma̱n, Nicolás ma̱n, a̱ma ihyan ya̱n Antioquía che chitahno ye da̱ma nduco ihyan nación yahn Israel ro mena̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tuhme cova̱h ihyan apóstol ca̱va ihyan chahn, nahn ta̱h ye ihyan, nda̱hco ye ntiyon min ta̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ndudo yahn Dendiohs ne, a̱ma retuhn, ne min ya̱n Jerusalén ne, ihyan che ritahno ye Dihvo vo Jesucristo ne, a̱ma ri ya̱hn ye. Nde chidocuya̱n, a̱ma ya̱hn ye chitahno ye, chinduco ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban ne, redin ye vederihno na̱n ihyan, te a̱ma yahino Dendiohs ihyan ma̱n, neca̱h ye vederihquentiyon ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","A̱ma o sa̱hn ndiya̱co che duche Esclavos Libertados, nduco a̱ma o sa̱hn ya̱n Cirene ma̱n, Alejandría ma̱n, ya̱hn yahn Cilicia ma̱n, Asia ma̱n ne, cana̱n se ruhn chende se nduco Esteban. ");
INSERT INTO cutNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ate hua chi nda̱hco ndiya se ihyan, te quenun Vaco Ndah yahn Dendiohs ihyan ma̱n, a̱ma va vededevano yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tuhme nedihve se a̱ma o sa̱hn ca̱va che cuacotuhn se ndudo cuahnde, ne ca̱hma se te chihnevan se che chihnga̱ ra̱hn Esteban yahn Dendiohs ma̱n, yahn ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nduco chemin ne, ndedecuan se sa̱hn ya̱n ma̱n, sa̱hn ndina̱n ma̱n, sa̱hn devano ley che dirun Moisés ma̱n, ne chi ta̱n sa̱hn chahn nduco Esteban, quenda se ihyan na̱n intiyahn. ");
INSERT INTO cutNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Namin nuhn sa̱hn chahn a̱ma o se che ca̱hma se ndudo cuahnde tuhca̱: ―Cuahn da̱ma chihnga̱ ra̱hn sa̱hn tih yahn ya̱co cuh che nihnde vih yahn Dendiohs ma̱n, yahn ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cua̱co chemin, te chihnevan nuhn che ra̱hn se te Jesucristo yahn ya̱n Nazaret ne, ndatera ye ya̱co cuh ma̱n, ndahcorun ye costumbre che chihco Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nducoya̱ca sa̱hn ndina̱n che vate se min ne, ndihchero se Esteban, ne nduhca̱ che ro na̱n ángel, tihca̱ ro na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tuhme chidocuya̱n che tahque ndina̱n me ne, chiquerune ye Esteban: ―¿A cua̱co nducuahn che rica nunde sa̱hn sih yehn ne? ");
INSERT INTO cutNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ndahconan Esteban, ne ra̱hn ye: ―Nducoya̱ca nchuhn, dihnó ma̱n, ihyan ndina̱n yahn nación yuhn vo ma̱n, cuihcovan ne che ca̱hmá. Dendiohs yuhn vo, ihyan min che a̱ma yudo vederihquentiyon yahn ye ne, nda̱ ye na̱n indihte yuhn vo Abraham, cuahn che quenan ca ye ya̱hn yahn Mesopotamia, ro che ametah cuhnde ye ya̱n Harán, ");
INSERT INTO cutNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ne ra̱hn ye ri ye ihyan: “Cuihcoman ya̱n vaque ma̱n, nducoya̱ca ihyan yehn ma̱n, ne cuehn a̱ma cua̱n ya̱hn na̱n che na̱hmá di.” ");
INSERT INTO cutNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tuhme chica Abraham ya̱n va̱co ye, Caldea, ne chahn ye, chihnde ye ya̱n Harán. Adive ne, chih chida ye, ne na̱hma Dendiohs ihyan yune, nde na̱n che nda̱ ye muhn, ya̱hn na̱n che vahto vo ma̱n ro cuh. ");
INSERT INTO cutNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Hua ca̱h Dendiohs nde a̱ma ndi ya̱hn cuh ihyan, nde na̱n che ca̱hno ye a̱ma ca̱h ye. Ate ca̱h ye ndudo yahn ye ihyan te co ya̱hn nda̱ta yahn ye, andahre ro min ne, ametah nde a̱ma da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Namin ra̱hn Dendiohs ri ye ihyan te nda̱ta yahn ye ne, va che cuahtenan ye ya̱n va̱co ihyan ta̱ma nación, ne din ta̱n ihyan nación min nduco ye ma̱n, din ye ntiyon yahn ihyan chahn nduco fuerza ma̱n, nde cuihno cun ciento nduyo. ");
INSERT INTO cutNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ate namin ra̱hn Dendiohs ri ye ihyan: “U dín castigo ihyan nación min che ca̱hcantiyon ye numacuahn vedeta̱n nda̱ta yehn che din ye ntiyon yahn ye. Cuihno min ne, nda̱ca ye nación min, ne cochi ye muhn ya̱hn cuh, ndeva ye yavená̱n.” ");
INSERT INTO cutNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Namin ca̱h Dendiohs ndudo yahn ye Abraham, ne chihquentiyon ye che conan a̱ma seña queri a̱ma ihyan, nda̱ta yahn ye, ca̱va che ca̱hco ran ye che nevahnecun ye ndudo min. Chemin che cuahn che chihndeya̱n da̱ya Abraham che duche Isaac ne, chihno nine ro ne, chaconahn ye seña. Tihca̱ chaconahn Isaac seña da̱ya ye Jacob, ne Jacob ne, tihca̱ chaconahn ye seña nducoya̱ca da̱ya ye. A ihyan min che chihco nda̱ta ye nduh che ndichio nda̱ta yahn ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Da̱ya Jacob che ihyan ndico yuhn vo ne, a ihyan chahn che din ve ye yahn dihno ye José, ne ndihcue ndeh ye ihyan nduco sa̱hn che quenda se ihyan nde nación yahn Egipto. Ate Dendiohs ne, chinduco ye José, ");
INSERT INTO cutNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ne ndedevahn ye ihyan yahn nducuahn che rechuhrihn ye. Ca̱h Dendiohs vederendedecadino che nda̱hca̱ ihyan, ne din ye che Faraón, rey yahn Egipto ne, din yahino ye ihyan. Chemin che chaconahn Faraón ihyan che ca̱hcantiyon ye ndeva̱co ye ma̱n, nde numachahte nación yahn Egipto ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Tuhme chihnde cuico numachahte nación yahn Egipto ma̱n, Canaán ma̱n, ne a̱ma chuhrihn nducoya̱ca ihyan, nde indihte yuhn vo, ne ametah renda̱ca che cheh ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ate cuahn che checadino Jacob che min nación yahn Egipto va trigo ne, dechuh ye da̱ya ye. Ta̱hn min ne, cade a̱ma yune chahn ihyan ndico yuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Cuahn che chi o yune che chahn ihyan chahn ne, ca̱h José che checadino ye te ihyan min che dihno ye, ne nduco chemin checadino Faraón ti chica nda̱ta yahn José. ");
INSERT INTO cutNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tuhme dechuh José che chehua chida ye Jacob nduco ihyan yahn ye. Nducoya̱ca ihyan chahn ne, ri ye ino raco ntihyon. ");
INSERT INTO cutNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tihca̱ chi che chahn Jacob, chihnde ye nación yahn Egipto. Adive ne, chih ye, ne namin a min chih ihyan ndico yuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Adive ne, ndiquenda ihyan ine yahn tena̱hn chahn nde ya̱n Siquem. Min chihche tun ye ihyan na̱n ya̱yan che ca Abraham, ndihcue da̱ya Hamor. ");
INSERT INTO cutNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Cuahn che a nda̱ nino ro che conahn ndudo che ca̱h Dendiohs numacuahn vedeyudo Abraham ne, ihyan nación yahn Israel ne, a̱ma chi ya̱hn ye min nación yahn Egipto. ");
INSERT INTO cutNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ta̱hn min chihnde ta̱ma rey yahn Egipto che hua rendihche ye José. ");
INSERT INTO cutNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rey min ne, din ta̱n ye numacuahn vederihncheh nduco ihyan ndico yuhn vo, ne chihquentiyon ye ihyan chahn che cade cuahteya̱n da̱ya ye che cha̱hn ne, ca̱hn ye, cuaconda̱h ye ca̱va che coh. ");
INSERT INTO cutNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ta̱hn min chihndeya̱n Moisés, ne a̱ma quenan ino Dendiohs lihn me. Ino iyo ra chi ta̱ve indihte yahn se sa̱hn, ");
INSERT INTO cutNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ne cuahn che chihcoma̱n ye lihn me ne, ta̱hn da̱ya ma̱n rey nta̱ca te sa̱hn. Ndeva te sa̱hn, ne ta̱ve te sa̱hn nduhca̱ da̱ya ma̱n te. ");
INSERT INTO cutNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chemin che chahn Moisés nducuahn vededevano yahn ihyan nación yahn Egipto. Cuahn che chi chahte ye ne, a̱ma dito na̱n ye na̱n che rente ye ma̱n, na̱n dehtenduh che redin ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Cuahn che a chi ye o raco nduyo ne, chahn ye chendihchero ye ihyan nación yahn ye, Israel. ");
INSERT INTO cutNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Min ndihchero ye che chahn a̱ma sa̱hn Egipto a̱ma sa̱hn nación yahn ye, ne chihno ye sa̱hn Egipto me, ndedevahn ye sa̱hn che ta̱ma me. ");
INSERT INTO cutNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tihca̱ din ye, te ra̱hco ye te nduco chemin ne, ihyan nación yahn ye ne, conahn ye te dechuh Dendiohs ihyan, ndedevahn ye ihyan chahn. Ate ihyan chahn ne, hua chenahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ta̱ma ro me ne, ndihchero Moisés o sa̱hn nación yahn ye che rahteruhn se nduco vih, ne nahn ca̱hco dihn ye sa̱hn. Ra̱hn ye ri ye sa̱hn: “Nchuhn ne, da̱ma nación yuhn vo nduco vih, ¿dehco che rahteruhn ne nduco vih?” ");
INSERT INTO cutNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ate sa̱hn che redin ta̱n nduco combiero yahn me ne, chaconda̱ se ihyan, ne ra̱hn se: “¿Duh chaconahn di che conan yahn nuhn, techecade yahn nuhn? ");
INSERT INTO cutNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A namin nahn cahne u nduhca̱ che chihne sa̱hn Egipto me ico?” ");
INSERT INTO cutNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cuahn che chihnevan Moisés che tihca̱ ra̱hn sa̱hn min ne, chano ye, ne cuahn ye, chihnde ye a̱ma cua̱n ya̱hn che duche Madián. Min chihneva̱co ye, ne nda̱ca o da̱ya ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Chihno o raco nduyo ne, min ya̱hn na̱n che metah duhva, nino na̱n cuete che duche Sinaí ne, adena̱n chihnde ro a̱ma ángel va̱n ruchiya̱hn yahn a̱ma ya̱hn lihn che riche, ndihchero Moisés. ");
INSERT INTO cutNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés ne, a̱ma cuahn ino ye yahn vederihno che rendihchero ye, ne cuahn che chahn nda̱ ye ca̱va che ndihchero ndah ye ne, chihnevan ye che ra̱hn Dihvo vo Dendiohs: ");
INSERT INTO cutNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“U che Dendiohs yahn ihyan ndico yehn, Abraham ma̱n, Isaac ma̱n, Jacob ma̱n.” Tuhme a̱ma dihya Moisés chi, nde tuno rendoh ye che va̱h ye, nde metah chihquino ye ndihchero ca ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ra̱hn Dendiohs ri ye ihyan: “Cuehnevi nda̱co che chenun cah, te ca̱hnda yehn yahn che nti nino na̱n che quenún. ");
INSERT INTO cutNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A ndihcheró che rechuhrihn ihyan yáhn min nación yahn Egipto, ne chihneván che reva̱h ye. Chemin che cochí, ndedeváhn ihyan. Ma̱n ne, conan yan, te dechúh di Egipto.” ");
INSERT INTO cutNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Andahre hua nevahnecun ihyan chahn Moisés ro mena̱n, ra̱hn ye ri ye ihyan: “¿Duh chaconahn di che conan yahn nuhn, techecade yahn nuhn?” Ate ma̱n Dendiohs dechuh ye ihyan ca̱va che cona̱n ye yahn ihyan chahn ma̱n, ca̱va che ndedevahn ye ihyan ma̱n, nduhca̱ che ra̱hn ye ro che chihnde ro ángel me na̱n ya̱hn lihn che riche me. ");
INSERT INTO cutNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","A Moisés che ndetenda̱h ye ihyan ndico yuhn vo min nación yahn Egipto, ne din ye vederihno ya̱hn min ma̱n, na̱n Nuniya̱hn Cua̱h ma̱n, ya̱hn na̱n che metah duhva ma̱n, chete che o raco nduyo. ");
INSERT INTO cutNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","A Moisés che ra̱hn ye ri ye ihyan nación yuhn vo, Israel: “Dendiohs ne, ndedecuan ye a̱ma ihyan profeta va̱n nda̱ta yuhn vo nduhca̱ che ndedecuan ye u, ne che ca̱hma ihyan min ne, chemin che codinahn nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A Moisés che quenda̱hna̱n ye yahn ihyan nación yuhn vo, Israel, min ya̱hn na̱n che metah duhva, ne a ihyan min che nte ángel nduco ye min Cuete Sinaí ca̱va che ca̱h ye ndudo min ihyan ndico yuhn vo. A ihyan min che chihnevan ye ndudo yahn che ndedevahn Dendiohs ihyan iyehnse, chihco ye ca̱vo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Ate ihyan ndico yuhn vo ne, chacota̱hn ye yahn Moisés ma̱n, nahn ndaconan ye nación yahn Egipto ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ra̱hn ihyan chahn ri ye Aarón: “Nahn nuhn che dendah ne a̱ma o dendiohs che quenda̱hna̱n ye yuhn vo, te Moisés, ihyan min che ndetenda̱h ye uvo nación yahn Egipto ne, a hua renta̱ ye, ne hua devano nuhn deh chi yahn ye.” ");
INSERT INTO cutNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Tuhme dendah ihyan chahn a̱ma itenine lihn. Chihno ye a̱ma o ite ca̱va che co te vedino na̱n itenine me, ne a̱ma chi yeno ye nduco dendiohs min yahn ye che dendah ma̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chemin che chihcoma̱n Dendiohs ihyan chahn, ne ca̱h yune ye che chitahno ye iyon che chenan na̱n ro, chivahn dendiohs yahn ye, nduhca̱ che dirun a̱ma cha ihyan profeta tuhca̱: Nchuhn, ihyan nación yahn Israel, cuahn che chahtechica ne ya̱hn na̱n che metah duhva chete che o raco nduyo ne, ndotenan che ca̱hno ne ite ca̱va che co te vedino, ndeva ne yavená̱n ne, ");
INSERT INTO cutNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","tahque ndah ne ne, quenda ne ya̱co na̱n che quenun Moloc ma̱n, iyon yahn Renfán ma̱n, ndeva ne yavena̱n dendiohs chemin chan che dendah ma̱n ne. Chemin che quenan cuma che dín castigo nchuhn, dechúh nchuhn nde tahque ca̱na yahn nación yahn Babilonia. ");
INSERT INTO cutNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Min ya̱hn na̱n che metah duhva ne, ihyan ndico yuhn vo ne, chihnde ta̱h ye ya̱co che chindah nduhca̱ che na̱hma Dendiohs Moisés ta̱ca̱ va che dendah ye. A chete ya̱co min ne, chenun ndah tu rahno na̱n che ndirun ley yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Chan rine, chihnde ta̱h ihyan chahn ya̱co me nde ro che nda̱ ye nduco Josué, cheta̱h ye ya̱hn yahn ihyan ta̱ma nación che chehnevi Dendiohs na̱n ye. Tihca̱ chihco cuda̱do ye ya̱co me nde ro che quenan David. ");
INSERT INTO cutNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dendiohs, ihyan min che ndeva Jacob yavena̱n ye ne, din yahino ye rey David, ne nahn ca̱hno rey me a̱ma ya̱co yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ate Salomón che chihno ye ya̱co yahn Dendiohs, ");
INSERT INTO cutNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","andahre Dendiohs, ihyan min che a̱ma yudo vederihquentiyon yahn ye, hua rendotenan ye ya̱co che rihno ihyan. Tihca̱ nduhca̱ che dirun ihyan profeta me tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ra̱hn Dihvo vo Dendiohs: “Rihquentiyón nde vahchetero ma̱n, nde numachahte iyehnse ma̱n. ¿Ta̱ca̱ conún chete a̱ma ya̱co che rihno ihyan? ¿Ta̱ca̱ cuhndé a̱ma cua̱n no? ");
INSERT INTO cutNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A má̱n dendáh nducuahn dehtenduh che va.” ");
INSERT INTO cutNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Quendi Esteban, ne ra̱hn ye: ―Nchuhn ne, cheche chedave yahn ne. Da̱ma ri ne nduco ihyan che hua ritahno ye Dendiohs, te hua redinahn ne. Numacuahn ro ne, rahcota̱hn ne vederihquentiyon yahn Vaco Ndah yahn Dendiohs. Nduhca̱ ihyan ndico yahn ne ne, tihchan ne. ");
INSERT INTO cutNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nducoya̱ca ihyan profeta ne, din ta̱n ihyan ndico yahn nchuhn nduco ye. Ihyan ndico yahn ne ne, chihno ye ihyan profeta chahn che dirun ye nde ro mena̱n che va che chi Da̱ya Dendiohs, ne cuahn che nda̱ ye ne, a ma̱n nchuhn hua chitahno ne ihyan, ne chihno ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nchuhn ne, nduco ángel dechuh Dendiohs ley yahn ye ca̱va che dinahn ne, ate hua redinahn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cuahn che chihnevan sa̱hn ndina̱n chahn che tihca̱ ra̱hn Esteban ne, a̱ma chi ta̱n se, nde tuno reh dihyon se. ");
INSERT INTO cutNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ate Esteban ne, quenun Vaco Ndah yahn Dendiohs ihyan, ne chenihyon na̱n ye na̱n ro, ne ndihchero ye che a̱ma yudo vederihquentiyon yahn Dendiohs ma̱n, che nti Dihvo vo Jesucristo la̱do ta̱h cua̱co ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tuhme ra̱hn ye: ―¡Condihche nchuhn! ¡Quendah vahchetero! ¡Nga̱ Ihyan min che rinduco ye nducoya̱ca ihyan, nti ye la̱do ta̱h cua̱co Dendiohs! ");
INSERT INTO cutNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ate sa̱hn chahn ne, neca̱hde se iverevan se, nde tuno rah ta̱n se, tumanga̱n se Esteban. ");
INSERT INTO cutNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Quenda se ihyan cuahn chihto ya̱n, ne min ca̱h se tu ihyan. A̱ma sa̱hn che duche se Saulo ne, din se cuda̱do tino yahn sa̱hn che chenan se ntiyon che ca̱h se tu ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ura che reca̱h se tu Esteban ne, cova̱h ye tuhca̱: ―Dihvé Jesucristo, nda̱hcó chedave yáhn ta̱h ne. ");
INSERT INTO cutNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tuhme chehntihya ye, ne ra̱hn ye numa dito ye: ―Dihvé, cuenchahco ne yahn sa̱hn sih che tihca̱ redin se. Chihno ra̱hn ye chemin ne, chih ye. ");
INSERT INTO cutNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo ne, da̱ma chi se nduco sa̱hn chahn che chihno se Esteban. A ro min no cana̱n a̱ma redin ta̱n se nduco ihyan ya̱n Jerusalén che ritahno ye Dihvo vo. Va̱n ihyan chahn ne, atena̱n ihyan apóstol che chahtenan ye min, te chihno chano nducoya̱ca ye, cuahn muhn cuahn min ye esta̱do yahn Judea ma̱n, nación yahn Samaria ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ihyan che ndah ihyan ye na̱n Dendiohs ne, a̱ma chi ra̱n ye ca̱va Esteban, ne chahn ye chihche ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo ne, quendi se redin ta̱n se nduco ihyan che ritahno ye Dihvo vo, ne renda̱ se nduh vah nduh vah, retenda̱h vah se ihyan. Nde nda̱hta, nde cha̱hn ye, rihnda rudo se ihyan, riquenda se ihyan, rih se ihyan va̱coya̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ihyan che chano chahn ne, rahndudo ye ndudo ndah yahn Dendiohs nduh cua̱n ya̱n na̱n che renda̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A̱ma cha ihyan chahn che duche ye Felipe ne, cuahn che nda̱ ye a̱ma cua̱n ya̱n yahn Samaria ne, min rahndudo ye ndudo yahn Dihvo vo Jesucristo, che a ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","A̱ma rendo da̱ma ihyan, rihnevan ye numacuahn vedenecun che rahndudo Felipe ma̱n, rendihchero ye vederihno che redin ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","A̱ma ya̱hn ihyan che chenun vaco chihnga̱ ihyan ne, rendihquenda̱h vaco chahn, a̱ma rah. Namin rendoyahn a̱ma ya̱hn ihyan che ndi cheche ye ma̱n, che neneva doh ca̱h ye ma̱n, ta̱h ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Chemin che nducoya̱ca ihyan ya̱n min ne, a̱ma yeno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ya̱n min ne, va a̱ma sa̱hn che duche se Simón, che cuah se. A ra̱hn me ne, a̱ma chihncheh se ihyan che vate ye numachahte nación yahn Samaria, ra̱hn se te ametah nde a̱ma ihyan nduhca̱ sa̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nducoya̱ca ihyan, nde ihyan ndico ma̱n, nde checa̱hya ma̱n, renevahnecun ye sa̱hn, ne ra̱hn ye: ―Sa̱hnguh ne, quenan cuma se vederihquentiyon chahte yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","A̱ma ra̱hn chitahno ihyan chahn sa̱hn, te nduco vedecuah yahn se ne, chihncheh se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ate cuahn che chihnevan ihyan chahn che rahndudo Felipe yahn vederihquentiyon yahn Dendiohs ma̱n, yahn che ndedevahn Dihvo vo Jesucristo ihyan ma̱n ne, nducoya̱ca ye, nde nda̱hta, nde cha̱hn ye, chitahno ye Dihvo vo, ne chedenune ye. ");
INSERT INTO cutNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nde Simón cuah me ne, chitahno se, ne chedenune se. Chinduco se Felipe, ne a̱ma rahn ino se yahn vederihno che rinahn. ");
INSERT INTO cutNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Cuahn che ihyan apóstol che chenan ye ya̱n Jerusalén checadino ye che nevahnecun ihyan ya̱hn yahn Samaria Ndudo yahn Dendiohs ne, dechuh ye Pedro nduco Jua̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuahn che nda̱ ihyan apóstol chahn ne, cova̱h ye ca̱va che conun Vaco Ndah yahn Dendiohs ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ametah conun Vaco Ndah yahn Dendiohs nde a̱ma ihyan chahn, te cade chedenune ye che nevahnecun ye Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tuhme Pedro nduco Jua̱n ne, nahn ta̱h ye ihyan chahn, ne quenun Vaco Ndah yahn Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Cuahn che ndihchero Simón che renun Vaco Ndah yahn Dendiohs ihyan che renahn ta̱h ihyan apóstol chahn ne, nahn ca̱h se tume ihyan, ");
INSERT INTO cutNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ne ra̱hn se: ―Cuedin nchuhn che namin nducó conan cumá vederihquentiyon tih, ca̱va che adecoduhno ihyan che nahn tá̱h ihyan ne, conun Vaco Ndah yahn Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Tuhme ra̱hn Pedro ri ye sa̱hn: ―A ndinda di nde nduco tume yehn, te rendedecadine te co cua nduco tume vederihquentiyon che reca̱h Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Di ne, nde hua co conen na̱n ntiyon cuh, te hua ndah chedave yehn na̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cuento ine yahn nunde yehn, ne cuique Dendiohs ndete che nchahco ye yehn che tihca̱ rendedecadine, ");
INSERT INTO cutNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","te ndero ndi che a ndinda di, nedin nunde yehn. ");
INSERT INTO cutNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ndahconan Simón, ne ra̱hn se ri se ihyan: ―Cova̱h nchuhn ca̱va che nchahco Dihvo vo Dendiohs nunde yáhn, ne hua cuahno có nduhca̱ che ra̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Cuahn che a nte ihyan apóstol chahn yahn vederihno che din Dendiohs ma̱n, cahndudo ye Ndudo yahn Dendiohs ma̱n ne, cona̱hn ye ya̱n Jerusalén, racotuhn ye ndudo ndah yahn Dihvo vo Jesucristo a̱ma ndeh ya̱n yahn Samaria na̱n che rechuh ye. ");
INSERT INTO cutNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Chihno min ne, ra̱hn a̱ma ángel yahn Dihvo vo Dendiohs ri ye Felipe: ―Cuehn cua̱hn yune che rica ya̱n Jerusalén, rahn cua̱hn ya̱n Gaza. Yune min che rechuh cua̱hn ya̱hn na̱n che metah duhva. ");
INSERT INTO cutNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tuhme cuahn Felipe, ne ura che a quenun yune ye ne, nta̱ca ye a̱ma sa̱hn ndina̱n, che tesorero yahn ta̱hn Candace, reina yahn nación yahn Etiopía. Ro min ne, a ndaconan se che chahn se ya̱n Jerusalén, ndeva se yavena̱n Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Cona̱hn se ya̱n va̱co se, va se chete carro yahn se, ne rahndudo se libro che dirun ihyan profeta Isaías. ");
INSERT INTO cutNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Tuhme ra̱hn Vaco Dendiohs nduco Felipe: ―Cuehn, cotone carro tih. ");
INSERT INTO cutNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Cuahn che tuno Felipe carro me ne, chihnevan ye che rahndudo sa̱hn min libro che dirun Isaías, ne tumerune ye sa̱hn: ―¿A renahn ne ndudo tih che rahndudo ne ne? ");
INSERT INTO cutNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ndahconan se yahn ye: ―Hua, te metah duh che te cuande u. Tuhme ya̱hve se ihyan che conda̱ ye chete carro me, cuhnde ye da̱ma nduco se. ");
INSERT INTO cutNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na̱n Ndudo yahn Dendiohs che rahndudo se ne, ndirun tuhca̱: Nduhca̱ che riquenda ihyan itecuche na̱n che ca̱hno ye ite ne, tihca̱ quenda ye ihyan. Nduhca̱ a̱ma itecuche lihn che hua rah te che rendu ihyan ite ne, tihca̱ ihyan min, te hua dehva ca̱hma ye. ");
INSERT INTO cutNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ndere ca̱ca nunde se yahn ye, ne ametah deh che ca̱hma ye, te hua nda̱ca duh che techeca̱de yahn ye numa cua̱co. ¿Duh co ca̱hma yahn nda̱ta yahn ihyan min?, te ca̱hno se ihyan, ne nda̱ca ye iyehnse cuh. ");
INSERT INTO cutNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tumerune sa̱hn min Felipe: ―Codin favor, ne cahme co u, ¿Duh yahn che tihca̱ dirun ihyan profeta me? ¿A yahn ma̱n ye, o yahn ta̱ma ihyan? ");
INSERT INTO cutNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tuhme cana̱n Felipe nde na̱n che rahndudo se, ca̱h cuande ye sa̱hn ndudo ndah yahn Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Cuahn che nda̱ ihyan chahn a̱ma cua̱n na̱n che va nune ne, ra̱hn sa̱hn ndina̱n me: ―Muhn va nune, ¿a hua co cuedenuné ne? ");
INSERT INTO cutNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ndahconan Felipe yahn se: ―Ndete che ritahnó ne numacuahn chedave yahn ne ne, ta̱ca̱ hua, co cuedenune ne. Tuhme ra̱hn sa̱hn min: ―Ritahnó te Jesucristo ne, ihyan min che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Chihquentiyon se che chan carro me. Tuhme cochahn se nduco Felipe na̱n nune me, ne chehdenune ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cuahn che ndiquenda̱h ihyan chahn va̱n nune ne, quenda Vaco Dihvo vo Dendiohs Felipe, ne chehna̱n se ihyan. Tuhme ndonun yune se, cona̱hn se, ne a̱ma yeno se. ");
INSERT INTO cutNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe ne, adena̱n nda̱ ye ya̱n Azoto, ne chuh ye nduh ya̱n nduh ya̱n, rahndudo ye Ndudo yahn Dendiohs nde nda̱ ye ya̱n Cesarea. ");
INSERT INTO cutNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Numacuahn ro min ne, riquendi Saulo redin ta̱n se nduco ihyan che ritahno ye Dihvo vo Jesucristo, nahn ca̱hno se ihyan. Chahn se na̱n chidocuya̱n che tahque ndina̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","chica se a̱ma ca̱ca, quenda se, ca̱va che ca̱hn se ya̱co yahn ihyan nación yahn Israel che vate ye ya̱n Damasco, din se preso nde nda̱hta, nde cha̱hn, ihyan che ritahno ye Dihvo vo, quenda se ihyan ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ate cuahn che nda̱ nino se ya̱n Damasco ne, adena̱n chiya a̱ma dave che chica na̱n ro na̱n se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ndeta̱hno chenda̱h se ndiya̱hn, ne chihnevan se a̱ma ndudo che ra̱hn: ―Saulo, Saulo, ¿dehco che redin tan nduco ihyan yáhn? ");
INSERT INTO cutNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Tumerune se: ―Dihvé, ¿duh ndih ne? Ndaconan ndudo me: ―U che Jesucristo che redin tan nducó. Nduhca̱ itenine che renun yah ma̱n te ite, renun te ya̱hn cuiyon che rahco nduco ihyan ite ne, tihca̱ redin. ");
INSERT INTO cutNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo ne, a̱ma dihya se chi, nde tuno rendoh se che va̱h se, ne ra̱hn se: ―Dihvé, ¿deh nahn ne che dín ne? Ndahconan Dihvo vo yahn se: ―Cuenecuen, ne cuehn viya̱n. Min ca̱hma a̱ma ihyan co ye di deh va che din. ");
INSERT INTO cutNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Namin sa̱hn che nduco Saulo ne, a̱ma dihya se chi, te chihnevan sa̱hn chahn ndudo me, ate hua duhva ndihche se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Tuhme necuan Saulo, ate cuahn che na̱hne se ndutina̱n se ne, ametah ro na̱n se. Chemin che cheta̱h sa̱hn chahn ta̱h se, ne quendanan se sa̱hn nde nda̱ se ya̱n Damasco. ");
INSERT INTO cutNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Min quenan se ino ro, ne hua ro na̱n se, nde hua cheh se, nde hua chih se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ya̱n min va a̱ma ihyan che duche ye Ananías che ritahno ye Dihvo vo Jesucristo. Ndihchero ihyan min a̱ma vederihno va̱n ya̱hnde yahn ye che nda̱ Dihvo vo na̱n ye, ne ya̱hve ye ihyan: ―¡Ananías! Ndahconan ye: ―Dihvé, ca̱hma ne. ");
INSERT INTO cutNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tuhme ra̱hn Dihvo vo ri ye ihyan: ―Cuehn cuahn yune che duche Yune Cua̱co, ne min ndeva̱co Judas, cuiquerone ca̱va a̱ma sa̱hn ya̱n Tarso che duche se Saulo. Min quenun se, reva̱h se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sa̱hn min ne, din Dendiohs che va̱n ya̱hnde yahn se ndihchero se di che nda, nahn tah sa̱hn ca̱va che ndaconan co ro na̱n se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Cuahn che chihnevan Ananías che tihca̱ ne, ra̱hn ye: ―Dihvé, a̱ma ya̱hn ihyan rente ye nducó yahn sa̱hn min che a̱ma redin ta̱n se min ya̱n Jerusalén nduco ihyan che ritahno ye ndih. ");
INSERT INTO cutNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma̱n ne, nda̱ se muhn, nda se a̱ma ca̱ca che dendah chidocuya̱n che tahque ndina̱n ca̱va che din se preso nducoya̱ca nuhn che ritahno nuhn ndih, quenda se nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ate ra̱hn Dihvo vo ri ye ihyan: ―Cuehn, te má̱n tenda̱hnún sa̱hn ca̱va che cuahndudo se ndudo yáhn, cahnevan ihyan nación yahn Israel ma̱n, ihyan nación chena̱hn ma̱n, rey yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ca̱h cuandé sa̱hn che va che a̱ma chuhrihn se che cuande yáhn. ");
INSERT INTO cutNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Tuhme cuahn Ananías, chenda̱ ye vah na̱n che quenun Saulo. Nahn ta̱h ye sa̱hn, ne ra̱hn ye ri ye sa̱hn: ―Dihnó Saulo, Dihvo vo Jesucristo, ihyan min che chihnde ro ye nan cua̱hn yune ne, dechuh ye u ca̱va che ndaconan co ro nan ma̱n, ca̱va che conun Vaco Ndah yahn Dendiohs di ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ndeta̱hno chera che deca̱ ro yun ro che chenan ndutina̱n se, ne chi ro na̱n se. Tuhme necuan se, ne chedenune se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Chihno min ne, cheh se, ne ndeva fuerza sa̱hn. Quenan se neve ro min ya̱n Damasco nduco ihyan che ritahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chihno min ne, cana̱n cahndudo Saulo nduh cua̱n chete ya̱co, ne ra̱hn ye te Jesucristo ne, ihyan min che Da̱ya Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nducoya̱ca ihyan che rihnevan ye ne, rahn ino ye, ne retumarune vih ye: ―¿A ndiyu sa̱hn tih che redin ta̱n se ya̱n Jerusalén nduco ihyan che ritahno ye Jesús? ¿A ndiyu sa̱hn tih che nda̱ se muhn ca̱va che quenda se ihyan che ritahno ye ihyan min, neca̱h se ihyan ta̱h chidocuya̱n ndina̱n? ");
INSERT INTO cutNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ate Saulo ne, nde tahque numa ino se rahndudo se che cua̱co te Dihvo vo Jesucristo ne, a ihyan min che a va ca̱de che chi ye ndedevahn ye ihyan iyehnse. Nde na̱n che ametah deh che ca̱hma ihyan nación yahn Israel che vate ye min ya̱n Damasco. ");
INSERT INTO cutNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Chihno ndeh ro ne, ihyan nación yahn Israel chahn ne, ntuhno ye ca̱va che ca̱hno ye Saulo, ");
INSERT INTO cutNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ate checadino se. Nde ro nde ra̱hn rano ihyan chahn sa̱hn nduh cua̱n chende chan yahn ya̱n me ca̱va che ca̱hno ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ate a̱ma vino ne, ihyan che ritahno ye Dihvo vo ne, ndedevah ye sa̱hn chete a̱ma cuahte chahte na̱n chete che ndi chan yahn ya̱n me, ne tihca̱ chi che ndevahn se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cuahn che nta̱ Saulo ya̱n Jerusalén ne, nahn conduco se ihyan che ritahno ye Dihvo vo Jesucristo, ate nducoya̱ca ihyan chahn ne, va̱h ye, te ra̱hco ye te co hua cua̱co che a ritahno se Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ate Bernabé ne, quenda ye Saulo na̱n ihyan apóstol chahn, ne neca̱h cuande ye ihyan nduhca̱ che chihnde ro Dihvo vo na̱n se cua̱hn yune ma̱n, nduhca̱ che ya̱hve ye sa̱hn ma̱n, nduhca̱ che numa ino se cahndudo se ya̱n Damasco vederihquentiyon yahn Dihvo vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tuhme chinduco Saulo ihyan apóstol chahn, ne quenan se min ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Numa ino se rahndudo se vederihquentiyon yahn Dihvo vo, riya̱hve se ihyan, nda̱ta yahn Israel, che rente ye deva̱co griego. Ate ihyan chahn ne, rinuhn ino ye ta̱ca̱ co ca̱hno ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cuahn che checadino ihyan che ritahno ye Dihvo vo che tihca̱ ne, quenda ye sa̱hn ya̱n Cesarea, ne ndedechuh ye sa̱hn ya̱n va̱co se Tarso. ");
INSERT INTO cutNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ta̱hn min ne, numachahte esta̱do yahn Judea ma̱n, Galilea ma̱n, nación yahn Samaria ma̱n ne, nducoya̱ca ihyan che ritahno ye Dihvo vo ne, cheguan redin ta̱n ihyan nduco ye, ne a ndevate tahn ye, rendeva ye yavena̱n Dihvo vo Dendiohs numacuahn vedenecun. Reneca̱h ya̱n Vaco Ndah yahn Dendiohs chedave yahn ihyan chahn, ne redin Dendiohs che a̱ma ya̱hn ihyan ritahno ye Dihvo vo, rinduco ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Cuahn che quechica Pedro, rahndudo ye va̱n ihyan che ritahno ye Dihvo vo Jesucristo ne, chahn ye, chendihchero ye ihyan che vate ye ya̱n Lida. ");
INSERT INTO cutNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Min nta̱ca̱ ye a̱ma sa̱hn cah che duche se Eneas. A nine nduyo ndi cheche se, quendite se na̱n yundo. ");
INSERT INTO cutNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ra̱hn Pedro ri ye sa̱hn: ―Eneas, Dihvo vo Jesucristo din ye che ndoyehn. Cuenecuen, condihte ndah yundo yehn. Ndeta̱hno ndoyahn Eneas, ne necuan se. ");
INSERT INTO cutNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nducoya̱ca ihyan ya̱n Lida ma̱n, ya̱n Sarón ma̱n, ndihchero ye che ndoyahn se, ne a̱ma ya̱hn ye chihcoma̱n ye dehtenduh che ritahno ye ro mena̱n, ne chitahno ye Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ta̱hn min ne, chihnde a̱ma ihyan nda̱hta ya̱n Jope che ritahno ye Dihvo vo Jesucristo. Ihyan min ne, duche ye Tabita, ne che deva̱co griego ne, Dorcas. A̱ma ndah ihyan ye, ne a̱ma yeno ye, rinan ye ihyan cheva̱h. ");
INSERT INTO cutNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Cheta̱h cah ihyan min, ne chih ye. Chihno na̱no ihyan tena̱hn me ne, chacondihte ndah ye ihyan chete cua̱rto che va na̱n o cuahto. ");
INSERT INTO cutNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Checadino ihyan che ritahno ye Dihvo vo che ya̱n Lida quenan Pedro, ne nducote nino ya̱n min ne, tahve ye o ihyan che ca̱hn ye, ngua ye ihyan, ne ra̱hn ye: ―Cuhn vo nduco ne ya̱n Jope tenun tenun no. ");
INSERT INTO cutNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Tuhme cuahn Pedro nduco ihyan chahn, ne cuahn che nda̱ ye min ne, quenda ihyan chahn ihyan chete vah na̱n che quendite tena̱hn me. Min chenun nducoya̱ca nda̱hta va̱h, a̱ma raco ye, ne na̱hme ye Pedro vestido ma̱n, coya̱no ma̱n, che nda̱hyon tena̱hn me ro che quenan ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Chihquentiyon Pedro che ndiquenda̱h vah nducoya̱ca ihyan chahn, ne chentihya ye, cova̱h ye. Ndihchero ye tena̱hn me, ne ra̱hn ye: ―Tabita, cuenecuen. Ndeta̱hno na̱hne ye ndutina̱n ye, ne ndihchero ye Pedro, ne necuan ye, va ye na̱n yundo. ");
INSERT INTO cutNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Tuhme cheta̱h Pedro ta̱h ye, ne ndedecuan ye ihyan. Cah ye nducoya̱ca ihyan che ritahno ye Dihvo vo Jesucristo ma̱n, nda̱hta va̱h chahn ma̱n, ne na̱hme ye ihyan nda̱hta me che a ntuche ye va̱n tena̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nducoya̱ca ihyan ya̱n Jope ne, checadino ye yahn vederihno me, ne a̱ma ya̱hn ye chitahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ra̱hn quenan Pedro min ya̱n Jope, ndeva̱co Simón, a̱ma sa̱hn che redin dave se ima. ");
INSERT INTO cutNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Min ya̱n Cesarea chihnde a̱ma capitá̱n che duche se Cornelio, che ndi cuande se compañia che duche Italiana. ");
INSERT INTO cutNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Sa̱hn min nduco nducoya̱ca ihyan yahn se che chenun ye ndeva̱co se ne, rendeva se yavena̱n Dendiohs numacuahn vedenecun. A̱ma reca̱h se tume che rinan se ihyan nación yahn Israel, ne reva̱h se ro ro. ");
INSERT INTO cutNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A̱ma ro, tenduh na̱n rahco ino a chino ne, chinahn a̱ma vederihno na̱n se, ndihchero ndah se a̱ma ángel yahn Dendiohs che chenda̱ ye na̱n quenun se, ne ya̱hve ye sa̱hn: ―¡Cornelio! ");
INSERT INTO cutNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A̱ma dihya se chi, ndihchero se ángel me, ne tumerune se ihyan: ―Dihvé, ¿deh nahn ne ne? Ndahconan ángel me yahn se: ―Dendiohs, a chihnevan ye che revah, ne ndihchero ye che redin vedeva̱hino nduco ihyan cheva̱h. ");
INSERT INTO cutNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ma̱n ne, cuedechoh ihyan che ca̱hn ye ya̱n Jope, ngua ye Simón che namin duche ye Pedro. ");
INSERT INTO cutNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Quenan ye a̱ma vah che nti nino nuniya̱hn, va̱co a̱ma sa̱hn redin dave ima che namin duche se Simón. Ihyan min ca̱hma ye co ye di deh che va che din. ");
INSERT INTO cutNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cuahn che cona̱hn ángel me ne, cah Cornelio o sa̱hn deca̱hya yahn se nduco a̱ma sanda̱do che quenan se ndeva̱co se che namin ritahno se Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Chihno neca̱h cuande se sa̱hn nducuahn ne, dechuh se sa̱hn ya̱n Jope. ");
INSERT INTO cutNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ta̱ma ro me ne, tenduh na̱n inguiya̱hn ne, cuahn che a cuahn nino sa̱hn chahn ya̱n Jope ne, cocha Pedro tin vah yuto na̱n che quenan ye, ca̱va che cova̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A̱ma chi cuico ye, ne numanahn che rindah che cheh ye ne, chinahn a̱ma vederihno na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ndihchero ye na̱n ro a̱ma che deca̱ ro a̱ma tino chahte tihca̱ ro che nechiche nduh che cun esquina yahn, ne cochahn cua̱hn ndiya̱hn nino na̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Min chete tino me chenun nducoya̱ca na̱n ite che cun ca̱h te ma̱n, cu ma̱n, ya̱hda ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tuhme chihnevan ye a̱ma ndudo che ra̱hn: ―Pedro, cuihne ite sih, cocheh ite. ");
INSERT INTO cutNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ate ndahconan Pedro: ―Dihvé, hua, te u ne, nde menahn metah chéh nde a̱ma na̱n ite che chihnga̱ te. ");
INSERT INTO cutNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ndaconan ndudo me: ―Cha che a nedin dave Dendiohs ne, hua quendi ndedecadine che chihnga̱. ");
INSERT INTO cutNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ino yune ndaconan ndihchero ye vederihno me. Tuhme conda̱ tino me cua̱hn na̱n ro. ");
INSERT INTO cutNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nahmin che a̱ma rendedecadino Pedro deh conahn vederihno me ne, sa̱hn che dechuh Cornelio ne, a nda̱ se chendevah, retumerune se ti che va̱co Simón. ");
INSERT INTO cutNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tuhme tumerune se a min quenan a̱ma ihyan che duche ye Simón che namin duche ye Pedro. ");
INSERT INTO cutNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Rendedecadino ca Pedro yahn vederihno me cuahn che ya̱hve Vaco Ndah yahn Dendiohs ihyan: ―Nda̱ ino se, rinuhn se di. ");
INSERT INTO cutNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Cuenchehn, ne cuehn nduco se. Dehve rahque, te u dechúh sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tuhme cuenchahn Pedro cua̱hn na̱n che vatendi sa̱hn che dechuh Cornelio, ne ra̱hn ye ri ye sa̱hn: ―U che rinuhn nchuhn. ¿Deh ntiyon cochi ne ne? ");
INSERT INTO cutNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ndahconan sa̱hn chahn: ―Huate, capitá̱n Cornelio dechuh ye nuhn. Ihyan min ne, a̱ma ndah ihyan ye, ne rendeva ye yavena̱n Dendiohs. Nducoya̱ca ihyan nación yahn Israel ne, yahino ye ihyan. Ra̱hn a̱ma ángel yahn Dendiohs ri ye ihyan che dechuh ye chehua ndih, ca̱va che ca̱hn ne ndeva̱co ye, cahnevan ye deh che va che ca̱hma ne co ne ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tuhme ra̱hn Pedro che conda̱ sa̱hn chahn chete vah, ne chahtenan se nduco ye. Nde ta̱ma ro me cuahn ye nduco se, nduco neve ihyan ya̱n Jope che ritahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Na̱n che chi o ro me ne, nda̱ ihyan chahn ya̱n Cesarea, ne quenan rino Cornelio nduco nducoya̱ca ihyan yahn se ma̱n, amigo yahn se ma̱n, che ndiya̱hve se. ");
INSERT INTO cutNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuahn che nda̱ nino ihyan chahn va̱co Cornelio ne, quenda̱h se vah ca̱va che nevahnecun se Pedro, ne chehntihya se na̱n ye, rendeva se yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ate ndedecuan Pedro sa̱hn, ne ra̱hn ye: ―Cuenecuen, cuandi. Hua nda̱hca̱ che ndeva yavená̱n, te u ne, ihyan iyehnse u nduhca̱ di. ");
INSERT INTO cutNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ca ra̱hn ca rica ye, chenda̱ ye chete vah, ne ndihche ye che a̱ma ya̱hn ihyan ndi da̱ma ye min. ");
INSERT INTO cutNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tuhme ra̱hn ye ri ye ihyan chahn: ―Nchuhn ne, a devano ne te ca̱hnda va yahn nuhn, ihyan nación yahn Israel, che ca̱hn nuhn ndeva̱co ihyan ta̱ma nación ma̱n, che conduco nuhn ihyan chahn ma̱n. Ate Dendiohs ne, te ye, checadinó te hua quendi ndedecadinó che hua nda̱hca̱ che coda̱ma nuhn nduco ihyan ta̱ma nación. ");
INSERT INTO cutNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Chemin che cuahn che tahve nchuhn che chehua u ne, ndeta̱hno cochí, hua chacotá̱hn. Ma̱n ne, nahn cadinó deh cuande che tahve ne che chehua u. ");
INSERT INTO cutNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Tuhme ndahconan Cornelio: ―A ma̱n cun ro, co tenduh ura cuh ne, va ya̱hté ma̱n, revá̱h ma̱n, muhn chete va̱có, cuahn che chihnde ro a̱ma ángel, quenun ye tino che tuno diya̱hn ro. ");
INSERT INTO cutNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ra̱hn ye ri ye u: “Cornelio, chihnevan Dendiohs che revah, ne ndihchero ye che redin vedeva̱hino nduco ihyan cheva̱h. ");
INSERT INTO cutNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ma̱n ne, cuedechoh nde ya̱n Jope che ngua Simón che namin duche ye Pedro. Quenan ye a̱ma vah che nti nino nuniya̱hn, ndeva̱co a̱ma sa̱hn che redin dave ima, che namin Simón duche se.” ");
INSERT INTO cutNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Chemin che a ndeta̱hno dechúh che chehua ndih. Nda̱hca̱ din ne che cochi ne. Ma̱n ne, nto da̱ma nducoya̱ca nuhn muhn na̱n Dendiohs ca̱va che cahnevan nuhn nducuahn che chihquentiyon ye che ca̱hma ne. ");
INSERT INTO cutNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tuhme cahndudo Pedro: ―Ma̱n ne, a chenáhn te Dendiohs che cua̱co niyon ne, hua retenda̱h nun ye ihyan, ");
INSERT INTO cutNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","te da̱ma no yahino ye nducoya̱ca ihyan adecotino nación yahn ye, ndete che rendeva ye yavena̱n ye ma̱n, redin ye che ndah ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dendiohs ne, dechuh ye Jesucristo, Dihve nducoya̱ca ihyan, va̱n ihyan nación yahn Israel, ca̱va che cuahndudo ye ndudo ndah yahn che ndo ya̱n Dendiohs nduco ihyan iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nchuhn ne, a devano ndah ne yahn nducuahn che coma̱n chinahn numachahte nación yahn Israel, cana̱n nde esta̱do yahn Galilea, cuahn che a chuh che cahndudo Jua̱n Bautista ma̱n, chehdenune ye ihyan ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","A devano ne te Dendiohs ne, din ye che quenun Vaco Ndah yahn ye Jesucristo yahn ya̱n Nazaret, ne nda̱hco ye vederihquentiyon chahte ta̱h ye. Ihyan min ne, quechica ye, redin ye che ndah, ne rendedevahn ye ihyan che rechuhrihn ye, redin chundah. Tihca̱ redin ye, te quenan cuma ye vederihquentiyon yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Nuhn racotuhn nuhn ndudo cua̱co yahn nducuahn che din Dihvo vo Jesucristo numachahte nación yahn Israel ma̱n, ya̱n Jerusalén ma̱n. Ihyan min ne, nahn ya̱h se ihyan na̱n a̱ma cruz, chihno se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ate chihno ino ro ne, ndedetuhche Dendiohs ihyan, ne cahnecun ye che quechica ro ye va̱n nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Hua quechica ro ye va̱n nducoya̱ca ihyan ya̱n, ate quechica ro ye va̱n nuhn che a tenda̱h nun Dendiohs nuhn nde ro mena̱n ca̱va che cuacotuhn nuhn ndudo yahn che tihca̱ chi. Cuahn che a ntuche ye va̱n tena̱hn ne, da̱ma cheh nuhn, da̱ma chih nuhn nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Chihquentiyon ye che cuahndudo nuhn na̱n ihyan che nda̱hco Dendiohs vederihquentiyon ta̱h ye ca̱va che teche ca̱de ye yahn nducoya̱ca ihyan che chenduche ye ma̱n, che ndih ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A yahn ihyan min che dirun nducoya̱ca ihyan profeta nde a ra̱hn me. Dirun ye te nducoya̱ca ihyan che cotahno ye ihyan min ne, nchahco Dendiohs nunde yahn ye che cuande yahn ihyan min. ");
INSERT INTO cutNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nde metah cuihno cuahndudo Pedro cuahn che quenun Vaco Ndah yahn Dendiohs nducoya̱ca ihyan che rihnevan ye ndudo me. ");
INSERT INTO cutNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ihyan nación yahn Israel che ritahno ye Dihvo vo che nduco ye Pedro ne, a̱ma cuahn ino ye chi yahn che quenun Vaco Ndah yahn Dendiohs nde ihyan ta̱ma nación. ");
INSERT INTO cutNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Devano cua̱co ye te quenun Vaco Ndah yahn Dendiohs ihyan chahn, te rente ye ta̱ma te o na̱n deva̱co ma̱n, rendeva ye yavena̱n Dendiohs ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Chemin che ra̱hn Pedro: ―¿A va duh che ca̱hco ta̱n che cuedenune ihyan chuhn?, te a quenun Vaco Ndah yahn Dendiohs ihyan nduhca̱ che quenun uvo. ");
INSERT INTO cutNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tuhme chihquentiyon ye che cuedenune ihyan chahn, cuah ye Dihvo vo Jesucristo. Chihno min ne, chica ihyan chahn favor Pedro che conan ye neve ro nduco vih. ");
INSERT INTO cutNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ihyan apóstol chahn nduco ihyan che ritahno ye Dihvo vo Jesucristo che vate ye esta̱do yahn Judea ne, checadino ye te nde ihyan ta̱ma nación a chitahno ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cuahn che nta̱ Pedro ya̱n Jerusalén ne, ihyan nación yahn Israel che ritahno ye Dihvo vo ne, ra̱hva ye nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tumerune ihyan chahn: ―¿Dehco che chehn va̱co ihyan ta̱ma nación, cheh da̱ma nduco ye ne? ");
INSERT INTO cutNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Tuhme neca̱h cuande Pedro ihyan chahn nducuahn che chi: ");
INSERT INTO cutNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―A̱ma ro cuahn che quenán ya̱n Jope ne, ura che revá̱h ne, chinahn a̱ma vederihno ná̱n. Ndihcheró a̱ma che deca̱ ro tino chahte tihca̱ ro, ne nechiche nduh che cun esquina yahn, chica na̱n ro, cochahn cua̱co na̱n che quenún. ");
INSERT INTO cutNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Cuahn che chihco ndáh cuda̱do deh chenun chete ne, ndihcheró ite che cun ca̱h te ma̱n, ite chano ma̱n, cu ma̱n, ya̱hda ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ne chihneván ndudo che ra̱hn: “Pedro, cuihne ite sih, cocheh ite.” ");
INSERT INTO cutNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ate ndahconán: “Dihvé, hua, te nde menahn metah chéh nde a̱ma ite che chihnga̱ te.” ");
INSERT INTO cutNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Tuhme ndaconan ndudo me nde na̱n ro: “Cha che u, Dendiohs, a nedin davé ne, hua quendi ndedecadine che chihnga̱.” ");
INSERT INTO cutNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ino co ndaconan chinahn vederihno me ná̱n, ne conda̱ cua̱hn na̱n ro. ");
INSERT INTO cutNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","A ura min no nda̱ ino se che rinuhn se u, che chica se nde ya̱n Cesarea. ");
INSERT INTO cutNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Chihquentiyon Vaco Dendiohs che hua dehve ra̱hcó, cá̱hn nduco se. Namin a̱n dino vo chuhn ne, chinduco ye u, chahn nuhn va̱co a̱ma sa̱hn, ");
INSERT INTO cutNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","che nte cuande se nuhn che ndihchero se a̱ma ángel che chandi ye, chihto na̱n se ndeva̱co se, ne tuhca̱ ra̱hn ye ri ye sa̱hn: “Cuedechoh che ngua Simón che namin duche ye Pedro, quenan ye ya̱n Jope. ");
INSERT INTO cutNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ihyan min ca̱hma ye co ye di nduco ihyan yehn deh va che din nchuhn ca̱va che ndevahn ne.” ");
INSERT INTO cutNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Cuahn che chihno nte sa̱hn min ne, cana̱n cahndudó. Ate numanahn che cahndudó ne, adena̱n quenun Vaco Ndah yahn Dendiohs ihyan chahn nduhca̱ che quenun uvo ro mena̱n me. ");
INSERT INTO cutNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tuhme neca̱hcó che ra̱hn Dihvo vo: “Jua̱n ne, chehdenune ye ihyan, ate nchuhn ne, conun Vaco Ndah yahn Dendiohs nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nducote ma̱n Dendiohs din ye nduco ihyan chahn nduhca̱ che din ye nduco uvo che chitahno vo Dihvo vo Jesucristo ne, ¿duh u ca̱va che din va̱hché yahn Dendiohs? ");
INSERT INTO cutNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Cuahn che chihnevan ihyan chahn ne, chahtedihn chende ye, ne ndeva ye yavena̱n Dendiohs, ne ra̱hn ye: “Tuhme ne, rahnecun Dendiohs che nto ino ihyan ta̱ma nación nunde yahn ye, cuahtenan ye vahchetero numacuahn ro.” ");
INSERT INTO cutNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cuahn che chuh che chih Esteban ne, cana̱n redin ta̱n ihyan nduco ihyan che ritahno ye Dihvo vo, ne chano ihyan chahn. Na̱hn ye ne, cuahn ye nde nación yahn Fenicia ma̱n, Chipre ma̱n, ya̱n Antioquía ma̱n. Min chacotuhn ye Ndudo yahn Dendiohs atena̱n va̱n ihyan nación yahn Israel, te va̱n ihyan ta̱ma nación ne, hua chacotuhn ye ndudo me. ");
INSERT INTO cutNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ate neve ihyan nación yahn Chipre ma̱n, ya̱n Cirene ma̱n, cuahn ye ya̱n Antioquía, ne ihyan chahn chacotuhn ye ndudo ndah yahn Dihvo vo Jesucristo nde va̱n ihyan ta̱ma nación. ");
INSERT INTO cutNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nducote chenan cuma ihyan chahn vederihquentiyon yahn Dihvo vo ne, a̱ma ya̱hn ihyan chihcoma̱n ye dehtenduh che ritahno ye ro mena̱n me, ne chitahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cuahn che checadino ihyan che ritahno ye Dihvo vo che chenan ye ya̱n Jerusalén ne, dechuh ye Bernabé nde ya̱n Antioquía. ");
INSERT INTO cutNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cuahn che nda̱ Bernabé min ne, ndihchero ye che a̱ma va vedeyahino yahn Dendiohs va̱n ihyan chahn, ne a̱ma chi yeno ye. Ya̱hve ye ihyan chahn che quendi ye numa ino ye vederihquentiyon yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tihca̱ din Bernabé, te a̱ma ndah ihyan ye ma̱n, quenun Vaco Ndah yahn Dendiohs ihyan ma̱n, numa ino ye ritahno ye ma̱n. Ya̱n min ne, a̱ma ya̱hn ihyan chitahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Chihno min ne, cuahn Bernabé ya̱n Tarso, ngua ye Saulo. Cuahn che nta̱ca ye ihyan ne, ndaconan ye nduco vih ya̱n Antioquía. ");
INSERT INTO cutNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Min chahtenan ye a̱ma nduyo nduco ihyan che ritahno ye Dihvo vo, chicuahn ye a̱ma ya̱hn ihyan. Min ya̱n Antioquía cade cana̱n ihyan ra̱hn ye yahn ihyan che ritahno ye Dihvo vo Jesucristo te cristia̱no ye. ");
INSERT INTO cutNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ta̱hn min ne, a̱ma o ihyan che recadino ye yahn che va che co ne, chica ye ya̱n Jerusalén, ne nda̱ ye min ya̱n Antioquía. ");
INSERT INTO cutNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A̱ma cha ihyan chahn che duche ye Agabo ne, din Vaco Dendiohs che checadino ye che a̱ma cuhnde cuico numachahte iyehnse. Chandi ihyan min na̱n ihyan che ritahno ye Dihvo vo, ne ra̱hn ye che tihca̱ va che co. Ndudo min ne, chinahn adive cuahn que quenan Claudio emperador. ");
INSERT INTO cutNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Tuhme ihyan che ritahno ye Dihvo vo Jesucristo che vate ye min ya̱n Antioquía ne, nte ca̱de ye nduco vih che nedin da̱ma ye tume nduhva che tuno ta̱h ye, dechuh ye yahn dihno vo che vate ye esta̱do yahn Judea ca̱va che conan ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Tihca̱ din ihyan chahn, ne dechuh ye Bernabé nduco Saulo, quenda ye tume me, neca̱h ye ta̱h intiyahn ya̱co che vate ye min. ");
INSERT INTO cutNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ta̱hn min ne, redin ta̱n rey Herodes nduco ihyan che ritahno ye Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jacobo, dihno Jua̱n ne, chihquentiyon rey me che chihno se ihyan nduco espa̱da, ");
INSERT INTO cutNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ne nducote ndihchero se che quenan ino ihyan nación yahn Israel ne, namin din se preso Pedro. Ro che tihca̱ din se ne, ro vihco che reh ihyan pa̱n che hua nduco ya̱ yahn. ");
INSERT INTO cutNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Cuahn che a din se preso Pedro ne, chaconuhn se ihyan va̱coya̱hn, ne ntihyon a̱ma sanda̱do chahtenan se cuda̱do ihyan, te chuh vihco me ne, nahn tenda̱h se ihyan, techeca̱de se yahn ye, ne ca̱hno se ihyan na̱n ihyan ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","A̱ma vateya̱n sanda̱do che redin se cuda̱do Pedro che quenun ye va̱coya̱hn, ne ihyan che ritahno ye Dihvo vo ne, reva̱h ye numa ino ye ca̱va ye. ");
INSERT INTO cutNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Vino che co dave ta̱ma ro me che nahn tenda̱h Herodes Pedro na̱n ihyan ya̱n ne, quiya̱do ye chete va̱coya̱hn me menda̱hn yahn o sanda̱do, nchiche ye nduco o cadena. Sanda̱do chena̱hn chahn ne, redin se cuda̱do chende va̱coya̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Adena̱n chenda̱ a̱ma ángel yahn Dihvo vo Dendiohs chete va̱coya̱hn me, ne a̱ma chiya dave. Denuhn nun ángel me Pedro, ndedetuhche ye ihyan, ne ra̱hn ye ri ye ihyan: ―Cuenecuen tenun tenun no. Ndeta̱hno nta̱hte cadena che nchiche ta̱h Pedro, ");
INSERT INTO cutNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ne ra̱hn ángel me: ―Conda̱hco chiche ima che renan chete, ne condonun cah nda̱co yehn. Cuahn che a va ya̱n Pedro ne, ndaconan ra̱hn ángel me: ―Condonon tino tu yehn, ne cuiquendi u, cuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro ne, quendi ye ángel me, nde hua devano ye a cua̱co chemin, te rihno ye che ra̱hco ye. ");
INSERT INTO cutNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Chuh ye o cua̱n na̱n che chenun sanda̱do, redin se cuda̱do, ne cuahn che nda̱ ye chendevah cu che a renda̱ na̱n ca̱lle ne, na̱ne ma̱n chendevah me. Ndiquenda̱h ye, chica ca ye tah, ne cona̱hn ángel me. ");
INSERT INTO cutNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tuhme chenahn Pedro, ne ndedecadino ye: ―Ma̱n ne, a devano cua̱có te Dendiohs tahve ye a̱ma ángel yahn ye ca̱va che ndedevahn ye u ta̱h Herodes ma̱n, yahn nducuahn che chenan ino ihyan nación yahn Israel che cuahno có ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pedro ne, ca rendedecadino ye yahn che tihca̱ chi, ca rica ye, cuahn ye ndeva̱co María, chaco Jua̱n Marcos. Min ndi da̱ma a̱ma ya̱hn ihyan, reva̱h ye. ");
INSERT INTO cutNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cuahn che nda̱ ye min ne, reca̱h ta̱h ye chendevah chahte ma̱n, riya̱hve ye ma̱n. Cuahn a̱ma ta̱hn dihn che duche te Rode, quendihchero te duh che riya̱hve. ");
INSERT INTO cutNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ate cuahn che ndonahn te ndudo Pedro ne, nducote a̱ma yeno te ne, nde hua na̱hne te chendevah me. Ndaconan te, rano te, ngu te ndudo che nti Pedro chendevah. ");
INSERT INTO cutNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ihyan chahn ne, ra̱hn ye ri ye ta̱hn: ―¡Luco ri di, ta̱hn dihn! Ate ta̱hn min ne, ra̱hn te te cua̱co che ihyan min. Tuhme ra̱hn ihyan chahn: ―Ndiyu ihyan min. Co ángel che redin cuda̱do ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Numanahmin ne, quendi Pedro, reca̱h ta̱h ye chendevah. Cuahn ihyan chahn na̱hne ye chendevah me, ne cuahn che ndihchero ye Pedro ne, a̱ma cuahn ino ye chi. ");
INSERT INTO cutNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ate din ta̱h Pedro yahn ihyan chahn che cuahte dihn chende ye nahmin che neca̱h cuande ye nduhca̱ che ndetenda̱h Dendiohs ihyan va̱coya̱hn. Namin ra̱hn ye: ―Ca̱hma nchuhn co ne Jacobo ma̱n, dihno vo chena̱hn ma̱n, nduhca̱ che chi. Tuhme chica ye min, cuahn ye ta̱ma cua̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cuahn che chi dave ta̱ma ro me ne, a ri rite co luco sanda̱do chahn, te hua devano se deh chi nduco Pedro. ");
INSERT INTO cutNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes ne, dechuh ye che chinuhn Pedro, ne nducote hua nta̱ca ihyan ne, chica ye sa̱hn chahn che neca̱h cuande se ihyan deh chi. Tuhme chihquentiyon ye sanda̱do chena̱hn che ca̱hno se sa̱hn. Chihno min ne, chica Herodes min esta̱do yahn Judea, ne cuahn ye quenan ye ya̱n Cesarea. ");
INSERT INTO cutNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes ne, ta̱n ye nduco ihyan ya̱n Tiro ma̱n, ihyan ya̱n Sidón ma̱n, ate ihyan chahn ne, ntuhno ye ca̱va che ca̱hn ye na̱n Herodes. Ya̱hve ye a̱ma sa̱hn ndina̱n yahn rey me che duche se Blasto, che ca̱hma nan se ihyan, ca̱va che ndoya̱n rey me nduco ye. Tihca̱ din ihyan chahn, te na̱n ya̱hn yahn rey me, rica dehtenduh che reh ye. ");
INSERT INTO cutNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes ne, chihco vih ye a̱ma ro ca̱va che ndo da̱ma ihyan chahn, ne nda̱ ro min ne, ndonun ye tino che renun ye ura che retecheca̱de ye. Chihnde ye na̱n che rihquentiyon ye, ne cahndudo ye, chihnevan ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tuhme rendeva ihyan chahn yavena̱n rey me, ne rah ye: ―Ihyan tih che rahndudo ye ne, ¡ndiyu ihyan iyehnse ye, te Dendiohs ye! ");
INSERT INTO cutNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","A ura min no chiya a̱ma ángel yahn Dendiohs, ne din ye che cheta̱h cah Herodes. Chine nda̱h ihyan, ne a̱ma yah vederih chih ye, te ca̱h yune ye che ndeva ihyan yavena̱n ye, nduhca̱ ndete che ihyan min che Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ta̱hn min ne, a̱ma retuhn ndudo yahn Dihvo vo Jesucristo, ri ya̱hn ihyan che ritahno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Cuahn che a dinahn Bernabé nduco Saulo ntiyon che chahn ye ne, nda̱ca ye ya̱n Jerusalén, cona̱hn ye ya̱n Antioquía, quenda nduco ye Jua̱n Marcos. ");
INSERT INTO cutNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Va̱n ihyan che ritahno ye Dihvo vo Jesucristo, che vate ye ya̱n Antioquía ne, chenun va̱n ihyan che rahndudo ye Ndudo yahn Dendiohs ma̱n, ihyan ricuahn ma̱n. Ihyan chahn ne, Bernabé ma̱n, Saulo ma̱n, Simón cuan ma̱n, Lucio yahn ya̱n Cirene ma̱n, Manaén ma̱n, ihyan min che chihta ye da̱ma nduco Herodes, gobernador yahn Galilea. ");
INSERT INTO cutNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","A̱ma ro che vate ihyan chahn ya̱hte ma̱n, reva̱h ye ma̱n ne, ra̱hn Vaco Ndah yahn Dendiohs nduco ye: ―Cuedechuh nchuhn Bernabé nduco Saulo che ca̱hn se, din se ntiyon che a necá̱h che din se. ");
INSERT INTO cutNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tuhme chahte tun ihyan chahn ya̱hte, ne cova̱h ye. Chihno min ne, nahn ta̱h ye ihyan che o chahn ca̱va che nuhnde ta̱h ye ntiyon min, ne dechuh ye ihyan, cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bernabé nduco Saulo ne, cuahn ye ya̱n Seleucia nduhca̱ che chihquentiyon Vaco Ndah yahn Dendiohs. Min chahtenun ye a̱ma ba̱rco, ne cuahn ye ya̱hn yahn Chipre. ");
INSERT INTO cutNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cuahn che nda̱ ihyan chahn ya̱n Salamina ne, cana̱n rahndudo ye Ndudo yahn Dendiohs chete ya̱co. Jua̱n Marcos ne, nduco se ihyan chahn, rinan se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Chahtechica ye numachahte ya̱hn min, ne nda̱ ye ya̱n Pafos. Min nta̱ca ye a̱ma sa̱hn, nda̱ta yahn Israel, che duche se Barjesús. Sa̱hn min ne, cuah se, ne redin ca̱ se che Dendiohs rinan ye sa̱hn. ");
INSERT INTO cutNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nduco se gobernador Sergio Paulo, a̱ma ihyan che renahn ye. Ihyan min ne, tahve ye che chehua Bernabé nduco Saulo, te nahn cahnevan ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ate sa̱hn cuah me, che namin duche se Elimas ne, redin va̱hche se yahn ihyan chahn, te hua nahn se che cotahno gobernador me. ");
INSERT INTO cutNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tuhme Saulo, che namin duche ye Pa̱blo ne, quenun Vaco Ndah yahn Dendiohs ihyan. Ndihche ro ndah ye sa̱hn, ");
INSERT INTO cutNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ne ra̱hva ye nduco se: ―Di, ¡da̱ya chundah! ¡A̱ma duhtuno ihyan di! ¡Ndere quechique, rihncheh! ¡Hua renan ine nde a̱ma dehtenduh che ndah! ¿Dehco che hua reguen, redetohnen vederihquentiyon yahn Dendiohs? ");
INSERT INTO cutNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ma̱n ne, Dendiohs din ye castigo di. Co ve nan, ne hua co ro nan. Ndeta̱hno chiya man na̱n se, ametah chi ro na̱n se. Cana̱n rinuhn ta̱h se duh che quendanan sa̱hn, te hua ro na̱n se. ");
INSERT INTO cutNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cuahn che ndihchero gobernador me che tihca̱ chi ne, chitahno ye Dihvo vo Jesucristo, te a̱ma rahn ino ye yahn ndudo yahn Dihvo vo che ricuahn ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pa̱blo nduco combiero yahn ye ne, chahtenun ye a̱ma ba̱rco, ne chica ye ya̱n Pafos, nda̱ ye ya̱n Perge, ya̱hn yahn Panfilia. Jua̱n Marcos ne, chihcoma̱n se ihyan chahn, ne cona̱hn se ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ihyan chahn ne, quendi ye yune yahn ye, chica ye ya̱n Perge, ne nda̱ ye ya̱n Antioquía, ya̱hn yahn Pisidia. A̱ma ro che rahte tuhno ihyan ne, chenda̱ ye chete ya̱co yahn ihyan nación yahn Israel, chahte ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Cuahn che a chihno cahndudo ihyan ley che dirun Moisés ma̱n, ndudo che dirun profeta ma̱n ne, ihyan ndina̱n yahn ya̱co me ne, dechuh ye ndudo yahn ihyan chahn: ―Dihno nuhn, ndete che va ndudo che ca̱hma ne nduco ihyan ne, co ca̱hma ne meniyon. ");
INSERT INTO cutNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Tuhme necuan Pa̱blo, ne din ta̱h ye che cuahteya̱n ihyan chahn, ne cahndudo ye: ―Nchuhn, nda̱ta yahn Israel, che rendeva ne yavena̱n Dendiohs, cuihnevan ne. ");
INSERT INTO cutNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Dendiohs yahn nación yuhn vo Israel ne, tenda̱hnun ye ihyan ndico yuhn vo. Cuahn che chenan ca ihyan chahn nación yahn Egipto ne, din ye che a̱ma chi ya̱hn ye, ne ndetenda̱h ye ihyan numacuahn vederihquentiyon yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Cuahn che chenan ihyan chahn ya̱hn na̱n che metah duhva ne, din chahtino Dendiohs yahn ye tenduh o raco nduyo, ");
INSERT INTO cutNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ne decuihno ye ndache nación min ya̱hn yahn Canaán, ne ca̱h ye ya̱hn min ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Cana̱n nde ro min, chete che cun ciento quenan o raco ndiche nduyo, nde ro che quenan ihyan profeta Samuel ne, raconahn Dendiohs juez che rihquentiyon ye ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tuhme chica ihyan chahn a̱ma rey ca̱va che ca̱hcantiyon ye ihyan, ne cahnecun Dendiohs. Chaconahn ye Saúl, da̱ya Cis, nda̱ta yahn Benjamín, ca̱va che co se rey yahn ihyan chahn o raco nduyo. ");
INSERT INTO cutNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Cuahn che tuno ro ne, Dendiohs ne, chehnevi ye Saúl. Ca̱h ye vederihquentiyon me David, ne ra̱hn ye: “David, da̱ya Isaí ne, a̱ma sa̱hn che renevahnecun se che náhn, ne dinahn se nducuahn che ca̱hcantiyón.” ");
INSERT INTO cutNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Va̱n nda̱ta yahn David ne, ndedecuan Dendiohs Jesucristo, nduhca̱ che a ca̱h ye ndudo yahn ye ca̱va che ndedevahn ye ihyan nación yahn Israel. ");
INSERT INTO cutNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Numanahn che metah nda̱ Jesucristo ne, nda̱ Jua̱n, cahndudo ye che nto ino nducoya̱ca ihyan nación yahn Israel nunde yahn ye, ne cuedenune ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Cuahn che a nino cuihno ntiyon yahn Jua̱n ne, ra̱hn ye: “Co ra̱hco nchuhn te u ne, ihyan che chenan rino ne, ate ndiyu u, te adive ne, cochi a̱ma ihyan che a̱ma yudo vederihquentiyon yahn ye. U ne, nde hua rigonun chihve u ca̱va che co mozo yahn ihyan min, nta̱hte correa yahn nda̱co yahn ye.” ");
INSERT INTO cutNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Nchuhn dihnó, nda̱ta yahn Abraham, che rendeva ne yavena̱n Dendiohs, a dechuh ye ndudo cuh yahn ne ca̱va che ndevahn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ihyan ya̱n Jerusalén nduco ihyan ndina̱n yahn ye ne, hua checadino cua̱co ye deh vederihquentiyon quenan cuma Dihvo vo Jesucristo, nde hua chenahn ye che dirun ihyan profeta, andahre ndate ndate, ro che rahtetuhno ihyan, rihnevan ye ndudo min, rahndudo ihyan chete ya̱co. Chemin che chihco ca̱de ye che ca̱hno se ihyan min, ne nduco chemin chinahn nducuahn che dirun ihyan profeta chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Andahre metah nde a̱ma nunde yahn Dihvo vo, ate chica ihyan chahn che ca̱hcantiyon Pila̱to che ca̱hno sanda̱do ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Cuahn che a din ihyan chahn nducuahn che a va ca̱de che cuahno Dihvo vo co, nduhca̱ che a ndirun na̱n Ndudo yahn Dendiohs ne, ndedevah ye ihyan na̱n cruz, ne chacondihte ye ihyan chete a̱ma ya̱yan. ");
INSERT INTO cutNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ate Dendiohs ne, ndedetuhche ye ihyan va̱n tena̱hn, ");
INSERT INTO cutNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ne a̱ma ndeh ro chinduco ye ihyan che chica ye esta̱do yahn Galilea, nda̱ ye nduco ye ya̱n Jerusalén. Ma̱n ne, a ihyan chahn che racotuhn ye ndudo yahn ihyan min va̱n nducoya̱ca ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Namin nuhn ne, rahndudo nuhn na̱n nchuhn yahn ndudo ndah che ca̱h Dendiohs ihyan ndico yuhn vo. ");
INSERT INTO cutNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ma̱n ne, a dinahn Dendiohs ndudo min, te a ndedetuhche ye Dihvo vo Jesucristo ca̱va uvo, nduhca̱ che a ndirun na̱n Salmo o tuhca̱: “Di che Da̱yá. Ma̱n ro cuh ne, a chihco ró di na̱n nducoya̱ca ihyan, ca̱va che codevano ye te Da̱ya má̱n di.” ");
INSERT INTO cutNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Namin ta̱ma cua̱n na̱n Ndudo yahn Dendiohs a ndirun tuhca̱: “U, Dendiohs, din yahinó nchuhn nduhca̱ che a cá̱h ndudo yáhn David.” Nduco ndudo cuh ne, chihco ro ye che ndedetuhche ye Dihvo vo Jesucristo va̱n tena̱hn ca̱va che hua cha̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Namin va ta̱ma ndudo che ndirun na̱n ta̱ma Salmo tuhca̱: “Hua cuahnecun ne che cha̱ Da̱ya ne.” ");
INSERT INTO cutNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Me David ne, a devano vo che, nduhca̱ che chihquentiyon Dendiohs ne, chichihve ye na̱n ihyan che vate ye ro che quenan ye iyehnse. Tuno ro yahn ye ne, namin chih ye nduhca̱ ihyan ndico yahn ye, ne cha̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ate ihyan min che ndedetuhche Dendiohs ihyan ne, hua cha̱ ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nchuhn, dihnó, cuedevano ne te che cuande yahn ihyan min ne, co nda̱ca ne vederenchahco yahn nunde yahn ne. Chu che rahndudo nuhn na̱n ne. ");
INSERT INTO cutNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Che cuande yahn Dihvo vo Jesucristo ne, nducoya̱ca ihyan che ritahno ye ihyan ne, renda̱ca ye vederenchahco yahn nunde yahn ye, che hua nda̱ca ihyan ro che rihquentiyon ley che dirun Moisés. ");
INSERT INTO cutNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ma̱n ne, cuihco nchuhn cuda̱do che hua conahn nduco ne nduhca̱ che dirun a̱ma cha ihyan profeta tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nchuhn che duche rino ne, condihche ne. Cuahn ino ne, ne cuih ne, te ro che vate ne ne, u, Dendiohs, dín vederihno rahte, che nde hua cotahno ne, andahre ca̱hma ihyan co ye nchuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Cuahn che ndiquenda̱h Pa̱blo nduco combiero yahn ye chete ya̱co me ne, ihyan che hua nda̱ta yahn Israel ne, chica ye che ndaconan cuahndudo ye yahn dehtenduh che tuhchan, ndate che ta̱ma, ro che rahtetuhno ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cuahn che a cona̱hn ihyan ne, a̱ma ya̱hn ihyan nación yahn Israel ma̱n, ihyan ta̱ma nación ma̱n, che ritahno ye numa ino ye nduco vih ne, cuahn ye nduco Pa̱blo nduco Bernabé. A̱ma riya̱hve ye ihyan chahn che quendi ye numa ino ye, cotahno ye, ne hua ca̱hcoma̱n ye Dendiohs, ihyan min che redin yahino ye ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ta̱ma ndate me, ro che rahtetuhno ihyan ne, ndo da̱ma a nahn numa ya̱n, ihyan che nahn cahnevan ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ate cuahn che ndihchero ihyan nación yahn Israel chahn che a̱ma ya̱hn ihyan ne, chi ve ye, ne cana̱n ruhn chende ye nduco Pa̱blo ma̱n, ra̱hn ta̱n ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tuhme Pa̱blo nduco Bernabé ne, numa ino ye ra̱hn ye ri ye ihyan chahn: ―Nchuhn, ihyan nación yahn Israel, a ca̱va nchuhn mena̱n vihca che rahndudo nuhn Ndudo yahn Dendiohs. Ate ma̱n ne, nducote hua nahn nevahnecun nchuhn ma̱n, ra̱hco ne te dehve rendotenan ne ma̱n ne, ca̱hcoma̱n nuhn nchuhn, ne cuahndudo nuhn, cahnevan ihyan ta̱ma nación. ");
INSERT INTO cutNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Va che dinahn nuhn nduhca̱ che chihquentiyon Dihvo vo Jesucristo nuhn tuhca̱: Tenda̱h nún di ca̱va che cuahndode ndudo yáhn va̱n ihyan nducuahn nación. Nde numachahte iyehnse, nducoya̱ca ihyan che nevahnecun ye ndudo yáhn, ndevahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Cuahn che chihnevan ihyan ta̱ma nación che chenun ye min che tihca̱ ra̱hn ihyan chahn ne, a̱ma chi yeno ye, ne nevahnecun ye ndudo yahn Dihvo vo Jesucristo. Va̱n ihyan chahn ne, chitahno nducoya̱ca ihyan che a va ca̱de che cuahtenan ye vahchetero numacuahn ro. ");
INSERT INTO cutNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tihca̱ chetuhn ndudo yahn Dihvo vo numachahte ya̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ate ihyan nación yahn Israel chahn ne, chinun ye a̱ma o sa̱hn na̱hn nduco a̱ma o ta̱hn nda̱hta che ndah ihyan te, che renevahnecun ihyan ya̱n ta̱hn. Tihca̱ ndedecuan ihyan chahn ihyan che chi ta̱n ye nduco Pa̱blo nduco Bernabé nde cande che ndetenda̱h ye ihyan ya̱hn min. ");
INSERT INTO cutNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tuhme chihde ihyan chahn nda̱co yahn ye, chihtera ye yuniya̱hn ca̱va che na̱hma ye ihyan ya̱n min te hua nda̱hca̱ din ye che hua nevahnecun ye Ndudo yahn Dendiohs, ne cuahn ye ya̱n Iconio. ");
INSERT INTO cutNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Me ihyan che ritahno ye Dihvo vo Jesucristo ne, a̱ma yeno ye, ne quenun Vaco Ndah yahn Dendiohs ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Cuahn che nda̱ Pa̱blo nduco Bernabé ya̱n Iconio ne, chenda̱ ye chete ya̱co, ne a̱ma nda̱hca̱ cahndudo ye. Chemin che a̱ma ya̱hn ihyan nación yahn Israel ma̱n, ihyan ta̱ma nación ma̱n, chitahno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ate ihyan nación yahn Israel che hua chitahno ye ne, chinun ye ihyan ta̱ma nación che ametah cotahno ye, ca̱va che ndihche ta̱n ye ihyan che ritahno ye Dihvo vo Jesucristo. ");
INSERT INTO cutNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","A̱ma ra̱hn chahtenan ihyan chahn min, ne rahndudo ye numa ino ye, chenan ino ye Dendiohs. Dendiohs ne, redin ye che renahn ihyan te cua̱co che yahino ye ihyan iyehnse nduhca̱ che rahndudo ihyan chahn, te ca̱h ye vederihquentiyon ihyan ca̱va che din ye vederihno. ");
INSERT INTO cutNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ihyan ya̱n min ne, o cua̱n ndi ye. A̱ma cua̱n ye ne, rinduco ye ihyan nación yahn Israel, ne ta̱ma cua̱n ye ne, rinduco ye ihyan apóstol chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tuhme ihyan nación yahn Israel chahn nduco ihyan ta̱ma nación ne, ntuhno ye nduco intiyahn ca̱va che din ta̱n ye nduco ihyan apóstol chahn, ca̱h ye tu ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ate Pa̱blo nduco Bernabé ne, checadino ye, ne chano ye, cuahn ye ya̱hn yahn Licaonia, ya̱n Listra ma̱n, ya̱n Derbe ma̱n, nduh cua̱n na̱n che nino ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Min chahtechica ye, cahndudo ye Ndudo yahn Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Min ya̱n Listra va a̱ma sa̱hn che nenevadoh ca̱h se nde ro che chihndeya̱n se, nde tah hua ri rica se. ");
INSERT INTO cutNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Sa̱hn min ne, va se, rihnevan se che rahndudo Pa̱blo. Ndihchero ndah ye sa̱hn, ne checadino ye te ritahno se che co din Dendiohs che ndoyahn se. ");
INSERT INTO cutNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Tuhme cah ye yahn se: ―Cuenecuen, cuandi cuaque. Ndeta̱hno chandi cua̱co se, ne cana̱n rica se. ");
INSERT INTO cutNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Cuahn che ndihchero ihyan ya̱n vederihno che din Pa̱blo ne, nduco deva̱co yahn ma̱n ye, deva̱co yahn Licaonia ne, rah ye: ―O dendiohs yuhn vo, nda̱conda̱ ye ihyan, chiya ye iyehnse. ");
INSERT INTO cutNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ra̱hn ihyan chahn te Bernabé ne, dendiohs yahn ye che duche ye Júpiter, ne Pa̱blo ne, Mercurio, te ihyan min che rahndudo ye. ");
INSERT INTO cutNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Chidocuya̱n yahn Júpiter che nti ya̱co yahn ye chihto ya̱n me ne, nda̱ ye, nda ye na̱nda ma̱n, itenine ma̱n, ca̱va che ca̱hno ye ite che co te vedino, ndeva ye nduco ihyan ya̱n chahn yavena̱n Bernabé nduco Pa̱blo. ");
INSERT INTO cutNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Cuahn che checadino ihyan apóstol chahn che tihca̱ ne, cana̱n rendeh ye tino yahn ye ca̱va che na̱hma ye che hua tihca̱ din ihyan chahn, ne chenda̱ ye va̱n nducoya̱ca ye, rah ye: ");
INSERT INTO cutNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¿Dehco che tihca̱ redin nchuhn?, te nuhn ne, ihyan iyehnse nuhn nduhca̱ nchuhn. A ca̱va chemin che cochi nuhn, ca̱hma nuhn nduco ne che ca̱hcoma̱n ne dehtenduh che tihchan che hua cochihve, ne cotahno ne Dendiohs, ihyan min che quenduche ye. A ihyan min che dendah ye na̱n ro ma̱n, iyehnse ma̱n, nuniya̱hn ma̱n, nducuahn che va ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ro mena̱n me ne, ca̱h yune ye che quendi ihyan yune yahn ma̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ate hua chihcoma̱n ye ihyan, te din ye che ndah nduco ye, chihco ro ye vedeyahino yahn ye. A Ihyan min che redin ye che ran co ma̱n, che ndah ri chenda̱ta ma̱n. Rihquecheh ye uvo ma̱n, reneca̱h ya̱n ye chedave yuhn vo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Andahre tihca̱ ra̱hn Pa̱blo ma̱n, Bernabé ma̱n, ate aconunde cuahn chica̱de chica ta̱n ye che ca̱hno ihyan ya̱n chahn itenine che co te vedino, che ndeva ye yavena̱n ye. ");
INSERT INTO cutNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tuhme nda̱ neve ihyan, nda̱ta yahn Israel, che chica ye ya̱n Antioquía ma̱n, ya̱n Iconio ma̱n, chinun ye ihyan ya̱n, ne ca̱h ye tu Pa̱blo. Chihno min ne, co a ndih Pa̱blo ra̱hco ihyan chahn, ne chihnda̱ rudo ye ihyan nde cua̱hn chihto ya̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ate ura che ndi da̱ma ihyan che ritahno ye Dihvo vo na̱n Pa̱blo ne, necuan ye, ne cona̱hn ye viya̱n nduco vih. Ta̱ma ro me ne, chica ye min nduco Bernabé, nda̱ ye ya̱n Derbe. ");
INSERT INTO cutNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Min cahndudo ye Ndudo yahn Dendiohs, ne a̱ma ya̱hn ihyan chitahno ye Dihvo vo. Chihno min ne, ndaconan ye, nchuh ye ya̱n Listra ma̱n, ya̱n Iconio ma̱n, nta̱ ye ya̱n Antioquía. ");
INSERT INTO cutNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Queri a̱ma ya̱n na̱n che nchuh ye ne, reneca̱h ya̱n ye chedave yahn ihyan che ritahno ye Dihvo vo, ne riya̱hve ye ihyan che quendi cotahno ye numa ino ye. Ra̱hn ye ri ye ihyan chahn te va che a̱ma chuhrihn ye muhn iyehnse, ate adive ne, cuahtenan ye vahchetero. ");
INSERT INTO cutNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Namin tenda̱h nun ye neve ihyan queri a̱ma cua̱n ca̱va che co ye intiyahn ya̱co. Cova̱h ye ma̱n, chahte ye ya̱hte ma̱n, ne nda̱hco ye nducoya̱ca ihyan chahn che ritahno ye Dihvo vo ta̱h Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Chihno min ne, nchuh ihyan chahn ya̱hn yahn Pisidia, ne nda̱ ye ya̱hn yahn Panfilia. ");
INSERT INTO cutNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Cahndudo ye Ndudo yahn Dendiohs ya̱n Perge, tuhme cuahn ye ya̱n Atalia. ");
INSERT INTO cutNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chahtenun ye a̱ma ba̱rco, chica ye min, cona̱hn ye ya̱n Antioquía, a ya̱n min che nda̱hco intiyahn ya̱co ihyan chahn ta̱h Dendiohs che a̱ma va vedeyahino yahn ye, ca̱va che ca̱hn ye na̱n ntiyon che ma̱n ne, a dinahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Cuahn che a nta̱ ye ne, nedin da̱ma ye nducoya̱ca ihyan che ritahno ye Dihvo vo, ne neca̱h cuande ye ihyan chahn nducuahn che din Dendiohs nduco ye ma̱n, nduhca̱ che din Dendiohs che chitahno ihyan ta̱ma nación ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pa̱blo nduco Bernabé ne, a̱ma ra̱hn chahtenan ye ya̱n min nduco ihyan che ritahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ta̱hn min ne, a̱ma o sa̱hn che chica se esta̱do yahn Judea, nda̱ se ya̱n Antioquía ne, min chicuahn se ihyan che ritahno ye Dihvo vo te ca̱va che co ndevahn ye ne, va che conan seña ihyan nduhca̱ che chihquentiyon Moisés. ");
INSERT INTO cutNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pa̱blo nduco Bernabé ne, riya̱hve ye sa̱hn chahn che ndiyu tihca̱, ate a̱ma chahtecuhn chende se nduco ye. Nducote hua chi chihnde ca̱de min ne, nte ca̱de ihyan che ritahno ye Dihvo vo che dechuh ye ihyan chahn nduco ta̱ma te o ihyan ya̱n Jerusalén ca̱va che nte ca̱de ye nduco ihyan apóstol ma̱n, intiyahn ya̱co ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Chica ihyan chahn ya̱n Antioquía, chuh ye nación yahn Fenicia ma̱n, Samaria ma̱n, reneca̱h cuande ye ihyan che ritahno ye Dihvo vo che vate ye min, nduhca̱ che chihcoma̱n ihyan ta̱ma nación dehtenduh che ritahno ye mena̱n, ne chitahno ye Dendiohs. Nducoya̱ca ihyan che chihnevan ye ndudo me ne, a̱ma chi yeno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Cuahn che nda̱ Pa̱blo nduco Bernabé min ya̱n Jerusalén ne, nducoya̱ca ihyan ndiya̱co ma̱n, ihyan apóstol ma̱n, intiyahn ya̱co ma̱n, nevahnecun ye ihyan. Tuhme Pa̱blo nduco Bernabé neca̱h cuande ye ihyan chahn yahn nducuahn che din Dendiohs nduco ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ate a̱ma o sa̱hn fariseo che namin ritahno se Dihvo vo ne, chahtendi se, ne ra̱hn se: ―Va che conan seña ihyan ta̱ma nación che ritahno ye Dihvo vo ma̱n, va che dinahn ye ley che dirun Moisés ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Tuhme ndoda̱ma ihyan apóstol chahn nduco intiyahn ya̱co ca̱va che nte ca̱de ye yahn chemin. ");
INSERT INTO cutNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Cuahn che a a̱ma ndeh rente ihyan chahn ne, chandi Pedro, ne ra̱hn ye: ―Dihnó, a devano nchuhn te a ra̱hn ne, va̱n uvo ne, tenda̱h nun Dendiohs u ca̱va che cuahndudó Ndudo yahn ye, cahnevan ihyan ta̱ma nación, ne cotahno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dendiohs che rendihche ye chedave yahn nducoya̱ca ihyan ne, te ye, checadino vo che ndeva ye ihyan chahn, te din ye che quenun Vaco Ndah yahn ye ihyan, nduhca̱ che quenun uvo. ");
INSERT INTO cutNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dendiohs ne, da̱ma no yahino ye uvo nduco ihyan chahn, te namin ihyan chahn ne, nchahco ye nunde yahn ye yahn che chitahno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Dehco che retumarande nchuhn Dendiohs? Che tihca̱ rihquentiyon ne ne, reca̱h rihn ne ihyan ta̱ma nación che ritahno ye Dihvo vo, te nducuahn che nahn ne che dinahn ye ne, nde ihyan ndico yuhn vo, nde ma̱n vo, hua chi dinahn vo. ");
INSERT INTO cutNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","A devano vo te dema̱n nduco vedeyahino yahn Dihvo vo Jesucristo che ndevahn vo ma̱n, ihyan chahn ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tuhme chahtedihn chende ihyan, ne chihcovan ye che neca̱h cuande Pa̱blo nduco Bernabé yahn vederihno che din Dendiohs nduco ye va̱n ihyan ta̱ma nación. ");
INSERT INTO cutNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cuahn che chihno nte ihyan chahn ne, necuandi Jacobo, ne ra̱hn ye: ―Dihnó, cuihcovan nchuhn che ca̱hmá. ");
INSERT INTO cutNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro ne, a neco ye uvo nduhca̱ che din yahino Dendiohs ihyan ta̱ma nación, ne tenda̱h nun ye va̱n ihyan chahn, ihyan che co yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tihca̱ va che co, te a tihca̱ dirun a̱ma cha ihyan profeta tuhca̱: ");
INSERT INTO cutNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ra̱hn Dendiohs: “Cuihno min ne, ndaconán, ne nda̱hco ca̱dé vederihquentiyon yahn David che va ma̱n. Dín che ndaconan ndo chahte ma̱n, che ca̱hcantiyon ma̱n ma̱n, ");
INSERT INTO cutNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ca̱va che ihyan yahn nducuahn nación che a tenda̱hnún ne, cotahno ye u che Dihve ye.” ");
INSERT INTO cutNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Tihca̱ ra̱hn Dihvo vo Dendiohs, te ye, checadino vo dehtenduh che tuhchan nde a ra̱hn me. ");
INSERT INTO cutNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Chemin che rá̱hn te hua nda̱hca̱ che ca̱h rihn vo ihyan nación chena̱hn che a chihcoma̱n ye dehtenduh che ritahno ye ro mena̱n me, ne chitahno ye Dendiohs. ");
INSERT INTO cutNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Tahque nda̱hca̱ che dirun vo yahn ye che hua cheh ye che rihco ihyan na̱n che ra̱hn ye dendiohs yahn ye ma̱n, che hua cheh ye yute yahn ite che hua ra yun yahn te ma̱n, che hua cheh ye yun ma̱n, che hua ndere cuahtenan ye nduco nda̱hta che ndiyu nda̱hta yahn ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tihca̱ din vo, te nducuahn ya̱n, nde a ra̱hn me, ndate ndate, ro che rahtetuhno ihyan ne, rahndudo ihyan ley che dirun Moisés, ne hua nda̱hca̱ che din vo che co nda̱che ihyan che riquendi ye ley min. ");
INSERT INTO cutNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tuhme ihyan apóstol ma̱n, intiyahn ya̱co ma̱n, nducoya̱ca ihyan chena̱hn che ritahno ye Dihvo vo ma̱n ne, nte ca̱de ye, ne tenda̱hnun ye o ihyan ca̱va che dechuh ye ihyan nduco Pa̱blo ma̱n, Bernabé ma̱n, ya̱n Antioquía. Quenda̱h yahn o ihyan che namin ndina̱n ye va̱n ihyan che ritahno ye Dihvo vo. A̱ma ye ne, Judas, che namin duche ye Barsabás, ne ta̱ma ye ne, duche ye Silas. ");
INSERT INTO cutNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nduco ihyan chahn ne, dechuh ye a̱ma ca̱ca na̱n che dirun ye: “Nuhn, ihyan apóstol ma̱n, intiyahn ya̱co ma̱n, nducoya̱ca ihyan chena̱hn che ritahno ye Dihvo vo ma̱n ne, rente nuhn Dendiohs nchuhn, dihno nuhn, ihyan nación chena̱hn che vate ne ya̱n Antioquía ma̱n, ya̱hn yahn Siria ma̱n, Cilicia ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Checadino nuhn te a̱ma o ihyan che chica ye muhn, ne nda̱ ye ta̱n ne, redin va̱hche ye yahn nchuhn ma̱n, redetoh ye ino nchuhn ma̱n, che ndere ricuahn ye che va che conan seña nchuhn ma̱n, dinahn ne ley che dirun Moisés ma̱n. Hua ndiyu nuhn che dechuh nuhn ihyan chahn. ");
INSERT INTO cutNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","A nte ca̱de nuhn, ne tenda̱hnun nuhn o dihno vo va̱n nuhn, dechuh nuhn ihyan ta̱n, quendihchero ye nchuhn da̱ma nduco dihno vo che a̱ma yahino vo ihyan, Bernabé ma̱n, Pa̱blo ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ihyan chahn che ndihco menda̱hn ye ihyan, redin ye ntiyon yahn Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Me ihyan che o che dechuh nuhn ne, Judas ma̱n, Silas ma̱n. A ihyan chahn che nte cuande ye nchuhn yahn nducuahn che nte ca̱de nuhn. ");
INSERT INTO cutNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Numacuahn vederihquentiyon yahn Vaco Ndah yahn Dendiohs nte ca̱de nuhn che hua ca̱h rihn nuhn nchuhn nduco a̱ma ndeh na̱n dehtenduh. Atena̱n dehtenduh che tuhchan, va che dina̱hn ne. ");
INSERT INTO cutNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Hua cheh nchuhn yute che rihco ihyan che ri vedino na̱n dehtenduh che redin ye dendiohs yahn ye ma̱n, hua cheh ne yun ma̱n, yute yahn ite che hua ra yun yahn te ma̱n, hua ndere cuahtenan ne nduco nda̱hta che ndiyu nda̱hta yahn ma̱n ne ma̱n. Ndete che dinahn ne dehtenduh che tuhchan ne, nda̱hca̱ din ne. Dendiohs conduco ye nchuhn.” ");
INSERT INTO cutNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tuhme chica ye min, ne nda̱ ye ya̱n Antioquía. Nedin da̱ma ye nducoya̱ca ihyan che ritahno ye Dihvo vo, ne neca̱h ye ca̱ca me. ");
INSERT INTO cutNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Cuahn che cahndudo ihyan ca̱ca me, chihnevan ihyan chahn ne, a̱ma neca̱h ya̱n ye chedave yahn ye, ne chi yeno ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas nduco Silas ne, namin quenan cuma ye vederihquentiyon che rahndudo ye Ndudo yahn Dendiohs, ne cuahn che cahndudo ye, chihnevan ihyan chahn ne, a̱ma neca̱h ya̱n ye chedave yahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Cuahn che a ndeh ro chahtenan ye min ne, ihyan che ritahno ye Dihvo vo ne, ndedechuh ye ihyan numacuahn vedeyeno ya̱n Jerusalén. ");
INSERT INTO cutNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ate Silas ne, quenan ye min ya̱n Antioquía. ");
INSERT INTO cutNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Namin Pa̱blo ma̱n, Bernabé ma̱n, chahtenan ye min, ne nduco a̱ma ya̱hn ihyan ne, quendi ye, ricuahn ye ndudo yahn Dihvo vo Jesucristo ma̱n, rahndudo ye ma̱n. ");
INSERT INTO cutNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Adive ne, ra̱hn Pa̱blo ri ye Bernabé: ―Cuhn vo ta̱ma yune nduco ne, quendihchero vo nducoya̱ca dihno vo che vate ye nducuahn ya̱n na̱n che a chahtechico vo, cahndudo vo ndudo yahn Dihvo vo. Ndihchero vo ta̱ca̱ chenan ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé ne, nahn ye che ca̱hn Jua̱n Marcos, co nduco se ihyan. ");
INSERT INTO cutNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ate Pa̱blo ne, ra̱hn ye te hua nda̱hca̱ che quenda ye sa̱hn yahn che, cuahn che chahn ye mena̱n me ne, chihcoma̱n se ihyan ya̱hn yahn Panfilia, cona̱hn se, ne hua quendi se nduco ye na̱n ntiyon. ");
INSERT INTO cutNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nducote hua chida̱ma ndudo yahn ye nduco vih ne, chihcoma̱n vih ye. Bernabé ne, quenda ye Jua̱n Marcos, ne chahtenun ye a̱ma ba̱rco, ne cuahn ye ya̱hn yahn Chipre. ");
INSERT INTO cutNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Me Pa̱blo ne, quenan ino ye che conduco Silas ihyan. Cova̱h ihyan che ritahno ye Dihvo vo ca̱va che numacuahn vedeyahino conduco Dendiohs ihyan, ne cuahn ye. ");
INSERT INTO cutNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Chuh ye ya̱hn yahn Siria ma̱n, Cilicia ma̱n, reneca̱h ya̱n ye chedave yahn ihyan che ritahno ye Dihvo vo. ");
INSERT INTO cutNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pa̱blo nduco Silas ne, chuh ye ya̱n Derbe, ne nda̱ ye ya̱n Listra. Min va a̱ma sa̱hn che duche se Timoteo, che ritahno se Dihvo vo Jesucristo. Sa̱hn min ne, da̱ya a̱ma nda̱hta nación yahn Israel che namin ritahno ye Dihvo vo. Chida se ne, ihyan nación yahn Grecia. ");
INSERT INTO cutNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ihyan che vate ye ya̱n Listra ma̱n, ya̱n Iconio ma̱n, che ritahno ye Dihvo vo ne, ra̱hn ye yahn se che ndah ihyan se. ");
INSERT INTO cutNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pa̱blo ne, nahn ye che conduco sa̱hn min ihyan, ne nahn ye seña sa̱hn ca̱va che hua co yudo yahn ihyan nación yahn Israel che vate ye ya̱hn min, te nducoya̱ca ye ne, devano ye te chida se ne, ihyan ta̱ma nación ye. ");
INSERT INTO cutNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nducuahn ya̱n na̱n che renda̱ ye ne, reca̱h cuande ye ihyan che ritahno 