﻿USE sofia;
DROP TABLE IF EXISTS sofia.cul_vpl;
CREATE TABLE cul_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cul_vpl WRITE;
INSERT INTO cul_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jehe, ajijaro imapi Jesocristo tahimari. Jeso biridi ojariapa Isaraeri potemahi jodiodeni quiquinanajaridenicca tamine Dabi. Biridi ohuaha naco Isaraeri potemahi jodiodeni huapimacca idi Abarahao. Nadsapa Abarahao potemahi onideni hua inadsa Jeso imenicca maqqui oni bacco inanijine. ");
INSERT INTO cul_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Tahidepa Abarahao. Abarahaopa Isahacacca abi. Isahacapa Jacobocca abi. (Jacobo oni ohuahapa Isaraeri.) Jacobo bedideni ojaria onipa Joda. Pohua, pohua imecotedenidsa: —Isaraeri potemahi jodiodeni −quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Joda bedipa papamade: Pare, Dsara quinajari. Imenideni oninipi Tamara. Parepa Eserocca abi. Eseropa Araocca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Araopa Aminadabecca abi. Aminadabepa Nahasaocca abi. Nahasaopa Saomocca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saomopa Bohodsicca abi. Bohodsi imeni oninipi Rahaba. Bohodsipa Obedecca abi. Obede imeni oninipi Roto. Obedepa Dsesse-Isahicca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Dsesse-Isahipa Dabicca abi. Najari Dabipa jodiodenicca tamine tojajari. Pohuapa Saromocca abi. Saromo imenipi Oria bedimeni bote. ");
INSERT INTO cul_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Saromopa Robohuacca abi. Robohuapa Abiacca abi. Abiapa Asacca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asapa Josapatecca abi. Josapatepa Joraocca abi. Joraopa Osiacca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiapa Joataocca abi. Joataopa Acasecca abi. Acasepa Esequiacca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esequiapa Manasecca abi. Manasepa Amaocca abi. Amaopa Josiacca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiapa Jeconiadenicca abi. Jeconia, pohua imecotedeni madimanadsapa dsama onihicca madija jadsire eccajonamanajaro. Najaridenina deni toquejenadsapa Isaraeri potemahideni todsepe toquejenajari. Poccadeni dsama Babironiahuaji iaccanibaqqui-manadsapa tarabaidsajine medse toquejenajari. ");
INSERT INTO cul_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nadsa nahi dsama onihihuaji madimanadsa Jeconia bedi tossonajari. Pohua onipa Saratieo. Saratieopa Sorobabeocca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sorobabeopa Abiodicca abi. Abiodipa Eriaquiocca abi. Eriaquiopa Adsoriacca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Adsoriapa Sadocacca abi. Sadocapa Aquiocca abi. Aquiopa Eriodecca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriodepa Eriasacca abi. Eriasapa Mataocca abi. Mataopa Jacobocca abi. ");
INSERT INTO cul_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobopa Dsodsecca abi. Najari Dsodsena Mariacca maqqui tojajaripaja. Jehe, Dsodsecca amoneje Mariadsana Jeso tossonajari. Najari Jesona —Ia Idinide Cristo-Mesia −ihinanajaro. ");
INSERT INTO cul_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jehe, najaro imapi Jeso biridideni huapi taraha onideni eti ajima-jerajaro. Abarahao onidsama hua idsanapodsapi ajicca tamine Dabi oni bacco inadsapi biridideni 14 quinajari. Nadsapi Dabi onidsama hua inapomadsapi Jeconia oni bacco inadsapi denima biridideni 14 quinajari. Aja Jeconia madidsapa Isaraeri potemahideni todsepe toquejenadsa dsama Babironiahuaji iaccanibaqqui-manajari. Dsotode Jeconia Babironiadsa madidsa pohua onidsama hua inapomadsapi ia Idinide Cristo-Mesia tossonahi bacco inadsapi denima 14 quinajari. ");
INSERT INTO cul_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesocristo tossonahijinecca imapi ajima napojaro: Jeso imeni Mariapi Dsodse icajihijine tahide imehidenipa jehe canirepojari. Mariapi maqquideje ssamo taccani. Dsodsepa pocca odsahuaji Maria iaccani-jeraccadsapi ponidsa huada-jaraccahi. Naraha ponipi jiajaro. Dio Corime huati tadsapa poni idsonidsa ejedeni nahatodsa huittidsajari. ");
INSERT INTO cul_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ponicca maqqui tojahijine Dsodsepa imari bica taja najari. Poni jiani qqui taraha ponidsa ima inassonarinijine jipera tajari. Nadsapa pohua bodi: —Cacomehedsa onebona −najari. ");
INSERT INTO cul_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pohua bodi nama naraha pocca huadadsa Diocca dodosse Pohua Atti ccaccaronade ahuatodsa huati tajari: —Dsodse, tiapi tamine Dabi potemahi tijani. Ticappina-jeraji. Maria jiaporaha ticajinijine oppinera tani. Aja, Maria poni idsonidsa ejedeni huittidsajaripa madijajine jarahi. Dio Corime huati tadsa ejedeni cajijaro −najari. ");
INSERT INTO cul_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","—Nidsa poni bedi tossonadsapa onipa “Jeso” tana. (Ettidsapi: Ia Medsede madija Tonassiajade, inajaro.) Najaripa pocca madija inassiajabaqquihitohui, poccadeni imasiri manaconi najidsohue pohuadenidsa inassonari-jeranitohui −najari Dio Atti ccaccaronade atti. ");
INSERT INTO cul_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Najaro ima huapima ima tojaponijinepi maittaccadsama Diopa Pohua Atti cacomerabote Isahiadsa huati tadsa Isahiana huati iqquimajaro. ");
INSERT INTO cul_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Pohua attipa: —Ticattomama canaji. Dsohuato maqquideje ssamo taraha jiadsapi ejedeni cajinitohui. Poni bedidsapa: Emanohueo, quiquinanahitohui −napohui nade Isahia. (Emanohueo ettidsapi: Dio iadsa madihi, inajaro.) ");
INSERT INTO cul_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nadsapa Dsodsedsa huati huati taha jicadsapa Dsodse nocco tojajari. Dio Atti ccaccaronade attidsa ibora tadsapa Maria icajijaro. ");
INSERT INTO cul_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nadsapi pocca amoneje tojaraha poni idsonicca ejedeni tossona-jaraccadsapa ponidsa huada-jarajari. Poni bedi tossonadsapa Dsodse ejedeni oni hua inajari: —Jeso −najari. ");
INSERT INTO cul_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesopa odsa panani onini Berenedsa tossonajari. Najaro odsapi Jodeahuajicca dsamacca. Jeso tossonahicca huajanodsapa tamine Herode dsama Jodeacca madija cacahuade tojajari. Pohuapa odsa panani Jerosaredsa madijari. Nadsapa tamine Herode nahidsa madihi paja naccadsa dsama huaji tanicca madija maji ccajonahihuaji jahijonadsa Jerosaredsa bacco najonamanajari. Pohuadenipa abadsico bedi tahimari nahatoqquiri napojarideni. ");
INSERT INTO cul_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerosaredsa bacco najonamanadsa attidenipa: —¿Nija? ¿Nejecohuaji Isaraeri potemahi aja jodiodenicca tamine tossonajaritta? −najonamanajari. —Iapi maji ccajonahihuaji imadidsa abadsico bedi dsati qqui icanade. Najaro imapi tamine deni tojajari tossonahitohui quinapojaricca ima tojajaro. Najari qquide jaijajonajaro. Ipitodsa jassi inadsa pohuadsa: “Icca tamine” inanijine −quinajari. ");
INSERT INTO cul_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nadsapa tamine Herode najaro ima mittadsapa bodi tocasserajari. Pocca madija nahi Jerosaredsa madimanajarideni ima mittamanadsa naco bodideni cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nadsapa tamine Herodepa dada toqquimade taminedeni, jodiodenicca marinaja maridedeni naco inequeriqquihijine huahua inabaqquijari. Queriqquimanadsapa pohuadenidsa huati tajari: —Aji Dio Atti dsodo nanidsa ia Idinide Cristo-Mesia tossonahicca imapi ¿nejecoma napojarotte? ¿Nejecohuajina Cristo-Mesia tossonahitohui napojarotte? −nahi nade Herode. ");
INSERT INTO cul_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tamine Herodedsa ima ecomeramanajaro: —Jodeahuajicca odsa panani Berenedsana tossonahitohui. Najaro imapi Dio Atti cacomerabote Miqueo dsodo inapojaro. ");
INSERT INTO cul_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Pohua atti ajama napojari: “Berenecca ima huati onana. Jodeacca dsamahuaji odsa panani huapi taraha Berenepi ajimani toja-jerani. Ima bicani deni tojanicca cajinitohui. Nahidsa tamine deni tojahicca tossonahitohui. Pohuapa occa madija Isaraeri potemahideni ecahuabaqquihitohui” napohui nade Dio Atti cacomerabote −quinahi nade jodiodenicca marinaja maridedeni. ");
INSERT INTO cul_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herode najaro ima mittadsapa aja abadsico bedi tahimari nahatoqquiri napojaridenitohui cacomehedsa huahua inabaqquijari, poccadeni ima mittahijine. Jahijonadsapa pohuadenidsa huati tajari: —Aja abadsico bedi dsati qqui ticanamanajaripa ¿nejecoma nadsa cahatojaritta? −nahi nade. Nadsapa pohuadsa abadsico bedi tahimari ecomeramanadsa mittajari. ");
INSERT INTO cul_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Nadsapa Herode Berenehuaji dosse iqquimabaqquijari: —Berenehuaji jai tijana. Nanihuaji ejedenitohui qqui taridsamanana. Bacco tiquinadsapa ohuadsa huati tanimanana. Ohua naqui pohua qquide occadsa opitodsa ohuittadsa pohuadsa: “Occa tamine” onanijine, onajaro −naraha maidsajari. Tamine ohuahadsa jipera tajari. ");
INSERT INTO cul_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Herode atti mittamanadsapa jai tojajari. Jai toja, jai toja nanaja abadsico bedi aja qqui icanamanapojari pohuadeni tedsejema cahatopomajari. Cahatopomadsa abadsico bedi tahimari nahatoqquiri napojarideni huatidsemaneri najari. Pohuadeni tedsejema tohuaccadsa ejedeni tossonahicca odsadsa quehenacossajari. ");
INSERT INTO cul_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nahidsa jai tojedsimadsapa ejedeni qqui, imeni Maria qqui toquinajari. Pohuadsa huatidsemanadsapa pohuadeni pitodsa jassi tadsa: —Tamine deni tojahi −quinajari. Pohuadeni dsepetaji baho bedeni bicaqquiri najaro itaboridsamanadsa poccadeni daniji ejedenidsa da inaqquimanajaro. Oro huatini ccara tanicca da quinajaro. Ahua majicone tohuessihi majo bica tajari naco da quinajari. Ahua ohuaha oni mirra majicone majo ocassa tahicca naco da quinajari. ");
INSERT INTO cul_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nadsa dsome nahidsa cahadijadsapa huada cajimanajari. Dio pohuadenidsa huati tajari: —Tamine Herodehuajipi jai tijani-jeraji. Pocca ima oppina tani −najari poccadeni huadadsa. Nama nadsapa poccadeni dsamahuaji jai tojanihijinepa Jerosarecca jahuihuaji jai tojani-jarahi. Jahui onihina jai tojanijari. ");
INSERT INTO cul_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nadsapa abadsico bedi tahimari nahatoqquiri napojarideni jai tojania jicahi. Dsotodepa Dsodse pocca huadadsa Diocca dodosse Pohua Atti ccaccaronade ahuatodsa atti ajama najari: —Dsodse, nocco tijaji. Huassinaja aja ejedeni imeni tadsajani dsama Ejitohuaji tiaccabaqquijo. Tamine Herodecca dosseniji ejedenitohui qqui naridsamanabote nahi, inanadsoqque-manahijine. Nani Ejitohuaji timadi-dsanapoccana. Nidsa tiadsa huati onapomadsana ticcanipomanijine bica tani −najari. ");
INSERT INTO cul_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nadsapa huassinaja nocco toquejenadsa: —Jina, jidapana dsome icadana −najari Dsodse. Nadsapa dsomeraha ejedeni imeni tadsajani Ejitocca jahui jai tojajari. ");
INSERT INTO cul_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ejitohuaji bacco toquinadsapa tamine Herode madiccadsa nahidsa madimana-dsanapoccajari. Najaro imapi maittaccadsama Dio huati tapodsa Pohua Atti cacomerabote Osea dsodo inapojaropi ajima najaro: —Occa Ejedeni Ejitohuaji madiraha pohuatohui huahua onajaro −najari Dio Atti Oseajine dsodo nanidsa. Nadsapa tamine Herode dsoqquehi ima mittamanadsana poccadeni dsamahuaji jahinijari. ");
INSERT INTO cul_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herode dsoqque-jaraccadsa ima ajima inanajaro. Aja abadsico bedi tahimari nahatoqquiri napojaridenitohui madiraha pohuahuaji jahini-jaradsapa bodi huatomajari: —Ohua icamaidsamanajaro −najari. Nadsapa paja huadirijari. Huadidsapa tamine dsati tossonajari dsori tajarahijine pocca madija dosse inabaqquijari: —Jari, Berenedsa madimanajarideni, Berene huajira tanidsa madiridsamanajarideni naco bedideni maqquideje bedi huajanorideni 2 najari, huajanorideni ajamanicca naco, najarideni huapima tinajicaridsamanahissa tajo −nahi nade Herode. Aja abadsico bedi dsati qqui icanamanapojaricca huajanodsa tocatojaridsajarideni huapima jicaridsahijine. ");
INSERT INTO cul_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nama quinadsapa Isaraeri potemahidenicca ejedeni badsiraqquiri najari inajicamanajarijine imehideni, imenideni oji oji quinajari. Najaro imapi pina maittaccadsama Dio Atti cacomerabote Jeremia dsodo inapojarossa najaro tojajaro. Isaraeri potemahidenicca ini maittaccadsama madipojaro onini Raqueo tahimarinidsa dsodo nanipi ajima najaro: ");
INSERT INTO cul_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","—Odsa panani Ramahuajicca dsamadsa oji imeni tojajaro. Raqueo potemanidenipi bedidenitohui oji oji quinajaro. Ponidenicca ojie naqui huatinideni ssonanijine jiperaqquiri najaro, bedideni jicaridsadsa −napohui nade Dio Atti Jeremiajine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nadsapa dsotode tamine Herode dsoqquehi nattipa dsama Ejitohuaji Dio Atti ccaccaronade Dsodse pocca huadadsa ahuatopomadsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Dsodse, nocco tijaji. Aja ejedeni imeni tadsajani Isaraeri potemahidenicca dsamahuaji tiaccanibaqquijo. Ejedeni inanadsoqque-manahijine tohui quinajaridenipa jicahi −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nadsapa Dsodse nocco tojadsapa najoradsa Isaraeridenicca dsamahuaji ejedeni imeni tadsajani iaccanibaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nanihuaji bacco tanimanadsapa Dsodse ima mittajari: —Herode dsoqquedsapa pohua bedi onipa Aquelao najarina dsama Jodeacca tamine tojajari −quinajari. Najaricca ima naqui tabaccora tajaro, pina imehicca imassa nadsapi Dsodse nahihuaji madihijine cappinajari. Naraha pocca huadadsa Dio pohuadsa huati tajari: —Aji Jodeadsapi timadimana-jeraji −nahi nade. Nadsapa dsama arobeni Carireahuajina tojoppemamanajari. ");
INSERT INTO cul_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jai tojadsapa Carireahuaji bacco toquinajari. Nadsapa odsa panani Nasaretidsa madimanajari. Najaro imapi pina Dio Atti cacomeraqquiri najarideni madija Idinide Cristo-Mesia tahimari huati toquinapojarissa najaro: —Pohuadsa: “Nasaretihuajicca” quiquinanahitohui −quinapohui nade Dio Atti dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Huajano toccahi huapi tadsa madija oni Huanopa dsama arobeni onini Jodeacca huamoni ssono caji, siba caji tanihuaji madija maride tojajari. Pohuadsa: Baotista, quiquinanajari. (Ettidsapi: Totopade, inajaro.) ");
INSERT INTO cul_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Mari mari ihicanabaqquiridsa nadsapa ajama nanaridsa najari: —¡Ticcadeni imasiri tineboridsamanaji! ¡Diotohuira tidsanapomanaji! Diocca cacahuehepi iadsa bacco najonabote nani −nanaja najari Huano. ");
INSERT INTO cul_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aji Huanocca imapi maittaccadsama Dio Atti cacomerabote Isahia dsodo inapojaro. Pohua atti ajama napojari: —Nidsa dsama huamoni ssono caji, siba caji tanihuaji madijaripa atti mohui tadsa madija huahua huahua ihinajonabaqqui nahitohui. Pohua attipa: “¡Ia Medsede ccajonabote nahi! ¡Tinajoramanaji! ¡Pohua tedsejema jahui tijinedeni tobicapoji! Najaroa aji tibodideni pohuatohui tinajoramanaji” nanaja nahitohui dsama huamonihuaji madijaripa −napohui nade Dio Atti Isahiajine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nadsama Huanopa dsama huamonihuaji madidsapa pocca eteropi camello cone ba nani ssequi nadsa huedsajari. Pocca ssoquepi bani etero. Pohua taparipa sese, dsamacca jidsi oquine najari. ");
INSERT INTO cul_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Madija huapima Huano atti mittamanahijine jahijonana canajaridenipa odsa panani Jerosarecca, Jodeacca dsamadsa madiridsamanajarideni, hueni Jordaohuaji madiridsamanajarideni naco bacco bacco quinajari. ");
INSERT INTO cul_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Poccadeni imasiri Diodsa ecomeramanadsapi Huanopa hueni Jordaodsa topa topa ihidsanabaqqui najari. ");
INSERT INTO cul_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Naraha dsotode madija huapi taha jahijonahi Huano qqui tajari. Pohuadenipa Isaraeri potemahi jodiodeni mota marinaja onini pariseodsa jehe quinajarideni, mota marinaja onini sadoseodsa jehe quinajarideni totopa tohui quinadsa Huanohuaji jahijonajari. Naraha Huanopa pohuadenidsa huati tajari: —¡Tiadenipi pina maccassa tiquinani. Ticcadeni imapi tabaccora tajaro! Tiadenipi tibodideni cacajiqquimera-jeraraha: “Huano ia topa todsanabaqquidsapa Diocca najidsohuedsa dsori icanirenitohui” ¿tiquinajaroqui? Naraha tibodideni cacajiqquimera-jeradsapi dsori ticanire-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Naraha tettideni ajima tiquinadsana bica tani: “Imasiri onebona. Diotohuira obodi huahuatoma nanijine” tiquinadsapi tibodideni cacajiqquimeranicca ima ahuato tanijine ima bicanira tinanamanaji, onajaro −najari Huano. ");
INSERT INTO cul_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","—Naraha tibodidenidsa ajima tiquinanitide: “Icca idipa Abarahaoja najari, Diopa ia tohuattajobaqqui-jarahitohui” titiquina naraha tiadeni ticamaidsanimanajaro. Diopa madijassa najarahi. Pohua jipa tadsapa aji siba huihuitteri naridsajarodsa naco Diopa Abarahao potemahissa naha inahatoridsahijine pajirajari. Paji tiadenipi: “Abarahao potemahi iquejenani” tiquinaraha Diodsa iboraqquiri tiquinejeradsapi tiadeni tohuattajo-baqquihitohui. ");
INSERT INTO cul_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nadsapi Diodsa iboraqquiri tiquinejeradsa, ima bicani tinanamana-jeradsa naqui ticcadeni ima pina ahua tabaccora tajaricca imassa najaro. Paji, najari ahua ca cajine dsamipa najorahi. Ahua bono bica tajaradsapa ca tacaridsa tahi. Ca tacaridsadsapa bobottahuaji hua hua totodsima najari, diji tahijine −nahi nade Huano. ");
INSERT INTO cul_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","—Ohuapi passodsa tiadeni topa odsanabaqquijaro, imasiri tinebomanadsa Diotohuira tiquinanicca ima ahuato tanijine. Naraha madija dacorajari ccajonabote nahi. Ohuapi tahide mari mari onaporaha aja dsotodecca mamaride ccajonajarina deni tojajari. Najarina Dio Corime tibodidenidsa madihijine tiadenidsa inanaridsahitohui. Pohuapa pohuadsa toquejena-jarajaridenipa jororoni jiquejeranihuaji hua idsimabaqquihijine pajirajari. Ohuapi ajimani ojani. Pina pocca medsessa onanijinepi opajira-jerani. Pohua amoricca sadaria dsojode naqui opajira-jerani −nahi nade Huano. ");
INSERT INTO cul_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","—Jehe, ccajonabote najaripa madija icattejidsa-baqquihijine. Pina madija aroso jidsadsa trigo huire tahijine qquero quissa, qquero quissa, qquero quissa inamacossajari. Nahi trigo etero, eppe, ede najaripa jojodedsa toccahijine. Nadsapa noccona ecahuajari pocca odsahuaji. Naraha trigo etero, eppe, ede najaripa diji tahijine bobottahuaji hua idsimahitohui. Najaria aja Diodsa iboraqquiri najarajaridenipa jororoni jiquejeranihuaji hua idsimabaqquihitohui. Najaro jororonipi ohuihuira tani −nahi nade Huano. ");
INSERT INTO cul_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nadsapa Jeso dsama arobeni onini Carireadsa madiraha hueni Jordaohuaji qquedsippajari. Huano madihihuaji bacco dsippadsapa Huanodsa: —Ohua topa tidsanaji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Naraha Huano attipa: —Ohuapi ajimani ojani. Tiana ohua topa tidsanani bica tani −najari. ");
INSERT INTO cul_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Naraha Jesopa: —Epeje, nema nehe ohua topa tidsanaji. Ajijaropi Dio pocca dosseniji nema inanijine −najari Jeso. Nadsapa Huano jehe najari. ");
INSERT INTO cul_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nadsapa Jeso topa idsanajari. Jeso passodsa totehemadsa tocattamacossa nanaja meme tohuaba najaro. Dio Corime ahuato taha pina midsorissa naha ccaronajari. Ccaronadsa Jesodsa be tajari. ");
INSERT INTO cul_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nadsapa memehuaji atti mittaronajari: —Ajajaripa occa Ejedeni. Pohuadsa ohuati huana tajaro. Pocca ima bica tajarojine ohuatidsejaro −najari Dio. ");
INSERT INTO cul_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Huano Jeso topa idsanaha jicadsapa Dio Corime Jeso iaqquemorajari, dsama huamoni ssono caji, siba caji tanihuaji iaccajari. Nahihuaji pohua iaccajaripa imasiri totonanade Satanapa Jeso nattome inahijine. Satanapa Jeso imasiri inananijine dissera tajari. ");
INSERT INTO cul_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nadsama Jesopa huamonihuaji madidsapa jiperahi huada 40 naha madidsanapojari. Pohua jipa-jarahicca ssiaja 40, dsome 40 nadsapa pemihissa tajari. ");
INSERT INTO cul_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nadsapa Satana Jeso icamaidsahijine pohuadsa bacco tajari. Satana attipa: —Dio Bedi tijadsapi, jari, tijipanijine ajijaro siba pan tojahijine huati tinaji −najari. ");
INSERT INTO cul_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Naraha manaco Jeso Satanadsa huati tajari: —Dio Atti dsodo nanidsapi ajima najaro: “Dsamatapadsara imadini ojari-jerani. Abi Dio huati tahi imittajarocca ibodidsa tojadsapi pina ijipajarossa najaro. Najarojinena idacorani nadsapi imadijaro” nani Dio Atti dsodo nanipi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nahi dsotode imasiri totonanade Satanapa Jeso odsa panani bicabote Jerosarehuaji iaccajari. Nanicca Diodsa dada toqquima tetepihuaji inanajari. ");
INSERT INTO cul_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nahidsa Satana Jesodsa huati tapomajari: —Jari, Dio Bedi tijadsapi joppa tinaronaneje, namihuaji tissona-jeranitohui −najari. —Aji Dio Atti dsodo nanidsapi ajima najaro: “Diopa pocca dodosse tabaqqui memehuajiccadsa huati tahitohui, tia ecahuamananijine. Pohuadeni bijidsa tia dama ijidsamanadsapi temori naqui sibadsa cabiquera-jeranitohui” nani Dio Atti dsodo nanipi −najari Satana Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Naraha manaco Jeso huati tapomajari: —Jehe, Dio Atti dsodo nani nema naraha Pohua Atti dsodo nani onihipi ajima najaro: “Tia Medsede Dio nattome tajarajo. Tettidsa: ‘Dio ohuacatamana’ tejeraji” nani Dio Attipi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nahi dsotode Satanapa ssono imeni huaji tanihuaji Jeso iaqquemorajari. Nahihuaji bacco toquinadsa Satanajine dsama huapima Jesodsa ahuato inanaridsajaro. Dsama huapima bica tanicca, odsa panani huapima bica tanicca Jeso dsopi icanaridsajari Satanapa. ");
INSERT INTO cul_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nadsapa Satana Jesodsa huati tapomajari: —¡Qqui taneje! Ajijaro dsama huapimapi tiadsa da onanijine. Jehe, obaccohuaji tipitodsa tittadsa ohuadsa tetidsedsa: “Occa tamine” taji. Ohuadsa nema tadsapi ajijaro huapimapi ticca tojanijine, onajaro −najari Satana atti. ");
INSERT INTO cul_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Naraha manaco Jeso Satanadsa huati tajari: —¡Satana, ajicca ticcaniji! Epejena. Ohuapi tiadsa ohuatidsena onejerani. Dio Atti dsodo nanidsapi ajima najaro: “Ia Medsede Dio Pohuadsara tetidsemanani ojari dsanapoji. Pohua Attidsara iboraqquiri tiquinaji” nani Dio Attipi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nadsapa Satana toccanijari. Nanaja Diocca dodosse tabaqquipa najoramanapoja nadsa Jeso acco icamamanahijine jahironajari. ");
INSERT INTO cul_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dsotode Jesopa —Huano Baotista toponi cocorodsa coro idsimamanahi −quinahi ima mittadsapa dsama arobeni onini Carireahuaji toccanijari. ");
INSERT INTO cul_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Naraha Jesopa odsa panani Nasaretidsa tomadinipoma-jarajari. Odsa panani Capernaohuajina madihijine toccajari, nahi Carireacca coridsa inidihuaji. Jesopa nahihuaji madihijine toccadsapa Isaraeri bedi Dsaborona potemahidenicca dsamabotedsa ccaridsa, Isaraeri bedi Netari potemahidenicca dsamabotedsa naco ccaridsa najari. ");
INSERT INTO cul_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jeso nahihuaji madihijinecca imapi maittaccadsama Dio Atti cacomerabote Isahia dsodo inapojaro. Pohua attipa: ");
INSERT INTO cul_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","—Dsaborona potemahidenicca dsamabotehuaji, Netari potemahidenicca dsamabotehuaji naqui ima bicani cajini. Ia Idinide nahihuaji madimanajaridenidsa bacco tajari, pina ssiajanissa najari. Nahihuajipa jodio quejena-jarajarideni caji tahi. Coridsa huapicca dsama, hueni Jordao maji toccahihuajicca dsama onini Carireadsapa Diodsa ssamoqquiri naha madimanajari. ");
INSERT INTO cul_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Dsidsinidsa madimanadsapa dsoqquehe noppineni cappinamanaraha ssiajani dsati pohuadenidsa tossiajaridsadsapi Diojine madija tocassiejerahijine tahimarini ahuato inananitohui −napohui nade Dio Atti Isahiajine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nahihuaji Jeso bacco tadsana Dio Atti maride tahide idimapojari. Madija mari mari ihicanabaqqui nadsa pohua attipa: —Ticcadeni ima Diodsa tecomeramanadsa ticcadeni imasiri tinebomanaji. Diotohuira tidsanapomanaji. Diocca cacahuehepi iadsa bacco najonabote nani −nanaridsa najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jeso Carireacca coridsa inidi toccabacossadsa madija pamaha qqui inabaqquijari: Ssino pohua oni ohuaha Pedro, pohua ohuaha Adiri tedseje. Pohuadenipa aba cocorodedeni. Aba corode toquejenaraha Jeso bacco najonajari. ");
INSERT INTO cul_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pohuadenidsa huati tajari: —Jina, ohuadsa ticadaridsaji, ohuatimade tiquejenadsapi tiadeni onahattabaqquinijine. Tahidepi abadsa tidsepedeni ijimanaporaha jidapapi madija ohuadsa toquejenahijinena tidsepedeni ijimananitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Najaro ima mittamananaja poccadeni tajapa icanebomanadsa Jesodsa tohuedajari. ");
INSERT INTO cul_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nadsapa denima jai tojabacossanaja Jesopa madija ohuaha pohua imecote tedseje qqui inabaqquijari. Najaridenipa Sebedeo bedideni Satiaco, Huano quinajari. Poccadeni abi quinadsa canoadsa jassi dsajari. Tajapa ssequinimade toquejenaraha Satiaco, Huano tedseje Jeso huahua inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Najarideni naco amadsati poccadeni canoa icanebomana, poccadeni abi inebomana nadsa Jesodsa tohuedajari. ");
INSERT INTO cul_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesopa Carireahuaji ccaridsa ccaridsa naridsajari. Nani Isaraeri potemahi jodiodenicca Dio Atti mamari onihi onihi naridsanihuaji mari mari nanaridsa najari. Pohuapa Diocca cacahuehecca ima bicani ehecomeraridsa najaro. Comaqquiri najarideni naco comani onihi, onihi cajiridsamanaraha huapima ihinanomi-ridsabaqqui najari. ");
INSERT INTO cul_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pocca imapi dsama Siria nemanehehuaji madiridsamanajarideni naco mittaridsamanadsapa poccadeni dsama huaji taraha comaqquiri najarideni eheccajona-baqquimana najari. Dsamacoma cajimanajarideni, isso sirideni, biji sirideni, comani onihi onihi cajimanajarideni eheccajona-baqquimana nadsa huapima Jeso ihinanomi-ridsabaqqui najari. Madija bodidenidsa Satanacca dodosse tabaqqui tocorimedeni madidsamanajarideni, aja huatiajojo comani cajimanajarideni, aja madija idedeni tone biqueradsa issodeni ssomi toquejenajarideni naco eheccajona-baqquimana nadsa Jeso ihinanomibaqqui najari. ");
INSERT INTO cul_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nani Carireahuajicca madiridsamanajarideni mota, dsama arobeni onini Decaporihuajicca madiridsamanajarideni mota, odsa panani Jerosarecca madimanajarideni mota, dsama arobeni onini Jodeahuajicca madiridsamanajarideni mota, hueni Jordao maji ccajonahihuaji madiridsamanajarideni mota naco huapima Jesotohui disseraqquiri nadsa jahijonana canajari. ");
INSERT INTO cul_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesopa madija huapima pohuadsa queriqquihi qqui tadsapa ssonohuaji toqquemorajari. Nahidsana maride huittarijari. Jesocca mamari tabaqquipa pohuahuaji huajijira canajari. ");
INSERT INTO cul_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nadsapa mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Tiadeni motta tibodideni tobicanijine tipajiramana-jerani nahatoqquiri tiquinadsapi Diopa tiadenidsa ima bicani inanajaro. Diocca cacahuehe tiadenidsa tojanitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Tibodideni huanacossadsa oji tiquinaraha Diopa tiadenidsa ima bicani inanajaro. Dio tibodideni acco camahitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Tiadenidsa ima tabaccora tanicca bacco taraha tedimana-jeradsa tibodideni: “Nidsa Dio ohua acco camahitohui” tiquinadsapi Diopa tiadenidsa ima bicani inanajaro. Nidsa Diojine dsama dsati tojadsa najaropi ticcadeni cacahuehe tojanitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Tibodidenipi pina: “Occa ima Diodsa pajiranissa taccaraho, Pohua Attissa onananijine dissera onana” tiquinadsapi Diopa tiadenidsa ima bicani inanajaro. Tibodidenidsa jipa tinajarocca Dio tiadenidsa inananitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Tiadenipi madijadsa tetideni huanaqquiri nadsa pohuadenidsa ima tojadsapi pohuadeni acco ticamabaqquimanadsapa Diopa tiadenidsa ima bicani inanajaro. Diopa tiadenidsa naco huati huana tahitohui, tiadeni acco tocamabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Tibodidenidsa Diotohuira tiquinadsapi ticcadeni ima quejema-jeradsapi Diopa tiadenidsa ima bicani inanajaro. Jidapapa Dio tiadenidsa tojidserajari. Nidsa memehuajipa Dio Pohua qqui tiquinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Madija ohuaha tijinedeni cajoneradsapa Diopa tiadenidsa ima bicani inanajaro. Diopa tiadenidsa: “Occa ejedenideni” najari. ");
INSERT INTO cul_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Diodsa disseraqquiri tiquinadsa Pohua Attissa tinanamanadsapi jehe quina-jarajarideni tiadeni tonajidso-baqquimanaraha Diopa tiadenidsa ima bicani inanajaro. Diocca cacahuehe tiadenidsa tojanitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Occa madija tiquejenajarojinepi madija tiadeni totamasso-baqquimanadsa, tiadeni tonajidso-baqquimanadsa, ticcadeni ima totabaccoranijine maidsa maidsa quinadsa naco Diopa tiadenidsa ima bicani inanajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tetidsemanaji. “Epejeni bica tani” tiquinaji. Memehuaji bacco tiquinadsapi Diocca daniji bicabote ticajimananitohui. Maittaccadsama naco Diodsa jiperaqquiri najaridenipa aja Dio Atti cacomeraqquiri najarideni inajidso-baqquimanaja najonapohui najari −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Tiadeni aji ohuadsa jehe tiquinajaropi pina sahocca imassa tiquinajaro. Sahopi bani bica tahijine. Aji tiadenipi pina sahossa tiquinajaro, ajijaro dsamacca madija tinanabicabaqqui-manahijine. Saho ajiboni amossi nadsapi ajiboni cajipomanijine ssamo tani. Nadsapi tiadeni naqui ajijaro dsamacca madijadsa ima bicani tinanamanaridsanijine nebomana tiquinejeraji Ticcadeni jeheniji ponima toja-jerana. Saho ponima tojadsapi madija coro quinadsa madijajine ttai ttai toja tani. ");
INSERT INTO cul_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Tiadeni aji ohuadsa jehe tiquinajaropi pina ajijaro dsamacca ssiajanissa tiquinajaro. Ossiejene ticajimanadsapi dsama huapimacca madijadsa otahimari tijinedeni ahuatoridsajaro. Tissiejenedeni ahuato tadsapi pina odsa panani ssono tetepihuaji ahuato tajarossa najaro. Ssonocca odsa pananipi najimanijine ssamo tani. ");
INSERT INTO cul_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jojororo naco toquehessidsapa icanajimahijine jarahi. Ssapotodsa boco icanahijine jarahi. Nadsa jojororo toquehessidsapa aja pohua cacahittari nahidsana cacahittari najari, nahi madija odsa bodihuaji madimanajarideni huapima ssiajani cajimanahijine. ");
INSERT INTO cul_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tissiejenedenipi pina najaro ssiajanissa tiquinajaro, madija huapimadsa tossiajabaqquinijine. Ima bicani titinanamana najaro, madija huapima qqui toquinahijine. Nema tinanamanadsapi Abi Dio memehuaji madijaridsa pohuadsa huatidsemanadsa: “Diopa bica tahi” quinahijine −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesopa denima mari icanabaqquidsapa pohua atti ajama najari: —Tiadenipi: “Jesopa Moisesicca marinaja jicanijine ccajonajari” tiquinejeraji. Tettideni onihi naqui: “Jesopa maittaccadsama Dio Atti cacomeraqquiri najaridenijine dsodo nani naqui inajicanijine” tiquinejeraji. Ohuapi najaro marinaja huapima pajiranissa tanijine occajonajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ohuapi pajissara tiadenidsa huati onajaro. Aji meme, nami jiquejeraccadsa Moisesicca marinajapi nebo-jeranitohui. Meme, nami jicadsapi Dio Atti dsodo nanicca marinaja huapima pajiranissa tanitohui. Tohuatti ojarie dsori teje cama-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nadsama madijadenipa Dio Atti ojariedsa iboqquiri nadsapa imasiri cajimanajari. Madija ibo tajari pohua tesse tohuibohuijine mari icanajari attipa: “Diocca dosseniji motapi najo tani, tineboji” nanaja nadsapa najaripa Diocca cacahuehedsa ajamani tojahitohui. Naraha madija ohuaha Diocca dosseniji huapimadsa ibora tajaripa pohua tessedsa: “Diocca dosseniji huapimadsa ibora tinaji” nanaja nadsapa najarina Diocca cacahuehedsa deni tojahitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tiadenidsa huati onajaro: Diocca cacahuehedsa tiquejenanijinepi Dio Pohua jipa tajaricca tinanamanadsana pocca cacahuehedsa tiquejenanijine tipajiramanani. Aja jodiodenicca marinaja maridedeni, marinaja onini pariseodsa jehe quinajarideni tedsejepa Diocca dosseniji cacahuade disseraqquiri najari. Tiadeni naqui pina najarideni disseraqquiri najarissa tiquinana. Naraha tiadenipi denima tinapajiramananissa tana. Nema tiquinadsapi Diocca cacahuehedsa tiquejenanitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Ticcadeni ididenicca marinaja timittamanajonajaropi ajima najaro: “Madijapa tinanadsoqque-jarajo. Madija tinanadsoqquedsapa ima cacattemade atti tiadsa: ‘Manaco tidsoqqueji’ nahitohui” quiquinanade. ");
INSERT INTO cul_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Naraha tiadenidsa huati onana: Timecotedsa titessedsa naqui tedidsapi ima ticajinitohui. Ima cacattemahuaji: “Ticca imapi tabaccora tani” quinahitohui. Ticca huadie tinebo-jeradsa timecotedsa denima tatamasso tadsapi ima cacattemadedeni deni toquejenajaridenipa tiadsa ima inassonarimananitohui. Ticca huadie deni tojadsapi timecotedsa tabaccorehema tatamasso taraha ticca imana denima tabaccora tajaro. Nidsa ticca imapi Dio mittahitohui. Ticca ima nema nadsapi jororoni jiquejeranihuaji tijanitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","—Nadsama ticca daniji: “Diodsa da onana” tiquinadsa naqui Diodsa da tahijinecca huahuanarihuaji ticca daniji tiaccaraha aji timecotedsa ima tinanapojaro tibodi huato-dsanapoccani. ");
INSERT INTO cul_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nadsapi ticca daniji dsojo tidsimaraha Diodsa da tahijinecca huahuanaridsa hua tari-jaraccadsama nahidsa tineboccajo. Nadsapi timecotedsa ticcaji, ticca ima ticattemamananijine. Ticca ima ticattemamanadsa ticajonerapomadsana Diodsa da tahijinecca huahuanarihuaji ticcanipomaji. Nadsana ticca daniji Diodsa da tinahijine hua tarihi bica tahi. ");
INSERT INTO cul_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Nadsama madija ohuahadsa ima tinanadsa naqui pohua attipa: “Tia ohuaccana ima cacattemahuaji” nadsa naco tahide tia tohuacca-jaraccadsama pohua tedseje ticcadeni ima ticattemamanapoji. Pohua huati tinassonapojo, nahi taminehuaji tia tohuacca-jarahijine. Ticcadeni ima ticattemamanapo-jeradsapi ima cacattemahuaji bacco tinadsapi ima tinanajaro manaconi todsepe tijanitohui. Toponi cocorohuaji tia coro idsimamananitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pajissara tiadsa huati onajaro. Nani toponi cocorohuaji timadidsapi amadsati tiqquena-jeranitohui. Ima tinanajaro manaconi nemanehe tinajicanissa tadsana tiqquenanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Ticcadeni ididenicca marinaja timittamanajonajaropi ajima najaro: “Amoneje ticajidsapi amoneje onihipi tija-jeraji. Maqquideje ticajidsapi maqquideje ohuaha tinaja tajarajo” quiquinanade. ");
INSERT INTO cul_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Naraha tiadenidsa huati onana: Madijapa amoneje onihi qqui tadsa tohuini inacomadsapi pohua bodidsa imasiri inanajaro. Pina amoneje ijajarossa najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—Nadsama imasiri tinana-jeranijinepi tibodidsa daco tijiradsa poni taji. Poni tejeradsapi ima oppina tani tiadsa ssonarinitohui. Nadsama pina tinocco nahatoniccadsa tohuini tanicca qqui tinadsapi najarodsa imasiri tinananijine tohuini taraha daco tijiradsa poni taji, imasiri tinana-jeranijine. Nema tadsapi pina tinocco nahatonicca huari, joca, jeo, coro tinajarossa najaro, imasiri tinana-jeranijine. Tinocco ojarie amossi naraha ¡epeje! tessirema tissiajanitohui. Jororoni jiquejeranihuaji tija-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nadsama pina tidsepe nahatoniccadsa imasiri tinanabote naraha daco tijiradsa poni taji, imasiri tinana-jeranijine. Nema tadsapi pina tidsepe nahatonicca ca ticajidsajarossa najaro. Tidsepe cajarie amossi canaraha ¡epeje! tessirema tissiajanitohui. Jororoni jiquejeranihuaji tija-jeranitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Ticcadeni ididenicca marinaja timittamanajonajaropi ajima najaro: “Maqquideje: Occa amoneje onebona nadsapa tahide nebohuecca papeo dsodo inadsa ponidsa da inadsa inebodsapi pohuadsa ima nohuerani” quiquinanade. ");
INSERT INTO cul_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Naraha ohuattipi ajima onajaro: Ticca amoneje tinebodsapi imasiri tinanajaro. Ticca amoneje tinebodsa maqquideje ohuaha icajidsapa tijine poni naqui imasiri inanajaro. Ponicca maqqui icajidsati naco imasiri inanajaro. Diocca dosseniji naqui ecahuamana-jerajaro. Nadsama ohuattipi: ¡Paji! Ticcadeni amoneje nebomana tejeraji, onajaro. Naraha ticca amoneje maqquideje ohuaha inajadsana “Onebona” tadsa tinebodsapi tiadsa ima nohuerani. Ticca amoneje maqquideje ohuaha inajadsapa poni ponijine imasiri inanajaro. Nadsana tineboni oppinera tani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—Ticcadeni ididenicca marinaja timittamanajonajaropi ajima najaro: “Diodsa: ‘Pajissa ajima onanana’ tadsapi timaidsa-jeradsa aji huati tinajarossa tinanaji” quiquinanade. ");
INSERT INTO cul_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naraha ohuattipi ajima onajaro: “Pajissa ajima onanana” tadsapi ticca pajissehepi tohuatti onihi tadsajani huati tina tejeraji. Madijapa maidsamanadsa: “Pajissa huati onajaro” quinadsapa tohuatti onihi tadsajani inatassaqquidsa pina pajissehessa najaro huati toquinaraha maidsamanajari. Pohuadeni attissa inanamana-jeradsa: “Oppinera tani, Dio onidsa huati onapo-jerade” quinaraha Diopa attideni mittajari. Ajana madija attidenipa: “Occa imapi pajissa, memehuajicca nahato tahi” quinahipa bica tejerani. Memehuajipi Diocca huihuittari. Diopa mittahi. ");
INSERT INTO cul_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Madija ohuaha attidenipa: “Occa imapi pajissa, ajijaro namipi nahato tani” quinadsa naco bica tejerani. Namipi Dio amori cabarihijinecca huihuittari bedenissa najaro. Diopa mittahi. Madija ohuaha attideni onihi naqui: “Occa imapi pajissa, Jerosarepi nahato tani” quinadsa naco bica tejerani. Jerosarepi Diocca Cattaniji, tamine deni tojahicca odsa panani. ");
INSERT INTO cul_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Madija ohuaha attideni naco: “Occa imapi pajissa, occa nahatohuema huati onajaro” quinaraha pohuadeni attidsa tatideni amadsati tosohuehue nanijinepi ssamo tani. Pohuadeni tatideni amadsati tonopo-po nanijine naqui ssamo tani. ");
INSERT INTO cul_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nadsama tiadenipi pajissa tiquinadsa pajissara: “Jehe, pajissa” tiquinaji. Naraha poni tiquinadsa naqui “Jehe, poni” tiquinaji. ¡Epeje! Nema najarora huati tiquinanijine bica tani. Naraha tettidenipi tohuatti onihi tadsajani tinatassaqquimanadsapi bica tejerani. Najaropi pina mamaidsadedeni attidenissa najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—Ticcadeni ididenicca marinaja timittamanajonajaropi ajima najaro: “Madija ohuahajine tinocco sia tadsapi manaco pohua nocco sia tinanadsapa bica tani. Tino naqui. Madija ohuahajine tino jai tocanadsapi manaco pohua ino jai ticananadsa bica tani” quiquinanade. Manaco manacopi nama najonamanajari. ");
INSERT INTO cul_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Naraha ohuattipi tiadenidsa ajima onajaro: madijapa tiadenidsa tabaccorehe inanadsapi “Manaco” tiquinejeraji. Madija tipano idanidsa naco “Ohuaccone manaco odana” tiquinejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Madija attipa: “Ohuadsa ima tinanani” nadsa ima cattemadehuaji tia tohuaccadsa tamine attipa: “Ima tinanajaro manaconi pohuadsa titetepicca da tinaji” nadsapa pohuadsa da tinaji. Titetepicca onihi ssirinijine huatini ccara taraha najaro naqui nema nehe pohuadsa da tinaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nadsama madija naco benehi huaji tani toccahijine tiadsa huati tadsapa: “Jari, ohua acco ticamaji. Ajicca odsa onihidsa ohua tineboji” nadsapa pohua attissa tinanaji. Pohua tinebohuihuaji tineboraha denima pohua accode ticcanijine bica tani, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nadsama madija tiadsa: “Jari, ohuadsa manaconi jirehe da taji” nadsapa pohuadsa da tinaji. Madija ohuaha atti naco: “Pohuama ohuadsa da taccajo. Nidsa tiadsa da onanihijine” nadsapi teccocco-jarajo. Pohuadsa da tinaccajo, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—Moisesicca marinaja timittamanajonajaropi ajima najaro: “Titessedenidsa tetideni huanaqquiri nana” quiquinanade. Ticcadeni ididenicca marinaja timittamanajonajaro naqui: “Tiadeni huadidedenipa manaco ticahadibaqquijo” quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Naraha ohuattipi ajima onajaro: Tiadeni huadidedenidsa naqui pina tetideni huanaqquiri naji. Tiadeni najidsodedenipa Dio pohuadeni bodi acco icamabaqquihijine Diodsa huati huati tiquinana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nadsana tiadenipi Abi Diocca ejedeni tiquejenani ahuato tanijine. Dio memehuaji madijaripa bica tajari. Madija huapimadsa huati huana tajari. Bicaqquiri najaridenidsa huati huana tajari, tabaccoraqquiri najaridenidsa naco huati huana tajari. Dio pocca nahatohue majipa Pohuadsa jehe quinajarideni, Pohua Attidsa iboqquiri najarideni huapimadsa tossiajabaqquijari. Pocca nahatohue passo naqui Dio Pohuajine huapimadsa caji taridsajaro. ");
INSERT INTO cul_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tiadenidsa ohuatti ajima najaro: Madija tiadenidsa huatideni huanaqquiri najaridenidsara tetideni huanaqquiri nani ojari nadsapi pina madija huapimacca imassa tinanamanajaro. Najarossa tinanamanadsapi nidsa memehuaji Dio tiadenidsa: “Jehe bicaqquiri tiquinani” najarahitohui. Ajana, imasiri cajimanajarideni pina romanodenicca taminecca dosseniji dsiniro nanaccadedenipa aja pohuadenidsa huatideni huanaqquiri najaridenidsara huatideni huanaqquiri nahi ojari najari. Paji, pohuadenissa tiquinejerana. Tiadenipi tohuati huanehe denima bica tanicca ticajimanadsana bica tani. ");
INSERT INTO cul_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nadsama tiadenipi ticcadeni madijadsa tetidsemanadsa: “¿Nija, bica tinaqui?” tiquinaraha madija ohuahadsa: “¿Nija, bica tinaqui?” tiquinejeradsa pina madija ohuahadenicca madiessa tiquinajaro. Ajana, Diodsa jehe quina-jarajarideni poccadeni madijadsa: “¿Nija, bica tinaqui?” nanaridsamana naraha noccodeni jidsa tajaridsapa: “¿Nija, bica tinaqui?” quina-jarahi. Paji, tiadenipi pohuadenissa tiquinejerana. ");
INSERT INTO cul_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ticcadeni Abi Dio memehuaji madijaripa pocca tohuati huanehe pajiranissa tajaro. Tiadeni naqui tinapajiramananissa taji, pina ticcadeni Abi Diocca tohuati huanehessa tinanamanana, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Pajissara Dio Pohuadsa tidsepedeni ijimanadsa ima bicani tinanamanadsapi madija qqui toquinahijinera tidsepedeni ijimana tejeraji. Madija tiadeni qqui toquinadsa attidenipa: “A, tijinedeni bica tani. Bicaqquiri tiquinani” quinahitohuira timadimana tejeraji. Paji, attideni nama quinahitohuira timadimanadsapi Abi Dio memehuaji madijaripa najaro ima nahato tapoja najari. Nidsa dsotode pohua baccohuaji tidomodeni huadsapi: “Tijinedeni bica tani. Bicaqquiri tiquinani” najarahitohui. Pocca daniji bicabote naqui tiadenidsa da inejeranitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Nadsama cappiramanajaridenidsa manaconi jirehe da tinabaqquinijinepi pohuadenidsa teti huana tadsa manaconi jirehe da tinabaqquini bica tani. Naraha madija tijine bica tani qqui toquinadsa: “A, bica tahi. Pohuapa cappiramanajaridenidsa manaconi jirehe da da najari” quinahijine tohuini tadsapi bica tejerani, onajaro. Attideni nama quinahi tohuini tadsapi pina maidsajidede rabotedenissa tajaro. Pohuadeni naco cappiramanajaridenidsa da da quinaraha huatideni huanaqquiri najarajari. Pohuadenipa madija mittamanahijine jodiodenicca Dio Atti mamarihuaji huati huati toquinajari, amossinihuaji naco huati huati toquinajari. Pohuadeni poccadeni imaraha: “Ijine bica tani, bicaqquiri inani” quiquinanajari. Madija ohuahadeni attidenipa: “¡Pajissa! Bicaqquiri tiquinani” quinahitohuira madimanajari. Naraha ohuapi pajissara tiadenidsa huati onajaro: Najaridenipa tahide tohuini quinahicca cajimanapodsapa nidsa dsotode Dio Pohua baccohuaji domo huadsa najaridenidsa Diopa: “Jehe, epejeni. Bicaqquiri tiquinani” najarahitohui. Pocca daniji bicabote naqui da inejeranitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Naraha tiapi cappiramanajaridenidsa da tinanijinepi ticca ima tecomeraridsa tejeraji. Titesse bica tajaridsa naco ticca ima huati tina-jeraji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ajina, cappiramanajaridenidsa da tinanijinepi madija ohuahadeni qqui toquina-jaradsana da tinani bica tani, onajaro. Nema tadsapi madija ohuahadeni ticca daniji nahatoqquiri najararaha Abi Diona nahato tahi. Nidsa dsotode Dio Pohua baccohuaji tedsa tia catidsedsapa: “Jehe, epejeni. Bica tinani” nahitohui. Pocca daniji bicabote naqui tiadsa da inanitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Abi Diodsa huati tiquinanijine naqui pina maidsajidede rabotedenissa tiquinejeraji, onajaro. Najaridenipa Diodsa huatide toquejenadsapa pina madija Diodsa disseraqquiri najarissa quinaraha maidsamanajari. Nadsa najarideni nama quiquinanajaridenipa jodiodenicca Dio Atti mamarihuaji domo huedsadsa, amossinihuaji domo huadsa naco madija ohuahadeni mittamanahijine Diodsa huatide totoquejena najari. Madija ohuahadeni attidenipa: “A, Diodsa huatide disseraqquiri nahi” quinahitohuira mamadimana najari. Noccodeni jo najonahi quinahitohuira madimanajari. Nadsama ohuapi pajissara tiadenidsa huati onajaro: Najaridenipa tahide tohuini quinahicca cajimanapodsapa nidsa dsotode Dio Pohua baccohuaji domo huadsa najaridenidsa Diopa: “Jehe, epejeni. Bicaqquiri tiquinani” najarahitohui. Pocca daniji bicabote naqui da inejeranitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Naraha tiapi Abi Diodsa huati tinanijinepi “Ohua icattaqquimana-jerana” tadsa ticca odsa bodihuaji tiqquedsima, noccobiji ticahacossa nadsa tia motta Diodsa huati tinaji. Nema tadsapi madija ohuahadeni ticca huatinaja mittamana-jararaha Abi Diona mittahi. Nidsa dsotode Dio Pohua baccohuaji tedsa tia catidsedsapa: “Jehe, epejeni. Bica tinani” nahitohui. Pocca daniji bicabote naqui tiadsa da inanitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Diodsa huatide tijadsa naqui ticca huatinaja huati tinadsapi huati tinajaro, huati timanipomajaro, huati timanipomajaro tejeraji, onajaro. Ajana, Diodsa toquejena-jarajaridenipa nama nama quiquinanajari. Tohuini quinahicca tohui pohuadeni cacahuade huatide toquejenadsapa huati toquinajari, huati nimanimana-pomajari, huati nimanimana-pomajari quiquinanajari. “Nema inadsa etti mittahijine” quiquinanaraha pohuama huati huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Naraha tiadenipi pina pohuadenissa tiquinejerana. Diodsa ponima huati huati tiquinejerana, onajaro. Ajina, ticappiramananicca huapima Dio Pohuadsa huati tiquinejeraccadsama Pohua bodipa nahato tapohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Nadsama Diodsa huatide tiquejenanijinepi tettidenipi ajima tiquinaji: “Jehe Abi Dio, memehuaji timadijaro, Tiadsa iquejenajaropi ticca madija iquejenajaro. Tiapi nahatojide tijirani ojari tani. ¡Bica tinani! Madija huapima: ‘¡Dio, Tiapi deni tijani!’ quinana, inajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ticca cacahuehe huapimadsa tinanaridsana, inajaro. Pina memehuaji Tiadsa madimanajarideni huapima Tettidsa iboraqquiri dsadsanapomana najarissa quinahijine aji namihuaji imadijaro ia huapima naqui Tettidsa iboraqquiri inana, inajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Itapari naco huada huajijiradsa iadsa da da tajo. ");
INSERT INTO cul_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Madija iadsa tabaccorehe inanamanadsa poccadeni tabaccorehedsa: ‘Epejena, huadi onejerani’ inadsapi manaco icca tabaccorehe epeje tinanaji, Abi Dio. Icca tabaccorehe manaconi najidsohue iadsa tinana-jeraji, inajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Imasiritohui ibodi huatodsa naqui najaro tohuini inejeranijine ia acco ticamabaqquiji, imasiri inana-jeranijine, inajaro. Tabaccorehe jinede Satana pohuahuaji ia joca todsimanibaqqui-jarahijine ia tecahuabaqquinissa taji, inajaro.  Tiana ia huapima tecahuabaqqui-dsanapojaro. ¡Daco tijirani! ¡Bica tinani! ihidsanapo najaro.  Epejeni.” ");
INSERT INTO cul_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nadsama Jesopa pohuadenidsa denima huati tajari: —Jehe, ajina madija tiadsa ima inatabaccoradsa naqui tiapi: “Najaro imadsa ohuati ajimana. Pohuadsa ohuadi-jerana” taji. Nema tadsana ticca Abi memehuaji madijari ticca imasiridsa huati ajamahitohui. ");
INSERT INTO cul_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Naraha madija ohuahacca imadsa epeje tejeradsapi ticca Abi Dio naco ticca imasiri epeje inana-jeranitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Diodsa huatide tiquejenanijine jipehe tinebocossamanadsapi tipanodeni odsaqquiri nejerana, pina tipanodeni bica tadsa timadimanana, onajaro. Naraha tipanodeni odsaqquiri nadsapi pina maidsajidede rabotedenissa tiquinarana. Najaridenipa madija ohuahadeni qqui toquinadsa: “A, jipehe nebocossamanahi, Diodsa disseraqquiri nahi” quinahijine tohuira quinadsapa pohuadenijine pohuadeni cacahuamanahissa tajaradsapa ocasseraqquiri nanaja najari. Nadsama pajissara tiadenidsa huati onajaro: Najaridenipa madija attideni tohuira quinadsapa pohuadeni tohuini quinahicca tahide cajimanapojari. Nadsapa dsotode Dio Pohua baccohuaji domo huadsa Diopa pohuadenidsa: “Jehe, epejeni. Bicaqquiri tiquinani” najarahitohui. Pocca daniji bicabote pohuadenidsa da inejeranitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Naraha jipehe tinebocossanijinepi tahide tipano ssahua, titati ssiri tadsana jipehe tinebocossani bica tani. ");
INSERT INTO cul_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nadsama jipehe tinebocossani madija ohuahadeni ssamoqquiri naraha Abi Diodsapi ahuato tani. Pohuana nahato tajari. Nidsa dsotode Pohua baccohuaji tedsa Diopa tiadsa: “Epejena, ticca ima bica tani” nahitohui. Pocca daniji bicabote naqui tiadsa da inanitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Jehe, aji namidsa timadimanaccadsapi tidsepedenitaji tinahapimananijine tohuinira timadimana tejeraji. Ajina, todsepetaji tinahapimanadsapi poni maccanijine ssari nani caji tani. Motapi ponira majatoni caji tani. Motapi ponira botedsa jadsi tani. Motapi botie toja tani. Nema nadsapi tidsepedenitajipi jica-ca-ca... nemanehe amossi nani caji tani, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nadsama aji namidsa timadimanani paji naccadsama Dio Pohua tohuini nahicca tohuira timadimanaji, onajaro. Memehuaji aja Dio madihidsana ima bicani tiadenidsa tohuapiponijinepi ajijaro namidsa tidsepedeni ihijimana naji. Nema tiquinadsapi Diocca daniji bicabote tiadenidsa da inanitohui. Najaro Diocca danijipi poni maccanijine ssari nanijine nohuerani. Majatonijine nohuerani. Bobotide botihijine nohuerahi. Paji jicarinijine naqui nohueranitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ajina, tiadenipi ajijaro namicca todsepetaji tohui, dsiniro tohuira timadimaneje nadsapi najarodsara tetidseridsamanajaro. Naraha Dio Pohua tohuini nahicca tohuira timadimanadsapi Diocca danijidsana tetidsemananitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Inoccopi essiredsa pina jojororossa najaro. Inocco bica tadsapi essire ssiajani ijini. Idsepedsa naqui damade nahato inajaro. Emoridsa naqui ccaridsade nahato inajaro. Icca tarabaidsa naqui ipajirajaro. Ibodi huatode naqui nahato inajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Naraha inocco bica tejeradsapi pina inocco dsidsi tajarossa najaro, essire nemanehe issamo tani. Dama inanijine naqui ssamo tani, iccaridsanijine naqui ssamo tani, icca tarabaidsa naqui ssamo tani. Imapi najarossa najaro tibodidenidsa Dio ssiejene toqquedsimadsapi tibodideni ssiajani cajini. Naraha Dio ssiejene toqquedsima-jeradsapi tibodidenidsa pina dsidsini ijiridsajarossa najaro. Aji tiadenipi: “Nahatoqquiri inani. Ibodi ssiaja tani” tiquinaraha najaro ssiajanipi occa imassa nejeradsapi ssiajani ticajimana-jerajaro. Dsidsini oppina taniccadsa timadimanajaropaji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Jehe, madija pohua dossede pamahadsa dsepe ijihijinepa pajira-jarahi. Dossede pamaha cajidsapa ojariadsana huati huana tajari. Pohua attidsana ibora tahitohui. Ohuahadsa ajimani huati huana tadsapa pina pohuadsa jipera tajarissa nahitohui. Pohua attidsa ibo tahitohui. —Madija Diodsa dsepe ijidsapa dsinirotohuira dsepe ijihijine ssamo tahi. Dsinirotohuira huatidsedsapa Diodsa huatidsehijine ssamo tahi. Ima pamehepi Diotohui, dsinirotohui najaripa madihijine ssamo tahi, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Nadsama tiadenidsa ohuattipi: Timadimananijinecca ticappiramanani noppineni ticappinamana tejeraji, onajaro. Pina ¿nejecora ojipapadseje? ¿Nejeco dsamatapa ppejenera dse onapadsaja? ¿Nejecora ohuedsapadseje? tiquinejeraji. Najarotohuipi tibodideni huahuatomacca nejerana, onajaro. Icca madiepi dsamatapaha ojari-jarahi. Icca madiena denima bica tajaro. Essire naqui etero edsanijinea ojari-jerani. Essirecca imana denima bica tajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","—Ajana, meme abarideni memedsa jahiridsajaripa qqui qqui tiquinani. Najaridenicca imadsa tibodideni huatoma-manaji. Pohuadenipa huidsajacca ppa nahi pperaqquiri, huidsajacca ppa nahi bono poreraqquiri nadsapa nidsa dsotode jipamanahijine ppa nahi bono naco odsadsa ecahuamana-jarajari. Naraha ticcadeni Abi Dio memehuaji madijaripa pohuadenidsa jipamanahijine da da ihinanajari. Diopa meme abaridenidsa huati huana taraha tiadenidsana denima huati huana tajari. Tiadenidsa naco tijipamananijinecca da da ihinanahitohui. ");
INSERT INTO cul_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Naraha tiadenipi ¿nejecotohui tibodideni: ¿Denima omadi-dsanapopadseje? tiquinajaro? Najarotohui tibodideni huahuatomacca nadsapi ¿ticcadeni madie denima tinanamananijine nahatoqquiri tiquinaqui? ¡Nahatoqquiri tiquinejerani! Ponima tibodideni huahuatomacca nejerana, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—Nadsama ima onihi naqui: ¿Nejecotohui etero ticajicamanani noppineni ticappinamanajaro? Najarotohui tibodideni huahuatomacca nejeraji. Jari, qqui tiquinanaja mohue ppata taridsajari. Mohuepa tarabaidsera, huepe picocora, etero ssequiquira taraha ppata taridsadsapa pina etero bicani huedsamanajarissa najari. ");
INSERT INTO cul_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ajana, maittaccadsama naco Isaraeri potemahidenicca tamine Saromopa dsepe ssejide radsapa etero bicani huatini ccara tanicca huedsadsapa bica tataja naraha mohuena denima bicaqquiri najari, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¡Jaho, ticcadeni jehenijipi badsira tani! ¿Nejecotohui tiadenipi “Dio ia tohuacahua-baqquihi” tiquinejerani? Ajina, dseropi etero huedsanijine cappiraraha Diojine poni mohueni cajidsapi pina etero bicani huedsajarossa nani. Dseropi mohueni cajini bica taraha huada huada nadsa dseqqueri nadsapi botta ina tani. Naraha dseropi ajimanicca. Tiadenipi pina aji dserossa tiquinejerani. Diocca cacatidse tabaqqui tiquejenajaro. Nadsama Diopa tedsamananijinecca etero naqui denima tiadenidsa da inanitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Naraha tiadenipi timadimananijinecca ticappiramanani noppineni ticappinamana tejeraji. Pina ¿nejecora ojipapadseje? ¿Nejeco dsamatapa ppejenera dse onapadsaja? ¿Nejecora ohuedsapadseje? tiquinejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Diodsa toquejena-jarajaridenipa nama nama nanaridsamana najari. Poccadeni jijipa tohuira, pohuadeni dsepetaji tohuira bodideni huahuatoma-mana najari. Naraha ticcadeni Abi Dio memehuaji madijari ticajimanani. Pohuapa ticappiramananicca huapima nanahato najari. ");
INSERT INTO cul_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Diocca cacahuehecca imadsa tibodideni huatomaridsanijine Diotohuira tataridsamana naji. Dio Pohua jipa tahiccadsara tetetidsemana naji, onajaro. Nema tiquinadsana Diojine ticappiramananicca tiadenidsa inanaridsanitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—Jehe, titedsejemadenicca huada tahimarini tohui tibodideni huahuatoma-mana nejerana. Pina: “¿Dsemassa nejeco imara tojapadseje?” titiquina nejerana, onajaro. Jidapanacca ssiaja tahimarinira tibodideni huahuatoma-mana nana, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Nadsama tiadenidsa ohuattipi: Madija ticattejidsamana tajarajo. Pina madija ohuahacca ima tiadenidsa bica tejeradsapi: “A, namajide rahi, pocca ima bica tejerani” tiquinejeraji, onajaro. Madijadenidsa tettideni nema tiquinejeradsapi manaco Diopa tiadenidsa: “Ticcadeni ima naqui bica tejerani” najarahitohui. ");
INSERT INTO cul_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Madija ohuahacca ima tibodidenidsa huatoma-manajaropi pina pocca ima nattome tiquinajarossa najaro. Naraha madija ohuahacca ima nattome tiquinadsapi manaco ticcadeni ima naqui nattome quinanitohui. Madija ohuahadsa tinanamanajarocca imapi manaco tiadenidsa najarossa inanamananitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Naraha tiadenipi timecotecca madie pina Diocca dossenijissa nejerani qqui tiquinadsa tettidenipi: “A, tijine bica tejerani” titiquina naraha tiadeni naqui imasiri ticajimanani. Nadsama najaro ticcadeni imapi pina timecote noccodsa ahua majiconi huedsani qqui tinajarocca imassa najaro. Timecotedsa: “A, tinoccodsa ahua majiconi huedsaha, tire oninena” taraha tinoccodsa naqui ahua majiconi imeni huedsani. Qqui tinanissa tejerani, tinocco ahuatora tani. ");
INSERT INTO cul_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nadsama tiadenipi imasiri ticajimanadsapi ¿nejecotohui timecotedsara: “A, tijine bica tejerani. Tia acco ocamana, ticca ima tobicanijine” titiquina naraha tiadenipi tahide ticcadeni imaha tijinedeni tobicapo-jerajaro? ");
INSERT INTO cul_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Jaho, nema tiquinadsapi pina mamaidsadedenissa tiquinajaro! Ticcadeni ima bica tejeradsapi tahide ticcadeni imaha tinabicamanapoji. Nadsana timecote acco ticamamanahijine tipajiramananitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Tiadenidsa ohuatti onihi naqui: Madija Dio Atti mittade jiperaqquiri najaridenipa pina ettessa, pina porocossa quinajari. Ettedsa bica tanicca da tiquinaraha tiadeni cca naja camahitohui. Poroco naco pohuadsa perla bica tanicca da tiquinaraha ssamo tadsa ttai ttai inananitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Jehe, Abi Diodsa huati huati titiquina naji, onajaro. Dio Pohuadsa huati tiquinadsapi tiadenidsa ticcadeni huatinajassa nehe da inanitohui. Pina tohuini tanicca qquide dissera tinadsapi bacco tinanitohui. Najarossa najaroa Diodsa huatide dissera tinadsapi Pohuapa ticca huatinaja tiadsa inapajiranissa tanitohui. Pina madijacca odsadsa tiqquedsimanijine tohuini tadsa odsa jinededsa huahua tadsapi tiadsa noccobiji icatabojidsanitohui. Najarossa najaroa Diodsa huati huati tiquinadsapi ticcadeni huatinaja mittahi. ");
INSERT INTO cul_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","¡Pajissa! Madija Diodsa huati tadsapa Diopa pohuadsa pocca huatinaja da inanitohui. Madija naco Diodsa huatide dissera tadsapa Dio Pohuajine pocca huatinaja inapajiranissa tanitohui. Madijapa pina Diocca noccobijidsa huahua najarissa nadsa Diopa pohuadsa noccobiji icatabojidsanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Ajana, madijapa pocca ejedeni pan tohui huati tadsapa ¿pohua bedidsa siba da ina taqui? Nohuerani. Tiadenidsapa madija nama najari nohuerahi. ");
INSERT INTO cul_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Madija ohuaha naco pocca ejedeni aba tohui huati tadsapa ¿pohua bedidsa macca da ina taco? Nohuerahi. ");
INSERT INTO cul_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tiadenipi tabaccorehe ticajimanaraha ticcadeni ejedenidsa bica tahicca dade nahatoqquiri tiquinani. Nadsapa ticcadeni Abi Dio memehuaji madijari Pohuadsa huati tiquinadsapi tiadenidsa bica tahicca dade denima jipa tahi, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Jehe, nadsama tiadenidsa madija huapima ima bicanira inanamananijine tohuini tiquinadsapi madija huapimadsa naqui ima bicanira titinanamana naji, onajaro. Nema tiquinadsana Dio Atti tecahuamananissa tajaro. Aji Moisesicca marinajassa tinanamanajaro, Dio Atti cacomeraqquiri najaridenicca dsodoniji naqui najarossa tinanamanajaro, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Diocca cacahuehedsa tiquejenanijinepi ohuadsa jehe tiquinanissa taji. Pina noccobiji tojera tanihuaji jai tijedsimajarossa tiquinaji. Madijapa ohuadsa jehe quina-jarajaridenipa pina noccobiji toja tanihuaji jai tojedsimajarissa quinajari. Pina jahui imeni toccade najora tanihuaji jai tojajarissa quinajari. Naraha najaro jahuipi najidsohue jiquejeranihuaji toccajaro. Nahihuajina madija huemaha toquejenajari. ");
INSERT INTO cul_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Naraha madija ohuadsa jehe quinahissa tajaridenipa noccobiji tojera tanihuaji jai tojedsimajari. Pina jahui bedenihuaji jai tojajarissa quinajari. Najaro jahuihuaji jai tojadsa Diocca cacahuehedsa bacco toquinadsapa camittehe jiquejeranicca cajimanahitohui. Nahihuajipa madija pamadema dsanapojari −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Jehe, tiadenidsa ohuattipi: Paji, madija mamaidsadedeni tiadeni tocamaidsabaqquihijine bacco toquinahitohui. “Dio tahimari ecomeraridsajaro” quinaraha maidsamanajari. Pohuadenipa pina edede joneqquiri najarissa quinaraha bodidenipa pina dsomaji oppinabotessa quinajari. ");
INSERT INTO cul_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Poccadeni madie tinoccodenidsa qqui tiquinadsa ima bicani inanamana-jeradsapi nahatoqquiri tiquinanijine: mamaidsadedeni quejenajari. Ajina ¿cotihidsa uva bono pore pore quinaco? Nohuerahi. ¿Jessi ininedsa naco iquiera bono pore pore quinaco? Nohuerahi. ");
INSERT INTO cul_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ahua ede bica tadsapa bono naco bica taha cahua tahi. Naraha ahua ede bica tajaradsapa bono naco tabaccora taha cahua tahi. ");
INSERT INTO cul_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ahua ede bicahidsapa bono tabaccora taha cahua-jarajari. Ahua ede tabaccora tadsapa bono bica taha cahua-jarajari. ");
INSERT INTO cul_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ahua huapimapa bono bicahi cappiraridsa-manadsapa ca ippiridsamanadsa botta quinajari. ");
INSERT INTO cul_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aji madijacca ima naqui pina ahua bonocca imassa najaro. Madijapa: “Dio tahimari ecomeraridsajaro” quinaraha ima bicani inanamana-jeradsapi mamaidsadedeni quejenajari nahatoqquiri tiquinani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Madijapa ohuadsa attideni: “Ohua Medsede” quiquinanahi huapi taraha motapa Diocca cacahuehehuaji jai tojedsima-jarahitohui. Occa Abi Dio memehuaji madijari Pohua tohuini nahiccara inanamanajarodenina Diocca cacahuehehuaji jai tojedsimahitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nadsapa nidsa madija huapimacca ima Dio icattemanijinecca huada bacco tadsapi ohuattidsa iboqquiri najarideni ohuadsa ajama quinahitohui: “Ohua Medsede, ticca ima huapimapi ohohuacomeraridsa nadija. Tia oni hua onadsa naqui madija bodidenicca tocorimedeni dosse dosse ohoninebaqqui nadija. Tia oni hua onadsa naqui qqui toquinapo-jarajaricca ocanahatori canani huapi tadija” quinahitohui. Naraha najaridenipa Diocca cacahuehehuaji jai tojedsima-jarahitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jehe, nidsa dsotode najarideni motadsa ohuattipi: Tiadenidsa onocco jidsa tani. Occa madija tiquejena-jerani. Dio Attidsa iboqquiri tiquinadsapi Pohua tohuini nahicca tinanamana-jerajaro. ¡Aji ohuadsapi huajiji tinaji! onanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Madija ohuatti mittamanadsa ohuattissa inanamanajaropi pina aja madija pocca odsa nahatode nahato tajarissa quinajari. Madijapa pocca odsa icanahatodsapi nami ccara tanihuaji bacco tadsana huehuema ppa idsajaro. Nadsapi odsa daco cajirajaro. ");
INSERT INTO cul_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nadsapi passo cca, hueni cappanima, passo toqquemoja, jojode jadsirema jo jo nadsapi odsadsa ssonari ssonari naraha toquehedima-jerajaro. Odsa toquehedima-jerajaropi huehuema nami ccara tanihuaji bacco teje najaro. ");
INSERT INTO cul_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Naraha madija ohuatti mittamanaraha ohuattissa inanamana-jerajaropi pina aja madija pocca odsa nahatode ssamo tajarissa quinajari. Najari madijapa pocca odsa icanahatodsapi nami ccara tanihuaji bacco tejeradsapi huehuema ssiqui daco nanidsara ppa idsajaro. ");
INSERT INTO cul_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nadsapi passo cca, hueni cappanima, passo toqquemoja, jojode jadsirema jo jo neje nadsapi odsa toquehedimajaro. Odsa toquehedimadsapi catirorijarossa najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nadsama Jeso iadsa huati huati taha jicadsapa nahidsa madija huapima taharibobo canajari bodidenipa: —A, pocca marinaja bica taha −quinade. ");
INSERT INTO cul_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jeso pocca marinaja mari icanabaqquidsapa pohuana nahatojide rajari, atti caji tajaria. Aja jodiodenicca marinaja maridedeni attissa najarajari. ");
INSERT INTO cul_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jeso ssonohuaji madija mari icanabaqquia jicadsa qquedsippanidsapa madija huapi taha Jeso natti jahidsippanijari. ");
INSERT INTO cul_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huapima jahidsippaninaja madija dsamacoma onini leprajine huapi jadsimarohi Jesohuaji bacco najonajari. Pohua bodipa: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta nadsa huati tajari: —Ohua Medsede, ohuapi bica onejeraraha tia jipa tinadsapi ohua tinanabicanijine nahato tinani −nahi nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nadsapa Jeso pohua dsepedsa bara inadsa: —Jehe, jipa onani. Tibicaji, onajaro −nahi nade Jeso. Nanaja amadsati pohua huapicca tomossissi nadsapa tobicajari. ");
INSERT INTO cul_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nadsapa pohuadsa Jeso attipa: —Aji tibicanicca ima madijadenidsa huati taridsa tejerana −najari. —Naraha Diodsa dada toqquimahuajina ticcaji, onajaro. Nanidsa tiqquedsimadsapi dada toqquimade ojariadsara tepi tobicani tia nohue tinaji. Nadsapi ticca dsamacoma Diodsa oppina tanicca tomossidsapi ticca daniji Diodsa tojanijine ohuaha ohuaha naha pina edede, ppiriri, oqui najari da da tidsimana. Pina Moisesicca marinajadsa iboraqquiri inajarossa tinanaji, onajaro. Nadsapi huapimadsa ticca ima toppinerani ahuato tadsapi: “Pajissa tibicajaro” quinahijine, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nahi dsotode Jesopa odsa panani Capernaohuaji bacco tanidsapa romanodenicca soldado dossede Jesodsa ccajonajari. Aja ccajonajaripa pocca dodosse tabaqqui 100 quinajari. Pohua bodipa: —Jeso ohua acco camahijine −nadsa Jesodsa huati tajari. ");
INSERT INTO cul_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Ohua Medsede, occa medsepa occa odsahuaji coma taha porijari. Comene dacoradsa ssomi tojamarodsa poripaja −najari. ");
INSERT INTO cul_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nadsapa Jeso: —Jehe, onanomihijine nani occana −najari. ");
INSERT INTO cul_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Naraha soldado dossede attipa: —Jehe ohua Medsede, tiapi nahatojide tijirani naraha ohuapi ajimani, ssamo onani. Occa odsahuaji ticcanijine jipera tinanitide, onajaro. Naraha ajidsa huati tinadsapi nani occa odsahuajiccaraha, occa medse tettidsa tinanomihijine tipajirani nahato onani −najari nade. ");
INSERT INTO cul_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Aji ohua naqui occa taminecca dossenijidsa omadijaro. Manaco soldadodenipa occa dossenijidsa madimanajari. Pohuadenitohui huahua onadsapi jahijona tahi. Dosse dosse onadsa naco ohuattidsa jai toja tahi. Occa medsedsa naqui: “Tidsepe ijiji” onadsa naqui pina aji odossejarossa inana tani. Nema nadsapi ajidsa huati tinadsa occa medse tonomihijine tipajirani, onajaro −nahi nade soldadodeni dossede atti. ");
INSERT INTO cul_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Najaro ima Jeso mittadsapa huatidsedsa pohua bodi: —A, pohuapa nahato taha −najari. Nadsapa pohua nattihuaji jahimissajaridenidsa huati tajari: —Ohuapi pajissara tiadenidsa huati onana: ¡Ajajari bodi namanahapa pajissa nahissa tajari! Tiadeni Isaraeri potemahideni huapimapi tettideni ohomitta naraha ajajarissa najari tiadenidsapa nohuerahi. Pajissa tiquinanissa tani ohomitta nejerani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—Naraha ohuattipi tiadenidsa: Jehe, dsama nemanehedsa madiridsamanajarideni motapa Isaraerideni quejena-jararaha ohuadsa pajissa quinajaridenipa nidsa Diocca ejete jipaqquie imeni tojadsapi nahidsapa huapima jipaqquimanahijine jahijonahitohui. Ticcadeni idideni Abarahao, Isahaca, Jacobo najarideni tedseje pohuadeni naco nani memehuaji Dio pocca cacahuehehuaji pohuadeni naco jipaqquimanahitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Diopa pocca cacahuehe memehuajicca Abarahao potemahi Isaraeridenidsa tojanijine inanajoraporaha ohuadsa pajissa quina-jaradsapa Dio amossinihuaji hua ininebaqquihitohui. Dsidsinidsa toquejenadsa ocasserani ahuamana-dsanapodsapa panodeni todsahi nadsa oji oji quinahitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nadsama romanodenicca soldado dossededsa Jesopa: —¡Jehe, epejena! Tiapi tibodi pajissa tanissa tadsapi ticca odsahuaji ticcanina. Nani bacco tinanidsapi tibodi tohuini tanicca tiadsa onanani qqui tinanitohui −nahi nade Jeso. Nanaja huati huati toquinaraha soldado dossede pocca odsahuaji pocca medse amadsati tonomijari quinade. ");
INSERT INTO cul_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jeso Pedrocca odsahuaji toqquedsimadsapa Pedro massodini pori canani Jeso qqui tajari. Coma tajaro, huapini ppocorajaro. ");
INSERT INTO cul_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nadsapa Jeso poni dsapanidsa bara nadsapa huapini tonahuihui najaro. Nadsapi totehemadsa Jeso pocca mamari tabaqquima inajipabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jehe, dsomeme nadsapi madija bodidenidsa Satanacca dodosse tocorime cajimanajarideni Jesohuaji eccajonabaqquijari. Najaridenipa huapi taraha Jeso pohua attidsara tocorime dosse ininebaqquidsapa jahininejari nade. Comaqquiri najarideni naco huapima inanomiridsajari nade. ");
INSERT INTO cul_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aji Jesojine nema najaropi pina tahide Dio Atti cacomerabote Isahia itedsejemacca ima ecomerapojarossa inanajaro. Najaroa aji: —Pohuana icca comani onihi onihi naridsajaro idiridsajaro. Icca dsamacoma naqui idiridsadsa pohuadsa tojadsapi inajicanitohui −napohui nade Isahia. ");
INSERT INTO cul_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nadsapa Jeso madija pohuadsa queriqquijonahi tohuapihi nahi qqui tadsapa pohua huatimadedenidsa: —Jina, coridsa jippehuaji jaijana −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nadsapa jai tojabote naraha jodiodenicca marinaja maride Jesohuaji ccajonadsapa: —Nija ohua Maride −najari. —Aji ticcaridsadsama ohua naqui tiadsa occana, onajaro −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Naraha Jesopa pohuadsa huati tajari: —Ohuadsa ticcaridsanijine tipajira-jeranitide. Ajana dsohuadsohuapa odinedeni cajiridsamanahi. Ppiriri naco tadsarideni cajiridsamanahi. Aji ohua Madija Bedipi odsa ocappirani. Ohuadanijinecca huahuada ocappirani −nade. ");
INSERT INTO cul_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nadsapa Jesocca mamari ojariapa Jesodsa huati tajari: —Ohua Medsede, occa abi huatiahi ppa odsahijine tahide occa odsahuaji occanipoccana. Nidsa dsotodena tiadsa occaridsanijine ¿jehe taqui? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Naraha Jeso pohuadsa huati tajari: —¡Poni! Jidapana ohuadsa ticcaji −najari. —Aja madijapa Diocca camittehe cappiramanajarideni caji tahi. Pohuadenina madija dsoqquedsa ppa idsamanahijine pajiramanahi −nahi nade Jeso pocca mamaridsa. ");
INSERT INTO cul_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nadsapa Jeso canoadsa toqquedsadsa pocca mamari tabaqqui naco pohuadsa jai tojedsadsa pohuadsa jai tojajari. ");
INSERT INTO cul_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nadsapa ori toquinaraha amadsati jojode dacorehema ccajona, passo dacorehema ccajona nadsapi coridsa ssoda ssoda najarojine canoadsa passo ssonidsa ssonidsa najaro. Naraha Jesopa huadaja dsanapojari. ");
INSERT INTO cul_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nadsapa Jeso huadahihuaji jai tojeppidsa Jeso cobo cobo quinadsa: —¡Ia Medsede, nocco tijaji! ¡Ia acco ticamabaqquiji! ¡Je icanabote nani! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Nadsapa Jeso pohuadenidsa huati tajari: —¿Nejecotohui ticappinamanajaro? Tiadenipi ohuadsa: “Jehe, Jesopa ia tohuacahua-baqquihijine pajirahi” ¿tiquinejerajarorane? −nahi nade. Nadsapa totehemadsa jojodedsa, passodsa huati tajari: —¡Epeje taji! −nahi nade. Nadsapi jojode, passo ssoda ssoda najaro naqui joma najaro. Joma nadsapi passo podsippanissa tajaro. ");
INSERT INTO cul_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nadsapa pocca mamari tabaqqui huapima: —A ¿nejeco madija? Ajina, jojode passo ssodadani tadsajani pohua attidsa ibora taha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nadsapa coridsa jippehuaji bacco tajari Jeso. Najaro dsama arobeni oninipi Cadara. Nahihuaji madija pamahapa tonoccobirihuaji mamadimana najari. Najarideni madija bodidenidsapa Satanacca dodosse tabaqqui tocorimedeni madidsamanajarijine huadidi tajari. Nadsapa nahi Cadarahuajicca madija huapimapa tocorime cajimanajarideni noppine cacappinamana nadsa tonoccobirihuajicca jahui jajahi toja najarajari. Naraha Jeso toqquemoradsapa pohuadeni pamaha tonoccobirihuaji huedajonajari, Jesodsa bacco quinajari. ");
INSERT INTO cul_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nadsapa Jeso qqui toquinadsapa jadsirema huati huati toquinajari: —Dio Bedi ¿nejecotohuira ticcajonajaro? ¿Ia najidsode ticcajonajaroqui? Dio ia tonajidso-baqquihijinecca huada bacco tejeraccaraha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Naraha nahi huajira tanidsa poroco huapi taha jiparidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nadsapa Jesodsa tocorime attidenia: —¡Jaho! Ia dosse tininebaqquidsapi poroco bodidenidsara ia dosse tidsimabaqquiji −quinahi nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nadsapa Jeso: —¡Jehe, porocodsa tiquejenana! −nahi nade. Nadsapa madija bodidenicca tocorime jahininedsapa porocodsana jai tojedsimaridsajari. Nanaja poroco huapimapa coridsa inidi sseberanihuaji domo toqquedsippadsa diri-ri-ri todsippadsapa cojo-jo-jo quinajari. Tocatojedsippajari. Je tocaniredsapa coridsadsa cacotedsanajari. ");
INSERT INTO cul_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nadsapa poroco cacahuadedeni qqui toquinadsa odsa pananihuaji domo toccanijari. Bacco tanimanadsapa ima huapima huati naridsamanajari: —¡Tonoccobirihuaji madimanajarideni bodidenicca tocorimedeni Jesojine jahininepaja! −naridsamanahi nade. ");
INSERT INTO cul_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Nadsapa nani odsa pananicca madija huapima Jeso qquide jahijonajari. Bacco najonamanadsapa poccadeni dsamadsa Jeso toccanihijine dossede dissassera tajari: —¡Ticcaniji, aji icca dsamadsapi timadi tejeraji! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nadsapa canoadsa jai tojedsanidsapa coridsa jippehuaji pohuadeni ori najonamanapohuihuaji ori tanimanadsa huana tocananimana-pomajari. Jeso pohua mamadi nahi Capernaohuaji bacco tanimanajari nade. ");
INSERT INTO cul_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Naraha nahihuajipa madija ide tone biqueradsa isso ssomi tojahi pohua taborodsa poridsa Jesodsa eccajonamanajari. Jeso pohuatohui disseraqquiri nahi qqui tadsapa pohua bodidsa nahato tajari: —Pajissa, Jesopa madija inanomihijine nahato tahi −quinahi Jeso pohuadsa ahuato tadsapi coma tajaridsa huati tajari: —Otesse, ¡ticappina-jeraji! Aji imasiri tinanajaro huapimapi onanamossini. Jidapapi ticca ima Diodsa tobicani −najari nade. ");
INSERT INTO cul_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jeso atti nama nadsapa jodiodenicca marinaja maridedeni mota mittamanadsapa pohuadenira ssejeje cosseri najari: —Apaja, Jesopa: “Imasiri onanamossina” naha. Pohua attipa: “Ohuapi pina Dio ojani” nanaja najarissa naha. ¡Jesocca imapi bica tejerani, pina Dio itamassojarissa nahi! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Naraha Jesopa pohuadeni bodidenicca ima nahato tadsapa pohuadenidsa huati tajari: —¿Nejecotohui ohuadsa ima tabaccora taniccara tibodideni huatomanajaro? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—Naraha ¿nejecoma najaro imana tiadenidsa denima najora tani? Aja madija coma tajaricca imasiri onanamossini ¿najora taqui? Coma tajari onanabicahina ¿denima najora tajarorane? ");
INSERT INTO cul_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Naraha ohua Madija Bedi ojajaropi madijacca imasiri onanamossinijine Diocca dacorehe ocajini nahatoqquiri tiquinanijinepi, aji namidsa naqui ohuatti ocajini nahatoqquiri tiquinanijine coma tajaridsa huati onana −najari. Nadsapa madija ssomi tojahidsa pohua attipa: —¡Titehemaji! ¡Titaboro tididsa ticca odsahuaji ticcaniji! −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nadsapa totehemadsa pocca odsahuaji toccanijari nade. ");
INSERT INTO cul_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nadsama madija ssomi tojahi tonomihi madija huapima qqui toquinadsapa cappinamanaraha huatidsemanadsa: —A ¡Diopa bica tahi, bica tahi! −quinajari. —Dio pocca dacorehe madija namihuaji madijaridsa inanani qqui inani −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nadsama Jeso jahui ccajonadsa ohua qqui tajari. Ohuapi Mateo. Ohuapi romanodenicca taminecca dosseniji dsiniro nanaccade ojajarode. Nahi romanodenidsa dsiniro da tanijine ihinaccamana nanihuajicca odsa bedeni bodidsa ohuittidsaraha Jeso ohuadsa huati tajari: —Jina, ohuadsa ticcaji −nade. Nadsapi otehemadsa pohuadsa occajarode. ");
INSERT INTO cul_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Nahi dsotode occa odsahuaji ijipanijine huahuanaridsa jassi inahuajanidsapi nahidsa Jeso qquide jahidsimajari. Otessedeni romanodenicca taminecca dosseniji dsiniro nanaccadedeni huapima naco jahidsimajari. Jodiodenicca marinaja ecahuamana-jerajarodeni naco iadsama jassi nahuajanijari. Jeso pohua huatimadedeni ia naqui pohuadeni tedseje jipade iquejenajaro. ");
INSERT INTO cul_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Naraha jodiodeni mota marinaja pariseodsa jehe quinajaridenipa madija bicaqquiri najarajarideni tedseje ijipani qqui toquinajari. Najaro imadsa jiperaqquiri nadsapa iadsa huati toquinajaride: —A ¿nejecotohui tiadeni maridepa romanodenicca taminecca dosseniji dsiniro nanaccadedeni tedseje, imasiri cajimanajarideni tedseje jipajari? −quinade. (Aja madija nama najarideni tedsejepa jipade oppina tani quiquinanajari, pariseodeni, jodiodenicca marinaja maridedeni tedseje.) ");
INSERT INTO cul_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Naraha pohuadeni attideni mittadsa manaco Jeso huati tajari: —Nomiqquiri najaridenipa toponi totonanomide tohuini quina-jararaha comaqquiri najaridenina toponi totonanomide tohuini quiquinanajari −nade. —Ohuapi pina toponi totonanomidessa onajaro. Madijadenicca ima Diodsa tobicanijine pohuadeni accode occajonajarode. ");
INSERT INTO cul_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Naraha madijapa: “Iapi bicaqquiri inani” quiquinanajaridenicca ima onanabicanijine occajona-jerajaro. Imasiri totonanadedenicca ima onanabicanijinena occajonajaro. Jari, ajijaro ima ticahatteraji. Maittaccadsama Dio Atti cacomerabote Osea dsodo inajaro: “Tohuati huanehe, acco camehe tohuini onani. Moisesicca marinajassa tinanamanadsapi ohuadsa ticcadeni bani bedi ono tojahijine da da titiquina naraha madija ohuahadsa tetideni huaneraqquiri nadsapi ticcadeni daniji jipera onani. Madija huapimadsa tetideni huanaqquiri nanijinena jipa onani. Pohuadeni acco ticamabaqquimanadsa naco jipa onani” napohui nade Dio −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nadsapa Huano Baotistacca mamari tabaqqui Jesohuaji bacco najonamanadsapa pohuadsa huati toquinajari: —Nija. Iapi Diodsara huati huati idsanaponijine jipehe ihinebocossa nani. Jodiodeni marinaja pariseodsa jehe quinajarideni naco jipehe nenebocossamana naraha ¿nejecotohui ticca mamari tabaqqui tedsejedeni jipehe titinebocossamana nejerajaro? −quinade. ");
INSERT INTO cul_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nadsapa Jeso pohuadenidsa huati tajari: —Dsabissopa amoneje cajibote najari pocca ejete tojadsapi ¿pohuadsa queriqquimanajarideni huatidsemanera taco? Huatidsemana tahi. Dsabisso cajibote najari tedseje huatidsemanadsapa jipehe nebocossamana-jarajari. Naraha nidsa huada onihiccadsa madija ohuahadeni dsabisso cajibote najari inanadsoqque-manahijine pohua iaccamanadsapa pohua tessedenipa jipehe nebocossamanahitohui −nade Jeso. (Aja pohua atti nama najaripa pohuapa pina dsabisso cajibote najari. Jeso pohuadenidsa madiccadsapa pohua huatimadedeni jipehe nenebocossamana najaraccajari, najari.) ");
INSERT INTO cul_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Ima onihi naqui ajima najaro: Etero ssessequidedenipi etero jadanidsapi etero dsati ihibedsacossamana nejerajaro. Etero dsatipi etero jadanidsa podsacossadsa dsotode ssabo nadsapi joca naqqui tani. Nadsa etero jadani sseo tapomadsapi denima totabaccora tani −nade Jeso. (Aja pohua atti nama najaripa pocca marinaja pina jodiodenicca marinajassa nejerani. Jeso pocca marinajapi dsati.) ");
INSERT INTO cul_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—Ima onihi naqui ajima najaro: Uva ppejene nahatodsatipa bani etero ssequi nahi jadahidsa sso sso ihidsamana najarajari. Uva ppejene nahatodsatipa bani etero jadahidsa sso todsadsa ssicatadsapa jocaquera tajarijine sseo tahi caji tahi. Sseo tadsapa uva ppejene sso taha jica tahi, dsamine naco totabaccoradsapa coro quina tahi. Naraha uva ppejene dsatipa bani etero ssequi nahi dsatidsara sso sso totodsa nadsana uva ppejenepa ecahuahissa tajari. Aja dsamine naco totabaccora-jarajari −nade Jeso. (Aja pohua atti nama najaripa madija bodi dsati tojadsana Jesocca marinaja dsati ecahuanijine pajirahi, najari.) ");
INSERT INTO cul_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesopa pohuadeni atti ecomera-dsanapodsapi jodiodenicca Dio Atti mamarihuajicca tamine Jesodsa huati tahijine ccajonajari. Jesohuaji bacco najonadsapa pohua bodi: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta tocattedsa najari. Nadsapa Jesodsa huati tajari: —Occa ejedeni huatiapaja. Occa odsahuaji ticcadsa tidsepedsa poni bara tadsa tijine camittemanidsa madipomanijine −najari. ");
INSERT INTO cul_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nadsapa Jeso pocca mamari tabaqqui tedseje pohua natti jai tojamissajari. ");
INSERT INTO cul_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Naraha jahuidsa amoneje coma tajaro Jeso toccahi qqui tajaro. Ponipi dsamacoma onini amaissoranaja cajijaro. Poni coma tanicca huajanopa 12 naraha ama jicaquera tanicca tonahanajonajaro. Nadsapi Jeso qqui tadsa poni bodinipi: —Jehe, pocca eterora bara onadsapi onominitohui −najaro. Nadsama Jeso nattihuaji toccamissadsa tohuajiressissi nadsa pocca etero iponi bara inajaro. ");
INSERT INTO cul_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nadsapa Jeso piti nahuajanidsa qqui taneje amoneje coma tajaro qqui tajari. Qqui tadsapa: —Asi, ticappina tejeraji. Tibodipi ohuadsa: “Jehe, Jeso ohua tonanomihijine pajirahi” tadsapi najarojine jidapapi ticca dsamacoma toccapa −najari Jeso. Nadsapi amadsati amani totappadsapi tonomijaro. ");
INSERT INTO cul_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nadsapa denima tossoniqquimamana dsanapodsapa jodiodenicca Dio Atti mamarihuajicca tamine tadsarihuaji Jeso bacco tajari. Bacco tadsapa madija toqueriqquihi qqui tajari. Ejedeni ppa todsanijine najoramanadsa totorededeni tore tore quinajari, madija motapa jadsirema oji oji camajari, motapa johua johua camajari. ");
INSERT INTO cul_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Naraha Jeso attipa: —¡Jari, huapima ajijaro odsacca jai tijenaji! Ejedenipi dsoqque-jerani. Huadajaro −najari. Naraha pohuadenipa Jeso atti jaja icanamanajari. ");
INSERT INTO cul_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Naraha pohuapa madija dosse ininebaqquidsa Jeso toqquedsimajari. Toqquedsimadsa ejedeni poni dsapani equidi nadsa totehemajaro. ");
INSERT INTO cul_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nadsapa najaro dsama arobenihuaji madimanajarideni huapima mittaridsamanajari. Ejedeni camittemaninicca ima tojaribaqquiridsajarode. ");
INSERT INTO cul_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesopa ejedenicca odsadsa qquenadsapa toccanijari. Toccani toccani nanaja nocco siri pamaha Jeso natti tohuedamissajari. Tohuedamissadsa huahua tamissamanajari: —¡Dabi Potemahi! ¡Iadsa teti huana taji inaha! −tamissamanajari. ");
INSERT INTO cul_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nadsapa Jeso odsa bacco tadsapa toqquedsimajari. Naraha nocco siri pamaha huedajonajaripa Jesodsa tohuajiressimanadsa Jeso pohuadenidsa huati tajari: —Jari, ohuadsa tibodidenipi ¿nejecoma tiquinani? “Ia tonanomibaqquihijine pajirajari” ¿tiquinajaroqui? −nade. Nadsapa: —Jehe ia Medsede, ia tinanomibaqquinijine nahato tinani, inajaro −quinade. ");
INSERT INTO cul_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nadsapa nocco siri pamaha nocco bara inabaqquidsa Jesopa: —Jehe, ohuadsa pajissa tiquinadsapi tinoccodeni ssire tanitohui −nade. ");
INSERT INTO cul_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jeso atti nama nadsapa nocco siri pamaha noccodeni ssire tocanirejari. Nadsapa Jeso pohuadenidsa huati tajari: —¡Paji, ajijaro imapi madijadenidsa tecomamanaji! −nade. ");
INSERT INTO cul_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Naraha tohuedanidsapa pohuadeni cacomamana-jarajari. Poccadeni ima ecomeraridsa-manajaro. Najaro dsama arobenihuaji madimanajarideni huapima —Jeso nocco siri pamaha inanomibaqquijari −ima mittaridsamanajari nade. ");
INSERT INTO cul_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nocco siri pamaha tocanomiredsa tohuedaniraha manaco ebeno siri eccajonamanajari. Pohua bodidsapa Satanacca dodosse tocorime madidsajarijine atti cappirajari. ");
INSERT INTO cul_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Naraha Jeso pohua bodicca dosse ininedsapa ebeno biquemanidsapa atti cajipomajari. Nadsapa madija huapima qqui toquinadsapa: —A, bica tahi. ¡Jesopa nahato tahi! −quinajari. Attideni naco: —Aji ia Isaraeri potemahi icca dsamadsa nama nahi qqui qqui inapo-jaraccade −quinade. ");
INSERT INTO cul_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Naraha jodiodeni mota marinaja pariseodsa jehe quinajarideni attidenia: —Ajana, Jesopa tocorimedenicca tamine Satanacca dacorehe cajijarijinea pocca dodosse tabaqqui dosse ininebaqquijaripaja −quinaraha maidsamanajaride. ");
INSERT INTO cul_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nadsama Jesopa odsa panani onihi, onihi naridsajarodsa, odsa capamema najaro onihi, onihi naridsajarodsa bacco bacco nanaridsa nadsapa poccadeni Dio Atti mamarihuaji mari mari nanaridsa najari. Jesopa Diocca cacahuehecca ima bicani mari mari nanaridsa najari. Comani onihi, onihi cajiridsamanajarideni naco ihinanomi-baqquiridsa najari. ");
INSERT INTO cul_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jeso madija pohuatohui jahijonana canahi qqui inabaqquidsapa pohuadenipa pina edede pohuadeni cacahuade jiraha pohuama mamadiri naridsamanajarissa quinajari. Nama quinadsapa Jeso pohua bodidsa: —A, tohuati nahanaqquiri nahi −nadsa pohuadenitohui huati cahanariri canaridsajari. Madija huapimapa pohuadeni acco camade, pohuadeni maride cappiramanadsapa pina edede pohuadeni cacahuade nohueradsa nanajidso toquejenajarissa quina tahi. ");
INSERT INTO cul_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nadsapa Jeso pocca mamari tabaqquidsa huati tajari: —Madija Dio jiraha madimanahi huapi taraha pohuadeni maridea huapi tajarahi. Pina huidsajacca ppa nahi bono jica-jarajarissa quinaraha poredea madija pama quinajari. ");
INSERT INTO cul_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nadsapi huidsaja jinede Diodsa huati tiquinaji, Pohua Atti maride dosse inabaqquidsa bono porede tohuapihijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nadsapa Jeso itohui pocca dodosse tabaqqui 12 inajaro, itohui huahua nadsapa iadsa pocca nahatohue inanaridsajarode. Nadsapi ia naqui madija bodidenicca tocorime dosse inineridsa-baqquihijine ia tonapajira-baqquihissa tajari. Nadsapa iadsa pocca nahatohue inanaridsadsa naqui comaqquiri najarideni naco comani onihi, onihi cajiridsamanaraha ihinanomi-ridsabaqqui nahijine ia tonapajira-baqquijaride. ");
INSERT INTO cul_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nadsama ia pocca dodosse tabaqqui iquejenajaropi ia oni huapimapi ajima inajaro: Tahidepa Ssino, oni ohuaha naqui Pedro. Pedro pohua ohuaha onipa Adiri. Madija ohuaha onipa Satiaco. Pohua ohuahapa Huano. Pohuadeni pamahapa Sebedeo bedi. ");
INSERT INTO cul_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Madija ohuahadeni naco Feripe, Batorome, Tomas, quinajari. Ohuapi Mateo romanodenicca taminecca dosseniji dsiniro nanaccade ojajarode. Madija ohuahapa Satiaco. Satiacopa Arapeo bedi. Ohuaha naco Tadeo (pohua oni ohuahapa Joda). ");
INSERT INTO cul_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Madija ohuaha naco Ssino, pohuadsa romanodeni momohuade quiquinanajari. Madija ohuahapa Joda Iscariote. Najaripa Jeso ccaccorade. Nadsapi 12 inajaro Jesodsa iquejenajarode. ");
INSERT INTO cul_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesopa pocca dodosse tabaqqui 12 inajaropi pohua tahimari mari icanaridsabaqquihijine ia dosse tabaqquijari. Ia dosse tabaqqui-jaraccadsama ia mari tocanabaqquijaride. Pohua attipa: —Jehe, tiadenipi otahimari madija mari ticanabaqquiridsahijine jai tijadsapi jodio quejena-jarajaridenidsapi jai tija-jeraji. Dsama Samariacca odsa pananihuaji naqui jai tijedsima tejeraji. ");
INSERT INTO cul_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Naraha Isaraeri potemahi jodiodenihuajina jai tijani bica tani. Najaridenipa pina edede jano toquejenajarissa quinajari. Jehe, najaridenidsana jajahi tijaridsa naji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Najaridenidsara jai tijaridsadsa otahimari tecomeraridsamananissa taji. “Diocca cacahuehepi iadsa bacco najonabote nani” taridsamanana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Comaqquiri najarideni Diocca dacorehema titinanomi-baqquimana nana. Madija dsoqquemanajarideni naco Diocca dacorehema pohuadeni titinahatonimana nana. Madija dsamacoma onini leprajine jadsimanajarideni naco Diocca dacorehema huapidenicca titinanomi-baqquimana nana. Madija bodidenidsa Satanacca dodosse tabaqqui tocorime madidsamanajarideni naco bodidenicca dosse dosse titininebaqquimana najo, onajaro. Jehe, tiadenidsapi manaconi jirehe Dio pocca dacorehe tiadenidsa inanajaro. Tiadeni naqui najarideni tobiquemani-manadsapa manaconitohui huati tiquinejeraji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","—Ticcadeni benehidsa naqui dsiniro tiaccamana tejeraji. Oro poni, plata poni, ccarara onihi naqui poni. ");
INSERT INTO cul_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Benehicca saco naqui tiaccamana tejeraji, poni. Ticcadeni etero onihi tedsamananijinecca naqui poni. Temoridenicca ohuahapa tiaccamana tajarajo. Aja tedsamanajarira tiaccamanahi ojari najo. Tiadeni totocahuejidsa ahua naqui tiaccamana tejeraji, poni. Nadsama otahimari maridera tidsepedeni ihijiridsamana nadsapi ticcadeni mamari tabaqquina ticcadeni madiejine tiadenidsa da da nanaridsamana nahi bica tahi −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Nadsama odsa panani onihihuaji, odsa capamema najaro onihihuaji naqui bacco tiquinadsapi nahicca madija bica tajari, tiadenidsa jipa tajari tohuira qqui taridsamanana. Madija bica tajari bacco tiquinadsapa najaricca odsadsara timadimanani bica tani. Odsa panani onihihuaji jai tija-jeraccadsama aji bacco tiquinapojarocca odsadsara timadimanana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jehe, nadsama najaro odsadsa madimanajaridenidsa jai tijedsimadsapi pohuadenidsa: “¿Nija, bicaqquiri tiquinaqui? Diocca jonehe tiadenidsa tojana” tiquinana. ");
INSERT INTO cul_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nadsama ticcadeni marinaja mittamanadsa, tiadenidsa bicaqquiri nadsapa Diocca jonehe pohuadenidsa tojanitohui. Naraha tiadenidsa, ticcadeni marinajadsa naco jiperaqquiri nadsapa Diocca jonehe pohuadenidsa toja-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nadsapa tiadenidsa jiperaqquiri nadsa: “Ajidsa timadimanaji” quina-jaradsapa, aja ticcadeni marinaja mittade jiperaqquiri nadsa naco najaro odsadsa jai tijeqquimani bica tani. Madija nama quinahicca odsa tinebomanadsapi temoridenicca sadariadsa ssiqui ma tajaro catojanijine pporo pporo tiquinana. Nahi poccadeni ibohue bodideni huatoma-manahijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","—Jehe, pajissara tiadenidsa huati onana: Nidsaranibote madija huapimacca ima Dio icattemanijinecca huada bacco tadsa Dio pocca najidsohue tojadsapi najaridenidsapa denima oppina tanitohui. Ajina maittaccadsama odsa panani Sodomacca madija, odsa panani onihi Comoracca madija, nahihuaji madija madiridsamanajarideni naco tabaccoraqquiri nadsapa Diojine jicaridsapojaripaja. Naraha pohuadenipa nidsa dsama jicadsapi poccadeni imasiri manaconipa najidsohue oppina tajaro pohuadenidsa ssonarinitohui. Naraha ohuattidsa jiperaqquiri najaridenidsana najidsohue denima oppina tanicca ssonarinitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Jehe ¡tibodideni huatoma-manaji! Ohua tiadeni dosse onabaqquijaropi pina edede dsomaji panahihuaji tiadeni dosse onabaqquijarossa najaro. Jai tijaridsanihuajipi madija tiadenidsa huadiqquiri nahi caji tahi. Nema nadsapi tinoccodeni panaji. Pina macca nocco panajarissa tiquinaji. Naraha tiadenipi tedimana tejerana, pina midsori jone tajarossa tiquinaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","¡Paji, tinoccodeni panaji! Madija huadiqquiri najari aniridsahi. Najaridenipa tiadeni tadamamanadsapa jodiodenicca taminedenihuaji tiadeni tohuaqquedsimabaqqui-manahitohui. Jodiodenicca Dio Atti mamarihuaji naqui tiadeni tacossimanahitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Otahimari tiadenidsa tojajaro acconi huadimanadsa dsama cacahuadedenihuaji tiadeni tohuaqquedsimabaqqui-manahitohui. Dsama onihicca dsama onihicca madija tamine deni toquejenajarihuaji naco tiadeni tohuaqquedsimabaqqui-manahitohui. Naraha nema nehe ticcadeni ima tecomeramanadsapi taminedeni, jodio quejena-jarajarideni naco otahimari mittamanahijine. ");
INSERT INTO cul_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nadsama taminedenidsa tiadeni tohuaqquedsimabaqquimanadsapa pohuadenidsa ticcadeni ima tecomeramananijine ¿nejecoma onapadseje? tiquinejerana. Ticappinamana tejerana, onajaro. Nahidsa taminedenidsa tecomeramananijine Dio Pohua Corimena tettideni acco tocamabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Huati tiquinadsapi tettideniraha ticcadeni Abi Dio Pohua Corimejinena huati tiquinajaro, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Naraha najidsohuepi tiadenidsaha ssonarini ojari nejeranitohui. Aja ohuadsa jehe quinajaridenipa otahimaridsa toquejenajarijine pohua ohuahadeniraha pohuadenidsa huadiqquiri nadsapa eheccora-baqquimana nahitohui, inajicabaqqui-manahijine. Imehideni naco pohua bedideni otahimaridsa toquejenajarijine bedidenidsa huadiqquiri nadsapa pohuadeni bedideni eheccora-baqquimana nahitohui, inajicabaqqui-manahijine. Bedideni naco imehideni otahimaridsa toquejenajarijine pohuadeni imehidenidsa huadiqquiri nadsapa imehideni ihinajica-baqquimana nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Occa madija tiquejenadsapi madija huapima tiadenidsa jiperaqquiri nahitohui. ¡Naraha tiadenipi dacoco tijiraji! Najaro huadie tinahanamana-dsanapodsapi dsama jicani bacco tiquinadsa tiadenina ticassiejeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Naraha tiadenidsa jiperaqquiri najarideni tiadeni tonajidso-baqquimanadsapa ¡huassinaja odsa panani onihihuaji tidomodeni toccana! Tiadeni tonajidso-baqquimanapomadsa naco ¡odsa onihihuaji tidomodeni toccapomana! onajaro. Pajissara tiadenidsa huati onajaropi: Nidsa Isaraeri potemahidenicca odsa panani huapimadsa maride jai tijaridsani jiquejeraraha Madija Bedi ohua ohuatomani-pomanitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Tetideni ajimamana tejerana: Madija pocca mamari tabaqquipa pohuadeni maridedsa deni toquejena-jarahi. Pohuadeni maridena denima nahato tajari. Madijacca dodosse tabaqqui naco pohuadeni dossededsa deni toquejena-jarahi. Naraha pohuadeni dossedena denima nahato tajari. ");
INSERT INTO cul_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Najarossa najaroa aji madija pohua maridedsa ima ssonaridsapi pohuadsa naqui ima ssonari tani. Nadsapa pohua atti: “Epeje, ohua maridedsa nama quinadsapa ohuadsa naqui nama quinana” nahi bica tani. Madija pohua dossededsa ima ssonaridsapi pohuadsa naqui ima ssonari tani. Aji ohuapi ticcadeni tamine ojani ohua itamassomanadsa pina: “Tiapi tocorimedenicca tamine Beheosebo” quinadsapa tiadeni occa madija tiquejenajarodenidsa naco denima tatamasso quinahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Nadsama tiadenidsa jiperaqquiri najarideni noppinedenipi ticappinamana tejerana, onajaro. Ajina, jidapana poccadeni tabaccorehe inajimamanaraha nidsa dsotodena ahuato tanitohui. Ima bicani ahuatora tanidsa inanamana, ima bica tejeranicca naqui ahuatora tanidsa inanamana naraha nidsa dsotodena najaro ima huapima ahuato tanitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aji ohuattipi dsome tiadenidsa huati huati onajaropi nidsa ssiajanidsa tecomeramanaji. Teribodenidsa ojidsa huati huati onajaro naqui nidsa amossinihuajina jadsirema tecomeramanaji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—Nadsama otahimaridsa tiquejenajarojinepi madija tiadeni tonajicabaqquihijine tohuini quinaraha najarideni noppinedenipi ticappinamana tejeraji. Najaridenipa timedeni jicanijine pajiramanaraha nidsa tijicani nattinipi aji jororoni jiquejeranihuaji ticorimedeni hua todsimabaqquihijine ssamoqquiri nahitohui. Diona tiadeni tonajicabaqquihijine pajirahi. Aji jororoni jiquejeranihuaji ticorimedeni hua todsimabaqquihijine naco pajirahi. Nadsama Dio noppinena ticappinamanaji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","30","—Diopa madija huapimacca ima nahato tajari. Aji, titatideni conani huapima onini huade naco nahato tajari. Diopa tiadeni tohuacahua-baqquihitohui. Pohuapa dsama huapimacca cacahuade naco nahato tajari. Ppiriri naco Dio: “Jehe huatia-jarana” nadsapa huatiera tahi. Naraha Dio: “Jehe huatiana” nadsana huatia tahi. Nadsama ppiriri manaconepa ¿huati ccara taco? Huati ccarera tahi. Ppiriri pamaha manaconepa ccarara cajarie da da ihicanamana najaro. ");
INSERT INTO cul_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nema nadsapi ¡ticappinamana tejeraji! onajaro. Ppiriripa ajamani toquejenaraha huapima Dio ecahuabaqquijari. Naraha Diopa tiadenidsana denima huati huana tajari. Tiadeni tohuacahua-baqquihissa tahitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Madija ojariapa madija ohuaha mittamanahijine pohua cacomeradsa: “Ohuapi Jesocca madija ojani” nadsapa manaco ohuapi occa Abi Dio memehuaji madijaridsa ohuacomeranitohui: “Ajajari madijapa occa tojahi” onanitohui. ");
INSERT INTO cul_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Naraha madijapa madija ohuaha mittamanahijine pohua cacomeradsa: “Ohuapi Jesocca madija ojajerani” nadsapa manaco ohuapi occa Abi Dio memehuaji madijaridsa ohuacomeranitohui: “Najaripa occa madija jarahi” onanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Tiadenipi tibodidenidsa: “Jehe, Jesopa ajijaro namidsa jonehe tojaridsanijine ccajonajari” tiquinanitide. Naraha ohuapi madija cajonerara canahijine occajona-jerani. Madija cahadirere canahijinera occajonajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","—Nadsama aji occajonajaropi madija pohuadenira pohuadenira naridsamanahijine. Madija motapa ohuadsa jehe quinajari. Madija motapa ohuadsa jehe quina-jarajari. Nadsama madija ohuadsa jehe najaripa pocca odsadsa madija madimanajarideni ohuadsa jehe quina-jaradsapa pocca huadi toquejenajari. Jehe, occajonajaropi ajima nanitohui: Dsabissopa imehi tedseje cacahadire nahitohui. Bedenipi imeni tadsajani cacahadire nanitohui. Jinomadinipi massodini tadsajani cacahadire nanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Madijapa pocca madijadsa denima huati huana tadsa ohuadsapa ajamani huati huana tadsapa najari madijapa occa toja-jarahitohui. Aja madija pohua imehidsa, pohua imenidsa huati huana taraha ohuadsapa ajamani huati huana tadsapa occa madija toja-jarahitohui. Pohua bedidsa, pohua bedenidsa huati huana taraha ohuadsapa ajamani huati huana tadsapa occa madija toja-jarahi. ");
INSERT INTO cul_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Madija ohuadsa dissera tajaradsapa occa madija tojahijine pajira-jarahi. Occa madija tojahijinepa otahimarijine ocasserani inahanaraha nema nehe otahimaridsara dissera tajari. Pohuadsa: “Ahua porimacossanidsa tia inanadsoqquena” quinadsa naco pohua attipa: “Epejena odsoqquena. Jeso onebo-jarahi” nadsapa najarina occa madija tojajari. ");
INSERT INTO cul_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Madijapa pocca madie ohuadsa eccoradsapi pohua inanadsoqque-manaraha camittehe jiquejeraniccapi cajidsanapohuitohui. Naraha madija ohuaha pocca madie ohuadsa acco tadsa ajijaro namidsa madi-dsanapohuijine tohuinira nadsapa dsoqquehitohui. Dsoqquedsapa camittehe jiquejeranicca caji-jarahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesopa pocca dodosse tabaqquidsa denima huati tajari: —Madijapa pocca odsahuaji jai tijedsimanijine tiadenidsa pohua attipa: “Jehe, Jeso tahimari teccajonamanajaro bica tani. ¡Jai tijedsimaji!” nadsa najari madijapa tiadenidsa bica tadsapa ohuadsa naco bica tajari. Ohuadsa bica tadsapa ohua Cadossede Abi Diodsa naco bica tajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","—Nadsama madijapa Dio Atti cacomerabotedsa pohua attipa: “Pajissa, Diocca dodosse tijani. Dio Atti tecomeradsapi mittade jipa onani” nadsa najari madijadsapa Dio pocca biquehe inananitohui. Pina Dio pocca biquehe Pohua Atti cacomeraqquiri najaridenidsa inanaridsajarossa najaro pohuadsa naqui inananitohui. Nadsama madijapa Diojine madihissa dsanapojaridsa pohua attipa: “Jehe, Diodsa timadinissa dsanapodsapi ohuadsa bica tinani. ¡Occa odsahuaji tiqquedsimaji!” nadsa najari madijadsapa Dio pocca biquehe inananitohui. Pina Dio pocca biquehe madija madimanahissa tajaridenidsa inanaridsajarossa najaro pohuadsa naqui inananitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","—Nadsama madijapa occa mamari ojaria ajamani tojajari tohuati nahana tajaridsa pohua bodipa: “Jehe, ajajaripa Jesocca madija, pohuadsa accora onana” nadsa pohuadsa da inadsa bica tani. Passo nahuini dse nahijine da icanadsa naco manaco nidsaranibote Diopa pocca biquehe najari madijadsa inananitohui. ¡Pajissara huati onajaro! −nade Jeso, pocca dodosse tabaqqui jai tojaridsahijine dosse inabaqquidsa. ");
INSERT INTO cul_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jeso pocca dodosse tabaqqui 12 inajaro pohua tahimari maride iquejenaridsanijine ia mari tocanabaqquia jicadsapa madija huapima mari icanabaqqui-ridsahijine ia huapima jaijajarode. Jeso naco iadsama toccajaride. Najaro dsama arobeni onini Carireahuajicca odsa panani onihi, onihihuaji, odsa capamema najaro onihi, onihi nanihuaji Dio Atti ehecomeraridsa najarode. ");
INSERT INTO cul_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nadsama Huano Baotistapa toponi cocoro todsimadsa huedsaraha madija attideni: —Cristo-Mesiapa canahatori canahi −quinahi ima mittajari. Mittadsapa pocca dodosse tabaqqui Jesodsa huati toquinahijine dosse inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nadsapa iahuaji jahijonadsa bacco najonamanadsapa Jesodsa huati toquinajaride: —Ia maride Huanopa tiadsa huatide ia dosse najonabaqquijari. Pohua attipa: “¿Tiapi aja tohui imadijaro Cristo-Mesia tijaqui? ¿Ohuahatohui imadiccanijinerane?” nade Huano atti −quinade. ");
INSERT INTO cul_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nadsapa Huano dosse inajonabaqquijaridenidsa Jeso pohua cacomerajari: —Jehe, ticadanidsa Huanodsa huati tinanimanaji. Aji qqui tiquinajaro, aji timittamanajaro pohuadsa huati tinanimanana −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—Ajima tiquinana: “Madija nocco sirideni nocco ssire tocanirehi. Madija isso sirideni naco tocanomiredsa jahiridsahi. Madija dsamacoma onini leprajine huapideni jadsimarojarideni naco imedeni tobicaridsahi. Madija huaribodeni didiqquiri najarideni naco huaribodeni ssire tocanireridsahi. Madija huatiajarideni naco camittemani-ridsamanahi, madija tohuati nahanaqquiri najarideni naco icassiejeranijinecca ima mari icanabaqquimanadsa mittaridsamanahi” tinanimanana tiadeni maridedsa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","—Aja madija mota attidenipa: “Jesopa Cristo-Mesia jarahi, pocca imapi onihi, Cristo-Mesiacca imassa nejerani” quinaraha madija mota nama quina-jarajari attidenipa: “Pajissa Jesopa icca Mesia” quinadsa pohuadenidsana Dio pocca biquehe inananitohui. Ajijaro ima huapima Huanodsa huati tinanimanana −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nadsapa Huano dosse inajonabaqquijarideni tohuedanihi natti Jesopa pohuadsa queriqquimanajaridenidsa Huano tahimari huati tajari: —Nadsama dsama huamoni ssono caji, siba caji tanihuajipi ¿nejeco qquidera jajahi tija najarotte? Aja madija pocca ima japari tajaro pina boba jojodejine jene jene tocanajarissa najari ¿nama najari qquide jajahi tija najarottarane? Naraha Huano Baotistapa pocca ima japari tejerade. ");
INSERT INTO cul_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Huamonihuaji jajahi tija nadsapi ¿nejeco qquidera jajahi tija najarotte? Aja madija etero huatini ccara tanicca huedsajari qquide ¿jajahi tija najarottarane? Naraha tiadenipi nahatoqquiri tiquinani: Madija etero huatini ccara tanicca huedsamanajaridenipa taminedenicca odsadsana mamadimana najari. ");
INSERT INTO cul_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Nadsapa ¿nejecotohuira nanihuaji jajahi tija najarotte? ¿Dio Atti cacomerabotecca marinaja mittade jajahi tija najarottaqui? Jehe ¡pajissa! Pocca marinajatohui jajahi tija najaroa. Huanopa pina Dio Atti cacomeraqquiri najaridenissa naraha pohuapa deni tojajari. Pohua dsepe ijijaripa ima deni tojanicca cajijari. Najaro imapi otahimari Cristo-Mesia tiadeni Idinide ojajaropaji. Najaro ima inanajora-ridsapojaropaji. ");
INSERT INTO cul_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aja, Huano Baotistapa maittaccadsama pohua tedsejemacca ima Dio Atti cacomerabote Maraquia dsodo inapojaro. Najaropi pina Diopa Cristo-Mesiadsa huati tapojarissa najaro: “Tahide titahimari tohuaccade madija ojaria titedsejema dosse onapohuitohui. Nahi mittamanadsa madija bodidenipa titohui najoramanapohuijine, pina tijahine najoramanapojarossa inanamananitohui, onajaro” napohui nade Dio Atti −nade Jeso atti. ");
INSERT INTO cul_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Nadsama pajissara tiadenidsa huati onajaro: Aji namidsa madiridsamanajaridenidsa naco madija ohuaha pina Huano Baotistassa najari nohuerahi. Huano Baotista pohuajinena madija bodideni otahimaritohui Diocca cacahuehecca ima dsati inanajorabaqquipojari. Najarojine Huanopa namidsa madiridsamanajarideni huapimadsa deni tojajari. Naraha nidsa dsotode madijapa Diocca cacahuehecca ima dsati tojani qqui toquinadsa najarodsa toquejenadsapa pohuadenipa Huano Baotistadsa deni toquejenahitohui. Madija ajamani tojajari pina tohuati nahana tajari pohua naco Diocca cacahuehedsa tojadsapa pohua naco Huano Baotistadsa deni tojahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","—Jehe, Diocca cacahuehecca ima dsati madijadsa tojanijine Huano Baotistapa tahide mari mari najonapojari. Jidapana ohua naqui maride nema onajonajaroa ajijaropaji. Naraha madijapa Diocca cacahuehecca imadsa jiperaqquiri nadsa pohuadenijine najidsohue ssonari ssonari najonajaropaji. Jicanijine disseraqquiri naraha pajiramana-jarahi. ");
INSERT INTO cul_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maittaccadsama Dio Atti cacomeraqquiri najarideni Moisesicca marinajadsa naco Dio Atti ecomeramaneje najonaponi najaroa aja Huanopaja. Huapima Diocca cacahuehecca ima naqui mari mari nanajonamana najari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","—Nadsama ajijaro ima timittamananijine tipajiramanadsapi: “Jehe, pajissa” tiquinaji. Najaro imapi Huanopa pina Dio Atti cacomerabote nidsa ccajonahitohui quiquinanajaripa Eriassa najari. (Aji Dio Atti dsodo nanidsapi: “Nidsa Ohuatti cacomerabote onipa Eria tiadenidsa dosse onahitohui” napohui nade Dio.) ");
INSERT INTO cul_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","—Naraha jidapanana aja madija madiridsamanajaridenipa ¿pina nejecojaridenissa quinajari? −nade. Nadsapa pocca marinaja mittamanahissa tahijine ajijaro namidsa imadinicca imadsa mari icanabaqquijari. Pohua attipa: —Jehe, madija jidapana madiridsamanajaridenipa pina ejedenideni boronidsa jassi tadsa poccadeni ittome tossamodsa ahuaji johua, ahuaji johua quinajarissa najari, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Pohuadenipa pohuadeni tessedenidsa: “Jaho, dsobi tiquinanijine totoredsa tore tore inaraha tetidsemana-jerani, dsobi dsobi tiquinejerani” quinajari. “Ittomedsa naqui tiadeni oji inanabaqquinijine ajie tohuati nahana taniccadsa jiri jiri inaraha tiadenipi oji tiquinehe nejerani” quinajari. ");
INSERT INTO cul_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jehe, aja madija jidapana madimanajaridenipa pina ejedeni jamimanajarissa quinahi onajaropi Huano Baotista madidsa Dio Atti cacomerade tojadsapa ejetecca jipaqquiecca jijipa jipa-jarahi. Ejetecca dsedse dse najarahi. Nadsa johua johua quinadsa attidenipa: “Huano Baotistacca madie jidsa tani. ¡Pohua bodidsa Satanacca dodosse tocorime madidsajari itidija!” quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nani dsotode ohua Madija Bedi ojajaroa ejetecca jipaqquiecca jijipa ojipa, dsedse dse onadsapa ohuadsa johua johua quinajari attidenipa: “Jaho, madijadsa jipa naridsajide rahi, dsedsejide rahi. Romanodenicca taminecca dosseniji dsiniro nanaccadedenidsa ccaridsajari. Madija imasiri cajimanajari tedseje naco ccaridsajide rahi” quiquinanajari ohuadsa. Attidenipa Huanodsa, ohuadsa nama quinaraha nidsa imasiri cajimanajaridenipa ettidsa iboraqquiri nadsa bodideni cacajiqquimera, imarideni cacajiqquimera nadsapa Diocca nahatohue, pocca pajissehe ahuato tanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesopa odsa panani onihi onihi naridsajarocca madija poccadeni ibohue tahimarini huati tajari. Poccadeni odsa pananihuaji Jeso pohua canahatori canahicca denima inahatoridsaraha bodideni cacajiqquimera-manaha najaradsapa poccadeni imasiridsa apaja quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Pohua attipa: —Jaho, odsa panani Corasinahuaji timadimanajarodenipi najidsohue oppina tanicca tiadenidsa ssonarinitohui. Jaho, odsa panani Besaidahuaji timadimanajarodeni naqui najidsohue oppina tanicca tiadenidsa ssonarinitohui. Ajina, ticcadeni odsa pananihuaji ocanahatori canani qqui qqui tiquinaraha tibodideni cacajiqquimerehe nejerade. Naraha maittaccadsama odsa panani Tirohuaji madimanapojaridenipa tabaccoraqquiri najari, aji odsa panani Sidohuaji madimanapojarideni naco tabaccoraqquiri najari pohuadeni huapimapa ocanahatori canani qqui toquinapo-jarajari. Nassa qqui toquinadsapa Diodsa toquejenahijine najomana-jarahitohuiraha. Poccadeni imasirijine bodideni ocassera tadsapa etero jidsa tanicca huedsamanadsa dsippo oconi pohuadeni tatidsa huira huira quinadsa oji oji quinahitohuiraha −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—Naraha aji Corasinahuaji timadimanajaro tiadenidsa, Besaidahuaji timadimanajaro tiadenidsa naqui ohuattipi: Nidsa madija huapimacca ima cattemanijinecca huada bacco tadsa Dio Pohua baccohuaji tidomodeni huadsapi Tirohuaji madimanajaridenidsa Dio pocca najidsohue ajimani tojanitohui. Sidohuaji madimanajaridenidsa naco ajimani tojanitohui. Naraha tiadenidsana Dio pocca najidsohue denima oppina tanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Jaho, odsa panani Capernaohuaji timadimanajarodeni naqui najidsohue oppina tanicca tiadenidsa ssonarinitohui. Dio memehuaji madijaridsa bacco tiquinadsa tiadenidsa Pohua Attipa: “Jehe, tiadenipi bicaqquiri tiquinani” ¿napadsaja? ¡Nama najarahitohui! Ticcadeni ibohuejinepi nami odini huaji tani jicaqquini nohueranihuaji tiadeni hua todsimahitohui. Ajina, ticcadeni odsa pananihuaji ocanahatori canani qqui qqui tiquinaraha tibodideni cacajiqquimerehe nejerade. Naraha maittaccadsama odsa panani Sodomahuaji madimanapojaridenipa imasiri sseqquiri nadsa Diojine memehuajicca dsippo siba quejemani ppocorajarodsa odsa, madija huapima jicajari. Naraha pohuadenipa ocanahatori canani qqui toquinapo-jarajari. Nassa qqui toquinadsapa pohuadeni bodideni cacajiqquimera-manadsa Dio pohuadeni inajica-jarahitohuiraha. Jidapana Sodomadsapi madija madimanahi paja naccahitohuiraha −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","—Naraha aji Capernaohuaji timadimanajaro tiadenidsa ohuattipi: Nidsa dsama jicadsa huapima imarideni icattemaridsanijine Dio Pohua baccohuaji domo huadsapa Sodomahuaji madimanajaridenidsa Dio pocca najidsohue ajimani tojanitohui. Naraha tiadenidsana Dio pocca najidsohue denima oppina tanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nahi dsotode Jesopa Imehidsa huati tajari: —Jehe Abi, Tiadsa ohuatidsejaro. Tiapi memehuaji madimanajarideni Cacahuade tija, namihuaji madimanajarideni Cacahuade tija najaro. Jehe, madija nahatoqquiri najaridenipa ajijaro dsamacca ima tocahatteraraha Tiadsapa jiperaqquiri najari. Nadsama tijinepi ticca pajissehecca ima mittamana-jarahijine pohuadenidsa ahuatora tinanajaro. Naraha madija motadenipa: “Iapi ssamomo inajaro, pina ejedeni bedissa inajaro” quiquinanajaridenidsana ticca ima pajissacca ahuato tinanajaro. ");
INSERT INTO cul_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jehe, Abi ¡pajissa! Tia jipa tinadsapi tijine nema tinanajarode −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nadsapa Jeso iadsa huati tapomajari: —Occa Abipa ohuadsa pocca nahatohue huapima inanaridsajaro. Occa Abina pohua motta ohuadsa nahato tahi ojari najari. Occa Abipa nadsama Pohua ojari naha ohuadsa nahato taha nama najonajari. Ohuapi Abi Diocca Ejedeni ojani. Ohua naqui nadsama. Ohua ojari onehe Pohuadsa nahato onajonajaro. Nadsama ohua Dio Bedi ojadsapi madijadeni ohuadsa toquejenajaripa pohuadenidsa jipa onadsapi ojine pohuadenipa Dio Pohuadsa noccodeni tojidserahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—Nadsama ima ccanajani temanadsapi pina ccanajabote jore tiquinadsa ja tiquejenajarossa nadsapi ohuahuajira jai tijajonaji. Otahimaridsa pajissa tiquinadsapi tibodideni jassi onanabaqquinitohui. ");
INSERT INTO cul_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Occa marinaja tiadenidsa tojanijinepi ohuadsa tiadeni teccoramanaji, ohuadsa iboraqquiri tiquinanijine, onajaro. Ohuadsa ticahatteraji. Tiadeni Maride ohuapi jone onani, bica onani. Tibodideni onabicabaqquinitohui. ");
INSERT INTO cul_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Occa marinaja tiadenidsa tojanijinepi ojine pajiranissa tani. Ohuadsa pajissa tiquinadsapi pina ppahua taniccassa nani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nadsapi dsotode naqui jassinajacca huada bacco tadsa Jeso, pocca dodosse tabaqqui tedseje huidsaja nocconi jaijeqquimadsa ipemidsapi aroso jidsadsa trigo bono qqui inajari. Dside ippiridsadsa dsojo dsojo icajidseri nadsa pore siqui apa, pore siqui apa inade. ");
INSERT INTO cul_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Naraha jodiodeni mota marinaja pariseodsa jehe quinajaridenipa ia qqui toquinadsa Jesodsa attidenipa: —¡Ajana! Jassinajacca huadadsapi idsepe ijinijine oppina taraha ticca dodosse tabaqquipa trigo bono dside ippiridsamanadsapa pina jassinajacca huada jerajarodsa dsepedeni ijimanajarissa quinaha −quinade. ");
INSERT INTO cul_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nadsapa Jeso pohuadenidsa huati tajari: —¿Naraha tiadenipi aji Dio Atti maittaccadsama dsodo naniccadsa Dabicca ima hua hua titiquina naraha tetideni ajimamanajarorane? Najaro imapi Dabipa pohua tessedeni tedseje pemimanadsapa pan Diodsa da tahicca oppina taraha jipamanajari. ");
INSERT INTO cul_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Diodsa dada toqquimahuaji toqquedsimadsa cacahuadedsa pan tohui huati tajari. Pan ohuaha nohueradsa Diodsa da tahiccaraha Dabi jipajari, pohua tessedenidsa naco da inabaqquidsa jipamanajari. Najari pan Diodsa da tahipa dada toqquima cacahuadedenira jijipamana najariraha Dabideni pemimanadsa jipamanajari oppinera tahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Nadsama Moisesicca marinajadsa naqui ¿dada toqquima cacahuade tahimarideni hua hua titiquina naraha tetideni ajimamanajarorane? Aji, maittaccadsama Moisesicca marinajapi: Jassinajacca huadadsa dada toqquima cacahuadedenipa dsepedeni ijimanaraha pohuadenidsa najaro huadapi oppinera tani, napohui nade Moisesi. ");
INSERT INTO cul_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Naraha tiadenidsa ohuattipi: Aji Diodsa dada toqquimacca odsapi deni tojanicca tojaccade. Naraha jidapana aja, tiadenidsa madijaripa Abi Diojine pohuana deni tojajari. Jidapanana Diodsa dada toqquimacca odsapi pohuadsa ajimani tojajaro. Najari deni tojajari onajaropi ohuapaji −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","—Maittaccadsama Dio Atti cacomerabote Osea dsodo inapojaropi: “Tohuati huanehe, acco camehe tohuini onani. Ohuadsa ticcadeni bani bedi ono tojahijine da da titiquina naraha madija ohuahadsa tetideni huaneraqquiri nadsapi ticcadeni daniji jipera onani. Madija huapimadsa tetideni huanaqquiri nanijinena jipa onani. Pohuadeni acco acco titicamabaqquimana dsadsanapo nadsa naqui jipa onani” napohui nade Dio. Naraha najaro dsodonijipi timittamana-jerajaro. Nassa timittamanadsapi ima cappiramanajarideni johua ticanabaqquimana-jarahitohuiraha. ");
INSERT INTO cul_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aji Madija Bedi ojajaroa jassinajacca huadapi ohuana jinede ojani. Jassinajacca ima cacahuadepi ohuana paji −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nahidsa Jeso toccadsapa Dio Atti mamarihuaji toqquedsimajaride. ");
INSERT INTO cul_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nadsapa nahihuajicca madija dsepe siri naco nahidsa huittarijari. Nadsa pariseodenipa Jesodsa huati toquinajari: —Nija, Moisesicca marinajadsa, icca madijacca marinajadsa naqui jassinajacca huadadsa madija coma tajari inanomihijine ¿oppinera taqui? Najaropi pina jassinajacca huada jerajarodsa idsepe ijijarossa naraha −quinajari. Pohuadeni bodipa: —Jidapana jassinajacca huadadsa ajajari dsepe siri inanomidsapa Jesodsa ima inahananijine −quinajari. ");
INSERT INTO cul_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Naraha Jesopa: —¡Jari! Manaco ohuatti tecomeramanaji. Ajina, pina ticcadeni edede itide. Jassinajacca huadadsaraha ticcadeni edede odidsa tossonidsimadsapa ¿tidinimana-jaraco? ¡Tidinimanahitohui! onajaro. ");
INSERT INTO cul_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Naraha ticcadeni ededepa ¿tiadenidsa bica tajaraco? Ededepa bica tahi. Naraha ia madijapi denima bicaqquiri inajaro. Nadsapi jassinajacca huadadsa edededsa bica inanani oppinera tadsapi madijadsa naqui bica inanabaqquihijine oppinera tani, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nadsapa madija dsepe siridsa Jeso attipa: —Jari, tidsepe ohuahuaji da ticanajonaji −nade. Nanaja pohua dsepe pohuahuaji da icanadsapi dsepe tocanomijaro. Pina pohua dsepe onihissa camanijaro. ");
INSERT INTO cul_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Naraha pariseodenipa dsotode nahidsapa jai tojeninedsapa imahaha canajari: —¿Nejecoma inanadsa Jeso inanadsoqquehijine? −quinajari. Nadsapa najaro ima huati toquinahijine queriqquimanajari quinade. ");
INSERT INTO cul_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesopa pohua inanadsoqque-manahijine tohuini quinahi nahato tadsapa Dio Atti mamarihuaji nebodsa toccajari. Ia pocca dodosse tabaqqui ia naqui huaji tanihuaji jaijajaro. Nadsapa pohuadsa madija huapi taha jahijonadsapa comaqquiri najarideni huapima inanomibaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Naraha inanomibaqquidsapa pohuadenidsa huati tajari: —Tiadeni onanomibaqquijaro tecomamanana. Aja madija huapimadsa otahimari huati taridsamana tejeraji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nadsama Jesocca imapi pina maittaccadsama Diojine Pohua Atti cacomerabote Isahia dsodo inapojarossa najaro: ");
INSERT INTO cul_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","—¡Ticattomama canaji! Ajajaripa tiadeni Idinide tojahijine occa Ejedeni Ohuattidsa ibora tahijine ocattapojari. Pohuatohui ohuati huana tajaro. Pohuapa Ohua catidsehissa tajari. Ocorime pohuadsa onanadsapi Ohuatti inapajiranissa tanitohui. Pohuapa aja madija tabaccorehe inebomanadsa occa biquehedsa toquejenahijine tahimarini dsama huapimacca madijadsa huati huati naridsahitohui. ");
INSERT INTO cul_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pohuapa pohuadsa jiperaqquiri najarideni tedseje ahuaji huati ahuaji huati quina-jarahitohui. Johuahuera tahitohui. Amossinidsa pohua atti mohui tadsa atti atti najarahitohui. ");
INSERT INTO cul_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pohuapa boba ede jai tahi paja jai inanari-jarahitohui. Naparina jororone cahuidsa jami-mi nadsa naco pohuapa paja icanahuiri-jarahitohui. (Najaro imapi pina aja madija pohuadsa jehe nahissa tajarajari ettajo-jarahitohui. Madija pocca jeheniji tomijiraraha pohuapa najari acco icamahitohui.) Nama dsanapodsapa nidsa dsotode pohuajine occa biquehe deni tojadsapi tabaccorehe inajicanitohui. ");
INSERT INTO cul_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nadsama dsama huapimacca madija pohuatohui quinadsa pohua canajoranihitohui madimanajari, najari Dio −napohui nade Isahia. ");
INSERT INTO cul_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nadsapa madija pohua bodidsa Satanacca dodosse tocorime madidsajari. Najarijine nocco siri, ebeno siri nadsapa qqui tajarajari, atti naco cappiraha madijari. Pohua tessedenipa Jesohuaji eccajonamanajari. Nadsama Jesopa pohua bodicca dosse ininedsapa tonomijari. Qqui tapomajari, atti naco cajipomajari. ");
INSERT INTO cul_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nadsapa nahihuajicca madija huapima najaro qqui toquinadsapa: —A, bica tahi. ¡Jesopa nahato tahi! −quinajari. Attideni naco: —¿Ajajari Jesopa, tamine Dabi Potemahico? Aja ia Idinide, pohuatohui imadijaro ¿ccaronajarico? −quinajari. ");
INSERT INTO cul_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Naraha pariseodeni najaro ima mittamanadsa maidsamanadsa attidenia: —Ajana, Jesopa tocorimedenicca tamine Beheosebocca dacorehe cajijarijinea pocca dodosse tabaqqui dosse ininebaqquijaripaja −quinajari. ");
INSERT INTO cul_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Naraha Jesopa pohuadeni bodi nahato tajari. Bodideni huatomanahijine pohuadenidsa ajijaro ima huati huati tajari: —Dsama huapimacca taminepa madija ecahuabaqquiraha dsotode pocca madija cahadiremanadsa ahuaji atti ahuaji atti quinadsapa pocca cacahuehe inassamomanajaro. Nadsapa pocca madija domo tocca tahi. Najarossa najaro odsa pananicca madija cahadiredsapa tojaribaqqui tahi. Ima onihi naqui najarossa najaro madija ojaria pocca odsacca madija cahadiredsapa poccadeni ima tossamonitohui. ");
INSERT INTO cul_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ima najarossa najaroa Satanapa pocca dodosse tabaqqui madija bodidsa madidsamanajarideni dosse ininebaqquidsapa pina pohua pocca madija tedseje cahadirejarissa najari. Nama nadsapa pocca dossehe inassamodsapi sara tabaqquihitohuiraha. ¿Nadsapa pocca dodosse madija bodicca dosse ininehijine jipa taco? Jipera tahi. Aji ohuadsa tettidenipi: “Satanacca dacorehedsa pocca dodosse dosse tininejari” tiquinaraha najaropi pajissa jerani. Nassa najaro pajissa tojadsapi Satana pohua pocca dodosse tabaqqui inajaribaqqui-ridsahitohuiraha. ");
INSERT INTO cul_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ajina, ohuadsa: “Beheosebocca dacorehe ticajini” tiquinaraha ticcadeni mamari tabaqqui naco Satanacca dodosse tabaqqui dosse dosse ihininebaqquimana najari. Naraha pohuadenipa ¿nejecojaricca dacorehedsa nama quinajari? Aja ticcadeni mamari tabaqquipa dacorehe cajimanadsapa Satanacca dodosse tabaqqui dosse ininebaqqui-manaraha pohuadenidsa: “Beheosebocca dacorehe ticajimanani” ¿tiquinattaqui? Nema tiquinejerani, onajaro. Nadsama ¿nejecotohui ohuadsa nema tiquinajaro? Tibodidenipi quejemama canajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—Naraha ohuapi Dio Corimecca dacorehe ocajije najaro Satanacca dodosse tabaqqui dosse dosse ohoninebaqquiridsa najari. Nema onanadsapi tiadenidsa ahuato onanajaro: jidapana Diocca cacahuehe tiadenidsa bacco najonajaropaji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—Nadsama Satanapa dacorehe cajiraha ohuapi deni ojajaro. Pohuapa ajamani pina ajijaro ima tiadenidsa huati onabote najarossa najaro. Nadsama bobotidepa: “Odsacca todsepetaji obotina” najariraha odsa jinede dacorabote odsadsa madidsadsapa botihijine pajira-jarahi. Naraha bobotide denima dacoradsapa odsa jinede dama inadsa jore inaqquidsapa pohua dsepetaji botihijine pajirahi. Ima najarossa najaroa aji ohua pina bobotide denima dacorajarissa onajaro. Occa dacorehe deni tojadsapi pina Satana jore onaqquijarissa nadsa pocca dodosse tabaqqui dosse dosse ohoninebaqqui najaripaja −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nadsapa Jeso denima huati huati tajari: —Nadsama madija ohuadsa toja-jaradsapa occa huadi tojajari. Pohua naco madija ohuadsa toquejenahijine pohuadeni acco icamabaqqui-jaradsa pohuajine ohuadsa tohuajimanajari, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Nama nadsapa tiadenidsa ohuattipi: Madija imasiri inanamanaraha nidsa dsotode: “Icca ima inebona” quinadsapa poccadeni imasiri, poccadeni tamassohue Diodsa ecomeramanadsa Diopa poccadeni imasiri huapima epeje inananitohui. Naraha Dio Corime itamassomanadsa, pohuajine tojajarodsa maidsehe huahua quinadsa naco Diopa pohuadeni atti huati ajama-jarahitohui. Poccadeni imasiri epeje inana-jeranitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","—Aji ohua Madija Bedi ojajarodsa madija atti atti quinadsa ohua itamassomanaraha nidsa dsotode: “Icca ima inebona” quinadsapa poccadeni imasiri, poccadeni tamassohue Diodsa ecomeramanadsa Diopa poccadeni imasiri epeje inananitohui. Naraha Dio Corime itamassomanadsa pohuajine tojajarodsa maidsehe huahua quinadsa naco Diopa pohuadeni atti huati ajama-jarahitohui. Jidapana imadiccadsama poccadeni imasiri epeje inana-jeranitohui. Nidsa dsotode Dio pocca cacahuehe tojadsa naqui epeje inana-jeranitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nadsama Jesopa ahuacca imadsa mari icanabaqquihijine huati huati tajari: —Ahua bicahi ppa tadsa tecahuahissa tadsapa bono bica taha cahua tahi. Naraha ahua ppa tadsa tecahua-jaradsapa bono tabaccora taha cahua tahi. Nadsama ahua huapima bono cajiridsadsapa bono bicahi cajihi nahato inadsapi: “Najari ahuapa bica tahi” inajaro. Bono tabaccora tahi cajihi nahato inadsapi: “Najari ahuapa tabaccora tahi” inajaro. ");
INSERT INTO cul_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jaho, maidsaqquiri tiquinani. Tebenodenipi pina macca ebenossa tiquinajaro. Tibodideni tabaccoraqquiri nadsapi ima tabaccora tajarodsara tebenodenidsa atti atti titiquina najaro. Aja madija huapimapa pohuadeni bodidsa ima caji tadsapi najaro imara huati huati totoquina najari. ");
INSERT INTO cul_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nadsama madija bica tajaripa pohua bodidsa ima bicani ecahuadsapi ima bicanira huati huati tataja nahitohui. Naraha madija bica tajarajaripa pohua bodidsa ima tabaccora tani ecahuadsapi ima tabaccora taniccara huati huati tataja nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nadsama tiadenidsa huati onajaro: Ima ponimacca huati huati tiquinadsapi nidsa madija huapimacca ima cattemanijinecca huada bacco tadsa Dio Pohua baccohuaji tidomodeni huadsapi aji ima ponimacca huati huati tiquinapojarocca huapima dsori teje cama-jeranitohui, onajaro. Diopa tiadenidsa: “Jari, ohuadsa ticcadeni ima tecomeramanaji. ¿Nejecotohui tettideni nema nema titiquina najaro?” nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nadsama pina jidacca ahuacca ima huati onajarossa najaro aji tettideni huapima Dio nattome inadsapi tohuatti tabaccora tanicca ticajimanadsapi Diopa: “Tabaccora tinani. Tia onajidsona” nahitohui. Naraha tettideni bica tanicca ticajimanadsapi Diopa: “Bica tinani. Tia ocatidsena” nahitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Naraha Jeso atti mittamanadsapa jodiodenicca marinaja maridedeni mota, marinaja pariseodsa jehe quinajarideni mota naco Jesodsa huati toquinajari: —Jari Mamaride, pajissa Diocca dacorehe ticajidsapi memehuajicca nahatohue bicabote ahuato tinanaji. Qqui inana, inajaro −quinade. ");
INSERT INTO cul_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Naraha Jesopa pohuadenidsa huati tajari: —Jidapana timadimanajarodeni tabaccoraqquiri tiquinehe timadimanajaro. Tahidepi tettideni: “Diocca iquejenani” tiquinaraha dsotodepi Pohua Atti tinebomanajaro. Aji ocanahatoriri cananijine tohuira huati tiquinaraha occa nahatohue onahatona onejerani. Naraha ocanahatoriri cananicca ima ojariena qqui tiquinanitohui. Najaropi Dio Atti cacomerabote Jonasocca imassa najaro. ");
INSERT INTO cul_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Najaroa aji Jonaso pina huatiajarissa nadsa aba imehi bodidsa huada huatinimade tojari nehe madidsajarissa najaro aji ohua Madija Bedi ojajaropi nidsa ohuatiadsa nami bodihuaji huada huatinimade tojari nehe omadinitohui. Pina Jonasocca imassa najaro ohuadsa tojanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Nadsapi nidsa madija huapimacca ima cattemanijinecca huada bacco tadsapi Dio Pohua baccohuaji tidomodeni huanitohui. Nahidsapa odsa panani Ninibehuaji madimanajaridenipa ticcadeni ima tiadenidsa inassonarimananijine huati toquinahitohui: “Iapi Jonasocca ima imittadsa ibodi cacajiqquimerade. Naraha tiadenidsapa Dio Atti cacomerabote deni tojajari madiraha pohua atti mittade iboqquiri tiquinajaro. Nema tiquinadsapi Dio tiadeni tohuattajo-baqquidsapa bica tani, inajaro” quinahitohui Ninibecca madija −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Najaro huadadsa dsama Sebahuajicca tamine amoneje madijaro naqui ticcadeni ima tiadenidsa inassonarinijine huati tanitohui. Poni attinipi: “Ohuapi dsama huaji tanihuaji omadiraha tamine Saromocca nahatohue omittanijine occajonade. Naraha tiadenidsa madijaripa denima nahato taraha pohua atti mittade iboqquiri tiquinajaro. Nema tiquinadsapi Dio tiadeni tohuattajo-baqquidsapa bica tani, onajaro” nanitohui Sebahuajicca tamine amoneje attinipi −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesopa ima onihidsa mari icanabaqquijari. Pohua attipa: —Nadsama tocorime ojaria madija bodidsa madidsaraha qquenadsapa toccajari. Aji dsama huamo tanihuaji, passo nohueranihuaji pohua madihijine qquide toccadsa qqui qqui naridsaraha pohua madihijine bacco tajarajari. ");
INSERT INTO cul_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nadsapa: “Jehe, occa mamadi botehuaji occanipomana” najari tocorime atti. Nadsapa ccanipomajari. Bacco nanidsa madija pohua bodi tohuirehi qqui tadsapa pina odsa johue tocanehe huisso tocanajarossa naraha tomadirajaro. ");
INSERT INTO cul_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nadsapa tocorime toccapomadsa pohua tessedeni tocorime 7 quinaha jina inanibaqquijari. Najaridenipa denima tabaccoraqquiri naraha pohua tedseje jai tojedsimajari, madimanahijine. Nadsama ima nema najaro madijadsa tojadsapi pocca madie tabaccora taporaha dsotodepi denima totabaccorajaro. Tiadenidsa najarossa najaro tojanitohui. Jidapana tabaccoraqquiri tiquinehe timadimanajarodeni otahimaridsa pajissa tiquinejeradsapi ticcadeni madie denima totabaccoranitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jehe, Jesopa madijadsa huatide tojaraha amossinihuajipa Jeso imeni, pohua imecotedeni tedseje: —Jesodsa huati inana −quinadsa pohuatohui domo huajari. ");
INSERT INTO cul_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nadsa Jesodsa madija ojaria attipa: —Ticca ami, timecotedeni amossinidsa domo huapaja. “Tiadsa huati inana” quinajari −najari. ");
INSERT INTO cul_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Naraha pohuadsa huati tajaridsa Jeso attipa: —Occa amipi ¿nejecojarona paji? Ohuemecotedeni naco ¿nejecojaridenina paja? −nade. ");
INSERT INTO cul_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aji, ia pocca dodosse tabaqquideni ia dsopi tabaqquidsa Jeso attipa: —Ajajaridenina pina occa amissa, pina ohuemecotedenissa quinajari, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Madijadenipa occa Abi Dio memehuaji madijari Pohua jipa tahicca ihinanamana najarodenina pina ohuemecotedenissa quinajari. Amonejedeni naqui Dio Pohua jipa tahicca ihinanamana najarodenina pina occa amissa, pina ohuemecotedenissa quinajaro, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dsotodepa najaro huadadsa Jeso odsadsa qquenadsapa coridsa inidicca ssiquihuaji toqquedsippadsa huittajari. ");
INSERT INTO cul_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Madija huapi taha nahi pohuahuaji jahidsippadsa Jeso mari icanabaqquihijine canoadsa toqquedsadsapa canoacca huihuittaridsa huittarijari. Nadsama madija huapimapa nahi coridsa inidicca ssiquidsa domo huajari. ");
INSERT INTO cul_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nadsapa Jeso pocca marinaja ajijaro namidsa imadinicca ima tadsajani pohuadenidsa huati huati tajari. Pocca imapi ajima najarode: —Huidsaja ppappadepa pocca huidsaja huirade toccajari. ");
INSERT INTO cul_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nocco huira inaridsajari. Naraha motapa jahuihuaji catojaja najari. Nadsapa ppiriri jahironadsa amadsati saca quinajari. ");
INSERT INTO cul_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Aja nocco huira naridsajari mota naco siba ccababa tanidsa catojajari. Nanidsapi ssiqui bicani badsira taraha nama naha huassinaja moro tajari. ");
INSERT INTO cul_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Moro taraha jabo huapihuajira toccabaqquijari. Maji ccajonadsapa maji ppoconejine botejari. ");
INSERT INTO cul_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nocco mota naco namidsa cotihi caji tahihuaji catojajaria cotihi tedseje paja moro toquinarihi naraha cotihijine ssomi tojajari. ");
INSERT INTO cul_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Naraha nocco mota huira naridsajaripa nami bicanidsa catojaridsadsapa mororo canaridsadsa bica taha napijari. Bono cajiridsadsapa ede ojariapa bono 100 naha cajijari. Ede ohuahaccapa bono 60 naha cajijari. Ede ohuahaccapa bono 30 naha cajijari. ");
INSERT INTO cul_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nadsama ia, pocca dodosse tabaqqui iquejenajaropi Jeso pohuahuaji huajijira icanadsa ajima inade: —¿Nejecotohui titahimari ajijaro namidsa imadinicca ima tadsajani pohuadeni mari mari titicanaridsabaqqui najaritta? −inade. ");
INSERT INTO cul_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Naraha Jeso iadsa ecomerade: —Jehe maittaccadsama Diocca cacahuehecca ima dsati najoraporaha madija inahattabaqqui-jaraccade. Naraha jidapanana Dio Pohuajine pocca cacahuehe tahimarini dsati tiadenidsana ahuato tani. Naraha madija motapa Dio Pohuajine pohuadenidsa ahuatora tadsa mittamana-jarajari −nade. ");
INSERT INTO cul_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—Ajina, Diocca cacahuehe tahimarini mari ocanaridsabaqquihicca madija tohuattajaripa Diojine najaripa denima tohuattahitohui. Nadsapa najarina denima nahato tahissa tahitohui. Naraha Diocca cacahuehe tahimarini mari ocanaridsabaqquihicca madija mimitta naraha tohuatta-jaradsapa occa marinaja cappirahissa tahitohui. Badsira taha tohuattadsapa najaro naqui amossi nanitohui. ");
INSERT INTO cul_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nema najarojine otahimari ajijaro namidsa imadinicca ima tadsajani madijadeni mari ocanaridsabaqquija naridsapohui najari. Pohuadenipa qqui qqui toquinaraha pina qqui toquirahi najaripaja. Diocca dosseniji mimittamana naraha pina mittamanerahi najari. Pohuadeni bodi naco ssamoqquiri najari. ");
INSERT INTO cul_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nadsama poccadeni imapi pina maittaccadsama Dio Atti cacomerabote Isahia dsodo inapojarossa najaro inanamanajaro. Aji Isahia attipa: “Teribodeni ticajimanaraha pina timittamanerani nanitohui. Tinoccodeni ticajimanaraha pina qqui tiquirani nanitohui. ");
INSERT INTO cul_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ajajari madija bodideni tossamoridsadsapa paja tossamomanarihi nahitohui. Huaribodeni moda nahi nadsapa pina mittamanerahi nahitohui. Noccodeni naco modsi quinadsapa pina noccodeni cappiramanajarissa nahitohui. Nama quinadsapa qqui toquinahijine ssamoqquiri, mittamanahijine ssamoqquiri, bodideni tocahatterahijine ssamoqquiri nadsapa bodideni cacajiqquimera-manahijine ssamoqquiri nahi. Nassa bodideni cacajiqquimera-manadsa ohuadsa toquejenadsapa onabicabaqquihitohuiraha” nahi nade Dio −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","—Naraha aji tiadenina ohua ocanahatoriri canajaro tinoccodenidsa qqui tiquinaridsajaropi Dio tiadenidsa ima bicani inanajaropaji. Teribodenidsa naqui occa marinaja timittamanajaropi Dio tiadenidsa ima bicani inanajaropaji. ");
INSERT INTO cul_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pajissara tiadenidsa huati onajaro: Maittaccadsama Dio Atti cacomeraqquiri najarideni, Diodsa iboraqquiri najarideni naco occa nahatohue aji jidapana tiadeni qqui tiquinajarocca qqui toquinahijine tohuini quinaporaha tahide tojicapodsapa qqui toquina-jarajari. Aji occa marinaja timittamanajarocca naqui najaro mittamanahijine tohuini quinaporaha tojicapodsapa mittamana-jarajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nadsama Jesopa pocca marinaja ajijaro namidsa imadinicca ima tadsajani mari icanabaqquipomadsa naco pohua attipa: —¡Jari, titaharibomananissa taji! Huidsaja ppappadecca imapi ajima najaro: ");
INSERT INTO cul_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nocco huira inaridsajari mota jahuihuaji catojajaripa pina madija Diocca cacahuehe tahimarini mittamanaraha ja quina-jaradsa pina mittamanerahi nadsapa bodidenidsa Dio Atti toqquedsima-jerajarossa najaro. Aja ppiriri nocco saca inaridsajaripa pina maidsehe jinede Satana ccajonadsa bodideni inassamobaqquijarissa najaro. Nadsapa Dio Atti pohuadenidsa nohuerajaro. ");
INSERT INTO cul_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Madija ohuaha bodidenicca imapi pina aji siba ccababa tajarocca imassa najaro. Dio Atti mittamanadsa amadsati huatidsemanajari. ");
INSERT INTO cul_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pohuadenipa Diodsa jehe dsanapomanahijineraha Dio Atti pohuadeni bodidsa toja-jerajaropi pina siba ccababa tanidsa nocco moro taraha jabo huapihuajira toccabaqquijaricca imassa najaro. Nadsama aja maji ppoconejine botejaricca imapi Dio Attidsa jehe quinajarijine pohuadenidsa najidsohue ssonaridsa, ocasserani ahuamanadsapa jehe quidsati attidenia: “Epejena, Dio Attipi inebona” quinajari. ");
INSERT INTO cul_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Madija ohuaha bodidenicca imapi pina namidsa cotihi caji tajaricca imassa najaro. Pohuadenipa Dio Atti mittamanaraha pohuadeni dsepedeni ihijimana najarotohuira disseraqquiri nadsapa Dio Atti tocahatterahissa tajarajari. Dsiniro tohuira quinadsa naco najaro imajine Dio Atti huatideni ajamamanajari. Poccadeni jeheniji pina aja nocco moro taraha cotihijine ssomi tojadsapa bono-jarajarissa najaro. Dio Atti mittamanaraha pohuadenijine Dio Atti madija ohuahadenidsa toja-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Naraha madija ohuaha bodidenicca imapi pina aji nami bica tajarocca imassa najaro. Dio Atti mittamanadsapa jehe quinahissa tajari. Poccadeni jeheniji napidsapi pina aja nocco nami bicanidsa moro tahissa tadsapa bono cajijari. Ede ojariapa bono 100 naha cajiridsajari. Ede ohuahaccapa bono 60 naha cajijari. Ede ohuahaccapa bono 30 naha cajijari. Aja Diodsa jehe quinahissa tajaripa madija mari icanabaqqui-ridsadsapa madija ohuaha ohuaha quinaha Diodsa inanabaqqui-manahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesopa pocca marinaja ajijaro namidsa imadinicca ima tadsajani madija mari icanabaqquipomajari: —Jehe, Diocca cacahuehe tahimarini onihi naqui pina huidsaja jinede pocca huidsajahuaji nocco bicahi huira inaridsajaricca imassa najaro. ");
INSERT INTO cul_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Dsome huapima cahadijadsapa pocca huadi ccajonajaria aroso jidsadsa trigo bicahi tetepidsa dsero nocconi pina trigossa najaro huira inaridsajaro. Huira inaridsaha jicadsapa aja huidsaja jinededsa huadi tajaripa toccanijari. ");
INSERT INTO cul_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nadsapa trigo bicahi moro tajari, bono cajijari. Dsero pina trigossa najaro naqui moro tajaro. ");
INSERT INTO cul_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nadsa huidsaja jinedecca dodosse tabaqqui qqui toquinadsa pohuadeni dossedehuaji jai tojanidsapa huati toquinajari: “Ia dossede ¿trigo noccora ticca huidsajadsa huira tajarajarittaco? ¿Nejecohuajicca dsero pina trigossa najaro nocconi ccajonajarotte? inajaro” quinajari. ");
INSERT INTO cul_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Naraha huidsaja jinede attipa: “Jaho, madija ohuadsa huadi tajaripa dsero nocconi huira inaridsajaroa” najari. Nadsa pocca dodosse tabaqqui attidenipa: “Jipa tinadsapi dsero dsoppade jaijanipomana, inajaro” quinajari. ");
INSERT INTO cul_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Naraha jinede attipa: “¡Poni! Najaro dsero dsoppa tiquinejerana. Trigo naco dsoppa tiquirana” najari. ");
INSERT INTO cul_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“Apajaccana, pamaha napimanaccana. Nidsa trigo bono jadadsana ahuato tahitohui. Nadsana bonotohui edema ti tiquinaridsahijine bica tahi. Nadsapa titidedenidsa ajima onanitohui: Jari, tahide dsero ti tiquinapona, onanitohui. Tide jicadsa ponira hua naqquidsapi jore nacossadsana botta tiquinaji, onanitohui. Naraha trigo bicahi bonotohui edema ti tiquinadsapa occa odsahuaji ohuadsa tojahijine jore jore tanimanajo, onanitohui” najari huidsaja jinede atti. Jehe, Diocca cacahuehepi najaro imassa najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nadsapa Jeso pocca ima huati tapomahijine ajijaro namidsa imadinicca ima tadsajani mari icanabaqquipomajari: —Diocca cacahuehepi pina mostaza noccocca imassa najaro. Madijapa pocca huidsajadsa mostaza nocco ppa idsajari. ");
INSERT INTO cul_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Najari mostaza noccopa potera tajari. Ppa nahi nocco ohuaha naco potera tajari caji taraha mostaza noccopa denima potera tahi. Naraha mostaza nocco moro tadsapa huidsajacca ppa nahidsa pohuana deni tojajari. Napidsapa pina ahua imehissa najari. Motaradsapa pohua ininedsa ppiriri pohuadeni tadsari bina tarimana tahi. Jehe, Diocca cacahuehecca ima mari ocanabaqquijaripa pina najaro imassa najaro. Tahidepi madija pamahadsa tojapojaro. Dsotodena madija huapimadsa tojaridsadsapi Diocca cacahuehedsa madija tohuapihitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nadsapa Jeso pohua tahimari ajijaro namidsa imadinicca ima tadsajani mari icanabaqquipomadsa naco: —Jehe, Diocca cacahuehe tahimarini onihi naqui pina pan ssaja tahijinecca imassa najaro. Amoneje pan inahatohuijinepa pan ssaja tahijine quequejema levadura trigo ria nahidsa icanejemajari. Ssaja tahijine quequejema badsira taraha trigo ria nahi harina 3 kilopa motarajari. Naraha ssaja tahijine quequejema trigo ria nahi harinadsa tojaribaqquidsapa ssaja tajari. Aji Diocca cacahuehecca ima naqui najaro imassa najaro. Tahidepa madija pamaraha dsotodena Diocca cacahuehecca ima dsama huapimadsa tojaribaqquidsa madija huapimadsa tojaridsajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jehe, Jesopa pohua tahimari ajijaro namidsa imadinicca ima onihi onihi najaro tadsajani madija huapima mari mari ihicanabaqqui najari. Pohuadenidsa huati tadsapa ajijaro namidsa imadinicca imadsara mari mari ihicanabaqqui najaride. ");
INSERT INTO cul_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jeso nama najaripa aja maittaccadsamacca Dio Atti cacomerabote Jeso tedsejemacca ima dsodo inaponicca najarossa inanajaro. Najaro ima Dio Atti dsodo nanidsa ajima najaro: —Otahimari ajijaro namidsa imadinicca ima tadsajani mari mari ohocanabaqqui nahitohui. Dsama onahato-jeraccadsama naqui otahimari ahuatora tajonaraha. Nidsa ojine najaro ima ahuatoridsadsapi madija huapima mari ocanabaqquiridsahitohui −napohui nade Dio Atti cacomerabote. ");
INSERT INTO cul_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nadsapa nahidsa Jeso madija huapima inebobaqquidsapa toqquemoranijari. Odsahuaji toqquedsimanidsapa nahidsa pocca dodosse tabaqquideni iapi pohuahuaji huajijira inadsa huati inajaro: —Jari, jidacca huidsajacca aroso jidsadsa trigo tedseje dsero quejemani tahimarini huati tinapojaro iadsa huati timanipomaji, imittanissa tanijine, inajaro −inade. ");
INSERT INTO cul_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nadsapa ia mari tocanabaqquijari: —Jehe, ohuapi Madija Bedi ojajaroa pina trigo bicahi huihuiradessa onajaro. ");
INSERT INTO cul_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nadsama huidsajapi ajijaro dsamassa najaro. Trigo bicahi noccopa pina madija Diocca cacahuehedsa toquejenajarissa najari. Pohuadenipa Dio Attidsa iboraqquiri najari. Naraha dseropi pina madija Diocca huadi Satana attidsa iboraqquiri najaridenissa najaro. ");
INSERT INTO cul_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nadsa dsero nocconi huihuiradepa huidsaja jinedecca huadi Satana. Nadsama nidsa trigo bono jadadsa ti nahijinecca huada bacco tajaropi pina nidsa dsama jicadsa Dio Pohuadsa toquejenajarideni icattejidsa-baqquihijine tahimarissa najaro. Aja trigo titidedenipa Diocca dodosse tabaqqui memehuajicca. ");
INSERT INTO cul_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Aji dsero huanaqquidsa botta quinanijinecca imapi nidsa ajijaro dsama jicadsa madijadsa najarossa najaro tojanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Naraha nidsa ohuapi Madija Bedi ojajaroa memehuaji omadipomadsa occa dodosse tabaqqui memehuajicca dosse onaronaridsa-baqquidsapa imasiri mamaridedeni, imasiri totonanadedeni tedseje huapima icattejidsabaqqui-manahitohui, Diocca cacahuehedsa toquejena-jarahijine. ");
INSERT INTO cul_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Najarideni huapimapa jororoni jiquejeranihuaji hua idsimabaqqui-manahitohui. Nahihuajipa ocasserani ahuamana-dsanapodsapa panodeni todsahi nadsa oji oji quinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nadsama icattejidsa-baqquimanaha jicadsapa madija Dio Pohua jipa tahicca inanamanajarodenina aja Pohuadsa toquejenajarideni huapima Abi Diocca cacahuehedsa madimana-dsanapodsapa pina maji dsibehi tajarissa quinahitohui. Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Jehe, Diocca cacahuehepi pina todsepetaji bicabote huatini ccara taniccassa najaro. Madijapa pajimaranihuaji qquide ccaridsadsa todsepetaji tonajimani bacco inajaro. Todsepetaji bicabote, huatini ccara tanicca qqui tadsapa najaro todsepetaji denima inajimapomajaro. Nadsapa huatidsedsa toccanijari. Pocca odsahuaji bacco tanidsapa pohua dsepetaji nemanehe manaconitohui da inehe jicajaro. Najaro manaconi cajidsapa aja pohua qquide ccaridsapohuihuaji toccapomajari. Nadsapa najaro dsama mitta inadsapi pocca tojajaro. Aji todsepetaji bicabote huatini ccara tanicca pohuajine tonajimani naqui pocca tojajaro. Najaro imassa najaro Diocca cacahuehe denima bica tadsapi madija pocca imabote nemanehe inebodsapi Diodsara huatidse-dsanapohuitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Jehe, Diocca cacahuehe tahimarini onihi naqui pina madija tomattocca huatini ccara tanicca perla mittade tohuini nadsa qquide ccaridsajari. ");
INSERT INTO cul_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nadsama perla bicabote huatini ccara tanicca bacco inadsapa jinededsa: “Ohuadsa tecahuaji” nadsa pocca odsahuaji toccanijari. Pohua dsepetaji inequeriqquidsa nemanehe da inadsapa najaro manaconidsa perla mittade toccapomajari. Mitta inadsapi pocca tojajaro. Jehe, Diocca cacahuehepi najaro imassa najaro. Icca imabote nemanehe inebodsapi Diocca cacahuehe bicabote iadsa tojajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Jehe, Diocca cacahuehe tahimarini onihi naqui pina aba cocoro imenibote passo imenihuaji tappa icadsippamanadsa joca icamoranimanadsapa aba ohuaha, ohuaha naha huemajari. ");
INSERT INTO cul_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nadsapa aba cocorodsa ijihissa tadsapa ssiquihuajina joca icamoranimanadsapa jassi tadsa aba bica tajarira icattejidsamanadsa dsaminedsa hua idsaridsamanajari. Naraha aba tabaccora tajaripa hua quinajari. ");
INSERT INTO cul_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Najarossa nanitohui nidsa ajijaro dsama jicadsa naqui. Tahidepa Diocca huadidsa toquejenajarideni Dio inajidsobaqquihijinepa pina aba tabaccora tajari tocattejidsadessa quinahitohui. Diocca dodosse tabaqqui memehuajiccana madija tabaccoraqquiri najari icattejidsabaqqui-manaccahitohui. Pohuadenira domo huahitohui. Najaridenipa jororoni jiquejeranihuaji hua todsimabaqquihitohui. Nahihuajipa ocasserani ahuamana-dsanapodsapa panodeni todsahi nadsa oji oji quinahitohui. Naraha ohuadsa toquejenajarideni, aja Dio Pohua jipa tahicca inanamanajarodenina Dio madihihuaji toquejenahitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nadsapa Jeso iadsa huati tajari: —¿Nija? Occa ima aji tiadeni mari mari ohocanabaqqui najaro ¿timittamananissa taqui? −nade. Nadsapa: —Jehe, imittani −inade, ia huapima. ");
INSERT INTO cul_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nadsapa iadsa Jeso attia: —Nema nadsapi jodiodenicca marinaja maridedeni Diocca cacahuehe tahimarini dsatidsa toquejenadsapa pina odsa jinedessa quinajari. Odsa jinedepa pohua dsepetaji odsa bodihuaji ecahuajaro. Todsepetaji jadani caji, todsepetaji dsati naqui caji najari. Nadsapa pohua bodi nahato tadsa todsepetaji jadani dsojo inine tani. Todsepetaji dsati naqui dsojo inine tani. Nadsama aja Dio Atti maridedeni madija maride toquejenadsapa Dio Atti dsodo napojarocca, Diocca cacahuehe tahimarini dsati tadsajani maride nahatoqquiri najari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nadsama Jesopa pocca marinaja ajijaro namidsa imadinicca ima tadsajani huatide jicadsapa nahihuaji nebodsa ");
INSERT INTO cul_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","pohua napihihuajina toccanijaride. Odsa panani Nasareti bacco tanidsapa poccadeni Dio Atti mamarihuaji toqquedsimadsa mari icanabaqquijari. Naraha nahicca madijapa Jeso canahatoriri canahi qqui toquinapo-jaradsa huajo caniredsa attidenipa: —A ¿nejecohuaji tohuattajaritta? −quinade. —¿Nejecojaricca nahatohue Jesodsa tojajarotte? −quinade. ");
INSERT INTO cul_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—¡Naraha ajajaripa ahua nanahatode bedia! Imeni oninipi Maria. Pohua imecotedeni naco: Satiaco, Dsodse, Ssino, Joda quinajaripajade. ");
INSERT INTO cul_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Pohua caripenedeni naqui aji imadinidsa madimana-jeraqui? Madimanani. Nadsama ¿nejecohuajicca nahatohue pohuadsa tojajarotte? −quinade. ");
INSERT INTO cul_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Nadsapa pohua atti mittade tojiperamanajari. Nadsapa Jeso attia: —Ohuadsa pajissa tiquinejeradsapi pina Dio Atti cacomeraqquiri najarideni tahimarissa tinanamanajaro: Madija huapimapa aja Dio Atti cacomerabotedsa: “Pajissa Diocca dossenijia” quiquinanaraha aja pohua dsamariccapa nama quina-jarahi, pocca odsacca naco pohua attidsa jiperaqquiri naha nama najonamanajari −nade. ");
INSERT INTO cul_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nadsapa nahihuajicca madija Jesodsa pajissa quina-jaradsapa pohua canahato-huajapohui canahicca huapi tejerani. Madija pamahara inanomibaqquijaride. ");
INSERT INTO cul_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nadsapa Jeso canahatori canaridsadsapa pocca ima tojaribaqquijaro. Nadsapa dsama arobeni Carireahuajicca tamine Herodepa Jesocca ima huati huati toquinahi mittadsapa ");
INSERT INTO cul_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","pocca dodosse tabaqquidsa huati tajari. Herode attipa: —Aja canahatori canajaripa Huano Baotista dsoqqueraha nahatonijari. Najaro nahatonihejine canahatori canahi −nahi nade tamine Herode. ");
INSERT INTO cul_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nadsama Herode atti nama nadsa tahide pohuajine Huano Baotista inanadsoqque-manapojari. Najaro imapi ajima najaro: Tahidepa tamine Herode pohua imecote Feripecca amoneje Herodia icajidsa ima tojajaro. Huanopa poccadeni ima mittadsa Herodedsa huati tajari: —Diocca dossenijidsapi timecotecca amoneje tidijidsadsapi bica tejerani −nanaja najari Huano. Najaro ima Herodia mittadsapi Huanodsa huadijaro. Ponicca maqquidsa dosse dosse nadsa tamine Herodepa pocca dodosse tabaqqui idossebaqquidsa Huano dama quinadsapa toponi cocoro todsimadsa coro idsimamanajari. ");
INSERT INTO cul_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nadsapa tamine Herodepa Huano Baotista dsoqquehijine tohuini naraha madija noppinedeni cappinajari. Ajana, madijadeni huapimapa: —¡Huano Baotista attipa pajissa! Pohuapa Dio Atti cacomerabote −quinajari huapima. ");
INSERT INTO cul_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Naraha huada onihidsa tamine Herode pohua tossonahicca huada bacco tadsa ejete inanajaro. Herodia bedeni dsobi dsobi todsadsapi huapima qqui toquinajari. Nadsapa tamine Herode ponicca dsobinaja bica tani qqui tadsa huatidsedsapa ");
INSERT INTO cul_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","dsohuatodsa pohua attia: —Jari jata, ticca huatinaja ohuadsa huati tinaji. Nadsapi tiadsa da onanitohui −najari. —¡Pajissa! Tia ocamaidsa-jerajaro, ohuattissa onanitohui −nahi nade tamine Herode. ");
INSERT INTO cul_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nadsapi dsohuatocca ami attinipi: —Huano Baotista tatitohui huati tinaji −nadsa najarossa inanajaro. Attinipi: —Ohuadsa Huano Baotista tati parato imehidsa huittidsadsa da ticanajo −nani nade dsohuato attini. ");
INSERT INTO cul_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nadsapa Herode pohua bodi jipera taraha pohua atti tahide: —Tia ocamaidsa-jerajaro, ohuattissa onanitohui −nanaja napodsa pohua tessedeni: —Pajissehe huati tajari −quinahijine tohuini nadsapa: —Jehe, Huano matto ca tijidsadsapa paratodsa ponidsa da ticanajo −najari. ");
INSERT INTO cul_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nadsapa pocca dodosse toponi cocorohuaji dosse inajari. Nadsapa tamine Herode attidsa Huano matto ca ijidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Nadsama tati paratodsa ettidsadsa dsojo icadsimanidsapa dsohuatodsa da icanajari. Nadsapi dsohuato poni imenidsa da icanajari. ");
INSERT INTO cul_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nadsapa Huanocca dodosse tabaqquideni assiretohui jahijonadsa dsojo ininemanajari. Nadsapa ppa idsamanajari. Dsotodepa: —Najaro ima Jesodsa huati inana −quinadsa Jesodsa huatide jai tojajari. ");
INSERT INTO cul_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesopa —Huano Baotista dsoqquehi −quinahi ima mittadsapa pohua motta madihijine madija madide nohuerahihuaji canoadsa jaijaro ia huapima. Naraha madija huapimapa —Jeso toccahi −quinahi ima mittamanadsa odsa onihi onihi naridsanicca madija Jeso pohuatohui coridsa huapi jai tojabacossajari. Dsotorinihuaji jai huajanijari. ");
INSERT INTO cul_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nadsapa Jeso canoa huana tocanadsa toqquemorajari. Nanaja madija pohuatohui jai tojajarideni bacco toquinapodsa domo hueri nahi qqui inabaqquijari. Nadsapa pohuadenitohui huati cahanari canadsapa comaqquiri najarideni inanomiridsa-baqquijari. ");
INSERT INTO cul_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nadsapa maji toccadsa pocca dodosse tabaqqui iapi Jesodsa huati inade: —Ahuajipa madija madide nohuerahi. Maji toccahi. Madija dosse tinanibaqquijo, ahuajipa dsamatapa mitta quinahijine nohuerahi. Aja, odsacca dsamatapa mittade jai tojanina −inade. ");
INSERT INTO cul_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Naraha Jesopa: —Jai tojanihijinepa ¡pohua! Ajadsa tiadeni tinajipabaqquimanajo −nade. ");
INSERT INTO cul_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Naraha iapi: —Iadsapa pan 5, aba pama napaja. Denima icappirani −inade. ");
INSERT INTO cul_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nadsapa Jeso attia: —¡Apaja! Najari ohuadsa teccajonamanajo −najari. ");
INSERT INTO cul_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nadsapa Jeso madija huapimadsa huati tajari: —Nani dsero caji tanidsa jassi jassi tineri naridsaji −nade. Nadsapa Jeso pan 5 naha inacca, aba pamaha idsaba nadsa memehuaji tocattamacossa nadsa Diodsa huati tajari: —Jehe, epejeni. Ticca daniji iadsa bica tahi −najari. Nadsapa Jeso canahatori canajarijine pan, aba najari tohuapidsa icanabobiridsadsapa pocca dodosse tabaqqui iadsa pan da inabaqquijari. Iana madija jassi jassi teri najaridenidsa pan da inabaqquiridsajaride. ");
INSERT INTO cul_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Da inabaqquiridsadsa jipamanadsapa accararidsa-manajari. Jipamanahissa taraha mota tojajari. Pan bobi, aba ime mota inaccaniridsa-manadsapa quiqui 12 naha ijiridsajari. ");
INSERT INTO cul_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nadsa aja madija jipamanajaridenipa maqquideje 5 mil quinajari. Denima poccadeni amoneje, poccadeni ejedenideni naco jipamanajari. ");
INSERT INTO cul_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nadsapa canahatori canahicca pan jipamanahi nattipa Jeso pocca dodosse tabaqqui ia coridsa jippehuaji ia dosse tabaqquipojari: —Jari, canoadsa jai tijedsadsa tahide jippehuaji jai tijapoji, onajaro −nade. Naraha Jeso pohuapa nahidsa iboccajari. Nadsapa madija huapimadsa huati tajari: —Epejeni, huapima jai tijanina −nade. ");
INSERT INTO cul_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nadsapa madija jai tojanihijine huati taha jicadsapa manaco pohua motta ssonohuaji denima toqquemorajari, imehi Diodsa huati tahijine. Jeso pohua motta nahi ssonohuaji Diodsa huatide tojadsa cadsomejari. ");
INSERT INTO cul_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Naraha iapi coridsa nocconi ori inaraha jojode itedsejema ccajonadsapi passo ssoda ssoda najarojine canoa quehenacossajaro. ");
INSERT INTO cul_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nadsapa ssiajaricossadsa Jesopa qquedsippanidsa passo tetepi iahuaji ccamissajonadsa ia bacco tamissabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nadsapa Jeso passo tetepi ccajonahi qqui inadsapi otessedeni tedseje ijabojo najarode. Pohua noppine icappinadsapi johua johua inade: —¡Tocorime itidija! −inajarode ia huapima. ");
INSERT INTO cul_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Naraha iadsa Jesopa: —¡Ticappinamana tejeraji, ohuapi ohua! −nade. ");
INSERT INTO cul_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nadsapa Pedro attia: —Ohua Medsede ¿pajissa tiaqui? Pajissa tijadsapi tiahuaji passo tetepi occanijine ohuadsa huahua taji, onajaro −najari. ");
INSERT INTO cul_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Nadsapa Pedrodsa Jeso huahua najari: —Jehe, ticcajonaji −najari. Nadsa Pedropa canoadsa huittidsaraha totehema, passodsa toqquedsippadsapa Jesohuaji passo tetepi toccajari. ");
INSERT INTO cul_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Naraha jojode dacorajaro, oppina tani qqui tadsa Pedro bodi cappinajari. Cappinadsapa passodsa jaro dsanajari. Jaro dsanadsapa Jesotohui huahua najari: —¡Ohua! ¡Ohua! ¡Ohua Medsede, ohua tidimoraji! −najari Pedro. ");
INSERT INTO cul_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nadsa Jesopa amadsati Pedro dsepedsa dama mari idsanadsapa huati tajari: —Pedro, ticca jeheniji pajiranissa tejerajarojine jaro tidsanajaropaji. ¿Nejecotohui ohuadsa: “Jehe, Jesopa passo tetepi occanijine pajirahi” tejerajaro? −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nadsama canoadsa huededsanidsapa jojode totappajaro. ");
INSERT INTO cul_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nani canoadsa jassi idsaraha ia huapima ibodipi: —Jeso deni tojahi, iapi ajimani iquejenani −inadsa Jeso baccohuaji ipitodsa jassi idsadsapi pohuadsa huati inajaro: —Pajissa, tiapi Dio Bedi tijani −inajarode, ia huapima. ");
INSERT INTO cul_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Dsotode coridsa jippehuaji iaqquejidsadsapi dsama onini Jenesarehuaji bacco inajaro. ");
INSERT INTO cul_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nadsapi jaijemoradsa nahihuaji madimanajarideni Jeso qqui toquinajari. Nadsapa —Jeso iadsa bacco nahi −quinahi ima tojaridsadsapi comaqquiri najarideni pohuadeni tesse eheccajona-baqquimana najaride. ");
INSERT INTO cul_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nadsama huapima Jesotohui disseraqquiri nadsa pohuadeni attidenipa: —¡Jeso, ohua tinanomiji! ¡Ticca etero iponira bara onanijine ahuaji ticcajonaji! −quiquinanajari. Nadsapa pocca etero iponi bara quinajarideni huapimapa tocanomireridsahissa tajari. ");
INSERT INTO cul_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nadsapa huada onihidsa odsa panani Jerosarehuajicca jodiodeni marinaja pariseodsa jehe quinajarideni, jodiodenicca marinaja maridedeni tedseje Jesodsa bacco najonamanajari. Jesocca dodosse tabaqqui pohuadeni dsepe ssahuarahi jipamanahi qqui toquinadsapa Jesodsa huati toquinajari: ");
INSERT INTO cul_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Nejecotohui ticca dodosse tabaqquipa jodio quejenaraha icca ididenicca marinaja ecahuamana-jerajaro? −quinade. —Ajana, pohuadeni dsepe ssahuarahi jipamanadsapa Diodsa bica tejerani, iadsa naqui oppina tani, ihinanajaro −quinade. ");
INSERT INTO cul_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Naraha Jesopa: —Jari, tahide ohuatti tecomeramanaji. ¿Nejecotohui tiadenipi Diocca dosseniji nahatoqquiri tiquinaraha najaro dosseniji tecahuamananissa tejerajaro? Aji ticcadeni ididenicca marinajadsana disseraqquiri tiquinadsapi Diocca dosseniji ponima tinanamanajaro. ");
INSERT INTO cul_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ajina, Diocca dossenijipi: “Ticcadeni abidsa, ticcadeni amidsa tetideni huanaqquiri nana. Pohuadenitohui tetideni huanaqquiri nadsa attidenidsa iboraqquiri tiquinana” napohui nade. Pohua atti naqui: “Madijapa imehidsa, imenidsa imasiri inanadsapi manaco najaripa dsoqquehitohui” napohui nade Dio Atti, Moisesijine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Naraha tettidenipi: “Madija imehidsa, imenidsa pohua attipa: ‘Jaho, tiadeni acco ocamabaqquinijineraha ocajijaro huapimapa Diodsa da onahijine onapodsapi tiadeni acco ocamabaqquinijine opajira-jerani’ nadsa pocca abi, pocca ami acco icamabaqqui-jaradsapa bica tani” tiquinaraha. ");
INSERT INTO cul_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ticcadeni madijacca marinajadsana “bica tani” titiquina nadsapi tijinedeni Diocca dosseniji huahuattajo tinanamanajaro. ");
INSERT INTO cul_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jaho, tiadenipi maidsehe ticajimanani. Maittaccadsama Diojine Pohua Atti cacomerabote Isahiapa ticcadeni imassa nehe dsodo inapojaro. Jidapanana najarossa najarodsa timadimanajaro. Ajana, maittaccadsama Diojine Isahiapa: ");
INSERT INTO cul_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ajajarideni madijapa ohuadsa: ‘Dio, tiapi bica tinani’ quiquinanaraha pohuadeni bodidenidsa otohui quina-jarahi. ");
INSERT INTO cul_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pohuama ohuadsa jiri jiri quiquinanajari. Pohuadeni maride naco: ‘Dio Atti mari mari inajaro’ quiquinanaraha madijacca marinajara mari mari nanaridsamana najari” napohui nade Dio Atti −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Dsotodepa Jeso madija pohuahuaji jahijonahijine tohuideni huahua najari. Pohuahuaji bacco najonamanadsa Jesopa: —Jari, ohuatti titaharibobo canaji timittamananissa tanijine −nade. ");
INSERT INTO cul_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","—Tiadenidsapi jijipa oppina tahicca caji tahi. Madija nama nahicca jipadsapa tettidenipi: “Diodsa bica tejerani, Moisesicca marinajadsa naqui oppina tani” titiquina najaro. Naraha ohuattipi ajima najaro: Huapima itaparipa dappi inadsa ibodidsa tojadsapa imasiri toja-jerani. Naraha ebenodsa huati huati ihinanajarojinena madijadsa imasiri ihinanamana najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nadsapi ia pocca dodosse tabaqqui iquejenajaropi madija atti atti quinahi imittadsa manaco Jesodsa huati inajarode: —Nija, jidacca huati tinajarocca ima pariseodeni mittamanadsapa tettidsa nacasseraqquiri nahi ¿nahato tinaqui? −inade. ");
INSERT INTO cul_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Naraha Jeso attia: —¡Epeje! ¡Nama dsanapomanahitohui! Madija occa Abi Dio memehuaji madijaridsa toquejenajaridenipa pina pocca huidsajacca ppa nahissa quinajari. Naraha aja pariseodenipa pina pohuama moro toquinajarissa quinajari. Nadsama huidsaja jinedepa pohuama moro tahicca jaboma dsoppa inadsa ajacca hua inajari. Dio naco najaro imassa inananitohui. Pohuadsa toquejena-jarajarideni aji jororoni jiquejeranihuaji hua idsimabaqquihitohui. Ajana, pohuadeni attipa: “Dio Atti maride iquejenajaropi pina noccodeni siri jahinedeni dsopi icanabaqquijarissa inajaro” quinaraha pohuadeni huapima naco pina noccodeni sirissa quinajari. Pohuama noccodeni siri ohuahadeni jahinedeni dsopide toquejenajari. Nadsama nocco siri pamahapa pohua tesse jahine dsopide tojaridsadsapa odi tohuajarodsa pohuadeni pamahapa tocatojedsimera tahi. Aja pariseodenipa pina najaro imassa inanamanajaro. Paji, pohuadenidsa tiquejemamana tejeraji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nadsa Pedropa Jesodsa huati tajari: —Ia Maride, ticca marinaja aji “Huapima itapari dappi inadsa ibodidsa tojadsapa imasiri toja-jerani” tajaropi ¿nejecoma najaro? −nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Nadsapa Jeso attia: —¿Tiadeni naqui occa marinaja timittamana-jerajaroqui? ");
INSERT INTO cul_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Timittamananissa tanijinepi tiadeni mari ocanabaqquipomana. Aja ejeridsa toqquedsimajari itapari. Itaparipa idsonedsa totoqquedsima najari. Dsotode miji inadsapa toqqueqquimajari. ");
INSERT INTO cul_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Naraha ejeridsa qquenajaropi etti. Ettipi ibodi huatodsa ebenojine huati huati inajaro. Najaro huati huati inajarojinena imasiri totoja najaro. ");
INSERT INTO cul_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ajina, tabaccorehe huapimapi madija pohua bodidsa ahuatomadsa pohua todossenidsapa imasiri inanajaro. Najaropi pina madija imasiritohui pohua bodi huatojari, madija inanadsoqquehijine tohuini najari, madija amoneje cajiraha amoneje onihi ajade tohuini najari, amoneje maqqui cajiraha maqquideje ohuaha najade tohuini najaro, maqquideje tabiraraha amoneje ajade tohuini najari, amoneje tabiraraha maqquideje najade tohuini najaro, najaro ima madija pohua bodidsa ahuatomadsapi imasiri toja tani. Tabaccorehe onihi naqui pina botie tohuini najari, maidsehe huati tahijine tohuini najari, madija tatamasso nahijine tohuini najari. ");
INSERT INTO cul_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Najaro tabaccorehe huapimajinepi madija pohua bodi totabaccorajari. Najarojinena madija imasiri ihinanamana najaro. Naraha idsepe ssahuarani ijipadsapi ibodidsa imasiri toja-jerani. Aja jodiodeni marinaja pariseodsa jehe quinajarideni, jodiodenicca marinaja maridedeni tedseje attidenipa: “Ia ehuerani icca ima Diodsa tohuirenijinepi huajijiradsa idsepe ssahua ssahua inadsa tohuirenijine” quiquinanaraha ibodidsa imasiri ecahuadsapi idsepera ssahua inaraha imapi tohuirenijine ssamo tani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nadsapa nahihuaji mari icanabaqquia jicadsapa Jeso toccajari. Odsa panani pamehe Tiro, Sidohuaji toccajari. ");
INSERT INTO cul_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nanihuajicca amonejepi Canahacca madija, jodio jerani. Najaro amoneje bacco ijidsade. Jeso qqui tadsapi huahua huahua najaro: —¡Ohua Medsede, tiapi maittaccadsamacca tamine Dabi Potemahi tijajaro! ¡Otohui teti huana taji! −nade, johua johua nadsa. —Occa ejedeni tocorime cajijaro. Najarijine ponipi ocasserani ahuadsanapojaro −nade. ");
INSERT INTO cul_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Naraha Jeso ponidsa huati tajarajari, joma najari. Nadsapi ia pocca dodosse tabaqquia pohuadsa huati inajaro: —Apaja, ponidsa: “¡Ticcaniji!” taji, inajaro. Aji inattihuaji huahua huahua namissajonajaro tocasserani nani −inade. ");
INSERT INTO cul_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nadsapa Jeso attia: —Occa Abi Dio ohua dosse naronajaripa Isaraeri potemahi jodiodenidsara ohua dosse naronajaride. Najaridenipa pina edede jano toquejenajarissa quinajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Naraha ponipi dissera tadsapi joppa namissajaro, tossoniqquima, Jeso pohua baccohuaji poni pitonidsa huittajaro. Poni attinipi: —¡Ohua Medsede, ohua acco ticamaji! −nade. ");
INSERT INTO cul_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nadsapa Jeso ponidsa huati tajari: —Madija ohuaha jodio quejena-jarajari tahide acco ocamabaqquipohuijinepa bica tejerani. Najaro imapi pina madija pocca ejedenidenidsa dsamatapa da inaraha idinidsa pocca ettedsana da inajarissa najaro. Naraha Diocca madija jodiodenina tahide acco ocamabaqquipohuijine bica tani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nadsa Jeso attidsa ponipi: —Pajissa, ohua Medsede, naraha ettepa pohua jinedecca huahuanaridsa dsamatapa tabotto catojadsapa pohua naco jipajari. Jodio ojajeraraha ohuadsa ticca acco camehe badsira tehe tinanaji, onajaro −nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Attini nema nadsapi ponidsa Jesopa: —Jehe, amoneje, tiapi ohuadsa jehe tanissa tajaro. Ohuadsa tibodipi: “Jehe, Jesopa occa ejedeni inanomihijine pajirahi” tadsapi ticca huatinaja tiadsa onanana, onajaro −nanaja nadsapa ponicca odsahuaji bedeni tonomijaro. ");
INSERT INTO cul_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jehe, Jeso toccanidsapa Carireacca coridsahuaji toqquedsippanipomajari. Coridsa poni huapi toccabacossajari, ssonohuaji toqquemoradsapa nahi ssonodsa huittajari. ");
INSERT INTO cul_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nadsapa madija huapima Jesotohui ssonohuaji jahimorajari. Jesodsa bacco nimoramanajaridenidsapa isso siri quejemamana, nocco siri quejemamana, biji siri quejemamana, ebeno siri quejemamana najari. Comaqquiri najari huapi taha quejemamanajari. Nadsapa Jesohuaji comaqquiri najarideni pohuadeni tesse eccajonabaqqui-manadsapa pohua baccohuaji ettaridsamanadsa inanomibaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Inanomibaqquidsapa madija nahidsa queriqquimanajarideni qqui toquinadsa jabojo quinajari. Aja ebeno siriraha atti nimanipomajari. Biji ttomoraha biji cajimanimanapomajari. Isso siriraha issodeni biquemaniridsa-manadsapa jahiridsapomajari. Noccodeni siri naco noccodeni biquemanimanajari. Nadsapa madija attidenipa: —¡A, Isaraeri potemahi jodiodenicca Diopa bica tahi, deni tojahi! −quinajari, huapima Diodsa huatidsemanadsa. ");
INSERT INTO cul_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nadsapi ia pocca dodosse tabaqqui iquejenajaro Jeso itohui huahua napomadsapa iadsa huati tajari: —Madija huapimatohui ohuati cahanariri canani. Huada 3 nehe ohuadsa jahiridsadsapa pohuadeni tapari jicajari. Nema nanipi pohuadenidsa: “Jai tijaniji” onanijine jipera onajaro. Pohuadenipa pemi huatiacossaja camarana −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Naraha pocca dodosse tabaqqui iquejenajaro ettipi: —Naraha iapi madija madide nohuerahihuaji iqueriqquidsapi ¿nejecohuaji madija huapima jipamanahijine dsamatapa mitta inapadsaja? −inajarode. ");
INSERT INTO cul_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Naraha iadsa Jesopa: —¿Nejecoma naha pan ticajimanani? −nade. Nadsapi ettia: —Pan 7 naha icaji, aba bedi pamaha icaji nani −inade. ");
INSERT INTO cul_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nadsapa madija huapimadsa Jeso huati tajari: —Jari, jassi tinaridsaji −najari. ");
INSERT INTO cul_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nadsapa pan 7 naha pohua dsepedsa inacca, aba pamaha idsaba nadsa Jesopa Diodsa huati tajari: —Jehe Abi Dio, epejeni, ticca daniji iadsa bica tahi −nadsapa pan icanabobiridsajari. Icanabobiridsadsapa pocca dodosse tabaqquideni iadsa da inabaqquijari. Iana madija huapimadsa da inabaqquiridsajaride. ");
INSERT INTO cul_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nadsapa Jeso canahatori canajarijine pan, aba najari tohuapidsa madija huapima jipamanadsapa accararidsa-manajari. Jipamanahissa taraha mota tojajari. Pan bobi, aba ime mota iana inaccaniridsadsapa quiqui 7 naraha ijiridsade. ");
INSERT INTO cul_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Aja jipamanajaridenipa maqquideje 4 mil quinajari. Denima poccadeni amoneje, poccadeni ejedenideni naco jipamanajari. ");
INSERT INTO cul_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Dsotode madija huapimadsa Jeso attipa: —Jehe, jidapanana jai tijaninissa tana −najari. Nadsapa Jeso canoadsa toqquedsanipomajari. Coridsa jippehuaji jaijadsapi dsama Macadaohuaji bacco inajaro. ");
INSERT INTO cul_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jesopa dsama Macadaodsa bacco tadsa nahicca Isaraeri potemahi jodiodeni mota marinaja onini pariseodsa jehe quinajarideni, marinaja onini sadoseodsa jehe quinajarideni tedseje pohua qquide jahijonajari. Pohuadeni bodipa: —Jeso nattome inana, pocca ima tossamonijine −quinadsapa Jesodsa huati toquinajari: —Jeso, pajissa Diocca dacorehe ticajidsapi memehuajicca nahatohue bicabote ahuato tinanaji. Qqui inana −quinade. ");
INSERT INTO cul_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Naraha pohuadenidsa Jeso attipa: —Tiadenipi maji tocca-cca nadsa memehuaji maccohua ssire-re nani qqui tiquinadsapi: “A, dsemassapi meme bica tanitohui” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aji dsidsidsamassa naqui memehuaji maccohua diji tadsa tettidenipi: “Jidapapi jojode, passo caji tani” titiquina najaro. Meme qquide nahatoqquiri tiquinaraha aji jidapanacca ima dsati tojajaropi qquide ssamoqquiri tiquinani. Diojine ajijaro dsamadsa Cristo-Mesia dsepe ijiridsahi tiadenidsa ahuato taraha tiadenipi ticahattera-jerajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","—Jidapana timadimanajarodeni tabaccoraqquiri tiquinehe timadimanajaro. Tahidepi tettideni: “Diocca iquejenani” tiquinaraha dsotodepi Pohua Atti tinebomanajaro. Tiadenipi ocanahatoriri cananijine tohuira huati tiquinaraha occa nahatohue onahatona onejerani. Naraha ocanahatoriri cananicca ima ojariena qqui tiquinanitohui. Najaropi Jonasocca imassa najaro −nade Jeso. (Aja pohua atti nama najaripa Jonaso pina huatiajarissa naraha Diojine tossiajadsa madipomajari.) Nadsapa nahihuajicca madija inebobaqquidsa Jeso toccapomajari. ");
INSERT INTO cul_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nadsapi Jeso pocca dodosse tabaqquideni ia huapimapi coridsa jippehuaji jaijaraha ijipanijine itapari eti ajimadsapi dsojo inajarade. ");
INSERT INTO cul_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nadsama nahi canoadsa jassi idsadsa Jeso iadsa huati tajaride: —Tetideni huatoji. Marinaja onini pariseo, marinaja onihi onini sadoseo naqui pina pan ssaja tahijine quequejema tahimarissa najaro. Paji, najaro tiadenidsa toja-jeranijine tiadenipi dacoco tijiraji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pohua atti nama nadsapa iara ojidsa huati icanirere canade: —¿Nejecotohui pohua atti nama najari? Aji ijipanijine pan icappirajarocca huati tajarirana −inade. ");
INSERT INTO cul_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Naraha Jesopa ibodi nahato tadsa huati tajari: —Jaho, ticcadeni jehenijipi badsira tani. ¿Nejecotohui ohuadsa: “Jehe, Jesopa ia tonajipabaqquihijine pajirahi” tiquinejerani? ¿Nejecotohui pan ticappiramananicca imadsara imahaha ticanajaro? ");
INSERT INTO cul_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Nejecoma nadsa ticahatteranijine? Tibodideni huatomaji. Madija 5 mil quinaraha pan 5 naha dside onariridsadsa jiparidsamanajaride. Mota tojadsapa quiqui ijiridsahi qqui tiquinaraha ¿tetideni ajimajaroqui? ");
INSERT INTO cul_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aja madija 4 mil quinaraha pan 7 naha dside onariridsadsa jiparidsamana-pomajaride. Motapa quiqui ijiridsahi qqui tiquinapomaraha ¿tetideni ajimajaroqui? ");
INSERT INTO cul_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Nejecotohui occa marinajadsa tibodideni huatoma-jerajaro? Pancca ima huati onejerapa. Aji pariseo, sadoseo najaro marinajassa tinanamana-jeranijine dacoco tijiraji, onajaro. Najaro marinaja pamehepi tojaribaqqui tani. Pina pan ssaja tahijine quequejema tahimarissa najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nadsana ibodi huatomajaro. Jesopa pan ijipanijinecca quequejema tahimaridsa ia mari tocanabaqquijaripa marinaja pariseo, marinaja sadoseo iadsa toja-jeranijine huati huati tajari inade. ");
INSERT INTO cul_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Dsotode Jeso, pohua huatimadedeni ia inadsa odsa panani Sesarea de Piripohuaji jaijajaro. Jahui jaijadsa Jeso iadsa huati tajari: —Madijapa ohua Madija Bedi otahimari huati huati nanaridsamana nadsapa ohuadsa attideni ¿nejecoma nejecoma quiquinanajari? −nade Jeso iadsa. ");
INSERT INTO cul_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Naraha ettipi: —Tiadsa madija motapa: “Huano Baotista tijani” quiquinanajari. Ohuahadenipa: “Maittaccadsamacca Dio Atti cacomerabote Eria tijani” quiquinanajari. Ohuahadeni naco: “Maittaccadsamacca Dio Atti cacomerabote Jeremia tijani” quiquinanajari. Madija ohuaha attideni naco: “Maittaccadsamacca Dio Atti cacomerabote ohuaha tijani” quiquinanajari −inade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nadsapa Jeso iadsa huati tajari: —Naraha tiadenidsapi ¿nejecojari ojani? −nade. ");
INSERT INTO cul_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Naraha manaco Pedro huati tajari: —Tiapi Cristo-Mesia tijani. Dio camitta tajari Bedi tijani −nade. ");
INSERT INTO cul_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nadsapa Pedrodsa Jeso attipa: —Jehe Ssino, tiapi Huanocca ejedeni tijajaro. Diopa tiadsa ima bicani inanajaro. Aji otahimari nahato tinajaropi madijajine jerani. Occa Abi memehuaji madijarina otahimari Cristo-Mesia ojani tiadsa ahuato inanajaro. ");
INSERT INTO cul_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Jidapapi tia onipi “Pedro” onajaro. (Ettidsapi: Siba, inajaro.) Tiapi otahimari mari ticanabaqquidsapa ohuadsa pajissa quinajarideni tohuapiridsahitohui. Nadsapi otahimaridsa quequeriqquimana nahijinecca tojaridsanijine. Najaro otahimaridsa quequeriqquimana nahiccapi dacorajaro, pina sibassa najaro. Amossi nanijine ssamo tajaro. Dsoqquehecca dacorehe naqui otahimaridsa quequeriqquimana nahicca inajicanijine pajira-jerajaro. ");
INSERT INTO cul_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Pedro, occa dacorehe tiadsa onananitohui, tetti dacoranijine. Najaropi pina Diocca cacahuehecca noccobijicca pipico tiadsa da onajarissa nahitohui. Madija otahimari mari ticanabaqquidsa pajissa quinadsapa Diocca cacahuehedsa toquejenahitohui. Pina Diocca cacahuehecca noccobiji pohuadenidsa ticanahabajarossa nanitohui. Tetti dacorajarojine naqui ajijaro namicca imadsa: “Jehe, bica tani” tadsapi Dio memehuaji madijari naco: “Jehe, bica tani” nahitohui. Naraha ima onihidsa: “Najaropi poni, bica tejerani” tadsapi Dio memehuaji madijari naco: “Poni, bica tejerani” nahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nadsapa pohua huatimade iadsa Jeso pohua attipa: —Ohuapi Cristo-Mesia ojani madija ohuahadenidsa tecomamanaccana −nade. ");
INSERT INTO cul_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dsotode Jeso pocca dodosse tabaqqui ia mari tocanabaqquidsapa ajama najaride: —Occa Abicca dossenijidsa odsa panani Jerosarehuaji occanitohui. Nanidsa jodiodeni ime jocohuideni, dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajaridenijine najidsohue imeni ocasserani onahananitohui. Nadsapi ohua inanadsoqque-mananitohui. Naraha ohua ppa idsamanaraha huada huatinimade tojari nadsapi Abi Dio ohua nahatonihitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Naraha Pedroa Jeso iacca-cca nadsa huati tajari: —Jidacca ima huati tinajaro ticca ima nema najaro imapi huati tina tejeraji. Diopa tidsoqquenijine jipera tahi. Dio tia cacahuahi −nahi nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Naraha Jeso tahide huajanidsa Pedrodsa huati tajari: —¡Paji, otedsejemapi! Ohua teccocco tejeraji, onajaro. Tettipi pina maidsehe jinede Satana attissa nani. Diocca dossenijidsa ibora onanijineraha tettidsara ibora onadsapi Dio jipa tahicca onana-jeranitohui. Tiapi Dio jipa tahicca ssamo tinani. Madija tohuini quinajariccana nahato tinajaro −nahi nade Jeso Pedrodsa. ");
INSERT INTO cul_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nadsapa Jeso pohua huatimade iadsa denima huati huati tajari: —Aji “Jesocca madija iquejenana” tiquinadsapi tiadeni tohuini tiquinanicca tohui tetideni ajimamanaji. Ohuadsara disseraqquiri tiquinaji. Madija tiadenidsa: “Ahua porimacossanidsa tidsoqqueji” quinadsa naco: “Jehe, odsoqqueni bica tani. Jeso onebo-jarahi” titidsanapomana nana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tiadenipi ticcadeni madie ohuadsa teccoramanadsapi madija tiadeni tonajicabaqqui-manaraha camittehe jiquejeranicca ticajimana-dsanaponitohui. Naraha madija ohuahapa pocca madie ohuadsa eccoccodsapi, pina ajijaro namidsa madi-dsanapohuijine tohuinira nadsapa najaripa dsoqquehitohui. Dsoqquedsapa camittehe jiquejeranicca caji-jarahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","—Madija naco ajijaro namicca biquehe tohuini madidsa, ajijaro dsamacca ima deni tojanicca tohuini madidsa naco huapima pohuadsa tojaraha Diotohui najaradsapa nidsa pohua dsoqquedsa jororoni jiquejeranicca dsori tajarahitohui. Nadsapa pohua cajijaricca huapima ponima tojanitohui. Pohuapa pohua cajijariccadsa camittehe jiquejeranicca mitta inanijine ssamo tani. ");
INSERT INTO cul_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Naraha ohuapi Madija Bedi ojajaroa nidsaranibote Abi Dio ssiejenema pocca dodosse tabaqqui memehuajicca tedseje occaronapomanitohui. Nadsapa madija madihissa tajari pocca madie tonanabicadsa Diodsa dsepe ijijaripa nidsa pohuadsa denima bica tanicca da onanitohui. Madija ohuadsa dissera tajarajari Diodsa badsira tehe dsepe ijijaripa bica tanicca badsira tehe pohuadsa da onanitohui. Naraha madija ima bica tajarodsa dsepe ijijaradsapa occa daniji cappirahitohui. Madija ima tabaccora tajarodsa dsepe ijijaripa occa najidsohue cajihitohui. ");
INSERT INTO cul_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ohuapi pajissara tiadenidsa huati onajaro: Ajidsa tidomodeni huajaro motadenipi tidsoqquemana-jeraccadsama ajijaro titedsejemadenicca ima qqui tiquinanitohui. Najaroa aji ohua Madija Bedi ojajaroa nidsaranibote madija ohuacahuabaqquihijine occa deni tojehema occaronapomanitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jeso pohua tedsejemacca ima huati tahi nattini huada 6 nadsa ssonohuaji Jeso toqquemoradsapa Pedro, Satiaco, Huano quinajaridenira iaqquemorabaqquijari. Jai tojemoradsapa ssono tetepihuaji bacco tomoramanajari. ");
INSERT INTO cul_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nahidsa qqui toquinanaja Jeso pano todsibehijaro pina maji ssiejenessa najari. Pocca etero naqui tonopojaro pina ssiaja tajarossa najaro. ");
INSERT INTO cul_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nadsapa qqui toquinanaja Eria, Moisesi tedseje Jesodsa ahuatoma-manadsa imahaha canajari. (Pohuadenipa maittaccadsamacca Dio Atti cacomeraqquiri najarideni.) ");
INSERT INTO cul_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nadsapa Pedro Jesodsa huati tajari: —Ohua Medsede, iapi ajidsa iquejenadsa bica tani. Ticcadeni odsa huahuaqquide 3 canehe inahatona. Nadsapi tiadsa, Moisesidsa, Eriadsa cananijine −nahi nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro huati huati nanaja pohuadeni tetepihuaji esseni dsibehi tajaro ccaronajaro. Ccaronadsapi pohuadenidsa ijihuajanijaro. Nadsapa nahi esseni bodidsa atti qquenajaro: —Ajajaripa occa Ejedeni. Pohuadsa ohuati huana tajaro. Pocca ima bica tajarojine ohuatidsejaro. Pohua atti timittamananissa taji −nahi nade Dio. ");
INSERT INTO cul_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nadsapa Pedrodeni atti mohuini mittamanadsa cappinamanadsapa pohuadeni baccohuaji domodeni pona najari. ");
INSERT INTO cul_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nadsapa Jeso pohuadenihuaji ccanijari. Bara inabaqquidsa pohua attipa: —Titehemamanaji, ticappinamana tejeraji −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nadsapa totehemamanadsa qqui toquinanaja Jesodsa madija ohuahapa nohuerajari. Pohua motta hua canajari. ");
INSERT INTO cul_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nadsapa ssonohuaji jahidsippanidsa Jeso pohuadenidsa huati tajari: —Aji ssono tetepidsa qqui tiquinajarocca imapi tecomamanaccana. Ohuapi Madija Bedi ojajaroa nidsa odsoqqueni nattini onahatonidsana najaro ima tecomeramananijine bica tani −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nadsapa Jesodsa huati toquinajari: —¿Nejecotohui jodiodenicca marinaja maridedeni attipa: “Cristo-Mesia ccajona-jaraccadsama Dio Atti cacomerabote Eriana tahide ccanipohuitohui” quiquinanajari? −quinahi nade pohua huatimade 3 quinajarideni. ");
INSERT INTO cul_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nama quinadsapa Jesoa: —Pajissa, tahidepa Eria ccanipohuitohui, ima huapima icattemaridsaponijine. ");
INSERT INTO cul_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Naraha ohuattipi: Eriapa ccanipode, onajaro. Aja Eria dsoqquejari ccanipo-jararaha madija ohuaha pina pohuassa najari ccajonadsa ima icattemaridsapode. Naraha pohuadsa noccodeni jidsaqquiri nadsa nacasserehe pohuadsa inanamanade. Najarossa najaro nidsa ohua Madija Bedi ojajaroa ohuadsa naco nama quinadsapa ocasserani onahananitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pohua atti nama nadsapa pohua huatimadedeni bodideni huatoma-manajari: —Ja... Jehe, Eria tahimariraha imapi Huano Baotistana paja. Pohuana madijacca ima cattemade ccaridsapode −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nadsapa Jeso, pohua huatimade 3 quinajarideni tedseje jahidsippanidsapa madija toqueriqquihihuaji bacco nanimanajari. Nahidsa madija ojaria Jesodsa huati tahijine ccajonajari. Jesohuaji bacco najonadsapa pohua bodi: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta tocattedsa najari. Nadsapa Jesodsa huati tajari. ");
INSERT INTO cul_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Pohua attipa: —Ohua Medsede, occa ejedenidsa teti huana taji. Huatiajojo comani cajijari. Ocasserani imeni inahanajaro. Najaro comani quidsa nadsapa pitora pitora naridsajari. Dsippodsa naco ssonidsanaja naridsapohui nanaja najari. Passodsa naco je taja naridsapohui nanaja najari −nade. ");
INSERT INTO cul_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","—Nadsama ticca dodosse tabaqquidenidsa occa ejedeni ohuaccajonajari naraha inanomimanahijine ssamoqquiri napa −nade imehi atti. ");
INSERT INTO cul_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nadsapa Jesoa: —Jaho, madija huapima Diodsa jehe tiquinanissa tejerani. Ajijaro namicca ima bica tejeranicca ticajimaneje najaro. Tiadeni mari mari ohocanabaqqui naraha ¿nejecoma nadsa ticahatterapadseje? Ticcadeni jeheniji pajiranissa tejeradsapi ohuadsa ocassera taraha ¿nema nehe onahana-dsanaponijinequi? ¡Jari, ticca ejedeni ohuadsa teccajonajo! −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nama nadsapa Jesohuaji ejedeni coma tajari eccajonamanajari. Nadsapa Jeso ejedeni bodicca dosse ininehijine huati tajari: —¡Tocorime tabaccorabote! ¡Ejedeni tinebodsa tiqquenaji, onajaro! −nade. Nadsapa qquenadsa amadsati ejedeni coma tajaripa tonomijari. ");
INSERT INTO cul_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nadsapi dsotode ia pocca dodosse tabaqqui ia motta Jesodsa huati inade: —¿Nejecotohui iaha ajajari ejedeni bodicca dosse ininehijine ipajira-jerapa? −inajarode. ");
INSERT INTO cul_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Naraha Jeso pohua attipa: —Tipajiramana-jerajaropi tibodideni Diodsa jehe tiquinanissa tejerajaro. Pajissara tiadenidsa huati onajaro: Ticcadeni jeheniji badsira tehe pina mostaza nocco badsira tajarissa nehe ticajimanadsapi ssamo tanicca tinanamananijine tipajiramananitohui. Pina ajaro ssonodsa huati tiquinadsa: “Ajiccahuaji ticcaji” tiquinadsapi tettidenidsa ssono poni ehuerani toccanitohui, onajaro. Nadsama ticcadeni jeheniji dacoradsapi tiadenidsa ima ssamo tanicca nohueranitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nani dsama arobeni Carireahuaji Jeso tedseje jaijaridsadsa iadsa Jeso huati tajaride: —Aji ohua Madija Bedi ojajaropi nidsa dsotode madija ojaria ohua ccaccoradsapa madija dsepedenidsa ojanitohui. ");
INSERT INTO cul_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nadsapi ohua inanadsoqque-mananitohui. Ohua ppa idsamanaraha huada huatinimade tojari nadsapi Abi Dio ohua nahatonihitohui −nade Jeso. Najaro ima huati tadsapa ibodi qquedsa nade. ");
INSERT INTO cul_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nani odsa panani Capernaohuaji bacco inanidsapi iahuaji dsiniro nanaccadedeni bacco quinajari. Pohuadenipa madijacca dsiniro mota ihinaccamana najaro, Diodsa dada toqquimacca odsa ecahuamananijine. Nadsapa Pedrodsa huati toquinajari: —¿Nija? Tiadeni maridepa pocca dsiniro mota Diodsa dada toqquimacca odsa cacahuanijine ¿da da nattaco? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Naraha Pedropa: —Jehe, da da nahi pohuapa −nahi nade. Dsotode Pedro odsahuaji qquedsimanidsapa Jeso dsinirocca ima Pedrodsa huati tojidsapojari: —¿Nija Ssino, nejecoma tani tibodi? Ajijaro namicca taminedeni ¿poccadeni madijacca dsiniro mota ihinaccamana najaroqui? ¿Madija ohuahadeni poccadeni dsamadsa madimanajaricca dsiniro motana ihinaccamana najarorane? −nade. ");
INSERT INTO cul_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nadsapa Pedro ecomerajaro: —Dsama onihicca, dsama onihicca jahijonajaridenicca dsiniro motana ihinaccamana najaro −nade. Nadsapa Jeso atti: —Nama nadsapa tamine pocca dsamacca madija paca paca quiquinana-jarahi. ");
INSERT INTO cul_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Naraha iapi dsama onihicca madija iquejena-jeraraha Diodsa dada toqquimacca dsiniro nanaccadedenidsa ima ocassera tejeranijine pohuadenidsa dsiniro da inana. Jari, aba corode coridsahuaji tiqquedsippaji. Tahidecca huana tapojari ajaridsa qqui tana. Nanidsapi dsiniro qqui tinanitohui. Najaro dsiniro tididsa dsiniro nanaccadedenidsa da tinadsapi occa, ticca naqui pajiranissa tanitohui −nade Jeso. Nadsapa Pedro Jeso attissa inanajaro. ");
INSERT INTO cul_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nadsapi ia Jesocca dodosse tabaqqui Jeso pohuadsa huati inajarode. Ettipi: —Dio memehuaji madijaricca cacahuehedsapi ¿nejecojarina deni tojajari? −inajarode. ");
INSERT INTO cul_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Naraha Jesopa ejedenitohui huahua nade. Ejedeni ccajonadsapa idomo huahuajanini nocconidsa ejedeni inahua najari. ");
INSERT INTO cul_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nadsapa Jeso huati tajari: —Pajissara tiadenidsa huati onana: Tibodi pina ejedeni bodissa nanijine tecajiqquimera-jeradsapi Diocca cacahuehedsa tija-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Diocca cacahuehedsa madija denima bica tajaripa: “Deni ojani” najarajari. Pohuapa pina ajajari ejedenissa najari. Pohua bodipa: “Ohuapi ajimani ojani, Diodsara ibora onani” nanaja najarina deni tojajari Diodsa. ");
INSERT INTO cul_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ajajari ejedenissa najaridsa tetideni huanaqquiri nadsapi ohuadsa naqui tetideni huanaqquiri najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesopa denima huati huati tajari: —Nadsama madijapa pohuajine ohuadsa jehe quinajarideni imasiri inanamanadsapi pohuadsa najidsohue oppina tanicca ssonarinitohui. Ejedeni ohuadsa jehe quinajarideni naco madija imasiri mamaridejine imasiri tocahatteradsapa aja imasiri mamaride pohuadsa najidsohue oppina tanicca ssonarinitohui. Pina ajijaro imassa najaro: Siba ccanajabote pohua mattodsa ssoque dsanadsa passo imeni dsaja tanihuaji je tahijine cco todsippadsapa oppina taraha najidsohue denima oppina tanicca pohuadsa ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jaho, ajijaro namicca imasiripi jiquejerani. Aji namidsa timadimanajaropi ima tinanamananijine caji tani. Paji, nema najarodsa imasiri tinanamana tani. Naraha madijajine imasiri tinanamanadsapi pohuadsa ima denima oppina tanicca ssonarinitohui. Madija nama najaripa manaco Diona inajidsohuitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Nadsama imasiri tinana-jeranijinepi tibodi daco tijiradsa poni taji. Pina tidsepedsa imasiri tinanabote naraha daco tijiradsa poni taji. Nema tadsapi pina tidsepe ca ticajidsajarossa najaro. Tidsepe cajarie amossi canaraha Diocca cacahuehedsa timadidsapi tetidsenitohui. Naraha imasiridsa dissera tinadsapi pina tidsepe capamehe ticajijarossa naraha jororoni jiquejeranihuaji tia coro todsimahitohui. —Nadsama imasiri caji tanihuaji ticcanijine naqui tohuini taraha poni taji. Nema tadsapi pina temori ca ticajidsajarossa najaro. Temori cajariraha Diocca cacahuehedsa timadidsapi tetidsenitohui. Naraha imasiridsa dissera tinadsapi pina temori capamehe ticajijarossa naraha jororoni jiquejeranihuaji tia coro todsimahitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","—Nadsama tinoccodsa naqui tohuini tanicca qqui tinadsa imasiri tinananijine tohuini taraha daco tijiradsa poni taji. Nema tadsapi pina tinocco huari, joca, jeo, coro tinajarossa najaro. Tinocco ojariraha Diocca cacahuehedsa timadidsapi tetidsenitohui. Naraha imasiridsa dissera tinadsapi pina tinocco pamehe ticajijarossa naraha jororoni jiquejeranihuaji tia coro todsimahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","—Tibodideni tettidenima tiadeni tecahuamananissa taji. Madija ohuadsa pajissa najaridsa tettidenipi: “¡Ssamo tinani!” tiquina tejeraji. Occa madija ajamani tinanabaqquimana tajarajo, onajaro. Occa Abi Dio memehuaji madihidsapa pocca dodosse tabaqqui occa madija cacahuade madimanajari. Najaridenipa Abi Dio Pohua pano naco qqui qqui dsanapomanajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nadsapa Jeso ia mari tocanabaqquijari: —Ajijaro ima tibodidenidsa ¿nejecoma tiquinani? Jari, tiadenipi ticcadeni edede 100 naha ticajimanadsapa onideni hua tiquinadsa ojaria amossi nadsapa ¿pohuatohui qquide jai tija-jeraqui? Jehe, edede jinedepa pocca edede qquide toccahitohui. Pocca edede 100 naha cajiraha ojaria amossi nadsapa 99 tojajari. Pocca edede 99 naha huamonihuaji inebobaqquidsapa ojaria amossi najari qquide toccahitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pocca edede bacco inanidsapa huatidsehitohui. Pocca edede 99 naha amossihuaja-jaradsa naco huatidse tahi. Pajissara tiadenidsa huati onajaro: Edede jinedepa pocca edede amossi najari bacco inanidsapa denima huatidse tahi. ");
INSERT INTO cul_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Najarossa najaroa ticcadeni Abi Dio memehuaji madijaria pocca madija ojaria pocca cacahuehedsa amossi nahijinepa jipera tajari. Madijapa Dio Pohuadsa tohuajiraha pohuadsa tojanipomahijine jipa tajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesopa denima huati huati tajari: —Madija ohuadsa jehe najari timecote tojaraha tiadsa imasiri inanadsapi pohua ojari nadsa mohuaradsa huati ticanana: “Ohuadsa tijine bica tejerani” tana. Nadsapa pohua cacomeradsapa: “Jehe, pajissa tiadsa nema onanade. Ojine bica tejerani. Jidapapi nema onapoma-jeranitohui” nadsapa manaco pohuadsa: “Jehe, epejena, bica tani” tana. Nadsapa timecote tedseje ticatidserapomanijine. ");
INSERT INTO cul_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Naraha timecotedsa mohuaradsa huati tinaraha mitta-jaradsapa timecote ohuaha pamaha tiaccabaqquina, pohuadeni tedseje pohuadsa huati tiquinanijine. Pohuadeni naco pocca ima mittamanahijine. Nadsapa madija pama itide, huatimade tojari nahitide nahatoto tadsapa bica tahi. Mohuaradsa imahaha ticanadsa pohua huati ticanamananaja mittadsapa: “Jehe, epejena” nadsapa timecote tedseje ticatidserapomanijine. ");
INSERT INTO cul_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Naraha najarideni atti mitta-jaradsapa otahimaridsa quequeriqquimana najarideni tedseje pohuadsa huati tiquinaji. Pohuadeni atti mittadsapa pocca ima tobicanitohui. Naraha otahimaridsa quequeriqquimana najarideni atti mitta-jaradsapa pina Diodsa jehe quina-jarajaridenissa nahijine. Imasiri cajijari. Pohuapa pina romanodenicca taminecca dosseniji dsiniro nanaccadedenissa najari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iadsa denima huati huati tajari: —Pajissara tiadenidsa huati onajaro. Ajijaro namicca imadsa: “Jehe, bica tani” tiquinadsapi Dio memehuaji madijari naco: “Jehe, bica tani” nahitohui. Naraha ima onihidsa: “Najaropi poni, bica tejerani” tiquinadsapi Dio memehuaji madijari naco: “Poni, bica tejerani” nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pajissara tiadenidsa huati onapomajaro. Ajijaro namidsa tipamehe Diodsa huati tiquinanijine jehe ticaniredsapi occa Abi memehuaji madijaripa ticcadeni huatinaja mittahitohui. Pohuapa ticcadeni huatinaja tiadenidsa inananitohui. ");
INSERT INTO cul_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jehe, ohuadsa jehe tiquinajarodenipi tipama nitide, denima tetimade ojaria itide otahimaridsa titiqueriqqui nadsapi nani tiqueriqquinidsa ohua naqui ohoquejema najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nadsapa Pedro Jesodsa tohuajiressidsa pohuadsa huati tajari: —Ohua Medsede, ohuemecotepa ohuadsa tabaccorehe inanajaro. Dsotode naqui ohuadsa imasiri inanajaro. Dsotode naqui ohuadsa tabaccorehe inanapomajaro. Nama dsanapojari. Naraha ohuapi: Pohuadsa ohuadi-jerani, onajaro. Dsotode naqui ohuadipoma-jerani. Dsotode naqui ohuadipoma-jerani. Nema onapomajaro. Nema onapomajaro. Naraha ¿nema odsanaponijinequi? onajaro. Aji pocca nacasserehe ohuadsa onihi, onihi, onihi 7 nehe bacco tadsapi ¿nadsana pohuadsa ohuadinijinequi? −nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Naraha Jesopa: —Paji, nema tejeraji. Nacasserehe onihi onihi onihi tassaqquini 70 denima 70 denima 70 dsanaporaha “Manaco” tejerana. Titessecca imadsa teti ajima dsanapona, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesopa ajijaro namidsa imadinicca ima tadsajani mari icanabaqquijari. Pohua attipa: —Jehe, Diocca cacahuehecca imapi pina tamine pohua biji accodedenicca cuenta icattemaridsanijinecca imassa najaro. ");
INSERT INTO cul_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Taminepa pohua biji accodedenicca cuenta icattemanijine huahua inabaqquijari. Jahijonajari, bacco najonamanadsapa tamine biji accode ojariana pocca cuenta deni tojadsapi najarina taminehuaji iaqquedsimamanajari. Najaripa dsiniro imeni pina 10 mil nehe debe najari. ");
INSERT INTO cul_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Naraha aja debe najari pocca cuenta paca nahijine cappiradsapa tamine pohua biji accodedeni icadossebaqquijari: “Jari, pocca cuenta paca nahijine pohua dsepetaji nemanehe dsinirotohui da tiquinaji. Nadsama pohua, pocca amoneje, pocca ejedeni naco manaconedenitohui da tinabaqquimanajo, madijacca dodosse tabaqqui toquejenahijine. Nadsapa najari manaconedenidsana pocca cuenta jicanijine pajirani” najari tamine atti. ");
INSERT INTO cul_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Naraha tamine biji accode dsiniro imeni debe najari pocca tamine atti mittadsapa nahi tamine baccohuaji pohua pitodsa huitta nadsa ojiema huati huati tajari: “Jaho, ohua medsede, nidsa ia da tinabaqqui-jeraccaji. Tia paca onanissa tanitohui, omaidsa-jerani” najari. ");
INSERT INTO cul_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nama nanaja taminepa pohuatohui huati tohuanahi nadsa: “Jehe epejeni. Bica tani” najari. “Jidapapi ticca cuenta oneboni. Epeje onani” najari. ");
INSERT INTO cul_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Nadsapa tamine biji accodepa toccaniraha pohua tesse pohuadsa debe najari bacco ijidsajari. Najaripa pohuadsa badsira tehe debe najari, pina dsiniro ccarara 100 najaro. Naraha tamine biji accodepa pohua tesse pohuadsa debe najari bacco ijidsadsapa pohuadsa debe najari acconi ssiporidsa dama niqui inadsa huadiema pohuadsa huati tajari: “¡Jari, ohuadsa ticca cuenta paca taji!” najari. ");
INSERT INTO cul_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Naraha pohua tessepa pohua pitodsa huitta nadsa ojiema huati huati tajari: “Jaho, otesse, nidsa tia paca onanitohui, omaidsa-jerani” najari. ");
INSERT INTO cul_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Naraha pohuadsa debe najari attidsa jehe najaradsapa: “¡Poni! Ohua paca tejerade. Nadsapi toponi cocorodsa tedsaji. Ticca cuenta paca tanissa tadsana tiqquenanijine” najari. Nadsapa coro idsimajari. ");
INSERT INTO cul_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Naraha tamine biji accode ohuahadeni pohua tesse inajidsohui qqui toquinadsapa nacasseraqquiri nadsa najaro ima poccadeni taminedsa huati tanimanajari. ");
INSERT INTO cul_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Nadsapa tamine aja pohua biji accode dsiniro imeni debe najari tohui huahua napomajari. Ccanidsa najaridsa tamine attipa: “Tiapi obiji accode tabaccorabote tijani. Ajina, tiapi dsiniro imeni ohua debe taporaha ohuadsa huati huati tinadsa ticca debe epeje onanajaro. ");
INSERT INTO cul_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Naraha tiapi titesse tiadsa debe najaricca debedsa epeje tejerajaro. Ohuapi tiadsa ohuati huana tade. Tia naqui pina ohuassa tadsapi titessecca debedsa epejena tanitohuiraha” najari pocca tamine. ");
INSERT INTO cul_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Nadsapa tamine huadidsa pohua biji accode inajidsomanahijine dosse inabaqquijari: “Ajaripa ohuadsa pocca cuenta paca najaradsapa tinajidsomana-dsanapojo” najari. “Pocca cuenta nemanehe paca nahissa tadsana toccanihijine, onajaro” najari tamine atti −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nadsapa Jeso denima mari icanabaqquijari: —Aja, occa Abi memehuaji madijari naco tiadenidsa nama nahitohui. Timecote tiadenidsa nacasserehe inanaraha tiadenipi: “Manaco, manaco” tiquinadsapi Abi Dio naco ticcadeni tabaccorehe epeje inana-jeranitohui, onajaro. Titessedenicca ima tiadenidsa ocassera taraha epeje tiquinaji. Pohuadenidsa pina tetideni huanaqquiri naji, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nadsapa Jeso dsama arobeni Carireahuajicca madija mari icanabaqquia jicadsapa dsama arobeni Jodeahuaji toccajari. Hueni Jordao jippehuaji toccadsapa dsama arobeni Pereahuaji bacco tajari. ");
INSERT INTO cul_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Madija sibema pohuadsa jai tojadsapa comaqquiri najarideni Jeso inanomibaqquijaride. ");
INSERT INTO cul_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Naraha nahidsapa Isaraeri potemahi jodiodeni mota marinaja pariseodsa jehe quinajarideni Jesodsa jiperaqquiri nadsa pocca marinaja inassamomananijine ima najoramanajari. Jesodsa tohuajiressimanadsapa pohuadsa huati toquinajari: —Aja ¿maqquideje pocca amonejedsa jipera tadsa inebodsapi pohuadsa ima nohueraqui? −quinade. ");
INSERT INTO cul_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Naraha Jeso pohuadenidsa huati tade: —Dio Atti dsodo nani hua hua titiquina naraha ¿ajijaro ima tetideni ajimamanajarorane? Maittaccadsama Dio dsama inahatoponipi Pohuajinena madija toquejenapodsapa ajima najaro: “Maqquideje, amoneje tadsajani inahatobaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nema najarojinea maqquideje pohua bedimenidsa tojadsapa imehi imenidenidsa nebo, pohuadenira madimanajari. Nadsapa pamaraha pina ojarijarissa quinajari” nahi nade Dio Atti Moisesijine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nadsapa assiredeni pamaraha cacajiredsapa Diojine pina ojarijarissa dsanapohuijine. Nadsama Diojine pina ojarijarissa quinaraha caneboredsapa bica tejerani. Madija ohuaha atti noppine caneboredsa naco bica tejerani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Naraha marinaja pariseodsa jehe quinajari attidenipa: —Naraha ¿nejecotohui Moisesicca marinajapi ajima naha? “Maqquideje pocca amoneje inebonijinepi nebohuecca papeo dsodo inadsa ponidsa da inadsa inebodsapi pohuadsa ima nohuerani” nani nade −quinajari. ");
INSERT INTO cul_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Naraha Jeso huati tajari: —Najaropi maittaccadsama ticcadeni idideni huaribodeni sibaqquiri nadsa nebohue tohui quinadsapa Moisesi najaro marinaja pohuadenidsa dsodo inajarode. Naraha Dio dsama inahatoponipi amoneje nebo nebocca imapi nohueraccade. ");
INSERT INTO cul_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tiadenidsa huati onana: Ticcadeni amoneje nebomana tejeraji. Ticca amoneje tinebodsa amoneje onihi ticajidsapi imasiri tinanajaro. Diocca dosseniji naqui tecahua-jerajaro. Naraha ticca amoneje maqquideje ohuaha inajadsana “Onebona” tadsa tinebodsapi tiadsa ima nohuerani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nadsapi ia Jeso huatimadedeni pohuadsa huati inade: —Jaho, amoneje ineboni oppina tadsapi ia motta amoneje jirehe imadidsana bica tani −inade. ");
INSERT INTO cul_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Nadsapa Jeso iadsa huati tade: —Jehe, naraha madija huapimapa amoneje jiraha pajiramana-jarahi. Diojine madija motana najaro imadsa pajiramanajari. ");
INSERT INTO cul_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ima onihi onihi cajimanajaripa amoneje cajimana-jarajaripaja. Mota ojari ojari quinahapa tossonamanapohuidsama amoneje cajimanahijinepa ssamoqquiri najari. Madija motapa pohua ime inajidsomanadsapa amoneje ajade ssamoqquiri najari. Maqquideje motapa pina amoneje ajade pajiramana-jarajarissa quinaha madimanajari. Pohuadeni attipa: “Diodsara idsepe ijidsa icca ima ojari nanijine” quinajari. Ajijaro imapi madija huapimacca jerani. Madija mota ojari ojari quinajaridenicca ima. Pohuadenipa: “Jehe, nema onana” quinadsapa nema ihinanamana najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nadsapa madija poccadeni ejedeni Jesodsa eccajonabaqqui-manajari, —Jeso tatideni bara inabaqquidsa Diodsa huati tahijine −quinadsa. Naraha Jeso huatimadedeni attidenia: —¡Ejedenipa pohua! ¡Jesohuaji teccajonabaqquimana tajarajo! −quinade. ");
INSERT INTO cul_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Naraha Jeso pohua huatimadedeni attideni mittadsapa: —¡Poni, nema tiquinejeraji! Pohuadeni jahijonana, onajaro. Eccajonabaqqui-manahijine tecossamana tejeraji. Madijapa pina ajajari ejedenidenissa quinajarina Diocca cacahuehedsa toquejenahitohui −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nadsapa ejedeni ojari ojari tatideni bara, inebo, bara, inebo naridsajari. Jicadsapa Jeso toccajaride. ");
INSERT INTO cul_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jesopa denima toccaraha madija pohuahuaji ccajonajari attipa: —Nija Mamaride ¿nejeco ima bicani onanadsana camittehe jiquejeranicca bacco onanijine? −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Naraha Jesopa: —¿Nejecotohui ohuadsara ima bicanitohui huati tinajaro? Ima bicani jinedepa Diona paja. Pajissa. Naraha camittehe jiquejeranicca bacco tinanijinepi Dio pocca dossenijidsara ibora tinaji −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Naraha dsabisso attipa: —¿Nejecomanajaro Diocca dossenijidsara ibora onanijine, tajaro? −nade. Naraha Jeso attipa: —Diocca dosseniji Moisesi dsodo inajarocca nahato tinani. Najaropi ajima najaro: “Madija tinanadsoqque-jarajo. Madija ohuahacca amoneje tija tejeraji. Tiboti tejeraji. Maidsehedsa naqui madijadsa ponima ima tinahana tejeraji” nani Diocca dosseniji. ");
INSERT INTO cul_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Onihi naqui: “Ticca abi, ticca amidsa bica tinadsa tinamadibaqquihissa tajo. Tinoriccadsa naqui teti huana taji, pina tia tiadsa teti huana tajarossa taji” nani Diocca dosseniji Moisesi dsodo inajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Naraha dsabisso attipa: —Najaro marinaja huapimapi ohuacahuajonajarode. ¿Naraha nejeco imara ohuadsa dsori taccajaro? −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Naraha Jeso pohuadsa huati tade: —Tipajiranissa tanijinepi ajima taji: Ticcanidsa tidsepetaji nemanehe manaconidsa da tinaridsaji. Nani najaro dsiniropi madija tohuati nahanaqquiri najaridenidsa da tinabaqquinijine. Nema tinanadsapi nidsa memehuaji Diocca biquehe tiadsa tojanitohui. “Nema onana” tadsapi ohuadsara dissera tinaji −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Naraha dsabisso najaro ima mittadsapa: —Jehe, nema onana −najarajari. Pohua dsepetajitohui, pocca dsinirotohui huati huana tajari. Pohuapa dsepe sse taja nadsapa bodi ocassera taha toccanide. ");
INSERT INTO cul_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nadsapa Jeso ia pohua huatimadedenidsa huati tade: —Pajissara tiadenidsa huati onana: Madija dsepedeni sseqquiri najaridenipa Diocca cacahuehedsa toquejenahijine najo tani. ");
INSERT INTO cul_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tiadenidsa huati omanipomana: Pina bani imehibote camellopa etero ssessequi odinidsa toqqueqquimahijine pajira-jarajarissa najari madija dsepe sse tajaripa Diocca cacahuehedsa tojahijine ssamo tani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nadsapi ia pohua huatimadedeni najaro ima imittadsapi ijabojo nadsa huati icanirere canade: —Jaho, madija tocassiejerahijinepa ssamo tani. ¿Nejecojarina tossiajapadsaja? −inade. ");
INSERT INTO cul_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Nadsapa Jeso ia tocattabaqqui nadsa huati tade: —Madijapa ssamomo taraha Diodsapi ssamo tejerani. Pohuajinena madija tocassiejerahitohui −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Naraha Pedropa Jesodsa huati tade: —Ia Maride, iapi tiadsa jaijaridsanijinepi icca odsa, icca madija, huapima ineboridsabaqquide. Nadsapa Dio iadsa ¿nejecora da inapadsaja? −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Naraha Jeso iadsa huati tade: —Pajissara tiadenidsa huati onana: Ohuapi Madija Bedi ojajaroa nidsa ajijaro dsama Diojine dsati tojadsapi occaronapomanitohui. Nadsapi deni ojanicca huihuittari bicanidsa ohuittaridsa dosse dosse onanitohui. Nadsana tiadeni 12 tiquinajaro naqui ima cacahuadecca huihuittari 12 nehe cacahitteri najarodsa jassi tinariridsanitohui. Nadsapi icca madija jodiodeni aja icca idi Isaraeri pohua bedi 12 quinajarideni potemahicca ima ticattemamananitohui −nade. ");
INSERT INTO cul_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","—Nadsama tiadenipi occa madija tiquejenajarojinea ticcadeni odsa ticanebomana, timecotedeni tinebobaqquimana, ticcadeni abi, ami tinebobaqquimana, ticcadeni ejedeni tinebobaqquimana, ticcadeni dsama tinebomana nadsapi nidsa dsotode aji huapima tineboridsa-manajarossa nehe Dio tiadenidsa da inaridsadsapi denima ticajimananitohui. Tetidsemaneri nanitohui, camittehe jiquejeranicca naqui ticajimananitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","—Jehe, jidapana tiadenipi ajimani tiquejenaraha ajijaro imadsa tibodideni huatomanaji: Madija jidapana madimanajarideni motapa deni toquejenaraha nidsaranibotepa ajamani toquejenahitohui. Jidapana madimanajarideni mota ajamani toquejenajarideni naco nidsaranibotepa deni toquejenahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesopa pocca marinaja ajijaro namidsa imadinicca ima tadsajani mari icanabaqquijari. Pohua attipa ajama nade: —Diocca cacahuehecca imapi pina huidsaja jinedecca imassa najaro. Pocca huidsajadsa ppa nahi uva pohuara ppa naridsajari. Huidsaja jinedepa dsidsidsamassa qquenadsa pocca huidsajahuaji tarabaidsa quinahijine madijatohui toccajari. ");
INSERT INTO cul_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bacco inabaqquidsapa pohuadeni tedseje imahaha canajari. Poccadeni dsamacca tarabaidsa huada ojarie manaconipi ccarara cajarie 1 denario. “Najaropi bica tani” quinadsapa jehe canirejari. Nadsapa pocca huidsajahuaji tarabaidsa quinahijine dosse inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Nahi dsotode maji huarijonadsa naco huidsaja jinedepa todsepetaji dada caji tanihuaji toccajari. Nahidsapa madija ohuaha dsepedeni jiraha domo huahi qqui inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Najaridenidsa naco huati tajari: “Tiadeni naqui occa huidsajahuaji tarabaidsa tiquinanijine jai tijaji. Tiadenidsa manaconi pajiranissa tehe da onanijine” najari. Nadsapa jai tojajari. ");
INSERT INTO cul_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nahi dsotode maji itetepidsa naco huidsaja jinedepa nama napomajari. Maji tohuenajonadsa naco nama napomajari. ");
INSERT INTO cul_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nahi dsotode maji toccadsa naco huidsaja jinedepa madija ohuahadenitohui toccapomadsa madija dsepedeni jiraha bacco inabaqquidsapa pohuadenidsa huati tajari: “¿Nejecotohui majidsama ajidsa tidsepedeni jirehe tiquejenajaroneje?” najari. ");
INSERT INTO cul_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Naraha pohuadeni cacomeramanajari: “Itohui madija huahua quina-jaradsapa” quinajari. Nadsapa pohuadenidsa naco: “Jehe, occa huidsajahuaji tidsepedeni ijimananijine tiadeni naqui jai tijaji” najari. Nadsapa pohuadeni naco jai tojajari, maji toccaraha. ");
INSERT INTO cul_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Nadsapa maji todsidsidsa huidsaja jinede pocca tatarabaidsadedeni cacahuadedsa huati tajari: “Jari, tatarabaidsadedeni huahua tanibaqquijo, poccadeni tarabaidsa manaconi da tinaridsanijine. Tahidepa aja maji toccadsa tarabaidsa quinajaridenina paca tinabaqquipona. Najarideni nattipa maji tohuenajonahicca paca, maji itetepicca paca, maji huaripohuicca paca tinabaqquina. Nadsana tahide dsidsidsamassa tarabaidsa quinajarideni paca tinabaqquina” najari. ");
INSERT INTO cul_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nadsapa dsotode tarabaidsa quinajaridenidsaha pohuadenidsa ccarara cajarie 1 denario da inaridsapojaropi pina tarabaidsa huada ojarie manaconissa nehe da inaridsajaro. Pohuadenidsa pohuadenidsa inanaridsajaro. ");
INSERT INTO cul_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nadsapa maji tohuenajonahicca paca, maji itetepicca paca, maji huaripohuicca paca inabaqquia jicadsapa dsidsidsamassa tarabaidsa quinajarideni paca inabaqquihijine najorajari. Naraha pohuadeni bodi attidenipa: “Iapi dsidsidsamassa tarabaidsa inapa. Iapi denima icajinitohuia” quinaraha pohuadenidsa naqui huada ojariecca tarabaidsa manaconissa nehe ccarara cajarie 1 denariora da inaridsajaro. ");
INSERT INTO cul_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","—Nadsapa huapima najarossa nehe cajiridsamanaraha tahide tarabaidsa quinajaridenipa najoramanapojari, huidsaja jinededsa ima idimamanahijine. ");
INSERT INTO cul_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Nadsapa huidsaja jinededsa pohuadeni attipa: “Maji toccadsa jai tojajaridenipa maji badsira taha tarabaidsa quinaraha pohuadenidsa pina iadsassa nehe da tinabaqquia” quinajari. “Naraha iapi majidsama maji ppoccone eraha icca tarabaidsa manaconi iadsa denima da tejerani. Aja maji toccadsa tarabaidsa quinajaridenicca manaconissa nehe icajia” quinajari. ");
INSERT INTO cul_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Naraha huidsaja jinedepa aja attideni nama quinajarideni ojariadsa huati tajari: “Jehe otesse, ticca tarabaidsa manaconi ojine dsori tejerapa. Nadsa tahide huada ojariecca tarabaidsa manaconi tiadsa huati onapopa. Tettipi: ‘Ccarara cajarie 1 denario ohuadsa bica tani’ ¿tapo-jerajaroqui? Nadsa tahide ‘Bica tani’ tapa” najari huidsaja jinede. ");
INSERT INTO cul_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","“Nadsapi ticca tarabaidsa manaconi ticajini. Epeje, ticcaniji. Dsotode tarabaidsa quinajaridenidsa naqui tarabaidsa manaconi pina tiadenidsassa nehe da onanijine jipa onadsapi epeje, nema onanajaro. ");
INSERT INTO cul_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Occa dsiniropi occa. Ohua tohuini onadsa da onanijine bica tani. Aja pohuadenidsa ohuati huana tadsapi pohuadeni acco ocamabaqquijari. ¿Najaro acconi tijamimanajarorane?” najari huidsaja jinede −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Nadsapa Jeso denima huati tajari: —Jehe, Abi Diopa huati huana tajari pina huidsaja jinedessa najari. Pocca cacahuehe tojadsapi dsotode toquejenajaridenipa pocca biquehe cajimanahitohui. Pina tahide toquejenajarideni cajimanajarissa quinahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jeso tedseje odsa panani Jerosarecca jahui jaijadsa pocca dodosse tabaqqui 12 inajaro ia motta pohuadsa iqueriqquinijine ia huahua tabaqquide. Nadsapa jahui jaijadsa iadsa huati huati dsanapodsapa pohua atti ajama najaride: ");
INSERT INTO cul_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Aji, Jerosarehuaji jaijemorajaropi nahatoqquiri tiquinani. Ohuapi Madija Bedi ojajaroa nidsa Jerosare bacco inadsapi dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajarideni dsepedenidsa ojanitohui. Ohuadsa: “Dsoqquena, dsoqquena” quinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Dsotodepi madija ohuaha jodio quejena-jarajaridenidsa ohua da quinadsa najaridenina ohua jaja icanaqquimanajaro, ohua cossi inaqquimanajaro nanitohui. Nadsapi ahua porimacossanidsa ohua inanadsoqque-manadsa ohua ppa idsamananitohui. Naraha huada huatinimade tojari nadsa onahatoninitohui −nade Jeso iadsa. ");
INSERT INTO cul_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nadsapi Sebedeo bedimenipi poni bedi pamaha Satiaco, Huano quinadsa Jesohuaji tohuajiressimanajari. Poni bodinipi: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji poni pitonidsa huitta nadsa Jesodsa huati tade: —Ohua Maride, tiadsa huati onanijinea −nade. ");
INSERT INTO cul_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Naraha Jesopa: —¿Nejeco imara ohuadsa huati tinanijine? −nade. Nadsapi poni attinia: —Ticca cacahuehe bicanihuaji madija cacahuade tittaridsapi occa ejedeni pahimarihijine tinori nahatonihuaji huittari, tinori ssamohuaji huittari quinahijine nama tinanabaqquijo, onajaro −nade Sebedeo bedimeni. ");
INSERT INTO cul_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Naraha pohuadenidsa Jesoa: —A, najaro imapi ssamomo tinani. Ohuapi ocasserani ohuabote nani. Ohuadsa najidsohue ssonarinitohui. Aji tiadenipi najidsohue tinahanamananijine ¿tipajiramanaqui? −nade. Naraha pohuadenipa: —Jehe, ia naqui ipajirani −quinade. ");
INSERT INTO cul_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nadsapa pohuadenidsa Jesoa: —Jehe, pajissa ocasserani tinahanamananitohui. Aji ohua najidsohue onahanadsapi tiadeni naqui nidsa dsotode najidsohue tinahanamananitohui. Naraha memehuaji occa cacahuehedsa madija cacahuade ohuadsama pahimarihijinepa ohua dosse dosse onejerani. Abi Dio icattejidsa-baqquijaridenina ohuinoridsa pahimarihijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Najaro ima imahaha canahi imittadsapi Jeso huatimade mota 10 inajaroa imecote pamahadsa edijarode. ");
INSERT INTO cul_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nadsapa Jeso ia huahua tabaqquidsa pohuadsa iqueriqquide. Iadsa huati tade: —Tiadenipi madija ohuaha jodio quejena-jarajaridenicca madie nahatoqquiri tiquinani. Poccadeni taminedenipa dossede dacoraqquiri nadsa poccadeni madija dosse dosse quiquinanajari. Deni toquejenajari ohuahadeni naco poccadeni madija dacorehedsa ehecahuabaqquimana najari. ");
INSERT INTO cul_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Naraha aji ohuadsa tiquejenajaropi nema tiquinanijine bica tejerani. Naraha titessedeni ojariapa: “Ohuana deni ojana” nadsapa pohuana huapima bijideni acco icamaridsabaqquihijinena bica tani. ");
INSERT INTO cul_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Diocca cacahuehedsa deni tijanijinepi titesse bijideni acco ticamaridsajo. Pina poccadeni medse tijajarossa tanijine. ");
INSERT INTO cul_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aji ohua Madija Bedi ojajaropi madija dosse dosse onanijine occajona-jerajaro. Madija acco ocamabaqquihijinena occajonajaro. Madija poccadeni imasiri manaconi pohuadenidsa ssonari-jeranijine poccadeni imasiri manaconipi ohuana ohua ohuaccoranitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nadsapi odsa panani Jericodsa jaijedsima... jaijenaraha Jeso natti madija sibema jahimissajari. ");
INSERT INTO cul_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jahui jaijadsapi nocco siri pamaha jahui inididsa pahimajari. —Jeso toqqueqquimahi −quinahi ima mittamanadsapa huahua quinajari: —¡Ia Medsede, Dabi Potemahi! ¡Iadsa teti huana taji, inaha! −quinade. ");
INSERT INTO cul_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Naraha madija attidenipa: —¡Poni! ¡Joma tiquinaji! −quinaraha pohuadenipa denima paja huahua toquinarihi huahua toquinarihi najari: —¡Ia Medsede, tamine Dabi Potemahi! ¡Itohui teti huana taji! −quinapomade. ");
INSERT INTO cul_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nadsapa Jeso toccaraha huaha tahi nadsa: —¿Nejecotohuira ohuadsa huahua tiquinajaroneje? −nade. ");
INSERT INTO cul_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nadsapa: —Ia Medsede, inocco ssire tinanabaqquiji, inajaro −quinade. ");
INSERT INTO cul_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nadsapa Jeso tohuideni huati huana tadsa noccodeni bara inabaqquidsapa amadsati noccodeni ssire-re nade. Nadsapa Jesodsa tohuedade. ");
INSERT INTO cul_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nadsapi Jesodsa madija huapima jaijade. Odsa panani Jerosarehuaji iajiradsapi odsa capamema najaro onini Betapaquedsa bacco inapojaro. Betapaquepi ssono onini Oribodsa anijaro. Nahidsana Jeso pocca dodosse tabaqqui pamahadsa huati tajaride: ");
INSERT INTO cul_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Jari, ajicca odsa capamema nanihuaji ticadapoji. Nanidsapi bojo namidsadsa bedima ssoque dsanehe huani. Najaro dicca tiquinadsa poni bedima teccanimanaji −nade. ");
INSERT INTO cul_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","—Naraha tiadenidsa madija attipa: “¿Nejecotohui bojo dicca tiquinajaro?” nadsapa pohuadsa huati tiquinana: “Ia Medsede ajaro bojo tohuini nadsapaja” tiquinana. Nadsapa bojo tiadenidsa toccanijine dosse inanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Najaro imapi pina maittaccadsama Dio Pohua Atti cacomerabote Sacariadsa huati tapojarissa nehe tojajaro: ");
INSERT INTO cul_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","—Odsa panani Siodsa madimanajaridenidsa ajima taji: “Qqui tiquinanaja, ticcadeni tamine bicabote tiadenihuaji bacco nahi. Pohuapa jone tahi, jadsire tohui najarahi. Ajana, bojo imehidsa huittarijona-jarahi. Bojo namidsadsa todsepetaji jojorede bedi idedsa huittarijonahi” −napohui nade Sacaria. ");
INSERT INTO cul_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nadsapa pocca dodosse tabaqqui pamahapa Jeso pohua attissa inanamananijine tohuedajari. ");
INSERT INTO cul_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nadsapa bojo namidsadsa imeni bedima bacco toquinadsapa eccanimanade. Bacco nanimanadsapa poccadeni etero huapicca motarajaro ssiti quinadsa bojo idedenidsa bina quinadsa bojo bedidsana Jeso huittarijari. ");
INSERT INTO cul_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nadsapa madija huapi taha Jesodsa huatidsemanadsa pohua tedsejema jahui bina idsanapomanajaro, pohuadsa: —Deni tijani −quinahijine. Nadsapa jahuidsa pohuadeni teteppe namidsa hua idsanapomanade. Madija ohuahadenipa birijari eppe ca ippimanadsa hua idsanapomanade. Nadsapa Jeso jahui bina tani motta toccadsanapojari. ");
INSERT INTO cul_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Madija huapima pohua tedsejema jai tojaja, pohua nattihuaji jahijonaja dsanapomanajari. Pohuadsa huatidsemanadsa huahua dsanapomanajari: —¡Tamine Dabi Potemahi deni tojahi, deni tojahi! −dsanapomanajari. —¡Ia Medsede onima ccajonajaridsa biquehera tojana, tojana! ¡Memehuaji Diodsa madimanajarideni pohuadsa: “¡Deni tijani!” quinana, quinana! −dsanapomanade. ");
INSERT INTO cul_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nadsapa Jeso Jerosarehuaji bacco todsimadsapa nahi odsa pananicca madimanajarideni huapima huatidsemanadsa ahuaji huahua ahuaji huahua naridsamanajari: —¿Nejecojaridsa huatidsejona-manajarinaja? −quinajaride. ");
INSERT INTO cul_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Naraha madija Jeso pohuadsa jahijonajaripa ecomeramanajari: —¡Jehe, ajajaripa Jeso! Pohuapa Dio Atti cacomerabote. Dsama Carireahuajicca odsa onini Nasareticca madija. ¡Najaria! −quinade. ");
INSERT INTO cul_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nadsapa Jeso Diodsa dada toqquimahuaji toqquedsimade. Najaro odsacca boronidsa madija bani bedi Diodsa da tahijinecca dade toquejenahi qqui tajari. Manaconitohui dadadedeni qqui inabaqquidsapa huapima mohua ininebaqquijari, mimittadedeni naco mohua ininebaqquijari. Dsiniro cacacajiqquimeradedenicca huahuanari naqui hua inaridsajaro, midsori dadadedenicca huihuittari naqui hua inaridsajaro naridsade. ");
INSERT INTO cul_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nadsapa pohuadenidsa Jeso huati tade: —Dio Atti dsodo nanidsa ima ajima najaro: “Occa odsapi Ohuadsa huati huati toquinahijinecca odsa tocajanitohui” naponi nade Dio Atti dsodo nanidsa. Naraha tiadenipi madija titicamaidsa-baqquimana nadsa tijinedenia pina bobotidedenicca quequeriqqui odsassa ticananamanajaro −nade. ");
INSERT INTO cul_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nahi dsotodepa Diodsa dada toqquimahuaji Jesodsa nocco siri jahijona, isso siri jahijona nadsa inanomiridsa-baqquide. ");
INSERT INTO cul_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Naraha dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinadsa Jeso canahatori canadsa madija tocanomirehi qqui toquinadsapa jiperaqquiri nade. Ejedenideni naco najaro odsacca boronidsa Jesodsa huatidsemanadsa johua johua quinajari. Ejedeni attidenipa: —¡Tiapi tamine Dabi Potemahi! ¡Deni tijani, deni tijani! −quinahi mittamanadsapa Jeso deni tojajari accone huadimanajari. ");
INSERT INTO cul_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ejedeni attideni pohuadenidsa ocassera tadsa Jesodsa huati toquinajari: —¿Ajajari ejedeni attideni timitta-jerajaroqui? −quinade. Naraha Jesopa: —Jehe, omittani. Attideni omittaraha tiadenina Dio Atti dsodo nanicca hua hua titiquina naraha ¿najaro ima tetideni ajimamanajarorane? Imapi ajima najaro: “Ejedenideni, ejedeni tobaccocca naco tiadsa huatidsemanadsa jiri jiri quinahitohui: ‘¡Bica tinani! ¡Bica tinani!’ quinahitohui” naponi nade Dio Atti dsodo nanidsa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nadsapa Jeso tedseje Diodsa dada toqquimahuaji inebo Jerosare inebo nadsapi odsa capamema najaro onini Betaniahuaji jaijanide. Nanidsa bacco inanidsapi nanidsana icahadijade. ");
INSERT INTO cul_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Huada ssiaja dsidsidsamassa Jerosarehuaji jaijapomadsapi jahuidsa Jeso pemide. ");
INSERT INTO cul_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nadsapa jahui inorinidsa ahua iquiera qqui tadsapa nahihuaji toccajari... bacco tade. Dsaboradsa qqui tadsapa iquiera bono nohuerade. Eppera qqui tajari. Bono nohueradsapa iquieradsa Jeso huati tade: —¡A, apaja! Jidapapi tibonomani-jeranitohui. ¡Nohueranitohui! −najari. Nanaja amadsati eppe dseqqueri-ri nade. ");
INSERT INTO cul_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Naraha pocca dodosse tabaqqui iapi icattomama canadsa ettipi: —A ¿nejecotohui amadsati iquiera dseqqueri najari? −inade. ");
INSERT INTO cul_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Nadsapa Jeso iadsa: —Pajissara tiadenidsa huati onajaro: Tiadeni naqui Diodsa jehe tiquinanissa tadsa Pohuadsa huatide tiquejenadsapi tibodideni: “¿Pajissa tojapadseje? Nohueranitide” tiquinejeraji. Nadsana pina ojinessa najaro ahua iquiera dseqqueri tinanamanahitohui. Naraha najaro imaha ojari-jerani. Ajijaro ssonodsa naqui huati tiquinadsa: “Ssono, titehemadsa passo imenidsa jaro tidsanaji” tiquinadsapi nema nanitohui. ");
INSERT INTO cul_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jehe, Diodsa huati tiquinadsapi tibodidenidsa: “Jehe, Diopa nema inananijine pajirahi” tiquinadsapi aji ticcadeni huatinaja Diojine najarossa inananitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nani dsotode Jerosarehuaji bacco inanipomadsapi Diodsa dada toqquimahuaji jaijedsimapomajaro. Nahidsa Jeso maride tojaraha pohuadsa jiperaqquiri najarideni aja dada toqquimade taminedeni, jodiodeni ime jocohuideni quinadsa Jesodsa tohuajiressimanadsa pohuadsa huati toquinajari: —Iadsa ticca ima tecomeraji. ¿Nejecojaricca dacorehe ticajijaro? ¿Nejecojari attidsa dadadedeni mohua tininebaqquijari? −quinade, Jeso pohua cacomerahijine tohuini quinadsa. ");
INSERT INTO cul_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Naraha manaco Jeso pohuadenidsa huati tade: —Ohua naqui tiadenidsa huati onana, tecomeramananijine. Ohuadsa tecomeramanadsapi ohua Cadossede oni, occa dacorehe tahimarini tiadenidsa huati onanijine −nade. ");
INSERT INTO cul_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","—Jari, Huanopa ¿nejecojari icadossedsa topa idsanabaqquijaritta? ¿Diojine ttarana, madijajine ttarana? −nade Jeso. Naraha taminedenipa pohuadenira huati tocanirere canade: —Jaho “Huanocca topaniji Diocca dosseniji” inadsapi Jesopa: “¿Nejecotohui pohuadsa jehe tiquinejerajarotte?” nahitohui iadsa −quinade. ");
INSERT INTO cul_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","—Naraha “Huanocca topanijipi madijacca dosseniji” inadsapi madija iadsa huadimanarana. Aja madija huapima attidenipa: “Huanopa Dio icadossejari. Dio Atti cacomerabotedija” quiquinanade −quinajari taminedeni, madijadeni noppine cappinamanadsa. ");
INSERT INTO cul_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nama quinanaja Jesodsa: —Ssamomo inani −quinade. Nadsapa Jesoa: —Ohua naqui ohua Cadossede onipa tiadenidsa ohuacomera-jarahi −nade pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesopa pohuadenidsa denima huati huati tajari: —Ajijaro ima huati onadsapi ¿nejeco imara tibodideni huatoni? Madijapa bedi pamajari. Ojariadsa huati tajari: “Ato, occa huidsaja uva ppa nahihuaji tidsepe ijiji” najari. ");
INSERT INTO cul_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Naraha bedipa ibo tadsa: “Oqquejerani” najari. Naraha dsotodepa pohua bodi cacajiqquimeradsa uva ppa nahihuaji toccajari. ");
INSERT INTO cul_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dsotode pohua bedi dsotodeccadsa naco najarossa najaro huati tapomajari: “Ato, occa huidsaja uva ppa nahihuaji tidsepe ijiji” najari. Pohua bedi dsotodecca attipa: “Jehe abi, occana” naraha tocca-jarajari. ");
INSERT INTO cul_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pohua bedi pamaraha ¿nejecojarina imehi attidsa ibora tajari? −nade Jeso. Nadsapa dada toqquimade taminedeni, jodiodenicca taminedeni quinadsa Jesocca marinaja ecomeramanade: —Tahidecca napaja −quinade. Nadsapa Jeso pohuadenidsa huati tajari: —Pajissara tiadenidsa huati onajaro: Romanodenicca taminecca dosseniji dsiniro nanaccadedeni, amoneje dsinirotohui ponideni dada quinajarodeni naqui Diocca cacahuehedsa toquejenahijine najoramanapojari. Naraha tiadenipi tinajoramana-jerajaro. ");
INSERT INTO cul_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ajana, Huano Baotistapa madija madimanahissa tahijine mari icanabaqquiraha tiadenipi pohuadsa pajissa tiquinejerajaro. Manaco ajajarideni romanodenicca taminecca dosseniji dsiniro nanaccadedeni “imasiri sseqquiri nahi” tiquinajaro. Amoneje dsinirotohui ponideni da da quinajaro naqui “imasiri sseqquiri nani” tiquinaraha najaridenina Huanodsa pajissa quinajari. Bodideni cacajiqquimerajari. Naraha tiadenipi Huanocca ima timittamana, madija bodi cacajiqquimerahi qqui tiquinaraha tibodideni cacajiqquimera-jerajaro. Pajissa tiquinejerade −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jeso attipa: —Ajijaro namidsa imadinicca ima onihi tadsajani tiadeni mari ocanabaqquina. Titaharibobo canaji. Madijapa pocca huidsajadsa uva pohuara ppa inajari. Nadsapi huidsaja inidi siba hua inahuajanijaro. Uva bono ttai nadsa ppejene tojahijine naqui sibadsa odi inahatojaro. Huidsaja cacahuade huittarihijine siba hua tamaroni naqui hua inamarojaro. Najaro huapima jicadsapi huidsaja jinede pocca huidsaja ecahuamananijine madijatohui qqui naridsajari, nahi pocca huidsajadsa tarabaidsa quinahijine, ppa nahi uva ecahuamanahijine. Uva bono jadadsapa motapa huidsaja jinededsa tojahijine. Motapa huidsaja cacahuadedeni pohuadenidsa tojahijine. Nadsapa pocca huidsaja ecahuamananijine madija qqui inabaqquidsapa pocca huidsaja pohuadenidsa inebojaro. Nadsapa jinede dsama huaji tanihuaji toccajari. ");
INSERT INTO cul_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva bono jadahicca abadsico bacco tadsapa huidsaja jinede huaji tanidsa madiraha pocca uva bonotohui pocca dodosse tabaqqui dosse inanibaqquijari. ");
INSERT INTO cul_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Naraha pocca dodosse tabaqqui huidsajahuaji bacco nanimanadsapa huidsaja cacahuadedeni itadamamanajari. Motapa itabaromanajari. Motapa inanadsoqque-ridsamanajari. Motapa sibadsa iquinabaqqui-manajari. ");
INSERT INTO cul_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nadsapa huidsaja jinede pocca dodosse ohuahadeni dosse inanibaqquijari. Tahideccassa quinaraha denima huapi taha dosse inanibaqquijari. Huidsaja cacahuadedenihuaji bacco nanimanaraha najarideni naco inajidso-baqquimanajari. Motapa itabaromanajari. Motapa inanadsoqque-ridsamanajari. Motapa sibadsa iquinabaqqui-manajari. ");
INSERT INTO cul_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","—Nadsapa huidsaja jinede pohua bodipa: “Occa ejedenidsana cappinamanahitohui” nadsa pocca ejedeni huidsaja cacahuadedenidsa dosse inanijari. ");
INSERT INTO cul_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Naraha huidsajahuaji bacco nanidsapa huidsaja cacahuadedeni pohua qqui toquinadsa pohuadenira huati tocanirejari: “Najaripa huidsaja jinede bedi. Nidsaranibote imehi dsoqquedsa huidsajapi pohuadsa tojanitohui. Jari, inanadsoqquena, huidsajapi icca tojanijine” quinajari. ");
INSERT INTO cul_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nama quinadsapa huidsaja jinede bedi dama quinadsa huidsaja inidihuaji iaccamanadsapa inanadsoqque-manajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nadsapa pohuadsa queriqquimanajaridenidsa huati tajari: —Jari, tibodideni huatoji. Huidsaja jinede bacco nanidsapa ¿nejecoma napadsaja huidsaja cacahuadedenidsa? −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nadsapa ecomeramanajari: —Jehe, huidsaja jinede pohua bacco nanidsapa huidsaja cacahuadedeni tabaccoraqquiri naja najari inajicabaqquihitohui. Pocca huidsajapi madija ohuahadenidsana da inanitohui. Pohuadenina pocca huidsaja ecahuamanadsa pina jinede attissa inanamanadsapi uva bono jadadsa motapa jinededsa da inanimanahitohui −quinade. ");
INSERT INTO cul_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nadsapa Jeso pohua tahimari pohuadenidsa ahuato tanijine pohuadenidsa denima huati tajari: —Tiadenipi Dio Atti dsodo nanicca hua hua titiquina naraha siba huahuattajo tojajaro tahimarini ¿tetideni ajimamanajaroqui? Imapi ajima najaro: “Odsa sibadsa icanahatomananijinepi nanahatodedenipa siba ojariepi ettajomanani nade. Naraha dsotodepi najaro sibana odsa daco cajiranijine tojajaro. Aji siba huahuattajo tojajaropi ia Medsede Diojine deni tojajaro. Najaro imajine Diodsa etidsejaro” nani Dio Atti dsodo nanidsa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Nadsapi tiadenidsa ajima onajaro: Diopa pocca cacahuehe tiadenidsa tojanijine najoraporaha Pohua Bedi tettajomanadsapa pocca cacahuehepi idininitohui, madija ohuahadenidsana da inanijine. Najaridenina Diodsa iboraqquiri nadsa poccadeni madiedsa ima bicani ahuato tanitohui. ");
INSERT INTO cul_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nadsama siba dacorehe cajijarocca ima onihi naqui ajima nani: Najaro sibadsa madija tohuedimamanadsapa poccadeni ima tossamodsapi assiredeni tajoriridsamanajarissa quinahitohui. Najaro siba madijadsa ssonaridsapi mere tocaniredsapa jamiromanahissa tahitohui −nade Jeso, pohua tahimari huati tadsa. (Aja madija pohuadsa pajissa quina-jaradsapa paja jicarihi nahitohui, najari.) ");
INSERT INTO cul_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nadsapa dada toqquimade taminedeni, marinaja pariseodsa jehe quinajarideni quinadsa Jesocca marinaja mittamanadsapa bodideni nahatoqquiri najari: —Jesopa icca ima huati huati tajari, iapi pohua ettajojarijine −quinade. ");
INSERT INTO cul_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nadsapa Jesodsa huadimanadsa: —Jeso todsepe inanana −quinaraha madija noppinedeni cappinamanajari, aja madija huapima: —Jesopa Dio Atti cacacomerabote −quiquinanadsa. ");
INSERT INTO cul_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nadsapa Jeso pocca marinaja ajijaro namidsa imadinicca ima tadsajani madija huapimadsa huati tapomajari. ");
INSERT INTO cul_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Pohua attipa: —Diocca cacahuehecca ima onihipi pina ajijaro imassa najaro. Tamine deni tojajaripa pocca ejedeni amoneje cajihijinecca jipaqquie inahatojaro. ");
INSERT INTO cul_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nadsapa cacajirehicca jipaqquie najoradsa pohua tessedeni jahijonahijine pocca dodosse tabaqqui dosse inabaqquiridsajari. Huati naridsamanadsapa attidenia: “Ohua medsedecca jipaqquie najorani. ‘Jai tijajonaji’ napaja” quinaraha pohua tessedenipa jai tojahijine jiperaqquiri najari. ");
INSERT INTO cul_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Dsotode naco pocca dodosse tabaqqui ohuahadeni dosse inabaqquipomajari. Pohua attipa: “Aja huahua onabaqquipojaridenidsa ajima tiquinaji: ‘Tamine attipa ajama napaja: Jipaqquie onajorani. Occa bohui dsoqque, occa bohui bedi oquibote dsoqque nahi. Huapima najorahi, najari. Occa ejedeni cacajirehicca jipaqquietohui jai tijajonaji, napaja tamine’ tiquinana” najari. ");
INSERT INTO cul_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nadsapa jai toja, huati toquinaraha pohua tessedenidsa pina ponimassa najaro. Ohuahapa pocca huidsajahuaji tocca, ohuahapa pohua dsepetaji dadahuaji tocca najari. ");
INSERT INTO cul_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Motapa taminecca dodosse tabaqqui itadamamanadsa inajidsobaqquimana, inanadsoqque-ridsamana najari. ");
INSERT INTO cul_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","—Nadsapa tamine huadidsapa pocca soldado icadossebaqquijari, pocca dodosse tabaqqui jicajarideni acconedeni jicahijine. Inajicabaqqui-manadsapa poccadeni odsa naqui botta inaridsamanajaro. ");
INSERT INTO cul_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nadsapa pocca dodosse tabaqqui ohuahadenidsa tamine attipa: “Jehe, occa ejedeni cacajirehicca jipaqquie najoranissa taraha otesse huahua onabaqquipojaridenipa occa huatidsehedsa pajiramana-jarahi. ");
INSERT INTO cul_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jari, madijatohui jahui imeni huapimadsa jai tijaridsaji. Nahihuajicca madija huapima bacco tinabaqquimanadsa ajima tiquinaji: ‘Tamine attipa: Occa ejedeni cacajirehicca jipaqquietohui jai tijajonaji, napaja’ tiquinana” najari tamine atti. ");
INSERT INTO cul_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nadsapa taminecca dodosse tabaqqui jahui imeni jai tojaridsadsa madija bacco inabaqqui-manajaridenipa tabaccoraqquiri najarideni, bicaqquiri najarideni naco inequeriqquimanajari. Nadsapa madija jai tojaja canadsa taminecca odsa bodihuaji madija ijimanajari. ");
INSERT INTO cul_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Nadsapa huapima jipamanadsa taminepa pocca ejedenicca jipaqquiedsa queriqquimanajari qquide qquedsimajari. Pocca daniji etero huedsaridsamanaha bica bica quinajari. Naraha madija ojariapa taminecca daniji cacajirehicca etero huedsa-jaraha qquedsimahi tamine qqui tajari. ");
INSERT INTO cul_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nadsa taminepa pohuadsa huati tajari: “¿Nija otesse? Occa ejedeni cacajirehicca etero occa daniji huedsaridsamanaraha tiaha tedsani qqui onejeraha. ‘Ohuapi cajicajicca etero jirani oqquedsimana’ ¿tajarorane?” najari. Naraha pohuapa tamine atti mittaraha joma najari. ");
INSERT INTO cul_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nadsapa tamine pocca dodosse tabaqquidsa: “Jari, ajajari madija isso jore, biji jore tiquinajo. Ajicca amossini dsidsinihuaji coro tininemanajo. Nahihuajipa ocasserani ahua-dsanapodsapa pano todsahi nadsa oji oji nahitohui” najari. ");
INSERT INTO cul_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—Jehe, Diocca cacahuehecca imapi najarossa najaro. Diopa pocca cacahuehedsa toquejenahijine madija huapima huahua inajonabaqquiraha pamema naha icattejidsabaqquijari, pohuadsa jehe quinahijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dsotodepa Isaraeri potemahi jodiodeni mota marinaja pariseodsa jehe quinajarideni tohuajimanahi nadsa pohuadenira imahaha canajari. —¿Nejecoma inanadsa Jeso atti inassamodsa pohuadsa ima inassonarinijine? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nadsapa pariseodenicca mamari tabaqqui pama, tamine Herodecca madija pama quinadsa Jesodsa huati toquinahijine dosse inabaqquijari. Nadsapa maidsehedsa ajama quinade: —Mamaride, ticca ima iadsa ahuato tani. Pajissara huati huati tinajaro. Pajissa Diocca marinajadsa madija madimanahissa tahijine mari mari titicanabaqqui najari. Madija attideni noppine ticappina-jeradsapi ticca ima onihi toja-jerajaro. Madija deni tojajari, madija dsepe sse tajari, madija ajamani tojajari tedsejepa tiadsa najarissa caniqquimerajari −quinade. ");
INSERT INTO cul_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","—Nadsama ibodi acco ticamabaqquiji. ¿Nejeco imana bica tani tajaro? Romanodenicca tamine deni tojahicca pocca dossenijidsa icca dsiniro mota pohuadsa da inanijine ¿bica taqui? ¿Bica tejerarane? Moisesicca marinajadsa ¿oppina taqui? ¿Oppinera tarane? ¿Tetti nejecoma tani? −quinade. ");
INSERT INTO cul_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesodsa attideni bica tadsa huati huati toquinaraha poccadeni tabaccorehe pohuadsa ahuato tadsa pohuadenidsa huati tajari: —¡Timaidsamanajaro! ¿Nejecotohui occa ima tossamonijine ohuadsa huati tiquinajaro? ");
INSERT INTO cul_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jari, ohuadsa dsiniro ccarara romanodenidsa da tanijinecca nohue ticanamanaji, qqui ocanana −nade Jeso. Nadsapi denario dsojo icanajonamanadsa Jesodsa da icanamanade. ");
INSERT INTO cul_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nadsapa pohuadenidsa huati tapomajari: —Jari, ajijaro ccararadsapi ¿nejecojari corimena anijaro? ¿Nejecojari oni dsodo najaro? −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nadsapa pohuadsa ecomeramanajari: —Romanodenicca taminedija −quinade. Nadsapa pohuadenidsa Jeso attipa: —Romanodenicca tamine pocca dsiniropi pohuadsa da tinanimanaji. Naraha Diocca tiquejenadsapi Pohua jipa tahiccara Pohuadsa da tiquinaji −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jeso atti mittamanadsa jabojomanadsapa: —A, icca ima ecomeranijine nahato tajaria −quinade. Nadsapa Jesodsa apaja quinadsa jai tojanijaride. ");
INSERT INTO cul_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Najaro huadadsa Isaraeri potemahi jodiodeni mota marinaja onini sadoseodsa jehe quinajarideni Jesohuaji bacco quinajari. Poccadeni marinajapi: —Idsoqquedsapi inahatoninijine nohuerani −quiquinanajari. —Najaro imadsa Jeso atti ijine tossamodsa cobara tana −quinadsa Jesodsa najaro ima huati toquinade: ");
INSERT INTO cul_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mamaride, Moisesicca marinajadsapi ajima nani: “Maqquidejepa amoneje cajiraha ejedeni jiraha dsoqquedsapa pocca amonejepi pohua imecotena icajina, nahi ejedeni cajidsapa pocca ato dsoqquejaricca ejedenissa nahijine” nade Dio Atti Moisesijine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nadsama tiadsa ima ajima najaro huati inana. Aja iadsapa pohuadeni imecote pohuadenira 7 quinaha madimanajari. Tahideccaha amoneje cajipojari, naraha bedi jiraha dsoqquejari. Nadsapa pocca amonejepi pohua imecotedsa tojajaro. ");
INSERT INTO cul_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Najari naco pohua ohuaha bedimeni icajiraha ejedeni jiraha dsoqquejari. Dsotodecca naco najaro amoneje icajiraha najari naco ejedeni jiraha dsoqquejari. Najarossa dsanapojaro cajide 7 quinaraha ejedeni jiraha jicajari. ");
INSERT INTO cul_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Najarideni jicadsapa poni naqui dsoqquejaro. ");
INSERT INTO cul_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nadsapi dsama jicadsa madija inahatonidsapi pohua imecote 7 quinajaripa najaro amoneje icajiqquimanaporaha ¿nejecojarina ponicca maqqui tojapadsaja? −quinade. ");
INSERT INTO cul_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Naraha Jeso attipa: —Ticcadeni marinajapi dsori tajaro. Dio Atti nahatoqquiri tiquinaraha pajissa tiquinanissa tejerajaro. Diopa pocca dacorehema madija inahatonibaqquihijine pajirahi naco ssamoqquiri tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jicamanajarideni nahatonimanadsapa caji caji cana-jarahitohui. Diohuaji madimanadsapa pina Diocca dodosse tabaqqui memehuajiccassa quinahitohui. Aja pohuadenipa caji caji cana-jaradsa madimanajari. ");
INSERT INTO cul_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","—Nadsama Diojine madija nahatonimanahicca imapi Dio Pohua Atti dsodo nanidsa dsodo napojaro. Pohua Atti dsodo nani hua hua titiquina naraha ¿najaro imapi tetideni ajimamanajaroqui? ");
INSERT INTO cul_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Aji maittaccadsama Abarahao, Isahaca, Jacobo quinajari dsoqquemanahi nattipa Diopa Moisesidsa huati tajari: “Ohuapi Dio, ticca idideni Abarahao, pohua bedi Isahaca, pohua bedi Jacobo quinajaridenicca Dio ojani” nahi nade. Aja Dio Atti nama nadsapa Abarahaodeni nahatonimanadsa madimana-dsanapohuicca ima ahuato tajaro. Diopa paja dsoqquemanarihi najaridenicca Dio jarahi. Diopa camittaqquiri najaridenicca Dio. Pohuapa jidapana naco poccadeni Dio −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Najaro ima mittamanadsa madija huapima jabojo quinadsapa: —A, Jesopa nahato tajari −quinajaride. ");
INSERT INTO cul_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Marinaja pariseodsa jehe quinajaridenipa ima mittamanajari: —Jesopa marinaja sadoseodsa jehe quinajarideni attideni ajimani inanajaro −quinahi ima mittamanadsapa pohuadenira queriqquidsa imahaha canajari: —Jari, ia naqui Jesodsa huati inana −quinadsa Jesodsa huatide jai tojajari. ");
INSERT INTO cul_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Najarideni ojaria jodiodenicca marinaja maride tojajaripa pohua bodidsa: —Jeso nattome onana −najari. Jesodsa bacco toquinadsapa najaria pohuadsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mamaride, Diocca dosseniji huapi tehe Moisesidsa da inaraha ¿nejecojaro dossenijina pocca dosseniji huapimadsa deni tojajaro? −nade. ");
INSERT INTO cul_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Naraha Jesopa pohuadsa huati tajari: —Aji Diocca dosseniji deni tojaniccapi ajima najarona paji: “Tiadeni Medsede Diodsa tetideni huanaqquiri naji. Tibodideni huatonissa tadsa, dacoco tijiradsa Pohuadsara disseraqquiri tidsanapomanadsapi Pohuadsa tetideni huanaqquiri nanijine.” ");
INSERT INTO cul_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Najarona Diocca dosseniji deni tojanicca. ");
INSERT INTO cul_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Diocca dosseniji deni tojanicca onihi pina tahideccassa najaro ajima najaro: “Tinorideniccadsa tetideni huanaqquiri naji, pina tiadenidsa tetideni huanaqquiri najarossa naji.” ");
INSERT INTO cul_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Najaro Diocca dosseniji pamehedsa pocca dosseniji Moisesijine dsodo najaro huapima tassaqquijaro. Dio Atti cacomerabote attideni naqui najaro pamehedsa tassaqquijaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Marinaja pariseodsa jehe quinajaridenipa Jesodsa queriqquimanahi paja naccadsapa Jeso pohuadenidsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Cristo-Mesiacca imapi tibodidenidsa ¿nejecoma nani? ¿Pohuapa nejecojari potemahi tiquinajaro? −nade Jeso. Nadsapa ecomeramanajaro: —Pohuapa Dabi Potemahi −quinade. ");
INSERT INTO cul_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nadsapa pohuadenidsa Jeso atti: —Naraha tamine Dabipa maittaccadsama madidsa Dio Corimejine pohua tedsejemacca ima huati tadsapa Cristo-Mesiadsa: “Ohua Medsede” napojari. Dabi pohua attipa: ");
INSERT INTO cul_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ia Medsede Diopa ohua Medsede Mesiadsa huati tajari: ‘Ohuinori nahatonihuaji tittariji. Ohua tedsejepi tohuatti dacorajaro ticajiji’ najari. ‘Nidsaranibote tia huadidedenipa ajamani onanabaqquihitohui. Poccadeni dacorehepi onajicanitohui’ napohui nade Dio.” ");
INSERT INTO cul_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Naraha Cristo-Mesia tamine Dabi Potemahi tojadsapa ¿nejecotohui Dabi pohua potemahidsaraha: “Ohua Medsede” napojaritta? −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pohuadenipa najaro ima ecomeramananijine pajiramana-jarajari. Najaro huadadsa Jesojine poccadeni ima tossamoridsadsapi ima onihi Jesodsa huati toquinahijine huapima cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nahi dsotodepa madija queriqquihidsa, ia pocca dodosse tabaqquideni naqui pohuadenidsama iquejemadsa Jeso iadsa huati tajaride: ");
INSERT INTO cul_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe quinajarideni tedsejepa Moisesicca marinaja nahatoqquiri nadsapa timittamananissa tanijine tiadeni mari mari totocanabaqquimana najari. ");
INSERT INTO cul_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Moisesicca marinaja tiadeni mari tocanabaqqui-manadsapa poccadeni marinajadsa iboraqquiri tiquinaji. Naraha pina poccadeni madiessa tiquinejeraji. Pohuadenipa ima bica taniccadsa mari mari quinaraha poccadeni madiepi pina poccadeni marinajassa nejerani. ");
INSERT INTO cul_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pohuadeni attipa: “Diocca dossenijidsa ajima tiquinaji” quinaraha poccadeni marinaja najo tanicca inaharimanajaro. Nadsapi pohuadenijine ima toccanajani najaro. Najaro imapi madija ecahuamananijine pajiramana-jarahi. Pohuadeni naco najaro ima madija ecahuamananijine acco icamabaqquimana-jarahi. ");
INSERT INTO cul_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pohuadenipa madija pohuadenihuaji noccodeni jo najonahi nahitohuira madimanajari, madija pohuadeni qqui toquinadsa: “A, Diodsa disseraqquiri nahi” quinahijine. Aja jodiodeni motapa pohuadeni assaridsa, pohuadeni bijidsa Dio Atti dsodo nani dsaminidsa oro idsamanadsa ssoque ssoque teri najaro. Naraha pariseodeni, jodiodenicca marinaja maridedeni tedsejepa dsamini denima imenicca ssoque ssoque teri najaro, “Dio Atti dsamini denima ahuato tanijine” quinadsa. Poccadeni etero iponidsa naqui cohuani dequerema cahuiheheri najaro. “Iana denima Diodsa bicaqquiri inani” quinaraha. ");
INSERT INTO cul_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jipaqquie imenidsa naqui deni toquejenajaridenicca huihuittaridsa jassi tarihijine tohuini quiquinanajari. Aja Dio Atti mamarihuaji naco jassi tarihijine deni toquejenajaridenicca huihuittari tohuini quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jahuihuaji jahiridsadsa naco madija pohuadenidsa: “¿Nija, bica tinani? Tiapi deni tijani” quinahijine naco tohuini quiquinanajari. Madija naco pohuadenidsa: “Ohua maride” quinahijine tohuini quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—Naraha tiadenipi madija tiadenidsa: “Ohua maride” quinahijine tohuini tiquinejerana −nade Jeso iadsa. —Tiadeni Maridepa ojarihi. Nadsapi tiadeni huapimapi timecotedeni tiquejenajaro. Tiadenidsa ojaria deni tojahicca nohuerahi. ");
INSERT INTO cul_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aja namidsa madimanajaridenidsa naqui: “Abi” tiquinejerana. Ticcadeni Abi memehuaji madijarina ojarihi. Najaridsara: “Abi” tiquinaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Madija tiadenidsa: “Ia dossede” quinadsa naqui poni tiquinaji. Tiadeni dossedepa Cristo-Mesia ojarihi. ");
INSERT INTO cul_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Naraha tiadenidsa madija denima bica tajaripa huapima bijideni accode dissera tajari. Pina ticcadeni medsessa najarina deni tojajari Diodsa. ");
INSERT INTO cul_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ajana, madijapa pohua ehuerahi pohua deni tonanadsa: “Ohuana deni ojani” nadsapa nidsa dsotode najaripa Dio ajamani inanahitohui. Naraha madijapa: “Ohuapi ajimani ojani” nadsa pohua imecotedeni accode tohuini naha madijaripa nidsa dsotode najarina Dio deni inanahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nadsapa Jeso jodiodenicca marinaja maridedenidsa, marinaja pariseodsa jehe quinajaridenidsa huati tajari: —Jaho, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Dio Atti madija mari ticanabaqquimanahissa tadsapa madija Dio Atti tocahatterahijineraha. Dio Atti mari ticanabaqquimanahissa tajaradsa, ticcadeni marinaja najo tanicca tinaharimanadsapi tijinedeni madija Dio Atti tocahattera-jarajari. Nema tiquinadsapi pina Diocca cacahuehecca noccobiji ticahacossamanajarossa najaro. Nadsapa madija Diocca cacahuehedsa jai tojedsima-jarajari. Tiadeni naqui pocca cacahuehedsa jai tijedsima-jerajaro.  ");
INSERT INTO cul_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Jaho, jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Tabira tocajamanajarodeni ponideni madimananijineccaraha ticamaidsabaqquimanadsa tiadenidsa totoja nadsapi ponidenicca odsa naqui tiadenidsa totocajaridsa najaro. Naraha ticcadeni tabaccorehe ahuatora tanijinepi Diodsa huati huati tiquinadsa ticcadeni huatinaja dequerajaro. Aja madija tiadenidsa: “A, Diodsa disseraqquiri nahi” quinahijine. Tiadenina Dio Attima mamaidsadsa tadsapi nidsa Diocca najidsohue denima oppina tanicca tiadenidsa ssonarinitohui −nade Jeso.  ");
INSERT INTO cul_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Jaho, jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Madija ohuaha jodiodenicca marinajadsa toquejenahijine maride disseraqquiri tiquinadsapi dsama onihihuaji, dsama onihihuaji maride jajahi tijaridsa najaro. Passo imeni jippehuaji naqui maride jajahi tijaridsa najaro. Madija ohuahadenipa: “Jodiodenissa inana, Diodsa iquejenanijine” quinaraha tijinedenina ticcadeni marinajadsara toquejenajari. Najarojinena poccadeni ima denima totabaccorajaro. Ticcadeni ima tabaccora tadsapi jororoni jiquejeranihuaji tiquejenanitohui. Tijinedeni poccadeni ima denima totabaccoradsapi pohuadeni naco jororoni jiquejeranihuaji toquejenahitohui. ");
INSERT INTO cul_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Jaho, tettidenipi: “Iapi Dio Attidsa madija mari icanabaqquijaripa pina madija jahinedeni dsopide iquejenajarossa najaro” tiquinaraha tiadeni huapimapi noccodeni sirissa tiquinajaro. Huahuattajo tiquejenanitohui. Dio Atti mari mari titicanabaqquimana naraha tibodideni huatonissa tejerajaro. Ticcadeni marinajapi ajima najaro: Madijapa madija ohuahadsa huati tajari: “Ohuatti ojine pajiranissa tanitohui, pina Diodsa dada toqquima pajiranissa tajarossa najaro” najari. Naraha pohua attissa inana-jeradsapi: “Epeje, oppinera tani” titiquina najaro. Naraha pohua attipa: “Ohuatti ojine pajiranissa tanitohui, pina Diodsa dada toqquimahuajicca oro pajiranissa tajarossa najaro” najari. Naraha pohua attissa inana-jeradsapi: “Oppina tani” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Tiadenipi ssamoqquiri tiquinani. Tibodideni huatonissa tejerajaro. ¿Nejecojaro imana deni tojajaro? ¿Diodsa dada toqquimahuajicca orona deni tojajaroqui? ¿Dada toqquimacca odsana deni tojajarorane? Jehe, dada toqquimacca odsana Dio pocca. Najarodsa oro da idsimamanadsana Dio pocca tojajaro. Najaroa aji dada toqquimana deni tojajaropaji. ");
INSERT INTO cul_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Ticcadeni marinaja onihi naqui ajima najaro: Madijapa madija ohuahadsa huati tajari: “Ohuatti ojine pajiranissa tanitohui, pina Diodsa da tahijinecca huahuanari pajiranissa tajarossa najaro” najari. Naraha pohua attissa inana-jeradsapi: “Epeje, oppinera tani” titiquina najaro. Naraha pohua attipa: “Ohuatti ojine pajiranissa tanitohui, pina Diodsa da tahijinecca huahuanaridsa da naqquinaja huapima pajiranissa tajarossa najaro” najari. Naraha pohua attissa inana-jeradsapi: “Oppina tani” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Tiadenipi ssamoqquiri tiquinani. Tibodideni huatonissa tejerajaro. ¿Nejecojaro imana deni tojajaro? ¿Madijacca da naqquinaja huahuanaridsa huanarijaropi deni tojajaroqui? ¿Diodsa da tahijinecca huahuanarina deni tojajarorane? Huahuanarina Dio pocca. Najarodsa madijacca da naqquinaja hua inarimanadsana Dio pocca tojajaro. Najaroa aji Diodsa da tahijinecca huahuanarina deni tojajaropaji. ");
INSERT INTO cul_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—Madijapa madija ohuahadsa huati tadsapa: “Ohuatti ojine pajiranissa tanitohui, pina Diodsa da tahijinecca huahuanari pajiranissa tajarossa najaro” nadsa najaro huahuanaricca ima huati tadsapa najaro huahuanaridsa huanarijaro huapima naqui huati tajari. ");
INSERT INTO cul_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Madijapa madija ohuahadsa huati tadsa naco: “Ohuatti ojine pajiranissa tanitohui, pina Diodsa dada toqquima pajiranissa tajarossa najaro” nadsa najaropi dada toqquimacca imaha ojari-jerani. Najaropi Diocca ima. Nahidsapa Dio madijari. ");
INSERT INTO cul_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Madijapa: “Ohuatti ojine pajiranissa tanitohui, pina meme pajiranissa tajarossa najaro” nadsa najaropi memecca imaha ojari-jerani. Nanihuajipi Dio Pohua dosse dosse nahicca huihuittari cahittajaro. Najarodsapa Dio Pohua huittarijari. Memehuajicca ima huati tadsapa Diocca ima naco huati tajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Jaho, jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Ticcadeni odsa inorinicca ppa nahi dsamatapa quequejema majo bica tajari pore tiquinadsa naco badsira taraha mota Diodsa da da titiquina najari. Najaropi ticcadeni marinaja ajimaniccaraha tecahuamananissa tajaro. Naraha Diocca dosseniji deni tojaniccapi tecahuamana-jerajaro. Diocca dosseniji deni tojaniccapi madija ticamaidsabaqquimana-jaradsa tettideni pajiranissa tanijine. Madijadsa naqui tetideni huanaqquiri nanijine. Maidseraqquiri tiquinadsa tettidenissa tinanamana-dsanaponijine. Jehe, najaro dosseniji tecahuamana-jeradsapi ticcadeni ima dsori tajaro. Aji ticcadeni odsa inorinicca ppa nahi mota Diodsa da da titiquina najari bica tahi naraha najaro dosseniji ajimanicca aji Diocca dosseniji deni tojanicca tadsajani tecahuamanaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Jaho, tiadenipi pina noccodeni sirissa tiquinajaro. Oppina tahicca dappi tiquina-jarahijine ticcadeni dsedse eterodsa tinaqqueqquima-manadsana dse dse titiquina najaro, “sisipe ssonippahitide” tiquinadsa. Naraha Diocca dosseniji deni tojanicca tecahuamana-jeradsapi pina bani jipahi oppina tahicca camello motararaha nama naha dappi tiquinajarissa najari. ");
INSERT INTO cul_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Jaho, jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Ticcadeni madiepi pina dsedse, parato huapihuajira ssahua ssahua tiquinajarissa najaro. Naraha tibodidenina pina dsedse parato bodihuaji ssahuarahi oba tajarissa tiquinajaro. Tibodidenidsa tibotimanajarocca ima ijijaro. Tohuini tiquinajarocca naqui ijijaro. ");
INSERT INTO cul_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tiadenipi tibodideni huatonissa tejerajaro. Ticcadeni dsedse, ticcadeni parato bodihuaji naco ssahua ssahua tiquinajo. Najaropi aji ticcadeni tabaccorehe tinebomanaji, tibodideni tohuirenijine. Nadsana ticcadeni madie naqui tobicanitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","—Jaho, jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Tiadenipi pina tonoccobiricca siba bica tanijine nopohuidsa sse tiquinadsa bica tajarossa tiquinajaro. Huapihuaji bica taraha bodihuajipi oppina tani. Madija dsoqquehi tonedeni caji, imedeni jadsini obani naqui caji tani. ");
INSERT INTO cul_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tiadenipi najarossa tiquinajaro. Madija tiadeni qqui toquinadsapa pina bicaqquiri tiquinajarossa naraha tibodidenidsa maidsehe iji, imasiri iji najaro. ");
INSERT INTO cul_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Jaho, jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Maidsajidede tijirani. Tiadenipi Dio Atti cacomeraqquiri napojarideni noccobirideni tetepidsa siba hua tinamaromanajaro. Madija bicaqquiri najarideni noccobirideni tetepidsa naqui bica tanijine tijinedeni hua naridsajaro. ");
INSERT INTO cul_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Naraha tettidenipi: “Maittaccadsama icca idideni madimanapohuidsama imadidsapi nassa pohuadenissa inejeraneje. Icca ididenipa Dio Atti cacomeraqquiri najarideni inanadsoqque-baqquimanadsapa nassa iapi pohuadeni acco icamabaqqui-jaranaja” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Naraha tettideni nema tiquinadsapi tijinedeni ima ahuato tajaro. Tiadenipi Dio Atti cacomeraqquiri najari nanadsoqquededeni potemahi tiquejenajaro. Pohuadenissa tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Nadsapi ticcadeni ididenicca jarehe idimamanapojarocca najarossa tinanamanadsa jicana −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Tiadenipi pina maccassa tiquinani. Ticcadeni ima tabaccora tajaro. “Diocca najidsohue dsori icanirenitohui” ¿tiquinajaroqui? ¡Dsori ticanire-jeranitohui! Jororoni jiquejeranihuaji tiquejenanitohui. ");
INSERT INTO cul_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nema nadsapi tiadenidsa Dio Atti cacomeraqquiri najarideni, Diojine nahatoqquiri najarideni, Dio Atti pajissacca mamaridedeni dosse onaridsabaqquihitohui. Naraha motapa tinanadsoqque-baqquimanahitohui. Motapa ahua porimacossanidsa tinanadsoqque-baqquimanahitohui. Motapa jodiodenicca Dio Atti mamarihuaji titacossimanadsa biqueramanahitohui. Motapa odsa onihihuaji odsa onihihuaji mohua tinabaqquimana-ridsahitohui. ");
INSERT INTO cul_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nema tiquinajarojinepi tiadenidsa najidsohue imeni ssonarinitohui. Ajijaro dsamacca madija bicaqquiri najari tojicadsa emenedeni toccajaro manaconedeni tiadenidsa ssonarinitohui. Aja tahidepa Abeo bicabotena pohua ohuahajine dsoqquepojari. Najari dsoqquepodsama aja Dio Atti cacomeraqquiri najarideni naco inajicamanaja najonapohui najaria aja Berequia bedi Sacaria inanadsoqque-manahi bacco najonajaropaji. Sacariapa Diodsa dada toqquima bacconihuaji aji Diodsa da tahijinecca huahuanari inorinidsa inanadsoqque-manajaripaja. ");
INSERT INTO cul_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pajissara tiadenidsa huati onajaro: Aja huapima jicajonajarideni manaconedeni jidapana madimanajaridenidsa Diojine najidsohue ssonarinitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesopa odsa panani Jerosarehuaji madimanajaridenicca ima huati tajari: —Ohuapi titohuideni oji oji onadsapi: “Jerosare, Jerosare” ohonanajaro. Maittaccadsama ticcadeni idideni madimanapodsa naco Dio Atti cacomeraqquiri najarideni inanadsoqque-ridsamanaja najonapohui najari. Diopa pocca dodosse tabaqqui tiadenidsa dosse dosse inajonabaqquiporaha sibadsa tiquinabaqquimanaja najonapohui najari. Naraha ohuapi tiadeni ohuacahuabaqquina, onajaro. Pina tacara poni bedi poni appani dopanidsa ecahuabaqquijarissa onanijineraha tiadenipi ohuadsa jiperaqquiri tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tetideni huatoji. Diopa tidsamarideni Jerosare inebonitohui. Tiadeni tohuacahuabaqqui-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ohua naqui, ohua qqui timanimanapoma-jeraccanitohui. Nidsaranibote ima najoranissa tadsa occanipomadsana ohua qqui tiquinapomanitohui. Nadsana tettidenipi: “Jehe, ajaripa Dio onima ccaronajari. Pohuapa bica tahi, bica tahi” tiquinanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nadsapa Diodsa dada toqquimadsa Jeso qquenadsapa toccadsa ia pohua huatimadedeni pohuadsa iajiressidsa huati inajarode: —Ia Maride, aji dada toqquimahuajicca odsa huapimapi bicaqquiri naha −inade. ");
INSERT INTO cul_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Nadsapa Jesoa: —Aji odsa imeni sibadsa nahatoridsani jidapana qqui tiquinaraha pajissara tiadenidsa huati onana: Nidsa dsotode ajijaro odsa huapimapi taboridsehe jicanissa tanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nadsapi ssono Oribohuaji jaijemorajaro. Nahidsa Jeso huittaridsapa ia pohua huatimadedeni iara pohuadsa huajijira icanadsa pohuadsa huati inajaro: —Ia Maride, jidacca ima huati tinajaropi ¿nejecoma nadsa tojapadseje? Aji namihuaji ticcaronapomanijinecca ima, aji dsama jicanicca ima tohuajiradsa nahatoqquiri inanijinepi ¿nejecora qqui inapopadseje? −inade. ");
INSERT INTO cul_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nadsapa Jesoa: —Paji, madija tiadeni tocamaidsabaqquirana. ");
INSERT INTO cul_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nidsa madija huapi taha pohuama ohua onidsa maidsamanadsapa: “Ohuapi Cristo-Mesia ojani” quiquinanahitohui. Najaridenipa madija huapi taha icamaidsabaqqui-manahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ima onihi naqui: “Jadsire tojaridsani” timittamananitohui. Naraha ticappinamana tejerana. Jadsirepi epeje tojaponitohui. Naraha dsamapi jiquejeraccanitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nadsama madija dsama onihicca, dsama onihicca tedseje jadsire inanamana-ridsanitohui. Tamine ohuahacca madija, tamine ohuahacca madija tedseje cahadire-ridserahitohui. Pemi naqui cajiridsanitohui. Namidsadsa naqui tojaridsanitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Najaro ocasserehe tahide tojaporaha denima ocasserehe tojadsanaponitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Nadsapa tiadeni tadamamanadsapa todsepedsa tiquejenaridsanitohui. Pohuadenijine nanajidso tiquejenadsapi tijicaridsanitohui. Occa madija tiquejenajarojinepi madija huapima tiadenidsa jiperaqquiri nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nadsama ohuadsa toquejenajarideni motapa ohuatti nebomanadsa ima ponimacca maidsanijidsara toquejenaridsahitohui. Nama quinadsapa pohuadeni tesse dsoqquehijine ahuaji eccora, ahuaji eccora naridsamanahitohui. Pohuadenira pohuadeni tessedsa ahuaji jipera, ahuaji jipera naridsamanahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Dsama jicanijinepi mamaidsade ahuatomaridsa-manahitohui: “Ohuapi Diocca dosseniji, Dio Atti ohuacomerajaro” quiquinanaraha Diocca dosseniji jarahi. Naraha pohuadenipa madija mota huapi taha icamaidsabaqqui-manadsapa huapima attidenipa: “Jari, najaridenicca imadsara iquejenana” quinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dsama huapimadsa madijapa imasiri denima denima inanaridsamananitohui. Dsama huapimadsa imasiri ijiridsajarojine tohuati huanehepi huatideni ajamamanahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","—¡Naraha tiadenipi dacoco tijiraji! Najaro huadie tinahanamana-dsanapodsapi tijicaraha ticassiejeranitohui. Timadimanaccadsa dsama jicani bacco tiquinadsa naqui ticassiejeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Naraha dsama jiquejeraccadsama Dio pocca cacahuehecca ima bicani dsama huapimadsa ecomeraridsa-manaccanitohui. Najaro imapi otahimari madija tocassiejerahijinecca dsama nemanehedsa madiridsamanajarideni mittaridsamanahitohui. Nadsana dsama jicanicca huada bacco tanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesopa dsama jicanicca ima denima ia mari tocanabaqquijari. Pocca marinaja hua tiquinadsapi timittamananissa taji. Pohua attipa: —Nidsa jodio quejena-jarajaridenijine Diodsa dada toqquimahuaji oppinabote corime huedsadsapa toppinanitohui. Nadsapi pohuadenijine icca madija jodiodenipa icappinaqquimanadsa Diodsa dada toqquima paji inebomanarinitohui. Najaro imapi maittaccadsama Dio Atti cacomerabote Daniel dsodo inapojaro. Najaro ima tojani qqui tiquinadsapi tidomo toccaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Aji dsama Jodeahuaji timadiridsa-manajaropi ssonohuaji tidomo toqquemorana. ");
INSERT INTO cul_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Madija pocca odsa amossinihuaji ccaridsadsapa pohua dsepetajitohui pocca odsahuaji toqquedsimani-jarana. ");
INSERT INTO cul_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Madija pocca huidsajahuaji dsepe ijijari naco paja joppa tarina. Pocca eterotohui odsahuaji ccani-jarana. ¡Poni! ");
INSERT INTO cul_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jaho, amoneje jiamanajarodeni, bacconideni ijimanajarodeni naqui joppa toquinanijine tohuati nahanaqquiri nanitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Diodsa huati huati tidsanapomanaji, aji najaro ima oppinabote tojadsa tidomo toccadsapi ssirini nohueranijine, jassinajacca huadadsa naqui nohueranijine, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Najaro ima oppina tanicca bacco nadsapi madija huapima ocasserani imeni inahanamananitohui. Maittaccadsama Dio dsama inahatoponipi nema nanicca ocasserehe qqui quinapo-jerani. Nohuerani. Ia naqui qqui inejerani paji nani. Nidsa dsotode naqui nema napoma-jeranitohui. Nohueranitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Najaro ocasserehe nema dsanapodsapi madija tossiajaja cama-jarahitohuiraha najaro ocasserehecca huada Dio ajimani inananitohui. Dio pocca madija pohua icattejidsa-baqquijaridenidsa huati huana tadsapa: “Nanidsa epejena, jicana” nahitohui Dio −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Nadsapa madija tiadenidsa pohuama: “Qqui, ajajaripaja ia Idinide Cristo-Mesia” quinadsa, madija ohuaha attideni naco: “Qqui, ajaccajarina Cristopaja” quinadsapa pajissa tiquinejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Madija mamaidsadedeni naco tiadenidsa jahijonahitohui. Pohuadenipa: “Ohuapi Cristo-Mesia ojani” quinahitohui. Ohuahadeni naco: “Ohuapi Diocca dosseniji ojani, Pohua Atti ohuacomeranijine” quinaraha maidsamanajari. Pohuadeni bodipa: “Dio icattejidsa-baqquijarideni icamaidsabaqquina” quinadsa poccadeni maidsehe canahatorimana canaridsahitohui. Madija pohuadenidsa: “Pajissa Diocca dosseniji” quinahijine tohuini quinaraha Dio Pohua icattejidsa-baqquijarideni motapa pohuadenidsa pajissa quina-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aji huati huati onajarocca imapi nidsaranibote tojanijineraha jidapana tiadenidsa huati onajaropajipa. ");
INSERT INTO cul_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nadsama madija attideni: “Ajacca madija madide nohuerahihuaji ia Idinide ccanihi” quinadsapa nani qquide jai tija tejerana. Madija ohuahadeni naco: “Ajiccajaro odsa bodidsa ia Idinide pohua najimahi” quinadsa naco pajissa tiquinejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aji ohuapi Madija Bedi ojajaroa nidsa occaronapomadsapi ahuato tanitohui, pina ssissiede dacorehema ssie nadsa meme nemanehe tossiajabaqquijarossa nanitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Abaridsa toqueriqquinidsa bani huatiahi ponahi nahatoqquiri tiquinajaro. Pina najaro imassa najaro occaronapomadsapi madija huapima nahatoqquiri nahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesopa ima denima huati huati tajari: —Naraha ocasserehe inahanamanani nattinipi maji ohuihitohui. Abadsico naco cahuihitohui. Memecca abadsico bedi naco catojahitohui. Jidapapa memecca huapima dacoraqquiri naccahi. Naraha dsotodepa meme dsadsa nadsapi huenene huenene canahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nadsana ohuapi Madija Bedi ojajaroa occaronapomadsapi memehuaji ahuato tanitohui. Nadsapa dsama huapimacca madija cappinamanadsa oji oji quinahitohui. Nadsapi meme essenima oquejemehe occaronapomani qqui toquinahitohui. Occa dacorehe, occa deni tojehe ahuato tanitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nadsapa occa dodosse tabaqqui memehuajicca dosse onaridsabaqquidsa jadsirema jei jei quinadsa Dio icattejidsa-baqquipojarideni inequeriqquinibaqqui-manahitohui. Dsama nemanehedsa madiridsamanajarideni huapima ahuajicca, ahuajicca inequeriqquinibaqqui-manahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—Jari, ahua iquiera tahimaridsa ticahatteraji. Eppe moro nimanihi qqui tiquinadsapi: “Jehe, dsadsajade tojemanini” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pina najaro imassa najaro aji dsama jicani tahimarini huati huati onajaro qqui tiquinadsapi: “Jehe, Jeso ccanihi, pina icca noccobijidsa huajarissa najari” tiquinana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pajissara tiadenidsa huati onajaro: Aji dsama jicani tahimarini huati huati onajarocca madija dsoqquemana-jaraccadsama najaro ima huapima tojanissa tani qqui toquinaccahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Meme, nami naqui jicaridsanissa tanitohui. Naraha ohuattipi jiquejeranitohui. Aji huati huati onajaropi najarossa nanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Occaronapomanicca huada, maji naco madija huapima ssamoqquiri nahi. Diocca dodosse tabaqqui memehuajicca naco ssamoqquiri nahi. Dio Bedi ohua naqui najaro ima ssamo onani. Naraha Abi Dio Pohuana nahato tahi ojarihi −nade. ");
INSERT INTO cul_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Jehe, ohuapi Madija Bedi ojajaroa nidsa occaronapomadsapi pina maittaccadsama Nohue madipodsa ppani ccajonajarocca imassa nanitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ppani ccajona-jeraccadsama madijadenipa jijipamana najari, dse dse quinajari, caji caji canajari. Nama quiquinanapojaria aja Nohue pocca canoa imenidsa toqquedsimahicca huada bacco tajaropaji. ");
INSERT INTO cul_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Madija motapa ppani tojanicca huada ssamoqquiri nadsa najoramanapo-jarajari. Nadsapa ppani huassinaja bacco najonadsapi huapima je tocaniredsa jicajari. Najarossa nanitohui nidsa ohua Madija Bedi ojajaroa occaronapomadsa naqui madija mota otohui najoramana-jaradsapa ajijaro namidsa jicahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jehe, nidsa occaronapomadsapi ima ajima nanitohui: Madija pamaha huidsajadsa dsepedeni ijimanajari. Ojaria otohui najorapojarina iaccamacossanihitohui. Naraha ohuahapa otohui najora-jaradsapa inebohuitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Amoneje pamehe naqui dododsa dode toquejenajaro. Ojarie otohui najorapojarona iaccamacossani-nitohui. Naraha onihipi otohui najora-jeradsapi inebonitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","—Nadsama tetideni huatodsa ticattomama canaji. Ohua tiadeni Medsede occaronapomanicca huada ssamoqquiri tiquinani. ");
INSERT INTO cul_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ajijaro imadsa tibodideni huatoji: Odsa jinedepa bobotide qquedsimahijinecca huada nahato tapodsapa pocca odsadsa botide qquedsima-jarahijine pocca odsa cacahuade nocco bissahitohuiraha ssamo taja najari. ");
INSERT INTO cul_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nema nadsapi tinajoramanehe timadimanaji. Madijapa ohua Madija Bedi ojajaroa occaronapomanicca huada ssamoqquiri nahi. Nidsa huatideni ajamama canadsa bacco onanipomanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","46","Jesopa ima onihi huati tajari: —Madija dsepe ssebotepa huaji tani toccahijine najoradsapa pocca dodosse ojariadsa huati tajari: “Occa madija tecahuabaqquina. Jipamanahijine maji bacco tadsapa taparideni da da titinabaqqui nana” najari. Nadsapa dsepe ssebote toccajari. —Nadsapa pocca dodosse nahato tadsa, ibora tadsapa madija ecahuabaqquihissa tahitohui, pina pohua dossede attissa inananitohui. Nama nadsapa dsepe ssebote ccanidsa qqui tadsapa pocca dodossedsa ima bicani inananitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nadsapi pajissara tiadenidsa huati onajaro: Madija dsepe ssebotepa pocca dodosse ibora tajaridsa ajama nahitohui: “Tiapi occa odsa, occa huidsaja, odsepetaji huapima tecahuaji” nahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","—Naraha dsepe ssebotecca dodosse tabaccora tadsapa pohua dossede attissa inana-jeranitohui. Pohua bodipa: “Ohua dossede najoccahi, qqui tajarahi” nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Nadsapa pohua dossedecca dodosse tabaqqui ohuahadeni ihinajidsobaqqui nahitohui. Nadsapa pohua naco noccodeni janoqquiri najaridenidsa quejemadsapa jipadera ccaridsadsapa coma tanicca naco dse dse nanaridsa nahitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pocca dodosse tabaccorabotepa pohua dossede ccanihicca maji, huada ssamo tadsa pohuatohui najora-jarahitohui. Nama nanaridsa nanaja dsepe ssebotepa bacco nanihitohui. ");
INSERT INTO cul_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Nadsapa pocca dodosse inajidsohuitohui. Dsoqquedsapa maidsajidede rabotedenihuaji inanahitohui. Nahihuajipa ocasserani ahua-dsanapodsapa pano todsahi nadsa oji oji nahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nadsapa Jeso madija denima mari icanabaqquijari: —Diocca cacahuehe tojadsapi pina ajijaro imassa nanitohui: Dsohuato 10 quinajaropi dsabisso dsohuato cacajirehicca jipaqquietohui najoramanadsapi ponidenicca jojororo equidiridsamanadsa dsabisso cajibote najari bacco ijidsamanahijine dsome jai tojajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naraha dsohuatodeni mota 5 quinehepi bodinideni huatonissa tejerajaro. Naraha dsohuatodeni mota 5 quinehepi bodinideni huatonissa tajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nadsapi dsohuato bodinideni huatonissa tejerajaropi ponidenicca jojororo iaccamanaraha ppejene jicadsa denima sso idsamanahijine dsojo quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Naraha dsohuato bodinideni huatonissa tajarodenipi ponidenicca jojororo iaccamanadsapa ppejene jicadsa denima sso idsamanahijine dsojo quinajari. ");
INSERT INTO cul_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nadsapi jai tojajaro, boronidsa bacco toquinaraha dsabisso cajibote najari najodsapa dsohuatodeni cahadijabote nadsapi nanidsa cahadijajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Naraha dsome nocconi tojadsana madija jadsirema huahua najari: “¡Dsabisso ccajonahi, ccajonahi! ¡Jai tijajonaji, bacco tijidsamanahijine!” najari. ");
INSERT INTO cul_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nadsapi dsohuatodeni huapima nocco toquejenadsa totehemamanadsapi ponidenicca jojororo denima ssiaja tahijine najoramanajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Naraha dsohuato bodinideni huatonissa tejerajaropi motadenidsa attinidenia: “Ticcadeni jojororo ppejene badsira taha iadsa da tiquinajo, icca jojororo ohuiridsabote nahi” quinajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Naraha dsohuato bodinideni huatonissa tajarodeni attinidenia: “Poni. Tiadenidsa badsira taha sso idsajarahi. Tiadenidsa, iadsa nadsapa pajira-jarahi. Dadahuaji jai tijaccaji, jojororo ppejene ohuaha mitta tiquinahijine” quinajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nadsapi mittade jai tojajaro. Naraha nanihuaji najomanadsapi aja dsabisso amoneje cajihijine bacco najonajari, cacajirehicca jipaqquiedsa toqquedsimajari. Nadsapi dsohuato bodinideni huatonissa tapojarodeni pohuadsa jai tojedsimajaro. Nadsapi noccobiji icahacossajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Naraha dsohuatodeni mota 5 quinehepi dadahuaji mittade najomanadsa dsotode bacco nanimanajaro. Amossinidsa domoni huadsa dsabisso cajibote najaridsa huahua quinajaro: “¡Ia, ia! ¡Jaijedsimanijine noccobiji ticanahabaji!” quinajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Naraha dsabissopa noccobiji icatabojidsa-jerani. Pohua attipa: “Tiadenidsa pajissa onocco jidsa tani. Occa madija tiquejena-jerani” najari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Nadsapa madija huapimadsa Jeso attipa: —Tibodideni huatonissa taji. Ohua occaninicca huada ssamoqquiri tiquinani. Maji naco ssamoqquiri tiquinani. Tinajoramanehe timadimanaji −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesopa ima onihi huati tajari: —Diocca cacahuehe tojadsapi pina ajijaro imassa nanitohui. Madija pocca benehi toccahijinepa pocca dodosse tabaqqui queriqquihijine huahua inabaqquijari. Queriqquidsapa pocca dsinirodsa dsepedeni ijimanahijine pohuadenidsa da inaridsajaro. “Aja occa dsiniro tinahapimanadsa nidsa occanidsapi ohuadsa nemanehe da tanimananijine” najari. ");
INSERT INTO cul_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pocca dodosse ojariapa dsiniro inahapinijine nahato tahissa tadsapa pohuadsa ccarara 5 mil nehe da inajaro. Ohuaha naco dsiniro inahapinijine nahato tadsapa pohuadsa ccarara 2 mil nehe da inajaro. Ohuahapa dsiniro inahapinijine ajamani nahato tadsapa pohuadsa ccarara 1 mil nehera da inajaro. Nadsapa dsiniro jinede pocca benehi toccajari. ");
INSERT INTO cul_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Nadsapa ccarara 5 mil nehe cajijaripa amadsati toccajari. Mitta, da, mitta, da naridsajari. Dsepe ijiridsahissa tadsapa 5 mil cajiporaha denima 5 mil cajijari. ");
INSERT INTO cul_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nadsapa ccarara 2 mil nehe cajijari najari naco mitta, da, mitta, da naridsajari. Dsepe ijihissa tadsapa denima 2 mil cajijari. ");
INSERT INTO cul_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Naraha ccarara 1 mil nehe cajijaripa nema inana-jerajaro. Najaripa pohua dossedecca dsiniro inajimanijine nami hui idsadsa ppa idsajaro. ");
INSERT INTO cul_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Dsiniro jinedepa huada huapi tadsa ccanijari. Bacco nanidsapa pocca dodosse tabaqquicca ima mittahijine pohuadenidsa huahua najari, poccadeni cuenta icattemanijine. ");
INSERT INTO cul_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nadsapa ccarara 5 mil nehe cajijari ccajonajari. Ccarara 10 mil nehe jinededsa da inanijaro. Pohuadsa da inanidsa pohua attipa: “Ohua dossede, ohuadsapi ccarara 5 mil nehe da tade. Naraha qqui taneje, odsepe ijiridsanissa tadsapi denima 5 mil nehe tojajaro” najari. ");
INSERT INTO cul_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Nadsapa dsiniro jinede attipa: “Jehe, tiapi occa dodosse ohuattidsa ibora tinajaro. Bica tinani. Tiadsa badsira tehe da onaporaha denima tojanijine dissera tinadsapi denima tiadsa da onanitohui. Tiqquedsimaji, etidsena” najari pocca dodossedsa. ");
INSERT INTO cul_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Nadsa pocca dodosse ohuaha ccarara 2 mil nehe cajijari ccajonajari. Pohua attipa: “Jehe, ohua dossede, ohuadsapi ccarara 2 mil nehe da tade. Naraha qqui taneje, odsepe ijiridsanissa tadsapi denima 2 mil nehe tojajaro” najari. ");
INSERT INTO cul_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Nadsapa dsiniro jinede attipa: “Jehe, tia naqui occa dodosse ohuattidsa ibora tinajaro. Bica tinani. Tiadsa badsira tehe da onaporaha denima tojanijine dissera tinadsapi denima tiadsa da onanitohui. Tiqquedsimaji, etidsena” najari pocca dodossedsa. ");
INSERT INTO cul_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Nadsa pocca dodosse ohuaha ccarara 1 mil nehe cajijari ccajonajari. Pohua attipa: “Ohua dossede, tiapi madijadsa daco tijirajaro. Tiapi tarabaidsa tejeraraha ticca dodosse tabaqquijine titicaji najaro. ");
INSERT INTO cul_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nadsapi tinoppine ocappinadsa nami hui odsadsa ticca dsiniro ppa odsajarode. Aja ticca dsiniro tiadsa da onanina” najari. ");
INSERT INTO cul_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Naraha dsiniro jinede attia: “¡Occa dodosse ibobote! ¡Tabaccora tinani! Tettipi ohuadsa: ‘Madijadsa daco tijirajaro. Tarabaidsa tejeraraha ticca dodosse tabaqquijine titicaji najaro’ taha. Naraha ohuadsa nahato tinadsapi occa dsiniro aji dsiniro ehecahuamana nanihuajina tinebodsa tohuapidsapi occanidsa denima ohuadsa da taninitohuiraha” najari dsiniro jinede atti. ");
INSERT INTO cul_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Nadsapa pocca dodosse tabaqqui ohuahadenidsa huati tajari: “Jari, occa dsiniro ccarara ibobotedsa da onapojaropi tidinimanaji. Tidinimanadsapi madija dsiniro ccarara 10 mil nehe cajijaridsana da tiquinaji. ");
INSERT INTO cul_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aja, cajijaripa pohuadsa denima, denima, denima tojadsapi huemani cajihitohui. Naraha ibobotepa badsira taha cajiraha pohua cajijaricca todininitohui. ");
INSERT INTO cul_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nadsama aja occa dodosse ibobotepa dsidsinihuaji coro tininemanajo. Nahihuajipa ocasserani ahua-dsanapodsapa pano todsahi nadsa oji oji nahitohui” najari dsiniro jinede atti −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesopa denima mari icanabaqquijari: —Ohuapi Madija Bedi ojajaroa nidsa occaronapomadsapi occa deni tojehe ossiejenema occaronapomanitohui. Diocca dodosse tabaqqui memehuajicca ohuadsa jahironahitohui. Nadsapi deni ojanicca huihuittari bicanidsa ohuittaridsa dosse dosse onanitohui. ");
INSERT INTO cul_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nadsana dsama huapimacca madija obaccohuaji queriqquihitohui. Nadsapa ohuana madija ocattejidsa-baqquihitohui. Pina edede cacahuadepa pocca edede icattejidsa-baqquijarissa onanabaqquihitohui. Edede cacahuadepa edede bicahi pohuadenira icattejidsabaqqui, edede jidsadsa cabra pohuadenira icattejidsabaqqui najari. ");
INSERT INTO cul_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pohua biji nahatonihuajipa edede bicahi pohuara. Pohua biji ssamohuajipa edede jidsadsa cabra pohuara inanabaqquijari. Ohua naqui madija ocattejidsa-baqquidsapa madija bicaqquiri najari Dio Pohua jipa tahicca inanamanajarodenipa obiji nahatonihuaji onanabaqquihitohui. Madija tabaccoraqquiri najari Dio Pohua jipa tahicca inanamana-jerajarodenina obiji ssamohuaji onanabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—Nadsapi ohua tamine ojadsa aja madija obiji nahatonihuaji domo huajaridenidsa huati onanitohui: “Nija, occa Abi tiadenidsa ima bicani inanaridsajaro. Pocca cacahuehe tiadenidsa tojani. Najaropi dsama nahato-jeraccadsama tiadenidsa najorapojaro. ");
INSERT INTO cul_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ohuadsa bicaqquiri tiquinadsapi opemidsa ohua titapamanade. Obacco dsaridsa ohuadsa passo da ticanamanade. Tiadenihuaji bacco onajonadsa ohuadsa tinoccodeni jidsaqquiri naraha: ‘Iadsa timadiccaji’ tiquinade. ");
INSERT INTO cul_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Etero ocappiradsa naqui ohuadsa da tiquinade. Coma onadsa naqui ohua qquide jajahi tijajona nade. Toponi cocorodsa ohuedsadsa naqui ohua qquide jajahi tijedsima nade” onanitohui pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Nadsapa aja madija bicaqquiri najarideni ohuadsa huati toquinahitohui: “Ia Medsede ¿nejecoma nadsa tipemidsa tiadsa dsamatapa da inajaritta? ¿Nejecoma nadsa tibacco dsaridsa tiadsa passo da icanajarotte? ");
INSERT INTO cul_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Nejecoma nadsa tiadsa inocco jidsa taraha, ‘Iadsa timadiccaji’ inajarotte? ¿Nejecoma nadsa etero ticappiradsa tiadsa da inajarotte? ");
INSERT INTO cul_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Nejecoma nadsa coma tinadsa tia qquide jaijedsimajarotte? ¿Nejecoma nadsa toponi cocorodsa tedsadsa tia qquide jaijedsimajarotte? Ssamomo inani” quinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nadsapi ohua tamine ojadsapi pohuadenidsa ohuatti ajima onanitohui: “Pajissara tiadenidsa huati onajaro. Aja madija occa tojajari ojaria tohuati nahana tajari acco ticamamanadsapa pina ohua acco ticamamanajarossa najaro” onanitohui, obiji nahatonihuaji domo huajaridenidsa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","—Naraha obiji ssamohuaji domo huajaridenidsapi ohuatti ajima onanitohui: “¡Aji ohuadsapi huajiji tinaji! Diopa tiadenidsa najidsohue inanajaro. ¡Jororoni jiquejeranihuaji jai tijaji! Najaropi pocca huadi Satanadsa, Satanacca dodosse tabaqquidenidsa najorapojaro. ");
INSERT INTO cul_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tiadenipi opemidsa ohua titapamana-jerade. Obacco dsaridsa ohuadsa passo da ticanamana-jerade. ");
INSERT INTO cul_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tiadenihuaji bacco onajonadsa ohuadsa tinoccodeni jidsaqquiri nadsa: ‘Iadsa timadiccaji’ tiquinejerade. Etero ocappiradsa naqui ohuadsa da tiquinejerade. Coma onadsa naqui ohua qquide jajahi tijajona nejerade. Toponi cocorodsa ohuedsadsa naqui ohua qquide jajahi tijedsima nejerade” onanitohui pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Nadsapa aja madija tabaccoraqquiri najaridenipa ohuadsa huati toquinahitohui: “Ia Medsede ¿nejecoma nadsa tipemidsa tiadsa dsamatapa da inajarajaritta? ¿Nejecoma nadsa tibacco dsaridsa passo tiadsa da icana-jerajarotte? ¿Nejecoma nadsa tiadsa inocco jidsa tadsa ‘Iadsa timadiccaji’ inejerajarotte? ¿Nejecoma nadsa etero ticappiradsa tiadsa da inejerajarotte? ¿Nejecoma nadsa coma tinadsa tia qquide jaijedsima-jerajarotte? ¿Nejecoma nadsa toponi cocorodsa tedsadsa tia qquide jaijedsima-jerajarotte? Ssamomo inani” quinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nadsapi ohua tamine ojadsapi pohuadenidsa ohuatti ajima onanitohui: “Pajissara tiadenidsa huati onajaro. Aja madija occa tojajari ojaria tohuati nahana tajari acco ticamamana-jaradsapa pina ohua acco ticamamana-jerajarossa najaro” onanitohui pohuadenidsa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Jehe, tabaccoraqquiri najaridenipa najidsohue jiquejeraniccadsa madimana-dsanapohuitohui. Naraha madija bicaqquiri najari Dio Pohua jipa tahicca inanamanajarodenina camittehe jiquejeranihuaji madimana-dsanapohuitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesopa madija mari icanabaqquia jicadsapa ia pohua huatimadedenidsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Nahatoqquiri tiquinani huada pama nadsapi ejete Pascoa tojanitohui. Ohuapi Madija Bedi ojajaroa nidsa najaro ejete tojadsapi todsepe ojanitohui. Ahua porimacossanidsa ohua inanadsoqque-mananijine −nade. ");
INSERT INTO cul_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nadsapa Jesodsa jiperaqquiri najarideni aja dada toqquimade taminedeni, jodiodeni ime jocohuideni tedseje poccadeni tamine deni tojajari onipa Caipa pocca odsa imenidsa queriqquimanajari. ");
INSERT INTO cul_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Nahidsa imahaha canajari: —¿Nejeco maidsehedsa Jeso todsepe tojadsa dsoqquehijine? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Naraha pohuadeni atti onihipi: —Ejete tojadsapi ima nohueraccanijine. Jesodsa madija jipaqquiri najarideni pohua dama inahi qqui toquinadsapa mohua mohua canarana −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesopa odsa capamema najaro onini Betaniahuaji madidsa Ssino pohuadsa huapi jadsidsi quiquinanajaricca odsadsa toqquedsimajari. ");
INSERT INTO cul_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nahi Ssinocca odsadsa jipade jassi inaridsa amoneje Jesodsa tohuajiressijaro, poni dsapanidsa siba onini alabastro nahatoni jojo bicahi dsojo inajonajari. Najari jojodsa majojo bicani huatini ccara tanicca dsojo icadsimajaro. Jesodsa bacco tadsapi tatidsa nemanehe sso inarijaro. ");
INSERT INTO cul_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Naraha Jesocca dodosse tabaqqui ia qqui inadsapi edijaro. Ettipi: —¿Nejecotohui majojo ponima inajicajaro? −inade. ");
INSERT INTO cul_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","—Najaro majojo nemanehe manaconidsa da icanadsa iadsa da inadsapi madija cappiramanajaridenidsa da iqquimanitohuiraha −inade. ");
INSERT INTO cul_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Etti nema inadsa Jeso mittadsapa pohua attipa: —Epeje tiquinaji. ¿Nejecotohui ponidsa tedimanajaro? Ponijine ohuadsa nema nadsapi bica tani. ");
INSERT INTO cul_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cappiramanajaridenina tiadenidsa madimana-dsanapohuitohui. Naraha ohuapi tiadenidsa omadidsanapo-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Aji majojo ohuassiredsa sso inarijaropi pina odsoqquedsa ohua ppa idsamananijinessa najaro najorapojaro −nade. (Jodiodenipa poccadeni madija dsoqquedsapa nama quiquinanajari.) ");
INSERT INTO cul_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","—Pajissara tiadenidsa huati onajaro: Dsama onihi, dsama onihidsa otahimari madija tocassiejerahijinecca ecomeramanadsapi aji otatidsa majojo sso inarijarocca ima naqui madija mittaridsamanahitohui. Nema nadsapi ponicca ima huatideni ajamamana-jarahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesocca dodosse tabaqqui 12 quinajari ojaria oni Joda Iscariotepa dada toqquimade taminedenidsa huatide toccajari. ");
INSERT INTO cul_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Pohua attipa: —Jari, Jeso tidsepedenidsa onanahijinepa ¿nejecoma nehe ohuadsa da tiquinanijine? −najari. Nadsapa taminedeni dsiniro ccarara plata 30 nehe huatini ccara tanicca Jodadsa da quinajaro. ");
INSERT INTO cul_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nadsapa toccanidsa pohua bodi najorajari. Jeso pohuadenidsa eccorahijine inoccodsaridsajari. ");
INSERT INTO cul_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Isaraeri potemahi jodiodenicca ejete imeni bacco tajaro, oninipi Pan ssaja tajarahicca. Najaro ejetepi huada 7 nehe jicanijine. Tahidecca huadadsa jipaqquie onini Pascoa ihinanamana najaro. (Pascoa ettidsapi: Dio tossoniqquimajari, inajaro.) Nadsapi najaro huadadsa Jesodsa ia pohua huatimadedeni huati inajaro: —¿Nejecohuaji Pascoacca jipaqquie tiadsa inajoranijine? −inade. ");
INSERT INTO cul_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Iadsa huati tajari: —Odsa pananihuaji otessecca odsadsa huatide jai tijapoji. Pohuadsa ajima tiquinana: “Ia Maride attipa: ‘Ohuadsa ima tojabote nani’ najari. ‘Nadsapa occa dodosse tabaqqui tedseje ticca odsadsa Pascoacca jipaqquiedsa edede bedi ijipaqquinijine’ napaja” tiquinana −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nadsapi Jesocca dodosse tabaqqui iapi Jeso pohua attissa inanajaro. Pascoacca jipaqquie dsome ijipaqquinijine inajorajarode. ");
INSERT INTO cul_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nadsapi najaro dsomedsa ia Jesocca dodosse tabaqqui 12 inajaro pohua tedseje huahuanaridsa ijipaqquinijine jassi inahuajanijarode. ");
INSERT INTO cul_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jipade iquejenanaja Jeso iadsa huati tajari: —Pajissara tiadenidsa huati onana: Aji tiadeni ojariaha ohua ccaccoradsapa todsepe ojanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pohua atti nama nadsapa ibodi qquedsadsa: —¿Ohua Medsede, aji ohuadsaqui? −inaridsajaro. ");
INSERT INTO cul_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nadsapa Jeso attia: —Madija ojariapa icca paratodsa pohua naco pocca pandsa depo apa, depo apa nahi. Najarina ohua ccaccorahitohui. ");
INSERT INTO cul_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Jehe, ohuapi Madija Bedi ojajaroa nidsa odsoqquenitohui. Pina maittaccadsama otedsejemacca ima Dio Atti cacomeraqquiri najarideni dsodo quinapojarossa onanitohui. Naraha ohua ccaccoradedsa oppina tehe tojanitohui. Jaho, najari maqquideje tossona-jaradsapa bica taraha, oppina tanicca dsori tahitohuiraha −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nadsapa Joda Iscariote, Jeso ccaccoradepa Jesodsa huati tajari: —Ohua Maride ¿ohuadsa tajarorane? −naraha Jesoa: —Jehe, tia tetti nema tajaropajia −nade. ");
INSERT INTO cul_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nadsapa jipade iquejenadsa Jeso pan idi nadsa Diodsa huati tajari: —Jehe, Abi Dio ticca daniji iadsa bica tahi −nade. Nadsapa pan icanarobedsa dside jai da, dside jai da inaridsade. Ia pocca dodosse tabaqquidsa huati tajari: —Aja, apa tiquinajo. Ajijaropi ohuemecca ima −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Dsotodepa dse inahijine dsedse equidi nadsa Diodsa huati tajari: —Jehe, Abi Dio ticca daniji iadsa bica tahi −nade. Nadsapa iadsa da icanadsa iadsa huati tajari: —Aja, dse taridsamanajo, tiadeni huapima. ");
INSERT INTO cul_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ajajari dsedsepa ohuemenecca ima. Dio madija tedseje jehe canirehijinecca ima tojanijine. Nidsa ohua odsoqquedsa ohuemene toccadsapi najaro jehe canireniji pajissa tojanitohui. Aji ohuemene toccajaropi madija huapimadsa ima bicani tojanijine. Najaropi madija huapimacca imasiri manaconi ohuadsa tojadsapi Diopa poccadeni imasiri epeje inananijine. ");
INSERT INTO cul_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ajijaropi tiadenidsa huati onajaro: Uva ppejene dse inajaripa dse onapoma-jaraccahitohui. Nidsa occa Abicca cacahuehe tojanissa tadsa tiadeni tedseje uva ppejene ohuaha dsatira dse inahitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pascoacca jipaqquie jicadsapi Diodsa jiri inade. Jiri inehe jicadsapi ssono Oribohuaji jaijemoranide. ");
INSERT INTO cul_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nahidsa bacco imoradsana Jeso iadsa huati tajari: —Ajijaro dsomepi tiadeni huapima ohua tinebomananitohui. Pina Dio Atti dsodo napojarossa nanitohui: “Nidsa edede cacahuade dsoqquedsapa pocca edede tojaribaqquihitohui.” ");
INSERT INTO cul_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Naraha ohuapi Diojine onahatoninitohui. Onahatonidsapi titedsejemadeni dsama arobeni Carireahuajina occaninitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Naraha Pedro attia: —Huapima tia inebomanaraha ohuapi tia onebo-jeranitohui −nade. ");
INSERT INTO cul_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nadsapa Jeso Pedrodsa: —Pajissara tiadsa huati onana: Tiapi ajijaro dsome tacara huahua najaraccadsa ohuadsa: “Onocco jidsa tani” tanitohui. Dsotode naqui: “Onocco jidsa tani” tapomanitohui. Dsotode naqui nema tapomanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Naraha Pedroa: —A, ohuapi nema onejeranitohui −nade. —Ima oppina tadsa naqui tiadsa: “Onocco jidsa tani” onejeranitohui. Tiadsama odsoqquenijine bica tani −nade Pedro. Ia pohua huatimade huapima naqui etti nema inade. ");
INSERT INTO cul_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nadsapa Jeso pohua inadsa ahua ppa naridsahi oni Jesemanihuaji jaijajaro. Nanihuaji bacco inadsapi ia pocca dodosse tabaqqui iquejenajaro, iadsa Jeso attipa: —Tiadenipi ajidsa jassi tinaccaji. Ohuapi ajiccadsa Abi Diodsa huati onaccana −nade. ");
INSERT INTO cul_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nadsapa pohua huatimade 3 quinaha jina inabaqquijari. Pohuadenipa Pedro, Sebedeo bedideni Huano, Satiaco quinajarideni pohuadsa denima jai tojajari. Nahidsana Jeso bodi qquedsadsapa ojibote najari. ");
INSERT INTO cul_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nadsapa pohuadenidsa: —Obodi ocassera tajarojine ohuatiabote-te canani. Tiadenipi ajidsa tibomanaccaji. Ohuadsama tinoccodeni bissaccana −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nadsapa Jeso tocca-cca nadsa pohua baccohuaji namidsa pona nadsa Imehidsa huati tajari: —Abi, aji ¿madija tocassiejerahijinecca ima onihi nohueraqui? Nohueradsapi epeje. Madija huapimacca imasiri manaconi najidsohue ohuadsa tojadsapi ocasserani ohuanitohui. Pina dsedse bidabote dse onanijinessa najaro. Najaro onahananijine jipera onaraha ohua jipa onanicca tohui onejerajaro. Tia jipa tinaniccana paji. Najarodsana ibora onajaro −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nadsapa pohua huatimadedenihuaji ccanijari. Bacco nanidsapa cahadijahira qqui tajari. Nadsapa Pedrodsa Jeso huahua najari: —¿Ticahadijajaroqui? ¿Dsome nocconi ocaja-jeraraha tinoccodeni bissade tipajiramana-jerajaroqui? ");
INSERT INTO cul_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ticahadija-jeradsa Diodsa huati tiquinaji, ima oppina tehe tojadsapi tijaparimanadsa ima tinanamana-jeranijine. Tibodidenipi ibora taraha tessiredenina mijira tajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nadsapa toccanipomadsa Imehidsa huati tapomadsa naco: —Abi, nahato tinani. Madija huapimacca imasiri manaconi ocasserani ohuanijine jipera onaraha tia jipa tinaniccadsana ibora onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nadsapa pohua huatimadedenihuaji ccanipomaraha cahadijahira qqui inabaqquijari, huada comani ahuamanaja nadsa. ");
INSERT INTO cul_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nadsapa inebobaqquipomadsa Diodsa huati tapomajari. Pina pohua huati tapohuissa najari huati tapomajari. ");
INSERT INTO cul_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nadsapa pohua huatimadedenihuaji ccanipomadsa Jeso attipa: —¿Tiadenipi ticahadija dsanaponijinequi? Ohuapi Madija Bedi ojajaroa jidapapi ohua ccaccoradejine imasiri cajimanajarideni dsepedenidsa ojanitohui −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nadsapa: —Jina, titehemamanaji. Ajana, jidapapa ohua ccaccorade ccajonahi −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jeso huati huati naccaraha Joda bacco najonajari. Jodapa Jesocca dodosse tabaqqui 12 quinajarideni ojaria. Pohuana madija huapi taha eccajonabaqquijari. Jadsirecca massito eccajonamana, huahuacca eccajonamana najaro. Pohuadenipa dada toqquimade taminedenicca dosseniji, ime jocohuidenicca dosseniji jahijonajari. ");
INSERT INTO cul_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jodapa Jeso todsepe inanahijine eccajonabaqqui-jaraccadsama taminedenidsa huati tapojari: —Nidsa pano mose onahitohui. Najarina dama tiquinahijine −napojari nade. ");
INSERT INTO cul_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Nadsapa huapima jahijonadsa bacco najonamanajari. Nanaja Joda Jesodsa tohuajiressi, pina pajissa pohuadsa bica tajarissa nadsa: —¿Nija ohua Maride? −nanaja pano mose inajaride. ");
INSERT INTO cul_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Naraha Jesopa Jodadsa: —Otesse, ohuadsa ima tinananijine ticcajonajaro. Nadsapi nema taji −nade. Nadsapa Jesodsa tohuajiressimanadsa dama quinajari. ");
INSERT INTO cul_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Naraha Jesocca madija ojariana massito dsoppa jeo, dada toqquimadedenicca tamine deni tojajaricca medse huaribo ca taneje tajo canajaro. ");
INSERT INTO cul_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Naraha Jeso najaridsa: —¡Paji! Ticca massito dso ticadsaniji. Jadsirecca massitodsa madija ijine ahuajaripa nidsa dsotode pohua naco jadsirecca massitodsa inanadsoqque-manahitohui −nade. ");
INSERT INTO cul_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","—Jaho ¿tibodi ssamo tajaroqui? Ohua jipa onadsa Abi Diodsa huati onadsapi pocca dodosse tabaqqui memehuajicca ohua acco icamamananijine pina soldadodenissa najari 72 mil quinaha dosse inaronabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Naraha nema onadsapi pina Dio Atti dsodo napojarossa onana-jeranitohui. Aji, ohuadsa ima oppina tanicca tojanijinepi maittaccadsama Diojine dsodo quinapojaro. ¡Epeje! Dio Atti nemanehe onapajiranissa tanijine. Ohua accodetohui huahua onejerana, onajaro −nade Jeso atti. ");
INSERT INTO cul_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nadsapa Jeso pohuatohui jahijonajaridenidsa huati tajari: —¿Nejecotohui tiadenipi ohua dama tiquinanijine jadsirecca massitoma, huahuaccama jai tijajonajaro? Nema tiquinadsapi pina bobotidetohui jai tijajonajarossa najaro. Nadsa tiadenidsama huajijiradsa Diodsa dada toqquimahuaji mari mari ohonanaraha ohua dama tiquinehe nejerade. ");
INSERT INTO cul_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Naraha epeje, ohuadsa ima tinanamananijinepi pina aji Dio Atti cacomeraqquiri najarideni dsodo quinapojarossa najaro tojanijine −nade Jeso. Naraha ia pocca dodosse tabaqqui huapimapi Jeso inebodsa idomo toccade. Nadsapa Jeso pohua motta ojari naha iaccanimanahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jeso dama quinadsapa tamine Caipacca odsahuaji iaccamanajari. Pohuapa dada toqquimadedenicca tamine deni tojajari. Nahidsa jodiodenicca marinaja maridedeni, jodiodeni ime jocohuideni huapima queriqquimanahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Naraha Pedropa huajima tohuanamissadsa dada toqquimadedenicca tamine deni tojajaricca boronidsa bacco todsimajari. Caipacca dodosse tabaqquidenidsama huittajari. Pohua bodipa: —¿Jeso nejecoma inanamanahijine? −najari. ");
INSERT INTO cul_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nadsapa dada toqquimade taminedeni, jodiodenicca ima cacattemadedeni deni toquejenajarideni tedseje Jesodsa ima inassonarimananijine tohuini quinadsa madija maidsehe huati toquinahijine tohui qqui naridsamanajari. Aja madija attidenipa: —Jesopa icca marinajadsa oppina tanicca inanapaja −quinadsa taminedeni: —Jehe, najaro imadsa Jeso dsoqquehijine pajirahi −quinahijine. ");
INSERT INTO cul_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Madijapa maidsehe onihi onihi huati toquinaraha najaro imadsa Jeso dsoqquehijine pajira-jerani. Poccadeni maidsehe najarossa naridsa-jerani. Oppina tanicca jerani. Dsotodecca madija pamahana poccadeni maidsehe najarossa najaro huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ojaria attipa: —Titaharibobo canaji. Jeso atti ajama nahi omittade: “Aji Diodsa dada toqquimacca odsa madija icanahatomanaraha ocatabodsapi huada 3 nadsa ocanahatoninitohui” nade pohua atti −nahi nade. Pohua tesse naco najarossa najaro huati tajari. Attideni nama quinaraha maidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nadsapa dada toqquimadedenicca tamine deni tojajari totehema, hua nadsa Jesodsa huati tajari: —¿Tiapi tia tecomajaroqui? Tiadsa ima inassonarimanajaropi ¿nejecoma naneje? −nahi nade tamine atti. ");
INSERT INTO cul_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Naraha Jesopa pohua cacoma najari. Nadsapa tamine huati tapomajari: —Dio camitta tajari onima huati tinaji onadsama iadsa tia tecomeraji: ¿Tiapi Dio Bedi Cristo-Mesia tijaqui? −nahi nade tamine. ");
INSERT INTO cul_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nadsapa Jeso: —Jehe, tiadeni ohuadsa nema tiquinajaropaji. Naraha tiadenidsa huati onajaro: Ohuapi Madija Bedi ojajaroa nidsa dsotode Dio Dacorabote ohua deni tonanadsapa Pohua inori nahatonihuaji ohuittarini qqui tiquinanitohui. Nidsa meme essenima occaronapomani qqui tiquinanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nanaja dada toqquimadedenicca tamine deni tojajaripa Jeso atti mittadsa huati jami nadsa pocca etero joca taneje sseo najaro. Nadsapa huapimadsa huati tajari: —¡Dio itamassojari! ¡Epeje! Jidapapi pocca ima nahatoto inani. Madija ohuahacca imatohui huati inejerana. Pohua attipa pina: “Ohuapi Dio ojani” najarissa naha. Pohua atti tabaccora tani timittamanani. ");
INSERT INTO cul_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Jari, tettideni ¿nejecoma tiquinani? −nahi nade Caipa. Naraha huapima: —¡Jehe, pohua atti nama nadsapa dsoqquena inajaro! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nadsapa Jeso panodsa ppito-to ppito-to canajari, idaqquimanajari, pohuadeni dsepedsa naco pano ppa inanimanajari nade. ");
INSERT INTO cul_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Jari, Cristo-Mesia tijadsapi ¿nejecojari tia idajari? ¡Tecomerajo! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jesopa odsa bodihuaji nanajidso tojaraha Pedropa amossinihuaji boronidsa huittajari. Nadsapi najaro odsacca medse dsohuato ccajonadsapi pohuadsa huati tajaro: —Tiapi Jeso Carireahuajicca huatimade tijadija −nani nade. ");
INSERT INTO cul_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Naraha huapima mittamanadsa Pedro pohua namaidsajari: —A, ohuapi onocco jidsa tani. Qqui onajarade. Najaro ima ssamo onani ohuapi −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nadsapa Pedro najaro boronicca qqueqquedsimahuaji toccadsa najaro odsacca medse onihi pohua qqui tadsa huapimadsa huati tajaro: —Ajajaripa Jeso Nasaretihuajiccadsa ccaridsadija −nani nade. ");
INSERT INTO cul_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Naraha Pedro pohua namaidsapomajari: —Dio nahato tahi pohuadsa onocco jidsa tani −napomahi nade. ");
INSERT INTO cul_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Naraha dsotodepa nahidsa toqueriqquijari attidenipa: —¡Pajissade! Tiapi Jesocca tijade. Carireahuajicca tohuatti ticajini −quinahi nade Pedrodsa. ");
INSERT INTO cul_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nadsapa Pedro huadijari. —Pajissa huati huati onejeradsapi Dio ohua tinajidsoji, onana. Pajissa tiadenidsa huati onajaroa: Najari madijadsa onocco jidsa tani −nahi nade. Nanaja tacara huahua naja najari. ");
INSERT INTO cul_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nadsapa Jeso atti Pedro bodi huatomanijari: —Tacara huahua najaraccadsapa tetti tinamaidsani 3 nanitohui −napojari. Aja Jeso atti Pedro bodi huatomanidsapa toqquenadsa ojijari nade. ");
INSERT INTO cul_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ssiajadsapi dada toqquimade taminedeni, ime jocohuideni tedseje queriqquimanadsa pohuadenira imahaha canajari. Jehe caniredsapa Jeso dsoqquehijine ima najoramanajari. ");
INSERT INTO cul_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Nadsapa Jeso biji jore quinadsa tamine Piratohuaji iaccamanajari, —Jeso dsoqquena −quinahijine. Tamine Piratopa romanodeni. Pohuapa jodiodenicca dsama cacahuade tojajari. ");
INSERT INTO cul_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jeso ccaccorade Jodapa —Jeso dsoqquehijine iaccamanajari −quinahi ima mittadsapa pohua bodi jabojo najari: —Jaho ¿nejecotohui Jeso ohuaccorajaritta? −najari. Nadsapa dada toqquimade taminedeni, ime jocohuideni, najarideni huapima dsiniro ccarara 30 nehe Joda pohuadsa da quinapojaro pohuadenidsa da inaninijine pohuadenihuaji toqquedsimanijari. ");
INSERT INTO cul_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Pohuadenidsa huati tajari: —Jaho, tabaccorehe onanajaro. Jesopa imasiri cappiraraha ojine tidsepedenidsa tojadsapa dsoqquehitohui −nahi nade Joda. Naraha pohuadenipa: —Epejea, ijine jerani. Ticca imasiripi ticca −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nadsapa poccadeni daniji ccarara 30 nehe Diodsa dada toqquima bodihuaji quissa inanijaro. Quissa inanie jicadsapi toccanijari. Dsotodepa pohuajine pohua mattodsa ssoque dsanadsa joppa taronadsa pohua nanadsoqquejari. ");
INSERT INTO cul_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nadsapa dada toqquimade taminedenipa najaro dsiniro ccarara inaccanimanadsa attidenipa: —Ajijaro dsiniro madija dsoqquehijine paca quinajariccapi Diodsa dada toqquimahuajicca dsinirodsa quejemanijine oppina tani. Najaro dsiniropi madija emene toccahijine manaconi −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nadsapa imahaha canaha jicadsapa najaro dsinirodsa dsama onini: Dsipa nanahatodecca quiquinanahihuaji mitta quinajaro, —Najaro dsamapi manahideni noccobirideni tojanijine −quinadsa. ");
INSERT INTO cul_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Naraha najaro dsamapi Jodadsa da quinapojarocca dsinirodsa mitta quinadsa najaro dsama onini cacanidsatipi: —Tohuemene manaconidsa mitta nanicca dsama −quiquinanajari. Aji ohua omadidsa ajijaro dsodode ojadsa naco madijapa nama quiquinanahipaja naccahi. ");
INSERT INTO cul_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Najaro dsama jodiodenicca taminedeni mitta quinajaropi pina maittaccadsama Dio Atti cacomerabote Jeremia dsodo inapojarossa najaro. Najaro imapi ajima najaro: —Isaraeri potemahideni mota attidenipa: “Jehe, dsoqquehijine eccorahi manaco dsiniro ccarara plata 30 nani pajirani” quinahitohui. ");
INSERT INTO cul_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Najaro dsiniro inaccanimanadsapi dsama onini: Dsipa nanahatodecca quiquinanahihuaji mitta quinahitohui, pina Dio ohuadsa huati tajarissa najaro −napohui nade Dio Atti Jeremiajine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tamine Piratohuaji Jeso iaccamanadsa nahi Pirato baccohuaji inahuamanajari. Nadsapa Pirato Jesocca ima mittahijine pohuadsa huati tajari: —¿Tiapi jodiodenicca tamine tijaqui? −najari. —Jehe, tetti nema tajaropaji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Naraha dada toqquimade taminedeni, ime jocohuideni tedseje Piratodsa poccadeni maidsehe huati toquinajari. Naraha Jesopa joma najari. ");
INSERT INTO cul_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nadsapa Pirato Jesodsa huati tajari: —Ticca ima bica tejerani quinajari ima huapi tani huati huati toquinaraha ¿timitta-jerajaroqui? −najari. ");
INSERT INTO cul_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Naraha Jesopa huati tajarajari. —Occa ima ohuacomerana −najarajari. Pohuadsa ima inassonarimanajarodsa naqui: —Pajissa jerani −najarajari. Nohuerahi. Nama nadsapa tamine Piratopa jabojo najari. Pohua bodipa: —¿Nejecotohui pohua cacomajari? −najari. ");
INSERT INTO cul_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Huajano huajijiradsa jodiodenicca ejete Pascoa tojadsa tamine Piratopa toponi cocorodsa madija huedsamanajari ojaria pohuajine qqueqquenamana najari. Madija huapima tohui quinajarina pohuajine qquenahijine najorajari. ");
INSERT INTO cul_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nadsapa toponi cocorodsa huedsajari ojaria onipa Baraba. Pocca ima tabaccora tadsa madija huapima pohuadsa nahatoqquiri najari. ");
INSERT INTO cul_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nadsapa Pirato pohuahuaji madija queriqquijonadsa pohuadenidsa huati tajari: —¿Nejecojarina qquenahijine tohui tiquinajaro? ¿Baraba qquenahijineco? ¿Jesodsa “Cristo-Mesia” quiquinanajari tappa onahijinerana? −nade. ");
INSERT INTO cul_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Piratopa pohua bodidsa Jesopa ima cappirahi nahato tapojari. Pohua bodipa: —Dada toqquimade taminedenipa Jesocca deni tojehe acconi huadimanadsa ohuadsa eccajonamanajari −najari. ");
INSERT INTO cul_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Piratopa ima cacattemahuajicca huihuittaridsa huittariccadsa pocca amoneje pohuadsa ima dosse inajonajaro. Poni attinipi: —Najari maqquidejepa bica tajari. Pohuadsa ima tinana-jerana. Dsomedsa Jesocca imajine occa huada oppina tapa −najaro. ");
INSERT INTO cul_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Naraha dada toqquimade taminedeni, ime jocohuideni tedsejepa Jesodsa ima inanamananijine najoramanajari. Madija huapimadsa huati naridsamanajari: —“Barabana qquenana” tiquinaji. “Jesopa dsoqquena” tiquinaji −naridsamanahi quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nadsapa tamine Pirato aja huapima domo huajaridenidsa huati tapomajari: —¿Aja pamaha todsepe toquejenajaripa nejecojarina ojine qquenahijine tohui tiquinajaro? −napomade. Nadsapa huapima johuahua johuahua canajari: —¡Barabana tijine qquenajo, qquenajo! −quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Naraha Piratopa domo huajaridenidsa huati tapomajari: —Jehe, naraha Jesodsa “Cristo-Mesia” quiquinanajaripa ¿nejecoma onanahijine jipaqquiri tiquinani? −nade Pirato atti. Naraha huapima johuahua johuahua canapomajari: —¡Najari Jesona ahua porimacossanidsa dsoqquena, dsoqquena! −quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Naraha nejecotohui dsoqquehijine? ¿Nejeco imara inanajaro? −nade Pirato atti. Naraha domo huajarideni huapima paja johua toquinarihi nadsa: —¡Ahua porimacossanidsa dsoqquena, dsoqquena! −quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Naraha Pirato pohua bodi huatojari: —Ohuatti pajira-jerani. Pohuadenijine mohuaniji oppina tehe tojabote nani −nade. Nadsapa Pirato pohua dsepe ssahua nahijine passotohui huahua najari. (Pohua dsepe ssahua najaricca imapi: —Ohuapi ima ocappirani −najarissa najaro.) Nadsapa passo dsojo icanajonamanadsa huapima qqui toquinadsa Pirato pohua dsepe ssahuade tojadsapa huati tajari: —Ajajari madija dsoqquehijinepi occa ima jerani. Pohua emene toccahijine jehe onejerajaro. Najaropi ticcadeni ima −nade Pirato. ");
INSERT INTO cul_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nadsapa madija huapima attidenipa: —¡Jehe, epeje! Ettijine dsoqquedsa pohua emene toccajaro manaconipi iadsa, icca ejedenidsa tojani bica tani −quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nadsa tamine Piratopa Baraba qquenahijine huati tajari. Nadsapa pocca soldadodeni Jeso cossi inaqquimanahijine icadossebaqquijari. Cossi inaqquimanaha jicadsapa icadossebaqquipomajari: —Ahua porimacossanidsa coba tidsanamanahijine tiaccamanajo −nade Pirato. ");
INSERT INTO cul_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nadsapa tamine Piratocca soldadodenipa odsa imeni bodihuajicca boronidsa Jeso iaqquedsimamanajari. Nahidsa romanodenicca soldado huapima toqueriqquijari. ");
INSERT INTO cul_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Pohuadenipa: —Jeso pina taminessa inanana −quinaraha maidsamanajari. Nadsapa Jesocca etero ssiti quinadsa etero macconi motaranicca pina taminedeniccassa najarodsa Jeso inehedsamanajari. ");
INSERT INTO cul_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","—Jeso taticca pina tamine tatideniccassa nana −quinaraha cotihi atinema jore nahuajanihira ettarimanajari. Pohua dsepe nahatonihuajiccadsa naco pina taminecca dsodsopissa naraha ahua ppahua tajarora da quinajaro. Nadsapa jaja icanaqquimanahijine pohua baccohuaji pohuadeni pitodsa jassi tadsapa: —¡Deni tijani jodiodenicca tamine! −quinaraha maidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nadsapa ppito inaqquimanajari. Pohua dsepecca ahua idinimanadsa najarodsa pohua tatidsa huacca huacca quinajari. ");
INSERT INTO cul_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nadsapa maidsehedsa pohuadsa jidsa jidsa quinaha jicadsapa etero macconi motaraniccapi ssiti quinadsa pohua pocca eterora inehedsanimanajari. Nadsapa ahua porimacossanidsa Jeso coba idsanamanahijine iaccamanajari. ");
INSERT INTO cul_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Soldadodenipa Jeso iaccamananaja dsama Sirenecca madija Ssino bacco ijidsamanajari. Jesopa ahua porimacossani dsojo inaraha ja tojadsa soldadodenipa Ssino icadossemanajari: —Manaco tia ajajaricca ahua porimacossani dsojo tinaji −quinadsapa manaco Ssinona dsojo inajaro. ");
INSERT INTO cul_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nadsapa ssono Cocottahuaji jai tojemora, bacco tomoramanajari. (Ssono onini Cocotta ettidsapi: Totati Tonanissa nani, quiquinanajari.) ");
INSERT INTO cul_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nahidsa uva ppejene bidabotedsa quejemahi Jesodsa da icanamanajari, —Pohua comene ojidsama nanijine −quinadsa. Naraha badsira taha ecatama, pohua nade. ");
INSERT INTO cul_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nadsapa ahua porimacossanidsa coba idsanamanajaride. Coba idsanamanaha jicadsapa acca icanamacossa-manajari. Nadsapa Jesocca eterotohui soldadodeni siba bedenidsa coro coro quinajaride, —¿Pocca etero nejecojaridsana tojanijine? −quinadsa. Najaro sibadsa ittomemanadsapa pocca etero pohuadenidsa ojari ojari naridsajarode. ");
INSERT INTO cul_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ittomemanaha jicadsapa nahidsa cacahuade jassi tajaride. ");
INSERT INTO cul_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jeso tati tetepihuaji naqui dsodo nani coba idsanamanajaro. Najaro dsodo nanipi: —Ajajaripa Jeso, Jodiodenicca Tamine −najaro. ");
INSERT INTO cul_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bobotide pamaha naco Jesodsama topamajonahijine ahua porimacossanidsa cobaba idsanamanade. Ohuahapa Jeso inori nahatonihuaji que, ohuahapa Jeso inori ssamohuaji que tade. ");
INSERT INTO cul_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Madija nahi jai tojeqquimajarideni Jesodsa jiperaqquiri nadsa tatamasso quinajari. Tatideni huide huide quinadsa attidenipa: ");
INSERT INTO cul_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Ajina, tettipi: “Diodsa dada toqquima ocatabodsapi huada 3 nadsa ocanahatoninitohui” teteje nade −quinade. —Jari, pajissa Dio Bedi tijadsapi tia tinassiajaji. Ahua porimacossanidsa tia tidinidsa ticcaronaji −quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nadsapa dada toqquimade taminedeni, jodiodenicca marinaja maridedeni, ime jocohuideni tedseje Jeso itamassomanajari. ");
INSERT INTO cul_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Attidenipa: —Ajana, madija ohuaha inassiajabaqquiraha pohua tonassiajadepa ssamo tahi. Pohuapa Isaraeri potemahidenicca tamine tojadsapa ahua porimacossanidsa ccaronana. Nadsana pohuadsa pajissa inanijine −quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—Ajana pohuapa Diodsa jehe nahissa tajari. Diopa pajissa pohuadsa huati huana tadsapa jidapanana pohua inassiajana, inajaro. Ajana, pohua attipa: “Ohuapi Dio Bedi ojani” nanaja nade −quinade, jidsa jidsa quinadsa. ");
INSERT INTO cul_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bobotidedeni naco pohua inoridsa ahua porimacossanidsa cobaba dsanaraha najaro tohuattissa najarodsa Jesodsa atti atti quinade. ");
INSERT INTO cul_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Maji itetepi tojadsa dsama nemanehe todsidsini najaro. Dsidsi dsanapojaropi maji 3 bacco tajaro. ");
INSERT INTO cul_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Najari maji 3ʼdsa Jesopa pohua attidsa jadsirema huahua najari: —Eri, Eri ¿rema sabatani? −nahi nade. (Najaropi: —Abi Dio, Abi Dio ¿nejecotohui ohua tinebojaro? −najari nade.) ");
INSERT INTO cul_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Naraha nahidsa domodeni huajari mittamanadsapa: —A, maittaccadsamacca Dio Atti cacomerabote Eriadsa huahua nahi −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nadsapa nahidsa domo huajari ojaria huassinaja joppa tajari, huassa tajari idi, uva ppejene ssicata bidada najaridsa edsippa, ppaja tojadsa bobadsa oro, da icanamacossajari. ");
INSERT INTO cul_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Naraha madija attidenia: —¡Maqui, nidsa padseje! Pohua inassiajahijine Eria ccajonahitidija. Qqui inaccana −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Naraha Jeso jadsirema johua napomadsapa huatiajari. ");
INSERT INTO cul_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Naneje Diodsa dada toqquima bodihuajicca huahuacossa etero sibabote naqui Diojine sseo naronajaro. Carobe najaro. Nami naqui dsadsa najaro. Siba imeni huihuitteri naridsajaro naqui caroberidsajaro. ");
INSERT INTO cul_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tonoccobiri mota naqui tohuabaridsajaro. Diodsa pajissa quinapojari jicapojarideni huapi taha Diojine nahatonimanahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nahatonimanadsapa pohuadeni noccobiridsa jahinineridsajari. Naraha dsotode Jeso nahatonidsana najaridenipa odsa panani Jerosarehuaji jai tojedsimanijari. Nahidsa madija huapima pohuadeni qqui inabaqquimanajari. ");
INSERT INTO cul_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nadsapa ssonohuaji soldado tamine, pocca soldadodeni tedseje Jeso cacahuade domo huajaridenipa nami dsadsa nani qqui, oppina tanicca huapima qqui toquinadsapa jabojo quinadsa attideni: —¡Jaho! Pajissa ajaripa Dio Bediraha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amonejedeni naqui huaji tanidsa cattade domoni huajaro. Ponidenipi Jeso dsama arobeni Carireadsa ccaridsapodsa pohua accode pohuadsa jahiridsajaro. ");
INSERT INTO cul_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ponidenipi huapi taraha mota oninidenina Maria Madarenahuajicca, Jose Satiacodenicca ami Maria, Sebedeo bedidenicca ami quinajaro. ");
INSERT INTO cul_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dsomebote nadsa dsepe ssebote oni Dsodsepa tamine Piratodsa huatide toccajari. Pohuapa odsa panani Arimateahuajicca madija. Pohuapa tahide Jesocca tojapojari. ");
INSERT INTO cul_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nadsapa tamine Piratodsa bacco tadsa Jeso assire ppa idsahijine huati tajari nade. Nadsapa Pirato pocca soldadodenidsa huati tajari: —Ajajari madijadsa Jeso assire da tiquinana, ppa idsahijine −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nadsapa nahi Jeso coba dsanaha que tahihuaji bacco toquinadsa Dsodsedsa Jeso assire da quinadsapa etero dsojorani onini lino bica tajarodsa jore inaqquidsapa dsojo inajari. ");
INSERT INTO cul_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nadsapa tonoccobirihuaji dsojo inajari. Najaro tonoccobiripi Dsodse dsama mitta inapodsa pohua noccobiri tojanijine tahide sibadsa hui quinapojaro. Najarodsa Jeso assire ibedsajari. Dsodse qquenadsapa siba imeni pata inanijaro, Jeso noccobiridsa huacossanijine. Nadsapa Dsodse toccanijari. ");
INSERT INTO cul_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Naraha Maria Madarenahuajicca, Maria onihi tadsajanipi ibomanadsa Jeso noccobiricca siba huacossanihuaji tocattanimanadsa pahimaccajaro. ");
INSERT INTO cul_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nadsapi huada ssiaja, jassinajacca huadadsa dada toqquimade taminedeni, marinaja pariseodsa jehe quinajarideni tedseje tamine Piratodsa huatide jai tojapomajari. ");
INSERT INTO cul_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Bacco toquinadsapa attidenia: —Ia dossede, ibodi huatomajaro, aja maitta maidsajide rabotepa dsoqque-jaraccadsama pohua attipa: “Nidsa odsoqquedsapi huada 3 nadsa onahatoninitohui” nanaja nade. ");
INSERT INTO cul_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nama nadsapa pohua noccobiri ecahuamananijine ticca soldadodeni dosse tinabaqquijo, dsepedeni panahissa tadsa huada 3 nehe ecahuamananijine. Nama quinadsapa pocca dodosse tabaqqui dsome Jeso assire idinemana-jarahijine. Idinemanadsapa madija huapimadsa maidsamanadsa: “Jeso nahatonihi” quinarana. Jeso pohua madidsa naco maidsa maidsa napojari. Pocca dodosse tabaqqui madija huapimadsa: “Jeso nahatonihi” quinadsapa maidsanijirideni denima tabaccora tarana −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Nadsapa Pirato pohuadenidsa: —Jehe, Jeso noccobiri cacahuade soldado jai tojahijine dossede jipa onani. Tiaccabaqquimanajo, pohua noccobiri mohua quina-jarahijine soldadodeni dsepedeni panahijine −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nadsapa taminedeni soldadodeni tedseje jai tojadsapa siba imenibote huittacossanicca jore nani dsepedeni panahissa tadsapa: —Epejena. Dicca nanijine ssamo tani −quinahi nade. Nadsama jore nani idenidsa modsa nepi quinadsa najaro nepi nadsa tojano niqui todsanajaro. (Najaropi dicca nadsa bararini ahuato tanijine.) Nadsapa taminedeni soldadodeni inebobaqquimanadsapa jai tojanijari. ");
INSERT INTO cul_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nadsapi jassinajacca huada jicani nattini semana tojapomanicca huada tahidecca domingo ssiajajonadsa Maria Madarenahuajicca, Maria onihi tadsajani Jeso noccobirihuaji qquide tohuedajaro. ");
INSERT INTO cul_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tohuedaneje... nami jadsirema dsadsa najaro. Aji nami jadsirema dsadsa najaropi ia Medsede Diocca dodosse memehuajicca ccaronajari. Ccaronadsapa Jeso noccobiricca siba pata inajaro. Nadsapa najaro sibadsa huittari canahi quinade. ");
INSERT INTO cul_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pohuapa ssiaja tajari pina ssissiede ssiajanissa najari. Pocca etero nopo tajaro pina huepessa naraha denima nopo tajaro. ");
INSERT INTO cul_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldadodeni najari qqui toquinadsapa pohua noppine cappinamanadsa tacca-cca-cca quinajari. Nadsapa pina cacotajarissa quinajari. ");
INSERT INTO cul_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Naraha Diocca dodossepa amoneje huedajonajarodenidsa huati tajari: —¡Tiadenipi ticappinamana tejeraji! Jeso qquide ticadajonajaro nahato onani. Pohuapa ahua porimacossanidsa inanadsoqque-manajari. ");
INSERT INTO cul_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Naraha ajadsa podsa-jarahi. Pohuapa nahatonipa. Pina pohua dsoqque-jaraccadsama “onahatoninitohui” nanaja napojarissa najari. Jari, pohua podsahihuaji qquide ticadedsimaji. ");
INSERT INTO cul_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nadsapi huassinaja ticadanidsa pocca dodosse tabaqquidsa huati tinanimanaji: “Jesopa nahatonihi” tiquinana. Pohuapa titedsejemadeni dsama arobeni Carireahuaji toccanipohuitohui. Nanihuaji jai tijanidsana pohua qqui tiquinahijine. Epejeni najaro ima tiadenidsa huati onaponi −nahi quinade. ");
INSERT INTO cul_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nadsapi Jeso noccobirihuaji nebomanadsa huassinaja Jesocca dodosse tabaqquidsa huatide dsaja tanijaro. Cappinamanaraha huatidsemaneri tanijaro. ");
INSERT INTO cul_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dsaja taniraha nahi jahuidsa Jeso ponidenidsa ahuatomadsa: —Nija −najari. Nadsapi pohuadsa tohuedessidsa huatidsemanadsa ponideni pitonidsa pahimadsa pohua issodsa cahuajocossamana nadsa: —¡Ia Medsede, deni tijani! −quinani nade. ");
INSERT INTO cul_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Nanaja Jesopa: —¡Ticappinamana tejeraji! Ticadanidsapi ohuemecotedenidsa huati tinanimanana: “Dsama arobeni Carireahuaji jai tojanina. Nanidsana ohua qqui toquinahijine, napaja” tiquinana −nahi nade Jeso ponidenidsa. ");
INSERT INTO cul_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mariadeni tohuedanije naraha Jeso noccobiri cacahuade soldadodeni mota naco dada toqquimade taminedenidsa huati tanimanahijine odsa pananihuaji domo toccanijari. Aji nami dsadsa najarocca ima, Diocca dodosse memehuajicca siba pata inajarocca ima naqui, najaro ima huapima soldadodeni qqui toquinajaricca huati tanimanajari. ");
INSERT INTO cul_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Naraha dada toqquimade taminedeni najaro ima mittamanadsapa ime jocohuideni tedseje queriqquimanadsa imahaha canajari. Jehe caniredsapa dsiniro huemani soldadodenidsa da inabaqquiridsajaro, pajissa pohuadeni qqui toquinajaripa ecomamananijine. ");
INSERT INTO cul_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Aji tiadenidsa dsiniro da inabaqquijaropi maidsehera huati tiquinanijine. Ajima tiquinaji: “Dsome icahadijadsa Jesocca dodosse tabaqquipa Jeso assire idinimanajari” tiquinaji. ");
INSERT INTO cul_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nadsapi najaro ima ticcadeni tamine Pirato mittadsapa tiadenidsa huadihitohuiraha ia pohuadsa huati inanissa tadsapi tiadenidsa tojonehitohui −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nadsapa soldadodeni dsiniro cajimanajaridenipa taminedeni attidenissa inanamanajaro. Najaro poccadeni maidsehepi icca madija jodiodeni motadenidsa tojaridsanissa tajaro. Aji ohua omadidsa ajijaro dsodode ojadsa naco najaro maidsehe motadenipa huati huati quinahi paja naccahi. ");
INSERT INTO cul_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nadsapi ia Jesocca dodosse tabaqqui 11 inajaro Carireahuaji jaijanijaro. Pina tahide amonejedenidsa Jeso huati tapojarissa inanajaro. Jeso attipa: —Najaro ssonohuaji jai tijemorana −nadsa najaro ssonohuaji jaijemorajaro. ");
INSERT INTO cul_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bacco imoradsapi Jeso qqui inajari. Qqui inadsapa pohuadsa etidsedsa: —¡Tiapi deni tijani, tiapi nahatonie jinede tijani! Aja tiassa najari ohuaha nohuerahi −inade. Naraha mota bodidenipa: —¿Pajissa Jeso nahatonijarico? −quinajaride. ");
INSERT INTO cul_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nadsapa Jeso dsaboradsa iadsa huati tade: —Abi Diopa pocca nahatohue huapima memehuajicca, namihuajicca naco ohuacahuaridsahijine pocca dacorehe ohuadsa inanajaro. ");
INSERT INTO cul_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nema nadsapi dsama huapimadsa otahimari maride jai tijaridsaji. Madija ohuadsa toquejenahijine maride disseraqquiri tiquinaji. “Jehe, Jesodsa iquejenana” quinadsapa Abi Dio onima, ohua Dio Bedi ohua onima, Dio Corime onima passodsa topa topa titidsanabaqquimana nana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aji occa marinaja tiadeni onahattabaqquijaro nemanehedsa iboraqquiri nahijine naco mari mari titicanabaqqui-ridsamana nana, onajaro. Ohuapi huada huajijiradsa tiadenidsa ohomadiridsa nanitohui. Nema odsanapojaroa dsama jicani bacco tanitohui −nade Jeso. Epejeni.");
INSERT INTO cul_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ajijaro ima bicanipi Dio Bedi Jesocristo tahimari icassiejeranijinecca. Pohua tahimari madija huapimadsa tojaridsanijine ajima najaro: ");
INSERT INTO cul_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Maittaccadsama Dio Pohua Bedidsa huati tapojarissa najaro Pohua Atti cacomerabote Isahia dsodo inajaro. Dio Attipa: —Tahide titahimari tohuaccade madija ojaria titedsejema dosse onapohuitohui. Nahi mittamanadsa madija bodidenipa titohui najoramanapohuijine, onajaro −napohui nade Dio. ");
INSERT INTO cul_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","—Najarina dsama huamoni ssono caji, siba caji tanihuaji madidsapa atti mohui taha madija huahua huahua ihinajonabaqqui nahitohui. Pohua attipa: “¡Ia Medsede ccajonabote nahi! ¡Tinajoramanaji! ¡Pohua tedsejema jahui tijinedeni tobicapoji! Najaroa aji tibodideni pohuatohui tinajoramanaji” nanaja nahitohui dsama huamonihuaji madijaripa −napohui nade Dio. ");
INSERT INTO cul_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Najaria aja madija oni Huanopa dsama huamoni ssono caji, siba caji tanihuaji madija maride tojajaripaja. Pohuadsa: Baotista, quiquinanajari. (Ettidsapi: Totopade, inajaro.) Pohua attipa: —¡Ticcadeni imasiri tineboridsamanaji! −nanaridsa najari. —Tibodideni ajima tiquinaji: “Occa imasiri onebona. Jidapapi Diotohuira odsanapona” tiquinaji. Nadsana totopa ticajiridsamanaji. Nema tiquinadsapi Dio ticcadeni imasiridsa: “Epeje, ohuati ajimani” nahijine −nahi nade Huano. ");
INSERT INTO cul_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Madija huapima Huano atti mittamanahijine jahijonana canajaridenipa odsa panani Jerosarecca, Jodeacca dsamadsa madiridsamanajarideni huapima bacco bacco najonamanajari. Poccadeni imasiri Diodsa ecomeramanadsapi Huanopa hueni Jordaodsa topa topa ihidsanabaqqui najari. ");
INSERT INTO cul_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nadsama Huanopa dsama huamonihuaji madidsapa pocca eteropi camello cone ba nani ssequi nadsa huedsajari. Pocca ssoquepi bani etero. Pohua taparipa sese, dsamacca jidsi oquine najari. ");
INSERT INTO cul_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Huano mari icanabaqquidsa ajijaro ima huati tajari: —Madija dacorajaripa ccajonabote nahi. Ohuapi tahide mari mari onaporaha aja dsotodecca mamaride ccajonajarina deni tojajari. Ohuapi ajimani ojani. Pina pocca medsessa onanijinepi opajira-jerani. Pohua amoricca sadaria diccade naqui opajira-jerani. ");
INSERT INTO cul_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ohuapi passodsa tiadeni topa odsanabaqquijaro. Naraha aja ccajonabote najarina Dio Corime tibodidenidsa madihijine tiadenidsa inanaridsahitohui −nahi nade Huano. ");
INSERT INTO cul_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nadsapa Jeso dsama arobeni onini Carireacca odsa Nasaretidsa madiraha hueni Jordaohuaji qquedsippajari. Bacco dsippadsapa Huano Jeso topa idsanajari. ");
INSERT INTO cul_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nadsa Jeso passodsa totehemadsa tocattamacossa nanaja meme tohuaba najaro. Dio Corime ahuato taha pina midsorissa naha Jesohuaji ccaronajari. ");
INSERT INTO cul_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Bacco naronadsapa memehuaji atti mittaronajari: —Tiapi occa ejedeni. Tiadsa ohuati huana tajaro. Ticca ima bica tajarojine ohuatidsejaro −nahi nade Dio. ");
INSERT INTO cul_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Huano Jeso topa idsanaha jicadsapa Dio Corime Jeso iaqquemorajari, dsama huamoni ssono caji, siba caji tanihuaji madihijine. ");
INSERT INTO cul_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jeso madihi inoridsapa bani huadi tahicca caji tajari. Nahidsa Jeso huada 40 naha madidsana imasiri totonanade Satanapa Jeso nattome inajari. Pohuapa Jeso imasiri inananijine dissera taraha Jesopa Satana attidsa jehe najarajari. Nadsapa Diocca dodosse tabaqqui memehuajicca Jeso acco icamamanajari. ");
INSERT INTO cul_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Naraha Huano Baotista toponi cocorodsa coro idsimamanahi nattipa Jeso dsama arobeni Carireahuaji toccanijari. Nahihuaji Diocca ima bicani icassiejeranijinecca mari icanabaqqui-ridsajari. ");
INSERT INTO cul_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Pohua attipa: —Jidapapi Diocca cacahuehe iadsa bacco najonabote nani. Pina Dio huati tapohuissa najaro. Ticcadeni ima Diodsa tecomeramanadsa ticcadeni imasiri tinebomanaji. Diotohuira tidsanapomanaji. Diocca ima bicani ticassiejeranijineccadsara jehe tiquinanissa taji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jeso Carireacca coridsa inidi toccabacossadsa Ssino, pohua ohuaha Adiri tedseje qqui inabaqquijari. Pohuadenipa aba cocorodedeni. Aba corode toquejenaraha Jeso bacco najonajari. ");
INSERT INTO cul_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pohuadenidsa huati tajari: —Jina, ohuadsa ticadaridsaji, ohuatimade tiquejenadsapi tiadeni onahattabaqquinijine. Tahidepi abadsa tidsepedeni ijimanaporaha jidapapi madija ohuadsa toquejenahijinena tidsepedeni ijimananitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Najaro ima mittamananaja poccadeni tajapa icanebomanadsa Jesodsa tohuedajari. ");
INSERT INTO cul_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nadsapa denima jai tojabacossanaja Jesopa Sebedeo bedideni Satiaco, pohua imecote Huano tedseje qqui inabaqquijari. Poccadeni tajapa ssequinimade canoadsa jassi dsajari. ");
INSERT INTO cul_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nadsapa Satiaco Huano tedseje Jeso huahua inabaqquijari. Najarideni naco amadsati poccadeni abi Sebedeo, pocca tatarabaidsadedeni tedseje canoadsa jassi dsadsa inebobaqquimanajari. Nadsapa Satiaco, Huano tedseje Jesodsa tohuedajari. ");
INSERT INTO cul_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nadsama Jesopa pohua huatimadedeni tedseje Capernaohuaji bacco toquinajari. Nahidsa jassinajacca huadadsa Dio Atti mamarihuaji jai tojedsimadsa Jesopa madija mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nadsa mittamanadsapa: —A, pocca marinaja bica taha −quinahi nade. Jeso pocca marinaja mari icanabaqquidsapa pohuana nahatojide rajari, atti caji tajaria. Aja jodiodenicca marinaja maridedeni attissa najarajari. ");
INSERT INTO cul_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nadsapa Dio Atti mamarihuaji madija pohua bodidsa Satanacca dodosse tocorime cajijari naco huittarijari. Jeso qqui tadsapa pohua bodiccajine jadsirema atti atti najari: ");
INSERT INTO cul_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¡Nasaretihuajicca Jeso! ¿Nejecotohuira ticcajonajaro? ¿Icca ima tinajicanijine ticcajonajaroqui? Ticca ima nahato onani. Tiapi Diocca Ejedeni Bicabote tijani −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Naraha joma nahijine Jesopa atti dacoradsa huati tajari: —¡Epeje! ¡Didi taji! ¡Najari madijadsa tiqquenaji! −najari. ");
INSERT INTO cul_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nadsapa tocorimejine najari madija tohuedimadsapa pitora pitora najari. Nadsapa jadsirema johua johua nadsapa pohua bodicca qquenajari. ");
INSERT INTO cul_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nadsapa qqui toquinajaridenia huajo caniredsapa: —A ¿nejecoma najari? −naridsamanahi nade. —Jesocca marinaja pina dsatissa naha. A, atti cajidsa dosse imaha −quinajari. —Tocorime cajijari pohua bodicca Jeso attidsa ibora taha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nadsapi Jesocca ima amadsati tojaribaqquijaro. Carireacca dsama pohuadeni inoricca huajirema nahicca madiridsamanajarideni naco pohua tahimari mittaridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nadsapa nani jodiodenicca Dio Atti mamarihuaji jahininedsapa Jeso, Satiaco, Huano quinadsa Ssino, Adiridenicca odsahuaji jai tojedsimajari. ");
INSERT INTO cul_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nanidsapi Ssino massodini coma tehe, huapini ppocorehe pori canajaro. Naraha nahidsa jai tojedsimadsapa amadsati ponicca dsamacoma tahimarini Jesodsa huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nadsapa Jeso ponidsa tohuajiressidsa dsapani equidi, joca imadsapi huapini tonahuihui najaro. Tonomidsapi pohuadeni inajipabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nadsapa maji tonahuidsa madija comaqquiri najarideni, aja madija bodidenidsa Satanacca dodosse tocorime cajimanajarideni naco eccajonabaqquijari nade. ");
INSERT INTO cul_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nadsapa nahicca madija huapima madiridsamanajarideni Ssino, Adiridenicca odsacca noccobijidsa queriqquimanajari. ");
INSERT INTO cul_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Naraha Jesopa comaqquiri najarideni huapima comani onihi onihi cajiridsamanaraha inanomibaqquijari. Tocorime huapi taha naco dosse ininebaqquijari. Pohuadenipa Jesodsa nahatoqquiri naraha Jeso pohua tahimari ecomeramananijine jipera tadsapa didi inanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nadsapa ssiajaricossadsa Jeso totehema, odsa pananidsa toqquenadsapa madija madide nohuerahihuaji toccajari, Diodsa huati tahijine. ");
INSERT INTO cul_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dsotodena Ssino-Pedro pohua tessedeni tedseje Jesotohui qqui naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bacco quinadsapa: —Huapima tia qquide jahijonapomapaja −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Naraha pohuadenidsa huati tajari: —Jina, odsa onihihuajina jaijana. Odsa onihicca, odsa onihicca mari ocanabaqqui-ridsahijine occaronajarode −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nadsapa dsama Carireahuaji ccaridsa ccaridsa naridsajari. Nani Isaraeri potemahi jodiodenicca Dio Atti mamari onihi onihi naridsanihuajicca mari icanabaqqui-ridsajari. Madija bodicca tocorime qquenaridsahijine naco dosse dosse ihinineridsa najari nade. ");
INSERT INTO cul_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nadsapa madija dsamacoma onini leprajine huapi jadsimarohi Jesodsa ccajonajari. Pohua bodipa: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta nadsa Jesodsa huati tajari: —Ohua Medsede, ohuapi bica onejeraraha tia jipa tinadsapi ohua tinanabicanijine nahato tinani −najari. ");
INSERT INTO cul_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nadsapa Jeso pohua bodidsa: —Tohuati nahana tahi −nadsa pohua dsepedsa bara inadsa: —Jehe, jipa onani. Tibicaji −najari. ");
INSERT INTO cul_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nanaja amadsati pohua huapicca tomossissi nadsapa tobicajari. ");
INSERT INTO cul_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Nadsapa Jeso pohua dosse inajari. Pohua tobicahicca ima madija ohuahadenidsa huati naridsa-jarahijine naco pohuadsa huati tajari. ");
INSERT INTO cul_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jeso attipa: —Aji tibicanicca ima madijadenidsa huati taridsa tejerana −najari. —Naraha Diodsa dada toqquimahuajina ticcaji, onajaro. Nanidsa tiqquedsimadsapi dada toqquimade ojariadsara tepi tobicani tia nohue tinaji. Nadsapi Diodsa ticca ima bica tejeranicca toppineradsapi ticca daniji Diodsa tojanijine ohuaha ohuaha naha pina edede, ppiriri, oqui najari da da tidsimana. Pina Moisesicca marinajadsa iboraqquiri inajarossa tinanaji, onajaro. Nadsapi huapimadsa ticca ima toppinerani ahuato tadsapi: “Pajissa tibicajaro” quinahijine, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Naraha aja tobicajaripa toccajari, Jeso pohua inanabicahi tahimari huati naridsajari. Najarojine Jeso pocca nomietohui madija disseraqquiri nadsapa odsa panani onihi, onihidsa totoqquedsima najarajari Jeso, pohua qqui toquinahi noppine. Nama nadsapa madija madide nohuerahihuajina ccaridsa ccaridsa najari. Naraha madija huapimapa nama naha pohuatohui quinadsapa jajahi toja najari pocca nomietohui. ");
INSERT INTO cul_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nahidsa Jesopa madi madi nanaja odsa panani Capernaohuaji toccanipomadsapa bacco tanijari. Nadsapa madija: —Jeso odsadsa bacco nanihi −quinahi ima mittaridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nadsapa pohuatohui queriqquimanadsa poccadeni odsa boronima, odsa bodima ijiridsa najari. Nadsapa Jeso Dio Atti mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nadsapa madija ide tone biqueradsa isso ssomi tojahipa pohua taborodsa dsojo icanajonamanajari. Pohua tesse ahuaji pama, ahuaji pama najonamanahi nade. ");
INSERT INTO cul_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Naraha madija siba tadsapa Jeso bacco quinahijine pajiramana-jaradsa odsa tetepihuajina iaccamaromanajari. Jeso huedsahi tetepidsa odsa icatabojidsamanajaro. Nahidsana madija ssomi tojahi pohua taborodsa poridsa odsa bodihuaji tappa icanaronamanajari. ");
INSERT INTO cul_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jeso pohuatohui dissessera tahi qqui tadsapa pohua bodidsa nahato tajari: —Pajissa, Jesopa madija inanomihijine nahato tahi −quinahi Jeso pohuadsa ahuato tadsapi coma tajaridsa huati tajari: —Otesse, aji imasiri tinanajaro huapimapi onanamossini. Jidapapi ticca ima Diodsa tobicani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Naraha nahidsa jodiodenicca marinaja maridedeni naco jassi tariridsajari. Pohuadeni bodipa: ");
INSERT INTO cul_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—Apaja, Jesopa: “Imasiri onanamossina” naha. Pohua attipa: “Ohuapi pina Dio ojani” nanaja najarissa naha. ¡Jesocca imapi bica tejerani! ¡Pina Dio itamassojarissa nahi! Naraha Dio Pohuana ojarijari imasiri inanamossinijine −quinahi nade jodiodenicca marinaja maridedeni. ");
INSERT INTO cul_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nama quinaraha Jesopa pohuadeni bodidenicca ima nahato tadsapa pohuadenidsa huati tajari: —¿Nejecotohui tibodidenidsa nema tiquinajaro? −najari. ");
INSERT INTO cul_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","—Jari, tibodideni huatoma-manaji ¿nejecoma najaro imana tiadenidsa denima najora tani? Aja madija coma tajaricca imasiri onanamossini ¿najora taqui? Coma tajari onanabicahina ¿denima najora tajarorane? ");
INSERT INTO cul_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aji ohua Madija Bedi ojajaropi tiadenidsa occa ima ahuato onanana. Madijacca imasiri onanamossinijine Diocca dacorehe ocajini. Aji namidsa naqui ohuatti ocajini nahatoqquiri tiquinanijinepi coma tajaridsa huati onana −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nadsapa madija ssomi tojahidsa huati tajari: —Tiadsa huati onadsa: ¡Titehemaji! ¡Titaboro tididsa ticca odsahuaji ticcaniji! −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nadsapa totehema, madija huapima cattomama canaraha amadsati pohua taboro idi nadsa pocca odsahuaji toccanijari. Nadsapa madija huapima cappinamanaraha huatidsemanadsapa: —A, ¡Diojine bica tani! −quinajari. —Nema nani qqui qqui inejeraccade −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeso coma tajari inabiquemanihi nattipa coridsa poni huapihuaji toqquedsippapomajari. Madija sibema pohuadsa queriqquimanadsapa mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nahidsa Jeso denima toccadsapa madija oni Rebi qqui inajari. Najaripa Arapeo bedi. Pohuapa romanodenicca taminecca dosseniji dsiniro ihinaccamana nanihuajicca odsa bedeni bodidsa huittidsajari. Nadsapa Jeso pohuadsa huati tajari: —Jina, ohuadsa ticcaji −nadsa Jesodsa toccajari. ");
INSERT INTO cul_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nahi dsotodepa Rebi tadsarihuaji Jeso tedseje jipaqquimanahijine madija huapi taha huahuanaridsa jassi nahuajanijari. Nahidsapa romanodenicca taminecca dosseniji dsiniro nanaccadedeni, jodiodenicca marinaja ecahuamana-jerajarodeni naco Jeso pohua huatimadedenidsama jassi nahuajanijari. Najarideni Jesodsa jahiridsajaripa huapi tahi. ");
INSERT INTO cul_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Naraha jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe quinajaridenipa madija bicaqquiri najarajarideni Jeso tedseje jipamanahi qqui toquinajari. Najaro imadsa jiperaqquiri nadsapa Jeso huatimadedenidsa atti atti quinajari: —A ¿nejecotohui tia maridepa romanodenicca taminecca dosseniji dsiniro nanaccadedeni tedseje, imasiri cajimanajarideni tedseje jipajari? −quinajari nade. (Aja madija nama najarideni tedsejepa jipade oppina tani quiquinanajari.) ");
INSERT INTO cul_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Naraha Jeso pohuadeni attideni mittadsa manaco Jeso huati tajari: —Nomiqquiri najaridenipa toponi totonanomide tohuini quina-jararaha comaqquiri najaridenina toponi totonanomide tohuini quiquinanajari. Ohuapi pina toponi totonanomidessa onajaro. Madijadenicca ima Diodsa tobicanijine pohuadeni accode occajonajarode. Naraha madijapa: “Iapi bicaqquiri inani” quiquinanajaridenicca ima onanabicanijine occajona-jerajaro. Imasiri totonanadedenicca ima onanabicanijinena occajonajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Huano Baotistacca mamari tabaqqui jipehe nebocossamana, jodiodeni marinaja pariseodsa jehe quinajarideni naco jipehe nebocossamana najari, Diodsara huati huati dsanapomanahijine. Nadsapa madija Jesohuaji bacco najonamanadsapa pohuadsa huati toquinajari: —Huano Baotista pocca mamari tabaqqui tedseje jipehe nebocossamanajari. Pariseodenicca mamari tabaqqui naco jipehe nebocossamanaraha ¿nejecotohui ticca mamari tabaqquia jipehe nebocossamanaha najarahi? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nadsapa Jeso pohuadenidsa huati tajari: —Dsabissopa amoneje cajibote najari pocca ejete tojadsapi ¿pohuadsa queriqquimanajarideni jipehe nebocossamana taco? Nebocossamana-jarahi −nahi nade. —Dsabisso cajibote najari tedseje huatidsemanadsapa jipehe nebocossamana-jarajari. ");
INSERT INTO cul_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Naraha nidsa huada onihiccadsa dsabisso cajibote najari iaccamanadsapa pohua tessedenipa jipehe nebocossamanahitohui −nahi nade Jeso. (Aja pohua atti nama najaripa pohuapa pina dsabisso cajibote najari. Pohua huatimadedeni jipehe nenebocossamana najarajari, najari.) ");
INSERT INTO cul_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Ima onihi naqui ajima najaro: Etero ssessequidedenipi etero jadanidsapi etero dsati ihibedsacossamana nejerajaro. Etero dsati etero jadanidsa podsacossadsa dsotode ssahua nadsapi joca naqqui tani. Nadsapi etero jadani sseo tapomadsapi denima totabaccora tani −nahi nade. (Aja pohua atti nama najaripa pocca marinaja pina jodiodenicca marinajassa nejerani. Jeso pocca marinajapi dsati.) ");
INSERT INTO cul_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","—Ima onihi naqui ajima najaro: Uva ppejene nahatodsatipa bani etero ssequi nahi jadahidsa sso sso ihidsamana najarajari. Uva ppejene nahatodsati bani etero jadahidsa sso todsadsa ssicatadsapa jocaquera tajarijine sseo tahi caji tahi. Sseo tadsapa uva ppejene sso taha jica tahi, dsamine naco totabaccoradsapa coro quina tahi. Nadsama uva ppejene dsatipa bani etero ssequi nahi dsatidsara sso sso totodsa najari −nahi nade Jeso. (Aja pohua atti nama najaripa madija bodi dsati tojadsana Jesocca marinaja dsati ecahuanijine pajirahi, najari.) ");
INSERT INTO cul_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nadsapa dsotode naco jassinajacca huadadsa Jeso pohua huatimadedeni tedseje huidsaja nocconi motta jai tojeqquimajari. Jai tojeqquimadsapa aroso jidsadsa trigo bono pore ippimanadsa apa dsanapomanajari. ");
INSERT INTO cul_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Naraha jodiodeni marinaja pariseodsa jehe quinajarideni qqui toquinadsapa pohuadenidsa bica tejeradsa Jesodsa huati toquinajari: —¡Ajana! Tetimadedenipa huidsajacca bono pore quinadsapa pina jassinajacca huada jerajarodsa dsepedeni ijimanajarissa quinaha. Jassinajacca huadadsapi idsepe ijinijine oppina taraha −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Naraha Jeso pohuadenidsa huati tajari: —¿Naraha tiadenipi aji Dio Atti maittaccadsama dsodo naniccadsa Dabicca ima hua hua titiquina naraha tetideni ajimamanajarorane? Najaro imapi Dabipa pohua tessedeni tedseje dsamatapa cappiramanadsa pemimanadsapa pan Diodsa da tahicca oppina taraha jipamanajari. ");
INSERT INTO cul_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Aja maittaccadsama Diodsa dada toqquimadedenicca tamine deni tojajari onipa Abiata madidsa nahihuaji Dabi toqquedsimadsa pan tohui huati tajari. Pan ohuaha nohueradsa Diodsa da tahiccaraha Dabi jipajari, pohua tessedenidsa naco da inabaqquidsa jipamanajari. Najari pan Diodsa da tahipa dada toqquima cacahuadedenira jijipamana najariraha Dabideni pemimanadsa jipamanajari oppinera tahi −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Naraha Jesopa denima pohuadenidsa huati huati dsanapojari: —Dio madija inahatobaqquijaripa jassinajacca huada madija inapajiramananissa tanijine inahatobaqqui-jarajari. Diopa jassinajacca huada tahimarini huati tapojaripa jassinajacca huadapi madijadsa bica tanijinena huati tapojari −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","—Ohua Madija Bedi ojajarona jassinajacca huada jinede ojani. Jassinajacca ima cacahuadepi ohuana paji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Naraha Dio Atti mamarihuaji Jeso toqquedsimani-pomadsapa madija dsepe siri naco nahidsa huittarijari. ");
INSERT INTO cul_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Nadsama jodiodeni marinaja pariseodsa jehe quinajaridenipa Jeso inoccodsamanajari. Jesopa jassinajacca huadadsa madija inanomibaqquidsapa pohuadenidsa pina jassinajacca huada jerajarodsa pohua dsepe ijijarissa najari, quinajari. Pohuadeni bodipa: —Jidapana jassinajacca huadadsa ajari dsepe siri inanomidsapa Jesodsa ima inahananijine −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Naraha Jesopa dsepe siridsa huahua najari: —Titehemadsa ahuaji ticcajonaji −najari. ");
INSERT INTO cul_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nadsapa dsepe siri ccajonadsa Jesopa madija huapimadsa huati tajari: —Jari, Moisesicca marinaja, icca madijacca marinaja naqui nahatoqquiri tiquinadsapi ohuatti tecomeramanaji. Jassinajacca huadadsapi ¿nejecoma najaro ima inananina “Bica tani” tiquinajaro? Jassinajacca huadadsa madija inabicabaqquidsa “Oppina tani” ¿tiquinajaroqui? Madija inajidsobaqquidsana “Bica tajaro” ¿tiquinajarorane? −najari. —Jassinajacca huadadsa naco ijine madija tossiajadsa ¿oppina taqui? “Paja dsoqquerina” ¿tiquinajarorane? −najari. Naraha pohuadeni cacomamanajari. Nahatoqquiri naraha cappinamanadsa joma quinajari. ");
INSERT INTO cul_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nadsapa Jeso madija huapima jassi nahuajanijari icahadibaqquidsa noccodeni icattabaqqui najari. Nadsapa pohua bodi ojijari, huaribodeni sibaqquiri nadsa. Nadsapa dsepe siridsa: —Jari, tidsepe ohuahuaji da ticanajonaji −nahi nade. Nadsa pohua dsepe pohuahuaji da icanadsapi tocanomijaro. ");
INSERT INTO cul_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Naraha pariseodeni jai tojenadsapa tamine Herodecca madija tedseje queriqquimanajari. Nahidsa ima idimamanajaro, Jeso dsoqquehijine. ");
INSERT INTO cul_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nadsapa Jeso pohua huatimadedenima coridsahuaji jai tojedsippajari. Aja dsama arobeni Carireahuajicca madija naco huapi taha Jesodsa jahimissajari. ");
INSERT INTO cul_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Madija ohuahadeni naco Jesocca ima mittamanadsa pohua canahatoriri canahi qquide tohuini quinadsa Jesotohui jahimissassa canajari. Madija huapi taha jahijonana canajari. Dsama arobeni Jodeahuajicca, odsa panani Jerosarehuajicca, dsama arobeni Idomeahuajicca, hueni Jordao jippehuajicca, odsa panani Tirohuajicca, odsa panani Sidohuajicca madija naco jahijonana canajari. ");
INSERT INTO cul_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nadsapa madija si tocajajari canadsapa Jeso pohua huatimadedenidsa huati tajari: —Canoa qqui ticanamanaji. Nidsa nanidsa oqquedsanijine. Madija huapi taha jahijonahi ia mere inanamanarana −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aja comaqquiri najari inanomibaqquidsapa ohuaha tonomi, ohuaha tonomi naridsamanajarijine pohuadsa jahijonedsati naco Jeso bara quinahijine pohuahuaji jo todsimahi najari. ");
INSERT INTO cul_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aja madija bodidenicca tocorime Jeso qqui toquinadsapa Jeso baccohuaji pohuadeni pitodsa jassi tadsa attideni dacoradsa johua johua quinajari: —¡Tiapi Dio Bedi tijani! −quinahi nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Naraha pohua tahimari ecomamananijine Jeso atti dacoradsa huati tajari: —¡Najaro otahimari huati tiquina tejeraji! −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesopa coridsahuaji madija mari icanabaqquia jicadsapa ssonohuaji toqquemorajari. Nadsapa Jeso pohua jipa tahicca madijatohui huahua inajonabaqquidsapa pohuadsa queriqquimanajari. ");
INSERT INTO cul_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nadsapa 12 quinahana icattejidsabaqquijari, pohua huatimade toquejenahijine. Najaridenipa Jeso dosse inabaqquiridsadsa pohua tahimari maride jahiridsahijine. Nadsapa Jeso pohuadeni oni icanacanibaqquijari: —Occa dodosse tabaqqui −najari. ");
INSERT INTO cul_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Pocca dacorehe pohuadenidsa inanaridsajaroa madija bodidenicca tocorimedeni dosse dosse ihininebaqqui nahijine pohuadeni inapajirabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nadsama 12 quinajarideni icattejidsabaqquijari onidenipa ajama quinajari: Tahidepa Ssino. Pohua oni Jesojine icanacanidsatipa: Pedro, najari. ");
INSERT INTO cul_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Madija ohuaha onipa Satiaco. Pohua ohuahapa Huano. Pohuadeni pamahapa Sebedeo bedi. Najarideni pamahapa Jesojine onideni icanacanidsatipa: Boanereque, najari. (Ettidsapi pina: ttottorodecca madija, najari.) ");
INSERT INTO cul_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Madija ohuahadeni onideni naco Adiri, Feripe, Batorome, Mateo, Tomas quinajari. Madija ohuaha onipa Satiaco. Satiacopa Arapeo bedi. Madija ohuaha onipa Tadeo (pohua oni ohuahapa Joda). Madija ohuaha onipa Ssino, pohuadsa: romanodeni momohuade, quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Madija ohuaha onipa Joda Iscariote. Najaripa Jeso ccaccorade. Najarideni Jeso icattejidsa-baqquijaripa 12 quinaha pohuadsa toquejenajaride. ");
INSERT INTO cul_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nadsapa Jeso odsa bacco tanidsapa madija pohuadsa toqueriqquini-manapomajari. Madija pohuadsa disseraqquiri nadsapa pocca mamari tabaqqui tedseje dsepedeni ijimanahissa tajari. Nama quinadsapa jipamanahijine ssamo tajari. ");
INSERT INTO cul_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Naraha Jeso imeni, pohua imecotedeni tedseje ima mittamanajari: —Jeso bodi tossamohui, jipa-jarahi −quinahi mittamanadsa pohua iaccanimanahijine jahijonajari. ");
INSERT INTO cul_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nahidsa naco odsa panani Jerosarehuajicca jodiodenicca marinaja maridedeni bacco quinajari. Najarideni attidenia: —Tocorimedenicca tamine Beheosebopa Jeso bodidsa madidsajari. Pocca dacorehe cajijarijinea pocca dodosse tabaqqui dosse ininebaqquijaripaja −quinahi nade. Naraha maidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nadsapa Jeso pohuadenidsa huahua najari. Pohuadeni bodi huatomanahijine ajijaro namidsa imadinicca ima huati huati tajari: —¿Satanapa pohua dosse tonine taco? Nohuerahi −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Dsama huapimacca taminepa madija ecahuabaqquiraha dsotode pocca madija cahadiremanadsa ahuaji atti ahuaji atti quinadsapa pocca cacahuehe inassamomanajaro. Nadsapa pocca madija domo tocca tahi. ");
INSERT INTO cul_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Najarossa najaro odsa cajariecca madija cahadiredsapa poccadeni ima tossamodsapi tojaribaqqui tahi. ");
INSERT INTO cul_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ima najarossa najaroa Satanapa pocca dodosse tabaqqui madija bodidsa madidsamanajarideni dosse ininebaqquidsapa pina pohua pocca madija tedseje cahadirejarissa najari. Nama nadsapa pocca dossehe inassamodsapi sara tabaqquihitohuiraha −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Nadsama imasiri totonanade Satanapa dacorehe cajiraha ohuapi deni ojajaro. Pohuapa ajamani pina ajijaro ima tiadenidsa huati onabote najarossa najaro. Nadsama bobotidepa: “Odsacca todsepetaji obotina” najariraha odsa jinede dacorabote odsadsa madidsadsapa botihijine pajira-jarahi. Naraha bobotide denima dacoradsapa odsa jinede dama inadsa jore inaqquidsapa pohua dsepetaji botihijine pajirahi, onajaro. Ima najarossa najaroa aji ohua pina bobotide denima dacorajarissa onajaro. Occa dacorehe deni tojadsapi pina Satana jore onaqquijarissa nadsa pocca dodosse tabaqqui dosse dosse ohoninebaqqui najaripaja −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nadsapa Jeso jodiodenicca marinaja maridedenidsa denima huati huati tajari: —Pajissara tiadenidsa huati onajaro: Madija imasiri inanamanaraha nidsa dsotode: “Icca ima inebona” quinadsapa poccadeni imasiri Diodsa ecomeramanadsa Diopa poccadeni imasiri huapima epeje inananitohui. Poccadeni tamassohue huapima naqui Dio epeje inananitohui. ");
INSERT INTO cul_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Naraha Dio Corime itamassomanadsa, pohuajine tojajarodsa maidsehe huahua quinadsa naco Diopa pohuadeni atti huati ajama-jarahitohui. Poccadeni imasiri epeje inana-jeranitohui. Poccadeni ima oppina tajaropi pohuadenidsa nema dsanaponitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aja Jeso atti nama najaria jodiodenicca marinaja maridedeni maidsamanadsa: —Jesopa Satanacca dacorehe cajijarijine canahatoriri canaridsajari −quinadsapa manaco Jesopa pohuadenidsa ima oppina tani huati tajari. ");
INSERT INTO cul_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nadsama Jeso imeni pohua imecotedeni tedseje Jeso pohuahuaji bacco toquinajari. Amossinihuaji domo huadsa huati toquinajari: —Jesodsa huahua tiquinaji −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Madija Jesodsa jassi tarijarideni pohuadsa huati toquinajari: —Ticca ami, timecotedeni amossinidsa titohui domo huapaja −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Naraha Jeso pohua attipa: —Occa amipi ¿nejecojarona paji? Ohuemecotedeni naco ¿nejecojaridenina paja? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nadsapa pohuadsa jassi tarijarideni icattabaqquidsapa pocca madija jararaha: —Ajajaridenina pina occa amissa, pina ohuemecotedenissa quinajari. ");
INSERT INTO cul_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Madijadenipa Dio Pohua jipa tahicca ihinanamana najarodenina pina ohuemecotedenissa quinajari. Amonejedeni naqui Dio Pohua jipa tahicca ihinanamana najarodenina pina occa amissa, pina ohuemecotedenissa quinajaro, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesopa coridsa inididsa maride tojapomajari. Madija ohuaha ohuaha quinaha pohuadsa toqueriqquijari. Madija pohuadsa panahicca tojadsapa Jeso coridsacca canoadsana toqquedsadsapa canoacca huihuittaridsa huittarijari. Nadsama madijapa nahi coridsa inidicca ssiquidsa domo huajari. ");
INSERT INTO cul_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nadsapa pohuadenidsa ima huapi tehe mari icanabaqquijari. Pocca marinaja ajijaro namidsa imadinicca ima tadsajani mari icanabaqquijari. Jesocca marinajapi ajima najaro: ");
INSERT INTO cul_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Titaharibobo canaji. Huidsaja ppappadepa pocca huidsaja huirade toccajari. ");
INSERT INTO cul_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nocco huira inaridsajari. Naraha motapa jahuihuaji catojaja najari. Nadsapa ppiriri jahironadsa amadsati saca quinajari. ");
INSERT INTO cul_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Aja nocco huira naridsajari mota naco siba ccababa tanidsa catojajari. Nanidsapi ssiqui bicani badsira taraha nama naha huassinaja moro tajari. ");
INSERT INTO cul_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Moro taraha jabo huapihuajira toccabaqquijari. Maji ccajonadsapa maji ppoconejine botejari. ");
INSERT INTO cul_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nocco mota naco namidsa cotihi caji tahihuaji catojajaria cotihi tedseje paja moro toquinarihi naraha cotihijine ssomi tojajari. Nadsapa bono-jarajari. ");
INSERT INTO cul_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nadsapa nocco mota huira naridsajaripa nami bicanidsa catojaridsadsapa mororo canaridsadsa bica taha napijari. Bono cajiridsadsapa ede ojariapa bono 30 naha cajijari. Ede ohuahaccapa bono 60 naha cajijari. Ede ohuahaccana 100 naha cajijari. ");
INSERT INTO cul_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nadsapa madija mota jai tojaniraha madija pamaha madimanajaripa Jesocca dodosse tabaqqui 12 quinajarideni tedseje Jesodsa huati toquinajari: —Jeso, ajijaro namidsa imadinicca ima tadsajani ia mari ticanabaqquijaropi ¿nejecoma najaro ticca marinaja? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Naraha Jeso pohuadenidsa huati tajari: —Jehe maittaccadsama Diocca cacahuehecca ima dsati najoraporaha madija inahattabaqqui-jaraccade. Jidapanana Diojine pocca cacahuehe tahimarini dsati tiadenidsana ahuato tani. Naraha madija motapa ajijaro namidsa imadinicca ima tadsajani pohuadeni mari ocanabaqquidsapa mittamana-jarajaripaja. ");
INSERT INTO cul_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nama nadsapa Dio Atti cacomerabote Isahia dsodo inapojarossa najaro. Isahia attipa: “Qqui qqui toquinaraha pina qqui toquirahi nahitohui. Pohuadeni bodi pina ssamoqquiri najarissa nahitohui. Diocca dosseniji mimittamana naraha pina mittamanerahi nahitohui. Mittamana-jaradsapa bodideni naco cacajiqquimeramana-jaradsapa Dio poccadeni imasiri epeje inana-jeranitohui” napohui nade Isahia atti −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nadsapa Jeso huati tajari: —Aji occa marinaja ajijaro namidsa imadinicca ima tadsajani tiadeni mari ocanabaqquidsapi ¿timittamana-jerajaroqui? Timittamana-jeradsapi occa marinaja ¿nejecoma najarodsana timittamananijine? onajaro −najari. ");
INSERT INTO cul_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Jidacca occa marinajapi ajima najaro: Huidsaja ppappadepa pina Dio Atti mamaridessa najari. Noccopa pina Dio Atti madijadsa totoja najarossa najaro. ");
INSERT INTO cul_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nocco huira inaridsajari mota jahuihuaji catojajaripa pina madija Dio Atti mittamanaraha pohuadeni bodi iboqquiri nadsapa bodidenidsa Dio Atti toqquedsima-jerajarossa najaro. Aja ppiriri nocco saca inaridsajaripa pina maidsehe jinede Satana ccajonadsa bodideni inassamobaqquijarissa najaro. Nadsapa Dio Atti pohuadenidsa nohuerajaro. ");
INSERT INTO cul_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Madija ohuaha bodidenicca imapi pina aji siba ccababa tajarocca imassa najaro. Dio Atti mittamanadsa amadsati huatidsemanajari. ");
INSERT INTO cul_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pohuadenipa Diodsa jehe dsanapomanahijineraha Dio Atti pohuadeni bodidsa toja-jerajaropi pina aja siba ccababa tanidsa nocco moro taraha jabo huapihuajira toccabaqquijaricca imassa najaro. Nadsama aja maji ppoconejine botejaricca imapi Dio Attidsa jehe quinajarijine pohuadenidsa najidsohue ssonaridsa, ocasserani ahuamanadsapa jehe quidsati attideni: “Epejena, Dio Attipi inebona” quinajari. ");
INSERT INTO cul_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","—Madija ohuaha bodidenicca imapi pina namidsa cotihi caji tajaricca imassa najaro. Pohuadenipa Dio Atti mittamanaraha ");
INSERT INTO cul_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pohuadeni dsepedeni ihijimana najarotohuira disseraqquiri nadsapa Dio Atti tocahatterahissa tajarajari. Dsiniro tohuira quinadsa naco najaro imajine poccadeni jeheniji maidsehe toja tani. Huapima pohuadeni tohuini quinajaricca tohuira bodideni huatoma-manadsa naco Dio Atti huatideni ajamamanajari. Nama quinajaridenipa poccadeni jeheniji pina aja nocco moro taraha cotihijine ssomi tojadsapa bono-jarajarissa najaro. Dio Atti mittamanaraha pohuadenijine Dio Atti madija ohuahadenidsa toja-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Naraha madija ohuaha bodidenicca imapi pina aji nami bica tajarocca imassa najaro. Dio Atti mittamanadsapa jehe quinahissa tajari. Poccadeni jeheniji napidsapi pina aja nocco nami bicanidsa moro tahissa tadsapa bono cajijari. Ede ojariapa bono 30 naha cajijari. Ede ohuahaccapa bono 60 naha cajijari. Ede ohuahaccana 100 naha cajiridsajari. Aja Diodsa jehe quinahissa tajaripa madija mari icanabaqqui-ridsadsapa madija ohuaha ohuaha quinaha Diodsa inanabaqqui-manahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesopa denima huati tajari: —Nadsama jojororo toquehessidsa ssapotodsa boco icanahijine ¿bica taco? Bica tajarahi. Aja jojororo toquehessidsapa huahuada dopanihuaji tocanajimahijine jarahi. Jojororo toquehessidsapa aja pohua cacahittari nahidsana cacahittari najari, nahi madija huapima ssiajani cajimanahijine. ");
INSERT INTO cul_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nadsama jidapana ima ahuatora tanicca caji taraha nidsa dsotodepi ahuato tanitohui. Aji jidapana occa marinaja mota ahuatora tadsa timittamana-jeraraha nidsa dsotode tiadenidsa ahuato tadsana timittamananitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nadsapi teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nadsapa huati tapomajari: —Najaro ohuatti tibodideni huatonissa tadsa tecahuamanaji. Naraha timittamananissa tejeradsapi ticahattera-jeranitohui. Timittamananissa tadsapi ticahattereje dsanaponi nanitohui. ");
INSERT INTO cul_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aji tiadeni ohuatti tecahuamanadsapi denima ticahatteranitohui. Naraha occa marinaja timittamanaraha ohuatti tecahuamana-jeradsapi occa marinaja odininitohui, onajaro. Nadsapi tiadeni tiadenira ticamaidsanimanadsa naqui: “Dio Atti ocajini, nahato onani” tiquinaraha najaro naqui odininitohui. Paji, nemamana tejeraji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesopa ima onihi huati tajari: —Jehe, Diocca cacahuehe tojaridsajaropi pina ajijaro imassa najaro. Madijapa dsamatapa nocco huira inaridsajari. ");
INSERT INTO cul_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Dsomepa huahuada najari, ssiaja nocco tojadsapa onihihuaji dsepe ihiji najari. Naraha dsamatapa noccopa pohua ehuerahi moro moro tajari. Madijapa dsamatapa nocco moro inanahijine ssamo taraha Diona nahato tajari. Diojine moro moro tajari. ");
INSERT INTO cul_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jehe, nami bica tadsa tahidepa ede napijari. Dsotodepa mohue toccajari. Dsotodepa bono cajijari. ");
INSERT INTO cul_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nadsapa bono jadadsa jinede attipa: “Bono jadahi pore onana” nadsa porede toccajari. Bono pore inajari, jicadsapa pocca odsahuaji eccanijari. Jehe, Diocca cacahuehepi pina najaro imassa najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nadsama Jeso huati tapomajari: —Tibodideni huatomanaji. ¿Nejecoma najarona paji Diocca cacahuehe? Aji Diocca cacahuehe tahimarini timittamananijinepi ajijaro namidsa imadinicca ima onihidsa tiadeni mari ocanabaqquina −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","—Diocca cacahuehepi pina mostaza noccossa najaro. Mostaza noccopa potera tajari. Ppa nahi nocco ohuaha naco potera tahi caji taraha mostaza noccopa denima potera tajari. ");
INSERT INTO cul_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jehe, mostaza noccopa potera taraha ppa idsadsa napidsapa huidsajacca ppa nahidsa pohuana deni tojajari. Motaradsapa pohua ininedsa naco ppiriri pohuadeni tadsari eppe nahuinedsa bina tarimana tahi. Jehe, Diocca cacahuehecca ima mari ocanabaqquijaripa pina najaro imassa najaro. Tahidepi madija pamahadsa tojapojaro, dsotodena madija huapimadsa tojaridsadsapi Diocca cacahuehedsa madija tohuapihitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesopa pohua tahimari ajijaro namidsa imadinicca ima onihi onihi najaro tadsajani mari mari ihicanabaqqui najari. Madija huapimadsa huati tadsapa pohuadeni mittamanahijine pajiraniccara mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pohuadenidsa huati tadsapa ajijaro namidsa imadinicca imadsara mari mari ihicanabaqqui najari. Naraha dsotode pocca mamari tabaqquidsana pocca marinaja inahattabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Najaro ssiajadsa maji tonahuidsa Jesopa pohua huatimadedenidsa huati tajari: —Jina, coridsa jippehuaji jaijana −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nadsapa pohuadsa queriqquimanajarideni inebobaqquijari. Jesopa najaro canoadsa huittaridsa maride tojaraha maride jicadsa paja iaccamanarihi najari. Madija ohuahadeni naco canoa onihidsa tohuaccamissamanajari. ");
INSERT INTO cul_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jai tojadsapa jojode dacorehema ccajona, passo dacorehema ccajona nadsapi coridsa ssoda ssoda najarojine canoadsa passo ssonidsa ssonidsa najaro. ");
INSERT INTO cul_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Naraha Jesopa canoa dsotonihuaji pohua tati poponima ibemadsa tohuittamissadsa huadajonajari. Nadsapa Jeso pohuadsa huahua quinajari: —¡Ia Maride nocco tijaji! ¡Je icanabote nani! ¿Nema nehe poni ijicanijinequi? −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nanaja Jeso nocco tojadsa totehemadsa jojodedsa passodsa huati tajari: —¡Epeje taji! ¡Mohua tejeraji! −nahi nade. Naneje jojode, passo ssoda ssoda najaro naqui joma najaro. Joma nadsapi passo podsippanissa tajaro. ");
INSERT INTO cul_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nadsapa pocca mamari tabaqquidsa huati tajari: —¿Nejecotohui ticappinamanajaro? Tiadenipi ohuadsa: “Jehe, Jesopa ia tohuacahua-baqquihijine pajirahi” ¿tiquinejerajarorane? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Naraha pohuadenipa cappinamanajari. Bodideni jabojo quinadsa pohuadenira imahaha canajari: —Aja ia Maridepa ¿nejeco madija? Pohuapa jojode, passo ssodadanima quejema naraha jojodedsa: “Epeje taji” nadsa jojode joma naha −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aja coridsa jippehuaji bacco toquinajaricca dsama oninipi Jerasa. ");
INSERT INTO cul_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nahidsana Jesopa toqquemoraraha madija bodidsa Satanacca dodosse tocorime madidsajari tonoccobirihuaji qquenadsa Jesodsa bacco dsippajari. ");
INSERT INTO cul_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Pohuapa tonoccobiri caji tanihuaji mamadi najari. Nadsapa nahi Jerasahuajicca madijapa biji jore quinaraha joca tajojo, joca tajojo najari. Isso naco jore quinaraha ttai tajojo, ttai tajojo najari. Cadenadsa naco jore quinaraha pohuajine tajoppi tajoppi najaro. Jore quinapomadsa naco nama dsanapodsapa pohuaha deni tojadsanapojari. Jore quinadsa ecahuamanahijineraha jojorededeni ajamani toquejenadsapa paja inebomanarihi najari. ");
INSERT INTO cul_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Pohuapa ssiaja ccaridsa, dsome ccaridsa nanaridsa najari. Johua johua nanaridsa najari. Ssonohuaji ccaridsa, tonoccobirihuaji ccaridsa nadsapa sibadsa pohua ime ca jeo, ca jeo tonanamarojari. ");
INSERT INTO cul_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nanaja Jeso huaji tanidsa qquemorahi qqui tadsapa joppa najonajari, Jeso baccohuaji pohua pitodsa huitta najari. ");
INSERT INTO cul_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Naraha Jesopa amadsati pohua bodiccadsa huati tajari: —¡Tocorime, najari madija tinebojo! −najari. Nadsapa tocorime jadsirema huati tajari: —Jeso ¿nejecotohuira ticcajonajaroneje? ¿Ohua najidsode ticcajonajaroqui? Tiapi Dio deni tojajaricca Ejedeni tijani. ¡Dio onima ohua tinajidso tejeraji, onaha! −najari. ");
INSERT INTO cul_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Naraha Jesopa tocorimedsa huati tapomajari: —¿Tia onipi nejeco? −najari. —Ohua onipi Siba tani, tocorime huapi inani −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nadsapa madija bodicca tocorimedenia Jesodsa huatide disseraqquiri najari: —¡Ajijaro dsama huaji tanihuaji ia dosse tinabaqqui tejeraji, inaha! −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Naraha nahi ssono huajira tanidsa poroco huapi taha jiparidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nadsapa tocorimedeni Jesodsa huati toquinapomajari: —Poroco huapimadsana ia dosse tidsimabaqquiji. Nanidsana iquejenana −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nadsapa Jeso: —¡Jehe, porocodsana tiquejenana! −najari. Nadsapa najari madija bodicca tocorime jahininedsapa porocodsana jai tojedsimaridsajari. Nanaja porocopa coridsa inidi sseberanihuaji domo toqquedsippadsa diri-ri-ri todsippadsapa cojo-jo-jo quinajari, tocatojedsippajari. Poroco huapimapa 2 mil quinajari. Coridsadsa je tocaniredsapa cacotedsanajari. ");
INSERT INTO cul_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nadsapa poroco cacahuadedenipa ahuajicca odsa pananihuaji ima joppa tocanajari, ohuahapa huidsajahuaji ima joppa tocanajari. Nama naridsamanajari. Ima inanaridsamanadsapi cattade jahijonana canajari, madija huapima. ");
INSERT INTO cul_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nadsapa qquide jahijonadsapa Jeso huahihuaji bacco najonamanajari. Aja madija tocorimedeni cajipojaripa tonomihira qqui toquinajari. Nahidsa huitta canajari. Etero huedsapomajari, bodi huatohue naco cajipomajari. Nadsapa madija huapima cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Qqui toquinapojaridenia aja madija bodicca tocorimedeni jahininejari tahimari huati, poroco tahimari huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nadsapa poccadeni dsamadsa Jeso toccanihijine dossede dissassera tajari: —¡Ticcaniji, aji icca dsamadsapi timadi tejeraji! −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nadsapa Jeso toqquedsippanidsapa canoadsa toqquedsanijari. Nadsapa madija tocorime cajiporaha tonomijaripa Jesodsa huahua najari: —¡Ohua naqui tiadsa occana! −najari. ");
INSERT INTO cul_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Naraha Jeso attipa: —Poni, ticcaniji. Ticca odsahuaji ticca madijadsa tijaniji. Ticca madija huati tinabaqquina: “Onomijaropi Diojine. Diopa ohuadsa huati huana tajari” tinanina −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nadsapa toccanidsa pocca ima huati naridsajari. Dsama arobeni Decaporicca odsa huapimadsa pohua tonomihicca ima, Jeso pohua inanomihicca ima huati taridsajari. Nadsapa huapima mittamanadsapa: —A, Diojine bica taha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesopa pohua huatimadedeni tedseje canoadsa jippehuaji tohuaccanimanajari. Bacco tanimanadsapa madija Jeso qquide jahidsippappa canajari. Jesopa coridsa inididsa huajari. ");
INSERT INTO cul_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nanaja jodiodenicca Dio Atti mamarihuajicca tamine ojaria naco ccajonajari. Pohua onipa Jairo. Jesodsa bacco najonadsapa pohua bodipa: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta nadsa tocattedsa najari. ");
INSERT INTO cul_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nadsapa Jesodsa huati tajari: —Occa ejedeni amoneje bedeni tomijirani. Jina, occa odsahuaji icadaccana. Tidsepedsa poni bara tadsa tonomidsa madipomanijine −nahi nade Jairo. ");
INSERT INTO cul_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nadsapa Jeso Jairo tedseje jahui tohuedanijari. Naraha madija huapima Jesodsa cahuaja dsanapojarijine Jeso queberibote dsanapojari. ");
INSERT INTO cul_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Madija huapima jai tojahidsa naqui amoneje coma tajaro tohuanajaro. Ponipi dsamacoma onini amaissoranaja cajijaro. Poni coma tanicca huajanopa 12 naraha ama jicaquera tanicca totonahana dsanapojaro. ");
INSERT INTO cul_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Coma tadsa toponi totonanomidedenihuaji ponima totocca naraha tonomi-jerajaro. Denima coma dsanapojaro. Toponi totonanomidedenidsa poni manaconi cajicaridsajaro. ");
INSERT INTO cul_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Naraha Jeso tahimari madija huati huati toquinahi mittajaro. Nema najaroa aji Jesotohui toccajaropaji. Poni bodinipi: —Pocca eterora bara onadsapi onominitohui −najaro. Madija si tocajajari canajonaraha amoneje coma tajaropi Jeso nattihuaji toccamissadsa tohuajiressissi nadsa pocca etero bara inajaro. ");
INSERT INTO cul_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Naneje amadsati amani amossi najaro. Nadsapi poni doroni comani tomossini nahato tajaro. ");
INSERT INTO cul_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nadsapa Jeso pohua bodi nahato tajari, pocca dacorehejine madija inanomijaro. Nanaja amadsati Jeso pohua nattihuaji piti nahuajanidsa huati tajari: —¿Nejecojari occa etero bara inajaroneje? −najari. ");
INSERT INTO cul_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Naraha pohua huatimadedeni attidenia: —Madija si tocajajari canajonajaripa. Naraha tiapi: “¿Nejecojarina ohua bara najari?” tajaro −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Naraha Jeso pohua bara najari tohui ahuaji qqui, ahuaji qqui naridsajari. ");
INSERT INTO cul_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nadsapi amoneje cappinehe ccajonadsa tacca-cca canajonajaro. Jeso baccohuaji poni pitonidsa huitta nadsa poni cacomerajaro: —Ojinepa −najaro. Nadsapi poni amaissoranaja cajijaro Jeso pocca etero bara inadsa amadsati tomossijarocca ima huati tajaro. ");
INSERT INTO cul_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nadsapa Jeso ponidsa huati tajari: —Jehe asi, ohuadsa tibodi: “Jehe, Jeso ohua tonanomihijine pajirahi” tadsapi najarojine ticca dsamacomapi toccapa. Ticcanidsapi ticappina tejerana. Najaro comanidsa quidsa tapoma-jeranitohui −najari. ");
INSERT INTO cul_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nahidsa Jeso huati huati taraha, jodiodenicca Dio Atti mamarihuajicca tamine pocca odsacca madija bacco najonamanadsa ejedeni imehidsa huati toquinajari: —Jairo, ticca ejedeni dsoqqueni. Jidapapa ia Maride ccajona-jarana. Dsoqqueni. Epejeni, poni −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Nama quinaraha Jesopa Jairodsa: —Tibodipi ticappina tejerana. Pina “Jehe, poni tonominijine” tana −nahi nade Jeso atti. ");
INSERT INTO cul_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jeso pohua natti jai tojamissajarideni pohuadsa jai toja-jarahijine Jeso eccoccobaqquijari. Naraha pohuadsa jai tojahijinepa Pedro, Satiaco, Huano quinajari. Aja Huanopa Satiaco ohuaha. Pohuadenira jina inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nadsapa Jairocca odsahuaji jai toja, bacco toquinajari. Bacco toquinadsa pina mohua mohua camajarissa najari Jeso qqui tajari. —Ejedeni dsoqqueni −quinadsa jadsirema oji oji camajari, johua johua camajari. ");
INSERT INTO cul_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Odsadsa toqquedsimadsapa Jeso huati tajari pohuadenidsa: —¿Nejecotohui ticcadeni ojie dacorajaro? ¿Nejecotohui johua johua ticamajaro? Ejedenipi dsoqque-jerani. Huadani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Naraha pohuadenipa Jeso atti jaja icanamanajari. Naraha Jesopa madija huapima dosse ininebaqquijari amossinihuaji. Nadsapa Jeso, pohua huatimadedeni, ejedeni imehi, imeni quinadsa ejedeni huatiajaro porinihuaji jai tojedsimajari. ");
INSERT INTO cul_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nadsapa Jesoa ejedeni dsapani equididsa pohua attidsa huati tajari: —Taritta ccomi −najari. (Najaro ettidsapi: —Ejedeni, titehemaji −najari.) ");
INSERT INTO cul_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Naneje ejedenipi amadsati camittemanidsapi totehemajaro. Nadsapi ccaridsajaro. Huajanorini 12 najari. Najaro ejedeni ccaridsadsapi madija huapima jabojo quinaraha huatidsemanajari: —A, apaja bica tahi −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nadsapa Jeso atti pohuadenidsa: —Ajijaro imapi huati taridsamana tejerana. Poni −najari. Nadsapa Jeso attia: —Ticcadeni ejedeni tinajipamanaji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nadsapa Jeso pohua madihidsa nebo pohua napihihuajina toccanijari. Pohua huatimadedenima jai tojanijari. ");
INSERT INTO cul_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Odsa panani Nasareti bacco tanidsapa jassinajacca huadadsa Dio Atti mamarihuaji toqquedsimadsa mari icanabaqquijari. Nadsapa nahicca jassi tarijarideni mittamanadsapa huajo caniredsapa: —A ¿nejecohuaji tohuattajaritta? −quinajari. —¿Nejecojaricca nahatohue Jesodsa tojajarotte? ¿Nejecoma nadsa madija ihinanomi najari? Pohuapa canahatoriri canahi qqui qqui ihinana-jaraccade −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—¿Naraha ajajaripa ahua cocobade jaraco? ¡Ahua cocobadedija, Maria bedia! Pohua imecotedeni naco: Satiaco, Dsodse, Joda, Ssino quinajaripajade. ¿Pohua caripenedeni naqui aji imadinidsa madimana-jeraqui? Madimanani −quinahi nade. Nadsapa pohua atti mittade tojiperamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nadsapa Jeso attia: —Ohuadsa pajissa tiquinejeradsapi pina Dio Atti cacomeraqquiri najarideni tahimarissa tinanamanajaro: Madija huapimapa aja Dio Atti cacomerabotedsa: “Pajissa Diocca dossenijia” quiquinanaraha aja pohua dsamariccapa nama quina-jarahi. Pohua imecotedeni, pocca odsacca naco pohua attidsa jiperaqquiri naha nama najonamanajari −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nadsapa nahihuajicca madija Jesodsa pajissa quina-jaradsapa pohua canahato-huajapohui canahicca huapi tejerani. Madija pamahara bara inabaqquidsapa inanomibaqquijari nade. ");
INSERT INTO cul_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","Nadsapa pocca odsahuajicca madija jehe quina-jaradsapa Jesopa pohuadenitohui pohua bodi huato-dsanapojari. ");
INSERT INTO cul_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Nadsapa odsa onihihuaji odsa onihihuaji Jesopa mari mari naridsa najari. ");
INSERT INTO cul_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nadsapa pocca dodosse tabaqqui 12 quinajari huahua inabaqquidsa dosse inabaqquiridsajari. Ahuajicca jahui topama, ahuajicca jahui topama, ahuajicca jahui topama quinahijine dosse inabaqquijari. Jesopa pocca nahatohue pohuadenidsa inanaridsajaro. Madija bodidenicca tocorime naco dosse inineridsa-baqquihijine pohuadeni inapajirabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nadsapa benehidsa jai tojadsa pohua attissa inanamananijine Jeso pohuadeni mari icanabaqquijari. Pohua attipa: —Jehe ticcadeni benehidsapi tidsepedenitaji dsojo tiquina tejeraji. Tidsepedenidsapi tiadeni totocahuejidsara dsojo dsojo tiquineri naji. Dsamatapa naco tiaccamana tajarajo. Saco naqui tiaccamana tejeraji. Dsiniro naqui tiaccamana tejeraji. ");
INSERT INTO cul_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Temoridenicca sadaria naco aja tedsamanajarira ohojariri najo. Ticcadeni etero naqui pamehepi tiaccamana tejeraji, aji tedsamanajarora ohojariri tinanamanaji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Nadsama odsa panani onihi bacco tiquinadsapi aji ticadedsimapojarocca odsadsara timadimanaccana. Denima ticada-jeraccadsa najaro odsadsara timadimanaccana. ");
INSERT INTO cul_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Naraha odsa pananihuaji bacco tiquinadsa madija: “Ajidsapi timadimanaji” quina-jaradsapa, aja ticcadeni marinaja mittade jiperaqquiri nadsa naco najaro odsadsa ticadeqquimani bica tani. Madija nama quinahicca odsa tinebomanadsapi temoridenicca sadariadsa ssiqui ma tajaro catojanijine pporo pporo tiquinana. Nahi poccadeni ibohue bodideni huatoma-manahijine, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nadsapa pocca dodosse tabaqqui jai tojajari. Madija bodideni cacajiqquimera-manahijine mari icanabaqqui-ridsamanajari. Pohuadeni attipa: —Imasiri tinebomanaji. Diodsara tiquejenaji −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Madija bodidenicca tocorime ohuaha ohuaha naridsajarideni naco dosse dosse ihimaridsamana najari. Madija comaqquiri najarideni naco ihinanomi-ridsabaqquimana najari. Oqui badsira taha tatidenidsa sso sso ihinariridsamana nadsa Diodsa huati huati totoquina nadsapa Diojine totocanomireridsa najari. ");
INSERT INTO cul_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nadsama dsama arobeni Carireahuajicca tamine Herodepa Jesocca ima huati toquinahi mittajari. Jeso canahatori canaridsahicca ima naqui tojaribaqquije najaro. Nadsapa Herode attia: —Jesopa Huano Baotista dsoqqueraha nahatonijari. Najaro nahatonihejine canahatori canahi −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Naraha madija ohuaha attidenipa: —Jesopa maittaccadsamacca Dio Atti cacomerabote madipojari Eria ccanipomajari itidija −quinahi nade. Madija ohuaha attideni naco: —Aja Jesopa pina maittaccadsamacca Dio Atti cacomeraqquiri najaridenissa najari −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Naraha tamine Herodepa madija nama quinahi mittaraha pohua attia: —Jesopa Huano. Nahato onani. Soldado ocadossebaqquidsa Huano matto ca ijidsamanaraha nahatonijari −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Nadsama Herode atti nama nadsa tahide pohuajine Huano Baotista inanadsoqque-manapojari. Najaro imapi ajima najaro: Tahidepa tamine Herode pohua imecote Feripecca amoneje Herodia icajidsa ima tojajaro. Huanopa poccadeni ima mittadsa Herodedsa huati tajari: —Diocca dossenijidsapi timecotecca amoneje tidijidsadsapi bica tejerani −nanaja najari Huano. Najaro ima Herodia mittadsapi Huanodsa huadijaro. Ponicca maqquidsa dosse dosse nadsa tamine Herodepa pocca dodosse tabaqqui idossebaqquidsa Huano dama quinadsa toponi cocoro todsimadsa coro idsimamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodiapi Huanodsa jipera tadsapi pohua inanadsoqque-manahijine tohuini nadsa maqquidsa huati taraha poni attinidsa jehe najaraccahi. ");
INSERT INTO cul_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herode cappinadsa: —Huanopa bica tahi. Diocca dosseniji −nanaja nadsapa ecahuahissa tajari. Nadsapa Huanocca marinaja mittadsapa pohuadsa bica taraha ibo tadsapa: —¿Nejecoma onapadseje? −najari. Naraha nama naha Huanocca marinaja mittahijine pohuatohui huahua huahua dsanapojari. ");
INSERT INTO cul_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Naraha huada onihidsa tamine Herode pohua tossonahicca huada bacco tadsa ejete inanajaro. Nadsapa jipaqquimanahijine huahua inabaqquijari, taminedeni, soldado dossededeni, Carireahuajicca ime jocohuideni, pohuadsa jipaqquimanahijine. Nadsapi Herodia najorajaro ponicca ima. ");
INSERT INTO cul_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodia bedenipi dsobi nanijine toqquedsimajaro. Nadsapa tamine Herode, pohua tessedeni tedseje ponicca dsobinaja bica tani qqui toquinadsa, ponijine huatidsemanadsapa dsohuatodsa tamine Herode attia: —Jari jata, ticca huatinaja ohuadsa huati tinaji. Nadsapi ticca huatinaja da onanitohui −najari. ");
INSERT INTO cul_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","—¡Pajissa! Dio nahato tahi. Tia ocamaidsa-jerajaro. Occa dsama arobenitohui huati tinadsa naqui tiadsa da onanitohui −nahi nade tamine Herode atti. ");
INSERT INTO cul_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Najaro ima mittadsa dsohuato toqquenadsapi imenidsa huati tajaro: —Ami ¿nejecora huati onanijine? −najaro. Nadsapi imeni attinia: —Jari jata, Huano Baotista tatitohui huati tinaji −nani nade. ");
INSERT INTO cul_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nadsapi taminehuaji huassinaja toqquedsimanidsa ponicca huatinaja huati tajaro: —Jidapanana Huano Baotista tati parato imehidsa huittidsadsa ohuadsa da ticanajo −nani nade. ");
INSERT INTO cul_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nadsapa Herode pohua bodi Huano dsoqquehijine jipera taraha pohua atti tahide: —Dio nahato tahi. Tia ocamaidsa-jerajaro −nanaja napodsa aja pohua tessedeni: —Pajissehe huati tajari −quinahijine tohuini nadsa: —Ohuattissa onananitohui −nahi nade. Nadsapa poni attinidsa jehe najari. ");
INSERT INTO cul_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nadsapa pocca dodosse dosse inajari, Huano matto ca ijidsadsa tati dsojo icadsimaninijine. Nadsapa pocca dodosse toponi cocorohuaji toccajari, Huano matto ca ijidsajari. ");
INSERT INTO cul_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tati paratodsa ettidsadsa dsojo icadsimanidsapa dsohuatodsa da icanajari. Ponina imenidsa da icaniqquimajari. ");
INSERT INTO cul_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Dsotode Huano pohua huatimadedeni ima mittamanadsapa assiretohui jahijonajari. Ppa idsamanahijine dsojo ininemanadsapa siba odinidsa ibedsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nadsama Jeso pocca dodosse tabaqqui dosse inabaqquipojarideni jahiniqquijari. Jesodsa poccadeni benehicca ima huati nanimanajari: —Ima bicani dsati mari icanabaqqui-ridsadija. Ticca deni tojehe iadsa tinanajarojine madija coma tajari naco inanomibaqqui-ridsadija −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Nahidsa pohuadeni madimanahihuaji madija Jeso tohui quinadsa jahijonana canajari. Madija caji tadsa Jeso, pohua huatimadedeni tedseje dsepedeni ijimanahissa tadsapa jipamanahijine pajiramana-jarahi. Nadsapa: —Jina, madija madide nohuerahihuaji jaijana. Nanidsana jassi inaccana −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nama nadsapa Jeso pocca dodosse tabaqqui tedsejedeni todidi tanihuaji jassi quinahijine canoadsa tohuaccamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Naraha madija Jeso toccahi qqui toquinadsapa: —A, Jeso pajamarahihuaji toccahijine −quinajari. Nadsapa madija odsa onihi onihi naridsanicca jai tojabacossadsa Jeso tedsejema bacco toquinapojari. Naraha dsotode Jesopa pohua huatimadedeni tedseje canoadsa bacco najonamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Huana tocanamanadsa Jeso toqquemoradsapa madija domo hueri nahi qqui inabaqquijari. Pohuadenipa pina edede pohuadeni cacahuade jiraha pohuama mamadiri naridsamanajarissa quinajari. Nadsapa Jeso pohua bodidsa: —A, tohuati nahanaqquiri nahi −nadsa pohuadenitohui huati cahanari canajari. Nadsapa pocca ima onihi onihi nehe pohuadeni mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Maji toccadsa pohua huatimadedenipa Jeso pohuadsa huati toquinajari: —Jaho, maji toccahi −quinajari. —Ahuajipa madija madide nohuerahi −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","—Madija dosse tinanibaqquijo. Ahuajipa dsamatapa mitta quinahijine nohuerahi −quinajari. —Aji, odsa huajira tanicca dsamatapa mittade jai tojanina −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Naraha Jeso attia: —Tiadeni tinajipabaqquimanajo −najari. Naraha pohuadeni attipa: —Taparideni mittade jaijanijinepi dsiniro huemani pina 200 denario icajidsana pajiraraha ¿iana pohuadeni taparideni mittade jaijanijinerane? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nadsapa pohuadenidsa huati tajari: —¿Nejecoma naha pan ticajimanani? ¡Qqui taridsamanajo! −nahi nade Jeso. Pan, aba qqui toquinadsapa pohuadsa huati nanimanajari: —Pan 5, aba pama napaja −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nadsapa Jeso madija huapimadsa huati tajari: —Nani dsero napidsati caji tanidsa tiadenira jassi jassi tineri naridsaji −najari. ");
INSERT INTO cul_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nadsapa madija 100 quinaha queriqquidsa jassi tajari. Madija 50 quinaha queriqquidsa jassi tajari. Ohuahadeni naco totoqueriqquiri naridsadsa jassi taridsajari. Huapima nama naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nadsapa Jeso pohua dsepedsa pan inacca, aba idsaba nadsapa memehuaji qqui tamacossadsa Diodsa huati tajari: —Jehe, epejeni. Ticca daniji iadsa bica tahi −najari. Nadsapa Jeso canahatori canajarijine pan, aba najari tohuapidsa icanabobiridsadsapa pohua huatimadedenidsa da inabaqquijari. Nadsapa pohuadenina madija jassi jassi teri najaridenidsa da inabaqqui-ridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nadsapa jipamanadsapa accararidsa-manajari. ");
INSERT INTO cul_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jipamanahissa taraha mota tojajari. Pan bobi, aba ime mota inaccaniridsa-manadsapa quiqui 12 naha ijiridsajari. ");
INSERT INTO cul_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nadsama pan jipamanajaridenipa maqquideje 5 mil quinajari. ");
INSERT INTO cul_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nadsapa canahatori canahicca pan jipamanahi nattipa Jeso pohua huatimadedeni coridsa jippehuaji dosse inabaqquipojari: —Jari, canoadsa jai tijedsadsapi tahide odsa panani Besaidahuaji jai tijapoji, onajaro −nahi nade. Naraha Jeso pohuapa iboccajari. Nadsapa madija huapimadsa naco huati tajari: —Epejeni, jai tijanina −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nadsa jai tojanidsapa Jesopa ssonohuaji denima toqquemorajari, imehi Diodsa huati tahijine. ");
INSERT INTO cul_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jeso pohua motta nahi ssonohuaji Diodsa huatide tojadsa cadsomejari. Naraha pohua huatimadedenipa coridsa nocconi ori toquinahi paja naccaraha. ");
INSERT INTO cul_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nahidsa Jeso qqui icanamissabaqquijari. Ori ori quinaraha jojodejine canoa quehenacossajaro. Ssiajaricossadsa Jeso toqquedsippanidsapa passo tetepi toccamissajari. Pina ssiqui toccajarissa najari. Pohuadeni natti toccamissajari, pohuadeni inori tossoniqquimahitohuiraha. ");
INSERT INTO cul_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pohuadeni inorihuaji qqui toquinanaja passo tetepi ccajonahi qqui toquinadsapa johua johua quinajari: —¡Tocorime itidija! −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pohua huatimadedeni huapima qqui toquinadsapa jabojo quinajari. Nadsapa Jeso: —¡Ticappinamana tejeraji, ohuapi ohua! −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nadsapa canoadsa toqquedsanidsapa jojode totappajaro. Naraha jabojomana najarijine cappinamanahi paja naccajari. ");
INSERT INTO cul_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jeso huatimadedenipa Jeso pocca nahatohue aja pan da inabaqquidsa inapajira-ridsabaqquihi qqui toquinaporaha bodideni ssamoqquiri najari. Pohuadeni bodi Jeso tahimari mittamanahijine pajiramanahissa tajarajari. Bodidenidsa ahuatora tajaro. ");
INSERT INTO cul_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nadsapa Jeso pohua huatimadedeni tedseje coridsa jippehuaji tohuaqquejidsamanajari. Dsama onini Jenesare bacco toquinajari. Huana tocanamanadsapa canoa ssoque icadsanamanadsa jai tojemorajari. ");
INSERT INTO cul_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nadsapa jai tojemoradsa nahihuaji madimanajarideni Jeso qqui toquinajari. ");
INSERT INTO cul_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nadsapa madija comaqquiri najaridenitohui domodeni toccaniridsajari. Jeso ccaridsahihuaji comaqquiri najari taborodenima ihiaccamissa-baqquimana najari. ");
INSERT INTO cul_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesopa odsa onihihuaji toccadsa, dsotode odsa capamanihuaji toccadsa, odsa pananihuaji toccadsa naco madija pohuatohui bacco bacco nanajonamana najari. Huapima comaqquiri najari inanomibaqquihijine pohuadsa eheccajona-baqquimana najari. Pohua tedsejema jahuidsa, boronidsa naco ehequibaridsamana najari. Jesodsa huahua huahua quinajari: —¡Jeso ohua tinanomiji! ¡Ticca etero iponira bara onanijine ahuaji ticcajonaji! −quiquinanajari. Nadsapa pocca etero iponi bara quinajarideni huapimapa tocanomireridsahissa tajari. ");
INSERT INTO cul_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nadsapa huada onihidsa odsa panani Jerosarehuajicca jodiodeni marinaja pariseodsa jehe quinajarideni, jodiodenicca marinaja maridedeni tedseje Jesodsa bacco najonamanajari. ");
INSERT INTO cul_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Najari pohuadenina Jesocca mamari tabaqqui pohuadeni dsepe ssahuarahi jipamanahi qqui toquinajari. Najaropi pohuadenidsa bica tejerani. Pina imasiri inanamanajarossa najaro, quiquinanajari. Aja jodiodeni poccadeni ididenicca marinajadsa iboqquiri nadsapa oppina tani quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jodiodeni huapima, pariseodeni naco poccadeni ididenicca marinaja huapi tehe ecahuajonamanajaro. Najaro marinaja motapi jipamanabote nadsapa pohuadeni dsepe ssahua ssahua quiquinanapo najari. Najaropi obani noppineni jerani. Madija ohuaha aja jodio quejena-jarajarideni tedseje quejemamanajari noppine. ");
INSERT INTO cul_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jodiodenipa dadahuaji jahinidsa naco tahide pohuadeni dsepea ssahua quinapodsana jijipamana najari. Poccadeni jijipajinecca huapima pina parato, queneco, panera naqui ssahua ssahua quiquinanajari. Diocca dossenijipi nema nejeraraha jodiodeni poccadeni marinaja huapi tehe Dio Attidsa inaharimanajaro. ");
INSERT INTO cul_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nadsapa pariseodeni, jodiodenicca marinaja maridedeni tedseje Jesocca mamari tabaqqui pohuadeni dsepe ssahuarahi jipamanahi qqui toquinadsapa Jesodsa huati toquinajari: —¿Nejecotohui ticca mamari tabaqquipa jodio quejenaraha icca ididenicca marinaja ecahuamana-jerajaro? Ajana, pohuadeni dsepe ssahuarahi jipamanadsapa Diodsa bica tejerani, iadsa naqui oppina tani, ihinanajaro −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nadsapa Jeso pohuadenidsa huati tajari: —A, tiadeni naqui Diocca dosseniji nahatoqquiri tiquinaraha tecahuamananissa tejerajaro. Tiadenipi maidsehe ticajimanani. Maittaccadsama Diojine Pohua Atti cacomerabote Isahiapa ticcadeni imassa nehe dsodo inapojaro. Jidapanana najarossa najarodsa timadimanajaro. Ajana, maittaccadsama Diojine Isahiapa: “Ajajarideni madijapa ohuadsa: ‘Dio, tiapi bica tinani’ quiquinanaraha pohuadeni bodidenidsa otohui quina-jarahi. ");
INSERT INTO cul_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pohuama ohuadsa jiri jiri quiquinanajari. Pohuadeni maride naco: ‘Dio Atti mari mari inajaro’ quiquinanaraha madijacca marinajara mari mari nanaridsamana najari” napohui nade Dio. ");
INSERT INTO cul_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ajina, madijacca marinajana tiadenidsa denima bica tadsapi Diocca dossenijipi tinebomanajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jeso denima huati tapomajari pohuadenidsa: —Ticcadeni madijacca marinajadsa disseraqquiri tiquinadsapi Diocca dosseniji ponima tinanamanajaro. ");
INSERT INTO cul_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pina ajijaro imassa najaro Diocca dosseniji Moisesi huati iqquimajaro: “Ticcadeni abidsa, ticcadeni amidsa tetideni huanaqquiri nana. Pohuadenitohui tetideni huanaqquiri nadsa attidenidsa iboraqquiri tiquinana” napohui nade. Pohua atti naqui: “Madijapa imehidsa, imenidsa imasiri inanadsapi manaco najaripa dsoqquehitohui” napohui nade Dio Atti, Moisesijine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Naraha tiadenidsapi ima ajima najarona bica tajaro: “Madija imehidsa, imenidsa pohua attipa: ‘Jaho, tiadeni acco ocamabaqquinijineraha ocajijaro huapimapa Diodsa da onahijine onapodsapi tiadeni acco ocamabaqquinijine opajira-jerani’ quina tahi.” ");
INSERT INTO cul_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nadsa tettidenipi: “Jehe, madija nama nadsapa epeje, poni, pocca abidsa, pocca amidsa da inejerana” tiquinaraha. ");
INSERT INTO cul_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ticcadeni madijacca marinaja tipotemanidenidsa mari mari tatajonamana najarodsana: “Bica tani” titiquina nadsapi tijinedeni Diocca dosseniji pajissacca huahuattajo tojajaro. Ticcadeni madijacca ima najarossa najaro caji tani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Dsotodepa Jeso madija pohuahuaji jahijonahijine tohuideni huahua napomajari. Pohuahuaji bacco najonamanadsa Jesopa: —Jari, huapima ohuatti titaharibobo canaji, timittamananissa tanijine. ");
INSERT INTO cul_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tiadenidsapi jijipa oppina tahicca caji tahi. Madija nama nahicca jipadsapa tettidenipi: “Diodsa bica tejerani, Moisesicca marinajadsa naqui oppina tani” titiquina najaro. Naraha ohuattipi ajima najaro: Huapima itaparipa dappi inadsa ibodidsa tojadsapa imasiri toja-jerani. Naraha ebenodsa huati huati ihinanajarojinena madijadsa imasiri ihinanamana najaro.  ");
INSERT INTO cul_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −nahi nade Jeso.  ");
INSERT INTO cul_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nadsapa Jeso madija inebobaqquidsapa odsadsa toqquedsimajari. Nahidsa pohua huatimadedeni pohuadsa huati toquinajari: —Ia Maride ¿ticca marinaja nejecoma najaro? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nadsapa Jeso attia: —¿Tiadeni naqui ohuatti timittamana-jerajaroqui? Nema nadsapi timittamananissa tanijine tiadeni mari ocanabaqquipomana. Aja itapari huapima dappi inadsapa ibodidsa imasiri toja-jerani. ");
INSERT INTO cul_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Itaparipa ibodi huahuato nanihuaji toqquedsima-jarahi. Itaparipa idsonedsana totoqquedsima najari. Dsotode miji inadsapa toqqueqquimajari −nahi nade Jeso. (Pohua atti nama nadsapa itapari huapima oppinera tahi, najari.) ");
INSERT INTO cul_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesopa denima huati tajari: —Naraha madija pohua ajaridsa qquenajaropi pohua bodi huatodsa pohua ebenojine huati huati tajarijinena imasiri totoja najaro. ");
INSERT INTO cul_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ajina, tabaccorehe huapimapi madija pohua bodidsa ahuatomadsa pohua todossenidsapa imasiri inanajaro. Najaropi pina madija imasiritohui pohua bodi huatojari, maqquideje tabiraraha amoneje ajade tohuini najari, amoneje tabiraraha maqquideje najade tohuini najaro, botie tohuini najari, madija inanadsoqquehijine tohuini najari. Najaro ima madija pohua bodidsa ahuatomadsapi imasiri toja tani. ");
INSERT INTO cul_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Tabaccorehe onihi naqui pina madija amoneje cajiraha amoneje onihi ajade tohuini najari, amoneje maqqui cajiraha maqquideje ohuaha najade tohuini najaro, madija ohuaha cajijaricca tohuini najari, ima tabaccora tajaro inananijine tohuini najari, madija icamaidsabaqquihijine tohuini najari. Najaro ima madija pohua bodidsa ahuatomadsapi imasiri toja tani. Tabaccorehe onihi naqui pina pohua cacahuade jipera tadsa huapima ponima tohuini najari, madija deni tojehe acconi bodi huadi tajari, madija tatamasso nahijine tohuini najari, pohua bodi “Ohuana bica onajaro, deni ojani” najari, madide ssamo tadsa maidsehecca imadsa pajissa najari. Najaro ima madija pohua bodidsa ahuatomadsapi imasiri toja tani. ");
INSERT INTO cul_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Najaro tabaccorehe huapima madija pohua bodidsa ahuatomadsa pohua bodi totabaccorajari. Najarojinena madija imasiri ihinanamana najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nadsapa nahihuaji mari icanabaqquia jicadsapa Jeso toccajari. Odsa panani onini Tirocca dsamahuaji toccajari. Nahihuajicca odsadsa bacco tadsapa mohuaradsa Jeso toqquedsimajari. —Bacco onani madija motadeni ssamoqquiri nana −najari. Naraha pohua bacco nahi ima tojaridsajaro. ");
INSERT INTO cul_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Naneje amoneje —Jeso ajadsa bacco nahi −quinahi ima mittadsapi pohuatohui toqquedsimajaro. Poni bedeni tocorime cajijaro. Imeni bodinipi: —Ajarina occa ejedeni inanomihijine pajirahi −nadsapi Jeso pohua baccohuaji poni pitonidsa huittajaro. ");
INSERT INTO cul_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Poni attinipi: —Jeso, occa ejedenidsa tocorime madidsahi. Dosse tininejo, tonominijine, onajaro −nani nade imeni. Naraha najaro amonejepi jodio jerani. Ponipi dsama Siria arobeni Penisiahuajicca madija. ");
INSERT INTO cul_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nadsapa Jeso ponidsa huati tajari: —Madija ohuaha jodio quejena-jarajari acco ocamabaqquipohuijinepa bica tejerani. Najaro imapi pina madija pocca ejedenidenidsa dsamatapa da inaraha idinidsa pocca ettedsana da inajarissa najaro. Ejedenidenipa tahide jipamanapona, onajaro. Aja Diocca madija jodiodenina acco ocamabaqquipohuijine bica tani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nadsapi pohuadsa huati tajaro: —Pajissa ohua Medsede, naraha jijipacca huahuanari dopanidsa ejedenicca dsamatapa tabottodsa ette naco jipajari. Jodio ojajeraraha ohuadsa ticca acco camehe badsira tehe tinanaji, onajaro −nani nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nadsapa: —Jehe, tetti nema nadsapi bica tani. Ticcanina. Ticca ejedeni bodinicca tocorimepa toqquenahi −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nadsapi toccanijaro. Ponicca odsa bacco tanidsa toqquedsimanidsapi poni bedeni tonominira qqui tajaro. Nadsapi mohuaradsa pori canajaro. Tocorimepa toqquenajari. Nohuerajari. ");
INSERT INTO cul_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesopa odsa panani Tirodsa joppemajari, odsa panani Sidohuaji toccahijine. Nahi Sidodsa tossoniqquima, ccahuajanidsapa dsama arobeni onini Decaporidsa ccaridsajari. Dsotodepa Carireacca coridsahuaji bacco tanijari. ");
INSERT INTO cul_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nahi Carireadsana Jesodsa madija huaribo didibote eccajonamanajari. Huati tahijine naco ebeno ssamo tajari. Ccaccajonadedeni attidenia: —Jeso, itesse tinanabicahijine tidsepedsa pohua bara tajo −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nadsapa Jeso aja huaribo didibote madija sibema domo huahidsapa iacca-cca nadsa pohua dsepedsa huaribo odini ororo icanajaro. Pohua ebeno naqui pohua dsepedsa ppito nadsa ebeno bara inajari. ");
INSERT INTO cul_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nadsama Jeso memehuaji qqui tamacossanaja pohua ssa tocanacossadsa pohua attidsa huati tajari: —¡Eppatta! −najari. (Najaro ettidsapi: —¡Teribo ssire-re naji! −najari.) ");
INSERT INTO cul_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Naneje pohua huaribo ssire-re najari. Pohua ebeno naqui tobicajaro. Nadsapa huati tahi tobicajari. ");
INSERT INTO cul_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nadsapa pohuadsa, pohua tessedenidsa naco Jeso huati tajari: —Ajijaro imapi tecomamanana −najari. Naraha amadsati pohua tahimari ecomeraridsa-manajaro. Jeso attipa: —Tecomamanaji, onapa −napomaraha joma quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aja, huapima jabojo quinaraha huatidsemanadsa attidenipa: —A, ima deni tojanijinecca qqui inani −quinajari. —Jesocca nahatohuepi huapima bica tani. Ajana, huaribo didi taraha pohuajine huaribo tobicadsapa tohuatti mittajari. Atti cappiraraha pohuajine atti cajijari −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nadsapi huada onihidsa naqui madija huapima Jesodsa queriqquipomajari. Madija huapi taraha jipamanahijine dsamatapa jicajari. Najaria aja Jeso pohua huatimadedeni huahua inabaqquidsa pohuadenidsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Madijadsa ohuati cahanariri canani. Huada 3 nehe ohuadsa jahiridsadsapa pohuadeni tapari jicajari. ");
INSERT INTO cul_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Naraha jipamanahijine poccadeni odsahuaji dosse onanibaqquidsapa pemi huatiacossaja camarana. Motadenipa dsamarideni huaji tani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Naraha Jeso huatimadedeni attidenia: —Naraha iapi madija madide nohuerahihuaji iqueriqquidsapi ¿nejecoma inadsa madija inajipabaqquihijine? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nadsapa pohuadenidsa huati tajari: —¿Nejecoma naha pan ticajimanani? −nahi nade. Naraha: —Pan 7 naha icajini −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nadsapa Jeso madijadsa: —Huapima jassi tinaridsaji −nahi nade. Nadsapa Jeso pan 7 naha pohua dsepedsa inaccadsa Diodsa huati tajari: —Jehe Abi Dio, epejeni, ticca daniji iadsa bica tahi −nadsapa pan icanabobiridsajari. Icanabobiridsadsapa pohua huatimadedenidsa da inabaqquijari. Pohuadenina madija huapimadsa da inabaqqui-ridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aba bedi naco pamaha cajimanajari. Najari naco idsaba nadsa Jeso Diodsa huati tapomajari: —Jehe Abi Dio, epejeni, ticca daniji iadsa bica tahi −nadsapa idossebaqquijari: —Aba naco da tinabaqquimanajo −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nadsapa Jeso canahatori canajarijine pan, aba najari tohuapidsa madija huapima jipamanadsapa accararidsa-manajari. Jipamanahissa taraha mota tojajari. Pan bobi, aba ime mota inaccaniridsa-manadsapa quiqui 7 naha ijiridsajari nade. ");
INSERT INTO cul_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nadsa madija jipamanajaridenipa 4 mil quinajari. Jipamanaha jicadsapa Jeso dosse inanibaqquijari nade. ");
INSERT INTO cul_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nadsapa Jeso pohua huatimadedeni tedseje canoadsa jai tojedsajari. Coridsa jippehuaji tohuaccamanadsapa dsama Daomanotahuajina bacco toquinajari. ");
INSERT INTO cul_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesopa coridsa jippehuaji bacco nanipomadsa nahicca Isaraeri potemahi jodiodeni mota marinaja pariseodsa jehe quinajaridenipa pohua qquide jahijonajari. Jesodsa bacco quinadsapa pohua tedseje ahuaji huati ahuaji huati quinajari. Pohuadeni bodipa: —Jeso nattome inana, pocca ima tossamonijine −quinadsapa Jesodsa huati toquinajari: —Jeso, pajissa Diocca dacorehe ticajidsapi memehuajicca nahatohue bicabote ahuato tinanaji. Qqui inana, inajaro −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nadsapa Jeso pohua bodi tonacasserahi nadsa jadsirema pohua ssa tocanacossadsa huati tajari: —¿Nejecotohui aja jidapana madija madimanajaridenipa ocanahatoriri cananijine tohuira huati toquinajari? Pajissara tiadenidsa huati onajaro: Jidapana madimanajaridenidsa occa nahatohue onahatona onejerani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nadsapa inebobaqquidsa canoadsa toqquedsanipomadsapa pocca dodosse tabaqqui tedseje jippehuaji jai tojajari nade. ");
INSERT INTO cul_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Coridsa jippehuaji jai tojaraha jipamanahijine poccadeni dsamatapa huatideni ajamamanadsapa dsojo quina-jarahi. Pohuadenipa pan ojaria nahi canoadsa cajimanaraha huapimadsa pajira-jarahi. ");
INSERT INTO cul_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nadsama nahi canoadsa jassi dsadsa Jeso pohuadenidsa huati tajari: —Tetideni huatoji. Jodiodenicca marinaja onini pariseo, aji tamine Herodecca ima naqui pina pan ssaja tahijine quequejema tahimarissa najaro. Paji, najaro tiadenidsa toja-jeranijine tiadenipi dacoco tijiraji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pohua atti nama nadsapa pohua huatimadedeni pohuadenira ojidsa huati tocanirere canajari: —¿Nejecotohui pohua atti nama najari? Aji ijipanijine pan icappirajarocca huati tajarirana −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Naraha Jesopa pohuadeni bodi nahato tajari: —¿Nejecotohui pan ticappiramananicca imadsara imahaha ticanajaro? ¿Nejecoma nadsa ticahatteranijine? ¿Nejecoma nadsa occa marinaja timittamananijine? ¿Tibodideni najoqquiri najarorane? ");
INSERT INTO cul_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tinoccodeni ticajimanaraha ¿qqui tiquinejerajaroqui? Teribodeni naqui ticajimanaraha ¿timittamana-jerajaroqui? Tinoccodenidsa qqui tiquinaporaha ¿tetideni ajimama canajarorane? ");
INSERT INTO cul_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Madija 5 mil quinaraha pan 5 naha dside onariridsadsa jiparidsamanajari. Motapa quiqui ijiridsahi ¿nejecoma naha tidiridsamanatta? −najari. Nadsapa: —Quiqui 12 nade −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nadsapa Jeso: —Aja madija 4 mil quinaraha pan 7 naha dside onariridsadsa jiparidsamanajari. Motapa quiqui ijiridsahi ¿nejecoma naha tidiridsamanatta? −najari. Nadsapa: —Quiqui 7 nade −quinajari pohua huatimadedeni. ");
INSERT INTO cul_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nadsapa pohuadenidsa Jeso attipa: —Pan ijipanijine ocanahatoriri canani opajirani. Naraha pan ticappiramananicca ima huati onejerapa. ¿Ticahattera-jeraccajaroqui? −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nadsapa Jeso pohua huatimadedeni tedseje odsa panani Besaidahuaji bacco toquinajari. Nahicca madijapa Jesodsa nocco siri eccajonamanadsa attidenipa: —Jeso ¿ettidsa jipa tinaqui? Itesse nocco bara tajo, inajaro −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nadsapa Jeso nocco siri dsepedsa dama inadsa odsa panani huapihuaji iaccajari. Nadsapa pohua nassopedsa nocco siri nocco ppaja inanajari. Nadsana bara inadsa pohuadsa huati tajari: —¿Nija, tinocco tohuatoqui? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nadsapa pohua nocco ssire-re nadsapa: —Jehe, madija qqui onabaqquiraha pohuadenipa pina ahua domoni ccaridsajarossa quinahi −nahi nade nocco siri. ");
INSERT INTO cul_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nadsapa nocco bara inapomadsapa nocco tohuatonissa tajaro. Huapima qqui taridsahissa tajari. ");
INSERT INTO cul_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nadsapa dosse inanijari pocca odsahuaji: —Jehe, ticca odsahuaji ticcaniji. Naraha odsa pananihuajipi tiqquedsimani-jeraccaji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nocco siri tonomihi dsotodepa Jeso pohua huatimadedeni tedseje jai tojajari. Odsa panani Sesarea de Piripo jahuihuaji jai tojadsapa nanihuajicca odsa capamema najaro onihidsa onihidsa jahiridsajari. Nadsa jahui jai tojadsa Jesopa pohua huatimadedenidsa huati tajari: —Madija otahimari huati huati nanaridsamana nadsapa ohuadsa attideni ¿nejecoma nejecoma quiquinanahi? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Naraha pohuadeni attipa: —Tiadsa madija motapa: “Huano Baotista tijani” quiquinanajari. Ohuahadenipa: “Maittaccadsamacca Dio Atti cacomerabote Eria tijani” quiquinanajari. Ohuahadeni naco: “Maittaccadsamacca Dio Atti cacomerabote ohuaha tijani” quiquinanajari −quinahi nade Jeso huatimadedeni attidenipa. ");
INSERT INTO cul_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nadsapa Jeso pohuadenidsa huati tapomajari: —Naraha tiadenidsapi ¿nejecojari ojani? −nahi nade. Nadsapa manaco Pedro huati tajari: —Tiapi Cristo-Mesia tijani −najari. ");
INSERT INTO cul_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nadsapa Jeso pohua attipa: —Jehe, bica tani. Naraha occa imapi madija ohuahadenidsa tecomamanaccana −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesopa pohua huatimadedeni mari icanabaqquidsapa ajama najari: —Aji ohuapi Madija Bedi ojajaroa nidsa dsotode najidsohue imeni ocasserani ohuanitohui. Jodiodeni ime jocohuideni, dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajaridenipa ohua ettajomananitohui. Nadsapi ohua inanadsoqque-mananitohui. Naraha ohua ppa idsamanaraha huada huatinimade tojari nadsapi Abi Dio ohua nahatonihitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jeso pohua tedsejemacca ima huati tadsa ahuato tajaro. Naraha Pedroa Jeso iacca-cca nadsa huati tajari: —Jidacca ima huati tinajaro ticca ima nema najaro imapi huati tina tejeraji −nahi nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Naraha Jeso tahide huajanidsa pohua huatimadedeni icattabaqqui nadsa Pedrodsa huati tajari: —¡Paji, otedsejemapi! Ohua teccocco tejeraji, onajaro. Tettipi pina maidsehe jinede Satana attissa nani. Tiapi Dio jipa tahicca ssamo tinani. Madija tohuini quinajariccana nahato tinajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nadsapa Jeso denima mari icanabaqquihijine madija huapima, pohua huatimadedenima huahua inabaqquijari. Pohua attipa: —Aji “Jesocca madija iquejenana” tiquinadsapi tiadeni tohuini tiquinanicca tohui tetideni ajimamanaji. Ohuadsara disseraqquiri tiquinaji. Madija tiadenidsa: “Ahua porimacossanidsa tidsoqqueji” quinadsa naco: “Jehe, odsoqqueni bica tani. Jeso onebo-jarahi” titidsanapomana nana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tiadenipi ticcadeni madie ohuadsa teccoramanadsapi otahimari madija tocassiejerahijinecca maride tiquejenadsa naqui madija tiadeni tonajicabaqqui-manaraha camittehe jiquejeranicca ticajimana-dsanaponitohui. Naraha madija ohuaha pocca madie ohuadsa acco tadsa ajijaro namidsa madi-dsanapohuijine tohuinira nadsapa dsoqquehitohui. Dsoqquedsapa camittehe jiquejeranicca caji-jarahitohui −nahi nade Jeso atti. ");
INSERT INTO cul_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—Madija naco ajijaro namicca biquehe tohuini madidsa, ajijaro dsamacca ima deni tojanicca tohuini madidsa naco huapima pohuadsa tojaraha Diotohui najaradsapa nidsa pohua dsoqquedsa jororoni jiquejeranihuaji dsori tajarahitohui. Nadsapa pohua cajijaricca huapima ponima tojanitohui. ");
INSERT INTO cul_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pohuapa pohua cajijariccadsa camittehe jiquejeranicca mitta inanijine ssamo tani. ");
INSERT INTO cul_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aja jidapana madimanajarideni Dio Atti inebomanadsa imasiri ihinanamana najaro. Najarideni noppine madija cappinamanadsapa: “Jesocca madija ojajerani” quina tahi. Occa marinajadsa naco: “Omittana onejerani” quina tahi. Nama quinadsapa manaco ohuatti pohuadenidsa: “Occa madija tiquejena-jerani” onanitohui. Ohuapi Madija Bedi ojajaroa nidsaranibote ajijaro namidsa occaronapomadsapi occa Abi Dio ssiejenema, pocca dodosse tabaqqui memehuajicca tedseje occaronapomanitohui. Nadsana: “Onocco jidsa tani pohuadenidsa” onanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesopa pohuadsa queriqquimanajaridenidsa denima huati tajari: —Ohuapi pajissara tiadenidsa huati onajaro. Ajidsa tidomodeni huajaro motadenipi tidsoqquemana-jeraccadsama Diocca cacahuehe dacorehema ccajonani qqui tiquinanitohui −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nadsapa Jeso najaro ima huati tahi nattini huada 6 nadsa ssonohuaji toqquemoradsapa Pedro, Satiaco, Huano quinajaridenira iaqquemorabaqquijari. Jai tojemoradsapa ssono tetepihuaji bacco tomoramanajari. Nahidsa qqui toquinanaja Jeso pano todsibehijaro. ");
INSERT INTO cul_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pocca etero naqui amadsati todsibehijaro, nopo tajaro. Najaro noponipi madija ssamoqquiri nahi. Madija iapi etero ssabo ssabo inaraha ijine najarossa nanijine pajira-jerani. ");
INSERT INTO cul_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nadsapa qqui toquinanaja Eria, Moisesi tedseje Jesodsa ahuatomanadsa imahaha canajari. Pohuadenipa maittaccadsamacca Dio Atti cacomeraqquiri najarideni Jesohuaji ahuatoma-manajari. ");
INSERT INTO cul_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Nadsapa Pedrodeni cappinamanajari. Naraha Pedro pohua bodidsa: —¿Nejecora huati onanijine? −nanaja pohuama pohua atti Jesodsa: —Ia Maride, iapi ajidsa iquejenadsa bica tani. Ticcadeni odsa huahuaqquide 3 canehe inahatona. Nadsapi tiadsa, Moisesidsa, Eriadsa cananijine −nahi nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Naraha amadsati pohuadeni tetepihuaji esseni ccaronajaro. Ccaronadsapi pohuadenidsa ijihuajanijaro. Nadsapa nahi esseni bodidsa atti qquenajaro: —Ajajaripa occa Ejedeni. Pohuadsa ohuati huana tajaro. Pohua atti timittamananissa taji −nahi nade Dio. ");
INSERT INTO cul_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nanaja qqui toquinaraha Jesodsa madija ohuahapa domo hua-jarahi. Pohua motta hua canajari. ");
INSERT INTO cul_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nadsapa ssonohuaji jahidsippanidsa Jeso pohuadenidsa huati tajari: —Aji ssono tetepidsa qqui tiquinajarocca imapi tecomamanaccana. Ohuapi Madija Bedi ojajaropi nidsa odsoqqueni nattini onahatonidsana najaro ima tecomeramananijine bica tani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pohua atti nama nadsapa madija ohuahadsa huati toquina-jararaha pohuadenira imahaha canajari: —¿Nejeco imara huati tajari? Pohua attipa: “Onahatoninitohui” naha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nadsapa Jesodsa huati toquinajari: —¿Nejecotohui jodiodenicca marinaja maridedeni attipa: “Cristo-Mesia ccajona-jaraccadsama Dio Atti cacomerabote Eriana tahide ccanipohuitohui” quiquinanajari? −quinahi nade pohua huatimadedeni. ");
INSERT INTO cul_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nama quinadsapa manaco Jeso pohuadenidsa: —Pajissa, tahidepa Eria ccanipohuitohui, ima huapima icattemaridsaponijine. Naraha ohua Madija Bedi otahimaripi Diojine Pohua Atti cacomeraqquiri najarideni dsodo quinapojaro. Najaroa aji nanajidso ojadsapi ocasserani ohuanitohui. Madija naco ohua jaja icanamananitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","—Naraha ohuattipi: Eriapa ccanipode, onajaro. Aja Eria dsoqquejari ccanipo-jararaha madija ohuaha pina pohuassa najari ccajonadsa ima icattemaridsapode. Naraha nacasserehe pohuadsa inanamanade. Najaro ima pohuadsa tojajaropi maittaccadsama Dio Atti dsodo napojarossa najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nadsapa Jeso, Huano, Satiaco, Pedro quinajarideni Jeso pohua huatimade mota madimanahihuaji bacco dsippanimanabote nadsa qqui toquinajari. Pohuadeni tesse madimanahidsa madija huapi taha toqueriqqui najari. Nahidsapa jodiodenicca marinaja maridedeni Jesocca madija tedseje ahuaji huati ahuaji huati quinajari. ");
INSERT INTO cul_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Naraha Jeso bacco nanihi qqui toquinadsa huatidsemanajari: —A, Jeso bacco nanihi −quinadsapa pohuadsa nija quinahijine pohuahuaji domo toqquejidsajari. ");
INSERT INTO cul_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Nadsapa Jeso pohuadenidsa huati tajari: —¿Nija, nejecotohui ahuaji huati ahuaji huati tiquinajaroneje? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nahidsa madija ojaria Jesodsa huati tajari: —Ohua Maride, occa ejedeni tiadsa ohuaccajonajaripa. Pohua bodidsa tocorime madidsajari. Najarijine atti cappirajari. ");
INSERT INTO cul_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pohua dama inadsa jadsirema cco inacossadsapa namidsa edima bohua nadsapa pohua ajari ssabojene tocca tocca najari, ino ccado-do-do najari, assirema ccara-ra ccara-ra najari. Occa ejedeni nama nama nadsa tetimadedenidsa huati onajaropa: “Occa ejedeni pohua bodicca dosse tininemanajo” onaraha ssamoqquiri napaja −nahi nade imehi atti. ");
INSERT INTO cul_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nadsapa Jesoa: —Jaho, madija huapima Diodsa jehe tiquinanissa tejerani. Tiadeni mari mari ohocanabaqqui naraha ¿nejecoma nadsa ticahatterapadseje? Ticcadeni jeheniji pajiranissa tejeradsapi ohuadsa ocassera taraha ¿nema nehe onahana-dsanaponijinequi? −nanaja: —¡Jari, ticca ejedeni ohuadsa teccajonajo! −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nama nadsapa pohuahuaji ejedeni eccajonamanajari. Naraha tocorime Jeso qqui tadsapa ejedeni quidsa inanajari. Namidsa tohuedimajari. Dehue naridsadsapa ajari ssabojene toccajari. ");
INSERT INTO cul_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nadsapa coma tajari imehidsa Jeso huati tajari: —¿Pohua coma tahicca abadsico nejecoma canahi? −najari. Naraha imehi attipa: —Badsira tadsamade −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—Huajijiradsa quidsa inanadsapa dsippodsa naco ihinassonidsana najari. Passodsa naco ihinassonippa nanaja najari, inanadsoqquehijine. Nadsapi Jeso tiana nahato tinanitide. Iadsa teti huana taji, ia acco ticamabaqquinijine −nahi nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Naraha Jesopa: —Jaho, tettipi ohuadsa: “Tiana nahato tinanitide” tajaro nema tejeraji. Madijapa pohua bodi Diodsa jehe nahissa tadsapa nahato tajari: “Diopa ima huapima inananijine pajirahi” najari −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nadsapa imehia atti mohui tadsa huati tajari: —¡Jehe, Diopa pajirahi! onajaro. Naraha obodi acco ticamaji, occa jeheniji todacorani nanijine −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nadsapa Jeso qqui tanaja madija pohuadsa queriqquijonahi tohuapihi nahi qqui tadsapa tocorime dosse ininejari. Pohua attipa: —Tocorime, tohuaribo sibehe totonanade, tohuebeno totonassamode, tia dosse omajaro. ¡Ejedeni tinebojo! ¡Tiqquenadsapi tiqquedsimanipoma-jeraji, onajaro! −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nadsapa tocorime johua najari. Pohuajine ejedeni huatiacossadsa dari-ri-ri nadsapa qquenajari. Nadsapa ejedeni pina huatiajarissa naha ponajari. Nama nadsapa: —Huatiahi −quinajari nade. ");
INSERT INTO cul_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Naraha Jeso ejedeni dsepedsa dama inadsapa nomi taha inatehema najari. ");
INSERT INTO cul_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nadsa dsotode Jeso odsahuaji toqquedsimanidsapa pohua huatimadedeni motaha: —¿Nejecotohui iaha ajari ejedeni bodicca dosse ininehijine ipajira-jerapa? −quinajari. ");
INSERT INTO cul_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nadsapa Jeso attia: —Nama nahicca dosse tininemanahijinepa Diodsa huati tiquinadsana toqquena tahi −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nadsama nahidsa nebomanadsapa jai tojanijari. Dsama arobeni Carireahuaji jai tojeqquimajari. Naraha Jesopa pohua toqqueqquimahi madija nahatoqquiri nahijine jipera tadsa pohua cacomadsa toqqueqquimajari. ");
INSERT INTO cul_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Aja Jeso nema najaripa pohua huatimadedeni pohuadenira maride dsepe ijihijine. Pohua attipa: —Ohuapi Madija Bedi ojajaroa nidsa dsotode madija ojaria ohua ccaccoradsapa madija dsepedenidsa ojadsapi ohua inanadsoqque-mananitohui. Ohua ppa idsamanaraha huada huatinimade tojari nadsapi Abi Dio ohua nahatonihitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Naraha pohuadenipa pocca marinaja mittamanahissa tajarajari. —¿Nejecoma tajaro? −quinahitohuiraha cappinamanadsapa Jesodsa huati toquina-jarajari. ");
INSERT INTO cul_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Nadsapa Jeso pohua huatimadedeni tedseje odsa panani Capernaohuajicca jahui jai tojanidsa Jeso huatimade pohuadenira imahaha tocananijari: —Aji ia huapimapi ¿nejecojarina deni tojajari? −tanimanajari. Odsadsa bacco tanimanadsapa jai tojedsimanijari. Nadsapa Jeso pohua huatimadedeni huati icanabaqquijari: —¿Nejeco imara jahuidsa imahaha ticananijaroneje? −nahi nade. Naraha pohuadeni bodipa: —Jeso icca imadsa jipera tahitide −quinadsapa ecomeramana-jerani. Tocadidire najari. ");
INSERT INTO cul_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nadsapa Jeso huittaridsa pohua huatimade 12 quinajarideni huahua inabaqquidsapa pohuadenidsa huati tajari. Pohua attipa: —Madijapa: “Ohuana deni ojani” najaripa Diodsa bica tajarahi. Madijapa: “Ohuapi ajimani ojani” najarina Diodsa bica tajari. Najaripa madija huapimadsa acco camade dissera tadsapa najarina Diodsa bica tajari. Aji pocca ima bica tadsapi pocca deni tojehe pajissacca ahuato tajaropaji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ejedeni huahua inadsa pohua huatimadedeni jassi nahuajanihi nocconidsa inahua najari. Nadsapa idi, dsojo ijidsadsa pohua huatimadedeni mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Pohua attipa: —Ajajari ejedenissa najaridsa tetideni huanaqquiri nadsapi ohuadsa naqui tetideni huanaqquiri najaro. Ohuadsa tetideni huanaqquiri nadsapi ohua Cadossede Abi Diodsa naqui tetideni huanaqquiri najaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nadsapa Huano Jesodsa huati tajari: —Ohua Maride, madija ohuaha tia oni hua nadsa madija bodicca tocorime dosse ininehi qqui inade. Naraha pohuapa iadsa ccaridsa-jaradsa pohuadsa: “Epeje taji. Poni” inade −nahi nade Huano. ");
INSERT INTO cul_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Naraha Jeso attipa: —Pohuadsa poni tiquinejeraji. Madija ohua oni hua nadsa canahatoriri canadsapa nidsa dsotode ohuadsa atti tabaccora tajarahitohui. ");
INSERT INTO cul_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Madija nama najaripa iadsa huadi tajaradsa ia acco camade tojajari −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","—Pajissara tiadenidsa huati onajaro: Aji ohuadsa tiquejenadsapi madijadenipa: “Jehe, pohuadenipa Cristo-Mesiacca madija, pohuadenidsa accora onana” quinadsa tiadenidsa da quinadsa bica tani. Passo dse tiquinanijine da icanamanadsa naqui manaco nidsaranibote Dio pocca biquehe pohuadenidsa inananitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesopa denima huati huati tajari: —Nadsama madija ojariajine ohuadsa jehe quinajari imasiri inanamanadsapi pohuadsa najidsohue oppina tanicca ssonarinitohui. Ejedeni ohuadsa jehe quinajarideni naco madija imasiri mamaridejine imasiri tocahatteradsapa aja imasiri mamaride pohuadsa najidsohue oppina tanicca ssonarinitohui. Pina ajijaro imassa najaro: Siba ccanajabote pohua mattodsa ssoque dsanadsa passo imenihuaji je tahijine cco todsippadsapa oppina taraha najidsohue denima oppina tanicca pohuadsa ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","—Nadsama imasiri tinana-jeranijinepi tibodi daco tijiradsa poni taji. Poni tejeradsapi ima oppina tanicca tiadsa ssonarinitohui. Pina tidsepedsa imasiri tinanabote naraha daco tijiradsa poni taji. Nema tadsapi pina tidsepe ca ticajidsajarossa najaro. Tidsepe cajarie amossi canaraha Diocca cacahuehedsa timadidsapi tetidsenitohui. Naraha imasiridsa dissera tinadsapi pina tidsepe capamehe ticajijarossa naraha jororoni jiquejeranihuaji ticcanitohui. Najaro jororonipi ohuihuira tani. ");
INSERT INTO cul_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","—Nadsama imasiri caji tanihuaji ticcanijine naqui tohuini taraha poni taji. Nema tadsapi pina temori ca ticajidsajarossa najaro. Temori cajariraha Diocca cacahuehedsa timadidsapi tetidsenitohui. Naraha imasiridsa dissera tinadsapi pina temori capamehe ticajijarossa naraha jororoni jiquejeranihuaji tia coro todsimahitohui. ");
INSERT INTO cul_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","—Nadsama tinoccodsa naqui tohuini tanicca qqui tinadsa imasiri tinananijine tohuini taraha daco tijiradsa poni taji. Nema tadsapi pina tinocco huari, joca, jeo, coro tinajarossa najaro. Tinocco ojariraha Diocca cacahuehedsa timadidsapi tetidsenitohui. Naraha imasiridsa dissera tinadsapi pina tinocco pamehe ticajijarossa naraha jororoni jiquejeranihuaji tia coro todsimahitohui. ");
INSERT INTO cul_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nanihuaji ocasserani tedsanaponitohui. Timeqquene ssari-ri cadsanaponitohui. Jororoni ohuihuira taniccadsa time ca dsanaponitohui. ");
INSERT INTO cul_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—Aji tiadeni huapima Diojine tibodideni tohuirenijinepi pina sahojine bani jadsi-jarajarissa nanitohui. Pina dsippo jororonijine bani cadsapa jadsi-jarajarissa nanitohui. ");
INSERT INTO cul_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sahopi bica tani. Banidsa huira nadsapi jadsi-jarahi. Naraha saho ajiboni tomossidsapi tomajidera tani, icca bani naco totabaccora tahi. Ajibo tapomanijine ssamo tani. Tiadenidsa ohuatti pina sahossa onanajaro. Ohuatti ticajimanana, imasiri tinanamana-jeranijine, madija ohuahadeni tinanabicabaqqui-manahijine. Titessedeni tedseje ticajonerara canaji, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jeso odsa panani Capernaodsa nebodsapa dsama arobeni Jodeahuaji toccajari. Hueni Jordao jippehuaji toccadsapa dsama arobeni Pereahuaji bacco tajari. Nahidsapa madija sibema pohuadsa queriqquipomadsapa mari icanabaqquijari. Jesopa nama nanaridsa najari. ");
INSERT INTO cul_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nahidsapa jodiodeni mota marinaja pariseodsa jehe quinajarideni Jesodsa jiperaqquiri nadsa pocca marinaja inassamomananijine ima najoramanajari. Jesodsa tohuajiressimanadsapa pohuadsa huati toquinajari: —Aja ¿maqquideje pocca amoneje inebodsapi pohuadsa ima nohueraqui? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Nadsapa Jeso attia: —Jari, tecomeramanaji: Maittaccadsama Moisesipa najaro ima mari icanabaqquipojaride. Pocca marinaja ¿nejecoma natte? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nadsapa pariseodeni attidenipa: —Jehe Moisesicca marinajapi ajima nade: “Maqquidejepa pocca amoneje inebonijinepi nebohuecca papeo dsodo inadsa ponidsa da inadsa inebodsapi pohuadsa ima nohuerani” nadija −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nadsapa Jeso huati tajari: —Jehe naraha najaropi maittaccadsama ticcadeni idideni huaribodeni sibaqquiri nadsa nebohue tohui quinadsapa Moisesi najaro marinaja pohuadenidsa dsodo inajarode. ");
INSERT INTO cul_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Naraha Dio dsama inahatoponipi amoneje nebo nebocca ima nohueraccade. Diojine madija toquejenapodsapa ima ajima najaro: “Maqquideje amoneje tadsajani inahatobaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Nema najarojinea maqquideje pohua bedimenidsa tojadsapa imehi imenidenidsa nebo, pohuadenira madimanajari. ");
INSERT INTO cul_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nadsapa pamaraha pina ojarijarissa quinajari” najaro Dio Atti dsodo nanidsa. Nadsapa pajissa assiredeni pamaraha cacajiredsapa Diojine pina ojarijarissa dsanapomanahijine. ");
INSERT INTO cul_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nadsama Diojine pina ojarijarissa quinaraha caneboredsapa bica tejerani. Madija ohuaha atti noppine caneboredsa naco bica tejerani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nadsapa Jeso pohua huatimadedeni tedseje odsahuaji jahinipomadsa odsa bodihuaji jassi dsadsapa Jesodsa huati toquinajari: —¿Ticca marinaja nejecoma najaro? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Nadsapa Jeso pohuadenidsa ima ecomerajaro: —Jehe maqquideje pocca amoneje inebodsa amoneje onihira icajidsapi pocca amoneje tahide inebojarodsa imasiri inanajaro. Nama nadsapa Diocca dosseniji ecahua-jerajaro. ");
INSERT INTO cul_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Amoneje naqui ponicca maqqui inebodsa ohuahara icajidsapa ponicca maqqui tahide inebojaridsa imasiri inanajaro. Nema nadsapi Diocca dosseniji ecahua-jerajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nadsapa madija poccadeni ejedeni Jesodsa eccajonabaqqui-manajari —Jeso tatideni bara inabaqquidsa Diodsa huati tahijine −quinadsa. Naraha Jeso huatimadedeni attidenia: —¡Ejedenipa pohua! ¡Jesohuaji teccajonabaqquimana tajarajo! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Naraha Jesopa pohua huatimadedeni ejedeni tedsejemadeni huacossamanahi qqui tadsapa huadijari. —¡Poni, nema tiquinejeraji! Pohuadeni jahijonana, onajaro. Eccajonabaqqui-manahijine tecossamana tejeraji. Madijapa pina ajajari ejedenidenissa quinajarina Diocca cacahuehedsa toquejenahitohui. ");
INSERT INTO cul_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pajissara tiadenidsa huati onana: Madijapa pohua bodicca jeheniji pina ejedenicca jehenijissa najaradsapa Diocca cacahuehedsa toja-jarahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nadsapa Jeso ejedeni idi, dsojo ijidsadsa tatidsa bara nadsa huati tajari: —Abi Dio, ticca biquehe ajajari ejedenidsa tinanaji, onajaro −nahi nade. Ejedeni ohuahadeni naco nama inanabaqqui-ridsajari. ");
INSERT INTO cul_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nahi dsotodepa Jeso jahui toccadsa pohuahuaji madija ojaria joppa najonajari. Jeso baccohuaji pohua pitodsa huitta nadsa huati tajari: —Nija, Mamaride bicahi ¿nejecoma onadsa camittehe jiquejeranicca bacco onanijine? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Naraha Jesopa: —¿Nejecotohui ohuadsa: “Mamaride bicahi” tajaro? Madija bicahi nohuerahi. Diona bica tahi ojarihi. ");
INSERT INTO cul_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Naraha camittehe jiquejeranicca bacco tinanijinepi Diocca dosseniji Moisesi dsodo inajarocca nahato tinani. ¿Najaro huapima tecahuanissa taqui? Diocca dossenijipi ajima najaro: “Madija tinanadsoqque-jarajo. Madija ohuahacca amoneje tija tejeraji. Tiboti tejeraji. Maidsehedsa naqui madijadsa ponima ima tinahana tejeraji. Madija ticamaidsa tajarajo” nani Diocca dosseniji. Pocca dosseniji onihi naqui: “Ticca abi, ticca amidsa bica tinadsa tinamadibaqquihissa tajo” nani Diocca dosseniji Moisesi dsodo inajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Naraha Jeso baccodsa huittajari attipa: —Mamaride, najaro marinaja huapimapi dsabisso ojapodsama ohuacahuajonajarode −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nadsapa Jeso icattoma nanaja pohuadsa huati tohuanahi nadsa huati tajari: —Naraha ima ojarie tiadsa dsori taccani. Ticcanidsa tidsepetaji nemanehe manaconidsa da tinaridsaji. Nani najaro dsiniropi madija tohuati nahanaqquiri najaridenidsa da tinabaqquinijine. Nema tinanadsapi nidsa memehuaji Diocca biquehe tiadsa tojanitohui. “Nema onana” tadsapi ohuadsara dissera tinaji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Najaro ima mittadsapa pano todsahi najari. —Jehe, nema onana −najarajari. Pohua dsepetajitohui, pocca dsinirotohui huati huana tajari. Pohuapa dsepe sse taja nadsapa bodi ocassera taha toccanijari. ");
INSERT INTO cul_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nadsapa Jeso cattahuajanihi nadsa pohua huatimadedenidsa huati tajari: —¡A, madija dsepedeni sseqquiri najaridenipa Diocca cacahuehedsa toquejenahijine najo tani! −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nema najaro ima pohua huatimadedeni mittamanadsa huajo canirejari. Nadsapa Jeso huati nimanipomajari: —Jaho, otessedeni, madija Diocca cacahuehedsa toquejenahijine najo tani, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pina bani imehibote camellopa etero ssessequi odinidsa toqqueqquimahijine pajira-jarajarissa najari madija dsepe sse tajaripa Diocca cacahuehedsa tojahijine ssamo tani −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nadsapa Jeso pohua huatimadedeni najaro ima mittamanadsa bodideni jabojomanadsapa huati tocanirere canajari: —Jaho, madija tocassiejerahijinepa ssamo tani. ¿Nejecojarina tossiajapadsaja? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Nadsapa Jeso pohuadeni icattabaqqui nadsa huati tajari: —Madijapa ssamoqquiri naraha Diodsapi ssamo tejerani. Pohuajinena madija tocassiejerahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Naraha Pedropa Jesodsa huati tajari: —Ia Maride, iapi tiadsa jaijaridsanijinepi icca odsa, icca madija, huapima ineboridsabaqquide −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Manaco Jeso atti: —Pajissara tiadenidsa huati onana: Madija ohua acco camahijinepa pocca odsa icanebo, pohua imecote inebobaqqui, pocca ami, abi inebobaqqui, pocca ejedeni inebobaqqui, pocca dsama inebo nadsapa otahimari madija tocassiejerahijinecca tojaridsanijine dsepe ijiridsajari. ");
INSERT INTO cul_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nadsapa nidsa dsotode huapima pohua ineboridsajarossa nehe Dio pohuadsa da inaridsadsapi cajipomahitohui. Jidapana ajijaro namidsa pohua madiccadsa huemani cajihitohui. Pohuadsa pina pocca odsa tohuapijarossa nanitohui. Pohua imecotedeni naco tohuapiridsahitohui, pohuadsa pocca amissa najaro cajiridsanitohui. Ejedeni ohuahadeni pina pocca ejedeni toquejenajarissa naridsahitohui. Dsama naqui pina pocca dsamassa najaro pohuadsa tojaridsanitohui. Naraha otahimari pohuadsa tojajarojine pohuadsa najidsohue ssonarinitohui. Nema nanitohuiraha nidsa dsama dsati tojadsapi camittehe jiquejeraniccadsa madi-dsanapohuitohui. Pajissa −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","—Naraha jidapana tiadenipi ajimani tiquejenaraha ajijaro imadsa tibodideni huatomanaji: Madija jidapana madimanajarideni motapa deni toquejenaraha nidsaranibotepa ajamani toquejenahitohui. Jidapana madimanajarideni mota ajamani toquejenajarideni naco nidsaranibotepa deni toquejenahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jeso pocca madijama Jerosarecca jahui jai tojadsapa pohuana tahide tojadsanapojari. Pocca dodosse tabaqquipa pohua nattihuaji jai tojajari. Jeso dsoqquehijine noppine cappinamanadsa huatideni huatoto cadsanapojari. Madija ohuahadeni pohuadeni nattihuajicca jai tojamissajari naco cappinamanajari. Nadsapa pocca dodosse tabaqqui 12 quinajari pohuadenira huahua inabaqquidsa pohuadsa queriqquijari. Nadsapa jahui jai tojadsa pohuadsa ima tojanijinecca huati huati dsanapojari. ");
INSERT INTO cul_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jeso attipa: —Jerosarehuaji jaijemorajaropi nahatoqquiri tiquinani. Ohuapi Madija Bedi ojajaroa nidsa Jerosare bacco inadsapi dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajarideni dsepedenidsa ojanitohui. Ohuadsa: “Dsoqquena, dsoqquena” quinahitohui. Dsotodepi madija ohuaha jodio quejena-jarajaridenidsa ohua da quinanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Najaridenina ohua jaja icanaqquimanajaro, ohua ppito inaqquimanajaro, ohua cossi inaqquimanajaro nanitohui. Nadsapi ahua porimacossanidsa ohua inanadsoqque-manadsa ohua ppa idsamananitohui. Naraha huada huatinimade tojari nadsa onahatoninitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nadsapa Sebedeo bedideni Satiaco, Huano tedsejepa Jesohuaji tohuajiressimanadsa huati toquinajari: —Ia Maride ¿ettidsa jehe taqui? Icca huatinajassa tinanaji, inajaro −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Manaco pohuadenidsa: —¿Nejeco imara tiadenidsa onananijine? −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nadsapa pohuadenia: —Ticca cacahuehe bicanihuaji madija cacahuade tittaridsapi tinoridsa ipahimarinijine ohuapi tinori nahatonihuaji ohuittari, ocotepa tinori ssamohuaji huittari inanijine ¿jehe taqui? −quinahi nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Naraha pohuadenidsa Jesoa: —A, najaro imapi ssamomo tinani. Ohuapi ocasserani ohuabote nani. Ohuadsa najidsohue ssonarinitohui. Aji tiadenipi najidsohue tinahanamananijine ¿tipajiramanaqui? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Jehe, ia naqui ipajirani −quinahi nade. Nadsapa pohuadenidsa Jesoa: —Jehe, pajissa ocasserani tinahanamananitohui. Aji ohua najidsohue onahanadsapi tiadeni naqui nidsa dsotode najidsohue tinahanamananitohui. ");
INSERT INTO cul_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Naraha memehuaji occa cacahuehedsa madija cacahuade ohuadsama pahimarihijinepa ohua dosse dosse onejerani. Abi Dio icattejidsa-baqquijaridenina ohuinoridsa pahimarihijine −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Naraha Jeso huatimade mota 10 quinajaridenipa najaro ima imahaha canahi mittamanadsapa Satiaco Huanodenidsa huadimanajari. ");
INSERT INTO cul_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nadsapa Jeso huahua inabaqquidsa pohuadsa toqueriqquidsapa pohuadenidsa huati tajari: —Tiadenipi madija ohuaha jodio quejena-jarajaridenicca madie nahatoqquiri tiquinani. Poccadeni taminedenipa dossede dacoraqquiri nadsa poccadeni madija dosse dosse quiquinanajari. Deni toquejenajari ohuahadeni naco poccadeni madija dacorehedsa ehecahuabaqquimana najari. ");
INSERT INTO cul_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Naraha aji ohuadsa tiquejenajaropi nema tiquinanijine bica tejerani. Naraha titessedeni ojariapa: “Ohuana deni ojana” nadsapa pohuana huapima bijideni acco icamaridsabaqquihijinena bica tani. ");
INSERT INTO cul_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Diocca cacahuehedsa deni tijanijinepi titesse bijideni acco ticamaridsajo, pina poccadeni medse tijajarossa tanijine. ");
INSERT INTO cul_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aji ohua Madija Bedi ojajaropi madija dosse dosse onanijine occajona-jerajaro. Madija acco ocamabaqquihijinena occajonajaro. Madija poccadeni imasiri manaconi pohuadenidsa ssonari-jeranijine poccadeni imasiri manaconipi ohuana ohua ohuaccoranitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nadsapa Jeso pohua huatimadedeni tedseje odsa Jericodsa bacco toquinajari. Nahidsa toqqueqquimadsapa pohua huatimadedeni, madija ohuahadeni naco huapi taha pohuadsa jai tojajari. Nani jahui inididsapa nocco siri huihuitta najari. Pohuapa Timeo bedi, onipa Bartimeo. Pohua dsepe da nadsa: —Ohuadsa dsiniro da tiquinaji −tatacossa najari. ");
INSERT INTO cul_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Najaria —Jeso Nasaretihuajicca toqqueqquimahi −quinahi ima mittadsapa Jesodsa huahua najari: —¡Jeso, Dabi Potemahi! ¡Ohuadsa teti huana taji onaha! −najari. ");
INSERT INTO cul_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Naraha madija motadenipa: —¡Poni! ¡Joma taji! −quinahi nade. Nama quinaraha denima paja huahua tarihi huahua tarihi najari: —¡Tamine Dabi Potemahi! ¡Ohuadsa teti huana taji! −napomahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nama nadsapa Jeso huaha tahi nadsa —Jari, huahua tajonamanajo. Ccajonana −nahi nade. Nadsapa nocco siridsa huahua quinajari: —¡Jehe, bica tani! Titehemaji, tiadsa huahua nahi −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nanaja pohua teteppe ssiti, totehemahi, Jesohuaji toqquessijari. ");
INSERT INTO cul_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nadsapa Jesoa: —¿Nejecora tiadsa onananijine? −nahi nade. Nadsapa nocco siripa: —Ohua Maride, onocco ssire tinanaji, onajaro −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nadsapa Jeso: —Epeje. Ticcaniji. Tibodi ohuadsa pajissa tadsapi tinomini −najari. Nadsapa Jesojine amadsati pohua nocco ssire tajari. Jerosarecca jahui Jeso denima toccadsapa Bartimeo naco pohuadsa toccajari. ");
INSERT INTO cul_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nadsapa Jeso, pohua huatimadedeni, madija huapima tedsejedeni jai tojajari. Odsa panani Jerosarehuaji tohuajiramanadsapa ssono onini Oribodsa jai tojemorajari. Najaro ssonodsa odsa capamema najaro pamehe anijaro, oninidenipi Betapaque, Betania najaro. Najaro odsa pamehedsa bacco toquinabote nadsa Jeso pohua huatimade pamahadsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Jari, ajicca odsa capamema nanihuaji ticadapoji. Nanihuajipi bojo namidsadsa napidsati ssoque dsanaha huahi. Najari bojopa idedsa madija huittari-jaraccahi. Najari dicca tiquinadsa teccanimanajo −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","—Naraha tiadenidsa madija attipa: “¿Nejecotohui bojo dicca tiquinajari?” nadsapa pohuadsa huati tiquinana: “Ia Medsede ajajari bojo tohui nadsapaja. Nidsa eccanihitohui” tiquinana −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nadsapa tohuedanaja, jahuidsa bojopa ssoque dsanahi bacco quinajari, odsa huajira tanidsa. Nadsapa bojo dicca quinajari. ");
INSERT INTO cul_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nanaja nahicca madija domodeni huajari attideni: —¿Nejecotohui bojo dicca tiquinajari? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Naraha manaco pohuadeni cacomeramanajari: —Ia Medsede tohui nadsapaja −quinahi nade. Nadsapa jehe quinadsa eccanimanajari. ");
INSERT INTO cul_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nadsapa bojo eccanimanajari... Jesohuaji bacco nanimanadsapa poccadeni etero huapicca motarajaro ssiti quinadsa bojo idedsa bina quinadsa nahidsa Jeso huittarijari. ");
INSERT INTO cul_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nadsapa madija huapi taha Jesodsa huatidsemanadsa pohua tedsejema jahui bina idsanapomanajaro, pohuadsa: —Deni tijani −quinahijine. Nadsapa jahuidsa pohuadeni teteppe namidsa hua idsanapomanani nade. Madija ohuahadenipa birijari eppe huamonicca ca ippimanadsa hua idsanapomanahi nade. Nadsapa Jeso jahui bina tani motta toccadsanapojari. ");
INSERT INTO cul_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Madija huapima pohua tedsejema jai tojaja, pohua nattihuaji jahijonaja dsanapomanajari. Pohuadsa huatidsemanadsa huahua huahua dsanapomanajari: —¡Diopa deni tojahi, deni tojahi! ¡Ia Medsede onima ccajonajaridsa biquehera tojana, tojana! −dsanapomanajari. ");
INSERT INTO cul_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","—¡Pohuapa icca idi tamine Dabi Potemahi bicabote! ¡Ia Cacahuade tojahijine ccajonahi! ¡Bica tahi, bica tahi! ¡Memehuaji Diodsa madimanajarideni pohuadsa: “¡Deni tijani!” quinana, quinana! −dsanapomanahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nadsapa Jeso Jerosaredsa bacco todsimadsa Diodsa dada toqquimahuaji toccajari. Nahihuaji toqquedsimadsapa qqui naridsahissa tajari. Qqui naridsaha jicadsapa maji toccajari. Nadsapa Jeso pocca dodosse tabaqqui 12 quinajari tedseje Betaniahuaji jai tojanijari, bacco tanimanahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huada ssiaja nahi Betaniadsa Jeso toccapomadsapa pemijari. ");
INSERT INTO cul_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nadsapa huaji tanidsa ahua iquiera eppe cajipomahi qqui tadsa: —Bono naco cajihitide −nahi nade. Naraha nahi bacco tadsapa eppe pohuara qqui tajari. Iquiera eppe cajidsapa bobono najariraha bono-jaraccahi. Pohua bonohuicca abadsico bacco tocana-jaraccajari. ");
INSERT INTO cul_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nadsapa Jeso ahua iquieradsa huati tajari: —¡A, apaja! Jidapapi tibono madija jipamanapoma-jarahitohui. ¡Nohuerahitohui! −nahi nade. Nahidsa pohua huatimadedeni mittamanajari. ");
INSERT INTO cul_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nadsapa Jeso Jerosarehuaji tocanajoranipomadsa Diodsa dada toqquimahuaji toqquedsimani-pomajari. Najaro odsacca boronidsa madija bani bedi Diodsa da tahijinecca dade toquejenahi qqui tajari. Manaconitohui dadadedeni qqui inabaqquidsapa huapima mohua ininebaqquijari. Mimittadedeni naco mohua ininebaqquijari. Dsiniro cacacajiqquimeradedenicca huahuanari naqui hua inaridsajaro. Midsori dadadedenicca huihuittari naqui hua inaridsajaro. ");
INSERT INTO cul_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Madija ohuahadeni naco najaro odsacca boroni motta todsepetaji dsojo dsojo ihiqquimamana nejeranijine Jeso ecossajaro nade. ");
INSERT INTO cul_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nadsapa Jeso huapima mari icanabaqquijari: —Dio Atti dsodo nanidsa ajima najaro: “Occa odsapi ohuadsa huati huati toquinahijinecca odsa tocajanitohui. Dsama huapimacca madija ohuadsa huatide jajahidsima nahijine” naponi nade Dio Atti dsodo nanidsa. Naraha tiadenipi madija titicamaidsa-baqquimana nadsa tijinedenia pina bobotidedenicca quequeriqqui odsassa ticananamanajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Naraha dada toqquimade taminedeni, jodiodenicca marinaja maridedeni tedseje najaro ima mittamanadsapa Jesodsa jiperaqquiri najari. Madija huapimapa Jesocca marinajatohui disseraqquiri nadsapa taminedeni, mamaridedeni tedseje Jeso deni tojahi noppine cappinamanajari. —Jesopa deni tojadsa ajimani iquejenarana −quinadsa Jeso dsoqquehijine jara jara quinajari: —¿Nejecoma inanadsa Jeso inanadsoqquehijine? −quinajari nade. ");
INSERT INTO cul_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naraha todsidsidsa Jesopa pocca dodosse tabaqqui tedseje Jerosaredsa jai tojenajari. ");
INSERT INTO cul_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nadsapa huada ssiaja dsidsidsamassa ahua iquiera huahihuaji jai tojapomajari. Qqui toquinapomadsapa jaboma botejari. ");
INSERT INTO cul_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nadsapa Pedro bodi huatomadsa Jesodsa huati tajari: —¡Ohua Maride, qqui tanaja! Maitta iquiera tettidsa tinajidsojaripa botea −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Naraha Jeso pohuadenidsa huati tajari: —Tibodidenidsa: “Diopa occa huatinajassa inananijine pajirahi” tiquinaji. ");
INSERT INTO cul_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pajissara tiadenidsa huati onajaro: Madijapa ajijaro ssonodsa huati tadsa: “Ssono, titehemadsa passo imenidsa jaro tidsanaji” nadsapa ssono nema nanitohui. Pohuapa jehe nahissa tadsa pohua bodi: “¿Pajissa tojapadseje? Nohueranitide” najaradsapa Diojine ssono jaro dsananitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Najaroa ohuatti: Diodsa huati tiquinadsapi tibodidenidsa: “Jehe, Diopa nema inananijine pajirahi” tiquinadsapi ticcadeni huatinaja Diojine najarossa inananitohui, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","—Diodsa huatide tiquejenadsa naqui madija tiadenidsa ima inanapojarotohui tibodideni huatodsapi: “Najaro imadsa ohuati ajimana. Pohuadsa ohuadi-jerana” tiquinaji, onajaro. Nema tiquinadsana ticcadeni Abi Dio memehuaji madijaripa ticcadeni imasiridsa huati ajamahitohui.  ");
INSERT INTO cul_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Naraha tibodideni najaridsa epeje tiquinejeradsapi ticcadeni Abi Dio memehuaji madijaripa ticcadeni imasiri epeje inana-jeranitohui, onajaro −nahi nade Jeso.  ");
INSERT INTO cul_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nahi dsotodepa Jerosarehuaji bacco tanimanapomajari. Nadsapa Diodsa dada toqquimahuaji Jeso toqquedsimadsapa pohuadsa jiperaqquiri najarideni aja dada toqquimade taminedeni, jodiodenicca marinaja maridedeni, jodiodeni ime jocohuideni quinadsa Jesodsa tohuajiressimanajari. ");
INSERT INTO cul_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nadsapa pohuadsa huati toquinajari: —Iadsa ticca ima tecomeraji. ¿Nejecojaricca dacorehe ticajijaro? ¿Nejecojari attidsa dadadedeni mohua tininebaqquijari? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Naraha manaco Jeso pohuadenidsa huati tajari: —Ohua naqui tiadenidsa huati onana, tecomeramananijine. Ohuadsa tecomeramanadsapi ohua dossede oni, occa dacorehe tahimarini tiadenidsa huati onanijine. ");
INSERT INTO cul_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jari, Huanopa ¿nejecojari icadossedsa topa idsanabaqquijaritta? ¿Diojine ttarana, madijajine ttarana? Jari, ohuadsa tecomeramanaji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Naraha taminedenipa pohuadenira huati tocanirere canajari: —Jaho “Huanocca topanijipi Diocca dosseniji” inadsapi Jesopa: “¿Nejecotohui pohuadsa jehe tiquinejerajarotte?” nahitohui iadsa −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","—Naraha “Huanocca topanijipi madijacca dosseniji” inadsapi madija iadsa huadimanarana. Aja madija huapima attidenipa: “Huanopa Dio icadossejari. Pajissa Dio Atti cacomerabote” quiquinanade −quinajari taminedeni, madijadeni noppine cappinamanadsa. ");
INSERT INTO cul_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nama quinanaja Jesodsa: —Ssamoqquiri inani −quinahi nade. Nadsapa Jesoa: —Ohua naqui ohua dossede onipa tiadenidsa ohuacomera-jarahi −nahi nade pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nadsapa Jeso pocca marinaja ajijaro namidsa imadinicca ima tadsajani mari icanabaqquijari: —Madijapa pocca huidsajadsa ppa nahi uva pohuara ppa inajari. Nadsapi huidsaja inidi siba hua inahuajanijaro. Uva bono ttai nadsa ppejene tojahijine naqui sibadsa odi inahatojaro. Huidsaja cacahuade huittarihijine siba hua tamaroni naqui hua inamarojaro. Najaro huapima jicadsapi huidsaja jinede pocca huidsaja ecahuamananijine madijatohui qqui naridsajari, nahi pocca huidsajadsa tarabaidsa quinahijine, ppa nahi uva ecahuamanahijine. Uva bono jadadsapa motapa huidsaja jinededsa tojahijine. Motapa huidsaja cacahuadedeni pohuadenidsa tojahijine. Nadsapa pocca huidsaja ecahuamananijine madija qqui inabaqquidsapa pocca huidsaja pohuadenidsa inebojaro. Nadsapa jinede dsama huaji tanihuaji toccajari. ");
INSERT INTO cul_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uva bono jadahicca abadsico bacco tadsapa huidsaja jinede huaji tanidsa madiraha pocca dodosse ojaria pocca huidsajahuaji dosse inanijari, uva bonotohui huidsaja cacahuadedenidsa huati tahijine. ");
INSERT INTO cul_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Naraha pocca dodosse huidsajahuaji bacco nanidsapa huidsaja cacahuadedeni dama quinadsa idaqquimanajari. Uva bono jiraha dosse inanimanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nadsapa huidsaja jinede pocca dodosse ohuaha dosse inanijari. Huidsaja cacahuadedenihuaji bacco naniraha najari naco inajidsomanadsa tati biquerajari. Itamassomanadsa uva bono jiraha dosse inanimanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nadsapa pocca dodosse ohuaha dosse inanijari. Naraha najaripa inanadsoqque-manajari. Dsotode naco pocca dodosse tabaqqui dosse inanibaqquihi huapi taraha motadenipa itabaromanajari. Motadenipa inanadsoqque-ridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Nadsapa pohuadsa ojaria madiccahi, najaripa huidsaja jinede pohua pocca ejedeni. Najaridsapa huati huana tajari. Pohua bodipa: “Occa ejedenidsana cappinamanahitohui” najari. Nadsapa pocca huidsaja cacahuadedenidsa pocca ejedeni dosse inanijari. ");
INSERT INTO cul_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Naraha huidsajahuaji bacco nanidsapa huidsaja cacahuadedeni pohuadenira huati tocanirejari: “Ajaripa huidsaja jinede bedi. Nidsaranibote imehi dsoqquedsa huidsajapi pohuadsa tojanitohui. Jari, inanadsoqquena, huidsajapi icca tojanijine” quinajari. ");
INSERT INTO cul_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nama quinadsapa huidsaja jinede bedi dama quinadsa inanadsoqque-manadsapa huidsaja idenihuaji coro quinajari −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nadsapa Jeso pohuadsa queriqquimanajaridenidsa huati tajari: —Jari, tibodideni huatoji. Huidsaja jinede pohuadenidsa ¿nejecoma napadsaja? Pohuapa bacco nanidsa huidsaja cacahuadedeni inajicadsapa huidsajapi madija ohuahadenidsana da inanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nadsapa Jeso pohua tahimari pohuadenidsa ahuato tanijine Dio Atti dsodo nanicca huati tajari: —Tiadenipi Dio Atti dsodo nanicca hua hua titiquina naraha siba huahuattajo tojajaro tahimarini ¿tetideni ajimamanajaroqui? Imapi ajima najaro: “Odsa sibadsa icanahatomananijinepi nanahatodedenipa siba ojariepi ettajomanani nade. Naraha dsotodepi najaro sibana odsa daco cajiranijine tojajaro. ");
INSERT INTO cul_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Aji siba huahuattajo tojajaropi ia Medsede Diojine deni tojajaro. Najaro imajine Diodsa etidsejaro” nani Dio Atti dsodo nanicca −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nadsapa dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinadsa Jesocca marinaja mittamanadsapa bodideni nahatoqquiri najari: —Jesopa icca ima huati huati tajari, iapi pohua ettajojarijine −quinahi nade. Nadsapa Jesodsa huadimanadsa: —Jeso todsepe inanana −quinaraha madija noppinedeni cappinamanadsapa apaja quinadsa jai tojanijari. ");
INSERT INTO cul_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nadsapa jodiodenicca taminedenipa marinaja pariseodsa jehe quinajarideni pama, tamine Herodecca madija pama quinaha dosse inajonabaqqui-manajari, Jesocca ima inassamomanadsa pohuadsa ima inassonarimananijine. ");
INSERT INTO cul_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bacco najonamanadsapa huati toquinajari: —Mamaride, ticca ima iadsa ahuato tani. Pajissara huati huati tinajaro. Madija attideni noppine ticappina-jeradsapi ticca ima onihi toja-jerajaro. Madija deni tojajari, madija dsepe sse tajari, madija ajamani tojajari tedsejepa tiadsa najarissa caniqquimerajari. Pajissehera Diocca marinajadsa madija madimanahissa tahijine mari mari titicanabaqqui najari −quinahi nade. —Nadsama iapi romanodenicca tamine deni tojahicca pocca dossenijidsa icca dsiniro mota pohuadsa da inanijine ¿bica taqui? ¿Bica tejerarane? Moisesicca marinajadsa ¿oppina taqui? ¿Oppinera tarane? ¿Tetti nejecoma tani? ¿Paca inanijinequi? ¿Paca inejeranijinerane? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesodsa attideni bica tadsa huati huati toquinaraha poccadeni maidsehe pohuadsa ahuato tadsa pohuadenidsa huati tajari: —¿Nejecotohui occa ima tossamonijine ohuadsa huati tiquinajaro? Jari, ohuadsa dsiniro denario dsojo ticanajonamanaji, qqui ocanana −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dsojo icanajonamanadsapi Jeso attia: —Jari, ajijaro ccararadsapi ¿nejecojari corimena anijaro? ¿Nejecojari oni dsodo najaro? −nahi nade Jeso. Nadsapa pohuadsa ecomeramanajari: —Romanodenicca taminedija −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nadsapa pohuadenidsa Jeso attipa: —Romanodenicca tamine pocca dsiniropi pohuadsa da tinanimanaji. Naraha Diocca tiquejenadsapi Pohua jipa tahiccara Pohuadsa da tiquinaji −nahi nade Jeso. Nadsapa —Jesocca ima tossamona −quinajarideni jabojomanadsa attidenipa: —A, icca ima ecomeranijine nahato tajaria −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nadsapa Isaraeri potemahi jodiodeni mota marinaja sadoseodsa jehe quinajarideni Jesohuaji bacco quinajari. Poccadeni marinajapi: —Idsoqquedsapi inahatoninijine nohuerani −quiquinanajari. —Najaro imadsa Jeso atti ijine tossamodsa cobara tana −quinadsa Jesodsa najaro ima huati toquinajari: ");
INSERT INTO cul_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mamaride, Moisesicca marinajadsapi ajima nani: “Maqquidejepa amoneje cajiraha ejedeni jiraha dsoqquedsapa pocca amonejepi pohua imecotena icajina, nahi ejedeni cajidsapa pocca ato dsoqquejaricca ejedenissa nahijine” nade Dio Atti Moisesi dsodo inajaro. ");
INSERT INTO cul_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Nadsama tiadsa ima ajima najaro huati inana. Aja pohuadeni imecote pohuadenira 7 quinaha madimanajari. Tahideccaha amoneje cajipojari, naraha bedi jiraha dsoqquejari. ");
INSERT INTO cul_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Dsotodecca naco pohua ohuaha bedimeni icajiraha ejedeni jiraha dsoqquejari. Dsotodecca naco najaro amoneje icajiraha najari naco ejedeni jiraha dsoqquejari. ");
INSERT INTO cul_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Najaro imapi nema dsanapojaro 7 quinaraha ejedeni jiraha jicajari. Najarideni jicadsapa poni naqui dsoqquejaro. ");
INSERT INTO cul_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nadsapi dsama jicadsa madija inahatonidsapi pohua imecote 7 quinajaripa ¿nejecojarina ponicca maqqui tojapadsaja? Huapimapa poni icajiqquimanaporaha −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Naraha Jeso attipa: —Ticcadeni marinajapi dsori tajaro. Dio Atti nahatoqquiri tiquinaraha pajissa tiquinanissa tejerajaro. Diopa pocca dacorehema madija inahatonibaqquihijine pajirahi naco ssamoqquiri tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jicamanajarideni nahatonimanadsapa caji caji cana-jarahitohui. Diohuaji madimanadsapa pina Diocca dodosse tabaqqui memehuajiccassa quinahitohui. Aja pohuadenipa caji caji cana-jaradsa madimanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Nadsama Diojine madija nahatonimanahicca imapi Pohua Atti cacomerabote Moisesi dsodo inapojaro. Najaro Dio Atti dsodo nani hua hua titiquina naraha ¿najaro imapi tetideni ajimamanajaroqui? Aji ahua diji tanidsa Diopa Moisesidsa huati tajari: “Ohuapi Dio, ticca idideni Abarahao, pohua bedi Isahaca, pohua bedi Jacobo quinajaridenicca Dio ojani” nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aja Dio Atti nama nadsapa Abarahaodeni nahatonimanadsa madimana-dsanapohuicca ima ahuato tajaro. Diopa paja dsoqquemanarihi najaridenicca Dio jarahi. Diopa camittaqquiri najaridenicca Dio. Pohuapa jidapana naco poccadeni Dio. Najaroa ticcadeni marinajadsa: “Nahatonie nohuerani” titiquina najaropi dsori tajaro. Pajissa jerani −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesopa sadoseodeni tedseje ahuaji huati ahuaji huati quinanaja jodiodenicca marinaja maride ojariaha Jeso pohuadenidsa ecomerani bica tani mittadsapa pohua naco Jesodsa huati tajari: —Jari, Diocca dosseniji huapi taraha ¿nejecojaro dossenijina pocca dosseniji huapimadsa deni tojajaro? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nadsapa pohuadsa Jeso huati tajari: —Aji Diocca dosseniji deni tojaniccapi ajima najarona paji: “Isaraeri potemahideni, titaharibobo canaji. Ia Medsede Diopa ojarijari. Dio ohuaha nohuerahi. ");
INSERT INTO cul_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tiadeni Medsede Diodsa tetideni huanaqquiri naji. Tibodideni huatonissa tadsa, dacoco tijiradsa Pohuadsara disseraqquiri tidsanapomanadsapi Pohuadsa tetideni huanaqquiri nanijine.” ");
INSERT INTO cul_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Diocca dosseniji deni tojanicca onihi pina tahideccassa najaro. Deni tojaniccapi ajima najaro: “Tinorideniccadsa tetideni huanaqquiri naji. Pina tiadenidsa tetideni huanaqquiri najarossa naji.” Najaro Diocca dosseniji pamehena deni toquejenajaro. Pocca dosseniji onihipi najaro pamehessa nejerajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nadsapa Jesodsa jodiodenicca marinaja maride attia: —Jehe Mamaride, tettipi pajissa. Ia Medsede Diopa ojarihi. Ohuaha nohuerajari. ");
INSERT INTO cul_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nadsama Diodsara eti huanaqquiri nanijine. Ibodi huatonissa tadsa dacoco ijiradsa Pohuadsara disseraqquiri idsanapodsapi Pohuadsa eti huanaqquiri nanijine. Inoriccadsa naqui eti huanaqquiri nanijine pina aji iadsa eti huanaqquiri najarossa inanijine. Najarona denima bica tajaro. Aji icca bani bedi ono tojahijine Diodsa dada toqquimahuaji da da ihinanajaro, icca daniji onihi naqui dada toqquimahuaji ihinebo najaro huapimapi Diodsa bica taraha aji tohuati huanehe pameheccadsa deni toquejena-jerani −nahi nade jodiodenicca marinaja maride atti. ");
INSERT INTO cul_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pocca cacomeraniji bica tanicca Jeso mittadsapa: —Jehe, Diocca cacahuehedsa tijanijine tipajirabote nani −nahi nade Jeso. Jesopa ecomeranissa dsanapodsapa ima onihi pohuadsa huati toquinahijine huapima cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nadsapa Diodsa dada toqquimahuaji Jeso mari icanabaqquidsapa madija ecomeramananijine huati tajari: —¿Nejecotohui jodiodenicca marinaja maridedeni attidenipa: “Cristo-Mesiapa Dabi Potemahi” quiquinanajari? ");
INSERT INTO cul_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Naraha tamine Dabipa maittaccadsama madidsa Dio Corimejine pohua tedsejemacca ima huati tadsapa pohua attipa: “Ia Medsede Diopa ohua Medsede Mesiadsa huati tajari: ‘Ohuinori nahatonihuaji tittariji. Ohua tedsejepi tohuatti dacorajaro ticajiji’ najari. ‘Nidsaranibote tia huadidedenipa ajamani onanabaqquihitohui. Poccadeni dacorehepi onajicanitohui’ napohui nade Dio.” ");
INSERT INTO cul_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Naraha madija attidenipa: “Cristo-Mesiapa tamine Dabi Potemahi” quiquinanadsapa ¿nejecotohui Dabipa pohua potemahidsaraha: “Ohua Medsede” napojaritta? −nahi nade Jeso. Nahidsa Jeso atti mittade madija huapi taha queriqquimanajari. Pocca marinaja mittamanadsa huatidsemanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesopa madija mari icanabaqquidsa ima ajima najaro huati tajari: —¡Paji, tiadenipi! Pina jodiodenicca marinaja maridedenicca madiessa tiquinejeraji. Pohuadenipa etero dequerajarodsa huedsaridsamanadsa attidenipa: “Iapi pina taminessa inani” quiquinanajari. Aji dadahuajicca jahuidsa jahiridsadsa naco madija pohuadenidsa: “¿Nija, bica tinani? Tiapi deni tijani” quinahijine tohuini quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Dio Atti mamarihuaji jassi tarihijinepa deni toquejenajaridenicca huihuittari tohuini quiquinanajari. Jipaqquie imenidsa naqui deni toquejenajaridenicca huihuittaridsa jassi tarihijine tohuini quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Nadsama tabira tocajamanajarodeni ponideni madimananijineccaraha icamaidsabaqqui-manadsa pohuadenidsa totoja nadsapi ponidenicca odsa naqui pohuadenidsa totocajaridsa najaro. Naraha poccadeni tabaccorehe ahuatora tanijinepi Diodsa huati huati toquinadsapa poccadeni huatinaja dequerajaro, aja madija pohuadenidsa: “A, Diodsa disseraqquiri nahi” quinahijine. Pohuadenipa Dio Attima mamaidsamana nadsapa nidsa Diocca najidsohue denima oppina tanicca pohuadenidsa ssonarinitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nadsapa Jeso Diodsa dada toqquimahuaji madiccajari. Pohuapa nahi bodidsa madijacca da naqquinaja dsiniro cocoro todsa cahittarini tadsajanima huittarijari. Madija poccadeni dsiniro coro coro icadsamanani cattoma canajari. Dsiniro sseqquiri najarideni huemani coro icadsamanani qqui tajari. ");
INSERT INTO cul_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nadsapi nanidsa tabira tocajani tohuati nahana tajaro ccajonajaro. Poni madinijinecca dsiniro bedeniraha ponicca danijijine capamehe cororo icadsajaro. ");
INSERT INTO cul_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nadsama najaro qqui tadsapa pohua huatimadedeni huahua inabaqquijari: —Pajissara tiadenidsa huati onajaro: Ajijaro tabira tocajani cappiradsa tohuati nahana taraha ponicca daniji dsiniro bedeniraha deni tojani. Pina Diodsa denima da inajarossa najaro. Madija ohuahadenipa poccadeni daniji toqueriqquini huapi taraha Diodsapi ajimani tojajarossa najaro. ");
INSERT INTO cul_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pohuadenipa sseqquiri nadsa poccadeni dsiniro mota arobeni da quinaraha ajijaro tabira tocajanipi cappiraraha nemanehe da inajaro. Tohuati nahana tani, poni madinijineccaraha da inehe jicajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nadsapa Diodsa dada toqquimadsa Jeso qquenadsapa pohua huatimade ojaria attia: —¡Ohua Maride, qqui taneje! Diodsa dada toqquimahuajicca odsa huapimapi siba bicanidsa nahatoridsani bicaqquiri naha −nahi nade pohua huatimade. ");
INSERT INTO cul_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nadsapa Jesoa: —Aji odsa imeni sibadsa nahatoridsani bicabote jidapana qqui tinaraha nidsa dsotodepi taboridsehe jicanissa tanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nadsapa ssono Oribohuaji Jeso pohua huatimadedeni tedseje jai tojemorajari. Najaro ssonopi Diodsa dada toqquimahuaji ahuato tajaro. Nahidsa Jeso huittadsa Pedro, Satiaco, Huano, Adiri quinajarideni pohuadenira Jesodsa huati toquinajari: ");
INSERT INTO cul_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Ia Maride, jidacca ima huati tinajaropi ¿nejecoma nadsa tojapadseje? Najaro ima tohuajiradsa nahatoqquiri inanijinepi ¿nejecora qqui inapopadseje? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nadsapa Jesoa: —Paji, madija tiadeni tocamaidsabaqquirana. ");
INSERT INTO cul_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nidsa madija huapi taha pohuama ohua onidsa maidsamanadsapa: “Ohuapi Cristo-Mesia ojani” quiquinanahitohui. Nadsapa madija huapi taha icamaidsabaqqui-manahitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ima onihi naqui: “Jadsire tojaridsani” timittamananitohui. Naraha ticappinamana tejerana. Jadsirepi epeje tojaponitohui. Naraha dsamapi jiquejeraccanitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nadsama madija dsama onihicca, dsama onihicca tedseje jadsire inanamana-ridsanitohui. Tamine ohuahacca madija, tamine ohuahacca madija tedseje cahadire-ridserahitohui. Namidsadsa naqui tojaridsanitohui. Pemi naqui cajiridsanitohui. Najaro ocasserehe tahide tojaporaha denima ocasserehe tojadsanaponitohui −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—Paji, ¡tetideni huatomanaji! Madija huadiqquiri najari cajiridsahi. Najaridenipa tiadeni tadamamanadsapa jodiodenicca taminedenihuaji ticcadeni ima mittamanahijine tiadeni tohuaqquedsimabaqqui-manahitohui. Jodiodenicca Dio Atti mamarihuaji naqui tiadeni itabaromananitohui. Otahimari tiadenidsa tojajaro acconi huadimanadsa dsama cacahuadedeni baccodenidsa tidomo huanijine tiadeni tohuaqquedsimabaqqui-manahitohui. Dsama onihicca dsama onihicca madija tamine deni toquejenajari baccodenihuaji naqui tidomo huanijine tiadeni tohuaqquedsimabaqqui-manahitohui. Nanidsana ticcadeni ima tecomeramanadsapi taminedenipa otahimari mittamanahijine. ");
INSERT INTO cul_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dsama jiquejeraccadsama otahimari madija tocassiejerahijinecca dsama huapimadsa ecomeraridsa-manaccanitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nadsapa taminedenihuaji tiadeni tohuaqquedsima-baqquimanadsapa pohuadenidsa ticcadeni ima tecomeramananijinepi ¿nejecoma onapadseje? tiquinejerana. Ticappinamana tejerana, onajaro. Taminedenidsa ima huatide nahatoqquiri tiquinanijine Dio Pohua Corimena tiadeni acco tocamabaqquihitohui. Dio Corimejine tiadenidsa ima ahuato tadsapi najaro imara huati tiquinaji. Huati tiquinadsapi tettideniraha Dio Corimejinena huati tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Naraha najidsohuepi tiadenidsaha ssonarini ojari nejeranitohui. Aja ohuadsa jehe quinajaridenipa otahimaridsa toquejenajarijine pohua ohuahadeniraha pohuadenidsa huadiqquiri nadsapa eheccora-baqquimana nahitohui, inajicabaqqui-manahijine. Imehideni naco pohua bedideni otahimaridsa toquejenajarijine bedidenidsa huadiqquiri nadsapa pohuadeni bedideni eheccora-baqquimana nahitohui, inajicabaqqui-manahijine. Bedideni naco imehideni otahimaridsa toquejenajarijine pohuadeni imehidenidsa huadiqquiri nadsapa imehideni ihinajicabaqquimana nahitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Occa madija tiquejenajarojinepi madija huapima tiadenidsa jiperaqquiri nahitohui. ¡Naraha tiadenipi dacoco tijiraji! Najaro huadie tinahanamana-dsanapodsapi tijicaraha ticassiejeranitohui. Timadimanaccadsa dsama jicani bacco tiquinadsa naqui ticassiejeranitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesopa dsama jicanicca ima denima mari icanabaqquijari. (Pocca marinaja hua tiquinadsapi timittamananissa taji.) Pohua attipa: —Nidsa jodio quejena-jarajaridenijine Diodsa dada toqquimahuaji oppinabote corime huedsadsapa toppinanitohui. Nahidsa huedsahipa bica tejerani. Nadsapi pohuadenijine icca madija jodiodenipa icappinaqquimanadsa Diodsa dada toqquima paji inebomanarinitohui. Najaro ima tojani qqui tiquinadsapi tiadeni huapima dsama Jodeahuaji timadiridsa-manajaropi ssonohuaji tidomo toqquemorana. ");
INSERT INTO cul_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Madija pocca odsa amossinihuaji ccaridsadsapa pohua dsepetajitohui pocca odsahuaji toqquedsimani-jarana. ");
INSERT INTO cul_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Madija pocca huidsajahuaji dsepe ijijari naco paja joppa tarina. Pocca eterotohui odsahuaji ccani-jarana. ¡Poni! ");
INSERT INTO cul_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jaho, amoneje jiamanajarodeni, bacconideni ijimanajarodeni naqui joppa toquinanijine tohuati nahanaqquiri nanitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Najaro ima oppinabote tojadsa tidomo toccadsapi ssirini nohueranijine Diodsa huati huati tidsanapomanapoji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Najaro ima oppina tanicca bacco nadsapi madija huapima ocasserani imeni inahanamananitohui. Maittaccadsama Dio dsama inahatoponipi nema nanicca ocasserehe qqui quinapo-jerani. Nohuerani. Ia naqui qqui inejerani paji nani. Nidsa dsotode naqui nema napoma-jeranitohui. Nohueranitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Najaro ocasserehe nema dsanapodsapi madija tossiajaja cama-jarahitohuiraha najaro ocasserehecca huada Dio ajimani inananitohui. Dio pocca madija pohua icattejidsa-baqquijaridenidsa huati huana tadsapa: “Nanidsa epejena, jicana” nahitohui Dio −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Nadsapa madija tiadenidsa pohuama: “Qqui, ajajaripaja ia Idinide Cristo-Mesia” quinadsa, madija ohuaha attideni naco: “Qqui, ajaccajarina Cristopaja” quinadsapa pajissa tiquinejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Madija mamaidsadedeni naco tiadenidsa jahijonahitohui. Pohuadenipa: “Ohuapi Cristo-Mesia ojani” quinahitohui. Ohuahadeni naco: “Ohuapi Diocca dosseniji ojani, Pohua Atti ohuacomeranijine” quinaraha maidsamanajari. Pohuadeni bodipa: “Dio icattejidsa-baqquijarideni icamaidsabaqquina” quinadsa poccadeni maidsehe canahatorimana canaridsahitohui. Madija pohuadenidsa: “Pajissa Diocca dosseniji” quinahijine tohuini quinaraha Dio Pohua icattejidsa-baqquijarideni motapa pohuadenidsa pajissa quina-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nadsapa ¡paji! Ajijaro ima huati huati onajaropi tetideni ajima-jerana. Najaro huapimapi nidsaranibote tojanijineraha jidapana tiadenidsa huati onajaropajipa −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesopa ima denima huati huati tajari: —Naraha ocasserehe inahanamanani nattinipi maji ohuihitohui. Abadsico naco cahuihitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Memecca abadsico bedi naco catojahitohui. Jidapapa memecca huapima dacoraqquiri naccahi naraha dsotodepa meme dsadsa nadsapi huenene huenene canahitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nadsana ohuapi Madija Bedi ojajaroa nidsa meme essenima oquejemehe occaronapomani madija huapima qqui toquinahitohui. Occa dacorehe, occa deni tojehe ahuato tanitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nadsapa occa dodosse tabaqqui memehuajicca dosse onaridsabaqquidsapa Dio icattejidsa-baqquipojarideni inequeriqquini-baqquimanahitohui. Dsama nemanehedsa madiridsamanajarideni huapima ahuajicca, ahuajicca inequeriqquini-baqquimanahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","—Jari, ahua iquiera tahimaridsa ticahatteraji. Eppe moro nimanihi qqui tiquinadsapi: “Jehe, dsadsajade tojemanini” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pina najaro imassa najaro aji dsama jicani tahimarini huati huati onajaro qqui tiquinadsapi: “Jehe, Jeso ccanihi. Pina icca noccobijidsa huajarissa najari” tiquinana, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pajissara tiadenidsa huati onajaro: Aji dsama jicani tahimarini huati huati onajarocca madija dsoqquemana-jaraccadsama najaro ima huapima tojanissa tani qqui toquinaccahitohui. ");
INSERT INTO cul_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Meme, nami naqui jicaridsanissa tanitohui. Naraha ohuattipi jiquejeranitohui. Aji huati huati onajaropi najarossa nanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Occaronapomanicca huada, maji naco madija huapima ssamoqquiri nahi. Diocca dodosse tabaqqui memehuajicca naco ssamoqquiri nahi. Dio Bedi ohua naqui najaro ima ssamo onani. Naraha Abi Dio Pohuana nahato tahi ojarihi −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","—Nema nadsapi tetideni huatonissa taji. Occaronapomanijinecca huada ssamoqquiri tiquinaraha otohui tinajoramanehe timadimanaji. ");
INSERT INTO cul_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ohuapi Madija Bedi ojajaroa occaronapomanicca imapi pina ajijaro imassa najaro: Madijapa dsama huaji tanihuaji toccahijine joppemadsapa pocca odsa ecahuamananijine pocca medse nahidsa inebobaqquijari. Huapimapa dsepedeni ijimanahijine tarabaidsa onihi onihi cajiridsamanajari. Jinedepa noccobiji cacahuadedsa: “Otohui ticattoma canana” nadsapa toccajari. ");
INSERT INTO cul_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Odsa cacahuadedeni huapimapa jinede ccanihicca huada ssamoqquiri nadsapa najoramanaha madimanajari. “Maji toccadsa ccanihitide, dsome nocconi itide, tacara huahua nadsa itide, ssiajadsa itide” quinajari. Tiadeni naqui occaronapomanicca huadatohui tinajoramanehe timadimanaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ajana, odsa cacahuadedeni jinedetohui najoramana-jaradsapa nassa cahadijadsa bacco naninaja. Tiadeni naqui ohua occaronapomadsapi tinajoramana-jeradsa bacco onanirana. ");
INSERT INTO cul_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nadsapi tiadenidsa ohuattipi ajima onajaro: Occaronapomanicca huadatohui tinajoramanehe timadimanaji. Madija huapima naco nama quinana, onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jodiodenicca ejete pamehe tohuajirajonajaro. Tahidecca huadadsapi Pascoa tojapojaro. (Ettidsapi: Dio tossoniqquimajari, inajaro.) Dsotodepi Pan ssaja tajarahi jipamanajaricca ejete tojapomajaro. Najaro ejete tojanijinecca huada pamehe dsori taccadsapi ajijaro ima tojajaro. Dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajaridenipa Jesodsa jiperaqquiri najari huapima queriqquidsa: —¿Nejeco maidsehedsa Jeso todsepe tojadsa dsoqquehijine? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Naraha pohuadeni atti onihipi: —Ejete tojadsapi ima nohueraccanijine. Jesodsa madija jipaqquiri najarideni pohua dama inahi qqui toquinadsapa mohua mohua canarana −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesopa odsa capamema najaro onini Betaniahuaji madidsa Ssino huapi jadsidsi quiquinanajaricca odsadsa toqquedsimajari. Nahi Ssinocca odsadsa jipade jassi taridsa amoneje Jesodsa tohuajiressijaro, poni dsapanidsa siba onini alabastro nahatoni jojo bicahi dsojo inajonajari. Najari jojodsa majojo bicani oninipi nardo dsojo icadsimajaro. Najaro majojopi passodsa quejemerani, huatini ccara tanicca. Nadsapi jojo bono idejidsadsa Jeso tatidsa nemanehe sso inarijaro. ");
INSERT INTO cul_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Naraha nahidsa jassi tarijarideni motaha huadimanadsapa pohuadenira imahahacosseri najari: —¿Nejecotohui majojo ponima inajicajaro? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","—Najaro majojo manaconipi dsiniro ccarara 300 denario denima nitide. Iadsa da inadsapi madija cappiramanajaridenidsa da iqquimanitohuiraha −quinahi nade, pohuadenira huati canirere canadsa. Nadsapa ponidsa naco atti atti quinajari nade. ");
INSERT INTO cul_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Naraha Jesoa: —Epeje tiquinaji. ¿Nejecotohui ponidsa tedimanajaro? Ponijine ohuadsa nema nadsapi bica tani. ");
INSERT INTO cul_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cappiramanajaridenina tiadenidsa madimana-dsanapohuitohui. Tohuini tiquinadsapi pohuadeni tinanabica-baqquimanahijine bica taraha ohuapi tiadenidsa omadidsanapo-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aji majojo ohuassiredsa sso inarijaropi pina odsoqquedsa ohua ppa idsamananijinessa najaro najorapojaro −nahi nade. (Jodiodenipa poccadeni madija dsoqquedsapa nama quiquinanajari.) ");
INSERT INTO cul_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","—Pajissara tiadenidsa huati onajaro: Dsama onihi, dsama onihidsa otahimari madija tocassiejerahijinecca ecomeramanadsapi aji otatidsa majojo sso inarijarocca ima naqui madija mittaridsamanahitohui. Nema nadsapi ponicca ima huatideni ajamamana-jarahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jesocca dodosse tabaqqui 12 quinajari ojaria oni Joda Iscariotepa dada toqquimade taminedenidsa Jeso eccorahijine huatide toccajari. ");
INSERT INTO cul_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nadsapa Jodacca ima mittamanadsa huatidsemanajari: —Jehe, Jeso teccorajari manaco dsiniro tiadsa da inana −quinahi nade. Nadsapa Joda toccanidsa pohua bodi najorajari. Jeso pohuadenidsa eccorahijine inoccodsaridsajari. ");
INSERT INTO cul_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan ssaja tajarahicca ejete bacco tajaropi huada 7 nehe jicanijine. Najaro ejetecca huada tahideccadsa jodiodeni pohuadeni motta edede bedi Diodsa da da quiquinanajari. Edede bedi inanadsoqque-manadsa ibanamanadsapa jipamanajari. Najaro ejete oninipi Pascoa quinajari. Nadsapi najaro huada bacco tadsa Jesodsa pohua huatimadedeni huati toquinajari: —¿Nejecohuaji Pascoacca jipaqquie tiadsa inajoranijine? −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nadsapa pohua huatimadedeni pamahadsa huati tajari: —Odsa pananihuaji ticadapoji. Maqquideje jojoridsa passo dsojo tanihi bacco tiquinadsapa pohua natti ticadamissana. ");
INSERT INTO cul_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pocca odsadsa toqquedsimanidsapa nahicca odsa jinededsa huati tiquinana: “Ia Maride attipa: ‘¿Nejecohuajicca coba canahuajaninidsa Pascoacca jipaqquiedsa ojipanijine ohuatimadedeni tedseje?’ napaja” tiquinana. ");
INSERT INTO cul_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nadsapa pocca odsa tetepicca coba canahuajanini imeni tiadenidsa nohue inanitohui. Nanidsapi huahuanari, huihuittari najoraponi. Nanidsana jijipa tinajoramanaponijine −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nadsapa tohuedadsapa pina Jeso pohua huati tajarissa najaro odsa najorani qqui toquinajari. Nanidsa Pascoacca jipaqquie dsome jipaqquimanahijine najoramanajari. ");
INSERT INTO cul_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jesopa pocca dodosse tabaqqui 12 quinajari tedseje dsomejonadsa jipaqquimanahijinecca odsadsa bacco toquinajari. ");
INSERT INTO cul_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Huahuanaridsa jassi nahuajanidsa jipade toquejenadsapa Jeso huati tajari: —Pajissara tiadenidsa huati onana: Ohuadsa jipade tiquejenaraha ojariaha ohua ccaccoradsapa todsepe ojanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nama nadsapa pohuadeni bodi qquedsadsa: —¿Aji ohuadsaqui? −naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nadsapa Jeso attia: —Tiadeni 12 tiquinaraha ojariana icca paratodsa pohua naco pocca pandsa depo apa, depo apa nahi. Najarina ohua ccaccorahitohui. ");
INSERT INTO cul_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Jehe ohuapi Madija Bedi ojajaroa nidsa odsoqquenitohui. Pina maittaccadsama otedsejemacca ima Dio Atti cacomeraqquiri najarideni dsodo quinapojarossa onanitohui. Naraha ohua ccaccoradedsa oppina tehe tojanitohui. Jaho, najari maqquideje tossona-jaradsapa bica taraha, oppina tanicca dsori tahitohuiraha −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nadsapa jipade toquejenadsa Jeso pan idi nadsa Diodsa huati tajari: —Jehe Abi Dio, ticca daniji iadsa bica tahi −nahi nade. Nadsapa pan icanarobedsa dside jai da, dside jai da inaridsajari. Pohua huatimadedenidsa huati tajari: —Aja, apa tiquinajo. Ajijaropi ohuemecca ima −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Dsotodepa dse quinahijine dsedse equidi nadsa Diodsa huati tajari: —Jehe Abi Dio, ticca daniji iadsa bica tahi −nahi nade. Nadsapa pohuadenidsa da icanadsa dse naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nadsapa pohuadenidsa huati tajari: —Ajajari dsedsepa ohuemenecca ima. Dio madija tedseje jehe canirehijinecca ima tojanijine. Nidsa ohua odsoqquedsa ohuemene toccadsapi najaro jehe canireniji pajissa tojanitohui. Aji ohuemene toccajaropi madija huapimadsa ima bicani tojanijine. ");
INSERT INTO cul_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pajissara tiadenidsa huati onajaro. Aja uva ppejene dse inajaripa dse onapoma-jaraccahitohui. Nidsa memehuaji Diocca cacahuehedsana uva ppejene ohuaha dsatira dse onahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pascoacca jipaqquie jicadsapi Diodsa jiri quinajari. Jiri quinaha jicadsapa ssono Oribohuaji jai tojemoranijari. ");
INSERT INTO cul_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nahihuaji bacco tomoramanadsana pohuadenidsa Jeso huati tajari: —Tiadeni huapima ohua tinebomananitohui. Pina Dio Atti dsodo napojarodsapi ajima nanitohui: “Nidsa edede cacahuade dsoqquedsapa pocca edede tojaribaqquihitohui.” ");
INSERT INTO cul_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Naraha ohuapi Diojine onahatoninitohui. Onahatonidsapi titedsejemadeni dsama arobeni Carireahuajina occaninitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Naraha Pedro attia: —Huapima tia inebomanaraha ohuapi tia onebo-jeranitohui −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nadsapa Jeso Pedrodsa: —Pajissara tiadsa huati onana: Tiapi ajijaro dsome tacara huahua nahi pama najaraccadsa ohuadsa: “Onocco jidsa tani” tanitohui. Dsotode naqui: “Onocco jidsa tani” tapomanitohui. Dsotode naqui nema tapomanitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Naraha Pedroa: —¡Nohuerani! ¡Ohuapi nema onejeranitohui! −nahi nade. —Ima oppina tadsa naqui tiadsa “Onocco jidsa tani” onejeranitohui. Tiadsama odsoqquenijine bica tani −nahi nade Pedro. Jeso huatimadedeni huapima naco attideni nama quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nadsapa najaro ssonodsa ahua ppa nahi oni Jesemanihuaji jai tojajari. Bacco toquinadsapa Jeso attia: —Tiadenipi ajidsa jassi tinaccaji. Ohuapi ajiccadsa Abi Diodsa huati onaccana −nahi nade pohua huatimadedenidsa. ");
INSERT INTO cul_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nadsapa Pedro, Satiaco, Huano quinajarideni jina inabaqquidsapa najaridenina pohuadsa denima jai tojajari. Nahidsana Jeso bodi qquedsadsapa ojibote najari. ");
INSERT INTO cul_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nadsapa pohuadenidsa: —Obodi ocassera tajarojine ohuatiabote-te canani. Tiadenipi ajidsa tibomanaccaji. Tinoccodeni bissaccana −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nadsapa Jeso tocca-cca nadsa pohua baccohuaji namidsa pona nadsa Imehidsa huati tajari: —Abi, aji ima comabotepi ohuadsa huaji tinanaji. ¿Madija tocassiejerahijinecca ima onihi nohueraqui? Nohueradsapi epeje −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Imehidsa huati tapomadsa naco: —Abi, nahato tinani. Madija huapimacca ima manaconi najidsohue ohuadsa tojadsapi ocasserani ohuanitohui. Pina dsedse bidabote dse onanijinessa najaro. Najaro onahananijine jipera onaraha ohua jipa onanicca tohui onejerajaro. Tia jipa tinaniccana paji. Najarodsana ibora onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nadsapa pohua huatimadedenihuaji ccanijari. Bacco nanidsapa cahadijahira qqui tajari. Nadsapa Pedrodsa Jeso huahua najari: —Ssino ¿tedajaroqui? ¿Dsome nocconi ocaja-jeraraha tinoccodeni bissade tipajiramana-jerajaroqui? ");
INSERT INTO cul_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ticahadija-jeradsa Diodsa huati tiquinaji, ima oppina tehe tojadsapi tijaparimanadsa ima tinanamana-jeranijine. Tibodidenipi ibora taraha tessiredenina mijira tajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nadsapa toccanipomadsa pina Imehidsa huati tapohuissa najari huati tapomajari. ");
INSERT INTO cul_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nadsapa pohua huatimadedenihuaji ccanipomaraha cahadijahira qqui inabaqquijari, huada comani ahuamanaja nadsa. Jeso ccanidsa nocco toquejenajari. Naraha pohuadsa huati toquinahijine tossamomanajari. ");
INSERT INTO cul_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Diodsa huatide tocanajoranipomajari, pohua huatimadedenihuaji ccanipomadsapa: —¿Tiadenipi ticahadija dsanaponijinequi? Epeji, ohuapi Madija Bedi ojajaroa jidapapi ohua ccaccoradejine imasiri cajimanajarideni dsepedenidsa ojanitohui −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nadsapa: —Jina, titehemamanaji. Ajana, jidapapa ohua ccaccorade ccajonahi −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jeso huati huati naccaraha Joda bacco najonajari. Jodapa Jeso pocca dodosse tabaqqui 12 quinajarideniraha. Pohuana madija huapi taha eccajonabaqquijari. Jadsirecca massito eccajonamana, huahuacca eccajonamana najaro. Pohuadenipa dada toqquimade taminedenicca dosseniji, jodiodenicca marinaja maridedenicca dosseniji, ime jocohuidenicca dosseniji jahijonajari. ");
INSERT INTO cul_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jodapa Jeso todsepe inanahijine eccajonabaqqui-jaraccadsama taminedenidsa huati tapojari: —Nidsa pano mose onahitohui. Najarina dama tiquinadsapa biji jore tiquinadsa teccanimanana −napojari nade. ");
INSERT INTO cul_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nadsapa huapima jahijonadsa bacco najonamanajari. Nanaja Joda Jesodsa tohuajiressi, pina pajissa pohuadsa bica tajarissa nadsa: —¿Nija ohua Maride? −nanaja pano mose inajari. ");
INSERT INTO cul_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nadsapa Jeso dama quinajari. ");
INSERT INTO cul_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Naraha Jesocca madija ojariana massito dsoppa jeo, dada toqquimadedenicca tamine deni tojajaricca medse huaribo ca taneje tajo canajaro. ");
INSERT INTO cul_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nadsapa Jeso pohuatohui jahijonajaridenidsa huati tajari: —¿Nejecotohui tiadenipi ohua dama tiquinanijine jadsirecca massitoma, huahuaccama jai tijajonajaro? Nema tiquinadsapi pina bobotidetohui jai tijajonajarossa najaro. ");
INSERT INTO cul_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nadsa tiadenidsama huajijiradsa Diodsa dada toqquimahuaji mari mari ohonanaraha ohua dama tiquinehe nejerade. Naraha epeje, najaropi pina aji Dio Atti dsodo napojarossa najaro tojanijine −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nadsapa pohua huatimade huapimapa Jeso inebomanadsa domo toccajari. Nadsapa Jeso pohua motta ojari naha iaccanimanajari. ");
INSERT INTO cul_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Naraha dsabissopa pohua teteppedsara pohua teppe nadsa Jeso iaccanimanahi natti toccamissajari. Nadsapa Jeso tohuaccanidedeni pohua qqui quinadsa dama quinaraha ");
INSERT INTO cul_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pohua teteppe ssiti, ccoroje joppa tadsapa dsori tajari nade. ");
INSERT INTO cul_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jeso dama quinadsapa dada toqquimadedenicca tamine deni tojajarihuaji iaccamanajari. Nadsapa nahidsa dada toqquimade taminedeni queriqquijari, ime jocohuideni, jodiodenicca marinaja maridedeni huapima naco nahidsa toqueriqqui najari. ");
INSERT INTO cul_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Naraha Pedropa huajima tohuanamissadsa dada toqquimadedenicca tamine deni tojajaricca boronidsa bacco todsimajari. Caipacca dodosse tabaqquidenidsama huittajari. Jassi nahuajanidsa dsippodsa pohuadeni dsepe da quinajari. ");
INSERT INTO cul_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nadsapa dada toqquimade taminedeni, jodiodenicca ima cacattemadedeni deni toquejenajarideni tedseje Jesodsa ima inassonarimananijine tohuini quinadsa madijadsa huati taridsamanajari. Aja madija attidenipa: —Jesopa icca marinajadsa oppina tanicca inanapaja −quinadsa taminedeni: —Jehe, najaro imadsa Jeso dsoqquehijine pajirahi −quinaraha ima oppina tanicca bacco quina-jerani. ");
INSERT INTO cul_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Madija huapi taha maidsaniji onihi onihi huati toquinaraha poccadeni imapi najarossa naridsa-jerani. ");
INSERT INTO cul_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nadsapa madija ohuahadeni totehemamanadsa Jesodsa poccadeni maidsaniji inassonarimanajaro. ");
INSERT INTO cul_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Attidenipa: —Titaharibobo canaji. Jeso atti ajama nahi imittade. Pohua attia: “Aji Diodsa dada toqquimacca odsapi madija icanahatomanaraha ocatabodsapi huada 3 nadsa ocanahatoninitohui. Najaropi madija icanahatomana-jerani” nade pohua atti −quinahi nade. Pohuadeni atti nama quinaraha maidsamanajari. Pina Jeso attissa nejerani. ");
INSERT INTO cul_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Naraha pohuadeni pamahacca ima nemanehepi najarossa nejerani. Najaro imadsa naqui Jeso inanadsoqque-manahijine pajira-jerani. ");
INSERT INTO cul_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nadsapa dada toqquimadedenicca tamine deni tojajari totehema, hua nadsa Jesodsa huati tajari: —¿Tiapi tia tecomajaroqui? Tiadsa ima inassonarimanajaropi ¿nejecoma naneje? −nahi nade tamine atti. ");
INSERT INTO cul_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Naraha Jesopa pohua cacoma najari. Nadsapa tamine huati nimanipomajari: —¿Tiapi Cristo-Mesia tijaqui? ¿Dio Bicabote Bedi tijaqui? −nahi nade tamine. ");
INSERT INTO cul_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nadsapa Jeso: —Jehe, nema onajaro −nahi nade. —Ohuapi Madija Bedi ojajaroa nidsa dsotode Dio Dacorabote ohua deni tonanadsapa Pohua inori nahatonihuaji ohuittarini qqui tiquinanitohui. Nidsa meme essenima occaronapomani ohua qqui tiquinanitohui −nahi nade Jeso atti. ");
INSERT INTO cul_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nanaja dada toqquimadedenicca tamine deni tojajaripa Jeso atti mittadsa huati jami nadsa pocca etero joca taneje sseo najaro. Nadsapa huapimadsa huati tajari: —¡Epeje! Jidapapi pocca ima nahatoqquiri inani. Madija ohuahacca imatohui huati inejerana. ");
INSERT INTO cul_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Dio itamassojari! “Ohuapi Dio ojani” najarissa naha. Pohua atti tabaccora tani timittamanani. ¿Jari, tettideni nejecoma tiquinani? −nahi nade Caipa. Naraha huapima: —¡Jehe, pohua atti nama nadsapa dsoqquena inajaro! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nadsapa pohuadsa ppito-to ppito-to canajari, nocco ssoque quinadsapa idaqquimanajari. Nadsapa attidenia: —Jari ¿nejecojari tia idajari? ¡Tecomerajo! −quinahi nade. Nadsapa dada toqquimahuajicca cacahuadedeni Jeso pohuadenidsa tojadsapa pohuadeni naco Jeso idaqquimanajari nade. ");
INSERT INTO cul_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jesopa odsa bodihuaji nanajidso tojaraha Pedropa amossinihuaji boronidsa huittajari. Nadsapi aji dada toqquimadedenicca tamine deni tojajaricca medse dsohuato ccajonajaro. ");
INSERT INTO cul_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro dsippo jiade tojahi qqui tadsa icattoma nadsapi pohuadsa huati tajaro: —Tiapi Jeso Nasaretihuajicca huatimade tijadija −nani nade. ");
INSERT INTO cul_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Naraha Pedro pohua namaidsajari: —A, ohuapi onocco jidsa tani. Qqui onajarade. Najaro ima ssamo onani ohuapi −nahi nade. Nadsa Pedropa boroni qqueqquedsimahuaji toccadsa huajari. Nanaja tacara huahua najari. ");
INSERT INTO cul_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naraha taminecca medsepi Pedro qqui inapomadsa nahidsa toqueriqquijaridenidsa huati tapomajaro: —Ajajari maqquidejepa Jeso huatimadedija −nani nade. ");
INSERT INTO cul_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Naraha Pedropa pohua namaidsapomajari: —Onocco jidsa tani −napomahi nade. Naraha dsotodepa nahidsa toqueriqquijari attidenipa: —¡Pajissade! Tiapi Jesocca tijade. Carireahuajicca madija tijaha −quinahi nade Pedrodsa. ");
INSERT INTO cul_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nadsapa Pedro huadijari. —Pajissa huati huati onejeradsapi Dio ohua tinajidsoji, onana. Pajissa tiadenidsa huati onajaroa: Pohuadsa onocco jidsa tani. Jidacca najari tahimari huati tiquinajaro ohuapi qqui qqui onajaradija −nahi nade Pedro. ");
INSERT INTO cul_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Nanaja tacara huahua nimanidsapa Jeso atti Pedro bodi huatomanijari: —Tacara huahua najaraccadsapa tetti tinamaidsani 3 nanitohui −napojari. Aja Jeso atti Pedro bodi huatomanidsapa bodi qquedsadsa oji idimajari nade. ");
INSERT INTO cul_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ssiajadsapi dada toqquimade taminedeni, ime jocohuideni, jodiodenicca marinaja maridedeni, jodiodenicca ima cacattemadedeni huapima queriqquimanadsa pohuadenira imahaha canajari. Jehe caniredsapa Jeso biji jore quinadsa tamine Piratohuaji iaccamanajari, —Jeso dsoqquena −quinahijine. Tamine Piratopa romanodeni. Pohuapa jodiodenicca dsama cacahuade tojajari. ");
INSERT INTO cul_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nadsapa tamine Piratohuaji Jeso iaqquedsimamanadsapa Pirato Jesodsa huati tajari: —¿Tiapi jodiodenicca tamine tijaqui? −najari nade. —Jehe, tetti nema tajaropaji −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nadsapa dada toqquimade taminedenipa Piratodsa poccadeni maidsehe huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Nadsapa Pirato Jesodsa huati tapomadsa: —¿Tia tecomera-jerajaroqui? Aja pohuadenipa ticca imapi tabaccora tani huapi tani huati huati toquinaha −najari nade. ");
INSERT INTO cul_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Naraha Jeso joma najari. Nama nadsapa tamine Pirato jabojo najari. Pohua bodipa: —¿Nejecotohui pohua cacomajari? −najari nade. ");
INSERT INTO cul_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Huajano huajijiradsa jodiodenicca ejete Pascoa tojadsa tamine Piratopa toponi cocorodsa madija huedsamanajari ojaria pohuajine qqueqquenamana najari. Madija huapima: —Najari qquenana −quinadsapa ihineqquena najari. Piratopa najarossa inananijine najorajari. ");
INSERT INTO cul_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nadsapa toponi cocorodsa huedsajari ojaria onipa Baraba. Barabapa toponi nanajidsodedeni tedseje toponi cocorodsa domo huedsajari. Pohuapa pohua tessedeni tedseje romanodenicca taminedsa jara jara quiquinanadsa madija ojaria ijinedeni ahuamanajari. ");
INSERT INTO cul_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nanaja madija huapima tamine Piratodsa huatide jahijonadsa attidenipa: —Ejete Pascoa tojadsapi toponi cocorodsa huedsajari ojaria tijine qqueqquena nade. Najarossa tinanapomaji inajaro −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Naraha Piratoa: —Jehe, aja pohuadsa: “Jodiodenicca tamine” quinajari tappa onahijine ¿jipaqquiri tiquinaqui? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Piratopa pohua bodidsa Jesopa ima cappirahi nahato tapojari. Pohua bodipa: —Dada toqquimade taminedenipa Jesocca deni tojehe acconi huadimanadsa ohuadsa eccajonamanajari −najari. ");
INSERT INTO cul_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Naraha dada toqquimade taminedenipa Jeso tossiajahijine jiperaqquiri nadsa madija huapimadsa huati naridsamanapojari: —“Barabana qquenana” tiquinaji −quinahi nade. Nadsapa huapima Barabatohui johuahua johuahua canajaripaja. ");
INSERT INTO cul_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Naraha Piratopa domo huajaridenidsa huati tapomajari: —Jehe, naraha pohuadsa “Jodiodenicca tamine” quinajaripa ¿nejecoma onanahijine jipaqquiri tiquinani? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Naraha huapima johuahua johuahua canapomadsapa: —¡Ahua porimacossanidsa dsoqquena, dsoqquena! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Naraha nejecotohui dsoqquehijine? ¿Nejeco imara inanajaro? −nahi nade Pirato. Naraha domo huajarideni huapima paja johua toquinarihi nadsa: —¡Ahua porimacossanidsa dsoqquena, dsoqquena! −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nadsapa tamine Pirato pohuadsa madija huapima huatidsemanahijine Baraba ineqquenajari. Nadsapa pocca soldadodeni Jeso cossi inaqquimanahijine icadossebaqquijari. Cossi inaqquimanaha jicadsapa icadossebaqquipomajari: —Ahua porimacossanidsa coba tidsanamanahijine tiaccamanajo −nahi nade Pirato. ");
INSERT INTO cul_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nadsapa tamine Piratocca soldadodenipa odsa imeni bodihuajicca boronidsa Jeso iaqquedsimamanajari. Nahidsa romanodenicca soldado huapima toqueriqquijari. ");
INSERT INTO cul_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Pohuadenipa: —Jeso pina taminessa inanana −quinaraha maidsamanajari. Nadsapa etero macconi motaranicca pina taminedeniccassa najarodsa Jeso inehedsamanajari. —Jeso taticca pina tamine tatideniccassa nana −quinaraha cotihi atinema jore nahuajanihira ettarimanajari. ");
INSERT INTO cul_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nadsapa jaja icanaqquimanahijine pohuadsa: —¡Deni tijani jodiodenicca tamine! −quinahi nade maidsamanadsa. ");
INSERT INTO cul_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pohua tatidsa ahua ppahua tajarodsa huacca huacca quinajari. Ppito inaqquimanajari. Nadsapa: —Pina taminedsassa inana −quinadsa Jeso baccohuaji pohuadeni pitodsa huittamana, tocattedsamana, huittamana, tocattedsamana naraha maidsamanajari. ");
INSERT INTO cul_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nadsapa maidsehedsa pohuadsa jidsa jidsa quinaha jicadsapa etero macconi motaraniccapi ssiti quinadsa pohua pocca eterora inehedsanimanajari. Nadsapa ahua porimacossanidsa Jeso coba idsanamanahijine iaccamanajari. ");
INSERT INTO cul_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Soldadodenipa Jeso iaccamananaja dsama Sirenecca madija Ssinopa huidsajahuaji ccanidsa soldadodeni bacco ijidsamanajari. Najari Ssinopa Arejadro, Rofodenicca abi. Jeso ahua porimacossani dsojo inaraha ja tojadsa soldadodenipa Ssino icadossemanajari: —Manaco tia ajajaricca ahua porimacossani dsojo tinaji −quinadsapa manaco Ssinona dsojo inajaro. ");
INSERT INTO cul_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nadsapa ssono Cocottahuaji Jeso iaqquemoramanajari. (Ssono onini Cocotta ettidsapi: Totati Tonanissa nani, quiquinanajari.) ");
INSERT INTO cul_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nahidsa bacco toquinadsa uva ppejene, ahua amani onini mirra quejemadsa Jesodsa da icanamanajari, —Pohua comene ojidsama nanijine −quinadsa. Naraha Jesopa pohua najari nade. ");
INSERT INTO cul_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nadsapa ahua porimacossanidsa coba idsanamanajari. Coba idsanamanaha jicadsapa acca icanamacossa-manajari nade. Nadsapa soldadodeni: —¿Jesocca etero nejecojaridsana tojanijine? −quinadsa siba bedenidsa coro coro quinajari. Najaro sibadsa ittomemanadsapa pocca etero pohuadenidsa ojari ojari naridsajaro nade. ");
INSERT INTO cul_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dsidsidsamassa maji 9ʼdsa Jeso coba idsanamanajari. ");
INSERT INTO cul_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pohua tati tetepihuaji dsodo nani coba idsanamanajaro. Najaro dsodo nanipi: —Ajajaripa Jodiodenicca Tamine −najaro. ");
INSERT INTO cul_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Bobotide pamaha naco Jesodsama topamajonahijine ahua porimacossanidsa cobaba idsanamanajari. Ohuahapa Jeso inori nahatonihuaji que, ohuahapa Jeso inori ssamohuaji que tajari nade. ");
INSERT INTO cul_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Madija nahi jai tojeqquimajarideni Jesodsa jiperaqquiri nadsa Jesodsa tatamasso quinajari. Tatideni huide huide quinadsa attidenipa: —Ajina tettipi: “Diodsa dada toqquima ocatabodsapi huada 3 nadsa ocanahatoninitohui” teteje nade −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","—Jari, tia tinassiajaji. Ahua porimacossanidsa tia tidinidsa ticcaronaji −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nadsapa dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajaridenipa Jeso itamassomanajari: —Ajana madija ohuaha inassiajabaqquiraha pohua tonassiajadepa ssamo tahi. ");
INSERT INTO cul_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pohuapa Cristo-Mesia Isaraeri potemahi jodiodenicca tamine tojadsapa porimacossanidsa ccaronana. Nadsana qqui inadsa pohuadsa pajissa inanijine −quinajari. Pohua inoricca naco ahua porimacossanidsa cobaba dsanaraha najaro tohuattissa najarodsa Jesodsa atti atti quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Maji itetepi tojadsa dsama nemanehe todsidsini najaro. Dsidsi dsanapojaropi maji 3 bacco tajaro. ");
INSERT INTO cul_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Najari maji 3ʼdsa Jesopa pohua attidsa jadsirema huahua najari: —Eroi, Eroi ¿rema sabatani? −nahi nade. (Najaropi: —Abi Dio, Abi Dio ¿nejecotohui ohua tinebojaro? −najari nade.) ");
INSERT INTO cul_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Naraha nahidsa domodeni huajari mittamanadsapa: —¡Titaharibobo canaji! Maittaccadsamacca Dio Atti cacomerabote Eriadsa huahua nahi −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nadsapa nahidsa domo huajari ojaria huassinaja joppa tajari, huassa tajari idi, uva ppejene ssicata bidada najaridsa edsippa, ppaja tojadsa bobadsa oro, da icanamacossajari. Nadsapa najari attia: —¡Maqui, nidsa padseje! Pohua idironahijine Eria ccajonahitidija. Qqui inaccana −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Naraha Jeso jadsirema johua nadsapa huatiajari. ");
INSERT INTO cul_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Naneje Diodsa dada toqquima bodihuajicca huahuacossa etero sibabote naqui Diojine sseo naronajaro, carobe najaro. ");
INSERT INTO cul_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nadsapa Jeso baccohuaji soldado tamine Jeso cacahuade huajaripa Jeso huatiahi qqui tadsa: —¡Jaho! Pajissa ajari maqquidejepa Dio Bediraha −nahi nade soldado tamine atti. ");
INSERT INTO cul_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amonejedeni naqui huaji tanidsa cattade domoni huajaro. Ponidenipi huapi taraha mota oninidenina Maria Madarenahuajicca, Jose Satiacodenicca ami Maria, Sarome quinajaro. ");
INSERT INTO cul_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mariadenipi Jeso dsama arobeni Carireadsa ccaridsapodsa pohua accode pohuadsa jahiridsajaro. Amoneje onihideni naqui huapi tani. Ponidenipi Jerosarehuaji Jesodsa jahijonajarodeni. ");
INSERT INTO cul_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jeso dsoqquehicca huadapi viernes. Jodiodenipa najaro huadadsa poccadeni jassinajacca huadatohui nanajoramana najari. Huada ssiaja sabadopi poccadeni jassinajacca huada tojadsapi dsepedeni ihijimana najarajari. Madija dsoqquedsa ppa idsamanahijine naco oppina tani quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nadsapa viernes dsomebote nadsa odsa panani Arimateahuajicca madija oni Dsodsepa cappinera tadsa tamine Piratodsa huatide toccajari. Pohuapa jodiodenicca ima cacattemadedeni ojaria. Madija huapimapa pohuadsa nahatoqquiri najari. Pohua naco Diocca cacahuehetohui najoraha madijari. Nadsapa tamine Piratodsa bacco tadsa Jeso assire ppa idsahijine huati tajari. ");
INSERT INTO cul_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Naraha Dsodse atti mittadsapa Pirato jabojo najari, —Jeso amadsati huatiahi −quinahi mittadsa. Nadsapa huahua najari soldadodeni taminedsa: —Nija ¿pajissa jidaccadsama dsoqquejarico? −nahi nade Pirato. ");
INSERT INTO cul_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nadsapa soldadodenicca taminea: —Jehe, pajissa, dsoqquejaripa −nadsapa Pirato Dsodsedsa: —Jehe, Jeso assire dicca tadsa ppa tidsahijine tiaccajo −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nadsapa Dsodse etero dsojorani onini lino, bica tanicca mittade toccajari. Mitta inadsapi Jeso coba dsanaha que tahihuaji tocanajoranijari, Jeso assire dicca inadsa eterodsa jore inaqquijari. Nadsapa Jeso assire tonoccobirihuaji dsojo inajari. Nanidsa tonoccobirijine sibadsa hui todsimani najorapojaro. Nahidsa Jeso assire dsojo idsimadsa ibedsajari. Siba imeni pata inanidsa Jeso noccobiri odinihuaji ecossajaro nade. ");
INSERT INTO cul_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nanidsa Maria Madarenahuajicca, Josecca ami Maria quinajarodeni Jeso assire ibedsahi qqui toquinajaro. ");
INSERT INTO cul_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jassinajacca huada jicadsapi Maria Madarenahuajicca, Maria Satiaco imeni, Sarome quinadsa ahua majiconi majoni bica tajaro mittade jai tojajaro, Jeso assire huira inarimanahijine. ");
INSERT INTO cul_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Semana tojapomanicca huada tahidecca domingo dsidsidsamassa maji ssido najonadsa Jeso noccobirihuaji ahua majiconi majoni bica tajaro iaccamanajaro. ");
INSERT INTO cul_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nadsapi Jeso noccobirihuaji jai tojadsa imahaha cadsanapojaro: —¿Nejecojari ia acco camapadsaja, Jeso noccobiricca siba imeni pata inanijine? −quinani nade. ");
INSERT INTO cul_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Naraha bacco toquinadsa qqui toquinaneje tonoccobiripi tohuabeje najaro. Siba imenipi pajimaranihuajina huitteje najaro. ");
INSERT INTO cul_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nadsapi jai tojedsimadsa qqui toquinaneje dsabisso eterori nopo taha nahatonihuaji huittari canajari. Nadsapi jabojo quinajaro nade. ");
INSERT INTO cul_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Dsabissopa ponidenidsa huati tajari: —¡Ticappinamana tejeraji! Tiadenipi Jeso Nasaretihuajicca qquide jai tijajonajaro. Najaripa ahua porimacossanidsa coba idsanamanadsa dsoqqueraha nahatonijari. Ajadsapa nohuerahi. Jari, pohua ibedsamanahihuaji qqui tiquinajo. ");
INSERT INTO cul_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nadsapi jai tijanidsa pohua huatimadedenidsa, Pedrodsa naqui ima huati tinanimanaji. Jesopa titedsejemadeni dsama arobeni Carireahuaji toccanipohuitohui. Nanihuaji jai tijanidsana pohua qqui tiquinahijine, pina pohua dsoqque-jaraccadsama tiadenidsa huati tapojarissa najaro −nahi nade dsabisso atti. ");
INSERT INTO cul_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nadsapi amonejedeni jabojomanadsa tacca-cca-cca quinadsa tonoccobirihuaji domoni qquenadsapi domoni toccanijaro. Nadsapi jahui domoni ccanidsapi cappinamaneri nadsa Jeso nahatonihicca ima huati toquina-jeraccani nade. ");
INSERT INTO cul_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesopa semana tojapomanicca huada tahidecca domingodsa dsidsidsamassa nahatonijari. Nahi dsotodepa Maria Madarenahuajiccadsa ahuatomajari. Najaro Mariapi tahide poni bodinidsa tocorime 7 quinaha cajiporaha Jeso dosse ininebaqquijari. ");
INSERT INTO cul_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maria Madarenahuajicca Jeso qqui tadsapi pohuadsa jahiridsapo-jaridenidsa huatide joppa nanijaro. Pohuadenipa oji oji camaraha Maria bacco nanidsa Jeso nahatonihi tahimari huati tajaro. ");
INSERT INTO cul_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Poni attinipi: —¡Jesopa camittemanidsa madipa! ¡Pajissa qqui onapa! −nani nade. Naraha poni attinidsa pajissa quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dsotode naco Jeso pohuadsa pajissa quinajarideni pamahadsa ahuatomajari. Pohuadenipa odsa capamema najarohuaji tohuedadsa jahuidsa Jeso bacco quinaraha pohuadenidsa jidsa taccajari. Dsotodena noccodeni jidsera najari. ");
INSERT INTO cul_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nadsapa tohuedanijari. Jesodsa toquejenajaridenidsa Jeso nahatonihicca ima huati tanimanaraha pohuadeni attidsa naco pajissa quina-jarahi nade. ");
INSERT INTO cul_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dsotode naco pohua huatimadedeni 11 quinajari jipade toquejenahidsa Jeso ahuatomajari. Pohuadenipa: —Jehe, Jeso nahatonihijine pajirahi −quina-jaradsa huaribodeni sibaqquiri nadsa Jeso huati icanabaqquijari: —¿Nejecotohui occa madijapa onahatonini qqui toquinaraha pohuadeni attidsa pajissa tiquinejerajaro? −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Nadsapa denima huati tajari: —Dsama huapimadsa jai tijaridsaji. Madija huapimadsa otahimari madija tocassiejerahijinecca teccoraridsa-manaji −nahi nade. ");
INSERT INTO cul_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","—Nadsapa madija otahimaridsa pajissa quinadsa passodsa totopa cajimanadsapa tocassiejerahitohui. Naraha madija ohuadsa pajissa quina-jarajaridenipa Diojine najidsohue jiquejeranihuaji jai tojahitohui. ");
INSERT INTO cul_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ohuadsa pajissa quinajaridenipa ohua onidsa dsepedeni ijimanadsa canahatorimana canahitohui. Canahatorimana canadsapa Diocca dacorehe ahuato tanitohui. Jehe, ohua onidsa huati huati toquinadsapa Satanacca dodosse tocorime dosse ininebaqqui-manahitohui. Tohuatti onihidsa naco huatide nahatoqquiri nahitohui. ");
INSERT INTO cul_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Macca coma tahicca damade pajiramanahitohui. Coma tahicca oni veneno dse quinadsa naco pohuadenidsa comene nohuerahitohui. Madija comaqquiri najarideni naco pohuadeni dsepedsa bara quinadsapa totocanomire nahitohui −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nadsapa ia Medsede Jeso pohua huatimadedenidsa huati taha jicadsapa memehuaji Dio pohua iaccamacossanijari. Diopa Jeso deni inanadsapa Pohua inori nahatonihuaji inahittarijari, madija ihicadossebaqqui nahijine. ");
INSERT INTO cul_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nadsapa Jeso tahimari icassiejeranijinecca pohua huatimadedeni dsama huapimadsa ecomeraridsa-mananijine jai tojaridsajari. Ecomeraridsa-manadsapi ia Medsede acco icamabaqquidsa pocca dacorehema canahatorimana canaridsajari. Nama quinadsapa madijadenidsa Jeso tahimari pajissa ahuato tajaro. Epejeni.");
INSERT INTO cul_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","¿Nija Teofiro? Tiadsa Jeso tahimari dsodo onajaro. Tahide Jeso pohuadsa toquejenajarideni mota huapi taha pohua tahimari dsodo naridsamanapojaride. Pohua tossonapohui tahimaria aja nahatonidsa Imehidsa toccamacossanihi bacco tajaropaji. Pohua tahimari huapima pajiranissa tanijine quinadsa dsodode disseraqquiri najaride. ");
INSERT INTO cul_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Aja pohua huatimade pohuadsa jajahiridsa najarideni pocca nahatonaja onihi, onihi nehe qqui najonamanajari naqui dsodo quinajari. Aja Jeso pohuadeni mari mari ihicanabaqqui najari naco dsodo quinajari. Pohuadenipa Jesocca marinaja ehecomeraridsamana najaro naqui icahatterajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nadsapi ohua naqui Jeso tahimari dsodo ocadsanaponijine tohuini onadsa aji Jeso pohua tahimaritohui, pocca marinajatohui dissera onajarode. Aji poccadeni dsodoniji huapima naqui hua onaridsajarode. Aja madija Jeso qqui toquinajarideni, pocca marinaja mittamanajarideni, najaridenicca ima naqui omittanissa tanijine onadsa occaridsajarode. Jeso pohua tahimari huapima dsodo quinajarocca onatassaqquidsa ojine tahideccadsama pajissehera dsodo onajonajaroa ajijaropaji. Jehe Teofiro, Jeso tahimari huapima ticajinijine onadsa tiadsa dsodo onajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Aji Jeso tahimari tia maridedeni tia mari icanamanajaro huapimapi pajissa nahato tinanijine tiadsa dsodo onajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nadsama Herodepa Isaraeri potemahi jodiodenicca dsama onini Jodea cacahuade tojadsa Sacaria naco madiccajari. Pohuapa Diodsa dada toqquimade tojajari. Nahihuaji dsepedeni ihijimana najarideni mota onidenipa Abia potemahideni. Sacaria naco Abia potemahideni. Pohuadenipa Diodsa dada toqquimahuaji cacahuade toquejenadsapa madijacca da naqquinaja Diodsa dada ihiqquimamana najaro. Pocca amoneje Sabeopi Arao potemani. ");
INSERT INTO cul_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sacaria pocca amoneje tadsajanipa poccadeni ima Diodsa bica tajaro. Ia Medsede Diocca dosseniji naqui ecahuamananissa tajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Naraha Sabeopi ccaranije najaro. Maqqui tedseje ejedeni jiraha jadahi tocajamanajari. ");
INSERT INTO cul_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Diodsa dada toqquimadedeni huapi taraha ojari ojari quinaha bodihuaji totoqquedsimamana, najari nahatohui majo bicabote tohuesside. Tohuessidsapa essene majo bica taha jami-mi canadsapa Diodsa huati huati totoquina najari. Sacariacca madija Abiadeni Diodsa dada toqquima ecahuamanadsapi madija ojaria bodihuaji toqquedsimahijine qqui quinahijineccadsa Sacaria oni bacco quinajari. Nadsapa Sacariana majo bicabote iessihijine bodihuaji dosse idsimamanajari. ");
INSERT INTO cul_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Toqquedsimadsapa majo bicabote iessidsa jami-mi cananaja amossinihuaji madija huapima Diodsa huatide toquejenaja najari. ");
INSERT INTO cul_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sacariapa nahi bodihuaji madiccadsa Diocca dodosse Pohua Atti ccaccaronade pohuadsa ahuatomajari. Majo bicabote tohuessidsa majo toccabaqquihijinecca huahuanari inorini nahatonihuaji huajari. ");
INSERT INTO cul_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nadsapa Sacaria Diocca dodosse qqui inadsapa cappinajari: —¿Nejecora ohuadsa tojapadseje? −najari. ");
INSERT INTO cul_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Naraha manaco Dio Atti ccaccaronade attipa: —Sacaria ticappina-jeraji, Diopa ticca huatinaja mittahi. Ticca amoneje Sabeopi ejedeni cajinitohui. Tossonadsapa onipa: Huano, tana −najari. ");
INSERT INTO cul_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","—Ticca ejedeni tossonadsapa tetidsenitohui. Madija ohuahadeni naco huatidsemanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nadsama najari ticca ejedenipa Diodsa bica taha tojahitohui. Pohuapa uva ppejene dse najarahitohui. Dsedse coma tanicca naco dse najarahitohui. Pohuapa tossona-jaraccadsama Dio Corime pohuadsa tojahitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pohuapa ajama nahitohui: Nidsa Diocca ima ecomeraridsadsapi Isaraeri potemahi jodiodeni mota huapi taha ia Medsede Diodsa toquejenani-pomahitohui. Nama nahitohui pohuapa. ");
INSERT INTO cul_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nadsama Huanopa Dio Corime inadacorahitohui. Pina maittaccadsama Dio Atti cacomerabote Eria Dio Corime inadacorajarissa nahitohui. Pohuapa ia Medsede tedsejema madija bodideni inanajorabaqquipohuitohui. Nahi aja imehideni bodideni tobicamanadsapa pohuadeni bedidenidsa huatideni huanaqquiri nahijine. Aja Diodsa iboqquiri najarideni naco mittamanadsapa Diodsa tohuiboramanahijine. Nidsa pohuajine madijapa ia Medsedetohui najoramanahijine −najari Dio Atti ccaccaronade. ");
INSERT INTO cul_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Naraha Sacaria manaco huati tajari Dio Atti ccaccaronadedsa: —¿Nejecoma onadsa ticca ima pajissa tojani nahato onanijine? Ohuapi jadahibote ojani, occa amoneje naqui jadani tocajani −najari Sacaria atti. ");
INSERT INTO cul_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Naraha Dio Atti ccaccaronade attipa: —Ohuapi Cabirie Dio madihihuajicca ojani. Dio acco acco ohocama najari. Dio ohua dosse naronajari tiadsa ima bicani huati onanijine. ");
INSERT INTO cul_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Naraha aji huati onajarodsa pajissa tejeradsapi tetti jirehe timadiccanitohui. Nidsa ejedeni tossonahicca abadsico bacco tadsapa tossonahitohui. Ticca ejedeni tossonadsana tetti ticajipomanijine. Nadsana aji pajissa huati onajaro nahato tinanitohui −najari Dio Atti ccaccaronade Sacariadsa. ");
INSERT INTO cul_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Naraha Diodsa dada toqquima huapihuajiccadsa Sacariatohui madimanajarideni attidenipa: —¿Nejecotohui Sacariapa bodihuaji najojari? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nanaja Sacaria qquenadsapa huati tahitohuiraha atti cappiraha qquenajari. Naraha madija pohuadenidsa ima ahuato teje najaro: —A, Diodsa dada toqquima bodihuaji Diojine pohuadsa ima ahuato tajaro nitide −quinajari. Nadsapa Sacaria madija nahatoqquiri nahijinepa pohua dsepedsara dsopi dsopi najari, atti cappiradsapa. ");
INSERT INTO cul_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sacariapa nahi Diodsa dada toqquimahuaji madiccajari. Aja pocca madija Abiadeni dsepedeni jicahicca huada bacco tadsapa Sacaria toccanijari pocca odsahuaji. ");
INSERT INTO cul_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nahidsa tomadinimanadsana Sacaria bedimeni Sabeopi jiajaro. Pina ponicca madijacca marinajassa najaro ejedeni idsonidsa huittidsadsapa abadsico 5 canaha ponicca odsahuaji qquena-jeraccani. ");
INSERT INTO cul_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Nani ponicca odsadsa madidsapi poni bodinidsa: —Jidapapi madija ohuadsa: “Ccarani” huahua quina-jarahitohui −najaro. —Jidapapi Diojine ejedeni ocajini. Ohuadsa ima bica tanicca tojani −najaro Sabeo. ");
INSERT INTO cul_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nadsapi Sabeo jianicca abadsico 6 canadsa odsa onihihuaji Dio pocca dodosse Pohua Atti ccaccaronade Cabirie dosse inaronapomajari. Najaro odsa oninipi Nasareti, dsama arobeni Carireahuajicca. ");
INSERT INTO cul_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nani Nasaretidsa dsohuato madijaro, poni oninipi Maria. Ponipi maqquideje caji-jeraccani, maqquideje ssamo taccani. Najaro dsohuatodsa Dio Cabirie dosse inaronajari, ponidsa huati tahijine. Nadsama najaro dsohuatopi Dsodse icajinijine tahide imehidenipa jehe canirepojari. Dsodsepa maittaccadsamacca tamine Dabi jinodi potemahi. ");
INSERT INTO cul_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nadsapa Dio Atti ccaccaronade Cabirie ccaronadsapa Mariadsa ahuatodsa huati tajari: —Nija Maria, Dio tia catidsehi. Ia Medsede Diopa tiadsa madihi −najari. ");
INSERT INTO cul_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria pohua atti mittadsapi huajo najaro. Poni bodinidsa: —¿Nejecotohui pohua atti nama najari? ¿Nejeco imara ohuadsa tojapadseje? −najaro. ");
INSERT INTO cul_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nanaja Cabirie ponidsa huati tapomajari: —Maria ticappina-jeraji. Diodsa bica tinani. ");
INSERT INTO cul_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jidapapa ejedeni tidsonedsa huittidsahitohui. Nadsama ejedeni tossonadsa onipa: Jeso, tana −najari. ");
INSERT INTO cul_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","—Pohuapa denima madija bicahi tojahitohui. Pohuadsa: “Dio memehuaji madijaricca Ejedeni” quiquinanahitohui. Ticca ejedenipa ia Medsede Diojine tamine deni tojahicca tojahitohui, pina pocca idi maittaccadsamacca tamine Dabissa nahitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pohuapa pocca madija Isaraeri potemahi ecahuabaqqui-dsanapohuitohui. Pocca cacahuehe naqui jiquejeranitohui −najari Cabirie atti Mariadsa. ");
INSERT INTO cul_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Naraha manaco Maria Cabiriedsa huati tajaro: —Ajijaro imapi ¿nejecoma najaro? Ohuapi maqquideje ocappiraccaha, maqquideje ssamo onaccani −najaro. ");
INSERT INTO cul_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Naraha manaco Cabirie huati tajari: —Dio Corimepa tiadsa bacco naronahitohui. Dio memehuaji madijaripa tiadsa pocca dacorehe inananitohui. Pina meme esseni nahuini tiadsa huedsana najarossa nadsapi Diocca dacorehe tiadsa tojanijine. Najarojine ejedeni nahatojaripa imasiri cappira, bodi ssiaja tahitohui. Pohuadsa: “Dio Bedi” quiquinanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nadsama aji ticca madija Sabeo naqui jadaniraha ejedeni cajini. Abadsico 6 canaha poni idsonidsa huittidsaccahi. Madija huapima ponidsa: “Ccarani” quiquinanaraha jiajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diopa ssamo tajarahi −najari Cabirie. ");
INSERT INTO cul_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nadsama Maria poni attinipi: —Jehe, Diocca medse ojani. Pohua Attidsa ibora onani. Aji huati tinajaropi Dio ohuadsa inanana −najaro. Nadsapa Dio Atti ccaccaronade Cabirie toccamacossanijari. ");
INSERT INTO cul_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nadsapi Maria ponicca madija Sabeo qquide dsama arobeni Jodeahuaji huassinaja toccajaro. Ssonohuajicca odsa panani bacco tajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nanihuaji Maria bacco tadsapi Sacariacca odsadsa toqquedsimajaro. Sabeodsa: —¿Nija, bica tinaqui? −najaro. ");
INSERT INTO cul_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Maria nija nani Sabeo mittadsa poni idsonicca ejedeni ttai ttai nadsapa Dio Corime Sabeo bodinidsa tojahissa tajari. Nadsapi Dio Corimejine bodini nahato tajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nadsapi Sabeo poni attini ahuato tadsa Mariadsa huati huati tajaro: —Diojine tiadsa ima bicani tojani. Amoneje huapi taraha tiadsana Dio ima bicani denima inanajaro. Tidsonecca ejedenidsa naco Dio ima bicani inananitohui −najaro Sabeo. ");
INSERT INTO cul_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","—Nadsama ohuapi ajimani ojaraha ohua Medsedecca ami ohuadsa ticcajonajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ohuadsa nija tadsapi ohuidsonecca ejedeni huatidsejari, ttai ttai nahi. ");
INSERT INTO cul_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jehe, ia Medsede Dio tiadsa huati tapohuicca ima pajissa tojanijine pajissa tadsapi Dio tiadsa ima bicani inanajaro −najaro Sabeo Mariadsa. ");
INSERT INTO cul_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nadsapi Maria Diodsa huatidsedsa attinipi: —Obodi ohuattima: Ohua Medsede deni tojajari, bica tahi, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ohua ocorimema Dio ohua Tonassiajadedsa ohuatidseri najaro. ");
INSERT INTO cul_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ohuapi Diocca medse ajimanicca ojaraha aji jidapanadsama madija attidenipa: “Diocca biquehe tiadsa tojani” dsadsanapomana nahitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dio Dacorabote ohuadsa ima denima bica tanicca inanajaro. Pohua oni imittadsapi Pohuapa imasiri cappira, Pohua bodi ssiaja tahi nahato inajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nadsama Diopa Pohuadsa madija cappinamanadsa, Pohuadsa huahuatidsemana nadsa naco pohuadenidsa huati cahanari canahitohui. Pohuadeni potemahidsa naco nama dsanapohuitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dio pocca dacorehema dsepe ihiji najari. Aja madija pohuadeni bodi attideni: “Nahato onani, Dio jirehe bica onani” quiquinanajaridenipa Dio pohuadeni inajaribaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nadsama tamine dacorabotedeni naco Diopa poccadeni dossehepi inajicaridsanitohui. Ajamani toquejenajaridenina Diopa deni inanabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pemi madimanajaridenidsana huemahi da inahitohui. Naraha dsepedeni sseqquiri najaridenipa dsepedeni jiraha Dio pohuadeni dosse inanibaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nadsama ia Isaraeri potemahideni Dio Attidsa iboraqquiri inajaropi Dio Pohua ia acco tocamabaqquihitohui. Isaraeri potemahideni iadsa Diopa huati ajama-jarahitohui. Pocca tohuati huanehema iadsa huati cahanari cadsanapohuitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jehe, najaro imapi Dio icca ididenidsa huati taja najonapohui najari. Icca idi Abarahaodsa, pohua potemahideni huapimadsa huati cahanari canajonajaria aja iadsa naco nama nahipaja dsanapojari −najaro Maria Diodsa huatidsedsa. ");
INSERT INTO cul_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariapi abadsico 3 canaha nani Sabeodsa madiccajaro. Nadsapi ponicca odsahuaji toccanijaro. ");
INSERT INTO cul_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Sabeocca ejedeni tossonahijinecca abadsico bacco tocanadsapa maqquideje bedi tossonajari. ");
INSERT INTO cul_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tossonadsapa poni inorinidsa madimanajarideni, ponicca madija quinadsa ponicca odsadsa queriqquijari. —Diopa ponidsa huati huana tadsa ejedeni cajijaro −quinahi ima mittamanadsapa ponidsa jahijonajari, poni tadsajani huatidsemanahijine. ");
INSERT INTO cul_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ejedeni huadari 8 nadsapa jodiodenicca huissinaja cajihijine poccadeni madija huapima naco jahijonajari. Pohua oni naco imehi onidsa icanacanimanahijine: —Sacaria −quinahijineraha. ");
INSERT INTO cul_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Imeni attinipi: —Apajana, pohua onipa Huano −najaro. ");
INSERT INTO cul_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Nadsapa attidenia: —Naraha ticca madija oni nama nahi nohuerahi −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nadsapa ejedeni imehidsa: —Ticca ejedeni oni ¿nejecoma nahi jipa tinani? −quinadsa pohuadeni dsepedsa dsopi dsopi quinajari. ");
INSERT INTO cul_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Naraha imehipa pohua bedi oni dsodo inahijine ahua ssapa tajarotohui pohua dsepedsa huahua najari. Nadsa dsodo inadsapi: —Pohua onipa: Huano −najari. Nadsapa huapima huajo canirejari. ");
INSERT INTO cul_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nanaja Sacariapa atti cajimanipomajari. Atti cajimanipomadsapa: —¡Diopa bica tahi! ¡Pohuadsa ohuatidsejaro! −najari. ");
INSERT INTO cul_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nanaja Sacaria inoridsa madimanajarideni jabojo quinajari. Nadsapi najaro dsama arobeni Jodeacca ssono bedeni namidsa tanidsa madiridsamanajaridenidsa naqui ima tojaridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nadsapa huapima ima mittaridsamanajaridenipa pohuadeni bodia: —¿Nejecoma napadsaja ajajari ejedenipa? −quinajari. Dio pocca dacorehema Huano ecahuahissa dsanapojari huapimadsa ahuato tajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nadsama ejedenicca abi Sacariapa Dio Corime pohua bodidsa tojahissa tadsa Dio Atti ecomerajaro: ");
INSERT INTO cul_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—¡Diopa bica tahi! ¡Ia Isaraeri potemahideni Medsede deni tojahi! Iapi Dio pocca tocattabaqquinaja iquejenajaro. Dio iadsa ccajonahitohui, ia todinibaqquihijine. Najarojine Pohuadsa ehetidse najaro. ");
INSERT INTO cul_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ia Tonassiajade dacorabote iadsa dosse inaronajari. Pohuapa maittaccadsamacca tamine Dabi Diodsa iborabote potemahi. ");
INSERT INTO cul_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Diopa maittaccadsama Pohua Atti cacomeraqquiri najaridenidsa ia Tonassiajade ccajonahijine tahimari huati tapodsapa ehecomeramana najonajaro. ");
INSERT INTO cul_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ia Tonassiajadepa ia jaradedenicca jarehedsa ia tonassiajabaqquihitohui. Iadsa jiperaqquiri najarideni naco huadidi taraha pohuajinena icassiejeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Diopa icca ididenidsa huati huana tajari. Pohuadeni tedseje jehe canirejaricca ima huati ajama-jarajari. Inapajiranissa tanitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Najaropi maittaccadsama icca idi Abarahaodsa Dio huati tapojaripa: “Pajissa Ohuattissa onananitohui” napojari. ");
INSERT INTO cul_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Icca ididenidsa huadiqquiri najarideni jara jara ihinabaqquimana naraha Diona inassiajabaqquijari. Jidapana naqui ia huadide noppine icappina-jeradsa Diodsara iboraqquiri idsanaponitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ima jirehe Pohuadsara imadinissa dsanaponitohui. Icca madie naqui Diocca dossenijidsa pajiranissa dsanaponitohui −najari Sacaria atti. ");
INSERT INTO cul_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nadsapa pohua bedidsa huati tajari: —Jehe Huano, tiapi occa ejedeni, nidsa tinapidsapi ia Medsede tedsejema madija bodideni tinanajorabaqquipojaripa pohua ccajonahitohui madimanahijine. Nema tadsapi tiadsa: “Dio memehuaji madijari Atti cacomerabote” quiquinanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Huano, tiapi icassiejeranijinecca ima ia Dio pocca madija iquejenajaro iadsa huati tinaridsanitohui. Dio icca imasiri epeje inanadsapi nidsa pocca najidsohue tojadsa dsori icanirenitohui. ");
INSERT INTO cul_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Dio iadsa huati cahanari canadsa ia Tonassiajade iadsa dosse inaronabote nahi. Najaripa madija inassiajabaqquihitohui. Dio tedseje icajoneranijinecca ima naqui ia tonahattabaqquihitohui. Ia Tonassiajadepa pina dsidsidsamassa maji ccajonadsa ssire najonajarissa najari. Ssiajani dsati iadsa bacco najaro. Madija dsidsinidsa madiridsamanajaridenipa dsoqquehe noppineni cappinamanaraha ssiajani dsati pohuadenidsa tossiajaridsadsapi memehuajicca jahui ahuato inanajaro −najari Sacaria atti. ");
INSERT INTO cul_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nadsama Sacariacca ejedeni Huanopa Diocca dacorehema napidsanapojari. Diotohui dissera taja najari. Dsotode denima napidsapa dsama huamoni ssono caji, siba caji tanihuaji madidsanapojari. Nadsapa Dio Pohua jipa tahicca huada bacco tadsa Isaraeri potemahideni mari icanabaqquihijine Huano dosse inajari. ");
INSERT INTO cul_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jeso tossona-jaraccadsapa dsama huapimacca imapi ajima najaro: Tahidepa romanodenicca tamine deni tojahicca onipa Acosto pohua bodipa: —¿Nejecoma naha madija madimanahi occa cacahuehedsa? −nadsa madija onideni huapima dsodo naridsamanahijine pocca dosseniji ccaridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nadsapa Acostojine dsama huapimacca madija onideni dsodode tahidecca dsodo quinajari. Najari huajanodsa pohua biji accode onipa Quirinio dsama Siriahuaji cacahuade tojajari. ");
INSERT INTO cul_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nadsama madija huapima dsama onihi onihidsa mamadimaneri naridsamanaraha birididenicca dsamadsa jai tojaniridsajari. Isaraeri potemahideni naco birididenicca dsamadsana pohuadeni oni dsodo quinahijine jai tojaniridsajari. ");
INSERT INTO cul_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nadsapa Dsodse. Pohua naco dsama arobeni Carireahuajicca odsa panani onini Nasaretidsa madiraha biridi tamine Dabi madipohuicca odsa panani Berenehuajina toccanijari, pohua oni dsodo nahijine. Berenepi dsama arobeni Jodeacca. ");
INSERT INTO cul_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nadsama Dsodsepa Maria tadsajani Berenehuaji tohuedajari. Mariapi Dsodse pohuadsa da quinaraha ponidsa huada huada najaraccahi. Poni idsonidsa ejedeni huittidsaja najari. ");
INSERT INTO cul_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Nadsapa Berenehuaji bacco toquinaraha odsa ijiridsajaro. Madija huapima tahide bacco toquinapoja najari. Odsa ijiridsadsapi Dsodse pocca amoneje tadsajanipa bohuicca huahuadadsa madimanajari. Nahidsa madimanadsana Mariacca ejedeni comajari. Poni bedi tahidecca tossonajari. Nadsapa etero dsojoranidsa teppe inadsa dsero huanarini tetepidsa ibari najari. ");
INSERT INTO cul_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nadsama odsa panani Berene huajira tanidsapa edede cacahuadedeni madimanajari. Pohuadenipa huamonidsa jassi jassi tajari. Dsomepa edede cacahuade noccodeni bibissa najari. ");
INSERT INTO cul_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nanaja pohuadenidsa Diocca dodosse Pohua Atti ccaccaronade ahuatojari. Dio Pohua ssiejene tossiajabaqquidsa cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Naraha Dio Atti ccaccaronade pohuadenidsa: —Ticappinamana tejeraji. Tiadenidsa ima bicani huati onana −najari. —Huatidsehe imeni madija huapimadsa tojaridsanijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","—Jidapapa tiadeni Tonassiajade tossonahi, tamine Dabicca dsamabote Berenedsa. Pohuapa ia Idinide Cristo-Mesia najari. ");
INSERT INTO cul_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nadsama aji occa huatinaja nahatoqquiri tiquinanijinepi ajima nani qqui tiquinanitohui. Ejedeni tossonedsatipa etero dsojoranidsa teppe naha dsero huanarinidsa pori canahitohui −najari Dio Atti ccaccaronade. ");
INSERT INTO cul_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nadsapa ima huati taha jicadsapa Diocca dodosse tabaqqui memehuajicca huapi taha amadsati ahuatoma-manadsa Diodsa huatidsemanadsa jiri jiri quinajari: ");
INSERT INTO cul_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—¡Dio memehuaji madijaripa bica tahi, deni tojahi! Namihuaji Pohuajine huatidsehe cajiridsani. Dio pocca cacatidse tabaqquidsa pocca jonehe tojaridsani −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nadsapa Diocca dodosse tabaqqui memehuaji jai tojamacossanidsapa aja edede cacahuade attidenipa: —¡Jina, Berenehuaji jaijanina! Ia Medsede iadsa huati tahi qquide jaijanina −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nadsapa huassinaja jai tojanidsapa Maria Dsodse tedseje madimanahidsa bacco toquinajari. Nanaja ejedeni pori canajari dsero huanarinidsa. ");
INSERT INTO cul_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nadsapa edede cacahuadedeni ejedeni qqui toquinadsapa aja Diocca dodosse attissa nehe qqui toquinajari. Nadsapa Diocca dodosse ejedeni tahimari pohuadenidsa huati tajaricca ima ecomeramanajaro nahicca madijadsa. ");
INSERT INTO cul_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nadsapa madija mittamanadsa: —A, nema najaroraha... −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Naraha Mariapi ponicca ejedenicca ima Dio ponidsa huati tapojari poni bodinidsa huatini ajima nejerajaro. Edede cacahuadedeni ponicca ejedeni tahimari huati toquinadsa naco najaro ima poni bodinidsa huatini ajima nejerajaro. ");
INSERT INTO cul_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nadsapa edede cacahuadedeni huamonihuaji jai tojanidsapa Diodsa tohuatidsenimanajari: —¡Abi Dio bica tinani! Tijine ia Idinide tahimari imittadsapi iadsa bica tani. Ia Idinide tossonahi qqui inadsa naco etidseni −tanimanajari. Imapi pina Diocca dodosse huati tapojarissa nehe tojadsapi tohuatidsenimanajari. ");
INSERT INTO cul_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ejedeni huadari 8 nadsapa jodiodenicca huissinaja cajijari. Nadsapa pohua oni naco icanacanimanajari: Jeso, quinajari. Najari onipa Maria jia-jeraccadsa Diocca dodosse ponidsa huati tapojari. ");
INSERT INTO cul_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Nadsapa Jeso tossonahi natti huada 40 jicani nattinipi Dsodse Maria tadsajani aji Moisesicca marinajassa inanamananijine Jerosarehuaji tohuedajari. Amoneje ejedeni tocassonadsa ama toccajarojine Diodsa bica tejerani, Moisesicca marinajadsa naqui oppina tani, quiquinanajari jodiodeni. Nadsapi ponicca ima Diodsa tobicanijinepi ajima nanina bica tajaro: —Ejedeni tossonahi natti huada 40 jicadsapi imenipi Diodsa dada toqquimahuaji toqquedsimadsa ponicca daniji Diodsa da inahijine −nani nade Dio Atti dsodo nanidsa. Nadsama ponicca daniji Diodsa da inahijinepa ajima nana: —Midsori pamehe amoneje maqqui tedseje dada titiquina nana. Midsori nohueradsapi ococo napidsati pamehe naqui dada titiquina nana −nani nade Dio Atti dsodo nanidsa. Nadsapa poccadeni ejedeni naco iaccamanajari: —Diodsa da inahijine −quinadsa. Najaro ima naqui Moisesicca marinajadsa dsodo najaro: —Ejedeni maqquideje bedi tossonapojaripa Diocca tojana −nani nade Dio Atti dsodo nanidsa. Nadsapa Dsodse, Maria poccadeni ejedeni Jerosarehuaji dsojo quinajari, Diodsa dada toqquimadedeni qqui toquinadsa Diodsa huati toquinahijine. ");
INSERT INTO cul_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nadsama madija oni Simeopa Jerosarehuaji madijari. Pohuapa bica tajari. Diocca dossenijissa inananijine dissera tajari. Isaraeri potemahideni Idinide ccajonahitohui madijari. Dio Corimepa Simeodsa madijari. ");
INSERT INTO cul_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nadsapa pohua bodidsa ima ahuato inanajaro. Najaro imapi: —Tidsoqque-jeraccadsama ia Idinide Cristo-Mesia qqui tinahitohui. Diopa Mesia dosse inaronabote nahi −napojari Simeodsa. ");
INSERT INTO cul_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nadsapa Dio Corime pohua icadossedsapa Diodsa dada toqquimahuaji toqquedsimajari. Nahidsa madidsapa Jeso imeni imehi tedseje bacco dsimamanajari. Pohuadenipa pina Diocca dosseniji dsodo naniccassa nehe inanamananijine Jeso iaqquedsimamanajari. ");
INSERT INTO cul_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nadsapa Simeo Jeso qqui tadsapa ididsa, dsojo ijidsadsa Diodsa huatidsejari. Pohua attipa: ");
INSERT INTO cul_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Jehe ohua Medsede Dio, jidapanana ohuadsa huati tapojarocca ima bicani tijine pajiranissa tani −najari. —Jidapapa ajajari ejedeni qqui onahi, najaritohui obodi huahuatoma naccade. Jidapapa Isaraeri potemahideni icca ima tobicanitohui, onajaro. Nadsama ohuapi jidapanana odsoqquenijine onajorani. Odsoqquedsapi bica tani, onajaro −najari Simeo atti. ");
INSERT INTO cul_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","—Jehe jidapapa ohua onoccodsa qqui onahi ia Idinide. ");
INSERT INTO cul_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Pohuapa tossiejehe jinede, madija huapimacca tojahitohui. ");
INSERT INTO cul_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pohuapa pina ssiajanissa najari. Pohua ssiejene tossiajabaqquidsapi Isaraeri potemahi jodio quejena-jarajaridenidsa Diojine madija tocassiejerahijine tahimarini ahuato inananitohui. Jehe Abi Dio, ticca madija ia Isaraeri potemahidenipi iadsa madija huapima attidenipa: “Ticcadeni dsamadsa ia Idinide tossonadsapa Diojine tiadenidsa ima bicani tojani” quiquinanahitohui −najari Simeo. ");
INSERT INTO cul_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nadsapa Dsodse bedimeni tadsajani Simeo atti mittamanadsapa jabojo quinajari. Nadsapa pohuadeni attipa: —A, icca ejedeni tahimari nahato taha −quinajari bedimeni tadsajani. ");
INSERT INTO cul_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Naraha Simeopa pohuadenidsa denima huati huati tajari: —Diocca biquehe tiadenidsa tojadsanapona, onajaro −najari. Nadsama Maria ponidsa naco huati huati tajari Simeo: —Diopa ajajari ejedeni dosse inaronajari, Isaraeri potemahideni icanaroberidsa-baqquihijine. Mota huapi taha pohuadsa jiperaqquiri nadsa Dio pohuadeni ettajobaqquidsapa ocasserani ahuamanahitohui. Naraha pohuadsa jipaqquiri najaridenipa nidsa dsotodepa ima bicani cajimanahitohui, Diodsa madimana-dsanapohuijine. Jehe, ajajari ejedenipa Isaraerideni inassiajabaqquihijine Dio dosse inaronaraha madija motapa pohuadsa jara jara quiquinanahitohui. Pocca marinajadsa naco huattajojo tahitohui. ");
INSERT INTO cul_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nama quinadsapa madija bodideni huatohue ahuato tajaro. Madija mota attidenipa: “Diodsapi jipaqquiri inajaro” quiquinanaraha pohuadenipa Jesodsa jiperaqquiri nadsapa pohuadeni atti pina maidsehessa nani. Diodsa jipaqquiri najaripa pajissa jerani. —Nadsama Maria, ticca ejedenicca imapi tiadsa ocassera tehe tojanitohui. Pina huahuajinadsa tibonoccori pora tocaniqquimajarossa nanitohui −najari Simeo atti. ");
INSERT INTO cul_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Naraha nani Diodsa dada toqquimahuaji naqui amoneje jadani madijaro. Poni oninipi Ana. Ponipi Dio Atti ehecomera najaro. Imehi onipa Panohue. Najaripa idi Asera potemahi. Ponipi jadani tocajani. Dsohuatoponipi maqquideje cajiraha huajano 7 nadsapa maqqui dsoqquejari. ");
INSERT INTO cul_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nahi maqqui dsoqquedsama tabira madijonajaroa huajanorini 84 bacco tajaripaja. Ponipi Diodsa dada toqquimahuaji madijaro. Amossinihuaji totoqquena nejerani. Ponipi ssiajabote dsome naqui Diotohui nadsapi dissera tajaro. Jipehe naqui huajijiradsa nenebocossa najaro. Diodsa naqui huajijiradsa huati huati teteje najaro. ");
INSERT INTO cul_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nadsama Maria Dsodsedenihuaji Ana ccajonadsa ejedeni qqui tadsapi huatidsejaro: —Jehe Abi Dio, jidapanana ticca dosseniji bica tahi qqui onajari, ia Idinide tojahijine −najaro Ana. Nadsapi madija huapimadsa pocca ima huati huati tajaro: —Jidapanana Jerosarecca madija aji ia Isaraeri potemahi iquejenajaro huapimadsa ia Idinide Cristo-Mesia bacco najonahi. Nidsa ia todinibaqquihitohui −najaro Ana attini. ");
INSERT INTO cul_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nadsapa Dsodse Maria tadsajani ejedeni tossonedsaticca ima aji Diocca dosseniji dsodo najarossa inanamanehe jicadsapi Carireahuaji jai tojanijari, nahi poccadeni odsa Nasaretidsa tomadinimanahijine. ");
INSERT INTO cul_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nahidsa madimanadsapa Jeso napidsanapojari. Pohua bodi naco tohuatta-dsanapojari. Dio naco Jeso icatidseri najari. ");
INSERT INTO cul_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nadsama jodiodenicca ejete imenibote bacco tajaro, oninipi Pascoa (Ettidsapi: Dio tossoniqquimajari, inajaro.) Jeso imehi imeni tadsajanipa ejete tohuajiradsa totohueda najari Jerosarehuaji. Nama dsanapomanajari huajano huajijiradsa. ");
INSERT INTO cul_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nadsama Jeso huajanori 12 cajidsapa pohuadenidsa Jerosarehuaji toccajari. Pina huajano huajijiradsa nama dsanapomanajarissa inanamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Odsa panani Jerosaredsa bacco toquinadsapa ejete qquide madimanaccajari. Ejete jicadsa Jeso imehideni huedaniraha Jesopa Jerosaredsa ibojari. Naraha Maria maqqui Dsodse tedsejepa bedidenitohui huatideni huato-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pohuadeni attipa: —Madija siba tajaria, pohua tessedsa ccanihitide −quinajari. Naraha cahadijacossahidsa poccadeni ejedenitohui qquiqquihihi naridsajari. Madija pohuadsa noccodeni jidsera tajaridsa, pohua imecotedenidsa naco huati naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Naraha bacco quina-jaradsapa Jerosarehuaji tohuedanipomajari. ");
INSERT INTO cul_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nadsapa pohuatohui qqui naridsamana-pomajari. Huada huatinimade tojari nadsana Diodsa dada toqquimahuajina Jeso bacco quinajari. Mamaridedenidsama pohua naco huittari canajari. Jeso pohua naco mamaridedeni imahaha canahidsa taharibo canajari. Pohua naco pohuadenidsa huati huati tajari, poccadeni huatinaja ecomerajaro. ");
INSERT INTO cul_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nadsapa huapima Jeso atti mittamanadsapa: —A, nahato tahi −quinajari. —Huati huati tahi imari bica taha −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nadsa imehi imeni tadsajani qqui toquinadsapa jabojomanadsa: —A, ajadsana quejemajariraha −quinajari. Naneje imeni attinipi: —Ato ¿nejecotohui iadsa huatirani tibojarotte? Iapi amossi tajaro nitidija inadsa icappinadsa titohui qquiqquihihi inaridsajaro −najaro. ");
INSERT INTO cul_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Naraha pohua attipa: —¿Nejecotohui otohuira ticadaridsajaro? Ohuadsa ssamomo tinaccajaro nitide. Ohuapi occa Abicca odsadsa odsepe ijijaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Naraha huati tahi mittamanaraha Jeso pocca ima mittamana-jaraccajari. ");
INSERT INTO cul_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nadsapa pohuadenidsa toccanijari, poccadeni odsa Nasareti bacco tanimanajari. Imehideni attidsa ibora tajari. Mariapi pocca dacorehe qqui qqui tadsapi poni bodini nahato tajaro. Pohua tahimari huatini ajima nejerajaro. ");
INSERT INTO cul_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesopa tohuattaja dsanapohui najari. Denima napi dsanapojari. Dio naco icatidseri dsanapojari. Madija naco icatidsemaneri dsanapojari. ");
INSERT INTO cul_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sacariacca ejedeni Huanopa Dio pohua cadossejaridsa dsepe ijibote nadsa dsama cacahuadedeni ajama quinajari: Odsa panani Romahuaji madimanajaridenicca tamine deni tojahicca onipa Tiberio. Pohuapa dsama huapima ecahuaridsajaro. Pocca cacahuehepi huajano 15 bacco tajari. Pocca dossenijidsapa madija ohuaha, madija ohuaha tamine toquejenaridsajari. Nadsama najaridenipa pocca dossenijidsa dsama cacahuade madiridsamanajari. Isaraeri potemahi jodiodeni madimanahicca dsama oninipi Jodea. Nahicca taminepa Ponsio-Pirato. Isaraeri potemahi mota madimanahicca dsama oninipi Carirea. Nahicca taminepa Herode. Herode pohua ohuaha Feripepa dsama onini Itorea ecahuajaro. Itorea inorinicca naqui ecahuajaro. Najaro dsama oninipi Taraconite. Itorea inorini onihihuajicca dsama oninipi Abirinia. Nahicca taminepa Risania. ");
INSERT INTO cul_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nadsama odsa panani Jerosarehuaji dada toqquimadedenicca tamine deni toquejenahi pamaha madimanajari. Onidenipa: Anasa, Caipa, quinajari. Jehe, najarideni taminedeni toquejenaridsadsa najari huajanodsa Sacariacca ejedeni Huanopa dsama todidi tanidsa madijari. Nanihuajipi dsama huamoni ponira, ssono caji, siba caji tani. Nahihuaji madidsapa Dio pocca dosseniji Huanodsa huati tajari. ");
INSERT INTO cul_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nadsapa hueni Jordao inidicca dsama huapima ccaridsadsa madija maride tojajari. Pohua attipa: —¡Ticcadeni imasiri tineboridsamanaji! −nanaridsa najari. —Tibodideni ajima tiquinaji: “Occa imasiri onebona. Jidapapi Diotohuira odsanapona” tiquinaji. Nadsana totopa ticajiridsamanaji. Nema tiquinadsapi Dio ticcadeni imasiridsa: “Epeje, ohuati ajimani” nahijine −najari Huano. (Pohuadsa: Baotista, quiquinanajari. Ettidsapi: Totopade, inajaro.) ");
INSERT INTO cul_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nadsama Huanocca imapi maittaccadsama Dio Atti cacomerabote Isahia dsodo inapojaro. Pohua atti ajama napojari: —Nidsa dsama huamoni ssono caji, siba caji tanihuaji madijaripa atti mohui tadsa madija huahua huahua ihinajonabaqqui nahitohui. Pohua attipa: “¡Ia Medsede ccajonabote nahi! ¡Tinajoramanaji! ¡Pohua tedsejema jahui tijinedeni tobicapoji! Najaroa aji tibodideni pohuatohui tinajoramanaji” nanaja nahitohui −napohui nade Dio. ");
INSERT INTO cul_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","—Pohua atti naco: “Nami totodohuedseri najaro tijinedeni ijiridsaji, onajaro. Ssono quequehemeri najaro ponanissa tanijine hui tiquinapoji. Jahui johuidso tajaro naqui tijinedeni borocco tapoji. Jahui ccababa tajaro naqui tijinedeni huire tapoji. Aji tibodideni naqui pina najarossa tinanamanapoji. Ia Medsedetohui tinajoramanaponijine ticcadeni ima tinanabicamanapoji, tibodideni tinahireridsamanaji. ");
INSERT INTO cul_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jehe, ia Medsedetohui tinajoramanadsa pohua ccajonadsapa pohuajine madija huapimadsa Diocca daniji tossiejehecca ahuato tanijine” nanaja nahitohui dsama huamonihuaji madijaripa −napohui nade Dio Atti Isahiajine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nadsapa madija huapi taha totopa tohui quinadsa Huano madihihuaji jahijonana canajari. Naraha Huanopa pohuadenidsa huati tajari: —¡Tiadenipi pina maccassa tiquinani, ticcadeni imapi tabaccora tajaro! Tiadenipi tibodideni cacajiqquimera-jeraraha: “Huano ia topa todsanabaqquidsapa Diocca najidsohuedsa dsori icanirenitohui” ¿tiquinajaroqui? Naraha tibodideni cacajiqquimera-jeradsapi dsori ticanire-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Naraha tettideni ajima tiquinadsana bica tani: “Imasiri onebona. Diotohuira obodi huahuatoma nanijine” tiquinadsapi tibodideni cacajiqquimeranicca ima ahuato tanijine ima bicanira tinanamanaji, onajaro −najari Huano. —Naraha tibodidenidsa ajima tiquinanitide: “Icca idipa Abarahaoja najari, Diopa ia tohuattajobaqqui-jarahitohui” titiquina naraha tiadeni ticamaidsanimanajaro. Diopa madijassa najarahi. Pohua jipa tadsapa aji siba huihuitteri naridsajarodsa naco Diopa Abarahao potemahissa naha inahatoridsahijine pajirajari. Paji tiadenipi: “Abarahao potemahi iquejenani” tiquinaraha Diodsa iboraqquiri tiquinejeradsapi tiadeni tohuattajo-baqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nadsapi Diodsa iboraqquiri tiquinejeradsa, ima bicani tinanamana-jeradsa naqui ticcadeni imapi pina ahua tabaccora tajaricca imassa najaro. Paji, najari ahua cacajine dsamipa najorahi. Ahua bono bica tajaradsapa ca tacaridsa tahi. Ca tacaridsadsapa bobottahuaji hua hua totodsima najari, diji tahijine −najari Huano. ");
INSERT INTO cul_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nadsapa madija attidenia: —Nadsapi iaha ¿nejecoma inanijine, ibodi cacajiqquimeranicca ima ahuato tanijine? −quinajari Huanodsa. ");
INSERT INTO cul_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Naraha Huanopa: —Jehe, tiadenipi etero tetepicca pamehe ticajimanadsapi aja madija etero tetepicca cappirajaridsa ojarie da tiquinaji. Nadsama dsamatapa ticajimanadsa naqui madija dsamatapa cappirajaridsa da tiquinajo −najari Huano atti. ");
INSERT INTO cul_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Naraha nahidsa naco madija jahijonajari, aja romanodenicca taminecca dosseniji dsiniro nanaccadedeni. Pohuadenipa: —Huano ia topa todsanabaqquina −quinadsa jahijonajari. Huanocca marinaja mittamanadsapa Huanodsa huati toquinajari: —Mamaride, ia naqui ¿nejecoma inanijine, ibodi cacajiqquimeranicca ima ahuato tanijine? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Naraha Huanopa: —Jehe, tiadeni naqui aji dsiniro tinaccamanadsapi pina taminecca imassa nehera titinaccamana naji, onajaro. Denimapi poni −najari Huano. ");
INSERT INTO cul_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Naraha nahidsa soldadodeni naco totopatohui jahijonajari. Huanocca marinaja mittamanadsapa Huanodsa huati toquinajari: —Iaha ¿nejecoma inanijine, ibodi cacajiqquimeranicca ima ahuato tanijine? −quinajari. Naraha Huanopa: —Tiadeni naqui madija pohuadeni dsepedenitajitohui, poccadeni dsinirotohui naqui jabojo tinanabaqquimana-jarajo, onajaro −najari Huano soldadodenidsa. —Nadsama madija ima cappiraraha pocca dsinirotohui pohuadsa ima tinanamanajaro. Naraha tiadenipi nema tiquinejeraji. Ticcadeni cacahuehe manaconi tamine tiadenidsa dsiniro da inajarora epejena. “Najarodsara imadina” tiquinaji, onajaro −najari Huano soldadodenidsa. ");
INSERT INTO cul_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Isaraeri potemahidenipa ia Idinide Cristo-Mesiatohui madimana-dsanaponaja Huanocca marinaja mittamanadsapa pohuadeni bodidsa: —¿Huanopa Cristo-Mesiaco? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Naraha Huanopa pohua cacomerajari: —Ohuapi passodsa tiadeni topa odsanabaqquijaro. Naraha madija dacorajari ccajonabote nahi. Ohuapi tahide mari mari onaporaha aja dsotodecca mamaride ccajonajarina deni tojajari. Najarina Dio Corime tibodidenidsa madihijine tiadenidsa inanaridsahitohui. Pohuapa pohuadsa toquejena-jarajaridenipa jororoni jiquejeranihuaji hua idsimabaqquihijine pajirajari. Ohuapi ajimani ojani. Pina pocca medsessa onanijinepi opajira-jerani. Pohua amoricca sadaria diccade naqui opajira-jerani −najari Huano. ");
INSERT INTO cul_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","—Jehe, ccajonabote najaripa madija icattejidsa-baqquihijine. Pina madija aroso jidsadsa trigo huire tahijine qquero quissa, qquero quissa, qquero quissa inamacossajarissa nahitohui. Trigo etero, eppe, ede najaripa jojodedsa toccadsapa noccona ecahuajari pocca odsahuaji. Naraha trigo etero, eppe, ede najaripa diji tahijine bobottahuaji hua idsimahitohui. Najaria aja Diodsa iboraqquiri najarajaridenipa jororoni jiquejeranihuaji hua idsimabaqquihitohui. Najaro jororonipi ohuihuira tani −najari Huano. ");
INSERT INTO cul_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jehe, Huanopa madija Diotohui bodideni huatoma-manahissa tahijine mari icanabaqquija najonapohui najari. Poccadeni imasiri nebomanahijine mari mari ihicanabaqqui najari. Pohuadeni bodi acco acco ihicamabaqqui najari. Pocca marinaja ajima najonajaro: —Ia Idinide ccajonabote nahi. Diocca cacahuehecca ima bicani tojabote nani −nanaridsa najari. ");
INSERT INTO cul_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Huanopa tamine Herode naco pocca imasiri nebohuijine mari mari ihicana najari. Herodecca imapi tabaccora tajaro. Pohua imecote Feripecca amoneje onini Herodia idijidsadsa pocca amoneje tojajaro. Nadsapa Herodecca ima bica tejeradsa Huanopa Herode mittahijine pohuadsa huati huati tataja naraha Herode pocca imadsa dissera tajari. ");
INSERT INTO cul_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pohuapa imasiri sse tapoja naraha ima denima tabaccora tanicca inanajaro. Najaria Huano toponi cocoro todsimadsa coro idsimajaripaja. ");
INSERT INTO cul_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ajijaro imapi Huano coro todsima-jaraccadsa madija topa idsanaridsa-baqquipodsapa Jeso naco topa idsanajari. Nahidsa Jeso Diodsa huatide tojadsapa meme naqui tohuaba najaro. ");
INSERT INTO cul_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nahidsapa Dio Corime ccaronajari. Ahuato taha pina midsorissa naha Jesohuaji ccaronajari. Bacco naronadsapa memehuaji atti mittaronajari: —Tiapi occa ejedeni. Tiadsa ohuati huana tajaro. Ticca ima bica tajarojine ohuatidsejaro −najari Dio. ");
INSERT INTO cul_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesocca huajano 30 nadsana madija maride tojaridsapojari. Nahihuajicca madija pohua tossonahi tahimari ssamoqquiri nadsapa pohuadsa: Dsodsecca ejedeni, quiquinanajari. Nadsama Dsodsecca abipa Eri, ");
INSERT INTO cul_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ericca abipa Matata, Matatacca abipa Rebi, Rebicca abipa Meriqui, Meriquicca abipa Janai, Janaicca abipa Jose, ");
INSERT INTO cul_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josecca abipa Matatia, Matatiacca abipa Amosi, Amosicca abipa Nahomo, Nahomocca abipa Esri, Esricca abipa Nacai, ");
INSERT INTO cul_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nacaicca abipa Mahata, Mahatacca abipa Matatia, Matatiacca abipa Semehi, Semehicca abipa Joseca, Josecacca abipa Joida, ");
INSERT INTO cul_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joidacca abipa Joana, Joanacca abipa Resa, Resacca abipa Sorobabeo, Sorobabeocca abipa Saratieo, Saratieocca abipa Neri, ");
INSERT INTO cul_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nericca abipa Meriqui, Meriquicca abipa Adi, Adicca abipa Cosama, Cosamacca abipa Eromodama, Eromodamacca abipa Eri, ");
INSERT INTO cul_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ericca abipa Josohue, Josohuecca abipa Eriesa, Eriesacca abipa Jorimi, Jorimicca abipa Matata, ");
INSERT INTO cul_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatacca abipa Rebi, Rebicca abipa Simeo, Simeocca abipa Joda, Jodacca abipa Jose, Josecca abipa Jonao, Jonaocca abipa Eriaquio, ");
INSERT INTO cul_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriaquiocca abipa Merea, Mereacca abipa Mena, Menacca abipa Matata, Matatacca abipa Natana, ");
INSERT INTO cul_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanacca abipa Dabi, Dabicca abipa Dsesse-Isahi, Dsessecca abipa Obede, Obedecca abipa Bohodsi, Bohodsicca abipa Sera, Seracca abipa Nahasao, ");
INSERT INTO cul_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasaocca abipa Aminadabe, Aminadabecca abipa Adami, Adamicca abipa Arani, Aranicca abipa Esero, Eserocca abipa Pare, Parecca abipa Joda, ");
INSERT INTO cul_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jodacca abipa Jacobo, Jacobocca abipa Isahaca, Isahacacca abipa Abarahao, Abarahaocca abipa Tera, Teracca abipa Nacoro, ");
INSERT INTO cul_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorocca abipa Seroco, Serococca abipa Racao, Racaocca abipa Pereque, Perequecca abipa Ebere, Eberecca abipa Sera, ");
INSERT INTO cul_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Seracca abipa Cainana, Cainanacca abipa Arapacade, Arapacadecca abipa Seme, Semecca abipa Nohue, Nohuecca abipa Rameque, ");
INSERT INTO cul_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ramequecca abipa Matosare, Matosarecca abipa Enoco, Enococca abipa Jarede, Jaredecca abipa Maharareo, Maharareocca abipa Caino, ");
INSERT INTO cul_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainocca abipa Enoso, Enosocca abipa Sete, Setecca abipa Adana, Adanacca abipa Dio. ");
INSERT INTO cul_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Huano Jeso topa idsanaha jicadsapa Jeso bodidsa Dio Corime tojahissa tajari. Hueni Jordaohuaji qquemoranidsapa Dio Corime Jeso iaccajari, dsama huamoni ssono caji, siba caji tanihuaji madihijine. ");
INSERT INTO cul_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nahihuaji bacco tadsapa huada 40 naha madijari. Nahidsa naco imasiri totonanade Satanapa Jeso nattome inajari. Pohuapa Jeso imasiri inananijine dissera tajari. Nadsapa Jeso jiperahi huadari 40 naha madidsapa pemihissa tajari. ");
INSERT INTO cul_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nadsapa Satana Jesodsa huati tajari: —Dio Bedi tijadsapi, jari, tijipanijine ajijaro siba dsamatapa tojanijine huati tinaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Naraha manaco Jeso Satanadsa huati tajari: —Dio Atti dsodo nanidsapi ajima najaro: “Dsamatapadsara imadini ojari-jerani” −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nahi dsotode imasiri totonanade Satanapa ssono imeni huaji tani tetepihuaji Jeso iaqquemoradsapa dsama huapima pohuadsa ahuato inanaridsajaro. Satanapa amadsati Jeso dsama huapima dsopi icanaridsajari. ");
INSERT INTO cul_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Nadsapa Satana Jesodsa huati tajari: —¡Qqui taneje! Ajijaro dsama huapimapi tiadsa da onanijine. Tiana najaro dsama huapimacca dosse dosse tanijine. Najaro huapimacca biquehe naqui tiadsa onananijine. Ajijaro dsama huapimapi occa tojajarode. Nema nadsapi ohua jipa onajarodsa da onanijine bica tani. ");
INSERT INTO cul_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jehe, tipitodsa tittadsa ohuadsa tetidsedsa: “Occa tamine” taji. Ohuadsa nema tadsapi ajijaro huapimapi ticca tojanijine, onajaro −najari Satana atti. ");
INSERT INTO cul_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Naraha manaco Jeso Satanadsa huati tajari: —Dio Atti dsodo nanidsapi ajima najaro: “Ia Medsede Dio Pohuadsara tetidsemanani ojari dsanapoji. Pohua Attidsara iboraqquiri tiquinaji” nani Dio Attipi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nahi dsotodepa Satana Jeso odsa panani Jerosarehuaji iaccajari. Nanicca Diodsa dada toqquima tetepihuaji inanajari. Nahidsa Satana Jesodsa huati tapomajari: —Jari, tiapi Dio Bedi tijadsapi joppa tinaronaneje, namihuaji tissona-jeranitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","—Dio Atti dsodo nanidsapi ajima najaro: “Diopa pocca dodosse tabaqquidsa huati tahitohui, tia ecahuamananijine. ");
INSERT INTO cul_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Pohuadeni bijidsa tia dama ijidsamanadsapi temori naqui sibadsa cabiquera-jeranitohui” nani Dio Atti dsodo nanipi −najari Satana Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Naraha manaco Jeso huati tapomajari: —Jehe, Dio Atti dsodo nani nema naraha Pohua Atti dsodo nani onihipi ajima najaro: “Ia Medsede ticca Dio nattome tajarajo. Tettidsa: ‘Dio ohuacatamana’ tejeraji” nani Dio Attipi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ima onihidsa ima onihidsa Satana Jeso icamaidsaridsaraha Jesopa Diodsa ibora tahissa tadsapa imasiri inaneje cama-jerajaro. Nadsapa Satana maidsehe onihi bodi huatoma-jaradsapa toccanijari. Toccaniraha dsotode Jeso icamaidsapomahijine madijari. ");
INSERT INTO cul_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesopa dsama arobeni onini Carireahuaji Dio Corimecca dacorehema ccanijari. Nadsapa nahihuajicca madija huapima Jeso tahimari huati naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Odsa onihi onihi naridsanihuaji ccaridsadsapa poccadeni Dio Atti mamarihuaji mari mari ihicanaridsabaqqui najari. Madija huapima attidenipa: —Jehe, Jesopa bica tahi −nanaridsamana najari. ");
INSERT INTO cul_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesopa pohua napihi odsa panani Nasaretihuaji ccanijari. Nahidsa madinidsapa jassinajacca huada bacco tadsa jodiodenicca Dio Atti mamarihuaji toqquedsimajari. Pohuapa odsa huapimadsa nama nanaridsa najari. Nadsapa nahidsa queriqquimanadsapa pohuana totehemajari, Dio Atti hua inanijine. ");
INSERT INTO cul_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nahicca Dio Atti mamari cacahuadena pohuadsa Dio Atti dsodo nani da inajaro. Jeso najaro papeo pico naqquini tappa-ppa inadsa Dio Atti cacomerabote Isahiacca dsodoniji bacco inajaro. Najaroa Cristo-Mesia madija Idinide ccajonahitohui quiquinanajari tahimaripa ajijaropaji: ");
INSERT INTO cul_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—Ia Medsede Dio, Pohua Corime ohuadsa tojadsapa pocca dacorehe ocajijaro. Diopa ohua tocattejidsajari, madija tohuati nahanaqquiri najaridenidsa ima bicani icassiejeranijinecca huati huati onaridsadsapi ima mimittamana nahijine. Nadsapa pohuadeni bodidenipa: “Occa imasiri ohuadsa ocassera tani” quinadsapa onabicabaqquihijine, onajaro. Dio ohua cadossedsapa aja madija cahacossamanajaridenipa oneqquenabaqquihitohui. Aja imasiri jinede Satanajine madijapa pina cahacossamanajarissa quinaraha poccadeni imasiri epeje onanadsapi pina ojine jahininejarissa nahitohui. Aja madija noccodeni siri naco noccodeni ssire onanabaqquihijine. Aja madija dsidsinidsa madiridsamanajarideni naco imasiri jinede Satanacca maidsanijidsa jehe quinaporaha ossiejene pohuadenidsa bacco tadsapi pohuadeni bodideni ssire onanabaqquidsa ohuadsana jehe quinahijine, onajaro. Madija nanajidso toquejenajarideni naco odinibaqquihitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Diopa ohua cadossedsa huati onaridsajaro. Jidapapi madijadsa ia Medsede Diocca ima bicani najorajaro. Madija tocassiejerahijinepa najorani −nani Isahiacca dsodoniji Jeso hua inajaro. ");
INSERT INTO cul_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nadsapa Jeso papeo pico naqquini pico inanidsapi Dio Atti mamari cacahuadedsa da inanijaro. Nadsapa Jeso pohuadeni baccohuaji huittarijari. Nadsapa jassi dsajarideni huapima Jeso icattaqquimanadsapa pohuadeni mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nadsapa Jeso huati tajari: —Dio Atti dsodo nani aji hua onajarocca ima Cristo-Mesia ccajonahitohui nanaja najaripa jidapana tiadenidsa madijaripaja −najari Jeso pohua tahimari huati huati tadsa. ");
INSERT INTO cul_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nadsapa madija huapima attidenipa: —A, pohua attipa bica taha −quinajari. —Naraha pohuapa Dsodse bedia −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Naraha Jeso huati tapomajari: —Maittaccadsama icca ididenipa ajama quiquinanade: “Toponi totonanomide tijadsapi tia tinanomiji” quiquinanajari. Nadsama tiadeni naqui ocanahatori canani qqui tiquinanijine tohuini tiquinadsapi ohuadsa tettideni nema tiquinanitidija −najari. —Aji odsa panani Capernaohuaji ocanahatori canani ima timittamanadsapi tettideni: “Aji ticca dsamadsa naqui najarossa tinanaji” tiquinajaro nitide −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nadsapa denima huati dsanapojari: —Pajissara tiadenidsa huati onajaro: Maittaccadsamacca imapi ajima najonajaro: Dio Atti cacomerabote pocca dsamadsa bacco nanidsa naco pocca madijapa pohua attidsa jiperaqquiri najari. Pina jidapana tiadeni naqui ohua aji occa dsamahuaji bacco onanijaroraha ohuadsa pajissa tiquinejerani. ");
INSERT INTO cul_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nadsama pajissara tiadenidsa huati onajaro: Maittaccadsama naco icca idideni Isaraeri potemahidenipa Diodsa jehe quinahissa tajaradsa Diopa dsama onihicca madijadsana canahatori canajari. Aja Dio Atti cacomerabote Eria madiccadsapa huajano huatimade tojari abadsico 6 canaha passo qquejerajaro. Nadsapi madija huapimadsa pemi tojaridsajaro. Ia Isaraeri potemahi jodiodeni iquejenajaro icca dsamadsa naqui amoneje maqquirinideni jicamanaja najonapohui najarodeni huapi tajaro. ");
INSERT INTO cul_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Naraha najarodeni huapimapi Eria acco icamabaqquinijine Dio dosse inajarajari. Dsama onihihuajina Dio Eria dosse inajari. Odsa pamema najaro oninipi Sarepetahuajina toccajari. Sarepetapi odsa panani Sido huajira tanidsa odsa tojajaro. Nanicca amoneje jodio jerajaro maqqui dsoqquejarina acco icamajaro. ");
INSERT INTO cul_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ajijaro ima naqui nahatoqquiri tiquinani. Maittaccadsama Dio Atti cacomerabote Eriseo madipodsa naco ia Isaraeri potemahi jodiodeni iquejenajaro icca dsamadsa dsamacoma onini leprajine huapideni jadsimarojarideni huapi tajari. Naraha ojaria jodio jarajari oni Nahamapa dsama Siriahuajicca madijaraha Eriseodsa ccajonadsapa pohuana tonomihi ojarijari −najari Jeso pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Naraha jodiodenipa aja Dio Atti mamaridsa jassi tarijari huapima Jesodsa huadimanajari. Jesocca marinajapi: —Dsama onihicca madija jodio quejena-jararaha Diopa najarideni naco acco icamabaqquijari −nadsapa huadimanajari. ");
INSERT INTO cul_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nadsapa najarideni huapima Jesodsa huadimanadsapa mohua ininemanadsa iaqquenamanajari. Poccadeni odsa panani Nasareti denihuaji iaqqueqquima-manajari. Nasaretipi ssonodsa odsa tojajaro. Nani ssono memedsaranihuaji iaqquemoramanajari, coro inaronamanahijine. ");
INSERT INTO cul_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Naraha Jesopa pohuadeni jai tojahi nocconidsa tohuanajari. Cojojohuaji bacco toquinadsapa: —Jeso coro inaronana −quinaraha madija huapi taraha dsodonijari Jeso. Dsodonidsapa toccanijari. ");
INSERT INTO cul_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nadsapa Jeso Capernaohuaji toqquedsippajari. Capernaopi dsama Carireacca odsa panani. Nanidsapi Dio Atti mamari cajimanajari. Nanihuaji poccadeni jassinajacca huadadsa Jesopa madija mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nadsapa pocca marinaja mittamanadsapa: —A, pocca marinaja bica taha −quinajari. Pohuapa atti caji tajarijine nama quinajari. ");
INSERT INTO cul_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nadsapa Dio Atti mamarihuaji Jeso mari icanabaqquiraha nahidsapa madija bodidsa Satanacca dodosse tocorime cajijari huittarijari. ");
INSERT INTO cul_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nadsapa Jeso qqui tadsapa pohua bodiccajine jadsirema atti atti najari: —¡Jaho, Nasaretihuajicca Jeso! ¿Nejecotohuira ticcajonajaro? ¿Icca ima tinajicanijine ticcajonajaroqui? Ticca ima nahato onani. Tiapi Diocca Ejedeni Bicabote tijani −najari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Naraha joma nahijine Jeso atti dacoradsa huati tajari: —¡Epeje! ¡Didi taji! ¡Najari madijadsa tiqquenaji! −najari. Nanaja tocorimejine madija pina cco inacossajarissa najari. Aja jassi tariridsajarideni baccohuaji tohuedimajari. Nahidsa tohuedimadsapa pohua bodicca qquenajari. Naraha pohua inajidso-jaradsapa inabiquera-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nadsapa qqui toquinajaridenia huajo caniredsapa pohuadenira huati tocanirere canajari: —¿Nejecoma najaro marinaja cajijari? Ajajaripa dacorehe caji, atti caji najaria. Madija bodicca tocorime pohuajine qquenaha −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nadsapa Jeso tahimari huati naridsamanadsapa nahi pohuadeni inoricca huajirema nahicca madiridsamanajarideni naco Jeso tahimari mittaridsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nadsapa Jeso aja jodiodenicca Dio Atti mamarihuaji qquenadsa toccajari, Ssinocca odsahuaji toqquedsimajari. Nanidsapi Ssino massodini coma tajaro, huapini ppocorajaro. Nadsapa Jesodsa huati toquinajari: —Poni tinanomiji −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nadsapa Jeso poni icattoma nadsa aji huapini ppocorajarodsa: —Epeje taji −najari. Naneje huapini tonahuihui najaro. Nadsapi amadsati tonomidsa totehemadsapi aja Jeso pocca mamari tabaqqui tedseje inajipabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nadsapa maji tonahuidsa aja comaqquiri najarideni cacahuadedeni Jesohuaji eccajonabaqquijari. Poccadeni dsamacoma comani onihi onihi naridsajaro cajimanadsa Jesohuaji eccajonabaqquijari. Nadsapa comaqquiri najarideni bara inaridsabaqquijari. Ohuaha bara inebo, ohuaha bara inebo naridsadsapa tocanomireridsajari. ");
INSERT INTO cul_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Madija bodidenidsa Satanacca dodosse tocorime cajimanajarideni naco Jeso pohuadenidsa huati tadsapa bodidenicca jahininejari. Tocorimedenia Jesopa madija Idinide Cristo-Mesia pohuadsa nahatoqquiri nadsapa johua johua quinajari: —¡Tiapi Dio Bedi tijani! −quinaraha Jesopa pohua tahimari ecomeramananijine jipera tadsapa: —¡Epeje tiquinaji! −nadsa didi inanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ssiajajonadsa Jesopa nahi odsa pananidsa toqquenadsapa madija madide nohuerahihuaji toccajari. Nadsapa madija huapima pohuatohui qqui naridsamanajari. Jeso bacco quinadsapa: —Aji iadsa timadiccaji, odsa onihihuaji tiqquejeraji −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Naraha pohua attipa: —Ohuapi odsa onihihuaji naqui Diocca cacahuehecca ima bicani mari mari onaridsanijine, onajaro. Nema onanijine occa Abipa ohua cadossejari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aja pohuapa Isaraeridenicca dsama Jodeahuaji Dio Atti mamari onihi onihi naridsanihuaji mari mari nanaridsa najari. ");
INSERT INTO cul_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jesopa Carireahuaji Dio Atti maride ccaridsadsapa Carireacca coridsa onini onihi Jenesare inidihuaji toqquedsippajari. Nahidsapa madija huapi taha jahijonajari, Dio Atti mittamanahijine. Nahidsana Jeso quebericossabote najari. ");
INSERT INTO cul_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nadsapa Jeso qqui taneje canoa capamehe ijirani ssiquidsa cacoda najaro. Canoa jinededenipa coridsa inididsa tajapa ssahuade toquejenajari. ");
INSERT INTO cul_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Canoa cajariepi Ssinocca. Najarodsa Jeso toqquedsadsa jinededsa huati tajari: —Ssino, madija domo huahi huajiji canadsa mari ocanabaqquihijine ohua dso ticanacossaccaji −najari. Nadsapa Jeso canoadsa huittidsadsapa madija huapima mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nadsapa mari icanabaqquia jicadsapa Ssinodsa huati tajari: —Ticca canoa ajicca coridsa nocconi dsaja tanihuaji ori ticanamanadsa ticcadeni tajapa coro ticadsanamanaji, aba ticajimananijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Nadsapa Ssino Jesodsa huati tajari: —Ia Maride, iapi dsome inassiajaraha aba icaji nejerani −najari. —Naraha ia ticadossebaqquidsapi icca tajapa coro icadsippana −najari Ssino. ");
INSERT INTO cul_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nadsapa coridsa nocconihuaji ori toquinadsa tajapa coro icadsanamanajaro. Joca icanimoramanadsapi aba ijijari. Ccanaja tajarijine tajapapi ojarie tajo tajo teri najaro. ");
INSERT INTO cul_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nadsapa pohuadeni tesse canoa onihiccatohui dsepedeni huadsa huadsa quinajari, —Ibiji acco tocamabaqquina −quinadsa. Bacco quinadsa joca icadsamanadsapa aba huemaja najari. Canoa capamaraha ijijari. Najari aba qquenejepa je tocanamanabote najari. ");
INSERT INTO cul_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nadsapa Ssino-Pedro najari aba huemahi qqui tadsapa huajo najari. Nadsapa Ssino Jeso baccohuaji pohua pitodsa huittidsa nadsa huati tajari: —¡Ia Medsede, aji ohuadsapi huaji tinaji! Ohuapi imasiri sse onani −najari. ");
INSERT INTO cul_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aja aba huemahi qqui toquinadsa Ssinopa cappinajari, pohua tessedeni naco cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Aja Ssino pohua tesse Sebedeo bedideni Satiaco, Huano quinajarideni naco: —A ¿nejecotohui aba huemajari? −quinajari. Huapima cappinamanaraha Jesopa Ssinodsa huati tajari: —Ticappina tejeraji. Jidapapi madija maride tijana. Tahidepi aba tiadsa tojahijine tidsepe ihiji naccadija naraha jidapapi madija Diodsa toquejenahijine tidsepe ijidsanaponitohui −najari Jeso Ssinodsa. ");
INSERT INTO cul_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nadsapa ori nanimanajari. Coridsa inidi bacco nanimanadsa canoapi ssoqueque icadsanamanajaro. Nadsapa Jesodsa jai tojahijinepa poccadeni canoa, poccadeni tajapa, poccadeni aba, poccadeni madiejine huapima naqui inebomanadsa Jesodsana jai tojajari. ");
INSERT INTO cul_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesopa dsama arobeni Carirea odsa panani onihidsa onihidsa mari mari naridsadsapa madija dsamacoma onini leprajine huapi jadsimarohi pohuadsa bacco najonajari. Jeso qqui tadsapa pohua bodia: —Jesona deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta nadsa panopi namidsana bacco tajaro. Nadsapa Jesodsa huati tajari: —Ohua Medsede, ohuapi bica onejeraraha tia jipa tinadsapi ohua tinanabicanijine nahato tinani −najari. ");
INSERT INTO cul_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nadsapa Jeso pohua dsepedsa bara inadsapa: —Jehe, jipa onani. Tibicaji −najari. Nanaja amadsati pohua huapicca tomossissi nadsapa tobicajari. ");
INSERT INTO cul_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nadsapa Jeso pohuadsa huati tajari: —Aji tibicanicca ima madijadenidsa huati taridsa tejerana. Naraha Diodsa dada toqquimahuajina ticcaji, onajaro. Nanidsa tiqquedsimadsapi dada toqquimade ojariadsara tepi tobicani tia nohue tinaji. Nadsapi Diodsa ticca ima bica tejeranicca toppineradsapi ticca daniji Diodsa tojanijine ohuaha ohuaha naha pina edede, ppiriri, oqui najari da da tidsimana. Pina Moisesicca marinajadsa iboraqquiri inajarossa tinanaji, onajaro. Nadsapi huapimadsa ticca ima toppinerani ahuato tadsapi: “Pajissa tibicajaro” quinahijine −najari Jeso pohuajine huapi tobicajaridsa. ");
INSERT INTO cul_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Naraha Jeso pohua tahimaripi ssaja taridsajaro. Najarojine madija huapima Jeso pohua atti mittade jahijonana canajari, madija tocanomirehijine naco jahijonana canajari. ");
INSERT INTO cul_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Naraha Jesopa pohua motta madija nohuerahihuaji totocca najari, Diodsa huati huati tahijine. ");
INSERT INTO cul_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Dsotodepa Jeso madija maride tojadsapa jodiodeni mota marinaja pariseodsa jehe quinajarideni, jodiodenicca marinaja maridedeni naco mittade jassi tariridsajari. Najaridenipa dsama arobeni Carireahuajicca odsa huapimacca jahijonaridsajari, dsama arobeni Jodeahuajicca odsa huapimacca naco jahijonaridsajari, odsa panani Jerosarecca naco jahijonaridsajari. Nadsama Jeso maride tojadsa, madija inanomibaqquihijine naqui Diocca dacorehepi Jesojine ahuato tajaro. ");
INSERT INTO cul_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nadsapa madija ide tone biqueradsa isso ssomi tojahipa pohua taborodsa poridsa pohua tessedeni dsojo icanajonamanajari. —Jeso baccohuaji porihijine odsa bodihuaji dsojo icadsimana −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Naraha madija siba tadsapa dsojo icadsimamanahijine tojera tadsapi odsa tetepihuajina dsojo icanamaromanajari. Odsa tetepini arobenihuaji icatabojidsamanadsapa madija ssomi tojahi pohua taborodsa poridsa tappa icanaronamanajari. Madija domo huahuajanihi nocconidsa da icanaronamanadsapa Jeso pohua baccohuaji bacco tocanaronajari. ");
INSERT INTO cul_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jeso pohuatohui dissessera tahi qqui tadsapa pohua bodidsa nahato tajari: —Pajissa, Jesopa madija inanomihijine nahato tahi −quinahi Jeso pohuadsa ahuato tadsapi coma tajaridsa huati tajari: —Otesse, aji imasiri tinanajaro huapimapi onanamossini. Jidapana ticca ima Diodsa tobicani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jeso atti nama nadsapa jodiodenicca marinaja maridedeni, pariseodeni tedseje bodideni huatoma-manadsapa: —Apaja, Jesopa “Imasiri onanamossina” naha. Pohua attipa: “Ohuapi pina Dio ojani” nanaja najarissa naha. ¡Jesocca imapi bica tejerani pina Dio itamassojarissa nahi! Naraha Dio Pohuana ojarijari imasiri inanamossinijine −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Naraha Jesopa pohuadeni bodicca ima nahato tadsapa pohuadenidsa huati tajari: —¿Nejecotohui tibodidenidsa nema tiquinajaro? −najari. ");
INSERT INTO cul_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—Jari, tibodideni huatoma-manaji ¿nejecoma najaro imana tiadenidsa denima najora tani? Aja madija coma tajaricca imasiri onanamossini ¿najora taqui? Coma tajari onanabicahina ¿denima najora tajarorane? ");
INSERT INTO cul_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Naraha aji ohua Madija Bedi ojajaropi madijacca imasiri onanamossinijine Diocca dacorehe ocajini nahatoqquiri tiquinanijinepi, aji namidsa naqui ohuatti ocajini nahatoqquiri tiquinanijine coma tajaridsa huati onana −najari Jeso. Nadsapa madija ssomi tojahidsa huati tajari: —Tiadsa huati onadsa: ¡Titehemaji! ¡Titaboro tididsa ticca odsahuaji ticcaniji! −najari. ");
INSERT INTO cul_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nadsapa amadsati totehemadsa... huapima cattomama canaraha pohua taboro idi nadsa pocca odsahuaji toccanijari. Nadsapa Diodsa tohuatidsenidsa jiri jiri tanijari: —¡Diopa bica tahi, bica tahi! −tanijari. ");
INSERT INTO cul_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nadsapa madija huapima cappinamanaraha huatidsemanadsapa: —A, ¡Diojine bica tani! −quinajari. —Aji jidapana qqui inajaropi bica tani −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nahi dsotodepa Jeso jahui toccadsa romanodenicca taminecca dosseniji dsiniro nanaccade qqui tajari. Pohua onipa Rebi. (Pohua oni ohuahapa Mateo.) Nahi romanodenidsa dsiniro da tanijine ihinaccamana nanihuajicca odsa bedeni bodidsa huittidsadsapa Jeso pohuadsa huati tajari: —Jina, ohuadsa ticcaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nadsapa Rebi pocca tarabaidsa inebo, Jesodsana toccajari. ");
INSERT INTO cul_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dsotodepa Rebi Jesodsa huatidsedsapa: —Ijipaqquina −najari. Nadsapa pocca odsahuaji pohua tessedeni Jeso tedseje jipaqquimanahijine dsamatapa huemahi najorajari. Queriqquimanadsa pohua tesse romanodenicca taminecca dosseniji dsiniro nanaccadedeni, pohua tessedeni tedseje jipaqquimanajari. Nahidsa madija ohuahadeni naco Jeso pocca mamari tabaqquima jipamanajari. ");
INSERT INTO cul_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Naraha nahidsa naco jodiodenicca marinaja pariseodsa jehe quinajarideni, jodiodenicca marinaja maridedeni tedsejepa madija imasiri cajimanajarideni tedseje Jesodeni jipamanahi qqui toquinajari. Najaro imadsa jiperaqquiri nadsapa Jesocca mamari tabaqquidsa atti atti quinajari: —A ¿nejecotohui tiadenipi romanodenicca taminecca dosseniji dsiniro nanaccadedeni tedseje, imasiri cajimanajarideni tedseje tijipamanajaro? −quinajari. (Aja madija nama najarideni tedsejepa jipade oppina tani quiquinanajari.) ");
INSERT INTO cul_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nadsapa Jeso pohuadenidsa huati tajari: —Ponima pohuadenidsa ojipa-jerajaro. Pohuama otohui huahua quina-jarahi. Nomiqquiri najaridenipa toponi totonanomide tohuini quina-jararaha comaqquiri najaridenina toponi totonanomide tohuini quiquinanajari −najari. —Ohuapi pina toponi totonanomidessa onajaro. Madijadenicca ima Diodsa tobicanijine pohuadeni accode occajonajarode. ");
INSERT INTO cul_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Naraha madijapa: “Iapi bicaqquiri inani” quiquinanajaridenicca ima onanabicanijine occajona-jerajaro. Imasiri cajimanajaridenicca ima onanabicanijinena occajonajaro. Pohuadeni bodideni acco ocamabaqquidsa: “Imasiri inebona” quinahijine, onajaro. Pohuadeni bodi cacajiqquimeradsapa Diocca ima dsatidsa toquejenahijine, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Naraha nahicca madijapa Jesodsa huati toquinajari: —Huanocca mamari tabaqquipa jipehe nebocossamanadsapa Diodsara huati huati dsadsanapomana najari. Jodiodeni marinaja pariseodsa jehe quinajaridenicca mamari tabaqqui naco aja Huanocca mamari tabaqquissa quiquinanajari. Naraha ¿nejecotohui ticca mamari tabaqquia jijipaqquimana najari? −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Naraha manaco Jeso pohua cacomerajari: —Aja dsabisso amoneje cajibote najari pocca ejete najoradsa pohua tessedenitohui huahua nadsapa huapima pohuadsa queriqquidsapa najaridenidsa: “Jipehepi tinebocossamanaccaji” ¿tiquinapadseje? Nema tiquinejeranitohui. Pohua tessedenipa pohuadsa huatidsemanadsa jipaqquimanahitohui. Naraha huada onihiccadsa dsabisso cajibote najari iaccamanadsapa pohua tessedeni jipehe nebocossamanahitohui −najari Jeso. (Nadsama najaro imapi Jeso aja namihuaji madidsapa pohua tessedeni pohuadsa huatidsemanadsa pohua tedseje jijipaqquimana najaripaja. Naraha dsotode pohua inanadsoqque-manadsapa pohua tessedenipa jipehe nebocossa-manaccahitohui, najaripaja.) ");
INSERT INTO cul_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nadsapa ajijaro namidsa imadinicca ima onihi Jeso pohuadenidsa huati tajari: —Icca etero dsatipi etero jadanidsa podsacossanijinepi beri beri inejerajaro. Icca etero nema inanadsapi icca etero dsati inatabaccorajaro. Najaro etero dsati bobini beri tojidsani mota naqui etero jadanidsa podsacossadsapi najarossa nejerajaro. Jidsa tani. Etero jadanipi tobiquemaninira tani −najari Jeso. (Nadsama aji Jesocca marinajapi pina jodiodenicca marinajassa nejerani. Jeso pocca marinajapi dsati.) ");
INSERT INTO cul_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Ima onihi naqui ajima najaro: Uva ppejene nahatodsatipa bani etero ssequi nahi jadahidsa sso sso ihidsamana najarajari. Uva ppejene nahatodsatipa bani etero jadahidsa sso todsadsa ssicatadsapa jocaquera tajarijine sseo tahi caji tahi. Sseo tadsapa uva ppejene sso taha jica tahi, dsamine naco totabaccoradsapa coro quina tahi. ");
INSERT INTO cul_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nadsama uva ppejene dsatipa bani etero ssequi nahi dsatidsara sso sso totodsa najari −najari Jeso. (Aja pohua atti nama najaripa madija bodi dsati tojadsana Jesocca marinaja dsati ecahuanijine pajirahi, najari.) ");
INSERT INTO cul_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Ima onihi naqui tiadenidsa huati onana: Madija uva ppejene jadahi dse dse quiquinanadsapa pohuadenipa uva ppejene nahatodsati tohui quiquinana-jarajaripaja. “Uva ppejene jadahipa iadsa bica tajari, jidsera tahi” quiquinanajari −najari Jeso. (Nadsama najaro imapi madija poccadeni ima jadani naqui najarossa najaro. Poccadeni ima jadanidsa huatideni huanaqquiri nadsapa Jesocca ima dsatidsa: —Najarona denima iadsa bica tani −quina-jarajaripaja. Poccadeni ima jadani nebomanahijinepa jiperaqquiri najaripaja.) ");
INSERT INTO cul_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Naraha jassinajacca huadadsa Jesopa pocca mamari tabaqqui tedseje toccajari. Huidsaja nocconi motta jahui toqqueqquimani jai tojeqquimajari. Nahihuajipa aroso jidsadsa trigo bono jadahi caji tajari. Jesocca mamari tabaqqui nahi jai tojeqquimadsapa pore dsanapomanadsa pohuadeni dsepedsa siqui apa, siqui apa, siqui apa dsanapomanajari. ");
INSERT INTO cul_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Naraha jodiodeni marinaja pariseodsa jehe quinajarideni qqui toquinadsapa pohuadenidsa bica tejeradsa huati icanabaqquimanajari: —¿Nejecotohui jassinajacca huadaraha najaro huidsajacca bono pore tiquinajari? Jassinajacca huadadsapi idsepe ijie oppina taraha −quinajari. Naraha bonopa pamaha pore pore ijidsamaneri najariraha pariseodeni pohuama pohuadenidsa ima inahanamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Naraha Jeso pohuadenidsa huati tajari: —¿Naraha tiadenipi aji Dio Atti maittaccadsama dsodo naniccadsa Dabicca ima hua hua titiquina naraha tetideni ajimamanajarorane? Najaro imapi Dabipa pohua tessedeni tedseje pemimanadsapa pan Diodsa da tahicca oppina taraha jipamanajari. ");
INSERT INTO cul_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Diodsa dada toqquimahuaji toqquedsimadsa cacahuadedsa pan tohui huati tajari. Pan ohuaha nohueradsa Diodsa da tahiccaraha Dabi jipajari, pohua tessedenidsa naco da inabaqquidsa jipamanajari. Najari pan Diodsa da tahipa dada toqquima cacahuadedenira jijipamana najariraha Dabideni pemimanadsa jipamanajari oppinera tahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Naraha Jesopa denima pohuadenidsa huati tajari: —Madija Bedi ojajaroa jassinajacca huadapi ohuana jinede ojani. Jassinajacca ima cacahuadepi ohuana paji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jassinajacca huada onihidsa naqui Jesopa Dio Atti mamarihuaji toqquedsimadsapa mari icanabaqquipomajari. Naraha nahidsapa madija dsepe nahatonicca ccara tocajani huittarijari. ");
INSERT INTO cul_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Naraha jodiodenicca marinaja maridedeni, marinaja pariseodsa jehe quinajarideni tedseje Jeso inoccodsamanajari. Jesopa jassinajacca huadadsa madija inanomibaqquidsapa pohuadenidsa pina jassinajacca huada jerajarodsa dsepe ijijarissa najari, quinajari. Pohuadeni bodipa: —Jidapana jassinajacca huadadsa dsepe siri inanomidsapa Jesodsa ima inahananijine −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Naraha Jeso pohuapa pohuadeni bodi nahato tadsapa madija dsepe siridsa huahua najari: —Titehemadsa ahuaji ticcajonaji −najari. Nadsapa totehemadsa nahihuaji huajari. ");
INSERT INTO cul_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nadsapa Jeso huapimadsa huati tajari: —Tiadenidsa huati onana. Moisesicca marinaja, icca madijacca marinaja naqui nahatoqquiri tiquinadsapi ohuatti tecomeramanaji. Jassinajacca huadadsapi ¿nejecoma najaro ima inananina “Bica tani” tiquinajaro? Jassinajacca huadadsa madija inabicabaqquidsa “Oppina tani” ¿tiquinajaroqui? Madija inajidsobaqquidsana “Bica tajaro” ¿tiquinajarorane? −najari. —Jassinajacca huadadsa naco ijine madija tossiajadsa ¿oppina taqui? “Paja dsoqquerina” ¿tiquinajarorane? −najari. ");
INSERT INTO cul_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nadsapa Jeso madija huapima jassi nahuajanijari noccodeni icattabaqqui nadsa dsepe siridsa huati tajari: —Jari, tidsepe ohuahuaji da ticanajonaji −najari. Nadsapa pohua dsepe pohuahuaji da icanadsapi dsepe tocabicajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Naraha jassi nahuajanijarideni motapa pariseodeni. Pohuadenina Jesodsa huadimanajari. Nadsapa pohuadenira imahaha canadsa: —¿Nejecoma inanadsa Jeso inanadsoqquehijine? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nadsapa najari abadsicodsa Jesopa Diodsa huati tahijine ssonohuaji toqquemorajari. Nahidsa dsome Diodsa huati huati taha cassiaja najari. ");
INSERT INTO cul_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cassiajadsapa pocca mamari tabaqquidsa huahua najari. Huapima queriqquimanadsa 12 quinahana icattejidsabaqquijari, pohua huatimade toquejenahijine. Nadsapa Jeso onideni icanacanibaqquijari: —Occa dodosse tabaqqui −najari. ");
INSERT INTO cul_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tahidepa Ssino. Pohua oni Jesojine icanacanidsatipa: Pedro, najari. Pedro ohuaha Adiri. Pohuadeni tesse Satiaco, Huano, Feripe, Batorome quinajari. ");
INSERT INTO cul_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Pohuadeni tesse ohuaha naco Mateo, Tomas, Satiaco quinajari. Satiacopa Arapeo bedi. Pohuadeni tesse ohuaha naco Ssino, pohuadsa: romanodeni momohuade, quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Pohuadeni tesse ohuahapa Joda. Najaripa Satiaco bedi. Jicahiccapa Joda Iscariote. Najaripa Jeso ccaccorade. Najarideni Jeso icattejidsa-baqquijaripa 12 quinaha pohuadsa toquejenajari. ");
INSERT INTO cul_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nadsapa Jeso pocca dodosse tabaqqui 12 quinajarideni tedseje qquedsippaniraha nani deoni huamo tanihuajipa madija huapima Jeso pohuatohui madimanajari. Nahihuaji Jesocca dodosse tabaqqui huapima queriqquimanajari. Nahidsa naco dsama arobeni Jodeacca madija, odsa panani Jerosarecca madija, passo imeni inididsa madimanajarideni, aja odsa panani pamehe Tirocca, Sidohuajicca jahijonana canajari. ");
INSERT INTO cul_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Huapimapa Jeso atti mittamanaja camahijine jahijonajari. Comaqquiri najarideni Jeso inanomibaqquihijine naco jahijonajari. Aja madija bodidenidsa Satanacca dodosse tabaqqui tocorime madidsamanajarideni naco jahijonajari. Pohuadenipa nanajidso toquejenaraha najarideni naco Jesojine tocanomireridsajari. ");
INSERT INTO cul_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Madija comaqquiri najaridenipa: —Jesodsa idsepedsa bara inadsapi icanomirenijine −quinadsa pohuatohui disseraqquiri najari. Aja Jeso pocca dacorehe pohuadenidsa tojadsapi huapima tocanomireridsajari. ");
INSERT INTO cul_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeso pocca dodosse tabaqqui icattabaqqui nadsa huati tajari: —Tiadeni motapi ticappiramanaraha Diotohuira tiquinadsapi Diopa tiadenidsa ima bicani inanajaro. Diocca cacahuehe tiadenidsa tojanitohui. ");
INSERT INTO cul_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—Tiadeni mota naqui jidapana tipemimanaraha Diotohuira tiquinadsapi Diopa tiadenidsa ima bicani inanajaro. Nidsa dsotode Diohuaji tiqueriqquidsapi tipajiramananissa tanitohui. —Tiadeni mota naqui jidapana oji tiquinaraha Diotohuira tiquinadsapi Diopa tiadenidsa ima bicani inanajaro. Nidsa dsotodepi tetidsemaneri nadsa jaja taqquimananitohui. ");
INSERT INTO cul_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—Ohuapi Madija Bedi ojajaroa occa madija tiquejenajarojinepi madija ohuadsa jiperaqquiri najaridenipa pohuama tiadenidsa naco jiperaqquiri nahitohui. Najaro ima tiadenidsa tojadsapi Diopa tiadenidsa ima bicani inanajaro. Madija ohuadsa jiperaqquiri najaridenipa aja tiadenidsa naco: “Iadsa tiquejemamana tejeraji” quinadsapa tiadeni dosse dosse tatanibaqquimana nahitohui. Najaro ima tiadenidsa tojadsapi Diopa tiadenidsa ima bicani inanajaro. Nadsama madija tiadeni totamasso-baqquimanadsa naco Diopa tiadenidsa ima bicani inanajaro. Nadsama tiadenipi ohua onidsa tecanimanajarojine aja ohuadsa jiperaqquiri najaridenipa tiadeni onidsa naco: “Imittana inejerani, tabaccoraqquiri nahi” quiquinanahitohui. Najaro nacasserehe tiadenidsa tojadsa naqui Diopa tiadenidsa ima bicani inanajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ohuadsa jiperaqquiri najarideni biridideni naco maittaccadsama Dio Atti cacomeraqquiri najarideni inajidso-baqquimanaja najonapohui najari. Najarideni potemahi jidapana naco tiadeni tonajidso-baqquimanadsa ¡epeje! Tibodideni ccaracossa tejerana. Pina tetidsemaneri nana, onajaro. Nidsa memehuaji Dio madihihuaji bacco tiquinadsapi Diocca daniji bicabote tiadenidsa tojanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Nadsapa madija domo huajaridsa Jeso denima huati huati tajari: —Tiadeni motapi tidsepedenitaji sseqquiri tiquinajarojine Dio tohui tiquinejerani. Jidapana ajijaro namidsa timadimanadsapi tiadeni tohuini tiquinanicca huapima ticajimanaraha nidsa dsotodepi tiadenidsa nohueranitohui. A, tiadenipi tohuati nahanaqquiri tiquinani. Diopa oppina tanihuaji tiadeni tonanabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Aji tiadeni mota naqui jidapana jijipa, dsamatapa sseqquiri tiquinajarojine Dio tohui tiquinejerani. Naraha nidsa dsotodepi tipemimananitohui. A, tiadeni naqui tohuati nahanaqquiri tiquinani. Diopa oppina tanihuaji tiadeni tonanabaqquihitohui. —Tiadeni mota naqui ajijaro dsamadsa timadimanaccadsapi ponima jai tijaridsadsa tetidsemaneri, jaja tiquineri naridsadsa: “Jehe, bica tani” tataridsamana naraha nidsa dsotodepi ocasserani teridsamanadsa oji tiquinanitohui. A, tiadenipi tohuati nahanaqquiri tiquinani. Diopa oppina tanihuaji tiadeni tonanabaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Nadsama tiadeni mota naqui aji occa imassa tinanamana-jeraraha madija tiadenidsa: “Jehe, ticcadeni ima bica tani. Tiadenidsa etidsejaro” quiquinanadsa tetidsemanaraha tiadenipi tohuati nahanaqquiri tiquinani. Diopa oppina tanihuaji tiadeni tonanabaqquihitohui. Maittaccadsama Dio Atti cacomeraqquiri najarideni madimanapodsa naco Dio Atti mari icanabaqquihissa taraha poccadeni marinajadsa: “Jehe, bica tani” quina-jarajari. Naraha maittaccadsama naco madija ohuahadeni attidenipa: “Ia naqui Dio Atti cacomeraqquiri inani” quiquinanaraha pohuadeni nanamaidsamana najari. Najaridenidsana madija huapima attideni: “Jehe, ticcadeni ima iadsa bica tani” quiquinanajari, maidsehena pohuadenidsa bica tadsa. Jidapana naco tiadenidsa: “Jehe, bicaqquiri tiquinani” quiquinanajari. Najaridenia ajajaripaja jinodideni potemahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Nadsama aji ohuatti timittamanajarodeni tiadenidsa ajima onajaro: Tiadeni huadidedenidsa pina tetideni huanaqquiri nana. Aja tiadenidsa jiperaqquiri najarideni naco pohuadenidsa pina ima bicanira titinanamana nana, nani tijinedeni ima bica tanijine, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aja madija ohuahadeni naco tiadeni totamasso-baqquimanadsa: “Tabaccoraqquiri tiquinani” quiquinanaraha pina tettideni bica tadsa pohuadenidsa huati huati tataridsamana nana, onajaro. Aja madija tiadenidsa tabaccorehe ihinanamana nadsa naco pina Diodsara huati huati titiquina nana, nahi Diona inabicabaqquihijine, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Madija huadidsa tipano idanidsa naco “Ohuaccone manaco odana” tejerana, onajaro. Tiadsa huadi tajaripa pajara tia cahadi, pajara tia cahadi naraha manacopi pohuadsa tedi tejeraji. Nadsama madija ohuahapa ticca etero pamacossajaro qqui tadsa huapicca tohuini inacomadsa: “Ohuadsa da taji” nadsa naco pohuadsa da tinaji. Titetepicca onihi naqui teccocco-jeradsa pohuadsa da tinaji. Nema tiquinadsapi occa marinaja tecahuamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Madija tidsepetaji mitta nadsa naco pohuadsa da tinaji. Tidsepetaji huatirahi ididsa naco huati tidsima tejeraji. ");
INSERT INTO cul_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nadsama tiadenipi madija huapima tiadenidsa ima bicanira inanamananijine tohuini tiquinadsapi madija huapimadsa naqui ima bicanira titinanamana nana, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Tiadenipi madija tiadenidsa huatideni huanaqquiri najaridenidsara tetideni huanaqquiri nani ojari nadsapi ¿Diopa tiadenidsa: “Jehe, bicaqquiri tiquinani” napadsaja? Nohuerahi. Aja madija imasiridsa disseraqquiri najarideni naco pohuadeni tessedsa huatideni huanaqquiri nahi. Naraha pohuadeni tesse jarajaridenidsapa huatideni huaneraqquiri nahi. ");
INSERT INTO cul_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tiadenipi madija tiadeni acco camamanajari-denidsara pohuadeni acco ticamabaqquimanahi ojari nadsapi ¿Diopa tiadenidsa: “Jehe, bicaqquiri tiquinani” napadsaja? Nohuerahi. Aja madija imasiridsa disseraqquiri najarideni naco pohuadeni tessedeni acco icamamana tahi. Naraha madija pohuadenidsa noccodeni jidsaqquiri najaridenidsapa pohuadeni acco camade jiperaqquiri nahi. ");
INSERT INTO cul_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Tiadenidsa madija attipa: “Pohuama ohuadsa da taccajo, nidsa tiadsa da onanihijine” nadsa tibodidenipi: “Jehe, ohuadsa da inanihitohui, nidsa dsotode ocajipomanijine” titiquina nadsapi najaridenidsara da da tiquinani ojari nadsapi ¿Diopa tiadenidsa: “Jehe, bicaqquiri tiquinani” napadsaja? Nohuerahi. Aja madija imasiridsa disseraqquiri najarideni naco pohuadeni tessedsa pohuama da quina tahi, dsotode pohuadenidsa ccanipomahijine. Naraha madijapa da naniraqquiri najaridenidsapa pohuama dade jiperaqquiri nahi. ");
INSERT INTO cul_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","—Naraha tiadenidsa ohuattipi: Tiadeni huadidedenidsa naco tetideni huanaqquiri nana. Tiadeni acco cama-jarajarideni naco acco ticamabaqquimanana. Madija naco tiadenidsa: “Pohuama ohuadsa da taccajo” quinadsapa pohuadenidsa da da tiquinana. Dsotode da inanihitohui tibodideni huatomana tejerana. Nema tiquinadsapi manaco Diopa tiadenidsa pocca daniji bicabote da inanitohui. Nadsapi ticcadeni ima naqui ahuato tanijine, aja Abi Dio memehuaji madijaricca ejedeni tiquejenajaro. Pohuapa madija huapimadsa pocca nahatoniji eccocco-jerajaro. Dio Pohuadsa: “Ticca daniji ohuadsa bica tani” quina-jarajaridenidsa aja madija tabaccoraqquiri najaridenidsa naco Abi Diopa huapimadsa huati huana tajari. Ajijaro dsamadsa madimanajarideni huapimadsa Dio pocca nahatonaja inanaridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nadsama tiadeni naqui pina ticcadeni Abi Diojinessa tinanamanana. Abi Diopa tohuati huanehe, acco camehema madijadsa huati huana tajari, tiadeni naqui madija huapimadsa tetideni huanaqquiri nadsa pohuadeni acco acco titicamabaqquimana nana, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Tiadenipi madija ticattejidsamana tajarajo. Pina Diocca dossenijissa inana-jerani qqui tiquinadsa: “A, namajide rahi, pocca ima bica tejerani” tiquinejerana. Madijadenidsa tettideni nema tiquinejeradsana manaco Diopa tiadenidsa: “A, ticcadeni ima naqui bica tejerani” najarahitohui tiadenidsa. Aja madija ohuahacca ima tiadenidsa bica tejeradsa naqui tettidenipi: “Pohuapa tabaccora tahi, pohua nanajidso tojahi bica tahi” tiquinejeraji. Nema tiquinejeradsana manaco Diopa tiadenidsa: “Tia naqui tabaccora tinani, nanajidso tijanitohui” najarahitohui. Nadsama madija ohuahacca ima tiadenidsa bica tejeradsa naqui epejena najaro imatohui tibodideni huatomana dsanapo-jerana. Pohuadsa tedimanadsa naqui denima ticahadirejerana, pina ticajonerapomana, onajaro. Nema tiquinadsapi titessedsa ima bica tejerani tinanamanadsa naqui manaco tiadenidsa: “Epejena, huadi onejerani, ohuati ajimani” nahitohui. Diocca ejedeni tiquejenadsapi nidsa dsama jicadsa Dio naco ticcadeni ima huati nimani-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nadsama tiadenipi madijadsa da tiquinadsa naqui najaropi manaconitohui jerani ponima da tiquinaji. Nema tiquinadsapi Diopa tiadenidsa da inanitohui. Pohuapa tiadenidsa huemani da inanitohui. Pina ticcadeni saco Pohuajine ijijaro, epejeraha denima ajarini joca inadsa topa icamerijaro, denima quissa icameridsapi ijinissa tajaro. Nadsapi tiadenina huemani ticajimananitohui. Tijinedeni madija ohuahadsa tinanamanajarocca imapi manaco tiadenidsa najarossa najaro inanamananitohui, onajaro. Pina huemahi madijadsa da tiquinadsapi manaco Diopa tiadenidsa huemahi da inahitohui. Madijadsa badsira taha da tiquinadsa naco manaco Diopa tiadenidsa badsira taha da inahitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nadsama Jesopa ajijaro namidsa imadinicca imadsa mari icanabaqquijari: —Nocco siri pamahapa ¿ojaria pohua tesse eccaridsahijine nahato taco? Nahato tajarahi. Pohua tesse eccaridsadsapa odi tohuajarodsa pamaha tocatojedsimera tahi. Paji, pina nocco sirissa tiquinejerana. Ssamoqquiri tiquinejerana. ");
INSERT INTO cul_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ajijaro ima tetideni ajimamana tejerana: Madija pocca mamari tabaqquipa pohuadeni maridedsa deni toquejena-jarahi. Pohuadeni maridena denima nahato tajari. Naraha disseraqquiri nadsa tocahatterahissa tadsana pina pohuadeni maridessa quinahitohui, onajaro. Jehe, nema tiquinana. Ohuadsa ticahatteranissa tana, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Madija ohuahacca imadsa: —Bica tejerani −inejeranijine Jesopa ajijaro namidsa imadinicca ima tadsajani mari icanabaqquipomajari. Pohua attipa: —Tiadenipi timecotecca madie pina Diocca dossenijissa nejerani qqui tiquinadsapi tettideni: “A, pohuajine ima bica tejerani” titiquina naraha tiadeni naqui imasiri ticajimanani. Nadsama najaro ticcadeni imapi pina timecote noccodsa ahua majiconi huedsani qqui tinajarocca imassa najaro. Timecotedsa: “A, tinoccodsa ahua majiconi huedsaha, tire oninena” taraha tinoccodsa naqui ahua majiconi imeni huedsani. Tinocco ahuatora tadsapi qqui tinanissa tejerani. ");
INSERT INTO cul_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nadsama tiadenipi imasiri ticajimanaraha ¿nejecotohui timecotedsara: “A, tijine ima bica tejerani. Tia acco ocamana, ticca ima tobicanijine” titiquina naraha tiadenipi tahide ticcadeni imaha tijinedeni tobicapo-jerani? ¡Jaho, nema tiquinadsapi pina mamaidsadedenissa tiquinajaro! Ticcadeni ima bica tejeradsapi aji ticcadeni imaha tinanabicamanapoji. Nadsana timecote acco ticamamanahijine tipajiramananitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesopa ahuacca imadsa mari icanabaqquihijine huati huati tajari: —Ahua bicahidsapa bono tabaccora tajari cahua-jarajari. Ahua tabaccora tajaridsapa bono bicahi quejemaha cahua-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Madijapa iquiera bono tohui quinadsapa ¿botani tetehuedsa iquiera bono pore pore quinaco? Nohuerahi. Uva bono tohui quinadsa naco ¿cotihidsa uva bono pore pore quinaco? Nohuerahi. Nadsama ahua huapima bono cajiridsadsapa bono bicahi cajihi nahato inadsapi: “Najari ahuapa bica tahi” inajaro. Bono tabaccora tahi cajihi nahato inadsapi: “Najari ahuapa tabaccora tahi” inajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Aji madijacca ima naqui pina ahuacca imassa najaro. Aja madijadenipa pohuadeni bodicca ima nahato inejeraraha poccadeni madie qqui inadsapi pohuadeni bodicca ima naqui iadsa ahuato tajaro. Madija bica tajaripa pohua bodidsa ima bicani cajidsapa ima bicani ihinana najaro. Naraha madija bica tajarajaripa pohua bodidsa ima tabaccora tani cajidsapa imasiri ihinana najaro. Aja madija huapimapa pohuadeni bodidsa ima caji tadsapi najaro imara huati huati totoquina najari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Tiadeni motapi ¿nejecotohui ohuadsa “Ohua Medsede” titiquina naraha aji ohuattissa tinanamana-jerani? onajaro. ");
INSERT INTO cul_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Aja madija ohuadsa bacco quinadsa ohuatti mittamanadsapa ohuattissa inanamanajaropi pina aja madija “Odsa bicani ocanahatona” najaricca imassa quinajari. Madijapa pocca odsa icanahatonijinepi odi hui idsimajaro. Nami ccara tanihuaji bacco tadsana huehuema ppa idsajari. Nadsapi odsa daco cajirajaro. Nadsapi ppani imeni bacco nadsa dacorehe ssahaha canadsa odsadsa jiba jiba naraha cojo tocana-jerajaro. Aji huehuemapi nami ccara tanihuaji bacco teje najaro. ");
INSERT INTO cul_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Naraha madija ohuatti mittamanaraha ohuattissa inanamana-jerajaropi pohuadenipa pina aja madija pocca odsa nahatode ssamo tajarissa quinajari. Najari madijapa pocca odsa icanahatodsapi huehuemajine odi hui todsanipi ssiqui nami ccara tanihuaji bacco tejerajaro. Odipi huaji tejerani. Nadsapi ppani imeni bacco nadsa dacorehema ssahaha canadsa odsadsa jiba jiba nadsapi odsa cojo tocanajaro. Odsa cojo tocanadsa toquehedimadsapi catirorijarossa najaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jeso madija mari icanabaqquia jicadsapa odsa panani Capernaohuaji toccanijari. ");
INSERT INTO cul_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nahidsapa romanodenicca soldado dossede madijari. Pocca dodosse tabaqqui soldadopa 100 quinajari. Najari pocca odsahuajipa pocca medse coma tajari huatiabote najari. Pohuapa pocca medsedsa huati huana tajari. ");
INSERT INTO cul_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nanaja Jeso tahimari mittadsapa nahicca jodiodeni ime jocohuideni mota Jesodsa huati toquinahijine dosse inabaqquijari: —Jeso ahuaji ccajonahijine huati ticanamanahissa tana, nahi occa medse inanomihijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nadsapa Jesodsa bacco toquinadsapa huati toquinahissa tajari: —Aja romanodenicca soldado dossedepa bica tahi. Pohuapa icca madija jodiodenidsa naco huati huana tajari. Pohuapa icca Dio Atti mamari naqui pohuajinena icajijaro. Pohuapa iadsa bica tahi. Manaco pohua acco ticamajo, inajaro −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nadsapa Jeso pohuadenidsa toccanijari. Odsahuaji bacco tanimanabote naraha romanodenicca soldado dossede pohua tessedeni tahide dosse inabaqquijari, Jeso bacco ijidsamanahijine. Jeso jahuidsa bacco ijidsamanadsapa pohuadsa huati toquinajari: —Soldado dossede attipa ajama napaja: “Ohua Medsede, epeje, occa odsahuaji ticcajona tejeraji. Tiapi nahatojide tijirani naraha ohuapi ajimani, ssamo onani. Occa odsahuaji tiqquedsimanijine jipera tinanitide” napaja −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","—Pohua attipa: “Jeso, ohuapi pina aji tia bica tinajarossa onejerani onadsa tia qquide oqquejerajaro. Naraha tia huati tinadsapi occa medse tonomihitohui, onajaro” napaja −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","—Pohua atti denima naqui: “Aji ohua naqui occa taminecca dossenijidsa omadijaro. Manaco soldadodenipa occa dossenijidsa madimanajari. Pohuadenitohui huahua onadsapi jahijona tahi. Dosse dosse onadsa naco ohuattidsa jai toja tahi. Occa medsedsa naqui: ‘Tidsepe ijiji’ onadsa naqui pina aji ohua odossejarossa inana tani. Nema nadsapi ajidsa huati tinadsa occa medse tonomihijine tipajirani, napaja tiquinana” najari romanodenicca soldado dossede atti −quinajari pohua tessedeni. ");
INSERT INTO cul_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Najaro ima Jeso mittadsapa huatidsedsa pohua bodi: —A, pohuapa nahato taha −najari. Tahidehuajanidsa pohua nattihuaji jahimissajaridenidsa huati tajari: —Tiadenidsa huati onana: Ajajari bodi namanahapa pajissa nahissa tajari. Tiadeni Isaraeri potemahideni huapimapi tettideni ohomitta naraha ajajarissa najari tiadenidsapa nohuerahi. Pajissa tiquinanissa tani ohomitta nejerani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Romanodenicca soldado dossede pohua tessedeni jai tojanidsa pocca odsahuaji bacco tanimanadsapa pocca medsepa tonomihira qqui toquinajari. ");
INSERT INTO cul_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nahi dsotodepa Jeso pocca dodosse tabaqqui tedseje odsa onini Nainahuaji jai tojajari. Madija huapi taha naco pohuadenidsa jai tojajari. ");
INSERT INTO cul_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Odsa totoqquedsimahuaji bacco toquinabote naraha qqui toquinanaja madija dsoqquehi dsodsojo tocanadsa dsojo icanajonamanajari, ppa idsamanahijine. Aja dsoqquejari imenipi tabira tocajapojaro. Bedi dsoqquedsapa poni motta tojajaro. Poni bedi maqquideje ojari naraha dsoqquejari. Odsahuajicca madija huapima poni huatinimade jahijonajari. ");
INSERT INTO cul_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naraha Jesopa ponidsa huati huana tadsapa: —Oji tejeraji −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nadsapa Jeso tohuajiressijari, dsoqquejari dsodsojo tocanadsa bara nadsapa dsojodedeni domo huaha tahi najari. Nanaja Jesopa huati tajari: —Dsabisso, tiadsa huati onana: ¡Titehemaji! −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nadsapa aja dsoqquejari camittemanidsa totehema, huittari najari. Atti naco cajipomajari. Nadsapa imenidsa Jeso attipa: —Aja, ticca ejedeni tiadsa tojanipomajo −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Madija huapima Jesojine dsabisso camittemanihi qqui toquinadsapa cappinamanaraha Diodsa huatidsemanajari: —¡Iadsa Dio Atti cacomerabote nahato tajari bacco nahi, bacco nahi! −naridsamanajari huapima. —Iapi Diocca madija iquejeneje najaro jidapapi Diocca nahatohue aji ia qqui inajaroccapi Dio ia acco tocamabaqquihitohui inajaro −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nadsapa Jesojine dsabisso camittemanihicca ima tojaridsadsapi dsama Jodeahuaji madimanajarideni huapima mittaridsamanajari. Poccadeni dsama jicaqquinihuaji naqui ima bacco taridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Huano pocca mamari tabaqqui —Jeso canahatori canahi −quinahi ima mittamanadsapa Huanodsa huati toquinajari. Nadsapa Huano Jeso tahimari mittadsapa pocca mamari tabaqqui pamaha Jesohuaji dosse inabaqquihijine huahua inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nadsapa pohuadenidsa huati tajari: —Jesodsa ticadaji, pohuadsa ohuatti huati tiquinana. Ajima tiquinaji: “¿Tiapi aji pohuatohui imadijaro Cristo-Mesia tijaqui? ¿Ohuahatohui imadiccanijinerane?” tiquinana Jesodsa −najari Huano. ");
INSERT INTO cul_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nadsapa Huanocca dosseniji Jesodsa bacco toquinadsapa pohuadsa huati toquinajari: —Huano Baotista attipa tiadsa huati inanijine ia dosse najonabaqquijari. Pohua attipa: “¿Tiapi aja tohui imadijaro Cristo-Mesia tijaqui? ¿Ohuahatohui imadiccanijinerane? nadija tiquinana” nade Huano atti −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aja pohuadeni Jesodsa huati toquinadsama Jeso pohua dsepe iji iji nahi qqui toquinajari. Madija comaqquiri najarideni comani onihi, onihi cajiridsamanajari inanomibaqquijari. Madija bodidenicca tocorime ohuaha ohuaha naridsajarideni naco Jesojine jahinineridsajari. Madija nocco sirideni naco nocco ssire inanaridsajari. ");
INSERT INTO cul_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nadsapa Huano dosse inajonabaqquijaridenidsa Jeso pohua cacomerajari: —Jehe, ticadanidsa Huanodsa huati tinanimanaji. Aji qqui tiquinajaro, aji timittamanajaro pohuadsa huati tinanimanana −najari Jeso. —Ajima tiquinana: “Madija nocco sirideni nocco ssire tocanirehi. Madija isso sirideni naco tocanomiredsa jahiridsahi. Madija dsamacoma onini leprajine huapideni jadsimarojarideni naco imedeni tobicaridsahi. Madija huaribodeni didiqquiri najarideni naco huaribodeni ssire tocanireridsahi. Madija huatiajarideni naco camittemani-ridsamanahi. Madija tohuati nahanaqquiri najarideni naco icassiejeranijinecca ima mari icanabaqquidsa mittaridsamanahi” tinanimanana tiadeni maridedsa −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","—Aja madija mota attidenipa: “Jesopa Cristo-Mesia jarahi, pocca imapi onihi, Cristo-Mesiacca imassa nejerani” quinaraha madija mota nama quina-jarajari attidenipa: “Pajissa Jesopa icca Mesia” quinadsa pohuadenidsana Dio pocca biquehe inananitohui. Ajijaro ima huapima Huanodsa huati tinanimanana −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nadsapa Huano dosse inajonabaqquijarideni tohuedanihi natti Jesopa pohuadsa queriqquimanajaridenidsa Huano tahimari huati tajari: —Dsama huamoni ssono caji, siba caji tanihuajipi ¿nejeco qquidera jajahi tija najarotte? Aja madija pocca ima japari tajaro pina boba jojodejine jene jene tocanajarissa najari ¿nama najari qquide jajahi tija najarottarane? Nohueraha. ");
INSERT INTO cul_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aji huamonihuaji jajahi tija nadsapi ¿nejeco qquidera jajahi tija najarotte? Aja madija etero huatini ccara tanicca huedsajari qquide ¿jajahi tija najarottarane? Naraha tiadenipi nahatoqquiri tiquinani: Madija etero huatini ccara tanicca huedsamanajaridenipa taminedenicca odsadsana mamadimana najari. Naraha Huanopa nema najaro madietohui najarajari. Pohuapa camello conera huehuedsa najari. Dsama huamonihuaji mamadi najari. ");
INSERT INTO cul_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Naraha ¿nejecotohuira pohua cattade jajahi tija najarotte? “Huanopa Dio Atti cacomerabote dacorajari” titiquina nadsa ¿jajahi tija najarottaqui? Jehe pajissa. Pocca marinajatohui jajahi tija najaro. Huanopa pina Dio Atti cacomeraqquiri najaridenissa naraha pohuapa deni tojajari. Pohua dsepe ijijaripa ima deni tojanicca cajijari. Najaro imapi otahimari Cristo-Mesia tiadeni Idinide ojanijinecca ima inanajora-ridsapojaropaji. ");
INSERT INTO cul_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aja, Huano Baotistapa maittaccadsama pohua tedsejemacca ima Dio Atti cacomerabote dsodo inapojaro. Najaropi pina Diopa Cristo-Mesiadsa huati tapojarissa najaro: “Tahide titahimari tohuaccade madija ojaria titedsejema dosse onapohuitohui. Nahi mittamanadsa madija bodidenipa titohui najoramanapohuijine, pina tijahine inajoramanapojarissa inanamananitohui, onajaro” napohui nade Dio Atti Maraquia dsodo inapodsa. ");
INSERT INTO cul_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Nadsama tiadenidsa huati onajaro: Aji namidsa madiridsamanajaridenidsa naco madija ohuaha pina Huano Baotistassa najari nohuerahi. Huano Baotista pohuajinena madija bodideni otahimaritohui Diocca cacahuehecca ima dsati inanajorabaqquipojari. Najarojine Huanopa namidsa madiridsamanajarideni huapimadsa deni tojajari. Naraha Diocca cacahuehepi ima onihi cajijaro. Najaroa nidsa dsotode madijapa Diocca cacahuehecca ima dsati tojani qqui toquinadsa najarodsa toquejenadsapa Huano Baotistadsa deni toquejenahitohui. Madija ajamani tojajari pina tohuati nahana tajari Diocca cacahuehedsa tojadsapa pohua naco Huano Baotistadsa deni tojahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","—Madija huapima Huanocca marinaja mittamanadsapa jodiodeni mota, romanodenicca taminecca dosseniji dsiniro nanaccadedeni naco: “Jehe, pajissa Diopa nahato tahi. Bicaqquiri inejerani. Icca tabaccorehe inebona” quinadsapa Huano topa idsanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Naraha jodiodeni marinaja pariseodsa jehe quinajaridenipa, jodiodenicca marinaja maridedeni tedseje nama quina-jarajari. Huanocca marinajadsa huaribodeni sibaqquiri nadsapa topaniji tohui quina-jarajari. Diopa pohuadenidsa ima dsati bicani inananitohuiraha pohuadenipa ettajomanajaro. ");
INSERT INTO cul_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Naraha jidapanana aja madija madiridsamanajaridenipa ¿pina nejecojaridenissa quinajari? onajaro. Ohuatti timittamananissa tanijine ajijaro namidsa imadinicca imadsa tiadeni mari ocanabaqquina. ");
INSERT INTO cul_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jehe, madija jidapana madiridsamanajaridenipa pina ejedenideni boronidsa jassi tadsa poccadeni ittome tossamodsa ahuaji johua, ahuaji johua quinajarissa najari, onajaro. Pohuadenipa pohuadeni tessedenidsa: “Jaho, dsobi tiquinanijine totoredsa tore tore inaraha tetidsemana-jerani, dsobi dsobi tiquinejerani” quinajari. Pohuadeni atti naco: “Ittomedsa naqui tiadeni oji inanabaqquinijine ajie tohuati nahana taniccadsa jiri jiri inaraha tiadenipi oji tiquinehe nejerani” quinajari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Jehe, aja jidapana madimanajaridenipa pina ejedeni jamimanajarissa quinahi onajaropi Huano Baotista Dio Atti cacomerade tojadsapa ejetecca jipaqquiecca jijipa jipa-jarahi, dse najarahi nadsa johua johua quinadsa attidenipa: “Huano Baotistacca madie jidsa tani. ¡Satanacca dodosse tocorime pohua bodidsa madidsajari itidija!” quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Dsotodepi ohua Madija Bedi ojajaroa ejetecca jipaqquiecca jijipa ojipa, dsedse dse onadsapa ohuadsa johua johua quinajari attidenipa: “Jaho, pohuapa jipajide rahi, dsedsejide rahi. Romanodenicca taminecca dosseniji dsiniro nanaccadedeni, madija imasiri cajimanajarideni naco pohua tesse toquejenajari” quiquinanajari ohuadsa. ");
INSERT INTO cul_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Huanodsa, ohuadsa attideni nama quinaraha nidsa imasiri cajimanajarideni ettijine bodideni cacajiqquimera, imarideni cacajiqquimera nadsapa Diocca nahatohue ahuato tanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Madija marinaja onini pariseodsa jehe najaripa Jesodsa huahua najari, pocca odsahuaji inajipahijine. Najaricca odsahuaji Jeso toccadsa toqquedsimadsapa huahuanaridsa huittarijari, jipahijine. ");
INSERT INTO cul_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Naraha najaro odsa pananidsapi amoneje huananari madijaro. Ponipi ima mittajaro: —Pariseocca odsahuaji Jeso bacco nahi, nahihuaji jipahijine −quinadsa nanihuaji toqquedsimajaro. Jojo bicahi siba alabastro nahatoni dsojo inajonajari. Najari jojodsa majojo bicani ijijaro. ");
INSERT INTO cul_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ojiema Jesodsa bacco tadsapi pohua amorihuaji huadsa oji oji najaro. Nadsapi poni nocconi ppajani ssabororo nadsa Jeso amori ppajaja tocaja najaro. Nadsapi poni tatini conanidsa Jeso amori sse ippijari. Amori sse ippia jicadsapa amoridsa mose najaro. Nani dsotodepi ponicca majojodsa naqui Jeso amori ssohoho icanarijaro. ");
INSERT INTO cul_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Naraha aja pariseo Jesodsa huahua najaripa najaro amoneje Jesodsa nema nani qqui tadsa pohua bodipa: —Ajana, Jesopa Dio Atti cacomeraqquiri najaridenissa nadsapa madija bodidenicca ima nahato tanaja. Najaro amoneje pohuadsa mari dsanajaropi madierini tabaccora tajaro. Ponidsa: “Huaji tinaji” nahitohuiraha −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Naraha Jeso attipa: —Simon, tiadsa huati onana −najari. Naraha pohua cacomerajari: —Jari Mamaride, huati tinaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesopa Simon pohua bodidsa atti atti nahi nahato tadsa ima ajima najaro huati tajari: —Maqquideje pamahapa dsiniro dada nanaja nahihuaji debe quinajari. Ojariapa dsiniro ccarara 500 denario debe najari. Madija ohuahapa 50 denario debe najari. ");
INSERT INTO cul_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nadsama pohuadeni pamahapa poccadeni ima tossamodsapi paca quinahijine pajiramana-jarahi. Nadsapa dsiniro dadade attipa: “Jehe, tipajiramana-jeradsapi ticcadeni cuenta ojine dsodo nani sse onanitohui. Nani tiadenidsa: Denima ohua paca tiquinaji, onejeranijine” najari dsiniro dadade atti. Nadsapi poccadeni cuenta jicani. —Jari Simon ¿nejecoma tani tettipi? ¿Nejecojarina dsiniro dadadedsa denima huati huana tajari? ¿Aja denima debe najaripa dsiniro dadadedsa denima huati huana tajarico? ¿Ajamani debe najarina dsiniro dadadedsa denima huati huana tajarirana? −najari Jeso Simondsa. ");
INSERT INTO cul_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Naraha Simon pohua cacomerajari: —Ssamo onani. Aja denima debe najarina dsiniro dadadedsa denima huati huana tajari itide −najari. Nadsapa Jeso pohuadsa huati tajari: —Jehe pajissa. Tecomeranissa tani −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nadsapa Jeso amoneje icattoma nadsa Simondsa huati tajari: —Qqui, ajijaro amonejecca tohuati huanehepi ahuato tani. Ohuapi ticca odsadsa oqquedsimaraha tiapi ohuadsa pina icca madijacca imassa tinana-jerani. Ohuadsa passo da ticanehe nejerani, ohuamori ssahua onanijineraha. Naraha ajijaro amonejena oji oji nadsapi poni nocconi ppajani toccadsa ohuamori ppajaja tocajadsapi poni tatini conanidsa ohuamori sse ippijaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","—Tiapi ohuadsa pina icca madijacca imassa tinana-jerani. Icca madijapa itesse jipahijine huahua inadsa bacco nadsapa ipano mose mose ihinanajaro, itatidsa oqui naco sso sso ihinari najari. Opano mose tejeraraha ajijaro amonejena oqquedsimaponidsama ohuamori mose mose dsanapojaro. ");
INSERT INTO cul_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Otatidsa oqui naco sso tari-jararaha ajijaro amonejena ohuamori majojodsa ssohoho icanarijaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","—Jehe, najarojinea aji huati onajaropaji: Ponipi ima sse taporaha ponicca ima tabaccora tanicca Dio sse inadsapi jidapapi ponidsa ima nohuerani. Ponina denima ohuadsa huatini huana tajaro. Madija ohuahadeni naco poccadeni ima tabaccora tanicca Dio sse inadsapi pohuadenidsa ima nohuerani. Naraha madija bodideni: “Icca tabaccorehepi huapi tapo-jerade” quinajaridenia aja ohuadsa badsira taha huatideni huanaqquiri najaripaja, onajaro. Nadsama Simon, najaro ima tibodi huatoji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nadsapa Jeso amonejedsa huati tajari: —Aji, ima tinanapojaropi sse inehe jicajaro. Najaroa aji tibicajaropaji Diodsa −najari. ");
INSERT INTO cul_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Naraha nahi huahuanarihuaji Jeso tedseje jipamanahijine jassi tarijarideni pohuadenira huati canirere canajari: —Ajajaripa ¿nejecoma najaritta? ¿Nejecotohui pohuapa madija bodicca tabaccorehe tonanamosside nahato taha? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pohuadeni atti nama quinaraha Jesopa amonejedsa huati tajari: —Tiapi ohuadsa jehe tadsa tossiejehe ticajijaro. Diocca jonehema, pocca cappinerehema ticcaniji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nahi dsotodepa Jeso odsa panani onihihuaji onihihuaji mari mari naridsajari. Diocca cacahuehecca ima bicani huati huati naridsajari. Pocca dodosse tabaqqui 12 quinaha pohuadsa jahiridsajari. ");
INSERT INTO cul_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Amonejedeni naqui Jeso pohuadsa jahiridsajaro. Ponidenipi comaqquiri naporaha Jesojine tocanomireridsajaro. Onihideni naqui tocorimejine comaqquiri naporaha Jesojine bodinidenicca jahininejari. Najarodeni ojarie oninipi Maria, poni dsamarini onini Madarenadsa cacanijaro. Poni naqui tahidepi tocorime 7 quinajari cajiporaha Jesojine jahininejari. ");
INSERT INTO cul_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Amoneje onihi naqui Jesodsa ccaridsajaro, oninipi Dsohuana. Ponicca maqqui onipa Cosa. Cosapa tamine Herodecca odsa imeni cacahuade tojajari. Herodecca medsedeni naco dosse dosse najari. Amoneje onihipi Sosana ponidenidsama Jesodsa toccajaro. Amoneje onihideni naqui huapi tehe Jesodsa jai tojajaro. Ponideni huapimapi Jeso acco camade toquejenajaro. Ponidenicca dsinirodsa naqui pohuadeni taparideni mitta mitta nanaridsamana najaro. ");
INSERT INTO cul_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Odsa pananicca madija huapima naco jai tojaja camajari Jeso qquide. Madija huapima pohuadsa queriqquimanadsapa Jeso pocca marinaja mari icanabaqquihijine ajijaro namidsa imadinicca ima tadsajani mari icanabaqquijari. Nadsapa pohuadenidsa ajama najari: ");
INSERT INTO cul_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jehe, huidsaja ppappadepa pocca huidsaja huirade toccajari. Huidsaja bacco tadsapa huirade tojaridsajari. Cadsi huira, cadsi huira, cadsi huira naridsajari. Aja nocco huira inaridsajari motapa jahuihuaji catojajarijine ttai ttai tojaridsajari. Nocco ahahuatori nadsapa ppiriri saca quinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aja nocco huira inaridsajari motapa siba ccababa tanihuaji catojaridsajari. Najari naco moro taraha jabo nami ppaja tanihuaji bacco tajaradsapa maji ppoconejine botejari. ");
INSERT INTO cul_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aja nocco mota naco namidsa cotihi caji tahihuaji catojajaripa cotihi tedseje paja moro toquinarihi naraha cotihijine ssomi tojajari. ");
INSERT INTO cul_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nadsapa nocco mota huira naridsajaripa nami bicanidsa catojaridsadsapa mororo canaridsadsa bica taha napijari. Bono cajiridsadsapa ede ojariapa bono 100 naha cajijari. Ede huapimacca nama naridsajari −najari Jeso. Jeso huati huati taha jicadsapa pohuadenidsa jadsirema huati tajari: —Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nahi dsotodepa pocca dodosse tabaqqui pohuadsa huati toquinajari: —Jeso, ajijaro namidsa imadinicca ima tadsajani ia mari ticanabaqquijaropi ¿nejecoma najaro ticca marinaja? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Naraha Jeso pohuadenidsa huati tajari: —Jehe maittaccadsama Diocca cacahuehecca ima dsati najoraporaha madija inahattabaqqui-jaraccade. Jidapanana Diojine pocca cacahuehe tahimarini dsati tiadenidsana ahuato tani. Naraha madija motapa ajijaro namidsa imadinicca ima tadsajani pohuadeni mari ocanabaqquidsapa mittamana-jarajaripaja. Nama quinajaripa pina Dio Atti cacomerabote Isahia dsodo inapojarossa najaro. Isahia attipa: “Qqui qqui toquinaraha pina qqui toquirahi nahitohui. Pohuadeni bodi pina ssamoqquiri najarissa nahitohui. Diocca dosseniji mimittamana naraha pina mittamanerahi nahitohui” napohui nade Isahia atti −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—Aji occa marinaja ajijaro namidsa imadinicca ima tadsajani tiadeni mari ocanabaqquijaropi ajima najaro: Aja noccopa Dio Attissa najaro. ");
INSERT INTO cul_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nocco huira inaridsajari mota jahuihuaji catojajaripa pina madija Dio Atti mittamanaraha pohuadeni bodidsa toja-jeranijine maidsehe jinede Satana ccajonadsapa pohuadeni bodicca Dio Attipi amossi inanaridsajaro. Najaropi pina nocco jahuidsa catojadsa ahahuatori nadsapa ppiriri saca inaridsamanajarissa najari. Najarossa najaroa maidsehe jinede Satanajine bodideni inassamobaqquidsapa Diodsa pajissa quina-jaradsa tocassiejera-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Madija ohuaha bodidenicca imapi pina aji siba ccababa tajarocca imassa najaro. Dio Atti mittamanadsa huatidsemanaraha pohuadeni bodidsa toja-jerajaro. Najaro imapi pina aja nocco moro taraha siba ccababa teje najaro jabo huapihuajira toccabaqquijaricca imassa najaro. Najaria aja moro todsatiraha maji ppoconejine botejaripaja. Najaro imapi pina madija tahidepa: “Jehe, Dio Atti bica tani” quinaporaha dsotode pohuadenidsa ima ssonaridsa ocasserani ahuamanadsapa: “Epejena, Dio Attipi inebona” quinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Madija ohuaha bodidenicca imapi pina cotihi tedseje nocco moro tajaricca imassa najaro. Pohuadenipa Dio Atti mittamanaraha pohuadenia ajijaro namicca ima Dio Atti tadsajani icanejemamana-dsanapojaro. Nadsama pohuadenia aja pohuadeni dsepedeni ihijimana najarotohuira disseraqquiri nadsapa Dio Atti tocahatterahissa tajarajari. Nadsama madija attidenipa: “Todsepetaji inehemana” quiquinanadsa naco poccadeni jeheniji maidsehe toja tani. Aji namicca ima pohuadeni tohuini quinahiccadsara huahuatidsemana nadsa naco Dio Attipi huatideni ajamamanajari. “Dio Attina denima bica tani” quina-jarajari. Nadsama poccadeni jehenijipi pina aja cotihi tedseje nocco moro taraha cotihijine ssomi tojadsapa bono-jarajarissa najaro. Nama najari madija naco otahimari bicani icassiejeranijinecca pohuadeni tesse mari icanabaqquimana-jaradsapa ohuatti mittamana-jarajaripaja. Poccadeni madiedsa occa marinaja ahuato tejeradsapi pohuadeni tesse ohuadsa pajissa quina-jarajari. Nama quinadsapa pina bononoraqquiri najarissa quinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Naraha madija ohuaha bodidenicca imapi pina aji nami bica tajarocca imassa najaro. Dio Atti mittamanadsapa jehe quinahissa tajari. Pohuadeni bodipa pajissehe tohuini quinajari, bodideni bicaqquiri najari. Dio Atti pohuadeni bodidsa ecahuamana-dsanapojaro. Poccadeni jeheniji napidsapi pina aja nocco nami bicanidsa moro tahissa tadsapa bono cajijari. Nadsama pohuadenipa Dio Attidsa disseraqquiri nadsa ocasserani ahuamanadsa naco nama naha Dio Attidsara jehe dsanapomanajari. Pohuadenipa madija ohuaha acco acco ihicamabaqquimana nadsapa najarideni naco Diocca ejedeni toquejenajari −najari Jeso atti. ");
INSERT INTO cul_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Nadsama jojororo toquehessidsapa boco icanahijine jarahi. Huahuada dopanihuaji naco tocanajimahijine jarahi. Jojororo toquehessidsapa aja pohua cacahittari nahidsana cacahittari najari, nahi madija odsa bodihuaji jahidsimajarideni ssiajani cajimanahijine. Ohuatti naqui najarossa najaro, pina jojororo ssiejene ssiaja tajarissa najari. Aja madija ohuatti cajimanajaridenipa ecomamana-jeranijine, najaro ssiajanipi madija huapimadsa tossiajabaqquinijine, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nadsama ima ahuatora tanicca caji taraha nidsa dsotodepi ahuato tanitohui. Aji occa marinaja mota ahuatora tadsa timittamana-jeraraha nidsa dsotodena tiadenidsa ahuato tadsana timittamananitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—Jehe, nadsama ohuatti timittamananissa taji. Paji, occa marinaja timittamanadsapi mohuaradsa ohuatti huapima tiadenidsa tojanissa tanijine timittamananissa taji. “Ponimaha” tiquinejeraji. Aji tiadeni ohuatti tecahuamanadsapi denima ticahatteranitohui. Naraha occa marinaja timittamanaraha ohuatti tecahuamana-jeradsapi occa marinaja odininitohui. Occa marinaja tiadenidsa tojapoma-jeranijine, onajaro. Nadsapi tiadenira tiadeni ticamaidsanimanadsa naqui: “Dio Atti ocajini, nahato onani” tiquinaraha najaro naqui odininitohui. Paji, nemamana tejeraji, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Naraha Jeso pohua mari mari nahihuajipa Jeso imeni, pohua imecotedeni quinadsa pohuahuaji bacco toquinajari. Bacco toquinaraha madija huapi taja najari pohuahuaji jai tojedsimahijineraha tojera tajaro. ");
INSERT INTO cul_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Naraha madija ojaria Jesodsa huati tajari: —Ticca ami, timecotedeni amossinidsa domo huapaja: “Tia qqui inana” quinapaja −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Naraha Jeso pohua attipa: —Aja madija Dio Atti mittamanahissa tadsa Pohua Attissa inanamanajarodenina pina occa amissa, pina ohuemecotedenissa quinajari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nadsapa Jeso pocca dodosse tabaqqui tedseje canoadsa jai tojedsadsa nahi canoadsa pohuadenidsa huati tajari: —Jina, coridsa jippehuaji jaijana −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nadsapa tohuaccamanaraha Jesopa huadaja dsanapojari. Huatideni ajamama canaraha jojode dacorehema ccajona, passo dacorehema ccajona nadsapi coridsa ssoda ssoda najaro, canoadsa passo ssonidsa ssonidsa najarojine je tocanamanabote najari. ");
INSERT INTO cul_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nadsapa Jeso huadahihuaji jai tojeppidsa nocco tojahijine cobo quinajari: —¡Ia Maride, ia Maride! ¡Nocco tijaji! ¡Je icanabote nani! −quinajari. Nadsapa Jeso totehemadsa jojodedsa, passo ssodadanidsa huati tajari: —¡Epeje taji! −najari. Nadsapi jojode, passo ssoda ssoda najaro naqui joma najaro. Joma nadsapi passo podsippanissa tajaro. ");
INSERT INTO cul_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nadsapa Jeso pocca dodosse tabaqquidsa huati tajari: —Tiadenipi ohuadsa: “Jehe, Jesopa ia tohuacahua-baqquihijine pajirahi” ¿tiquinejerajarorane? −najari Jeso. Naraha pohuadenipa cappinamanajari. Bodideni jabojo quinadsa pohuadenira imahaha canajari: —Aja ia Maridepa ¿nejeco madija? Pohuapa jojode, passo ssodadanima quejema naraha jojodedsa: “Epeje taji” naneje joma naha −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jojode jicadsa denima tohuaccamanadsapa dsama Carirea jippehuaji bacco toquinajari. Pohuadeni huana tocanamanahihuajicca dsama oninipi Jerasa. ");
INSERT INTO cul_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nahidsa Jeso toqquemoradsapa nahicca odsacca madija ojaria pohuadsa bacco najari. Najari madijapa Satanacca dodosse tocorime cajijari. Najaripa tocorimejine ccoroje mamadi najari. Odsadsa madi-jarahi. Tonoccobirihuajina mamadi najari. ");
INSERT INTO cul_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Huajijiradsa tocorimejine totodacora najari. Nahi odsa pananicca madijapa ecahuamanahijine cadenadsa biji jore quinaraha tocorimejine dacoradsa cadena joca tajojo, joca tajojo najari. Isso naco cadenadsa jore quinaraha ttai tajojo, ttai tajojo najari. Dsama huaji tanihuaji madija madide nohuerahihuaji naco tocorimejine joppa tajari. Nadsapa Jeso toqquemoraraha najari madija naco qquedsippajari. Jesodsa bacco dsippadsapa madija bodicca tocorime toqquenahijine pohuadsa huati tajari: —¡Tocorime, tiqquenaji! ¡Najari madija tinebojo! −najari. Nadsapa Jeso baccohuaji pohua pitodsa huitta nadsa jadsirema johua johua najari: —Jeso ¿nejecotohuira ticcajonajaro? ¿Ohua najidsode ticcajonajaroqui? Tiapi Dio deni tojajaricca Ejedeni tijani. ¡Epejena, ohua najidso tejeraji! −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nadsapa Jeso huati tapomajari: —¿Tia onipi nejeco? −najari. Naraha pohua cacomerajari: —Ohua onipi Siba tani −najari. Pohuadenipa huapi taja najari pohua bodidsa madidsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pohua bodiccana Jesodsa huati toquinajari: —¡Jaho, ia dosse tininebaqqui-jeraji! ¡Nami odini huaji tanihuaji ia hua tidsima-jeraji, inaha! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Naraha nahi ssono huajira tanidsa poroco huapi taha jiparidsamanajari. Nadsapa tocorimedeni Jesodsa huati toquinapomajari: —Porocodsana iquejenaccana −quinajari. Nadsapa Jeso: —¡Jehe, porocodsana tiquejenana! −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nadsapa najari madija bodicca tocorime jahininedsapa porocodsana jai tojedsimaridsajari. Nanaja porocopa coridsa inidi sseberanihuaji domo toqquedsippadsa diri-ri-ri todsippadsapa cojo-jo-jo quinajari, tocatojedsippajari. Je tocaniredsapa coridsadsa cacotedsanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nadsapa poroco cacahuadedenipa aja poroco tocatojedsippahi qqui toquinadsapa ahuajicca odsa pananihuaji ima joppa tocanajari, ohuahapa huidsajahuaji ima joppa tocanajari. Nama naridsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nadsapa madija huapima qquide jahijonana canajari. Jesohuaji bacco najonamanadsapa aja madija bodicca tocorime jahininedsa tonomihira qqui toquinajari. Nahi Jeso huahidsa huitta canajari. Etero huedsapomajari, bodi huatohue naco cajipomajari. Nadsapa madija huapima cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Qqui toquinapojaridenia aja madija tocorime cajiraha tonomihicca ima madija huapimadsa huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nadsapa dsama Jerasahuajicca madija huapima cappinamanadsa poccadeni dsamadsa Jeso toccanihijine dossede dissassera tajari: —¡Ticcaniji, aji icca dsamadsapi timadi tejeraji! −quinajari. Nadsapa Jeso canoadsa toqquedsanidsapa tohuaccanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Naraha jai tojani-jaraccadsa aja madija bodicca tocorime jahininedsa tonomihipa Jesodsa huati tajari: —Jeso, tiadsa occana ¿jehe taqui? −najari. Naraha Jeso pohuadsa: —Poni, tiboji −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Ticca odsahuajina ticcanina. Ticca madijadsa aji Diojine tinominicca ima huati tinanina −najari. Nadsa toccanidsapa nahicca odsa pananicca madija huapimadsa aja pohua tonomihicca, Jeso pohua inanomihicca ima huati taridsajari. ");
INSERT INTO cul_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nadsapa Jeso coridsa jippe pohuadeni nattihuaji jai tojanidsapa bacco tanimanajari. Bacco tanimanadsapa nahicca madija huapima huatidsemanadsa: —¿Nija, ticcanijaroqui? Iadsa bacco tanidsapi bica tani −quinajari. Pohuatohui madimanapoja najari. ");
INSERT INTO cul_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Naraha nahidsa Jeso bacco nanidsatiraha Jairo naco nahihuaji bacco najonaja najari. Pohuapa jodiodenicca Dio Atti mamarihuajicca tamine. Pohuapa Jesohuaji bacco nadsapa pohua bodipa: —Jesopa deni tojahi, ohuapi ajimani ojani −nadsa Jeso baccohuaji pohua pitodsa huitta tocattedsa najari. Nadsapa Jesodsa huati tajari: —Jina, occa odsahuaji icadaccana. Occa ejedeni tomijirapaja −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jairo bedenipi ojari najaro, ponicca huajanopa 12 naraha huatiabote najaro. Nadsapa Jeso Jairocca odsahuaji toccajari. Madija pohua toccahi qqui toquinadsapa madija huapima pohuadsa jai tojaja najari. Si tocajajari cadsanapoja najari Jesopa mere tabote dsanapojari. ");
INSERT INTO cul_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Madija huapima jai tojahidsa naqui amoneje coma tajaro tohuanajaro. Ponipi dsamacoma onini amaissoranaja cajijaro. Poni coma tanicca huajanopa 12 naraha ama jicaquera tanicca tonahanajonajaro. Toponi totonanomidedenidsa totocca naraha tonomi-jerajaro. ");
INSERT INTO cul_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Naneje ponipi Jeso qqui tadsapi Jeso nattihuaji toccamissadsa tohuajiressissi nadsa pocca etero iponi bara inajaro. Nahi poni bara inahidsa amadsati amani totappajaro. ");
INSERT INTO cul_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nanaja Jeso pajadsa huati najari: —¿Nejecojarina ohua bara najarinaja? −najari. Naraha manaco madija huapimapa: —Iapi nohue ijirani −quinajari. Naraha Pedro atti: —Ia Maride, madija huapi taja najari. Tiapi ahuaji bai, ahuaji bai quinajaria −najari Pedro. ");
INSERT INTO cul_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Naraha Jeso pohua cacomerajari: —Madija ohua bara nahi nahato onani. Occa dacorehe pohuadsa tojani nahato onani −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naraha amonejepi poni cacomaraha Jesojine ima tojani mittadsapi: —Jehe, nahato tahi −nadsapi cappinadsa tacca-cca canehe Jeso baccohuaji poni pitonidsa huitta nadsa ponicca ima ecomerajaro. Aji poni Jesocca etero bara inadsa amadsati amani tomossijarocca ima huati tadsa madija huapima mittamanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Naraha Jeso ponidsa huati tajari: —Jehe asi, ohuadsa tibodi: “Jehe, Jeso ohua tonanomihijine pajirahi” tadsapi najarojine ticca dsamacomapi toccapa. Ticcanidsapi ticappina tejerana −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesopa amonejedsa huati huati tahipaja naraha jodiodenicca Dio Atti mamarihuajicca tamine pocca odsacca madija ojaria bacco najonajari. Ejedeni imehidsa huati tajari: —Jairo, ticca ejedenipi huatiapaja. Ia Maride Jesodsa huati tidsima tejeraji: “Epejena occa odsahuaji tiqquejeraji” tana −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Naraha Jeso ima mittadsapa Jairodsa huati tajari: —Tibodipi ticappina tejerana. Pina “Jehe, poni tonominijine” tadsapi ticca ejedeni tonominitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nadsapa Jeso Jairocca odsahuaji bacco tadsapa aja Jeso pohuadsa jahijonajaridenipa Jairocca odsadsa jai tojedsima-jarahijine Jeso eccoccobaqquijari. Naraha jai tojedsimahipa Jeso pohua, Pedro, Huano, Satiaco, aji ejedeni imehi imeni todsimamanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Madija huapima nahidsa queriqquimanajarideni oji oji camajari. Ponitohui huatideni huanaqquiri nadsapa poccadeni ojiema johua johua quinajari. Naraha Jeso pohuadenidsa huati tajari: —Ojimana tiquinejeraji. Ejedenipi dsoqque-jerani. Huadajaro −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Naraha pohuadenipa ejedeni huatiani nahatoqquiri nadsapa Jeso atti jaja icanamanajari. ");
INSERT INTO cul_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Naraha Jesopa ejedeni huatiajaro porinihuaji toqquedsimadsa dsapanidsa mari nadsa jadsirema huahua najari: —¡Ejedeni, titehemaji! −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Naneje ejedeni ponipi camittemani-pomadsapi amadsati totehemajaro. Nadsapa Jeso attia: —Ticcadeni ejedeni tinajipamanaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ponicca abi ami jabojo quinaraha huatidsemanajari. Naraha Jeso pohua attipa: —Ajijaro imapi huati taridsamana tejerana. Poni −najari pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesopa pocca dodosse tabaqqui 12 quinajaridenidsa huahua nadsa queriqquijari. Jesopa tocorimedsa pohuana denima atti dacorajari. Najaro pohua atti dacorehe pocca dodosse tabaqquidsa inanajaro. Pohuadenidsa huati tadsa naco ajama najari: —Ohuatti, occa nahatohuema tiadenidsa onanana, aja madija bodidenicca tocorime ohuaha ohuaha naridsajarideni naco dosse dosse titimaridsa-baqquimana nahijine, onajaro. Madija huapima comani onihi onihi naha cajiridsamanajaridenicca naqui titinanomi-baqquimana nahijine, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pohuadeni motta jai tojaridsahijine Jesopa pohuadeni dosse inabaqquijari: —Diocca cacahuehecca ima tecomeraridsamanana. Madija comaqquiri najarideni tiadenidsa bacco quinadsa naco titinanomi-baqquimana nana −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pohuadenidsa denima huati tajari: —Ticcadeni benehidsa naqui tiadeni totocahuejidsa ahua dsojomana tiquinejeraji. Ticcadeni saco, ticcadeni dsamatapa, ticcadeni dsiniro, najaro huapimapi tiaccamana tejeraji. Ticcadeni etero naqui pamehepi tiaccamana tejeraji. Aji tedsamanajarora ohojariri tinanamanaji. ");
INSERT INTO cul_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nadsama odsa panani bacco tiquinadsapi aji jai tijedsimapojarocca odsadsara timadimanaccaji. Nani odsa pananihuaji ticcadeni marinaja jicadsapi odsa panani onihihuaji denima jai tijapomaji. ");
INSERT INTO cul_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nadsama odsa panani onihihuajiccapa tiadenidsa: “Ajidsa timadimanaji, Diocca cacahuehecca ima imittanijine” quina-jaradsapa nani poccadeni odsa pananihuajipi tinebomanadsa jai tijeqquimani bica tani, onajaro. Jai tijeqquimadsa naqui temoridenicca sadariadsa ssiqui ma tajaro catojanijine pporo pporo tiquinana. Nahi poccadeni ibohue bodideni huatoma-manahijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nadsapa poccadeni benehidsa jai tojabaqquiridsajari. Odsa panani huapimadsa ima bicani icassiejeranijinecca mari mari nanaridsamana najari. Madija comaqquiri najarideni naco ihinanomi-ridsabaqquimana najari. ");
INSERT INTO cul_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nadsama dsama arobeni Carireahuajicca tamine Herodepa Jesocca ima huati toquinahi mittajari. —Jesopa canahatori canajari −quinahi mittadsapa Herode pohua bodidsa: —¿Ima nejecoma najarona paji? −najari. Madija motadeni attidenipa: —Aja canahatori canajaripa Huano Baotista nahatonijari −quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Madija ohuaha attideni naco: —Maittaccadsamacca Dio Atti cacomerabote Eria nahatonijari −quiquinanajari. Madija ohuaha attideni naco: —Maittaccadsamacca Dio Atti cacomerabote ohuaha nahatonijari itide −quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Naraha Herode attipa: —Ohuana ocadossebaqquidsa Huanopa matto ca ijidsamanajaride. Nadsama aja canahatori canajari pohua tahimari ohuadsa huati huati totoquina najaripa ¿nejecoma najari napaja? −najari. Atti nama nadsapa Jeso qqui tahijine dissera tajari. ");
INSERT INTO cul_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesocca dodosse tabaqqui bacco nanimanadsapa poccadeni benehicca ima huati nanimanajari. Nahi dsotodepa Jeso pohuadeni pohuadenira odsa panani Besaidahuaji iaccabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nadsama madijadenipa Jeso toccahi nahatoqquiri nadsapa dsotode jai tojamissajari. Bacco toquinadsapa Jeso pohuadenidsa huati tajari: —¿Nija, bacco tajonamanajaroqui? −najari. Nadsapa Diocca cacahuehecca ima mari icanabaqquijari, aja comaqquiri najarideni naco inanomiridsa-baqquijari. ");
INSERT INTO cul_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Naraha Jesocca dodosse tabaqqui 12 quinajarideni maji toccahi qqui toquinadsapa Jesodsa huajiressimanadsa pohuadsa huati toquinajari: —Ajajari madijadeni huati tinabaqquijo tocahadijanina. Pohuadeni tapari naco odsa onihihuaji mitta naridsamanana. Aja iadsapa dsamatapa nohuerahi −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Naraha Jesopa: —Tiadeni tinajipabaqquimanajo −najari pohuadenidsa. Naraha pohuadeni attipa: —Naraha pan 5, aba pama naha icajini. Denima icappirani −quinajari. —¿Nadsapa pohuadeni tapari odsa pananihuaji mittade jaijanijinerane? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aja madija Jesohuaji queriqquijaripa maqquideje 5 mil quinajarijine pocca dodosse tabaqquideni inajipabaqqui-manahijinepa pajiramana-jarajari. Naraha Jeso pohuadenidsa huati tajari: —Aja madija huapima jassi taridsahijine huati tinabaqquimanajo. Madija 50 naha tinequeriqquimana, ohuaha 50 naha tinequeriqquimana naridsadsa jassi jassi teri tinanaridsa-baqquimanajo, jipade najoraridsamanahijine. Nama tinanaridsa-baqquimanajo −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nadsapa nama inanaridsabaqquidsapa madija huapima jassi taridsajari. ");
INSERT INTO cul_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nadsapa Jeso pan 5 naha inacca, aba pamaha idsaba nadsa Jeso memehuaji tocattamacossa nadsa Diodsa huati tajari: —Jehe, epejeni. Ticca daniji iadsa bica tahi −najari. Nadsapa Jeso canahatori canajarijine pan, aba najari tohuapidsa icanabobiridsadsapa pocca dodosse tabaqquidsa da inabaqquijari. Pohuadenina aja madija jassi jassi teri najaridenidsa da inabaqqui-ridsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Da inabaqqui-ridsamanadsa jipamanadsapa accararidsa-manajari. Jipamanahissa taraha mota tojajari. Pan bobi, aba ime mota inaccaniridsa-manadsapa quiqui 12 naha ijiridsajari. ");
INSERT INTO cul_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nahi dsotodepa Jeso Diodsa huati tahijine pocca dodosse tabaqqui tedseje pohuadeni motta madija nohuerahihuaji jassi tajari. Nahidsa Jesopa pohuadenidsa huati tajari: —Madija otahimari huati huati nanaridsamana nadsapa ohuadsa attideni ¿nejecoma nejecoma quiquinanahi? −najari Jeso pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Naraha pohuadeni attipa: —Tiadsa madija motapa: “Huano Baotista tijani” quiquinanajari. Ohuahadenipa: “Maittaccadsamacca Dio Atti cacomerabote Eria tijani” quiquinanajari. Ohuahadeni naco: “Maittaccadsamacca Dio Atti cacomerabote ohuaha nahatonijari” quiquinanajari −quinajari Jesocca dodosse tabaqqui attidenipa. ");
INSERT INTO cul_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nadsapa Jeso pohuadenidsa huati tapomajari: —Naraha tiadenidsapi ¿nejecojari ojani? −najari. Nadsapa manaco Pedro huati tajari: —Tiapi Diocca dosseniji Cristo-Mesia tijani −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nadsapa Jeso attipa: —Jehe, bica tani. Naraha najaropi madija ohuahadenidsa tecomamanaccana −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesopa pocca dodosse tabaqquidsa denima huati huati tajari: —Aji ohuapi Madija Bedi ojajaroa nidsa dsotode najidsohue imeni ocasserani ohuanitohui. Jodiodeni ime jocohuideni, dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajaridenipa ohua ettajomananitohui. Nadsapi ohua inanadsoqque-mananitohui. Naraha ohua ppa idsamanaraha huada huatinimade tojari nadsapi Abi Dio ohua nahatonihitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nadsapa Jeso madija huapimadsa huati tajari: —Aji “Jesocca madija iquejenana” tiquinadsapi tiadeni tohuini tiquinanicca tohui tetideni ajimamanaji. Ohuadsara disseraqquiri tiquinaji. Madija tiadenidsa: “Ahua porimacossanidsa tidsoqqueji” quinadsa naco: “Jehe, odsoqqueni bica tani. Jeso onebo-jarahi” titidsanapomana nana huajijiradsa, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tiadenipi ticcadeni madie ohuadsa teccoramanadsapi madija tiadeni tonajicabaqqui-manaraha camittehe jiquejeranicca ticajimana-dsanaponitohui. Naraha madija ohuaha pocca madie ohuadsa acco tadsa ajijaro namidsa madi-dsanapohuijine tohuinira nadsapa dsoqquehitohui. Dsoqquedsapa camittehe jiquejeranicca caji-jarahitohui −najari Jeso atti. ");
INSERT INTO cul_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","—Madija naco ajijaro namicca biquehe tohuini madidsa, ajijaro dsamacca ima deni tojanicca tohuini madidsa naco huapima pohuadsa tojaraha Diotohui najaradsapa nidsa dsoqquedsa jororoni jiquejeranihuaji dsori tajarahitohui. Nadsapa pohua cajijaricca huapima ponima tojanitohui. ");
INSERT INTO cul_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nadsama aji tiadenipi madija ohuaha noppinedeni ticappinamanadsa: “Jesocca madija ojajerani” tiquinadsapi aji occa marinajadsa naqui: “Omittana onejerani” tiquineje camadsapi manaco ohuatti tiadenidsa: “Occa madija tiquejena-jerani” onanitohui. Ohuapi Madija Bedi ojajaroa nidsaranibote ajijaro namidsa occaronapomadsapi occa deni tojehema, occa Abi Dio ssiejenema, Diocca dodosse tabaqqui memehuajicca dacorehema occaronapomanitohui. Nadsana: “Onocco jidsa tani tiadenidsa” onanitohui. ");
INSERT INTO cul_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Naraha ohuapi pajissara tiadenidsa huati onajaro. Ajidsa tidomodeni huajaro motadenipi tidsoqquemana-jeraccadsama Diocca cacahuehe qqui tiquinanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jeso pohua tedsejemacca ima huati tapohui jicani huada 8 nani nattinipi ajijaro ima tojajaro. Jeso pocca Abi Diodsa huati tahijine ssonohuaji toqquemoradsapa Pedro, Huano, Satiaco quinajaridenira iaqquemorabaqquijari. Jai tojemoradsapa ssono tetepihuaji bacco tomoramanajari. ");
INSERT INTO cul_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nahidsa Jeso Diodsa huatide tojanaja pano todsibehihi najari. Pohua pano todsibehidsapa pocca etero naqui tonopo-po nadsapi todsibehijaro. ");
INSERT INTO cul_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nadsapa cattomama cananaja nahihuaji madija pamaha Jesodsa imahaha canajari. Najaridenipa Moisesi, Eria tedseje. Pohuadenipa maittaccadsamacca Dio Atti cacomeraqquiri najarideni Jesohuaji ahuatoma-manajari. ");
INSERT INTO cul_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pohuadenihuaji tossiajabaqqui najaro, Dio madihihuajicca ssiajani pohuadenidsa ahuatohuajanijaro. Jesopa madija huapimacca tabaccorehe manaconi tojahijine Jerosaredsa inanadsoqque-manahijinecca ima imahaha canajari Moisesi, Eria, Jeso quinadsa. ");
INSERT INTO cul_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Naraha Pedro, Huano, Satiaco quinajaridenipa cahadijabote, noccodeni ssire-re nadsa Jeso pohua ssiejene qqui, pohuadsa madija pamaha ahuatoma-manahi qqui toquinajari. ");
INSERT INTO cul_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisesi, Eria tedseje Jesohuaji tohuedanibote nadsa Pedro Jesodsa huati tahijineraha pohua bodi ssamo tadsa pohuama pohua attipa: —Ia Maride, iapi ajidsa iquejenadsa bica tani. Ticcadeni odsa huahuaqquide 3 canehe inahatona. Nadsapi tiadsa, Moisesidsa, Eriadsa cananijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro huati huati taja naraha essenipi pohuadeni tetepihuaji ccaronajaro. Ccaronadsapi pohuadenidsa ijihuajani nadsa cappinamana najari. ");
INSERT INTO cul_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nadsapa nahi esseni bodidsa atti qquenajaro: —Ajajaripa occa Ejedeni. Pohuadsa ohuati huana tajaro. Pohuapa madija Idinide tojahijine ocattejidsapojaride. Pohua atti timittamananissa taji −najari Dio. ");
INSERT INTO cul_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Najari atti jicadsapa qqui toquinanaja Jeso pohua motta hua canajari. Naraha Pedrodenipa pohuadeni qqui toquinajaricca ima ecomamana naccajaro. Madija ohuahadsa huati naridsamana-jaraccahi. ");
INSERT INTO cul_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Huada ssiaja ssonohuaji jai tojedsippanidsapa madija sibema Jeso bacco ijidsabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nahidsa madija ojaria Jesodsa huahua najari: —¡Ohua Maride, jari occa ejedeni qqui taccajo! Occa ejedeni ajajari ojarihi −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","—Tocorime pohua dama inadsa johua johua najari. Pohua bodi tossamodsapa pitora pitora nanaja nadsapa pohua ajari ssabojene tocca tocca najari. Tocorime pohua inajidsoja najari, apaja inana-jarahi. ");
INSERT INTO cul_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ticca dodosse tabaqquidsa huati onadsa: “Occa ejedeni tinanomimanajo” onaraha pajiramana-jarahi −najari imehi atti. ");
INSERT INTO cul_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nadsapa Jesoa: —Jaho, madija huapima Diodsa jehe tiquinanissa tejerani. Ajijaro namicca ima bica tejeranicca ticajimaneje najaro. Tiadeni mari mari ohocanabaqqui naraha ¿nejecoma nadsa ticahatterapadseje? Ticcadeni jeheniji pajiranissa tejeradsapi ohuadsa ocassera taraha ¿nema nehe onahana-dsanaponijinequi? −nanaja: —¡Jari, ticca ejedeni ohuadsa teccajonajo! −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Naraha ejedeni Jesohuaji tohuajiradsapa tocorimejine namidsa tohuedimajari. Pohuajine pitora pitora naraha Jeso pohua dosse ininejari. Pohua attipa: —¡Tocorime tabaccorabote! ¡Ejedeni tinebodsa tiqquenaji, onajaro! −najari. Nadsapa qquenadsa amadsati ejedeni tonomijari. Nadsapa Jeso ejedeni imehidsa inananijari. ");
INSERT INTO cul_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Nadsapa madija huapima jahijonajaridenipa jabojo quinaraha huatidsemanajari: —A, nama nahi qqui qqui inapo-jarade. Diocca nahatohuepi deni tojani −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Madija huapimapa Jeso ejedeni inanomihicca ima imahaha cananaja Jesopa pocca dodosse tabaqquidsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Aji ima huati huati onajaropi timittamananissa taji: Ohuapi Madija Bedi ojajaroa nidsa dsotode madija ojaria ohua ccaccoradsapa madija dsepedenidsa ojanitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Naraha pocca dodosse tabaqquipa aja Jeso huati huati tajari mittamanahissa tajarajari. Diojine Jesocca imapi ahuatora tajaro, mittamana-jaraccahijine. —¿Nejecoma tajaro? −quinahitohuiraha cappinamanadsapa Jesodsa huati toquina-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nadsapa Jesocca dodosse tabaqquipa pohuadenira imahaha canajari. Ahuaji huati, ahuaji huati quinadsa attideni ajama quinajari: —Aji ia huapimapi ¿nejecojarina deni tojajari? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Naraha Jesopa pohuadeni bodi nahato tapojari. Nadsapa ejedeni idi nadsa, pohua inoridsa inahua najari. ");
INSERT INTO cul_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nadsapa pohuadenidsa huati tajari: —Ajajari ejedenissa najaridsa tetideni huanaqquiri nadsapi ohuadsa naqui tetideni huanaqquiri najaro. Ohuadsa tetideni huanaqquiri nadsa naqui ohua Cadossede Abi Diodsa tetideni huanaqquiri najarossa najaro. Aja madija ejedenidsa huati huana tadsapa pohua tessedsa naco huati huana tajari. Najaripa madija huapimadsa acco camade dissera tadsapa pohua atti naco: “Ohuapi ajimani ojani, Diodsara ibora onani” nanaja najarina Diodsa bica tajari. Pocca ima bica tadsapi pocca deni tojehe pajissehecca ahuato tajaropaji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nadsapa Huano Jesodsa huati tajari: —Ohua Medsede, madija ohuaha tia oni hua nadsa madija bodicca tocorime madidsajari dosse ininehi qqui inade. Naraha pohuapa iadsa ccaridsa-jaradsa pohuadsa: “Epeje taji. Poni” inade −najari Huano. ");
INSERT INTO cul_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Naraha Jeso attipa: —Pohuadsa poni tiquinejeraji. Pohuapa occa ima inatabaccora-jerajaro. Madija nama najaripa iadsa huadi tajaradsapa ia acco camade tojajari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesopa memehuaji toccamacossanihijine tohuajiradsa huati tajari: —Jerosarehuaji occana. Ima ohuadsa oppina taraha nema nehe occana −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nadsapa dsama Samariacca odsa pamema nanihuaji huati toquinahijine Jesopa pohua tedsejema madija dosse inabaqquipojari: —Nanihuajicca odsadsa edacossanijine huati tiquinana −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nadsapa jai tojajari, bacco toquinadsa huati toquinaraha samaritanodenipa odsa dade jiperaqquiri najari. Pohuadenipa —Jesopa Jerosarehuaji toccahitohui −quinahi ima nahatoqquiri nadsa nahidsa Jeso huadahijine jiperaqquiri najari. ");
INSERT INTO cul_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Naraha pocca dodosse tabaqqui pamaha Satiaco Huano tedsejepa samaritanodeni atti: —Jeso ajadsa huadahijine jiperaqquiri inani −quinahi ima mittamanadsapa Jesodsa huati toquinajari: —Ia Maride, iapi memehuajicca jororonidsa jicahijine Diodsa huahua inana ¿jehe taqui? −quinajari. (Pina maittaccadsama Eriajine taminecca dodosse tabaqqui nama inanabaqquidsa jicajarissa inanabaqquina.) ");
INSERT INTO cul_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Attideni nama quinadsapa Jeso icattabaqqui nadsa pohuadenidsa huati tajari: —¡Nema tiquinejeraji, poni! −najari. —Occa tiquejenajaropi “manaco” inejerana.  ");
INSERT INTO cul_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ohuapi madija nanadsoqquede occajona-jerajaro. Madija onassiajabaqquihijinena occajonajarode  −najari Jeso. Nadsapa denicca odsa pamema najarodsana jai tojajari. ");
INSERT INTO cul_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jahui jai tojadsapa madija ojaria Jesodsa huati tajari: —Ohua Medsede, tiadsa occaridsana onajaro −najari. —Tiadsa occaridsadsapi tia onebo nejeranijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Naraha Jesopa pohuadsa huati tajari: —Ohuadsa ticcaridsanijine tipajira-jeranitide. Ajana dsohuadsohuapa odinedeni cajiridsamanahi. Ppiriri naco tadsarideni cajiridsamanahi. Naraha aji ohua Madija Bedi ojajaropi odsa ocappira, ohuadanijinecca huahuada ocappira nani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nadsapa Jeso madija ohuahadsa huati tajari: —Ohuadsa ticcaridsaji, tia naqui occa dossenijidsa tidsepe ijinijine −najari. Naraha pohua attipa: —Jehe ohua Medsede, occa abi huatiahi ppa odsahijine occa odsahuaji occanipoccana. Nidsa dsotodena tiadsa occaridsanijine ¿jehe taqui? −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Naraha Jeso pohuadsa huati tajari: —Madijapa Diocca camittehe cappiramanajarideni caji tahi. Pohuadenina poccadeni madija dsoqquedsa ppa idsamanahijine pajiramanahi. Naraha tiapi ohuadsa ticcaridsaji. Diocca cacahuehecca ima tecomeraridsanijine. Icca benehi inajorani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Madija ohuaha naco Jesodsa huati tajari: —Ohua Medsede, ohua naqui tiadsa occaridsana. Naraha tahidepi occa odsahuaji occaniccana. Nidsa nanihuaji occa madijadsa occanicca ima huati onabaqquiccana −najari. ");
INSERT INTO cul_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Naraha Jeso najaridsa naco huati tajari: —“Occa odsahuaji occaniccana” tadsapi Diocca cacahuehedsa tidsepe ijinijine tipajira-jerani. Najaro imapi pina bani ssitedecca imassa najaro. Madija bani ssite inahijine pocca bobadsa joca icanaraha pohua nattihuaji qqui tanidsapa bani ssite inajarahitohui. Bani ssite inahijinepa banihuaji paja tocattarihi nadsana bica tahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jeso pocca mamari tabaqqui mari icanabaqquia jicadsapa pohuadenidsa: —Odsa panani onihi onihi nanihuaji mari ocanabaqqui-ridsahijine −najari. Pocca mamari tabaqqui pohua tedsejema dosse inabaqquiridsapojari: —Madija otahimari mittamanapohuijine −nadsapa pocca mamari tabaqqui 72 quinaha Jeso icattejidsabaqquijari pohua tedsejema pama pama naha dosse inabaqquiridsapojari. ");
INSERT INTO cul_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nadsapa pohuadenidsa huati tajari: —Madija Dio jiraha madimanahi huapi taraha pohuadeni maridea huapi tajarahi. Pina huidsajacca ppa nahi bono jica-jarajarissa quinaraha poredea madija pama quinajari. Nadsapi huidsaja jinede Diodsa huati tiquinaji, Pohua Atti maride dosse inabaqquidsa bono porede tohuapihijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nadsapa denima huati tajari: —Jai tijabaqquiridsaji. Naraha aji tiadeni dosse onabaqquijaropi pina edede bedi dsomaji panahihuaji tiadeni dosse onabaqquijarossa najaro. ");
INSERT INTO cul_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jai tijaridsadsapi saco, dsiniro huahuadsa, sadaria naco tiaccamana tajarajo. Jahui jai tijadsa naqui “Ahuajicca madijadsa qqui ijidsaccana” tiquinejerana. Madija jahuidsa qqui tiquinadsa naco “Huati icanaccana” tiquinejerana. ");
INSERT INTO cul_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Madijacca odsadsa bacco tiquinadsa jai tijedsimadsa jinededenidsa huati tiquinadsapi ajima tiquinana: “Diocca jonehe tiadenidsa tojaji” tiquinana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nadsapa aja odsa jinede pajissa Diocca jonehe tohuini nadsa Diocca jonehe pohuadsa tojanijine. Naraha madija ohuahapa Diocca jonehe tohuini quina-jaradsapa epejena pohuadenidsa toja-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nadsama aja odsa jinede: “Aji occa odsadsa timadimanaji” nanaridsamana nadsapa nani poccadeni odsahuajira timadimanaccana. Odsa panani onihihuaji jai tija-jeraccadsapi odsa onihihuaji, onihihuaji ticahadijaridsa tejeraji, tijiparidsamana tejeraji, onajaro. Aji odsa bacco tiquinapojarodsara tiadeni totonajipabaqqui nadsa poccadeni dsamatapa titijipamana nana. Poccadeni passo, ahua bono ppejene ocassa tajari naco dse dse titiquina nana, onajaro. Nadsama madija Dio Atti maridera dsepe ijihissa tadsapa manaconi jirehe tiadeni totonajipabaqquimana nana. Aji tidsepedeni ijiridsamanadsapi najaropi ticcadeni marinaja manaconissa najaro. ");
INSERT INTO cul_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Odsa panani onihihuaji bacco tiquineje naridsaponi nadsapi nahicca madija: “Ticcadeni marinaja imittana” quinajarideni tiadenidsa: “Aja tijipamanaji” quinajaridenidsara titijiparidsamana nana. ");
INSERT INTO cul_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nahicca madija comaqquiri najarideni naco tinanomibaqquimanaja naridsapohui nana. Pohuadenidsa huati tiquinadsa naqui: “Tiadenidsa Diocca cacahuehepi huajira tani” titiquina nana, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jesopa pocca mamari tabaqquidsa denima huati tajari: —Nadsama odsa panani onihihuaji bacco tiquinadsa naqui tiadenidsa: “Ajidsapi timadimana tejeraji” nanaridsamana nadsapa jahui jai tijeqquimadsa pohuadenidsa ajima tiquinana: ");
INSERT INTO cul_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Tiadenipi Diocca cacahuehecca ima mittade jiperaqquiri tiquinadsapi epejena jaijeqquimanijine” tiquinana. “Tidsamaridenicca ssiqui emoridsa matajaro naqui catojanijine pporo inana, nani ticcadeni ibohue tibodideni huatoma-mananijine” tiquinana. “Naraha tiadenipi ¡timittamananissa taji! Diocca cacahuehe tiadenidsa huajira taraha...” tiquinana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ajina, nidsa dsama jicadsa Diopa dsama huapima ima manaconi huati tadsapa najaro odsa pananicca madija occa marinaja mittade jiperaqquiri nadsapa najidsohue imenidsa madimanahitohui. Ajina, maittaccadsama odsa panani Sodomacca madijapa imasiri sseqquiri nadsapa Diojine jicaridsapojari. Naraha pohuadenipa nidsa dsama jicadsapi poccadeni imasiri manaconipa najidsohue oppina tajaro pohuadenidsa tojanitohui. Naraha occa marinaja mittade jiperaqquiri najaridenidsana najidsohue denima oppina tanicca tojanitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—Jaho, madija odsa panani Corasinahuaji timadimanajarodenipi najidsohue oppina tanicca tiadenidsa ssonarinitohui. Jaho, madija odsa panani Besaidadsa timadimanajarodeni naqui najidsohue oppina tanicca tiadenidsa ssonarinitohui. Ticcadeni odsahuaji ocanahatori canani qqui qqui tiquinaraha tibodideni cacajiqquimerehe nejerade. Ajina, maittaccadsama odsa panani Tirohuaji madimanapojarideni tabaccoraqquiri najari. Aji odsa panani Sidohuaji madimanapojarideni naco tabaccoraqquiri najari. Pohuadeni huapimapa aji ocanahatori canani qqui toquinapo-jarajari. Nassa qqui toquinadsapa Diodsa toquejenahijine najomana-jarahitohuiraha. Poccadeni imasirijine bodideni ocassera tadsapa etero jidsa tanicca huedsamanadsa dsippo oconidsa jassi tadsa oji oji quinahitohuiraha −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—Naraha nidsa madija huapimacca ima cattemanijinecca huada bacco tadsa Dio Pohua baccohuaji tidomodeni huadsapi Tirohuaji madimanajaridenidsa Dio pocca najidsohue ajimani tojanitohui. Sidohuaji madimanajaridenidsa naco ajimani tojanitohui. Naraha tiadenidsana Dio pocca najidsohue denima oppina tanitohui. ");
INSERT INTO cul_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","—Jaho, madija odsa panani Capernaohuaji timadimanajarodeni naqui najidsohue oppina tanicca tiadenidsa ssonarinitohui. Dio memehuaji madijaridsa bacco tiquinadsa tiadenidsa Pohua Attipa: “Jehe, tiadenipi bicaqquiri tiquinani” ¿napadsaja? ¡Nama najarahitohui! Ticcadeni ibohuejinepi nami odini huaji tani jicaqquini nohueranihuaji tiadeni hua todsimahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Naraha denima pocca mamari tabaqquidsa huati huati tajari: —Tiadenipi otahimari tecomeraridsamanadsapi madija tettidenidsa jehe quinadsapa ohuadsa naco jehe quinajari. Nadsama madija ohuahadeni tiadeni tohuattajo-baqquidsapa ohuadsa naco huattajojo tajari. Ohuadsa huattajojo tadsapa aja ohua cadossejaridsa naco huattajojo tajari −najari Jeso atti, pocca mamari tabaqqui jai tojaridsahijine dosse inabaqquijaridsa. ");
INSERT INTO cul_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jesocca mamari tabaqqui 72 quinajarideni jahiqquinidsapa huatidsemaneri nanidsa Jeso pohuadsa huati toquinajari: —Ia Medsede, tia onima huati inadsapi Satanacca dodosse tocorime ettidsa iboraqquiri nadija −nanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nadsapa manaco Jeso pohuadenidsa huati tajari: —Jehe, ohuana Diocca huadi Satana memehuaji Diojine ssonaronahi pina ssissiedessa naronahi qqui onajaride. ");
INSERT INTO cul_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Occa dacorehe tiadenidsa onanaridsajaropi aja Satanacca dacorehe cajimanajaridenidsa tiadenina deni tiquejenanitohui. Nadsama oppina tanicca pina macca ttai tinanaqquimanadsa tiadeni cca todsa-jarahitohui. Dsorima ssidede naco ttai tinanaqquimanadsa tiadeni ttodi todsa-jarahitohui. Satana pohua, pocca dacorehe cajimanajarideni naco tiadeni tonajidsobaqquimana-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Naraha tocorime tettidenidsa iboraqquiri nadsa tetidsemanaraha najaro imapi ajimani. Ima denima bica taniccapi ajima nani: Occa madija tiquejenadsapi tiadeni onipi memehuaji Diocca papeodsa dsodo naridsani. Najaro imadsana denima tetidsemanaji, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Huati taha jicadsapa Jeso Dio Corimejine huatidseri nadsa Imehidsa huati tajari: —Jehe Abi, tiadsa ohuatidsejaro. Tiapi memehuaji madimanajarideni Cacahuade tija, namihuaji madimanajarideni Cacahuade tija najaro. Jehe, madija nahatoqquiri najaridenipa ajijaro dsamacca ima tocahatteraraha Tiadsa jiperaqquiri najari. Nadsama tijinepi ticca ima pajissacca mittamana-jarahijine pohuadenidsa ahuatora tinanajaro. Naraha madija motadenipa: “Iapi ssamoqquiri inajaro, pina ejedenissa inajaro. Dio, ia acco ticamabaqquiji, iatta naccaraho” quiquinanajari. Jehe, nadsama tijinepi ticca ima pajissacca mittamanahijine pohuadenidsana ahuato tinanajaro. Jehe Abi, ¡pajissa! Tia jipa tinadsapi tijine nema tinanajarode, onajaro. Nadsama tijinepi ohuadsa bica tani, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nadsapa pocca mamari tabaqquidsa huati tapomajari: —Occa Abipa ohuadsa pocca nahatohue huapima inanaridsajaro. Occa Abina pohua motta ohuadsa nahato tahi ojari najari. Occa Abipa nadsama Pohua ojari naha ohuadsa nahato taha nama najonajari. Ohuapi Abi Diocca Ejedeni ojani. Ohua naqui nadsama. Ohua ojari onehe Pohuadsa nahato onehe nema onajonajaro. Nadsama ohua Dio Bedi ojadsapi madijadeni ohuadsa toquejenajaripa pohuadenidsa jipa onadsapi ojine pohuadenipa Dio Pohuadsa noccodeni tojidserahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nadsapa Jeso pocca mamari tabaqqui icattabaqqui nadsa huati tajari: —Aji ohua ocanahatoriri canajaro tinoccodenidsa qqui tiquinaridsajaropi Dio tiadenidsa ima bicani inanajaropaji. Ohuapi madija Idinide ojeje najaro aji tiadeni tinoccodenidsa qqui tiquinajaropaji. Dio naco tiadenidsa ima bicani inanajaropaji. ");
INSERT INTO cul_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Maittaccadsama Dio Atti cacomeraqquiri najarideni, jodiodenicca taminedeni naco occa nahatohue aji jidapana tiadeni qqui tiquinajarocca qqui toquinahijine tohuini quinaporaha tahide tojicapodsapa qqui toquina-jarajari. Aji occa marinaja timittamanajarocca naqui najaro mittamanahijine tohuini quinaporaha tojicapodsapa mittamana-jarajari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jassi nahuajanidsa aja jodiodenicca marinaja maride pohua bodipa: —Jeso nattome onana −nadsa totehemadsa huati tajari: —Mamaride ¿nejecoma onadsa camittehe imadi-dsanaponicca bacco onanijine? −najari. ");
INSERT INTO cul_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Naraha pohuadsa Jeso huati tajari: —¿Nejeco ima hua hua tatte Diocca dosseniji dsodo nanidsa? Hua tadsapi ¿nejeco imara tiadsa ahuato tatte? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nanaja jodiodenicca marinaja maridepa Dio Atti ecomerajaro: —“Tiadeni Medsede Diodsa tetideni huanaqquiri naji. Tibodideni huatonissa tadsa, dacoco tijiradsa Pohuadsara disseraqquiri tidsanapomanadsapi Pohuadsa tetideni huanaqquiri nanijine. Tinorideniccadsa naqui tetideni huanaqquiri naji, pina tiadenidsa tetideni huanaqquiri najarossa naji” nade Dio Atti dsodo nanidsapi −najari jodiodenicca marinaja maride atti. ");
INSERT INTO cul_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nadsapa pohuadsa Jeso huati tajari: —Huati tinani bica tani. Nema tidsanapodsapi Diodsa timadinitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Naraha jodiodenicca marinaja maride pohua bodi attipa: —¿Nejecojaridenina ohuinoricca? Najaro Moisesicca marinaja Dio Atti dsodo nanipi ¿ohuacahuanissa tajaroqui? −najari. Nadsapa Jesodsa huati tajari: —Diocca dosseniji najarossa onananijineraha ¿nejecojaridenina ohuinoricca? −najari jodiodenicca marinaja maride. ");
INSERT INTO cul_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jodiodenicca marinaja maride attipa: —¿Nejecojaridenina ohuinoricca pohuadsa ohuati huana tanijine? −nadsapa Jeso manaco pohuadsa ajijaro ima huati tajari: —Jodiodeni ojariapa odsa panani Jerosarecca jahui odsa Jericohuaji toccanihuaji toccajari. Toccaraha... bobotidedeni dama quinadsa idaqquimanaha, huatiabote nadsa eterori ssiti quinehe jica nadsa jahui inorinidsa inebomanadsa jai tojanijari. ");
INSERT INTO cul_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Naraha dada toqquimadepa huati ajama canaha jahui toccanaja madija biquerajari ponacossahi qqui taraha toccarihuaja-dsanapojari. ");
INSERT INTO cul_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nahi dsotode naco dada toqquimade bijideni accode rehuitadeni quiquinanajari ojaria najaro jahui toccajari. Najari naco madija biquerajari ponacossahi qqui taraha toccarihuaja-dsanapojari. ");
INSERT INTO cul_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nadsapa madija ohuaha dsama onini Samariacca madija naco najaro jahui toccajari. (Aja Samariacca madijadenidsa: samaritano, quiquinanajari. Pohuadenipa jodiodeni tedseje ahuaji jipera ahuaji jipera quinajari.) Nadsapa samaritano quiquinanajari ojaria najaro jahui toccadsa madija biquerajari ponacossahi qqui tadsapa pohuatohui huati huana tajari, pocca madija jararaha. ");
INSERT INTO cul_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nadsapa samaritano uva bono ppejene ahua oquini icanejemadsa bobotidedenijine biquerajari ecanajijari. Pocca bejo jore inacossadsapa pocca bojodsa ibarijari. Nadsapa odsa onihihuaji iaccajari, nahidsa ecahuahijine. ");
INSERT INTO cul_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Naraha huada ssiaja samaritano toccabote nadsa odsa jinededsa ccarara denario capamehe dahaha icanajaro. “Coma tajari tecahuana. Nidsa occanipomadsa tiadsa aja tecahuajari manaconi mota tojadsapi da onapomanijine” nahi nade samaritano attipa −najari Jeso jodiodenicca marinaja maridedsa. ");
INSERT INTO cul_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Naraha Jeso pohuadsa denima huati huati taccajari: —Aja madija 3 quinajaripa dada toqquimade, Rehuita, samaritano quinajaridenipa ¿nejecojarina paja aja bobotidedenijine biquerajaridsa pina pohua inoriccassa najari? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nadsapa jodiodenicca marinaja maride ecomerajaro: —Aja madija biquerajaridsa huati huana tajarina paja −najari. Nadsapa pohuadsa: —Jehe, ticcanidsapi nema tidsanapoji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesopa pocca dodosse tabaqqui tedseje poccadeni benehidsa denima jai tojeqquimadsapa odsa capamema nanidsa bacco toquinajari. Nanidsapi amoneje onini Marta madijaro. Najarona Jesodsa huahua najaro: —Occa odsadsa timadiccaji −najaro. Nadsapa Jeso toqquedsimajari. ");
INSERT INTO cul_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martacca eso Maria naqui nanidsa madijaro. Jeso maride tojadsapa Mariapi pohua atti mittade huittajaro. ");
INSERT INTO cul_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Naraha Martapi ponicca odsa bica tocananijine, huapima jipaqquimanadsa bica tanijine dsapani ijiridsajaro. Dsapani jica-jeradsa ponidsa tonajoni nadsa Jesodsa huati tajaro: —Ohua Medsede, ohua motta occa odsadsa odsepe ijini. Ohuemecote ohua acco cama-jeradsapi ¿tiadsa bica taqui? Ponidsa huati tinaji, ohua acco camaccanijine −najaro. ");
INSERT INTO cul_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Naraha Jeso Martadsa huati tajari: —Marta, tiapi ticca odsa bica tocananijine, jijipa naco tinajoranijine najarotohuira teti huatojaro. ");
INSERT INTO cul_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Naraha ima onihina denima bica tajaro. Najarotohuina teti huatonijine bica tajaro. Mariapi ima denima bica tajarocca icattejidsajaro. Jehe, epejena. Ponipi occa marinaja mittana. Tiahuaji dosse onejerani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesopa pocca dodosse tabaqqui tedseje dsama onihihuaji maride ccaridsadsapa Diodsa huatide tojajari. Huatide jicadsa pocca mamari ojariapa Jeso pohuadsa huati tajari: —Jari, ia naqui Diodsa huati huati inanijine ia mari ticanabaqquiji, pina Huano pocca mamari tabaqqui mari icanabaqquijarissa tinanaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nadsapa Jeso pohuadenidsa huati tajari: —Diodsa huati tiquinadsapi ajima tiquinaji: “Jehe Abi Dio, iapi ticca ejedeni Tiadsa huati inajaro. Jehe, Tiapi nahatojide tijirani ojari tani. ¡Bica tinani! Madija huapima: ‘¡Dio, Tiapi deni tijani!’ quinana, inajaro. Ticca cacahuehe huapimadsa tinanaridsana, inajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Itapari naco huada huajijiradsa iadsa da da tajo. ");
INSERT INTO cul_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Madija iadsa tabaccorehe inanamanadsa poccadeni tabaccorehedsa: ‘Epejena, huadi onejerani’ inadsapi manaco icca tabaccorehe epeje tinanaji, Abi Dio. Icca tabaccorehe manaconi najidsohue iadsa tinana-jeraji, inajaro.” ");
INSERT INTO cul_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jesopa Diodsa huatide tocahatterahijine denima mari icanabaqquijari: —Ajima najaro imadsa tiadeni mari ocanabaqquina. Dsome nocconi titesse huaji tanicca bacco nadsa titapahijine nohueradsapa titesse tinoridsa madijaridsa huahua tajaro: “Otesse huaji tanicca bacco najonahi. Naraha otapari nohuerahi, pohuadsa da onahijine ocappirani. Ohuadsa pan huatimade tojari naha da tajo” tajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naraha odsa bodicca pohua cacomerajari: “Ohuadsa huahua tejeraji, noccobiji cahacossani. Occa ejedeni ohuinoridsa cahadijahi. Tiadsa da onahitohuiraha otehemanijine tojera tani” najari tinoricca −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Naraha tiadenidsa huati onajaro: Tinoriccapa titesseraha pohuadsa huahua tapodsapa qquena-jarahi. Naraha ticappina-jeradsa huade dissera tinadsana qquenahitohui. Qquenadsapa ticappiranicca tiadsa da inahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Nadsama ohuapi tiadenidsa huati onajaro: Abi Diodsa huati huati titiquina naji, onajaro. Dio Pohuadsa huati tiquinadsapi tiadenidsa ticcadeni huatinajassa nehe da inanitohui. Pina tohuini tanicca qquide dissera tinadsapi bacco tinanitohui. Najarossa najaroa Diodsa huatide dissera tinadsapi Pohuapa ticca huatinaja tiadsa inapajiranissa tanitohui. Pina madijacca odsadsa tiqquedsimanijine tohuini tadsa odsa jinededsa huahua tadsapi tiadsa noccobiji icatabojidsanitohui. Najarossa najaroa Diodsa huati huati tiquinadsapi ticcadeni huatinaja mittahi. ");
INSERT INTO cul_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","¡Pajissa! Madija Diodsa huati tadsapa Diopa pohuadsa pocca huatinaja da inanitohui. Madijapa Diodsa huatide dissera tadsapa Dio Pohuajine pocca huatinaja inapajiranissa tanitohui. Madijapa pina Diocca noccobijidsa huade dissera tajarissa nadsapa Dio pohuadsa noccobiji icatabojidsanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—Ajana, madijapa pocca ejedeni aba tohui huati tadsapa ¿pohua bedidsa macca da ina taco? Nohuerahi. Tiadenidsapa madija nama najari nohuerajari. ");
INSERT INTO cul_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Madija ohuaha pocca ejedeni tacara nappanitohui huati tadsa naco ¿pohua bedidsa dsorima da ina taco? Nohuerahi. ");
INSERT INTO cul_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tiadenipi tabaccorehe ticajimanaraha ticcadeni ejedenidsa bica tahicca dade nahatoqquiri tiquinani. Aji tiadeni naqui ticcadeni Abi Dio memehuaji madijaridsa huati tiquinadsapi tiadenidsa bica tahicca dade denima jipa tahi. Pohua Corime tohui tiquinadsa naqui Pohuadsa huati tiquinadsapi tiadenidsa da inahitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nadsapa madija pohua bodidsa Satanacca dodosse tocorime madidsajarijine ebeno siri tojajari. Atti cappiraha madijari. Naraha Jesojine ebeno siri bodicca qquenadsapa ebeno biquemanidsa atti cajipomajari. Nadsapa nahihuajicca madija qqui toquinadsapa: —A, bica tahi. ¡Jesopa nahato tahi! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Naraha nahihuajicca madija ohuahadeni pohuadsa pajissa quina-jaradsa mota attidenia: —Ajana, Jesopa tocorimedenicca tamine Beheosebocca dacorehe cajijarijinea pocca dodosse tabaqqui dosse ininebaqquijaripaja −quinaraha maidsamanajari. ");
INSERT INTO cul_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naraha mota bodidenia: —Jeso nattome inana. ¿Nejecojaricca dacorehe cajijari? −quinadsapa Jesodsa huati toquinajari: —Jari, pajissa Diocca dacorehe ticajidsapi memehuajicca nahatohue bicabote ahuato tinanaji. Qqui inana, inajaro −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Naraha Jesopa pohuadeni bodi nahato tajari. Pohuadeni bodi huatomanahijine pohuadenidsa ajijaro ima huati huati tajari: —Dsama huapimacca taminepa madija ecahuabaqquiraha dsotode pocca madija cahadiremanadsa ahuaji atti ahuaji atti quinadsapa pocca cacahuehe inassamomanajaro. Nadsapa pocca madija domo tocca tahi. Najarossa najaro odsa cajariecca madija cahadiredsapa poccadeni ima tossamodsapi tojaribaqqui tahi. ");
INSERT INTO cul_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ima najarossa najaroa Satanapa pocca dodosse tabaqqui madija bodidsa madidsamanajarideni dosse ininebaqquidsapa pina pohua pocca madija tedseje cahadirejarissa najari. Nama nadsapa pocca dossehe inassamodsapi sara tabaqquihitohuiraha. ¿Nadsapa pocca dodosse madija bodicca dosse ininehijine jipa taco? Jipera tahi. Aji ohuadsa tettidenipi: “Beheosebocca dacorehedsa pocca dodosse dosse tininejari” tiquinaraha najaropi pajissa jerani. Nassa najaro pajissa tojadsapi Satana pohua pocca dodosse tabaqqui inajaribaqqui-ridsahitohuiraha. ");
INSERT INTO cul_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ajina, ohuadsa: “Beheosebocca dacorehe ticajini” tiquinaraha ticcadeni mamari tabaqqui naco tocorime dosse dosse ihininebaqquimana najari. Naraha pohuadenipa ¿nejecojaricca dacorehedsa nama quinajari? Aja ticcadeni mamari tabaqquipa dacorehe cajimanadsa tocorime dosse ininebaqqui-manaraha pohuadenidsa: “Beheosebocca dacorehe ticajimanani” ¿tiquinattaqui? Nema tiquinejerani, onajaro. Nadsama ¿nejecotohui ohuadsa nema tiquinajaro? Tibodidenipi quejemama canajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","—Naraha ohuapi Diocca dacorehe ocajije najaro Satanacca dodosse tabaqqui dosse dosse ohoninebaqquiridsa najari. Nema onanadsapi tiadenidsa ahuato onanajaro: jidapana Diocca cacahuehe tiadenidsa bacco najonajaropaji, onajaro −najari Jeso atti. ");
INSERT INTO cul_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Nadsama Satanapa dacorehe cajiraha ohuapi deni ojajaro. Pohuapa ajamani, pina ajijaro ima tiadenidsa huati onabote najarossa najaro. Aja madija dacorajaripa dsepe cajidsa pocca odsacca huapima ecahuanissa tajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pohua bodipa: “Odsepe ocajidsapi daco ojirani” naraha madija ohuaha denima dacorajari bacco nadsapa odsa jinede dama inajari. Dsepecca equididsa jinede biji jore inadsapa pohua dsepetaji huapima inaccadsa da inabaqquijaro. Ima najarossa najaroa aji occa dacorehe deni tojadsapi Satana jore onaqquidsapa pocca dodosse tabaqqui dosse dosse ohoninebaqqui najaripaja −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nadsapa Jeso denima huati huati tajari: —Nadsama madija ohuadsa toja-jaradsapa occa huadi tojajari. Pohua naco madija ohuadsa toquejenahijine pohuadeni acco icamabaqqui-jaradsa pohuajine ohuadsa tohuajimanajari, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesopa ima onihidsa mari icanabaqquijari. Pohua attipa: —Nadsama tocorime ojaria madija bodidsa madidsaraha qquenadsapa toccajari. Aji dsama huamo tanihuaji, passo nohueranihuaji pohua madihijine qquide toccadsa qqui qqui naridsaraha pohua madihijine bacco tajarajari. Nadsapa: “Jehe, occa mamadi botehuaji occanipomana” najari tocorime atti. ");
INSERT INTO cul_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nadsapa ccanipomajari, bacco nanidsa madija pohua bodi tohuirehi qqui tadsapa pina odsa johue tocanehe huisso tocanajarossa najaro. ");
INSERT INTO cul_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nadsapa tocorime toccapomadsa pohua tessedeni tocorime 7 quinaha jina inanibaqquijari. Najaridenipa denima tabaccoraqquiri naraha pohua tedseje jai tojedsimajari, madimanahijine. Nadsama ima nema najaro madijadsa tojadsapi pocca madie tabaccora taporaha dsotodepi denima totabaccorajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nadsapa Jeso maride tojadsapa amoneje madija sibemadsa quejemajaropi jadsirema huahua najaro: —Jehe, ticca amidsapi ima bicani tojani. Ponipi bedi nahato tajari inanapidsapa huatidsehe cajini −najaro amoneje attini. ");
INSERT INTO cul_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Naraha Jeso huati tajari: —Jehe, naraha madijapa Dio Atti mittamanadsa najarossa inanamanadsapi najaridenidsana ima bicani tojanitohui. Huatidsehe naqui cajimanahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nadsapa Jesodsa madija toqueriqquija dsanapohui najari. Nanaja madija si tocajajari canadsa mari icanabaqquidsapa ajama najari: —Nadsama aja jidapana madija madimanajaridenipa tabaccoraqquiri nadsa ocanahatoriri cananijine tohuira huati toquinaraha occa nahatohue onahatona onejerani. Naraha ocanahatoriri cananicca ima ojariena ahuato onananitohui. Najaropi Dio Atti cacomerabote Jonasocca imassa najaro. ");
INSERT INTO cul_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Najaroa aji Jonaso pina huatiajarissa naraha Diojine tossiajadsa madipomajari. Pocca ima odsa panani Ninibehuaji madimanapojarideni mittamanadsapa: “Jehe, ajajaripa Diocca dosseniji, Dio Atti imittanijine” quinade. Najarossa najaro imadsa Diopa madija jidapana madimanajarideni inahattabaqquihitohui. Aji ohua Madija Bedi ojajaropi nidsa ohuatiadsa Diojine ossiajadsapi omadipomanitohui. Pina Jonasocca imassa najaro ohuadsa tojanitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Nadsapi nidsa madija huapimacca ima cattemanijinecca huada bacco tadsapi Dio Pohua baccohuaji tidomodeni huanitohui. Nanidsapi dsama Sebahuaji tamine amoneje madijaropi ticcadeni ima tiadenidsa inassonarinijine huati tanitohui. Poni attinipi: “Ohuapi dsama huaji tanihuaji omadiraha tamine Saromocca nahatohue omittanijine occajonade. Naraha tiadenidsa madijaripa denima nahato taraha pohua atti mittade iboqquiri tiquinajaro. Nema tiquinadsapi Dio tiadeni tohuattajo-baqquidsapa bica tani, onajaro” nanitohui Sebahuajicca tamine amoneje attinipi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Najaro huadadsa odsa panani Ninibehuaji madimanajarideni naco ticcadeni ima tiadenidsa inassonarimananijine huati toquinahitohui: “Iapi Jonasocca ima imittadsa ibodi cacajiqquimerade. Naraha tiadenidsapa Dio Atti cacomerabote deni tojajari madiraha pohua atti mittade iboqquiri tiquinajaro. Nema tiquinadsapi Dio tiadeni tohuattajo-baqquidsapa bica tani, inajaro” quinahitohui Ninibecca madija −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Nadsama jojororo naco toquehessidsapa ahuatora tanihuaji tocanajimahijine jarahi. Ssapotodsa naco boco icanahijine jarahi. Jojororo toquehessidsapa aja pohua cacahittari nahidsa cacahittari najari, nahi madija odsa bodihuaji jahidsimajarideni ssiajani cajimanahijine. Najarossa najaro Dio ssiejene tiadenidsa bacco teje nadsapi tibodideni tossiajaridsani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—Inoccopi essiredsa pina jojororossa najaro. Inocco bica tadsapi essire ssiajani ijini. Idsepedsa naqui damade nahato inajaro. Emoridsa naqui ccaridsade nahato inajaro. Icca tarabaidsa naqui ipajirajaro. Ibodi huatode naqui nahato inajaro. Naraha inocco bica tejeradsapi pina inocco dsidsi tajarossa najaro, issamo tani. Dama inanijine naqui ssamo tani, iccaridsanijine naqui ssamo tani, icca tarabaidsa naqui ssamo tani. Imapi najarossa najaro tibodidenidsa Dio ssiejene toqquedsimadsapi tibodidenidsa ssiaja taridsani. Naraha Dio ssiejene toqquedsima-jeradsapi tibodidenidsa pina dsidsini ijiridsajarossa najaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—Aji tiadenipi: “Nahatoqquiri inani. Ibodi ssiaja tani” tiquinadsapi ¡paji! onajaro. Najaro ssiajanipi occa imassa nejeradsapi ssiajani ticajimana-jerajaro. Dsidsini oppina taniccadsana timadimanajaropaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Naraha tibodidenidsa Dio ssiejene ijidsapi, aji dsidsinicca ima oba tanicca tibodideni tecahuamana-jeradsapi, otahimari Diocca ima tibodidenidsa ahuato tanissa tanitohui. Pina jojororo ssiejene tiadenidsa tossiajabaqquijarissa nahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesopa madija mari icanabaqquia jicadsapa marinaja pariseodsa jehe najari ojaria Jesodsa huati tajari: —Occa odsahuaji tijipanijine ticcajonaji −najari. Nadsapa Jeso najaricca odsadsa toqquedsimajari. Jipahijine huahuanaridsa huittarijari. ");
INSERT INTO cul_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nadsapa pariseopa pohua dsepe ssahua najari, —Oppina tahicca bara onahitide −nadsa. Nama nama quiquinanajari marinaja onini pariseodsa jehe quinajarideni huapima. Naraha Jesopa pohua dsepe ssahuarahi huittaridsa pariseo qqui tadsapa huajo najari. ");
INSERT INTO cul_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Naraha pohuadsa Jeso huati tajari: —Marinaja pariseodsa jehe tiquinajaro, ticcadeni madiepi pina dsedse, parato huapihuajira ssahua ssahua tiquinajarissa najaro. Naraha tibodidenina pina dsedse parato bodihuaji ssahuarahi oba tajarissa tiquinajaro. Tibodidenidsa tibotimanajarocca ima ijijaro. Tohuini tiquinajarocca ima naqui ijijaro. ");
INSERT INTO cul_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ssamoqquiri tiquinani! Diopa essire nemanehe inahatojaro. Pohuapa ¿ibodi nahato tajaraco? Ibodi nahato tahi. ");
INSERT INTO cul_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nema nadsapi ticcadeni tabaccorehe tinebomanaji, tibodideni tohuirenijine. Nadsapi maidsehedsa dsiniro denima tiadenidsa totoja nejeranijine. Madija tohuati nahanaqquiri najarideni naco acco acco titicanabaqquimana najo. Nadsana ticcadeni madie naqui tobicanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Jaho, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Ticcadeni odsa inorinicca ppa nahi dsamatapa quequejema majo bica tajari pore tiquinadsa naco badsira taraha mota Diodsa da da titiquina najari. Najaro ticcadeni marinaja ajimaniccaraha tecahuamananissa tajaro. Naraha Diocca dosseniji deni tojaniccapi tecahuamana-jerajaro. Diocca dosseniji deni tojaniccapi madija ticamaidsabaqquimana-jaradsa tettideni pajiranissa tanijine. Diodsa naqui tetideni huanaqquiri nanijine. Jehe, najaro dosseniji tecahuamana-jeradsapi ticcadeni ima dsori tajaro. Aji ticcadeni odsa inorinicca ppa nahi mota Diodsa da da titiquina najari bica tahi naraha najaro dosseniji ajimanicca aji Diocca dosseniji deni tojanicca tadsajani tecahuamanaji, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Jaho, marinaja pariseodsa jehe tiquinajaro, tiadenipi huahuattajo tiquejenanitohui. Ticcadeni Dio Atti mamarihuaji jassi tinarinijinepi deni toquejenajaridenicca huihuittari tohuini titiquina najaro. Aji dadahuajicca jahuidsa jai tijaridsadsa naqui madija tiadenidsa: “¿Nija, bica tinani? Tiapi deni tijani” quinahijine naqui tohuini titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Jaho, tiadenipi huahuattajo tiquejenanitohui. Tiadenipi pina madija ppa todsahibote noccobiri tohuatorajarossa tiquinajaro. Madijapa najaro tonoccobiri tetepihuaji jai tojeqquimadsapa madija nahidsa ppa todsaraha ssamoqquiri nahi. Nama quinadsapa ima oppina tanicca pohuadenidsa tojajaro. Madija tiadeni qqui toquinadsapa pina bicaqquiri tiquinajarossa naraha tibodidenicca tabaccorehepi ssamoqquiri najari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Naraha jodiodenicca marinaja maride ojaria Jesodsa huati tajari: —Mamaride, tetti nema nadsapi iadsa naqui ima tinahanajaroa −najari. ");
INSERT INTO cul_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Naraha Jesoa: —Jehe, jodiodenicca marinaja maridedeni tiadeni naqui huahuattajo tiquejenanitohui. Tettidenipi: “Diocca dossenijidsa ajima tiquinaji” tiquinaraha ticcadeni marinaja najo taniccara tinaharimanajaro. Nadsapi tijinedeni ima toccanajani najaro. Najaro imapi madija ecahuamananijine pajiramana-jarahi. Tiadeni naqui najaro ima madija ecahuamananijine acco ticamabaqquimana-jarahi. ");
INSERT INTO cul_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—Jaho, tiadenipi huahuattajo tiquejenanitohui. Tiadenipi Dio Atti cacomeraqquiri napojarideni noccobirideni tetepidsa siba hua tinamaromanajaro, “Poccadeni ima bica tade, eti ajima-jerana” tiquinadsa. Naraha najaridenipa ticcadeni ididenijine jicaridsajari. ");
INSERT INTO cul_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Pohuadeni noccobiri tetepidsa siba hua tinamaromanadsapi pina ticcadeni ididenicca imadsa jehe tiquinajarossa najaro. Pohuadenijine Dio Atti cacomeraqquiri najarideni jicaridsajari. Tijinedenina pohuadeni noccobirideni nahatoridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Nadsama Diopa Pohua bodi nahato tapodsapa ajama najari: “Madijadenidsa Ohuatti cacomeraqquiri najarideni dosse onabaqquihitohui. Occa dodosse tabaqqui naco pohuadenidsa dosse onabaqquihitohui. Naraha motapa inajicamanahitohui. Motana jicahijine itaqquidso-ridsamanahitohui” napohui nade Dio. ");
INSERT INTO cul_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nadsama aji jidapana timadimanajaropi tiadenidsa najidsohue imeni ssonarinitohui. Aja dsama inahatopodsama Pohua Atti cacomeraqquiri najarideni tojicadsa emenedeni toccajaro manaconedeni tiadenidsa ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Aja tahidepa Abeona pohua ohuahajine dsoqquepojari. Najari emene toccapodsama aja Dio Atti cacomeraqquiri najarideni naco inajicamanaja najonapohui najaria aja Sacaria inanadsoqque-manahi bacco najonajaropaji. Sacariapa Diodsa dada toqquima bacconihuaji aji Diodsa da tahijinecca huahuanari inorinidsa inanadsoqque-manajaripaja. Jehe, pajissara tiadenidsa huati onajaro: Aja Dio Atti cacomeraqquiri najarideni huapima jicajonajari manaconedeni jidapana timadimanajarodenidsa Diojine najidsohue ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Jodiodenicca marinaja maridedeni tiadeni naqui huahuattajo tiquejenanitohui. Dio Atti madija mari ticanabaqquimanahissa tadsapa madija Dio Atti tocahatterahijineraha. Dio Atti mari ticanabaqquimanahissa tajaradsa, ticcadeni marinaja najo tanicca tinaharimanadsa naqui tijinedeni madija Dio Atti tocahattera-jarajari. Nema tiquinadsapi pina Diocca cacahuehecca noccobiji ticahacossamanajarossa najaro. Nadsapa madija Diocca cacahuehedsa jai tojedsima-jarajari. Tiadeni naqui pocca cacahuehedsa jai tijedsima-jerajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesopa poccadeni ima huati taha jicadsapa najaro odsadsa toqquenadsa toccajari. Naraha jodiodenicca marinaja maridedeni pariseodeni tedsejepa poccadeni ima acconi huatideni jamimanajari. Nadsapa najaro huadadsa Jesocca ima tossamonijine ima idimamanadsa huada huajijiradsa pohuadsa ima onihidsa huati, ima onihidsa huati dsanapomanajari. ");
INSERT INTO cul_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jeso ima bica tejeranicca ecomeranijine tohuini quinadsa pohuadsa huati huati dsanapomanajari. Pohuadsa ima inassonarimananijine disseraqquiri naraha Jesopa ima pajiranissa taniccara ehecomera najaro. ");
INSERT INTO cul_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Isaraeri potemahi jodiodeni mota marinaja pariseodsa jehe quinajaridenipa Jesocca marinaja inassamomananijine disseraqquiri naraha madija Jeso pocca marinajatohui queriqquidsapa denima tohuapi, denima tohuapi najari. Madija panahicca tohuapihi dsanapodsapa pohuadeni amori ahuaji ttai, ahuaji ttai quinajari. Naraha nahidsa Jesopa pocca dodosse tabaqquidsana tahide huati tapojari: —Pariseodenipa mamaidsamana najari. “Dio Atti cacahuade iquejenani” quinaraha poccadeni marinaja Moisesicca marinajadsa inaharimanajaro. Poccadeni madie naqui Dio Attissa nejerani. Poccadeni ima najimehecca caji tani. Najaro poccadeni marinaja, poccadeni madie maidsehecca totojaribaqqui najaro. Pina pan ssaja tahijine quequejemacca imassa najaro. Paji, poccadeni imassa tinanamana-jeranijine dacoco tijiraji. ");
INSERT INTO cul_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nadsama madija huapima poccadeni maidsehecca imapi inajimamanaraha nidsa dsotodepi ahuato tanitohui. Ima ahuatora tanicca huapimapi ahuatomanitohui. Aji ima bicani ahuatora tanidsa inanamanajaro, aji ima bica tejeranicca ahuatora tanidsa inanamanajaro naqui ahuato tanitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nadsama dsome ima huati huati tiquinadsa naqui nidsa dsotodepi ssiajanidsana ticcadeni imapi ahuato tanitohui. Odsa coba canahuajanini bodidsa ima ojidsa huati huati tiquinadsa naqui dsotodepi amossinihuajina madija huapima mittamanahijine ticcadeni ima madija ohuahana jadsirema ecomeramananitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Nadsama otessedeni, ohuatti tecomeraridsamanadsa ticcadeni madiepi pina occa marinajassa tinanamanadsapi madija ohuahadenipa tiadenidsa: “Jicana, jicana” quiquinanadsapa ticappinamana tejerana. Madijapa tiadenidsa: “Jicana” quinadsapa timedeni jicanijine pajiramanaraha tijicani nattinipi tiadeni tonajidso-baqquipomahijine ssamoqquiri nahi. Aji jororoni jiquejeranihuaji tiadeni hua todsimabaqquihijinepa ssamoqquiri nahi. Nadsama tiadenipi pohuadenidsa ticappinamana-jeraji, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Naraha Diodsana ticappinamanaji. Pohuapa: “Tijicaji” nadsapa tijicanitohui. Najarina tijicani nattini naco tiadeni tonajidso-baqquihijine nahato tajari. Pohuapa aji jororoni jiquejeranihuaji tiadeni hua todsimabaqquihijine naco nahato tajari. Madijadsapi ticappinamana tejeraji naraha Diodsana ticappinamanaji, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","—Diopa madija huapimacca ima nahato tajari. Aji titatideni conani huapima onini huade naco nahato tajari. Diopa dsama huapimacca cacahuade nahato tajari. Ajina: “Ppiriri mitta onana” tiquinadsapi ppiriri da da quinahihuaji dsiniro bedenidsa ppiriri mitta mitta titiquina najari. Ppiriri 5 nahapa ccarara capamehedsa mitta mitta titiquina najari. Naraha ppiriripa huati ccarera tahiccaraha Diopa ppiriri naco ecahuabaqquijari. Ppiriri naco pohua dsoqquehicca huada bacco tejeraccadsapi dsoqque-jaraccahi. Nadsama tiadenipi ticappinamana tejeraji, onajaro. Ppiriripa ajamani toquejenaraha Diopa pohuadeni ecahuabaqquijari. Naraha Diopa tiadenidsana denima huati huana tajari. Tiadeni tohuacahua-baqquihissa tahitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Nadsama ohuapi tiadenidsa huati onajaro: Madija ojariapa madija ohuaha mittamanahijine pohua cacomeradsa: “Ohuapi Jesocca madija ojani” nadsapa manaco ohuapi Madija Bedi ojajaroa Diocca dodosse tabaqqui memehuajicca mittamanahijine pohuadenidsa ohuacomeranitohui: “Ajajari madijapa occa madija tojahi” onanitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Naraha madijapa madija ohuaha mittamanahijine pohua cacomeradsa: “Ohuapi Jesocca madija ojajerani” nadsapa manaco ohuapi Diocca dodosse tabaqqui memehuajicca mittamanahijine ohuacomeranitohui: “Najaripa occa madija jarahi” onanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Aji ohua Madija Bedi ojajarodsa madija atti atti quinadsa ohua itamassomanaraha nidsa dsotode: “Icca ima inebona” quinadsapa poccadeni imasiri, poccadeni tamassohue Diodsa ecomeramanadsa Diopa poccadeni imasiri epeje inananitohui. Naraha Dio Corime itamassomanadsa, pohuajine tojajarodsa maidsehe huahua quinadsa naco Diopa pohuadeni atti huati ajama-jarahitohui. Poccadeni imasiri epeje inana-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Naraha jodiodenipa nidsa otahimari tiadenidsa tojajaro acconi huadimanadsapa poccadeni Dio Atti mamarihuaji tiadeni tohuaqquedsimabaqqui-manahitohui. Tiadeni tonajidso-baqquimanahijine ima cacattemadedenihuaji, taminedenihuaji naqui tiadeni tohuaqquedsima-baqquimanadsapa ticcadeni ima tecomeramananijine ¿nejecoma onapadseje? tiquinejerana. Occa marinaja tecomeramananijine naqui ticappinamana tejerana. ");
INSERT INTO cul_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Nani pohuadeni tedsejema terimanadsa huati tiquinanijinepi Dio Corimena tiadeni tonahattabaqquihitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nadsapa aja madija panahicca ojaria Jesodsa huati tajari: —Mamaride, occa atodsa huati tinaji. Aja occa abi dsoqquejari dsepetajibote mota ohuadsa pohuadsa nanijine. Occa atodsaha ojari nani −najari. ");
INSERT INTO cul_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Naraha manaco Jeso attipa: —Otesse, ohuapi ticca abi dsoqquejari dsepetajibote ticca atodsa, tiadsa nanijine cacahuade ojajerani −najari Jeso pohuadsa. ");
INSERT INTO cul_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nadsapa Jeso huapimadsa huati tajari: —Paji, todsepetaji acconi tedimana tejeraji. Tibodideni tecahuamanaji, aji tidsepedeni tossenijine tohuira tibodideni huato-jeraji. Najaro tidsepetaji huemadsa tetidsemanehe timadimanani ojari-jerani. Diotohuira timadimananina bica tajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nadsapa Jeso pohuadenidsa ajijaro namidsa imadinicca ima huati tajari: —Madija dsepe sse tajari nami bicani cajidsapa pocca huidsajacca porede toquejenadsapa huemahi pore pore quiquinanajari. Aroso jidsadsa trigo mota totoja najari. ");
INSERT INTO cul_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nadsapa dsepe sse tajari bodipa: “¿Nejecoma onanijine? Occa huidsajacca trigo mota cacahuahijine odsa onihi ocappirani” najari. ");
INSERT INTO cul_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nadsapa pohua bodi huatojari: “Jehe jidapanana nahato onani. Occa trigo huadsaridsajaricca odsara otaboridsadsa denima ojine odsa motaraqquiri naridsana. Nani najarodsana occa trigo, aja huapima ocajijaricca ohuacahuaridsahijine” najari. ");
INSERT INTO cul_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pohua bodidsa naco: “Nadsapi aji ohua otahimari huati onanijine: Jehe, jidapapi sse onani. Huajano huapi taha omadinijine opajirani. Jehe, nadsapi pina jassi onana. Pina ojipa, dse onajaro ohuatidseri ohuatidseri naridsana, onanitohui” najari. ");
INSERT INTO cul_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Naraha Diopa pohuadsa huati tajari: “Tiapi ssamo tinani. Ajijaro dsomedsa tidsoqquenitohui” najari. “Aja tidsepetaji, aja huidsajacca bonoma tecahuaridsajaripa tidsoqquedsapi ¿tiadsa nama dsanapopadsaja? ¡Nohuerahi! Tidsepetajipa madija ohuahadsana tojaridsahitohui” najari Dio. ");
INSERT INTO cul_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Imapi nema najaro madija pohua tonanabicahijine todsepetaji inehemaraha Diodsapa pina cappirajarissa najari, Diodsa huatidse-jaradsa −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nadsapa Jeso pocca dodosse tabaqquidsa huati tajari: —Tiadenidsa ohuattipi: Timadimananijinecca ticappiramanani noppineni ticappinamana tejeraji, onajaro. Pina ¿nejecora ojipapadseje? ¿Nejecora ohuedsapadseje? tiquinejeraji. Najarotohuipi tibodideni huahuatomacca nejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Icca madiepi dsamatapaha ojari-jarahi. Icca madiena denima bica tajaro. Essire naqui etero edsanijinea ojari-jerani. Essirecca imana denima bica tajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—Jari, tosicocca imadsa tibodideni huatoma-manaji. Tosicopi huidsajacca ppa nahi pperaqquiri, huidsajacca ppa nahi bono poreraqquiri nadsapi nidsa dsotode jipamananijine ppa nahi bono naco odsadsa ecahuamana-jarajari. Naraha Diona ponidenidsa jipamananijine da da ihinanajari. Diopa tosicodenidsa huati huana taraha tiadenidsana denima huati huana tajari. Tiadenidsa naco tijipamananijinecca da da ihinanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Naraha tiadenipi ¿nejecotohui tibodideni: ¿Denima omadi-dsanapopadseje? tiquinajaro? Najarotohui tibodideni huahuatomacca nadsapi ¿ticcadeni madie denima tinanamananijine nahatoqquiri tiquinaqui? ¡Nahatoqquiri tiquinejerani! ");
INSERT INTO cul_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Najaro nahatohue ssamoqquiri tiquinaraha Diodsapi najora tani. Nadsama ¿nejecotohui ima onihitohui, ima onihitohui tibodideni huahuatoma najaro? Pina Dio tiadeni tohuacahuabaqqui-jarajarissa najari. Naraha “Jehe, Diona nahato tahi ia cacahuabaqquihitohui” tiquinana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—Jari, qqui tiquinanaja mohue ppata taridsajari. Naraha mohuepa tarabaidsera, huepe picocora, etero ssequiquira taraha ppata taridsadsapa pina etero bicani huedsamanajarissa najari. Ajana maittaccadsama naco Isaraeri potemahidenicca tamine Saromopa dsepe ssejide radsapa etero bicani huatini ccara tanicca huedsadsapa bica tataja naraha mohuena denima bicaqquiri najari. ");
INSERT INTO cul_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","¡Jaho, ticcadeni jehenijipi badsira tani! ¿Nejecotohui tiadenipi “Dio ia tohuacahua-baqquihi” tiquinejerani? Ajina, dseropi etero huedsanijine cappiraraha Diojine poni mohueni cajidsapi pina etero bicani huedsajarossa nani. Dseropi mohueni cajini bica taraha huada huada huada nadsa dseqqueri nadsapi botta ina tani. Naraha dseropi ajimanicca. Tiadenipi pina aji dserossa tiquinejerani, Diocca cacatidse tabaqqui tiquejenajaro. Nadsama Diopa tedsamananijinecca etero naqui denima tiadenidsa da inanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Naraha tiadenipi ticappinamaneri naridsa-jeraji. “¿Nejecora ojipapadseje? ¿Nejeco dsamatapa ppejenera dse onapadsaja?” tiquinejerana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ajijaro dsamacca madija Diodsa toquejena-jarajarideni huapimapa nama nama nanaridsamana najari. Poccadeni jijipa tohuira pohuadeni dsepetaji tohuira bodideni huahuatoma-mana najari. Naraha tiadenipi Abi bicahi ticajimanani. Pohuapa ticappiramananicca huapima nanahato najari. ");
INSERT INTO cul_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Diocca cacahuehecca imadsa tibodideni huatomaridsanijine Diotohuira tataridsamana naji. Nema tiquinadsana Diojine ticappiramananicca tiadenidsa inanaridsanitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Nadsama tiadenipi occa edede, occa cacacahua tabaqqui tiquejenajaropi ticappinamana tejeraji. Aji tiadeni ohuacahua-baqquijaropi tipamema naraha occa Abipa tiadenidsa: “Aji occa cacahuehepi tiadenidsa onanajaro” najari. ");
INSERT INTO cul_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nadsama ohuatti tiadenidsa ajima najaro: Tidsepedenitaji manaconitohui da tinaridsamanaji. Najaro manaconi dsiniropi madija cappiramanajaridenidsa da tinabaqqui-ridsamanaji. Aji tidsepedenitaji, dsiniro naqui ¿nejecodsara tecahuamanadsa ticajimana-dsanaponijine? ¿Aji dsiniro dsamini totabaccorarera tanicca caji taqui? Nohuerani. Naraha cappiramanajaridenidsa da tinabaqquiridsa-manajaropi pina memehuaji aja Dio madihidsana ima bicani tiadenidsa tinahapimanapojarossa najaro. Najaropi Diocca daniji bicabote jiquejeranicca tiadenidsa da inanitohui. Najaro Dio pocca danijidsapa bobotide botihijine nohuerahitohui, poni maccanijine naqui ssari nanijine nohuerani. ");
INSERT INTO cul_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ajina, tiadenipi ajijaro namicca todsepetaji tohui, dsiniro tohuira timadimaneje nadsapi najarodsara tetidseridsamanajaro. Naraha Dio Pohua tohuini nahicca tohuira timadimanadsapi Diocca danijidsana tetidsemananitohui, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jesopa pohua ccaronapomahitohui najoramanahijine mari icanabaqquijari. Pohua attipa: —Tiadenipi tinajoramanaji, pina madija pohuadeni medsede cajicajicca ejetehuaji toccadsa “dsome bacco nanihitohui” quinadsa poccadeni etero huedsamana, jojororo iquehessimana nadsa najoramanajarissa tiquinaji, onajaro. Ajana pocca dodosse tabaqqui pohuatohui najoramanadsa bacco nanidsapa noccobijidsa coba coba nadsa amadsati icatabojidsamananitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Dsome nocconi bacco nanihitide, ssiajajonadsa itide ssamoqquiri naraha noccodeni bissadsa pohuadeni medsede bacco nanidsapa pohuadenipa ima bicani cajimanahitohui. Pajissara tiadenidsa huati onajaro: Pohuadeni medsede pohuadenidsa huatidsedsapa: “Huahuanaridsa jassi tahuajaniji” nahitohui. Nadsapa jipamanahijine pohuana taparideni dsojo dsojo nahitohui, pina poccadeni dodossessa nahijine. ");
INSERT INTO cul_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Nadsama tiadenipi ajijaro imadsa tibodideni huatoji: Odsa jinedepa bobotide ccajonahijinecca maji nahato tapodsapa pocca odsadsa botide qquedsima-jarahijine pocca odsa ecahuanissa tanitohuiraha ssamo taja najari. ");
INSERT INTO cul_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Naraha tiadenipi tinajoramanehe timadimanaji. Madijapa ohua Madija Bedi ojajaroa occaronapomanicca huada ssamoqquiri nahi. Nidsa huatideni ajamama canadsa bacco onanipomanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nadsapa Pedro huati tajari: —Ia Maride ¿aji titohui inajorehe imadinijinecca ima huati huati tinajaropi iadsaha ojarinijinequi? ¿Madija huapimadsarane? −najari. ");
INSERT INTO cul_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43","Nadsapa Jeso pohuadenidsa ima onihi huati tajari: —Madija dsepe ssebotepa huaji tani toccahijine najoradsapa pocca dodosse ojariadsa huati tajari: “Occa madija tecahuabaqquina. Jipamanahijine bacco tadsa pohuadeni tapari da da titinabaqqui nana” najari. Nadsapa dsepe ssebote toccajari. —Nadsapa pocca dodosse nahato tadsa, ibora tadsapa madija ecahuabaqquihissa tahitohui, pina pohua dossede attissa inananitohui. Nama nadsapa dsepe ssebote ccanidsa qqui tadsapa pocca dodossedsa ima bicani inananitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nadsapi pajissara tiadenidsa huati onajaro: Madija dsepe ssebotepa pocca dodosse ibora tajaridsa ajama nahitohui: “Tiapi occa odsa, occa huidsaja, odsepetaji huapima tecahuaji” nahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","—Naraha dsepe ssebotecca dodosse tabaccora tadsapa pohua dossede attissa inana-jeranitohui. Pohua bodi attipa: “Ohua dossede ccanihijine najoccahi, qqui tajarahi” nahitohui. Nadsapa pohua dossedecca dodosse tabaqqui maqquideje inajidsobaqqui, amoneje inajidsobaqqui nahitohui. Jipadera ccaridsadsa coma tanicca dse dse naridsadsapa comani ahahua nahitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pocca dodosse tabaccorabotepa pohua dossede ccanihicca maji, huada ssamo tadsa pohuatohui najora-jarajari. Nama nanaridsa nanaja dsepe ssebote bacco nanidsapa pocca dodosse inajidsohuitohui. Dsoqquedsapa iboqquiri najaridenihuaji inanahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Jehe madijapa pohua dossede atti nahato taraha pohua attissa inananijine ibo tadsapa nanajidso inahananitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Naraha madija ohuahapa pohua dossede atti ssamo tadsapa pohuajine bica tejeradsapi cossi cossi inebo nahitohui. Jehe, Dio naco madijadsa dosse dosse najari. Pocca dossenijissa inanadsana bica tani. Diopa iadsa: “Occa madija tecahuabaqquina” nadsa pocca madija ecahuabaqquihissa tadsana bica tani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Nadsama ajijaro namidsa occaronajaropi pina dsippo diji tajarossa onanadsa madija huapimadsa ssonariridsanijine. Nidsa imasiri manaconi ojanijinepi Diocca najidsohue madijadsa ssonariridsanitohui. Jaho, najaro ima jidapana ohuadsa toja naccaraho, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aji ohua imasiri manaconi ojanijinepi najidsohue imeni onahanaccanitohui. Najaro imapi nahato onaraha najaro ima ohuadsa toja-jeraccadsapi aji nacassera onajaropaji. ");
INSERT INTO cul_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tiadenipi tibodideni: “Jehe, Jesopa ajijaro namidsa jonehe tojaridsanijine ccajonajari” ¿tiquinajaroqui? Naraha ohuapi najarotohui occajona-jerani. Madija motapa ohuadsa jehe quinajari, madija motapa ohuadsa jehe quina-jaradsapa pohuadenira pohuadenira naridsamanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Aja jidapana naco odsa cajariecca madija 5 quinajari pamahapa pohuadenira, huatimade tojari najaripa pohuadenira quinajari. Nama quinajaripa cahadire cahadire naha nama dsanapomanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nadsama ojine madija pohuadenira pohuadenira quinadsapa ajima nanitohui: Dsabissopa imehidsa huahuadi nahitohui. Imehipa bedidsa huahuadi nahitohui. Imenipi bedenidsa huahuadi nanitohui. Bedeni naqui imenidsa huahuadi nanitohui. Massodinipi jinomadinidsa huahuadi nanitohui. Jinomadini naqui massodinidsa huahuadi nanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesopa madija huapimadsa ima denima huati huati tajari: —Maji toccahihuaji meme esseni caji tani qqui tiquinadsapi: “Passo ccabote nani” titiquina najaro. Nadsapi nema neneje najaro. ");
INSERT INTO cul_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dsama napicossanihuajicca jojode jojo najonani qqui tiquinadsa naqui: “Icca dsamadsa ppocoranitohui” titiquina najaro. Nadsapi nema neneje najaro. ");
INSERT INTO cul_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jaho, tiadenipi pina maidsajidede rabotedenissa tiquinajaro. Meme qquide nahatoqquiri, nami qquide nahatoqquiri tiquinaraha aji jidapanacca ima dsati tojajaropi qquide ssamoqquiri tiquinani. Najaropi Diojine ajijaro dsamadsa Cristo-Mesia pohua dsepe ijiridsahi tiadenidsa ahuato taraha ticahattera-jerajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—¿Nejecotohui tiadenipi ima bica taniccara ticattejidsamana-jerajaro? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","—Nadsama madija ohuahadsa ima tinanadsa naqui pohua attipa: “Tia ohuaccana ima cacattemahuaji” nadsa naco tahide tia tohuacca-jaraccadsama pohua tedseje ticcadeni ima ticattemamanapoji. Pohua huati tinassonapojo, nahi taminehuaji tia tohuacca-jarahijine. Ticca ima ticattemamanapo-jeradsapi ima cacattemahuaji bacco tinadsapi ima tinanajaro manaconi todsepe tijanitohui. Toponi cocorohuaji tia coro idsimamananitohui. ");
INSERT INTO cul_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tiadsa huati onajaro. Nani toponi cocorohuaji timadidsapi amadsati tiqquena-jeranitohui. Ima tinanajaro manaconi nemanehe tinajicanissa tadsana tiqquenanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jeso mari mari naraha madija jahijonajaridenia aja tamine Pirato dsama Carireacca madija inajicajaricca ima Jesodsa huati toquinajari: —Carireacca madijapa Jerosarehuaji Diodsa dada toqquimadsa poccadeni da naqquinaja iaqquedsimamanajari. Bani ette tojahicca Diodsa da quinahijine ssipori huisside toquejenaraha tamine Piratocca dodosse tabaqquideni bacco todsimamanadsapa ijinedeni ahuamanajari. Pohuadenijine bani bedi dade toquejenajari emenedeni bani bedi emene tedseje quejemajaro −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Naraha manaco Jeso pohuadenidsa huati tajari: —Tettidenipi: “Carireacca madijapa imasiri sseqquiri nadsa oppina tanidsa jicajari” ¿tiquinajaroqui? Aja “Carireacca madija motapa imasiri badsira tehe cajimanadsapa pohuadenidsa ima oppina tehe bacco nejerajaro” tiquinanitidija. ");
INSERT INTO cul_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Naraha imapi nema nejerani. Tiadeni huapima Dio Attidsa ibobo tinadsa tibodideni cacajiqquimera-jeradsapi dsoqquehe jiquejeranicca bacco tiquinanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—Ima onihi naqui ajima najaro: Jerosaredsa passojine hui todsani onini Siroe inorinidsa siba hua nahuajanijaro tirocossadsa madija 18 naha jicajari. Najaridenidsa naqui tettidenipi: “Imasiri sseqquiri nadsa oppina tanidsa jicajari” ¿tiquinajaroqui? Aja “Jerosarecca madija motapa imasiri badsira tehe cajimanadsapa pohuadenidsa ima oppina tehe bacco nejerajaro” tiquinanitidija. ");
INSERT INTO cul_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Naraha imapi nema nejerani. Tiadeni Dio Attidsa ibobo tinadsa tibodideni cacajiqquimera-jeradsapi dsoqquehe jiquejeranicca bacco tiquinanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesopa ajijaro namidsa imadinicca imadsa mari icanabaqquijari, madijadeni bodi cacajiqquimera-jeradsapa jicahi noppine bodideni huatohuijine. Pohua attipa: —Maqquideje ojariapa pocca huidsajadsa ahua iquiera ppa todsahi huajari. “Nanihuaji occana, ahua iquiera bono cajihitide” najari. Naraha nahihuaji bacco tadsapa bono cahua najarajari. ");
INSERT INTO cul_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nadsapa huidsaja cacahuadedsa huati tajari: “Huajano tahideccadsa qquide occajona, huajano dsotodeccadsa qquide occajona, jidapana naqui qquide occajona naraha bono qqui onajaraha. ¡Ca tinajo! Pohuama nahidsa hua dsanapona onejerani” najari. ");
INSERT INTO cul_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Naraha huidsaja cacahuadepa manaco huidsaja jinededsa huati tajari: “Ohua medsede, ca inajaraccana. Ajari huajanodsa jabohuaji hui onahuajanidsa ahua huahuassa tadsajani ocanejemahijine” najari. ");
INSERT INTO cul_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“Nama onanadsa bonohitidija. Naraha bono-jaradsana ca tahijine” najari huidsaja cacahuade −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nadsama dsotodepa jassinajacca huadadsa Jesopa Dio Atti mamarihuaji toqquedsimadsapa madija mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nanidsa naqui amoneje coma tajaro qquedsimajaro. Satanacca dodosse tocorimejine poni ideni jocadsajaro. Huanissa tanijine ssamo tani. Huajano 18 naha nema najonajaro. ");
INSERT INTO cul_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Naneje Jeso qqui inadsapi poni ccajonanijine huahua najari. Bacco nadsapi: —Asi, ticca dsamacoma tomossini −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nadsapa pohua dsepedsa bara inadsa amadsati ideni tobicajaro. Nadsa huanissa tadsapi huatidsedsa Diodsa jiri jiri najaro: —Jehe, Tiapi bica tinani, bica tinani −najaro Diodsa. ");
INSERT INTO cul_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Naraha Jeso jassinajacca huadadsa madija inanomidsapa Dio Atti mamaricca tamine jipera tajari. Aja jodiodenipa: —Jassinajacca huadadsa madija dsepedeni ijimanahijinepa oppina tani −quiquinanajari. Nadsapa Dio Atti mamaricca taminepa huadi tadsa madija queriqquimanajaridenidsa huati tajari: —Huada 6 nehe idsepe ijini bica tani. Najaro huada 6 nehe ticanomirenijine jai tijedsimaji. Naraha jassinajacca huadadsa toponi totonanomidetohui jai tijedsima tejeraji ¡poni! −najari Dio Atti mamaricca tamine atti. Pohua atti nama nadsapa Jesodsa ima inanajaro. Jassinajacca huadadsa madija inanomibaqquidsapa pina pohua dsepe ijijarissa najari. ");
INSERT INTO cul_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Naraha Jeso taminedenidsa huati tajari: —¡Mamaidsadedeni, ponima huati tiquinajaro! ¿Jari, tiadeni naqui ticcadeni bohui, ticcadeni bojo, ticcadeni odsadsa ssoque ssoque dsaneri naridsadsapa jassinajacca huadaraha madone dicca tiquinadsa passo dse quinahijine passohuaji joca joca titiquina nejeraqui? Najaropi jassinajacca huadadsa tidsepedeni ijimana tani. Naraha: “Najaropi icca bohui nomiqquiri nahijine, oppinera tani” titiquina najaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","—Nadsapi jassinajacca huadadsa ticcadeni bohui tecahuabaqquidsapa aji amoneje jassinajacca huadadsa onanomidsa naqui oppinera tani. Ponipi Abarahao potemahije najaro pina tiadenissa naraha ponipi huajano 18 nehe tabaccorehe jinede Satanajine ideni siri tojehe madijaro. Ponipi huajano huapi tahi coma tajaro. Satanapa pina poni ssoque idsanajarossa najaro. Nadsama jassinajacca huadadsaraha ponipi Satana ssoque idsanaraha tappa inanijine bica tani, onajaro. ¿Naraha tiadenidsapi bica tejeraqui? −najari Jeso Dio Atti mamaricca taminedenidsa huati tajari. ");
INSERT INTO cul_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ima nema najaro huati tadsapa pohuadsa huadiqquiri najarideni cappinamanajari. Naraha madija motapa amoneje tonomini qqui toquinadsa Jesocca nahatohue bicani, deni tojanicca qqui toquinadsapa huatidsemanajari. ");
INSERT INTO cul_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nadsama najaro ima jicadsa Jeso attipa: —Tibodideni huatomanaji. ¿Nejecoma najarona paji Diocca cacahuehe? Aji Diocca cacahuehe tahimarini timittamananijinepi ajijaro namidsa imadinicca ima onihidsa tiadeni mari ocanabaqquina −najari Jeso madijadenidsa huati tadsa. ");
INSERT INTO cul_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—Diocca cacahuehepi pina mostaza noccossa najaro. Mostaza noccopa potera taraha madija huidsajadsa ppa idsadsa napidsapa pina ahua imehissa najari. Motaradsapa pohua ininedsa ppiriri pohuadeni tadsari bina tarimana tahi. Jehe, Diocca cacahuehecca ima mari ocanabaqquijaripa pina najaro imassa najaro. Tahidepi madija pamahadsa tojapojaro. Dsotodena madija huapimadsa tojaridsadsapi Diocca cacahuehedsa madija tohuapihitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jeso huati tapomajari: —Aji, Diocca cacahuehecca ima timittamananijine ima onihi tadsajani tiadenidsa huati onana. ");
INSERT INTO cul_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Diocca cacahuehepi pina pan ssaja tahijinecca imassa najaro. Amonejepi pan inahatohuijinepa pan ssaja tahijine quequejema oni levadura aja trigo ria nahidsa ijine icanejemajari. Ssaja tahijine quequejema badsira taraha trigo ria nahi harina 3 kilopa motarajari. Naraha ssaja tahijine quequejema trigo ria nahi harinadsa tojaribaqquidsapa ssaja tajari. Aji Diocca cacahuehecca ima naqui najaro imassa najaro. Tahidepa madija pamaraha dsotodena Diocca cacahuehecca ima dsama huapimadsa tojaribaqquidsa madija huapimadsa tojaridsajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nadsama Jesopa Jerosarehuaji pocca benehidsa toccadsapa odsa panani onihidsa, onihidsa mari icanabaqquija dsanapohui najari. ");
INSERT INTO cul_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Madija mari icanabaqquidsapa nahicca madija ojaria pohua bodi huatodsa Jesodsa huati tajari: —Ohua Medsede ¿madija tocassiejerahijine naco ipama najaroqui? −najari Jesodsa. Nadsapa Jeso atti huapimadsa: ");
INSERT INTO cul_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Dacoco tijiraji. Noccobiji tojera tanihuaji jai tijedsimanijinepi tinajomana tejeraji. Aji occa imadsa jehe tiquinanijine Diocca cacahuehedsa tiquejenanijine naqui tinajomana tejeraji. Tiadenidsa ohuattipi ajima onajaro: Nidsa dsotodepi madija huapi taha: “Jaijedsimana, Jesodsa iquejenana” quinahitohuiraha ohuadsa toquejenahijine pajiramana-jarahitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tahide ohuadsa jai tijedsima-jeradsapi nidsa dsotodepa odsa jinede najoradsa totehema, noccobiji ecossani nadsapi jai tijedsimanijine ssamo tanitohui. Nadsapi amossinidsa tidomo huadsa noccobijidsa coba coba tiquinadsa odsa jinededsa: “Noccobiji iadsa ticatabojidsaji” tiquinaraha pohuapa: “Tiadenipi ¿nejecohuajicca tiquejenani?” nahitohui tiadenidsa. ");
INSERT INTO cul_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nadsapi ima huati ticadsanamananitohui: “Nadsa timadidsama ia qqui tinabaqquide. Tiadsa ijipaqquidsa ocassa tanicca naqui dse inade. Icca odsa boronidsa naqui ia mari ticanabaqquide” tiquinanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Naraha odsa jinedepa manaco tiadenidsa huati tahitohui: “Naraha ohuapi jai tijajonanihuaji ssamo onani. Tiadenipi jidsaqquiri tiquinani” nahitohui. “Imasiri ticajimanadsapi ohuadsa timadimana-jeraji. ¡Ajicca jai tijaji!” nahitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Nadsapi Diocca cacahuehedsa huati tinadsa ticattomama canadsapi ticcadeni idideni Abarahao, Isahaca, Jacobodenipa, aja Dio Atti cacomeraqquiri najarideni tedseje, huapima nahidsa madimanahi qqui tinabaqquimanaraha tiadenipi huahuattajo tiquejenanitohui. Tiadenipi ocasserani temanadsanapodsapi tipanodeni todsani nadsa oji oji tiquinanitohui. ");
INSERT INTO cul_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nadsapa dsama nemanehedsa madiridsamanajarideni naco Diocca cacahuehehuaji jahijonana canahitohui. Motapa Isaraerideni quejena-jararaha ohuadsa pajissa quinajarideni naco jahijonana canahitohui. Dio pocca cacahuehedsa queriqquimanadsapa pocca jipaqquiecca ejete imenidsa huahuanaridsa jassi nahuajanihitohui. ");
INSERT INTO cul_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nadsapa madija mota ajijaro dsamadsa madimanaccadsapa Dio Atti cajimanapojari. Naraha najarideni arobedeni motapa Diocca cacahuehedsa toquejena-jarahitohui. Madija ohuaha naco ajijaro dsamadsa madimanaccajaridenipa Dio Atti cajimanapo-jarajari. Naraha dsotodena Dio Atti pohuadenidsa bacco tadsa pohuadeni motapa Diocca cacahuehedsa toquejenahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jeso huati huati taja naraha jodiodeni marinaja onini pariseodsa jehe quinajarideni bacco najonamanadsa pohuadsa huati toquinajari: —Ajidsapi timadi tejeraji. ¡Ajicca ticcaji! Tamine Herodepa: “Tia onanadsoqquena” nahi −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Naraha manaco Jeso pohuadenidsa pohua cacomerajari: —Najari dsomaji huadibotedsa huati tiquinaji: “Jeso attipa ajama nahi” tiquinana. “Tibodi huatoji. Jidapana, dsemassa naqui, madija bodidenicca tocorime dosse onineridsa-baqquihitohui, madija tocanomirehijine. Comaqquiri najarideni naco onanomibaqquihijine. Huada onihidsana odsepe jicanitohui. Najarotohui occaronajarode nadija” tiquinana Herodedsa −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","—Nema nehe nani occanitohui. Occa imapi najorapode. Jidapanapi ajidsa odsepe ijiccani. Dsemassana denima occanitohui. Huada ssiajapi denima occapomanitohui. Huada onihiccadsa naqui nema odsanapojaroa Jerosare bacco onanitohui. Aja Dio Atti cacomeraqquiri najarideni naco Jerosarehuajina jijicamana najari. Odsa onihihuaji odsoqquenijinepi bica tejerani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nadsama Jesopa odsa panani Jerosarehuaji madimanajaridenicca ima huati tajari: —Ohuapi titohuideni oji oji onadsapi: “Jerosare, Jerosare” ohonanajaro. Maittaccadsama ticcadeni idideni madimanapodsa naco Dio Atti cacomeraqquiri najarideni inanadsoqque-ridsamanaja najonapohui najari. Diopa pocca dodosse tabaqqui tiadenidsa dosse dosse inajonabaqquiporaha sibadsa tiquinabaqquimanaja najonapohui najari. Naraha ohuapi tiadeni ohuacahuabaqquina, onajaro. Pina tacara poni bedi poni appani dopanidsa ecahuabaqquijarissa onanijineraha tiadenipi ohuadsa jiperaqquiri tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tetideni huatoji. Diopa tidsamarideni Jerosare inebonitohui. Tiadeni tohuacahuabaqqui-jarahitohui. Ohua naqui ohua qqui timanimanapoma-jeraccanitohui. Nidsaranibote ima najoranissa tadsa occanipomadsana ohua qqui tiquinapomanitohui. Nadsana tettidenipi: “Jehe, ajaripa Dio onima ccaronajari. Pohuapa bica tahi, bica tahi” tiquinanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jassinajacca huadadsa Jesopa pariseodeni taminecca odsahuaji jipade toccajari. Nahidsapa pariseo ohuahadeni naco jipamanajari. Pohuadenipa Jeso inoccodsamanajari: —Nidsa pocca ima dsori tadsapi pohuadsa ima inassonarinijine −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nahi Jeso tedsejemapa madija jitemarodsa coma tajari qquedsimajari. ");
INSERT INTO cul_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nadsapa Jeso najari qqui tadsapa pariseodenidsa, jodiodenicca marinaja maridedenidsa naco huati tajari: —Jari, Moisesicca marinajadsa, icca madijacca marinajadsa naqui jassinajacca huadadsa madija coma tajari inanomihipa “Oppinera tani” ¿tiquinaqui? “Oppina tani” ¿tiquinajarorane? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Naraha pohuadenipa joma quinajari. Nadsapa Jeso madija coma tajari bara inadsa tonomijari. Nadsapa: —Ticcaniji −najari pohuadsa. ");
INSERT INTO cul_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nadsapa Jeso pariseodenidsa huati tapomajari: —Jari, tiadenipi jassinajacca huadadsa idsepe ijinijine “oppina tani” tiquinaraha pina ticcadeni ejedeni itide, ticcadeni bohui itide passojine hui todsanidsa tossonippadsapa ¿joca timoranimana-jaraco? Naraha coma tajari onanomijaripa pina najaro imassa najaroa −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Naraha pariseodeni, jodiodenicca marinaja maridedeni Jesodsa ima inassonarimananijine tohuini quinadsapa pohuadeni cacomamanajari. ");
INSERT INTO cul_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nadsapa nahi pariseodenicca taminecca odsadsa jipaqquimanahijinepa deni toquejenajaridenicca huihuittari bica tanicca tohui icattejidsaridsa-manajaro. Pohuadeni bodipa: —Jehe, ohuana bica onani −quinahicca ima ahuato tanijine deni toquejenajaridenicca huihuittaridsa jassi tarijari. Nama naridsamanahi Jeso qqui tadsapa pohuadeni mari icanabaqquijari, ajijaro namidsa imadinicca imadsa. ");
INSERT INTO cul_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Jari, tiadenidsa huati onana, timittamananijine −najari. —Madijapa pina cacajirehijinecca jipaqquie tojabote nadsapa tiadenidsa huahua nadsa jai tija tani. Naraha nanihuaji jai tijedsimadsa jassi tinarinijine huihuittari deni toquejenajaridenicca huihuittaridsa huittarimana tejeraji. Deni toquejenajaridenicca huihuittaridsa tittarimanadsapi nidsa dsotode madija tiadenidsa deni tojajari bacco nahitide. ");
INSERT INTO cul_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nadsapa odsa jinede tiadsa huati tahitohui: “Ticca huihuittaridsapa ajajarina huittarina” nahitidija. Nadsa tibodi cappinadsapi ajamani toquejenajaridenicca huihuittaridsa tittarirana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Naraha ticca ima bica tanijinepi madija pohuadsa tijipanijine titohui huahua nadsa aja ajamani toquejenajaridenihuaji tittarinina bica tani. Nadsapa odsa jinede tia qqui tadsa: “A, otesse, denima bica tanihuaji tittariji” nahitohui. Nadsama aja huapima jassi nahuajanijarideni qqui toquinadsapa odsa jinede denima bica tanihuaji tia dosse tahitohui. Nadsapa: “Jehe, pohuapa denima bica tajari” quinahitohui tiadsa. ");
INSERT INTO cul_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Najaro imadsana Diocca cacahuehecca madie ticahatteranijine. Madijapa: “Ohuapi deni ojani” nadsa Diopa najari ajamani inanahitohui. Naraha madijapa: “Epejena, ajimani ojani naqui bica tani” nadsapa najarina Dio deni inanahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesopa marinaja onini pariseodsa jehe quinajaridenicca tamine Jeso pohuadsa jipahijine huahua najaridsa huati tajari: —Jehe, madija tiadsa jipaqquimanahijine jipa tinadsapi titessedenitohui, timecotedenitohui, ticca madijatohui huahua tejerana. Tinocco jidsera tajaridenitohui, dsiniro sseqquiri najaridenitohui, najaridenitohuipi huahua tejerana. Manaco pohuadenipa tijipanijine tiadsa huahua quinahitohui. Nadsapi pohuadenidsa ima bicani tinanajaro manaconi ticajini. ");
INSERT INTO cul_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Naraha madija tiadsa jipaqquimanahijine jipa tinadsapi aja madija cappirajarideni, madija siri toquejenajarideni, aja madija isso sirideni, madija nocco sirideni, nama najaridenitohuira huahua tana. ");
INSERT INTO cul_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nema tadsapi tibodi tetidsenitohui. Pohuadenipa manaco tiadsa jipaqquie inahatomananijine pajiramana-jarahi, ssamoqquiri najari. Naraha nidsa Diopa pocca madija inahatonibaqquidsana manaco Pohuana tiadsa ima bicani inananitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nadsapa nahidsa jipade jassi tarijarideni ojaria Jesocca marinaja mittadsapa Jesodsa huati tajari: —Nidsa Diocca cacahuehedsa madija toquejenadsa Diocca jipaqquinaja imenidsa jipamanadsapa Dio pohuadenidsa ima bicani inananitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Naraha Jesopa pocca marinaja ajijaro namidsa imadinicca ima tadsajani pohuadsa huati tajari: —Jehe, madija dsepe sse tajaria: “Jipaqquie imeni onahatona” nadsapa madija huapi taha huahua inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jijipa najoradsapa jipaqquie jinede pohua tessedenitohui pocca dodosse dosse inajari, pohua tessedenidsa: “Ohua medsede atti: ‘Jijipa najorahi, jai tijajonaji’ napaja” nahijine. ");
INSERT INTO cul_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Nadsapa pohua tessedenidsa huatide ccaridsaraha “Idsepe ijini” naridsamanajari. Pohuama huati toquinajari. Tahidecca attipa: “Ohuapi huidsaja tojanijine dsama mitta onajaro, najaro qquide occabote nani. Tia medsedecca jipaqquiedsa occanijine opajira-jerani. Epejena, otohui timadi tejeraji” najari. ");
INSERT INTO cul_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nadsapa jipaqquie jinedecca dodosse madija ohuahadsa naco huati taraha najari naco: “Odsepe ijini. Occa bohui mitta odsati 10 quinajari ojine papamacosseri nadsa occa huidsajacca nami boto nanijine nattome onabaqquiccana, onajaro. Tia medsedecca jipaqquietohui occanitohuiraha odsepe ijini” najari. ");
INSERT INTO cul_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nadsa huahua inapojari ohuahadsa naco huati taraha najari naco: “Ohuapi oqquejerani. Tia medsededsa huati tinana: Aji ohuapi amoneje ocajidsatije najaro. Epeje, ticca jipaqquiedsa oqquedsima-jerani” najari. ");
INSERT INTO cul_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Nadsapa jipaqquie jinedecca dodosse toccanijari, poccadeni ima huapima huati tanijari. Jipaqquie jinedepa najaro ima mittadsa huadijari. Pocca dodossedsa huati tajari: “Nema nehe huassinaja odsa pananihuaji ticcaji. Nanihuajicca jahui onihi onihicca madijatohui qqui taridsaji. Aja dsiniro cappiramanajarideni, madija siri toquejenajarideni, pina isso siri tojajari, nocco siri tojajari najarideni ahuaji teccanibaqquijo” najari. ");
INSERT INTO cul_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nadsapa dsotode pocca dodosse madija huapima eccanibaqquijari. Jipaqquie jinededsa huati tajari: “Jehe ohua medsede, tettissa onanaraha ticca odsapi cajinissa tejeraccani” najari. ");
INSERT INTO cul_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nadsapa jipaqquie jinede huati tapomajari: “Jari, jahui onihi odsa panani inidihuajicca jahui ticcaridsaji. Madija ohuahadeni teccanibaqquijo, jahidsimahijine. Occa odsa cajinijine, onajaro” najari. ");
INSERT INTO cul_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","“Aja madija huahua onabaqquipojaridenipa occa jipaqquiedsa jai tojedsima-jarahitohui. Occa jijipa ecatamamana-jarahitohui” najari jipaqquie jinede −najari Jeso, Diocca cacahuehecca ima mari icanabaqquidsa. ");
INSERT INTO cul_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nadsapa Jeso pocca benehidsa toccadsapa madija huapi taha pohuadsa jai tojamissajari. Nadsapa Jeso cattahuajanihi nadsa pohuadenidsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Madijapa ohuadsa tojahijine tohuini naraha pohuapa pocca madijadsana denima huati huana tadsa, ohuadsapa ajamani huati huana tadsapa najaripa occa tojahijine pajira-jarahi. Madijapa pocca abi, pocca ami, pocca amoneje, pocca ejedenideni naco, pocca ato naco, pocca asi naqui, pocca esodeni naco, ojari itide, huapi tahitide, ima onihi pina ohuattissa nejeranicca pohuadsa huati toquinadsa pohuadeni attidsana ibora tadsapa occa madija tojahijine pajira-jarahi. Occa madijapa ohuattidsana iboraqquiri najari. Madija naco pohua pocca madiedsa denima huati huana tadsapa ohuadsa ajamani huati huana tajari. Pina ohuattissa inana-jeradsapi occa madija tojahijine pajira-jarahi. ");
INSERT INTO cul_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Madija ohuadsa dissera tajaradsapa occa madija tojahijine pajira-jarahi. Occa madija tojahijinepa otahimarijine ocasserani inahanaraha nema nehe otahimaridsara dissera tajari. Pohuadsa: “Ahua porimacossanidsa tia inanadsoqquena” quinadsa naco pohua attipa: “Epejena odsoqquena. Jeso onebo-jarahi” nadsapa najarina occa madija tojajari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jeso denima huati huati tajari: —Jehe, occa dodosse tabaqqui tiquejenanijinepi ponima “Jesocca ojana” tiquinejerana. Tahidepi tibodideni huato-mananissa tapoji. Pina ajijaro imassa najaro: Tettidenipi: “Odsa imeni nami macconi botta tanidsa ocanahatona” tiquinadsapi ¿nejecoma titiquinapo najaro? Jehe, tahidepi: “Odsa manaconipi ajima nanitide” titiquinapo najaro. Nadsapi: “Occa odsa cajicanissa tanijine ¿occa dsiniro pajirapadseje?” titiquinapo najaro. ");
INSERT INTO cul_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Naraha tahidepi ticca odsa canahatonijine manaconi nattome tapo-jeradsapi dopanihuajicca nami macconi botta tani hua inariridsamanajarodsara ticca dsiniro jicaqquinitidija. Najarodsa dsiniro jicadsapi ticca odsa cajica-jeranitohui. Nadsapi madija huapima tia jaja icanaqquimananitohui. ");
INSERT INTO cul_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Attidenipa: “Ajajari madijapa odsa icanahatoraha cajicanissa tanijine ssamo tajari” quinahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Nadsama ima onihipi ajima najaro: Tamine pamaha dsama onihicca dsama onihicca tedseje cahadirehijine poccadeni soldado tedseje najoraridsamanajari. Tamine ojariapa pocca soldado 10 mil naha cajijari, naraha tamine ohuahaccapa denima huapi tajari, 20 mil naha cajijari. Nadsapa aja soldado 10 mil naha cajijaripa aja tamine soldado 20 mil naha cajijari tedseje bacco tocanire-jaradsama ¿pohua bodipa nejecoma napopadsaja? Jehe, pohua bodi huatopohuitohui: “Ohuapi aja tamine soldado 20 mil naha cajijari tedseje icahadiredsapi ¿deni ojapadseje? ¿deni ojajerapadseje?” nahitohui najari tamine. ");
INSERT INTO cul_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nadsama: “Occa soldado 10 mil nadsapa deni ojajeranitohui” nadsapa aja tamine soldado 20 mil cajijari jahijonahi huaji taccadsama pohuadsa ima dosse inajaro: “Icahadire-jerana. Ijicarana. ¿Nejecora tiadenidsa da inadsa icajoneranijine?” nahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Jehe, ima najarossa najaroa tiadeni naqui occa madija tiquejenanijine tahide tibodideni huato-mananissa tapoji, onajaro. “¿Jesocca ojadsapi huapima oneboridsanijine opajirapadseje?” tiquinaji. Aji ticajimanajarocca huapima tinebomananijine iboqquiri tiquinadsapi occa madija tiquejenanijine tipajiramana-jeranitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Nadsama sahopi bica tani. Banidsa coro idsippadsapi ajibo tajaro. Aba jadsi-jarahijine naco sahodsa huira inajari. Naraha saho ajiboni tomossidsapi tomajidera tani, icca bani naco totabaccora tahi. Ajibo tapomanijine ssamo tani. Saho ajiboni tomossidsapi ponima tojajaro. ");
INSERT INTO cul_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Namidsa huira inadsapi sahojine icca ppa nahi moro tajarahi. Ahua huassa tajaridsa quejemadsa naqui sahojinepi ppa nahi moro tajarahi. Nadsama saho ponima tojadsapi nebojaro. Najaro imapi pina tiadeni naqui ajijaro dsamacca madijadsa ima bicani tinanamanaridsajaro. Nema tidsanapomanana. Nema tinanamana-jeradsapi ticcadeni jeheniji ponima tojarana. Nadsama teribodeni ticajimanadsapi ohuatti timittamananissa taji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nadsapa aja romanodenicca taminecca dosseniji dsiniro nanaccadedeni, imasiri sseqquiri najarideni tedsejepa: —Jesocca marinaja imittana −quinadsa Jesohuaji jahijonajari. ");
INSERT INTO cul_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Naraha jodiodeni mota marinaja pariseodsa jehe quinajarideni, jodiodenicca marinaja maridedeni tedsejepa aja imasiri sseqquiri najaridenidsa Jeso quejemahi qqui toquinadsapa jiperaqquiri najari. Nadsapa atti atti quinajari: —Ajana, ajajari madijapa imasiri sseqquiri najaridenidsa nija nahi taji. Pohuadeni tedseje naco jipajari. Naraha iapi pohuadeni tedseje ijipanijinepi oppina tani, inajaro −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Naraha manaco Jeso pohuadenidsa ajijaro namidsa imadinicca ima tadsajani mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Pohua attipa: —Jari, tiadenipi ticcadeni edede 100 naha ticajimanadsapa onideni hua tiquinadsa ojaria amossi nadsapa ¿pohuatohui qquide jai tija-jeraqui? Jehe, edede jinedepa pocca edede qquide toccahitohui. Pocca edede 100 naha cajiraha ojaria amossi nadsapa 99 tojajari. Pocca edede 99 naha huamonihuaji inebobaqquidsapa ojaria amossi najari qquide toccajari. Nadsapa qqui qqui naridsanaja pocca edede bacco inanijari. ");
INSERT INTO cul_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bacco inanidsapa pohua mattodsa ibari nanijari. Nadsapa huatidsenijari. ");
INSERT INTO cul_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nadsapa odsa bacco nanidsapa pohua tessetohui huahua najari: “¡Occa edede amossi najaripa bacco onanihi! ¡Occa odsahuaji jai tijajonaji, etidsenijine!” najari. ");
INSERT INTO cul_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nadsama pajissara tiadenidsa huati onajaro: Najarossa najaro madija imasiri sseqquiri najaridenipa pina edede jano tojadsa amossi najarissa quinajari. Naraha ojaria: “Diodsa ojanijine, occa ima onebona” nadsapa Diopa pocca dodosse tabaqqui memehuajicca tedseje huatidsemana tahi. Aja madija tahide Diodsa toquejenapojaridenicca imadsa naco memehuajiccapa huatidsemana tahi. Naraha aja madija Diodsa tojedsatidsapa denima huatidsemana tahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nadsapa ima onihi naqui huati tajari: —Amonejepi dsiniro ccarara 10 nehe cajiraha ponicca dsiniro cajarie amossi canadsapi ¿qquide dissera tejeraqui? Dissera tajaro. Jojororo iquehessidsa ponicca odsadsa johue naridsajaro. Ponicca dsinirotohui mohuaradsa qqui naridsanissa tajaro. ");
INSERT INTO cul_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bacco icananidsapi poni tassanitohui, poni inoriniccatohui huahua najaro: “¡Ohuadsa tetidsemanaji! Occa dsiniro amossi canaraha bacco ocananini” najaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Nadsama ohuapi tiadenidsa huati onana: Najarossa najaroa madija imasiri sse tajaripa: “Diodsa ojanijine, occa ima onebona” nadsapa Dio pocca dodosse tabaqqui tedseje huatidsemana tahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesopa dsoqquejari dsepetajibotecca imadsa huati huati najari: —Madijapa pohua bedi pamajari. ");
INSERT INTO cul_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Dsotodeccapa imehidsa huati tajari: “Abi, tidsepetaji, ticca dsiniro, ticca dsama huapima nidsa tidsoqquedsapi icca tojanijine tade. Nadsapi aji occapi tidsoqque-jeraccadsama ohuadsa arobeni da taji” najari. Nadsapa imehi pohua bedi pamahadsa pohua dsepetaji, pocca dsama icanaroberidsadsa pohuadenidsa da inaridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Naraha huada onihidsapa pocca abicca daniji aji dsama cajidsati, pohua dsepetaji cajidsati naqui dsinirotohui da inaridsajaro. Nadsapa dsiniroma dsama huaji tanihuaji toccajari. Nadsapa dsama huaji tanicca odsa bacco tadsapa ejetetohui, dsodsobitohui, amonejetohui naridsajari. ");
INSERT INTO cul_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Nadsapa pocca dsiniro nemanehe inajicajaro. Naraha najari huajanodsa pemi naqui tojaridsajaro. Dsamatapa naco bonoridsa-jarajari. Nadsapa dsabisso pemijari. ");
INSERT INTO cul_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tarabaidsatohui nahihuajicca madijadsa huati tajari. Nahihuajicca madija pohuadsa: “Occa poroco tecahuabaqquijo” nadsa pocca poroco madimanahihuaji dosse inajari. (Naraha dsabissopa jodioja nadsa poroco cacahuade pohuadsa ocassera taraha nama naha poroco ecahuajari.) ");
INSERT INTO cul_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pohuadsa dsamatapa da quina-jaradsa pemidsapa: “Poroco tapari ojipa naccaraho” nanaja naraha poroco tapari pina imissa najaro naqui pohuadsa da quinehe nejerani. ");
INSERT INTO cul_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Nadsapa bodi huatomajari: “Occa abicca odsadsapa tatarabaidsadedeni caji taraha pohuadenidsa dsamatapa mota totoja nade. Naraha ohuapi ajihuaji pemi, ohuatiabote nani” najari pohua bodi. ");
INSERT INTO cul_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nadsapa pohua bodi huatodsapa: “A, occa abicca odsahuaji occanina. Bacco onanidsapi pohuadsa occa ima huati onanijine: Abi, ojine ima tabaccora tani Diodsa. Tiadsa naqui ojine ima tabaccora tani, onanijine” najari pohua bodidsa. ");
INSERT INTO cul_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","“Nadsama: Abi jidapapi ohuadsa: ‘Occa ejedeni’ tejeraji. Tiapi bica tinaraha ojinepi ima bica tejerani, onanitohui. Naraha jidapapi ticca dodosse ojanijine ¿jipa tinaqui? onanitohui” najari pohua bodidsa. ");
INSERT INTO cul_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—Nadsapa pocca abihuaji toccanijari. Toccanijari... bacco tanibote nadsa pocca abipa huaji taraha pocca ejedeni ccanihi qqui tajari. Qqui tadsapa pocca ejedenidsa huati huana taja najari. Joppa tojidsajari, dama, icahuajocossa, pano mose inajari. ");
INSERT INTO cul_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Naraha bedi attipa: “Abi, ojine ima tabaccora tani Diodsa. Tiadsa naqui ojine ima tabaccora tani. Abi, jidapapi ohuadsa: ‘Occa ejedeni’ tejeraji. Tiapi bica tinaraha ojinepi ima bica tejerani” najari imehidsa. ");
INSERT INTO cul_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Naraha pocca abipa bedi atti mittaraha pina mitterahi najari. Pocca dodosse tabaqquidsana huati tajari: “¡Huassinaja occa ejedeni etero bicanidsa tinehedsamanajo! ¡Todsepecca naqui dsepe tinahanamanajo, amoricca naco tinehedsamanajo!” najari. ");
INSERT INTO cul_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","“Bohui napidsati oqui tajari naco teccanimanadsa tidamanajo, ijipaqquinijine” najari. ");
INSERT INTO cul_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“Etidsenijine bica tani. Occa ejedeni pina dsoqquejarissa naraha madinipomahi. Pohuapa pina jano tojajarissa naraha bacco nanipomahi” najari. Nadsapa pocca odsacca huapima huatidsemanajari. ");
INSERT INTO cul_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Naraha pohua bedi tahideccapa huidsajahuaji dsepe ijidsa ccaninaja odsa huajiranidsa mittajari. Tire tire camaja, tore tore camaja najari, pocca abicca odsadsa dsodsobi tojajaro. ");
INSERT INTO cul_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Naraha pohuapa pocca abicca medsetohui huahua najari. Ccajonadsapa pohuadsa huati tajari: “¿Nejecotohui icca odsadsa ejete tojajaro?” najari. ");
INSERT INTO cul_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Naraha imehicca medsepa pohuadsa huati tajari: “Timecote bacco nanijari. Nomi, bica taha ccanidsa ticca abi bohui bedi oquibote inanadsoqquejari” najari. ");
INSERT INTO cul_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Naraha pohuapa jamijari. Odsahuaji toqquedsimanide jipera tadsapa pocca abina qquenajari. Qquenadsapa bedidsa huati huati tajari, toqquedsimanihijine. ");
INSERT INTO cul_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Naraha manaco imehidsa huati tajari: “Ohuapi tiadsa huajano huapi taha odsepe ijijaro. Ticca dosseniji aji jipa tinajarocca ohuadsa dosse dosse tajarossa onanaraha ohuadsa bani ette tojahi da taha najarahi, otessedeni tedseje ohua naqui ohuatidsenijineraha” najari imehidsa. “Bani huati ccarera tahicca pina edede jidsadsa cabra bedi naco ohuadsa da taha najarahi, otessedeni tedseje ijipaqquinijineraha. ");
INSERT INTO cul_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Naraha ticca ejedeni aja ticca dsiniro ponima amoneje pehiqquiri najarodenidsa inajicajaro pohuadsana bohui bedi oquibote tinanadsoqquejari” najari imehidsa. ");
INSERT INTO cul_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—Nadsapa manaco imehi pohuadsa huati tajari: “Ato, tiapi ohuadsa timadi-dsanapojaro. Odsepetaji, occa huidsaja, occa bani ette tojahi, occa odsa najari huapimapa ticca” najari. ");
INSERT INTO cul_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","“Naraha jidapapi ijipaqquidsa etidsenijine bica tani. Ticca eso dsoqquejarissa naraha jidapapa ima dsatidsa madinihi. Pohuapa jano tojaraha qqui imanihi” najari pohua bedidsa −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nadsapa Jeso pocca dodosse tabaqquidsa ajijaro namidsa imadinicca ima onihidsa huati tajari: —Jehe, madija dsepe ssebotepa pohua cajijaricca huapima pohua biji accode ojaria ecahuajaro. Naraha pohua biji accodepa pohua pohuajine pocca cacahuehe tossamojaro. Nadsapa madija ohuahadenia dsepe ssebotedsa huati toquinajari: “Tibiji accodepa ticca dsiniro ponima inajicajaro” quinajari. ");
INSERT INTO cul_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nadsapa dsepe ssebote pohua biji accodedsa huahua nadsa huati icanajari: “Nija, ticca ima ohuadsa huati toquinajari. Ponima occa dsiniro tinajicani quinahi ima omittani. ¿Ticca cacahuehe nejecoma tinanajaro? Ohuadsa ticca cacahuehecca dsodo nani huapima tinajoradsa ohuadsa da taniji, onajaro. Nadsama tiapi denima tecahuaji onejerani” najari pohuadsa. ");
INSERT INTO cul_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Nadsapa aja pohua biji accodepa pohua ehuerahi bodi huatojari: “Jidapapi ¿nejecoma onapadseje? Ohua dossede ohuadsa jipera tadsapa odsepe ijinijine nohueradsapi ocappiranitohui” najari. “Huidsaja ppa onanijinepi opajira-jerani. Madijadenicca dsiniro manaconi jirehe mitta onanijine naqui cappina onani. ");
INSERT INTO cul_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pina ajima onana. Ohua dossededsa debe quinajaridenicca debe ajimani onanaridsana. Nadsana ohuadsa huatidsemanadsa nidsa tarabaidsa ocappiradsapi aji ima onajorapojarojine ohuadsa: ‘Aji occa odsadsa timadiji’ quinahitohui” najari pohua bodidsa. ");
INSERT INTO cul_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—Nadsapa pohua dossededsa debe quinajaridenitohui huahua najari. Ojaria huahua ccajona, ojaria huahua ccajona najari. Nadsapa tahide ccajonapojaridsa huati tajari: “Ohua dossededsa debe tani ¿nejecoma natte?” najari. ");
INSERT INTO cul_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nadsapa huati tajari: “Ahua oribo bono oquine jojori imeni 100 nehe debe onajaridija” najari. Nadsapa dsepe ssebote biji accode attipa: “Aji ticca cuenta dsodo nani tiadsa da onanina. Ajidsa huassinaja tittaridsa ticca cuenta 50ʼra dsodo taji” najari. ");
INSERT INTO cul_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nadsapa dsotodeccadsa naco huati tajari: “Tia naqui ¿ohua dossededsa nejecoma nehe debe tajaritta?” najari. Naraha pohua attipa: “Aroso jidsadsa trigo saco 100 naha debe onajaridija” najari. Nadsapa pohuadsa huati tajari: “Aji ticca cuenta dsodo nani tiadsa da onanina. Ajidsa huassinaja tittaridsa 80ʼra dsodo taji” najari. Nama nama najari debe quinajarideni huapimadsa. ");
INSERT INTO cul_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Naraha dsepe ssebotepa pohua biji accodejine pohuadsa debe quinajaridenicca debe ajimani inanaridsani ima mittadsapa pohua attia: “Jehe, obiji accodepa pohua tedsejemacca ima maidsehedsa najorapohuijine bodi nahato tajari” najari. Jehe imapi nema najaro. Madijapa pohuadeni tessedenidsa maidsamanahijine bodideni nanajoramanapo najari. Naraha Diocca madijapa pohuadeni tessedenidsa maidsamanahijine najoramanapohuijine ssamoqquiri nahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Tiadenidsa huati onajaro: Ajijaro namicca ticajimanajaroccadsa madija acco ticamabaqquimanajo. Nema tiquinadsapi titessedeni tohuapihitohui. Nidsa dsotode Dio madihihuajicca mamadi jiquejeraniccadsa timadimanadsapi ticcadeni accorehe manaconipi Dio pocca biquehena tiadenidsa inanaridsanitohui. ");
INSERT INTO cul_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Madijapa cacahuaniji badsira tehe ecahuadsa maidsa-jaradsapa nidsa dsotode cacahuaniji deni tojanicca ecahuanijine “Bica tahi” quinahitohui. Naraha cacahuaniji badsira tehe ecahuadsa maidsadsapa cacahuaniji deni tojaniccadsa “Jehe pohua ecahuana” quina-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Najarossa najaroa ajijaro namicca biquehe tecahuamanaraha maidsadsa tinadsa tijinedeni toccanissa tejeradsapi Diopa pocca biquehe pajissacca tiadenidsa: “Tecahuamanaji” najarahitohui. ");
INSERT INTO cul_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Madija ohuahacca dsiniro tecahuamananissa tejeradsapi ticcadeni dsiniro naqui tecahuamananissa tejeranitohui. Nema nadsapi ticcadeni dsiniro tiadenidsa da quina-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Nadsama tiadenipi tiadeni dossede pamahadsa tidsepedeni ijimananijinepi tipajiramana-jerani. Tiadeni dossede pamaha ticajimanadsapi ojariadsana tetideni huanaqquiri najaro. Pohua attidsana iboraqquiri tiquinanitohui. Ohuahadsapi ajimani tetideni huanaqquiri nadsapi pina pohuadsa jiperaqquiri tiquinajarossa nanitohui. Pohua attidsa ibobo tinanitohui. —Diocca tiquejenadsapi dsinirocca dodosse tiquejenanijine ssamo tani. Dsinirotohuira tetidsemanadsapi Diodsa tetidsemananijine ssamo tani. Ima pamehepi Diotohui, dsinirotohui, timadimananijinepi ssamo tani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jeso maride tojadsa marinaja pariseodsa jehe quinajarideni naco nahidsa quejemamanadsa taharibobo canajari. Pohuadenipa dsinirodsana huatideni huanaqquiri najari. Naraha Jeso atti nama nahi mittamanadsapa pohuadsa ssamoni huahua quinajari. ");
INSERT INTO cul_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nadsapa Jeso manaco pohuadenidsa huati tajari: —Tiadenipi madija noccodenidsa bicaqquiri tiquinaraha Diopa tibodideni nahato tajari. Madija huapimapa tiadenidsa: “Bicaqquiri nahi” quinaraha pajissa jerani. Ticcadeni madiedsapa Dio jipera tahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Maittaccadsama Moisesicca marinaja nemanehe, Dio Atti cacomeraqquiri najaridenicca dsodoniji naqui mari mari quinaja najonapohui najaria aja Huano Baotistapaja. Nadsana Diocca cacahuehecca ima bicani madijadsa tojanijine Huano Baotistapa tahide mari mari najonapojari. Jidapana ohua naqui maride nema onajonajaroa ajijaropaji. Naraha madijapa Diocca cacahuehecca imadsa jiperaqquiri nadsa pohuadenijine najidsohue ssonari ssonari najonaraha nama naha madija Diocca cacahuehedsa totoquejena najaripaja. ");
INSERT INTO cul_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Ajina ¿meme, nami jicanijine najora taqui? Najo tani. Naraha Moisesicca marinaja jicanijinepi denima najo tani. Jicanijinepi ssamo tani. Dio Atti dsodo nanicca marinaja huapima pajiranissa tanitohui. Tohuatti ojarie dsori teje cama-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Naraha tiadenipi Diocca dosseniji Moisesidsa huati tapojaricca imadsa madija mari ticanabaqquiraha tijinedenia tojidsajaro. Diocca dosseniji pajissaccapi ajima najarona paji: Maqquidejepa pocca amoneje inebodsa amoneje onihira icajidsapi imasiri inanajaro. Nama nadsapa Diocca dossenijipi ecahua-jerajaro. Madija ohuaha naco aji amoneje ponicca maqqui inebojaro “Ocajina” nadsa icajidsapi imasiri inanajaro. Nama nahipa Diocca dosseniji ecahua-jerajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesopa ima onihi huati huati tajari: —Madija dsepe sse tajaripa etero bicani huehuedsa najari. Huada huajijiradsa ejete ihinana najaro. Pohua tessedeni tedseje jijipa bica tahiccara jijipamana najari. ");
INSERT INTO cul_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Naraha madija tohuati nahana, huapi jadsimaro najaripa nahi dsepe ssebotecca noccobijidsa huihuitta najari. Pohua onipa Lasaro. ");
INSERT INTO cul_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Dsepe sse tajaricca jijipa motatohui huihuitta najari. Pohua huapi jadsijarijine naco ette eno eno quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nadsapa tohuati nahana tajaripa dsoqquejari. Dsoqquedsapa Diocca dodosse tabaqqui memehuajicca iaccamacossanimanajari. Nahihuajipa Isaraeri potemahi jodiodeni huapimacca idi Abarahaohuaji bacco tajari. Nadsapa Abarahao tedseje memehuajicca dsama bicanidsa madimanajari. Dsotode dsepe sse tajari naco dsoqquedsa ppa idsamanajari. Naraha pohuapa paja jicamanarijaridenihuaji bacco tajari. ");
INSERT INTO cul_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","—Nadsama dsepe sse tajaripa paja jicamanarijaridenihuaji madidsapa ocasserani ahuajari. Nahihuaji madidsapa huaji taraha Lasaro Abarahao tedseje qqui inabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nadsapa Abarahaodsa huahua najari: “¡Idi Abarahao, ohuadsa teti huana taji! Lasaro ohua acco camahijine pohua dsepe cote passodsa iquehedsippa nadsa dosse tajonajo, ohuebeno tonahuini nanijine. Ohuapi aji jororoni ppocoranidsa ocasserani ohuani” najari. ");
INSERT INTO cul_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Naraha Abarahao pohuadsa huati tajari: “Neppe, teti huatomaji. Tahide namihuaji timadiponipi bicani tepode. Naraha Lasaropa ocasserehedsa madipode. Jidapapi Lasarodsa ima bicani tojajaro. Naraha tiapi ocasserani tinahanajaro” najari Abarahao dsepe ssebotedsa. ");
INSERT INTO cul_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","“Ima onihi naqui tia timadi ia imadi nani nocconihuajipi cojojo imeni cahuajiqquimanihuaji imadijarossa najaro. Aja imadinihuajicca madija tiadenihuaji bacco toquinahijine ssamo tani. Manaco nahihuajicca madija iahuaji bacco najonahijine ssamo tani. Nadsama Lasaro tiahuaji dosse onahijine naco ssamo tani” najari Abarahao. ");
INSERT INTO cul_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Naraha dsepe sse tajari huati tapomajari: “Idi Abarahao, Lasaro namihuaji dosse tinaronanijo, occa abicca odsahuaji ohuemecotedenidsa huati tahijine. ");
INSERT INTO cul_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nadsama ohuapi ohuemecote 5 quinaha ocajidija. Pohuadenidsa ohuatti Lasaro huati tanihijine: ‘Paji Diocca dossenijidsa iboqquiri tiquinadsapi nacasserehehuaji bacco tiquinanitohui’ nahijine pohuadenidsa” najari dsepe ssebote atti. ");
INSERT INTO cul_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Naraha Abarahao huati tapomajari: “Dio Atti Moisesi dsodo inajaro, Dio Atti cacomeraqquiri najarideni dsodo quinajaro naqui cajimanahi. Najaro ima mittamanadsa bodideni cacajiqquimera-manahijine pajiramanahi” najari. ");
INSERT INTO cul_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Naraha dsepe ssebote attia: “Jehe idi Abarahao, najaro dsodo nani cajimanaraha najarodsa pajissa quina-jarajari. Naraha madija dsoqquejari nahatonidsa pohuadenihuaji huatide toccanidsana pajissa quinahitohui, poccadeni imasiri inebomananijine” najari dsepe ssebote atti. ");
INSERT INTO cul_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Naraha Abarahao attia pohuadsa: “Dio Atti Moisesijine dsodo nani cajimana, Dio Atti cacomeraqquiri najaridenijine dsodo nani naqui cajimana nahi. Najaro Dio Atti mittamana-jaradsapa aja madija dsoqqueraha nahatonijari attidsa naco mittamana-jarahitohui. Pajissa quina-jarahitohui” najari Abarahao atti −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nadsapa Jeso pocca dodosse tabaqquidsa huati tajari: —Aji namidsa timadimanajaropi ima tinanamananijine caji tani. Paji, nema najarodsa imasiri tinanamana tani. Naraha madijajine imasiri tinanamanadsapi pohuadsa ima denima oppina tanicca ssonarinitohui. Madija nama najaripa Diona inajidsohuitohui. ");
INSERT INTO cul_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nadsama madija ojariajine ohuadsa jehe quinajari imasiri inanamanadsapi pohuadsa najidsohue oppina tanicca ssonarinitohui. Ejedeni ohuadsa jehe quinajarideni naco madija imasiri mamaridejine imasiri tocahatteradsapa aja imasiri mamaride pohuadsa najidsohue oppina tanicca ssonarinitohui. Pina ajijaro imassa najaro: Siba ccanajabote pohua mattodsa ssoque dsanadsa passo imenihuaji je tahijine cco todsippadsapa oppina taraha najidsohue denima oppina tanicca pohuadsa ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Paji! Tiadenipi tiadeni tecahuamananissa taji, imasiri tinanamana-jeranijine −najari Jeso. —Nadsama timecote ohuadsa jehe najari tiadsa imasiri inanadsapi manaco mohuaradsa pohua huati ticanajo: “Ohuadsa tijine ima bica tejerani” tana. Nadsapa pohua cacomeradsapa: “Jehe, tiadsa nema onade. Ojine bica tejerani. Jidapapi nema onapoma-jeranitohui” nadsapa manaco pohuadsa: “Jehe, epejena, tiadsa ohuadi-jerani” tana, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nadsapa timecote ohuadsa jehe najari tiadsa tabaccorehe inanajaro. Dsotode tiadsa imasiri inanapomajaro. Dsotode naqui tiadsa tabaccorehe inanapomajaro. Nama dsanaporaha pocca imasiri jicani nattinipa pohua atti tiadsa: “Epeje, ojine tiadsa bica tejerani. Jidapapi nema onapoma-jeranitohui” nadsapa manaco pohuadsa tettipi: “Jehe, epejena, tiadsa ohuadi-jerani” taji, onajaro. Huada ojariedsa nama dsanapojari 7 nehe bacco taraha nema nehe pocca imasiridsa epeje tidsanapoji, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nadsapa Jesodsa pocca dodosse tabaqquipa huati toquinajari: —Ia Medsede, icca jeheniji Diodsa todacorani nanijine iadsa denima tinanaji −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nadsapa manaco ia Medsede pohuadenidsa huati tajari: —Ticcadeni jeheniji badsira tehe pina mostaza nocco badsira tajarissa nehe ticajimanadsapi ssamo tanicca tinanamananijine tipajiramananitohui. Pina ajijaro ahuadsa huati tiquinadsa: “Ahua, tia motta jeo tinadsa passo imeni inididsana tia ppa tidsana” tiquinadsapi ahua tettidenidsa ibora tanitohuiraha −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Madijacca tatarabaidsade tarabaidsahuaji ccaccani nadsa pohua dossede attipa ¿nejecoma napadsaja? Pina huidsaja ppade ccanidsa, pina edede cacahuade ccanidsa nadsapa pohua dossede: “Jehe, ajidsa tittaridsa tijipaji” ¿napadsaja? Nama najarahitohui pocca tatarabaidsadedsa. ");
INSERT INTO cul_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pohua dossede attipa ajama nahitidija: “Ohuadsa dsamatapa ppe tadsa, ojipanijine tinajoradsa jijipa hua tarijo. Nidsa ohuajari jicani nattinina manaco tijipanijine” nahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","—Nadsapa tatarabaidsade pohua dossede attissa inanadsa pohua dossede attipa: “Jehe, tijine bica tani” ¿napadsaja? Nama najarahitohui. Najaropi pocca tarabaidsa epeje. ");
INSERT INTO cul_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nadsama tiadeni naqui Diocca dosseniji tecahuamananissa tadsapi tettideni: “Epeje, najaropi ia icca idsepe ijie” titiquina nana. “Iapi deni iquejena-jerani. Ia dossedecca tatarabaidsade iquejenani” titiquina nana −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nadsapa Jeso pocca benehidsa Jerosarehuaji toccajari. Dsama arobeni onini Samaria, dsama arobeni onihi onini Carirea tadsajani ttomoqquinihuaji ccaridsajari. ");
INSERT INTO cul_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nadsapa nanihuajicca odsa capamema nahihuaji Jeso bacco tajari. Nahidsapa madija 10 quinajari dsamacoma onini leprajine huapideni jadsimanahi madimanajari. Nadsapa Jesohuaji jai tojajari, pohuadsa huajiji nadsa domo hua najari. ");
INSERT INTO cul_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jadsirema pohuadsa huahua quinajari: —¡Jeso, ia Medsede, iadsa teti huana taji! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nadsapa Jeso pohuadeni qqui inabaqquidsapa pohuadenidsa huati tajari: —Diodsa dada toqquimadedenihuaji jai tijedsimadsa pohuadenidsa tepideni nohue tiquinaji −najari. Nadsapa pohuadeni huapi nohuede jahui jai tojaninaja tocanomirejari. ");
INSERT INTO cul_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nadsapa ojaria pohua huapi tobicahi qqui tadsapa dsodonijari. Huatidsedsa jadsirema: —¡Diopa bica tahi, bica tahi! −nanijari. ");
INSERT INTO cul_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesodsa bacco nanidsapa —Jehe bica tinani −nahijine Jeso baccohuaji pohua pitodsa huitta, tocattedsa nadsa assari namidsa bacco tajaro. Nadsama aja madija dsodonijaripa dsama Samariacca. ");
INSERT INTO cul_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nadsapa Jeso huati tajari: —Naraha aja ¿madija 10 quinajaripa tocanomire-jaraco? Tocanomireraha mota 9 quinajaridenipa ¿nejecohuaji? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","—Ajajaripa icca madija jodio jararaha pohuapa dsodonidsa Diodsa huatidsenijari. Motapa Diodsa: “Jehe, tijine icanomireni bica tani” nanimana-jarahi −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nadsapa pohuadsa Jeso huati tajari: —Titehemadsa ticcaniji. “Jehe, Dio ohua tonanomihi pajirahi” tadsapi tinomijaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nadsapa marinaja pariseodsa jehe quinajarideni Jesodsa huati toquinajari: —¿Nejecoma nadsa Diocca cacahuehe tojapadseje? −quinajari. Naraha Jeso pohuadenidsa huati tajari: —Diocca cacahuehepi ahuatora tani, inoccodsa qqui inejerani. ");
INSERT INTO cul_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Madijapa: “Qqui taji, Diocca cacahuehe ajidsa bacco nani, ajiccadsa bacco tani” quina-jarahitohui. Diocca cacahuehepi jidapana tiadenidsa tojaridsani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dsotodepa pocca dodosse tabaqquidsa huati tajari: —Ohuapi Madija Bedi ojajaroa nidsa occaronapomanicca huada bacco tani tohuini tiquinadsapi: “Jaho, najaro huada qqui inaccaraho” tiquinaraha nohueraccanitohui. ");
INSERT INTO cul_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Naraha madija tiadenidsa maidsamanadsapa ajama quinahitohui: “Qqui tiquinajo, Cristo-Mesia ajadsa bacco nanihi, ajaccadsa bacco nanihi” quiquinanahitohui. Naraha madija attideni nama quinadsapa: “Jina qqui inana” tiquina tejerana. ¡Poni! ");
INSERT INTO cul_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ohuapi Madija Bedi ojajaroa occaronapomanicca huada bacco tadsapi ahuato tanitohui. Pina ssissiede memedsa ssie nadsa meme nemanehe tossiajabaqquijarossa nanitohui. ");
INSERT INTO cul_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Naraha ohuapi Madija Bedi ojajaroa tahide ima onihi, onihi najaro ocasserani onahanaponitohui. Jidapana madija madimanajarideni naco ohua ettajomanaponitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Ohuapi Madija Bedi ojajaroa nidsa occaronapomadsapi pina maittaccadsama Nohue madipodsa ppani ccajonajarocca imassa nanitohui. ");
INSERT INTO cul_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Madijadenipa jijipamana najari, dse dse quinajari, caji caji canajari. Nama quiquinanapojaria aja Nohue pocca canoa imenidsa toqquedsimahicca huada bacco tajaropaji. Naraha madija motapa ssamoqquiri nadsa ppani bacco najonadsapi huapima je tocaniredsa jicajari. ");
INSERT INTO cul_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Dsotode Abarahaocca ejedeni ohuaha Rote odsa panani Sodomahuaji madidsa naco pina aji Nohue madipohuicca imassa napomajaro. Madijadenipa jijipamana najari, dse dse quinajari, todsepetaji mitta mitta quinajari, poccadeni dsamatapa da da quinajari, poccadeni huidsaja ppa ppa quinajari, poccadeni odsa ihinahatomana najaro. ");
INSERT INTO cul_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Naraha Rotepa Sodomadsa nebodsa joppa taraha najaro huadadsa Diojine memehuajicca jororoni azufre quejemani Sodomahuaji catojadsapi madija huapima jicajari. ");
INSERT INTO cul_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jehe, ohuapi Madija Bedi ojajaroa occaronapomanicca huada naqui najarossa nanitohui. Pina Nohue madipodsassa, pina Rote madipodsassa najaro. Nidsa dsotode ajijaro namidsa jidsera onanipomadsa madija mota otohui najoramana-jarajaridenipa jicahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","—Nadsama najaro huada bacco tadsapi madija pocca odsa amossinihuaji ccaridsadsapa pohua dsepetajitohui pocca odsahuaji toqquedsimani-jarana. Madija ohuaha pocca huidsajahuaji dsepe ijijari naco pocca odsahuaji toccani-jarana. ");
INSERT INTO cul_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Aji Rotecca amonejecca ima tetideni ajimamana-jerana. Ponidsa Dio Attipa: “Tinattihuajipi qqui tani tejerana” naraha poni nattinihuaji qqui nanidsapi siba tojajaro. ");
INSERT INTO cul_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Madijapa pocca madie Diodsa acco tadsa ajijaro namidsa madi-dsanapohuijine tohuinira nadsapa dsoqquehitohui. Dsoqquedsapa camittehe jiquejeranicca caji-jarahitohui. Naraha madijapa pocca madie Diodsa eccoradsapi pohua inanadsoqque-manaraha camittehe jiquejeranicca cajidsanapohuitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Jehe, nidsa occaronapomanijine ima ajima nanitohui: Madija pamaha dsome huahuadadsa cahadijaraha ojaria otohui najorapojarina iaccamacossanihitohui. Naraha ohuahapa otohui najora-jaradsapa inebohuitohui. ");
INSERT INTO cul_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Amoneje pamehe dododsa dode toquejenajaro naqui. Ojarie otohui najorapojarona iaccamacossani-nitohui. Naraha onihipi otohui najora-jeradsapi inebonitohui.  ");
INSERT INTO cul_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Maqquideje pamaha huidsajahuaji dsepedeni ijimanajari naco. Ojaria otohui najorapojarina iaccamacossanihitohui. Naraha ohuahapa otohui najora-jaradsapa inebohuitohui −najari Jeso.  ");
INSERT INTO cul_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Najaro ima Jeso huati huati taha jicadsapa pocca dodosse tabaqqui pohuadsa huati toquinajari: —Ia Medsede, ajijaro imapi ¿nejecoma nanidsana tojapadseje? −quinajari. Naraha Jeso pohua cacomerajari: —Abaridsa toqueriqquinidsa bani huatiahi ponahi nahatoqquiri tiquinajaro. Pina najaro imassa najaro occaronapomadsapi madija huapima nahatoqquiri nahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesopa ajijaro namidsa imadinicca imadsa pocca dodosse tabaqqui mari icanabaqquijari. Madija Diodsa huatide disseraqquiri nahijine, —Diopa ohuatti mitta-jarahi −quina-jarahijine huati huati tajari. ");
INSERT INTO cul_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nadsapa ima ajima najaro huati tajari: —Odsa pananihuajipa ima cacattemade madijari. Pohuapa Dio noppine cappina-jarajari. Madijadsa naco cappina-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Najaro odsa pananidsa amoneje maqqui dsoqquejari madijaro. Ponipi huajijiradsa ima cacattemadedsa huatide totocca najaro: “Ohua acco ticamaji” naneje najaro. “Madijacca nacasserehe onahana-dsanaponi” naneje najaro. ");
INSERT INTO cul_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Naraha pohuapa poni acco camade ibojide rajari. Naraha dsotodena bodi huatodsa ajama najari: “Diodsa ocappina-jerani madijadenidsa naqui ocappina-jerani. ");
INSERT INTO cul_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Naraha aji amoneje tabira tocajajaro ohuadsa tonajo huati cajiradsapi poni acco ocamana. Acco ocama-jeradsapi poni attini ohuadsa tocasseraqquinitohui” najari ima cacattemade ibobote. Nadsapa poni acco camade tohuiborajari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nadsapa ia Medsede Jeso attipa: —Jehe, ima cacattemade bica tajarajaripa atti nama najari. ");
INSERT INTO cul_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pohua atti nama naraha Diopa nama najarajari. Pohuapa bica tajari. Pocca tocattejidsabaqquinaja attideni mittajari. Pohuadenipa Diodsa ssiaja huati, dsome huati totoquina najari. Nadsapa ¿Dio pohuadeni acco icamabaqquihijinepa najopadsaja? Najo-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Najaroa tiadenidsa huati onajaropaji: Diopa najo-jaradsa tiadeni acco tocamabaqquihitohui, onajaro. Naraha ohuapi Madija Bedi ojajaroa nidsa occanipomadsapi ¿occa madijapa Dio Pohuadsa huatide disseraqquiri nahipaja napadsaja? Pohuadeni naco: “Jehe, Dio ohua acco camahi” ¿quiquinanahipaja napadsaja? onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesodsa queriqquimanajari mota bodidenipa: —Jehe, ohuapi Moisesicca marinaja ohuacahuanissa tajaro, bica onani −quiquinanajari. Najari bodideni naco: —Madija ohuassa quina-jarajaridenipa Moisesicca marinaja ecahuamananissa tejerani, bicaqquiri najarahi −quiquinanajari. Naraha Jesopa najarideni bodicca ima nahato tadsapa ajijaro namidsa imadinicca ima huati tajari. ");
INSERT INTO cul_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Madija pamahapa Diodsa huati toquinahijine dada toqquimahuaji tohuededsimajari. Ojaria Diodsa dissera tajari, pohuapa marinaja onini pariseodsa jehe najari. Ohuahapa imasiri sse tajari, pohuapa romanodenicca taminecca dosseniji dsiniro nanaccade. ");
INSERT INTO cul_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Nadsapa marinaja pariseodsa jehe najari huadsa Diodsa huati tadsapa ajama najari: “Jehe Abi Dio, tiadsa bica onajaro, ohuapi pina madija ohuahadenissa onejerani. Pina bobotidedenissa, pina mamaidsadedenissa, pina amonejecca cahassibotedenissa onejerajaro. Pina ajajari romanodenicca taminecca dosseniji dsiniro nanaccadessa onejerani. Bica onajaro” najari. ");
INSERT INTO cul_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Ohuapi semana huajijiradsa jipehe ohonebocossa najaro. Ohuapi occa dsiniro ohuadsa totoja najaro mota naqui tiadsa da da ohodsanapo najaro” najari. ");
INSERT INTO cul_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Naraha romanodenicca taminecca dosseniji dsiniro nanaccadepa huajima huajari. Madija ohuahadenipa tocattamacossamanadsa Diodsa huati huati toquinaraha pohuapa cappinaja najari tocattedsa najari. “Tabaccora onani” najari. Pohua attipa: “Abi Dio, ohuadsa teti huana taji. Ohuapi imasiri ocajini” najari taminecca dosseniji dsiniro nanaccade −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Najaro ima huati taha jicadsapa aja —Bica onani −quiquinanajaridenidsa Jeso attipa: —Nadsama ohuapi tiadenidsa huati onajaro. Ajajari maqquideje imasiri sse tajaripa pohua bodi tobicadsapa pocca odsahuaji toccanijari. Pocca ima Dio sse ineje najaro, Diodsa tobicajari. Naraha madija ohuaha marinaja pariseodsa jehe najaripa Diodsa bodi tobica-jarajari. Pocca ima mota tabaccora taniccapi Diodsa huati tajaradsapa pocca ima Dio sse inejereje najaro. Jehe, madijapa: “Occa biquehe qqui tiquinaji” nanaja najaripa Diodsa ajamani tojahitohui. Naraha madijapa: “Ohuapi ajimani ojani” nanaja najarina Dio deni inanahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nadsapa madija poccadeni ejedeni badsiraqquiri najarideni Jesodsa eccajonabaqqui-manajari, —Jeso tatideni bara inabaqquidsa Diodsa huati tahijine −quinadsa. Naraha Jesocca dodosse tabaqqui qqui toquinadsapa attidenia: —¡Ejedenipa pohua! ¡Jesohuaji teccajonabaqquimana tajarajo! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Naraha Jeso pohuapa ejedenitohui huahua najari. Pohua huatimadedenidsa pohua attipa: —Pohuadeni jahijonana, onajaro. Eccajonabaqqui-manahijine tecossamana tejeraji. Madijapa pina ajajari ejedenidenissa quinajarina Diocca cacahuehedsa toquejenahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Pajissara tiadenidsa huati onana: Madijapa pohua bodicca jeheniji pina ejedenicca jehenijissa najaradsapa Diocca cacahuehedsa toja-jarahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Madija ojaria tamine tojajaripa Jesodsa huati tajari: —Nija Mamaride bicahi ¿nejecoma onadsa camittehe jiquejeranicca bacco onanijine? −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Naraha manaco Jeso pohuadsa huati tajari: —¿Nejecotohui ohuadsa: “Mamaride bicahi” tajaro? Madija bicahi nohuerahi. Diona bica tahi ojarihi. ");
INSERT INTO cul_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Naraha camittehe jiquejeranicca bacco tinanijinepi Diocca dosseniji Moisesi dsodo inajarocca nahato tinani. ¿Najaro huapima tecahuanissa taqui? Pocca dossenijipi ajima najaro: “Madija ohuahacca amoneje tija tejeraji. Madija tinanadsoqque-jarajo. Tiboti tejeraji. Maidsehedsa naqui madijadsa ponima ima tinahana tejeraji. Ticca abi, ticca amidsa bica tinadsa tinamadibaqquihissa tajo” nani Diocca dosseniji Moisesi dsodo inajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Naraha tamine attipa: —Najaro dosseniji huapimapi dsabisso ojapodsama ohuacahuajonajarode −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Naraha Jeso tamine atti mittadsapa pohuadsa huati tajari: —Naraha ima ojarie tiadsa dsori taccani. Ticcanidsa tidsepetaji nemanehe manaconidsa da tinaridsaji. Nani najaro dsiniropi madija tohuati nahanaqquiri najaridenidsa da tinabaqquinijine. Nema tinanadsapi nidsa memehuaji Diocca biquehe tiadsa tojanitohui. “Nema onana” tadsapi ohuadsara dissera tinaji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Naraha taminepa najaro ima mittadsa: —Jehe, nema onana −najarajari. Pohua dsepetajitohui, pocca dsinirotohui huati huana tajari. Pohuapa dsepe sse taja nadsapa bodi ocassera taha hua canajari. ");
INSERT INTO cul_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tamine bodi ocassera tahi Jeso qqui tadsapa huati tajari: —¡A, madija dsepedeni sseqquiri najaridenipa Diocca cacahuehedsa toquejenahijine najo tani! −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","—Pina bani imehibote camello etero ssessequi odinidsa toqqueqquimahijine pajira-jarajarissa najari. Madija dsepe sse tajaripa Diocca cacahuehedsa tojahijine ssamo tani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nadsapa Jeso atti nama nahi mittamanadsapa madija attidenia: —Jaho, madija tocassiejerahijinepa ssamo tani. ¿Nejecojarina tossiajapadsaja? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Naraha Jeso attipa: —Madijapa ssamomo taraha Diodsapi ssamo tejerani. Pohuajinena madija tocassiejerahitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Naraha Pedropa Jesodsa huati tajari: —Ia Maride, iapi tiadsa jaijaridsanijinepi icca odsa, icca madija, huapima ineboridsabaqquide −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Manaco Jeso pohuadenidsa huati tajari: —Pajissara tiadenidsa huati onana: Madija ohuadsa dsepe ijihijinepa pocca odsa icanebo, pocca amoneje inebo, pohua imecote inebobaqqui, pocca abi, ami inebobaqqui, pocca ejedeni inebobaqqui nadsapa Diocca cacahuehe madijadsa tojaridsanijine dsepe ijiridsajari. ");
INSERT INTO cul_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nadsapa nidsa dsotode huapima pohua ineboridsajarossa nehe Diojine cajipomahitohui. Jidapana ajijaro namidsa pohua madiccadsa huemani cajihitohui. Nidsa Diojine dsama dsati tojadsa naqui camittehe jiquejeraniccadsa madi-dsanapohuitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesopa pocca dodosse tabaqqui 12 quinajari tedseje Jerosarecca jahui jai tojadsa pohuadenira huahua inabaqquidsa pohuadsa queriqquijari. Nadsapa pohuadenidsa huati huati dsanapojari: —Aji odsa panani Jerosarehuaji jaijemorajaropi nahatoqquiri tiquinani. Ohuapi Madija Bedi ojajaroa nidsa Jerosare bacco inadsapi aja Dio Atti cacomeraqquiri najarideni otahimari dsodo quinapojaropi ohuadsa tojanitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ohuapi madija ohuaha jodio quejena-jarajarideni dsepedenidsa ojanitohui. Najaridenina ohua jaja icanaqquimanajaro, ohua itamassoqquimanajaro, ohua ppito inaqquimanajaro nanitohui. ");
INSERT INTO cul_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nadsapi ohua cossi inaqquimanadsapi ahua porimacossanidsa ohua inanadsoqque-manadsa ohua ppa idsamananitohui. Naraha huada huatinimade tojari nadsa onahatoninitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Naraha pocca dodosse tabaqquidsa Jeso pohua tahimari huati huati taraha mittamana-jarajari. Pohuadeni bodidsa najaro ima ahuatora tajaro. Pohuadenipa: —Ja, pohua dsoqquehijinecca ima huati tajari −quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesopa odsa panani Jericohuaji tohuajirajonadsapa jahui inididsa madija nocco siri huihuitta najari. Pohua dsepe da nadsa: —Ohuadsa dsiniro da tiquinaji −tatacossa najari. ");
INSERT INTO cul_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nadsapa madija huapima pohuahuaji jai tojeqquimama canahi mittadsapa huati tajari: —¿Nejecotohui madija huapima jai tojeqquimama canajari? −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Naraha pohuadsa huati toquinajari: —Jeso Nasaretihuajicca huajirajonahi −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nadsapa nocco siri huahua najari: —¡Jeso, Dabi Potemahi! ¡Ohuadsa teti huana taji, onaha! −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Naraha madija tahidejonamanajari attidenia: —¡Poni! ¡Joma taji! −quinajari. Naraha denima paja huahua tarihi huahua tarihi najari: —¡Tamine Dabi Potemahi! ¡Ohuadsa teti huana taji! −napomajari. ");
INSERT INTO cul_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nanaja Jeso ccajonaraha mittadsapa huaha tahi nadsa: —Jari, nocco siri ahuaji teccajonamanajo −najari. Nadsa eccajonamanadsapa pohuadsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Nejecora tiadsa onananijine? −najari. Naraha nocco siripa: —Ohua Medsede, onocco ssire tinanaji, onajaro −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nadsapa Jeso: —Jehe, tinocco ssire tana. Tibodi ohuadsa pajissa tadsapi tinomini −najari. ");
INSERT INTO cul_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nadsapa Jesojine amadsati pohua nocco ssire tadsapa Jesodsa toccajari. Diodsa huatidseri dsanapojari. Madija huapima naco pohua nocco tonomihi qqui toquinadsapa huatidsemanadsa: —¡Diopa bica tahi, bica tahi! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesopa odsa panani Jerosarehuaji toccahijine tahidepa odsa panani Jericodsaha bacco tapojari. Nadsapa Jerico nocconi toqqueqquimahijine toqquedsimajari. ");
INSERT INTO cul_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Naraha nahidsapa maqquideje dsepe ssebote madijari, pohua onipa Saqueo. Pohuapa jodiodeniraha romanodenicca taminecca dosseniji dsiniro nanaccadedenicca tamine tojajari. ");
INSERT INTO cul_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nadsapa —Jeso ccajonahi −quinahi mittadsapa Saqueo bodipa: —Jeso qqui onana −najari. Naraha pohuapa tere tajarijine, madija huapi tadsapa Jeso qqui inajarajari. ");
INSERT INTO cul_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nadsapa Saqueo madija jai tojeqquimahi qqui tadsapa tedsejemadenina joppa tajari: —Aji ahuadsa occamarodsa Jeso toqqueqquimahi qqui onana −nadsa ahuadsa toccamarojari. ");
INSERT INTO cul_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Naraha Jeso Saqueo huittarihihuaji toqqueqquimadsapa Saqueo ahuadsa huittarihi qqui tajari. Nadsapa Saqueodsa huahua najari: —¡Saqueo, huassinaja ticcaronaji! Ohuapi jidapana ticca odsahuaji omadiccana, onajaro −najari. ");
INSERT INTO cul_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nadsapa Saqueo huassinaja ccaronadsa Jesodsa: —Jehe, occa odsadsa timadiccaji −najari. Saqueo pocca odsahuaji Jeso iaccanidsapa tohuatidsenijari. ");
INSERT INTO cul_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Naraha madija huapimapa Jeso Saqueocca odsadsa toqquedsimahi qqui toquinadsapa pohuadenira imahaha canajari: —A, Jesopa imasiri ssebotecca odsadsaraha toqquedsimaha. Jeso nama nadsapa iadsa bica tejerani −quinajari jodiodeni atti, aja romanodenicca taminecca dosseniji dsiniro nanaccadedenidsa jiperaqquiri nadsa. ");
INSERT INTO cul_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nadsapa odsadsa jassi todsanaja Saqueo totehemadsa ia Medsededsa huati tajari: —Jehe ohua Medsede, jidapapi ajima onana: Aja cappiramanajaridenidsa odsepetaji arobeni ocanarobenissa taridsadsapi pohuadenidsa da onaridsana. Nadsama aja ocamaidsabaqquijaridenidsa naqui pina aja ocamaidsabaqquipojarissa nehe pohuadenidsa da omanina. Nadsapi pohuadenidsa najarossa nehe denima da, denima da, denima da omaniridsanijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nadsapa Jeso madija huapima mittamanahijine huati tajari: —Jehe, jidapana ajajari maqquidejepa pocca imasiri inebodsa Diodsa pajissa nadsapa pina maittaccadsama pocca idi Abarahao Diodsa pajissa najarissa najari. Nadsapa pohua, pocca odsacca madijadsa naqui Diocca tossiejehe tojaridsani ahuato tani −najari Jeso atti. ");
INSERT INTO cul_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","—Nadsama aji ohua Madija Bedi ojajaropi madija jano toquejenajarideni pina ajajari maqquidejessa quinajari qquide occajonajaro. Imasiricca dodosse toquejenajarissa quinaraha onassiajabaqquihijine. Huapima ohuadsa pajissa quinadsapa camittehe jiquejeranicca cajimanahijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesopa Saqueodsa huati huati tahidsa madija queriqquimanajarideni mittamanajari. Jeso Jerosarehuaji tohuajirajonadsa pohuadeni bodi attidenipa: —Nidsa Jeso Jerosaredsa bacco tadsapa amadsati Diocca cacahuehe tojanitohui −quinaraha najaro ima tojanijine jerani. Nadsapa Jeso pohuadeni bodi huatomanahijinepa ajijaro namidsa imadinicca imadsa mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jeso attipa: —Dsama huapimacca tamine deni tojahicca dsama onihicca deni toquejenajarideni ojariadsa huahua najari: “Tia ocattejidsajaro, ticca dsama arobeni cacahuade tijanijine. Ohuadsa huatide ahuaji ticcajonaji” najari. Nadsapa huaji taraha pohuahuaji huatide toccahijine najorajari. Pohua bodipa: “Nidsa occanidsa ohuapi occa dsamacca tamine ojanitohui” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nadsapa toccabote nadsa pocca dodosse tabaqqui mota 10 quinaha huahua inabaqquijari. Nadsapi dsiniro ccarara huatini ccara tanicca 10 najaro pohuadenidsa ojari ojari nehe da inaridsajaro. Nadsapa pohuadenidsa huati tajari: “Ajijaro dsinirodsa mitta, da, mitta, da taridsamanana, dsiniro tohuapinijine. Nidsa occanidsapi ohuadsa nemanehe da tanimananijine” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Aja tamine tojahijinepa tamine deni tojahicca madihihuaji toccajari. Naraha toccahi nattipa pocca dsamacca madijapa pohuadsa jiperaqquiri nadsapa madija dosse inabaqquimanajari, tamine deni tojahiccadsa huati toquinahijine. Bacco toquinadsa attidenipa: “Aja ticattejidsajaripa icca tamine tojahijine jiperaqquiri inani” quinajari, dsama huapimacca taminedsa. ");
INSERT INTO cul_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Naraha tamine deni tojahiccapa attidenidsa jehe najaradsa pohua icattejidsajaripa tamine inanajari. Nadsapa tamine tojadsapa pocca dsamadsa dosse dosse nahijine toccanijari. Bacco nanidsapa pocca dodosse tabaqqui pohuadenidsa dsiniro da inaridsajarodenidsa huahua najari, “¿Dsiniro nejecoma nehe tojani?” nahijine. ");
INSERT INTO cul_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nadsapa tahide qquedsimapojaria pohuadsa huati tajari: “Ohua dossede, ticca dsiniro ccarara cajariraha ojine deni tojadsapi 10 nehe tojani” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nadsapa tamine tojedsati manaco pohuadsa huati tajari: “Jehe, tiapi occa dodosse bica tinani. Ohuattidsa ibora tinadsapi occa dosseniji ima bedeniraha tijine toccanissa tadsapi odsa panani 10 najarocca cacahuade tijanitohui” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pocca dodosse ohuaha naco qquedsimadsa huati tajari: “Ohua dossede, ticca dsiniro ccarara cajariraha deni tojadsapi 5 nehe tojani” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nadsapa tamine tojedsati manaco pohuadsa huati tajari: “Jehe, tiapi odsa panani 5 najarocca cacahuade tijanitohui” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Naraha pocca dodosse ohuaha qquedsimadsapa pohuadsa huati tajari: “Ohua dossede, ajijaropaji ticca dsiniro. Eterodsa jore onaqquinissa tadsa ohuacahuajaro. ");
INSERT INTO cul_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ohuapi tinoppine ocappinajaro. Tiapi madijadsa daco tijirajaro. Tiapi tarabaidsa tejeraraha ticca dodosse tabaqquijine titicaji najaro” najari. ");
INSERT INTO cul_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nadsapa manaco tamine tojedsati attipa: “¡Occa dodosse tabaccora tinani! Tia tettijine tiadsa ima ssonarijaro. Aji ohuattidsa ibo tinadsapi ohuadsa bica tejerani. Tettipi ohuadsa: ‘Madijadsa daco tijirajaro. Tarabaidsa tejeraraha ticca dodosse tabaqquijine titicaji najaro’ taha. Naraha occa ima nahato tinadsapi ");
INSERT INTO cul_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿nejecotohui occa dsiniro tohuapinijine dsiniro ehecahuamana nanihuaji da tidsima-jerajaro? Nassa occanidsapi aji occa dsiniro tohuapijarocca tadsajani ocajinitohuiraha” najari tamine atti. ");
INSERT INTO cul_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nadsapa aja pocca dodosse tabaqqui domodeni huaridsajaridsa huati tajari: “Jari, occa ccarara tidinimanadsa ccarara 10 cajijaridsana da tiquinaji” najari tamine atti. ");
INSERT INTO cul_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Naraha pohuadeni attipa: “Ia dossede, najaripa ccarara 10 nehe cajia” quinajari. ");
INSERT INTO cul_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Naraha tamine attipa: “Epejena, ohuapi tiadenidsa huati onajaro: Madija occa dossenijidsa dissera tadsapa pohuadsa denima tojanitohui. Naraha aja madija occa dossenijidsa dissera tajaradsapa cappirahissa tahitohui. Badsira tehe cajiraha najaro naqui todininitohui. ");
INSERT INTO cul_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nadsama aja ohuadsa huadiqquiri najarideni tamine ojanijine jiperaqquiri najarideni ohuahuaji teccajonabaqquimanadsa obaccohuaji domo huadsapa tinajica-baqquimanajo” najari tamine tojedsati atti −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesopa ima huati huati taha jicadsapa denima jai tojajari, Jerosarehuaji bacco toquinahijine. ");
INSERT INTO cul_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tahidepa ssono onini Oribodsa jai tojemorajari. Najaro ssonodsa odsa capamema najaro pamehe anijaro, oninidenipi Betapaque, Betania najaro. Najaro odsa pamehedsa bacco toquinabote nadsa pocca dodosse tabaqqui pamahadsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Jari, ajicca odsa capamema nanihuaji ticadapoji. Nanihuajipi bojo namidsadsa napidsati ssoque dsanaha huahi. Najari bojopa idedsa madija huittari-jaraccahi. Najari dicca tiquinadsa teccanimanajo −najari. ");
INSERT INTO cul_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","—Naraha tiadenidsa madija attipa: “¿Nejecotohui bojo dicca tiquinajari?” nadsapa pohuadsa huati tiquinana: “Ia Medsede ajajari bojo tohui nadsapaja” tiquinana −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nadsapa tohuedanaja, bojo napidsati ssoque dsanaha huahi qqui quinajari, pina aja Jeso huati tajarissa najaro. ");
INSERT INTO cul_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bojodsa bacco toquinadsapa dicca quinanaja jinedepa: —¿Nejecotohui occa bojo dicca tiquinajari? −najari. ");
INSERT INTO cul_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Naraha manaco pohuadeni cacomeramanajari: —Ia Medsede tohui nadsapaja −quinajari. Nadsapa jinede jehe nadsa eccanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nadsapa bojo eccanimanajari... Jesohuaji bacco nanimanadsapa poccadeni etero huapicca motarajaro ssiti quinadsa bojo idedsa bina quinadsa nahidsa inahittarimanajari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nadsapa Jeso bojodsa toccahi tedsejema pohuadsa jahiridsajarideni poccadeni etero jahui bina idsanapomanajaro, pohuadsa: —Deni tijani −quinahijine. Nadsapa Jeso jahui bina tani motta toccadsanapojari. ");
INSERT INTO cul_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nadsapa ssono Oribo jahui toqquedsippanihuaji bacco tabote nadsa pocca dodosse tabaqqui, pohuadsa jahiridsajarideni huapima Jeso canahato-huajapohui canahi qqui toquinapoja najarijinea Diodsa tohuatidsemana-dsanapojari. Jiri jiri dsanapomanaja mohua mohua dsanapomanaja najari. ");
INSERT INTO cul_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Attidenipa: —¡Ia Medsede onima ccajonajaridsa biquehera tojana, tojana! ¡Pohuapa ia Isaraeri potemahideni icca tamine! ¡Pohuadsa biquehera tojana, tojana! −dsanapomanajari. —Memehuaji Dio icca imadsa cajoneri canahi, canahi, najaro jonehe tojaridsanijine. ¡Memehuaji Diodsa madimanajarideni pohuadsa: “¡Deni tijani!” quinana, quinana! −quinajari, huahua dsanapomanadsa. ");
INSERT INTO cul_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nadsapa nahi odsa pananihuajicca madija huapima Jesocca madija tedseje toqueriqqui najari. Naraha nahidsa jodiodeni mota marinaja pariseodsa jehe quinajarideni quejemamanajari. Najarideni motaha Jesodsa huati toquinajari: —Mamaride, ticca dodosse tabaqqui huati tinabaqquijo. Nama nama quinahipa oppina tani. Pohuadeni joma tinanabaqquijo −quinajari. Aja pariseodenipa Jesodsa huatidsemanahijine jiperaqquiri najari. ");
INSERT INTO cul_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Naraha Jesopa pohuadenidsa huati tajari: —Tiadenidsa huati onana: Aja occa dodosse tabaqqui joma onanabaqquidsapa aji jahui inidicca sibana Diojine mohua mohua quinanitohui. Occa ima huati toquinanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nadsapa Jeso Jerosarehuaji tohuajiradsa najaro odsa panani qqui tadsapa nahicca madijatohui oji oji najari. ");
INSERT INTO cul_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Pohua attipa: —A, jidapana tiadenidsa Diocca jonehe tojanitohuiraha ssamoqquiri tiquinajaro. Jehe, ajijaro jonehe pajissacca tohuini tiquinejeradsa najarojine Diocca ima tiadenidsa ahuato tejerajaro. ");
INSERT INTO cul_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Nema tiquinadsapi nidsa ima oppina tehe tiadenidsa tojanitohui. Jerosarecca siba hua nahuajanini memedsararaha idenihuaji ticcadeni huadidenipa nami ppa inamaromanadsa siba hua nahuajanini tetepi bacco toquinadsa cottajahuajanimanaha jicadsapa tiadenidsa ssonarimanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nadsapi tijicaridsanitohui. Ticcadeni odsa siba hua tamaroni huapima naqui pohuadenijine cco-cco bototo tohuedi, cco-cco bototo tohuedi naridsanitohui. Tiadeni Tonassiajade Cristo-Mesia tiadenidsa Dio dosse inaronaraha tibodideni pajissa tiquinejerajaro. Nema tiquinadsapi ima oppina tehe tiadenidsa tojanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nadsapa Jeso Jerosaredsa bacco todsimadsa Diodsa dada toqquimahuaji toqquedsimajari. Najaro odsacca boronidsa madija bani bedi Diodsa da tahijinecca dade toquejenahi qqui tajari. Manaconitohui dadadedeni qqui inabaqquidsapa huapima mohua ininebaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nadsapa pohuadenidsa huati tajari: —Dio Atti dsodo nanidsa ajima najaro: “Occa odsapi ohuadsa huati huati toquinahijinecca odsa tocajanitohui” naponi nade Dio Atti dsodo nanidsa. Naraha tiadenipi madija titicamaidsa-baqquimana nadsa tijinedenia pina bobotidedenicca quequeriqqui odsassa ticananamanajaro −najari. ");
INSERT INTO cul_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesopa huada huajijiradsa Diodsa dada toqquimahuaji mari mari ihicanabaqqui najari. Naraha dada toqquimade taminedeni, jodiodenicca marinaja maridedeni, odsa panani Jerosarecca deni toquejenajarideni quinadsa Jesodsa jiperaqquiri nadsa pohuadeni attipa: —¿Nejecoma inanadsa Jeso inanadsoqquehijine? −quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jeso dsoqquehijine tohuini quinaraha madijapa Jesocca marinaja pohuadenidsa bica tadsa mittade dissassera taja najari. Nadsapa inanadsoqque-manahijine pohuadenidsa ssamo tajaro. ");
INSERT INTO cul_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jesopa huada huajijiradsa Diodsa dada toqquimahuaji madija huapima mari mari ihicanabaqqui najari. Ima bicani icassiejeranijinecca Jeso madija mari icanabaqquiraha pohuadsa jiperaqquiri najarideni aja dada toqquimade taminedeni, jodiodenicca marinaja maridedeni, jodiodeni ime jocohuideni quinadsa Jesodsa tohuajiressimanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nadsapa pohuadsa huati toquinajari: —Iadsa ticca ima tecomeraji. ¿Nejecojaricca dacorehe ticajijaro? ¿Nejecojari attidsa dadadedeni mohua tininebaqquijari? −quinajari, Jeso pohua cacomerahijine tohuini quinadsa. ");
INSERT INTO cul_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Naraha manaco Jeso pohuadenidsa huati tajari: —Ohua naqui tiadenidsa huati onana. Ohuadsa tecomeramanaji. ");
INSERT INTO cul_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Huanopa ¿nejecojari icadossedsa topa idsanabaqquijaritta? ¿Diojine ttarana, madijajine ttarana? ¿Tettideni nejecoma tiquinani? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Naraha taminedenipa pohuadenira huati tocanirere canajari: —Jaho “Huanocca topanijipi Diocca dosseniji” inadsapi Jesopa: “¿Nejecotohui pohuadsa jehe tiquinejerajarotte?” nahitohui −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","—Naraha “Huanocca topanijipi madijacca dosseniji” inadsapi madija sibadsa ia toquinabaqquirana. Aja madija huapima attidenipa: “Huanopa Dio icadossejari. Dio Atti cacomerabotedija” quiquinanade −quinajari taminedeni, madijadeni noppine cappinamanadsa. ");
INSERT INTO cul_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nama quinadsapa taminedeni Jesodsa huati toquinajari: —Huano madija topa idsanabaqquihijine pohua dossedepa ssamomo inani −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nadsapa Jesoa: —Ohua naqui ohua dossede onipa tiadenidsa ohuacomera-jarahi −najari. ");
INSERT INTO cul_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Dsotode Jesopa pocca marinaja ajijaro namidsa imadinicca ima tadsajani madija mari icanabaqquijari: —Madijapa pocca huidsajadsa ppa nahi uva pohuara ppa inajari. Nadsapi pocca huidsaja ecahuamananijine madijatohui qqui naridsajari, nahi pocca huidsajadsa tarabaidsa quinahijine, ppa nahi uva ecahuamanahijine. Uva bono jadadsapa motapa huidsaja jinededsa tojahijine. Motapa huidsaja cacahuadedeni pohuadenidsa tojahijine. Nadsapa pocca huidsaja ecahuamananijine madija qqui inabaqquidsapa pocca huidsaja pohuadenidsa inebojaro. Nadsapa jinede dsama huaji tanihuaji toccajari. Nahidsa madi-dsanapoccahijine. ");
INSERT INTO cul_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva bono jadahicca abadsico bacco tadsapa huidsaja jinedepa huaji tanidsa madiraha pocca dodosse ojaria pocca huidsajahuaji dosse inanijari, huidsaja cacahuadedeni uva bono mota pohuadsa da quinahijine. Naraha pocca dodosse huidsajahuaji bacco nanidsapa huidsaja cacahuadedenipa inajidsomanajari. Uva jiraha dosse inanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nadsapa huidsaja jinede pocca dodosse ohuaha dosse inanijari. Huidsaja cacahuadedenihuaji bacco naniraha najari naco inajidsomanajari. Itamassomanadsa uva jiraha dosse inanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nadsapa pocca dodosse ohuaha dosse inanijari. Naraha najaripa inabiqueramanadsa huidsaja inidihuaji jadsirema joca coro ininemanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—Najari toccanidsapa huidsaja jinede attipa: “¿Nejecoma onanijine? A, jehe, ajima onana. Occa ejedeni ohua obonoccoriccana dosse onanina. Najaridsana cappinamanahitohui” najari. ");
INSERT INTO cul_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Nadsapa dosse inanijari, toccaniraha huidsajahuaji bacco nanidsa huidsaja cacahuadedenipa pohua qqui toquinadsapa pohuadenira huati tocanirejari: “Ajaripa huidsaja jinede bedi. Nidsaranibote imehi dsoqquedsa huidsajapi pohuadsa tojanitohui. Jari, inanadsoqquena, huidsajapi icca tojanijine” quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nama quinadsapa huidsaja jinede bedi dama quinadsa huidsaja inidihuaji joca quinadsa inanadsoqque-manajari −najari Jeso. Nadsapa pohuadsa queriqquimanajaridenidsa huati tajari: —Jari, tibodideni huatoji. Huidsaja jinede pohuadenidsa ¿nejecoma napadsaja? ");
INSERT INTO cul_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pohuapa ima mittadsapa pocca huidsajahuaji toccanipomahitohui. Manaco pocca huidsaja cacahuadedeni inajicaridsahitohui. Pocca huidsajapi madija ohuahadenidsana da inanitohui −najari Jeso. Naraha pohuadsa queriqquimanajaridenia najaro ima mittamanadsapa: —¡Jaho, najaro ima iadsa toja-jerana! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Nadsapa Jeso pohuadeni icattabaqqui nadsa huati tajari: —Tettidenipi: “Najaro ima iadsa toja-jerana” tiquinaraha pajissa tojanitohui. Najaro imassa najaro Dio Atti dsodo nanidsa dsodo napojaro. Imapi ajima najaro: “Odsa sibadsa icanahatomananijinepi nanahatodedenipa siba ojariepi ettajomanani nade. Naraha dsotodepi najaro sibana odsa daco cajiranijine tojajaro” nani Dio Atti dsodo nanidsa dsodo napojaro. ");
INSERT INTO cul_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nadsama najaro siba dacorehe cajijarodsa madija tohuedimamanadsapa poccadeni ima tossamodsapi assiredeni tajoriridsamanajarissa quinahitohui. Najaro siba madijadsa ssonaridsapi mere tocaniredsapa jamiromanahissa tahitohui −najari Jeso, pohua tahimari huati tadsa. (Aja pohua atti nama najaripa madija pohuadsa pajissa quina-jaradsapa paja jicarihi nahitohui, najari.) ");
INSERT INTO cul_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nadsapa dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinadsa Jesocca marinaja mittamanadsapa bodideni nahatoqquiri najari: —Jesopa icca ima huati huati tajari, iapi pohua ettajojarijine −quinajari. Nadsapa Jesodsa huadimanadsa: —¡Jari, jidapana Jeso todsepe inanana! −quinaraha madija noppinedeni cappinamanadsa dama quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nadsapa dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinadsa Jeso inoccodsamanajari. Attidenipa: —Jesopa romanodeni jiperaqquiri nahicca huati tadsapa romanodenicca dosseniji cacahuadedsa huati inanijine, nahi pohua dsepedsa tojahijine −quinajari. Nama quinadsapa poccadeni madija mota Jesodsa huati toquinahijine dosse inabaqquimanajari. Pohuadenipa pina pajissa Jeso pohua attitohuissa quinaraha pohuadeni bodidsa maidsehe najoramanajari. Nadsapa Jesodsa tohuajiressimanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pohuadenipa Jesodsa ajama quinajari: —Nija, Mamaride, ticca marinajapi toccanissa tajaro nahatoqquiri inani. Ticca ima dsori torani naridsajaro. Madija attideni noppine ticappina-jeradsapi ticca ima onihi toja-jerajaro. Madija deni tojajari, madija dsepe sse tajari, madija ajamani tojajari tedsejepa tiadsa najarissa caniqquimerajari. Pajissara Diocca marinajadsa madija madimanahissa tahijine mari mari titicanabaqqui najari −quinajari Jesodsa. ");
INSERT INTO cul_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","—Nadsama iapi romanodenicca tamine deni tojahicca pocca dossenijidsa icca dsiniro mota pohuadsa da inanijine ¿bica taqui? ¿Bica tejerarane? Moisesicca marinajadsa ¿oppina taqui? ¿Oppinera tarane? ¿Tetti nejecoma tani? −quinajari maidsehedsa. ");
INSERT INTO cul_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pohuadsa ima inassonarimananijine huati toquinaraha Jeso poccadeni maidsehe nahato tajari. Nadsapa pohuadenidsa huati tajari: ");
INSERT INTO cul_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Jari, dsiniro denario ohuadsa nohue ticanamanaji −najari. Nohue icanamanadsapa huati tapomajari: —Jari, ajijaro ccararadsapi ¿nejecojari corimena anijaro? ¿Nejecojari oni dsodo najaro? −najari Jeso. Naraha pohuadeni attipa: —Romanodenicca taminedija −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Naraha Jeso attipa: —Romanodenicca tamine pocca dsiniropi pohuadsa da tinanimanaji. Naraha Diocca tiquejenadsapi Pohua jipa tahiccara Pohuadsa da tiquinaji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naraha taminedeni, mamaridedeni quinajaripa Jeso atti cobara inanamanadsa madija queriqquimanajari huapima mittamanahijine tohuini quinaraha pajiramana-jarajari. Jabojomanadsa attidenipa: —A, icca ima ecomeranijine nahato tajaria −quinadsa todidimana najari. ");
INSERT INTO cul_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nadsapa Isaraeri potemahi jodiodeni mota marinaja onini sadoseodsa jehe quinajarideni Jeso madihihuaji jahijonajari. Poccadeni marinajapi: —Idsoqquedsapi inahatoninijine nohuerani −quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Najaro imadsa Jeso atti ijine tossamodsa cobara tana −quinadsa Jesodsa najaro ima huati toquinajari: —Mamaride, Moisesicca marinajadsapi ajima nani: “Maqquidejepa amoneje cajiraha ejedeni jiraha dsoqquedsapa pocca amonejepi pohua imecotena icajina, nahi ejedeni cajidsapa pocca ato dsoqquejaricca ejedenissa nahijine” nade Dio Atti Moisesijine dsodo nanidsa −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","—Nadsama tiadsa ima ajima najaro huati inana: Aja pohuadeni imecote pohuadenira 7 quinaha madimanajari. Tahideccaha amoneje cajipojari, naraha bedi jiraha dsoqquejari. ");
INSERT INTO cul_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Dsotodecca naco pohua ohuaha bedimeni icajiraha ejedeni jiraha dsoqquejari. ");
INSERT INTO cul_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dsotodecca naco najaro amoneje icajiraha najari naco ejedeni jiraha dsoqquejari. Najarossa dsanapojaro cajide 7 quinaraha ejedeni jiraha jicajari. ");
INSERT INTO cul_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Najarideni jicadsapa poni naqui dsoqquejaro. ");
INSERT INTO cul_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nadsapi dsama jicadsa madija nahatonimanadsapa pohua imecote 7 quinajaripa najaro amoneje icajiqquimanaporaha ¿nejecojarina ponicca maqqui tojapadsaja? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Naraha Jeso attipa: —Jidapana aja namidsa madimanajaridenipa caji caji cacana nadsa madimanaccajari. ");
INSERT INTO cul_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Naraha nidsa dsotode madijapa memehuaji Dio madihihuaji madimanadsapa nama quinapoma-jarahitohui. Caji caji canapoma-jarahitohui. Aja Diodsa iboraqquiri najaridenipa Dio inapajirabaqquihissa taja nadsa pohuadeni inahatonibaqquihitohui. ");
INSERT INTO cul_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nadsapa pohuadenipa dsoqquemanapoma-jarahitohui. Pina Diocca dodosse tabaqqui memehuajiccassa quinahitohui. Diocca nahatonihe cajimanadsapa Diocca ejedeni toquejenajari. ");
INSERT INTO cul_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Nadsama Diojine madija nahatonimanahicca imapi Moisesi dsodo inajaro. Aji ahua diji tani tahimarinidsa Moisesipa ia Medsede Dio Atti dsodo inajaro: “Ohuapi Dio, ticca idideni Abarahao, pohua bedi Isahaca, pohua bedi Jacobo quinajaridenicca Dio ojani” nahi nade, Moisesijine dsodo nanidsa. ");
INSERT INTO cul_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aja Dio Atti nama nadsapa Abarahaodeni nahatonimanadsa madimana-dsanapohuicca ima ahuato tajaro. Diopa paja dsoqquemanarihi najaridenicca Dio jarahi. Diopa camittaqquiri najaridenicca Dio. Pohuapa jidapana naco poccadeni Dio. Pohuadsa huapima madimana-dsanapojari −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jodiodenicca marinaja maridedeni motana Jesodsa huati toquinajari: —Jehe Mamaride, imapi najarona paji −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Nadsapa aja huati toquinapojaripa cappinamanadsapa apaja quinajari. ");
INSERT INTO cul_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesopa madija bodideni huatoma-manahijine pohuadenidsa huati tajari: —¿Nejecotohui madija attidenipa: “Cristo-Mesiapa Dabi Potemahi” quiquinanajari? ");
INSERT INTO cul_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Naraha tamine Dabipa maittaccadsama madidsa pocca jijiridsa pohua tedsejemacca ima dsodo inapojaro. Dabicca dsodonijipi ajima najaro: “Ia Medsede Diopa ohua Medsede Mesiadsa huati tajari: ‘Ohuinori nahatonihuaji tittariji. Ohua tedsejepi tohuatti dacorajaro ticajiji’ najari. ");
INSERT INTO cul_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‘Nidsaranibote tia huadidedenipa ajamani onanabaqquihitohui. Poccadeni dacorehepi onajicanitohui’ napohui nade Dio.” ");
INSERT INTO cul_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Naraha madija attidenipa: “Cristo-Mesiapa tamine Dabi Potemahi” quiquinanadsapa ¿nejecotohui Dabipa pohua potemahidsaraha: “Ohua Medsede” napojaritta? −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Madija huapima taharibobo canadsa Jesopa pocca dodosse tabaqquidsa huati huati tajari: ");
INSERT INTO cul_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—¡Paji, tiadenipi! Pina jodiodenicca marinaja maridedenicca madiessa tiquinejeraji. Pohuadenipa etero dequerajarodsa huedsaridsamanadsa attidenipa: “Iapi pina taminessa inani” quiquinanajari. Aji dadahuajicca jahuidsa jahiridsadsa naco madija pohuadenidsa: “¿Nija, bica tinani? Tiapi deni tijani” quinahijine tohuini quiquinanajari. Dio Atti mamarihuaji jassi tarihijinepa deni toquejenajaridenicca huihuittaridsa jassi tarihijine tohuini quiquinanajari. Jipaqquie imenidsa naqui deni toquejenajaridenicca huihuittaridsa jassi tarihijine tohuini quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Nadsama tabira tocajamanajarodeni ponideni madimananijineccaraha icamaidsabaqqui-manadsa pohuadenidsa totoja nadsapi ponidenicca odsa naqui pohuadenidsa totocajaridsa najaro. Naraha poccadeni tabaccorehe ahuatora tanijinepi Diodsa huati huati toquinadsapa poccadeni huatinaja dequerajaro, aja madija pohuadenidsa: “A, Diodsa disseraqquiri nahi” quinahijine. Pohuadenipa Dio Attima mamaidsamana nadsapa nidsa Diocca najidsohue denima oppina tanicca pohuadenidsa ssonarinitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesopa Diodsa dada toqquimahuaji dsepedeni sseqquiri najarideni dsiniro dade toquejenajari qqui inabaqquijari. Poccadeni dsiniro da naqquinajacca bahodsa hua idsamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nanihuaji naqui amoneje tabira tocajanipi poni madinijinecca dsiniro bedeniraha ponicca danijijine capamehe cororo icadsajaro. ");
INSERT INTO cul_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nadsapa Jeso pohuadsa toqueriqquijaridenidsa huati tajari: —Pajissara tiadenidsa huati onana: Ajijaro amoneje tabira tocajani ponipi cappiraraha ponicca daniji dsiniro bedeniraha deni tojani. Pina Diodsa denima da inajarossa najaro. Naraha aja huapima dsepedeni sseqquiri najaridenicca danijipi pina ajimani Diodsa da quinajarossa najaro. ");
INSERT INTO cul_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pohuadenipa poccadeni dsiniro mota arobeni da quinajaro. Naraha ponipi cappirajaro, tohuati nahana tajaro. Poni madinijineccaraha da inehe jicajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jesocca dodosse tabaqquipa Diodsa dada toqquimahuajicca odsa qquide bica tocanadsa imahaha canajari: —A, siba noponi bicabotedsa nahatoridsajaro. Madijacca daniji oro dsibehi tajarodsa nehebedsoridsajaropi bicaqquiri nani −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Naraha Jeso attipa: —Aji odsa imeni sibadsa nahatoridsani jidapana qqui tiquinaraha nidsa dsotodepi taboridsehe jicanissa tanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nadsapa Jesocca dodosse tabaqqui pohuadsa huati toquinajari: —Ia Maride, jidacca huati tinajaropi ¿nejecoma nadsa tojapadseje? Najaro ima tohuajiradsa nahatoqquiri inanijinepi ¿nejecora qqui inapopadseje? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nadsapa Jesoa: —Paji, madija tiadeni tocamaidsabaqqui-manarana. Nidsa madija huapi taha pohuama ohua onidsa maidsamanadsapa: “Ohuapi Cristo-Mesia ojani” quiquinanahitohui. “Jidapana dsama jicanicca bacco tani” quiquinanahitohui. Naraha najarideni attidsa jehe tiquinejeraji. ");
INSERT INTO cul_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nadsama madija dsama onihicca, dsama onihicca tedseje jadsire imeni inahatomanani tahimarini timittamanadsa naqui ticappinamana tejerana. Ticcadeni dsamahuaji, dsama onihihuaji naco huadiqquiri najarideni taminedenicca cacahuehe najidsoridsamanahi timittamanadsa naqui ticappinamana tejerana. Najaro ima oppina taniccapi tahide tojaporaha dsama jicanijinepi nohueraccanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesopa denima huati huati tajari: —Nadsama madija dsama onihicca, dsama onihicca tedseje jadsire inanamana-ridsanitohui. Tamine ohuahacca madija, tamine ohuahacca madija tedseje cahadire-ridserahitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nadsama namidsadsa imeni naqui caji tanitohui, pemi naqui cajiridsanitohui. Dsamacoma naqui dsama onihidsa, dsama onihidsa cajiridsanitohui. Nadsapi memehuaji naqui oppina tanicca ahuatodsa tijabojomananitohui. Najaro qqui tiquinadsapi dsama jicanicca bacco tani nahatoqquiri tiquinanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Naraha aji ima huapima huati huati onajarocca toja-jeraccadsama tiadenidsa ima tojaridsaponitohui. Madija huadiqquiri najarideni tiadeni tadamamanadsapa tiadeni tonajidsobaqqui-manahitohui. Jodiodenicca Dio Atti mamarihuaji tiadeni tohuaqquedsimabaqqui-manahitohui, toponi cocorodsa naqui tiadeni coro todsima-baqquimanahitohui. Otahimari tiadenidsa tojajaro acconi huadimanadsa dsama onihicca dsama onihicca madija tamine deni toquejenajarihuaji tiadeni tohuaqquedsimabaqqui-manahitohui. Dsama cacahuadedenihuaji naco tiadeni tohuaqquedsimabaqqui-manahitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nani pohuadeni dsepedsa tiquejenadsa taminedenidsa ticcadeni ima tecomeramanadsapi otahimari naqui mittamanahijine. ");
INSERT INTO cul_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","—Nadsama ticcadeni ima tecomeramanadsapi tiadenidsa ima ssonari-jeranijine tibodideni titinajoramanapo nejerana. ");
INSERT INTO cul_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tettideni tecomeramananijinepi tiadeni acco ocamabaqquinitohui, tiadeni huadidedeni tettideni inassamomana-jeranijine, ima huatide nahatoqquiri tiquinanijine. Nadsapa pohuadeni attina tettidenidsa ajimani tojanitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Naraha tiadeni huadidedeni naco ticca abi itide, ticca ami nitide, timecotedeni itide, ticca madija itide, titesse itide pohuadenipa otahimari tiadsa tojajaro acconi huadimanadsa todsepe tiquejenanijine tiadeni eccoramana-ridsanitohui. Tiadeni mota naqui tiadeni inanadsoqque-maneje camaridsanitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Occa madija tiquejenajarojinepi madija huapimapa tiadenidsa jiperaqquiri nahitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Naraha Dio tiadeni tohuacahua-baqquihitohui. Pohua jipa tadsa naco titatideni conani ojarie amossineje cama-jeranitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nadsama tiadenidsa ohuattipi: ¡Dacoco tijiraji! Najaro huadie tinahanamana-dsanapodsapi tiadenina ticassiejeranitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesopa dsama jicanicca ima denima mari icanabaqquijari: —Nidsa dsotode ticcadeni odsa panani Jerosare huapihuaji jajadsirededeni cottajahuajanimanaha jica nahi qqui tiquinadsapi: “Jerosare jicanicca huada bacco tani” tiquinana. ");
INSERT INTO cul_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nadsama aji dsama Jodeahuaji timadiridsa-manajaropi ssonohuaji tidomo toqquemorana. Jerosaredsa timadimanajaro naqui tidomo toccana. Aji huidsajadsa timadimanajaropi odsa pananihuaji jai tijani tejerana, tijicarana. ");
INSERT INTO cul_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","—Najaro ima oppinabote tojajaropi Jerosarecca madija iboqquiri nadsapa Diocca najidsohue pohuadenidsa ssonarinitohui. Pina Dio Atti dsodo napojarossa nehe tojanitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Najaro ima oppina tajaro bacco nadsapi amoneje jiamanajarodeni, bacconideni ijimanajarodeni naqui joppa toquinanijine tohuati nahanaqquiri nanitohui. Jehe, ajijaro dsamacca madija Diocca najidsohuejine ocasserani ahuamanahitohui. Diocca huadie imeni ajajari madijadenidsa ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jadsirejinecca massitodsa motadenipa jicaridsahitohui. Motadeni naco jajadsirededeni itadamamanaridsadsa pohuadeni dsepedsa toquejenadsapa dsama onihihuaji dsama onihihuaji iaccanibaqqui-ridsamanahitohui. Nadsapa jodio quejena-jarajarideni deni toquejenadsapa Jerosare inatabaccoramananitohui. Pohuadenijine Jerosarepi pina ttai ttai tojajarossa nanitohui. Naraha dsotodepi poccadeni huajano Jerosarehuaji madimanahijine pajiranissa tadsapi najidsohue jicanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesopa ima denima huati huati tajari: —Ima nahatoqquiri tiquinaponijinepi maji, abadsico, abadsico bedi najaridenipa tojidsaridsahitohui. Aja memehuajicca tojidsaridsadsapa namihuaji madimanajarideni jabojo quinahitohui. Coridsa imenicca passo poni ssodadani tojidsadsapi mohuini oppina tajarojine madija huapima jabojo quinahitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jidapapa aja maji, abadsico, abadsico bedi naco dacoraqquiri naraha najaro ima tojadsapi meme dsadsa nadsa memecca huapima huenene huenene canahitohui. Madijapa: “¡Iadsa dsama oppina tani! ¿Nejecoma napadseje?” quinadsa cappinamanadsapa tossamoridsamanaja huahuatia cossamanerinaja camahitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nadsana ohuapi Madija Bedi ojajaroa meme essenima oquejemehe occaronapomani madija huapima qqui toquinahitohui. Occa dacorehe, occa deni tojehe ahuato tanitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Madija ohuahapa cappinaridsa-manaraha tiadeni occa madijapi aji huati onajaro qqui tiquinadsapi pina tetidsemanana. Memehuaji ticattamacossassa canana. Ohuapi tiadeni odinibaqquinijine titohuideni occaronanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nadsapa ajijaro namidsa imadinicca imadsa pohuadeni mari icanabaqquijari: —Jari, ahua iquiera tahimaridsa ticahatteraji. Ahua iquiera, ahua huapima naco eppe moro nimanihi qqui tiquinadsapi: “Jehe, dsadsajade tojemanini” titiquina najaro. ");
INSERT INTO cul_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pina najaro imassa najaro aji dsama jicani tahimarini huati huati onajaro qqui tiquinadsapi: “Jehe, Diocca cacahuehe tohuajirajonani” tiquinana, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","—Pajissara tiadenidsa huati onajaro: Aji dsama jicani tahimarini huati huati onajarocca madija dsoqquemana-jaraccadsama najaro ima huapima tojanissa tani qqui toquinaccahitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Meme, nami naqui jicaridsanissa tanitohui. Naraha ohuattipi jiquejeranitohui. Aji huati huati onajaropi najarossa nanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Paji tiadenipi tiadeni tecahuamananissa taji, tibodideni ccaracossa-jeranijine. Aji bica tejeraraha tohuini tiquinajaroccapi tineboridsamanaji. Aji dse tiquinadsa comani teteridsamana najaro naqui tineboridsamanaji. Aji timadimananicca tohuira tibodideni huahuato najaro naqui tineboridsamanaji. Najaro tinebomana-jeradsa dsama jicanicca huada amadsati bacco tadsapi huajo ticanirenitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Najaro huada bacco tadsapi pina tajapa abadsa cassonaridsa tohuittamanajarissa tiquinarana. Dsama jicanicca oppinehepi ajijaro dsama huapimacca madijadsa ssonarinitohui. ");
INSERT INTO cul_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Najaro noppineni tinajoramanehe timadimanaji, onajaro. Diodsa huati huati titidsanapomana naji, aji ima oppina tehe tojadsa dsori ticanirenijine. Ohuapi Madija Bedi ojajaroa nidsa occaronapomadsapi ima jirehe obaccohuaji tidomodeni huanijine naqui Diodsa huati huati titidsanapomana naji, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesopa huada huajijiradsa Diodsa dada toqquimahuaji maride totoja najari. Dsomedsapa Ssono Oribo quiquinanahihuaji totoccani najari. Nahidsa huahuada najari. ");
INSERT INTO cul_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Naraha madija huapimapa dsidsidsamassa Diodsa dada toqquimahuaji bacco bacco nanajonamana najari, Jesocca marinaja mittamanahijine. ");
INSERT INTO cul_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jodiodenicca ejete imeni tohuajirajonajaro, oninipi Pan ssaja tajarahicca. Najaro ejete onini onihipi Pascoa. (Ettidsapi: Dio tossoniqquimajari, inajaro.) Najaro ejete toja-jeraccadsapi ajijaro ima tojajaro. ");
INSERT INTO cul_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinajaridenipa Jesodsa jiperaqquiri nadsa attidenia: —¿Jeso nejecoma inanadsa dsoqquehijine? −quinajari. Naraha pocca madija noppine cappinamanajari. —Jeso dama inahi qqui toquinadsapa mohua mohua canarana −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nadsapa Joda. Pohuapa Jesocca dodosse tabaqqui 12 quinajari ojaria. Pohua oni ohuahapa Iscariote. Pohua bodidsa imasiri mamaride Satana toqquedsimadsapa pohuana Jeso eccorahijine bodi najorajari. ");
INSERT INTO cul_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nadsapa dada toqquimade taminedeni, nahicca odsa cacahuadedeni quinajaridenidsa Joda huatide toccajari. —Jeso tidsepedenidsa onanahijine, onajaro −nadsa pohuadeni tedseje Jeso dama quinahijine imahaha canajari. ");
INSERT INTO cul_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nadsapa huatidsemanadsa: —Jehe, nema tadsapi tiadsa dsiniro da inanitohui −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nadsapa Joda jehe nadsa bodi najorajari. Toccanidsapa Jeso pohuadenidsa eccorahijine inoccodsaridsajari. Pohua bodipa: —Madija nohue quiradsa Jeso dama tiquinajo, onanijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pan ssaja tajarahicca ejete bacco tapojaropi huada 7 nehe jicanijine. Najaro ejetecca huada tahideccadsa jodiodeni pohuadeni motta edede bedi Diodsa da da quiquinanajari. Edede bedi inanadsoqque-manadsa ibanamanadsapa jipamanajari. Najaro ejete oninipi Pascoa quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nadsa Jesopa Pedro Huano tedseje dosse inabaqquijari: —Jidapana Pascoacca jipaqquie tinajoramanapoji, dsome ijipaqquinijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Naraha pohuadeni attipa: —¿Nejecohuaji inajoranijine? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","11","Naraha Jeso pohuadenidsa huati tajari: —Jerosarehuaji ticadapoji. Nahidsa madija jojoridsa passo dsojo tanihi qqui tiquinadsapa najari natti ticadamissadsa pocca odsa bacco tiquinana. Nadsapi nahicca odsa jinededsa huati tiquinana: “Ia Maride attipa: ‘¿Nejecohuajicca coba canahuajaninidsa Pascoacca jipaqquiedsa ojipanijine occa dodosse tabaqqui tedseje?’ napaja” tiquinana. ");
INSERT INTO cul_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nadsapa pocca odsa tetepicca coba canahuajanini imeni tiadenidsa nohue inanitohui. Nanidsapi huahuanari, huihuittari najoraponi. Nanidsana jijipa tinajoramanaponijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Nadsapa tohuedadsapa pina Jeso pohua huati tajarissa najaro odsa najorani qqui toquinajari. Nanidsa Pascoacca jipaqquie dsome jipaqquimanahijine najoramanajari. ");
INSERT INTO cul_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jipamanahijinecca maji bacco tadsapa Jeso pocca dodosse tabaqqui tedseje jipamanahijine huahuanaridsa jassi nahuajanijari. ");
INSERT INTO cul_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nadsapa Jeso pohuadenidsa huati tajari: —Obodipi: Ocasserani ohua-jeraccadsama occa dodosse tabaqqui tedseje Pascoacca jipaqquiedsa ijipaqqui naccaraho, ohodsanapo najaro. ");
INSERT INTO cul_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nadsama ajijaro ejetecca jipaqquiepi ojipapomanijine huaji taccani. Nidsa Diocca cacahuehe tojadsana nanidsana ijipaqquipomanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nadsapa Jeso dsedse equidi nadsa Diodsa huati tajari: —Jehe Abi Dio, ticca daniji iadsa bica tahi −najari. Nadsapa pohuadenidsa huati tajari: —Aja, tiadeni huapima dse tiquinajo. ");
INSERT INTO cul_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ajijaropi tiadenidsa huati onajaro: Diocca cacahuehe tojanijinecca huada bacco tejeraccadsapi uva ppejene dse onapoma-jaraccahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nahi dsotodepa pan pohua dsepedsa idi nadsa Diodsa huati tapomajari: —Jehe Abi Dio, ticca daniji iadsa bica tahi −najari. Nadsapa icanarobedsa dside jai da, dside jai da inaridsajari. Nadsapa Jeso huati tajari: —Ajijaropi ohuemecca ima. Ticassiejeranijinepi ohua ohuana ohua ohuaccoranijine. Nidsa ohua nohue ojiradsa naqui ohuadsa tetideni ajimamana nejeranijine ajima titinanamana nana, onajaro. Aja pan ocanabobiridsadsa tiadenidsa da onaridsadsa tijipamanajaropi titiqueriqquimana nadsa nema titidsanapomana nanijine, onajaro −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jipaqquimanahi natti naco dsedse equidi nadsa huati tapomajari: —Ajajari dsedsecca imapi Dio madija tedseje jehe canirehijinecca ima dsati tojanijine. Nidsa ohua odsoqquedsa ohuemene toccadsapi najaro jehe canireniji dsati pajissa tojanitohui. Aji ohuemene toccajaropi tiadenidsa ima bicani tojanijine. Najaropi ticcadeni imasiri manaconi ohuadsa tojadsapi ticassiejeranijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Nadsa aji ijipaqquinidsa ohua ccaccorade naco ajijaro huahuanaridsa ohuadsama jipade huittarihi. ");
INSERT INTO cul_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Naraha ohuapi Madija Bedi ojajaroa nidsa odsoqquenitohui. Pina Diojine maittaccadsama otedsejemacca ima najorapojarossa onanitohui. Naraha ohua ccaccoradedsa oppina tehe tojanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nadsapa pohuadenira huati tocanirere canadsa: —¿Nejecojarina Jeso dsoqquehijine madija dsepedenidsa inanahijine? −naridsamanajari Jeso huatimadedeni. ");
INSERT INTO cul_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesocca dodosse tabaqqui pohuadenira ahuaji huati ahuaji huati quinadsapa: —¿Nejecojarina iadsa deni tojajari? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Naraha Jeso pohuadenidsa huati tajari: —Madija ohuaha jodio quejena-jarajaridenicca tamine huapimapa dossede dacoraqquiri nadsa poccadeni madija dosse dosse quiquinanajari. Dodossede ohuahadeni naco deni toquejenadsapa attideni dacoradsa poccadeni madija dosse dosse nanaridsamana najari. Pohuadenidsa poccadeni madija attidenipa: “Ia acco camade tiquejenani. Iadsa bica taniccara tinanamanajaro” quinaraha maidsa maidsa quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Naraha aji ohuadsa tiquejenajaropi pina najari taminedenissa tiquinejeraji. Aji tiadeni deni tijeje camajaropi pina dsabisso dossehedsa ibora tajarissa tiquinadsana bica tani. Madija dossede tijadsa naqui: “Ohuana deni ojani” tejeraji. Ticca madija bijideni acco ticamabaqquiridsahina bica tajaro. ");
INSERT INTO cul_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ajaro namicca madijapa “Ojipana” nadsapa pocca huihuittaridsa huittaridsa pocca medsena jijipa dsojo dsojo najari, pohua medsedecca huahuanaridsa hua inarihijine. Naraha tiadenidsa huati onajaro: ¿Nejecojarina deni tojajari? ¿Madija huihuittaridsa huittarijaripa deni tojajarico? ¿Pocca medsena deni tojajarirana? Aja huittarijarina deni tojajari. Pocca medsepa ajamani tojajari. Naraha ohuapi tiadeni Medsede ojaraha pina ticcadeni medse ojajarossa najaro, tibijideni acco ocamabaqquijaro. Tiadeni naqui nema tiquinana, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Aji ohuapi ocasserani ohuadsa, madija ohuadsa ima oppina tanicca inanamanadsa naqui tiadenipi ohuadsa paji timadimanarini dsanapojaro. Ohuatimade disseraqquiri tiquinajaro. ");
INSERT INTO cul_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nema najaroa aji ohua tiadenidsa onananijinepi pina aji occa Abi ohuadsa inanajarossa najaro. Ohuadsama tiadeni naqui madija dossede tiquejenanitohui, onajaropaji. Pina occa Abi ohuadsa huati tapojarissa najaro, ohua cadossejarissa najaro: “Nidsa madija dsama huapimacca dossede tijanitohui” napode. ");
INSERT INTO cul_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nidsa occa cacahuehe bacco tadsa huapimacca tamine ojadsa naqui tiadenipi occa huahuanari aji ohua ojipanihuaji ohuadsama tijipamana-dsanaponitohui. Ticcadeni cacahuehe icca madija jodiodeni aja icca idi Isaraeri pohua bedi 12 quinajarideni potemahi tecahuabaqqui-manaridsadsapa poccadeni tamine tiquejenanitohui. Nadsama tiadenipi pohuadeni dossedecca huihuittari 12 quinajarodsa ima cattemade jassi tinariridsanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesopa Ssino-Pedrodsa huati tajari: —Ssino, tibodi huatoji. Satanapa titohuideni tonacomabaqquihi. Pohuapa titohuideni Diodsa huati tajari, tiadeni nattome tabaqquihijine. Pina aroso jidsadsa trigo etero toccahijine qquero huira, qquero huira quinajarissa najari ohua tinebomananijine tiadenidsa ocasserehe inananitohui. ");
INSERT INTO cul_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Naraha Ssino, titohui Diodsa huati huati onajaro, ohua tinebo-jeranijine. Ohuadsa epeje tanitohuiraha, otohuira tapomadsapi timecotedeni aja ohuadsa jehe quinajaridenicca jeheniji todacoranijine pohuadeni acco ticamabaqquijo, onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Naraha Ssino attia: —Ohua Medsede, ohuapi nema onejeranitohui. Toponi cocorodsa tia coro idsimamanadsa naqui ohua naqui onajorani, tiadsama ohuedsanijine. Tiadsama odsoqquenijine naqui onajorani −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Naraha manaco Jeso attia: —Pedro, tiadsa huati onana: Nidsa ajijaro dsome ssiajaricossanihuaji tacara huahua najaraccadsa tetti tinamaidsanitohui. Ohuadsa: “Onocco jidsa tani” tanitohui. Dsotode naqui: “Onocco jidsa tani” tapomanitohui. Dsotode naqui nema tapomanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nadsapa Jeso pocca dodosse tabaqquidsa huati tajari: —Madija maride tiquejenaridsanijine tiadeni dosse onabaqquipodsa jai tijaridsade. Ticcadeni saco, ticcadeni dsiniro, ticcadeni sapato najari jirehe jai tijaridsaji onadsapi ¿nejecora ticappiramanatte? −najari Jeso. Naraha pohuadeni cacomeramanajari: —Nohuerade. Icappira nehe jaijaridsa-jerade −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nadsapa Jeso pohuadenidsa huati tapomajari: —Naraha jidapapi occa dosseniji tahidessa nejerani. Jidapapi saco, dsiniro ticajimanadsapi tiaccamanaji. Nadsama jadsirecca massito ticappiramanadsa naqui ticcadeni ssirinijinecca huehuedsa da tiquinadsa mitta tiquinaji. ");
INSERT INTO cul_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nadsapi otedsejemacca ima tiadenidsa huati onana: Dio Atti dsodo naponiccapi pajissa ohuadsa tojanitohui. Pohua Atti cacomerabote Isahia dsodo inaponipi ajima najaro: “Nidsa madija attidenipa: ‘Ajajaripa tabaccoraqquiri najaridenidsama quejemajari’ quinahitohui” napohui nade Isahia. Najarossa najaropi ohuadsa madija attideni nama quinahitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Naraha pohuadeni attipa: —Ia Maride, ajidsapi jadsirecca massito capamehe icajini −quinanaja Jesopa: —Jehe, najarodsapi tipajiramanani −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nadsapa Jeso huati taha jicadsapa odsadsa toqquenadsa ssono Oribohuaji toqquemorajari. Aja pohua huajijiradsa totocca nahihuaji toccajari. Pocca dodosse tabaqqui naco pohuadsa jai tojemorajari. ");
INSERT INTO cul_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Aja pohuadeni quequeriqquimana nahihuajicca ahua oribo ppa nahi dopehuaji bacco toquinadsapa pohuadenidsa huati tajari: —Jari, Diodsa huati huati tiquinaji, aji ticappinamanadsa ima tinanamana-jeranijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesopa pocca dodosse tabaqqui jassi tahidsa toqqueqquimajari, cahuajiqquima nadsa pohua pitodsa huittadsa Diodsa huati huati tajari. ");
INSERT INTO cul_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ajama najari: —Abi, jipa tinadsapi otedsejemacca ima oppina tanicca ohuadsa toja-jerana, onaraha. Madija huapimacca ima manaconi najidsohue ohuadsa tojadsapi ocasserani ohuanitohui. Pina dsedse bidabote dse onanijinessa najaro. Najaro onahananijine jipera onaraha ohua jipa onanicca tohui onejerajaro. Tia jipa tinaniccana paji. Najarodsana ibora onajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nanaja nahi Jeso pohua Diodsa huati huati tahihuaji Diocca dodosse memehuajicca ahuatojari. Najaripa Jeso acco icamadsa inadacorajari. ");
INSERT INTO cul_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Naraha Jeso pohua bodi ocassera-ra canajari. Diodsa huatide todacorahi nadsapa taniccojari. Pohua taniccone toccadsa namidsa catojadsapi pina ama motarehe ssaboro ssaboro najarossa najaro. ");
INSERT INTO cul_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Diodsa huati taha jicadsapa pocca dodosse tabaqquihuaji ccanijari. Bacco nanidsapa cahadijahira qqui tajari. Bodideni oji quinajarijine tocamijireradsapa cahadijajari. ");
INSERT INTO cul_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Naraha pohuadenidsa huati tajari: —¿Nejecotohui ticahadijajaro? Nocco tiquejenadsa Diodsa huati huati tiquinaji. Ima oppina tehe tojadsapi tijaparimanadsa ima tinanamana-jeranijine, onapa −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesopa huati huati naccaraha madija huapi taha bacco najonamanajari. Jodana tahidejonajari. Pohuapa Jeso pocca dodosse tabaqqui 12 quinajari ojariaraha pohuana Jesohuaji tohuajiressi, pano mose inajari. ");
INSERT INTO cul_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Naraha Jeso attipa: —Joda, ohuapi Madija Bedi ojajaroa ¿opano mose tajaropi aja ohuadsa huadiqquiri najaridenidsa ohua teccorajaroqui? −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Naraha aja Jeso huatimadedeni attidenia: —Ia Medsede ¿massitodsa itacaridsaco? −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nadsapa Jesocca madija ojariana dada toqquimadedenicca tamine deni tojajaricca medse huaribo nahatonihuajicca ca taneje tajo canajaro. ");
INSERT INTO cul_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Naraha Jeso attia: —¡Apajana, denima ca tejeraji! −najari. Nadsapa taminecca medse huaribo bara icanadsapa huaribo tocabiquemanijari. ");
INSERT INTO cul_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesotohui jahijonajaridenipa aja dada toqquimade taminedeni, Diodsa dada toqquimahuajicca cacahuadedeni, ime jocohuideni quinajari. Najaridenidsa Jeso huati tajari: —¿Nejecotohui tiadenipi jadsirecca massitoma, huahuaccama jai tijajonajaro? Nema tiquinadsapi pina bobotidetohui jai tijajonajarossa najaro. ");
INSERT INTO cul_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nadsa tiadenidsama huajijiradsa Diodsa dada toqquimahuaji ohoquejema naraha ohua dama tiquinehe nejerade. Naraha ohuadsa ima tinanamananijinepi dsidsinidsara jai tijajonajaro. Jidapapi tijinedeni dsidsini jinede deni tojajari −najari Jeso. Nadsapa Jeso dama quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nadsapa Jeso dama quinadsa dada toqquimadedenicca tamine deni tojajaricca odsahuaji iaccamanajari. Naraha Pedropa Jeso iaccamanahi nattideni huajima tohuanamissajari. ");
INSERT INTO cul_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Odsadsa bacco toquinadsapa boronidsa dsippo inadsamanadsa jiade jassi nahuajanijari. Pedro naco pohuadenidsama huittabacossajari. ");
INSERT INTO cul_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Naraha najaro odsacca medse dsohuato Pedro dsippodsa huittahi qqui tadsa icattoma nadsa aja jassi nahuajanijaridenidsa huati tajaro: —Ajajaripa Jesodsa ccaccaridsa nade −najaro. ");
INSERT INTO cul_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Naraha Pedropa pohua namaidsajari: —Dsohuato, ohuapi pohuadsa onocco jidsa tani −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nahi dsotode madija ohuaha naco Pedro qqui tadsapa: —Tia naqui Jesocca madija tijani −najari. Naraha Pedropa pohua namaidsapomajari: —Ohuapi najaricca madija ojajerani −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nahi dsotode maji ojaria tossoniqquimadsa madija ohuaha attipa: —¡Pajissade! Ajajaripa Jeso huatimadedija. Pohuapa dsama arobeni Carireahuajicca madija jidsera tahi −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Naraha manaco Pedro pohuadenidsa huati tajari: —¿Nejecoma najaro imara huati huati tiquinajaro? Ohuapi najaro ima ssamo onani −najari. Pedropa najaro ima huati huati nanaja tacara huahua najari. ");
INSERT INTO cul_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nanaja Jesopa cattahuajanihi nadsa Pedro icattoma najari. Nadsapa Pedro pohuadsa Jeso huati tapojaricca ima bodi huatomanijari: —Nidsa ajijaro dsome ssiajaricossanihuaji tacara huahua najaraccadsa tetti tinamaidsani 3 nanitohui −napohui nade. ");
INSERT INTO cul_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Najaro ima Pedro bodi huatomanidsapa toqquenajari. Pohua motta oji oji najari. ");
INSERT INTO cul_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jeso cacahuadedenipa huadiedsa jidsa jidsa quinajari. Jeso huaccade jo narihi najari. ");
INSERT INTO cul_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nocco ssoque quinadsa naco pohuadsa huati toquinajari: —Jari ¿nejecojari tia idajari? ¡Tecomerajo! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Attideni tabaccora tajarodsa itamassoqquimanajari. ");
INSERT INTO cul_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ssiajadsapi jodiodeni ime jocohuideni, dada toqquimade taminedeni, jodiodenicca marinaja maridedeni quinadsa queriqquimanajari. Nadsapa jodiodenicca ima cacattemadedeni deni toquejenajarideni quequeriqquimana nahihuaji Jeso iaccamanajari. Nahihuaji huapima jai tojedsimadsa pohuadsa huati toquinajari: ");
INSERT INTO cul_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Cristo-Mesia tijadsapi iadsa tia tecomeraji: “Ohuapi Cristo-Mesia ojani” taji −quinajari. Naraha Jesopa: —Tiadenidsa: “Ohuapi Cristo-Mesia ojani” onadsapi ¿ohuadsa pajissa tiquinapadseje? Pajissa tiquinejerani nahato onaponi. ");
INSERT INTO cul_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Manaco tecomeramananijine tiadenidsa huati onadsapi ¿tecomeramanapadseje? Tecomeramana-jeranitohui −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","—Ohuapi Madija Bedi ojajaroa nidsa dsotode Dio Dacorabote ohua deni tonanadsapa Pohua inori nahatonihuaji ohuittarinitohui. Nanihuaji ohuittaridsapi Abi Pohua tedseje dosse dosse onanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naraha pohuadeni attia: —Nema tadsapi ¿tiapi Dio Bedi tijaqui? −quinajari Jesodsa. Naraha Jeso pohua cacomerajari: —Jehe, tiadeni ohuadsa nema tiquinajaropaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nadsapa pohuadeni attia: —Jidapapi pocca ima huati toquinahijine madija ohuahatohui huahua inejerana. ¡Epeje! Pohua pohua cacomeradsa pohua atti oppina tanicca imittanissa tani −quinajari. Nadsapa najaro imadsa dsoqquehijine najoramanajari. ");
INSERT INTO cul_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nadsapa jodiodenicca taminedeni nahidsa queriqquimanajari huapimapa totehemamanadsa tamine Piratohuaji Jeso iaccamanajari. Tamine Piratopa romanodeni. Pohuapa jodiodenicca dsama cacahuade tojajari. ");
INSERT INTO cul_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tamine Piratohuaji bacco toquinadsa pohuadsa poccadeni maidsehe huati toquinajari: —Jesojinepi ima bica tejerani, pocca ima ajima nani −quinajari. —Jeso madija inequeriqquidsa mari icanabaqquidsapa romanodenicca cacahuehedsa tojiperamanajari. “Iara ia ecahuana” quinajari. Pocca marinaja naqui: “Romanodenicca taminedsa ticcadeni dsiniro mota naqui paca tiquinejeraji” nanaja nahi. Nadsama pohua atti onihi naqui: “Ohuapi Cristo-Mesia, ticcadeni tamine deni tojahicca ccajonahitohui quiquinanajari ojani” nahi naco imittani −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nadsapa Pirato Jesodsa huati tajari: —¿Tiapi jodiodenicca tamine tijaqui? −najari. —Jehe, tetti nema tajaropaji −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Naraha Piratopa dada toqquimade taminedenidsa, nahidsa madija queriqquimanajarideni huapimadsa huati tajari: —Ajajaripa icca dsamacca marinaja inajidsoje cama-jerani. Ima oppina tanicca inana-jerani. Tettidenidsa onajidsohuijine pajira-jerani −najari Pirato. ");
INSERT INTO cul_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Naraha pohuadenipa denima jadsirema johua johua quinajari: —Ajajari madija mari mari naridsadsapa pohuajine mohuaniji tojaridsani. Dsama Carireahuaji mari mari napojari. Nahi dsotode naco aji icca dsama Jodeahuaji mari mari naridsadsapa ajadsa bacco najonajari −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Madija attideni: —Dsama Carireahuaji mari mari napojari −quinahi mittadsapa Pirato attia: —¿Ajajaripa Carireaccaco? −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nadsapa jehe quinahi mittadsapa tamine Herodehuaji Jeso iaccamanahijine dosse inajari. Herodepa Carireahuajicca cacahuaderaha Jerosaredsa huada pamehe madiccajari. Nadsapa Herodehuaji Jeso iaccamanajari. ");
INSERT INTO cul_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tamine Herodehuaji Jeso iaqquedsimamanajari. Aja Herodepa tahide Jeso tahimari mimitta napodsapa: —Jeso qqui onaccaraho −nanaja najari. Nadsapa pohuahuaji Jeso iaqquedsimamanahi qqui tadsapa huatidsejari. —Jehe, jidapanana pohua canahatori canahi qqui onanitohuia −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nadsapa Herode Jesocca ima mittahijine pohuadsa huati huati dsanaporaha Jesopa pohua cacoma najari. ");
INSERT INTO cul_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Naraha nahihuaji naco dada toqquimade taminedeni, jodiodenicca marinaja maridedeni tedsejepa dissassera tadsa ima onihi, ima onihi huati toquinadsapa: —¡Jesopa tabaccora tahi! ¡Tinajidsojo, tinajidsojo! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nadsapa Herode pocca soldadodeni tedseje Jeso momohua inanamanajari. Jesodsa maidsamanadsapa etero bica taniccadsa inehedsamanajari. Pina taminessa inanamanadsa pohuadsa jidsa jidsa quinajari. Nadsapa Herodepa tamine Piratohuaji Jeso dosse inanipomajari. ");
INSERT INTO cul_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tahidepa Herode Pirato tedseje ahuaji jipera ahuaji jipera quinapojari. Naraha Jeso ahuaji dosse, ahuaji dosse quinadsapa najaro huadadsa cajonerajari. ");
INSERT INTO cul_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nadsapa tamine Piratopa dada toqquimade taminedeni, jodiodeni ime jocohuideni, madija ohuahadeni naco huahua inajonabaqquidsa queriqquijonajari. ");
INSERT INTO cul_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nadsapa pohuadenidsa huati tajari: —Aja Jeso ohuadsa teccajonamanapodsapa tettidenipi: “Pohuajine mohuaniji tojaridsani” tiquinaraha tiadeni tinoccodenidsa pohuadsa huati onapa. Pocca ima omittadsapi pina tettidenissa nejerani. Pohuadsapi ima nohuerani −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","—Tamine Herode naco pocca ima mittaraha pocca ima tabaccora tanicca nohueradsa ohuahuaji dosse inanipomajari. Aja Jesopa ima tabaccora tanicca inana-jeradsapi pohuapa dsoqquehijine bica tejerani. ");
INSERT INTO cul_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nama nadsapa pina ocadossebaqquidsa cossi inaqquimanaha jicadsapa dosse onanina, toccanihijine −najari tamine Pirato. ");
INSERT INTO cul_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Naraha madijapa Pirato: —Jeso toccanihijine −nahi mittamanadsa huapima johuahua johuahua canajari: —¡Najaripa dsoqquena! ¡Aja coro todsimapojari Barabana tijine qquenajo! −quinajari.  Aja huajano huajijiradsa ejete Pascoa tojadsapi Piratojine toponi cocorodsa madija huedsamanajari ojaria qqueqquena najari.  ");
INSERT INTO cul_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Naraha Baraba pohuajinena odsa panani Jerosaredsa madija inequeriqquidsa romanodenidsa mohua mohua quinadsa coro idsimamanajari. Pohuajine naco madija dsoqquejari. ");
INSERT INTO cul_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Piratopa Jeso tappa inahijine tohuini nadsa madija huapimadsa huati tapomajari: —Jeso apaja onanana. Pohuadsapi ima nohuerani −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Naraha pohuadenipa jadsirema johuahua johuahua canapomajari: —¡Ahua porimacossanidsa dsoqquena, dsoqquena! −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Naraha Pirato pohuadenidsa huati tapomajari: —¿Naraha nejecotohui dsoqquehijine? ¿Nejeco imara inanajaro? Jesocca ima omittadsapi imari tabaccora tanicca nohuerani. Pohua inanadsoqquehijinepa bica tajarahi. Jesopa pina ocadossebaqquidsa cossi inaqquimanadsapa apaja onanadsa toccanihijine, onajaro −najari Pirato. ");
INSERT INTO cul_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Naraha madijadenipa Jeso ahua porimacossanidsa dsoqquehijine tohuini quinadsapa dacoco radsa denima johuahua johuahua canapomajari. Nama dsanapomanadsapa pohuadenina deni toquejenajari. ");
INSERT INTO cul_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nadsapa Piratopa pohuadeni attidsa jehe najari. ");
INSERT INTO cul_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Madija Baraba qquenahijine jipaqquiri nadsapa Piratojine qquenajari. Aja Barabapa madija inequeriqquidsa romanodenidsa mohua mohua naridsamanadsa coro todsimajari. Pohuapa madija ijine ahuahiraha ijinedeni qquenajari. Naraha Jesona dsoqquehijine pohuadenidsa eccorajari. Pina pohuadsa huati toquinapojarissa inananijine Jeso dsoqquehijine icadossebaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Soldadodenipa Jeso iaccamananaja dsama Sirenecca madija Ssinopa huidsajahuaji ccanidsa bacco ijidsamanajari. Jeso ahua porimacossani dsojo inaraha ja tojadsa soldadodenipa Ssino dama ijidsamanadsa icadossemanajari: —Manaco tia ajajaricca ahua porimacossani dsojo tinaji −quinajari. Nadsapa ahua porimacossani Ssino johuidsa ibarimanadsa Jeso natti dsojo inamissajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Madija huapi taha Jeso natti jai tojajari. Amoneje naqui nani toquejemamanajarodeni Jesotohui oji oji dsanapomanajaro, jadsirema johua johua dsanapomanajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Naraha Jesopa ponidenihuaji qqui nanidsa huati tajari: —Aji Jerosarecca amoneje tiadenipi otohui oji oji tiquinejeraji. Aji tiadeni titohuideni, aji ticcadeni ejedenitohuira oji oji tiquinana −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","—Aji otohui oji oji tiquinajaropi nidsaranibote aji Jerosaredsa ima oppina tanicca bacco nadsa nanidsana pina aji otohui oji oji tiquinajarossa tiquinanitohui. Najaro huada bacco tadsapi madijapa ajama quinahitohui: “Amoneje ccaranipi bicani ahuamanani ojimana-jerani. Ejedeni cappiramanajarojine ojimana-jerajaro. Ponideni dsojorinidsa ejedeni tomide nohue quirajaro naqui ojimana-jerajaro” quiquinanahitohui. ");
INSERT INTO cul_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ima oppina tani bacco nadsa madijapa cappinamanadsa ajama quinahitohui: “Jaho, ssono imeni dequerajaro iahuaji cojo naronaccaraho, bodi iquejenadsapi nani oppina tanicca qqui inejeranijine” quinahitohui. ");
INSERT INTO cul_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aji ohuapi imasiri onana-jeraraha ohua inajidsomanajaro. Naraha aja Jerosarehuaji madimanajarideni imasiridsa disseraqquiri nadsapa najidsohue pohuadenidsa denima oppina tanitohui −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Madija pamaha naco Jesodsama topamajonahijine iaccabaqquimanajari. Pohuadenipa botijidede raja, madija inanadsoqquemana najarideni. ");
INSERT INTO cul_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ssono Totati Tonanissa nani quiquinanahihuaji bacco tomoramanadsapa ahua porimacossanidsa que tahijine Jeso coba idsanamanajari. Coba idsanamanaha jicadsapa acca icanamacossa-manajari. Aja botijidede raja, madija inanadsoqquemana najarideni naco coba idsanamanaridsajari. Ahua porimacossani onihidsa, onihidsa naridsamanajari. Ohuahapa Jeso que tahi inori nahatonihuaji, ohuahapa Jeso que tahi inori ssamohuaji quinajari.  ");
INSERT INTO cul_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nadsapa Jeso Imehidsa huati tajari: —Abi, pohuadenipa ohuadsa ssamoqquiri nadsa ohua inanadsoqque-manaraha epejena. Aji ocasserani ohuajaro manaconipi pohuadenidsa tinana-jerana, onajaro −najari Jeso.  Nadsapa soldadodeni Jesocca eterotohui siba bedenidsa coro coro quinajari, —¿Pocca etero nejecojaridsana tojanijine? −quinadsa. Najaro sibadsa ittomemanadsapa pocca etero pohuadenidsa ojari ojari naridsajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Madija huapima nahidsa cattade domo huajari. Taminedeni naco nahidsa cattade domo huadsa attideni tabaccora tadsa Jesodsa jidsadsa jidsadsa canajari: —Ajana, madija ohuaha inassiajabaqquiraha jidapanana pohua tonassiajana. Pajissa madija Tonassiajade Cristo-Mesia tojahijine Dio icattejidsadsapa nama nahi qqui inana. Nahato taranaja −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadodeni naco Jesodsa jidsadsa jidsadsa canajari. Nadsapa jai tojessidsa uva ppejene ssicata, bidada najari Jeso dse nahijine da icanamacossa-manajari, —Pohua comene ojidsama nanijine −quinadsa. ");
INSERT INTO cul_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Attideni onihi naqui: —Tiapi jodiodenicca tamine tijadsapi tia tinassiajaji −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jeso tati tetepihuaji naqui dsodo nani coba idsanamanajaro. Najaro dsodo nanipi: —Ajajaripa Jodiodenicca Tamine −najaro. ");
INSERT INTO cul_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Naraha botijidede raja, madija inanadsoqquemana najarideni Jeso inoridsa cobaba dsanajari ojaria Jesodsa atti tabaccora tadsa jidsa jidsa najari: —Tiapi Cristo tijadsapi tia tinassiajaji. Ia naqui ia tinassiajabaqquiji −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Naraha aja coba dsanajari ohuaha attia: —¡Paji, nema tejeraji! ¿Diodsa ticappina-jerajarorane? Tia naqui ahua porimacossanidsa coba dsanahi tijaraha ¿nejecotohui tetti nema tajaro? ");
INSERT INTO cul_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aji iapi ponima ocasserani ejerani. Inajidsojarojine ocasserani ejaro. Naraha ajajari maqquidejepa najidso-jararaha ocasserani ahuajari −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nadsapa Jesodsa huati tajari: —Jeso, ticca cacahuehehuaji bacco tinadsa ohuadsa teti huato nana −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Manaco Jeso pohuadsa huati tajari: —Pajissara tiadsa huati onajaro. Aji jidapana ohuadsama memehuajicca dsama bicanihuaji timadinijine −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Maji itetepi tojadsa dsama nemanehe todsidsini najaro. Dsidsi dsanapojaropi maji 3 bacco tajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Maji todsidsidsapa Diodsa dada toqquima odsa imeni bodihuajicca huahuacossa etero sibabotepi Diojine sseo naronajaro, carobe najaro. ");
INSERT INTO cul_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Maji najarissa nadsa ssonohuaji Jesopa jadsirema huati tajari: —Abi, ticca cacahuehedsa ojapomanijine, onajaro −nadsapa Jeso huatiajari. ");
INSERT INTO cul_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nadsapa soldado tamine Jeso cacahuadepa dsama todsidsini nani qqui, Jeso huatiahi qqui tadsapa: —¡Dio bica tahi, deni tojahi! −najari. Pohua attipa: —Pajissa, ajajari maqquidejepa bica tahi. Ima cappirajari −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nadsapa madija huapima Jeso cattade domo huajaridenipa maji todsidsihi qqui, Jeso huatiahi qqui toquinadsapa cappinamanadsa domo toccanijari. Pohuadeni bacco huaccacca huaccacca tocananijari: —¡Jaho, icca dsamadsa ijine bica tejerani, bica tejerani! −tanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Naraha aja Jesodsa huatideni huanaqquiri najaridenipa huaji tanidsa qquide domo huajari. Amonejedeni naqui pohuadenidsama domoni huajaro. Najarodenipi Jeso Carireadsa ccaridsapodsa pohuadsa jahiridsajaroa Jeso pohuadsa Jerosarehuaji jahijonajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Nahidsapa madija bicabote madijari. Pohua onipa Dsodse, dsama Jodeacca odsa panani Arimateahuajicca madija. Pohuapa Diocca dosseniji inapajiranissa, pocca ima toccanissa tajaro. Dsodsepa Diocca cacahuehetohui naco najoraha madijari. Pohuapa jodiodenicca ima cacattemadedeni ojaria. Pohua tesse ima cacattemadedeni: —Jeso dsoqquena −quinaraha pohuapa jehe najarajari. Pohua tessedeni Jeso inajidsomanadsa naco najidsode jipera tajari. ");
INSERT INTO cul_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Dsodsepa Jeso assire ppa idsahijine tamine Piratohuaji huatide toccajari. Bacco tadsapa Piratodsa huati tajari: —Jeso assire ppa odsahijine ¿jehe taqui? −najari. ");
INSERT INTO cul_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nadsapa Pirato jehe nadsa Dsodse nahi Jeso coba dsanaha que tahihuaji tocanajoranijari. Jeso assire dicca inadsa etero dsojorani onini linodsa jore inaqquijari. Jore inaqquia jicadsapa tonoccobirihuaji dsojo inajari. Najaro tonoccobiripi sibadsa hui todsimajaro. Najarodsapa madija dsoqquehi podsa-jaraccahi. Najarodsa Jeso ibedsajari. ");
INSERT INTO cul_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Najaro huada viernepi jodiodenipa poccadeni jassinajacca huada sabadotohui najoramanajari. Najaro jassinajapi dsomeme nadsa bacco bacco tajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Aji amoneje Jeso pohuadsa Carireahuaji jahijonajarodenipi Jeso assire tonoccobirihuaji Dsodse dsojo inadsapa ponideni naqui nani jai tojajaro. Jai tojamissadsapi tonoccobiridsa Jeso assire ibedsahi qqui toquinajaro. ");
INSERT INTO cul_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nadsapi odsahuaji jai tojanidsa majojo majoni bica tajaro, ahua majiconi majoni bica tajaro najoramanajaro. (Pina jodiodeni poccadeni madija dsoqquejari assiredsa sse inamaromanajari, huira inamaromanajarissa inanamananijine najoramanajaro.) Nadsapi jassinajacca huada tojadsapi jassi quinajaro, pina Moisesicca marinajassa inanamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Semana tojapomanicca huada tahidecca domingo dsidsidsamassana amonejedenipi Jeso noccobirihuaji qquide jai tojanipomajaro. Ahua majiconi majoni bica tajaro najoramanapoje najaro iaccamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Bacco toquinadsapi qqui toquinaneje tonoccobiripi tohuabeje najaro. Siba imenipi pajimaranihuajina huitteje najaro. ");
INSERT INTO cul_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nadsa jai tojedsimadsa qqui toquinaraha Jeso assirepa podsa najarajari. ");
INSERT INTO cul_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nadsapi jabojomanadsa: —¿Nejecoma najari? −quinajaro. Nanaja madija pamaha eterorideni ssiaja tajaro ponideni inorinidsa ahuatoma-manajari. ");
INSERT INTO cul_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nadsapi cappinamananissa tadsa ponideni pitonidsa jassi, tocattedsamana, namidsa assarinideni bacco tajaro. Najarideni pamaha ponidenidsa huati toquinajari: —¿Nejecotohui Jeso qquide ahuaji jai tijajonajaro? Paja dsoqquemanarihi najaridenina pohuadeni noccobiridsa podsamana tahi. Naraha Jesopa camittemanidsa madihi −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Tibodideni huatomaniji. Dsama arobeni Carireahuaji timadimanapodsa tiadenidsa pocca ima huati huati nanaja napode. ");
INSERT INTO cul_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pohua attipa: “Ohuapi Madija Bedi ojajaroa nidsa dsotode madija ojaria ohua ccaccoradsapa imasiri sseqquiri najarideni dsepedenidsa ojanitohui. Ahua porimacossanidsa ohua inanadsoqque-mananitohui. Ohua ppa idsamanaraha huada 3 nadsa onahatoninitohui” napode pohua atti −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nadsapi Jeso atti bodinideni huatoma-manajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tonoccobirihuaji jahinidsa odsahuaji bacco nanimanadsapi Jesocca dodosse tabaqqui 11 quinajaridenidsa ima huati toquinajaro. Jesocca madija motadenidsa naqui huati naridsamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ponideni oninipi Maria Madarenahuajicca, Dsohuana, Maria Satiaco imeni quinajaro. Amoneje onihideni naqui ponidenidsa quejemamanajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Naraha Jesocca dodosse tabaqqui ima mittamanadsapa pohuadenidsa jidsa tajaro, pina ponideni bodini tossamojarossa najaro. Ponideni attinidsa pajissa quina-jarajari. ");
INSERT INTO cul_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Naraha Pedropa nama naha Jeso noccobirihuaji joppa tajari. Bacco tadsapa tonoccobiri bodihuaji tocattedsima nanaja Jeso assire jojore naqqui eteroa podseje nanira qqui tajari. Nadsapa Pedro pocca odsahuaji bodi huatohua toccanijari. ");
INSERT INTO cul_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Najaro ssiajadsa Jeso huatimadedeni pamaha odsa capamema najaro onini Emaohuaji tohuedajari. (Aji Jerosaredsa maji 3ʼdsa ticcadsapi maji 6ʼdsa Emao bacco tinani.) ");
INSERT INTO cul_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nadsapa najarideni pamaha najaro jahui tohuedajaria Jeso tahimari huahuatiti dsanapojari, aji ima huapima mittamanajari, aja pohuadeni qqui toquinajaricca ima huahuatiti dsanapojari. ");
INSERT INTO cul_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jahuidsa ahuaji huati ahuaji huati dsanapomananaja Jeso naco pohuadenidsa bacco tadsapa huapima jai tojajari. ");
INSERT INTO cul_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Najaripa Jeso pohuaraha pohuadsa noccodeni jidsa tajari. ");
INSERT INTO cul_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nadsapa Jeso pohuadenidsa huati tajari: —¿Nejeco imara ahuaji huati ahuaji huati tidsanapomanajaro jahui motta? −najari. Nadsapa ba nanaja panodeni todsahi najari. ");
INSERT INTO cul_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Najari madija pamajarideni ojaria Cleopa pohuana Jesodsa huati tajari: —Tia naqui Jerosarehuaji Pascoacca ejetetohui timadiraha ¿ima dsati ssamo tinajaroqui? Aji Jerosarecca ima dsati huapima nahatoqquiri inaraha ¿tiaha ssamo tinani ojari tajarorane? −najari. ");
INSERT INTO cul_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—Naraha imapi ¿nejecoma najaro? −najari Jeso. Naraha Cleopa pohua tesse tedseje huati toquinajari: —Jeso Nasaretihuajicca pohuadsa ima inanamanajaro tahimarinipi ajima najaro: Pohuapa Dio Atti cacomerajide rabote. Diocca dacorehejine pocca marinaja bica tajaro. Diocca dacorehejine canahatori canaridsajari naco bica tajari. Madija huapimadsa, Diodsa naco pocca ima bica tade. ");
INSERT INTO cul_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Naraha dada toqquimade taminedeni, ia jodiodeni icca taminedeni quinadsa Jeso dsoqquehijine romanodenidsa da quinajari. Pohuadenina idsahuamanahi dsotodepa ahua porimacossanidsa coba idsanamanadsa inanadsoqque-manajari. Nama inanamanade. ");
INSERT INTO cul_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Naraha Isaraeri potemahi jodiodeni iapi icca dsamadsa iara imadinijine aja “Jeso pohuajinena icca cacahuehe tojapomanijine” inajaro ibodidsa. Naraha pohua huatiahicca huadapi jidapapi huadari 3 nani. ");
INSERT INTO cul_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Naraha iadsa amoneje queriqquimanajarodenijine ijabojo najaro. Ponidenipi ssiajaricossadsa Jeso cahuahihuaji jai tojajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Naraha pohua assire qqui quina-jarahi. Nadsama amonejedenipi jahinidsa huati nanimanajaro: “Diocca dodosse tabaqqui memehuajicca qqui inabaqquipa. Iadsa attidenipa: ‘Jesopa nahatonihi’ quinapaja” quinajaro. ");
INSERT INTO cul_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nadsapa itesse pamaha tohuedajari Jeso cahuahihuaji. Pohuadeni naco pina aji amoneje ponideni attinidenissa nehe qqui toquinaraha Jesopa qqui quina-jarahi −quinajari Cleopadeni. ");
INSERT INTO cul_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nadsapa Jeso huati tajari: —¡A, tiadenipi ssamomo tinajaro! Dio Atti cacomeraqquiri najaridenicca marinaja dsodo quineje najonaponi najaro nemanehe Dio Atti dsodo nanidsa dsodo napojaro titimittamana naraha ¿nejecotohui pajissa tiquinanijine tibodideni najoqquiri nani? ");
INSERT INTO cul_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Dio Atti dsodo nanidsa ajijaro ima ahuato tajaro: Najaroa aji madija Tonassiajade Cristo-Mesiatohui imadijaro ocasserani ahuahitohui, madijacca tabaccorehe manaconi tojahijine. Ocasserani ahua-jaradsa dsoqque-jaradsapa Diocca deni tojehe pohuadsa ahuato-jeranitohuiraha. Pajissa najidsohue imeni ocasserani ahuadsa dsoqquedsapa nahatonidsa Imehihuaji toccamacossanijari. Nadsapa pocca Abi Dio pocca deni tojehe pohuadsa inanajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nadsapa Dio Atti dsodo nanicca pohuadeni bodi huatoma-manahijine mari icanabaqquijari Jeso. Tahidepa Moisesicca marinajadsa Cristo-Mesia tahimari dsodo nanidsa Jeso pohua tahimari pohuadeni mari icanabaqquijari. Dio Atti cacomeraqquiri najaridenijine pohua tahimari dsodo najonamanajaricca dsodoniji naqui mari icanabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Odsa capamema najaro Emao bacco toquinadsa Cleopadenidsa Jeso attipa: —Jehe, ajidsa tibomanaji. Ohuapi denima occani −najari. Pohua atti nama nadsapa tossoniqquimahitohuiraha ");
INSERT INTO cul_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Cleopadenipa Jeso pohuatohui quinadsa pohuadsa huati toquinajari: —Iadsa tiboccaji. Maji toccahi, dsomebote nani −quinajari. Nadsapa pohuadenidsa ibojari Jeso. Pohuadenidsama odsadsa toqquedsimajari. ");
INSERT INTO cul_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nadsapa jipamanahijine jassi taridsa Jeso pan ididsa Diodsa huati tajari: —Jehe Abi Dio, tiadsa etidsejaro. Ticca daniji iadsa bica tinanajari, inajaro −najari. Icanarobedsa pohuadenidsa da inaridsajari. ");
INSERT INTO cul_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nanaja noccodeni ssire-re nadsa Jeso jidsera nimananijari. Naraha amadsati amossi najari. ");
INSERT INTO cul_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nadsapa pohuadenira huati tocanirejari: —¿Nejecotohui pohuapa jahuidsa qqui inajonaraha inocco jidsa tapa? Iadsa huati huati najonadsa Dio Atti dsodo nani ia mari tocanabaqquidsa ibodi etidsepa −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nadsapa huassinaja totehemamanadsa Jerosarehuaji tohuedanijari. Bacco tanimanadsapa Jesocca dodosse tabaqqui 11 quinajarideni pohuadeni tesse tedseje queriqquimanahihuaji tohuededsimajari. ");
INSERT INTO cul_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Queriqquimanajaridenipa aja huededsimajaridenidsa huati toquinapojari: —¡Jesopa pajissa nahatonijari! Ssino attipa: “Qqui onahi” napa −quinajari. ");
INSERT INTO cul_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Manaco Emaohuaji tohuedajarideni poccadeni ima huati nanimanajari. Aja jahuidsa Jeso pohuadenidsa huati huati dsanapojaricca ima huati, odsadsa Jeso pan icanarobedsa pohuadenidsa da inaridsadsa noccodeni jidsera najari naco huati toquinajari. ");
INSERT INTO cul_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aja Jeso qqui toquinajaricca ima imahaha canaraha nahi nocconidsa Jeso ahuatomajari. Pohuadenidsa: —Nija, ticappinamana-jeraji. Diocca biquehera tiadenidsa tojana −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Naraha jabojomanadsa bodidenipa: —¡Corime itidija! −quinadsa cappinamanajari. ");
INSERT INTO cul_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Naraha Jeso pohuadenidsa huati tajari: —¿Nejecotohui ticappinamanajaro? ¿Nejecotohui tibodideni tossamojaro, pina ohuadsa pajissa tiquirani naha? −najari. ");
INSERT INTO cul_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","—Jari, ohuamori qqui, odsepe qqui tiquinaji. Ohuapi ohua. Ohueme bara tiquinaji, nadsana nahatoto tinanijine. Aji icorimepi ime cappira, tone cappira nahi naraha ohuapi ohueme ocaji, otone ocaji nani qqui tiquinani −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nadsapa pohua dsepe nohue, pohua amori nohue najari. ");
INSERT INTO cul_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nadsapa huatidsemanaraha pohuadeni bodipa: —¿Pajissa, Jeso nahatonijarico? −quinajari. Nadsapa nahatoqquiri nahijine Jeso pohuadenidsa huati tajari: —¿Ajidsa ojipanijine ticajimanaqui? −najari. ");
INSERT INTO cul_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","43","Nadsapa pohuadsa aba ibanahi bobi da quinadsa pohuadeni dsepecca ididsapa cattomama canaraha jipajari. ");
INSERT INTO cul_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nadsapa pohuadenidsa huati tajari: —Aji ima ohuadsa tojajaropi pina tiadenidsa occaridsaponi huati onapojarossa najaro tojajaro. Najaropi Dio Atti dsodo naponiccassa najaro. Aji Moisesi otahimari dsodo inapojaropi najarossa najaro. Dio Atti cacomeraqquiri najarideni naco otahimari dsodo quinapojari. Ajie jijiridedeni naco otahimari dsodo quinapojari. Najaro huapimapi maittaccadsama dsodo quinaja najonapohui najari. Najarossa najaro Diojine ohuadsa tojajaro −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nadsapa Dio Atti dsodo naponicca mittamanahissa tahijine bodideni acco icamabaqquijari. ");
INSERT INTO cul_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pohua atti naco: —Jehe, Dio Atti dsodo nanidsapi otahimari. Najaroa aji madija Idinide Cristo-Mesia quiquinanajari ccajonadsapa ocasserani imeni inahananitohui. Madija inanadsoqque-manadsa ppa idsamanaraha huada 3 nadsa nahatonihitohui. ");
INSERT INTO cul_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Najaro pohua tahimari ecomeraridsa-manadsapi madija bodideni cacajiqquimera-manahijine naco huati toquinahitohui. Nadsapa madija pohuadeni bodi cacajiqquimera-manadsa: “Occa imasiri onebona” quinadsapa Dio poccadeni imasiri epeje inananitohui. Najaro ima bicanipi madija huapima mittaridsamanahijine Cristo-Mesiapa pocca dodosse tabaqqui mari naridsamanahijine dosse inaridsabaqquihitohui. Tahidepa Jerosaredsa mari icanabaqquimanahitohui, dsotodepa dsama huapimadsa maride jai tojaridsahitohui. Najari Cristo-Mesiapa ohua. Otahimari maridepa ohua occa madija dosse onabaqquihijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Nadsama tiadeni occa dodosse tabaqqui tiquejenajaropi ohua Cristo-Mesia ojani nahatoqquiri tiquinani. Odsoqqueraha onahatonini pajissa tinoccodenidsa qqui tiquinajaro. Nema nadsapi otahimari tecomeraridsamanaji. ");
INSERT INTO cul_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Naraha tahidepi Jerosaredsa timadimanaccaji. Nidsa occa Abi Dio huati tapojarissa najari ohuana tiadenidsa dosse onaronahitohui. Najari Dio Corimena tiadenidsa tojaridsahitohui. Pohuapa Dio memehuaji madijaricca dacorehe tibodidenidsa inanaridsanitohui. Nadsana otahimari mari taridsamananijine −najari Jeso. ");
INSERT INTO cul_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nadsapa Jeso pohua huatimadedeni odsa pananidsa iaqquenabaqquijari. Odsa capamema najaro onini Betania tohuajiranidsa domo huajari. Nahidsa pohua huatimadedenitohui pocca Abi Diodsa huati tajari. Pohua dsepe memehuaji da tamacossadsa: —Jehe Abi, ajajarideni tecahuabaqquijo. Ticca biquehe pohuadenidsa tinanaridsaji −najari. ");
INSERT INTO cul_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pohuadenitohui Diodsa huati huati tanaja toccamacossanijari. Imehi Dio memehuaji iaccamacossanijari. ");
INSERT INTO cul_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nadsapa pohua huatimadedeni attidenipa: —¡A, Jesopa bica tahi! ¡Deni tojahi! −quinajari. Nadsapa Jerosarehuaji huatidsemaneri tanimanajari. ");
INSERT INTO cul_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Huajijiradsa Diodsa dada toqquimahuaji quequeriqquimana dsanapojari. Diodsa huatidsemanadsa jiri jiri quinajari. Pohua Atti mimittamana najari, Pohuadsa huati huati dsadsanapomana najari.");
INSERT INTO cul_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jesopa ajijaro nami nahato-jeraccadsama nadsama madipojari. Pohuapa Dio Atti. Pohuapa nadsama Diodsa madipojari. Pohua naco Dio. ");
INSERT INTO cul_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nami nahato-jeraccadsama Jesopa Diodsa madiridsapojari. ");
INSERT INTO cul_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nadsama aji huapima tojaridsajaropi Jesona inanaridsajaro. Jeso nohueradsapa nassa aja namicca huapima tojaridsa-jaranaja. ");
INSERT INTO cul_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nadsama Jeso pohuapa camittehe jinede. Najaricca camittehena madijadsa ssiajani tojaridsajaro. ");
INSERT INTO cul_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Najaro ssiajanina dsidsinihuaji jororo canadsa tossiajabaqquijaro. Nadsama dsidsinipi Jeso ssiejene inadsidsinijinepi ssamo tani. ");
INSERT INTO cul_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Maqquideje onipa Huano. Pohuadsa: Baotista, quiquinanajari. (Ettidsapi: Totopade, inajaro.) Pohuana Dio icadossedsa: —Jesona ssiajani jinede −naridsahijine. Nama naridsadsa ssiajani jinede Jesodsa pajissa quinahijine. ");
INSERT INTO cul_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Huanopa ssiajani jinede jarahi. Pohuapa ssiajani jinedecca ima cacomerade madijari. ");
INSERT INTO cul_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ssiajani pajissapi aji namihuaji bacco naronajaro. Najaro ssiajanina madija huapimadsa tojaridsajaro. ");
INSERT INTO cul_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ssiajani jinedea aja namidsa ccaronadsa madijaripaja. Aja huapima cajiridsajaripa pohuana inahatoridsajari. Naraha madijapa pohuadsa noccodeni jidsaqquiri najari. ");
INSERT INTO cul_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Pocca madijadsa bacco naraha pohuadsa jiperaqquiri najari. ");
INSERT INTO cul_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Naraha madija Jesodsa pajissa nadsa: —Jeso ohuadsa tojana −nadsapa najaridsana Dio huati huati tajari: —Occa ejedeni tijajaro bica tani −nanaja najari. ");
INSERT INTO cul_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Madija Diocca ejedeni toquejenahijinecca imapi pina madija tossonajaricca imassa nejerani. Pina maqquideje amoneje tohuini nadsa inajiadsa ejedeni dsati tossonajaricca imassa nejerani. Naraha Diojine pocca ejedeni toquejenajaripa Dio Pohuajinena bodideni dsati totoja najaro. ");
INSERT INTO cul_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Dio Attiraha assire tojadsapa Jeso iadsa madijaripaja. Pocca nahatonijipi bicabote deni tojani qqui inade. Nadsama pocca nahatohuepi ojariana nahato tajari. Abi Dio Bedina ojarihi. Pohuapa huati huana tadsa ia todinibaqquijari. Pohuapa pajissehe jinede. ");
INSERT INTO cul_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nadsama aja Huanopa Jeso tahimari ecomeraridsajaropi: —Najari tahimaria huati onapojarode: Ohua mari mari onaporaha aja dsotode mari mari najarina deni tojajari. Pohuapa nadsama madipojari, ohonanapode −nade Huano atti. ");
INSERT INTO cul_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nadsama pocca biquehepi pohuajine iadsa huapi tehe tojeje dsanaponi najaro. ");
INSERT INTO cul_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nadsama maittaccadsama Moisesipa Diocca dosseniji mari mari napojari. Najaro pocca marinaja huarijonania aji iadsa bacco najaropaji. Nadsama jidapapa Jesocristona Diocca tohuati huanehe, pocca pajissehe iadsa ahuato inanajaropaji. ");
INSERT INTO cul_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nadsama madija iapi Dio qqui inaja cama-jarahi. Pohua Bedi ohojaridejinena Abi Diodsa nahatoqquiri inajaro. Pohuapa Dio bonoccoriccaja najari. ");
INSERT INTO cul_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nadsapa odsa panani Jerosarecca jodiodenicca taminedeni attipa: —¿Huanopa aja tohui imadijaro ia Idinide Cristo-Mesiaco? −quinadsa Diodsa dada toqquimade, pohuadeni biji accode rehuitadeni tedseje huahua inabaqquimanajari. Nadsapa pohuadenidsa: —Huano madihihuaji jai tijaji, pohuadsa huati tiquinadsa: “Tiapi ¿nejecojari tijani?” tiquinana −quinadsa dosse inabaqquimanajari. ");
INSERT INTO cul_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Nadsapa jai toja, bacco toquinadsapa poccadeni tamine attideni Huanodsa huati iqquimamanajaro. Naraha Huano pohua cacoma-jarajari. Amadsati pohua cacomerade: —Ohuapi Cristo ojajerani −nade. ");
INSERT INTO cul_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Naraha pohuadsa huati toquinapomade: —Nadsapi ¿nejecojari tijani? ¿Maittaccadsamacca Dio Atti cacomerabote Eria tijaqui? −quinade. Naraha Huanopa: —Ohuapi Eria ojajerani −nade. Nadsapa: —¿Moisesicca dsodonijidsa aja Dio Atti cacomerabote dsotode ccajonahitohui quiquinanajari tijaqui? −quinade. Naraha Huanopa: —Ohuapi najari ojajerani −nade. ");
INSERT INTO cul_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Naraha denima Huanodsa huati toquinapomade: —Nadsapi ¿nejecojari tijani? −quinapomade. —Jari, iadsa ticca ima tecomeraji. Tetti imittadsapi ia dosse najonadedenidsa huati inaninijine −quinade Huanodsa. ");
INSERT INTO cul_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Naraha Huanopa pohua cacomerade: —Ohuapi dsama huamoni ssono caji, siba caji tanihuaji ohuatti mohui tadsa madija huahua huahua ohonajonabaqqui najari. “¡Ia Medsede tedsejema jahui tijinedeni tobicapoji! Najaroa aji tibodideni pohuatohui tinajoramanaji” ohonanajaro. Najaro imapi maittaccadsama Dio Atti cacomerabote Isahia huati tapojari −nade Huano atti. ");
INSERT INTO cul_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Aja Huanodsa huati toquinajarideni dosse najonadedenipa Isaraeri potemahi jodiodeni mota marinaja onini pariseodsa jehe quinajari. Nadsapa poccadeni dodosse tabaqqui Huanodsa huati toquinapomajari. ");
INSERT INTO cul_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pohuadeni attipa: —Tettipi: “Cristo ojajerani. Eria ojajerani. Dio Atti cacomeraqquiri najarideni ojaria ojajerani” tadsapi ¿nejecotohui passodsa madija topa topa titidsanabaqqui najaritta? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Naraha Huano pohua cacomerade: —Ohuapi passodsara topa topa ohodsanabaqqui najari. Naraha madija ohuaha tiadenidsa madiraha pohuadsa tinoccodeni jidsaqquiri naccani. ");
INSERT INTO cul_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Najarina deni tojajari. Ohuapi tahide mari mari onaporaha pohuapa dsotode mari mari najonahitohui. Ohuapi ajimani ojani. Pina pocca medsessa onanijinepi opajira-jerani. Pohua amoricca sadaria diccade naqui opajira-jerani −nade Huano atti. ");
INSERT INTO cul_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ajijaro imapi odsa capamema najaro onini Betaniadsa qqui inapode. Betaniapi hueni Jordao maji ccajonahihuaji anijaro. Nahihuaji Huano Baotista madija topade tojadsana pohuadsa huatide jahijonajari. ");
INSERT INTO cul_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nani Betaniadsa imadiccadsapi najaro huada ssiajadsa Huano Jeso ccajonahi qqui tadsa iadsa huati tajaride: —¡Qqui tiquinajo! ¡Ajajaripa Diocca daniji madija huapimadsa! Pohuapa Diocca Edede Bedi bicabote Diodsa da da inajarissa najari. Nidsa dsoqquedsapa pohuana madija huapimacca imasiri inanamossinitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Nadsa pohua tahimaripi tiadenidsa huati huati onapode: Ohuapi tahide mari mari onaporaha aja madija dsotode mari mari najonajarina deni tojajari. Ohuapi ajimani ojani. Pohuapa nadsama tahide madipojari, ohonanade. ");
INSERT INTO cul_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ohuapi pohuadsa ssamo onade. Naraha Isaraeri potemahideni tiadenipi pohuadsa nahatoqquiri tiquinanijinepi Dio ohua cadossedsa madija passodsa topa topa onajaropaji −nade Huano. ");
INSERT INTO cul_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Huanopa tahide Jeso topa idsanadsa Dio Corime Jesodsa ccaronahi qqui tadsa iadsa huati tajaride: —Ohuapi Dio Corime qqui onade. Pina midsorissa naha ccaronadsa Jesodsa be tahi qqui onade. ");
INSERT INTO cul_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ohuapi pohuadsa nahato onapo-jerade. Naraha passodsa topa odsanabaqquihijinepa Dio ohua cadossedsa ohuadsa huati tapojaride: “Ocorime ccaronadsa madijadsa be tahi qqui tinahitohui. Najarina Ocorime madijadsa inanaridsahitohui” napode Dio ohuadsa. ");
INSERT INTO cul_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jehe, najaripa pajissa ohua qqui onadsa huati onajaro: Ajajaripa Dio Bedi, onajaro −nade Huano atti. ");
INSERT INTO cul_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huada ssiajadsa Huano Baotista pohua huatimade pamaha tedseje domo hua pomade. ");
INSERT INTO cul_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nahidsana Jeso toqqueqquimahi Huano qqui tadsa pohuadenidsa huati tajaride: —¡Qqui tiquinajo! ¡Ajajaripa Diocca daniji madija huapimadsa! Pohuapa Diocca Edede Bedi Diodsa da da inajarissa naraha icca imasiri manaconi tojahijine Dio iadsa eccorajari −nade Huano iadsa. ");
INSERT INTO cul_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nadsapa Huano huatimade pamaha ima mittamanadsapa Jesodsa tohuedamissade. ");
INSERT INTO cul_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jeso natti tohuedamissaraha Jeso pohua natti qqui naninaja pohuadeni huedajonahi qqui inabaqquijaride. Nadsapa Jeso pohuadenidsa huati tade: —¿Nejecotohui ticadajonajaro? −nade. Naraha: —Ia Maride ¿nejecohuaji timadijaro? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Naraha Jeso: —Jina, qqui tiquinaji −nade pohuadenidsa. Nadsapa jai tojajari. Maji toccadsana pohua madihihuaji bacco toquinadsapa qqui toquinade. Nahi pohuadsa jassi todsadsapa dsomejarode. ");
INSERT INTO cul_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jehe, Huano huati tahi mittamanadsapa Jesodsana toquejenajaride. Ojariapa Ssino-Pedro imecote Adiri. ");
INSERT INTO cul_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nadsapa Adiri Jesocca odsahuaji qquenadsapa pohua imecote Ssinotohui toccajaride. Pohua imecote Ssinohuaji bacco tadsapa huati tajari: —¡Ssino, iapa aja tohui imadijaro Mesia bacco inahi! −najari. (Jodio attidenidsapa: Mesia, quinaraha dsama Cresiacca madija attidenidsapa: Cristo, quinajari. Madija ettidsapa: Madija Tonassiajade tojahijine Dio pohua icattejidsapojari, inajaro.) ");
INSERT INTO cul_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nadsapa Adiri pohua imecote Jesohuaji eccanijari. Jeso Ssino qqui tadsapa pohuadsa huati tade: —Tiapi Huanocca ejedeni Ssino tijani. Ssino tijaraha jidapapi tia oni onihira hua onana −najari. Nadsapa pohua oni hua inadsapa: —Sepa −nade. (Jodio attidenidsapa: Sepa, quinaraha dsama Cresiacca madija attidenidsapa: Pedro, quinajari. Madija ettidsapa: Siba, inajaro.) ");
INSERT INTO cul_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huada ssiajapa Jeso: —Dsama arobeni onini Carireahuaji occana onajaroa −nade. Nahihuaji toccadsana Jeso Feripe bacco inadsa pohuadsa huati tajari: —Jina, ohuadsa ticcaridsaji, ohuatimade tijadsapi tia onahattanijine −nade. ");
INSERT INTO cul_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nadsama Feripepa Besaida odsa pananicca. Pedro, Adiri naco najaro odsa pananicca. ");
INSERT INTO cul_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Feripepa pohua tesse Natanahetohui toccajari. Bacco inadsa pohuadsa huati tajari: —Iapi Moisesicca dsodonijidsa tahimari ihimitta najari bacco inahi −najari. —Dio Atti cacomeraqquiri najarideni pohua tahimari dsodo quinajari. Pohua onipa Jeso, Dsodsecca ejedeni. Pohuapa odsa panani Nasaretihuajicca −najari Feripe. ");
INSERT INTO cul_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Naraha Natanahe attipa: —A ¿Nasaretihuajicca madijapa bica tajari caji taco? −najari. Nadsapa Feripe Natanahedsa: —Jina, nidsa qqui tinahitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nadsapa Natanahe Jesohuaji toccadsapa Jeso Natanahe ccajonahi qqui ijidsadsapa pocca ima naqui pohuadsa ahuato tajaro. Nadsapa Jeso Natanahe tahimari huati tade: —Qqui, aja maqquideje ccajonajaripa pajissa Isaraeri potemahi. Icca ididenicca marinaja ecahuanissa tajaro. Pohuapa maidsera tahi −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Naraha Natanahe atti Jesodsa: —¿Nejecoma nadsa ohua qqui tinadsa ohuadsa nahato tinajaro? −nade. Naraha Jeso Natanahedsa huati tade: —Nadsa Feripe tiadsa huati tajaraccadsa ahua iquiera dopedsa teni tia qqui onapa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Naraha Natanahepa: —Ia Maride, ¡tiapi Dio Bedi tijani! ¡Tiapi Isaraeri potemahidenicca tamine tijani! −nade. ");
INSERT INTO cul_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Naraha manaco Jeso pohuadsa huati tade: —¿Iquiera dopedsa teni tia qqui onapa onajarodsa ohuadsa pajissa taqui? −nade. —Nidsa, nahatonaja deni tojanicca huapi tani qqui tinanitohui −nade Jeso Natanahedsa. ");
INSERT INTO cul_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nadsama Jesopa ima denima huati huati tade iadsa: —Pajissara tiadenidsa huati onajaro: Nidsa meme tohuabani naqui qqui tiquinanitohui. Aji ohua Madija Bedi ojajaro ohuadsa Diocca dodosse tabaqqui memehuajicca jahirona jai tojamacossani, jahirona jai tojamacossani nahi naco qqui tiquinanitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Huada 3 bacco tadsapi Canahuaji cajicajicca ejete tojajaro. Canapi dsama arobeni onini Carireacca odsa panani. Jesocca ami naqui nani ejete qquide toccajaro. ");
INSERT INTO cul_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jeso pohua huatimadedeni ia naqui nanidsa jaijedsimade. Cajicajicca ejete jinede iadsa jina nadsa jaijedsimajarode. ");
INSERT INTO cul_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Naraha uva ppejene jicadsa Jesocca amipi: —Uva ppejene jicaha −nade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nadsapa Jeso atti: —Ami ¿nejecotohui ohuadsa huati tinajaro? Occa ima ahuato onananijine bacco tejeraccaraha −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Naraha imenipi jijipa dsodsojodedenidsa huati tade: —Jeso tiadenidsa huati tadsapa pohua attissa tinanamanaji −nade. ");
INSERT INTO cul_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Naraha nanidsapi siba imeni passojine ccohue todsaridsani 6 nehe cajimanajaride. Najarodsapa jodiodeni —Icca ima bica tanijine −quinadsa pohuadeni dsepetaji ettippamana, idimoramana nanaja najari. Najaro siba imeni ccohue todsani ojariedsapi passo 80 litro ijijaro nitide. ");
INSERT INTO cul_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nadsapa Jeso jijipa dsodsojodedenidsa huati tade: —Siba ccohue todsaridsanidsa passo tinajiridsamanaji −nade. Nadsapi najarodsa passo inajiridsamanadsapi iponihuaji bacco bacco teri nade. Nadsapa Jeso canahatori canajarijine passoraha uva ppejene inanajari. ");
INSERT INTO cul_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nadsapa Jeso: —Jari, jidapapa badsira taha huana ticadsanamanadsa cajicajicca ejete cacahuadedsa dsojo ticanamanajo, ecatamahijine −nade. Nadsapa uva ppejene huana icadsanamanadsa dsojo icanamanade, pina Jeso attissa inanamanajaro. ");
INSERT INTO cul_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nadsapa ejete cacahuadedsa da icanamanadsapa aja passoraha uva ppejene tojajari badsira taha ecatama nade. Naraha ejete cacahuadepa ssamo tadsa pohua bodi: —¿Nejecohuajicca uva ppejene? −najari. Naraha uva ppejene dsodsojode pohuadenina passo ponira dsojo dsojo inanimanajarojine nahatoqquiri nahi. Nadsapa ejete cacahuade aja cacajirebote najaridsa huati tade: ");
INSERT INTO cul_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—Madija huapimapa ejete inahatomanadsapi tahide uva ppejene bica tahiccara da da ihicanaridsa-baqquimana nanaja najari. Madija accaramanadsana ajamani majidera tahicca da da ihicanaridsa-baqquimana najari −nade. —Naraha tiapi uva ppejene denima bica tahiccapa teccoccobaqqui, dsotodena da ticanabaqquijarirana −nade ejete cacahuade atti. ");
INSERT INTO cul_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ajijaro imapi Carireahuajicca odsa panani Canadsa Jeso tahidecca canahatori canapojari. Najaropi Jeso pocca deni tojehe ahuato inanapojaro. Nadsapi pohua huatimadedeni iapi Jesodsa pajissa inajarode. ");
INSERT INTO cul_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nadsapi coridsa inidicca odsa panani Capernaohuaji jaijedsippade. Jeso pohua, pocca ami, pohua imecotedeni, pohua huatimadedeni ia huapima jaijedsippade. Nanidsapi huada pamehe imadide. ");
INSERT INTO cul_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jodiodenicca ejete imeni onini Pascoa tohuajiradsapi Jesopa Jerosarehuaji toccade. ");
INSERT INTO cul_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Naraha nani Jerosarehuajicca Diodsa dada toqquimadsapi manaconitohui dadadedeni dade toquejenahi Jeso qqui inabaqquijari. Bohui, edede, midsori da da quiquinanajari. Dsiniro cacajiqquimera-manahijine naco dade huihuittariri naridsajari. ");
INSERT INTO cul_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nama quinahi Jeso qqui tadsapa cocossi amadsati inahatojaride. Ijinedeni poponeri najari inaccaridsadsa inahapicossa, ppiro-ro nadsa itacossiridsajaride. Nadsapa Diodsa dada toqquimahuajicca dadadedenipa amossinihuaji mohua ininebaqquide. Poccadeni ededema, poccadeni bohuima domo toqquenajaride. Dsiniro cacajiqquimera-manahijine dsiniro naqui maca maca imeri naridsade. Huahuanari naqui cco cco icanacosseri naridsade. ");
INSERT INTO cul_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Midsori dadadedeni naco dosse ininebaqquide: —¡Ajicca huapihuajina ticcadeni midsori dsojo dsojo tininemanaji! ¡Aji occa Abi tadsaridsapi dada tinanamana tejeraji! −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nadsapi pohua huatimadedeni iapi eti huatomajarode: —Dio Atti dsodo napojaropi: “Ticca odsa acconipi ohuana ocasserani ohuanitohui” nanaja napode −inade. ");
INSERT INTO cul_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Naraha dsotodepa jodiodeni Jeso huati icanamanade: —¿Nejecojari tia cadossedsa nema nema tajaro? ¡Jari, ticanahatori canaji! Qqui inadsana pajissa inanijine −quinade. ");
INSERT INTO cul_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Naraha pohuadenidsa Jeso huati tade: —Jari, ajijaro Diocca odsa ticanajidsomanehe cajicaneje huada 3ʼpi ocanahatomanie cajicanitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Naraha jodiodeni Jesodsa huati toquinapomade: —¡A, apaja! Ajijaro odsa Diodsa dada toqquimapi huada huajano 46 naha dsepedeni ijimanade. Naraha tettipi: “Ajijaro odsa huada 3ʼpi ocanahatomanie cajicanitohui” taha. ¡Nema ticanana-jerani! −quinade. ");
INSERT INTO cul_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Najaro odsacca ima huati tajaripa pohua assire tahimarini huati tajaride. ");
INSERT INTO cul_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iapi pohua huatimadedeni Jeso dsoqquedsa nahatonidsana eti huatomajaropajide. Najaropi pohua huati tadsa imittapojarode. Nadsapi Dio Atti dsodo napojaroccadsa denima jehe pajissa idsanapojarode. Jeso huati huati tajari imittapojarodsa naqui jehe pajissa inajarode. ");
INSERT INTO cul_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesopa ejete Pascoatohui Jerosaredsa madiccadsapa canahatoriri canaridsajaride. Pocca nahatohue qqui toquinadsapa madija mota pohuadsa pajissa quinade. ");
INSERT INTO cul_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","Naraha Jesopa pohua bodidsa nahato tajari: —Ohuadsa pajissa quinahissa tahi −najarajari. Pohuapa madija bodicca ima mittahijine pohuadenidsa: —¿Nejecoma nani tibodidenicca ima? −najarajari. Madija pohuadeni bodicca ima pohuadsa huatide nohueraraha pohua ehuerahi nahato tajari. ");
INSERT INTO cul_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Isaraeri potemahi jodiodeni dossede ojaria onipa Nicodemo. Pohuapa marinaja onini pariseodsa jehe najari. ");
INSERT INTO cul_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Najaripa dsomeraha Jesodsa huati tahijine ccajonajari. Bacco najonadsapa: —Mamaride, iapi nahatoqquiri inapode. Tiapi Diocca dosseniji ticcajonajaro madija maride. Nahatohue pina aji ticcassa najaropi madija Dio pohuadsa tojahissa tajarina cajijari. Pohuadsa Dio nohueradsapa caji-jarahi −nade Nicodemo. ");
INSERT INTO cul_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Naraha Jeso Nicodemodsa huati tajari: —Pajissara tiadsa huati onana: Madija Diocca cacahuehedsa tojahijinepa tossonapomadsana Diodsa tojahitohui. Tossonapoma-jaradsapa Diocca cacahuehedsa toja-jarahitohui −nade Jeso Nicodemodsa. ");
INSERT INTO cul_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Naraha manaco Nicodemo huati tajari Jesodsa: —Madija jadahi ijaraha ¿nejecoma inadsa pina ejedeni inehe issonapomanijine? ¿Icca ami dsahuanidsa ittidsapomadsapi issonapoma taqui? −nade Nicodemo. ");
INSERT INTO cul_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Naraha manaco Jeso Nicodemodsa huati tajari: —Pajissara tiadsa huati onana: Madija bodidenicca imasiri tohuireridsadsapi madija Dio Corimecca nahatonajadsa toquejenadsapa Diocca cacahuehedsa toquejenajari. Naraha madija nama quina-jaradsapa Diocca cacahuehedsa toquejena-jarahi. ");
INSERT INTO cul_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Maqquideje ejedeni inahatojaripa madija tojajari. Naraha Dio Corimejine nahatojaripa Pohua Corime pohuadenidsa totoja najari. Dio Corime pohuadenidsa tojaridsadsapa pina tossonapomajarissa quina tahi −nade. ");
INSERT INTO cul_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","—Nadsama tiadsa huati onana. Ohuattipi: Pina ejedeni tossonedsatissa tiquinapomaji onajarodsapi huajo tejeraji. ");
INSERT INTO cul_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Dio Corimejine madija bodi dsati tojadsapi pina jojodecca imassa najaro. Jojodepi qqui inejeraraha jojode ponijinena ahahuato najaro. Jojodepi poni jipa tanihuaji tocca tani. Poni mohuini naqui imitta tani. “¿Nejecoma nanicca ccajonajaro?” taraha ssamo tinani. “¿Nejecoma nani toccajaro?” ina tani. Dio Corimejine madija bodi nahatodsati tojadsa naco qqui inajararaha pocca madie dsati tojani nahato inajaro −nade Jeso Nicodemodsa. ");
INSERT INTO cul_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Naraha manaco Nicodemo Jesodsa huati tapomajari: —¿Najaro imapi nejecoma najaro? −nade. ");
INSERT INTO cul_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Manaco Jeso pohua cacomerade: —Tiapi Isaraeri potemahi jodiodeni maride tijaraha ¿najaro ima ssamo tinajaroqui? ");
INSERT INTO cul_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pajissara tiadsa huati onana: Iapi Diojine madija bodideni dsati toquejenahi nahatoqquiri inajaro. Aji madijacca madie dsati tojani qqui inajaro naqui tiadenidsa huati huati ihinanaraha timittamana-jerajaro. ");
INSERT INTO cul_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aji namicca icca madieccama tiadeni mari ocanabaqquiraha pajissa tiquinejerani. Aji memehuajicca Diocca ima ponira tiadenidsa huati onadsa naqui pajissa tiquinejerajarorane −nade. ");
INSERT INTO cul_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","—Nadsama aja namicca madija ojariapa memehuaji toccamacossaja cama-jarahi. Naraha aji Madija Bedi ojajarona ohuapi memehuajicca occaronajaro. ");
INSERT INTO cul_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nadsa maittaranibote dsama huamoni ssono caji, siba caji tanihuaji icca madija jahiridsapodsapa Moisesi macca corime bronce inahatodsa ahuadsa que inanahi quinade. Madijapa maccajine jicahitohuiraha macca corime que tahihuaji qqui quinadsapa totocassiejera najari. Nadsama aji Madija Bedi ojajaroa ohua naqui ahuadsa ohua que inanamanadsapi nema onanitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","—Nadsama madija huapima ohuadsa pajissa quinajaridenipa camittehe jiquejeranicca cajimana-dsanapohuijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Diopa madijadsa huati cahanari canahi. Pohua Bedi ojari naraha da inadsapa huapima pohuadsa pajissa quinajaridenipa tocassiejerahijine. Camittehe jiquejeranicca naco cajimana-dsanapohuijine. ");
INSERT INTO cul_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Diopa Pohua Bedi madija dsahuade dosse inarona-jarajari. Madija tonassiajadera dosse inaronajari −nade. ");
INSERT INTO cul_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","—Nadsama pohuadsa pajissa quinajaridenipa idsahuabaqqui-jarahitohui. Naraha aja pohuadsa pajissa quina-jarajaridenicca imapi Dio Pohuadsa ahuato taridsaponi. Naraha Dio Attipa: “Occa ejedeni ohojaride. Pohuadsa pajissa tiquinejeradsapi ticcadeni imapi ohuadsa tabaccora tani. Nidsa ticcadeni ima nema tidsanapomanadsapi najidsohue jiquejeranihuaji tiquejenanitohui” nahi Dio −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","—Nadsama Dio Bedidsa pajissa quina-jarajaridenipa poccadeni tabaccorehepi ajima najaro: Ssiajani aji namidsa bacco naronaraha madija motapa dsidsinidsara jipaqquiri najari. Pohuadenipa ima tabaccora tanicca ihinanamana nadsapi ssiajanidsapa jiperaqquiri najaripaja. ");
INSERT INTO cul_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Madija motapa pohua pohuadeni tonatabaccora-manadsapa ssiajanidsa huattajoqquiri najari. Pohuadenipa ssiajanidsa huajijira canaha najarahi, poccadeni ima huapimadsa ahuato tajaro noppineni. ");
INSERT INTO cul_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Naraha madija pajissehedsa madimanadsapa ssiajanitohuira quinajari. Pina Diocca dossenijissa inanamanadsapi pohuadeni dsepe ijiridsajarima ahuato tanijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nani dsotodepi dsama arobeni Jodeahuaji Jeso toccadsapa pohua huatimadedeni iapi pohuadsa jaijade. Nanidsa imadidsana madija topa idsanabaqquijaride. ");
INSERT INTO cul_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Naraha Huano naco odsa Enohuaji madija topa idsanabaqquija najari. Najaropi odsa Sarimadsa huajira tani. Enodsana passo dsaja tanicca caji tajaro. Nahidsana madija jajahijona najari, Huanocca topanijitohui. ");
INSERT INTO cul_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Huanopa toponi cocorodsa coro idsimamana-jaraccadsama nahidsa madijari. ");
INSERT INTO cul_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nadsapa Huano huatimadedenipa jodio ojaria tedseje bodideni tohuiremanahijinecca ima ahuaji huati ahuaji huati quinajari. ");
INSERT INTO cul_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Nadsapa Huano huatimadedeni jai tojanidsapa Huanodsa huati toquinade: —Ia Maride, maitta hueni Jordao jippehuaji tiadsa bacco tajari pohua tahimari huati huati titinanajaripa madija topade tojahi. Huapima pohuahuaji jajahi toja nahi −quinade. ");
INSERT INTO cul_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Naraha Huano pohuadenidsa huati tade: —Diopa madija dsepe ijihijine pohuadsa da inejeradsapi nama najarahi. Naraha Dio madija dsepe ijihijine pohuadsa da inadsapi dsepe ijie cajihi −nade. ");
INSERT INTO cul_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","—Nadsa ohuatti timittamanade: Ohuapi Cristo-Mesia ojajerani ohonanade. Diopa Jeso tedsejema ohua cadossepojaride. ");
INSERT INTO cul_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ohuapi pina dsabisso amoneje cajibote najari pohua tessessa onajaro. Dsabisso cacajirehijinecca ejete bacco tadsapa pohua tesse naco pohuatohui madijari. Pohua tessepa aja cacajirejari atti mittadsapa huatidse tahi. Najaroa ohua naqui Jesodsa madija toquejenadsa omittadsapi ohuatidseri najaro. ");
INSERT INTO cul_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jeso deni tojajadsanapohui nadsapa bica tani. Ohua ajimani ojanini naqui bica tani, onajaro −nade Huano. ");
INSERT INTO cul_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nadsapa Huano pohua huatimadedenidsa denima huati tajari: —Memehuaji ccaronajaripa aja namihuajicca madijassa najarahi. Pohuapa deni tojahi. Ajijaro namiccapa namicca. Ajijaro namicca imara huati huati totoquina najari. Memehuaji ccaronajaripa huapimadsa deni tojajari. ");
INSERT INTO cul_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pohuapa memehuajicca qqui tajari, mittajari naqui ecomeraridsajaro. Naraha madija huapimapa pocca huatinajadsa pajissaha quina-jarahi. ");
INSERT INTO cul_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Naraha pohua attidsa pajissa quinajarina: “Jehe, Diopa pajissehe jinede” quinajari. ");
INSERT INTO cul_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pohuana Dio icadossejari, huati huati nanaridsa najari. Najarina Dio Atti huati tahissa tajari. Dio Pohua Corime pohuadsa da ineje najaro inapajiranissa tajaro. ");
INSERT INTO cul_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Imehipa Bedidsa huati huana tajari. Pohua Bedidsa pocca nahatonaja huapima pohuadsa inanajaro. ");
INSERT INTO cul_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nadsapa Pohua Bedidsa pajissa quinajaridenina camittehe jiquejeranicca cajimana-dsanapohuijine. Naraha pohuadsa iboqquiri najaridenipa camittehe cajimana-jarahitohui. Dio Pohuana najidsohue jiquejeraniccadsa inanabaqquihitohui −nahi nade Huano Baotista. ");
INSERT INTO cul_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nadsapa Jesodsa madija tohuapijaricca ima tojaridsajaro. Nadsapi jodiodeni mota marinaja onini pariseodsa jehe quinajaridenidsa ima bacco tajaro: —Jesodsa toquejenajarideni tohuapihi. Huano Baotistadsa ajamani. Jesona madija denima topa topa ihidsanabaqqui najari −nanaridsamana nahi ima mittamanajari. ");
INSERT INTO cul_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Naraha Jeso pohuapa madija topa topa ihidsanabaqqui najarahi. Pohua huatimadedenina madija topa topa ihidsanabaqqui najari.) ");
INSERT INTO cul_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nadsapa Jesodsa: —Marinaja pariseodsa jehe quinajarideni titahimari mittamanahi −quinadsapa dsama arobeni Jodeadsa joppemajari, dsama arobeni Carireahuaji toccanipomahijine. ");
INSERT INTO cul_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jodeadsa jaijanijaro jahuipi dsama arobeni Samariahuaji tossoniqquimani Carirea bacco tanijaro. ");
INSERT INTO cul_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Najaro jahui jaijanidsapi Samariacca odsa panani oninipi Sicadsa iajirajonajaro. Najaro odsapi maittaccadsama Jacobocca dsamabote huajira tajaro. Jacobo pohua dsamaribotepi pohua bedi Josedsa da inapojaro nade. ");
INSERT INTO cul_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nanidsana —Jacobocca passojinebote −quiquinanajari hui todsajaro. Najaro passojine hui todsanidsa bacco inapojaro. Maji itetepi bacco tabote nadsa Jeso ja tojajonadsa, passojine hui todsani inorinidsa huittarijaride. ");
INSERT INTO cul_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Nahidsa Jeso huittariraha ia pohua huatimadedenipi odsa pananihuaji jaijajaro, itapari mittade. Naraha nahi passojine inorinidsa Jeso huittaridsa Samariacca madija amoneje passotohui ccajonajaro nade. Nadsapa Jeso ponidsa huati tajari: —Ohuadsa ticca passo dse onana −nahi nade. ");
INSERT INTO cul_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jeso atti nama nadsapa ponidsa jidsa tajarossa najaro. Aja, jodiodenipa samaritanodeni dsepedenitajidsapa: —Dsede oppina tani −quiquinanade. Nadsapi amoneje Jesodsa huati tajaro: —¿Nejecotohui tiapi jodiodeni tijaraha ohuadsara passo mitta tajaro? Ohuapi Samariacca madija ojani −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Naraha manaco Jeso ponidsa huati tajari: —Diocca daniji nahato tinadsapi aja tiadsa passo mitta todsajaridsa manacora ohuadsa passo mitta tidsanitohuiraha ssamo tinajaro. Naraha ohuadsa nahato tinadsa ohuadsa huati tinadsapi passo camittehecca tiadsa da onanitohuiraha −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Naraha amoneje poni attinipi: —¿Nejecodsara passo huana ticadsananijine? Hui todsanicca passopi huaji tani. ¿Nejecohuajicca passo camittehecca ohuadsa da ticananijine? −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","—Ajijaro passojine hui todsanipi maittaccadsama Jacobo iadsa inebojaro. Ajijaro passopi Jacobo dse dse napojari. Pohua bedideni naco ajijaro passodsa dse dse quinapojari. Poccadeni bani ette tojahi naco ajijaro passodsa dse dse quinapojari. ¿Naraha tiana deni tijajarorane, Jacobona ajamanirana? −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Naraha manaco Jeso ponidsa huati tajari: —Ajijaro passopi dse inaraha ibacco dsaripoma tani −nahi nade. ");
INSERT INTO cul_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—Nadsa aji ohua passo da ocanajaro dse quinahipa baccodeni dsarimanapoma-jarahitohui. Aji occa daniji passona madija bodidenidsa jiquejeranitohui. Camittehe jiquejeranicca tojanijine −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Naraha amoneje attinipi: —Jari aji ohuadsa huati tinajaro passo ohuadsa da ticanaji, obacco dsaripoma-jeranijine. Nani ajijaro passotohui ohoccajona nejeranijine −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Naraha Jeso ponidsa huati tapomajari: —Ticcanidsa ticca maqquidsa huati tinanidsa ahuaji ccajonana −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naraha poni attinipi: —Maqquideje ocappirani −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Naraha Jeso ponidsa huati tapomajari: —Jehe “Maqquideje ocappirani” tadsapi pajissa. Naraha ticca maqquipa 5 quinahi. Jidapanacca naco ticca maqqui jarahi. Tetti nema nadsapi pajissa −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Naneje amoneje attinipi: —Tiapi Dio Atti cacomerabote tijani −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Icca abidenipa ajijaro ssonodsana Diodsa huahuatidsemanapo najari. Nadsa jodio tiadeni tettidenipi: “Jerosaredsana Diodsa tetetidsemana nani bica tani” tiquinajaro −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Naraha manaco Jeso amonejedsa huati tajari: —Amoneje, ohuatti timittaji. Nidsa imapi cacajiqquimeranitohui. Aji ssonohuaji Diodsa tetetidsemana najaropi nebonitohui. Aja Jerosarehuaji Diodsa huahuatidsemana nahihuaji naqui nebonitohui −nahi nade. ");
INSERT INTO cul_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","—Samaritano tiadenipi Diodsa tetetidsemana naraha, najaro imapi ssamoqquiri tiquinani. Naraha jodiodeni iana pajissa Diodsa ehetidse najaro. Ia jodiodenidsa tossiejehe ccajonapojarona madija huapimadsa tojaribaqquijaro. ");
INSERT INTO cul_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jidapapi ima dsati bacco tani. Madija pajissa Abidsa huatidsemanaha madimanajaridenipa pohuadeni bodicca pajissehema Dio Pohuadsa jehe quinadsapa huatidsemanahitohui. Abipa madija nama quinajaridenidsapa jipa tahi. ");
INSERT INTO cul_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Diopa assire jarahi, corime. Nadsama madija Dio Pohuadsa huatidsemanajaripa pohuadeni corimema huatidsemanahina bica tani. Maidsamana-jaradsa huatidsemanahina bica tani onajaro −nahi nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Naraha amoneje attinipi: —Jehe, ohuapi nahato onani: Mesia pohua oni ohuahapa Cristo quinajari. “Najari ccajonahitohui” quinahipa ohomitta nade. Nidsa pohua bacco nadsapa pocca marinaja huapima iadsa ahuato inananitohui −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nadsapa Jeso ponidsa huati tade: —Ohuapi Mesia tiadsa huati huati onajaro −nahi nade. ");
INSERT INTO cul_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Naraha pohua huatimadedeni iapi Jeso pohua huittarihidsa bacco inanineje Jesopa amonejedsa huati huati tahi qqui inadsapi ijabojo nade. Ibodidsa: —¿Nejecotohuira ponidsa huati huati tajari? −inade. Jeso pohuadsa naqui: —¿Nejeco imara poni tadsajani huahuatiti tinajaroneje? −inanitohuiraha huati inejerade. ");
INSERT INTO cul_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nadsapi amoneje ponicca jojori inebo, odsa pananihuaji toccanide. Odsa panani bacco tanidsapi madija huapimadsa huati tanijaro: ");
INSERT INTO cul_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jari, aja maqquideje nahatobote occa ima huapima ohuadsa huati huati tajari qqui tiquinajo. Pohuapa aja tohui imadijaro ia Idinide Cristo-Mesia itidija −nani nade. ");
INSERT INTO cul_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nadsapa najaro odsa pananicca madija mota jahininedsa Jesohuaji jahijonajari. ");
INSERT INTO cul_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Amoneje odsa pananihuaji huati huati teje naraha iassa Jesodsa: —Ia Maride, tijipaji −inade. ");
INSERT INTO cul_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Naraha Jesopa: —Jijipa ohuaha ocajini −nade iadsa. ");
INSERT INTO cul_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nadsapi iara imahaha icanadsa: —¿Madija ohuaha pohuadsa jijipa dsojo inajonajari itide? −inade. ");
INSERT INTO cul_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nadsapa Jeso iadsa huati huati tajari: —Ohuapi Dio ohua cadossejari. Pohua jipa tahicca odsepe ijijaro. Najaropi pina occa jijipassa najaro. Dio Pohua dsepe ihiji nahicca najaro onajicanijine, onajaro. Najaropi occa jijipa −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Naraha tettidenipi ajima tiquinani: “Abadsico 4 canadsana huidsajacca ppa nahi bono jadahi pore nahi bica tahi” tiquinaraha ohuattipi: ¡Ajana qqui tiquinanaja! Aja huidsajacca ppa nahipa jadabote tojahi. Pore nahi bica tahi −nade. —Madija Dio Atti mittamanahijinepa najoramanahi. Pina huidsajacca ppa nahi jadajarissa quinahi. ");
INSERT INTO cul_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Madija huidsajacca ppa nahi bono porede dsepedeni ihijimana najaripa ima bicani cacajimana najari. Pohuadenijinena madija camittehe jiquejeranicca cacajimana najari. Nadsapa huidsaja ppadedeni, bono porededeni tedsejepa huatidsemana tahi. ");
INSERT INTO cul_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nadsama ajijaro imapi pajissa: Huidsaja ppadedenipa ohuaha, huidsajacca bono jadadsa porededenipa ohuaha quinajari. ");
INSERT INTO cul_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nadsama ohuapi huidsajacca bono jadahi porede tiadeni dosse onabaqquina. Aja ticcadeni ppaniji jarahi. Najaridsapa madija ohuahadenina dsepedeni ijimanapojari. Naraha tidsepedeni ijimanajarocca huapimapi tassaqquijaro. Aja dsepedeni ijimanapojaricca naqui tiadenidsa ima bicani tojani −nade Jeso iadsa. ");
INSERT INTO cul_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nadsapi amoneje Samariacca odsa panani Sicahuaji Jesocca ima huati huati tadsa madija mota huapi taha Jesodsa pajissa quinajari. Aji amoneje poni attinipi: —Aja otahimari huapima nahato tajari, ohuadsa huati huati tapa −najaro mittamanadsapa pajissa quinajari. ");
INSERT INTO cul_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nadsapa Samariacca madijadeni iahuaji bacco najonamanadsapa Jesodsa huati toquinade: —Iadsa timadiccaji −quinade. Nadsapi nanidsa icca huada pamaccanijine imadiccade. ");
INSERT INTO cul_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jeso nahidsa ibodsapa madija denima Jeso atti mittamanadsapa pohuadsa pajissa quinade. ");
INSERT INTO cul_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nadsapa amonejedsa huati toquinade: —Tahidepi tettidsaha “Jesopa Cristo-Mesia” inapojaro. Naraha jidapapi Jeso pocca marinaja imittadsapi pohuadsa pajissa inajaro. Tettidsaha imittani ojari-jerani. Jidapapi pocca marinaja imittadsapi nahatoqquiri inani: “Pohuapa dsama huapimacca madija Tonassiajade” inajaro −quinade. ");
INSERT INTO cul_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nadsapi dsama arobeni Samariadsa icca huada pama nadsapi Jeso pohuadsa jaijanide dsama arobeni Carireahuaji. ");
INSERT INTO cul_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Nahidsana Jeso Dio Atti cacomeraqquiri najarideni tahimarideni huati tajaride: —Poccadeni madijapa pohuadenidsa: “Deni tijani” quina-jaraha nama najonamanajari −najaride Jeso. ");
INSERT INTO cul_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nadsapa Carireahuaji bacco nanidsapa icatidsemaneri nade. Aja odsa panani Jerosarehuaji madimanapodsapa ejete Pascoadsa pohua canahatori canahi qqui toquinapoja najari. ");
INSERT INTO cul_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Carireacca odsa panani Canahuaji ejetedsa Jeso pohuajine passoraha uva ppejene ihinana nanihuaji jaijanipomajaro. Naraha tamine biji accode bedipa odsa onihi Capernaohuaji coma tajari. ");
INSERT INTO cul_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Naraha tamine biji accodepa: —Jeso dsama arobeni Jodeahuaji ccanidsa Carireadsa bacco nanihi −quinahi ima mittadsapa Canahuaji ccajonajari Jesodsa. Bacco najonadsapa Jeso pohuadsa huati tade: —Occa odsahuaji ohuadsa ticcaccaji, occa ejedeni dsoqquebote nahi tinanomihijine −nade. ");
INSERT INTO cul_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Naraha Jeso attipa: —Tiadenipi ocanahatori canani qqui tiquinejeradsapi ohuadsa pajissa tiquinejerani. Qqui qqui tiquinapo-jerajarocca ahuato onana-jeradsa naqui ohuadsa jehe tiquinejerani −nade. ");
INSERT INTO cul_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Naraha tamine biji accodepa: —Ohua Medsede, occa ejedeni dsoqque-jaradsama ticcaccaji −nade. ");
INSERT INTO cul_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nadsapa Jeso pohuadsa huati tade: —Ticcaniji, ticca ejedenipa dsoqque-jarahi, tonomihi −nade. Nadsapa Jeso pohua attidsa pajissa nadsapa toccanide. ");
INSERT INTO cul_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nadsapa toccanijari, huada ssiaja pocca odsa bacco tanibote naraha pocca medsedeni bacco ijidsabaqquijari. Nadsapa huati toquinajari: —¡Ticca ejedenipa tonomidija! Madihi −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Maji nejecodsa occa ejedenipa tonomijaritta? −nahi nade. —Maittadsama maji itetepidsa huapi ppocone totappajaridija −quinahi nade. ");
INSERT INTO cul_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nadsapa imehi bodi huatojari: —Maittadsama maji itetepidsa Jeso huati tajaride: “Ticca ejedenipa tonomihi” najaride −nahi nade. Nadsapa tamine biji accode pocca odsacca huapima naco Jesodsa pajissa quinajari nade. ");
INSERT INTO cul_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ajijaro imapi Jeso Jodeahuaji ccanidsa Carireadsa bacco nanidsapa nahi Carireadsa canahatori canapomajari. ");
INSERT INTO cul_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jodiodenicca ejete bacco tapomadsapi Jeso Jerosarehuaji toccanipomajaride. ");
INSERT INTO cul_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nani Jerosarehuajipi edede ihieqquedsimamana nahicca noccobiji huajira tanidsa siba ppajani tohuittidsanani dsaja tajaro. Najaro passo onini jodiodeni atti ebreodsapi: Besata, quiquinanajari. Nani passo inorinidsapi madija comaqquiri najaridenicca odsa 5 canehe cacahitteri najarode. ");
INSERT INTO cul_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Najaro odsadsapa madija comaqquiri najarideni domo podsaridsa, noccodeni siri domo podsaridsa, issodeni siri domo podsaridsa, idedeni tone biqueradsa issodeni ssomi toquejenajarideni domo podsaridsa najaride. Pohuadenipa: —Passo ccomororo canadsa opodsippadsa onominijine −quiquinanajari.  ");
INSERT INTO cul_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aji passo ccomororo cacana najaropi Diocca dodosse memehuajiccajine huajiji tadsa ccomororo cacana najaro, quiquinanajari. Passo ccomororo canadsa madija tahide toqquedsippapodsa podsippajarina totonomimana najari, quiquinanajari nade.  ");
INSERT INTO cul_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Naraha nahicca comaqquiri najarideni ojariapa huajano 38 naha coma tajari. ");
INSERT INTO cul_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Najarina ponahi Jeso qqui inadsa nahidsa coma taha maitta madirahi ima mittadsapa pohuadsa huati tajaride: —¿Tinominijine jipa tinaqui? −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Naraha pohua cacomerade: —Jehe, jipa onaraha passo ccomororo canadsa ohua napodsippade ocappiradsa ajidsa onominijine ssamo tani −nade. —Passohuaji ccobo odsipparaha mijira onadsapi madija ohuahadenina tahide bacco bacco totodsippamanapo najari −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nadsapa Jeso aja coma tajaridsa huati tade: —¡Titehemaji! Titaboro tididsa ticcaniji −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Nanaja amadsati tonomidsapa totehema, pohua taboro idi toccani-ni naraha najaro huadapi sabado tojajarojine pohua taboro dsojode oppina tani, quiquinanajari. ");
INSERT INTO cul_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nadsapa jodiodenipa pohuadsa: —A, jidapapi icca jassinajacca huada sabadoraha titaboro dsojo taridsani. Najaro imapi bica tejerani −quinade. ");
INSERT INTO cul_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Naraha tonomijaripa pohua cacomerade: —Ohua tonanomide attipa: “Titaboro tididsa ticcaniji” nadsapa −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Naraha: —¿Nejecojarina tiadsa: “Titaboro tididsa ticcaniji” najarinaja? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Naraha tonomijaripa pohua tonanomide oni ssamo tajari: —¿Nejecojarinaja? −nade. Aja Jeso madija inanomihidsapa madija huapi taja najari. Nahi pohuadenidsa quejemadsapa amossi najari. ");
INSERT INTO cul_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Dsotodena Jeso pohua inanomijaripa Diodsa dada toqquimahuaji bacco inajari. Nahidsana pohuadsa huati tajaride: —Jidapapi tinomidsama imasiri tinanapoma-jerana. Imasiri tinanapomadsapi denima ocasserehe tiadsa ssonarinitohui −najaride Jeso pohua inanomijaridsa. ");
INSERT INTO cul_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nadsapa tonomijari jodiodenidsa huatide toccajari: —Jesona ohua tonanomijari −nahi nade. ");
INSERT INTO cul_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Naraha pohua atti nama nadsapa jodiodeni Jeso jara quinajari, inanadsoqque-manahijine. Sabado huajijiradsa madija ihinanomibaqqui nadsapa pohuadsa huadimanajaride. ");
INSERT INTO cul_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Naraha nidsa dsotodena Jesopa pohuadenidsa huati tade: —Occa Abipa dsepe ijihipaja nadsapa ohua naqui nema onajaro −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jeso atti nama nahi mittamanadsapa jodiodeni paja icahadimanarihi nade. Attidenipa: —Sabadopi oppina tani inajarodsa ibora tajaradsapa madija inanomihi −quinajari. Jeso pohua atti onihi naqui: —Diopa occa Abi −nahi mittamanadsapa pohuadenidsa pina Diossa nahi quinadsa Jeso dsoqquehijine tohui inacomamanajari. ");
INSERT INTO cul_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Naraha Jesopa jodiodenidsa pohua tahimari ecomerade: —Pajissara tiadenidsa huati onajaro: Dio Bedipa pohua ehuerahipa nahatora tahi. Naraha pocca Abicca nahatohue qqui tadsana pohua naco nema inanajaro. Pina Imehicca nahatohuessa najaro ihinahato najaro Bedi naco −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","—Imehi pohua Bedidsa huati huana tadsapa pohuadsa pocca nahatohue nohue inajaro. Najaro nahatohue Abijinepi denima denima dsanaponitohui. Najaro qqui tiquinadsapi huajo ticanirenitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","—Abi inahatonibaqquijaripa camittehe pohuadenidsa da da ihinaridsa najaro. Najarossa najaro pocca Ejedeni naco pohua jipa tajaridsa pocca camittehe da da ihinaridsa najaro. ");
INSERT INTO cul_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Abipa Pohua Bedidsa dacorehe da inadsapi Pohua Bedi icadossejari: “Tiana madija poccadeni imasiri manaconi pohuadenidsa tinassonariji” najari. Nadsapa Abi Diopa madija poccadeni imasiri manaconi pohuadenidsa inassonari-jeranitohui. Pohua Bedina pohuadenidsa inassonarinitohui. ");
INSERT INTO cul_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nadsana dsama huapimacca madijapa Dio Bedidsa: “A, nahato tahi” quinahijine. Pina Imehidsa: “A, nahato tahi” quinajarissa quinahijine. Naraha Pohua Bedidsa: “Nahato tahi” quina-jaradsapa pocca Abi pohua Cadossededsa naco: “Nahato tahi” quina-jarajarissa najari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Pajissara tiadenidsa huati onana: Ohuatti mittamanajaridenipa aja ohua Cadossede Abi Diodsa pajissa quinadsa naco camittehe jiquejeranicca cajimana-dsanapohuitohui. Poccadeni imasiri manaconipi pohuadenidsa ssonari-jeranitohui. Tahide Diodsa ssamoqquiri nadsapa pina dsoqquemanajarissa quinaraha najaro inebomanadsa camittehe jiquejeraniccadsa toquejenajari −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—Pajissara tiadenidsa huati onana: Jidapapi ima bacco nabote nani: Diodsa ssamoqquiri najarideni naco Dio Bedi ohuatti mittamanahitohui. Ohuattidsa iboraqquiri nadsapa camittehe jiquejeranicca cajimanahitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","—Abi Diopa camittehe jinede. Ohuapi Pohua Bedi ohuadsa naqui camittehe da inajaro. ");
INSERT INTO cul_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Occa Abijine ohuatti ocajijaropi nidsa dsama jicadsa madijadenicca imasiri manaconi pohuadenidsa onassonarinitohui. Ohuapi Madija Bedi ojajarode. ");
INSERT INTO cul_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ajijaro ima timittamanadsapi huajo ticanire-jeraji. Nidsa aja jicapojarideni ohuatti mittamanadsapa nahatonimanahitohui. ");
INSERT INTO cul_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nadsapa bicani inanamanehe jicajarideni nahatonimanadsapa camittehe jiquejeraniccadsa toquejenahitohui. Naraha imasiri inanamanehe jicajarideni nahatonimanadsapa poccadeni imasiri manaconi idsahua-baqquidsapa najidsohue jiquejeraniccadsa madimana-dsanapohuitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesopa jodiodenidsa huati huati dsanapojaride: —Nadsama ohua mottapi madija poccadeni imasiri manaconipi pohuadenidsa onassonari-jerajaro. Abi Dio Pohua Atti omittadsana imarideni ohocattema najaro. Ohuapi ohua motta ohua tohuini onanicca onana-jerajaro. Naraha aja ohua Cadossede Pohua Attissa onanadsana imarideni ocattemadsa onapajiranissa tajaropaji. ");
INSERT INTO cul_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ohuapi Dio Bedi ojani” onajaro ohua motta huati huati onadsapi tiadenipi ohuadsa: “Pohua motta pohua atti iadsa ehecomera najaro pajissa jerani” titiquina najaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","—Naraha otahimari cacomeradepa ohuaha madihi. Najaripa Huano. Pohuapa otahimari pajissara huati huati tajari nahato onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","—Nadsama Huanocca imatohui dosse tinabaqquimanapodsa naco otahimari ecomerajaro. Pohuapa pajissacca imara huati huati tajari −nade pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","—Naraha madija otahimari cacomerade nohueradsa naqui epeje. Ohuapi Dio Bedi ojani otahimari ima onihidsa naqui ahuato tajaro. Aji otahimari Huano ecomerapojarocca tiadenidsa huati huati onajaropi tossiejehe ticajimananijine. Huanocca huatinajadsa pajissa tiquinapodsapi ohuadsa naqui pajissa tiquinanijineraha. ");
INSERT INTO cul_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Huanopa pina jojororo toquehessidsa jororo canapojarissa najari. Pohua jororonepa aja pocca huatinaja tiadenidsa bica tade. Pohuadsa tetetidsemana naraha amossi nadsapa epeje tiquinade. ");
INSERT INTO cul_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nadsama Huanocca huatinajapi ajimani. Occa nahatohuena deni tojajaro. Occa nahatohuepi occa Abicca dosseniji. Najaro nahatohuejinena ima ahuato tajaro: Pajissa occa Abi ohua cadossejari. ");
INSERT INTO cul_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Nadsama Abi ohua cadossejarijinena occa ima ahuato tani qqui tiquinajaropaji. Naraha Pohua Atti mohuini timittamana-jerani. Pohua assire naco qqui tiquina-jarahi. ");
INSERT INTO cul_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pohua Atti naqui tibodidenidsa madidsa-jerani, Abi Dio icadossejaridsa pajissa tiquinejerajarojine. ");
INSERT INTO cul_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nadsama tiadenipi Dio Atti dsodo nani timittamananissa tanijine hua hua titiquina nani. Tettidenipi: “Dio Atti dsodo nanidsa camittehe jiquejeranicca bacco inanijine” titiquina najaropi nani Dio Atti dsodo nanidsa otahimari anini. ");
INSERT INTO cul_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Naraha tiadenipi ohuadsa pajissa tiquinejerajaro. Pajissa tiquinadsapi camittehe jiquejeranicca ticajimana-dsanaponitohuiraha −nade. ");
INSERT INTO cul_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","—Madija attidenipa: “Tiapi deni tijani. Bica tinani” quinahijine occajona-jerajaro. ");
INSERT INTO cul_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ohuapi tibodideni nahato onani: Diocca tohuati huanehepi tiadenidsa nohuerani. ");
INSERT INTO cul_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ohuapi occa Abi onima pocca dosseniji occajonajarode. Naraha tiadenipi ohuadsa: “Iadsa tijaji” tiquinejerani. Naraha madija ohuaha pohua pocca imadsa ccajonajaridsapa: “Iadsa tijaji” tiquinanitohui. ");
INSERT INTO cul_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Naraha ¿nejecoma tiquinadsa ohuadsa pajissa tiquinanijine? Tiadenipi aja titessedeni tiadenidsa: “Tijine ima bica tani” quinahitohuina tiquinajaro. Naraha Diona ojarihi. Pohua Attipa tiadenidsa: “Tijine ima bica tani” nahijine tohuinipi tibodideni huatoma-jerani. ");
INSERT INTO cul_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tibodidenipi ajima najaro: “Dsama jicadsa Cristo-Mesia iadsa ima inassonarinijine Abi Diodsa huati tahitohui” tiquinaraha aja tiadenidsa ima inassonarinijinepi Moisesina paja. Tibodidenipi: “Moisesicca marinaja ecahuanissa tadsapi icassiejeranitohui” tiquinaraha tecahuamananijinepi tipajiramana-jerani. ");
INSERT INTO cul_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nadsama Moisesipa otahimari dsodo inapojaro. Moisesidsa jehe tiquinadsapi ohuadsa naqui jehe tiquinanijineraha. ");
INSERT INTO cul_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Naraha Moisesicca dsodonijidsa pajissa tiquinejeradsapi ¿nejecoma nadsa ohuattidsa pajissa tiquinanijine? −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nani dsotodepi dsama arobeni Carireacca coridsa onini onihipi Tiberiacca coridsa quiquinanajari jippehuaji Jeso pohuadsa jaijajarode. ");
INSERT INTO cul_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Madija huapima naco Jesotohui inatti jajahimissa najaride. Pocca nahatohuedsa comaqquiri najarideni tonomiridsamanahi qqui toquinapoja najarijine Jeso pohuatohui quinajari. ");
INSERT INTO cul_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nadsapa Jeso ssonohuaji toqquemoradsa pohua huatimadedeni ia naqui pohuadsa jaijemorade. Nanidsa jassi inadsapi Jeso naco iadsama huittajaride. ");
INSERT INTO cul_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ajijaro ima tojajaropi jodiodenicca ejete onini Pascoa bacco tabote nadsade. ");
INSERT INTO cul_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nanidsa jassi inadsana madija bacco namissamanahi Jeso qqui inabaqquijaride. Nadsapa Jeso pohua huatimade Feripedsa huati tade: —¿Nejecohuaji madija huapima jipamanahijine taparideni mitta inapadsaja? −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesopa madija inajipabaqquihijine nahato taporaha ecomadsa: —¿Feripe atti nejecoma nahi? −nadsa huati tajari. ");
INSERT INTO cul_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Naraha Feripe attipa: —Dsiniro huemani pina 200 denariodsa madija taparideni mitta inadsapa badsira badsira taridsaraha motadenipa dsori tocanirehitohui −nade. ");
INSERT INTO cul_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Naraha Jeso huatimade ojaria onipa Adiri, pohuapa Ssino-Pedro ohuaha najarina dsabisso pan cajihi qqui tadsapa Jesodsa huati tajaride: ");
INSERT INTO cul_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ajajari dsabissona pan 5, aba pama naha cajiraha madija huapima jipamanahijine pajira-jarahi. Madijapa huapi tahi −nade. ");
INSERT INTO cul_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nadsapa Jeso iadsa huati tade: —Madija jassi taridsahijine huati tinabaqquimanajo −nade. Nadsapa huati inabaqquidsa nahi dsero bica tanidsa jassi taridsade. Maqquideje pohuarapa 5 mil quinajaride. ");
INSERT INTO cul_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Nadsapa Jeso pan inaccadsa Diodsa huati tajari: —Jehe, epejeni. Ticca daniji iadsa bica tahi −najari. Nadsapa Jeso canahatori canajarijine pan tohuapidsapa madija jassi jassi teri najaridenidsa da inabaqquiridsade. Aba naco najarissa inanajari. Nadsapa huapimadsa inapajirabaqquihissa tade. ");
INSERT INTO cul_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Madija huapima jipamanaha accaramanadsapa Jeso iadsa huati tade: —Mota tojadsapa tinaccaniridsa-manajo. Mota tinebomana tajarajo −nade. ");
INSERT INTO cul_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nadsapa pan 5 najari jipamanajari ajarideni mota inaccaniridsadsapa quiqui 12 naha ijiridsade. ");
INSERT INTO cul_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nadsapa Jeso canahatori canahi qqui toquinadsapa imahaha canade: —Pajissa ajajaripa Dio Atti cacomerabote. Maittaccadsama ima imittapojaropi: “Ajijaro dsamadsa bacco nahitohui” quiquinanapode −quinade huapima. ");
INSERT INTO cul_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nadsapa madija attideni: —Jari, Jeso dama inadsa icca tamine tojahijine iaccanina −quinaraha Jeso pohuadsa nama quinahijine nahato tapodsapa madija inebobaqquipomadsa pohua motta madihijine ssonohuaji denima toqquemorade. ");
INSERT INTO cul_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nadsapi maji amossi nabote nadsa Jeso huatimade iapi coridsahuaji jaijedsippajarode. ");
INSERT INTO cul_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesotohui imadidsapi dsomebote tojaraha Jeso qquedsippa-jaradsapa canoadsa jaijedsadsa coridsa jippehuajicca odsa panani Capernaohuaji iaccade. ");
INSERT INTO cul_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nadsapi coridsa nocconi iaccaraha jojode jo jo nadsapi coridsa ssoda ssoda nade. ");
INSERT INTO cul_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nani coridsa nocconi iaccanaja inattihuaji passo tetepi Jeso ccajonahi qqui inadsapi icappina nade. ");
INSERT INTO cul_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Naraha pohua cacomerade: —¡Ticappinamana tejeraji, ohuapi ohua! −najonade. ");
INSERT INTO cul_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nadsapi etidsedsa pohuadsa: —Canoadsa tiqquedsaji −inade. Nadsapi amadsati Capernaohuaji bacco inade. ");
INSERT INTO cul_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Najaro ssiajadsa madija mota aja coridsa jippehuaji ibomanajarideni huatideni huatomadsa: —Jeso huatimadedenipa canoa cajarie caponajarodsa jai tojaraha Jesopa pohuadenidsa tocca najarade −quinajari. ");
INSERT INTO cul_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Nadsapa nahidsa Jesotohui, pohua huatimadedenitohui qqui naridsamanaraha bacco inabaqquimana-jaradsapa: —Jina, jippehuaji jaijana −quinanaja odsa panani Tiberiahuajicca canoa onihi bacco bacco canajona-manajaro quinade. Nahi Jeso pohua Diodsa huati tadsa: —Jehe, epejeni. Ticca daniji iadsa bica tahi −napodsa pan da da ihinabaqqui nahi huajira tanihuaji huana huana canajona-manajaro. Nadsapa nahidsa ibomanajarideni najaro canoa onihidsa onihidsa jai tojedsaridsadsapa Capernaohuaji jahimissajaride Jesotohui. ");
INSERT INTO cul_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jesotohui dsotode jahimissajarideni canoa onihidsa bacco bacco namissamanade. Nadsapa Jesodsa huati toquinade: —Ia Maride ¿nejecoma nadsa ahuaji bacco tajonajarotte? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Naraha Jeso pohuadenidsa huati tade: —Jehe, pajissara tiadenidsa huati onana: Ohuapi tiadeni onajipabaqquidsa teccaramanajarojine otohui tiquinajaro. Naraha occa marinaja, ocanahatori canani timittamananissa tejeradsapi najaro occa marinajatohui ohua qquidso tajonamana-jerani −nade Jeso pohuadenidsa. ");
INSERT INTO cul_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","—Naraha tiadenipi ticcadeni jijipa jicaca tahicca tohuira tibodideni huato-jeraji, onajaro. Jijipa jicaquera tahicca tohuira tibodideni huatomanaji −nade. —Ohuapi Madija Bedi ojajaroa jijipa jicaquera tahiccara tiadenidsa da onaridsahijine, onajaro. Nadsama najaro cacahuehepi occa Abi Dio ohuadsa da inadsa occajonajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Naraha manaco pohuadsa huati toquinade: —Dio jipa tahicca inananijinepi ¿nejecoma inanijine? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Naraha Jeso pohuadenidsa huati tapomade: —Diopa ajima tiquinadsana jipa tajari. Aji ohua Diocca dossenijidsa pajissa tiquinadsana Dio jipa tahi −nade. ");
INSERT INTO cul_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Naraha manaco pohuadsa huati toquinapomade: —¿Nejecora inoccodsa ticanahatori canani qqui inadsa tiadsa pajissa inanijine? ¿Nejecora tinahatohuijine tipajirani? Qqui inana −quinade. ");
INSERT INTO cul_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","—Jari, pina maittaccadsama icca idideni dsama huamonihuaji Moisesidsa jahiridsadsapa jijipa oni mana jijipamana nahi quinade. Najaro ima Dio Atti dsodo nanidsapi ajima najaro: “Pohuadenidsa memehuajicca pan da inadsapa jijipamana najari” quiquinanade −quinade Jesodsa. ");
INSERT INTO cul_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Naraha Jeso pohuadenidsa huati tapomade: —Pajissara tiadenidsa huati onana: Najari pan memehuajiccapa Moisesicca daniji jarahi. Abi Diona pohuadenidsa da da nanaja najari. Naraha jidapanaccapa memehuajicca pan pajissacca occa Abi Dio tiadenidsa da inajari. ");
INSERT INTO cul_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Najaripa Diocca daniji memecca ccaronajari, dsama huapimadsa camittehe jiquejeranicca da inaridsanijine −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Naraha pohuadeni attipa: —Jari, Mamaride, najari pan iadsa da da tidsanapojo −quinade. ");
INSERT INTO cul_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Naraha Jeso pohuadenidsa huati tade: —Aji ohuapajia pan timadimana-dsanaponijinepi. Ohuadsa pajissa quinajaridenipa pemimana-jarahitohui, baccodeni naco dsarimana-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nadsa tahide tiadenidsa huati huati onapode. Ohua qqui tiquinaraha ohuadsa pajissa tiquinejerani, onapode. ");
INSERT INTO cul_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Naraha ohuapi occa Abicca daniji ohuadsa jahijonajarideni huapimapa ohuattajobaqqui-jarahitohui. ");
INSERT INTO cul_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aji ohua memehuaji occaronajaropi ohua ohua motta tohuini onanicca onananijine jerani. Occa Abi ohua cadossejari. Pohua jipa tahicca tohuini onadsa odsepe ijiridsajaro. ");
INSERT INTO cul_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ohua cadossejari pohua jipa tahiccapi ajima najaro: Abi Dio ohuadsa madija inanabaqquijaripa ohuacahuabaqquihissa tadsapa amossi naja cama-jarahitohui. Nidsa huada jicarinicca bacco tadsapi huapima onahatoni-baqquihitohui. ");
INSERT INTO cul_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nadsama occa Abi Pohua jipa tahicca onihipi ajima najaro: Madija huapima Dio Bedi qqui toquinadsa pohuadsa pajissa quinadsapa camittehe jiquejeranicca cajimanahitohui. Nidsa huada jicarinicca bacco tadsapi najarideni huapima onahatoni-baqquihitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","42","Nadsapa jodiodeni Jeso atti: —Ohuapi pan memehuajicca occaronajaro −nahi mittamanadsapa pohuama attitti cosseri nade: —Ajajari Jesopa Dsodse bediraha “Ohuapi memehuaji occaronajaro” naha. ¿Pocca abi amidenidsa inocco jidsaqquiri najaroqui? ¡Nahatoqquiri inani! −quinade. ");
INSERT INTO cul_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Naraha Jesopa pohuadenidsa huati tade: —¡Ponima attitti ticossajaropi tinebomanaji! ");
INSERT INTO cul_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Occa Abi Dio ohua Cadossedepa madija ohuadsa inanabaqqui-jaradsapa ohuadsa toquejena-jarahi. Naraha occa Abi ohuadsa inanabaqquijaridenina ohuadsa totoquejena najari. Najaridenipa nidsa huada jicariniccadsa onahatoni-baqquihitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Dio Atti cacomeraqquiri najarideni dsodo quinapojarodsa naqui ajima nani: “Diona madija huapima mari icanabaqquihitohui” quinapohui nade. Najaroa aja madija huapima Abi Dio Atti mittamanadsa tocahatterajaridenina ohuadsa totoquejena nahitohui. ");
INSERT INTO cul_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","—Nadsama madija huapimapa Abi qqui toquina-jararaha ojariana Abi qqui tajari. Najaropi ohua. Ohuapi Dio pocca occajonajaro. ");
INSERT INTO cul_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ohuapi pajissara tiadenidsa huati onajaro: Madija ohuadsa jehe quinajaripa camittehe jiquejeranicca cajimana-dsanapohuitohui, onajaro −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","—Jehe, ohuapi pan timadimana-dsanaponijinecca. ");
INSERT INTO cul_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nadsa maittaccadsama ticcadeni idideni dsama huamonihuaji jahiridsadsapa pan oni mana jipamanapojaripa huapima jicaridsajari. ");
INSERT INTO cul_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Naraha aja pan memehuajicca ccaronajari tahimari huati huati onajaro jipamanajaridenipa jicamana-jarahijine, onajaro. ");
INSERT INTO cul_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ohuapi pan camittehecca ojani memehuajicca occaronajaro. Najari pan madija jipamanajaripa madimana-dsanapohuijine, onajaro. Tiadenidsa pan da onajaripa ohuassire. Madija dsama huapimacca tocassiejerahijinepa ohuana ohua ohuaccoranitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nadsapa jodiodeni Jeso atti mittamanadsa pohuadenira ahuaji huati ahuaji huati quinajaripa: —¿Pohua pohua assire nejecoma inanadsa ia tonajipabaqquihijine? ¡Ssamo tani! −quinajaride. ");
INSERT INTO cul_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Naraha Jeso pohuadenidsa huati tade: —Pajissara tiadenidsa huati onapomana: Ohuapi Madija Bedi ojajaroa ohueme tijipamana-jeradsapi camittehe jiquejeranicca ticappiramananitohui. Ohuemene dse tiquinejeradsa naqui camittehe jiquejeranicca ticappiramananitohui. ");
INSERT INTO cul_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Naraha ohueme jipamanajarideni, ohuemene dse quinajaridenina camittehe jiquejeranicca cajimana-dsanapohuitohui. Nadsapa nidsa huada jicarinicca bacco tadsapi najaridenina onahatoni-baqquihitohui, onajaro. ");
INSERT INTO cul_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nadsama ohuemepi jijipa pajissacca, ohuemene naqui dsedse pajissacca ojani. ");
INSERT INTO cul_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aja ohueme jipamanajarideni, ohuemene dse quinajaridenipa ohuadsa madiridsamanajari. Ohua naqui pohuadenidsa omadiridsajaro. ");
INSERT INTO cul_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Abi Dio camitta tajarina ohua dosse naronajaride. Najari Pohuajine camitta onajaro. Najarossa onanajaroa madija ohua jipamanajaridenipa najaro camittehe jiquejeranicca cajimanahijine. ");
INSERT INTO cul_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aja pan memehuajicca ccaronajari tahimari huati onajaropi pina pan oni mana ticcadeni idideni jipamanajarissa najarahi. Ididenipa najari mana jipamanaraha najaridenipa tojicahi. Naraha aji ohuapi pan memehuajicca ojajaro. Najari pan jipamanajaridenipa madimana-dsanapohuitohui −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Najaro imapi Capernaohuajicca Dio Atti mamarihuaji Jeso madija mari icanabaqquijaride. ");
INSERT INTO cul_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nadsapa Jesocca marinaja pohua ime tahimarini mittamanadsapa aja pohuadsa jahiridsajarideni motapa imahaha canade: —Aja Jeso huati huati tajaripa imittanijine najo tani. ¿Nejecojarina mittadsa jehe nahijine? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pohuadenira attitti cosseri nahi Jeso nahato tadsapa pohuadenidsa huati tade: —¿Aji ima huati huati onajaropi tiadenidsa ocassera tajaroqui? ");
INSERT INTO cul_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Naraha ohuapi Madija Bedi ojajaroa nidsa omadiponihuaji occamacossanini qqui tiquinadsapi ¿nejecoma tiquinapadseje? Nadsana tibodideni huatomanitohui. ");
INSERT INTO cul_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Dio Corimena madijadsa camittehe da inajaro. Madijapa pohua tessedsa camittehe da inanijine ssamo tani. Ohuatti tiadenidsa huati huati onajaropi Dio Corimecca daniji. Camittehe jiquejeranicca tiadenidsa da inanijine pajirani. ");
INSERT INTO cul_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Naraha tiadeni motapi ohuattidsa pajissa tiquinejeraccani −nade Jeso. Madija mota pohuadsa pajissa quina-jarajaridenidsa naco nahato tapojari. Pohua ccaccoradedsa naco nahato tapojari. ");
INSERT INTO cul_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nadsapa denima huati tajari: —Najaroa ohuattipi: Occa Abi Diopa madija ohuadsa inanabaqqui-jaradsapa ohuadsa toquejena-jarahi. Naraha occa Abi ohuadsa inanabaqquijaridenina ohuadsa totoquejena najari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jeso najaro ima huati huati tadsapa madija pohuadsa jahiridsajarideni huapi taraha motapa jai tojaniridsade. Jeso pohuadsa jahiridsaraha ineboqqui-manajaride. ");
INSERT INTO cul_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nadsapa Jeso pohua huatimade 12 inajarodsa huati tade: —¿Tiadeni naqui: “Jaijanina” tiquinaqui? −nade. ");
INSERT INTO cul_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Naraha Ssino-Pedro pohua cacomerade: —Ia Medsede ¿nejecojaridsara jaijanijine? Tettina ojarini camittehe jiquejeranicca. ");
INSERT INTO cul_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iapi tiadsaha pajissa inapode. Tiadsana nahatoqquiri inajaro: Tiapi Diocca Ejedeni Bicabote tijani −nade Pedro. ");
INSERT INTO cul_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nadsapa Jeso huati tapomade: —Aji 12 tiquinajaropi tiadeni ocattejidsa-baqquijarode. Naraha ojariapa pina occa huadi Satanassa nahi −nade. ");
INSERT INTO cul_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aja Jeso huati tajaripa Simon Iscariote bedi Joda tahimari huati tajaride. Jeso pohua huatimade 12 inaraha najari ojariana Jeso ccaccorade tojajaride. ");
INSERT INTO cul_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nahi dsotodepa dsama arobeni Carireadsana Jeso madiccadsa odsa onihi, onihidsa mari mari naridsajaride. Dsama arobeni Jodeahuajipa jodiodeni Jeso pohua dsoqquehijine tohui quinadsapa nahihuaji madide jipera tajari. ");
INSERT INTO cul_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Naraha jodiodenicca idideni odsa huahuaqquidedsa madiridsamanapojaridenicca ejete tohuajirajarode. ");
INSERT INTO cul_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nadsapa Jeso pohua imecotedenipa pohuadsa huati toquinade: —Ajidsapi timadi tejeraji. Jodeahuaji ticcaji. Nahihuaji madimanajari titohui quinajaridenidsa naqui ticca nahatohue nohue nohue taridsaji −quinade. ");
INSERT INTO cul_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","—Madija ohuaha nahatohue cajimanajaridenipa pohuadeni tahimari tojaridsanijinepi poccadeni nahatohue ihinajimamana nejerajaro. Madija huapima qqui toquinahijine nahatohue ahuato ihinanamana najaro. Tia naqui nahatohue ticajidsapi madija huapima qqui toquinahijine nema taridsaji −quinade pohua imecote attideni. ");
INSERT INTO cul_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jeso pohua imecotedeniraha pohuadsa pajissa quina-jaradsapa attideni nama quinajaripaja. ");
INSERT INTO cul_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Naraha Jeso pohua imecotedenidsa huati tade: —Tiadenipi huada ponimaccadsa tohuini tiquinaraha otahimari tojaridsanijinecca huada bacco tejeraccani −nade. ");
INSERT INTO cul_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","—Nadsama tiadenidsapa ajijaro dsamacca madija nacasseraqquiri najarahi. Naraha ohuadsana nacasseraqquiri najari, ohuapi poccadeni imasiri cacomera onadsa. ");
INSERT INTO cul_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nadsapi tiadenira ejetehuaji jai tijaji, ohuapi oqquejerani. Ohuadsa nahatoqquiri nahijinecca huada bacco tejeraccani −nade. ");
INSERT INTO cul_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jeso atti nama nadsapa Carireadsa ibojaride. ");
INSERT INTO cul_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nadsapa Jeso imecotedeni ejetetohui jai tojadsapa pohua naco dsotode nahi madija huapi tahidsa toquejema-dsanapode. Naraha pina pohuadenidsa toqquerahi nahijine pohua cacomajaride. ");
INSERT INTO cul_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nadsa ejete tojadsapi jodiodeni taminedenipa Jeso bacco quinahijine qqui naridsamanadsapa: —¿Nejecohuaji maqquideje nahatobotepa? −quinajaride. ");
INSERT INTO cul_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nadsapa madija huapima Jeso pohua tahimari imahaha canade. Madija motapa: —Najaripa maqquideje bicabotea −quinade. Naraha madija ohuahadenipa: —Iadsapa bica tajarahi. Pohuapa toponi mamaidsade −quinade. ");
INSERT INTO cul_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Naraha Jesodsa jipaqquiri najaripa jodiodeni noppine cappinamanadsa ojidsa imahaha canade. ");
INSERT INTO cul_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ejete mota tohuanaccaraha Diodsa dada toqquimahuaji Jeso toqquedsimadsa madija mari icanabaqquijaride. ");
INSERT INTO cul_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nahidsa Jeso mari icanabaqquidsana jodiodeni huajo caniredsa imahaha canajaride. —¿Nejecoma nadsa tohuattajaritta? Mari mari ihicanamana najararaha −quinade. ");
INSERT INTO cul_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Naraha Jesopa pohuadenidsa huati tade: —Occa marinajapi occa jerani, ohua Cadossedejine −nade. ");
INSERT INTO cul_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","—Aji tibodidenipi: “Pocca marinajapi ¿Diocca dossenijiqui? ¿Pohua motta pohua attirane?” tiquinajaro nitide. Naraha Dio Pohua jipa tahiccara tinanamanadsapi otahimari tiadenidsa ahuato tanitohui: Occa marinajapi Diocca. ");
INSERT INTO cul_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aja madija pocca ima huati huati tataja najaripa madija ohuaha pohuadsa: “A, tiapi nahato tinani” nahijine huati huati tataja najari. Naraha madija ohuaha huati huati tataja najaripa: “Ajijaro imapi ojine jerani, ohua cadossedecca ima, pohuadsara tetidsemanaji” najari. Najarina pajissacca ima huati huati tataja najari. Maidsa-jarajari −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","—Naraha ¿Diocca dosseniji Moisesi dsodo inajaropi tiadenidsa nohuerajarottaqui? Ticajimanaraha najarodsa iboqquiri tiquinajaro. ¿Nejecotohuira ohua tinanadsoqquemananijine tohuini tiquinajaro? Najaropi Diocca dosseniji jerani −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nadsapa madija huapima Jesodsa huati toquinade: —Tiapi tocorime ticajijarojine mona tijajaro nitidija. ¿Naraha nejecojarideni “Tia inanadsoqquena” quinajari? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Naraha Jeso pohuadenidsa huati tade: —Icca jassinajacca huada sabadodsa occa nahatohue ojari naraha huajo ticanirejarode. ");
INSERT INTO cul_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Aji Moisesicca marinajadsapi: “Maqquidejedenipa huissinaja cacajimana nahijine” napohui nade. (Naraha najaro imapi Moisesi huati tadsa jerani. Abarahao madipodsama nema najonajaro.) Najaroa aji ejedeni huadari 8 nadsapa sabadoraha huissinaja titinacajibaqquimana najaripaja. ");
INSERT INTO cul_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tibodideni huatomanaji: Pina Moisesicca marinajassa titinanamana nanijine sabadodsa maqquideje bedi huissinaja titinacajimana naraha ¿aji ojinepi bica tejeraqui? Ojinepa sabadodsa madija assire namanaha tonomiraha ¿nejecotohui ohua ticahadimanajaro? ");
INSERT INTO cul_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nadsapi ajijaro ima tibodideni huatonissa taji. Ponima “Tabaccora tani” tiquinejeraji. Ima nattomede tiquejenadsa pajissara nattome tiquinanissa taji −nade Jeso. ");
INSERT INTO cul_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nadsapa Jerosarehuaji madimanajarideni motaha Jeso qqui toquinadsa imahaha canajaride: —“¿Ajajaria inanadsoqquena” quiquinanajarico? ");
INSERT INTO cul_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡A, naraha aja madija mari mari najonaha! Taminedenipa: “Mari tejeraji” quina-jarajarirana. ¿Icca taminedenipa: “Pajissa, Cristo-Mesia” quinajarico? −quinade. ");
INSERT INTO cul_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","—Naraha iapi ajajari madija pohua ccajonahihuajipa nahatoqquiri inani. Nassa Cristo-Mesiapa pohua ccajonahihuaji ssamoqquiri inaneje −quinade. ");
INSERT INTO cul_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesopa nahi Diodsa dada toqquimahuaji maride tojaraha pohuadeni atti mittadsa jadsirema huati tajaride: —¡Jehe, tiadenid