﻿USE sofia;
DROP TABLE IF EXISTS sofia.cuk_vpl;
CREATE TABLE cuk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cuk_vpl WRITE;
INSERT INTO cuk_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bab-Dummadi, gebe-negasailaunni, nibneg, napneg obinnisad. ");
INSERT INTO cuk_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Deunni, napneg gwen nabir-daklesulid, neg olloo-dakleged, unnila dii-wilasailad-birgi negsichidbi naid. Bab-Dummad-Burbadi dii-birgi aibannaid. ");
INSERT INTO cuk_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Geb degine, Bab-Dummad sogded: “Neg-meegwad nagu.” Agi, neg-meegwad nagunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Geb Bab-Dummad dakded, neg-meegwad, ibnuedi. Agi, Bab-Dummad neg-meegwad, negsichid-ebo bachikii imaknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Bab-Dummad neg-meegwad ibginedye onug-imaksad. Negsichiddi mutikidye onug-imaksad. Weyob neg osedosad, geb neg oibosbalid. Deyob, ibagwenadgi neg gusad. ");
INSERT INTO cuk_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Geb degine, Bab-Dummad sogdebalid: “Neg-ollor-dummad nagu, adi, diimar bachikii naguegar.” ");
INSERT INTO cuk_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Deyobi, Bab-Dummad neg-olloled-dummad nasiksad. Neg-ollor-dummad-birgi dii nagunonikid, degi, neg-ollor-dummad-urba dii nagunonibalid. Deyob gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bab-Dummad a-neg-olloled-dummad mogir-aradye onugsasad. Weyob neg osedosad, geb neg oibosbalid. Deyob, ibabogwadgi neg gusad. ");
INSERT INTO cuk_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Geb degine, Bab-Dummad sogdebalid: “Dii-mogir-arad-urba-naid bachiki nagu, adi, neg-dinnagwad naguegar.” Deyob gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bab-Dummad, neg-dinnagwad, napaye onugsasad. Geb diidina, demarye onugsanonikid. Geb Bab-Dummad dakded, we-ibmar bela nueganbi. ");
INSERT INTO cuk_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Agi, Bab-Dummad sogdebalid: “Bela ibmar-durbamar napagi nagu: Gaganmar-gwag-nikad ambikumar, degine, akar-akar sapi-sunna-sanmakmalad, e-sangi gwag-nika gusun. Ibmar-durbamar akar-akar bela na egad-egad-balibimaladba ambikumarsun.” Deyob gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Geb napagi ibmar-durbamar nagunonikid: Gaganmar-gwag-nikamalad bela na akar-akar egad-egad-balibimaladba, degi, sapimar-e-sangi-gwag-nikumalad bela akar-akar na egad-egad-balibimaladba ambikunonimalad. Bab-Dummad dakdebalid, we-ibmar bela nueganbi. ");
INSERT INTO cuk_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Weyob neg osedosad, geb neg oibosbalid. Deyob, ibapaagwadgi neg gusad. ");
INSERT INTO cuk_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Geb degi, Bab-Dummad sogdebalid: “Nibneggi gwallumar nagu, adi, neg-mutikid, neg-ibgined-ebo bachikii guegar. Adi, ibagan-nagumaid, yolamar-nagumaid, birgamar-nagumaid magar daklegegar. ");
INSERT INTO cuk_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Degi, gwallumar-niba-naid napneg-mee saegar.” Deyob gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bab-Dummad gwallu-dummagan gwabo obinyenonikid: Gwallu-dummad, neg-ibginedgi negdaknai guegar. Gwallu-senigwaddi, neg-mutik negdaknai guegar. Degine, niisgwamar obinnisbalid. ");
INSERT INTO cuk_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Bab-Dummad napneg-mee-imakega, gwallumar, niisgwamar, nibneggi nasiksad. ");
INSERT INTO cuk_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Adi, neg-ibginedgi negdaknai guegar, degi, neg-mutikidgi negdaknai gubaligar. Adina, neg-meegwad, negsichid-ebo bachikii imakegar. Bab-Dummad dakded, we-ibmar bela nueganbi. ");
INSERT INTO cuk_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Weyob neg osedosad, geb neg oibosbalid. Deyob, ibabakegwadgi neg gusad. ");
INSERT INTO cuk_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Geb degi, Bab-Dummad sogdebalid: “Diigi ibmar-dulamar bela akar-akar ambikumar, degine, nuumar ambikumar, we-napneggi nabir niba gukudii gumalagar.” ");
INSERT INTO cuk_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bab-Dummad demargi ibdula-dummagan obinnisad, degine, diigi belagwapa ibmar-dulamar obinnisbalid. Bela na egad-egad-balibimaladba obinnisad. Degine, Bab-Dummad bela nuumar na egad-egad-balibimalad obinnisbalid. Bab-Dummad dakded, we-ibmar bela nueganbi. ");
INSERT INTO cuk_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bab-Dummad a-ibmar-durgangi ise-nued-binsaedgi amarga sogded: “Bemar dula-mergumai gumarsun. Demargi bukidar-dula-mergumai gumarsun. Degine, nuumar, bemar we-napneggi bukidar-dula-mergumai gumarmosun.” ");
INSERT INTO cuk_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Weyob neg osedosad, geb neg oibosbalid. Deyob, ibataledgi neg gusad. ");
INSERT INTO cuk_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Geb degi, Bab-Dummad sogdebalid: “Napagi bela ibmar-durgan na egad-egad-balibimaladba ambikumar: Ibmar-durgan-sunna-akwilemalad, ibmar-durgan-napagi-garmakdimalad, ibmar-durgan-sapurbarmalad, bela na egad-egad-balibimaladba ambikumar.” Deyob gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bab-Dummad bela ibmar-durgan-sapurbarmalad na egad-egad-balibimaladba obinnisad. Ibmar-durgan-sunna-akwilemalad bela na egad-egad-balibimaladba obinnisbalid. Degine, ibmar-durgan-napagi-garmakdimalad bela na egad-egad-balibimaladba obinnisbalid. Bab-Dummad dakded, we-ibmar bela nueganbi. ");
INSERT INTO cuk_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Geb degi, Bab-Dummad sogdebalid: “Emisgindi, anmar, dule-obinyesun, anmar-sunnague anmar imakoed. Dulede, we-ibmar-durganmargi gangued-nika guoed: Uamargi, nuumargi, ibmar-durgan-sunna-akwilemaladgi, ibmar-durgan-sapurbarmaladgi, ibmar-durgan-napagi-garmakdimaladgi, bela we-ibmarmargi we-napneggi gangued-nika guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bab-Dummad dule-obinyenonikid, na e-sunnague obinyenonikid. Bab-Dummad e-sunnague na imaksad. Machered, ome-ebo obinnisad. ");
INSERT INTO cuk_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Bab-Dummad we-dulemargi ise-nued-binsasadba, ega sogded: “Bemar mimmigan-bukidar nikumar. We-napneggi dula-bukidar urbemar, degi, bela we-napneg-ugakaase ambikumar. Bemar we-napneggi be gangued-nikadba bela we-ibdurganmargi be obindii gumarsun: Uamargi, nuumargi, degi, ibmar-durgan-napagi-garmakdimaladgi.” ");
INSERT INTO cuk_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Geb degi, Bab-Dummad dulega sogdebalid: “We-napneggi bela gagan-nabir-gwag-nikumalad, degi, bela sapimar-e-sangi-gwag-nikumalad, an bemarga uked. A-ibmar-durba bela bemar-masga guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Bab-Dummad we-napneggi bela we-ibmar-durganga sogdebalid: “Bela ibdula-unimaladga, bela nuumarga, bela ibdurgan-napagi-garmakdimaladga, bela gagan-ara-aramalad e-masga-guega an ega uked.” Deyob gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Geb degine, Bab-Dummad dakded, bela ibmar-na-obinnisadi, bela-bela nueganbi. Weyob neg osedosad, geb neg oibosbalid. Deyob, ibanergwadgi (6) neg gusad. ");
INSERT INTO cuk_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Deyobi, nibneg obinnilesad, napneg obinnilesad, amargi ibmar-akar-akar obinnilesad, bela deyob ambikunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ibanergwadgi (6) Bab-Dummad bato bela ibmar-obinnissoggu, ibagugled-nagunonigu (7), Bab-Dummad obunnosad, bar arbassulid. ");
INSERT INTO cuk_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Geb degine, Bab-Dummad ibagugledgi (7) ise-nued binsasad. Bela ibmar-obinnisad-bergusgu, obunnosad. A-ulale, a-iba, iba-islidikidye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Deyob napneg obinnilesad, degi, nibneg obinnilesad. 1b. Dule abirgunagwar Edénʼgi gwisgunonikid (2:4-25) Bab-Dummad-Jehová, we-napneg, degi, nibneg obinnisgua, ");
INSERT INTO cuk_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","amba sapimar napneggi sated, amba yoo gaganmar-aragana ainidabalid. Ar ade, Bab-Jehová amba yoo dii napagi owidaged, degi, dule napagi-arbaega satebalid. ");
INSERT INTO cuk_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Unnila napagi dii-bupurmakmaid, bergwapa napa ogegar. ");
INSERT INTO cuk_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Geb degine, Bab-Dummad-Jehová napa susgu, a-napagi dule-sobsad. Bab-Jehová dule-sobsagu, dule-asugi buu imaksad. Geb agi, dule burba-nika gunonikid. Agine, dule dula-gunonisunnad. ");
INSERT INTO cuk_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Geb degine, Bab-Dummad-Jehová dad-nakwedsik, Edénʼgi nainu-nued nasiksad. Agi, Bab-Dummad-Jehová we-dule-obinnisad ogwisnonikid. ");
INSERT INTO cuk_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Agine, Bab-Dummad-Jehová sapimar akar-akar bela yeerdaklemalad ainiega imaksad. A-sapimar-e-san bela yeer-gulle imaksad. Nainu-nued-abargi, sapi-wargwen gwichid. Dule we-sapi-e-san guchale, dula-gudii guoed, gwen burgosulid. Degine, sapi-baid gwichibalid. Dule we-sapi-e-san guchardina, wisguoed, ibu ibnuedi, ibu ib-isganabali. ");
INSERT INTO cuk_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Degine, Edénʼgi diwar maid. Agi, e-saila-siid. A-diwar nainu-nued ogmaid. A-diwar ana-sogabake nikad. ");
INSERT INTO cuk_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Gebe-ana-gwensakgadi Pisónʼye nugad. A-diwar bela Havila-yalaganba bipirmakmaid. Aginbali, a-yargi or nikad. ");
INSERT INTO cuk_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Havila-yargine or-nikadi, or-nuedid. Agi sapi-nued-gichi-nikad-bedelioʼye-nugad nikad. Degi, akwa-nued-óniceʼye-nugad nikabalid. ");
INSERT INTO cuk_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Diwar-ana-sogbogwaddi Gihón-diwarye nugad. A-diwar bela Cus-yalaganba bipirmakmaimogad. ");
INSERT INTO cuk_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Diwar-ana-sogapaagwaddi Hidekelʼye nugad. A-diwar, Asiria-dad-nakwedsik maid. Diwar-sogabakegwaddi Éufratesʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nainu-nued-Edén-akwega, Bab-Dummad-Jehová, dule-ogwisnonikid, agi arbaegar. ");
INSERT INTO cuk_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Agine, Bab-Dummad-Jehová dulega igar-uksad: “We-nainu-nuedgi sapimar-bukwad-e-sanmar sunna bela be gunned. ");
INSERT INTO cuk_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Unnila sapi-wargwen-e-sandi melle be gunno. We-sapi, ibmar-nued-wisi, ibmar-isgana-wisi dule-saed. A-sapi-e-san be guchale, a-ibagi be burgoed.” ");
INSERT INTO cuk_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Geb degine, Bab-Dummad-Jehová sogded: “Dule wargwen-gudiir, akuu dakleged. Degisoggu, dulega e-abirgined an imakoed, adi, e-bendaked-nuedga guegar.” ");
INSERT INTO cuk_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Bab-Dummad-Jehová napagi bela ibmar-durgan, bela nuumar obinnisad. Bab-Jehová we-ibdurganmala Adánʼse senonikid. Adi, Adán ega nug amiegar. Dule ibmar-durganga nug-amisad, abali, ibmar-durgan nugnanaed. ");
INSERT INTO cuk_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Weyobi dule bela we-ibmar-durgan: Ibmar-durgan-sunna-akwilemaladga, bela nuumarga, bela ibmar-durgan-sapurbarmaladga, nug amisad. Degi-inigwele, Adánʼgardi e-bendaked sate gusad. ");
INSERT INTO cuk_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Geb degine, Bab-Dummad-Jehová Adán-ise-nue-gabega imaksad. Adán nue-gabmaigu, Bab-Jehová Adán-e-dikargar-wargwen onosad. Geb Bab-Dummad-Jehová gannar Adán-e-san edisad. ");
INSERT INTO cuk_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Bab-Dummad-Jehová we-dikargargi ome-obinnisad. Agi, macheredga ome-senonikid. ");
INSERT INTO cuk_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Adán ome-dakdegu, sogded: “Ar wedi an-galado, ar ade, an-gargi obinnilealedid. Wedi an-sanado, ar ade, an-sangi obinnilealedid. Ar Bab-Dummad we-ome macheredgi obinnisad. We nugguodo, Omeye.” ");
INSERT INTO cuk_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","A-ulale, machered e-babgi bangudoed, e-nangi bangudoed. Geb machered e-ome-ebo garmakdii guoed. Ebogwadi, san-wargwennagwadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Deunni, Adán, Eva-ebogwa, uka-swili garmakdimalad, gwen binged nikasurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bab-Dummad-Jehová we-napneggi bela ibmar-durgan obinnisad. Amar-abargi, naibedi ibmar-durgan-baiganba dule-binsaed-gaedgi bur buledid. Naibe omega sogded: —¿Etto, Bab-Dummad bemarga sogsa: ‘We-nainu-nuedgi sapimar-gwichid-e-san melle bipisaale gunmaloye?’ ");
INSERT INTO cuk_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ome naibe-abin sogded: —Ar igid-sapi-e-san anmar we-nainu-nuedgi gunbimala, sunna bela anmar gunmalad. ");
INSERT INTO cuk_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Unnila nainu-nued-abargi sapi-wargwen-gwichid-e-sanbi geg anmar gunned. Bab-Dummad anmarga sogsado: ‘Melle a-sapi-e-sandi be gunmaloye, degine, melle be ebumarbaloye. Ar bemar guchale, bemar burgwemaloye.’ ");
INSERT INTO cuk_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ar naibedi omega sogded: —Suli, degisuli. Bemar gwen burgosuli. ");
INSERT INTO cuk_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ar Bab-Dummad nue-wisid, bemar we-sapi-e-san guchale, ibmar-wisii gudmaloed. Geb agine, bemar Bab-Dummadyob ibmar-wisi gudmaloed, ibi ibnuedi, ibi ib-isganabali. ");
INSERT INTO cuk_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Ome sapi-san-dakdegu, dakalid, sapi-san yeerdaklege, nued-gulle-daklege, degine, nue-ibmar-wisi sunna dule-imake daklege. Degisoggu, ome sapi-san-gwachagu, guchad. Geb ome e-suiga uksamogad. E-suide guchamogad. ");
INSERT INTO cuk_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Geb agine, na ebobela neg-ittos nadmalad, emarde uka-swili garmakdii. Geb degine, saburega gagan-urwagiid-higueraʼye-nugad maksamalad. Agi, na saburusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Dule, e-omebogwa, neg-sedogudanikidgi itoarmalad, Bab-Dummad-Jehová, nainu-nued-abargi garmakdii. Dule, e-omebo deyob itosmargu, Bab-Dummad-Jehováʼgi nainu-nuedgi sapimar-bukwad-imbaba dukunadmalad. Adi, mer Bab-Jehová emar-dakegar. ");
INSERT INTO cuk_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Bab-Dummad-Jehováʼdi macheredse goted, ega sogded: —¿Bia be gudii? ");
INSERT INTO cuk_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Dule abin-sogded: —An be-itosad, nainu-nued-imbaba be gudii. Ar an uka-swili-gudisoggu, an be-dobee itoged. A-ular, an be-idu dukusad. ");
INSERT INTO cuk_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Geb degine, Bab-Dummad macheredse egichialid: —¿Ar doa bega sogsa, be uka-swilii gudiiye? An bega sogsad: ‘Sapi-wargwen-e-san mer be gunnoye.’ ¿A-sapi-e-sande be guchasi? ");
INSERT INTO cuk_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Dule Bab-Dummad-abin sogded: —Ome-anbo-garmakdiguega be anga-uksadi, a, anga sapi-e-san uksad. Geb an guchasunnad. ");
INSERT INTO cuk_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Geb degine, Bab-Dummad-Jehová omese egichided: —¿Ibiga deyob be imaksa? Ome abin-sogded: —Ar naibe an-yardaksad. A-ular, sapi-e-san an guchad. ");
INSERT INTO cuk_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Geb degine, Bab-Dummad-Jehová naibega sogded: “Ar weyob be imaksasoggu, ibmar-durgan-akwilemaladba, degi, ibmar-durgan-sapurbarmalad-baiganba, bedi bur bule be ukabsalesun. Emi-iba-onodedgi, be napagi unimakdii gusun, degine, be-burgwedse, napa-madii be gusun. ");
INSERT INTO cuk_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ome-ebogwa na be isdar-dakdii an be-imakoed. Ome-e-wagwa, be-wagwa-ebo na isdar-dake gumaloed. Ome-e-wagwa be-nonogi annaoed. Bedina e-mali-gasigi onakliksaoed.” ");
INSERT INTO cuk_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Bab-Dummad omega sogded: “Be sikwi-bakalile, nunmaked-dummad an bega ukoed, nunmakedgi be ugakguoed. Be-suibina be sogdii guoed. Be-sui be-iduedga guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Bab-Dummad macheredga sogdemogad: “Ar be-ome-sogedba, sapi-e-san-mer-gunnoye an bega sogsadi, be guchasoggu: Deyob be imaksad-ular, we-napa iwiles nagusun. Be burgwedse ise-arbaar-alamakdiidgi, be masgunned-amidii gusun. ");
INSERT INTO cuk_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Napa bega ikomar nikuoed, napa bega gagan-ikobiid nikuoed. Gagan-nainuginmalad-gunne be guoed. ");
INSERT INTO cuk_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Be-wimaked-osuurmakedgi na be masgunned-amidii guoed. Deyob be guoed, be napaga gannar guedse. Ar ade, napagi be danikid. Ar be napasoggu, be burgwisale, napaga gannar be binyoed.” ");
INSERT INTO cuk_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ar omede bela dulemar-dula-gunonikoed-e-nanga guosoggu, Adán na e-ome Evaʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Bab-Dummad-Jehová, macheredga, degi, omega ibmar-durgan-uka morga imaksad. Geb macheredga, degi, omega mor yossunnad. ");
INSERT INTO cuk_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Geb degine, Bab-Dummad-Jehová sogded: “Emigindi, dule anmar-sunnaa gunonimogad. Dulemarde ibmar-nued-wisi, degine, ibmar-isgana-wisi gunonikid. Ar dule sapi-e-san-dula-dule-imaked-guchale, degisadegu dula-gudii guoed. Degisoggu, melle dulemar we-sapi-e-san gwanegala, degi, melle gunnegala, dulemar-nainu-nuedgi-gudiid, an onogoed.” ");
INSERT INTO cuk_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Degisoggu, a-ular, Bab-Dummad-Jehová, nainu-nued-Edénʼgi dule-gudiid onossunnad. Degine, napagi-arbaega dule-imaksad. Ar ade, napagi dulede danikid. ");
INSERT INTO cuk_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Bab-Jehová, Adán nainu-nuedgi-gudiid onosgua, nainu-nued-dad-nakwedsik baliwiturmar-querubinʼye-nugad ogwichisad. Degine, es-suid-gwabunye-gwichid bela bipirmakgwichi imaksabalid. Adi, melle dule-wargwensaar sapi-dula-dule-imakedse warmakmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adán e-ome-Evaʼse-gochagu, Eva gurgin-nika gunonikid. Evaʼga susugwa uklenonikid, Caínʼye onugsasad. Ar Eva sogded: “Bab-Jehová na e-sogedba susugwa anga uksad.” ");
INSERT INTO cuk_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Geb a-sorba, Evaʼga Abel uklenonikid, Caín-e-urba. Abel sibad-wawaad-edarbedga gusad. Caínʼdi sapurba-arbaed-dulega gusad. ");
INSERT INTO cuk_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ibagan-nasad-sorbali, Caín na e-ibmar-sanmaksamalad wesad. Geb Bab-Jehováʼga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abelʼdi na Bab-Jehováʼse sibad-wawaad-gebegwalulesmalad senonimogad, geb oburgwisad. A-sibad-wawaad-e-gwallu ogumakar Bab-Jehováʼga uksad. Bab-Jehová Abel-yeer-daksad, degine, ega-ibmar-uksad yeer daksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Bab-Jehová Caín-yeer-daksasulid, degine, ega-ibmar-senonikid amba yeer daksasurbalid. A-ulale, Caín bela-bela sae-itoalid. E-wagar-daklegedi magar-dakleged, nue sae-itoged. ");
INSERT INTO cuk_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Geb degine, Bab-Jehová Caínʼga sogded: “¿Ibiga sae be itoge? ¿Ibiga be-wagar urwakwaa daklege? ");
INSERT INTO cuk_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ar ibmar-nued be imakele, ¿an be-abingassurmogar be insae? Eye, an be-abingasmogale. Ar emigindi, be ibmar-nued imaksursoggu, isgued begi-aibinega guakwaa be-edarbediid. Degi-inigwele, sunna isguedgi be obined.” ");
INSERT INTO cuk_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ibagwengi, Caín e-urbaga sokalid, sapurba wis-garmakdii sanamarye. Geb ebo-sapurba-gudiidgi, Caín e-urba-Abel-sarsosad, geb oburgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Geb degine, Bab-Jehová Caínʼse egichided: —¿Bia be-urba-Abel nade? Caín, Bab-Jehová-abin sogded: —An wissuli. ¿Ar ande an-urba-edarbedsi? ");
INSERT INTO cuk_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Bab-Jehová Caínʼga sogded: —Ar wede, ¿ibi be imaksa? Be-urba-ablis be eosad. Emide, a anga sogeyob an itoged: ‘Anga be igar-naboye.’ ");
INSERT INTO cuk_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Be be-urba oburgwisadba, napa be-urba-e-ablis gobsad. A-ulale, be ukabsalessunnad. ");
INSERT INTO cuk_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","A-ular, be nainugi arbaoen-inigwele, bega ibmar sanmakosulid. Be we-napneggi dule-wakindiiyob negsuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Geb degine, Caín, Bab-Jehová-abin sogded: —Weyob sabsur be an-odurdakele, gwen guo an itosulid. ");
INSERT INTO cuk_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ar emi-ibagi, nainugi-arbaedgi be an-ononaisoggu, we-napneggi garmakdii, dikasur begi bangus gudii, dule-wakindiiyob negsuli, obunnoged-sate an gudii gudoed. Degisoggu, doa-dule an-dakalile, an-oburgoed. ");
INSERT INTO cuk_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Bab-Jehová Caín-abin sogded: —Suli, deyob guosuli. Ar dule be-oburgwele, we-dule-be-oburgwisad ilagugle (7) bur bule sabsur-odurdaklegoed. Geb degine, Bab-Jehová Caínʼgi wilub nasiksad, adi, dule-gwensak Caín-dakalile, melle oburgwegar. ");
INSERT INTO cuk_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Caín Bab-Jehováʼgi bangudgu, Nod-yargi megidapid. Nod-yarde Edén-dad-nakwedsik naid. ");
INSERT INTO cuk_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caín e-omese-gochagu, e-ome gurgin-nika gunonikid. Machigwa-ega-uklesad, Enocʼye onugsasad. Caín, neggwebur urbenonikid. E-machi-nugba, we-neggwebur Enocʼye onugsanonikid. ");
INSERT INTO cuk_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoc, Irad-e-babad. Iradʼdi, Mehujael-e-babad. Mehujaelʼdi, Metusael-e-babad. Metusaelʼdi, Lamec-e-babmogad. ");
INSERT INTO cuk_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamecʼdi ome-warbo-nikusad: Wargwen Adaʼye nugad, baiddi Zilaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada machi-nikusad, Jabalʼye onugsasad. Jabal-inse dordoneg-sobed onoded. A-inse ibmar-durgan-akwedgi-arbaed onodbalid. ");
INSERT INTO cuk_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabal urba nikusad, Jubalʼye nugad. Jubal-inse gar-arpa-ogoled onoded. A-inse gammu-ogoled onodbalid. ");
INSERT INTO cuk_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zilaʼdi machigwa-nikunonimogad. Tubal-Caínʼye a-machigwa onugsasad. Tubal-Caín-inse esgoro-gordikidgi-ibmar-sobed onoded, degi, esgorogi-ibmar-sobed onodbalid. Tubal-Caín bun-wargwen nikusad. E-bunde, Naamaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ibagwengi, Lamec e-omemarga sokalid: “Ada, Zila, an bemarga ibmar-sogoedi, nue be an-itomalo: Dule naibi-an-imaksad-ular, an oburgwisad. Machigwa an-sarsosad-ular, an oburgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ar dule Caín-oburgwisale, we-dule ilagugle (7) buged-mai, sabsur-odurdaklegoye sogleged. Ar dule an-oburgwisardi, we-dule an-oburgwisad-ular, dulapaa-gakambe-gakagugle (77), bur bule sabsur-odurdaklegergebed.” ");
INSERT INTO cuk_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adán e-omese gochabargu, Eva susugwa-nikunonikid. Geb Eva sogded: “Caín, e-urba-Abel-oburgwissoggu, Bab-Dummad susugwa anga Abel-anar uknonikid.” A-ular, Eva a-susugwa Setʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set machigwa-nikusmogad, Enósʼye onugsasad. A-ibagan-akar, dulemar Bab-Jehováʼse gotemalad. ");
INSERT INTO cuk_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","We, Adán-e-wagan-nugmar-narmakar-mamaid-e-gardad. Bab-Dummad dule-obinnisgua, deunni na e-sunnague dule-imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Bab-Dummad machered ome-ebogwa obinnisad. Wemargi ise-nued binsasad. Bab-Dummad dulemar-obinnisgua, amarga sogsad: “Bemar, duleye nugguoye.” ");
INSERT INTO cuk_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adán birga-dulanergwa-gakambe-nikadgi (130), e-machi gwalulesad, Setʼye onugsanonikid. Setʼde bela Adánʼsun-dakleged, degine, bela e-bab-daeyobi dabalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","A-sorba, Adán birga-dulataled-ilabaabak (800) napi-gudii gusad. Adán, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Degisoggu, Adán bela birga-dulataled-ilabakebak gaka durgwen-gakambe (930) dula-gudii gusad. Degi-birga-nika Adán burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set birga-dulatar-gakatar-nikadgi (105), e-machi-Enós gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","A-sorba, Set birga-dulataled-ilabaabak gakagugle (807) napi-gudii gusad. Set, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Degisoggu, Set, bela birga-dulataled-ilabakebak gakambe-gakabo (912) dula-gudii gusad. Degi-birga-nika Set burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enós birga-dulabake-gakambe-nikadgi (90), e-machi-Cainán gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","A-sorbali, Enós, birga-dulataled-ilabaabak gakambe-gakatar (815) napi-gudii gusad. Enós, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Degisoggu, Enós, bela birga-dulataled-ilabakebak gakatar (905) dula-gudii gusad. Degi-birga-nika Enós burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainán, birga-dulapaa-gakambe-nikadgi (70), e-machi-Mahalaleel gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","A-sorbali, Cainán, birga-dulataled-ilabaabak gaka dulabo (840) napi-gudii gusad. Cainán, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Degisoggu, Cainán, bela birga-dulataled-ilabakebak gakambe (910) dula-gudii gusad. Degi-birga-nika Cainán burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel, birga-dulapaa-gakatar-nikadgi (65), e-machi-Jared gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","A-sorba, Mahalaleel, birga-dulataled-ilabaabak gaka dulagwen-gakambe (830) napi-gudii gusad. Mahalaleel, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Degisoggu, Mahalaleel, bela birga-dulataled-ilabaabak gaka dulabake-gakambe-gakatar (895) dula-gudii gusad. Degi-birga-nika Mahalaleel burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared, birga-dulabaabak-gakabo-nikadgi (162), e-machi-Enoc gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","A-sorba, Jared, birga-dulataled-ilabaabak (800) napi-gudii gusad. Jared, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Degisoggu, Jared, bela birga-dulataled-ilabakebak gaka dulapaa-gakabo (962) dula-gudii gusad. Degi-birga-nika Jared burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoc, birga-dulapaa-gakatar-nikadgi (65), e-machi-Matusalén gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusalén-gwalulesad-sorba, Enoc, birga-dulataled-ilapaa (300) Bab-Dummad-walikaa nanadii gusad. Enoc, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Degisoggu, Enoc, bela birga-dulataled-ilapaa gaka dulapaa-gakatar (365) dula-gudii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ar Enoc, Bab-Dummad-walikaa nanadii gussoggu, ibagwengi sate daklealid, ar ade, Bab-Dummad na-sesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusalén, birga-dulabakebak-gakagugle-nikadgi (187), e-machi-Lamec gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","A-sorba, Matusalén, birga-dulataled-ilagugle gaka dulabake-gakabo (782) napi-gudii gusad. Matusalén, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Degisoggu, Matusalén, bela birga-dulataled-ilabakebak gaka dulapaa-gakabakebak (969) dula-gudii gusad. Degi-birga-nika Matusalén burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec, birga-dulabakebak-gakabo-nikadgi (182), e-machi gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Noéʼye e-machi-onugsasad. Ar ade, sogded: “Bab-Jehová we-napa-ukabsassoggu, a-ular, anmar ise-alamaknai arbaergebed. Ar emigindi, we-machigwa anmarga obunnoged ukoed.” ");
INSERT INTO cuk_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noé-gwalulesad-sorba, Lamec, birga-dulataled-ilatar gaka dulabake-gakambe-gakatar (595) napi-gudii gusad. Lamec, machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Degisoggu, Lamec, bela birga-dulataled-ilagugle gaka dulapaa-gakambe-gakagugle (777) dula-gudii gusad. Degi-birga-nika Lamec burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé, bato birga-dulataled-ilatar (500) nikagua, e-masmala gwalulenonikid: Sem, Cam, degi, Jafet. ");
INSERT INTO cuk_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Dulemar we-napneggi merguarmargu, degi, ega bunormala gwalulemaiguargu, ");
INSERT INTO cuk_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","masmala-Bab-Dummadba-nanamalad dakalid, dulemar-yagan yeer daklemala. Degisoggu, masmala-Bab-Dummadba-nanamalad dulemar-yagana-ebo-nikuega na e-abegedba susdamalad. ");
INSERT INTO cuk_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Agi, Bab-Jehová sokalid: “Ar dulemar unnila dule-gumarsoggu, An-Burba dule-dula-imaked degisadegu eba gudii guosulid. Degisoggu, dulemar burgoed. A-ular, unnila birga-dulanergwa (120) dula-bukwa gumaloed.” ");
INSERT INTO cuk_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Masmala-Bab-Dummadba-nanamalad, dulemar-sisgan-nikudmargu, mimmigan-baknonimalad. A-burwigan dule-mas-bipisuli gusmalad. Wemala, epennegwa dule-gala-ibegan, degi, dule-nuga-nika gusmaladid. A-akale, dule-masdummagan we-napneggi-nika gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Bab-Jehová dakalid, we-napneggi dogdar dulemar-isgued mergugusa, degine, we-dulemar unnila ibmar-isgana-imakedginbi binsadimala. ");
INSERT INTO cuk_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Degisoggu, Bab-Jehová ulubgi nue bukib-binsaedba, sogded: “Dulemar an we-napneggi urbissulina, bur nabirinad.” ");
INSERT INTO cuk_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","A-ular, Bab-Jehová sogded: “An dule-obinnisad we-napneggi an obelogodo. Degine, bela ibmar-durgan, bela ibmar-durgan-napagi-garmakdimalad, degi, nuumar an obelobalodo. An we-ibmarmar-obinnisadgi, nue-nunmak an itoged.” ");
INSERT INTO cuk_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ar degi-inigwele, Bab-Jehová Noéʼbi nued-gudii daksad. ");
INSERT INTO cuk_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noé-igar weyob maid: Noé ibmar-inniki-imaked-duled. A-ibagangine, dule Noéʼgi akar-ibmar-soged sated. Noé Bab-Dummad-walikaa nanadii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé machimala-walapaa nikusad: Sem, Cam, Jafet. ");
INSERT INTO cuk_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Deunni, bela-dulemar, Bab-Dummad-asabin, we-napneggi nue-isgus gudidiid. Deginbali, dulemar na sabsur-imakbukwamarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Bab-Dummad-dakded, bela-dulemar we-napneggi dogdar nue-isgus gudidimala, degisoggu, neg nue-isgus naisunnad. ");
INSERT INTO cuk_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","A-ulale, Bab-Dummad Noéʼga sogded: “Bela dulemar an osulosokalid. Dulemar galagwensulidaed, muchub-muchub sabsur-imakmaladi yaisulid. A-ulale, dulemar an obelogoed, degine, we-napneg-naid an obelobaloed.” ");
INSERT INTO cuk_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Bab-Dummad sogdebalid: “Noé, ur-dummad na be sobo. Suar-goferʼye-nugad-e-urgomar be ebugoed. Ur-soboedgi gwardumar be sioed. Ur-dummad-be-soboeddi magaba, degine, yaba baryagi bela be magoed. ");
INSERT INTO cuk_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Weyob ur-dungu be soboed: E-sugued, dali-dulapaa-gakambe-gakatar (75) be imako. E-matardungueddi, daliambe-gakabo-abala (12½) be imako. E-nibgued, daligugle-abala (7½) be imakbalo. ");
INSERT INTO cuk_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ur ailapaa-nika be soboed, e-uas-urba e-yawagak-bipigwad achabogi urba be sioed, degine, e-dikarba yawagak be ogwisbaloed. ");
INSERT INTO cuk_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","”We-napneg-odogega muusaila an barmidagoed. Bela we-napneggi ibmar-dula-gudidimalad an obelogoed, bela burgoed. ");
INSERT INTO cuk_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","”An bebo igar-meso. We-ur-dummadyaba be dogo: Be, be-ome, be-masmala, degi, be-balamar. ");
INSERT INTO cuk_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Be-sunnaa durgumogoed. Ur-dummadyaba, bela we-napneggi ibmar-durgan-nikadi, abirgunagwar-abirgunagwar be oubogo. ");
INSERT INTO cuk_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Bela ibmar-dula na egad-egad balibimaladba, abin-abin war-warbo ur-dummadyaba beba ubomogo: Bela nuumar, bela ibmar-durgan, bela ibmar-durgan-napagi-garmakdimalad, adi, bela amar durgumarmogagar. ");
INSERT INTO cuk_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","”Degine, bela mas akar-akar be onmakbalo, degi, nue sabobalo, adi, we-mas be gunnegar. Degine, ibmar-dula-gudidimalad we-mas gunmogagar.” ");
INSERT INTO cuk_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ar igi Bab-Dummad Noéʼga sogsa, aba bela Noé ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Geb a-sorba, Bab-Jehová Noéʼga sogded: “Emi-ibagangi, dulemar-bukwad-abargi, unnila bebi an-asabin inniki nanadiid. Degisoggu, be, be-gwenadganmala ur-dummadyaba be doge. ");
INSERT INTO cuk_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Geb bela ibmar-durgan-swilidikmalad: Machered-walagugle (7), ome-walagugle, ur-dummadyaba be oubogo. Ibmar-durgan-swilidiksurmaladdi unnila machered-wargwen, ome-wargwen be oubogo. ");
INSERT INTO cuk_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nuumala amba deyob be imakbaloed: Nuumar-swilidik-akar-akar-nikadi, gwagugle-gwagugle (7-7), abirgunagwar-abirgunagwar ur-dummadyaba be oubogo. Adi, we-napneggi bela ibmar-durgan, nuumarse-bakar, egad-egad balibimalad mer e-dula berguegar. ");
INSERT INTO cuk_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","”Ar ade, ibaguglese (7) dii an owioed, iba-dulabo (40) mutikidba, degi, ibginedba dii-winai an imakoed. ¡We-napneggi bela ibmar-dula-obinnilesad, bela an obelogoed!” ");
INSERT INTO cuk_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ar igi Bab-Jehová Noéʼga sogsa, aba bela Noé ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","We-napneggi muusaila-nosgua, deunni, Noé birga-dulataled-ilanergwa (600) nikad. ");
INSERT INTO cuk_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé-ur-dummad-sobsadyaba-dogsamaladi, wemalad: Noé, e-ome, e-masmala, degi, e-balamar, adi, muusailaba melle burgwemalagar. ");
INSERT INTO cuk_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ibmar-durgan-swilidikmalad, ibmar-durgan-swilidiksurmalad, nuumar, ibmar-durgan-napagi-garmakdimalad, ");
INSERT INTO cuk_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","a-ibmar-durgan, igi Bab-Dummad Noéʼga sogsadyobi, Noéʼba ur-dummadyaba war-warbo abirgunagwar-abirgunagwar dogsamalad. ");
INSERT INTO cuk_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ibagugle-gusgu (7), muusaila napneggi muluded. ");
INSERT INTO cuk_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé birga-dulataled-ilanergwa-nikadgi (600), nii-warbogwad-ibambe-gakagugledgi, dii-wilasailadgi bela napa-urba-dii-sailagan-mamaid utuded, degine, nibneggi-dii-sailagan-mamaid argaded. ");
INSERT INTO cuk_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Napneggi iba-dulabo (40) bane-bane mutikidba, ibginedba, dii-winai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Noé, ur-dummadyaba-dogsad-ibagi, wemar eba dogsamarmogad: E-ome, e-machi-Sem, e-machi-Cam, e-machi-Jafet, degi, e-masmala-omegan. We-dulemarbi ur-dummadyaba dogsamalad. ");
INSERT INTO cuk_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Wemarba bela ibmar-durgan-na-egad-egad-balibimalad dogsamarbalid. A-ibdurgan wemalad: Ibmar-durgan-sapurbarmalad, ibmar-durgan-sunna-akwilemalad, ibmar-durgan-napagi-garmakdimalad, nuumar, degi, bela ibmar-sakan-nikamalad. We-ibmar-durgan, Noéʼba ur-dummadgi dogsamarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Bela ibmar-dula-gudidimalad Noéʼba ur-dummadyaba war-warbo dogsamalad. ");
INSERT INTO cuk_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bab-Dummad Noéʼga-sogsadba bela ibmar-durgan-akar-akar na abirgunagwar-abirgunagwar dogsamalad. Geb a-sorba, Bab-Jehová ur-dummad-yawagak edisad. ");
INSERT INTO cuk_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Iba-dulabo (40) napneggi dii-winai gusad. Dii-muludgu, ur muamakded. Degisoggu, ur-dummad dii-birgi muamaknai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dii sabsur-muremai-muremai guded. Ur-dummaddi dii-birgi muamaknai gussunnad. ");
INSERT INTO cuk_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Dii bela-bela mulussoggu, napneggi-yar-dummagan-bukmalad bela dogsad. ");
INSERT INTO cuk_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bela yarmar dogsa-sigisgu, amba dii dalipaa-abala-wilub (3½) muremai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Weyob bela ibmar-durgan-we-napneggi-bukwad burgwisad: Nuumar, ibmar-durgan-sunna-akwilemalad, ibmar-durgan-sapurbarmalad, ibmar-durgan-unimalad, degi, bela dulemar burgwismarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","We-napneggi ibmar-dula-gudimalad, bela burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Weyob bela we-napneggi we-ibmarmar obelolesad: Dulemar, ibmar-durgan, ibmar-durgan-napagi-garmakdimalad, degi, nuumar, amar bela burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Unnila, Noé, degi, ur-dummadyaba-bukwamaladbi durgusmalad. Dakargu, iba-dulagugle-gakambe (150) bela napneggi dii-saila mulus nagusad. ");
INSERT INTO cuk_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Geb degine, Bab-Dummad Noéʼgi, degi, ibmar-durgan-sapurbarmaladgi, ibmar-durgan-sunna-akwilemaladgi, bela ur-dummadyaba-bukwadgi binsaded. Bab-Dummad we-napneggi burwa ogornonikid. Geb degi, dii ilided. ");
INSERT INTO cuk_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Deginbali, demar-wilasailadgi dii-sailagan-mamaid atided, degine, nibneggi dii-sailagan-mamaid atidmogad. Dii bar wissulid. ");
INSERT INTO cuk_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Agine, dii binna-binna ilided. Iba-dulagugle-gakambe-gusgu (150), dii nue ilided. ");
INSERT INTO cuk_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Geb nii-walagugled-ibambe-gakagugledgi, ur-dummad Ararat-yalagangi megidapid. ");
INSERT INTO cuk_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dii nue-iremai gualid. Nii-warambed-gebe-iba-onodedgi bato yar-dummagan-e-mullumar noalid. ");
INSERT INTO cuk_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Iba-dulabogwad-sorba (40), Noé ur-dummadgi yawagak-bipi-soblesad egasad. ");
INSERT INTO cuk_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Geb agi, sikwisichid barmisad. Sikwisichiddi gannar-gannar gukudii gusad, dii-dingued edarbedii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noé sikwisichid-barmisad-sorba, nuu barmisad, adi, dakega sana napa dingudibeye. ");
INSERT INTO cuk_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ar napa amba yoo dingusoggu, nuu siged amissurgusad. Degisoggu, gannar ur-dummadse nonikid. Noé e-argan onosgu, nuu-gasad, ur-dummadyaba gannar nuu-odosad. ");
INSERT INTO cuk_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noé ibagugle (7) napi edarbisbalid, a-sorba gannar nuu barmisbalid. ");
INSERT INTO cuk_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Bato nue neg-mutikguali, nuu gannar nonikid. E-nugargi olivo-gagan senonikid. Agi, Noé nabir neg-nue-dingumaid mag daksad. ");
INSERT INTO cuk_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noé amba ibagugle (7) napi edarbisbalid, geb agi, gannar Noé nuu barmisbalid. Agindi, nuu Noéʼse bar gannar nonisulid. ");
INSERT INTO cuk_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Degidgine, Noé birga-dulataled-ilanergwa-gakagwensak-nikadgi (601), napneg nue dingusad. Nii-gebe-gwisguded-ibagwenadgi, Noé ur-dummad-e-uas earisad. Geb agi dakded, napa dingusnai. ");
INSERT INTO cuk_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nii-warbogwad-iba-dulagwen-gakagugledgi, napa nue-dingusad. ");
INSERT INTO cuk_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Geb degi, Bab-Dummad Noéʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Ur-dummadyaba-be-gudiid be nodago. Be-ome, be-masmala, degi, be-balagan beba nodamarmogo. ");
INSERT INTO cuk_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ibmar-dula-gudidimalad ur-dummadyaba-bukwad bela be onobalo: Nuumar, ibmar-durgan, degi, ibmar-durgan-napagi-garmakdimalad, adi, amar bela we-napneg-naid-ugakaase mimilemalagar. Deginbali, dula ichesur mergumalaga, we-napneg-naidgi bela ambikumalagar.” ");
INSERT INTO cuk_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Geb degine, ur-dummadyaba-bukwadgi nosmarsunnad: Noé, e-ome, e-masmala, degi, e-balamar. ");
INSERT INTO cuk_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bela ibmar-durgan ur-dummadyaba-bukmaladi na-egad-egad-balibimaladba, ainismarmogad: Bela ibmar-sapurbarmalad, degi, bela ibmar-durgan-akwilemalad, bela ibmar-durgan-napagi-garmakdimalad, bela nuumar, ur-dummadgi ainismalad. ");
INSERT INTO cuk_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Geb agine, Noé, Bab-Jehová-nug-odummogega, ibmar-ogumakar-ukleged-aila sobsad. Geb Noé bela ibmar-durgan-swilidikmalad, degi, nuumar-swilidikmalad akar-akar-ugakaase susad. Geb degine, ailagi ogumakar Bab-Jehováʼga uksad. ");
INSERT INTO cuk_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ibmar-ogumakaled-yeer-yapanned Bab-Jehováʼse-mosgu, Bab-Jehová sogded: “We-napneg dulemar-isgued-ular, bar an ukabsaosulid. Ar dulemar gusgu na sapingwagwad-akar e-gwagegi unnila isguedginbi binsadimalad. Degine, an emi-imaksadyob, muusailaba bela ibmar-dula-gudidiid bar an ogilogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Amba we-napneg-naidgi, ibmar diglegoed, ibmar welegoed, neg uere guoed, neg diopii guoed, yola-nii naguoed, dii-wied-nii naguoed, neg-ibgined naguoed, neg-mutikid nagubaloed. Bela wemar-ibmar nikagu guoed, sate guosulid.” ");
INSERT INTO cuk_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Bab-Dummad Noéʼgi, degi, e-masmalagi ise-nued binsasad. Weyob ega sogsad: “Mimmigan-bukidar be nikumar, we-napneggi dula be omelomar, bela we-napneg-ugakaase ambikumar. ");
INSERT INTO cuk_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bela we-napneggi ibmar-dula-gudidimalad be-dobedba bemar-asabin gwakidmaloed: Bela ibmar-durgan-gukumalad, bela ibmar-durgan-napaginmalad, bela ibmar-durgan-napagi-garmakdimalad, bela ibmar-durgan demarginmalad. Bela-a-ibmar-durgangi be obine gumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","”Bela ibmar-dulamalad, degi, gagan-araragana-sunna-gullemalad sunna bemar gunmaloed. Ani an bela bega uknaid. ");
INSERT INTO cuk_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","”San-abebiid, melle be gunmalo. Ar abegi burba-dulagued danikid. ");
INSERT INTO cuk_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ar ibmar-durgan be-oburgwisale, an we-ibdurgan oburgwemogoed. Dule, dule-oburgwismogale, amba oburgwilemogoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ar Bab-Dummad dule e-sunnague-obinnissoggu, dule-gwensak dule-oburgwisale, dule-baid a-dule-oburgwemogoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","”Bemardi mimmigan-bukidar nikumar. Be-mimmigan we-napneggi mergumai gusun.” ");
INSERT INTO cuk_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bab-Dummad Noéʼga, degi, e-masmalaga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nabir, ani an bemarbo, degi, be-waganmarbo an igar mesoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Degine, bela ibmar-dulamalad bemarba ur-dummadyagi-bukwa-ainisad: Nuumar, ibmar-durgan-sunna-akwilemalad, ibmar-durgan-sapurbarmalad. ”Bela we-ibmar-durgan-we-napneggi-bukmaladbo an igar mesoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","An-bemar-ebo-igar-mesoedi gwen gwagosulid: Bela dulemar, degine, bela ibmar-durgan muusailagi bar an ogilogosulid. We-napneg obelogega bar muusaila murosulid. ");
INSERT INTO cuk_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","”An bemar-ebo, degine, an bela ibmar-durganbo-igar-mesnaidi, degisadegu maiguoed. A-e-wilubgan weyob maiguoed: Sue maiguoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mogir-imbaba an sue-mesoedi, we-napnegbo an igar-mesoed-e-wilubga guoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","We-napneggi mogirmar-gutumakalile, an-sue mogir-imbaba megnonikoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Geb an nue-ebinsaoed, an bemarbo, degi, bela ibmar-durganbo igar mesisad. Bela ibmar-dulamalad-ogilogega, baid-muusaila-weyobid bar murosulid. ");
INSERT INTO cuk_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Mogir-imbaba sue megnonikile, an dakoed. Agi, ani, Bab-Dummad, bela dulemarbo, degine, bela ibmar-durgan-we-napneggi-bukmaladbo degisadegu-igar-mesisad an ebinsaoed. ");
INSERT INTO cuk_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","”We-napneggi bela dulemarbo, degi, ibmar-durganbo an igar-mesisadi, sue, e-wilubga guoed.” Deyob Bab-Dummad Noéʼga ibmar sogsad. ");
INSERT INTO cuk_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé-machimala ur-dummadyaba-nosmaladi, wemardo: Sem, Cam, Jafet. Camʼde, Canaán-e-babad. ");
INSERT INTO cuk_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Wemar-warbaagwad Noé-masmala gumalad. We-napneggi dulemar-bukmalad, belagwapa wemargi danimalad. ");
INSERT INTO cuk_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé napagi arbadgua, uva digsad. ");
INSERT INTO cuk_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ibagwengi, Noé vino gobsagu, mumgusad. Noé e-dordonegyaba uka-swiri meremai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Canaán-e-bab-Cam, e-bab-Noé uka-swiri-mai-daksagu, nodegusad. E-iamar-warbogwad-magaba-gwichidga sogdapid. ");
INSERT INTO cuk_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Geb degi, Sem, Jafet-ebo e-bab-edugega mor-dummad amismalad. Geb gukinba mor-dummad-gani sorsik-sorsik nadegusmalad. Baidsik ataknadapi gusmalad, adi, mer e-bab uka-swiri-maid dakegar. Geb a-mor-dummadgi e-bab-edusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noé nue-wibamasgu, atakalid. E-machi-bipigwad igi e-imaksa deyob, wisgusgu sogded: ");
INSERT INTO cuk_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“¡Canaán, be iwigusun! Be-iamar-e-mai-mesagwaledga be gusun.” ");
INSERT INTO cuk_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Geb degi, Noé sogdebalid: “Sem-e-Bab-Dummad-Jehová, a-e-nug odummolesun. Sem-maiga Canaán gudii gusun. ");
INSERT INTO cuk_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Bab-Dummad, Jafet-neg gatik nasgumai imakena gadin. Jafet, Sem-e-dordoneggi gudii gusun, degine, Canaán Jafet-maiga gusun.” ");
INSERT INTO cuk_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Muusaila-mulusad-sorba, Noé amba birga-dulataled-ilapaa gaka dulabo-gakambe (350) dula-gudii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Degisoggu, Noé, birga-dulataled-ilabakebak gaka dulabo-gakambe-nikadgi (950) burgwenonikid. ");
INSERT INTO cuk_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noé-masmala, wemalad: Sem, Cam, Jafet. Wemarde muusaila-mulusad-sorba, na mimmigan nikusmalad. Noé-masmala-e-wagan ambikusmalad, wemalad: ");
INSERT INTO cuk_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Jafet-masmala, wemalad: Gomer, Magog, Madai, Javán, Tubal, Mesec, degi, Tiras. ");
INSERT INTO cuk_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer-masmaladi, wemalad: Askenaz, Rifat, Togarma. ");
INSERT INTO cuk_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javán-masmaladi, wemalad: Elisa, Tarsis, Quitim, degi, Dodanim. ");
INSERT INTO cuk_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Wemar, Jafet-wagan gumalad. Wemar, demar-gakaba ambikusmalad. Gaya emar-emarbi sunmakmalad. Degine, na e-dadgan-e-dadganba, dulemar na emar-emar ambikusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cam-masmala, wemalad: Cus, Mizraim, Fut, degi, Canaán. ");
INSERT INTO cuk_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cus-masmaladi, wemalad: Seba, Havila, Sabta, Raama, degi, Sabteca. Raama-masmaladi, wemalad: Seba, Dedán. ");
INSERT INTO cuk_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cus, Nimrod-e-babad. Nimrod-insega we-napneggi nuga-nikad gusad, dule-dutusulid gusad. ");
INSERT INTO cuk_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nimrod, Bab-Jehová-nabir-egi-binsasadba sapurba ibmar-maked-dule gusad. A-ulale, weyob-sogleged: “Dule-Nimrodʼyob ibmar-maked-duleye.” ");
INSERT INTO cuk_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrod, we-neggweburmargi negsemai gusad: Babelʼgi, Erecʼgi, Acadʼgi, degi, Calneʼgi. We-neggweburmar, Sinar-yargi bukwagusad. ");
INSERT INTO cuk_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Geb Nimrod Sinar-yargi-nodegusgu, Asiria-yarse nadegusad. Agi, we-neggweburmar urbidapid: Nínive, Rehobot, Cala, degi, Resén. ");
INSERT INTO cuk_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Resén-neggwebur-dummad, Nínive, Cala-ebo-abingunaid-abargi siid. ");
INSERT INTO cuk_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim-wagan, wemalad: Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO cuk_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Casluhim, degi, Caftorim. Casluhim-dulegi Filistea-dulemar danikid. ");
INSERT INTO cuk_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaánʼdi, Sidón-e-babad. Sidónʼde, Canaán-machi-sailaginedid, geb degine, Hetʼye-nugad, baksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaán-wagan, wemalad: Jebuseo-dulemar, Amorreo-dulemar, Gergeseo-dulemar, ");
INSERT INTO cuk_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Heveo-dulemar, Araceo-dulemar, Sineo-dulemar, ");
INSERT INTO cuk_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvadeo-dulemar, Zemareo-dulemar, Hamateo-dulemar. Geb sorbali, Canaán-dulemar na e-dadgan-e-dadganba aisakidmalad. ");
INSERT INTO cuk_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Canaán-dulemar e-yar-gasadi, wemalad: Sidón-neggweburgi onoded, Gerar-yalasik, Gaza-neggweburse warmaksad. We-yar-e-neggweburmarde, wemalad: Sodoma, Gomorra, Adma, degine, Zeboimʼsik, Lasa-neggweburse. ");
INSERT INTO cuk_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Wemar, Cam-e-wagan gumalad. E-dadgan-e-dadganba, degine, gaya emar-emarbi-sunmake ambikusmalad. Yar-egad-egad, degine, dulemar emar-emarbi ambikusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Deginbali, Jafet-e-ia-Sem, machimala-nikusmogad. Heber-masmala, bela Sem-wagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem-masmala, wemalad: Elam, Asur, Arfaxad, Lud, degi, Aram. ");
INSERT INTO cuk_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram-masmaladi, wemalad: Uz, Hul, Geter, Mas. ");
INSERT INTO cuk_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad, Sala-e-babad. Salaʼdi, Heber-e-babad. ");
INSERT INTO cuk_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Heber machimala-warbo nikusmogad: Machi-sailagined Pelegʼye nugad. Ar ade, a-ibagangi dulemar aisakided. Peleg-e-urba, Joctánʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joctán-masmala, wemalad: Almodad, Selef, Hazarmavet, Jera, ");
INSERT INTO cuk_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO cuk_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO cuk_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, degi, Jobab. Wemar belagwapa, Joctán-machimala gued. ");
INSERT INTO cuk_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Wemar Sefar-yalagansik, Mesa-nadedgi, bukwagusmalad. We-yalagande dad-nakwedsik naid. ");
INSERT INTO cuk_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Wemar Sem-e-wagan gumalad. E-dadgan-e-dadganba, degine, gaya emar-emarbi-sunmake ambikusmalad. Yar-egad-egad, degine, dulemar emar-emarbi ambikusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Wemar, Noé-machimala, e-gwenadgan-e-gwenadganba ambikusmalad. Na e-wagan-e-wagan yar gasmalad. Wemar muusaila-mulusad-sorba, bela we-napneggi-aisakis ambikusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Epennegwa, bela dulemar unnila gaya-gwennaa sunmakmalanad. ");
INSERT INTO cuk_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Dad-nakwedsik dulemar nadgua, Sinarʼgi nebabi-nai dakdapid. Agi ambikudapmalad. ");
INSERT INTO cuk_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ibagwengi, na ga muchub-muchub sokarmalad: “Anmar dakebinne, anmar napa-ginnid akwayob dutusuli sobe, geb degine, anmar soogine ogumakar imakoed.” Weyob akwa-anar napa-ginnid-akwayob-dutusuli-sobaled ebusmalad, degine, barya ebusmarbalid, ebo acha-acha imakegar. ");
INSERT INTO cuk_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Geb a-sorba, sogdemarbalid: “Anmar dakebinne, anmar neggwebur-dummad sobmala. Geb neg-matusulid nibnegse-warmakedse, anmar sobbaloed. Anmar deyob imakele, bela anmar nug-nika gumaloed, dule-dummaganga anmar gumaloed, degine, adi, mer anmar we-napneggi aisakimalagar.” ");
INSERT INTO cuk_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Geb Bab-Jehováʼdi, dulemar-neggwebur-dummad-sobnanaid, degine, dulemar-neg-matusulid-sobnanaid-dakega aidenonikid. ");
INSERT INTO cuk_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Geb Bab-Jehová binsaded: “Wemar, unnila dulemar-soggwenna gued, unnila gaya-soggwenna sunmakmalad. We-arbaedgebe-imaklenaid-obelosmalale, sogdamarbaloed, arbaed-baid anmar imakmarbarye. Degisoggu, bar galegosurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","A-ulale, anmar aidenaergebed, ei gaya oburnaegar, adi, na aku itomaloed.” ");
INSERT INTO cuk_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Deyobi, Bab-Jehová belagwapa we-napneggi dulemar-osakisad. Degisoggu, we-neggwebur bar sobsasurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","We-neggweburgine, Bab-Jehová weyob dulemar gaya-akar-akar-sunmakega imaksad. A-ulale, we-neggwebur Babelʼye nuggusad. Geb wegine, Bab-Jehová bela dulemar we-napneg-ugakaase osakisad. ");
INSERT INTO cuk_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Wemar, Sem-e-wagan gumalad: Birgabogus muusaila-nasad-sorba, Sem-machi-Arfaxad gwalulesad. Deunni, Sem birga-dulatar (100) nikad. ");
INSERT INTO cuk_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A-sorbali, Sem birga-dulataled-ilatar (500) napi-gudii gusad. Sem machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaxad birga-dulagwen-gakambe-gakatar-nikadgi (35), e-machi-Sala gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A-sorbali, Arfaxad birga-dulataled-ilabake-gakapaa (403) napi-gudii gusad. Arfaxad machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala birga-dulagwen-gakambe-nikadgi (30), e-machi-Heber gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A-sorbali, Sala birga-dulataled-ilabake-gakapaa (403) napi-gudii gusad. Sala machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber birga-dulagwen-gakambe-gakabake-nikadgi (34), e-machi-Peleg gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A-sorbali, Heber birga-dulataled-ilabake gaka dulagwen-gakambe (430) napi-gudii gusad. Heber machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg birga-dulagwen-gakambe-nikadgi (30), e-machi-Reu gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A-sorbali, Peleg birga-dulataled-ilabo-gakabakebak (209) napi-gudii gusad. Peleg machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu birga-dulagwen-gakambe-gakabo-nikadgi (32), e-machi-Serug gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A-sorbali, Reu birga-dulataled-ilabo-gakagugle (207) napi-gudii gusad. Reu machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug birga-dulagwen-gakambe-nikadgi (30), e-machi-Nacor gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A-sorbali, Serug birga-dulataled-ilabo (200) napi-gudii gusad. Serug machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor birga-dulagwen-gakabakebak-nikadgi (29), e-machi-Taré gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A-sorbali, Nacor birga-dulatar-gakambe-gakabakebak (119) napi-gudii gusad. Nacor machimala-baigan nikusbalid, degine, bunamala nikusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taré bato birga-dulapaa-gakambe-nikadgi (70), e-masmala Abram, Nacor, degi, Harán gwalulesad. ");
INSERT INTO cuk_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","We, Taré-e-igar: Taré, Abram-e-babad. Nacor, degi, Harán amba Taré-masmalamogad. Haránʼde, Lot-e-babad. ");
INSERT INTO cuk_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Harán e-bab-Taré-iduar Caldea-dulemar-yargi, Ur-neggweburgi burgwisad. Urʼde Harán-gwalulesad-neggweburad. ");
INSERT INTO cuk_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram, Sarai-nikusad. Nacorʼdi, Milca-nikusad. Milcaʼde, degi, Isca, Harán-e-sisgan gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraiʼdi geg mimmi nikued, ar ade, gusgu muu-neggi geg mimmi-bake danikid. ");
INSERT INTO cuk_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taré Canaán-yarse-naega Caldea-dulemar-yargi Ur-neggweburgi noar gusad. Taré na eba wemar sear gusad: E-machi-Abram, e-wagwa-Lot Harán-machi, degine, e-bala-Sarai e-machi-Abram-ome. Degi-inigwele, Taré, Harán-neggweburse-mosgu, agi megidapmalad. ");
INSERT INTO cuk_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Geb Taré, Harán-neggweburgi birga-dulataled-ilabo-gakatar-nikadgi (205) burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ibagwengi, Bab-Jehová Abramʼse gornonikid, ega sognonikid: “Be-neggweburgi be noe, be-gwenadgangi be bangu, be-bab-neggi-be-gudiid be nae. An bega neg-oyogoedse be nae. ");
INSERT INTO cuk_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Begine, dulamar bukidar-mergue an imakoed. An begi ise-nued-binsaedgi, an bega ibmar imakoed. Dule-nue-nug-nikadga an be-imakoed. Degine, be-nuggi dulemargi ise-nued binsalemarmogoed. ");
INSERT INTO cuk_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Dulemar-ise-nued-begi-binsamaladgi, an ise-nued egi binsamogoed. Dulemar-be-ukabsamaladgi, an ukabsaar sunmakmogoed. Be-nuggi, bela dula-we-napneggi-bukwamaladgi ise-nued an binsaoed.” ");
INSERT INTO cuk_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram, Bab-Jehová-ega-sogsadba Harán-neggweburgi-maid nodegusad. Lot, Abramʼba nadegusmogad. Abram birga-dulapaa-gakambe-gakatar-nikadgi (75), Haránʼgi-mai noalid. ");
INSERT INTO cuk_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram Canaán-yalase-argua, wemar eba sealigusad: E-ome-Sarai, e-niga-Lot, e-maimar-Haránʼgi-amisad. Degine, na ibmar-nikad bela sealigusbalid. Abram, degi, eba-nadapmalad Canaán-yarse modapmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Geb Abram Canaán-yalagi dogded. Siquem-neggweburse warmakdapid, bia sapi-islidikid-Moreʼye-nugad-gwichidse. Deunni, a-yalagangine, Canaán-dulemala bukwamalad. ");
INSERT INTO cuk_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Agine, Bab-Jehová Abramʼse magarosad, ega sogded: “We-yar an be-waganga ukoed.” Agine, Abram Bab-Jehováʼga-ibmar-ogumakar-ukleged-aila sobsad, ar ade, Abram soged, Bab-Jehová wegi anse magarosaddeeye. ");
INSERT INTO cuk_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Geb agine, Abram yalagansik naded. We-yalagande Betel-neggweburgi dad-nakwedsik siid. Agi, dordoneg sidapid. Degisoggu, Betel-neggwebur egi dad-argwanedsik signonikid. Hai-neggweburdi dad-nakwedsik egi signonikid. Abram agi Bab-Jehováʼga-ibmar-ogumakar-ukleged-aila-baid sobsabalid. Geb degine, Bab-Jehováʼse agi gochasunnad. ");
INSERT INTO cuk_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Geb a-sorba, Abram Neguev-yalagansik binna-binna nadap gusad. ");
INSERT INTO cuk_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Deunni, a-ibagangine, bela Canaán-yargi ukud-dummad nagunonikid. Ar Abram na e-maidgi mas-satesoggu, Abram Egipto-yarse sikwas megnad gusad. ");
INSERT INTO cuk_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Abram Egipto-yarse warmakdanigu, e-ome-Saraiʼga sogded: “Omegwa, an wisdo, be yeerdakleged. ");
INSERT INTO cuk_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Degisoggu, Egipto-dulemar be-dakalile, sogdamaloed: ‘We-omegwa, we-machered-e-omeye.’ Andi an-oburgwemaloed, bedi be-oburgosurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Degisoggu, mer an-oburgwemalaga be sogodo, be an-bunye. Adi, be-ular anga ibmar bela nueganbi guegar.” ");
INSERT INTO cuk_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram Egipto-yarse modapgu, Egipto-dulemar dakalid, Sarai bela-bela yeerdaklege. ");
INSERT INTO cuk_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Dummagan-Faraónʼga-arbamalad daksamarmogad, Sarai yeerdaklege. Amar Faraónʼse nadegusmalad, ega sogdapmalad, ome bela-bela yeerdakleye. Wemar-dummagan Faraón-negse Sarai-sesa gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Sarai-ulale, Faraón Abram-nued-akwisad. Sibad-wawaadmar, moli-bebe-nikamalad, moli-uayasuid-machergan, moli-uayasuid-omegan, mai-machergan, mai-omegan, degine, moli-yargan-muremalad Abramʼga uksad. ");
INSERT INTO cuk_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Degine, Faraón e-negse Abram-e-ome-Sarai-sesad-ulale, Bab-Jehováʼdi Faraón, degi, e-negyaginmalad-sabsur-odurdaksad, boni-dummagan ega uksad. ");
INSERT INTO cuk_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","A-ulale, Faraón Abramʼse gochad, ega sogded: “¿Ibiga wede deyob be an-imaksa? ¿Ibiga be anga sogsasuli, we-omegwa an-omeye? ");
INSERT INTO cuk_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Emide, be anga sogsad, we-ome, an-bunye. Ar emide sunna an-omega an imaked-nagad. ¡Be-ome na be sede! ¡Be nae!” ");
INSERT INTO cuk_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Geb degine, Faraón na e-sordamarga igar-uksad, Abram, e-ome, degi, bela ibmar-nikad sedoye, Egipto-yargi-naed imakoye. ");
INSERT INTO cuk_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram Egipto-yargi-noargu, e-ome, degi, bela na ibmar-nikadi sealid. E-niga-Lot eba aligusmogad. Amar Neguev-yalaganse gannar nonimalad. ");
INSERT INTO cuk_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ar Abram ibmar-durgan-bukidar-nika nonikid, mani-bukidar, degi, or-bukidar-nika nonikid. Degisoggu, dule-mani-ibedga gusad. ");
INSERT INTO cuk_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Neguev-akar, Abram gannar binna-binna alid. Betel-neggweburse geb warmakdapid. Geb degi, gannar naded, bia gebe na dordoneg sisagusadse. We-negde Betel-negabargi, degi, Hai-negabargi siid. ");
INSERT INTO cuk_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Agine, deunni, Abram Bab-Jehováʼga-ibmar-ogumakar-ukleged-aila sobsa gusad. Agine, Abram Bab-Jehováʼse gocha gusad. ");
INSERT INTO cuk_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot amba dule-mani-ibedmogad. E-gilor-Abramʼyob sibad-wawaadmar, moli-bebe-nikamalad, degi, dordonegmar nikamogad. ");
INSERT INTO cuk_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ar emar-mamaidgi, ibmar-durgan bukidar nikamarsoggu, ibmar-durganga mas unnisuli gualid. A-ular, Abram, Lot-ebogwa geg na walikaa gudigue guarmalad. ");
INSERT INTO cuk_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Molimarga mas unnisulidba, Abramʼga-dule-moli-bebe-nikad-akwemalad, Lotʼga-dule-moli-bebe-nikad-akwemalad-ebo na uluardamalad. Aginbali, a-ibagangine, Canaán-dulemar, degi, Ferezeo-dulemar a-yargine amba bukwamarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ibagwengi Abram Lotʼga sokalid: “Anmar na gwenadgan gumalad. Degisoggu, anmar na boni-nika gudiile, ibnuedsulid. Degi, anga-moli-bebe-nikad-edarbemalad, bega-moli-bebe-nikad-edarbemarmogadbogwa urwemarmogale, we ibnuedsurbalid. ");
INSERT INTO cuk_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Emi be dakena, napa unniguar be-asabin naid. Degisoggu, be-abegedba na be sudo, igid bur be suoe. Degisoggu, angi be bangusun. Ar be argan-sapiledsik naye be sogele, andi argan-nuedsik naoed. Argan-nuedsik be naye sogele, andi argan-sapiledsik naoed.” ");
INSERT INTO cuk_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot bela Jordán-diwarsik Zoar-neggweburse neba-naid dakded. A-nebagi dii nue-nika, degine, Bab-Jehová-nainu-nuedyob-daklege dakalid. E-daklegedde Egipto-yaryob daklebalid. Ar Bab-Jehová Sodoma-neggwebur, degi, Gomorra-neggwebur-obelogoed-iduale, we-neggweburmar yeer daklegenad. ");
INSERT INTO cuk_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Geb degine, Lot bela Jordán-diwarsik-neba-naid susad. Na e-maidgi dad-nakwedsik nade gusad. Weyobi, Abram, Lot-ebogwa, na bangud gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abramʼdi, Canaán-yalagi besad. Lotʼdi, nade gusad. Nebagi neggweburmar-bukwadse megnade gusad. Geb Lot Sodoma-neggwebur-waliksaar e-dordornegmar sisad. ");
INSERT INTO cuk_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomaʼgi dulemar-bukwad bela-bela isgana nanaed, isgued-dummagan Bab-Jehová-asabin imakdimalad. ");
INSERT INTO cuk_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot Abramʼgi-bangusad-sorba, Bab-Jehová Abramʼga sokalid: “Be-maidgi be dad-nakwedsik, dad-argwanedsik, dad-nakwed-argan-nuedsik, dad-nakwed-argan-sapiledsik nue be neg dako. ");
INSERT INTO cuk_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","We-napnegmar be dakedi, bela bega an ukoed. We-yalagan begadga degi, be-wagangadga degisadegu guoed. ");
INSERT INTO cuk_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ukubyob be-wagan yaisur-mergu, an imakoed. Ar igi ukub geg ebislege, deyobi, be-wagan geg ebisle gumogoed. ");
INSERT INTO cuk_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Degisoggu, emisgindi, bela we-yalaganba be nae, ar we-yala an bega ukoed.” ");
INSERT INTO cuk_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Geb degine, Abram nade gudsunnad, e-dordonegmar-siid sesa gusad. Abram Hebrón-neggwebur-walik megnaded, sapi-islidikmalad-Mamreʼgi-bukwadse. Agi, Abram Bab-Jehová-nuggi, Bab-Jehováʼga-ibmar-ogumakar-ukleged-aila sobsad. ");
INSERT INTO cuk_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Deunni, we-reymar negdakmamaid: Sinar-e-rey-Amrafel, Elasar-e-rey-Arioc, Elam-e-rey-Quedorlaomer, degi, Goim-e-rey-Tidal, wemar, neg-dakmaid. ");
INSERT INTO cuk_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","A-ibagangi, deunni, we-reymar-walabakegwad, baigan-reymar-ataled-ebo bila-onogega na atosmalad. We-reymar-walataled atosmarmogad: Sodoma-e-rey-Bera, Gomorra-e-rey-Birsa, Adma-e-rey-Sinab, Zeboim-e-rey-Semeber, degi, Bela-e-rey. We-Bela-neggweburde, Zoarʼye nugbalid. ");
INSERT INTO cuk_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Wemar-e-ataled, e-sordamar Sidim-nebagi urbisad, Demar-Gagbidye-nugad-walik. ");
INSERT INTO cuk_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Rey-Quedorlaomer birgambe-gakabogus (12) we-reymar-walataled-e-dummadga-gudigu, we-reymar-walataled birgambe-gakapaagusgu (13), sogdemalad: “Anmar we-rey-Quedorlaomerʼgi gwisguergeboye.” ");
INSERT INTO cuk_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Birgagwen-nasad-sorba, Quedorlaomer, degine, reymar-eba-nanaimalad Astarot-Karnaim-yalagansik bila-ononadmalad. Agine Refa-dulemargi nakwismalad. A-sorba, Hamʼgi Zuz-dulemargi nakwismalad. Geb Save-Quiriataimʼgi Emita-dulemargi nakwismalad. ");
INSERT INTO cuk_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Seir-yalagangindi Horí-dulemargi nakwismalad, Parán-nebase baregichamalad. We-Paránʼde nega-dulesulid-walik naid. ");
INSERT INTO cuk_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Quedorlaomer, degine, reymar-eba-gudidimalad we-dulemar-sogabakegwadgi-nakwisgu, gannar aibiris armalad. Geb Enmispatʼye-neg-nugadse nonimalad. We-Enmispatʼde, Cadesʼye nugbalid. Rey-Quedorlaomer, degi, reymar-eba-gudidimalad Amalec-dulemar-yalaganba bela ibmar obelonadap gusmalad. Deyob Amorreo-dulemar-imaksamarbalid. We-Amorreo-dulemarde Hazezon-Tamar-yalagangi bukwamalanad. ");
INSERT INTO cuk_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Geb degine, Sodoma-e-rey, Gomorra-e-rey, Adma-e-rey, Zeboim-e-rey, Bela-e-rey, bila-onomalaga, Sidim-nebase nonimalad. Bela-neggweburde, Zoarʼye nugbalid. ");
INSERT INTO cuk_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Agi, we-reymar-e-ataled, baigan-reymar-warbakegwadbo uludmalad. Ebo-ulusmaladi, wemalad: Elam-e-rey-Quedorlaomer, Goim-e-rey-Tidal, Sinar-e-rey-Amrafel, degi, Elasar-e-rey-Arioc, we-reymar ulusmaladid. ");
INSERT INTO cuk_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dakargua, bela Sidim-nebagi yaa-dummagan-bukidar-bukwa nanaed. We-yaa-dummagande barya-yaisur nikad. Sodoma-e-rey, degi, Gomorra-e-rey urwenanaigua, wakite gusmalanad. Degi-inigwele, yaa-dummadgi argwatapmalad. E-sordamar-baigandi yalaganba wakitemalad. ");
INSERT INTO cuk_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Reymar-nakwismaladi, Sodoma-neggweburgi, degi, Gomorra-neggweburgi, bela masgullemalad, degi, bela ibmar-nuegan sesmalad. ");
INSERT INTO cuk_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ar Abram-niga-Lot, Sodomaʼgi-maimosoggu, reymar-nakwisad Lot-sesa gusmarmogad, degi, bela e-ibmar-nikad e-ibe sesa gusmarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ar dule-wargwen nabir wakichasoggu, Abramʼga bela ibmar sognonikid. Abramʼde Hebreo-duled. Abramʼde Amorreo-dule-e-sapi-dummagan-walik maid. We-Amorreo-dulede Mamreʼye nugad. Mamreʼdi, gwenadgan nikad, amarde wemalad: Escol, Aner. Wemala, Abramʼba naimaladid. ");
INSERT INTO cuk_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram itoargu e-niga gales-selesye, geb e-maimar-e-neg-yagi-gwalulesmaladse gochad. Wemarde bila-onomaladid. Belagwapa dulataled-ilapaa gakambe-gakabaabak (318) mergued. Amarmala, Dan-neggweburse reymar-Lot-gasa-sesmalad-balegitemalad. ");
INSERT INTO cuk_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abram, dulemar-eba-nadapmalad danar-danar oambikusgu, mutikidba ukiar reymargi ubodapmalad. Abram, degi, e-sordamarmala, emargi nakwismargu, we-reymar-wakitemalad Hoba-neggweburse balegichamalad. Hobaʼde Damasco-neggwebur-dad-nakwed-argan-sapiledsik siid. ");
INSERT INTO cuk_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","We-reymar-ibmar-sesadi, Abram bela gannar susad. Deyobi, Abram e-niga-Lot-galesad onosad, degi, bela gannar Lot-e-ibmar susbalid. Deginbali, omegan-onosbalid, degi, bela dule-baigan-galesmalad amba onosbalid. ");
INSERT INTO cuk_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram Quedorlaomerʼgi, degi, Quedorlaomerʼba-reymar-gudidimaladgi nakwis-danigua, Sodoma-e-rey, Save-neba-naidgi Abram-abindakega abin noalid. Save-nebade Rey-Nebaye nugbalid. ");
INSERT INTO cuk_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Geb degine, Salem-e-rey-Melquisedec, madu, degi, vino Abramʼga senonikid. We-Melquisedecʼde dule-irwa-Bab-Dummad-Bur-Biriginedse-goledid. ");
INSERT INTO cuk_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Geb degine, Melquisedec, Abramʼgi ise-nued-binsaedgi, weyob sogded: “Abram, Bab-Dummad-Bur-Birigined begi ise-nued binsaoed. We-Bab-Dummad, nibneg, degi, napneg bela obinnisadid. ");
INSERT INTO cuk_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Bab-Dummad-Bur-Birigined-e-nug odummolesun. A-Bab-Dummad be-isdarmaladgi-nakwega be-imaksad.” Geb degine, Abram bela ibmar-gannar-susadi, yopira-emarbi-sogambegi (10) mamarisad. A-gwensak Melquisedecʼga uksad (10%). ");
INSERT INTO cuk_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Geb degine, Sodoma-e-rey Abramʼga sogded: —Dulemarbi be anga udage. Ibmarmardi be sue. ");
INSERT INTO cuk_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ar Abramʼdi abin-sogded: —Suli. Bab-Dummad-Bur-Birigined-Jehováʼga ise-sogar an imaksad. We-Bab-Dummadde nibneg, degi, napneg bela obinnisad. ");
INSERT INTO cuk_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Aga, an sogsad: ‘Bipisaale ibmar an be-ibe suosurye, dubamar, degi, sapat-dubse-bakar, an-nag-uka-edinnega gwen an bei suosurye. Adi, melle be an-annik sogega, an we-dule mani-ibedga imaksaye.’ ");
INSERT INTO cuk_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Andi an ibmar abesulid. Unnila sapingana-anba-gudidimalad-e-mas-guchamaladbi anga unnigualed. Degine, dule-anba-arbimalad, Aner, Escol, degi, Mamre, amardi igar-maidba ibmar sumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Weyob-gusad-sorbali, Abram negburgan-daksad. Agi, Bab-Jehová ega sunmakded, ega sogded: “Abram, melle be dobguo, ar sigu-abgaedyobi, an be-irwa gwisgudioed. Degine, bega-ibmar-nued-uklegoedi, bega ibmar-dummadga guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram Bab-Jehová-abin sogded: —Bab-Jehová-Bela-Negsemaid, ar be wisid, an mimmigan-sated, degite, ibmar-dummad be anga ukoye sogedi, ¿ar wede ibi-nuedga anga guosunna? Degisoggu, bela-an-ibmar-nikadi, we-anga-neg-daked-Damasco-dule-Eliezer, an-sorba bela ibmar gaoed. ");
INSERT INTO cuk_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram sogdebalid: —Ar be anga mimmi-uksasursoggu, anga-arbaed-dule an-sorba bela ibmar gasunnoed. ");
INSERT INTO cuk_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Bab-Jehová Abram-abin sogded: —Suli, degisuli. Be-sorba ibmar-bela-gaoedi, be-machi-sunnad bela be-ibmar gaoed. We-Eliezerʼdi suli. ");
INSERT INTO cuk_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Geb degine, Bab-Jehová magaba Abram-sesad, ega sogded: —Nue be niba atake, be niisgwamar ebise, ar sunna be ebisodibe. Weyob-mergu wagan be nikuoed. ");
INSERT INTO cuk_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram, Bab-Jehová-ega-ibmar-soged gwen bengussulid. Degisoggu, a-ulale, Bab-Jehová, dule-isgussulidyob Abram-daknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Bab-Jehová Abramʼga sogded: —Ani an Bab-Jehová gued. Caldea-dulemar-yargi Ur-neggweburgi be-maigu, ani an be-onosad, adi, we-yar an bega ukega, degi, begadga guegar. ");
INSERT INTO cuk_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram Bab-Jehová-abin sogded: —Bab-Jehová-Bela-Negsemaid, degite, ¿igi nue an wisguosunna, we-yarde nue angadga guoe? ");
INSERT INTO cuk_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Bab-Jehová abin-sogded: —Anga be we-ibmar sedagoed: Moli-bebe-nikad-ome-birgapaagwad, sibad-birgapaagwad, sibad-wawaad-machered-birgapaagwad, sapur-nuu-gwagwen, degi, wagnuu-e-mimmi-gwagwen be anga sedabalo. ");
INSERT INTO cuk_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram bela we-ibmar-durgan Bab-Jehováʼga senonikid. Geb amar negabala-daasa marisad. Geb degi, asabin-asabin mesisad. Nuumardi marissulid, gwagwar mesisad. ");
INSERT INTO cuk_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Geb mulamala we-ibmar-durgan-burgwarmaladse duurmaknonikid. Ar Abramʼdi we-mulamar-ononnonai gualid. ");
INSERT INTO cuk_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Neg-mutikguargu, Abramʼgi bela-bela gabed gwichigunonikid. Ukiar, negsichid bela Abram-ebilis nagusad. Agine, nue dobe itoalid. ");
INSERT INTO cuk_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Geb degine, Bab-Jehová Abramʼga sogded: —Nue be wisguergebed, be-wagan e-yarsulidgi gudii gumaloed. Agi maiganga gumaloed, degine, a-yargi birga-dulataled-ilabake (400) sabsuli be-wagan-wiomaloed. ");
INSERT INTO cuk_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Dulemar-be-wagan-maiga-imakoedi, ani, an sabsur-odurdakoed. Agi, be-wagan ainidamalogu, ibmarmar-nuegan nue-nika ainidamaloed. ");
INSERT INTO cuk_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ar bedina nue-sered-mai be burgoed, degine, nue-bogidikidgi be diglegoed. ");
INSERT INTO cuk_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ar emigindi, amba yoo Amorreo-dulemala bela-bela isgumarsoggu, be-wagan ilabakegus-gwagedgi, geb we-yarse be-wagan gannar nonikoed. ");
INSERT INTO cuk_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Bato neg-mutikgusgu, bela-bela bato negsichinadedgi, sianargi waa bupurmaksii daklealid. Degine, acha-gwallu-gamai daklearbalid. A-sianar, degi, a-gwallu ibmar-durgan-negabar-maraled-bukwad-abargi nadapid. ");
INSERT INTO cuk_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","A-ibagi, Bab-Jehová Abram-ebo igar mesisad. Agi Abramʼga sogded: —We-yala be-waganga an ukoed, Egipto-diwar-maid-akar, diwar-dummad-Éufrates maidse. ");
INSERT INTO cuk_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Yarmar an bega sogedi, wemardo: Ceneo-dulemar-bukwad-yala, Cenezeo-dulemar-bukwad-yala, Cadmoneo-dulemar-bukwad-yala, ");
INSERT INTO cuk_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het-dulemar-bukwad-yala, Ferezeo-dulemar-bukwad-yala, Refa-dulemar-bukwad-yala, ");
INSERT INTO cuk_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorreo-dulemar-bukwad-yala, Canaán-dulemar-bukwad-yala, Gergeseo-dulemar-bukwad-yala, Jebuseo-dulemar-bukwad-yala, bela we-yalamala an be-waganga ukoed. ");
INSERT INTO cuk_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai e-sui-Abramʼga geg mimmi bake gusad. Saraiʼde e-mai-Egiptoʼgined nikad, Agarʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Geb Sarai, Abramʼga sogded: —Bab-Jehová geg goe-bake an-imaksad. Degisoggu, an bese wilesakwaa egissundo, bunagwa an-maiga-gudiidse be gole. Abakale a-omebali, an mimmi nikualile. Abram Sarai-ega-soged nabir itosad. ");
INSERT INTO cuk_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Deunni, Abram birgambegus (10) Canaán-yargi maid. Geb a-ibagangine, Sarai bunagwa-Egiptoʼgined-Agarʼye-nugad, Abramʼga urmaksad, ese golegar. ");
INSERT INTO cuk_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram Agarʼse-gochagu, Agar gurgin-nika gunonikid. Agar gurgin-nikagudi-itoargu, e-dummad-Sarai-ibgwensur dakded. ");
INSERT INTO cuk_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Geb degine, Sarai Abramʼga sogded: —¡Be-ular, emide, Agar ibgwensur an-dakalid! An-sunnad an bega Agar-urmaksad, ese be golegar. Ar emide, mimmi-nikuo-itogedba, anba bur dummarba san-imaked. Emigindi, Bab-Jehová sogoed, wede doagi ataklegoe: Begine, igi angine. ");
INSERT INTO cuk_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Geb degine, Abram Sarai-abin sogded: —Be-itoleged, be-mai begi siid. Ar igi be Agar imakbie, be imakodo. Geb degine, Sarai sabsur Agar-imakalid. Degisoggu, a-ular, Agar wakitesunnad. ");
INSERT INTO cuk_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ar Bab-Jehová-e-baliwitur nega-dulesulidganba, Shur-igar-maidsik dii-saila-siidgi Agar-abingualid. ");
INSERT INTO cuk_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Bab-e-baliwitur Agarʼse egichialid: —Sarai-e-mai-Agar, ¿bia be daniki? ¿Bia be nae? Agar abin-sogded: —An-dummad-Sarai-idu an wakinmai. ");
INSERT INTO cuk_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Geb degine, Bab-Jehová-baliwitur ega sogded: —Be-dummadse gannar be nae. Ar igi bega sogdagoe, bela aba be ibmar imako. ");
INSERT INTO cuk_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Aginbali, Bab-Jehová-baliwitur Agarʼga sogdebalid: “Be-wagan bela-bela an omelogoed. Degisoggu, geg dule ebise guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Bab-Jehová-baliwitur sogdebalid: “Be bonigwar-gudiidi, susugwa be nikuoed. Bab-Jehová be-wilediid itossoggu, we-machigwa Ismaelʼye be onugsaoed. ");
INSERT INTO cuk_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","We-machigwade yaisurdae guoed, moli-uayasuid-sapurbalidyob guoed. We-machi dulemar-baiganbo bela urwoed, degi, bela-dulemar-baigan ebo urwemarmogoed. Degine, e-gwenadgangi gwisgubalo-inigwele, e-gwenadgan-abargi-mai guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ar Agarʼde Bab-Jehová-ebo sunmaksasoggu, Bab-Dummad an-dakmaidye neg onugsasad. Ar ade soged, Bab-Dummad-an-daksaye. Degite, amba an dula-gudiiye. ");
INSERT INTO cuk_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","A-ulale, dia nugad, Dia-Dule-Dulad-An-Dakmaidye. We-diadega Cades, degi, Bered-ebo-abingunaid-abargi siid. ");
INSERT INTO cuk_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Geb degine, omegwa-Agar, Abramʼga machigwa baknonikid. Geb Abram, a-machigwa Ismaelʼye onug-imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ismael gwalulenonigua, deunni, Abram birga-dulabake-gakanergwa (86) nikad. ");
INSERT INTO cuk_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram birga-dulabake-gakambe-gakabakebak-nikadgine (99), Bab-Jehová ese magarononikid, ega sognonikid: —Ani, an Bab-Dummad-Bela-Gangued-Nikadid. An-sogedba be nue-innikii nanadii guo. ");
INSERT INTO cuk_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","An bebo igar-mesisad, gannar an bega sogbar: ‘Wagan-bukidar-nikuega an be-imakoed.’ ");
INSERT INTO cuk_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Geb degine, Abram Bab-Dummad-asabin napase e-bebe-ebulegedse dulluu imaksad. Bab-Dummaddi ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Weyob an bebogwa igar-mesoed: Be, dule-yar-baid-baidgi-ambikumaloed-e-dad-dummadga an be-imakoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ar dulemar-yar-baid-baidgi-ambikumaloed-e-dad-dummadga an be-imakosoggu, be bar Abramʼye nugguosulid. Emi-onodoedgine, Abrahamʼye be nugguoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Wagan-bukidar-nikuega an be-imakoed. Begine, reymar ainidagoed, degine, yar-baid-baidgi be-waganmar-bukwa an imakoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Degisadegu, an bebo igar-mesoed, degine, yoedse be-wagan-ebo an igar mesbaloed. Ani, an degisadegu be-Bab-Dummadga guoed. Degine, be-sorba be-wagan-e-Bab-Dummadga degisadegu an gubaloed. ");
INSERT INTO cuk_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Emi, Canaán-yala be-yalasur-inigwele, degite, a-yalagi be garmakdiid. We-Canaán-yalade, bela degisadegu an bega uked, degi, be-sorba, be-waganga an ukbaloed. A-yalade, degisadegu bemargadga guoed. Deginbali, ani, an be-wagan-e-Bab-Dummadga gubaloed. ");
INSERT INTO cuk_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Deginbali, Bab-Dummad Abrahamʼga sogdebalid: —Be, degi, bela be-wagan degisadegu anbo-igar-mesnaidba be nanamalo. ");
INSERT INTO cuk_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Weyob an bebogwa igar-mesnaid, be-wagan we-igar-mesnaidba imakmarmogoed: ‘Bela bemar-abargine, masmala e-abgan-uka-duku sikmaloed.’ ");
INSERT INTO cuk_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","”Bemala be-abgan-uka-duku sikergebed. Weyob we-ibmar-imakedgi bemar-anbogwa-igar-mesisad mag daklegoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Emi-ibagan-onodoedgi, bela masmala, ibabaabakgus (8) gwalulegedgi e-abgan-uka-duku ega siklegoed. Deyob degibi be-wagan be imakmarmogoed. Be-wagansurmalad amba deyob imakmarmogoed. Be-mai be-neggi gwalulesaddibe, be-mai manigi be dule-baidse baksaddibe, amba deyob be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Be-mai be-neggi-gwalulesaddibe, be-mai manigi be dule-baidse baksaddibe, wemar e-abgan-uka-duku-siksuli be imakosulid. Weyob an bemar-ebo igar-mesnaid be-abgangi degisadegu mag daklegoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","”Ar dule e-abgan-uka-duku siksulile, we-dule bemar-abargi onolegergebed. Ar bemarbo an-igar-mesisad-sogedba imaksasulid agala onolegergebed.” ");
INSERT INTO cuk_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Geb degine, Bab-Dummad Abrahamʼga sogdebalid: —Be-ome bar Saraiʼye nugguosulid. Emi-onodoedgine, Saraʼye nugguoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Be-omegi ise-nued an binsaoed. Bemarga machigwa an ukoed. Eye, napiragwa, be-omegi ise-nued an binsaoed. Sara dulemar-yar-baid-baidgi-ambikumaloed-e-nanaga guoed, degine, e-wagana dulemar-e-reyga gumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham napase e-bebe-ebugedse dulluu imaksad, geb allided. Agi, binsaded: “¿Ar wede dule-birga-dulatar-nikad (100) sunna babga gusi? ¿Ar wede Sara birga-dulabake-gakambe-nikadgi (90) sunna nanga gusi?” ");
INSERT INTO cuk_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Geb degi, Abraham Bab-Dummadga sogded: —¡Bitigi Ismaelʼgi be nued binsaena gadin! An-sorba bela an-ibmarmar Ismaelʼgadga guena gadin. ");
INSERT INTO cuk_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Bab-Dummad Abraham-abin sogded: —Suli. Deyob guosuli. Ar an bega soged, be-ome-Sara bega mimmi bakoye. A-machigwa Isaacʼye be onugsao. An bebo-igar-mesisadi, be-machigwa-Isaac-ebo gannar we-igar an obinogoed. Ar degisadegu Isaac-e-wagan-ebo we-igar mai guoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","”Emi, be-machi-Ismaelʼga be ibmar-egichisadi, an be-itosbalid. Be-machi-Ismaelʼgine ise-nued an binsamogoed. Mimmigan-bukidar-nikuega an imakoed, degine, wagan-bukidar-merguega an imakbaloed. Ismael, dule-dummagan-nuga-nikamalad e-ambe-gakabogwad-e-dadga (12) an imakoed, degine, e-dulamar ichesur an imakoed. ");
INSERT INTO cuk_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","An-bebo-igar-mesisaddina, Isaac-ebogwa igar-maigu an imakoed. Sara birgagwense we-ibaganse bega mimmi bakoed.” ");
INSERT INTO cuk_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Bab-Dummad Abraham-ebo-sunmaknaid-bergusgua, nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","A-ibagi-gines, Abraham e-machi-Ismael-e-abgan-uka-duku siksad. Ar igi Bab-Dummad ega sogsa, bela e-maimar-e-neggi-gwalulesmalad, bela e-maimar manigi-baklesad, degi, belagwable machergan-e-neguyagi-gudidimalad e-abgan-uka-duku-sikega imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham birga-dulabake-gakambe-gakabakebak-nikadgi (99), e-abgan-uka-duku siksad. ");
INSERT INTO cuk_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismaelʼdi birgambe-gakapaa-nikadgi (13), e-abgan-uka-duku ega siksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham, degi, e-machi-Ismael-ebo iba-galagwen abgan-uka-duku-siked-igar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Machergan-bela-Abraham-neguyagi-gudidimalad, e-maimar-e-neg-yagi-gwalulesmalad, dule-baidse maimar-manigi-baklesad, amar Abrahamʼba belagwable abgan-uka-duku-siked-igar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Bab-Jehová sapimar-islidikmalad-Mamreʼgi-gwichid-dikarba Abrahamʼse magarosad. Deunni, yorukudba, Abraham e-dordoneg-yawagakgi siid. ");
INSERT INTO cuk_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham atakdegu, dakded, machergan-walapaa gwichi. Deyob dakdegu, Abraham abindaknaega gwichibin imaksad. Ese modapgu, a-dulemar-abin napase e-bebe-ebulegedse dulluu imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Abraham amarga sogded: —An-dummad, an bese ise-wilesakwaa egised, melle be bakar nao. An-negse be obunnoda. ");
INSERT INTO cuk_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ar be nabir-itogele, an bemarga dii aminao, adi, bemar nag-enukegar. Geb a-sorba, bemar sapi-urba obunnonamaloed. ");
INSERT INTO cuk_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ar bemar an-neg-maid-walik-nadapsoggu, an bemar-ogannogega bemar-naed-idu an bemarga masgunned sunaoed. Dule-warbaagwad abin-sogdemalad: —Nueddo. Be-sogedbardo. ");
INSERT INTO cuk_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham gwae-gwae e-dordonegyaba-dogdegu, e-ome-Saraʼga sogded: —¡Gwaegwa! Madubur-bur-nued, nued-mergu madu-sobega be sue. ");
INSERT INTO cuk_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Geb degi, Abraham, moli-bebe-nikamalad-bukwadse abarmakdebalid. Moli-senigwad-bur-nued, bur-san-dutugwad susad. Geb degine, dule-ega-arbaedgala uksad. Geb a-dulede, gwae yog duar-imaksad, adi, mas-gunmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abraham we-dulemar-warbaagwadga moli-san uksad, moli-nunis uksabalid. Geb degine, moli-nunis-gwamakaled ega uksabalid. Abrahamʼdi amar-sapi-urba-mas-gunbukwad, daksii gusad. Abakalegi ibmar-baigan abearbalirye binsaed. ");
INSERT INTO cuk_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Geb dulemar-warbaagwadi Abrahamʼse egichiarmalad: —¿Bia be-ome-Sara nade? Abraham abin-sogded: —Dordonegyaba gunai. ");
INSERT INTO cuk_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Geb degi, warbaagwad-wargwen sogded: —Baid-birgase gannar an bese nonibaloed. A-ibagangi, be-ome-Sara bato susugwa-nika gudioed. Ar Saraʼdi, neg-dogedyaba Abraham-yarganba dulemar-Abraham-ebo-sunmaknanaid bela itogwichid. ");
INSERT INTO cuk_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Dakleargua, Abraham, degi, Sara, bato nue selebagusmalad. Deginbali, Sara bato wagub-guchabalid. ");
INSERT INTO cuk_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","A-ulale, Sara allided, ulubgi binsaded: “Bato ande selebagusad, degi, an-suide selebagusmogad. Wegiid an bar dakosur-itole. ¿Ar wede sunna an bar mimmi nikuosi? Geg bar an nikued.” ");
INSERT INTO cuk_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ar Bab-Jehováʼdi, Abrahamʼga sogded: —¿Ar ibiga Sara alle? ¿Ar ede seredgussoggu, geg bar mimmi-nikuye binsade? ");
INSERT INTO cuk_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Ar Bab-Jehováʼga ibmar-geg-gued nikasi? Suli. Baid-birgase gannar an bese ataknonibaloed. A-ibagangine, Sara machi-wargwen bato nikuoed. ");
INSERT INTO cuk_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara Bab-Jehová-weyob-ibmar-soge-itoargu, Sara dobe-itoded. A-ular, osuloded, sogded: —An alle-gwissuli. Ar Bab-Jehováʼdi abin-sogded: —¡Suli! Be allisa. ");
INSERT INTO cuk_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Geb a-sorba, dulemar-warbaagwad gwisgusmargu, Sodoma-neggwebursik atakdemalad. Geb degi, asik nadmarsunnad. Abraham sikwas eba nade gusmogad, adi, amarga sogega, degimaloye. ");
INSERT INTO cuk_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Geb degine, Bab-Jehová binsaded: “¿Ar an ibmar-imaksokalid Abrahamʼgi an odukuode? ");
INSERT INTO cuk_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahamʼde dulemar-bukidarad-e-babga guosoggu, degine, dulemar-dutusulid-e-babga gubalosoggu, an ibmar-imaksokalid an ega sogergebed. Deginbali, an ega sogsabalid: ‘Begi bela we-napneggi yar-baid-baidgi-bukmaladgi an ise-nued binsaoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Deginbali, Abraham an susbalid, adi, an-igar-maidba e-mimmigan-odurdakega, degi, e-wagan-odurdakega, adi, igar-nueganba nanamalaga, degine, igar-innikigwadbi imakdii gumalagar. ”Adi, an Abrahamʼga ibmar-imakoye-sogsadba, an imakegar.” ");
INSERT INTO cuk_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Degisoggu, Bab-Jehová Abrahamʼga sogded: —Dulemar-e-isgued doggus wilub-obichagusad, anse binnasur gorbukmalad, sogdemalad: Sodoma-neggweburgi-bukwamaladi, degi, Gomorra-neggweburgi-bukmaladi, nue-galagwensur damalad, degine, nue-bela-belad isgus bukmalad. ");
INSERT INTO cuk_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Degisoggu, neggweburse an amar-daknadapid, ar bule anga nabir sogmala. Ar degisulile, an-sunnad an nue-dakoed. ");
INSERT INTO cuk_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Atakdimaladi, warbogwa Sodoma-neggweburse nadmalad. Abrahamʼdi Bab-Jehová-asabin gwisgusad. ");
INSERT INTO cuk_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Geb degine, Abraham Bab-Jehováʼse walikaa naded, ega sogded: —¿Ar dule-isgudisurmalad, dule-isgudimaladba be obelogode? ");
INSERT INTO cuk_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","”Ar dule-nuegan dulabo-gakambe (50) we-neggweburgi gudidiile, ¿amba be we-neggwebur obelogode? Ar we-dule-nuegan dulabo-gakambe (50) gudidimalad-sabed-ular, ¿we-neggwebur melle obelogodeeye be sogosurde? ");
INSERT INTO cuk_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Dogdar-itole, dule-ibmar-isgana-imakdisulid, dule-ibmar-isgana-imakdiidba be oburgwer. Ebobela emarbi isgusadyob be imako itole. Mer deyob be sae. Bee be, bela dule-we-napneggi-bukmaladga, igar-naboged-e-dummadsoggu, ¿igar-innikii maidba be imakosurde? Eye. Be igar-innikii maidba imakoed.” ");
INSERT INTO cuk_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Geb degine, Bab-Jehová abin-sogded: —Ar e-dulabo-gakambe (50) dule-nuegan Sodoma-neggweburgi gudidiile, amar-ular Sodoma-neggwebur an obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ar Abrahamʼdi gannar Bab-Jehováʼga sogdebalid: —Dummad, bese nue-wilesakwaa an egised, ar bedi Dummadid, andi dule-binsaledid. ");
INSERT INTO cuk_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Igidibe, dule-nuegan dulabo-gakambe-guega (50), e-walatar-napile. ¿Amba walatar-napid-ular, bela Sodoma-neggwebur be obelogode? Bab-Jehová Abraham-abin sogded: —Ar we-neggweburgi dulabo-gakatar (45) dule-nuegan amba wis gudiile, an obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Gannar Abraham sogdebalid: —¿Ar unnila dulabo (40) dule-nuegan gudiile, bela Sodoma-neggwebur be obelogode? Bab-Jehová abin-sogded: —A-dule-nuegan-dulabogwad-ular (40), we-neggwebur an obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ar Abrahamʼdi gannar Bab-Jehováʼga sogdebalid: —Dummad, gannar-gannar an bega ibmar-sognaidgi, melle be isdar an-itogo. Ar unnila dulagwen-gakambe (30), dule-nuegan gudidiile, ¿bela Sodoma-neggwebur be obelogode? Bab-Jehová gannar abin-sogdebalid: —Ar we-neggweburgi unnila dulagwen-gakambe-gudidimalad-ular (30) an obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham sogdebalid: —Dummad, weyob an bega sunmakewilubsulinad, degi-inigwele, ¿we igi-balile, unnila dulagwen (20) dule-nuegan we-neggweburgi gudiir? Bab-Jehová Abraham-abin sogdebalid: —Amar-dulagwenad-ular (20), we-neggwebur an obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Amba Abraham gannar sogdebalid: —Dummad, wis an bese egis, melle be isdar an-itogo. Napi an bega soge. A-sorba, bar an bega ibmar sogosulid: ¿Igi be imaksale, unnila warambe (10) dule-nuegan gudiir? Bab-Jehová Abraham-abin sogded: —Ar dule-warambegwad-ulale (10), an we-neggwebur obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Bab-Jehová, Abraham-ebo-sunmaked-bergusgu, na naded. Abrahamʼdi gannar e-dordoneg-siidse nonikid. ");
INSERT INTO cuk_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nue neg-gutulesa, baliwitur-warbogwad Sodoma-neggweburse modapmalad. Deunni, Lot, neggwebur-doged-yawagakgi siid, ar ade, agi gusgu dummagan ambikunonidamalad. Lot, a-dulemar-warbogwad-daksagua, abin nadegusad. Lot dulemar-warbogwad-asabin napase e-bebe ebulegedse dulluu imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Lot amarga sogded: —Dummagan, an bese wilesakwaa wis egisdo, emi-mutik an-neggi bemar obunnobi an abedo. An-neggi sunna bemar nag enukmalad. Geb oibosar, wakudaryala bemar sunna naed. Geb amar-warbogwad Lot-abin sogdemalad: —Suli, nued be anmargi binsaendo. Anmardi neg-magaba gaboe. ");
INSERT INTO cuk_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Degi-inigwele, Lot amargi alamaknai gusad. Geb a-warbogwad sogdemarsunnad: “Eye, anmar beba naoe.” Geb Lot-negse modapmargu, Lot amarga mas-nued imaksad, ega madu-inasulid imaksad. Ebogwad nue-mas guchamalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Amba yoo megmaladgine, bela machergan-Sodoma-neggweburginmalad, sergan, degine, sapinganse-bakale, neg-ebilis ambikunonimalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lotʼga binnasur sogdemalad: —¿Bia machergan emi-mutik be-negse-nonimalad nade? ¡Anmarga be onoge! ¡Anmar we-machergangi dodobied! ");
INSERT INTO cuk_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Geb agi, Lot magaba dulemarse nononikid, e-sorba yawagak ise-ediar imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Geb Lot dulemarga sogded: —Aimar, an bemarse wilesakwaa egismar. Melle bemar galagwensuli neg-imakmalo. ");
INSERT INTO cuk_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","An walabo sisgan nikad, amba yagan-nanaed. Amar an bemarga onogoed. Ar igi bemar amar-imakbimala, be-itolegedmardo. Wemar-warbogwad-anse-nonimaladdi melle bemar oakalomalo, ar ade, wemar an-negse ubononisoggu, we-dulemar an nue-akwergebed. ");
INSERT INTO cuk_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Dulemar-oimakbukwad Lot-abin sogdemalad: —¡Be ainire! Be anmar-neggweburginedsulid. ¿Be anmar-dummadsi? Be anmar-dummadsuli. Emigindi, we-machergan-warbogwadba bur bule anmar be-imakoed. Geb degine, sabsur Lot-imakarmalad. Agine, yawagak-omukumalaga, yawagakse duurmakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lotʼse-atakdimaladdi yawagak-imbaba argan-onosmargu, Lotʼgadebin imaksamalad, negyaba odosmalad, geb degine, yawagak edismalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Geb wemar-warbogwad dulemar-bela-magaba-bukwad geg-atake imaksamalad. Belagwapa, sapinganse, degine, serganse-bakale, geg-atake gusmalad. Yawagak acha-acha-aminanaid, budar-itoarmalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Geb degine, dule-warbogwad Lotʼga sogdemalad: —¿Amba gwenadgan-baigan be nika? Be-sapingan, be-masmala, be-bunamala, bela we-neggweburgi gwenadgan-be-nikadi be sede. Bela be-gwenadgan we-neggweburgi be onogo, degine, dikasur be sede. ");
INSERT INTO cuk_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ar ade, anmar we-neggwebur obelosokalid. Ar we-neggweburgi-dulemar-bukmalad bela-bela nue-isgus galagwensulidamalad Bab-Jehováʼse warmaksad. A-ular, Bab-Jehová we-neggwebur-obelogega anmar-barmialid. ");
INSERT INTO cuk_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Geb degine, Lot e-sapinganga-gumaloed daknaded. Amarga sogdapid: —¡Gwisgumar, be nomar, ar ade, Bab-Jehová we-neggwebur obelosokalid! Ar e-sapingandi Lot-ega-ibmar-soged baisur-itosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ar bato neg-oibodanigussoggu, baliwiturmar Lotʼga sokalid: —¡Gwaegwa! Be nae. Be-ome, degine, be-sisgan-warbogwad be sede. Ar be sedsulile, anmar we-neggwebur-sabsur-odurdaksokalidba, bemar burgwemarmogoed. ");
INSERT INTO cuk_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ar Lot binnaa gunaisoggu, baliwitur-warbogwad, Lot, e-ome, degi, e-sisgan-warbogwad argangi gadebin imaksamalad. Geb neggweburgi wemar-onosmalad, adi, bendaklemalagar. Ar Bab-Jehováʼdi nue Lot-wiledaksoggu, baliwiturmar a-ular, weyob Lot-imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Bato neggweburgi nosmargua, baliwitur Lotʼga sokalid: —¡Be abarmakdemar, mer be burgwemalagar! Mer bar yarganba gannar atako, deginbali, yalaganba be wakinmalo. Melle nebagi be obunnobalo. Ar degisulir, bemar burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lotʼdi abin-sogded: —¡Suli dummagan, deyob suli! Ar bese wis wilesakwaa an egised. ");
INSERT INTO cuk_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Emide, ibmar-nuegan bukidargus bemar anga imakdanikid. Degine, nued bemar angi binsasad, bemar an-bendaknonigu. Degi-inigwele, yalaganba geg an wakinned. Ar neg-bergudele, an sunna igarba bargalesaled. Ar degiile, an burgwemogo-itole. ");
INSERT INTO cuk_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wegi itakasaale neggwebur-bipigwad-siidse an sunna wakichaled. ¡Ase naed be an-imake, adi, an bendaklegegar, an melle burgwegar! A-neggweburdi nue bipigwad. ");
INSERT INTO cuk_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Geb dule abin-sogded: —An be-itos. Be anse egisnaidba an bega imakoed. We-neggwebur-bipigwad be anga obaredi, adi, an obelogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","¡Be nae! Gwae be a-neggwebur-bipigwadse be nae. Be neggwebur-bipise-warmakedse geb an neg obelogoed. A-ulale, a-neggwebur-bipigwad, Zoarʼye onugsalesad. ");
INSERT INTO cuk_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Bato neg-oibosadgi, Lot, Zoar-neggweburse modapid. ");
INSERT INTO cuk_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Geb degi, Bab-Jehová nibneg-akar Sodoma-neggweburgi, degine, Gomorra-neggweburgi soo, degi, azufre egi odesad. ");
INSERT INTO cuk_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Bab-Jehová wemar-neggwebur, degi, agi bela gudidimalad, degi, bela a-nebagine gaganse-bakale, obelosad. ");
INSERT INTO cuk_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ar Lot-e-omedi, yarganba atakded. Agi, yog balu-warga binyale-naded. ");
INSERT INTO cuk_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","A-bangine, wakudaryalaba Abraham nadegusad, bia Bab-Jehová-ebo sunmakgwichigusa, ase naded. ");
INSERT INTO cuk_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Abraham, Sodomaʼsik, degi, Gomorraʼsik, degi, bela nebasik atakdegu, dakded, bela-bela waa bupurmagwichi. Soo-yagi waa bupurmakgwichiyobi daked. ");
INSERT INTO cuk_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Weyobi, Bab-Dummad Lot-maigusadgi neggweburmar-nebagi-bukwad obelosad. Bab-Dummad Abrahamʼgi nued-binsaed-ular, Lot-onosad, melle Lot dule-baiganba burgwegar. ");
INSERT INTO cuk_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Weyob neg-gusad-sorbali, Lot Zoar-neggweburgi dobe-mege gualid. Aga, Lot, e-sisgan-warbogwadmala yalaganba nade gusad. Na e-warbaagwa akwasaila-ollorsiidyaba megidapmalad. ");
INSERT INTO cuk_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Ibagwengine, ior na urbaga sokalid: —Anmar-bab bato nue-selebagusad. Wegi machergan sated, adi, igar-maidba anmarse golegar. ");
INSERT INTO cuk_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Degisoggu, anmar-bab anmar omumsamalo. Geb agi, anmar ese goloed, adi, anmar ega anagan-urbegar. ");
INSERT INTO cuk_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","A-mutikidba, vinoʼgi e-bab-ogobsamalad. E-sisgwa-dummad e-babse gochad. Ar e-babdi gwen itossulid, sana e-sisgwa e-yarba megisa, degine, sana gannar gwisgusbali. ");
INSERT INTO cuk_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","A-bangine, ior urbaga sokalid: —Sae-mutik bab-yarba an megisad. Degisoggu, emi-mutik anmar bab-omumsabalo, adi, bab-yarba megmogagar. Geb degiir, anmar geb ega anagan urboed. ");
INSERT INTO cuk_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","A-mutiki, vinoʼgi gannar e-bab ogobsamarbalid. Geb degine, urba e-babse gochamogad. Ar Lot gwen itossurbalid, sana e-sisgwa-bipigwad e-yarba megisa, degine, sana gannar gwisgusbali. ");
INSERT INTO cuk_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Weyob Lot-e-sisgan-warbogwad bonigwar e-babgadga gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","E-sisgwa-dummadga susugwa uklenonikid. A Moabʼye onugsasad. Agi, Moab-dulemar-bukwadi danikid. ");
INSERT INTO cuk_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","E-sisgwa-bipigwadga susugwa uklenonimogad. Adi, Benammiʼye onugsasad. Agi, Amón-dulemar-bukwadi danimarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham e-maidgi bangud gusad. Neguev-nebaganba nade gusad. Gerar-neggweburgi megidapid. We-neggweburde Cades, degi, Shur, amar-negabargi siid. ");
INSERT INTO cuk_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Agi Abraham maigua, sogsagusad, e-ome-Sara, e-bunye. Gerar-neggwebur-e-rey-Abimelec, Sara-nikuega Saraʼbina gochad. ");
INSERT INTO cuk_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","A-mutikidba, Bab-Dummad Abimelecʼse gabgi nonikid, ega sognonikid: —Be we-ome-sealid-ular, be burgo. Ar we-omede sui nikad. ");
INSERT INTO cuk_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ar Abimelec amba yoo Saraʼse gorsoggu, Abimelec Bab-Dummad-abin sogded: —Dummadye, ¿ar bede dule-neg-oakalossulid oburgoye be sogde? ");
INSERT INTO cuk_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ar Abraham-sunnad anga sogsad: We-ome, an-bunye. Degine, omegwa anga sogsamogad: We-machered, an-susye. Ar degisoggu, gwen ichakwa-binsasulidgi an ibmar imaksad. Ibmar-isgana an imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bab-Dummad Abimelecʼga gabgi sogsad: —An nue be-wisid, ichakwa-binsasulidgi be imaksad. A-ulale, omese-golega an be-imaksasulid, adi, melle be angi noegar. ");
INSERT INTO cuk_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ar emigindi, ome e-suiga gannar be berbena. Ar we-machered Bab-Dummad-gayaburba-barsogedsoggu, be-ular Bab-Dummadse goloed, adi, mer be burgwegar. Ar omegwa gannar e-suiga be berbenasulirdi, be, degi, be-gwenadgan burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Oibosgu, wakudaryalaba Abimelec gwisgusgu, bela e-maiganse gochad, amarga bela sogsad, igi ede gabdaksa. Itosmargua, bela nue-dobe itodmalad. ");
INSERT INTO cuk_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Geb a-sorbali, Abimelec, Abrahamʼse-gochagu, ega sogded: —¡Emi, be-neg-oakalosad be dake! ¿Ibigi an begi nosa? Emisgi isgued-dummad be angi, degi, an-sordamargi senonigu. Weyob be ibmar imakewilubsulinad. ");
INSERT INTO cuk_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelec Abrahamʼga sogdebalid: —¿Ar ibiga deyob be imakye be binsaali? ");
INSERT INTO cuk_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham, Abimelec-abin sogded: —Wegi dule-Bab-Dummad-dobee-nanaed sateye an biendo. Degisoggu, an-ome-ular an-oburgwemaloeddeeye an binsasad. ");
INSERT INTO cuk_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ar nabiri, we-omegwa an-bunad. An-bab-e-sisgwad, an-nandi e-nansulid. Deginbali, we-ome, an-omebalid. ");
INSERT INTO cuk_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Bab-Dummad anga igar-uknonigu: Be-bab-neggi-be-gudiid be naye. Geb an we-omega sogsad: ‘Bia anmar modapile, nue be an-sabele, be sogoye, be an-bunye.’ ");
INSERT INTO cuk_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Geb degine, Abimelec, Abrahamʼga e-ome-Sara gannar uksasunnad. Geb aginbali, Abrahamʼga sibad-wawaadmar, moli-bebe-nikamalad, mai-machergan, degi, mai-omegan, uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelec, Abrahamʼga sogdebalid: —Be dake, we an-yala. Bia be megbie be-itolegedba be yar sue. ");
INSERT INTO cuk_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saraʼga sogdemogad: —An be-susgala mani-miligwen-aidikue (1,000) uksad. We-mani dule-beba-gudidimalad-asabin be oyogo, adi, oyogega bedi gwen nossurye. Dule-wargwensaale gege begi sunnasur sunmaked. ");
INSERT INTO cuk_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Geb degine, Abraham Bab-Dummadse goted, geb Bab-Dummad Abimelec-onugusad, degi, e-ome-onugusbalid. Deginbali, e-maimar-omegan-onugusbalid, adi, nabir sunna mimmi-bake gumalagar. ");
INSERT INTO cuk_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ar ade, Abraham-e-ome-Sara-ulale, Bab-Jehová omegan-Abimelec-negginmalad geg mimmi-bakega imaksanad. ");
INSERT INTO cuk_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Bab-Jehová e-sogsadba Saraʼgi ise-nued binsasad. Saraʼga ise-sogar-imaksadba ega ibmar imaknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Degisoggu, Sara bonigwar gunonikid. Deunni, Abraham bato nue seredgusad. Bab-Dummad Abrahamʼga-sogsadyobi, a-ibagangi Sara susugwa baknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham, Sara-ega-susugwa-baksadi Isaacʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Isaac ibabaabakgus-gwalulesadgi (8), Abraham Bab-Dummad-ega-sogsadba, Isaacʼga abgan-uka-duku siksad. ");
INSERT INTO cuk_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham birga-dulatar (100) nikadgi, Isaac gwalulenonikid. ");
INSERT INTO cuk_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Geb degine, Sara sogded: “Bab-Dummad an-oallisad, bela dulemar susugwa-nikusye an-wisguarmalale, anba weligwaledba allemarmogoed.” ");
INSERT INTO cuk_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sara sogdebalid: “¿Ar wede doa Abrahamʼga sogoen be insae, ani, Sara, ega mimmi bakoye? Dule sogosulina. Ar emigindi, be dakena, ar Abraham bato seredgus-inigwele, degite, anga machigwa baksad.” ");
INSERT INTO cuk_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Machigwa-Isaac dunguded, degine, mam-iargunonikid. Mam-iargusad-ibagi, Abraham iba-dummad onosad. ");
INSERT INTO cuk_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","A-iba-ononaidgi Sara dakded, Agar-e-machi-Ismael Isaacʼgi dodonai. We-machide Agar Abraham-ebo baksadid. Agarʼde Egipto-duled. ");
INSERT INTO cuk_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","A-ular, Sara Abrahamʼga sogded: —¡We-mai, degine, e-machi we-neggi be onoge! We-mai-e-machi an-machi-sunnagwadyob geg an-machi-Isaacʼba, be-ibmar-beoedi abingamogad. ");
INSERT INTO cuk_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ar Ismael Abraham-machi-sunnad gusoggu, Sara weyob Abrahamʼga ibmar-sogsadi, Abraham nue-nunmak itosad. ");
INSERT INTO cuk_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ar Bab-Dummaddi Abrahamʼga sogded: “Melle be-machigi, degine, be-maigi nunmak be itoge. Ar ibi Sara bese egichialile, aba be ibmar sae. Ar ade, Isaac-waganbi be-wagan-sunnadga gumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ar be-mai-machidi be-machibarsoggu, amba deyob an imakbaloed, dule-bukidar-guega an imakmogoed.” ");
INSERT INTO cuk_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Neg-oibosadgi, wakudaryalaba, Abraham Agarʼga madu, degi, buglugi dii ega uksad. Abraham Agar-gukingi bela ega ibmar nasiksad. Geb degi, Agarʼga e-machi-Ismael-uksagu, barmisad. Agar nadegusad, Beersebaʼsik nega-dulesulidganba bipirmakdii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Buglugi dii-siid bergusgu, Agar sapi-urba e-machi sisad. ");
INSERT INTO cuk_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Agarʼdi bannabasaar wilubba-banguedgi signaded. Ar ade, binsasad: “Machi burgwialir, an dakbisulid.” Agar sigidapgu, machi boalid. ");
INSERT INTO cuk_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bab-Dummad, machigwa bosiid itosad. Bab-Dummad-e-baliwitur nibneg-akar Agarʼse gornonikid, ega sogded: “¿Agar, igi be itoge? Mer be bukib itoge, ar Bab-Dummad be-machi-bosiid itosad. ");
INSERT INTO cuk_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Be nae, be-machi be suna. Nue be-argangi be gao, mer indako. Ar ade, an we-machigwagi dule-bukidar-gued an imakoed.” ");
INSERT INTO cuk_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Geb degine, Bab-Dummad Agar dia-siid-dakega imaksad. Agar diase nade gusad. Geb buglugi dii enosad. Geb degine, diigi Ismael-ogobsad. ");
INSERT INTO cuk_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ismael-dungumaidba Bab-Dummad Ismael-bendaksad. A-machigwade nega-dulesulidgi maigusad. Agi, yeer sigu-mie gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Sapingwagusgu, Parán-nega-dulesulidgangi-maidgi, e-nan ega ome-Egiptoʼgined uksad. ");
INSERT INTO cuk_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","A-ibagangine, deunni, Abimelec Abrahamʼga sunmaknade gusad. Ficol eba nade gusmogad. Ficolʼde Abimelec-e-sordamar-e-dummadga gudiid. Abimelec, Abrahamʼga sogdapid: —Bela be ibmar-imakdele, Bab-Dummad nue-be-bendake anmar daked. ");
INSERT INTO cuk_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Degisoggu, weyob, Bab-Dummad-nuggi ise-sogar be anga soge, akar be an-imakosurye, degine, an-mimmigan, degi, an-wagan akar be imakosurbarye. Igi-nued an be-imaksamoga, deyob be an-imakmogoed, degine, emi we-yargi-be-gudiid-e-dulemar deyob be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham, Abimelec-abin sogded: —Napira-Bab-Dummad-nuggi ise-sogar an bega soged: ‘Eye, an imakosuli.’ ");
INSERT INTO cuk_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Geb degine, Abraham, Abimelecʼga sogded, igi Abimelec-e-maimala e-ibe dia susmala. ");
INSERT INTO cuk_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelec Abraham-abin sogded: —An wissulid wede doa deyob imaksa. Ar bede anga sogsasulid. Ar emi geb an itogwichid. ");
INSERT INTO cuk_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Geb degine, Abraham sibad-wawaadmar, moli-bebe-nikamalad susad, geb degine, Abimelecʼga uksad. A-ibagine, Abimelec Abraham-ebo igar mesismalad. ");
INSERT INTO cuk_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ar Abrahamʼdi e-sibad-wawaad-bukwadgi sibad-wawaad-ome-senigana walagugle (7) susad. Geb degine, amar bachikii urbisad. ");
INSERT INTO cuk_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","A-ulale, Abimelec Abrahamʼse egichialid: —¿Ar ibiga-wede be sibad-wawaad-ome-senigana walagugle (7) be bachikii urbisa? ");
INSERT INTO cuk_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham abin-imakded: —Ar we-sibad-wawaad-ome-senigana walagugle (7) an bega uked, adi, soglegegalad, we-dia, ani an akwisye. ");
INSERT INTO cuk_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","A-ulale, emar-gunanaidgi Beersebaʼye onugsasmalad. Ar ade, na ebogwa sogsamalad, anmar ibmar-sogsamaladi imakedseye, geg anmar imaksuli guye. ");
INSERT INTO cuk_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beersebaʼgi na igar-nabosmargu, Abimelec, degine, e-sordamar-idued-Ficolʼmala gannar Filistea-neggweburmarse nadmalad. ");
INSERT INTO cuk_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahamʼdi Beersebaʼgi ingwa-soled-sapi digsad. Agine, Bab-Dummad-Jehová-Degisadeguadse gochad. ");
INSERT INTO cuk_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham birga-suitii Filistea-dulemar-yargi maigusad. ");
INSERT INTO cuk_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Undar birgamar nasadgine, Bab-Dummad Abraham-wilub-dakesokalid, bule egi nue bensurdibeye. Bab-Dummad nugba Abrahamʼse gornonikid: —¡Abraham! Abraham Bab-Dummad-abin sogded: —Na, degite, an be-itomai. ");
INSERT INTO cuk_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Bab-Dummad Abrahamʼga sogded: —Isaac, be-machi-wargwennagwad be nue-sabedi, Moriah-yalaganse be sede. A-yalagan-mosale, an bega yar-oyogoedgi be-machi be anga ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Oibosgu, wakudaryalaba Abraham gwisgusad, e-moli-uayasuid guakwaa nasiksad. Sapan amisbalid, machigwa-ogumakar-uklegoedgi ogaegar. Abraham bia Bab-Dummad ega-naoye-sogsadse nadegusad. E-machi-Isaac, degi, e-maimar-warbo eba nadmarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Abraham ibapaagus-nanaedgi yar egi dikasur-noe dakalid. ");
INSERT INTO cuk_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Geb degine, Abraham e-maimarga sogded: —Wegi bemar moli-uayasuidmala an-edarbemalo. Machigwa-anbogwa Bab-Dummad-e-nug-odummogega andi naoed. Geb degine, gannar anmar bese nonikoed. ");
INSERT INTO cuk_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham ibmar-ogumaklegoed-ogaegala sapan susad, geb Isaac-e-gukingi mesisad. Abrahamʼdi es, degi, acha-gwallu-ogaar sesad. Geb degidgine, Abraham e-machi-ebo nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Sikwas nanaedgine, Isaac Abrahamʼga sogded: —¡Baba! Abraham abin-sogded. —Degite machi, soge. Isaac sogded: —Anmar sapan, degi, acha-gwallu-ogaar sedanikid, degite, ¿bia sibad-wawaad-senigwad anmar Bab-Dummadga-ogumakar-ukoedde? Abraham Isaac-abin sogded: ");
INSERT INTO cuk_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","—Machi, Bab-Dummad anmarga sibad-wawaad-senigwad udagoed, anmar ega ogumakar ukegar. Deyob, ebogwa imakenadap gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Abraham, degi, e-machi-Isaac-ebo Bab-Dummad-ega-yar-sogsadse modapmargu, Abraham Bab-Dummadga-ibmar-ogumakar-ukleged-aila sobsad. Geb a-aila-birgi sapan urbisad. Geb degine, e-machi-Isaac-edichagu, we-aila-birgi sapan-birgi Isaac-mesisad. ");
INSERT INTO cuk_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham e-machi-oburgwegala es susgua, ");
INSERT INTO cuk_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bab-Jehová-e-baliwitur niba ese gollalid: —¡Abraham! ¡Abraham! Abraham Bab-Jehová-e-baliwitur-abin sogded: —Degite. Wegi an gunai. ");
INSERT INTO cuk_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Bab-Jehová-e-baliwitur Abrahamʼga sogded: —Melle machigwa be oakaloge. Melle be naibi-imake. Ar bato an wisid, be Bab-Dummad-dobee nanadiid. Ar be gwen sogsasulid, an-machi-wargwensakad melle be anga ukodeeye. ");
INSERT INTO cuk_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham dakded, sibad-wawaad-machered sapi-imbaba e-bebegi galesnai. Abraham agi sunaded. Sibad-wawaad-machered-susgua, ogumakar e-machi-anar Bab-Dummadga uksad. ");
INSERT INTO cuk_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Geb a-sorbali, Abraham weyob we-neg onugsasad: Bab-Jehová ibmar-unnitiba-ukedye. A-ulale, amba we-garda narmaklenaidse sogleged: Bab-Jehová-yargine ibmar-unnitiba-uklegoedye. ");
INSERT INTO cuk_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Bab-Jehová-e-baliwitur gannar irbogi niba Abrahamʼse gornonibalid, ");
INSERT INTO cuk_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ega sogded: —Bab-Jehová soged: ‘Ani, an bega ise-sogar soged: Ar be-machi-wargwensakad mer be anga ukodeeye be sogsasursoggu, ");
INSERT INTO cuk_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","an bela-bela ise-nued begi binsaoed. Be-wagan bela-bela-mergu an imakoed, niisgwamar-niba-nanaidyob, degi, ukub-demar-gakagi-nikadyob an imakoed. Deginbali, be-wagan e-isdarmaladgi nakwedii guoed, degi, e-neggweburgan ei sudii guoed. ");
INSERT INTO cuk_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Deginbali, ar an bega-ibmar-sogsadyob be imaksasoggu, bela dula-we-napneggi-bukwamalad be-waganba an egi ise-nued binsamogoed.’ ");
INSERT INTO cuk_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham bia-e-maimar-obesa, ase gannar nonikid. Degine, bela Beerseba-neggweburse nade gusmalad. Agine, Abraham megidapid. ");
INSERT INTO cuk_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Degi-undaradgine, Abrahamʼga soglenonikid, e-urba-Nacor machimala-nikamoye, Milca ega baksaye. ");
INSERT INTO cuk_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Gebe-machigwa ega gwalulesad, Uzʼye nugad. A-sorba, e-urba-Buz gwalulesad. Degi, Kemuel gwalulesad. Kemuelʼde, Aram-e-babad. ");
INSERT INTO cuk_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Deginbali, Nacor-e-masmala-baigan, Milcaʼbo-baksabalid, wemalad: Quesed, Hazo, Pildas, Jidlaf, degi, Betuel. ");
INSERT INTO cuk_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","We-Betuelʼde Rebeca-e-babad. Wemar-walabaabakadi (8) Nacor-machimalad, Milca-ebo baksadid. Nacorʼde Abraham-e-urbad. ");
INSERT INTO cuk_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Deginbali, Nacor, Reúma-ebo baid-machimala nikusbalid. Reúmaʼde e-ome-dikarbalidid. We-ebogwa machimala-baksadi, wemalad: Teba, Gaham, Tahas, degi, Maaca. ");
INSERT INTO cuk_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara birga-dulanergwa-gakagugle-nikadgi (127) burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara Canaán-yalagangi, Quiriat-Arba-neggweburgi burgwisad. Quiriat-Arbaʼde, Hebrónʼye bilebalid. Abraham Sara-burgwisadba nue-bosad, degine, nue-Sara-ebinsadii gusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Geb degine, Abraham Sara-burgwar-maid-obes nade gusad. Het-dulemarse naded. ");
INSERT INTO cuk_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Geb Abraham Het-dulemarga sogded: —Ar an bemar-abargine weginedsur-inigwele, anga wis be neg-uan manigi ukmala, adi, an-ome-mui agi an digegar. ");
INSERT INTO cuk_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Het-dulemar Abraham-abin sogdemalad: ");
INSERT INTO cuk_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—¡Dummad, bega an sogmardo! Ar Bab-Dummad anmar-abargine, dule-dummadga be-susad. Degisoggu, be-ome-mui anmar-neg-uan-bur-nuedgi be dige. Ar anmar-wargwensaar bega sogosulid: Melle be-ome-e-mui be anmar-neg-uangi digye. ");
INSERT INTO cuk_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Geb degine, Abraham gwisgusad, Het-dulemar-bukmalad-asabin dulluu imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Geb degi, amarga sogded: —Ar bemar wegi an-ome-burgwisad nue-digbi abegele, an bemarse wilesakwaa egisdo, an-nuggi bemar Zohar-machi-Efrónʼse egismar: ");
INSERT INTO cuk_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","‘Anga, e-nainu-dikarba-akwasaila-ollor-siid, Macpelaʼye-nugad, manigi ukye.’ Ar e-mani-gargeguedba, an bennukoed. Ar degiir, geb an neg-uan wegi nikuoed. ");
INSERT INTO cuk_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ar Het-dule-Efrón emar-abargi simosoggu, bela Het-dulemar, degi, dule-bela-neggweburse-ubomamaid e-itomalaga, Abraham-abin sogded: ");
INSERT INTO cuk_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—¡Dummad, degisuli! An-nainu, degine, akwasaila-ollor-siid binsa an bega ukoed, maniginsuli. An-sordamar-bukwad anmar-daksiid, amar-asabin an bega we-akwasaila-ollor-siid binsa uknaid. Agi be-ome-mui be dige. ");
INSERT INTO cuk_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahamʼdi Het-dulemar-asabin gannar na dulluu imakded. ");
INSERT INTO cuk_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Abraham bela dulemar-e-itobukwad-abargi Efrón-abin sogded: —¡Bemar bela nue an-itogo! An bega soged, mani be sue. Nainu an bese bakoed. Geb a-sorba, an-ome-mui an digoed. ");
INSERT INTO cuk_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Geb degi, Efrón abin-sogded: ");
INSERT INTO cuk_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Dummad, nue be an-itogo: Nainu-e-gargegued mani-dulataled-ilabake-aidikued-wilub (400) gargegued. Wegindi anmar na abin-abin imakosurmalad. Degisoggu, be-ome be dignado. ");
INSERT INTO cuk_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham, Efrón Het-dulemar-abargi ega nainu-gargegued-sogsad nabir-itosad. Degisoggu, dule-ibmar-ukmalad-igar-maidba mani-dulataled-ilabake-aidikued-wilub (400) mie-mie bennuksad. ");
INSERT INTO cuk_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Weyobi, Mamre-dad-nakwedsik Efrón-nainu-Macpelaʼgi-naidi, Abrahamʼgadga gunonikid. A sogleged, nainu, akwasaila-ollor-siid, bela sapimar, Abrahamʼgadga gunoniye. ");
INSERT INTO cuk_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Het-dulemar, degi, dule-bela-neggweburgi-dogmamaid, nue-amar-daksii gusmarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Geb agine, Abraham akwasaila-ollor-siidgi e-ome-Sara-mui-digsa gusad. We akwasaila-ollor-dummad, Macpela-nainugi siid, Mamre-dad-nakwedsik. Mamre-neggweburde Hebrónʼye nugbalid, Mamre-neggwebur Canaán-yargi siid. ");
INSERT INTO cuk_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Weyob we-nainugi akwasaila-ollor-siid, Abrahamʼgadga gunonikid. We-nainude Het-dulemar Abrahamʼga manigi uksad, adi, Abraham we-nainu e-neg-uanga imakegar. ");
INSERT INTO cuk_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham bato nue selebagusad. Bab-Jehová Abrahamʼgi bela ise-nueganbi binsadii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ibagwengine, Abraham e-mai-bur-undargus-arbadiidse gochad. We-mai bela ega ibmar-dakega gudiid. Abraham a-maiga sogded: —Be anga ise-sogar-ibmar-sogegala, an-dua-urba be-argan be mese. ");
INSERT INTO cuk_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Bab-Dummad-Jehová-Nibneg-Dakmaid-nuggi, degi, napneg-dakmaid-nuggi ise-sogar be anga soge. Wegi, an Canaán-dulemar-abargi an maid. A-Canaán-yagan-wargwensaar mer an-machi-Isaac-onikued be sao. ");
INSERT INTO cuk_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bur be an-yarse nao. Agine, an-gwenadgan-e-sisgan-wargwen, an-machi-Isaacʼga be aminao, adi, a-yagwa Isaac-nikuegar. ");
INSERT INTO cuk_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","E-mai abin-sogded: —Nued, dummad. Ar yagwa we-negse yapa anba dagele, ¿igi an imakosunna? ¿Ar degiile, be-yargi be aligusadse, an be-machi sedsunnode? ");
INSERT INTO cuk_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham abin-sogded: —¡Suli, mer an-machi ase be sedo! ");
INSERT INTO cuk_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Bab-Dummad-Jehová-Nibneg-Dakmaidi an-bab-neggi an-onosad, degi, an-babgan-yalagi an-onosbalid. A anga sogsad: ‘Napira ise-sogar an bega sogye: Emi-be-maidgi we-yala an be-waganga ukoye.’ Degisoggu, a-Bab-Dummad e-baliwitur be-idu barmidoed, adi, weba an-machiga ome be sedagegar. ");
INSERT INTO cuk_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ar ome beba dagbisulile, be ise-sogar anbo igar-mesisadgi be ollorguodo. Unnila an bega soged, ¡bipisaale melle an-machi be weba sedo! ");
INSERT INTO cuk_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Geb degine, Abraham-e-mai, e-dummad-Abraham-dua-urba e-argan mesisgu, Abrahamʼga ise-sogar imakded, eyeye, an be-sogedba an imakoye. ");
INSERT INTO cuk_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Geb a-sorbali, Abraham-e-mai moli-yargan-mureged-warambe (10) susad. Abraham-ibmar-nuegan-nikad binsa-ukega susbalid. Geb degine, Mesopotamia-yarse, Nacor-neggweburse naded. ");
INSERT INTO cuk_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Abraham-e-mai Nacor-neggwebur-magaba modapgu, deun bato neg-sedogualid. A-wachigi omegan dii-weenad damalad. Abraham-e-mai moli-yargan-muremalad dia-naba-obunnogega sindigar osisad. ");
INSERT INTO cuk_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Geb degine, Abraham-e-mai Bab-Dummadse goted: “Bab-Jehováʼye, an-dummad-Abraham-e-Bab-Dummadye, emi-ibagi nued anga ibmar-gued be imakena yeerban, degine, an-dummadgi nued be binsabalina gadin. ");
INSERT INTO cuk_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Wegi dia-naba an siidgi, yagana-we-neggweburginmalad wese dii wedanimaloed. ");
INSERT INTO cuk_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","A-yagwa-wargwenga an sogoedga, ‘wis be-buglu be odeye, adi, an dii gobegarye.’ A-yagwa weyob an-abinsaalile: ‘Dii be gobye, be-moli-yargan-muremaladga dii an ukmogoye.’ Agi an wisguoed, a-yagwa be-mai-Isaac-e-omega-guega be susa. Degi, be an-dummadgi-ise-nued-binsasad an wisgubaloed.” ");
INSERT INTO cuk_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Abraham-e-mai amba yoo Bab-Dummadse-goled bergue, dakded, yagwa-gwensak e-gukingi buglu-sii daniki. Dakleargua, we-yagwade Betuel-e-sisgwad, Rebecaʼye nugad. Betuelʼde Milca-e-machid. Milcaʼdi Nacor-e-omed. Nacorʼdi Abraham-e-urbad. ");
INSERT INTO cuk_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebeca yeer dakleged, amba yagwad, sui-sated. Rebeca diase aideded, e-buglu enosad, geb gannar nakwialid. ");
INSERT INTO cuk_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Agine, Abraham-e-mai gwae yagwa-abin naded. Yagwase modapgu, ega sogded: —Be-buglugi be dii-semaidi wis be anga udage. ");
INSERT INTO cuk_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Yagwa abin-sogded. —Dummad, be gobe. Geb degi, yog e-buglu-odear imaksad. E-argangi buglu-ganiki, diigi ogobsad. ");
INSERT INTO cuk_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Abraham-e-mai nue-gobsagua, Rebeca ega sogded: —Moli-yargan-muremaladga an dii weemogoed, adi, bela na dii-gobbimaladba gobmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Geb degine, yagwa e-buglugi-dii-semaidi dii-siedgi eodapid. Deyobi ichesuli nanasad, bela moli-yargan-muremalad unniguar dii gobsamaladse. ");
INSERT INTO cuk_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ar Abraham-e-maidi unnila daksigusad, ar ade, nue wisgubied, e-nonikidgi bule Bab-Jehová egi nued binsasdibeye. ");
INSERT INTO cuk_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Bela moli-yargan-muremalad dii gobsamargua, Abraham-e-mai, yagwa-e-asugi olasu yosad. We-olasude gramo-nergwa (6) aidikued. Deginbali, sakwagi-nasikleged-olobiid, gwabo ega uksabalid. We-sakwagi-nasiklegedde gramo-dulatar (100) obinesaar aidikued. ");
INSERT INTO cuk_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Geb degine, Abraham-e-mai yagwaga sogded: —¿Be doa-sisgwa? Degi, anmar obunnogega, ¿be-bab-walik neg-nika be dake? ");
INSERT INTO cuk_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Yagwa abin-sogded: —An Betuel-sisgwa. An-babde Nacor-machid, Milcaʼbo baksadid. ");
INSERT INTO cuk_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Anmar-neggine bemar gabmalaga unniguar neg-nikad. Deginbali, molimar-yargan-muregedga unniguar gagan, degi, mas-maed nikabalid. ");
INSERT INTO cuk_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Geb degine, Abraham-e-mai yokorgi sindigar sigisad. Geb Bab-Jehováʼse goted, e-nug odummoded, ");
INSERT INTO cuk_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","sogded: “¡Bab-Jehováʼye be-nug odummolesun! Bedi an-dummad-e-Bab-Dummadid. Bedi an-dummadgi be-sabgued, degi, be-napiragwad gwen galakudisulid. Degine, Bab-Jehováʼye be an-sealid. Be anga igar-oyosad, adi, an-dummad-e-gwenadgan-negse an warmakegar.” ");
INSERT INTO cuk_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeca, bela ibmar-gusad e-nan-negginmaladga-sogega e-nan-negse abarmakded. ");
INSERT INTO cuk_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebecaʼde sus-nikad, Labánʼye nugad. Labán Abraham-e-mai-aminaega dia-siidse abarmakded. ");
INSERT INTO cuk_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","E-sus e-bun-Rebeca olasu-yoi, degi, sakwagi-nasikleged-nai daksad. Degine, Labán itosbalid, igi e-bun-Rebeca machered-ega-ibmar-sogsagusadi, e-nanga sognai. Geb Labán, Abraham-e-maise naded. Abraham-e-mai, degi, moli-yargan-muremalad amba dia-walik bukwamalad. ");
INSERT INTO cuk_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Geb Labán Abraham-e-maiga sogded: —Bedi dule-nuedid. Begi Bab-Jehová ise-nued binsasad. ¿Ar ibiga magaba be mellesii? Be anba dage. Ar bato neg guakwaa an bemarga nudaksad, degi, be-moli-yargan-muremaladga guakwaa an neg nudaksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Geb degine, Abraham-e-mai Labánʼba negse alid. Agi, moli-yargan-muremaladgi ibmarmar-bukwad odesad. Degine, Labán a-molimarga masgunned uksad. Deginbali, Abraham-e-maiga, degi, eba-danimaladga dii senonikid, adi, nag enukmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Abraham-e-maiga mas guakwaa sisgu, Abraham-e-mai sogded: —Mas-inse an gunnosuli. Bina an bega ibmar-sogbied soggwelergebed. Labán abin-sogded: —Degite, sogdo. ");
INSERT INTO cuk_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Abraham-e-mai sogded: —Ani, an Abraham-e-maid. ");
INSERT INTO cuk_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Bab-Jehová ibiba nued an-dummadgi binsasa, mani-ibedga imaksad. We-ibmarmar ega uksad: Sibad-wawaadmar, moli-bebe-nikamalad, ormar, manimar, mai-machergan, mai-omegan, moli-yargan-muremalad, degi, moli-uayasuigan-bukidar ega uksad. ");
INSERT INTO cuk_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","”Aginbali, e-ome-Sara, deun bato nue seleba-gusadgi, ega mimmi-baksad. An-dummad bela e-machiga ibmar uksad. ");
INSERT INTO cuk_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","An-dummad ise-sogar-ibmar-imakega an-imaksad, anga sogsad: ‘Anmar we-Canaán-yargi-maidgi, melle an-machi e-yagan-nikuega be imakoye. ");
INSERT INTO cuk_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Bur an-bab-e-gwenadganse be naoye, an-gwenadgan-e-sisgan-wargwen an-machi-nikuega be aminaoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","”An-dummad-abin an sogsad: ‘Dummad, ¿ar yagwa yapa anba dagele, igi an saoe?’ ");
INSERT INTO cuk_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","”Geb degine, an-dummad an-abin sokalid: ‘Ani an, Bab-Jehová-igarba nanadiiye. A-Bab-Jehová e-baliwitur beba barmidoye, adi, be-naoedba bega nueganbi ibmar guegarye. Weba an-machiga an-gwenadgan-e-sisgwa be amioye, adi, nikuegarye. ");
INSERT INTO cuk_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ar an-gwenadgan yapa bega e-sisgwa-ukerdina, adi, be ise-sogar-anga-sogsadi, bar beginsurye, adi, be ollorguoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","”Emi, deyob an diase nonisunnad. An Bab-Jehováʼse gotegu, an sogded: Bab-Jehováʼye, an-dummad-Abraham-e-Bab-Dummadye. We an nonikidse, ar napira be anga ibmar-imakoye be nue-sogele, ");
INSERT INTO cuk_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Bab-Jehováʼye, an wilesakwaa an bese egisye. Emi dia-naba an siidgi, weyob ibmar-gubi an abeye: Yagwa-gwensak dii-weenonikoedi, an ega sogoedga, ‘wis be-buglu be odeye, adi, an dii gobegarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A-yagwa weyob an-abinsaalile: ‘Dii be gobye, be-moli-yargan-muremaladga dii an ukmogoye.’ Agi an wisguoed, a-yagwa be-mai-Isaac-e-omega-guega be susye. ");
INSERT INTO cuk_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","”Bab-Dummadga weyob an sogsiid amba yoo an obeloge, Rebeca e-gukingi buglu-sii-daniki an dakalid. Dii-weegala diase aideded. Rebeca dii-wesgu, an ega sokalid: ‘Wis be anga dii udaye.’ ");
INSERT INTO cuk_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Rebeca yog e-buglu odear imaksad. Geb degi, anga sogded: ‘Dii be gobe, degine, be-moli-yargan-muremaladga dii an ukmogoed.’ Rebeca anga dii uksad, degine, an-molimarga dii uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","”Geb degine, an ese egichided: ‘¿Be doa-sisgwa?’ ”Bunagwa an-abin imaksad: ‘An Betuel-sisgwaye. An-babde Nacor-machiye, Milcaʼbo baksadye.’ ”Geb degine, an ega e-asugi olasu yosad, geb deginbali, e-sakwamargi sakwagi-nasikleged an ega nasiksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Geb degi, yokorgi sindigar an sigisad. Geb degine, Bab-Jehováʼse an goted, Bab-Jehová-nug an odummoded. Bab-Jehová an-dummad-Abraham-e-Bab-Dummadga gumogad. A-e-nug an odummoded, igar-nuedba an-senonikidba an e-nug odummoded. Adi, an-dummad-e-urba-e-sisgwa an-dummad-machi-e-omega guegar.” ");
INSERT INTO cuk_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Abraham-e-mai sogdebalid: —Ar emigindi, be anga nue sogmalo, an-dummadgi bemar nued, degi, napiragwadgi binsaodibe. Ar deyobsulile, bemar nue anga sogmarbalo, adi, an wisgubaloed, igi an imakoe. ");
INSERT INTO cuk_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Geb degine, Labán, Betuel-ebo abin-sogdemalad: —We-ibmar bela Bab-Jehováʼgi danikid. Degisoggu, geg anmar bega soged eyeye, geg an bega sogbalid surye. ");
INSERT INTO cuk_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Wegi Rebeca gwichi, be sede. Bab-Jehová-sogsadba, Rebeca be sedo, adi, be-dummad-machi-e-omega guegar. ");
INSERT INTO cuk_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham-e-mai deyob-ega-soge-itosgu, Bab-Jehová-asabin yokorgi sindigar sigided, napase e-bebe-ebulegedse dulluu imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Geb degine, Abraham-e-mai ibmar-bukidar onosad: Olomar, manimar, degi, mormar. Geb Rebecaʼga uksad. Deginbali, Abraham-e-mai Rebeca-e-susga, degi, e-nanga ibmar-bukidar binsa uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","A-sorbali, Abraham-e-mai, degi, eba-gudidimalad mas guchamalad, gobsamalad, degine, geb gabismalad. Oibosgua, Abraham-e-mai gwisgusgua, sogded: —Emi, anmar gannar an-dummad-negse-naega be anmar-imaksun. ");
INSERT INTO cuk_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ar Rebeca-e-sus, degi, e-nana, sogdemalad: —Bunagwa anmar-walik napi-ibambe (10) gudii guoye. Geb a-sorbali, naoye. ");
INSERT INTO cuk_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Abraham-e-maidi abin-sogded: —Melle bar an-igar gamalo. We-an-bese-nonikidi Bab-Jehová bela ibmar-nueganbi-guega imaksad. Degisoggu, gannar an-dummad-negse-naed be an-imakmarsun. ");
INSERT INTO cuk_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Geb degine, Abraham-e-mai-abin sogdemalad: —Anmar bunagwase gormalo, ar bunagwade igi sogdamogodibe. ");
INSERT INTO cuk_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebecaʼse gochamalad, ese egisdemalad: —¿Emisgwa we-macheredba be nabie? Bunagwa abin-sogded. —Eye, an nabie. ");
INSERT INTO cuk_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Geb degine, Rebeca-barmismarsunnad, degi, ome-gusgu-Rebeca-akwedidaedi eba nadmogad. Abraham-e-mai, degi, eba-gudidimalad nadmarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Rebeca-e-gwenadgan Rebecaʼgi ise-nued binsadmalad, weyob ega sogdemalad: “Buna, bela-bela-dulemar-mergued-nanga be gusun. Be-wagana, e-isdarmalad-neggwebur egadgaguega imaksun.” ");
INSERT INTO cuk_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Geb degine, Rebeca, degi, Rebeca-e-maimar moli-yargan-muregedgi nakwismarsunnad, Abraham-e-mai-sorba nadap gusmalad. Weyobi, Abraham-e-mai Rebeca-sesa nadsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Deunni, Isaacʼdi dia-Lajay-Roíʼye-nugadse-gudii danikid, ar ade, Neguevʼye-neg-nugadgi maid. ");
INSERT INTO cuk_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaac deunni sedogidbali binsa sapurba wis garmakdii sanaded. Agi dakalid, moli-yargan-muremalad daniki. ");
INSERT INTO cuk_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeca atakdemogu, Isaac-dani dakalid. Agine, Rebeca, moli-yargan-mureged-birgi-siidgi aideded. ");
INSERT INTO cuk_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Geb degine, Abraham-e-maise egichided: —Dule sapurba anmarsik-danikidi, ¿we doa-dule? Abraham-e-mai Rebeca-abin sogded. —We an-dummadi. Geb degi, Rebeca e-muswe susad. Geb e-wagar odukusad. ");
INSERT INTO cuk_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Geb degine, Abraham-e-mai e-ibmar-imaksad bela Isaacʼga sogsad. ");
INSERT INTO cuk_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Geb degi, Isaac e-nan-dordonegyaba Rebeca-sesad. Agi, na nikusmalad. Geb degine, Isaac Rebeca-nue-sabe gusad. Isaac, Rebeca-nikadba yeer-itodii gusad, a-ulale, e-nan-Sara-burgwisadgi wis baisur-itosad. ");
INSERT INTO cuk_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham ome-baid-nikusbalid, a-ome Ceturaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","A-omebogwa, mimmigan-nikusad wemalad: Zimram, Jocsán, Medán, Madián, Isbac, Súa. ");
INSERT INTO cuk_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsán-e-masmala, wemalad: Seba, Dedán. Dedán-e-waganmar, wemalad: Asurim-dulemar, Letusim-dulemar, Leumim-dulemar. ");
INSERT INTO cuk_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madián-e-masmaladi, wemalad: Efa, Efer, Hanoc, Abida, degi, Elda. Bela-wemala Cetura-e-wagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham bela ibmar-nikadi e-machi-Isaacʼga bela uksad. ");
INSERT INTO cuk_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Abraham omegan-baiganba-mimmi-nikusmaladgardi, unnila ibmar ega wis ichesaar binsa uksad. Amba Abraham dula-gudigua, e-mimmigan-baigan e-machi-Isaacʼgi dikasur dad-nakwedsik barmisad. ");
INSERT INTO cuk_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham birga-dulabaabak-gakambe-gakatar-sergu (175) megisad. ");
INSERT INTO cuk_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nue-selebaa-mai burgwisad, ar ade, bato burgwedginmogad. Deyob na e-sergan-burgwarmamaidse megidapmogad. ");
INSERT INTO cuk_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","E-masmala, Isaac, degi, Ismael, Mamre-dad-nakwedsik akwasaila-ollor-siid-Macpelaʼye-nugadgi, Abraham-digsamalad. A-nainude, Efrónʼgadinad. Efrónʼde Zohar-machid, Het-duled. ");
INSERT INTO cuk_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","We-nainu, Abraham Het-dulemarse baksad. We-akwasaila-ollor-siidgi e-ome-Sara-dikarba Abraham diglesad. ");
INSERT INTO cuk_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham-burgwisad-sorba, Bab-Dummad Isaacʼgi ise-nued binsasad. Isaacʼde dia-naba megidapid. We-diade Lajay-Roíʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael, Abraham Agarʼbo-machi-baksadid. Agarʼde, Sara-e-maid, Egipto-duled. ");
INSERT INTO cuk_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael-e-masmala e-gwalulesadba ilemakar naid. Weyob nugmalad: Nebaiot. A e-machi-dummad, geb a-yarba, Cedar, Adbeel, Mibsam, ");
INSERT INTO cuk_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO cuk_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis, degi, Cedema. ");
INSERT INTO cuk_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Wemala, Ismael-e-masmala-warambe-gakabogwad-e-nugmalad (12). Na megismaladgi, e-nugba neg onugsasmalad. Ar wemala, e-sordamar-e-dummadga gusmarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael birga-dulanergwa-gakambe-gakagugle-nikadgi (137) burgwisad. Deyob e-sergan-burgwarmamaidse megidapmogad. ");
INSERT INTO cuk_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael-e-wagana Egipto-yar-asabin, Havila-yar, degi, Shur-yar-abargi, Asiria-yar-igarba, ambikudapmalad. Amba e-gwenadgan egi gwisgunanaigus-inigwele, agi megidapmalad. ");
INSERT INTO cuk_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham-machi-Isaac-e-igar weyobdo. Abrahamʼga e-machi-Isaac gwalulenonikid. ");
INSERT INTO cuk_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac birga-dulabo-nikadgine (40), Rebeca-nikunonikid. Rebecaʼde, Betuel-sisgwad. E-susdi, Labánʼye nugad. Amarde, Arameo-dulemalad, Padan-Aram-neggweburgi bukwamalad. ");
INSERT INTO cuk_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca geg mimmi-baked. Degisoggu, Isaac Bab-Jehováʼse ega gochad. Bab-Jehová Isaac-ese-gochad itosad. Agi, Rebeca gurgin-nika gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ar warbogwadi amba sapidukugi-mamaiunni, bato gaemamaid. Agi, Rebeca binsaded: “¿Ar ibiga anga weyob gunai? Degisoggu, a-ular, Bab-Jehováʼse igar-aminad gusad.” ");
INSERT INTO cuk_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Bab-Jehová Rebeca-abin sogded: “Be-sapi-dukugine, neggwebur-sogabo danikid, amba yoo napnegse-aideged-idu, bato neggwebur-sogabogwad na ebo gae-nanaid. Gwensak, baidba bur-dutusur guoed, ia, urba-sogedba nanadii guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeca-e-nugued-ibagan warmaknonikid. Susugwa ega warbo uklenonikid. ");
INSERT INTO cuk_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Gebe-aidenonikidi saila gisii nikad, bela wawaadikid. A-susugwa Esaúʼye onugsasmalad. ");
INSERT INTO cuk_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Geb a-sorba, e-urba e-argan-nailikgi e-ia-maligi-akanai aidenonikid. A-ulale, Jacobʼye onugsasmalad. Deunni, Isaac birga-dulapaa (60) nikad. ");
INSERT INTO cuk_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Masmala-warbogwad dungudmalad. Esaú ibmar-make-duledid. Sapurba-gudiile, yeer-itodaed. Jacobʼdi dule-boo-daedid. Neggi-gudiile, bur-yeer-itodaed. ");
INSERT INTO cuk_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac bur bule Esaú-sabed, ar ade, Esaú-ibmar-maked-gunned yeer-itodaed. Ar Rebecaʼdina bur bule Jacob-sabmogad. ");
INSERT INTO cuk_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ibagwengine, Esaú sapurba-gudii, nue-geggus nonigua, Jacob ingwa-burwi-gisi-dunai daknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Geb Esaú, Jacobʼga sokalid: —An ukudmaada itoged, wis be anga we-ibmar-gisi-dunaid be udage. (A-ulale, Esaú, Edomʼye bilebalid). ");
INSERT INTO cuk_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob abin-sogded: —Nabirdo. Degiile, ar be machi-sailaginedsoggu, bela-bega-ibmar-uklegoed, be anga udagodo. ");
INSERT INTO cuk_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaú abin-sogded: —An ukudba burgwedanisoggu, anga-bela-ibmar-uklegoed, an bega ukodo. ¿Ar ibiga bar an we-ibmar abesunna? An abesuli. ");
INSERT INTO cuk_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Geb Jacob sogded: —Emisbinne, ise-sogar be anga sogdo, deyob an bega ibmar ukedseye. Esaú abin-sogded: —Ise-sogar an bega sogye, deyob an bega ibmar ukedseye. Esaú, machi-sailagined-guedgi-bela-ega-ibmar-uklegoed e-urba-Jacobʼga uksad. ");
INSERT INTO cuk_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Geb degine, Jacob, Esaúʼga ingwa-burwi-gisi-dualed madubo ega uksad. Esaú masgunned-bergusgua, degi, gobsabargua, gwisgusad, geb nadegusad. Weyob, Esaú na machi-sailagined-guedgi bela-ega-ibmar-uklegoedi, baisur-daksad. ");
INSERT INTO cuk_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","A-ibagangine, ukud-dummad nagunonikid, igi Abraham-ibagangi nagusmoga deyob nagunonimogad. A-ulale, Isaac Gerar-neggweburse nade gusad. Deunni, Filistea-dulemar-e-rey-Abimelec, agi maimogad. ");
INSERT INTO cuk_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Agine, Bab-Jehová Isaacʼse magarosad, ega sogded: “Melle be Egipto-yarse nao. Bia an bega sogoe, agi be megoed. ");
INSERT INTO cuk_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ar emigindi, wegi sikwas be mego. An beba gudii guoed, degine, ise-nued an begi binsaoed. Ar ade, begala, degine, be-wagangala we-yar an ukoed. Ar igi be-bab-Abrahamʼga ise-sogar an sogsa, deyob an imakedsegad. ");
INSERT INTO cuk_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Be-wagan ichesur niisgwamar-nibneggi-merguedyob an imakoed. Be-wagangala bela we-yar ega an ukoed. Deginbali, bela dulemar-we-napneggi-bukmalad be-wagwaba ise-nued an egi binsaoed. ");
INSERT INTO cuk_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ar ade, Abraham an-sogedba, an-igar-maidba, an ega ibmar-sogsadba, an-ibmar-odurdakedba nanadii gusad.” ");
INSERT INTO cuk_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Geb degine, Isaac Gerarʼgi bessunnad. ");
INSERT INTO cuk_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Dulemar-Gerarʼgi-bukmalad ese egichiarmargu, we-Rebeca, doaye, Isaac dobe-soggusad, Rebeca e-omeye. Degisoggu, sogdedaed, Rebeca e-bunye. Ar Rebeca yeerdaklesoggu, Isaac binsaed, abakalegi machergan-we-yarginmalad Rebeca-ular an-oburgwiarmalarye. ");
INSERT INTO cuk_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ibagan-nasad-sorbali, ibagwengi Isaac Gerar-neggweburgi-maidgine Filistea-dulemar-e-rey-Abimelec yawagak-bipigi-atakgwichidgi dakalid, Isaac e-ome-Rebeca-ibe wagar unai. ");
INSERT INTO cuk_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Geb degine, Abimelec, Isaacʼbina gochad, ega sogded: —Etto, ¿Rebeca, we be-ome? ¿Ar ibiga be anmarga sogsa, Rebeca an-bunye? Isaac abin-sogded: —Ar ade, an binsasad, abakalegi we-ome-ular an-oburgwiarmalarye. ");
INSERT INTO cuk_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ar Abimelecʼdi abin-sogded: —¿Ar ibiga-wede deyob be anmar-imaksa? Machered-gwensak, we-neggweburgined ar be-omese gochana, isguega be anmar-imaksanad. ");
INSERT INTO cuk_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Geb degine, Abimelec bela e-sordamarga igar mesisad: —Ar dule-wargwen we-machered-ibgwensur-imakalile, igidibe, e-omese achaalile, we-dule oburgwilegoye. ");
INSERT INTO cuk_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","A-birgagine, Isaac na e-maidgi ibmar-gwag-digsadi bela-belad nue wesad, ar ade, Bab-Jehová ise-nued egi binsasad. ");
INSERT INTO cuk_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaac mani-ibed gunonikid, ibmar-bukidar-nika gunonibalid: ");
INSERT INTO cuk_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sibad-wawaadmar, moli-bebe-nikamalad, degi, maigan ichesur-nika gunonikid. A-ulale, Filistea-dulemar egi nobguarmalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","A-ular, Filistea-dulemar diamar omulusmalad, napa egi eosmalad. A-diamarde, Isaac-e-bab-Abraham dula-gudigua, Abraham-e-maimar akwismalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Geb degine, Abimelec, Isaacʼga sogdesunnad: —Ar be anmarba bur gannarbasoggu, wegi-maid be nae. ");
INSERT INTO cuk_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Geb Isaac Gerar-nebase nade gusad. Geb agi megidapsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Abraham dula-gudigua, diamar akwisad. A-diamar Abraham-burgwisgu, Filistea-dulemar omulusad. A-diamar gannar Isaac akwisad. Isaac a-diamar e-bab-onugsasadba gannar onugsasmogad. ");
INSERT INTO cuk_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ibagwengine, Isaac-e-maimar nebagi dia-akwinanaigua, dii-aryomai amismalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ar Gerar-nebagi-sibad-wawaad-edarbedimaladdi Isaac-sibad-wawaad-edarbemalad-ebo uluarmalad, ar ade, sogmalad: We-dii anmargadye. A-ulale, Isaac we-dia Esekʼye onugsasad. A-sogleged: Urwedye. Ar ade, a-diabina ulusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A-sorbali, Isaac-e-maimar dia-baid akwismarbalid. Gerar-dulemar a-diabina uluarmarbalid. A-ular, Isaac a-dia Sitnaʼye onugsasad. A-sogleged: Na isdar-dakmaladye. ");
INSERT INTO cuk_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Agi, Isaac dikasur nadsunnad. Agi, dia-baid akwidapid. Ar we-dia-binardi ulussurmarsoggu, Isaac Rehobotʼye dia-onugsasad. A-sogleged: Na e-itoleged-gudiguedye. Ar ade, soged: “Ar emigindi, Bab-Jehová anmar nabir-itodiguega, anmarga we-neg uksad, adi, anmar wegi nasguegar.” ");
INSERT INTO cuk_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Isaac agi-mai, Beersebaʼse nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","A-mutikidgine, Bab-Jehová Isaacʼse magarosad, ega sogded: “Ani, an be-bab-Abraham-e-Bab-Dummadid. Melle be dobguo, an beba gudiguad. An-mai-Abraham-ulale, begi ise-nued an binsaoed, wagan-bukidar an bega ukoed.” ");
INSERT INTO cuk_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Agine, Isaac ibmar-ogumakar-ukleged-aila sobsad. Geb Bab-Jehováʼse gochad. Beersebaʼgi Isaac megidapid. Geb e-maimar agi dia akwismalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ibagwengine, Abimelec Isaacʼbo sunmakega Gerar-akar nonikid. Eba e-ai-Ahuzat nonimogad, degi, Abimelec-e-sordamar-e-dummad-Ficol nonimogad. ");
INSERT INTO cuk_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac Abimelecʼga sogded: —¿Ibiga be an-dakdanimala? Ar bemar an-abesulid, degine, bemar-yargi be an-ononnosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Abimelec Isaac-abin sogded: —Bab-Jehová beba gudigu anmar daked. Emigi, anmar bega sogbied, anmarbo be igar mesye. Weyob anmar igar mesmalodo: ");
INSERT INTO cuk_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Be anmargi ichakwa daosulid. Anmar begi ichakwa daosurmogad. Ar anmar gusgu nued begi damalad, anmar nuedgi be-barmiarmalad. Ar emide, Bab-Jehová begi ise-nued binsamaid. ");
INSERT INTO cuk_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Geb degine, Isaac Abimelecʼga iba-dummad onosad. Emar nue-mas guchamalad, degi, nue-gobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Oibosgua, wakudaryalabali gwisgusmalad, ise-sogar na ega sogsamalad, anmar we-ibmar-sognaid imakedseye. Geb agine, Isaac Abimelecʼga sogded, degimaloye, geb Abimelec-e-sordamala Isaacʼga sogdemarmogad, degimaloye. Degine, aigwale na egi bangudmalad. ");
INSERT INTO cuk_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Amba a-ibagine, Isaac-e-maimar Isaacʼga gaya-nued senonimalad, ega sognonimalad: Anmar dia-akwinanaidgi dii amismarye. ");
INSERT INTO cuk_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Isaac a-dia Sebaʼye onugsasad. A-ulale, a-neggwebur deyob Beersebaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaú birga-durbo-nikadgine (40), Judit-nikusad. Juditʼde Beeri-sisgwad, Het-duled. Esaú, Basemat-nikusbalid. Basematʼde Elón-sisgwad, amba Heteo-dulemogad. ");
INSERT INTO cuk_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","We-omegan-warbogwad, Isaacʼga, degi, Rebecaʼga nunmaked-dummad onosad. ");
INSERT INTO cuk_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac bato nue selebagusad, degi, aku-atakgusbalid. Ibagwengine, Isaac, e-machi-dummad-Esaúʼse gochad. Geb ega sogded: —¡Machi! Esaú abin-sogded: —Degite. ¿Ibua? ");
INSERT INTO cuk_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Geb Isaac sogdebalid: —Mag be an-daked, an nue-selebagusad. Ukiar sunna an burgwed. ");
INSERT INTO cuk_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","A-ular, sapurba-nabi an be-abedo. Anga ibmar-maknaega warsi be sedo, sigu be sedbalo. ");
INSERT INTO cuk_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ibmar be maksale, an mas-gunbidaedyob ise-nue-imakar be anga mas saoed. Geb we-mas-gunnega be anga sedagoed. A-sorba, an-burgwed-iduar, ise-nued-an-begi-binsaedgi an bega ibmar sogoed. ");
INSERT INTO cuk_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isaac-Esaúʼga-ibmar-sogsadi, Rebecaʼdi bela itosad. A-ular, Esaú sapurba e-babga ibmar-maknadgu, ");
INSERT INTO cuk_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","a-sorba, Rebeca e-machi-bipigwad-Jacobʼga sogded: —Nue be an-itogo. Be-bab, be-ia-Esaúʼga sunmakgwisgu, ega-soge an itosad: ");
INSERT INTO cuk_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Sapurba be ibmar-maknaye, a-mas ise-nue-imakar anga be saoye. Geb an burgwed-iduar Bab-Jehová-asabin, an-begi-ise-nued-binsaedgi an bega ibmar sogoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Machi, degisoggu, nue be an-itogo. An-ibmar-bega-sogoedba, bela be imako. ");
INSERT INTO cuk_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Degisoggu, sibadmar-bukwadse be nae, sibad-mimmi-senigwad-warbo-bur-nuedid be anga sedago. Be-bab mas-gunbidaedyob an ise-nue-imakar an ega mas saoed. ");
INSERT INTO cuk_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Geb degine, be-bab a-mas-gunnega ega be sedoed. Adi, be-bab e-burgwed-iduar, ise-nued-binsaed bega sogoed. ");
INSERT INTO cuk_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ar Jacobʼdi e-nan-Rebecaʼga sogded: —Ar nabir be sogendo. Ar an-iadi wawaad. Andi degisulid. ");
INSERT INTO cuk_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ar an-bab an-abagan-ebualile, mag an-itogoed, ande an Jacobʼad. Geb angi binsaoed, an egi dodonaiye. Ar bur an-ukabsaoed, ise-nued-angi-binsaed bar anga sogosulid. ");
INSERT INTO cuk_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ar e-nandi Jacob-abin sogded: —Machigwa, be ukabsaleye sogele, ani an ukabsalegoed, bedi ollordo. Degisoggu, an-ibmar-bega-sognaidba be imake. Sibad-mimmi-senigana-warbo be anga sedage. ");
INSERT INTO cuk_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob sibad-mimmi-seniganabina naded. Geb e-nanga senonikid. Agi e-nan Isaac-mas-abedaedyob sibad-e-san ise-nue-imakar imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Geb degine, Rebeca, e-machi-dummad-Esaú-e-mor onosad. A-morde bur mor-nuedid, e-neggi ise-nue-saboar bukwad. Agine, Rebeca e-machi-bipigwad-Jacobʼga a-mor-yoega uksad. ");
INSERT INTO cuk_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Geb deginbali, Rebeca sibad-bipi-e-uka-wawaadgi Jacob-e-surgan, degine, e-dukarba obipirmaksad, bia absarsuli-nanaedgi nasiksad. ");
INSERT INTO cuk_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Geb degine, Rebeca mas ise-nue-saale Jacobʼga uksad, adi, Jacob e-bab-Isaacʼga ukegar. Geb madu-imaksadi ega uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Geb degine, Jacob, e-bab-siidse dogdapid, ese gordapid: —¡Baba! Isaac abin-sogded: —An wegi sii. ¿Be biti-an-machi? ");
INSERT INTO cuk_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob abin-sogded: —An, Esaú, be-machi-dummad. Be anga-sogsadba bato an imaksad. Baba, be-dage. Wis wese be sigdage. An-ibmar-maksad be gundage. Geb be ise-nued-angi-binsaed be anga sogoed. ");
INSERT INTO cuk_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Geb degine, Isaac e-machiga sogded: —Machi, ¿igi nabir bato be ibmar abingusbinne? Jacob e-bab-abin sogded. —Bab-Dummad-Jehová gwae-gwae ibmar-abinguega an-bendaksad. ");
INSERT INTO cuk_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ar e-bab-Isaacʼdi abin-sogded: —Anse be dage, an be-ebubie, bule be an-machi-Esaú-sunnaddibe. ");
INSERT INTO cuk_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob e-bab-walikaa naded, adi, e-ebugegar. Geb degine, Isaac sogded: —Be-sunmaked Jacobʼyob be sunmaked. Be-sakwamardi Esaú-sakwamar an itoged. ");
INSERT INTO cuk_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isaac Jacob-e-sakwamar e-ia-Esaú-sakwamaryob absar yaisur-itossoggu, Isaac magar-itossulid. A-ular, Isaac ise-nued-binsaed Jacobʼga soged-iduale, ");
INSERT INTO cuk_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","gannar Jacobʼga sogded: —¿Ar nue be an-machi-Esaú-sunnadi? Jacob abin-sogded: —Eye, an Esaú-sunnadi. ");
INSERT INTO cuk_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Geb degine, e-bab Jacobʼga sogded: —Machi, anga be mas dake, adi, be-ibmar-maksad an gunnegar. Geb a-sorba, an-ise-nued-begi-binsaed an bega sogoed. Jacob e-babga mas daksasunnad, degi, ega vino senonibalid. Isaac nue-mas-guchad, degi, nue-gobsabalid. ");
INSERT INTO cuk_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Geb degine, Isaac Jacobʼga sogded: —Machi, anse be dage, be an-wagar udage. ");
INSERT INTO cuk_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob e-bab-wagar-uega e-bab-walikaa nonigua, e-bab, Jacob-mor-yoid usad. Geb degine, Isaac, Jacobʼgi-nued-ise-binsadedba, ega weyob sogded: “Eye, weyob an-machi-Esaú yapanned. E-yapannedi sapuryob yapanned Bab-Jehová sapurgi ise-nued binsasadyob yapanned. ");
INSERT INTO cuk_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Bab-Dummad bega nibneggi dii-boo-mimai saoed. We-napneggi nainumar-nuegan bega ukoed, orosgi-dakleged-e-gwag-bukidar bega ukoed, vino-bukidar bega ukoed. ");
INSERT INTO cuk_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dulemar-yar-baid-baidgi-bukmaladi bukidar bega arbamalaga gumaloed, dulemar-akar-akar-soga-iliba be-asabin yokorgi-sindigar sigmaloed. Be-gwenadgan-e-iduedga be guoed. Be-nan-e-masmala be-asabin bela sindigar sigmaloed. Dulemar-be-ukabsamalale, amar ukabsalemogoed. Dulemar-ise-nued-begi-binsamalale, amargi ise-nued binsalemogoed.” ");
INSERT INTO cuk_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac, ise-nued-binsaed-Jacobʼga-sognaid bergusgua, Jacob nodeyalaba, Esaúʼdi sapurba-ibmar-makdiid dognonikid. ");
INSERT INTO cuk_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Esaú mas nued-gulle e-babga imaksamogad. Geb e-babga sesa gusad, ega sogdapid: —Baba, be gwisgu. Be-machi, bega ibmar-maksad be gunne, be-angi-ise-nued-binsaed be anga sogsun. ");
INSERT INTO cuk_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Geb degine, Isaac, Esaúʼga sogded: —¿Be doa-dule? Esaú abin-sogded. —Ani, an Esaú, be-machi-gebesailagined. ");
INSERT INTO cuk_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac geger-itoged, nue-wawanmake sogded: —Degite, ¿wede doa be-iduar ibmar-maksad, yeer-gulle anga senonisunna? Be-nonikid-iduar, dule-anga-mas-senonikid bela an guchad. Bato be-iduar-dule-arbidga, egi ise-nued-binsaed bela an ega sogsad. Ar emigindi, bato egi ise-nued binsalessunnad. Geg bar an oakaloged. ");
INSERT INTO cuk_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaú, e-bab weyob ega soge itosgu, nue-nunmak binnasur ise-ogormakar boded. Geb e-babga sogded: —¡Baba, ise-nued-binsaed be anga sogmoga! ");
INSERT INTO cuk_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ar Isaacʼdi e-machi-abin sogded: —Be-urba bato anse arbid. An-yardaksad. Ise-nued-binsaleged begadinad, be-ibe atursasad. ");
INSERT INTO cuk_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Geb Esaú sogded: —¡Ar nabir ega Jacobʼye nug nasiksamala! ¡Ar emide ilabogus an-yardakdanikid! Gebe unni, an machi-sailagined-guedba anga ibmar-uklegoenad an-ibe susad. Emide, angi ise-nued-binsaleged an-ibe susbalid. Esaú sogdebalid: —Baba, degite, angi ise-nued-binsaleged, ¿wis be anga obessuli? ");
INSERT INTO cuk_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Geb degi, e-bab-Isaac abin-sogded: —Be-dummadga-gued-igar Jacobʼga an uksad. Bela e-gwenadgan e-maiga-gued-igar, an ega uksabalid. ”An-ise-nued-egi-binsaedba, an ega sogsabalid: Bitigi orosgi-dakleged-bukidar nikuena gadinye, degine, vino-bukidar nikubalina gadinye. Ar emigindi, machi, ¿igi-bar-an-saosunna?” ");
INSERT INTO cuk_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaú e-babgi alamaknai gusad: —¿Baba, be-ise-nued-binsaed wis soggwensaar geg be anga soge? ¡Be angi ise-nued binsamoga! Degine, Esaú gannar ise-ogormakar bodbalid. ");
INSERT INTO cuk_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Geb, Isaac na e-machi-Esaúʼga sogded: “Napaneg-nuedgi be megosulid, degine, nibneggi-boo-batedi sate be gubaloed. ");
INSERT INTO cuk_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Be-es-suidgi na be san bendakdii guoed. Degine, be-urba-e-maiga be gubaloed, ar be dutusur-gusale, geb be-urbagi be nooed.” ");
INSERT INTO cuk_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Weyob-gusad-akale, Esaú, Jacob-sae-dakded, ar ade, e-annik ise-nued-egi-binsaleged egwachad. Degisoggu, Esaú binsadisunnad: “Emisgwasaar an-bab-burgosoggu, aba anmar bukib-binsadii guoed. A-sorbali, an-urba-Jacob anse oburgwilegoye.” ");
INSERT INTO cuk_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Rebeca wisgusgu igi e-machi-dummad-Esaú binsadii, e-machi-bipigwad-Jacobʼse gochad, ega sogded: —Be-ia-Esaú be-oburgwebi gudiid. Yamo baisur-itogeyob gudiid. ");
INSERT INTO cuk_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Degisoggu, machi, nue be an-itogo: Emisbinne, Harán-neggweburse an-sus-Labán-e-negse be wakinne. ");
INSERT INTO cuk_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Agi, be-ia sae-itoged baisur-ito-gusadse be undar gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Be-ia-Esaú ibmar-iegedse be gudii guoed. A-sorba, be gannar-dagega an be-owisogoed. Ar iba-galagwengi an-masmala-warbobela an surgubisulid. ");
INSERT INTO cuk_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Geb degine, Rebeca e-sui-Isaacʼga sokalid: —Esaú, Het-dule-e-sisgwa-nikusad-ular, an budar-itogusad. We-Canaán-yargi Het-dulemar-bukwad-e-sisgwa-wargwen-weyob-damogadi Jacob nikusale, ar an bur burgwed, nabirid. ");
INSERT INTO cuk_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Geb degine, Isaac Jacobʼse gochad, geb egi ise-nued binsasad. Geb ega sogded: —Melle we-yar-Canaánʼgined-ome be nikuo. ");
INSERT INTO cuk_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Padan-Aram-neggweburse, be-nan-e-bab-Betuel-negse be nao. Agi, be-nan-e-sus-Labán-e-sisgwa be nikuo. ");
INSERT INTO cuk_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bab-Dummad-Bela-Gangued-Nikad ise-nued begi binsaena gadin, degine, bukidar-mimmigan bega ukbalina gadin, adi, begi dulamar-bukidar ainiegar. ");
INSERT INTO cuk_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Bab-Dummad Abrahamʼgi ise-nued binsasad, begi, degi, be-wagangi ise-nued binsamogana gadin. Adi, we-yar-anmar-egi-gudiid begadga guegar. We-yarde, Bab-Dummad, Abrahamʼga uksad. ");
INSERT INTO cuk_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Weyobi, Isaac Padan-Aram-neggweburse Jacob-barmisad. Jacob, Labán-negse modapid. Labánʼde Arameo-dule-Betuel-e-machid, Rebeca-e-susud. Rebecaʼde Jacob, degi, Esaú-e-nanad. ");
INSERT INTO cuk_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú daksad, e-bab-Isaac Jacobʼgi ise-nued-binsaleged ega sogsa. Geb degine, Padan-Aram-neggweburse ome-nikuega Jacob-barmisbali. Esaú daksabalid, e-bab Jacobʼgi ise-nued-binsasgu, ega sogsagusad, melle Canaán-ome be nikuoye. ");
INSERT INTO cuk_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jacob, e-bab, degi, e-nan ega sogsadba imaksad. Jacob Padan-Aram-neggweburse nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Weyob-gusadba, Esaú magar daksad, e-bab Canaán-omegan-nabir gwen daksuli, ");
INSERT INTO cuk_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","a-ulale, Esaú Ismael-daknadgusad. Ismaelʼde Abraham-e-machid. Esaú Ismael-e-sisgwa-Mahalatʼye-nugad nikusad. Mahalatʼde Nebaiot-e-bunad. A-iduale, Esaú bato Canaán-omegan nikumaibalid. ");
INSERT INTO cuk_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob, Haránʼse naega Beersebaʼgi node gusad. ");
INSERT INTO cuk_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Nadapgu, bia ega neg-mutikgude, agi gabided. Nono nakwis-megegala akwa amisad, e-nono-urba siegar. Agi, gabided. ");
INSERT INTO cuk_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Geb Jacob, gabdakargu, dakalid, arsan napagi-gwichidi nibnegse-warmakgwichi. A-arsangi Bab-Dummad-baliwiturmar nakwemamai, degine, aidemamai daksad. ");
INSERT INTO cuk_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Jacob daksabalid, Bab-Jehová arsan-birgi gwichi. Bab-Jehová ega sogded: “Ani, an Bab-Jehová, be-dad-Abraham-e-Bab-Dummad, be-bab-Isaac-e-Bab-Dummad. Begala, degine, be-wagangala, be-gabmaid-napanega an ukoed. ");
INSERT INTO cuk_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Be-wagan we-napneg-ukub-merguedyob bela-bela mergu guoed. Degine, be-wagan dad-nakwedsik, dad-argwanedsik, dad-nakwed-argan-nuedsik, dad-nakwed-argan-sapiledsik bela aisakis ambikuoed. Degine, bebali bela dule-yar-baid-baidgi-bukwamalad, degi, be-waganbali, egi ise-nued binsalegoed. ");
INSERT INTO cuk_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","An beba gudiguad. Bia be nade sogele, an beba gudii guoed. Gannar we-yarse be daged, an be-imakoed. An be-metosulid, bela an bega-ibmar-sogsad an imakoed.” ");
INSERT INTO cuk_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob gabdakmaid-ataksagua, binsaded: “Nue-napiragwad. Bab-Jehová wegi gudiid an wissulinad.” ");
INSERT INTO cuk_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Jacob nue-dobe itoded, binsaded: “We-nega, nega-islidikidid. Wegi Bab-Dummad maid. ¡Wegi, nibnegse-doged-yawagak gwichid!” ");
INSERT INTO cuk_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Oibosgu, wakudaryalaba Jacob gwisgusad. E-nono-megega-akwa-ebusad susad. A-akwa ogwichisad. Geb, gwallu-wawa egi eosad, adi, oyogega, wede nue-islidikidye. ");
INSERT INTO cuk_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Iduale, agi neggwebur-siidi, Luzʼye nuganad. Jacobʼdi a-neggwebur Betelʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Agi, Jacob weyob ise-sogar sogsad: “Ar Bab-Dummad anba gudiguale, an emi-nadapidgi an-edarbele, anga masgunned ukele, degi, anga mor-yoed ukbalile, ");
INSERT INTO cuk_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","degine, an-bab-negse nuedgi, ise-bendaklegaledgi gannar an aibilisale, ar deyobile, Bab-Jehová an-Bab-Dummadga an imakoed. ");
INSERT INTO cuk_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","”We-akwa an ogwichisad, we Bab-Dummad-e-negga guoed. ”Bab-Dummad, bela ibmar-be-anga-ukoedi, ambegi gwensak (10%) an bega ukoed.” ");
INSERT INTO cuk_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob dulemar-dad-nakwedsik-bukmaladse nade gusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Sapurba-nadapidgi dia sii dakalid. Ar sibad-wawaadmar a-dii gobdamarsoggu, a-dikarba sibad-wawaadmar-danapaa obunnobukwa dakdapid. Dia-birgindi, akwa-dummad siid. ");
INSERT INTO cuk_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Bela sibad-wawaadmar danar ase ambikunonikile, sibad-wawaad-edarbemalad akwa-dummad onir damalad, adi, diigi sibad-wawaad-ogobmalagar. Geb a-sorbali, gannar akwa-dummad dia-birgi sidamalad. ");
INSERT INTO cuk_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob sibad-wawaad-edarbemaladse egichided: —¿An-aimar, bemar biarmaladi? Abin-imaksamalad: —Anmar Harán-neggweburginedi. ");
INSERT INTO cuk_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Jacob amarga sogdebalid: —¿Bemar, Nacor-e-machi-Labán-mag-dake? Abin-imakdemalad: —Eye, anmar mag dake. ");
INSERT INTO cuk_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Jacob ese egisdebalid: —¿Labánʼde nued gudii? Sibad-wawaad-edarbemalad abin-imakdemalad: —Eye, Labán nued gudii. Be dakena, e-sisgwa-Raquel e-sibad-wawaadmar sedanikid. ");
INSERT INTO cuk_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Geb degine, Jacob sogded: —Sibad-wawaad e-urbilegedgi-urbelegegala amba dad-dikasulid. ¿Ar ibiga bemar geg sibad-wawaadmarga dii ukmala? Geb sorbali, bemar sibad-wawaadmar-gagan-mamalaga gannar sedmaloed. ");
INSERT INTO cuk_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ar sibad-wawaad-edarbemaladdi abin-sogdemalad: —Geg anmar deyob imakmalad. Anmar gusgu bela sibad-wawaadmar-danar-ambikued edarbedamalad. Adi, anmar akwa-dummad-dia-edisiid oniregar. Geb anmar sibad-wawaadmar diigi ogobmaloed. ");
INSERT INTO cuk_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jacob, dulemar-ebo sunmakgwisgua, Raquel e-bab-sibad-wawaadmar senonikid. Ar Raquel e-babga sibad-wawaadmar-edarbedga gudiid. ");
INSERT INTO cuk_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Raquelʼde, Labán-e-sisgwad. Labánʼdi, Rebeca-e-susud. Jacob, e-gilor-Labán-sisgwa Labán-sibad-wawaadmar-sedani-daksagu, dia-birgi akwa-dummad-siid-onirega nade gusad. Geb onirisgua, sibad-wawaadmarga dii uksad. ");
INSERT INTO cuk_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Geb degine, Jacob Raquel-wagar-udapid, ega sogega, be nued sogeye. Geb degine, Jacob binnasur boded. ");
INSERT INTO cuk_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob Raquelʼga sogdesun, ede Rebeca-machiye. Labánʼdi e-gilorye. Geb Raquel deyob itosgu, e-babga-sogega abarmakde gusad. ");
INSERT INTO cuk_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labán itoargu, e-bun-Raquel-machi-Jacobʼgi ega sunmake, agi Labán abarmakded, Jacob-abin-daknaegar. Modapgu, Jacob e-nigasoggu, ise-angaagwar Jacob-imakdapid, ei-wagar usbalid, ega sogega, be nued sogeye. Geb agine, e-negse Jacob-sesad. Geb degine, Jacob bela e-gusad-igar Labánʼga sogsad. ");
INSERT INTO cuk_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Labán Jacobʼga sogded: “Ar be nue anbo ablis-mesadid.” Jacob Labán-walik nii-walagwen gudii gualid. ");
INSERT INTO cuk_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Niigwen-gusad-sorbali, Labán Jacobʼga sokalid: —Be an-gwenad-inigwele, binsa geg be anga arbaed. Anga be soge, igi-mani be-bennukbi be an-abege. ");
INSERT INTO cuk_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Dakargu, Labán sisgan-warbo-nikad: Dummad, Leaʼye nugad. Bipigwaddi, Raquelʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea e-ibya mommoo dakleged. Raquelʼdi bela-bela yeer dakleged. ");
INSERT INTO cuk_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ar Jacob Raquel-abearsoggu, Labán-abin sogded: —Be-sisgwa-bipigwad-Raquel an nikuegala, an bega birgagugle (7) arbaoed. ");
INSERT INTO cuk_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Geb degine, Labán Jacob-abin sogded: —Ar an-sisgwa dule-baidga-ukedba bur an bega uked nabirid. Degisoggu, be an-walik beedo. ");
INSERT INTO cuk_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ar weyob Jacob Raquel-nikuegala birgagugle (7) arbasad. Ar Jacob nue-Raquel-abesoggu, dogdar birga-suitii itossulid. ");
INSERT INTO cuk_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Birgaguglegus (7) Jacob arbaedgine, Labánʼga sokalid: —Ar an bega sogsadyob Raquel-nikuega bato birgaguglegus (7) an bega arbadanisoggu, anga be Raquel-udage. ");
INSERT INTO cuk_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Geb degi, Labán e-neg-dikarba-neg-baidsik-mamaidse gochad, adi, e-sisgwa-sui-nikued-ibase dagmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","A-mutiki, Labánʼdi e-sisgwa-Lea-sesad, Jacobʼga ukdapid. Jacobʼdi Raquelʼye biensoggu, aga Leaʼse gochasunnad. ");
INSERT INTO cuk_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Aginbali, Labán e-sisgwa-Leaʼga e-mai-wargwen uksad, adi, Leaʼga ibmar-imakegar. A-mai, Zilpaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Neg-oibosgu, Jacob dakalid, Lea e-dikarba mai. Degisoggu, Jacob Labánʼga sokalid: —¿Igi be an-imaksa? Be angi dodo-soge. ¿Ar ande Raquelʼbina an bega arbassursi? ¿Ibiga degite be an-yardake? ");
INSERT INTO cuk_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Labán Jacob-abin sogded: —Wegine, anmarga-igar-maisulid, urba e-ior-idu sui-nikuoye. ");
INSERT INTO cuk_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Degisoggu, igar-maidba Lea bebogwa itoged-irgwen gudii guodo. Geb a-sorbali, an bega Raquel-ukbaloed, ar be soger, Raquelʼbina birgagugle (7) an bega arbabaloye. ");
INSERT INTO cuk_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob sogsado, eyeye, ede arbaoye. Lea-nikusad-itoged-irgwenad-bergusgu, Labán Jacobʼga Raquel-uksabalid, adi, Jacob Raquel-nikuegar. ");
INSERT INTO cuk_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán e-mai-wargwen Raquelʼga uksamogad, adi, Raquelʼga ibmar-imakegar. A-mai, Bilhaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob Raquelʼse gochad. Jacob, Leaʼba-bur bule Raquelʼbina sogsasoggu, degidbali, amba birgagugle (7) Labánʼga arbadii gusbalid. ");
INSERT INTO cuk_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Bab-Jehová dakdegu, Jacob bur Lea-baisur-dake, Lea mimmi-nikuega imaksad, Raquelʼdi geg mimmi-bake imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea bonigwar gunonikid. Bab-Jehová-machigwa-ega-uksadi, Rubénʼye onugsasad, ar ade, soged: “Bab-Jehová wile-itodiid an-daksad. Ar emigindi, an-sui an-sabguoed.” ");
INSERT INTO cuk_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","A-sorbali, Lea machigwa-baid-nikunonibalid. Adi, Simeónʼye onugsasad. Geb agi sogded: “Bab-Jehová an-sui-baisur-an-daked daksad. A-ular, Bab-Jehová machigwa-baid anga uksabalid.” ");
INSERT INTO cuk_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Lea gannar machigwa-baid-nikunonibalid. Adi, Levíʼye onugsanonikid. Ar ade, Lea soged: “An-suiba machimala-walapaagus an bakdanisoggu, ar emigindi, an-sui bur bule an walikaa guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea amba machigwa-baid-nikunonibalid. Adi, Judáʼye onugsasad, ar ade, Lea soged: “Ar emigindi, Bab-Jehová-nug an odummogoed.” A-sorbali, Lea mimmigan-nikued galesad. ");
INSERT INTO cuk_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquel geg Jacobʼga mimmi-bake-itoargu, e-ior-Leaʼgi nobgualid. Raquel e-sui-Jacobʼga sogded: —¿Ibiga geg be anga mimmi bake? Mimmi an abege. Be anga baksulile, an burgoed. ");
INSERT INTO cuk_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacobʼdi Raquelʼse uluded, ega sogded: —¿Ar ani an Bab-Dummadsi? Ar Bab-Dummad geg mimmi-bake be-imaksad. Ani an deyob be-imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Geb degine, Raquel Jacobʼga sogded: —An-mai-Bilhaʼse be gole. A-omegwa mimmigan-nikusale, an-sunnad mimmigan-nikusadyob an guoed. ");
INSERT INTO cuk_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Weyob Raquel e-sui-Jacobʼga e-mai-Bilha-uksad, adi, Jacob Bilhaʼse golegar. Geb degine, Jacob Bilhaʼse gochad. ");
INSERT INTO cuk_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Agi, Bilha bonigwar gunonikid, Jacobʼba machi-wargwen baknonisunnad. ");
INSERT INTO cuk_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Geb degine, Raquel sogded: “Ar Bab-Dummad anga igar-nued imaksad. Ar Bab-Dummad an ese-gordiid an-itosadba, anga machigwa uknonikid.” A-ular, we-machigwa Danʼye nugguoed. ");
INSERT INTO cuk_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A-sorbali, Raquel-e-mai-Bilha machigwa-baid Jacob-ebo baknonibalid. ");
INSERT INTO cuk_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Agi, Raquel sogded: “An-iorbo an nue-urwedii gusad, emidi an egi obichad. A-ular, we-machigwadi Neftalíʼye nugguoed.” ");
INSERT INTO cuk_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea geg bar mimmigan-bake-itoargu, e-mai-Zilpaʼye-nugad, Jacobʼga uksad, adi, Jacob Zilpaʼse golegar. ");
INSERT INTO cuk_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Agi, Zilpa Jacobʼba machigwa baknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Geb degi, Lea sogded: “¡Ibiyob nued angi binsalesa!” A-ulale, a-machigwa Gadʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Geb a-sorbali, Lea-e-mai-Zilpa Jacob-ebo machigwa-baid baknonibalid. ");
INSERT INTO cuk_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Geb agine, Lea sogded: “¡Yeer-itoleged! Emigindi, omegan sogmaloed, ande weligwar-itoye.” A-ulale, machigwa Aserʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ibagwengine, orosgi-dakleged-trigo-weed-ibagangine, Rubén sapurba naded. Agi, sapi-bipi-sanmar mandrágoraʼye-nugad amisad. A-sapi-bipi-sanmar e-nan-Leaʼga sesad. Raquel a-sanmar-daksagu, Leaʼga sogded: —Mandrágora-e-sanmar be-machi-bega-senonikid, wis be anga udamoga. ");
INSERT INTO cuk_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ar Leaʼdi abin-sogded: —¿Ar emide, be angi-sui-egwachad, unni be itosursi? Ar emide, mandrágora-sanmar an-machi-anga-senonikid be abebalid. Raquel abin-sogded: —Be-machi-mandrágoraʼmar-bega-senonikid be anga ukele, emi-mutik Jacob bese goloed. ");
INSERT INTO cuk_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Sedogidba, Jacob sapurba-gudidanigu, Lea Jacob-abin noded, ega sogded: —Emi-mutik be anse goloed, ar ade, an-machi mandrágora-e-san-anga-senonikidbo an be-ogwasad. A-mutik, Jacob, Leaʼse gochasunnad. ");
INSERT INTO cuk_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bab-Dummad Lea-ese-goled-itosadba, Lea bonigwar gunonisunnad. Lea wesega Jacobʼga masmala walatargus bakdanikid. ");
INSERT INTO cuk_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Geb degine, Lea sogded: “Ar an-suiga an-machi an uksadbali, Bab-Dummad nabir angi binsasad.” Lea we-machigwa Isacarʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Geb a-sorbali, Lea baid-machigwa Jacob-ebo nikunonibalid. Agi, machimala walanergwa (6) guded. ");
INSERT INTO cuk_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea sogded: “Bab-Dummad ibmar-nued anga uksad. Emigindi, an-sui bur-yeer an-dakoed, ar ade, an ega masmala walanergwagus (6) nikudanikid.” A-ulale, we-machigwa Zabulónʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Napidgine, Lea bunolo nikunonikid. A-bunolo, Dinaʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Bab-Dummad Raquelʼgi nued binsadmogad. Bab-Dummad Raquel-ese-goledi itosad, mimmigan-nikuega imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Geb degine, Raquel bonigwar gunonisunnad, machigwa ega uklenonikid. Agi, Raquel sogded: “An geg-mimmi-bakedba an-bingegudiidi, Bab-Dummad anga osulosad. ");
INSERT INTO cuk_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Bitigi Bab-Jehová baid-machigwa anga ukbalina gadin.” A-ulale, machigwa Joséʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raquel goe-José-baksad-sorbali, Jacob Labánʼga sogded: —An-yarse gannar an naega be anga igar uke. ");
INSERT INTO cuk_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ar be nue-wisid, igi an-omegan-ular an bega arbasa. Degisoggu, an-omeganga, degi, an-mimmiganga be igar uke, anba namalagar. ");
INSERT INTO cuk_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ar Labánʼdi abin-sogded: —Ar nued be angi binsaele, mer be nagwele, wis be napi-begwele. Ar an nerse-oyosadba an wisgusad, be-nukad, Bab-Jehová ise-nued angi binsamaid. Labán Jacobʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","—Anga be sogdo, igi-manigi anga be arbaoe. An be-bennukoed. ");
INSERT INTO cuk_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Geb degine, Jacob ega sogded: —Ar nue be wisid, igi an bega arbasa, igi an bega be-ibmar-durgan an akwisa. ");
INSERT INTO cuk_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","An-nonikid-idu ibmar-ichee-be-nikadi, bega napiragwad merguded, ar ade, an bese nonikid-akar Bab-Jehová ise-nued begi binsasad. Degite, ¿emide, sana an-mimmiganga an na arbadmogosunna? ");
INSERT INTO cuk_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Geb Labán Jacobʼse egisdesunnad: —Degite, ¿igi-mani be-bennukbi be an-abesunna? Jacob weyob abin-sogded: —Mer be an-bennuke. Ar ibmar an bega sogoed nabir be itogele, napi an bega be-sibad-wawaadmar an edarboed. ");
INSERT INTO cuk_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Emi an be-sibadmar-abargi, bela sibad-wawaadmar-gutu-nanaimalad, mata-matamalad, sibad-wawaad-senigan-sichigana egwaoed. Deginbali, sibadmar-gutu-nanaimalad, mata-matamalad an egwabaloed, adi, weyob-daklemalad angadga guegar. We-ibmar-durgangi be an-bennukodo. ");
INSERT INTO cuk_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Degisoggu, ibagwengi be dakdanikogu, be dakoed, an bule ibmar-inniki-imaked-duledibe. An-sibadmar-abargi, sibad-gutu-nanaisurmalad, mata-matasurmalad, sibad-wawaad-senigan-sichiganasurmalad gudiile, an bei atursasdo. ");
INSERT INTO cuk_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Labán Jacob-abin sogded: —Nueddo. Be-sogedba an imakodo. ");
INSERT INTO cuk_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Degi-inigwele, aka Labánʼdi, a-ibagi, e na sibad-machergan bara-baramalad, mata-matamalad, sibad-omegan gutu-nanaimalad, wis sipu-sipu nanaimalad, degine, sibad-wawaad-sichigana, bachikii urbisad. Geb degine, Labán e-masmalaga uksad, adi, ega akwemalagar. ");
INSERT INTO cuk_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Geb Jacobʼgi we-sibadmar-obanguegala, ibapaa-bangu-nanalege-wilub sesad. Jacobʼdina, sibad-baigan Labánʼga akwedii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob we-sapi-e-anagan siksad: Álamo-e-ana, almendro-e-ana, degi, castaño-e-ana. Degine, amar-sapi-anagan bara-bara-daklegegala, a-e-uka saguar-saguar esisad. ");
INSERT INTO cuk_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Geb degine, sibadmar-dii-gobnonidamaladgi sibadmar-asabin, a-sapi-anagan-bara-bara-dakleged urbisad. Ar ade, agi sibad-machergan sibad-omegangi nakwenonidamalad. ");
INSERT INTO cuk_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ar suarmar-bara-barad-asabin sibadmar nakwedamarsoggu, e-mimmigan bara-bara, gutu-gutu, degine, mata-mata gwalulemamaid. ");
INSERT INTO cuk_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Geb degine, Jacob a-sibadmar Labán-e-sibadmar-bukwad-asabin bachikii urbisdaed. Weyob Jacob Labán-sibadmargi na e-sibad bachikii urbemai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Sibadmar-bur-wardadamalad omegi-nakwed-irbali, Jacob sibadmar-dii-gobedgi suarmar-bara-barad urbisdaed, adi, omegi nakwialile, suarmar-bara-barad dakegar. ");
INSERT INTO cuk_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ar sibadmar-garagana-nakwialirdi, Jacob suarmar-bara-barad urbedasulid. A-ulale, sibadmar-garagandi, Labánʼgad daed. Sibad-wardummagandi, Jacobʼgad daed. ");
INSERT INTO cuk_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Weyob Jacob mani-ibedga gunonikid, ichesur sibadmar-wawaad, maigan-machergan, maigan-omegan, moli-yargan-muremalad, degine, moli-uayasuigan-nika gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob wisgualid, Labán-e-masmala weyob sunmakdiiye: “Jacob bela anmar-bab-e-ibmar susye. Agi, mani-ibedga gunoniye.” ");
INSERT INTO cuk_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Deginbali, Jacob daksabalid, Labán idualeyobi bar nued e-daksuli. ");
INSERT INTO cuk_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Geb degine, Bab-Jehová Jacobʼga sogded: “Be-babgan-yarse, be-gwenadgan-bukwadse be nae. Ani, an beba gudii guoed.” ");
INSERT INTO cuk_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob sapurba e-sibad-wawaad edarbe-maidgi, Raquelʼse, degi, Leaʼse gochad, ese dagmarye. ");
INSERT INTO cuk_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Jacob Raquelʼga, degi, Leaʼga sogded: —An mag daked, bemar-bab idualeyob bar nued an-daksulid. Ar degi-inigwele, an-bab-e-Bab-Dummad gusgu anba gudiguad. ");
INSERT INTO cuk_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ar bemar-sunnad nue wismalad, igi an be-babga an arbadii. ");
INSERT INTO cuk_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Emidi, be-bab an-yardakdiguad. An-bennuked anga irambegus (10) ogwadanikid. Deginbali, Bab-Dummad be-bab-an-naibi-saegala gwen imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ar be-bab anga sogsale: ‘Ibmar-durgan-gutu-nanaimaladgi an be-bennukoye,’ degidbali, sibadmar-e-mimmigan-gwalulemamaid, bela gutu-nanaimaladbi gwalulenonidaed. Degi, be-bab anga sogsabalile: ‘Ibmar-durgan-bara-baramaladgi an be-bennukoye,’ degidbali, e-mimmigan-gwalulemamaid bela bara-baradbi gwalulenonidabalid. ");
INSERT INTO cuk_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Weyob, Bab-Dummad anga-ukegala, be-bab-ibe e-ibmar-durgan susad. ");
INSERT INTO cuk_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","”Ibagwengine, ibdurgan-idudigu, an gabdaksad. An dakalid, sibad-machergan omegi-nakwenanaid bara-bara-nanaed, gutu-gutu-nanaed, degine, mata-mata-nanaed. ");
INSERT INTO cuk_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","An we-gabdakedgine, Bab-Dummad-e-baliwitur an-nugba anse gochad. An abin-imaksad: ‘An be-itomai.’ ");
INSERT INTO cuk_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Geb degine, Bab-Dummad-e-baliwitur anga sokalid: ‘Nue be dako. Be dakena, sibad-machergan omegi-nakwenanaid bela bara-bara-nanaed, gutu-gutu-nanaed, degine, mata-mata-nanaed. Ar ade, an bela wisid, igi Labán be-imakdii. ");
INSERT INTO cuk_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ani an Bab-Dummad, Betelʼgi bese magarosadid. Agi, be akwagi gwallu-wawa eosad, adi, oyogega, we-negde nue-islidikidye. Degine, anga ise-nue-sogar be imaksabalid, an imakedseye. ¡Be gwisgu! ¡Wegi-maid be nae! Be-gwalulesad-yarse gannar be nae.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Geb degine, Raquel, Leaʼbogwa Jacob-abin sogdemalad: —An-bab-neggine bar anmar ibmar nikasulid. ");
INSERT INTO cuk_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ar anmar-bab dulemar-baidyob anmar-imaksad, e-sisganyob gwen anmar-daksulid, bur manigi anmar-uksad. Degine, be anmar-nikuega ega be manigi-arbasad, bela a-mani biin imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ar napiragwad, Bab-Dummad bela an-babgi ibmar-susadi, ¿ar wede anmargadsursi? Eye, anmargadi, degi, anmar-mimmigangadi. Degisoggu, bela Bab-Dummad bega ibmar-sogsadba be imakdo. ");
INSERT INTO cuk_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Degine, Jacob Canaán-yarse e-bab-Isaac-maidse, gannar dagega, guakwaa ibmar dakalid. Jacob moli-yargan-muregedgi e-mimmigan, degi, e-omegan-onakwisgu, ali gusad. ");
INSERT INTO cuk_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Degine, Jacob Padan-Aramʼgi e-arbasadgi bela ibmar-nikusadi sealid, bela ibmar-durgan-nikadse-bakale, searbalid. ");
INSERT INTO cuk_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Deunni, Labánʼdi baidsik naded, e-sibad-wawaadmar-e-absar esinaded. Raquelʼdi e-bab-naded-sorba, e-bab-ibe nuchu-mimmimar atursasad. ");
INSERT INTO cuk_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Weyob Jacob, Arameo-dule-Labán yardaksad. Jacob, Labánʼga gwen sogsasulid, ede naesokarye. ");
INSERT INTO cuk_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jacob wakitedo, bela ibmar-nikadi, sesagusad. Nadedgi, Éufrates-diwargi bato obaksabinned, degine, Galaad-yarmarsik nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ibapaagwad-sorbali, geb Labán wisgualid, Jacob wakiteye. ");
INSERT INTO cuk_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Geb degine, Labán e-gwenadgan-abalagine, Jacob-baregite gusad. Ibagugle-gusgu (7), Galaad-yalagangi Jacob-bargadapid. ");
INSERT INTO cuk_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","A-mutikidgine, Bab-Dummad Arameo-dule-Labánʼse gabgi magarosad, ega sogsad: “Nue be an-itogo, melle Jacobʼga urwedgi sabsur be ibmar sogo.” ");
INSERT INTO cuk_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Labán Galaad-yalaganba Jacob-bargadapid, ar ade, agi Jacob obunnodapid. Agi, Labán e-gwenadganmala obunnodapmogad. ");
INSERT INTO cuk_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Labán wis gannadginsaar Jacobʼga ibmar sogded: —¿Igi be anga gude? ¿Ibiga be an-yardaksa? ¡Emide, be an-sisgan bila-onoedgi-galesdamaladyob sealid! ");
INSERT INTO cuk_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Ibiga be an-yardaksa? ¿Ibiga an-arbak an-owisossuli be wakinnali? Be an-owisosana, weligwaledgi an bega sogsanad, nuedgi be naye. Degine, namakedgi, gar-tambor, degi, gar-arpa goled-abalagi be alinad. ");
INSERT INTO cuk_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Emide, bipisaale, be an-sisgan, degi, an-wagan-e-wagar-uega gwen be an-imaksasulid, degimaloye amarga sogega be an-imaksasurbalid. ¡Emide, dule-binsaedsulidyob be anga gusad! ");
INSERT INTO cuk_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ar emide, sunna an bela bemar-onailiksaed. Degi-inigwele, mutik be-bab-e-Bab-Dummad anga sunmaksad, weyob anga sogsad: ‘Nue be an-itogo, melle Jacobʼga urwedgi sabsur be ibmar sogoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ar emide, bela-bela be-bab-negse be gannar dagbiedde, degite, ¿ibiga an-nuchu-an-bab-dummagan be ani atursassunna? ");
INSERT INTO cuk_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Geb degine, Jacob, Labán-abin sogded: —Ar ade, an dobgusad. An binsasad, abakalegi be-sisgan be angi ise-urwedgi be sualirye. ");
INSERT INTO cuk_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ar wegi dule-wargwen be-ibe nuchu-be-bab-dummagan ganikile, ¡a-dule oburgwilegodo! Anmar-gwenadgan anmar-barsogega guoed: Be-ibmar be amie, ar an be-ibe ibmar-ganidibe, be sedodo. Ar ade, Jacob, Raquel nuchumar-atursasad wissulid. ");
INSERT INTO cuk_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Labán Jacob-e-dordonegyaba dogsad. Geb a-sorba, Lea-dordonegyaba, degine, maimar-warbogwad-dordonegyaba dogsabalid. Degi-inigwele, nuchumar-gwen-amissur gusad. Labán, Lea-dordonegyaba-noargu, geb Raquel-dordonegyaba dognonikid. ");
INSERT INTO cuk_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ar ade, Raquel nuchumar-susadi, moli-yargan-mureged-e-gan-urba odukusad. Geb degine, a-birgi Raquel sigisad. Labánʼdi nuchumar bela negyaba amidigus-inigwele, amissur gusad. ");
INSERT INTO cuk_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Geb degine, Raquel e-babga sogded: —Baba, an gwisgusulir, mer be anse urwo, ar ade, an emi mor-enukdiid. ");
INSERT INTO cuk_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ar Labánʼdi nuchumar-amidiid amissursoggu, a-ulale, Jacob uluded, Labánʼga binnasur weyob sogded: —Ar emide, ¿ibigi an begi nosa? ¿Ibigi an begi isgus be an-daksunna? Ar emide, ise-aporsaar be an-baregindigu. ");
INSERT INTO cuk_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","An-ibmar bela be argasad. ¿Ar ibi-be-ibmar be an-neggi be amissunna? Be ibmar-amisad, be-gwenadgan-asabin, an-gwenadgan-asabin be urbedo, adi, sogmalaga, ar doa-anbogwadi bur-nabir ibmar soge. ");
INSERT INTO cuk_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","”Birga-dulagwen (20) an bega arbasad. Bipisaale be-sibadmar, degi, sibad-wawaadmar, mimmi-nikudanikir, igarba gwen melledsulid. Be-sibadmar-abargi, bipisaale be-ibe sibad-wawaad-machered-wargwensaar an guchasulid. ");
INSERT INTO cuk_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ibmar-durgan-sapurbarmalad bei sibad-oburgwisale, an bennukewilubsulinad, aka an bur bennukdedaed. Mutikidbardibe, ibginedbardibe, bei-sibad-aturimaklesale, be angi mani gadaed.” ");
INSERT INTO cuk_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Jacob Labánʼga sogdebalid: —An bega arbadigusgu, ibgine, neg-diopisulidba an burgwebidaed. Neg-mutikdi, neg-diopigwadba an burgwebidabalid. ¡Ar gabedse-bakar, gwen gabbi an-itodasulid! ");
INSERT INTO cuk_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Birga-dulagwen (20) an be-neggi gudii gusad. Unnila, wemarbi an nikusad: Be-sisgan-warbogwadbina birgambe-gakabake (14) an bega arbasad. Be-sibadmarbina birganergwa (6) an bega arbasad. Degine, be-an-bennukedi, be anga irambe (10) ogwadii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","”Ar Bab-Dummad Abraham-e-Bab-Dummadga maid, degine, an-bab-Isaac a-Bab-Dummad-dobekwaa nanadii gusad. A-Bab-Dummad anba gudisulina, arganagwabi be an-barmialinad. Napira an bega soged: Ar Bab-Dummad, wile-an-itodiid magar-daksad, degine, an-arbadiid magar-daksabalid. A-ulale, mutik bese magarosad, ibmar binnasur bega sogsad.” ");
INSERT INTO cuk_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Geb degine, Labán Jacob-abin sogded: —Be-omegan, an-sisganad. Burwigana, an-waganad. Sibad-wawaadmar, an-sibad-wawaadmalad. ¡Bela we-ibmarmar be dakedi, bela angadbiid! Ar an-sisgansoggu, ¿igi an bar saosunna? Degine, an-sisgan-mimmiganbarsoggu, ¿igi an imakbalosunna? ");
INSERT INTO cuk_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Degisoggu, a-ular be dage, be anbogwa igar-mesdo, adi, agi be anbo igar-mesnaid-wilubgan mag daklegegar. ");
INSERT INTO cuk_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Geb degine, Jacob akwa-dummad susad, a-akwa ebo igar-mesnaid-wilubgan-oyogega ogwichisad. ");
INSERT INTO cuk_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Geb degine, e-gwenadganga sogded: —¡Akwa-onmakmar! Bela akwa-ichesur-urbegala, akwa-onmaksamalad. Agine, akwa-ichesur-bukwad-walik mas-guchamalad. ");
INSERT INTO cuk_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labán e-gayaba a-neg Jegar-Sahadutaʼye onugsasad. Jacobʼdi e-gayaba a-neg Galaadʼye onugsasmogad. ");
INSERT INTO cuk_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Geb degine, Labán sogded: —Emi-ibagi, we-akwa-dunnumakbukwad anmar-igar-mesnaid-e-wilubgan-oyogega gued. A-ular, a-nega Galaadʼye nuggusad. ");
INSERT INTO cuk_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Deginbali, a-neg Mizpaʼye nuggusbalid, ar ade, Labán sogsad: —Anmar na gi yoggudmalo-inigwele, Bab-Jehová anmar-dakdii guoed. ");
INSERT INTO cuk_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Degine, an-sisgan sabsur be imakalile, igidibe, omegan-baid be nikuarbalile, ar dule-baigan amba-be-daksur-inigwele, be ebinsao, Bab-Dummaddi anmar-dakoed, a anmar-barsogega guoed. ");
INSERT INTO cuk_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Degine, Labán Jacobʼga sogdebalid: —Nue be dake, akwamar-odunnumakbukwad, degi, akwa-dummad-gwichid, anmar-deyob-igar-mesisad, anmarga-oyogega gued. ");
INSERT INTO cuk_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","We-akwa-sogbogwadi anmarga-sogega guoed, bedi be ansik obakosurye, degine, anmoga an besik obakosurmoye, adi, melle na anmar sabsur imakmalagarye. ");
INSERT INTO cuk_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Be-dad-Abraham-e-Bab-Dummad, degi, an-dad-Nacor-e-Bab-Dummad, anmarga igar-nabogega guoed. Geb degine, Jacob e-bab-Isaac-Bab-Dummad na e-Bab-Dummadga-imakdimogad-nuggine ise-sogar sogded, ede deyob imakedseye. ");
INSERT INTO cuk_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Geb degine, Jacob yar-birgine Bab-Dummadga ibmar-ogumakar uksad. Geb Jacob agi mas-gunmalaga e-gwenadganse gochad. Agi bela e-gwenadgan mas-guchamalad. Degine, a-yar-birgi gabismarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Oibosgu, wakudaryalaba Labán gwisgusad, degimaloye-sogega bela e-wagan-wagar usad, degine, e-sisgan-wagar usbalid. Geb a-sorbali, bela amargi ise-nued-binsaedgi ega ibmar sogsad. Geb degine, Labán gannar e-negse ali gusad. ");
INSERT INTO cuk_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob e-maidgi nadegusbalid. Nadapgu, Bab-Dummad-baliwiturmar Jacob-abin noalid. ");
INSERT INTO cuk_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacob, baliwiturmar-daksagu, sogded: “We-nega, Bab-Dummad-e-sordamar-neg gued.” A-ulale, Jacob a-nega Mahanaimʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob e-iduale, Edom-yalaganba, dule e-barsogega Seir-neggweburse barmisad. Adi, e-ia-Esaúʼga sogega, ede daniye. ");
INSERT INTO cuk_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Jacob sogded: “An-dummad-Esaúʼga weyob be sogo: ‘Be-mai-Jacob soged: Ede emi-ibadse Labán-walik-gudii gusye. ");
INSERT INTO cuk_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Emidi, ede bukidar we-ibmarmar nikaye: Molimar-bebe-nikad, moli-uayasuigan, sibad-wawaadmar, sibadmar, maigan-omegan, maigan-machergan. ” ’Dummad, we-gayaburba an bese barmisiid. Degisoggu, bitigi nued be an-abin-daksana yeerban.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Dule-gayaburba-sesmalad gannar aibilismargu, Jacobʼga sognonimalad: —Anmar be-ia-Esaúʼse arbimalad. Na e-sunnad be-abin danikid, degine, machergan e-dulataled-ilabake (400) eba danimarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob dulemar-weyob-ega-soge itoargu, bela-bela dobe-itonaded, degi, nue bukib-binsaded. Jacob dulemar-eba-danimalad danabo urbisad. Amba deyob sibad-wawaadmar, moli-bebe-nikamalad, degi, moli-yargan-muremalad imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ar ade, Jacob binsasad: “Ar Esaú dulemar-danagwenadgi-gwisgualile, danagwenad-baid sunna wakinneddeeye.” ");
INSERT INTO cuk_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Geb degine, Jacob Bab-Dummadse goted, ega sogded: “Bab-Jehováʼye, be an-dad-Abraham-e-Bab-Dummad-gued, degi, an-bab-Isaac-e-Bab-Dummad-gubalid. Be anga sogsad: ‘Be-yarse, degi, be-gwenadganse be naye. An bega bela ibmar-nueganbi-gued an imakoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","An wisi, be angi nued binsamaid, gwen be angi nodisulid, ar deyob be an-imake-wilubsulinad. We-Jordán-diwar an obaksagua, deunni, ibmar-bipisaar gwen an semaigussulid, unnila, gaapoledbi an semai gusad. Ar emigindi, ibmar-dummagan-danabo an nikad. ");
INSERT INTO cuk_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Bab-Jehováʼye, ¡an-ia-Esaúʼgi wis be an-bendake! An dobe-itoged. Abakalegi an-oburgwialile, degi, an-omemar, an-mimmimar-oburgwiarbalile. ");
INSERT INTO cuk_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ar bede nue anga sogsad: ‘Bela ibmar-nueganbi-gued an bega imakoye. Be-wagan bela-bela ukub-merguedyob-guosoggu, geg dule ebise guoye.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","A-mutiki, Jacob agi gabisad. Geb bangine, e-ibmar-bur-nuegan susad, adi, e-ia-Esaúʼga ukegar: ");
INSERT INTO cuk_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Sibad-omegan, waladulataled-ilabo (200), sibad-machergan, waladulagwen (20), sibad-wawaad-omegan, waladulataled-ilabo (200), sibad-wawaad-machergan, waladulagwen (20). ");
INSERT INTO cuk_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Moli-yargan-mureged-e-omemar-emisgwa-mimmi-nikusmalad, e-mimmiganse-bakar, waladulagwen-gakambe (30), moli-bebe-nikad-e-omegan, waladulabo (40), moli-bebe-nikmalad-machergan, warambe (10), moli-uayasuid-omegan, waladulagwen (20), degi, moli-uayasuid-machergan, warambe (10). ");
INSERT INTO cuk_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Geb degine, Jacob ega-arbamaladga ibmar-durgan danar-danar-uksagu, ega sogded: “Bemar an-idu namar. Bemar na gi undar bangu-bangu danar-danar-nadapi be imakmalo.” ");
INSERT INTO cuk_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Jacob gebe-dulemar-barmisad-e-iduedga weyob sogsad: “An-ia-Esaú be-abingualile, degi, bega sokardibe: ‘¿Doa be-dummadye? ¿Bia be nadapye? Degine, be ibmar-durgan-semaidi, ¿we doagadye?’ ");
INSERT INTO cuk_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Abin be sogoed: ‘We-ibmar-durgan, be-mai-Jacobʼgadye. Dummad-Esaú, an-dummad-Jacob bega we-ibmar-durgan barmiarye. Degi, Jacob e-sunnad anmar-sorba danimoye.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Degine, dulemar-baid-sogbogwad danar-barmisbalid. Degine, dulemar-sogbaagwad amba deyob danar-barmisbalid. Degine, Jacob bela danar-danar-ibmar-durgan-semamaidga sogsad: “An-ia-Esaú bemar-abingualile, bemar degibi sogmarmogoye. ");
INSERT INTO cuk_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Deginbali, ega sogbaloye: ‘Be-mai-Jacob, an-sorba daniye.’ ” Ar ade, Jacob binsaed: “An-ia sae-itogedi, we-ibmarmar-an-ega-uknaidgi an binsaed-gaoeddeeye. Geb a-sorbali, an-sunnad an-ia an dakoye. Ar wegii saedgi nued an-abingaaliirye.” ");
INSERT INTO cuk_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Degisoggu, Jacob na e-iaga-ibmar-uknaid e-idu barmisad. Na edi e-neggi besad, agi mutik gabegar. ");
INSERT INTO cuk_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","A-mutiki, Jacob e-omegan-warbogwad, e-maigan-omegan-warbogwad, degi, e-masmala-warambe-gakagwensakad (11), Jaboc-diwar-dinnagwadsik-obakega imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Deginbali, bela ibmar-durgan-nikadi diwargi-obakega imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob walagwen besgua, dule-wargwen ese nonikid. We-dule Jacob-ebo neg-oibogedse gala-maada urwenai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ar dule Jacobʼgi geg obin-itosoggu, duagar-dikar-gwadilenaidgi sarsosad. Degisoggu, Jacob urwenaigu, e-duagar nosad. ");
INSERT INTO cuk_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Geb degine, dule Jacobʼga sogded: —Be an-indake. Bato neg-oibodanikid. Jacob abin-sogded: —Be angi ise-nued-binsaedgi be anga ibmar-sogsulile, an be-indakosulid. ");
INSERT INTO cuk_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Dule Jacobʼse egichided: —¿Igi be nuga? Jacob abin-sogded: —Jacobʼye, an nuga. ");
INSERT INTO cuk_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Geb degine, dule ega sogded: —Jacobʼye bar be nugguosulid. Ar ade, be Bab-Dummadbo-galitosadgi, degi, dulemarbo-galitosadgi be obichasoggu, be Israelʼye nugguoed. ");
INSERT INTO cuk_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob dulese egisdemogad: —Emigi, be-nug anga be sogmoga, ¿igi be nugmoga? Dule abin-imakded: —¿Ibiga be anse an-nug egise? Geb degine, dule Jacobʼgi ise-nued-binsaedgi ega sogded. “Bela bega ibmar-nueganbi gusunno.” ");
INSERT INTO cuk_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Geb Jacob a-nega Penielʼye onugsasad. Ar ade, Jacob soged: “Bab-Dummad-wagar nue an daksad, degite, amba an dula gudiid.” ");
INSERT INTO cuk_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jacob bato Penielʼgi nue-bangumaigua, dad-nakwialid. Ar ade, Jacob dikargi naibigussoggu, muya-muya nanagusad. ");
INSERT INTO cuk_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","A-ulale, emi-ibase Israel-dulemar ibdurgan-e-duagar-dikar-gwadilenaid-e-dub-wardummad-maid-sinnigwad wissur gunmalad, ar ade, agi Israel sarsolesad, a-dub-wardummad sinni gusad. ");
INSERT INTO cuk_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob dakdegu, Esaúʼba machergan e-dulataled-ilabake-mergu (400) daniki, mimmigan danar-danar Leaʼba, Raquelʼba, degi, e-maigan-omegan-warbogwadba mimisad. ");
INSERT INTO cuk_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Gebedgi, Jacob e-maigan-omegan e-mimmiganmala iduega imaksad. Geb a-sorba, Lea e-mimmiganmala nasiksad. Geb napidgine, Raquel e-machi-Joséʼbo nasiksad. ");
INSERT INTO cuk_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Geb degine, Jacobʼdi bela wemar-idusad, dulluu e-bebe napase ebulegedse ilagugle (7) e-iase warmaksadse imaknadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ar Esaúʼdi e-urba-Jacobʼse abarmakded, bela angaagwar Jacob-gadapid, degi, e-wagar udapbalid, ebobela ise-boale bodmalad. ");
INSERT INTO cuk_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Geb a-sorbali, Esaú, omegan-dakargu, degi, mimmigan-dakargu, egichided: —Wemardi, ¿we doamala? Jacob abin-sogded. —We-mimmigan Bab-Dummad angi-nabir-binsaedba anga uksadid. ");
INSERT INTO cuk_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Geb degine, e-omegan-maigan na e-mimmiganmala Esaúʼse warmaknonimalad. Geb degine, dulluu e-bebe napase ebulegedse imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Geb a-sorbali, Lea e-mimmiganmala deyob dulluu imaknonimarmogad. Geb napidgine, José e-nan-Raquelʼbo nonikid, amba deyob dulluu imaknonimarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Geb degine, Esaú egichidbalid: —¿Ar ibiga we-ibmar-durgan danar-danar be anga barmiali? Jacob ega sogded: —Be angi-nued-binsaega, an bega barmialid. ");
INSERT INTO cuk_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaú sogded: —Urba, deyobsuli. An ibmar-durgan unniguar-nikamogad. Be-ibmar-durgan begadid. Na be sue. ");
INSERT INTO cuk_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Degi-inigwele, Jacobʼdi e-iagi alamaknai gusad: —Suli ia, degisuli. An we-ibmar-bega-sedanikidi, bitigi be abingasana yeerban. Ar be nued be anmar-abindaksasoggu, an be-dakdedgine, Bab-Dummad-wagar-dakdeyob an itonaded. ");
INSERT INTO cuk_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Degisoggu, nue-wilesakwaa an bese egised, we an bega-ibmar-durgan-uknaid be sue, ar ade, Bab-Dummad mani-ibedga an-imaksad. Ibmar-durgan unniguar an nikad. Ar Jacob e-ia-Esaúʼgi alamaknaigusoggu, Esaú ibmar-durgan-abingassunnad. ");
INSERT INTO cuk_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Geb degine, Esaú sogded: —Nabir. Anmar namarsundo. An be-idugoed. ");
INSERT INTO cuk_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob e-ia-abin sogded: —Ia, nabirindo. Ar be nue wisid, mimmigan binnaa nanamalad. Degisoggu, geg anmar darekwaa naed. Degine, sibad-wawaadmar-e-mimmigangi, degi, moli-bebe-nikamalad-e-mimmigangi an binsaergebbalid. Ar sibad-wawaadmar geggusmalale, sunna ibagwen bela giir gued. ");
INSERT INTO cuk_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ar bur-nuediled be an-idu naer. Ar andi binnale be-sorba nadapoed. Ibmar-durgan-nanaed-e-ganguedba, degi, mimmigan-nanaed-e-ganguedba an be-sorba nadapoed. Anmar Seir-yargi abingumalodo. ");
INSERT INTO cuk_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaú abin-sogded: —Nabirdo. Machergan-anba-nonimaladi, abala an bega obego. Jacobʼdi e-ia-abin sogded: —¿Ar ibiga be obegoe? Bato unniguar nued be angi binsasad. ");
INSERT INTO cuk_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ar aka a-ibagi Esaú Seir-yarse gannar naded. ");
INSERT INTO cuk_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ar Jacobʼdi Sucotʼse naded. Agi, e-neg sobsad, degine, e-ibmar-durganga galu sobsabalid. A-ulale, Jacob a-nega Sucotʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob Padan-Aram-neggweburgi-mai Canaán-yarse-nonigu, bonisuli nuedgi nonikid. Jacob Siquem-neggwebur-asabin megnonikid. ");
INSERT INTO cuk_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jacob Hamor-e-masmalase mani-gwadulatargi (100) nainu baksad. Hamorʼde Siquem-e-babad. A-nainugi Jacob dordoneg sisad. Jacob agi megnonikid. ");
INSERT INTO cuk_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Geb a-sorbali, Jacob Bab-Dummadga-ibmar-ogumakar-ukleged-aila sobsad. A-aila Jacob El-Elohe-Israelʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ibagwengine, Dina, neggweburse bunamalase ataknad gusad. Dinaʼde Lea-sisgwad, Jacobʼbo-baksadid. ");
INSERT INTO cuk_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Siquem a-bunagwa-dakargu, gadebin imaksad, egi nue-dodosad. Siquemʼde Hamor-e-machid. Hamorʼdi, Heveo-duled, neggweburgi nue-nug-nikagwadid. ");
INSERT INTO cuk_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ar bela-bela Siquem Jacob-sisgwa-Dinaʼbina nue-sogsoggu, e-abegega egi alamaknai gusanad. ");
INSERT INTO cuk_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Degi, Siquem, e-bab-Hamorʼga sogded: “Jacobʼse be anga Dina egisnae. An nue-nikubied.” ");
INSERT INTO cuk_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob wisgusad, e-sisgwa-Dinaʼgi Siquem nue-dodosye. Ar e-masmala sapurba e-ibmar-durgan-edarbedimarsoggu, Jacob e-masmala-negse-nonikidse geb ibmar sogsad. ");
INSERT INTO cuk_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Degidgine, Siquem-e-bab-Hamor, Jacobʼbo-sunmakega Jacobʼse nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jacob-masmala-sapurba-gudidimalad neggusad-wisgusmargu, gannar negse nonimalad. Ar ade, e-bab-Israel-nug nue-gagalesad. Aginbali, Siquem e-bungi-dodosad-ular, nue-gwage-nunmak-itomalad, degi, nue-sae-itomarbalid. Ar ade, Siquem weyob imakewilubsulinad. ");
INSERT INTO cuk_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ar Hamorʼdi Jacob-e-masmala-ebo sunmaksad, ega sogded: —An-machi-Siquem bela-bela bemar-bun abeged. Bemar be-bun an-machi-ebo-nikued wis be imakmala. ");
INSERT INTO cuk_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Bemar anmar-gwenadga gumardo, adi, anmar nabir bemar-sisgan-nikue gumaloed, degine, bemar nabir anmar-sisgan-nikue gumarmogoed. ");
INSERT INTO cuk_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Wegi bemar megmarmoga. Anmar-yar guakwaa bemar-idu naid, bemar anmar-walik megdo, be arbamardo, degine, nainu be bakmardo. ");
INSERT INTO cuk_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ar Siquemʼmoga Dina-e-babga, degi, Dina-e-susmarga sogdemogad: —Anmar-ibmar-bega-sognaid be abingamala. Ar ibu be anse egismardibe, an bega ukmaloed. ");
INSERT INTO cuk_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ome-nikuega ar gusgu igar-maidba ibmar-ukleged, aba bur dumma be anse ibmar-egisele, degi, ibmar-bukidar bega ukbi be an-abegele, an bemarga ibmar ukoed. Be-bun an nikuega bemar an-imakmala. ");
INSERT INTO cuk_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Degi-inigwele, ar Siquem Dinaʼgi nue-dodossoggu, Jacob-e-masmala Siquemʼga, degi, Hamorʼga, yamo-yardakar ");
INSERT INTO cuk_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","ega sogdemalad: —Suli, degisuli. Geg anmar dule-abgan-uka-duku-sikarsulidga anmar-bun uked. Anmar deyob imakele, binged-dummad itole. ");
INSERT INTO cuk_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Bela bemar-machergan abgan-uka-duku be sikmalardi, nabirdo. Ar weyob be-machergan anmaryob imakerdi, nabirdo. ");
INSERT INTO cuk_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ar deyob bemar imakele, bemar sunna anmar-sisgan nikumaloed, degine, anmar sunna bemar-sisgan-nikumarmogoed. Anmar sunna bemar-abargi megmaloed. Anmar bemarbogwa dule-wargwennayob gumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bemar anmar-sogedba abgan-uka-duku-siksurmalale, wegi-anmar-gudiid anmar naoed. Anmar-bun anmar sedmaloed. ");
INSERT INTO cuk_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor, degi, e-machi-Siquem Jacob-e-masmala-ega-ibmar-sogsamalad nued itosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Dogdar nadsuli, Siquem Jacob-e-sisgwabina nue-sogsoggu, e-abgan-uka-duku siksad. Ar Siquem e-gwenadgan-abargi bur nue-nug-nikagwadsoggu, ");
INSERT INTO cuk_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Siquem, e-bab-Hamor-ebogwa neggwebur-doged-yawagakse nade gusmalad, ar ade, agi igar-naboleged-negad. Agi, Siquem, e-bab-Hamorʼbo dulemarga sogdemalad: ");
INSERT INTO cuk_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—We-dulemar, anmar-aimalad. Anmar-abargi megmaloed, degi, wegi arbamaloed, ar ade, unniguar napa naid. Sunna anmar wemar-sisgan nikumalad, degi, wemar sunna anmar-sisgan nikumarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ar anmar unnila dule-wargwennayob-guegala, sogmardo, emarde anmar-abargi megmalagala, emar imakdamarmogadyob, anmarde anmar-abgan-uka-duku sikmaloye. ");
INSERT INTO cuk_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bela ibmar-nikmalad, degi, bela e-ibmar-durgan anmargadga gumogoed. Unnila anmar sogergebed, eyeye. Deyob anmar sogele, anmar-abargi megmalodo. ");
INSERT INTO cuk_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bela machergan a-neggweburginmalad, Hamor, degi, e-machi-Siquem-ega-soged nabir-itosmalad. Degisoggu, bela e-abgan-uka-duku siksamarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ibapaagusgu, Jacob-e-masmala-warbogwad, Simeón, degi, Leví, Dina-e-susmar, e-es-suid-sesmargu, neggweburse nade gusmalad. Amba deun, machergan e-abgan-uka-duku-siksadba nunmak-itomaidgi modapmalad. Geb degine, Simeón, degi, Leví bela we-machergan es-suidgi oburgwismalad. ");
INSERT INTO cuk_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Simeón, Levíʼbo, es-suidgi-ewarar, Hamor, degi, e-machi-Siquem-oburgwismalad. Geb degi, e-bun-Dina Siquem-neggi-gudiid onosmalad. Agine, nade gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Geb degine, Jacob-masmala-baigan nonimarmogad, burgwar-mamaidgi nasmargua, e-bun-Dinaʼgi Siquem nue-dodosad-ular, neggweburgi-ibmar-nikad bela sesa gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Jacob-masmala we-ibmarmar sesa gusmalad: Sibad-wawaadmar, moli-bebe-nikamalad, moli-uayasuidmar, bela neggweburgi-ibmar-nikad, degi, sapurba-ibmar-nikamarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Neggi-ibmar-nikamalad bela atursasmalad, omegan, mimmigan, degi, bela ibmarmar-negyagi-bukmalad sesa gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Geb degine, Jacob, Simeónʼga, degi, Levíʼga sogded: —Ar emigindi, boni-dummad bemar anga uksamalad. Dulemar-we-yargi-mamaimalad, Canaán-dulemar, Ferezeo-dulemar, isdar an-dakdamaloed. Emar, anmargi bila-onomalaga atodmaloed. Ar anmar machergan-ichee gumarsoggu, ani, degi, an-gwenadgan bela oburgwilemaloed. ");
INSERT INTO cuk_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ar e-masmaladi, e-bab-abin sogdemalad: —¿Ar wede Siquem anmar-bun-Dina omegambanuchuyob imakoye soge? Suli, degisuli. ");
INSERT INTO cuk_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Bab-Dummad Jacobʼga sogded: “Be nae, Betel-neggweburse be megnae. Deun, be-ia-Esaúʼgi be wakinmaigu, ani, Bab-Dummad, an bese magarosadid. Betel-neggweburgi be anga-ibmar-ogumakar-ukleged-aila be sobo.” ");
INSERT INTO cuk_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Geb degine, Jacob bela e-neguyaginmaladga, degi, bela eba-gudimaladga sogded: “Bemar be-bab-dummadga-imakdiid be sedidimalad, bela be metemalo. Bemar bela islidikidguega, be obmarbalo, degine, bela mor ogwamarbalo. ");
INSERT INTO cuk_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Anmar emisgwasaar Betelʼse naoed. Agine Bab-Dummad anse magaros gusad. A-Bab-Dummad-e-nug-odummogega an ibmar-ogumakar-ukleged-aila ega sobdapoed. A-Bab-Dummadde an wile-itodigu, an-bendaksad. A-Bab-Dummad an-naddaedba anba gudiguad.” ");
INSERT INTO cuk_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Degisoggu, bela e-bab-dummadga-imakdimalad Jacobʼga senonimalad. Degine, e-uaya-dukugi olua-nanaid Jacobʼga uksamarbalid. Geb degi, Siquem-neggwebur-itakasaar Jacob bela a-ibmarmar sapi-encinaʼye-nugad-urba digsad. ");
INSERT INTO cuk_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Emar noarmargu, Bab-Dummad dulemar-neggweburmar-dikarbarmalad bela-bela Jacob-dobgumalaga imaksad. A-ulale, dulemar bar Jacob, degi, e-masmala-baregichasurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob, degi, bela Jacobʼba-nadapmalad Luz-neggweburse modapmalad. A-neggweburde Canaán-yargi siid, degi, Betelʼye nugbalid. ");
INSERT INTO cuk_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Agi, Jacob Bab-Dummadga-ibmar-ogumakar-ukleged-aila sobsad. Jacob e-iagi wakinmaigua, agi Bab-Dummad ese magaros gusad. A-ular, Jacob a-neg El-Betelʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Agi, Débora burgwisad. Déboraʼde Rebeca-akwisadid. Betel-waliksaar sapi-encinaʼye-nugad-urba digsamalad. Jacob Débora-digsad-neg Alón-Bacutʼye onugsasad. A-sogleged, Sapi-encina-bosadye. ");
INSERT INTO cuk_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jacob Padan-Aramʼgi-mai gannar Betel-neggweburse nonibargu, Bab-Dummad ese gannar Betelʼgi magarononibalid. Bab-Dummad Jacobʼgi ise-nued-binsaedgi gannar ega sogded: ");
INSERT INTO cuk_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“Be Jacobʼye nuganad. Emigindi, bar deyob be nugguosulid. Be Israelʼye nugguoed.” ");
INSERT INTO cuk_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Bab-Dummad Jacobʼga sogdebalid: “Ani, an Bab-Dummad-Bela-Gangued-Nikadid. Mimmigan-bukidar, degine, wagan-bukidar be nikuo. Begi dulemar-sogagwen nodagoed, degine, dulemar-sog-akar-akar begi nodabaloed. Be-waganmala reymarga gumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abrahamʼga, degi, Isaacʼga, yar-an-ukoye sogsadi, a-yar an bega ukmogoed. Be-sorbali, be-waganga a-yar an ukbaloed.” ");
INSERT INTO cuk_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Bab-Dummad Jacob-ebo-sunmaksad-bergusgua, niba nade gusad. ");
INSERT INTO cuk_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Geb degine, Jacob akwa susad, Bab-Dummad-ega-sunmaksadgi a-akwa ogwichisad. Geb a-sorbali, a-akwagi gwallu-wawa, degi, vino egi eosad, oyogega, we-akwa, Bab-Dummadgadye. ");
INSERT INTO cuk_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A-neggi Bab-Dummad Jacob-ebo sunmaksad. A-ular, Jacob a-neg Betelʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Geb a-sorbali, Jacob, degi, bela eba-gudimalad Betelʼgi nade gusmalad. Amba Efrata-neggweburgi-yeer-banguedgi, Raquel goe-nikunonikid. Goe-nikuegala, undar-boniganba galitosad. ");
INSERT INTO cuk_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Raquel bur bule bonigan-itonaidgi, muu-sikwigaed ega sogded: “Melle be dobgu, machigwa-baid bega uklesbalid.” ");
INSERT INTO cuk_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ar Raquelʼdi napi-iche-iche-maidgi e-goe Benoniʼye onugsasad. Ar e-bab-Jacobʼdi machi-bipi Benjamínʼye onugsanonikid. ");
INSERT INTO cuk_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Weyob Raquel burgwisad. Efrataʼse-naed-igarba Raquel-mui digsamalad. Emigindi, a-neggwebur, Belénʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob Raquel-neg-uan-birgi akwa-dummad ogwichisad. A-akwa amba we-garda narmaklesmaidse Raquel-digar-maid oyonaid. ");
INSERT INTO cuk_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel nade gusad. Neg-suid-Migdal-Edarʼdaksik megidapid. Agi, Israel e-dordoneg sidapid. ");
INSERT INTO cuk_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel bato Migdal-Edarʼgi nue-mai, Rubén e-bab-ome-Bilha-maidse nade gusad. Agi, Rubén Bilhaʼse gochad. Jacob wisgusgu, Rubén Bilhaʼse gochaye, Jacob nue-sae itosgusad. ");
INSERT INTO cuk_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jacob masmala-warambe-gakabo (12) nikusad: Jacob-Leaʼbo-masmala-nikusadi, wemalad: Rubén, e-machi-sailagined, Simeón, Leví, Judá, Isacar, degi, Zabulón. ");
INSERT INTO cuk_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Jacob-Raquelʼbo-masmala-nikusadi, wemarmogad: José, degi, Benjamín. ");
INSERT INTO cuk_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Jacob Raquel-e-mai-Bilhaʼbo-masmala-nikusadi, wemarmogad: Dan, degi, Neftalí. ");
INSERT INTO cuk_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Jacob Lea-e-mai-Zilpaʼbo-masmala-nikusadi, wemarmogad: Gad, degi, Aser. Wemala, Jacob-machimala gumalad, Padan-Aramʼgi gwalulesmaladid. ");
INSERT INTO cuk_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob Mamre-neggweburse e-bab-Isaac-daknade gusad. Mamre-neggweburde, Arba-neggwebur-walik siid. Mamre-neggweburde, Hebrónʼye bimarbalid. A-neggweburgine, Abraham, degi, Isaac mai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac nue seleba-mai birga-dulabakebak-nika (180) burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","E-sergan-abargi mesismalad. E-masmala Esaú, degi, Jacob, e-bab-Isaac-digsamalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esaú, Edomʼye nugbalid. Esaú e-anagan nikusad. ");
INSERT INTO cuk_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú Canaán-yargined-omegan-nikusadi, wemalad: Gebesailagine, Ada-nikusad. Adaʼde Elón-e-sisgwad, Het-duled. Esaú, Aholibama-nikusbalid. Aholibamaʼde Aná-e-sisgwad, Zibeón-e-wagwad. Zibeónʼde Heveo-duled. ");
INSERT INTO cuk_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Degine, Esaú, Basemat-nikusbalid. Basematʼde Ismael-e-sisgwad, Nebaiot-e-bunad. ");
INSERT INTO cuk_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaú Canaán-yargi-maigu, machimala-nikusadi, wemalad: Adaʼbo baksadid, Elifaz. Basematʼbo baksadid, Reuel, ");
INSERT INTO cuk_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Aholibamaʼbo baksadid Jeús, Jaalam, degi, Coré. ");
INSERT INTO cuk_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaú, e-omemar, e-masmala, e-bunamala, degi, bela eba-gudidimalad yar-baidse sesa gusad. Deyob, e-urba-Jacob-idu bangud gusad. Bela e-ibmar-durgan, degi, bela e-ibmar-Canaán-yargi-nikusad sesa gusad. ");
INSERT INTO cuk_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ar Esaú, Jacob-ebo bela ibmar-durgan-ichesur-nikamarsoggu, geg ebo walikaa-gudii gumalad. Ar e-mamaidgine, ibmar-durgan mas-mamalaga napa unniguarsulid. ");
INSERT INTO cuk_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","A-ulale, Esaú Seir-yalaganba megnad gusad. Esaúʼde, Edomʼye nugbalid. ");
INSERT INTO cuk_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Edom-dulemar-e-dadgan Seir-yalaganba bukwagusmalad. Wemala, Esaú-wagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esaú-e-masmala weyob nugmalad: Ada-e-machi-Elifaz. ");
INSERT INTO cuk_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Wemardi, Elifaz-e-masmala gumarmogad: Temán, Omar, Zefo, Gatam, degi, Cenaz. ");
INSERT INTO cuk_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Esaú-machi-Elifaz, ome-dikarbalid nikagusad, Timnaʼye nugad. Elifaz Timnaʼbo machi-nikusad, Amalecʼye nugad. Wemar, Ada-e-wagan-gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel-e-masmaladi, wemalad: Nahat, Zera, Sama, degi, Miza. Wemar, Esaú-ome-Basemat-e-wagan-gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Aholibama, Esaú-ome-baid gubalid. Aholibamaʼde Aná-e-sisgwad, Zibeón-e-wagwad. A-ome Esaúʼbo masmala-baksadi, wemalad: Jeús, Jaalam, degi, Coré. ");
INSERT INTO cuk_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaú-e-wagan dule-idumaladga-gusmaladi, wemalad: Esaú-machi-gebesailagined, Elifaz. Elifaz-e-masmala dule-idumaladga-gusmarmogadi, wemalad: Temán, Omar, Zefo, Cenaz, ");
INSERT INTO cuk_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam, degi, Amalec. Wemar, Elifaz-e-masmala, Edom-yalagangi dule-idumaladga gusmalad. Bela wemar. Esaú-e-ome-Ada-wagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esaú-machi-Reuel-e-masmala, dule-idumaladga-gusmarmogadi, wemalad: Nahat, Zera, Sama, degi, Miza. Wemar, Reuelʼsik, Edom-yalagangi dule-idumaladga gusmarmogad. Wemala, Basemat-wagan gumalad. Basematʼde Esaú-e-ome-baid gued. ");
INSERT INTO cuk_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaú-ome-Aholibamaʼdi Aná-sisgwad. Aholibama-e-masmala dule-idumaladga-gusmaladi, wemalad: Jeús, Jaalam, degi, Coré. ");
INSERT INTO cuk_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Bela wemala, Esaú-e-wagan gumalad. Esaúʼde, Edomʼye nugbalid. Bela wemala, e-dulemar-idumaladga gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seir-e-masmala amba Edom-yalagi bukwa gusmarmogad. Seirʼde, Horí-duled. Seir-e-masmaladi, wemalad: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO cuk_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer, degi, Disán. Wemala, Seir-e-wagan, Edom-yalaganba Horí-dulemar-e-idumaladga gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotán-e-masmala, wemalad: Hori, Hemam. Lotán-e-bundi, Timnaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal-e-masmaladi, wemalad: Alván, Manahat, Ebal, Sefo, degi, Onam. ");
INSERT INTO cuk_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeón-e-masmaladi, wemalad: Aja, degi, Aná. We-Aná e-bab-Zibeónʼga nega-dulesulidganba moli-uayasuid-edarbedigu, dian-diopisulid amisad. ");
INSERT INTO cuk_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná mimmigan-warbo-nikusadi, wemalad: Machigwa nugad, Disón. Bunagwa nugad, Aholibama. ");
INSERT INTO cuk_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disón-e-masmaladi, wemalad: Hemdán, Esbán, Itrán, degi, Querán. ");
INSERT INTO cuk_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer-e-masmaladi, wemalad: Bilhán, Zaaván, degi, Acán. ");
INSERT INTO cuk_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disán-e-masmaladi, wemalad: Uz, degi, Arán. ");
INSERT INTO cuk_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horí-dulemar-e-dummaganga gusmaladi, wemalad: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO cuk_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer, degi, Disán. Wemala, Seir-yalaganba Horí-dulemar-idumaladga e-gwenadgan-e-gwenadganba gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israel-dulemar amba yoo rey-nikumargu, deun we-reymar Edom-yargi negsemai gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor-machi-Belaʼye-nugadi, Edom-yargi reyga megisad. E-neggweburga-gusadi, Dinabaʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Rey-Bela burgwisgua, a-sorba, Jobab negdaknonikid. Jobabʼde, Zera-e-machid, Bosra-neggweburginedid. ");
INSERT INTO cuk_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab burgwisgua, a-sorba, Husam negdaknonikid, Husamʼde, Temán-yalaginedid. ");
INSERT INTO cuk_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam burgwisgua, a-sorba, Hadad negdaknonimogad. Hadadʼde, Bedad-e-machid. Hadad, Moab-yargi Madián-dulemargi nakwisad. Hadad-e-neggweburga-gusadi, Avitʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad burgwisgua, a-sorba, Samla negdaknonikid. Samlaʼde, Masreca-neggweburginedid. ");
INSERT INTO cuk_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla burgwisgua, a-sorba, Saúl negdaknonikid. Saúlʼde, Rehobotʼginedid. Rehobot-neggweburde, Éufrates-diwar-gakaba siid. ");
INSERT INTO cuk_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saúl burgwisgua, a-sorba, Baal-Hanán negdaknonikid. Baal-Hanánʼde, Acbor-e-machid. ");
INSERT INTO cuk_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Acbor-machi-Baal-Hanán burgwisgua, a-sorba, Hadar negdaknonikid. Hadar-e-omedi, Mehetabelʼye nugad. Mehetabelʼde, Matred-e-sisgwad, Mezaab-e-wagwad. Hadar-e-neggweburga-gusadi, Pauʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","We-dulemar, Esaú-e-wagan-dummaganga gumalad. E-gwenadganmarba ilemakar danikid, e-yarmarba ilemakar danikid, degi, e-negmar-megismaladba ilemakar danikid. We, e-nugmalad: Timna, Alva, Jetet, ");
INSERT INTO cuk_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO cuk_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO cuk_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, degi, Iram. Wemala e-yargi bia-megismaladgi, Edom-dulemar-idumaladga gusmalad. Esaúʼdi, Edom-dulemar-e-dad-sailad. Esaúʼde, Edomʼye nugbalid. ");
INSERT INTO cuk_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob e-bab-maigusmogadgi-megega, Canaán-yargi besad. ");
INSERT INTO cuk_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jacob-e-igar weyob maid. José sapingwaunni, birgambe-gakagugle-nikagua (17), e-iamarmala sibad-wawaad-edarbedii daed. E-iamardi Bilha, degi, Zilpa-e-masmalad. Bilhaʼde, degi, Zilpaʼde Jacob-e-omeganad. José negse-modapir, e-iamar-sunnasurdaed e-babga sogdapdaed. ");
INSERT INTO cuk_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ar Israel nue-selebagusadgi José gwalulessoggu, Israel, e-masmala-baiganba bur bule José-sabed. Israelʼde, Jacobʼye nugbalid. Degisoggu, Israel, Joséʼga mor-suid yeerdakleged-akar-akar maksad. ");
INSERT INTO cuk_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","E-iamar dakarmargu, e-bab bur bule emarba José-sabdae, degidbali, e-iamar José-sae-dakdemalad, degi, bipisaar ese bar-gordii gussurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ibagwengi, José gabdaksad. Na e-gabdaksad e-iamarga sogsad. A-ular, e-iamar bur bule José-sae-dakarmalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ar ade, José e-iamarga weyob sogsad: —Bemar nue-an-itomalo, an-gabdaksad an bemarga soggwelo. ");
INSERT INTO cuk_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","An gabdaksad: Bela-anmar sapurba gudiiye. Orosgi-dakleged-trigo duk-dukgwen-imaknaigu, ukiagwar an-trigoʼdi gannaa gwisguded. Ar bemargaddi angad-dikarba bela ebilis ambikusmalad, degine, bela angad-abin dulluu imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Geb degine, e-iamar abin-sogdemalad: —Ar be sogsunde, ¿be anmar-reyga guoye? ¿Be anmar-dummadga megoye? Adi surbali. We deyob-gabdaksadba degi, e-iamarga e-gabdaksad-sogsadba e-iamar bur bule José-sae dakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","A-sorbali, José gabdaksabalid. A-gabdaksad e-iamarga sogsabalid. Weyob ega sogded: —An-gabdaksad be nue-itomarbalo: An dakalid, dad-ibeler, nii, degi, niisgwamar-gwaambe-gakagwensak (11) bela an-asabin dulluu imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","José weyob-gabdaksadi, e-babga, degi, e-iamarga sogsagua, e-bab Joséʼga sabsur-ibmar sokalid, ega sogded: —We deyob be gabdaksadi, ¿wede ibu be obare? ¿Ar ade, ani, be-nan, degi, be-iamar, anmar be-nug-odummonai gumalode? Adi surbali. ");
INSERT INTO cuk_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","E-iamar bur bule José-isdar dakdemalad. Ar e-babdi José-gabdaksadgi nue-binsadii gualid. ");
INSERT INTO cuk_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ibagwengine, José-e-iamar e-bab-sibad-wawaadmar gagangi-omaega, Siquem-neggwebursik nade gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Geb degine, Israel Joséʼga sokalid: —Be-iamar Siquem-neggwebur-naba sibad-wawaad-edarbedimalad. Be-iamar-daknabi an be-abedo. José abin-sogded: —Nuedgi an naodo. ");
INSERT INTO cuk_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israel sogded: —Nueddo. Be nae, be-iamar be daknae, igi gudimardibe, degi, sibad-wawaadmar nued bukwadibe. Be gannar anse nonikoed. Be anga sognonikoed, be-iamarde nueganbidibe. Israel Hebrón-neba-akar José-barmis gusad. ");
INSERT INTO cuk_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","José Siquemʼse modapgu, dule-wargwen, José sapurba-bipirmadii abingualid. Joséʼse egichialid: —¿Ibu be amidii? ");
INSERT INTO cuk_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","José abin-sogded: —An-iamar an amidii. ¿Sunna be anga sogsale, bia an-iamar sibad-wawaadmar edarbedimala? ");
INSERT INTO cuk_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Dule abin-sogded: —Bato wegi nadmalad. Be-iamar soge an itosad, emarde Dotán-neggweburse naye. Geb degine, José e-iamar-aminadap gusad. Dotán-neggwebur-dikarba abingudapid. ");
INSERT INTO cuk_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","E-iamar, José-danikid bato dikasuli daksabinmalad. José amba yoo ese warmake, idu igar amismalad, José-oburgwemaloye. ");
INSERT INTO cuk_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Geb sogdemalad: —¡Be dakmalana, dule-gabdakegwa dani! ");
INSERT INTO cuk_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ginebinne, anmar oburgwenae. Geb a-sorba anmar dia-yaagi metemaloed. Anmar sogmaloed, ibmar-sapurbalid-ursirmalad guchaye. ¡Anmar dakodo, bule-nabir e-gabdaksad ega guodibe! ");
INSERT INTO cuk_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rubén e-urbamar weyob-sunmaknanai-itosgua, José-bendakbi gualid. Degisoggu, e-urbamarga sogded: —Melle anmar José-oburgwemalo. ");
INSERT INTO cuk_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Melle bemar José-ablis eomalo. Wegi nega-dulesulidganba dia-siid-yaba be odomalo. Melle be oburgwemalo. Rubén José-bendakbiedba, deyob sogsad, adi, e-babga gannar José-dula-ukegar. ");
INSERT INTO cuk_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","José e-iamar-bukwadse modapgu, e-iamar José-gasmalad. Geb ei mor-suid-yeerdakleged-akar-akar-makaled esusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Geb dia-yaba José-metemalad. We-diade ollobi dinna siid. ");
INSERT INTO cuk_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Geb a-sorbali, e-iamardi mas-gunnega sigismalad. Geb agine, Ismael-dulemar danagwen Galaad-akar danimalad. E-moli-yargan-muregedgi gwallu-wawadikmalad, ina-wawadikmalad, sapi-gunnugiid-wawadikmalad-mirraʼye-nugad, Egipto-yarse semamaid. ");
INSERT INTO cuk_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Geb degine, Judá, e-gwenadganga sogded: —Ar anmar anmar-urba-oburgweye-soger, ¿ibi-nued anmar egi amiosunna? Ibmar-nued anmar egi amiosulid. Ar a-sorbali, anmar neg-oakalosad odukubalirgebed. ");
INSERT INTO cuk_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Deginbali, José anmar-urbabalid, bab mesamaladid. Bur-nuediled anmar bur Ismael-dulemarga manigi-uker. Judá-ibmar-soged bela e-gwenadgan yeer-itosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ismael-dule-ibmar-ukmalad José-e-iamar-bukwadse mosmargu, José-e-iamala José-dia-yaagi-siid-onosmalad. Ismael-dulemarde Madiánʼginmaladid. Degine, mani-gwadulagwengi (20) José-uksamalad. Weyobi Ismael-dulemar Egiptoʼse José-sesmalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rubén dia-siidse gannar nonigu, José-sate dakalid. Geb agi, Rubén e-mor esirmaksad, oyogega, ede, nue-nunmak itoye. ");
INSERT INTO cuk_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Geb a-sorbali, e-urbamar-bukwadse nonikid, amarga sognonikid: —¡Machigwa bar dia-yaba sisulid! Ar emigindi, ¿igi an gudoe? ");
INSERT INTO cuk_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Geb degine, e-iamar José-mor-suid-susmargu, sibad-bipi-oburgwisad-abegi mor dudismalad. ");
INSERT INTO cuk_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Geb degine, e-babse José-mor senonimalad. Degine, weyob Israelʼga sognonimalad: “Anmar we-mor amismala. Nue be dake, ¿we be-machi-e-mor-suid be dake?” ");
INSERT INTO cuk_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob dakdegu e-machi-mola, weyob sogded: “¡Eye, we an-machi-mor-suidi! An-machi ibmar-dula-sapurbalid-ursilidse gullesad.” ");
INSERT INTO cuk_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Geb degine, Jacob e-mor esirmakded. Geb wile-itogedba mor-sommed yosad, degine, iba-ichesuli e-machi-burgwisad-ular bodii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Bela e-masmala, degi, e-bunamala aisaale Jacob-gwage-baisur-itoge-imaknaidaenad, ar Jacobʼdi e-gwage-baisur-itoged abesurdaed. Aka bur bule e-machibina bodii daed, sogdii daed: “An-machi-burgwisad-ular, an burgwedse bodii guoye.” ");
INSERT INTO cuk_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ismael-dulemar Egiptoʼgi dule-Potifarʼye-nugadga manigi José-uksamalad. We-Potifarʼde Egipto-rey-Faraónʼga, arbaed-duled. Potifarʼde Faraón-sordamar-daked-e-dummadbalid. ");
INSERT INTO cuk_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","A-ibagangine, Judá e-gwenadgangi bangud gusad, dule-Hiraʼye-nugadse naded. Hiraʼde Adulam-neggweburginedid. ");
INSERT INTO cuk_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Agine, Judá Canaán-dule-Súaʼye-nugad-e-sisgwa abealid. Judá a-bunagwa nikusad. ");
INSERT INTO cuk_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Nikusgua, e-ome bonigwar-gunonikid. Susugwa ega uklenonikid, Erʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Gannar ome bonigwar gunonibalid. Susugwa ega uklenonibalid. Adi, Onánʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Judá-e-ome baid-machi nikunonibalid, Selaʼye onugsanonikid. A-machigwa gwalulesgu, deunni, Judá-ome, Quezibʼgi gudiid. ");
INSERT INTO cuk_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá e-machi-dummad-Erʼga ome-uksad. A-omede Tamarʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ar Bab-Jehováʼdi Er-e-daed gwen nabir daksursoggu, Er-oburgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Geb degine, Judá, Onánʼga sogded: “Igar-maidba be imakega, be-ia-burgwisad-e-ome be nikuo. Adi, be-ia beba mimmi nikumogagar.” ");
INSERT INTO cuk_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ar Onán wisid, e-mimmi-gwalulegoedi egadye soglegosulid. A-ulale, e-ia-omese-goled-irba napagi e-burba midaed, adi, melle e-ia eba mimmi-nikuegar. ");
INSERT INTO cuk_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onán-weyob-imakedi, Bab-Jehová gwen nabir daksasulid. Degisoggu, Bab-Jehová Onán-oburgwismosunnad. ");
INSERT INTO cuk_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Geb degidgine, Judá e-bala-Tamarʼga sogdesunnad: “An-machi-Sela-dummad-guedse be-bab-neggi suisuli be gudii gusun.” Ar ade, Judá binsabalid, e-machi-Sela e-iamaryob sunna burgwemogaddeeye. Deyobi, Tamar e-bab-negse nadegudsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ibagan nadedgi, Judá-ome-Súa-sisgwa burgwenonikid. Judá e-ome-burgwisadba bukib-itodiid wis baisur-itogusgu, Timnat-neggweburse nade gusad. Agi, Judá e-sibad-wawaadmar-e-absar-imminanaidse naded. E-ai-Hira Adulam-neggweburgined eba nade gusmogad. ");
INSERT INTO cuk_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamar wisgusad, e-saka-Judá Timnat-neggweburse sibad-wawaad-e-absar imminadye. ");
INSERT INTO cuk_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Deyob wisgusgu, Tamar e-sui-burgwisad-ular mor-bukib-binsaed-yoid esusad. Geb mor-baid yosad. Geb degine, dunwegi e-wagar odukusad, adi, melle dulemar magar e-dakmalagar. Geb degine, Enaim-neggwebur-dogedgi sigisad, ar ade, Timnatʼse-naega, agi igar maid. Tamar weyob imaksad, ar ade, Sela bato dummad-gusa daksad. Degine, Tamar, gwen Sela e-suigaguega, ega uksurmala daked. ");
INSERT INTO cuk_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judá ome-muswegi-na-wagar-eduar-siid-daksagua, binsaded, we-ome gambanuchurgebye. ");
INSERT INTO cuk_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Geb degine, Judá igarba-nadapidgi omese-naega aibatesunnad. Ar Judá wissulid, we-omede, e-bala gue. Omese-modapgu, ega sogded: —¿Sunna be anbo megisale? Ome abin-sogded: —Be anbo-megbiele, ¿ibu be anga ukoe? ");
INSERT INTO cuk_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judá abin-sogded: —An sibad-bipi-wargwen an bega barmidagoed. Ome abin-sogded: —Eye. Be-ibmar-sediid be anga udagwerdo. Be anga sibad-bipi-barmidagedse we-ibmar an bega gannar ukoed. ");
INSERT INTO cuk_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judá omese egichided: —Degite, ¿ibi bega ukbi be an-abesunna? Ome abin-sogded: —Be-goo-burba-wilub, degi, e-dub, degine, suar-gaapoled-be-ganikidi, be anga udado. Judá omega bela a-ibmar uksad. Geb degine, ese gochad. Degidbali, ome bonigwar gunonisunnad. ");
INSERT INTO cuk_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Geb a-sorbali, Tamar naded. E-wagargi muswe-naid unnusad. Geb degine, gannar e-sui-burgwisad-ular mor-bukib-binsaed-yoidaed yosad. ");
INSERT INTO cuk_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Geb a-sorbali, Judá e-ai-Adulam-neggweburginedba sibad-bipi barmisad, adi, ome e-ibe-ibmar-obesad ega gannar ukegar. E-ai ome-amissurgusad. ");
INSERT INTO cuk_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Degisoggu, Adulam-dule Enaim-neggweburginmaladse egichided: —¿Bia ome-gambanuchu Enaim-neggweburgined, igargi-sidaed nade? Abin-sogdemalad: —Wegi ome-gambanuchu sidasulid. ");
INSERT INTO cuk_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Geb degine, e-ai Judáʼse gannar nonisunnad, ega sognonikid: —Ome an daksasur gusad. Deginbali, Enaim-neggweburginmalad anga sogmarbalid, ome-gambanuchu bipisaar wegi gudidasurye. ");
INSERT INTO cuk_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judá e-ai-abin sogded: —Ome an-ibmar-ganikid egadga gusunnodo, adi, melle dulemar anmargi dodomalagar. Ar wedi dulemar wisgumalargebed, an ega sibad-bipi barmisanad, ar be a-ome-amis-inigwele, degite, be daksasur gusad. ");
INSERT INTO cuk_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Nii-walapaagwad-sorba Judáʼga sognonimalad: —Be-bala-Tamar machergan-baiganba yootee gudiiye. Degisoggu, bonigwar-gudsunye. Judá binnasur sogded: —¡Bemar we-ome onomala, bemar ogumakar oburgwemala! ");
INSERT INTO cuk_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tamar-magaba-onolenaigu, e-sakaga gaya-barmisad: “We-ibmarmar-e-ibed bonigwar an-imaksad. We-goo-burba-wilub, e-dub, degi, we-gaapoled, we-ibmar, ¿doagad be dake?” ");
INSERT INTO cuk_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judá e-ibmarmar magar-daksagu, sogded: “Ar ani an Tamarʼga an-machi-Sela uksasursoggu, Tamar nabir imaksad. Andina, igar-maidgi bur nue-dummad-nosad.” Judá bar e-balase bipisaar gochasulid. ");
INSERT INTO cuk_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar mimmi-nikunonigu, warbo ega uklenonikid. ");
INSERT INTO cuk_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Gwalulenaimargu, machi-wargwen e-argan onosad. Geb degine, muu-sikwigaed machi-bipi-e-argangi dub-ginnid edichad, geb sogded: “We-inse aidenonikid.” ");
INSERT INTO cuk_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Degidgine, machi-bipi gannar e-argan odosad. E-gwenad-inse aidenonikid. A-ulale, muu-sikwigaed Faresʼye goe-onugsasad. Ar ade, soged: “¡Be-inse be idusadid!” ");
INSERT INTO cuk_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Geb degine, baid-machi-bipi e-argangi dub-ginnid-atinnale aidenonimogad. A-machidi Zaraʼye onugsalesad. ");
INSERT INTO cuk_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","José Egipto-yarse-selesgu, Egipto-dule-Potifarʼye-nugad Ismael-dulemarse José-baksad. Potifarʼde Faraónʼga arbaedid, degi, Faraón-sordamar-daked-e-dummadid. Faraónʼdi Egipto-e-reyd. ");
INSERT INTO cuk_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ar Bab-Jehováʼdi Joséʼba gudiguad. Degisoggu, José e-dummad-Egipto-dule-neggi-gudigu, bela Joséʼga ibmar nueganbi nadegusad. ");
INSERT INTO cuk_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","E-dummad-Potifar dakalid, Bab-Jehová Joséʼba nue-gudii. A-ulale, Joséʼga bela ibmar nueganbi guddae. ");
INSERT INTO cuk_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Degisoggu, e-dummad José-yeer-dake gunonisunnad. Potifar José e-bendakega onugsanonikid, degine, e-neggi ega-ibmar-daked-dummadga onugsasbalid. Degisoggu, Potifar bela e-ibmar-nikadi, José bela ega ibmar-dakega nugsasad. ");
INSERT INTO cuk_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Potifar e-neg-dakega José-onugsasgu, degi, bela e-ibmar-nikad ega dakega imaksabargu, a-ibagan-onoded-akar, Bab-Jehová Egipto-dule-Potifarʼgi ise-nued binsaded. E-neggi, degi, sapurba bela e-ibmar-nikadgi, ise-nued binsaded. ");
INSERT INTO cuk_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","José Potifarʼga bela ibmar-dakdisoggu, Potifar dogdar bar e-ibmargi ise-binsaar gudisulid, ar wisid, José bela ega ibmar nue-akwediid. Degisoggu, unnila masginbi binsadisunnad. José, sapingwa-nued-itoged yeer dakleged. ");
INSERT INTO cuk_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Degisoggu, ibagan-nanamaidgi, Potifar-e-ome, Joséʼbina-sokalid. Ibagwengi Joséʼga sogded: —José, dage. Anmar anbo mege. ");
INSERT INTO cuk_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Joséʼdi yapa gusad. José, ome-abin sogded: —An-dummad bela-ibmar-nikad ega-dakega an-nug-imaksad. Emigi, an-wegi-gudiidgi an-dummad bar gwen dogdar ibmargi bukib binsadisulid. ");
INSERT INTO cuk_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","We-neguyagi, dule-baid anba-bur-dummad sulid. An-dummadse ibi an egisdedibe, surye gwen anga sogdisulid. Unnila bebi geg an be-ebuged, ar ade, bedi e-omed. Degisoggu, ¿ar igi we-ibmar-isgana an imakosunna? Bab-Dummadgi an nue-dummad-nosar-itole. ");
INSERT INTO cuk_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ar Potifar-e-ome bane-bane Joséʼgi alamakdidaed, ebo megega, degine, e-walikaa-gudii guegar. Ar Joséʼdi gwen eba ibsadisulid. ");
INSERT INTO cuk_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ibagwengine, José arbaegala negyaba dogded. ");
INSERT INTO cuk_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ar dule satesoggu, ome, José-mordukugi gadebin-imaksad, ega sogded: “¡Anbo be mege!” Ar Joséʼdi ise-abarmakar noded. Degisoggu, e-mor ome-argangi-obes abarmakded. ");
INSERT INTO cuk_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ome José-abarmakde-dakdegu, degi, e-argangi mor mide-nade dakdegu, ");
INSERT INTO cuk_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","neggi-ega-arbamaladse gochad. Amarga sogded: “Nue be dakmala. An-sui anmarga Hebreo-dule-senonikidi, emigindi, anmargi dodoalid. An-dakega negyaba dogsad, anse gorbigualid. Ar andi binnasur goted. ");
INSERT INTO cuk_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ar bela-bela binnasur-gole an-itoargu, e-mor-obesa abarmakded.” ");
INSERT INTO cuk_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Geb degine, ome José-mor urbisad, geb e-sui-negse-nonigua ega oyosad. ");
INSERT INTO cuk_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Geb degine, ome dule-baiganga-sogsadyob e-suiga sogdebalid: “Hebreo-mai-be-anmarga-senonikidi, angi dodogega an-gabedyaba dogsad. ");
INSERT INTO cuk_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ar an bela-bela binnasur gotesoggu, e-mor-obes abarmakded. ");
INSERT INTO cuk_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Weyob, be-mai an-imaksad.” José-e-dummad e-ome-ega-ibmar-sogsadba bela-bela nue-sae itoded. ");
INSERT INTO cuk_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Degisoggu, Potifar José-gasgu, igar ukded, reymar-sordamar esgaryagi-mellesiidyaba José-metoye. Amba esgaryagi José mellesi-inigwele, ");
INSERT INTO cuk_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Bab-Jehováʼdi, Joséʼba amba gudii gusad. E-sabgued amba Joséʼga oyomai gusad. Degisoggu, Bab-Jehová esgarya-daked-dummad José-nued-dakega imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Esgarya-daked-dummad, bela dulemar-mellebukwad-dakega José-onugsasad. Esgaryagi bela ibmar-imakleged José-sogedba imaklemai gualid. ");
INSERT INTO cuk_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Esgarya-daked-dummad José-ibmar-imaked bar sorba daknonidasulid, bule nabir imaksadibeye. Ar ade, Bab-Jehová Joséʼba-gudigusoggu, bela Joséʼga ibmar-nueganbi-gued imakdaed. ");
INSERT INTO cuk_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Weyob ibmar-gusad-sorbali, nogdaked-e-dummad, degi, madusobed-e-dummad, e-dummad-Egipto-e-reygi nosgusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Degidbali, Rey-Faraón we-dulemar-ega-arbamalad-warbogwadse nue-uluded. ");
INSERT INTO cuk_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Degisoggu, Faraón nogdaked-e-dummad, degi, madusobed-e-dummad esgaryagi meted. Esgaryade sordamar-e-dummad-neggi siid. José amba a-esgaryagi mellesimogad. ");
INSERT INTO cuk_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Sordamar-e-dummad Joséʼga we-dulemar-warbogwad urmaksad, adi, José wemar-dakegar. We-dulemar undar esgaryagi mellesii gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ibagwengi, mutikidba, wemar-warbogwad-esgaryagi-mellesiid gabdakar gusad. We-gabdaksamalad-e-oduloleged, akar-akar nanaed. ");
INSERT INTO cuk_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","José wakdaradba, we-dulemar-warbogwadse-ataknonigu, nue-bukib-binsabukwa daknonikid. ");
INSERT INTO cuk_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Agala, José we-Faraónʼga-arbamalad-dummagan-mellesimaladse egisdesunnad: —¿Ibiga emi bemar nue-bukib-binsabukwa? ");
INSERT INTO cuk_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Amar abin-sogdemalad: —Anmar-gabdaksadi, dule-anmarga-oduloged sated. José abin-sogded: —¿Ar ade, Bab-Dummad gabdaked-odulogedsursi? Bemar anga soge, igi bemar gabdaksamala. ");
INSERT INTO cuk_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Geb degine, nogdaked-e-dummad Joséʼga e-gabdaksad sogded: —An gabdakmaigu, uva-dub an dakalid. ");
INSERT INTO cuk_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Uva-dub e-dub-giapaa-nika an dakalid. Uva-dub sanmakali, e-dutumar naguali, degi, gwagde an dakalid. Uvaʼmar dukar-enagude, degi, gorede an dakarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","An-argangi Faraón-e-noga an ganiki an dakalid. Geb uva noggi-egurega an susdaed. Geb a-sorba, Faraónʼga an nog ukdedaed. ");
INSERT INTO cuk_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Geb degi, José ega sogded: —Be gabdaksadi, we obardo: Uva-dub-giapaagwadi, ibapaagwadye. ");
INSERT INTO cuk_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ibapaase, Faraón bega igar amioed. Geb gannar be-arbaed bega ukoed. Gannar Faraónʼga nog-uknai be guoed. ");
INSERT INTO cuk_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","”Deyob bega gunonikile, melle be an-iego, an-ebinsao. Wis an-ular Faraónʼga be sunmako, adi, we-esgaryagi-an-mellesiid an-onogegar. ¡Wile be an-dako! ");
INSERT INTO cuk_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ar Hebreo-dulemar-e-yalagangi an-atursasmalad. Ar an esgaryagi mellesiwilubsulinad, ar ade, ibmar-ichakwa gwen an imaksasulid.” ");
INSERT INTO cuk_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Madusobed-e-dummad, José, e-gabdaksad nued-odulosa-daksagu, Joséʼga sogdemogad: —An gabdaksamogad, garba-burwigana-gwapaagi madu-ochigana an nono-birgi sii an daksad. ");
INSERT INTO cuk_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Garba-birginedgi galagwensuli madu-ochigana Faraónʼga-bukwa an daksad. Agine, sikwimar garba-an-nonogi-siidse madu-ochigan gunnonidamala an daksad. ");
INSERT INTO cuk_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Geb degine, José abin-sogded: —Be gabdaksadi, we obardo: Garba-burwigana-gwapaagwadi, ibapaagwadye. ");
INSERT INTO cuk_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ibapaase, Faraón bega igar amioed. Geb sapidukugi gammu-gaale be-oburgoed, degi, mulamar be-san gunnoed. ");
INSERT INTO cuk_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A-ibapaagwadgi, Faraón-gwalulesad-iba nonikid. Faraón iba-dummad ega-arbamaladga onosad. Faraón, e-ibase-nonimalad-asabin, ega nogdaked-e-dummad-mellesiid-sedagega, degi, madusobed-e-dummad-mellesiid-sedagega imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Faraón, nogdaked-e-dummad gannar e-arbaedgi odosad. Nogdaked, gannar Faraónʼga nog-dakega gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Faraón, José gabdaksad-odulosadyob, madusobeddi, sapigi gammu-gaale oburgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Degi-inigwele, nogdaked-e-dummad bipisaale Joséʼgi gwen bar binsassulid. ");
INSERT INTO cuk_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ibagwengi, birgabo nasad-sorba, Faraón gabdakalid, ede Nilo-diwar-gakagi gwichiye. ");
INSERT INTO cuk_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Diwargi moli-bebe-nikad-omegan-yeerdaklege, degi, wardada-wardada-daklege walagugle (7) nakwiali daksad. A-molimarde, masarmaryob-dakleged-imbaba gagan-mananai daksad. ");
INSERT INTO cuk_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A-molimar-sorbali, walagugle (7) molimar-bebe-nikad-omegan-baigan, sunnasur-dakle, degi, gara-gara-dakle, diwargi nakwiar daksabalid. A-molimar, molimar-baigan-naba diwar-gakagi ambikunonimala daksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Geb degine, moli-bebe-nikad-omegan-garagana, moli-bebe-nikad-omegan-wardadagan-guchamala daksabalid. Agi, Faraón atakalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Faraón gannar gabidbalid, degi, gabdakarbalid: Dakalid, orosgi-dakleged-sargwengi gagugle (7) e-durbagan-yeerdaklege nue-sanmaknanai daksad. ");
INSERT INTO cuk_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Wemar-sorba, orosgi-dakleged-baid-sargwengi gagugle-ainiarbali (7) daksabalid. Amardi gara-gara, degi, dad-nakwedsik-burwa-goledse dinna-dinnagusa daksad. ");
INSERT INTO cuk_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","We orosgi-dakleged-durbagan-gara-garagwad-gagugledi (7), durbagan-baigan-nue-sanmaknanaid-gagugled (7) guchad. Faraón atakargu, gabdakmai itoalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Oibosgu, wakdaradgine, Faraón nue-suli-suli itoalid. Degisoggu, Faraón igar-uksasunnad, bela Egiptoʼgi nelemar, degi, nue-ibmar-wisimalad, ese dagmaloye. Faraón amarga e-gabdaksad bela sogsad. Amar wargwensaale, bipisaar ega gwen odulossurmalad, wede ibi-obare. ");
INSERT INTO cuk_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Geb degine, nogdaked-e-dummad José-e-binsaded. Agi, Faraónʼga sogded: “Dummad, nue-dummad-nosa an-itoged. ");
INSERT INTO cuk_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Emi an ebinsado, madusobed-e-dummad, degi, ani, an bega-arbaed-dule, be sae-itogedba anmarse-uludgu, sordamar-e-dummad-neggi-esgarya-siidse be anmar-warbobela mete gusad. ");
INSERT INTO cuk_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Deunni, ibagwengine, mutikidbali, madusobed-e-dummad gabdaksad, degi, an gabdaksamogad. We-gabdaked anmargi-ibmar-guoed, anmar egad-egad gabdaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","A-esgaryagine, Hebreo-sapingwa-wargwen anmar-abargi mellesii gusmogad. We-sapinde sordamar-e-dummad-e-maid. A-sapingwaga, anmar-gabdaksad anmar sogsa gusad. A-sapinde, anmarga odulosad igi an-gumaloe. ");
INSERT INTO cuk_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","¡Igi anmarga odulosa, bela deyob gusad! An-arbaedse gannar an dogsad. Baiddi dukar-gaar oburgwilesad.” ");
INSERT INTO cuk_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Geb degine, Faraón Joséʼse gochad. Agi, esgaryagi-mellesiidgi, yog-onoar imaksamalad. José nue saila-siksad, mola-nued yosad. Geb degine, Faraónʼse nonikid. ");
INSERT INTO cuk_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Geb degine, Faraón ega sogded: —An gabdaksad. Emide, dule-anga-oduloged sated. Emide an itoged, dule bega gabdaked sogsale, bedi sunna oduloye. ");
INSERT INTO cuk_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","José, Faraón-abin sogded: —Dummad, we-oduloged angi sisulid. Ar Bab-Dummad bega odulogoed. We-odulolegoed bega ibnuedga guoed. ");
INSERT INTO cuk_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraón Joséʼga sogded: —Nilo-diwar-gakagi gwichiye an gabdakalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Diwargi moli-bebe-nikad-omegan-yeerdaklege, degi, wardada-wardada-daklege walagugle (7) nakwiali an dakalid. A-molimarde, masarmaryob-dakleged-imbaba gagan-mananai an dakalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","A-molimar-sorbali, walagugle (7) molimar-bebe-nikad-omegan-baigan, sunnasur-dakle, degi, gara-gara-dakle, diwargi nakwiar an dakarbalid. ¡Bipisaale bela Egipto-yargi weyob molimar-sunnasur-dakleged an dakdisulid! ");
INSERT INTO cuk_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Geb degine, moli-bebe-nikad-omegan-garagana, moli-bebe-nikad-omegan-wardadagan-guchamala an dakarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ar moli-garagana moli-wardadagana-guchamar-inigwele, amba gara-gara-dakleged. Agi, attaas an naded. ");
INSERT INTO cuk_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","”Gannar an gabidbargu, an gabdakarbalid: An dakalid, orosgi-dakleged-sargwengi gagugle (7) e-durbagan-yeerdaklege, nue-sanmaknanai an dakalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Wemar-sorba, orosgi-dakleged-baid-sargwengi gagugle-ainiarbali (7) daksabalid. Amardi gara-gara, degi, dad-nakwedsik-burwa-goledse dinna-dinnagusa an dakarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","We orosgi-dakleged-durbagan-gara-garagwad-gagugledi (7), durbagan-baigan-nue-sanmaknanaid-gagugled (7) guchad. Deyob an gabdaksad nermarga an sogsanad. Amar wargwensaale, gwen anga odulossurgusmalad.” ");
INSERT INTO cuk_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Geb degine, José Faraón-abinsaded: —Dummad, be-sogbo-gabdaksadi, we unnila soggwenna gued. Bab-Dummad e-ibmar-imaksokalid be-owisonaid. ");
INSERT INTO cuk_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Moli-bebe-nikad-omegan-nuegan-walagugled (7) obardo, birgagugledye (7). Orosgi-dakleged-e-durbagan-nuegan-gagugled (7) amba birgagugledye (7) obarbalid. Be-sogbo-gabdaksadi, ebobela soggwennagwad. ");
INSERT INTO cuk_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Moli-bebe-nikad-omegan-walagugle (7) sunnasur-gara-gara-dakleged, baigan-sorba-ainialidi, amba obarbalid, birgagugledye (7). Amba deyobbalid, orosgi-dakleged-durbagan-gagugled (7) gara-garagwad, degi, dad-nakwedsik-burwa-goledse-dingusadi, we obared, birgagugle (7) ibmar sate guoye. ");
INSERT INTO cuk_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","”Ar igi an bega sogsa, ar deyobdo: Faraón, Bab-Dummad e-ibmar-imaksokalid be-owisonaid. ");
INSERT INTO cuk_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Bela Egipto-yalagi birgagugle (7) ibmar ise-obinagwar welenai guoed. ");
INSERT INTO cuk_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Geb a-sorbali, birgagugle (7) ukud-dummad nagunonikoed. Dulemar, Egiptoʼgi iduar-ibmar-yaisur-nikusadi, gwen bar ebinsaosurmalad, ar ade, ukud-dummadi Egipto-yar-obelogoed. ");
INSERT INTO cuk_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ar ibmar bela-bela sate-guosoggu, iduar ibmar bela-bela-nikusadgi bar binsaosurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Faraón, ilabo-be-gabdaksad, obared, Bab-Dummad weyob ibmar-imaksokalidi, bato emisgwasaar imaksokarye. ");
INSERT INTO cuk_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","”Degisoggu, Faraón, Egipto-yargi dule-gwensak, dule-binsaed-ibed, dule-nue-ibmar-wisid ibmar-dakega be amiele, nuediled. ");
INSERT INTO cuk_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faraón, weyob be imake: Dummagan-negdakmalad be onugsae, adi, amar bela Egipto-yargi ibmar-gwag weemalagar. Amar ibmar-gwag-welesad sagu-walatargi gwensak sumaloed. Weyob ibmar birgagugle-sanmakoedi (7) sumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Birga-nued-naguoedgi orosgi-dakleged-weemaloed bela danakwaa urbemaloed. Faraón, we-ibmar-urbilegoed, bee be dakoed, degine, neggwebur-dummagangi we-mas be sabogoed. ");
INSERT INTO cuk_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Deyobi, orosgi-dakleged bela Egipto-yarga sabolegoed, adi, Egiptoʼgi ukud-dummad birgagugle-nagunonikir (7), melle dulemar burgwemalagar.” ");
INSERT INTO cuk_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","José Faraónʼga sognaid, weyob be ibmar imakye. Faraón, degi, dummagan-ega-arbamalad, nued José ega-ibmar-soge itosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Degisoggu, Faraón sogdesunnad: —¿Bemar insagua, dule-baid weyobi Bab-Dummad-burba-nikad anmar amio be insae? Anmar amiosuli. ");
INSERT INTO cuk_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Geb Faraón Joséʼga sogded: —Ar Bab-Dummad bela we-ibmarmar-wisguega be-imaksadsoggu, a-ulale, dule-baid beba dule-binsaed-ibed, dule-nue-ibmar-wisid sulid. ");
INSERT INTO cuk_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Degisoggu, bee, wegi an-reyneg-dakega be guoed. Degine, an-dulemar bela be-sogedba ibmar imake gumaloed. Ar ani, an reysoggu, unnila anbi begi bur dumma guoed. ");
INSERT INTO cuk_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Geb degine, Faraón Joséʼga sogdebalid: —Bela Egipto-yar-daked-dummadga, ani, an be-onugsanaid. ");
INSERT INTO cuk_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Geb degine, Faraón e-argangi olargan-yoid unnusad. A-olargan-yoidgi e-wilub naid. Geb degine, olargan Joséʼga yosad. Geb a-sorbali, Faraón igar-ukded, sogded: Mor-nued-linoʼye-nugad, a-mola Joséʼga yomarye, degine, e-dukargi ordub ega nasikmarbarye. ");
INSERT INTO cuk_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Geb a-sorbali, Faraón e-ur-napagined-gusgu-e-sorba-naidaedgi José-onakwisad. Degine, Faraón igar-uksabalid, binnasuli José-iduar gornadap-imakmaloye: “¡Igar egamar!” Weyobi, José dummadga Egiptoʼgi nuggunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Geb degine, Faraón Joséʼga sogdebalid: —Ar ani, an dummad-inigwele, bela Egipto-yargi bipisaale dule be-wissuli ibmar imakosulid. ");
INSERT INTO cuk_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraón Egipto-gayaba José-onugsanonikid, Zafnat-Paneaʼye. Degine, Faraón Potifera-e-sisgwa-Asenatʼye-nugad, José-nikuega ega uksad. We-Potiferaʼde On-neggweburgi dule-irwa-e-bab-dummadse-goledid. Weyobi, José bela Egipto-yargi dummadga gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","José birga-dulagwen-gakambe-nikadgi (30), Egipto-e-rey-Faraónʼse seles gusad. José Faraónʼga degimaloye sogsagu, Egipto-yargi bela atakdii gualid. ");
INSERT INTO cuk_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Egiptoʼgi birgagugle (7) bela-bela nue-ibmar sanmaksad. ");
INSERT INTO cuk_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","José we-birgagugledgi (7) bela orosgi-dakleged Egipto-yargi-nikadi wesad. Bela-amar neggwebur-dummagangi sabosad. Neggwebur-dummagan-dikarba nainu-nanaidgi orosgi-dakleged-welesadi, neggwebur-dummagan-irba sabosad. ");
INSERT INTO cuk_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","José orosgi-dakleged ukub demar-gakaba-merguedyobi, bela-bela-mergu wesad. Ar orosgi-dakleged bela-bela mergusoggu, geg wilubsalegusad, ar wisgulessurgusad igi mergue. ");
INSERT INTO cuk_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ukud-dummad-nagued-idu, José e-ome-Asenatʼbo machimala-warbo nikusad. Asenatʼde Potifera-e-sisgwad. Potiferaʼde On-neggweburgi dule-irwa-e-bab-dummadse-goledid. ");
INSERT INTO cuk_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","José e-machi-gebesailagined Manasésʼye onugsasad, ar ade, José soged: “Bela-nunmaked-dummad-an-itosad, iegega Bab-Dummad an-imaksad, degine, an-gwenadgan-iegega an-imaksabalid.” ");
INSERT INTO cuk_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","José baid-e-machidi Efraínʼye onugsasad, ar ade, José soged: “An yar-wilesadgi Bab-Dummad mimmimar-nikuega an-imaksad.” ");
INSERT INTO cuk_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Egiptoʼgi birgagugle (7) ibmar-yaisur-sanmaksad bergudapid. ");
INSERT INTO cuk_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Degine, José iduakwaa sogsadyob, ukud-dummad nagudmogad. Bela yar-baigangindi ukud-dummad nagusad. Egiptoʼgindi masgunned nika gusad. ");
INSERT INTO cuk_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Egipto-yarginmalad ukur-itoarmargua, Faraónʼse masgunned egisnadmalad. Geb degine, Faraón, bela Egipto-dulemarga sogded: “José be daknamala. A-sogedba bemar ibmar saoed.” ");
INSERT INTO cuk_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ukud bela-bela Egipto-yargi nagunonigu, José orosgi-dakleged-sabolebukwad-negmar bela eganonikid. Geb degine, José Egipto-dulemarga manigi ukded, ar ade, bela-Egiptoʼgi ukud bur bule naguded. ");
INSERT INTO cuk_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Bela dule-yar-baigangi-bukmaladdi, Joséʼse orosgi-dakleged-bakmalaga Egiptoʼse nonidamalad. Ar ade, yar-baigangindi masgunned satemalad. ");
INSERT INTO cuk_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob wisgusgu, Egipto-yargi orosgi-dakleged-nikaye, e-machimalaga sogded: “Anga sogmalad, Egipto-yargi orosgi-dakleged nikaye. ¿Ar ibu be abdakmarsunna, emide, be muchub-muchub nuu na be dakbukmargu? ");
INSERT INTO cuk_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Degisoggu, bemar Egiptoʼse namala, ase orosgi-dakleged baknamala, adi, anmar mer burgwemalagar.” ");
INSERT INTO cuk_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Geb degine, José-e-iamar-warambegwad (10) Egiptoʼse orosgi-dakleged baknadmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jacob José-e-urba-Benjamín, e-iamarba barmissulid. Ar ade, binsaed: “Abakalegi, Benjamín igarba nailikgualirye.” ");
INSERT INTO cuk_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ar bela Canaán-yargi ukud-dummad naimosoggu, Israel-masmala dulemar-baigan-mas-baknadmarmogadba nadmarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","José Egipto-yargi dummadga maid. A-ular, bela dulemar-neggwebur-baidginmalad orosgi-dakleged bakdanikile, José ega ukdaed. E-iamar Joséʼse-nonigua, bela José-abin dulluu e-bebe napase ebulegedse imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","José e-iamar-dakdeyalaba bato magar-daksad, e-iamalad. José yamo aku-e-iamar-dakeyob imaksad. Degi, apor e-iamarse egichided: —¡Bemar! ¿Bia be danimala? E-iamar abin-sogdemalad: —Anmar Canaán-yalagi danimalad, orosgi-dakleged bakegar. ");
INSERT INTO cuk_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ar Joséʼdi e-iamar-mag-daksad. E-iamardi José-aku daked. ");
INSERT INTO cuk_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Geb degidgine, José e-iamargi-gabdaksad insaas naded. Geb degine, e-iamarga sogded: —Bemar dule-argamalad gumalad. Bemar unnila dakdanimalad, bia anmar-yargi baisursunna-doglemalad sii. ");
INSERT INTO cuk_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Abin-sogdemalad: —¡Dummad! Suli, degisuli. Anmar, be-maimar gued. Anmar orosgi-dakleged-bakega nonikid. ");
INSERT INTO cuk_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Bela anmar bab-galagwenad gumalad. Anmar dulemar-yardakedsurmalad. Anmar bipisaale dulemar-argaega gudisurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","José bur bule sogded: —Binsa bemar gordii. Bemar unnila dakdanimalad, bia anmar-yargi baisursunna-dogleged sii. ");
INSERT INTO cuk_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","E-iamar José-abin sogdemalad: —Anmar be-maimar gued. Bela anmar bab-wargwengi gwenadgan-ambe-gakabo (12) gumalanad. Anmar Canaán-yargi maimalad. Anmar-urbadi, anmar-bab-walik besad. Baiddi burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Degi-inigwele, José, e-iamarga gannar sogdebalid: —An bemarga sogsamalad, bemar dule-argamalad gumarye. ");
INSERT INTO cuk_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Weyob, an bemar-wilubdakoed: Faraón-nuggi napira an bemarga soged: Bemar be-urba anga wese sedagedse, geb be nomaloed. ");
INSERT INTO cuk_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ar bemar-wargwen be-urba be sunamardo. Bemar-baigandi wegi gales-sigmaloed. Anmar dakmalodo, bule-nabir bemar anga sogmala. Ar nabirsulile, Faraón-nuggi napira an bemarga soged: Ar bemar dule-argamaladdo. ");
INSERT INTO cuk_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Geb degine, José ibapaa esgaryagi e-iamar-meted. ");
INSERT INTO cuk_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ibapaagusgu, e-iamarga sogded: —An Bab-Dummad-dobee nanadiid-duled. Ar bemar an-yardaknaisurmalale, be-gwenad-wargwen esgaryagi be obes namardo. ");
INSERT INTO cuk_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ar deyob bemar imakele, an bemar-oburgosulid. Bemar-baigandi namalo, orosgi-dakleged be sedmalo, adi, be-gwenadgan nabir mas gunmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Geb be anga be-urba-bipigwad be sedamaloed. Agi, an dakoed, bule-nabir be anga sogmala. Ar degisulile, be oburgwilemaloed. E-iamar José-ega-ibmar-sogedba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","José-e-iamar na ga muchub-muchub sogdemalad: —Anmar anmar-urbagi nue-dummad nosmalad. Ar anmarga weyob sognai-gusan-inigwele, bemar wile an-dakye. Anmar itossurmalad. A-ulale, wede, emi anmarga nunmaked-dummad nonimosunnad. ");
INSERT INTO cuk_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubén e-gwenadgan-abin sogded: —An bemarga sognaigusanad, melle bemar machigwa naibisamarye. Ar bemar an-itossurmalad. Degisoggu, emigindi machigwa-burgwisad anmarginsoggu, anmar emigindi wilenaimosundo. ");
INSERT INTO cuk_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","José-e-iamar wissurmalad, José bela mag e-itoged. Ar ade, José e-iamarbo-sunmaknaigua, dule-baid ega odulos gusad. ");
INSERT INTO cuk_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","José e-iamargi banguded. Geb degine, José boded. José gannar e-iamar-bukwadse-nonigu, ega sunmakdebalid. Geb José, Simeón e-gwenadgan-abargi-gwichid onosad. Geb e-gwenadgan-wagab edichad. ");
INSERT INTO cuk_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Geb a-sorba, José ega-arbamaladga igar-uksad, orosgi-dakleged sagu ena-ena imakoye. Degine, gannar ega mani ukoye, e-sagu-e-sagu-yaba ega mani urboye. Degine, igarba mas-gunmaloed ega ukbaloye. Ar José-sogsadyob bela imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Geb degine, José-e-iamar e-moli-uayasuidgi orosgi-dakleged urbismargu, nadmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","José-e-iamar gabmaloedse modapmargu, wargwen e-moli-uayasuid-masgi-omaega e-sagu egaded. Sagu-egadgu, dakalid, e-mani bukwa. ");
INSERT INTO cuk_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Geb degine, e-gwenadganga sogded: —¡Be dakmalana, gannar anga mani uksamalad! ¡Be dakmalana, an-sagu-yaba mani bukwad! José-e-iamar belagwable bela-bela nue-dobe-itonadmalad, dobedba wawanmakdemargu, na ga muchub-muchub sogdemalad: —¿Wede igi Bab-Dummad anmar-imaknai? ");
INSERT INTO cuk_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Canaán-yarse warmakdapmargu, bela e-bab-Jacobʼga sogdapmalad, emar igi gusmala. E-babga sogdemalad: ");
INSERT INTO cuk_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Dule-Egipto-yar-dakmaid anmarga nue-apor sunmaksad. Anmarga soged: ‘Bemar an-yarse-nonimaladi yamo an-yar-argaega nonimarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ar anmardi abin-imaksamalad: ‘Anmar dule-yardakedsurmarye, degi, anmar bipisaale dule-argamalaga gudisurmarbarye. ");
INSERT INTO cuk_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Bela-anmar bab-wargwengi gwenadgan-ambe-gakabo (12) gumalanye. Wargwendi bato burgwisye. Bipigwaddi Canaán-yargi be-walik besye.’ ");
INSERT INTO cuk_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","”Geb degine, Egiptoʼgi-dummadga-maid anmarga weyob soged: ‘An-walik be-gwenad-wargwen be obemarye, adi, agi an magar bemar-dakoye, bemarde bule dule-yardakedsurmardibeye. Bemar-baigandi orosgi-dakleged be-gwenadganga be sedmarye. ");
INSERT INTO cuk_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Degi-inigwele, be-urba-bipigwad be anse sedamaloye. Deyob bemar imakele, an magar dakoed, bemar dule-yardakedsurmalad, degine, bemar dule-argaedsurmarbalid. Geb degine, be-gwenad-esgaryagi-siid an onogoye. Geb bemar be-itoleged, bia bemar we-yargi nabiedba be nanadii gumaloye.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","José-e-iamar orosgi-dakleged, sagu-yaba-bukwad-onodmargu, dakarmalad, e-sagu-e-sagu-yaba sagu-bipigi bela mani bukwadbi. Deyob dakarmargu, José-e-iamar, degi, e-babse-bakar, dobe itodmalad. ");
INSERT INTO cuk_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Geb degine, Jacob e-masmalaga sogded: —Bemar, masmala-sate be an-imakmaloed. José bato burgwis, degi, Simeón anmarba bar gudisurbalid. ¡Emigindi, bemar Benjamín an-ibe nidesokarbalid! ¡An emarba bur ibitodiid! ");
INSERT INTO cuk_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Geb degine, Rubén e-babga sogded: —Ani an bega Benjamín-dakoed. Ani an gannar bega Benjamín senonikoed. Bega an gannar senonisulile, an-masmala-warbogwad be oburgodo. ");
INSERT INTO cuk_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ar Jacob e-machi-abin sogded: —An-machi-Benjamín bemarba naosuli. Benjamín-e-ia-José burgwisad. Unnila Benjamínʼbi napi-anga gudiid. Ar bemar nasokalidba, igarba Benjamín akar-gusale, ar bemargindo. Ar an seredgusad, bukib-binsaedba an burgwisar, bemargindo. ");
INSERT INTO cuk_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Canaán-yargine bur bule ukud-dummad-naid gangumai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Degisoggu, Jacob, degi, e-masmala Egipto-yargi-orosgi-dakleged-senonimalad bergudanigu, Jacob e-masmalaga sogded: —Gannar Egipto-yarse bemar namar, anmarga orosgi-dakleged wis ichesaar be baknamar. ");
INSERT INTO cuk_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ar Judá, e-bab-abin sogded: —Dummad-mas-dakmaid nue anmarga ise-sogar imaksad: ‘Be-urba-bipi bemar sedanisurmalale, bur melle be anse dagmaloye.’ ");
INSERT INTO cuk_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Degisoggu, Benjamín be anmarba barmidele, anmar bega orosgi-dakleged baknaodo. ");
INSERT INTO cuk_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ar be anmarba barmisulirdi, anmar bega baknaosurmodo. Ar dule anmarga sogsad: ‘Ar bemar be-urba-bipigwad anga sedasurmalale, bemar gwen an-dakosurmarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Geb degine, Israel sogded: —¿Ibiga bemar sunnasur angi damala? ¿Ibiga bemar we-dulega sogsamala: ‘Anmar, urba-baid nikabarye?’ ");
INSERT INTO cuk_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Masmala e-bab-abin sogdemalad: —Ar ade, dummad-mas-dakmaid anmarse nue-ibmar egichisad, degi, anmarse nue-anmar-gwenadgan egichisbalid. Anmarse egichisad: ‘¿Be-babde amba dula? ¿Bemar urba-baid nikamarbali?’ Ar anmarse ibmar-egisnaidbi ega an sogsamalad. Ar igi anmar wisguosunna, weyob anmarse egisdagoed: ‘Be-urba be anga sedamaloye.’ Anmar wissurdo. ");
INSERT INTO cuk_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judá e-bab-Israelʼga sogded: —Ar anmar ukudba burgwebisurmalale, Benjamín be anmarba barmiddo. Ani, an bega dakoed. Eyeye be sogele, anmar yog-naar imakoed. Ar deyob be imakele, geb anmar, be, degi, anmar-mimmigan burgosurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Be-machi-an-sedoedi, angi siido. Ar machigwa igi-gusdibe, an-nukindo. Ar wese gannar an bega senonisulile, an-burgwedse angi ataklegodo. ");
INSERT INTO cuk_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Weyob anmar yoggunaisulina, ¡bato ilabogus anmar Egipto-yarse arbi-wilubbinad! ");
INSERT INTO cuk_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Geb degine, e-bab-Israel Judá-abin sogded: —Ar geg an oakalosoggu, ar weyob bemar imakmarsundo. Be-sagu-yaba macheredga binsa ibmar-ukega be sedmar. Bemar-ibmar-sedoedi, bur-ibmar-nuegan-we-yargi-nikad ega be sedmalo: Sapi-gunnugiid-wawadikmalad, achanis, gwallu-wawadikmalad, ina-wawadikmalad, nur-nuezʼgiimalad, degine, nur-almendroʼmar be sedmalo. ");
INSERT INTO cuk_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Deginbali, mani-ilabo-mergu be sedmarbalo. Ar abakalegi, emar bemarga mani-uksadi wis noar-odosale, a-mani bemar-sunnad ega be gannar ukmalo. ");
INSERT INTO cuk_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","¡Be namar! Be-urba be sedmar. Dummad-mas-dakmaidse gannar be namar. ");
INSERT INTO cuk_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bab-Dummad-Bela-Gangued-Nikad wile be-dakmalana gadin, adi, be-gwenad-galesiid onogegar, degine, Benjamín nabir gannar barmidabaligar. Andi, machimala-sate an gudele, igi an barsaosunna, machimala-sate an guodo. ");
INSERT INTO cuk_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Jacob-machimala Egiptoʼgi-dummadga-maidga ibmar-binsa-ukdapmaloed sesmalad. Mani-ilabo-bur-bule-mergu sesmalad, degi, Benjamín-sesmarbalid. Geb degine, Egipto-yarse nadmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joséʼse modapmargu, José dakded, Benjamín e-iamarba nonimoga. Geb José ega-neg-akwedga sogded: “We-dulemar an-negse be sede. Moli-bebe-nikad-wargwen be oburgo. Mas-sao, ar ade, we-dulemar emi yoruku anba mas gunmaloed.” ");
INSERT INTO cuk_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ar Joséʼga-neg-akwed José-ega-sogsadyob imaksad, e-sunnad José-e-gwenadgan-sesad. ");
INSERT INTO cuk_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Agine, José-e-gwenadgan José-negse selemamaigu, dobe-itonadmalad, sogdemalad: “Iduar anmar-sagu-yaba mani-urbismalad-ular, yamo e-negse anmar-semaid. ”Wese anmar-senonikid, adi, sabsur-anmar-odurdakega, e-maiga anmar-imakega, degine, anmar-moli-uayasuidmar anmar-ibe suegar.” ");
INSERT INTO cuk_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Degisoggu, José-neg-yawagak-mosmargu, Joséʼga-neg-akwedbo-sunmakmalagala ese walikaa nadmalad. ");
INSERT INTO cuk_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Geb Joséʼga-neg-akwedga sogdemalad: —¡Dummad! Iduale, anmar orosgi-dakleged-bakega arbimalad. ");
INSERT INTO cuk_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Gannar anmar nadedgi, neg-gaboedse anmar modapgu, anmar sagu egad-egad-egadmargu, anmar-sagu-yaba, bela-sogedba anmar-mani-senonikid bukwa dakalid. Emigi, a-mani bega-ukega anmar sedanikid. ");
INSERT INTO cuk_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ar anmar wissulid, iduale doa anmar-sagu-yaba mani urbisa. Deginbali, orosgi-dakleged-bakega anmar mani sedanibalid. ");
INSERT INTO cuk_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Joséʼga-neg-akwed abin-sogded: —Mer be bukib-binsamar, mer be dobgumar. Ar bemar-Bab-Dummad, be-bab-e-Bab-Dummad, a bemar-sagu-yaba mani-urbisargebed. Ar ade, bemar-mas-baksad-mani anga uklesad. Joséʼga-neg-akwed Simeón-esgaryagi-mellesiid onosad. Geb degi, e-gwenadgan-bukwadse sesad. ");
INSERT INTO cuk_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Geb degine, Joséʼga-neg-akwed bela negyaba José-e-gwenadgan-odosad. Geb ega dii uksad, adi, na nag enukmalagar. Deginbali, e-moli-uayasuidmarga mas uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","José-e-iamar guakwaa Joséʼga-ibmar-ukmaloed urbismalad. José-yorukudba-nonikoedi edarbesigismalad. Ar ade, wisgusmalad, emarde agi mas gunmaloye. ");
INSERT INTO cuk_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","José e-negse-nonigu, e-iamar ega ibmar-ukega-senonikid ukdemalad, bela José-abin dulluu e-bebe napase ebulegedse imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Geb degine, José egisded: —Bemarde nueganbimar sogeye. José egisdebalid: —Degite, be-babde, be-anga-egi-sunmaksamalad, nue-selebagusye, ¿amba dula gudii? ¿Nued gudii? ");
INSERT INTO cuk_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","José-e-iamar bela napase dulluu José-abin imakdemalad. Geb degine, ega sogdemalad: —Anmar-bab, be-mai, nued gudii. Amba dula gudii. ");
INSERT INTO cuk_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","José bela dulemar-dakdegu, dakalid, e-urba-galagwenad-Benjamín simoga. Geb degine, José sogded: —¿We, bemar-urba-bipigwad bemar anga egi sunmaksamaladi? Geb degine, José, Benjamínʼga sogded: —¡Machi, Bab-Dummad ise-nued begi binsaena gadin! ");
INSERT INTO cuk_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","José weyob sogsagua, e-urba-dakedba bela-bela ulubgi-yeer-itoged, geb bela-bela bobi gualid. Degidbali, José gwae-gwae e-gabedyaba dogsad. Agi, nue-bosii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","José bosiid na bargasgu, e-wagar-enuksagu, noalid. Geb degine, sogded: “¡Mas wemar!” ");
INSERT INTO cuk_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Joséʼga mese-gwagwengi mas ega urbismalad. Jacob-e-masmalagardi baid-mesegi, degine, Egipto-dulemar-eba-mas-gunmaladga baid-mesegi urbismarmogad. Ar ade, Egipto-dulemar Hebreo-dulemarbo geg mas gunned, ega ised-dummad gued. ");
INSERT INTO cuk_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","José e-gwenadganga igar-uksagu, mese-naba e-serguedba sigismalad, dummad-inse, geb bipigwadse. Agala, bela geger-dakmalad, muchub-muchub, nuu-nuu dakbukwa guarmalad. ");
INSERT INTO cuk_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","José e-mesegi-mas-bukwad e-iamarga uksad. Benjamínʼgardi bur bule ilatar-mergu uksad. José, e-gwenadganmala gobsamalad, weligwar itosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Mas-guchamalad-sorbali, José dule-ega-neg-akwedga weyob igar-uksad: “We-dulemar-saguyaba orosgi-dakleged nue-ise-enamakar be balo. Degine, mani egad-egad e-sagu-yaba ega be urbebalo. ");
INSERT INTO cuk_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Deginbali, an-mani-nog e-urba-bipigwad-sagu-yaba be odogo. Degine, orosgi-dakleged-baksad-e-mani agi be odobalo. Nog, mani-ebo walikaa be sio.” Joséʼga-neg-akwed José-ega-sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Geb dad-nakwialiyalaba, José negse e-gwenadgan-barmialid. José-e-gwenadgan e-moli-uayasuid egad-egadgi armalad. ");
INSERT INTO cuk_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","José-e-gwenadgan neggweburgi amba itakasaar-nadapidgine, José ega-neg-akwedga sogded: “We-machergan-naded be bareginna. Be bargasale, ega be sogo: ‘¿Ibiga dule-ibmar-nued-bega-imaksadgi be isdar binsasmala? ¿Ibiga be e-mani-nog atursasmala? ");
INSERT INTO cuk_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","We-mani-nog an-dummad gobega ebuged, degi, Bab-Dummadse-idakega ebubalid. ¡Bemar nue-dummad nosmalad!’ ” ");
INSERT INTO cuk_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Joséʼga-neg-akwed José-e-gwenadgan-bargasgu, bela deyob ega sogdapid. ");
INSERT INTO cuk_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Agi, José-e-gwenadgan abin sogdemalad: —Dummad, ¿ibiga weyob be anmarga soge? ¡Anmar weyob geg ibmar imaked! ");
INSERT INTO cuk_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Anmar-sagu-yaba mani-bukwa anmar dakargusadi, a-mani Canaán-yar-akar anmarde bega ukega gannar sear gusad. Degite, ¿igi anmar be-dummad-neggi, mani, degi, olo atursaosunna? Geg anmar atursaed. ");
INSERT INTO cuk_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","¡Ar doa-saguyaba nog-sii dakledagoe, a-dule oburgwilegodo. Geb degine, anmarmoga bela be-dummad-maiga gumarmogodo! ");
INSERT INTO cuk_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Geb degine, Joséʼga-neg-akwed sogded: —Bemar-sogedyob imaklegodo. Degi-inigwele, unnila ar doa nog-ganiki, abi unnila an-maiga guoed. Ar bemar-baigandi akarsurdo. Na be namalodo. ");
INSERT INTO cuk_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Belagwable na egad-egad yog sagu napase odedmalad, degi, egadmalad. ");
INSERT INTO cuk_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Joséʼga-neg-akwed sagu wargwen-wargwengi nog-amided. Ia-dummadgi onoded, geb bipigwadse warmaksad. Geb Benjamín-sagu-yaba nog sii daklealid. ");
INSERT INTO cuk_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Bela mor esirmakdemalad, oyogega, emarde nunmak-itomarye. Geb a-sorbali, e-sagu moli-uayasuid-birgi-onakwismargu, bela gannar neggweburse armalad. ");
INSERT INTO cuk_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judá, degi, e-gwenadgan José-negse-nonimargu, amba José e-neggi-sii daknonimalad. Geb degine, bela José-asabin dulluu e-bebe napase ebulegedse imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ar Joséʼdi amarga sogded: —¿Ar igi be anga gudmala? ¿Ar bemar wissurmarsi, dule-anyobidi Bab-Dummadse-idakedba sunna ibmar wisgued? ");
INSERT INTO cuk_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judá abin-sogded: —¿Ar igi anmar be-abin-imakosunna? ¿Ar igi anmar sogosunna, anmar deyob ibmar imaksasurye? Ar Bab-Dummadde anmar-daksad, anmar nue-dummad nosad. Degisoggu, wegi anmar, degi, dule-sagu-yaba be-nog-amilesad, be-maiga gumarsunnodo. ");
INSERT INTO cuk_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ar José abin-sogded: —Suli, deyob geg gue. Unnila doa-sagu-yaba an-nog amilesa, abi an-maiga guoed. Baigandi sunna be-bab-negse gannar baisur-itogedgi namalad. ");
INSERT INTO cuk_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Geb degine, Judá Joséʼse naded, ega sogded: —Dummad, bese wilesakwaa an egised, begarbi an sogbied. Dummad, ar be Faraón-sunnadyobmosoggu, mer be anse urwo. ");
INSERT INTO cuk_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Be anmarse egichisgusad, anmarde bab-nikamar-sogeye, degi, be urba-baid-nikamarbar-sogeye. ");
INSERT INTO cuk_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Anmar be-abin-imaksagusad, anmar-bab selebagusye. Anmar urba-bipigwad nikabarye. We-machi anmar-bab selebagusadgine nikusye. Degine, anmar bega sogsabalid, anmar-bab bela-bela we-machigwa-sabye. Ar ade, unnila nan-wargwengi webi-walagwenad, e-ia-nan-galagwenad burgwisad. ");
INSERT INTO cuk_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","”Geb degine, be anmarga sogsagusad: ‘Be-urba be anga sedamaloye,’ ar ade, be dakbigusad. ");
INSERT INTO cuk_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Anmar bega sogsagusad: ‘Dummad, machigwa geg e-babgi banguye. Ar e-babgi bangudele, e-bab burgwisarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ar bede anmarga sogsagusad: ‘Machigwa bemarba danisulile, an bemar-abingaosurye.’ ");
INSERT INTO cuk_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","”Anmar gannar anmar-babse warmakdapgu, be-anmarga-sogsadi, bela anmar ega sogdapid. ");
INSERT INTO cuk_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","”Geb degine, anmar-bab anmarga weyob igar-uksad: ‘Gannar bemar Egiptoʼse orosgi-dakleged wis baknamarbarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ar anmardi abin-imaksad: ‘Anmar-urba anmarba nasulir, anmar geg naye. Ar anmarba nasulir, dule-dummad-mas-uked anmar-abindakosurye.’ ");
INSERT INTO cuk_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","”Anmar-bab anmarga sogsagusad: ‘An-ome-Raquelʼbo an masmala-warbo-nikusad be wismarye. ");
INSERT INTO cuk_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","A-wargwenadi angi bangusad-akar bar an gwen dakdisurye. Ibmar-durgan-sapurbalid an-machi-ichimaksad an bensurye. ");
INSERT INTO cuk_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ar an-machi-baid bemar angi sedbalile, igarba-akar-gunonikile, bemarginye. An dule-selebagusad, bukib-binsaedba-burgwider, bemarginbarye.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Judá Joséʼga sogdebalid: —Ar an-bab we-machigwa-ebo bela-bela walikasoggu, anmarba gannar nasulile, ");
INSERT INTO cuk_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","sate dakalile, anmar-bab burgoed. Degisoggu, anmar-bab-selebagusad, bukib-binsaedba burgwider, anmargindo. ");
INSERT INTO cuk_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","An-babga an sogsad: ‘Ani an bega machigwa nue-dakoye.’ Deginbali, an ega sogsabalid: ‘Machigwa gannar an bega senonisulile, an-burgwedse angi atakledii guoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","”A-ulale, wilesakwaa an bese egised, ani an machigwa-anar be-maigaguega be an-imaksundo. Machigwa e-iamarba-naega be imake. ");
INSERT INTO cuk_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ar degisulile, ¿igi an machigwasuli gannar an-babse an naosunna? An-bab nue-dummad-wilegoed an dakbisulid.” ");
INSERT INTO cuk_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","José bela-dulemar-ega-arbamalad-asabin geg na san bargagussoggu, binnasur goted: “¡Bela bemar-wegi-bukmalad ainimar!” A-ulale, Joséʼga-arbamalad ainidmalad, wargwensaale bukwa gussulid. Agine, José e-gwenadganga sogsad, ede doawa. ");
INSERT INTO cuk_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Geb degine, José binnasur boded. Degisoggu, bela Egipto-dulemar itosmalad, degi, Faraón-negginmaladse-bakar neg-gunaid wisgusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","José, e-gwenadganga sogded: —Ani, an José. ¿An-bab amba dula? E-gwenadgan José-asabin-bukwadi, bela-bela dobe-itomarsoggu, geg abinsagusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ar Joséʼdi e-gwenadganga sogded: —Wis be anse walikaa dagmala. José-e-gwenadgan José-walik-gunonimargu, José ega sogded: —Ani an be-urba-José gued. Epenne bemar Egipto-dulega an-uksa gusmaladid. ");
INSERT INTO cuk_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","”Degi-inigwele, ar be an-uksamaladba, mer bemar surbinsa-itomalo, mer sae be dukin itomarbalo. Ar ade, Bab-Dummad bemar-idu dulemar-baigan-bendakega an-barmialid, adi, melle ukudba burgwemalagar. ");
INSERT INTO cuk_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Emide, we-yargi ukud-naid-akar birgabogusad. Amba birgatar napid. Ar dulemar ibmar-digmaloen-inigwele, ibmar-weosurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Degi-inigwele, we-napneggi bemar mer berguega, Bab-Dummad bemar-idu an-barmialid, adi, bemar mer ukudba burgwegar. Degine, Bab-Dummad ibmar-gegerdaklegedgi bemar-bendakega, degi, be-mimmigan-nue-bendakega, an-imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","”Degisoggu, Bab-Dummad wese an-barmialid, bemar an-barmiarsulid. Bab-Dummad Faraónʼga binsaed-dakedgaguega an-onugsasad. Bela Faraón-negdakega, degine, bela Egipto-yargi negdaked-dummadga-megega an-onugsasbalid. ");
INSERT INTO cuk_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Gwae an-babse gannar be namar. Ega be sognamar: ‘Be-machi-José sogye: Bab-Dummad bela Egipto-yar-dakega an-onugsasye. Gwae be an-dakdagoye, mer be yogguoye. ");
INSERT INTO cuk_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gosén-yalaganba be-mimmigan-abargi, be-wagan-abargi, bela be-ibmar-durgan-abargi, degi, bela be-ibmar-nikad-abargi be megoye. Deyobi, be an-walikaa megoye. ");
INSERT INTO cuk_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ar ade, amba birgatar ukud-dummad naguosoggu, ani, an bega, be-neguyaginmaladga, degi, bela beba-gudidimaladga an mas ukoye, adi, melle ibmar-sate bemar gumalagarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","”An-urba-Benjamín, degi, bemar-sunnagwad an bemarga bela-ibmar-sognaid be nue an-itosmalad. ");
INSERT INTO cuk_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Bela an-babga be sogmalo, ani an Egipto-yargi bela-bela gangued-nika maiye. Degine, bela wegi be ibmar-daksamalad an-babga be sogmarbalo. ¡Gwae be namar! ¡Gwae an-bab be sedamalo!” ");
INSERT INTO cuk_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","José e-urba-Benjamín angaagwar-imakdegu, boded. Benjamín e-ia-Joséʼgi-akas-nai bonai gusmogad. ");
INSERT INTO cuk_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Geb degine, José bela e-iamar-angaagwar-gadgu, ise-boar e-iamar-wagar-unai gusad. Bela bonanai gusmalad. Weyob-gusad-sorba, geb e-iamar Joséʼga nabir sunmakded. ");
INSERT INTO cuk_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Faraón-e-negyagi bela José-e-gwenadgan-nonimarye wisgusmalad. Faraón weligwar itosad, degine, dummagan-ega-arbamalad weligwar itosmarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Geb degine, Faraón Joséʼga sogded: “Be-gwenadganga be sogo: ‘Be-moli-uayasuid-birgi ibmar-nasikye, Canaán-yarse gannar be namarye.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Faraón Joséʼga sogdebalid: “Be-iamarga be sogo: ‘Anga be-bab, degi, be-gwenadgan-Canaánʼgi-bukwad be sedagoye. Egipto-yargi napa-bur-nued an ega ukoye, degine, we-yargi mas-nued gunmaloye.’ ");
INSERT INTO cuk_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","”Deginbali, José, be-gwenadganga be igar-ukbalo: ‘We-Egiptoʼgi urmar-napagined-ibmar-seed sedmarye, adi, be-omegan, be-mimmigan, degi, bemar-bab sedagegarye. Be-gwenadgan-Canaánʼgi-bukwadga be sogmaloye: Be dagmarye. ");
INSERT INTO cuk_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Deginbali, melle ibmar-nikmaladgi binsamaloye, ar ade, Egipto-yargi bur-ibmar-nued-nikadi bemargadga guoeddeeye.’ ” ");
INSERT INTO cuk_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Israel-e-masmala deyob imaksamalad. José, Faraón-ega-sogsadba, e-gwenadganga urmar-napagined-ibmar-seed uksad, degine, igarba mas-gunnega ega mas uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Deginbali, José, mor-binigan e-iamarga uksabalid. Benjamínʼgardi mani-dulataled-ilapaa-aidikue-wilub (300) ega uksad, degine, mor, goatar ega uksabalid. ");
INSERT INTO cuk_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","E-babgardi ibmar-nuegan-Egiptoʼgi-nikad moli-uayasuid-warambe (10) ena-ena barmisad. Degine, e-bab igarba mas-gunnega, moli-uayasuid-omegan-warambe (10), orosgi-dakleged, madumar, degi, masgullemalad, ena-ena barmisbalid. ");
INSERT INTO cuk_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","José nuedgi e-gwenadgan-barmisgu, amarga sogsad: “Melle igarba be urwenadapi gumalo.” Geb degine, e-iamar nadsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","José-e-gwenadgan Egipto-yargi nadsunnad. Canaán-yarse e-bab-maidse modapmalad. ");
INSERT INTO cuk_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Jacobʼga sogdapmargu: “José amba dula-gudiiye, Egipto-yargi dummadga negdakmaiye.” Jacob, e-masmala ega ibmar-sognaid geg itoged, geg ibmar-soge naded. Ar ade, e-masmala-bened. ");
INSERT INTO cuk_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ar e-masmala José-ibmar-sogsad bela Jacobʼga sogsamalad. Jacob dakdebalid, Egiptoʼse e-sedega urmar-napagined-ibmar-seed José ega barmiali, Jacob bela-bela yeer itonaded. ");
INSERT INTO cuk_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Geb degine, Jacob sogded: “¡Emigindi, an nue bensurdo, an-machi-José amba dula-gudiid! Burgwed-idu an daknaoed.” ");
INSERT INTO cuk_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israel Egipto-yarse nadegusad, bela ibmar-nikad sesa gusad. Israelʼde Jacobʼye nugbalid. Beerseba-neggweburse mosgu, e-bab-Isaac-e-Bab-Dummadga ibmar-ogumakar uksad. We-Bab-Dummadde e-bab-Isaac-e-Bab-Dummadmogad. ");
INSERT INTO cuk_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","A-mutikidba Bab-Dummad Israelʼga gabdakedba sunmaksad. Jacobʼse e-nugba gornonikid: —¡Jacob! Jacob Bab-Dummad-abin sogded: —Wegi an be-itomai. ");
INSERT INTO cuk_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Geb degi, Bab-Dummad sogded: —Ani, an Bab-Dummadid, be-bab-e-Bab-Dummadmogad. Egipto-yarse-be-naed mer dobguo, ar ade, agi be-wagan bukidar-merguega an imakoed. ");
INSERT INTO cuk_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ani, an beba Egiptoʼse naoed, degi, an-sunnad gannar we-yarse-dagega an be-imakoed. Deginbali, be burgwiar-sogele, José be-dikarba-gwichi guoed. ");
INSERT INTO cuk_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Geb a-sorbali, Jacob, Beersebaʼgi-maid naded. Israel-machimala, Faraón-urmar-napagined-ibmar-seed-barmialidgi, e-bab, e-bab-e-omegan, degi, e-mimmigan-onakwis sesmalad. ");
INSERT INTO cuk_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jacob, degi, e-gwenadgan, bela Egipto-yarse nadmalad. We-ibmar sesmalad: E-molimar-bebe-nikad, e-sibad-wawaadmar, degi, bela Canaán-yargi ibmar-nikad sesad. ");
INSERT INTO cuk_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Bela wemar Jacobʼba Egipto-yarse nade gusmalad: E-masmala, e-sisgan, degi, e-wagan. ");
INSERT INTO cuk_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jacobʼde Israelʼye nugbalid. Israel-masmala Egipto-yarse-nadegusmalad-e-nugmar, wemalad: Rubén, Jacob-machi-gebesailagined. ");
INSERT INTO cuk_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubén-e-masmaladi, wemalad: Hanoc, Falú, Hezrón, Carmi. ");
INSERT INTO cuk_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeón, Rubén-yarbalidid. E-masmaladi, wemarmogad: Jemuel, Jamín, Ohad, Jaquín, Zohar, Saúl. Saúl-e-nande Canaán-dolad. ");
INSERT INTO cuk_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leví, Simeón-yarbalidid. E-masmaladi, wemarmogad: Gersón, Coat, Merari. ");
INSERT INTO cuk_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judá, Leví-yarbalidid. E-masmaladi, wemarmogad: Er, Onán, Sela, Fares, Zara. Ar Erʼdi, Onán-ebogwa Canaán-yargi burgwismalad. Fares-e-masmaladi, wemarmogad: Hezrón, Hamul. ");
INSERT INTO cuk_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacar, Leví-yarbalidid. E-masmaladi, wemarmogad: Tola, Fúa, Job, Simrón. ");
INSERT INTO cuk_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulón, Isacar-yarbalidid. E-masmaladi, wemarmogad: Sered, Elón, Jahleel. ");
INSERT INTO cuk_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Jacob, we-masmala Padan-Aram-neggweburgi Leaʼbo baksa gusad. Agi, e-bunagwa-Dina baksabalid. Bela-e-wagan: Omegan, degi, macherganse-bakar, dulagwen-gakambe-gakapaa-mergu (33) gusad. ");
INSERT INTO cuk_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Jacob masmala-Zilpaʼbo-baksad, wemalad: Gwensak, Gadʼye nugad. E-masmaladi, wemalad: Zifión, Hagui, Ezbón, Suni, Eri, Arodi, Areli. ");
INSERT INTO cuk_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Baiddi, Aserʼye nugad. E-masmaladi, wemarmogad: Imna, Isúa, Isúi, Bería. Degine, amar-e-bundi Seraʼye nugad. Bería-e-masmaladi, wemarmogad: Heber, Malquiel. ");
INSERT INTO cuk_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","We-masmala-ebogwad, Zilpa Jacobʼbo baksad. Zilpaʼde Labán-e-mai guenad. Labán na e-sisgwa-Leaʼga Zilpa-uksa gusad. Bela Zilpa-masmala e-mimmiganse-bakale, warambe-gakanergwa-mergu (16) gusad. ");
INSERT INTO cuk_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Raquel Jacobʼbo-baksaddi, wemalad: José, Benjamín. ");
INSERT INTO cuk_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José Egipto-yargi Asenatʼbo-masmala-baksadi, wemalad: Manasés, Efraín. Asenatʼde, Potifera-e-sisgwad. Potiferaʼde, On-neggweburgi dule-irwa-e-bab-dummadse-goledid. ");
INSERT INTO cuk_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamín-e-masmaladi, wemarmogad: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim, degi, Ard. ");
INSERT INTO cuk_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Wemala, Raquel, degi, Jacob-wagan-gumalad. Bela warambe-gakabake-mergu (14) gusad. ");
INSERT INTO cuk_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Jacob masmala-Bilhaʼbo-baksad, wemalad: Gwensak, Danʼye nugad. E-machidi, wedid: Husim. ");
INSERT INTO cuk_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Baiddi, Neftalíʼye nugad. E-masmaladi, wemalad: Jahzeel, Guni, Jezer, degi, Silem. ");
INSERT INTO cuk_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","We-masmala-ebogwad, Bilha Jacobʼbo baksad. Bilhaʼde Labán-e-mai guenad. Labán e-sisgwa-Raquelʼga Bilha-uksa gusad. Bela Bilha-masmala e-mimmiganse-bakale, walagugle-mergu (7) gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Dulemar-ablis-galagwenmalad Jacobʼba Egipto-yarse nonimaladi, bela dulapaa-gakanergwa (66) mergued. E-masmala-e-omegandi gwen obarilesulid. ");
INSERT INTO cuk_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José-e-masmala Egipto-yargi warbo gwalulesmalad. Degisoggu, Jacob, e-masmala, degi, e-waganse-bakale, bela dulapaa-gakambe (70) Egipto-yargi megidapmarsundo. ");
INSERT INTO cuk_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob e-idu José-daknaega Judá-barmisad, adi, José Gosén-yalaganse e-abindakdagegar. Jacob, degi, eba-danimalad Gosén-yarse nonimarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Geb degi, José e-bab-abindaknaega igar-ukded, ega guakwaa ur-napagined nasikye. José Gosén-yargi e-bab-abinguargua, angaagwar e-bab-gasad. E-bab-gukingi undar bonai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Geb degine, Israel Joséʼga sogded: —An gannar be-daksadba, degine, amba-dula an be-daknonikidba, emigindi, ¡an burgwer, akarsulid! ");
INSERT INTO cuk_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","José e-iamarga, degi, e-bab-neguyaginmaladga sogded: —An Faraón-owisogega, Faraón-daknagwelo. An ega sogdapoed: ‘An-iamar, degi, an-bab-e-wagan Canaán-yalagi-mamaiye, wese Egipto-yargi-megega anse nonimarye. ");
INSERT INTO cuk_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Amarde, sibad-wawaad-akwedgi, degi, moli-bebe-nikmalad-akwedgi arbamarye. Na e-sibad-wawaadmar, e-moli-bebe-nikmalad, degi, bela e-ibmarmar-nikamalad senonimarye.’ ");
INSERT INTO cuk_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Faraón bemarse gollalir, degine, bemarse egichialir, ibigi bemar arbamarye, ");
INSERT INTO cuk_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","bemar abin-sogoed, bemarde gusgu be-dadganyobi sibad-wawaad-akwedgi arbamarye. Deyob be sogele, adi, nabir bemar Gosén-yalaganba megmaloed, ar ade, Egipto-dulemarga igar maisulid, dule-sibad-wawaad-akwemalad-ebo megmalad. ");
INSERT INTO cuk_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","José, Faraón-owisonaded, ega sogdapid: —An-bab, degine, an-iamar-Canaán-yargi-mamaid, emi bato Gosén-yarse nonimalad, bela ibmar-nikad, sibad-wawaadmar, degi, moli-bebe-nikmalad senonimarbalid. ");
INSERT INTO cuk_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","José, Faraónʼse e-iamar-walatar sesad, adi, Faraón amar-mag-dake guegar. ");
INSERT INTO cuk_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Geb degine, Faraón José-e-iamarse egichialid: —¿Ibigi bemar arbamala? Amar abin-imakdemalad: —Dummad, anmar-be-maigan-gumaladi, anmar-dadganyob anmar sibad-wawaad-edarbemalad gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Anmar we-yarse megega nonikid, ar ade, Canaán-yalagi ukud yaisulid, anmar-sibad-wawaad gagan-maed sate gualid. Degisoggu, Dummad, Gosén-yargi-megega wis be anmar-imake. ");
INSERT INTO cuk_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Geb degine, Faraón, Joséʼga sogded: —José, be-bab-nonikidi, be-iamar-nonikidi, be-walik-megega nonimalad. ");
INSERT INTO cuk_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egipto-yala bega guakwaa naid. Be-gwenadgan-megega Gosén-yar ega be uke, ar ade, a-napa, napa-baiganba bur nuedid. Ar be-gwenadgan-abargi machergan-nue-yeer-ibmar-durgan-akwemalad-nikadibe, amar an-ibmar-durgan-akwega be onugsaodo. ");
INSERT INTO cuk_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","José, Faraónʼse e-bab-sesa gusbalid, adi, Faraón Jacob-mag-dake guegar. Jacob, Faraón-argan-gadgua, ise-nued-egi-binsaedgi ega sogsad, be undarsaar megena gadinye. ");
INSERT INTO cuk_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Geb Faraón Jacobʼse egichialid: —¿Birgabigwa be nika? ");
INSERT INTO cuk_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob Faraón-abin sogded: —Birga-dulanergwa-gakambegus (130), we-napneggi an bipirmakdiid. Doggus ibagan-nuegan an daksasurgusad. Ibagan-isganagi bur bule an gudii gusad. An-dadgan-sergu-megisadyob yoo an ese warmaked. ");
INSERT INTO cuk_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Geb a-sorbali, Jacob Faraónʼga sogded, degimaloye. Geb Jacob noded. ");
INSERT INTO cuk_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Degidgine, Joséʼdi, e-bab-Jacob, degi, e-iamar, Egipto-yargi-megega imaksad. Geb degine, José Faraón-ega-igar-uksadba, Ramesés-yargi, e-babga, degi, e-gwenadganga, nainumar-bur-nued uksad. ");
INSERT INTO cuk_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Deginbali, José e-gwenadgan-mas-abegedba, bela e-gwenadganga mas-ukmai gusad. ");
INSERT INTO cuk_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Bela neggweburmargi bur bule ukud nasgumaid. Abali, mas sategusad. Egiptoʼgi, degi, Canaán-yargi ukudba dulemar burgwemamaid. ");
INSERT INTO cuk_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Egiptoʼginmalad, degi, Canaánʼginmalad orosgi-dakleged Joséʼse-bakega bela e-mani ebusmalad. A-mani, José, Faraón-neggi bela sabosad. ");
INSERT INTO cuk_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Egiptoʼgi, degi, Canaán-yargi mani-sategussoggu, Egipto-dulemar Joséʼga sognadmalad: —¡Be anmarga masgunned udage! Mani-satedba, ukudba be anmar-oburgwer, igar maisulid, wedi noaled. ");
INSERT INTO cuk_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","José dulemar-abin sogded: —Ar bemar mani bergusale, be-ibmar-durgan be sedamalo. A-muchub, an bemarga orosgi-dakleged ukoed. ");
INSERT INTO cuk_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Egipto-dulemar Joséʼse we-ibmar-durgan senonimalad: Molimar, sibad-wawaadmar, sibadmar, moli-bebe-nikamalad, degi, moli-uayasuidmar senonimalad. A-birgagi, José, a-muchub ega orosgi-dakleged uksad. ");
INSERT INTO cuk_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","A-birga-bergusgua, birga-baid nagunonikid. Geb Egipto-dulemar Joséʼga sognonimalad: —Dummad, anmar mani-satedi, geg anmar begi odukued. Deginbali, anmar-ibdurgan bela begadga gusbalid. Anmar mas-bakega, ibmar-baigan-bega-uked sated. Degisoggu, anmar-nainu, degi, anmar begadga gumalargebed. ");
INSERT INTO cuk_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Be anmar-nainu baksundo, be anmar-bakbarsundo, adi, masgi be anmar-ogundii guegar. Anmar Faraón-e-maiga gumaloed, degine, ibmar-gwaggi anmar-nainugi-anmar-arbaoedi, Faraónʼgadga guoed. Mer anmar burgwega, degi, melle napa binsa wilenai-gubaliga, be anmarga ibmar-gwag udado. ¿Ar ibiga burgwega be anmar-imakoe? ¿Ibiga binsa nainu wilenai-guega be imakbaloe? Melle deyob be imake. ");
INSERT INTO cuk_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Geb degine, José Egipto-yargi Faraónʼga bela nainu baksad, ar ade, Egipto-dulemala ukudba na e-nainu ukdemalad. Weyobi Faraónʼgadga nainumar gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Degisoggu, Egipto-dulemala bela Egipto-yargi Faraón-maiga gunonimarsundo. ");
INSERT INTO cuk_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","José unnilagwa Egipto-dule-irwa-bab-dummaganse-gormalad-e-nainubi baksasulid, ar ade, Faraón amarga orosgi-dakleged ukdaed. Degisoggu, amardi e-nainu uksasurmalad. ");
INSERT INTO cuk_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Geb degine, José dulemarga sogded: —Emigindi, be-nainumar, degi, bemar, Faraónʼgadga gunonikid. Ar ade, ibmarmar-an-baksadi, Faraónʼga an baksad. Emigindi, an bemarga ibmar-gwag digmalaga an uked. ");
INSERT INTO cuk_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Bemar ibmar-weemaloedi, sagu-walatargi gwensak Faraónʼga be ukmaloed. Sagu-warbakegwaddi, be digega ebumaloed. Adi bemar, be-mimmigan, degi, bela dulemar-beba-gudidimalad a-ibmar gunmalagar. ");
INSERT INTO cuk_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Dulemar José-abin sogdemalad: —Be nued anmargi daed. Nue be anmar-bendaksad. Degisulina, anmar burgoenad. ¡Anmar Faraón-maiga gumalodo! ");
INSERT INTO cuk_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Weyobi José igar-mesnonikid, bela Egipto-yalagi ibmar-durbagan-welegedi, sagu-atargi gwensak Faraónʼga ukoye. José weyob igar-mesisadi, amba we-garda-narmaklenaidse, deyob, we-igar maid. Ar Egipto-dule-irwa-bab-dummadyob-imakdimaladse-gormaladdi bennuksurmalad, ar ade, e-nainumala Faraónʼgadga gussurgusad. ");
INSERT INTO cuk_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israel-dulemala Egipto-yargi-yoggunonimaladi, Gosén-yargi megnonimalad. Agi, nainumar na nikudmalad, dula-ichesur-mergu gudmalad. ");
INSERT INTO cuk_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob birgambe-gakagugle (17) Egipto-yargi megisad. Jacob birga-dulagugle-gakagugle (147) gudii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ibagwengine, Israel e-burgwed warmaksa itoalid. A-ulale, e-machi-Joséʼse gochad, ega sogded: —Ar ibmar-nued be anga nue-imakbiele, be-argan an-dua-urba be mese. Weyobi be anga oyogoed, an bese ibmar-egisoed, be anga imakedseye. Degisoggu, an bese egised, melle Egipto-yargi be an-mui-digo. ");
INSERT INTO cuk_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","An-babganyob an burgwenonimogale, Egipto-yargi be an-mui sedo. Bia an-babgan-muimar digar mamai, agi be an-mui digmogo. José e-bab-abin sogded: —An deyob imakodo. ");
INSERT INTO cuk_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","E-bab Joséʼgi alamaknai gusad: —¡Ise-sogar be anga soge, deyob an imakoye! José ise-sogar abin-sogded: —Eye, deyob an imakoe. Geb degine, Israel e-gabed-nono-onakwedsik, e-nono yollee imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Iche-naded-sorbali, Joséʼga sokarmalad, be-bab uellemaiye. Geb degine, José e-bab-daknaded. José, e-masmala-warbogwad, Manasés, degi, Efraín, eba sesa gusad. ");
INSERT INTO cuk_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jacob-owisosmargu, be-machi-José be-dakdaniye, Jacob na gandik imaksad, degi, e-gabedgi sigisad. ");
INSERT INTO cuk_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Geb degine, Jacob Joséʼga sogded: —Bab-Dummad-Bela-Gangued-Nikad, Canaán-yargi, Luz-neggweburgi, anse magaros gusad. Agi, angi ise-nued-binsaedgi anga sogsa gusad: ");
INSERT INTO cuk_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘Nue be an-itoye, mimmigan-bukidar-nikuega an be-imakoye. Degine, begi dulemar-bukidar-galagwensuli-ainiega an imakoye. Deginbali, be-waganga we-yala an ukoye. We-yalade be-wagangadga degisadegu guoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","”Nabir, be-machi-Efraín, degi, be-machi-Manasés, an bese we-Egipto-yarse-nonikid-iduar, we-yargi gwalulesmalad. We-masmalade angadid. Igi Rubén, degi, Simeón an-masmala-sunnadi, wemarde deyob gunonimarmogad. ");
INSERT INTO cuk_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","We-masmala-warbogwad-sorba be mimmigan-nikuoedi, adi, begadga guoed. Amardi Efraín, degi, Manasés-e-urbamarsoggu, e-iamarba ibmar nikumarmogoed. ");
INSERT INTO cuk_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","An Padan-Aramʼgi danigua, Canaán-yargi be-nan-Raquel Efrata-neggweburse-warmakdanikidgi angi burgwisad. A-igarba an e-mui digsad. Emigindi, Efrata-neggweburde Belénʼye nugad.” ");
INSERT INTO cuk_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel ukiar José-e-masmala-dakargu, egichided: —Wemardina, ¿we doamala? ");
INSERT INTO cuk_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","José e-bab-abin sogded: —We-masmala, Bab-Dummad anga we-Egipto-yargi uksadid. Geb degine, e-bab Joséʼga sogded: —Be-masmala wis gatik anse walikaa be nidage, adi, ise-nued-an-egi-binsaedgi ibmar ega sogegar. ");
INSERT INTO cuk_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel bato nue selebagusad, nue-aku atakgusad. Bar nue-ataksursoggu, José e-masmala e-babse walikaa sesad. Israel masmala-angaagwar-gasgua, ei wagar usad. ");
INSERT INTO cuk_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Geb degine, Israel Joséʼga sogded: —Bar-be-dakosurye an bienad. Degi-inigwele, Bab-Dummad be-masmala-dakega an-imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","José e-masmala e-bab-Israel-yokor-imbaba-gwichidi onosad. Geb degine, José e-bab-asabin e-bebe napase-warmakedse imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Geb degine, José e-masmala-warbogwad e-argangi gasad, Efraín, e-argan-nuedsik, degi, Manasés, e-argan-sapiledsik gasad. Geb agine, gannar e-bab-Israelʼse walikaa sesad. Agala, Efraín Israel-argan-sapiledsik gwisgusad, degi, Manasésʼdi Israel-argan-nuedsik gwisgusmogad. ");
INSERT INTO cuk_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israel, e-argan masmalagi-mesidgu, e-argan muchub biir imaksad. Degisoggu, Israel e-argan-nued machi-bipigwad-Efraín-nonogi mesisad. Manasés-bur-dummad-inigwele, Israel e-argan-sapileddi, Manasés-nonogi mesisad. ");
INSERT INTO cuk_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Geb degine, Jacob Joséʼgi ise-nued-binsaedgi ega sogded: “Bab-Dummad-sogedba, an-dad-Abraham, degi, an-bab-Isaac, nanadii gusad. A-Bab-Dummad, an gwalulesad-akar an-edarbediguad. ");
INSERT INTO cuk_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Bab-Dummad-e-baliwitur bela bonigangi an-bendakdii gusad. A-baliwitur we-masmalagi ise-nued binsasun. We-masmalaba an-nug ebinsaledii gusun. Degine, Abraham-e-nug, degi, Isaac-e-nug ebinsaledii wemarba gumarsun. Wemala mimmigan-ichesuli nikumarsunno, degine, we-napneggi bemar dula-ichesur-mergu gumarsun.” ");
INSERT INTO cuk_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ar Joséʼdi, e-bab Efraín-nonogi e-argan-nued-mesisadi, gwen nabir daksursoggu, José e-bab-argan-nued gasad, Efraín-nonogi-maidgi onirisad. Geb José e-bab-argan-nued Manasés-nonogi mesnaigu, e-babga sognaid: ");
INSERT INTO cuk_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","—¡Baba, suli, weyobsuli! We, bur-dummadid. Be-argan-nued we-nonogi be mese. ");
INSERT INTO cuk_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ar e-bab-Jacobʼdi yapa deyob imakgusad. Geb José-abin sogded: —¡Machi, bato an wisi! Ar Manasés amba dule-nue-nug-nikadga gumogoed. Degi-inigwele, e-urba-Efraínʼdi bur bule nug-nika guoed, degi, e-wagangi dulamar-bukidar akar-akar ainidagoed. ");
INSERT INTO cuk_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","A-ibagi, Jacob we-masmalagi ise-nued-binsaedgi ega sogded: “Israel-dulemar dulemargi ise-nued-binsadmalale, bemar-nug obarmaloed. Weyob sogmaloed: ‘Bab-Dummad, igi Efraín, degi, Manasés-imaksa, deyob bemar-imakmosun.’ ” Weyobi Israel, Efraín bur Manasésʼba nug-dummarba imaksad. ");
INSERT INTO cuk_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Geb degine, Israel Joséʼga sogded: —Nue be itogo. An burgoed. Ar degi-inigwele, Bab-Dummad bemarba gudii guoed. Bab-Dummad bemar-dadgan-yarse gannar bemar-sedoed. ");
INSERT INTO cuk_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Be-gwenadganba an bega bur bule ibmar uked. An bega Siquem-yala uked. We-Siquem-yarde Amorreo-dulemargi an bila-onosgu, an-egi-nakwisadba an ei susad. ");
INSERT INTO cuk_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob e-machimalase gochad. Ese nonimargu, ega sogded: “Anse walikaa be dagmar. An bega sogoed, igi bemar yoedse guoe. ");
INSERT INTO cuk_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Masmala, be an-itomalagala, anse be dagmar, be-bab-Israel be nue itodamar. ");
INSERT INTO cuk_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","”Rubén, be an-machi-sailaginedid, be an-ganguedid, be-inse an-san-burbagi danikidid. Be-inse bur nug-dummarba-nika guedid, be-inse bur gangued-nika guedid. ");
INSERT INTO cuk_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ar ade, be diwar-nomaidyob gued, geg be galeged. Ar an-omese be gornonigu, an-gabedgi be dodosad. A-ulale, bur dummadga bar be guosulid. ");
INSERT INTO cuk_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","”Simeón, Leví, gwenadgan gumalad. Es-suidmargi dulemar-sabsur-imakdamalad. ");
INSERT INTO cuk_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","E-onmakbukwadse, gwen an dogbisulid. E-igar-itobukmalad-abargi, gwen an sigbisulid. Ar ade, sae-itodmargu, dulemar-oburgwismalad. Yogasaar moli-bebe-nikad-e-dua-dub-wardummad siksamalad. ");
INSERT INTO cuk_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Be-doggus-urwed bela-bela isdar-itolegega gusun. Degine, be-sabsur-ibmar-imaked, bela-bela isdar-daklegega gusun. Jacob-yalaganba an bemar-oaisakioed, Israel-neggweburmargi bela aisakiega an bemar-imakoed. ");
INSERT INTO cuk_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","”Judá, be-gwenadgan be-nug odummomaloed. Be-gwenadgan be-abin dulluu e-bebe napase ebulegedse imakmaloed. Be-isdarmaladgi be obindii guoed. ");
INSERT INTO cuk_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judá, be achumigur-sapingwagwadyob gued, Masgasa-gunnaid bergusale, obunnomegisdaed. ¿Doa ese achaoe? Dule geg ese achaed. ");
INSERT INTO cuk_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Judá-dulemar-abargi dule-negsemaid gwen surguosulid, degine, gaapoled-e-ibed danikidse e-gaapoled-ganikid egi suosurmarbalid. Ar ade, dulemar-yar-baid-baidgi-bukmalad e-rey-Siloh-nonikoed, a-rey-sogedba nanamaloed. ");
INSERT INTO cuk_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Judá mani-ibedga gunonikosoggu, uva-bukidar-nikadba e-moli-uayasuid uva-sailagi edinnoed, e-moli-bipi bur uva-e-wardummadgi edinnoed. Degi, Judá vino-obine-nikadba, e-mor vinoʼgi enukoed. ¡Vinoʼgi, e-mordummad enukbaloed! ");
INSERT INTO cuk_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","E-ibya vinoʼba bur gudureged. E-nugarmar moli-nunisba bur sibudikid. Ar Judá, mani-ibedid. ");
INSERT INTO cuk_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","”Zabulón, demar-gakagi megoed. Agi, urmar-nagued-neg nika guoed. E-ambikuoed, Sidón-yalase warmakoed. ");
INSERT INTO cuk_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","”Isacar, moli-uayasuid-dutusulidyob gued. Geg-gwisgue e-neg-yagi sagumar-imbagi obunnomaid. ");
INSERT INTO cuk_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Isacar, obunnogega, yar-nued-dakargua, degi, yeerdaklege dakargua, ibmar-berbegega na san imaksad, emar-maiga gunonikid. ");
INSERT INTO cuk_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","”Dan, Israel-masmala-ambe-gakabogwad-baiganyobmogad (12). Dan, e-sordamarga igar-nudakedga guoed. ");
INSERT INTO cuk_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan, naibe-buled igargi-maidyob guoed, a-naibe moli-maligi warmaksale, dule-moli-birgi-siid argwatedaed.” ");
INSERT INTO cuk_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Jacob sogdebalid: “¡Bab-Jehováʼye, bela-bela be an-abonoged, an-edarbediid!” ");
INSERT INTO cuk_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Geb degine, Jacob e-masmalaga sogdebalid: “Gadʼgi sordamar-urwemalad bukidar gwisgunonimaloed. Degi-inigwele, Gadʼdi, a-sordamar-baregitoed. ");
INSERT INTO cuk_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","”Aser mas-yaisur-nika guoed. We-masmar reymar-mas-gunnedyob yeer-gulle itomaloed. ");
INSERT INTO cuk_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","”Neftalí, igi goe-ome sapurba e-itolegedba gudidae, degi, e-mimmigan yeerdakle nikabali, deyob gued. ");
INSERT INTO cuk_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","”José, dian-dikarba sapi-gwichiyob gued, sapi-yaisur-sanmakedyobid, e-anagan galu-birgi obakmamaid. ");
INSERT INTO cuk_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Joséʼga nunmaked-dummad uksamalad, sigu-mimalad isdar be-dakmaladba begi sigu mismalad. ");
INSERT INTO cuk_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Degi-inigwele, bedi sikirmaksasulid, be-garganguedba be-warsi be gachii ganigwichi gusad. ¡Jacob-e-Bab-Dummad-Gandik-Maid, dog-nuedye an bega soged! Bedi sibad-wawaad-edarbedyob emar-idumaid, bedi, akwasaila-dule-odukuedyob gued, be Israel-bendakedid. ");
INSERT INTO cuk_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","¡Ar ade, be-bab-e-Bab-Dummad be-bendakoed! Bab-Dummad-Bela-Gangued-Nikad, ise-nued begi binsaoed. ¡Nibneggi ise-nued begi binsaoed! ¡Demar-uluba ise-nued begi binsaoed! Bemala, ichesur mimmigan-nika gumaloed, degi, be-mimmigan masgi be-omadii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","An-babgan angi ise-nued-binsasadba, be-bab ise-nued bur begi binsanaid. José, we ise-nued begi binsalesadi, yarmar-epenneganagi ibmar-sanmakedba bur nueganad, sapur-epenneganagi ibmar-sanmakedba bur nueganad. José, we-ise-nued-binsaleged, begadid. Ar be-gwenadgan-abargi be sulesad. ");
INSERT INTO cuk_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","”Benjamín, achu-sapur-gadi-urwedyob gued. Wakdar e-masgasad gundaed. Sedodi, e-mas-obichadi, e-sordaganmala gundaed.” ");
INSERT INTO cuk_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Wemala, Israel-dulemar-sogambe-gakabo-ambikusadid (12). Weyob e-bab-Jacob ise-nued-binsaedgi e-masmala-war-wargwenga na emar-guoedgi ega napi sunmaksad. ");
INSERT INTO cuk_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ibagwengi, Jacob weyob e-masmalaga igar uksad: “An-burgwed warmaksad. An burgwisale, Canaán-yalagi, Het-dule-Efrón-nainugi, akwasaila-ollor-siidgi, an-dadgan-dikarba an-mui be digmalo. ");
INSERT INTO cuk_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","A-akwasaila-ollor-siid an bega obared: Mamre-asabin Macpelaʼgi akwasaila-ollor-siid. Deunni, Abraham Het-dule-Efrónʼse nainu-baksagu, we-akwasaila-ollor-siid baksa gusbalid. Adi, agi e-gwenadgan-e-muimar digegar. ");
INSERT INTO cuk_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Agi, Abraham, degi, e-ome-Sara digsamalad. Agi, Isaac, degine, e-ome-Rebeca digsamarbalid. Deginbali, agi, Lea an digsamogad. ");
INSERT INTO cuk_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","We-nainude, degine, akwasaila-ollor-siidde Het-dulese bakles gusad.” ");
INSERT INTO cuk_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jacob weyob e-masmalaga igar-uksad-bergusgu, gannar megided. Geb degine, burgwissunnad. ");
INSERT INTO cuk_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Geb degine, José e-bab-mui angaagwale gasad, geb nue-bonai, napi e-bab-wagar usad. ");
INSERT INTO cuk_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Geb a-sorbali, José nermar-ega-arbamaladga igar-ukded: “E-bab-Israel-e-muigi ina-wawadikmalad eoye, adi, melle e-mui nunguegarye.” Ar nermar deyob imaksamarsunnad. ");
INSERT INTO cuk_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ina-wawadikmalad Jacob-muigi-eogegala iba-dulabo (40) gagasmalad. Ar ade, muigi ina-eomalaga, deyob ibagan abeleged. Egipto-dulemala iba-dulapaa-gakambe (70) Jacobʼba bukib-itobukwa gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Degine, ibagan-bukib-binsaed-bergusad-sorba, José dulemar-Faraón-neggi-gudidimaladga sunmakalid. Ega sogded: —Ar an bemargi nuedile, Faraónʼga wis be anga sognamar: ");
INSERT INTO cuk_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘An-bab burgwedani-maigu, ega ise-sogar an-imakega an-imaksad, ande e-neg-uan-guakwa-sisadgi e-mui-digoye. We-neg-uan Canaán-yalagi siiye. Degisoggu, an begi wileye, an-bab-mui-dignaega be an-imakye. An-bab-mui-digsayalaba gannar an nonikoye.’ ");
INSERT INTO cuk_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Geb degine, Faraón Joséʼga sogsad: —Be nao. Igi be-bab ise-sogar-be-imakega be-imaksa, deyob be be-bab dignao. ");
INSERT INTO cuk_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Geb José e-bab-dignad gusad. Eba bela dule-dummagan-Faraónʼga-arbamalad, Faraón-neggi dule-dummagan-nug-nikamalad, Egipto-yargi dule-dummagan-nug-nikamalad, eba nade gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Deginbali, José-e-negginmalad, José-e-iamar, Jacob-e-negginmaladse-bakar, nade gusmarmogad. Unnila mimmiganbi, degi, ibmar-durganbi Gosén-yargi obesmalad. ");
INSERT INTO cuk_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Deginbali, dulemar-bukidar ur-napaginedgi, degi, dulemar-bukidar moli-birgi-sii eba nade gusmalad. Degisoggu, dulemar-ichesur Joséʼba nade gusmalad. ");
INSERT INTO cuk_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Atadʼye-neg-nugadse, ibmar-gwag-omukued-negse modapmargu, bela nue-bukib itosmalad, degi, nue-dummad bosmalad. Atadʼde, diwar-Jordán-dad-nakwedsik naid. Agi, igar-maidba José e-babba ibagugle (7) bukib-binsadii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Canaán-dulemar-agi-bukmalad, dakdemargu Egipto-dulemar ise-boar-gunanai, sogdemalad: “Egipto-dulemar-ibe dule-dummad burgwis-dakleye.” A-ulale, a-neg bismalad, Abel-Misraimʼye. A sogleged, Egipto-dulemar-bosmalad-nebaye. We-nebade Jordán-diwar-dad-nakwedsik naid. ");
INSERT INTO cuk_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Jacob-e-masmala, ar igi e-bab ese egichisgusa, deyob bela imaksamalad: ");
INSERT INTO cuk_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","E-bab-mui Canaán-yarse sesa gusmalad. Macpela-nainugi akwasaila-ollor-siidgi digsamalad. We-nainude Abraham, Het-dule-Efrónʼse baksa gusad. Adi, agi e-gwenadgan digegar. We-nainude, degine, akwasaila-ollor-siidde Mamre-dad-nakwedsik naid. ");
INSERT INTO cuk_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","José, e-bab-digsad-sorba, e-gwenadganmala, degi, bela eba-gudimalad Egipto-yarse gannar nonimalad. ");
INSERT INTO cuk_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jacob burgwissoggu, José-e-iamar binsadmalad: “Anmar Joséʼgi nue-dododii gusad. A-ulale, abakalegi José isdar anmar-dakalile, buged-mai anmar-imakalile, wede, ¿igi anmar gudoe?” ");
INSERT INTO cuk_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Degidbali, e-iamar Joséʼga weyob gayaburba barmismalad: “Anmar-bab burgwed-idu anmarga weyob sogsad, bega weyob sogoye: ");
INSERT INTO cuk_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Be-iamar-dummad-begi-nosadi, sabsur-be-imaksamaladi, wis be iegoye, begi-nossuliyob be dakoye.’ ”Degisoggu, anmar bese egised, anmar dummad-begi-nosadi, begi nossuliyob be anmar-dake. Ar anmarde be-bab-e-Bab-Dummad-e-mai gumalad.” Ar Joséʼga-gaya-berbedimalad weyob ega sognanaigua, Joséʼdi ise-boar naded. ");
INSERT INTO cuk_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Geb degine, José-e-iamar-sunnad nonimalad, José-abin e-bebe dulluu napase ebulegedse imaksamalad, geb ega sogdemalad: —Anmar nonimalad. Anmar be-mai gumalad. ");
INSERT INTO cuk_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ar Joséʼdi e-iamar-abin sogded: —Mer dobgumar. ¿Ar an Bab-Dummadsi? Suli. E-ibmar-imaked geg an imaked. ");
INSERT INTO cuk_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ar bemar sabsur-an-imaksa-inigwele, emi bemar negdakedi, Bab-Dummaddi dulemar-bukidar-bendakega, mer burgwemalaga, we-ibmar-isgana-gusadi, ibmar-nuedga obinnisad. ");
INSERT INTO cuk_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Degisoggu, mer dobgumar. Ani, an bemarga, degi, be-mimmiganga mas ukoed. Weyob, José e-iamar-dobee-itogedi, baisur-itogega imaksad. Ar ade, José nue-sabedgi e-iamarga sunmaksad. ");
INSERT INTO cuk_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","José, degine, e-bab-e-gwenadgan Egipto-yargi amba maigusmalad. José birga-dulatar-gakambe (110) gudii gusad. ");
INSERT INTO cuk_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","José Efraín-wagan daksad. Degine, e-wagwa-Maquir-e-mimmigan egadga imaksad. Maquirʼde e-machi-Manasés-e-machid. ");
INSERT INTO cuk_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ibagwengine, José e-gwenadganga sogded: “An-burgwed warmaksad. Bab-Dummaddi bemar-bendakdanikoed, we-yargi bemar-onogoed. Bab-Dummad bia Abrahamʼga, Isaacʼga, degi, Jacobʼga yar-ukoye-sogsagusadse bemar-sedoed.” ");
INSERT INTO cuk_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Geb degine, José Israel-dulemar ega ise-sogar-imakega imaksad, anmar bega deyob imakedseye. Geb degine, José ega sogded: “Ar nue-napiragwad, Bab-Dummad bemar-bendaknonikoed. Ar deyob gunonikile, bemar an-garmar wegi be sedmalo.” ");
INSERT INTO cuk_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Geb José Egipto-yargi-maid birga-dulatar-gakambe-nikadgi (110) burgwenonikid. José-e-muigi ina-wawadikmalad eosmalad, adi, melle e-mui nunguegar. Geb degine, mui-e-ulugi Egipto-yargi mesismalad.");
INSERT INTO cuk_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Wemar-Israel-masmala na e-babba Egipto-yarse nonigusmalad: ");
INSERT INTO cuk_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO cuk_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón, Benjamín, ");
INSERT INTO cuk_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad, degi, Aser. ");
INSERT INTO cuk_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jacob-e-gwenadgan bela dulapaa-gakambe-mergu (70), Egiptoʼse nonimalad. Joséʼdi bato Egipto-yargi maid. ");
INSERT INTO cuk_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ibagan-nadedba José, e-gwenadgan, degine, bela na e-unni-sergumaladi burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ar Israel-dulemar mimmigan-ichesur-nikussoggu, yaisur merguded. Degisoggu, dutusur gunonimalad. Egipto-yargi Israel-dulemar bela-bela-mergu ambikunonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Undar birgamar nasad-sorba, Egipto-yargi rey-baid megnonikid. A-rey wissulid, José doa-dule gusa. A-reyde e-dulemarga sogded: ");
INSERT INTO cuk_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Be dakmar, Israel-dulemar anmarba bur melumalad, degine, anmarba bur dutusurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","”Degisoggu, anmar ise-itoar igar-amiergebed, adi, melle bar sordamar ega merguegar. Ar degisulile, anmar bila-onoalile, abakalegi anmar-isdarmaladba-akadele, anmargi aibinnalile, ar degiile, dule-dummaganga gudmaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","A-ulale, Egipto-dulemar dummagan-onugsasmalad, adi, Israel-dulemar arbaed-dutusulidgi oarbamalagar. Egipto-dulemala Faraónʼga-mas-sabogega neggweburmar-sobega Israel-dulemar-imaksad. We-neggweburmarde, Pitónʼye, degine, Ramesésʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ar Egipto-dulemar bur bule Israel-dulemar-sabsur-imakmaidba, aka bur bule Israel-dulemar mergumaid. Degisoggu, Egipto-dulemala bela-bela Israel-dulemar-nue-dobguarmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Egipto-dulemala e-maiga Israel-dulemar bela-bela sabsuli imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Nue wiosmalad, arbaed-dutusulid ega ukdamalad, napsa-obured, degi, napsa-ginnid akwayob-sobega, deginbali, bela sapurba-arbaleged amarga uksabalid. Bela wemargine, Israel-dulemala sabsur imakledamalad. ");
INSERT INTO cuk_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Deginbali, Egipto-e-rey Hebreo-omeganga-sikwigamaladga sunmaksad. A-mukwa-gwensak Sifraʼye nugad, baiddi, Fúaʼye nugad. Amarga Faraón sogded: ");
INSERT INTO cuk_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","—Bemar Hebreo-omeganga sikwigaarmalale, nue be dakmalo, wede machigwadibe, bunolodibe. Machigwale, oburgwemalo. Bunolordina, melle oburgwemalo. ");
INSERT INTO cuk_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Degi-inigwele, mukwamar-sikwigamalad Bab-Dummad-dobe itosmalad. A-ulale, Egipto-rey-ega-sogedba imaksasurmalad, machimala-oburgwissurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Geb degine, Egipto-rey mukwamarse gochad, amarga sogded: —¿Ar ibiga wede bemar machimala-oburgwedasurmala? ");
INSERT INTO cuk_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mukwamar Faraón-abin sogdemalad: —Ar ade, Hebreo-omegan Egipto-omeganyobsulid. Ar Hebreo-omegandi dutusulid, amba yoo anmar ese warmake, bato ugakgusdaed. ");
INSERT INTO cuk_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bab-Dummad mukwamar-sikwigamaladgi nued-binsasad. Israel-dulemardi mergumai, degine, bur bule dutusurgumai gusad. ");
INSERT INTO cuk_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Ar mukwamar-sikwigamalad Bab-Dummad-dobe-itosmarsoggu, Bab-Dummad egi nued-binsasad, bukidar-mimmigan-nikuega imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ar Faraónʼdi na e-dulemarga igar-mesisad: “Hebreo-dule-gwalulesale, machigwadibe, bela diwarse metemalo. Bunolordina, melle oburgwemalo.” ");
INSERT INTO cuk_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Leví-wagwa-wargwen ome-nikusad. E-ome amba Leví-wagwasikidmogad. ");
INSERT INTO cuk_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","A-ome, gurgin-nika gunonikid. Geb degine, susugwa ega uklenonikid. E-nan machi-bipi-yeerdakle-dakargu, nii-walapaa odukusad. ");
INSERT INTO cuk_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ar geg bar-dikasurgus odukugussoggu, sargi-garba susad. Geb a-garba-e-yaa-ollo-ollogwad baryagi enir-enir imaksad. Geb degine, e-nan sargi-garbagi machi-bipi-mesisgu, nargammugiid-diwar-gakaba-bukwad-imbaba nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","E-bun bannabaa gwisgusad, dakega, igi-e-susde gudodibeye. ");
INSERT INTO cuk_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Geb degine, Faraón-e-sisgwa diwarse obnonikid. Ar yagan-ega-arbamaladdi diwar-gakaba garmakdimargua, Faraón-e-sisgwa nargammugii-dakleged-imbaba garba-nai dakalid. Geb degine, ega-arbaed-ome-wargwen-barmisad, adi, ega garba sedagegar. ");
INSERT INTO cuk_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Garba-egadgu, machi-bipi-bomai dakalid. Faraón-e-sisgwa machi-bipi-nue-wiledakde, sogded: —We-machi-bipi, Hebreo-dule-e-goed. ");
INSERT INTO cuk_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Geb degine, machi-bipi-e-bun Faraón-e-sisgwaga sogded: —Hebreo-ome-wargwen we-machi-bipi-akwega an bega aminaer, ¿nued be itoge? ");
INSERT INTO cuk_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faraón-e-sisgwa bunagwaga sogded: —Eye, be aminae. Geb degine, bunagwa machi-bipi-e-nanse gornaded. ");
INSERT INTO cuk_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Faraón-e-sisgwa machi-bipi-e-nanga sogded: —We-machi-bipi be anga-akwega be sede. Anga-be-akoedi, an be-bennukoed. Agine, e-nan goe-sesad. Geb degine, akwedii gusad. ");
INSERT INTO cuk_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Machi-bipi mam-iargusgu, e-nan Faraón-sisgwaga uksad. Geb agi, Faraón-sisgwa na e-mimmiga machi-bipi-imaksad. Geb Moisésʼye machi-bipi-onugsasad, ar ade, sogded: “Ar ande diigi onosaddeeye.” ");
INSERT INTO cuk_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Moisés bato machered-gusgu, ibagwengine, e-gwenadgan-ablis-emaladse ataknade gusad. Agi dakalid, e-gwenadgan arbaed-dummad imaknanai. Geb degine, Moisés dakdebalid, Egipto-dule-wargwen Hebreo-dule-sabsur-sarsonai. Hebreo-dule Moisés-ebogwa na ablis emaladid. ");
INSERT INTO cuk_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Geb degine, Moisés bela e-dikarba ataksagu, dulemar-sate daksagua, Egipto-dule-oburgwisad. Geb degine, odukuegala, ukubyaba digsad. ");
INSERT INTO cuk_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","A-banedgine, Moisés gannar e-gwenadganse nade gusbalid. Agi dakalid, Hebreo-dulemar na ebo-urwenanai. Dule-sabsur-imaknaidse Moisés egichided: —¿Ibiga na be-ablis-emalad be sabsur sarsonai? ");
INSERT INTO cuk_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","We-Hebreo-dule Moisés-abin sogded: —¿Ar doa anmar-dummadga, degi, anmarga-igar-nabogedga be-onugsasa? ¿Egipto-dule-oburgwisadyob be an-oburgwebimoga? Moisés weyob ega soge itoargu, dobe-itonaded, ar ade, mag itoged, ede Egipto-dule-oburgwisad, degine, binsaded, ede wisgulesye. ");
INSERT INTO cuk_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ar inso, Faraón wisguargu, Moisés Egipto-dule-oburgwisye, agi Faraón, Moisés-oburgwebi-gualid. Ar Moisésʼdi wakitegu, Madián-yalaganba megnaded. Warmakdapgu, dia-gwagwen-naba sigidapid. ");
INSERT INTO cuk_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Madiánʼgi dule-irwa-Bab-Dummadse-goled-wargwen maid. We-dulede, Reuelʼye-nugad, degi, Jetroʼye nugbalid. We-dulede, sisgan-walagugle (7) nikad. A-ibagi, we-bunamala e-bab-sibad-wawaad diigi-ogobega, dii-sied-enogega, diase dii sunaded. ");
INSERT INTO cuk_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ar sibad-wawaad-edarbemalad-baigan nonimogad. Amar, bunamala-ononnosmalad. Moisés we-bunamala-walagugled-bendakega ulusad. Geb degine, Moisés bunamala-sibad-wawaadmar diigi ogobsad. ");
INSERT INTO cuk_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Bunamala e-bab-Reuelʼse gannar modapmargu, e-bab ese egichialid: —¿Ar ibiga, emigindi bur bemar gwae-gwae nonimala? ");
INSERT INTO cuk_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bunamala e-bab-abin sogdemalad: —Sibad-wawaad-edarbemalad-baigan anmarse uluargu, Egipto-dule-wargwen anmarbina ulusad. Geb a-sorba, anmarga dii wesad. Geb deginbali, diigi sibad-wawaadmar ogobsabalid. ");
INSERT INTO cuk_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Geb degine, Reuel e-sisganga sogded: —Emide, ¿bia we-dulede? ¿Ar ibiga we-dule be wargwen obesmala? Bemar ese gornamala, adi, anmarse mas-gundagegar. Geb Moisésʼse gorapmargu, mas-gunbukwadgi Reuel Moisésʼga sogded: “Be an-walik megoye.” ");
INSERT INTO cuk_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moisés, Reuel-ega-ibmar-sogsad yeer-itosgu, sogded: “Nabirdo, be-walik an gudiguodo.” Degisoggu, Moisés Reuel-neggi megnonisunnad. Geb degidbali, Reuel na e-sisgwa-Séfora Moisésʼga uknonikid, adi, Moisés nikuegar. ");
INSERT INTO cuk_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Degidgine, Séforaʼga susugwa uklenonikid. Moisés a-susugwa Gersónʼye onugsasad, ar ade, Moisés sogded: “Yar-baidgi, an-yarsulidgi an gudiid.” ");
INSERT INTO cuk_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Birgamar naded, geb Egipto-e-rey burgwenonikid. Degi-inigwele, Israel-dulemardi amba maiga gudidimalad-ular, naibi-itodidimalad. A-ular, bodidimalad. Geb degine, Bab-Dummad we-Israel-dulemar-bodidimalad itosad. ");
INSERT INTO cuk_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Degine, Bab-Dummad Israel-dulemar-nunmak-itodidimalad nue mag daksabalid. Agi, Bab-Dummad Abrahamʼbo, Isaacʼbo, Jacobʼbo, igar-mesisad insaded. ");
INSERT INTO cuk_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Agine, Bab-Dummad Israel-dulemar-dakded, degine, nue mag itosbalid, igi-Israel-dulemar wilebukwa. ");
INSERT INTO cuk_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moisés e-saka-Jetroʼga sibad-wawaad edarbediid. Jetroʼde, Madiánʼgi dule-irwa-Bab-Dummadse-goledid. Ibagwengine, Moisés nega-dulesulidganba sibad-wawaadmar sesagusad. Bab-Dummad-yar-dummadse modapid. A-yar-dummadde Horebʼye nugad. ");
INSERT INTO cuk_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Agi Bab-Jehová-e-baliwitur sapi-bula-abargi, soo-gwabunye-gwichidgi, Moisésʼse magarosad. Moisés sapi-bula nue-nuu dakdegu, dakalid, sapi-bula gummakgwichi, degite, bergusuli. ");
INSERT INTO cuk_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Geb degi, Moisés binsaded: “¿Ar wedi igidi? An daknaoed, wede ibiga sapi-bula geg bergue.” ");
INSERT INTO cuk_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Bab-Jehová dakdegu, Moisés e-dakega ese warmakdaniki, agi sapi-bula-abargi Moisésʼse goted: —¡Moisés! ¡Moisés! Moisés Bab-Dummad-abin sogded: —Degite, wegi an be-itogwichi. ");
INSERT INTO cuk_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Geb degine, Bab-Dummad Moisésʼga sogded: —Melle anse be warmako. Degine, be-naggi nag-uka-yoid be unge. Ar be napa-annagwichidi, napa-nuedid, nega-isligwaled-napad. ");
INSERT INTO cuk_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Bab-Dummad sogdebalid: —Ani an be-babgan-e-Bab-Dummadid. Ani an Abraham, Isaac, degi, Jacob-e-Bab-Dummadid. Geb degi, Moisés dobe-Bab-Dummad-wagar-dakedba na e-wagar edusad. ");
INSERT INTO cuk_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ar Bab-Jehováʼdi Moisésʼga sogdebalid: —Ar nue an daksad, igi an-dulamar Egipto-yargi nue wilebukwa. Ar ade, Egipto-dulemar sabsur an-Israel-dulemar-wiodidimalad, na e-bodidimalad, na nunmak-itodidimalad, an itosbalid. ");
INSERT INTO cuk_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","A-ulale, we-napnegse an aidenonikid, adi, Israel-dulemar Egipto-dulemarse-wilebukwadgi an onogegar. An-dulamar yar-nued-naidse, an sedoed. A-yarde, dummad-naid, napa-nuedid, gadi ibmar sanmaked. ”A-yargine, we-dulemar bukwad: Canaán-dulemar, Het-dulemar, Amorreo-dulemar, Ferezeo-dulemar, Heveo-dulemar, degi, Jebuseo-dulemar bukwad. ");
INSERT INTO cuk_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","”Israel-dulemar nunmak-itodimaladba bobukwad an itosad. Degine, an daksabalid, Egipto-dulemala dogdar sabsur-Israel-dulemar imakbukwad. ");
INSERT INTO cuk_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Degisoggu, be nae, ani an Faraónʼse be-barmidoed, adi, an-Israel-dulemar Egipto-yargi-bukwad be ononaegar.” ");
INSERT INTO cuk_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Geb degine, Moisés, Bab-Dummadga sogded: —Ar an Faraón-asabin-gwisgunaega, ¿an doasunna? Israel-dulemar Egipto-yargi-wilebukwad an ononaega, ¿an doasunna? ");
INSERT INTO cuk_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bab-Dummad Moisés-abin sogded: —Ani an beba gudiguoed. Wegi be dakoed, ani an be-barminaid: An-dulamar-Egipto-yargi-bukwad be onosale, bela bemala we-yargi be an-nug-odummobukwa gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ar Moisésʼdi, Bab-Dummad-abin sogded: —Israel-dulemarse an naele, an ega sogele: Be-dadgan-e-Bab-Dummad bemarse an-barmiarye, Israel-dulemar anse egisdamaloed: ‘¿Ar Bab-Dummadde igi nugsunna?’ Degite, ¿igi an abin-sogosunna? ");
INSERT INTO cuk_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Bab-Dummad, Moisés-abin sogded: —ANI AN, AN-GUED. Israel-dulemarga be sogo: ‘AN-GUED bemarse an-barmialid.’ ");
INSERT INTO cuk_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Geb degine, Bab-Dummad Moisésʼga sogdebalid: —Israel-dulemarga be sogbalo: ‘Bab-Dummad-Jehová, be-dadgan Abraham, Isaac, degi, Jacob, amar-e-Bab-Dummad bemarse an-barmialid.’ Weyob an nugaguad. We degibi an-nug degisadegu nugad. ");
INSERT INTO cuk_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Moisés be nae, Israel-girmar-dummagan-ebo be ambikuo, ega be sogo: ” ‘Bab-Jehová, be-dadgan Abraham, Isaac, degi, Jacob, amar-e-Bab-Dummad anse magarosad. A-Bab-Dummad anga sogsad, ede bemar-daksaye, degine, bemar-itosbarye, igi Egipto-yargi bemar-wiobukmala.’ ");
INSERT INTO cuk_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ega be sogbalo: ‘Bab-Dummad anga sogsabarye, ede bemar Egipto-yargi-wilebukwad bemar-onogoye. Degine, ede bemar-sedoye: Canaán-dulemar-bukwadse, Het-dulemar-bukwadse, Amorreo-dulemar-bukwadse, Ferezeo-dulemar-bukwadse, Heveo-dulemar-bukwadse, degi, Jebuseo-dulemar-bukwadse, amar-dulemar-yalaganse bemar-sedoye. ” ’A-yalagine napa-nuedid, gadi ibmar sanmakedid.’ ");
INSERT INTO cuk_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","”Israel-girmar-dummagan be-itogoed. Geb degine, amala bebo Egipto-e-reyse namaloed. Egipto-e-reyga bemar sogoed: ‘Hebreoʼmar-e-Bab-Dummad-Jehová, a anmarse magarosad. Degisoggu, ibapaa-naedgi nega-dulesulidganba, naedse be anmar-imakye, adi, anmar agi anmar-Bab-Dummad-Jehováʼga, ibmar ogumakar ukegar.’ ");
INSERT INTO cuk_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","”Degi-inigwele, ar an nue-wisid, Egipto-e-rey baisursunnagwadgi bemar-onogosulid. Ar Egipto-e-rey ise-gandikidgi geb bemar-onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Degisoggu, an-gangued an oyogoed, degine, Egipto-dulemar sabsur an odurdakoed, burgwed-nagase an imakoed. Ibmar-dakledisulid Egipto-yargi an imakoed. A-sorbali, geb Egipto-e-rey-Faraón bemar-onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","”Deginbali, an imakbaloed, Egipto-dulemar Israel-dulemargi nued-binsaed, adi, Israel-dulemar Egipto-yargi nodmalale, mer arganagwabi nodmalagar. ");
INSERT INTO cuk_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bela omegan wargwen-wargwen na e-neg-dikarba-mamaidsedibe, Egipto-dule-negyagi gudiidsedibe, ibmar egisoed: Ibmar-manigi-sobaled, ibmar-orgi-sobaled, mormar. We-ibmarmar be-masmalaga, degi, be-bunamalaga be yooed. Ar weyob Egipto-dulemar-ibe bemar ibmar suoed.” ");
INSERT INTO cuk_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Geb degi, Moisés Bab-Dummad-abin sogded: —Israel-dulemar an-itogosurmalad, an-bengumaloed. Anga bur sogdamaloed: ‘Bab-Jehová bese magarossuli.’ ");
INSERT INTO cuk_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Bab-Jehová Moisés-abin sogded: —Ar nabir be sogendo. Degite, ¿ibu be-argangi be ganisunna? Moisés, Bab-Jehová-abin sogded: —Gaapoled. ");
INSERT INTO cuk_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Bab-Jehová apor Moisésʼga sogded: —Gaapoled napase be mete. Moisés gaapoled napase meted. Geb degine, gaapoled yog naibega binyar-naded. Moisés dobedba idu abarmakdenad. ");
INSERT INTO cuk_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ar Bab-Jehováʼdi Moisésʼga sogded: —Be-argangi naibe e-bunnugi be gae. Moisés achadgu, naibe-gasgu, naibe gannar gaapoledga binyeded. ");
INSERT INTO cuk_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Bab-Jehová Moisésʼga sogded: —Weyob be imakoed-ulale, Israel-girmar-dummagan be-benguosurmalad, be-dadgan Abraham, Isaac, Jacob, amar-e-Bab-Dummad-Jehová, bese magarosye. ");
INSERT INTO cuk_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Bab-Jehová Moisésʼga sogdebalid: —Be-argan be-moryaba be-binasgargi be mese. Moisés na e-binasgargi e-argan mesisad. E-argan gannar onoargu, naibe-buna-yaa-maleged nika, ise-sibudiki, dakuu-dakle onoalid. ");
INSERT INTO cuk_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Geb degine, Bab-Jehová Moisésʼga sogdebalid: —Gannar be-argan be-binasgargi be mesbali. Moisés deyob imaksabalid. Gannar na e-argan onoargu, e-argan bato e-san-baidyobi nued noalid. ");
INSERT INTO cuk_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Geb degine, Bab-Jehová Moisésʼga sogdebalid: —Gebe be ibmar-imakoedgi Israel-dulemar be-itosurmalale, beba ibmar imaksurmalale, ibmar-sogbogwad ega be oyogoed. Abakalegi ibmar-sogbogwad-be-oyogoedgi be-itoarmalale. ");
INSERT INTO cuk_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ar Israel-dulemar amba be-ibmar-sogbogwad-oyosad itosurmalale, beba ibmar-imaksurmalale, dii diwargi be suoed. A-dii napagi be eogoed. Dii-diwargi-be-susad napagi aryogogua, dii abega binyidoed. ");
INSERT INTO cuk_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moisés Bab-Jehová-abin sogded: —¡Dummad, yeergangu-itole! Aku an itodaed, ibu an sogoe. Gusgu degibi an daniguad, emisginbisulid. An gale-gale sunmaked, an baisursunna sunmaksulid. ");
INSERT INTO cuk_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ar Bab-Jehováʼdi Moisés-abin sogded: —¿Ar wede doa, dulega gaya sisa? ¿Wede doa, dule-geg-sunmaked imaksa? ¿Wede doa, dule-uaya-yalliled imaksa? ¿Wede doa, dule-aku-ataked imaksa? ¿Wede doa, dule-mag-ataked imaksasunna? ¿Ani an Bab-Jehová-guedgi imaksasursi? ");
INSERT INTO cuk_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","”Degisoggu, be nae. Be sunmakder, ani an beba gudiguoed. Degine, be-ibmar-sogoed, ani an be-odurdakoed.” ");
INSERT INTO cuk_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moisésʼdi sogdebalid: —¡Dummad, yeergangu-itole! An bega guosulid. Bese wilesakwaa an egise, bur be dule-baid barmide. ");
INSERT INTO cuk_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Geb degidgine, Bab-Jehová Moisésʼse uluded, ega sogded: —¿Ar ande Leví-wagwa-be-ia-Aarón, magar daksursi? ¿Ar a-dulede nued sunmaksursi? Deginbali, be-ia-Aarón be-abin nodagoed. Be-dakdagogua, Aarón ulubgi weligwar itogoed. ");
INSERT INTO cuk_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Aarónʼga bela be sogoed, igi sunmakoe. Bemar sunmakalile, ani an be-bendakoed, degine, ani an Aarón-bendakbaloed, adi, bemar nuekwaa sunmakmalagar. Degine, an bemarga sogoed, igi bemar ibmar imakmaloe. ");
INSERT INTO cuk_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aarón be-anar dulemarga sunmakoed, Aarónʼde bega be-gwabinyob guoed. Deginbali, be, Aarónʼga Bab-Dummadyobiyob ega be gumogoed. ");
INSERT INTO cuk_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","We-gaapoled-be-ganikid be sede, ar ade, we-gaapoledgi ibmar-gegerdaklemalad be oyogoed. ");
INSERT INTO cuk_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moisés gannar e-saka-Jetro-negse nonikid, agi e-sakaga sogded: —Gannar an Egipto-yarse nabied, bia an-gwenadgan-ablis-mesamalad bukwadse. An daknabied, amba an-gwenadgan dulamardibe. Jetro Moisés-abin sogded: —Be nae, bitigi-nuedgi be modapina yeerban. ");
INSERT INTO cuk_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moisés Madián-yalaganba amba gudigua, agi Bab-Jehová Moisésʼga sogsad: —Egipto-yarse gannar be nae, ar ade, bela dulemar-be-oburgwebimaladi bato bela burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Agi Moisés moli-uayasuidgi na e-ome, degi, e-machimala-onakwisgu, sesagusad, Egipto-yarse gannar aligusad. Moisés Bab-Dummad-gaapoled e-argangi-ganiki nadegusad. ");
INSERT INTO cuk_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Geb a-sorbali, Bab-Jehová Moisésʼga sogded: —Egiptoʼse be modapile, Faraón-asabin bela ibmar-gegerdaklemalad be imakoed. We-ibmar-gegerdaklemalad sunna-imakega an bega gangued uksad. Ar andi aka bur bule Faraón-burguega an imakoed, adi, Faraón melle Israel-dulemar-onogegar. ");
INSERT INTO cuk_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","”Geb degine, Faraónʼga be sogoed: ‘Bab-Jehová weyob soged: Israel an-machi-sailaginedid. ");
INSERT INTO cuk_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Bato an bega sogsad, an-machi be onoye, adi, anse gormalagar, an-nug odummogegar. Ar bede yapa an-machi onosoggu, be-machi-sailaginedi an oburgoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Moisés igarba nadapgua, bia na-e-gwenadganmala mutik gaboedgi, Bab-Jehová, Moisés-abin noalid. Bab-Jehová, Moisés-oburgwebigualid. ");
INSERT INTO cuk_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Geb degine, Séfora estin-akwa susad. Geb agine, e-machi-abgan-uka-duku siksad. Geb Séfora Moisés-nag-dukugi e-machi-abgan-uka-duku sikaa imaksad. Geb degi, Moisésʼga sogded: “Be an-sui-nue-napiragwadid, sui-ablis-eoged-duled.” ");
INSERT INTO cuk_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Geb degine, Bab-Jehová Moisés-naega imaksasunnad. Séfora e-machi-abgan-uka-duku-siksad-ular, sogsagusad, “Moisésʼde sui-ablis-eoged-duleye.” ");
INSERT INTO cuk_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ar Bab-Jehováʼdi Aarónʼga sogded: “Nega-dulesulidganba be nae, ase be Moisés-abin be nae.” Geb agine, Aarón naded, Bab-Dummad-yargi Moisés-abingudapid. Agi, Moisés-e-wagar udapid, ega sogegar, be nued sogeye. ");
INSERT INTO cuk_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Geb degine, Moisés Aarónʼga bela ibmar sogsad, igi Bab-Jehová ega ibmar-sogoye sogsadba. Degine, ega sogsabalid, ibmar-gegerdaklemalad-imakega e-barmiarbarye. ");
INSERT INTO cuk_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Geb degi, Moisés, Aarónʼbogwa Israel-girmar-dummagan-ebo ambikunaded. ");
INSERT INTO cuk_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Geb degine, Aarón bela Israel-girmar-dummaganga sogded, igi Bab-Jehová Moisésʼga sogsa. Deginbali, Moisés dulemar-asabin Bab-Jehová ega imakoye sogsadba ibmar-gegerdaklemalad imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Dulemar Aarón-ega-ibmar-sogsad bengussurmalad. Emar itoarmargu, Bab-Jehová nue e-itosmarye, degi, na e-wilebukmalad e-daksamarbarye, bela na e-nono napase dulluu imakdemalad, oyogega, Bab-Jehová-e-nug emarde odummomarye. ");
INSERT INTO cuk_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Weyob gusad-sorbali, Moisés, Aarónʼbo Faraónʼga sognadmalad: —Weyob Israel-e-Bab-Dummad-Jehová soged: ‘An-dulamar nega-dulesulidganse be barmid, adi, anga iba-ononamalagar.’ ");
INSERT INTO cuk_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ar Faraónʼdi abin-sogded: —¿Bab-Jehováʼde doasunna? ¿Ibiga an a-sogedba ibsaoe? ¿Ibiga an Israel-dulemar onodagoe? We-Bab-Jehová an wissuli. Degine, Israel-dulemar an onogosurbali. ");
INSERT INTO cuk_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Geb degine, Moisés, Aarón-ebogwa Faraónʼga sogdemalad: —Hebreoʼmar-e-Bab-Dummad anmarse magarosad. Degisoggu, anmar nega-dulesulidganba ibapaa-nanalegedse naoed, Agi, anmar Bab-Dummad-Jehováʼga ibmar-ogumakar ukoed. Ar degisulile, abakalegi Bab-Jehová uelleged-dummadgi anmar-oburgwialile, igidibe, es-suidgi anmar-oburgodibe. ");
INSERT INTO cuk_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ar Egipto-reydi, Moisés-abin, degi, Aarón-abin sogded: —¿Ibiga bemar yamo dulemar-melle-arbaega deyob gordanimala? ¡Be namala, be arbanamala! ");
INSERT INTO cuk_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraón sogdebalid: —Emigindi, Israel-dulemar bukidar Egipto-yargi bukmalad. Ar bemarde, ¿bar-arbasuli amar imakode? Deyobsulirgebed. ");
INSERT INTO cuk_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Aka a-ibagine, Faraón dulemar-arbananaid-dummagan-e-dummaganga igar uksad. Degi, danar-danar-arbananaimalad-e-dummaganga igar uksabalid: ");
INSERT INTO cuk_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","—Israel-dulemar napsa-ginnid-akwayob-sobegala anmar ega gusgu bula-dinnaganagiid ukdaedyob melle ega bar ukmalo. ¡Na emar-sunnad bula-dinnaganagiid aminamalodo! ");
INSERT INTO cuk_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Degi-inigwele, napsa-ginnid-akwayob-sobaled amba gusgu e-mergu-sobmaladyob, sobmarbalodo. Napa-ginnid-akwayob-sobaled bipisaale gwagwen-akuar sobosurmalad. Ar wemarde, wiegala nanaed. A-ular, binnasur gordanimalad: ‘Anmar, ibmar-ogumakar anmar-Bab-Dummadga uknabimarye.’ ");
INSERT INTO cuk_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Gatik bur bule Israel-dulemar-arbaega be imakmalo. Gatik bur oarbamalo, adi, melle dule-ega-gakansadanikid itomalagar. ");
INSERT INTO cuk_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Dummagan-sabsur-dulemar-oarbananaimalad, degine, danar-danar-arbananaid-e-dummagan nadegusmalad, dulemar-arbananaimaladga sogdemalad: —Faraón apor igar-uksad, melle bemarga bula-dinnaganagiid bar ukmaloye. ");
INSERT INTO cuk_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Degisoggu, bemar-sunnad bula-dinnaganagiid aminamalargebed. Degi-inigwele, napa-ginnid-akwayob-bemar-sobedi, bemarga aidegosulid, gusgu mergu sobedyobi amba bemar sobmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Israel-dulemala oros-gagangiid-e-warmar aminamalaga bela Egipto-yalaganba duurmakdemalad. Adi, bula-dinnaganagiid-muchub ebumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Dummagan-sabsur-dulemar-oarbananaimalad dulemarse sabsur uluarmalad: —Bemarga bula-dinnaganagiid-ukledagu, igi-mergu bemar gusgu napa-ginnid-akwayobid imakdamala, deyob-mergu bemar imakmarbalodo. ");
INSERT INTO cuk_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Faraón-dummagan, Israel-dulemar-e-dummagan-onugsalesad sabsur-bibyoddamalad. We-Israel-e-dummagan danar-danar-arbamalad-e-dummaganad. Geb Israel-dummaganga sogdedamalad: —¿Ar ibiga bemar idualedba emi, degi, sae, napa-ginnid-akwayobid bur ichee sobsamala? ");
INSERT INTO cuk_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Israel-dulemar-danar-danar-arbananaid-dummadga-gunanaid Faraónʼse nadmalad, ega binnasursaar ibmar sogdemalad: —Dummad, ¿ibiga be be-maimar-bega-arbamalad weyob be imake? ");
INSERT INTO cuk_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Emide, bar anmarga bula-dinnaganagiid uksurmalad, degite, napsa-ginnid-akwayobid sobbi be anmar-abeged. Deginbali, anmar-sarsoardamarbalid. Degisoggu, Dummad, bar anmarginsurdo, be-sordamargindo. ");
INSERT INTO cuk_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ar Faraónʼdi abin-sogded: —¡Ar bemar unnila dule-wiegala nanaed! A-ular, bemar sogdidimalad: ‘Anmar ibmar-ogumakar Bab-Jehováʼga uknamaloye.’ ");
INSERT INTO cuk_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","¡Be arbanamala! Ar bemarga bula-dinnaganagiid uklegosurmar-inigwele, amba gusgu mergu ibagwengi-sobedyobi napsa-ginnid-akwayob-sobaled be sobmalo. ");
INSERT INTO cuk_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israel-dulemar-danar-danar-arbananaid-dummaganga soglesgu, bemarga gwagwensaar aidegosurye, igi ibagwenadgi gusgu mergu napsa-ginnid-akwayob-sobaled bemar sobe, deyob be sobmaloye. Deyob ega soglesgu, na nue nunmak itosmalad. ");
INSERT INTO cuk_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Israel-dule-arbananaimalad-e-dummagan, Faraón-ebo-sunmakdii noarmargu, dakarmalad, Moisés, degi, Aarónʼbo e-edarbebukmala. ");
INSERT INTO cuk_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Amar, Moisésʼga, Aarónʼga sogdemalad: —Bab-Jehová begi gwisgumalana yeerban, sabsur-be-odurdakmalana gadin. Ar bemar-nukined, Faraón, degi, dummagan-ega-arbamalad isdar anmar-dakarmalad. Ar bemar Faraónʼga, degi, e-dummaganga es-suid-uksamalayobi gued, adi, anmar-oburgwemalagar. ");
INSERT INTO cuk_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Geb degine, Moisés Bab-Jehováʼse gornadgu, ega sogded: —Dummadye, ¿ibiga be we-dulemar sabsur odurdake? ¿Ibiga wese be an-barmiali? ");
INSERT INTO cuk_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Faraónʼse be-nuggi an sunmaknonikid-akar, we-Faraón bur bule be-dulamar-wioalid, degite, bedi be-dulamar gwen be bendaksulid. ");
INSERT INTO cuk_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Bab-Jehová Moisés-abin sogded: —Emigindi be dakodo, igi an Faraón-imakoe. Emide, an-dutusur-ganguedgine an ibmar-imakedba, Faraón bemarga sogdagoed, ‘bemar namarye.’ Ar an-dutusur-ganguedgine an ibmar-imakedba, Faraón bemarga sogdabaloed, ‘bemar an-yargi nomarye.’ ");
INSERT INTO cuk_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Bab-Dummad Moisésʼga sunmakdebalid, ega sogded: —Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ani an Bab-Dummad-Bela-Gangued-Nikadid. We-nugba Abrahamʼse, Isaacʼse, Jacobʼse, an magarosad. An-nug-Jehováʼye-nugadbardi, an ese magarossulid. ");
INSERT INTO cuk_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Deginbali, amar-ebogwa an igar-mesisad, an sogsad, bemarga Canaán-yala an ukoye. A-yargi, Abraham, Isaac, Jacob, e-yarsulidgi sikwas gudigusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Emide, Israel-dulemar nunmakedba bodidimalad. Degine, Egipto-dulemar na e-maiga gandikidgi-be-imakdidimalad an itosad. Be-dadganbo an igar-mesisad an iessulid. ");
INSERT INTO cuk_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Degisoggu, Israel-dulemarga be sogna: ‘Ani, an Bab-Jehová gued. Egipto-dulemar-maiga be gubukmaladgi, sabsur be-imakdimaladgi an bemar-onogoed. An-gangued-nikadba an Egipto-dulemar sabsur-odurdakoed. Aba an be-bendakoed. ");
INSERT INTO cuk_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ani an be-sumaloed, an-dulamarga an be-imakmaloed. Ani an be-Bab-Dummadga guoed. ” ’Deyobi, bemar wisgumaloed, ani an be-Bab-Dummad-Jehová gued. Deginbali, bemar wisgumarbaloed, ani an Egipto-dulemar sabsur-bemar-oarbananaimargu an bemar-onosad. ");
INSERT INTO cuk_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Abrahamʼga, Isaacʼga, Jacobʼga an sogsagusad, Canaán-yala an bemarga ukedseye. A-yalase an be-nidmaloed. A-yala, degisadegu an bemarga ukoed. Ani an Bab-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moisés bela weyob Israel-dulemarga sogsad. Degi-inigwele, Israel-dulemar maiga-gudidimalad-ular, nue bukib-itodidimalad-ular, Moisésʼba ibsassurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Geb degine, Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","—Egipto-rey-Faraónʼga be sogna, Israel-dulemar-Egipto-yargi-bukwad be onogoye. ");
INSERT INTO cuk_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ar Moisésʼdi Bab-Jehová-abin sogded: —Israel-dulemarbela anba ibsassurmalad, ar Faraón-bulesunna. Ar ande nued sunmaksurbalid. ");
INSERT INTO cuk_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Geb degine, Bab-Jehová Moisésʼga, degi, Aarónʼga, Israel-dulemargi, degi, Egipto-rey-Faraónʼgi sunmakded. Geb Bab-Jehová Israel-dulemar-Egipto-yargi-bukwad-onogega, Moisésʼga, degi, Aarónʼga igar uksad. ");
INSERT INTO cuk_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Israel-dulemar-e-dadgansik wemar e-gwenadgan-iduedga gumalad: Israel-machi-sailagined-Rubén-e-masmala, wemalad: Hanoc, Falú, Hezrón, Carmi. Wemar Rubén-e-masmala gumalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeón-e-masmaladi, wemalad: Jemuel, Jamín, Ohad, Jaquín, Zohar, Saúl. We-Saúlʼde, ome-Canaánʼgined-e-machid. Wemala, Simeón-e-masmala gumalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Leví-e-masmaladi, machi-dummad-inse, geb bipigwadse, wemalad: Gersón, Coat, degine, Merari. Levíʼdi birga-dulanergwa-gakambe-gakagugle-nika (137) burgwisad. ");
INSERT INTO cuk_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gersón-e-masmaladi, degi, e-gwenadgandi, wemalad: Libni, degine, Simei. ");
INSERT INTO cuk_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Coat-e-masmaladi, wemalad: Amram, Izhar, Hebrón, Uziel. Coatʼdi birga-dulanergwa-gakambe-gakapaa-nika (133) burgwisad. ");
INSERT INTO cuk_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari-e-masmaladi, wemalad: Mahli, degine, Musi. Wemar, garda-maidba Leví-e-gwenadgan gumalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram e-ammor-Jocabed nikusad. Amarga Aarón, degi, Moisés uklenonikid. Amram birga-dulanergwa-gakambe-gakagugle-nika (137) burgwisad. ");
INSERT INTO cuk_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar-e-masmaladi, wemalad: Coré, Nefeg, Zicri. ");
INSERT INTO cuk_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziel-e-masmaladi, wemalad: Misael, Elzafán, Sitri. ");
INSERT INTO cuk_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aarónʼdi, Elisabet nikusad. Elisabetʼde Aminadab-e-sisgwad, Naasón-e-bunad. Geb Aarónʼga, degi, Elisabetʼga machimala-uklenonikid: Nadab, Abiú, Eleazar, Itamar. ");
INSERT INTO cuk_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Coré-e-masmaladi, wemalad: Asir, Elcana, Abiasaf. Wemala, Coré-dulemar-idumaladga gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aarón-e-machi-Eleazar, Futiel-e-sisgwa-wargwen nikunonikid. Machigwa ega uklenonikid, Finees. Wemala, Levita-e-gwenadgan gumalad, na e-idumaladid. ");
INSERT INTO cuk_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ar Bab-Jehová Aarónʼga, degi, Moisésʼga wemar-sunnadga sogsagusad, Israel-dulemar-Egipto-yargi-bukwadi danar-danar na e-gwenadgan-e-gwenadganba be onogoye. ");
INSERT INTO cuk_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Amba Moisés, degi, Aarón, Israel-dulemar-Egiptoʼgi-wilebukwad-onogega, Egipto-rey-Faraón-ebo sunmakap gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Bab-Jehová Egipto-yargi Moisésʼbo sunmaksagua, ega sogsad: ");
INSERT INTO cuk_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","—Ani an Bab-Jehová gued. Bela an bega ibmar sogoedi, Egipto-rey-Faraónʼga bela be ibmar-sogmogoed. ");
INSERT INTO cuk_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ar Moisésʼdi Bab-Jehová-abin sogded: —Bab-Jehová, ar ande gale-gale sunmaksoggu, ¿igi Faraón an-ibmar-ega-sogedba ibmar-imakosunna? An-sogedba ibmar imakosuli. ");
INSERT INTO cuk_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Geb degine, Bab-Jehová Moisésʼga sogded: “Emi be dakena, Faraón-asabin Bab-Dummadyob be guoed. Be-ia-Aarónʼdi bega gayaburba-barsogedga gumogoed. ");
INSERT INTO cuk_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Bela an-bega-ibmar-sogoedi, bela Aarónʼga be sogmogoed. Geb degine, Aarón Faraónʼbo sunmakoed, adi, Faraón na e-yargi Israel-dulemar-bukwad onogegar. ");
INSERT INTO cuk_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ar andi gatik aka bur bule Faraón-burguega an imakoed, adi, mer an-dulamar-onogegar. Deyob an imakoed, adi, Egipto-yargi ibmar-dummagan, ibmar-gegerdaklemalad an gatik imakegar. ");
INSERT INTO cuk_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Faraónʼga-bemar-ibmar-sogoedi, be-itogosurmalad. Ar andi Egipto-yargi an-gangued an oyogoed, ar sabsur Egipto-dulemar an odurdakoedgi, an-dulamar-Israel-dulemar, Egipto-yargi an onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","An-gangued Egiptoʼgi an oyosale, degi Israel-dulemar Egipto-yargi-bukwad an onosale, agi Egipto-dulemar wisgumaloed, ani an Bab-Jehová gue.” ");
INSERT INTO cuk_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moisés Aarón-ebogwa ar igi Bab-Jehová ega sogsa, aba bela imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moisés, degi, Aarón, Faraónʼbo sunmaksamargua, deunni, Moisés birga-dulabake (80) nikad. Aarónʼdi deunni, birga-dulabake-gakapaa (83) nikad. ");
INSERT INTO cuk_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Bab-Jehová Moisésʼga, degi, Aarónʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Faraón bemarga sokardibe, ibmar-gegerdakleged anga be imakye, Aarónʼga be sogoed, be-gaapoled be suye, napase Faraón-asabin be meteye, adi, gaapoled naibega binyegar.” ");
INSERT INTO cuk_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moisés Aarón-ebogwa Faraón daknadgusmalad. Igi Bab-Jehová ega sogsa, aba imaksamalad. Aarón Faraón-asabin, degi, Faraónʼga-arbamalad-asabin napase e-gaapoled meted. Geb degine, gaapoled naibega binyided. ");
INSERT INTO cuk_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ar Faraónʼdi e-dulemar-nue-ibmar-wisimaladse, nelemarse gochad. Wemala, ibmar-burba-wisimaladba bela deyob imaksamarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Na wargwen-wargwen e-gaapoled napase metemalad, bela gaapoled naibega binyidmalad. Degi-inigwele, Aarón-gaapoleddi dulemar-ibmar-nue-wisimalad-e-gaapoled, degi, nelemar-e-gaapoled dosad. ");
INSERT INTO cuk_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Bab-Jehová bato iduar Moisésʼga sogsadyob, Faraón aka burguded. Faraón Moisés-ega-sogedba ibmar gwen imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Geb degine, Bab-Jehová Moisésʼga sogded: “Moisés, Faraón bela-bela aka bur bule burguded, Israel-dulemar-Egipto-yargi-bukwad yapa onoged. ");
INSERT INTO cuk_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Oibosale, wakudaryalaba Faraón diwarse aidenadapile, abin be naoed. Diwar-gakagi be edarboed, degine, be-gaapoled-naibega-binyisad be sedoed. ");
INSERT INTO cuk_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Agi, Faraónʼga be sogoed: ‘Hebreoʼmar-e-Bab-Dummad-Jehováʼye-nugad an-barmiarye, bega sogega: An-dulamar be onoye, adi, nega-dulesulidganba anse gornamalagarye, an-nug odummogegarye. Ar emidse an-ibmar-bega-sogedba be imaksursoggu, ");
INSERT INTO cuk_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","emigi be wisguoye, ani an Bab-Jehová guye.’ ”Moisés, emide, we-gaapoled-argangi-ganikidgi be diwar bibyodele, dii abega binyidoed. Agi Faraón wisgusunnoed, ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Uamardi burgwidoed, diwar sunnasur yapandagoed. Degisoggu, Egipto-dulemala ima we-dii gobe gudamaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Deginbali, Bab-Jehová Moisésʼga sogdebalid: “Aarónʼga be sogo, be-gaapoled be suye. Degine, be-argan diwarmargi, dianmargi, mata-nanaidmargi, degi, dii-sabolesimaladgi be oyoye, gwidu-urgomargi-dii-bukwadse-bakar, degi, gwidu-akwamargi-dii-bukwadse-bakar, bela Egipto-yargi abebi guoye.” ");
INSERT INTO cuk_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moisés Aarón-ebogwa igi Bab-Jehová ega sogsa, ayob imaksamalad. Aarón e-gaapoled onakwisad. Geb degine, Faraón-asabin, ega-arbamalad-asabin diwar bibyosad. Geb degine, bela dii abega binyided. ");
INSERT INTO cuk_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Uamardi burgwisad, diwar bela sunnasur yapansoggu, Egipto-dulemar geg dii gobe guarmalad. Bela Egipto-yargi abe yaisur-nika gunonikid. ");
INSERT INTO cuk_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ar Egipto-nelemar ibmar-burbamar-wisidba amba deyob imaksamarmogad. Bab-Jehová bato iduar Moisésʼga sogsadyob, Faraón aka bur bule burguded, Moisés, degi, Aarónʼbo-ibmar-sogedba, Faraón imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraón na e-neg-gabedse nonikid, we-ibmar-gusadi bai gwen itossulid. ");
INSERT INTO cuk_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Degine, ar diwar-diidina geg goblegussoggu, Egipto-dulemala dii-nued-sumalaga bela diwar-naba dia akwismalad. ");
INSERT INTO cuk_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Bab-Jehová diwar-bibyosad-sorba, ibagugle (7) ibagan nasad. ");
INSERT INTO cuk_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Bab-Jehová Moisésʼga sogded: “Be Faraón daknao, ega be sogo: ‘Bab-Jehová weyob soged: An-dulamar be onogo, adi, anse gornamalagar, an-nug odummogegar. ");
INSERT INTO cuk_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ar an-dulamar be onosulile, sabsur an be-odurdakoed, bela be-yargi ammanoo yaisur-nika an imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Diwargi bukidar ammanoo gwalulegoed. Agi, nakwidagoed. Be-negyagi ubogoed, bia be gabmaidgi dogoed, be-gabed-birgi ambikuoed. Bega-arbamalad-neggi, be-sordamar-neggi ubogoed. Be-madu-sobedyaba, degine, be-madu-omukuedgi, agi ammanoomar-bukidar ambikuoed. ");
INSERT INTO cuk_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ammanoomar begi, bega-arbamaladgi, degi, be-sordamargi ichomakdii guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Bab-Jehová Moisésʼga sogded: “Aarónʼga be soge, be-gaapoled diwarmargi, dianmargi, matamargi oyoye, adi, agi ammanoomar ainidamalagar. Degine, Egipto-yargi bukidar ammanoo nika gusun.” ");
INSERT INTO cuk_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aarón na e-gaapoled Egipto-diwarmargi oyoded. Geb degine, agi bukidar ammanoomar ainialid. Egipto-yargi bela ammanoomar yaisur nika guded. ");
INSERT INTO cuk_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ar nelemar ibmar-burba-wisidba deyob imaksamarmogad. Egipto-yargi ammanoo bukidar-nika imaksamarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Geb degine, Faraón, Moisésʼbina, Aarónʼbina gochad, amarga sogded: —Bab-Jehováʼga be soge, anga, degi, an-sordamarga ammanoo osuloye. Geb degine, be-dulemar naega an imakoed, adi, Bab-Jehováʼga ibmar-ogumakar uknamalagar. ");
INSERT INTO cuk_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moisés Faraón-abin sogded: —Anga be soge, ¿sana bega, bega-arbamaladga, degi, be-sordamarga, Babse-gorbi be an-abege? Adi, ammanoomar begi banguega, degi, be-neggwebur-negmargi berguegar. Unnila diwarginbi nika guegar. ");
INSERT INTO cuk_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Faraón Moisés-abin sogded: —Bane-bakas be imako. Moisés Faraón-abin sogded: —Ar deyob guodo, adi, be wisguegar, dule-baid anmar-Bab-Dummad-Jehováʼyobid sated. ");
INSERT INTO cuk_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ammanoomala, begi bangudmaloed, be-neggi bar-gudiguosurmalad. Bega-arbamaladgi, degi, be-sordamargi bar-gudiguosurmarbalid, unnilagwa diwarginbi gudigumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moisés, Aarón-ebogwa Faraónʼgi bangudgu, Moisés Bab-Jehováʼse egichided, ammanoomar-ichesur-Faraónʼse-be-barmialid osuloye. ");
INSERT INTO cuk_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Bab-Jehová Moisés-ese-egisnaidba imaksad. Ammanoomar, neggi, galu-imbagi, degi, sapurba-garmakdimalad, burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Dulemar ammanoo-burgwismalad wesmalad. Bela danar oambikusmalad. Geb degine, bela neg-nunudbi yapated. ");
INSERT INTO cuk_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Degi-inigwele, Faraón ammanoo-bergus-dakargu, ar igi Bab-Jehová bato iduar sogsadyob, Faraón aka bur bule burguded. Faraón, Moisés-ega-ibmar-sogedba, degi, Aarón-ega-ibmar-sogedba gwen imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Bab-Jehová Moisésʼga sogdebalid: “Aarónʼga be soge, be gaapoled be onakye, agi ukub be bibyoye, adi, ukub gwiiga binyegar, adi, bela Egipto-yargi gwii yaisur nikuegar.” ");
INSERT INTO cuk_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Deyob imaksamalad. Aarón na e-gaapoled onakwided. Geb agine, ukub bibyosad, geb degine, bela Egipto-yargi ukub gwiiga binyided. We-gwiimala, dule-gutemalad, degi, ibdurgan-gutemalad. ");
INSERT INTO cuk_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Nelemar aisaar gwii-yaisur-nikuega na ibmar-burbamar-wisimaladba imaknanai guarmarmoganad. Degi-inigwele, ukub gwiiga obinnissurmalad. Ar degidgine, gwiimardi, dule-gunnanai, degi, ibdurgan-gunnanai guarmalad. ");
INSERT INTO cuk_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Geb degine, nelemar Faraónʼga sogdemalad: “¡Wedi Bab-Dummad-ganguedi!” Bab-Jehová bato iduar sogsadyob, Faraónʼdi aka bur bule burguded. Moisés-ega-ibmar-sogedba gwen imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Bab-Jehová Moisésʼga sogdebalid: “Oibosale, be gwisguo. Wakudaryalaba Faraón-diwarse-naoedse Faraón-abin be nao. Faraónʼga be sogo: ‘Bab-Jehová weyob soged: An-dulamar be onogo, adi, anse gornamalagar, an-nug odummogegar. ");
INSERT INTO cuk_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ar be onosulile, gukurmar-galagwensulid an begi, bega-arbamaladgi, degi, be-sordamargi, deginbali, be-negyagi an barmidoed. Egipto-dulemar-neggi gukurmar-galagwensulid ena ubogoed. Deginbali, ar bia Egipto-dulemar-gudidimala, a-napagi amba gukurmar-galagwensulid nika gubaloed. ");
INSERT INTO cuk_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ar weyob gunonikile, Gosén-yalagindi, bia an-dulamar bukwa, gukurmar nikuosulid. Gosén-yalaginbi gukurmar-galagwensulid gwagwensaale nika guosulid. Agi be wisguoed, ani an Bab-Jehová gued. We-Egipto-yargi an gudiid. ");
INSERT INTO cuk_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","An-dulamar, be-dulemar-ebogwa akarsaila an dakoed. Oibosale, an bega sognaidyob, we-ibmar-dakledisulid an imakoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Bab-Jehová deyob imaksad, gukurmar-galagwensulid yaisur Faraón-neggi, Faraónʼga-arbamalad-neggi ubononikid. Degine, bela Egipto-yalagi bukidar gukur-galagwensulid-nika gunonikid. We-gukurmar Egipto-yala nue-oichosad. ");
INSERT INTO cuk_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Geb degine, Faraón Moisésʼse, degi, Aarónʼse gochad, amarga sogded: —Be namar, be-Bab-Dummadga ibmar-ogumakar be uknamar. Ar Egipto-yargindi mer be nomalo. ");
INSERT INTO cuk_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moisésʼdi Faraón-abin sogded: —Suli, anmar deyob imakele, nuedsuli. Ar ade, anmar-Bab-Dummad-Jehováʼga, anmar ibmar-ukedi, we Egipto-dulemarga ibmar-isganad, ibmar-sunnasulidid. Egipto-dulemar a-ibmarmar-ogumakar-uknai anmar-daksale, ar an wisid, akwagi-makar anmar-oburgwismalaled. ");
INSERT INTO cuk_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Anmar nega-dulesulidganba, ibapaa-nanaedse anmar naergebed. Agi, anmar-Bab-Dummad-Jehováʼga ibmar-ogumakar anmar ukoed. Ar igi anmarga Bab-Dummad-Jehová sogoe, aba anmar ibmar ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Geb degine, Faraón sogded: —Nega-dulesulidganba-naed an bemar-imakoed, adi, na bemar, bemar-Bab-Dummad-Jehováʼga, ibmar-ogumakar uknamalagar. Naega an bemar-imakoedi, dikasurdi melle be namalo. Deginbali, anga be Bab-Dummadse gormarmogo. ");
INSERT INTO cuk_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moisésʼdi Faraón-abin sogded: —An wegi nodele, Bab-Jehováʼse an egisoed, oibosale, gukurmar-galagwensuli-nikadi begi, bega-arbamaladgi, degi, be-dulemargi banguye. Deyob an imakoed, be anga soger, bar an be-yardakosurye, degine, be-dulemar an onogoye, onosuli bar an imakosurye, adi, Bab-Jehováʼga bemar ibmar-ogumakar uknamalagarye. ");
INSERT INTO cuk_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moisés, Faraónʼgi bangudgu, Bab-Jehováʼse goted. ");
INSERT INTO cuk_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Bab-Jehová Moisés-ese-ibmar-egichisadba imaksad. Gukurmar-galagwensuli-nikadi, Faraónʼgi, Faraónʼga-arbamaladgi, degi, Faraón-sordamargi banguded. ");
INSERT INTO cuk_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ar Faraónʼdi gannar aka bur bule burguded, Israel-dulemar-onogega gwen imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Geb degine, Bab-Jehová Moisésʼga sogdebalid: “Faraón be daknao, ega be sogo: ‘Hebreoʼmar-e-Bab-Dummad-Jehová weyob sogye: An-dulamar be onogo, adi, anse gornamalagar, an-nug odummogegar. ");
INSERT INTO cuk_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","” ’Ar be an-dulamar-onosulile, amba be gaele, ");
INSERT INTO cuk_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Bab-Jehová be-molimar-be-nainugi-gudidimaladgi e-gangued oyogoed. Degine, boni-dummad we-be-ibdurgangi odegoed: Molimargi, moli-uayasuidmargi, moli-yargan-muremaladgi, moli-bebe-nikamaladgi, sibad-wawaadmargi, degi, sibadmargi, odegoed. Bela we-ibdurgan burgwemaloed.’ ");
INSERT INTO cuk_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","”Weyob be Faraónʼga sogo: ‘Ar Bab-Jehováʼdi Israel-dulemar-ibdurgan, Egipto-dulemar-ibdurganbo akarsaila dakoed, adi, melle Israel-dulemar-e-ibdurgan burgwemalagarye.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Degine, Bab-Jehová iba nasiksad. Geb sogded: “Neg-oibosale, we-ibmar an deyob imakoed.” ");
INSERT INTO cuk_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Neg-oibosgu, Bab-Jehová deyob imaksad. Egipto-dulemar-e-ibmar-durgan bela burgwismalad. Israel-dulemar-e-ibmar-durgandi, wargwensaale gwen burgwissulid. ");
INSERT INTO cuk_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraón Israel-dulemar-e-ibmar-durgan-daknamalaga, e-dulemar barmisad. Dakleardo, Israel-dulemar-e-ibmar-durgan wargwensaale gwen burgwissuli. Degi-inigwele, Faraón aka bur bule burguded, Israel-dulemar-onossulid. ");
INSERT INTO cuk_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Geb degine, Bab-Jehová Moisésʼga, degi, Aarónʼga sogdebalid: “Madu-sobedyaba buru-bukwadi nukgwen be-argan-warbogi be weemalo. Geb agine, Moisés Faraón-asabin buru niba midoed. ");
INSERT INTO cuk_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Geb buru ukubga binyidoed, degine, bela Egipto-yalaganba mimiledoed. We-ukub, dulemar-yaa-nikadbi, degi, ibmar-durgan-yaa-nikadbi imakoed.” ");
INSERT INTO cuk_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Moisés Aarónʼbogwa madu-sobedyaba buru-bukwad-wesmargua, Faraón-daknadmalad. Agine, Moisés buru niba-mided, degi, dulemar, ibmar-durganse-bakale, bela yaa-nikadbi gunonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Nelemar Moisés-asabin geg gwisgu gusmalad, ar ade, amarse-bakale, bela yaa-nikadbi gusmarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ar Bab-Jehováʼdi, aka bur bule Faraón-burguega imaksad. Ar igi Bab-Jehová bato iduar Moisésʼga sogsa, deyob gunonikid. Degisoggu, Faraón Moisés-gwen-bar-wisgubisuli, degi, Aarón-gwen-bar-wisgubisuli gusad. ");
INSERT INTO cuk_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Geb degine, Bab-Jehová Moisésʼga sogdebalid: “Neg-oibosale, wakudaryalaba be gwisguo, Faraónʼga be sognao: ‘Hebreoʼmar-e-Bab-Dummad-Jehová weyob sogye: An-dulamar be onogo, adi, anse gornamalagar, an-nug odummogegar. ");
INSERT INTO cuk_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","” ’Ar emigindi, an-boni-dummagan an begi, bega-arbamaladgi, degi, bela be-sordamargi an barmidoed, adi, be wisguegar, bela we-napneggi dule-anyobid surye. ");
INSERT INTO cuk_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Emi-gunaidgi, bur bule sabsur an be-odurdaknaina, boni-dummad-gwensakgi an be-dulemar-sabsur-odurdakena, bato be bela burgwismalanad. ");
INSERT INTO cuk_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ar emigindi, wis dula-gudiguega an be-imaksad, adi, an-gangued be dakegar, adi, bela we-napneg-naidgi an-wisgumalagar, an doa-dule gue. ");
INSERT INTO cuk_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ar aka emigindi, be an-dulamar-onobisulidba an-dulamargi amba be gwisgudiid. ");
INSERT INTO cuk_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","¡Degir nued! Neg-oibosar, we-wachigi, dii-akwaga-binyaled, Egipto-dulemar-bukualid-akar, emisgwadse, Egipto-yargi deyob-gwen-babatedisulidi, bela-bela babated an imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Degisoggu, be-ibmar-durgan, degi, bela be-ibmar-nainugi-nikadi, bela nuekwaa be sabogo. Ar ade, dii-akwaga-binyaled, babatidagogu, bela dulemar, degi, ibmar-durgan neg-uas-yaba dukuarsuli-bukwamaladi, bela ese burgoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Abala-Faraónʼga-arbamalad, Bab-Jehová-idu-owisonaid dobe-itosmalad. A-ular, uas-urba e-maimar-odosmalad, degine, e-ibmar-durgan odosmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ar baigandi, Bab-Jehová-idu-e-owisonaid baisur-itosmalad. Degisoggu, magaba e-maimar-obesmalad, degi, e-ibmar-durgan obesmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Geb degine, Bab-Jehová Moisésʼga sogded: “Be-sakwa niba be onak, adi, bela Egipto-yargi dii-akwaga-binyaled bela dulemargi, ibmar-durgangi, degi, e-nainugi-ibmar-nikadgi babategar.” ");
INSERT INTO cuk_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moisés niba e-sakwa onakwisad. Geb agine, Bab-Jehová mar-golega imaksad. Mar-dakarmakded, degine, dii-akwaga-binyaled bela napase babatialid. Bab-Jehová bela Egipto-yargi dii-akwaga-binyaled babatega imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Dii-akwaga-binyaled babatemai gusad, degine, mar-dakarmakmaid aidemai gusbalid. Ar Egipto-yargi-dule-ambikuded-akar, Egipto-yargine bipisaale dii-akwaga-binyaled weyob-gangu babatedisulid. ");
INSERT INTO cuk_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Dii-akwaga-binyaled bela Egipto-yargi, ibmarmar nainumargi-nanaid, ogilosad. Dulemar, degi, ibmar-durganse-bakar uas-urba-dukubuksurmaladi, ogilosad. Deginbali, bela Egipto-yargi-ibmar-digarmalad, sapi-dummaganse-bakale, ese bibichisad. ");
INSERT INTO cuk_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ar degite, Gosén-yargindi, Israel-dulemar-bukwadgindi, bipisaale dii-akwaga-binyaled gwagwensaar argwachasulid. ");
INSERT INTO cuk_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Geb degine, Faraón Moisésʼse, degi, Aarónʼse gochad. Amarga sogded: —Mag an itodo, ani an nosad. Angindo, an-dulemarginbardo, Bab-Jehováʼginsurdo. ");
INSERT INTO cuk_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bar an bemar-gaosulid. Be namarsun. Ar mar doggus-wilub-obicha gollomakmaisoggu, dii-akwaga-binyaled doggus wilub-obicha babatemaisoggu, wis be Bab-Jehováʼse be anmarga gole, adi, we-ibmarmar anmarga osulogegar. ");
INSERT INTO cuk_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moisésʼdi Faraón-abin sogded: —An we-neggweburgi nodeyalaba Bab-Jehováʼse golega argan an onakdoed. Geb agine, dii-akwaga-binyaled bar babatosulid, degine, mar bar gollomakosurbalid, adi, be wisguegar, we-napneg Bab-Jehováʼgadid. ");
INSERT INTO cuk_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Degi-inigwele, an nue wisid, be, degi, bega-arbamalad, degite, amba Bab-Dummad-Jehová-dobsurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","”We-ibmarmardi bela burgwisad: Gagan-linoʼye-nugad, orosgi-dakleged-cebadaʼye-nugad, Ar ade, bato cebadaʼde sanmaksad, degi, gagan-linoʼye-nugad bato durbamaksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","”Degi-inigwele, we-ibmarmardi akargussulid: Orosgi-dakleged-trigoʼye-nugad, orosgi-daklebalid-centenoʼye-nugad, amardi, akargussulid, Ar ade, amardi amba yoo ainidagedgined.” ");
INSERT INTO cuk_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moisés Faraónʼbo-sunmaksad-sorba, neggweburgi nodgu, e-argan onakded, Bab-Jehováʼse goted. Deyob imaksagu, dii-akwaga-binyaled yog berguar naded, bar babatissulid. Degine, mar bar gollomaksasurbalid, yog berguar nadbalid. ");
INSERT INTO cuk_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ar Faraónʼdi deyob dakdegua, bar dii wisuli, dii-akwaga-binyaled bar babatesurbali, degi, mar bar gollomakmaisurbali, Faraón gannar isgudbalid. Faraónʼga-arbamalad e-dummadyob burgudmarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ar igi Bab-Jehová bato iduar Moisésʼga sogsa gusa, deyob gunonikid. Faraón gannar bela-bela burgunonikid, degisoggu, Israel-dulemar-onogega gwen imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Bab-Jehová Moisésʼga sogdebalid: “Faraónʼse be nae, Faraón be dakna. Ar an-sunnad an Faraón bur bule burguega an imaksad, ega-arbamalad bur bule burgumalaga an imaksad. Ar an ibmar-gegerdaklemalad-imaked-ese-an-oyogegala, an ibmar-dummagan-imaked-ese-an-oyogegala, an deyob imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Deyob an imaksad, adi, be-mimmiganga be sogegar, be-waganga be sogegar, igi an Egipto-dulemar-sabsur-imaksa, degine, igi an ibmar-gegerdaklemalad amar-abargi imaksabali. Adi, agi bemar wisgumaloed, ani an Bab-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moisés Aarónʼbogwa Faraón-daknadgusmalad. Faraónʼga sogdapmalad: “Weyob Hebreoʼmar-e-Bab-Dummad-Jehová soged: ‘¿Ar wede sanagwadsega bede an-asabin san bipii imakoe? An-dulamar noega be imako, adi, anse gornamalagar, an-nug odummonamalagar. ");
INSERT INTO cuk_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","” ’Ar amba be yapa an-dulamar-onogele, neg-oibosale, sesmar-bukidar be-yarse an sedagoed. ");
INSERT INTO cuk_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","We-sesmar we-napneggi yaisur-mergu-nikuosoggu, napa gwen daklegosulid. We-sesmar, dii-akwamarga-binyaled-babatisad ibmar-wis-obesad bela gunnoed, degi, bela sapi-sapurba-bukmalad gunbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Be-negmaryaba, bega-arbamalad-negmaryaba, degi, bela Egipto-dulemar-negmaryaba, ena ubononikoed. Ar we-ibmar, be-babgan-we-yarse-nonikid-akale, degi, be-dadgan-we-yarse-nonikid-akale, e-ibagangi, emi-iba-naidse, weyob gwen dakledisulid.’ ” Moisés Faraónʼga-sunmakgwichid-bergusgu, biir imaksad, geb Faraónʼgi banguded. ");
INSERT INTO cuk_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Geb degine, Faraónʼga-arbamalad Faraónʼga sogdemalad: “¿Ar wede sanagwadsega we-dulede anmarga boni-dummad-onodiid berguoe? Degisoggu, Dummad, we-Hebreo-dulemar-naed be imake, e-Bab-Dummad-Jehováʼse gornamalagar. Dummad, ¿ar bede amba Egipto-yar-nue-bergus-naid be daksursi?” ");
INSERT INTO cuk_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Geb degine, Faraón gannar Moisésʼse, Aarónʼse gochad. Amarga sogded: —Be namar. Be-Bab-Dummad-Jehováʼse be gornamar. Bemar-naed-idu anga sogmalo, ¿doamar nadmalale? ");
INSERT INTO cuk_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moisés Faraón-abin sogded: —Anmarba-namaloedi, wemalad: Anmar-mimmiganmar, anmar-serganmar, anmar-machimala, anmar-bunamala, anmar-sibad-wawaadmar, degi, anmar-moli-bebe-nikadmar. Ar ade, anmar, anmar-Bab-Jehováʼga iba-dummad onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faraónʼdi dodoalegi ega sogded: —¡Eye, be-Bab-Jehová beba naoe! Ar bemar, unnila wakinnedgi binsananaisoggu, ¿ar ande, be-mimmigan bemarba-barmido be an-insae? ");
INSERT INTO cuk_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Suli. Deyob gued sate. Ar bemar Bab-Jehováʼse gornabimalale, e-nug-odummonabimalale, bemar-macherganbi namalodo. Ar deyob bemar egichismalad. Agi, Faraón Moisés-e-asabin-gwichid, degi, Aarón-e-asabin-gwichid, gandikidgi-onomalaga igar ukded. ");
INSERT INTO cuk_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Geb degine, Bab-Jehová Moisésʼga sogded: “Egipto-yargi sesmar-dagega be-argan be oyo, adi, bela Egipto-nainugi-ibmar-nikad obelogegar. Degine, dii-akwaga-binyaled-babatisad ibmar-obelossulidi, we-sesmar bela amar-obelogegar.” ");
INSERT INTO cuk_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moisés Egipto-yar-naidgi e-argan-oyodgua, Bab-Jehová dad-nakwedsik Egipto-yargi-burwa-golega imaksad. Burwa ibgi-gormai osedosad, degine, mutik-gormai oiboarbalid. Oiboargu, burwa-dad-nakwedsik-gochadi, sesmar-senonikid. ");
INSERT INTO cuk_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","A-sesmala, bela Egipto-yargi ubononikid. We-ibagangi sesmar-ichesur-ubononikidyob iduale weyob neg gudisulid. Degine, we-sorbali, weyob guosurbalid. ");
INSERT INTO cuk_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ar ade, sesmarde bela-bela mergusoggu, napa gwen magar daklessulid. Degine, dii-akwaga-binyaled gagan-obesad, degi, sapi-durbamar-sapigi-obesad, sesmar amar bela guchamalad. Egipto-yargi bipisaale nainu-e-gaganmar, sapi-e-gaganmar, gwen bessulid. ");
INSERT INTO cuk_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraón, Moisésʼse, degi, Aarónʼse yog-gollar imaksad. Geb, amarga sogded: “Be-Bab-Dummad-Jehováʼba an nue-nosad. Bemargi an nue-nosbalid. ");
INSERT INTO cuk_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","An wis bemarse egised, an-begi-yolesadi begi-nossuliyob be an-dake. We-boni-dummad-anga-osulogega, be-Bab-Dummad-Jehováʼse be anga gole.” ");
INSERT INTO cuk_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moisés Faraónʼgi bangudeyalaba Bab-Jehováʼse Faraónʼga goted. ");
INSERT INTO cuk_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Geb, Bab-Jehová burwa-gormaid obilisad. Burwa dad-argwanedsik binnasur-golega imaksad. A-burwa bela sesmar-sesad, Demar-Ginnidye-nugadse obatedapid. Ses Egipto-yargi gwagwensaale gwen bessulid. ");
INSERT INTO cuk_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ar Bab-Jehováʼdi aka bur bule Faraón-burguega imaksad. Degisoggu, Faraón Israel-dulemar-naega imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Geb degine, Bab-Jehová Moisésʼga sogded: “Bela Egipto-yargi negasichidbi naguegala, be-argan niba be oyoge. We-negsichidi bela-bela gudure guosoggu, acha-acha gudii gumaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Agi Moisés e-argan niba onakdegusad. Geb bela-bela negasichid bela-Egipto-yargi ibapaa nagunonikid. ");
INSERT INTO cuk_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Bela-bela ibapaa-wilub negasichid-nagussoggu, dule, dule-e-dikarba-gwichidi akudaksa gusad. Degine, geg aineba nale gusbalid. Degi-inigwele, Israel-dulemar-neggindina bela neg-mee naid. ");
INSERT INTO cuk_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Geb degine, Faraón Moisésʼse gochad, ega sogded: —Be namalo. Be-Bab-Jehováʼse be gornamar, e-nug odummonamar. Be be-mimmigan sedmarbalo. Degi-inigwele, moli-bebe-nikamalad, degi, sibad-wawaadmar, amardi be obemalo. ");
INSERT INTO cuk_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moisésʼdi Faraón-abin sogded: —¡Adi surbali! Ar be bur anmarga ibmar-durgan ukoed. Adi, a-ibmar-durgan Bab-Jehová-anmar-Bab-Dummadga ogumaklegar uklegegar. ");
INSERT INTO cuk_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Deginbali, anmar-moli-bebe-nikamalad anmarba naergebbalid. Ar ibmar-durgan-wargwensaale wegi beosulid. Ar ade, anmar, anmar-Bab-Dummad-Jehováʼse golegala, e-nug odummogegala, na anmar-ibdurgan suergebed. Degisoggu, anmar amba wissulid, igid anmar Bab-Jehováʼga-ukoe. Geb anmar weba sudapoed, ibimar anmar abegoe. ");
INSERT INTO cuk_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ar Bab-Jehováʼdi aka bur bule Faraón-burguega imaksad, Israel-dulemar-mer-onogega imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Deginbali, Faraón Moisésʼga sogsabalid: —Wegi be an-asabin-gwichidi, be nae. Mer be anse gannar-dagedgi be binsao. Ar be ibagwengi an-asabin be gwisgunonikile, anse be burgoed. ");
INSERT INTO cuk_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moisés Faraón-abin sogded: —Napira be anga soged. Ar bar be-wagar an dakosulid. ");
INSERT INTO cuk_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Bab-Jehová Moisésʼga sogded: “Napi boni-dummad-gwensak Faraónʼga, degi, Egipto-dulemarga an barmidagoed. A-sorbali, Faraón e-sunnad bemar-onogoed. Bar wegi-gudiguega bemar-imakosulid. ");
INSERT INTO cuk_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ar emigindi, Israel-dulemar-macherganga, degi, Israel-dulemar-omeganga be sogo, na e-neg-dikarba-mamaidse, ibmar-manigi-sobaled, degi, ibmar-orgi-sobaled egismaloye.” ");
INSERT INTO cuk_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Dakargua, Bab-Jehová Egipto-dulemar Israel-dulemar-nued-dakega imaksad. Deginbali, Faraónʼga-arbamalad dakmalad, Moisésʼde dule-dummadi, dule-nug-nikagwadi. Amba Egipto-yargi bela dulemala deyob Moisés-dakmarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Geb agine, Moisés Faraónʼga sogded: “Bab-Jehová weyob soged: ‘Nega-gabigwengi bela Egipto-yargi an nasoed. ");
INSERT INTO cuk_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Egipto-dulemar-e-machi-sailagined burgwemaloed. Egipto-yar-dakmaid-Faraón, be-machi-dummadgi onodoed. Degine, mai-ome-obnagedgi-arbaed-e-machi-sailaginmalad burgwemarmogoed. Deginbali, ibmar-durganse-bakar, sailagi-gwalulesmalad, burgwemarmogoed.’ ");
INSERT INTO cuk_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","”A-ibagi, bela Egipto-yargi binnasur gormaloed, na nunmak-itomaladba bomaloed. Weyob iduale, binnasur-gordisurmalad, degine, weyob a-sorba bar binnasur-golosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ar Israel-dulemar-abargi wis bipisaale achu dulese urwosulid, ibmar-durganse gwen urwosurbalid. Geb agi, bemar wisgumaloed, Bab-Jehová, Israel-dulemar Egipto-dulemarbo akarsaila dakye.” Geb Moisés Faraónʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","“Bela dule-bega-arbamalad anse duurmaknonikoed, yokorgi-sindigar-sii anga sogdamaloed: ‘Be naye, degine, bela be-sordamar-beba-nanaimalad, bela be namarye.’ Agi geb an naoed, iduardi an naosulid.” Bela-bela Moisés nue-urwe Faraón-asabin-gwichi noalid. ");
INSERT INTO cuk_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Bab-Jehová Moisésʼga sogded: “Egipto-yargi gatik bur bule an-ibmar-gegerdaklemalad an imakega, Faraón bemar-ibmar-sogedba imakosulid.” ");
INSERT INTO cuk_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moisés Aarónʼbogwa bela we-ibmar-gegerdaklemalad Faraón-asabin imaksad. Ar Bab-Jehováʼdi aka bur bule Faraón-burguega imaksasoggu, Faraón Israel-dulemar-Egipto-yargi-bukwad onossulid. ");
INSERT INTO cuk_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Bab-Jehová Egipto-yargi Moisésʼga, degi, Aarónʼga sunmaksad, amarga sogsad: ");
INSERT INTO cuk_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“We-nii, bemarga bur nii-sunsoged guoed. Gebe birga-onoded-e-niiga guoed. ");
INSERT INTO cuk_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","”Bemar bela weyob Israel-dulemarga sogo: ” ‘We-nii-ibambegi (10) bemar wala-walagwen, e-gwenadgan-e-gwenadganba, degi, neg-iliba, sibad-wawaad-sapingwagwad-war-wargwen na sumalo. ");
INSERT INTO cuk_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ar dule e-gwenadgan-ichegwale, sibad-wawaad-sapingwagwad geg bela gunnele, dule-neg-ibed e-neg-dikarba-itaka-maidbo na bulakwaa gunmalo. E-dule-merguedba na mimimalo, adi, sogedba gunmalagar. ");
INSERT INTO cuk_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Sibad-wawaad-sapingwagwad-amilegoedi, machered amilegergebed, birgagwen-nikadirgebed, bonisulid. Deyob be sumaloed, sibad-wawaaddibe, sibaddibe. ");
INSERT INTO cuk_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","” ’Bemar a-sibad-wawaad we-nii-ibambe-gakabakedse (14) sabomaloed. A-ibagi, neg-sedogusale, Israel-dulemar-belagwable, wala-walagwen, we-sibad-wawaad oburgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Geb degine, bemar we-sibad-wawaad-abe weoed. Geb degine, bia bemar sibad-wawaad-gunmaloedgi, yawagak-e-dikargi-urgomar-gwichidgi, degi, yawagak-niba-urgo-maidgi, we-abe be magoed. ");
INSERT INTO cuk_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A-mutiki, a-sibad-wawaad-e-san narar, gagan-gagbidba, degine, madu-inasulidba be gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","We-sibad-wawaad melle bipisaale maki gunmalo, amba duar mer be gunmarbalo. Bela we-sibad-wawaad, nonose-bakale, e-malimarse-bakale, degi, e-samurse-bakale, soogi narar imakmalo. ");
INSERT INTO cuk_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Melle we-sibad-wawaad-e-san sabogo. Ar wis obichale, banedse bemar bela ogumakmalo. ");
INSERT INTO cuk_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Bemar weyob sibad-wawaad gunmaloed: Bato mor-yoi, sapat-yoi, degi, gaapoled be-argangi-gani, bemar we-ibmar gwae-gwae gunmaloed, ar ade, Oburgwilegoenad-Iba an-nuggi onolegoed. We sogleged, bemar Egipto-yargi-wilebukwa Bab-Jehová bemar-ollor-imaksaye. ");
INSERT INTO cuk_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","” ’A-mutikidgi bela Egipto-yargi an nasoed. Deginbali, an Egipto-dulemar-e-machi-sailaginmalad oburgoed, degi, e-ibmar-durgan-sailagi-gwalulesmalad amba deyob an oburgwebaloed. An bela Egipto-dulemar-e-bab-dummagan wiogoed, an sabsur-odurdakoed. Ani, an Bab-Jehová, ani an weyob soged. ");
INSERT INTO cuk_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","” ’Sibad-wawaad-e-abe bemarga-oyogega guoed, biti bemar-neg gumala. An abe-dakdogua, bemargi an bakar nasoed. Degisoggu, an Egipto-dulemar-oburgwidogua, bemardi wargwensaar burgosurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","” ’We-iba bemar insaewilubmalad. Bemar we-iba, iba-dummad Bab-Jehováʼga onogewilubmalad. Bemar igar mesoed, adi, be-waganmar, we-iba igar-maidba degisadegu onodii gumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Bemar ibagugle (7) madu-inasulid gunmaloed. Degisoggu, iba gebe-onodeyalaba bemar-neggi madubur-ina sate guergebed. Ar doa-dule, we-ibagugledgi (7) madu e-ina-nika guchale, we-dule, Israel-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Gebe-iba-onodoedgi, degi, ibagugledgi (7), na bemar danar islidikidgi ambikumalargebed. We-ibabogwadgine bemar arbaosurmalad. Unnila na be mas-gunmalagala, masgullegoedbi bemar dumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","” ’Madu-E-Inasulid-Iba bemar onogewilubmalad, ar ade, a-ibagi, Egipto-yargi-bukwa danar-danar an bela bemar-onosad. Igar-maidbali, bemar we-iba be-wagan degisadegu onodii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Bemar madu e-inasuli gunmaloed, gebe-nii-onoded-ibambe-gakabake-nagunonikir (14), a-sedogidgi, geb degine, amba a-nii-iba-durgwen-gakagwensakadse (21), a-sedogidse gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Bemar-neggine, we-ibagugledgi (7) madu-ina gwen daklegosulid. Ar ade, doa-dule madu-e-ina-nika guchale, ar we-dule Israel-duledibe, Israel-dulesurdibe, we-dule Israel-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Degisoggu, melle madu-ina-nika ibmar gunmalo. Ar bia bemar na mamaimardibe, bemar madu e-inasuli gunmalargebed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Geb degine, Moisés bela Israel-girmar-dummaganse gochad. Amarga sogded: “Be namar. Bemar be-gwenadganga, sibad-wawaad-birgagwen-nikad sunamar. A-sibad-wawaad be oburgwemaloed, adi, Oburgwilegoenad-Iba be onomalagar. ");
INSERT INTO cuk_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bemar sibad-wawaad-e-abe bormogi weoed. Geb gagan-hisopoʼye-nugad-e-gagan be gwannoed. A-e-gagan danakwaa be gaogu, abegi be owardikuoed. Geb degine, a-abe bela neg-yawagak-e-dikarmar-gwichidgi, degi, yawagak-niba-urgo-maidgi be magoed. Bemar wargwensaale melle be-neggi be nomalo. Neg-oibogedse geb be nomaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Bab-Jehová Egipto-dulemar-oburgwe-danikile, bela neg-yawagak-dikargi abe-nai-dakalile, a-neggi bakar nasoed. Bab-Jehová, dulemar-oburgwed-baliwitur-danikid be-negyaba-dogega gwen imakosulid. Bab-Dummad gwen-burgwega be-imakosulid. ");
INSERT INTO cuk_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","”Bab-Dummad-bemarga-we-igar-mesisadi, bemar, degi, be-wagan, degisadegu imakdii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Bab-Jehová bemarga-yar-ukoye-sogsadgi bemar dogdapile, bemar we-iba deyob-onodii degisadegu gumarbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Be-mimmigan bemarse egichialile: ‘Wede weyob anmar iba-onoged, ¿ibi obarye?’ ");
INSERT INTO cuk_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Bemar abin-soge-wilubmalad: ‘Bab-Jehová Egipto-dulemar-oburgwenaigusgu, anmargindi bakar-nasye. Degisoggu, Bab-Jehová-nuggi we-sibad-wawaad oburgwileye. Degine, Israel-dulemar Egipto-yargi bukwagu, Bab-Jehová Israel-dulemar-neggi bakar-nadegusye, Egipto-dulemardi oburgwilesye. Weyobi, Bab-Jehová, anmar-gwenadgan-bendaksaye, anmardi oburgwilessurye.’ ” Moisés sunmaked-bergusgua, Israel-dulemala dulluu imaksamalad, oyogega, emarde Bab-Jehováʼse gornanaiye, Bab-Dummad-nug odummonanaiye. ");
INSERT INTO cuk_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Agi, geb nadmalad. Igi Bab-Jehová Moisésʼga, degi, Aarónʼga igar-uksa, aba bela deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nega-gabigwenadbali, Bab-Jehová Egipto-dulemar-gwenadgan-iliba e-machi-sailagined-oburgwisad. Amba deyob Faraón-Egipto-yar-dakmaid-e-machi-sailagined, degi, dule-esgaryagi-mellesiid-e-machi-sailaginedse-bakar oburgwisad. Degine, ibmar-durgan-gebegwalulesmalad oburgwisbalid. ");
INSERT INTO cuk_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Faraón, degi, ega-arbamalad, degine, bela Egipto-dulemar a-mutik gwisgusmalad, geb bela Egipto-yargi, binnasur ise-gormakar bosmalad, ar ade, neg-ilibali e-machi-sailagined burgwenai gusad. ");
INSERT INTO cuk_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Abga-a-mutikidgi Faraón Moisésʼse, degi, Aarónʼse gochad. Amarga sogded: “Be namar. Bemar-Israel-dulemar, an-dulemargi be bangumar. Bemar Bab-Jehová-e-nug odummonamar. Igi bemar sogsa gusa, deyob imaknamar. ");
INSERT INTO cuk_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Bemar be-sibad-wawaadmar, degine, moli-bebe-nikamalad be abemaladba sedmarbalo. Deginbali, bemar anga Bab-Jehováʼse gormarmogo, angi nued binsamogagar.” ");
INSERT INTO cuk_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egipto-dulemala gwae-gwae Israel-dulemar-ononai gualid. Ar ade, binsamalad, emarde bela burgwemaloye. ");
INSERT INTO cuk_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israel-dulemala madu-omukuar-siid, amba yoo egi madu-ina-eoleged, e-omukuedgi-siid susmalad. Bela e-morgi obipirmaksagu, e-gukingi-sii sesmalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Deginbali, Moisés-ega-igar-uksadba imaksamalad. Egipto-dulemarse ibmarmar-orgi-sobaled, degi, ibmarmar-manigi-sobaled egichismalad, degi, mormar egichismarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Bab-Jehová Egipto-dulemar Israel-dulemar-nued-dakega imaksad. A-ular, Egipto-dulemar bela Israel-dulemar-ese-ibmar-egichisad, ega nue-ukbi itogunonimalad. Weyobi, Israel-dulemala Egipto-dulemargi bela-bela ibmar-nuegan susmalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel-dulemala neggwebur-Ramesésʼye-nugadgi nodmalad, neggwebur-Sucotʼye-nugadse nadmalad. Machergan-sunna-bato-bila-onomaladbi, nagab-ainiarmaladi, mili-dulataled-ilanergwa (600,000) mergued. Omegan, degi, mimmigandi obarilesulid. ");
INSERT INTO cuk_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Israel-dulemarba dule-baigan-yar-baid-baidginmalad eba-bukidar ainiarmarmogad. Deginbali, bukidar sibad-wawaadmar, degi, moli-bebe-nikamalad searmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Israel-dulemar gwae-gwae-itoarmaladba amba yoo mas-due ainiarmalad, ar ade, Egipto-dulemala, e-yargi gandikidgi Israel-dulemar-onosmalad. Degisoggu, madu-omukualed-Egiptoʼgi-searmaladgi madu-olo e-inasuli sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel-dulemala Egipto-yargi birga-dulataled-ilabake gaka-dulagwen-gakambe (430) gudii gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Birga-dulataled-ilabake gaka-dulagwen-gakambegi (430), Bab-Jehová-e-sordamar Egipto-yargi-bukwad danar-danar ainiarmalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","A-mutiki, Bab-Jehová, Egipto-yargi Israel-dulemar-onogega, Israel-dulemargi nue nakulenai gusad, adi, bonisuli nomalagar. Agala, bela Israel-dulemar-wagan-danimaloedi, Bab-Jehová-ega-ibmar-imaksad-ular, a-mutikidgi atakbukwa gumaloed. Deyob, degisadegu imakdii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Bab-Jehová Moisésʼga, degi, Aarónʼga sogded: “Oburgwilegoenad-Iba-onogegala, weyob igar mai guoed: ‘Israel-dulesulid we-ibagi-mas-gulleged gunnosur guoed. Ar wede ega ised. ");
INSERT INTO cuk_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","” ’Ar mai-manigi-baklealiddi, idu bato e-abgan-uka-duku-siklesale, we-ibagi-mas-gulleged sunna gunnoed. ");
INSERT INTO cuk_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","” ’Dule-Israel-dulesulidi, unnila sikwas be-yargi nadapdibe, na mani-onogega arbadibe, a-dule bipisaale we-ibmar gunnosulid. ");
INSERT INTO cuk_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","” ’We-sibad-wawaad unnila neg-gwagwengi gullegoed. We-ibmar-oburgwilesad-e-sana, baid-negse sedega neg-gwagwengi bipisaale onolegosulid, degine, bipisaale be sibad-wawaad-e-gar bisgosurbalid. ");
INSERT INTO cuk_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","” ’Bela Israel-dulemala weyob imakergebmalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","” ’Degi-inigwele, Israel-dulesulid bemar-abargi gudiile, we-dule Oburgwilegoenad-Iba, degi, Bab-Jehová-nug-odummogega onobiele, iduale, bela machergan-e-neguyaginmalad e-abgan-uka-duku sikmalargebed. Geb a-sorbardi, sunna iba onogodo, ar we-dulemala be-yargi-gwalulesadyob gunonikoed. ” ’Dule-wargwensaale, e-abgan-uka-duku-sikarsulid, we-ibagi-mas-gulleged gunnosur guoed. ");
INSERT INTO cuk_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","” ’Bela dulemar-be-yargi-gwalulesmaladi, degi, dulemar-be-yarginsurmalad-be-abargi-gudidimaladi, ebobela deyob we-igar imakmaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israel-dulemala, Bab-Jehová igi Moisésʼga, degi, Aarónʼga igar-uksa, aba bela deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","A-ibagine, Bab-Jehová Egipto-yargi Israel-dulemar danar-danar onosad. ");
INSERT INTO cuk_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Machi-sailaginmalad anga be udago. Ar bela Israel-dulemar-e-machi-gebesailaginmalad, angadid. Degi, e-ibmar-durgan-gebe-gwalulemalad, amba deyobbalid.” ");
INSERT INTO cuk_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Geb degine, Moisés Israel-dulemarga sogded: “We-iba nue be insamalo. Bab-Jehová, bemar Egipto-yargi maiga-wilebukwadgi gandikidba bemar-ononaid. Melle bemar madu e-ina-nika gunmalo. ");
INSERT INTO cuk_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Emi bemar nonanaidi, Abib-niigi be nonanaid. ");
INSERT INTO cuk_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ar Bab-Jehová bemar-dadganga ise-sogar sogsa gusad, we-yala an bemarga ukedseye: Canaán-dulemar-yar, Het-dulemar-yar, Amorreo-dulemar-yar, Heveo-dulemar-yar, degi, Jebuseo-dulemar-yar. A-yarmar napa-nuedid, gadi ibmar sanmaked. ”Degisoggu, Bab-Jehová we-dulemar-yarse bemar-odononikile, we-Abib-niigi bemar we-iba onomaloed. ");
INSERT INTO cuk_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Ibagugle (7) madu e-inasuli bemar gunnoed. Ibagugledgi bemar iba-onogoedi, we-iba, Bab-Jehováʼgadid. ");
INSERT INTO cuk_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ibagugle (7) bemar madu e-inasuli gunmaloed. Bipisaale bemar madu-ina, madu e-inabardibe, be-yargine be nikuosurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ibagugle-gusadgine, be-machiga be sogmaloed: ‘An Egipto-yargi noargu, Bab-Jehová anga ibmar-dummagan imaksad, a-ular, an we-iba onoged. ");
INSERT INTO cuk_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Deginbali, we-iba, bemar-sakwagi, bemar-bebegindibe, wilub-naiyob guoed. We, bemar-insaega imakoed, bemar Bab-Jehová e-igar-maidgi sunmakdiguewilubbid, ar ade, Bab-Jehová gandikidba Egipto-yargi bemar-onosad. ");
INSERT INTO cuk_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","A-ulale, we-iba birga-irba e-iba-sekalaa bemar onogewilubmalad.’ ");
INSERT INTO cuk_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","”Bab-Jehová, ar igi bemarga, degi, be-dadganga sogsagusa, we-yala an bemarga ukedseye, deyob, Canaán-dulemar-yarse bemar-nisale, degi, bemarga uksale, ");
INSERT INTO cuk_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","bela be-machi-sailagined Bab-Jehováʼga be nugsaergebmalad. Amba deyob be-ibmar-durgan-machered-gebe-gwaluleged Bab-Jehováʼga bemar ukbaloed, ar ade, bela wemala, Bab-Jehováʼgadid. ");
INSERT INTO cuk_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","”Moli-uayasuid-ome gebe-mimmi-machered-nikued, a-mimmi-muchub sibad-wawaad-sapingwa, ebo be ogwaoed. Ar be sibad-wawaad muchub uksulile, adi, moli-uayasuid-mimmi-e-dukar be bisgoed. Deginbali, machi-gebesailagined-ular, Bab-Jehová be bennuknaiyobi ega be ibmar ukoed, adi, machi-sailagined onogegar. Machi-sailagined-ular, degibi be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","”Ar ibagwengi be-machi bese egichialile, ar wede ibi obarye. Be-machiga bemar sogoed: ‘Bab-Jehová gandikidba Egipto-yargi deun anmar maiga wilebukwagua, anmar-onosgusye. ");
INSERT INTO cuk_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faraón bur bule burgudgua, yapa anmar-onogeguargua, Bab-Jehová bela Egipto-dulemar-e-machi-sailagined-oburgwisye, degi, ibmar-durgan-e-mimmi-machered-gebegwalulesmalad amba deyob oburgwisbarye. A-ulale, anmar ibmar-mimmi-machered-gebegwaluleged bela Bab-Jehováʼga ukdamarye, degine, anmar-machi-sailagined-anar anmar Bab-Jehová bennuknaiyobi, ega ibmar-ogumakar ukdaye, adi, anmar-machi-sailagined-onogegarye. ");
INSERT INTO cuk_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Degisoggu, anmar weyob ibmar-imaked, bemar-sakwagi, bemar-bebegindibe, wilub-naiyob guegarye. We be insaega gumaloye, Bab-Jehová gandikidba Egipto-yargi anmar-onosgusye.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faraón Israel-dulemar-onosgua, Bab-Dummad Filistea-dulemar-yarsik-igar-maidsik Israel-dulemar-sessulid. A-igar bur-itakagwanad. Ar ade, Bab-Jehová binsasad, Israel-dulemar bila-onosogele, yapa bila-ono gudamaloye, bur gannar Egipto-yarse dagbi-gudamaloeddeeye. ");
INSERT INTO cuk_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","A-ulale, Bab-Dummad Israel-dulemar nega-dulesulidganba-bipirmakega sesa gusad, Demar-Ginnidye-nugad-naid-igarba sesad. ");
INSERT INTO cuk_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Deyobi, Israel-dulemala guakwaa urwenadapiyob Egipto-yargi noarmalad. Moisés, eba José-garmar sesa gusad. Ar ade, José burgwesokargu, Israel-dulemar-ega-ise-sogar-sogega imaksad, anmar be-garmar sededseye. Deunni, José, Israel-dulemarga weyob sognai gusad: “Napiragwad, Bab-Dummad bemar-bendaknonikoed. Ar deyob gunonikile, bemar an-garmar bemarba sedmalo.” ");
INSERT INTO cuk_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israel-dulemala neggwebur-Sucotʼye-nugadgi noarmalad. Geb Etamʼye-neg-nugadse ambikudapmalad. Agi, nega-dulesulidgan onoded. ");
INSERT INTO cuk_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ibgine, Bab-Jehová mogir-bubawaryob-gwichidba Israel-dulemar-idu-nadap gusad, adi, ega igar-oyonadap guegar. Mutikdina, soo-bubawaryob-gwichid-gwabunyemaidba idu-nadap gusad, adi, ega neg-mee saegar. Aga, nabir sunna ibginedba, degine, mutikidba, Israel-dulemar nadap gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Mogir-bubawaryob-gwichid gusgu Israel-dulemar-iduar ibgi nadap gusad. Soo-bubawaryob-gwichid-gwabunyemaiddi, mutik Israel-dulemar-idu-nadap gusbalid. ");
INSERT INTO cuk_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Israel-dulemarga be sogna, be gannar igar-baidba aibirmar. Pi-Hahirotʼye-neg-nugad-asabin bemar ambikunonimaloed. Pi-Hahirotʼde, Demar-naidi, degi, Migdolʼye-neg-nugad-naidi, amar-abargi naid. Baal-Zefónʼye-neg-nugad-asabin naid. A-asabin demar-gakagi bemar ambikunonimaloed. ");
INSERT INTO cuk_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Adi, Faraón binsaegar: ‘Israel-dulemar wissurmarye, emarde bia namaloye. Emar nega-dulesulidganba yoggus gudimarye.’ ");
INSERT INTO cuk_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","”Andi an, aka bur bule Faraón-burguega imakoed, degine, Faraón bemar-bareginnega an imakbaloed. Geb degine, Faraónʼgi, degi, e-sordamar-bila-onomaladgi an-gargangued an oyogoed. Deyob, Egipto-dulemala wisgumaloed, ani an Bab-Jehová guye.” Israel-dulemala deyob imaksamardo. ");
INSERT INTO cuk_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Geb degi-gunaidgine, Egipto-e-reyga soglealid, Israel-dulemar wakitemarye. Egipto-e-rey, degi, ega-arbamalad, binsaed-gwagdemalad, weyob sogdemalad: “¿Ar wede, ibiga anmar Israel-dulemar-onosa? Emide, anmar we-dulemar-naega imaksagu, gwen bar anmarga arbaosurmalad. Degisulirgebed.” ");
INSERT INTO cuk_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Geb degine, Faraón igar-ukdesunnad, urmar-bila-onoged-napagined ega guakwaa nasikye. Geb degine, Faraón e-sordamar-bila-onomalad sesad. ");
INSERT INTO cuk_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Faraón urmar-napagined-bur-nuegan dulataled-ilanergwa (600) susad, deginbali, bela Egiptoʼgi urmar-napaginmalad-baigan sesbalid. Faraón, e-dummagan a-urmar war-wargwen-sedega imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Bab-Jehováʼdi aka bur bule Egipto-rey-Faraón-burguega imaksad. A-ular, Faraón Israel-dulemar-baregite gusad. Israel-dulemardi dobsulidba nadap gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Bela Egipto-dule-e-sordamar-bila-onomalad, e-urmar-napagined, moli-birgi-sii-urwemaladi, Israel-dulemar-bareginnega ainidgusmalad. Egipto-sordamar, Israel-dulemar demar-gakaba Pi-Hahirotʼgi-danar-bukwa bargadapmalad, Baal-Zefón-asabin. ");
INSERT INTO cuk_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Israel-dulemar dakdemargu, Faraón, degi, Egipto-dulemar egi daniki, bela-bela dobe-itodmalad. A-ular, Bab-Jehováʼse gandikidba bendakleged egisdemalad. ");
INSERT INTO cuk_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Geb Moisésʼga sogdemalad: —¿Ar wede Egipto-yargi neg-uande sursi? Emide, nega-dulesulidganba anmar-oburgwega weba be anmar-onosgu. Ar wede, ¿ibiga deyob be anmar-imaksa? Ar wede, ¿ibiga Egipto-yargi be anmar-onosa? ");
INSERT INTO cuk_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ar anmar Egipto-yargi-gudigu bega sogsasursi, ‘¡Anmar bur Egipto-dulemar-e-maiga-gued bur nuedye! ¡Ar anmar nega-dulesulidganba-burgwedba Egipto-dulemar-maiga-gued bur nuedye!’ ");
INSERT INTO cuk_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moisésʼdi Israel-dulemar-abin sogded: —Melle be dobgumar. Gandik be imakmar. Bab-Jehová bemar-bendakega-ibmar-imakoed be nue dakmar. Ar ade, emi bemar Egipto-dulemar-dakedi, bipisaale gwen bar-dakosurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ar Bab-Jehová bemar-ular-urwosoggu, bemar mer bukib binsamalo. ");
INSERT INTO cuk_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Geb degine, Bab-Jehová Moisésʼga sogded: “¿Ar ibiga be anse bendakleged egise? ¡Israel-dulemarga gandikidba be soge, be namarye! ");
INSERT INTO cuk_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Bedina, be-gaapoled be onakwe, be-sakwa demarsik be oyoge, demar negabar be egae. Ar deyobi, Israel-dulemar demar-argasadgi neg-dinnagwadgi obakmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ar andi, Egipto-dulemar be-bareginmalaga, aka bur bule burguega an imakoed. Geb agine, Faraónʼgi, bela e-sordamar-bila-onomaladgi, e-ur-napaginmaladgi, e-sordamar-moli-birgi-sii-urwemaladgi, an egi-ibmar-imakoedi, an-nug bur odummolegega an imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","An Faraónʼgi, e-urmar-napaginmaladgi, e-sordamar-moli-birgi-sii-urwemaladgi an-gangued an oyosale, agi Egipto-dulemar wisguoed, ani an Bab-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Agine, Bab-Dummad-e-baliwitur, Israel-sordamar-idu-nadapidi, gwagded, Israel-sordamar-sorba nagusad. Deyobi, mogir-bubawaryob-gwichidi, Israel-dulemar-idu-nadapidi, gwagdemogad, Israel-sordamar-sorba nagusmogad. ");
INSERT INTO cuk_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Degisoggu, mogir-bubawaryob-gwichid Israel-sordamar-sorba nagussunnad, Egipto-sordamar-idu. Egipto-sordamargala, we-mogir gorosur-dakleged. Israel-sordamargardi, we-mogir ega neg-mee imaknaid. A-ulale, mutikidba Egipto-sordamar geg Israel-sordamar-barga gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Degine, geb Moisés e-argan demarse oyoded. Geb agine, Bab-Jehová dad-nakwedsik burwa-binnasur ogochad. A-burwa degi-gormai oiboalid. Weyobi, a-burwa demar negabar-egaega imaksad. Deyob, Bab-Jehová, demar-abargi neg odinnosad. ");
INSERT INTO cuk_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","We-napa-dinnagwadba Israel-dulemar obaksamalad. Demar gasdibir-matusulidyob e-dikar-nuedsik-mai, degi, e-sapiledsik-mai gusad. ");
INSERT INTO cuk_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Egipto-dulemar Israel-dulemar-sorba, ubodmalad: Bela Faraón-e-molimar, bela e-urmar-napaginmalad, degi, bela e-sordamar-moli-birgi-sii-urwemalad ubodmalad. Amala, demar-neg-abaladse Israel-dulemar-baregichamalad. ");
INSERT INTO cuk_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Bolegoedbali, Bab-Jehová mogir-bubawaryob-gwichid-akar, degi, soo-bubawaryob-gwichid-akar Egipto-sordamar-ise-nue-dakdegu, Egipto-sordamar ber suli-suli-itogega imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Deginbali, Bab-Jehová, Egipto-sorda-e-ur-e-nagmar-bipirmaknanaid bela oichosbalid. Degisoggu, ugak wis binnaa nadap gusmalad. Geb Egipto-sordamala sogdemalad: “Ar ade, Bab-Jehová Israel-dulemar-anar urwenaid. Bab-Jehová anmargi gwisgunaid. Degisoggu, Israel-dulemargi anmar wakinmarsun.” ");
INSERT INTO cuk_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ar Bab-Jehováʼdi Moisésʼga sogded: “Demar-birgi be-argan be oyoge, adi, demar gannaryob guegar. Geb degine, Egipto-sordamargi, e-urmar-napaginmaladgi, degi, e-sordamar-moli-birgi-sii-urwemaladgi demar arweoed.” ");
INSERT INTO cuk_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moisés e-argan demar-birgi oyoded. Oiboargu, demar gusgu-maidyob gannarse gunonikid. Egipto-dulemala wakinye sokarmalan-inigwele, ar demardi egi gwichigunonikid. Weyobi, Bab-Jehová, Egipto-dulemar demargi ogundisad. ");
INSERT INTO cuk_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Demar gusgu-maidyob gannarse gunonigu, urmar-napagined, sordamar-moli-birgi-sii-urwemalad, degi, bela Faraón-e-sordamar-bila-onomalad, wemala, Israel-dulemar-bareginnega-demargi-dogsamaladi, bela egi demar arwenonikid. Faraón-sordamar bela burgwismalad, wargwensaale gwen durgussulid. ");
INSERT INTO cuk_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ar Israel-dulemardi demargi obaksamalad, napa-dinnagwadgi nadapgusmalad. Demar gasdibir-matusulidyob e-dikar-nuedsik-mai, degi, e-sapiledsik-mai gusad. ");
INSERT INTO cuk_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","A-ibagine, Bab-Jehová, Egipto-dulemar-ganguedgi Israel-dulemar-abonosad. Israel-dulemala Egipto-sordamar-e-muimar demar-gakaba-omilede daksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israel-dulemar dakdegu, Bab-Jehová e-gangued Egipto-dulemargi sabsur-yolesa, nue Bab-Jehová-dobee itonadmalad, degine, Bab-Jehováʼgi bensuli gunonimalad. Amba deyob Bab-Jehová-mai-Moisésʼgi, bensuli gunonimarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Geb degidgine, Moisés, degi, Israel-dulemar we-namaked, Bab-Jehová-nug-ogannogega namakdemalad: “Bab-Jehová-nug-odummogega an namakoed, ar ibibayobi Bab-Jehová-emargi-nakwisad geger-daklege, deunni, molimar, degi, e-birgi-sigmalad, demargi ogundisgu. ");
INSERT INTO cuk_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","An-namaked, Bab-Jehováʼga an namaked. Ar Bab-Jehová an-ogannogedid, an-abonogedid. Bab-Jehová an-Bab-Dummadid, an a-e-nug odummogoed. We-Bab-Jehová an-bab-e-Bab-Dummadid, an a-e-nug ogannoged. ");
INSERT INTO cuk_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Bab-Jehová, dule-bila-onoged-sunsogedid. ¡Bab-Jehováʼye e-nug nugad! ");
INSERT INTO cuk_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Bab-Jehová Faraón-e-urmar-napaginmalad, degi, Faraón-sorda-bila-onomalad demargi odosad. Faraónʼga-sorda-semalad-e-dummagan-bur-nuegan, Demar-Ginnidye-nugadgi gundilesad. ");
INSERT INTO cuk_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Akwayobi wilasailase argwachamalad, degi, muu-wilasailad egi mulus nagusad. ");
INSERT INTO cuk_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","”Bab-Jehová, be-gargangued dutusulid, be-gargangued gandikidba maid. Bab-Jehová, be-garganguedba be be-isdarmalad ogilosad. ");
INSERT INTO cuk_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Be-gangued-dutusulidgi dulemar-begi-gwisgusmalad be ogilosad. Be-uluded be barmisgu, be-isdarmalad gaganyob gummakded. ");
INSERT INTO cuk_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Be-bunnogedgi be dii danar oambikunonikid. Demar-billigan gasdibir-matusulidyob megisad, muu-wilasailad bogidik nagusad. ");
INSERT INTO cuk_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","”Anmar-isdarmalad binsasmalad: ‘An bargaedse bareginnoye. An e-ibmar-suoedi, an mimioye, an egi yeer-itogedse, an mimioye. An es-suid, an egi onogoye, an-sunnagwad an wemar ogilogoye.’ ");
INSERT INTO cuk_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Bab-Jehová, ar be burwa-ogochadba, be demarse-dolegega imaksad. Gingwayobi dii-gandikidba-nukamakmaidgi dogdemalad. ");
INSERT INTO cuk_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Bab-Jehová, ¡bab-dummad-baid bebo wilubdaked sated! ¡Beyob-isligwaled, baid sated! ¡Beyob-dummadid, satebalid! ¡Be ibmar-gegerdakleged-imakedi, dobe-ito anmar-imaked! ¡Ar nabirid, be-nug odummolegergebed! ");
INSERT INTO cuk_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","¡Be-gangued be oyodgu, napa we-dulemar-dosad! ");
INSERT INTO cuk_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","”We-dulemar be abonosadi, be-sabedbali na be semaid. Be-ganguedbali, we-dulemar be-neg-swilidikidse na be sedoed. ");
INSERT INTO cuk_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dulemar-yar-baid-baidgi-bukmalad wisguarmalale, wawanmakdemaloed. Filistea-dulemar sulibinsa itodmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom-e-dummagan bela-bela dobgudmaloed. Moab-e-dummagan dobedbali, wawanmakdemaloed. Bela Canaán-dulemar dobedba duurmakdemaloed. ");
INSERT INTO cuk_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bab-Jehová, be-surgan-ganguedba we-dulemar bela-belad-gwakidmalodo. Bela we-dulemar dobgudmalodo. Bab-Jehová, be-gangued-abin we-dulemar akwayob geg sunmak sigmaloed. Bela be-dulemar-na-begadga-imaksad bela-obaksadse, we-dulemar bogidik ambikumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Bab-Jehová, be-megega na be yar-susadse, be-dulamar be sedoed. A-yargi, degisadegu-megega be anmar-imakoed. A-yar na be sisadid. Agi be megega, be-neg be sisad. ");
INSERT INTO cuk_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","¡Bab-Jehová degisadegu negsemai guoed!” ");
INSERT INTO cuk_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Faraón-urmar-napaginmalad, degi, moli-birgi-sii-urwemalad, Israel-dulemar-bargaega demargi-dogdemargu, Bab-Jehová amargi demar-arwega imaksad. Israel-dulemardi demargi napa-dinnagwadgi nadapi obaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Bab-Dummad-gayaburba-barsoged-bundor-María, Aarón-e-bunad. We-Maríaʼde, gar-panderetaʼye-nugad susad, geb namakded. Bela omegan-baigan gar-pandereta ogornadap gusmarmogad, eba dodonadap gusmarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","María ega weyob namaknadapid: “Bab-Jehová-nug-odummogega namakmar. Molimar, degi, e-birgi-sigmalad demargi ogundisa. Ibibayobi, Bab-Jehová Egipto-dulemargi-nakwisad geger-daklege.” ");
INSERT INTO cuk_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moisés, Israel-dulemar Demar-Ginnidye-nugadgi-bukwad sesa gusad. Nega-dulesulidgan-Shurʼye-nugadse sesad. Agine, ibapaa nanasmalad, gwen dii amissurgusmalad, ar dii sated. ");
INSERT INTO cuk_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Maraʼye-neg-nugadse modapmargu, agi-dii-nikadi, geg gobe gusmalad, ar ade, dii gagbisailad. A-ulale, a-neg Maraʼye onugsasmalad. Maraʼde sogleged, “gagbisailadye.” ");
INSERT INTO cuk_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Dulemar Moisésʼgi ichakwa sunmakarmalad, sognanai guarmalad: “¿Ar wede ibi anmar goboe?” ");
INSERT INTO cuk_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Geb degine, Moisés Bab-Jehováʼse bendakleged egichided. Agi, Bab-Jehová Moisésʼga sapi-bipi oyosad. A-sapi-bipi Moisés diise meted. Agine, dii sayee naded. Agine, Bab-Jehová Israel-dulemar-wilubdaksad. Deginbali, agi igi-na-nanamaloed-igar ega uksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Bab-Jehová Israel-dulemarga weyob sogded: “Ani an bemar-Bab-Dummad-Jehová gued. Ar bemar, an bemarga-ibmar-soged be nue itomalale, an-ibmar-abegedba be imakele, degi, an igar-bemarga-uksad be imakmalale, degine, an-igar-mamaidba be damalale, Egipto-dulemargi bonigan-dummagan-an-barmialidi, bemargi a-bonigan an barmidagosulid. Ar ade, ani an Bab-Jehová gued. Ar ani an bemar-nudakedid.” ");
INSERT INTO cuk_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Geb a-sorbali, Elimʼye-neg-nugadse modapmalad. Agi ambe-gakabo (12) dian ariomaid, degine, sapi-ogobgi-dakleged dulapaa-gakambe (70) bukwabalid. Agine, Israel-dulemar dii-naba ambikudapmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Bela Israel-dulemar Elimʼye-neg-nugadgi node gusmalad, geb nega-dulesulidganba-Sinʼye-nugadse warmakdapmalad. Sinʼde Elimʼye-neg-nugad-naid, degi, Sinaíʼye-neg-nugad-naid, amar-negabargi naid. Deunni, Egiptoʼgi nii-warbogus gaka-ibambe-gakatargus (15) noarmalad-akalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","A-nega-dulesulidgangi dulemar bela Moisésʼgi, degi, Aarónʼgi uluarmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israel-dulemar sogdemalad: “Ar Bab-Jehová Egipto-yargi anmar-oburgwismalana bur nabirinad. Webardi, anmar bormo-ebiris bormo san-ena, nue-immelegedse mas-gundaenad. Ar emidi, bemar we-nega-dulesulidganse bela ukudba-anmar-oburgwega be anmar-nialid.” ");
INSERT INTO cuk_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Geb degine, Bab-Jehová Moisésʼga sogded: “Bemarga an madu niba batedaged an imakoed. Degine, dulemar, unnila emigadbi madu-weemalaga, bane-bane neg-magaba nomalargebed. Adi, an wilubdakegalad, doamar an-ibmar-sogedba imakmalodibe, doamar imakosurbardibe. ");
INSERT INTO cuk_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ibanergwadgindina (6) dulemar ilabo-mergu e-negse-sedega madu weemaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moisés, Aarónʼbogwa Israel-dulemarga sogdemalad: “Sedogidba be wisgumaloed, Bab-Jehová, na e, Egipto-yargi bemar-onosye. ");
INSERT INTO cuk_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Degine, wakdaradbali, Bab-Jehová-e-gangued-yeerdakleged be dakmaloed, ar ade, Bab-Jehová bemar-egi-oimakbukmalad bemar-itosad. ¿Ar anmardi doasunna, ar emide, be anmargi oimakbukmargu?” ");
INSERT INTO cuk_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Degine, Moisés sogdebalid: “Sedogi Bab-Jehová bemarga san ukoed, adi, a-san be gunmalagar. Wakdardi madu ise-obinagwar bemarga ukoed, ar ade, Bab-Jehová egi be ulusmalad be-itosmalad. ¿Ar anmardi doasunna, anmargi be urwenaimargu? Ar bemar anmargi ulussulid, Bab-Jehováʼgi be ulusmalad.” ");
INSERT INTO cuk_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Geb degine, Moisés, Aarónʼga sogded: “Israel-dulemarga be soge: ‘Bela Bab-Jehová-asabin ambikudamar, ar ade, Bab-Jehová bemar egi-oimakbukwad bemar-itosad.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aarón Israel-dulemarga sunmakgwisgua, bela dulemar nega-dulesulidganba atakdemalad, agi mogir-imbaba Bab-Jehová-e-gangued-yeerdakleged nononikid. ");
INSERT INTO cuk_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Geb degine, Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Israel-dulemar angi oimakbukwad an itosad. Amar-ebo be sunmak, ega be soge: ‘Emi-sedogi be san gunmaloye, wakdardina, be madu gunmaloye, nue-immelegedseye. Adi, be wisgumalagarye, ani an Bab-Jehová guye, ani an bemar-Bab-Dummadye.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","A-sedogidgine, nuumar-codornizʼye-nugad nonimalad, bia Israel-dulemar-bukwadgi ena ambikunonimalad. Degine, wakdaradbali, Israel-dulemar-bukwad-dikarba dii bominonikid. ");
INSERT INTO cuk_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Dii-bomisad-dingudgu, sorba daklealid nega-dulesulidgan-napagi ibmar-dataragwad, dii-akwaga-binnisadyob-daklege omilede. ");
INSERT INTO cuk_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ar Israel-dulemar wissurmarsoggu, wede ibua, a-ular, a-dakarmalale, na muchub-muchub egisdedamalad: “¿Wede ibua?” Geb Moisés ega sogded: “We madu, Bab-Jehová bemarga uked, adi, be mas-gunmalagar. ");
INSERT INTO cuk_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Bab-Jehová bemarga soged, weyob bemar imakoye: Na be mergu-gunmaladba, wargwen-wargwen weenamaloye. Degine, na be be-neggi mergu-dule-nikadba, wala-walagwengi nibirbo-wilub-mergu weemaloye.” ");
INSERT INTO cuk_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israel-dulemala deyob imaksamalad. Gwen-gwen bur ichesur wesmalad, gwen-gwen bur ichee wesmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Deyob weemaloye-soglesadba wesmalad. Ar dule-ichesur-wesadga obichasulid, dule-ichee-wesadga akussurmogad. Na e-mergu gunnedba, wala-walagwen egad-egad wesmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Geb degine, Moisés Israel-dulemarga sogded: “Bemar bipisaale melle banedga we-masgunned be sabomalo.” ");
INSERT INTO cuk_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Degi-inigwele, dulemar abala Moisés-sogedba imaksasurmalad, abar banedga sabosmalad. Banedga-sabosmaladi, ei nusbiin gusad, bela nunu-yapan oiboalid. Geb degine, Moisés amargi nue-sae-itoded, ese uluded. ");
INSERT INTO cuk_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Na e-mergu-gunmaladbali, wakdaradba egad-egad weenaddamalad, ar ade, dad-diopisurgudele, dad-abin diree naddaed. ");
INSERT INTO cuk_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ibanergwadgindi (6), ilabo-wilub mas wesmalad. A sogledo, wala-walagwengi nibirbake-wilub wesmarye. Geb degine, neg-danar-danar-bukmalad-e-dummagan ibmar-gusad Moisésʼga sognadmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Agi, Moisés amarga sogded: “Ar weyob Bab-Jehová igar uksad. Oibosale, obunnoged-ibad. We-iba, Bab-Jehováʼgadid. Emi bemar mas-yobiedi, emi be yomalodo. Emi mas-dulebiedi, emi be mas dumalodo. Bemarga-mas-obinoedi, banedga be sabomaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ibmar-obichadi, Moisés-igar-uksadba sabosmalad, adi, oibosar gunmalagar. We-ibmar nungussulid, nusbiin gussurbalid. ");
INSERT INTO cuk_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Geb degine, Moisés sogded: “Emi obunnoged-ibad, Bab-Jehová-ibad. We-ibmar emi be gunmar. Ar emi-ibagi, we-ibmar, babatenai, degi, napagi-mellemai gwen be dakosurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Bemar sunna ibanergwa (6) we-ibmar weemaloed. Ar ibagugledgindina (7), obunnoged-ibad. A-ibagi, we-ibmar sate guoed.” ");
INSERT INTO cuk_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Degite, gwenna-gwennagwa ibagugledgine (7) wis ibmar-weenamalaga, node gusmalad. A-ibmar wessurgusmalad, ar ade, a-ibagi a-ibmar gwen daksasurgusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Geb degine, Bab-Jehová Moisésʼga sogded: “¿Ar wede sanagwadse an-igar-mamaidba, an bemarga-ibmar-sogedba be nanamaloye soge? ");
INSERT INTO cuk_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ani, Bab-Jehová, an bemarga ibagwen-obunnoged-iba uksanad. Agala, ibanergwadgine (6), an bemarga masgunned ibabo-wilub uksad. Degisoggu, ibagugledgine (7), bemar na e-neg-e-neggi megewilubmalanad, bemar na be-neggine noewilubsurmalanad.” ");
INSERT INTO cuk_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Geb degine, dulemar ibagugledgine (7) obunnosmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel-dulemala we-ibmar-weemaladi, bismalad: “Manáʼye.” We-ibmarde, e-gwag sipugwad, gagan-wawadikid-culantroʼye-nugad-e-gwagyobid, degi, madu-dibyaled achanis egi eoaledyob gulleged. ");
INSERT INTO cuk_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Geb sorbali, Moisés sogded: “Weyob Bab-Jehová bemarga igar uked: ‘Bormogi nibirbake be maná enomalo. Bemar be-waganga be nue sabomalo, adi, be-wagan dakmalaga, Egipto-yargi an bemar-onosmargu, igid-mas an bemarga nega-dulesulidganba uksa gusa.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Geb degine, Moisés Aarónʼga sogded: “Bormo gwagwen be sue, agi nibirbake be maná urboed. A-sorbali, Bab-Jehová-asabin be sioed, adi, bemar-waganga-oyogega be sabogoed.” ");
INSERT INTO cuk_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Igi Bab-Jehová Moisésʼga igar-uksa, deyob, Aarón, we-maná sabogega, bormogi Bab-Jehová-Dadganbo-Igar-Mesisad-Ulu-asabin sisad. ");
INSERT INTO cuk_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israel-dulemala birga-dulabo (40) maná-gundii gusmalad. Canaán-yargi dulemar-bukwadse-mosmaladse we-maná gundii gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Ibmar-wilubsaed-gomerʼgwensak nibirbake gued. Gomer-gwambeddi (10) ibmar-wilubsaed-efa-gwensak gued. ");
INSERT INTO cuk_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Bela Israel-dulemar nega-dulesulidgan-Sinʼye-nugadgi nodegusmalad, Bab-Jehová-ega-igar-ukmaidba, obunnomai-obunnomai nadapgusmalad. A-sorbali, Israel-dulemar dii-gobega Refidimʼye-neg-nugadgi ambikudapmalad. Agi dii sated. ");
INSERT INTO cuk_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Degisoggu, Moisésʼse sabsur egisdemarsunnad, ega sogdemalad: —¡Anmarga gobega be dii udage! Moisés dulemar-abin sogded: —¿Ibiga sabsur be anse dii egise? ¿Ibiga Bab-Jehová-wilubdakye be sogmala? ");
INSERT INTO cuk_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ar Israel-dulemar uku-uku itomarsoggu, Moisésʼgi uludmalad, sogdemalad: —¿Ibiga Egipto-yargi be anmar-onosa? ¿Ukudba-burgwega be anmar-onosa? ¿Anmar-mimmigan-oburgwega be anmar-onosa? ¿Anmar-ibdurganmar-oburgwega be anmar-onosa? ");
INSERT INTO cuk_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Geb degine, Moisés Bab-Jehováʼse binnasur goted, ega sogded: —Ar we-dulemarde, ¿igi an imakergebe? ¡Ar iche-napinad akwagi-makar an-oburgwemalanad! ");
INSERT INTO cuk_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Bab-Jehová Moisés-abin sogded: —Israel-dulemar-idu be nae. Israel-girmar-dummagan gwenna-gwenna beba be sedoed. Nilo-diwar-bibyosad-gaapoled, be sedbaloed. Emigi be nadeen. ");
INSERT INTO cuk_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Horeb-yargi, akwa-dummad-walik an be-asabin gwisguoed. Akwa-dummad be bibyosale, agi dii aryodagoed, adi, dulemar a-dii gobmalagar. Moisés, Israel-girmar-dummagan-e-dakbukwad-asabin deyob imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moisés a-neg Meribaʼye onugsasad, ar ade, agi Israel-dulemar ulusad. Degine, a-neg Masahʼye onugsasbalid, ar ade, agi Israel-dulemar Bab-Jehová-wilubdaksamalad, deun sogsamargu: “¿Ar wede Bab-Jehová anmarba gudii, anmarba gudisuli?” ");
INSERT INTO cuk_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalec-dulemar, Israel-dulemargi bila-onogega Refidimʼye-neg-nugadse nadmalad. ");
INSERT INTO cuk_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Agine, Moisés Josuéʼga sogded: “Bila-ononaega, machergan war-wargwen sue-sue be imake. Be nae, Amalec-dulemar-ebo be urwenae. Banedsega andi yar-dummad-birse Bab-Dummad-gaapoled argangi-gani an naoed.” ");
INSERT INTO cuk_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué igi Moisés ega soge, aba imaksad, Amalec-dulemarbo urwenaded. Ar degidgine, Moisés, Aarón, degi, Hur, yar-dummad-birse nadmalad. ");
INSERT INTO cuk_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Moisés, e-sakwa onakwidele, Israel-dulemar-urwenanaidi, e-isdarmaladgi obitedamalad. Ar Moisés e-sakwa-odedele, Amalec-dulemar obitedamalad. ");
INSERT INTO cuk_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ar Moisés-e-sakwa geggusdaed, degi, Moisés-sigega ega akwa amismalad. Moisés-sigisgua, Aarón, Hur-ebogwa Moisésʼga sakwa-gasmalad, wargwen sakwa-gwensaksik, baiddina sakwa-baidsikmo. Weyobi, dad-argwanedse, Moisés-sakwa onakwar, nue-innikii gasmalad. ");
INSERT INTO cuk_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Weyob Josué, Amalec-dulemar-sordamargi es-suidgi-oburgwar nakwisad. ");
INSERT INTO cuk_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Geb degine, Bab-Jehová Moisésʼga sogded: “We-bila-onolesad gardagi narmak, adi, insadii gumalagar. Degine, Josuéʼga be sogbalo: ‘Amalec-dulemargi mer bar binsamalagala, an bela obelogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Agi, Moisés Bab-Jehováʼga-ibmar-ogumakar-ukleged-aila sobsad. A-aila, “Bab-Jehová an-banderye onugsasad.” ");
INSERT INTO cuk_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Agi, Moisés sogded: “Bab-Jehová-negdakmaidgi Amalec-dule gwisgunonisoggu, Bab-Jehová, degisadegu, Amalec-e-wagan-danikidbali, egi bila-ononai gudoed.” ");
INSERT INTO cuk_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetro Moisés-e-saka, Madiánʼgi dule-irwa-Bab-Dummadse-goledga maid. We-Jetroʼde, igi Bab-Dummad Moisés-bendaksa, bela wisgusad. Degine, igi Bab-Dummad Israel-dulemar-bendaksabali, bela wisgusbalid. Deginbali, wisgusbalid, igi Bab-Jehová Israel-dulemar Egipto-yargi onosbali. ");
INSERT INTO cuk_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moisés Faraónʼse-nadapidgi, e-saka-Jetroʼse e-ome-Séfora barmisgusad. Jetro na e-sisgwa-Séfora e-neggi abingasad, ");
INSERT INTO cuk_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","degine, Moisés-masmala-warbogwad abingasbalid. Wargwen Gersónʼye nugad, ar ade, Moisés sogsa gusad: “We-yar-baidgi an we-yarginedsulid gudiiye.” ");
INSERT INTO cuk_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Baid-machigwadi, Eliezerʼye nugad, ar ade, Moisés sogsa gusbalid: “An-bab-e-Bab-Dummad an-bendaknonikid, Faraón-es-suidgi an-onosad.” ");
INSERT INTO cuk_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moisés nega-dulesulidganba Bab-Dummad-yar-walik dulemar-oambikudapid. Ase, Jetro, Moisés-e-ome, degi, e-masmala-warbogwad nade gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetro, Moisés-owisos gusad: “Ani, an be-sak-Jetro, be-ome, degi, be-masmala-warbogwadmala, anmar be-dakdanimalad.” ");
INSERT INTO cuk_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moisés e-saka-abin noar gusad. E-abin dulluu imaksad, degine, degiteye-sogega ei-wagar usad. Sunmaksamargua, e-dordoneggi dogdemalad. ");
INSERT INTO cuk_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Agi, Moisés e-sakaga bela sogsad, igi Bab-Jehová Israel-dulemar-bendakega Faraón-imaksa, degine, igi Bab-Jehová Egipto-dulemar-imaksabali. Degine, igi igarba Israel-dulemar wiledani-gusmarbargua, Bab-Jehová Israel-dulemar-bendaksabali. ");
INSERT INTO cuk_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetro Bab-Jehová Israel-dulemargi e-sabgued-nue-oyosgusadba, degine, Egipto-dulemar-ganguedgi Israel-dulemar-bendaksagusadba, bela-bela weligwar-itosad. ");
INSERT INTO cuk_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetro sogded: “Bab-Jehová Faraónʼgi, degi, Egipto-dulemar-ganguedgi, bemar-bendaksad. Degine, bemar-Israel-dulemar Egipto-dulemar-be-wiodimaladgi, Bab-Jehová bemar-onosad. A-ular, Bab-Jehová-e-nug odummolesun. ");
INSERT INTO cuk_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","”Deginbali, Faraón dulemar-baisursunnagwadiyob bemar-imaksabalid. Ar emigindi, Bab-Jehová Egipto-dulemar-sabsur-imaksadba nue an wissunnad, we-Bab-Jehová, baigan-bab-dummadye-sogmaladba bur-dummadid.” ");
INSERT INTO cuk_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Agi, Jetro ibdurgan-wargwen Bab-Dummadga-ogumakar-ukega susa gusad. Deginbali, Bab-Dummadga-ukbaliga, ibmar-baigan senonibalid. Geb a-sorbali, Aarón, degi, bela Israel-girmar-dummagan, Moisés-e-sakaba Bab-Dummad-asabin mas-gunnadmalad. ");
INSERT INTO cuk_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Banedgine, Moisés Israel-dulemarga igarmar-gwatirnanaid-nabogega signonikid. Ar ade, dulemar na gwatirismalale, Moisésʼse wakdaradba degi-iirmakmai osedoddaed. ");
INSERT INTO cuk_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Jetro dakargu, Moisés arbaed-dummad imake, Moisésʼga sogded: —¿Ar ibiga be bela we-arbaed be imake? Emide, dulemar bese wakudaryalaba iirmakmai osedoddamalad. ¿Ar ibiga bebi walagwen we-dulemarga be igar naboge? ");
INSERT INTO cuk_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moisés e-saka-abin sogded: —Ar ade, dulemar Bab-Dummadse igar-amimalaga anse nonidamalad. ");
INSERT INTO cuk_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Na-ebo gachimakarmalale, anse nonidamalad, dakega, doa bur-nabir soge. Geb an Bab-Dummad-igargan-mamaid ega an sogdaed, degine, igi-Bab-Dummad we-igargangi anmar-odurdakmai an ega sogdabalid. ");
INSERT INTO cuk_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Geb degine, e-saka-Jetro Moisésʼga binsaed ukded: —We-be-deyob-imakedi, nuedsulid. ");
INSERT INTO cuk_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ar ade, be geggus daed, dulemar-bese nonidamarmogad geggus damarmogad. Be-arbaed-imakedi begi obined. Bebi-wargwen bela be imakosurguoed. ");
INSERT INTO cuk_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Binsaed-an-bega-ukoedi, nue be itogo. Bab-Dummad beba gudiguoed. Be-dulemar-anar Bab-Dummad-asabin be gwisguoed, bonigan-mamaid ega be sogoed. ");
INSERT INTO cuk_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Be-dulemar igar-mamaidgi be odurdako, degi, igar-mamaidba-imaked be odurdakbalo. Deginbali, ega be sogbalo, igi nanamalargebe, degi, ibumar imakmarbaloe. ");
INSERT INTO cuk_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Bedina, deyob be imakegala, neggweburgi dulemar-nabir-ibmar-imakmalad be suo: Dulemar Bab-Dummad-dobee-nanadimalad, dulemar wagar-darbodasurmalad, dulemar ibmar-atursaaledgi mani-onosurmalad, a-dulemar be suoed. Amar gwenna-gwennagwa, dulemar-miligwenad-e-dummadga (1,000) be imakoed, baigan dulemar-dulataled-e-dummadga (100) be imakoed, baigan dulemar-dulabo-gakambegwad-e-dummadga (50) be imakoed, degi, baigandi e-ambegwad-e-dummadga (10) be imakmogoed. ");
INSERT INTO cuk_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","”Wemala, dulemarga igar-nabodii gudoed. Igar-dummadile, bese senonikoed. Igar-bipigwardi, emar na nabomaloed. Weyobile, arbaed-dummad be imakosulid, ar wemala be-bendakmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ar Bab-Dummad bega sogdibe, an bega-ibmar-sognaid be imakye, ar weyob be imakele, be unniguoed, degine, dulemarmoga, weligwaledgi na e-negse namarmogoed.” ");
INSERT INTO cuk_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moisés e-saka-ega-soged itosad, a-sogedba bela imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","A-ular, Moisés Israel-dulemar-bur-nabir-ibmar-imakmalad susad. Amar, dulemar-miligwenad-e-dummadga (1,000) onugsasad, baigan, dulemar-dulataled-e-dummadga (100) onugsasad, baigan, dulemar-dulabo-gakambegwad-e-dummadga (50) onugsasad, degine, baigandi, dulemar-e-ambegwad-e-dummadga (10) onugsasmogad. ");
INSERT INTO cuk_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","We-dulemar Israel-dulemarga igar-nabogedga degisadegu gudmalad. Igar-bur-dummagan Moisésʼse sesdamalad. Igar-burwiganadi, emar na igar nabodamalad. ");
INSERT INTO cuk_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Degi-neggusad-sorbali, Moisés e-sakaga sognai gualid, degimaloye. Degi, geb e-saka na e-negse gannar aligusad. ");
INSERT INTO cuk_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israel-dulemala Egipto-yargi nii-warbaagus noalid-akale, nega-dulesulidgan-Sinaíʼye-nugadse modapmalad. ");
INSERT INTO cuk_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Refidimʼye-neg-nugadgi-bukwa-noargu, nega-dulesulidgan-Sinaíʼye-nugadse modapmalad. Agi, yar-asabin ambikudapmalad. ");
INSERT INTO cuk_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Agine, Moisés Bab-Dummadbo-abinguega yar-birse nakwisad. Agi, Bab-Jehová ese goted, ega sogded: “Weyob Jacob-e-waganga be sogoed, Israel-dulemarga: ");
INSERT INTO cuk_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Be-sunnad be daksamalad, igi an Egipto-dulemar-imaksa, degine, igi an wese bemar-seali. Igi sulubagi e-mimmigan-ogukuega, sabedgi e-mimmigan-sakanba-gasa sesdae, deyobiyob an wese bemar-senonikid. ");
INSERT INTO cuk_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Degisoggu, ar bemar bela an-sogedba nanaele, degine, an bemar-ebo igar-mesnaidba be daele, bemar dulemar-baiganba bur angadga guoed. Ar bela we-napneg angadsoggu, bemarbina-bur-itogerba an guoed. ");
INSERT INTO cuk_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Bela bemar dule-irwa-Bab-Dummadse-gormaladga gumaloed, be-dulemar islidikidbi angadga gumaloed.’ Deyob Israel-dulemarga be sogoed.” ");
INSERT INTO cuk_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moisés gannar Israel-dulemarse nonikid. Agi, Israel-girmar-dummaganse gochad. Geb degine, Moisés bela ega sogded, igi-Bab-Jehová ega igar uksa. ");
INSERT INTO cuk_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Geb degine, Israel-dulemar bela na balibi sogdemalad: “Bab-Jehová anmarga-igar-uksad, a-sogedba bela anmar imakodo.” Moisés dulemar-ega-sogsad Bab-Jehováʼga sognai gusad. ");
INSERT INTO cuk_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Agi, Bab-Jehová ega sogded: “Nue be an ito, an bese mogir-guduregedba nonikoed, adi, an-bebo-sunmaknaid dulemar itogega. Adi, deyob dulemar degisadegu begi bensuli gumalagar.” Moisés dulemar-ega-sogsad gannar Bab-Jehováʼga sognai gusad. ");
INSERT INTO cuk_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Bab-Jehová Moisésʼga sogded: “Emi, be Israel-dulemarse nao. Emi, degi, banedgi, Israel-dulemar an-nug-odummomalaga guakwaa isligwar-bukwa be imako. Deginbali, swilidik-guega mor na enukmarbalo, ");
INSERT INTO cuk_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","degi, bela guakwaa ibapaagwadga ambikumalo, ar ade, ani, Bab-Jehová, ibapaase Sinaí-yargi an aidegoed. Bela Israel-dulemar an-dakmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","”Melle dulemar yarse nakwemalaga, yar-dikarba be galu bela ebiris nasikoed. Deginbali, ega be sogo, we-yargi nue-binsaed-nikaa be damaloye, degine, melle a-yarse nakwemarbaloye, degine, melle a-yar-walikaa namaloye. Ar doa-dule a-yarse warmaksale, oburgwelegoye. ");
INSERT INTO cuk_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Dule-wargwensaale dule-oburgwilegoedse achaosulid. Ar dule-oburgwilegoedi, akwagi-makar oburgwilegoed, sigugi-makar imaklegodibe. Ar duledibe, ibmar-durgandibe, wede dula-gudii imaklegosulid, oburgwilegedsegad. Unnila, dulemar sibad-wawaad-machered-e-bebe-gollalirbi, yarse nakwenamaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moisés yar-birgi-gudiid aidenonikid. Agi, Moisés, Bab-Dummad-e-nug-odummomalaga, guakwaa isligwale dulemar-urbisad. Dulemardina, na e-mor enuksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Agi, Moisés dulemarga sogded: “Guakwaa ibapaagwad-idu ambikumalo, degine, melle na be be-omese gormalo.” ");
INSERT INTO cuk_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ibapaa-gusadgi neg-oiboargu, mar-goledi bela-bela itoleged, degine, mar-dakarmakmaidi bela-bela daklebalid. Yar-birgi, mogir-gudure naid. Gar-trompeta-binnasur-goted-itosmargua, bela-dulemar-bukwadi dobedba wawanmakdemalad. ");
INSERT INTO cuk_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Geb degine, Moisés bela-dulemar-bukwadi Bab-Dummad-ebo-abingunamalaga yarse sesad. ");
INSERT INTO cuk_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinaí-yalagi bela waa bupurmakmaid, ar ade, agi Bab-Jehová soo-abargi aidenonikid. Bela-bela waa yargi bupurmakmaisoggu, soo-saila-gasiiyob dakleged. Bela yar-siidi binnasur giglimaksiid. ");
INSERT INTO cuk_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Gar-trompeta-goledi aka bur bule gangumai gualid. Moisés sunmakdele, Bab-Dummaddi mar-goledyob abinsadaed. ");
INSERT INTO cuk_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Bab-Jehová bur Sinaí-yar-matusulidse aidenonikid. Geb degine, Bab-Jehová Moisésʼga sogded, we-yar-matusulidse ese dagye. Agi, Moisés nakwisad. ");
INSERT INTO cuk_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Geb degine, Bab-Jehová Moisésʼga sogdebalid: —Moisés, be aidenae. Dulemarga be sogna, galu-nagusadgi melle obakmalo, melle an-dakedgi binsamalo. Ar dulemar, deyob-obakele, bukidar burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ar dule-irwa-anse-gormalad amba anse warmakmar-inigwele, na e-san ise-bagagwar urukmalargebed. Ar degisulile, anse ogilolemogoed. ");
INSERT INTO cuk_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moisés Bab-Jehová-abin sogded: —We-dulemar we-Sinaí-yarse nakwebiguosurmalad, ar be anmarga igar uksad, ‘galu be emakmaloye, ar ade, wede neg-islidikidga imaklegoye.’ ");
INSERT INTO cuk_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Bab-Jehová Moisésʼga sogdebalid: —Be nae, be aidenae. Aarónʼga be sogna, beba yar-birse nakwedaye. Dule-irwa-anse-gormaladdi, degi, dulemar-baigandi, melle anse nakwedgi binsamaloye. Ar nakweye-sogmalale, anse sabsur-imaklemaloed, anse ogilolemaloed. ");
INSERT INTO cuk_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moisés yar-birgi-gudiidgi aidenonisunnad. Geb bela Bab-Jehová-ega-sogsad Israel-dulemarga sognonikid. ");
INSERT INTO cuk_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Bab-Dummad sunmakded, weyob sogded: ");
INSERT INTO cuk_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ani an be-Bab-Dummad-Jehová gued. Bemar Egipto-yargi maiga-wilebukmargu, ani an bemar-onosadid. ");
INSERT INTO cuk_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Melle bab-dummad-baid an-asabin be nikumalo. ");
INSERT INTO cuk_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Melle be ibmar-wilubgan sobmalo, nibneggi ibmar-nikad-wilubgandibe, napneggi ibmar-nikad-wilubgandibe, demargi ibmar-nikad-wilubgandibe. ");
INSERT INTO cuk_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","A-ibmar-wilubgan-asabin dulluu be imakosurmalad, degine, Bab-Dummadyob ese be golosurmalad. Ar ade, ani an be-Bab-Dummad-Jehová gued. An be-Bab-Dummad gadi-nobguedid. Ar an dule-isganamar-isdarsunna-dakmalad sabsur-odurdakedid. Degi, e-mimmigan, e-wagan, e-wagan-yokorbarmaladsega an sabsur-odurdakbalidid. ");
INSERT INTO cuk_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ar dulemar-an-sabmaladdi, dulemar-an-Igarmar-Mamaidba-nanamaladdi, an bela-e-waganmar-danimaloed e-ibe nue-sabguedid. ");
INSERT INTO cuk_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Melle be-Bab-Dummad-Jehová-nug yogasaar be obaro. Ar dule yogasaar Bab-Dummad-nug obarisale, a-dule, Bab-Dummad-Jehováʼse sabsur-odurdaklegedsegad. ");
INSERT INTO cuk_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Obunnoged-ibagi be obunnogo, adi, a-ibagi, be Bab-Dummad-e-nug odummogegar. Igi be-Bab-Dummad-Jehová bega Igar-uksa, aba be imako. ");
INSERT INTO cuk_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ibanergwa (6) be arbaoed. A-ibagangi bela ibmar-imakbied be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ibagugledgindi (7), obunnoleged-ibad, be-Bab-Dummad-Jehová-e-nug-odummolegedid. A-ibagi bipisaale be arbaosulid. Be-machi, be-bunagwa, bega-arbaed-machered, bega-arbaed-ome, be-moli-bebe-nikad-alugwasualed, be-moli-uayasuid, be-ibdurgan, a-ibagi, arbaosurmarmogad. Deginbali, dule-be-yarginedsulid be-negyagi-gudiid, a-ibagi, arbaosurmarmogad. Ar obunnoged-ibagi igi be obunnomoga, beyobi bega-arbaed-machered, degine, bega-arbaed-ome, obunnomarmogoed. ");
INSERT INTO cuk_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ar ade, Bab-Jehová ibanergwa (6) arbasad. A-ibagangi we-ibmarmar obinnisad: Nibneg obinnisad, napneg obinnisad, demar obinnisad, degi, bela agi ibmarmar-bukwadi obinnisbalid. Geb degi, ibagugledgindi (7), Bab-Jehová obunnosad. A-ulale, Bab-Jehová, ibagugledgi (7) ise-nued-binsasad. A-ibagi sogsad, we-iba, iba-islidikidye. ");
INSERT INTO cuk_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Be-daedbali, be-bab-nug-odummodii, degi, be-nan-nug-odummodii be nanamalo. Adi, be-Bab-Dummad-Jehová we-napneg-bega-uknaidgi sereddii be megegar, degi, bela bega ibmar-nueganbi gubaligar. ");
INSERT INTO cuk_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Melle be dule-oburgo. ");
INSERT INTO cuk_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Melle be be-abirginsulid-ebo galagwensuli nanao. ");
INSERT INTO cuk_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Melle be ibmar-atursao. ");
INSERT INTO cuk_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Melle be gakansaar aimargi sunmako. ");
INSERT INTO cuk_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Melle be dule-baid-ibmarbina be sogo: Dule-baid-negbina, dule-baid-omebina, dule-baid-mai-macheredbina, dule-baid-mai-omebina, dule-baid-moli-bebe-nikad-alugwasualedbina, dule-baid-moli-uayasuidbina. Bipisaale dule-baid-ibmarbina be sogosulid.” ");
INSERT INTO cuk_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Bela Israel-dulemala e-sunnagwad mar-gollomakmaid itosmargua, degine, gar-trompeta-binnasur-goled itosmarbargua, deginbali, mar-dakarmakmaid daksamarbargua, degi, yar waa-moodo-siid daksamarbargua, Israel-dulemar nue-dobee itodmalad, wawanmakdemalad. Degisoggu, yargi bannabaa ambikusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Agi, Moisésʼga sogdemalad: —Be anmarga sunmake, anmar be-itogoed. Bab-Dummaddi melle anmarga sunmako, abakale, anmar burgwialile. ");
INSERT INTO cuk_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moisés Israel-dulemar-abin sogded: —Melle be dobgumar. Bab-Dummad bemar-wilubdakega bemarse nonikid, adi, bemar, degisadegu Bab-Dummad-dobee nanamalagar, adi, melle be isgumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Israel-dulemardi, Moisés mogir-guduregedgi-Bab-Dummad-maidse-nadedi bannabaa dakbuk gusad. ");
INSERT INTO cuk_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Bab-Jehová Moisésʼga sogded: “Israel-dulemarga weyob be soge: ‘Nibneg-akale an bemarbo sunmaksad bato be daksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Melle bemar orgi-ibmar-sobaled, manigi-ibmar-sobaleddibe, be-bab-dummadga anyob be imakmalo. ");
INSERT INTO cuk_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","” ’Bab-Dummadga-ibmar-ogumakar-ukleged-aila-sobega, anga be napa sobmaloed. A-ailagi be we-ibmarmar ukmaloed: Be-sibad-wawaadmar, sibadmar, degi, be-moli-bebe-nikamalad, anga be ogumakar ukmaloed. A-ailagi be anga ibmarmar-ukmaloedi, dulemar-e-isgued-eliedga uklegoed. Deginbali, a-ailagi be anga ibmarmar-ukmaloedi, bemar-anbogwa gwenatigwar-gudii gumalaga, degi, bemar na gwenatigwar-gudii gumalaga uklebaloed. ” ’Bia an-nug ebinsalebi an abegoe, ase an nonikoed, agi ise-nued an begi binsanonikoed. ");
INSERT INTO cuk_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ar bemar anga ibmar-ogumakar-ukleged-aila-akwa be sobbiele, unnila be akwamar-sobarsulid urbe-urbe be imakmalo, ar ade, bemar, akwa esgorogi sobdele, wede bar ibmar-ogumakar-ukleged-aila-nuedga guosulid. ");
INSERT INTO cuk_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Degine, anga ibmar-ogumakar-ukleged-aila melle arsan-nika imako. Ar bemar agi nakwialile, be-abgan daklego-itole.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Bab-Jehová Moisésʼga sogdebalid: “We-Igarmar Israel-dulemarga be ukoed: ");
INSERT INTO cuk_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","‘Be Hebreo-dule-mai baksale, unnila, bega birganergwa-arbaega (6) be imakoed. Birgagugledgi (7) be ollor-imakoed. We-dule, e-arbasadgi, bipisaale gwen bennuklegosulid. ");
INSERT INTO cuk_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","” ’We-mai-baklesadi, bese omesuli nonikile, walagwen gannar naoed. Ar bese ome-nika-nonikile, e-omebo gannar naoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","” ’Mai-e-ibed e-maiga ome-uksale, ome ega machimala-baksale, bunamala-baksardibe, ome, degi, e-mimmigan, e-mai-ibedgadga guoed. Maidina, walagwen gannar naoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","” ’Ar mai, na e-ibed-sabedbali, na e-ome-sabedbali, degi, na e-mimmigan-sabedbali, sogele, an yapa naye, ");
INSERT INTO cuk_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ar adi, e-ibed, dummagan-igar-nabomaladse e-mai-sedoed Geb yawagaksedibe, yawagak-dikarsedibe, sedoed. Agi esgoro-swichwigwadgi e-uaya udgoed. Geb agi, a-dule ibed-e-maiga degisadegu gunonisunnoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","” ’Ar dule-wargwen na e-bunagwa maiga-guega manigi uksale, we-bunagwa-ollor-imaklegega, mai-macherganyob imaklegosulid. ");
INSERT INTO cuk_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","” ’Dule-wargwen-bunagwa-baksad eginsur-bunagwa-dakele, nikubisulile, sunna Israel-dule-baid nabir manigi bunagwa-onogega imakoed. Nikubisurgussoggu, bipisaagwale, Israel-dulesulidga manigi ukosulid. ");
INSERT INTO cuk_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","” ’Dule bunagwa-baksadi, e-machi-ebo-nikuega ega ukele, na e-sisgwayob we-bunagwa-sedii guoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","” ’Dule bunagwa-maiga-baksadi, a-bunagwa-nikusale, a-sorba, geb ome-baid-nikunonibalile, we-bunagwa-idualedga: Mas-ega-uklegedi, amba deyob ega ukdii guoed. Mor-ega-uklegedi, amba deyob ega ukdii gubaloed. Degine, amba ebo gudiidgine, ese gordii gubaloed. ");
INSERT INTO cuk_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","” ’Ar e-sui bunagwaga we-ibmar-sogbaagwad imaksulile, bunagwa sunna na e-itolegedba nabier naoed. Onolegega, bipisaale dule-baid we-bunagwa-anar bennukosulid, maniginsuli binsa na e-itolegedba nooed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Bab-Jehová Moisésʼga sogdebalid: “Dule-wargwen dule-baid-sabsur-naibisasadba oburgwisar, we-dule, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","”Ar dule-emar-oburgwisad yamo-imaksasulile, Bab-Dummad-sogedba burgwisale, we-dule, bega an neg-sorba-sogoedse, dukunaoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","”Ar dule, sae-itogedba dule-baid-oburgwisale, anga-ibmar-ogumakar-ukleged-ailase dukunadele, we-dule, amba be sunaedsegad, degine, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","”Dule e-bab-naibisasale, e-nan-naibisasdibe, we-dule, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","”Dule, dule-baid-gasale, dule-baidga manigi dule-galesad-uksale, igidibe, amba e-walik-gales-sii daklesdibe, we-dule-emar-gasad oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","”Dule e-bab-ukabsasale, e-nan-ukabsasale, we-dule, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","”Na ebo-urwenaidgi, dule akwagi-makar dule-baid-naibisasale, igidibe, argangi sabsur-sarsosadgi naibisasdibe, oburgwissulile, ar gasgindi mesisale, ");
INSERT INTO cuk_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","we-dule-naibigusad suar-gaapoledgi nabir nanagusardina, geb agi soglegoed, we-emar-naibi-imaksadi oburgwilegosurye, baisurye. Deyob soglego-inigwele, dule-emar-naibi-imaksad, bela ega inadi bennukoed, degine, arbassulid-nukad bela bennukbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","”Dule suargi na e-mai-machered-sarsosale, e-mai-ome-sarsosdibe, degidba oburgwisale, we-dule sabsur-odurdaklegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ar e-mai-sarsolesad, ibagwenadgi, ibabogindibe, nabir ugakgusale, we-mai, e-ibedgadsoggu, e-ibed sabsur-odurdaklegosulid. ");
INSERT INTO cuk_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","”Machergan urwenanaidgi ome-gurgin-nikad-naibisasale, ei igarba-mellegega imaksale, ar omedi dogdar akar-gussulile, e-sui igi-mani egi gadagoedba, dule-ome-sarsosad deyob bennukergebed. Dulemar-ega-igar-nabomalad e-sui-mani-nug-egisnaid nabir-itomalale, deyob imaklegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","”Ar ome apor-naibigusardi, weyob imaklegoed: Ome-burgwisar, dule oburgwilemogoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Dule, ome-ibe ibya-nailik naibisasale, ibya-nailik ei naibisalemogoed. Dule, ome-ibe nugar-gagwen bichisalnugar-gagwen ei bichilemogoed. Dule, ome-ibe argan-nailik naibisasale, argan-nailik ei naibisalemogoed. Dule, ome-ibe nag-wargwen naibisasale, nag-wargwen ei naibisalemogoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Dule ome-ogumaksale, ogumaklemogoed. Dule, ome-naibisasale, deyob naibisalemogoed. Dule, ome-sarsosale, deyob sarsolemogoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","”Dule na e-mai-machered ibyagi-sarsosale, e-mai-omegwa-ibyagi-sarsosdibe, ei ibya onosale, e-ibed ei-ibya-gwagwen-onosad-ular, e-mai-ollor-imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","”Ei nugar-gagwen-bichisale, e-ibed ei-nugar-bichisad-ular, e-mai-ollor-imakoed.” ");
INSERT INTO cuk_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Moli-bebe-nikad-machered dule-macheredgi-yolesale, omegindibe, degidba, dule-oburgwisale, we-moli, akwagi-makar oburgwilegoed. E-san, gullegosulid. Moli-e-ibeddi oakalolegosulid. ");
INSERT INTO cuk_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","”Ar moli-ibed bato wisilegusgu moli-bebe-nikad-machered dulemargi-yoledigua, degine, e-ibed gwen edichasuli, we-moli dulegi yolesdibe, dule-oburgwisale, we-moli akwagi-makar oburgwilegoed. Geb moli-ibed, akwagi-makar oburgwilemogoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","”Degi-inigwele, moli-bebe-nikad-ibed na san-bendakegala, mer oburgwilegega, egi-mani-galegoed, bennukoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","”Moli-bebe-nikad machi-gwensakgi-yolesdibe, bunolo-gwensakgindibe, amba we-igar-maidba imaklegoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","”Ar moli-bebe-nikad-machered mai-macheredgi yolesdibe, mai-omegindibe, we-moli, akwagi-makar oburgwilegoed. Degine, moli-ibed mani-gwadulagwen-gakambe (30) mai-ibed-bennukoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","”Dule-wargwen dia egaar sisale, igidibe, yaa-dummad dii-sigega akwisdibe, a-yaa edissuli sisale, agi moli-bebe-nikad-alugwasualed argwachale, moli-uayasuid-argwachadibe, ");
INSERT INTO cuk_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","dia-ibed moli-ibed-bennukoed, geb degi, ibmar-dula-burgwisad suoed. ");
INSERT INTO cuk_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","”Moli-bebe-nikad-wargwen baid-moli-bebe-nikad-machered-oburgwisdibe, moli-dulad manigi uklegoed, we-mani na ebo negabar mimioed, degine, moli-burgwisad-e-san negabar mimimarbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","”Ar dule wisirdi, we-moli-bebe-nikad-machered gadi-urwe, degite, e-ibed moli-gwen-edichasuli, moli-gadi-urwed-ibed, moli-bebe-nikad-machered-burgwisad-ibedga moli-bebe-nikad-machered-dulad ega wargwen ukoed. Moli-gadi-urwed-ibed, moli-burgwisaddi susunnoed.” ");
INSERT INTO cuk_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Dule, moli-bebe-nikad-alugwasualed-wargwen atursasale, sibad-wawaad-atursasdibe, geb oburgwisdibe, igi, manigi-uksadibe, moli-atursasad-ular, moli-bebe-nikad, walatar e-ibedga ukoed. Sibad-wawaad-anardi, sibad-wawaad-walabake ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","”Dule-atursaed mutik ibmar-atursanai-daklesale, agi onaibisalesale, degi, burgwenonikile, we-dule-ibmar-e-ibed, dule-oburgwissuliyob daklegoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","”Ar ibmar-ibed ibgin dule-atursaed-oburgwisardi, egi ataklegoed, we-dule, dule-oburgwisye. ”Dule-ibmar-atursasadi, ibmar-atursasad-wilub bennukergebed. Ar ibmar-atursasad-bennukega mani satele, bennukega, maiga-guega na dukin manigi ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","”Ibdurgan-atursalesad amba-dula dule-atursasad-neggi-gudii daklealile, dule-ibdurgan-atursasad ilabo-wilub ukoed: Moli-bebe-nikad-machered-alugwasualeddibe, moli-uayasuiddibe, sibad-wawaaddibe, ilabo-wilub e-ibedga ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","”Dule, e-ibdula gagan-maega nainuse sesale, uva-digalesse sesdibe, geb e-ibdurgan, dule-baid-nainugi gagan-masale, ibdula-ibed, e-nainugi-gwagmar-weleged-bur-nuegangi nabogoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","”Dule-wargwen ikomar-ogumakega soo-ogasale, we-soo orosgi-dakleged-trigo-digar-naidse warmaksale, igi, trigo-danar-weles-bukwadse warmaksale, igi, nainugi-ibmar-digarnaid ogumaksadibe, dule-soo-ogasad, bela dule-baid-ibe-ibmar-ogumaksad bennukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","”Dule, nuedgi dule-baidga na e-mani, ega-sabogega uksadibe, e-ibmar-nued-gargerbad ega-sabogega uksadibe, we-dule-baid-neggi we-ibmar atursalesale, dule-ibmar-atursasad-galesadi, ilabo-wilub bennukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","”Ar dule-ibmar-atursasad-daklessulirdina, dule-neg-ibed dummagan-igar-nabomalad-asabin seledoed, adi, daklegega, abakale e ibmar-atursasdibe, atursassurdibe. ");
INSERT INTO cuk_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","”Dulemar-ebogwad sogmalale, we-ibmar angadye: Moli-bebe-nikad-alugwasualeddibe, moli-uayasuiddibe, sibad-wawaaddibe, mordibe, ibi-ibmar-yoggusaddibe. We-dulemar-ebogwad, dummagan-igar-nabomalad-asabin namaloed. Ar doa bur ibmar-atursas dakledagoe, a-dule, ilabo-wilub dule-baid-bennukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","”Dule-wargwen bensulidgi dule-baidga ibdurgan uksale: Moli-uayasuid ega akwega uksadibe, moli-bebe-nikad-alugwasualeddibe, sibad-wawaaddibe, we-ibmar-ega-uksad burgwenonikile, naibigunonidibe, dule-gwen-daksasuli ei atursalenonidibe, ");
INSERT INTO cuk_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","we-dule ibmar-e-ibedga-sogoed: ‘Napira Bab-Jehová-nuggi ise-sogar an bega sogye, ibmar-bega-akwega-be-anga-uksadi, an be-ibe gwen oakalossurye.’ ”Ibdula-ibedi, dule-ega-ibmar-soged nabir itogele, we-dule-ibmar-akwisad ibmar-bennukosulid. ");
INSERT INTO cuk_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","”Ar dule-ibmar-akwed-wagab ibmar-atursalesardi, adi, na e, ibdula-ibed-bennukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","”Ibdula-ega-uklesad ibdula-sapurbalidse ichimaklesale, mer-bennukegala, ibdula-burgwisad-e-goa ibdula-ibedga oyogergebed. ");
INSERT INTO cuk_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","”Dule-wargwen dule-baidse egichisdibe, ega ibdula-wargwen wis udagwerye, ibdula burgwenonikile, igi, e-ibed-daklesulidgi ibdula-naibi-gunonikile, dule-ibmar-wis-egichisadi, e-ibed-bennukergebed. ");
INSERT INTO cuk_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","”Ar e-ibed-wagab ibdula burgwisale, naibigusdibe, adi, bennukosulid. ”Manigi-bennus ebunairdi, bar bennukosulid, ar a-mani bato ega bennuksayob gusad.” ");
INSERT INTO cuk_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Dule-wargwen yagwa-amba yoo-sui-niku-gudiidgi dodosale, ar gusgu ome-nikued-igar-maidba ome-e-babga-mani-ukleged ukoed, degine, nikubaloed. ");
INSERT INTO cuk_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Bunagwa-e-bab yapa ega sui-ukele, amba degite, we-dule gusgu yagwa-bennukleged-igar-maidba manigi yagwa-e-bab-bennukergebed. ");
INSERT INTO cuk_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","”Melle be ome-ina-isgana-imaked, dula-gudii imako, oburgwemalo. ");
INSERT INTO cuk_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","”Dule ibdurganbo galagwensur guele, we-dule, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","”Bab-Jehováʼgarbi ibmar-ogumakar be ukoed. Ar degisulile, dule bab-dummad-baiganga ibmar-ogumakar-ukele, a-dule, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","”Dule-be-yarginsulid melle sabsur be imako, degine, melle be wiobalo, ar ade, bemar Egipto-yargi be-yarsulidgi be gudii gusmogad. ");
INSERT INTO cuk_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","”Omegan-ei-sui-burgwismalad, degine, mimmigan-babgan-sated, melle be sabsur-imakmalo. ");
INSERT INTO cuk_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ar be amar sabsur-imakmalale, e-bendakega anse gollarmalale, an amar-bendakega ese naoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Degine, an nue-ise-urwedgi, es-suidgi sabsur-be-odurdakar an be-oburgwemaloed. Ar agine, be-omegandi sui-sate gumaloed, be-mimmigandi bab-sate gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","”Dule-wileged-an-dulamar-abargi-gudiid begi mani-gasale, gannar bega ukbaloye sogsale, melle be dulemar-mani-ukmaladyob damalo, degine, melle egi be mani-onakmai gumarbalo. ");
INSERT INTO cuk_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","”We-dule-wileged ega be mani-uksad-anar bega e-mordummad uksale, sedogusale, gannar ega e-mordummad be ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ar ade, neg-diopigwadgi yoega, unnila we-morbi-nikad. Ar degisulile, ¿ibi-morgi atuosunna? Dule-wileged e-bendakega anse gollalile, bendakega an ese naoed, ar ade, an dulemar-wiledakdaed. ");
INSERT INTO cuk_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","”Melle bela-bela sabsur Bab-Dummadgi ichakwaa sunmako, degine, melle dule-be-neggwebur-semaid be ukabsao. ");
INSERT INTO cuk_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","”Melle be ibmar-gwag-gebe-welemalad, degine, vino-gebe-egurelemalad Bab-Dummadga-uksuli gumalo. ”Be-machi-sailagined anga be ukmarbalo. ");
INSERT INTO cuk_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","”Amba deyobbalid, moli-bebe-nikad-macheredsailagined, degine, sibad-wawaad-macheredsailagined, amba anga be ukmarbaloed. We-ibmar-durgan sunna ibagugle (7) na e-nan-walik gudii gued, ibabaabakgus-gwalulesad-sorbardi (8), anga be ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","”Bemala dulemar-islidikid-anga-uklesmaladga guoed. Ibdula-sapurbarmalad be-ibe sapurgi ibdula-oichimaksale, melle a-ibdula-e-san gunmalo. A-e-sanmala achuga be ukmaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Mer gakansaar be ibmar sogo. Emargi gakansaar yolegega melle dule-isgana-ebo be igar nabogo. ");
INSERT INTO cuk_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","”Melle dulemar-bukidar-ibmar-isgana-imakmaladyob be ibmar imako. Igar-nabolenaidgi dule-bukidar-sogmaladba melle be binsaed galemalo. Dule-bukidar igar-innikisulidgi-yolenai be dakele, melle eba be dao. Bedi igar-innikigwadba be imako. ");
INSERT INTO cuk_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","”Dule-wilegedga-igar-itolenaile, wileged-ular, melle be, e-ibmar-sognaidba, eba be nai guo. ");
INSERT INTO cuk_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","”Moli-bebe-nikad-alugwasualed yoggus-gudii be dakalile, moli-uayasuiddibe, amba be-isdaradgadile, gannar e-ibedga be uko. ");
INSERT INTO cuk_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","”Melle be dule-isdar-be-daked-bendaksuli be guo. E-moli-uayasuid ibmar-ichesur-semaidba aimukud be dakele, e-moli be bendakoed, ibmar-e-birgi-bukwad ega be odegoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","”Dule-wilegedga igar-nabolenaidgi, ega igar-maidba be imako, melle egi be yogasaar yoledii guo. ");
INSERT INTO cuk_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","”Binsa-dulemargi-gakansaar-yolemaladgi be bangumar. ”Degine, melle binsa dule-ibmar-oakalossulid-oburgwega be imako. Degi, melle dule-nued-daed okalobalo. Ar ade, dule-ibmar-oakalosad an sabsur-odurdakedsegad. ");
INSERT INTO cuk_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","”Melle dulemarse manigi be binsaed galego. Ar ade, manigi-bakleged be-binsaed gaoed, bar inniki-binsae be-imakosulid. Deginbali, dule-igar-nabomalad, igar-itonaidgi, dule-ibmar-oakalossulidgi-aibinega imakbalid. ");
INSERT INTO cuk_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","”Melle be dule-be-yarginsulid sabsur-imako, ar ade, bemarmoga, Egipto-yargi, be-yarsulidgi be gudii gusmogad. Ar bato bemar wismalad, yar-baidgi-gudiir, wede igi-itolege.” ");
INSERT INTO cuk_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Birganergwa (6) be ibmar digoed, degi, birganergwa (6) be ibmar webaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Birgagugledgindina (7) melle be ibmar bar digo. Napa-obunnogega be imakoed, adi, dule-wilemalad a-ibmar gunmalaga, degi, ibmar-durgan-sapurbarmalad, a-ibmar-obinoed gunmarmogagar. ”Amba deyob, be-uva-digaled, degi, be-olivoʼmar-digaled, be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","”Ibanergwa (6) bela be-ibmar-imaked be imako, ibagugledgindina (7), be obunnogoed, adi, be-moli-bebe-nikad-alugwasualed, degi, be-moli-uayasuid, obunnomalagar. Deginbali, be-maigan, degi, dule-be-yarginedsulid, gannar gangumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","”Bela an bemarga ibmar-sogsadba be nanamalo. ”Melle bab-dummagan-baiganse be gormalo, melle bipisaale baid-bab-dummad-nug be bimalo.” ");
INSERT INTO cuk_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“An-nug-odummogega, birgagi sogapaa be anga iba onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","”Madu-Inasulid-Iba be onogoed. A-ibagi, ibagugle (7) madu e-inasuli be gunnoed. Ar igi bato idu an bemarga sogsa gusa, deyob be gunmaloed. Abib-niigi be iba onogoed, ar ade, a-niigi Egipto-yargi be noar gusmalad. Dule anse arganagwabi gwen nonikosulid. Anga ibmar sedagergebmalad. ");
INSERT INTO cuk_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","”Gebe be ibmar-gwag-wealir, Ibmar-Gwag-Gebe-Weleged-Iba be onogoed. ”Deginbali, bela be-nainugi be arbasad, na be bela-ibmar-wesadgi, birga-bergusar, Ibmar-Gwag-Napi-Weleged-Iba be onobaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","”Bela machergan, birgagi ilapaa, Bab-Jehová-Bur-Dummad-asabin ambikunonimaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","”Bemar anga ibdurgan-ogumakar-ukalile, melle e-abe madu-ina-nikad-ebo-mesa be anga ukmalo. Degine, ibmar-gwallu ibagi-be-anga-ukmalad, melle banedga be osabogo. ");
INSERT INTO cuk_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","”Be-nainugi be-ibmar-gebe-weleged-bur-nuegan, be-Bab-Dummad-Jehová-negse be sedergebed. Sibad-e-mimmi melle e-nan-nunisgi be duo.” ");
INSERT INTO cuk_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Israel-dulemar, nue be itomalo. An-baliwitur bemar-iduega an barminaid, adi, igarba bemar-edarbenadapguega, degine, yar-guakwa-an-bemarga-nasiksadse bemar-sedegar. ");
INSERT INTO cuk_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","A-baliwitur nue be itomalo, a-sogedba bemar nanadii guo. Ar ade, an-nuggi ibmar-imakdisoggu, melle a-baliwiturgi be gwisgudii gumalo. Ar ade, bemar-isgued, a-baliwitur, igi-barsaye bemarga sogosulid. ");
INSERT INTO cuk_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ar nue a-sogedba be nanadimalale, an-bemarga-bela-ibmar-sogsadba be damalale, dule-be-isdardakmalad-e-isdaradga an gumogoed, degine, dule-begi-gwisgumaladgi an gwisgumogoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","”An-baliwitur bemar-idu nadapguoed: Amorreo-dulemar-yalaganse, Het-dulemar-yalaganse, Ferezeo-dulemar-yalaganse, Canaán-dulemar-yalaganse, Heveo-dulemar-yalaganse, degi, Jebuseo-dulemar-yalaganse, bemar-sedoed. We-dulemala bela an obelogoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","”Melle we-dulemar-sunnasurdamaladba be damarmogo. Melle e-bab-dummagan-asabin be yokorgi-sindigar sigmalo, degine, melle e-nug odummomarbalo. Bur e-bab-dummagan-e-wilubgan-sobarmalad be osulogoed. E-akwa-e-bab-dummadganga-imakmalad ei be mamaroed. ");
INSERT INTO cuk_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","”Be-Bab-Dummad-Jehová-e-nug be odummogo. Geb degine, Bab-Jehová bega mas-obinagwar, degi, dii-obinagwar ukoed. ”Bemar uellesuli an be-imakmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","”Degine, sereddii-mai an be-imakmarbaloed. Be-yargine, siamar gurgin-nika-gudiir mellegega an imakosulid. Bela omegan sikwi-bakedbi gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","”Neggweburmargi-bemar-naoedgi, e-dulemar bemar-asabin bela-belad-gwayemalaga, surbinsa-itomalaga, degi, be-asabin-duurmakega, an imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","”Bemar-nadapid-idu bulu-barminaiyob an imakoed, adi, igi bulu-idu dulemar-duurmakdedamala, deyob bemar-asabin Heveo-dulemar, Het-dulemar, degi, Canaán-dulemar bemar-idu duurmakdemaloed. ");
INSERT INTO cuk_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","We-dulemar, birgagwengi yog-onoar an bemarga imakosulid, adi, melle napa binsa-wilenai guegar, degi, ibdurgan-sapurbarmalad melle yaisur mergumai gubaligar. Ar degiile, bemar-naibisamalo-itole. ");
INSERT INTO cuk_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Geb bemar dula-bukidar-gusadse, degi, yar-akwegala na be unnigus-itomaladse an we-dulemar binna-binna bemarga onomai an imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","”Be-yar-abingumaloedi, weyob an bemarga nasikoed: Demar-Ginnidye-nugad-naid-akar, Filistea-dulemar-demar-naidse, degine, Nega-dulesulid-akar, diwar-Éufrates-maidse, an nasikoed. Dulemar-we-yargi-bukwamaladgi-nakwed an be-imakoed. We-dulemar bela be-asabin be onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","”Melle we-dulemar-ebo be igar-mesdii nanamalo, degine, e-bab-dummagan-ebo be igar-mesosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","”Deginbali, be-yargi we-dulemar be obegosurbalid. Ar be obesmalardi, angi isguega be-imakmaloed. E-bab-dummagan-e-nug-odummogega be-imakmaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Bab-Jehová Moisésʼga sogded: “An-maidse anse be nakweda. Beba be Aarón, Nadab, degi, Abiú be sedago. Degi, Israel-girmar-dummagan-dulapaa-gakambe (70) beba be sedabalo. Wemar angi bannaba ambikumaloed, agi yokorgi-sindigar ambikumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Bebi unnila be anse warmakoed. Israel-dulemar-selearsurmaladdi, nakosurmalad, degi, anse warmakosurmarbalid.” ");
INSERT INTO cuk_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moisés nade gusad. Bab-Jehová-bela-ega-ibmar-sogsad, degi, igarmar-ega-uksabalid, bela dulemarga sogdapid. Bela dulemala dule-wargwennayobi Moisés-abin-imakdemalad: “Bela Bab-Jehová-ibmar-sogsadba anmar ibmar imakmaloye.” ");
INSERT INTO cuk_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Geb degine, Moisés bela Bab-Jehová-ibmar-sogsadi narmaksad. Moisés wakudaryalaba gwisgualid. Yar-dummad-naba Bab-Dummadga-ibmar-ogumakar-ukleged-aila sobsad, degine, akwamar-islidikid-gwaambe-gakabo (12) urbisbalid. A oyonaid, gwa-gwagwenadi, Israel-dulemar-sogambe-gakabogwad-e-wilubgan (12) guye. ");
INSERT INTO cuk_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Geb, Moisés moli-bebe-nikad-machergan-oburgwemalaga Israel-sapingan barmisad. A-molimar Bab-Jehováʼga ogumakar uksamalad, degi, gwenatigwar-guega molimar-sapingana ega uksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moisés molimar-abe-negabar susad, nog-dummagangi sisad, baid-negabaladdi Bab-Dummadga-ibmar-ogumakar-ukleged-ailagi misad. ");
INSERT INTO cuk_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","A-sorbali, Moisés dulemar-Bab-Dummad-ebo-Igar-Mesisad-garda susad, geb, dulemarga absoded. Dulemar abin-sogdemalad: “We-igar-maid-sogedba, degi, bela we-Bab-Jehová-anmarga-sogsadba anmar daoye.” ");
INSERT INTO cuk_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Geb degine, Moisés abe susad, dulemar-bukwadgi misad. Geb sogded: “Bab-Jehová weyob bemarga sogsadbali, we-abe, Bab-Jehová-bemar-ebo-Igar-Mesnaid-e-wilubganad.” ");
INSERT INTO cuk_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moisés, Aarón, Nadab, Abiú, amar yar-birse nakwidmalad. Wemarba Israel-girmar-dummagan-dulapaa-gakambe (70) eba yar-birse nakwidmarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Agi, amar Israel-e-Bab-Dummad daksamalad: E-nag-urbali, zafiro-akwabir-nuedyob, bela swilidik mogir-ara-ara-daklegedyob napa naid. ");
INSERT INTO cuk_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Degite, wemar-Israel-girmar-dummagan Bab-Dummad-daksamar-inigwele, Bab-Dummaddi oakalossulid. Amba dula gudii gusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Geb degine, Bab-Jehová Moisésʼga sogded: “Yar-birse anse be naknao, agi be an-edarbo. Agi an-Igarmar, degi, anba-bemar-nanamaloed-Igar an bega akwa-matargwagi-narmakar ukoed, adi, a-Igarmargi be dulemar-odurdakegar.” ");
INSERT INTO cuk_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Geb degine, Moisés, Josué-ebo Bab-Dummad-yarse nakwid gusad. Josuéʼde Moisés-bendakedid. ");
INSERT INTO cuk_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Moisés Israel-girmar-dummagangardi sogded: “Anmar bemarse-gannar-nonikidse, wegi be anmar-edarbemalo. Aarón, Hur-ebogwa bemar-abargi gudii gumaloed. Ar bemar ibmar-egisbimalale, wis bemar boni-nikuardibe, wemar-ebogwadse be idakmaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Geb degine, Moisés yar-birse-nakwidgua, a-yala mogir-ena signonikid. ");
INSERT INTO cuk_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Agine, Bab-Jehová-e-gangued-yeerdakleged yar-Sinaíʼgi aidenonikid. A-yala, ibanergwa (6) mogir-ena sigisad. Ibagugledgine (7), Bab-Jehová mogir-imbaba Moisésʼse gornonikid. ");
INSERT INTO cuk_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israel-dulemar Bab-Jehová-e-gangued-yeerdaklegedi, yar-birgi-soo-binnasur-gwabunyemaiyob dakmalad. ");
INSERT INTO cuk_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moisés mogir-imbaba dogded, yar-birse nakwided. Moisés yar-birgi iba-dulabo (40) ibginedba, degi, mutikidba gudii gusad. ");
INSERT INTO cuk_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Israel-dulemarga be sogo, anga-ibmar-ukega be ibmar weemaloye. Bela na e-ulubgi-ibmar-ukbi-itogedba, na ukmaloye. ");
INSERT INTO cuk_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","We-ibmarmar-uklegoed be abingaoed: Olo, mani, esgoro-gordikid, ");
INSERT INTO cuk_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued, sibad-e-absarmar, ");
INSERT INTO cuk_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled, ibdurgan-uka-nuegan, urgomar-acaciaʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Olivo-gwallu gwallumar-ogaegar. Ina-wawadikid, olivo-gwallu-nugsalegedgi-ebulegedba oburegar. Ina-wawadikid, ina-wawadikid-obupurmaklegedba oburegar. ");
INSERT INTO cuk_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Akwamar-nuegan-óniceʼye-nugmalad, degi, akwa-nuegan-bamalad, mor-efodʼye-nugad-birgi nasikegar, degi, mor-binasgargi-nasiklegedgi nasikegar. ");
INSERT INTO cuk_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Geb anga anse-goled-neg be sobmalo. ”A-abargine an gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ar igi bela an bega oyogoe, a-sunnagwad be dulemar-anse-goled-neg-sunna-seleged be soboed, degi, a-yagi bela ibmar-ebuleged a-sunnagwad be sobbaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Deginbali, ulu be sobbaloed. We-ulu-sobega, urgo-acaciaʼye-nugad be ebugoed. E-sugued, achaatar-nika be soboed, e-matardungued, achapaa, degi, e-nibgued, achapaabar. ");
INSERT INTO cuk_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Olo-sunnabi uluyaba ebiris be nasikoed, degi, ulu-asgine, olo-sunnabi ebiris egi be nasikbaloed. Deginbali, birgi, bela-ebiris e-mullugwad olobi be nasikbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","”Agala, olua-dummagan-gwabake-sobega or be duoed. Ulu-e-dikar-bergunaid-sogbakegwadgi gwa-gwagwen be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","”Urgo-acaciaʼye-nugad-walagana suitii be soboed. We-suarmargi or egi bela be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Suarmar-walagana-suid, ulugi-olua-dummagan-nanaid-yaba be odogoed, adi, a-suarmargi ulu nabir selegegar. ");
INSERT INTO cuk_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Suarmar-walagana-suigan, ulu-e-olua-dummagan-nanaid-yaba-dogar-mai degisadegudoed, bar be ungosulid. ");
INSERT INTO cuk_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","A-uluyagi Igar-narmakar-an-bega-ukoedi be mesoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","A-sorbali, ulu-eduged or-nuedgi be imakoed. E-sugued, achaatar-nika be imakoed, e-matardungueddi, achapaa-nika be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","”Degine, baliwiturmar-dummagan-querubinʼye-nugmalad-walabo orbi be sobbaloed. Be soboedi, mardogi-binna-binna-sarsoar-sobnai be imakoed. Baliwiturmar-querubinʼmar-warbogwad ulu-eduged-birgi e-duku-dukusik-gwichi be soboed. ");
INSERT INTO cuk_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Degisoggu, querubin-wargwen ulu-eduged-birgi e-dukusik be soboed, degi, baid-querubin-wargwen e-duku-baidsik be sobbaloed. Ulu-edugedba-mesa be querubin-warbogwad soboed. ");
INSERT INTO cuk_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Querubin-e-sakanmala ulu-eduged-birgi nallaa gwichioed, adi, e-sakan ulu-eduged-odukunai guegar. We-querubinʼmala asabin-asabin gwisgumaloed, degi, ulu-edugedsik e-wagar-atakgwichi be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","”Geb a-sorbali, ulu-edugedi, ulu-birgi be mesoed, geb ulu-yagi dulemar-ebo-an-Igar-Mesnaid narmakar-an-bega-ukoedi be mesoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","An besega, querubinʼmar-warbogwad-gwichid-abargi, ulu-eduged-birgi, magarogoed. Agi an bebo sunmakoed. Agi an bega-Israel-dulemarga-ibmar-sogoed, an bela bega sogoed.” ");
INSERT INTO cuk_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Deginbali, mese be soboed. Urgo-acaciaʼye-nugad be ebugoed. E-sugued, achabake, e-matardungued, achabo, e-nibgueddi, achapaa-nika guoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","”Olobi egi be nasikoed, degi, e-dikar-bela-ebilis olo mulluu be mesoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Deginbali, e-dikar-bela-ebilis wis-nibakwaa be imakbaloed. E-matardungued, argan-matagwen be imakoed. We-wis-nibakwaa-be-imakoedgi, or ebiris be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","”Deginbali, oluaduk-dummagan, gwabake be soboed. Mese-e-nag-sogbakegwad-iliba gwa-gwagwen be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Oluaduk-dummagan-gwabakegwad, mesegi-mulluu-mesilesad-urba nai guoed. A-oluaduk-dummagan-yaba suar-suid dogoed, adi, mese nabir semalagar. ");
INSERT INTO cuk_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","”Suar-acaciaʼye-nugad-walagana suitii be soboed. A-suar-walagana-ebilis or be matak-matak nasikoed, degi, a-suar-walaganagi mese be semaloed. ");
INSERT INTO cuk_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Degine, e-batemar, e-bate-dummagan, degi, e-nog-dummagan, orbi be sobbaloed. ”E-bormomar be sobbaloed, adi, agi Bab-Dummadga-ibmar-uknaid eogegar. Wemala olo-nuedbi be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Madu-Bab-Dummad-asabin-ukleged, mese-birgi-maigu be imakoed.” ");
INSERT INTO cuk_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Deginbali, gwallu-sied olobi be soboed. Gwallu-sied mardogi-binna-sarsoar be soboed. E-nag, e-war, e-nogmar, e-abingaed, e-dutumar, bela wemar egi-nanai soggwenna soblegoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","”Gwallu-siedgi, e-sakwa walanergwa-nika (6) be imakoed. Nailik, e-sakwa walapaa be soboed, baidsik, e-sakwa walapaa be sobbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","E-sakwa-war-wargwengi nur-matargana-e-dutuyob nog be soboed, dutu-abingaed-gwagwen, degi, e-dutu be soboed. Degine, e-sakwa-baidgi nur-matargana-e-dutuyob nog be sobbaloed, dutu-abingaed, degi, e-dutu be sobbaloed. Gwallu-sigedgi e-sakwa-walanergwagi (6) degibi be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Gwallu-sied-wargi nog-gwabake nur-matargana-dutugii-dakleged be imakoed, e-abingaedmar, degi, e-dutumar egi be sobbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","E-sakwa-warbogwad e-wargi-yolenaidgi abingaed-gwagwen be soboed, degi, abingaed-baid e-sakwa-warbogwad-baid-urba be sobbaloed, deginbali, abingaed-baid e-sakwa-warbogwad-baid-urba be sobbaloed. Bela deyobi e-sakwa-walanergwad (6) be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","E-abingaedmala, degi, e-sakwamala, unnila bela gwennaa be imakoed. Bela-wemala soggwennaa mardogi-binna-sarsoar be soboed, bela we olo-sunnabi be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Geb degine, ega gwallu gwagugle (7) be soboed. A-gwallumala be ogaoed, adi, asabin neg-mee imakegar. ");
INSERT INTO cuk_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Deginbali, e-gwillodub-sikmalad, degi, e-bate-burwigana, bela olobi be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Gwallu-sied be sobegala, degi, bela e-ibmar-burwigana-sobegala, or-nued nibir-dulapaa-gakambe-gakabake-aidiku (74) be ebugoed. ");
INSERT INTO cuk_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","”Nue be dako, be imakoedi, igi yar-birgi bega e-dakleged oyolesa, a-sunnagwad be imakoed.” ");
INSERT INTO cuk_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Bab-Jehová Moisésʼga sogdebalid: “Anse-goled-neg-sunna-seleged be soboed. Be sobega, lino-mor-nued goambe (10) be ebugoed. Deginbali, be nirbadub-arad, nirbadub-suir-akwagiid, degi, nirbadub-ginnid be ebubaloed. Agine, baliwitur-dummagan-querubinʼye-nugad, bela nue-yeerdakle-imakar, a-morgi be sobbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Bela mormar-e-suguedi, daligugledbi (7) be imakoed. E-matardungueddi, daligwenadbi be imakoed. Mormala bela emarbi-dungu be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Mor-dummagan-goatale be gwadi-gwadi imakoed. Baid-mormar-goataledi amba gwadi-gwadi be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Degine, mor-goataled-gwadialed-e-dikargi e-uayamar dub-aradgi ega be nasikoed. Amba deyob mormar-baigan-goataled gwadiarmalad-e-dikargi be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Mormar-goataled-gwadiarmaladgi e-uayamar gwadulabo-gakambe (50) be nasikoed. Degine, baigan-goataled-gwadiarmaladgi amba gwadulabo-gakambe (50) be nasikbaloed. E-uayamar abin-abin be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Mor-nasiked orbi dulabo-gakambe (50) be imakbaloed, adi, mormar-goataledi, baigan-mormar-goataledbo be oatogegar, adi, anse-goled-neg-sunna-seleged-e-mor unnila gogwenayob guegar. ");
INSERT INTO cuk_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Sibad-absar mor-dummaganga be imakbaloed, adi, anse-goled-neg-sunna-seleged-birgi anwegar. A-mormar-dummagan goambe-gakagwensak (11) be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Mormar-e-sugued, daligugle-gaka-abala sugue (7½) be imakoed, e-matardungueddi, daligwen be imakoed. Mormar-dummagan goambe-gakagwensakad (11) bela emarbi-dungu be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","We-mormar-dummagan, goatar be gwadioed, degine, baid goanergwa (6) be gwadibaloed. Geb anse-goled-neg-sunna-seleged-e-yawagak-asabin, mormar-dummagan-goanergwad-e-gogwenad-napid be nubyar nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Geb a-sorbali, mor-dummad-dikarba gwadulabo-gakambe (50) e-uayamar be nasikoed. Amba deyob baigan-gwadilesmalad-dikarba e-uayamar be nasikbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Deginbali, esgoro-gordikid-dulabo-gakambe (50) mor-gamalad be imakbaloed. Wemala mor-dummad-e-uaya-yaba be odogoed, adi, mor-dummagan danar-danaled unnila goa-gwennagwadyob guegar. ");
INSERT INTO cuk_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mormar-dummagan, ar bur-suidsoggu, anse-goled-neg-sunna-seleged-e-dikarmargi batenai guoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","We-batenanaidi, anse-goled-neg-sunna-seleged-edugoed, gwensaksik, achabo batenai be imakoed, baidsik, amba achabo batenai be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled, anse-goled-neg-sunna-seleged-edugega be imakbaloed. Geb degine, ibdurgan-uka-nuegan, be ebubaloed, adi, agi anse-goled-neg-edugegarbar. ");
INSERT INTO cuk_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","”Deginbali, anse-goled-neg-sunna-selegedga urgomar-acaciaʼye-nugad be sobbaloed. We-urgomar nue inniki-inniki be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","We-urgomar dalibo-abala-sugu be imakoed, e-matardungueddi achapaa be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Deginbali, urgomargi e-nagmar war-warbo-nika be soboed, adi, nabir urgomar naga-nagaba matak-matak gwisguegar. Weyob bela urgomar be anse-goled-neg-sunna-selegedga be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Degisoggu, urgomar mata-dulagwen (20) anse-goled-neg-sunna-selegedga, dad-nakwed-argan-nuedsik ogwichega be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Urgomar-mata-dulagwenad-urba e-sigmalad gwadulabo (40) manibi be soboed. Urgomar-irbali gwa-gwabo e-sigmalad be imakoed, adi, urgo-e-nagmar e-sigmaladgi dogegar. ");
INSERT INTO cuk_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Anse-goled-neg-sunna-selegedga urgomar-mata-dulagwen (20) dad-nakwed-argan-sapiledsik ogwichega be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Be e-sigmalad-manibiid gwadulabo (40) be imakbaloed. Urgomar-iliba gwa-gwabo e-sigmalad be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Anse-goled-neg-sunna-seleged-sorsik, dad-argwanedsiki urgo-matanergwa (6) be sobbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Deginbali, e-abingunaid-yarganbalidgala, urgo-matabo be soboed. Deyobi, e-abingunaid-yarganbalid-baidga, urgo-matabo be sobbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","We-urgo-matabogwad-e-nagmar, e-sigmalad-birgi darbo abingunaidgi gwisguoed. Geb nibalidse or-dummad-naidgi be urgo darbobela be odogoed. Weyob urgo-matabogwad niba ebo-atonai be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Degisoggu, urgo-matabaabakgi (8) e-sigmalad-manibiid gwaambe-gakanergwa (16) be sioed. A-sogleged, urgo-matagwengi e-urba e-siged be gwa-gwabo sioye. ");
INSERT INTO cuk_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Deginbali, urgo-warakwagana-acaciaʼye-nugad-biir-megmalad be imakbaloed. We-urgo-warakwagana anse-goled-neg-sunna-seleged-e-dikar-soggwensikidga walatar be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Urgo-warakwagana anse-goled-neg-sunna-seleged-e-dikar-baidsikidga, walatar be imakbaloed. Degine, dad-argwaned-yarganbalidga urgo-warakwagana walatar be imakbaloed, ");
INSERT INTO cuk_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Neg-abargi-urgo-warakwa-megoed bela-baksa urgomar-abargi megoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Bela urgomar-ebilis or be matak-matak nasikoed. Degine, e-olua-dummagan orbi be imakbaloed, adi, a-yaba urgo-warakwagana-odogegar. Bela we-urgo-warakwagana-biir-megmalad-birgi or be nasikbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","”Igi-dakle yar-birgi bega oyolesa, ayobi, anse-goled-neg-sunna-seleged be soboed. ");
INSERT INTO cuk_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Deginbali, mor-dummad be imakoed. We-dubmargi be imakoed: Nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, linoʼdub-nuedgi be soboed. We-morde nue-yeerdakle-imakar, baliwiturmar-querubinʼye-nugad, egi-ise-nue-sobale be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Buarmar-acacia-walabakegwadgi we-mor-dummad-yeerdakleged be nasikoed. We-buarmarde or egi nasiklealed. E-siged-manibiid-birgi we-buarmar gwisguoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","We-mor-dummadde mor-nasikmaladgi be nasikoed. Degisoggu, we-mor-dummad Neg-Islidikid, Neg-Ise-Islidikid-ebo bachiki-imakega guoed. We-mor-dummad-daksik Dulemarbo-An-Igar-Mesisad-Ulu be sioed. ");
INSERT INTO cuk_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Geb degine, Dulemar-Ebo-An-Igar-Mesisad-Ulu-birgine, e-eduged be mesoed. E-edugedde, Isgued-Elileged-E-Wilubye, sogleged. We-ulude, Neg-Ise-Islidikidyaba sioed. ");
INSERT INTO cuk_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Neg-Islidikidgi, mor-naid-magabali, dad-nakwed-argan-sapiledsik, mese be sioed. We-mese an-asabin madu-ukleged-mesed. A-mese-asabinni, dad-nakwed-argan-nuedsik gwallu be sibaloed. ");
INSERT INTO cuk_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Anse-goled-neg-sunna-seleged-e-yawagakgala, we-dubmargi mor-dummad be soboed: Nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, linoʼdub-nuedgi be soboed. Ise-nue-sobar, bela-bela-nue-yeerdakle-imakale, be we-mor-dummad imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Degine, we-mor-dummadgala, acacia-buarmar walatale ega be imakoed. We-buarmar-ebilis or be matak-matak nasikoed, degine, mor-gamalad olobi ega be imakbaloed. Deginbali, wemar-buarmar-ataled-abingaega, esgoro-gordikidgi gwaatale e-sigmalad be soboed.” ");
INSERT INTO cuk_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Bab-Jehová Moisésʼga sogdebalid: “Anga-ibmar-ogumakar-ukleged-aila, be imakbaloed. A-aila, urgo-acaciaʼye-nugadgi emarbi yaa-dungu be imakoed. E-sugued, daligwen-gaka-achabo, e-matardungued, daligwen-gaka-achabobar. E-nibgueddi, bisgipaa. ");
INSERT INTO cuk_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Degine, moli-bebegii aila-e-dikar-abingunanaid-birgi be ogwisbaloed. We-moli-bebegiidmala, ailagi bato eba-mese-sobale be imakoed. Anga-ibmar-ogumakar-ukleged-aila-birgi, esgoro-gordikid be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","”Deginbali, bela ibmarmar-we-ailagi-ebuleged esgoro-gordikidgi be soboed: Buru-simalad-bormomar. Buru-weemalad-wesar-dummagan, Abe-bomied-nog-dummagan. San-obin-obin-saed-iko-dummagan. Soo-seed-bormomar. ");
INSERT INTO cuk_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Deginbali, esgoro-gordikidgi san-nared-saki-sakid be sobbaloed. A-saki-sakidga, e-uaya, e-dikar-abingunanaidgi esgoro-gordikidgi be sobbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Degine, san-nared-saki-sakid anga-ibmar-ogumakar-ukleged-ailagi, negabaladgi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Deginbali, anga-ibmar-ogumakar-ukleged-ailaga, suar-warakwagana be imakbaloed. We-suar-warakwaganaga urgo-acaciaʼye-nugad be ebugoed. We-suar-warakwagana-birgi esgoro-gordikid egi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Suarmar we-aila-e-oluaduk-dummagan-nanaid-yaba be odogegalad. We-suarmar, anga-ibmar-ogumakar-ukleged-aila seledsokalile, dikarba-nai guoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Anga-ibmar-ogumakar-ukleged-aila be ollor imakoed, degine, we-aila urgomargi be soboed. Ar igi bega yar-birgi oyolesa, deyob dakle be soboed.” ");
INSERT INTO cuk_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Bab-Jehová Moisésʼga sogdebalid: “Deginbali, anse-goled-neg-sunna-selegedga neg-imba be nasikbaloed. Dali-dulagwen-gakatar-sugu (25) guoed, dad-nakwed-argan-nuedsik be nasikoed. Degine, we-neg-imba-e-galugi lino-mor-nued naguoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","E-buarmardi, waladulagwen (20) nikuoed, degi, e-buar-sigmalad, amba gwadulagwenbar (20). Bela wemar-sobegala, esgoro-gordikid be ebugoed. E-gamalad-sobegala, degi, buar-e-nonomar-sobegala, mani be ebugoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Amba deyob anse-goled-neg-sunna-seleged-imba dad-nakwed-argan-sapiledsik, lino-mor-nued dali-dulagwen-gakatar-sugu (25) be nasikbaloed. E-buarmardi, dulagwen (20), degi, e-buar-sigmalad amba dulagwenbar (20). E-buar-sigmalad-imakegala, esgoro-gordikid be ebugoed. E-mor-gamaladgardi, degi, e-buar-nonomargardi, mani be ebugoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","”Anse-goled-neg-sunna-seleged-imba dad-argwanedsik, mor-dummad daliambe-gakabo-gaka-abala-matardungu (12½), be nasikoed. E-buarmardi, warambe (10), degi, e-buarmar-sigmalad, gwaambebar (10). ");
INSERT INTO cuk_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Anse-goled-neg-sunna-seleged-imba dad-nakwedsikid e-matardungued, daliambe-gakabo-gaka-abala (12½) guoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Yawagak-doged-dikarba mor-dummad naguoedi, dalipaa-gaka-bisgipaa, doged-e-dikar-gwensaksik sugu naguoed. E-buarmardi, walapaa, degi, e-sigmalad amba gwapaabar. ");
INSERT INTO cuk_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Degine, doged-e-dikar-baidsiki, mor-dummad, dalipaa-gaka-bisgipaa nagubaloed. E-buarmardi, walapaa, degi, e-sigmalad amba gwapaabar. ");
INSERT INTO cuk_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","”Yawagak-dogedgi mor-dummad daliatar be nasikoed. We-mor-dummad be imakoedi, nirbadub-aradgi be imakoed, nirbadub-suir-akwagiidgi be imakoed, nirbadub-ginnidgi be imakoed, linoʼdub-nuedgi, ise-nue-sobar, bela-bela-nue-yeerdakle be imakoed. Degine, e-buarmardi, walabake, degi, e-sigmalad amba gwabakebar. ");
INSERT INTO cuk_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Bela we-neg-imba-e-buarmar-ebiroedi, e-buar-nonomar, manigi soblegoed, e-gamalad, manigi soblebaloed. E-sigmaladdi, esgoro-gordikidgi soblegoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","”Neg-imba dali-dulagwen-gakatar-sugu (25) guoed, e-matardungued, daliambe-gakabo-abala (12½) guoed. E-mor-naguoed, daligwen-bisgise sugu naguoed. We-mor-dummagan-naguoedi, lino-mor-nued guoed. E-sigmaladdi, esgoro-gordikidgi soblegoed. ");
INSERT INTO cuk_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Anse-goled-neg-sunna-selegedgi belagwapa-ibmarmar-ebulegoedi, bela esgoro-gordikidbi guoed. Degine, we-a-neg-bargamalad, degi, e-galumar-bargamalad, bela esgoro-gordikidmarbi be imakbaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Olivo-e-gwallu ibmar-baidba-oburarsuli be sedamalo, adi, gwallu-ogamalagar. Degisadegu gwallu gasii guegar. ");
INSERT INTO cuk_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aarón, degi, e-machimala, gwallu guakwaa simaloed, adi, gwallu gasigu oibodagegar. We-gwallu Bab-Jehová-dulemarbo-ambikued-neggi, mor-dummad-Bab-Ulu-irwa-naid-magaba sigoed. We-igar-an-ukedi, Israel-dulemarga, degine, e-waganga, degisadegu guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Bab-Jehová Moisésʼga sogdebalid: “Be-ia-Aarón, degi, e-machimala Nadab, Abiú, Eleazar, Itamar, amala bese warmaked be imako. Wemar, anga Israel-dulemar-abargi dule-irwa-anse-gormaladga gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Be-ia-Aarónʼgala dule-irwa-anse-goled-bur-dummad-mormar be imako, adi, oyogega, be-ia-Aarónʼde dule-dummadye, nue-nug-nikadye. ");
INSERT INTO cuk_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Bela dulemar-mormaked-wisimaladbo be sunmako. We-dulemar Aarónʼga mor-makmalaga an ega gurgin-nuegan uksad. Deyobi, Aarón dule-irwa-anse-goledga an nug-imakegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","”Aarónʼga mormar-maklegoedi, wemalad: Mor-binasgargi-nagued, mor-efodʼye-nugad, mor-dummad-suitigwad, mor-dummad-dubgi-ise-nue-sobaled, mor-gurgin, degine, morgo-dub-saderba-nagued. ”Degisoggu, be-ia-Aarónʼga, degi, e-masmalaga, dule-irwa-anse-goled-mormar be imakoed, adi, amala dule-irwa-anse-gormaladga gumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","”We-mormar-makegala, we-dubmar ebulegoed: Ordub, nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued.” ");
INSERT INTO cuk_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Bab-Jehová Moisésʼga sogdebalid: “Mor-efodʼye-nugad be imakoed. Mor-efodʼye-nugad nue-yeerdakle be makoed. Agala, we-dubmar ebulegoed: Ordub, nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued. ");
INSERT INTO cuk_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","”E-mor-gukinmar ebo atogegala, morgo warakwaa be imakoed, e-duku-e-dukugi ebo gwadiegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Mor-efodʼye-nugad-e-mordub-sadergi-naid, nue-yeerdakle be imakoed. We-mordub mor-efodʼgi gwadiar-nai guoed. We-mordub-makega, be we-dubmar ebugoed: Ordub, nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued. ");
INSERT INTO cuk_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","”Degine, akwa-óniceʼye-nugad gwabo be suoed. A-akwa-gwabogwadgi Israel-masmala-warambe-gakabogwad-e-nugmar (12) be narmakoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Gwagwengi masmala-walanergwad-e-nugmar (6) be narmakoed, degine, akwa-baidgine, baigan walanergwad-e-nugmar (6) be narmakbaloed. Be-narmakoedi, machi-dummadgi be onodagoed, geb machi-bipigwadse, e-gwalulesmaladba be narmakoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Dule-orgi-arbaedi we-nugmar we-akwamar-birgi narmakoed, igi wilub-nasikega imakdamala, deyob imakoed. We-akwamar-dikargi or be nasikoed, adi, akwamar agi galegegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","We-akwamar-gwabogwad mor-efodʼye-nugad-gukinmargi be nasikoed. Weyob, Aarón, Israel-dadgan-warambe-gakabogwad-e-nug (12) an-asabin nai gudioed, adi, ani Bab-Jehová, an we-dulemar insaegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Akwamar-gwabogwad-gaegala, or be imakoed. A-birgi akwamar be sioed. ");
INSERT INTO cuk_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Degine, e-dub-orbiid giabo be imakoed, akwa-gwabogwad-sigoed agi be edinnoed.” ");
INSERT INTO cuk_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Bab-Jehová Moisésʼga sogdebalid: “Geb degine, mor-binasgargi-nagued, igar-nabolegedgi-ebulegega, nue-yeerdakle be imakoed. Mor-efodʼye-nugad-imaksadyob be imakbaloed. ”We-dubmar be ebugoed: Ordub, nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued. ");
INSERT INTO cuk_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","E-sugued, degi, e-matardungued emarbi be imakoed, achagwen-sugu, achagwen-matardungu be imakoed. We-mor darbo be saoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","We-mor-birgi akwa-nuegan ile-ile be urboed. Degiid ilebake be urboed: Ile-soggwengi be urboed: Akwa-sárdicaʼye-nugad, akwa-topacioʼye-nugad, akwa-carbuncloʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ile-sogbogi be urboed: Akwa-esmeraldaʼye-nugad, akwa-zafiroʼye-nugad, akwa-diamanteʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Ile-sogbaagi be urboed: Akwa-jacintoʼye-nugad, akwa-ágataʼye-nugad, akwa-amatistaʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Ile-sogbakegi be urboed: Akwa-beriloʼye-nugad, akwa-óniceʼye-nugad, akwa-jaspeʼye-nugad. Or-gaega-imaklesad-birgi bela we-akwamala be sioed. ");
INSERT INTO cuk_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","”Akwa-nuegana gwaambe-gakabo (12) guoed, Israel-masmala-warambe-gakabogwad-iliba (12). Igi wilub-nasikega imakdamala, deyob, akwa-gwa-gwagwengi, Israel-dulemar-dadgan-sogambe-gakabogwad-e-nugmar iliba be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","”Mor-binasgargi-naguedga ordub-nued sinni-sinni be soboed. ");
INSERT INTO cuk_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Geb degine, be olua-gwabo-olobiid mor-binasgargi-nagued-e-dukumargi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Geb ordubmar-sinni-sinnid-giabogwad mor-binasgargi-nagued-e-dukugi olua-gwabogwad-naidgi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mor-efodʼye-nugad-nasikegala, ordubmar-sinni-sinnid-giabogwad be akwa-nuegan-e-gukingi-siidgi-edinnar nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","”Deginbali, be olua-gwabo-olobiid be imakbaloed. We-ormar mor-binasgargi-naguedyaba, e-dukumargi be nasikoed. Be nasikoedi, mor-efodʼgi naguegalad. ");
INSERT INTO cuk_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Deginbali, napi be olua-gwabo-olobiid be imakbaloed. We-ormar mor-efodʼye-nugad-e-dikarnagaba be nasikoed. E-abingunaidgi yaba-dogar be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Geb degine, mor-binasgargi-nagued-e-olua-gwabogwad, mor-efodʼye-nugad-e-olua-gwabo-naimogad-ebo dub-aradgi edillegoed. Adi, mor-efodʼye-nugad dub-saderba-naidgi naguegar. Deyob guoed, adi, mor-binasgargi-nagued melle mor-efodʼgi bachikii guegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","”Weyobi, Aarón, anse-goled-neg-islidikidyaba dogdele, igar-nabogega mor-binasgargi-nagued-ebulegedgi Israel-e-masmala-e-nug naigu guoed. Adi, an wemar-e-binsadigu guegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","”Deginbali, mor-binasgargi-nagued, igar-nabogega-ebulegedgi, be Urim, degi, Tumim sioed. Adi, Aarón an-asabin-dogder, e-binasgargi-nai dogegar. Weyobi, Aarón, an-asabin-gwisgudaged-ilibali, e-binasgargi Israel-dulemarga igar-nabogega sedigu guegar.” ");
INSERT INTO cuk_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Bab-Jehová Moisésʼga sogdebalid: “Mor-dummad-efodʼye-nugad, bela mor-aradbi be imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Nono-odogega, abargine mor-gammu be sikoed. Mor-gammu-e-dikar bela-ebilis be ebayoed, adi, melle achirmakegar. ");
INSERT INTO cuk_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","”Mor-dummad-e-nag-dukugi bela-ebirar yeerdakle be soboed. Be soboedi, sapi-granada-e-sanyob-dakleged be soboed, nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi be soboed. Degine, amar-imba-imbagi gapan-burwigana-olobiid, bela e-nag-duku-ebilis be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Weyob be nasikoed: Gapan-bipigwad-olobiid, a-nagaba, sapi-granada-e-sanyob-sobaled be nasikoed, geb a-nagaba gapan-bipigwad-olobiid be nasikbaloed, geb sapi-granada-e-sanyob-sobaled be nasikbaloed. Deyob, muchub-muchub bela-ebilis mor-dummad-e-nag-dukugi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","”Aarón, dule-irwa anse-gorsokalile, we-mola-yoi dogoed. Adi, e-gapan-burwigana-goled mag itolegegar. Aarón an-asabin Neg-Islidikidse-dogder, degine, agi noarbalir, gapan-burwigana-goled mag itolebaloed. Deyob imakele, Aarón burgosulid. ");
INSERT INTO cuk_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","”Deginbali, or-nued matarkwaa be imakbalo. Geb a-birgine, wilub-nasikega-imakdamaladyob be we-gayaburba nasikoed: ");
INSERT INTO cuk_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","”We-olo-matargwagwad dub-aradgi-edinnar mor-gurgin-ebirmakaled-asabinnidgi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Weyobi, Aarón-bebegi nai guoed. We-olo-matargwagwad sogleged: Aarón ibmar-ukleged-swilidikid-anga-ukalile, Israel-dulemar-nosasogele, Aarónʼgi gwisgulegoye, degine, an e-isgusmalad elioye, geb an anga-ibmar-ukleged-swilidikid-ukarmalar, abingaoye. ");
INSERT INTO cuk_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","”Degine, mor-dummad-dubgi-ise-nue-sobaled lino-morye-nugadgi be imakoed, degine, mor-gurgin-ebirmakaled amba lino-morgi be imakbaloed. Deginbali, morgo-dub-sadergi-nagued ise-nue-sobar, bela-bela nue-yeerdakle be imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Deginbali, Aarón-e-masmalaga mor-dummad-dubgi-ise-nue-sobaled, degi, morgo-dub-sadergi-nagued, degine, mor-gurgin ega be imakmogo. Adi, oyolegegar, wemarde dule-dummaganye, nue-nug-nikamaladye. ");
INSERT INTO cuk_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","”We-mormar be imaksadi, be-ia-Aarónʼga, degine, e-masmalaga be yooed. Geb degine, gwallu-wawa amar-nonogi be eogoed. Geb degi, dule-irwa-anse-gormaladga-gumalaga be onugsaoed. ");
INSERT INTO cuk_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Deginbali, lino-mor garson-bipi-urba-yolegedga be imakoed, adi, wemar melle uka-swiri gumalagar. We-garson-bipi saderse, geb duase-sugu yooed. ");
INSERT INTO cuk_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aarón, degi, e-masmala, dulemar-anbo-ambikued-negse-dogdemalale, we-garson-bipi-yoi dogmaloed. Degine, anga-ibmar-ogumakar-ukleged-ailase nadmalale, amba we-garson-bipi-yoi dogbaloed. Adi, wemala melle isgumalagar. Ar isgumalale, wemala burgwemaloed. Aarónʼgala, degi, e-masmalagala, we-igar degisadegu-mai guoed.” ");
INSERT INTO cuk_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Bab-Jehová Moisésʼga sogdebalid: “Aarón, degi, e-masmalabo, anga dule-irwa-anse-gormaladga-gumalaga, weyob be imakoed: Be-molimar-abargi moli-bebe-nikad-sapingwa-wargwen, degi, sibad-wawaad-machered-warbo be suoed. Amar, swilidikid be suoed, bonikwasulid be suoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","”Deginbali, trigo-madubur-bur-nuedgi be we-madumar imakoed: Madu-inasulid, madu-olo-olivo-gwallugi-omukualed-inasulid, madu-matargwa olivo-gwallugi-magaled-inasulid. ");
INSERT INTO cuk_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","”We-madumala anse-gorleged-negse sedegala, garba-senigwadgi be urboed. Geb degine, moli-bebe-nikad-sapingwagwad, degi, sibad-wawaad-machered-warbogwad, anga ukega be sedoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","”Geb be, Aarón, degi, e-masmalamala, dulemar-anbo-ambikued-neg-yawagakse be sedoed. Agi be, Aarón, degi, e-masmala, be diigi ogoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Agine, we-mormar-maklesad Aarónʼga be yooed: Mor-dummad-dubgi-ise-nue-sobaled, mor-dummad-suitigwad, mor-efodʼye-nugad, mor-binasgargi-nagued. ”Geb degine, mor-efodʼye-nugad morgo-dub-sadergi-naguedgi ega be edinnoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Deginbali, mor-gurgin-ebirmakaled e-nonogi ega be sioed. We-mor-gurgin-ebirmakaled-birgi or-nued-matargwagwad-islidikid ega be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Geb degine, olivo-gwallu be suoed. Geb we-olivo-gwallu Aarón-nonogi be eogoed. Adi, dule-irwa-anse-goledga onugsalegegar. ");
INSERT INTO cuk_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","”Deginbali, Aarón-e-masmala bese-dagega be imakmogoed. Geb, ega be mor-dummagan-maklesad yomogoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Degi, ega be gurgin simogoed. Deginbali, Aarónʼga, degi, e-masmalaga nuekwa mor-dub-saderba-nagued be edinnoed. Weyobi, Aarón, degi, e-masmala, angarbi-arbamalaga be onugsaoed. Weyobi, dule-irwa-anga-goledga degisadegu gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","”A-sorbali, moli-bebe-nikad-sapingwagwad dulemar-anbo-ambikued-neg-yawagakse be sedoed. Geb Aarón, degi, e-masmala, we-moli-e-nono-birgi e-argan mesmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Geb agi, dulemar-anbo-ambikued-neg-yawagakgi be an-asabin we-moli oburgoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Geb we-moli-e-abe be suoed. Degine, we-abe be-googi anga-ibmar-ogumakar-ukleged-ailagi moli-bebegiid-gwichidgi be mage-mage imakoed. Geb degine, Abe-gwabgusaddi, bela ibmar-ogumakar-ukleged-aila-nagaba be eogoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Deginbali, bela we-ibmarmar be weoed: E-samurgi-gwallu-nanaid, e-bina-dukugi-gwallu-nanaid, e-mirwa-gwabogwadgi-gwallu-nanaid, degi, e-mirwa-gwabogwad. ”Geb a-gwallumala anga ibmar-ogumakar-ukleged-aila-birgi be ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Moli-bebe-nikad-e-sandi, e-ukadi, e-saadi, soogi dulemar-danar-danar-bukmalad-magaba be ogumakoed. Ar we-ibmardi isgued-anar uklegoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","”Geb degine, sibad-wawaad-machered-warbogwad be wargwen suoed. ”Aarón, degi, e-masmala, a-sibad-e-nono-birgi e-arganmar mesmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","We-sibad-wawaad-machered be oburgoed, degine, ibmar-ogumakar-ukleged-aila-e-dikarmargi we-sibad-wawaad-e-abe be bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","We-sibad-wawaad be goamakoed. Geb e-samur, degi, e-malimar, nue be enukoed. Geb degine, wemar-enukaled e-nonoba, e-sanmar-goamakaledba, mesa be urboed. ");
INSERT INTO cuk_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Geb a-sorbali, sibad-wawaad-machered ibmar-ogumakar-ukleged-aila-birgi bela be ogumakoed. We-ibmar-ogumakar-anga-ukleged, an yeer-yapan itogoed. We anga soogi ogumakar uklenaid. ");
INSERT INTO cuk_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","”Geb degine, sibad-wawaad-machered-baid be subaloed. Aarón, degi, e-masmala, a-sibad-wawaad-e-nono-birgi e-arganmar mesmarbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","We-sibad-wawaad be oburgoed. Geb e-abe be abala suoed. Geb Aarón-e-uaya-duku-argan-nuedsikidgi we-abe be magoed. Degine, e-goo-dummad-e-argan-nuedsikidgi, e-nag-goo-dummad-nuedsikidgi we-abe be magbaloed. Amba deyob be Aarón-e-masmala imakbaloed. ”Geb anga-ibmar-ogumakar-ukleged-aila-e-dikarmargi we-abe be bomi-bomi imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Anga-ibmar-ogumakar-ukleged-ailagi-abe-siidi, degi, dule-nugsalenair-olivo-gwallu-ebulegedi, Aarónʼgi be bomi-bomi imakoed, degi, e-mormargi be bomi-bomi imakbaloed. Geb Aarón-e-masmalagi, degi, e-masmala-morgi be bomi-bomi imakbaloed. ”Weyobi, Aarón, e-mormala, e-masmala, degi, e-masmala-mormala, an-asabin anga islidiki guoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","”Geb degine, we-sibad-wawaad-machered-e-gwallu be suoed: E-samurgi-gwallu-nanaid, e-bina-dukugi-gwallu-nanaid, e-mirwa-gwabogwadgi-gwallu-nanaid, degi, e-mirwa-gwabogwad be suoed, degine, e-dua-argan-nuedsikid be subaloed. Ar ade, we-sibad-wawaad dule-irwa-Bab-Dummadse-goled-onugsalegega uklegaledid. ");
INSERT INTO cuk_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","”Deginbali, madu-e-inasurmalad garba-bipi-Bab-Dummad-asabin-siidgi be suoed: Madu-olo, gwagwen, madu-olivo-gwallugi-omukualed, gwagwen, degi, madu-matargwagwad, matagwen. ");
INSERT INTO cuk_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","”Bela we-madumala, Aarónʼga, degi, e-masmalaga, be ukoed. Geb an-asabin bana-bana imakmaloed, adi, anga-ibmar-ukledaedga guegar. ");
INSERT INTO cuk_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","”Geb a-sorbali, Aarón e-argangi-madumar-ganikid bega ukoed. Geb ibmar-ogumakar-ukleged-ailagi be ogumakoed, anga-ibmar-ogumakar-uklesad-ebo mesa be ogumakoed, adi, an nued-yapan itogegar. Ar wede, anga soogi-ogumakar-uklegaledid. ");
INSERT INTO cuk_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","”Deginbali, be anga Aarón-anga-arbaega-onugsalegega, sibad-wawaad-machered-e-binasgar be suoed. Geb we-binasgar be bana-bana imakoed, adi, anga-ibmar-ukledaedga guegar. We-sibad-wawaad-e-binasgar begadga guoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","”Sibad-wawaad-machered-uklesad-e-binasgar anga-bana-bana-uklegaled, bachikii be imakoed, degi, e-dua-sabolesad anga-bana-bana-uklesad, bachikii be imakbaloed. Wemala, Aarónʼga, degi, e-masmalaga uklegoed. Ar we-ibmarmar, Aarón, degi, e-masmala, anga-arbaega-onugsalenaidgi sulesad. ");
INSERT INTO cuk_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","We-ibmarmala Aarónʼga, degi, e-masmalaga uklegoed. Weyob Israel-dulemarga degibi-sadegu igar-maigu guoed. We-ibmar-uklegedi, Israel-dulemar ukdii guoye sogleged. We-uklegedi, gwenatigwar-guega-ibmar-ukleged guoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","”Aarón-mormar-islidikmalad, anse-dule-irwa-gorsokalir-yoleged, Aarón-sorba, e-wagan sumaloed, adi, a-mormar-yoi anga dule-irwa-Bab-Dummadse-gormaladga-nugsalemalagar. ");
INSERT INTO cuk_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aarón-e-wagan-wargwen, e-bab-sorba dule-irwa-anse-golega-sulesar, anga Neg-Islidikidgi-arbaega, dulemar-anbo-ambikued-negse nonikile, we-mola yooed. Ibagugle (7) we-mola-yoi gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","”Anga-arbaega-dule-onugsalesadgi sibad-wawaad-machered-uklegaled-e-sana be suoed. A-e-sana nega-islidikidgi be duoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aarón, degi, e-masmala, we-sibad-wawaad-machered-uklegaled-e-san, degi, garbagi-madu-siid, dulemar-anbo-ambikued-neg-yawagakgi gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","We-ibmarmar-uklesadbali, an wemar isgussuliyob daknonikid, degi, anga-arbaega dule-irwa-golega-gumalaga nugsalesmalad. Degisoggu, we-ibmarmar Aarónʼbi, degi, e-masmalabi gunmaloed. Ar we-ibmarmar anga uklegaledsoggu, dule-baigandi gunnosurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","We-sanmar-anga-uklegaled, degi, we-madumar-anga-uklegaled, obichale, be soogi ogumakoed. Ar we-ibmarmar ibmar-swilidikmaladsoggu, oibosadgine melle bar gunno. ");
INSERT INTO cuk_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","”Degisoggu, an-bela-bega-sogsadba, deyob be, Aarón, degi, e-masmala be imakoed. Wemala anga-arbaega-onugsalegega, ibagugle (7) egi be arbaoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","E-isgumalad-elilegegala, anga be bane-bane moli-bebe-nikad-sapingwagwad ukoed. Degidbali, ibmar-ogumakar-ukleged-aila anga-uklegega guagwar signonikoed. We-aila anga-uklegoedi, olivo-gwallu egi be mage-mage imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Deyob isgued-elilegegala, degi, angadga-aila-guegala, ibagugle (7) be imakoed. Degine, deyob aila angadga sii guoed. Degi, ibu-ibmar we-aila-ebusale, bela-ibmar angadga gunonimogoed.” ");
INSERT INTO cuk_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Bab-Jehová Moisésʼga sogdebalid: “Bab-Dummadga-ibmar-ogumakar-ukleged-ailagi bane-bane wemar be ukoed: Sibad-wawaad-sapingwa-birgagwen-nikad walabo be ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Wakdar we-sibad-wawaad wargwen be oburgoed, sedogi be baid oburgwebaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Deginbali, we-sibad-wawaad-gebe-oburgwilegoedba be we-ibmar ukoed: Madubur-bur-nued, nibiratar, olivo-gwallu, bute-wargwen eba be oburoed. Degine, anga be egi vino, bute-wargwen-mergu eobaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Geb sedogi, sibad-wawaad-baid be oburgwebaloed. Wakdar-imaksadyob be imakbaloed. We-ibmar-soogi-ogumakar-ukleged an yeer-yapan itodaedid. ");
INSERT INTO cuk_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","”Anse-goled-neg-dogedgi an bebo-sunmakega bebo-abinguoedgi, be-wagan degisadegu, an-asabin, anga we-ibmar-ogumakar-ukmai gumaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Deginbali, agi an, Israel-dulemarbo abingubaloed. A-nega, an-egi-gandikidba-gudii guoedbali, neg-islidikidga guoed. ");
INSERT INTO cuk_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","”Dulemar-anbo-ambikued-neg, degi, anga-ibmar-ogumakar-ukleged-aila angadga an imakoed. Deginbali, Aarón, degi, e-masmala, angadga an imakbaloed, adi, dule-irwa-anse-gormaladga gumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ani an Israel-dulemar-abargi gudii guoed, degine, e-Bab-Dummadga an gubaloed. ");
INSERT INTO cuk_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Adi, deyob Israel-dulemar wisgumaloed: Ani an, e-Bab-Dummad-Jehová guye. Ani an, emar-Egipto-yargi-wilebukwamargu, onosye, adi, emar-abargi an gudii guegarye. Ar ani an, Bab-Jehová gued, ani an, e-Bab-Dummadid.” ");
INSERT INTO cuk_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Bab-Jehová Moisésʼga sogdebalid: “Deginbali, anga ina-wawadikid-ogumaked-aila be sobbaloed. Agi ina-wawadikid obupurmaklegegar. We-aila-sobegala, urgomar-acaciaʼye-nugad be ebugoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","We-aila, achabo-sugu imaklegoed, e-matardungued, achabobar. E-sugued, e-matardunguedbo emar-dungu guoed. E-nibgueddi, dali-abala. E-moli-bebegiid ailaba-mesa be soboed. ");
INSERT INTO cuk_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Birgi be or-nued nasikoed: E-birgi-akinnar-maidgi, bela e-dikarmargi, e-moli-bebeyob-daklegedgi, bela amargi, or be nasikoed. E-dikarbali, ormar-mullu-ebirar be mesbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Deginbali, ormar-mullugalad-urba olua-bela-olobiid gwabo, e-dikarmargi be nasikoed, adi, nabir suarmar-suitigwad egi dogega, aba nabir selegegar. ");
INSERT INTO cuk_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","We-suarmar-suitigwad-imakega urgo-acaciaʼye-nugad be ebugoed. Degine, we-suarmargi or egi be ebiris nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","”Geb degine, ina-wawadikid-ogumakleged-aila sigoed, bia mor-dummad Dulemar-Anbo-Igar-Mesisad-Ulu-Eduged-Maid-Irwa nai, a-asabin, bia an bebo-abinguoe, agi be sioed. ");
INSERT INTO cuk_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","”Aarón bane-bane, wakudaryalaba, gwallumar guakwaa imakalile, ina-wawadikid-ogumakleged-ailagi anga ina-wawadikmalad ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Deginbali, neg-sedogusale, Aarón, sedo-gwallu-ogaalile, anga ina-wawadikidmalad ogumakbaloed. Degibi-sadegu, an-asabin be-wagan we-ina-wawadikidmalad obupurmakdii gudoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","We anga-ina-wawadikmalad-ogumakleged-ailagi: Ina-wawadikmalad-baid uklegosulid, ibmar-durgan ogumaklegar uklegosurbalid, degine, anga-ibmar-gwag-ukleged agi uklegosurbalid, degine, a-birgi egi be ibmar eogosurbalid. Unnila ina-wawadikidmaladbi be ogumakoed, an bega sogsadyob. ");
INSERT INTO cuk_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","”Aarón, birgagine, isgued-eliega, we-ina-wawadikmalad-ukleged-ailagi, e-moli-bebeyob-daklegedgi, anga-ibmar-ogumakar-uklesad-e-abe egi mage-mage imakoed. Birgagine, irgwennaa deyob imakoed. Be-wagan, degisadegu imakdii gudoed. We-aila angadga guoed.” ");
INSERT INTO cuk_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Bab-Jehová Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Israel-dulemar be ebichidele, na san-bendakmalagala, wala-walagwen an-bennukmaloed. Ebichilesadba bennukmaloed, adi, melle bemargi boni-dummagan ainiegar. ");
INSERT INTO cuk_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","”Bela dulemar-ebislesmalad mani-gramo-atar (5) bennukoed: We-mani anse-goled-neggi-mani-aidikued-wilub-negabar gued. ”We-mani anga ibmar-uklegedga guoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bela dulemar-birga-dulagwen-nikamalad (20), degi, bela aba-obine-birga-nikamalad-ebislesmaladi, anga we-mani ukoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","”Dulemar, na san-bendakmalaga anga mani-ukarmalale, dule-mani-ibed mani gwen-obine ukosulid. Dule-wileged gwen mani-ichee ukosurmogad. Anga we-mani ukarmalar, bela mani-gramo-atar ukmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Degisoggu, be-sunnagwad be Israel-dulemar-we-mani-ukarmalar, be suoed. Geb a-mani, dulemar-anbo-ambikued-neggi-arbalegega-ebulegega be ukoed. ”Weyobi, an insaegalad, Israel-dulemar na e-san-onogegala, a-anar mani uksamarye.” ");
INSERT INTO cuk_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Bab-Jehová Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Deginbali, dii-sied esgoro-gordikidbi be soboed. E-sigedga-guoedi, esgoro-gordikidbi be imakoed. A-dii-sied argan-enukega-ebulegega be imakoed. We-dii-sied be sioedi, dulemar-anbo-ambikued-neg-siid, degi, anga-ibmar-ogumakar-ukleged-aila-siid, amar-imbagi be sioed. Geb egi be dii enogoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","A-diigi, Aarón, e-masmalamala, e-arganmar, degi, e-malimar, enukmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Wemala, dulemar-anbo-ambikued-neggi-dogdedibe, degi, anga-ibmar-ogumakar-ukleged-ailase warmaknadele, ");
INSERT INTO cuk_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","e-arganmar, degi, e-malimar enukmaloed. Ar degi-imaksulile, burgwemaloed. We degisadegu, weyob Aarónʼga, degi, e-waganga we-Igar maigu guoed.” ");
INSERT INTO cuk_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Bab-Jehová Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ina-nuegan-yeer-yapanmalad be suo: Mirraʼye-nugad-diregwad, nibirambe-gakapaa (13). Canelaʼye-nugad-yeer-yapanned, nibirnergwa-abala (6½). Cálamoʼye-nugad-yeer-yapanned, nibirnergwa-abala (6½). ");
INSERT INTO cuk_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Casiaʼye-nugad, nibirambe-gakapaa (13), degi, olivo-gwallu, galón-gwagwen. Anse-goled-neggi ibmar-oaidikued-wilubsiidgi be wilubsaoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","”We-inamar olivo-gwalluba bela be oburoed, anga olivo-gwallu-wawadikidga guegar. We-gwallu-wawadikid be imakoedi, dule-gwallu-wawadikid-imakdaedyob be imakoed. We-gwallu-wawad angadga guoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","We-gwallu-wawadgine be wemar magoed: Dulemar-anbo-ambikued-neg, Dulemar-Anbo-Igar-Mesisad-Ulu, ");
INSERT INTO cuk_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","mese, degi, bela eba-ibmarmar-ebulemalad, gwallu-sied, degi, bela eba-ibmarmar-ebulemalad, ina-wawadikmalad-ogumakleged-aila. ");
INSERT INTO cuk_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Anga-ibmar-ogumakar-ukleged-aila, degi, bela eba-ibmarmar-ebulemalad, degine, dii-sied esgoro-gordikidgi-sobaled, bela e-malise-bakar. Amar bela we-gwallu-wawadgine be magoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","”Weyobi anga-ibmar-uklegaledga guoed. Bela we-ibmarmala angadgarbi guoed. Ibu-ibmar we-ibmarmar-ebusale, bela angadgarbi gunonimogoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","”Deginbali, Aarónʼgi, degi, e-masmalagi, be we-gwallu-wawad eogoed, adi, anga dule-irwa-anse-gormaladga gumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israel-dulemarga be sunmakoed, ega be sogoed: ‘We gwallu-wawad, degisadegu, gwallu-wawa-eoleged-islidikidga guoye. ");
INSERT INTO cuk_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","We-gwallu-wawad dule-bamaladgi eolegosulid, degine, we-gwallu-wawad-imakaledyobi, baid-gwallu-wawad be imakosulid. We-gwallu-wawad, gwallu-wawad-islidikidid. Degisoggu, gwallu-wawad angadgarbi-gued be dako. ");
INSERT INTO cuk_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","” ’Ar doa-dule, we-gwallu-wawad-imakaledyob baid-gwallu-wawad-imaksale, dulemar-irwa-anse-goledsulidgi eosdibe, e-dulemar-abargi ononnolegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Degine, Bab-Jehová Moisésʼga sogdebalid: “We-gagan-yeer-yapanmalad-e-gichi be weo: Estacteʼye-nugad-e-gichi, ámbarʼye-nugad-e-gichi, gálbanoʼye-nugad-e-gichi, ina-wawadikid-incienso-nued. We-gagan-yeer-yapanmalad-e-gichi bela emarbi-mergu be weo. ");
INSERT INTO cuk_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","”Bela-we-gagan-yeer-yapanmalad-e-gichi be oburoed. Igi ina-wawadikid-sobed-dule ina-wawadikid sobe, deyob be ina-wawadikid-inciensoʼye-nugad be soboed. Gagan-yeer-yapanmaladi ise-nue-oburar be imakoed. Balu egi be mesbaloed. Baid-ibmar egi be oburosulid. We-ina-wawadikid-inciensoʼye-nugad, angadgarbi guoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","We-ina-wawadikid bela ise-nagar, ise-ubimakar be imakoed. We-ina-wawadikid, Dulemar-Anbo-Igar-Mesisad-Ulu-siid-asabin, dulemar-anbo-ambikued-neggi be sioed. Agi, an bese magarogoed. We-ina-wawadikid bela-bela bemarga angadgarbi-ebulegega guoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","We-ina-wawadikid be imakoedi, baid-ina-wawadikid weyob-oburale, be imakosulid. We-ina-wawadikid Bab-Jehováʼgadgarbi be dakoed. ");
INSERT INTO cuk_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","”Ar doa-dule weyob ina-wawadikid-e-yapanned-uega imakalile, we-dule, e-dulemar-abargi ononnolegoed.” ");
INSERT INTO cuk_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Nue be an-itogo. Hur-e-wagwa-Judá-yargined Uri-machi-Bezaleelʼye-nugad an susad. ");
INSERT INTO cuk_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","We-Bezaleelʼga An-Burba an ega nue-uksad. Nue-binsaed-nikagued an ega uksad, nue-ibmar-magar-itogued an ega uksad, nue-ibmar-wisigued an ega uksad, degine, nabir-ibmar-obinyemaigued an ega uksad. ");
INSERT INTO cuk_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Adi, nabir ibmar yeerdakle-sobegar, nabir orgi-arbaegar, nabir manigi-arbaegar, nabir esgoro-gordikidgi-arbaegar. ");
INSERT INTO cuk_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Degine, nabir akwa-nuegangi-arbaegar, nabir akwa-nuegan ibmar-birgi siegar, nabir urgomargi-arbaegar, degine, nabir-galagwensuli ibmar-yeerdakle-imakegar. ");
INSERT INTO cuk_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","”Deginbali, Bezaleel-bendakega, Dad-dummad-Dan-wagwa Ahisamac-machi-Aholiab an susbalid. Dule-nue-ibmar-wisimalad, gatik-ibmar-wisguega an imaksad, adi, bela an-ibmar-sogsadba bega imakmalagar, we-ibmargi arbamalagar: ");
INSERT INTO cuk_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Dulemar-anbo-ambikued-neggi, Dulemar-Anbo-Igar-Mesisad-Ulugi, Dulemar-Anbo-Igar-Mesisad-Ulu-edugedgi, degi, anse-goled-neg-sunna-selegedgi bela-ibmar-ebuleged sobegar. ");
INSERT INTO cuk_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Degine, mese, geb bela-eba-ibmarmar-ebulemalad. Gwallu-sied-bela olobiid, geb bela eba-ibmarmar-ebulemalad. Anga-ina-wawadikid-inciensoʼye-nugad-ogumakleged-aila. ");
INSERT INTO cuk_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Anga-ibmar-ogumakar-ukleged-aila, geb bela-eba-ibmarmar-ebulemalad. Dii-sied-esgoro-gordikidgi-sobaled, geb bela e-malise-bakar, sobegarbar. ");
INSERT INTO cuk_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Degine, we-mormar makmarbaloed: Aarón-mor-islidikmalad, degi, e-masmala-mor-anse-dulemar-irwa-gorsokalir-yodamalad. ");
INSERT INTO cuk_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Olivo-gwallu-magega-ebuleged, degi, ina-wawadikid Neg-Islidikidgi-ebuleged sobegarbar. Wemala, Bezaleel, degi, Aholiab-ebogwa bela sobmaloed. ”Ar igi bela an bega sogsa, deyob sogedba imakmaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Bab-Jehová Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Israel-dulemarga be sunmakoed, ega be weyob sogo: ‘Napira an bemarga soged, an-obunnoged-ibagi be obunnomalo, ar ade, wede bemar-ebo an-Igar-Mesnaid e-wilubga gued. Be-waganga we-Igar degisadegu mai guoed, adi, be wisgumalagar, ani an Bab-Jehová gued. Ani an be-sunonimalad, anga arbadii gumalagar. ");
INSERT INTO cuk_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Degisoggu, obunnoged-ibagi mer arbamalo, ar ade, a-iba bemargala iba-islidikidid. A-ibagi, dule obunnogergebed. A-ibagi, dule wis arbasale, we-dule e-dulemar-abargi Israel-dulemar-abargi-onolegoed. ");
INSERT INTO cuk_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ibanergwa (6) arbalegoed, ibagugledgindina (7), obunnoged-ibad. We-iba Bab-Jehováʼgadid. Ar doa-dule we-ibagi arbaye-sogele, napira an bega soged, we-dule oburgwilegedsegad.’ ");
INSERT INTO cuk_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","”Degisoggu, Israel-dulemala obunnoged-ibagi arbaosurmalad. E-waganmargala we-Igar degisadegu-mai guoed. ");
INSERT INTO cuk_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Israel-dulemar-anbo-we-Igar-Mesnaid e-wilubga guoed, degisadegu-maigu guoed. Ar Bab-Jehová, nibneg-nasikegala, napneg-nasikegala, ibanergwa (6) arbasad. Ibagugledgindi (7), bar arbassulid. Bab-Dummad a-ibagi obunnosad.” ");
INSERT INTO cuk_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Bab-Jehová, Sinaí-yargi Moisésʼbo-sunmaknaid-bergusgua, Israel-Dulemarbo-Igar-Mesnaid-e-wilubga-guega, Moisésʼga akwa-matargwagwad-matabo uksad. We-akwagi-Igarmar-narmaklesadi, Bab-Dummad na e-sunnad e-googi narmaksad. ");
INSERT INTO cuk_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Israel-dulemar dakdegu, Moisés yar-birgi-gudiid gwen aidedasuli, Aarónʼse nade gusmalad. Ega sogdemalad: —¡Aarón! Be anmarga bab-dummagan sobe, adi, anmar-idu-nadap gumalagar. Ar Moisés-Egipto-yargi-anmar-onosad, anmar wissulid, wede igi-gusa. ");
INSERT INTO cuk_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aarón dulemar-abin sogded: —Be-omegan-uaya-dukugi-ormar-nanaid, be-bunamala-uaya-dukugi-ormar-nanaid, be-masmala-uaya-dukugi-ormar-nanaid be ungemardo. Geb be anse sedamalo. ");
INSERT INTO cuk_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Geb degine, bela dulemar uaya-dukugi olua-nanaid unnusmalad, geb bela Aarónʼse senonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aarón bela we-ormar abingasad. Geb soogi or dusad. Binna-binna sobe-sobe imaksad, moli-bebe-nikad-sapingwagwadga obinnisad. Geb degine, bela sogdemalad: “¡Israel-dulemar! Wemar be-bab-dummagan-dake. Wemar, Egipto-yargi bemar-onosad-dake.” ");
INSERT INTO cuk_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aarón weyob dulemar-daksagu, moli-bebe-nikad-asabin ibmar-ogumakar-ukleged-aila sobsad. Geb binnasur sogded: “¡Oibosale, Bab-Jehováʼga iba-dummad anmar onomaloed!” ");
INSERT INTO cuk_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Oibosgu, wakudaryalaba dulemar ailagi ibdurgan-ogumakar uksamalad, degine, gwenatigwar-guegala, ibmar uksamarbalid. Geb mas gutemalad, gobdemalad. Bela galagwensuli wergudmalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Geb degine, Bab-Jehová Moisésʼga sogded: —Be nae, be aidena. Ar be-dulemar, Egipto-yargi be onosadi, nue-isgudmalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","An-ega-Igar-uksadgi bato bangudmalad. Emide, or dusmalad, moli-bebe-nikad-sapingwagwadyob sobsamalad. A-molise Bab-Dummadyob ese gornanaid, Bab-Dummadyob ega ibmar-ogumakar uknanaid. Sogdemalad: ‘Israel-dulemar, we be-bab-dummagan-dake, we Egipto-yargi bemar-onosad-dake.’ ");
INSERT INTO cuk_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Bab-Jehová Moisésʼga sogdebalid: —We-Israel-dulemar an dakedi, nue dulemar-non-dutusurmaladid. ");
INSERT INTO cuk_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Degisoggu, emigindi be an-dako. An sae-itoged. We-dulemar an obelogoed. Bedina, wagan-bukidar-nikuega an be-imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Geb degine, Moisés e-Bab-Dummad-Jehová-urwed-bargaegala, ega sogded: —Bab-Jehová, ¿ar ibiga sae-itogedba be-dulamar be obelodagoe? ¿Ar na be Egipto-yargi be-gangued-dutusulidba onossursi? ");
INSERT INTO cuk_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ar ibiga Egipto-dulemar-weyob-sogega be imakoe: ‘Emide be dake, Bab-Dummad Egipto-yargi we-dulemar-onosad, yala-imbaba-oburgwega onosad. Bela we-napneggi-obelogega onosad.’ Melle be sae-itoge. Melle we-dulemar-obelogedgi binsae. ");
INSERT INTO cuk_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Be-maimar Abraham, Isaac, degi, Jacob, amar be ebinsae. Ar amarga be sogsa gusad, an ise-sogar sogye: ‘Niisgwamar-nibneggi-nanaidyob be-wagan an bega omelogoye. Degine, be-waganga we-yarmar-nanaid degisadegu egadga guoye.’ ");
INSERT INTO cuk_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Geb degine, Bab-Dummad e-dulemar-obelogoye-sogsagusadi, emisgi sogdesunnad, bar obelogosurye. ");
INSERT INTO cuk_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Geb degine, Moisés yar-birgi-gudiidi aidealid. Moisés akwa-matabogwad Bab-Dummad-Israel-Dulemarbo-Igar-Mesnaid-narmakaledi e-argangi-sedani aidealid. Igar-Mesilesad akwa-matabogwadgi abinbela narmakaled. ");
INSERT INTO cuk_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Bab-Dummad akwa-matabogwad imaksad, degi, e-sunnad egi narmaksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Geb degine, Josué dule-bukidar oimake-itoargu, Moisésʼga sogded: —Dulemar danar-bukwadgi urwe-nana an itodo. ");
INSERT INTO cuk_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moisés, Josuéʼga sogded: —We-oimak-an-itogedi, bilagi-nakwisadyob gwen oimake an itosulid. Bilagi-galakusadyob gwen oimake an itosurbalid. An itogedi, dulemar namakmar an itodo. ");
INSERT INTO cuk_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Moisés dulemar-bukwadse-aidenonigua, moli-bebe-nikad-sapingwagwad-sobaled dakded, degine, dulemar-dodonanai dakdebalid. Moisés deyob dakdegu, sae-itoded. E-argangi-akwa-matabogwad-ganikid binnasur meted. Yar-dikarba we-akwa-matabogwad mamarisad. ");
INSERT INTO cuk_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Geb degi, Moisés, moli-bebe-nikad-sapingwagwad-soblesad susad, geb ogumakega soogi balimeted. Geb doo-doo imaksad, bela ubi-ubi-imakedse sasad. Geb degine, diigi mie-mie imaksad. A-diigi Israel-dulemar-ogobsad. ");
INSERT INTO cuk_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Geb Moisés Aarónʼga sogded: —¿Igi we-dulemar be-imaksa? Emide be, we-dulemar dummad-isguega be imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aarón Moisés-abin sogded: —Dummad, mer be anse urwe. Ar be wisid, we-dulemar unnila isguedginbi binsadidamalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ar we-dulemar anga sokarmalad: ‘Anmar-idu-nadap-guegala anmarga bab-dummagan be sobye. Ar ade, anmar wissuliddeeye, we-dule-Moisés Egipto-yargi-anmar-onosadi, igi-gusdibeye.’ ");
INSERT INTO cuk_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Geb degine, an ega sogdesunnad: ‘Dule or-nikadi, anga sedamalo.’ Agi anga or uksamarsunnad. Geb soogi an ormar meted. Geb degine, we-moli-bebe-nikad-sapingwagwad noarsunnad. ");
INSERT INTO cuk_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moisés dakdegu, dulemar geg na san-bargamala, Aarón, gwen we-dulemar-san-bargaega imaksasuli, deginbali, we-Israel-dulemala, e-isdarmalad-dodogedga gudoe, ");
INSERT INTO cuk_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","degidbali, Moisés dulemar-danar-bukwad-dogedgi gwisgusad, amarga sogded: “Ar doamar Bab-Jehováʼba nanai-itomala, anse dagmalo.” Agi bela Levita-dulemar Moisésʼba akadmalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Moisés amarga sogded: “Weyob Israel-e-Bab-Dummad-Jehová soged: ‘Bela bemar na es-suid nasikmalo, dulemar-danar-danar-bukwadse gannar be namalo, dulemar-e-dordo-e-dordonegse be namalo. Be-gwenaddibe, be-aidibe, be-neg-dikarba-mamaiddibe, be oburgwemalo.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levita-dulemar Moisés-ega-sogsadba bela imaksamalad. A-ibagi, dulemar-milipaa-gubin (3,000) oburgwismalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Geb degine, Moisés Levita-dulemarga sogded: “Emi-ibagi, bemar, be-masmalagi-aibichad-ular, be-gwenadgangi-aibichad-ular, Bab-Jehováʼga-arbaega be gunonimalad. Degisoggu, Bab-Jehová, emi-ibagi, ise-nued bemargi binsanonimalad.” ");
INSERT INTO cuk_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Degidgine, oibosgua, Moisés Israel-dulemarga sogded: “Bemala nue-dummad-isgusmalad. Degi-inigwele, Bab-Dummadbo-igar-nabogegala, Bab-Jehováʼse an nakwenaoed, abakalegi, Bab-Dummad nabir bemarga isgued-elialile.” ");
INSERT INTO cuk_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Geb degine, Moisés Bab-Jehováʼse gannar nonikid, ega sogded: —Ar we-Israel-dulemar or-sobaled bab-dummadga-imaknonimargu, nue-dummad-isgunonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Degisoggu, Bab-Dummadye, we-dulemar-e-isgusad ega be eliena gadin. Ar degisulile, be-gardagi an-nug-narmakar-naid be elisunna. ");
INSERT INTO cuk_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Bab-Jehová Moisés-abin sogded: —Ar dule-angi-isgusadbi an-gardagi-e-nug-narmakar-naid an ei elioed. ");
INSERT INTO cuk_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Degisoggu, bedi be nae. We-dulemar an-bega-sogsad-yarse be sede. An-baliwitur be-idumai guoed. Ar dulemar-angi-isgusmaladdi, e-odurdakleged-ibagan-nonikile, e-isgusmaladba an a-dulemar sabsur-odurdakoed. ");
INSERT INTO cuk_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Geb deyobi, Bab-Dummad-Jehová Aarón-moli-bebe-nikad-sapingwagwad-sobsad-ular, Israel-dulemargi boni-dummad barmialid. ");
INSERT INTO cuk_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Geb Bab-Jehová Moisésʼga sogded: “Emigindi, wegi be nae. Be Egipto-yargi-dulemar-onosadmala be nae. Abrahamʼga, Isaacʼga, degi, Jacobʼga an ise-sogar-sogsad, ‘we-yala an be-waganga ukedseye’, a-yarse be namala. ");
INSERT INTO cuk_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Be-idugega an-baliwitur an bega barmidoed. Degine, we-dulemar an be-idu onioed: Canaán-dulemar, Amorreo-dulemar, Het-dulemar, Ferezeo-dulemar, Heveo-dulemar, Jebuseo-dulemar. We-dulemar bela an be-iduar onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","”Yar-gadi-ibmar-sanmakedse, napa-nuedse, be nao. Andi an bemarba barnaosulid. Ar bemardi uaya-gwen-niksurmaladsoggu, abakalegi igarba an bemar-obeloalile.” ");
INSERT INTO cuk_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Israel-dulemar Bab-Dummad-weyob-soge itosmargu, bela bukib-itodmalad, ogormakdemalad. Degine, ormar-yeerdaklemalad bar nasissurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ar Bab-Jehová Moisésʼga sogsad: “Israel-dulemarga be sogoye: ‘Bemar dulemar-uaya-gwen-niksurmaladye, non-dutusurmaladye. Ar wis sikwas an bemarba naye sogele, anse bemar osulolesmalarye.’ ” Bab-Jehová sogdebalid: “Israel-dulemarga be sogbalo: ‘Ormar-yeerdaklemalad ungemaloye. Sorba an dakoye, igi an bemar-imakodibeye.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Degidbali, Horeb-yar-akar Israel-dulemar ormar-yeerdaklemalad bar yossurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moisés dordoneg sesagusad, geb dulemar-danar-danar-bukwad-magaba sisad. A-dordoneg onug-imaksad: “Bab-Dummad-dulebo-sunmaked-dordonegye.” Ar dule Bab-Jehováʼse idakbiele, dulemar-danar-danar-bukwadgi noergebdaed, geb Bab-Dummad-dulebo-sunmaked-negse naddamalad. ");
INSERT INTO cuk_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Moisés we-dordonegse nadele, bela dulemar e-dordoneg-yawagak-magaba gwisgusdamalad, Moisés Bab-Dummad-dulebo-sunmaked-dordonegse dogedse egi atakgwichidamalad. ");
INSERT INTO cuk_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Moisés dordoneggi dogdele, mogir-bubawaryob-gwichidi aideardaed, dordoneg-yawagakse aidenonidaed. Agine, Bab-Jehová Moisésʼbo sunmakdedaed. ");
INSERT INTO cuk_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Israel-dulemar dakdele, mogir-bubawaryob-gwichidi dordoneg-yawagakgi aidenoniki, bela na e-neg-yawagakgi dulluu napase imakdedamalad, deyob Bab-Dummad-nug-ogannoddamalad. ");
INSERT INTO cuk_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Igi-dule na e-ai-ebo sunmake, deyobi Bab-Jehová Moisésʼbo asabin-asabin sunmakdaed. Geb Moisés, Bab-Dummad-ebo-sunmaksale, dulemar-danar-danar-bukwadse nonidaed. Degine, Moisés-e-bendaked-sapingwa Nun-machi-Josuéʼye-nugad, we-dordoneggi gwen bangudisulid. ");
INSERT INTO cuk_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moisés Bab-Jehováʼga sogded: —Emide be anga sognagu: ‘We-dulemar be sedye.’ Degite, be anga sogsulid, doa be anba barmidoe. Emide be anga sogbalid: ‘An be-wisi be doa-gue, yeer an be-dake, be angi nueddae.’ ");
INSERT INTO cuk_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ar degite, begi-nueddae be an-dakedde, emigindi, an bese wilesakwaa egissundo, be-ibmar-abeged be anga oyodo. Adi, an begi mer benguegar, nued be an-dakegar. Be insao, we-dulemar be-dula gumalad. ");
INSERT INTO cuk_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Bab-Jehová Moisésʼga sogded: —An-sunnad an beba gudioed. Ani an baisur-ito-gudii be-imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moisés Bab-Dummad-abin sogded: —Ar be anmarba nasulile, melle wegi-naye be anmarga sogdo. ");
INSERT INTO cuk_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ar be anmarba dagsulile, ¿ar igi-degite anmar wisguosunna, be anga ibmar-sogsadi nue-napiraye? ”Ar be anmarba gudiirdi, adi, anmar magar daklemaloed, anmardi emaryobsurye, dulemar-bamaladbo akarsailaye.” ");
INSERT INTO cuk_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Bab-Jehová Moisés-abin sogded: —Be-anga-sognaidi an bega imakodo. Ar an be-sabed, an be-wisid be doa-gue, ar be an-ai gued. ");
INSERT INTO cuk_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Geb degine, Moisés Bab-Jehováʼga sogded: —An bese wilesakwaa wis egised, be-gangued-yeerdakleged be anga oyoge. ");
INSERT INTO cuk_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Bab-Jehová Moisés-abin sogded: —Bela an-nueddaed an bega oyogoed. An-nug-Jehová-wisguega an be-imakoed. Ar doagi an nued binsabie, an egi nued binsaoed. Ar doa an wiledakbie, a-dule an wiledakoed. ");
INSERT INTO cuk_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Bab-Jehová sogdebalid: —Degi-inigwele, an-wagardi be dakosulid. Ar dule bipisaale an-wagar dakosurguoed. Dule an-wagar daksale, bar dula-gudii guosulid, burgoed. ");
INSERT INTO cuk_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Geb degine, Bab-Jehová sogdebalid: —Wegi, an-nagabasaar-akwasiid-birgi be gwisgue. ");
INSERT INTO cuk_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","An-gangued-yeerdakleged be-asabin-nadapidgi, akwa-mararmaid-gullugwadgi an be-ogwisguoed. An-argangi an be-ibya edugoed. Geb an begi-nasale, an-argan an oniroed. ");
INSERT INTO cuk_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Geb an-argan an onirisale, an-yarganbi be dakoed. An-wagardi, be dakosurguoed. ");
INSERT INTO cuk_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Bab-Jehová Moisésʼga sogded: “Be akwa-madareged-matabogwad iduar-be-marisgusadyob, be gannar sobbalo. A-akwa-matabogwadgi, an iduar-narmaksayob, gannar an narmakbaloed. ");
INSERT INTO cuk_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Degisoggu, banedse wakudaryalaba be Sinaí-yar-bur-birise naknao. A-yar-birse be anse nonikoed. ");
INSERT INTO cuk_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Dule-baid bipisaale beba nakosulid, dule-baid bipisaale, a-yargine, gudii guosurbalid. Deginbali, sibad-wawaadse-bakar, degi, moli-bebe-nikamaladse-bakale, bipisaale a-yar-walikaa gagan-manai guosurmalad.” ");
INSERT INTO cuk_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moisés gebe-idualedyobi akwa-matargwa-matabo-nued sobsad. Geb degine, Moisés, Bab-Jehová-ega-sogsadba, wakudaryalaba gwisgualid, agi, Moisés akwa-matabogwad-semai Sinaí-yar-birise nakwided. ");
INSERT INTO cuk_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Geb degine, Bab-Jehová mogirba aidenonikid, Moisésʼse walik-gunonikid. Geb Bab-Jehová e-nug-wisguega Moisés-imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Bab-Jehová Moisés-asabin-nadapgua, binnasuli weyob sogded: “¡Ani an Bab-Jehová gued! ¡Ani an Bab-Jehová gued! Ani an Bab-Dummad-dutusulidid. Ani an dulemar-wiledaked-dummarbadid, Ani an nue-dulemar-wiledakedid. Ani an wissur-gwae-gwae urwedid, Ani an nue-dulemar-saberbadid. An-ibmar-soged, napiragwadid. ");
INSERT INTO cuk_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ani an degisadegu dulemar-sabgumaiguadid. Dule-ibmar-isgana-imaked ibmar-isgana-imaksuliyobi an dakedid. Dule-angi-gwisgued, angi gwisgusuliyobi an dakedid. Dulega an e-isgued elibalidid. ”Degi-inigwele, dule-nue-e-isgusadba, sabsur-odurdakleged-igardi an ega mesedsegad. Babgan-isgusar, e-mimmiganse-bakar, e-wagan, e-wagan-yokorsegadse-bakar, an sabsur-odurdakedsegad.” ");
INSERT INTO cuk_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Geb degine, Moisés e-bebe-ebulegedse napase yog-e-wagar dulluu imaksad. Geb Bab-Jehová-nug-odummoded, weyob sogded: ");
INSERT INTO cuk_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Dummad, ar nue-napiragwale, an begi nueddae be an-dakele, be anmar-abargi be gudii imake. Dummad, an wisi, we-dulemar nue-uaya-gwen-niksurmaladid, nono-dutusurmaladid. Degi-inigwele, anmar-ibmar-isgana-imakmalad, anmar-isgued, anmarga be elie. Be-dulamarga be anmar-imake.” ");
INSERT INTO cuk_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Bab-Jehová Moisésʼga sogded: “Nue be itogo. Ani an bemarbo igar mesoed. Ani an bemar-abargi, dulemar-baiganga-gwen-ibmar-oyoledisulid, we-napneggi-ibmar-dakledisurmalad, an imakoed. Degine, bia be dulemar-baigan-abargi be gudii gumaloe, a-dulemar ibmar-dakledisurmalad-an-bemarga-imakoed nue-dakmaloed. Ani, Bab-Jehová, ani an imakoed. ");
INSERT INTO cuk_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","”Emi an-bega-ibmar-sognaidba be nanadii guo. Be-asabinni an we-dulemar onogoed: Amorreo-dulemar, Canaán-dulemar, Het-dulemar, Ferezeo-dulemar, Heveo-dulemar, Jebuseo-dulemar, an onogoed. ");
INSERT INTO cuk_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","”Canaán-yarse be dogsokalir, dulemar-a-yargi-bukmalad-ebo melle be igar-mesdii nanamalo. Ar deyob be imakmalale, sunna ese be yardaklemalad. ");
INSERT INTO cuk_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Dulemar-bukmalad-ibe e-bab-dummadgan-e-ailamar be earmalo, e-akwamar-bab-dummadga-sobarmalad e-ibe be omukumalo, degine, e-bab-dummad-bundor-Asera-sobaledi, bela e-ibe be osulomalo. ");
INSERT INTO cuk_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","”Ar ani Bab-Jehová gadi-nobgusoggu, baid-bab-dummagan-asabin be dulluu imakosurmalad. Ar Bab-Jehová, e-nug-nugadi Gadi-Nobguedye nugad. ");
INSERT INTO cuk_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","”Degisoggu, we-yargi dulemar-bukmalad-ebo melle be igar-mesdii nanamalo. Ar wemala, galagwensuli na e-bab-dummadba-nanaarmalar, eba-damalaga be imakdamaloed. Degi, e-bab-dummaganga ibmar-ogumakar-ukarmalar, ega be ukmarmoye, bega sogdamaloed. Degine, a-ibmar-e-bab-dummadga-uklesad-gunnega be imakdamaloed. ");
INSERT INTO cuk_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Degine, bemarga sogdamaloed: ‘Anmar-sisgan be-masmalaga be ukye.’ Ar we-omegan, galagwensuli e-bab-dummaganba-nanaarmalar, be-masmala galagwensuli e-bab-dummaganba-nanaega imakdamarmogoed. ");
INSERT INTO cuk_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","”Melle be, or-dualed, mani-dualed, degi, esgoromar-soogi-dualed, bab-dummadga imakdii gumalo.” ");
INSERT INTO cuk_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Madu-E-Inasuli-Gulleged-Iba be onogoed. Ibagugle (7), madu e-inasuli, an-bega-sogsadba, an-bega-ibagan-uksadba be gunnoed. We-iba be Abib-niigi onogoed, ar ade, Abib-niigi bemar Egipto-yargi noargusmalad. ");
INSERT INTO cuk_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","”Be-machi-gebesailagined, we angadga gued. Degine, moli-bebe-nikad-macheredsailagined, sibad-wawaad-macheredsailagined angadga gubalid. ");
INSERT INTO cuk_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Moli-uayasuid-macheredsailagined angadga gubalid. Degi-inigwele, a-muchubdi, sibad-wawaad-sapingwagwad be anga ukoed. A-moli-uayasuid-sailagined-muchub sibad-wawaad be uksulile, moli-uayasuid-sailagined-dukar be bisgoed. Be-masmala-gebesailaginmalad-muchub mani be ukoed. ” ‘Dule-wargwensaale arganagwabi anse dagosulid, anga ibmar-sedagergebed.’ ");
INSERT INTO cuk_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","”Ibanergwa (6) be arbaoed, ibagugledgindina (7) be obunnogoed. Amba ibmar-digedgindibe, ibmar-weedgindibe, amba be obunnogoed. ");
INSERT INTO cuk_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","”Deginbali, be Itoged-ibaganga iba-dummad onobaloed. A-sogleged, orosgi-dakleged-trigo gebe-weleged-ibaye. Degine, birga-bergunai napi-ibmar-weleged-iba be onobaloed. ");
INSERT INTO cuk_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","”Birgagi ilapaa bela-machergan, an-asabin nonimaloed. Ani an, Dummad, Bab-Jehová, Israel-e-Bab-Dummad soged. ");
INSERT INTO cuk_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","An bemar-idu dulemar-bukwadi, an bemarga onogoed, adi, bemar gatik yar-dummad nikuegar. Deyobi, birgagi ilapaa an-nug-odummogega be an-asabin-nanagwismalar, dulemar bemar-annik be-nainumar suosulid. ");
INSERT INTO cuk_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","”Melle ibmar-ogumakar-ukleged-e-abe, madu-ina-nikad-ebo-mesa be anga ukmalo. Degine, bemar Oburgwilegoenad-Iba-onogedgi mas-gwabgusad banedga be sabogosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","”Be-Bab-Dummad-Jehováʼse-goled-negse be-nainugi-gebe-ibmar-welesad be sedoed. ‘Melle sibad-e-mimmi e-nan-nunisgi be dumalo.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Bab-Jehová Moisésʼga sogded: “We an-bega-sogsad be narmake. Ar we-an-bega-sogsadba an bebogwa, degine, Israel-dulemarbogwa, an Igar mesnaid.” ");
INSERT INTO cuk_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Geb Moisés Bab-Jehováʼbogwa iba-dulabo (40) ibginedba, mutikidba gudii gusad. Moisés a-ibagangi mas-guchasulid, gobsasurbalid. Agi, Moisés akwa-matargwagwadgi Bab-Dummad-Israel-dulemarbo-Igar-Mesnaid-Ambegwadi (10) narmaksad. ");
INSERT INTO cuk_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","A-sorbali, Moisés Sinaí-yargi-gudiidgi-aideargu, akwa-matargwagwad-matabogwadgi Bab-Dummad-Israel-dulemarbo-Igar-narmakar-mesisad e-argangi sedanigusad. Ar Moisésʼdi, Bab-Dummadbo-sunmaksadbali, yar-birgi-aidedanigu, e-wagar dakar-dakar-gadanikid wissulid. ");
INSERT INTO cuk_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aarón, degi, bela Israel-dulemala, Moisés-dakdemargu, Moisés-wagar dakar-dakar-daklege, bela dobee-itonadmalad, bar ese warmakbi guarsurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Geb degine, Moisés Israel-dulemarse gochad. Aarón, degi, bela Israel-dulemar-danar-danar-bukwad-e-dummagan Moisésʼse warmaknonimalad. Geb agi, Moisés amarga sunmaksad. ");
INSERT INTO cuk_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Geb degine, bela Israel-dulemar Moisésʼse nonimarmogad. Agine, Moisés bela Bab-Jehová-Sinaí-yargi-ega-ibmar-sogsad amarga sogsamogad. ");
INSERT INTO cuk_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moisés Israel-dulemar-ebo-sunmaknaid-bergusgua, na e-wagar muswegi edusad. ");
INSERT INTO cuk_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Moisés Bab-Jehová-ebo-sunmakega ese nadele, e-wagargi muswe-naidi ungedaed. Geb noalile, gannar muswe e-wagargi nasikdaed. Geb degine, Moisés Israel-dulemarga sogdedaed, igi Bab-Dummad ega ibmar sogsad. ");
INSERT INTO cuk_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israel-dulemar Moisés-wagar-dakdele, dakdedamalad, Moisés-wagar dakar-dakar gae. Geb degine, Moisés Bab-Dummad-ebo-sunmakedse gannar muswegi na e-wagar eduddasunnad. ");
INSERT INTO cuk_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moisés bela Israel-dulemarse gochad, geb degine amarga sogded: “Weyob Bab-Jehová igar uksad, weyob be imakmaloye: ");
INSERT INTO cuk_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Ibanergwa (6) arbalegoed, ibagugledgindi (7), iba-islidikidid. A-ibagi, Bab-Jehováʼga obunnolegoed. Ar doa-dule a-ibagi arbaele, we-dule oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Bemar-neg-yagine, bipisaale obunnoged-ibagi soo be ogaosurmalad.” ");
INSERT INTO cuk_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moisés, bela Israel-dulemar-danar-ambikunonikidga weyob sunmaksad: “Bab-Jehová sogsad: ‘Weyob be imakmaloye: ");
INSERT INTO cuk_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Bemar ibmar-nikadi Bab-Jehováʼga be sedamaloed. Dulemar na e-gwagegi ibmar Bab-Jehováʼga ukbi-itomaladba ibmar sedagoed. We-ibmarmar sedagoed: Olo, mani, esgoro-gordikid. ");
INSERT INTO cuk_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued, sibad-e-absarmar, ");
INSERT INTO cuk_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled, ibdurgan-uka-nuegan, urgomar-acaciaʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Olivo-gwallu gwallu-ogaegar. Gwallu-wawad ibmar-magega guegar, degi, olivo-gwallu ina-wawadikmaladgi ebulegegar. ");
INSERT INTO cuk_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Akwa-nuegan-óniceʼye-nugmalad, akwa-nuegan mor-efodʼye-nugad-birgi nasikegar, degi, mor-binasgargi-nasiklegedgi nasikegarbar.’ ” ");
INSERT INTO cuk_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Moisés Israel-dulemarga sogdebalid: “Bela Bab-Jehová-ibmar-sogsad-sobmalaga, bela dulemar bemar-abargi nue-ibmar-wisi-sobemalad nonimalo. ");
INSERT INTO cuk_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Amar we-ibmarmar sobmaloed: Bab-Dummadse-goled-neg-sunna-seleged, e-neg-sunnad, e-uas-mormar, e-mor-gamalad, e-urgomar, e-suarmar, e-buarmar, e-sigmalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","”Deginbali, sobmarbaloed: Bab-Dummad-Israel-Dulemarbo-Igar-Mesisad-Ulu, e-suarmar, e-eduged, mor-dummad-Ulu-walik-naguoed. ");
INSERT INTO cuk_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","”Deginbali, sobmarbaloed: Mese, mese-suarmar, bela mesegi-ibmar-ebulemalad, degi, madu-Bab-Dummadga-ukleged. ");
INSERT INTO cuk_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","”Sobmarbaloed: Gwallu-sied, degi, bela eba ibmarmar-ebulegoed. E-gwallumar, degi, olivo-gwallu gwallu-ogaegar. ");
INSERT INTO cuk_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","”Sobmarbaloed: Ina-wawadikid-inciensoʼye-nugad-ogumakleged-aila, degi, e-suarmar. Gwallu-wawa ibmar-magega ebuleged, ina-wawadikmalad. Mormar-dummagan Neg-Sunna-Seleged-e-yawagak-dogedgi-naguoed. ");
INSERT INTO cuk_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","”Sobmarbaloed: Bab-Dummadga-ibmar-ogumakar-ukleged-aila, e-esgoro-gordikmalad-biir-biir-megoed, degi, e-suarmar, bela eba-ibmarmar-ebulegoed. Dii-sied-esgoro-gordikidbiid, degi, a-e-malimar. ");
INSERT INTO cuk_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","”Sobmarbaloed: Bab-Dummadse-goled-neg-sunna-seleged-e-galugi mormar-dummagan-ebirmaloed, e-buarmar, e-sigmalad. We-neg-sunna-seleged-e-neg-e-galu-dogedgi mor-dummad-naguoed. ");
INSERT INTO cuk_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","We-neg-e-bargamalad, e-galu-bargamalad, e-dubmar sobmaloed. ");
INSERT INTO cuk_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Aarónʼga, degi, Aarón-masmalaga, Bab-Dummadse-goled-neggi-mormar-ebulemaloed sobmarbaloed. Bela we-ibmarmar sobmaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Degidgine, bela Israel-dulemar Moisés-asabin-bukmaladi ainiarmalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Bela dulemala, bela na e-gwagegi-ibmar-ukbi-itosmaladi, Bab-Dummad-dulemarbo-ambikued-neg-sobmalaga, agi-bela-ibmarmar-ebulemalad-sobmalaga, degine, dule-irwa-Bab-Dummadse-goledgi mor-islidikid-yomalad-sobmalaga, Bab-Jehováʼga ibmar searmalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bela ibmar-ukbi-itosmaladi, machergan, degi, omegan-ugakse, we-ibmarmar senonimalad: Ordub, oluamar, sakwagi-ormar-nagumalad, argangi-or-yolemalad, degi, bela ormar-galagwensuli senonimalad. Belagwable Israel-dulemala Bab-Jehováʼga or senonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bela dulemar nirbadub-arad-nikamalad, nirbadub-suir-akwagiid, nirbadub-ginnid, linoʼdub-nued, sibad-e-absarmar, sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled, ibdurgan-uka-nuegan, senonimalad. Bela-dulemar we-ibmar-nikamaladi, Bab-Dummadga-ukega senonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bab-Dummadse-goled-neg-sunna-selegedgi ebulegega, dulemar mani-nikamaladi, esgoro-gordikid-nikamaladi, Bab-Jehováʼga ukdemalad. Degine, urgomar-acaciaʼye-nugad-nikamaladi, ukdemarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Deginbali, omegan-ibmar-nue-wisimalad, e-argangi-dub-sobsamaladi, Bab-Dummadga senonimalad: Nirba-dub-aradgi-sobsamalad, nirbadub-suir-akwagiidgi-sobsamalad, nirbadub-ginnidgi-sobsamalad, degi, linoʼdub-nuedgi-sobsamalad, senonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Bela omegan ibmar-nue-imakmaladi, e-gwagegi nue-imakbi-itosmaladi, sibad-e-absarmar sobsamarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Israel-dulemar-dummaganga-gudidimaladi, akwa-nuegan-óniceʼye-nugad, degi, akwamar-nuegan, mor-efodʼye-nugadgi-nasikmalaga, degi, mor-binasgargi-nasikleged-birgi-nasikmalaga, senonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Deginbali, we-ibmarmar senonimarbalid: Ina-nuegan, olivo-gwallu gwallu-ogaegar, gwallu-wawad ibmar-magegar, degi, ina-wawadikmalad obupurmakegar. ");
INSERT INTO cuk_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Bela Israel-dulemar, machergan, degi, omeganse-bakale, na gwagegi-ibmar-ukbi-itosmaladi, Bab-Jehováʼga na e-itogedba-ibmar-ukega senonimalad, adi, Bab-Jehováʼga ibmarmar sobegar. Ar igi Bab-Jehová-Moisésʼga-sogsagusa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Geb degine, Moisés Israel-dulemarga sogded: “Nue be an-itomalo. Bab-Jehová, Uri-machi-Bezaleel onugsasad. Bezaleelʼde, Hur-e-wagwad. E-dad-dummad-Judáʼgi danikidid. ");
INSERT INTO cuk_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Bab-Dummad Bezaleelʼga E-Burba uksad, nue-binsaed-nikaa guegar, nue-ibmar-mag-ito guegar, nue-ibmar-wisi guegar, degi, ibmar-akar-akar-obinyegar. ");
INSERT INTO cuk_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Adi, ibmar-yeerdakle orgi-sobegar, manigi-sobegar, esgoro-gordikidgi-sobegar. ");
INSERT INTO cuk_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Deginbali, nabir akwa-nuegangi-arbaegar, akwa-nuegan ibmar-birgi siegar, nabir urgomargi-arbaegar, degi, galagwensuli ibmar-yeerdakle imakegar. ");
INSERT INTO cuk_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","”Bab-Dummad Bezaleelʼga, degi, Aholiabʼga nabir-dulemar-odurdaked-gurgin uksad. Aholiab Ahisamac-e-machid, e-dad-dummad-Danʼgi danikidid. ");
INSERT INTO cuk_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Bab-Dummad Bezaleelʼga, degi, Aholiabʼga, we-gurginmar uksad: Nabir baisursunna-ibmar-imaked, nabir-ibmar-onoged, nabir nirbadub-aradgi-ibmar-sobed, nabir-nirbadub-suir-akwagiidgi-ibmar-sobed, nabir-nirbadub-ginnidgi-ibmar-sobed, nabir-linoʼdub-nuedgi-ibmar-sobed-gurgin, uksabalid. We-dulemala, ibmar-yeerdakle sobmaladid, mormargi arbamaladid, degi, nabir na-e-itolegedba sunna ibmar-akar-akar onomaladid.” ");
INSERT INTO cuk_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Moisés sogdebalid: “Degisoggu, Bezaleel, Aholiabʼbogwa, Bab-Jehová-sogsagusadba Bab-Dummadse-goled-neg-sunna-selegedgi ibmar-ebulemalad bela imakmaloed. Deginbali, bela dulemar, Bab-Jehová nue-wisi-ibmar-sobega-imaksamarmogadi, degi, ega baisursunna-ibmar-imakega-imaklesbalidi, Bab-Dummadse-goled-neg-sunna-seleged-sobega, wemar-ebogwadba arbamarmogoed.” ");
INSERT INTO cuk_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moisés, we-dulemarse gochad: Bezaleelʼse, Aholiabʼse, degi, bela dule-ibmar-nue-wisi baisursunna-ibmar-imakmaladse gochad. We-dulemar na e-itolegedba arbaega nonimalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Moisés we-dulemarga Israel-dulemar-ibmarmar-senonikid uksad. Adi, agi we-dulemar Bab-Dummadse-goled-neg-sunna-selegedgi ibmar-ebulemaloed sobegar. Israel-dulemala na e-itolegedba bane-bane wakudaryalaba Bab-Dummadga-ibmar-ukega ibmarmar senonidamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Bela-dulemar-ibmar-sobnanaid deyob dakdegua, e-arbaed indaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Geb Moisésʼga sognadmalad: “Dulemar Bab-Jehová-sogsadba-ibmar-sobega ibmar-berbelemaid doggus wilub-obichagusad. Emide, ibmar ise-obinagwaled.” ");
INSERT INTO cuk_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Degisoggu, Moisés dulemar-bukwadse gaya-barmisad: “Machergan, degi, omegan, Bab-Dummad-neg-sobega melle bar ibmar amimalo, melle bar Bab-Jehováʼga ibmar sedamalo.” ");
INSERT INTO cuk_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Ar ibmar-sobmalaga, bato ibmarmar unnigualed. Ar ise-obinagwarsoggu, dulemar ibmar-baid bar senonisurmalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Bela dulemar-arbananaid, napiragwad-bur-ibmar-sobmalad, Bab-Dummadse-goled-neg-sunna-seleged sobsamalad. We-dulemar, linoʼdub-nuedgi, nirbadub-aradgi, nirbadub-suir-akwagiidgi, degi, nirbadub-ginnidgi mor-dummagan-goambe (10) sobsamalad. Agi baliwitur-dummagan-querubinʼye-nugad bela nue-yeerdakle-imakar mor-dummagangi-nai sobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Mormar-e-sugued, daligugledbi (7) imaksamalad, e-matardungueddi, daligwenadbi imaksamalad. Mormala bela emarbi-dungu imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Mormar-dummagan goatale gwadismalad, amba deyob baid goatale gwadismarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Degine, mor-goataled-gwadialed-e-dikargi e-uayamar dub-aradgi ega nasiklesad. Amba deyob mormar-baigan goatarmalad-gwadiarmalad-e-dikargi nasiklesbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Mormar-gebedgi gwadulabo-gakambe (50) e-uayamar nasiksamalad. Degine, baigan-goatar-gwadiarmaladgi gwadulabo-gakambe (50) e-uayamar nasiksamarbalid. Degisoggu, e-uayamar na abin-abin nasiklesad. ");
INSERT INTO cuk_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Deginbali, mor-gaed-orbiid dulabo-gakambe (50) sobsamarbalid. Agi mormar oatosmalad. Degisoggu, Bab-Dummadse-goled-neg-sunna-seleged-e-mor-dummagan unnila gogwenayob gunonisunnad. ");
INSERT INTO cuk_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","We-dulemar, Bab-Dummadse-goled-neg-sunna-seleged-edugega, sibad-absarmargi mor-dummagan sobsamalad. Sibad-absarmar mor-dummaganga goambe-gakagwensak (11) imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Mormar-dummagan-goambe-gakagwensakad (11) bela na-emarbi-dungu imaksamalad. Mormar-e-sugued, daligugle-gaka-abala (7½) sugued. E-matardungueddi, daligwenad. ");
INSERT INTO cuk_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","We-mormar-dummagan, goatar gwadismalad. Degine, baiddi, goanergwa (6) gwadismalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Geb a-sorba, mor-dummagan-goatar-gwadilealed-dikarba, gwadulabo-gakambe (50) e-uayamar nasiksamalad. Amba deyob baigan-gwadilesmalad-dikarba, gwadulabo-gakambe (50) e-uayamar nasiksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Deginbali, esgoro-gordikidgi mor-gaed dulabo-gakambe (50) soblesbalid, adi, agi bela neg-edugegar, unnila gogwennayob gunonisunnad. ");
INSERT INTO cuk_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Geb degine, Bab-Dummadse-goled-neg-sunna-seleged-edugega, sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled, gwadi-gwadi imaksamarbalid. Adi, sibad-absarmor-dummagan-birgi ogillegegar. Geb sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled-birgi ogillegega, ibdurgan-uka-nuegan gwadi-gwadi imaksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Deginbali, Bab-Dummadse-goled-neg-sunna-selegedga urgomar-acaciaʼye-nugad sobsamalad. We-urgomala, bela nue-innikii ogwichismalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","We-urgomar, dalibo-abala-sugu imaksamalad. E-matardungueddi, achapaa-nika imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","We-urgomargi, e-nagmar war-warbo-nika imaksamalad, adi, nabir urgomar naga-nagaba matak-matak gwisguegar. Bab-Dummadse-goled-neg-sunna-selegedga bela degibi urgomar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Weyob Bab-Dummadse-goled-neg-sunna-selegedga urgomar-mergu imaksamalad: Mata-dulagwen (20) dad-nakwed-argan-nuedsik-ebugegar. ");
INSERT INTO cuk_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","We-urgomar-dulagwenad-urba (20), dulabo (40) e-sigmalad manibi sobsad. Urgomar-irbali gwa-gwabo e-sigmalad imaksamalad, adi, urgomar-e-nagmar agi odogegar. ");
INSERT INTO cuk_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Bab-Dummadse-goled-neg-sunna-seleged dad-nakwed-argan-sapiledsik-ebugegala, urgomar-dulagwen (20) sobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","E-sigmalad, manibii gwadulabo (40) sobsamarbalid. Urgomar-iliba, gwa-gwabo e-sigmalad sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Bab-Dummadse-goled-neg-sunna-seleged dad-argwanedsikidga urgomar-matanergwa (6) sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Bab-Dummadse-goled-neg-sunna-seleged na abingunanaidga urgomar-matabo sobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","We-urgomar darbo oatosmalad. Geb birgi e-nonogi or-dummad-naid yosmalad, adi, melle bar urgo-matabogwad-ungega, weyobi imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Degisoggu, urgomar bela matabaabak (8) sobsamalad, e-siged-mani-biid gwaambe-gakanergwa (16) sobsamalad. Bela urgomar-iliba, e-sigmalad gwa-gwabo sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Deginbali, urgo-warakwagana-acaciaʼye-nugad sobsamarbalid: Urgo-warakwagana-walatar Bab-Dummadse-goled-neg-sunna-seleged-e-dikar-soggwensikidga sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","33","Degine, baid-dikarsikidga, walatar sobsamarbalid, degine, e-dikar-yargansikid-dad-argwanedsikidga urgo-warakwagana walatar sobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Urgomar-ebilis egi ormar matak-matak nasiksamalad, degine, e-olua-dummagandi orbi sobsamalad. Degine, Urgo-warakwagana-ebilis egi ormar matak-matak nasiksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Deginbali, mor-dummad nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, degi, linoʼdub-nuedgi sobsamalad. We-mor-dummadde nue-yeerdakle-imakar, baliwiturmar-querubinʼye-nugad egi-sobar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","We-mor-dummad-nasikegala, acacia-buarmar-walabake ogwichismalad. A-buarmar-ebilis, egi ormar matak-matak nasiksamalad. Degine, mor-gamalad bela orbi sobsabalid. Deginbali, buarmar-e-gaed, adi, gwabake manibi sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Deginbali, Bab-Dummadse-goled-neg-sunna-seleged-yawagakga mor-dummad imaksamarbalid, nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, degi, linoʼdub-nuedgi imaksamalad. We-mor-dummadde, nue-yeerdakle imakaled. ");
INSERT INTO cuk_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A-yawagakgindi, buarmar-walatar ogwichismalad, degine, mor-gamalad sobsabalid. A-buarmar-ebilis egi ormar matak-matak nasiksad, degine, e-siged-gwaataledi, esgoro-gordikidgi sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleel, Bab-Dummad-Dulemarbo-Igar-Mesisad-Ulu urgomar-acaciaʼye-nugadgi sobsad. E-suguedi, achaatar, e-matardungued, achapaa, degine, e-nibgued, achapaa-nibgu sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Yaba, olo-nued-sunnabi nasiksad. Birgi, deyob olo-sunnabi egi nasiksabalid. Birgi, bela-ebiris e-mullugwad olobi nasiksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Deginbali, olua-dummagan-gwabake-sobega or dusbalid. Adi, ulu-e-dikar-bergunaid-sogbakegwadgi gwa-gwagwen nasikegar. Olasu-gwabo dikar-gwensaksik-nasikega sobsad. Baid-dikarba, gwabo-nasikega sobsabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Deginbali, urgo-acaciaʼye-nugad suitii warbo imaksabalid. We-suarmar-walaganagi or ebiris nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Degine suarmar-walagana-suid ulugi olasu-dummagan-nanaid-yaba odosmalad, adi, nabir ulu selegegar. ");
INSERT INTO cuk_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Deginbali, ulu-edugedga or-nued imaksabalid. E-sugued, achaatar-nika imaksad, e-matardungueddi, achapaa-nika imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Degine, ulu-eduged-birgi, e-dukusik-e-dukusik-ogwisguega, baliwitur-dummagan-querubinʼye-nugad walabo orbi mardogi binna-binna sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Baliwitur-dummagan-querubin ulu-eduged-birgi gwensak e-dukusik sobsad. Baid e-dukusik, deyob sobsabalid. Ulu-edugedba-mesa querubin-warbogwad, ulu-eduged-e-duku-dukusik gwigwichi sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Querubinʼmala ulu-eduged-birgi asabin-asabin sakan-nallaa gwismalad. E-sakangine, ulu-eduged odukunanaid. E-wagardi, ulu-edugedgi ataknanaid. ");
INSERT INTO cuk_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Deginbali, Bezaleel, urgo-acaciaʼye-nugadgi mese-sobsabalid. E-sugued, achabake-nika imaksad, e-matardungued, achabo, e-nibgueddi, achapaa-nika imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Bela we-mesegi or-nued nasiksad, degine, bela e-dikarba ebilis or mulluu mesisbalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Deginbali, mese-e-dikar-bela-ebilis wis-nibakwasaar e-matardungued argan-matagwen imaksad. Nibakwaa-imaksad-birgi, or mulluu mesisad. ");
INSERT INTO cuk_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Deginbali, oluaduk-dummagan-gwabake-sobega, ormar dusbalid. We-oluaduk-dummagan-gwabakegwadi, mese-dikar-sogabake-abingunanaidgi nasiksad. E-malimar-walabakegwad-iliba nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Mese-gakuli-mulluu-mesilesad-urba, oluaduk-dummagan-gwabake-nasiksadgi suarmar-suid ododamalad, adi, nabir mese selegegar. ");
INSERT INTO cuk_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mese-selegega, suar-acaciaʼye-nugad-walagana suitii imaksamalad. A-birgi, bela ebiris or nasiksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Deginbali, Bezaleel, mese-birgi ibmarmar-sigoedi, or-sunnabi sobsabalid: Batemar, bate-dummagan, bormomar. Degine, nog-dummagan Bab-Dummadga-ibmar-diregwad-uklegega sobsabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Deginbali, gwallu-sied orbi sobsabalid, mardogi binna-sarsoar sobsad. E-mali, e-sakwamar, e-nogmar, e-abingamalad, e-dutumar, bela-wemar unnila soggwenna gued. ");
INSERT INTO cuk_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Gwallu-siedgi e-dikarba walanergwa (6) e-sakwamar nonanaid. Gwensaksik, e-sakwa-warbaa nonaid. Baidsik, e-sakwa warbaa nonaibalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","E-sakwa-wargwengi e-nogmar-gwapaa nur-matargana-e-dutuyob-dakle imaksad. Degine, dutu-abingaed-nika, geb, e-dutu-nika imaksad. Deyob, e-sakwamar-bamaladgine imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Gwallu-sied-e-wargi, nogmar gwabake nur-matargana-e-dutudaklegeyob sobsad. Degi, e-noggi e-dutu-abingamalad, degi, e-dutumar sobsabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Gwallu-sied-e-sakwa-warbogwad e-wargi-yolenaidgi e-abingaed-gwagwen, sobsad, deginbali, e-abingaed-baid-gwagwen, e-sakwa-warbogwad-baid-urba sobsabalid, deginbali, amba abingaed-baid-gwagwen e-sakwa-warbogwad-baid-urba sobsabalid. Degibi gwallu-sied e-sakwa-walanergwad-urba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","E-dutu-abingamalad, degi, e-sakwamala, unnila bela gwennaa or-nuedbi-imakaled. Soblesadi, mardogi binnaa-sarsogar soblesad. ");
INSERT INTO cuk_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Deginbali, e-gwallu-gwagugled (7) bela or-nuedbi imaksabalid. E-gwillodub-sikmalad, degi, e-bate-burwigana bela or-nuedbi imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Or-nued-aidikued nibir-dulapaa-gakambe-gakabake (74) ebusad, bela e-ibmar-burwiganase-bakar deyob aidiku imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Deginbali, Bezaleel ina-wawadikid-ogumaked-aila sobsabalid. A-aila-sobegala, urgomar-acaciaʼye-nugad ebusad. E-sugued achabo, e-matardungued achabo-nika sobsad. E-suguedi, e-matardunguedbo, emar dungued. E-nibgueddi, dali-abala nibgued. E-moli-bebegiid-gwichid ailaba-mesa imakaled. ");
INSERT INTO cuk_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Or-nued aila-birgi, aila-dikarba, degi, e-moli-bebegiidgi nasiksad, degine, e-dikar-ebilis or mulluu mesisad. ");
INSERT INTO cuk_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Deginbali, or-mullugalad-urba, olua-dummagan gwabo e-dikarmargi nasiksad. Deyob abinbela nasiksad, adi, agi nabir suarmar-suitigwad odogegar, nabir selegegar. ");
INSERT INTO cuk_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","We-urgomar-suitigwad urgo-acaciaʼye-nugadgi sobsamalad. Geb a-birgine, or nasiksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Deginbali, gwallu-wawa-islidikid ibmar-magega-ebuleged imaksabalid. Degine, ina-wawadikmalad-ibmarba-oburarsulid, yeer-yapanmalad, dule-ina-wawad-sobmaladyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Deginbali, Bezaleel urgo-acaciaʼye-nugadgi Bab-Dummadga-ibmar-ogumakar-ukleged-aila sobsabalid. E-sugued, daligwen-gaka-achabo, e-matardungued, daligwen-gaka-achabo-nika sobsad. E-sugued, degi, e-matardungued, emarbi imaksad. E-nibgueddi, bisgipaa-nika imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","We-aila mullugwad-sogabake-abingunaidgi moli-bebegiid ogwichisad. We-moli-bebegiid ailaba-mesa sobsad. Bab-Dummadga-ibmar-ogumakar-ukleged-aila-birgi esgoro-gordikid egi nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Deginbali, bela Bab-Dummadga-ibmar-ogumakar-ukleged-ailagi we-ibmar-ebulemaloed sobsabalid: Buru-simalad-bormomar. Buru-weemalad-wesar-dummagan, Abe-bomied-nog-dummagan. San-obin-obin-saed-iko-dummagan. Soo-seed-bormomar. Bela-wemala esgoro-gordikidgi sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Bab-Dummadga-ibmar-ogumakar-ukleged-ailaga, san-nared-saki-sakid esgoro-gordikidgi sobsad. We-san-nared-saki-sakid Bab-Dummadga-ibmar-ogumakar-ukleged-aila-yagi, negabaladgi nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Deginbali, olua-dummagan-sobega esgoro-gordikid dusbalid. Deyob imaksad, adi, san-nared-saki-sakidgi we-olua-dummagan-gwabake nasikega, adi, agi suarmar-suigan odogegar. ");
INSERT INTO cuk_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Urgo-acaciaʼye-nugad-walagana suitii sobsad. Geb a-suarmar-birgi, esgoro-gordikid nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Geb degine, Bab-Dummadga-ibmar-ogumakar-ukleged-aila-dikarba oluaduk-dummagan-nanaid-yaba suarmar-walagana odosad, adi, nabir aila selegegar. Bab-Dummadga-ibmar-ogumakar-ukleged-aila ollor sobaled. We-aila urgomargi sobaled. ");
INSERT INTO cuk_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezaleel, dii-sied, degi, e-sigedga-gued, esgoro-gordikidgi sobsabalid. We-sobegala, omegan-Bab-Dummadse-goled-neggi-arbamalad e-isbemar-esgoro-gordikidgi-sobaled ebusad. ");
INSERT INTO cuk_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Bezaleel, Bab-Dummadse-goled-neg-sunna-seleged-e-neg-imba, degi, e-galu sobsabalid. Dad-nakwed-argan-nuedsik, a-neg-imba-e-galuga, mor-dummagan imaksad: Lino-mor-nued dali-dulagwen-gakatar-sugu (25), sobsad. ");
INSERT INTO cuk_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","E-buarmar, dulagwen (20) mergued. Egi-sigmalad, dulagwen (20) mergubalid, bela esgoro-gordikidgi sobaled. Buarmar-e-nonomar, e-gamalad, bela manibi sobaled. ");
INSERT INTO cuk_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Bab-Dummadse-goled-neg-sunna-selegedgi dad-nakwed-argan-sapiledsik, mor-dummad dali-dulagwen-gakatar-sugu (25) naibalid. E-buarmar, dulagwen (20) gwigwisbalid. Degi, e-sigmalad esgoro-gordikidgi dulagwen (20) imakarbalid. E-gamalad, degine, e-buar-nonomar, manigi sobarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Dad-argwanedsik mor-dummad-naidi, daliambe-gakabo-abala (12½) sugued. E-buarmar, warambe (10) gwigwichid, degi, e-siged, gwaambebalid (10). E-gamalad, degi, e-buar-nonomar, manigi sobarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dad-nakwedsik mor-dummad-naidi, daliambe-gakabo-abala (12½) sugued. ");
INSERT INTO cuk_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","E-yawagak-dikarsiki, mor-dummad-naidi, dalipaa-gaka-bisgipaa sugued. E-buarmar walapaa, degine, e-sigmalad, gwapaa sobarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Degine, yawagak-baid-dikarbali, mor-dummad dalipaa-gaka-bisgipaa-sugu naid. Degi, buarmar, walapaa, degi, e-sigmarmogad, gwapaa sobarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Mor-dummagan neg-galugi-nanaidi, bela lino-mor-nuegan naed. ");
INSERT INTO cuk_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","E-buarmar-sigmalad bela esgoro-gordikidgi sobaledbiid. E-gamaladi, degi, e-olua-dummagandi, manibi sobaled. Deginbali, e-buar-nonomargi, bela manibi matak-matak ebiris naid. Bela Babse-goled-neg-e-buarmar-bukwad-e-olua-dummagan bela manibiid. ");
INSERT INTO cuk_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Yawagakga neg-imba-dogedgi mor-dummad-naidi, mor ise-nue-sobar, bela-bela nue-yeerdakle-imakar naid. We-mor-dummad-sobaledi, we-dubmargi sobaled: Nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, degi, linoʼdub-nuedgi sobaled. E-suguedi, daliataled. E-nibgueddi, daligwen-gaka-bisgise nibgued. We-mor-dummagan mor-dummagan-neg-imbagi-nanaidyob-dungu imaklesad. ");
INSERT INTO cuk_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","E-buarmar, walabake gued, e-sigmalad, gwabakebalid. Wemar, esgoro-gordikidgi sobaled. E-gamalad, e-olua-dummagan manigi sobaled, degi, e-buar-nonomargi, bela manibi matak-matak ebiris naid. ");
INSERT INTO cuk_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Bab-Dummadse-goled-neg-sunna-seleged-e-bargamalad, degi, neg-imba-e-galu-ebirnaid-e-bargamalad, bela esgoro-gordikidgi sobaled. ");
INSERT INTO cuk_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Bab-Dummad-dulemarbo-Igar-Mesisad-neg-sunna-selegedgi ibmarmar-ebulesad ebislesgusad. Leví-e-wagan, Moisés-sogedba ibmar-ebismalaga arbasmalad. Geb Aarón-dule-irwa-Bab-Dummadse-goled-machi-Itamar, ibmarmar-ebislesad narmaksad. ");
INSERT INTO cuk_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Uri-machi-Bezaleel, bela Bab-Jehová igi Moisésʼga sogsagusa, deyob ibmar imaksad. Bezaleel Hur-e-wagwad, dad-dummad-Judáʼgi danikidid. ");
INSERT INTO cuk_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ahisamac-machi-Aholiab, Bezaleel-bendakega gusad. Aholiab, dad-dummad-Danʼgi danikidid. Aholiabʼde, esgorogi-ibmar-sobed-duled, nabir-ibmar-akar-akar-onogedbalid. Deginbali, nabir we-dubmargi ibmar-sobedbalid: Nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, degi, linoʼdub-nuedgi mor-yeerdakle sobedid. ");
INSERT INTO cuk_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Israel-dulemar Bab-Dummad-neg-sunna-selegedgi-ebulegega, Bab-Dummadga-or-uksamalad, bela ebusmalad. Nibir-milibo gaka dulabakebak-gakambe-gakatar (2,195), ebusmalad. Bab-Dummad-neggi nibirgi-ibmar-wilubsalegedba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Dulemar-bukwad-ebislesadba, e-mani, nibir-miligugle gaka dulataled-ilatar gaka dulabo-gakambe (7,550) gusad. Bab-Dummad-neggi nibirgi-ibmar-wilubsalegedba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Bela-dulemar-birga-dulagwen-gaka-nikmaladi (20+), mili-dulataled-ilanergwa-gakapaa gaka dulataled-ilatar gaka dulabo-gakambe-mergu (603,550) daklealid. Wemala, e-dule-irba mani-gramo-nergwa uksamalad. Bab-Dummad-neggi nibirgi-ibmar-wilubsalegedba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Deginbali, Bab-Dummadse-goled-negga e-sigmalad-sobega, degi, mor-dummad-naidga e-sigmalad-sobega, mani, nibir-miligugle gaka dulataled-ilatar (7,500) ebulesbalid. E-siged-dulatargi (100), mani, nibir-miligugle gaka dulataled-ilatar (7,500) ebulesad. Degisoggu, e-siged-iliba nibir-dulapaa-gakambe-gakatar (75) ebulesad. ");
INSERT INTO cuk_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Mani-gwabgusadgindi buarmar-gamalad sobsad, Degine, buar-e-nonomar, degi, e-olua-dummagan sobsabalid. ");
INSERT INTO cuk_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Dulemar esgoro-gordikid nibir-miliatar gaka dulataled-ilapaa gakambe (5,310) uksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","We-esgoro-gordikidgi Bab-Dummadse-goled-neg-sunna-seleged-e-yawagak-siged, degine, Bab-Dummadga-ibmar-ogumaker-ukleged-aila, sobsamarbalid. Agine, san-nared-saki-sakid sobsamarbalid, degine, a-ailagi-ibmar-ebulemalad bela sobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Amba Bab-Dummadse-goled-neg-sunna-seleged-e-sigmalad, e-yawagak-e-sigmalad esgoro-gordikidgi sobsamalad. Degine, bela a-neg-bargamalad, degi, bela e-galu-bargamalad-dikarba-gwigwismalad, esgoro-gordikidgi sobsamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Dule-irwa-Bab-Dummadse-gormalad-mormar nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, mor sobsamalad. We-mor-yoi, Bab-Dummadse-goled-negse dogdedamalad. Amba deyobi, Aarónʼga mor-islidikid imaksamarbalid. Igi Bab-Jehová, Moisésʼga sogsagusa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezaleel mor-efodʼye-nugad amba deyob imaksabalid. A-imakega, we-dubmar ebusad: Ordub, nirbadub-arad, nirbadub-suir-akwagiid, nirbadub-ginnid, degi, linoʼdub-nued. ");
INSERT INTO cuk_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Or-matargwa-matargwa imaksamalad, degine, gara-gara dubga siksamalad, adi, nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, degi, linoʼdub-nuedgi, ise-nue-yeerdakle imakegar. ");
INSERT INTO cuk_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Degine, mor-efodʼye-nugad-e-gukingi nabir-atinned imaksamarbalid, adi, agi e-dukugi abin atogegar. ");
INSERT INTO cuk_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Mor-molidubga-gunaidi, mor-efodʼba-baka-mesa naid. We-mor-molidub amba deyob we-dubmargi imakarmogad: Ordubgi, nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, degine, linoʼdub-nuedgi imakaled. Igi Bab-Jehová Moisésʼga sogsagusa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Akwamar-óniceʼye-nugad-nue-sobsamaladi, or-birgi sismalad. Agine, wilub-nasikega-imakdamaladyob imaksamalad. Agi Israel-masmala-e-nug nasiksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mor-efodʼye-nugad-e-gukingi nasiksad, adi, a-akwamargi Israel-dulemar-sogambe-gakabogwad (12) insaledii guegar. Igi Bab-Jehová Moisésʼga sogsagusa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bezaleel, mor-binasgargi-nagued, nue-yeerdakle, mor-efodʼye-nugad-imakaledyob imaksabalid. We-dubmargi imakaled: Ordubgi, nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, linoʼdub-nuedgi, imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Deginbali, mor-binasgargi-nagued-e-sugued, degi, e-matardungued, bela emarbiid, degi, darbobalid. We-mor nubyaa-imaksale, e-sugued, degi, e-matardungued, achagwenad. ");
INSERT INTO cuk_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","We-mor-birgine, akwamar-nuegan-ilemakar-sogabake osismalad: Ile-soggwengine, we-akwamar osismalad: Akwa-sardioʼye-nugad, akwa-topacioʼye-nugad, akwa-carbuncloʼye-nugad. Weyob ile-soggwengi bukwad. ");
INSERT INTO cuk_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ile-sogbogine, we-akwamar osismarbalid: Akwa-esmeraldaʼye-nugad, akwa-zafiroʼye-nugad, akwa-diamanteʼye-nugad. Weyob ile-sogbogi bukwad. ");
INSERT INTO cuk_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ile-sogbaagi, we-akwamar osismarbalid: Akwa-jacintoʼye-nugad, akwa-ágataʼye-nugad, akwa-amatistaʼye-nugad. Weyob ile-sogbaagi bukwad. ");
INSERT INTO cuk_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Ile-sogbakegi, we-akwamar osismarbalid: Akwa-beriloʼye-nugad, akwa-óniceʼye-nugad, akwa-jaspeʼye-nugad. Weyob ile-sogbakegi bukwad. Bela we-akwamar-mor-birgi-bukwadi, or-ega-imaklesad-imbaba osismalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Akwa-nuegana gwaambe-gakabo (12) gued, Israel-masmala-merguedba, degi, akwa-gwa-gwagwengi e-nugmar ilibali narmakar nanaid. Igi wilub-nasikega imakdamala, deyob Israel-dulemar-sogambe-gakabogwad-e-nugmar (12) egi narmakar nanaid. ");
INSERT INTO cuk_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Mor-binasgargi-naguedga ordub-nued sinni-sinni imaksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Deginbali, akwamar-e-sigoed gwabo orbi imaksamalad, degine, olua-gwabo orbi imaksamarbalid. Oluamar-gwabogwad mor-binasgargi-nagued-e-dukumar-sogbogwadgi nasiksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Geb degine, ordubmar-sinni-sinnid-giabogwad mor-binasgargi-nagued-e-dukugi-olua-gwabogwad-naidgi odosad. ");
INSERT INTO cuk_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Geb deginbali, amba ordubmar-sinni-sinnid-e-duku-sogbogwad ormar-sigedgi, mor-efodʼye-nugad-e-gukingi asabin nasiksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Deginbali, orbi olua-gwabo imaksamarbalid. Mor-binasgargi-nagued e-dukumar-bergunaidgi, asabin-urbalidgi nasiksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Deginbali, olua-gwabo orbi imaksamarbalid, mor-efodʼye-nugad-gukingi asabin urbali makaled-waliksaar, mor-sadergi-nagued-birgi-nasikega imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Deyobi, mor-binasgargi-nagued-e-oluamargi mor-efodʼye-nugad-e-oluamar-ebo dub-aradgi edichamalad, adi, mor-efodʼye-nugad-e-mor-sadergi-nagued-birgi, mor-binasgargi-naguedgi, mer bachikii guegar. Igi Bab-Jehová-Moisésʼga-sogsa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Deginbali, mor-dummad-efodʼye-nugad bela mor-aradgi nue-sobar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","E-negabargi, yaa-olloo nono-odogega mor-gammuga imaksamalad. Mor-gammu-e-dikarba, melle achirmakega, bela-ebilis dubgi sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mor-dummad-e-nag-dukugi sapi-granada-e-sanyob-dakleged nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, linoʼdub-nuedgi-sobar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Deginbali, gapan-burwigana olobiid imaksamarbalid. We-gapan-burwigana, bela mor-e-nag-duku-ebilis sapi-granada-e-sanyob-dakleged imba-imbagi nasiksad. ");
INSERT INTO cuk_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Gapan-bipigwad-gwensak, a-dikarba sapi-granada-e-sanyob-dakleged nasiksad. Deyob bela muchub-muchub mor-dummad-suitigwad e-nag-ebilis nasiksamalad. We-mor, dule-irwa-Bab-Dummadse-goled, Bab-Dummadse-gornadele, ebuged. Igi Bab-Jehová Moisésʼga sogsa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Deginbali, Aarónʼga, degi, e-masmalaga mor-dummad-suitigwad lino-mor-nuedgi-sobar imaksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Deginbali, mor-gurgin-ebirmakaled lino-mor-nuedgi, e-yeerdaklemalad imaksamarbalid. Amba linoʼdub-nuedgi garson-bipi-urba-yoleged imaksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Deginbali, morgo-dub-sadergi-nagued we-dubmargi sobsamarbalid: Linoʼdub-nuedgi, nirbadub-aradgi, nirbadub-suir-akwagiidgi, nirbadub-ginnidgi, ise-nue-sobar, bela-bela-nue-yeerdakle imaksamalad. Igi Bab-Jehová Moisésʼga sogsa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Deginbali, or-nued-matarkwaa sobsamarbalid. We-or-nued-matargwagwadgi wilub-nasikega-imakdamaladyob we-gayaburba nasiklesad: “BAB-JEHOVÁʼGA SWILIDIK-NUGSALEGALED.” ");
INSERT INTO cuk_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","We-or-matargwagwadga dub-arad nasiksamalad. Adi, we-dub mor-gurgin-birgi atinegar. Igi Bab-Jehová Moisésʼga sogsa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Weyob Bab-Dummadse-goled-neg-sunna-seleged, sobsa gusmalad. We-nega bilebalid, Bab-Dummad-dulemarbo-ambikued-negye. Ar igi Bab-Jehová Moisésʼga sogsa, deyob Israel-dulemar sobsamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bab-Dummadse-goled-neg-soblesad Moisésʼga uksamalad, degi, we-ibmarmar-egi-ebulegoed bela ega uksamarbalid: Bela mor-gamalad, e-urgomar, e-suar-walagana, e-buarmar, degi, e-sigmalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","E-sibad-wawaad-machered-e-ukamar-ginnidgi-odolegaled, ibdurgan-uka-nuegan, degi, mor-dummad Bab-Dummad-Dulemarbo-Igar-Mesisad-Ulu-naba-naguoed. ");
INSERT INTO cuk_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Bab-Dummad-Dulemarbo-Igar-Mesisad-Ulu, e-suarmar-suigan, degi, e-eduged. ");
INSERT INTO cuk_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Mese, bela eba-ibmarmar-ebuleged, degi, Bab-Dummad-asabin-madu-ega-ukleged. ");
INSERT INTO cuk_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Gwallu-sied-olobiid-imakaled, e-gwallumar, gwallumar-bela-ilekwaa-silegoed, bela-ibmarmar-gwalluba-ebulemalad, degi, e-gwallu-diimar. ");
INSERT INTO cuk_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Bab-Dummadga-ibmar-wawadik-ogumakar-ukleged-aila-olobiid, gwallu-wawad magega-ebuleged, ina-wawadikid, degi, mor-dummad Bab-Dummadse-goled-neg-sunna-seleged-yawagak-dogedgi naguoed. ");
INSERT INTO cuk_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Bab-Dummadga-ibmar-ogumakar-ukleged-aila esgoro-gordikidgi sobaled, esgoro-gordikidgi san-nared-saki-sakid sobaled, e-suarmar-walagana, degi, bela eba-ibmar-ebulemalad, E-dii-sied, degi, e-siged. ");
INSERT INTO cuk_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Mor-dummagan e-galugi naguoed, e-buarmar, egi-sigmaloed, degine, e-mor-dummad neg-imba-dogedgi naguoed. E-dubmar, e-bargamalad, degi, bela Bab-Dummadse-goled-neg-sunna-seleged dulemarbo-danar-ambikued-neggi ibmar-ebulemalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Deginbali, Bab-Dummadse-goled-neggi dule-irwa-Bab-Dummadse-golega e-mormar-ebulemaloed. Dule-irwa-Bab-Dummadse-goled-Aarón-mormar-islidikid-ebugoed, degi, Aarón-e-masmala dulemar-irwa-Bab-Dummadse-gorsokalir, mormar-ebumaloed. We-ibmarmar Moisésʼga uksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ar igi Bab-Jehová Moisésʼga igar-uksa, bela deyobi Israel-dulemar ibmar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moisés bela ibmar-imaksamalad argasad. Ar Moisés daksagua, Israel-dulemar Bab-Jehová-sogsadba bela ibmar-imaksamala, a-dulemargi ise-nued binsasad. ");
INSERT INTO cuk_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Geb degine, Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Gebe-nii-onoded ibagwengi, anse-goled-neg-sunna-seleged be sioed. We-negde, dulemar-anbo-ambikued-negad. ");
INSERT INTO cuk_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","A-negyabali, Bab-Jehová-Dulemarbo-Igar-Mesisad-Ulu be sioed. Geb we-Ulu-idu, mor-dummad be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Mor-naid-idu, mese be sioed, a-mese, nue-ise-nudakar be sioed. Degine, gwallumar-sied be sibaloed, degine, e-gwallumar ega be ogaoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Anga-ina-wawadikmalad-ogumakar-ukleged-aila-olobiidi, Bab-Jehová-Dulemarbo-Igar-Mesisad-Ulu-irwa mor-naid-asabin, be sioed. Degine, anse-goled-neg-sunna-seleged-doged-asabin, mor-dummad be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","”Geb a-sorbali, anse-goled-neg-sunna-seleged dulemar-anbo-ambikued-negye bilebalid, a-asabin, anga-ibmar-ogumakar-ukleged-aila be sioed. ");
INSERT INTO cuk_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Geb degine, dulemar-anbo-ambikued-neg, degi, anga-ibmar-ogumakar-ukleged-aila, amar negabargi dii-sied be sioed. Geb degine, dii-siedgi dii be enogoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Geb napidgine, e-dikarba galu be imakoed. Geb a-galu-dogedgi mor-dummad be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","”Geb a-sorbali, gwallu-wawad-magega-ebuleged, a-gwallu-wawadgi anse-goled-neg-sunna-seleged, degi, bela-agi-ibmarmar-bukwadi be magoed. Adi, deyob we-ibmarmar angadgarbi guoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Deginbali, anga-ibmar-ogumakar-ukleged-aila, degi, bela e-ibmarmar, gwallu-wawad-magega-ebulegedgi be mage-mage saoed. Adi, deyob we-ibmarmar angadgarbi guoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Amba deyobi, dii-sied, degine, e-siged, gwallu-wawad-magega-ebulegedgi be magbaloed. Adi, deyob we-ibmarmar angadgarbi guoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","”Geb a-sorbali, Aarón, degi, e-masmala, dulemar-anbo-ambikued-neg-e-yawagakse be sedoed. Geb amar diigi be ogoed. ");
INSERT INTO cuk_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Geb Aarónʼga be e-mor-islidikmalad yooed. Geb gwallu-wawad egi be eogoed. Geb anga-arbaega be Aarón-onugsaoed, adi, dule-irwa-anse-goledga guegar. ");
INSERT INTO cuk_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Geb a-sorbali, Aarón-e-masmala bese warmakega be imakoed. Geb degine, ega mor-dummad-suitigwad be yooed. ");
INSERT INTO cuk_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ar igi gwallu-wawad e-babgi be eosa, deyob e-masmalagi be eomogoed. Geb amala dulemar-irwa-goledga anga gumaloed. Gwallu-wawad egi eolesad-ulale, e-wagan degisadegu anse-dule-irwa-goledga gumaloed.” ");
INSERT INTO cuk_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moisés, Bab-Jehová-bela-ega-igar-uksadba sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Birgabogwadgi, gebe-nii-onoded-ibagwenadgi, Bab-Dummadse-goled-neg-sunna-seleged osisgusad. ");
INSERT INTO cuk_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moisés, Bab-Dummadse-goled-neg-sunna-seleged osisad, e-sigmalad urbisad, e-urgomar ogwichisad, e-suarmar-biir-megmalad mesisad, degine, e-buarmar ogwichisbalid. ");
INSERT INTO cuk_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Moisés, Bab-Dummadse-goled-neg-sunna-seleged-birgi mor-dummagan ogichad. Moisés, igi Bab-Jehová ega igar-uksa, sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Geb a-sorbali, Moisés, Bab-Dummad-Dulemarbo-Igar-Mesisad akwagi-narmakar-maid susad, geb Bab-Dummad-Uluyaba mesisad. Degine, a-Ulu seegala, e-suarmar egi yosad. Geb degine, a-Ulu-birgi, Ulu-eduged mesisad. ");
INSERT INTO cuk_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Geb Moisés, Bab-Dummadse-goled-neg-sunna-selegedyaba Ulu odosad. Geb mor-dummad Ulu-idu nasiksad, adi, dulemar mer a-Ulu dakmalagar. Moisés, igi Bab-Jehová ega igar-uksa, sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Moisés, Bab-Dummad-dulemarbo-ambikued-negyaba, mor-dummad-naid-dad-nakwed-argan-sapiledsik, mese sisbalid. ");
INSERT INTO cuk_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","A-mese-birgi madumar ilekwaa urbisad. Moisés, igi Bab-Jehová ega igar-uksa, sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Moisés, Bab-Dummad-dulemarbo-ambikued-neggi, dad-nakwed-argan-nuedsik mese-asabin, gwallu-sied sisad. ");
INSERT INTO cuk_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Degine, Bab-Jehová-asabin gwallumar-ogasad. Moisés, igi Bab-Jehová ega igar-uksa, sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Deginbali, Moisés, Bab-Dummad-dulemarbo-ambikued-neggi, mor-dummad-naid-asabin, Bab-Dummadga-ina-wawadikid-ukleged-aila-olobiid sisbalid. ");
INSERT INTO cuk_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","A-aila-birgine, Moisés, ina-wawadikmalad ogumaksad. Moisés, igi Bab-Jehová ega igar-uksa, sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Deginbali, Moisés, Bab-Dummadse-goled-neg-dogedgi mor-dummad nasiksabalid. ");
INSERT INTO cuk_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Deginbali, Moisés, Bab-Dummad-dulemarbo-ambikued-neg-sunna-seleged-doged-asabin, Bab-Dummadga-ibmar-ogumakar-ukleged-aila sisbalid. Agi, Bab-Dummadga-ibmar-ogumakar uksad, degine, Bab-Dummadga-ibmar-gwagmar-ukleged uksabalid. Moisés, igi Bab-Jehová ega igar-uksa, sogedba imaksad. ");
INSERT INTO cuk_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Deginbali, Moisés, Bab-Dummad-dulemarbo-ambikued-neg, degi, Bab-Dummadga-ibmar-ogumakar-ukleged-aila, wemar-abargine, dii-sied sisbalid. Degine, agi dii enosbalid, adi, agi argan, degi, nag enukegar. ");
INSERT INTO cuk_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Agine, Moisés, Aarón, degi, Aarón-e-masmala, argan, degi, e-nagmar na enuksamalad. ");
INSERT INTO cuk_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Amar, Bab-Dummad-dulemarbo-ambikued-negse dogdemalar, Bab-Dummadga-ibmar-ogumakar-ukleged-ailase warmaknadmalar, e-argan, degine, e-nag enukdamalad. Ar igi Bab-Jehová Moisésʼga igar-uksa, deyob enukdamalad. ");
INSERT INTO cuk_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Geb napidgine, Moisés, Bab-Dummadse-goled-neg-sunna-seleged-e-galumar nasiksad, Bab-Dummadga-ibmar-ogumakar-ukleged-aila, degi, Bab-Dummadse-Goled-Neg-Islidikid, amar-ebilis we-galumar nasiksad. Degine, we-galu-dogedgi mor-dummad nasiksad. Weyob Moisés Bab-Dummadse-goled-neg-sunna-seleged sobsad. Bela Moisés weyob obelosad. ");
INSERT INTO cuk_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Bab-Dummadse-goled-neg-sunna-selegedgi, dulemar-ambikuedgi mogir nagunonikid. Geb a-neggi bela-bela-ena Bab-Jehová-e-gangued-yeerdakleged aidenonikid. ");
INSERT INTO cuk_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moisés, Bab-Dummadse-goled-negse geg-doge-gualid, ar ade, a-birgi mogir-naid, degine, Bab-Jehová-e-gangued-yeerdakleged bela agi ena naibalid. ");
INSERT INTO cuk_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israel-dulemar Bab-Dummadse-goled-neggi bubawaryob mogir-naid-nakwidele, e-neg-bubukwad weeddamalad. Geb agi banguddamarmogad. ");
INSERT INTO cuk_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ar mogir Bab-Dummadse-goled-neggi-bangusulile, Israel-dulemar-na-danar-danar-bukwadgi geg bangudamalad. Mogir Bab-Dummadse-goled-neggi-bangudele, geb agi banguddamalad. ");
INSERT INTO cuk_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ar ade, Bab-Jehová-e-mogir neg-ibgine, ese-goled-neg-birgi naidaed, degine, neg-mutikdi, ese-goled-neg-birgi bubawaryob soo ganaidaed. Bela Israel-dulemar bubawaryob we-mogir dakedbidamalad. Weyobi, Israel-dulemar bangued-irba gusdaed.");
INSERT INTO cuk_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Bab-Jehová dulemarbo-ambikued-neg-akar Moisésʼse gochad. Agi ega sunmaksad, ega sogsad: ");
INSERT INTO cuk_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Israel-dulemarga be sunmake, ega be soge: ‘Bemar Bab-Jehováʼga ibmar-ukleged ukega sedanimalale, sunna moli-bebe-nikad-sedamalad, igi, sibad-wawaaddibe. ");
INSERT INTO cuk_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ar dule-gwensak Bab-Jehováʼga moli-bebe-nikad ogumakar ukele, we-moli-bebe-nikad machered guergebed, swilidik, gwen boni-nikasuli guergebed. We-ibmar-uklenaid, Bab-Jehová-dulemarbo-ambikued-neg-e-yawagak-dogedgi uklegoed, adi, Bab-Jehová nabir we-ibmar abingaegar. ");
INSERT INTO cuk_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Dule, moli-bebe-nikad-sapingwagwad-ogumakar-uklegoed-e-nonogi na e-argan mesoed. Deyobi, dule-e-isgued-elilegegala, Bab-Jehová we-moli-bebe-nikad abingaoed. ");
INSERT INTO cuk_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Geb degine, dule, Bab-Jehová-asabin we-moli-bebe-nikad-sapingwagwad-e-dukar egwannoed. Geb Aarón-masmala-dule-irwa-Bab-Dummadse-gormalad, Bab-Jehováʼga we-moli-e-abe ukoed. Geb sorbali, moli-abe ibmar-ogumakar-ukleged-aila-e-dikarmargi bomi-bomi imakoed. We-ailade, Bab-Dummad-dulemarbo-ambikued-neg-yawagak-dogedgi siid. ");
INSERT INTO cuk_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","A-sorbali, moli-bebe-nikad-sapingwagwad-e-uka edaroed, geb e-san goa-goa imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aarón-masmala-dule-irwa-Bab-Dummadse-gormalad, ibmar-ogumakar-ukleged-aila-birgi sapanmar urboed, geb soo ogamaloed. ");
INSERT INTO cuk_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Geb Aarón-masmala-dule-irwa-Bab-Dummadse-gormalad, moli-e-san-goamakaled, e-nono, degi, e-samurgi-gwallu-nanaid ibmar-ogumakar-ukleged-ailagi soo-gasiid-birgi urboed. ");
INSERT INTO cuk_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Dule-ibmar-uknaid, moli-e-samurmar, degi, e-malimar, diigi enukoed. Geb dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-aila-birgi bela ogumakoed. We, ibmar-ogumakar-uklegedid, Bab-Jehováʼga soogi-ogumakar ibmar-ukleged yeer-yapannedid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Bab-Jehová Moisésʼga sogdebalid: “Ar dule-gwensak anga sibad-wawaad, igi, sibaddibe ogumakar ukele, we-ibdurgan-machered swilidik, gwen boni-nikasuli guergebed. ");
INSERT INTO cuk_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","We-dule, Bab-Jehová-asabin ibmar-ogumakar-ukleged-aila-dad-nakwed-argan-sapiledsik, sibad-wawaad-machered-e-dukar egwannoed. Geb Aarón-masmala-dule-irwa-Bab-Dummadse-gormalad, sibad-wawaad-e-abe, ibmar-ogumakar-ukleged-aila-e-dikarmargi bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Geb sorbali, we-dule, sibad-wawaad-e-san goa-goa imakoed. Geb dule-irwa-Bab-Dummadse-gormalad, sibad-wawaad-e-san-goamakaled, e-nono, degi, e-samurgi-gwallu-nanaid ibmar-ogumakar-ukleged-ailagi, soo-gasiid-birgi urboed. ");
INSERT INTO cuk_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Dule-ibmar-uknaid, sibad-wawaad-e-samurmar, degi, e-malimar, diigi enukoed. Geb dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-aila-birgi bela ogumakoed. We, ibmar-ogumakar-uklegedid, Bab-Jehováʼga soogi-ogumakar ibmar-ukleged yeer-yapannedid.” ");
INSERT INTO cuk_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-gwensak Bab-Dummadga nuumar-ogumakar-ukele, sunna sapur-nuu, igi, wagnuu-mimmidibe, Bab-Jehováʼga uked. ");
INSERT INTO cuk_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-aila-birgi nuu mesoed, geb agi e-ibe dukar ungoed. Geb nuu-abe ibmar-ogumakar-ukleged-aila-dikarba eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Dule-irwa-Bab-Dummadse-goled, nuu-e-masgammu, degi, e-samurmar onioed. Geb bia buru milege, ibmar-ogumakar-ukleged-aila-dikarba, dad-nakwedsik mioed. ");
INSERT INTO cuk_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Agine, nuu-saban egaoed, geb sakangi-gani negabar onaboed. Geb degine, dule-irwa-Bab-Dummadse-goled, we-nuu, ibmar-ogumakar-ukleged-aila-birgi soo-gasiidgi ogumakoed. We, ibmar-ogumakar-uklegedid, Bab-Jehováʼga soogi-ogumakar ibmar-ukleged yeer-yapannedid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be soge: ‘Dule-gwensak anga ibmar-gwag-gulleged ukele, e-madubur-bur-nued sedagoed. A-madubur-birgine, olivo-gwallu, degi, ina-wawadikid eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","A-sorbali, we-dule, Aarón-masmala-dule-irwa-Bab-Dummadse-gormaladse we-madubur sedoed. Geb dule-irwa-Bab-Dummadse-goled, argan-nukgwen, we-madubur-olivo-gwallubo-oburaled, degi, ina-wawadikidmala suoed. Geb dule-irwa-Bab-Dummadse-goled, we-madubur ibmar-ogumakar-ukleged-ailagi ogumakoed, adi, ebinsamalaga we-ibmar-gwagmar Bab-Jehová bemarga ukmaid. We, ibmar-ogumakar-uklegedid, Bab-Jehováʼga soogi-ogumakar ibmar-ukleged yeer-yapannedid. ");
INSERT INTO cuk_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ibmar-ukleged-obichaddi, Aarónʼgadga, degi, e-masmalagadga guoed. Bab-Jehováʼga soogi-ogumakar-ibmar-uklemalad-bamaladba we-ibmar-ukleged bur-ise-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","” ’Ar be Bab-Jehováʼga ibmar-gwag-gulleged soogi-yoar uknaile, ega be madu-olo bur-madubur-nuedgi-imakaled-inasulid, olivo-gwalluba-omukualed be ukoed, madu-dibyaled-inasulid, olivo-gwallugi-magaled be ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","” ’Ar be Bab-Jehováʼga ibmar-gwag-gulleged dibyar ukele, bur-madubur-nuedgi-imakaled-inasulid, olivo-gwalluba-omukualed be ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","We-madu-dibyaled, be bisge-bisge imakoed, geb olivo-gwallu be egi eogoed. We, Bab-Jehováʼga ibmar-gwag-gulleged ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","” ’Ar be Bab-Jehováʼga ibmar-gwag-gulleged bormogi-duar ukele, bur-madubur-nuedgi-imakaled, olivo-gwalluba-omukualed be ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Weyobi, ibmar-gwag-gulleged we-ibmarmarba guagwar-imaklesad, Bab-Jehováʼga be sedoed, degi, dule-irwa-Bab-Dummadse-goledga be ukoed. Geb agine, dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-ailase sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Agi, dule-irwa-Bab-Dummadse-goled, argan-nukgwensaar we-ibmar-ukleged ogumakoed, adi, bemar ebinsamalaga: Ani, Bab-Jehová, an bemarga bela ibmar uked. We, ibmar-ogumakar-uklegedid, Bab-Jehováʼga soogi-ogumakar ibmar-ukleged yeer-yapannedid. ");
INSERT INTO cuk_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ibmar-ukleged-obichaddi, Aarónʼgadga, degi, e-masmalagadga guoed. Bab-Jehováʼga soogi-ogumakar-ibmar-uklemalad-bamaladba we-ibmar-ukleged bur-ise-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","” ’Be Bab-Jehováʼga ibmar-gwag-gulleged-ukleged-ukedi, bipisaale madu-inaba, degi, achanisba be oburosulid. Ar ade, Bab-Jehováʼga soogi-ibmar-ogumakar-ukleged bipisaar madu-ina-nika, degi, achanis-nika ogumaklegosulid. ");
INSERT INTO cuk_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Bab-Jehováʼga gebe-ibmar-sanmaksamalad-uklegedbali, achanis, degi, madu-ina be ukoed. Degi-inigwele, Bab-Jehováʼga ibmar-ogumakar-ukleged-ailagi ibmar-ukleged-yeer-yapannedyobi be ukosulid. ");
INSERT INTO cuk_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","” ’Bela ibmar-gwag-gulleged-ukleged, baluba be imakoed. Ar balu Bab-Dummad-bebo-igar-mesisad-e-wilub gued. Degisoggu, bela be-ibmar-uklegedgi balu be mesoed. ");
INSERT INTO cuk_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","” ’Bab-Jehováʼga ibmar-gwag-gulleged-gebe-sanmaklesad be ukele, soogi e-warmarbela be yooed, degi, e-gwagmar-nagale be ukoed. We, be-ibmar-gwag-gulleged-gebe-sanmaklesad-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","A-birgine, olivo-gwallu, degi, ina-wawadikid be eogoed. We, ibmar-gwag-gulleged-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Dule-irwa-Bab-Dummadse-goled, argan-nukgwensaar, we-ibmar-gwag-nagaled-olivo-gwalluba-oburaled, degi, bela ina-wawadikidmala ogumakoed, adi, bemar ebinsamalaga: Ani, Bab-Jehová, an bemarga bela ibmar ukmaid. We, Bab-Jehováʼga soogi-ogumakar-ibmar-uklegedid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be soge: ‘Dule-gwensak gwenatigwar-guega anga moli-bebe-nikad ukele, we-moli machereddibe, omedibe, swilidik, gwen boni-nikasulid anga ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","We-dule, moli-bebe-nikad-ogumakar-uklegoed-e-nonogi na e-argan mesoed. Bab-Dummad-dulemarbo-ambikued-neg-yawagak-dogedgi we-moli-e-dukar egwannoed. Geb sorbali, Aarón-masmala-dule-irwa-Bab-Dummadse-gormalad, moli-e-abe ibmar-ogumakar-ukleged-aila-dikarmargi bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","” ’Geb dule-gwenatigwar-guega Bab-Jehováʼga we-moli-ibmarmar soogi-ogumakar ukoed: Samurgi-gwallumar-nanaid, bela samur-bukwad-e-dikarmargi-gwallumar-nanaid, ");
INSERT INTO cuk_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","e-mirwa-gwabogwad, mirwa-birgi-gwallumar-nanaid, e-dikarmargi-gwallumar-nanaid, bina-dutugwadgi-gwallumar-nanaid. We-bina-dutugwad mirwa-gwabogwadba-mesa onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Geb degine, Aarón-masmala bela we-ibmarmala ibmar-ogumakar-ukleged-ailagi ogumakoed. We-ibmarmar, soo-gasiid-birgi ibmar-ogumakar-ukleged-bukwadmala ogumaklegoed. We, Bab-Jehováʼga soogi-ibmar-ukleged, Bab-Jehová yeer-yapanne itogedid. ");
INSERT INTO cuk_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","” ’Ar dule-gwenatigwar-guega Bab-Jehováʼga sibad-wawaad-ukele, we-sibad-wawaad machereddibe, omedibe, swilidik, gwen boni-nikasulid ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ar sibad-wawaad-sapingwagwad ukele, Bab-Jehováʼga uknaidgi ");
INSERT INTO cuk_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","dule-ibmar-uknaidi, sibad-wawaad-sapingwagwad-e-nonogi na e-argan mesoed. Geb Bab-Dummad-dulemarbo-ambikued-neg-yawagak-asabin we-sibad-wawaad-e-dukar egwannoed. Geb sorbali, Aarón-masmala ibmar-ogumakar-ukleged-aila-e-dikarmargi sibad-wawaad-e-abe bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","” ’Dule-gwenatigwar-guega Bab-Jehováʼga we-sibad-wawaad-ibmarmar ogumakar ukoed: E-gwallu, e-bunnusaila-nagase-sikaled, samur-birgi-gwallumar-nanaid, degi, bela samur-bukwad-e-dikarmargi-gwallumar-nanaid, ");
INSERT INTO cuk_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","e-mirwa-gwabogwad, degi, mirwa-birgi-gwallumar-nanaid, e-dikarmargi-gwallumar-nanaid, deginbali, bina-dutugwadgi-gwallumar-nanaid. We-bina-dutugwad mirwa-gwabogwadba-mesa onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Geb degine, dule-irwa-Bab-Dummadse-goled bela we-ibmarmar ibmar-ogumakar-ukleged-ailagi ogumakoed. We-ibmar-ogumaklegedi, Bab-Jehováʼga masga gued. ");
INSERT INTO cuk_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","” ’Ar dule Bab-Jehováʼga sibad ukele, Bab-Jehováʼga we-sibad uknaidgine, ");
INSERT INTO cuk_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","na e-argan sibad-e-nonogi mesoed. Geb Bab-Dummad-dulemarbo-ambikued-neg-asabin sibad-e-dukar egwannoed. Sorbali, Aarón-masmala ibmar-ogumakar-ukleged-aila-e-dikarmargi sibad-e-abe bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","” ’Dule-gwenatigwar-guega Bab-Jehováʼga we-sibad-ibmarmar soogi ogumakar ukoed: Samur-birgi-gwallumar-nanaid, bela samur-bukwad-e-dikarmargi-gwallumar-nanaid, ");
INSERT INTO cuk_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","e-mirwa-gwabogwad, mirwa-birgi-gwallumar-nanaid, e-dikarmargi-gwallumar-nanaid, bina-dutugwadgi-gwallumar-nanaid. We-bina-dutugwad mirwa-gwabogwadba-mesa onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","” ’Geb degine, dule-irwa-Bab-Dummadse-goled bela we-ibmarmar ibmar-ogumakar-ukleged-ailagi ogumakoed. We-ibmar-ogumaklegedi, Bab-Jehováʼga masga gued, yeer-yapannedid. Bela we-gwallumala Bab-Jehováʼgadid. ");
INSERT INTO cuk_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","” ’Ar bia bemar ambikuoe, bemarga, degi, be-waganga, degisadegu weyob igar megoed: Bemar bipisaale, ibmar-e-gwallu, degi, ibmar-abe gunnosurmalad.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Israel-dulemarga be sunmak, amarga be soge: ‘Dule-gwensak na wissulidba Bab-Jehová-Igar-Maidgi annasale, ibmar-ise-imakleged imaksale, weyob ibmar imaklegoed: ");
INSERT INTO cuk_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","” ’Ar dule-irwa-Bab-Dummadse-goled-e-dummad isgusale, bela Israel-dulemar-oichononikoed. A-ulale, Bab-Jehováʼga moli-bebe-nikad-sapingwagwad-swilidikid, gwen boni-nikasulid na e-isgusad-ular, ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dule-irwa-Bab-Dummadse-goled Bab-Dummad-dulemarbo-ambikued-neg-yawagak-dogedse, Bab-Jehováʼse we-moli-sapingwagwad sedoed. Agi, we-moli-e-nonogi na e-argan mesoed. Geb Bab-Jehová-asabin we-moli-dukar egwannoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Geb sorbali, dule-irwa-Bab-Dummadse-goled-e-dummad moli-sapingwagwad-e-abe ichesaar suoed. Geb we-abe, Bab-Dummad-dulemarbo-ambikued-negse sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Dule-irwa-Bab-Dummadse-goled na e-goo moli-abegi owardikuoed, geb Bab-Dummadse-goled-neg-Ise-Islidikid-idu atued-dummad-naidsik, Bab-Jehová-asabin, ilagugle (7) we-abe bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Geb sorbali, dule-irwa-Bab-Dummadse-goled, we-abe Bab-Dummadga-ina-wawadikid-obupurmakleged-ailagi moli-bebeyob-gwigwichidgi magoed. We-galu, Bab-Dummad-dulemarbo-ambikued-neggi, Bab-Jehová-asabin siid. Geb bela abe-gwabguoedi, Bab-Dummad-dulemarbo-ambikued-neg-yawagak-dogedgi ibmar-ogumakar-ukleged-aila-siid-nagagi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Geb we-dule-irwa-Bab-Dummadse-goled, isgued-ular, we-moli-bebe-nikad-sapingwagwad-ibmarmar Bab-Jehováʼga ogumakar ukoed: E-samurgi-gwallumar-nanaid, degi, bela samur-bukwad-e-dikarmargi-gwallumar-nanaid weoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Deginbali, e-mirwa-gwabogwad, mirwa-birgi-gwallumar-nanaid, e-dikarmargi-gwallumar-nanaid, bina-dutugwadgi-gwallumar-nanaid webaloed. We-bina-dutugwad mirwa-gwabogwadba-mesa onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","” ’Ar igi dule-gwenatigwar-guega moli-bebe-nikad-uklenaid-e-gwallumar weedae, deyobi, we-moli-sapingwagwad-e-gwallumar weemogoed. Geb degine, dule-irwa-Bab-Dummadse-goled we-ibmarmala ibmar-ogumakar-ukleged-ailagi ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","” ’Ar moli-bebe-nikad-sapingwagwad-e-uka, bela e-san, e-nonoba-mesa, e-malimar, e-samurmar, degi, e-saamar, Israel-dulemar-danar-danar-bukwad-magaba onogoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Bela we-moli-e-ibmarmar dulemar danar-danar-bukwad-magaba, ar bia burumar-milegedse, neg-swilidikidse onolegoed. Geb agi, soo-gasiid-birgi be ogumakoed. Buru-milegedgi ogumaklegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Ar bemar ibmar-wissulidba Bab-Jehová-Igar-Maidgi annasale, ibmar-ise-imakleged imaksale, bela Israel-dulemar Bab-Jehováʼgi nue-dummad-isgusmalad. ");
INSERT INTO cuk_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ar Israel-dulemar na e-isgusad wisgunonimalale, e-isgusad-anar moli-bebe-nikad-sapingwagwad anga ukega senonimaloed. We-moli-sapingwagwad Bab-Dummad-dulemarbo-ambikued-negse sedmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Israel-girmar-dummagan Bab-Jehová-asabin moli-sapingwagwad-e-nonogi e-arganmar mesmaloed. Geb Bab-Jehová-asabin we-moli-sapingwagwad-dukar egwanmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Geb sorbali, dule-irwa-Bab-Dummadse-goled-e-dummad, moli-sapingwagwad-abe Bab-Dummad-dulemarbo-ambikued-neg-yase sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Dule-irwa-Bab-Dummadse-goled na e-goo moli-sapingwagwad-abegi owardikuoed. Geb Bab-Dummadse-goled-neg-Ise-Islidikid-idu atued-dummad-naidsik, Bab-Jehová-asabin, ilagugle (7) we-abe bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Geb sorbali, dule-irwa-Bab-Dummadse-goled, we-abe ichesaar ibmar-ogumakar-ukleged-ailagi moli-bebeyob-gwigwichidgi magoed. We-galu, Bab-Dummad-dulemarbo-ambikued-neggi, Bab-Jehová-asabin siid. Geb bela abe-gwabguoedi, Bab-Dummad-dulemarbo-ambikued-neg-yawagak-dogedgi ibmar-ogumakar-ukleged-aila-siid-nagagi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Geb dule-irwa-Bab-Dummadse-goled-e-dummad bela moli-bebe-nikad-sapingwagwad-e-gwallu weoed, geb ibmar-ogumakar-ukleged-ailagi ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","” ’Ar dule-irwa-Bab-Dummadse-goled-isgusad-anar igi moli-bebe-nikad-sapingwagwad imakledae, deyobi, Israel-dulemar-e-isgusad-anar we-moli-bebe-nikad-sapingwagwad imaklemogoed. Deyobi, dule-irwa-Bab-Dummadse-goledi Israel-dulemarga e-isgusad Bab-Dummad-ega-osulogega imakoed. Geb Bab-Dummad Israel-dulemar egi nossuliyob dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Geb sorbali, dule-irwa-Bab-Dummadse-goled Israel-dulemar-danar-danar-bukwad-magaba moli-onogoed. Geb igi moli-bebe-nikad-sapingwagwad-idualed ogumaksagusa, deyobi, we-moli-bebe-nikad-sapingwagwad ogumakbaloed. Ar Israel-dulemar-e-isgusad-anar we-moli-bebe-nikad oburgwilenaid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Ar dule-dummadga-maid na wissulidba isgusale, na e-Bab-Dummad-Jehová-igar-maidgi annasale, ibmar-ise-imakleged imaksale, we-dule-dummadga-maid Bab-Jehováʼgi nue-dummad-isgusad. ");
INSERT INTO cuk_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","We-dule na e-isgusad wisgunonikile, sibad-machered-swilidikid, gwen boni-nikasulid na e-isgusad-anar Bab-Jehováʼga-ukega senonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","We-dule sibad-nono-birgi na e-argan mesoed. Geb bia ibmar-durgan-ogumakar-ukleged-e-dukar egwallege, agi Bab-Jehová-asabin sibad-e-dukar egwannoed. We-sibad dule-isgusad-anar oburgwilenaid. ");
INSERT INTO cuk_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Geb degine, dule-irwa-Bab-Dummadse-goled we-sibad-e-abegi e-goo owardikuoed. Geb we-abe ibmar-ogumakar-ukleged-ailagi-moli-bebeyob-gwigwichidgi mage-mage imakoed. Geb bela abe-gwabguoedi ibmar-ogumakar-ukleged-aila-siid-nagagi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Geb dule-irwa-Bab-Dummadse-goled bela sibad-e-gwallu ibmar-ogumakar-ukleged-ailagi ogumakoed, ar igi dule-gwenatigwar-guega ibmar-ukleged-e-gwallu ogumakdae, deyob imakmogoed. Deyobi, dule-irwa-Bab-Dummadse-goledi dule-dummadga-maid-e-isgusad Bab-Dummad-ega-osulogega imakoed. Geb Bab-Dummad dule-dummadga-maid egi nossuliyob dakoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Ar Israel-dule-wargwen, na wissulidba isgusale, na e-Bab-Dummad-Jehová-igar-maidgi annasale, ibmar-ise-imakleged imaksale, we-dule Bab-Jehováʼgi nue-dummad-isgusad. ");
INSERT INTO cuk_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","We-dule na e-isgusad wisgunonikile, sibad-ome-swilidikid, gwen boni-nikasulid na e-isgusad-anar Bab-Jehováʼga-ukega senonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","We-dule sibad-nono-birgi na e-argan mesoed. Geb bia ibmar-durgan-ogumakar-ukleged-e-dukar egwallege, agi, sibad-e-dukar egwannoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Geb degine, dule-irwa-Bab-Dummadse-goled na e-goo sibad-e-abegi owardikuoed. Geb ibmar-ogumakar-ukleged-ailagi-moli-bebeyob-gwigwichidgi abe mage-mage imakoed. Geb bela abe-gwabguoedi ibmar-ogumakar-ukleged-aila-siid-nagagi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Geb sorbali, dule-irwa-Bab-Dummadse-goled sibad-e-gwallu bela weoed, ar igi dule-gwenatigwar-guega ibmar-ukleged-e-gwallu weedae, deyob imakbaloed. Geb dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-ailagi sibad-e-gwallu ogumakoed. We-ibmarde Bab-Jehováʼga-ibmar-ukleged yeer-yapannedid. Deyobi, dule-irwa-Bab-Dummadse-goledi dule-e-isgusad Bab-Dummad-ega-osulogega imakoed. Geb Bab-Dummad dule egi nossuliyob dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","” ’Ar dule-isgusad na e-isgusad-anar sibad-wawaad-sedanikile, sibad-wawaad-ome-bipi nue-swilidikid, gwen boni-nikasulid Bab-Jehováʼga senonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","We-dule, we-sibad-wawaad-e-nono-birgi e-argan mesoed. Geb bia ibmar-durgan-ogumakar-ukleged-e-dukar egwallege, agi we-sibad-wawaad-e-dukar, e-isgued-anar egwannoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Geb sorbali, dule-irwa-Bab-Dummadse-goled e-goo sibad-wawaad-e-abegi owardikuoed. Geb ibmar-ogumakar-ukleged-ailagi-moli-bebeyob-gwigwichidgi abe mage-mage imakoed. Geb bela abe-gwabguoedi ibmar-ogumakar-ukleged-aila-siid-nagagi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Geb sorbali, sibad-wawaad-e-gwallu bela weoed, ar igi dule-gwenatigwar-guega sibad-wawaad-mimmi-ukleged-e-gwallu weedae, deyob imakbaloed. Geb dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-ailagi, sibad-wawaad-e-gwallu ibmar-ogumakar-ukleged-bamaladba-mesa ogumakoed. Deyobi, dule-irwa-Bab-Dummadse-goledi dule-e-isgusad Bab-Dummad-ega-osulogega imakoed. Geb Bab-Dummad dule egi nossuliyob dakoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Ar dule-gwensakse gorlenonikile, be ibmar-daksad, be ibmar-itosad sogdaye. Ar we-dule yapa sogdagele, we-dule, dummad-nosad, degisoggu, sabsur-odurdaklegergebed. ");
INSERT INTO cuk_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Dule-gwensak ibmar-swilidiksulid ebusale: Ibmar-durgan-ised-burgwisaddibe, ibmar-durgan-ised-sunna-akweleged-burgwisaddibe, ibmar-ised-napagi-garmakdimalad-burgwisaddibe, we-dule, ibmar-isedgi-warmaksad itossur-inigwele, swilidiksuli gunonikoed. Degisoggu, we-dule, nue-dummad-nosad. ");
INSERT INTO cuk_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","” ’Dule-gwensak wissulidgi ibmar-isgana-dulegi-danikid ebusale, we-dule, swilidiksuli gunonikoed. Geb sorba, deyob ibmar-imaksaye-wisgunonikile, we-dule, nue-nosadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","” ’Dule-gwensak, ibmar-nued-imakega, ibmar-isgana-imakegardibe, ibmar-ise-sogar-sogleged, nue-binsassuli sogsadibe, geb degine, sorba, magar itononikile, ede, deyob sogewilubsulinye, we-dule, nue-nosadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","” ’Dule-gwensak we-ibmarmar-soggwenadgi isgusale, e-isgusad dukin na barsogergebed. ");
INSERT INTO cuk_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Geb Bab-Jehováʼga na e-isgusad-anar sibad-wawaad-ome, sibad-omedibe, oburgwega ukoed. Weyobi, dule-irwa-Bab-Dummadse-goled, Bab-Dummad we-dulega-isgusad-osulogega imakoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-isgusad sibad-wawaad-mimmi-bakega mani galakuele, sapur-nuu-gwabo, wagnuu-mimmi-gwabodibe, na e-isgusad-ular Bab-Jehováʼga ukoed. Nuu-gwagwen e-isgusad-ular oburgwelegega ukoed, baiddi, ogumaklegega ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","We-dule, dule-irwa-Bab-Dummadse-goledse we-nuumar sedoed. We-Bab-Dummadse-goled gebedgine isgusad-ular nuu-gwagwen weyob ukoed: E-dukar obipirmakoed, degi-inigwele, e-nono dukargi ungosulid. ");
INSERT INTO cuk_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Geb sorbali, isgued-ular nuu-uklenaid-e-abe ibmar-ogumakar-ukleged-aila-dikargi bomi-bomi imakoed. Geb nuu-abe-obichadi, ibmar-ogumakar-ukleged-aila-nagagi mioed. We-ibmar-uklegedi isgued-ular ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Dule-irwa-Bab-Dummadse-goled nuu-baiddi igar-maidba ogumakar ukoed. Weyobi, dule-irwa-Bab-Dummadse-goled, Bab-Dummad we-dulega-isgusad-osulogega imakoed. Geb Bab-Dummad dule egi nossuliyob dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","” ’Ar dule-isgusad sapur-nuu-gwabo-bakega, wagnuu-mimmi-gwabo-bakegardibe, mani galakubalile, madubur-bur-nued nibiratar na e-isgusad-ular Bab-Jehováʼga ukoed. We-maduburgi, olivo-gwallu, degi, ina-wawadikid eogosulid. Ar we-madubur isgued-ular ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Geb we-madubur dule-irwa-Bab-Dummadse-goledse sedoed. Bab-Jehová bemarga bela we-ibmar-ukmaid be ebinsamalaga, dule-irwa-Bab-Dummadse-goled madubur na argan-nukgwen suoed. Geb we-madubur Bab-Jehováʼga-ibmar-bamalad-soogi-ogumakar-uklegedba-mesa ibmar-ogumakar-ukleged-ailagi ogumakoed. We-ibmar-uklegedi, isgued-ular ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Weyobi, dule-irwa-Bab-Dummadse-goled ibmar-ukleged Bab-Jehováʼga ukoed. Adi, Bab-Jehová, dulega e-isgusad eliega, egi nossuliyob dakegar. Ibmar-ukleged-gwabgusaddi, dule-irwa-Bab-Dummadse-goledgadga guoed. Ar igi ibmar-gwag-ukleged obichale, a-dulemarga ukledae, deyob uklemogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: “Israel-dulemarga be sogo: ");
INSERT INTO cuk_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","‘Dule-gwensak na wissulidba Bab-Jehová-ibmar-islidikidgi isgusale, Bab-Jehováʼga e-isgued-ular sibad-wawaad-machered-swilidikid, gwen boni-nikasulid ukoed. We sibad-wawaad-macheredga e-mani-gargegued mani-aidikuedba nasiklegoed. Ar igi Bab-Dummadse-goled-neggi mani-aidikued-wilub-ebislege, deyob ebislegoed. We-ibmar-uklegedi, isgued-ular ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Dule-isgusad we-ibmar-islidikidgi-isgusad-ulale, gannar a-wilub ibmar ukoed, degine, napi ibmar-atargi gwensak ukbaloed. We-ibmardi dule-irwa-Bab-Dummadse-goledga ukoed. Weyobi, dule-irwa-Bab-Dummadse-goled dule-isgusad-ular Bab-Dummadga sibad-wawaad-machered oburgoed, geb Bab-Dummad dule egi nossuliyob dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","” ’Ar dule-gwensak na wissulidba Bab-Jehová-Igar-Maidgi annanonikile, amba we-dule isgusye soglegoed, sabsur-odurdaklegergebed. ");
INSERT INTO cuk_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Degisoggu, dule-irwa-Bab-Dummadse-goledse sibad-wawaad-machered-swilidikid, gwen boni-nikasulid sedoed. We sibad-wawaad-macheredga dule-isgusadba mani-soglesadba e-mani-gargegued nasiklegoed. Weyobi, dule-irwa-Bab-Dummadse-goled we-dule ibmar-wissulidba-isgusad Bab-Dummad ega osulogega imakoed, geb Bab-Dummad dule egi nossuliyob dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","We-ibmar-uklegedi, isgued-ular ibmar-uklegedid. Ar we-dule, Bab-Jehová-Igar-Maidgi annasad, Bab-Jehováʼgi nue-dummad nosad.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: “Israel-dulemarga be sogo: ");
INSERT INTO cuk_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","‘Dule-gwensak dule-baid ega ibmar-sabogega-uksadi, a-ibmar gannar yapa e-ibedga ukele, mer-ukega yardaksadibe, ei ibmar atursasdibe, gannadgi annik ibmar-susdibe, we-dule weyob-imaksadbali, Bab-Jehováʼgi nue-dummad nosad. ");
INSERT INTO cuk_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Deginbali, ibmar-yoggusad amisale, degite, amissurye sogdibe, dule-gusgu-isgudaedgi, isgussurye gakansaar ise-sogar-sogdibe, ");
INSERT INTO cuk_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","we-dule we-ibmargi nosad, egi ataklegoed. Degisoggu, gannar we-ibmarmar ukergebed: Ibmar-atursasad, emar-annik gandikidgi ibmar-susad, dule-baid ega ibmar-sabogega-uksanad, ibmar-yoggusad amissurye-soged, ");
INSERT INTO cuk_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ibmar-bamaladgi-gakansaar-sogsad-imakoye. We-dule, a-ibmarmar bela e-ibedga gannar ukoed, deginbali, napi ibmar-atargi gwensak ega ukbaloed. Ar e-isgued-ular, ibmar-uknaid-ibagi, ibmar-ibedga bela we-ibmarmar gannar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","” ’Na e-isgusad-ular, Bab-Jehováʼga sibad-wawaad-machered-swilidikid, gwen boni-nikasulid sedoed. Dule-isgusadba mani-soglesadba we-sibad-wawaad-macheredga mani-gargegued nasiklegoed. Geb dule, we-sibad-wawaad-machered na e-isgusad-ular, dule-irwa-Bab-Dummadse-goledga ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Geb degine, dule-irwa-Bab-Dummadse-goled we-dule-e-isgued-ular, Bab-Jehováʼga sibad-wawaad ukoed. Geb Bab-Jehová bela we-dule-e-isgusad osulogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Aarónʼga, degi, e-masmalaga be soge: ‘Ibmar-ogumakar-uklealir, weyob be imakmaloye: ” ’Ibdurgan-ogumakar-ukleged bela gummakegala, ibmar-ogumakar-ukleged-aila-birgi mutiki gamai oibodagoed. Ibmar-ogumakar-ukleged-aila-birgi soo-gasiid ginnosulid. ");
INSERT INTO cuk_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","” ’Dule-irwa-Bab-Dummadse-goled e-linoʼmor yooed, degi, lino-morsangi-garson-bipi-makaled yobaloed. Ibdurgan-ogumaklenaid bela gummaksale, dule-irwa-Bab-Dummadse-goled ibmar-ogumakar-ukleged-aila-birgi buru-bukwad weoed. Geb we-aila-dikarba buru urboed. ");
INSERT INTO cuk_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Sorbali, dule-irwa-Bab-Dummadse-goled e-mor esugoed, geb mor-baid yooed. Geb degine, Israel-dulemar-danar-danar-bukwad-magaba, neg-swilidikidse buru sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","” ’Ibmar-ogumakar-ukleged-aila-birgi soo-gasiid ginnosulid. Dule-irwa-Bab-Dummadse-goled bane-bane wakudaryalaba soo-gasiid-birgi sapan urboed. A-soo-birgine, Bab-Jehováʼga-ibmar-ogumakar-uklenaid mesoed, deginbali, a-birgi dule-gwenatigwar-guega ibmar-uklenaid-e-gwallu ogumaklebaloed. ");
INSERT INTO cuk_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ibmar-ogumakar-ukleged-aila-birgi soo-gasiid bipisaar ginnosulid, degisadegu gasii guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: “Aarónʼga, degi, e-masmalaga be sogoed: ‘Bab-Jehováʼga ibmar-gwag-uklegoed-e-igar weyob mai-guoye: Bemar ibmar-ogumakar-ukleged-aila-asabin Bab-Jehováʼga ibmar-gwag ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","” ’Dule-irwa-Bab-Dummadse-goled-wargwen Bab-Jehováʼga-ibmar-ukleged-madubur-bur-nued olivo-gwalluba-mesa argan-nukgwen weoed, deyobi, ibmar-gwag-ukleged-birgi bela ina-wawadikid-bukwad subaloed. Bela we-ibmarmar-susadi, ibmar-ogumakar-ukleged-aila-birgi ogumakoed. Adi, bemar ebinsamalaga, Bab-Jehová bela bemarga ibmar ukmaid. Bab-Jehová we-ibmar-ukleged yeer-yapan itodaed. ");
INSERT INTO cuk_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","” ’Bemar, we-ibmar-ukleged-gwabguoed gunmaloed. Madubur-e-inasuli, Bab-Dummad-dulemarbo-ambikued-neg-imbagi, neg-islidikidgi gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","” ’We-ibmar madubur-e-inaba dulegosulid. Ar ade, we-ibmar-ogumakar-uklesad-gwabgusadi, ani, Bab-Jehová, Aarónʼga, degi, e-masmalaga uksad. Ar we-ibmar igi isgusad-ular-ibmar-ukleged islidikid gue, degi, igi dule-baidgi-nosar-ibmar-ukleged islidikid gue, deyobi, we-ibmar bur-ise-islidikidid gumogad. ");
INSERT INTO cuk_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","” ’Bela Aarón-e-wagan-machergan we-ibmar sunna gunmaloed. Weyobi, Bab-Jehováʼga-ibmar-ogumakar-ukleged be-waganga degisadegu igar maiguoed. Ibu-ibmar Bab-Dummadga-ibmar-uklegedgi warmaksale, we-ibmar-warmaksad ibmar-swilidikidga gunonikoed.’ ” Weyob Bab-Jehová Moisésʼga sunmaksad. ");
INSERT INTO cuk_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: “Aarónʼga, degi, e-masmalaga be soge: ");
INSERT INTO cuk_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","‘Bemar, Bab-Jehováʼga arbaega-nugsalegoed-ibagi, we-ibmar-ukleged ukmaloed: Madubur-bur-nued, nibiratar anga ukoed. Wakdara negabar ukoed, baid negabaladdi sedo ukoed. Degisadegu na ukdii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","We-ibmar-uklenaid ibmar-dibyedgine olivo-gwalluba be dibyoed. Degine, nue-omukuar burwi-burwi-dibyale anga be ukoed. We, ani, Bab-Jehová, yeer-yapanne itodaed. ");
INSERT INTO cuk_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Amba deyobi, dule-irwa-anse-goled e-bab-Aarón-sorba-arbaega nugsalenonikir, imakmogoed. Bab-Jehová we-igar degisadegu maiguega uksad. We-ibmar-ukleged bela ogumaklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Dule-irwa-Bab-Dummadse-goled Bab-Jehováʼga na e-ibmar-uked gunnosulid, bela ogumaklegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Aarónʼga, degi, e-masmalaga be soge: ‘Isgued-ular Bab-Jehováʼga-ibmar-ogumakar-ukleged-igar weyob mai-guoye: Bia ibdurgan-ogumakar-ukleged-e-dukar-egwallege, agi, Bab-Jehová-asabin isgued-ular-ibmar-uklenaid-e-dukar egwallemogoed. We-ibmarde ibmar-bur-ise-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Dule-irwa-Bab-Dummadse-goled isgued-ular-ibdurgan-uknaid, sunna we-san gunnoed. Bab-Dummad-dulemarbo-ambikued-neg-e-imbagi neg-islidikidgi gunnoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","We-sangi ibu warmaksadibe, bela we-ibmar-egi-warmaksad islidikidga gunonikoed. We-ibdurgan-abe, morgi milesale, we-mor nega-nue-islidikidgi enuklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Deginbali, san-ukleged, biti-napsa-bategi-dulesa, we-napsa-bate mamarilegoed. Ar esgoro-gordikid-bormogi-dulesardi, we-bormo diigi nue enuklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","” ’We-san Bab-Dummadga-uklenaid unnila dule-irwa-Bab-Dummadse-gormalad-e-gwenadgan-machergan gunmaloed. We-ibmar bur-ise-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ar isgued-ular ibdurgan-uklenaid-abe Bab-Dummad-dulemarbo-ambikued-negse, neg-islidikidse isgued-osulogega-selesgusadi, e-sandi gullegosulid. Bela we-san soogi ogumaklegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-gwensak dule-baidgi-nosad-ular Bab-Dummadga-ibmar-uked bur-ise-islidikid gued. Weyobi, ega igar megoed: ");
INSERT INTO cuk_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Bia ibmar-durgan-ogumakar-ukleged-e-dukar egwallege, agi dule-baidgi-nosad-ular-ibmar-uklenaid-e-dukar egwallemogoed. Geb e-abe ibmar-ogumakar-ukleged-aila-e-dikarmargi bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Geb sorbali, bela ibmar-uklenaid-e-gwallu Bab-Jehováʼga uklegoed: E-bunnugi-gwallumar-nanaid, e-samur-birgi-gwallumar-nanaid, ");
INSERT INTO cuk_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","e-mirwa-gwabogwad, a-birgi e-gwallumar-nanaid, e-dikarmargi-gwallumar-nanaid, degi, bina-dutugwadgi-gwallumar-nanaid. We-bina-dutugwadgi-gwallumar-nanaid mirwa-gwabogwadba welegoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","” ’Geb sorbali, dule-irwa-Bab-Dummadse-goled bela wemar ibmar-ogumakar-ukleged-ailagi ogumakar Bab-Jehováʼga ukoed. We-ibmala, isgued-ular ogumakar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","We-ibmar bela dule-irwa-Bab-Dummadse-gormalad-e-gwenadgan-machergan nabir gunmaloed. We-ibmar nega-islidikidgi gunmaloed. We, ibmar-bur-ise-islidikidid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Isgued-ular-ibmar-uklegedga, degi, dule-baidgi-nosad-ular-ibmar-uklegedga, unnila igar-soggwenna megoed. Dule-baidgi-nosad-ular ibmar-uklenaidi, dule-irwa-Babse-goled-ibmar-imaknaidgadga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","We-ibdurgan-uklenaid-e-uka dule-irwa-Babse-goled-ibmar-imaknaidgadga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Amba deyobbali, madubur soogi-yoaled, madubur bormogi-dualed, degi, madubur bormogi-dibyaled, dule-irwa-Babse-goled-ibmar-imaknaidgadga gubaloed. ");
INSERT INTO cuk_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Bela ibmar-gwag-Bab-Dummadga-ukleged, olivo-gwalluba-omukualeddibe, dinnagwaddibe, Aarón, e-masmalamala, na emarbi-mergu sumaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-gwenatigwar-guega ibmar-ukleged-e-igar weyob megoed: ");
INSERT INTO cuk_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Dule Bab-Jehováʼga dog-nuedye-sogega ibmar-uknaile, we-ibmar-uknaid-ukine, madu-olo-e-inasuli-olivo-gwalluba-omukualed, madu-matargana-e-inasuli-olivo-gwallugi magaled, degi, madubur-bur-nuedgi-madu-ologana-dibyar olivo-gwalluba-omukualed ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Bab-Jehováʼga-dog-nuedye-sogega ibmar-uklenaidmala, degi, gwenatigwar-guega ibmar-uklenaidmala, madu-ologana e-inaba-imakar Bab-Jehováʼga uklebaloed. ");
INSERT INTO cuk_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Bab-Jehováʼga ukegala, bela we-ibmarmar-uklegedi, sog-soggwen sulegoed. Geb gwenatigwar-guega dule-irwa-Babse-goled ibmar-e-abe bomi-bomi-imaksadga we-ibmarmar guoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","” ’Bab-Jehováʼga-dog-nuedye-sogega we-san uklesadi, a-ibagi gullegoed, banedgala bipisaar san sabolegosulid. ");
INSERT INTO cuk_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","” ’Ar Bab-Jehováʼga-ibmar-ogumakar-uklenaidi, dule ibmar-imakedseye sogsagusad-ular uklenadibe, igi Bab-Jehováʼga na ibmar-ukbiedba uklenadibe, adi, a-ibagi a-san gullegoed. Ar san-obichardi, sunna bangi gullebaloed. ");
INSERT INTO cuk_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ar ibapaagi, we-san amba bukwale, bela soogi ogumaklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","” ’Ar dule ibapaagi gwenatigwar-guega ibmar-ukleged-e-san guchale, we-ibmar-uklesadi, Bab-Jehová bar abingaosulid, bar ega igarga guosulid. Ar ade, we-san swilidiksuli gunonikoed. Dule we-san-guchadi, nue-dummad-isgusye soglegoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","” ’We-sangi ibmar-swilidiksulid warmaksale, we-san bar gullegosulid, soogi ogumaklegoed. San-baiddi, bela dule-san-swilidik-gudimalad sunna gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","” ’Dule-san-swilidiksuli-gudiid, gwenatigwar-guega ibmar-uklenaid-e-san guchale, e-dulemar-abargi onolegoed. Ar we-sande, Bab-Jehováʼgadid. ");
INSERT INTO cuk_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","” ’Deginbali, dule ibmar-isgana-dulegad-ebusale, ibdurgan-e-ibmar-isgana-ebusale, ibmar-ised-isgana-ebusale, geb a-sorbali, gwenatigwar-guega ibmar-uklesad-e-san gunnele, we-dule, e-dulemar-abargi onolegoed. Ar we-sande, Bab-Jehováʼgadid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Israel-dulemarga be soge: ‘Moli-bebe-nikad-machered-e-gwallu, sibad-wawaad-bipigwad-e-gwallu, degi, sibad-ome-e-gwallu, bemar bipisaar gunmalosulid. ");
INSERT INTO cuk_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Ibdurgan-sapurbalid-ursirmarse ibmar-burgwisad-e-gwallu, ese oichimaklesad-e-gwalludibe, mer be gunmalo. A-gwallumardi sunna ibmar-bamaladga be ebumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","” ’Dule Bab-Jehováʼga-ibmar-ogumakar-ukleged-e-gwallu guchale, we-dule, e-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","” ’Deginbali, bia bemar maigumaloe, agi bemar bipisaar nuumar-abe, baid-ibdurgan-abedibe, gunmalosulid. ");
INSERT INTO cuk_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ar doa-dule ibu-abe guchale, we-dule, e-dulemar-abargi onolegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Israel-dulemarga be soge: ‘Dule, gwenatigwar-guega ibmar-ukleged-ukele, we-dule, Bab-Jehová-asabin we-ibmar-ukleged abar sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Deginbali, we-dule, e-sunnad ibmar-ogumakar-uklegoedi, Bab-Jehová-asabin sedbaloed. Ibmar-e-gwallu, degi, e-binasgar sedoed. Geb binasgar Bab-Jehová-asabin bana-bana-imaklear ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Dule-irwa-Bab-Dummadse-goled ibmar-e-gwallu ibmar-ogumakar-ukleged-ailagi ogumakoed. Moli-e-binasgardi Aarónʼga, degi, e-masmalaga uklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Dule-gwenatigwar-guega ibmar-ukleged-e-dua-nuedsikidi, dule-irwa-Babse-goled-ibmar-imaknaidga uklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Dule-irwa-Babse-goled dule-gwenatigwar-guega ibmar-ukleged-e-abe-uknaidi, degi, e-gwallu-uknaidi, we-ibmar-e-dua-nuedsikid suoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Israel-dulemar gwenatigwar-guega ibmar-ukleged-e-binasgar-bana-bana-imakleged, degi, e-dua, dule-irwa-Babse-goled-Aarónʼga, degi, e-masmalaga, ani Bab-Jehová, an uksad. We-igala, degisadegu Israel-dulemarga mai guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Bab-Jehová dule-irwa-ese-goledga, Aarón, degi, e-masmala-nug-imaksad-iba-akale, we-ibmar-Bab-Jehováʼga-ogumakar-uklegedi, Aarónʼga, degi, e-masmalaga ukleged-igar megnonikid. ");
INSERT INTO cuk_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","We-dulemar-nug-imaklesad-ibagi, Bab-Jehová Israel-dulemarga igar-uksad, Aarónʼga, degi, e-masmalaga we-ibmarmar ukmaloye. We-igar, degisadegu Israel-waganga mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Deginbali, Bab-Jehováʼga-ibmar-ogumakar-uklegedsik, Bab-Jehováʼga-ibmar-gwag uklegedsik, isgued-ular ibmar-ogumakar-uklegedsik, weyob igar megisad. Deginbali, dule-baidgi-nosar ibmar-uklegedsik, dule-irwa-Bab-Dummadse-golega nugsalenair ibmar-uklegedsik, degi, gwenatigwar-guega ibmar-uklegedsik, weyob igar megisad. ");
INSERT INTO cuk_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Bab-Jehová Moisésʼga we-igar Sinaí-yalagi uksa gusad. Deunni, Israel-dulemar Sinaí-nega-dulesulidganba gudimargu, Bab-Jehová Moisésʼga ega-ibmar-ukleged-igar uksagusad. ");
INSERT INTO cuk_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Aarón, degi, e-masmala beba be sedo. Dule-irwa-Bab-Dummadse-gormalad-e-mormar, degi, nugsalenaidgi-olivo-gwallu-ebuleged be sedbalo. Deginbali, isgued-ular moli-bebe-nikad-sapingwagwad-oburgwileged be sedo, sibad-wawaad-machered-warbo be sedbalo, degi, garba-bipigwadgi madu-inasulid be sedbalo. ");
INSERT INTO cuk_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Degine, bela Israel-dulemar Bab-Dummad-dulemarbo-ambikued-neg-yawagakgi be oambikuoed.” ");
INSERT INTO cuk_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moisés Bab-Jehová-ega-igar-uksadba ibmar-imaksad. Geb Bab-Dummad-dulemarbo-ambikued-neg-yawagakgi Israel-dulemar-oambikusad. ");
INSERT INTO cuk_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Agi, Moisés Israel-dulemarga sogded: “Bab-Jehová anga igar-uksad, weyob ibmar imakoye.” ");
INSERT INTO cuk_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Geb degine, Moisés, Aarónʼse, degi, Aarón-e-masmalase gochad, ese dagmalagar. Geb diigi amar-ogsad. ");
INSERT INTO cuk_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aarónʼga mor-dummad-suid yosad. Geb mor-dub sadergi ega edichad. Deginbali, mor-dummad-suitigwad ega yosbalid, geb a-birgi, mor-sakwasulid-efodʼye-nugad ega yosbalid, geb efod-molidubgi mor-dummad-suitigwad nue edichad. ");
INSERT INTO cuk_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Geb sorbali, a-birgi mor-binasgargi-nagued ega nasiksad, geb mor-binasgargi-naguedyabali Urim, degi, Tumim ega sisad. ");
INSERT INTO cuk_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Deginbali, e-nonogi mor-gurgin-ebirmakaled ega sisbalid, geb mor-gurgin-ebirmakaled-birgi, e-bebegi or-matargwagwad ega nasiksad. We-or-matargwagwad oyonaid, Aarón, Bab-Jehováʼga-ibmar-imakega nugsalesye. Ar igi Bab-Jehová ega igar-uksagusa, deyobi Moisés ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Sorbali, Moisés, nugsalenaidgi-olivo-gwallu-ebuleged susad. Geb we-olivo-gwallugi Bab-Dummadse-goled-neg-sunna-seleged mage-mage imaksad, degi, bela a-yaba ibmar-bukwad mage-mage imaksabalid. Weyobi, we-ibmarmar unnila Bab-Dummadgarbi ebulegega imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Ibmar-ogumakar-ukleged-aila-birgi, ilagugle (7) olivo-gwallu bomi-bomi imaksad. Ibmar-ogumakar-ukleged-birgi, degi, bela we-ailagi ibmar-ebulemalad-bukwad-birgi, olivo-gwallu eosad, adi, we-ibmarmar unnila Bab-Dummadgarbi ebulegegar. Deginbali, dii-sied-birgi, degi, dii-sied-e-nagmargi olivo-gwallu mage-mage imaksabalid, adi, unnila Bab-Dummadgarbi we-ibmarmar ebulegegarbar. ");
INSERT INTO cuk_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Sorbali, Moisés, dule-irwa-Bab-Dummadse-goledga Aarón-nugsaega, Aarón-nonogi olivo-gwallu eosad. ");
INSERT INTO cuk_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moisés, Aarón-e-masmala-ese-dagega imaksabalid. Geb mor-dummadgan-suitimalad ega yosad, mor-dub sadergi ega edichad. Deginbali, mor-gurgin-ebirmakaled ega sisbalid. Ar igi Bab-Jehová ega igar-uksagusa, deyobi, Moisés ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Geb a-sorbali, Moisés, moli-bebe-nikad-sapingwagwad-isgued-ular-ukleged ega sedadega imaksad. Geb Aarón, degi, e-masmala, moli-bebe-nikad-sapingwagwad-e-nono-birgi e-argan mesismalad. ");
INSERT INTO cuk_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Geb degine, Moisés moli-bebe-nikad-e-dukar egwachad. Geb e-googi moli-abe-wesgua, ibmar-ogumakar-ukleged-ailagi moli-bebeyob-gwigwichidgi, degi, aila-dikarmargi moli-abe mage-mage imaksad, adi, a-aila, swilidik imakegar. Abe-gwabgusaddi ibmar-ogumakar-ukleged-aila-nagagi eosad. Weyobi, ibmar-ogumakar-ukleged-aila swilidik gunonikid, degi, unnila Bab-Dummadgarbi ebulegega gunonikid. ");
INSERT INTO cuk_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Moisés we-moli-bebe-nikad-uklenaid-e-samur-birgi gwallumar-nanaid, e-bina-dutugi gwallumar-nanaid, mirwa-gwabogwad, degi, mirwa-birgi-gwallumar-nanaid bela susad. Geb bela we-ibmarmar ibmar-ogumakar-ukleged-ailagi ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ar Moli-bebe-nikad-sapingwagwad-e-ukadi, e-sandi, degi, e-saadi, bela Israel-dulemar-danar-danar-bukwad-magaba ogumaksad, ar igi Bab-Jehová ega igar-uksagusa, deyobi Moisés ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","A-sorbali, Moisés, sibad-wawaad-machered Bab-Jehováʼga-ogumakar-uklegoed ega sedagega imaksad. Geb Aarón, degi, e-masmala we-sibad-wawaad-machered-e-nono-birgi e-argan mesismalad. ");
INSERT INTO cuk_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Geb degine, Moisés we-sibad-wawaad-machered-e-dukar egwachad, geb sibad-wawaad-abe ibmar-ogumakar-ukleged-aila-dikarmargi bomi-bomi imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","A-sorbali, Moisés sibad-wawaad-machered-e-san goa-goa imaksad. Geb sibad-wawaad-e-nono, e-san-goamaksad, degi, e-gwallu soogi ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","E-samurmar, degi, e-nagmar diigi enuksad. Geb a-sorbali, igi Bab-Jehováʼga-ibmar-soogi-ogumakar-ukleged-yeer-yapanned ogumakledae, deyobi, Moisés we-sibad-wawaad ibmar-ogumakar-ukleged-ailagi ogumaksad, ar igi Bab-Jehová ega igar-uksa gusa. ");
INSERT INTO cuk_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","A-sorbali, Moisés sibad-wawaad-machered-baid ega sedagega imaksad. We-sibad-wawaadi Bab-Jehováʼga-arbaega-nugsalenair ukledaedid. Aarón, degi, e-masmala sibad-wawaad-machered-e-nono-birgi na e-argan mesismalad. ");
INSERT INTO cuk_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","A-sorbali, Moisés sibad-wawaad-e-dukar egwachad. Geb Moisés na e-googi sibad-wawaad-e-abe wesgua, Aarón-e-uaya-duku-argan-nuedsikidgi, abe mage-mage imaksad, degi, e-goo-dummad-argan-nuedsikidgi, degine, e-goo-dummad-nag-nuedsikidgi, abe mage-mage imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Deginbali, Moisés, Aarón-e-masmala-ese-dagega imaksabalid. Moisés e-googi sibad-wawaad-e-abe-wesgua, amar-uaya-duku-argan-nuedsikidgi, abe mage-mage imaksad, degi, amar-goo-dummagan-argan-nuedsikidgi, degine, amar-goo-dummagan-nag-nuedsikidgi, abe mage-mage imaksabalid. Geb sibad-wawaad-e-abe-obichadi ibmar-ogumakar-ukleged-aila-dikarmargi eosad. ");
INSERT INTO cuk_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Geb Moisés sibad-wawaad-machered-e-gwallu, e-bunnu, e-samurgi gwallumar-nanaid, e-bina-dutugwadgi-gwallumar-nanaid susad. Deginbali, mirwa-gwabogwad, e-gwallumarse-bakale, degi, sibad-wawaad-machered-e-dua-nuedsikid susbalid. ");
INSERT INTO cuk_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Moisés, Bab-Jehová-asabin madu-inasulid garbagi-bukwadi susad, degi, madu-olo-inasulid susbalid. Deginbali, madu-olo-olivo-gwalluba-oburaled, degi, madu-matar susbalid. Geb we-madumala, sibad-wawaad-e-gwallu-birgi, degi, sibad-wawaad-e-dua-nuedsikid-birgi urbisad. ");
INSERT INTO cuk_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Geb bela-we-ibmarmar Aarón-e-argangi, degi, e-masmala-argangi urbisad. Geb Aarón, degi, e-masmala, we-ibmarmar Bab-Jehováʼga-ukega, Bab-Jehová-asabin bana-bana imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Moisés, Aarón-annik, degi, e-masmala-annik gannar we-ibmarmar susad. Geb ibmar-ogumakar-ukleged-ailagi, ibmar-Bab-Jehováʼga-uklenaidba-mesa ogumaksad. We-ibmar Bab-Jehováʼga-arbaega nugsalenaidgi-ukleged yeer-yapannedid, Bab-Jehováʼga soogi ogumakar ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Geb degine, Moisés sibad-wawaad-machered-e-binasgar susad. Geb Bab-Jehováʼga-ukega, Bab-Jehová-asabin bana-bana imaksad. We-binasgar Bab-Jehováʼga-arbaega-nugsalenaidgi-ukleged Moisésʼga uklesadid. Ar igi Bab-Jehová ega igar-uksagusa, deyobi, Moisés ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","A-sorbali, Moisés, nugsalenaidgi-olivo-gwallu-ebuleged, degi, ibmar-ogumakar-ukleged-ailagi abe-siid susad, geb Aarónʼgi, degi, e-masmalagi bomi-bomi imaksad. Deginbali, wemar-e-mormargi bomi-bomi imaksabalid. Weyobi, Moisés, Aarón, degi, e-morse-bakale, Bab-Jehováʼga swilidik imaksad. Deginbali, Aarón-masmala, degi, e-morse-bakale, swilidik imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Geb Moisés Aarónʼga, degi, Aarón-e-masmalaga sogded: “Bab-Dummad-dulemarbo-ambikued-neg-yawagak-dogedgi, bemar san dunamar. Agi, Bab-Jehováʼga-arbaega-nugsalenaidgi madu-ukleged-garbagi-siidba be san gunmaloed. Igi Bab-Jehová anga igar-uksagusgu, anga sogsagusa: ‘Aarón, degi, e-masmala we-san gunmaloye.’ ");
INSERT INTO cuk_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Geb san-obichad, madu-obichad, be ogumakmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Ibagugle (7) Bab-Jehováʼga-arbaega-nugsaleged-iba naguoed. We-ibagan-gwinmakedse, bemar Bab-Dummad-dulemarbo-ambikued-neggi bukumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ar igi emi ibmar-imaklesa, deyobi, Bab-Jehová bemar-isgued-ular ibmar-imakoye sogsagusad. ");
INSERT INTO cuk_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Degisoggu, ibagugle (7) mutikidba, degi, ibginedba bemar Bab-Dummad-dulemarbo-ambikued-neg-yawagakgi bukumaloed, ar igi Bab-Jehová-bemarga-sogsagusa, adi, bemar melle burgwemalagar. Ar deyob Bab-Jehová anga sogsad.” ");
INSERT INTO cuk_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aarón, degi, e-masmala, ar igi Bab-Jehová Moisésʼga ibmar-sogsagusa, bela deyobi ibmar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ibabaabakgi (8), Moisés, Aarónʼse, Aarón-e-masmalase, degi, Israel-girmar-dummaganse gochad. ");
INSERT INTO cuk_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Moisés Aarónʼga sogded: “Isgued-ular-oburgwilegega moli-bebe-nikad-sapingwagwad Bab-Jehováʼga be ukoed, deginbali, Bab-Jehováʼga sibad-wawaad-machered ogumakar-ukega be ukbaloed. We-ibdurgan-warbogwad swilidik, gwen-boni-nikasulid, Bab-Jehová-asabin be ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","”A-sorbali, Israel-dulemarga be sunmakoed, amarga be sogoed: ‘Isgued-ular-oburgwilegega sibad-machered be sedamaloye. Deginbali, Bab-Jehováʼga ogumakar-ukega moli-bebe-nikad-sapingwagwad, degi, sibad-wawaad-sapingwagwad be sedamarbaloye. We-ibdurgan-warbogwad birgagwen nikamaloed, degi, swilidik, gwen-boni-nikasulid guoed. ");
INSERT INTO cuk_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Deyobbali, dule-gwenatigwar-guega moli-bebe-nikad-machered, degi, sibad-wawaad-machered be sedamarbaloed. We-ibdurgan Bab-Jehová-asabin ogumakar be ukmaloed. Deginbali, ibmar-gwag-gullemalad olivo-gwalluba-oburar be sedamarbaloed. Ar emi-ibagi, Bab-Jehová bemarse e-gangued oyogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Israel-dulemar, Moisés-ese-ibmar-egichisadi, bela Bab-Dummad-dulemarbo-ambikued-neg-yawagakse sesmalad. Bela Israel-dulemar Bab-Jehováʼga-ibmar-ogumakar-ukleged-ailase nonimalad. Geb Bab-Jehová-asabin gwichi gusmalad. ");
INSERT INTO cuk_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Geb degine, Moisés sogded: “Bab-Jehová bemarga igar uknaid: ‘Weyob, bemar ibmar imakmaloye.’ Ar deyob be imakmalale, Bab-Jehová na e-gangued-yeerdakleged bemarse oyogoed.” ");
INSERT INTO cuk_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Geb a-sorbali, Moisés Aarónʼga sogded: “Ibmar-ogumakar-ukleged-ailase be dage. Agi, be-isgued-ular, Bab-Jehováʼga-ibmar-ukleged be ukdage. Degi, be-ibdurgan-ogumakar-ukleged Bab-Jehováʼga be ukdabali. Bab-Jehová bebo-igar-naboged, degi, Bab-Jehová e-dulamarbo-igar-naboged be imake. Deginbali, Israel-dulemar-e-ibmar-uked Bab-Jehováʼga be ukbali, adi, Bab-Jehová e-dulamarga e-isgued osulogega, ar igi Bab-Jehová na igar-uksa gusa.” ");
INSERT INTO cuk_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Geb degine, Aarón ibmar-ogumakar-ukleged-ailase naded. Geb e-isgued-ular, moli-bebe-nikad-sapingwagwad-uknaid-e-dukar egwachad. ");
INSERT INTO cuk_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Geb e-masmala we-moli-abe ega uksamalad. Aarón abegi na e-goo owardikusgua, ailagi-moli-bebeyob-gwigwichidgi abe mage-mage imaksad. Abe-gwabgusaddi ibmar-ogumakar-ukleged-aila-nagagi eosad. ");
INSERT INTO cuk_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","A-sorbali, moli-oburgwilesad-e-gwallu, e-mirwamar, degi, e-binagi-gwallumar-nanaid, ibmar-ogumakar-ukleged-ailagi ogumaksad. Ar igi Bab-Jehová Moisésʼga igar-uksagusa, deyobi, Aarón ibmar imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Ar moli-e-sandi, degi, e-ukadi Israel-dulemar-danar-danar-bukwad-magaba ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Deginbali, Aarón Bab-Jehováʼga-ibdula-ogumakar-ukleged-e-dukar egwachad. Degine, e-masmala a-abe ega uksad. Geb Aarón ibmar-ogumakar-ukleged-aila-e-dikarmargi abe bomi-bomi imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","A-sorbali, Aarón-masmala e-bab-Aarónʼga moli-bebe-nikad-e-san-goa-goad uksad. Deginbali, e-nono ega uksabalid. Geb Aarón bela we-ibmarmar ibmar-ogumakar-ukleged-ailagi ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Geb moli-samurmar, degi, e-duamar enuksad. Geb san-ogumaklenaidba-mesa ibmar-ogumakar-ukleged-ailagi ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Deginbali, Aarón, Israel-dulemar-e-isgued-osulogega Bab-Jehováʼga ibdurgan uksabalid. Dulemar-isgusad-ular sibad-machered-uklenaid susad, degi, e-dukar-egwachad. Geb degine, dulemar-isgued-ular Bab-Jehováʼga uksad, ar igi iduar e-isgued-ular ibmar imaksagusa, deyobi imaksabalid. ");
INSERT INTO cuk_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ar igi igar-mai, aba Aarón Bab-Jehováʼga ibdurgan ogumakar uksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Degi, ibmar-gwag-gullemalad uksabalid. Geb Aarón, a-ibmar-gwag argan-nukgwen susad, geb wakdar-ibmar-ogumakar-uklegedba-mesa ibmar-ogumakar-ukleged-ailagi ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Geb sorbali, dule-gwenatigwar-guega moli-bebe-nikad-machered-uklenaid-e-dukar egwachad, degi, sibad-wawaad-machered-uklenaid-e-dukar egwachabalid. Aarón-masmala e-bab-Aarónʼga a-abe uksad, geb Aarón ibmar-ogumakar-ukleged-aila-dikarmargi a-abe bomi-bomi imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Deginbali, Aarón-masmala e-bab-Aarónʼga moli-machered-e-gwallu, degi, sibad-wawaad-machered-e-gwallu, e-bunnumar, e-samurgi-gwallumar-nanaid, e-mirwamar, degi, e-binamargi gwallumar-nanaid uksabalid. ");
INSERT INTO cuk_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Geb we-gwallumar moli-machered-e-binasgargi, degi, sibad-wawaad-machered-e-binasgargi urbisad. Geb degine, we-gwallumar ibmar-ogumakar-ukleged-ailagi ogumaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","We-ibdurganmar-e-binasgardi, degi, e-duamar-nuedsikiddi, Aarón Bab-Jehová-asabin bana-bana imaksad. Ar igi Bab-Jehová Moisésʼga sogsagusa, deyobi imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Israel-dulemar-bukwadsik Aarón e-argan oyoded, geb amargi ise-nued-binsaedgi sunmaksad. Dulemar-isgued-ular ibmar-durgan-uksagu, Bab-Jehováʼga ibmar-ogumakar-uksagu, degi, dule-gwenatigwar-guega ibmar-uksagu, Aarón ibmar-ogumakar-ukleged-aila-naba-gwichidgi banguded. ");
INSERT INTO cuk_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Geb sorbali, Moisés, Aarónʼbo, Bab-Dummad-dulemarbo-ambikued-negse dogsamalad. Agi gannar noarmargua, Israel-dulemargi ise-nued-binsaedgi sunmakdemalad. Geb Bab-Jehová na e-gangued-yeerdakleged Israel-dulemarse oyosad. ");
INSERT INTO cuk_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Degidgine, Bab-Jehová soo barmialid. Geb ibmar-ogumakar-ukleged-aila-birgi ibdurgan-gummakega-bukwad, degi, ibdurgan-gwallumar-bukwad bela soose gummaksad. Ar deyob daksamargua, bela Israel-dulemar weligwaledba oimakdemalad. Geb Bab-Jehová-nug-odummogega napase e-wagar dulluu imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aarón-masmala Nadab, degi, Abiú, na egad-egad sianar susmalad. Geb sianargi soo ogasmalad, deginbali, sianargi ina-wawadikid urbismarbalid. Degi-inigwele, Bab-Jehová-ega-igar-uksadba imaksasurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Degisoggu, Bab-Jehová Nadabʼgi, degi, Abiúʼgi soo barmialid. Geb wemala, Bab-Jehová-asabin burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Geb Moisés, Aarónʼga sogded: “Bab-Jehová we, sogsa gusad. Deun sogsagusgu: ‘Dule anse warmakmaladga, an-islidik-gued an ega oyogoed. Bela dulemarga an-gangued-yeerdakleged an oyogoed.’ ” Agine, Aarón bar sunmaksasulid. ");
INSERT INTO cuk_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Geb a-sorbali, Moisés Uziel-masmalase gochad, Misaelʼse, degi, Elzafánʼse. Uzielʼde Aarón-e-gilor gued. Geb Moisés we-masmalaga sogded: “Be dagmar. Bab-Jehováʼse-goled-neggi be-gwenadgan-warbogwad-burgwismaid be onodamar. Israel-dulemar-danar-danar-bukwad-magaba be sedmar.” ");
INSERT INTO cuk_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Geb degine, Misael, Elzafánʼbo e-gwenadgan-burgwismalad-ononadmalad. Geb dule-burgwismalad-e-mor-dummad-yoidgi bipirmakar Israel-dulemar-danar-danar-bukwad-magaba onosmalad. Ar igi Moisés ega igar-uksa, deyob imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Geb degine, Moisés, Aarónʼga, degi, Aarón-masmala-warbogwad Eleazarʼga, degi, Itamarʼga sogded: “Be bukib-itoged-oyomalaga, melle be gwiarsuli-gudii gumalo, degi, melle be-mor be esirmakmarbalo. Degisulile, be burgwemaloed, degine, Bab-Jehová bela-Israel-dulemargi uludbaloed. Ar be-gwenadgan-Israel-dulemardi, Bab-Jehová-soo-odesad-ular, akarsuli bukib-itomaloed. ");
INSERT INTO cuk_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Bab-Dummad-dulemarbo-ambikued-neg-yawagakgi mer be bangumalo, adi, mer be burgwemalagar. Na bemar ebinsao, ar Bab-Jehováʼga-arbaega bemar-nonogi Bab-Jehováʼga-nugsalenaidgi-olivo-gwallu-ebuleged eolesad.” Eleazar, degi, Itamar, Moisés-ega-sogsadba ibmar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Geb degine, Bab-Jehová Aarónʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Be, degi, be-masmala dulemar-anbo-ambikued-negse dogsokarmalale, bemar bipisaale vino, degi, sisa gobosurmalad. Ar degisulile, bemar burgwemaloed. We-igar be-waganga degisadegu-mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Ar bemar nue-mag-dake gumalargebed, igid ibmar-nuedi, igid ibmar-isgana, degi, igid ibmar-swilidikidi, igid ibmar-swilidikidsuli. ");
INSERT INTO cuk_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Deginbali, ani, Bab-Jehová, an bemarga Moisésʼba igar-uksagusad, bemar Israel-dulemar-odurdakoed.” ");
INSERT INTO cuk_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moisés, Aarónʼga, degi, Aarón-masmala-dula-besmalad-Eleazarʼga, degi, Itamarʼga sogded: “Bab-Jehováʼga-ibmar-gwag-gullemalad-e-madubur-uklenaid-gwabgusad be sumala. Geb we-madubur, e-inasuli, ibmar-ogumakar-ukleged-aila-naba be gunmar, ar we-ibmarde bela-bela ibmar-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Neg-islidikidgi be gunmaloed. Ar we-ibmar Bab-Jehováʼga-soogi-ogumakar-uklegedid, bega, degi, be-masmalaga uklesad. Ar weyobi anga igar uklesad. ");
INSERT INTO cuk_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","”Deginbali, be, be-masmala, degi, be-bunamala ibmar-e-binasgar-bana-bana-imaklesad, degi, e-dua-Bab-Jehováʼga-uklesad sunna neg-islidikidgi gunmarbalid. We-ibmarmar Israel-dulemar gwenatigwar-guega Bab-Jehováʼga ibmar-uklegedid. Bab-Jehová sogsad: ‘Bega, degi, be-mimmiganga degisadegu uklegoye.’ ");
INSERT INTO cuk_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Bab-Jehováʼga ibmar-ogumakar-uklenaid-e-gwallu-ogumaklegoedba-mesa, ibmar-dua-uklegoed, degi, binasgar-bana-bana-imaklegoed Bab-Jehováʼga uklegoed. We-ibmarmar bega, degi, be-mimmiganga degisadegu uklegoed, ar igi Bab-Jehová igar-uksa gusa.” ");
INSERT INTO cuk_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Geb degine, Moisés, isgued-ular-sibad-machered-uklenaid egichided. Ar Moisés wisguargu, bato bela gummaksaye, Aarón-masmala-warbogwad Eleazarʼse, degi, Itamarʼse uluded, amarga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","—¿Ar ibiga bemar neg-islidikidgi dule-isgusad-ular-Bab-Jehováʼga-ibmar-uklenaid guchasurmala? Ar we-ibmar nue-islidikid gued. Bab-Jehová dulemar-e-isgued-osulogega bemarga uksanad. Ar we-ibmar-uklegedgi Bab-Jehová dulemar-e-isgued osuloged. ");
INSERT INTO cuk_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ar sibad-machered-e-abe Bab-Dummadse-goled-Neg-Islidikidyaba seledsursoggu, bemar sibad-machered-e-san neg-islidikidgi guchawilubmalanad, ar igi an bemarga igar-uksa gusa. ");
INSERT INTO cuk_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Geb Aarón, Moisés-abin sogded: —Emi, an-masmala Nadab, degi, Abiú, na e-isgued-ular ibmar uksamalanad, degi, Bab-Jehováʼga ibmar-ogumakar uksamarbalinad. Degi-inigwele, we-masmala-ebogwad an surgunonikid. Ar emi, isgued-ular-ibmar-ukleged an guchana, ¿Bab-Jehováʼde nabir an-dakoen be insae? Suli. Nabir an-dakosulinad. ");
INSERT INTO cuk_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moisés, weyob Aarón-e-abin-imaksa-itosgua, yeer itosad. ");
INSERT INTO cuk_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Israel-dulemarga be sogmar: ‘Bela we-napneggi ibdurgan-bukwamalad-abargi, wemar be gunmaloed: ");
INSERT INTO cuk_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ibdurgan-e-goonasi-darbo-mamararmalad, gagan-masar, gannar-mabaliga sabanyagi mas saboged, Wegiid-ibdurganmar be nabir gunnoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","” ’Degi-inigwele, ibdurgan-gagan-masar, gannar-mabaliga sabanyagi mas saboged, amar-abargi goonasi-darbo-mararsurmalad gudidimogad. Amardi be gunnosulid. A-ibdurganmala, wemalad: Moli-yargan-mureged, we-moli gagan-masar, gannar-mabaliga sabanyagi mas saboged, ar e-gonasidi, mararsulid. We-ibdurgan bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Deginbali, nubi, gannar-mabaliga sabanyagi mas saboged, ar e-gonasidi, mararsulid. We-ibdurgan bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Amba deyobi, ugdun, gannar-mabaliga sabanyagi mas saboged, ar e-gonasidi, mararsulid. We-ibdurgan bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Deginbali, sina, goonasi-darbo-marar-nika-inigwele, gannar-mabaliga sabanyagi mas sabosulid. We-ibdurgan bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","” ’We-sanmar be gunnosurmalad, deginbali, a-ibmar-burgwarmalad be ebugosurmarbalid. Bemar we-ibmarmar swilidiksuli dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ibdurgan-dii-yagi-gudidimalad-see-nikamalad, degi, uka-nikamalad, demargineddibe, diwargineddibe, be sunna gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ar ibmar-dummagan, degi, ibmar-senigan-see-nikasurmalad, degi, uka-nikasurmalad, demargineddibe, diwargineddibe, bemar we-ibdurgan swilidiksuli dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","” ’E-san bemar gunnosulid, deginbali, we-ibmar-burgwarmalad bemar ima-dakbaloed, ar ade, bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Bela ibmarmar-diigi-gudidimalad-see-nikasurmalad, degi, uka-nikasurmalad, bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","” ’Bemar we-nuumar ima-dakoed, be gunnosurmalad, ar ade, we-nuumar bemarga swilidiksuli gued: Sulubagi, sulubagi-garmar-bisge-bisge-imaked, uabu, ");
INSERT INTO cuk_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","mula, degi, bela sulubagi-senigan akar-akar-daklemalad, ");
INSERT INTO cuk_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","bela abgokor akar-akar-daklemalad, ");
INSERT INTO cuk_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","nuu-dummad-dukar-suid avestruzʼye-nugad, irmon-senigan, bela dilli-dilli akar-akar-daklemalad, ");
INSERT INTO cuk_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","irmon, diidod, badu-cisneʼye-nugad, ");
INSERT INTO cuk_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","noo-mutikid, gorgi, mula-dummad, ");
INSERT INTO cuk_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","dabgala, bela dabgala-dummagan-akar-akar-daklemalad, sikwi-nugar-suid-abubillaʼye-nugad, degine, uksir. ");
INSERT INTO cuk_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","” ’Bela ibsenigan-gukumalad mali-walabakegwadgi-nanamalad, bemarga ibmar-swilidiksulidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Degi-inigwele, ibsenigan-gukumalad mali-walabakegwadgi-nanamalad, ukinbali, ichomakega e-nag-sorbalid-bur-suigan nikamalad, be sunna gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Bemar we-ibmarmar sunna gunmaloed: Bela ses-dummagan-akar-akar-daklemalad, sesmar, degi, ses-senigan. ");
INSERT INTO cuk_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ar bela ibsenigan-gukumalad-bamalad mali-walabakegwadgi-nanamalad, bemarga ibmar-swilidiksulidga guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Bab-Jehová, Moisésʼga, degi Aarónʼga sogdebalid: “We-ibmarmar-ulale, bemar swilidiksuli gunonikoed. Ar doa-dule we-ibdurgan-burgwarmalad ebusdibe, neg-mutikidse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Ar doa-dule we-ibdurgan-burgwaled ebusale, na e-mor enukoed. We-dule mutikidse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Bela ibdurgan goonasi-mamararsulid, degi, mas gannar-mabaliga sabanyagi mas-sabosulidi, bemar swilidiksuli dako. Bemar we-ibdurgan-ebusale, swilidiksuli be guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Bela ibdurgan-mali-walabake-nikamalad e-goo-nasigi-nanasurmalad, bemarga ibmar-swilidiksulidga guoed. Doa-dule we-ibmar-burgwaled ebusale, neg-mutikidse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Dule we-ibmarmar-burgwaled ebusale, e-mor enukoed. We-dule mutikidse swilidiksuli gudii guoed. We-ibmarmar ibmar-swilidiksuli be dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Napagi ibmar-durgan-garmakdii-abargi, bemar we-ibdurgan swilidiksuli dakoed: Diachugiid-comadrejaʼye-nugad, nusa, ammanoomar-akar-akar-daklemalad, ");
INSERT INTO cuk_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","akwa-nuku, daim, isgin, asbanmar, degi, gwanurgiid-camaleónʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Napagi ibdurgan-garmakdii-abargi, we-ibdurgan bemar swilidiksuli dakoed. Ar doa-dule we-ibmar-burgwaled-ebusale, neg-mutikidse swilidiksuli gudii guoed.” ");
INSERT INTO cuk_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “We-ibdurganmar-burgwaled we-ibmarmargi argwachale: Ibmar-urgogi-sobaledgi, ibmar-ibdurgan-ukagi-sobaledgi, morgi, sagugi, degi, ibmar-arbaedgi-ebulegedgi, argwachale, we-ibmarmar mutikidse swilidiksuli guoed. Ar gannar we-ibmarmar swilidik-guega, diigi enuklegergebed. Geb deyobi gannar swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","”Napsa-bormo-yagi we-ibmarmar-burgwaled argwachale, we-napsa-bormo-yagi bela ibmar-bukwadi ibmar-swilidiksulidga gunonikoed. Degisoggu, we-napsa-bormo mamarilegoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","We-napsa-bormogi-dii-siid ibmar-gullegedgi dedemaksale, we-ibmar-gulleged swilidikidsulidga gunonikoed. Deyobbalid, we-napsa-bormogi-dii-siid gobedgi dedemaksale, we-gobed swilidiksuli gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","”We-ibmar-burgwaled ibmar-bamaladgi argwachale, we-ibmarmar bela ibmar-swilidiksulidga gunonikoed. Madu-yoedgi argwachadibe, soogi argwachadibe, we-ibmarmar swilidiksulidga gunonikoed. Degisoggu, we-madu-yoed mamarilegoed, degi, we-soo obelolegoed. We-ibmarmar swilidiksuli gunonikid. Degisoggu, bemar deyobi, we-ibmar dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","”Degi-inigwele, unnila dian, degi, dii-sailagi bia dii-sulege, amarbi amba ibmar-swilidikidga guoed, gwen isguosulid. Ar dule we-ibmar-burgwaled-ebusaddi, swilidiksuli gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","”Ar we-ibmar-burgwaled ibmar-gwag-diglesokalidgi argwachale, we-ibmar-gwag amba swilidik guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ar ibmar-gwaggi dii eolesardi, geb agi, we-ibmar-burgwaled egi argwachale, adi, we-ibmar-gwag swilidiksuli gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","”Ibdurgan-nabir-gulleged burgwisale, ar doa-dule we-ibmar-burgwaled-ebusale, neg-mutikidse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Dule we-ibmar-burgwisad-e-san guchale, na e-mor enukoed. We-dule mutikidse swilidiksuli gudii guoed. Doa-dule we-ibmar-burgwisad magaba-onosale, na e-mor enukoed. We-dule mutikidse swilidiksuli gudii guoed.” ");
INSERT INTO cuk_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Bab-Jehová, Moisésʼga, degi Aarónʼga sogdebalid: “Bemar napagi-ibdurgan-garmakmalad gunnosulid, ar ade, ibmar-swilidiksurmaladid. ");
INSERT INTO cuk_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","”Ibdurgan-unimakar-nanamalad, e-mali-walabakegwadgi-nanamalad, degi, e-malimar-ichesulidgi-nanamalad, bemar gunnosurmalad, ar ade, swilidiksurmaladid. ");
INSERT INTO cuk_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ibdurgan-unimakar-nanamalad-gunnedba mer be swilidiksuli gumalo, mer be isgumalo, ar we-ibdurganmar swilidiksuli gumalad. ");
INSERT INTO cuk_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","”Ani, an-bemar-Bab-Dummad-Jehová gued. Ar an dule-isligwaledsoggu, bemar gwage-swilidik imakmalo, deyobi, bemar gwage-swilidik gudimalo. Ibdurgan-unimakar-nanamalad-gunnedba, degi, ebugedba, mer be swilidiksuli gumalo. ");
INSERT INTO cuk_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ani an Bab-Jehová gued. Ani an Egipto-yargi bemar-onosad, adi, an be-Bab-Dummadga guegar. Degisoggu, bemar gwage-swilidik imakmala, ar an dule-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","”Ibdurgansik, nuumarsik, bela ibdurgan-dii-yagi-gudidimaladsik, degi, bela ibdurgan-napagi-garmakdidimaladsik, weyob igarmar megisad. ");
INSERT INTO cuk_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Adi, bemar magar-dakega, igid ibmar-isgana-gue, igid ibmar-nuegan-gue. Deginbali, igid-ibdurgan nabir gullege, igid-ibdurgan ise gullebali.” ");
INSERT INTO cuk_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Bab-Jehová, Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Israel-dulemarga be weyob sogo: ‘Ome-wargwen gurgin-nika gunonikile, geb machigwa baknonikile, ibagugle (7) san-swilidiksuli gudii guoed. Ar igi na e-igar-dakdiir gudidae, deyobi gudiguoed. ");
INSERT INTO cuk_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ibabaabakgi (8) machi-bipi-ibe e-abgan-uka-duku siklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ar e-nandi iba-dulagwen-gakambe-gakapaa (33) e-boni-itosad-ulale, san-urukdii guoed. San-urukdiid-e-ibagan-berguedse, geb ibmar-swilidikmalad ebugoed, degi, Bab-Dummad-goled-negse dogoed. ");
INSERT INTO cuk_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","” ’Ar bunolo-baksardi, adi, itoged-ilabo san-swilidiksuli gudii guoed. Ar igi na e-igar-dakdiir gudidae, deyobi gudii guoed. Geb iba-dulapaa-gakanergwa (66) e-boni-itosad-ulale, san-urukdii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","” ’Ome, machigwa-nikusad-ulardibe, bunolo-nikusad-ulardibe, san-urukdiid-e-ibagan-bergunonikile, ome sibad-wawaad-bipigwad Bab-Jehováʼga-ogumakar-ukega sedoed. Degi, e-isgued-ular, wagnuu-gwagwendibe, sapur-nuu-gwagwendibe, Bab-Dummad-dulemarbo-ambikued-neg-yawagakse oburgwilegega sedoed. Agi dule-irwa-Bab-Dummadse-goledga ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Geb dule-irwa-Bab-Dummadse-goled we-ome-e-isgued-eliega Bab-Jehová-asabin a-ibmar ogumakar ukoed. Deyobi, we-ome, e-burba-milesadgi nue-swilidik gunonikoed. ” ’Omega machigwa-uklesdibe, bunolo uklesdibe, weyob ega igar-mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ar ome sibad-wawaad-bipigwad-bakega mani galakuele, sunna wagnuu-gwabodibe, sapur-nuu-gwabodibe, sedoed. Gwagwen ogumakar-uklegega guoed. Baiddi, e-isgued-ular-uklegega guoed. Dule-irwa-Bab-Dummadse-goled we-ome-e-isgued-eliega Bab-Jehováʼga ukoed. Deyobi, ome nue-swilidik gunonikoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Dule-gwensak e-ukagi ukamar-mullu-mullu-bukwale, duuled-siidibe, e-ukagi ibmar-sipuu naidibe, yaa-siid naibe-bunayob-dakledibe, we-dule, dule-irwa-anse-goledse seledoed, Aarónʼsedibe, e-masmalasedibe. ");
INSERT INTO cuk_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Dule-irwa-anse-goled dule-ukagi-yaa-siid dakoed. Yaa-siidgi e-siga sipuu naile, degi, yaa ise-nue-gulluu daklegele, wedi, naibe-buna-yaa gued. Geb dule-irwa-anse-goled uka-daksad-sorbali, sogoed: ‘We-dule, swilidiksurye.’ ");
INSERT INTO cuk_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","”Ar dule-ukagi ibmar-sipu-naid, unnila asginbi-nai daklegele, deginbali, e-siga sipuu daklesurbalile, dule-irwa-anse-goled, ibagugle (7) we-dule dule-baigangi bachikii mesoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Geb ibagugledgine (7), dule-irwa-anse-goled, we-dule-e-uka gannar dakbaloed. Ar amba gannar deyob yaa daklegele, degi, ega bar nasgusulile, dule-irwa-anse-goled, gannar ibagugle (7) we-dule mesbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Geb ibagugle-nasad-sorbali (7), dule-irwa-anse-goled, we-dule-e-uka gannar dakbaloed. Ar yaa bar nasgussulile, degi, aka bur bergumai daklegele, dule-irwa-anse-goled sogoed: ‘We-dule, swilidik guye.’ Ar ade, unnila binsa uka ainisad. Geb degine, dule na e-mor enukoed, geb dule swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","”Uka-oyoapid-sorbali, we-dulega yaa nasgudele, dule-irwa-anse-goledse gannar e-uka oyonabaloed. ");
INSERT INTO cuk_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Dule-irwa-anse-goled we-dule-e-uka dakoed. Ar yaa-siid nasgumai-dakele, we-dule swilidiksurye sogoed, ar we-yaade, naibe-buna-yaa gued.” ");
INSERT INTO cuk_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Dule ukagi yaa siile, dule-irwa-anse-goledse seledoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Dule-irwa-anse-goled dule-e-uka dakoed. Ar uka-engunaid, degi, e-sigamar, sipuu naile, deginbali, e-san-gisigwad magar-daklebalile, ");
INSERT INTO cuk_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","wedi, naibe-buna-yaa bur buledid. Dule-irwa-anse-goled sogoed: ‘We-dule, swilidiksuli guye, nue-boni-nikaye.’ Degisoggu, bar bachikii we-dule-mesosulid, ar ade, bato wismalad, we-dule, swilidiksuli gued. ");
INSERT INTO cuk_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","”Ar dule-irwa-anse-goled dule-uka bela nonose-bakale, nagadukuse-nasgumai dakele, ");
INSERT INTO cuk_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","geb we-dule-e-uka argaoed. Ar dule-irwa-anse-goled, bela binsa-uka-nika dakele, sogoed: ‘We-dule, swilidik guye.’ Ar e-uka bela sipuu naded-ulale, we-dule swilidik gunonikid. ");
INSERT INTO cuk_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ar e-ukagi e-san-gisigwad daklealirdi, adi, soglegoed, we-dule, swilidiksurye. ");
INSERT INTO cuk_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Dule-irwa-anse-goled we-san-gisigwad dakoed, geb sogoed: ‘We-dule, swilidiksurye.’ Ar san-gisigwad, swilidiksulid. We-boni naibe-buna-yaa gued. ");
INSERT INTO cuk_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","”Ar san-gisi-dakleged sipuu daklenadele, dule-naibe-buna-yaa-nikadi dule-irwa-anse-goledse naoed, ");
INSERT INTO cuk_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","adi, ega yaa-siid dakegar. Ar yaa sipuu daklenadele, dule-irwa-anse-goled sogoed: ‘We-dule, swilidikye.’ Deyobi, dule swilidik gunonikoed.” ");
INSERT INTO cuk_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Bab Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Ar dule-gwensak e-ukagi dusi siile, degi, sorba nugunonikile, ");
INSERT INTO cuk_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","geb dusi-sigisadgi ega uka-enguardibe, gutu-gisi-sipusaar naguardibe, dule-irwa-anse-goledse oyonaoed, ");
INSERT INTO cuk_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","adi, ega uka dakegar. Ar dusi-sigisadgi ise-nue-gulluu daklegele, degi, e-siga sipuu nadele, dule-irwa-anse-goled sogoed: ‘We-dule swilidiksurye.’ Ar ade, dusi-sigisadgi naibe-buna-yaa signonikid. ");
INSERT INTO cuk_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ar dule-irwa-anse-goled we-dusi-sigisadgi siga sipuu daksulile, degi, ise-nue-gulluu daksulile, aka bur dulega yaa bergumai-dakele, ibagugle (7) dule-baigangi bachikii we-dule-mesoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ar yaa-siid bela uka-ugakaase nasgudele, dule-irwa-anse-goled sogoed: ‘We-dule, swilidiksurye.’ Ar ade, naibe-buna-yaa nikad. ");
INSERT INTO cuk_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ar yaa-siid bar dungusulile, deginbali, uka-sipu-naid bar nasgusurbalile, aka bur nugumaile, dule-irwa-anse-goled sogoed: ‘We-dule, swilidikye.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Dule-gwensak gummaksale, geb gummakaledgi uka sipuu naguardibe, igi, gisii naguardibe, ");
INSERT INTO cuk_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","dule-irwa-anse-goled we-gummakaled dakoed. Ar gummakaledgi e-siga sipuu naile, degi, yaa ise-nue-gulluu daklegele, wedi gummakaledgi naibe-buna-yaa signonikid. Dule-irwa-anse-goled sogoed: ‘We-dule, swilidiksurye.’ Ar ade, we-dule naibe-buna-yaa nikad. ");
INSERT INTO cuk_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","”Ar dule-irwa-anse-goled gummakaled-daksadgi, dakalile, siga sipuu gussuli, deginbali, yaa ise-nue-gulluu daklesurbali, aka bur bergumai dakele, dule-irwa-anse-goled ibagugle (7) dule-baigangi bachikii we-dule-mesoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Ibagugle-gusale (7), dule-irwa-anse-goled gannar ega uka dakbaloed. Ar yaa-siid bela uka-ugakaase nasgudele, dule-irwa-anse-goled sogoed: ‘We-dule, swilidikidsurye.’ Ar ade, naibe-buna-yaa nikad. ");
INSERT INTO cuk_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ar yaa-siid nasgusulirdi, unnila gummaksad-e-gannar gued. Degisoggu, dule-irwa-anse-goled sogoed: ‘We-dule, swilidikye.’ Ar ade, unnila gummaksad-e-wilub gued.” ");
INSERT INTO cuk_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Machered-wargwengi, igi, omegindibe, e-nonogi yaa sigialile, igi, e-akugi yaa sigialile, ");
INSERT INTO cuk_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","dule-irwa-anse-goled we-yaa dakoed. Ar we-yaa ise-nue-gulluu daklegele, e-sigamar gordik, degi, ichee daklegele, dule-irwa-anse-goled sogoed: ‘We-dule, swilidiksurye.’ Ar wedi nono-yaa, degi, aku-yaa nikad. ");
INSERT INTO cuk_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ar dule-irwa-anse-goled we-yaa-daksadgine, dakele, yaa gulluu daklesuli, deginbali, e-sigamar sichii daklesuli, ibagugle (7) dule-boni-nikad dulemar-baigangi bachikii mesoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ibagugledgine (7), dule-irwa-anse-goled we-dule nue, argaoed. We-yaa-maleged nasgussulile, degine, a-yaagi e-sigamar gordiksulile, degine, yaade dogdar-gulluu daklesulile, ");
INSERT INTO cuk_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","geb agi, e-siga-emiega we-dule-imakoed. Unnila yaa-siidgi e-siga emiosulid. Geb degi, dule-irwa-anse-goled we-dule-yaa-nikad gannar ibagugle (7) dulemar-baigangi bachikii mesoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ibagugledgine (7), dule-irwa-anse-goled gannar nue-argabaloed. We boni-nikad e-ukagi nasgussulile, degine, yaa asginegwale, dule-irwa-anse-goled sogoed: ‘We-dule, swilidikye, boni nikasurye.’ We-dulede na e-mor enukoed, degi, soglegoed, we swilidikye. ");
INSERT INTO cuk_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","”San uruksad-sorba boni-nikad ega nasgudele, ");
INSERT INTO cuk_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","dule-irwa-anse-goled nue-argaoed. Boni-nikad ukagi nasgudele, dule-irwa-anse-goled siga-gordikid bar amiosulid. We-dule boni-nikad, burbar swilidiksulid. ");
INSERT INTO cuk_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ar boni nasgumai daklesulile, degine, siga-sichigana ainialile, we-dule-bonigwaledi nugusad. We-dule, bonigwarsulid. Dule-irwa-anse-goled sogoed: ‘We-dule swilidikye.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Amba deyobbalodo, machered-gwensak, igi, ome-gwensakdibe, na e-ukagi uka sipuu naguardibe, ");
INSERT INTO cuk_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","dule-irwa-anse-goled ega uka argaoed. Dule-ukagi uka-sipu-naid wis sichisaar daklegele, adi, we binsa uka siid. We-dule, swilidik gued.” ");
INSERT INTO cuk_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Ar dule-gwensak-ibe sailagia babatialile, degi, sailagia-sate gunonikile, we-dule, swilidikidye soglegoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ar dule-ibe sailagia-bebegined babatialile, degi, e-bebe swiri gunonikile, we-dule swilidikidye soglegoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ar e-nono-swirigwad-dakasik, igi, e-bebegindibe, yaa gisisaar siile, wedi naibe-buna-yaa siid. ");
INSERT INTO cuk_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Geb degine, dule-irwa-anse-goled ega yaa dakoed. Ar dakalile, we-yaa-dule-nono-swiregedgi-siid gisisaar daklege, ar igi ukagi naibe-buna-yaa-siir dakledae, ");
INSERT INTO cuk_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","deyob daklegele, we-dule, naibe-buna-yaa nikad. Degisoggu, dule-irwa-anse-goled sogoed: ‘We-dule, swilidiksurye.’ Ar ade, dule, e-nonogi yaa siid.” ");
INSERT INTO cuk_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Dule-yaa-maleged-nikadi mor-achirmakaled yooed, gwiosurbalid, degi, e-wagar-negabar-odukuar-nadapi binnasuli gornadapoed: ‘¡An swilidiksuli! ¡An swilidiksuli!’ ");
INSERT INTO cuk_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Dule yaa-maleged-nika-gudiidgine, enik soglegoed: ‘We-dule, swilidiksurye.’ We-dule, swilidiksursoggu, na walagwen mai guoed. Dulemar-danar-danar-bukwad-magaba mai guoed.” ");
INSERT INTO cuk_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Sibad-wawaad-absargi-mor-makaledgine, degi, lino-dubgi-mor-makaledgine, gutu-nai daklealile, ");
INSERT INTO cuk_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","degi, lino-dubgi-mor-sobaledgine, sibad-wawaad-absargi-mor-sobaledgine, ibmar-ukagine, degi, ibmar-ukagi-ibmar-sobaledgine, gutu-nai daklealile, ");
INSERT INTO cuk_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ar we-gutu-naid gwili-absargii-dakledibe, igi, gisisaar-dakledibe, wedi, boni-dummad gued. Degisoggu, dule-irwa-anse-goledse oyogoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","”Dule-irwa-anse-goled we-gutu-naid dakoed. Geb we-ibmar-gutu-naid ibagugle (7) bachikii urboed. ");
INSERT INTO cuk_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Dule-irwa-anse-goled ibagugledgi (7) gannar we-gutu-naid argaoed. Ar we-gutu-naid, morgi, mor-sobaledgi, ibmar-ukagi, degi, ibmar-ukagi-ibmar-sobaledgi nasgusale, wedi, boni-dummad gued. We-ibmarmar bar nuedsulid. ");
INSERT INTO cuk_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Degisoggu, mor, mor-sobaled, ibmar-uka, degi, ibmar-ukagi-ibmar-sobaled, deyob-gutu-nikamalad, bela ogumaklegoed. Ar ade, boni-dummad gued. Ibmarmar bela ogumaklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","”Ar dule-irwa-anse-goled ibmar-nue-arganaidgi, we-gutu-naid, morgi, mor-sobaledgi, ibmar-ukagi, degi, ibmar-ukagi-ibmar-sobaledgi nasgussuli dakele, ");
INSERT INTO cuk_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","dule-irwa-anse-goled sogoed: ‘Ibmar-gutu-nikad enukmarye.’ Geb we-ibmarmar gannar ibagugle (7) bachikii urbebaloed. ");
INSERT INTO cuk_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","”Ibmar-gutu-nikad enuklesad-sorba, dule-irwa-anse-goled gannar ibmar-dakbaloed. Ar dakele, gutu-naid bergussuli, amba gannar nai, gutu nasgussur-inigwele, soglegoed: ‘We, ibmar-nuedsurye, bela ichakwaye.’ Degisoggu, we-ibmar ogumaklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","”Ar dule-irwa-anse-goled ibmar-enuklesad-sorba we-gutu-naid boree-nai dakalile, morgi-gutu-naid, ibmar-ukagi-gutu-naid, degi, mor-sobaledgi-gutu-naid sikoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ar we-gutu-naid gannar morgi-nai, mor-sobaledgi-nai, ibmar-ukagi-nai, degi, ibmar-ukagi-ibmar-sobaledgi-nai daklealile, wedi, gannar boni-dummad nagualid. Ar gutu-naid ogumaklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","”Ar mor, mor-sobaled, ibmar-uka, degi, ibmar-ukagi-ibmar-sobaled enuklesadgine gutu-naid allisale, we-ibmarmar gannar enuklebaloed, geb we-ibmarmar swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Sibad-wawaad-absargi-mor-makaledgi boni-gutu-naidga, lino-dubgi-mor-makaledgi boni-gutu-naidga, mor-makaledgi boni-gutu-naidga, degi, ibmar-ukagi-ibmar-sobaledgi boni-gutu-naidga, weyobi igar megoed. Adi, soglegega, we-ibmar swilidikye, igi, swilidiksurye.” ");
INSERT INTO cuk_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Dule-naibe-buna-yaa-nikusad na e-san-urukega, weyob ega igar-mai guoed: Dule-irwa-anse-goledse we-dule seledoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Geb dule-irwa-anse-goled, we-dule-e-uka-dakega, dulemar-danar-danar-bukwad-magaba nodoed. Ar dule-irwa-anse-goled, naibe-buna-yaa-siid nugusa dakele, ");
INSERT INTO cuk_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","we-dule-e-san-urukega, nuu-dulad-swilidikid-gwabo, urwar-urgo, morgo-ginnid, degi, hisopo-ana, sedagoye sogoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Geb a-sorbali, dule-irwa-anse-goled ibe-dii napsa-noggi-sioed. Geb a-birgi nuu-gwagwen oburgoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Geb degine, nuu-dulad, urwar-urgo, morgo-ginnid, degi, hisopo-ana suoed. Geb we-ibmarmar nuu-duladba-mesa, nuu-oburgwilesad-e-abegi owardikuoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Dule-irwa-anse-goled dule-naibe-buna-yaa-nika-gusadgi ilagugle (7) abe bomi-bomi imakoed. Geb dule-swilidikgusye sogsad-sorbali, dule-irwa-anse-goled nuu-dulad indakoed, adi, nuu e-itolegedba sapurba gukumai guegar. ");
INSERT INTO cuk_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","”Dule-san-uruknaid e-mor enukoed, bela e-sailagia, e-siga swiri-imakoed, degi, diigi nue oboed, adi, swilidik guegar. Geb a-sorbali, dule-nugusad, sunna dulemar-danar-danar-bukwadse dogoed. Degi-inigwele, ibagugle (7) e-dordonegyaba gabosulid. ");
INSERT INTO cuk_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ibagugledgine (7), gannar e-sailagia, e-aku-siga, e-ibya-siga bela swiri imakoed. Na e-mormar enukoed, ise-obar imakbaloed. Deyobi, we-dule swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","”Geb dule-nugusad ibabaabakgine (8) we-ibmarmar-ukleged senonikoed: Sibad-wawaad-ome-senigwad-swilidikid boni-nikasulid, warbo, sibad-wawaad-ome-birgagwen-nikad-swilidikid boni-nikasulid, wargwen, degi, ibmar-gwag-uklegedga madubur-nued nibirambe-gakatar (15) olivo-gwalluba-omukuar sedabaloed, deginbali, olivo-gwallu bute-abala ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","”Dule-irwa-anse-goled dulega-san-uruknaidi, we-dule, degi, e-ibmarmar-ukleged dulemar-anbo-ambikued-neg-yawagakse an-asabin bana-bana imakoed, ar ade, wemar bana-bana-ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Geb sorbali, dule-irwa-anse-goled sibad-wawaad-sapingwagwad-wargwen olivo-gwallu-litro-abalad-mesa suoed, geb a-ibmar-sulesad dule-isgusad-ular Bab-Jehováʼga ukoed. Geb Bab-Jehová-asabin bana-bana imakoed, ar ade, wemar bana-bana ibmar-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Dule-irwa-anse-goled neg-islidikidgi bia isgued-ular ibdurgan-e-dukar-egwallege, degi, bia ibdurgan-ogumakar-ukleged-e-dukar-egwallege, agi sibad-wawaad-bipigwad-e-dukar egwannoed. Ar isgued-ular-ibdurgan-ukleged, degi, na-dukin-isgusad-ular-ibdurgan-ukleged dule-irwa-anse-goledgadga gued, ar ade, we-ibmarmar nue-islidikidid. ");
INSERT INTO cuk_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","”Geb dule-irwa-anse-goled dule-isgusad-ular, ibdurgan-uklenaid-e-abe weoed. Geb dule-san-uruklenaid-e-uaya-nuedsikidgi, e-goo-dummad-nuedsikidgi, degi, e-nag-goo-dummad-nuedsikidgi, a-abe magoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","”Amba deyobi, dule-irwa-anse-goled olivo-gwallu-bute-abalad subaloed. Geb e-argan-nuku-sapiledsikidgi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Geb degine, e-goo-dummad-nagabalid-nuedsikid olivo-gwallu-e-argan-nuku-sapiledsik-siidgi owardikuoed. Geb olivo-gwallu-owardikusad an-asabin ilagugle (7) bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","”Geb dule-irwa-anse-goled e-argan-nukugi olivo-gwallu-ganikid-obichadi, dule-san-uruknaidgi magoed: E-uaya-duku-nuedsikidgi, abe-magaled-birgi magoed, e-argan-goo-dummad-nuedsikidgi, abe-magaled-birgi magbaloed, degi, e-nag-goo-dummad-nuedsikidgi, abe-magaled-birgi magbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Deginbali, olivo-gwallu-ganikid-obichadi, dule-san-uruknaid-e-nonogi eobaloed. Dule-irwa-anse-goled dule-san-uruknaid-e-isgued-elilegegala, an-asabin weyob ibmar imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","”Geb sorbali, dule-irwa-anse-goled dule-san-uruknaid-e-isgued-ular anga ibdurgan ogumakar ukoed. Deyobi, dule-san-swilidiksuli-gudiid, san swilidik gunonikoed. ”Agine, dule-irwa-anse-goled ibdurgan-ogumakar-uklegoed-e-dukar egwannoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Geb we-ibdurgan ibmar-ogumakar-ukleged-ailagi anga ibmar-gwag-uklegedba-mesa ogumaklegoed. Dule-irwa-anse-goled dule-san-uruknaid-e-isgued-elilegegala, weyob ibmar imakoed. Geb we-dule san swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","”Ar dule-san-uruknaid dule-wilegedirdi, sibad-wawaad-warbaagwad-bakega mani satele, adi, sibad-wawaad-sapingwagwad-wargwen e-isgusad-ular ukoed. We-sibad-wawaad-sapingwagwad, dule-e-isgued-elilegegala, bana-bana-imaklegar uklegoed. Deginbali, madubur-bur-nued-nibiratar olivo-gwalluba-omukualed, degi, olivo-gwallu-bute-abala, ibmar-gwag-uklegedyob sedbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Amba deyobi, wagnuu-gwabo, sapur-nuu-gwabodibe, e-mani-nikadba sedbaloed. Nuu-gwagwena, e-isgued-ular ukoed, baiddi, ogumakar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","We-ibmar, ibabaabakgine (8), dule-irwa-anse-goled-asabin sedagoed, adi, san swilidik guegar. Dulemar-anbo-ambikued-neg-yawagakgi an-asabin uknonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Dule-irwa-anse-goled sibad-wawaad-sapingwagwad-isgued-ular-uklenaid, degi, olivo-gwallu-bute-abala suoed. Geb an-asabin bana-bana-ibmar-uklegedyob ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Geb sorbali, sibad-wawaad-sapingwagwad-isgued-ular-uklenaid-e-dukar egwannoed. Dule-irwa-anse-goled, a-abe weoed. Geb dule-san-uruknaid-e-uaya-duku-nuedsikidgi, e-argan-goo-dummad-nuedsikidgi, degi, e-nag-goo-dummad-nuedsikidgi, a-abe magoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","”Geb a-sorbali, dule-irwa-anse-goled olivo-gwallu na e-argan-nuku-sapiledsikidgi eogoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","”Geb e-argan-nuedsikid-e-goo-dummad-nagabalid we-olivo-gwallu-ganikidgi owardikuoed. Geb an-asabin olivo-gwallu ilagugle (7) bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","”Geb dule-irwa-anse-goled e-argan-nukugi olivo-gwallu-ganikid-obichadi, dule-san-uruknaidgi magoed: E-uaya-duku-nuedsikidgi, abe-magaled-birgi magoed, e-argan-goo-dummad-nuedsikidgi, abe-magaled-birgi magbaloed, degi, e-nag-goo-dummad-nuedsikidgi, abe-magaled-birgi magbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","”Dule-irwa-anse-goled e-argangi-olivo-gwallu-ganikid-obichadi dule-san-uruknaid-e-nonogi magoed, adi, deyobi, an we-dule-e-isgued ega elioed. ");
INSERT INTO cuk_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Geb a-sorbali, wagnuu-gwabo, sapur-nuu-gwabodibe, e-mani-nikadba ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nuu-gwagwenad dule-isgued-ular uklegoed. Baiddi, ibmar-gwag-uklegedba-mesa ogumakar uklegoed. Dule-irwa-anse-goled dule-san-uruknaid-e-isgued-elilegega, an-asabin weyob ibmar imakoed.” ");
INSERT INTO cuk_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Dule-naibe-buna-yaa-nikusad san-urukegala, ibmar-baid geg-ukele, weyob ega igar mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“An bemarga Canaán-yar-uknaidse be dogsamalale, agi an bemar-neggi digwar nasikdemalale, ");
INSERT INTO cuk_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","e-neg-ibed dule-irwa-anse-goled-owisonaoed, ega sogoed: ‘An-neg-galugi digwaryob nai an dakye.’ ");
INSERT INTO cuk_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","”Geb degine, dule-irwa-anse-goled neg-argaed-iduale, bela negyaba-ibmar-bukwad oniega imakoed, adi, bela negyaba-ibmar-bukwad melle isguegar. Deyob imaklesale, geb dule-irwa-anse-goled neg-argaega negyaba dogoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","”Ar dule-irwa-anse-goled neg-arganaidgi neg-galugi digwar gordik, igi, gisii nai dakele, deginbali, we-gutu-nanaid yaa-bubukwayob daklebalile, ");
INSERT INTO cuk_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","dule-irwa-anse-goled, a-neggi nodagoed. Geb ibagugle (7) a-neg ediar sioed. ");
INSERT INTO cuk_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Ibagugledgine (7), dule-irwa-anse-goled gannar neg-arganabaloed. Ar galugi-digwar-naid nasgusale, ");
INSERT INTO cuk_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","dule-irwa-anse-goled igar-ukoed, akwamar-digwar-nikad ungemarye. Geb a-akwamar ibmar-isganamar-milegedgi, neggwebur-magaba minamaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Deginbali, igar-ukbaloed, bela negyabali, galugi-napsa-magaled baad-baad imakmarye. Geb napsa-babatisadi ibmar-isgana-milegedgi, neggwebur-magaba minamaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Geb degine, akwamar-onolesad-muchub, akwamar-binigan sioed, geb we-galu-birgi napsa-binid magoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","”Ar galugi akwamar-onosad-sorba, galu-adarisad-sorba, degi, galu-maglesad-sorba, a-neggi gannar digwar nagualile, ");
INSERT INTO cuk_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","dule-irwa-anse-goled we-neg gannar arganaoed. Ar a-neggine, digwar bela nasgusale, we-digwar ibmar-oichogedid. A-ulale, neg swilidiksuli gued. ");
INSERT INTO cuk_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Degisoggu, we-negde earilegoed, bela e-akwamar, e-urgomar, degi, bela we-neg-sobega-ibmar-ebulesmalad ibmar-isgana-milegedgi, neggwebur-magaba milegoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","”Doa-dule, dule-irwa-anse-goled we-neg-edisad-ibagangine, we-negyaba dogsadibe, we-dule neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Dule a-neggi gabisale, mas-guchale, e-mor enukoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","”Ar dule-irwa-anse-goled neg-argaega negyaba-dogsadgi dakalile, neg-maglesad-sorba bar digwar nasgussuli, sogoed: ‘We-neg, swilidik guye.’ Ar ade, digwar bar a-neggi naisulid. ");
INSERT INTO cuk_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","”Dule-irwa-anse-goled neg-urukegala, nuu-gwabo-sedoed, deginbali, urwar-urgo, morgo-ginnid, degi, hisopo-ana sedbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Geb a-sorbali, dule-irwa-anse-goled ibe-dii napsa-noggi-sioed. Geb a-birgi nuu-gwagwen oburgoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Geb a-sorbali, urwar-urgo, hisopo-ana, morgo-ginnid, degi, nuu-dulad nuu-burgwisad-abegi, degi, dii-siidgi owardikuoed. Geb dule-irwa-anse-goled ilagugle (7) abe neggi bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","”Weyobi dule-irwa-anse-goled nuu-abegi, diigi, nuu-duladgi, urwar-urgogi, hisopo-anagi, degi, morgo-ginnidgi neg urukoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Geb degine, nuu-dulad neggwebur-magaba indakoed, adi, e-itolegedba sapurba gukumai guegar. Weyobi, neg urukoed, geb we-neg swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","”Weyobi naibe-buna-yaa-maleged akar-akar-daklemaladga, ");
INSERT INTO cuk_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","morgi-gutu-naguedga, neggi-digwar-naguedga, ");
INSERT INTO cuk_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","uka-enguedga, yaa-sigedga, degi, ukagi-gutu-sipu-naguedga igar mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Adi, bemar dulemar-odurdakega, sana wede ibmar swilidik gue, degi, sana wede ibmar swilidiksuli gue. Deyobi, naibe-buna-yaa-maleged-nikuedga igar mai guoed.” ");
INSERT INTO cuk_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Bab-Jehová Moisésʼga, degi, Aarónʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Israel-dulemarga be sunmakmar, ega be sogmar: ‘Machered-gwensak, e-abgangi boni-nikale, we-dule swilidiksuli gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ar ega duled-bupunmaksadibe, bupunmaksasurdibe, we-dule swilidiksuli guoed. Weyob ibmar swilidiksuli gunonikoed: ");
INSERT INTO cuk_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","We-dule-boni-nikad bia megoe, a-ibmar swilidiksuli gunonikoed. Amba deyobbalid, we-dule ibugi sigoe, bela a-ibmar swilidiksuli gunonibaloed. ");
INSERT INTO cuk_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ar doa-dule, dule-boni-nikad-e-meged-ebusale, e-mor enukoed, degi, obbaloed. Dule-ibmar-ebusad neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ar doa-dule, bia dule-boni-nikad-sigisadgi sigisale, e-mor enukoed, degi, obbaloed. Dule-sigisad neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Amba deyobbalid, ar doa-dule, dule-boni-nikad-ebusale, e-mor enukoed, degi, obbaloed. We-dule neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Ar dule-boni-nikad dule-baidgi wii-agsale, dulegi-wii-aglesad e-mor enukoed, degi, obbaloed. Dulegi-wii-aglesad neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Dule-boni-nikad moli-e-gangi-sigisale, we-moli-e-gan swilidiksuli gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ar doa-dule, dule-boni-nikad-urba-ibmar-sigisad-ebusale, dule-ibmar-ebusad neg-mutikguedse swilidiksuli gudii guoed. Ar dule-we-ibmar-sedoed e-mor enukoed, degi, obbaloed. Geb we-dule neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Ar dule-boni-nikad e-argan-enuksasuli dule-ebusale, we-dule-ebulesad e-mor enukoed, degi, obbaloed. Dule-ebulesad neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ar dule-boni-nikad ibmar-napsagi-sobaled-ebusale, we-ibmar-napsagi-sobaled marilegoed. Ar ibmar-urgogi-sobaled-ebusale, we-ibmar diigi nue enuklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Dule-bonigwaled nugusdibe, san-uruked-igar-imakegala, ibagugle (7) edarboed. E-mor enukoed, diigi nue-oboed, geb deyobi, swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","” ’We-dule-nugusadi, ibabaabakgine (8), wagnuu-gwabo, sapur-nuu-gwabodibe, Bab-Jehováʼga Bab-Dummad-dulemar nugusdibe boo-ambikued-neg-yawagakse sedoed. Agi dule-irwa-Bab-Dummadse-goledga nuumar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Dule-irwa-Bab-Dummadse-goled nuu-gwagwen dule-isgued-ular ukoed, nuu-baiddi ogumakar Bab-Jehováʼga ukoed. Deyobi, dule-irwa-Bab-Dummadse-goled Bab-Jehová-asabin swilidik-imakega dule-bonigwaled-saoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","” ’Machered-gwensak e-san-burba misale, oboed. Geb neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ar ibi-morgindibe, ibi-ibmar-ukagindibe, dule-burba milesale, we-ibmar diigi nue enuklegoed. Geb neg-mutikguedse swilidiksuli guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Dule-gwensak omebo-gabisadgi, e-san-burba misale, ebobela nue obmaloed. Geb neg-mutikguedse swilidiksuli gudii gumaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Bab-Jehová, Moisésʼga, degi, Aarónʼga sogdebalid: “Israel-dulemarga be sunmakmar, ega be sogmar: ‘Ome-gwensak na e-igar-dakdiile, ibagugle (7) swilidiksuli gudii guoed. Ar doa-dule we-ome ebusale, we-dule mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Ar we-ome ibugi megoe, bela we-ibmar swilidiksuli gunonikoed. Ar we-ome na igar-dakdiid-ibagangi ibugi sigbalodibe, amba deyobi, a-ibmar swilidiksuli gunonibaloed. ");
INSERT INTO cuk_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ar doa-dule we-ome-gabed-ebusale, we-dule e-mor enukoed, degi, nue obbaloed. Geb neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ar doa-dule we-ome-ibmar-birgi-sigisad ebusale, e-mor enukoed, degi, nue obbaloed. Geb neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ar doa-dule we-ome-gabisad-birgi-ibmar-bukwad-ebusdibe, we-ome-gangi-sigisad-birgi-ibmar-bukwad-ebusdibe, we-dule neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ar machered-gwensak we-omebo-gabisale, ibagugle (7) swilidiksuli gunonikoed. Deginbali, we-machered bia gaboe, bela a-ibmar swilidiksuli gunonimogoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Ome-gwensak na e-igar-daked-e-ibagan-sogedba e-igar-dakdiid ega bergusulile, igidibe, e-igar-dakdiid-e-ibagan ega suitii nadele, we-ome weyob-gudiid-berguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","We-ome na e-igar-dakdiid-ibagangi ibigi gaboe, we-ibmar ome-igar-dakdiid-berguedse swilidiksuli gunonikoed. Deginbali, we-ome ibugi sigoe, bela we-ibmar ome-igar-dakdiid-berguedse swilidiksuli gunonibaloed. ");
INSERT INTO cuk_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ar doa-dule we-ibmarmar-ebusale, swilidiksuli gunonikoed. E-mor enukoed, degi, nue obbaloed. Geb neg-mutikguedse swilidiksuli gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","” ’Ome na-e-igar-dakdiid-bergunonikile, san-uruked-igar-imakegala, ibagugle (7) edarboed. Geb a-sorbali, swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","We-ome ibabaabakgine (8), wagnuu-gwabo, sapur-nuu-gwabodibe, Bab-Jehováʼga Bab-Dummad-dulemarbo-ambikued-neg-yawagakse sedoed. Agi dule-irwa-Bab-Dummadse-goledga nuumar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Dule-irwa-Bab-Dummadse-goled we-nuu-gwagwen dule-isgued-ular ukoed, nuu-baiddi Bab-Jehováʼga ogumakar ukoed. Deyobi, dule-irwa-Bab-Dummadse-goled, Bab-Jehová-asabin ome-igar-dakdiid swilidik-imakega saoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Bab-Jehová, Moisésʼga, degi, Aarónʼga, sogdebalid: “Deyobi, bemar, Israel-dule-swilidiksurmalad e-dulemargi bachikii imakmaloed. Adi, anse-goled-neg bemar-abargi-siid-oichosmalad-ulale, mer wemar burgwemalagar.” ");
INSERT INTO cuk_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Deyobi, machered-e-abgangi-boni-nikadga, degi, machergan-san-burba-mimaladga igar mai guoed. Ar ade, weyob-gued-ulale, swilidiksuli gunonidamalad. ");
INSERT INTO cuk_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Deyobi, ome-igar-dakdiidga, machered-e-burba-misadga, degi, machered-ome-igar-dakdiidse-gochadga, igar mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aarón-masmala-warbogwad-burgwismalad-sorbali, Bab-Jehová, Moisésʼga sunmaksad. Ar we-masmala Bab-Jehováʼga-ibmar-ogumakar-ukleged-ailase yogasaar-warmaksadba burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Bab-Jehová, Moisésʼga sogded: “Be-ia-Aarónʼga be soge: ‘Bab-Dummadse-goled-neggi mor-dummad-naid-daksik, Neg-Ise-Islidikidse wachi-yogasaar mer be dogo. Deginbali, Bab-Dummad-Ulu-birgi-eduged-maid-asabin mer be yogasaar dogbalo, adi, mer be burgwegar. Ar ade, ulu-eduged-birgi mogir-imbaba, Bab-Jehová magarononidaed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Bab-Jehová, Moisésʼga sogdebalid: “Anse-goled-Neg-Ise-Islidikidse Aarón dogsokalile, e-isgued-ular moli-bebe-nikad-sapingwagwad anga sedoed, deginbali, sibad-wawaad-machered ogumakar-ukega anga sedbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Aarón nue obsad-sorbali, we-mor-nue-islidikmalad yooed: Lino-mor-islidikid, lino-garson-bipi-urbalid, lino-morgo-dub-sadergi-nagued, deginbali, lino-mor-gurgin-ebirmakaled sibaloed. Wemarde mor nue-islidikmaladid. ");
INSERT INTO cuk_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","”Aarón, Israel-dulemar-e-isgued-ular, sibad-machered-warbo anga ukoed, deginbali, ogumakar-ukega sibad-wawaad-machered-wargwen anga ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","”Aarón, e-isgued-ular moli-bebe-nikad-sapingwagwad sedagoed. Geb e-isgued-eliega, degi, e-gwenadgan-e-isgued-eliega, we-moli-sapingwagwad anga ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Geb sorbali, Aarón sibad-machered-warbogwad suoed, geb dulemar-anbo-ambikued-neg-yawagakgi anga ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Geb degine, Aarón we-sibadmar wilub-dakoed, adi, dakega, igid Bab-Jehováʼgad guoe, igid Azazelʼgad guoe. ");
INSERT INTO cuk_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Sibad-machered Bab-Jehováʼgadga-gunonikid, isgued-ular oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ar sibad-machered Azazelʼgadga-gunonikiddi, isgued-eliegala, an-asabin dula uklegoed. Geb a-sorbali, we-sibad Azazelʼga nega-dulesulidganba barmidoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","”Aarón e-isgued-ular, moli-bebe-nikad-sapingwagwad sedagoed. Geb e-isgued-eliega, degi, e-gwenadgan-e-isgued-eliega, we-moli-sapingwagwad anga ukoed. Geb Aarón, e-isgued-ular, we-moli-sapingwagwad-e-dukar egwannoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Geb a-sorbali, Aarón an-asabin ibmar-ogumakar-ukleged-ailagi-soo-gasiid sianar-ena weoed. Deginbali, ina-wawadikid-nagaled-yeer-yapanned argan-nukbo subaloed. Geb Aarón, we-ibmarmar atued-dummad-naid-daksik sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Geb agine, an-asabin soo-yagi ina-wawadikid eogoed, adi, a-waa-bupurmakdoedi Dulemar-Anbo-Igar-Mesisad-Ulu-edugedgi daasa sigoed. Deyob imakoed, adi, Aarón melle burgwegar. ");
INSERT INTO cuk_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","”Geb a-sorbali, Aarón, moli-bebe-nikad-sapingwagwad-e-abegi, e-goo owardikuoed. Geb Ulu-Eduged-dad-nakwedsikidgi, a-abe bomi-bomi imakoed. E-googi abe-naid ilagugle (7) ulu-asabin bomi-bomi imakoed.” ");
INSERT INTO cuk_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Bab-Jehová, Moisésʼga sogdebalid: “Aarón, Israel-dulemar-isgued-eliegala, sibad-machered-e-dukar-egwannoed. A-abe, atued-dummad-naid-daksik sedoed. A-abede, igi moli-bebe-nikad-sapingwagwad-e-abe imaksa, deyobi imakbaloed: A-abe, Dulemar-Anbo-Igar-Mesisad-Ulu-eduged-birgi, degi, Ulu-asabin, bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Deyobi, Aarón, anse-goled-neg bela ibmar-isganagi, angi yolesmaladgi, degi, Israel-dulemar-e-isgusmaladgi urukoed. Amba deyobi dulemar-anbo-ambikued-neg, dulemar-isgusmalad-abargi-siid, imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","”Aarón Neg-Ise-Islidikidyaba isgued-ular ibmar-uknaidgine, degi, gannar nodagedse, dule-wargwensaale dulemar-anbo-ambikued-neggi gudiguosulid. Aarón, e-isgued-ular, e-gwenadgan-isgued-ular, degi, Israel-dulemar-isgued-ular, ibmar-uksale, ");
INSERT INTO cuk_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","An-asabin ibmar-ogumakar-ukleged-aila-gwichid-urukega nodagoed. Moli-bebe-nikad-sapingwagwad-e-abe, degi, sibad-machered-e-abe weoed. Geb ibmar-ogumakar-ukleged-aila-dikarba moli-bebeyob-gwigwismaladgi magoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Aarón e-googi-abe-naid ibmar-ogumakar-ukleged-ailagi ilagugle (7) bomi-bomi imakoed. Aarón Israel-dulemar-isgusad-ulale, deyobi, ibmar-ogumakar-ukleged-aila urukoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","”Aarón Neg-Ise-Islidikid, dulemar-anbo-ambikued-neg, degi, ibmar-ogumakar-ukleged-aila swilidik-imaksad-sorbali, sibad-machered-dulad anga sedagoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aarón sibad-machered-dulad-nono-birgi e-arganmar mesoed. Geb degine, bela Israel-dulemar-ibmar-isgana-imaksamalad, angi-bela-yolesmalad, degi, bela e-isgusmalad barsogoed. Deyobi, we-sibad-macheredgi Israel-dulemar-e-isgusmalad naguoed. Geb dule-ega-igar-uklesadi, we-sibad, nega-dulesulidganba sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Dule, we-sibad-machered nega-dulesulidgangi indakoed. Geb we-sibad bela Israel-dulemar-e-isgusad nega-dulesulidganba sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","”Geb a-sorbali, Aarón dulemar-anbo-ambikued-negse dognonikoed. Agine, Neg-Ise-Islidikidse-dogega lino-mor-yosadi esugoed. Geb agi a-mormar urboed. ");
INSERT INTO cuk_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Geb Aarón e-neg-obed-islidikidgi oboed. Agine, gannar e-mor-binsaled yooed. Geb a-sorbali, nodagoed. Geb e-isgued-ular, degi, Israel-dulemar-e-isgued-ular ibmar ogumakar ukoed. Deyobi, e-isgued-eliega, degi, Israel-dulemar-e-isgued-eliega, ibmar ogumakar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Deginbali, isgued-ular ibdurgan-uklenaid-e-gwallu ibmar-ogumakar-ukleged-ailagi ogumakbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","”Dule, nega-dulesulidganba Azazelʼse sibad-machered berbeapid, e-mor enukoed, degi, obbaloed. Geb weyob-imaksad-sorbali, nabir Israel-dulemar-danar-danar-bukwadse gannar nonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","”Moli-bebe-nikad-sapingwagwad, degi, sibad-machered-isgued-ular-oburgwilesad, isgued-eliega amar-abe Neg-Ise-Islidikidse selesgusad. We-ibdurganmar, Israel-dulemar-danar-danar-bukwad-magaba seledoed. We-ibdurganmar-e-ukadi, e-sanmardi, degi, e-saamardi, soogi ogumaklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","”Dule-we-ibmarmar-ogumakoedi, e-mor enukoed, degi, obbaloed. Geb weyob-imaksad-sorbali, nabir Israel-dulemar-danar-danar-bukwadse gannar nonikoed.” ");
INSERT INTO cuk_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga, degi, Israel-dulesurmaladga, weyobi degisadegu igar mai guoed: Nii-walagugled-ibambegi bemar mas-gunsuli gudii guoed. Deginbali, bemar bipisaale arbaosurbalid. ");
INSERT INTO cuk_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ar a-ibagi, an-asabin bemar-isgued elilegoed, degi, bemar bela we-isgumaladgi swilidik gunonimaloed. ");
INSERT INTO cuk_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","A-iba, bemarga obunnoged-iba guoed, agi bemar mas-gunsuli gudii guoed. We-igar, degisadegu-mai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","”Dule, e-bab-sorba-gan-suega dule-irwa-anse-goled-bur-dummadga-nugsalesad ega-bela-gangued-uklesadi, isgued-ular ibmar-uked imakoed. We-dule, lino-mor-nue-islidikid yooed. ");
INSERT INTO cuk_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","We-dule, Neg-Ise-Islidikid, dulemar-anbo-ambikued-neg, degi, ibmar-ogumakar-ukleged-aila, swilidik imakoed. Deginbali, dule-irwa-anse-gormalad-e-isgued-ular, degi, bela Israel-dulemar-e-isgued-ular anga ibmar-ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","”Bemarga weyob degisadegu we-igar mai guoed: Israel-dulemar-e-isgued-eliegala, bemar birgagi irgwen we-igar imakdii gumaloed.” Ar igi Bab-Jehová ega sogsa, deyob Moisés bela imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Bab-Jehová, Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Aarónʼga, degi, e-masmalaga, degine, bela Israel-dulemarga be soge: ‘Bab-Jehová weyob bemarga igar-uked: ");
INSERT INTO cuk_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","” ’Ar Israel-dule-gwensak moli-bebe-nikad, sibad-wawaaddibe, sibaddibe, Bab-Jehováʼga ukbigualile, ");
INSERT INTO cuk_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Bab-Jehová-dulemarbo-ambikued-neg-yawagakgi oburgwergebed. Ar dule, danar-danar-bukwadgi ibdurgan-oburgwisale, igi danar-danar-bukwad-magaba oburgwisale, we-dule, dummad-nosad. A-ulale, we-dule, Israel-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","We-igar weyob-maid, adi, Israel-dulemar neg-swiregedgi-ibdurgan-oburgwedamaladi Bab-Jehováʼga sedmalagar. Dule-irwa-Bab-Dummadse-goledse Bab-Jehová-dulemarbo-ambikued-neg-yawagakse sedmaloed. Geb agi dule-irwa-Bab-Dummadse-goled Israel-dulemar gwenatigwar-guega we-ibdurgan Bab-Jehováʼga ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Geb a-sorbali, dule-irwa-Bab-Dummadse-goled, Bab-Dummad-dulemarbo-ambikued-neg-dogedgi ibmar-ogumakar-ukleged-aila-gwichidgi, we-ibdurgan-e-abe bomi-bomi imakoed. Geb Bab-Jehová-yeer-yapanne-itogega, ibdurgan-e-gwallu ega ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Bemar niamarga bar ibmar ogumakar ukosurmalad. Bemar a-niamar-nug odummodii gusmalad, eba isgudii gusmalad. Degisoggu, be-waganga weyob degisadegu igar-mai guoed.’ ");
INSERT INTO cuk_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","”Dulemarga be sogbaloed: ‘Ar Israel-dule-gwensakdibe, Israel-dulesulid-bemar-abargi-gudiiddibe, ibmar ogumakar-uknaile, igi, ibmar-baid uknadibe, ");
INSERT INTO cuk_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","we-ibmar Bab-Dummad-dulemarbo-ambikued-neg-yawagakse Bab-Jehováʼga-ukega sedergebed. We-ibmar sessulile, we-dule Israel-dulemar-abargi onolegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Bab-Jehová sogdebalid: “Israel-dulemarga be sogbaloed: ‘Ar Israel-dule-gwensakdibe, Israel-dulesulid-bemar-abargi-gudiiddibe, san-abebi guchale, we-dulegi an sabsur-gwisguoed, degi, we-dule e-dulemar-abargi an onogoed. ");
INSERT INTO cuk_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ar ade, bela ibdurgan-dula-gued, degi, dule-dula-gued abegi danikid. Ani an ibdurgan-e-abe bemarga uksad, adi, bemar ibmar-ogumakar-ukleged-ailagi a-abe bemar-isgued-ular anga ukegar. Ar ade, abegi dule-isgued elileged.’ ");
INSERT INTO cuk_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","”Degisoggu, Israel-dulemarga an soged: ‘Bemar bipisaale san abebi gunnosurmalad, deginbali, Israel-dulesulid bipisaale san abebi gunnosurmogad.’ ");
INSERT INTO cuk_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","”Ar Israel-dule-gwensakdibe, Israel-dulesulid-bemar-abargi-gudiiddibe, ibmar-durgan-nabir-gulleged-maksale, nuudibe, a-abe eogoed, geb a-abegi ukub mioed. ");
INSERT INTO cuk_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ar ade, abegi bela ibdurgan-dula-gued danikid. A-ulale, an bemarga sogsad: ‘Bemar bipisaale san abebi gunmalosurye, ar ade, abegi bela ibdurgan-dula-gued danikid. Ar doa-dule san abebi guchale, we-dule e-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","” ’Bela Israel-dulemardibe, Israel-dulesuliddibe, ibdurgan-achu-sapurse-burgwisad guchale, igi ibdurgan-san-ichimaklesad guchale, e-mor enukoed, degi, nue obbaloed. Geb we-dule neg-mutikguedse swilidiksuli gudii guoed. Geb a-sorbali, swilidik gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ar e-mor enuksulirdi, degi, obsurbalirdi, e-isgued na dukin sedii guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Bab-Jehová Moisésʼga igar uksad: ");
INSERT INTO cuk_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Weyob be Israel-dulemarga sogo: ‘Ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","” ’Bemar Egipto-dulemar-damaladyob, melle be damalo. A-yargi bemar bukwagusmalad. ” ’Bemar Canaán-dulemar-damaladyob, melle be damalo. A-yarse an bemar-sedsokalid. Deginbali, e-damaladba, melle be nanamarbalo. ");
INSERT INTO cuk_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","An-bemarga-igar-uksadba be ibmar imakmalo, degi, an-Igar-Mamaidba be nanamalo. Ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Degisoggu, an-Igarmar-Mamaidba, an-bemarga-igar-uksamaladba be nanamalo. Ar doa-dule we-igar-mamaidba ibmar-imakele, dula-gudii guoed. Ani an Bab-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Bab-Jehová Moisésʼga sogdebalid: “Dule-wargwensaale e-gwenadbo negsichigi galagwensuli nanadii guosulid. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Melle be-nanbo negsichigi galagwensuli be nanadii guo. Ar degiile, be-babgi be dododii itole. Melle be deyob nanao, ar be-nan gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Melle be-bab-omebo negsichigi galagwensuli be nanadii guo. Ar degiile, be-babgi be dododii itole. ");
INSERT INTO cuk_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Melle be-bun-gargwenadbo negsichigi galagwensuli be nanao. Deginbali, melle be-bun-be-babsikidbo, be-bun-be-nansikidbo, negsichigi galagwensuli be nanadii guo. Ar amba we-be-bunmar be-negyagi gwalulesdibe, igi, be-negyagi gwalulessurdibe, mer deyob ebo be nanao. ");
INSERT INTO cuk_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Melle be-waganbo negsichigi galagwensuli be nanadii guo. Ar degiile, na be dukin be-nug oichogoed. ");
INSERT INTO cuk_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Melle be-bab-ome-e-sisgwabo negsichigi galagwensuli be nanadii guo. Ar be-bab-sisgwayob gued. Degisoggu, be-bungi be dododiiyob gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Melle be-ammorbo negsichigi galagwensuli be nanadii guo, ar ade, be-bab-e-bun gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Melle be-nan-e-iorbodibe, be-nan-e-urbabodibe negsichigi galagwensuli be nanadii guo, ar ade, be-nan-e-gwenadgan gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Melle be-gilor-e-omebo negsichigi galagwensuli be nanadii guo. Ar be-gilor-ome be-ammorga gunonikid. ");
INSERT INTO cuk_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Melle be-balabo negsichigi galagwensuli be nanadii guo. Ar ade, be-machi-ome gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Melle be-ia-omebodibe, be-urba-omebodibe, negsichigi galagwensuli be nanadii guo. Ar degiile, be-ia-e-nug, be-urba-e-nug be oichogoed. ");
INSERT INTO cuk_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Melle ome-wargwenbo, degi, e-sisgwabo, deginbali, e-waganbo negsichigi galagwensuli be nanadii guo. Ar ade, wemar na gwenadgan gumalad. Ar deyob be gudiile, nue-dummad be isgudiid. ");
INSERT INTO cuk_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Ar amba be-ome-dula-gudiidgine, be-ambe be nikuosulid, deginbali, ebo be negsichigi galagwensuli nanadii guosurbalid. Ar degiile, omegan na ebo e-isdarmaladga gunonimaloed.” ");
INSERT INTO cuk_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Bab-Jehová Moisésʼga sogdebalid: “Ome igar-dakdidibe, melle ese be golo. Ar ade, ome swilidiksuli gudiid. ");
INSERT INTO cuk_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Deginbali, melle dule-baid-e-omebo negsichigi galagwensuli be nanadii guo. Ar degiile, be swilidiksuli guoed. ");
INSERT INTO cuk_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Melle bab-dummad-Molocʼga be-mimmigan be ogumakar uko. Ar deyob be imakele, be-Bab-Dummad-nug be oichogoed. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Omebo-megeyob mer be macherganbo mego. Ar wede ibmar-isgana gued. ");
INSERT INTO cuk_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Bipisaale ibdurganbo galagwensuli be guosulid. Ar wede, ibmar-isgana gued. Ome-wargwensaale ibdurganbo galagwensuli guosulid. Ar wede, ibmar-isgana gued.” ");
INSERT INTO cuk_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“We-ibmar-imakedba mer be swilidiksuli gumalo. Ar an bemar-idu-dulemar-onosokalid, we-ibmar-imakedba swilidiksuli gunonimalad. ");
INSERT INTO cuk_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Deginbali, e-napase-bakale, nue-isgus nagunonimogad. E-ibmar-isgana-imaksad-ulale, an we-dulemar sabsur-odurdaksad, geb e-dulemar e-yar-isgusadgi ononnolesmalad. ");
INSERT INTO cuk_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Degisoggu, an bemarga an-igargan-uksadba, degi, an bemarga an-igargan-sogsadba be ibsamala. Israel-dulemar, degi, Israel-dulesulid-bemar-abargi-mamaid, we-ibmar-isganamar mer be imakmala. ");
INSERT INTO cuk_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ar we-yargi bemar-idu dulemar-ambikusmalad we-ibmar-isganamar imaksamalad. Degisoggu, e-yar nue-isgus nagussunnad. ");
INSERT INTO cuk_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ar bemar we-yar oichosmalale, igi bemar-idu we-yargi dulemar-bukwagusad onilesgusa, deyobi, bemar we-yargi ononnolemogoed. ");
INSERT INTO cuk_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","”Ar doa-dule we-ibmar-isgana imakele, we-dule e-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Degisoggu, an-igar-mamaidba be nanamala. Dulemar we-yargi bemar-idu we-ibmar-isgana-imaksamaladba, mer be nanamala. Mer be we-ibmar-imakedba isgumala. Ani an be-Bab-Dummad-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Bab-Jehová Moisésʼga weyob igar uksad: ");
INSERT INTO cuk_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Bela Israel-dulemar-bukwadga be sunmako, ega be sogo: ‘Bemar gwage-swilidik-gudii gumalo, ar ande be-Bab-Dummad-Jehová gwage-swilidik gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Bemar be-babgi, degi, be-nangi, binsaed-nikaa nanamalo. An-obunnoged-ibagi, be obunnodii nanamalo. Ani an bemar-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Melle bab-dummadsurmalad-e-nug be odummomalo, deginbali, melle ibmar-esgoro-dualedgi-sobaled be-bab-dummadga be imakmalo. Ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","” ’Gwenatigwar-guega be Bab-Jehováʼga ibmar uksokalile, nuedgi ega be ukoed, adi, Bab-Jehová we-ibmar-uklenaid nuedgi abingaegar. ");
INSERT INTO cuk_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Uklesad-ibagi we-ibmar-uklesad be gunnoed, deginbali, sunna banedgine be gunbalid. Ar amba ibapaagi we-ibmar gwabgusale, adi, soogi be ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ar we-ibmar ibapaagi gullegele, we-ibmar isganaga guoed. Bab-Jehová we-ibmar abingaosulid. ");
INSERT INTO cuk_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ar dule-we-ibmar-guchad, na e-isgued dukin-sedii guoed, ar ade, Bab-Jehováʼga-ibmar-swilidikid-uklesad, ibmar-isgana imaknonikid. We-dule, e-dulemar-abargi onolegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Be-nainugi ibmar-gwag be wealile, melle be-nainugi bela ibmar-gwag be weo, deginbali, ibmar-gwag-napagi batisad, melle bar be subalo. Ar we-ibmar-gwag-argwachamalad dule-wileganaga, degi, Israel-dulesulidmarga be obegoed. ");
INSERT INTO cuk_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","” ’Melle be-uva bela ise-wear be imako, deginbali, uva-napagi-argwachamalad, melle bar be subalo. Ar we-uva-argwachamalad dule-wileganaga, degi, Israel-dulesulidmarga be obegoed. Ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Melle ibmar be atursao. Melle be gakansao. Melle na be muchub-muchub yardakmalo. ");
INSERT INTO cuk_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Melle an-nuggi be ise-sogar-sogo: An ibmar imakoye. Ar degiile, be-Bab-Dummad-nug be oichogoed. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Melle be-dulemar be aporsao, deginbali, melle e-ibe be ibmar atursabalo. Dule-bega-arbaed yog be bennukar imako, melle banedse e-ibe be mani gao. ");
INSERT INTO cuk_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Melle dule-uaya-yalliled be ukabsao. Deginbali, melle dule-ibyasulid ibmargi-yolegega be imako. Bur be be-Bab-Dummad-dobee nanadii guo. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Igar-nabolenaile, igar-innikigwadba be imako. Melle dule-wilegedba be nai guo. Deginbali, melle dule-mani-nikadba be nai gubalo. Dulemarga igar-innikigwadba be igar-nabogo. ");
INSERT INTO cuk_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Melle be dulemargi yogasaar sunmako. Melle dule-baid-oburgwedgi be binsao. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Melle be-gwenad be isdar dako. Dule-baid isgusale, ega be bakar ibmar soge, adi, melle e-isgusadba be nagumogagar. ");
INSERT INTO cuk_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Melle be-dulemar be buged-mai imako, deginbali, melle isdar-dakdii be gubalo. Ar igi na be san-sabgue, deyobi dule-baid be sabgumogoed. Ani an Bab-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Bab-Jehová-Igar-Mamaidba be nanadii gumalo. Melle be-moli-bebe-nikadmar ibdurgan-baidbo be onakdii guo. Melle be-nainu-gwensakgine, ibmar-gwag be akar-akar digo. Melle dub-baid-baidgi-oburar-mor-makaled be yoo. ");
INSERT INTO cuk_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","” ’Ar dule-gwensak, ome-maiga-gudiid-sui-nikusokalidbo negsichigi galagwensuli nanasale, ar amba we-ome yoo manigi onolegele, deginbali, amba yoo maiga-gudiidgi ollorgubalile, ebobela sabsur-odurdaklemaloed. Degi-inigwele, oburgwilegosurmalad, ar ade, ome, amba yoo maiga-gudiidgi ollorgued. ");
INSERT INTO cuk_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","We-machered, na e-isgusad-ular, sibad-wawaad-machered Bab-Jehováʼga ukoed. We-sibad-wawaad-machered Bab-Dummad-dulemarbo-ambikued-neg-yawagakse sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Geb dule-irwa-Bab-Dummadse-goled, we-sibad-wawaad-machered isgusad-ular-uklenaidgi, Bab-Jehováʼga sogoed, we-dulega isgued eliye. Weyobi, dulega, e-isgued elilenonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","” ’An-bemarga-yar-uknaidse bemar dogsale, agi bemar sapi-nabir-gullemalad-digsale, gebe we-sapimar-sanmakoed birgapaa be gunnosurmalad, ar ade, we-sapi-e-san bemarga isganaga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Birgabakegwadgine, bela we-sapi-e-san Bab-Jehová-nug-odummogega Bab-Jehováʼga nugsalegoed. ");
INSERT INTO cuk_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Geb birgataledgine, sunna bemar we-sapi-e-san gunmaloed. Deyobi, we-sapi bela-bela bemarga sanmakdoed. Ani an bemar-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Melle san abebi be gunmalo. Melle ibmar-wilubgan-dakedgi yoedse-ibmar-guoed-sogdii be gumalo. Melle nia-igar-dule-oichogedgi arbao. ");
INSERT INTO cuk_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Melle sailagia orokwaa be sikmalo. Deginbali, melle be-siga-e-duku be sikbalo. ");
INSERT INTO cuk_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Dule-burgwisad-ular, melle be-san na be daas-daas imako, deginbali, melle be-sangi ibmar yogasaar narmakar be sobo. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Melle be-sisgwa gambanuchuga be imako, adi, melle be-sisgangi we-igar-isgana dogega. Ar degiile, be-yala bela-bela isgudoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘An-obunnoged-ibagi be obunnomalo, degi, anse-goled-neg melle neg-isganayob be dakmalo, egi be binsaed-nikaa damalo. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","” ’Melle dule-burwarmaladbo-sunmakmarye-sogmaladse be idakmalo. Deginbali, melle burba-isganase-gormaladse be idakmarbalo. Ar deyob be imakmalale, eba be isgumarmogoed. Ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Dador begi danikile, iduale be gwichibin imako. Dadormargi be binsaed-nikaa dao. Be-Bab-Dummad-dobee be nanao. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","” ’Dule-yar-baidsikid bemar-yargi-megnonikile, melle be sabsur-imakmalo. ");
INSERT INTO cuk_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","We-dule-bemar-abargi-maidi, be-negginedyob be dakmalo. Ar bemaryobgusoggu, be nue sabgumalo. Be insamalo, Egipto-yargi, be-yarsulidgi, be deyob gudii gusmarmogad. Ani an bemar Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Igar-nabolenaidgi, igar-maidba inniki be imako: Melle napaneg-wilubsalenaidgi, be galakuar wilubsao. Melle ibmar-oaidikunaidgi, be galakuar oaidikuo. Melle ibmar-mergu-urbilegedgi, be galakuar urbo. ");
INSERT INTO cuk_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ibmar-wilubdaked-nued, nibir-nued, degi, ibmar-wilubsaed-nued be ebumalo. Ani an be-Bab-Dummad-Jehová gued. An Egipto-yargi be-onosadid. ");
INSERT INTO cuk_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","” ’Degisoggu, bela an-igar-mamaidba be ibsamalo. Bela an bemarga igar-uksadba be ibmar imakmalo. A-sogedba be nanadii gumalo. Ani an Bab-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Israel-dulemarga weyob be sogo: ” ‘Ar Israel-dule-gwensakdibe, Israel-dulesulid-bemar-abargi-maiddibe, e-mimmi bab-dummad-Molocʼga ogumakar uksale, we-dule oburgwilegoed. Dulemar, we-dule akwagi-makar oburgoed. ");
INSERT INTO cuk_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","An-sunnad we-dulegi an yolemogoed. An we-dule e-dulemar-abargi obelogoed. Ar bab-dummad-Molocʼga e-mimmi-ogumakar-uksad-ulale, an-nug-islidikid oichosad, degi, anse-goled-neg oichosbalid. ");
INSERT INTO cuk_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ar dulemar, we-dule na-e-mimmi bab-dummad-Molocʼga ogumakar-uksad baisur-dakele, degi, we-dule-oburgwesurmalale, ");
INSERT INTO cuk_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ani an we-dule, degi, e-gwenadgan sabsur-odurdakoed. We-dule, degi, bela dulemar-bab-dummad-Moloc-nug-odummosmaladmala, an e-dulemar-abargi obelogoed. ");
INSERT INTO cuk_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","” ’Dule-wargwen dule-burgwarmaladbo-sunmakmarye-sogmaladse idakele, degi, burba-isganase-gormaladse idakele, deginbali, amarba-nai guarbalile, we-dulegi an gwisguoed. We-dule, e-dulemar-abargi an obelogoed. ");
INSERT INTO cuk_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","” ’Degisoggu, angarbi be gudii gumalo, gwage-swilidik be imakmarsun, ar ade, ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","An-igarmar-mamaidba be ibsamala, degi, eba be ibmar imakmala. Ani an Bab-Jehová, bemar-gwage-swilidik-imakedid. ");
INSERT INTO cuk_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","” ’Ar dule-gwensak e-bab-ukabsasale, e-nan-ukabsasale, we-dule oburgwilegoed, ar ade, e-bab, degi, e-nan-ukabsasad. We-dule, na dukin burgwed amisad. ");
INSERT INTO cuk_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","” ’Ar dule-gwensak dule-baid-omebo negsichigi galagwensuli nanasale, wemar, ebobela oburgwilemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","” ’Ar dule-gwensak e-bab-omebo negsichigi galagwensuli nanasale, e-babgi nue dodosad. A-dule, e-bab-omebo oburgwilegoed. Wemar, na dukin burgwed amismalad. ");
INSERT INTO cuk_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","” ’Ar dule-gwensak e-bala-ebo negsichigi galagwensuli nanasale, wemar, ebobela oburgwilegoed. Nue-dummad isgusmalad. Wemar, na dukin burgwed amismalad. ");
INSERT INTO cuk_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","” ’Ar machered-wargwen machered-baidbo galagwensuli gusale, ebobela oburgwilegoed, ar ade, nue-dummad isgusmalad. Wemar, na dukin burgwed amismalad. ");
INSERT INTO cuk_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","” ’Ar dule-wargwen ome-nikusadgi, e-ome-e-nan-nikunonibalile, we-dule, nue-dummad isgusad. Degisoggu, we-dule, degi, we-omegan-warbogwadmala, ogumakar oburgwilemaloed, adi, bemar-abargi dulemar melle we-ibmar-isgana-imakdii gumalagar. ");
INSERT INTO cuk_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","” ’Ar machered-gwensak ibdurganbo galagwensuli-gusale, we-dule, oburgwilegoed, deginbali, ibdurgan oburgwilemogoed. ");
INSERT INTO cuk_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","” ’Ome-gwensak ibdurganbo galagwensuli-gusale, we-ome, degi, ibdurgan oburgwilegoed. Wemar, na dukin burgwed amismalad. ");
INSERT INTO cuk_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","” ’Ar dule-gwensak e-bun-e-babsikidbodibe, e-nansikidbodibe, negsichigi galagwensuli nanasale, ibmar-isgana imaksad. Degisoggu, e-dulemar-wagab ebobela oburgwilemaloed. E-bun-e-nug dummad-oichosad. We-dule, e-isgusad-ular, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","” ’Ar dule-gwensak ome-e-igar-dakdiidgi ese gochale, degi, ome-igar-dakdiid eyeye sogsamogale, wemar, ebobela e-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","” ’Melle be-ammor-babsikidbodibe, be-nansikidbodibe, negsichigi be galagwensuli nanao. Ar degiile, be-sergan-nug be oichogoed. Wemar, ebobela na e-isgusad-ular, sabsur-odurdaklemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","” ’Ar dule-gwensak e-gilor-omebo negsichigi galagwensuli nanasale, e-gilor-nug oichosad. Wemar, ebobela e-isgued-sedii gumaloed, mimmi-nikussuli burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","” ’Ar dule-gwensak, e-iagindibe, e-urbagindibe ome-egwanele, we-dule nue-dummad isgusad. E-ia-nug, degi, e-urba-nug oichosad. We-dule, e-ambebo mimmigan-nikuosuli gudii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","” ’Degisoggu, an bemarga bela an-igarmar-uksadba, an bemarga bela an-igarmar-sogsadba be ibsamalo. A-sogedba, be ibmar-imakdii gumalo. Adi, an-bemar-odosokalid-yargi an melle bemar-onogegar. ");
INSERT INTO cuk_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","An bemar-sabed-ular, bemar-idu we-yargi-dulemar-bukmalad an onisokalid-e-damaladba, mer be damalo. Ar we-dulemarde, bela we-ibmar-isganamar-imakdii gusmalad. A-ulale, an wemar bela-bela isdar-daknonikid. ");
INSERT INTO cuk_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ar bemargardi an sogdo: We-dulemar-be-idu-bukwad-e-yala bemargadga guoed, an bemarga ukoed, adi, degisadegu bemargadga guegar. A-yargi bela-bela ibmar-gulleged obinebaka nikad. ” ’Ani an be-Bab-Dummad-Jehová gued. Bemar an-dulamarga-guega, ani an dulemar-baigangi bachikii bemar-urbisad. ");
INSERT INTO cuk_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Degisoggu, ibdurgan-swilidikid, ibdurgan-swilidiksulidbo, bemar magar-dake gumalargebed. Deginbali, nuumar-swilidikid, nuumar-swilidiksulidbo, bemar magar-dake gumarbalirgebed. Bemar we-ibdurgan-swilidiksulid-ebuged-ular, nuumar-swilidiksulid-ebuged-ular, ibmar-napagi-garmakdimalad-swilidiksulid-ebuged-ular, melle be swilidiksuli gumalo. Ar ade, we-ibmarmar an bemarga swilidik gusurye sogsa gusad. ");
INSERT INTO cuk_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Bemar anga islidik damalargebed, ar ade, ani an Bab-Jehová islidik gued. Ani an dulemar-baigangi bachikii bemar-urbisad, adi, bemar an-dulamarga guegar. ");
INSERT INTO cuk_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","” ’Machered-gwensakdibe, ome-gwensakdibe, dule-burgwaled-e-burbase idakele, igi, ibmar-wisguega burba-isganase-gordiile, we-dule, akwagi-makar oburgwilegoed. We-dule, na dukin burgwed amisad.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Bab-Jehová, Moisésʼga sogded: “Dule-irwa-Bab-Dummadse-gormalad-Aarón-e-masmalaga be soge: ‘Melle dule-burgwisad ebumalo. Ar degiile, swilidiksuli gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Aarón-masmala, unnila e-gwenad-walikagwad-burgwismaladbi ebugoed: E-nan, e-bab, e-machi, e-bunolo, e-ia, e-urba, ");
INSERT INTO cuk_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","degi, e-bun sui-satedba amba be-walik-gudiid, sunna na ebumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","” ’Dule-yogasaaledyob melle swilidiksuli gumalo, deginbali, mer isgumarbalo. ");
INSERT INTO cuk_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","” ’Dule-irwa-Bab-Dummadse-gormalad nono swire imakmalosulid, e-siga-duku sikmalosulid, deginbali, e-san daas-daas imakosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Wemar, e-Bab-Dummadga gwage-swilidik gudigumaloed, degi, e-Bab-Dummad-nug oichomalosulid. Ar we-dulemar, Bab-Jehováʼga ibmar-ogumakar ukmaladid, degi, e-Bab-Dummad-madu ukmarbalidid. A-ulale, dule-irwa-Bab-Dummadse-gormalad gwage-swilidik gudigumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Dule-irwa-Bab-Dummadse-goled, ome-gambanuchu-imaked nikuosulid, ome-machered-egi-dodosad nikuosulid, deginbali, ome-sui-meted nikuosurbalid, ar ade, dule-irwa-Bab-Dummadse-goled Bab-Dummadga-arbaega nug-imaklesad. ");
INSERT INTO cuk_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","” ’Degisoggu, bemala dule-irwa-Bab-Dummadse-goled swilidik dakoed. Ar we-dulede, be-Bab-Dummadga madu ukedid. Ar we-dule, begala dule-swilidik guoed. Ar ani an-Bab-Jehová dule-swilidikid gued. Ani an dule-swilidikidga bemar-imaked. ");
INSERT INTO cuk_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","” ’Ar dule-irwa-Bab-Dummadse-goled-e-sisgwa gambanuchuga-gudiile, we-bunagwa e-bab-nug oichodiid. Degisoggu, we-bunagwa, ogumakar oburgwilegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Bab-Jehová Moisésʼga sogdebalid: “Dule e-gwenadgan-abargi dule-irwa-Bab-Dummadse-gormalad-e-dummadga sulenonikidi, degi, Bab-Dummadga-arbaega e-nonogi olivo-gwallu eolesadi, degi, dule-irwa-Bab-Dummadse-goled-bur-dummad-e-mor-yoega ega gangued uklesbalid, e-sailagia gwiarsuli gudii guosulid, degi, dule-burgwisad-ular, e-mor esirmakosulid. ");
INSERT INTO cuk_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","We-dule, dule-burgwisad-negse dogosulid. Amba e-babdibe, e-nandibe, burgwisar, a-negse amba dogosurbalid, adi, melle swilidiksuli guegar. ");
INSERT INTO cuk_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","”Bab-Dummad-Neg-Islidikid mer oichogega, Bab-Dummadse-Goled-Neg-Islidikidgi noosulid. Ar ade, e-nonogi ina-wawadikid eolesad, adi, soglegegar: ‘We-dule, Bab-Dummadgarbi-arbaega nug-imaklesye.’ Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","”Dule-irwa-Bab-Dummadse-gormalad-e-dummad, unnila ome-yagwabi nikuoed. ");
INSERT INTO cuk_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ome-ei-sui-burgwisad, degi, ome-sui-meted nikuosulid, deginbali, ome-gambanuchu-imaked nikuosurbalid. Unnila e-dule-bunagwa-yagwad nikuoed, ");
INSERT INTO cuk_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","adi, melle e-dulemar-abargi e-wagan-danikoed-e-nug isguegar. Ani an Bab-Jehová, we-dule-islidik imaked.” ");
INSERT INTO cuk_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Bab-Jehová, Moisésʼga sunmakded, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Aarónʼga sogo: ‘Be-wagan-bonikwagwad bipisaale Bab-Dummadga-madu-ukleged ukosulid, ese warmakosulid. Degisadegu, be-waganga weyob igar maiguoed. ");
INSERT INTO cuk_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Bab-Dummadga-ibmar-ukedse weyob-bonigwamalad bipisaale warmakosulid: Dule-ibya-sated, dule-muya-muya-nanaed, dule-nag-sikaled, dule-sakwa-sikaled, dule-asu-bonikwagwad, dule-uaya-bonikwagwad, ");
INSERT INTO cuk_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","dule-nag-bisgaled, dule-argan-bisgaled, ");
INSERT INTO cuk_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","dule-yargan-mureged, dule-geg-dungumalad, dule-ibya-sibudikid, dule-ukagi-yaa-siid, dule-ukagi-boni-nikad, dule-alugwaggi-boni-nikad. ");
INSERT INTO cuk_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","” ’Aarón-e-wagan-bonikwagwad, bipisaale Bab-Jehováʼga-ibmar-ogumakar-ukleged-ukega, Bab-Jehováʼse warmakosulid. Ar bonikwaa-gued-ulale, bipisaale Bab-Dummadga-madu-ukleged-ukega, Bab-Jehováʼse warmakosulid. ");
INSERT INTO cuk_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ar Bab-Dummadga-madu-uklegeddi sunna gunmaloed, deginbali, mas-nued-islidikid, degi, mas-nued-bur-islidikid sunna gunmarbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Degi-inigwele, bonikwaa-gued-ulale, mor-dummad-naid-daksik dogosulid, deginbali, Bab-Dummadga-ibmar-ogumakar-ukleged-ailase warmakosurbalid, adi, anse-goled-neg mer oichogegar. Ani an Bab-Jehová, dule-irwa-anse-gormalad islidik an imaked.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Weyobi, Moisés, Aarónʼga, Aarón-e-masmalaga, degi, bela Israel-dulemarga sunmaksa gusad. ");
INSERT INTO cuk_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Aarónʼga, degi, e-masmalaga be sogo: ‘Israel-dulemar anga ibmar-islidik-uksamaladgi melle dodomalo, adi, bemar mer an-nug-islidikid oichomalagar. Ani an Bab-Jehová gued.’ ");
INSERT INTO cuk_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","”Amarga be sogbalo: ‘Bela be-wagan, degi, be-wagan-sorba-danimarbaloed, nue-swilidiksuli-gudiidgi Israel-dulemar anga ibmar-islidikmalad-uksadse warmakdele, we-dule, an-asabin yog-onolegar guoed. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","” ’Aarón, ar be-wagan-gwensak naibe-buna-yaa nikale, igi, e-abgangi boni-nikale, na san-swilidik-guedse geb sunna Bab-Dummadga-ibmar-islidikmalad-ukleged gunnoed. Aarón, ar be-wagan-gwensak, ibu-ibmar-burgwaled ebusale, dule-na-e-burba-misad ebusale, ");
INSERT INTO cuk_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ibmar-napagi-garmakdimalad ebusale, dule-swilidiksulid ebusale, ibmar-baigan-swilidiksulid ebusale, ");
INSERT INTO cuk_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","a-dule, neg-mutikguedse swilidiksuli gudii guoed. ” ’Ar e-abgan enuksulile, a-dule, Bab-Dummadga-ibmar-islidikmalad-ukleged gunnosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Dad-argwatele, a-dule, swilidik gunonikoed. Geb a-sorba, Bab-Dummadga-ibmar-islidik-ukleged nabir gunnoed, ar ade, we-ibmar e-masgunned gued. ");
INSERT INTO cuk_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Dule-irwa-Bab-Dummadse-gormalad ibdurgan-burgwaled, degi, achu-sapurse ibdurgan-san-ichimaklesad gunnosulid. Ar degiile, dule swilidiksuli gunonikoed. Ani an Bab-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Bab-Jehová, Moisésʼga sogdebalid: “Degisoggu, dule-irwa-Babse-gormalad an-igar-uknaidba ibsamalo. An-igar-uknaidba ibsasulid-ulale, melle isgumalo, adi, wemar melle burgwemalagar. Ani an Bab-Jehová, wemar angarbi-arbaega an nug-imaksad. ");
INSERT INTO cuk_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","”Dule-irwa-Babse-goled-e-gargwenadsulid we-ibmar-islidikmalad gunnosulid. Deginbali, dule-e-neggi-maid, degi, dule-ega-arbaed, we-ibmar-islidikid gunnosurmarmogad. ");
INSERT INTO cuk_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","”Ar dule-irwa-Babse-goled manigi mai-wargwen-baksale, a-duledi, sunna we-ibmar-islidikmalad gunnoed. Deginbali, dule-irwa-Bab-Dummadse-goled-neggi mai-gwalulesmalad amba sunna we-ibmar-islidikid gunmarmogoed. ");
INSERT INTO cuk_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","”Dule-irwa-Babse-goled-e-sisgwa, dule-irwa-Babse-goledsulidbo-nikusale, we-ome, Bab-Dummadga-we-ibmar-islidikid-ukleged gunnosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ar dule-irwa-Babse-goled-e-sisgwa ei-sui burgwenonidibe, mimmi-nikussuli e-sui-metedibe, na e-bab-negse gannar nonikile, ar igi yoo-sui-nikugu, e-bab-masgunned gundii gusa, deyobi, gannar e-bab-masgunned gundii gubaloed. Ar dule-baigandi, bipisaale we-mas gunnosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","”Ar dule-gwensak wissulidgi ibmar-islidikid guchale, we-dule, we-ibmar-guchad-wilub gannar dule-irwa-Bab-Dummadse-goledga ibmar ukoed. A-ukinbali, ibmar-atargi-gwensak napi ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","”Degisoggu, dule-irwa-Babse-gormalad Israel-dulemar Bab-Jehováʼga-ibmar-islidikidmalad-ukleged-oichogega imakosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ar dule-wargwen, we-ibmar-islidikid-ukleged-guchale, na dukin e-isgued sedii guoed. Ani an Bab-Jehová, wemar angarbi-arbaega an nug-imaksad.” ");
INSERT INTO cuk_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Aarónʼga, degi, e-masmalaga, deginbali, bela Israel-dulemarga be sogo: ‘Ar Israel-dule-wargwendibe, Israel-dulesulid-bemar-abargi-maiddibe, ibmar-imakoye-sogsad-ular, igi, na e-itoleged ibmar-ukbied-ular, Bab-Jehováʼga ibmar ogumakar ukele, ");
INSERT INTO cuk_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","we-ibmar, Bab-Jehová-nabir-abingaegala, ibmar-durgan-machered-swilidikid, boni-nikasulid ukoed. Sunna moli-bebe-nikad-machered, sibad-wawaad-machereddibe, sibad-machereddibe, ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","” ’Ibdurgan-wis-boni-nikad bipisaale Bab-Jehováʼga be ukosulid, ar ade, Bab-Jehová we-ibmar bei abingaosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","” ’Amba deyobbardo, ar dule-gwensak ibmar-imakoye-sogsad-ular, igi, na e-itoleged-ibmar-ukbied-ular, gwenatigwar-guega, Bab-Jehováʼga moli-bebe-nikad, sibad-wawaaddibe, sibaddibe, ukele, we-ibdurgan-swilidikid, boni-nikasulid ukoed, adi, nabir Bab-Jehová we-ibmar-uknaid abingaegar. ");
INSERT INTO cuk_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Bab-Jehováʼga ibdurgan-aku-atakmalad, muya-muya-nanamalad, nag-sikarmalad, yaa-nikamalad, uka-sensenmalad, uka-muru-murumalad, be ukosulid. ” ’Deginbali, we-ibmarmar ibmar-ogumakar-ukleged-ailagi, Bab-Jehováʼga be ogumakar ukbalosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Sunna be-itoleged ibmar-ukbiedba anga be moli-bebe-nikad, igi, sibad-wawaad-wis-bonigwaled uked. Ar ibmar-imakoye-sogsad-ular, ibdurgan-degiid be ukerdi, Bab-Jehová bei abingaosulid. ");
INSERT INTO cuk_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Bab-Jehováʼga ibdurgan alugwag-bonigwaled, alugwag-madareged, alugwag-gwasualed, degi, alugwag-sikaled be ukosulid. Be-yalagi ibdurgan-degimalad Bab-Jehováʼga be ukosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","” ’Deginbali, ibdurgan-degimalad be-Bab-Jehováʼga-ukega, Israel-dulesulid-abin be abingabalosulid, ar ade, we-ibdurganmar bonigwaledid. Degisoggu, be-ibe abingalegosulid.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Moli-bebe-nikad-e-mimmi gwalulesdibe, sibad-wawaad-e-mimmi-gwalulesdibe, igi sibad-e-mimmi-gwalulesdibe, na e-nan-walik ibagugle (7) gudii guoed. Geb ibabaabakgine (8) sunna bemar anga we-ibdurgan ogumakar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","”Melle iba-galagwena moli-bebe-nikad-ome, e-mimmi-ebo, igi, sibad-wawaad-ome, e-mimmi-ebo e-ibe be e-dukar egwanno. ");
INSERT INTO cuk_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","”Be anga dog-nuedye-sogega, ibmar uknaile, nue igar-maidba-imakar be ukoed. Adi, an nabir abingaegar. ");
INSERT INTO cuk_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","We-ibmar-be-anga-uknaid, a-ibagi be gunnoed. Banedga, we-ibmar be sabogosulid. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","”An-igarmar-mamaidba be ibsamala, eba be ibmar-imakdii gumala. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","”An-nug-islidikidgi melle be dodomalo, adi, Israel-dulemar-abargi an-nug islidik guegar. Ani an Bab-Jehová bemar islidik imaked. ");
INSERT INTO cuk_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ani an Egipto-yargi bemar-onosad, adi, an bemar-Bab-Dummadga gumalagar. Ani an Bab-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Israel-dulemarga be weyob sogo: ‘Bab-Jehová we-itoakwaa-ibamar-onoleged mesisad. Bemar Bab-Jehová-nug-odummogega, a-ibamar islidikid-onmakedye bimaloed. Bab-Jehová we-ibamar omesisad.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be weyob sogo: ‘Bemar ibanergwa (6) arbamaloed. Ar ibagugledgindi (7), bemar obunnomaloed. A-iba, an-nug-odummogega itoakwaa-iba-onoleged-iba gued. A-ibagi, bemar bipisaale arbaosurmalad. A-ibagi, bemar na bia maimalodibe, Bab-Jehová-nug-odummogega bemar obunnogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be weyob sogo: ‘Bab-Jehová we-itoakwaa-ibamar-onoleged mesisad. Bemar Bab-Jehová-nug-odummogega we-itoakwaa-ibamar-onolegedgi islidikidgi onmaknonimaloed. An bemarga iba-mesnaid-sekalaagi, bemar na onmaknonimaloed: ");
INSERT INTO cuk_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","” ’Gebe-nii-onodoed-ibambe-gakabakegi (14), a-sedogidba, bemar Bab-Jehová-nug-odummogega Egipto-yargi bemar Oburgwilegoenad-Iba onomaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be weyob sogo: ‘A-nii-ibambe-gakatargi (15), Bab-Jehová-nug-odummogega Madu-E-Inasulid-Iba onodoed. Madu-e-inasulid ibagugle (7) be gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Gebe-iba-onodoedgine, bemar islidikidgi danar ambikumaloed. A-ibagi, bipisaale bemar arbaosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ibagugle (7) bane-bane, bemar Bab-Jehováʼga ibmar ogumakar ukmaloed. Geb ibagugledgi (7), bemar Bab-Jehová-e-nug-odummogega islidikidgi danar ambikunonimaloed. A-ibagi, bemar bipisaale arbaosurmalad.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Israel-dulemarga be sogo: ‘Yar-an-bemarga-uknaidse bemar dogsamalale, agi bemar ibmar-gwag-digaled wearmalale, bemar gebe-ibmar-gwag-wesad-dukgwen, dule-irwa-Bab-Dummadse-goledse sedoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Dule-irwa-Bab-Dummadse-goled Bab-Jehová-asabin we-ibmar-gwag bana-bana imakoed, adi, Bab-Jehová we-ibmar-gwag abingaegar. Obunnoged-iba-banedgine, we-ibmar-gwag Bab-Jehováʼga bana-bana imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","We-ibmar-gwag-dukgwenad Bab-Jehováʼga be uknaid-ibagi, sibad-wawaad-sapingwagwad-birgagwen-nikad, swilidikid, boni-gwen-nikasulid, Bab-Jehováʼga be ogumakar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Deginbali, madubur-bur-nued nibirbake olivo-gwalluba-omukuar, be ukbaloed. We-ibmar-ogumakar-ukleged Bab-Jehová yeer-yapanne itodaed. Degine, vino bute-gwagwen eba eolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Be-Bab-Dummadga-inse be we-ibmar-gwag uksasulile, bemar madu gunnosulid. Bemar ibmar-gwag-dibyaled, igi, ibmar-gwag-biniddibe, gunnosurmarbalid. Bia be mai-guoe, bega, degi, be-waganga, we-igar degisadegu mai guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Obunnoged-banedgine, orosgi-dakleged-trigoʼye-nugad-dukgwen Bab-Jehováʼga be bana-bana-uksad-sorbali, itoged-ilagugle (7) be ebisoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Obunnoged-ilagugled (7), geb a-banedgine, bela iba-dulabo-gakambe (50) guoed. Geb degine, Bab-Jehováʼga ibmar-gwag-binidi bemar ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Be-neggine, madu-gwabo madubur-nuedgi-e-inaba-sobaled, Bab-Jehováʼga bana-bana-ukega be sedoed. We-madu-gwagwen madubur-nibirbake-imakaled, baid amba deyob imakarbalid. We-madumar Bab-Jehováʼga gebe-ibmar-sanmaked-uklegedid. ");
INSERT INTO cuk_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Maduba-mesa sibad-wawaad-sapingwagwad-birgagwen-nikad, swilidik, boni-nikasulid, walagugle (7) be ukoed. Deginbali, moli-bebe-nikad-sapingwagwad-wargwen, degi, sibad-wawaad-machered walabo be ukbaloed. Wemala, Bab-Jehováʼga ogumakar be ukoed. Degine, ibmar-gwag eba be ukbaloed, degine, vino-egi-eolemalad be ukbaloed. Wemarde, Bab-Jehováʼga soogi ogumakar-uklegedid, Bab-Jehová yeer-yapanne itodaed. ");
INSERT INTO cuk_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","” ’A-ukinbali, isgued-ular sibad-machered-wargwen be ukbaloed, degi, gwenatigwar-guega sibad-wawaad-sapingwagwad-birgagwen-nikad, warbo be ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Dule-irwa-Bab-Dummadse-goled, sibad-wawaad-sapingwagwad-warbogwad madu-gebe-uklegedba-mesa Bab-Jehová-asabin bana-bana imakoed. We-ibmarmala, Bab-Jehová-asabin ibmar-ukleged-bana-bana guedid. Wemar, Bab-Jehováʼga ibmar-islidik-uklegedid, dule-irwa-Bab-Dummadse-goledga uklegoedid. ");
INSERT INTO cuk_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","” ’A-ibagi, bela bemar Bab-Jehová-nug-odummogega islidiki danar ambikunonimaloed. A-ibagi, bemar bipisaale arbaosurmalad. Be-wagan bia maimardibe, we-igar degisadegu ega maigu guoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","” ’Ibmar-gwag-weed-ibagan mosale, melle bela be-nainu-dikar-nagase be weo. Deginbali, ibmar-gwag napase batisale, melle a-ibmar-gwag be bar suo. Ar ade, wemala dulemar-wileganaga, degi, Israel-dulesurmaladga be obegoed. Ani an be-Bab-Dummad-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Israel-dulemarga be sunmake, ega be soge: ‘Nii-walagugled-gebe-iba-onodedgi, bemar obunnogoed. A-ibagi, gar-trompeta-ogolale, bemar iba onogoed. Deginbali, bemar Bab-Jehová-nug-odummogega danar ambikunonimarbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","A-ibagi, bemar bipisaale arbaosurmalad. Agine, bemar, Bab-Jehováʼga ibmar ogumakar ukoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Israel-dulemarga be sunmake, ega be soge: ‘Nii-walagugled-ibambegi Isgued-Elied-Iba guoed. A-ibagi, bemar Bab-Jehová-nug-odummogega, islidik danar ambikunonikoed. A-ibagi, bemar mas-gunsuli gudigumaloed, deginbali, bemar Bab-Jehováʼga ibmar ogumakar ukmarbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","A-ibaginbali, bemar bipisaale arbaosurmalad, ar ade, a-iba, Isgued-Elileged-Ibad, agine, be-Bab-Dummad-Jehová bemarga isgued elioed. ");
INSERT INTO cuk_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ar dule-wargwen a-ibagi mas-guchale, we-dule, e-dulemar-abargi onolegoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Ar dule-wargwen a-ibagi arbasale, we-dule, e-dulemar-abargi an obelogoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","” ’Degisoggu, a-ibagi, bemar bipisaale arbaosurmalad. Be-wagan bia maimardibe, we-igar degisadegu ega maigu guoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","A-iba, bemarga obunnogoed-iba guoed. A-ibagine, bemar mas-gunsuli gudiguoed. We-obunnoged-iba, bemar nii-walagugled-ibabakebak-sedodedgi onodoed. Geb banedgi, sedogidse bergudapoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Israel-dulemarga be sogo: ‘Nii-walagugled-ibambe-gakaatargine, Neg-Matargana-Sobaled-E-Iba Bab-Jehová-e-nug-odummogega be onodoed. We-iba, ibagugle (7) onolenai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Gebe-iba-onodedgine, bemar Bab-Jehová-e-nug-odummogega islidiki danar ambikunonimaloed. A-ibagi, bemar bipisaale arbaosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Bemar ibagugle (7) Bab-Jehováʼga ibmar-ogumakar-uknai guoed. Ibabaabakadgine (8), bemar Bab-Jehová-e-nug-odummogega islidiki danar ambikunonimaloed. Agine, amba bemar Bab-Jehováʼga ibmar ogumakar ukbaloed. A-iba, iba-dummadid. Degisoggu, bemar a-ibagi, bipisaale arbaosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","” ’We-ibamala Bab-Jehováʼga iba-itoakwaa-onolemaladid. A-ibagi, Bab-Jehová-e-nug-odummogega bemar islidiki danar ambikunonimaloed, adi, Bab-Jehováʼga we-ibmarmar-ogumakar ukegar: Ibdurgan-ogumakar-ukleged, ibmar-gwagmar-ukleged, ibmarmar-ukleged, degi, vino-ukleged. We-ibmarmar e-ibagan-uklegoed-maidba be ukmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","We-ibamala, Bab-Jehová-obunnoged-iba-ukine, Bab-Jehováʼga ibmar-uklegoye-ise-sogar-sogsad-ukine, degi, ibmar-ukbiedba-ukleged-ukine, be onobaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","” ’Nii-walagugled-ibambe-gakatargi, bemar ibmar-gwag-wesmalad-sorbali, Bab-Jehováʼga ibagugle (7) bemar iba onomaloed. Gebe-iba-onodoedgi, degi, ibabaabakgi (8) bemar arbaosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Gebe-iba-onodoedgine, bur sapimar-nuegangi e-sanmar-nuegan-nanaid, ogobgi-dakleged-e-gagan, sapimar-dummagan-e-anagan, degi, sosgamar bemar amimaloed. Ibagugle (7) bemar be-Bab-Dummad-Jehová-asabin wergumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Birga-iliba, nii-walagugledgi (7), ibagugle (7) bemar Bab-Jehová-nug-odummogega iba-onodii gumaloed. We-igar bemar-waganga degisadegu maigu guoed. ");
INSERT INTO cuk_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ibagugle (7) bemar neg-matargan-sobaledgi-mai gumaloed. Bela bemar Israel-dulemar Israel-yargi-gwalulesmalad we-neg-matargan-sobaledgi-mai gumaloed, ");
INSERT INTO cuk_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","adi, be-wagan wisgumalaga, an Egipto-yargi Israel-dulemar-onosgu, ani an neg-matargan-sobaledgi-megega bemar-imaksaye. Ani an bemar-Bab-Dummad-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Weyobi, Moisés, Israel-dulemarga Bab-Jehováʼga-ibamar-itoakwaa-onolegedgi sunmaksad. ");
INSERT INTO cuk_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Bab-Jehová, Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Israel-dulemarga be soge: ‘Olivo-gwallu-bur-swilidikid ibmarba-oburarsulid, be sedamalo. Adi, Bab-Dummadse-goled-neggi gwallu ogaegar. Deyobi, a-gwallumar degisadegu gasii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aarón Bab-Dummad-dulemarbo-ambikued-neggi gwallumar ogaoed, bia Bab-Dummad-Israel-dulemarbo-Igar-Mesisad-Ulu-siid-iduar, mor-dummad-naid magaba ogaoed. Adi, we-gwallumar Bab-Jehová-asabin gasii oibodagegar. We-igar, be-waganga degisadegu maigu guoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Gwallu-sied-olobiid-birgi gwallumar-bukwad degisadegu Bab-Jehová-asabin gasii guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Madubur-nuedgi madu-ologana gwaambe-gakabo (12) be soboed. Madu-gwagwengi madubur nibirbo be ebugoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Bab-Jehová-asabin mese-olobiid-birgi, ilebo be madu-ologana urboed. Ilegwengi gwanergwa (6) be urboed, baid ilegwengi deyob mergu be urbebaloed. ");
INSERT INTO cuk_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Deginbali, ina-wawadikid-ibmar-baidba-oburarsulid madu-ilegwen-ilegwen-bukwad-dikarba be urbebaloed. We-ina-wawadikid madu-anar ebinsalegega-ibmar-uklegedyob gued. We-ina-wawadikid Bab-Jehováʼga ogumakar uklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Obunnoged-iba-iliba, Israel-dulemar-nukine, we-madu Bab-Jehová-asabin be urbedii guoed. Israel-dulemar weyob degisadegu we-igar imakdioed. ");
INSERT INTO cuk_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","We-madu Aarónʼgadga, degi, e-masmalagadga degisadegu guoed, neg-islidikidgi gunmaloed. Ar ade, we-ibmar bur bule Bab-Jehováʼga ibmar-ogumakar-ukleged-baiganba, islidikid gued. Weyob we-igar degisadegu maigu guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","A-ibagangine, Israel-dulemar-abargi dule-gwensak maigusad. E-nande Israel-duled, e-babdi Egipto-duled. Ibagwengine, we-dulede Israel-dule-wargwen-ebo danar-danar-bukwadgi uluar gusad. ");
INSERT INTO cuk_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Agine, ome-Israelʼgined-e-machi galagwensuli sunmakdegu Bab-Dummad-nug obarisad. Degisoggu, we-dule, Moisésʼse sesagusmalad. ");
INSERT INTO cuk_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Geb Bab-Jehová Israel-dulemarga we-dule-imaklegoed-sogedse, esgaryagi we-dule-metemargweled. We-dule-e-nande Selomitʼye nugad, Dibri-sisgwad. Dibriʼdi Dan-wagwad. ");
INSERT INTO cuk_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Geb degine, Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“We-dule-galagwensuli-sunmaksad bemar-danar-danar-bukwad-magaba be onomalo. Bela dule-itosmalad we-dule-nono-birgi e-argan mesoed. Geb bela Israel-dulemar akwagi we-dule-makoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israel-dulemarga weyob be sogoed: ‘Ar doa-dule e-Bab-Dummadgi galagwensuli-sunmaksale, e-isgusad egi aibinoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ar doa-dule e-gwenad-ukabsanaidgi Bab-Jehová-nug bisale, we-dule oburgwilegoed. Bela Israel-dulemar akwagi we-dule-makoed. Ar Israel-duledibe, Israel-dulesurdibe, Bab-Jehováʼgi-galagwensuli-sunmaksale, we-dule oburgwilegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Bab-Jehová, Moisésʼga sogdebalid: “Ar doa-dule, dule-baid-oburgwisale, we-dule oburgwilemogoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ar doa-dule, dule-baid-ibe ibdurgan-oburgwisale, we-dule ibdurgan-oburgwisad-anar ibdurgan-baid ega ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ar doa-dule, dule-baid-naibi-imaksale, we-dule, deyob naibi-imaklemogoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ar doa-dule, dule-baid-ibe gar-bichisale, we-dule-ibe gar bisgelemogoed. Ar doa-dule, dule-baid-ibe ibya-naibisasale, we-dule-ibe ibya naibisalemogoed. Ar doa-dule, dule-ibe nugar-bichisale, we-dule-ibe nugar bisgelemogoed. Ar doa-dule, igi-dule-baid-naibisaoe, we-dule deyob naibisalemogoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ar doa-dule, dule-baid-ibe ibdurgan-oburgwisale, we-dule-ibe ibdurgan-oburgwisad-anar ibdurgan-baid ega ukoed. Ar doa-dule, dule-baid-oburgwisardi, we-dule deyob oburgwilemogoed. ");
INSERT INTO cuk_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Israel-dulega, degi, Israel-dulesulidga unnila igar-soggwenna maigu guoed. Ani an bemar-Bab-Dummad-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moisés Israel-dulemarga bela we-ibmar sogsa gusad. Geb Israel-dulemar, dule-galagwensuli-Bab-Jehováʼgi-sunmaksad danar-danar-bukwamalad-magaba onosmalad. Geb agi, akwagi-makar oburgwismalad. Ar igi Bab-Jehová, Moisésʼga sogsa gusa, deyobi, Israel-dulemar ibmar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Bab-Jehová, Moisésʼga Sinaí-yargi sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Israel-dulemarga be sogo: ‘Bab-Jehová bemarga-yar-uknaidse be ambikudapmalale, Bab-Jehová-nug-odummogega a-yargi birgagwen nainu obunnonai guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","” ’Birganergwa (6) bemar be-nainumargi ibmar digmaloed. Birganergwa (6) be-uva-dub be nue sike-sike imakmaloed, degi, e-san be weemarbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Birgagugledgindina (7), Bab-Jehová-nug-odummogega, bar be nainugi arbaosurmalad. A-birgagine, be-nainugi be ibmar-digosulid, deginbali, be-uva-dub be sike-sike imakosurbalid. ");
INSERT INTO cuk_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Be-nainugi wargwengi ibmar-gwag-ainidagoedi be bela weosulid, deginbali, uva be digsasulid wargwengi-sanmakdagoedi be bela weosurbalid. Birgagwen nainugi be arbaosulid. ");
INSERT INTO cuk_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Degi-inigwele, a-birgagi nainugi bela ibmar-sanmakoedi bemarga unniguar gunnega guoed. Be-mai-machered, be-mai-ome, dule-bega-arbaed, degi, Israel-dulesulid-be-yargi-gudiid sunna gunmarmogoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Deginbali, be-molimar-bebe-nikad, degi, ibdurganmar be-yargi-nikamalad we-ibmarmar-sanmakoedi, sunna gunmarmogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Birgagugled, ilagugle (7) be ebisoed. A sogleged, birga-durbo-gakabakebakye (49). ");
INSERT INTO cuk_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Geb a-birga-nasadgine, nii-walagugled-ibambegi, isgued-osuloged-ibagi binnasuli gar-trompeta bela be-yalagi be ogoloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Weyobi, birga-durbo-gakambegidi (50), Bab-Jehováʼga birga-islidikidga be imakoed. A-birgagi, bela Israel-yargi Israel-dulemar maiga-gudiile, ollorgunonikoed. A-birga, bemarga Gannar-Ibmar-Ukleged-Birgaga guoed. Degine, bemar na gannar e-nainu-e-nainu sumaloed, gannar na e-gwenadganse namaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Birga-dulabo-gakambegid (50) bemarga Gannar-Ibmar-Ukleged-Birgaga guoed. A-birgagi, bemar nainugi ibmar-digosurmalad, nainugi ibmar-ainioed be weosurmarbalid, degine, uva be weosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ar ade, a-birga, Gannar-Ibmar-Ukleged-Birgad. A-birgade bemarga birga-islidikidid. A-birgagi unnila ibmar-e-itolegedba-ainied-sanmakoedi be gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","” ’Gannar-Ibmar-Ukleged-Birgagi bela bemar na gannar e-nainu-e-nainuse namaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","” ’Dule-baidga be nainu manigi-uksadibe, dule-baidse be nainu-baksadibe, melle bemar be-gwenadgan mesagwar imako. ");
INSERT INTO cuk_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Igi birga Gannar-Ibmar-Ukleged-Birga-napi, a-birga-napiwilub be dule-baidse nainu bakoed. Dule-nainu-ukoeddi, Gannar-Ibmar-Ukleged-Birga-napiwilub nainu gargegu ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","” ’Gannar-Ibmar-Ukleged-Birga amba undar napile, mani-dummad nainu be ukoed. Gannar-Ibmar-Ukleged-Birga ichee napile, adi, nainu mani-bipii be ukoed, ar ade, ibmar-welegoedba, we-nainu gargegu be ukoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","” ’Melle be dule-baid mesagwar imako. Bur be-Bab-Dummad be dobee nanadii gumalo, ar ade, ani an bemar-Bab-Dummad-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Bab-Jehová-e-igar-bemarga-uksadba be nanamarsun, Bab-Jehová-Igar-Mamaidba be damarsun. A-sogedba bemar gudii gumarsun. Geb degine, bemar bogidik gudii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Nainu bemarga ibmar-osanmakoed. A-ibmarmar nue-immedik bemar gunmaloed, degine, a-yalagi, nue-bogidik bemar bukwa gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","” ’Ar bemar egisdamalodibe: ¿Ar wede birgagugledgi (7), ibi anmar gunmalosunna? Ar ade, ibmarde anmar digosurmalad, degine, anmar weosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","” ’Birganergwadgine (6) Bab-Jehová bemargi ise-nued binsamaloed. Bab-Jehová birgapaa-wilub nainugi ibmar-osanmakoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Birgabaabakgine (8), be ibmar-digmaloed. A-birgagine, ibmar-gwagmar-sabosmalad bemar gunmaloed. Birgabakebakse (9), ibmar-sabosad be gunmaloed. Geb a-birgagine, ibmar-sanmakded be gutemaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-nainu-baksadi degisadegu egadga guosulid, ar ade, nainu Bab-Jehováʼgadid. Ar bemar unnila sikwas we-yargi gudimalad. Bemar we-yargi degisadegu gudiguosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Degisoggu, bemar-nainu-baksamaladi, be wisgumalargebed, gannar-nainu-obirileged-igar bemarga maigu guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","” ’Be-gwenad mani-sate-gudele, na e-nainu uksale, e-gwenad-bur-walikagwad nainu-uklesad ega onononikoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","” ’Dule ega e-anar nainu-onoged-satele, ar na dukin e-nainu-onogega, unniguar mani amisale, ");
INSERT INTO cuk_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","nainu-uklesad-akar birga ebisoed. Geb Gannar-Ibmar-Ukleged-Birga igi-napi, a-wilub mani bennukoed. Geb degine, we-nainu gannar na egadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ar unniguar mani amissulile, dule ese nainu-baksadi we-nainu Gannar-Ibmar-Ukleged-Birgase gani guoed. Geb agine, we-nainu Gannar-Ibmar-Ukleged-Birgagi gannar e-ibedgadga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","” ’Dule-gwensak neggwebur-sakdigar-siidyaba na e-neg manigi uksale, we-dule, sunna a-neg birgagwengi gannar obiroed. Ega birgagwen naguoed gannar neg-obiregar. ");
INSERT INTO cuk_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Birgagwengi we-neg obiridsulile, neggwebur-sakdigar-siidyaba we-neg-siidi, dule-neg-baksadgadga, degi, e-wagangadga degisadegu guoed. Gannar-Ibmar-Ukleged-Birgagi we-neg e-ibedga bar uklegosulid. ");
INSERT INTO cuk_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","” ’Neggwebur-sakdigarsulidgi negmar-siidi nainuyob guoed. A-negmardi sunna gannar obirilegoed, Gannar-Ibmar-Ukleged-Birgagi a-nega e-ibedga uklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","” ’Levita-dulemardi e-neggweburmargi e-neg-siidi manigi uksale, sunna gannar obire guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Dule-gwensak Levita-dulemar-neggweburgi Levita-dulese neg baksale, we-dule, Gannar-Ibmar-Ukleged-Birgagi gannar ega neg maniginsuli ukoed. Ega gannar obiroed, ar ade, e-neggweburmargi-neg-bukwadi Israel-dulemar-abargi Levitaʼmarga uklesadid. ");
INSERT INTO cuk_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Levita-dulemar-e-gagan-nainumardi bipisaale manigi uklegosulid. Ar ade, we-gagan-nainu Levita-dulemargadga degisadegu guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","” ’Be-dule wilegedga gudele, bese danikile, be bendakoed. Be-neggi dule-neggwebur-baidginedyob gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","We-dulegi, melle ega be mani-nug meso, degi, melle ei ibmar be sumarbalo. Suli, degisuli. Be-Bab-Dummad-dobee be nanamaloed. We-be-dule be-walik gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Deginbali, bese mani egichisale, egi mani onogegala, melle egi mani-obine be gao, degi, melle masgunned ega mani-obine be ukbalo. ");
INSERT INTO cuk_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ani an be-Bab-Dummad-Jehová gued. Ani an Canaán-yala bemarga ukega, Egipto-yargi bemar-onosad, adi, an be-Bab-Dummadga guegar. ");
INSERT INTO cuk_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","” ’Be-dule be-walik-gudii wilegedga gudele, manigi bese na dukin ukdele, melle dule-mai-imaklegedyob be imako. ");
INSERT INTO cuk_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Nabir binsa bega dule-arbaedyob, Israel-dulesulid-be-walik-gudiidyob be imakoed. We-dule, Gannar-Ibmar-Ukleged-Birgase bega arbaoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Geb a-birgagine, e-mimmiganmala nabir be-neggi nodoed. Geb e-gwenadganse gannar naoed, na e-dadgan-nainu gannar egadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Deyob guoed, ar ade, Israel-dulemar anga-arbamalad-gumalad, ani an wemar Egipto-yargi onosad. A-ular, Israel-dulemala maiga-guega manigi uklegosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Melle Israel-dulemar sabsuli-imakdii be gumalo. Suli, degisuli. Be-Bab-Dummad-dobee-nanadii be gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","” ’Dulemar-be-yar-dikarba-mamaid, machereddibe, omedibe, amala sunna be-maiga gumaloed. Amala, machereddibe, omedibe be-maiga-gumalagala, manigi be bakmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Deginbali, Israel-dulesurmalad-bemar-abargi-mamaid, e-mimmigan-be-yargi-gwalulesmaladi, be-maiga-guegala, sunna manigi be bakmaloed, adi, bemargadga guegar. ");
INSERT INTO cuk_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Be burgwisale, we-be-maimala sunna be-mimmiganga be obemalad, adi, degisadegu be wagangadga guegar. Amala, degisadegu be-maiga gumaloed. Bemar, be-gwenadgandi, Israel-dulemardi, sabsuli gwen imakosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","” ’Israel-dulesulid bemar-abargi-maid mani-ibedga gudele, Israel-dule a-dikarba-maid wilegedga gudele, we-dule, dule-mani-ibed-e-maiga-guega na san-ukdele, igidibe, Israel-dulesulid-e-gwenadga na san-ukdele, ");
INSERT INTO cuk_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","dule-na-san-uksad sunna gannar onoleged. E-gwenad-wargwen sunna manigi onogoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","E-gilordibe, e-gilor-machidibe, a sunna manigi a-dule-onogoed. E-gwenad-walikagwad sunna onomogad. Ar e-sunnad sunna nabir na onogele, ar na dukin manigi onogodo. ");
INSERT INTO cuk_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Dule, degi, dule-mani-ibed na ebogwa itomaloed, birgabigwa-gusa dule-manigi-uklesa, degi, igi-birga, Gannar-Ibmar-Ukleged-Birga napi. Agine, itogoed, dule-wargwen-arbaed igi-mani bennuklesale, abali, mani-nasiklegoed, igi-manigi dule-onolegoe. ");
INSERT INTO cuk_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Gannar-Ibmar-Ukleged-Birga amba ichesur-napile, a-wilub, uklesadgi-ollorguega mani-dummad bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Gannar-Ibmar-Ukleged-Birga ichenapile, itomaloed, a-birgamarde igi-mani-wilub gue. Geb ollorguega, a-wilub bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","We-dule, unnila dule-birgagwen-manigin-arbaedyob imaklegoed. We-dule nue be dakmaloed, melle dule-baksad sabsuli we-dule-imaked be imakmalo. ");
INSERT INTO cuk_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","” ’We-dule Gannar-Ibmar-Ukleged-Birga-idu ollorgussulile, Gannar-Ibmar-Ukleged-Birgagi e-mimmiganmala ollorguoed. ");
INSERT INTO cuk_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","” ’Israel-dulemar anga-arbamalad gumalad. We-Israel-dulemar, ani an Egipto-yargi onosad. Ani an be-Bab-Dummad-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Bab-Jehová, Moisésʼga sogdebalid: “Melle ibmar-sobarmalad bab-dummadyob-imakegala, be sobmalo. Ibmaryob-daklemalad-wilubgan, degi, akwa-islidikmalad, melle be sobmarbalo. Deginbali, akwa-sobaled bemar-yargi be siosurmarbalid, adi, melle bemar a-asabin dulluu imakegar. Ar ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","”An-obunnoged-ibagi, bemar obunnomarmogoed. Degine, anse-goled-neggi nue-binsaed-nikaa be damaloed. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","”An bemarga igarmar-uksadba, igarmar-mesisadba, be nanamalale, a-igarmar-sogedba be inniki damalale, ");
INSERT INTO cuk_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ani an bemarga e-ibagan-sekalaa dii-owioed. Nainumargi-ibmar-digaled na e-ibagan-sekalaa sanmake an imakoed, degine, sapimar deyob an imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Uva-san-weledagoed-ibaganse, ibmar-gwag-welegoed bemar nikagu gumaloed. Degi, ibmar-gwag-diged-ibagan-nagunonikoedse, bemar uva-san amba wenanai guoed. Immediki be gudii gumaloed. Degine, bogidik be-yalagi bemar bukwa gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","”Ani an bemar-yargi neg-bogidikid nasikoed. Degine, dobsulidba nue-gabbukwa, an bemar-imakoed. Ibdurgan-sapurbarmalad-ursirmar an bemarga osulogoed. Degine, bar be-yalagi bila-onolegega an imakosulid. ");
INSERT INTO cuk_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Bemar be-isdarmalad-bareginmaloed, amar es-suidgi bemarse burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Bemar-walatale, dulemar-dulatar-mergued (100) bareginmaloed. Bemar-dulatale (100) dulemar-miliambe-mergued (10,000) bareginmaloed. Be-isdarmalad bemarse es-suidgi burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","”An ise-nued bemargi binsaoed. An bemar-omelogoed, dulemar-ichesuli-guega an bemar-imakoed. Degine, an-bemarbo-igar-mesisadi maiguguega an imakoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ibmar-gwagmar-sabolesmalad bemar gunmaloed, degine, ibmar-gwag-binid-wesmalad-sabogega, birga-nasadgi ibmar-gwag-gwabgusad be midmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","”An bemar-abargi maigu guoed. An isdar bemar-dakosulid. ");
INSERT INTO cuk_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","An bemar-abargi gudii guoed. Ani an bemar-Bab-Dummadga guoed. Bemarmoga, be an-dulamarga gumarmogoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ani an bemar-Bab-Dummad-Jehová gued. Ani an Egipto-yargi bemar-onosad, adi, bemar Egipto-dulemar-e-maiga mer bar-guegar. Bemar mer bingegudii gumalaga, maiga-gudiidgi an bemar-onosad.” ");
INSERT INTO cuk_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Bab-Jehová, Moisésʼga sogdebalid: “Ar bemar an-itosurmalale, degi, an-negseleged-igarmar-mamaidba be dasurmalale, an sabsur bemar-odurdakoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","An-igarmar-mamaid be baisur dakmalale, an-igarmar-bemarga-uksadba be nanasurmalale, bela an-sogedba be dasurmalale, degine, an bemarbo-igar-mesisadgi be annadmalale, ");
INSERT INTO cuk_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","an weyob bemar-sabsur-imakoed: Ukiar dobed-dummad bemargi nagunonikoed, bonigan-dummagan, degi, uellemalad-dummagan begi an barmidagoed. Wemala, be-ibyamar oichogoed, degi, be-sanmar nolloo imakoed. Be-ibmar-gwag bemar binsa digmaloed, ar ade, dule-baigan bemar ibmar-gwag-digmaloedi gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Bemargi nue-dummad an yolegoed, degine, bemar be-isdarmaladse galakuega an bemar-imakoed. Be-isdarmaladse bemar ebipiledii gumaloed, degine, dulemar bemar-bareginnosurmar-inigwele, degite, bemar wakinmamai gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","”Deyob an sabsur-bemar-odurdaked-sorbali, amba bemar an-sogedba dasurmalale, be-isgumalad-ular, ilagugle (7) bur bule sabsur an bemar-odurdaknonisunnoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Bemar be-san-dummarba-imakmaladi, an san-bipii bemar-imakoed. Nibneg esgoroyob, an bega imakoed, degi, napadi esgoro-gordikidyob an bega imakbaloed, ar ade, dii wiosulid, degi, napagi ibmar-sanmakosulid. ");
INSERT INTO cuk_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Binsa dummad-arbanai be guoed, ar ade, napa isguosoggu, ibmar-gwag-be-digsale, bega sanmakosulid. Degine, be-sapimar bega sanmakosurbalid. ");
INSERT INTO cuk_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","”Ar amba a-sorba, bemar angi yolenanaimalale, an-sogedba bemar dasurmalale, be-isgumalad-ular, ilagugle (7) bur bule boni-dummagan bemargi an barmidagoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Degine, bemargi ibdurgan-sapurbarmalad-ursilimalad an barmidabaloed, adi, be-mimmigan ese bergumalaga, degi, be-moli-bebe-nikamalad bei oburgwemalagar. Degisoggu, bemar ichee-gudmalosoggu, dule-be-igarba-nanamalad sate gudmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","”Weyob an bemar-sabsur-odurdaknanaidgine, amba bemar nugusurmalale, amba bemar angi-yolenanaile, ");
INSERT INTO cuk_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ani an bemargi yolemarmogoed, be-isgumalad-ular, ilagugle (7) bur bule boni-dummagan bemargi an barmidabaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","An bemar-ebo-igar-mesisadba bemar dasurmalale, bemar urwenanaidgi, es-suidgi-burgwega an bemar-imakoed. Ar bemar bemar-neggweburgi be dukunadmalale, uelleged-dummad begi an barmidoed, degine, bemar, be-isdarmaladse be galakumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","”Mas-sate an bemar-imakoedgi, soo-gwagwengi omegan-warambe (10) bemarga mas-dunai guoed. Mas ise-wilubsaar-mimidmalogu, mas ichee-gusoggu, immelegosurmalad. ");
INSERT INTO cuk_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","”Ar deyob sabsur an bemar-odurdaknaid, amba be an-itosurmalale, amba angi bemar yolenanaile, ");
INSERT INTO cuk_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","agine, bemargi ise-yolegar nue an sae-itogedgi, an-sunnad bemargi yoledsunnoed, be-isgumalad-ular, ilagugle (7) bur bule boni-dummagan bemargi an barmidabarsunnoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Be-masmala be gutemaloed, be-bunamala be gutemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Be-bab-dummad-baiganse-gormalad-e-aila-matusurmalad bei an osulogoed, be-bab-dummad-baiganse-gormaladga ina-wawadikid-e-aila-sobarmalad bei an bibisgoed. Be-bab-dummadyob-imakmalad-burgwarmaladgi, be-muimar an mesoed. Isdar an bemar-dakoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Be-neggweburmar an bibisgoed, be-bab-dummad-baiganse-gormalad-negmar an bibisgebaloed, degine, be anga ibmar-ogumakar-ukmalad bei an abingaosulid, ar ade, isdar-yapanne anga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","”Be-yala bei an bibisgoed. Be-isdarmalad be-yarse nonimalogua, amarbela geger be-yar dakmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Bemar dule-baid-baid-bukwamaladse-aisakiega an be-imakmaloed, degine, be-isdarmalad es-suid-gani bemar-bareginnega an imakoed. Be-yala, dulemar-sate guoed, degi, be-neggweburmar bela bibisgar guoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Geb degine, be-isdarmalad-yargi be bukwamaloedgine, be-yardi olloo mellesii guoed. Geb agine, be-yala wis obunnogoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ar igi be maidgi, be-yala obunnoged-birgagi obunnosawilubbina, deyobi, bemar maiosurmaladgine, be-yala obunnogoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","”Bemar-dula-bemaloedi, be-isdarmalad-yargi bela-belad dobed an begi nasikmaloed. A-ular, binsa sapi-gagan-argwanedgi bemar gwakiar wakinmamai gumaloed. Ar igi dule es-suid-idu wakitedamala, deyob bemar wakitemaloed. Ar dule bemar-bareginnosurmar-inigwele, degite, bemar aimukudmaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Es-suid-idu wakinmamaiyob, dule bemar-bareginnanai-guosurmar-inigwele, na be muchub-muchub yolenanai gumaloed. Be-isdarmalad-abin bemar gwisguosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","”Dulemar-baigan-yargi be burgwemaloed, be-isdarmalad-yala be-obelomaloed, agi, be diglemaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Bemar-burgosurmaladdi, be-isdarmalad-yargi aka bur bule wiledmaloed. Bemar isgusmalad-ular, degi, be-babgan-isgusmalad-ular, be deyob gumaloed. ");
INSERT INTO cuk_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","”Ar bemar-isgusadba, degi, be-babgan-isgusadba, be angi bangudigumalad, be angi yoledigumalad. ");
INSERT INTO cuk_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Ar a-ular, be-isdarmalad-yarse an bemar-barmidoed. A-yargi-gudiidgi bemar-isgusmalad na be magar-itononimalale, be anga sokarmalale, anmar bukib-itomarye, ");
INSERT INTO cuk_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","geb agi an, Jacob-ebo, Isaac-ebo, degi, Abraham-ebo-igar-mesisad an ebinsaoed. Deunni, amarga an sogsad, yar an bemarga ukoye. A-yargi ise-nued an egi binsaoed. ");
INSERT INTO cuk_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","A-yargi bemar bangudogua, bar egi be megmalosulidgi, a-yala obunnonai guoed. Bemardi, be-isgusmalad-ular be sabsur-odurdaklemaloed. Ar ade, an-igar an bemarga uksamaladi, bemar abingassurmalad, an-igar an-bemarga-mesismaladi, isdar be daksamalad. ");
INSERT INTO cuk_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","”Ar be-isdarmalad-yargi be gudigumalo-inigwele, amba an be-iegosurmalad. Degine, bela be-obelogedse an be-imakosurmalad. Ar an deyob imakdele, degiile, bemar-dadgan-ebo-an-igar-mesisadgi an annao-itole. Ar ade, ani an be-Bab-Dummad-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Be-dadgan-ebo-an-igar-mesisad, an iegosulid. Deun, an bemar-Bab-Dummadga-guega, Egipto-yargi dulemar-baigan-wagab an bemar-onosad. Ani an Bab-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","We-igar-uklesmalad, degine, dulemar-odurdakega-igar-uklesmalad, deun, Bab-Jehová Sinaí-yargi Moisésʼba Israel-dulemar-ebo igar mesis gusad. ");
INSERT INTO cuk_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Bab-Jehová, Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Israel-dulemarga be sunmake, amarga be sogo: ‘Dule Bab-Jehováʼga sogsadibe, dule-gwensak-anar an mani bennukoye, we-dule-onogega, weyob imakoed: ");
INSERT INTO cuk_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Machergan birga-durgwen-nikad (20), birga-dulapaa-nikadse (60) onogega, mani-dulabo-gakambe-aidiku (50) be bennukoed, Bab-Dummadse-goled-neggi mani-wilub-saed-siidba bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Omegan-onogegardina, mani-dulagwen-gakambe-aidiku (30) be bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Masmala birgatar, birga-dulagwenadse-nikale (20), onogega, mani-dulagwen-aidiku (20) be bennukoed. Bunamala-onogegardi, mani-ambe-aidiku (10) be bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Susmala nii-wargwen-nikale, birgatar-nikadse, onogega, mani-atar-aidiku be bennukoed. Bunormala-onogegardi, manipaa-aidiku be bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Machergan-birga-dulapaa (60), degi, birga-dulapaa-obine-nikale, onogega, mani-ambe-gakatar-aidiku (15) be bennukoed. Mukwamar-onogegardi, mani-ambegi-aidiku (10) be bennukoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","” ’Ar dule nue-wilegediile, we-igar-maidba geg bennukele, dule-irwa-Bab-Dummadse-goledse seledoed, adi, ega mani-nug nasikegar. Dule-irwa-Bab-Dummadse-goled, we-dule e-ganguedba na bennuko-itogedba, ega mani-nug nasikoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Bab-Jehováʼga ibdurgan sunna uklegedile, a-ibdurganmar Bab-Jehováʼga uklesale, bela we-ibdurganmala ise-nue-islidikidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Degisoggu, we-ibdurgan bipisaale ibdurgan-baidbo ogwalegosulid, ibdurgan-baid-bur-nueddibe, ibdurgan-baid-bur-ichakwagwaddibe, bipisaale muchub ogwalegosulid. Ar we-ibdurgan-muchub baid-ibdurgan be ukye sogele, we-ibdurgan-warbobela ise-nue-islidikidga guoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","” ’Ibdurgan-Bab-Dummadga-ukleged, swilidiksulidile, dule-irwa-Bab-Dummadse-goled-asabin seledoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Geb dule-irwa-Bab-Dummadse-goled we-ibdurgan nue dakoed, adi, sogega, igi-mani-gargegu naguoe. We-mani-naguoedi, dule-baid bipisaale ogwaosulid. ");
INSERT INTO cuk_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ibdurgan-e-ibed we-ibdurgan-onobiele, mani-soglesadba bennukoed, degine, a-ukine, a-mani-atargi-gwensak napi bennukbaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Ar dule-wargwen Bab-Jehováʼga na e-neg-uksale, dule-irwa-Bab-Dummadse-goled we-neg nue dakoed. Nue dakogu, geb dulega mani-nug-nasikoed. We-mani-nug-naguoedi, dule-baid bipisaale ogwaosulid. ");
INSERT INTO cuk_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ar dule Bab-Jehováʼga na neg-uksad gannar neg abegele, mani-nug-nagusadba bennukoed. A-ukinbali, a-mani-atargi-gwensak napi bennukbaloed. Geb agine, we-neg gannar egadga gunonikoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-wargwen na e-nainu-e-dad-ega-uksad, Bab-Jehováʼga ukele, we-nainu ibmar-gwag-diglegedba e-mani-nug ega naguoed. Orosgisaar-dakleged-cebadaʼye-nugad galón-gwadulabo-gakambe-gakatar (55) sunna diglegele, mani dulabo-gakambe (50) aidikued-wilub ega naguoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Dule na e-nainu Gannar-Ibmar-Ukleged-Birgagi Bab-Jehováʼga uksale, nainu-gargegued-soglesadba e-mani-nug naguoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Gannar-Ibmar-Ukleged-Birga-sorba Bab-Jehováʼga e-nainu ukerdina, dule-irwa-Bab-Dummadse-goled ebisoed, birgabigwa Gannar-Ibmar-Ukleged-Birga-baidse-warmaked napi. Geb a-wilub ega mani-nug bur-bipi nasikoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","” ’Ar dule na e-nainu-uksadi gannar obirbiele, nainuga mani-nug-nagusadba bennukoed, degine, a-ukinbali, a-mani-atargi-gwensak napi bennukbaloed. Geb agine, we-nainu gannar egadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ar dule we-nainu gannar obirsulile, we-nainu dule-baidga manigi uklesale, we-nainu dule bar obirosulid. ");
INSERT INTO cuk_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","We-nainu Gannar-Ibmar-Ukleged-Birgagi ollorgunonikogu, we-nainu Bab-Jehováʼgadga gunonikoed. Degine, nainu-islidikidga gunonisunnoed. Geb degine, we-nainu dule-irwa-Bab-Dummadse-gormaladgadga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","” ’Ar dule-wargwen, nainu-e-dad-ega-uksasulid-baksadi, Bab-Jehováʼga ukbiele, ");
INSERT INTO cuk_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","dule-irwa-Bab-Dummadse-goled Gannar-Ibmar-Ukleged-Birga-napiwilub ega mani-nug nasikoed. Geb a-ibagine, a-mani-nug-nagusadba dule mani bennukoed. Ar wede Bab-Jehováʼga ibmar-swilidik uklegaledid. ");
INSERT INTO cuk_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Gannar-Ibmar-Ukleged-Birga-nagunonikir e-ibed-sunnadga we-nainu gannar uklegoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","” ’Bela ibmarga be mani nasikalile, Bab-Dummadse-goled-neggi mani-wilub-saed-siidba ega be nasikoed. We-mani-e-wilubde gramo-ambe (10) aidikued.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Ar ibdurgan-gebe-gwalulemaladdi, gusgu bato Bab-Jehováʼga uklegaledsoggu, gege be Bab-Jehováʼga uked, ar bato egadid. Ar moli-bebe-nikaddibe, sibad-wawaaddibe, wemarde bato Bab-Jehováʼgadid. ");
INSERT INTO cuk_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ar ibdurgan swilidiksulile, e-ibed we-ibdurgan-onobiele, mani-nug-nagusadba bennukoed, degine, a-ukinbali, a-mani-atargi-gwensak napi bennukbaloed. We-ibdurgan-onosulirdi, e-mani-nug-nagusadba dule-baidga manigi uklegoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Dule-gwensak Bab-Jehováʼga ibmar-ilagwen-ukar-imaksale, gege bar manigi uked, gwen onogosurbalid: Duledibe, ibdurgandibe, nainu-e-dad-ega-uksaddibe, manigi ukosulid, gwen onogosurbalid. Bela Bab-Jehováʼga-ibmar-uklesadi, nue-islidikidga gunonikoed. ");
INSERT INTO cuk_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Dule-wargwen-oburgwilegega ukabsalesgudiidi, manigi onolegosulid. We-dule, oburgwilegergebed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Bab-Jehová, Moisésʼga sogdebalid: “Israel-dulemarga be sogo: ‘Nainugi-ibmar-sanmakmalad, ibmar-gwag sanmakoeddibe, sapimar-sanmakoed-e-sanmardibe, bela wemala ambegi-gwensakad (10%) Bab-Jehováʼgadid. Wemala bela Bab-Jehováʼga nugsalegaledid. ");
INSERT INTO cuk_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Dule-wargwen we-ibmar-ambegi-gwensakad (10%) wis ebubiele, ega mani-nug-nagusadba bennukoed, degine, a-ukinbali, a-mani-atargi-gwensak napi bennukbaloed. ");
INSERT INTO cuk_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","” ’Moli-bebe-nikamalad, igi sibad-wawaadmardibe, bela wemar-merguedba warambegi-gwensak (10%) Bab-Jehováʼgadid, ar ade, Bab-Jehováʼga uklegergebed. ");
INSERT INTO cuk_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","We-ibdurganmala be dakosulid, wede nueddibe, ichakwadibe, unnila Bab-Jehováʼga bemar uksa-imakmaloed. Deginbali, we-ibdurganmala ibmar-baidbo be muchub ogwaosurbalid. Be ogwaye sogele, we-ibdurgan, degi, ebo be ogwanaid, warbobela Bab-Jehováʼga islidikidga guoed. We-ibdurgan-warbogwadi be gwen manigi onogosulid, Bab-Jehováʼgadga guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Bab-Jehová we-igarmala Sinaí-yalagi Moisésʼga uksad, adi, Moisés Israel-dulemarga we-igarmar ukmogagar.");
INSERT INTO cuk_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Israel-dulemar birgabogus gaka nii-warbo-ibagwengusa Egipto-yargi-bukwa ainisgusmaladgine, Bab-Jehová Sinaí-nega-dulesulidganba, dulemarbo-ambikued-neggi, Moisésʼga sunmaksad. Weyob ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Bela Israel-dulemar be ebiso, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba be ebiso. Bela machergan-irba e-nug be meso. ");
INSERT INTO cuk_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Bee be, be-ia-Aarónʼbo, dulemar-ilekwaa na e-sordamar-bukwadba machergan birga-durgwen (20) nikamalad, degi, birga-durgwen-obine (20+) nikamalad, sunna dule-bila-onogedse-namalad be ebiso. ");
INSERT INTO cuk_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Bemar-bendakega bemar-dadgan-warambe-gakabogwad-war-wargwengi, neguyagi-dummadga-gudiid be suoed.” ");
INSERT INTO cuk_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Bab-Jehová Moisésʼga sogdebalid: “We-dulemala, bemar-bendakmaloedid: Rubén-e-wagansik, Sedeur-machi-Elisur. ");
INSERT INTO cuk_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeón-e-wagansik, Zurisadai-machi-Selumiel. ");
INSERT INTO cuk_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Judá-e-wagansik, Aminadab-machi-Naasón. ");
INSERT INTO cuk_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isacar-e-wagansik, Zuar-machi-Natanael. ");
INSERT INTO cuk_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zabulón, e-wagansik, Helón-machi-Eliab. ");
INSERT INTO cuk_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","José-e-masmalasikdi: Efraín-e-wagansik, Amiud-machi-Elisama. Manasés-e-wagansik, Pedasur-machi-Gamaliel. ");
INSERT INTO cuk_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benjamín-e-wagansik, Gedeoni-machi-Abidán. ");
INSERT INTO cuk_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan-e-wagansik, Amisadai-machi-Ahiezer. ");
INSERT INTO cuk_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Aser-e-wagansik, Ocrán-machi-Pagiel. ");
INSERT INTO cuk_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad-e-wagansik, Deuel-machi-Eliasaf. ");
INSERT INTO cuk_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Neftalí-e-wagansik, Enán-machi-Ahira.” ");
INSERT INTO cuk_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Wemala, dule-dummagan-nuga-nikamalad Israel-dulemar-dadgan-warambe-gakabogwad-abargi (12) onugsalesmalad-dake. Wemala, Israel-dulemar-idumaladga nugsalesmaladid. ");
INSERT INTO cuk_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Degisoggu, Moisés, degi, Aarón, we-dulemar-nugsalesmaladse e-nugba ese gochasunnad. ");
INSERT INTO cuk_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Nii-warbogwad gebe-iba-onodedgi, Moisés bela dulemar-danar urbisad. Geb degine, machergan na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba bela e-nugmar mesisad. Bela machergan birga-dulagwen-nikad (20), degine, birga-dulagwen-obine-nikamaladi (20+), e-nugmar narmaklesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Ar Bab-Jehová igi Moisésʼga-sogsagusa, deyob, Moisés Sinaí-nega-dulesulidganba dulemar-ebichisad. ");
INSERT INTO cuk_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Rubén, Israel-e-machi-sailagined, a-e-wagan, na e-dadgan-e-dadganba, degine, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Rubén-wagan, mili-dulabo-gakanergwa gaka dulataled-ilatar-mergu (46,500) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeón-wagan, na-e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Simeón-wagan, mili-dulabo-gakambe-gakabakebak gaka dulataled-ilapaa-mergu (59,300) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gad-wagan, mili-dulabo-gakatar gaka dulataled-ilanergwa gaka dulabo-gakambe-mergu (45,650) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Judá-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Judá-wagan, mili-dulapaa-gakambe-gakabake gaka dulataled-ilanergwa-mergu (74,600) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isacar-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Isacar-wagan, mili-dulabo-gakambe-gakabake gaka dulataled-ilabake-mergu (54,400) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zabulón-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zabulón-wagan, mili-dulabo-gakambe-gakagugle gaka dulataled-ilabake-mergu (57,400) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","José-masmaladi, Efraín-wagansik, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efraín-wagan, mili-dulabo gaka dulataled-ilatar-mergu (40,500) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manasés-wagansikdi, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manasés-wagan, mili-dulagwen-gakambe-gakabo gaka dulataled-ilabo-mergu (32,200), dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benjamín-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Benjamín-wagan, mili-dulagwen-gakambe-gakatar gaka dulataled-ilabake-mergu (35,400), dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan-wagan, mili-dulapaa-gakabo gaka dulataled-ilagugle-mergu (62,700) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Aser-e-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Aser-wagan, mili-dulabo-gakagwensak gaka dulataled-ilatar-mergu (41,500) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Neftalí-wagan, na e-dadgan-e-dadganba, na e-gwenadgan-e-gwenadganba, na wala-walagwen, bela machergan birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamaladi (20+), sunna dule-bila-onogedse-namalad-e-nugmar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Neftalí-wagan, mili-dulabo-gakambe-gakapaa gaka dulataled-ilabake-mergu (53,400) dakleardo. ");
INSERT INTO cuk_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Moisés, Aarón, degi, Israel-dummagan-na-e-dadgangi-war-wargwen-sulearmalad, we-dulemar-ebichismalad. ");
INSERT INTO cuk_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Bela Israel-dulemar birga-durgwen-nikad (20), degine, birga-durgwen-obine-nikamalad (20+), sunna dule-bila-onogedse-namalad-e-nugmar, na e-gwenadgan-e-gwenadganba bela mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Bela Israel-dulemar-e-nug, mili-dulataled-ilanergwa-gakapaa gaka dulataled-ilatar gaka dulabo-gakambe-mergu (603,550) mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Leví-wagandi, na e-gwenadgan-e-gwenadganba, amardi Israel-dulemar-baiganba ebislessurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ar ade, Bab-Jehová Moisésʼga sogsagusad: ");
INSERT INTO cuk_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Unnila Leví-waganbi Israel-dulemar-abargi be ebisosulid. ");
INSERT INTO cuk_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Be, Levita-dulemar Dulemar-Anbo-Igar-Mesisad-E-Neg-dakega be imakoed. Degine, a-neggi-ibmar-ebulemalad, degi, bela a-negga-ibmar-ebulemalad-dakega, be imakbaloed. Levita-dulemala, anse-goled-neg-sunna-seleged, degine, bela e-ibmarmar-agi-ebulemalad semaloed. Degine, Levita-dulemarbi agi arbamaloed. Degine, a-neg-dikar-ebilis megmaloed. A-ular, Leví-e-wagan be ebisosulid.” ");
INSERT INTO cuk_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Bab-Dummad Moisésʼga sogdebalid: “Anse-goled-neg-sunna-seleged seledsokalile, Levita-dulemar a-neg earoed. A-neg gannar osisokarmalale, Levita-dulemar osimarbaloed. Dule-baid, Levita-dulesulid a-negse warmaksale, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israel-dulemar na danar-danar, degine, na e-bander-e-bander-urba ambikumaloed. E-sordamar-bila-onomalad-ilemakar ega soglesadba ambikumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levita-dulemardi, Dulemar-Anbo-Igar-Mesisad-E-Neg-dikar-ebilis ambikumaloed, adi, melle an-urwed Israel-dulemargi yolegegar. Levitaʼmar, Dulemar-Anbo-Igar-Mesisad-E-Neg edarboed.” ");
INSERT INTO cuk_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israel-dulemala bela Bab-Jehová-Moisésʼga-ibmar-sogsadba imaksamalad. Ar deyob bela imaksamardo. ");
INSERT INTO cuk_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Bab-Jehová Moisésʼga, degi, Aarónʼga sunmakded, amarga sogded: ");
INSERT INTO cuk_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Israel-dulemala dulemar-anbo-ambikued-neg-ebilis ambikumaloed, na egad-egad, e-dadgan-e-dadgan-e-bander-urba bukwa gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","”Wemala, dulemar-anbo-ambikued-neg-siid-dad-nakwedsik ambikumaloed: Gebedgi, Judá-wagan, na e-bander-urba e-sordamarba ambikumaloed. Judá-wagan-e-dummad Naasónʼye nugad. Naasónʼde Aminadab-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","E-sordamar ebislesmaladba, mili-dulapaa-gakambe-gakabake gaka dulataled-ilanergwa (74,600) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","”Judá-wagan-dikarba, Isacar-wagan ambikuoed. Isacar-wagan-e-dummad Natanaelʼye nugad. Natanaelʼde Zuar-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","E-sordamar ebislesmaladba, mili-dulabo-gakambe-gakabake gaka dulataled-ilabake (54,400) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","”Baid-dikarsik Zabulón-wagan ambikumarmogoed. Zabulón-wagan-e-dummad Eliabʼye nugad. Eliabʼde Helón-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","E-sordamar ebislesmaladba, mili-dulabo-gakambe-gakagugle gaka dulataled-ilabake (57,400) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","”Bela Judá-wagan-bukwamaladgi, sordamar-sogapaa-ebislesmaladba, bular mili-dulabakebak-gakanergwa gaka dulataled-ilabake (186,400) mergued. Judá-wagan, na e-sordamar-nanadapmalad idunadapi gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","”Rubén-wagan, na-e-bander-urba, e-sordamarba dulemar-anbo-ambikued-neg-siid-dad-nakwed-argan-nuedsik ambikumaloed. Rubén-wagan-e-dummad Elisurʼye nugad. Elisurʼde Sedeur-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","E-sordamar ebislesmaladba, mili-dulabo-gakanergwa gaka dulataled-ilatar (46,500) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","”Rubén-wagan-dikarba, Simeón-wagan ambikuoed. Simeón-wagan-e-dummad Selumielʼye nugad. Selumielʼde Zurisadai-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","E-sordamar ebislesmaladba, mili-dulabo-gakambe-gakabakebak gaka dulataled-ilapaa (59,300) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","”Baid-dikarsik Gad-wagan ambikumarmogoed. Gad-wagan-e-dummad Eliasafʼye nugad. Eliasafʼde Reuel-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","E-sordamar ebislesmaladba, mili-dulabo-gakatar gaka dulataled-ilanergwa gaka dulabo-gakambe (45,650) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","”Bela Rubén-wagan-bukwamaladgi, sordamar-sogapaa-ebislesmaladba, bular mili-dulagugle-gakambe-gakagwensak gaka dulataled-ilabake gaka dulabo-gakambe (151,450) mergued. Rubén-wagan, Judá-sordamar-sorba, na e-sordamar-nanaimaladba nadapi gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","”Geb degine, a-sorbali, Levita-dulemar, dulemar-anbo-ambikued-neg semai gumaloed. We-negde, Israel-dulemar-negabargi siidaed. Ar igi Levita-dulemar na bukwa-daniki, deyob na e-bander-e-bander senadapi gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraín-wagan e-bander-urba, dulemar-anbo-ambikued-neg-siid-dad-argwanedsik ambikumaloed. Efraín-wagan-e-dummad Elisamaʼye nugad. Elisamaʼde Amiud-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","E-sordamar ebislesmaladba, mili-dulabo gaka dulataled-ilatar (40,500) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","”Efraín-wagan-dikarba, Manasés-wagan ambikuoed. Manasés-wagan-e-dummad Gamalielʼye nugad. Gamalielʼde Pedasur-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","E-sordamar ebislesmaladba, mili-dulagwen-gakambe-gakabo gaka dulataled-ilabo (32,200) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","”Baid-dikarsik Benjamín-wagan ambikumarmogoed. Benjamín-wagan-e-dummad Abidánʼye nugad. Abidánʼde Gedeoni-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","E-sordamar ebislesmaladba, mili-dulagwen-gakambe-gakatar gaka dulataled-ilabake (35,400) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","”Bela Efraín-wagan-bukwamaladgi, sordamar-sogapaa-ebislesmaladba, bular mili-dulatar-gakabaabak gaka dulataled (108,100) mergued. Efraín-wagan, na e-sordamar-nanaimaladba danakwaa-nadapmalad-sogapaagi nadapi gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","”Dan-wagan e-bander-urba, dulemar-anbo-ambikued-neg-siid-dad-nakwed-argan-sapiledsik ambikuoed. Dan-wagan-e-dummad Ahiezerʼye nugad. Ahiezerʼde Amisadai-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","E-sordamar ebislesmaladba, mili-dulapaa-gakabo gaka dulataled-ilagugle (62,700) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","”Dan-wagan-dikarba, Aser-wagan ambikuoed. Aser-wagan-e-dummad Pagielʼye nugad. Pagielʼde Ocrán-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","E-sordamar ebislesmaladba, mili-dulabo-gakagwensak gaka dulataled-ilatar (41,500) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","”Degine, baid-dikarsik Neftalí-wagan ambikumarmogoed. Neftalí-wagan-e-dummad Ahiraʼye nugad. Ahiraʼde Enán-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","E-sordamar ebislesmaladba, mili-dulabo-gakambe-gakapaa gaka dulataled-ilabake (53,400) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","”Bela Dan-wagan-bukwamaladgi, sordamar-sogapaa-ebislesmaladba, bular mili-dulagugle-gakambe-gakagugle gaka dulataled-ilanergwa (157,600) mergued. Dan-wagan, napi-solaba na e-bander senadapi gumaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Wemala, Israel-dulemar na e-gwenad-e-gwenadganba ebislesmaladid. Bela danar-danar-bukwamaladgi, na e-sorda-e-sordamar-ebislesmaladba, mili-dulataled-ilanergwa-gakapaa gaka dulataled-ilatar gaka dulabo-gakambe (603,550), bela mergued. ");
INSERT INTO cuk_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ar igi Bab-Jehová Moisésʼga igar-uksadba, Leví-wagandi we-Israel-dulemarba ebislessurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Israel-dulemala bela Bab-Jehová-Moisésʼga-igar-uksadba imaksamalad. Bela na e-bander-e-bander-urba ambikusmalad, degine, na e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba nadapi gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Deun, Bab-Jehová Sinaí-yargi Moisésʼga sunmaksagusgu, weyobi, Aarón-wagan, degi, Moisés-wagan gardagi-narmaklegar mesilesad. ");
INSERT INTO cuk_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Weyobi, Aarón-masmala nugmalad: Nadab, Abiú, Eleazar, Itamar. Nadabʼde, e-machi-sailaginedid. ");
INSERT INTO cuk_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","We-Aarón-masmala, dule-irwa-Bab-Dummadse-gormaladga sulesmalad. Wemarde, Bab-Dummadse-dule-irwa-goledga-gumalaga nug-imaklesmalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Sinaí-nega-dulesulidganba Nadab, degi, Abiúʼbo, igar-maisulidba Bab-Jehováʼga ibmar-ogumakar uksamalad. A-ular, amar Bab-Jehová-asabin burgwismarsunnad. Wemar-warbogwad mimmi-nikussurmalad. Unnila, Eleazar, degi, Itamar, wemarbi e-bab-Aarón-asabin dule-irwa-Bab-Dummadse-goledga arbananai gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Leví-wagan, dule-irwa-anse-goled-Aarón-asabin be sedage. We-Leví-waganmar, Aarón-ibmar-imakedgi Aarón-bendakmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Amala, dulemar-anbo-ambikued-neggi Aarónʼga, degi, bela Israel-dulemarga arbananai gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","We-Leví-wagan dulemar-anbo-ambikued-neggi bela ibmarmar-ebulemalad akwemaloed. Degine, anse-goled-neg-sunna-selegedgi Israel-dulemar-ular ibmar imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","We-Leví-wagan, Aarón, degi, e-masmala-bendakega be imakoed. Wemala, Israel-dulemar-abargine bachikii sulesmalad, anga arbaegar. ");
INSERT INTO cuk_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aarón, degi, e-masmaladi, dule-irwa-anse-goledga be imakoed. Ar dule-baid, dule-irwa-anse-goledsulid anse-goled-negse warmakele, oburgwilegoed.” ");
INSERT INTO cuk_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ani an Israel-dulemar-abargi Leví-wagan-baigan bela Israel-machi-sailaginmalad-anar an susad. Ar bela machimala-sailaginmalad angadsoggu, Leví-wagan-baigan angadga gusunnodo. ");
INSERT INTO cuk_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Egipto-yalagi bela machi-sailaginmalad an oburgwisgua, ani an Israel-machi-sailaginmalad angadga-guega an susad. Deyob dulemar, degi, ibdurganse-bakale, an imaksad. Ar we-ibdurgan, bela angadid. Ani an Bab-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Bab-Jehová Sinaí-nega-dulesulidganba, Moisésʼga sunmaksad, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Leví-wagan-baigan na e-dadgan-e-dadganba, degi, na e-gwenad-e-gwenadganba be ebiso. Bela-machergan be ebisoed, susmar-nii-wargwen-nikamaladse-bakar, be ebisoed.” ");
INSERT INTO cuk_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moisés, Bab-Jehová-ega-igar-uksadba, bela Leví-wagan-baigan ebichisad. ");
INSERT INTO cuk_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Leví-masmala, wemalad: Gersón, Coat, degi, Merari. ");
INSERT INTO cuk_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gersón-masmaladi, wemarmogad: Libni, Simei. ");
INSERT INTO cuk_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Coat-masmaladi, wemarmogad: Amram, Izhar, Hebrón, degi, Uziel. ");
INSERT INTO cuk_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari-masmaladi, wemarmogad: Mahli, Musi. Leví-wagan-baigan na e-dadgan-e-dadganba weyob gumalad, na e-gwenad-e-gwenadganba ebislesad. ");
INSERT INTO cuk_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Libni-wagan-danaled, degi, Simei-wagan-danaled Gersónʼgi danimalad. Wemala, Gersón-wagan gumardo. ");
INSERT INTO cuk_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","We-e-sordamar bela machergan-ebislesmalad, susmala-nii-wargwen-nikamaladse-bakar-ebislesmaladi, miligugle gaka dulataled-ilatar (7,500) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gersón-wagan dad-argwanedsik Bab-Dummadse-goled-neg-sunna-seleged-yarganba, bukusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gersón-wagan-e-dummad Eliasafʼye nugad. Eliasafʼde Lael-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gersón-wagan we-ibmar-imakmalaga gumalad: Bab-Dummad-dulemarbo-ambikued-neg-dakedga. Ibmar-ukamar Bab-Dummadse-goled-neg e-uasga-gunaid-dakedga. A-yawagak-dogedgi-mor-dummad-naid-dakedga. ");
INSERT INTO cuk_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Mor-dummad bela Bab-Dummadse-goled-neg, degi, ibmar-ogumakar-ukleged-aila-ebirnaid-dakedga. Degine, e-yawagakgi mor-dummad-naid, bela urdubmar-agi-ebulemaladse-bakar-dakedga gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amram-wagan-danaled, Izhar-wagan-danaled, Hebrón-wagan-danaled, degi, Uziel-wagan-danaled Coatʼgi danimalad. Wemar, Coat-wagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","We-e-sordamar bela machergan-ebislesmaladi, degi, susmala-nii-wargwen-nikamaladse-bakar-ebislemaladi, milibaabak gaka dulataled-ilanergwa (8,600) mergued. Wemala, Bab-Dummadse-goled-neg-dakmaladga gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Coat-wagan, dad-nakwed-argan-nuedsik Bab-Dummadse-goled-neg-sunna-seleged-dikarba, bukusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Coat-wagan-e-dummad Elizafánʼye nugad. Elizafánʼde Uziel-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Coat-wagan we-ibmar-imakmalaga gumalad: Bab-Dummad-Israel-Dulemarbo-Igar-Mesisad-Ulu-dakedga. Mese-dakedga. Gwallumar-sied-dakedga. Ibmar-ogumakar-uklemalad-ailamar-dakedga. Bab-Dummadse-goled-neggi-ibmar-ebulemalad-dakedga. Mor-dummagan-dakedga. Degi, bela agi ibmarmar-ebulesiid dakedga gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Leví-wagan-baigan-e-dummad Eleazarʼye nugad Aarón-e-machid. Aarónʼde dule-irwa-Bab-Dummadse-goledid. Eleazarʼde Bab-Dummadse-goled-neg-sunna-seleged-dakmalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mahli-wagan-danaled, degi, Musi-wagan-danaled, Merariʼgi danimalad. Wemar, Merari-wagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","We-e-sordamar, bela machergan-ebislesmalad, susmar-nii-wargwen-nikamaladse-bakar-ebislesmaladi, milinergwa gaka dulataled-ilabo (6,200) mergued. ");
INSERT INTO cuk_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari-wagan, dad-nakwed-argan-sapiledsik Bab-Dummadse-goled-neg-sunna-seleged-dikarba bukusmalad. Merari-wagan-e-dummad Zurielʼye nugad. Zurielʼde, Abihail-e-machid. ");
INSERT INTO cuk_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merari-wagan we-ibmar-dakmalaga gumalad: Bab-Dummadse-goled-neg-sunna-seleged-e-urgomar-dakmaladga, e-suarmar-dakmaladga, e-buarmar-dakmaladga, e-sigmalad-dakmaladga, bela e-ibmarmar-dakmaladga, degine, bela ibmar-egi-ebulemalad-dakmaladga. ");
INSERT INTO cuk_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Bab-Dummadse-goled-neg-e-galu-bubamar-dakmaladga, e-sigmalad-dakmaladga, e-bargamalad-dakmaladga, e-dubmar-dakmaladga gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moisés, Aarón, degi, a-e-masmala, Bab-Dummadse-goled-neg-sunna-seleged-asabin mamaigusmalad. A-sogleged, Bab-Dummad-dulemarbo-ambikued-neg-dad-nakwedsik mamaigusmarye. Aarón, degi, e-masmala, Israel-dulemar-nuggine, Bab-Dummadse-goled-neg-sunna-seleged dakega gumalad. Dule-baigan dule-irwa-Babse-goledsulile, Bab-Dummadse-goled-negse warmaksale, oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Moisés, degi, Aarón, Bab-Jehová-ega-sogsadba, bela Leví-wagan, machergan, degi, bela susmar-nii-wargwen-nikamaladse-bakar, na e-dadgan-e-dadganba ebichismargua, daklealid, mili-dulagwen-gakabo (22,000) mergue. ");
INSERT INTO cuk_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Bab-Jehová Moisésʼga sogded: “Israel-dulemar-e-masmala-sailaginmalad, nii-wargwen-nikamaladse-bakale, bela ebiso, degine, e-nugmar be narmakbalo. ");
INSERT INTO cuk_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","”Geb degine, Israel-masmala-gebesailaginmalad-anar bela Leví-wagan be suo. Geb deginbali, bela Israel-dulemar-e-ibdurgan-gebemalad-anar, Leví-wagan-e-ibdurgan be subalo. Ani an Bab-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moisés Bab-Jehová-ega-sogsadba imaksad, bela Israel-masmala-gebesailaginmalad ebichisad. ");
INSERT INTO cuk_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Bela masmala-sailaginmalad-nii-walagwen-nikamaladse-bakar-ebislesadi, a-e-nugmar-mesilesadi, mili-dulagwen-gakabo gaka dulataled-ilabo gaka dulapaa-gakambe-gakapaa (22,273) mergu daklealid. ");
INSERT INTO cuk_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Geb degine, Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Bela Israel-masmala-gebesailagined-anar, Leví-wagan be suo. Degine, Israel-dulemar-e-molimar-anar, Leví-wagan-e-molimar be subalo. Leví-wagan angadga guoed. Ani an Bab-Jehová gued. ");
INSERT INTO cuk_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","”Ar Israel-dulemar-e-masmala-gebesailaginmalad, Leví-wagangi dulataled-ilabo gaka dulapaa-gakambe-gakapaa (273) egi-obinedba, Israel-masmala burgoenad. Amar-onogega, ");
INSERT INTO cuk_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","dule-war-wargwengi mani-sibu-gwaatar be suo. A-mani Bab-Dummadse-goled-neggi-aidikuedba be suo. We-manide, gera-dulagwen (20) aidikued. ");
INSERT INTO cuk_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","We-manimala, bela Aarónʼga, degi, e-masmalaga be uko. We-manide Israel-masmala-gebesailaginmalad-onolesad-e-manid.” ");
INSERT INTO cuk_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moisésʼde Israel-masmala-gebesailaginmalad, Leví-wagan-obinedba manigi-onolesadi susad. ");
INSERT INTO cuk_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Moisés we-mani abingasad, mani-sibu-miligwen gaka dulataled-ilapaa gaka-dulapaa-gakatar (1,365) aidikued. Bab-Dummadse-goled-neggi-mani-oaidikuedba we-mani oaidikusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","A-sorbali, Moisés, we-dule-onolesmalad-mani Aarónʼga, degi, a-e-masmalaga uksad. Moisés, ar Bab-Jehová-ega-sogsadba imaksad. ");
INSERT INTO cuk_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Bab-Jehová Moisésʼga, degi, Aarónʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Leví-wagan-abargi, Coat-wagan na e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba, be ebiso. ");
INSERT INTO cuk_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Bela machergan birga-durgwen-gakambe-nikamalad (30), degi, birga-durbo-gakambe-nikamaladse (50), dulemar-anbo-ambikued-neggi sunna-arbamaloed, be ebiso. ");
INSERT INTO cuk_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","”Coat-wagan dulemar-anbo-ambikued-neggi, ibmarmar-ise-islidikid akwega be imakoed: ");
INSERT INTO cuk_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Bemar danar-danar-bukwamaladgi baid-negse-naesokarmalale, Aarón, degi, e-masmala nonimaloed, anse-goled-negse dogmaloed, mor-dummagan Nega-Ise-Islidikid-idu-nanaid weemaloed. A-morgi, Dulemar-Anbo-Igar-Mesisad-Ulu anwoed. ");
INSERT INTO cuk_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","A-birgine, ibdurgan-uka-nuegan oginmaloed. Geb agi, Aarón, degi, e-masmala, a-uka-birgi mor-aradbiid oginmarbaloed. Geb degine, Ulu-sedmalaga egi e-suarmar yomaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","”Madu-anga-ukleged-mese-birgi mor-arad oginmaloed. Geb agi, batemar, wesarmar, nogmar, degi, bormo-dukwa-ibmar-eogega-ebuleged urbemaloed. Madude a-mesegi bukwagu guoed. ");
INSERT INTO cuk_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","A-ibmarmar-birgine, mor-ginnid oginmaloed. Geb birgine, ibdurgan-uka-nuegan oginmarbaloed. Geb a-sorbali, mese-sedmalaga egi e-suarmar yomaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","”Geb degine, Aarón, degi, e-masmala mor-arad sumaloed. A-mor-aradgi gwallumar-sied anwemaloed, degi, e-gwallumar, gwallu-gwillodub-sikmalad-e-disla, e-bate-burwigana, degine, bela olivo-gwallu-simalad-e-nogmar agi anwemarbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Geb degine, gwallumar-sied, degi, bela egi-ibmar-ebulemaladi, ibdurgan-uka-nuegangi anwemaloed. Geb degi, nabir-sedmalaga suar-wargwengi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","”Ibmar-ogumakar-ukleged-aila-olobiidi mor-aradgi anwemaloed, geb, ibdurgan-uka-nuegan e-birgi anwebaloed. Geb degine, nabir-sedmalaga e-suarmar egi yomarbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","”Aarón, degi, e-masmala, bela ibmar-anse-goled-neggi-ebulemalad weemaloed. Geb mor-aradgi anwemaloed, degi, ibdurgan-uka-nuegangi anwemarbaloed. Geb degine, nabir-sedmalaga suar-wargwengi be nasikoed. ");
INSERT INTO cuk_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","”Ibmar-ogumakar-ukleged-ailagi buru-bukwad weemaloed. Geb a-aila mor-suir-akwagiidgi anwemarbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","A-aila-birgi, bela e-ibmar-ebulemalad urbemarbaloed: Buru-weemalad, iko-san-obin-obin-imakmalad, sianarmar, degi, nog-dummagan. A-ibmarmar-birgine, ibdurgan-uka-nuegan oginmaloed, degine, nabir-sedmalaga suarmargi nasikmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","”Aarón, degi, e-masmala, bela anse-goled-neggi, degi, anse-goled-neggi-ibmar-ebulemalad-bukwad bela morgi anwisale, geb agi Israel-dulemar naega guakwagusale, Coat-wagan nonimaloed, a-ibmarmar sedmalagar. Degi-inigwele, ibmar-angadga-gusadi na e-argangi ebugosurmalad. Ar ebusmalale, burgwemaloed. Bela we-ibmarmar dulemarbo-an-ambikued-neggi-bukwadi, Coat-wagan sedmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","”Eleazarʼdi, dule-irwa-anse-goled Aarónʼye-nugad-e-machid. We-Eleazarʼde gwalluga gwalludii-baloedid, degi, ina-wawadikmalad, ibmar-gwag-gusgu-ukleged, degine, olivo-gwallu-ibmarmargi-eolegega-ebuleged dakoedid. Deginbali, Eleazar bela anse-goled-neg, degine, agi bela-ibmarmar-bukwad dakbaloed. Deginbali, bela agi-ibmarmar-ebulesimalad dakbaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Bab-Jehová Moisésʼga, degi, Aarónʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Leví-wagan-abargi, melle Coat-wagan-obelogega be imako. ");
INSERT INTO cuk_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Coat-wagan ibmar-anga-nugsalesmaladse nonisogele, dula-gudigumalagala, melle burgwemalaga, weyob be imako. ”Aarón, degi, e-masmala Coat-waganga sogoed, ibu-ibmar imakmaloe, degi, ega sogbaloed, ibu-ibmarmar sedmarbaloe. ");
INSERT INTO cuk_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","”Aarón, degi, e-masmala ibmar-anga-nugsalesmalad anwelenaile, Coat-wagan dogosurmalad, degine, bipisaale dakosurmarbalid. Ar dogmalale, burgwemaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Bab-Jehová Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Gersón-wagan, e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba be ebiso. ");
INSERT INTO cuk_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Bela machergan birga-dulagwen-gakambe-nikamalad (30), degi, birga-dulabo-gakambe-nikamaladse (50), dulemar-anbo-ambikued-neggi sunna-arbamaloed be ebiso. ");
INSERT INTO cuk_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gersón-wagana we-ibmarmar-seedgi arbamaloed: ");
INSERT INTO cuk_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Anse-goled-neg-sunna-seleged, a-e-mor-dummagan, Dulemar-anbo-ambikued-neg-e-mormar-anwemalad, ibdurgan-uka-nuegan-a-neggi-akinnarmamaid, dulemar-anbo-ambikued-neg-yawagakgi mor-dummad-naid, ");
INSERT INTO cuk_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","mor-dummagan-bela-neg-imba-ebirnanaid sedmarbaloed. Degi, ibmar-ogumakar-ukleged-ailase mor-dummagan warmaknaid, degine, anse-goled-neg-yawagakgi mor-dummagan-warmaknanaibalid sedmarbaloed. Geb a-e-dubmar, degi, bela agi-ibmarmar-ebulemalad sedmarbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","”Gersón-wagan bela na e-arbamaladgi, na ibmar semamaidgindibe, anse-goled-neggi arbananaidgindibe, bela Aarón, degi, e-masmala-sogedba ibmar imakmaloed. Gersón-waganga be sogoed, we-ibmarmar sedsokarmalale, nue salakarmaloye. ");
INSERT INTO cuk_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Gersón-wagan dulemar-anbo-ambikued-neggi weyob ibmar imakmaloed. Amarde, Itamar-ibmar-sogedba arbanai gumaloed. We-Itamarʼde, Aarón-e-machid. Aarónʼdi, dule-irwa-anse-goledid.” ");
INSERT INTO cuk_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Bab-Jehová Moisésʼga sogdebalid: “Merari-wagan, e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba, be ebiso. ");
INSERT INTO cuk_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Bela machergan birga-dulagwen-gakambe-nikamalad (30), degi, birga-dulabo-gakambe-nikamaladse (50), sunna dulemar-anbo-ambikued-neggi arbamaloed be ebisoed. ");
INSERT INTO cuk_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","We-dulemar dulemar-anbo-ambikued-neggi urgomar-ebulesad sedmaloed. A-urgomardina, wemalad: E-suarmar, e-buarmar, e-sigmalad, ");
INSERT INTO cuk_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","galu-ebirar buarwar-gwigwichid, e-sigmalad, e-bargamalad, e-dubmar, degi, bela e-ibmar-abelemalad sedmarbaloed. ”Dule-war-wargwenga be sogoed, ibu-ibmarmar sedmaloe. ");
INSERT INTO cuk_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","We-arbaedi Merari-wagan, na e-dadgan-e-dadganba, degisadegu na e-arbaedgi dulemar-anbo-ambikued-neggi arbamaloed. Itamar-ega-igar-ukedba arbamaloed. We-Itamarʼde Aarón-e-machid. Aarónʼdi, dule-irwa-anse-goledid.” ");
INSERT INTO cuk_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moisés, Aarón, degi, Israel-dulemar-danar-danar-bukwamalad-e-dummaganmala, Coat-wagan, na e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba ebichismarsunnad. ");
INSERT INTO cuk_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Bela machergan birga-durgwen-gakambe-nikamalad (30), degi, birga-durbo-gakambe-nikamaladse (50) bela sunna Bab-Dummad-dulemarbo-ambikued-neggi-arbamaloed ebichilesad. ");
INSERT INTO cuk_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Weyob Coat-wagan na e-dadgan-e-dadganba ebislesmargu, milibo gaka dulataled-ilagugle gaka dulabo-gakambe (2,750) mergu daklealid. ");
INSERT INTO cuk_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Weyob bela Coat-wagan e-dadgan-e-dadganba ebislesmalad. A-dulemarde bela sunna Bab-Dummad-dulemarbo-ambikued-neggi arbamaloed. Weyob Moisés, degi, Aarón, Coat-wagan ebichismalad. Bab-Jehová-Moisésʼga-igar-uksadba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Moisés, Aarón, degi, Israel-dulemar-danar-danar-bukmalad-e-dummaganmala, Gersón-wagan e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba ebichismarmogad. ");
INSERT INTO cuk_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Bela machergan birga-durgwen-gakambe-nikamalad (30), degi, birga-dulabo-gakambe-nikamaladse (50), sunna Bab-Dummad-dulemarbo-ambikued-neggi arbanonimaloed ebichilesad. ");
INSERT INTO cuk_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Weyob Gersón-wagan e-dadgan-e-dadganba, degine, na e-gwenad-e-gwenadganba ebislesmargu, milibo gaka dulataled-ilanergwa gaka dulagwen-gakambe (2,630) mergu daklealid. ");
INSERT INTO cuk_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Weyob bela Gersón-wagan, e-dadgan-e-dadganba, ebislesmalad. A-dulemarde bela sunna Bab-Dummad-dulemarbo-ambikued-neggi arbamaloed. Weyob Moisés, degi, Aarón, Gersón-wagan-ebichismalad. Bab-Jehová-Moisésʼga-igar-uksadba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Moisés, Aarón, degi, Israel-dulemar-danar-danar-bukwamalad-e-dummaganmala, Merari-wagan, na e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba ebichismarmogad. ");
INSERT INTO cuk_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Bela machergan birga-durgwen-gakambe-nikamalad (30), degi, birga-dulabo-gakambe-nikamaladse (50) sunna Bab-Dummad-dulemarbo-ambikued-neggi arbanonimaloed ebichilesad. ");
INSERT INTO cuk_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Weyob Merari-wagan na e-dadgan-e-dadganba ebislesmargu, milipaa gaka dulataled-ilabo (3,200) mergu daklealid. ");
INSERT INTO cuk_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Weyobi Moisés, degi, Aarón, bela Merari-wagan, na e-dadgan-e-dadganba-mergue ebichismalad. Amar Bab-Jehová-Moisésʼga-igar-uksadba imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Moisés, Aarón, degi, Israel-girmar-dummagan bela Leví-wagan na e-dadgan-e-dadganba, na e-gwenad-e-gwenadganba ebichismaladi, ");
INSERT INTO cuk_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","machergan birga-durgwen-gakambe-nikamalad (30), degi, birga-durbo-gakambe-nikamaladse (50) sunna Bab-Dummad-dulemarbo-ambikued-neggi arbanonimaloedi, degine, sunna we-negsemaloedi, ");
INSERT INTO cuk_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","bela we-dulemar milibaabak gaka dulataled-ilatar gaka dulabake (8,580) mergu daklealid. ");
INSERT INTO cuk_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Moisés, Bab-Jehová-igi-ega-igar-uksadba, dulemarga ibmar-imaked-igar uksad, degine, ibmar-sedmaloed-igar uksabalid. Moisés, Bab-Jehová-ega-igar-uklesadba, weyob dulemar-ebichisad. ");
INSERT INTO cuk_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Israel-dulemarga be soge: ‘Bemar-danar-danar-bukwadgi bela Israel-dulemar ukagi-boni-yaa-akar-akar-nikamalad be onomalo. Dule-na-e-burba-daksamalad, degi, dule-burgwisad-ebusmalad, be onomarbalo. Ar ade, dule-burgwisad-ebussoggu, swilidiksuli gunonikid. ");
INSERT INTO cuk_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Bemar-bukwadgi dule-boni-nikamalad, omedibe, igi, machereddibe, be onomaloed. Adi, wemar melle bemar-bukwadgi an-bemar-abargi-maid-neg oichogegar.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israel-dulemala Bab-Jehová-Moisésʼga-sogsadyobi imaksamalad: Dulemar-boni-nikamalad emar-bukwadgi onosmalad. ");
INSERT INTO cuk_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Bab-Jehová Moisésʼga sunmakdebalid, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Israel-dulemarga be soge: ‘Dule-machereddibe, igi, omedibe, dule-baid-ibe-ibmar-oakalosale, we-dule angi nue dummad-nosdo. Degisoggu, nue-odurdakleged ega igar mego. ");
INSERT INTO cuk_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","We-dulede e-isgusad na dukin barsogo. Degine, dule-baidgi-nosad-ular, ibmar-oakalosawilub ega ibmar-uko. A-ukine, ibmar-atargi gwensak napi ega ukbalo. ");
INSERT INTO cuk_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ar dule-naibi-gusad bato burgwisale e-gwenad-walikagwad-satele, ega-ibmar-uklegoenad anga uklego, degi, dule-irwa-anse-goledga uklemogo. Deginbali, dule-aimar-naibisasadi, e-isgusad-ular, sibad-wawaad-machered-ukbalo, adi, dule-irwa-anse-goled we-ibmar anga ogumakar ukegar. ");
INSERT INTO cuk_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","” ’Israel-dulemar bela-ibmarmar-dule-irwa-anse-goledse-sedmaloedi, dule-irwa-anse-goledgadga guo. ");
INSERT INTO cuk_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ar dule anga ibmar-uksardi, we-ibmar na egadga guo. Ar dule-irwa-anse-goledga uksardi, adi, we-ibmar we-dule-irwa-anse-goledgadga guo.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Bab-Jehová Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Israel-dulemarga be sunmak, ega be soge: ‘Binsa sogmalo, ome-gwensak abirgunagwar-gudiid-igargi yoledsunnad, ");
INSERT INTO cuk_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","we-ome e-sui-dikarba dukuar machered-baidbo negsichigi yoledsunnad, degi, bipisaale a-ome negsichigi-yolenai daklessulid. ");
INSERT INTO cuk_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","” ’Degi-inigwele, e-sui e-omegi nue-nobe-itogele, degi, egi dodosye binsaele, igi amba e-ome egi nossurdibe, ");
INSERT INTO cuk_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","e-sui dule-irwa-anse-goledse e-ome-sedoed. Agi, madubur-cebadaʼye-nugad, nibiratar e-omegi nobed-ular anga we-ibmar ukoed. Ar we-ibmar, omegi-nobe-itoged-ular uklenaisoggu, we-ibmar-birgine olivo-gwallu eogosulid, degine, ibmar-wawadikmalad eogosurbalid. Deginbali, we-ibmar-uklesadi, isgusad wisguegalad. ");
INSERT INTO cuk_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","” ’Dule-irwa-anse-goled, an-asabin we-ome ogwisoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Geb degidgine, dule-irwa-anse-goled dii-nued-ditirmakaled napsa-noggi eogoed. Geb anse-goled-neg-sunna-seleged-e-napa-buru weoed, agine, we-olli dii-ebo oburoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Geb degi, dule-irwa-anse-goled, we-ome an-asabin ogwisguoed, geb ome-e-sailagia ei esikoed, agine, ome-argangi ome-wisguega-nobedba-ibmar-uklegaledi, sioed. Dule-irwa-anse-goleddi, e-argangine dii-gagbid gani-gwisguoed. We-dii-gagbidye dule-ukabsaed-diid. ");
INSERT INTO cuk_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Geb degidgine, dule-irwa-anse-goled ome ega ise-sogar-imaked saoed. A-omega sogoed: Dule bebo gabissulile, degine, be-suigi be nossulile, degine, egi be dodossulile, we-dii-gagbireged-iwir-dule-imakedgi be ollorguoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ar be-suigi be nosardi, egi be dodosardi, machered-baidbo be akar-akar-gusardi, be ukabsalegoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","” ’Degidgine, dule-irwa-anse-goled we-ome-ukabsaoed, weyob ega sogoed: Bab-Jehová iwiguega be-imaksun, degine, be-dulamar-abargi dulemar sunnasuli-be-dakega be-imaksun. Degine, we-dii-gagbid anagan-nikusuli be-imaksun, deginbali, saban-muega be-imakbarsun. ");
INSERT INTO cuk_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","We-dii-dule-iwisaed begi ubodele, be-saban odunguega-imaksun, geg-anagan-nikuega be-imaksun. ” ’Ome, dule-irwa-anse-goled-abin sogdoed: ¡Ar deyob gudo! ¡Ar deyob gudo! ");
INSERT INTO cuk_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","” ’Dule-irwa-anse-goled iwisalesad-soglesad, gardagi narmakoed. Geb degine, a-gardagi-narmakaledi, dii-gagbiregedgi elioed. ");
INSERT INTO cuk_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Geb a-dii-gagbiregedgi ome-ogoboed. Adi, ome nue-dummad-wiledii guegar. ");
INSERT INTO cuk_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","” ’Geb a-sorbali, ome dule-irwa-anse-goledga ibmar-nobedba-uklenaid ukoed. Geb degine, dule-irwa-anse-goled, an-asabin ibmar-orosgi-dakleged-cebadaʼye-nugad bana-bana imakoed. Agine, ibmar-ogumakar-ukleged-ailase sedoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Degine, dule-irwa-anse-goled argan-nukgwen orosgi-dakleged-cebada suoed. We sogleged, ebinsalegegaye. Geb degi, we-ibmar, ibmar-ogumakar-ukleged-aila-birgi ogumakoed. ” ’Dule-irwa-anse-goledi, we-diigi ome-ogoboed. ");
INSERT INTO cuk_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ar we-ome, e-suigi nosale, we-dii-dule-iwisaed gobogu, ome-e-saban mudoed, geg-bar-mimmi-bake gudoed. Deyobi, we-ome na e-dulemar-abargi iwilesgudii gusunnoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ar we-ome e-suigi nossulile, galagwensuli-gussulile, adi, iwiguosulid, degisoggu, akar-guosulid sunna mimmi-bake guoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","” ’Ome e-sui-dikarba nosa-sogele, e-suigi dodosale, weyobi nobgued-igar ega mai guoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Machered nue e-omegi nobe-itoalile, an-asabin e-ome-sedoed. Geb degine, dule-irwa-anse-goled we-igar-maidba ega imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Ome na e-isgusadba sabsur-odurdaklegodo, machereddi nosdeeye egi soglegosulid.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Israel-dulemarga be sunmak, ega be soge: ‘Machered-gwensak-sokardibe, igi, ome-gwensak-sokardibe, Bab-Jehováʼgarbi an ibmar-imakdii guega Bab-Jehováʼga bela an-san an na ukoye, we-dule Nazareoʼye soglegoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Deyob na imakele, vino gobosulid, degi, sisamar gobosurbalid. Deginbali, vinagre-vinoʼgi-danikid, degi, vinagre-sisamargi-danikid, gobosurbalid. Deginbali, uva-nis gobosurbalid, degine, uvaʼmar, degi uva-odinnolegarmalad gunnosurbalid. ");
INSERT INTO cuk_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Dule Nazareoʼga-gudiid-ibagangine, e-ibagan-sogsad-berguedse bipisaale, uva-san, e-gwag, degi, e-ukase-bakale, gunnosulid. ");
INSERT INTO cuk_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","” ’Ar dule na Nazareoʼga-gudiidgine, e-ibagan-sogsad-berguedse sailagia sikosulid. Unnila Bab-Jehováʼgarbi-ibmar-imakdii guoed, degine, e-sailagia suitii imakoed, ar ade, e-sailagia sikosulid. Geb ibagan-bergunonikile, a-sorba, sunna na e-sailagia sikoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","” ’A-ukinbali, a-dule Bab-Jehováʼga na-san-uksad-ibagangine, dule-burgwaledse warmakosurbalid. ");
INSERT INTO cuk_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Amba e-babdibe, igi, e-nan burgwisdibe, igi, e-urbadibe, igi, e-ia-burgwisdibe, igi, e-bundibe, ase-bakale, ese warmakosulid, ar ade, Bab-Jehováʼgarbi-ibmar-imakdiguega Bab-Jehováʼga na san-uksa gudiid. ");
INSERT INTO cuk_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Dule Bab-Jehováʼga na san-uksad-ibagangine, unnila Bab-Jehováʼgarbi ibmar-imakdii guoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","” ’Dule-Bab-Jehováʼga-na-san-uksad-walik, dule-wargwen ukiar burgwenonikile, we-dule-Nazareoʼga-gudiid-e-igar-maid oichogoed. Degisoggu, ibagugledgi (7), na san-uruked-e-ibagan-mosale, non-swirii imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Degine, ibabaabakadgi (8) sapur-nuu-gwabo, igi, wagnuu-e-mimmi-gwabodibe, sedagoed. Bab-Dummad-dulemarbo-ambikued-neg-yawagakse, dule-irwa-Bab-Dummadse-goledse sedagoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","” ’Ar dule-Bab-Jehováʼga-na-san-uksad, dule-burgwisad-ular isgunonisoggu, we-nuu-gwabo-ukoedi, dule-irwa-Bab-Dummadse-goled, we-nuu-gwagwen dule-isgued-osulogega Bab-Dummadga ukoed. Nuu-baiddi, ogumakar Bab-Dummadga ukbaloed. A-ibagangine, gannar na e-sailagia osuguoed, Bab-Dummadga sogegar, gannar an bega an-san ukbarye. ");
INSERT INTO cuk_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Geb degi, we-dule Bab-Jehováʼga-na-san-uksad-ibagangi, Bab-Jehováʼgarbi nanadii guoed. E-isgusad-ular, sibad-wawaad-sapingwagwad-birgagwen-nikad Bab-Dummadga sedagoed, adi, e-isgusad ega osulogegar. Idu Bab-Jehováʼgarbi-arbadigusad-ibagan bar ebislegosulid. Ar dule-burgwisadi, ei ibagan oichossoggu, e-ibagan gannar onodoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","” ’Weyobi, dule-Nazareoʼga-gudiid e-ibagan-sogsad bergunonikile, ega-igar-maidba imakoed. Bab-Dummad-dulemarbo-ambikued-neg-yawagakse na dagoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Agi, Bab-Jehováʼga ibmar-ukleged sedagoed: Sibad-wawaad-sapingwagwad-birgagwen-nikad uknonikoed. We-sibad-wawaad swilidik, gwen boni-nikasuli ogumakar-uklegega senonikoed. Degine, sibad-wawaad-ome-birgagwen-nikad-swilidikid, gwen boni-nikasulid, e-isgued-anar ukega senonibaloed. Deginbali, dule gwenatigwar-guega, sibad-wawaad-machered-swilidikid gwen boni-nikasulid ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Deginbali, Nazareo-dule ibmar-gwag-Bab-Jehováʼga-ukleged, degine, e-gobed-ega-uklebalid, sedabaloed. Deginbali, garba-bipigi madu-inasulid, sedabaloed. We-madude, madu-ologana madubur-nuedgi olivo-gwalluba-omukualedid, degine, madu-matargana olivo-gwallugi-magaledid. We-ibmarmar, we-Nazareo-dule sedagoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","” ’Geb degine, dule-irwa-Bab-Dummadse-goled, we-Nazareo-dulega-isgued-osulogega, we-ibmar Bab-Jehováʼga ukoed. A-ukinbali, we-ibmar ogumakar Bab-Jehováʼga ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Deginbali, gwenatigwar-guega, sibad-wawaad-machered oburgwebaloed. We-sibad-wawaadba-mesa garba-bipigi-madu-inasuli-bukwad dule-irwa-Bab-Dummadse-goled Bab-Jehováʼga ukbaloed. Deginbali, ibmar-gwagmar, degi, ibmar-eolemalad Bab-Jehováʼga ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","” ’Geb degidgine, dule-na-Bab-Jehováʼga-san-uksad, Bab-Dummad-dulemarbo ambikued-neg-e-yawagak-walik na-e-sailagia ioed. Geb agine, e-sailagia soogi-ogumakega Bab-Dummadga-ibmar-uklenaid-urba soo-gasiidgi urboed. We-ibmarde gwenatigwar-guega uklenaid. ");
INSERT INTO cuk_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","” ’Dule-Bab-Jehováʼga-san-uksad-sailagia-siksad-sorbali, dule-irwa-Bab-Dummadse-goled sibad-wawaad-machered-e-gukin-matar-dualed suoed, degine, garbagi madu-olo-inasulid-siid, madu-matar-e-inasulid-siid subaloed. Agi, geb Nazareo-dulega ukoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Geb we-ibmar-ukoedi, gannar suoed. Geb dule-irwa-Bab-Dummadse-goled, bana-bana-imakar Bab-Jehováʼga ukoed. We-ibmar dule geg yogasaar sued, unnila dule-irwa-Bab-Dummadse-goledga uklegoed. Deginbali, sibad-wawaad-e-binasgar, degi, e-dua Bab-Jehováʼga-uklearbalid dule-irwa-Bab-Dummadse-goledga uklebaloed. Geb deyobi, a-sorbali, dule-Bab-Jehováʼga-na-san-uksad, sunna vino-gobe gunonisunnoed. ");
INSERT INTO cuk_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","” ’Dule Bab-Jehováʼga-san-uksad-Nazareoʼye-bileged Bab-Jehováʼgarbi-ibmar-imakdigubiele, weyob ega igar-mai guoed. Weyobi, Bab-Jehováʼga ibmar-ukoed, degi, na ibmar-nikadba ukbaloed. Dule-Bab-Jehováʼga-na-san-urmaksadi igar-maidba na imakergebed, imaksuli guosulid, imakedsegad.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Bab-Jehová Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aarónʼga, degi, e-masmalaga be sunmak. Ega be soge: ‘Israel-dulemargi ise-nued be sunmakalile, weyobi, be sogoed: ");
INSERT INTO cuk_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Bab-Jehová ise-nued begi binsadii gusun, nue be-akwedii gusun. ");
INSERT INTO cuk_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Bab-Jehová bela-bela nued be-dakdii gusun. Bela-bela nue-be-sabgudii gusun. ");
INSERT INTO cuk_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Bab-Jehová nued-begi-binsaed bega-oyodii gusun. Degi, ulubgi bogidikid bega ukdii gusun.’ ");
INSERT INTO cuk_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","”Weyobi Aarón, degi, e-masmala, Israel-dulemarga an-nuggi sogoed. Geb degine, Israel-dulemargi nued an binsaoed.” ");
INSERT INTO cuk_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Moisés Bab-Dummadse-goled-neg-seleged-sobsad-obelosgu, ina-wawadikid a-neggi bomi-bomi imaksad. Degine, bela agi ibmarmar-bukwad Bab-Dummadga nug-imaksad. Agi, we-neg Bab-Dummadgarbi-ebulegega nug-imaksasunnad. Geb ibmar-ogumakar-ukleged-ailagi ina-wawadikid egi bomi-bomi imaksabalid, degine, bela ailagi-ibmarmar-ebulemalad Bab-Dummadga nug-imaksabalid. Agi, we-ibmar bela Bab-Dummadgarbi-ebulegega nug-imaksad. ");
INSERT INTO cuk_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Geb degine, Israel-dulemar-e-dummagan, a sogleged, na e-gwenad-e-gwenadgan-e-dummaganye, amala, e-dadgan-dummaganba-dulemar-ebislesmalad-e-dummagan gumalad. Amala, Bab-Jehováʼga ibmar uknonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","We-ibmarmar senonimalad: Dummagan ebo-ebo ur-napagined-ibmar-seed-wargwen senonimalad, degine, dummagan-iliba moli-bebe-nikad-alugwasualed-war-wargwen senonimalad. Degisoggu, bela ur-napagined-ibmar-seed walanergwasundo (6), degine, moli-bebe-nikad-alugwasualed warambe-gakabosundo (12). We-ibmarmala, Bab-Jehováʼga-ukega Bab-Dummadse-goled-neg-sunna-selegedse senonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“We-ibmarmar-bega-uknanaid e-abin be sue, adi, dulemar-anbo-ambikued-neggi ebulegegar. We-ibmarde Leví-wagan-baiganga, na e-ibmar-ebulegedba ega be ukoed.” ");
INSERT INTO cuk_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Geb Moisés, we-urmar, degi, moli-alugwasuarmalad sussunnad. Geb degine, Leví-wagan-baiganga uksasunnad. ");
INSERT INTO cuk_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Gersón-e-waganga urmar-napagined-ibmar-seed walabo ega uksad, degine, moli-bebe-nikad-alugwasualed walabake ega uksabalid, arbagedgi-ibmar-abemaladba ebugegar. ");
INSERT INTO cuk_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Merari-e-waganga urmar-napagined-ibmar-seed walabake ega uksad, degine, moli-bebe-nikad-alugwasualed walabaabak (8) uksabalid, arbagedgi ibmar-abemaladba ebugegar. We-Leví-wagan-baigande dule-irwa-Bab-Dummadse-goled-Aarón-machi-Itamar-sogedba arbananai gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Moisés, Coat-wagangardi we-ibmarmar uksasulid, ar ade, wemala e-gukingi ibmarmar-Bab-Dummadgadga-gusadi, semamai gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ibmar-ogumakar-ukleged-aila Bab-Dummadga nugsalesgu, we-dummagan ibmar-ogumakar-ukleged-aila-asabin, Bab-Dummadga ibmarmar uksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ar ade, Bab-Jehová, Moisésʼga sogsagusad: “Ibmar-ogumakleged-aila-anga-nugsalesadga-ibmar-ukegale, iba-ibagwengi dummagan-war-wargwen anga ibmar ukoed.” ");
INSERT INTO cuk_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Iba-gebe-onodedgine, Aminadab-machi-Naasón-inse Bab-Jehováʼga ibmar senonikid. We-Naasónʼde, e-dad-dummad-Judáʼgi danikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Naasón Bab-Jehováʼga-ibmar-uksadi, wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Aminadab-machi-Naasón, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ibabogi, Zuar-machi-Natanael, Bab-Jehováʼga ibmar-senonimogad. We-Natanaelʼde dad-dummad-Isacarʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Natanael Bab-Jehováʼga-ibmar-uksadi, wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Zuar-machi-Natanael, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ibapaagine, Helón-machi-Eliab, Bab-Jehováʼga ibmar senonimogad. We-Eliabʼde dad-dummad-Zabulónʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","We-Eliab Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Helón-machi-Eliab, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ibabakegine, Sedeur-machi-Elisur, Bab-Jehováʼga ibmar senonimogad. We-Elisurʼde dad-dummad-Rubénʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","We-Elisur Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Sedeur-machi-Elisur, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ibatargine, Zurisadai-machi-Selumiel, Bab-Jehováʼga ibmar senonimogad. We-Selumielʼde dad-dummad-Simeónʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","We-Selumiel Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Zurisadai-machi-Selumiel, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ibanergwadgi (6), Deuel-e-machi-Eliasaf, Bab-Jehováʼga ibmar senonimogad. We-Eliasafʼde dad-dummad-Gadʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","We-Eliasaf Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Deuel-machi-Eliasaf, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ibagugledgi (7), Amiud-machi-Elisama, Bab-Jehováʼga ibmar senonimogad. We-Elisamaʼde dad-dummad-Efraínʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","We-Elisama Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Amiud-machi-Elisama, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ibabaabakadgi (8), Pedasur-machi-Gamaliel, Jehováʼga ibmar senonimogad. We-Gamalielʼde dad-dummad-Manasésʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","We-Gamaliel Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Pedasur-machi-Gamaliel, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ibabakebakadgi (9), Gedeoni-machi-Abidán, Bab-Jehováʼga ibmar-senonimogad. We-Abidánʼde dad-dummad-Benjamín-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","We-Abidán Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Gedeoni-machi-Abidán, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ibambegi (10), Amisadai-machi-Ahiezer, Bab-Jehováʼga ibmar senonimogad. We-Ahiezerʼde dad-dummad-Danʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","We-Ahiezer Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Amisadai-machi-Ahiezer, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ibambe-gakagwensakgi (11), Ocrán-machi-Pagiel, Bab-Jehováʼga ibmar senonimogad. We-Pagielʼde dad-dummad-Aserʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","We-Pagiel Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Ocrán-machi-Pagiel, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ibambe-gakabogi (12), Enán-machi-Ahira, Bab-Jehováʼga ibmar senonimogad. We-Ahiraʼde dad-dummad-Neftalíʼgi-danimalad-e-dummadid. ");
INSERT INTO cuk_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","We-Ahira Bab-Jehováʼga-ibmar-uksadi wemalad: Mani-bate-gwagwen, dulanergwa-gakambe-aidikued (130) senonikid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. Degine, mani-nog-dummad, dulapaa-gakambe-aidikued (70) senonibalid. E-aidikuedi, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobid. A-ibmargi, madubur-olivo-gwalluba-omukuar Bab-Dummadga-uklegedi, Bab-Dummadga-ukega senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Degine, or-wesar-dummad gagwen, mani-sibugan-gwaambe-aidikue-wilub (10) senonibalid. A-or-wesargi, ina-wawadikid ena senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Deginbali, Bab-Dummadga ibmar-ogumakar-ukega we-ibmarmar senonibalid: Moli-bebe-nikad-sapingwagwad, wargwen. Sibad-wawaad-machered, wargwen. Sibad-wawaad-sapingwagwad-birgagwen-nikad, wargwen. ");
INSERT INTO cuk_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Deginbali, e-isgued-osulogega, sibad-machered wargwen, Bab-Dummadga-ukega senonibalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Deginbali, gwenatigwar-guega, we-ibdurgan senonibalid: Moli-bebe-nikad-alugwasualed, warbo. Sibad-wawaad-machered, walatar. Sibad-machered, walatar. Degi, sibad-wawaad-sapingwagwad-birgagwen-nikad, walatar senonikid. We-ibmarmala, Enán-machi-Ahira, Bab-Jehováʼga senonikid. ");
INSERT INTO cuk_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Weyobi, Israel-dulemar-e-dummagan Bab-Jehováʼga ibmar-ogumakar-ukleged-aila nug-imaknanaigusgu ibmarmar senonigusmalad: Mani-bate, gwaambe-gakabo (12), mani-nog-dummad, gwaambe-gakabo (12), or-wesar, warambe-gakabo (12) senonigusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Mani-bate gwa-gwagwengi, mani-dulanergwa-gakambe-aidiku (130) nanaed. Degine, nog-dummad gwa-gwagwengi, mani-dulapaa-gakambe-aidiku (70) nanaed. Bela batemar, degine, nogmar, Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobi, mani-nibir-milibo gaka dulataled-ilabake-aidiku (2,400) daklealid. ");
INSERT INTO cuk_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Or-wesar-warambe-gakabo (12) egi ina-wawadikid-ena-senonimaladi, a-or-wesar-ga-gagwengi mani-ambe-aidiku (10) nanaed. Bela or-wesar Bab-Dummadse-goled-neggi mani-aidikued-ebislegedyobi, mani-nibir-dulanergwa-aidikue (120) gussundo. ");
INSERT INTO cuk_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Bab-Jehováʼga ibdurgan-ogumakar-ukega senonimaladdina, weyob mergued: Molimar-bebe-nikmalad-sapingwagwad, warambe-gakabo (12), sibad-wawaad-machered, warambe-gakabo (12), sibad-wawaad-sapingwagwad-birgagwen-nikad, warambe-gakabo (12). We-sibad-wawaad-birgagwenadba ibmar-gwag-ukleged senonimarbalid. Degine, isgued-eliega sibad-machered, warambe-gakabo (12) senonimarbalid. ");
INSERT INTO cuk_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Gwenatigwar-guega, ibdurgan-senonimalad, weyob mergued: Molimar-bebe-nikad-alugwasuarmalad, waladulagwen-gakabake (24), sibad-wawaad-machered, waladulapaa (60), sibad-machered, waladulapaa (60), degine, sibad-wawaad-sapingwagwad-birgagwen-nikad, waladulapaa (60) mergued. We-ibmarmala ibmar-ogumakar-ukleged-aila-nug-imaklenaigusgu Bab-Jehováʼga uklesad. ");
INSERT INTO cuk_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Moisés Bab-Jehová-ebo-sunmakega, Bab-Jehová-dulemarbo-ambikued-negse dogdegu, Moisés, Bab-Jehová-ega-sunmake itosad. Bab-Jehová-Dulemarbo-Igar-Mesisad-Ulu-e-atued-birgi, baliwitur-warbo-querubinʼye-nugad-gwichimalad-imbagi ega sunmake itosad. Weyobi, Bab-Jehová Moisés-ebo sunmakdaed. ");
INSERT INTO cuk_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Aarónʼga be soge: ‘Gwallu-gwagugled (7) be ogaalile, e-siedgi be sialile, e-gwallu-gaedi asabin be obiroed, adi, e-mee-gaedi asabinbi gaegar.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aarón, Bab-Jehová-Moisésʼga-sogsadyobi imaksad: Gwallu-sied-birgi gwallumar asabin-nasiksad, adi, e-mee-gaedi asabinbi gaegar. ");
INSERT INTO cuk_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Gwallu-sied bela olobiid, e-mali, degine, e-dutumar mardogi-binna-sarsolegar sobaled. Ar igi Bab-Jehová Moisésʼga oyosa, deyobi, inniki gwallu-sied sobaled. ");
INSERT INTO cuk_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Bab-Jehová Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Israel-dulemar-abargi Leví-wagan-baigan bachikii be anga urbo, degine, a-dulemar be anga abaluko. ");
INSERT INTO cuk_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Be Leví-wagan-baigan-abalukega weyob be imako: Isgued-eliega-dii-ebuleged be egi bomi-bomi imakoed, degi, bela e-abagangi-siga-nikad enioed. Degine, na e-mormar enukmaloed. Weyob imaksale, geb na san-swilidik gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Geb a-sorbali, moli-bebe-nikad-machered-sapingwagwad sumaloed, degine, ibmar-gwag-uklegedi madubur-nued olivo-gwalluba-bato-omukualed, sumarbaloed. Deginbali, bedina, dule-isgued-eliega moli-bebe-nikad-sapingwagwad-baid anga ukega be suoed. ");
INSERT INTO cuk_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Geb degidgine, Leví-wagan-baigan dulemar-anbo-ambikued-neg-asabin be sedoed. Agine, bela Israel-dulemar a-asabin-ambikued be imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Be, Leví-wagan-baigan Bab-Jehová-asabin senonikoed, geb Israel-dulemar we-Leví-wagan-baigangi na e-argan mesmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Geb degidgine, Aarón Israel-dulemar-nuggi a-Leví-wagan-baigan anga ibmar-bana-bana-ukledaedyobi, imakoed. Weyobi, Leví-wagan-baigan Bab-Jehováʼga-arbaega gudii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","”Geb a-sorbali, Leví-wagan-baigan moli-bebe-nikad-sapingwagwadmar-e-nonogi e-arganmar mesoed. Geb agine, an amarga isgued-eliega, bedi moli-bebe-nikad-wargwen anga be ukoed. Moli-bebe-nikad-baiddina, ogumakar anga be ukoed. ");
INSERT INTO cuk_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Geb degidgine, be, Leví-wagan-baigan Aarón-asabin, degi, e-masmala-asabin, be urboed. Geb degine, anga ibmar-bana-bana-imakledaedyobi, Leví-wagan-baigan anga be nugsaoed. ");
INSERT INTO cuk_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Weyobi, Leví-wagan-baigan Israel-dulemar-abargi bachikii anga be imakoed, adi, we-Leví-wagan-baigan angadga guegar. ");
INSERT INTO cuk_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","”Geb degine, be, bela Leví-wagan-baigan-uruksad-sorbali, degine, anga-ibmar-bana-bana-imakledaedyobi, be anga imaksad-sorbali, geb wemar dulemar-anbo-ambikued-neggi arbanonimaloed. ");
INSERT INTO cuk_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ar ade, Israel-dulemar-abargi, bela Leví-wagan-baigan anga nugsalearmaladid. We-Leví-wagan-baigan Israel-masmala-gebesailagined-anar an susad. ");
INSERT INTO cuk_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ar ade, bela Israel-dulemar-abargi masmala-gebe-gwalulemalad angadid. Duledibe, ibdurgandibe, bela wemala angadid. Egipto-dulemar-e-masmala-sailaginmalad an ogilosgua, we-ibmarmala bachikii angadga-guega an na imaksad. ");
INSERT INTO cuk_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","”Degi-inigwele, Israel-masmala-gebegwalulesmalad-ular, Leví-wagan-baigan an susad. ");
INSERT INTO cuk_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","We-Leví-wagan-baigan, Aarónʼga, degi, e-masmalaga, ibmar-binsa-ukledaedyobi an ega uksad, adi, dulemar-anbo-ambikued-neggi arbamalagar. Leví-wagan-baigan Israel-dulemar-anar Bab-Dummad-dulemarbo-ambikued-neggi arbamaloed, degi, emarga isgued-elileged-igar imakoed, adi, melle Israel-dulemar anse-goled-neg-asabin-nonikoedgi boni-dummad-nika guegar.” ");
INSERT INTO cuk_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Deyobi, Moisés, Aarón, degine, bela Israel-dulemar-danar-bukwamaladi, Bab-Jehová-Moisésʼga-ibmar-sogsadba, Leví-wagan-baigan-imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Leví-wagan-baigan na abaluksamalad, degine, bela na e-mormar enuksamarbalid. Geb agine, Aarón Bab-Jehováʼga we-Leví-wagan-baigan ibmar-bana-bana-imakledaeyobi uksad, degine, we-dulemar-isgued-eliega ibmar-uksad, adi, we-dulemar swilidik guegar. ");
INSERT INTO cuk_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Geb a-sorbali, we-Leví-wagan-baigan Bab-Dummad-dulemarbo-ambikued-neggi, Aarón-wagab, degi, e-masmala-wagab arbananai gusmalad. Ar igi Bab-Jehová Moisésʼga igar-uksa, deyobi, Aarón, degi, e-masmala, Leví-wagan-baigan-imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Geb deginbali, Bab-Jehová Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Weyob Leví-wagan-baiganga igar maiguoed: ‘Leví-wagan birga-durgwen-gakatar-nikad (25), degine, birga-durgwen-gakatar-obine-nikamaladi (25+), sunna dulemar-anbo-ambikued-neggi arbamaloye. ");
INSERT INTO cuk_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","We-Leví-wagan-baigan birga-dulabo-gakambe-nikunonikile (50), e-arbaedgi noergebed. A-sorbali, e-arbaed bar imakosurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","We-Leví-wagan-baigan anbo-ambikued-neggi sunna e-gwenadgan-bendakega gumaloed, e-sunnaddi bar we-arbaed imakosurmalad. Weyobi, Leví-wagan-baigan e-arbaed-imake be imakoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israel-dulemar Egipto-yargi birgabogusa, gebe-nii-onoded-ibagwengus-noaligusadgi, Bab-Jehová Moisésʼga Sinaí-nega-dulesulidganba sunmaksagusad. Weyob Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Israel-dulemala Oburgwilegoenad-Iba iba-sekalaa onomaloed. ");
INSERT INTO cuk_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","E-iba-maidba ibambe-gakabakegi (14), osedodedgi, we-iba be onomaloed. We-iba-be-onogoedi bela igar-maidba-imaked be imako, degine, bela e-igarmar-sogmaidba be iba onogo.” ");
INSERT INTO cuk_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Geb degine, Moisés Israel-dulemarga sogded: “Oburgwilegoenad-e-Iba bemar onomar.” ");
INSERT INTO cuk_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Geb agine, Israel-dulemar gebe-nii-onoded-ibambe-gakabakegi nega-dulesulidgan-Sinaíʼye-nugadgi, sedogidba Oburgwilegoenad-e-Iba onosmarsunnad. Ar igi Bab-Jehová Moisésʼga igar-uksa, aba bela Israel-dulemar imaksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Dakleargua, dule-gwenna-gwenna, dule-e-mui-ebusad-ular, san-swilidiksuli gunonigusmalad. A-ulale, a-ibagi Oburgwilegoenad-e-Iba onossurmalad. A-ibagi, dule-swilidiksurmalad Moisésʼse, degi, Aarónʼse nonigusmalad, amala ega sogdemalad: ");
INSERT INTO cuk_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","—Anmar dule-mui ebusad, agala anmar swilidiksurmalad. ¿Ibiga geg anmar Israel-dule-baiganyobi Bab-Jehováʼga Iba-sekalaa ibmar-uke guosunna? ");
INSERT INTO cuk_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moisés we-dulemar-abin sogded: —Bemar an-edarbemargwelo. An itogweloed, igi Bab-Jehová bemargi anga igar-ukoe. ");
INSERT INTO cuk_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Geb degine, Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Israel-dulemarga be sunmak, amarga be soge: ‘Ar doa-dule, igi, e-wagandibe, dule-burgwisad-ebusad-ular, na san-swilidiksur-gunonimalale, igi, dikasuli e-yarginsuli gudimalale, bemar nabir Oburgwilegoenad-e-Iba Bab-Jehováʼga onomaloed. ");
INSERT INTO cuk_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Degi-inigwele, we-dule, a-Iba, geb sorba nii-warbo-ibambe-gakabakegi, sedogidbali onomaloed. A-Ibagi madumar-e-inasulid, degi, gaganmar-gagbiremaladba sibad-wawaad-sapingwagwad gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","We-sibad-wawaad-Bab-Dummadga-ukaled-e-san-obichad, melle banedga be sabogo, degine, a-sibad-wawaad-e-garmar be bisgosurbalid. Oburgwilegoenad-e-Iba be onoarmalale, bela igar-maidba be imako. ");
INSERT INTO cuk_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","” ’Ar dule san-swilidikindibe, igi, neg-baidsik gudisulindibe, Oburgwelegoenad-Iba onossulile, we-dule, e-dulemar-abargi onolegoed. Ar anga ibmar-ukleged Iba-sekalaa-uksasursoggu, we-dule na e-isgusadba oburgwilegodo. ");
INSERT INTO cuk_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","” ’Dule-be-yarginsulid bemar-abargi maile, we-dule anga Oburgwilegoenad-Iba onobiele, igar-maidba imakoed. Ar iba-e-igar-mamaidba inniki imakoed. Israel-duledibe, igi, Israel-yarginsuliddibe, amba igar-maidba imakmogoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Bab-Dummadse-goled-neg-sunna-seleged gannar osilesgu, mogir we-Bab-Dummad-dulemarbo-ambikued-neg-birgi nagunonikid. Sedogidbali, neg-oibogedsega, we-neg-birgi mogir-naidi sooyobi-dakle nagusad. ");
INSERT INTO cuk_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Gusgu mogir weyobi nai gusad: Neg-ibgine, mogir neg-birgi-naidaed. Mutikdi, mogir sooyobi we-neg-birgi-naidaed. ");
INSERT INTO cuk_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Mogir Bab-Dummadse-goled-neg-birgi-naid-nakwided-iliba, Israel-dulemar na-e-danar-danar-bukwadgi banguddamalad. Bia mogir nagudapoe, agi Israel-dulemala gannar danar ambikudapdamalad. ");
INSERT INTO cuk_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Bab-Jehová-igar-ukedba Israel-dulemar banguddaed, degi, Bab-Jehová-sogedba Israel-dulemar danar ambikudapdabalid. Ar mogir bane-bane Bab-Dummadse-goled-neg-birgi naile, Israel-dulemar bangudasurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ar mogir Bab-Dummadse-goled-neg-birgi iba-bukidar-naile, Israel-dulemar Bab-Jehová-sogedba imakdamalad, gwen bangudasurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mogir Bab-Dummadse-goled-neg-sunna-seleged-birgi iba-ichesaar-naile, Bab-Jehová-sogedba Israel-dulemar danar-danar-ambikusdamalad, degine, Bab-Jehová-sogedba banguddamarbalid. ");
INSERT INTO cuk_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ar mogir, sedogidbali, degi, oibogedse nagusale, a-wakdar mogir nakwidele, Israel-dulemar banguddamarmogad. Ar mogir ibagwen-nagusale, mutikidba mogir nakwidele, Israel-dulemar naddamarmogad. ");
INSERT INTO cuk_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ar mogir bangusulile, Bab-Dummadse-goled-neg-sunna-seleged-birgi ibabo-naidibe, nii-wargwendibe, birgagwen-naidibe, Israel-dulemar geg bangudamarmogad, danar-danar bukwagu damalad. Ar mogir nakwiderdi, Israel-dulemar naddamarmogad. ");
INSERT INTO cuk_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Israel-dulemar Bab-Jehová-sogedba danar-danar-ambikudapdamalad, Bab-Jehová-sogedba naddamarbalid. Weyobi, Bab-Jehová-sogedba Bab-Jehová-Moisésʼba-Igar-Uksadba ibmar-imakdii gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Gar-trompeta, walabo manigi be sobo. We-garmarde mardogi binnaa sarsoar be soboed. We-gar-trompetaʼde dulemarse golega be ebugoed. Degine, dulemar-danar-danar-bukwad baid-negsik-sedesokalile be ebubaloed. ");
INSERT INTO cuk_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","We-gar-trompeta warbobela be ogotele, bela dulemar be-asabin dulemar-anbo-ambikued-neg-yawagak-abin ambikunonimaloed. ");
INSERT INTO cuk_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ar unnila gar-trompeta-wargwen be ogochardi, Israel-dulemar-e-dummaganbi bese nonimaloed. ");
INSERT INTO cuk_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Gebegi gar-trompeta binnasur be ogotele, degi, dulemar-oimaknadapmalale, dulemar-e-dad-sailaganba dad-nakwedsik-danar-danar-bukmalad-inse namaloed. ");
INSERT INTO cuk_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","”Irbogi gar-trompeta binnasur be ogotele, dulemar-e-dad-sailaganba dad-nakwed-argan-nuedsik-danar-danar-bukwamaladi bangudmaloed. Gar-trompeta binnasuli ogormaloed, degi, dulemar-oimaknadapmaloed, adi, namalaga guoed. ");
INSERT INTO cuk_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Dulemar danar-oambikuegardi unnila gar-trompetaʼbi be ogoloed. ");
INSERT INTO cuk_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","”Aarón-masmala-dule-irwa-Bab-Dummadse-gormalad, amar gar-trompetaʼmar ogormaloed. Weyob degisadegu, bemarga, degi, be-waganga be igar mesoed. ");
INSERT INTO cuk_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","”Dule-be-isdarmalad bemar-yargi begi-yoledanimalad-abin bemar bila-ononamalagala, gar-trompeta binnasuli be ogormaloed. Weyobi adi ani, Bab-Jehová, bemar-Bab-Dummad bemar-insamaloed, degine, be-isdarmaladgi an be-abonomaloed. ");
INSERT INTO cuk_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","”Bemar weligwar-itoged-ibagangi, iba-itoakwaa-onolemalad-ibagindibe, igi, nii-gwapid-gwisgued-ibagindibe, gar-trompeta bemar ogormarbaloed. Bemar ibmar-ogumakar-anga-ukarmalar, gwenatigwar-guega ibmar-ukarmalar, agi, bemar gar-trompeta ogormarbaloed, adi, an bemar-insamalagar. Ani an be-Bab-Dummad-Jehová gued.” ");
INSERT INTO cuk_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Birgabogwadgi, a-nii-walabogwad-iba-dulagwengi, mogir Bab-Dummad-Israel-Dulemarbo-Igar-Mesisad-neg-birgi-naid nakwided. Geb mogir Israel-dulemar-idu nadegusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Agi, Israel-dulemar, nega-dulesulidgan-Sinaíʼye-nugadgi bangudmalad. Mogir-e-idu-nadapid, ega nega-dulesulidgan-Paránʼye-nugadgi nagudapid. ");
INSERT INTO cuk_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","We-Israel-dulemar, Bab-Jehová-Moisésʼba-ega-Igar-uksadba, gebe nadegusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Judá-wagan-inse, igar-uklesadba e-sorda-e-sordamarba, danar-danar-bukwamaladba e-bander-senadapi gusmalad. E-dummadgala, Aminadab-machi-Naasón nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Zuar-machi-Natanael, Isacar-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Helón-machi-Eliab, Zabulón-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bab-Dummadse-goled-neg-sunna-seleged bela earilesgua, Gersón-wagan, degi, Merari-wagan a-neg semamai gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Geb a-sorba, Rubén-wagan igar-uklesadba e-sorda-e-sordamarba danar-danar-bukwamaladba e-bander-senadapi gusmalad. E-dummadgala, Sedeur-machi-Elisur nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Zurisadai-machi-Selumiel, Simeón-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Deuel-machi-Eliasaf, Gad-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Geb a-sorbali, Coat-wagan ibmar-Bab-Jehováʼga-nugsalesmalad semamai gusad. We-dulemar omoged-iduale, Leví-wagan-baigan bato guakwa Bab-Dummadse-goled-neg madar-madar onakwismalad. ");
INSERT INTO cuk_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Geb degidgine, Efraín-wagan igar-uklesadba e-sorda-e-sordamarba danar-danar-bukwamaladba e-bander-senadapi gusmalad. E-dummadgala, Amiud-machi-Elisama nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pedasur-machi-Gamaliel, Manasés-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Gedeoni-machi-Abidán, Benjamín-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Geb degine, bela dulemar-baigan-solaba Dan-wagan ega igar-uklesadba e-sorda-e-sordamarba danar-danar-bukwamaladba e-bander-senadapi gusmalad. E-dummadgala, Amisadai-machi-Ahiezer nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ocrán-machi-Pagiel, Aser-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Enán-machi-Ahira, Neftalí-wagan-danar-danaled-e-dummadga nadapi gusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Weyobi, Israel-dulemar e-bukwadgi bangudmalale, danar-danar e-sorda-e-sordamarba igar-uklesadba nadapi gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Geb degine, Moisés, Reuel-machi-Hobabʼga sunmakded. Reuelʼde Madián-duled, Moisés-e-sakad. Moisés Hobabʼga sogded: —Bab-Jehová anmarga sogsad, yar an bemarga ukoye. Emide, a-yalase anmar naesokalid. Anmarba be dage, anmar nued be-akwemaloed. Ar ade, Bab-Jehová Israel-dulemarga sogsad, ise-nued an bemargi binsamaloye. ");
INSERT INTO cuk_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab, Moisés-abin sogded: —An bemarba naosuli, an-negse bur an naoe, an-babganse bur an naoe. ");
INSERT INTO cuk_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Ar Moisésʼdi egi alamaknaigusad: —Melle be anmargi nae, ar be, be wisid bia sunna anmar nega-dulesulidgangi nabir ambikudapoe. Be anmar-idugega be guoed. ");
INSERT INTO cuk_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ar be anmarba alile, Bab-Jehová anmarga-ibmar-nuegan-ukoye-sogsad anmarga-uknonikile, a-ibmarmar anmar bega ukmarmogoed. ");
INSERT INTO cuk_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Weyobi, Israel-dulemar ibapaa-nanae-wilub Bab-Jehová-yalagi-bukwadi bangud gusmalad. Leví-wagan-baigan Bab-Jehová-Dulemarbo-Igar-Mesisad-Ulu-senadapmaladi, ibapaa Israel-dulemar-idu-nadapi gusad. Adi, ega danar-danar-ambikued-neg amiegar. ");
INSERT INTO cuk_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Israel-dulemar bukwamaladgi bangudmargua, ibginedba Bab-Jehová-e-mogir Israel-dulemar-birgi nadapigusad. ");
INSERT INTO cuk_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Bab-Dummad-Israel-dulemarbo-Igar-Mesisad-Ulu seledele, Moisés sogdedaed: “¡Bab-Jehováʼye, be anmar-bendake! Be-isdarmalad bela aisakisun. Dule-isdar-be-dakmalad bela be-idu duurmakmarsun.” ");
INSERT INTO cuk_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bab-Jehová-Ulu siledapile, agindi Moisés sogdedaed: “Bab-Jehová, gannar be-Israel-dulemar-mili-milibalidse be dage.” ");
INSERT INTO cuk_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ibagwengine, Israel-dulemar igar-bulegan-itonaidgi sae-itoarmalad. Bab-Jehová deyob daksagua, nue-uluded. Agine, Bab-Jehová e-soo barmialid, dulemar-bukwad-dikarba odesad. ");
INSERT INTO cuk_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Geb degine, Israel-dulemar Moisésʼse bela-bela wilenai gusmalad. Geb agine, Moisés Bab-Jehováʼse gotesunnad. Geb degidgine, soo akitesunnad. ");
INSERT INTO cuk_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Agala, Taberaʼye a-neg onugsasmarsunnad, ar ade, agi Bab-Jehová e-soo odesgusad. ");
INSERT INTO cuk_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israel-dulesurmalad Israel-dulemarba-apurusmaladi, unnila mas-gunnedginbi binsadimalad. We-dulemarba Israel-dulemar akadmarmogad. Geb binnasuli-bodmalad, sogdemalad: “¿Wede doa anmarga san-gunnega ukoe? ");
INSERT INTO cuk_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Anmar ebinsaed, Egipto-yargi anmarga binsa ua-ukleardaed. Agindi anmar akar-akar ibmar-gunnardaed: Pepinoʼmar, melónʼmar, puerroʼmar, ajoʼmar, degi, agumar anmar nue-gundaed. ");
INSERT INTO cuk_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ar emigindi, unnila we-manáʼbi anmar dakdiid, ibmar-baigan sated. Degisoggu, anmar ukudbargudmaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manáʼde gagan-ina-wawadikid-culantroʼye-nugad-e-gwagyobid. E-dakleged, gorosdikii sapi-gichiyob dakleged. ");
INSERT INTO cuk_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Israel-dulemar maná-weega ainiddaed. Geb akwamuugi nagdamalad, igi, orsargi ollimakodibe. Geb esmedgi dudamalad. Sulile, madu-maná-ologanaga imakodibe. E-gullegedi madu-olivo-gwalluba-imakaleyob gulleged. ");
INSERT INTO cuk_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","E-bukwamaladgi mutikidba boo babatialile, maná batiardamogad. ");
INSERT INTO cuk_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moisés, Israel-dulemar na e-neg-e-neg-yawagak-naba sabsur-bobukwa itosad. Agidbali, Bab-Jehová nue uluded, degine, Moisésʼmoga nue-sae itosmogad. ");
INSERT INTO cuk_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Agi, Moisés, Bab-Jehováʼga sogded: —Ande be-maid, degite, ¿ibiga be angi ichakwaa binsae? ¿Ibiga be bar an-bendaksuli? Emide, bela we-dulemar-niega be an-imaksad. Ar ade, we-dulemar-seleged dutusulid. ");
INSERT INTO cuk_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","¿Ar we-dulemarde angi danisi? ¿Ani an we-dulemar-baksasi? Emide be anga soggu: ‘We-dulemar be sede, igi dule na e-goe-mam-nunaid argangi semaidae, deyobi, e-dadganga an yala-ukoye-sogsadse, be sede.’ ");
INSERT INTO cuk_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","An we-dulemarga-san-ukega, ¿bia an ega san amioe? Bela we-dulemar anse-ise-boale anga sognonimalad: ‘San be anmarga amie, adi, anmar a-san gunnegar.’ ");
INSERT INTO cuk_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Bela we-dulemar an sedye-sogele, anbi wargwen geg an gued. Anbi wargwenale, angi dutusur noed. ");
INSERT INTO cuk_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ar weyob arbaed be anga ukele, bur be an-oburgwesunna. Be an-oburgwisar, bur nabirid, adi, nunmaked-dummad-itodii bar an guosulid. ");
INSERT INTO cuk_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Geb degine, Bab-Jehová Moisésʼga sogded: “Israel-girmar-dummagan dulapaa-gakambe (70) be anga onmako. Be girmar-dummaganga-gudidiid-wisidi, degi, dule-dummaganga-mamaid-wisbalidi be sedago. A-girmar-dummagan dulemar-anbo-ambikued-negse be sedago. Agi, be an-edarbemaloed. ");
INSERT INTO cuk_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Agi, an bebo-sunmakega an aidegoed. Be An-Burba-nikadyobi, a-dulemar An-Burba-nikuega an imakmogoed. Deyob an imakoed, adi, a-dulemar be-bendakegar, melle wargwen alamaknai be guegar.” ");
INSERT INTO cuk_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemar-baigangardi be soge: ‘Oibosale, na be abalukmalo, ar ade, san be gunmaloed. Bemar Bab-Jehováʼse boapmargua, ega be sogsamalad: Dule anmarga san gunnega ukmalana gadinye. Ar anmar Egipto-yargi bur-nued gudimalanad. ” ’Degisoggu, Bab-Jehová be-boed itosad, bemarga san ukoed, adi, bemar a-san gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Bemar unnila ibagwen, ibabo, ibatar, ibambe (10), iba-durgwen (20) san-gundii guosurmalad. Bemar nii-walagwen san gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","” ’Bemar san-gunnoedi budar-gungusadse be gunmaloed, ar ade, bemar be-Bab-Jehová-bemar-abargi-gudiid nabir gwen daksasurmalad. Deunni, ese bemar boapmalad, ega be sogsamalad: ¿Ar ibiga wese-dagega be Egipto-yargi be anmar-onosmala?’ ” ");
INSERT INTO cuk_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Geb degine, Moisés, Bab-Jehováʼga sogded: “Sordamar-mili-dulataled-ilanergwad-abalagi (600,000) an gwichid. Emide be soged: ‘We-dulemarga san an ukoye. We-dulemar nii-walagwen san gunmaloye.’ ");
INSERT INTO cuk_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","We-dulemarga sibad-wawaad, degi, moli-bebe-nikamalad ega ichesuli-oburgweye-sogele, amba unnigussuliled. Ar wemarga bela-uamar-gudidiid ega somalale, amba unnigussuliled.” ");
INSERT INTO cuk_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Geb degine, Bab-Jehová Moisés-abin sogded: “¿An geg imak be-ebinsae? Emigindi be dakodo, an-bega-ibmar-soged an imakodibe, igi, an imakosurdibe.” ");
INSERT INTO cuk_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Geb degine, Moisés Israel-dulemarse naded, Bab-Jehová-ega-ibmar-sogsad sognaded. Agine, Moisés Israel-girmar-dummagan dulapaa-gakambegwadse (70) gochad. Moisés Bab-Dummadse-goled-negse amar-sesad, agi oambikudapid. ");
INSERT INTO cuk_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Degidgine, Bab-Jehová mogir-abalagi aidenonikid, Moisésʼga sunmaksad. Geb degine, Bab-Jehová Israel-girmar-dummaganga Moisés-Bab-Burba-nikad ukdemogad. Bab-Dummad-Burba amargi aidenonimogu, amala Bab-Burbaba sunmakdemalad. Deyob-gusadi, a-sorba we-dummagangi bar deyob gussulid. ");
INSERT INTO cuk_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Israel-girmar-dummagan-warbo dulemar-danar-danar-bukwamaladgi besmalad. Amardi girmar-dummaganba-sulesmarmo-inigwele, Bab-Dummadse-goled-negse arbisurmalad. Amar-warbogwadi gwensak Eldadʼye nugad, baiddi Medadʼye nugad. Amargine, Bab-Dummad-Burba aidenonimogad. Amala Bab-Burbaba dulemar-danar-bukwamaladgi sunmakdemarmogad. ");
INSERT INTO cuk_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Machi-sapin-gwensak Moisés-owisogega abarmakded, ega sogdapid: —Eldad, degi, Medad, dulemar-danar-danar-bukwadgi Bab-Dummad-Burbaba sunmakdimarye. ");
INSERT INTO cuk_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Agine, Nun-machi-Josué, sapingwagwad-akar Moisés-bendakdiid, Moisésʼga sogded: —Dummad-Moisés, melle we-dulemar Bab-Dummad-Burbaba-sunmaked be imake. ");
INSERT INTO cuk_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moisés Josué-abin sogded: —Mer be nobgue. Bab-Jehová bela e-dulemargi E-Burba odegena yeerban. Bitigi bela Bab-Jehová-dulamar Bab-Dummadga-gayaburba-barsogmaladga gumalana gadin. ");
INSERT INTO cuk_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Geb a-sorbali, Moisés Israel-girmar-dummaganmala, dulemar-danar-danar-bukwamaladse nonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Geb degidgine, Bab-Jehová burwa ogornonikid. Abali, nuu-demargi-nikad-codornizʼye-nugad burwaba nonikid. We-codornizʼmarde Israel-dulemar-bukwadgi batenonikid. Codornizʼmar bela-bela mergued. Bela Israel-dulemar-bukwad-ebiris, argan-nuedsik ibagwen-dummad-nanae-wilubbi nuumar babatisad, degi, argan-sapiledsik ibagwen-dummad-nanae-wilubbi babatisbalid. Deginbali, dali-abala napagi-nibgu odunnumakbukwa gusbalid. ");
INSERT INTO cuk_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","A-ibagine, Israel-dulemar nuu-codorniz-wenanai osedosad, degi, oibosbalid. Degine, banedgine deyob nuu-codorniz-wenanai gusmarbalid. Dulemar bur nuu-ichee-wesmaladi garba-dummagan-gwadulatar (100) wesmalad. Emar-bukwamalad-dikarba dad-abin narismalad. ");
INSERT INTO cuk_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Israel-dulemar geb san e-gayayaba ododmaladgine, amba yoo sakumake, Bab-Jehová we-dulemargi isdar-binsaded, amargi boni-dummad ogwisnonikid. ");
INSERT INTO cuk_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","A-yargi dulemar-yaisur-ibmarbina-sogmalad-digsamaladba a-neg Kibrot-Hataavaʼye onugsasmalad. ");
INSERT INTO cuk_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Israel-dulemar Kibrot-Hataava-akar Hazerotʼse nadegusmalad. Agi danar ambikudapmalad. ");
INSERT INTO cuk_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moisés ome-Cus-yargined-nikusad-ular, e-bun-María, degi, e-ia-Aarón, egi isdar sunmakarmalad. ");
INSERT INTO cuk_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","María, Aarón-ebogwa sokarmalad: “¿Unnila Bab-Jehová Moisésʼgarbi sunmaksasi? ¿Anmarga Bab-Jehová sunmaksasurmosi? Anmarga sunmaksamoga.” María, Aarónʼbo-deyob-sogmaladi, Bab-Jehová itosad. ");
INSERT INTO cuk_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Ar Moisésʼdi, dule-na-san-dummarba-imaksulidid. We-napneggi-dulemar-baiganba bur na san-maikwaa imakdiid. ");
INSERT INTO cuk_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Geb degine, Bab-Jehová Moisésʼga, Aarónʼga, degi, Maríaʼga sogded: “Bemar-warbaagwad dulemar-anbo-ambikued-negse namar.” Degine, wemar-warbaagwad Bab-Dummad-dulemarbo-ambikued-negse nadmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Agine, Bab-Jehová mogir-bubawaryob-gwichidba, ese-goled-neg-seleged-yawagakse aidenonikid. Geb Aarónʼse, degi, Maríaʼse gochad. Amar-ebogwad nonimargua, ");
INSERT INTO cuk_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Bab-Jehová ega sogded: “An bemarga-ibmar-sogoed, nue be itomalo: Bemar-abargi an-gayaburba-barsoged gudiile, negburgan-dakedba an ese magaroged, gabdakedba an ega ibmar soged. ");
INSERT INTO cuk_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","An-mai-Moisésʼsedi, deyob an ese magarosulid. Ar Moisésʼdi anga-arbamalad-baiganba bur inniki gudiid-duled. ");
INSERT INTO cuk_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Moisés-anbo asabin-asabin an sunmaked, odukuar an ega ibmar sogdasulid. Moisés, an-dakleged-e-wilub dakdaed. Emide, ¿ibiga an-mai-Moisésʼgi be isdar sunmakmala?” ");
INSERT INTO cuk_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Geb degine, Bab-Jehová Maríaʼgi, degi, Aarónʼgi sae-itogedba uluded. Geb a-sorbali, Bab-Jehová nadsunnad. ");
INSERT INTO cuk_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Bab-Dummadse-goled-neggi mogir-naid-bangudeyalaba, María naibe-buna-yaa-maleged nikuded, bela e-uka sibudik-dakle naded. Aarón Maríaʼsik atakdegu, dakded María naibe-buna-yaa-maleged nika. ");
INSERT INTO cuk_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aarón, Moisésʼga sogded: “Dummad, anmar yogasaar-binsaedsuli-begi-sunmaksadba anmar begi isgusad. A-ulale, melle be sabsur-anmar-odurdake. ");
INSERT INTO cuk_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Melle María, mimmi muu-neggi-burgwar-aidenonidaed-daklegedyobi be obego.” ");
INSERT INTO cuk_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Geb degine, Moisés wilesagwa Bab-Jehováʼse gochad: “Bab-Dummadye, wilesakwaa an bese egised, María be emisbinne be nudake.” ");
INSERT INTO cuk_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Bab-Jehová Moisés-abin sogded: “E-bab, María wagargi-wiaksana, ¿María ibagugle (7) bingegudiguosulin be insae? Bingegudii guoenad. Degisoggu, ibagugle-wilub (7) María dulemar-danar-danar-bukwad-abargi be onogo. A-ibagan-sorbali, sunna gannar dulemar-danar-danar-bukwadse nonibaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Weyobi, María dulemar-danar-danar-bukwad-abargi ibagugle-wilub (7) onolesad. A-ibagangine, María-gannar-nonikidse Israel-dulemar e-danar-danar-bukwamaladgi gwen baid-yarse bangussurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Geb a-sorbali, Israel-dulemar Hazerotʼgi-bukwamaladgi nadmalad, nega-dulesulidgan-Paránʼye-nugadse modapmalad. Agi, Israel-dulemar danar-danar ambikudapmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Canaán-yar Israel-dulemarga an ukesokarsoggu, dulemar a-yar arganaega be barmide. Israel-dadgan-warambe-gakabogwad-irba (12), sapin-dummagan-war-wargwen be barmidoed.” ");
INSERT INTO cuk_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Geb degine, Moisés Bab-Jehová-ega-sogsadba nega-dulesulidgan-Paránʼye-nugad-akar dulemar-barmisad. We-dulemarde, bela Israel-dulemar-abargi dule-dummagan gumalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","We-dulemarde, wemalad: Dad-dummad-Rubénʼgi-danikidi: Samúa Zacur-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Dad-dummad-Simeónʼgi-danikidi: Safat Horí-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Dad-dummad-Judáʼgi-danikidi: Caleb Jefone-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Dad-dummad-Isacarʼgi-danikidi: Igal José-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Dad-dummad-Efraínʼgi-danikidi: Oseas Nun-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Dad-dummad-Benjamínʼgi-danikidi: Palti Rafú-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Dad-dummad-Zabulónʼgi-danikidi: Gadiel Sodi-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Dad-dummad-Joséʼgi-danikidi, Dad-dummad-Manasésʼsik-danikid: Gadi Susi-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dad-dummad-Danʼgi-danikidi: Amiel Gemali-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Dad-dummad-Aserʼgi-danikidi: Setur Micael-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Dad-dummad-Neftalíʼgi-danikidi: Nahbi Vapsi-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Dad-dummad-Gadʼgi-danikidi: Geuel Maqui-e-machi. ");
INSERT INTO cuk_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Moisés dulemar-yar-arganaega-barmisgusadi, weyob nugmalad. Moisés, Nun-machi-Oseasʼgala nug ogwasad, Josuéʼye onugsasad. ");
INSERT INTO cuk_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moisés, dulemar-Canaán-yar-arganaega-barmidsokalidga sogded: “Neguevʼgi bemar nasmaloed, geb yalaganse bemar modapoed. ");
INSERT INTO cuk_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Nue be yar argamalo, negde igidibe, dulemar-agi-bukmalad, bule nollosurmardibe, igi, nollomardibe, bule mergumardibe, igi, ichemardibe. ");
INSERT INTO cuk_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Dule-bukmaladgi, neg nueddibe, igi neg ichakwadibe. E-neggweburmar-bukwadgi, galu-matusulid-dummagan mamaidibe, igi, galu-matusurmalad mamaisurdibe. ");
INSERT INTO cuk_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Napade, igidibe, gadi ibmar-sanmakdibe, igi, ibmar-geg-sanmakdibe. A-napaginde, sapimar-nikadibe, sapimar satedibe. Melle be dobgumalo. A-yargine sapi-sanmar-nikadi, bemar sedamalo.” A-ibagangi, uva gebe-goroleged-ibad. ");
INSERT INTO cuk_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Dule-barmilesmaladi, nega-dulesulidgan-Zinʼye-nugad-akar Hamat-neggwebur-dogedse neg-argaapmalad, Rehob-neggweburse warmakapmalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Neguevʼgi nasmargu, Hebrón-neggweburse warmaksamalad. Hebrónʼgine, Anac-e-wagan Ahimán, Sesai, degi, Talmai mamaimalad. Hebrón-neggwebur bato birga-guglegus-siid (7), geb Zoán-neggwebur Egipto-yargi bukunonikid. ");
INSERT INTO cuk_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Dule-barmilesmalad Escol-dianse-modapmargu, uva-dubgi uva-dukgwen-naid siksamalad. Geb dulemar ebo suar-abargi uva-nai searmalad, degi, gusebyob-dakleged-granadoʼmar, degine, higo-sanmar searmarbalid. ");
INSERT INTO cuk_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israel-dulemar uva-dukgwen-gwachadgine, neg-naid Escol-nebaye onugsasmalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Dule-neg-argadimaladi iba-dulabogusgu (40), gannar nonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Dule-neg-argaapmalad nega-dulesulidgan-Paránʼse nonimalad, Cadesʼye-neg-nugadse. Agine, Moisésʼga, Aarónʼga, degi, bela Israel-dulemarga, bela neg-argasmaladba sunmaksamalad. Geb degine, sapi-san-senonimalad oyosmarbalid. ");
INSERT INTO cuk_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Deginbali, Moisésʼga weyob sogsamarbalid: —Neg-argaega be anmar-barmisadse anmar modapmalad. Ar nue-napiragwad, inso agi gadi-ibmar-sanmaked, napa-nuedid. Bemar dakegala, sapi-san an bega senonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Degi-inigwele, dulemar-a-yargi-bukwamaladi dutusur nanaed. E-neggweburmar dummagan nanaed, degine, e-neggweburmar nue-sakdigar bukwananabalid. Deginbali, Anac-e-wagan anmar daksamarbalid. ");
INSERT INTO cuk_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Neguevʼgi Amalec-dulemar bukwananaed. Yalaganbali, Het-dulemar, Jebuseo-dulemar, degi, Amorreo-dulemar bukwananaed. Canaán-dulemardi demar-gakaba, degi, Jordán-diwar-gakaba bukwananamalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Geb degine, Caleb Moisés-asabin dulemar-bar-sunmakega imaksasulid, geb sogded: —Anmar we-yarse ubonae. Anmargadga anmar we-yar-imaknae. Ar an wisid, anmar we-dulemar-bukwadgi nakwemaloed. ");
INSERT INTO cuk_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ar dulemar-Calebʼba-arbimaladdi sogdemalad: —We-dulemar-bukwamaladi anmarba bur dutusursoggu, anmar geg we-dulemarse bila-onogega namalad. ");
INSERT INTO cuk_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","We-dulemarde Israel-dulemarga yar-daksamaladgi neg-sunnasurye sogdemalad. Geb sogdemarbalid: —Anmar-negmar-dakapidgi, yarmar-argaapidgi bela dule-bukmaladi bemar-obelogoed. A-yarmargine, anmar dulemar-bukwa-daksamaladi, bela dule-masdummagan-nanaed, dule-bipisurmaladid. ");
INSERT INTO cuk_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Aginbali, anmar Anac-e-wagan-dule-masdummagan daksamarbalid. Anmar, a-dulemarba sesyob-dakle-nanaed, emar burwii emarba anmar-dakmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Geb degine, Israel-dulemar-bela-bukwamaladi oimakdemalad. A-mutiki, bela boedibi gusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Bela Israel-dulemala Moisésʼgi, degi, Aarónʼgi uludmalad. Amar sogdemalad: “¿Ar ibiga Bab-Jehová we-yarse anmar-senoniki? ¿We-yargi es-suidgi anmar-oburgwega anmar-senoniki? Wede, ¿bila-onogedgi anmar-omegan, degi, anmar-mimmigan anmar-isdarmaladse-seledega guode? Sulirgebed. ");
INSERT INTO cuk_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Egipto-yalagi anmar burgwismalana, bur gadinad. We-nega-dulesulidgangi anmar burgwebalina, bur gadindo. ¿Anmar gannar Egipto-yarse bur naer nuedirsursi? A bur nuediled.” ");
INSERT INTO cuk_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Na muchub-muchub sokarmalad: “Anmar dule-wargwen anmar-iduega amido. Adi, gannar anmar Egipto-yarse naegar.” ");
INSERT INTO cuk_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moisés, Aarón-ebogwa Israel-dulemar-bukidar-bukwad-asabin dulluu napase e-nono imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Nun-machi-Josué, degi, Jefone-machi-Caleb, amala neg-argaapmaladba arbigusmarmogad. Amar mor siir-siir imakdemalad, oyogega, emarde nue-nunmak itomarye. ");
INSERT INTO cuk_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Josué, Caleb-ebo, bela Israel-dulemar-bukwamaladga sogdemalad: “Anmar-yar-argaapidi, anmar egi-nanasadi, yar-nuedid. ");
INSERT INTO cuk_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ar Bab-Jehová yeer anmar-dakele, e, anmar-nidoed, a-yala anmarga ukoed. A-yalagi napade gadi-ibmar sanmaked, napa-nuedid. ");
INSERT INTO cuk_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Degisoggu, melle bemar Bab-Jehováʼba uayasuli gumalo. Melle Bab-Jehováʼgi yolemalo. Bemar dule-a-yargi-bukmalad melle dobgumarbalo, ar ade, we-dulemargi bemar baisursunna nakwemaloed. We-dulemardina dule-e-bendaked sated. Anmarbardina Bab-Jehová gudiid. Degisoggu, melle we-dulemar be dobgumar.” ");
INSERT INTO cuk_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ar bela dulemar-danar-bukwadi, Josué, Caleb-ebo akwagi-makedgi-binsabuksoggua, Bab-Jehová-e-gangued-yeerdakleged Bab-Dummad-dulemarbo-ambikued-neggi Israel-dulemar-bukwadse magarononikid. ");
INSERT INTO cuk_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Geb degine, Bab-Jehová Moisésʼga sogded: “Israel-dulemar-abargi bela ibmar-dummagan-dakledisurmalad an imakdii-inigwele, degite, ¿sanagwadse we-dulemar isdar-an-dakdii guoe? ¿Ar wede sana angi bensuli gumaloe? An wesesun. Bar an bendakosur. ");
INSERT INTO cuk_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Aka bur boni-dummagan ega an barmidoed, bela wemar an ogilogoed. Moisés, ar begine anagan-baigan ainidagega an imakoed. Amar, dule-burgwemaloedba bur bukidar gumaloed, degi, dutusuli gumarbaloed. A-iduega an be-imakoed.” ");
INSERT INTO cuk_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ar Moisésʼdi Bab-Jehováʼga sogded: “Bab-Jehová mer deyob be imake. Ar Israel-dulemar be obelogele, Egipto-dulemar be-wisgumaloed. Geb Egipto-dulemar Canaán-yargi-bukmaladga sogoed. Ar Canaán-dulemar bato wismalad bede Egipto-dulemar-abargine, we-Israel-dulemar be-gangued-nikadba be onosad. ");
INSERT INTO cuk_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Deginbali, wismarbalid bede Israel-dulemar-abargi gudiiye, be-dulamarse be magarodiiye, degine, be-mogir dulemar-birgi naidaye. Ibginedgine, Israel-dulemar be-mogir-bubawaryob-gwichidba nadapdamarye. Mutikdina, be-soo-bubawaryob-gwichid-gwabunyemaidba nadapdamarye. ");
INSERT INTO cuk_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ar bela Israel-dulemar be oburgweye-sogele, dulemar-be-nug-dummarba-itosmaladi sogdamaloed: ");
INSERT INTO cuk_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Jehováʼde epenne we-Israel-dulemarga sogsagusad, Canaán-yar an bega ukedseye. Emide, Bab-Jehová a-yarse we-dulemar geg odogussoggu, agala, we-Israel-dulemar nega-dulesulidganba ogilosye.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Moisés Bab-Jehováʼga sogdebalid: “Ar emigindi, bese wilesakwaa an egised, be-gangued-dummarbad be oyoge. Ar be-sunnad bato be sogsad: ");
INSERT INTO cuk_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘An wissur gwae-gwae urweye. Bela-bela dulemar-sabye. Degine, dule-begi-isgusad, ega be elidaye. Deginbali, dule-begi-gwisgued ega be elidabarye. Degi-inigwele, be sogdasulid, dule-isgusad an sabsur-odurdakosurdeeye. Ar babgan-isgusad-ular, be, e-mimmigan, e-wagan, degi, e-wagan-yokorgined, degine, e-wagan-yarganbalid be sabsur odurdakdaed.’ ");
INSERT INTO cuk_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ar be-sabgued dummarbasoggu, wilesakwaa an bese egised, we-dulemar-begi-nosad-e-isgued ega be elie. Ar igi Egipto-akar we-Israel-dulemar-begi-nosale, be, ies-imakdanidae, deyob be imake.” ");
INSERT INTO cuk_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Geb degine, Bab-Jehová Moisésʼga sogded: “Ar be anse egichisadba, we-dulemar-e-isgued bato an elisad. ");
INSERT INTO cuk_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Emi, napira an bega soged: An nue-dula-gudiid-ular, degi, bela napneg-naidgi an-gangued-yeerdakleged mag-dakleged-ular, ");
INSERT INTO cuk_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","an bega soged: ‘We-dulemar Egiptoʼgi, degi, nega-dulesulidgangi an-ibmar-imaksad-daksamaladi, degine, an-gangued-yeerdakleged daksamarbalidi, bipisaale wargwensaale yar-an-ega-ukoye-sogsad dakosurmalad. Amar bali-bali nega-dulesulidganba an-wilubdakdani gusmalad, an-sogedba ibmar imaksasurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Amar wargwensaale, Canaán-yar-e-babganga-an-ukoye-sogsad dakosurmalad. A-dulemar baisur-an-daksamalad. Degisoggu, wargwensaale a-yar gwen dakosurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","” ’Ar an-mai-Calebʼdi, a-dulemaryob gwen binsadisursoggu, anba nanadii guoeye sogsasoggu, yar-argaapidse-doged an imakoed, degi, e-wagan a-yala-egadga-guega, an imakbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ar emide, Amalec-dulemar, degi, Canaán-dulemar, nebagi bukwamalad. Oibosale, bemar Demar-Ginnidye-nugad-igarba nega-dulesulidganse namalo.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Bab-Jehová Moisésʼga, degi, Aarónʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“¿Ar wede sanagwadse dule-isganamar-angi-urwedimalad an baisur-itodii guoe? Israel-dulemar-angi-gwisgudimalad, angi-sunmakdimalad bato an itosad. ");
INSERT INTO cuk_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","”Israel-dulemarga be soge: ‘Bab-Jehová sogye, nue-napira an dula-gudisoggu, ar igi angi sunmaksamala, deyob an bemar-imakoye. ");
INSERT INTO cuk_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Be-muimar we-nega-dulesulidganba omilede gumaloed. Bela bemar birga-dulagwen (20), degi, obine-nika-ebislesmalad (20+) burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Jefone-machi-Calebʼdi, degi, Nun-machi-Josuéʼdi, Canaán-yar-an-bemarga-ukedseye-sogsadse dogmaloed. Bela dule-baigandi bipisaale a-yarse dogosurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","” ’Be, mimmigangi sunmaksamalad: Bila-onogedgi anmar-mimmigan gandikidgi anmargi sulegoye. A-mimmigandi, Canaán-yarse dogmaloed, a-yala dakmaloed. Ar bemardi a-yar baisur-daksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","” ’Ar be-muimardi we-nega-dulesulidganba omilede gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Bemar-isgusmalad-ular, bemar we-nega-dulesulidgangi bela-burgwemaladse, be-mimmigana birga-dulabo (40) nega-dulesulidganba bipirmakdii gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","” ’Bemar yar-argaega iba-dulabo (40) bipirmakdii gusmalad. A-iba-ibagwenad, birgagwen-wilub be-mimmiganga guoed. Degisoggu, be-isgusmalad-ular, birga-dulabo (40) nega-dulesulidganba bipirmakdii gumaloed. We-sogleged, ibagwenad, birgagwen-wilubye. Agi bemar wisgumaloed, ani an sabsur-bemar-odurdaknaid. ");
INSERT INTO cuk_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","” ’Ani, an Bab-Jehová gued. Ani an sogsad. Weyob bela dule-isganamar-angi-gwisgudimaladi, an imakoye. We-nega-dulesulidgangine we-dulemala bela bergumaloye, agi bela burgwemaloye.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Canaán-yar-argaega dulemar-Moisésʼse-barmilesgusmaladi, gannar aibilismargua, Moisésʼgi uludgusmalad, degine, Moisésʼgi-urwega bela dulemar-imaksamarbalid. Yar-argaapmaladgi neg-sunnasurye sognonigusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Amardi, Bab-Jehová-asabinni boni-dummagangi burgwismalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ar Nun-machi-Josuéʼdi, degi, Jefone-machi-Calebʼdi, dulemar-Canaán-yar-argaapmaladba burgwissurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moisés, Israel-dulemarga we-ibmar-gusad-sogsagua, bela Israel-dulemar nue-bukib itosmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Israel-dulemar wakudaryalaba gwichigusmalad, yalaganba nakwidmalad. A-dulemala sokarmalad: —Anmar, inso nue Bab-Jehováʼgi nosmalad. Degisoggu, Bab-Jehová-yar-anmarga-ukoye-sogsadse anmar nae. A-yar anmar sunamala. ");
INSERT INTO cuk_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moisés Israel-dulemar-abin sogded: —¿Ibiga bemar Bab-Jehová-igar-uksadba ibsassurmala? Weyob bemar ibmar-imaksokarmaladi, bemarga igarga guosurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Melle be namar. Ar Bab-Jehová bemarba bar gudisursoggu, bemar be-isdarmaladse galakumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ar Amalec-dulemar, degi, Canaán-dulemar bemar-idu bukwamalad. Amarse bemar galakumaloed. Bemar Bab-Jehováʼba yapa ibmar-imakgussoggu, Bab-Jehová bemarba gudiosulid. ");
INSERT INTO cuk_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ar Bab-Jehová-Dulemarbo-Igar-Mesisad-Ulu, degi, Moisés, Israel-dulemar-danar-danar-neg-ambikuedgi gwen bangussurmar-inigwele, Israel-dulemardi aka yala-birse nakwidmalad. ");
INSERT INTO cuk_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Geb degidgine, Amalec-dulemar, degine, Canaán-dulemar-a-yargi-bukwamaladi, bila-onogega Israel-dulemar-abin ainiarmalad. Amala Israel-dulemargi nakwismalad. Geb Horma-neggweburse Israel-sordamar-baregichamalad. ");
INSERT INTO cuk_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Israel-dulemarga be sunmak, ega be soge: ‘Canaán-yar-Bab-Jehová-bega-uksokalidse bemar dogdemalale, egi, bemar megidmalale, ");
INSERT INTO cuk_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","agi, bemar Bab-Jehováʼga moli-bebe-nikaddibe, igi, sibad-wawaaddibe, ogumakar-ukye binsaarmalale, na be ukoed. Igi-barsundibe, ar na be Bab-Jehováʼga-sogsadba, we-ibmar-an-ukedseye, a-ular, na be ukbidibe, na be ukoed. Igi-barsundibe, be-itolegedba Bab-Jehováʼga-ibmar-ukbiedba-ukbidibe, na be ukoed. Igi-barsundibe, iba-itoakwaa-onolegedgi na be ibmar-ukbiedba-ukbidibe, na be ukoed. We-ibmar-ogumaklegar-uklegedde Bab-Jehová, yeer-yapanne itodaed. ");
INSERT INTO cuk_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","” ’Ar dule Bab-Jehováʼga ibmar-ukbiele, napi-ibmar-baid ega ukega sedabaloed, nibiratar-mergu madubur-bur-nued sedagoed. A-madubur be omukuoed. Geb olivo-e-gwallu bute-warbo eba be oburoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Sibad-wawaad-wargwen ogumakar-ukleged-iliba, igi ibmar-negabar-ogumaklegodibe, igi bela ogumaklegodibe, a-iliba, vino-bute-warbo egi be eogoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","” ’Sibad-wawaad-machered-iliba, Bab-Dummadga be ukoed, madubur-bur-nued nibirbaa olivo-e-gwalluba oburar be omukoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Vino bute-walatar egi eolegoed. We-ibmarmar Bab-Jehováʼga ogumakar be ukoed. Ar Bab-Jehová yeer-yapanne itodaed. ");
INSERT INTO cuk_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","” ’Dule Bab-Jehováʼga ibmar-ukbiele, sunna uked: Moli-bebe-nikad sapingwagwa bela-ogumakardibe, igi abala-ogumakar Bab-Jehováʼga be ukodibe, igi na be ibmar-ukbiedba be ukodibe, igi gwenatigwar-guega ukodibe. ");
INSERT INTO cuk_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","We-moli-bebe-nikadbali madubur-bur-nued, nibiratar Bab-Jehováʼga be ukoed. We-be-ukoedi olivo-e-gwalluba galón-negabar eba oburar be omukuoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Degine, vino galón-negabala egi eolegoed. We-ibmarmar ogumakar-uklegoed, ar Bab-Jehová yeer-yapanne itodaed. ");
INSERT INTO cuk_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Weyobi ibmar-anga-uklegarmalad: Moli-bebe-nikad-sapingwagwaddibe, sibad-wawaad-machereddibe, sibad-wawaad-birgagwen-nikaddibe, sibad-sapingwagwaddibe, bega igar-uklesadba be imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","” ’Ar ibdurgan igi mergudibe, akarsulid. Bega-igar-uklesadba bela be imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Israel-dule-wargwen Bab-Jehováʼga ibmar-ogumakar-ukleged-nue-yeer-yapanned uked-ilibali, Bab-Dummad ega-igar-uksadba bela imakergebed. ");
INSERT INTO cuk_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","” ’Dule-ainebalid bemar-abargi maile, Bab-Jehováʼga ibmar-ogumakar-nue-yeer-yapanned ukbiele, amba bemaryob Bab-Dummadga ibmar-ukmarmogoed. Be-wagan degisadegu deyob imakmogoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","” ’Bemarga, degi, dule-yar-baidginmalad-bemar-abargi-mamaimaladga, unnila igar-wargwenna maiguoed, ar ade, bemar-neggweburgine unnila igar-wargwenna mai guoed. Bemar-waganga we-igar degisadegu mai guoed. Bemar, degi, dule-yar-baidginmalad Bab-Jehová-asabinni, bela emarbiid. ");
INSERT INTO cuk_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Degisoggu, Israel-dulemarga, degi, dule-yar-baidginmalad-bemar-abargi gudiidmarga, bela unnila igar-gwennagwa an bemarga uksad, a-igarbi bemar nika gumaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Bab-Jehová Moisésʼga sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Israel-dulemarga be sunmake, ega be soge: ‘Bab-Jehová yala-bemarga-uknaidse be dogsamalale, ");
INSERT INTO cuk_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","agi ibmar-sanmakmalad bemar gutemalale, Bab-Jehováʼga be ibmar ukmarmogo. ");
INSERT INTO cuk_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Gebe-madu-olo-bur-nued be imakoedi, a-madu-olo Bab-Jehováʼga be ukoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Wegibi degisadegu be-wagana gebe-madu-olo-imaklegedi Bab-Jehováʼga ukdii gumaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Bab-Jehová Moisésʼga sogdebalid: “Israel-dulemarga be soge: ‘Bab-Jehová-Moisésʼga-Igarmar-Uksad, be, degi, bemar-wagan degisadegu imakdii guoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Ar bemar, igi be-wagan a-igarmar-wissuli yolediile, a sogleged, we-isguedgi be igar-wissulidba be isgusye. ");
INSERT INTO cuk_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Bela dule-mamaimalad wissulidba isgunonimogale, bela amar moli-bebe-nikad-sapingwagwad ogumakar, nue-yeer-yapanned Bab-Jehováʼga ukoed. Degine, madubur-bur-nued Bab-Jehováʼga ukbaloed, degine, vino egi eobaloed. Geb degine, igar-soglesad-maidba dulemar-mamaid e-isgued-eliega sibad-machered ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Geb a-sorbali, dule-irwa-Bab-Dummadse-goled bela Israel-dulemar-isgued-eliega ibmar-ogumakar ukoed. ” ’Geb degidgine, Bab-Jehová we-Israel-dulemar-e-isgusad bergusa dakoed, ar ade, igar-wissulidba isgusadga ibmar-ogumakar anga uksamalad, degi, e-isgued-eliegala ibmar uksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Bela dule-igar-wissulidba-isgusmaladba Bab-Jehová bela Israel-dulemar, degi, dule-ainebarmalad isgussuliyobi dakoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","” ’Dule-wargwen igar-wissulidba-isgusale, e-isgusad-osulogega Bab-Jehováʼga sibad-ome-birgagwen-nikad ukoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Dule-irwa-Bab-Dummadse-goled, dule-igar-wissulidba-isgusadga-isgued-osulogega Bab-Jehová-asabin ibmar oburgoed. We-dule Bab-Jehová-ebo igar-nabogoed, geb degine, Bab-Jehová we-dulega isgued obergunonikoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Israel-duledibe, igi dule-ainebaliddibe, igar-wissulidba isgusmalale, wemarga unnila igar-wargwenna maiguoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","” ’Ar Israel-duledibe, igi-dule-ainebaliddibe, igar-maid-wisidba-isgusale, Bab-Jehováʼgi nue-isgusdo. We-duledi bemar-abargi oburgwilegoed. ");
INSERT INTO cuk_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Ar we-dule na dukin imakodo, ar ade, Bab-Jehová-ega-ibmar-sogsad baisur-itosad, Bab-Jehová-Igar-Maidgi annasad.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israel-dulemar nega-dulesulidgangi-gudidimargua, dule-wargwen obunnoged-ibagi sapan-aminai daksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","We-dulemar dule-sapan-aminaidi, Moisés-asabin, degi, Aarón-asabin, degine, bela dulemar-neggweburginmalad-asabin senonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ar wissurmarsoggu, igi a-dule-imakmaloe, esgaryagi metemalad. ");
INSERT INTO cuk_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Geb degine, Bab-Jehová Moisésʼga sogded: “We-dule oburgwilegergebed. Bela dulemar e-danar-danar-ambikued-neg-magaba we-dule akwagi maknamalo.” ");
INSERT INTO cuk_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Degisoggu, ar igi Bab-Jehová Moisésʼga-igar-uksa, deyobi, dulemala, we-dule e-danar-danar-ambikued-neg-magaba sesmalad. Geb we-dule-oburgwedse, akwagi maksamalad. ");
INSERT INTO cuk_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Israel-dulemarga be sunmako, ega be soge: ‘Bemar dub-suir-akwagiidgi be-morduku durbamakar be imakmalo. Degibi be-wagan degisadegu imakmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","We-morduku-durbamakaled be dakarmalale, Bab-Jehová bemarga-Igargan-uksad-insamalaga be-imakoed. Adi, a-Igarganba bemar nanamalagar, melle ibmar-dakedba wargwengi ibmar-imakbiedba nanamalagar, degi, melle Bab-Jehováʼgi be bangumalagar. ");
INSERT INTO cuk_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Adi weyobi, igargan bemar insaoed, degine, a-igargan-sogedba bemar nanaoed. Weyob be imakele, bemar be-Bab-Dummadga dule-swilidikmaladga gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ani an Bab-Jehová, be-Bab-Dummad gued. Ani an Egipto-yalagi an bemar-onosad, adi, be-Bab-Dummadga guegar. Ani an bemar-Bab-Dummad-Jehová gued.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","We-dulemar Moisésʼgi gwisgusmalad: Leví-wagwa-yarganbalid Coat-wagwa-Izhar-machi-Coréʼye-nugad, Degi, Dad-dummad-Rubénʼgi-danimalad: Eliab-masmala Datán, degi, Abiram. Deginbali, Pelet-machi-Onʼye-nugad. ");
INSERT INTO cuk_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Israel-dule-dummagan-dulataled-ilabo gaka dulabo-gakambe (250) Coréʼba akadmalad, Moisésʼgi gwisgudmarmogad. We-dummagande dulemar-binsaed-dakmalad-yagi bukwamaladid, dule-nue-nug-nikamaladid. ");
INSERT INTO cuk_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","We-dulemar bulakwa-ambikunonimargua, Moisésʼgi, degi, Aarónʼgi isdar-sunmakdemalad. Geb Moisésʼga, degi, Aarónʼga sogdemalad: —¡Bemar, wese be ugakmalo! Ar bela Israel-dulemar bato Bab-Jehováʼgadid, degite, ¿ibiga be binsamala, bemarde Bab-Jehová-sordamar-e-dummadye? Bemar a-sordamar-e-dummagansulid. ");
INSERT INTO cuk_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Moisés we-dulemar-degii-ega-sognanaid itosgua, amar-asabin dulluu imakded. ");
INSERT INTO cuk_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Geb degidgine, Moisés Coréʼga, degi, Coréʼba-nanaimaladga sunmakded, amarga sogded: —Oibosale, Bab-Jehová sogoed, ede doa-susa, doa-egadi, doa sunna ese warmakoe. Ar Bab-Jehová na dule-suoedi, a-dulebi, Bab-Jehováʼga nabir-ibmar-uke guoed. ");
INSERT INTO cuk_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Coré, be oibosale, degi, be-sordamar-beba-nanaimalad weyob bemar imakmalo: Bemar sianar sedmalo. ");
INSERT INTO cuk_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","A-sianargi bemar soo urbemalo, geb degine, a-sianargi ina-wawadikmalad bemar Bab-Jehová-asabin urbemarbalo. Ar Bab-Jehová doa-dule-suoe, a-dule, dule-irwa-Bab-Dummadse-goledga guoed. ¡Bemar Leví-wagan, emigindi bemar igar-maidgi-obitemalad! ");
INSERT INTO cuk_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Geb degine, Moisés Coréʼga sogdebalid: —¡Leví-wagan, an-ibmar-bemarga-sogoed, nue be an-itomalo! ");
INSERT INTO cuk_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Israel-e-Bab-Dummad Israel-dulemar-abargi bemar-susad, adi, ese-goled-neggi ega be arbamalaga, degine, Israel-dulemarga arbamalagarba, degite, ¿unniguar be itosurmarde? ");
INSERT INTO cuk_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","”Bab-Dummad bemar-abesad, bemar e-walikaa gudigued, degine, bela bemar-Leví-wagan e-walikaa gudigued abesad. ¿Emide, bemar dule-irwa-Bab-Dummadse-goledga gubimarbarde? ");
INSERT INTO cuk_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Degisoggu, be, degi, beba-nanaimalad, bemar Bab-Jehováʼgi-beedse-yolegegala na atosmalad. Ar ¿Aarónʼde doasunna, emide bemar egi gwisgunanaimargu? Degisulirgebed.” ");
INSERT INTO cuk_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Geb degine, Moisés, Datánʼse, degi, Abiramʼse gochad, ese dagmaloye. We-warbogwadde, Eliab-e-masmala-gumalad. Ar wemardi Moisés-abin sogdemalad: —¡Anmar bese naed-sate! ");
INSERT INTO cuk_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","¿Ar unnisur be itode, napa-gadi-ibmar-sanmakedgi, napa-nuedgi be anmar-onosad? Emigindi, we-nega-dulesulidgangi be anmar-oburgwebied. Anmar-dummadga be gubibalid. Adi sulirgebed. ");
INSERT INTO cuk_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Emide yala gadi-ibmar-sanmakedse, amba napa-nuedse yoo be anmar-odoged. Degine, amba yoo be anmarga nainumar, degi, nainu-uva-digarmalad be ukbalid. ¿Bela dulemar aku-atakeyobi beba bipirmakdii be abede? ¡Anmar bese naed, satemala! ");
INSERT INTO cuk_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Geb degine, Moisés nue-uluded, Bab-Jehováʼga sogded: —¡We-dulemar bega ibmar-ukalile, melle annik be suo! Ar wemar-ibe moli-uayasuid wargwensaale an sussulid, degine, an we-dulemar bipisaale gwen oakalossulid. ");
INSERT INTO cuk_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Geb a-sorbali, Moisés Coréʼga sogded: —Oibosale, bedi, degi, be-sordamar Bab-Jehová-asabin nonimaloed. Aarón ase nonimogoed. ");
INSERT INTO cuk_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Bemar wala-walagwengi Bab-Jehová-asabin, be esgoro-gordikid-sianargi ina-wawadikmalad ena sedamaloed. A sogleged, esgoro-gordikid-sianar dulataled-ilabo gaka dulabo-gakambe (250), ina-wawadikmalad-egi-bukwa senonimaloye. Be, degi, Aarón, bemar esgoro-gordikid-sianar sedamarmogoed. ");
INSERT INTO cuk_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Degine, dulemar egad-egad esgoro-gordikid-sianar-ganikidgi, soo urbismalad, degine, ina-wawadikmalad egi eosmarbalid. Geb agine, we-dulemar, Moisésʼmala, degi, Aarónʼmala, Bab-Dummadse-goled-neg-sunna-seleged-e-yawagakgi ambikunonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Coré Bab-Dummadse-goled-neg-sunna-seleged-yawagakgi bela dulemar-Moisésʼgi-yolenanaid oambikusgua, Bab-Jehová-e-gangued-yeerdakleged bela dulemar-bukwadgi magarononikid. ");
INSERT INTO cuk_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Agine, Bab-Jehová Moisésʼga, degi, Aarónʼga sunmakded, amarga sogded: ");
INSERT INTO cuk_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","—¡Bemar, we-dulemar-abargi be bangumar! Emiskwaa bela we-dulemar an obelogoed. ");
INSERT INTO cuk_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Moisés Aarón-ebogwa na e-wagar napase dulluu imakdemalad, geb sogdemalad: —Bab-Dummad, ar bee be, bela dulemarga san-burba-dulad-ukmaid. ¿Unnila dule-wargwenbi begi isgusad-ular, bela dulemar sabsur be odurdakode? Sulirgebed. ");
INSERT INTO cuk_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","—Bela Israel-dulemarga be sunmake, ega be soge: ‘Bemar Coré-neggi, Datán-neggi, degi, Abiram-neggi bangumar. Melle a-dikarba bemar gudii gumalo.’ ");
INSERT INTO cuk_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moisés, degi, Israel-girmar-dummaganmala, Datán-maidse, degi, Abiram-maidse nadegusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Geb degine, Moisés Israel-dulemarga sogded: —We-dulemar-isgana-neggi bemar bangumar, degine, melle e-ibmar be ebumalo, ar degiile, wemar-isgusmaladba be burgwemarmogoed. ");
INSERT INTO cuk_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Geb degine, Israel-dulemar, Coré-e-neggi, Datán-e-neggi, degi, Abiram-e-neggi bangudmalad. Datanʼdi, degi, Abiramʼdi e-neggi noalid, e-yawagak-asabin, e-omemala, e-mimmiganmala ambikunonimalad. ");
INSERT INTO cuk_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Agine, Moisés dulemarga sogded: —Wegine geb bemar wisguoed, bela-we-ibmarmar-imakega Bab-Jehová an-barmialid. Wargwen an-na-ibmar-imakbiedba an imaksasulid. ");
INSERT INTO cuk_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","We-machergan, ar igi-dulemar-baigan-burgwemala deyob burgwemarmogale, we-soglegodo, Bab-Jehová an-barmiarsurye. ");
INSERT INTO cuk_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ar Bab-Jehová ibmar-dakledisulid-imakele, napa egaele, agi bela we-dulemar, degi, e-ibmarmala obatele, geb bemar wisgumaloed, we-dulemar Bab-Jehováʼgi nue-dummad-nosmarye. ");
INSERT INTO cuk_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Moisés bela-weyob-ibmar-soggwichid-bergusgua, we-dulemar-bukwadgi napa yog-argaar naded. ");
INSERT INTO cuk_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Napa argadegusad, bela Coréʼba-nanaimalad, degi, e-mimmigan, e-negmar, e-ibmarmar, a-napa-yaba babatided. ");
INSERT INTO cuk_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","We-dulemar, dula napa-yaba babatidmalad, degi, bela e-ibmar-nikamalad napa-yaba babatidmarmogad. A-napa gannar atidegusad. Weyob we-dulemar Israel-dulemar-abargi bar-daklessurmalad, yoggudegusmalad. ");
INSERT INTO cuk_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Bela Israel-dulemar-dikarba-bukwamalad a-dulemar-binnasur-boe-itoarmargu, duurmakdemalad, sogdemalad: —¡Anmar wakinmala! ¡Abakalegi napa anmar-doarmogale! ");
INSERT INTO cuk_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Dulemar dulataled-ilabo gaka dulabo-gakambe (250) Bab-Jehováʼga ina-wawadikid-obupurmaknanaid, soogi-gummakar burgwismalad, ar ade, Bab-Jehová we-dulemargi soo barmialid. ");
INSERT INTO cuk_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Bab-Jehová Moisésʼga sunmakdebalid, ega sogdebalid: ");
INSERT INTO cuk_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Eleazarʼga be soge: ‘Ar esgoro-gordikid-sianar bato ibmar-nue-islidikidga an imaksasoggu, esgoro-gordikid-sianar be sue. A-sianargi soo-gabukwad dikasur be mio. We-Eleazarʼde Aarón-e-machid. We-Aarónʼde dule-irwa-Bab-Dummadse-goledid. ");
INSERT INTO cuk_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","We-dulemar-isgusmaladba-burgwismalad-e-sianar be sue. A-sianarmala matargwa-matargwa be imakoed, adi, amar Bab-Jehováʼga-ibmar-ogumakar-ukleged-ailagi matak-matak nasikegar. Ar ade, we-sianarmarde bato Bab-Jehováʼga uklesad. We-ibmarmala Israel-dulemar-oinsaega guoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Geb degine, dule-irwa-Bab-Dummadse-goled-Eleazar Bab-Jehová-ega-sogsadba we-sianar-esgoro-gordikidgi-sobaledi matargwa-matargwa imaksad. Agine, Bab-Dummadga-ibmar-ogumakar-ukleged-ailagi matak-matak nasiksad. ");
INSERT INTO cuk_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Esgoro-gordikid-sianar-matargwa-matargwa-imaklesadi, Bab-Dummadga-ibmar-ogumakar-ukleged-aila-birgi matak-matak-nasiklesadi, adi, Israel-dulemarga oyogegalad, degi, Aarón-e-wagansurmaladga oyogegalad, degine, dule-ega-igar-uklearsurmaladga oyogegalad melle Bab-Jehováʼga ina-wawadikid ukoye. Ar degisulile, Coré, degi, eba-nanaigusmarmogadyob gumarmogoed, ar igi Bab-Jehová bato iduakwaa Israel-dulemarga Moisésʼba sogsagusa, deyobi gumarmogoed. ");
INSERT INTO cuk_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Deginbali, a-oibosadgine, bela Israel-dulemar gannar Moisésʼgi, degi, Aarónʼgi isdar-sunmakarmarbalid, sogdemalad: “Bemar Bab-Jehová-e-dulemar oburgwismalad.” ");
INSERT INTO cuk_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ar Israel-dulemar Moisésʼgi, degi, Aarónʼgi sunmakarmarsoggu, a-ular, Moisés, degi, Aarón Bab-Dummad-dulemarbo-ambikued-negse nadmalad. Agine, dakdemalad, Bab-Dummadse-goled-neggi Bab-Jehová-e-gangued-yeerdakleged aidenoniki. ");
INSERT INTO cuk_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Geb Moisés, degi, Aarón dulemar-Bab-Jehováʼbo-ambikued-neg-walik gwisgudapmalad. ");
INSERT INTO cuk_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Agine, Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“¡We-dulemar-abargi bemar bangumar, adi, we-dulemar yoga-obeloar an imakegar!” Degidgine, Moisés Aarón-ebo napase dulluu na e-nono imakdemalad. ");
INSERT INTO cuk_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Degine, Moisésʼdi Aarónʼga sogded: “Sianar be sue, Bab-Dummadga-ibmar-ogumakar-ukleged-aila-soo-gasiid egi be urbe. Geb degine, ina-wawadikid agi be eogoed. Geb degidgine, Israel-dulemar-bukwadse gwae be nao, adi, we-dulemar-isgusad-anar we-ina-wawadikid Bab-Dummadga be ukegar. Deyob be imakoed, ar ade, Bab-Jehová bato uluded, dulemar bato nue-nailikguar nanaed.” ");
INSERT INTO cuk_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aarón, ar igi Moisés-ega-sogsadba sianar sussunnad. Degine, dulemar-bukwad-abarse abarmakded. Israel-dulemar bato yaisuli burgwiarmalad. Agi, Aarón Israel-dulemar-isgusad-anar Bab-Jehováʼga ina-wawadikid ukdesunnad. ");
INSERT INTO cuk_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Geb degine, dule-burgwismalad-mamaid-asabin Aarón gwisgusad. E-yarganbardi, dule-dulamalad bukwad. Geb agine, Bab-Dummad-boni-dummad-barmialid galenonikid. ");
INSERT INTO cuk_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","We-boni-dummadgi dulemar miliambe-gakabake gaka dulataled-ilagugle-mergu (14,700) burgwismalad. Coré-e-sordamar Moisésʼgi-yolesmaladba-burgwismaladi, adi, obarlesulid. ");
INSERT INTO cuk_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Geb a-sorbali, boni-dummad galenonigua, Aarón gannar Moisésʼse Bab-Dummad-dulemarbo-ambikued-neg-yawagakse aligusad. ");
INSERT INTO cuk_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Bab-Jehová Moisésʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Israel-dulemarga be sunmakna, ega be sogna: ‘Na e-dadgan-dummagan-warambe-gakabogwad-irba (12) gaapoled wargwen-wargwen sedamaloye. Degisoggu, gaapoled warambe-gakabo (12) sedamaloed. Wemar-gaapoledgi dummagan-e-nugmar bela be narmakoed. ");
INSERT INTO cuk_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Dad-dummad-Leví-gaapoledgine, Aarón-nug be narmakoed, ar ade, dadgan-dummagan-iliba gaapoled nikadbi gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","” ’We-gaapoledmar dulemar-anbo-ambikued-neggi Dulemar-Anbo-Igar-Mesisad-Ulu-asabin, bia an bebo-sunmakdae, agi be mesoed. ");
INSERT INTO cuk_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Gaapoled-aramakoedi, an a-e-ibed an suoed. Adi, Israel-dulemar-begi-gwisguardamaladi, melle bar begi sunmakmalagar.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Degidgine, Moisés Israel-dulemarga sunmaksagu, dadgan-dummagan-warambe-gakabogwad-e-dummagan-iliba gaapoled senonimalad. Degisoggu, gaapoled warambe-gakabo (12) senonimarsundo. We-gaapoledmar-wargwenad, Aarón-gaapoled gued. ");
INSERT INTO cuk_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Agine, Moisés Bab-Jehová-asabin gaapoledmar Bab-Dummad-Israel-Dulemarbo-Igar-Mesisad-Ulu-siid-asabin urbisad. ");
INSERT INTO cuk_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Degidgine, Moisés banedgine Bab-Dummad-Israel-Dulemarbo-Igar-Mesisad-Ulu-siidse-dogdegu, dakalid, Leví-wagwa-Aarón-gaapoled aradik-mai, e-dutumar-nanai, e-madumar nagusnanai, degine, almendroʼmar sanmaksananai daksad. ");
INSERT INTO cuk_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Geb degine, Moisés, bela-Israel-dulemar we-gaapoledmar-dakmalaga, Bab-Jehová-asabin-gaapoled-bukwadi onosad. Amar bela we-gaapoledmar daksamalad, degine, dummagan na egad-egad susmarsunnad. ");
INSERT INTO cuk_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Agine, Bab-Jehová Moisésʼga sogdebalid: “Gannar Aarón-gaapoled an-bemarbo-Igar-Mesisad-Uluse be mesna, adi, dulemar-anba-dasurmaladga wilubga guegar. Adi, a-dulemar melle begi bar urwemalagar. Ar urwemalale, we-dulemar burgwemaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moisés bela Bab-Jehová-ega-ibmar-sogsadba imaksad. ");
INSERT INTO cuk_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Geb degine, Israel-dulemar Moisésʼga sogdemalad: “¡Anmar bela oitolemaloed! ¡Bela anmar burgwemaloed! ");
INSERT INTO cuk_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ar dule Bab-Jehová-goled-negse-nadele, burgwemaloed. Degisoggu, bela anmar burgwemarsunnoed.” ");
INSERT INTO cuk_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Bab-Jehová Aarónʼga sogded: “Israel-dulemar anse-goled-neggi isgusale, begi, be-masmalagi, degi, be-dad-dummad-Leví-e-wagangi ataklegoed. Ar bemar dule-irwa-anse-gormalad na be-arbanaidgi isgusardi, begi, degi, be-mimmigangi ataklegoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","”Aarón, igi, be-masmaladibe, anse-goled-neggi bemar arbananaile, be-gwenadgan-Leví-wagan-baigan bemar-bendakega be imakmalo. ");
INSERT INTO cuk_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Wemala bemar-ibmar-imakedgi be-bendakmaloed, dulemar-anbo-ambikued-neg-akwega gumarbaloed. Degi-inigwele, ibmar-anga-uklesmaladse warmakosurmalad, degine, melle burgwemalaga anga-ibmar-ogumakar-ukleged-ailase warmakosurmarbalid. ");
INSERT INTO cuk_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","We-Leví-dulemala bemar-bendakedga gumaloed. Degine, we-Leví-dulemar dulemar-anbo-ambikued-neg dakmaloed, degine, bela agi-ibmar-imaklemalad imakmarbaloed. Degisoggu, agi bemar ibmar-imaknaigusale, Leví-dulemarbi bemarse warmakmaloed, dule-baigandi bemarse warmakosurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","”Unnila bemarbi An-Neg-Islidikid, degine, anga-ibmar-ogumakar-ukleged-aila dakmaloed, adi, melle bar Israel-dulemar sabsur an odurdakegar. ");
INSERT INTO cuk_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ar Israel-dulemar-abargi, ani an be-gwenadgan-Leví-dulemar an-sunnad an bemarga ukega susad, adi, dulemar-anbo-ambikued-neggi arbamalagar. ");
INSERT INTO cuk_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Unnila be, degine, be-masmalabi dule-irwa-anse-gormaladga gumaloed. A sogleged, anga-ibmar-ogumakar-ukleged-aila, degine, mor-dummad-naid-yarganba-ibmar-bukwad unnila bemarbi dakoye. Ani an bemarga dule-irwa-anse-goled-e-arbaed an uknaid. Ar dule-baid a-ibmar imakye-sogele, adi, oburgwelegoed.” ");
INSERT INTO cuk_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Bab-Jehová Aarónʼga sogdebalid: “Deginbali, dulemar anga-ibmar-ukmaloed-akwega an be-imakbalid. Ar bemar anga ibmar-akwemaladsoggu, bela Israel-dulemar anga ibmar-ukmalad, an bega, degi, be-masmalaga an ukoed. We-igarde degii-maigua sadeguoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ibmar-anga-uklegaled-ogumaklessurmalad, begadga gumaloed. Israel-dulemar ibmar-bela-anga-ukmalad, ibmar-gwagmar, isgued-ular ibmar-ukmalad, degi, e-nosad-ular ibmar-ukmalad, bela we-ibmarmala bega, degi, be-masmalaga ibmar-islidikidga guoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","We-ibmarmala bemarga ibmar-islidikid gumalad. Anse-goled-neggi we-ibmarmar be gunmaloed. Bela machergan we-ibmarmar nabir gunmaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Bab-Jehová Aarónʼga sogdebalid: “Deginbali, bela Israel-dulemar anga-ibmar-bana-bana-ukmaloedi, begala, degi, be-masmalagala, be-bunamalagala, we-ibmarmar an ukbaloed. Ar be-neguyagi bela islidik-gudimaladi sunna we-mas gunmarmogoed. We-igala degisadegu maiguoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","”Deginbali, ibmar-gebe-sanmakmalad, ibmar-bur-nuegan Israel-dulemar anga-senonimaloedi, olivo-gwallu, vino-binid, degi, ibmar-gwagmala, wemar bemarga an ukbaloed. ");
INSERT INTO cuk_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Israel-dulemar na e-nainugi gebe-ibmar-sanmakmalad-anga-sedamaloedi, an bemarga ukbaloed. Ar dule be-neguyagi bela islidik-gudimaladi we-ibmarmala nabir gunmaloed. ");
INSERT INTO cuk_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","”Israel-dulemar bela anga ibmar-ukmaladi, bela an bemarga ukbaloed.” ");
INSERT INTO cuk_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Bab-Jehová Aarónʼga sogdebalid: “Machigwa-gebegwaluleged, ibdurgan-gebe-gwalulemalad-anga-ukleged amba begadga gubaloed. Degi-inigwele, machigwa-gebegwaluleged sunna manigi onolegoed. A-sogleged, a-machigwa-anar mani uklegoye. Ibdurgan-sailagined-swilidiksulid anga-uklegosulid, degisoggu, a-anar mani uklebaloed. ");
INSERT INTO cuk_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Duledibe, igi, ibdurgandibe, nii-wargwen-nikadgi onolegegala, mani-sibu-gwaatar-anse-goled-neggi-mani-aidikued-ebislegedyob a-anar uklegoed. We-manimala, gera-dulagwen (20) nanaed. ");
INSERT INTO cuk_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","”Moli-bebe-nikaddi, sibad-wawaaddi, degi, sibaddi manigi onolegosulid. Ar ade, we-ibmarmardi anga uklegaledid. We-ibmarmar-e-abedi ibmar-ogumakar-ukleged-aila-dikarba be eogoed, degine, we-ibmarmar-gwallumardi ogumakar anga be ukoed. We-gwallumar-gummakaled yeer-yapan an itodaed. ");
INSERT INTO cuk_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Degi-inigwele, we-ibmarmar-e-sandi, e-binasgardi, e-dua-nued-sikiddi be suo, begadga be imako. ");
INSERT INTO cuk_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Israel-dulemar anga bela-ibmar-ukmalad, bela bega, be-masmalaga, be-bunamalaga an uked. Weyob we-igar degimaigu sadeguoed.” ");
INSERT INTO cuk_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Bab-Jehová Aarónʼga sogdebalid: “Israel-dulemar-abargi bega nainumar an ukosulid, ar ade, ani we-Israel-dulemar-abargi an begadga gued. ");
INSERT INTO cuk_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","”Bela Israel-dulemar-ibmar-ambegi-gwensak-anga-ukedi (10%), Leví-dulemarga we-ibmarmala an bela ega ukoed. Ar wemar dulemar-anbo-ambikued-neggi-arbamarsoggu, a-bennukega an ega bela ukoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Israel-dulemar dulemar-anbo-ambikued-negse warmakosurmalad. Ar warmaksale, angi-isgusadba burgwemaloed. ");
INSERT INTO cuk_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","A-ulale, Leví-dulemar dulemar-anbo-ambikued-neggi arbamaloed. Ar Israel-dulemar anse-goled-neggi isgunonimalale, Leví-dulemargi a-isgusad nagunonikoed. We-igar degisadegu dulemar-danimaloedga maigu guoed. Leví-dulemar e-gwenadgan-Israel-dulemar-baiganba yar nikuosurmalad. ");
INSERT INTO cuk_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ar ade, ani an Leví-dulemarga Israel-dulemar-ambegi-gwensak (10%) anga-ibmar-uklegedi, an uksad. A-ulale, Israel-dulemar-abargine, we-Leví-dulemarga yar an uksasulid.” ");
INSERT INTO cuk_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Bab-Jehová Moisésʼga sogded: ");
INSERT INTO cuk_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Leví-dulemarga be sunmako, ega be sogo: ‘Israel-dulemar ibmar-ambegi gwensak (10%) anga-ukega senonikile, we-ibmar Bab-Jehová-bega-sogsadba begadga guoed. Bela ibmar-begadga-guoedi ambegi gwensak (10%) Bab-Jehováʼga be ukmogoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","” ’Igi Israel-dulemar-baigan anga ibmar-gwag-bur-nued-ukmoga, degi, vino-ukmoga, deyobi, bemar anga uksamarmoye soglemogoed. ");
INSERT INTO cuk_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Weyobi, Israel-dulemar be-Bab-Jehováʼga ambegi-gwensak-ibmar-ukedi (10%), a-ibmar be-Bab-Jehováʼga be ukmogoed. Dule-irwa-Bab-Dummadse-goled-Aarónʼye-nugadga be ukoed. We soglegoed, be-Bab-Jehováʼga we-ibmar be uksaye. ");
INSERT INTO cuk_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Bela bega-ibmar-uklegoedi, abala be ibmar-bur-nuegan Bab-Jehováʼga ukoed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Bab-Jehová Moisésʼga sogdebalid: “Leví-dulemarga be sogbalo: ‘Ibmar-bur-nuegan Bab-Jehováʼga be uksale, soglegoed, na be Bab-Dummadga ibmar-gwag, degi, vino uksaye. ");
INSERT INTO cuk_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","We-ibmar-gwabguoedi bia na bemar gunbimala, na be gunmalodo, degine, be-gwenadgan gunmarmogoed. Ar ade, we-ibmargi Bab-Dummad-dulemarbo-ambikued-neggi-be-arbaedgi be bennuklesiid. ");
INSERT INTO cuk_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","We-ibmar Bab-Jehováʼga be uksale, a-sorba, a-ibmar-gwabguoedi sunna be gunnoed. Be guchale, be isguosulid. ” ’We-ibmar Bab-Jehová-bega-sogedba be imakoed. Melle be Bab-Jehováʼgi yolemalo. Ar degiile, be burgwemaloed.’ ” ");
INSERT INTO cuk_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Bab-Jehová Moisésʼga, degi, Aarónʼga sunmakded, ega sogded: ");
INSERT INTO cuk_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“We-igala, ani, Bab-Jehová an igar uked. Israel-dulemarga be soge: ‘Moli-bebe-nikad-ome-ginnid, swilidikid, bonigan-nikasulid, degi, bipisaale gwen amba yoo oarbaleged be sedamaloye. ");
INSERT INTO cuk_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","We-moli-bebe-nikad dule-irwa-anse-goled Eleazarʼye-nugadga ukmaloed. Eleazar bemar-danar-danar-bukwadgi we-moli-bebe-nikad-ome onogega imakoed. Geb degine, agi a-moli-bebe-nikad-e-nono egwannega imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","” ’Geb degidgine, dule-irwa-anse-goled-Eleazar, e-goo moli-bebe-nikad-abegi owardikuogu, geb agi ilagugle (7) dulemar-anbo-ambikued-neg-e-yawagaksik bomi-bomi imakoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Deginbali, moli-bebe-nikad e-asabin-ogumakega imakbaloed. We-ibmarmar ogumaklegoed: Moli-bebe-nikad-e-uka, e-san, e-abe, degi, e-saa. ");
INSERT INTO cuk_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Geb degine, dule-irwa-anse-goled, urwar-e-anagan, hisopo-e-ana, degi, mor-ginnid suoed. Geb degine, soo-yagi moli-ogumaknaidba-mesa a-ibmar ogumakoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","” ’A-sorbali, dule-irwa-anse-goled na e-mor enukoed, degi, obbaloed. Geb a-sorbali, mutikguedse nabir Israel-dulemar-danar-danar-bukwadse naoed. Mutikguedse swilidiksuli-gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Amba deyobmogoed, dule-moli-bebe-nikad-ogumaksad, na e-mor enukmogoed, degi, obmogoed. We-dulegi neg-mutikguedse swilidiksulidye soglegoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","” ’Geb agine, dule-gwensak-igar-maidba-swilidik-gudiid moli-bebe-nikad-ogumaklesad-e-buru weoed. Geb dulemar-danar-danar-bukwad-magaba, neg-swilidikidgi urboed. Agi, Israel-dulemarga sabolegoed. Israel-dulemar we-buru dii-ibmar-urukedgi-ebulegega imakoed. Wede anga isgued-anar uklenaid. ");
INSERT INTO cuk_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Dule-moli-buru-wesad na e-mor enukmogoed. We-dule neg-mutikguedse swilidiksurye soglegoed. Israel-dulemar, degi, Israel-dulesurmaladga weyob ega igar maigu guoed. A-igar degisadegu maigu guoed.’ ” Bab-Jehová Moisésʼga, degi, Aarónʼga sogdebalid: “Israel-dulemarga be soge: ");
INSERT INTO cuk_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","‘Dule-gwensak dule-burgwisad-ebusale, ibagugle (7) Bab-Dummad-asabin swilidiksuli guoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Dule-burgwisad-ebusad-ibapaagine dii-nued-islidikidgi na san urukoed, degi, ibagugledgine (7), we-dii-nued-islidikidgi na san urukbaloed. Geb agine, san swilidik gunonikoed. We-dule, a-ibapaagine, igi, a-ibagugledgine (7) san uruksulile, swilidiksuli-gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","” ’Dule-gwensak dule-burgwisad-ebusad-ular, san uruksulile, we-dule anse-goled-neg oichogoed. A-dule, Israel-dulemar-abargi onolegoed, ar ade, dule-uruked-diigi san uruksasulidba, egi isgued naigu guoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","” ’Dule-wargwen negyagi burgwisale, weyob ega igar-mai guoed. A-negyase dule dogsale, degine, ar doamala a-negyagi bukwamala, we-dulemala ibagugle (7) Moisés-Igar-Maidba burbar-swilidiksuli gumaloed. ");
INSERT INTO cuk_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Deginbali, bormo argasiidibe, igi, nue-atuarsurdibe, we-bormo swilidiksurye soglegoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","” ’Dule-gwensak sapurba dule-yamo-oburgwilesad-ebusale, dule-nuedgi-burgwisad ebusale, igidibe, neg-uangindibe, igi dule-burgwaled-e-gar-ebusdibe, we-dule ibagugle (7) swilidiksuli-gudii guoed. ");
INSERT INTO cuk_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","” ’Dule-swilidi