﻿USE sofia;
DROP TABLE IF EXISTS sofia.cuk09_vpl;
CREATE TABLE cuk09_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cuk09_vpl WRITE;
INSERT INTO cuk09_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo e-dadgan-siki ilekwaa-danikid e-garda. Jesucristo, David-e-wagwa, degi, Abraham-e-wagwabar. ");
INSERT INTO cuk09_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham-machidi nuga Isaac, Isaac-machidi Jacob, Jacob-machidi Judá, degi, Judá urbamarde. ");
INSERT INTO cuk09_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá-machidi Fares, degi, e-machi-baiddi Zara, We-machi-warbogwad-e-nandi nuga Tamar. Fares-machidi nuga Esrom, Esrom-machidi Aram. ");
INSERT INTO cuk09_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram-machidi Aminadab, Aminadab-machidi Naasón, Naasón-machidi Salmón. ");
INSERT INTO cuk09_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón, Rahab-ebo Booz-baksad, Booz, Rut-ebo Obed-baksamogad, degi, Obed-machidi nuga Isaí. ");
INSERT INTO cuk09_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí-machidi Rey-David, Rey-David-machidi Salomón, Salomón-e-nandi Urías-e-omega-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón-machidi nuga Roboam, Roboam-machidi Abías, Abías-machidi Asa, ");
INSERT INTO cuk09_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa-machidi Josafat, Josafat-machidi Joram, Joram-machidi Uzías, ");
INSERT INTO cuk09_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías-machidi Jotam, Jotam-machidi Acaz, Acaz-machidi Ezequías, ");
INSERT INTO cuk09_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías-machidi Manasés, Manasés-machidi Amón, Amón-machidi Josías. ");
INSERT INTO cuk09_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Judiomar gales Babiloniase ebipilesmargu, Josías machimala-nikunoni, Jeconías, degi, e-urbamar. ");
INSERT INTO cuk09_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Judiomar gales Babiloniase e-bipilesmalad-sorba, Jeconías, Babiloniagi, Salatiel-nikunonimogad, Salatiel-machidi nuga Zorobabel. ");
INSERT INTO cuk09_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel-machidi Abiud, Abiud-machidi Eliaquim, Eliaquim-machidi Azor. ");
INSERT INTO cuk09_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor-machidi Sadoc, Sadoc-machidi Aquim, Aquim-machidi Eliud. ");
INSERT INTO cuk09_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud-machidi Eleazar, Eleazar-machidi Matán, Matán-machidi Jacob. ");
INSERT INTO cuk09_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob-machidi José, José, María-e-sui, geb Jesús agi gwalulesad. We-Jesús, Cristoye nugad. ");
INSERT INTO cuk09_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Degisoggu, Jesús-e-dadgan, Abraham-akar Davidse, e-ambe-gakabake gued, degi, David-akar, Judiomar gales Babiloniase ebipilesmaladse, e-ambe-gakabakebalid, degi, Judiomar gales Babiloniase ebipilesmalad-akar Cristose e-ambe-gakabakebardo. ");
INSERT INTO cuk09_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo weyob gwalulesad: María, Jesús-e-nan, deun José-ebo igar nabosmalad na nikumaloye. Na nikued-idu, María daklealid, bato gurgin-nika gudii, Bab Dummad Burba Nued egi ataksadba. ");
INSERT INTO cuk09_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, María-sui, dule-gwage-nuedsoggu, yapa-María-obingesaedba arbakee mete-sokalinad. ");
INSERT INTO cuk09_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ar José degi-binsadii, gabgi Bab-Dummad-e-anger ese nonikid, ega sognonikid: “José, David-wagwa, mer be dobgu, be-ome-María na be abingae, ar María-bonigwar be dakedi, we Bab-Dummad-Burba-Nued-sogedba deyob gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María, machi-wargwen-nikuoed, Jesúsye be onugsao, ar ade iskuedgi e-neggwebur abonogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ar José, degi, Maríaga weyob bela ibmar-gusadi, deyob gusdo, adi Bab Dummad, na E-gaya-burba-berbegedba, na ibmar-sogsadba guegar, deun sogsa-gusgu: ");
INSERT INTO cuk09_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Emi be dake, yagwa-wargwen gurgin-nika guo, machi-nikunoniko, Emanuelye nugsalegoed. Is. 7:14 Emanuel sogleged, “Bab Dummad anmarba gudiiye.” ");
INSERT INTO cuk09_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José gabdakmaid-sorba ataksagu, ar igi Bab-Dummad-e-anger ega sogsa, deyob imaksad, José, María-nikunonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ar degite amba ese gochasurgweled, María na machi-gebe-nikusad-sorba geb ese gochad. Machigwa gwalulesad, Jesúsye nug imassun. ");
INSERT INTO cuk09_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús Judea-yalagi, Belén-neggweburgi gwalulesgu, deun Rey-Herodes neg-dakmaidgi, girmar-dada-nakwe-dorgan-ibmar-nue-wisimalad Jerusalénse nonimalad, ");
INSERT INTO cuk09_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","sognonimalad: —¿Bia Judiomar-E-Rey-gwalulesad mai? Ar ade anmar dada-nakwedba e-niskwa daksamalad, anmar ese danimarsunnad e-nug odummogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rey-Herodes degi-ega-soge itoargu, surbinsa-ito naded, degi, bela Jerusaléngi-bukmalad eba surbinsa-ito nadmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes bela dule-irwa-Bab-Dummadse-gormalad-e-dummaganse, degi, escribamarse gochagu, amarse egichialid, bia Cristo gwalulegoye. ");
INSERT INTO cuk09_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Amar, abin-imakdemar: —Cristo Belén-neggweburgi gwalulegoed, Judea-yalagi, ar deyob Bab-Dummad-gaya-burba-berbeged narmakar-obesad sognaid: ");
INSERT INTO cuk09_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Be, Belén-neggwebur, Judea-yalagi siid, be baisur-dakle-inigwele, ar neggwebur-baiganba be-bur nue nug nikad, ar ade begi dule-neggwebur-seoed nodagoed, adi an-dulemar-Israel-akwegar, igi sibad-wawaad-edarbed na e-sibad-wawaad-akwemogadyob. ");
INSERT INTO cuk09_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Degi Herodes, girmar-dada-nakwe-dorganse arbakee gochagua, ese nue egichialid, sana nue niskwade emarde daksamarye. Ega sogsamargu, ");
INSERT INTO cuk09_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Herodes Belénse amar-barmis, degi, amarga sogde: —Weba Belénse be namar, nue be mimmi-amimalo. Ar be amismalale, an-owisononiko, adi an ese namogagar, an e-nug odummo namogagar. ");
INSERT INTO cuk09_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Girmar-dada-nakwe-dorgan, Rey-Herodes degi-ega-soge itosmargu, nadmarsun. Amar dada-nakwedba niskwa-daksamalad e-idu nadap-gusad. Geb mosmargu, bia-mimmi-maidgi, agi niskwa mimmi-inikii nai-gunonikid. ");
INSERT INTO cuk09_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Girmar-dada-nakwe-dorgan niskwa-daksamargu, bela nue-weligwar itosmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Girmar-dada-nakwe-dorgan, neg-yaba dogdemargu, mimmi-dakdemar e-nan-María-walik mai, degi, yokorgi sindigar abin sigidmargu, mimmi-e-nug odummodmalad. Degine, girmar-dada-nakwe-dorgan na e-ulu egadmar, mimmiga ibmar-nuegan ukmalagar. Ega uksamalad: Olo, ibmar-wawadik-yapanned, degine, sapi-gunnugiid-wawadikmalad, mirra nugad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ar gabgi Bab Dummad girmar-dada-nakwe-dorgan-owisosad, melle gannar Herodesse bar naoye. Degisoggu, girmar-dada-nakwe-dorgan gannar e-neggweburse nadmalad, igar-baidsik. ");
INSERT INTO cuk09_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ar girmar-dada-nakwe-dorgan-naded-sorba, agi Bab-Dummad-e-anger gabgi Josése nonikid, ega sognonikid: “Be gwisgu, mimmi, degi, e-nan be sue, Egiptose bemar wakin. Weba be gudigumalo an-bega-sogedse, ar ade Herodes mimmi-amidagoed, oburgwegar.” ");
INSERT INTO cuk09_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José atakargu, mimmi, degi, e-nan, yog suar imaksad, a-mutikidba Egiptose ega wakitesunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Agi gudigusmalad, Herodes burgwisadse. Bab-Dummad-ibmar-sogsadba guegala deyob gusad, deun Bab-Dummad-gaya-burba-berbeged sogsa-gusgu: An-machi Egiptogi mai, an ese gochad, Israel-yarse dagegar. ");
INSERT INTO cuk09_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes dakdegu, girmar-dada-nakwe-dorgan e-yardaksa, nue sae-itoded. Degisoggu, a-ulale bela Belén-neggweburgi, degi, neggwebur-dikarbarmalad machimala-birgabo-akuar-nikmalad-oburgoye igar uksasunnad, ar ade nue-itosad mimmi birgabosaar nikar-gebye. ");
INSERT INTO cuk09_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herodes mimmigan-oburgwisad, ar igi Jeremías, Bab-Dummad-gaya-burba-berbeged sogsa-gusa, deyob gusad, deun sogsa-gusgu: ");
INSERT INTO cuk09_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá-neggweburgi dulemar oimakbuk-itolesad, bela-bela bukib-itomaladbali, nue boedbimalad, Raquel na e-mimmiganga boe itosmalad, ar dule-wargwensaar we-ome-bukib-binsaed-osuloged gwen nika-gussulid, ar ade e-mimmigan burgwisad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes-burgwisad-sorba, Bab-Dummad-anger-wargwen, Egiptogi Josése gabgi nonikid, ");
INSERT INTO cuk09_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ega sognonikid: “Be gwisgu, mimmi, degi, e-nan be sue, Israel-yalase be nae, ar dulemar-mimmi-oburgwebi-gusmaladi bato bela burgwismalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Geb degi José gwisgussun, mimmi, degi, e-nan-susgua, Israel-yalase nonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ar José itoargu, Arquelao, Judea-yalagi, e-bab-Herodes-sorba neg-dakmaiye, dobe ase nae-gualid. Ar gabgi Bab-Dummad-ega-sogsadba José Galilea-yalase nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","José Galilea-yarse nonigu, neggwebur-Nazaret-nugadse megnonikid, adi Bab-Dummad-gaya-burba-berbemalad-sogsamaladba guegar, deun sogsamargu, Nazaretginedye bilegoye. ");
INSERT INTO cuk09_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Deun a-ibagangi Juan-Bautista Bab-Dummad-igargi sunmaknonikid, Judea-yargi, nega-dule-sulidganba, ");
INSERT INTO cuk09_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","sognonikid: “Be-iskuedga na be ulubgi bukib-binsamar, be-daed be gwagmarsun, ar Bab-Dummad-neg-dakmaid bemar mosad.” ");
INSERT INTO cuk09_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ar wegi Bab-Dummad-gaya-burba-berbeged, Isaías, sogsa-gusad, deun sogsagu: Dule-wargwen nega-dule-sulidganba binnasur sunmaknonikoed, dulemarga sognonikoed: “Dule-Dummad-idu igar mayemar, igar-swilidik mesmar.” ");
INSERT INTO cuk09_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","We-dule, Juan-Bautista-nugad, moli-yargan-mureged-e-absar na e-morga imakdigualid, degi, moli-uka e-molidubga imakdiguarbalid, geb ses nabir gulleged, degi, achanis e-masga imakdigusbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalénginmalad, bela Judea-yalaganbarmalad, degi, Jordán-diwar-dikarba-dulemar-bukmalad, Juanse duurmaknonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","E-iskudiid na dukin-dukin barsognanai-guarmalad, geb Juan Bab-Dummad-digi-ogleged-igar imaknai-gualid, Jordán-diwargi. ");
INSERT INTO cuk09_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Juan dakargu, Judiomar Fariseo-sordamalad, degi, Judiomar Saduceo-sordamalad, bukidar ese Bab-Dummad-digi-ogleged-igar imakdani, amarga sogdesun: “¡Ar bemar naibe-bulegan-e-mimmiganyob gumalad! ¿Ar doa bemar-odurdaksa, Bab-Dummad-nue-urwedanikoed-idu wakinned? Bemar Bab-Dummad-digi-oglegedgi nuguosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Degisoggu, be-daedgine na be oyomar, bemar nue gwagsamalad, be-iskuedga na be bukib binsasmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Mer unnila na be sogmalo: ‘Anmar Abraham-wagan gumar, a-ulale Bab Dummad anmargi nabir binsaer-gebed.’ Suli, degisuli. Ar be Abraham-wagwasulile, akarsulid. Ar Bab Dummad sunna we-akwamar Abraham-e-waganga imaked. ");
INSERT INTO cuk09_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","“Deginbali, ar bato akan guar sapi-maligi yoid, ar degisoggu, sapi nue sanmaksulile, a-sapi siklegoed, soogi melledoed, ogumaklegegar. Deyob Bab Dummad dulemar-imakmogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ar andi napiragwad Bab-Dummad-digi-ogleged-igar an imakedi, an unnila digi ogdiid, bemar-iskusmalad na ga be bukib-binsasmalad oyogegar. Ar dule-an-sorba-danikiddi, ar anba bur dule-dummadsoggu, e-sapatse-bakar geg an ega seed. Ar dule-an-sorba-danikiddi, Bab Dummad Burba Nuedgi, degi, soogi be-ognonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Igi dulemar madubur-gwagwaled egwamala, deyob we-a-dule, dule-dummadid, bato guagwar e-argangi bigbi ganigwichid, madubur-gwagwaled na egwaoed, degi, na madubur-gwagwaled-nued na nue e-urbedgi na urboed, e-ukadi soogi ogumakoed, ar we-soode geg soo ginnedid, degi-gasii-sadeguad-sood. We sogledo, dule-an-sorba-danikoed madubur-gwagwaledyob dulemar-imakmogoye.” ");
INSERT INTO cuk09_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Degi, Jesús Galileagi gudiid, Jordán-diwarse nonikid, adi Juan Bab-Dummad-digi-ogleged-igargi e-ogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ar Juandi surye Jesúsga sogenad, ar ade ega soged: —Ar be, Bab-Dummad-digi-ogleged-igargi bur an-ogedid, ar be-bur anba dummadid. ¿Degite, anse be danide, an be-ogegar? Suli, degisuli. ");
INSERT INTO cuk09_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ar Jesúsdi, abin-sogded: —Ar emigindi anmar deyob saer-gebed, igar-maidba anmar imaker-gebed. Degisoggu, Juan Bab-Dummad-digi-ogleged-igargi Jesús-ogsasun. ");
INSERT INTO cuk09_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ar Jesús Bab-Dummad-digi-ogleged-igar-imaksad-sorba diwargi-gwichid nakwiarsun. Agi geb nibneg ega argaded, degi, Jesús, Bab Dummad Burba Nued nuuyobi egi aidedani daksad. ");
INSERT INTO cuk09_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Geb degi nibneggi gaya-burba gollalid, sogded: “We, An-Machi-sabed-sunnad gued, weba weligwar an itoged.” ");
INSERT INTO cuk09_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Juan Bab-Dummad-digi-ogleged-igargi Jesús-ogsad-sorba Bab Dummad Burba Nued nega-dule-sulidganba Jesús-sessun, nia-sailase wilubdaklegegar. ");
INSERT INTO cuk09_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús Bab-Dummadse-golegala iba-dulabogus mutikid, degi, ibginedba mas-gunsuli gudigusad-sorba, ukur itoalid. ");
INSERT INTO cuk09_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Degi nia-saila, dule-wilubdaked ese nonikid, ega sognonikid: —Ar be Bab-Dummad-Machi-sunnadile, we-akwamarga be soge: ‘Maduga be-binyeye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús, abin-imakdegu, nia-sailaga sogde: —Noar be soged, ar Bab-Dummad-Gardagi narmakar naid: Dule maduginbi dula gudiguosulid, bela Bab-Dummad-gaya-burba-itogedgi dula gudigubaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Geb degi nia-saila neggwebur-islidikidse Jesús-ses, Jerusalénse. Agi Bab-Dummadse-goled-neg-uas-birgi ogwisdapgu, ");
INSERT INTO cuk09_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jesúsga sogded: —Ar be Bab-Dummad-Machi-sunnadile, be napase ichomakdo, ar Bab-Dummad-Gardagi narmakar naid: Na e-angermar bega barmidagoye, e-argangi be-gamaloye, adi melle be nag akwagi yolegegarye. ");
INSERT INTO cuk09_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús, nia-saila-abin sogde: —Nabir be sogendo, ar Bab-Dummad-Gardagi narmakar sognaibalid: Melle Dummad, be-Bab-Dummad, be wilubdakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Geb degi gannar nia-saila yar-matusulidse Jesús-sesbalid, agi belagwable napa-naid, degi, e-gangumalad ese oyosgu, ");
INSERT INTO cuk09_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","geb Jesúsga sogded: —An-nug odummogegar, be sindigar an-asabin siger, geb we-ibmar belagwapa an bega ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Geb degi Jesús, abin-sogded: —Nia-saila-Satanás, be angi bangu, ar Bab-Dummad-Gardagi narmakar naid: Ar Dummad, be-Bab-Dummad, Asebi be goloed e-nug odummogegar, unnila agarbi be ibmar-imakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Geb degi nia-saila Jesúsgi bangussun. A-sorba angermar Jesússe nonikid, ega ibmar imaknonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús itoargu, Juan-Bautista eskaryagi mellesiiye, Jesús gannar Galilease nonikid. ");
INSERT INTO cuk09_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaretgi-maid bangudgu, Capernaumgi megnonikid, mata-dummad-naid-walik, Zabulón-yala, degi, Neftalí-yala-walik. ");
INSERT INTO cuk09_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ar Bab-Dummad-gaya-burba-berbeged, epenne-Isaías-sogsa-gusadba guegala deyob gusad, deun sogsa-gusgu: ");
INSERT INTO cuk09_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón-yala, degi, Neftalí-yala, mata-dummad-naidsik, Jordán-diwar-obakar-bukmalad, Galilea-dola, Judiosurmalad, ");
INSERT INTO cuk09_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","a-neggweburgi Bab-Dummad-wichuli-bukmalad nega-sichidgi siidyobid, dule-wargwen Bab-wisgusar, gwallu-dummad-meegwad ega ganonikidyobid, dulemar-neg-sichidgi-burgwednagagi-bukmaladga, dule-wargwen nonikid, ega gwallu-meegwad-ganonikidyob nonikid. ");
INSERT INTO cuk09_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Degi, agi Jesús Bab-Dummad-gaya-burbagi sunmakarsun: “Be-iskudiidga na be bukib binsamar, be-daed na be ogwamar, ar Bab-Dummad-neg-dakmaid bemarse warmaksad.” ");
INSERT INTO cuk09_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea-mata-dummad-gakaba nadapgu, dule e-urba-ebo mata-dummadgi saki-minai dakalid. Gwensak Simón, Pedroye-nugbalid, degi, e-urba-Andrés. Amarde gusgu ua-gaedgi arbamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús amarga sogde: —Anba be dagmar, igi bemar ua-gae, abayobi dulemar-napneggi-bukwad gaega, an be-odurdakmaloed, adi dulemar anba nagumalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Abga Simón, degi, Andrés, e-saki yog indakar, Jesúsba yog naar imasmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesús sikwas nadbargu, Santiago, Zebedeo-machi, degi, e-urba-Juan, a-ebo urgi e-bab-Zebedeomala saki-matumakbukwa dakdapid. Jesús amar-warbose-gochamogad, eba dagegar e-sapinganga guegar. ");
INSERT INTO cuk09_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Amar yog ur, degi, e-bab-Zebedeo mete nadmalad, Jesúsba naegar. ");
INSERT INTO cuk09_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús bela Galilea-yalaganba gudigusad, Judiomar-onmaked-neggi dulemar-odurdakdii, Bab-Dummad-neg-dakmaid-gaya-burba-nuedgi sunmakdii, degine, dulemar bela uelemalad, degi, galagwensuli ibmar-nunmak-itomalad nudakdii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesús dulemar-nudakdiidba, bela Siria-yalase e-nug dunguded. A-ular dulemar bela ibmar-naibi-itodimalad, galagwensuli-gegudimalad, abgan-nunmakdimalad, niasamalad, suu-itodimalad, abgan-burgwarmalad, Jesússe senonimalad. Bela Jesús amar-nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Dule-bukidar Jesúsba duurmaknadap-gusmalad, Galilea-dorgan, neggwebur-gwaambe-bukmaladginmalad, Jerusalénginmalad, Judeaginmalad, degi, Jordán-diwar-obakarmalad, amar Jesúsba duurmaknadap-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús dulemar-bukidar ese duurmakdani dakdegu, yar-birse nakwisad. Agi sigisgu, e-sapingan ese nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Degi, Jesús dulemar-odurdakdegu, sogded: ");
INSERT INTO cuk09_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Dulemar burbar na wileged itoger, amargi nued binsalesad, ar ade Bab-Dummad-neg-dakmaid amargadid. ");
INSERT INTO cuk09_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Dulemar-bodidimalad, amargi nued binsalesad, ar amar-bukib-binsadiid, weligwaled ega uklegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Dulemar na san-dummarba imaksurmalad, amargi nued binsalesad, ar amar we-napneg-naid egadga guoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Dulemar-igar-napiragwad-bina mas-gunbiedyob itodimalad, degi, uku-uku itodimalad, amargi nued binsalesad, ar Bab Dummad nabir igar-inikigwad-imaked amar-imakoed igi dulemar immerba nabir itononidamaladyob. ");
INSERT INTO cuk09_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Dulemar nue wile emar-daked, amargi nued binsalesad, ar amar wile daklemogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Dulemar-gwage-swilidikmalad, amargi nued binsalesad, ar amar Bab-Dummad-dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Dulemar emar-gwage-bogidik-imakmalad, amargi nued binsalesad, ar amar Bab-Dummad-mimmiganye bilenonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Dulemar igar-inikigwad-bina baregilledimalad, amargi nued binsalesad, ar ade Bab-Dummad-neg-dakmaid amargadid. ");
INSERT INTO cuk09_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Dulemar an-nug-ular be-ichoarmalar, be-bareginnarmalar, degi, galagwensuli binsa gakansaar begi sunmakarmalar, bemargi nued binsalesdo. ");
INSERT INTO cuk09_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Bemar yeer itomar, wergumar, ar nibneggi bemarga ibmar-uklegoed dummarbad, ar ayobi Bab-Dummad-gaya-burba-berbemalad epenne bemar-idu baregillesmarmogad.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús sogdebar: “Bemar we-napneggi baluyob gumalad. Ar balu-e-gaibid surgudele, ¿igi bar balu-balu guosunna? Geg bar ib-nuedga gued, degisoggu, balu igargi-mier bur nabirid, dulemar egi annaegar.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jesús sogdebar: “Bemar we-napneggi gwallu-meegwadga gumalad, ar neggwebur-gwagwen yar-birgi siile, geg we-neggwebur dukued. ");
INSERT INTO cuk09_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Degine, gwallu, ulu-urba-siega ogalesulid, gwallu ogaleged, e-sied-birgi siegar, adi bela dulemar-neg-yagi-bukmaladga neg-mee-saegar. ");
INSERT INTO cuk09_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Debayobi, gwallu gaeyobi, bemar dulemar-asabin damarmo, adi dule-baigan be-dakmalagar, bemar ibmar-nuegan imakdiid, degine, adi be Bab-Dummad-nibneggi-maid-e-nug ogannomalagar.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesús sogdebar: “Mer be binsamalo, Moisés-igar-mesisad, igi, Bab-Dummad-gaya-burba-berbemalad-igar-mesisad osulogega an noniye. Suli, an aga nonisulid, an nonikidi a-igar gatik bur-nue odulogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Ar napira an bemarga sogmalad, we-napneg, degi, nibneg-naid bergued-idu, Moisés-igar-narmakar-naid e-bichugwad-bur-bipigwad gwen bipisaar wis ogwalegosulid, ar bela narmakar-naidba guedsegad. ");
INSERT INTO cuk09_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Degisoggu, ar doa-dule we-igar-maidgi wis bipisaar egi gwatirisale, degine, ar deyob dulemar-odurdakele, a-dule, dule-bipigwadye nibneggi bilegoed. Ar dule bela Moisés-igar-maidba daele, degine, ar deyob dulemar-odurdakbalile, we-dule, dule-dummadye Bab-Dummad-neg-dakmaidgi bilemogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Ar napira an bemarga sogmalad, bemar igar-napiragwad-imaked, escribamarba, degi, Fariseomarba bur nuedsulile, Bab-Dummad-neg-dakmaidse bemar gwen dogosurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Degi Jesús sogdebar: “Be itosmalad, epenne igi serganga sogles-gusa: Mer na be oburgwemalo. Ex. 20:13 Ar dule-wargwen dule-oburgwisale, a-dulega odurdakleged-igar ega megnonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ar andi an bemarga sogmalad, ar dule-wargwen binsarsunna sae-itoge e-gwenadse urwe-dibe, a-dulega igar-itoleged megoed. Ar doa-dule e-gwenadga sog-dibe, ‘Be gegegwa an be-dakye,’ a-dulega Judio-dummagan igar-itogoed, ega igar amiegar. Ar doa-dule e-gwenadga sog-dibe, ‘Be akargubi an be-dakye,’ a-dule soo-sailase odurdakleged bur-nabirid. ");
INSERT INTO cuk09_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Degisoggu, Bab Dummadga ibmar be uksokalid, na e-ukleged-galuse be sedanikir, agi be insaalir, be-gwenadgi be gwatirisad, ");
INSERT INTO cuk09_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","be ibmar-Bab-Dummadga-be-uksokalid, na e-ukleged-galugi be obes nae, be-gwenad-bebo igar be nabonagwer, geb degi a-sorba gannar be dagoed, be Bab-Dummadga-ibmar-uksokalid geb be ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Dule-bebo igar gwatirnaid, ebo amba be igarba nadapi, gwae agi ebo igar be naboge, ar degi be imaksulile, abakalegi dule igar-naboged-dummadga be-ukalile, degi, a-dule, suar-ibedga be-ukarmogale, degiir, a eskaryagi be-metoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Napira an bega soge, be eskaryagi mellesiid, be noosurguodo, bela begi-mani-galesad be bennukedse.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús sogdebar: “Ar be itosmalad igi serganga soglesa: Mer be na abirgunagwarsuli neg-sichigi be yolemalo. ");
INSERT INTO cuk09_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ar andi an sogdo, ar dule-wargwen ome-wargwengi sunnasur na e-ulubgi egi binsasale, bato we-dule na abirgunagwarsuli neg-sichigi omegi yolesdo. ");
INSERT INTO cuk09_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Degisoggu, be-ibya-nuedsikid, be-gwage ichogega be-imak-dibe, bur be onodo, bikiin be metedo, ar bur nabirsursi unnila be-sangi-akanaid gwensak bei yoggusar, bur be-san bela soo-sailagi mellegedba. ");
INSERT INTO cuk09_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ar be-argan-nued be-gwage ichogega be-imak-dibe, bur be sikdo, bikiin be metedo, ar bur nabirsursi unnila be-sangi-akanaid gwensak bei yoggusar, bur be-san bela soo-sailagi mellegedbar.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesús sogdebar: “Bemar itosmar igi epenne bemar-serganga soglesbali: Ar dule-wargwen ome-metele, omega ome-meted-garda ukoye. ");
INSERT INTO cuk09_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ar andi an sogdo, ar dule-wargwen unnila e-ome egi-dikarba nosarbi sunna ome-meted. Ar degisulile, ome-meted ega igar gwen maisulid. Ar dule ome-metele, degiir ome neg-sichigi yolega imako-itole, degine, dule ome-melleded nikusale, a-dule ome-dikarba neg-sichigi yoledimodo.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Degine, bemar itosbar, igi epenne bemar-serganga soglesbali: Napira-ibmar-nuggi be sogsadi be imako, mer be imaksuli-guo. Ar Bab-Dummad-asabin napira be ibmar sogsad, imakedse be sao. ");
INSERT INTO cuk09_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ar andi an sogdo, mer bipisaar be sogo, an napira imakoye we-nibneg-naid-ularye, ar ade nibneg Bab-Dummad-siged-olo-ganad. ");
INSERT INTO cuk09_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Degine, mer be sogbalo, we-napneg-naid-ular napira an sogye an imakoye, ar ade napneg Bab-Dummad-e-nag-onakwed-ganad. Degine, mer be sogbalo, Jerusalén-neggwebur-ular an napira sogye an imakoye, ar ade Jerusalén Bab-Dummad-e-neggwebur gued. ");
INSERT INTO cuk09_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Degi, be nonose-bakar mer egi be sogo, an-nono-ular an napira ibmar imakoye, ar geg be sailagia-wargwensaar sipuu, igi, sichii be imaked. ");
INSERT INTO cuk09_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Ar be-sunmaked unnila be soge, eyeye, an imakoye, igi, an sao surye. Ar we-sogedba bur-bule be sogsale, agi ibmar-iskana dani-daed.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesús sogdebar: “Ar bemar itosmarbalid, epenne be-serganga soglesad: Ibya-gwagwen dule bei onosale, buged maiye, degine, nugar-wargwen dule bei bichisale, buged maibarye. ");
INSERT INTO cuk09_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ar andi an sogdo: Dule-iskana-abin mer be gwisgu. Bur be imakdo, dule-wargwen be-wagar-nuedsikid bei bibyosale, baid-wagar ega be oyobardo. ");
INSERT INTO cuk09_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ar dule-wargwen igar-nika igar-maidgi abin-abin be imakar-dibe, bei mor subiguar-dibe, ega be suba ukbardo. ");
INSERT INTO cuk09_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ar dule-wargwen ise-barmiar milla-gwen ega-ibmar-sedbi be abe-dibe, ega milla-bo ibmar-seded be sae. ");
INSERT INTO cuk09_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ar dule bese ibmar egichialir, ega be uke. Dulegi mer be ibmar nallegu, dule bega sokalir, wis anga be udagwerye, an gannar bega ukbaloye.” ");
INSERT INTO cuk09_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesús sogdebar: “Ar bemar itosmalad epenne be-serganga soglesad: Be dule-baigan-sabgumar, dule-be-istaraddi istar be dakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ar andi an sogdo: Be-istarmalad be sabgumar, dulemar-be-ukabsadimalad be nued egi binsamar, ibmar-nued ega be imakmar. Dulemar-be-nug-ichodimaladga, degi, be-baregindimaladga Bab Dummadse ega be gormar. ");
INSERT INTO cuk09_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Adi bemar, be-Bab-nibneggi-maid-e-mimmiganga gumalagar, ar Bab Dummaddi bela dulemar-nuegan, degi, dulemar-iskanaga dad-ibeler ogamaid. Degine, Bab Dummad bela dulemar igar-inikii-imakmaladga, degi, igar-inikii-imaksurmaladga di-owimaibalid. ");
INSERT INTO cuk09_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","“Ar dule-be-sabmaladbi be sabguele, ¿ar ibu-nued egi be amiosunna? Ibmar-nued egi be amiosuli. ¿Ar dulemar-iskana, Roma-dummadga-mani-gaedgi-arbamalad deyob na imakmosursi? ");
INSERT INTO cuk09_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿Ar be-gwenadganbi ega be soger, ‘Be nued sogeye,’ ar ibu baiganba bur-nued be imakmarsunna? Bur-nued be imaksuli. ¿Ar deyob dulemar-Bab-Dummad-wichurmalad imakmosursi? Eye, deyob imakmarmoga. ");
INSERT INTO cuk09_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ar be-Bab-nibneggi-maid dule-nueganga, degi, dule-iskanaganga ibmar-nuegan imaksoggu, a-ular bemar ulubgi dule-nueganga gumarmosundo.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús sogdebar: “Mer yamo dulemar-asabinbi igar-napiragwad-imaked be sao, adi be-dakmalagar. Ar deyob be daele, be-Bab-nibneggi-maid bar be-nug ogannogosur-itole. ");
INSERT INTO cuk09_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ar degisoggu, be dule-wileganaga mani uknair, mer be-idu binnasur gar-ogornai be sao, ar igi dulemar-wagar-darbo-damalad, Judiomar-onmaked-neggi, degi, igarba gar-binnasur-ogornaidgi mani-ukdamaladyob damala, adi dulemar e-nug ogannomalagar. Ar napira an bega sogmalad, ar a-dulemardi bato e-nug ogannolesmarsoggu, Bab Dummad bar amar-nug ogannogosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","“Ar bedi wileganga be mani uknair, be-argan-sapiled mer wisgu be-argan-nued ibmar imaknaid. A sogledo, mer dule-baiganga be soge-soge daoye be ibmar imakdiid. ");
INSERT INTO cuk09_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Adi be wileganaga-mani-uksad mer dule-baigan be-wisguegar, ar be-Bab bela-odukuar-be-ibmar-imaksad be-daksasoggu, na e emar-wagab be-nug ogannononikoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesús sogdebar: “Ar bemar Bab Dummadse gollalile, mer bemar dulemar-wagar-darbo-damaladyob be damalo, ar amardi yeer-ito damalad Judiomar-onmaked-neggi yamo-gwichi Bab Dummadse gordamalad, degine, yamo igar-abingunaidgi-gwichi Bab Dummadse gordamalad, adi dulemar e-dakmalagar. Ar napira an bemarga soged, ar a-dulemardi bato e-nug ogannolesmalad. Degisoggu, Bab Dummad bar amar-nug ogannogosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","“Ar bedi Bab Dummadse be gollalile, be neg-yaba be doge, nue yawagak edis, be-Bab-aku-dakleged, a-ebo be sunmake, ar be-Bab bela-odukuar-be-ibmar-imaked be-daksoggu, na e emar-wagab be-nug ogannogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ar Bab Dummadse be gollarmalale, melle gannar-gannar ibmar be sogo, igi dulemar-Bab-Dummad-wichurmalad imakedyob, ar amardi binsamalad, gannar-gannar ibmar-sogedba Bab Dummad e-itogoye. ");
INSERT INTO cuk09_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Degisoggu, mer dulemar-Bab-Dummad-wichurmalad-damaladyob be damalo, ar amba yo ibmar bemar egise, bato be-Bab bemar-wisid ibumala be abemala. ");
INSERT INTO cuk09_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Degisoggu, bemar weyob Bab Dummadse gormaloed: Anmar-Bab-nibneggi-maid, be-nug swilidik obariledii-gusun. ");
INSERT INTO cuk09_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na be-neg-dakmaid anmarse dage. Be ibmar na be-sogedba igi nibneggi imaklege, deyob we-napneggi imaked be imakmo. ");
INSERT INTO cuk09_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Emi-ibagi mas unnitibali anmarga be udage. ");
INSERT INTO cuk09_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Anmar-begi-iskusad anmarga be osulo, igi dulemar anmargi nosale, anmargi nossulidyob anmar dakdamogadyob. ");
INSERT INTO cuk09_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iskuedgi-wilubdaklegedse mer warmaked be anmar-imak, bur iskuedgi obined be anmar-sae. Ar na be-neg-dakmaid begadid, be-gangued, degi, be-nug odummoleged, begadbalid, birga-miliba degi-sadegu gusun. Be itogua.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesús sogdebar: “Ar dulemar-begi-nodimalad, begi nossuliyob be dakele, abayobi be-Bab-nibneggi-maid bega dakmogoed, be-iskusad bega osulogoed, egi nossuliyobi be dakmogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ar dulemar begi yoledimaladga begi nossuliyob be daksurmogale, be-Bab bega iskued osulogosurmogad, egi nossuliyob be dakosurmogad.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesús sogdebar: “Ar bemar Bab-Dummadse-golega mas-gunsuli gudiile, mer bemar-wagwar bukib-binsa na be imakmalo, dulemar-wagar-darbo-damalad imakedyob, ar amardi yamo e-wagar na ogwa-damalad, adi dulemar e-dakegar, emardi Bab-Dummadse-golega mas-gunsuli gudiiye. Ar napira an bemarga soged, ar amardi bato e-nug ogannolesmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“Ar bedi Bab-Dummadse-golega mas-gunsuli gudiile, na be nono gwallu-wawagi mage, degi, be wagar nue enukbalo, ");
INSERT INTO cuk09_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","adi mer be dulemarga oyogegar, Bab-Dummadse-golega mas-gunsuli be gudiiye. Unnila be-Babga be oyoge, ar be-Babbi wargwen be-dakmaid, na e dulemar-abargi be-nug ogannogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesús sogdebar: “Mer we-napneggined ibmar-nuegan-saboleged be we-napneggi sabomar, ar we-napneggi sunna amardi udumesed, degi, sunna saabin gued, degi, sunna atursamalad dogbalid, ibmar atursaegar. ");
INSERT INTO cuk09_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ar bemardi bur nibneggi ibmar-nuegan be sabomar, ar agindi geg ibmar iskued, ibmar geg saabin gubalid, degine, atursamalad adi geg dogbalid, ibmar atursaegar. ");
INSERT INTO cuk09_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","“Ar be ibmar-nuegan nibneggi sabolesiile, nibneggi be binsadii-gudoed. Be ibmar-nuegan we-napneggi sabolesiirdi, adi be we-napneggi binsadii-gudoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesús sogdebar: “Gwallu anmar-san mee-saedi, we, anmar-ibyado. Ar be-ibya nuedile, bela be-san ibegwar naido. ");
INSERT INTO cuk09_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ar be-ibya iskanale, bela be-san neg-sichidgi gudimodo. ¡Degisoggu, neg-meegwad-begi-naidi sichigwale, ar neg-sichid-bursunna, bule-goro be insae! ");
INSERT INTO cuk09_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Dule geg dummad-warboga maileged, ar ade wargwen sabguoed, baiddi istar dakoed. Wargwenga nue alamaknai-guoed, baiddi mesagwar dakoed. Geg be Bab-Dummad-maiga gued, degi, maniga-mailenai gubalid, unnila wargwen bur-bule be sabguoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesús sogdebar: “Degisoggu, an bemarga sogmar, mer surbinsa na be-san dula gudiidgi be itomar, ibu an gunno-dibeye, ibu an gobo-dibeye, degine, mer be-sangi be binsabar, ibu an yoo-dibeye. ¿Ar be-san-burbade mas-gunnedba bur nuedsursi? ¿Ar be-sande mor-yoedba bur nuedsursi? Eye, bur-nuedi. Anmar-dula-gudiid bur-biriginedid, we-mas-gunnedba, degine, we-mor-yoedba. ");
INSERT INTO cuk09_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Ar nue be dakmalana, sikwimar-niba-gukudimalad, gwen ibmar-gwag digdisurmalad, degi, gwen ibmar-gwag wedisurmarbalid sabogegar, deginbali, ibmar-gwag-urbed-neggine ibmar-gwag gwen urbedisurmarbalid. Degite, be-Bab-nibneggi-maid mas ega ukmaid. ¿Ar bemarde sikwimarba bur-bule nuedsursi? Eye, bur-nuedi. Degisoggu, Bab Dummad bemarga mas-gunned ukmogodo. ");
INSERT INTO cuk09_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Ar doa-dule na gatik egi binsaedbali sunna na e-san osuguo be insae? Suli, osuguosuli. ");
INSERT INTO cuk09_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ar mor-yoedbina, ¿ibiga surbinsa be itomala? Ar be dakmalana, sapur-dutumardi ibibayobi dungue, degite arbasurmalad, degi, na e-mor sobsurmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ar an bemarga sogmardo, degite, Salomón, mor bela yeer-daklemalad yosan-inigwele, ar dutumaryob gwen mor yossurgusad, dutumar bur Salomón-morba yeer dakleged. ");
INSERT INTO cuk09_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ar gagan-sapurbarmalad emi dulad, banedgi a-gaganmarde soo-yagi bato ogumaklesiid, degite, Bab Dummad yeer-dakle ega mor yoed. ¿Ar degite, bemar-Bab-Dummad-benmalad, bemarga bur-bule Bab Dummad geg mor ukde? Eye sunna bur-bule bemarga uke. ");
INSERT INTO cuk09_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ar degisoggu, mer surbinsa be itomar, mer be sogmar: ‘¿Ar ibu an gunmaloe, ibu an gobmaloe, ibu an yomaloe?’ ");
INSERT INTO cuk09_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ar dulemar-Bab-Dummad-wichurmalad wegid-ibmar bela amididimalad, ar be-Bab-nibneggi-maiddi bemar-wisid, bela bemar we-ibmarmar abemalad. ");
INSERT INTO cuk09_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","“Ar Bab-Dummad-neg-dakmaid-inse be amimar, degi, e-igar-napiragwad-imaked-inse, geb agi Bab Dummad belagwapa we-ibmarmar bemarga ukdagoed. ");
INSERT INTO cuk09_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Degisoggu, bane-bega-ibmar-guoedba mer surbinsa be itomar, ar ade baneddina na egad surbinsa-itoged sedanimogoed. Ar iba-irbali na e-bonigan egad-egad nikmalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús sogdebar: “Mer yogsaar be sogo, we dule-iskanaye, adi melle Bab Dummad deyob begi sogmogagar. ");
INSERT INTO cuk09_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ar dulemargi be sogsadyobi, begi soglemogoed, degine, dulemarga be igar-mesisadyobi, bega igar-megnonimogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“¿Ar ibiga be-gwenad-ibyagi durgan-maid magar be dake, ar be-ibya-yaba suar-maiddi aku be dake? ");
INSERT INTO cuk09_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ar igi be-gwenadga be sogoe: ‘Be-ibya-yaba durgan-maid an bega onogweloye,’ ar be-ibya-yaba suar maiddina? ");
INSERT INTO cuk09_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","“¡Ar bemar wagar-darbomalad! Suar be-ibya-yaba maid-insa be onoge, geb agi nabir be atakoed, be-gwenad-ibya-yaba durgan-maid onogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ar ibmar-nuegan-swilidikmalad mer be achumarga ukmar, ar abakalegi degir begi aibinnalile, degine, be-san ichimakalile. Degine, morbeb-akwagiid-nuegan mer be sinmarga mimar, ar abakalegi degir egi annaarmalale.” ");
INSERT INTO cuk09_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesús sogdebar: “Be Bab Dummadse ibmar egismar, Bab Dummad bega ukmaloed; be Bab Dummadse ibmar amimar, be amimaloed; be Bab Dummadse gormar, bega Bab Dummad yawagak egaoed. ");
INSERT INTO cuk09_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Ar dule-ibmar-bela-egised, ibmar abingaed; ar dule-ibmar-amiedi, ibmar amied; ar dule-yawagakgi-dulese-goledi, ega yawagak egaleged. ");
INSERT INTO cuk09_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“¿Ar doa-dule emi bemarse be-mimmi madu egichialile, ega be akwa ukmaloe? ");
INSERT INTO cuk09_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Igi, bese ua egichiar-dibe, ega bemar naibe ukmaloe? Suli. ");
INSERT INTO cuk09_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ar bemarde dulemar-iskana-inigwele, be-mimmiganga ibmar-nuegan-uked be wismaladde, ¿ar be-Bab-nibneggi-maid bursunna, dulemar-ese-ibmar-egismaladga ibmar-nuegan ukosur be insae? Ukoe. ");
INSERT INTO cuk09_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Degisoggu, dulemar igi ibmar bega imakbi be abege, deyob ega ibmarmar be imakmodo. Ar weyob Moisés igar-mesisad, degi, weyob Bab-Dummad-gaya-burba-berbemalad sogsamogad.” ");
INSERT INTO cuk09_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesús sogdebar: “Yawagak-waragwagwadba be dogmar, ar ade yawagak matar-dummadid, igar mata-bipisulid, yoggued-negse dulemar-semaid, degine, bukidar agi dulemar bur dogmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","“Ar yawagak garaa gued, degine, igar garaa gubalid, adi durgued-negse dulemar-semaid, unnila bokwagwa a-yawagak amimalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesús sogdebar: “Nue salakarmar Bab-Dummad-gaya-burba-berbemalad-sunnadsurmaladgi, ar amar yamo sibad-wawaadyob nonidamalad, ar e-ulubgindi achu-burburudyob sabsur-damalad-dulemalad. ");
INSERT INTO cuk09_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“A-dulemar e-daedgi be dakmaloed. ¿Ar ade ikogi uva sanmaksi, degi, higode iko-sapigi welesi? Suli, degisuli. ");
INSERT INTO cuk09_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ar deyobdo, sapi-nuegana, e-durba nueganbi sanmakmodo, ar sapi-iskanadi, e-durba-sanmaked iskanabimodo. ");
INSERT INTO cuk09_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ar sapi-nuedi geg e-durba iskana sanmaked, degine, sapi-iskana geg e-durba nued sanmakmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","“Ar sapimar e-durba nued sanmaksulile, olaodo, soogi metodo, ogumakegar. ");
INSERT INTO cuk09_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Degisoggu, Bab-Dummad-gaya-burba-berbemalad-sunnadsurmalad e-daedgi mag be dakmaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesús sogdebar: “Ar bela dulemar anga-sogedba: ‘Dummad, Dummad,’ degi-anga-sogedba Bab-Dummad-neg-dakmaidse gwen dogosulid. Dulemar an-Bab-nibneggi-maid-sogedba ibmar-saedba nibneggi dogmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“Bukidar a-ibagangi anga sogdamaloed. ‘Dummad, ¿ar be-nuggine anmar sunmaksasursi, be-nuggi anmar bukidar niamar-onosmarsursi, degine, be-nuggine bukidar ibmar-dakledisurmalad anmar imaksamarsursi?’ ");
INSERT INTO cuk09_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Geb degi an abin-sogoed: ‘Gwen an be-wichur, aku an be-dake, be angi bangumar, unnila bemar-ibmar-iskana-saedginbi-arbadimalad.’” ");
INSERT INTO cuk09_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús sogdebar: “Ar doa-dule we-an-sunmaked itos-dibe, degine, eba daele, we-dule, dule-binsaed-nikaa daedyobdo, na e-neg akwa-birgi sobsayobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Di-wiargu, diwarmar noar, burwamar binnasur gollar, bela-bela a-neggi signonigu, a-neg gwen aimukussur, ar ade neg akwa-birgi sobar siid. ");
INSERT INTO cuk09_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Degine, ar doa-dule we an-sunmaked itos-dibe, degite eba ibmar imaksasulile, we-dule, dule-binsaedsuli-gusayob guodo, na e-neg ukub-birgi sobsayobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Di-wiargu, diwarmar noar, burwamar binnasur gollar, bela-bela a-neggi signonigu, neg ayarid, a-neg nue-dummad bibichisdo. Be itogua.” ");
INSERT INTO cuk09_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ar Jesús wegi-ibmar-sogsad-sorba, dulemar geger dakmardo, weyob Jesús e-ibmar odurdaked. ");
INSERT INTO cuk09_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ar ade Jesús na ibmar odurdaked, escribamar odurdakeyob odurdaksulid, edi na nue-wisi odurdaked. ");
INSERT INTO cuk09_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús yar-birgi siid, aideargu, dulemar-bukidar eba duurmakdani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Agi dule-wargwen, naibe-buna-ya-maleged-nikad ese sindigar yokorgi signonikid, ega sognonikid: —Dummad, an wisi, sunna be an-nudaked, be an-nudakbier. ");
INSERT INTO cuk09_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús e-argan oyodgu, e-argangi ebusgu, ega sogded: —Nugubi an be-abe. ¡Be nugusun! Dule-naibe-buna-ya-maleged-nikad yog nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Geb degi Jesús dulega sogdesun: —Mer dule-baiganga be sogo be nugusad. Unnila be nae, dule-irwa-Bab-Dummadse-gormaladga na be-san oyona, degine, ar igi Moisés igar-mesisa, a-sogedba be ibmar imakna, adi dulemar be-dakega, nue be nugusad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús Capernaum-neggweburse dogsagu, Roma-sordamar-dulatar-sediid-wargwen ese noni, egi wilenoni, ");
INSERT INTO cuk09_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ega sognoni: —Dummad, an-mai bela abgan-burgwar neggi maid, nue bela-bela nunmaked itomaid. ");
INSERT INTO cuk09_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Geb degi Jesús, abin-sogde: —An nao, bega be-mai an nudaknao. ");
INSERT INTO cuk09_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Degi Roma-sordamar-dulatar-sediid, Jesús-abin sogde: —Dummad, ar an-negse gwen be dogedsulinad, unnila ibmar be sogsa-sae, agi an-mai yog nuguar naoed. ");
INSERT INTO cuk09_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Amba an dummad-nikmogad, degine, ani, an dummadmogad, sordamar ani an sediid. Ar wargwenga an sog-dibe, ‘Be nae,’ ar a yog naar-daed. Baidga an sogbar-dibe, ‘Be dage,’ yog dagar-daed. Degine, an-maiga an sog-dibe, ‘We be imake,’ yog imakar-daed. Ar deyobmogad, an-mai abgan-burgwar-maid, unnila be ibmar-sogsaa-imakedba, sunna yog nuguar-guoed. ");
INSERT INTO cuk09_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús weyob Roma-sorda-dummad ega soge itoargu, geger-ito naded, geb degi dulemar-e-sorba-duurmakdanimaladga sogdesun: “Napira an bemarga soged, Israel-dulemargi weyob dule nue an-bensulid an dakdisulid. ");
INSERT INTO cuk09_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Ar an bega sogdo, bukidar dad-nakwedsik, degine, dad-argwanedsik dulemar-Judiosurmalad nonimaloed, Bab-Dummad-neg-dakmaidse, adi Abrahamba, Isaacba, degine, Jacobba mas gunmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ar dulemar Bab-Dummad-neg-dakmaidse dogmaloye ega igar-maimaladga, Judiomarga, ar amardi bur dogosurmalad, ar amardi bur neg-sichidgi magaba melledmaloed. Agine bosii, degine, nunmakedba nugar ogorsii-gumaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Geb degi Jesús Roma-sordamar-dulatar-sediidga sogdesun: “Be nae, ar be bengussursoggu, be-mai an bega nudassun.” Ar dummad-e-mai-uelemaid yog a-wachigi nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús Pedro-negse nonigu, daknoni, Pedro-e-sakbundor nue uelegar mai. ");
INSERT INTO cuk09_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús e-argangi Pedro-sakbundor ebusgu, ueleged yog surguar, degi, Pedro-e-sakbundor yog gwisguar imaksad, geb a-sorba ega yog ibmar-imakar gussunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A-ibagi neg-mutikudgu, dulemar bukidar ese niaburba-nikmalad senonimalad. Jesús unnila e-sunmakedgi niaburbamar-onosad, degi, bela dulemar-uelemalad-nudaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ar Bab-Dummad-gaya-burba-berbeged, Isaías, deun epenne sogsadba guegala deyob gusad, deun sogsa-gusgu: Anmar-uelemalad anmarga na e sesad, degine, anmar-ibmar-nunmakmalad anmarga na e e-sangi sesbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús dulemar-bukidar e-dikarba-gudii daksoggu, e-sapinganga igar uksasun, mata-dummad obakar namalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Degi escriba-wargwen noni, Jesúsga sognoni: —Odurdaked-saila, ar bia be naoe, an beba naiguodo. ");
INSERT INTO cuk09_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús, abin-sogde: —Ar usmardi na e-gubya nikmalad, sikwimar-niba-gukudimaladdi na e-uu nikmarbalid, ar andi Dule-Machi, andi neg-sated. Anyob be unni nanamogale, anba be dagodo. ");
INSERT INTO cuk09_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E-sapin-baid Jesúsga sogdemogad: —Dummad, bina an-babse an nagwelo, an-bab-burgwedse geb beba an naoed. ");
INSERT INTO cuk09_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús, abin-sogde: —Anba be dage, an-sapinga guegar. Ar dulemar we-napneggi burbar bato-burgwar-gudimalad na e-burgwarmalad digoed. ");
INSERT INTO cuk09_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús urgi nakwisgu, e-sapingan eba nadmarmosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Igarba nadapmargu, burwa-dummad egi noalid. Ar demar bipisursoggu, bela ur demarba doged gualid, ar Jesúsdi ur-yagi ise-gabar maid. ");
INSERT INTO cuk09_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Geb degi e-sapingan Jesús-gabmaidse nonimargu, odaksamalad, ega sogdemalad: —¡Dummad, anmar-ur dogmaid, be anmar-bendake, anmar bergumaloed! ");
INSERT INTO cuk09_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús, abin-sogde: —¿Bemar an-benmalad, ar ibi be dobmala? Bemar dobgue-wilubsulinad. Degi Jesús gwisgusgua, binnasur burwaga, degi, demarga sogded, be bogidik saye. Geb degi bela neg swilidik sigissunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bela e-sapingan geger dakdemalad: —¿Ar we-dulede igidsunna, burwase, degi, demarse-bakar eba ibsamargu? ");
INSERT INTO cuk09_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús, degi, e-sapingan mata-dummad obaksamargu, Gadara-yalase modapmalad. Napase aidesmargu, walabo dulemar-niasamalad ese nonimalad, neg-uangi gudii noarmalad. Ar gadi urwemarsoggu, dulemar geg a-igarba nanamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Niasamalad-warbogwad binnasur gotemalad, sogdemalad: —Jesús Bab-Dummad-Machi, ¿ibiga be anmargi yoledaniki? ¿Ar be anmarse danikidi, amba yo anmar-odurdaked-ibagan-moed-iduar bato be sabsur anmar-odurdakega daniki? ");
INSERT INTO cuk09_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Emar-gunaidgi undar-banguedgi deun sinmar-bukidar mas mananaid. ");
INSERT INTO cuk09_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Niamar Jesúsgi wilenagusmar, ega sogdemar: —Ar dulegi be anmar-onogele, weba sinmar-bukidar mas-mananaidse be anmar-barmidye. ");
INSERT INTO cuk09_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús ega sogde: —Eye, sinmarse be dognamar. Niamar dulegi nodgu, sinmarse nadmarsun, agi ubodapmalad. Bela sinmar-ichesulid, danagwen yar-weregedgi batidmalad. Demarse sinmar bela batismargu, bela gundilegar burgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sin-edarbemalad dobguar, duurmakdemalad. Neggweburse modapmargu, bela sogdapmar, igi sinmar gundilegar burgwismala, degine, igi warbo niasamalad nugusmarmoga. ");
INSERT INTO cuk09_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Degi-itosmargua, bela a-neggweburginmalad Jesús-abin ainiarmalad. Jesús-daksamargu, egi wilenagusmalad, adi e-yargi naegar. Agi Jesús urgi nakwissunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Degi Jesús urgi nakwisgu, mata-dummad-gaka-baidse nadsun, na e-neggweburse nonisun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Agi dule-wargwen, bela-abgan-burgwar-nikad ese dule-megedgi-mai senonimalad. Ar Jesús dule-senonimalad-dakdegu, egi gwen bensulid, dule-abgan-burgwaledga sogded: —An-ai, gandik na be san-sae, na be-iskudii-gusad, be nugussun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Degi, escribamar-gwen-gwen na ulubgi sogdemar: “We-dule Bab-Dummad-nuggi nue dodonaid.” ");
INSERT INTO cuk09_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ar Jesús sunna dulemar-ulubgi-binsanaid mag daksoggu, sogdesun: —¿Ar ibiga bemar na be-gwagegi ichakwa binsanai? ¿Geg-iskued-osulo be an-insae? ");
INSERT INTO cuk09_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","An dule-bonigwaledga sog-dibe: ‘Be-iskunaid an bega osulos.’ Ar igi an sogbarsun-dibe: ‘Be nugu, be gwisgu, be nae.’ Degite, ¿igid bur-baisursunna imaklesunna? Suli, ebobela baisursunna imaklesuli. Ar dule sunna an nudakele, soglebardo, sunna dule-iskued an elibarye. ");
INSERT INTO cuk09_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Degisoggu, ani Dule-Machi, dule-bonigwaled an nudakoed, adi bemar wisguegar, igi dule-bonigwaled sunna an nudake, debayobi we-napneggi dule-gwage-iskunaid sunna nudaked an nikbalid. Degi Jesús dule-abgan-burgwar-nikadga sogdesun: —Be gwisgu, be-egi-maid na be sede, be-negse na be nasun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Geb degi-dule-bonigwaled yog nuguar-gusgu, na gwisgus imas, e-negse na nadsun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ar dulemar dule-nugusad dakdegu, geger dakdemalad. Bab Dummad dulega we-gangued uksadba, dulemar Bab-Dummad-nug odummodmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús dule-nudaksadgi-gwichi nadgu, dule-wargwen-dakar, Mateo nugad. A-dulede Roma-dummadga-mani-galeged-neggi siid, mani gasiid. Jesús Mateose gote, ega sogde: —Anba be dage, an-sapinga guegar. Degi Mateo gwisgusgu, eba yog naar imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mateo-neggi Jesús, degine, e-sapinganmala mas gunsigu, dulemar-Roma-dummadga-mani-gaedgi-arbamalad, degine, dulemar-baigan galagwensuli-iskudimalad eba mas gunbukwa-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseomar, Jesús dule-iskanamarba mas-gunsii dakarmargu, Jesús-sapinganga sogdemar: —¿Ar ibiga bemar-odurdaked-saila dulemar-Roma-dummadga-mani-gaedgi-arbamaladba, degi, dule-baigan-iskudimaladba wede mas gunne? ");
INSERT INTO cuk09_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús, deyob Fariseomar soge itosgu, sogde: —Dulemar-gegusurmalad ina-duled abesulid, unnila gegumaladbi ina-duled abe damalad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Degisoggu, be namar, be durdaknamar, Bab Dummad igi soge na E-Gardagi: Nue wile emar-daked bur an abeged, anga ibmar-gummakar ukedba. Os. 6:6 Ar we-napnegse an nonigu, dulemar-nuegan, na iskudisur-itomaladse golega an nonisulid. An nonikidi, dulemar-iskudii-na-itomaladse golega, adi na e-iskuedga ulubgi bukib binsamalagar, mer bar iskumalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Agi Juan-sapingan Jesússe nonimalad, ega sognonimalad: —Anmar, degi, Fariseomar, Bab-Dummadse-golega mas-gunsuli imbagwenar gudidamalad. ¿Ar ibiga be-sapingandi Bab-Dummadse-golega gwen mas-gunsuli gudidasurmala? ");
INSERT INTO cuk09_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús, abin-burbar-sogde: —¿Dulemar ome-nikued-ibagi mas-gullegedse nonikile, bukib binsamalo be insae, ar dule-ome-nikuoed e-abargi siir? Suli, bukib binsaosuli. Ar ibagan nonikoed, dule-ome-nikunaid e-idu seledoed, a-ibagan nonikile, agindi Bab-Dummadse-golega mas-gunsuli gudigumalodo. Emigindi amba an gudisoggu, an-sapingan geg mas-gunsuli gudigumardo. ");
INSERT INTO cuk09_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesús sogdebar: “Ar dule gwen morgoa-binid matuga mor-seredgi nasikega gwen imakdisulid. Degir, morgoa-binid sinnii nadele, mor-sered aka-bur-bule achirmakdo-itole. ");
INSERT INTO cuk09_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Deginbali, inna-gaibid-binid gwen ibmar-uka-bugluga-sobaled-seredgi baliledisulid. Degir, inna-gaibid mudele, buglu-sered esirmako-itole. Degir binsa inna-gaibid milego-itole, degi, bugluse-bakar binsa miledo-itole. A-ulale, inna-gaibid-binid buglu-binidgi baliledo, adi ebobela nabir igarga guegar. Dule-igar deyobmodo, igar-sered geg igar-binid-ebo atoged.” ");
INSERT INTO cuk09_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús wegi-sunmaksii, machered-wargwen, dule-nue-nug-nikagwad ese abarmaknonikid, yokorgi sindigar asabin signonikid, ega sognonikid: —An-bunolo emiskwaa burgwisad, ar degite anba be dage, be-argangi an-bunolo be ebudage, adi gannar durguegar. ");
INSERT INTO cuk09_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús gwisgus imaksagu, e-sapinganmala eba nadmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Degi ome-gwensak birga-ambe-gakabogus boni-nalur-nika gudiid, Jesús-yarganba nonikid, e-mor-duku ebunonikid. ");
INSERT INTO cuk09_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ar ade ome na ulubgi soged: “Ar unnila Jesús-mor-dukubi an ebusale, an nudaklegoye.” ");
INSERT INTO cuk09_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ar Jesús aibiris imaksagu, ome-gwichi dakdegu, ega sogded: —Omegwa, mer be dobgu. Ar be nue an-bengussursoggu, be nugussun. Ar agine, ome yog nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús dule-wargwen-wis-nug-nikagwad-negse modapsun. Agi dogdegu, dakde, dulemar-gar-ogormalad bato guagwar bukwa, degi, dulemar bukidar oimakbukwa. ");
INSERT INTO cuk09_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús amarga sogde: —Bemar ainirmar, ar bunolo burgwar maisulid, unnila gabmaid. Dulemar Jesúsgi dododmar. ");
INSERT INTO cuk09_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ar Jesús bela dulemar-onisgua, geb neg-yaba bunolo-maidse dogded. Jesús bunolo argangi gadapgu, ogwichiis imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ar weyob Jesús bunolo-odurgusad, bela a-yargi wisgunoni-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús bunolo-neggi nodgu, dulemar-warbo ibya-surmalad Jesús-sorba dani-gusmalad, gordani: —Be David-wagwasoggu, be dule-dummadid, wile be anmar-dake. ");
INSERT INTO cuk09_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Degi, Jesús negse dogsagu, dulemar-warbo-ibya-surmalad ese nonimalad. Jesús amarga sogded: —¿Ar bemar insagua, sunna an bemar-nudak be insamala? Amar, abin-sogdemar: —Dummad, eye, sunna be anmar-nudake. ");
INSERT INTO cuk09_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Geb degi Jesús amar-ibya ebussun, amarga sogdesun: —Ar bemar an-bensurmarsoggu, bemar nugumarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Geb degi amar nabir atak nadsun. Jesús amarga ise-sogar imas: —Melle dule-baiganga be sogmalo, an bemar-nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ar dule-warbogwad-nugusmalad a-neggi nodmargu, bela neggwebur-irba sogdemar igi Jesús e-nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ar ibya-nugusmalad nodmargu, Jesússe dule-niasaed-geg-sunmaked senonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús a-dulegi nia-onosgua, dule-geg-sunmaked nabir sunmak-naded. Dulemar-bukidar geger dakdemalad, sogdemalad: —Ar Israel-yargi wegiid-ibmar iduar gwen dakledisulid. ");
INSERT INTO cuk09_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ar Fariseomardi sogdemar: —Ar nia-sailaba wedi niamar-onodiid. ");
INSERT INTO cuk09_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús bela neggweburmar-dummagan, degi, neggweburmar-burwigana onodii, Judiomar-onmaked-neggi dulemar-odurdakdii, Bab-Dummad-neg-dakmaid, a-e-gaya-burba-nuedgi sunmakdii, degine, dulemar-abargi bela galagwensuli-gegumalad, degi, uelemalad-nudakdii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ar Jesús dulemar-bukidar-dakdegu, nue wile amar-dakded, ar ade dulemar e-bendaked-sate-gudidii daked, degine, e-idued sate dakbalid, igi sibad-wawaad e-idued-sate-gudii damalayob. ");
INSERT INTO cuk09_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Geb degi Jesús burbar na e-sapinganga sokalid: —Napira an bemarga soged, nainugi ibmar-gwag-weleged bukidarad, ar e-wemaladdina ichee gued. ");
INSERT INTO cuk09_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Degisoggu, nainugi-ibdula-gwag-weleged-e-ibedse be wilesakwaa egismar, adi e-nainuse ibdula-gwag-wemalad-barmidagegar. ");
INSERT INTO cuk09_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Degi Jesús na e-sapingan-ambe-gakabogwadse gochagua, ega gangued uksad, niaburbamar-onogegar, dule-galagwensuli-gegumalad, degi, bela uelemalad-nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Bab-Jesús na e-nuggi-ambe-gakabogwad-barmisad weyob nugmardo: Gebe Simón, Pedroye-nugbalid, agine, Andrés, Simón-e-urba, Santiago, degine, e-urba Juan, Zebedeo-machimala, ");
INSERT INTO cuk09_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","degine, Felipe, Bartolomé, Tomás, Mateo, Roma-dummadga-mani-gaedgi-arbasad, degi, Santiago Alfeo-machi, degi, Lebeo, Tadeoye-nugbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, a-dule cananista-sorda, degine, Judas-Iscariote, darba-Jesús-uksad-dule. ");
INSERT INTO cuk09_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús wemar e-ambe-gakabogwad barmisad, ega igar uksad: “Mer Judiosurmaladse be namalo, degine, Samaria-neggweburgangi mer dogmarbalo. ");
INSERT INTO cuk09_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ar bur be namaloed, dulemar Israel-dulemar sibad-wawaadyob yoggus-gudimaladse. ");
INSERT INTO cuk09_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Ar be nadmalale, Bab-Dummad-gaya-burbagi be sunmakmaloed, sogmaloed, ‘Emigindi Bab-Dummad-neg-dakmaid anmarse warmaksasunye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Degine, dulemar-uelemalad bemar nudakmaloed, dule-naibe-buna-ya-maleged-nikmalad nudakmarbaloed, dulemar-burgwar-mamaid gannar odurgumaloed, dulemargi niamar-onomaloed. Ar we-gangued manigi bemarga uklessursoggu, binsa bemar aimar-bendakmarmogoed, mer egi mani gamarmogo. ");
INSERT INTO cuk09_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Degine, olo, mani, esnon-mani, mer be sagu-yaba be sedmalo. ");
INSERT INTO cuk09_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sagu amba igarba sedosurmarbar, amba mor-gobo sedosurbar, amba sapat satebar, amba gaapoled sedosurbar, ar ade dule-arbaedi na e-arbaedgi mas gunner-gebed. Degisoggu, dulemarga be-ibmar-saoedi, a-dulemar masgi bemar-ogunnoed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ar ibu-neggwebur-dummadse, igi, neggwebur-bipigwadse be dogdap-dibe, be amimaloed, dule-nabir-be-sunmaked-abingaoed. A-neggi be megmaloed, ar a-neggweburgi be nodedse. ");
INSERT INTO cuk09_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ar bemar a-neg-yase dogdapile, nue neg-ibedse golo, ga sogo, bemar nued sogeye. ");
INSERT INTO cuk09_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ar a-negginmalad nabir-egi-be-binsaed sunna abingaoele, a-neggi dulemar ulubgi bogidik itononikoed, ar degisulirdi, nabir-egi-be-binsasad gannar bese nonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","“Ar dule-wargwen be-abingasulile, degine, be-sunmaked itosurbalile, a-neggi be nodagoed, igi, neggwebur-dibe. Agi be noalile, be-naggi-olli-nanaid nue eli-eli be imakoed, adi dulemar mag be-dakega, Bab-Dummad-igargi ega be sunmaksamoganad, emigindi ese bemar bar dagosurdo. Degisoggu, emargindo, ar Bab-Dummad-igar yapa abingamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Napira an bemarga soged, Bab-Dummad-igar-nabirogoed-ibagi, we-neggweburginmalad-be-abingassurmalad, Sodoma, degi, Gomorra-neggweburginmaladba bur-bule sabsur odurdaklemaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús, e-sapinganga sogded: “Emigi an na be-barmidmar, bemar sibad-wawaadyob, achu-burburumalad-abargi. Ar degisoggu, naibeyob bemar binsaed-nikarba damaloed degi-inigwele, baisursunna nuu-daeyob bemar damarbaloed, mer aimargi istar binsamalo. ");
INSERT INTO cuk09_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Dulemargi nue salakarmar, ar amar be-ukmaloed Judio-dummagan-igar-nabiromaladse, degine, Judiomar-onmaked-neggine sabsur be-bibyomarbaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Degine, ar be an-sapingansoggu, dulemar dummagan-neg-dakmamaid-asabin, degi, reymar-asabin dulemar be-ebipimaloed, adi dummaganga, degi, Judiosurmaladga bemar angi sunmakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","“Ar dulemar a-dummaganga be-uksamalale, mer be bukib binsamalo, igi an sogo-dibeye. Ar be sunmak-sokalile, Bab bega binsaed ukoed, igi be sogoe. ");
INSERT INTO cuk09_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ar ade bemar na be ibmar sogosulid, Bab Dummad Burba Nued bemarba sunmakoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jesús na e-sapinganga sogdebar: “Dulemar na muchub-muchub e-gwenadgan oburgwega na urmaknanai-gumaloed. Bab na mimmigi aibinnai-guoed, degi, mimmigan babgangi gwisgunai-gumogoed, na oburgwenanai-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bemar an-sapingansoggu, a-ular bela dulemar istar be-dakmaloed. Ar bemar galakussurmaladdina, igar-bulegan berguedse, nue abonolemaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Ar neggwebur-gwagwengi be-bareginnarmalale, baid-neggweburse idu be wakinmalo. Ar napira an bemarga soged, bemar Israel-neggweburgi bela an-gaya-burbagi-sunmaked-iduar bato ani Dule-Machi, an danikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“¿Ibiga bemar wilemalo be insae? Ar bemar wisid, ar sapin e-sailaba bur dummadsulid, degine, mai, e-ibedba bur dummadsurbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Degisoggu, sapin e-sailayob gusale bato gusbindo, degine, mai e-ibedyob gusale, bato yeer itoge-wilubdo. Ar dummad-wilegoed bemar nue wilemarmogodo. Ar dulemar anse Nia-Saila-Beelzebúye gochamaladde, ¿ar bemar bursunna? Deyob bemarse gormarmogodo.” ");
INSERT INTO cuk09_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesús sogdebar: “Degisoggu, dule-istar-be-dakmalad mer be dobgumar, ar bipisaale ibmar-dukuar-imaklegedi magadse buud noosurdeeye gwen soglesulid, degi, ar emi amba ibmar-dukualed wisgulegosurdeeye gwen soglesulid, wisgulegedse daed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ar begarbi an-ibmar-sogedi, bela dulemarga be sogmaloed. Ar unnila be uaya-nabarbi an-bega-ibmar-sogoedi, bela be dulemarga sogmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Mer be dobgumar dulemar-be-oburgwebimalad, ar be-burbadi oburgosurmalad. Bur Bab Dummad be dobgumar, ar adi sunna soo-sailagi be-burba, degi, be-san obeloged. ");
INSERT INTO cuk09_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“¿Ar ade sikwi-gwabo esnon-gwagwengi uklesursi? Ar degite, sikwi-gwagwensaale napase argwanosulid, be-Bab sogsulir. ");
INSERT INTO cuk09_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ar bemar sailagiase-bakar bela ebisar be-Bab-Dummad sediid. ");
INSERT INTO cuk09_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Degisoggu, mer be dobgumar, ar bemar bur-bule sikwimarba bur ibmar-nueganad. Ar degisoggu, bemar bursunna, Bab Dummad bur-bule nued be-akwemalodo. ");
INSERT INTO cuk09_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ar degisoggu, doa-dule dulemar-asabin na sog-dibe, ‘An Cristoba naiye,’ an-Bab-nibneggi-maid-asabin an sogmogodo, ‘We dule an-sapinye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ar doa-dule dulemar-asabin an-osulosardi, adi an-Bab-nibneggi-maid-asabin an a-dule-osulomogodo.” ");
INSERT INTO cuk09_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesús sogdebar: “Mer be binsamalo, we-napnegse an neg-bogidik-saega an noniye. Neg-bogidik-saega an nonisulid, an nonikidi, urwed-onogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bab-Dummad-Gardagi sognaidgii: An nonikidi, dule na e-bab-ebo ourwega, bunagwa na e-nan-ebo ourwega, bala na e-saka-bundor-ebo ourwega. ");
INSERT INTO cuk09_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ar neg-yaginmalad na e-istarmaladga gunonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ar dule, e-bab-dibe, e-nan-dibe, a bur-bule anba sabele, we an-sapinga gued-wilubsulid. Ar e-bunagwa-dibe, igi, e-machi-dibe, a bur-bule anba sabele, an-sapinga gued-wilubsulid. ");
INSERT INTO cuk09_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Igi dule burgwenadapile, na e-nakrus semai-dae, deyobi dule-anba-naid guakwaa burgwega nanasulile, a-dule an-sapinga gued-wilubsulid. ");
INSERT INTO cuk09_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","“Ar dule-wargwen anba-naid-ular burgwebisulir, e-san-burba ei yogguodo. Ar anba-naid-ular, burgwenonikirdi, adi na e-san-burba yogguosurdo.” ");
INSERT INTO cuk09_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesús sogdebar: “Ar dule bemar-abingaele, an-abinganaido. Ar dule an-abingaele, Bab-Dummad-an-barmialid, a-abinganaido. ");
INSERT INTO cuk09_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ar dule-wargwen Bab-Dummad-gaya-burba-berbeged-abingaele, ar Bab-Dummad-gaya-burba-berbegedsoggu, Bab Dummad ega ibmar-nuegan ukodo, igi na E-gaya-burba-berbemaladga ibmar-nuegan ukdamogadyob. Degine, dule-wargwen dule-nued-ibmar-inikii-saed-abingaele, ar dule-nued-ibmar-inikii-saedsoggu, Bab Dummad ega ibmar-nuegan ukodo, ar igi dule-nued-ibmar-inikii-saedga ibmar-nuegan ukdamogadyob.” ");
INSERT INTO cuk09_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jesús sogdebar: “Ar doa-dule an-nuggi dule-bipigwadga nog-gwagwen dii-diopigwadgi ogobsa-dibe, ar an-sapinsoggu, napira an bemarga soged, Bab Dummad ibmar-nuegan ega ukosurdeeye soglesurdo, ega ukedsedo.” ");
INSERT INTO cuk09_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús na e-sapingan-ambe-gakabo-guedga igar-uksad bergusad-sorbali, e-sapingan-barmidsun, na edi nade-gusmogad, Galilea-neggweburmarse, Bab-Dummad-gaya-burbagi sunmakegar, degine, dulemar-odurdakegar. ");
INSERT INTO cuk09_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan-Bautista-eskaryagi-mellesiid itoargu, Cristo ibmar-imakdiid, Juan na e-sapingan-warbo Cristose barmialid, ");
INSERT INTO cuk09_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","adi ese egisegar: “¿Ar epenne Bab Dummad sogsad, yoedse dule-wargwen an bemarga barmidagoye, ar be a-dule, igi, anmar dule-baid amba edarbemaloe?” ");
INSERT INTO cuk09_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús, abin-imakdegu sogde: “Be namar, Juanga bemar sognamar, ibmar na be itosmalad, degi, na be ibmar daksamalad: ");
INSERT INTO cuk09_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dulemar-ibya-surmalad mag-atak an imaksad, dulemar-muya-muya-nanamalad nabir-nanae an imaksad, dulemar-naibe-buna-ya-maleged-nikmalad swilidik an imaksad, dulemar-uaya-yallirmalad nabir-mag-ito an imaksad, dulemar-burgwismalad gannar-durguega an imaksad, degine, dulemar-wileganaga Bab-Dummad-gaya-burba-nuedgi an ega sunmaknonikid. ");
INSERT INTO cuk09_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Degine, Juanga be sogbaloed: ‘Ar dule-an-bensuliddi, a-dulegindi nued egi binsalesye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan-sapingan-warbogwad nadmargu, Jesús, Juan-Bautistagi dulemarga sunmakar, sogded: “¿Ar ibi-dakega bemar nega-dule-sulidganba arbisunna? ¿Nar-gammu burwaba aibangwichi dakega bemar arbi? Suli, degisuli. ");
INSERT INTO cuk09_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Degite, ar ibi-dakega bemar arbisunna? ¿Bemar dule-wargwen mor-nued-yoi-gudiid dakega arbimala? Suli, degisuli. Ar dulemar-mor-nued-yoi-gudimaladdi, amardi reymar-neg-yagi gudidimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ar degite, ¿ibi-dakega bemar arbisunna? ¿Bab-Dummad-gaya-burba-berbeged-dakegala? Eye, an bemarga sogmar, a bemar daksamalad, degine, Bab-Dummad-gaya-burba-berbegedba bur-bule bemar daksamalad, ar ade we bur-dule-dummadid. ");
INSERT INTO cuk09_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ar we-dulegine bato narmakar sognaid, Mesíasgi sunmaknaigu, Bab Dummad soged: Be-iduale, anga-gaya-burba-barsoged an barmidoed, Adi be-iduar bega igar-mayegar. Mal. 3:1 We-gaya-burba-barsoged, Juan-Bautistado. ");
INSERT INTO cuk09_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Napira an bemarga soged: Dulemar-we-napneggi-gwalulemaid Juan-Bautistaba bur-dummad sulid, ar degite, Bab-Dummad-neg-dakmaidgi bur-dule-bipigwadi, degite, a-dule Juan-Bautistaba bur dule-dummadid. ");
INSERT INTO cuk09_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan-Bautista-akala, emi-ibadsega, Bab-Dummad-neg-dakmaidse dogegala, dutusulidgi dogleged, unnila dulemar-dutusurmaladbi ese dogmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ar bela Bab-Dummad-gaya-burba-berbemalad, degi, Moisés-igar-mesisad, Bab-Dummad-gaya-burbagi-sunmaksamalad, Juan-Bautista-nonikidse. ");
INSERT INTO cuk09_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ar bemarga-an-soged bemar abingabiele, Juan-Bautista, we Elías-danikoye-soglesad-duledo. ");
INSERT INTO cuk09_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Bemar mag nue-itobiele, nue-itomar an bemarga ibmar soged.” ");
INSERT INTO cuk09_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Geb degi Jesús sogdebar: “Degite, emi we-dulemar-bukmaladde, ¿doa-sunnaa damar be insae? Wemar-damaladi, machimala neg-magaba ambikuedgi-ambikumaladyobdo, na muchub-muchub agi na gorbukmaladyobdo, ");
INSERT INTO cuk09_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","na ega sogbukmardo: An bemarga gar-ogochamalad, degite bemar gwen dodossurmalad. Anmar bemarga bukib-binsa namaksamalad, degite bemar gwen bossurmalad. Degisoggu, bemar we-burwigana-binsaedsulidyob damardo. ");
INSERT INTO cuk09_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ar Juan we-napnegse nonigu, dule-baigan-mas-gunnedyob mas-gunsuli, degi, dule-baigan-gobedyob gobsuli gudigusad. Egi bemar sogsa-gusmalad, ‘Wedi nia egi naiye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ani Dule-Machi, andi nonigu, mas gunnoni, gobnoni, angi be sogmalad: ‘We-dule bemar dakmalana, gadi-mas-gunned-dule, degine, gadi-vino-gobed-dule, deginbali, dulemar-Roma-dummadga-mani-gaedgi-arbamalad, degine, dulemar-galagwensuli-iskudimalad e-aiga-na-saed-dule.’ ” Geb degine Jesús sogdesun: “Ar dule Bab-Dummad-ibmar-wisidi, ibmar-nuegan-imakedgi mag-dakle daed.” ");
INSERT INTO cuk09_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Geb degi Jesús neggweburmargi-bukidar-ibmar-dakledisurmalad-imaksadgi sabsur ega ibmar sokarsun, ar ade dulemar na e-iskudiidga gwen bukib binsasurmalad, e-iskudiid gwen misurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jesús sogdesun: “¡Corazín-dorgan, be wilesmar! ¡Betsaida-dorgan, be wilesmar! Ar bemar Bab Dummadse sabsur-odurdaklenonikoed. Ar Tiro-neggweburgi, degi, Sidón-neggweburgi we-ibmar-dakledisurmalad imaklesana, a-neggweburmar bato dikasurgus sagumor yosmalanad, degine, burugi obsamarbalinad, adi oyogega, emarde na e-iskuedga bukib ulubgi nue itosmarye. ");
INSERT INTO cuk09_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Degisoggu, an bemarga sogsun, Bab-Dummad-igar-nabogoed-ibagangi, bemar bur-bule Tiro-dorganba, degi, Sidón-dorganba sabsur odurdaklemaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Emide bedi Capernaum-dorgan, na be nibnegse-onakwiles-gusadyobi, be-nug ogannoles-gusanad. Emigindi, be uluba-odurdakleged-negse odelegoedyob, be-nug iskunonikoed. Ar Sodoma-neggweburgi we-ibmar-dakledisurmalad be-neggweburgi-imaklesadyob imaklesana, we-Sodoma-neggwebur amba emi-ibaganse degina siindo. ");
INSERT INTO cuk09_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Degisoggu, an bemarga sogsun, Bab-Dummad-igar-naboged-ibagangi, bemar bur-bule Sodoma-dorganba sabsur odurdaklemaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","A-ibagangi, Jesús sunmakdegua, sogded: “Bab, an be-nug odummosun, bedi nibneg, degine, we-napneg-e-Dummad, degine, bedi dulemar-ibmar-wismaladgi, dulemar-ibmar-magar-itomaladgi an-we-ibmarmar-imaksad aku-ito be imaksad, dulemar-baisursunnagwadga bur be osanalosad, adi amar magar itomalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eye, Bab, ar ade deyob be abesad.” ");
INSERT INTO cuk09_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús sogdebar: “Bela-ibmarmar an-Bab anga uksadi. Dulemar-wargwensaar Bab-Dummad-Machi-mag-daked satemalad, unnila Babbi mag daked, degi, Bab-aku-dakmarbalid, unnila E-Machibi mag Bab-daked, ar doaga E-Machi na e-Bab-osanalobie, agarbi na osanalodo. ");
INSERT INTO cuk09_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Bela bemar-yegus-alamaknaimalad, degi, yegus-itodidimalad anse be dagmar, ani an bemarga obunnoged ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","An-igar-maid be sumar, degi, moli-bebe-nikad warbo-ebo-arbaegala suar biir e-dukargi ebo edin-damaladyob be angi akamar, angi be durdakmar, ar an na san-dummarba na imaksulid, degine, an na gwage-eikwaa na-daed-duled. Degine, agi na be-burbagala be obunnoged amioed. ");
INSERT INTO cuk09_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ar ade an-igar-maid nollogwad, degine, an-ibmar-seed ukubalid.” ");
INSERT INTO cuk09_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Deun a-ibagangine, Jesús obunnoged-ibagi orosgii-dakleged-digaled-imbaba nadapgu, e-sapingan ukur itoargu, ibmar-digaled gwane-gwane imakarmar, gunnegar. ");
INSERT INTO cuk09_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseomar-Jesúsba-nadapmalad deyob dakarmargu, Jesúsga sogdemar: —Be dakena, be-sapingan obunnoged-ibagi ibmar-ise-imakleged imaknadapmardo. ¿Mer arbaoye igar-maisursi? ");
INSERT INTO cuk09_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús, Fariseomar-abin sogde: “An-sapingan igar-maidgi annadisulid. ¿Ar bemarde absodisurmarsi, igi David imaksa, deun David, degi, e-sordamar ukumecharmargu? ");
INSERT INTO cuk09_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","A-ibagi David Bab-Dummadse-goled-negse dognoni-gusad, degi, madu-Bab-Dummadga-uklesad gucha-gusad. Ar David, degi, e-sordamar a-madu gunnedsulinad, ar ade madu isedid. ¿We-madu unnila dule-irwa-Bab-Dummadse-gormaladbi gunnoye igar-maisursi? Degite, ¿David, degi, e-sordamar igar-noar imaksamala? Suli, ar ukudba nabir madu guchamalad. Degisoggu, an-sapingan nabir imaksamarmodo. ");
INSERT INTO cuk09_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Deginbali, ¿ar bemarde Moisés-igar-maidgi absodisurmarsi, igi dule-irwa-Bab-Dummadse-gormalad, Bab-Dummadse-goled-neggi, obunnoged-ibagi annadimala, ar degite amar igar-noar imakdimala? Suli, igar-noar imakdisurmala. ");
INSERT INTO cuk09_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ar an bemarga sogdo, emide Bab-Dummadse-goled-neggi dule-bur-dummad be-abargi gudimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ar bemar insaena, Bab Dummad soged: Nue wile emar-daked bur an abeged, anga ibmar-gummakar ukedba. Os. 6:6 We bemar insamalana, an-sordamar noar-ibmar-imaknaiye bemar sogosurmalando. Ar dulemar-igar-maidgi-yoledsurmaladgi binsa bemar egi gwisgussurmalardo. ");
INSERT INTO cuk09_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ar ade ani Dule-Machi, obunnoged-iba-e-Dummadid.” ");
INSERT INTO cuk09_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","A-nainu-naidgi nasgu, Judiomar-onmaked-negse Jesús nonisun. ");
INSERT INTO cuk09_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Agine dule-wargwen-argan-burgwaled sii-gusmogad. Jesússe yamo egichiarmar, adi Jesúsgi sogmalagar, obunnoged-igar-maidgi annadiiye. Jesúsga sogdemar: —¿Ar obunnoged-ibagi sunna dule nudaklege? ");
INSERT INTO cuk09_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús, abin-sogde: —¿Ar doa-dule, bemar na sibad-wawaad-wargwen nika-dibe, ar bei obunnoged-ibagi yaa-gureged-yaba argwachale, be onossurmalale? Be onosmalale. ");
INSERT INTO cuk09_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Ar degite, dule bur-ibmar-nuedsursi sibad-wawaadba? Ar degisoggu, ibmar-nueddo, obunnoged-ibagi ibmar-nued saed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Geb degi Jesús dule-argan-burgwaledga sogdesun: —Be-argan be onak. Dule e-argan onakwidgu, yog nuguar naded, ar igi e-argan-baid nuedi, deyob gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseomar-Judiomar-onmaked-neggi-bukmalad ainiarmargu, yog igar amiarmar, igi-saele Jesús-oburgwemalo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ar Jesús wissoggu, Fariseomar e-oburgwebied, agi-gudiidgi bangudsun. Dulemar-bukidar eba nade-gusmalad, degine, Jesús bela dulemar-uelemalad nudakdii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ar Jesús dulemar-nudaksamaladga sogde-daed, mer an-barsogmaloye. ");
INSERT INTO cuk09_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ar epenne Isaías, Bab-Dummad-gaya-burba-berbeged idu-sogsa-gusadba guega, deyob gusad, deun sogsa-gusgu, Bab Dummad sogye: ");
INSERT INTO cuk09_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Emi be dakena, an-mai, anga arbaega an susad. An nue na sabed, an-burba egi nue-weligwar itoged. An-Burba-Nued an ega ukoed, ar dulemar-Judiosurmaladga igar-naboged-igargi sunmakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Gwen a-dule urwosulid, degi, binnasur sunmakosulid. Ar degi, igar-imbaba dule binnasur gordii, e-gaya gwen itogosulid, ");
INSERT INTO cuk09_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ar gammu-maraled gwen biskosulid, degine, gwallu-bipii-bupurmaksiid gwen oginnosulid, ar geb igar-napiragwad imakedse. ");
INSERT INTO cuk09_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ar bela-Judiosurmalad e-bendakega, a-dule-edarbebukwa gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Geb degi Jesússe dule-nia-nikadi, geg-atakedi, degine, geg-sunmakbalidi ese senonimalad. Jesús a-dule-nudaksad. Degisoggu, nabir-atak, degi, nabir-sunmak nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jesús-dule-nudaksad bela dulemar geger dakdemalad, sogdemarsunnad: “¿Ar we-dulede inso David-wagwa-yoedse-danikoye-soglesad-sunnad be insae?” ");
INSERT INTO cuk09_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ar Fariseomardi degi-dulemar-soge-itoarmargu, sogdemar: “Suli, we Mesías-suli, we Beelzebú, nia-saila, a egi-naid, wede a-sogedba niamar-onodiid.” ");
INSERT INTO cuk09_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ar Jesús Fariseomar-binsanaid mag daksoggu, amarga sogded: “Rey-gwensak na neggwebur dakmaid, ar e-sordamar na dukin-dukin egi aibinnarmalale, we-neggwebur bergudeled. Degine, ar neggwebur-dibe, igi, neg-yagin-dibe, na e-neg-yaginmalad na egi aibinnarmalale, we-neg bergudeled. ");
INSERT INTO cuk09_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ar nia-saila-Satanás na e-sapingan na onodele, ar na dukin egi aibinna-itole, ar degiile, ¿igi e-neg-na-dakmaid degi-sadeguosunna? Suli, e-neg bergudele. ");
INSERT INTO cuk09_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Ar ani, nia-saila-Beelzebú-nuggi an niamar-onodiile, ¿be-sapingandi doa-nuggi niamar-onodimarmosunna? Nia-saila-ganguedbarsuli. Degisoggu, bemar-sapingan bemarga oyonado, bemar noar sogdimalad, nia-saila-sogedba an niamar-onodiiye. ");
INSERT INTO cuk09_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Ar an Bab Dummad Burba Nuedgi niamar-onodiile, we bemarga oyonado, Bab-Dummad-neg-dakmaid bemarse warmaknoniye. ");
INSERT INTO cuk09_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ar dule-dutusulid na e-neggi siile, ¿igi dule-wargwen na e-negse dogo be insae, ei-ibmar atursaegar, ar bina iduar edinsulir? Ar bina iduar edingweler-gebed, geb degi sunna ei-ibmar atursaodo. Ar an deyobmodo, an nia-sailagi-nakwisadba, sunna emi an niamar-onodiid. ");
INSERT INTO cuk09_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ar dule anba dasulile, angi gwisgudiido. Ar dule anga dulemar danar urbedisulile, bur we-dule anga dulemar-ichodiido, mer anba naguegar. ");
INSERT INTO cuk09_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Ar degisoggu, an bemarga sogsun, ar bela dulemar-iskued, degine, dulemar galagwensuli Bab Dummadgi dodoar sunmakdii-dibe, Bab Dummad sunna amarga iskued elioed. Ar dulemar Bab Dummad Burba Nuedgi galagwensuli dodoar sunmaksardi, adi Bab Dummad gege iskued amarga elied. ");
INSERT INTO cuk09_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ar doa-dule galagwensuli Dule-Machigi dodoar sunmaksa-dibe, Bab Dummad sunna amarga iskued elioed. Ar dule Bab Dummad Burba Nuedgi galagwensuli egi dodoar sunmaksardi, adi e-iskusad we-napneggi, degi, nibneggi Bab Dummad ega gwen eliosulid. ");
INSERT INTO cuk09_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ar sapi nuedile, e-durbamaked nuedmodo, sapi iskanale, e-durbamaked iskanamodo. Ar ade sapi e-sanmakedgi dakleged, sapi-nued-dibe, igi, sapi-iskana-dibe. Dulemar deyobmodo, e-daedgine mag daklenonimogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“¡Ar bemar naibe-bulegan-e-mimmiganyob-gumalad! ¿Ar bemar iskana damarsoggu, degite, ar igi ibmar-nuegangi bemar sunmakosunna? Geg ibmar-nuegangi bemar sunmakmala. Ar ade dule gwagegi-binsaedba sunmak-daed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Ar dule, dule-nuedile, e-gwage-nuedba ibmar-nued onodo, ar dule, dule-iskanale, e-gwage-iskanadba ibmar-iskana onomodo. ");
INSERT INTO cuk09_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ar andi an bemarga sogdo, ar igi binsa galagwensuli dule sunmaksale, Bab-Dummad-ibagan-igar-nabogedgine, na sunmaksadgine Bab Dummadga na dukin barsoggwichi gumalodo. ");
INSERT INTO cuk09_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ar na be sunmaksadbali bega soglegoed, be odurdaklegosurye, igi, bega soglego-dibe, be sabsur odurdaklegoye.” ");
INSERT INTO cuk09_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Agi geb gwen-gwen escribamar, degi, Fariseomar, Jesúsga sogdemar: —Odurdaked-saila, anmar-wagab ibmar-wilubgan-dakledisulid anmarga be imake, adi anmar mag dakega, be-Bab-Dummad-nuggi-sunmaked napiragwadid. ");
INSERT INTO cuk09_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús, abin-imakdegu, sogde: —Be dulemar-iskanamar, degi, neg-sichigi-galagwensuli-yolemaladyob bemar-Bab-Dummadgi-nodimalad, bemar abemardo, ibmar-wilubgan-dakledisulid be-wagab bega imaked. Ar an bega sogmardo, wilubgan bega oyolegosurdo, ar oyolegoedi, Bab-Dummad-gaya-berbeged, Jonásye-nugad gusadyob bega oyolegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Ar igi Jonás ua-dummad-saban-yaba ibapaa-ibgined, degi, ibapaa-mutikidba megisa, debayobi ani Dule-Machi, napa-urba ibapaa-ibgined, degine, ibapaa-mutikidba megmogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Machergan-Níniveginmalad Bab-Dummad-igar-nabogoed-ibagangi we-dulemar bemar-emi-dula-gudidimalad-abargi gwisgudagogu, bemar-sabsur-odurdakye sogdagoed. Ar ade Jonás Bab-Dummad-igargi sunmaksagu, Nínive-dorgan na e-iskuedga bukib-binsas-gusmalad, na e-daed gwagsamalad. Ar emigindi, Jonásba bur-bule dule-dummad wegi bemar-abargi gudiid, ar degite, bemar be-iskuedga na be bukib-binsasurmalad, be-daed na be ogwasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Reina-yalasikid-neg-dakmaid Bab-Dummad-igar-nabogoed-ibagangi bemar-emi-dula-gudidimalad-abargi gwisgudagogu, bemar-sabsur-odurdakye sogdagoed. Ar ade we-omegwa bela-bela-dikasur dani-gusad, dad-Salomón-dule-binsaed-ibed-nikad itogegar. Ar emigindi, Salomónba bur-bule dule-binsaed-nikad wegi bemar-abargi gudiid, ar degite bemar an-itobisurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ar Jesús sogdebar: “Ar niaburba dulegi nodele, neg-dinnaganaba obunnoged-neg amidii-daed. Ar neg-obunnoged amisursoggu, ");
INSERT INTO cuk09_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","sogdasunnodo, ‘An-neg an mete-alidse gannar an dognaoye.’ Ar na e-negse modapogu, dakdapodo, neg olobi sii, nue durwiar sii, degi, nue neg nudakar sibar. ");
INSERT INTO cuk09_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","“Geb degi niaburba deyob daksale, gannar naodo, e-sordamar-walagugle eba-bur-bulegan-damalad sedagegar. Niaburbamar a-negse dognonimalogu, na e-negga imakdemalodo. Ar dule epenne-e-daedba aka-bur-bule iskudsunnodo. Debayobi bemar-emi-iskudidimalad gumarmogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ar amba Jesús dulemarga sunmaksii, deun e-nan, degine, Jesús-e-urbamar neg-magaba Jesús-edarbebukwa-gusmalad, ebo sunmakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dule-wargwen Jesúsga sokar: —Emi be-nan, degi, be-urbamar, neg-magaba be-edarbebukmalad, bebo sunmakbimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ar Jesús, dule-degi-ega-sogedga abin-sogded: —¿Ar doa an-nan-sunna, degi, doamar an-urbamar-sunna? ");
INSERT INTO cuk09_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jesús na e-argan e-sapingansik oyodgua, sogde: —We an-nan, degi, wemar an-urbamar. ");
INSERT INTO cuk09_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ar ade doa-dule an-Bab-nibneggi-maidba, a-sogedba ibmar imakele, ar a an-nando, a an-bundo, degine, a an-urbamardo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A-ibagi Jesús-neg-yagi-sii nodgua, mata-dummad-gakase nade-gusad, geb agi sigdap. ");
INSERT INTO cuk09_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Agi dulemar-bukidar ese nonimalad. Jesús urgi nakwisgu, agi sigis dulemar-odurdakegar, ar dulemardi bela mata-dummad-gakagi ambikusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús bukidar ibmar-burbarmaladgi akar-akar dulemarga sunmaksii-gusad, dulemar-odurdaksii-gusad. Geb Jesús sogde-gusad: “Ibagwengine dule-wargwen-ibmar-gwag-digedi, ibmar-gwag dignaded. ");
INSERT INTO cuk09_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ibmar-gwag dignaigusgu, abala ibmar-gwag igargi babatidapid. Sikwimar nonigua, ibmar-gwag-igargi-babatismalad manonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","“Abala akwa-yaisulidgi babatismalad napa-askinnegwadgi. Ar agi gwae-gwae ibmar-gwag ainialid, ar ade napa askinnegwad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Dad gaargu, ibmar-gwag gummakded, ar ade e-maligan askinnesoggu, dinguded. ");
INSERT INTO cuk09_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Abala ibmar-gwag iko-abargi babatisad. Ibmar-gwag dungudgu, ikomar ibmar-gwag ichosad, degisoggu, gwen sanmaksasursundo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Ar ibmar-gwag-napa-nuedgi-babatismaladdi, adi nue sanmaksad. Gwenna-gwenna akusaar sanmaksad, baiddi bur-nuegwad sanmaksad, degi, baigandi bur-napiragwad sanmaksad.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Geb Jesús sogdebar: “Bemar mag nue itobiele, nue itomar, an bemarga ibmar soged.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Geb degi e-sapingan Jesússe nonimargu, ega sogdemar: —¿Ar ibiga be dulemarga burbar ibmar sog-dae? ");
INSERT INTO cuk09_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús, abin-imakdegu sogde: “Ar bemargardi Bab-Dummad-neg-dakmaid igar-burbar-mamaid osanalogoye maid, ar dule-baigangardi ega osanalegosulid. ");
INSERT INTO cuk09_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ar dule-ibmar-nikadga, uklebalodo, adi bur-bule ibmar gatik nikuegar. Ar dule-ibmar-suliddina, ar bipii-wis-ibmar-nikad aka bur e-annik sulegoed. We sogledo, bemardi bur-bule ibmar mag-ito-guoye. ");
INSERT INTO cuk09_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","A-ular we-dulemarga burbar an sunmak-daed: Ar amba dakmar-inigwele, aku dakmardo. Ar itomar-inigwele, aku itomardo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ar degisoggu, igi epenne Isaías Bab-Dummad-gaya-burba-berbegedi sogsa-gusa, ar deyob gunonisundo, deun sogsa-gusgu: Ar na e-uayagwar itomalo-inigwele, aku itomaloed. Ar na e-ibyagwar dakmalo-inigwele, amba aku dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ar we-dulemar an-itobisurmalad, ar na e-uayagi nue aku-itomalad, ar e-ibya na murdik imasmalad. Ar adi mer na e-ibyagi mag dakmalagar, degi, mer na e-uayagi mag itomalagar. Ar degiile, Bab Dummadsik namalo-itole, ar degiile, an nudak dakledagoed. ");
INSERT INTO cuk09_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ar bemar-ibya mag dakedba, degi, bemar-uaya mag itogedba, bemardi nued begi binsalesadmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ar napira an bemarga soged, bukidar Bab-Dummad-gaya-burba-berbemalad, degi, bukidar dule-inikii-ibmar-imakmalad, emi-bemar-ibmar-daked dakbi gusmalanad, amar gwen daksasurmalad, degi, emi-bemar-ibmar-itoged itobi gusmalanad, amar gwen itossurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesús sogdebar: “Emi bemar nue itomarsun, ibmar-gwag-digedgi burbar an-bemarga-sunmaksad-igar: ");
INSERT INTO cuk09_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ar dule-wargwen Bab-Dummad-gaya-burba itosad, aku-ito-dibe, nia-saila nonikogua, a-dule-gwagegi gaya-burba-nued-diglesad ei ungenonikodo. Ar we sogledo, we ibmar-gwag igargi diglesadye. ");
INSERT INTO cuk09_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Ar ibmar-gwag-akwa-imbaba-babatismaladdi, adi Bab-Dummad-gaya-burba itosmargu, nue weligwar abingasmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ar wemar unnila askinbi Bab-abingasmarsoggu, ibmar-gwag-digaled maligan-askinnegwadyobdo. Degisoggu, Bab-Dummad-gaya-burba-ular wilearmargu, degine, dulemar sabsur e-imakarmargu, Bab Dummadgi bangudmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Ar ikomar-abargi-batismaladdi, we-dulemar Bab-Dummad-gaya-burba abingasmalando, ar we-napneggi-ibmar-nanaidgi, degi, maniginbi bur binsamarsoggu, binsaed-galedmalad, Bab-Dummad-gaya-burba-e-gwagegi-naid iedmarsunnad. Degisoggu, amar ibmar-gwag gwen sanmaksasulidyob gunonisundo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Ar ibmar-gwag-napa-nuedgi-diglesmaladdi, we-dulemardi Bab-Dummad-gaya-burba itosmargu, magasar nue itosmalad. Degisoggu, amar ibmar-gwag nue sanmaksamaladyob gunonisundo. Abala bur-napiragwad sanmaksamalad, abala bur-nuegwad sanmaksamalad, degine, baigandi bur-akusaar sanmaksamardo.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús burbar dulemarga sunmakdebar, sogdebar: “Bab-Dummad-neg-dakmaid-e-gaya-burba, dule-wargwen na e-nainugi ibmar-gwag-nued digsayobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ar dulemar gabidmargu, e-istarad orosgiid-digaled-abargi gagan-iskana dignonimogad, geb degi nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Ibmar-gwag nue aramaksagu, sanmakargu, gagan-iskana-abargi daklearmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ar e-maigan nainu-ibedse nonimalad, ega sognonimalad: ‘Dummad, ¿ar be-nainugi ibmar-gwag-nued be digsasursi? ¿Ar degite, bia we-gagan-iskanamar danisunna?’ ");
INSERT INTO cuk09_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nainu-ibed, abin-imakdesun: ‘An-istarad we-gagan-iskana digsad.’ E-maigan, abin-imakdemar: ‘¿Anmar we-gagan-iskana ungenabi be abege?’ ");
INSERT INTO cuk09_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Nainu-ibed, abin-sogde: ‘Suli, mer be ungenamar, ar abakalegi gagan-iskana bemar ungenaidgi orosgii-dakleged ungiarbalile. ");
INSERT INTO cuk09_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bur ebobela itoba na dungumaimaloed, ibmar-gwag-weleged-ibaganse. A-ibagangi ibmar-gwag-wemaladga an sogoed, bina gagan-iskana-inse be wemargwerye, amar danar-danar edinmarye, ogumakegar, orosgii-daklegeddi an-ibmar-gwag-urbilegedse be urbenamaloye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús baid igar-burbar-sunmaklegedgi sunmakdebar, sogdebar: “Bab-Dummad-neg-dakmaid-igar emi mostaza-e-gwag dule-wargwen na e-nainugi digsayobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ar mostaza-gwagde ibmar-gwagba bur-bipii-inigwele, ar dunguderdi, ibmar-dubaled-masga-gued-birgi obite-daed. Degisoggu, ar sapiga gunonikogu, sikwimar-niba-gukudimalad sunna e-anagangi gabsundo.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús burbar-sunmakleged-igargi sunmakdebar, sogdebar: “Bab-Dummad-neg-dakmaid-igar weyobdo, ar igi ome-wargwen ilapaa-madubur-wilubsaedgi, madubur-ina obatisa, geb degi madubur-ina binna-binna madubur ganoni-daed, bela omuedse.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ar bela Jesús burbar-sunmaklegedgi dulemarga sunmakde-daed, burbar-sunmaksuli gwen gussulid. ");
INSERT INTO cuk09_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ar Bab-Dummad-gaya-burba-berbeged sogsa-gusadba guegala, deyob Jesús sunmak-gusdo, deun sogsa-gusgu: An sunmakdogu, burbar an sunmakoed, nega-saila-akar ibmar-dukuar-mamaid an odulogega, burbar an sunmakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Geb degi dulemar Jesúsgi bangudgua, Jesús neg-yaba dogdesun. E-sapingan Jesússe walik gunonimargu, ega sogdemalad: —Anmarga be odulo, we ibi obare, gagan-iskanagi burbar be anmarga sunmaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús, abin-imakdegu, sogde: “Dule-ibmar-gwag-nued-digedi, we Dule-Machido. ");
INSERT INTO cuk09_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nainu-obaredi we-napnegdo, ibmar-gwag-nuedi, we Bab-Dummad-neg-dakmaid-e-mimmigando, gagan-iskanadi, we nia-saila-e-mimmigando. ");
INSERT INTO cuk09_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ar dule-istarad-gagan-iskana-digsadi we nia-sailado, ibmar-gwag-weleged-ibagan, we-napneg-berguoed-ibagando. Dulemar-ibmar-gwag-wemaladi, we angermardo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ar igi gagan-iskana unnulege, degi, ogumaklege, deyobi we-napneg-berguedse guoed. ");
INSERT INTO cuk09_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ar Dule-Machi na e-angermar-barmidagoed, na e-neg-dakmaidgi dulemar-ibmar-ichodimalad, degi, ibmar-iskana-imakdimalad-wenonikoed, ");
INSERT INTO cuk09_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","soo-sailase ogumaknaega, ar agi amar bobukwa, degi, beedse-wilebukwadba nugar-ogorbukwa-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Geb degi dule-ibmar-inikii-imakmalad e-Bab-neg-dakmaidgi dad-ibeler-gaeyob mag daklenonikoed dule-nuegan-sunnad-gumalad. Ar dulemar uaya-itogega-nikmalad nue itomar an-ibmar-sogsad.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús sogdebar: “Aginbali, Bab-Dummad-neg-dakmaiddi or-nuegan nainugi odukuar bukwadyobdo. Dule-wargwen a-or-nuegan amisgu, gannar odukusad. Na weligwar-ito naogua, bela na ibmar-nikadi ukogua, a-nainu na bakoed, adi a-or-nuegan na egadga guegar.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesús sogdebar: “Amba Bab-Dummad-neg-dakmaid, dule-wargwen-ibmar-baked, morbeb-akwagiid-nuegan amidiidyobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ar morbeb-akwagiid-bur-nued amisgua, nade-gusad. Na ibmar-nikad bela uksagu, ar a-morbeb-akwagiid-bur-nued baksasunnad.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesús sogdebar: “Amba deyobbardo, Bab-Dummad-neg-dakmaid sakiyobdo. Saki demargi miledogu, bela galagwensuli uamar egi galeged. ");
INSERT INTO cuk09_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Saki ua-ena-gusale, demar-gakase saki seledogu, dulemar ambikumalogu, uamar-nuegan garbagi-urbega suledagoed, uamar-iskanadi miledoed. ");
INSERT INTO cuk09_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","“Ar debayobi we-napneg berguedse guoed. Angermar ainidogu, nonimaloed, dulemar igar-maidba-inikii-ibmar-imakmalad, degi, dulemar-iskana akar-akar bachik urbegar. ");
INSERT INTO cuk09_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dulemar-iskana soo-sailase miledmaloed, ar agi amar bobukwa, degi, beedse-wilebukwadba nugar ogorbukwa-gumaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús geb e-sapinganga sogdesun: —¿Ar bela Bab-Dummad-neg-dakmaidgi an-bega-sogsamalad mag be itomala? Jesús-abin, sogdemar: —Eye, Dummad, bela mag an itomar. ");
INSERT INTO cuk09_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Geb degi Jesús amarga sogdesun: —Ar a-ulale, escriba-wargwen bela Bab-Dummad-neg-dakmaid-igar nue wisile, bab-na-neg-yaur-sediid-wargwenyobdo, igi we-dule na e-ibmar-nuedgi ibmar-binigan, degi, ibmar-sergan, ono-dae, deyobmodo, we-dule-nue-igar-wisid, ibmar-epenne-durdaksad, degine, ibmar-bini-durdaksad ebumodo baigan-odurdakega. ");
INSERT INTO cuk09_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús igar-burbamaladgi-sunmaksiid bergusad-sorba, nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jesús na e-dungued-neggweburse nonigu, Judiomar-onmaked-neggi emar-odurdaksigisad. Bukidar agi geger dakdemalad, sogdemalad: —¿Ar wede, bia binsaed-nuegan ami-dae, degine, ibiga nabir wede ibmar-dakledisurmalad imak-dae? ");
INSERT INTO cuk09_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ar wede carpinter-e-machisursi? ¿Ar e-nande María-nugsursi, Santiago, José, Simón, degine, Judas, amarde e-urbamarsursi? ");
INSERT INTO cuk09_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ar bela-e-bunmarde anmar-abargi gudisursi? ¿Ar degite, wede bia we ibmarmar durdaksasunna? ");
INSERT INTO cuk09_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Degisoggu, a-ular dulemar geger Jesús-dakdemalad, Jesúsgi uludmarsunnad. Ar Jesúsdi amarga sogde: —Bab-Dummad-gaya-burba-berbemalad bela-neggwebur-baigangi bina nue sogdamalad, unnila e-neggweburginbi, degi, e-neg-yaurginmaladbi baisur dakdamalad. A-ulale bemar an-abingassurmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Degisoggu, a-ulale, Nazaretgi Jesús ibmar-dakledisurmalad dogdar gwen imaksasulid, ar ade bukidar egi benmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Deun a-ibagangi, Rey-Herodes itoar bela-dulemar Jesúsgi sunmakedbimar. ");
INSERT INTO cuk09_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes na e-maiganga sogde: “We-dule-gudiid, we Juan-Bautista, ar wede gannar-durgus gudiid, a-ulale nabir ibmar-dakledisulid imaked.” ");
INSERT INTO cuk09_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ar ade Herodes, Juan-Bautista-gasa-gusad, eskoro-dubgi-edicha eskaryagi mete-gusad, Herodías-ular. Herodíasde, Felipe-omenad. Ar ade Herodes e-urbagi ome-egwachad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ar ade Juan Herodesga soged: “We-ome be nikued sulinye.” ");
INSERT INTO cuk09_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Deun Herodes Juan-oburgwebien-inigwele, geg oburgwe-gusad, dulemar-dobedba. Ar ade dulemar Juangi binsamalad, we Bab-Dummad-gaya-burba-berbegedye. ");
INSERT INTO cuk09_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Deun Herodes-gwalulesad-ibagi iba-ononanaigua, Herodías-e-sisgwa emar-abargi dodosgua, Herodes deun nue-yeer daksa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","A-ulale Herodesde bunagwaga sogsad: “Napira an bega soged, Bab-Dummad-nuggi an bega sogbalid, ar ibu be anse egisbie, an bega ukoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A-bunagwade, e-nan-ega-sogedba Herodesga sogded: —Bategi, Juan-Bautista-e-nono be anga udaye. ");
INSERT INTO cuk09_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rey-Herodes deyob bunagwa-ega-soge itosgu, nue bukib-ito naded, ar bato bunagwaga sogsasoggu, “Napira an bega sogye, ar ibu be anse egisbiele, an bega ukoye,” degine, dulemar-eba-mesa-naba-siid e-itosmosoggu, Herodes e-sordamarga sogdesun, “Bunagwaga Juan-Bautista-e-nono ukmarye.” ");
INSERT INTO cuk09_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Degisoggu, Herodes igar-uksasun, Juan-Bautista-eskaryagi-mellesiid e-dukar egwanegar. ");
INSERT INTO cuk09_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sordamar Juan-Bautista-e-nono bategi senonimargu, bunagwaga uknonimarsun, geb degi bunagwa e-nanga uksamosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Geb degi Juan-sapingan, Juan-e-san sunonimar, geb degi na neg-uangi digsamarsunnad. Geb degi Juan-e-sapingan nadmargu, Jesúsga sogdapmalad, Juan igi burgwisad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan-Bautista-burgwisad Jesús wisgusgu, dulemargi banguded, na emarbi urgi bachikii nadmalad, nega-dule-sulidganba. Ar dulemar Jesús-naded wisguarmargu, neggwebur-irba eba nagap nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús urgi aidedgu, dulemar-bukidar e-idu bukwa dakargu, nue dulemar wile dakde, degine, dulemar-uelemalad bela nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bato neg-sedodgu, e-sapingana Jesússe warmaknonimalad, ega sogdemalad: —Emi anmar nega-dule-sulidgangi bukmalad, degine, bato neg-sedodbalid. Degisoggu, dulemar be barmid, adi neggweburmarse namalagar, adi agi mas-gunned na bakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús na e-sapingan-abin sogde: —Wemar nasulir akarsulid, ar bemar ega mas-gunned ukmala. ");
INSERT INTO cuk09_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","E-sapingan, abin-sogdemar: —Anmar wegi mas sated, unnila madu-gwaatar, degi, ua-ukabo anmar nikmalad, degite, ¿igi anmar we-dulemar masgi ogunmalosunna? Geg anmar masgi ogunmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús na e-sapinganga sogde: —Degite madu, degi, ua anse be sedamar. ");
INSERT INTO cuk09_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Geb degi Jesús gagan-birgi dulemar-oambikuega imaksad. Jesús madu-gwaataled, degi, ua-ukabogwad susgua, niba atakdegu, Bab Dummadga dog-nuedye sogsad. Geb degi Jesús madu, degi, ua biske-biske imasgu, na e-sapinganga ukded, degi e-sapingan dulemar-bukidaradga ukdemosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Degine, bela-dulemar-gudidimalad nue-immeles mas guchamalad. Jesús-sapingan mas-obichad wesmargu, garba-gwaambe-gakabo-mergu enosmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ar dulemar-mas-guchamalad, unnila macherganbi miliatarsaar mergued, omegan, degi, mimmigan, amardi obarilesulid. ");
INSERT INTO cuk09_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Geb degi Jesús na e-sapingan urgi gwae nakwega imaksad, adi e-iduar mata-dummad-gaka-obakar namalagar, na edi dulemar naega imakega besad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jesús dulemar bela barmisgu, na walagwen yar-birse nakwisad, Bab Dummadse golegar. Neg-mutikudgu, na walagwen Bab Dummadse gorsigisad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ar e-sapingandi urgi mataba omukulenado, ar ade burwa asabin gormaid. ");
INSERT INTO cuk09_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wakudaryalaba, Jesús na e-sapinganse mata-dummad-birgi ganna-ganna nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesús-sapingan, dule mata-dummad-birgi-dani dakarmargua, dobe-ito nadmalad, dobedba binnasur gotemalad, sogdemalad: —¡Sergan anmargi dani! ");
INSERT INTO cuk09_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Degisoggu, a-ular Jesús yog e-sapinganse gotesun, ega sogdesun: —¡Be gandik imakmar, ani an gudii, mer be dobgumar! ");
INSERT INTO cuk09_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Geb degi Pedro, abin-sogde: —Dummad, ar be gudiile, an bese mata-dummad-birgi ganna-ganna daged be an-imakdo. ");
INSERT INTO cuk09_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús Pedroga sogde: —Be dagdena. Pedro urgi-siid mata-dummadgi aidesgu, mata-birgi ganna-ganna Jesússe nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pedro burwa-binnasur-gormai dakdegu, dobe-ito naded. Geb degi matagi dogdegu, binnasur gote, sogde: —¡Dummad, an-bendake! ");
INSERT INTO cuk09_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Geb degi Jesús argangi Pedro-gasgu, Pedroga sogded: —Be an-bengued-duled, ar ¿ibiga be an-bengusa? ");
INSERT INTO cuk09_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ar Jesús, Pedro-ebo urgi nakwismargu, burwa bogidik naded. ");
INSERT INTO cuk09_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Degine, urgi-bukwamaladi daksamargu, Jesús-nug odummodmarsun, igi Bab-Dummad-nug odummole-damogadyob, Jesúsga sogdemar: —Ar nue be Bab-Dummad-Machi-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Geb degi Jesús na e-sapinganmala mata-dummad obaksamargua, Genesaret-yarse nonimarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Dulemar-a-neggweburginmalad mag daksamargu, we Jesús gudiiye, gaya-burba mimmidmar, neggwebur-dikarba nanaidse. Degine, bela dulemar-uelemalad Jesússe senonimar. ");
INSERT INTO cuk09_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jesúsgi wilenagus-damalad: “Unnila be mor-dukubi wis ebuged be anmar-imakye.” Ar bela e-mor-duku-ebusmalad, bela nugusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Geb degi escribamar, degi, Fariseomar Jerusaléngi-danimalad Jesússe nonimargu, Jesúsga sogdemar: ");
INSERT INTO cuk09_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ibiga be-sapingan dadgan-igar-maidgi-wede yoledimala? ¿Ar ibiga be-sapingan argan enuksurmala mas-gunned-iduar? ");
INSERT INTO cuk09_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús, abin-imakdegu, sogde: —¿Ar ibiga bemarmo Bab-Dummad-igar-maidgi yoledimarmosunna, bemar dadgan-igar-maidba daed-ular? ");
INSERT INTO cuk09_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ar Bab Dummad sogsad: Be-bab-nug, degi, be-nan-nug, be odummogoye. Ex. 20:12; Dt. 5:16 Degine: Dule-gwensak babgi, igi, nangin-dibe gaya-ichakwa sunmaksale, a-dule oburgwemaloye. ");
INSERT INTO cuk09_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ar emigindi bemar-Fariseomardi soggu: ‘Ar doa-dule e-babga, degi, e-nanga sog-dibe: Geg an be-bendaked, ar bela-an-ibmar-nikadi bato Bab Dummadga an uksad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ar degisoggu, a-dule e-bab, degi, e-nan bar bendaksulir, gwen akarsulid.’ Ar weyob bemar dulemar-odurdakedba Bab-Dummad-igar-maidgi yoledimardo, be-dadgan-igar-maidba daed-ular. ");
INSERT INTO cuk09_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Bemar wagar-darbo-damalad! Ar nabir Isaías, Bab-Dummad-gaya-burba-berbeged, epenne bemar-nik sogsa-gusad, deun Bab Dummad sogye sogsa-gusgu: ");
INSERT INTO cuk09_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","We-neggwebur unnila askinbi an-nug odummomalad, ar e-gwage-ulubgindi angi gwen binsasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ar binsa askinbi amar anse gordimalad, an-nug odummomalagar. E-igar-maid odurdakeddi, dulemar-igar-mesisadba bur odurdakmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Degi Jesús dulemar-yogsarmaladse gotegu, amarga sogded: —Nue bela bemar an-itomalo: ");
INSERT INTO cuk09_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ar mas-gunned dule-ichosulid, ar dule galagwensuli-sunmakerdi, adi dule-ichodo. ");
INSERT INTO cuk09_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Geb degi e-sapingan Jesússe-walik gunonigua, ega sogdemar: —¿Be wisi, emi Fariseomar sae-itodmalad, weyob be-ibmar-soge itoarmargu? ");
INSERT INTO cuk09_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús, abin-imakdegu, sogde: —Ar an-Bab-nibneggi-maid sapi digsasulid, a-sapi gannar ungoed. ");
INSERT INTO cuk09_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mer geger be Fariseomar-dakmala, ar ibya-suliyob gudidimalad, amar aku-atakmalad-iduedmalad. Ar dule-ibya-sulid, dule-ibya-sulid-idumaile, ebobela neg-gullu-dummadgi argwanmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro, abin-imakdegu, Jesúsga sogde: —Anmarga be oduloge, we be-ibmar-burbar-soged mas-gunned dule-ichosulid, we ibu obare. ");
INSERT INTO cuk09_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús, abin-sogde: —¿Ar bemarmo amba aku-itomarmoga? ");
INSERT INTO cuk09_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ar bemar aku-itoge, bela mas-gunned, unnila sabanse ubod-daed, degi, geb gannar miled-dabalid? ");
INSERT INTO cuk09_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ar dule-galagwensuli-sunmakeddi, adi gwagegi-bukwa ainiar-daed, degisoggu, amardi dule-ichosundo. ");
INSERT INTO cuk09_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ar dule-gwagegi binsaed-iskanamar ainiar-daed, na iblomalad, na ome-dikarba, degi, sui-dikarba yolemalad, na abirgunagwarsuli neg-sichigi nanamalad, ibmar-atursamalad, gakansaar aimar-barsoged, Bab-Dummad-nuggi dodomalad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ar we-ibmarmardi dule-ichomaladdo, ar dule argan-enuksuli mas-gunneddi, dule-ichogedsulid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús Genesaretgi-gudiid nade-gus, Tiro, degi, Sidón-yarse. ");
INSERT INTO cuk09_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Agi ome-wargwen, Judiosulid, Cananeagined, a-yalaganba-danikid, binnasur Jesússe gordani, sogdani-gusad: —¡Dummad, be David-Wagwa, wile be an-dake! An-bunagwa sabsur niasamaid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ar Jesúsdi gwen abin-imaksasulid. Geb degi e-sapingan Jesússe warmaknonimargu, egi wilenagusmalad, ega sogdemalad: —We-ome be barmide, ar anmar-sorba wede ee gordanikid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús, abin-imakdegu, sogde: —An barmilealidi, dulemar-baiganse an barmilearsulid, unnila Israel-dulemar-sibad-wawaadyob-yoggus-gudimaladse an barmilealid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Degi, ome Jesús-abin yokorgi signonikid, ega sognonikid: —¡Dummad, be an-bendake, anga an-bunolo be nudake! ");
INSERT INTO cuk09_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús, abin-imakdegu, sogde: —Be Judiosursoggu, an be-bendakele, mimmigan-mas achuga uknaiyob an imako-itole, degisoggu, igar-maisulid mimmigan-mas achuga be ukoye. ");
INSERT INTO cuk09_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ome, Jesús-abin sogde: —Dummad, nabir be sogendo, ar degi-inigwele, achumarse-bakar sunna mimmigan-mas mesa-urba-batemamaid gunmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Geb Jesús, ome-abin imakdegu, sogde: —Ome, ibibayobi be an-bensuli bega sunna be-bunolo an nudakoed, degisoggu, deyob bega gusun. Ar a-wachigi yog e-bunolo nuguar-naded. ");
INSERT INTO cuk09_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tiro-yargi, degi, Sidón-yargi Jesús bangudgua, Galilea-mata-dummad-naidse nonikid. Geb degi Jesús yar-birse nakwisgu, agi sigidapid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Agi dulemar-bukidar Jesússe nonimalad, ese senonimalad, dulemar-muya-muya-nanamalad, dulemar-ibya-surmalad, dulemar-geg-sunmakmalad, dulemar-sakwa-sikarmalad, degi, bukidar dulemar-galagwensuli-uelemalad Jesús-nag-naba mesnonimalad. Jesús amar bela nudaksa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Degisoggu, dulemar-bukmalad geger dakdemalad, dulemar-geg-sunmakmalad sunmak imasgu, dulemar-sakwa-sikarmalad nudaksagu, dulemar-muya-muya-nanamalad nabir-nanae imaksagu, dulemar-ibya-surmalad mag-daksa imasgu. Degisoggu, Israel-Bab-Dummad-nug ogannodmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Degi Jesús na e-sapinganse gochagua, amarga sogde: —We-dulemar nue-wile an daked, ar ibapaagus anmarba bipirmakdimalad, mas-gunned sate gudimalad. Degisoggu, dulemar mas-gunsuli an barmidele, abakalegi igarba negoedamalale. ");
INSERT INTO cuk09_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Geb degi e-sapingan, abin-sogdemar: —¿Ar bia wede anmar neg-dule-sulidgangi mas-ichesur amimalosunna, we-dulemar-ichesulid masgi ogunnegar? ");
INSERT INTO cuk09_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús na e-sapinganga sogde: —¿Madu-bigwa bemar nikmarsunna? E-sapingan, abin-sogde: —Madu walagugle anmar nikmalad, degi, ua anmar wis nikmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Degi, Jesús dulemar-bukidarmalad napagi-sigega imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesús madu-walagugled susgua, degi, uamar susbargua, Bab Dummadga dog-nuedye sogsa-gusad. A-sorba, madu, degi, ua biske-biske imaksagu, e-sapinganga ukded. Geb degi e-sapingan dulemarga ukdemogad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dulemar-bergwapa madu, degi, ua-guchamargu, nue immelesmalad. Jesús-e-sapingan e-gwabgusad bela wesmargu, garba-gwagugle enosmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bela madu, degi, ua-guchamalad, macherganbi milibake-mergu daklealid. Omegan, degi, mimmigandi gwen obarilesulid. ");
INSERT INTO cuk09_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Degi, Jesús dulemar-barmisgu, Jesús urgi nakwissun, geb degi Magdala-yalaganse nonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseomar, degi, Saduceomar, Jesússe nonimar, yamo Jesús-wilubdakegar. Jesúsga sogdemar: —Be anmarga Bab-Dummad-ganguedba, ibmar-wilubgan-dakledisulid anmar-wagab be imake, adi anmar mag be-dakoed, be Bab-Dummad-nuggi nue danikid. ");
INSERT INTO cuk09_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús amar-abin imakdegu, sogde: “Wegi anmar-yargi neg-sedodele, bemar sogmardo: ‘Mogir, ber ginnidikid, degisoggu, neg-yolasaila guoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Degine, neg-wagdar bemar sogmarbardo: ‘Emi mogir ber ginnidikid, degine, gutumar yaisurbalid, degisoggu, dii burwaba mesa wioed.’ ¡Bemar wagar-darbo-damalad-dulemar! Ar di-wioeddi magar bemar dakmalad, degite, bemar-abargi ibmar-gunaiddi aku bemar dakmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","“Dulemar galagwensuli-damalad, degi, neg-sichigi-galagwensuli-yolemaladyob Bab-Dummad-sogedba-ibsasurmalad, amardi ega ibmar-wilubgan-dakledisurmalad oyobi abedamalad. Ar we-wilubgan ega oyolegosurmalad, unnila ega oyolegoedi, Bab-Dummad-gaya-burba-berbeged, Jonás, a-gusadyob a-wilubgan ega oyolegoed, adi wisgumalagar an doa-dule gue.” Jesús degi-sogsagu, emargi bangudsun. ");
INSERT INTO cuk09_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jesús na e-sapinganmala mata-dummad-gaka-obakar mosgua, e-sapingan dakarmar madu na iesmala. ");
INSERT INTO cuk09_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús na e-sapinganga sogdesun: —Nue salakarmar, Fariseomar, degi, Saduceomar-madubur-inagi. ");
INSERT INTO cuk09_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesús-sapingan na dukin ulubgi binsadmalad, sogdemalad: —Jesús weyob anmarga soger-gebed, anmar madu searsulidbar. ");
INSERT INTO cuk09_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús mag daksagu e-sapingan madu-senonisulidgi sunmakmalad, amarga sogdesun: “¿Ar ibiga bemar sogmarsunna, anmar madu searsurye? ¿Ar amba be an-benmarde? ");
INSERT INTO cuk09_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ar amba bemar nue-akusunna itomala, degine, be insasurmarsi, madu-gwaataledgi dulemar-miliatar madu guchamalad? ¿Agi madu-obichad garba-gwaambe-gakabo-mergu bemar wesmarbarsursi? ");
INSERT INTO cuk09_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Deginbali, ¿amba bemar insasurmarbali, madu-gwagugledgine dule-milibake madu guchamalad? ¿Agi madu-obichad, garba-gwagugle bemar wesmarbarsursi? ");
INSERT INTO cuk09_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ar ibiga bemar nue-akusunna itomala, madu-ular an bemarga sogsasulid, bemar nue salakarmarye, Fariseomar, degi, Saduceomar-madubur-inagi?” ");
INSERT INTO cuk09_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Geb degi Jesús-sapingan nue mag itosmalad, ega sogsad, madubur-inagi nue salakarmarye, nue madubur-ina-sunnadgi ega sogsulid. Ega soged, Fariseomar, degi, Saduceomar-ibmar-odurdakedgi nue salakarmarye. ");
INSERT INTO cuk09_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús Cesarea-de-Filipos-yarse nonigu, agi e-sapinganse egichialid, ega sogded: —¿Ani Dule-Machi, wede doaye an-nik dulemar sogmala? ");
INSERT INTO cuk09_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","E-sapingan abin-sogdemar: —Gwenna-gwenna Juan-Bautistaye, be-nik sogmalad. Baigandi sogmalad, be Bab-Dummad-gaya-burba-berbeged Elías-nugadye. Agi baigan sogmarbalid, be Jeremíasye, ar a sulile, baigan sogmarbalid, be Bab-Dummad-gaya-burba-berbeged epenne-gudigusad-wargwenye. ");
INSERT INTO cuk09_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús na e-sapinganga sogde: —¿Bemardina, doaye an-nik sogmarmosunna? ");
INSERT INTO cuk09_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón-Pedro Jesús-abin sogde: —Be Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule, Bab-Dummad-Dula-Maid-E-Machi-sunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Geb degi Jesús, abin-imakdemogad: —Simón, be Jonás-machi, begi nued binsalesad, ar dule we-ibmar bega sogsasulid, bega-sogsadi, an-Bab-nibneggi-maid, a bega we osanalos, an Cristoye, Bab-Dummad-Machi-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ani an bega sogsun; be Simónye-nugad, Pedroye be-nuggubaloed. We-akwa-birgi anba-nanaimalad an na omelomai an imakoed, burgweddi gwen egi nakosulid. ");
INSERT INTO cuk09_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Degine, ani an Bab-Dummad-neg-dakmaid-yabi an bega ukoed, ar bela we-napneggi be-ibmar-sogsadba galenonikile, nibneggi bela galenonimogoed. Ar we-napneggi be-ibmar-sogsadba igar-egasale, nibneggi bela deyob igar-egalemogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Geb degi Jesús na e-sapinganga sabsur sogdesun: “Melle dulemar-baiganga bipisaar sogoye, ede Jesúsye, Cristoye, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-sunnadye.” ");
INSERT INTO cuk09_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","A-iba-onodedgi Jesús na e-sapinganga e-burgoedgine sunmakded, ede Jerusalénse naer-gebye, Judiomar-girmar-dummaganse nue odurdaklegoye, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse nue wilegoye, degine, escribamarse wilebaloye, ede amarse oburgwilegoye, geb degi ede ibapaagi gannar durguoye. ");
INSERT INTO cuk09_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro, deyob-Jesús-sogsad itosgu, bachik Jesús-sesad, Jesúsga sabsur ibmar sogded: —Dummad, na be dukin wile na be dake, ar bela we-ibmar-be-sogsadi mer deyob bega guena-gadin. ");
INSERT INTO cuk09_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ar Jesús Pedrosik aibiris imaksagu, Pedroga sogde: —¡Nia-saila-Satanás, be angi bangusun! Bedi igar-iskanagi an-egwanbi-gudiid. Pedro, ar be-binsaedi, Bab-Dummad-sunnaa be binsasulid, unnila dulemar-sunnaa be binsaed. ");
INSERT INTO cuk09_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Geb degi Jesús na e-sapinganga sogde: “Ar dule-wargwen an-sapinga gubiele, na dukin san ieger-gebed, nakrus-semaiyob nanaer-gebed, bato burgwenadapidyob, geb a-dule anba dagodo, geb a an-sapinga guodo. ");
INSERT INTO cuk09_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","“Ar dule-wargwen anba-naid-ular burgwebisulir, e-san-burba ei yogguodo. Ar anba-naid-ular burgwenonikirdi, adi na e-san-burba yogguosurdo. ");
INSERT INTO cuk09_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Ar ibi-nuedga dule-wargwenga gusar be insae, ar dule napneg-naid bela egadga imaksar, ar e-san-burbadi yoggusar? Deginbali, ¿dule-gwensak e-san-burba-ular, ibi na uksar be insae, adi e-san-burba mer ei yogguegar? Ibmar-sated san-burba-ular ogwaed. ");
INSERT INTO cuk09_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Ar Dule-Machi na E-Bab-ganguedgi, degi, yeer-daklegedgi na e-angermar-abargi we-napnegse danikir, geb degi bela wala-walagwen dulemarga ibmar uknonikoed, na e-ibmar-imaksamaladba. ");
INSERT INTO cuk09_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Napira an bemarga soged, gwenna-gwenna wegi-bemar-bukmalad, burgosulid, amba dula gudii Dule-Machi-neg-dakmai-gued bemar dakedsemalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A-iba-nergwad-sorbali, Jesús, bachik Pedro, Santiago, degine, Santiago-urba Juan, amar bachik yar-bir-matusulidse sesad. ");
INSERT INTO cuk09_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Amar-asabin yar-birgi-gwichi Jesús-e-san-dakleged gwagde-gusad, na e-wagar dad-ibeler-gaeyobi gade-gusad, degine, e-mormar bela ise-sipumakar, bela dagudik, gwallubayobi dakle-naded. ");
INSERT INTO cuk09_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Geb agi Jesús-sapingan-warbaagwad dakdemalad, dulemar epenne-dula-gudigusmalad, Moisés, degi, Elías, amar Jesúsmala sunmakgwichi. ");
INSERT INTO cuk09_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Geb degi Pedro Jesúsga sogdesun: —Dummad, we nueddo wegi anmar gudigu. Ar be abegele, anmar wegi obunnoged-neg-gwapaa sobmalodo: Gwagwen bega, baid Moisésga, geb baid Elíasgarmo. ");
INSERT INTO cuk09_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ar amba Pedro sunmakgwichi, mogir mee emar-birgi nagunonikid. Geb agi mogir-imbaba gaka-burba gollalid, sogded: “We An-Machi-sabedi gued, we-machigi yeer an itoged. A-Machi nue be itomar.” ");
INSERT INTO cuk09_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ar Jesús-sapingan degi-gaya-burba itosmargua, yog napase askun sindigar sigidmalad, bela nue-dobe-ito nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Geb degi Jesús na e-sapingan-walik nonisunnad, e-argangi ebunonikid, emarga sogded: —Be gwisgumar, mer be dobgumar. ");
INSERT INTO cuk09_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E-sapingan nono-onakwidmargu, dakdemalad, unnila bato Jesúsbi walagwen gwichi. ");
INSERT INTO cuk09_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jesús na e-sapingan-warbaagwadmala yar-birgi-gwichi aidearmargu, na e-sapinganga ise-sabsur sogded: —Mer bipisaar an-san-gwagsad bemar daksamaladi dulemarga sogmaloye, geb Dule-Machi burgwisar gannar durgusad-sorba, geb be sogmaloye. ");
INSERT INTO cuk09_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Geb degi e-sapingan Jesússe egichiarmarsun, ega sogdemar: —¿Ibiga degite, escribamar sogmarsunna, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-nonikoed-idu, Elías-inse nonigweloye? ");
INSERT INTO cuk09_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús, abin-imakdegu, sogded: —Ar napiragwad, Elías-inse bina nonikoed, bela-dulemar Bab-Dummad-igargi-binsaega nudaknonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ar andi an bemarga soged, Elías bato nonikid. Nonigu, aku-daksa-gusmalad, ar igi na imakbi-gusmala, deyob Elías-imaksa-gusmalad. Amba deyob ani Dule-Machi, amarse odurdaklemogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Geb degi e-sapingan mag itosmalad, Juan-Bautista-nik ega ibmar soged. ");
INSERT INTO cuk09_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesús na-e-sapingan-warbaagwadmala dulemar-bukidar-bukmaladse aidenonimargu, dule-wargwen Jesússe nonikid, yokorgi sindigar abin signonikid, ega sognoni: ");
INSERT INTO cuk09_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Dummad, an-machi wile be dake, an-machi burwa-saar-daed, degine, ani nue odurdaklediid, imbagwenar soogi argwate-daed, imbagwenar digi argwate-daed. ");
INSERT INTO cuk09_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ar be-sapinganga an-machi an senonikinad, be-sapingan anga gwen nudaksasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús, abin-imakdegu, sogde: —¡Bemar Babgi-bengumalad-dulemar, bemar Bab-igar-oakalogedmar! ¿Sanase bemar-abargi an gudiguosunna, bemar mer an-bengumalagar? ¿Sanase mag be itomaloe? Budar an bemar-daked danikid. Machigwa anse be sedamar. ");
INSERT INTO cuk09_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Geb degi machigwa Jesússe senonimargu, Jesús niaga binnasur ibmar sokar, geb agi nia-machigwagi-maid nodsun, geb agi machigwa nugussunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Geb e-sapingan Jesússe bachikii nonigu, ega sokarmalad: —¿Ar ibiga anmardi geg niaburba-onogusmala? ");
INSERT INTO cuk09_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús abin-sogde: —Ar bemar ulubgi amba angi benmarsoggu, a-ular geg niaburba bemar onogusmalad, ar napiraa an bemarga soged, ar bemar wismalad igi mostaza-gwag bur-bipigwa. Ayob-dungu bemar angi bensulir, sunna we-yarga be sogsamalaled: ‘Wegi-siid be weba ainir,’ ar yar ainirisaled. Ar ibmar bela be imakedbiirdo. ");
INSERT INTO cuk09_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","An-emis-nia-onosadgiid, geg dule onoged, unnila mas-gunsuli Bab-Dummadse-goledgi geb bemar sunna wegiid-niamar-onoged. ");
INSERT INTO cuk09_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús Galilea-yargi bipirmakdimaladgi, na e-sapinganga sokalid: —Ani Dule-Machi, dulemarse uklegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Geb agi dulemar an-oburgwemaloed. Ar degite, ibapaagi gannar an durguoed. E-sapingan Jesús-deyob-ega-soge itoarmargu, nue wile-itodmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús na e-sapinganmala Capernaumse modapmalad, dulemar-Bab-Dummadse-goled-negga-mani-wemalad Pedrose nonimalad, ega sognonimalad: —¿Bemar-odurdaked-saila, we Bab-Dummadse-goled-negga-mani-weleged bennuksuli? ");
INSERT INTO cuk09_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro, abin-sogde: —Anmar-odurdaked-saila bennuke. Negse Pedro dogdegua, Jesús-inse ega sunmakalid, ega sogded: —Simón, be dakegua, reymar-we-napnegginmalad ¿doamargi we mani ga-damar be insae? ¿E-sordamargine, igi, dulemar-baigangine? ");
INSERT INTO cuk09_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro, abin-sogde: —E-sordasurmaladgi mani galeged. Jesús Pedroga sogdesun: —Degisoggu, e-sordamardi geg bennuksundo. ");
INSERT INTO cuk09_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ar degi-inigwele, dulemar mer anmargi urwemalagala, mata-dummadse be nae, be ua-sona. Ua gebe-be-sooedi, e-gaya be egaoed, a-e-gaya-yaba be mani-amioed. A-manigi bega, degi, anga, be mani-galeged bennukoed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A-ibagangi, deun Jesús-e-sapingan Jesússe nonimalad, ega sognonimalad: —¿Bab-Dummad-neg-dakmaidgi doa bur-dule-dummadi? ");
INSERT INTO cuk09_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús machi-bipigwad-wargwense gochagua, emar-abargi ogwichisgu, ");
INSERT INTO cuk09_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","sogde: “Napira an bemarga sogmalad, ar bemar machi-bipigwa-daedyob gusulile, Bab-Dummad-neg-dakmaidse geg be dogmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ar degisoggu, doa-dule na san bipii we-mimmigwayob na imakele, ar a-dule Bab-Dummad-neg-dakmaidgi dule-dummaddo. ");
INSERT INTO cuk09_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ar doa-dule an-nuggine we-mimmigwayobid-wargwen ber nue-weligwar abingaele, ar an-abinganaiyob gunaido.” ");
INSERT INTO cuk09_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesús sogdebar: “Ar dule-wargwen akwamu-dummad e-dukargi-nai demar-wilase metemalar, we-dule nue-dummad-wilegoed, ar burgoed. Aba bur-bule, dule nue-dummad-wilegoed, dule-wargwen we-mimmi-burwiganayob angi-bensur-gudidiid iskuega imaksar. Degisoggu, dule-ichoged-iduar, we-dulega bur-nuedirdo akwamu-dummad dukargi-nai burgwed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ibibayobi dulemar we-napneggi-bukmaladga iskana, ibmar dulemar gwage-ichomalad nikagu, degite, ibmar-dule-ichomalad nue abelebalid, degi-inigwele, ¡ar dule emar-gwage-ichodiiddina, adi nue-dummad-wilegodo! ");
INSERT INTO cuk09_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Degisoggu, ar be-argan, igi, be-nag-dibe, be-gwage-ichogega be-imak-dibe, bur be siked nabirid, begi-dikasur-meted be imake, ar bur-nabirsursi, dula gudigued nag-wargwen, igi, argan-wargwen-nika dula gudigued, bur argan-warbo be nikad, igi, mali-warbo be nikad, be soo-saila-geg-berguedse bur melleder. ");
INSERT INTO cuk09_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ar be-ibya be-gwage-ichogega be-imak-dibe, bur ibya be onoge, begi-dikasur-meted be imake, ar bur-nabirsursi, ibya-gwagwen-nika dula gudigued, gwendi, ibya-gwabo-nika bur soo-saila-geg-berguedse melleder.” ");
INSERT INTO cuk09_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús sogdebar: “Nue be salakarmar, mer ibgwensur we-burwigana be dakmalo, ar napira an bemarga soged, ar nibneggi e-angermar an-Bab-nibneggi-maid-walik gudigumalad. ");
INSERT INTO cuk09_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ar ani, Dule-Machi, an nonigu, dulemar-yoggus-gudimalad abonogega an nonikid. ");
INSERT INTO cuk09_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Bemar itogua, ar dule-wargwen dulatar-na-sibad-wawaad-nikad ei wargwen yoggusale, ¿ar dulabake-gakambe-gakabakebakad-obes nadsulir be insae, sibad-wawaad-wargwen-ei-yoggusad, sapurba aminaegar? Aminadele. ");
INSERT INTO cuk09_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“Napira an bemarga soged, ar na amisale, we sibad-wawaad-wargwenadba bur-weligwar itosaled, sibad-wawaad-dulabake-gakambe-gakabakebak yoggussulidba. ");
INSERT INTO cuk09_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Degisoggu, be-Bab-nibneggi-maid, sibad-wawaadyob we-bipigana-wargwensaar ei yoggubisur abemaid.” ");
INSERT INTO cuk09_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesús sogdebar: “Degisoggu, be-gwenad begi nosale, ese be nae, unnila bebo-apinni siidgi nue ega be soge, nue be angi nosye. Ar be-gwenad nabir be-itosale, na be-gwenad be-aiga gannar gunonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","“Ar be-gwenad be-itosulile, dule-wargwen, igi, dule-warbo-dibe beba be nide, adi bela be-ibmar-sogoed, amar-wagab be sogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","“Ar amar-wagab be-gwenad be-itosulile, bela na Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad-abargi be ega ibmar soge, ar amar-abargi amba be-gwenad be-itosulile, dule-Bab-Dummad-wichurmaladyob be we-gwenad-daksunnoed, degine, Roma-dummadga-mani-gaedgi-arbamaladyob be we-dule-dakbaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Napira an bega soged, ar bela we napneggi be-ibmar-sogsadba galenonikile, nibneggi bela galenonimogoed, ar bela we-napneggi be-ibmar-sogsadba igar-egasale, nibneggi bela deyob igar-egalemogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Gannar an bemarga soged, ar bemar-warbo we-napneggi na be-emarbi-binsae Bab Dummadse ibmar egichidele, ar ibu be egisbimala, an-Bab-nibneggi-maid a-ibmar bemarga imakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ar bia bemar-warbo, igi, warbaa an-nuggi ambikunonimalale, an bato bemar-abargi siid.” ");
INSERT INTO cuk09_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Geb degi Pedro Jesússe walikaa gunonikid, ega sognonikid: —Dummad, An-gwenad-angi-nosadga, ¿ilabigwa angi nossulidyob an dakoe? ¿Ilagugledsega? ");
INSERT INTO cuk09_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús abin-sogde: —Unnila ilagugleye an bega sogsulid, an bega soged, dulapaagwad-gakambe-ilagugle be-gwenad begi nossulidyob be dakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús sogdebar: “A-ulale, Bab-Dummad-neg-dakmaiddi, ar rey-wargwen e-maimar-egi-mani-ganikid-ebo igar-nabirogega ese gocha-gusadyobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wargwen-egi-mani-ganikid ese nonigu, dakleardo, talento-mili-ambe egi ganiki. ");
INSERT INTO cuk09_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ar we-dule mani-satedsoggu, geg e-dummad bennuked. A-ular e-dummad ega sogdesun, ‘Be-ome, degi, be-mimmimar, degi, bela be-ibmar-nikad be manigi ukna, adi agi be an-bennukoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Dakargu, a-maide, yokorgi e-dummad-asabin sindigar sii, egi wilenagusad, ega sognagualid: ‘Dummad, mer doga-doga be an-imako. Bela an be-bennukoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ar we-mai-e-dummad, wile na e-mai-dakdegu, a e-maiga sogdesun: ‘Be angi bar mani ganisurdo.’ ");
INSERT INTO cuk09_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ar we-mai, e-dummad-walik-siid nodgu, dule-ebo-arbaed, egi denario-dulatar-mani-ganikid abingualid. A-dule gammuyagi gasgu, ega sogded: ‘Angi be-mani-ganikid, be an-bennuk.’ ");
INSERT INTO cuk09_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Geb agi na-ebo-arbaed, egi wilenagusad, ega sogded: ‘Mer doga-doga be an-imak. Bela an be-bennukoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ar we-dule-ebo-arbaed gwen itobi gussulid. Nade-gusad, eskaryase dule-egi-mani-ganikid-metedapid, bela-egi-mani-ganikid bela e-bennukedse. ");
INSERT INTO cuk09_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ebo-arbamalad deyob daksamargu, bukib binsadmalad, nadmargu, e-dummadga bela sogdapmalad, emar na ibmar daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Geb degi e-dummad dule-egi-mani-gani-gusadse gochad, ega sogded: ‘Mai, be dule-iskana, bela-be-angi-mani-ganikid an bela bega osulosad, ar be angi wilenagusadbar. ");
INSERT INTO cuk09_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ar be geg bebo-arbaed be wile dakmosi, igi wile an be-daksamoga?’ ");
INSERT INTO cuk09_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Geb degi e-dummad uludgu, dulemar-odurdakmaloedga we-mai-iskana-urmaksasun, adi bela-egi-mani-ganikid bela e-bennukedse.” ");
INSERT INTO cuk09_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Geb degi Jesús sogde: “Amba deyob an-Bab-nibneggi-maid bemar-sabsur-imakmarmogoed, ar bemar bela gwagegi na be-gwenad-begi-nosad be ega sogsurmalar: ‘Be angi nossuliyob an be-dakoye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Emi Jesús weyob-ibmar-sogsad-sorba, Galileagi bangudsun, Judea-yalaganba, Jordán-diwar-obakar nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dulemar-bukidar Jesúsba nade-gusmalad, agi dulemar-onudaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Geb agi gwenna-gwenna Fariseomar Jesússe nonimalad, yamo yardaknonimalad, ega sognonimalad: —¿Wede binsa yogsaar sunna ome-meteye igar mai? ");
INSERT INTO cuk09_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús, abin-imakdegu, sogde: “¿Ar bemarde Bab-Dummad-Gardagi absodisurmarsi: Gebesailagi Bab Dummad we-napneg nasikargu, machered ome-ebo abirgunagwar ogwisgunonikid?” ");
INSERT INTO cuk09_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Degi Jesús sogdebar: “Bab-Dummad-Gardagi sognaibalid: A-ulale, machered ome-nikusale, e-babgi, degi, e-nangi banguoye igar maid, adi unnila e-ome-ebo gudiguegar, na ebogwad san-wargwennaga gunonisunnoed. ");
INSERT INTO cuk09_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ar degisoggu, bar na warbomarsursundo, unnila san-wargwennaa gunonimarsundo. Ar degisoggu, Bab Dummad abirgunagwar-dule-imaksadi mer na meted imakmar.” ");
INSERT INTO cuk09_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseomar, Jesús-abin sogdemar: —¿Ar ibiga degite, Moisés igar-mesissunna, ome-meted-garda imakoye ome-metegar? ");
INSERT INTO cuk09_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús, abin-sogde: —Ar bemar-gwage dutusulidba Moisés bemarga igar mesis-gusad, sunna bemar ome-meted-garda imakye, ome-metega, ar iduardi degi-igar-maisulinad. ");
INSERT INTO cuk09_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ar andi an bemarga soged, ar doa-dule ome-mete-dibe, ar e-dikarba-nosardi nabir metodo. Ar degisulirdi, ar ome-baid-nikusale, we-machered ome-dikarba neg-sichigi yolediido. Ar doa-dule, ome-melleded-nikusale, we-dule ome-dikarba neg-sichigi yoledimodo. ");
INSERT INTO cuk09_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","E-sapingan Jesúsga sokarmarsun: —Ar weyob macheredga ome-nikued-sik ega igar maile, mer bur ome-nikued nabir. ");
INSERT INTO cuk09_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Geb degi Jesús na e-sapingan-abin sogde: —Suli, deyobsuli. Ar bela dulemar ome-nikuosurmar-deeye soglesulid, unnila Bab Dummad dulemarga igar-uksamaladga, amardi nabir ome-nikuosur nanamalodo. ");
INSERT INTO cuk09_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ar gwen-gwen gusgu muu-neggi-danikid siamar-baisur-daked, ar gwen-gwen yamo girmar emar-abargi siamar-baisur-daked imaksamalad, ar gwen-gwenbali, siamar-baisur-daked dukin na imaksamalad, Bab-Dummad-neg-dakmaid-ular. Ar dule sunna unni na ome-suli nanao-itogele, we-igar na abingaodo, ome-suli nanaed. ");
INSERT INTO cuk09_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Geb degi Jesússe mimmigan-senonimalad, adi e-argan mimmigan-nonogi mesega, Bab Dummadse ega golega. Jesús-sapingan dulemar-mimmigan-senonimaladse uluarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ar Jesúsdi sogded: —Mer ese urwemar. Mimmigan anse daged be imakmar, mer be bargamar, ar Bab-Dummad-neg-dakmaid we-mimmiganyob-damaladgadid. ");
INSERT INTO cuk09_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ar Jesús mimmigan-e-nono-birgi na e-argan mesisgu, nue nabir egi binsaded, Bab Dummadse ega gochad. Geb a-sorba Jesús nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Geb degi dule-wargwen Jesússe nonikid, ega sognonikid: —Odurdaked-saila-nued, ¿ibi-nued an saer-gebe, burba-geg-bergued an nikuegar? ");
INSERT INTO cuk09_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús, abin-sogde: —¿Ibiga dule-nuedye be anga soge? Dule-nued niksulid, unnila Bab Dummadbi wargwennaa dule-nued gued. Ar burba-geg-bergued be nikubiele, Bab-Dummad-igar-mesisadba be nanaer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dule, abin-sogde: —¿Igid-igarmala? Geb Jesús, abin-sogde: Mer dule-oburgwemalo, mer sui-dikarba, degi, ome-dikarba yolemalo, mer atursamalo, mer gakansaar aimargi sunmakmalo. ");
INSERT INTO cuk09_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Be-babgi, degi, be-nangi nue-binsaed-nikaa damalo. Degine, na be dukin san-sabeyobi, emar be sabgumogo. ");
INSERT INTO cuk09_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sapingwa, Jesús-abin sogde: —Gusgu an sapingwagwad-akar bela we-igarmar-mamaidba an nanadiid. Emidi, ¿ibubi napi-imaked an abesunna? ");
INSERT INTO cuk09_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús, abin-sogde: —Ar ibmar-napiragwadbi-imakdii be nanabiele, be-negse be nae, be-ibmar na be manigi uknae, geb agi mani wileganaga be mimmioed. Geb degiir be nibneggi ibmar-nued be nikuodo. Geb a-sorba anba be dagoed, an-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sapingwa deyob Jesús ega soge itosgu, naibi-ito naded, ar ade dule-mani-ibedid. ");
INSERT INTO cuk09_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Geb degi Jesús na e-sapinganga sogdesun: —Napira an bemarga soged, ibiyobi dule-mani-ibganga Bab-Dummad-neg-dakmaidse-doged igar dutusuli, ar ade dogdar maniginbi binsamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Gannar an bemarga soged, moli-yargan-mureged bur-baisursunna iko-ibyagi doged, ar dule-mani-ibeddi bur-beedse Bab-Dummad-neg-dakmaidse doged. ");
INSERT INTO cuk09_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","E-sapingan, Jesús wegi-soge itosgu, nue geger-ito nadmalad, ar ade mani-ibgan bur-baisursunnaa abonolegoye bimalad. A-ulale, sogdemarsunnad: —¿Ar doa degite, sunna abonolegosunna? ");
INSERT INTO cuk09_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús na e-sapingan-dakdegu, ega sogde: —Ar dulemargardi geg gue, ar Bab Dummadgardi, bela ibmar guedbiid. ");
INSERT INTO cuk09_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Geb degi Pedro, abin-imakdegu, sogde: —Anmardi belagwapa ibmar obesad, adi anmar beba naegar. Degite anmardi, ¿ibu nikumarmogosunna? ");
INSERT INTO cuk09_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús, abin-sogde: “Napira an bemarga soged, Bab Dummad we-ibmar-bela-ogwaoed-ibagangi, ani Dule-Machi, an-olo-gan-yeer-daklegedgi an sigidapir, bemar-anba-nagusmalad olo-gan gwaambe-gakabogwadgi sigmarmogoed, adi Israel-dorgan-sogambe-gakabogwadga igar-nabosii bemar gumalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Ar doa-dule anba-naid-ular ibmar-meter, e-negmar, e-gwenadgan, e-bunmar, e-bab, e-nan, e-ome, e-mimmigan, degine, e-nainumar, we-dule ibmar-dulataledba bur-bule abingaoed, degine, burba-geg-berguedi nikubaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","“Ar dummagan-bukidar dule-sorbarmaladga guoed, degine, dule-sorbarmalad dummaganga gunonimogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús sogdebar: “Ar Bab-Dummad-neg-dakmaid weyobdo: Dule-wargwen, na neg-uya-sediid, wakudar neggi nodgua, dule-ega-arbamalad-aminaddo, adi e-nainugi ega arbamalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dule-nainu-ibed arbamalad-ebo na igar nabosmargu, arbamaladga sogsado, denario-irgwen ibagwengi an be-bennukoye. Geb agi e-nainuse ega arbaega barmissundo. ");
INSERT INTO cuk09_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Dad-abar-dummad gusgu, gannar nainu-ibed, nodbardo, dakdapdo, ibmar-ukleged-naba dulemar binsa bukmala, arbaed-suli. ");
INSERT INTO cuk09_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nainu-ibed amarga sogdedo: ‘Ar bemar an-nainuse arbanamarmo, ar sogedba an bemar-bennukmaloed.’ Amar nade-gusmalad, arbanad-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“Yorukugusgu, nainu-ibed dulemar-amiega gannar nodbar. Dulemar-amisgu, e-nainuse barmis, ega arbamalagar. Wachi-ilapaagi, amba deyob imaksabalid, degine amarga baiganga-sogsadyob sogsabalid. ");
INSERT INTO cuk09_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wachi-ilatargi, nainu-ibed gannar nodbalid, dulemar-dakdapid, arbasuli bukmala. Amarga sogded: ‘¿Ar ibiga bemar arbasuli emi be osedosmala?’ ");
INSERT INTO cuk09_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Abin-imakdemalad: ‘Ar dule anmarga arbaed-uksurmalad.’ Nainu-ibed amarga sogde: ‘Bemar an-nainuse arbanamarmo, ar sogedba an bemar-bennukmaloed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Neg-mutikudgu, nainu-ibed, ega-neg-dakedga sogded: ‘Arbamaladse be gole, be bennuk ibagwen-arbasad-wilub. Napisolaba-modapmalad-inse be bennuko, geb degi, wakudar arbadmaladse.’ ");
INSERT INTO cuk09_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Napisolaba-arbadmalad nonimargu, bennuklesmalad, denario-irgwen. ");
INSERT INTO cuk09_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Gebe-arbadmalad warmaksagu, binsadmar, emardi bur-melu bennuklegoye. Ar amar bennuklearmargu, amba denario-irgwen bennuklesmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","“Gebe-arbadmalad bennuklesmargu, nainu-ibedgi uluarmalad, ");
INSERT INTO cuk09_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","sogdemalad: ‘Wemar-sorba-nonimalad, unnila wachi-irgwen arbasmalad, anmardi bur-dummad arbasad, dadba dummad gal-itosad, degite, anmar-sunnaa bennuklesmarmogad.’ ");
INSERT INTO cuk09_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Nainu-ibed, amar-wargwen abinsadgu sogde: ‘An-ai, an gwen begi dodossulid. ¿Ar bemarbo igar an nabossursi, denario-irgwen an be-bennukoye? ");
INSERT INTO cuk09_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Degisoggu, ar begadid na be sue, be nae, ar wemar-napisolaba-nonimalad bemar-sunnaa an bennukbiele, an itolegeddo. ");
INSERT INTO cuk09_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ar wede igar-nabirsursi, an-itolegedba an-mani an imakbier? ¿Ar angi be nobsi, an dule-nued-daedba?’ ");
INSERT INTO cuk09_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Degisoggu, dummagan dule-sorbarmaladga guoed, degine, dule-sorbarmalad dummaganga gunonimogoed. Ar ade bukidar dulemarse gollesad, degite unnila ichee wis dulemar sulegaled.” ");
INSERT INTO cuk09_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalénse nadapmargu, Jesús na e-sapingan-ambe-gakabogwadse bachikii gochad, amarga sogded: ");
INSERT INTO cuk09_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Emi anmar Jerusalénse nadapid, Ani Dule-Machi, dule-irwa-Bab-Dummadse-gormalad-e-dummaganga, degi, escribamarga uklegoed. Amar anga igar-itosmalar, sogmaloed, oburgwemarye. ");
INSERT INTO cuk09_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Wemar-Judio-dummagan Judiosurmaladga an-ukmaloed, adi angi dodomalagar, an-bibyomalagar, degi, nakrusgi an-biokmalagar. Ar degi-inigwele, ibapaagi gannar an durguoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Geb degi Zebedeo-machimala-e-nan, Jesússe na e-machimalamala nonimar, yokorgi sindigar abin signonigu, Jesússe ibmar egisnonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús ega sogde: —¿Ibu be abege? Ome, abin-sogde: —Na be neg-dakmai-gusale, we an-masmala-warbogwad dummaganga be nugsao, gwensak be-argan-nuedsik-siged, baid be-argan-sapiledsik-siged. ");
INSERT INTO cuk09_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús, ome-abin imakdegu, sogde: —Ibmar bemar egisnanaid, bemar wichurmalad ibu be egisnanai. ¿Ar nue dummad-an-wilegoedgi sunna bemar wilemogosi, an nog-goboedyob? Degine, ¿an digi-ogaledgi sunna bemar oglemogosi? Emar, abin-imakdemargu, sogdemar: —Anmar sunnamala. ");
INSERT INTO cuk09_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús abin-sogde: —Ar bemar sunnamarsoggu, napira an bemarga soged, bemar anyob nue-dummad naibi-itomarmogoed. Ar dummaganga-nug-imakeddi, adi ani, an nug-saosulid, unnila Bab Dummad bato na-igar-mesisadba na e-nug saoed dulemar-dummaganga guoe. ");
INSERT INTO cuk09_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesús-e-sapingan-e-ambedi itosmalad wemar-warbogwad dummadga gubimalad. Degisoggu, wemar gwenad-warbogwadgi uludmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Geb degi Jesús e-sapinganse gochagu, amarga sogde: “Bemardi nue wismalad, dulemar-we-napneg-dummaganga-gudimaladdi e-sordamarba bur-dule-dummad na san-imak-daed, degisoggu, bela ega ibmar imakbi abe-damarsunnad. Degine, e-sorbarmalad gandikidba dulemar-barmidaed. ");
INSERT INTO cuk09_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“Bemardi mer deyob gumalo, ar be dummadga gubiele, maiyob bela be dulemar-bendaker-gebed. ");
INSERT INTO cuk09_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ar be dulemar-iduedga gubiele, bela dulemar maiga be guer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","“Ar ani Dule-Machi, we-napnegse an nonigu, mai-nikuega an nonisulid, maiyob dulemar-bendakega an nonikid, degine, an na-san-burba-ukegar, adi dule-iskudimalad-anar an burgwegar.” ");
INSERT INTO cuk09_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús na e-sapinganmala Jericó-neggweburgi noarmargu, dulemar-bukidar eba armalad. ");
INSERT INTO cuk09_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Deun, dulemar-warbo ibya-surmalad, igar-dikarba-simalad itosmargu, Jesús nadapye, binnasur Jesússe gotemalad, sogdemalad: —¡Dummad, Rey-David-wagwa, anmar-bendake, wile be anmar-dake! ");
INSERT INTO cuk09_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dulemar ese uluarmalad, adi boo sigmalagar. Ar bur-bule dulemar-ibya-surmalad binnasur Jesússe gotemalad, sogdemalad: —¡Dummad, Rey-David-wagwa, wile be anmar-dake! ");
INSERT INTO cuk09_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús, ibya-surmalad-itosgu, geb gwisgusad. Amarse gochagu, amarga sogde: —¿Ibu bemarga imakbi be an-abesunna? ");
INSERT INTO cuk09_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Dulemar-ibya-surmalad sogdemalad: —Dummad, mag-atake be anmar-imake. ");
INSERT INTO cuk09_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Geb Jesús amar-wile-dakdegu, amar-ibya-ebus, geb degi amar yog ibya nuguar nadmalad. Wemar-warbo ibya nugusad Jesúsba nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús na e-sapinganmala Jerusalén modanimargu, Olivos-yar-dikarba, Betfagé-neggwebur-walik-gusgu, Jesús na e-sapingan-warbo-barmisad, ");
INSERT INTO cuk09_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","amarga sogsad: —Neggwebur-bipii anmar-asabin-siidse be namar. Agi bemar dakdapoed, moli-uaya-suid atinnar nai, na e-mimmi e-dikarba gudii. A-moli bemar esikoed, geb degine a-molimar be anse sedamaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ar dule-wargwen bemarga akar sokalile, bemar sogmaloed: ‘Ar Dummad wedi bina-soged, ebusad-sorba bega yog gannar barmidabaloye soged.’ ");
INSERT INTO cuk09_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ar we deyob bela we-ibmar-gusadi, igi Bab-Dummad-gaya-burba-berbeged sogsa-gusa, adi deyob guegala gunonikid, deun sogsa-gusgu: ");
INSERT INTO cuk09_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Siongi-bukmaladga be soge: “Emi, be-Rey bese danikid, Na gwage eikwaa, moli-uaya-suid-birgi sii, Moli-uaya-suid-e-mimmi-birgi sii, Moli-uaya-suid ibmar-berbeged-e-mimmi-birgi-sii bese danikid.” ");
INSERT INTO cuk09_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesús-sapingan-warbogwad nadmarsunnad, Jesús ega igi sogsa, deyob imakdapmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jesús-sapingan moli-uaya-suid, degi, e-mimmi, Jesússe senonimarsunnad. Geb degi a-moli-birgi na e-mormar ogichamargu, a-birgi Jesús sigisad. Jesús moli-birgi sigisgu, Jerusalénse nadsun. ");
INSERT INTO cuk09_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dulemar-bukidarad, na e-mor igargi Jesús-iduar ogitemalad, abala ogob-gagangiid-e-gagan gwane-gwane imakdemargu, Jesús-iduar igargi ogitemalad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ar dulemar-bukidar-idu-nadapmaladi, degi, sorba-danimaladi, binnasur gornadapmalad, sognadapmalad: ¡Bab-Dummad-nug odummomar! ¡We David-Wagwa! ¡We, Bab-Dummad-nuggi-danikid, bela ega ib-nuedga guena-gadin! ¡Nibneggi e-nug odummomarbar! ");
INSERT INTO cuk09_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús Jerusaléngi dogdapgu, bela Jerusalénginmalad oimakdemalad, sogdemalad: —¿Wede doasunna? ");
INSERT INTO cuk09_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Dulemar-bukidarad-Jesúsba-danimalad sogdemalad: —We-dule, Jesús, Bab-Dummad-gaya-burba-berbeged, Nazaret-neggweburgined, Galilea-dola. ");
INSERT INTO cuk09_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús Bab-Dummadse-goled-negse dogdapgu, bela dulemar-ibmar-baknanaid, degi, ibmar-ukbukmalad sabsur onisad, degi, dulemar-mani-ogwabukmalad-e-mesa binnasur barbikiin meted, degi, dulemar nuu-ukbukmalad-e-gan barbikiin-metebalid. ");
INSERT INTO cuk09_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús amarga sogded: —Bab-Dummad-Gardagi narmarkar naid: Bab Dummad soged: ‘An-nega, anse-goled-negye nugguoed.’ Is. 56:7 Ar emigindi bemardi atursamalad-negga imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús Bab-Dummadse-goled-neggi siidgi, dulemar-ibya-surmalad, degi, dulemar-nue-geg-nanamalad ese nonimalad. Jesús amar bela-nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Deginbali, burwigana-bukidar Bab-Dummadse-goled-neggi oimakbukwad, sogbukwad: “¡We-David-Wagwa, e-nug odummomar!” Ar dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar Jesús-ibmar-dakledisulid-imaknai-dakedba, degine, machimala-oimakbukwa-itosmaladba, sae-itodmalad, Jesúsgi uludmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Amar Jesúsga sogdemalad: —¿Be itoge burwigana ibmar sogbukmalad? Jesús, abin-sogde: —Eye, an itoge; ¿Ar bemar Bab-Dummad-Gardagi absodisurmarsi? Burwigangi, degi, amba mimmigan-nunanaidgi, Amar-sunmakedgi be-nug-odummoged be imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesús agi nadgu, Judio-dummagan-mete-naded, neggweburgi nade-gusad, Betaniase. Geb agi megidapid. ");
INSERT INTO cuk09_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Oibosgu, Jesús wagdar Jerusalén-neggweburse gannar danigu, ukur itoalid. ");
INSERT INTO cuk09_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Igar-dikarba higuera-sapi-gwichi dakargu, ese nade-gusad. Ese modapgu, san sate dakalid, unnila e-gaganbi nika. A-sapiga Jesús sogdesun: —Be bipisaale bar gwen durbamakosulid. Agi higuera-sapi dinguded. ");
INSERT INTO cuk09_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jesús-e-sapingan higuera-sapi dingud-gusad daksagu, geger dakdemalad, sogdemalad: —¿Ar wede ibiga gwae-gwae higuera-sapi dingude? ");
INSERT INTO cuk09_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús, abin-imakdegu, sogded: —Napira an bemarga soged, ar bemar ibmar-imaknaid nue bensulile, unnila we-sapi-higuerabi deyob bemar imaksasuliled, ar sunna we-yarga be sogsamalaled: ‘Wegi be siid be ainir, demarse be nae,’ ar bemar-sogedba gusaled. ");
INSERT INTO cuk09_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ar bela be nue-bensuli Bab-Dummadse-goledgi be egisele, ar be-ibmar-egised abingaodo. ");
INSERT INTO cuk09_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús Bab-Dummadse-goled-negse nonigu, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan Jesússe warmaknonimalad, ar edi na odurdaksigu, ega sogdemalad: —¿Doa-nuggine-wede be we-ibmar imakdii? ¿Ar doa bega gangued uksasunna? ");
INSERT INTO cuk09_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús, abin-imakdegu, sogde: —An bemarse ibmar-soggwen egismogodo. Bemar an-abin imaksale, geb an bemarga sogmogoed, we doa gangued anga uksa we-ibmar an imakdiid. ");
INSERT INTO cuk09_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Juan-Bautista, Bab-Dummad-digi-ogleged imaksad, we, ¿bia daniki? ¿We, Bab Dummad barmiali, igi, we, dulemar barmiali? Anga be sogmalana. Degi, Judio-dummagan muchub-muchub na sogdemalad: “Bab Dummad barmiarye, anmar sogmalale, anmarga sogdagoed: ‘Degite, ¿ibiga bemar Juan-Bautista-bengusmarsunna?’ ");
INSERT INTO cuk09_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Dulemar barmiarye anmar sogbalile, anmarse neggwebur urwedagoed. Ar ade bela sogmalad, ‘Juan-Bautista, Bab-Dummad-gaya-burba-berbeged-sunnadye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Degisoggu, Judio-dummagan, Jesús-abin sogdemarsun: —Anmar wichurmar, doa Juan-Bautista-barmiali. Degi Jesús, abin-imakdemosun: —An bemarga sogosurmarmodo, wede doa-nuggi we-ibmar an imakdii. ");
INSERT INTO cuk09_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús Judio-dummaganga sogde: “Degite, ¿Be itomalana? Dule-wargwen machimala na warbo nikado. A-dulede e-machi-wargwenga sogdo: ‘Machi, an-nainuse be arbana, uva eminao.’ ");
INSERT INTO cuk09_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Machi, e-bab-abin imakdegu, sogded: ‘Yapa an nae.’ Ar sorba, bukib itoargu, na nade-gusdo, arbanaddo. ");
INSERT INTO cuk09_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bab na machi-baidse nadbardo, ega amba deyob sogdapbardo: ‘An-nainuse be uva eminao.’ E-machi e-bab-abin sogde: ‘Baba, eye, an arbanao.’ Ar degite, we-machi nadsurdo, arbanadsurdo.” ");
INSERT INTO cuk09_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jesús Judio-dummaganse egisdesun: —¿We-masmala-warbogwad, doa bur e-bab-sogedba ibmar imaksa be insae? Abin-sogdemar: —Machigwa arbaapid. Jesús emarga sogde: —Deyobdo. Ar napira an bemarga soged, dulemar-Roma-dummadga-mani-gaedgi-arbamalad, degi, omegan-gamba-samalad, amar bur bemarba Bab-Dummad-neg-dakmaidse dogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ar bemarse Juan-Bautista igar-napiragwadgi sunmaknonimar-inigwele, bemar eba ib-imaksasurmalad, ar Roma-dummadga-mani-gaedgi-arbamaladdi, degi, omegan-gamba-samaladdi e-sogsad bengussurmalad, ar bemar wemar-daksamarmo-inigwele, degite, be-iskuedga gwen bukib be itossurmalad, gwagegar, adi bemar we-igar abingamogagar. ");
INSERT INTO cuk09_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús Judio-dummaganga sogdebar: “Bemar itomarbalina, igar-burbar-baid maid: Ibagwengi dule-wargwen, na neg-uya sediid, uva na nainugi digsado, ber ebilis e maksado, agi, abargi uva-egured sobsabardo, geb degi galu sobsabardo, adi agi bela nainugi nakulegegar. Nainu-ibed dulemar-arbamaladga na e-nainu urmaksado, adi a-dulemar nainugi uva wealir, e-ibedga wis ukmogoye, na deyob ebo igar mesismardo. Nainu-ibeddi dikasur neggwebur-baidse nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Uva-weed-ibagan mosgu, nainu-ibed na e-maigan nainugi-arbamaladse barmialid, adi uva na egadid suegar. ");
INSERT INTO cuk09_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ar nainugi-arbamaladdi, nainu-ibed-e-maigan ese nonimargu, gwensak sarsosmalad, baiddi oburgwismalad, degi baiddi akwagi maksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A-sorba nainu-ibed na e-maigan-baigan bur-melu barmiarsunnad, ar amba deyob imaksamarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Nainu-ibed napisolaba na e-machi-barmiarsunnad, ar ade binsaded: ‘An-machisoggu, egi-binsaed-nikaa-damaladba gwen oakalogosurmar an insaye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ar nainugi-arbamalad, nainu-ibed-machi dani dakarmargu, na ega sogdemalad: ‘We-dule-danikidi e-bab burgwisar, nainu bela egadbi guoed. Degisoggu, dagmar, we-machi oburgwemarsun, adi anmar ei-nainu suegar.’ ");
INSERT INTO cuk09_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Machigwa-gasmargu, nainu-dikarba metemalad, geb degi oburgwismarsunnad.” ");
INSERT INTO cuk09_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesús Judio-dummaganse egisdesun: —Ar nainu-ibed na e-nainuse nonikir, ¿igi nainugi-arbamalad-imaknoni be insae? ");
INSERT INTO cuk09_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesús-abin sogdemar: —Ar nainu-ibed nonikogu, bela nainugi-arbamalad-iskanamar-sabsuli-oburgwenonikoed. Na e-nainu, baigan-arbamaladga urmaknonikoed, adi amar na iba-sekalaa e-uva ega ukmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ar Jesús na ede akwa-nuedyobsoggu, a-ular Judio-dummaganga sogdesun: —¿Ar bemarde Bab-Dummad-Gardagi absodisurmarsi? Bab-Dummad-Garda soged: Dulemar-neg-sobmalad-akwa-istar-daksamalad, a-akwa, akwa-sunsogedga bur gunonikid. ¿Ar weyob Bab Dummad akwa imaksad, ar anmarde geger dakde? ");
INSERT INTO cuk09_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Degisoggu, an bemarga sogmar, Bab-Dummad-neg-dakmaid, bemargadid, be-annik sulemaloed, dulemar-baigan-nabir-ibmar-nuegan-imakmaloedga uklegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ar dule-wargwen we-akwa-nuedgi argwachale, we-dule bibiskoed. Ar we-akwa dulegi argwachardi, adi, we-dule ese ubigwar guoed. ");
INSERT INTO cuk09_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesús we-igar-burbar-sunmaklemaladgi sunmaksad, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Fariseomar mag itosmalad, we emargi sunmaked. ");
INSERT INTO cuk09_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ar amar, Jesús-gabi-guarmalan-inigwele, geg oakalosgusmalad, ar ade neggwebur-dobmalad. Ar neggweburde we-Jesús Bab-Dummad-gaya-burba-berbegedye nik sogmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús, gannar igar-burbar-maidgi sunmakdebargu, Judio-dummaganga sogdebalid: ");
INSERT INTO cuk09_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bab-Dummad-neg-dakmaid weyobdo: Rey-gwensak na e-machi ome-nikued-ibagi mas-gunned-dummad onodaedyobdo. ");
INSERT INTO cuk09_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rey na e-maigan-barmisad, dulemar-ibase-nonimaloedse gornaegar, e-machi ome-niku-sokalid e-ibase dagegar. Ar ese-gollesmalad gwen ibase nonisurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Geb agi rey e-maigan-baigan-barmisbalid, ega sogsad: ‘Dulemar-ibase-danimaloedga sogo: Emi wegine, guagwar bemarga an mas imaksamar, molimar, degine, ibmar-unimalad-gwallu-ibegan an bemarga oburgwismar, bato bemarga guagwar bukwad, degisoggu mer ikumalo, ibase dagmalo.’ ");
INSERT INTO cuk09_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ar ese-gollesmalad bai gwen itossurmar, gwensak e-nainuse arbanad, baiddi ibmar-uked-negse ibmar-uknaded. ");
INSERT INTO cuk09_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ar baiddi, rey-e-maigan-sarsosgu, oburgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Rey wisguargu, ese-gollesmalad deyob e-maigan-imaksamarye, nue sae-itoded, na e-sordamar-barmisad, bela e-maigan-oburgwismalad-ogilosad, geb degi bela a-neggwebur ogumaksasunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Geb degi rey e-maiganga sogded: Dulemar-ibase-dagega-ese-gollesmalad ega igar-gwen-maisulid ibase dagegar. ‘Ar an-machi-ome-nikued-ibagi mas-gunned bato guagwarsoggu, ");
INSERT INTO cuk09_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","bemar namarsun, igargan-mamaidba, ar agi bemar dulemar-dakalir, ese be gormalo, mas-gunned-ibase dagmalagar.’ ");
INSERT INTO cuk09_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Rey-maigan igarganba nadmargu, dulemar-abingusmalad bela amarse gochamalad, dulemar-nuegan, degi, dulemar-iskanamarse-bakar. Ome-nikued-ibagi-mas-gulleged bela engussunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Rey mas-gunned-ibase dognonigu, dulemar-nonimalad-daknonikid. Agi dakalid, dule-wargwen ome-nikued-ibagi-mor-yoleged-e-mor yoisuli. ");
INSERT INTO cuk09_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Rey a-dulega sogded: ‘An-ai, ¿igi wegi be dogsa, ome-nikued-mor-yoisuli?’ Dule gwen abin-imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Geb degi rey e-maiganga sokarsun: ‘We-dule-e-argan, degi, e-mali edinmar, magaba neg-sichidgi metemar, agi dummad-na-wilesiidbali bosii-guoed, degi, nugar-gorsii-guoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ar Bab Dummad bukidar dulemarse gochad, degite unnila ichee wis sulesmalad.” ");
INSERT INTO cuk09_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesús sunmaked bergusgu, Fariseomar nadmalad, na igar amiarmalad, igi-saele e-sunmakedgi anmar Jesús-gao-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Degisoggu, Jesússe Fariseomar na e-sapingan-barmisad, Herodianomar-abargi. Jesússe nonimargu, ega sogdemalad: —Odurdaked-saila, anmar be-wisdo, be dule-ibmar-napiragwad-soged-duled, igar-napiragwadba Bab-Dummad-igar be odurdaked, degine, baisur be itoged igi dulemar begi binsae, ar ade begardi emarbi dulemar be daked. ");
INSERT INTO cuk09_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Degisoggu, anmarga be sogena, emide, ¿we igar-nuedi, Roma-Dummad César-nugad anmargi-mani-gaed bennuked? ¿Anmar bennukoe, igi, anmar bennukosuli? ¿Igi be sogmosunna? ");
INSERT INTO cuk09_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ar Jesúsdi wemar-egi-istar-binsananaid mag daksoggu, amarga sogded: —¡Bemar wagar-darbo-damalad! ¿Ar ibiga bemar yamo an-wilubdakdanimala? ");
INSERT INTO cuk09_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mani Roma-dummadga-ukleged anga be oyogena. Jesúsga denario-gwagwen oyoarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Geb degi Jesús amarga sogde: —¿Ar wede we-manigi doa-wagar-wilub sisunna, degine, doa-nug narmakar naibarsunna? ");
INSERT INTO cuk09_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jesús-abin sogdemalad: —Roma-Dummad-César, a-wagar-wilub, degi, a-nug narmakarbalid. Geb degi Jesús sogdesun: —Ar ibmar Césargadir, Césarba be ibsamardo. Ar ibmar Bab Dummadgadirdi, Bab Dummadba be ibsamardo. ");
INSERT INTO cuk09_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dulemar-Jesússe-ibmar-egisnonimalad weyob Jesús ega soge itosmargu, geger abin-itodmalad. Geb degi emardi Jesúsgi bangudmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Amba a-ibagi Saduceomar Jesússe nonimalad. Amarde sogmalad, dule burgwisale, gannar geg bar durguye. Agala Saduceomar Jesússe we-igar egichiarmalad, ");
INSERT INTO cuk09_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ega sogdemalad: —Odurdaked-saila, Moisés sogsa-gusdo: Ia mimmi-nikussuli ome-idu burgwisale, E-urba a-ome-nikuoye, Adi e-iaga anagan-urbegar. ");
INSERT INTO cuk09_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Anmar-abargi machimala e-gwenadgan-walagugle-na-gumaladi weyob gusdo. Ia-dummad ome-nikusgu, anagan-urbissuli burgwisdo. A-sorbalid a-ome-nikunonimogu, ");
INSERT INTO cuk09_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","amba e-iayob mimmi-nikussuli burgwismodo. Geb degi a-sorbalid amba a-ome-nikunonimogad. Deyob bela e-walagugled a-ome-nikusmaladbiid, anagan-gwen-obessuli bela burgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Geb a-sorba ome burgwismosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Ar dule-gannar-durguoed-iba nonikile, a-omede, ¿wede doa-omega guosunna, ar bela na e-gugle nikusmaladbiid?” ");
INSERT INTO cuk09_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Geb Jesús, Saduceomar-abin imakdegu, sogded: “Bab-Dummad-Garda-narmakar-maid wichulidba, degi, Bab-Dummad-gangued wichulidba, bemar noar sogmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ar ade dulemar gannar-durgued-ibagi ome-bar-nikuosurmalad, degine, gannar ome sui-nikunai bar guosurmogad, ar ade dulemar Bab-Dummad-angermar-nibnegginmaladyob gumaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jesús Saduceomarga sogde: “Dule-burgwismalad-gannar-durgued-igarde, ¿ar bemarde Bab-Dummad-sogsad absodisurmarsi? Bab Dummad sogsa-gusad: ");
INSERT INTO cuk09_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ani an Abraham, Isaac, degi, Jacob, amar e-Bab-Dummad. Ex. 3:6 Degisoggu, Bab Dummad, dulemar-burgwarmalad-e-Bab-Dummadsulid. Bab Dummad, dulemar-dula-gudidimalad-e-Bab-Dummadid. Ar Abraham, Isaac, degi, Jacob, amar burgwismar-inigwele, Bab Dummadgardi amba dula gudidimalad. Degisoggu, bemar nue noar sogmardo.” ");
INSERT INTO cuk09_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ar dulemar Jesús weyob soge itosmargu, geger itodmalad, we-Jesús weyob dulemar-odurdakdiid. ");
INSERT INTO cuk09_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Degi, Fariseomar wisguarmargu Jesús nue Saduceomar-abin imaksaye, Fariseomar na igar-amiarmarsunnad, Jesús-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fariseo-wargwen, Moisés-igar-nue-wisidi, Jesússe egichialid, yamo wilubdakegar: ");
INSERT INTO cuk09_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Odurdaked-saila, Bab-Dummad-igar-maidgi, ¿igid bur-igar-biriginedi? ");
INSERT INTO cuk09_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús, abin-sogde: “Dummad, Be-Bab-Dummad, bela be-gwagegi be sabguoed, bela be-san-burbagi, degi, bela be-binsaedgi. ");
INSERT INTO cuk09_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ar dule Bab-Dummad-sabgued, we-igar gebeddo, degi, bur igar-dummadbardo. ");
INSERT INTO cuk09_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Agi, igar-sogbogi, amba deyobsaarbardo: Ar na be-san na be sabguedyobi, dule-baid be sabgumogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ar wemar-igar-warbogwadgi, bela igar-baigan-mamaid, degi, Bab-Dummad-gaya-burba-berbemalad-sunmaksamalad, ase bergusiid.” ");
INSERT INTO cuk09_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseomar-danar-bukwadse Jesús ese egichialid, ");
INSERT INTO cuk09_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ega sogded: —¿Cristogi bemar igi binsamarsunna? ¿Wede Cristo doa-wagwa-sunna? Abin-sogdemar: —Rey-David-wagwa. ");
INSERT INTO cuk09_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús amarga sogdesun: —¿Ar degite, ibiga Bab Dummad Burba Nuedba David Cristoga sogsunna, ‘An-Dummadye,’ deun soggu? ");
INSERT INTO cuk09_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Bab Dummad an-Dummadga soged: ‘An-argan-nuedsik be sige, be dule-dummadga guegar, bela be-istarmaladgi-nakwedse an be-imakedsegad.’ ");
INSERT INTO cuk09_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ar David Cristoga soged, ‘Be an-Dummadye.’ Degite, ¿Cristo igi e-wagwaga gubarsunnoe? ");
INSERT INTO cuk09_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ar dule-wargwensaar Jesús-gwen-abin imaksasurmalad, degine, bipisaar dule ese ibmar gwen a-ibagi bar egisbi itossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Geb degi Jesús dulemar-bukidaradga, degi, e-sapinganga sunmakde, sogded: ");
INSERT INTO cuk09_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Fariseomar, degi, escribamar Moisés-igar-mamaid nue-wisi gandikidba odurdakmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ar degisoggu, Fariseomar bela bemarga Moisés-igar-maid-sogmaladba be damar, degi, eba be imakmarbar. Ar Fariseomar-damaladbardi mer be damalo, ar ade unni nabir sogmalad, imakeddi eba geg imakmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ar wemar-Fariseomar dulemarga beedse-dutusur igar-mesmalad. Ar degite emar dulemar-gwen-bendaksurmalad igar-mesisadba dulemar nanamalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ar Fariseomardi bela ibmar-imakmalad yamo dulemar e-dakmalagar. Degine, amardi bebegi, degine, sakwagi Bab-Dummad-Garda-saboged-sagu nasik-damalad, degine, e-mor-duku-durbamakarmalad osuosmalad, adi dulemar egi binsamalagar, emarde dule-nueganye. ");
INSERT INTO cuk09_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“We-Fariseomar ibagi mas gullealir, dummagan-gan-sigedginbi sigbi-damalad, degine, Judiomar-onmaked-neggi dummagan-gan-sigedginbi sigbi-damarbalid, ");
INSERT INTO cuk09_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","We-Fariseomar yeer itodamalad ibmar-ukleged-neggi dulemar bela ese goledbimalar, degine, yeer itodamalad, dulemar ese goled, odurdaked-sailaye. ");
INSERT INTO cuk09_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ar bemardi bese gorbisur be abemalad, odurdaked-sailaye, ar bemargardi unnila wargwennagwad bemar-odurdaked, Cristo, degine, bela bemar na-gwenadgan gumalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","We-napneggi mer dulemar-baiganga an-babye be sogo. Ar unnila wargwennaa be bab-nikmalad, be-Bab-nibneggi-maid. ");
INSERT INTO cuk09_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mer odurdaked-sailaye, na be bimalo, ar unnila be-odurdaked-saila wargwennaa gued, Cristo. ");
INSERT INTO cuk09_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","“Ar bemar-abargi bur-dummadidi, a bela-bemar-maiga guoed. ");
INSERT INTO cuk09_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ar ade dule-wargwen na nug dummarba na saele, a-dule-nug bur-bipii guoed. Ar dule na nug bipii na saerdi, adi a-dule-nug bur odummolegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Ar bemardi, escribamar, Fariseomar na be dule-wilesmar, wagar-darbo be damalad! Ar bemar Bab-Dummad-neg-dakmaidse dulemar-dogbimalad-idu yawagak be edidimalad, ar bemar ase dogsurmalad, degine, dulemar-ase-dogbimalad gwen dogega be imaksurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Bemar escribamar, Fariseomar, na be dule-wilesmar, wagar-darbo be damalad! Ar bemar yamo yardakar ammamar-ei-sui-burgwismalad-ibe neg atursa-damalad, degine, dulemar yeer bemar-dakegala yamo suitii Bab Dummadse bemar gorgwis-damalad. A-ular bemar bur-bule sabsur odurdaklemaloed, deyob bemar damaladba. ");
INSERT INTO cuk09_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Bemar escribamar, Fariseomar na be dule-wilesmar, wagar-darbo be damalad! Ar bemar demar, degi, yar bela be ebirdimalad, dule-wargwen-e-gwage ogwaegar, bemarba naguegar. Bemarba nagusale, aka be ilabo bur-bule soo-sailagi-odurdaklegoedga be imakdimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Ar bemar dule-wilesmar, bemar dulemar-idumalad-ibya-sulidmalad! Emi bemar soged: ‘Ar dule-wargwen sogsa-dibe Bab-Dummadse-goled-neg-nuggi napira an bega sogye, an ibmar saoye. Gwen akarsulid, degi-sogsadba ibmar-imaksulir. Ar dule Bab-Dummadse-goled-neggi-or-siid-nuggi, adi degi-sogsardi, degi-sogsadba saer-gebed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","“¡Bemar binsaed-gwen-niksurmalad, ibya-sulidyob be damalad! Ar igid bur-sunsogedsunna, ¿or bur-sunsogedi, igi, Bab-Dummadse-goled-neg bur-sunsogedi. Ar Bab-Dummadse-goled-neg or swilidikidga imaksursi? ");
INSERT INTO cuk09_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ar bemar sogmarbalid: ‘Dule-wargwen sogsa-dibe: Bab-Dummadga-ibmar-gummakar-ukleged-galu-nuggi napira an bega sogye, an ibmar imakoye. Degi sogsadba imaksasulir, gwen akarsulid. Ar dule Bab-Dummadga-ibmar-ukleged-nuggi degi-sogsardi, adi na degi-sogsadba eba saer-gebye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","“¡Bemar binsaed-gwen-niksurmalad, ibya-sulidyob be damalad! Ar ade igid bur-sunsogedsunna, ¿Bab-Dummadga-ibmar-gummakar-ukleged-galu, igi, we-ibmar a-birgi mesleged? ¿Ar Bab-Dummadga-ibmar-gummakar-ukleged-galu ibmar swilidik imaksursi? ");
INSERT INTO cuk09_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ar ade dule Bab-Dummadga-ibmar-ukleged-galu-nuggi sogsale, napira an bega sogye, an ibmar imakoye, a-dule bato Bab-Dummadga-ibmar-gummakar-ukleged-galu-nuggine degi-sogsadi ¿bela agi ibmar-ambikued eba galesmosursi? Bela eba galesmoga. ");
INSERT INTO cuk09_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Ar ade dule Bab-Dummadse-goled-neg-nuggi sogsale, napira an bega sogye, an ibmar imakoye, ar a-nuggi, degi, Bab-Dummad-a-neg-yaba-maid-nuggi bato sogsabalid, napira an bega sogye, an ibmar imakoye. ");
INSERT INTO cuk09_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ar dule nibneg-naid-nuggi sogsale, napira an bega sogye an ibmar imakoye, bato Bab-Dummad-e-olo-gana-siged-nuggi sogsado, degine, Bab-Dummad-a-ganagi-siged-nuggi sogsabardo. ");
INSERT INTO cuk09_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Ar bemar escribamar, Fariseomar, na be dule-wilesmar, wagar-darbo be damalad! Ar bemar ibmar-burwiganase-bakar menta, eneldo, degi, comino ambegi-gwensak Bab Dummadga be ukdimalad, ar degite bur-ibmar-sunsoged, Moisés-igar-maidgi igar-maid: Dulega igar-nudaked, dulemar wile-daked, degi, nue-inikii nanaed, amardi gwen be imakdisurmalad. Ar wemar bemar imaked nabirid, degine, amba ibmar-burwigana-bemar-imakdiid imakbalodo. ");
INSERT INTO cuk09_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“¡Bemar ibya-sulidyob emar-idudimalad. Bemar ibmar-burwiganagi alamaknanaimalad. Ibmar-dummagandi bemar gwen imaksurmalad, gwi gobedgi nair sumaladyob, degite, moli-yargan-mureged gobedgi nairdi domaladyob be damalad! ");
INSERT INTO cuk09_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Bemar escribamar, Fariseomar, na be dule-wilesmar, wagar-darbo-damalad! Ar bemar askinbi-na-dule-nued-imakmalad-dulemalad, noga, degi, bate unnila askinedbi nue bemar enukmaladyobid. Ar yabardi ibmar-atursamalad, degi, igar-inikigwad-gwen-imaksurmalad, ibmar-iskana ena be sedidimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo ibya-sulid! Bemar na ulubgi nue nudaked bur nabirid, geb askine be nued gudmogoed, igi nog-yabalid, degi, bate-yabalid, a-inse dulemar nue enukmaladyob, adi magabalid bato nue enukar guddamogadyob. ");
INSERT INTO cuk09_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Bemar escribamar, Fariseomar, na be dule-wilesmar, wagar-darbo-damalad! Ar bemar neg-uan-aski sipuu magaleyob, ibiyobi aski yeer-daklege, ar yabardi garbi ena, degi, ibmar-iskanabi ena bukwad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ar bemar amba deyobmarmodo, askindi ar nue be baiganse oyomardo bemar igar-maidba-inikii-ibmar-imakmalad-dulemarye, ar bemar ulubgindi wagar-darbo be damardo, ulubgi galagwensulid bukidar be sedimardo. ");
INSERT INTO cuk09_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Bemar escribamar, Fariseomar, na be dule-wilesmar, wagar-darbo-damalad! Ar bemar Bab-Dummad-gaya-burba-berbesmaladga neg-uan be sobmalad, degi, inikii-ibmar-imakdii-dule-nanasmaladga be yeer-dakle e-neg-uan-wilubgan imakmalad, ");
INSERT INTO cuk09_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","bemar sogmalad: ‘Anmar-dadgan-ibagi anmar gudigusana, Bab-Dummad-gaya-burba-berbemalad-oburgwenana-gusmargua, anmardi eba gwen akassurmalanye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ar bemar na-dukin na be san oyomardo, bemar we-dulemar-Bab-Dummad-gaya-burba-berbemalad-oburgwismalad-e-wagan gumarye. ");
INSERT INTO cuk09_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Degisoggu, be-dadgan ibmar-iskana-imaksamalad amba napidi, obelogegala, bemar deyob imakmarmosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Naibe-bulegan, ayob bemar iskana gumalad! ¿Ar igi bemar soo-sailagi-odurdaklemaloedgi wakinno na be itomala? Bemar wakinnosurmala. ");
INSERT INTO cuk09_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Degisoggu, Bab-Dummad-gaya-burba-berbemalad, degi, binsaed-ibegan, degi, escribamar an bemarga barmimarsunnad. Gwen-gwen bemar amar-oburgwemaloed, nakrusgi biokmaloed, baigandi bemar sabsur Judiomar-onmaked-neggi bibyomaloed, amar-baregindii neggwebur-baid-baidse be gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Deyob bemar imakoed, adi bemargi ataklemalagar, bela we-napneggi dulemar-ibmar-oakalossurmalad binsa be-dadgan oburgwis-gusmalad, Abel-dule-nued-akar, Zacarías, Berequías-e-machise. Deun be-dadgan, Bab-Dummadse-goled-neg-sunnad-siid, degi, Bab-Dummadga-ibmar-gummakar-ukleged-galu-siid-abargi, Zacarías-oburgwisgusmargu. ");
INSERT INTO cuk09_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Napira an bemarga soged, we dule-nuegan-oburgwilesmalad emi bemar-dula-gudidimaladgi ataklemaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalén-dor, Jerusalén-dor, Bab-Dummad-gaya-burba-berbemalad be oburgwedimalad, bemarse-barmilearmalad bemar akwagi be makdimalad! ¡Ilabigwa bela be-mimmigan danar an na urbebi-gusana, ar igi gannir na e-sakan-urba na e-mimmigan-urbe-daedyob, bemar yapagusmalad! ");
INSERT INTO cuk09_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Degisoggu, be-neg, nega-dule-sulidganyob gunonisunnoed, bei melledoed. ");
INSERT INTO cuk09_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ar an bemarga sogsun, emigindi bar be an-dakosurmalad, ar geb bemar sogedse: We, Bab-Dummad-nuggi danikid, bela ega ib-nuedga guena-gadin.” ");
INSERT INTO cuk09_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Bab-Dummadse-goled-neggi Jesús nodgua, agi bangudgu, e-sapingan ese walikgunonikid, ega oyoarmalad, Bab-Dummadse-goled-neg yeer-dakle siid. ");
INSERT INTO cuk09_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús na e-sapinganga sogded: —Ar we-neg yeer-daklegendo, degite napira an bemarga soged, bela we-neg-bemar-dakedi, bipisaale akwa-gwagwensaar-birgi na askin-askin bar sigosulid, bela egwallegoedbiid. ");
INSERT INTO cuk09_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús Olivos-yarse naded, agi sii, e-sapingan bachikii ese nonimalad, ese egisnonimalad: —¿Sana degite Bab-Dummadse-goled-neg ayarosunna? Be-danikid-iduar, ¿ibi-wilubgan oyoledagosunna? Neg-dukumosar, ¿igi neg gudagosunna? Anmarga be soge. ");
INSERT INTO cuk09_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús na e-sapingan-abin imakdegu, sogded: “Nue salakarmar, mer dulemar be-yardaked be-imakmalo. ");
INSERT INTO cuk09_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ar bukidar yamo anyob imaknonimaloed, sognonimaloed: ‘Ani an Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule.’ A-dule dulemar-bukidar-yardakoed, eba bukidar nagudmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","“Bila-onogedgibi naguar bemar itoar-dibe, degine, bila-onoged daniye, aginbi sunmakarmar bemar itoarbar-dibe, nue salakarmar, mer surbinsa be itomalo, ar wegid-igargan degi-guedsegad. Degi-inigwele, negdi amba yo dukumoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Dulemar-yar-baid-baidgi-bukmalad na bila ononanai-gudamaloed, degi, reymar na muchub-muchub egi yolenanai na gudamarbaloed. Yar-baid-baidgi uelemalad-bukidar ainioed, ukud-dummad nagubaloed, degine, negabandur-dummagan nagumai-gudabaloed, ");
INSERT INTO cuk09_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Degi-inigwele, bela we-ibagan-bulegan unnila igi dutu achunnalile e-bonigan nunmaked-itoar daeyobdo. Ar a-sorbardi bur-bule ibagan-bulegan nonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Neg deyob gunonikile, bemar-sabsur-odurdaklegega dulemar dummaganse be-ukmaloed, amar be-oburgwemaloed. Ar bemar an-sapingansoggu, a-ular bela-dulemar-yar-baid-baidgi-bukmalad istar be-dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A-ibagangine bukidar anba-naigusmalad angi bangudmaloed, na muchub-muchub uknanai-gumaloed, degine, na muchub-muchub na istar dake-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Degine, yamo, bukidar Bab-Dummad-gaya-burba-berbemaladyobi na san imaknonimaloed, amar bukidar-dulemar-yardakmaloed, adi eba nagumalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ar ibmar-iskana-yaisulidba, bukidar-anba-nagusmalad bar an-sabguosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ar ibagan-bulegan-berguedse, dule gwen galakussuliddina, adi nue abonolegodo. ");
INSERT INTO cuk09_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","“We-Bab-Dummad-neg-dakmaid-gaya-burba-nued bela we-napneg-naidgi sunmaklegweler-gebed, adi bela dulemar-yar-baid-baidgi-bukmalad Bab-Dummad-neg-dakmaid-gaya-burba-nued wisguegar, geb agi we-napneg bergunonisunnoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesús sogdebar: “Bab-Dummad-gaya-burba-berbeged-Daniel, wegi-narmaksa, sogsado: Bab Dummad ibmar-istar-dakedi, Bab-Dummadse-goled-neg-islidikidse dognonikogu, Neg-nued neg-iskanaga imakoed, Ar ade a-negse dogedsulinad. Dn. 9:27; 11:31 Ani Jesús, an bemarga sogdo: Bemar deyob neg dakalile, we-Daniel Bab-Dummad-gaya-burba-berbeged-sogsa-gusadba gunaido. Emi be nabir-garda-absodimalad mag ittos namaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Degisoggu, a-ibagi, Judeagi be gudiile, yalaganba be wakinsun. ");
INSERT INTO cuk09_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ar agi dule-wargwen neg-uas-birgi siile, aidealir, mer neg-yaba ibmar-oniega doged-sao, bur yog wakinnar imako. ");
INSERT INTO cuk09_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ar dule-wargwen sapurba gudiile, mer gannar negse bar daged sao, mor sudagegar, bur yog wakinnar imaked, nabirid. ");
INSERT INTO cuk09_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","“¡Ar ammamar-gurgin-nika-gudidimalad, degi, mimmigan-gwaruu-onunanaimaladdi a-ibagangi be nue wilemaloed, ar ade geg be abarmak-gumaloed! ");
INSERT INTO cuk09_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bab Dummadse be gormarsun, we-ibagan-bulegan mer di-wied-ibagi guega, degi, obunnoged-ibaginsurbar. ");
INSERT INTO cuk09_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ar a-ibagangi ibagan-buled, naibi-itoleged naiguoed. A-ibagan naibi-itolegedyobid Bab-Dummad-neg-obinnisad-akar gwen itoledisulid, degi, a-sorba ayobid bar itolegosurbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Ar Bab Dummad a-ibagan-wileged giar imaksasulina, dulemar a-ibagangi gwen wakinosurmalanad, bela burgwemaloenad. Emigindi Bab Dummad na e-sordamar bato nugsaar-ese-gollesmalad-sabedba a-ibagan giar nasiksad. ");
INSERT INTO cuk09_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Degisoggu, dule-wargwen bemarga sokar-dibe: ‘¡Be dakena, wegi gudii, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule!’ Degi, bemarga sokarbar-dibe: ‘¡Be dakena, weba Cristo gudibar!’ Degi-dule-bega-sogedba mer be ibsamalo. ");
INSERT INTO cuk09_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ar ade yamo binsa Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duleyob, degi, Bab-Dummad-gaya-burba-berbegedyob-na-imakmalad nonimaloed. Amar galagwensuli ibmar-wilubgan-dummagan imakdamaloed, degi, ibmar-dakledisurmalad imakdamarbaloed, adi dulemar-yardakegar. Amba Bab-Dummad-sunnad-na-nug-imasmaladse-bakar sunna ese yardaklegena, ese yardaklesmarmogaled. ");
INSERT INTO cuk09_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Degisoggu, nue salakarmar, ar iduakwaa bato an bemarga sogsamalad, mer yardaklemalo. ");
INSERT INTO cuk09_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ar degisoggu, bemarga sokarmar-dibe: ‘Cristo nega-dule-sulidganba gudiiye.’ Mer ase be namalo. Ar igi bemarga sokarmarbar-dibe: ‘Cristo neg-yaba duku-maiye.’ Mer be itomalo. ");
INSERT INTO cuk09_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","“Ar igi mar-ibyed ukiar dada-nakwedsik gaar-dae, degi yog neg-mee dad-argwanedsik neg imake, debayobi, ani Dule-Machi, an nonimogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ar bia san-burgwaled mai, agi mulamar danar ambikunoni-damalad. Debayobi dulemar mag dakmogoed, an gannar we-napnegse danikir.” ");
INSERT INTO cuk09_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús sogdebar: Ibagan-naibi-itoleged-sorba dad-ibeler bar gaosulid, nii bar gaosurmogad. Niskwamardi nibneggi-nanaid babatidagoed. Nibneggi ibmar-dummagan gala-nika-nanaid bela giglimakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Geb degine, mogir-imbaba ani Dule-Machi danikoed-wilubgan dakledagoed. Geb degi we-napneggi bela dulemar-baid-baid-danar-danar-bukmalad bukib binsadamaloed, degi, ani Dule-Machi, mogir-imbaba an-ganguedba, degi, an bela-bela-yeer-daklegedba dani bela an-dakdamaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","An-angermar gala-binnasur-goled-abargi an barmidoed, an-sordamar-bato-nugsalesmalad napneg-ugakase, degi, bela nibneg-ugakase anga wenaegar. Geb degi bela danar ambikunonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Sapi-higuera e-wilubgangi be durdakmar. Ar e-anagan dudumaksale, degi, e-gagan aramaksale, bemar nue wisid, yor omodanikid. ");
INSERT INTO cuk09_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Amba deyobmodo, we-ibmarmar-an-bemarga-sogsamaladi bela deyob guar bemar dakalir, bemar wisdo, ani Dule-Machi, an-danikid nue omosad. ");
INSERT INTO cuk09_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Napira an bemarga soged, we-dulemar-burgwed-idu we-ibmargan bela guedsegad. ");
INSERT INTO cuk09_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nibnegdi, degi, napnegdi bela berguoed, an-gaya-burbadi gege bergued, adi degi-sadeguoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ar an-danikoed-ibadi, degi, a-wachidi dule gwen wichulid, angermar-nibnegginmaladse-bakar gwen wichurmalad, unnila an-Bab-Dummadbi wisid sana an danikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ar igi Noé maigu-gusa, deyob ani Dule-Machi, gannar-danikoed-ibagangi gumogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Deun dii-mured-iduar mas gunbukwa, gobbukwa, ome-nikubukwa, degi, na e-sisgwaga sui-ukbukwa-gusmalad, Noé geb ur-dummad-na-sobsad-yaba dogsadse. ");
INSERT INTO cuk09_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A-dulemar mag gwen itossurmalad. Dii-muludgu, bela a-dulemar burgwismalad. A-Dule-Machi-danikoed-ibagangi, amba deyob gumogoed, dulemar an-edarbebukwasuli ukiar an nonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“A-ibagangi warbo sapurba na gudimalad, wargwen nibnegse seledoed, baiddi obelegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Omegan-warbo na ibmar-gwag nagnanaid, wargwen nibnegse seledoed, baiddi obelegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Degisoggu, nue salakarmar, nue atakmar, ar ade bemar wichulid sana be-Dummad danikoe. ");
INSERT INTO cuk09_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ar wedi bemar nue wismalad, ar dule-neg-ibed wisina igi-wachigi dule-ibmar-atursaed danikoe, e-neg-ibed edarbisaled, dule ei ibmar-atursaega imaksasuliled. ");
INSERT INTO cuk09_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ar degisoggu, bemar guagwar gudii-samar, ar ade ani Dule-Machi, danikoed bemar wichulid, wede sana an danikoe.” ");
INSERT INTO cuk09_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús egisdesun: “¿Ar doa degite mai-nued, nue-binsaed-nikaa, geg galakuedga guosunna? Mai-deyobidi, na e-dummad na e-neg-dakega nug saodo, adi wachi-sekalaa mai-baiganga mas dakegar. ");
INSERT INTO cuk09_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ar we-maigi nued binsalegodo, adi e-dummad gannar nonikir, daknonikir, ar nue deyob arbanai.” ");
INSERT INTO cuk09_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Geb degi Jesús sogde: “Napira an bemarga soged, mai-e-dummad bela na e-ibmar-nikadi we-maiga ukoed, bela ega ibmar-dakegar.” ");
INSERT INTO cuk09_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jesús sogdebar: “Ar mai-iskanardi, na e-gwagegi sokar-dibe: ‘An-dummad amba yoggudoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","A-ular mai-baigan-sarsoalir, degi, dulemar-mungumaladba akaalir, eba mas gunnalir, eba gobbalir. ");
INSERT INTO cuk09_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ar na e-dummad a-ibagi, a-wachigi danikoed-edarbedisulidgi nonikogu, ");
INSERT INTO cuk09_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","daknonikoed, mai deyob gudii. Degisoggu, dummad sabsur mai-odurdaknonikodo, a-e-mai dulemar-wagar-darbo-damaladba eskaryagi metodo, agi bosii, degi, dummad-odurdaklesiidba nugar gorsii-gusunnoed. Debayobi, ani Dule-Machi, an-maigan an imakmogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Degi Jesús sunmakdebar, sogdebar: “Bab-Dummad-neg-dakmaid weyobdo, igi yagana-ambe-guedi na gwallu susmala, ome-nikunaid-ibase naegar, suiga-guoed-abindaknaegar. ");
INSERT INTO cuk09_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E-atale dakleargu, nue-binsaed-nikaa damardo, degi, e-atarbali gwen binsaed nikmarsurdo. ");
INSERT INTO cuk09_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","E-ataled-binsaed-surmaladi, gwallu na sesmargua, gwen e-gwallu-dii-baid butegi enossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ar e-atar-binsaed-nikaa-damaladi gwalluba mesa na gwallu-dii bute-baidgi sesmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ar suiga-guoed yoggudsoggu, bela gabed itoarmargu, gabidmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Nega-gabigwengi binnasur dule gole itoarmalad: ‘¡Suiga-guoed dani, abin daknamar!’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Geb degi bela yagana gwisguarmarsun, na e-gwallu nudakarmar gatik nued gaegar. ");
INSERT INTO cuk09_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ar e-atar-binsaed-suli-damaladi, e-atar-binsaed-nikaa-damaladga sogdemalad: ‘Bemar gwallu-dii anmarga wis udamar, ar ade anmar-gwallu akinmaid.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Yagan-binsaed-nikaa-damalad sogdemalad: ‘Ar mer anmarga gwallu-dii akuegala, degi, bemarga mer akumogagala, bemar dulemar-gwallu-dii-ukmaladse bur be baknamar.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Ar yagan-binsaed-suli-damalad gwallu-dii geb baknadmargu, a-sorba suiga-guoedi nonikid, yagan-binsaed-nikaa-damalad guakwaa bukmarsoggu, eba mas-gunnega dogdemalad, a-sorba yawagak atidsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Geb yagan-ataledi-gwallu-dii-bakdimalad nonimarmogad, suiga-guoedga sognonimalad: ‘¡Dummad, anmarga be yawagak egamar!’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ar dummad abin-imakdegu, sogded: ‘Napira an bemarga soged, aku an be-dakmalad.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Degi Jesús sogdebar: “Degisoggu, nue nakulemar, ar be wichurmalad ibi-ibagi, igi-wachigi Dule-Machi danikoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús sogdebar: “Ar ade Bab-Dummad-neg-dakmaid weyobdo, igi dule-wargwen dikasur na e-neggi nasokargu, e-maiganse gocha, amarga na e-ibmar uksa-nade, ega dakegar. ");
INSERT INTO cuk09_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Emarga-uksadi na e-mani-onoged-sik gurgin-nikadbar. Wargwenga mani-talento-atar ega uksad, baidga mani-talento-bogwa uksad, degi, baidga talento-gwensak uksamogad. Mani-ibeddi dikasur nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Ar dule-talento-atar-abingasadi nadgu, na egi mani onoded, egi atar onosbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ar dule-talento-bogwa-abingasadi amba deyob imaksamogad, gwabo egi onosbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ar dule-talento-gwagwen-abingasaddi nadgu, napagi digdapid, e-dummad-mani napa-yaba odukusad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ar degi-undaradgine, we-maigan-e-dummad nonikid, e-maigan-ebo mani-igar naboalid. ");
INSERT INTO cuk09_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dule-talento-atar-abingasadi nonigu, talento-atar senonibalid, ega sognonikid: ‘Dummad, talento-atar be anga uksad, an talento-atar egi onosbalid, talento-ambe an bega sedanisunnad, be sue.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“E-dummad ega sogded: ‘Nued, be mai-nued, mai-gwen-akussulid. Ar ibmar-ichesaaledgi gwen akussuli be arbasad, ibmar-ichesur an bega uksunnoed. Degisoggu, an-werguedba be wergumosun.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ar dule-talento-bogwa-abingasad nonimogu, sognoni: ‘Dummad, talento-bogwa be anga uksad, talento-gwabo an egi onosbar, talento-bake an bega sedanisun, be sue.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“E-dummad ega sogde: ‘Nued, be mai-nued, mai-gwen-akussulid. Ar ibmar-ichesaaledgi gwen akussuli be arbassoggu, ibmar-ichesur an bega uksunnoed. Degisoggu, an-werguedba be wergumosun.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ar dule-talento-gwagwen-abingasad nonimogu, sognonikid: ‘Dummad, an be-wisdo, be dule-buledid, be ibmar-weed ibmar-digsasulidgi, degine, be-arbassulidgi ibmar be weed. ");
INSERT INTO cuk09_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Degisoggu, an be-dobgusad. An nadgu, be-talento napa-yaba an odukusad. Ar begadid an bega uksun.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“E-dummad, abin-sogdegu, ega sogded: ‘Be mai-iskana, mai-wiegala, be wisinad, an-ibmar-digsasulidgi an ibmar-weed, degine, an arbasulidgi ibmar an webalid. ");
INSERT INTO cuk09_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ar degisoggu, mani-onogosur be itogu, mani-urbemalad-negse be an-mani uknaenad, adi an nonikogu, an-mani onolesad, degi, e-burba an na sunonikoenad.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Dule-mani-ibed e-mai-baiganga sogded: ‘Degisoggu, talento-e-annik be sumarsun, dule-talento-ambe-nikadga be ukmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ar dule-ibmar-nikadi, ega bur uklegoed, adi bur-bule ibmar-nikuegar. Ar dule-ibmar-satedi annik ei sulegoed, amba wis nikad ei bur sulegoed. ");
INSERT INTO cuk09_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ar mai-wichur-arbaedi, magaba neg-sichidse metna, agi bosii-guoed, degi, dummad-wilesiidba nugar gorsii-guoed.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús sogded: “Ani Dule-Machi, na an-ganguedgi-danikoed-ibagi, bela an-angermar-gwage-swilidikmalad-abargi, geb degi an ologangi an-yeer-daklegedgi signonikoed, dulemarga igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Geb degi bela dulemar-yar-baid-baidgi-bukmalad an-asabin ambikunonimaloed. Agi geb bachik-bachik an oambikuoed, igi sibad-wawaad-edarbed sibad-wawaad, degi, sibad-absar-sulid-ebo akar urbe, deyob an dulemar-imakmogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An-argan-nuedsiki sibad-wawaad an urboed, degi, an-argan-sapiledsikdi sibad-absar-sulidi an urboed. ");
INSERT INTO cuk09_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Geb degi an-reyga-maidba an-argan-nuedsik-bukmaladga an sogdagoed: ‘Bemar dagmar, an-Bab-Dummadga be nuedmalad, bemar an-Bab-neg-dakmaid ibgudamar, ar we-napneg nagudgu, bato bemarga nugsales nagusad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ar an ukur itosgu, masgi be an-oguchamalad, an uku-uku itosgu, be an-ogobsamalad, an-neggwebur-sulidgi an gudigusgu, be an-akwismalad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","An mor-sate gudigusgu, mor be anga uksamalad, an uelesgu, be anse atakapmalad an-bendakegar, an eskaryagi mellesigusgu, be anse arbimalad.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Geb degi dulemar-igar-napiragwadba-damalad an-abin imakdemaloed, sogdamaloed: ‘Dummad, ¿sana ukudmada an be-daksamala, an deun masgi an be-oguchamala, uku-uku be itodigu, sana an be-ogobsamala? ");
INSERT INTO cuk09_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Sana be-neggwebur-sulidgi be gudigu, anmar be-susmala? ¿Sana mor-sate an be-daksamargu, mor an bega yosmala? ");
INSERT INTO cuk09_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Sana deun be uelemaigu, an bese atakapmala be-bendakegar? ¿Sana be eskaryagi mellesigu, an bese atakapmala?’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ani an-Rey, an abin-imakdoed: ‘Napira an bemarga soged, ar an-gwenadgan-dummagansulidse-bakar deyob bemar bendaksasoggu, be deyob an-bendaksamaladyobsundo.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Geb degi dulemar an-argan-sapiledsik-bukmaladga an sogdagoed: ‘Angi be bangumar, bemar bato ukabsalesmalad, soo-saila-geg-berguedse be namar, nia-sailaga, degi, e-angermarga a-neg bato guagwar sigisadse. ");
INSERT INTO cuk09_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ar ade ukumada an gudigusgu, gwen masgi be an-oguchasurmalad, uku-uku an itosgu, gwen be an ogobsasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","An-neggwebur-sulidgi an gudigusgu, gwen be an-akwissurmalad, mor-sate an gudigusgu, gwen be anga mor yossurmalad, an uelemaigusgu, gwen be an-bendakapsurmalad, degi, eskaryagi an mellesii-gusgu, gwen be anse atakapsurmalad.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Geb degi amar an-abin imakdemarmogoed: ‘Dummad, ¿sana ukur be gudii, uku-uku be itodii, be neggwebur-sulidgi be gudii, mor-sate be gudii, be ueledii, eskaryagi be mellesii an be-daksamala, deun anmar be-bendaksasuli?’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Geb degi wemar-abin an imakoed, an sogoed: ‘Napira an bemarga soged, ar an-gwenadgan-dummagansurmaladga deyob bemar imaksasurmarsoggu, anga bemar imaksasurmarmosundo.’ ");
INSERT INTO cuk09_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Degisoggu, wemar-iskanamar, odurdakleged-neg-sadeguoedse barmiledmaloed. Dulemar-nuegandi, burba-geg-bergued-negse namaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesús bela-wegi-ibmar-sogsad-sorba, e-sapinganga sokalid: ");
INSERT INTO cuk09_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Bemar wismalad, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba ibabose nagudoed. Agine, ani Dule-Machi, uklegoed, adi nakrusgi biokmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Degine, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, escribamar, Judiomar-girmar-dummagan-neggwebur-sedimalad, bela amar danar dule-irwa-Bab-Dummadse-gormalad-bur-dummad, Caifás-nugad, a-neg-imbase ambikunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Agi igar-itosmalad, adi yamo-yardakar Jesús-gaegar, geb degi oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Judio-dummagan na ga sogdemalad: —Mer ibagi anmar Jesús-gamalo. Degiir, dulemar Jesúsbina urwedamaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús Betania-neggweburgi, Simón-naibe-buna-ya-maleged-nika-gudigusad-neggi sii, ");
INSERT INTO cuk09_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","deun Jesús mesa-naba mas gunsigu, ome-wargwen ese nonikid, gwallu-wawaad-nuedi, bute-alabastro-akwagi-sobaledgi siid, Jesús-nonogi eononikid. A-gwallu-wawaad gargerba-bakleged. ");
INSERT INTO cuk09_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jesús-sapingan ome-weyob-imaksad daksamargu, uludmalad, sogdemalad: —¿Wede ibiga binsarsunna we-ome we-gwallu-wawa-nued wiosa? ");
INSERT INTO cuk09_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ar wede sunna we-gwallu-wawaad mani-dummad uklegoenad, degi, we-mani dule-wileganaga adi nabir uklegoenad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ar degi-sogmalad Jesús mag daksagu, sogded: —¿Ar ibiga bemar nue omese urwemala? Mer ese achamar. Ar ome ibmar-nued anga imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ar dule-wilegedi gusgu bemarba gudigu-sadeguoed. Andi bemarba gudigu-sadeguosulid. ");
INSERT INTO cuk09_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ar ome we gwallu-wawaad an-sangi eosadi, we eosdo an-diglegoed-iduar, ar gusgu anmar-igar-maidba. ");
INSERT INTO cuk09_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Napira an bemarga soged, bia an-gaya-burba-nuedgi we-napneggi sunmaklegoe, we-ome-ibmar-imaksadgi sunmaklemogoed, adi we-ome ibmar-imaksadgi binsamalagar.” ");
INSERT INTO cuk09_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jesús-e-sapingan-ambe-gakabogwad-wargwen, Judas-Iscarioteye-nugad, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Amarga sogdapid: —¿Ibi bemar anga ukmaloe, an bemarga Jesús-ukmalar? Judio-dummagan Judasga mani-sibu dulagwen-gakambe uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Geb agi Judas igar-amiarsunnad, igi saele darba Jesús-uko-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Judio-ibagi, Madu-Ina-Niksuli-Gulleged-Iba-gebe-onodedgi, e-sapingan Jesússe nonimalad, ega sognonimalad: —¿Bia anmar guagwar bega neg amimaloe, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi mas-gulleged gunnegar? ");
INSERT INTO cuk09_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús amarga sogde: —Neggweburse be namar, an-bega-dule-wargwengi-sogoedse. A-dulega be sogmaloed: ‘Odurdaked-saila sogye: An-ibagan omosye. Be-neggine an sapinganmala, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba an dakmaloye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ar igi Jesús emarga sogsamala, e-sapingan deyob imaksado. A-neggi ibagi na mas-gunmalaga bela ibmar guagwar urbismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A-ibagi neg-mutikudgu, Jesús na-e-sapingan-ambe-gakabogwadmala mesa-naba mas-gunnega signonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mas gunbukmargu, Jesús sogded: —Napira an bemarga soged, bemar-wargwen darba an-ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","A-ular e-sapingan nue-wile itodmalad, na wargwen-wargwen Jesúsga sogdemarsunnad: —¿Dummad, ani an be-ukoye? Sur an insa. ");
INSERT INTO cuk09_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús, abin-imakdegu, sogde: —Ar dule-wargwen e-argan bategi anba odogoedi, a darba an-ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Napira an bemarga soged, ani Dule-Machi, ar igi Bab-Dummad-Gardagi angi narmakar nai, ar deyob an guoed, an burgoed. Ar dule-darba-an-ukoeddina adi nue wilegoed, sabsur-odurdaklegoedba. A-dule gwalulessulina, bur nabirinad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Geb degi Judas, darba-Jesús-uknaid, Jesúsga sogded: —Odurdaked-saila, ¿ani an be-ukoye? Jesús ega sogde: —Ar bede soged. ");
INSERT INTO cuk09_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mas gunbukmargu, Jesús madu susgua, Bab Dummadga dog-nuedye sogsa-gusad. Geb a-sorba Jesús madu biske-biske imaksad, e-sapinganga ukded, sogded: —Be sumar, be gunmar, we-madu an-sanad. Jesús na e-sapinganmala we-madu guchamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A-sorba Jesús nog susbalid. Bab Dummadga dog-nuedye sogsabargu, e-sapinganga ukdebalid, sogdebalid: —Bemar bela we gobmar. ");
INSERT INTO cuk09_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","We, an-abe. An-abe Bab Dummad dulemarbo igar-bini-mesnaid-wilubganad, degi, an-abe dulemar-bukidar-ular milegoed, adi iskued ega eliegar. ");
INSERT INTO cuk09_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","An bemarga soged, emigindi uva-nisdi we-sorba bar an gobosulid, geb an-Bab-neg-dakmaidse an bemar-abargi an gobdapbaloed. Jesús na e-sapinganmala we-vino gobsamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bab-Dummad-nuggi namaksamalad-sorba, Olivos-yarse nadmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Geb degi Jesús na e-sapinganga sogded: —Belagwapa emi-mutik bemar angi bangudmaloed, ar ade Bab-Dummad-Gardagi narmakar naid, sognaid: ‘Sibad-wawaad-edarbed an oburgoed, Geb agi sibad-wawaad bela duurmakdoed.’ ");
INSERT INTO cuk09_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jesús sogdebar: —Geb gannar-an-durgusad-sorba, bemar-idu Galilease an naoed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro, abin-imakdegu, sogde: —Bela begi bangudmalale, andi begi gwen banguosulid. ");
INSERT INTO cuk09_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús, Pedro-abin sogded: —Napira an bega soged, emi-mutik, gannir-namaked-iduar, ilapaa be an-osulogoed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro, abin-sogde: —Ar an beba burgweye sogele, amba an be-osulogosulid. E-sapingan-baigan bela degibi sogdemalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús na e-sapinganmala Getsemaní-neg-nugadse nonimarsun. Agi e-sapinganga Jesús sogde: —Wegi bemar ambikumar, andi weba Bab Dummadse gornagwelo. ");
INSERT INTO cuk09_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedro, degi, Zebedeo-machimala-warbogwadbi eba sesa-gusad. Geb agi Jesús na nue-wilegoedba nue-wile itoalid, degi, nue-surbinsa itoarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Geb degi Jesús na e-sapingan-walapaagwadga sogde: —Andi an ulubgi nue-bukib-itogedba sunna an burgwisar-itoleged. Wegi be ambikumar, nue atakmalo, Bab Dummadse be gormalo. ");
INSERT INTO cuk09_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús sikwas nadgu, yokorgi sindigar napagi dulluu sigdapgu, Bab Dummadse gote, sogded: “An-Bab, an-idu igar-buled naid, ina-gaibid gobedyob beedse an egi wilegoed, sunna be anga osulogena-gadin, degite an-sogedbarsur, unnila be-sogedbarbi be imakoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Geb degi Jesús Bab-Dummadse-gorsiid bergusgu, na e-sapinganse nonikid, daknonikid, bela gabmamai. Geb degi Jesús Pedroga sogded: —¿Ar wachi-irgwensaar anba wis ataksii geg be gue, Babse golega? ");
INSERT INTO cuk09_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nue atak, Bab Dummadse be gole, adi iskuedgi-wilubdakleged mer bemarse warmakmalagar. An wisi bemar-burbadi guagwar gudiid Babse golega, bemar-sandi degisulid, adi nolloo gued. ");
INSERT INTO cuk09_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús gannar nadbargu, gannar Bab Dummadse gotebalid, sogdebalid: “An-Bab, an-idu igar-buled naid, ina-gaibid gobedyob beedse an egi wilegoed, geg be anga osulogele, igi-barsa, degite, be-sogedba be imakoed.” ");
INSERT INTO cuk09_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jesús Bab-Dummadse-gorsiid bergusgu, gannar na e-sapinganse nonibargu, daknonikid, gabmamai, ar ade gabed nue egi obin itomalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Degi Jesús na e-sapingan gabmamai obesad, gannar nadbalid. Degi gannar ilapaagi Bab Dummadse goted, gannar idu sogsadgii sogdebalid. ");
INSERT INTO cuk09_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Geb degi Jesús e-sapinganse nonikid, ega sognonikid: —Bemar gabmarsun, bemar obunnomarsun. Emigindi wachidi omossun. Ani Dule-Machi, dulemar-iskudidimaladse darba uklesokarsun, adi an-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Degisoggu, bemar gwisgumarsun, namarsun. Be dakmar, dule-darba-an-uksaddi bato anmar-walik gusad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús amba e-sapinganga sunmakgwichi, e-sapingan-warambe-gakabogwad-wargwen, Judas-nugad, ese nonikid. Aba dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan-neggwebur-sedimalad dulemar-bukidar-barmiar-gusmalad. We-dulemar-bukidar espunyar-yalaba, degi, suarmar annik-annik, Judasba duurmakdani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, Jesús-darba-uksadi dulemar-nonimalad-ebo igar-nabosad, ega sogsad: “Ar dule-e-wagar an uoed, ega sogegar, be nued sogeye, a-dule bemar gamaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Geb Judas yog Jesússe naar imaksad, ega sogded: —Odurdaked-saila, ¿be nuedi? Geb degi ei-wagar usa imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Degi Jesús Judasga sogded: —An-ai, ¿ibiga be daniki? Geb degi dulemar Jesússe nonimalad, geb Jesússe achadmargu, Jesús-gasmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ar e-sapin-wargwen Jesús-naba-gwichidi, espunyar onosgu, dule-irwa-Bab-Dummadse-gormalad-bur-dummad-e-mai naibi imaksad, e-uaya ei siksad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Geb degi Jesús aga sogde: —Be espunyar e-uka-yaba be mese, ar bela dulemar-espunyar-ebumaladi, espunyargi burgoed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ar be insagua, emispinne geg an-Babse gochar be insae, mili-miliba geg angermar anga barmida be insae? Anga barmialile. ");
INSERT INTO cuk09_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ar deyob gusale, ¿degite, igi Bab-Dummad-Gardagi narmakar-naidba bar gusarsunna? Ar a-Gardagi sognaid, an burgwer-gebye. ");
INSERT INTO cuk09_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Geb agi Jesús dulemarga sogded: —¿Ibiga bemar dule-iskana-ibmar-atursaedyob an-gadanimala, emide espunyar, degi, suarmar-yalaba bemar an-gadanimargu? Bane-bane bemarba an gudigusad, Bab-Dummadse-goled-neggi dulemar-odurdakdii, degite agindi bemar gwen an-gassurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Emigindi ar igar-maidbali, adi Bab-Dummad-Gardagi narmakar Bab-Dummad-gaya-burba-berbemalad-narmaksadba guegala deyob gunonikid. Degi Jesús-sapingan Jesús wargwen mete, e-idu bela duurmakdemarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Dulemar-Jesús-gasmaladi, dule-irwa-Bab-Dummadse-gormalad-bur-dummad, Caifás-nugadse Jesús-sesmalad, bia escribamar, degi, Judiomar-girmar-dummagan igar-itogega bukmaladse. ");
INSERT INTO cuk09_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedrodi bannabasaar Jesúsba nadap-gusmogad, dule-irwa-Bab-Dummadse-gormalad-bur-dummad-neg-imbase warmakdapid. A-neg-imbase dogsagua, suar-ibedmar-abargi sigdapid, dakega, igi Jesús-imakmalo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, girmar-dummagan, degi, bela Judio-dummagan-igar-nabiromalad, aminanai-guarmalad, igi-saele Jesús nodiid, yamo-gakansaale, amimalo-dibeye, adi Jesús-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Degite gwen amissurgusmalad, bia Jesús nodiid. Ar bukidar yamo-gakansaar sunmaknonimar-inigwer. Geb warbo yamo-gakansaar ibmar soged nonimalad, ");
INSERT INTO cuk09_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sognonimalad: —We-dule sogsaye: ‘An sunna Bab-Dummadse-goled-neg-siid an earye, degi, gannar ibapaagi sunna gannar an sobye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Dule-irwa-Bab-Dummadse-gormalad-bur-dummad gwisgusgu, Jesúsga sogded: —¿Be dulemar-abin imakosuli? ¿Ar wede igi be sogmosunna begi-sunmaknanaidgi? ");
INSERT INTO cuk09_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ar Jesúsdi bipisaar gwen abin-imaksasulid. Geb degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad ega sogdesun: —Bab-Dummad-Dula-Maid-nuggi an bega soged, anmarga be soge, ¿ar be Cristo, Bab-Dummad-Machi-sunnadi? ");
INSERT INTO cuk09_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús, abin-sogde: —Ar bede soged. A-uki an bega sogbalid, emigi ani Dule-Machi, Bab-Dummad-bela-gangued-nikad-e-argan-nuedsik dule-dummadga an sii be an-dakmaloed, degine, nibneggi mogir-imbaba daniki be an-dakmarbaloed. ");
INSERT INTO cuk09_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Geb degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad e-mor na esirmaksad, oyogegar Jesús degi-sogsad ede sae-itoye, Bab Dummadgi dodoguye. Degi dummaganga sogded: —¡Bab-Dummad-nuggi we dodosad! ¿Ar ibiga e-barsogmalad anmar bar abesunna? Ar bemar-sunnad, emiskwaa be itosmalad, we-Jesús Bab-Dummad-nuggi dodosad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Igi bemar itomarmosunna? Dummagan-igar-itobukmalad abin-imakdemargu, sogdemalad: —Oburgwed ega igar maid. ");
INSERT INTO cuk09_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Geb degi, dummagan Jesús-wagargi wiakdemalad, argan-olor sarsodmarbalid, degine, baigan wagargi bibyodmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ega sogdemalad: —Cristo, ar bela be ibmar wissoggu, anmarga be soge, ¿doa be-bibyossunna? ");
INSERT INTO cuk09_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro neg-imbagi sii, bunagwa-arbaed-wargwen ese nonikid, ega sognonikid: —Be, Jesús-Galileaginedba gudii an be-daksamogad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro, bela dulemar-asabin osuloded, sogded: —Aku an itoged, ibu be anga obare. ");
INSERT INTO cuk09_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro yawagakse nadgu, bunagwa baid Pedro-dakarbalid, a-bunagwa dulemar-bukmaladga sogded: —We-dule, Jesús-Nazaretginedba gudii an daksamogad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro gannar osulodbalid, sogded: —Bab-Dummad-nuggi napira an bemarga soged: Andi, an we-dule-aku-daked. ");
INSERT INTO cuk09_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Degine, sikwas sanargusadgine, walik-bukmalad Pedrose nonimargu, ega sogdemarmogad: —Napira an bega soged, be Jesús-sordamogad, ar be-sunmaked mag-itoleged be a-sordamogad. ");
INSERT INTO cuk09_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Geb degi Pedro ukabsaar ibmar sokalid, degi sogdebalid: —Bab-Dummad-nuggi napira an bemarga soged: Andi, an we-dule-aku-daked. Geb degidgine, yog gannir namakded. ");
INSERT INTO cuk09_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Geb degi Pedro ebinsaas-naded, igi Jesús ega ibmar sogsad: “Gannir-namaked-iduar, ilapaa be an-osulogoed.” Degi Pedro magaba nadgu, nue-ise-boar nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wakdargusgu, bela dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan-neggwebur-sedimalad igar-itosmargu, igar-mesismalad, Jesús-oburgwemaloye. ");
INSERT INTO cuk09_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Edinnar Jesús-sesmalad, neggwebur-dakmaidse Poncio-Pilato-nugadse, aga ukdapmalad, Jesúsga igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Geb degi Judas, Jesús-darba-uksad-dule, dakargu, Jesús-oburgwilegoe, bukib-binsaded. A-ular Judas mani-dulagwen-gakambed gannar dule-irwa-Bab-Dummadse-gormalad-e-dummaganse, degi, Judiomar-girmar-dummaganse senonikid, ");
INSERT INTO cuk09_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","amarga sognonikid: —An dummad nosad, dule-ibmar-gwen-oakalossulid binsa darba an uksad. Ar dummagandi, abin-imakdemalad: —¿Ar anmargardi baisi? ¡Ar wedi begindo! ");
INSERT INTO cuk09_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Geb degi Judas Bab-Dummadse-goled-neggi mani-mide nadsunnad, geb agi na dukin gammu gadapid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, Judas-mani-mided wesmargu, sogdemalad: —Igar-nuedsulid, we-mani anmar Bab-Dummadga-mani-sabogedgi uker, ar ade we-mani bato ukabsalealed, dule-gindakega-imakoed-manid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Geb dummagan igar-itosmargu, baksamalad, napsa-ibmarga-sobleged-nainu, adi agi dulemar-ainebarmalad burgwisar, digmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A-ular a-nainu amba emi-ibase bileged: “Nainu-Abeye.” ");
INSERT INTO cuk09_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ar deyob gunonido, igi Bab-Dummad-gaya-burba-berbeged, Jeremías-nugad, deun sogsa-gusgu: Mani-dulagwen-gakambe susmar, dule-nued-uklesad e-mani, Israel-dulemar an-uksad-mani. ");
INSERT INTO cuk09_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","A-mani napsa-ibmar-sobed-nainu bakega uksamalad, ar igi Bab Dummad anga sogsadba, aba igar imaklesad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dule-dummad-neg-dakmaid Pilato-nugad, a-asabin Jesús gwisgudapid. Pilato Jesússe egichialid, ega sogded: —¿Ar be Judiomar-E-Rey? Jesús, abin-sogde: —Ar bede soged. ");
INSERT INTO cuk09_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan ar Jesúsgi sognanai-guarmar, we, igar-iskana imakdiiye. Ar Jesúsdi gwen abin-imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Geb degi Pilato Jesúsga sogded: —¿Be itosuli bule-melu begi sunmaknanaid bede ibmar-iskana imakdiiye? ");
INSERT INTO cuk09_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ar Jesúsdi bipisaale gwen abin-imaksasulid. Degisoggu, Pilato nue-geger daksunnad, ar ibiga wede Jesús dulemar-abin imaksuli. ");
INSERT INTO cuk09_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Emide dakleargu, ibagi Pilato gusgu Judiomar-abemaladba dule-wargwen-eskaryagi-mellesiid ega onodaed. ");
INSERT INTO cuk09_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Deunni a-ibagangine, dule-wargwen eskaryagi-mellesiido, yeer-dule-nug-nikagwad, Barrabásye a-dulede nugad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dulemar-bukidar ambikunonimargu, amarga Pilato sokar: —¿Doa bemarga onobi be an-abemarsunna, Barrabás-onoge, igi, Jesús, Cristoye-nugad, a bemarga onobi be an-abemala? ");
INSERT INTO cuk09_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ar ade Pilato wisid, Judio-dummagan nobedbali ega Jesús-uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato deun igar-naboged-gangi sii, e-ome ese gaya barmialid: “We dule-nued, dule-iskudisulid, mer egi be yolemogo. Emi an ichakwa gabdakmai oibosad, an egi gabdaksadgi nue nunmak an itodiid.” ");
INSERT INTO cuk09_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ar dule-irwa-Bab-Dummadse-gormalad-e-dummagandi, degi, Judiomar-girmar-dummagan yamo dulemar-binsaed gasmalad, adi Pilatose Barrabás-egismalaga, ega onogegar, Jesúsdi oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato gannar dulemarga sogdebar: —¿Doa bur wemar-warbogwad bemarga onobi be an-abemala? Emar abin-sogdemar: —Barrabás anmarga onoye. ");
INSERT INTO cuk09_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Geb degi Pilato dulemarga sogdesun: —Ar degite Jesús, Cristoye-nugad, ¿igi an imakosunna? Bela abin-sogdemar: —¡We-dule nakrusgi bioke! ");
INSERT INTO cuk09_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato dulemarga sogdebar: —¿Ar degite, we-dulede ibu ibmar-iskana wede imaksasunna? Agi dulemar bur-bule oimakdemalad, sogdemalad: —We-dule nakrusgi bioke. ");
INSERT INTO cuk09_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato dakdegu gwen igar-nabolesuli, aka-bur-bule dulemar oimakbukwa, bormogi dii susgua, na e-argan dulemar-wagab enukded, sogded: —We-dule-nued bemar oburgoed, anginsurdo, bemargindo. ");
INSERT INTO cuk09_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bela-dulemar abin-sogdemalad: —We-dule-oburgwilegoed anmargi naguoed, degi, anmar-mimmigangi. ");
INSERT INTO cuk09_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Geb degi Pilato Barrabás-onossun. Jesúsdi sabsur-bibyosad-sorba suar-ibmalaga uksasun, adi nakrusgi biokmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Degi Pilato-e-suar-ibmala, Pilato-neg-Pretorio-nugadse Jesús-sesmalad. Agi suar-ibmala na e-sordamar bela-danagwenad Jesús-ebilis ambikunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Suar-ibgan Jesús-mor esusmargu, rey-mor-ginnid-yoedgiid Jesúsga yosmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","E-nonogi iko-sobaled-gurgin ega sismarbalid, gaapoledyob e-argan-nuedgi ega masargiid uksamarbalid. Geb degine, Jesús-asabin yokorgi sindigar sig-damalad, yamo egi dodonagus-damalad, ega sogde-damalad: —¡Be Judiomar-E-Rey, suibaksaar be ani gudigusana-gadin! ");
INSERT INTO cuk09_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Suar-ibgan Jesúsgi wiaksa-damarbalid, masargiid annik sudamalad, geb agi e-nonogi sarso-damarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Suar-ibgan Jesúsgi-dodosmalad-sorba, mor-ginnid ega esusmalad, gannar ega e-mor yosmalad. Geb degi Jesús-sesmarsunnad nakrusgi biokmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Roma-suar-ibgan Jesús nakrusgi biokegala Jerusalén-neggweburgi nodmargu, dule-wargwen-Cirene-neggweburgined, Simónye-nugad dakarmalad. A-dulede Jesúsga nakrus-seega ise-barmiar imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Neg Gólgotaye-nugadse modapmalad, a sogleged, Dule-Nonogar-Nega. ");
INSERT INTO cuk09_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","A-negse modapmargu, vino ina-gaibidgi oburaledba suar-ibgan Jesús-ogobdemalad, adi dogbar mer nunmaked itogegar. Ar Jesúsdi wis itosgua, yapa abin-gobgusad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Suar-ibgan Jesús-nakrusgi-bioksamargu, Jesús-morgi dodoarmalad, wilubdaknai-guarmalad, igid mormar egadga guo-dibeye. A-sorba Jesús-mor mimmismarsunnad. Weyob gusdo, adi Bab-Dummad-gaya-burba-berbeged epenne sogsadyob guegar, deun sogsa-gusgu: An-mor na mimmismarsun, degine, an-morgi wilubdaknanai gusmar, adi dakega doagadga guo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Degine suar-ibgan ambikusmargu, Jesús-edarbesigusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","E-nakrus-birgi narmaksamar, ibiga Jesús burgwenai. Narmakaled weyob sognaido: ");
INSERT INTO cuk09_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Geb degi suar-ibgan dulemar-atursamalad-warbo nakrusgi bioksamarmogad. Wargwen Jesús-nakrus argan-nuedsik ogwichisad, baiddi Jesús-nakrus argan-sapiledsik. ");
INSERT INTO cuk09_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dulemar-Jesús-dikarba-nasdamalad ise-dodoar egi nas-damalad, yamo ega nono-ege-ege gunadap nas-damalad, ");
INSERT INTO cuk09_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ega sogde-damalad: —Ar be Bab-Dummadse-goled-neg be earoye sogsad, degi, ibapaagi gannar sobbaloye. Ar be deyob sogsasoggu, emigindi na be dukin bendake, ar be Bab-Dummad-Machile, nakrusgi-naid be aidedage. ");
INSERT INTO cuk09_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Amba deyob, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, escribamar, Fariseomar, degi, Judiomar-girmar-dummagan, amar bela Jesúsgi dododmarmogad, sogdemarmogad: ");
INSERT INTO cuk09_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—We-Jesús dule-baigandi nabir bendaksad, edi dukin geg na bendaked. Ar Jesús Israel-Dulemar-E-Reyle, nakrusgi-naid aideda-den, geb agi anmar egi benguosulid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","We-dule Bab-Dummad-gwen-bengussulid e-bendakegar, degisoggu, Bab Dummad nabir we e-dakele, bendakodo, ar na sogsagusad: ‘Ani an Bab-Dummad-Machiye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Amba deyob atursamalad-Jesúsba-nakrusgi-bioklegar-naimalad egi dodonanai-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dad yorukugusgu, bela we-napa-naidgi nega-sichid nagunonikid, wachi-irbaase naigusad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wachi-irbaa gusgu, Jesús binnasur goted, sogded: “Elí, Elí, ¿lama sabactani?” A sogleged: An-Bab-Dummad, an-Bab-Dummad, ¿ibiga be angi bangusa? ");
INSERT INTO cuk09_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abar Jesús-nakrus-walik-bukmalad Jesús degi-soge itosmargu, sogdemalad: —Wede Elíasse gornaid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Degi dule-wargwen, yoga abarmakar naded, ibmar buta-butadi susgua vino-gaibidgi owardikusad, geb suar-dukugi edichagu, Jesúsga ukded, adi suk-suk saegar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ar baigandi sogdemalad: —Mer ese achamar, dakmalo bule Elías odenoniko-dibe. ");
INSERT INTO cuk09_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Geb Jesús gannar binnasur gotebargu, burkwis naded. ");
INSERT INTO cuk09_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Deun, Jerusaléngi, Bab-Dummadse-goled-neggi, Neg-Islidikid-irwa-mor-naid niba achirmakde urbalidse-bakar gusad. Degi napneg giglimakded, akwa-dummagan mamaridbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Degi neg-uanmar argadbalid, bukidar-dule-gwage-swilidikmalad-burgwismalad durgudmalad, ");
INSERT INTO cuk09_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","amar neg-uangi-mamaid ainidmalad. Jesús-gannar-durgusad-sorba, geb neggwebur-islidikid-Jerusalénse, nonimalad, degine, amar bukidar-dulemarse magarosmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Degi Roma-suar-ibed, sordamar-dulatar-sediid, degine, e-sordamar, Jesús-edarbebukmalad, negabandur-nagusad daksamargu, degi, bela ibmar-gusad daksamalad, bela nue-dobe-ito nadmalad, sogdemalad: —We-dule nue Bab-Dummad-Machi-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Agi bukidar-omegan bannabasaar Jesús-dakbuk-gusmarmogad. Ar a-omegan Galilea-akar Jesúsba bipirmakdanimalad, ega ibmar-imakdii-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Amar-omegan-abargi María-Magdalena, María, Santiago, degi, José e-nan, degine, Zebedeo-machimala-e-nan, gwichi-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Neg-sedodgu, mani-ibed-wargwen, José-nugad nonikid. We-dulede Arimateaginedid, Jesús-e-sapinga gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","We dule Pilatose nade-gusad, Jesús-mui egisdapid, adi neg-uanse dignaegar. Geb degi Pilato igar-uksad, Jesús-mui Joséga ukmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José, Jesús-mui-nakrusgi-naid odesgu, atued-sipu-ollibisulid-nuedgi nue obipirmaksad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Geb degi José na e-neg-uan-binidgi Jesús-mesisad. A-neg-uande akwa-imbaba nue-saale akwiargalad José akwa-dummad obaparmaksagu, a-neg-uan-doged-idu akwa-dummad sisa, nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","José, Jesús-mui dignaigu, María-Magdalena, baid Maríaye-nugbalid, neg-uan-asabin bukwa-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Banedgine, ibmar-guar-urbed-sorba, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Fariseomar Pilatose ambikunonimargu, ");
INSERT INTO cuk09_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ega sogdemalad: —Dummad, anmar insado, we-dule-yardakegwad amba dula gudigu, sogsa-gusad: ‘Ibapaagwad-sorba gannar an durguoye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Degisoggu, be barmide dule neg-uan ibapaa edarbegar, ar abakalegi degiile, e-sapingan mutik Jesús-mui atursanonimalale, geb dulemarga sokarmalale: ‘Burgwar-mamaimalad-abargi Jesús durgusye.’ Ar degiir, bur-bule idualedba dulemar-yardakoed. ");
INSERT INTO cuk09_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Geb degi Pilato amarga sogded: —Nabir, Ar degiile, wegi-suar-ibmala-bukwad be neg-uanse sedmar, ar na be wismaladba be imakmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Geb degi amar neg-uanse nadmarsun. Akwa-yawagakgi-siidgi Roma-wilub nasiksamalad, adi dulemar mer neg-uan egamalagar. Degine, suar-ibmala-ogwichismarbalid, neg-uan edarbemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Obunnoged-iba nasgu, itoged-iba-geb-naguded oiboargu, María-Magdalena, degi, María-baid, neg-uan-dakega nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Degi negabandur-dummad nagu-nonikid, ar ade Bab-Dummad-e-anger-nibneggi-danikid, napnegse nonigu, akwa-dummad neg-uan-yawagak-idu-siid onirnonikid. A-anger a-akwa-birgi sigissunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anger-e-dakleged mar-gaedyob-dakleged, degine, e-mor ise-sibudik, dakuu daklebalid. ");
INSERT INTO cuk09_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","A-dobedbali, suar-ibmala wawanmakdemalad, degi, burgwisayob megismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ar angerdi omeganga sogded: —Mer bemar dobgumar, ar an wisdo, bemar Jesús-nakrusgi-biokles-gusad amidanimalad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jesús wegi bar maisulid, ar igi bemarga sogsa-gusa, deyob gusad, Jesús gannar durgusad. Be dakdamar, bia Dummad-Jesús mai-gusad e-gannar. ");
INSERT INTO cuk09_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bemar gwae namar, e-sapinganga sognamar: ‘Emi Jesús burgwar-mai-gusadmar-abargi gannar durgusye, bemar-idu Galilease nadmarye, agi be dakmaloye.’ Webi an bemarga sogdo. ");
INSERT INTO cuk09_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Degi omegan neg-uangi nodgu, dobed-abargi, degi, nue-weligwar itogedginbali, abarmakdemalad, Jesús-sapinganga gaya-burba-nued sognamalagar, Jesús durgusye. Degine, omegan gaya-burba-nued sognadapmargu, ");
INSERT INTO cuk09_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","egi Jesús noalid, ega sogded: “¡Na, degite, bemarde!” Degi omegan ese walik gunonimargu, e-mali-duku angaagwar imakdemalad, degi, Jesús-nug Bab-Dummad-nug-odummolegedyob odummodmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Geb degi Jesús amarga sogde: —Mer bemar dobgumar, be namar, an-gwenadmarga gaya-burba-nued be sognamar, adi Galilease namalagar, agi an-dakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ar omegan nadapmargu, suar-ibmala-abar neggweburse nadmarmogad, dule-irwa-Bab-Dummadse-gormalad-e-dummagan owisodapmalad, bela igi neg-uangi ibmar-gusadba. ");
INSERT INTO cuk09_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, Judiomar-girmar-dummaganse gochamargu, na igar-itosmalad, degi, suar-ibmalaga mani-ichesur uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Amarga sogsamalad: —Bemar sogoye: ‘Jesús-sapingan mutikidba nonimarye, Jesús-mui atursasmarye anmar gabmamaiguye.’ ");
INSERT INTO cuk09_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ar dule-dummad-neg-dakmaid degi-itoalile, anmar-ebo sunmakoed, adi mer be-oakalomalagar bemar gabbukwad-ular. ");
INSERT INTO cuk09_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Suar-ibmala mani susmargu, ar igi Judio-dummagan ega sogsamala, deyob imaksamardo. Ar deyob Judiomar-abargi we-gaya amba emi-ibase soglediid: suar-ibmala gabmamaigu, Jesús-e-sapingan Jesús-mui atursasmarye. ");
INSERT INTO cuk09_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ar Jesús-e-sapingan-ambe-gakagwensak-guedi, Galilea-yarse nadmalad, bia Jesús ega sogsagusad, a-yarse be naoye. A-yarse nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","E-sapingan Jesús-dakarmargu, Jesús-nug igi Bab-Dummad-nug-odummolegedyob odummodmarmogad. Gwenna-gwenna-e-sapingan amba egi bengusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús na e-sapingan-walik gunonigu, amarga sogded: —We-napneggi neg-dakega degine, nibneg dakega Bab Dummad bela igar anga uksad. ");
INSERT INTO cuk09_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Degisoggu be namar, bela-dulemar-yar-baid-baidgi-bukmalad an-sapinganga gued be imaknamar, Bab-digi-ogleged-igar be imaknamar, Bab-Dummad-nuggi, Bab-Dummad-Machi-nuggi, degi, Bab-Dummad-Burba-Nued-nuggi. ");
INSERT INTO cuk09_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Bemar dulemar-odurdaknamar, bela-ibmar an-bemar-odurdaksad nue eba nanamaloye. An emi bemarba bane-bane gudiguoed, we-napneg-berguedse. Be itomargua.");
INSERT INTO cuk09_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo, Bab-Dummad-Machi, egi-gaya-burba-nued-sunmaklesad, wegi-onoddo. ");
INSERT INTO cuk09_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Epenne Isaías, Bab-Dummad-gaya-burba-berbeged narmaksado, Bab Dummad sogye: Be-iduale, anga-gaya-burba-barsoged an barmidoed, adi be-iduar bega igar-mayegar. ");
INSERT INTO cuk09_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Dule-wargwen nega-dule-sulidganba binnasur sunmaknonikoed, dulemarga sognonikoed: “Dule-Dummad-idu igar-mayemar, igar-swilidik mesmar.” ");
INSERT INTO cuk09_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Igi Isaías Bab-Dummad-gaya-burba-berbeged sogsa-gusa, deyobi Juan-Bautista nonikid, Bab-Dummad-digi-ogleged-igar imaknonikid, nega-dule-sulidganba nonikid, sunmaknonikid: “Be-iskuedga na be ulubgi bukib binsamar, be-daed be ogwamar, Bab-Dummad-digi-ogleged-igar be imakmar, adi be-iskudiid Bab Dummad bega eliegar.” ");
INSERT INTO cuk09_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Degisoggu, bela Judea-yalaganbarmalad, degi, bela Jerusalén-neggweburginmalad, Juan-Bautistase nonimarsun, gaya-burba-nued itogegar. E-iskudiid na dukin-dukin barsognanai-guarmalad. Geb Juan Bab-Dummad-digi-ogleged-igar imaknai-gualid, Jordán-diwargi. ");
INSERT INTO cuk09_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan-Bautista moli-yargan-mureged-e-absar na morga imakdii-gualid, degi, moli-uka e-molidubga imakdii-guarbalid, geb sese, degi, achanis e-masga imakdii-gusbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan dulemarga sogdebarsunnad: —Dule-wargwen-an-sorba-danikid, a-dule anba bela-bela bur dule-dummadsoggu, andi e-sapat-dubse-bakar geg ei an esiked. ");
INSERT INTO cuk09_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Andi Bab-Dummad-digi-ogleged-igar imaksad, unnila digi an be-ogsamalad. An-sorba-danikiddi, Bab Dummad Burba Nuedgi be-ogmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Deunni, a-ibagi Jesús Galilea-yargi gudiid, Nazaret-neggwebur-nugadgi. Agi nadegusad, Jordán-diwarse. Geb a-diwargi Juan-Bautista Bab-Dummad-digi-ogleged-igargi Jesús-ogsad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús diwargi nakwiargu, nibnega argad daksad, degine, Bab Dummad Burba Nued nuuyobi egi aidedani-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Degine nibneggi, gaya-burba gollar, sogded: “Be An-Machi-sabed-sunnad gued, beba weligwar an itoged.” ");
INSERT INTO cuk09_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Juan Bab-Dummad-digi Jesús-ogsad-sorba, Bab Dummad Burba Nued Jesús-sesa-gusad, nega-dule-sulidganba. ");
INSERT INTO cuk09_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Agi ibmar-durgan-abargi Jesús iba-dulabo gudigusad. Deunni nia-saila Jesússe noni-gusad, geb degine nia-saila-Satanás Jesús-wilubdaknai-gualid. Nia-saila Jesús-wilubdaksad-sorba, angermar noni-gusmogad, Jesús-bendakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A-ibagangi, eskaryagi-Juan-Bautista-metemalad-sorba, Jesús Galilea-yarse nonikid, Bab-Dummad-neg-dakmaid-gaya-burba-nuedgi sunmakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús sogdigualid: “Ibagandi nonisun, Bab-Dummad-neg-dakmaid anmarse warmaknonisun. Degisoggu, be-iskudiidga na be wile itomar, mer bar iskuegar, Bab-Dummad-gaya-burba-nued mer ulubgi bengumar.” ");
INSERT INTO cuk09_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús Galilea-mata-dummad-gakaba nadapgu, Simón-dakalid, sakigi ua-ganai e-urba-Andrés-ebo. Ar amar gusgu ua-gaedgi arbamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús amarga sogded: —Anba be dagmar, igi bemar ua-gae, abayobi dulemar-we-napneggi-bukwad-gaega an be-odurdakmaloed, adi dulemar anba nagumalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Simón, degi, Andrés, abga e-saki yog miar imasmalad, geb degi Jesúsba yog naar imasmarsunnad e-sapinganga guegar. ");
INSERT INTO cuk09_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús sikwas nadbargu, Santiago, degi, e-urba-Juan-ebo, urgi saki matumakbukwa dakdapid. Amar Zebedeo-machimala gued. ");
INSERT INTO cuk09_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús amarga yog sogdemogad: —Bemar anba dagmarmo, an-sapinganga gumarmogagar. Santiago, Juan-ebo Jesúsba nadmarsun e-sapinganga gumarmogagar. Zebedeodi, degi, ega-arbamaladdi, sorba urgi besmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús na e-sapinganmala Capernaum-neggwebur-nugadse nonimargu, obunnoged-ibagi Judiomar-onmaked-negse dognonimalad. Agi Jesús Bab-Dummad-igargi dulemar-odurdakdesunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesús dulemar-odurdaksigu, geger dakmalad igi dulemar-odurdaked. Ar ade escribagii dulemar-odurdaksulid, Jesúsdi nue-igar-wisi dulemar-odurdaked. ");
INSERT INTO cuk09_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Agi Judiomar-onmaked-neggi dule-wargwen, niaburba-nikad siid, binnasur gollalid, sogded: ");
INSERT INTO cuk09_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús-Nazaretgined, ¿Ibiga be anmar-wiodaniki? ¿Be anmar-obelogega daniki? Anmar be-wisi be doa-dule. Be dule-gwage-swilidikidid, Bab-Dummad-nuggi-danikid-duled. ");
INSERT INTO cuk09_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús niase uluded, ega sabsur ibmar sogded: —Mer be sunmak, dulegi-maid be noe. ");
INSERT INTO cuk09_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Niaburba dule-bindumakde-imasgu, binnasur goted, degine, geb dulegi nodsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Degi-gusad bela geger dakdemalad, agi sogdemarsunnad: —¿Wede igidbarsunna? We-dule nue-igar-wisi dulemar-odurdaked. Niaburbamarse-bakar eba ibsamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Degi bela Galilea-yalaganba wisguarmalad, igi Jesús dulemar-nudakdiid. ");
INSERT INTO cuk09_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesúsmala Judiomar-onmaked-neggi noarmar-gusad: Simón, Andrés, Santiago, degi, Juan. Amar-e-atar Simón-negse nonimalad, a-neg Andrés-negmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón-negse nonimargu, Jesúsga sokarmalad: “Simón-sakbundor ise-uelegar maiye.” ");
INSERT INTO cuk09_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús ese nade-gusad. Walik gwisgudapgu, argangi gasgu, geb ogwichiis imaksad, geb a-ome yog nuguar naded. Geb Simón-sakbundor a-sorba emarga yog ibmar imakar-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Neg-sedodgu, dad-argwated-sorba Jesússega dule-uelemalad, degine, nia-nikmaladse-bakar ese senonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dulemar bukidar Jesús-yawagak-naba ambikunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús bukidar dule-gegumalad-nudaksad, degine, niamar-bukidar-onisbalid. Niamar-e-abin-sunmakega gwen imaksasulid, ar ade wismalad, we-Jesús doa-dule gue. ");
INSERT INTO cuk09_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Banedgine, bolegoedbali, Jesús neggweburgi noded, na wargwen bachikii Bab Dummadse golegar. Geb degi, Babse gorsigusad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón-Pedro, degine, e-sordamar Jesús-amiarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesús-amismargu, ega sogdemalad: —Dulemar bela be-amidimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús, e-sapingan-abin sogded: —Unnila we-dulemargarbi an nonisulid. Degisoggu, neggwebur-baidse Bab-Dummad-igargi sunmaknamarbargwelo, ar aga we-napnegse an nonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilea-yalaganba Jesús garmakdii, Judiomar-onmaked-negmargi Bab-Dummad-igargi sunmakdii, degi, niamar-onidii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Degi-gudii, ibagwengine, dule-naibe-buna-ya-maleged-nikad yokorgi sindigar Jesús-asabin signonikid, egi wilenai, ega sogded: —An wisi, sunna be an-nudaked, be an-nudakbier. ");
INSERT INTO cuk09_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús dule-bonigwaled-dakdegu, nue-wile dakded, e-argangi ebus imaksagu, ega sogded: —Nugubi an be-abeged. ¡Be nugusun! ");
INSERT INTO cuk09_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dule-naibe-buna-ya-maleged-nikad yog nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús, dule-nugusad abga yog barmiar imaksad, sabsur ega sogded: ");
INSERT INTO cuk09_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Mer dulemar-baiganga be sogo, unnila dule-irwa-Bab-Dummadse-goledga na be-san oyona, be nugusad. Degine, nuu-gwabo be sedbalo, Bab Dummadga ukegar, Moisés-igar-mesisadba, adi dulemar mag be-dakegar, be nue nugusad. ");
INSERT INTO cuk09_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ar a-dule-nugusad nadgua, emarga bela sogded, igi Jesús e-nudaksad. Degisoggu, a-ular geg Jesús neggweburse doge-guarsunnad, unnila nega-dule-sulidganba gudiguarsunnad. Ar degi-inigwele, dulemar-dikasurmalad bukidar Jesússe noni-gusmalad, Jesús-dakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A-undarad-sorbali, Jesús gannar Capernaumse nonikid. Dulemar wisguarmargu Jesús neg-yagi maiye, ");
INSERT INTO cuk09_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","dule-bukidar ese noni-gusmalad, yawagaknase-bakar bela ena ese ambikunonimalad. Agi Jesús, Bab-Dummad-gaya-burbagi emarga sunmaksii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Degine, dule-walabake e-ai-abgan-burgwar-nikad gabedgi-mai Jesússe senonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dulemar-bukidar neg ena sisoggu, Jesússe geg warmakguarmalad. Degisoggu, dulemar-warbakegwad neg-birgi nakwismarsunnad, geb uas egasmalad, bia Jesús-siid-inik. Degi dule-gegu-maid Jesús-inik gabedgi-mai odesmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús dulemar-warbakegwad dakdegu egi gwen bensulid, dule-gegumaidga sogded: —An-ai, be-iskudii-gusad be nugussun. ");
INSERT INTO cuk09_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Agi escribamar bukwa-gusmogad. Amar Jesús-itosgu, binsadmalad: ");
INSERT INTO cuk09_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ibiga we-dule degi-soge? ¿Bab Dummadgi dodoye soge? ¿Unnila Bab Dummadbi sunna dulega iskued elisursi?” ");
INSERT INTO cuk09_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ar Jesús sunna ulubgi dulemar-binsaed mag daksoggu, amarga sogded: —¿Ibiga be-ulubgi deyob be binsabukmarsunna? ¿Geg iskued osulo be an-insae? ");
INSERT INTO cuk09_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","An dule-bonigwaledga sog-dibe: ¡Be-iskunaid an bega osulos! Ar igi, an sogbarsun-dibe: ¡Be nugu, be gwisgu, be nae, be-egi-gabed na be sede! Degite, ¿Igid bur-baisursunna imaklesunna? Suli, ebobela baisursunna imaklesuli. ");
INSERT INTO cuk09_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Degisoggu, ani Dule-Machi, dule-bonigwaled an-nudakoed, adi bemar wisguegar, igi dule-bonigwaled sunna an nudake, debayobi we-napneggi dule-gwage-iskunaid sunna nudaked an nikbalid. —Jesús dule-abgan-burgwar-nikadga sogdesun: ");
INSERT INTO cuk09_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Ani an bega soge, be gwisgu, be-egi-maid na be sede, be-negse na be nasun. ");
INSERT INTO cuk09_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Degi dule-bonigwaled yog nuguar gusgu, yog gwisguar imaksad, geb yog na-egi-gabed sear. Geb degi, dulemar-abargi noded. Degi, belagwapa geger dakdemalad, geb Bab-Dummad-nug ogannodmarsunnad, sogdemalad: “Wegiid-ibmar anmar gwen dakdisulid.” ");
INSERT INTO cuk09_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A-sorba Jesús gannar Galilea-mata-dummad-gakaba nade-gusad. Dule-bukidar eba nadmarmogad. Geb degi Jesús Bab-Dummad-igargi emar-odurdakded. ");
INSERT INTO cuk09_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Degi Jesús nadgu, Leví-dakalid, Alfeo-machi, Roma-dummadga-mani-galeged-neggi sii, mani gasii. Jesús Levíse goted, ega sogded: —Anba be dage, an-sapinga guegar. Degi Leví gwisgusgu, eba yog naar imaksad e-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús, e-sapinganmala Leví-neggi mas gunsigu, dule-Roma-dummadga-mani-gaedgi-arbamalad, degi, dule-baigan-galagwensuli-iskudimalad eba mas gunsigusmogad, ar a-dulemarde bukidar Jesúsba gudidamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Fariseomar, degi, escribamar, dule-iskanamarba Jesús mas-gunsii daksamargu, Jesús-e-sapinganse egichiarmalad, ega sogdemalad: —¿Ibiga be-odurdaked-saila dulemar-Roma-dummadga-mani-gaedgi-arbamaladba, degi, dule-baigan-iskudimaladba mas gunne? ");
INSERT INTO cuk09_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús, deyob Fariseomar soge itosgu, ega sogded: —Dulemar-gegusurmalad ina-duled-abesulid, unnila dulemar-gegumaladbi ina-duled-abe damalad. Deyobi, we-napnegse an nonigu, dulemar-nuegan na iskudisur-itomaladse golega an nonisulid, an nonikidi, dulemar iskudii-na-itomaladse golega. ");
INSERT INTO cuk09_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ibagwengine, Juan-e-sapingan, degi, Fariseomar-e-sapingan nue Bab-Dummadse-golega mas-gunsuli gudimargu, dulemar Jesússe egisnonikid, ega sognonikid: —¿Ibiga be-sapingandi Bab-Dummadse-golega mas-gunsuli geg gudigue? Juan-sapingandi, degi, Fariseomar-sapingandi mas-gunsuli gudidamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús, abin-burbar-sogde: “¿Dulemar ome-nikued-ibagi mas-gullegedse nonikile, dule-ome-nikuoed e-abargi siile, sunna mas-gunsuli gumalo be insae? Dule-ome-nikunaid e-abargi siile, dulemar geg mas-gunsuli gumalad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ar ibagan nonikoed, dule-ome-nikunaid e-idu seledoed. A-ibagan nonikile, agindi Bab-Dummadse-golega mas-gunsuli gudigumalodo. Emigindi amba an gudisoggu, an-sapingan geg mas-gunsuli gudigumardo. ");
INSERT INTO cuk09_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Aginbali, dule gwen morgoa-binid matuga mor-seredgi nasikega gwen imakdisulid. Degiir, morgoa-binid sinnii nadele, mor-sered aka-bur-bule achirmakdo-itole. ");
INSERT INTO cuk09_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Deginbali, inna-gaibid-binid gwen ibmar-uka-bugluga-sobaled-seredgi baliledisulid. Degiir, inna-gaibid mudele, buglu-sered esirmako-itole. Degiir, binsa inna-gaibid milego-itole, degi, bugluse-bakar binsa miledo-itole. A-ulale, inna-gaibid-binid buglu-binidgi balileged. Dule-igar deyobmodo, igar-sered geg igar-binid-ebo atoged.” ");
INSERT INTO cuk09_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ibagwengine, obunnoged-ibagi, Jesús orosgii-dakleged-digaled-imbaba nadapgu, e-sapingan ibmar-digaled gwane-gwane imaknadapmardo. ");
INSERT INTO cuk09_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseomar-Jesúsba-nadapmalad Jesússe egisdemalad: Be dakena, ¿ibiga be-sapingan obunnoged-ibagi ibmar-gwag gwane-gwane nadapmala? ¿Obunnoged-ibagi mer arbaoye igar maisursi? Emide be-sapingan igar-maidgi annadimargu. ");
INSERT INTO cuk09_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús, abin-sogded: —An-sapingan igar-maidgi annadisulid. ¿Bemar Bab-Dummad-Gardagi absodisurmarsi, David igi imaksa deun Abiatar, dule-irwa-Bab-Dummadse-gormalad-bur-dummadga maiun? David, degi, e-sordamar ukumechargu, Bab-Dummadse-goled-negse dognonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Agi Abiatar, Davidga madu-ised uksad, geb degi, e-sordamar a-madu guchamarmogad. Ar David, degi, e-sordamar a-madu gunnedsulinad, ar ade madu isedid. ¿We-madu unnila dule-irwa-Bab-Dummadse-gormaladbi gunnoye igar maisursi? Degite, ¿David, degi, e-sordamar igar noar imaksamala? Suli, ar ukudba nabir madu guchamalad. Degisoggu, an-sapingan nabir imaksamarmodo. ");
INSERT INTO cuk09_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Degine, Jesús Fariseomarga sogdebar: —Obunnoged-iba dulega nasiklesad, dule obunnoged-ibaga obinnilessulid. ");
INSERT INTO cuk09_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Degisoggu, ani Dule-Machi, obunnoged-iba-e-Dummadid. ");
INSERT INTO cuk09_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ibagwengi Jesús Judiomar-onmaked-neggi dognonibalid. Agine, dule-wargwen argan-burgwaled sii-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesús-istarmalad-bukidar Jesús-argabukwa-gusmalad, dakegar, bule obunnoged-ibagi Jesús dule-nudako-dibeye, adi egi sunmakmalagar, obunnoged-igar-maidgi annadiiye. ");
INSERT INTO cuk09_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús dule-argan-burgwaledga sogded: —Dage, abarse gwisguda. ");
INSERT INTO cuk09_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Degi Jesús dulemar-e-dakbukwadga sogded: —¿Wede igar-nuedi obunnoged-ibagi ibmar-nued-imaked, igi, ibmar-iskana-imaked? ¿Igid bur-nabiri, dule-odurgued, igi, dule-oburgwed? ¿Igi bemar sogsunna? Dule-gwensaksaar abin-imaksasulid, bela boo ambikusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús undar saebaksar itos, ulubgi nue bukib-binsa emar-dakded, ar ade nue-akusunna itomalad Bab Dummad dulemar-sabed. Degine, wile-emar-daked gwen niksurmarbalid, unnila bur-bule igar-maidba dabimalad. Jesús dule-argan-burgwaledga sogdesun: —Be-argan onak. Dule e-argan-onakwidgu, e-argan yog nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseomar Judiomar-onmaked-neggi sii noargu, Herodes-sordamar-ebo igar-amiarmalad, igi-saele Jesús-oburgwemalo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús na e-sapinganmala mata-dummad-gakase nade-gusad. Bukidar-Galilea-dorgan eba nade-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesús ibmar-dakledisurmalad imakdiiye wisguarmargu, Judeaginmalad, Jerusalénginmalad, Idumea-dorgan, Jordán-diwar-gakabarmalad, Tiro-yarginmalad, degi, Sidón-neggweburginmaladse-bakar nonimalad, Jesús-dakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Degisoggu, aga Jesús e-sapinganga sogsasunnad: —Anga guar ur nasikmalo, ar dulemar an-ebugega na barmesnanai-guarmalale, idu urgi an nakwegar, adi mer an-sarwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ar ibigala, ade Jesús dule-bukidar-nudakdisoggu, dule-uelemalad Jesús-ebugega na barmesnanai-guar-damalad, nudaklegegar. ");
INSERT INTO cuk09_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Degine, niaburba-dule-ichodimalad, Jesús-dakalile, sindigar yokorgi yog sigis-damalad, geb degi Jesúsga binnasur sogde-damalad: —¡Be Bab-Dummad-Machi-sunnadid! ");
INSERT INTO cuk09_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús niamarga sogde-daed: —Dulemar-abargi mer an-barsogmar, an doa-dule. ");
INSERT INTO cuk09_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A-sorbali Jesús yar-birse naded. Doamar ese dagbi abesa, amarse gochad. Amar bela ese ambikunonimargu, ");
INSERT INTO cuk09_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","geb degi Jesús e-ambe-gakabo susad, adi eba nanaegar. Amar Bab-Dummad-gaya-burba barsogega onugsalesbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Degi Jesús amarga gangued uksabalid, adi niamar-oniegar. Amar apóstolesye-bilesad, a sogleged, Jesús-nuggi-barmilenanaidye. ");
INSERT INTO cuk09_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesús-e-ambe-gakabo-susad, wemardo: Simón, a Pedroye Jesús onugsasbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, degine, e-urba Juan, Zebedeo-machimala; a-machimalade baisursunna ulud-daed. Degisoggu, Jesús, Boanergesye onugsasbardo, a sogleged, mar-goled-machimalaye. ");
INSERT INTO cuk09_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Degine, Andrés, Felipe, Bartolomé, Mateo, Tomás, degi, Santiago, Alfeo-machi, aginbali, Tadeo, Simón, a-dule cananista-sordad, ");
INSERT INTO cuk09_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","degi, Judas-Iscariote, darba-Jesús-uksad-dule. ");
INSERT INTO cuk09_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A-sorba Jesús na e-sapinganmala negse dognonimalad. Dulemar-bukidar gannar ese ambikunonisoggu, geg mas gunne-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","E-gwenadgan wisguarmargu, Jesús-sedega armalad, ar ade sogmalad, wis dargwen-ito an dakye. ");
INSERT INTO cuk09_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Escribamar-Jerusalénba-danimalad, sogdemalad: —Jesúsgi Beelzebú nai, nia-saila. Degi sogmarbalid: —Nia-saila ega gangued uksad, adi na e-nuggi niamar-oniegar. ");
INSERT INTO cuk09_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús, escribamar degi-soge itosgu, ese gochad, dagmarye. Ese nonimargu, Jesús burbar amarga sunmakded, sogded: “¿Nia-saila-Satanás na e-sordamar sunna onogo be insae? Adi suli. ");
INSERT INTO cuk09_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Deginbali, rey-gwensak na neggwebur-dakmaid, igi-dibe, e-sordamar dukin-dukin na egi aibinnarmar-dibe, ¿we-neggwebur bergussulir be insae? Bergudele. ");
INSERT INTO cuk09_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","“Aginbali, dulemar-na-neg-yagi-gudimalad, egi dukin-dukin na aibinnarmalale, ¿we-neg bergussulir be insae? We-neg bergudele. ");
INSERT INTO cuk09_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Debayobi nia-saila-Satanás na e-sordamargi aibitele, e-igar-mamaid bergudo-itole. ");
INSERT INTO cuk09_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Emigindi an bega sogmaloed, ibiga nabir niamar an onie. Ar dule-dutusulid e-neggi siile, dule-wargwen geg e-negse doged ei-ibmar atursaegar, ar bina edingweler-gebed, geb degi ei-ibmar atursaodo. Ar an deyobmodo, ar nia-sailagi an nakwisadba, sunna emi an niamar-onidiid. ");
INSERT INTO cuk09_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Degisoggu, napira an bemarga soged, galagwensuli be iskudii-dibe, ar amba galagwensuli Bab Dummadgi dodoar be sunmakdi-dibe, ar ase-bakar sunna Bab Dummad bega be-iskudiid elioed. ");
INSERT INTO cuk09_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ar doa-dule Bab Dummad Burba Nuedgi galagwensuli egi dodoar sunmaksardi, adi e-iskusad Bab Dummad gege ega elied, ar a-iskusaddi degi-eba-sadeguoed. Degisoggu, mer Bab Dummad Burba Nuedgi galagwensuli be sunmakmalo, degine, mer egi dodomarbalo.” ");
INSERT INTO cuk09_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús wegi-sogsa-gusdo, ar ade nik-sogmalad, Jesús niaburba-nikye, a-nuggi niamar-onodiiye. ");
INSERT INTO cuk09_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús dulemar-odurdaksigu, e-nan, degine, Jesús-urbamar Jesússe nonimalad. Neg-magaba gwisgunonimargu, dulemarga sogded: “Jesúsga soge, ‘Be-gwenadgan magaba be-edarbebukye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dulemar-Jesús-dikarba-bukmalad ega sogded: —Be-nan, degine, be-urbamar magaba be-edarbebukmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús, abin-sogded: —¿Doamar an-nana, degi, an-urbamala? ");
INSERT INTO cuk09_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jesús dulemar-e-dikarba-bukwad-dakdegu, sogded: —Wemar an-nangan, degine, wemar an-urbamar. ");
INSERT INTO cuk09_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ar doa-dule Bab-Dummad-igar-maidba daele, a-dulemar an-urbamalad, an-bunmalad, degi, an-nanganad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ibagwengi Jesús gannar mata-dummad-gaka-naba-sii odurdakdebalid. Dulemar-bukidar ese ambikunonisoggu, Jesús ur-digi-naidgi nakwisad, dulemardi gakagi ambikusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús urgi sii, dulemar-odurdakdebalid, bukidar ibmar-burbamaladgi sunmaksii-gusad, sogded: ");
INSERT INTO cuk09_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bemar nue itomar: Ibagwengine, dule-wargwen ibmar-gwag-digedi ibmar-gwag dignaded. ");
INSERT INTO cuk09_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ibmar-gwag dignaigusgu, abala ibmar-gwag igargi babatidapid. Sikwimar nonigua, ibmar-gwag-igargi-babatismalad manonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","“Abala akwa-yaisulidgi babatismalad, napa-askinnegwadgi. Ar agi gwae-gwae ibmar-gwag ainialid, ar ade napa-askinnegwad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dad gaargu, ibmar-gwag gummakdesunnad, ar e-maligan askinnesoggu, dinguded. ");
INSERT INTO cuk09_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","“Abala ibmar-gwag iko-abargi babatisad. Ibmar-gwag dungudgu, ikomar eba dungudmogad. Ikomar bur-bule ibmar-gwag-birgi obitesoggu, ibmar-gwag gwen sanmaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","“Ar ibmar-gwag napa-nuedgi-babatismaladdi, amardi ainiargu, dunguded, geb degi nue sanmaksad. Gwenna-gwenna akusaar sanmaksad, abala bur-nuegwad sanmaksad, deginbali, baigandi bur-napiragwad sanmaksad.” ");
INSERT INTO cuk09_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Geb Jesús sogdebar: —Bemar mag nue itobiele, nue itomar an-bemarga-ibmar-soged. ");
INSERT INTO cuk09_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Dulemar-naded-sorba Jesús-e-sapingan e-ambe-gakabo-gued, degi, e-walikaa-bukmalad Jesússe egichiarmalad, ega sogdemalad: —Be anmarga burbar sogsad, ¿ibu we nue obarsunna? ");
INSERT INTO cuk09_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús, abin-sogded: “Ar bemargardi Bab-Dummad-neg-dakmaid-igar-burbar-mamaid osanalegoye maid. Dulemar-baigangardi unnila ega ibmar burbar sunmakoye igar sogmaid, igi Bab-Dummad-gaya-burba-berbeged bato sogsa-gusa: ");
INSERT INTO cuk09_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","¡A-dulemar ise-dakar imaknai-guarmalale, mer mag dakegar. Aginbali, ise-itoar amba imakarmalale, mer mag itomalagar. Degiir, Bab Dummadse gannar namalo-itole, agi degiir, Bab Dummad e-iskudimalad ega elio-itole!” ");
INSERT INTO cuk09_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Geb degi Jesús e-sapinganga sogdebalid: “¿Burbar-an-ibmar-bemarga-sogsamaladi, amba akusunna bemar itomarmode? Degite, ¿igi an burbar bemarga ibmar-baigangi-sunmakedi mag bemar itomalosunna? Degiir an bemarga odulosunnodo: ");
INSERT INTO cuk09_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dule-ibmar-gwag-digedi, Bab-Dummad-gaya-burbagi sunmaked e-wilubgando. ");
INSERT INTO cuk09_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Bukidar-ibmar-gwag-igarba-babatismaladi dulemar-Bab-Dummad-gaya-burba-itosmalad e-wilubgando. Wemar gaya-burba itosmalanad degi-inigwele, nia-saila-Satanás e-gwagegi Bab-Dummad-gaya-burba-nued-diglesad ei-ungenonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Gwenna-gwenna baigandi akwa-yaisulidgi ibmar-gwag babatismalayobdo, napa-askinnegwadgi. Amar Bab-Dummad-gaya-burba itosmargu, nue-weligwar abingasmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ar wemar unnila askinbi Bab-Dummad-abingasmarsoggu, ibmar-gwag-digaled maligan-askinnegwadyobdo. Degisoggu, Bab-Dummad-gaya-burba-ular wilearmargu, degine, dulemar sabsur e-imakarmargu, Bab Dummadgi bangudmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Ar ibmar-gwag-iko-imbaba-babatismaladdi, we-dulemar Bab-Dummad-gaya-burba abingasmalando. ");
INSERT INTO cuk09_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ar we-napneggi-ibmar-nanaid, degi, maniginbi bur binsaed, degine, bela-ibmar-nikaa-gudigued, amar e-gwagegi dognonigu, e-binsaed galedmalad, Bab-Dummad-gaya-burba-e-gwagegi-naid iedmarsunnad. Degisoggu, amar ibmar-gwag-gwen-sanmaksasulidyob gunonisundo. ");
INSERT INTO cuk09_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Ar ibmar-gwag-napa-nuedgi-babatismaladdi, we-dulemar Bab-Dummad-gaya-burba itosmargu, e-gwagegi nue abingasmalad. Degisoggu, igi ibmar-gwag napa-nuedgi diglesar, nue sanmak-dae, debayobi amar ibmar-nuegan imaksamarmogad. Gwenna-gwenna akusaar sanmaksad, abala bur-nuegwad sanmaksad, degine, baigandi bur-napiragwad sanmaksadyob a-dulemar gunanimogad.” ");
INSERT INTO cuk09_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Degi Jesús sogdebar: “¿Ar gwallu mesa-urba siega ogalesi? ¿Degine, gabed-urba-siega gwallude ogalesi? Degisuli. Gwallu niba e-silegedgi sile-daed bela neg-mee-saegar. ");
INSERT INTO cuk09_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Deyobi ibmar bipisaale gwen dukuosurguodo. Be-ibmar-saed bela wisgulegedsegad, amba be dukuar ibmar-saoen-inigwele, bela dulemar wisguedsegad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Bemar mag nue itobiele, nue itomar, an-bemarga-ibmar-soged.” ");
INSERT INTO cuk09_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Degi Jesús sogdebalid: “Nue be binsaer-gebed, igi be Bab-Dummad-itobie. Ar ade igi Bab Dummad be itoge, abayobi Bab Dummad bega ibmar-itoged ukmogoed, degine, bur-bule mag-ibmar-ito be-imakoed. ");
INSERT INTO cuk09_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ar ade dule-ibmar-nikadga bur-bule ibmar uklebaloed. Ar dule-ibmar-suliddina, ar bipii wis ibmar-nikad aka-bur e-annik sulegoed.” ");
INSERT INTO cuk09_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Degi Jesús sogdebar: “Bab-Dummad-neg-dakmaid weyobdo: Dule-gwensak ibmar-gwag napagi digeyobdo. ");
INSERT INTO cuk09_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","We-dule wichurdo, ibiga nabir ibmar-gwag nie. We-dule gwen oakalogosurdo, gabmai-dibe, atakmai-dibe, mutikidbar-dibe, ar neg-ibginbar-dibe, we-dule gwen oakalogosurdo, na e-itoleged ibmar-gwag nidagoed, geb degi na dungudbaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","“Ar napade ibmar-gwag nabir dunguega imaked. Gebesaila e-gagan-inse aramakoed, a-sorba geb durbamakoed, geb agine sanmakdagoed. ");
INSERT INTO cuk09_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Geb ibmar-gwag nue goresale, geb weledagoed, ar ade weleged-ibagande warmaksad.” ");
INSERT INTO cuk09_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús sogdebar: “¿Bab-Dummad-neg-dakmaid igi an sogmalar-gebe, igi an nue osanalomalar-gebe? ");
INSERT INTO cuk09_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Weyobsundo: Ar igi mostaza-e-gwag napagi diglege, Bab-Dummad-gaya-burba ayobmodo. Mostaza-e-gwag napneggi bur-ibmar-gwagba bipigwadid. ");
INSERT INTO cuk09_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Degi-inigwele, mostaza-gwag-diglesad-sorba dunguderdi ibmar-dubaled-masga-gued-birgi obite-daed. E-anagan dikasur neg-gad-dasoggu, sunna sikwimar-niba-gukudimalad e-anagan-urba obunnosundo.” ");
INSERT INTO cuk09_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús dulemar-odurdakdele, burbar-sunmaksuli geg dulemar-odurdak-daed, burbar sunmakdegu-daed, mag dulemar nabir e-itogedse. ");
INSERT INTO cuk09_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wegi-burbale Jesús dulemar-odurdakdigusdo, e-sapingangardi bachikii bela osanalod-daed, na e-ibmar-sogsad we ibi nue obare. ");
INSERT INTO cuk09_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","A-ibagi neg-sedod-gusgu, Jesús e-sapinganga sogded: —Mata-dummad-abin-obakar namargwelo. ");
INSERT INTO cuk09_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ar Jesús bato urgi sisoggu, na e-sapinganba nade-gusad. Dulemar-bukidar gakagi besmalad, baigandi ur-baidgangi eba nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Igarba nadapmargu, mataba egi burwa-dummad noalid. Burwa binnasursoggu, demar-arwedba ur doged-gualid. ");
INSERT INTO cuk09_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsdi ursorba nono-onakwed-birgi nono-onakwiis gabmaid. E-sapingan Jesús-odaksamargu, ega sogdemalad: —¿Odurdaked-saila, baisur be anmar-dake anmar burgwisar? ");
INSERT INTO cuk09_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús gwisgusgu, burwaga sogded: “Be bogidik sae.” Geb degi demarga sogdebalid: “Be bogidik samo.” Burwa bogidik naded, bela neg swilidik sigisad. ");
INSERT INTO cuk09_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Geb Jesús e-sapinganga sogded: —¿Ibiga bemar yaisur dobgue? ¿Ibiga bemar Bab-Dummad-benmala? Mer Bab Dummadgi be bengumar. ");
INSERT INTO cuk09_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesús-e-sapingandi bela nue-dobe itodmalad, degi, muchub-muchub na ese egichiarmalad: —¿Wede doa-dule-sunna, burwase, degi, demarse-bakar eba ibsamargu? ");
INSERT INTO cuk09_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús e-sapinganmala mata-dummad-gaka-obakar modapmalad, Gadara-neg-nugadse. ");
INSERT INTO cuk09_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús urgi-sii aidedgu, dule-gwensak-niaburba-nikad, neg-uangi Jesús dikasur daksa, abin abarmakalid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","A-dule neg-uan na e-negga imaksa-gudiid. Dule geg gaed, eskoro-dubginse-bakar geg egi edilleged. ");
INSERT INTO cuk09_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Eskoro-dubgi e-nag, degi, e-argan edindamalan-inigwele, eskoro-dub ese itirid-daed. Degisoggu, dule geg-gae gudisunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dule-niaburba-nikad yala-imbaganba neg-uangi binnasur gordii, na dukin akwagi sarsodii oiboar daed, ar degi-osedod dabalid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesússe nonigu, yokorgi sindigar Jesús-abin signonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jesúsga binnasur sogded: —¡Mer ibgwensur be an-sao, Jesús Bab-Dummad-Bur-Dummadid-E-Machi! Napira Bab-Dummad-nuggi be anga soge, ise-mesagwar an be imakosurye. ");
INSERT INTO cuk09_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Weyob Jesúsga niaburba-nikad sogsa-gusad, ar ade Jesús ega sogsad: “Niaburba dulegi be maid be noe.” ");
INSERT INTO cuk09_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Degi Jesús a-dulese egichialid: —¿Igi be nuga? Dule, abin-sogded: —Bukidarad an nuga, ar ade anmar niamar-ichesulid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Degi niamar Jesúsgi gannar-gannar wilenagusad: —Mer dikasur anmar-barmidoye. ");
INSERT INTO cuk09_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Deunni sinmar-bukidar yar-naba mas mananaid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Niaburbamar Jesúsgi wilenagusad, ega sogdemalad: —Sinmar-bukwadse be anmar-barmid, ase be anmar-ouboge. ");
INSERT INTO cuk09_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús niaburbamar-onisgu, niaburbamar-barmisad sinmar-bukwadse. Niaburbamar sinmargi ubodapgu, sinmar-milibo yar-wereged-naba-bukwadi, mata-dummadse batenonigu, bela sinmar gundilegar burgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sin-edarbemalad dobguar duurmakdemalad, igarba nadapgu, degi, neggweburse nonimargu, bela aimarga sogdemalad, igi sinmar gusa. Dulemar degi-neg-gusad daknonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesússe nonimargu, dakarmalad dule-nia-bukidar-nika-gudii-daed nugus, mola nued yoi-sii. A-dulemar, dobe itodmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dulemar daksamalad, dule-nia-nika-gudigusad igi nugusa, degi, sinmar igi mata-dummadse bela babatis burgwisa, amar, dulemar-daksasurmaladga bela sogdemalad, igi igargan gusa. ");
INSERT INTO cuk09_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gadara-dulemar Jesúsgi nue wilenagusad, ega sogdemalad: “We-yargi-be-gudiid be nae.” ");
INSERT INTO cuk09_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús ur-naidse nonigu, dule nia-nika-gudigusad, Jesúsgi wilenagusad, eba naegar. ");
INSERT INTO cuk09_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús ega sogded: —Anba be naosur. Be-negse bur be nae, be-gwenadganse. Amarga be sogna, igi Bab Dummad nue wile be-daksa, ibiga nabir be-nudaksa. ");
INSERT INTO cuk09_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dule-niaburba-nika-gudigusad nadsun, Decápolis-yargi neggweburmar-bukwadgi sunmakdii-gualid, igi Jesús wile e-dakedba e-nudaksa. Bela-dulemar geger dakmalad ibiyobi nabir nugusa. ");
INSERT INTO cuk09_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús gannar urgi mata-dummad-gaka-baidse obaksabargu, a-mata-gaka-naba dulemar-bukidar ese nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Degi sii, Judiomar-onmaked-neg-daked-e-dummad-wargwen, Jairo-nugad, Jesússe nonikid. Jesús-dakargu, yokorgi sindigar e-asabin signonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Degi Jesúsgi nue wilenagusad, ega sogded: —An-bunagwa burgwedani maid. Anba be dage, be-argangi an-bunagwa be ebudage, adi mer burgwegar, yog nuguar guegar. ");
INSERT INTO cuk09_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Geb degi Jesús Jairoba nade-gusad. Dule-bukidar ali-ali na barmesnanai Jesúsba nade-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Dulemar-bukidar-nadapmalad-abargi ome-gwensak birga-ambe-gakabogus boni-nalur-nika-gudiid nadap-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A-ome nue wiles, na san-nunmaked abgadii ina-duledganse gusad. Aisaar nuguoeyob, inadurgan onodii, mani sabsur ukdii na san-ular gussoggu, mani bela ei bergussunnad, degisoggu wilearsunnad. Degite ome gwen bendaklessulid, aka-bur-bule ega bonigan burgumai-gualid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ome-bonigwar-gudiid, Jesús-nug bilear itoargu, emar-abargi Jesús-yarganba e-mor-duku ebugega nonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ar ade ome binsaded: “Unnila e-mor-dukubi wis an ebusale, gusbin-itole, ar yog an nuguar naoed.” ");
INSERT INTO cuk09_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ome Jesús-e-mor-duku ebusgu, e-boni yog nuguar naded. Ome magasaila na san itosad e-san nugusad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús e-burba-gangued sikwas egi node itossoggu, yog aibiris imaksad, dulemar-bukidar-bukwadse egisdesunnad: —¿Doa an-mor-duku ebusa? ");
INSERT INTO cuk09_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E-sapingan, abin-sogded: —¿Ar sunna be wisguosi doa be-ebusa, dule-bukidar be-ebilis na muchub-muchub barmesnanaid be daksursi? Be wisguosurguoe doa be-ebusa. ");
INSERT INTO cuk09_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús nue-nuu e-dikarba-bukmalad-dakdegu, aminagusad, doa e-ebusa. ");
INSERT INTO cuk09_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ome na e-san-nugusad mag itossoggu, dobe-itogedba ise-wawanmakar Jesússe nonikid, asabin yokorgi sindigar ese signonikid, bela Jesúsga sogdesunnad, igi na san gudigusad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús omega sogdesunnad: —Omegwa, be nue an-bengussursoggu, be nugussun. Be gwage-bogidikidgi be-negse be nasun, degine, be-bonigan bela bei bergussun. ");
INSERT INTO cuk09_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Amba Jesús omega sunmakgwichi, dulemar-Jairo-neggi-danimalad Jairoga sognonikid: “Be bunolo bato burgwis, mer be odurdaked-sailagi bar wilege bega be-bunolo nudakegar.” ");
INSERT INTO cuk09_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús deyob-dulemar-soge itosgu, bunolo-e-babga sogded: —Mer be bukib-binsao, unnila mer be an-benguo. ");
INSERT INTO cuk09_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús dulemar eba gwen naed imaksasulid, unnila Pedro, Santiago, agi Juan, Santiago-urba, amarbi eba-naed imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesús Jairo-negse modapgu, dulemar-dakdapid bela oimakbukwa, ise-nue-binnasur wilegar bobukwa. ");
INSERT INTO cuk09_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús neg-yaba dogdegu, amarga sogded: —¿Ibiga bemar oimakbukwa, ibiga bemar bobukwa? Bunolo burgwar maisulid, bunolo gabmaid. ");
INSERT INTO cuk09_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesús-degi-sogsad dulemar bela abin alliarmalad, egi dododmalad. Jesús bela dulemar-bukwad-onisgu, unnila bunolo-e-bab, e-nan, degi, eba-nadapmaladbi dogega imaksad, bia bunolo maidse. ");
INSERT INTO cuk09_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús bunolo argangi gasgu, e-gayaba bunologa sogded: —Talita cumi. A sogleged: “Bunolo an bega soge, be gwisgu.” ");
INSERT INTO cuk09_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Degi ega sogsagu, bunolo yog gwisgualid, geb degi yog nanaalid, ar ade bunolo yolabirga-ambe-gakabo nikad. Jesús bunolo-odulosad, dulemar geger dakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús ise-binnasur dulemar-bukwadga sogded: —Mer bipisaale aimar-baiganga bunolo-durgusad be daksamalad be sogmalo. Geb sogdebalid: —Masgi bunolo-ogunmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús Capernaumgi-gudii e-neggweburse naded, Nazaretse, e-sapingan eba nade-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Obunnoged-iba omosgu, Jesús Judiomar-onmaked-neggi emar-odurdakded. Dulemar-bukidar Jesús-ibmar-odurdaked-itobukmalad geger Jesús-itomalad, igi emar-odurdaked: Degisoggu, binsabukwa-guarmarsunnad: “¿Wede bia ibmar-durdaksa? ¿Ibiga nabir binsaed-nikarba sunmake, degi, ibiga nabir ibmar-dakledisurmalad imake? ");
INSERT INTO cuk09_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ar wede carpinter-dulesursi? ¿María-machisursi? ¿Santiago, José, Judas, Simón, amarde e-urbamarsursi? ¿E-bunmarde anmar-abargi gudimosunna? Anmar we itoged sate.” Degisoggu, sae Jesús-dakdemarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aga Jesús dulemarga sogded: —Bab-Dummad-gaya-burba-berbemalad bela neggwebur-baigangi bina nue sogdamalad, unnila e-neggweburginbi, agi e-gwenadgan, degi, e-neg-yaginmaladbi baisur dakdamalad. A-ular bemar an-abingasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Aga Jesús ibmar-dakledisurmalad dogdar gwen imaksasulid, unnila ichee wis gegumaladgi argan-mesisad, nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesúsdi geger itosunnad, ar ibiyobi na e-neggweburginmalad akusunna amba e-dakmala. A-sorba neggwebur-irba Jesús Bab-Dummad-gaya-burba-nuedgi aimar-odurdakdii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús e-sapingan-ambe-gakabo-guedse gochad, geb degi ebo-ebo barmisad, degine, gangued ega uksabalid, niaburbamar-oniegar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Amarga sogsabalid: —Bemar nasokalidba mer ibmar sedmalo, unnila gaapoledbi sedmalo. Aginbali, mer sagu sedmarbalo, mas sedosurbar, degi, manise-bakar gwen sedosurbar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Degine nag-uka unnila yoigwabi namalo, agine, mor yoigwabibar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesús e-sapinganga sogdebalid: —Ar doa-neggi bemar dogdapoe a-negginbi bemar obunnomaloed, mer neg-baid-baidgi gabdii-gumalo, neggwebur-iliba unnila neg-gwagwenginbi be gabmalo, ar a-neggweburgi geb be naedse. ");
INSERT INTO cuk09_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ar ibi-neggwebur bemar-abingassur-dibe, ar degi, bemar-itobisurbar-dibe, a-neggweburgi bemar nodele, be-naggi olli-nanaid nue eli-eli saoed, adi dulemar mag be-dakega, Bab-Dummad-igargi ega be sunmakapmoganad. Emigindi bar ese bemar dagosulid. Degisoggu, emargindo, ar Bab-Dummad-igar yapa abingamalad. Napira an bemarga soged, Bab-Dummad-igar-nabirogoed-ibagi, we-neggweburginmalad-be-abingassurmalad, Sodoma, degi, Gomorraginmaladba bur-bule sabsur odurdaklegoed. ");
INSERT INTO cuk09_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Degi Jesús-sapingan nadmargu, dulemarga sogdesun: “Be-iskunanaidga na be bukib itomar, be-daed be gwagmar, Bab Dummadse dagmarsun, adi bega be-iskued eliegar.” ");
INSERT INTO cuk09_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jesús-sapingan niamar-bukidar-onismalad, degi, dule-gegumalad bukidar nudaksamarbalid, gwallu-wawagi mage-mage imaksamargu. ");
INSERT INTO cuk09_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dulemar bukidar Jesúsgi sunmakarmalad, bela neggwebur-iliba egi sokarmalad, emi Jesús ibmar-dakledisurmalad imakdiiye, dulemar-gegumalad-nudakdiiye. Rey-Herodes dulemar-degi-soge itoarmogu, sogdemogad: “We-duledi, Juan-Bautista-an-oburgwisad, a-gannar-durgusad, aga-wede nabir ibmar-dakledisurmalad imaked.” ");
INSERT INTO cuk09_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Baigandi sogmogad: “We Elías, Bab-Dummad-gaya-burba-berbeged, a gannar gudiid.” Baigandi sogbalid: “We Bab-Dummad-gaya-burba-berbeged, igi epenne Bab-Dummad-gaya-burba-berbemalad gudidamoga, we degidmogad.” ");
INSERT INTO cuk09_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodesdi dulemar-Jesúsgi-sunmak itoargu, sogded: “We, Juan-Bautista-e-dukar-an-egwachagusad, a gudiid, we-Juan gannar durgus gudiid.” ");
INSERT INTO cuk09_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ade Herodes, Herodías-nuggine eskaryagi Juan-mete-gusad. Ar Herodíasde Felipe-omenad. Herodes e-urba-Felipegi ome-egwachad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ar ade Juan, Herodesga soged: “Be-urba-ome be nikue-wilubsulinad, ar Bab-Dummad-igargi maid, ‘mer dule-baigangi ome-egwanoye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A-ulale, Herodíasde Juan-istar-daked, igi-saele an oburgo-dibeye binsadiid. Degite geg oakalogusbardo. ");
INSERT INTO cuk09_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ar Herodes Juan-Bautista-dobe itoged, ar ade wisid, Juan dule-gwage-swilidikidid, degine, igar-napiragwadba-daed-duled. Degisoggu, Herodes Juan-bendaksadba Herodías geg Juan-oakalomosundo. Herodes Juan ega sunmakalile, nue itobidaed. Degi-inigwele, eba geg igar sabardo, ar dobed bur egi obin-daed, surbinsa ito-daed, igi bur an saer-geb-dibeye binsaar-daed. ");
INSERT INTO cuk09_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodíasdi binsadisundo, igi-saele Juan an oburgo-dibeye. Degi-binsadii ega iba nonikid, deun Herodes na e-gwalulesad-ibagi iba onosigu. Herodes ega dummaganga-gudimaladse gochad, degine, sordamar-idudimaladse, aginbali, Galilea-yargi nuga-nikamaladse. Amar bela Herodesse nonimalad, eba mas gunmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Dummagan-mas-gunbukwadse Herodías-sisgwa dognonikid, amarga dodononikid. Herodes, bunagwa-dodosad nue-yeer daksasoggu, degine, eba-mas-gunbukmarmogad nue-yeer daksamarmogad. Degisoggu, Rey-Herodes bunagwaga sogdesunnad: —Ibu be anse egisbie, an bega ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Rey-Herodes bunagwaga sogdebalid: —Napira an bega soged, Bab-Dummad-an-dakmaid-nuggi an bega soged, ar an yar-ganikid sunna amba neg-abar an bega uksabaliled, ar a anse be egiser. ");
INSERT INTO cuk09_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Bunagwa nodgu, e-nanse naded. E-nanse mosgu, e-nanga sogdapid: —¿Ibu an Herodesse egisoe? E-nan binsaded: “Emigi Juan-Bautista-oburgwed-iba nued anga nonikid.” Aga e-nan e-bunagwa-abin sogded: —Juan-Bautista-e-nono be egisoye. ");
INSERT INTO cuk09_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bunagwa ise-abarmakar Herodesse dognonigu, ega sognonikid: —Juan-Bautista-e-nono bategi emispinne be anga udagoye. ");
INSERT INTO cuk09_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rey-Herodes bunagwa-ega-sognonikid itosgu, nue bukib-binsaded, ar geg bar oakalobardo, ar ade bato Bab-Dummad-asabin sogsad, dummagan-abargi: “Napira an bega sogye, ibu be anse egisbiele, an bela bega ukoye.” ");
INSERT INTO cuk09_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Degisoggu, Herodes yog sorda-wargwenga igar ukarsunnad: —Bunagwaga Juan-Bautista-nono bategi be ega ukoye. ");
INSERT INTO cuk09_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sorda eskaryase nadsunnad. Eskaryagi Juan-Bautista-e-dukar egwachagu, Juan-Bautista-nono bategi-sii bunagwaga uknonikid, geb bunagwa e-nanga uksamosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan-Bautista-burgwisad e-sapingan wisguarmargu, e-san sunonimarsunnad, geb degi Juan-Bautista-e-san uangi digsamarsundo. ");
INSERT INTO cuk09_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","We degi-gusad-sorba, Jesús-na-e-sapingan-e-ambe-gakabo-barmis-gusad, Jesússe gannar nonimalad, ega sognonimalad, ibimala ibmar-imaksamala, degine, igi emar-odurdaksamala. ");
INSERT INTO cuk09_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús e-sapinganga sogded: —Dagmar, anmarbi bachikii, neg-dule-sulidganba wis obunnonamargwelo. Ar ade dule-bukidar na muchubmakyolasoggu, geg mas gunne-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Degisoggu, Jesús na e-sapinganmala urgi bachik nade-gusmalad, na emarbi sigegar, adi wis obunnomalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Dulemar-bukidar Jesús-naded daksamalad, degisoggu, iduar nagab duurmakde-gusmalad. A-dulemar neggweburgi nasmargu, neggweburginmalad eba akas nade-gusmarmogad. Degisoggu, Jesús modapgu, dulemar bukidar e-idu-bukwa dakdapid. ");
INSERT INTO cuk09_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús urgi aidedgu, dulemar-bukidar-e-idu-bukwad nue wile dakded, ar ade sibad-wawaad edarbed-suliyobi gudidimalad, dule-e-iduged sate. Agi Jesús Bab-Dummad-igar-mamaidba dulemar-odurdaksii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Neg-sedodgu, e-sapingan Jesússe nonikid, ega sognonikid: —Anmar neggweburgi gwen buksurmar, emide nue neg-sedodgussoggu, ");
INSERT INTO cuk09_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","dulemarga be sogsun, bemar namarsun, adi igarba sunna nabir neggwebur-bukwadse, degi, neg-gwagwen-gwagwen-mamaidse bemar madu-bakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús na e-sapingan-abin sogded: —Ar bemar ega mas-gunned ukoed. E-sapingan, abin-sogdemogad: —¿Ar anmar madu baknasunde? Dule-wargwen nii-walabaabak-arbanai-bennukleged-wilub anmar madu-baker geb unniled. ");
INSERT INTO cuk09_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús, abin-sogded: —¿Madu bule-melu bemar niksunna? Be daknamala. Amiapmargu, e-sapingan Jesúsga sognonimalad: —Madu-gwaatar, degi, ua-ukabobar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Degi Jesús e-sapinganga sogded: —Nued, gagan-ara-arad-birgi dulemar dana-dana oambikumar. ");
INSERT INTO cuk09_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dulabo-gakambe-dulabo-gakambe, degi dulatar-dulatar dana-dana oambikusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Geb degi Jesús madu-gwaataled susgu, ua-ukabogwad susbargu, niba atakde, Bab Dummadga dog-nuedye sogsad. A-sorba, Jesús madu biske-biske imasgu, ega mergud, geb e-sapinganga madu uksad, adi dulemarga madu mimmiegar. Ua-ukabogwad degi-imaksabargu, ega mergudbalid, geb bela aimarga uke-uke imakdebalid. ");
INSERT INTO cuk09_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Degine, bela-dulemar-gudidimalad nue-immeles mas guchamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mas-guchad-sorba, Jesús-sapingan madu, degi, ua-obichad garba-gwaambe-gakabo-mergu wesmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bela-dulemar-madu-guchamalad, macherganbi, miliatar gued. ");
INSERT INTO cuk09_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dulemar-mas-guchamalad-sorba, Jesús urgi e-sapingan-onakwisad, adi e-idu mata-naid obakega, Betsaidase e-idu namalagar. Jesúsdi besad, dulemar-amba-yo-namalad dakega. ");
INSERT INTO cuk09_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesús dulemar-bela-barmisgu, edi yar-birse Bab Dummadse gornaded. ");
INSERT INTO cuk09_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","E-sapingan bato mata-abala-nadapi ega dad argwated, Jesúsdi walagwen yar-birgi Bab Dummadse gorsii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús na e-sapingan ise-gammiar alamaknanai dakalid, ar ade burwa asabinnid. Wakudaryala, Jesús na e-sapinganse ali-gusad, demargi ganna-ganna danigu, bakar naoye sogsanad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesús-sapingan dule-demar-birgi-dani dakargu, binnasur gotemalad, ar ade serganye bimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Bela daksamarsoggu, egi gwakidmalad. Degisoggu, Jesús yog e-sapinganse golar imaksad, ega sogded: —Mer dobgumar, gandik samar, ani an gudiid. ");
INSERT INTO cuk09_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Degidgine, Jesús na e-sapinganse urgi nakwenonisunnad. Geb degi burwa yog bogilegar naded. Degisoggu, e-sapingan geger dakdemarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús-madu-omelosad daksamar-inigwele, degite amba akusunna dakmalad, we doa-dule, ar ade e-sapingan amba nue aku-itomalad, we-dule sunna ibmar-dakledisurmalad-imaked. ");
INSERT INTO cuk09_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús na e-sapinganmala mata-dummad obaksamargu, Genesaret-yarse modapmarsunnad, geb degi ur gakagi edichamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Urgi-bukwa aidedmargu, dulemar bato yog magasaila Jesús-dakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bukidar wisguarmargu, Jesús Genesaret-yargi gudiiye, dulemar neggweburganse duurmakdemalad, dule-gegumalad owisomalagar. Geb degi dule-gegumalad ese e-megedgi senonimarsunnad, bia Jesús siidse. ");
INSERT INTO cuk09_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ar bia Jesús nadele, neggwebur-burwiganbar-dibe, neggwebur-dummaganbar-dibe, degi, sapurbar-dibe, bela-gegumalad Jesús-iduar bia dulemar ambikue, agi iduar igargi mesis-damalad, geb degi Jesúsgi wilenagus-damalad: “Be-mor-dukubi wis an ebusar, gusbinye.” Bela dulemar-Jesús-mor-duku-ebusmalad yog nuguar gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ibagwengi Fariseomar, degi, escribamar gwen-gwen Jerusaléngi-danimalad Jesússe nonimarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Amar dakarmargu, abar Jesús-sapingan, e-dadgan-igar-maidgii argan-enuksur mas gunne, egi sunmakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ar ade Fariseomar, degi, Judio-baiganmo, e-dadgan-igar-mesisadba damalad. Amarde argan-enuksur geg mas gunmalad, bina argan enukgweler-gebed, igi e-dadgan ega igar-mete-nadedba. ");
INSERT INTO cuk09_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Fariseomar ibmar-ukleged-neggi danimalar, geg mas gunmalad, bina argan-enukgweler-gebed e-dadgan igi ega igar-mesisa, aba imakgweler-gebed. Degi e-dadgan igar-obesmalad bukidar mamaid, nog-enuked, esmed-enuked, bormogimalad-enuked, degine, na ganmar-enuked, adi Bab Dummad yeer e-dakegegar. ");
INSERT INTO cuk09_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Agala, Fariseomar, degi, escribamar Jesússe egichiarsunnad: —¿Ibiga be-sapingan anmar-dadgan-igar-maidba dasurmala? Emide igar-maidgii argan-enuksur mas gunmargu. ");
INSERT INTO cuk09_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús, abin-sogded: “Bemar wagar-darbo-daed-dulemar. Aga nabir Isaías Bab-Dummad-gaya-burba-berbeged bemar-nik sogsa-gusad, garda narmaksagu: Bab Dummad sogye: ‘Bemar unnila askinbi angi binsamalad, be gwagegi angi gwen binsasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Binsa askinbi an-nug odummomalad. Be-odurdakeddi dulemar-igar-mesedba bur odurdakmalad.’ ");
INSERT INTO cuk09_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Be-dadgan-igar-mamaid-ular Bab-Dummad-igar bemar iearmalad.” ");
INSERT INTO cuk09_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Degi Jesús sogdebar: “Be-dadgan-igar-mamaidgi bur-bule bemar binsasoggu, Bab-Dummad-igar mamaid be oakalodmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ar Moisés sogsa-gusad: Be-babgi, degi, be-nangi binsaed-nikaa damaloye. Ex. 20:12; Dt. 5:16 Degine, Moisés sogsabalid: Dule-gwensak babgi, nangi gaya-ichakwa sunmaksale, a-dule-oburgwilegoye. ");
INSERT INTO cuk09_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Bemar-Fariseomardi sogmalad, dule-wargwen e-babga, degi, e-nanga sog-dibe: ‘Geg an be-bendak, ar bela an-ibmar be-bendakoed-nikadi bato Korbán, a sogleged, Bab Dummadga ukaled.’ Bemar sogmalad, we, ibmar-nuedye. ");
INSERT INTO cuk09_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“Degi, bemar sogmarbalid, Korbánye be-babga, degi, be-nanga be sogsale, be-bab, degi, be-nan geg be bar bendakye. ");
INSERT INTO cuk09_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wegi-bemar-daedba Bab-Dummad-igar-maidba geg be damalad, egi obichaa bemar damalad. Wegiid, bukidar be-dadgan-igar-mamaidba be damalad.” ");
INSERT INTO cuk09_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Geb degi Jesús dulemarse gochasun, amarga sogdesun: “Bela nue an-itomalo. ");
INSERT INTO cuk09_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ibmar-neg-askinmalad dulegi uboder, amar dule-gwage ichogedsulid, ar gwagegi-ibmar-bukwad ainialirdi, adi dule-gwage ichogeddo. ");
INSERT INTO cuk09_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“Bemar mag nue itobiele, nue itomar an-bemarga-ibmar-soged.” ");
INSERT INTO cuk09_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús dulemar-bukidaradgi bangudgu, neg-gwagwengi dogdapid, bia na obunnomaidgi. E-sapingan Jesússe egichialid: —Wede ibi nue obare, emiskwaa be-ibmar-burbar-odurdaksigusad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús na e-sapingan-abin sogded: —¿Amba bemar akusunna itomarmode, ibmar-neg-askinmalad dulegi uboder, amar dule-ichosulid? ¿Bemar wichursi, ibmar-neg-askinmalad dulegi uboder, geg dule-gwage ichoged? ");
INSERT INTO cuk09_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ar ade gwagese ubosulid, unnila sabanse ubodap-daed, geb degi gannar ber miled-dabalid. A Jesús sognaisundo, bela mas Bab Dummadgardi ised-surye. ");
INSERT INTO cuk09_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús sogdebalid: “Ar dule-gwagegi ibmar-ainieddi adi dule-ichodo. ");
INSERT INTO cuk09_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ade dule-gwagegi binsaed-iskana ainiar-daed, dule omegibi, machergangibi damalad, atursaed, na iblomalad, ");
INSERT INTO cuk09_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ome-dikarba, degi, machered-dikarba-yolemalad, na ebi-ibmar-abeged, aimar-ibmar-bina-soged, aimargi-istar-binsaed, emar-yardaked, bingesuli-abgangi-galagwensuli-sunmaked, nobgued, gakansaerbad, na san-dummarba-saed, degine, bina-gutuu-daed. ");
INSERT INTO cuk09_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Bela wemar-ibmar-iskana dule-gwagegi ainiar-daed, adi dulemar-gwage-ichogeddo.” ");
INSERT INTO cuk09_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Genesaretgi-gudii, Jesús nade-gusad, Tiro, degi, Sidón-yarse. Dule-wargwen-negse dogdapgu, dule-gwen-e-wisgubisuli abesad, ar degite wisgulesa winakad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Bunolo-wargwen-niaburba-nikad-e-nan, Jesúsgi sunmakmar itoargu, Jesússe nonikid, yokorgi asabin yog sindigar signonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","A-omede Judio-dulesulid, Sirofeniciaginedid. A-ome Jesúsgi wilenagusad, ega sognagusad: “Nia-an-bunologi-maid anga wis be onoged saye.” ");
INSERT INTO cuk09_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ar ome Judiosursoggu, Jesús, abin-sogded: —Bina mimmigan-inse mas-gunnoye sogleged. Ar ade igar-maisulid mimmigan-mas achuga be ukoye. Mimmigan-inse bina immelegweler-gebed. We sogledo, be Judiosursoggu, an be-bendakele, mimmigan-mas achuga uknaiyob an guo-itoleye. ");
INSERT INTO cuk09_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ome, Jesús-abin sogded: —Dummad, napira be soged degi-inigwele, achumarse-bakar sunna mesa-urba-mimmigan-mas-obatemamaid gunmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús omega sogde: —Ar weyob be sogsad-ular an bega sogsunnad, be-negse be nae, nia be-bunologi-maid bato nosad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ome nadsunnad. Negse modapgu, e-bunolo e-gabedgi obunnomai dakdapid, nia-egi-maid bato nosa, nue nugus. ");
INSERT INTO cuk09_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro-yargi gudii, Sidón-yarsik biirnade gusad, geb degi Decápolis-yala-imbaganba nodapid, Galilea-mata-dummad naidse. ");
INSERT INTO cuk09_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Agi dule-gwensak Jesússe senonimalad. A-dulede uaya-yalliled, degi, naya-naya sunmakbalid. Dulemar Jesúsgi wilenagusmalad, ega sogdemalad: “Wis be nudake.” ");
INSERT INTO cuk09_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús a-dule bachikii sesad, dule-sulidba. Degi Jesús e-goo dule-bonigwaled-uaya-yaba odos imaksad, geb degi e-gogi wiaksagu, dule-bonigwaled-gwabin-duku-ebus imaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Geb degi Jesús niba atakdegu, ulubgi binnasur-bunnosad-sorba, dule-bonigwaledga e-gayaba sogded: —Efata. A sogleged, argas gue. ");
INSERT INTO cuk09_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesús degi-sogsagua, dule-bonigwaled-uaya yog argaar naded, geb degi e-gwabin yog bipinmakarbalid, nue-swilidik sunmakded. ");
INSERT INTO cuk09_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús dulemarga sogdesunnad: —Mer bipisaar dule-baiganga sogmalo, an we-dule-nudaksaye. Ar Jesús dulemarga degi-sogdele, aka-bur-bule barsogde-damalad. ");
INSERT INTO cuk09_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ibiyobi geger Jesús-dakmala, a-ular sogdemarsunnad: “We-dule ibmar-nueganbi imakdiiye. ¡Ar dule-uaya-yalliledse-bakar sunna mag-ito dule-imaked, ar degi, dule-geg-sunmakedi, sunna dule-sunmak imakbalid!” ");
INSERT INTO cuk09_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Deun dule-bukidar ambikunonibargu, Jesús dulemar-mas-gunned-suli dakargu, e-sapinganse gochad, amarga sogded: ");
INSERT INTO cuk09_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—We-dulemar wile an daked, ar ibapaagus anmarba garmakdimalad, emide mas-gunned satemalad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mas-guchasuli anmar e-negse barmidele, igarba ukudba negoedmalaled, ar ade bukidar dikasur danimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","E-sapingan, Jesús-abin sogdemalad: —Ar wede igi anmar mas-gunned ukosunna, ar wegi dule mamaisulid. ¿Bia anmar mas dakdagosunna? ");
INSERT INTO cuk09_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús na e-sapinganse egisdesun: —¿Madu gwabigwa bemar sedisunna? E-sapingan, Jesús-abin sogdemalad: —Madu-gwagugle an sedimarye. ");
INSERT INTO cuk09_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Degi Jesús dulemar napagi oambikued imaksad. E-argangi madu-gwagugled susgua, Bab Dummadse goted, sogded: “Dog-nued, we-madu be anmarga uksagu.” Geb degi Jesús madu biske-biske imasgu, ega merguded, geb degi e-sapinganga madu uksasunnad, adi dulemarga mimmiegar. ");
INSERT INTO cuk09_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aginbali, ua-burwigana ichesaar wis sedimarbalid. Jesús Bab Dummadga dog-nuedye sogsabargu, ega mergudbalid. Geb degi dulemarga mimmiega imaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Bela nue-immeles mas guchamalad. Geb a-sorba Jesús-sapingan mas-obichad garba-gwagugle wesmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bela-dulemar-milibakesaar mas guchamalad. A-sorba Jesús dulemar e-neg-e-negse barmissunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesúsdi na e-sapinganmala urgi nakwisgu, Dalmanuta-yalaganba nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseomar Jesússe nonimalad, amar Jesús abin-abin imakarmalad. Amar yamo Jesús-wilubdakega ega sogdemalad: —Be anmarga Bab-Dummad-ganguedba ibmar-wilubgan-dakledisulid anmar-wagab be imake, adi anmar mag be-dakoed, be Bab-Dummad-nuggi nue danikid. ");
INSERT INTO cuk09_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús nue ulubgi bunnodgu, nue bukib-binsa sogded: —¿Ibiga we-dulemar-emiskwamalad ibmar-wilubgan-dakledisulid e-wagab imakbi an-abege? Napira an bemarga soged, bemarga an oyogosulid bemar anse ibmar egisnaid. ");
INSERT INTO cuk09_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Degi Jesús Fariseomar-idu nade-gusad. Geb degi gannar urgi nakwisgu, mata-abin-obakar naded. ");
INSERT INTO cuk09_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús-sapingan madu-seded nue-ies nade-gusmalad, unnila madu-gwagwen urgi wis sii daklealid. ");
INSERT INTO cuk09_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús na e-sapinganga sogded: —Nue salakarmar, Fariseomar, degi, Herodes madubur-inagi. ");
INSERT INTO cuk09_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","E-sapingan na muchub-muchub egisnanai-guarmalad, ar wede ibi nue obarsunna. Sogdemalad: “Anmar madu searsulidbali wede Jesús anmarga degi-soged.” ");
INSERT INTO cuk09_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús degi-e-sapingan-soge-itosgu, ega sogded: —¿Ibiga bemar madu surye sogmala? ¿Amba bemar nue aku-itomala, magar gwen itosurmala an-bemarga-sogsad? ¿Amba be nono-seredmala? ");
INSERT INTO cuk09_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Bemar ibya nikad, degite ¿amba be aku dakmarde? Uayade bemar nikmarbalid, degite ¿amba bemar aku itomarbarde? ¿Bemar insasursi, ");
INSERT INTO cuk09_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","dule-miliatar-abargi madu-gwaataled an mimmisgu, garba-gwabigwa deun bemar madu-obichad wesmala? E-sapingan, abin-sogdemalad: —Garba gwaambe-gakabo. ");
INSERT INTO cuk09_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús sogdebalid: —Dule-milibaked-abargi madu-gwagugled an mimmisbargu, ¿Garba-gwabigwa ade bemar wesmarbali? E-sapingan, abin-sogdemalad: —Garba gwagugle. ");
INSERT INTO cuk09_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Geb degi Jesús na e-sapinganga sogdesunnad: —Degite ¿amba bemar aku-itomarde, ibi an bemarga obare? Nue aku an be-dakmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Geb degi Jesús Betsaidase nonibarsun, agi dule-wargwen aku-ataked ese senonimalad. Geb Jesúsgi wilenagusmalad, ebugegar, adi nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús dule-aku-ataked argangi gasgu, neggweburgi ega banguded. Geb Jesús dule-aku-ataked ibyagi wiaksagu, e-argan dulegi mesis imaksad, geb degi ese egichidsunnad: —¿Emigindi sunna mag be dake? ");
INSERT INTO cuk09_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dule-aku-ataked atakdegu, sogded: —Dulemar an daked, sapimar nanaeyob. ");
INSERT INTO cuk09_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús gannar na e-argan dule-aku-ataked-e-ibyagi mesisgu, dule nue-nuu atakdegu, nue nugusad, degisoggu, nue-swilidik atakdesunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús dule-nudaksad-sorba, negse dule-nugusad-barmisad, ega sogded: —Mer neggweburse be doggwelo, be-negse be nadegugwelo, degine, mer dulemarga sogbalo be nugusad. ");
INSERT INTO cuk09_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A-sorbali Jesús, degi, e-sapingan, neggwebur-burwigana Cesarea-de-Filipos-yargi-siidse, nade-gusmalad. Igarba-nadapi, Jesús, e-sapinganse egichialid: —¿Doaye dulemar an-nik sogmala? ");
INSERT INTO cuk09_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","E-sapingan, abin-sogdemalad: —Gwenna-gwenna Juan-Bautistaye be-nik sogmalad. Baigandi sogmalad, be Bab-Dummad-gaya-burba-berbeged, Elías-nugadye. Agi baigan sogmarbalid, be Bab-Dummad-gaya-burba-berbeged-gudigusad-wargwenye. ");
INSERT INTO cuk09_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús na e-sapinganga sogded: —¿Bemardina, doaye an-nik sogmarmosunna? Pedro, Jesús-abin sogded: —Be Mesías. (A sogleged, Bab Dummad epenne dule-wargwen barmidagoye-sogsad-duleye.) ");
INSERT INTO cuk09_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Geb degi Jesús na e-sapinganga binnasur sogdesunnad: “Melle dulemar-baiganga bipisaar sogoye, ede Cristoye, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-sunnadye.” ");
INSERT INTO cuk09_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Degi Jesús, e-sapingan-odurdakded, sogded: —Ani Dule-Machi, nue wileger-gebed. Judiomar-girmar-dummagan, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degine, escribamar, amar gwen an-abingaosurmalad, an-oburgwemaloed. Geb degine, ibapaagi gannar an durgubaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús wegi-ibmar-sogsadi e-sapinganga ise-bakar-bud sogsado, ede oburgwilegoye. Agi Pedro, Jesús-bachikii-sesgua, ega binnasur sogded: —Mer deyob be soge, an burgoye. ");
INSERT INTO cuk09_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús aibilisgu, e-sapingan-bela dakdegu, geb Pedroga sabsur sogded: —Nia-saila-Satanás be angi bangusun. Bab-Dummad-sunnaa be binsasulid, unnila dulemar-sunnaa be binsaed. ");
INSERT INTO cuk09_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Geb degi Jesús dulemar-baiganse gochabargu, na e-sapinganga, degine, dulemar-baiganga sogded: “Ar dule-gwensak an-sapinga gubiele, na dukin san-ieger-gebed, nakrus-semaiyob nanaer-gebed, bato burgwenadapidyob, geb a-dule anba dagodo, geb a an-sapinga guodo. ");
INSERT INTO cuk09_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Ar dule wargwen anba-naid-ular burgwebisulir, e-san-burba ei yogguodo. Ar anba-naid-ular, degi, an-gaya-burba-nued-ular, agi burgwenonikirdi, adi na e-san-burba yogguosurdo. ");
INSERT INTO cuk09_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","“¿Ar ibi-nuedga dule-wargwenga gusar be insae, a-dule napneg-naid bela egadga imaksar, ar e-san-burbadi yoggusar? ");
INSERT INTO cuk09_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aginbali, ¿dule-gwensak e-san-burba-ular ibi na uksar be insae, adi e-san-burba mer ei yogguegar? Ibmar sated, san-burba-ular ogwaed. ");
INSERT INTO cuk09_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","“Dule-gwensak neg-sichigi-galagwensuli-yolemaladyob Bab-Dummadgi-nodimalad-abargi, degi, we-dulemar-iskudimalad-abargi, an-nug-ular, degi, an-gaya-burba-nued-ular bingegusale, degi, an-osulosale, ani Dule-Machi, an-angermar-gwage-swilidikmalad-abargi, an Bab-Dummad-ganguedgi, degi, nue-yeer-dakleged-nikadgi, an danikir, an we-dulegi bingegumogoed, aku-dakye an egi sogmogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús sogdebalid: —Napira an bemarga soged, gwenna-gwenna wegi-bemar-bukmalad burgosulid, amba-dula-gudii Bab-Dummad-neg-dakmaid bela e-ganguedba dani be dakedsemalad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","A-iba-nergwad-sorbali, Jesús-yar-matusulidse bachikii e-sapingan-warbaa sesa-gusad: Pedro, Santiago, degi, Juan, amarbi eba nade-gusmalad. Yar-birgi gwichi, Jesús amar-asabin e-san-dakleged gwagde-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E-mor ise-dar sipumakar, bela dagudik dakle naded, agi dakar-dakar-gae dakle nadbalid. Ayob napneggi geg mor sibudik dule enuked. ");
INSERT INTO cuk09_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Geb agi Jesús-sapingan-warbaagwad dakdemarbalid, dulemar-epenne-dula-gudigusmalad Elías, degi, Moisés, amar Jesúsmala sunmakgwichi. ");
INSERT INTO cuk09_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Geb degi Pedro Jesúsga sogded: —Odurdaked-saila, we nueddo wegi anmar gudigu. Anmar wegi obunnoged-neg-gwapaa sobmalodo: Gwagwen bega, baid Moisésgar, geb baid Elíasgarmo. ");
INSERT INTO cuk09_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ade Jesús-sapingan bela gwakidmarsoggu, Pedro itosulid yogsaar gole-gole gwichid. ");
INSERT INTO cuk09_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Degi-bukwa, mogir emar-birgi nagunonikid, degisoggu, neg-sichii nadsunnad. Mogir-imbaba gaya-burba gollalid: —We, An-Machi-sabedi-gued, a be nue itomar. ");
INSERT INTO cuk09_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jesús-sapingan ukiar e-dikarba atakdemargu, Moisés, degi, Elías gwen bar daksasurmalad, unnila Jesúsbi walagwen-gannaa gwichi dakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yargi aidedanimargu, Jesús na e-sapinganga sogdanikid: —Mer aimarga sogmalo be-ibmar-daksamalad. Ani Dule-Machi, an burgwisar, geb gannar-an-durgusad-sorbardi geb be sogmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aga na emarbi wisi gudigusmarsunnad. Degi-inigwele, na muchub-muchub egisnanai-guarmalad, we ibi nue obarye, burgwisar gannar durguoye soged. ");
INSERT INTO cuk09_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E-sapingan Jesússe egichiarmalad: —¿Ibiga escribamar soge, Elías-inse Mesías-idu bina danigweloye? ");
INSERT INTO cuk09_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús na e-sapingan-abin imaksad: —Nabir escribamar soged, Elías-inse bina nonikoed, a bela igar-nabononikoed. Deginbali, Bab-Dummad-Gardagi sognaibalid, ani Dule-Machi, nue ise-wilegar guoye, degi, dulemar istar an-dakmaloye. ");
INSERT INTO cuk09_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ar napira an bemarga soged, bato Elíasgiid arbid, igi imakbi-gusmala, deyob imaksamalad, sabsuli wiosmalad, igi Bab-Dummad-Gardagi narmakar-naidba. ");
INSERT INTO cuk09_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesús na e-sapingan-warbaagwadmala, yar-birgi-gudiid, gulluse aidenonigu, dule-bukidar e-sapingan-ebirbukwa daknonikid. Agi escribamar, degi, Jesús-sapingan-walabakebakad-ebo abin-abin imaknanai daknonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús nonikid geger dakdemalad, geb dule-bukidar ese duurmaknonimarsunnad. Jesúsga bela sogdemalad, dog-nued anmar itoye anmarse be noniguye. ");
INSERT INTO cuk09_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús e-sapinganse egichiarsun: —¿Ibi igargi escribamarbo bemar abin-abin imaknanaisunna? ");
INSERT INTO cuk09_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dule-wargwen dulemar-abargi-gwichid gollar: —Odurdaked-saila, wegi dulemar-abargi gwichiye an be-bienad, aga bega an-machi an sedanikinad, anga nudakegar. An-machigi niaburba-geg-sunmaked egi naid. ");
INSERT INTO cuk09_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","An-machigi nia egi nagunonikir, aimukud-daed, gaya-yaba wii maku-maku guar-daed, nugar ogornagus-dabalid, degi, gannargwaa nad-dabalid. Be-sapingangi an wilenagusanad, adi ega niaburba-onogegar. Be-sapingan ega gwen nia-onossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús, abin-sogde: —¡Bemar Bab-Dummadgi-bengumalad-dulemar! ¿Sanase an bemar-abargi an gudiguosunna bemar mer an-bengumalagar? ¿Sanase mag be itomaloe? Budar an bemar-daked danikid. Machigwa anse be sedamar. ");
INSERT INTO cuk09_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Machigwa Jesússe senonimarsun. Niaburba Jesús-daksagu, machigwa goellegega imaksad. Machigwa napagi aimukusgu, napagi bindu-bindu mai, gaya-yaba wii makumakmai gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús machigwa-e-babse egichided: —¿Wede sana bei wegi-guali? Machigwa-e-bab, abin-sogded: —Bipigwad-akar daniguad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nia saalile, machigwa-oburgwega, nia imbagwen soo-yagi, degi, dii-yagi omuku-daed. Degisoggu, sunna be anmar-bendakele, wile be anmar-dake, be anmar-bendake. ");
INSERT INTO cuk09_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús, abin-sogded: —¿Ibiga be anga soge, be sunna an-bendako sogeye? ¡Dule nue-bensulile, ega sunna ibmar bela gued! ");
INSERT INTO cuk09_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Machigwa-e-bab binnasur gote, sogded: —An wisi be sunna an-bendaked an be-bensulid. ¡Be an-bendake, bur-bule mer-begi-bengued an-imake! ");
INSERT INTO cuk09_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús dule-bukidar e-dikarba ambikumai dakargu, niaburbaga binnasur sogded: —Niaburba geg-sunmak-dule-saed, degi, geg-dule-ito-sabalid, an bega soged, we-machigwagi be noe, mer gannar ese bar dognoniko. ");
INSERT INTO cuk09_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Niaburba binnasur gotegu, machigwa gannar goelleged imasgu, omukusad, geb degi egi noded. Machigwa burgwisayob megisad. Bukidar sogdemalad, machigwa burgwis maiye. ");
INSERT INTO cuk09_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesúsdi machigwa argangi gasgu, ogwichiis imaksad. Machigwa yog gwisguar naded. ");
INSERT INTO cuk09_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A-sorba Jesús e-sapinganmala nade-gusad. Geb dule-wargwen-negse dogdapmargu, e-sapingan bachikii Jesússe egichiarmalad: —¿Ibiga anmardi geg we-niaburba-onogusa? ");
INSERT INTO cuk09_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús, abin-sogded: —Wegimalad-nia geg dule onoged, unnila mas-gunsulidgi, Bab Dummadse be goler, geb be sunna onoged. ");
INSERT INTO cuk09_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesús na e-sapinganmala agi-gudii nadmargu, Galileagi nasmalad. Jesús dule gwen e-wisgubisur abesad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ade e-sapingan-odurdakdiid, ega sogdiid: —Ani Dule-Machi, dulemarse uklegoed, degi, dulemar an-oburgwemaloed, geb an-burgwisad-sorbali ibapaagi gannar an durguoed. ");
INSERT INTO cuk09_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","E-sapingan nue aku-itomar-inigwele, dobedbali Jesússe gwen egichissurmalad, wede ibi nue emarga obare, degi-emarga-soged. ");
INSERT INTO cuk09_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesús na e-sapinganmala Capernaum-neggweburse nonimargu, neg-yaba dogsagu, Jesús, na e-sapinganse egichialid: —¿Ibigi bemar na abin-abin igarba imakdani-gusmala? ");
INSERT INTO cuk09_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","E-sapingan-wargwensaar gwen abin-imaksasurmalad. Ar ade igarba na abin-abin imakdani-gusmalad, doa bur-dummadga guo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Geb Jesús sigisgua, e-ambe-gakabogwadse gochad, amarga sogded: —Dule-wargwen dule-iduedga gubiele, bela-aimar-sorbalidga guer-gebed, degi, bela-aimar-maiga guer-gebbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Geb Jesús mimmi-wargwen-susgua, e-sapingan-abargi mimmi-ogwichisad, geb Jesús e-argangi mimmi-gasgua, sogded: ");
INSERT INTO cuk09_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Ar dule-wargwen an-nuggine we-mimmigwayobid-wargwen ber nue-weligwar abingaele, an-abinganaiyob gunaido. Aginbali, dule-gwensak an-abingaele, anbi an-abingasulid, dule-an-barmialid-abinganaimodo. ");
INSERT INTO cuk09_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Agi Juan Jesúsga sokalid: —Odurdaked-saila, anmar dule-wargwen-daksado be-nuggi niamar-onodii. A-dule anmar-sordasursoggu, anmar ega sogsado: ‘Mer Jesús-nuggi bar niamar-onogoye.’ ");
INSERT INTO cuk09_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús, abin-sogded: “Mer a-dule ibe igar-bisko, ar ade dule-wargwen an-nuggi ibmar-dakledisurmalad imakdiile, a-dule geg angi ichakwa sunmaknai-gued. ");
INSERT INTO cuk09_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ar dule anmargi yoledisulile, a-dule, we anmar-sordado. ");
INSERT INTO cuk09_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“An-nuggi dule-wargwen bemarga nog-gwagwen dii uksale, bemar Cristo-sapingansoggu, napira an bemarga soged, a-dule binsa bemarga dii ukosurmalad, ar Bab Dummad a-dulega bur-bule ibmar ukoed.” ");
INSERT INTO cuk09_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús sogdebar: “Ar dule-wargwen akwamu-dummad e-dukargi-nai demar-wilase metemalar, we-dule nue-dummad wilegoed, ar burgoed. Aba-bur-bule, dule nue-dummad-wilegoed, dule-wargwen we-mimmi-burwigana-angi-bensur-gudidiid iskuega imaksar. Degisoggu, dule-ichoged-iduar, we-dulega bur-nuedirdo, akwamu-dummad dukargi-nai burgwed. ");
INSERT INTO cuk09_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Ar be-argan be-gwage ichogega imak-dibe, be-argan be siked bur nabirid. Bur nabirsursi, argan-wargwen dula gudigued, gwendi bur-beedsesursi, argan-warbo-nika soo-sailase nader, ar ade agi soo-geg-ginned-negad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","((A-neggi nusmar geg burgwed, degi, soo geg ginbalid.)) ");
INSERT INTO cuk09_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“Ar be-nag be-gwage ichogega imak-dibe, be-nag be siked bur nabirid. Bur nabirsursi, nag-wargwen dula gudigued, gwendi bur-beedsesursi, nag-warbo-nika soo-sailase nader, ar ade agi soo-geg-ginned negad. ");
INSERT INTO cuk09_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","((A-neggi nusmar geg burgwed, degi, soo geg ginbalid.)) ");
INSERT INTO cuk09_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Ar be-ibya be-gwage ichogega imak-dibe, be-ibya be onoged bur nabirid. Bur nabirsursi, ibya-gwagwen Bab-Dummad-neg-dakmaidse doger, gwendi bur-beedsesursi, ibya-gwabo-nika soo-sailase nader. ");
INSERT INTO cuk09_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A-neggi nusmar geg burgwed, degi, soo geg ginbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ar ade anmar-belagwapa balugi imaklegoedbiid, soogi wilubdaklegegar. ");
INSERT INTO cuk09_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Balu ib-nuedid. Ar balu sayee nader ¿igi be bar balu-balu gannar saosunna? Suli, degisuli. Degisoggu, balu nuedyob be gumar, degi, na be muchub-muchub bogidik gudigued be imakmarsun.” ");
INSERT INTO cuk09_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús Capernaumgi nadbargu, Judea-yalaganba nonikid, Jordán-diwar-obakar yar-naidse. Agi gudii, dulemar-bukidar ese nonimalad. Ar igi Jesús gusgu na dulemar-odurdak-dae, deyob dulemar-odurdakdebarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseomar Jesússe nonimarmogad, yamo Jesús-wilubdakegar. Ese egisnonimalad: —¿Wede sunna ome-metoye igar mai? ");
INSERT INTO cuk09_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús, abin-imakdegu, sogded: —¿Moisés igi igar bemarga mesissunna? ");
INSERT INTO cuk09_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Fariseomar, abin-sogdemar: —Moisés sogsad, sui ome-metebiele, ome-meted-garda omega ukoye, geb degi ome-metoye. ");
INSERT INTO cuk09_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús, Fariseomar-abin imakdebargu, sogded: “Bemar-uayasur-daedbali Moisés bemarga wegi-igar mesisad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ar Bab Dummaddi deyob igar-mesissulid. Bab Dummad gebesaila neg nasikargu, machered, ome-ebo abirgunagwar ogwisnonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","A-ular Bab Dummad sogsabalid: Machered ome-nikusar, e-babgi, degi, e-nangi, banguoye, adi unnila e-ome-ebo gudiguegarye. ");
INSERT INTO cuk09_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ebogwad dule-wargwennaga gunoni-daed, degisoggu, bar warbosurdo, dule-wargwennagwadyobsundo. ");
INSERT INTO cuk09_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Degisoggu, abirgunagwar Bab-Dummad-dule-imaksadi, mer na meted imakmarsun.” ");
INSERT INTO cuk09_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A-sorba, Jesús-sapinganbi bachikii neggi bukwamargu, gannar ome-meted-igargi Jesússe egichiarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús, amarga sogded: Ar doa-dule ome-mete-dibe, degi, ome-baid-nikusale, we-machered ome-dikarba neg-sichigi yolediido. ");
INSERT INTO cuk09_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Degi, ome sui-mete-dibe, sui-baid-nikusale, a-ome sui-dikarba neg-sichigi yoledimodo. ");
INSERT INTO cuk09_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesússe mimmigan-sedani-gusmalad, Jesús ega ebugegar, adi Bab Dummad nued mimmigangi binsaegar. Jesús-sapingan dulemar-mimmigan-senonimaladse uluarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús, e-sapingan dulemarse-urwenai dakargu, saebaksaar itos, e-sapinganga sogded: —Mer ese urwemar. Mimmigan be anse daged imakmar, mer be bargamar, ar Bab-Dummad-neg-dakmaid we-mimmiganyob-damaladgadid. ");
INSERT INTO cuk09_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Napira an bemarga sogmalad, ar dule-wargwen Bab-Dummad-neg-dakmaid mimmiganyob abingasulile, geg Bab-Dummad-neg-dakmaidse doged. ");
INSERT INTO cuk09_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Geb degi Jesús e-argangi mimmigan-susgua, e-argan mimmigan-birgi mesisgu, nued mimmigangi binsad sogded: “Bitigi Bab Dummad nued bemargi binsaena-gadin.” ");
INSERT INTO cuk09_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús nasokargu, dule-wargwen ese abarmaknonikid, yokorgi sindigar Jesús-abin signonikid, ese egisnonikid: —Odurdaked-saila-nued, ¿ibi an imaker-gebe, burba-geg-bergued an abingaegar? ");
INSERT INTO cuk09_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús, abin-sogded: —¿Ibiga dule-nuedye be anga soge? Dule-nued-sulid, unnila Bab Dummadbi wargwennaa dule-nued gued. ");
INSERT INTO cuk09_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ar Bab Dummad igar-mesisad be wisid: Mer dule-oburgwemaloye, mer sui-dikarba, degi, ome-dikarba yolemaloye, mer atursamaloye, mer gakansaar aimargi sunmakmaloye, mer aimar-yardakmaloye, be-babgi, degi, be-nangi nue-binsaed-nikaa be damaloye. ");
INSERT INTO cuk09_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Dule, abin-sogded: —Odurdaked-saila, gusgu an-sapingwagwad-akar bela we-igarmar-mamaidba an nanadiid. ");
INSERT INTO cuk09_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Degi Jesús dule-dakdegu, nue-sabedba ega sogde: —Ibmar-gwensak amba be napi: Be-negse be nae, bela ibmar-be-nikad manigi be uknae, geb agi mani wileganaga be mimmioed. Geb degiir be nibneggi ibmar-nued be nikuoed. Geb a-sorba anba be dagoed, an-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Degi, dule wegi-ega-soglesadba undar-naibi-itos naded, ar ade dule-mani-ibedid. ");
INSERT INTO cuk09_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Agi Jesús e-dikarba atakdegu, e-sapinganga sogded: —¡Ibiyobi dulemar-mani-ibganga Bab-Dummad-neg-dakmaidse-doged igar-dutusuli, ar ade dogdar maniginbi binsamalad! ");
INSERT INTO cuk09_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Weyob-Jesús-ibmar-sogsad, e-sapingan geger itodmalad, ar ade mani-ibgan bur-baisursunnaa abonolegoye bimalad. Degi, Jesúsdi gannar e-sapinganga sogdesunnad: —Sapingan, dule-maniginbi-dogdar-binsamaladgardi Bab-Dummad-neg-dakmaidse-doged ega igar dutusulid. ");
INSERT INTO cuk09_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ar ade moli-yargan-mureged bur-baisursunnaa iko-ibyagi doged, ar dule-mani-ibeddi bur-beedse Bab-Dummad-neg-dakmaidse doged. ");
INSERT INTO cuk09_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ar Jesús wegi-sogsabargu, bur-bule e-sapingan geger itodmalad, na dukin-dukin ese egisnanai-guarmalad: “¿Ar doa degite sunna abonolegosunna?” ");
INSERT INTO cuk09_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús na e-sapingan-dakdegu, ega sogded: —Ar dulemargardi geg gue, Bab Dummadgardi igar nollo maid, ar Bab Dummadgardi bela ibmar sunna guedbiid. ");
INSERT INTO cuk09_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Degi Pedro Jesúsga sogdesun: —¿Anmardina? Anmardi belagwapa-ibmar-obesad, adi anmar beba naegar. ");
INSERT INTO cuk09_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús, Pedro abin-sogded: “Napira an bemarga soged, dule-wargwensaar an-nug-ular, degi, an-gaya-burba-nued-ular ibmar-meter, e-neg, e-gwenadgan, e-bunmar, e-bab, e-nan, e-ome, e-mimmigan, degine, e-nainu, ");
INSERT INTO cuk09_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","we-dule dulataledba bur-bule we-napneggi ibmar abingaosurdeeye soglesulid: Negmar, gwenadgan, bunmar, nangan, mimmigan, degine, nainugan, dulataledba bur-bule abingaedsegad. Ar mesagwar we-napneggi gudiguo-inigwele, ibagan-danikoedsedi burba-geg-bergued nikuoed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","“Degisoggu, dummagan-bukidar, dule-sorbamaladga guoed, degi, dule-sorbamalad, dummaganga gumogoed.” ");
INSERT INTO cuk09_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús na e-sapingan idumai, Jerusalén-igarba nadap-gusad. E-sapingan-e-yarganba-danimalad geger dakmalad, degi, nue-dobe itomarbalid, ar ade bonigan-abarse nadapid. Jesús na e-sapingan-ambe-gakabogwadbi bachikii ese gochagua, amarga sogded e-guoed igargan: ");
INSERT INTO cuk09_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Emide anmar Jerusalénse nadapmalad, ani Dule-Machi, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse, degi, escribamarse uklegoed. Amar sogmaloed, oburgwemarye, geb degi Judio-dummagan Judiosurmaladga an-ukmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Geb degi Judiosurmalad angi dodomaloed, angi wiakmarbaloed, an-sarsomarbaloed, agi geb an-oburgwemaloed. A-sorba ibapaagi gannar an durguoed.” ");
INSERT INTO cuk09_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago, Juan, Zebedeo-machimala, Jesússe nonimalad, ega sognonimalad: —Odurdaked-saila, anmarga be ibmar ukbi anmar abedo, anmar bese ibmar egisoed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús, abin-sogded: —¿Ibi bemarga ukbi be an-abesunna? ");
INSERT INTO cuk09_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jesús-abin imakdemalad: —Yoedse bela be-ganguedgi be-ologangi be sigisale, be-sorbalidga be anmar-imake, be-dikarba anmar-sied be anmar-imake, gwensak be-argan-nuedsik, baid be-sapiledsik. ");
INSERT INTO cuk09_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Geb Jesús amarga sogded: —Bemar amba wichulid ibi anse bemar egisnai, amba be aku-itomalad. ¿Ar nue-dummad an wilegoedgi sunna bemar wilemogosi, an nog-goboedyob? Degine, ¿an-digi-oglegoedgi sunna bemar oglemogosi? A Jesús obaris-gusad, e-wilegoed, degi, e-burgoed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Degi Santiago, Juan-ebo, Jesús-abin sogdemalad: —Anmar sunnamala. Geb Jesús amarga sogded: —Eye, nabiri, an-nog-goboed sunna bemar gobmogoed, an-digi-oglegoedgi sunna bemar a-digi oglemarmogoed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ar an-argan-nuedsik, degi, an-argan-sapiledsik-sigeddi an-sogedba uklegosulid, unnila bato dulemarga-uklegoye-soglesmaladga Bab Dummad ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","E-sapingan-baigan-ambe-guedi, Juan, degi, Santiago, dummadga-gubimalad-egisnai-itosmargu, ese uludmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ar Jesúsdi na e-sapinganse gochagu, amarga sogded: “Bemardi nue wismalad, dulemar-we-napneg-dummaganga-gudimaladdi e-sordamarba bur dule-dummad na san imak-daed, degisoggu, bela-ega-ibmar-imakbi abe-damarsunnad. Degine, e-sorbarmalad gandikidba dulemar-barmidaed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","“Bemardi mer deyob gumalo, ar be dummadga gubiele, maiyob bela be dulemar-bendaker-gebed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ar be dulemar-iduedga gubiele, bela-dulemar-maiga be nanadii-guer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Ar ani Dule-Machi, we-napnegse an nonigu, mai-nikuega an nonisulid, maiyob dulemar-bendakega an nonikid, degine, an na san-burba-ukegar, adi dule-iskudimalad-anar an burgwegar.” ");
INSERT INTO cuk09_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús na e-sapinganmala Jericóse nonimalad. Jericógi bangudbargu, e-sapingan, degi, dule-bukidar e-sorba duurmaknadap-gusmalad. Deun dule-aku-ataked, Timeo-machi, Bartimeo-nugad, igarba sii, wilesakwaa mani egissii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bartimeo itoargu Jesús-Nazaretgined nadapye, binnasur gote, sogded: —¡Jesús, Rey-David-Wagwa, be an-bendake, wile be an-dake! ");
INSERT INTO cuk09_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bukidar Bartimeose uluarmalad, boo be sigye ega sogdemalad. Aka-bur-bule Bartimeo binnasur gorsigisad: —David-Wagwa, wile be an-dake. ");
INSERT INTO cuk09_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Degi Jesús gwisgusgu, sogded: —Ese gornamar. Geb Bartimeose gochamalad, ega sogdemalad: —Bartimeo, be gandik sae, be gwisgu, Jesús bese goled. ");
INSERT INTO cuk09_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Geb Bartimeo e-suba mide, yog gwisguar, Jesússe nonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús Bartimeoga sogded: —¿Ibi bega imakbi be an-abege? Dule-aku-ataked, abin-sogded: —Odurdaked-saila, ibya an nugubied. ");
INSERT INTO cuk09_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús, abin-sogded: —Be nae, be an-bengussursoggu, be nugussun. Geb agi Bartimeo yog magasaila atakar naded, degi, Jesúsba nadap-gussunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesús na e-sapinganmala Jerusalén modanimargu, bia neggwebur-Betfagé, degi, Betania sii, yar-Olivos-nugad-abin, a-inikgusgu, Jesús na e-sapingan-warbo-barmisad, ");
INSERT INTO cuk09_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","amarga sogded: —Neggwebur-bipii anmar-asabin-siidse be namar. A-neggweburgi bemar dogdapmalale, moli-bipi-uaya-suid, dule-egi-yo-gwen-siged, be-idu atinnar-nai bemar dakdapoed. Be esikmaloed, geb degi be anse sedamaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dule-wargwen bemarga sokalir: ‘¿Ibiga bemar moli-bipi-esiknanai?’ Bemar, abin-sogoed: ‘Ar Dummad we-moli-binasoged. Ebusad-sorba bega yog gannar sedabaloye soged.’ ");
INSERT INTO cuk09_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jesús-sapingan nadmarsun, geb degi moli-bipi-uaya-suid, igargi neg-dikarba, yawagak-naba atinnai dakdapmalad. A-moli-esiksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Dulemar-agi-gunanaid, ega sogdemalad: —¿Ibi bemar imaknanai? ¿Ibiga bemar moli-bipi-uaya-suid-esiknanai? ");
INSERT INTO cuk09_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús-sapingan-warbogwad, abin-imakdemalad, Jesús ega sogsadba. Geb degi moli-ibed ega moli-barmiarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesús-sapingan moli-bipi-uaya-suid Jesússe senonimarsunnad. Geb degi moli-birgi na e-mormar ogichamargu, Jesús moli-birgi sigisad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesús, Jerusalénse nadapgu, dule-bukidar Jesús-idu igargi e-mor ogitemalad, abala ogob-gagangiid-e-gagan gwane-gwane imakdemargu, Jesús-iduar igargi ogitemalad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Dule-bukidar Jesús-idu-nadapmalad, degi, sorba-danimalad bela oimakdanimalad: ¡Bab-Dummad-nug odummomar! ¡We-dule Bab-Dummad-nuggi-danikid bela ega ib-nuedga guena-gadin! ");
INSERT INTO cuk09_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Bela ib-nuedga anmarga guena-gadin, anmar-dad-Rey-David yar-ganigusadyob gannar anmarse danigu! ¡Jesús-nug nibneggi ogannomarsun! ");
INSERT INTO cuk09_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Degi Jesús Jerusalénse dogdapsun, geb agi Bab-Dummadse-goled-negse dogdesunnad. Bela a-neggi ibmar daksagu, ar neg-sedodgussoggu, Betaniase nadsunnad, e-sapingan-ambe-gakabogwadmala. ");
INSERT INTO cuk09_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Banedgine, Betaniagi noarmargu, Jesús igarba ukur itoalid. ");
INSERT INTO cuk09_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Dikasur higuera-sapi gagan-aramakbukwa dakargu, ese nade-gusad, dakega e-durba nika-dibeye. Sapi mosgu, san sate dakalid, unnila gaganbi aramakwichi, ar ade durba-nikuedginsulid. ");
INSERT INTO cuk09_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Degi Jesús higuera-sapiga sogdesunnad: —Be bipisaale bar gwen durbamakosulid. Jesús-degi-sogsad e-sapingan bela itosmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesús, e-sapinganmala gannar Jerusalénse nonimargu, Bab-Dummadse-goled-neggi dognonimalad. Jesús, dulemar-a-neggi-ibmar-baknanaid, degi, ibmar-ukbukmalad, sabsur onisad. Dulemar-mani-ogwabukmalad-e-mesa binnasur bikiin meted, degi, dulemar-nuu-ukbukmalad-e-gan bar-bikiin metebalid. ");
INSERT INTO cuk09_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Dule-wargwensaar bipisaar Bab-Dummadse-goled-neggi ibmar-seded gwen imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Agi Jesús dulemar-odurdakde, sogded: —Bab-Dummad-Gardagi narmakar naid: Bab Dummad soged: ‘An-neg bela dulemar-soga-ilaba-anse-goled-negye nugguoye.’ ¿Ar ade deyob sognaisursi? Ar emigindi, bemardi atursamalad-negga imaksamargu. ");
INSERT INTO cuk09_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar, degi-Jesús-soge itosmargu, igar-amiarmarsunnad, igi-saer Jesús-oburgwemalo-dibeye. Ar ade Jesús-dobe-itomalad, ar ade bela dulemar geger Jesús-dakmalad igi dulemar-odurdakdiid. ");
INSERT INTO cuk09_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Neg-mutikudgu, Jesús, Jerusaléngi bangudsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jesús na e-sapinganmala wakdar igarba nadapmargu, higuera-sapi bela e-malise-bakar dingugwichi dakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Agi Pedro ebinsaargu, Jesúsga sogded: —Odurdaked-saila, be dake, higuera-sapi-sae-be-ukabsasad, dinguded. ");
INSERT INTO cuk09_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús ega sogded: “¿Geger be dake? Mer Bab Dummadgi be bengumala. ");
INSERT INTO cuk09_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Napira an bemarga soged, ar doa-dule we-yarga sog-dibe: ‘Be ainir, demarse be nae,’ a-dule bensulir, e-ibmar-sogedba ega guo daker, ar a-dulega nabir ibmar guodo, yar-ainirodo. ");
INSERT INTO cuk09_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Degisoggu, bemarga an soged, Bab Dummadse be gorsigusar, bela be-ibmar-egichiid bato begadye be binsae, ar a-ibmar bato Bab Dummad bega ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Bab Dummadse be gotele, dule begi nosale, ies-imaked be sae, adi be-Bab-nibneggi-maid egi-be-nosad nabir bega elimogoed. ");
INSERT INTO cuk09_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ar bemar dule-begi-nosad ies be imaksurmalale, ar be-Bab geg be-iskusad bega elimogad.” ");
INSERT INTO cuk09_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesús na e-sapinganmala Jerusalénse gannar nonimarbalid. Jesús Bab-Dummadse-goled-neg-yaba nadapgu, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, escribamar, degi, Judiomar-girmar-dummagan ese nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Amar Jesúsga sogdemalad: —¿Doa-nuggine wede be we-ibmar-imakdii? ¿Ar doa bega gangued uksasunna, we deyob be ibmar imakegar? ");
INSERT INTO cuk09_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús, abin-imakdegu, sogded: —An bemarse ibmar-soggwen egismogodo. Bemar an-abin imaksale, geb an bemarga sogmogoed, doa we-gangued anga uksa we-ibmar an imakdiid. ");
INSERT INTO cuk09_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Doa Juan-Bautista-barmiar be insae, Bab-Dummad-digi-ogleged-igar imakega? ¿Bab Dummad barmiali, igi, dulemar barmiali? Anga be sogmalana. ");
INSERT INTO cuk09_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Degi, Judio-dummagan muchub-muchub na sogdemalad: “Bab Dummad barmiarye anmar sogmalale, anmarga sogdagoed: ‘Degite ¿ibiga bemar Juan-Bautista-bengusmarsunna?’ ");
INSERT INTO cuk09_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Dulemar barmiarye anmar sogbalile, dulemar sunna sabsur anmar-imakmaloed.” Degisoggu, degi-soged dobe itomarbalid, ar ade bela sogmalad, Juan, Bab-Dummad-gaya-burba-berbeged-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Degisoggu, Judio-dummagan Jesús-abin-sogdemarsunnad: —Anmar wichurmalad, doa Juan-Bautista-barmiali. Degi Jesús, abin-imakdemosunnad: —An bemarga sogosurmarmodo, wede doa-nuggi we-ibmar an imakdii. ");
INSERT INTO cuk09_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Degi Jesús Judio-dummaganga burbar sunmakdesunnad: “Ibagwengi dule-wargwen nainugi uva-digsado, degi, ber ebilis emaksado, agi abargi uva-egured sobsabardo, geb degi galu sobsabardo, adi agi bela nainugi nakulegegar. Nainu-ibed dulemar-arbamaladga na e-nainu urmaksado, adi a-dulemar nainugi uva wealir, e-ibedga wis ukmogoye, na deyob ebo igar-mesismardo. Nainu-ibeddi dikasur neggwebur-baidse nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Uva-weed-ibagan mosgu, nainu-ibed na e-mai nainugi-arbamaladse barmialid, adi uva-na-egadid suegar. ");
INSERT INTO cuk09_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ar nainugi-arbamaladdi nainu-ibed-e-mai ese nonigu, sabsur sarsosmalad, geb degi unni-arganagwabi gannar barmismalad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Geb degi nainu-ibed e-mai-baid-barmiarbalid. Ar adi nonogi akwagi maksamalad, geb egi dodosmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A-sorba nainu-ibed e-mai-baid-barmiarbalid, adi oburgwismalad. Deyobi maigan-ichesur nainugi-arbamaladse barmimai-gusad. Nainugi-arbamalad maigan-ese-barmilesmalad gwen-gwen sarsosmalad, agi baigan-oburgwismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Geb degi napisolabalidgi nainu-ibed na e-machi-sabedi nainugi-arbamaladse barmialid, ar ade binsaded, an-machisoggu, egi-binsaed-nikaa-damaladba gwen oakalogosurmar an insaye. ");
INSERT INTO cuk09_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ar nainugi-arbamalad, nainu-ibed-machi dani dakarmargu, na ega sogdemalad: ‘We-dule-danikidi e-bab burgwisar, nainu bela egadbi guoed, degisoggu, dagmar, we-machi-oburgwemarsun, adi nainu anmargadga guegar.’ ");
INSERT INTO cuk09_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Machigwa-gasmargu, oburgwismalad, geb degi nainu-dikarba metemalad.” ");
INSERT INTO cuk09_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús dulemar-e-itobukmaladga sogdesun: —¿Degite, nainu-ibed igi dulemar-nainugi-arbamalad-imaknoniko be insae? Nonikogu, dulemar-nainugi-arbamalad-oburgwenonikoed. Geb degi dule-baiganga na e-nainu urmaknonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ar Jesús na ede akwa-nuedyobsoggu, a-ular Judio-dummaganga sogdesunnad: “¿Ar ade Bab-Dummad-Gardagi bemarde absodisurmarsi? Bab-Dummad-Gardagi soged: Dulemar-neg-sobmalad akwa istar daksamalad, a-akwa, akwa-bur-sunsogedga gunonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","¿Ar weyob Bab Dummad akwa-imaksad, Ar anmarde geger dakde?” ");
INSERT INTO cuk09_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Judio-dummagan Jesús-burbar-ibmar-sogsad mag itosmalad, yamo emarga ibmar sognaid. Degisoggu, Jesús-gabi-guarmalanad, degite, dummagan dulemar-dobedba geg Jesús-oakalogusmalad. Ar ade Jesús-gasmalar, dulemar-bukmalad Jesús-bina uluarmalaled. Degisoggu, Jesús-mete aineba-idu nade-gusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Judio-dummagandi, Fariseomar, degi, Herodes-sordamar Jesússe barmiarmalad, adi yamo Jesús-wilubdakegar, e-sunmakedgi gaegar. ");
INSERT INTO cuk09_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Degi Jesússe nonimargu, ega sogdemalad: —Odurdaked-saila, anmar be-wisdo, be dule-ibmar-napiragwad-soged-duled, baisur be itoged igi dulemar begi binsae, ar ade begardi emarbi dulemar be daked. Degisoggu, Bab-Dummad-igar-maid, napiragwadba be dulemar-odurdakdiid. Emide ¿we igar-nuedi, Roma-Dummad-César-nugad anmargi-mani-gaed-bennuked? ¿Anmar bennukoe, igi, anmar bennukosuli? ¿Igi be sogmosunna? ");
INSERT INTO cuk09_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús we-dulemar wagar-darbo-damalad mag daksoggu, wisid yamo e-yardakdanimalad. Amarga sogdesundo: —¿Ar ibiga bemar yamo an-wilubdakdanimala? Mani anse be sedamar, adi an dakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ese mani senonimargu, Jesús ese egichided: —¿Ar wede we-manigi doa-wagar-wilub sisunna, degine, doa-nug narmakar naibarsunna? Jesús-abin sogdemalad: —Roma-Dummad-César, a-wagar-wilub, degi, a-nug narmakarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús, abin-sogdesun: —Ar ibmar Césargadir, Césarba be ibsamardo. Ar ibmar Bab Dummadgadirdi, Bab Dummadba be ibsamardo. Weyob Jesús ega soge itosmargu, dulemar-Jesússe-ibmar-egisnonimalad geger abin-itodmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceomar Jesússe nonimarmogad. Amarde sogmalad: “Dule burgwisale, gannar geg bar durguye.” Agala Saduceomar Jesússe we-igar-egisdemalad: ");
INSERT INTO cuk09_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Odurdaked-saila, Moisés anmarga Bab-Dummad-Gardagi narmakar obesad: Ia mimmi-nikussuli ome-idu burgwisale, e-urba a-ome-nikuoye, adi e-iaga anagan-urbegarye. ");
INSERT INTO cuk09_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Dakargu, machimala e-gwenadgan-walagugle-na-gumaladi weyob gusdo. Ia-dummad ome-nikusgu, anagan-urbissuli burgwisdo. ");
INSERT INTO cuk09_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A-sorbalid a-ome-nikunonimogu, amba e-iayob mimmi-nikussuli burgwismodo. Geb degi a-sorbalid amba a-ome-nikunonimogad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Deyob bela-e-walagugled a-ome-nikusmaladbiid, anagan-gwen-obessuli bela burgwismalad. Geb a-sorba ome burgwismosunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Ar dule-gannar-durguoed-iba nonikile, a-masmala gannar durgualile, a-omede, ¿wede doa-omega guosunna, bela na e-gugle-nikusmaladbiid?” ");
INSERT INTO cuk09_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Geb Jesús, abin-imakdegu, Saduceomarga sogded: “¿Bab-Dummad-Garda-narmakar-maid wichulidba, degi, Bab-Dummad-gangued wichulidba, bemar noar sogmarsursi? Eye, a-ular bemar noar sogmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ar dulemar gannar durguarmalale, ome-nikunai, degi, sui-nikunai na bar guosurmalad, ar ade angermar-nibnegginmaladyob gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“¿Ar bemar dulemar-gannar-durgued-igar Moisés-gardagi-narmakar-maid absodisurmarsi? Moisés deun sapi-bula-gummakgwichi dakargu, ese nadgu, a-abargi Bab Dummad ega sogsa-gusad: ‘Ani an Abraham, Isaac, degi, Jacob, amar e-Bab-Dummadid.’ ");
INSERT INTO cuk09_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Degisoggu, Bab Dummad dulemar-burgwarmalad-e-Bab-Dummadsulid, Bab Dummad dulemar-dula-gudidimalad-e-Bab-Dummadid. Ar Abraham, Isaac, degi, Jacob, amar burgwismar-inigwele, Bab Dummadgardi amba dula gudidimalad. Degisoggu, bemar nue-noar sogmardo.” ");
INSERT INTO cuk09_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Escriba-wargwen, Jesús nue-yeer Saduceomar-abin-imaksa itosad, Jesússe egisnonikid: —¿Bab-Dummad-igar-maid, igid bur-biriginedi? ");
INSERT INTO cuk09_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús, abin-sogded: —Igar-bur-birigined weedo: Israel-dulemar be itomar: Dummad, anmar-Bab-Dummad, abi Dummad-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dummad, be-Bab-Dummad, bela be-gwagegi be sabguoed, bela be-san-burbagi, bela be-binsaedgi, degi, bela be-ganguedgi. Dt. 6:4-5 We bur-igar-biriginedid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A-igar-sorbalid amba degisaarbalid: ¡Na be-san-sabgueyob, dule-baid be sabgumogoed! Lv. 19:18 Baid-igarmar weba bur birigined sulid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Escriba, Jesús-abin sogded: —Nued, odurdaked-saila, napira be soged, Bab Dummad unnila wargwennaa gued, ayobid baid sulid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Bela be Bab-Dummad-sabgued, bela be-gwagegi, bela be-ibmar-mag-ito-guedgi, bela be-san-burbagi, degi, bela be-ganguedgi. Degine, na be-san-sabgueyob dule-baid-sabgued, amar bur-biriginedid Bab Dummadga ibmar-gummakar-ukedba, degine, bela ibmar-baigan-ega-ukedba. ");
INSERT INTO cuk09_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús, escriba e-abin nue imaksa itosgu, ega sogded: —Bab-Dummad-neg-dakmaidgi dikasur be gudisulid. A-sorba dule-baid ibmar Jesússe gwen egisbi itonadsurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bab-Dummadse-goled-neggi Jesús dulemar-odurdaksigu, sogded: “¿Ibiga escribamar Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-nik sogsunna, a-dule Rey-David-wagwaye? ");
INSERT INTO cuk09_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ar ade Rey-David-sunnad Bab-Dummad-Burba-Nued-sogedba sogsa-gusad: ¡Bab Dummad an-Dummadga soged: ‘An-argan-nuedsik be sige, be dule-dummadga guegar, bela-be-istarmaladgi nakwedse an be-imakedsegad!’ ");
INSERT INTO cuk09_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ar David-sunnad Cristoga soged, be an-Dummadye, degite, ¿Cristo igi e-wagwaga gubarsunnoe?” Judio-dummagan gwen Jesús-abin imaksasurmalad. Ar bukidar-Jesús-itobukwa-gusmaladdi, bela nue-yeer Jesús-itobukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús dulemar-odurdakdegu, sogded: “Escribamargi nue salakarmar, mer amaryob bemar damalo. Ar amardi na yeer-ito damalad mor-oyaarmakdiir, degine, dulemar bela ese ibmar-ukleged-neggi goledbimalale, amba yeer-ito damarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Amardi Judiomar-onmaked-neggi dule-dummagan-gan-sigedginbi sigbi-damalad, degine, ibagi mas gullealir, dummagan-gan-sigedginbi sigbi-damarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","“We-escribamar yamo-yardakar ammamar-ei-sui-burgwismalad ibe neg atursa-damalad, degine, dulemar yeer e-dakegala, yamo suitii Bab Dummadse gorgwis-damalad. Ar we-escribamar bur-bule sabsur-odurdaklemaloed deyob damaladba.” ");
INSERT INTO cuk09_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús Bab-Dummadse-goled-neggi, mani-ulu-naba sii, daksii-gualid, dulemar igi ulu-yagi Bab Dummadga mani-urbenoni-damalad. Deun daksabalid mani-ibgan ulu-yagi mani-bukidar egwadnonidamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Agi mukwa-wileged-wargwen, ei-sui-burgwisad nonimogad, mani-esnon-gwabo wis egwadnonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Geb degi Jesús na e-sapinganse gochad, ega sogded: —Napira an bemarga soged, we-mukwa bur-bule ulu-yagi dule-baiganba mani-egwachad. ");
INSERT INTO cuk09_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","¿Ibiga deyob an bemarga soge? Ar baigandi mani-uksamalad, ei-gwabgusad uknonimalad, we-mukwadi belagwa-na-nika-gudiid, e-wilesagwadgine na bela uknonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Bab-Dummadse-goled-neggi Jesús nodgu, e-sapin-wargwen ega sokalid: —Odurdaked-saila, akwamar-dummagan nue be dake. Bule burwi be dake. Degine, neg yeer-daklebalid. ");
INSERT INTO cuk09_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús, abin-imakdegu, ega sogded: —Ar we-neg yeer-daklegendo, degite, wemar-neg-dummagan be dakedi, degi, wemar-akwa-dummagan be dakedi, bipisaale akwa-gwagwensaar birgi na askin-askin bar sigosulid, bela egwallegoedbiid. ");
INSERT INTO cuk09_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús Bab-Dummadse-goled-neg-ayaroedgi-sunmaksad-sorba na e-sapinganmala Olivos-yarse modapmarsunnad. A-yar Bab-Dummadse-goled-neg-asabin siid. A-yargi Jesús sigidapgu, Pedro, Santiago, Juan, degi, Andrés, arbakee ese egichiarmalad: ");
INSERT INTO cuk09_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Anmarga be soge, ¿sana degite Bab-Dummadse-goled-neg-ayarosunna? ¿Degine, we-ibagan mosar, ibi-wilubgan nibneggi oyoledagosunna? Be anmarga soge. ");
INSERT INTO cuk09_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús, abin-sogdegu, amarga sogded: “Nue salakarmar, mer dulemar be-yardaked be-imakmalo. ");
INSERT INTO cuk09_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ar bukidar yamo anyob imaknonimaloed, sognonimaloed: ‘Ani an Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule.’ A-dule, dulemar-bukidar-yardakoed, eba bukidar nagudmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Bila-onogedgibi naguar bemar itoar-dibe, degine, bila-onoged daniye, aginbi sunmakmar bemar itoarbar-dibe, mer surbinsa be itomalo, ar wegiid-igargan degi-guedsegad. Degi-inigwele, negdi amba yo dukumoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dulemar-yar-baid-baidgi-bukmalad na bila ononanai-gudamaloed, degi, reymar na muchub-muchub egi yolenanai na gudamarbaloed. Negabandur-dummagan yar-baid-baidgi nagumai-gudagoed. Ukud-dummad, degi, ibagan-bulegan nai-gudabaloed. Degi-inigwele, we-ibagan-bulegan unnila igi ome gebe e-bonigan-nunmaked itoar-daeyobdo. Ar a-sorbardi bur-bule ibagan-bulegan nonikoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Degisoggu, nue salakarmar, ar dulemar bemar-ukmaloed Judio-dummagan-igar-nabiromaladse, degine, Judiomar-onmaked-neggine sabsur be-bibyomarbaloed. Ar be an-sapingansoggu, a-ular dummagan-neg-dakmamaidse, degi, reymarse be seledmaloed, adi bemar dummaganga angi sunmakegar. ");
INSERT INTO cuk09_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bab-Dummad-gaya-burba-nued bela dulemar-yar-baid-baidgi-bukmaladga sunmaklegweler-gebed, we-ibagan-bulegan-danikoed-idu. ");
INSERT INTO cuk09_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Dummaganse bemar ebipiledele, mer bukib binsamalo, ibu an sogo-dibeye. Igar-itolenagusar, Bab Dummad bega binsaed ukoed, a be sogoed. Ar be-itolegedba be sunmakosulid, Bab Dummad Burba Nued beba sunmakoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Dulemar na muchub-muchub e-gwenadgan-oburgwega na urmaknanai-gumaloed. Bab na mimmigi aibinnai-guoed, degi, mimmigan babgangi gwisgunai-gumogoed, na oburgwenanai-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bemar an-sapingansoggu, a-ular bela-dulemar istar be-dakmaloed. Ar ibagan-bulegan-berguedse dule-gwen-galakussuliddina, adi nue abonolegodo.” ");
INSERT INTO cuk09_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesús sogdebar: “Bab-Dummad-gaya-burba-berbeged, Daniel, wegi-narmaksa, sogsado: Bab-Dummad-ibmar-istar-dakedi, Bab-Dummadse-goled-negse dognonikogu, neg-nued neg-iskanaga imakoed, ar ade a-negse dogedsulinad. Dn. 9:27; 11:31 Ani Jesús, an bemarga sogdo: Bemar deyob neg dakalile, we Daniel-sogsagusadba gunaido. Emi be-nabir-garda-absodidimalad mag ittos namaloed. Degisoggu, a-ibagi Judeagi be gudiile, yalaganba be wakinsun. ");
INSERT INTO cuk09_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ar agi dule-wargwen neg-uas-birgi siile, aidealir mer neg-yaba ibmar-oniega doged-saoed, bur yog wakinnar imakoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ar dule-wargwen sapurba gudiile, mer gannar mor-sudagegala, negse bar daged-saoed, bur yog wakinnar imakoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","“Ar ammamar-gurgin-nika-gudidimalad, degi, mimmigan-gwaruu-onunanaimaladdi a-ibagangi be nue wilemaloed, ar ade geg be abarmak-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bab Dummadse be gormarsun, we-ibagan-bulegan mer di-wied-nigi guegar. ");
INSERT INTO cuk09_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ar a-ibagangi ibagan-buled, naibi-itoleged naiguoed. A-ibagan naibi-itolegedyobid Bab-Dummad-neg-obinnisad-akar gwen itoledisulid, degi, a-sorba ayobid bar itolegosurbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ar Bab Dummad a-ibagan-wileged giar imaksasulina, dulemar a-ibagangi gwen wakinosurmalanad, bela burgwemaloenad. Emigindi Bab Dummad na e-sordamar bato nugsaar-ese-gollesmalad-sabedba a-ibagan giar nasiksad. ");
INSERT INTO cuk09_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Degisoggu, dule-wargwen bemarga sokar-dibe: ‘¡Be dakena, wegi gudii Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule!’ Degi, bemarga sokarbar-dibe: ‘¡Be dakena, weba Cristo gudibar!’ Deyob dule-bega-sogedba mer be ibsamalo. ");
INSERT INTO cuk09_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Ar ade yamo-binsa-Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duleyob, degi, Bab-Dummad-gaya-burba-berbegedyob-na-imakmalad nonimaloed. Amar galagwensuli ibmar-wilubgan imakdamaloed, degi, ibmar-dakledisurmalad imakdamarbaloed, adi dulemar-yardakegar. Amba Bab-Dummad-sunnad-na-nug-imasmaladse-bakar sunna ese yardaklegena ese yardaklesmarmogaled. ");
INSERT INTO cuk09_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Degisoggu, nue salakarmar, ar bato iduakwaa an bela bemarga sogsamalad, mer yardaklemaloye.” ");
INSERT INTO cuk09_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús sogdebar: “A-ibagangi, ibagan-naibi-itoleged-sorbardi, dad-ibeler bar gaosulid, nii bar gaosurmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Niskwamardi nibneggi-nanaid babatidagoed, nibneggi ibmar-dummagan gala-nika-nanaid bela giglimakoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Geb degine, ani Dule-Machi, mogir-imbaba bela-bela an-ganguedba, degi, bela-bela an-yeer-daklegedba dani an-dakdamaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Geb degi an-angermar an barmidoed, bela-an-sordamar-bato-nugsalesmalad anga wenaegar. Amar napneg-ugakase, degi, nibneg-ugakase bela duurmaknonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Sapi-higuera e-wilubgangi be durdakmar. Ar e-anagan dudumaksale, degi, e-gagan aramaksale, bemar nue wisid yor omodanikid. ");
INSERT INTO cuk09_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Amba deyobmodo, we-ibmarmar an-bemarga-sogsamaladi deyob guar bemar dakalir, bemar wisdo, ani Dule-Machi, an-danikid nue omosad. ");
INSERT INTO cuk09_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Napira an bemarga soged, we-dulemar-burgwed-idu, we-ibmargan bela guedsegad. ");
INSERT INTO cuk09_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nibnegdi, degi, napnegdi bela berguoed, an-gaya-burbadi gege bergued, adi degi-sadeguoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ar an-danikoed-ibadi, degi, a-wachidi dule gwen wichulid. Angermar-nibneggi-bukwamalad, degi, ani Bab-Dummad-Machi, anse-bakar gwen wichurmogad, unnila Bab Dummadbi wisid sana an danikoed. ");
INSERT INTO cuk09_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","An-danikoed-ibagan bemar wichursoggu, be nue atakmar, guagwar ambikumar, be gatik Babse gormar. ");
INSERT INTO cuk09_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“An-danikoed dule-wargwen dikasur neggwebur-baidse nasokaliyobsundo: Nasokargu, ega-arbamaladga arbaed uksagu, amarga-neg-obes nadsunnad. Degine, yawagak-dakedga sogsabalid, nue nakulegoye. ");
INSERT INTO cuk09_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Bemar neg-ibed sana-danikid wichursoggu, nue nakulemar. Neg-ibed sedogwen daniko-dibe, neg-gabgwen-dibe, gebe-gannir-namaksiidgin-dibe, igi, wakdar-dibe. ");
INSERT INTO cuk09_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Adi ukiar bemargi danikir, mer gabmai be-daknonimalagar, (debayobi an nonimogoed, dule gwen wichulid sana an danikoed). ");
INSERT INTO cuk09_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","An-bemarga-sogedi, bemargarbi an sogsulid, bela-dulemar-baiganga an sogmogad, nue nakulemaloye.” ");
INSERT INTO cuk09_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Deun Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba ibabose guoele, degi, Madu-Inasuli-Niksuli-Gulleged-Ibagi, amba ibabo-napidginmoga, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar igar-amiarmalad, igi-saele, Jesús anmar yamo-yardakar gao-dibeye, geb degi adi oburgwemalagarye. ");
INSERT INTO cuk09_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Judio-dummagan na ga sogdemar: “Mer ibagi anmar Jesús-gamalo. Degiir, dulemar Jesúsbina urwedamaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús Betania-neggweburgi gudii, Simón-naibe-buna-ya-maleged-nika-gudigusad-negse mas gunnaded. A-neggi mas gunsigu, ome-wargwen gwallu-wawaa-nuedi, nardo-nugad, gargerba-baklegedi, bute akwa-alabastro-nugadgi sii, senonikid. Ome gwallu-wawaa-bute-nono bichisgu, Jesús-nonogi a-gwallu-wawaad eosad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Gwenna-gwenna-ome-dakbukmalad uludmalad, na ga sogdemalad: “¿Ibiga binsarsunna gwallu-wawaa-nued we-ome wiosa? ");
INSERT INTO cuk09_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¿Ar wede we gwallu-wawaad manigi uklesana, dule-wargwen birgagwen-arbanai-bennuklesa-wilub uklesansursi, geb degi wileganga e-mani nabir uklesansursi?” Deyob dulemar omegi sunmaknanai-guarmalad, egi uludmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ar Jesúsdi sogded: —Mer ese achamar, we-omese mer urwemar. We-ome ibmar-imaksad dog-nued angi binsasad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dule-wileganadi gusgu bemarba gudii degi-sadeguoed, degisoggu, wilegana sunna an-sorba bemar bendakoed, andi bemarba gudigu sadeguosulid. ");
INSERT INTO cuk09_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ar we-ome ibmar-imaksad na sunna-ibmar-imakedba imaksad. We-ome an-diglegoed-iduar gusgu anmar-igar-maidba gwallu-wawagi an-magsad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","“Napira an bemarga soged, bia an-gaya-burba-nuedgi we-napneggi sunmaklegoe, we-ome-anga-ibmar-imaksadgi sunmaklemogoed, adi we-ome-ibmar-imaksadgi binsamalagar.” ");
INSERT INTO cuk09_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, Jesús-e-sapingan-ambe-gakabogwad-wargwen, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse nade-gusad, adi darba Jesús amarga ukegar. ");
INSERT INTO cuk09_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Judio-dummagan Judas-itosmargu, weligwar itoarmalad, degi, ega sogdemalad: “Anmar mani bega ukoed.” Degisoggu, Judas igar-amiarsun, igi-saele darba Jesús-uko-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Judio-ibagi, Madu-Ina-Niksuli-Gulleged-Iba gebe-onodedgi, degi, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi sibad-wawaad-oburgwile-daed-ibagi, e-sapingan Jesúsga sognonimalad: —¿Bia anmar guagwar bega neg-amimaloe, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi mas-gulleged mas gunnega? ");
INSERT INTO cuk09_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Degi Jesús na e-sapingan-warbo-barmisad, amarga sogsad: —Neggweburse be namar. Agi bemar dule-wargwen-dakdapoed gwidugi dii semai, a-duleba bemar namaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","A-dule bia dogdapoe, a-neg-ibedga bemar sogmaloed: ‘Odurdaked-saila sogye: Bia an sapinganmala Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi mas-gunnoed-neg siiye.’ ");
INSERT INTO cuk09_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Neg-ibed neg-dummad guagwar bato nue-saale, niba-ailabirgi bemarga oyogoed. Agi guar bemar anmar-idu mas urbemaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesús-sapingan-warbogwad neggweburse nadmarsun. Neggweburse modapmargu, ar igi Jesús emarga sogsa, deyob dakdapmalad. A-neggi ibagi na mas gunmalaga, bela ibmar guagwar urbismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A-ibagi neg-mutikudgu, Jesús, degi, e-sapingan-ambe-gakabogwadmala nonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mesa-naba ambikunonimargu, mas gutemalad. Agi Jesús na e-sapinganga sogded: —Napira an bemarga soged, bemar-wargwen-anba-mas-gunsiidi darba an-ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A-ular e-sapingan wile itodmalad, Jesússe gwenna-gwenna na egisdemarsunnad: —¿Ani an be-ukoye? Sur an insado. Degi baid sogdemogad: —¿Ani an be-ukoye? Sur an insado. ");
INSERT INTO cuk09_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús, na e-sapingan-abin sogded: —Bemar ambe-gakabogwad-wargwen anba-bategi-madu-wara-saoed, a darba an-ukoed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Napira an bemarga soged, ani Dule-Machi, ar igi Bab-Dummad-Gardagi angi narmakar nai, ar deyob an guoed, an burgoed. Ar dule-darba-an-ukoeddina nue wilegoed. A-dule gwalulessulina bur nabirindo. ");
INSERT INTO cuk09_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mas gunbukmargu, Jesús madu-susgua, Bab Dummadga dog-nuedye sogsa-gusad. Geb a-sorba Jesús madu biske-biske imaksad, e-sapinganga ukde, sogded: —Be sumar, we-madu an-sanad. Jesús na e-sapinganmala we-madu guchamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A-sorba Jesús nog-susbalid. Bab Dummadga dog-nuedye sogsabargu, e-sapinganga ukdebalid, agi e-sapingan bela gobsamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Geb degi Jesús e-sapinganga sogded: —We, an-abe. An-abe Bab Dummad dulemarbo igar-bini-mesnaid-wilubganad, degi, an-abe dulemar-bukidar-ular milegoed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Napira an bemarga soged, emigindi, uva-nisdi we-sorba bar an gobosulid, Bab-Dummad-neg-dakmaidse geb an gobdapaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bab-Dummad-nuggi namaksamalad-sorba, Olivos-yarse nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Geb degi, Jesús na e-sapinganga sogded: —Belagwapa emi-mutik bemar angi bangudmaloed, ar ade Bab-Dummad-Gardagi narmakar naid, sognaid: Sibad-wawaad-edarbed an oburgoed, Geb agi sibad-wawaad bela duurmakdoed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jesús sogdebar: —Geb gannar an durgusad-sorba, bemar-idu Galilease an naoed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Geb degi Pedro Jesúsga sogded: —Bela begi bangudmalale, andi begi gwen banguosulid. ");
INSERT INTO cuk09_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús, Pedro-abin sogded: —Napira an bega soged, emi-mutiki, gannir-ilabo-namaked-iduar, ilapaa be an-osulogoed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ar Pedro aka-bur-bule sogded: —Ar an beba burgweye sogele, amba an be-osulogosulid. E-sapingan-baigan bela degibi sogdemalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesús na e-sapinganmala Getsemaní-neg-nugadse nonimalad. Agi e-sapinganga Jesús sogded: —Wegi bemar ambikumar, andi Bab Dummadse bina gorgwelo. ");
INSERT INTO cuk09_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Unnila Pedro, Santiago, degi, Juan, amarbi eba sesa-gusad. Agi Jesús na nue-wilegoedba nue-wile itoalid, degi, nue-surbinsa itoarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Agi Jesús na e-sapingan-walapaagwadga sogded: —Andi an ulubgi nue-bukib an itogedba sunna an burgwisar an itoged. Wegi be ambikumar, nue atakmalo, Bab Dummadse be gormalo. ");
INSERT INTO cuk09_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús sikwas nadgu, yokorgi sindigar napagi dulluu sigdapgu, Bab Dummadse gorsigisad, bitigi ega sunna egi-nunmaked-danikoed ega osulogena-gadinye. ");
INSERT INTO cuk09_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jesús Bab Dummadse gorsigu, wegi sogded: “An-Bab, begardi bela ibmar sunna guedbiid. An-idu igar-buled naid, ina-gaibid gobedyob beedse an egi wilegoed, be anga osuloge, degite an-sogedbarsur, unnila, be-sogedbarbi be imaksun.” ");
INSERT INTO cuk09_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jesús Bab-Dummadse-gorsiid bergusgu, na e-sapinganse nonikid, daknonikid bela gabmamai. Geb degi Jesús Pedroga sogded: —¿Simón, be gabmai? ¿Wachi-irgwensaar Babse golega wis geg be atake? ");
INSERT INTO cuk09_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nue atak, Bab Dummadse be gole, adi iskuedgi wilubdakleged mer bemarse warmakmalagar. An wisi bemar burbadi Babse golega guagwar gudiid, bemar sandi degisulid, adi nolloo gued. ");
INSERT INTO cuk09_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús gannar nadbargu, gannar Bab Dummadse gotebalid, gannar idu-sogsadgii sogdebalid. ");
INSERT INTO cuk09_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesús Bab-Dummadse-gorsiid bergusgu, gannar na e-sapinganse nonibargu, daknonikid gabmamai, ar ade gabed nue egi obin-itomalad. E-sapingandi nue gabmamai Jesús odaksasoggu, wichurmarsunnad, igi abin-sogmaloe. Geb degi Jesús gannar nadbalid Babse golegar. ");
INSERT INTO cuk09_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jesús ilapaagus gannar e-sapinganse nanaedgine, amarga sogdesunnad: —Bemar gabmarsun, bemar obunnomarsun. Bergussun, wachidi omossun. Emigindi, ani Dule-Machi, dulemar-iskudidimaladse darba ukle-sokarsunnad, adi an-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Degisoggu, bemar gwisgumarsun, namarsun, dule-darba-an-uksaddi bato anmar walikgusad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús amba e-sapinganga sunmakgwichi, e-sapingan-warambe-gakabogwad-wargwen, Judas-nugad, ese nonikid. Aba dule-irwa-Babse-gormalad-e-dummagan, degi, escribamar, degine, Judiomar-girmar-dummagan, dulemar-bukidar-barmiar-gusmalad. We-dulemar-bukidar espunyar-yalaba, degi, suarmar-annik-annik Judasba duurmakdani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, Jesús-darba-uksadi, dulemar-nonimalad-ebo igar-nabosad, ega sogsad: “Ar dule-e-wagar an uoed, ega sogegar, be nued sogeye, a-dule be gamaloed, degi, nue a-dule bemar sedmaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas nonigu, Jesússe naded. Jesús-walik gwisgudapgu, ega sogded: —Odurdaked-saila. Geb degi ei-wagar usa imaksad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Degi dulemar Jesússe achadmargu, Jesús-gasmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ar e-sapin-wargwen Jesús-naba-gwichidi, espunyar onosgu, dule-irwa-Bab-Dummadse-gormalad-bur-dummad-e-mai naibi imaksad, e-uaya ei siksad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús dulemarga sogded: —¿Ibiga bemar dule-iskana-ibmar-atursaedyob an-gadanimala, emide espunyar, degi, suarmar-yalaba bemar an-gadanimargu? ");
INSERT INTO cuk09_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Bane-bane bemarba an gudigusad, Bab-Dummadse-goled-neggi dulemar-odurdakdii, degite, agindi bemar gwen an-gassurmalad. Emigindi ar igar-maidbali, adi Bab-Dummad-Gardagi-narmakar-naidba guegala, bemar an-gamaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Degi Jesús-sapingan, Jesús wargwen mete, e-idu bela duurmakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Deun sapingwa-wargwen Jesúsba nadap-gusmogad. A-sapin mor yoi-suli, unnila atuedgi e-san-bipirmakar eba nadap-gusad. A-sapin-gasmargu, ");
INSERT INTO cuk09_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","binnasur guar, atued-mide, nabir aimargi noded, uka-swiri abarmakde-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dulemar-Jesús-gasmaladi dule-irwa-Bab-Dummadse-gormalad-bur-dummadse Jesús-senonimarsunnad. Agi bela dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan, degi, escribamar, bela ambikunonimalad Jesúsga igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedrodi bannabasaar Jesúsba nadap-gusmogad, dule-irwa-Bab-Dummadse-gormalad-bur-dummad-neg-imbase warmakdapid. Pedro suar-ibmalad-imbagi sigdapid, wis na soogi wadapmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, bela-Judio-dummagan-igar-nabiromalad, igar-aminanai-guarmalad, igi-saele Jesús-nodiid amimalo-dibeye, adi Jesús-oburgwemalagar. Degite gwen amissurgusmalad, bia Jesús nodiid. ");
INSERT INTO cuk09_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ar ade bukidar Jesúsgi istar sunmaknanaid, bela yamo-gakansaar ibmar sognanaisoggu, na gwen balillaa sogsasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Gwen-gwen gwisgusgua, yamo-gakansaar sogdemalad: ");
INSERT INTO cuk09_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Anmar we-Jesús soge itosmarye: ‘We-neg, Bab-Dummadse-goled-neg-siid, dulemar-sobsadi an earoye. Geb degi ibapaagi Bab-Dummadse-goled-neg gannar an soboeddina, dulemar-sobsulid an soboye.’ ");
INSERT INTO cuk09_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ar degi-sognanaimalad na degite balillaa gwen barsogsasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad, dummagan-abargi gwisgusgu, Jesúsga sogded: —¿Be dulemar-abin-imakosuli? ¿Ar wede igi be sogmosunna, begi sunmaknanaidgi? ");
INSERT INTO cuk09_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús bipisaar gwen abin-imaksasulid, degi, gwen akar sogsasurbalid. Dule-irwa-Bab-Dummadse-gormalad-bur-dummad Jesússe-ibmar-egichided, gannar ega sogded: —¿Ar be Cristo, Bab-Dummad-Bur-Odummolediid E-Machi-sunnadi? ");
INSERT INTO cuk09_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Degi Jesús, abin-sogded: —An aado. Ani Dule-Machi, bela-Bab-Dummad-gangued-nikad e-argan-nuedsik dule-dummadga-an-sii be an-dakmaloed, degine, nibneggi mogir-imbaba-dani be an-dakmarbaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Geb degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad e-mor na esirmaksad, oyogegar Jesús-degi-sogsad ede sae-itoye, Bab Dummadgi dodoguye. Degi dummaganga sogded: —¿Ar ibiga e-barsogmalad anmar bar abesunna? ");
INSERT INTO cuk09_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ar bemar-sunnad na itosmalad we-Jesús Bab-Dummad-nuggi dodosad. ¿Igi bemar itomarmosunna? Dummagan-igar-itobukmalad belagwapa sogdemalad: —Oburgwed ega igar-maid, degisoggu, nue-oburgwed imakmarsun. ");
INSERT INTO cuk09_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Gwenna-gwenna Jesúsgi wiakdemalad. Jesús-ibya-edusar, geb bibyosar, ega sogde-damalad: —Ar bela be ibmar wissoggu, emigi be sogena, ¿doa be-sarsosa? Jesúsdi dulemar-gwen-abin-imaksasulid. Agi suar-ibmala wagargi Jesús-bibyonai-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro aila-urba neg-imbagi sii, dule-irwa-Bab-Dummadse-gormalad-bur-dummadga-bunagwa-arbaed nonikid. ");
INSERT INTO cuk09_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bunagwa Pedro soogi wasii dakargua, nue-nuu dakdegu, ega sogded: —Jesús-Nazaretginedba be gudidamogad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro bunagwa-abin-osulod, sogded: —Aku an ito ibi be anga obare, degine, a-dule aku an dakbalid. A-sorba Pedro magaba-noed-yawagakse nadgu, gannir namakded. ");
INSERT INTO cuk09_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bunagwa gannar Pedro-dakarbargu, dulemar-bukmaladga sogded: —We-dule Jesúsba-gudii an daksamogad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro gannar osulodbalid. Degine, sikwas sanargusadgine Pedro-dikarba-gwigwismalad Pedroga sogdemarmogad: —Napira an bega soged, be Jesús-sordamogad, ar be Galilea-dolad, degi, be-sunmakedi a-dulemargii be sunmakmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Geb degi Pedro ukabsaar ibmar sokalid, degi, sogdebalid: —Bab-Dummad-nuggi napira an bemarga soged, we-dulegi-bemar-sunmaknanaid an aku daked. ");
INSERT INTO cuk09_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Degi-sogsagu, ilaboguddo gannir namaked. Agi Pedro ebinsaas-naded igi Jesús ega ibmar sogsad: “Gannir-ilabo-namaked-iduar, ilapaa be an-osulogoye.” Pedro deyob Jesús-ega-sogsad insadgu, ise-boar naded. ");
INSERT INTO cuk09_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wakudaryalaba, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan, degi, escribamar, bela Judio-dummagan-igar-nabiromalad igar-itosmargu, argan-edinnar Jesús-sesmalad. Geb degi Pilatoga Jesús-uksamarsunnad, ega igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Geb Pilato Jesússe egichided: —¿Ar be Judiomar-E-Rey? Jesús, abin-imakdegu, ega sogded: —Ar bede soged. ");
INSERT INTO cuk09_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan sognanai-guarmalad, Jesús igar-iskana imakdiiye. ");
INSERT INTO cuk09_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato gannar Jesússe egichided, ega sogded: —¿Be dulemar-abin imaksuli? Be dake bule begi sognanai, bede ibmar-iskana imakdiiye. ");
INSERT INTO cuk09_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Degite, Jesús bipisaale gwen abin-imaksasulid. Degisoggu, Pilato geger daksunnad, ar ibiga-wede Jesús dulemar-abin imaksuli. ");
INSERT INTO cuk09_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dakleargu, ibagi Pilato gusgu Judiomar-egismaladba dule-wargwen-eskaryagi-mellesiid ega ono-daed. ");
INSERT INTO cuk09_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Agine, dule-wargwen, Barrabás-nugadi, e-sordamarmala eskaryagi deun mellesii-gusad. Ar ade amar Roma-dulemargi gwisgusmargu, neg-oimakdii dulemar-oburgwis-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dulemar-bukidar Pilatose nonimalad, ese egisnonimalad, dule-wargwen-eskaryagi-mellesiid igi gusgu Judiomar-ibagi ega ono-dae, deyob ega onobaligar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato dulemar-abin-imakdegu sogded: —¿Judiomar-E-Rey bemarga onobi be an-abemala? ");
INSERT INTO cuk09_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ar ade Pilato wisid, dule-irwa-Bab-Dummadse-gormalad-e-dummagan binsa Jesúsgi-nobmaladbali ega uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Dule-irwa-Bab-Dummadse-gormalad-e-dummagandi mer-Jesús-onogegala yamo dulemar-ibe-binsaed-gasmalad, adi Barrabás-onomalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato dulemarse gannar egisdebarsunnad: —¿Judiomar-E-Reyye bemar biedi igi imakbi be an-abemarsunna? ");
INSERT INTO cuk09_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dulemar Pilato-abin-oimakdemalad: —¡We-dule nakrusgi bioke! ");
INSERT INTO cuk09_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato, dulemar-abin-sogded: —¿Ar degite, we-dulede ibu-ibmar-iskana wede imaksunna? Agi dulemar bur-bule oimakdemalad, sogdemalad: —¡We-dule nakrusgi bioke! ");
INSERT INTO cuk09_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato nabir-dulemar-ito imakbisoggu, Barrabás ega onossunnad. Jesúsdi sabsur-bibyosad-sorba suar-ibmalaga uksasunnad, adi nakrusgi bioknamalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Degi suar-ibmala Jesús-sesmarsunnad Pilato-neg-Pretorio-nugad-imbase. Agi suar-ibmala bela e-sordamar-danagwenad Jesússe ambikunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Geb degi suar-ibgan mor-suir-akwagiid, reygadgiid, geb Jesúsga yosmalad, degi, e-nonogi iko-gurgin-sobaled sismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Geb degi yamo Jesúsgi dodonagusmalad, binnasur gotemalad: —¡Be Judiomar-E-Rey, suibaksaar be ani gudigusana-gadin! ");
INSERT INTO cuk09_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A-sorba nonogi suargi Jesús-sarsosmalad, degi, egi wiaksamarbalad, agi yamo yokorgi sindigar Jesús-abin signoni-damalad, yamo e-nug odummonaiyob. ");
INSERT INTO cuk09_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Suar-ibgan Jesúsgi-dodosmalad-sorba, mor-suir-akwagiid ega esusmalad, adi e-mor ega gannar yomalagar. Geb degi Jesús-sesmarsunnad, nakrusgi biokmalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Suar-ibgan igarba Jesús-semaigu, dule-wargwen Jerusalénse-dani abinguarmalad. A-dule dakargu, Simón, Cirenegined. A-dulede Alejandro, degi, Rufo-e-bab. Suar-ibgan a-dule gannar-obirismalad ise-barmiar Jesúsga nakrus-seega imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gólgota-neg-nugadse Jesús-sesmarsunnad. Gólgota sogleged, Dule-Nonogar-Nega. ");
INSERT INTO cuk09_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","A-negse modapmargu, vino ina-gaibidgi oburaledba suar-ibgan Jesús-ogobdemalad, adi dogdar mer wis nunmaked itogegar, ar Jesúsdi gwen abin-gobsasulid. ");
INSERT INTO cuk09_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Suar-ibgan nakrusgi Jesús-bioksamargu, Jesús-morgi dodoarmalad, na wilubdaknai-guarmalad, igid Jesús-mor na emargadga guo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dakargu, deun dad-abar-dummad-gusad, Jesús nakrusgi bioksamargu. ");
INSERT INTO cuk09_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","E-nakrus-birgi narmaksamalad, ibiga Jesús burgwenai. Narmakaled weyob sognaido: ");
INSERT INTO cuk09_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Geb degi suar-ibgan dulemar-atursamalad-warbo nakrusgi bioksamarmogad. Wargwen Jesús-nakrus-argan-nuedsik ogwichismalad, baiddi Jesús-nakrus-argan-sapiledsik. ");
INSERT INTO cuk09_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Igi Bab-Dummad-Gardagi Jesúsgi narmakar nai, degi-sognaidba gunonikid: Dulemar-gwage-iskudimaladyob we-dule-dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dulemar-Jesús-dikarba-nasdamalad ise-dodoar egi nas-damalad, yamo ega nono-ege-ege gunadap nas-damalad, ega sogde-damalad: —¡Yaped! Be Babse-goled-neg-e-aroedi, degine, ibapaagi-gannar-sobbaloedi, ");
INSERT INTO cuk09_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","na be-dukin bendak-den, nakrusgi-naid be aideda-den. ");
INSERT INTO cuk09_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Amba deyob dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar Jesúsgi dododmarmogad, na ga sogdemalad: —We-Jesús, dule-baigandi nabir bendaksad, edi dukin na geg bendaked. ");
INSERT INTO cuk09_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ar ede Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dulele, Israel-Dulemar-E-Reyle, nakrusgi-naid aideda-den, adi anmar dakegar, geb agi anmar egi benguosulid. Jesúsba-nakrusgi-bioklegar-naimarmogadse-bakar egi dodonanai-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dad-yorukugusgu, bela-napneggi neg-sichid nagunonikid, wachi-irbaase naigusad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wachi-irbaa gusgu Jesús binnasur gote, sogded: —Eloi, Eloi, ¿lama sabactani? A-sogleged: An-Bab-Dummad, An-Bab-Dummad, ¿ibiga be angi bangusa? ");
INSERT INTO cuk09_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jesús-nakrus-walik-bukmalad gwena-gwena Jesús degi-soge itosmargu, sogdemalad: —Be itomar, wede Elíasse gornaid. ");
INSERT INTO cuk09_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Degi dule-wargwen abarmakded, vino-gaibidgi ibmar-buta-butadi owardikusad, geb suar-dukugi edichagu, Jesúsga ukded, adi suk-suk saegar. Geb degi dule sogded: —Mer ese achamar, dakmalo, bule Elías odenoniko-dibe. ");
INSERT INTO cuk09_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Geb Jesús napi binnasur gotegu, burkwis naded. ");
INSERT INTO cuk09_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Deun Jerusaléngi, Bab-Dummadse-goled-neggi, Neg-Islidikid-irwa mor-naid niba achirmakde urbalidse-bakar gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Degi, Roma-suar-ibed, sordamar-dulatar-sediid, daksad Jesús binnasur-gochad-sorba igi burgwisa, a-dule sogded: —We-dule, nue Bab-Dummad-Machi-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bannabasaar omeganmo Jesús-dakbuk-gusmarmogad. Amar-omegan-abargi gwichi-gusmogad: María-Magdalena, degi María, Santiago-bipigwad-e-nan, a, José-e-nanbalid, degi, Salomé, geb omegan-baiganmo. ");
INSERT INTO cuk09_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","We-omegan, Jesús-Galileagi-gudidagu, gusgu Jesúsba gudidamarmogad, degi, ega ibmar-imakdii-gusmalad. Degi, bukidar omegan-baigan-Jesúsba-Jerusalénse-nonimalad, dakbukwa-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Deun a-ibagi Ibmar-Guagwar-Sied-Ibad, bato obunnoged-iba warmakdanisoggu, neg-sedodgu, ");
INSERT INTO cuk09_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José, Arimatea-neggweburgined, Pilatose nade-gusad. A-Joséde Judio-igar-nabiromaladgi nue nug-nikmogad, Bab-Dummad-neg-dakmaid nue edarbedimogad-dulemogad. Joséde Pilatose dobsuli nonikid, Jesús-e-mui-egisnonikid, adi neg-uanse dignaegar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato, abin geg-itoded, bato Jesús burgwisad. Degisoggu, Roma-sordamar-dulatar-sediidse gochasunnad, agi ese egichided, bato Jesús burgwis sogeye. ");
INSERT INTO cuk09_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Roma-sordamar-dulatar-sediid, Pilatoga bela ibmar sogsagu, Pilato Joséga igar-uksasunnad, Jesús-mui-sedegar. ");
INSERT INTO cuk09_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Degi, José atued-binid baksagu, Jesús-mui nakrusgi-naid odesad, geb degi atued-sipugi nue obipirmaksad. Geb degi José akwa-gwisar-neg-uanga-siid-yaba Jesús-mesisad. Geb degi José akwa-dummad neg-uan-yawagakse obaparmasgu, akwa-dummad yawagak-idu sisad. ");
INSERT INTO cuk09_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María-Magdalena, degi, María, José-e-nan, daksamalad bia Jesús diglesad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Obunnoged-iba nasgu, María-Magdalena, degi, María, Santiago-e-nan, agi Salomé, amar gwallu-wawagwad-nuegan baksamalad, adi Jesús-muigi eomalagar. ");
INSERT INTO cuk09_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Itoged-iba-gebe-nagudedgi, wakudaryalaba, geb dad-nakwialidgi, neg-uanse omegan nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Igarba na sunmaknadapmalad: —¿Wede doa anmarga akwa-dummad, neg-uan-yawagakgi-siid onirosunna? ");
INSERT INTO cuk09_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Neg-uan mosmargu, dakarmalad bato akwa-dummad-neg-uan-yawagakgi-siid onirar-sii. ");
INSERT INTO cuk09_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Omegan neg-uan-yaba dogdemargu, sapin-gwensak Jesús-mai-gusad-argan-nuedsik sii dakarmalad, mola-sibu-suid-yoi sii. Deyob dakarmargu, omegan egi gwakidmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sapingwa omeganga sogded: —Mer bemar dobgumar, an wisi bemar Jesús-Nazaretgined-nakrusgi-biokles-gusad-amidanimalad. Jesús wegi bar maisulid, bato gannar durgusad. Bemar dakena, bia Jesús-mai-gusad e-gannar. ");
INSERT INTO cuk09_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bemar namar, e-sapinganga sognamar, Pedroga: ‘Jesús bemarga sogsadgii, bemar-idu Galilease nadye. Ede agi bemar dakoye-sogsa nadye.’ ");
INSERT INTO cuk09_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Omegan neg-uangi noarmargu, duurmakdemalad, ar ade wawanmakdemalad, gwakidmalad. Ar nue-dobe itomarsoggu, dulemarga gwen sogsasurmalad, Jesús-durgusad-igar. ");
INSERT INTO cuk09_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","((Jesús wakudaryalaba durgusad-ibagi, gebe-itoged-iba-nagudedgi, gebesaila María-Magdalenase na san magarosad. A-omega Jesús nia-walagugle-onos-gusad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A-ome nadgu, dulemar-Jesúsba-bipirmakdigusmaladse modapgu, a-dulemar bukib-binsabukwa, degi, bobukwa, dakdapid. Geb María-Magdalena amarga sogded, Jesús durgusye. ");
INSERT INTO cuk09_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ar amar Jesús dulaye itoarmargu, degi, an daksaye María-Magdalena amarga soggu, bengudmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A-sorba Jesús, e-sapingan-warbo-sapurba-nadapidse na e-san-gwagsad magarosbalid. ");
INSERT INTO cuk09_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Amar-warbogwad, Jerusalénse gannar nonimargu, e-sapingan-baigan-owisononimalad, Jesús-ese-magarosad-igar. Degite e-sapingan amarse-bakar gwen itossurmalad, ar bengudmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Degid-sorbali e-ambe-gakagwensakad mas-gunbukwadgine, Jesús na san magaro nonibarsunnad. E-sapingan amba aku-itomarsoggu, degi, bengusmarbarsoggu, Jesús amarga ibmar binnasur sogdesunnad, ar ade dulemar-Jesús-gannar-durgusad-daksamalad bengusmalad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús e-sapinganga sogdesunnad: “Bela dulemar-we-napneggi-bukmaladse be namar, bela dulemarga Bab-Dummad-gaya-burba-nuedgi angi bemar sunmaknamarsun. ");
INSERT INTO cuk09_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ar dulemar angi bensulidba an-abingasmalale, degi, digi-ogleged-igar imaksamalale, amar abonolemaloed. Ar dulemar-angi-bengusmaladdi, degi, an-abingassurmaladdina, adi e-san-burba degi-odurdakle-sii na sadeguoed. ");
INSERT INTO cuk09_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","“Dulemar-angi-bengussurmalad-ular, amardi we-ibmar-wilubgan-dakledisurmalad imakoed. Amardina an-nuggi niamar-onioed, degi, gaya-gwapid nabir-sunmak-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dule-an-bensurmalad sunna naibe-bulegan gae-gumaloed, ar degi, ina-sunna-dule-ibloged gobsamalale, a-ina amar-gwen-oburgosurmalad. Dulemar-gegumalad-birgi e-argan-mesisale, a-dulemar yog nuguar-gumaloed.” ");
INSERT INTO cuk09_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Dummad-Jesús degi-sunmaksad-sorba, Bab-Dummad-negse nakwid-gusad, degi geb Bab-Dummad-argan-nuedsik dummadga sigidapsunnad. ");
INSERT INTO cuk09_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Degine, Jesús-sapingan nadmargu, geb neggwebur-iliba Bab-Dummad-gaya-burba-nuedgi sunmakdemalad. Dummad-Jesús nue amar-bendaksad, degine, ibmar-wilubgan-dakledisurmalad nue oyodmalad, adi dulemar mag dakmalagar, we-igargi-sunmakdimalad igar-napiragwadye. Be itomargua.))");
INSERT INTO cuk09_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ar dule-bukidargus bato nue-inikii igar-napiragwad anmar-abargi-gusad narmaksaye sogdidimalando, ");
INSERT INTO cuk09_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ar gebesaila Jesús-sapingan na e-sunnad Jesús-daksamalad, igi anmar-odurdaksamala, amarde, Bab-Jesús-igargi sunmakdii-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Dummad-Teófilo, nue an baiganse egichisad-sorba, an dakmogua, ib-nueddo, Jesús-igar gebesaila onoded-akar, nue ilekwaa bega an narmaker, ");
INSERT INTO cuk09_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","adi be nue wisgumogagar Jesús-igargi-be-odurdaklesad we napiragwadid, gakansulid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Rey-Herodes, Judea-yargi neg-dakmaigu, deun dule-irwa-Bab-Dummadse-gormalad-wargwen, Abías-sikid, mai-gusad. A-dulede Zacarías-nugad, e-omedi Aarón-wagan-sikidid, Elisabetye-nugad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Emide ebobela Bab-Dummad-asabin dule-igar-napiragwadba-damalad gumalad, degine, Bab Dummad egi ibmar akar-soged sated. Bab-na-e-igar-uksadba, degine, Bab-Dummad-sogsadbali-nanadimalad-dulemalad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ar amarde mimmi-satemalad, ar ade Elisabet geg mimmi-baked, degine, bato amarde sered gusmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ibagwengine, Abías-sikmaladga wilub nonikid Bab-Dummadse-goled-neggi arbaegar. Deunni, Zacarías Bab-Dummadse-goled-neggi dule-irwa-Bab-Dummadse-golega arbanonimogad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na gusgu igi dule-irwa-Bab-Dummadse-gormala, deyob Zacarías nugsalealid, Bab-Dummad-Neg-Islidikidgi dogegar, ina-wawadikid ase obupurmaknaegar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Degine, ina-wawadikid-ogumaked-wachigi, deun bela-dulemar magaba Bab Dummadse gorbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías Bab-Dummad-Neg-Islidikidgi ina-wawadikid ogumaknaidgi, Bab-Dummad-anger-wargwen, Zacaríasse ukiar magargunonikid, daklealid ina-wawadik ogumakleged-galu-naba, argan-nuedsik gwichi. ");
INSERT INTO cuk09_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías deyob Bab-Dummad-anger-dakargu, gwakided, bela nue-dobee ito naded. ");
INSERT INTO cuk09_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ar angerdi ega sogded: “Zacarías, melle dobgu, ar Bab-Dummadse-be-goledi Bab Dummad be-itosad, be-ome-Elisabet bega machi-wargwen-bakoed, e-nug Juanye be onugsao. ");
INSERT INTO cuk09_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Be machi-nikuoedba, be yeer itogoed, be weligwar itogoed, degine, be-machi gwalulenonikir, bukidar egi weligwar itomarmogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","“Ar be-machide Bab-Dummad-asabin dule-dummadga guoed. Vino, degi, inna-gaibid gobosulid, degine, amba muu-neggi mai, bato Bab Dummad Burba Nued bela-bela nika-guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Deginbali, we-machi gannar Bab-Dummad-Jehováse, Israel-dulemar-bukidar obirnai-guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ar be-machi-Juan, Dule-Dummad-idu nadap-guoed, Elíasyob. Deyob Bab-Dummad-Burba, degi, Bab-Dummad-gangued nika-gumogoed, adi babgan gannar na e-mimmigangi binsa imakegar, sabguegar, degi, dulemar-galagwensuli-gudimalad dulemar-nuegan-binsaed-nikaa-damaladga imakegar, degine, adi, dulemar guagwar urbegar, Bab-Dummad-abingamalagar.” ");
INSERT INTO cuk09_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Degi Zacarías angerga sogded: —¿Degite igi an wisguosunna be-anga-soged we deyob guoed? Ar ande seredgusad, degi, an-omede bato seredgusmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anger, abin-imakdegu, sogded: —Ani an Gabriel, Bab-Dummad-asabin an gwichid, Bab-Dummad-sogedba an ibmar imakegar. Ani an barmilealid, bega sunmakegar, bega we-gaya-burba-nued sogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","We-ibmar-an-bega-sogsad e-ibagan mosale, we deyob gunonikoed. Ar be an-bengussoggu, geg bar sunmak be guoed. Be-machi-gwalulesad-sorba geb be gannar sunna sunmak-gunonibaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ar dulemardi magaba Zacarías-edarbebukmalad, geger dakarmalad, ibiga dikasurgus Bab-Dummadse-goled-Neg-Islidikidgi Zacarías gunaid yoggud-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zacarías agi noargu, geg emarga sunmaked. Agi mag daksamala, we Bab-Dummadse-goled-Neg-Islidikidgi wis ibya-apurus danikir-gebye. Zacarías dulemarga sunmaksasulid, unnila argangi emarga wis sunmaksad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Geb Zacarías dule-irwa-Bab-Dummadse-goled-imaked bergusgu, na e-negse nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Geb a-ibagan-sorbali, e-ome-Elisabet gurgin-nika gunonikid. Agine, Elisabet nii-walatar bar nodsuli na neg-yaba megisad. Agi sokalid: ");
INSERT INTO cuk09_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Bab Dummad nabir an-daknonikid, an mimmi sulidba, adi dulemar mer istar bar an-dakmalaga anga mimmi-uknonikid.” ");
INSERT INTO cuk09_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet nii-walanergwagus bonigwar gudiidgi, Bab Dummad, anger-Gabriel-barmialid, Galilease, Nazaret-neggweburse, ");
INSERT INTO cuk09_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","yagwa-gwensak María-nugadse. A-yagwade, dule-wargwen, José-nugad-ebo igar-nabosad, na nikumalagar. Joséde Rey-David-wagwad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Bia-María-maidse anger dognonigu, ega sognonikid: —¡Na, degite! ¡Bab Dummad begi nabir binsasad! Bab Dummad beba gudiguad. Baigan-omeganba Bab Dummad bur nued begi binsasad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ar Maríadi anger-dakargu, ibmar-ega-sogedba dobe ito naded, binsaded, wede anger weyob anse gornonikid ibi obarsunye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Degi anger ega sogdesunnad: —María, mer be dobgu, ar Bab Dummad nabir begi binsasad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ar emigindi, be gurgin-nika gunonikoed, mimmi-gwensak be nikuoed, Jesúsye a-machigwa be onugsaoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","We-machide dule-dummad guoed, Bab-Dummad-Bur-Dummadid a-e-Machiye soglegoed, degine, Bab Dummad, anmar-Dummad, igi epenne Rey-David, reyga mai-gusa, deyob e-wagwa-imakmogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Degine, we-Jesús, Israel-neggwebur-neg-dakmai degi-sadeguoed, e-neg-dakmai-guoedi gwen bar berguosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Geb degi María angerga sogded: —¿Ar wede igi guosunna? Ar amba an yaagwad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anger abin-imakdegu ega sogded: —Bab Dummad Burba Nued begi aidenonikoed, Bab-Dummad-Bur-Dummadid a-e-gangued be-edunonikoed. Degisoggu, Dule-gwage-swilidikid-gwalulegoed, soglenonikoed, Bab-Dummad-Machiye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Emi be-gwenad-Elisabet, bato sered gusadgi, geg mimmi-bakye-nik sogmaladi bonigwar gunonikid. Emide nii-walanergwagus gurgin-nika gudiid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ar ade Bab Dummadgardi ibmar-geg-gued nik-deeye soglesulid, ar bela ega ibmar nabir guedbiid. Deggisoggu, a-ular an bega sogsadyob bega gunonimogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Geb degi María sogdesun: —Ar andi Bab-Dummad-mai gued, ar be-ibmar-sogedba be anga imakdo. Degi anger Maríagi banguded. ");
INSERT INTO cuk09_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A-ibagangi, María Judá-yalaganba, a-neggwebur-gwagwense gwae nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacarías-negse dogdapgu, Elisabetse gordapid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabet itosgu, María ese gole, dule-e-sapi-dukugi-maid ber dulagwar itoded, degi, Elisabet bela-bela Bab Dummad Burba Nued nika-gunonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Degine, Elisabet binnasur gote, sogded: —Baigan-omeganba Bab Dummad begi bur nued binsasad, degine, be-anagi bur-nued egi binsasbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ar wede ibiga weyob angi nued binsalesa, emide, an-Dummad-e-nan anse ataknonigu? ");
INSERT INTO cuk09_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ar be anse gornonikid an itodeyalaba, an-sapi-dukugi-maid weligwar-itogedba ber dulagwar naded. ");
INSERT INTO cuk09_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ar be we-ibmar bengussulidba begi nued-binsalesad, ar Bab-Dummad-bega-ibmar-sogsadba we-ibmar bela bega guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Geb degi María sogdemogad: An ulub-akar an Bab-Dummad-nug odummosun. ");
INSERT INTO cuk09_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Degine, an-burba, Bab-Dummad-an-abonogedgi weligwar an itosun, ");
INSERT INTO cuk09_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ar an e-mai-bundor-binsalegwad-inigwele, Bab Dummad an-sunonikid, nued angi binsanonikid, ar emigindi, bela dulemar angi sogmaloed, nued egi binsalesad duleye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ar Bab-Dummad-Na-Gangued-Bela-Nikad, anga ibmar-dummagan imaksad, e-nug, ber swilidikidye nugad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ar Bab Dummad dulemar-e-dobee-nanadimalad wile daked, degine, a e-waganse-bakar, a-wile-daked eba sadegumogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Bab Dummad e-gangued na e-arbaedgi oyosad, dulemar-na-san-dummarba-imakdimalad-osulosad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Bab Dummad dule-dummagan-neg-semamaid-obelosad, degine, dulemar-na-san-bipii-imakdimalad-odummosad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Degine, dulemar-ukumesdimaladga ibmar-bukidar uksad, degine, dulemar-mani-ibgan, ibmar-sate barmisad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Bab Dummad na e-mai-Israel-dulemar-bendaksad, deun amar-wile-daked gwen iessurgu. ");
INSERT INTO cuk09_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ar Bab Dummad deyob anmar-dad-Abrahamga sogsad, degi, e-waganga sogsa-gusad, e-wile-daked degi-sadeguoye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María, Elisabet-walik nii-walapaa megialid, geb a-sorba na e-negse gannar ali-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet e-ibagan warmaknonigu, mimmi-nikunonikid, machigwa ega uklenonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","E-neg-dikarba-mamaid, degine, e-gwenadgan itoarmargu, Bab Dummad Elisabetgi nabir binsasye, degi, nue wile daksaye, Elisabetba wergudmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Degine, ibabaabakgus susugwa-gwalulesad-sorba senonimalad, e-abgan-duku sikegar, adi Moisés-igar-maidba imakegar. Degine, e-bab-Zacaríasba mimmi nug-imakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ar e-nan sunmakdegu, sogded: —Suli, degi nugguosur. Juanye nugguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Elisabetga sogdemalad: —¿Ibiga degi be onugsabie? Ar be-gwenadgan degi-gwen-nugsurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Geb degi e-babse egichiarmalad, argangi sunmakar, igi machigwa onugsaoye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías urgo-bipigwa egichisad, agi machigwa-nug narmaksad, Juanye nugguoye. Bukmaladi bela geger dakdemalad, deyob onugsabied. ");
INSERT INTO cuk09_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Geb degi Zacarías nabir sunmakded, e-gwabin bipinmakded. Sunmakdegu, Bab-Dummad-nug ogannoded. ");
INSERT INTO cuk09_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bela-e-neg-dikarba-mamaid dobe itonadmalad. Bela Judea-yalaganba we-ibmar-deyob-gusadi gaya mimmileded. ");
INSERT INTO cuk09_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ar bela-we-gayagan-itoarmalad na nue e-gwagegi binsadmalad, sogdemalad: “¿Ar we-mimmide doaga guosunna?” Dulemar daksamalad, a-mimmiba Bab-Dummad-gangued gudigu. ");
INSERT INTO cuk09_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Degi Zacarías, Juan-e-bab, Bab Dummad Burba Nued bela-bela nika gunonikid, degi, Bab-Dummad-nuggi sunmakdesunnad, sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dummad, Israel-e-Bab-Dummad, a-e-nug odummomarsun, ar ade e-dulemarse na ataknonikid, degine, iskuedgine anmar-onononikid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Bab Dummad e-mai-David-wagwa anmarga barminonikid, anmar-Abonoged gandikidba anmarga ogwisnonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ar igi gebesaila anmarga sunmaksa, na E-gaya-burba-berbemalad gwage-swilidikmaladba. ");
INSERT INTO cuk09_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Istar-anmar-dakdimalad, degi, sae-anmar-dakdimaladgi anmar-bendakoye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Adi Bab Dummad anmar-babgan wile dakega, degine, amar-ebo igar-swilidik-mesisad insaegar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bab Dummad na e-nuggi anmar-dad-Abraham-ebo napiragwadgi igar-mesisad, we-igar ede imakedseye. ");
INSERT INTO cuk09_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Istar-anmar-dakdimaladgi Bab Dummad anmar-onogoye, adi dobsuli anmar ega arbamalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nue gwage-swilidikidgi, degi, nue-napiragwadgi anmar burgwedse ega arbaegar, ");
INSERT INTO cuk09_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mimmi-bipi, bedina, Bab-Dummad-Bur-Dummadid a-E-gaya-burba-berbegedye be bilegoed. Ar bede, Dule-Dummad-barmiledagoye-sogsad-idu nadap-guoed, adi e-iduar igar mayegar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Adi na e-neggwebur abonoged-igargi odurdakegar, adi na e-iskudimaladgi abonogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ar anmar-Bab-Dummad nue-wilesakwaa anmar-dakedba, neg-meegwadyob anmarga dule-barmialid, nibneggi neg-meegwadgi danikidid. ");
INSERT INTO cuk09_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Adi dulemar-Bab-Dummad-wichurmalad neg-sichidgi bukmaladyob, amar Bab-Dummad-wisgumalagar, gwallu mee imakedyob. Degi, dule burgwed-dobmalad ega osulogegar. Adi anmar igar-bogidikidgi nanadii-gumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Degine, machigwa dungumai, e-burba gangumai gusad. Nega-dule-sulidganba gudigusad, Israel-dulemarse na san magaros gusadse, Bab-Dummad-igargi sunmakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Amba yo Jesús gwaluleged-idu, deun Augusto-César saila-dummadga Romagi maigu, igar mesialid, bela-dulemar-bukwad-ebisoye, igi mergu-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","We gebe dule-ebisleged imaklesdo, deun Cirenio dummadga Siria-yargi neg-dakmaiun. ");
INSERT INTO cuk09_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bela ebislemalagala na e-neggwebur-e-neggweburse nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José, Galilea-yargi, Nazaret-neggweburgi gudiid ali-gusmogad, Judea-yarse, Rey-David-neggweburse, Belén neg-nugadse, ade José, David-e-wagwad, aga Belénse nonisundo, ");
INSERT INTO cuk09_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","adi a-neggweburgi e-ome-Maríamala ebislemalagar. Deun bato igar-maid ebo nikuoye, degine, deun María bato gurgin-nika gudiid. ");
INSERT INTO cuk09_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén-neggweburgi gudimala, María-ibagan warmaknonikid, goe-baked-iba. ");
INSERT INTO cuk09_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Degine, machigwa gebe ega uklenonikid, agi samorgi obirmas, degi, moli-omaed-urgi mimmi-mesisad, ar ade emarga gabed-neg sate gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Deun a-ibagi Belén-neggwebur-dikarba, sibad-wawaad-edarbemalad, e-sibad-wawaad mutik edarbebukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Agine, Bab-Dummad-e-anger-wargwen amarse ukiar nonikid, degine, Bab-Dummad-e-yeer-dakleged-gaed bela emar-ebilis ibegwar ganonikid. Degine, sibad-wawaad-edarbemalad gwakiarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ar angerdi amarga sogded: —Mer be dobgumar, ar bemarga gaya-burba-nued, bela dulemar-weligwar-saed an sedanikid. ");
INSERT INTO cuk09_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rey-David-gwalulesad-neggweburgi, Beléngi, emi-ibagi bemarga Cristo gwalulesad, dule-Abonoged, Dule-Dummad, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule. ");
INSERT INTO cuk09_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Weyob be wilubdakmaloed: Mimmi samorgi-anwar moli-omaed-urgi mai be dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Degine ukiar, we-anger-abargi bukidar-angermar-nibnegginmalad-baigan daklealid, Bab-Dummad-nug ogannonanai, sognanai: ");
INSERT INTO cuk09_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Nibneggi Bab-Dummad-nug ogannomarsun, degine, we-napneggi neg-bogidikid gusun, dulemar-nuegan yeer binsadimaladga! ");
INSERT INTO cuk09_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Degine, nibnegse gannar angermar nadmarbargu, sibad-wawaad-edarbemalad na ga sokarmalad: —Ar anmar Belén-neggweburse namarsun, degi-neg-gusad daknamarsun, Bab Dummad anmar-owisosadba. ");
INSERT INTO cuk09_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Sibad-wawaad-edarbemalad gwae-gwae armarsunnad. Daknonimalad, José, María, degi, mimmi, moli-omaed-urgi mai. ");
INSERT INTO cuk09_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Degi-dakarmargu, sibad-wawaad-edarbemalad sogdemalad, igi angermar mimmigi ega sunmaksamala. ");
INSERT INTO cuk09_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ar bela-dulemar sibad-wawaad-edarbemalad ibmar sogsa itosmalad, geger itomalad we-ibmar sogmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ar Maríadi bela na e-gwagegi wargwen sedii-gusad, agi binsadii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ar sibad-wawaad-edarbemalad, ega ibmar soglesadba bela gusad daksamalad, degi, bela itosmalad-ular, gannar armargu, Bab-Dummad-nug odummodani, degi, ogannodani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jesús ibabaabakgus gwalulesadgi, Judiomar-igar-maidba imakegala, e-abgan-duku siksamalad, ega nug Jesúsye uksamalad, ar igi anger amba yo María bonigwar-gued-idu bato nug imaksadba. ");
INSERT INTO cuk09_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés-igar-mesisadba imakegala, María goe-nikusad-sorba ibagan nonisun, na san nudakmalagar. A-ular José, María-ebo, Jerusalénse Jesús-senonimalad, Bab Dummadga ukegar. ");
INSERT INTO cuk09_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ar igi Bab-Dummad-igargi narmakar mai: Ar gebesaila machigwa-inse nangi aidenonikile, Bab Dummadga be ukoed, adi, unnila egadga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Degine, ar igi Bab-Dummad-igargi narmakar naibali, Bab Dummadga ukoye: Sapur-nuu-gwabo, ar degisulile, wag-nuu-mimmigan-gwabo. Lv. 12:6-8 We sognaidba imakegala, María nonimogad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A-ibagangine, Jerusaléngi, dule-wargwen, Simeón-nugad, gudigusad. A-dulede dule-gwage-nuedid, Bab-Dummad-dobee-nanadiid, na Israel-bendakleged-edarbedimogad-duled. Bab Dummad Burba Nued a-duleba gudiguad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Bab Dummad na E-Burba-Nuedba Simeónga sogsad: “Be burgosurye, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-dakedseye.” ");
INSERT INTO cuk09_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Bab-Dummadse-goled-negse Jesús-e-babgan na mimmi-senonimargu, Moisés-igar-maidba imakegala, deun Bab-Dummad-Burba-Nued-sogedba, Simeón Bab-Dummadse-goled-negse nonimogad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón na e-swidawargi machigwa-mesisgua, Bab-Dummad-nug odummoded, sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Bab-Dummad-Bela-Neg-Semaid, an be-mai. Emigindi bogidikidgi be an-sedsun, ar iduar be ibmar anga sogsadyob. ");
INSERT INTO cuk09_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ar ade an-ibyagwar Bab-Dummad-dule-abonogoed-barmialid an daksad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","We-mimmi, Bab Dummad guagwar barmialid, bela-dulemar-bukwad-abargi, ");
INSERT INTO cuk09_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","dulemar-Judiosurmaladga be oyogegar, be doa-dule gue, igi gwallu neg-sichidgi neg-mee imakedyob. Degi, we-machi dulemar abonogoedba be-Israel-dulemargi nued sunmakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José, degi Jesús-e-nan, María, geger itomalad, Simeón bela weyob Jesúsgi sognaid. ");
INSERT INTO cuk09_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Geb degi Simeón, Jesúsga sogsagu, Bab Dummad begi nued binsaoye, a-sorba machigwa-e-nanga, Maríaga sogded: —We-machigwa sulesad Israel-yargi dulemar-dummagan-bukidar onogegar, degi, dulemar-binsarmalad dummaganga imakegar. We-machigwa Bab-Dummad-wilubga guega nonikid, oyogegar, Bab Dummad sunna nabir dulemar-abonoye. Ar degi-inigwele, dulemar-bukidar machigwa-abingaosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","We-machiba bukidar-dulemar-gwage-binsananaid mag daklegoed. María, ar begardi be-san-burbagi espunyar-yolenaiyob be nunmak itogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Agine Bab-Dummad-gaya-burba-berbeged-wargwen, Ana-nugad, Bab-Dummadse-goled-neggi gudimogad. A-omede, Fanuel-sisgwad, Aser-e-wagwasik danikid. Anade bato nue seredgusad, unnila birga-gugle sui-nika gudigusad, ");
INSERT INTO cuk09_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","degine birga-dulabake-gakabakegus ei-sui-burgwisad. A-mukwade Bab-Dummadse-goled-neggi gudigu-daed, ibginedba, degi, mutikidba Bab Dummadse gordii, degi, mas-gunsuli, Bab-Dummadse-golega-gudii-daed-duled. ");
INSERT INTO cuk09_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón deyob sunmakgwichidgi, Ana nonimogad. A-mukwa Bab Dummadga Jesúsgi dog-nuedye sogsa-gusad, degi, bela Jerusaléngi dulemar-Bab-Dummad-abonogoed-edarbedimaladga machi-bipigi ega sunmakde-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José, María-ebo bela Bab-Dummad-igar-maidba ibmar-imaksad-sorba, gannar Galilease nonimalad, na e-neggwebur-Nazaretse. ");
INSERT INTO cuk09_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Degine, machi-bipidi dungumai, gangumai, degine, nue-binsaed-ibed-gumai-gusad. Ar Bab Dummad a-machi-bipigi nue nabir binsadii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Birga-irba Jesús-e-babgan Jerusalénse nad-damalad, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi. ");
INSERT INTO cuk09_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús birga-ambe-gakabo-nikadgi, e-babganba Jerusalénse nonimogad, ar igi gusgu na ibagi igar-maidba imakmaladba. ");
INSERT INTO cuk09_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ibagan bergusgu, Jesús-babgan gannar Nazaretse armargu, machigwa-Jesúsdi Jerusaléngi besad. José, degi, e-nan-María, amardi wichurmalad Jesús-besad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E-babgandi dulemar-danar-danimaladba Jesús daniye bimalanad. Ibagwengus-nanaedgine e-gwenadgan-abargi, degine, mag-dakmalad-abargi Jesús-amiarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ar amissurmarsoggu, gannar Jerusalénse Jesús-aminonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Degine, ibapaagwad-sorba amidapid, Bab-Dummadse-goled-neggi, Moisés-igar-mesisad-nue-wisimalad-abargi sii, amar-itosii, degi, amarse ibmar egissii. ");
INSERT INTO cuk09_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ar bela-itobukmalad geger dakmalad Jesús nue ibmar wisi, degine, nue-imas Moisés-igar-nue-wisimalad abin-imaked. ");
INSERT INTO cuk09_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","E-babgan Jesús-dakarmargu, geger dakdemalad dummagan-abargi siid. E-nan Jesúsga sogded: —Machi, ¿ibiga we deyob be anmar-imaksa? Emide be-bab, degi, andi surbinsa anmar be-amidigu. ");
INSERT INTO cuk09_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Geb degi Jesús abin-imakdegu, sogded: —¿Ar be wichurmarsi an-Bab-arbaedgi an arbaer-gebed? ");
INSERT INTO cuk09_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ar e-babgandi aku itosmalad ar ibi ega obarisa. ");
INSERT INTO cuk09_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesús e-babganba arsunnad, gannar Nazaretse nonisunnad, na e-babgan-sogedba gudiguarsunnad. Ar e-nandi bela we-ibmarmar na e-gwageginbi sedii, egi binsadii-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ar Jesúsdi ibmar-nue-wisidgi, e-dunguedgi, degine, Bab-Dummad-nue-nabir-egi-binsaedgi, degi, dulemar-nued-egi-binsaedgi dungumai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Deun birga-ambe-gakatar gus Tiberio-César Romagi neg-dakmaidgi, Poncio-Pilato deun Judea-yargi dummadga maid, degine, Herodes Galilea-yargi dummadga maid, e-urba-Felipe Iturea-yargi, degi, Traconite-yargi dummadga maid, degine, Lisanias dummadga Abilinia-yargi maid. ");
INSERT INTO cuk09_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Deunni Anás, Caifás-ebo dule-irwa-Bab-Dummadse-gormalad-bur-dummadga maid. A-ibagangine, Bab Dummad Juanse gornonikid, Zacarías-e-machise. Deun Juan-Bautista nega-dule-sulidganba gudiid. ");
INSERT INTO cuk09_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan-Bautista nade-gusad, bela Jordán-diwar-dikarba, Bab-Dummad-digi-ogleged-igargi sunmakdii, dulemar na e-iskumaladga bukib binsaegar, adi e-daed gwagmalagar, adi iskuedgi abonomalagar. Agi Juan sunmakdii-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Juan-ibmar-imaknaid deyob gusad, ar igi epenne Isaías, Bab-Dummad-gaya-burba-berbeged narmaksa-gusa, deun sogsa-gusgu: Dule-wargwen nega-dule-sulidganba binnasur sunmaknonikoed, dulemarga sognonikoed: “Dule-Dummad-idu igar-mayemar, igar-swilidik mesmar. ");
INSERT INTO cuk09_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bela nebagan swilidik guoed, yarmala, degine, neg-mullugana omatolegoed. Igar-bire-bire-mamaid inikii imaklegoed, degine, igar-muru-muru-mamaid oswirmaklebaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bela dulemar Bab-Dummad-abonoged-wisgumaloed.” ");
INSERT INTO cuk09_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dulemar-bukidar Juan-Bautistase duurmaknoni-damalad, Bab-Dummad-digi-ogleged-igar imakegar; Juan amarga sogde-daed: “¡Ar bemar naibe-bulegan-mimmiganyob gumalad! ¿Ar doa bemar-odurdaksa, Bab Dummad nue-urwe-danikoed-idu wakinned? Bab-Dummad-digi-oglegedgi bemar nuguosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Degisoggu, be-daedgine na be oyomar, bemar nue gwagsamalad, be-iskuedga na be bukib binsasmalad. Mer unnila na be sogmalo: ‘Anmar Abraham-wagan gumar. A-ulale Bab Dummad anmargi nabir binsaer-gebed.’ Suli, degisuli. Ar be Abraham-wagwa-sulile, akarsulid, ar Bab Dummad sunna we-akwamar Abraham-e-waganga imaked. ");
INSERT INTO cuk09_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","“Deginbali, ar bato akan guar sapi-maligi yoid. Ar degisoggu, sapi nue sanmaksulile, a-sapi siklegoed, soogi melledoed, ogumaklegegar. Deyob Bab Dummad dulemar-imakmogoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ar degi dulemar Juan-Bautistase egichiar dasunnad, ega sogde-damalad: —Degite, ¿ibu anmar imakmarsunnoe? ");
INSERT INTO cuk09_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan, abin-imakdegu, sogded: —Dule suba-gobo nikale, dule-suba-sulidga gogwen ukmogo. Amba deyob mas-gunnedsik imakbaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Dulemargi-Roma-dummadga-mani-gaedgi-arbamalad Juanse nonimarmogad, Bab-Dummad-digi-ogleged-igar imakegar. Amar ega sogdemarmogad: —Odurdaked-saila, ¿anmardi ibi imakmarmogoe? ");
INSERT INTO cuk09_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan amarga sogded: —Bemar melle dulemargi wilub-obichaa mani gamalo, ar unnila bemarga igar-uklesadba be mani gamaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Degine, suar-ibmala ese egichiarmarmogad: —Anmardi ¿ibi imakmarmogoe? Juan, abin-sogded: —Mer emar-annik gannadba mani suo, degine, mer binsa aimar-ogakansao. Ar bemar na be-bennuklegedgi, gusbin be itoge-wilubmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dulemar-Juan-itobukmalad Cristo-edarbebukmarsoggu, na e-gwagegi binsabukmalad, we Juan-Bautista, Cristo sogeye. Cristo sogleged, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule. ");
INSERT INTO cuk09_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan abin-imakdegu, bela dulemarga sogded: “Ar andi napiragwad, Bab-Dummad-digi-ogleged-igar-imakedi, an unnila digi ogdiid, ar dule-baid-danikiddi, ar anba bur dule-dummadsoggu, e-sapat-dubse-bakar geg an ei esiked. Ar a-duledi Bab Dummad Burba Nuedgi, degi, soogi be-ognonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Igi dulemar oros-gwag egwamala, deyob we-a-dule, dule-dummadid, bato guagwar e-argangi bigbi-gani gwichid, oros-gwag na egwaegar. Degi, na oros-gwag nued na nue e-urbedgi na urboed, e-ukadi soogi ogumakoed. Ar we-soode geg soo-ginnedid, degi-gasii-sadeguad sood.” We sogledo, dule-dummad oros-gwagyob dulemar-imakmogoye. ");
INSERT INTO cuk09_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Weyob bukidar Juan dulemar-unadii-gusad, Bab-Dummad-gaya-burba-nuedgi dulemarga sunmaksagu. ");
INSERT INTO cuk09_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herodes dummadga maigu, Herodías-nikusad-ular, Juan sabsur Herodesga ibmar sogsad, ar ade Herodíasde e-urba-Felipe-omenad. Bela-ibmar-iskanamar Herodes imaksadi, ");
INSERT INTO cuk09_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","a-ukine, Herodes we imaknonibardo, Juan eskaryagi metenonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Degidgine, bela dulemar Bab-Dummad-digi-ogleged-igar imaknanaigua, agi Jesús Bab-Dummad-digi-ogleged-igar imaksamogad. Jesús Bab Dummadse gotegu, nibnega argade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jesúsgi Bab Dummad Burba Nued aidenonikid, sanale, nuuyobi aidenonikid, degi, nibneggi gaya-burba gollar-gusad, sogded: —Be An-Machi-sabed-sunnad gued, beba weligwar an itoged. ");
INSERT INTO cuk09_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús na e-arbaed imakdegu, deun birga-durgwen-gakambe nikad. Jesús, José-e-machiye bimalanad, degi, Josédi, Elí-e-machimogad. ");
INSERT INTO cuk09_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elídi Matat-e-machid, Matatdi Leví-e-machid, Levídi Melqui-e-machid, Melquidi Jana-e-machid, Janadi José-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josédi Matatías-e-machid, Matatíasdi Amós-e-machid, Amósdi Nahum-e-machid, Nahumdi Esli-e-machid, Eslidi Nagai-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaidi Maat-e-machid, Maatdi Matatías-e-machid, Matatíasdi Semei-e-machid, Semeidi José-e-machid, Josédi Judá-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judádi Joana-e-machid, Joanadi Resa-e-machid, Resadi Zorobabel-e-machid, Zorobabeldi Salatiel-e-machid, Salatieldi Neri-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neridi Melqui-e-machid, Melquidi Adi-e-machid, Adidi Cosam-e-machid, Cosamdi Elmodam-e-machid, Elmodamdi Er-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erdi Josué-e-machid, Josuédi Eliezer-e-machid, Eliezerdi Jorim-e-machid, Jorimdi Matat-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatdi Leví-e-machid, Levídi Simeón-e-machid, Simeóndi Judá-e-machid, Judádi José-e-machid, Josédi Jonán-e-machid, Jonándi Eliaquim-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimdi Melea-e-machid, Meleadi Mainán-e-machid, Mainándi Matata-e-machid, Matatadi Natán-e-machid. ");
INSERT INTO cuk09_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natándi David-e-machid, Daviddi Isaí-e-machid, Isaídi Obed-e-machid, Obeddi Booz-e-machid, Boozdi Salmón-e-machid, Salmóndi Naasón-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasóndi Aminadab-e-machid, Aminadabdi Aram-e-machid, Aramdi Esrom-e-machid, Esromdi Fares-e-machid, Faresdi Judá-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judádi Jacob-e-machid, Jacobdi Isaac-e-machid, Isaacdi Abraham-e-machid, Abrahamdi Taré-e-machid, Tarédi Nacor-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacordi Serug-e-machid, Serugdi Ragau-e-machid, Ragaudi Peleg-e-machid, Pelegdi Heber-e-machid, Heberdi Sala-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Saladi Cainán-e-machid, Cainándi Arfaxad-e-machid, Arfaxaddi Sem-e-machid, Semdi Noé-e-machid, Noédi Lamec-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecdi Matusalén-e-machid, Matusaléndi Enoc-e-machid, Enocdi Jared-e-machid, Jareddi Mahalaleel-e-machid, Mahalaleeldi Cainán-e-machid, ");
INSERT INTO cuk09_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainándi Enós-e-machid, Enósdi Set-e-machid, Setdi Adán-e-machid, Adándi Bab-Dummad-machid. Wemar, Jesús-e-dadgan gumardo. ");
INSERT INTO cuk09_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, Bab Dummad Burba Nued nue-nika gudii, Jordán-diwargi banguded. Geb degi, Bab Dummad Burba Nued nega-dule-sulidganba Jesús-sesa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Agi iba-dulabo, nia-saila Jesús-wilubdakdii-gualid. A-ibagangine, Jesús mas-gunsuli gudigusad, degisoggu, ukuur itoalid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Agi Jesúsga nia-saila sokalid: —Ar be Bab-Dummad-Machi-sunnadile, we-akwaga be soge: ‘Maduga be binyeye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús, abin-imakdegu, nia-sailaga sogded: —Noar be soged, ar Bab-Dummad-gaya-burbagi narmakar naid: Dule maduginbi dula gudiguosurye, ((bela Bab-Dummad-gaya-burba-itogedgi dula gudigubaloye)). ");
INSERT INTO cuk09_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Geb degi nia-saila yar-matusulidse Jesús-sesad. Agi belagwable-napneg-naid-ugakse ega yog irgwen oyoar imakdapid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Agi nia-saila Jesúsga sokalid: —We-neggweburgan-an-bega-oyosad bela e-gangued, degi, e-yeer-daklebalid bela an bega ukoed, ar bela wemar anga uklesad. Degisoggu, ar doaga an ukbie, aga an ukoed. ");
INSERT INTO cuk09_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Be yokorgi sindigar, igi Bab Dummadse gorlege, e-nug odummogegar, deyob be anse golele, we-neggweburgan bela begadga guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús, abin-imakdegu, sogded: —Nia-saila be angi bangu, ar Bab-Dummad-Gardagi narmakar naid: Ar Dummad be-Bab-Dummad, asebi be goloed, e-nug odummogegar, unnila agarbi be arbaoed. ");
INSERT INTO cuk09_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Geb degi nia-saila Jerusalénse Jesús-sesbalid, Bab-Dummadse-goled-neg-uas-birgi ogwisdapgu, Jesúsga sogded: —Ar be Bab-Dummad-Machi-sunnadile, be napase ichomakdo. ");
INSERT INTO cuk09_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ar Bab-Dummad-Gardagi narmakar naid: Na e-angermar bega barmidagoye be-edarbegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Degine, angermar e-argangi be-gamaloye, adi melle be-nag akwagi yolegegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús, abin-imakdegu, sogded: —Nabir be sogendo, ar Bab-Dummad-Gardagi narmakar sognaibalid: Melle Dummad, be-Bab-Dummad, be wilubdakoye. ");
INSERT INTO cuk09_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ar nia-saila bela Jesús-wilubdaked bergusgua, sikwas wis egi bangud gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús gannar Galilease nonigu, nue Bab-Dummad-Burba-Nued-gangued-nikadba nonikid, degi, bela neggweburmar-dikarba-nanaid wisguarmalad Jesús ibmar imakdiid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús Judiomar-onmaked-neggi dulemar-odurdakdii-gualid. Bela Jesús-nug odummogedbi-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús Nazaretse nonikid, bia na e-dungusadse. Obunnoged-ibagi, Jesús na gusgu e-daedba Judiomar-onmaked-negse dogdapid. Agi gwisguded, Bab-Dummad-Garda absogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ar ade Jesúsga uksamalad Bab-Dummad-gaya-burba-berbeged, Isaías, a narmaksad. Jesús garda egasgu, egasad, narmakar naidgi: ");
INSERT INTO cuk09_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Bab Dummad Burba Nued anba gudiid, ar an-susad, adi dulemar-wileganaga gaya-burba-nued an sogegar. An barmilesad, dulemar-gwage-nunmak-itodimalad-nudakegar, dulemar-galebukmaladga binnasur sogegar, bemar ainimarye, dulemar-ibya-suli-gudimaladga ibya ukegar; dulemar-baiganse-wiledimalad onogegar, ");
INSERT INTO cuk09_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Bab-Dummad-e-birga-nuedgi sunmakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","A-sorba Jesús Bab-Dummad-Garda obipirmasgu, Judiomar-onmaked-neg-daked-dulega garda uksagu, sigisad. Agi-bukmalad bela Jesúsginbi atakbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Geb degi Jesús sogded: —Emi-ibagi bemar-abargi we Bab-Dummad-Gardagi-narmakar-naid sanar-gunonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bela-dulemar-bukmaladi Jesúsgi nuedbi sunmakedbimalad. Geger nue dakmalad, ibiyobi Jesús sunmaked yeer nue sunmake. Degine, sogdemalad: —¿Ar wede José-e-machisursi? ");
INSERT INTO cuk09_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús amarga sogded: —An wisdo, wegi-sogleged sunna be anga sokarmalaled: ‘Ina-duled, na be dukin san nudake, adi anmarga oyogegar be nue ibmar wisid. Ar bukidar Capernaum-neggweburgi-ibmar-imaksad anmar be-itosmaladi, wegi be-neggweburgi be imakmoga.’ ");
INSERT INTO cuk09_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Degi Jesús sogdebalid: “Napira an bemarga soged, Bab-Dummad-gaya-burba-berbeged-wargwensaar na e-neggweburgi geg e-nug odummoleged. ");
INSERT INTO cuk09_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Napira an bemarga soged, Elías maigusgu, Israel-yargi, bukidar mukwamar-ei-sui-burgwismalad gudigusad. Deun dii birgapaa-abala gwen wissurgu, agi we-napagi bela ukud-dummad nagunonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Degite Elías a-mukwamarse gwen barmilessulid, bur barmiles-gusad, Sidónse, Sarepta-neggweburgi mukwa-wargwen-ei-sui-burgwisadse, a-mukwa ega mas ukegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Deginbali, Bab-Dummad-gaya-burba-berbeged, Eliseo-nugad, maigusgu, Israel-yargi dulemar-naibe-buna-ya-maleged bukidar nika-gusmalad, degite, amar gwen nudaklessulid, bur nudaklesad, Sirio-dule, Naamán-nugad.” ");
INSERT INTO cuk09_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ar weyob Jesús-ibmar-soge itosmargu, Judiomar-onmaked-neggi-bukmalad bela sae-itodmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dulemar gwisgudmargu, Jesús-gasmalad, geb degi neggwebur-magaba ise-onoar, yar-mulluse Jesús-sesmalad, ar ade a-yar-mullugi neggwebur siid. Ase Jesús-sesmalad, adi gulluba egwanmalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ar Jesúsdi emar-abargi ganna-ganna noded, emar-abargi bangudsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús Galilease nonikid, neggwebur-Capernaum nugadse. Agi obunnoged-ibagi dulemar-odurdaksii-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jesús dulemar-odurdaksigu, geger dakmalad igi dulemar-odurdaked, ar ade Jesúsde nue-igar-wisi sunmaked. ");
INSERT INTO cuk09_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Agi Judiomar-onmaked-neggi dule-wargwen, niaburba-iskana-nikad-siid binnasur goted, ");
INSERT INTO cuk09_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","sogded: —Jesús-Nazaretgined, mer anmarse be achao, ¿ibiga be anmar-wiodaniki? ¿Be anmar-obelogega daniki? An be-wisi be doa-dule, be-dule-gwage-swilidikidid, be Bab-Dummad-nuggi-danikid-duled. ");
INSERT INTO cuk09_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús niase uluded, ega sabsur ibmar sogded: —Mer be sunmak, dulegi-maid be noe. Geb degi nia emar-abargi dule-omukusgu, a-dule gwen akar imaksasuli nia a-dulegi node-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Degi-gusad bela geger dakdemalad, agi sogdemarsunnad: —¿Wede igidbarsunna, nue burba nika, gandik niaburbamarga ibmar soged, degine, niaburbamar eba ibmar-imakde-damalad? ");
INSERT INTO cuk09_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Degi bela Galilea-yalaganba wisguarmalad igi Jesús dulemar-nudakdiid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Geb degi Jesús gwisgudgu, Judiomar-onmaked-neggi-siidgi nodsunnad. Geb Jesús, Simón-negse dogdapid. Simón-sakbundor ise-uelegar mai dakdapid. Jesúsgi wilenagusmalad, adi Simón-sakbundor-nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Degi Jesús Simón-sakbundor-walik gwisgunonigu, sabsur uelegedga ibmar sogded. Agi ueleged yog berguar naded. Geb Simón-sakbundor yog gwisguar imaksad, geb a-sorba emarga yog ibmar imakar gussunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dad-argwategu, obunnoged-iba bergusgu, bela galagwensuli-ueleged-nikmalad Jesússe senonimalad. Jesús na e-argan uelemaladgi mesisgu, bela amar-nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Deginbali, Jesús bukidar niamar-onisbalid. Niamar ainider, binnasur gote, sogde damalad: “¡Be Bab-Dummad-Machid!” Ar Jesúsdi niamarse ulud-daed, osunmakega gwen imaksasulid, ar ade niamar wismalad, we Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duled. ");
INSERT INTO cuk09_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ar bato oibosgu, Jesús nadsun, nega-dule-sulidganba. Dulemar Jesús-amidii-guarmalad. Dulemar Jesús-amismargu, egi wilenagusmalad, mer egi naegar. ");
INSERT INTO cuk09_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ar Jesúsdi amarga sogded: —Ar neggwebur-baiganse Bab-Dummad-gaya-burba-nued, na e-neg-dakmaidgi an sunmaknabalir-gebed, ar a-ular an wese barmilealid. ");
INSERT INTO cuk09_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Galileagi Judiomar-onmaked-neg-simaladgi Jesús Bab-Dummad-gaya-burba-nuedgi sunmakdii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Degi Jesús mata-dummad-Genesaretgi-naidgi gudii, dulemar-bukidar ese nonimalad. Bab-Dummad-gaya-burba itomalagala na barmesnanai-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Agi Jesús dakalid ur-warbo gakagi nai. E-ibmaladi urgi aides bukwa, saki enukbukwa. ");
INSERT INTO cuk09_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","A ur-wargwengi Jesús nakwisad. Dakleargu, a-ur Simón-ur. Jesús Simónga sogded: —Wis be-ur matasik be onoge. Jesús a-urgi sigisad, agi-sii dulemar-bukidar-gakagi-bukwad-odurdakded. ");
INSERT INTO cuk09_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jesús sunmaked bergusgu, Simónga sogded: —Matasik be-ur be sede, be agi saki mie, ua-gaegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón, abin-imakdegu, ega sogded: —Odurdaked-saila, anmar oiboalid ua-gananai, degite, anmar ua gwen gassurmalad. Degi-inigwele, be-sogedba an saki miodo. ");
INSERT INTO cuk09_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ar Simón degi-saki-mismargu, ua-bukidar-gasmalad, a-ular saki achirmakbi-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Geb degi Simón na e-aimar-ur-baidgi-gunanaidse achasmalad, adi emar-bendakdamalagar. Ese nonimargu, ur-warbo-bela ua enosmargu, ua-enadba ur-dogbi-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón-Pedro ua-bukidar gasa dakdegu, Jesús-abin yokorgi sindigar sigided, ega sogded: —Dummad, angi be bangu, ar an iskudiid-duled. ");
INSERT INTO cuk09_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ar ua-bukidar-gasadba, Simón, degine, bela-eba-gunanaid dobe itodmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Degine, Simón-e-aimar, Zebedeo-machimala, Santiago, Juan-ebo, dobee itonadmarmogad. Ar Jesúsdi Simónga sogded: —Mer be dobgu, igi bemar ua-gae, abayobi dulemar napneggi gaega emigindi, an be-odurdakmaloed, adi dulemar anba nagumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simón, degi, e-aimar gakase ur senonimargu, bela ibmar obesmalad. Degi geb Jesúsba nadmarsunnad e-sapinganga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Neggwebur-gwensakgi Jesús gudigu, dule-wargwen naibe-buna-ya-maleged-yaisur-nikad ese nonikid, yokorgi sindigar Jesús-asabin signonikid. We-dule Jesúsgi wilenagusad, ega sokalid: —Dummad, an wisi, sunna be an-nudaked, be an-nudakbier. ");
INSERT INTO cuk09_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Geb degi Jesús e-argan ese achadgu, dule-ebusad, geb degi ega sogded: —Nugubi an be-abe. ¡Be nugusun! Degi, dule-boni-nikadi yog nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús dule-nugusadga sogded: —Mer dulemar-baiganga be sogo, an be-nudaksad. Unnila be nae, dule-irwa-Bab-Dummadse-goledse, be aga oyona be nugusad. Degine, be swilidik guegala, Bab-Dummadga-ibmar-ukleged be uko, Moisés-igar-mesisadba imakegar, adi amar wisgumalagar be nue nugusad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ar degi-inigwele, bela Jesús-nug dungumai gualid, bela wisguarmalad Jesús ibmar-imakdiid. Dulemar-bukidar duurmaknoni-damalad Jesús-itogegar, degine, na uelediid e-nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ar Jesúsdi Bab Dummadse golega nega-dule-sulidganba dulemargi bangud-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ibagwengine, Jesús dulemar-odurdaksigu, Fariseomar, degi, Judio-igar-nue-wisimalad bukwa-gusmogad. Amar bela Galilea-yargi, degi, Judea-yargi, degi, neggweburmar-nanaidgi danimalad. Degine, Jerusalén-neggweburgi danimarbalid. Agi Bab-Dummad-gangued Jesúsba gudigusad, dulemar-gegumalad-nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Degi daklealid, machergan e-ai-wargwen abgan-burgwar-nikad e-gabedgi-mai sedanimar. Amar Jesús-siidse neg-yaba e-ai-odobimalad, adi Jesús-asabin mesmalagar, ega nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ar dulemar bukidarsoggu, geg odogedbali, neg-birgi nakwismalad. Uas-egasmargu, agi dule-abgan-burgwaled e-gabedgi-mai dulemar-abargi odesmalad, Jesús-siid-inik. ");
INSERT INTO cuk09_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús a-dulemar egi gwen bensuli dakdegu, dule-gegumaidga sogded: —Dule, be-iskudii-gusad, be nugussun. ");
INSERT INTO cuk09_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Degi escribamar, degi, Fariseomar, na e-gwagegi binsadmalad, sogdemalad: “¿Wede doa-dule, emide Bab Dummadgi dodogu? ¿Unnila Bab Dummadbi sunna dulega iskued elisursi?” ");
INSERT INTO cuk09_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ar Jesús sunna ulubgi dulemar-binsaed mag daksoggu, dummagan-abin imakdegu, amarga sogded: —¿Ibiga be-ulubgi be degi-binsabukmarsunna? ¿Geg iskued osulo be an-insae? ");
INSERT INTO cuk09_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","An dule-bonigwaledga sog-dibe: ‘¡Be-iskunaid an bega osulos!’ Ar igi an sogbarsun-dibe: ‘¡Be nugu, be gwisgu, be nae!’ Degite, ¿igid bur-baisursunna imaklesunna? Suli, ebobela baisursunna imaklesuli. ");
INSERT INTO cuk09_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Degisoggu, ani Dule-Machi, dule-bonigwaled an nudakoed, adi bemar wisguegar, igi dule-bonigwaled sunna an nudake, debayobi we-napneggi dule-gwage-iskunaid sunna an nudakbalid. Jesús dule-abgan-burgwar-nikadga sogdesun: —Ani an bega soged, be gwisgu, be-egi-maid na be sede, be-negse na be nasun. ");
INSERT INTO cuk09_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Degi dule-bonigwaled yog nuguar-gusgu, emar-abargi yog gwisguar imaksad, degi, na e-gabedgi-maid na susgua, e-negse nadsunnad, Bab-Dummad-nug-odummonadap-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Agi belagwapa geger dakedbimalad, bela Bab-Dummad-nug odummodmalad. Nue dobe itomala, sogdemarsunnad: —Emi-ibagi ibmar-geger-dakleged an daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jesús dule-nudaksadgi-gwichi nadgu, agi dule-wargwen Roma-dummadga-mani-gaedgi-arbaed dakalid, Leví-nugad, mani-galeged-neggi sii, mani gasii. Jesús Levíse gote, ega sogded: —Anba be dage, an-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Degi Leví gwisgusgu, bela ibmar obes, Jesúsba naded, e-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví, e-neggi Jesúsga iba-dummad onosad. Agi dulemar-Roma-dummadga-mani-gaedgi-arbamalad bukidar bukwa, degi, baiganmo, e-mesa-naba mas gunbukwa-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Agi escribamar, degi, Fariseomar, Jesús-sapinganga sunmakarmalad, sokarmalad: —¿Ibiga dulemar-Roma-dummadga-mani-gaedgi-arbamalad, degi, dulemar-baigan-iskudidimaladba we-Jesús mas gunne, degine, eba gobbali? ");
INSERT INTO cuk09_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús, abin-imakdegu, sogded: —Dulemar-gegusurmalad ina-duled abesulid, unnila dulemar-gegumaladbi ina-duled abe-damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Deyobi, ar we-napnegse an nonigu, dulemar-nuegan-na-iskudisur-itomaladse golega an nonisulid. An nonikidi, dulemar-iskudii-na-itomaladse golega, adi na e-iskuedga bukib binsamalagar, mer bar iskumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Geb degi dulemar Jesúsga sokarmalad: —Juan-sapingan imbagwenar mas-gunsuli gudidamalad Bab Dummadse golegar. Amba deyob Fariseo-sapingan gudidamarmogad. ¿Ibiga be-sapingandi geg deyob damala? Be-sapingandi mas gundii, degi, gobdii-damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús, abin burbar sogded: —Dulemar ome-nikued-ibagi mas-gullegedse nonikile, dule-ome-nikunaid e-abargi siile, ¿sunna mas-gunsuli bemar-imako be insae? Suli, mas gunmaloe, ar weligwar itomalad. ");
INSERT INTO cuk09_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ar ibagan nonikoed, dule-ome-nikunaid e-idu seledoed. A-ibagan nonikile, agindi Bab Dummadse golega mas-gunsuli gudigumalodo. Emigindi amba an gudisoggu, an-sapingan geg mas-gunsuli gudigumardo. ");
INSERT INTO cuk09_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Geb degi Jesús ega burbar sunmakdebalid, sogded: “Ar dule mor-matumakegala geg morgo-binid mor-seredgi nasiked. Ar deyob imaksale, unnila mor-binidbi achirmakosulid, deginbali, mor-binid mor-sered-ebo na istar daklebalid. ");
INSERT INTO cuk09_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Deginbali, inna-gaibid-binid gwen ibmar-uka-bugluga-sobaled-seredgi baliledisulid. Degir, inna-gaibid mudele, buglu-sered esirmako-itole. Degir, binsa inna-gaibid milego-itole, degi, bugluse-bakar binsa miledo-itole. ");
INSERT INTO cuk09_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A-ulale, inna-gaibid-binid buglu-binidgi balileged, adi ebobela nabir igarga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Deginbali, dule inna-gaibid gobsale, bar inna-ochigwad sorba gobbisulid, ar ade soged: ‘Inna-gaibirbad bur inna-ochigwadba nuedye.’ Dule-igar deyobmodo, igar-sered geg igar-binid-ebo atoged.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ibagwengine, obunnoged-ibagi, Jesús orosgii-dakleged-digaled-abargi nadapgu, e-sapingan ibmar-digaled gwane-gwane imaknadapmala, e-argangi obu-obu imaksamargu, gutemalad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Degi Fariseomar-Jesúsba-gwen-gwen-nadapmalad Jesús-sapinganga sogdemalad: —¿Ar ibiga bemar ibmar-gwag gwane-gwane nadapmala? ¿Obunnoged-ibagi mer arbaoye igar-maisursi? Emide bemar igar-maidgi annadimargu. ");
INSERT INTO cuk09_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús, abin-imakdegu, sogded: “An-sapingan igar-maidgi annadisulid. ¿Ar wese-bakar bemar absodisurmarsi, igi David imaksa, deun David, degi, e-sordamar ukumecharmargu? ");
INSERT INTO cuk09_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","“A-ibagi David Bab-Dummadse-goled-negse dognoni-gusad, degi, madu-Bab-Dummadga-uklesad gucha-gusad. Ar David, degi, e-sordamar a-madu gunnedsulinad, ar ade madu-isedid. ¿We-madu unnila dule-irwa-Bab-Dummadse-gormaladbi gunnoye igar-maisursi? Degite, ¿David, degi, e-sordamar igar-noar imaksamala? Suli, ar ukudba nabir madu guchamalad. Degisoggu, an-sapingan nabir imaksamarmodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Geb degi Jesús sogdebalid: “Ani Dule-Machi, obunnoged-iba-e-Dummadid.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ibagwengi obunnoged-ibagi gunonibalid, deun Jesús Judiomar-onmaked-negse dognonigu, emar-odurdaksigusad. Agine, dule-wargwen, argan-nuedsik-burgwaled sii-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Agi escribamar, degi, Fariseomar, Jesús-argabukwa-gusmalad, dakega, bule obunnoged-ibagi Jesús dule-nudako-dibeye, adi egi sogmalagar, obunnoged-igar-maidgi annadiiye. ");
INSERT INTO cuk09_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ar Jesúsdi nue-wisid igi binsabukmala, a-ular dule-argan-burgwaledga sogded: —Dage, abarse be gwisguda. Agi neg-abargi dule gwisgunonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Geb degi Jesús sogded: —Ibmar-soggwen an bemarse egisbimardo: ¿Wede igar-nuedi obunnoged-ibagi ibmar-nued-imaked, igi, ibmar-iskana-imaked? ¿Igid bur-nabiri, dule-odurgued, igi, dule-oburgwed? ¿Igi bemar sogsunna? Dule-gwensaksaar abin-imaksasulid, bela boo ambikusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús bela dulemar-dikarba-bukmalad-daksagu, dule-argan-burgwaledga sogded: —Be-argan be onak. Dule e-argan onakwidgu, yog nuguar naded. ");
INSERT INTO cuk09_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Dummagan-bukmalad sae-itodmalad, na sunmakarmalad igi anmar Jesús-imakmalar-gebye. ");
INSERT INTO cuk09_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Deun a-ibagangine, Jesús yarse nade-gusad, Bab Dummadse golegar. Agi oibosad, Bab Dummadse gorsii. ");
INSERT INTO cuk09_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Oibosgu, eba-nanaimaladse gochad. Agi ambe-gakabo susad, e-sapinganga guegar. Amar-sulesad-onugsanonibalid, Jesús-nuggi-barmilearmaladye. ");
INSERT INTO cuk09_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sulesmalad wemardo: Simón, a Pedroye Jesús onugsasbalid, agine Andrés, Simón-e-urba, degine, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO cuk09_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago, Alfeo-machi Simón, Zeloteye-bimarbalid, ");
INSERT INTO cuk09_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, Santiago-e-gwenad, degi, Judas-Iscariote, darba-Jesús-uknonikid-dule. ");
INSERT INTO cuk09_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús na e-sapinganmala gulluse aidenonikid, agi nebagi e-sapinganmala, degi, dulemar-bukidar Judea-yalaganbarmalad, Jerusalénginmalad, Tiro, degi, Sidón, demar-gakagan-dorgan, amar bela Jesús-itogega nonimalad, degi, na uelemalad nugumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Agi dulemar niaburbase-nue-wiledigusmalad nudaklesmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Bela dulemar-bukidar Jesús-ebubi-damalad, ar ade Jesús-gangued-nikad, bela dulemar-onudakdiid. ");
INSERT INTO cuk09_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús na e-sapingan-dakdegu, sogded: Bemar-wilemalad, bemargi nued binsalesmalad, ar Bab-Dummad-neg-dakmaid, bemargadid. ");
INSERT INTO cuk09_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bemar-emi-uku-mesdimalad, bemargi nued binsalesmalad, ar ade bemar immerba itononimaloed. Bemar-emi-bodidimalad, bemargi nued binsalesmalad, ar ade bemar allenonimaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bemargi nued binsamaloed, ani Dule-Machi, an-nug-ular, dulemar istar be-dakarmalar, dulemar be-obannarmalar, dulemar be-ichoarmalar, degi, be-nuggi sunmakarmalar, be dule-iskanamarye. ");
INSERT INTO cuk09_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Dulemar sabsur be-imaksadba, a-ibagangi be wergumaloed, be weligwar itomaloed, ar nibneggi bemarga ibmar-uklegoed dummarbad. E-babgan bemar-idu amba sabsur Bab-Dummad-gaya-burba-berbemalad-wiosmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","¡Ar bemar mani-ibgandi wile itomaloed! Ar ade bemardi bato wegi yeer itodimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Ar bemar bato wegi immedik itodimaladdi, wile itomaloed! Ar ade be ukud itononimaloed. ¡Ar bemar bato emi alledimaladdi, wile itomaloed! Ar ade bemar nunmaked itononimaloed, degine, bemar bononimaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Ar bemargi bela-dulemar nuedbi sunmakarmalar, be dule-wilesmar! Ar deyob be-babgan Bab-Dummad-gaya-burba-berbemaladye binsa-gordimalad imaksamarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesús sogdebalid: “Ar bemar an-itobukmaladgardi an sogdo: Dule-istar-be-dakdimalad be sabgumar, dule sae-be-dakmaladga ibmar-nuegan be imakmar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Dulemar-be-ukabsadimaladgi nued egi be binsamar, dulemar be-ogakansadimaladga be Bab Dummadse ega gormar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Ar dule-wargwen wagargi be bibyosale, wagar-baid ega be oyobar. Dule bei-suba susale, mer mor-ega-uksuli be gubar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ar doa-dule bese ibmar egichialir, ega be uke. Ar dule be-ibe-ibmar susale, mer ese be bar egiso gannar bega udagegar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ar igi dulemar be-imakbi be abege, deyob dulemar be imakmogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ar dulemar be-sabmaladbi be sabguele, ¿Bab Dummadgi ibi-nued be amiosunna? Be ibmar-nued amiosuli. Ar dulemar-iskudimalad deyob dule-e-sabmalad sabgumarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ar dulemar ibmar-nued-bega-imakmaladgarbi ibmar-nued be imakmogale, ¿Bab Dummadgi ibi-nued be amiosunna? Ib-nued be amiosuli. Ar dulemar-iskudidimalad amba deyob imakmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Ar unnila dule-gannar-bega-ibmar-ukoedgarbi be ibmar wis ukele, ¿Bab Dummadgi ibi-nued be amiosunna? Ib-nued be amiosuli. Ar dulemar-iskudimalad dule-iskudimaladga ibmar-ukdamarmogad, adi sorba gannar ega ukbaligar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Degisoggu, be-istarmalad be sabgumar, ibmar-nued ega be imakmar, dule-ibmar-bei-abeged ega be ukmar, mer gannar-bega-ibmar-uked edarbedii be gumar, ar bemarga ibmar-uklegoed bur-dummarba gued, degine, Bab-Dummad-Bur-Dummadid-e-mimmiga bemar gunonikoed, ar Bab Dummad bela dulemar-sunnasurdamalad, degi, dulemar-iskanamar wile dakmaid. ");
INSERT INTO cuk09_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ar igi be-Bab dulemar-wile-dakmaimoga, degisoggu, ayob bemar dulemar-wile-dakmarmosundo.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús sogdebar: “Mer yogsaar be sogo, we dule-iskanaye, adi melle Bab Dummad deyob begi sogmogagar. Mer be sogo, we-dule-sabsur-odurdakye, adi melle Bab Dummad sabsur be-odurdakmogagar. Dulemar begi nossuliyob be dake, adi Bab Dummad egi nossuliyob bemar-dakmogagar. ");
INSERT INTO cuk09_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","“Aimarga ibmar be uke, adi Bab Dummad bega ibmar ukmogoed. Bab Dummad bega ukoed, ibmar-wilubsaleged-nuedgi, nue gindilegar, nue gwamakar, degi, nue enargwaagwadgi. Ar be ibmar wilub-imakedgine, Bab Dummad bega ibmar wilubsamogoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Geb degi Jesús burbar emarga ibmar sogded: “¿Ar dule-ibya-sulid, sunna dule-ibya-sulid-idumai guosi? ¿Ar ebobela yaa-guregedgi argwachasulir be insae? Argwachale. ");
INSERT INTO cuk09_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Dule-ibmar-durdaknaid geg e-sailaba dummad gued. Ar ibmar-durdaknaid obelosardi sunna e-odurdakedyob gumogodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jesús burbar sogdebalid: “¿Ar ibiga be-gwenad-ibyagi durgan-maid magar be dake, ar be-ibya-yaba suar-maiddi aku be dake? ");
INSERT INTO cuk09_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“¿Ar igi be-gwenadga be sogoe: ‘Be-ibya-yaba-durgan-maid an bega onogweloye.’ Ar be-ibya-yaba suar-maiddina? ¡Bemar wagar-darbomalad! Suar be-ibya-yaba-maid-insa be onoge, geb agi nabir be atakoed, be-gwenad-ibya-yaba-durgan-maid onogegar.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús sogdebalid: “Ar sapi-nuedsulid geg e-sanmaked nued sanmaked, degine, sapi nuedile, e-sanmaked geg ichakwa sanmaked. ");
INSERT INTO cuk09_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ar sapimar wargwen-wargwen na e-sanmakedgi dakleged. Ar ade higo-san ikogi sanmaksulid, degine, uva-san dub-iko-nikadgi gwen be weosurguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Anmar-dule amba deyobmodo, dule-nued, na e-gwagegi ibmar-nued-nikadba ibmar-nued onoged. Ar dule-iskanadi, dule na e-gwagegi ibmar-iskana-nikadba ibmar-iskana onomogad. Ar dule-sunmakedi, gwagegi-ibmar-naidba na sunmaked.” ");
INSERT INTO cuk09_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús sogdebalid: “¿Ibiga be anse gormala, ‘Dummad, Dummad,’ ar degite an-ibmar-sogedba be dasurmalad? ");
INSERT INTO cuk09_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Ar bela dulemar anse danikir, an-ibmar-soged itoger, degi, eba daele, an bega sogmalo, we doa sunnaa dule dae. Weyobdo. ");
INSERT INTO cuk09_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","We dule-gwensak na neg sobbargu, yaa akwisad, matusur akwisad, degi, neg-urba-gaed-akwa-birgi mesisad. Diwar noargu, diwar binnasur a-neggi yolenonikid, ar degite, gwen neg ogiglimaksasulid, ar ade akwa-birgi neg nue sobar siid. ");
INSERT INTO cuk09_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Ar dule an-gaya-burba-itosad, a-sogedba imaksasuliddi, adi we-dule weyobmodo: Dule neg sobsagu, unnila napa-birgi sobsad, neg-urba-gaed sate. Diwar noargu, a-neggi binnasur yolenonigu, neg-ayarided, neg dummad-bibichisdo. Be itogua.” ");
INSERT INTO cuk09_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús bela dulemar-e-itobukmaladga ibmar-sogsad-sorba Capernaumse dognonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Roma-sordamar-dulatar-sediid-e-mai ise-uelegar maid, burgwedani maid. A-dulede na e-mai nue sabed. ");
INSERT INTO cuk09_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Roma-sordamar-dulatar-sediid Jesúsgi-dulemar-sunmak itoargu, Judiomar-girmar-dummagan Jesússe barmialid, adi ese egisegar, e-negse dagye, e-mai ega nudakdaye. ");
INSERT INTO cuk09_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Judio-dummagan Jesússe nonimargu, egi nue wilenagusmalad, ega sognonimalad: —We-dule-e-mai wis be bendaker-gebed, ");
INSERT INTO cuk09_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ar ade anmar-neggwebur nue sabed, degine, anmar-Judiomarga onmaked-neg sobsabalid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús amarba nadsun. Neg modanigusgu, Roma-sordamar-dulatar-sediid e-aimar barmialid, Jesúsga sogegar: “Dummad, an-negse be dogsulir, akarsulid, ar an-negse be gwen dogedsulinad, ");
INSERT INTO cuk09_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","degine, an bese gwen dagedsurmoganad. Ar unnila be sogsa-sae, an-mai yog nuguar naoed. ");
INSERT INTO cuk09_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Amba an dummad-nikmogad, degine, ani an-dummadmogad, sordamar ani an sediid. Ar sorda-wargwenga an sog-dibe, be nae, yog naar-daed; baidga an sogbar-dibe, be dage, yog dagar-daed. Degine, an-maiga an sog-dibe, we be imake, yog imakar-daed. Ar deyobmogad, an-mai-burgwedani-maid, unnila be ibmar-sogsaa imakedba, sunna yog nuguar guoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Weyob Roma-sordamar-dulatar-sediid ega soge itoargu, Jesús geger-itoded, geb degi dulemar-e-sorba-duurmakdanimaladga sogdesunnad: —An bemarga sogmar, Israel-dulemargi weyob dule angi nue bensuli an dakdisulid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ar dulemar-barmilesmalad gannar negse nonimargu, daknonimalad, mai-uelemai-gusad bato nugus. ");
INSERT INTO cuk09_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesús, Roma-sordamar-dulatar-sediid-e-mai nudaksad-sorba, neggwebur-Nain-nugadse nadapgu, eba e-sapingan nadap-gusmarmogad, degine, baigan-bukidar eba nadap-gusmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Neggweburse-doged-yawagak mosgu, agi dulemar neg-uanse dule-burgwisad dignadap-gusmalad. A-dulede, mukwa-ei-sui-burgwisad-e-machi-wargwensakadid. Nain-neggweburginmalad bukidar a-mukwaba nadap-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Agi Dummad-Jesús dakargu, a-mukwa nue wile dakded, ega sogded: —Mer be boe. ");
INSERT INTO cuk09_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús dule-burgwar-maid e-ulu-semamaidse warmakdapgu, gwisgusmalad. Geb degi Jesús a-ulu ebusgu, sogded: —Sapingwa, an bega soge, be gwisgu. ");
INSERT INTO cuk09_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Geb degi dule-burgwar-maid gwisguargu, yog sunmakar-naded. Geb degi Jesús a-sapingwa e-nanga uksasunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Bela-dulemar dobe-ito nadmalad, geb degi Bab-Dummad-nug odummodmarsunnad, sogdemalad: —Bab-Dummad-gaya-burba-berbeged-wargwen-dummad anmar-abargi gwisgunonikid. Degine, Bab Dummad na e-dulemarse ataknonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Judea-yalaganba, degi, neggweburmar-a-dikarba-nanaid bela wisguarmalad, Jesús dule-burgwaled-gannar-odulosad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Deunni Juan-Bautista-e-sapingan bela Jesús-ibmar-imaksad Juan-Bautistaga sognonimalad. Agi Juan-Bautista na e-sapingan-warbose gochagu, ");
INSERT INTO cuk09_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Dummad-Jesússe barmisad, adi ese egisegar: —Ar epenne Bab-Dummad-sogsad dule-wargwen-an-bemarga-barmidagoye, ¿ar be a-dule, igi, anmar dule-baid amba edarbemaloe? ");
INSERT INTO cuk09_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ar dule-warbo-barmilealid Jesúsga sognonimalad: —Juan-Bautista bese anmar-barmialid, bese egisegar, bede, Bab-Dummad-epenne-sogsad-dule-wargwen-an-bemarga-barmidagoye, ar be a-dule sogeye, igi, anmar dule-baid amba edarbemalo sogeye. ");
INSERT INTO cuk09_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Agine, Jesús, Juan-Bautista-sapingan-wagab, dulemar-bukidar-gegudimalad, galagwensuli-bonigan-nikmalad, niaburba-nikmalad, degine, dulemar-bukidar-ibya-surmalad nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Geb degi Jesús, Juan-sapingan-abin imakdegu, sogded: —Be namar, Juanga be sognamar, ibmar be itosmalad, degi, ibmar be daksamalad: Dulemar-ibya-surmalad mag-atak an imaksad, dule-muya-muya-nanamalad nued-nanae an imaksad, dulemar-naibe-buna-ya-maleged-nikmalad swilidik an imaksad, dulemar-uaya-yallirmalad nabir-mag-ito an imaksad, dulemar-burgwismalad gannar-durguega an imaksad, degine, dulemar-wileganaga Bab-Dummad-gaya-burba-nuedgi an ega sunmaknonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Degine, Juanga be sogbalo: ‘Ar dule-an-bensuliddi, a-dulegindi nued egi binsalesye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan-Bautista-sapingana-warbogwad nadmargu, Jesús, Juan-Bautistagi dulemarga sunmakalid, sogded: “¿Ar ibiga nega-dule-sulidganba bemar arbisunna? ¿Nar-gammu burwaba aibangwichi dakega bemar arbi? Suli. ");
INSERT INTO cuk09_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","“Degite, ¿ar ibi dakega bemar arbisunna? ¿Bemar dule-wargwen-mor-nued-yoi-gudiid dakega arbimala? Suli. Ar dulemar mor-nued-yoi gudimaladdi, wergudimalad, amardi reymar-neg-yagi gudidimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","“Ar degite, ¿ibi dakega bemar arbimarsunna? ¿Bab-Dummad-gaya-burba-berbeged-dakegala? Eye, an bemarga sogmalad, a bemar daksamalad, degine, Bab-Dummad-gaya-burba-berbegedba bur-bule bemar daksamalad, ar ade we bur-dule-dummadid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ar we-dulegine bato narmakar sognaid, Mesíasgi sunmaknaigu, Bab Dummad soged: Be-iduale, anga-gaya-burba-barsoged an barmidoed, adi be-iduar bega igar-mayegar. Mal. 3:1 We-gaya-burba-barsoged, Juan-Bautistado. ");
INSERT INTO cuk09_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Ani an bemarga soged: Dulemar we-napneggi-gwalulemaid, Juan-Bautistaba bur-dummad sulid, ar degite Bab-Dummad-neg-dakmaidgi bur dule-bipigwadi, degite a-dule, Juan-Bautistaba bur-dule-dummadid.” ");
INSERT INTO cuk09_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bela dulemar Jesús-itosmalad, degi, Roma-dummadga-mani-gaedgi-arbamaladse-bakar, sogdemalad, Bab Dummad nued imaksaye, ar anmar, Juan-Bautista-digi-ogedgi oglesmarguye. ");
INSERT INTO cuk09_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ar Fariseomardi, degi, Moisés-igar-odulomaladdi Bab-Dummad-igar-emarga-uklenaid gwen abingassurmalad, Bab-Dummad-digi-ogleged Juan-Bautista-imakedi, gwen imaksasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Geb degi Jesús sogdebalid: “Degite, emi we-dulemar-bukmaladde, ¿doa sunnaa damar be insae? ");
INSERT INTO cuk09_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wemar-damaladi machimala neg-magaba-ambikuedgi ambikumaladyobdo, na muchub-muchub agi na gorbukmaladyobdo, na ega sogbukmardo: An bemarga gar-ogochamalad, degite, bemar gwen dodossurmalad. Anmar bemarga bukib-binsa namaksamalad, degite, bemar gwen bossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Degisoggu, bemar we-burwigana-binsaedsulidyob damardo. Ar Juan-Bautista we-napnegse nonigu, dule-baiganyob mas-gunsuli, degi, gobsuli gudigusad. Egi bemar sogsamalad: ‘Wedi nia egi naiye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ani Dule-Machi, andi nonigu, mas gunnonikid, gobnonikid, angi be sogmalad: ‘We-dule gadi-mas-gunned-dule, degine, gadi-vino-gobed-dule, deginbali, dulemar-Roma-dummadga-mani-gaedgi-arbamalad, degine, dulemar-galagwensuli-iskudimalad-e-aiga na saed-duled.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Geb degine Jesús sogdesunnad: “Ar dule Bab-Dummad-ibmar-wisidi, ibmar-nuegan-imakedgi mag dakle-daed.” ");
INSERT INTO cuk09_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ibagwengine, Fariseo-wargwen Jesúsgi wilenagusad, e-negse mas gunnaegar. Jesús, Fariseo-neg-yaba dogsagua, mesa-naba sigidapid mas gunnegar. ");
INSERT INTO cuk09_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A-neggweburgine ome-wargwen, ome-iskudiid-dule, itoargu, Jesús, Fariseo-neggi mas gunsiiye, gwallu-wawagwad bute-alabastro-akwagi-sobaledgi senonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ome Jesús-yarganba, e-mali-dikarba signonikid, ise-boar. Agi ome na e-ibya-nisgi Jesús-e-mali owardikusad, geb degi e-sailagiagi odinnosbalid. Ome Jesús-mali usgua, gwallu-wawaad Jesús-maligi eosad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fariseo-Jesús-nik-gochadi degi-daksagua, na e-gwagegi binsasii-gualid: “Ar we-dule, Bab-Dummad-gaya-burba-berbegedina, wisindo, we doa-dule, degine, we-ome-e-ebunaid igidi. Ar we-ome iskudiid-duled.” ");
INSERT INTO cuk09_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Geb degi Jesús sunmakdegu, sogded: —Simón, ibmar-gwensak an bega sogbido. Simón, abin-sogded: —Odurdaked-saila, be sogena. ");
INSERT INTO cuk09_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús sogdesun: —Dule-wargwengi walabo egi mani gasmalad: Wargwen egi dulataled-ilatar mani gasad, baiddi dulatar egi mani gasad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ar ebobela geg bennuk-gusmalad. Degisoggu, mani-ibed amarga sogsa-gusad: ‘Akarsurye, mer bar an-bennukmaloye.’ Anga be sogena: ‘¿Doa bur sab be insae?’ ");
INSERT INTO cuk09_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón, abin-imakdegu, sogded: —An insagua, bur-dumma egi mani-gani-gusad an insado. Jesús, abin-sogded: —Napiragwad be sogsado. ");
INSERT INTO cuk09_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ome-siidsik Jesús aibilisgua, Simónga sogded: —¿We-ome be dake? An be-negse dognonigu, be anga gwen dii uksasulid, anmar-gusgu-imakedba an-nag enukegar. Ar we-omedi e-ibya-nisgi an-nag enuksad, degine, e-sailagiagi anga an-mali odinnosbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Be an-wagar ussulid, be dog-nued noniye anga sogegar. Ar we-omedi an be-negse dogsad-akar an-mali usiid. ");
INSERT INTO cuk09_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Be an-nonogi anga gwallu-wawaad gwen eossulid, ar we-omedi an-maligi gwallu-wawaad eosad. ");
INSERT INTO cuk09_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ar degisoggu, an bega sogsun, we-ome-dummad-iskudiid ega bela elilesad, ar ade we-omede dummad-an-sabgusad. Ar dule unnila ichee ega iskued-elilesale, ichee sabgumogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Geb degi Jesús omega sogded: —Be-gwagegi iskudigusad be nugussun. ");
INSERT INTO cuk09_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dulemar-mesagi-eba-mas-gunbukmalad, na ulubgi binsadmalad, sogdemalad: —¿Ar wede doa-dulesunna, iskuedse-bakar sunna elied? ");
INSERT INTO cuk09_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ar Jesúsdi omega sogded: —Be-angi-bensulidba be iskuedgi abonolesun. Degisoggu, ulubgi be gwage-bogidikidba be nasun. ");
INSERT INTO cuk09_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Degidgine, a-ibagan-sorbali, Jesús bela neggweburmar-dummagan, degi, neggwebur-burwigana onodii-gualid, Bab-Dummad-neg-dakmaid-gaya-burba-nuedgi sunmakdii. E-sapingan-e-ambe-gakabogwad eba gudigusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Degine, omegan niaburba-iskana-nika-gusmalad, gegudii nugusmalad: María, Magdalenaye-nugad, nia-sogagugle egi onolesad, ");
INSERT INTO cuk09_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, Chuza-e-ome. We-Chuzade Rey-Herodesga neg-daked-dummadid, degine, Susana, degine, omegan-baigan-bukidar Jesúsba gudigusmarmogad. A-omegan na ibmar-na-nikamaladba Jesúsga ibmar-imakdii-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dulemar-bukidar Jesússe ambikunonigu, neggwebur-baid-baidginmalad ese nonimaladga, burbar sunmakded, sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ibagwengine, dule-wargwen-ibmar-gwag-digedi ibmar-gwag dignaded. Ibmar-gwag dignaigusgu, abala ibmar-gwag igargi babatidapid. Igargi-babatismaladgi dulemar egi annasmalad. Geb degi a-sorbali, sikwimar-niba-gukudimalad a-ibmar-gwag manonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","“Abala ibmar-gwag akwa-birgi babatismalad. Dunguargu, dinguded, ar ade neg-nisarsulid, dinnagwad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","“Abala ibmar-gwag iko-abargi babatisad. Ibmar-gwag dungudgu, ikomar eba dungudmogad. Ikomar ibmar-gwag-ichosad. Degisoggu, ibmar-gwag gwen sanmaksasursundo. ");
INSERT INTO cuk09_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“Ar ibmar-gwag napa-nuedgi-babatismaladdi, amardi dungudgu, nue sanmaksad, bela-bela sanmaksad.” Ar weyob Jesús dulemarga sunmaksigu, binnasur sogded: “Bemar mag nue itobiele, nue itomar an bemarga ibmar soged.” ");
INSERT INTO cuk09_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Geb degi e-sapingan Jesússe egichialid: —¿Wede be ibu obarsunna, we-ibmar burbar be anmarga sogsad? ");
INSERT INTO cuk09_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús na e-sapinganga sogded: “Ar bemargardi Bab-Dummad-neg-dakmaid-igar-burbar-mamaid osanalegoye maid, dulemar-baigangardi ega burbar soglegoed: Adi amba dakmar-inigwele, aku dakmalagar, ar itomar-inigwele, aku itomalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ar emi burbar an bemarga sogsadi, weyobdo: Ibmar-gwag, Bab-Dummad-gaya-burbad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","“Ibmar-gwag-igargi-babatismaladi, we Bab-Dummad-gaya-burba-sunmaked-e-wilubganad. Nia-saila sorba nonigu, dulemar-gwagegi Bab-Dummad-gaya-burba-nagusad ei osulononikid, adi mer Bab Dummadba damalagar, mer iskuedgi abonolemalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Ar akwagi-babatismaladdi Bab-Dummad-gaya-burba itosmargu, nue-weligwar abingasmalad. Ar wemar unnila askinbi Bab-abingasmarsoggu, ibmar-gwag-digaled maligan-askinnegwadyobdo. Degisoggu, ichee wis Bab Dummadba nanasmalad, ibagan-bulegan ega nonigu, Bab Dummadgi bangudmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Ar iko-imbaba-babatismaladdi, we-dulemar Bab-Dummad-gaya-burba abingasmalando, ar undargusgu, we-napneggi-ibmar-nanaid, degi, maniginbi, degi, we-napneggi unnila yeer-itodiguedse binsaed-galedmarsoggu, amar ibmar-gwag-gwen-sanmaksasulidyob gunonisundo. ");
INSERT INTO cuk09_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Ar napa-nuedgi-babatismaladdi, wemardi, Bab-Dummad-gaya-burba-itosad nue abingasmalad, gwage-nuedgi, gwage-napiragwadgi, gwen galakussuli Bab-Dummad-gaya-burbaba nanasmalad. Degisoggu, amar ibmar-gwag-nue-sanmaksamaladyob gunonisundo.” ");
INSERT INTO cuk09_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús sogdebar: “Dule gwallu ogasale, gwen ulu-yaba siosulid, degi, e-gabed-urba amba siega gwen imakdisurbalid. Dule gwallu ogasale, niba gwallu-siedgi sii-daed, adi dulemar dognonikir, gwallu-meegwad mag dakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Debayobi ibmar-bipisaale dukuosurguodo. Be-ibmar-saed bela wisgulegedsegad. Amba be dukuar ibmar saoen-inigwele, bela dulemar wisguedsegad, bela negache nononikoed. ");
INSERT INTO cuk09_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Degisoggu, nue be binsaer-gebed, igi be Bab-Dummad-itobie. Ar dule-ibmar-nikadga bur-bule ega gatik ibmar uklegoed, ar degine, dule-ibmar-satele, amba ibmar-nikuo-itogedi e-annik sulegoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús dulemar-odurdaksigu, geb degi e-nan, degine, Jesús-urbamar, Jesússe nonimalad. Ar dulemar bukidarsoggu, geg Jesússe warmak-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jesús-owisosmarsunnad, ega sognonimalad: —Be-nan, degine, be-urbamar magaba gwismalad, be-dakbimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús, abin-imakdegu, sogded: —Dule-Bab-Dummad-gaya-burba-itomalad, degi, eba-damalad, a an-nanad, degine, amar an-urbamalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ibagwengi, Jesús na e-sapinganmala urgi nakwisgu, amarga sogded: —Mata-dummad-obakar namargwelo. Geb degi nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Urgi nadapmargu, Jesús gabided. Geb degi egi mataba burwa-dummad noalid. Ur, dii-ena nagusad, degisoggu, ur-doged gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Geb degi e-sapingan Jesússe nonimargu, Jesús-odaksamalad, ega sogdemalad: —¡Odurdaked-saila, anmar-ur dogmaid, anmar bergumaloed! Jesús ataksagu, burwaga, degi, demarga binnasur sogded, be bogidik saye. Geb degi burba bogidik nadsunnad, neg swilidik sigissunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús e-sapinganga sogded: —¿Ar ibiga be Bab-Dummad-bengunonimala? E-sapingan dobe itonadmalad, degine, geger dakdemarbalid, na ega muchub-muchub sogdemalad: —¿Wede doa-dule-sunna, burwase, degi, demarse-bakar, eba ibsamargu? ");
INSERT INTO cuk09_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Geb degi Jesús na e-sapinganmala Gadara-dulemar-bukwadse modapmalad. A-negde Galilea-mata-obakar naid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús napase aidesgu, dule-wargwen Gadara-neggweburgined ese nonikid, dule-nia-dikasurgus-nikad. A-dule mor-yoisur gudii-daed, degine, neggi gabsurbalid, neg-uan-yaba gabdii-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","We-dule Jesús-dakargu, binnasur gormakdegu, Jesús-asabin yokorgi sindigar sigisgu, sogded: —Jesús, Bab-Bur-Dummad-Machi, ¿Ibiga be anse achadaniki? Napira Bab-Dummad-nuggi an bega soged: ¡Mer ise-mesagwar be an-imako! ");
INSERT INTO cuk09_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ar ade Jesús niaburba-dulegi-maidga soged: “Dulegi-be-maid, be nodaye.” Dakargu, a-dulegi niaburba-dikasurgus-maid. A-dule eskoro-dubgi, mali, degi, argan edin-damar-inigwele, dule eskoro-itir-daed, degine, nia nega-dule-sulidganba dule-ses-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ase Jesús egichiarsun: —¿Igi be nuga? Dule, abin-sogded: —Ichesulidye an nuga. Ar ade niamar-bukidar egi maid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Niamar Jesúsgi wilenagusad, melle niamar-galu-wilegoedse e-barmidmarye. ");
INSERT INTO cuk09_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Deun sinmar-bukidar yargi mas mananai-gusad. Niamar Jesúsgi wilenagusad, sinmargi an-odoye. Jesús amarga sogded, nabirye, ase be dognamarye. ");
INSERT INTO cuk09_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Niamar, dulegi ainidgu, sinmarse ubodapid. Sinmar yar-weregedgi batidgu, matase batidapid. Agi bela gundoledapmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ar sinmar-edarbemalad sin-gundolesad daksamargu, duurmakdemalad, neg-igarba-bukmaladga, degine, neggweburgi, sogdapmalad, igi sinmar gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Degi dulemar ainiarmalad neg-gusad dakegar. Jesússe nonimargu, daknonimalad, dule-nia-nika-gudigusadi Jesús-naba nue mor-yoi sii, nue-nugus sii. Dulemar deyob dakarmargu, dobee itodmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ar dulemar-dule-nugusad-daksamalad, dulemar-nonimaladga sogdemalad, dule-nia-nika-gudigusadi igi nugusa. ");
INSERT INTO cuk09_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Geb degi bela dulemar Gadara-yar-dikarbarmalad Jesúsgi wilenagusmalad, adi e-yargi e-idu naegar, ar ade bela dobee-ito nadmalad. Degi Jesús urgi nakwisgu, gannar arsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dule-nia-nika-gusad, Jesúsgi wilenagusad, e-sedegar. Ar Jesús egi bangudgua, ega sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Be-negse be nae, be sogna, ibibayobi Bab Dummad nue-wile be-daksa. Dule nadgua, bela neggweburgi sunmakdigualid, igi Jesús ega ibmar-dummagan imaksad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús gannar Capernaumse nonigu, dulemar-bukidarad ber weligwar Jesús-abingasmalad, ar ade bela Jesús-edarbedimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Geb degi machered-wargwen, Judiomar-onmaked-neggi-dummadid, Jairoye-nugad, Jesússe nonikid, Jesús-mali-naba sindigar yokorgi signonikid. A-dule Jesúsgi wilenagusad, e-negse naegar. ");
INSERT INTO cuk09_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Dakargu, Jairo unnila bunolo-wargwen nikad, birga-ambe-gakabo sergued. A-bunolode burgwedani maid. Jesús, Jairo-negse nadapgu, dulemar-bukidarad, ali-ali Jesúsgi yolenanai-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Dulemar-bukidarad-abargi ome-gwensak birga-ambe-gakabogus boni-nalur-nika-gudiid, gudimogad. A-ome na bela mani-nikad ina-duledgangi ollomaksad, ar degite gwen nudaklessulid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A-ome Jesús-yarganba nonikid, ei-mor-duku ebunonikid. Ome Jesús-mor-duku ebusgu, nalur-gudiiddi yog dinguar naded, yog nugudgu. ");
INSERT INTO cuk09_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Geb degi Jesús sogded: —¿Wede doa an-ebusa? Bela sulidbiye ega sogmargu, Pedro, degi, e-walik-bukmalad, Jesúsga sogdemalad: —Odurdaked-saila, dulemar-bukidar ali-ali be-barmesnana-naded, degite, be sogde: ‘¿Wede doa an-ebusa?’ ");
INSERT INTO cuk09_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ar Jesús, abin-imakdegu, sogded: —Dule an-ebusad, ar an mag-itoged, angi an-gangued noded dule-nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Degi, ome dakdegu, ibmar-imaksad gwen dukuar gussuli, ise-wawanmakar Jesússe nonikid, e-mali-naba yokorgi sindigar signonikid. Bela-dulemar-bukwad-abargi ome sogded, ibigarsunna Jesús-mor-duku ebunoniki. Ede, Jesús-mor-duku ebusgu, yog nuguar nadye. ");
INSERT INTO cuk09_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús omega sogded: —Omegwa, be nue an-bengussursoggu, be nugussun. Be gwage-bogidikidgi be-negse be nasun. ");
INSERT INTO cuk09_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Amba Jesús omega sunmakgwichi, dule-wargwen, Jairo-neggi danikid, Jairoga sognonikid: —Be-bunolo bato burgwis, mer be odurdaked-sailagi bar wilege bega be-bunolo-nudakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús deyob dule-soge itosgu, Jairoga sogded: —Mer be dobgu. Unnila mer be bengu, be-bunolo nuguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesús, Jairo-negse dogdapgu, dulemar eba gwen doged imaksasulid, unnila, Pedro, Santiago, degi, Juan, bunolo-e-bab, degine, bunolo-e-nan, amarbi eba dogsamalad. ");
INSERT INTO cuk09_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jesús modapgu, dakdapid bela bobukmala, degi, binnasur ise-wilegar bunologa bonanai. Jesús amarga sogded: —Mer bomar, bunolo burgwar-maisulid, unnila gabmaid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bela-dulemar-bukmalad Jesúsgi dodoarmalad, ar ade wismalad we-bunolo burgwar maid. ");
INSERT INTO cuk09_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ar Jesúsdi, bunolo argangi gasgua, binnasur sogded: —Bunolo, be gwisgu. ");
INSERT INTO cuk09_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Geb degi bunolo-e-burba gannar ese nonigu, yog gwisguar imaksad. Geb degi Jesús sogded, bunologa mas-gunned ukmarye. ");
INSERT INTO cuk09_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Bunolo-e-babgan geger dakmardo, we deyob gusad. Jesúsdi sogded, mer dule-baiganga sogmaloye. ");
INSERT INTO cuk09_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús na e-sapingan-ambe-gakabogwad danar oambikusgu, amarga bela igar-uksad, Bab-Dummad-ganguedba dulemargi niamar-oniegar, degine, dulemar-uelemalad-nudakegarbar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Geb degi Jesús na e-sapingan-barmisad, adi Bab-Dummad-neg-dakmaidgi sunmakegar, degi, dulemar-uelemalad nudakbaligar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na e-sapinganga Jesús sogsad: “Mer ibmar igarba sedmalo, suar-gaapoled suli, sagu suli, mas-gunned suli, degine, mani surbar. Deginbali, unnila mor-yoigwabi be namarbaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ar doa-negse be dogdapoe, a-negginbi be megoed, geb be naoedse. Mer neg-baid-baidgi gabdigumalo. Ar a-neggi-mai geb be baid-neggweburse naoed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","“Ar bia be-abingassurmalar, a-neggweburgi be nodmaloed, geb be-naggi-olli-nanaid nue eli-eli saoed, adi dulemar mag be-dakmalagar bemar Bab-Dummad-igargi ega sunmakapmarmoganad, degisoggu emargindo, ar Bab-Dummad-igar yapa abingamalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesús-sapingan-ambe-gakabo-guedi bela neggweburmar-burwiganase Bab-Dummad-gaya-burba-nuedgi sunmakdii-guarmalad, degi, dulemar-gegumalad nudakdii-gusmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes dummadga-maid itoargu, Jesús bela-ibmar-imakdiid, geger nue-ito naded, ar ade abar sogmalad: “We-Jesús, Juan-Bautista-burgwisad gannar durgusye.” ");
INSERT INTO cuk09_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Baigan sogmarbalid: “We-Jesús, epenne-Bab-Dummad-gaya-burba-berbeged, Elías-nugad, gannar noniye.” Degine, baigandi sogmalad: “We-Jesús, epenne-Bab-Dummad-gaya-burba-berbeged-wargwen-gudigusad gannar durgusye.” ");
INSERT INTO cuk09_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodesdi sogded: “Juan-Bautista-ibe nono an siksadde, ¿degite, wede doa-sunna, dulemar-egi-sunmak an itoged?” Degisoggu, Herodes Jesús-dakbiguarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesús-sapingan-e-ambe-gakabo-gued, Jesús-nuggi-barmilesmalad, gannar Jesússe nonimargu, ega sognonimalad bela ibmar imaksamalad. Jesús amarbi bachikii, nega-dule-sulidganba sesad, neggwebur-Betsaida-nugad-dikarba. ");
INSERT INTO cuk09_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Dulemar wisguargu, Jesús Betsaida-neggwebursik nadye, dulemar ase nade-gusmarmogad. Jesússe nonimargu, Jesús dulemar-abingasad. Geb degi amarga Bab-Dummad-neg-dakmaidgi sunmaksigisad, degine, dulemar-nudakleged-abemalad nudaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ar neg-sedogusgu, e-sapingan-ambe-gakabogwad Jesússe nonimalad, ega sognonimalad: —Dulemar be barmid, adi igarba neggweburmar-bukwadse, degi, neg-gwagwen-gwagwen igarba-mamaidgi sunna obunnomaloed, degi, agi mas-gunned sunna amimarbaloed, ar wegindi anmar nega-dule-sulidgangi-bukmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús na e-sapingan-abin sogded: —Bemar ega mas-gunned ukmar. E-sapingan, abin-imakdemarmogad: —Anmar unnila madu-gwaatar, degi, ua-ukabo nikmalad. Ar anmar degiir we-dulemar-ichesulidga mas baknaer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ar ade macherganbi-miliatar mergued. Geb degi Jesús na e-sapinganga sogded: —Danar-danar, e-dulabo-gakambe-dulabo-gakambe, be urbemar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","E-sapingan deyob imaksamalad, bela deyob dulemar-urbismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Geb degi Jesús madu-gwaataled susgu, ua-ukabogwad susbargu, niba atakdegu, Bab Dummadga dog-nuedye sogsad. A-sorba madu biske-biske imasgu, ega merguded. Geb e-sapinganga ukded, adi amar dulemarga ukmarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Degine, bela-dulemar-gudidimalad nue-immeles mas guchamalad. Mas-guchad-sorba, Jesús-sapingan madu, degi, ua-obichad, garba-gwaambe-gakabo-mergu wesmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ibagwengi, Jesús Bab Dummadse bachik gorsigusgu, deun e-sapingan eba bukwa-gusmogad. Amarse Jesús egichialid: —¿Doaye dulemar annik sogmala? ");
INSERT INTO cuk09_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","E-sapingan, abin-sogdemalad: —Gwenna-gwenna Juan-Bautistaye benik sogmalad. Baigandi sogmalad, be Bab-Dummad-gaya-burba-berbeged, Elías-nugadye. Agi baigan sogmarbalid, be Bab-Dummad-gaya-burba-berbeged-wargwen-epenne-gudigusad, gannar durgusye. ");
INSERT INTO cuk09_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús na e-sapinganga sogded: —¿Bemardina, doaye annik sogmarmosunna? Geb degi Pedro, Jesús-abin sogded: —Be Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duled. ");
INSERT INTO cuk09_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Geb degi Jesús na e-sapinganga sabsur sogded, melle dulemar-baiganga bipisaar sogoye ede Cristoye, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Degi Jesús sogdebar: —Ani Dule-Machi, nue-wileger-gebed. Judiomar-girmar-dummagan, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degine, escribamar, amar gwen an-abingaosurmalad, an-oburgwemaloed. Geb degine, ibapaagi gannar an durgubaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Degine, Jesús bela-dulemarga sogded: “Ar dule-wargwen an-sapinga gubiele, na dukin san ieger-gebed, nakrus bane-bane semaiyob nanaer-gebed, bato burgwenadapidyob, geb a-dule anba dagodo, geb a an-sapinga guodo. ");
INSERT INTO cuk09_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Ar dule-wargwen anba-naid-ular burgwebisulir, e-san-burba ei yogguodo. Ar anba-naid-ular burgwenonikirdi, adi na-e-san-burba yogguosurdo. ");
INSERT INTO cuk09_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Ar ibi-nuedga dule-wargwenga gusar be insae, a-dule napneg-naid bela egadga imaksar, geb edi na bergusar, ar e-san-burbadi yoggusar? Suli. Ibmar-nuedga ega gussuliled. ");
INSERT INTO cuk09_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Ar dule-gwensak an-nug-ular bingegusale, degi, an-gaya-burba-ular bingegusbalile, ani Dule-Machi, a-dulegi an bingegumogoed, an ganguedgi, degi, an-Bab-ganguedgi, degi, anger-swilidikmalad-abargi an danikoedgi. ");
INSERT INTO cuk09_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Ar napira an bemarga soged, gwenna-gwenna wegi-bemar-bukmalad burgosulid, amba dula gudii, Bab-Dummad-neg-dakmaid bese noni be dakedsemalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesús, na e-burgoedgi sunmaksad iba-baabakgus-dibe, a-sorba, Pedro, Juan, degi, Santiago sesa-gusad, yar-birse nakwided, Bab Dummadse golegar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesús Bab Dummadse gorsigusgu, e-wagar-dakleged gwagded, e-mor bela dagudik, dakar-dakar dakle naded. ");
INSERT INTO cuk09_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Geb agi Jesús-sapingan-warbaagwad dakdemar dulemar-epenne-dula-gudigusmalad, Moisés, degi, Elías, amar-warbogwad Jesúsmala sunmakgwichi. ");
INSERT INTO cuk09_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Amar, gwallu-meegwad-abargi gwichi, Jesús Jerusaléngi-burgoedgi, degi, we-napneggi-bangudoedgi sunmakgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, degi, baigan-eba-gudidimalad, gabed egi nue-obin itomar-inigwele, nue ataksamargu, Jesús-gangued, e-yeer-dakleged daksamalad, degi, dulemar-warbo Jesúsba gwichid daksamarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Degi, amar-warbogwad Jesúsgi bangudsokarmargu, Pedro, Jesúsga sogded: —Odurdaked-saila, we nueddo, wegi anmar gudigu. Anmar wegi obunnoged-neg-gwapaa sobmalodo: Gwagwen bega, baid Moisésgar, geb baid Elíasgarmo. Ar ade Pedro itosulid, yogsaar gole-gole gwichid. ");
INSERT INTO cuk09_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ar weyob Pedro sunmakgwichi, mogir emar-birgi nagunonikid. Dobe itodmalad, mogir emargi dognonigu. ");
INSERT INTO cuk09_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Degi mogir-imbaba gaya-burba gollar, sogded: “We An-Machi-sabedi gued, a be nue itomar.” ");
INSERT INTO cuk09_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Degi-sunmaked bergusgu, Jesús-sapingan dakarmalad unnila Jesúsbi wargwen gwichi. A-ibagangi Jesús-sapingan dulemar-baiganga ibmar-daksamalad gwen sogsasurmalad, bela daska edukusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A-oibosadgine, Jesús na e-sapingan-warbaagwadmala yar-birgi-gudiidgi aidearmargu, dulemar-bukidar ese nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Agi dule-wargwen, dulemar-bukidarad-abargi binnasur gote, sogded: —Odurdaked-saila, an-machi anga wis be dake, ar webi wargwen an wis nikad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dakargu, burba-iskana an-machigi nagunonikir, binnasur gote-daed, degine, binnasur wawanmakde-daed, gayaba maku-maku guar-daed, burba-iskana binnasur imak-daed, degine, bar indakbisur guar-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Be-sapingangi an wilesanad, adi ega niaburba onogegar. Be-sapingan ega gwen nia-onossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús, abin-imakdegu, sogded: —¡Bemar Bab-Dummadgi-bengumalad-dulemar, bemar Bab-Dummad-igar-oakalogedmar! ¿Sanase bemar-abargi an gudiguosunna, bemar mer an-bengumalagar? ¿Sanase mag be itomaloe? Budar an bemar-daked-danikid. Be-machigwa anse be sedage. ");
INSERT INTO cuk09_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Machigwa Jesússe danigu, niaburba machigwa-omukusad, degi, binnasur owawanmakded. Ar Jesúsdi niaburba-iskanase uluded, degi, machigwa-nudaksad. Geb degi e-babga machigwa-uksasunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jesús niaburba-iskana onosadba, bela dulemar Bab-Dummad-gangued geger dakedbimalad. Bela-dulemar Jesús-ibmar-imakdiid, geger dakbukmala, Jesús e-sapinganga sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ar nue be itomar we an-ibmar-sogoed, mer ieged be imakmalo, ar ade ani Dule-Machi, dulemarse uklegoed, an-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Weyob Jesús ega ibmar sogsad e-sapingan aku-itosmalad, ar ade emargi odukulegar gusad, adi aku-itomalagar. E-sapingan dobedba Jesússe gwen egichissurmalad, we ibi ega nue obarisa. ");
INSERT INTO cuk09_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Geb degi Jesús-e-sapingan na muchub-muchub abin-abin imakarmalad, doa-bur-dummadga guoye. ");
INSERT INTO cuk09_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ar Jesús, e-sapingan-gwage-binsanaid mag daksagu, machi-bipi-wargwen-susad. E-walik ogwichisgu, ");
INSERT INTO cuk09_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","e-sapinganga sogded: —Ar doa-dule an-nuggine we machi-bipi ber nue-weligwar abingaele, an-abinganaiyob gunaid. Aginbali, ar doa-dule an-abingaele, dule-an-barmialid abinganaido. Ar ade na bemar doa-bur-bipigwadi, a bur-dule-dummadid. ");
INSERT INTO cuk09_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan, Jesús-abin imakdegu, sogded: —Odurdaked-saila, anmar dule-wargwen-daksado be-nuggi niamar-onodii. A-dule anmar-sordasursoggu, anmar ega sogsado, mer Jesús-nuggi bar niamar-onogoye. ");
INSERT INTO cuk09_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús, abin-sogded: —Mer a-dule-ibe igar-bisko. Ar dule anmargi yoledisulile, a-dule, we anmar-sordado. ");
INSERT INTO cuk09_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesús nibnegse-naed-e-ibagan warmaknonigu, Jesús, Jerusalénse nue naed sokarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús igarba nadapgu, e-iduale na dulemar-barmisad. Amar nadgu, Samaria-neggwebur-bipigwadse dogdapmalad, adi agi idu guagwar neg-amimalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ar Samaria-neggwebur-bipigwadginmalad Jesús-gwen-abingassurmalad, ar ade daksamalad Jesús Jerusalénse naesokalid. ");
INSERT INTO cuk09_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","E-sapingan, Santiago, degi, Juan, deyob daksamargu, Jesúsga sogdemalad: —Dummad, ¿anmar nibneggi-soo-odedabi be abege, igi epenne Elías imaksamoga, adi wemar bela-ogumakegar? ");
INSERT INTO cuk09_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Geb degi Jesús amar-warbogwadsik atakdegu, amarga sabsur ibmar sogded: —Ar bemar na be wichurmardo igi-daed-burba be nikmala. ");
INSERT INTO cuk09_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ar ani Dule-Machi, nonigua, dulemar-san-burba-oyogguegala an nonisulid, an nonikid, dulemar-san-burba-abonogegar. Geb degi Jesús na e-sapinganmala neggwebur-baidse nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesús na e-sapinganmala nadgua, dule-wargwen igarba ega sokalid: —Dummad, ar bia be naoe, an beba naiguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús a-dulega sogded: —Ar usmardi na e-gubya nikmalad, sikwimar-niba-gukudimaladdi na e-uu nikmarbalid, ar andi Dule-Machi, andi na neg sated. Anyob be unni nanamogale, anba be dagodo. ");
INSERT INTO cuk09_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús dule-baidga sogded: —Anba be dage, an-sapinga guegar. Dule abin-sogded: —Dummad, bina an-babse an nagwelo, an-bab-burgwedse geb beba an naoed. ");
INSERT INTO cuk09_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús ega sogded: —Ar dulemar-burbar-bato-burgwar-gudimalad, we-napneggi na e-burgwarmalad-digoed, ar bedi, nae, Bab-Dummad-neg-dakmaidgi dulemarga be sunmaknae. ");
INSERT INTO cuk09_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Geb degi dule-baid Jesúsga sogdemogad: —Dummad, an beba naoed, ar bina an-neg-yaginmaladga degimaloye an sognagwelo. ");
INSERT INTO cuk09_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús aga sogded: —Ar dule neg-imunaidgi akas-dibe gwen yarganba baratakdisulid. Ar dule yarganba atakele, we-dule Bab-Dummad-neg-dakmaid geg egadga gued. Deyobmodo, dule binsaed-darbo-damalad, Bab-Jesúsba nagubibali, degi, we-napnegginedba ibmar imakbibardo. ");
INSERT INTO cuk09_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","We-ibmar deyob gusad-sorba, Dummad-Jesús na e-sapingan-baigan e-dulapaa-gakambe, bela na e-naoed neggweburmarse ebo-ebo e-iduar barmisad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesús amarga sogded: “Napira an bemarga soged, nainugi ibmar-gwag-weleged bukidarad, ar e-wemaladdina ichee gued. Degisoggu, nainugi ibdula-gwag-weleged-e-ibedse be wilesakwaa egismar, adi e-nainuse ibdula-gwag-wemalad-barmidagegar. ");
INSERT INTO cuk09_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Be namar, emigi an na be-barmidmar, bemar sibad-wawaad-sapingwagwadyob, achu-burburumalad-abargi. ");
INSERT INTO cuk09_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mer mor-sagu sedmalo, mani-sagu surbar, degi, sapat surbar, degine, igarba mer dulemarga suitii nued-sogeye sunmakgwichi be gumalo. ");
INSERT INTO cuk09_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Ar doa-negse be dogdapoe, agi bina be soggweloed: ‘We-neggi bemar gwage-bogidikidgi gudigusunye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","“Ar a-neggine dule-gwage-bogidikidgi-nanaed maile, be-ega-sogsadyob a-dulegi gwage-bogidikidi beoed. Ar degisulirdi, be-ega-sogsadyob gwen guosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Bemar unnila neg-gwagwenginbi be gabmaloed, degine, ibu bega gunnega, igi, gobega ukarmar-dibe, be gunno, be gobo. Ar ade dule-arbaed nue-bennukleged ega igar-maid, a-ular nabir bemar mas gunmogodo, degine, nabir gobbalodo. Mer neg-baid-baidgi gabdii-gumalo. ");
INSERT INTO cuk09_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ar ibi-neggweburse be dogdapo-dibe, be-abingasmalale, ar ibi-mas-gunned bega ukarmalale, be gunnoed. ");
INSERT INTO cuk09_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","A-neggweburgi dulemar-uelemamaid be nudakoed, degine, dulemarga be sogoed: ‘Bab-Dummad-neg-dakmaid bemarse warmaksasunye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Ar ibi-neggweburse be dogdapo-dibe, agi be-abingassurmalale, be e-galimbaba noalidgi, be sogoed: ");
INSERT INTO cuk09_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Be neggwebur-olli anmar-sapatgi-nagusadse-bakar anmar eli-eli imakmar, bemargi gwisgumalagar. Adi dulemar mag be-dakmalagar, anmar bemarga Bab-Dummad-igargi sunmakapmarmoganad. Degisoggu, bemargindo, bemar yapa Bab-Dummad-igar-abingamalad. Wedi bemar wisgubi anmar abedo, Bab-Dummad-neg-dakmaid bemarse warmaksasunnad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Ani, Jesús, an bemarga soged, Bab-Dummad-igar-nabogoed-ibagangi, neggwebur-be-abingassurmalad, Sodoma-neggweburba bur-bule sabsur odurdaklegoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús sogdebar: “¡Corazín-dorgan be wilesmar! ¡Betsaida-dorgan be wilesmar! Ar bemar sabsur odurdaklenonikoed. Ar Tiro-neggweburgi, degi, Sidón-neggweburgi we-ibmar-dakledisurmalad imaklesana, a-neggweburmar bato dikasurgus sagumor yosmalanad, degine, burugi obsamarbalinad, adi oyogegar, emarde na e-iskuedga bukib ulubgi nue itosmarye. ");
INSERT INTO cuk09_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Degisoggu, an bemarga sogsun, Bab-Dummad-igar-nabogoed-ibagangi, bemar bur-bule Tiro-dorganba, degi, Sidón-dorganba sabsur odurdaklemaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Emide bedi Capernaum-dorgan, na be nibnegse-onakwiles-gusadyobi, be-nug-ogannoles-gusanad. Emigindi, uluba-odurdakleged-negse odelegoedyob, be-nug iskunonikoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús, dulapaa-gakambe barminaidga sogdebar: “Ar dulemar be-itomalale, an-itomardo. Ar dulemar be-abingasurmalale, an-abingasurmardo. Ar dulemar an-abingasulile, dule-an-barmialid-abingasurmardo.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","E-dulapaa-gakambe Jesús barmisadi gannar nonimargu, ise-weligwar-ito nonimalad, Jesúsga sognonimalad: —Dummad, niamarse-bakar be-nuggine anmarba ibmar imasmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús amarga sogded: “Mer be dummarba na san itomalo. Ar nia-saila-Satanás na-dummarba-itosadbali an daksad, nibneggi mar-gaedyob argwate.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jesús e-sapinganga sogdebar: “Emide be dake, bemarga gangued an uked, naibemar-birgi, degine, diormar-birgi annaegar, degine, bela be-istarad-Satanás-ganguedgi, nakwegar. Amar gwen be-oakalogosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Degi-inigwele, mer bemar weligwar itomar niaburbamar bemar-sogedba ibmar imakedgi, bur be wergumar, bemar-nug nibneggi narmakar-naid-ular.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Geb agi Jesús Bab Dummad Burba Nuedba nue-weligwar ito naded, sogded: “Baba, an be-nug odummosun, bedi nibneg, degine, napneg e-Dummadid, degine, bedi dulemar-ibmar-wismaladgi, dulemar-ibmar-magar-itomaladgi, an we-ibmarmar imaksad, aku-ito be imaksad, dulemar-baisursunnagwadga bur be osanalosad, adi amar magar itomalagar. Eye, Baba, ar ade deyob be abesad.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesús sogdebar: “Bela-ibmarmar an-Bab anga uksad. Dulemar wargwensaar Bab-Dummad-Machi-mag-daked satemalad, unnila Bab Dummadbi mag daked, degi, Bab-Dummad-aku-dakmarbalid, unnila E-Machibi mag Bab-daked, ar doaga E-Machi na e-Bab-osanalobie, agarbi na osanaloged.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesús na e-sapinganse aibilidgu, amargarbi sogded: “Dulemargi we nued egi binsalesad, dulemar bemar-ibmar-dakedyob dakmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ar ani an bemarga sogmalad, bukidar Bab-Dummad-gaya-burba-berbemalad, degi, reymar, emi-bemar-ibmar-daked, dakbi-gusmalanad, amar gwen daksasurmalad, degi, amar emi-bemar-ibmar-itoged, itobi-gusmalanad, amar gwen itossurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Agine, Moisés-igar-mamaid-oduloged-wargwen, gwisgualid, Jesúsga sogded, yamo yardakegar: —Odurdaked-saila, ¿burba-geg-bergued an nikuegala, ibu an imaker-gebe? ");
INSERT INTO cuk09_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús, abin-sogded: —¿Bab-Dummad-igar-maidgi igi narmakar maisunna? ¿Igi be absodisunna? ");
INSERT INTO cuk09_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","A-dule, abin-imakdegu, sogded: Dummad, be-Bab-Dummad, bela be-gwagegi be sabguoed, bela be-san-burbagi, bela be-ganguedgi, bela be-binsaedgi. Dt. 6:5 Degine, be-san na be sabguedyobi, dule-baid be sabgumogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús aga sogded: —Nued be an-abin-imaksad. Ar be sogsadyob be imakdo, geb agi be degi-sadegu dula gudiguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ar Moisés-igar-maid-oduloged-nue-wisid na dukin nudakbisoggu, Jesúsga sogded: —¿Degite, doa-dule-baid an sabguer-gebsunna? ");
INSERT INTO cuk09_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús, abin-imakdegu, sogded: “Ibagwengi dule-wargwen Jerusaléngi aidedani-gusad, Jericóse. Igarba danigu, atursamalad argangingusad. Atursamalad sarsosmargu, bela ei-ibmar susmalad, burgwedani mete nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Dakargu, Judio-wargwen, dule-irwa-Bab-Dummadse-goled, a-igarba aidedani-gusad. Dule-yegus-mellemaid daksagu, egi bakar nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Amba deyob Judio-baid, Levita, dule-irwa-Bab-Dummadse-goled-bendaked-wargwen, dule-yegus-maid walikgusgu, daksamogu, egi bakar nade-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ar dule-wargwen, Samariagined, igarba nadapmogu, dule-yegus-maid-daknonimogad. Ar we-dule Judiosur-inigwele, dule-yegus-maid-dakdegu, nue-wile dakded. ");
INSERT INTO cuk09_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Samariagined dule-yegus-maidse warmakdapgu, nailikusmaladgi ega ina imaksad, ibmar-gwallu, degi, vino, egi eosad. Geb degi ega nue morgogi edichabalid. Degine, Samariagined e-moli-birgi dule-nailikusad-onakwisgu, meged-negse senonikid, degine, agi nue akwisad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“A-banedgine, Samariagined nasokargu, mani-gwabo onosad. Neg-dakedga mani uksagu, ega sogded: ‘Nue we-dule be anga ako. Degine, igi-mani-napi egi be misale, gannar an aibilisar, an be-bennuknonikoed.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Moisés-igar-maid-oduloged-nue-wisidga Jesús sogded: —Be itogua, we-dulemar-e-warbaagwad ¿doa bur dule-nailikusad sabedgi bendas be itosunna? ");
INSERT INTO cuk09_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Moisés-igar-maid-oduloged-nue-wisid Jesúsga sogded: —Ar dule bur-nue dule-nailikusad wile daksad, a-dule bur dule-baid nue sabgusdo. Geb degi Jesús ega sogded: —Samariagined dule-baid-bendaksadyob, deyob be imaknamosundo. ");
INSERT INTO cuk09_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús na e-sapinganmala igarba nadapgu, neggwebur-gwensakse dogdapid. A-neggweburgi ome-wargwen, Marta-nugad, na e-neggi Jesús-abingasad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","We-omede urba-nikad, Maríaye-nuga. María Jesús-walik sigisad, Jesús-ibmar-odurdaked itosii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ar Martadi ibmar-saedginbi binsanaisoggu, obir-obir gunaisunnad. Marta Jesúsga sogded: —Dummad, ¿emi be baisur dake, an-urba wargwen arbaega an-imaknaigu? Degisoggu, ega be soge, wis an-bendakye. ");
INSERT INTO cuk09_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús, abin-imakdegu, sogded: —Marta, Marta, surbinsa be itonaid, degi, obir-obir be itonaid ibmar-yaisur-saedba. ");
INSERT INTO cuk09_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ar unnila ibmar-soggwenbi bur-nuedid. María ibmar-soggwen-nued bur susad, an-sunmaked-itogegar, a-ibmar Maríagi gwen egwallegosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ibagwengi Jesús neg-soggwengi Bab Dummadse gorsiid bergusgu, e-sapin-wargwen ega sokalid: —Dummad, be anmar-odurdake, Bab Dummadse goledgi, igi Juan-Bautista na e-sapingan-odurdaksamoga. ");
INSERT INTO cuk09_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús, abin-sogded: —Be Bab Dummadse gollarmalar, weyob be sogmaloed: Anmar-Bab nibneggi maid, be-nug swilidik obariledii-gusun. Na be-neg-dakmaid anmarse dage. Be-ibmar na be-sogedba igi nibneggi imaklege, deyob we-napneggi-imaked be imakmo. ");
INSERT INTO cuk09_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Emi-ibagi mas unnitibali anmarga be udage. ");
INSERT INTO cuk09_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anmar-begi-iskusad anmarga be osulo, igi dulemar anmargi nosale, anmargi-nossulidyob anmar dakdamogadyob. Iskuedgi wilubdaklegedse mer warmaked be anmar-imak, bur iskuedgi obined be anmar-sae. ");
INSERT INTO cuk09_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús na e-sapinganga sogdebar: “Ar doa bemar-wargwen wegi ai-gwensak be nikmalale, nega-gabigwengi ese be nadmalar, ega be sogdapir: ‘An-ai, madu-walapaa wis be anga udagwer, ");
INSERT INTO cuk09_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ar an-ai-dikasur-danikid anse ataknonikid, emide ibmar-an-ega-uked sated.’ ");
INSERT INTO cuk09_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Dule neg-yaba-maid be abin-imakar-dibe, bega sog-dibe: ‘Mer be anse gole, an-yawagak bato atiarsiid, degine, an-mimmiganmala bato anmar gabmamaid. Degisoggu, geg an bar gwisgued, geg an bega madu uked.’ ");
INSERT INTO cuk09_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","“Ani Jesús, an bemarga soged: Ar be-ai-inigwele bega gwisgusulile, ar egi be alamaknaidba bega gwisgualirdo, ibmar-be-abeged bela bega uksaled. ");
INSERT INTO cuk09_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ar ani an bemarga soged: Be Bab Dummadse ibmar egismar, Bab Dummad bega ukmaloed; be Bab Dummadse ibmar amimar, be amimaloed; be Bab Dummadse gatik gormar, bega Bab Dummad yawagak egaoed. ");
INSERT INTO cuk09_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","“Ar bela dulemar-ibmar-egismalad, ibmar abingadamalad; ar dule ibmar amiele, amidamalad; degine, dule golele, ega yawagak egale daed. ");
INSERT INTO cuk09_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Ar doa emi be bab guedgi, be-mimmi bese madu egichialile, ega be akwa ukoe? ¿Igi, bese ua egichialile, ega be naibe ukmaloe? ");
INSERT INTO cuk09_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Igi, bese gannir-akwa egichialile, ega be dior-ukosi? Suli, ega be ukoe, bese-ibmar-egisnaid. ");
INSERT INTO cuk09_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ar bemarde dulemar-iskana-inigwele, be-mimmiganga ibmar-nuegan uked be wismalad. Ar be-Bab-nibneggi-maid bursunna, bemarga E-Burba-Nued-ukodo, dulemar-ese-egismaladga.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ibagwengi Jesús dule-geg-sunmakedgi nia-ononai-gusad. Nia dulegi nodgu, dule nabir-sunmak-naded. Dulemar degi-gusad geger dakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gwenna-gwenna sogdemalad: “Beelzebú, nia-saila, a-sogedba wedi niamar-onodiid.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Baigan, yamo Jesús-wilubdakegala, ese egichiarmalad, ega Bab-Dummad-ganguedba ibmar-wilubgan-dakledisulid imakye, adi nue wisgumalagar, Bab-Dummad-nuggi nue ibmar imakdiiye. ");
INSERT INTO cuk09_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ar Jesúsdi, emar-binsanaid mag daksoggu, amarga sogded: “Rey-gwensak na neggwebur dakmaid, ar e-sordamar na dukin-dukin egi aibinnarmalale, we-neggwebur bergudeled. Aginbali, dulemar na e-neg-yaginmalad na dukin-dukin egi aibinnarmalale, we-neg bergudeled. ");
INSERT INTO cuk09_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ar ambamodo, nia-saila-Satanás na dukin egi aibinnalir, ¿sunna na e-neg-dakmaid bergussulir be insae? Bergudele. Emide bemar sogmalad, Beelzebú-nuggi an niamar-onodiiye. ");
INSERT INTO cuk09_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","“Ar ani, nia-saila-Beelzebú-nuggi an niamar-onodiile, ¿be-sapingandi doa-nuggi niamar-onodimarmosunna? Nia-saila-ganguedbarsuli. Degisoggu, ar be-sapingan bemarga oyonado, bemar noar sogdimalad, nia-saila-sogedba an niamar-onodiiye. ");
INSERT INTO cuk09_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","“Ar Bab-Dummad-sogedba niamar an onodiile, we bemarga oyonado, Bab-Dummad-neg-dakmaid bemarse warmaknoniye.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jesús sogdebar: “Ar dule-wargwen-dutusulid, guagwar na espunyar gani e-neg akwediile, na bela e-ibmar-neggi-nikad dule geg ei atursaed. ");
INSERT INTO cuk09_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ar dule-baid eba-bur-dutusulid nonikir, egi nakwisar, ei-espunyar susar, ar a e-bendakoye binsadinad. Geb degi dule-bur-dutusulid sunna neg-ibed-ibmar ei susundo. Ani Jesús, an deyobmodo, ar an-bur-dutusulid, nia-sailagi an obinsoggu, sunna niamar an onosundo. ");
INSERT INTO cuk09_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ar dule anba dasulile, angi gwisgudiido, ar dule anga dulemar-danar-urbedisulile, bur we dule anga dulemar-ichodiido, mer anba naguegar.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús sogdebar: “Ar niaburba dulegi nodele, neg-dinnaganaba obunnoged-neg amidii-daed. Ar neg-obunnoged amisursoggu, sogdasunnodo: ‘An-neg an mete-alidse gannar an dognaoye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","“Ar na e-negse na modapogu, dakdapoed, nue neg durwiar sii, degi, nue neg nudakar sibar. ");
INSERT INTO cuk09_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Geb degi niaburba deyob daksale, gannar naodo, e-sordamar-walagugle eba-bur-bulegan-damalad sedagegar. Niaburbamar a-negse dognonimalogu, na e-negga imakdemaloed. Ar dule epenne-e-daedba aka-bur-bule iskudsunnodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ar Jesús weyob sunmaksigu, dulemar-bukidar-bukmalad-abargi ome-wargwen binnasur gote, Jesúsga sogded: —Ome we-napnegse-be-senonikid, degine, e-nuugi be-onusad, we-omegi bur-nued egi binsalesad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús, abin-sogded: —Ar dulemar bur-nued egi binsalesmaladdo, we-dulemar Bab-Dummad-gaya-burba itosmargu, a-sogedba nanadimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dulemar-bukidar ese duurmaknonimargu, Jesús sogded: “Emi-ibagi we-dulemar, dule-iskanamar, unnila ibmar-wilubgan-dakledisurmalad-oyolegoedbi amidimalad. Ar a-e-wilubgan ega oyolegosulid, ega bur oyolegoedi, Jonás-gusadyob. ");
INSERT INTO cuk09_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","“Ar igi Jonás Nínive-dorganga-e-wilubganga-gusa, deyob, ani Dule-Machi, dulemar-emi-dula-gudidimaladga oyolemogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Reina-yalasikid-neg-dakmaid, Bab-Dummad-igar-nabogoed-ibagangi, bemar-emi-dula-gudidimalad-abargi gwisgudagogu, bemar sabsur-odurdakye sogdagoed. Ar ade we-omegwa bela-bela dikasur dani-gusad, dad-Salomón dule-binsaed-ibed-nikad itogegar. Ar emigindi, Salomónba bur-bule dule-binsaed-nikad wegi bemar-abargi gudiid, ar degite, bemar an-itobisurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","“Machergan-Níniveginmalad, Bab-Dummad-igar-nabogoed-ibagangi, we-dulemar bemar-emi-dula-gudidimalad-abargi gwisgudagogu, bemar sabsur odurdakye sogdagoed. Ar ade Jonás, Bab-Dummad-igargi sunmaksagu, Nínive-dorgan na e-iskuedga bukib binsas-gusmalad, na e-daed gwagsamalad. Ar emigindi, Jonásba bur-bule dule-dummad wegi bemar-abargi gudiid, ar degite, bemar be-iskuedga na be bukib binsasurmalad, be-daed na be ogwasurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús sogdebar: “Ar dule gwallu ogasale, odukuega ogasulid, degine, ulu-urba-siega ogasurbalid, e-sied-birgi-siegala ogaleged, adi dulemar-ubomaid mag neg dakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Gwallu, anmar-san-mee-saedi we anmar-ibyado. Ar be-ibya nuedile, bela be-san ibegwar naido. Ar be-ibya iskanale, bela be-san neg-sichidgi gudimodo. ");
INSERT INTO cuk09_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","“Degisoggu nue be salakarmar, we neg-meegwad-begi-naidi, melle neg-sichidga-gued be imakmar. ");
INSERT INTO cuk09_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ar degisoggu, bela be-san ibegwalele, neg-sichid egi naisulile, bela ibegwar guodo, ar igi gwallu bela ibegwar neg imakedyobmodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús sunmaked bergusgu, Fariseo-wargwen ese nonikid, egi wilenonikid, e-negse mas gunnaegar. Jesús a-Fariseo-negse dogdapgu, mesa-naba signonikid mas gunnegar. ");
INSERT INTO cuk09_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseo, Jesús-daksagu, mas-gunned-idu gwen argan enuksasuli, geger dakded. ");
INSERT INTO cuk09_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ar Dummad-Jesúsdi ega sogded: “Nabir, emi bemardi, Fariseomar, askinbi na dule-nued-imakmalad-dulemalad, noga, degi, bate, unnila askinedbi nue bemar enukmaladyobid. Ar yabardi ibmar-atursamalad, degi, galagwensuli-damalad, ena bemar sedidimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","“¡Bemar nue-akusunna-itomalad! ¿Ar Bab Dummad ibmar-magabalid-imaksad, ar a amba yabalid-imaksabarsursi? ");
INSERT INTO cuk09_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Degisoggu, na be-ibmar-nikad, wileganaga be ukmar, geb degi ibmar bela bega swilidik guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ar ¡bemar-Fariseomar, na be dule-wilesmar! Ar bemar ibmar-burwiganase-bakar, menta, ruda, degi, gagan nuegan-nabir-gullemalad ambegi-gwensak Bab Dummadga be ukdimalad. Ar dulega-igar-nudaked, degi, Bab-Dummad-sabgueddi gwen be imakdisurmalad. Ar bemar wemar-imaked nabirid, degine, amba ibmar-burwigana bemar imakdiid, imakbalodo. ");
INSERT INTO cuk09_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ar ¡bemar-Fariseomar, na be dule-wilesmar! Ar bemar Judiomar-onmaked-neggi dummagan-gan-sigedginbi sigbi-damalad, degi, ibmar-ukleged-neggi dulemar bela bese goledbimalar, bemar yeer-ito damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ar ¡bemar-escribamar, degi, Fariseomar, bemar dule-wilesmar, bemar wagar-darbo-damalad! Bemar neg-uan-aku-daklemaladyobmalad, dulemar wichurmalad, na neg-uan-birgi garmakdimalad. Ayob, dulemar aku-be-dakmarmogad, bemar ulubgi-iskudiid.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Moisés-igar-maid-oduloged-wargwen, Jesúsga sogded: —Odurdaked-saila, weyob be ibmar sogele, anmargi nue be gwisgumodo. ");
INSERT INTO cuk09_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús, abin-sogde: “¡Ar bemar Moisés-igar-maid-odulomarmogad, bemar dule-wilesmarmo! Ar bemar dulemarga beedse-dutusur igar mesmalad. Ar degite, bemar dulemar-gwen-bendaksurmalad igar-mesisadba dulemar nanamalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Ar bemar dule-wilesmar! Ar be-dadgan Bab-Dummad-gaya-burba-berbemalad-oburgwismalad e-neg-uan be sobdimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Degisoggu, bemar-sunnad nue wismarmodo, degine, be-dadgan-ibmar-imaksad nabir-be-dakmalad-dulemalad. Ar napiragwad, be-dadgan Bab-Dummad-gaya-burba-berbemalad-oburgwismalad, bemardi, e-neg-uan ega be sobdimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“A-ulale, Bab Dummad bela-bela binsaed-nued-nikadba sogsabalid: ‘An amarga Anga-gaya-burba-berbemalad, degine, an-nuggi-barmilesmalad, an barmidoed. An-dule-barmismalad gwen-gwen oburgwemaloed, degine, abar bareginmaloed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Deyob bemar imakoed, adi bela Bab-Dummad-gaya-burba-berbemalad, gebesaila napneg-naguded-akar be-dadgan oburgwis-gusmalad, emi bemar-dula-gudidimaladgi ataklemalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel-oburgwilesad-akar, Zacarías-oburgwilesadse, deun be-dadgan Bab-Dummadga-ibmar-gummakar-ukleged-galu-siid, degi, Bab-Dummadse-goled-neg-sunnad-siid-abargi Zacarías-oburgwis-gusmargu. Napira an bemarga sogmalad, we-dulemar-oburgwilesmalad emi bemar-dula-gudidimaladgi ataklemaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Ar bemar, Moisés-igar-maid-odulomalad, bemar dule-wilesmar! Ar bemar Bab-Dummad-igar-wisgulegoed-yabi be susmalad, bemar Bab-Dummad-neg-dakmaidse gwen dogsasurmalad, degine, dulemar-ase-dogdanimaladga igar-dutusur bemar mesdimalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ar weyob Jesús sogsagua, escribamar, degi, Fariseomar nue-sae-itodmalad, imakdemalad, gatik Jesús-osunmaked, ");
INSERT INTO cuk09_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","adi dakega, abakalegi Jesús ibmar-wis-akar sokalile, adi Jesús-ibmar-sogedgi egi sorba gwisgumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aka-degidgine dulemar-bukidar mili-miliba Jesússe nonimalad, na bar mesnana guarmalad, degidgine, Jesús na e-sapingan-insega ega sokalid: “Nue salakarmar, Fariseomar-madubur-inagi, ar amar wagar-darbo-damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Ar bipisaale ibmar-dukuar-imaklegedi magadse buud noosurdeeye gwen soglesulid, degi, ar emi amba ibmar-dukualed, wisgulegosurdeeye gwen soglesulid, wisgulegedse daed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ar degisoggu, bela neg-sichidgi be-ibmar-sogsad, gwallu-meegwadse onolegoed. Ar na be-binnaa uayagi neg-yaba ise yawagak-edualedgi be sogsan-inigwele, be-ibmar-sogsad neg-uas-birgi binnasur soglegoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús sogdebar: “An-aimar, an bega sogmar: Mer be dobgumar, dulemar-be-san-oburgwebimalad, ar a-sorbardina geg bar be oakalomalad. ");
INSERT INTO cuk09_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","An be-odurdakmaloed, doa bur bemar dobgue-wilubmala. Bur Bab Dummad be dobgumar, ar adi be-oburgwisad-sorba sunna soo-saila-geg-berguedse be-metebalid. Eye, nabir an bega sogmar, bur Bab Dummad be dobgumar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Ar ade sikwi-gwaatargi esnon-gwabogi uklesursi? Ar degite, sikwi-gwagwensaale Bab Dummad iemaisulid. ");
INSERT INTO cuk09_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ar bemar-sailagiase-bakar bela ebisar Bab Dummad sediid. Degisoggu, mer be dobgumar, ar bemar bur-bule sikwimarba bur-ibmar-nueganad. Ar degisoggu, bemar-bursunna, Bab Dummad bur-bule nued be akwemalodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jesús sogdebar: “An bega sogmar, ar doa-dule dulemar-asabin na sog-dibe, an Cristoba naiye, ani Dule-Machi, an sogmogodo, Bab-Dummad-angermar-asabin, we an-sordaye. ");
INSERT INTO cuk09_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ar doa-dule dulemar-asabin an-osulosardi, adi Bab-Dummad-angermar-asabin an osulomogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ar bela dulemar Dule-Machigi iskana sunmaksa-dibe, Bab Dummad sunna amarga iskued elioed. Ar dule Bab Dummad Burba Nuedgi galagwensuli egi dodoar sunmaksardi, adi e-iskusad Bab Dummad ega gwen eliosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Dulemar Judiomar-onmaked-negse be-senonimalar, igar-nabiromalad, degi, dummagan-baigan bega igar itomalagar, mer be bukib binsamalo, ibi an sogo-dibeye, degi, igi an sunmako-dibeye, ");
INSERT INTO cuk09_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ar be sunmak-sokalile, Bab Dummad Burba Nued bemarga sogoed, igi be sogoe.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dulemar-bukidar-bukwad-abargi dule-wargwen Jesúsga sokar: —Odurdaked-saila, an-iaga be soge, an-bab burgwisgu, anmarga-ibmar-obesad, anga udamoye. ");
INSERT INTO cuk09_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesúsdi, abin-sogded: —Dule, ¿doa igar-naboged-dummadga an-nug imaksa? ¿Doa ibmar-mimmied-dummadga an-nug-imaksa, bemarga ibmar mamaregar? ");
INSERT INTO cuk09_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Degi Jesús dulega sogdebar: —Nue salakar, ibmar-we-napneggined-bina-yaisur-itoged-daedgi nue salakarmar, ar ibmar-ichesur-nikadgi dule san-dula-gudiguosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Geb degi Jesús emarga burbar sunmakde, sogded: “Dule-mani-ibed ibmar-yaisur-nikad, e-nainugi ibmar-digsagu, ega nue sanmaksado. ");
INSERT INTO cuk09_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na wargwen dukin ulubgi binsadii, sogded: ‘¿Igi an saoe, ar bia an ibmar-gwag emide an sabogoe?’ ");
INSERT INTO cuk09_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Na sogdesun: ‘Weyob an saoed, ibmar-gwag-saboged-neg an earoed, bur-dummad an soboed, agi an bela ibmar-gwag, degi, an-ibmarmar an sabogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Geb degi an na ga dukin sogoed: Na ibmar-bukidar bega birga-ichesulidba an sabos, degisoggu, be obunno, be gobe, be mas gunne, be wergusun.’ ");
INSERT INTO cuk09_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ar Bab Dummaddi a-dulega sogdedo: ‘Be dule-aku-ibmar-itoged-dule, emi-mutikidba be-san-burba an sudanikir, be ibmar-urbisad, ¿degite, doagadga guosunna?’ ");
INSERT INTO cuk09_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ar dule deyob gunoni-dado, unnila na dukin egadga ibmar urbed, ar Bab Dummadgindi gwen binsasulir.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Geb degi Jesús na e-sapinganga sogded: “Degisoggu an bemarga sogmar, mer surbinsa be san-dula-gudiidgi be itomar, ibu an gunno-dibeye, degine, be-sangi mer be binsabar, ibu an yoo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ar be-san-burba mas-gunnedba bur sunsogedid, degi, be-san mor-yoedba bur nuedid. Anmar dula gudiid, bur-biriginedid, we mas-gunnedba, degine, we mor-yoedba. ");
INSERT INTO cuk09_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“Emi be dakmalana, sikwi-sichidmar, gwen ibmar-gwag digdisurmalad, degi, gwen ibmar-gwag sabogega wedisurmarbalid, deginbali, ibmar-urbed-neg satemarbalid, degi, ibmar-gwag-urbed-neg amba satebalid. Degite, Bab Dummad mas ega ukmaid. ¿Ar bemarde sikwimarba bur-bule nuedsursi? Eye, bur-nuedi. Degisoggu, Bab Dummad bemarga mas-gunned ukmogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“¿Ar doa-dule na gatik-egi-binsaedbali sunna na-e-san osuguo be insae? Suli, osuguosuli. ");
INSERT INTO cuk09_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ar bemar we-ibmar-bipigwad-bela geg be samaladde, degite, ¿ibiga ibmar-baigan-bina surbinsa be itomarsunna? Mer surbinsa be itomala. ");
INSERT INTO cuk09_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ar be dakmalana, sapur-dutumar ibibayobi dungud-dae, gwen arbasurmalad, gwen na e-mor sobsurmarbalid. Ar an bemarga sogmardo, degite Salomón, mor-bela-yeer-daklemalad yosan-inigwele, ar dutumaryob gwen mor yossurgusad, dutumar bur Salomón-morba yeer dakleged. ");
INSERT INTO cuk09_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ar gagan-sapurbarmalad emi dulad, banedgi bato a-gaganmarde soo-yagi ogumaklesiid, degite, Bab Dummad yeer-dakle ega mor yoed. Ar degite, bemar bulesunna, Bab Dummad bemarga mor ukmogodo, bemar Bab-Dummad-benmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ar degisoggu, mer be bukib binsamar, ibu an gunno-dibeye, igi, ibu an gobo-dibeye. Eye, degine mer surbinsa be itomar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","“Ar dulemar-we-napneggi-Bab-Dummad-wichurmalad we-ibmarmar amididimalad. Ar be-Bab be-wisid, we-ibmarmar bemar abemalad. ");
INSERT INTO cuk09_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","“Ar Bab-Dummad-neg-dakmaid bur be amimar, geb adi bela we-ibmarmar bemarga uklemai-gumaloed.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús sogdegar: “Mer be dobgumar, ar bemar an-sibad-wawaad-ichegwadyobid, ar be-Bab nabir na e-itogedbali bemarga na e-neg-dakmaid ukoed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Ibmar-nikmalad na be ukmarsun, degine, wileganaga mani be ukmar. Mani-sagu-geg-nungued be sobmar, ibmar-nuegan geg-nibneggi-bergued agi be urbemar, adi atursamalad ase geg warmaked, degine, ibmar-udumesed geg ase warmakbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","“Ar be-ibmar-nuegan nibneggi sabolesiile, nibneggi be binsadii-gudoed. Be-ibmar-nuegan napneggi sabolesiirdi, adi be napneggi binsadii-gudoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús sogdebar: “Bemar guagwar gudii-samar, igi dule-arbamalad guagwar molidub-nai e-sabangi gudidamala, degine, be gwallu guagwar ogaar simar, we-a sogledo, be guakwaa gudigumarye. ");
INSERT INTO cuk09_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Igi dulemar, na e-dummad, ome-nikued-ibase nader, guagwar edarbedii-damala, adi e-dummad gannar nonikir, ese gornonikir, yawagak ega yog egaar imakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","“We-maimargi nued egi binsalegodo, e-dummad nonikir, e-idu guagwar sii daknonikir. Ar napira an bemarga soged, e-dummad na dukin molidub e-sadergi edinnogua, e-maimar mesa-naba siged imakoed, na e ega mas-daknai-guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","“Ar e-dummad neg-gabgwengi noniko-dibe, igi, bolegwadbar-dibe, daknonikir nue nakulebukwa, we-maimargi nued egi binsalegodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jesús sogdebar: “Ar we be nue wisigarmar, ar dule-neg-ibed wisile, igi-wachigi atursaed danikoe, idu guagwar sigisaled, ei-ibmar atursaega imaksasuliled. ");
INSERT INTO cuk09_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Degisoggu, bemar guagwar gudii-samar, ar ade be wichurmalad sana, ani Dule-Machi, an danikoe.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Geb degi Pedro Jesúsga sogded: —Dummad, ¿we be burbar anmarga be ibmar sogsad, anmargarbi be soge, igi, bela baiganga be sogmoga? ");
INSERT INTO cuk09_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Degi Dummad-Jesús abin-sogded: “¿Ar doa degite mai-nued, nue binsaed nikaa, geg galakuedga guosunna? Mai-deyobidi, na e-dummad na e-neg-dakega nug-saodo, adi wachi-sekalaa mai-baiganga mas-gunned dakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ar we-maigi nued binsalegodo, adi e-dummad gannar nonikir, daknonikir, ar nue deyob arbanai.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Geb degi Jesús sogded: “Napira an bemarga soged, mai-e-dummad bela na e-ibmar-nikadi we-maiga ukoed bela ega ibmar dakegar.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jesús sogdebar: “Ar mai-iskanardi, na e-gwagegi sokar-dibe: ‘An-dummad amba yoggudoed.’ A-ular mai-baigan, omegan, degi, machergan sarsoalir, degi, mas yaisur gunnalir, gobbalir, mungualir. ");
INSERT INTO cuk09_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ar na e-dummad a-ibagi, a-wachigi danikoed edarbesisulidgi nonikogu, daknonikoed, deyob gudii. Degisoggu, dummad sabsur mai-odurdaknonikodo, Bab-Dummadgi-bengumaladba sabsur odurdaklemogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ar we-mai, e-dummad igi ibmar-abe-daed wisinad degi-inigwele, guagwar gudigussulid, degine, e-dummad-sogedba ibmar imaksasulid. Degisoggu, sabsur odurdaklesunnodo, ichesur bibyolesunnodo. ");
INSERT INTO cuk09_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ar dule-wargwendi ibmar-odurdakleged-imaksan-inigwele, wichulidba deyob imaksasoggu, unnila ichee wis bibyolegodo. Ar ade dule-wargwenga ibmar-ichesur imakega ega uklesale, ase ibmar-ichesur egislemogoed. Ar ichesur ega ibmar-akwed ega uklesale, ase bur-bule ese egislemogoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús sogdebar: “We-napnegse soo-ogaega an nonikid. ¡Bato we-soo gamaina-yerban! ");
INSERT INTO cuk09_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nue an-dummad-wilegoed. ¡Ibiyobi an nue-wile itoge, we a-ibagangi deyob an guedse! ");
INSERT INTO cuk09_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“¿Ar we-napnegse an nonigu, napneg bogidik-saega an noni be insae? An bega sogmala, suli. An nonikidi, dulemar na muchub-muchub urwed onogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","“Ar emi onodoedgi, gwenadgan na e-ataledi, warbaa warbogwad-ebo urwenanai-gumaloed, degi, warbogwad, warbaase urwenanai-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bab na-machigi yolenai-guoed, degi, machi na-babgi yolenai-gumogoed. Nana na-sisgwagi yolenai-guoed, degi, sisgwa na-nangi yolenai-gumogoed. Saka-bundor balagi yolenai-guoed, degi, bala saka-bundorgi yolenai-gumogoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús dulemar-bukidaradga sogdebar: “Wegi anmar yargi dad-argwanedsik mogir-ainaksii be dakmalale, bemar sogmalad: ‘Di-wied dani.’ Ar deyob gunoni-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ar burwa yarsik gormairdi, bemar sogmalad: ‘Neg-ued dani.’ Ar deyob gunoni-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","“¡Bemar wagar-darbo-damalad! Ar bemar napneg, degi, nibneg-igargan-gumaloed mag dakmaladde, degite, ¿ibiga we-ibagangi-ibmar-gunaiddi aku bemar dakmarsunna? Bemar mag dake-wilubmardo.” ");
INSERT INTO cuk09_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús sogdebar: “¿Ar ibiga bemar-sunnad geg be dakmala, wede bule igar-napiragwad-dibe? ");
INSERT INTO cuk09_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dule-igar-nabogedse istar-be-dakdiid-bebo ase nadapir, igarba igar-naboged be imake, adi melle dule-igar-nabogedse be-sedegar, degi, adi melle suar-ibedga be ukegar, degi, suar-ibed melle eskaryagi adi be metegar. ");
INSERT INTO cuk09_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Napira an bega soged, be-eskaryagi-mellesiid be noosurguodo, bela begi-mani-galesad be bennukedse.” ");
INSERT INTO cuk09_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Deun a-ibagangi dulemar Jesúsga sognonimalad, igi Pilato Galilea-dorgan-oburgwismala, degi, igi a-abe ibmar-durgan-Bab-Dummadga-ogumakar-ukleged-abe-ebo oburus-gusmala. ");
INSERT INTO cuk09_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús amar-abin-imakdegu, sogded: “¿Bemar insagua, wemar-Galilea-dor weyob burgwismarsoggu, Galilea-dorgan baiganba bur-bule iskanamar be insae? ");
INSERT INTO cuk09_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","An bega sogmar, suli, degisuli. Ar bemar na be-iskuedga be bukib binsasurmalale, be-daed be gwagsurmalale, bemar burgwemarmogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","“Siloégi e-ambe-gakabaabakgi neg malusad, deun amar burgwis-gusmalad, ¿be insagua, amar Jerusaléngi-bukmaladba bur-bule neg gagadimar be insae? ");
INSERT INTO cuk09_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","An bemarga sogmar, suli, degisuli. Ar bemar na be-iskuedga be bukib binsasurmalale, be-daed be gwagsurmalale, bemar burgwemarmogodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Weyob Jesús burbar sogde-gusbalid: “Ibagwengine, dule-wargwen na e-nainugi higuera-sapi digsa-gusad. Higuera-sapi-durbamaked omosgu, e-durba aminonigu, sate daknonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","“Dule-sapigi-nakulegedga e-nainu-ibed sogded: ‘Emide birgapaagus we-higuera-sapise an nanadanikid, e-durba gwanegar. We-sapi geg sanmaksoggu, be omukusun. ¿Ar ibiga binsa napa gani-guosunna?’ ");
INSERT INTO cuk09_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Sapigi-nakuleged sogded: ‘Dummad, mer be omukugwer, amba we-birgagi wis napi ogwised be sae, bina ebilis napa an imugwelo, sapi-osanmaked-ina an urbegwelo. ");
INSERT INTO cuk09_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ar sanmaker sanmakoed, ar degisulirdi, geb be sapi omukusunnodo.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ibagwengi obunnoged-ibagi deun Jesús Judiomar-onmaked-neggi dulemar-odurdaksii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A-ibagi ome-wargwen birga-ambe-gakabaabakgus uelediid sii-gusmogad. A-ome yargan-dure-nanaed, nia-geg-inikii-nanaed-imaked-nika gudiid. ");
INSERT INTO cuk09_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús a-ome dakargu, a-omese gocha, ega sogded: —Omegwa, be bonigwar gudiid, we-bonigangi be ollorgussun. ");
INSERT INTO cuk09_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús a-omegi e-argan mesisgu, ome-yargan yog inikii naded, geb degi ome Bab-Dummad-nug ogannodsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ar Judiomar-onmaked-neggi-dummadga-gudiid sae-itod Jesús obunnoged-ibagi ome-nudaksadba. A-ular dulemarga sogded: —Ar iba, iba-nergwa arbaega naisursi, a-ibagi be dagmardo, nuguegar. Mer obunnoged-ibagi nuguega be dagmala. ");
INSERT INTO cuk09_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Geb degi Dummad-Jesús, abin-sogded: —¡Be wagar-darbo-daed! ¿Ar bemar belagwapa obunnoged-ibagi be-moli-bebe-nikad, degi, moli-uaya-suid e-gabedgi be esikdisurmarsi, sedega, digi ogobnaegar? ");
INSERT INTO cuk09_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","We-omede, Judiod, Abraham-wagwad, nia-saila-Satanásde birga-ambe-gakabaabakgus edinnar sediid, ¿geg ande we-omede obunnoged-ibagi esikde, nudakegar? ");
INSERT INTO cuk09_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ar Jesús weyob sogsagu, Jesús-istarmalad bela binge-ito nadmalad. Ar dulemar-baigandi bela weligwar itodmalad, Jesús bela ibmar-dakledisulid-nuegan imaksadba. ");
INSERT INTO cuk09_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús sogdebar: “¿Bab-Dummad-neg-dakmaid, we igi an sogmalar-gebe, ibi-ebo an wilubdakmalar-gebsunna? ");
INSERT INTO cuk09_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ar weyobsundo, mostaza-e-gwag dule-wargwen na e-nainugi digsayobdo. Dungudgu, sapiga gusdo, geb degi sikwimar-niba-gukudimalad a-sapi-anagangi sunna gabsundo.” ");
INSERT INTO cuk09_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Degi Jesús gannar sogdebar: “Bab-Dummad-neg-dakmaid, ¿ibu-ebo an wilubdakosunna? ");
INSERT INTO cuk09_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ar weyobsundo, madubur-inayobdo, ome-wargwen ilapaa-madubur-wilubsaedgi, madubur-ina obatisad, geb degi madubur-ina binna-binna madubur ganoni-daed, bela omuedse.” ");
INSERT INTO cuk09_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús Jerusalénse nadapgu, neggwebur-dummaganba, degi, neggwebur-burwiganba dulemar-odurdakdii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Degi dule-wargwen ega sokalid: —Dummad, ¿ar unni-ichee iskuedgi wis abonolemaloe? Jesús, abin-sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gatik yawagak-garagwadgi doged be imakmar. Ar nabir an bemarga sogmalad, ar bukidar a-yawagakgi dogbi-gudamaloen-inigwele, ar degite geg doge-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Ar bab-na-neg-sediid bato yawagak-edugega gwisgusar, yawagak-edisad-sorba, be magaba-gwichi gollalir, ega be sokalir; ‘Dummad, anga yawagak be egae.’ We-dule be-abin imakalir, sunna bega sogoed: ‘An be wichuli be bia daniki.’ ");
INSERT INTO cuk09_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Geb degi bemar ega sunna sogdagoed: ‘Anmar be-asabin mas guchamalad, anmar be-asabin gobsamalad, degine, anmar-neg-imbaba, be anmar-odurdakdii-gusad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ar a-dule be-abin-imakdamaloed: ‘An bega sogmar, an be-wichurmar, ar be bia danimala. Bela bemar angi bangumar, bemar ibmar-iskana-imakmalad-dulemar.’ ");
INSERT INTO cuk09_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ar bemar dakarmalale, Abraham, Isaac, Jacob, degi, bela Bab-Dummad-gaya-burba-berbemalad, Bab-Dummad-neg-dakmaidgi gudii, ar bemardi agi gudisuli, geb agi boed, degi, nue-dummad-wilesiidba nugar-gorsii be gudamaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“Ar dulemar dad-nakwedsikid, dad-argwanedsikid, dad-nakwed-nuedsikid, yalasikid, danimaloed, mesa-naba mas-gunnega signonimaloed, Bab-Dummad-neg-dakmaidgi. ");
INSERT INTO cuk09_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Emigi, ar dummagan-bukidar dule-sorbarmaladga guoed, degine, dule-sorbarmalad, dummaganga gumogoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A-ibagi Fariseomar-gwenna-gwenna na nonimalad, Jesúsga sognonimalad: —Wegi be noe, be nae, ar Rey-Herodes be-oburgwebied. ");
INSERT INTO cuk09_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús, abin-sogded: —Be namar, we-dule usyob-daedga be sognamar: ‘Be dake, an niamar-onodiid, degine, emi-ibagi an dulemar-nudakdiid, degine, bane an dulemar-nudakbaloed, geb achur an-arbaed an obelogoed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ar degi-inigwele, emi, banedse, degine, achur, an naer-gebed, ar ade geg gued, Bab-Dummad-gaya-burba-berbeged, Jerusalén-neggweburgi bannaba burgwed, Jerusaléngi burgwer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Jerusalén-dor, Jerusalén-dor, Bab-Dummad-gaya-burba-berbemalad be oburgwedimalad, bemarse-barmilearmalad bemar akwagi be makdimalad! ¡Ilabigwa bela-be-mimmigan danar an na-urbebi-gusana, ar gannir na e-sakan-urba na e-mimmigan-urbe-daedyob, bemar yapagusmalad! ");
INSERT INTO cuk09_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Degisoggu, be-neg, nega-dule-sulidganyob gunonisunnoed, bei melledoed. Ar an bemarga sogsun, emigindi bar be an-dakosurmalad, ar geb bemar sogedse: We-dule Bab-Dummad-nuggi danikid, bela ega ibmar ib-nuedga guena-gadinye.” ");
INSERT INTO cuk09_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ibagwengine, obunnoged-ibagi, dule-dummad-gwensak, Fariseo-wargwen, a-negse Jesús dogdapid, mas gunnegar. Agi Fariseomar Jesús-argabukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Degi Jesús-asabin dule-abgan-mued-nikad sii-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Geb degi Jesús, Moisés-igar-mamaid-odulomaladga, degi, Fariseomarga, sunmakalid, sogded: —¿Ar wede obunnoged-ibagi igar-mai dule-nudaked? ");
INSERT INTO cuk09_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ar amar gwen Jesús-abin imaksasurmalad. Jesús, dule-bonigwaled ebusgua, nudaksad. Geb degine, negse dule-nudaksad barmisad. ");
INSERT INTO cuk09_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Geb degi Jesús Fariseomarga sogded: —¿Ar doa bemar be-moli-uaya-suid, igi, moli-bebe-nikad-dibe, bei dia-yagi argwachar, ar obunnoged-iba-inigwele, yog onoar be imaksasulir be insae? Be onosmalale. ");
INSERT INTO cuk09_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ar Jesús-weyob-ibmar-sogsad geg abin-imakgusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús dulemar-mas-gunnega-ese-gollesmalad daksagu, dummagan-gan-sigedse bur signaddamala, Jesús burbar sunmakded, sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Dule-wargwen bese gocha-dibe, ome-nikued-ibase dagega, mer dummagan-gan-sigedgi be sigo, ar abakalegi dule-baid beba-bur-nug-nikadse gollesmogale. ");
INSERT INTO cuk09_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","“Ar dule-bese-gochad be-dakarsunna, degine, dule-baid-dakarbarsunna, bega sokarsunna: ‘We-gangi-be-siid, we-dulega be uke.’ Geb degi be nue binge, gan-napi-siidgi be signadele. ");
INSERT INTO cuk09_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ar bese ibase-dagega gollesar, bur gan-napi-siidgi be sige, ar adi dule-ibase-dagega-bese-gochad be-dakalir, bega sogegar: ‘An-ai, dummagan-gan-sigedgi bur be sigdage.’ Geb agindi dulemar-beba-mesagi-siid-abargi bur be-nug dummaa guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Ar ade dule-wargwen na-nug dummarba na saele, a-dule nug bur-bipii guoed. Ar dule na-nug bipii na saerdi, adi a-dule-nug bur odummolegoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Dule-mas-gunnega-ese-gochadga Jesús sogded: “Masgi dulemar be ogunbiele, mer be-aimarse be golo, mer be-urbamarse, mer be-iamarse, mer be-gwenadganse, degine, mer be-dikarba-mani-ibed-mamaidse be gorbalo. Ar deyob be imakale, abakalegi amar bese gollarmogale ese mas gundagegar. Ar degiile, bato be bennuklegodo. ");
INSERT INTO cuk09_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Ar be mas-gulleged-iba onoalir, dulemar-wileganase be gole, dulemar-argan-surmaladse, dulemar-muya-muya-nanamaladse, degi, dulemar-ibya-surmaladse. ");
INSERT INTO cuk09_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Geb agi begi nued binsalegoed. Ar ade we-dulemardi geg be-bennuked. Dulemar-gwage-nuegan-gannar-durgumaloed-ibagine, geb Bab Dummaddi be-bennuknonikoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Dule-wargwen-mesagi-Jesúsba-siid Jesús-ibmar-sogsad itosgu, ega sogded: —Dule-wargwen Bab-Dummad-neg-dakmaidgi mas gunnoed, a-dulegi nued binsalesdo. ");
INSERT INTO cuk09_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Geb degi Jesús ega sogded: “Ibagwengine dule-wargwen mas-gunned-iba-dummad onosiid, dulemar-bukidarse gochado, ese mas gundamalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mas-gulleged-wachi mosgu, na e-mai-barmisad dulemar-gollesmaladga sogegar: ‘Dagmar, bato bela mas guagwar siid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ar bela wargwen-wargwen sogdemalad, ar emarde geg dagmarye. Gebesailad sogded: ‘Nainu an na baksad, an a-daknaer-gebed, degisoggu an bega sogsun an bese wis naosurye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Baid sogdemogad: ‘Moli-bebe-nikad-warambe an baksad, an daknaer-gebed, degisoggu an bese naosurmogad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Baid sogdebalid: ‘Emiskwaa an ome-nikusad, degisoggu an bese naosulid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Mai, e-dummadse gannar nonigu, bela e-dummadga sognonikid, igi dulemar ega sogsamalad. Dule-iba-onosiid e-mai-ega-sogsad itosgu, nue sae-itoded, e-maiga sogded: ‘Gwae be dulemar-bukidar-ambikumaladse nae, neggwebur-igarba dulemar-wilegana be sedago, dulemar-argan-surmalad, dulemar-muya-muya-nanamalad, degi, dulemar ibya-surmalad, amar be sedagoed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Geb degi a-sorba mai sognonikid: ‘Dummad, be-anga-ibmar-sogsadba an imaksad, degite, amba neg engussulid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Geb degi dummad na-e-maiga sogded: ‘Be nae, igar-dummaganba, igar-burwigana-yarba-mamaidba, dulemar wese sedaged be imako, adi an-neg enguegar. ");
INSERT INTO cuk09_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ar an bega sogmar, iduar-dulemarse-an-gochad, a-dulemardi an-mas gunnosurmalad.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ibagwengine, dulemar-bukidar Jesúsba duurmaknadap-gusmalad. Jesús amarsik atakdegu, amarga sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ar dule-wargwen anse danikile, ar e-bab, e-nan, e-ome, e-mimmigan, e-iamar, e-urbamar, e-bunmar, degi, e-san-burbase-bakale anba-bur-bule-sabele, geg an-sapinga gued. ");
INSERT INTO cuk09_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Igi dule burgwenadapile, na e-nakrus semai-dae, deyobi dule-anba-naid guakwaa burgwega nanasulile, a-dule geg an-sapinga gued.” ");
INSERT INTO cuk09_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jesús sogdebar: “Ar bemar-wargwen na neg-matusur-warakwaagwad sobbiele, ¿idu sigsursi, itogega, igi-mani abelegoe, degine, mani unnitiba nikbar-dibe a-neg oguegar? ");
INSERT INTO cuk09_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ar be deyob imaksulile, degir abakalegi e-urbalid mesisar mani-akudedba oguarsulile, degir bela dulemar begi dododago-itole. ");
INSERT INTO cuk09_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Sogdamalo-itole: ‘We-dule neg-matusur-warakwaagwad sobdendo, be dakena, gwen ogussurgusdo.’ ");
INSERT INTO cuk09_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“¿Deginbali, ar doa-rey, baid-rey ese urwe-danikir, gebesaila sigsursi, dakegar, sunna mili-ambe-sordamar-na-nikad mili-dulagwen baid-rey-sordamar-sedanikidgi obino-dibeye? ");
INSERT INTO cuk09_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ar rey na galakuo itogele, baid amba dikasur-danikidgi sunna ese dulemar-barmided, rey-baidse egisega igi saer, ebo igar-nabogo-dibeye, mer ebo urwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Ar amba deyobmodo, bemar an-sapingala-gued-iduar nue bela na be ibmar ise-binsaar be saer-gebed, bela na be-ibmar-nikmalad bela iesulile, geg an-sapinga be gumardo. ");
INSERT INTO cuk09_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Balu ib-nuedid, ar balu sayee naderdi, ¿igi be bar balu-balu gannar saosunna? Bar saosuli. ");
INSERT INTO cuk09_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Balu, napaga, degi, napa-nudakedga bar gussuliled, neg-magaba miledsunnardo. Ar bemar mag nue itobiele, nue itomar, an bemarga ibmar soged.” ");
INSERT INTO cuk09_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bela Roma-dummadga-mani-gaedgi-arbamalad, degi, dulemar-galagwensuli-iskudimaladye-nik-sogmalad Jesús-itogegala ese nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseomar, degi, escribamar uurmakarmalad, sogdemalad: —We-duledi, dule-iskudimalad-abingaedid, degine, eba-mas-gunbalid-dulebalid. ");
INSERT INTO cuk09_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Geb degi Jesús burbar emarga sunmakde, sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Ar doa-dule bemar sibad-wawaad dulatar-nika-dibe, bei wargwen yoggusar, nega-dule-sulidganba sibad-wawaad dulabake-gakambe-gakabakebakad obessulir be insae, sibad-wawaad-wargwen-yoggusad aminaegar? ");
INSERT INTO cuk09_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Be amisale, be-gukingi weligwar-ito be mesisaled. ");
INSERT INTO cuk09_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","“Ar na be negse nonikile, be-aimar, degi, be-dikarba-mamaid be-negse ese be gochaled, ega be sogdeled: ‘Anba bemar wergumarmo, ar an-sibad-wawaad ani yoggusad, an amisad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Degisoggu, an bega sogmar, ar nibneggi bur-bule we werguedba wergumaloed, dule-iskudiid-wargwen na e-iskuedga bukib binsasar, gwagnonikir, we dulabake-gakambe-gakabakebak-nuegan gudiid, na e-iskuedga gwen bukib binsabi abedisurmaladga.” ");
INSERT INTO cuk09_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesús sogdebar: “Ar ome-wargwen, mani-gwaambe-nikad, ei gwagwen yoggusar, ¿gwallu ogassulir be insae, neg durwinagusar, mani amiedse imaksasulir be insae? Mani amiedse imaksale. ");
INSERT INTO cuk09_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","“Ar mani amisale, na e-aimarse gologu, e-neg-dikarba-mamaidse gorbalogu, amarga sogdagodo: ‘Anba weligwar bemar itomarmo, ar ani mani-yoggusad an amisad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","“Ar deyob an bemarga sogmardo, Bab-Dummad-angermar, ber weligwar ito-damalad dule-wargwen na e-iskudiidga bukib binsasar, nugunonikir.” ");
INSERT INTO cuk09_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús sogdebar: “Ibagwengine, dule-wargwen masmala-warbo-nika-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Machi-bipigwad e-babga sokalid: ‘Baba, angadga-ibmar-yoedse-guoedi anga be udage.’ Degine, e-bab ibmar mimmidsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“A-ibagan ichee-naded-sorba machi-bipigwad bela na ibmar onmaksagu, dikasur yar-baidse naded. Agine, ibmar-nikadi na bela obelosad, galagwensuli gaamakdii-gualid. ");
INSERT INTO cuk09_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ar na mani-nikadi bela obelosgu, a-yargi ukud-dummad nagunonikid. Degisoggu, nue wilearsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","“Degi machigwa a-yargi dule-wargwense arbaed-aminaded. Dule na e-nainuse machigwa-barmisad, ega sin-akwegar. ");
INSERT INTO cuk09_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Machigwa ukud-surbinsa itossoggu, dule ega mas-gunned uksurmarsoggu, sin-mas-gunnedi gunbi-guarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Degi machigwa mag na neg-itoargu sogded: ‘Ibibayobi an-bab-neggi an-babga-arbamaladdi mas-bukidar-gunned nika, andi wegi ukudba burgwedanigu. ");
INSERT INTO cuk09_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","An gwisguoed, an-babse an naoed, an ega sogdapoed: Baba, an Bab Dummadgi nue nosad, degine, begi an nue nosbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Degisoggu, bar be-machiye an bilegedsulid. Bega arbaed-wargwenga be an-imaksun.’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Machigwa gwichibin imaksad, na e-babse arsunnad. “Machigwa amba dikasur daniki, e-bab bato daksad, na wile e-machi-dakded, ese abarmakded, ise-angaagwar dukarba e-machi-gadapid, degi, ei-wagar udsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“E-machi na e-babga sogded: ‘Baba, an Bab Dummadgi nue nosad, degi, begi an nue nosbalid, degisoggu, bar be-machiga an guedsulid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ar e-babdi e-maimarga sogded: ‘Bur mola-nued an-machiga sedamar, ega mor yomar, degine, argan-yoed ega argangi yobar, degine sapat ega yomarbalo. ");
INSERT INTO cuk09_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Moli-bebe-nikad-e-mimmi-wardummad sedamar, oburgwemar, a anmar gunnoed, anmar iba-onomarsun. ");
INSERT INTO cuk09_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ar wede an-machi burgwisanad, emigindi gannar durgunonikid; yoggusanad, emigindi amilenonikid.’ Bela-dulemar weligwar-ito nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ar e-machi-dummaddi deun sapurba gudiid. Nonigua, neg-walik-gusgu, garmar-gole itoalid, degine, dodonanai dakarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Machi-dummad ega-arbaed-wargwense gochagu, ese egichialid: ‘¿Wede igid barsunna?’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ega-arbaed sogded: ‘Be-urba gannar nonikid. Be-bab moli-bebe-nikad-e-mimmi-wardummad oburgwisad, ar be-urba nued, uelesuli nonikidba.’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Geb degi machigwa sae-itoded, yapa neg-yaba doge-gualid. Degisoggu, e-bab magaba noarsunnad, egi wilenagusad, neg-yaba dogye. ");
INSERT INTO cuk09_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ar machigwadi e-bab-abin-imakdegu, sogded: ‘Emi birga-dikasurgus an bega arbadiid, uaya-suli an bega gudisulid, gwen be anga sibad-bipisaar be ukdisulid, an-aimar-abargi weligwar an gunnegar. ");
INSERT INTO cuk09_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ar we-be-machi nonigudi, bei ibmar bela obelosad, omegan-gamba-nuchumarba, emide agardi moli-bebe-nikad-e-mimmi-wardummad be oburgwisad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Bab, machi-abin sogded: ‘Machi, be anba gudiguad, bela-an-ibmar begadid. ");
INSERT INTO cuk09_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ar emigindi anmar iba-onoged nonikid, werguega, ar we-be-urba burgwisayob gusad, emigindi gannar durgusayob gunonikid, yoggusanad, emigindi gannar amilesad. Degisoggu, anmar werguer-gebed.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús e-sapinganga sogdebalid: “Dule-wargwen mani-ibed, ega na e-ibmar-akwed nika-gusad. Ibagwengine, mani-ibedga soglealid: ‘Dule-bega-ibmar-akwed be-ibmargi, degi, be-manigi dododiiye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Geb degi mani-ibed ega-ibmar-akwedse gochasun, ega sogded: ‘¿Wede igi be gudisunna, an-manigi dododii an be-itodo? Anga-be-ibmar-dakdiid bela anga be nue sogdasun, ar bar be anga ibmar-dakega guosulid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Geb degi dule-ibmar-akwediid na dukin sokalid: ‘¿Wede ibi an bar saosunna? Ar an-dummadde an-ega-ibmar-dakdiid angi suesokalid. Sapurgi an arbaye soger geg an gued, wileganayob mani an egisye soger an bingebalid. ");
INSERT INTO cuk09_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","An wisi igi an saoe, adi angi arbaed sulesale, dulemar e-neggi an-abingamalagar.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Degine, dule-ibmar-akwed dulemar-e-dummadgi-mani-ganimaladse gochagu, gebesailadga sogded: ‘¿Igi-mani an-dummadgi be ganiki?’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Abin-sogded: ‘Ibmar-gwallu bari-dulatar.’ Geb degi dule-ibmar-akwed ega sogdemogad: ‘Gardagi narmakaled, be mani ganiye, a be sue. Be sige, be a-gardagi narmake: dulabo-gakambe an ganiye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Geb a-sorba baidga sogdebalid: ‘Bedina, ¿igi-mani be ganimoga?’ Mani-ganikid, abin-sogded: ‘Madubur-gwagwaled wilubsaleged-dulatar.’ Geb degi dule-ibmar-akwed ega sogded: ‘Gardagi narmakaled, be mani ganiye, a be sue. Dulabake an ganiye be narmake.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Geb degi mani-ibed ega-ibmar-daked-nug odummod, ar ade we-ibmar-daked-iskana, nue-binsaed-nikaa ibmar imaksad. Ar ade dulemar-Bab-Dummad-aku-dakmalad nue-binsaed-nikaa bur dulemar-gwallu-meegwadgi-nanadimaladba baigan-ebo igar imaked.” ");
INSERT INTO cuk09_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesús sogded: “Andi an bega sogsun: Ai-nuegan nikued be sae, be we-napneggi mani-nikadgi, adi we-mani bega bergudele, yoedse neg-geg-berguedgi be abingamalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ar ibmar-ichegwadgi be galakussulile, amba ibmar-ichesur bega uklesale, be galakuosurbardo. Ar ibmar-ichegwadgi be galakusale, amba ibmar-ichesulidgi be galakubalodo. ");
INSERT INTO cuk09_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ar we-napneggi ibmar-nika-guedse be galakusale, ¿ar doa begi bensuli bar guosunna we-ibmar-napiragwad nikuedgi? Bab Dummad begi bengumogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ar ibmar-dulemar-baidgad be nued akwissulile, ¿ar doa ibmar bega ukosunna begadga guegar? Bab Dummad bega ukosuli. ");
INSERT INTO cuk09_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Mai-wargwensaar dummad-warbo geg nikued, ar ade wargwen-sabguoed, baiddi istar dakoed. Wargwenga nue-alamaknai guoed, baiddi mesagwar dakoed. Geg be Bab-Dummad-maiga gued, degi, maniga-mailenai gubalid, unnila wargwen bur-bule be sabguoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","We-ibmar bela Jesús sogsad, Fariseomar itobukwa-gusmarmogad, ar ade amar unnila mani-nikuedginbi binsadii-damalad. Amar Jesúsgi dodobukwa-gusmalad, binsa be gordiiye. ");
INSERT INTO cuk09_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Geb degi Jesús amarga sogdesun: —Ar bemardi dulemar-asabin na dukin na san ogannodimalad. Ar Bab Dummaddi bemar-gwage wisid. Ar dulemarga ibmar-nuediddi, Bab-Dummad-asabindi, ibmar-iskanad. ");
INSERT INTO cuk09_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús sogdebar: “Moisés-igar-mesisad, degi, Bab-Dummad-gaya-burba-berbemalad-sunmaksamalad Juan-Bautista-nonikidse egi sunmakledii-gusad. Juan-Bautista-nonikid-akala Bab-Dummad-neg-dakmaid-gaya-burba-nuedgi bemarga egi sunmaklenaid, degine, dulemar-bela-ase-dogbimalad dogbigunanaid. ");
INSERT INTO cuk09_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Ar bur-baisursunna we-napneg, degi, nibneg-naid, sunna surguoed, Moisés-igar-narmakar-naid e-bichugwad-bur-bipigwad gwen bipisaale adi wis ogwalegosurguoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús sogdebar: “Ar dule-wargwen ome-metele, ome-baid-nikusale, we-machered ome-dikarba neg-sichigi yolediido. Ar doa-dule, ome-melleded-nikusale, we-dule, ome-dikarba neg-sichigi yoledimodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús sunmakdegu, sogded: “Dule-wargwen mani-ibed mai-gusdo. A-dule mor-gwalugiid, degi, mola-sibu-nuedbi yoo-daed, degine, bane-bane bur mas-nueganbi gundii-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Agi dule-wileged-wargwen, mani-egisdii-daed gudigusmogad, Lázaroye-nugad. A-dulede, mani-ibed-yawagakgi yaa-sunnabi mellemai-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","We-dule-wileged mani-ibed-mas-gunned mesa-urba mas-durgan-batemaid, agi ibmelegoeyob binsadii-daed. Ar achumarse-bakale e-yaa emanoni-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ibagwengine, dule-wileged burgwisgu, angermar Abraham-maidse sesad. Dule-mani-ibed burgwismogu, neg-uanse digleapid. ");
INSERT INTO cuk09_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Dule-mani-ibed odurdakleged-neggi nue-wilesii atakargu, Abraham dikasur-sii dakardo, Lázaro a-walik simoga. ");
INSERT INTO cuk09_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Agi dule-mani-ibed binnasur gotegu, sogded: ‘Dad-Abraham, wis wile be an-dake, Lázaro anga be barmidage, adi e-goo-dukugi dii wis eogogu, an-gwabin-dukugi nasikega, ar andi wegi nue soo-sailagi an wilesiid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ar Abrahamdi abin-imakde, ega sogded: ‘Machi, be insae, be dula gudigusgu, ibmar-nuegan be nikusad, ar Lázarodi wiledii-gusad. Ar emigindi Lázaro wegi wergusisunnad, bedi wegi wilesisundo. ");
INSERT INTO cuk09_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Aginbali, neg-gullu-dummad anmar-abargi naid. Degisoggu, dulemar-obakbied bese geg obaked, degine, bemar anmarse geg obakmogad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Geb degi dule-mani-ibed Abrahamga sogdesun: ‘Degirdina, dad-Abraham, an bese ise-wilegar egisdo; an-bab-negse Lázaro be barmide. ");
INSERT INTO cuk09_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ar ade urbamar-walatar an nikad, adi amar-owisogegar, mer adi we-odurdakleged-negse dagegar.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ega sogded: ‘Moisés-igar-mesisad, degi, Bab-Dummad-gaya-burba-berbemalad-sogsamalad narmakar nikmalad, ar a-sogedba damalar-gebed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Geb dule-mani-ibed abin-sogded: ‘Dad-Abraham, degisuli. Ar dule-wargwen burgwisad gannar-durgus an-urbamarse naele, geb agi amar na e-iskuedga bukib binsasmalaled, e-daed gwagsamalaled.’ ");
INSERT INTO cuk09_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ar Abrahamdi ega sogded: ‘Ar Moisés, degi, Bab-Dummad-gaya-burba-berbemalad narmakar-maidba dasurmalale, amba itogosurmarbalid, dule-burgwisad gannar-durgus ega sunmaknaer.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús na e-sapinganga sogded: “Gwage-ichoged-igargandi danikosurdeeye gwen soglesulid. Ar dule gwage-ichogedga gueddi, adi nue wilegoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ar a-dule akwamu-dummad e-dukargi-nai demar-wilase metemalar, we-dule nue-dummad wilegoed, ar burgoed. Aba bur-bule, dule nue-dummad-wilegoed, dule-wargwen, we-mimmi-burwiganayobid, iskuega imaksar. Degisoggu, dule-ichoged-iduar, we-dulega bur-nuedirdo, akwamu-dummad dukargi-nai burgwed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Degisoggu, na be nue salakarmar. “Ar be-gwenad begi nosale, ega be soge, nue be angi nos-itoleye. Ar be-gwenad nabir be-itosale, ar na gwagegi bukib binsasale, e-daed gwagsale, begi-nossuliyob be dakoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ar be-gwenad ibagwen ilagugle begi nosale, degi, ilagugle bese gannar-gannar nonikile, bega sognonikile: ‘An-iskusadga an bukib binsaye, bar an deyob guosurye,’ begi nosasuliyob be dakoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Geb degi Jesús-nuggi-barmilesmalad, Jesúsga sogdemar: —Dummad, gatik begi bensuli be anmar-imake. ");
INSERT INTO cuk09_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Geb degi Dummad-Jesús sogded: “Bemar wismalad igi mostaza-e-gwag bur-bipigwa, ayob-dungu bemar angi bensulir, sunna we-Sicómoro-sapiga be sogsamalaled: ‘Wegi be gwichid be unge, demarse be diglenae.’ We-sapi bemar-sogedba imaksaled.” ");
INSERT INTO cuk09_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús sogdebar: “Ar bemar be-mai-wargwen be nika-dibe, bega napa imuega, igi, moli akwegar-dibe, sapurba-arbadii danikid-sorba, ¿ega be sogdimala?: ‘Be doge, mas-gunnega mesase be sigdage.’ ");
INSERT INTO cuk09_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Ar ega bur be sogmarsursi?: ‘Guakwaa be gudi-sae, mas-gunned anga due, anga be mas dake, an mas guchar, degi, an gobsabalir, geb a-sorba be mas gunmogoed, geb be gobmogoed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Ar degine, ¿dog-nuedye be-maiga be sogdasi, ar ibmar bega be-sogsadba imaksadba? An insagua, sur an insado. ");
INSERT INTO cuk09_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ar amba bemar deyobmodo, ar bela bemarga Bab-Dummad-ibmar-sogsadba be imaksamalale, be sogmalodo: ‘Anmar mai-nued arbasurmaladye, ar ibmar-imakoye anmarga-soglesadbi an imaksamaladdeye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús Jerusalénse nadapgu, Samaria, degi, Galilea, a-abargi nadap-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesús neggwebur-bipise dognadapgu, machergan-warambe naibe-buna-ya-maleged-nikmalad egi noarmalad, dikasur egi ambikunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Amar binnasur gote, sogdemalad: —¡Jesús, odurdaked-saila, wile be anmar-dake! ");
INSERT INTO cuk09_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús amar-dakdegu, amarga sogded: —Be namar, dule-irwa-Bab-Dummadse-gormaladga na be-san oyonamar, adi amar bemarga sogmalagar bemar nugusmarye. Ar degi, dule-warambegwad amba igarba dule-irwa-Bab-Dummadse-gormaladse nadapmargu, nugudmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","E-ambe-gued-wargwen, na nugus itoargu, gannar Jesússe nonikid, binnasur Bab-Dummad-nug ogannodani. ");
INSERT INTO cuk09_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Dule-nugusad yokorgi sindigar e-wagar-napagi-ise-megar Jesús-mali-naba signonikid, geb Jesúsga sogdebalid: —Dog-nued, be an-nudaksagu. We-dulede Samariaginedid. ");
INSERT INTO cuk09_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús sogded: —¿Ar warambe nugusmarsursi? Emide, ¿bia walabakebakad nade? ");
INSERT INTO cuk09_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Na nugusmalad-ular, ar gwen bilissurmala, Bab-Dummad-nug-ogannomalagar, unnila we-dule-ainebalidbi, Judiosulid, abi Bab-Dummad-nug odummononide? ");
INSERT INTO cuk09_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A-dulega Jesús sogdesun: —Be gwisgu, be nae. Be nue an-bensulidba be nugussun. ");
INSERT INTO cuk09_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseomar Jesússe egichialid: —¿Sana Bab-Dummad-neg-dakmaid danikoe? Jesús, abin-imakdegu, sogded: —Bab-Dummad-neg-dakmaid bemarse danikile, bemar owisoar gwen nonikosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Degine, sogmarbalosulid: ‘Be dakena, wegi gudii,’ igi: ‘Weba gudii.’ Ar ade Bab-Dummad-neg-dakmaid bemar-abargi gudiid. ");
INSERT INTO cuk09_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesús na e-sapinganga sogded: “Iba-nonikoed, ani Dule-Machi, an emi-gudiid-iba, a-ibagwen bemar dakbi-gudamaloenad, a-iba bemar gwen dakosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Degine, bemarga sogdamaloed: ‘Be dakena, wegi Cristo gudii.’ Baigan bemarga sogdamarbaloed: ‘Weba Cristo gudii.’ Mer be daknamalo, degine, mer eba be nagumarbalo. ");
INSERT INTO cuk09_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","“Ar igi mar-ibyed gadele, bela nibneg mee imakde-daed dakdamala, ani Dule-Machi, deyob bela an-dakmarmogoed an-danikoed-ibagi. ");
INSERT INTO cuk09_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ar gebe, ani Dule-Machi, bina nue wilegweler-gebed, wegi dula-gudidimaladse mesagwar gugweler-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ar igi Noé-maigu gusa, deyob, ani Dule-Machi, gannar-danikoed-ibagangi gumogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","“Noé maigu, mas gunnanai-gusmalad, gobnanai, ome-nikunanai, na ga ome-uknanai. Geb Noé ur-dummad-na-sobsad-yaba dogsagu, dii muluded, geb degi bela dulemar burgwisad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Amba deyob Lot-maigu gusbalid, mas gunnanai, gobnanai, ibmar-baknanai, ibmar-uknanai, ibmar-dignanai, neg-sobnanai-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","“Ar Lot, Sodoma-neggweburgi noded-ibagi geb nibneggi soo, degine, azufre batisad. Geb degi bela dulemar burgwisad. ");
INSERT INTO cuk09_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Deyob Dule-Machi-danikoed-ibagi gumogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ar a-ibagi, dule-wargwen neg-uas-birgi siile, aidealir, e-ibmar-nuegan neg-yaba-bukwadbina mer doged saoed, bur yog wakinnar imakoed. Ar dule-wargwen sapurba gudiile, amba mer negse gannar dagmogoed, bur yog wakinnar imakoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Be insamalo, Lot-ome sorba-ataksadba igi burgwisa. ");
INSERT INTO cuk09_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Ar dule-wargwen anba-naid-ular burgwebisulir, e-san-burba ei yogguodo. Ar anba-naid-ular burgwenonikirdi, adi na e-san-burba yogguosurdo.” ");
INSERT INTO cuk09_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jesús sogdebar: “An bemarga sogmalad, a-mutikid-ibagi na-ebo-dikarba gabmamaid, wargwen nibnegse seledoed, baiddi obelegoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Omegan-warbo na ibmar-gwag-nagnanaid, wargwen nibnegse seledoed, baiddi obelegoed. ");
INSERT INTO cuk09_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Warbo sapurba na gudimalad, wargwen nibnegse seledoed, baiddi obelegoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","E-sapingan Jesúsga sogdemar: —¿Dummad, bia deyob guoe? Jesús, abin-sogde: —Ar bia san-burgwaled mai, agi mulamar danar-ambikunoni-damalad. Debayobi dulemar mag dakmogoed, an gannar we-napnegse danikir. ");
INSERT INTO cuk09_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Degi Jesús na e-sapingan-odurdakega burbar sunmakdegu, amarga sogded: “Bab-Dummadse-goled nue abeleged, mer galakued imakmalo.” ");
INSERT INTO cuk09_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jesús burbar sogdesun: “Ibagwengi, neggweburgi dule-igar-naboged mai-gusad. A-dulede Bab-Dummad-gwen-dobsulid, degi, dulemargi gwen binsaed-nikaa dasurbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","“A-neggweburgi mukwa-wargwen ei-sui-burgwisad gudigusmogad. A-mukwade dule-igar-nabogedgi gannar-gannar alamaknaidgi ega sognoni-daed: ‘Dule-istar-an-dakdiid-ebo anga igar-nabiroye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Dule-igar-naboged gebe-guargua yapa mukwaga igar-nabo-gusad. “A-undaradgine na ulubgi sokalid: ‘Bab Dummad an dobsur-inigwele, degine, dulemargi-gwen-binsaed-nikaa an dasurbar-inigwele, ");
INSERT INTO cuk09_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ar we-mukwa angi alamaknaigusoggu, ega igar an nabogoye, ar degiile, abakalegi anse-nanagwisguadba budar an dakalirye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Geb degi Dummad-Jesús sogdebar: “Nue bemar itomalana, dule-igar-naboged, iskana-daedi, igi sogsa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Ar bemar insagu, Bab Dummad na e-dulemar-susadga igar-napiragwad imakosur be insae, ese mutikidba, degine, ibginedba gordimaladga? Imakoe. ¿Bab Dummad undaradgi geb ese-gormalad abinsao be insae? Suli. ");
INSERT INTO cuk09_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","An bega sogmar, Bab Dummad abga e-sordamarga igar-napiragwad imakoed. “Ar ani Dule-Machi, we-napnegse gannar danikir, bemar insagu, ¿dulemar Bab-Dummad-bensurmalad-nika we-napneggi daknoniko be insae?” ");
INSERT INTO cuk09_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ar dulemar, na dukin nuedye, baigandi iskanaye, sogdimaladga, Jesús we-igar-burbar-maidgi-sunmaklegedgi sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ibagwengi, machergan-warbo nadmalad Bab-Dummadse-goled-negse: Gwensak Fariseo, baiddina Roma-dummadga-mani-gaedgi-arbaed-dule. ");
INSERT INTO cuk09_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Fariseo gwichi Bab Dummadse gorgwichid, na dukin weyob soggwichid: ‘Bab Dummad, dog-nuedye an bega soged, ar an dulemar-baidgii dasulid, an atursilisulid, igar-inikigwadbi aimarga an imaked, an ome-dikarba-yoledisulid, degine, we-dule-Roma-dummadga-mani-gaedgi-arbaed-daedyob an dasulid. ");
INSERT INTO cuk09_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bab-Dummadse-golega itoged-irgwengi, ilabo an mas-gunsuli gudidaed, bela an mani-onoged-irba ambegi-gwensak an ukdaed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ar dule-Roma-dummadga-mani-gaedgi-arbaeddi Bab Dummadse gorgwisgu, bannaba gwichi, nonose-bakar gwen onakbisur gwichid, na e-binasgar sarsogwis soggwisdo: ‘Bab Dummad wile be an-dake, an dule-iskudiid-duled.’ ");
INSERT INTO cuk09_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Ani Jesús, an bega sogmar, ar we-dule bur gwage nugus-naddo, Fariseoba. Ar ade dule-wargwen na nug dummarba na saele, a-dule bur nug-bipii guoed. Ar dule na nug bipii na saerdi, adi a-dule bur nug odummolegoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Degine, Jesússe mimmigan-sedani-gusmalad, Jesús ega ebugegar, adi Bab Dummad nued mimmigangi binsaegar. Jesús-sapingan deyob dakarmargu, dulemar-mimmigan-senonimaladse uluarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ar Jesús na e-sapinganse gochagu, ega sogded: —Mer ese urwemar. Mimmigan anse daged be imakmar, mer be bargamar, ar Bab-Dummad-neg-dakmaid we-mimmiganyob damaladgadid. ");
INSERT INTO cuk09_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Napira an bemarga sogmalad, ar dule-wargwen Bab-Dummad-neg-dakmaid mimmiganyob abingasulile, geg Bab-Dummad-neg-dakmaidse doged. ");
INSERT INTO cuk09_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Dule-wargwen nue-nug-nikagwad Jesússe egisnonikid: —Odurdaked-saila-nued, ¿ibi an imaker-gebe, burba-geg-bergued an abingaegar? ");
INSERT INTO cuk09_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús, abin-sogded: —¿Ibiga dule-nuedye be anga soge? Dule-nued sulid, unnila Bab Dummadbi wargwennaa dule-nued gued. ");
INSERT INTO cuk09_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ar Bab-Dummad-igar-mesisad be wisid: Mer sui-dikarba, degi, ome-dikarba yolemalo, mer dule-oburgwemalo, mer atursamalo, mer gakansaar aimargi sunmakmalo, be-babgi, degi, be-nangi, nue-binsaed-nikaa damalo. ");
INSERT INTO cuk09_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Dule, abin-sogded: —Gusgu an sapingwagwad-akar bela we-igarmar-mamaidba an nanadiid. ");
INSERT INTO cuk09_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesús, weyob dule-ega-soge itosgu, ega sogded: —Ibmar-gwensak amba be napi. Bela ibmar-be-nikad manigi be uknae, geb agi mani wileganaga be mimmioed. Geb degiir be nibneggi ibmar-nued be nikuoed. Geb a-sorba anba be dagoed, an-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Dule, weyob Jesús-ega-soge itosgu, nue-bukib-binsaded, ar ade dule nue-mani-ibedid. ");
INSERT INTO cuk09_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús, dule-nue-bukib-binsa-ito daksagu, sogded: —¡Ibiyobi dulemar-mani-ibganga Bab-Dummad-neg-dakmaidse-doged-igar dutusuli, ar ade dogdar maniginbi binsamalad! ");
INSERT INTO cuk09_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ar ade moli-yargan-mureged bur-baisursunna iko-ibyagi doged, ar dule-mani-ibeddi bur-beedse Bab-Dummad-neg-dakmaidse doged. ");
INSERT INTO cuk09_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ar dulemar weyob Jesús-ibmar-soge-itosmalad, sogdemar: —¿Ar doa degite sunna abonolegosunna? Deyob sogsamardo, ar ade binsamalad, mani-ibgan baisursunnaa bur abonolegoye. ");
INSERT INTO cuk09_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús, dulemar-abin sogded: —Ar dulemargardi ibmar-geg-guedi, Bab Dummadgardi bela ibmar sunna guedbiid. ");
INSERT INTO cuk09_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Geb degi Pedro, Jesúsga sogded: —¿Anmardina? Emide wegi anmar na-ibmar-nikamalad bela an na obesmalad, adi anmar beba naegar. ");
INSERT INTO cuk09_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Geb degi Jesús, abin-sogded: —Napira an bemarga soged, ar dule-wargwensaar Bab-Dummad-neg-dakmaid-ular na e-neg, e-babgan, e-gwenadgan, e-ome, e-mimmigan, obesale, ");
INSERT INTO cuk09_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","bur-bule, we-napneggi ibmar-abingaosurdeeye soglesulid, degine, burba-geg-bergued yoedse amba-deyob abingabaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús na e-sapingan-warambe-gakabogwad bachikii sesgua, ega sogded: “Anmar Jerusalénse nadapid, Bab-Dummad-gaya-burba-berbemalad bela angi Dule-Machigi narmaksadba igargan anga guedsegad. ");
INSERT INTO cuk09_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","“Ani Dule-Machi, Judiosurmaladse uklegoed, amar angi dodomaloed, istar angi sunmakmaloed, degi, angi wiakmarbaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ar sabsur an-bibyosmalad-sorba, an-oburgwemaloed. Geb ibapaagwadgi gannar an durguoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ar Jesús-e-sapingan-ambe-gakabogwad aku itosmalad, ar ade amba egi odukuar we-gaya-burba maid, degisoggu, aku-ito gusmarsundo. ");
INSERT INTO cuk09_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ibagwengine, Jesús Jericó-neggweburse warmaknadapgua, deunni dule-ibya-sulidi, igar-naba sii, mani egissii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Dule-aku-ataked dulemar-bukidar duurmaknadap itoargu, amarse egichided: —¿Igi neg-gunai? ");
INSERT INTO cuk09_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ega sogdemalad: —Jesús-Nazaretgined nadapye. ");
INSERT INTO cuk09_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Geb degi dule-aku-ataked binnasur gote, sogded: —¡Jesús, Rey-David-wagwa, wile be an-dake! ");
INSERT INTO cuk09_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Dulemar-Jesús-iduar-nadapmalad dule-aku-atakedse uludmalad, adi mer binnasur golegar. Ar dule-aku-ataked aka-bur-bule binnasur gorsigisad: —¡Rey-David-wagwa, wile be an-dake! ");
INSERT INTO cuk09_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Geb degi Jesús gwisgusgua, dule-aku-ataked ese sedaged imaksad. Dule-aku-ataked ese nonigu, Jesús ese egichialid, ");
INSERT INTO cuk09_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ega sogded: —¿Ibu bega imakbi be an-abege? Dule-aku-ataked, Jesús-abin-sogded: —Dummad, mag-atak be an-imake. ");
INSERT INTO cuk09_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús ega sogded: —Be-ibya nugusun. Be an-bengussursoggu, be nugussun. ");
INSERT INTO cuk09_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Geb degi dule sunna mag-atak gussunnad. Dule-nugusad Jesúsba nadapgu, Bab-Dummad-nug ogannonadap-gusad. Bela-dulemar dule-nugusad-daksamargu, Bab-Dummad-nug ogannodmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericó-neggweburse Jesús modapgu, a-neggweburgi nadap-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Agi dakleargu, machered-wargwen, Zaqueo-nugad, Jericógi mai-gusad. Zaqueo dakleargu, dulemar-Roma-dummadga-mani-gaedgi-arbamalad-e-dummadid, degine, dule-mani-ibedbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A-dulede Jesús-dakbigualid, wede Jesús doasunye. Ar Jesúsba-dulemar-nadapmalad bukidarsoggu, Zaqueo geg Jesús-dake-gualid, ar ade Zaqueo dule-matukwagwad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Zaqueo aimar-idu abarmakde-gusad, sapi-sicómorogi nakwegar, ar ade Jesús a-igargi nasoed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús a-sapi-gwichid mosgu, niba atakdegu, Zaqueo-dakde, ega sogded: —Zaqueo, gwae be dage, aidedage, ar ade emi-ibagi an be-neggi obunnoger-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Geb degi Zaqueo gwae-gwae aidealid, weligwar na e-neggi Jesús-abingasad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Dulemar daksamargu Jesús Zaqueo-negse dogsa, bela sunmakedbi-guarmalad, sogdemalad: “Dule-iskudiid-negse Jesús dogsaye.” ");
INSERT INTO cuk09_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Geb degi Zaqueo gwisgusgu, Jesúsga sogded: —Dummad, emide wegi an-ibmar an-na-nikadi, negabar dule-wileganaga an ukoed. Ar dule-gwensak-dibe an ibmar-atursasale, an ega ilabake bur-melu an ega ukoed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús, abin-sogded: —Emi-iba we-neg-yaginmaladga iskuedgi-dule-abonoleged nonisun, ar ade we-dule, Abraham-e-wagwamogad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ar ade, ani Dule-Machi, dulemar-yoggusmalad amiega, degi, dulemar-iskuedgi-abonogega an nonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ar Jesús Jerusalén-neggwebur-walik gudisoggu, dulemar Bab-Dummad-neg-dakmaid bato emarse oyolesokarye bimalanad. A-ular Jesús dulemar-e-itosimaladga ");
INSERT INTO cuk09_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","burbar sunmakedgi sogded: “Dule-wargwen, nue-nug-nikadi, yar-baidse dikasur nade-gusad, reyga nugsalegegar. A-dulede, gannar-danibaloye sogsa naded. ");
INSERT INTO cuk09_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“A-dulede nasokargu, ega-arbamalad-warambegwadse gochad. Amarga mani-ichesur uksagu, ega sogded: ‘Wegi be anga mani-onomalo an gannar dagedse.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ar na e-neggweburginmalad dule-reyga-guoed istar dakmarsoggu, naded-sorba dulemar-barmisad, dummaganga sogegar: ‘We-dule anmar-reyga gubi anmar abesurye.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Degine, reyga-gusad-sorba gannar nonigu, e-maiganga-mani-uksadse gochad, adi amarse egisega igi mani imaksamala. ");
INSERT INTO cuk09_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Mai-gebesailad nonigu, reyga sognonikid: ‘Dummad, be-anga-mani-uksadgi ambe an onosbalid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Dummad ega sogdesun: ‘Nued, be, mai-nued. Ar ibmar-ichegwadgi be nued arbassoggu, neggwebur-gwaambedgi be dummadga guo.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Baid-mai reyse nonimogu, ega sognonikid: ‘Dummad, be-mani an bega gwaatar onosbalid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Dummad we-maiga amba deyob sogdebalid: ‘Neggwebur-ataledgi be dummadga gumogo.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Baid-mai nonibargu, reyga sognonikid: ‘Dummad, wegi an bega be-mani sedani, muswegi an bega nue-sabosad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ar an be-dobgusad, ar bede dule-yaisur-daed-duled, ar be ibmar-urbissulid be sudaed, ibmar-be-digsasulid be wedaed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Geb degi rey a-maiga sogdesun: ‘Be mai-iskana, ar na be-dukin-ibmar-sogsadba an bega sogsun. Ar be wisinad an dule-yaisur-daed-duled, an ibmar-urbissulid an sudaed, an ibmar-digsasulid an wedaed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Ar ibiga degite mani-urbileged-neggi be mani urbiapsuli, adi gannar an nonikogu, mani-nosad an sunonikoenad?’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ar rey dulemar-bukmaladga sogdesun: ‘We-dule-mani-ganikid e-annik be sumar, dule-mani-ambe-onosadga be ukmar.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Dulemar, rey-abin sogdemalad: ‘Dummad, ar a-dule mani-ambe bato nikad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Dummad, amar-abin sogded: ‘Ar dulemar-bela-ibmar-nikmalad aga bur napi uklegoed. Ar dule-ibmar-suliddi, amba ar ibu wis nika, ei bur sulegoed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Deginbali, istar-an-dakmalad, egi-dummadga-gubisur an-abesmalad, anse sedamar, an-asabin amar-e-dukar egwanmaloed.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús weyob ibmar sogsagu, e-sapingan idumai, Jerusalénse nadap-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Emi dakleargu, Jesús, Betfagé-neggweburse, degine, Betania-neggweburse warmakdanimargu, Olivosye-yar-nugad-siid inikgusgu, Jesús na e-sapingan-warbo-barmisad, ");
INSERT INTO cuk09_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","amarga sogsad: —Neggwebur-bipii anmar-asabin-siidse be namar. A-neggweburgi bemar dogdapmalar, moli-bipi-uaya-suid, dule-egi-yo-gwen-siged, be-idu atinnar-nai bemar dakdapoed. Be esikmalo, geb degi be anse sedamaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ar dule-wargwen bemarse egichialile: ‘¿Ibiga bemar moli-bipi-uaya-suid esiknanai?’, ega bemar weyob sogmaloed: ‘Ar Dummad we-moli-binasoged.’ ");
INSERT INTO cuk09_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesús na e-sapingan-warbo-barmisad nadmargu, dakdapmalad, ar igi ega soglesmaladba. ");
INSERT INTO cuk09_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jesús-sapingan moli-bipi-uaya-suid esiknanaigu, e-ibedmar ega sokarmalad: —¿Ibiga moli-bipi-uaya-suid bemar esiknanai? ");
INSERT INTO cuk09_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Abin sogdemalad: —Ar Dummad moli-bipi-uaya-suid-binasoged. ");
INSERT INTO cuk09_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesús-sapingan moli-bipi-uaya-suid Jesússe senonimarsunnad. Geb degi moli-bipi-birgi na e-mormar ogichamargu, Jesús-onakwismarsun, moli-bipi-birgi. ");
INSERT INTO cuk09_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús, Jerusalénse nadapgu, e-iduar igargi dulemar mor ogitemalad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos-yar-aideged-walik gusgu, bela bukidar dulemar-Jesúsba-nagusmalad, weligwar itodmalad, bela ibmar-dakledisulid emar daksadba, binnasur Bab-Dummad-nug ogannodmalad, ");
INSERT INTO cuk09_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","sogdemalad: ¡We, rey Bab-Dummad-nuggi danikid bela ega ib-nuedga guena-gadin! Nibneggi bogidikid gusun, degine, nibneggine Bab-Dummad-nug ogannomarsun. ");
INSERT INTO cuk09_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Degine, dulemar-bukidarad-abargi Fariseomar-war-wargwen Jesúsga sokarmalad: —Odurdaked-saila, beba-nanaimaladse be urwe, mer deyob sogmarye. ");
INSERT INTO cuk09_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús, abin-imakdegu, sogded: —An bega sogmar, ar wemar bogiledele, akwamar oimakarmalaled an-nug odummomalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesús Jerusalén-neggwebur-walik-mosgu, Jerusalén dakdegu, ega bode, ");
INSERT INTO cuk09_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","sogded: “¡Ar emi-ibadse geb-be-wisina, igi be imaker-gebe bogidik ambikuegar, bemar bogidik ambikusmalaled! Ar emigindi, we begi odukuar nagusad, adi mer mag be itomalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Ar ibagan begi danikoed, be-istarmalad be-ebilis napa gwisnonikoed, be-ebilis ambikunonikogu, geb degi bela begi gwichigudamaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Degi geb napagi be-omukumaloed, be-dulemar-oburgwemaloed, degine, akwamar be-birgi bubukwad bar be-birgi ambikuosurmalad. Ar deyob be guoed, bese atakleapid-iba aku be daksad-ular.” ");
INSERT INTO cuk09_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús Bab-Dummadse-goled-negse dogdapgu, dulemar-agi-ibmar-baknanaid, degi, ibmar-ukbukmalad sabsur onisad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús amarga sogded: —Bab-Dummad-Gardagi narmakar naid: Bab Dummad soged, An-nega anse-goled-negye. Is. 56:7 Ar emigindi, bemardi atursamalad-negga imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesús bane-bane Bab-Dummadse-goled-neggi Bab-Dummad-igargi dulemar-odurdakdii-gusad. Ar dule-irwa-Bab-Dummadse-gormalad-e-dummagandi, escribamardi, degi, dule-dummagan-neggweburgi-neg-semamaiddi Jesús-oburgwebi-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ar amar geg Jesús-oakalo-gusmardo, ar ade bela dulemar Jesús-nue-itobukwa-damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ibagwengine, Jesús Bab-Dummadse-goled-neggi dulemar-odurdaksigu, degine, Bab-Dummad-gaya-burba-nuedgi sunmaksigu, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, escribamar, degine, Judiomar-girmar-dummagan Jesússe nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Amar Jesúsga sognonimalad: —Be anmarga soge: ¿Doa-nuggine wede be we-ibmar imakdii? ¿Ar doa bega gangued uksasunna, we deyob be ibmar imakegar? ");
INSERT INTO cuk09_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús, abin-sogded: —An bemarse ibmar-soggwen egismogodo. Bemar anga sogmalana: ");
INSERT INTO cuk09_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Doa Juan-Bautista-barmiar be insae, Bab-Dummad-digi-ogleged-igar imakega? ¿Bab Dummad barmiali, igi, dulemar barmiali? Anga be sogmalana. ");
INSERT INTO cuk09_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Degi, Judio-dummagan muchub-muchub na sogdemalad: “Bab Dummad barmiarye anmar sogmalale, anmarga sogdagoed: ‘Degite, ¿ibiga bemar Juan-Bautista-bengusmarsunna?’ ");
INSERT INTO cuk09_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Dulemar barmiarye anmar sogbalile, dulemar bela akwagi anmar-makmaloed. Ar ade bela nue sogmalad, ‘Juan-Bautista, Bab-Dummad-gaya-burba-berbeged-sunnadye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Degisoggu, Judio-dummagan, Jesús-abin sogdemarsun: —Anmar wichurmalad doa Juan-Bautista-barmiali. ");
INSERT INTO cuk09_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Degi Jesús, abin-imakdemosun: —An bemarga sogosurmarmodo, wede doa-nuggi we-ibmar an imakdii. ");
INSERT INTO cuk09_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Geb degi Jesús dulemarga burbar-sunmaklegedgi sunmakdesun, sogded: “Ibagwengi, dule-wargwen nainugi uva digsado. Nainu-ibed dulemar-arbamaladga na e-nainu urmaksado, adi a-dulemar nainugi uva wealir, e-ibedga wis ukmogoye, na deyob ebo igar-mesisbardo. Geb degi nainu-ibeddi undar na yoggunaded. ");
INSERT INTO cuk09_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Uva-weed-ibagan mosgu, nainu-ibed na e-mai nainugi-arbamaladse barmialid, adi uva-na-egadid suegar. Ar nainugi-arbamaladdi nainu-ibed-e-mai ese nonigu, sabsur sarsosmalad, geb degi unnila arganagwabi gannar barmismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Geb degi nainu-ibed e-mai-baid-barmiarbalid. Ar we-mai sabsur sarsosmarbalid, degi, egi dodosmarbalid. Geb degi unnila arganagwabi gannar barmismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Degi, nainu-ibed irbaagi gannar na e-mai-baid barmiarbalid. Ar dulemar-nainugi-arbamalad we-mai nue-naibi imaksamarbargu, nainu-dikarba metemalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Geb degi nainu-ibed sokarsunnad: ‘¿Emide, igi an saosunna? An-machi na nue-sabedi an barmidodo. Ar an-machi-dakdamalogu, adi egi-binsaed-nikaa-damaladba gwen oakalogosurmarsua.’ ");
INSERT INTO cuk09_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ar nainugi-arbamalad, nainu-ibed-machi dani dakarmargu, na ega sogdemalad: ‘We-dule-danikidi e-bab-burgwisar, nainu bela egadbi guoed. Degisoggu, anmar we-machi-oburgwemarsun, adi nainu anmargadga guegar.’ ");
INSERT INTO cuk09_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Machigwa-gasmargu, nainu-dikarba metemalad, geb degi oburgwismarsunnad.” Jesús dulemar-e-itobukmaladga sogded: “¿Degite, nainu-ibed, igi dulemar-nainugi-arbamalad-imaknoniko be insae? ");
INSERT INTO cuk09_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nonikogu, dulemar-nainugi-arbamalad-oburgwenonikoed. Geb degi dule-baiganga na e-nainu urmaknonikoed.” Ar weyob Jesús ibmar soge itosmargu, sogdemalad: —¡Bab Dummad, mer weyob ibmar-imaked anmar-imakena-gadin! ");
INSERT INTO cuk09_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ar Jesús, na ede akwa-nuedyobsoggu, nuu Judio-dummagan-dakdegu, amarga sogded: —Degite, Bab-Dummad-Gardagi narmakar naid: Dulemar-neg-sobmalad akwa istar daksamalad, a-akwa, akwa-sunsogedga bur gunonikid. Sal. 118:22 ¿Wede ibi obarsunna?: ");
INSERT INTO cuk09_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ar dule-wargwen we-akwa-nuedgi argwachale, we-dule bibiskoed. Ar we-akwa dulegi argwachardi, adi we-dule ese ubigwar guoed. ");
INSERT INTO cuk09_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degine, escribamar, Jesús-gabi-guarmalanad, ar ade mag-itosmalad Jesús we-ibmar-burbar-sogsadi yamo emarga sognaid. Degisoggu, Jesús-gabi-guarmalanad, degite, dummagan dulemar-dobedba-geg-Jesús-oakalogusmalad, ar ade Jesús-gasmalar, dulemar-bukmalad Jesús-bina uluarmalaled. ");
INSERT INTO cuk09_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Judio-dummagan arbakee dulemar-argaed Jesússe barmiarmalad. Amar yamo dule-nuedyob na imakarmalad, adi Jesús ibmar-noar-sunmakedgi gamalagar. Jesús ibmar noar sogsale, gamaloed, dummad-neg-dakmaidga ukmalagar, adi Jesúsga igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dulemar-argamalad Jesússe egichiarmalad, ega sogdemalad: —Odurdaked-saila, anmar be-wisdo, be inikigwadba ibmar soged, degi, inikigwadba be ibmar odurdakbalid, degine, begardi dulemar emarbi be daked, ar ade Bab-Dummad-igar-maid, napiragwadba be dulemar-odurdakdiid. ");
INSERT INTO cuk09_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Emide, ¿we igar-nuedi, Roma-dummad, César-nugad, anmargi-mani-gaed bennuked? ¿Anmar bennukoe, igi, anmar bennukosuli? ¿Igi be sogmosunna? ");
INSERT INTO cuk09_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ar Jesúsdi wemar-yamo-e-yardakdanikid mag daksoggu, amarga sogded: —¿Ar ibiga bemar yamo an-wilubdakdanimala? ");
INSERT INTO cuk09_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mani be anga oyogena. Jesússe mani oyosmargu, Jesús sogded: —¿Ar wede we-manigi doa-wagar-wilub sisunna, degine, doa-nug narmakar-naibarsunna? Jesús-abin sogdemalad: —Roma-Dummad-César, a-wagar-wilub, degine, a-nug narmakarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Geb degi, Jesús, abin-imakdemosunnad: —Ar ibmar Césargadir, Césarba be ibsamardo. Ar ibmar Bab Dummadgadirdi, Bab Dummadba be ibsamardo. ");
INSERT INTO cuk09_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ar we-dulemar Jesús-sunmakedgi dulemar-asabin geg Jesús-yardakgusmalad. Ar bur-bule geger dakdemalad igi Jesús e-abin imaksad. Degisoggu, gwen bar-akar ega sogsasurmardo. ");
INSERT INTO cuk09_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Geb degi Saduceomar Jesússe nonimarmogad. Amarde sogmalad, “Dule burgwisale, gannar geg bar durguye.” Agala Saduceomar Jesússe we-igar egichiarmalad, ");
INSERT INTO cuk09_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ega sogdemalad: “Odurdaked-saila, Moisés anmarga Bab-Dummad-Gardagi narmakar obesad: Ia mimmi-nikussuli ome-idu burgwisale, e-urba a-ome-nikuoye, adi e-iaga anagan-urbegar. ");
INSERT INTO cuk09_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Dakargu, machimala e-gwenadgan-walagugle-na-gumaladi weyob gusdo. Ia-dummad ome-nikusgu, anagan-urbissuli burgwisad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A-sorbalid a-ome-nikunonimogu, amba e-iayob mimmi-nikussuli burgwismogad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Geb degi a-sorbalid amba a-ome-nikunonimogad. Deyob bela e-walagugled a-ome-nikusmaladbiid, anagan-gwen-obessuli bela burgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Geb a-sorba ome burgwismosunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Ar dule-gannar-durguoed-iba nonikile, a-omede, ¿wede doa-omega guosunna, ar bela na e-gugle-nikusmaladbiid?” ");
INSERT INTO cuk09_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Geb degi Jesús, Saduceomar-abin imakdegu, sogded: “Dulemar we-napneggi, na ome nikumalad, degi, sui-na-nikunanai-damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ar dulemar-nabir-Bab-Dummad-negse-dogmaloeddi, degi, gannar-durgumaloeddi, amar gannar ome-nikunai, degi, sui-nikunai bar guosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ar ade we-dulemar gannar-durgunonikidba geg bar burgwemalad. Amar angermaryob gunonimaloed, Bab-mimmiganga gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Ar burgwismalad gannar durguoye sogleged, Moisés anmarga oyosmogad. Moisés deun sapi-bula-gummakmai-daksadgi narmaksagu, Bab Dummadgi sogsa-gusad, Abraham e-Bab-Dummadye, Isaac e-Bab-Dummadye, degine, Jacob e-Bab-Dummadye. Degisoggu, Moisés anmarga oyodo, dule-burgwismalad gannar durguoye. ");
INSERT INTO cuk09_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ar ade Bab Dummad, dulemar-burgwarmalad-e-Bab-Dummadsulid. Bab Dummad, dulemar-dula-gudidimalad-e-Bab-Dummadid. Ar Abraham, Isaac, degi, Jacob burgwismar-inigwele, Bab Dummadgardi amba dula gudidimalad, ar ade Bab Dummadgardi bela dulemar dula gudidimalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Escribamar-war-wargwen Jesúsga sogdemalad: —Odurdaked-saila, nue imas be sogsado. ");
INSERT INTO cuk09_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A-sorba bar gwen ibmar Jesússe egisbi ito nadsurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Geb degi Jesús Judio-dummaganga sogded: “¿Degite, ibiga sogmarsunna, we Cristo Rey-David-wagwaye? ");
INSERT INTO cuk09_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ar David-sunnad soged, Salmos-narmakar-naidgi: Bab Dummad an-Dummadga soged: ‘An-argan-nuedsik be sige, be dule-dummadga guegar, ");
INSERT INTO cuk09_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","bela be-istarmaladgi nakwedse an be-imakedsegad.’ ");
INSERT INTO cuk09_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ar David, Cristoga soged, be an-Dummadye. Degite, ¿Cristo igi e-wagwaga gubarsunnoe?” ");
INSERT INTO cuk09_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bela dulemar Jesús-itobukwadgi, Jesús na e-sapinganga sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Escribamargi nue salakarmar, mer amaryob bemar damalo. Ar amardi na yeer ito-damalad mor oyaarmakdiir, degine, dulemar bela ese ibmar-ukleged-neggi goledbimalale, amba yeer ito-damarbalid. Amardi Judiomar-onmaked-neggi dule-dummagan-gan-sigedginbi sigbi-damalad, degine, ibagi mas gullealir, dummagan-gan-sigedginbi sigbi-damarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","“We-escribamar yamo-yardakar ammamar-ei-sui-burgwismalad-ibe neg atursa-damalad, degine, dulemar yeer e-dakegala yamo suitii Bab-Dummadse-gorgwis-damalad. Ar we-escribamar bur-bule sabsur-odurdaklemaloed, deyob damaladba.” ");
INSERT INTO cuk09_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús Bab-Dummadse-goled-neggi sigua, dakded, mani-ibgan mani-urbed-ulu-yagi Bab-Dummadga-mani-urbenoni-damalad. ");
INSERT INTO cuk09_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Daksabalid, mukwa-wileged-wargwen, ei-sui-burgwisad, mani-esnon-gwabo egwachamogad. ");
INSERT INTO cuk09_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús sogded: —Napira an bemarga soged, we-mukwa-wileged, ei-sui-burgwisad, we bur-bule dulemar-baiganba mani uksad. ");
INSERT INTO cuk09_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ar baigan Bab-Dummadga-mani-uksaddi, gwabgusad uksamalad. We-mukwadi belagwapa na nika-gudiid, e-wilesagwadgine na bela uknonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bab-Dummadse-goled-neg-sobaledgi dulemar sunmakbukmalad, e-akwamar yeer-dakleye, degine, dulemar a-neg yeer-daklegega-ibmar-uksamalad yeer-daklebarye. Agi Jesús sogded: ");
INSERT INTO cuk09_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ar we-neg yeer daklegendo, degite we-ibmarmar bemar dakmaladi, ibagan nonikoed, bipisaale akwa-gwagwensaar birgi na askin-askin bar sigosulid, bela ayaroedbiid. ");
INSERT INTO cuk09_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesús-sapingan, Jesússe egichiarmalad: —Odurdaked-saila, ¿sana degite, Bab-Dummadse-goled-neg ayarosunna? ¿Degine, we-ibagan mosar, ibi-wilubgan oyoledagosunna? ");
INSERT INTO cuk09_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Geb degi Jesús sogded: “Nue salakarmar, mer dulemarse yardaklemalo. Ar bukidar yamo anyob imaknonimaloed, sognonimaloed: ‘Ani an Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule.’ Degine, sognonimarbaloed: ‘Neg nue dukumossun.’ Degi-inigwele, mer eba be nagumalo. ");
INSERT INTO cuk09_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Bila-onogedgibi naguar bemar itoarmar-dibe, degine, neg-urwedgibi nai bemar itoarmarbar-dibe, mer be dobgumalo. Ar we-ibmarmar-inse guer-gebed, degite, neg bato emiskwaa berguo-deeye soglesulid.” ");
INSERT INTO cuk09_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Geb degi Jesús amarga sogdebar: “Dulemar-yar-baid-baidgi-bukmalad na bila ononanai-gudamaloed, degi, reymar na muchub-muchub egi yolenanai na gudamarbaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Degine, negabandur-dummagan nagumai-gudagoed. Yar-baid-baidgi ukud-dummad, degi, uelemalad-bukidar-ainimai-gubaloed. Dobed-dummad nagumai, degine, nibneggi ibmarmar-wilubgan-dakledisulid-dummagan oyolemai-gudagoed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ar bela we-ibagan-bulegan-iduale, dulemar bemar-baregindamaloed, bemar-gamaloed, degine, Judiomar-onmaked-negse bemar-sedmaloed, eskaryagi bemar-metemaloed, degine, reymar-asabin, degi, dummagan-neg-dakmamaid-asabin bemar-sedmaloed. Bemar an-sapingansoggu, a-ular deyob bemar gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Ar we-ibmarmar deyob guoedi, adi bemar angi sunmakegalad. ");
INSERT INTO cuk09_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Degisoggu, bemar gwagegi mer be binsamalo, an na san bendakegala, ¿igi an sogo-dibeye? ");
INSERT INTO cuk09_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ar ani an bega binsaed-nued ukoed igi be sogoe, bela dulemar-begi-gwisgudimalad begi nakosurmalad, ar ade geg be-abinsae-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Ar be-babganse-bakar be-ukmaloed, be-iamar, be-urbamar, be-gwenadgan, be-aimar, amar, dummaganga be-ukmaloed, degine, bemar-gwen-gwen oburgwilemaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Be an-sapingansoggu, a-ular bela-dulemar istar be-dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ar degi-inigwele, be sailagia-wargwensaar bei gwen yogguosulid. ");
INSERT INTO cuk09_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ar bemar galakussulidba be abonolemaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ar bemar dakalir, sordamar Jerusalén-ebiris bukwa, be wismardo, we-Jerusalén-neggwebur-bibisked-ibagan warmaknonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Degisoggu, a-ibagi, Judeagi be gudiile, yalaganba be wakinsun. Bemar-Jerusalén-neggwebur-abargi-gudimalad, a-neggweburgi be nomarsun, degine, bemar-sapurba-gudimalad mer bar neggweburse dagmalo. ");
INSERT INTO cuk09_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“Ar a-ibagangine dulemar-sabsur-odurdaklegoedba nunmaked-dummad guoed. Ar deyob guoed, adi bela Bab-Dummad-Gardagi-narmakar-naidba guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ar ammamar-gurgin-nika-gudidimalad, degi, mimmigan-gwaruu-onunanaimaladdi a-ibagangi be ani nue wilemaloed, ar ade geg be abarmak-gumaloed. Ar ade a-ibagangi we-napneggi ibagan-nunmak-itoleged nai-guoed, degine, Bab Dummad we-dulemargi nue odurdaked-dummad nasikoed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","“Degine, espunyargi ewarar burgwemaloed, degine, galesmalad bela neggweburmar akar-akar seledmaloed, degine, dulemar-Judiosurmalad Jerusalén nue ichononimaloed, we-dulemar Jerusaléngi-gudigumaloed-e-ibagan berguoedse.” ");
INSERT INTO cuk09_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús sogdebar: “Geb degine ibelergi wilubgan dakledagoed, nigi, degine, niskwamargi wilubgan dakledabaloed. Degine, napneggi dulemar-yar-baid-baidgi-bukmalad demar-uurmakedba, degi, demar-arwedba, surbinsa ito-damaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Dulemar-bukidar dobedba, degine, ibmar-dummagan we-napneggi akar-gudagoedba negoedmaloed, ar ade nibneggi ibmar-dummagan gala-nika-nanaid bela giglimakoed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","“Geb degine ani Dule-Machi, mogir-imbaba an-ganguedba, degi, an bela-bela yeer-daklegedba-dani an-dakdamaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ar ibmar-wegimalad deyob guar be dakele, gannaa be itomar, degi, na be guakwaa gudigumar, ar ade be-san-burba-abonoleged-ibagan warmaksad.” ");
INSERT INTO cuk09_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Degi Jesús na e-sapinganga burbar-sunmaklegedgi sogdebalid: “Nue be dakmalana, higuera-sapi, degi, sapi-baigan. ");
INSERT INTO cuk09_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Wegi anmar-yargi sapimar bato gannar aramaksale, bemar nue wisid, yor omodanikid. ");
INSERT INTO cuk09_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Amba deyobmodo, we-ibmarmar an-bemarga-sogsamaladi deyob guar bemar dakalir, bemar wisdo, Bab-Dummad-neg-dakmaid bato warmakdanikid. ");
INSERT INTO cuk09_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Napira an bemarga soged, we-dulemar-burgwed-idu, we-ibmargan bela guedsegad. ");
INSERT INTO cuk09_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nibnegdi, degine, napnegdi bela berguoed, an-gaya-burbadi gege bergued, adi degi-sadeguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bemargi na be-dukin nue salakarmarmo. Bemar gwagegi gadi mas-gunnedginbi mer binsadii-gumalo. Degine, mer munguedginbi, degi, we-napneggi-ibmar-naidginbi mer binsadii-gumarbalo, ar degiile, abakalegi we-ibagan bemar edarbedisulid ukiar bemargi danikile. ");
INSERT INTO cuk09_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","“Ar we-ibagan bela-dulemar we-napneggi-bukmaladgi ukiar nonikoed, igi ibmar-durgan ibmar-gaedgi ukiar gale-daedyob. ");
INSERT INTO cuk09_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Degisoggu, guar be gudisamar, Bab Dummadse gordigumar, adi bemar unnitiba we-ibmar-gudagoedgi be wakinmalagar, degine, a-ibagangi adi Dule-Machi-asabin gwage-swilidik gwichi-gumogagar.” ");
INSERT INTO cuk09_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús, Bab-Dummadse-goled-neggi bane-bane neg-ibgi dulemar-odurdakdii-gualid, degine, neg-mutikdi gabnad-daed, Olivosye yar-nugadse. ");
INSERT INTO cuk09_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Degine, neg-wagdar Bab-Dummadse-goled-negse, bela-dulemar Jesússe noni-damalad, e-odurdaked itogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Dakleargu, Madu-Inasuli-Gulleged-Iba-warmakdanikidgine, a-iba bilebardo, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibaye. ");
INSERT INTO cuk09_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Degine, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar, amar igar-amiarmalad, igi-saele Jesús-oburgwemalo-dibeye, ar ade dulemar-dobmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Degi nia-saila-Satanás Judasgi dognonikid. We-Judasde, Jesús-sapingan-e-ambe-gakabogwad-wargwen-gued, Iscarioteye-nugbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Degi Judas nade-gusad, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse, degi, suar-ibmala-e-dummaganse. Amarse modapgu, ega sogdapid, ede Jesús emarga ukoye. ");
INSERT INTO cuk09_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Judio-dummagan weligwar itosmalad. Judas-ebo igar-nabosmarsunnad, ega mani ukegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas sogsa-gusad, nue Jesús an bemarga ukoye. Degisoggu, Judas amidii-gualid, adi dulemar-darba Jesús-ukegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Madu-Ina-Niksulid-Gulleged-Ibagan mosgu, a-ibagi sibad-wawaad gunnega oburgwer-gebed, adi Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad insaegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Agine Jesús, Pedro-barmis, Juan-ebo, amarga sogsad: —Anmar-idu be namar, iba-onogegala ibmar guagwar be imaknamar, adi agi anmar mas gunmalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","E-sapingan-warbogwad Jesúsga sogdemalad: —Degite, ¿bia anmar be-idu guar neg-imakbi be abege? ");
INSERT INTO cuk09_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús, abin-sogded: —Emigi, bemar neggweburse dogdapmalale, dule-wargwen be-abingumaloed, gukingi dii gwidugi semai. A-dule-sorba be namaloed, bia dogdapoe, a-neggi bemar dogmarmogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","A-neg-ibedga be sogmaloed: ‘Odurdaked-saila bega soged: ¿Bia an sapinganmala Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi an mas-gunnoed-neg sii?’ ");
INSERT INTO cuk09_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Neg-ibed neg-dummad guagwar bato nue-saale niba-ailabirgi bemarga oyogoed. Agi bemar guar anmar-idu mas simaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jesús-sapingan-warbogwad nadmarsunnad. Ar igi Jesús emarga sogsa, deyob dakdapmalad. A-neggi ibagi na mas-gunmalagala, bela-ibmar guagwar urbismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Degine, mas-gunned-wachi mosgu, Jesús mesa-naba na e-nuggi-barmilearmalad-warambe-gakabogwadmala signonikid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús na e-sapinganga sogded: —¡Ibiyobi Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi an-burgoed-iduar bemarba we-mas-gunned an edarbedii-gusa! ");
INSERT INTO cuk09_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ar napira an bemarga soged, we-mas bar an gunnosulid, Bab-Dummad-neg-dakmaidgi geb an gutapbaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Degine, Jesús nog susgua, dog-nuedye sogsad-sorba, sogded: —We be gobmar, na be mimmimar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ar an bemarga soged, emigindi uva-nisdi we-sorba bar an gobosulid, Bab-Dummad-neg-dakmaid-nonikidse geb an gobdapbaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Geb degi Jesús madu susbar, dog-nuedye Bab Dummadga sogsagu, madu biske-biske imaksad. Geb degi e-sapinganga ukde, sogded: —We-madu an-san, bemar-ular uklegoed. Weyob bemar imakmaloed, adi angi bemar binsamalagar. Jesús na e-sapinganmala we-madu guchamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Madu imaksadyob, mas-guchamalad-sorba, Jesús uva-nis imaksabalid. Jesús nog susgua, sogded: —We-uva-nis, an-abe. An-abe Bab Dummad dulemarbo igar-bini-mesnaid-wilubganad. We-an-abe bemar-ular milegoed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ar emigindi, dule-darba-an-ukoeddi we-mesagi an-abargi simogad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Napira an bemarga soged, ani Dule-Machi, ar igi Bab Dummad bato epenne angi sogsa-gusa, ar deyob an guoed, an burgoed. ¡Ar dule-darba-an-ukoeddina nue wilegoed! ");
INSERT INTO cuk09_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Geb degi e-sapingan na muchub-muchub sogdemalad: “Wede doa darba Jesús-uko-dibeye.” ");
INSERT INTO cuk09_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesús-sapingan na muchub-muchub gaarmalad, ar doa bur emarba dummad guo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús na e-sapinganga sogded: “Reymar-neggwebur-semamaid, amar dulemargi bur-dule-dummad na san-imak-daed, degisoggu, bela ega ibmar imakbi abe-damarsunnad. Dule-neggwebur-semaid, nued ibmar-imakmaye-nik sogle-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ar bemardi deyob guosurmalad, bemar dummadid, na dule-bipigwadyob na san imakoed. Be dulemar-iduedile, na be baigan-maiyob gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ar ¿doa bur dule-dummad-sunna, dule mesa-naba-sigedi, igi, dulemar mesa-naba-simaladga mas-dakedi? Dule-mesa-naba-siid, ¿a bur-dule-dummadsursi? Deyobdo. Ar an bemar-dummad-inigwele, bemar-abargi bemar-maiyob an gudiid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“An-wilubdakleged-abargi bemarbi galakussuli anba be gudimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Degisoggu, igi Bab Dummad, ega neg seega, an nug imaksa, deyob ani, an bemar-nug-imakmogad, adi bemar neg-semogagar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Adi bemar an-neg-dakmaidgi an-mesagi mas gunnegar, degi, gobegar, degine, olo-gan-nuedgi-sii Israel-dorgan-sogambe-gakabogwadga igar-nabosii bemar gumalagar.” ");
INSERT INTO cuk09_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Dummad-Jesús sogdebalid: —Simón, Simón, be dake, igi madubur-gwagwaled-e-uka-miega omukulege, deyob nia-saila-Satanás bemar-imakega bemar-egichis-gudiid, adi iskuedgi be-egwanegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ar andi bega Bab Dummadse gochad, adi ulubgi be an-bensulid mer galakuegar. Gannar mag-neg-ito be anse aibilisale, be-gwenadgan be oganno nao, adi gatik anba nagumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro, Jesús-abin sogded: —Dummad, an guagwar gudiid an beba naegar, unnila eskaryasebisur, ar burgweye soger, amba an ginbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús, abin sogded: —Pedro, an bega soged, gannir-namaked-iduar ilapaa be an-osulogoed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús na e-sapinganga sogded: —Deun sagu suli, mani-seed-sagu suli, degi, sapat suli an be-barmismargu, ¿bemarga ibmar akusmala? Jesús-abin, sogdemalad: —Suli, unniguar anmar ibmar-nika-gudigusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Degi Jesús sogdebalid: —Emigindi, dule sagu-nikad na sedo, degi, mani-urbed-sagu sedbalo. Ar dule espunyar sulile, na e-suba uko, adi espunyar a-manigi bakegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ar an bemarga sogmalad, ar angi Bab-Dummad-Gardagi narmakar naid, amba a-sogedba guer-gebed, sognaid: Dulemar iskudimaladyob imaklesmoye. Is. 53:12 Jesús sogdebalid: —Ar weyob angi narmakar naid, ayob guer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Geb degi e-sapingan sogded: —Dummad, anmar espunyar-warbo nikmalad. Jesús, abin-sogded: —We unniguar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús mas-gunsiid-neggi nodgua, nade-gusad, bia gusgu Olivos-yarse nad-daedse. E-sapingan eba nade-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Emar-nadapidse warmaksamargu, Jesús e-sapinganga sogde: —Bemar Bab Dummadse gormar, adi iskuedgi wilubdakleged mer bemarse warmakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús na e-sapingangi banguded, nabir-akwa-mileged bangued-wilub. Agi yokorgi sindigar sigisgu, Bab Dummadse goted, ");
INSERT INTO cuk09_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","sogded: “Baba, an-idu igar-buled naid, ina-gaibid gobedyob beedse an egi wilegoed. Be anga osulobiele, be osulogo, ar degite an-sogedbarsur, unnila be-sogedbarbi be imakoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Geb degi anger-wargwen-nibalid ese magarononikid, Jesús-ogannogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ar Jesús bela-bela nue-surbinsa-itogusgu, bur-bule Bab Dummadse gorsigisad. E-wimakedi abeyob napase dedemaknai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesús Bab-Dummadse-gorsiid gwisgusgu, e-sapingan-bukwadse nonikid, daknonikid, bukib-binsamaladba gabmamai. ");
INSERT INTO cuk09_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús amarga sogded: —¿Ar ibiga bemar gabmamai? Bemar gwisgumar, Bab Dummadse gormar, adi iskuedgi wilubdakleged mer bemarse warmakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús amba e-sapinganga sunmakgwichi, dulemar-bukidar ese duurmaknonikid, Judas, e-ambe-gakabogwad-wargwen, a emar-idudanikid. A-dule Jesússe warmaknonigu, ei-wagar unoni ega sogegar, be nued sogeye. ");
INSERT INTO cuk09_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Degi Jesús ega sogded: —Judas, ¿wegi wagar-uar ani Dule-Machi, darba be an-uke? ");
INSERT INTO cuk09_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesúsba-gudimalad dakdegu, igi igargan gudagoe, Jesúsga sogdemalad: —Dummad, ¿anmar espunyargi dulemar-eware? ");
INSERT INTO cuk09_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jesús amba yo abin-imake, e-sapin-wargwen dule-irwa-Bab-Dummadse-gormalad-bur-dummad-e-mai naibi-imaksad, e-uaya-nuedsikid ei siksad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Geb degi Jesús ega sogded: —Mer ese be bar achae. ¡Be indake! Jesús dule-uaya ebusgu, dule-onudaksad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Degi Jesús dule-irwa-Bab-Dummadse-gormalad-e-dummaganga, suar-ibmala-Bab-Dummadse-goled-neg-dakmalad-e-dummaganga, degi, Judiomar-girmar-dummagan-ese-nonimaladga sogded: —¿Ibiga bemar dule-iskana-ibmar-atursaedyob an-gadanimala, emide espunyar, degi, suarmar-yalaba bemar an-gadanimargu? ");
INSERT INTO cuk09_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Bane-bane an bemar-abargi Bab-Dummadse-goled-neggi gudigusgu, agi bemar akar gwen an-imaksasurmalad. Ar emigindi bemarga wilubgan nonikid, degi, nia-sogedba ibmar-imaked-iba nonibalid, adi bemar an-gamalagar. Geb degi Jesús-gasmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Dulemar Jesús-gasmargu, sesmalad, dule-irwa-Bab-Dummadse-goled-bur-dummad-negse. Agine, Pedro bannabasaar Jesúsba nadap-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Degi suar-ibmala neg-imba-abargi soo-ogasmargu, a-dikarba sigismarsunnad. Pedro amar-abargi signonimogad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bunagwa-arbaed, Pedro soo-naba sii dakargu, nuu dakdegu, sogded: —We-dule amba Jesúsba gudigusmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ar Pedrodi osuloded, sogded: —Bunagwa, we-dule aku an daked. ");
INSERT INTO cuk09_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Degi Pedro sikwas-ichee-naded-sorba, dule-baid Pedro-dakarbargu, ega sogdemogad: —Be-dule amba Jesús-sordamogad. Pedro, abin-sogded: —Dule, an a-sordasuli. ");
INSERT INTO cuk09_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A-wachi-irgwen-nasad-sorba dule-baid sogdemogad: —Napiragwa, we-dule Jesúsba gudigusmogad, ar we Galilea-dolad. ");
INSERT INTO cuk09_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Geb degi Pedro sogded: —Dule, an wichuli ibu be anga obare. Geb degi, Pedro amba sunmakgwichi yog gannir namakalid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Geb degi Dummad-Jesús, Pedro-dakdegu, Pedro, ebinsaas-naded, igi Jesús ega ibmar sogsad: “Gannir-namaked-iduar ilapaa be an-osulogoed.” ");
INSERT INTO cuk09_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Degi Pedro magaba nodgu, nue-ise-boar naded. ");
INSERT INTO cuk09_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Dulemar, Jesús-mer-wakinnega-edarbebukmalad Jesúsgi dodoarmalad, degi, Jesús-sarsoarmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ei-ibya edichamargu, wagargi bibyos-damalad, geb ese egichiar-damalad: —Ar bela be ibmar wissoggu, be anmarga soge, ¿doa be-bibyossunna? Jesúsdi dulemar-gwen-abin-imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Degine, dulemar Jesús-nug-ichoegala bukidar egi sunnasur sunmakdemarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Neg-oibosgu, Judiomar-girmar-dummagan-neggwebur-sedimalad, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar ambikunonimalad, geb degi igar-nabiromalad-negse Jesús-senonimalad. Geb agi egichiarmalad: ");
INSERT INTO cuk09_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Be Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule? Be anmarga soge. Jesús, amar-abin sogded: —Ar an bemarga sogdele, be an-itossurmalaled. ");
INSERT INTO cuk09_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Deginbali, an bemarse egichidele, bemar an-abin imaksasurmalaled, degine, be an-onossurmarbaliled. ");
INSERT INTO cuk09_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ar emigindi, ani Dule-Machi, Bab-Dummad-Gangued-Nikad e-argan-nuedsik sigidapsunnoed dummadga guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bela sogdemalad: —¿Ar degisoggu, be Bab-Dummad-Machisunde? Jesús, abin-sogded: —Ar bemar-soged an aaye. ");
INSERT INTO cuk09_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Geb degi sogdemalad: —¿Ar ibiga dule-baid anmarga Jesúsgi bar ibmar-sogbi an abemarsunna? Ar anmar-sunnad an itosmalad na dukin sogsad, ede Bab-Dummad-Machiye. Degisoggu, we-Jesús-oburgwileger-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Geb degi bela-dulemar-igar-itobukmalad ainidmargu, Pilatose Jesús-sesmarsun, adi ega igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Geb degi Judio-dummagan Jesúsgi sognai-guarmalad, sogdemalad: —We-dule anmar itosad, dulemar-binsaed gadii, sogdii, mer Roma-Dummad-Césarga mani ukoye. We-Jesús na dukin sogdiid, ede reyye, ede Cristoye. ");
INSERT INTO cuk09_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Geb degi Pilato Jesússe egichialid, ega sogded: —¿Ar be Judiomar-E-Rey? Jesús, abin-imakdegu, sogded: —Ar bede soged. ");
INSERT INTO cuk09_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Degine, Pilato sogded, dule-irwa-Bab-Dummadse-gormalad-e-dummaganga, degi, dulemar-bukmaladga: —An dakgua, we-dule ibmar-gwen-oakalossur an daked. ");
INSERT INTO cuk09_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ar emar bur-bule sogdemalad: —We-Jesús dulemar-oimakdiid, bela Judea-yalaganba dulemar-odurdakdiid, Galilea-akar onoalid, emide wesegus naigusad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Geb degi Pilato itoargu, dulemar soge, Galileaye, egisdesunnad: —¿We-dulede Galileaginedi? ");
INSERT INTO cuk09_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato itoargu, Herodes-neg-dakmaidgi Jesús daniki, Herodesse barmissunnad. Ar ade deun Herodes Jerusalén-neggweburse gudimogad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes, Jesús-dakargu, weligwar itosad, ar ade dikasurgus Jesús-dakbigudiid. Herodesde itodiid, dulemar bukidar Jesús-ibmar-imakdiidgi sunmake. Degisoggu, Herodes binsadsunnad, Jesús e-wagab ibmar-dakledisulid ega imako insaye. ");
INSERT INTO cuk09_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes ibmar-bukidar Jesússe egisnai-gualid, ar degite Jesús gwen Herodes-abin imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Degine, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, escribamar Herodesga Jesúsgi binnasur sunmaknanai-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Geb degi Herodes, na e-suar-ibganmala, Jesús ibgwensur dakded, egi dododed, reymar-mor-nued-yoedyob, ega yosmarsunnad. Geb degi Herodes Pilatose gannar Jesús-barmisad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A-ibagine Pilato, degi, Herodes-ebo ailesad, ar ade iduardi ebo urwedimalanad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Geb degi Pilato, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse, neg-semamaidse, degi, bela-dulemarse gochagu, ");
INSERT INTO cuk09_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","amarga sogded: —We be-anga-senonimalad, be anga sognonimalad, we neg-oimakdiiye. Ar bemar-wagab an ese bela ibmar egichisgu, gwen an daksulid, we neg-ichodiid. Deginbali, egi-be-sunmakmalad gwen deyob an daksurbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ar Herodesse-bakar, an ese barmisgu, Jesús gwen ibmar oakalossuli daksamogad. Ar degisoggu, Jesús ibmar-iskana-gwen-imaksasursoggu, oburgwilege-wilubsulid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Degisoggu, an nue odurdaksad-sorba an we-dule-onogodo. ");
INSERT INTO cuk09_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ar ibagi Pilatode gusgu igar-maidba dule-wargwen-eskaryagi-mellesiid ono-daed. ");
INSERT INTO cuk09_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ar dulemar-bukidar-bukwaddi bela dule-wargwennayob oimakdemalad, sogdemalad: —¡We-Jesús be oburgwe, Barrabás be anmarga bur onoge! ");
INSERT INTO cuk09_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","We-Barrabásde eskaryagi-mete-gusmalad, ar ade Jerusaléngi, Roma-dulemargi gwisgusgu, neg-oimakdigu, dule-oburgwisad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato Jesús-onobiedba idu-sogsadgii gannar dulemarga sogdebalid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ar dulemardi gannar oimakdemarbalid: —¡We-dule nakrusgi bioke! ¡We-dule nakrusgi bioke! ");
INSERT INTO cuk09_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Geb Pilato gannar ilapaagi dulemarga sogdebalid: —¿Ar degite, we-dulede ibu-ibmar-iskana wede imaksasunna? An dakgua, ibmar-iskana gwen imaksasursoggu, oburgwilege-wilubsulid. Degisoggu, unnila an odurdakodo, geb degi an onosunnoed. ");
INSERT INTO cuk09_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ar emardi binnasur oimakdemalad, sogdemalad: —¡We-Jesús nakrusgi bioke! Ar degite, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, dulemar-oimakbukwad-sogedba bur imaklesad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Geb degi Pilato dulemar-egisbukwadba imaksasunnad, Jesúsga nakrusgi-oburgwed-igar mesissunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Dule Roma-dulemargi gwisgusgu, neg-oimakdii dule-oburgwisad-ular, eskaryagi mellesiid, a-dule Pilatose egichismalad ega onoye, a ega onossunnad. Geb Jesúsdi suar-ibmalaga uksasunnad, adi dulemar na igi Jesús imakbiedba imakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Roma-suar-ibgan Jesús-sesmargu, dule-wargwen Simón-nugad, Cirenegined, Jerusalénse-dani abinguarmalad. A-Simón ise-gandikidgi gasmargu, e-gukingi nakrus mesismalad, adi Jesús-sorba nakrus-semai-guegar. ");
INSERT INTO cuk09_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dulemar-bukidar Jesús-sorba duurmaknadap-gusmalad. Omegandi ee bonadap, Jesúsga oimaknadap-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ar Jesús omegansik aibiridgua, amarga sogded: “Omegan-Jerusalénginmalad, mer anga be bomar, na dukin be bomar, degi, be mimmiganga be bomar. ");
INSERT INTO cuk09_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ar ade ibagan-bulegan nonikoed, sognonimaloed: ‘Omegan-geg-mimmi-nikumalad, we-omegan-gusgu-geg-muu-neggi-gurgin-nikumalad, gwen-mimmigan-onussurmalad, we-omeganga bur ib-nuedga gusye, ar ade we-omegandi na-e-mimmiganba gwen wilegosulid.’ ");
INSERT INTO cuk09_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Geb degi dulemar sabsur-wilenaidba Yarmarga sogdamaloed: ‘Anmargi bur be batedamar.’ Degi yar-mulluganaga sogdamarbaloed: ‘Bur be anmar emurmar.’ ");
INSERT INTO cuk09_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Sapi-dinnagwad bur-bule sapi-makidba gummaked, ar deyobmodo, ar yaisur an wiomalale, ar dulemar-iskudimalad-bursunna, bur-bule wiomalodo.” ");
INSERT INTO cuk09_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Suar-ibgan dulemar-iskanamar-warbo Jesúsba semai-gusmarbalid, oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dule-Nonogarye neg-nugadse omosmargu, agi nakrusgi Jesús-bioksamalad. Dulemar-iskanamar-warbogwad nakrusgi bioksamarmogad. Wargwen Jesús-nakrus-argan-nuedsik ogwichismalad, baiddi, Jesús-nakrus-argan-sapiledsik. ");
INSERT INTO cuk09_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Degi Jesús sogded: —Bab Dummad, wemar iskunaisuliyob be dakoed, ar wichurmalad ibu imaknanai. Degi, suar-ibgan Jesús-morgi dodoarmalad, wilubdaknai-guarmalad, igid-mor emargadga guo-dibeye. A-sorba Jesús-mor mimmismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Degine, dulemar-bukidar dakbukwa-gusmalad, neggwebur-dakmamaidse-bakar Jesúsgi dodonai-gusmalad, sogdemalad: —We-Jesús dule-baigandi nabir bendaksad. Ar we Cristole, Bab Dummad susadile, na dukin bendakdo. ");
INSERT INTO cuk09_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Amba suar-ibgan Jesúsgi dodonanai-gusmarmogad, inna-gaibid ega senonimalad, ega uknonimalad, ");
INSERT INTO cuk09_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ega sogdemalad: —Ar be Judiomar-E-Reyle, na be dukin bendakdo. ");
INSERT INTO cuk09_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús-nakrus-birgi narmakar nai-gusbalid, Griego-gakaba, Latínba, degi, Hebreoba. Sognai-gusad: ");
INSERT INTO cuk09_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Dule-iskana-wargwen, Jesús-dikarba-nakrusgi-biokar-naimogad, egi dodonai-gusmogad, ega sogded: —Ar be dule-Bab-Dummad-yoedse-barmidagoye-sogsad-dulele, na be dukin bendakdo, degine, be anmar-bendakmodo. ");
INSERT INTO cuk09_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Agine, nakrusgi-biokar-naid-baid Jesúsgi-dodonaid-abin-imakded, ese uluded, ega sogded: —¿Ar be we-Jesús sunnaa burgwe sognai-inigwele, degite be Bab-Dummad-dobsuli? ");
INSERT INTO cuk09_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ar anmardi napiragwadba wilenaid, ar anmar ibmar-imaksadba odurdaklenaid. Ar wedi, ibmar-iskana gwen imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Geb degi Jesúsga sogded: —Reyga-mai be-neg-dakmaidgi na-be-danikir, be an-insao. ");
INSERT INTO cuk09_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Geb degi Jesús, abin-sogded: —Napira an bega soged, emi-ibagi nibneg-nued-naidgi be anba gudiguoed. ");
INSERT INTO cuk09_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Degine, yorukugusgua, bela napneggi neg-sichid-nagusad, wachi-irbaase naigusad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Degine, dad-ibeler gwen-bar-gassulid. Jerusaléngi Bab-Dummadse-goled-neggi, Neg-Islidikid-irwa mor-naid, negabar achirmakde-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Geb degi Jesús binnasur gotegu, sogded: —Baba, be-argangi an-san-burba an uksun. Degi-sogsad-sorba, Jesús burkwis naded. ");
INSERT INTO cuk09_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Roma-sordamar-dulatar-sediid, weyob-ibmar-gusad daksagu, Bab-Dummad-nug ogannoded, sogded: —Ar we-dule ibmar-gwen-oakalossulid, dule-nued-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bela dulemar-bukidar, Jesús nakrusgi-burgwenaid-dakbukmalad, bela we-ibmargan-gusad daksamargu, bukib-binsamaladba, na dukin binasgargi na sarsonanai negse nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ar bela Jesús-mag-dakmaladdi, degi, omegan, Galilea-akar-eba-bipirmakdimaladdi dikasur we-ibmar-gunaid dakbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Deun Judio-igar-nabiromalad-wargwen, José-nugad mai-gusmogad. A-dulede Arimatea-neggweburginedid, Judea-yala-dolad. A-José dakleargu, dule-nued, dule-igar-napiragwadba-daed-duled. ");
INSERT INTO cuk09_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","We-dulede, Bab-Dummad-neg-dakmaid nue edarbedimogad-duled. Josédi, Jesús-oburgweye sogsamaladba gwen naigussulid, degine, emar-ibmar-imaksamaladba gwen akassurbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","We-dulede Pilatose nade-gusad, Jesús-mui egisdapid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José, Jesús-nakrusgi-burgwar-naid odesgu, atued-sipugi nue obipirmaksad. Geb degi José akwa-gwisar neg-uanga-siid-yaba, yo-dule-egi-diglegedgi Jesús-mesisad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Deun a-ibagi Ibmar-Guagwar-Sied-Ibad, bato obunnoged-iba warmakdanikid. ");
INSERT INTO cuk09_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Omegan Galilea-akar-Jesúsba-danigusmalad, José-Arimatea-sorba nade-gusmalad, daksamalad neg-uan bia siid, degi, daksamarbalid, igi Jesús-digles mesismalad. ");
INSERT INTO cuk09_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Omegan gannar aibilismargu, ina-biseb-wawaad, degine, gwallu-wawagwad-nuegan guagwar urbismalad, adi Jesús muigi eonamalagar. Geb degine, omegan obunnoged-ibagi obunnosmarsunnad, igi Moisés-ega-igar-mesisadba. ");
INSERT INTO cuk09_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Itoged-iba-gebe-nagudedgi, wakudaryalaba omegan-baiganmala neg-uanse nadmalad, gwallu-wawagwad-guagwar-imasmalad sesmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Omegan neg-uanse nonimargu, daknonimalad, akwa-dummad bato ainirar sii. ");
INSERT INTO cuk09_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Neg-uanse dogdemargu, dakdemalad Bab-Jesús-e-san sate. ");
INSERT INTO cuk09_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jesús-mui-satedbali omegan aku itobukmaladgi, wede igi gusa, agi machergan-warbo, mola-sibu-ise-dakar-dakar-gaed-yoimalad ese gwisgunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ar omegan dobe itodmarsoggu, napase dulluu atakdemarsunnad. Machergan-warbogwad omeganga sogded: —¿Ar ibiga bemar dulemar-burgwarmalad-abargi dule-dula-gudiid be amidimarsunna? ");
INSERT INTO cuk09_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús wegi maisulid, ar bato gannar durgusad. Jesús amba Galileagi gudigu, igi bemarga sunmaksa, a be insamala. ");
INSERT INTO cuk09_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Deun Jesús bemarga sogsa-gusmargu: ‘Ani Dule-Machi, dulemar-iskudimaladse an ukleger-gebed, nakrusgi an biokleger-gebed, degi, ibapaagi gannar an durguer-gebed.’ ");
INSERT INTO cuk09_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Degi geb omegan insaas-naded, Jesús weyob ibmar sogsad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Omegan-neg-uanse-gudimalad nonimargu, e-ambe-gakagwensakad Jesús-nuggi-barmilesmaladga, degi, bela-baiganga, sogdemalad, Jesús gannar durgusad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","We-omegan gaya-burba-nued Bab-Jesús-nuggi-barmilearmaladga sognonimalad wemardo: María-Magdalena, Juana, María, Santiago-e-nan, degi, omegan-baigan-eba-gudimalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ar Jesús-nuggi-barmilesmaladdi omegan-emarga-ibmar-soged binsa ee gordimaladyob daksamarsoggu, bengudmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ar Pedrodi gwisgudgu, neg-uanse abarmakde gusad. Neg-uan mosgu, yaba atakdegu, atuedbi bukwa daksad. Ar Pedro weyob-ibmar-gusad geger dake, negse nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Degine, amba a-ibagi Jesúsba-nanaimalad-warbo Emaús-neggweburse nadap-gusmalad. A-neggwebur Jerusaléngi wachi-irbo-nanalegedgi egi siid. ");
INSERT INTO cuk09_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ebo na sunmaknadap-gusmalad bela wemar-ibmarmar gusadgi. ");
INSERT INTO cuk09_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ebo na sunmaknadapmargu, na muchub-muchub na ese egisnadapmargu, Jesús-sunnad ese warmaknonikid, eba nadap-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ar wemar-warbogwad e-ibya bargalesad, adi mer Jesús mag-dake-gumalagar. ");
INSERT INTO cuk09_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús amarga sogded: —¿Wede ibigi bemar sunmaknadapi, degine, ibiga bemar bukib-itomala? ");
INSERT INTO cuk09_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Emar-gwensak, Cleofas-nugad, abin-imakdegu ega sogded: —¿Ar unnila bebi-wargwennaa dule-gwapid Jerusaléngi bela emi-ibagangi ibmarmar-gusad wichulid gudiisi? ");
INSERT INTO cuk09_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Geb Jesús, abin-sogded: —¿Ibu-ibmala? Geb abin-imakdemalad: “Jesús-Nazaretginedgi bela ibmarmar gusad. We-Jesús Bab-Dummad-gaya-burba-berbeged, gandikidba nued Bab-Dummad-asabin, degi, dulemar-asabin ibmar-saed, degi, gandikidba-sunmaked-dulebalid. ");
INSERT INTO cuk09_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Degine, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, anmar-neggwebur-dakmamaid Roma-dummadga Jesús-uksamalad, adi oburgwemalagar. Geb degine, nakrusgi Jesús-bioksa-gusmarbali. ");
INSERT INTO cuk09_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Ar anmardi we-Jesúsgi binsadii-gusad, we-dule Israel-dulemar-abonogoedye. Ar emigindi, ibapaagus we-igargan deyob-gusad-akalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Ar omegan-anmar-abargi-bipirmakdimogad, amba yo-nue-neg-ibgued-idu neg-uanse nade-gusmalad. A-omegan geger-ito anmar-imaksad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ar ade Jesús-san neg-uangi gwen mai daksasurmarsoggu, anmarga sognonimalad, emarde ibya apurusmarye, angermar-daksamarye. A-angermar ega sogsamarye, Jesús dula gudiiye. ");
INSERT INTO cuk09_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","“Degine, anmar-sordamar neg-uanse nade-gusmalad, ar igi omegan sogmala, deyob dakdapmalad, ar Jesúsdi gwen daksasurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Geb degi Jesús amar-warbogwadga sogded: “Bemar non-sered gumar, degine, Bab-Dummad-gaya-burba-berbemalad-sogsamalad-bengumalad-dulemarbalid. ");
INSERT INTO cuk09_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ar Cristode bela-bela e-nug-odunguleged-iduar weyob wileger-gebsursi? Eye, deyob wileger-gebed.” ");
INSERT INTO cuk09_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Geb Jesús sogdebar, Moisés sogsad narmakar naidgi, degine, bela Bab-Dummad-gaya-burba-berbesmalad sogsamaladgi, degi, bela Bab-Dummad-Gardagi egi sognaidgi. Amar-warbogwadga Jesús bela sogsa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na neggwebur-nadapmaladse warmaksamargu, Jesúsdi yamo-imaksad edi nadegu saoeyob. ");
INSERT INTO cuk09_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ar emar-warbomalad Jesúsgi ise-alamaknai gusmalad, ega sogdemalad: —Bato neg-sedosgussoggu, neg-mutikgualid, degisoggu, anmarba be besun. Degisoggu, Jesús, emarba bessunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Geb degi Jesús emar-abargi mesa-naba sii, madu susad, Bab Dummadga dog-nuedye sogsagu, madu biske-biske imaksad, geb emarga uksasunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Geb degi e-warbogwad mag-Jesús-dakdemalad. Geb agi Jesúsdi egi binnidsunnad, gwen bar daksasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Geb degi ega na muchub-muchub sokarmalad: —¿Ar igarba danigu, anmarga Bab-Dummad-Gardagi sunmakdanigu, anmar-gwagede nue-weligwar itodani-gussursi? ");
INSERT INTO cuk09_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wemar-warbomalad a-wachigi yoga gwisguar imaksamalad, gannar Jerusalénse ali-gusmalad. Jerusalénse nonimargu, e-ambe-gakagwensak Jesús-nuggi-barmilesmalad, degi, baigan-eba-bukmarmogad danar-bukwa daknonimalad, ");
INSERT INTO cuk09_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","sogbukmalad: —Ar Dummad-Jesús nue gannar durgusye, Simónse Jesús na magarosye. ");
INSERT INTO cuk09_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Geb degi emar-warbogwad amarga sogdesun, igi igarba gusmala, degine, igi Jesús madu bichidgu, emar mag-Jesús-daksamala. ");
INSERT INTO cuk09_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jesús-sapingan amba we-ibmargangi sunmakbukmala, Jesús emar-abargi gwisgunonikid, emarga sogded: —¡Na, degite! Bemar, gwage bogidikidgi gudigumarsun. ");
INSERT INTO cuk09_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jesús-sapingandi gwakidmargu, dobgudmalad, sergan-dakye binsadmalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ar Jesúsdi amarga sogded: —¿Ar ibiga bemar dobe itomarsunna, degine, ibiga deyob bemar ulubgi binsamarsunna? ");
INSERT INTO cuk09_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","An-argan, degine, an-mali bemar dakmar. Be an-ebumar, adi bemar mag dakmalagar an-sunnad an gudiid. Ar burbadi sana, degine, garmar sulid, ar andi sana, degi, garmar nikad. Be an-dakmalana. ");
INSERT INTO cuk09_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ar degi-soggwichi, ega e-argan, degi, e-mali oyoded. ");
INSERT INTO cuk09_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ar e-sapingandi weligwaledba Jesús-durgusad bengudmalad, geger dakdemalad. Degisoggu, Jesús amarga sogdesunnad: —¿Ar bemar mas-gunned wis nikmala? ");
INSERT INTO cuk09_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Geb degi e-sapingan ua-naraled bisgar, degi, achanis ega uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús na e-sapingan-annik susgua, amar-asabin, ua, degi, achanis, guchad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesús amarga sogded: —Ar bela-angi-gusad we-ibmarmargi an bemarga bato sunmaksamalad, deun amba an bemar-abargi gudigu. Ar bela angi narmakar-naidba guer-gebed, igi Moisés-igargi, degi, Bab-Dummad-gaya-burba-berbemalad-narmaksamalad, degi, Salmosgi narmakar-naidba bela angi deyob guer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Geb degi Jesús na e-sapingan magar-itoged imaksad, adi mag itomalagar, igi Bab-Dummad-Gardagi-narmakar-naid nue sognai. ");
INSERT INTO cuk09_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús amarga sogded: “Weyob-narmakar-naid, a-narmakar-naidba Cristo-wileger-gebed, degi, burgwar-mai ibapaagwad-sorba gannar durguer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Degine, bela we-napneggi neggweburmar-nanaidgi Cristo-nuggi sunmakleger-gebed, dulemar na e-iskuedga bukib itoged, adi e-daed ogwamalagar, degi, Bab Dummad dulemarga iskued elinoni-daed igargi. We-igargan-sunmakleged Jerusalén-akar onodoed. ");
INSERT INTO cuk09_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ar bemar-sunnad we-igargan angi gusad daksamarsoggu, baiganga bemar sogmarmosunnodo. ");
INSERT INTO cuk09_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","“Emide, an-Bab bemarga sogsa-gusad, an bemarga ukoye, a an bemarga barmidagoed. Jerusalén-neggweburgi be edarbemalo, nibneg-akar burba-gangued bemarse nonikoedse.” ");
INSERT INTO cuk09_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Degi Jesús Jerusaléngi e-sapingan-bukwad-onosad, Betaniase sesa-gusad. Agi na e-argan niba onakwidgu, e-sapinganga sogded: —Bab Dummad bemargi nued binsaena-gadin. ");
INSERT INTO cuk09_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Degine, Jesús na e-sapinganga degi-sunmakgwichi, egi nued binsasgu, banguded, degi, edi nibnegse nakwidsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","E-sapingandi, Jesús-Bab-Dummadyob-daksadba e-nug ogannodmarsunnad, nue-weligwar gannar Jerusalénse aibirismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ar emardi Bab-Dummadse-goled-neggi gudigu-gusmalad, Bab-Dummad-nug ogannonai, degi, Bab Dummadgi nued binsabukwa gusmalad. Be itomargua.");
INSERT INTO cuk09_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Gebe-negasailaunni bato Gaya-Burba-Nued gudiid, we-Gaya-Burba-Nued Bab Dummadba gudiid, degi, we-Gaya-Burba-Nued, Bab Dummad gued. ");
INSERT INTO cuk09_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","We-a-Gaya-Burba-Nued, gebe-negasailaunni bato Bab Dummadba gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A-Gaya-Burba-Nued bela ibmar obinnisad. Ibmar-ambikunonikid, a-suli gwen ambikunonisulid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","A-Gaya-Burba-Nuedgi san-burba-dulad gudiid, we-a-san-burba-dulad dulemarga gwallu-meegwadga-gued. ");
INSERT INTO cuk09_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Gwallu-meegwad neg-sichid mee imaked, degine, neg-sichid gege gwallu-meegwadgi obined. ");
INSERT INTO cuk09_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bab Dummad dule-wargwen-barmiar-gusad, a-dule Juanye-nugad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","We-dule-nonikid gwallu-meegwad barsogega nonikid, adi bela dulemar a-gwallu-meegwad mer bengumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","We-dule, Juan-nugad, a gwallu-meegwadsulid. Juan nonikidi, unnila gwallu-meegwad-barsogegalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","We-gwallu-meegwad we-napnegse dani-gusad, napiragwadid. A-gwallu-meegwad bela dulemarga neg-mee-saed. ");
INSERT INTO cuk09_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","A-gwallu-meegwad we-napneggi gudigusad, ar we-napneg a-sogedba nagus-inigwele, degite, dulemar-we-napneggi-bukmalad aku daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","We-Gaya-Burba-Nued na e-dulemarse nonikinad, e-dulemar gwen abingassurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ar bela dulemar a-Gaya-Burba-Nued-abingasmaladdi, e-nuggi-bengussurmaladba, amarga Bab Dummad igar-uknonikid, na e-mimmiganga-gued-igar. ");
INSERT INTO cuk09_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A-Gaya-Burba-Nuedgi-bensurmalad, Bab Dummad Burba Nuedba gwalulenonimalad, dulemar-sogedbarsulid, dulemar-igarginsulid, dulemar-binsaedginsurbalid. Suli, degisuli. A-dulemar Bab-Dummad-sogedba E-Burba-Nuedgi gwalulenonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","We-a-Gaya-Burba-Nued, anmargii sanale san-nika-gunonimogad, degine, anmar-abargi sanale gudigusmogad. Anmar e-gandik-gaed daksamalad, unnila Bab-Dummad-Machi-Wargwenna-Gued e-gandik-gaed. A-dule ibibayobi dulemar-sabgue-wilubsulinad, degite, nue dulemar-sabe nanadii-gusad, degine, igar-napiragwadgi nanadii-gusbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan-Bautista a-dulegi sunmaksa-gusad, sogde-gusad, deun binnasur gote-gusgu: —We-dulegi an bemarga sunmaksa-gusmalad: Dule-wargwen an-sorba-danikoedi, we an-iduedid, ar we-inse an-idu gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ar a-dule bela-bela anmargi nued binsamaisoggu, belagwapa ibmar-nikadba ibmar-nuegan anmarga ukmaiguad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ar Bab Dummad Moisésba dulemarga igar-mesisad, dulemar igi nanaer-gebe. Ar Bab-Dummad-anmargi-nued-binsaeddi anmarga uklege-wilubsulinad na e-anmarga-ukbiedba anmarga ukmaid, degi, igar-napiragwaddi Jesucristoba anmarga uknonikid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dule gwen Bab-Dummad-dakdisulid. Unnila Bab-Dummad-Machi-Wargwennagwad, na e-Babba-mesa gudiid, a anmarga Bab-Dummad-osanalononikid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juan-Bautista Jesúsgi sunmaksa-gusgu, weyob gusdo. Deunni Judiomar-dummagan Jerusalén-akar dule-irwa-Bab-Dummadse-gormalad, degi, a-bendakmalad-barmiar-gusmalad, Juanse egismalagar: —¿Be doa-dule-sunna? ");
INSERT INTO cuk09_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan na dukin sogsa-gusad, gwen yapa sogsasulid: —Ani an Cristosur. ");
INSERT INTO cuk09_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Degi gannar Juanse egichidmarbalid: —Degite, ¿be doa-dule-sunna? ¿Be Elías? Juan, abin-imaksad: —Suli, an a-dulesur. Juan-Bautistaga sogdemarbarsun: —Degite, ¿be Bab-Dummad-gaya-burba-berbeged anmar edarbediiddi? Juan, abin-imakebar: —Suli, an a-dulesur. ");
INSERT INTO cuk09_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Degi ega sogdemarsun: —Degite, ¿be doa-dule-sunna? Adi dummaganga anmar sogega, be doa-dule. Degite, ¿doa-duleye na be sogsunna? ");
INSERT INTO cuk09_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan, abin-sogde-gus: —Isaías, Bab-Dummad-gaya-burba-berbeged sogsa-gusad: Dule-wargwen nega-dule-sulidganba binnasur sunmaknonikoed, dulemarga sognonikoed: Dule-Dummad-idu igar mayemar, igar-swilidik mesmar. Is. 40:3 Ani an a-duledo. ");
INSERT INTO cuk09_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Dulemar-Juanse-barmilear-gusmaladi, Fariseo-sapingan gumalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Juanse egichiarmalad, ega sogdemalad: —¿Ar degite, ibiga be Bab-Dummad-digi-ogleged-igar imakdisunna, ar bede Cristosulid, degi, Elíassurbalid, degine, Bab-Dummad-gaya-burba-berbeged anmar edarbediidsurbalid? ");
INSERT INTO cuk09_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan, amar-abin imakdegu, sogsa-gus: —Andi Bab-Dummad-digi-ogleged-igar-imakedi, unnila digi an ogdiid, ar bemar-abargi dule-wargwen-gudiiddi aku be dakmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A-dule an-sorba-danikidi, we an-iduedid. Ar anba bur dule-dummadsoggu, gege e-sapat-dub esik an itoged. ");
INSERT INTO cuk09_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","We degi-gusadi, bia Juan Bab-Dummad-digi-ogleged-igar imaknai, Jordán-diwar-obakar, Betania-neg-nugadgi, agi deyob gusa-gusdo. ");
INSERT INTO cuk09_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A-banedgine, Juan Jesús-ese-dani dakargua, sogded: —Be dakmalana, we-dule, Bab-Dummad-Sibad-Wawaad-E-Mimmid, bela dulemarga-we-napneggi-iskued osulogedid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","We dule-nik an sogsa-gusad: ‘Dule-wargwen an-sorba danikid, ar a-dule an-iduedid, ar ade a-inse an-idu gudiid.’ ");
INSERT INTO cuk09_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aku a-dule an dakmoganad. A-ulale, Bab-Dummad-digi-ogleged-igar an imaknonikid, adi Israel-dulemar mag dakega, doa Bab-Dummad-epenne-barmidagoye-sogsad-dule. ");
INSERT INTO cuk09_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan Jesús-nik sogsa-gusbalid: —Nibneggi Bab Dummad Burba Nued nuuyobi aidedani, degi, a-dulegi nagunoni an daksad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","An aku a-dule-dakmoganad, ar Bab Dummad digi-ogleged-igar-imakega an-barmialid, a anga sogsad: ‘Dule-wargwengi Bab Dummad Burba Nued aidenoni, degi, egi nagunoni be daksale, we a-duledo, Bab Dummad Burba Nuedgi dulemar-ogoed-duledo.’ ");
INSERT INTO cuk09_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","We deyob an daksad, degisoggu, nue an sogsundo, we-dule, Bab-Dummad-Machi-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A-banedgine, gannar Juan-Bautista, degine, e-sapingan-warbo walik gudiid, ");
INSERT INTO cuk09_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","dakarmalad, Jesús e-walik gudii. Juan sogded: —Be dakmalana, we-dule, Bab-Dummad-Sibad-Wawaad-E-Mimmid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juan-e-sapingan-warbogwad degi-soge itosgu, Jesúsba nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús sorba atakdegu, dule-warbogwad-eba-dani dakargu, amarga sogded: —¿Ibu be amimala? Amar, abin-sogdemalad: —Rabí, ¿Bia be mai? (Rabí sogleged, odurdaked-sailaye.) ");
INSERT INTO cuk09_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús amarga sogded: —Bemar dagmar. Degi be dakmaloed bia an mai. Amar Jesúsba nade-gusmar, degi, daksamar bia Jesús maid. A-ibagi Jesús-walik osedosmalad, ar ade bato sedosad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Emi dule-warbogwad Juan-sunmak-itosad, Jesúsba-nade-gusmalad, wargwen Andrésye-nugad, Simón-Pedro-e-urba. ");
INSERT INTO cuk09_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrésde e-ia-Simón-inse aminaded. Simón-amisgu, ega sogded: —Anmar Mesías-amismalad. (Mesías sogleged, Cristo.) ");
INSERT INTO cuk09_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Geb degi Andrés, e-ia-Simón Jesússe senonikid. Jesús, Simón-nuu-dakdegu, ega sogded: —Be Simón, Jonás-machi, emigindi Cefasye be nugguoed. (A sogledo, Pedro.) ");
INSERT INTO cuk09_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A-banedgine, Jesús Galilease naesokargu, agi Felipe-dakar, ega sogded: —Anba be dage an-sapinga guegar. ");
INSERT INTO cuk09_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe, Betsaida-neggweburginedid. Andrés, degi, Pedro, a-neggweburginmarmogadid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe, Natanael-aminad. Amisgu, ega sogde: —Moisés e-igar-mesisadgi igi narmaksa, degi, Bab-Dummad-gaya-burba-berbemalad egi narmaksamarmoga, yoedse dule-wargwen danikoye, a-dule anmar amisad. A-dule, Jesús, José-machi, Nazaretginedid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael, abin-sogded: —¿Ar Nazaret-neggweburgi sunna ibmar-nued nodasi? Felipe, abin-sogde: —Be anba dage, adi be-sunnad be dakoed. ");
INSERT INTO cuk09_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús, Natanael-ese-warmakdani dakargu, Natanaelgi sogded: —Wedi Israel-dule-sunnadid, dule-nuedid, we-dule gwagegi emar-yardaked gwen naisulid-duled. ");
INSERT INTO cuk09_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael Jesúsga sogded: —¿Wede igi be an-wisi an deyobid? Jesús, abin-sogded: —Amba yo Felipe bese goleunni, deun sapi-higuera-urba amba be sigua, bato an be-daksad. ");
INSERT INTO cuk09_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael Jesúsga sogdesun: —Rabí, be Bab-Dummad-Machi, Israel-e-Rey-sunnadid, a-ular be an-wisid. ");
INSERT INTO cuk09_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús, abin-sogded: —An bega sogsad, be higuera-sapi-urba sii an be-daksaye, ¿a-ular be an-bensuli? Weba bur-bule ibmar-dummagan be dakoed. ");
INSERT INTO cuk09_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús Natanaelga sogdebar: —Napira an bega soged, emi-onodedgi nibnega argas, Bab-Dummad-e-angermar nakwemai, degi, aidemai Dule-Machigi be dakoed. ");
INSERT INTO cuk09_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A-ibapaagwad-sorba Galilea-yargi, Caná-neggweburgi dule-wargwen ome-niku-sokalid. A-ibagi Jesús-e-nan sii-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","A-ibagi Jesússe, degi, e-sapinganse, dule-ome-niku-sokalid gochamogad, a-ibase dagegar. ");
INSERT INTO cuk09_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ibagi vino emarga galadgua, Jesús-e-nan Jesúsga sokar: —Vino emarga bergud. ");
INSERT INTO cuk09_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús, e-nan-abin sogded: —¿Omegwa, ibiga deyob be anga soge? An-ibagan amba yo warmaked. ");
INSERT INTO cuk09_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesús-e-nan, neg-ibed-e-maiganga sokar: —Jesús, ibi imakye bemarga sokalile, a-sogedba bela be imakmalo. ");
INSERT INTO cuk09_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Deun mete-akwa-gwanergwa dii-siega sii-gusad, ar igi Moisés-igar-mesisadba Judiomar na nudakega ebumala. A-mete-gwagwengi sunna galón-dulagwen-wilub, igi, galón-dulagwen-gakambe-wilub-dibe, dii siged. ");
INSERT INTO cuk09_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús maimarga sogded: —Bela metemar digi enomar. Bela nue-ena mete digi enosmarsun. ");
INSERT INTO cuk09_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Geb Jesús amarga sogdebar: —Emigi dii be wemar, dule-iba-sailaga-gusiidse be sedmar. Degi ase sesmarsun. ");
INSERT INTO cuk09_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iba-sailaga-gusiid dii-vinoga-binnisad gobsagua, dule-ome-nikusiidse gochad. Iba-sailaga-gusiid wichulid bia vino daniki. Ar maigandi wisdo, ar ade emar na dii wesmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Iba-sailaga-gusiid ome-nikusiidga sogded: —Bela dulemar vino-nued-insa mimmi-damalad, geb bukidargus-gobmalad-sorba vino-akusaaled mimmid-damalad. Ar bedi vino-nued sabos, geb be mimmialid. ");
INSERT INTO cuk09_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús we-ibmar-wilubgan-dakledisurmalad gebe Galilea-yargi, Caná-neggweburgi imaksa-gusad. Agi Jesús na e-gangued oyosad. Degine, e-sapingan Jesús-nue-bensuli-gunonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","We degi-gusad-sorbali, Jesús, e-nan, e-urbamar, degi, e-sapingan, Capernaumse nade-gusmalad. Agine, dogdar melu megissurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Deun Judiomar-iba, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba warmakdanikidgi, Jesús Jerusalénse nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jesús Bab-Dummadse-goled-negse dogdapgu, dulemar-moli-ukmalad, sibad-wawaad-ukmalad, degi, nuu-ukmalad, ukbukwa dakdapid, degine, dulemar agi-mani-ogwabukwa dakdapbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Degi Jesús ibmar-bibyoged-duba sobsagu, Bab-Dummadse-goled-neggi bela dulemar-ibmar-ukbukmalad-onosad, degi, sibad-wawaad, degi, molimar onisbalid, degine, dulemar-mani-ogwabukwad-e-mani midbalid, agine, e-mesamar ei obichabalid. ");
INSERT INTO cuk09_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesús dulemar nuu-ukbukmaladga sogded: —¡We-ibmarmar bela be sedmar, melle an-Bab-nega ibmar-ukleged-negga be imakmar! ");
INSERT INTO cuk09_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Degi Jesús-e-sapingan insad nadmalad, igi Bab-Dummad-Gardagi narmakar nai: Be-nega an bina nue soged-ular, nue egi nobe an itoged. ");
INSERT INTO cuk09_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judiomar Jesús-abin imakdemalad, abin-sogdemalad: —¿Ibi-ibmar-wilubgan-dakledisulid be anmarga imakosunna, adi anmarse oyogegar Bab Dummad bega igar-uksad weyob be ibmar imakegar? ");
INSERT INTO cuk09_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús, abin-imakde, emarga sogded: —We-Bab-Dummadse-goled-neg-siid be earmar, an ibapaagi gannar soboed. ");
INSERT INTO cuk09_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judiomar geb abin-sogdemarbar: —We-Bab-Dummadse-goled-neg birga-dulabo-gakanergwa soblenai-gusadde, emide, ¿bede ibapaagi gannar sobode? Geg be gue. ");
INSERT INTO cuk09_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ar Jesúsdi na e-sangi sunmaknaid, akwa-neg-sobaledgi sunmaknaisulid. ");
INSERT INTO cuk09_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ar degisoggu, Jesús burgwis gannar durgusgu, geb e-sapingan insaas-nadmalad we bato degi-sogsad. A-ular Jesús-e-sapingan Bab-Dummad-Gardagi narmakar naid, degine, Jesús-ibmar-sogsad, nue ulubgi abingasmalad, gwen bengussurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi Jesús, Jerusaléngi gudigu, ibmar-wilubgan-dakledisurmalad imaksadba, bukidar Jesús-bensuli-gunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ar Jesúsdi bela dulemar-daed wissoggu, dulemar-bengusad, ar ade wisid dulemar eba nue naisulid. ");
INSERT INTO cuk09_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesús dule-ega-ibmar-soged gwen abessulid, ar wisid dulemar ulubgi igi binsamala. ");
INSERT INTO cuk09_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Dule-wargwen Fariseo-sorda, Nicodemo-nugadi, a-dule Judiomar-abargi nue-nug-nikaa gudigusad. ");
INSERT INTO cuk09_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","We-dulede mutik Jesússe nonikid, ega sognonikid: —Rabí, odurdaked-saila-dummad, anmar wisid, be Bab Dummadgi danikid, dulemar-odurdakegar. Ar dule gege ibmar-wilubgan-dakledisurmalad imaked, we Bab Dummad eba gudisulir. ");
INSERT INTO cuk09_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús, Nicodemo-abin imakde, ega sogded: —Napira an bega soged, dule gannar gwalulesulile, gege Bab-Dummad-neg-dakmaid daked. ");
INSERT INTO cuk09_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo Jesússe egisdesun: —¿Ar igi dule-sered gannar gwalulegosunna? ¿Ar sunna gannar gwalulegega e-nan-nukugi gannar megosi? ");
INSERT INTO cuk09_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús, abin-sogde: “Napira an bega soged, ar dule digi, degi, Bab Dummad Burba Nuedgi gwalulesulile, gege Bab-Dummad-neg-dakmaidse doged. ");
INSERT INTO cuk09_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ar dule wegi-sanale gwalulesale, we sanaledgadid. Ar dule Bab Dummad Burba Nuedgi gwalulesardi, we burbaledgadid. ");
INSERT INTO cuk09_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Degisoggu, mer geg be itoge, an bega soged: Be gannar gwaluleger-gebye. ");
INSERT INTO cuk09_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Burwa-goledi e-itoledba goled, unnila e-goledbi be itoged. Bia burwa danikiddi be wichulid, degi, be wichurbalid, bia nadapbali. Deyobmodo, dule Bab Dummad Burba Nuedgi gwalulesar.” ");
INSERT INTO cuk09_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo, Jesús-abin sogde: —¿Wede igi nue gusunna? ");
INSERT INTO cuk09_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús, Nicodemo-abin sogde: “Bede Israel-dulemar-odurdaked-sailadde, ¿we-igar amba be aku itode? ");
INSERT INTO cuk09_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Napira an bega soged, anmar we-ibmar-wisidba sunmakmalad, anmar we-ibmar-daksadba an sogmalad, degite anmar ibmar-bega-sogedi yapa be abingamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ar ibmar-we-napneggined an bega sogsad, be benmalad, ar ¿igi be bengussurmalarsunna an bega ibmar-nibneggined sogdemalar? Be bengusmalaled. ");
INSERT INTO cuk09_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Dule nibnegse gwen nakwissulid, unnila Dule-Machibi nibneggi-mai aidenonikid. ");
INSERT INTO cuk09_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Igi Moisés nega-dule-sulidganba naibe-onakwis-gusa, debayobi, ani Dule-Machi, nakrusgi niba onailemogar-gebed. ");
INSERT INTO cuk09_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Adi doa-dule angi bengusulile, mer yogguega, adi burba-geg-bergued angi nikuegar.” ");
INSERT INTO cuk09_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Ar Bab Dummad bela we-napneggi-dulemar-bukwad nue sabgussoggu, E-Machi-Wargwenna-Guedi barmialid, adi dulemar-iskued-anar burgwegar. Ar doa-dule Bab-Dummad-Machigi bensuli-gunonikile, burba-geg-bergued nikuoed, adi mer bar degi-sadegu sabsur odurdaklesii-guegar. ");
INSERT INTO cuk09_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ar Bab Dummad we-napnegse na E-Machi-barmiargu, dulemar-we-napneggi-bukmalad sabsur-odurdakega barmiarsulid. Na E-Machi-barmialid, adi dulemar-we-napneggi-bukmalad na E-Machigi abonolemalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ar doa-dule Bab-Dummad-Machigi bensulile, we-dule sabsur odurdaklegosulid, ar dule benerdi, Bab-Dummad-Machi-Wargwennaa-Gued e-nuggi bengusad-ular bato adi sabsur-odurdakleged-igar ega megisdo. ");
INSERT INTO cuk09_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Bab-Dummad-Machi we-napnegse-nonikidba neg mee imaknonikid. Dulemar ibmar-iskana-imakmaladba, neg-sichid bur gwallu-meegwadba sabgusmalad. A-ular dulemar sabsur odurdaklegoed. ");
INSERT INTO cuk09_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","“Ar bela dulemar-ibmar-iskana-imakmaladi, gwallu-meegwad istar dakdamalad, gwalluse dagbisur-damalad, adi melle e-ibmar-iskana-imakdiid neg-meegwadse osanalolegegar. A sogledo, dulemar ibmar-iskana-imakmalad yapa Bab-Dummad-Machise dagdamalad, adi melle e-istar-daed mag daklegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","“Ar dule igar-napiragwad-imakdiiddina, gwalluse noni-damalad, adi na e-ibmar-imakdiid na oyogega, na Bab Dummadgi ibmar imakdiid.” ");
INSERT INTO cuk09_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A-sorbali Jesús na e-sapinganmala Judea-yalase nonimalad, agi undar gudigusmalad, Bab-Dummad-digi-ogleged-igar imaknai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Deun Salim-walik, Enón-neg-nugadgi, Juan-Bautista Bab-Dummad-digi-ogleged-igar imaknai-gusmogad, ar ade agi dii wilarbad. Dulemar Juan-Bautistase noni-gusmalad, Bab-Dummad-digi-oglegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ar ade deun amba yo Juan eskaryagi melleged. ");
INSERT INTO cuk09_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Agi Juan-sapingan Judiomar-ebo abin-abin imakarmalad, dule-swilidik-ibmar-imaked-igargi. ");
INSERT INTO cuk09_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","E-sapingan, Juanse nonimalad, ega sognonimalad: —Odurdaked-saila, dule Jordán-diwar-obakar beba gudigusad, egi nued be sunmaksad, a-dule Bab-Dummad-digi-ogleged-igar imaknaimogad, degine, dule-bukidar ese duurmaknadapmalad, degisoggu, be sordamar-sate guoed. ");
INSERT INTO cuk09_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan, e-sapingan-abin imakdegu, sogded: “Ar dule gege ibmar-abingaed, ar nibneggi ega ibmar danisulir. A sogledo, ani Juan, degi, Jesús, anmar anbobela, Bab Dummad anmar-barmiarye. Ar Bab Dummad soger, Jesús anba bur dule-dummad guoye, ar deyob guodo. ");
INSERT INTO cuk09_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ar bemar-sunnad an itosmalad, an sogsagu: Ani an Cristosur, andi unnila e-idu-barmilealidid, ega igar-mayegar. ");
INSERT INTO cuk09_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Ar dule ome-nikunaidyobdo, dule-ome-nikunaid, a-ome a-dule-omega gunonikoed. Ar machered-e-aidi, e-dikarba gwichid, unnila sui-e-sunmaked itogwichid, weligwar itogwichid, sui ibmar soggwichid. Ar an dule-ome-nikunaid-e-aiyobmogad, emigindi nue an weligwar itomosundo. ");
INSERT INTO cuk09_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesús bur nug-dungue-wilubbid, andi bur nug-bipii gue-wilubbid.” ");
INSERT INTO cuk09_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Juan-Bautista sogdebar: “Ar Jesús-nibneggi-danikid bela dulemargi obined. Dule-napneggineddi, unnila napnegginedid, napneggined-ibmarbi sunmaked. Ar dule-nibneggi-danikiddi bela dulemargi obined. ");
INSERT INTO cuk09_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","“We dule-nibneggi-danikid nibneggi-ibmar-daksadba, degi, nibneggi-itosadba, sunmaked, degite, dulemar a-dule-gwen-itobisurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ar dule, dule-nibneggi-danikid-sunmaked abingaele, we sognado, Bab-Dummad-ibmar-soged napiraye. ");
INSERT INTO cuk09_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ar Bab Dummad we-dule-barmiarsoggu, a-ular we-dule-nibneggi-danikid Bab-Dummad-gaya-burba sunmaked. Ar Bab Dummad na E-Burba-Nued ise-obinagwar uked, ise-wilubsaar uksulid. ");
INSERT INTO cuk09_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","“Ar Bab Dummad nue na Machi-sabsoggu, bela ibmar E-Machiga na uksasunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","“Ar doa-dule Bab-Dummad-Machi-bensuli-gunonikile, a-dule burba-geg-bergued nikuoed. Ar dule Bab-Dummad-Machigi bengunonikirdi, burba-geg-bergued gwen nikuosulid, agardi Bab Dummad dulemar-sabsur-odurdakoed-igar bato guar ega maid.” ");
INSERT INTO cuk09_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Dummad-Jesús wisguar, Fariseomar itoarmarye dulemar sogdimarye: “Jesús, Juan-Bautistaba bur-bule dulemar-Bab-Dummad-digi-ogleged-imakdiiye, degi, bur-bule sapingan-nikbarye.” ");
INSERT INTO cuk09_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Ar Jesús Bab-Dummad-digi-ogleged-igar imakdisulindo, e-sapingan imakdiinad.) ");
INSERT INTO cuk09_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","A-ular, Jesús Judeagi bangudsunnad, gannar Galilease nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ase naegala, Samaria-yargi naer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria-yalase, neggwebur-Sicar-nugad-dikarse Jesús nonisun, bia dad-Jacob na e-machi-Joséga nainu-uksad-walik. ");
INSERT INTO cuk09_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Agine Jacob-dia-akwisad siid. Jesús nanaedba yegussoggu, a-dia-dikarba sigisad, obunnogegar. Deun bato yoruku gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ome-wargwen, Samariagined, a-diase nonikid, dii suegar. Jesús a-omega sogded: —Anga be dii-gobed wis udage. ");
INSERT INTO cuk09_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ar ade Jesús-sapingan neggweburse naded, mas-bakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Judiomar, degi, Samaria-dorgan na geg sunmakmarsoggu, ome-Samariagined, Jesús-abin sogded: —¿Ibiga bede Judio-duledde, andi ome-Samariaginedidde, anse be dii-gobed egise? ");
INSERT INTO cuk09_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús, abin-imakdegu, ega sogded: —Ar Bab-Dummad-ibmar-uked be wisina, degine, doa-dule bega soge: ‘Anga dii-gobed be udaye,’ be ese dii egisoenad, degine, na e bega ukoenad, dii-burba-nikad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ome, Jesús-abin sogded: —Dummad, be dii-weed-ibmar sated, degine, dia-yaa matusurbalid, degite ¿igi be dii-burba-nikadi onogosunna? ");
INSERT INTO cuk09_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ar bede anmar-dad-Jacobba bur dummadsi? Anmar-dad we-dia anmarga uksad, we-dii na gobsad, e-mimmigan, degi, e-molimar, we-dii gobsamarmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús, ome-abin imakde, sogded: —Ar doa-dule we-dii-gobsa-dibe, gannar uku-uku itobaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ar dii-an-ega-ukoed gobsardi, bar gannar uku-uku itogosulid. Ar dii-an-ega-ukoeddi, dii napa-urba aryomaiyobi, e-ulubgi megoed, adi burba-geg-bergued nikuegar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ome Jesúsga sogded: —Dummad, we-dii be anga udage, adi melle gannar bar uku-uku an itogegar, degine, adi melle gannar bar wese dii an wedagegarbar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús, abin-sogded: —Be nae, be-suise be gornae, degi, gannar be dagbaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ome, abin-imakde, sogded: —An sui sated. Jesús, abin-imakded: —Nabir be soged: ‘An sui sateye.’ ");
INSERT INTO cuk09_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ar sui walatargus be nikued, emi sui be nikumaidi be-sui-sulid. Ar nabir be-sogsad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ome, Jesús-abin sogded: —Dummad, an be-dakgua, be Bab-Dummad-gaya-burba-berbeged an be-dakdo. ");
INSERT INTO cuk09_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Anmar-dadgan, Samaria-dulemar we-yargi Bab Dummadse gochamalad, e-nug odummogegar. Ar bemar-Judiomardi soged, Jerusaléngi, agi Bab Dummadse goler-gebye e-nug odummogegar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús omega sogded: —Omegwa, napira an bega soged, mer be an-bengu, ibagan dani, we-yarginsur, degine, Jerusalénginsurbar, be Bab Dummadse goloed e-nug odummogegar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Bemar-Samaria-dulemar wichurmalad, doase gornai e-nug odummogegar, anmar-Judiomardi wismalad, ar doase gornai e-nug odummogegar, ar ade dulemar-abonoleged Judiomargi danikid. ");
INSERT INTO cuk09_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ar ibagan danikoed, emigindi ibagan nonisunnad, dulemar Bab Dummadse gollalile, nue burbar, degi, napiragwadgi ese gormaloed e-nug odummogegar. Ar Bab Dummad dulemar-degi-ese-goled amidimogad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bab Dummad, burbaled. Ar dule Bab Dummadse goledi, burbar, degi, napiragwadgi ese gormogar-gebed. ");
INSERT INTO cuk09_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ome, Jesúsga sogded: —An wisi, yoedse Mesías, dule-wargwen barmiledagoye soglesad, Cristo-nugad nonikoed. A-Cristo nonikile, a anmarga bela ibmar sognonikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús, ome-abin sogded: —Ani an a-duled, bebo sunmaksiid. ");
INSERT INTO cuk09_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Agi e-sapingan nonikid, amar geger dakdemalad, Jesús, ome-ebo sunmaksiid, degi-inigwele, gwen ega sogsasurmalad: “¿Ibu omese be egissii? ¿Ibiga ome bebo sunmaksii?” ");
INSERT INTO cuk09_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Degi ome e-gwidu-mete neggweburse nadsunnad. Neggweburse modapgu, macherganga sogdapid: ");
INSERT INTO cuk09_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Be dagmar, dule-wargwen bela-an-ibmar-imaksad-anga-sogsad be dakdamar, ¿abakalegi we-dule Cristo-sua? ");
INSERT INTO cuk09_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Degi dulemar neggweburgi ainiarmargu, bela Jesússe nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Degi-gunaigua, e-sapingan Jesúsgi wilenai-gusmalad, ega sognai-guarmalad: —Odurdaked-saila, wis mas be gungwele. ");
INSERT INTO cuk09_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús, abin-sogded: —Andi mas-gunned an nikad, ar a-mas-gunnedi bemar wichurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Degi e-sapingan na ega muchub-muchub sokarmalad: —¿Ar dule-wargwen mas-gunned ega senoni-sua? ");
INSERT INTO cuk09_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús, abin-sogded: “Dule-an-barmialidba ibmar-imaked, degi, a-e-arbaed-obeloged, a an-mas-gunnedid. ");
INSERT INTO cuk09_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Ar bemarde sogsursi: ‘Amba nii-walabake napye ibmar-gwag-weed-iba?’ Andi an bemarga sogdo, nue be atakmar, nainu be dakmar, dulemar-bukidar-duurmakdanimalad, we-dulemar ibmar-gwagyobdo, weegala bato guagwar naid. ");
INSERT INTO cuk09_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Ar dule ibmar-gwag-weedgi arbaedi bennukledo, degine, ibmar-gwag-weoedi burba-geg-berguedga weoed, adi dule-ibmar-gwag-digedi, dule-ibmar-gwag-weed-ebo na wergumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","“Ar we-ibmar-sogleged nue-napira sogleged: ‘Dule-gwensak ibmar-gwag-diged, dule-baid, ibmar-gwag-wee-daed.’ ");
INSERT INTO cuk09_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","An bemar-barminanaid, bemar ibmar-gwaggi-arbassurmalad weega. Dule-baigan arbasmalad, bemar a-arbasadgi dogdemalad.” ");
INSERT INTO cuk09_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bukidar Samaria-dorgan, Sicar-neggweburginmalad Jesús-bengussurmalad, ar ade ome Jesúsgi sogdiid: “Bela an-ibmar-imaksad anga sogsaye.” ");
INSERT INTO cuk09_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Degine, bukidar Jesússe Samaria-dorgan duurmaknonimalad, egi wilenagusmalad: “Anmar-walik be beeye.” Amar-walik Jesús ibabo megissunnad, dulemar-odurdakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesús-ibmar-sogsadgi bur-ichesur Jesúsgi bengussurmalad, ome-ibmar-sogsadba. ");
INSERT INTO cuk09_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A-ulale omega sokarmalad: —Anmar-Jesúsgi-bensulidi unnila be anmarga ibmar sogedginsulid. Ar anmar-sunnad itosmarmogad. Anmar nue-wisid, we-dule napneggi dule-iskubukmalad-abonoged-sunnadid, we-dule Bab-Dummad-dule-wargwen-barmiledagoye-sogsad-duled. ");
INSERT INTO cuk09_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesús Sicar-neggweburgi ibabo megisad-sorbali, Samaria-yargi node-gusad, Galilease naegar. ");
INSERT INTO cuk09_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ar Jesús na e-sunnad sogsa-gusmogad: “Bab-Dummad-gaya-burba-berbegedi na e-neggweburgi geg e-nug odummoleye.” ");
INSERT INTO cuk09_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jesús Galilease nonigu, Galilea-dorgan nued abingasmalad, ar ade ibase arbimarmosoggu, agi daksamalad, igi Jesús Jerusaléngi ibmar imaksad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Degisoggu, Jesús gannar Galilea-yarse nonigu, Caná-neggweburse nade-gusad, bia dii vinoga obinnisadse. Deun Capernaum-neggweburgi dule-dummad, Reyga-arbaed-e-machi uelemaid. ");
INSERT INTO cuk09_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","We-dule itoargu, Jesús Judea-yarba-gudiid Galilea-yarse noniye, Jesússe nade-gusad. Jesúsgi wilenai-guar, adi e-machi ega nudaknaegar, ar ade e-machi burgwedani maid. ");
INSERT INTO cuk09_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús, abin-sogded: —Ibmar-wilubgan-dakledisurmalad, degi, ibmar-geger-daklemalad bemar daksasulina, be an-benmalanad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Dule-dummad, Reyga-arbaed, sogded: —Dummad, an-machi-burgwed-idu gwae anba be dage. ");
INSERT INTO cuk09_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús, abin-sogded: —Be nae, be-machi dula gudiid. Reyga-arbaed Jesús-degi-ega-sogsad gwen bengussulid. Degisoggu, na e-negse nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Negse monadapgu, e-maigan abin-noarmalad. E-dummad-abingusmargu, ega sogdemalad: —Be-machi bato nugus. ");
INSERT INTO cuk09_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Degi, dummad e-maiganse egichiar, igi-wachigi e-machi nuguarye. Abin-sogdemar: —Sae, wachi-irgwengi ueleged gichaye. ");
INSERT INTO cuk09_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Machigwa-e-bab mag itosad, a-wachigi Jesús ega sogsa-gusad: “Be-machi dula gudiiye.” Machigwa-e-bab, degine, bela e-negginmalad, Jesúsgi bensuli-gunonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesús Judea-yargi-gudiid Galilea-yarse nonigu, we-ibmar-wilubgan-dakledisulid ilabogus wegi-imaknonido. ");
INSERT INTO cuk09_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","We-ibmar degi-gusad-sorbali, Judiomar-iba nonikid. Agi Jesús Jerusalénse nonimogad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusaléngi, Sibad-Wawaadye-Yawagak-nugad-naba, dii-wilasar-naid, Hebreo-gayagi Betesdaye bileged. Agi neg-imba-dummagan-gwaatar siid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A-neg-imbamargi uelemalad-bukidar maimalad, ibya-surmalad, geg-nanamalad, bela-abgan-burgwarmalad. Amar dii-sukamaked edarbe mamaimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ar ade imbagwenar anger aidenoni-daed, dii-wilasar-naid osukamakegar. Ar doa-dule-insa a-dii-wilasar-naid sukamaksad-sorba aidesale, ibi-ueleged nik-dibe, yog nuguar-daed. ");
INSERT INTO cuk09_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Agine, machered-wargwen birga-dulagwen-gakambe-gakabaabakgus uelemaid mai-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús a-machered-meremai dakalid. Jesús wisguargu, we-machered dikasurgus uelemaiye, a-macheredga sogded: —¿Be nugubie? ");
INSERT INTO cuk09_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Dule-uelemaid, abin-imakde, sogded: —Dummad, dii-sukamaksad-sorba dule a-dise an-odeged sate daed, ar an-aideged-idu an-iduar bato dule aides-daed. ");
INSERT INTO cuk09_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús ega sogded: —Be gwisgu, be-egi-gabed na be sede, be nae. ");
INSERT INTO cuk09_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesús-degi-sogsad-sorba, dule yog nuguar naded, e-gabed na susa, nadsunnad. A-ibagi deun obunnoged-iba gued. ");
INSERT INTO cuk09_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Agi Judiomar dule-nugusadga sogdemalad: —Emi-ibagi obunnoged-iba naid, degisoggu, be-egi-gabed na be sededsulid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Dule-nugusad, abin-sogded: —Dule-an-nudaksad, ar a anga soged: ‘Be-egi-gabed na be sedye, be naye.’ ");
INSERT INTO cuk09_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Degi dule-nugusadse egisdemarsunnad: —¿Ar doa bega sogsa: ‘Be-egi-gabed na be sedye, be naye?’ ");
INSERT INTO cuk09_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ar dule-nugusad, wichulid, doa ega sogsa, ar Jesúsde bato dulemar-bukidar-gunanaid-abargi banguded. ");
INSERT INTO cuk09_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A-sorbali Bab-Dummadse-goled-neggi Jesús dule-nugusad-dakargu, ega sogded: —Be dake, be nugusad. Degisoggu, mer be bar iskuo. Degir, aka-bur-bule boni-dummad begi danikile. ");
INSERT INTO cuk09_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Dule-nugusad nade-gusad, Judiomar-owisodapid, Jesús e-onudaksaye. ");
INSERT INTO cuk09_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","A-ulale, Judiomar Jesús-bareginnarmarsunnad, oburgwebi-guarmalad, ar ade obunnoged-ibagi we-ibmarmar imakdiid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Degi Jesús, abin-sogded: —An-Bab gusgu arbanaiguad, degisoggu, a-ular an arbamosundo. ");
INSERT INTO cuk09_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","A-ulale Judiomar bur Jesús-oburgwebi-guarmalad, ar ade Jesús unnila obunnoged-ibabi biskedisulid, Bab Dummad na ebo emar imakdibalid, na sogsadba, Bab Dummad an-Bab-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús geb degi abin-imakdesun: “Napira an bemarga soged, Bab-Dummad-Machi gege na wargwengi ibmar imaked, unnila e-Bab-dakedba ibmar-imaked. Ar e-Bab bela ibmar-imakedi, E-Machi a sunnaa bela ibmar imakmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ar Bab na Machi-sabsoggu, ibmar-imakedi bela E-Machiga na oyoged. Ar weba bur-bule ibmar-dummagan Bab ega oyogoed, adi bemar bur-bule geger dakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ar igi Bab dule-burgwar-maid gannar oduloge, ega san-burba-dula-gued uke, amba E-Machi deyobmodo, ar doaga san-burba-dulad ukbie, ega ukodo. ");
INSERT INTO cuk09_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ar Bab emigi bar dulemarga igar-itogosulid, ar ade na E-Machiga we-igargan uksad, ");
INSERT INTO cuk09_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","adi bela dulemar E-Machi-nug ogannomogagar, ar igi E-Bab-nug oganno-damarmoga. Ar dule Bab-Dummad-Machi-e-nug odummosulile, E-Bab-nug odummosurmodo, ar ade Bab na E-Machi-barmialid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Napira an bemarga soged: Ar dule an-sunmakedba daele, degi, Bab-an-barmialidgi bengusulile, a-dule burba-geg-bergued nikuodo. A-dule bar sabsur odurdaklegosulid, ar burgwar-gudiidgi nosad, dula gudii-gunonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Napira an bemarga soged: Ibagan danikoed, emigindi ibagan nonisunnad, dulemar-burbar-burgwarmalad Bab-Dummad-Machi-e-gaya-burba itononikoed, ar dulemar-a-gaya-burba-itosmalad durgunonikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ar igi Bab na-dukin-na-dulad-nika gudii, amba deyob na E-Machiga na-dukin-na-dula-gued uksamogad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Deginbali, ar ade Dule-Machisoggu, amba ega igar-uksabalid, dulemarga igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","We-igar mer geger be itomar, ar ibagan danikoed, dulemar-neg-uangi-burgwar-mamaid, bela Bab-Dummad-Machi-e-gaya-burba-itomaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ar dule-ibmar-nued-imaksamalad gannar durgunonimaloed, burba-dulad nikuegar, ar dule-ibmar-iskana-imaksamaladdi, gannar durgunonimarmogoed, odurdakleged-negse naegar.” ");
INSERT INTO cuk09_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesús Judiomarga sogdebar: “Geg na dukin wargwen na ibmar imaked, unnila an-Bab-anga-sogedba an dulemarga igar-itoged. An-igar-itogedi, igar-napiragwadgi an itoged, ar wargwen an-itolegedba an ibmar-imaksulid, an-ibmar-imakedi, dule-an-barmialid-sogedba an ibmar-imaked, an-Bab-sogedba. ");
INSERT INTO cuk09_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ar an na dukin ibmar barsogele, an-ibmar-sogedi, igarga gussuliled. ");
INSERT INTO cuk09_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Emigindi dule-baid an-barsoged, a-ular an wisid, dule an-barsoged, napiragwadba an-barsogdiid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Bemar Juan-Bautistase dulemar-barmiar-gusmalad, egisega, be Mesías sogeye. Juan dulemar-abin imaksagu, napiragwadgi angi sogsa-gusad, ani an Mesíasye. ");
INSERT INTO cuk09_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ar we-napneggined-dulemar an-barsoged an amidisulid, degi-inigwele, we Juan-sogsad an bemarga sogmalad, adi bemar-abonolemalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ar igi acha-gwallu gummake, degine, mee-gae, ayobi Juan-Bautista gunonikid. Ar bemar unnila ichesaar a-gwallugine yeer-itodii-gudigusmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ar Juan angi sogdigusadba bur-bule an-ibmar-imakdiidba an bemarga oyonaid, an doa-dule gue. Ar arbaegala Bab arbaed anga uksad, ar arbaed an imakdiid, a bato oyonaid, Bab an-barmiarye. ");
INSERT INTO cuk09_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Deginbali, Bab-an-barmialid, bato angi sunmaksa-gusad. Bemardi bipisaale e-gaya-sunmaked be itodisurmalad, degine, e-dakleged be dakdisurmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Deginbali, Bab-gaya-burba bemargi gwen naisurbalid. Ar Bab na dule bemarse barmialidi, bemar a-dule-benmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bab-Dummad-Garda-narmakar-naid nue be baramimar, ar agi burba-geg-bergued baramilesiye be sogmalad. Ar a-Gardagi angi sunmaknaid, an doa-dule gue. ");
INSERT INTO cuk09_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ar degite anse bemar yapa dagmalad, adi burba-geg-bergued bemar nikuegar. ");
INSERT INTO cuk09_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Dulemar an-nug-odummoged, an abingasulid. ");
INSERT INTO cuk09_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ar an bemar-wisid, bemar Bab-Dummad-sabsurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","An-Bab-nuggi an bemarse nonikid, degite be an-abingasurmalad. Ar dule-baid na dukin e-nuggi danikoeddi, adi bemar a-dule-abingamaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Ar igi bemar Bab-Dummad-bensuli-gumalosunna, ar unnila na be muchub-muchub san-ogannodimalad, ar Bab-Dummad-unnila-wargwenna-guedgi nug-gangued-danikid bemar amisurmalad? ");
INSERT INTO cuk09_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Mer bemar binsamalo, ani an-Bab-asabin bemargi gwisgumaloye. Suli, dule bato nika bemargi-gwisgumaloed, Moisés. Ar a-dulegi bemar sogmalad, a-igar-mesisadgi anmar-nanaedba an nibnegse dogmaloye. Bemar-iskudimaladba a-Moisés bemargi Bab-Dummad-asabin gwisgumaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ar Moisés-ibmar-sogsad be bengusurmalana, be an-bensurmalando, ar Moisés-ibmar-narmaksad angi narmaksad. ");
INSERT INTO cuk09_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ar Moisés-ibmar-narmaksad be benmaladde, degite, ¿igi an-ibmar-sogedgi bensuli be gumalosunna? Be an-bengumaloe.” ");
INSERT INTO cuk09_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","We degi-gusad-sorbali, Jesús Galilea-mata-dummad-obakar nade-gusad. We-mata-dummad Tiberias-mataye-nugbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Dulemar-bukidar Jesúsba nade-gusmalad, ar ade ibmar-wilubgan-dakledisulid dule-uelemaladgi-imakdiid daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Agi Jesús yar-birse nakwisgu, e-sapinganmala agi sigdapmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Deun Judiomar-iba, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba bato omosad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús atakdegu, dakded, dulemar-bukidar ese nonimala. Agi Felipega sogded: —¿Wemar madu gunmalagar, wede bia anmar madu bakoe? ");
INSERT INTO cuk09_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Unnila binsa Felipe-wilubdakega Jesús weyob Felipega sogsa-gusad, ar edi na bato wisid igi imakoe. ");
INSERT INTO cuk09_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe, Jesús-abin sogded: —Dule-wargwen nii-walabaabak-arbana-bennukleged, a-manigi madu baklesale, amba unnisuliled, belagwapa wis madu bipi-bipi gunmalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Geb degi e-sapin-baid, Andrés, Simón-Pedro-e-urba, Jesúsga sogded: ");
INSERT INTO cuk09_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Wegi machigwa-wargwen cebada-madu-gwaatar wis sediid, degine, ua-burwigana wis ukabo sedibalid, degite, ¿ar wede unniosi, ar dule bukidarad? ");
INSERT INTO cuk09_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús degi sogded: —Nabir. Dulemar be urbemar. A-degi-gunanaidgine, gagan bukidar naid. Agi dulemar ambikusmargu, miliatar-wilub machergan mergu daklealid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús madu susgua, Bab Dummadga dog-nuedye sogsagu, e-sapinganga madu uke-uke imaksad. Geb e-sapingan dulemar-gagan-birgi-bukmaladga ukdemogad. Jesús amba deyob ua-imaksabalid, ar bule-mergu abemaladba ega uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bela dulemar immelesmargu, Jesús e-sapinganga sogded: —Bela gwabgusmalad be wemar, adi mer binsa mas milegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Cebada-madu-gwaataled bela guchamalad-sorba, gwabgusmalad wesmargu, garba-gwaambe-gakabo-mergu enosmar daklealid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ar dulemar Jesús-madu-gwaataled-omelosad-daksamalad, sogdemalad: —We inso Bab-Dummad-gaya-burba-berbeged we-napnegse-nonikoed-sunnadye. ");
INSERT INTO cuk09_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ar ise-ebipiar reyga-guega e-imakdanimalo, Jesús dulemar-daksagu, e-iduar yarse walagwen banguded. ");
INSERT INTO cuk09_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dad argwategu, Jesús-sapingan demar-gakase aidenonimalad igi ega Jesús-sogsa-gusadgii. ");
INSERT INTO cuk09_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Urgi nakwismargu, mata-dummad obakdemalad, Capernaumse. Deun bato neg nue mutikgusad, Jesúsdi e-sapinganse amba yo nonikid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ar burwa binnasur gormaisoggu, demar dunguded. ");
INSERT INTO cuk09_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jesús-sapingan kilómetro-atargus, igi, nergwagus gammimaladgine, dakarmalad, Jesús demar-birgi nanadani, e-urse warmakdani. Deyob dakarmargu, dobguarmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús na e-sapinganga sogded: —Ani an gudii, mer be dobgumar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Degi e-sapingan weligwar urgi Jesús-abingasmalad, degine, bia-na-nadapmaladse warmaksamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A-banedgine, dulemar-bukidar-Jesúsba-mata-obakar-gudimaladi dakarmalad unnila ur-wargwen-nai-gusadi, sate. A-urgi Jesús na e-sapinganba nakwissulid, unnila e-sapinganbi nade-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ur-baigandi Tiberias-neggweburgi-danimalad nagunonimalad, bia Dummad-Jesús Bab Dummadga dog-nuedye-sogsad-sorba madu-omelosad guchamaladgi. ");
INSERT INTO cuk09_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ar dulemar Jesús-daklesur dakargu, degi, e-sapingan satemoga, Jesús-amiegala, urgi nade-gusmalad, Capernaumse. ");
INSERT INTO cuk09_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dulemar mata-dummad-obakar Jesús-amismargu, ega sogdemar: —¿Odurdaked-saila, sana wese be noniki? ");
INSERT INTO cuk09_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús, abin-imakdegu, emarga sogded: —Napira an bemarga soged, be an-amimaladi, an-ibmar-dakledisulid-imaksadba be an-amisurmalad, ar bemar madu-immedik-guchadba be an-amimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mas-baisursunna-bergumaladga mer be arbamar. Be arbamar, mas anmarga burba-geg-bergued-uked-degi-sadeguoedga. Ar a-masdi sunna bemarga, ani Dule-Machi, an ukoed, ar agala Bab Dummad bato angi e-wilub nasiksad, we angi burba-geg-bergued nikumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Degi, Jesús-abin sogdemarsun: —¿Degite, igi an imakmalosunna Bab Dummadga ibmar-imakega? ");
INSERT INTO cuk09_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús, abin-imakde, emarga sogded: —Bab-Dummadga-ibmar-imaked wedo, Bab-Dummad-bemarga-na-dule-barmialidgi, mer agi be bengumar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jesús-abin sogdemalad: —¿Degite, ibi-ibmar-wilubgan-dakledisulid be anmarga imakosunna, adi anmar dakega, begi anmar mer benguega Bab Dummad be-barmialid? ¿Ibi-ibmar be imaksunna? ");
INSERT INTO cuk09_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","¿Bedi ibi anmarga ukosunna? Ar anmar-dadgan nega-dule-sulidgangi maná-guchamalad, ar Bab-Dummad-Garda sognaid: Ede dadganga madu-nibneggi-danikid uksaye, gunnegar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús amarga sogded: —Napira an bemarga soged, Moisés bemarga madu-nibneggi-danikid uksasulid, ar an-Bab madu-nibneggi-danikid-sunnad bemarga uked. ");
INSERT INTO cuk09_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ar Bab-Dummad-madu, we-dule-nibneggi-aidenonikid, we-napnegginmaladga burba-dula-gudiguedi uked. ");
INSERT INTO cuk09_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jesúsga sogdemalad: —Dummad, madu-degiid be anmarga ukdigu-sae. ");
INSERT INTO cuk09_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús, abin-sogded: “Ani an madu-burba-duladid. Ar dule anse danikile, bar gwen ukumesosulid. Ar dule an-bengusulile, bar gwen uku-uku itogosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Ar an bemarga epenne bato sogsamalad, ibmar-dakledisulid-imaksad be an-daksamar-inigwele, degite amba be an-benmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ar bela Bab dulemar-anga-ukedi, anse dagoed anba naguegar. Ar dule anse danikile, gwen an barmetosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","“Ar nibneggi an danikid, an-itoleged na ibmar-saega an danisulid. An nonikid, dule-an-barmialid-sogedba ibmar-imakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Bab-an-barmialid we abemaid: Bela dulemar-anse-nonikid gwen wargwensaar oyoggubisur an-abeged, adi ibagan-napi-naguoedgi a-dulemar an gannar odulogegar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","“Dule-an-barmialid we abemaid: Bela dulemar-E-Machi-dakedi, degine, egi bensuli-gunonikile, burba-geg-bergued nikuoed. Degine, ani, ibagan-napi-naguoedgi a-dule an odulogoed.” ");
INSERT INTO cuk09_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Degi Judiomar Jesúsgi sunmakedbi-guarmalad, ar ade Jesús sogsad: “Ani an madu-nibneggi-aidenonikidye.” ");
INSERT INTO cuk09_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Judiomar Jesúsgi sogdemalad: —¿Ar wede Jesússursi, José-machisursi, degine, e-bab, degi, e-nan anmar mag daksursi? ¿Ar degite ibiga sogsunna, nibneggi an aidenoniye? ");
INSERT INTO cuk09_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús amar-abin imakde, sogded: —Mer na be muchub-muchub angi istar sunmakmar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dule-wargwensaale gege anse daged, ar Bab-an-barmialid, a anse-dagega imaksulir, ibagan-napi-naguoedgi, ani an a-dule-odulogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bab-Dummad-gaya-burba-berbemalad-gardagi narmakar naid: Bab Dummad na e-igargi bela dulemar-odurdakoye. Is. 54:13 Degisoggu, bela Bab-itosmalad, degi, egi durdaksamarbalid, amar anse danimaloed anba naguegar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ar an sogsulid, dule-wargwensaar Bab-daksa-deeye. Suli, unnila dule-Bab-Dummadgi-danikid, abi unnila Bab-daksad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Napira an bemarga soged: Ar dule angi bengusulile, a-dule burba-geg-bergued nikad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","“Ani an madu-burba-duladid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ar be-dadgan nega-dule-sulidgangi maná guchamar-inigwele, amar bela burgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","“An bemarga madu-nibneggi-aidenonikidgi an sunmakedi, a-madu dule guchale, adi geg bar burgwed. ");
INSERT INTO cuk09_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ani an madu-duladid, nibneggi-aidenonikidid. Ar dule-wargwen a-madu guchale, bar burgosulid, degi-dula-sadeguoed. An madu-ukoedi, we an-sanad. An a-madu ukoed, adi we-napneg-naidgi dulemar-bukmalad dula gudiguegar.” ");
INSERT INTO cuk09_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Agi Judiomar na abin-abin imakarmalad, sogdemalad: —¿Ar wede anmar e-san-gunnega anmarga na e-san ukode? Adi surbali. ");
INSERT INTO cuk09_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús amarga sogded: —Napira an bemarga soged: Ar bemar Dule-Machi-e-san-gunsulile, degine, e-abe gobsurbalile, bemar burba-dulad-satemalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ar dule an-san gunnele, degi, an-abe gobele, a-dule burba-geg-bergued nikado, degine, ibagan-napi-naguoedgi, ani an a-dule-odulogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ar an-sana, mas-gunned-sunsogedid, degine, an-abe, gobed-sunsogedbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ar dule-an-san-gunmalad, degi, an-abe-gobmalad, anginbi gudigumalad, degine, an egi gudigumogad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ar igi Bab-dula-gudiid an-barmiali, degine, igi an Babgi an dula gudimoga, dule an-san guchale, deyob a-dule angi dula gudigumogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ar ani an madu-nibneggi-aidesadid. Be-dadgan-maná-guchadyobsulid, ar amardi burgwismalad. Ar madu-nibneggi-aidesadi, dule a-madu guchardi, adi burgosulid, degi-sadeguoed. ");
INSERT INTO cuk09_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús we-ibmar-sogsagusadi, Judiomar-onmaked-neggi sogsa-gusdo, deun Capernaumgi dulemar-odurdaksigusgu. ");
INSERT INTO cuk09_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bukidar-e-sapingan Jesús weyob-soge itosmargu, sogdemalad: —We-ibmar-sogedi gwen nollo sogsulid. Degisoggu, we deyob-sogedba, ¿ar doa eba ibsaoe? Anmar eba ibsaosurmala. ");
INSERT INTO cuk09_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ar Jesús na wissoggu, e-sapingan na muchub-muchub we-igargi sunmaknanaid, amarga sogdesun: —¿Ar we-an-bemarga-sogedi, be istar itomala? ");
INSERT INTO cuk09_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Degite, ¿igi be sogsamalarsunna, ar Dule-Machi nibneggi-bia-mai-gusadse gannar nakwemai be dakarmalar? ");
INSERT INTO cuk09_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ar Bab-Dummad-Burbabi dula gudigued uked, dule-sandi binsaledid. An-bemarga-ibmar-sogsadi, we burba-napiragwadid, degine, dula gudiguedbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ar bemar gwenna-gwennagwa an-benmalad. Ar Jesús bato gebesaila-akar wisid doamala e-benmala, degine, doa darba e-ukoe. ");
INSERT INTO cuk09_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús sogded: —A-ulale an sogsad, dule anba naguegala gege anse dagye, ar Bab anse sedasulir. ");
INSERT INTO cuk09_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Degidgine, bukidar e-sapingan Jesús-metemalad, bar Jesúsba gudigussurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Geb degi Jesús na e-sapingan-warambe-gakabogwadga sokar: —¿Ar bemar nabimarmoga? ");
INSERT INTO cuk09_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón-Pedro, abin-sogded: —Dummad, ¿doaba anmar naosunna? Ar bebi unnila igar-napiragwad nikad, dulemar burba-geg-bergued nikuegar. ");
INSERT INTO cuk09_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ar anmar begi bensulid, degine, anmar wisid, be Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duled, Bab-Dummad-Dula-Maid-E-Machi-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús, Pedro-abin sogded: —¿Ar warambe-gakabo an be-susmarsursi, ar bemar-gwensak niasursi? ");
INSERT INTO cuk09_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judas-Iscariote, Simón-e-machi, a-nik Jesús deyob sogsa-gusad, ar a-dule Jesús-darba-uknai-guoedid, e-sapingan-e-ambe-gakabogwad-wargwen. ");
INSERT INTO cuk09_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","We degi-gusad-sorba, Jesús Galilea-yalaganba bipirmakdii-gusad, ar ade yapa Judeagi gudigued, ar Judiomar e-oburgwebimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Deun Judiomar-iba bato mosadgined, Obunnoged-Neg-Sobarmalad-Ibagi. ");
INSERT INTO cuk09_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","E-urbamar Jesúsga sokar: —Wegi be node, Judease be nae, adi be-sapingan be-ibmar-imaked be-dakoed. ");
INSERT INTO cuk09_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ar dule-wargwen na mag-dakle imakbiele, geg odukuar ibmar-imaked. Ar ibmar-dakledisulid be imakdisoggu, bela dulemar-wagab be imakdo. ");
INSERT INTO cuk09_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","E-urbamar weyob Jesúsga sogsamardo, ar ade e-urbamarse-bakar Jesús-benmalad, we Mesíasye. ");
INSERT INTO cuk09_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Degi Jesús e-urbamarga sogdesun: —An Jerusalénse-naed-ibagan angardi amba yo moed, ar bemargardi ibagan bato gusgu guagwar-nai daed. ");
INSERT INTO cuk09_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ar we-napneg-naidgi-dulemar-bukmalad geg istar bemar-daked, andi istar an-dakmardo, ar andi ega sogdiid, be-ibmar-imakdimalad iskanaye. ");
INSERT INTO cuk09_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ar bemardi ibase namardo. Andi amba naosurgweled, ar yo angardi an-ibagan moed. ");
INSERT INTO cuk09_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Deyob e-urbamarga sogsagu, Jesúsdi na Galileagi bessun. ");
INSERT INTO cuk09_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesús-urbamar ibase naded-sorba, Jesús ibase nade-gusmogad. Jesús arbakee nade-gusad, emar-wagab nadsulid. ");
INSERT INTO cuk09_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ibagi Judiomar Jesús-amidii-guarmalad, sogdemalad: —¿Wede bia dule nade? ");
INSERT INTO cuk09_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Agine dulemar-bukidarad-abargi Jesúsgi uurmakarmalad, gwenna-gwenna sogdemalad: “We-Jesús, dule-nuedid.” Baigandi sogmarmogad: “Suli, we dule-yardakdiid-duled.” ");
INSERT INTO cuk09_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ar dulemar Judiomar-dummagan-dobedba, bakar-buud Jesúsgi gwen sunmaksasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ar Obunnoged-Neg-Sobarmalad-Iba negabar-gusgu, Jesús Bab-Dummadse-goled-negse nonikid, agi dulemar-odurdaksigusad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judiomar-dummagan geger Jesús-dakdemalad, sogdemalad: —Ar we-dule dummaganse-ibmar-gwen-durdaksasulid, ar degite, ¿ibiga ibmar-nue-wisi dulemar-odurdake? ");
INSERT INTO cuk09_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús amarga sogdesun: “An-ibmar-odurdaked angadsulid, Bab-Dummad-an-barmialid-sogedba an dulemar-odurdaked. ");
INSERT INTO cuk09_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ar Bab-Dummad-sogedba dule nanabiele, mag dakoed, an-ibmar-odurdakdiid Bab Dummadgi dani-dibe, igi, an-ibmar-odurdakdiid an na dukin onos-dibe. ");
INSERT INTO cuk09_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ar dule na wargwen e-sogedba ibmar sogdiile, unnila a-dule na dukin nug-dungued-amidiido. Ar e-barmialid-nug odummogega gudiirdina, adi we napiragwaddo, a-dulegine, gakan naisurdo. ");
INSERT INTO cuk09_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“¿Ar Moisés bemarga igar uksasursi? Degite a-igargi bemar nanadisurmalad. ¿Ibiga be an-oburgwebimarsunna?” ");
INSERT INTO cuk09_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Dulemar, Jesús-abin sogdemalad: —Nia begi nai. ¿Ar doamar be-oburgwebimala? ");
INSERT INTO cuk09_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús amarga sogded: “Ibmar-dakledisulid obunnoged-ibagi unnila gwennaa an imaksadde, degite ¿geger be an-dakmarde? Emide be sogmargu, an dule-iskanaye. ");
INSERT INTO cuk09_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés bemarga abgan-duku-siked-igar mesismalad. Ar Moisés bemarga uksasulindo, ar dadgan-akar-danikid. Obunnoged-ibagi bemar abgan-duku-siked-igar imakbukdo, igar-mai-inigwer, mer arbaoye. ");
INSERT INTO cuk09_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Melle Moisés-igar-mesisadgi annaegala, amba obunnoged-iba-dibe, bemar abgan-duku-siked-igar imakbukwad, degite, ¿ibiga obunnoged-ibagi dule an nudaksad, sae be an-dakmarsunna? ");
INSERT INTO cuk09_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dulemar-ibmar-imaked mer askinbi be dako. Nue igar-amisadgi geb be we-dulegi sogoed, we dule-nued-dibe, igi, dule-iskana-dibe.” ");
INSERT INTO cuk09_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Degi Jerusalénginmalad gwenna-gwenna sogdemalad: —¿Ar dummagan we-dule-amidimarsursi, oburgwemalagar? ");
INSERT INTO cuk09_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Emide be dakena, bela-dulemar-abargi sunmakgwisgu, degite, gwen ega akar sogsurmalad. ¿Ar dummagande nue mag itononimarsi, we, Cristo-sunnadid, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duled? ");
INSERT INTO cuk09_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","“Ar wedi anmar wisid, bia daniki, degisoggu, we-Jesús geg Cristoga gued. Ar Cristodi nonikile, anmar wisguosulid, bia danikid.” ");
INSERT INTO cuk09_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús Bab-Dummadse-goled-neggi dulemar-odurdaksigu, binnasur sunmakde, sogded: —Bemar mag an-dakmalad, degine, be an-wismarbalid an bialidi. An-itolegedba wargwen an danisulid, ar Bab Dummad an-barmialid, adi napiragwadid. A-duledi bemar aku-dakmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Andi a-dule mag an daked, ar agi an danikid, ar a an-barmialid. ");
INSERT INTO cuk09_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Agine, dummagan Jesús-gabi-guarmalanad, degite, bipisaale gwen gassurmalad, ar ade yo e-burgwed-ibagan omoged. ");
INSERT INTO cuk09_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Dulemar-bukidar Jesúsgi bengussurmalad, sogdemalad: —Bab Dummad sogsad, yoedse dule-wargwen an bemarga barmidagoye. A-dule nonikile, be insagua, ¿bur-bule we-dulebali ibmar-wilubgan-dakledisulid imako be insae? Gwen deyob imako an insasurdo. ");
INSERT INTO cuk09_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseomar itosmalad, igi dulemar Jesúsgi Mesíasye sunmaknanaid. Degisoggu, Fariseomar, degine, dule-irwa-Bab-Dummadse-gormalad-e-dummagan suar-ibmala-barmismalad, Jesús-gaegar. ");
INSERT INTO cuk09_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Geb Jesús dulemar-e-itobukwadga sogded: —Napi ichesaar an bemar-abargi gudiid, an naesokalid dule-an-barmialidse. ");
INSERT INTO cuk09_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Be an-amimalo-inigwele, gwen be an-amimalosulid. Ar bia an gudiguoedgine, geg ase be namalad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Degi Judiomar na ga sokarmarsun: —¿Ar wede bia naoe, anmarde bar amiosurmalad? ¿Ar wede Griego-dulemar-abargi-Judiomar-aisakis-bukmaladse naosi, Griegomar-odurdakegar? ");
INSERT INTO cuk09_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Wede ibi obarsunna, we sogsad: ‘Be an-amimalo-inigwele, gwen be an-amimalosurye. Ar bia an gudiguoedgine, geg ase be namarye?’ ");
INSERT INTO cuk09_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Napi-iba-naidgi, a-iba bur iba-dummadid, a-ibagi Jesús gwisgusgu, binnasur sunmakded, sogded: —Ar dule-wargwen uku-uku itodiile, anse dage, anse dii gobdado. ");
INSERT INTO cuk09_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ar dule an-bensulile, ar igi Bab-Dummad-Gardagi sognai, e-ulubgi diwar-burba-nikad aryomai-guoye. ");
INSERT INTO cuk09_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús sogsa-gusad, diwar-burba nikadye, we Bab Dummad Burba Nued dulemar-egi-benguosurmalad abingaoedgi sogsa-gusad. Ar ade amba yo Bab Dummad Burba Nued nonikid, ar Jesús amba yo bela-bela e-nug ogannoleged. ");
INSERT INTO cuk09_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Bukidar-dulemar weyob-Jesús-ibmar-soged-itosmargu, sogdemalad: —Ar we-dule, Bab-Dummad-gaya-burba-berbeged napiragwad-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Baigandi sogmalad: —We, Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-sunnadid. Degine, baiganmo sogmarmogad: —¿Ar ade Galileagi Cristode danikosi? Suli, agi daniko suli. ");
INSERT INTO cuk09_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Ar Bab-Dummad-Gardagi sognaisursi Cristo Davidgi danikoye, Belén-neggweburgi, bia David epenne gwalulesadgi? ");
INSERT INTO cuk09_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ar dulemar Jesús-ulale na muchub-muchub uludmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Degine, gwen-gwen Jesús-gabimalan-inigwele, gwen gassurgusmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Suar-ibmala-barmilesmalad gannar nonimalad, dule-irwa-Bab-Dummadse-gormalad-e-dummaganse, degi, Fariseomarse. Fariseomar ega sogdemalad: —¿Ibiga bemar Jesús-sedanisurmala? ");
INSERT INTO cuk09_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Suar-ibmala abin-imakdemalad: —¡Dule-wargwensaale weyob gwen sunmakdisulid, nue yeer sunmaked! ");
INSERT INTO cuk09_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Degi Fariseomar, abin-imakdemalad: —¿Ar bemar ese yardaklesmarmoga? ");
INSERT INTO cuk09_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ar bemar dakgua, dummagan, degine, Fariseomar, a-dulegi bensurmar be daksii? Benmala. ");
INSERT INTO cuk09_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ar dulemar-baigandi Moisés-igar-mesisad-wichurmaladba Jesúsba nagudmalad. Degisoggu, bato amar nue-ukabsales bukmarsundo. ");
INSERT INTO cuk09_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, Fariseomogadi, dule ibagwengi mutik Jesússe nonigusadi, e-sordamarga sokalid: ");
INSERT INTO cuk09_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿Ar anmar-igar-maidgi sunna dule-wargwenga amba yo igar-itoged-iduar bato soglesi, be dummad-nosye, degisoggu, bega sabsur odurdakleged-igar maiye? Suli, degisuli. ");
INSERT INTO cuk09_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Fariseomar, Nicodemo-abin imakdemalad: —¿Ar be Galileaginmogadi? Bab-Dummad-Garda-narmakar-naidgi nue be baramie, be dakodo, bipisaale Bab-Dummad-gaya-burba-berbeged gwen Galileagi danisulid. ");
INSERT INTO cuk09_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","((Degi dummagan na e-neg-e-negse nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Degi Jesús Olivos-yarse nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Banedgine, waidaryala Jesús Bab-Dummadse-goled-negse gannar nonigu, dulemar-bukidar ese nonimalad. Jesús sigisgua, dulemar-odurdaksigusad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Deun escribamar, degi, Fariseomar, ome-wargwen neg-sichigi-yolenai-galesad, Jesússe senonimalad. Dummagan dulemar-abargi ome-ogwisnonimargu, ");
INSERT INTO cuk09_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesúsga sogdemalad: —Odurdaked-saila, we-ome e-sui-sulid-ebo na neg-sichigi-yolenai gasmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Emi Moisés anmarga igar-mesisad, omegan-degimalad akwagi makoye, oburgwegar. Degite, bedina, ¿igi be sogmosunna? ");
INSERT INTO cuk09_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ar yamo Jesús-wilubdakegala Fariseomar ese deyob egichismalad, adi Jesúsgi sorba gwisgumalagar. Ar Jesúsdi, napase dulluu atakdegu, e-gogi napa narmak-narmak imaksigisad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ar Fariseomar Jesús e-abinsaegala ese egisnanai-guarmarsoggu, Jesús gannar nue sigisgu, abin-sogded: —Ar bemar-wargwen na be iskuedsuli-itogele, a-inse akwa omegi metagodo. ");
INSERT INTO cuk09_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús gannar napase dulluu atakdebargu, gannar napagi narmaksigisbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ar Fariseomar degi-Jesús-soge itosmargu, mag na ulubgi e-iskudiid itosmarsoggu, wargwen-wargwen ainidmalad, dummagan-inse, geb degi a-sorba yaigana. Geb Jesús unnila ome-negabargi-gwichid-ebo bessunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús gannar nue sigisbargu, dakdegu, dulemar sate, unnila omebi gwichi, omega sogded: —Omegwa, ¿bia dulemar-begi-gwisgunanaid nadmala? ¿Wargwensaar be-odurdakye sogsasurmala? ");
INSERT INTO cuk09_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ome, abin-sogded: —Dummad, dule-wargwensaar angi gwisgussulid. Degi Jesús omega sogdemosun: —An begi gwisguosurmogad. Be nae, mer be bar iskuo.)) ");
INSERT INTO cuk09_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Gannar Jesús dulemarga sunmakdebargu, sogded: —Ani an we-napneg-naid gwallu-meegwadid. Ar dule anba dagele, neg-sichidgi nanaosulid, gwallu-meegwad nikuoed, a-gwallu-meegwad burba-geg-bergued dulemarga uked. ");
INSERT INTO cuk09_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Degi Fariseomar Jesúsga sogdemalad: —Be-ibmar-sogedi, na be dukin barsogsoggu, a-ular be-ibmar-sogedi, geg anmar abingaed. ");
INSERT INTO cuk09_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús, Fariseomar-abin sogded: —Ar an-ibmar-sogedi, na dukin an sog-inigwele, an-ibmar-soged napiragwad an soged, ar an wisid, bia an daniki, degine, bia an nabaloe. Ar bemardi wichurmalad, bia an daniki, degine, bia an nabaloe. ");
INSERT INTO cuk09_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ar bemardi unnila we-napneg-igar-maidba sogmalad, we dule-iskanaye, igi, we dule-nuedye. Andi an sogsulid we dule-iskanaye, igi, we dule-nuedye. ");
INSERT INTO cuk09_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ar dule-wargwengi an sogele, igar-naboegalad, we deyob an imaked andi napiragwadba soged, we dule-nuedye, igi, we dule-iskanaye, ar wargwen an sogsulid, an-Bab-an-barmialid, a-anbo soged. ");
INSERT INTO cuk09_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Bemar-igar-maidgi sogmaid, dule-warbo barsoged-nikale, we napiragwadye abingalegoye. ");
INSERT INTO cuk09_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ani an-ibmar-sogedi, an na dukin angi an soged, degine, Bab-an-barmialid, angi sogmogad. Degisoggu, an-ibmar-sogedi napiragwaddo. ");
INSERT INTO cuk09_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Degi Jesúsga sogdemarsun: —¿Bia be-Babde maisunna? Jesús, dulemar-abin sogded: —Aku be an-dakmalad, degine, an-Bab aku be dakmarbalid. Ar mag be an-dakmalana, an-Bab mag be dakmarmogando. ");
INSERT INTO cuk09_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Weyob Jesús sunmaksa-gusad, deun Bab-Dummadse-goled-neggi, mani-weleged-naba-sii dulemar-odurdaksigu. Dule-wargwensaale gwen Jesús-gassurmalad, ar ade amba yo e-galeged-wilub omoged. ");
INSERT INTO cuk09_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús gannar Judio-dummaganga sogdebalid: —An naesokar. Be an-amimalo-inigwele, be an-amimalosulid. Bemardi be-iskuedgi na be burgwemaloed. An-bia-naedse, geg bemar ase warmaked. ");
INSERT INTO cuk09_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Degi Judio-dummagan sogdemar: —¿Ar ede na dukin oburgosi? Ar soged: ‘An-bia-naedse, geg bemar ase namarye.’ ");
INSERT INTO cuk09_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús amarga sogded: —Bemar we-napnegginedid, andi nibnegginedid. Bemardi we-napnegginmaladid, andi we-napnegginedsulid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A-ular an bemarga sogsa-gusmalad, be-iskuedgi na be burgwemaloye. Ar be an-abingasurmalale an doa, na be-iskuedgi be burgwemalodo. ");
INSERT INTO cuk09_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Judio-dummagan Jesúsga sogdemarsun: —¿Ar be doa-sunna? Degi Jesús, abin-sogded: —Ar iduar bato an bega sogsamalad, an doa-dule. ");
INSERT INTO cuk09_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Emi bemar-noar-nanadiidbali ibmar-bukidar an bemargi-soged nikad. Ar dule-an-barmialiddi napiragwadbi ibmar soged. Andi, an a-itosadba, we-napneggi-bukmaladga an sogdimogad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ar Judio-dummagan aku itosmalad deun Jesús sogsa-gusgu, an-barmialidye. E-Babgi ega sunmaked. ");
INSERT INTO cuk09_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Degi Jesús sogdebar: —Ar ani Dule-Machi, bemar nakrusgi-biokegala niba an-onakwismalale, geb bemar wisgunonimaloed, an doa-dule, degine, an-itolegedba an ibmar-imakdisulid. Ar an-Bab an-odurdaksadba, deyob an sunmakdiid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ar an-Bab-an-barmialid anba gudiid, wargwen an-metedisulid, ar ade an bela-ibmar-imakedi, an-Bab-nabir-itogedi an imaked. ");
INSERT INTO cuk09_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús weyob sunmakedba, bukidar egi bensuli-gunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús Judiomar-egi-bengussurmaladga sogded: —Ar bemar an-gaya-burba-sunmakedgi nue eba nanaele, nue bemar an-sapingan-sunnadga gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Degine, bemar igar-napiragwad wisgunonimaloed, degine, igar-napiragwad iskuedgi bemar-ollorsanonikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Judiomar, Jesús-abin sogdemalad: —Anmar Abraham-e-wagan gumalad, anmar aimar-maiga gwen gudisurmalad, degite, ¿ibiga be anmarga sogsunna: ‘Bemar ollorgunonikoye?’ ");
INSERT INTO cuk09_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús, abin-sogded: —Napira an bemarga soged, dulemar-iskuedgi-gudimaladi, we-iskuedse mailedimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Dule-maiga-arbaedi geg neg-yagi gudigu-sadeguad. Ar neg-ibed-e-mimmirdi neg-yagi gudigu-sadeguodo. ");
INSERT INTO cuk09_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Degisoggu, ar Bab-Dummad-Machi iskuedgi be-onononikir, geb be nue-napiragwad ollorgumaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","An wisi bemar Abraham-wagan gumalad, degi-inigwele be an-oburgwebimalad, ar ade an-ibmar-sogsad be abingasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","An-ibmar-sogedi an-Bab-walik an ibmar-daksadba an sunmaked, ar bemardi be ibmar-imakedi be-bab-ibmar-itosadba be imakmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Judio-dummagan Jesús-abinsadmargu, sogdemalad: —Abraham anmar-dadad. Jesús, abin-sogded: —Bemar Abraham-wagan-sunnadina Abraham-ibmar-imaksadyob bemar ibmar-imakdimarmoganad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ar Bab-Dummadgi-an-ibmar-napiragwad-itosad an a bemarga sogsad-ular, emigindi be an-oburgwebimalad. Dad-Abrahamdi gwen deyob gussulid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ar bemardi be-bab-Satanás-ibmar-imaked be imakmalad. Degi Judiomar Jesúsga sogdemalad: —Anmar dule-neg-sichigi-gwalulesad-surmalad. Anmar bab-nika-gwalulesmalad, Bab Dummad anmar-babad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Degi Jesús amarga sogded: “Ar Bab Dummad bemar-babana, be an-sabmalando, ar Bab-Dummad-akar an danikid, degine, agi wese an nonikid. Ar na dukin an-itolegedgi an danisulid, Bab Dummad an-barmialid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ibiga nue-akusunna an-ibmar-soged be itomala? Ar ade an-ibmar-soged be itobisurmaladba, be aku itomalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ar nia-saila bemar-babad, degine, be-bab-ibmar-abegedba be damalad. Ar gusgu, gebesailaunni nia-saila dule-gindakedid, degine, igar-napiragwadgi banguded, ar igar-napiragwad nia-sailagi naisulid. Ar nia-saila gakansaar sunmakdele, gusgu na e-daedba sunmaked, ar ade gusgu gakansaerbad, degine, dulemar-gakansaed-e-babad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ar andi ibmar-napiragwad sogsoggu, a-ulale be an-abingasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“¿Ar doa-dule angi sogoe, an iskudiiye? Ar igar-napiragwad an sogele, degite, ¿ibiga be an-abingasurmarsunna? ");
INSERT INTO cuk09_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ar dule Bab Dummadgadile, Bab-Dummad-gaya-burba sunmaked itoged. A-ulale, bemardi Bab-Dummad-gaya-burba-itosulid, ar bemar, Bab Dummadgadsulid.” ");
INSERT INTO cuk09_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Degi Judiomar Jesús-abinsadmalad, ega sogdemalad: —Ar anmar nabir sogmalad, be Samaria-dulemar-iskanayobmogad, degine, nia begi naid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús, abin-sogded: —Nia angi naisulid. An-Bab-nug bur an odummodiid, bemardi an-nug-ichodimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","An na dukin nug-odummoged an amidisulid. Ar dule-wargwen an-nug-odummoged maid, a sogoed, an dule-nued-dibe, igi, an dule-iskana-dibe. ");
INSERT INTO cuk09_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Napira an bemarga soged, an-gaya-burba-sogedba dule daele, we-dule burgosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Degi Judiomar Jesúsga sogdemalad: —Emigindi anmar nue wisdo, nia begi naid. Abraham, degi, Bab-Dummad-gaya-burba-berbemaladdi burgwismalad, emide bedi soged: ‘Ar dule-wargwen an-gaya-burba-sogedba daele, burgwed itogosurye.’ ");
INSERT INTO cuk09_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ar bede anmar-dad-Abrahamba bur dummasi? Ar dad-Abrahamdi burgwisad. ¡Bab-Dummad-gaya-burba-berbemalad burgwismarmogad! ¿Ar be doaye na sogsunna? ¿Ar be-bur amarba bur dummadsi? ");
INSERT INTO cuk09_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús, Judiomar-abin sogded: —Ar na dukin an na san-odummogele, an na san-odummogedi, binsaleddo. Bab Dummad bemar-Bab-Dummadye be sogmalad, a-Bab-Dummad an-Babad, a an-nug odummoged. ");
INSERT INTO cuk09_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Bemardi a-Bab-Dummad-aku-dakmalad, andi a-Bab-Dummad-mag-daked. Ar bemarga an sog-dibe, a-Bab-Dummad aku an dakye, bemar-sunnaa an gakansasmogardo. Andi a-Bab-Dummad mag an daked, degine, e-gaya-burbaba an nanadibalid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Anmar-dad-Abraham, an-danikoed-dakoedba weligwar itosad. An-nonikid daksagu, geb agi nue-weligwar itononisunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Degi Judiomar ega sogdemalad: —Amba be birga-dulabo-gakambe niksulidde, ¿degite, Abraham be daksade? Be daksasuli. ");
INSERT INTO cuk09_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús, abin-sogded: —Napira an bemarga soged, amba yo Abraham gwalulege, bato ani an gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Degi Judiomar akwa gadebinmalad, akwagi Jesús-makegar. Jesúsdi emar-idu dukusad, degi, Bab-Dummadse-goled-neggi nodsunnad. Degi emar-abargi nodgu, nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús nadapgu, machered-wargwen gusgu muu-neggi ibya-suli-gwalulesad dakalid. ");
INSERT INTO cuk09_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesús-sapingan Jesússe egichiarmalad: —Odurdaked-saila: ¿Ar we doa-iskusadba ibya-suli gwalulesa? ¿E-babgan iskusa, igi, ar na e iskusa? ");
INSERT INTO cuk09_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús na e-sapingan-abin sogded: —We, degine, e-babgan, amar iskussurmalad. We ibya-suli-gwalulesad, adi Bab-Dummad-ibmar-imaked we-dulegi oyolegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Igi dulemar ibgi arbae, ar mutik nonikir, geg dule bar arbaed. An deyobmodo, amba ibgi ibagan-naidgi dule-an-barmialid-arbaed an imaker-gebed. Ar an bemargi bangudogu, mutikidyob guoed, bar an ibmar-imakosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ar emigi we-napneggi an gudiidgi, ani an we-napneggi-dulemar-bukwadga igar-napiragwad oyonaid, gwallu-meegwadyob an gued. ");
INSERT INTO cuk09_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesús degi-sogsad-sorba, napagi wiaksagu, napa olli-olli wiigi imaksad, degine, e-gogi olli-ollid wesgu, dule-ibyagi mage-mage imaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Geb degi Jesús dule-ibya-sulidga sogded: —Dii-wilasar-naidse, Siloé-nugadse be ibya na enukna. (Siloé sogleged, Barmilenaid.) Degi dule-ibya-sulid nadsun ibya enukega. Ibya enuksagu, nonikid bato sunna mag-atake. ");
INSERT INTO cuk09_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","E-neg-dikarba-mamaid, degine, dule-ibya-suli-gudidaed-mag-dakmaladi sogdemalad: —¿Ar we dule-ibya-suli, degine, wilegedi, mani aimarse egisdidaedsursi? ");
INSERT INTO cuk09_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abar sogmalad: —We a-duleye. Baigandi sogmarmogad: —Surye, binsa we sunnaa dakleye. Degi, na e-ibeddi soged: —Ani an a-duleye. ");
INSERT INTO cuk09_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ese egichiarmarsunnad: —¿Igi nabir mag be atakgusa? ");
INSERT INTO cuk09_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Dule-nugusad, abin-imakdegu, sogded: —Dule-wargwen, Jesús-nugadi, napa olli-olli imaksad, an ibyagi mage-mage imaksabalid, geb degi anga sokalid: ‘Siloése be nae, be ibya enukna.’ Agi an ase nade-gusad, an-ibya an enuksad, geb degi mag-atak an gunonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Geb degi ega sogdemalad: —Ar degite, ¿bia Jesús nadsunna? Dule-nugusad abin-sogded: —An wichuli, bia Jesús nade. ");
INSERT INTO cuk09_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Fariseomarse dule-ibya-suli-gudigusad senonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Deun obunnoged-ibagi Jesús napa olli-olli imaksa-gusad, dule-ibya-sulid a-ibagi onudaksa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseomar dule-ibya-suli-gudigusadse egisdemarmogad: —¿Igi nabir be ibya nugusa? Dule-nugusad, abin-sogded: —Jesús an-ibyagi olli mage-mage imaksad, degi, ibya an enuksagu, mag-atak an gunonikid. ");
INSERT INTO cuk09_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Degi abar Fariseomar sogdemalad: —We-dule Bab Dummadgi danisulid, ar ade we-dule obunnoged-ibagi dule-nudaksad. Fariseo-baigandi sogmalad: —¿Ar dule iskudiile, we sunna ibmar-wilubgan-dakledisurmalad imakosi? Suli, geg imake. Na Fariseomar abin-abin imakarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Degi Fariseomar gannar dule-ibya-suli-gudigusadga sokarmalad: —Dule-bega-ibya-nudaksadgi ¿igi be sogmosunna? Dule-nugusad, abin-sogded: —Andi an soged, we Bab-Dummad-gaya-burba-berbeged-duleye. ");
INSERT INTO cuk09_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ar Judiomardi we-dule-ibya-suli-gudigusad, ibya-emigindi-nikusad benmalad. A-ular dule-ibya-suli-gudigusad-e-babganse gochamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ese egisdemalad: —¿Ar we be-machi-sunnadi, we ibya-suli gusgu gwalulesadi? ¿Ar degite ibiga emigindi nabir ataksunna? ");
INSERT INTO cuk09_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","E-babgan sogdemalad: —Anmar wisi, we anmar-machid, ibya-suli gwalulesad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ar emigindi mag-atakeddi an wichurmalad, ibiga nabir mag-atake. Anmar wichurbalid, ar doa ega nabir ibya nudaksa. Ar bato dummadsoggu, ese be egismar, na e bemarga sogoed, doa ega ibya nudaksa. ");
INSERT INTO cuk09_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Dule-ibya-suli-gudigusad-e-babgan Judiomar-dummagan-dobedbali weyob sogsagusmardo, ar ade Judio-dummagan bato igar-itosmalad, ar dule-wargwen sog-dibeye Jesús we-dule-Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duleye, Judiomar-onmaked-neggi onomaloye. ");
INSERT INTO cuk09_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","A-ulale dule-ibya-suli-gudigusad-e-babgan sogsa-gusmalad: “Bato dummadsoggu, ese be egismar, doa e-onudaksa.” ");
INSERT INTO cuk09_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Degine, Fariseomar dule-ibya-suli-gudigusadse gannar gochamargu, ese egisdemalad, ega sogdemalad: —Bab-Dummad-asabin napiragwadba be anmarga sogmalo igi be nugusa. Anmardi wismalad we-dule, dule-iskanad. ¿Bedi igi be sogmosunna? ");
INSERT INTO cuk09_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Degi, dule-nugusad, abin-imakdegu, sogded: —An wichulid, we dule-iskudiid-dibe. Unnila ibmar-soggwennaa an wisid, iduardi aku an atakenad, emigindi mag an ataked. ");
INSERT INTO cuk09_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Fariseomar gannar dule-ibya-suli-gudigusadse egichiarmarbalid: —¿Igi-be-imaksa? ¿Igi nabir bega ibya nudaksa? ");
INSERT INTO cuk09_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Dule-nugusad, abin-sogded: —Ar bato bega an sogsamalad, be an-itosurmalad. ¿Degite ibiga gannar be itobimarsunna? ¿Ar bemar e-sapinganga gubimarmosi? ");
INSERT INTO cuk09_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Fariseomar dule-ibya-suli-gudigusadse uluarmalad, ega sogdemalad: —Bedi Jesús-e-sapindo, anmardi Moisés-e-sapinganmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Anmardi wisid, Bab Dummad Moisésga sunmaksad, we-duledi, anmar wichulid, bia daniki. ");
INSERT INTO cuk09_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Dule-ibya-suli-gudigusad abinsadgu, sogded: —¡Ar deyobi! ¡We ibmar nue aku-itolegeddo, bemardi wichurmalad we-dule bia daniki, degite angardi ibya nudaksad! ");
INSERT INTO cuk09_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ar anmar wisid, Bab Dummad dule-iskudimalad ese gollalile, itosur-daed. Ar dule-wargwen Bab-Dummad-dobee nanadiirdi, degine, Bab-Dummad-sogedba ibmar imakdiirdi, Bab Dummad a-dule ese gollalile, adi ito-daed. ");
INSERT INTO cuk09_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ar bipisaale, gebe-negasailaunni, gwen itoledisulid, dule-gusgu-muu-neggi ibya-suli gwalulesad, dule-wargwen a-dulega ibya nudaksa-deeye. ");
INSERT INTO cuk09_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We-Jesús Bab Dummadgi danisulina, gege deyob ibmar imakenad. Ar emigindi deyob ibmar-imakdisoggu, we-Jesús Bab-Dummad-akar danido. ");
INSERT INTO cuk09_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Fariseomar abinsadmargu, ega sogdemalad: —Be dule, be iskuedgi gwalulesadde, ¿be anmar-odurdakde? Be anmar-odurdakedsulid. Degi, Judiomar-dummagan dule-ibya-suli-gudigusad, Judiomar-onmaked-neggi onosmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús itoargu, Fariseomar Judiomar-onmaked-neggi dule-ibya-suli-gudigusad-onosmarye, Jesús a-dule-amisgu, ega sogded: —¿Bab-Dummad-Machigi be bensuli? ");
INSERT INTO cuk09_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Dule-nugusad, abin-imakdegu, sogded: —Dummad, ¿doa-dule-sunna, adi an mer egi benguegar? ");
INSERT INTO cuk09_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús, abin-sogded: —A-dule be daksad, bebo sunmakgwichid, ani an Bab-Dummad-Machid. ");
INSERT INTO cuk09_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Dule-ibya-suli-gusad, abin-sogded: —Dummad, an begi bensulid. Geb degi yokorgi sindigar Jesús-abin sigisgu, igi Bab Dummadse gollege e-nug odummogegar, deyob Jesús-nug odummodmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús sogded: —We-napnegse an nonigu, dulemar bachik-bachik-urbega an nonikid. Dulemar-aku-atakdimalad mag-atak saegar, degi, dulemar-mag-atakdimalad, aku-atak imakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Degine, Fariseomar-gwenna-gwenna Jesús-walik gwichimalad, Jesús degi-soge itosmargu, ega sogdemalad: —¿Ar anmarmode, aku atakmarmosi? ");
INSERT INTO cuk09_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús, amar-abin sogded: —Bemar aku atakena, be iskued surmalanad. Emigindi bemar soged: ‘Bab-Dummad-igar-maid nue mag an dakmarye,’ degisoggu, a-ular be-iskued begi nanaimarsundo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús sogdebar: “Napira an bemarga soged: Ar sibad-wawaad-galu-emakaled-yawagakgi dule dogsulile, yarganba dukuar dogele, we-dule sibad-wawaad-atursaeddo, degi, dule-atursili-sunnaddo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ar dule yawagak-siidgi dogerdi, we-dule sibad-wawaad-e-ibed-sunnaddo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","“Yawagak-daked we-dulega yawagak-egaogu, sibad-wawaad na e-edarbed gaya-burba mag itoged. Sibad-wawaad-edarbed e-sibadse na nugar-nugar gordo, degine, galu-yaba-bukwad onogodo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sibad-wawaad-edarbed bela e-sibad-wawaad na onisale, na e idunadap-daed. Sibad-wawaad eba nadapmalodo, ar ade na e-edarbed-e-gaya-burba mag itomalad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ar e-edarbedsulidbardi naosurmalad, aka bur e-idu duurmakdemaloed, ar ade e-gaya-burba aku-itomalad.” ");
INSERT INTO cuk09_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús weyob dulemarga odukuar-ibmar-sogsadi, aku-ito-gusmalad, ibi ega obarisa. ");
INSERT INTO cuk09_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús gannar emarga sogdebarsun: “Napira an bemarga soged: Ani an sibad-wawaad-galu-emakaled-e-yawagak-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Dulemar-odurdakega an-idu-nonimalad, amar atursamaladid, degi, gandikidgi-atursamalad. Sibad-wawaad amar-gaya-burba itossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ani an yawagak; ar dule angi dogele, a-dule abonolegoed, degi, dogogua, gannar nobaloed, degine, angi mas-gunned amioed. ");
INSERT INTO cuk09_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Dule-atursaed danikile, sibad-wawaad-atursaegalad, oburgwegalad, degine, osulogega unnila nonidamalad. Andi an nonigua, burba-dula-gudigued ukega an nonikid, degine, bela ulubgi yeer-itodii guegar. ");
INSERT INTO cuk09_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ani an sibad-wawaad-edarbed-nuedid. Sibad-wawaad-edarbed-nued e-san-burba, sibad-wawaad-ular na uked, e-anar burgwegar. ");
INSERT INTO cuk09_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","“Ar sibad-wawaad-edarbed-nuedsuliddi, unnila bennuklegega-arbaeddi, sibad-wawaad-egadsulidba, achu-burburud danikir, sibad-wawaad-mete idu nad-daed. Degisoggu, achu-burburud sibad-wawaad-ganonikogu, sibad-wawaad-oduurmaksundo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Degisoggu, dule-manigi-arbaed wakite-daed, ar ade unnila bennuklegega arbaed, degisoggu, sibad-wawaad baisur daksundo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ani an sibad-wawaad-edarbed-nuedid. An-sibad-wawaad mag an na daked, degi, mag an-dakmarmogad, ");
INSERT INTO cuk09_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","igi Bab nue an-wisi, deyob an Bab-wismogad. Degine, an-san-burba an-sibad-wawaad-ular an na uked, e-anar burgwegar. ");
INSERT INTO cuk09_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Sibad-wawaad-baigan an nikbalid, we-galu-yabalidsulid, ainebalidid. Amar anse an sedamogar-gebed, amar an-gaya-burba-itomaloed. Unnila sibad-wawaad dangwennaa guoed, degine, e-edarbed wargwennaa gubaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Burgwega an-san-burba an uked, adi gannar an subaligar. A-ulale, Bab nue an-sabed. ");
INSERT INTO cuk09_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Gege dule an-san-burba angi sued, ar ade an-sunnad na wargwen na uked. Ar ani gangued an nikad na an-san ukega, degi, an na gannar subaligar. We-igar an-Bab anga-uksadba an imaked.” ");
INSERT INTO cuk09_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ar Jesús-wegi-sogsad-ular Judiomar na muchub-muchub abin-abin na imakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bukidar Jesúsgi sogdemalad: —We nia-nika gudiid, we akargualid: ¿Ar ibiga be itomala? Mer be itomala. ");
INSERT INTO cuk09_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Baigandi sogmogad: —We-ibmar-sogedi, we nia-gayasulid. ¿Ar niade sunna dule-ibya-surmaladga ibya nudaksi? Suli, degisuli. ");
INSERT INTO cuk09_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Deun Jerusaléngi Bab-Dummadse-Goled-Neg-Gannar-Nudaklesad-Iba naid. A-ibagangine, di-wied-nii yoid. ");
INSERT INTO cuk09_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Deun Jesús Bab-Dummadse-goled-neg-ubebba, Salomónye-nugadsik, bipirmakdiid. ");
INSERT INTO cuk09_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Judiomar bela Jesús-ebilis ambikusmargu, ega sogdemalad: —¿Bule-sui undar yoote be anmar-obinsa imakmaloe? Ar be Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dulele, anmarga bakar be soge. ¿Ar be Cristo-sunnadi? ");
INSERT INTO cuk09_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús, amar-abin sogde: —Ar bato an bega sogsamalad, bemar an-itobisurmalad. An-Bab-nuggi ibmar-saedi, a bemarga sognaid, an doa-dule gue. ");
INSERT INTO cuk09_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ar bato an bemarga sogsamaladyob, ar bemar an-sibad-wawaadsursoggu, a-ular be an-itosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","An-sibad-wawaad an-gaya-burba mag-itomalad, mag an daked, degine, anba nad-damalad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ani an burba-geg-bergued ega uked, bipisaale amar gwen berguosurmalad, degi-sadegumaloed, degine, bipisaale dule gege angi an-sibad-wawaad sued. ");
INSERT INTO cuk09_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","An-Bab sibad-wawaad-anga-uksadi, a-Bab bela dule, degi, niamarba bur dummad, degine, bipisaale dule-baid gege an-Babgi an-sibad-wawaad sued. ");
INSERT INTO cuk09_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ani, degine, an-Bab, anmar wargwenna gumalad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Degi Judiomar gannar akwa susmalad, Jesús-makegar. ");
INSERT INTO cuk09_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús Judiomarga sogded: —Ibmar-nuegan-bukidar an-Bab-nuggi an bega oyosmalad, degite, ¿igid-imaksad-ular akwagi be an-makbimarsunna? ");
INSERT INTO cuk09_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judiomar, abin-imakdemargu, sogdemalad: —Be-ibmar-nued-makdiid-ular anmar akwagi be-makbisurmalad, anmar akwagi be-makbiedi, be Bab-Dummad-nuggi dododid-ular. Ar be we-napnegginedidde, emide degite Bab Dummadga na be imaked. ");
INSERT INTO cuk09_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús, abin-sogde: —¿Ar bemargi Moisés-igargi-narmakar naisursi? An bemarga sogsad, bemar bab-dummagan gumarye. ");
INSERT INTO cuk09_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ar Bab-Dummad-gaya-burba-abingasmaladse, be bab-dummaganye Bab Dummad gocha-gusad. Ar Bab-Dummad-Garda geg anmar bisked. Degisoggu, noar an sogsasurdo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ar Bab ega-arbaega an-susad, degine, we-napnegse an-barmialid. ¿Anga bemar sogode: ‘Be Bab-Dummad-nuggi dododiiye,’ an sogsad-ular: ‘Ani an Bab-Dummad-Machiye?’ ");
INSERT INTO cuk09_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ar an-Bab-ibmar an imakdisulile, mer be an-ibmar-soged abingamardo. ");
INSERT INTO cuk09_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ar an-Bab-ibmar an imakdiirdi, ar be an-benmar-inigwele, an-ibmar-imakdiidgi mer be bengumardo, adi bemar wisgumalagar, degine, mer bengumalagar Bab angi gudiid, degine, an Babgi gudimogad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Agine, Judiomar gannar Jesús-gabi-guarmalanad degi-inigwele, Jesús egi nabir wakicha-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús gannar Jordán-diwar-obakar nade-gusad, bia Juan iduar Bab-Dummad-digi-ogleged-igar imaknai-gusadgi. Agi Jesús megidapid. ");
INSERT INTO cuk09_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ase dulemar-bukidar Jesússe duurmaknoni-gusmalad, sogdemalad: —Ar inso Juan-Bautista ibmar-wilubgan-imakledisulid imaksasur-inigwele, bela we Jesúsgi ibmar sogsad, napiragwad sogsad. ");
INSERT INTO cuk09_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Agine bukidar Jesúsgi-bensuli-gunonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dule-wargwen Lázaro-nugadi, Betaniagined, deun uelemaid. We-Betania-neggweburde María, degine, e-ior-Marta e-neggweburmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","We-María, gwallu-wawaadgi Bab-Jesús-magsa-gusad, na e-sailagiagi Dummad-Jesús-e-nag odingusii-gusadid. We-María-e-sus Lázaro deun uelemaid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Degisoggu, Lázaro-e-bunmar dulemar-barmismalad, Jesúsga sogegar, Dummad, ar dule-nue-be-sabedi, uelemaiye. ");
INSERT INTO cuk09_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús, degi-itosgua, sogded: —We-Lázaro-uelemaidi, burgwegarsulid, Bab-Dummad-nug-odummogega we-uelemaid, adi we-uelemaidgi Bab-Dummad-Machi-e-nug odummolegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Dakargua, Jesús, nue Marta, e-urba, degine, Lázaro-sabed. ");
INSERT INTO cuk09_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jesús wisgusgu, Lázaro uelemaiye, bia-na-maidgi ibabo amba megis-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Geb a-sorba, Jesús na e-sapinganga sokalid: —Gannar anmar Judease namarye. ");
INSERT INTO cuk09_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E-sapingan ega sogded: —Odurdaked-saila, emide Judiomar akwagi be-makbi-gusmaladde, ¿degite gannar be nabarde? ");
INSERT INTO cuk09_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús, abin-sogded: —¿Ar neg-ibgined wachi-irambe-gakabo niksursi? Ar dule neg-ibgi gudiile, geg yoleged, ar we-napneggined neg-meegwadba gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ar dule neg-mutikidgi gudiirdi, yoledo, ar agindi gwallu-meegwad sulid. An-burgoed-iba-nonikidse geb an burgoed, emigindi an-oburgosurmalad, ar ibginedyob an gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","We-degi-sogsad-sorba Jesús na e-sapinganga sogdesunnad: —Anmar-ai-Lázaro gabmaid, an ese naer-gebed odakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E-sapingan ega sogdemalad: —Dummad, ar Lázaro gabmaile, nuguodo. Degite, ¿ibiga be nabisunna? Mer be nae. ");
INSERT INTO cuk09_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ar Jesús we-degi-sogsa-gusadi, sognaindo: “Lázaro burgwar maiye.” Ar e-sapingandi, gabed-sunnad ega obarye bienad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Geb degi Jesús bakar-buud sogdesunnad: —Lázaro burgwis maiye. ");
INSERT INTO cuk09_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Bemar-ular yeer an itoged, ar Lázaro-walik an gudigussurgu, adi bemar mer angi bengumalagar. Degisoggu, anmar Lázarose namargwelo. ");
INSERT INTO cuk09_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Degi Tomás, Dídimoye bimarbalid, e-sordamarga sogdesunnad: —Anmar Jesúsba namarmodo, adi anmar eba burgwemarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Degi Jesús Betaniase nonigu, daknonikid, Lázaro ibabakegus bato neg-uangi digles-mai. ");
INSERT INTO cuk09_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania dakargu Jerusaléngi itakaa siid, unnila wachi-abala nanae-wilub. ");
INSERT INTO cuk09_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lázaro-burgwisad-ular, Judiomar-bukidar Martase, degi, Maríase nonigusmalad, adi wis e-gwage odimakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta itosgu Jesús daniye, e-abin nade-gusad, Maríadi neggi besa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Degi Marta Jesúsga sogded: —Dummad, be wegi anmar-abargi gudigusana, an-sus burgwissulinad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Emigi an wisbardo, ar ibu Bab Dummadse be egisele, Bab Dummad bega ukoed. ");
INSERT INTO cuk09_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús, abin-sogded: —Be-sus gannar durguoed. ");
INSERT INTO cuk09_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta, abin-sogded: —An wisi, ibagan-bergusar, an-sus dulemar-gannar-durguoed-ibagi gannar durguoed. ");
INSERT INTO cuk09_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús, abin-sogde: —Ani an gannar sunna dule-odurguedid, degi, ani an burba-geg-bergued ukedbalid. Ar dule angi bensulile, ar burgwar mai-inigwele, gannar durguoed. ");
INSERT INTO cuk09_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ar bela-dula-gudidimalad angi bensulile, bar e-san-burba berguosulid, degi-sadeguoed. ¿Ar we an-bega-soged be bensuli? ");
INSERT INTO cuk09_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta, Jesús-abin sogded: —Dummad, eye, an bensuli, be Cristo, Bab-Dummad-Machi, we-napnegse be danikoye be sogles-gusadid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta deyob sogsad-sorbali, e-urbase gornaded, ega arbakee sogdapid: —Odurdaked-saila noni, bese gole. ");
INSERT INTO cuk09_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Deyob ega soge itosgu, María yog gwisguar imaksad, Jesússe nade-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús deun amba yo neggweburse doged, ar bia-Marta-e-abingusadgi amba gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judiomar wis María gwage odimakegala, e-neggi-eba-bukmaladi, daksamargu, María gwae gwisgus node, eba nodmarmogad. Amar sogdemalad: —María neg-uanse naded, ase bonaded. ");
INSERT INTO cuk09_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María, Jesús-siidse modapgu, Jesús dakdegu, e-abin yokorgi sindigar sigdapid, ega sogded: —Dummad, be wegi anmar-abargi gudigusana, an-sus burgwissulinad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús dakdegu, María ise-boale, degine, Judiomar-wis-María-gwage-odimakega-nonimalad ise-boarmarmoga, na ulubgi nue-nunmak ito-nadmogad, degi, nue-María-wile-dakded. ");
INSERT INTO cuk09_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesús Maríaga sogded: —¿Bia bemar Lázaro-digsamala? Jesúsga sogdemalad: —Dummad, be dage, be dakdage, bia digar mai. ");
INSERT INTO cuk09_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Degi Jesús boded. ");
INSERT INTO cuk09_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Degi Judiomar sogdemarsunnad: —Nue be dake, ibiyobi Jesús Lázaro-nue-sabena. ");
INSERT INTO cuk09_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Degi Judio-baigan sogdemarmogad: —Ar we-Jesúsde, dule-ibya-sulidga ibya-egasadde, ¿ar sunna wede Lázaro oburgwesuli geg imakgussi? Deyob imake-wilubbinad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús nue ulubgi bukib itodbargu, neg-uanse nonikid. Dakargua, gusgu na Judiomar mui digdamalad akwa-yaa-ollogwad-yaba, geb akwa-dummad e-doged-idu sii-damalad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús dulemarga sogdesunnad: —Akwa-dummad-onirmar. Marta, dule-burgwisad-e-bun, sogded: —Dummad, ¿Ibiga akwa be onirbie? Bato ibabakegus diglesad, degisoggu, ¿bato nun yapansursi? ");
INSERT INTO cuk09_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús, Marta-abin sogded: —¿An bega sogsasursi, be bensulile, Bab-Dummad-gangued be dakoye? ");
INSERT INTO cuk09_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Degi geb bia dule-burgwisad-diglesadgi akwa-dummad-idu-siid onirismalad. Geb degi Jesús niba atakdegu, sogded: —Baba, dog-nuedye an bega soge, be an-itosgu. ");
INSERT INTO cuk09_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Andi an wisid, be gusgu an-ito daed. Ar we-ibmar an sogsadi, dulemar-an-dikarba-bukwamalad-ular an sogsad, adi mer bengumalagar be an-barmialid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesús degi-sogsad-sorbali, binnasur goted: —¡Lázaro, magaba be nodage! ");
INSERT INTO cuk09_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lázaro dule-burgwis-gusadi, noargu, bela naga, degine, arganmar morgo-bipirmakedgi ise-atinnar noalid, degine, e-wagar ise-morgogi bipirmakarbalid. Jesús dulemarga sogded: —Be Lázaro esikmar, degi, naega be imakmarsun. ");
INSERT INTO cuk09_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Bukidar-Judiomar-Maríaba-nonimalad, Jesús Lázaro-gannar-odulosad daksamargu, Jesús-bensuli-gunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ar gwenna-gwennadi Fariseomarse nadmalad, ega sogdapmalad, igi Jesús Lázaro-odulosad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Degine dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Fariseomar, amar igar-itogega dummagan-onmaknonimargu, sogdemalad: —¿Igi an samalosunna? Ar we-dule ibmar-wilubgan-imakdisulid bukidar emide imakdiid. ");
INSERT INTO cuk09_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ar we-Jesús ibmar-dakledisulid gatik imakega anmar imakmalale, bela eba nagudmaloed. Geb degi Roma-dummagan nonimaloed, anmar-Bab-Dummadse-goled-neg, degi, anmar-yar osulononimaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Degi Judio-dummagan-wargwen, Caifás-nugadi, deun a-birgagi dule-irwa-Bab-Dummadse-gormalad-bur-dummadga gumaid, e-sordamarga sogded: —Bemar nue ibmar wichurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ar bemar aku itomarsi, bela dulemar-anar dule-wargwen bur burgwed nabirid, adi melle bela dulemar-a-yargi-bukmalad obelolegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","We-Caifás degi-ibmar-sogsadi, na wargwen e-itolegedba ibmar sogsasulid, ar ade a-birgagi dule-irwa-Bab-Dummadse-gormalad-bur-dummadsoggu, iduakwaa sogsa-gusad: “Jesús bela Judio-dulemar-anar burgoye.” ");
INSERT INTO cuk09_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesús unnila Judio-dulemar-anarbi burgosulid, burgwebaloed, adi bela Bab-Dummad-mimmigan aisakis-bukmalad na danakwaa urbegar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Degisoggu, Judio-dummagan a-iba-akar na sogsamardo, Jesús-oburgwemaloye. ");
INSERT INTO cuk09_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Degisoggu, Judiomar-abargi bar Jesús ise-na-san-oyoar gudigussulid. Judea-yargi node-gusad, naded, nega-dule-sulid-dikarba, neggwebur-Efraín-nugadse. Jesús a-neggweburgi na e-sapinganmala megidapsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Deun Judiomar-iba Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba bato omosad. Bukidar neggwebur-baid-baidginmalad Jerusalénse iduakwasaar nonimalad, adi na san swilidik imakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","A-dulemar Jesús-amiarmarsunnad, Bab-Dummadse-goled-neggi bukmargu, na muchub-muchub egisnanai-guarmalad: —Be dakgua, ¿Jesús ibase nonikosur be dake? ");
INSERT INTO cuk09_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Fariseomar, igar-mesismalad, ar doa-dule wis-dibeye bia Jesús gudiiye, sogmaloye, adi Jesús-gamalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Iba-nergwase, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba naguoele, Jesús Betaniase nonikid, bia Lázaro maidse. We-Lázaro burgwis-gusgu, deun Jesús gannar we-dule-odulosad-duled. ");
INSERT INTO cuk09_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Agine, Jesúsga sedo mas-gunned imaksamalad. Marta deun ega mas daknai-gusad, Lázarodi Jesús-mas-gunsiidgi sii-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Agi María, bute-gwagwen gwallu-wawaad-nued, nardo-nugad, ber gargesailad, Jesússe senonikid. Geb degi María Jesús-naggi a-gwallu-wawagwad eosad, degi, na e-sailagiagi Jesús-nag odinnosad. Gwallu-wawagwad-e-yapanned bela neg gasa sigisad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jesús-sapin-wargwen, Judas-Iscariote, Simón-e-machi, ar darba-Jesús-ukoed-dule, sokalid: ");
INSERT INTO cuk09_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Ibiga we-gwallu-wawagwad denario-dulataled-ilapaa gargegu uklessuli, adi a-mani wileganaga ukega? ");
INSERT INTO cuk09_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ar Judas degi-sogsa-gusadi, dule-wilegana-sabedbali deyob sogsasulid, ar ade dakargua, dule-atursilisoggu, mani-sagu na e sedisoggu, mani-agi-urbilemaid arbak atursadii-daed. ");
INSERT INTO cuk09_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Geb degi Jesús, Judas-abin sogded: —Mer Maríaga akar-soge. We gwallu-wawagi an-magsadi, an diglegoed-ular an-magsad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ar bemar-abargi wileganadi gusgu gudiguoed, andi bemar-abargi sadeguosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Judiomar-bukidar wisguarmargu, Jesús Betaniagi gudiiye, ese duurmaknonimalad, unnila Jesús-dakegarbisulid, Lázaro-dakegarbalid, ar ade Jesús Lázaro burgwar-mai odulosad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan igar-amismarbargu, igar-mesismalad, Lázaro-oburgwemarmogoye. ");
INSERT INTO cuk09_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ar ade Jesús, Lázaro-odurgusad-ular, Judiomar-bukidar Judio-igar-odurdakmaladgi bangudmalad, Jesúsgi-bensuli-gunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A-banedgine, dulemar-bukidar-ibase-nonimalad itoarmargu, Jesús Jerusalénse daniye, ");
INSERT INTO cuk09_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ogob-gagangiid-e-gagan gwachamalad, degine, Jesús-abin nadmalad, Jesús-nug odummogegar. Jesús-dakarmargu, binnasur gotemalad, sogdemalad: ¡Bab-Dummad-nug odummomar! ¡We-dule Bab-Dummad-nuggi-danikid, bela ega ib-nuedga guena-gadin, Israel-e-Reygi! ");
INSERT INTO cuk09_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús moli-uaya-suid-e-mimmi-amisad, egi birgi sigisad, ar Bab-Dummad-Gardagi egi narmakar naidyob: ");
INSERT INTO cuk09_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mer be dobgu, Siongi-bukmalad, emigi be-rey bese danikid, moli-uaya-suid-e-mimmi-birgi sii. ");
INSERT INTO cuk09_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ar gebesaila Jesús-sapingan aku-itosmalad, wede ibi-obare. Ar Bab Dummad Jesús-nug-ogannosad-sorbali, geb e-sapingan insadmalad, we Jesúsgi bato Bab-Dummad-Gardagi narmakar naid, degi-narmakar-naidba ega imaksamarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Dulemar Jesús-daksamalad, igi deun Lázaro-neg-uan-yaba-maigu ese gocha, gannar odulosa, amar baiganga sogedbimalad we-igargan. ");
INSERT INTO cuk09_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","A-ulale dulemar-bukidar Jesús-abin noni-gusmalad, ar ade itosmalad, igi Lázaro gannar odurgus-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ar Fariseomardi na ga sogdemalad: —Dulemar mer Jesúsba naguegala, anmar gwen oakalogosurmalad. Ar be dakena, ar bela dulemar eba duurmakmaid. ");
INSERT INTO cuk09_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Griego-dulemarmo, Bab-Dummadse-golega, Judiomar-ibagi Judiomar-abargi nonimarmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Amar, Felipese nonimalad. Felipe, Betsaida-Galileaginedid. Griego-dulemar Felipegi wilenai-gusmalad, ega sogdemalad: —Dummad, anmar Jesús-dakbimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe nadgu, Andrésga sogdapid. Degine, Felipe, Andrés-ebogwa Jesúsga sogdapmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús, abin-imakdegu, sogded: “Emigindi iba nonisun, adi ani Dule-Machi, an-nug odummolegegar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Napira an bemarga soged, ar ibmar-gwag napagi argwansulile, e-uka nungu sulile, unnila na ebi gudii-daed. Ar e-uka nunguerdi, adi bukidar sanmakodo. ");
INSERT INTO cuk09_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","“Ar amba deyobmodo dule na e-san-burba na sabele, binsa oyogguodo. Ar we-napneggi e-san-burba na sabsulile, burba-geg-berguedga sabogodo. ");
INSERT INTO cuk09_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ar dule anga arbabiele, anba dagodo, an-sogedba nanaegar. Ar bia an gudiguoedgine, dule-anga-arbaedi agi gudigumogoed. Ar dule anga arbaele, an-Bab a-dule-nug odummogoed.” ");
INSERT INTO cuk09_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesús sogdebar: “Emigindi an ulubgi surbinsa itoged, degite, ¿igi an sogosunna? ¿An sogoe, ‘Bab Dummad, emigindi we-ibmar-nunmaked-dummad be anga osuloye?’ Suli, degi-an-sogosuli, ar aga we-napnegse an nonikid, burgwegar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bur an sogodo: Bab Dummad, be-nug be odummoge.” Degi nibneggi gaya-burba gornonikid: “Bato an-nug an ogannosad, degi, an-nug gannar an ogannobaloed.” ");
INSERT INTO cuk09_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Dulemar-bukmalad, gaya-burba-sunmak-itosmaladi, sogdemalad: —Mar gochaye. Baigandi sogmalad: —Anger-wargwen ega sunmaksaye. ");
INSERT INTO cuk09_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús sunmakdegu, sogded: —We-gaya-burba-be-itosmalad anga nonisulid, bemarga nonikid. ");
INSERT INTO cuk09_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Emigindi we-napneggi dulemar-bukmalad sabsur-odurdakleged-iba nagunonikid. Emigindi nia-saila we-napneg-dummadga-gudiid, a-onoleged-iba nonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ar ani, ar napneg-naidgi an onakwilesale, bela dulemar anse an ebioed anba nagumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","We Jesús degi-sogsa-gusadi, mag itoledo, sognaid, ede nakrusgi biokar burgoye. ");
INSERT INTO cuk09_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Dulemar, Jesús-abin sogdemalad: —Anmar wismalad Moisés-igargi sognaid, Cristo, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule nonikir, burgosulid, degi-sadeguoed. ¿Ar ibiga bedi sogsunna, Dule-Machi onakwileger-gebye, nakrusgi biokar burgwega? ¿Ar we doa-sunna Dule-Machi? ");
INSERT INTO cuk09_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Geb degi Jesús, abin-sogded: —Emigindi ani gwallu-meegwadga ichesaar amba bemar-abargi an gudiid. Gwallu-meegwad amba bemar-abargi-gudiidgi eba be nanamar, ar melle neg-sichid ukiar be imakmalagar. Ar dule neg-sichidgi nadapile, wichur daed bia nadapi. ");
INSERT INTO cuk09_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ar emigindi amba be gwallu nikmarsoggu, gwallugi mer be bengumar, adi bemar neg-meegwad-mimmiganga gumalagar. Jesús degi-ibmar-sogsa-gusad-sorba nadsunnad. Emar-idu dukusad, mer e-amimalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ar Jesús emar-wagab ibmar-wilubgan-dakledisurmalad bukidar imaksa-inigwele, dulemar amba Jesúsgi bengusmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ar ade epenne Bab-Dummad-gaya-burba-berbeged, Isaías sogsa-gusadyob guegala, deyob gunonikid, deun Isaías sogsa-gusgu: Bab Dummad ¿doa anmar-ibmar-sogsa-gusad bengussuli? Bela bengusadbimalad. ¿Doasega Bab Dummad na e-gangued oyosa? Amba a-dulemargardo. ");
INSERT INTO cuk09_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","A-ulale dulemar Jesús-abingassurmalad, ar ade Isaías amba sogsa-gusbalid: ");
INSERT INTO cuk09_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Bab Dummad amar-e-ibya aku-dake imaksad, degi, amar uayasur-daega imaksabalid, adi melle na e-ibyagi mag dakmalagar, degi e-gwagegi melle mag itomarbaligar. Ar degiile, abonolemalo-itole. Ar degiile, amar an nudake dakledago-itole. ");
INSERT INTO cuk09_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías weyob sogsa-gusad, deun Jesús-e-gangued daksagu, agi egi sunmaksa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ar degi-inigwele, dummagan-bukidar-neg-dakmamaid, ulubgi Jesús-gwen-bengussurmalad, degite bakar-buud amar gwen sogsasurmalad, emarde Jesúsba naimoye, ar ade dobmalad, adi melle Fariseomar Judiomar-onmaked-neggi emar-onomalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Deginbali, ar dummagan dulemar-na-e-nug-odummoged bur-nabir itomarbalid, Bab Dummad e-nug odummogedbar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús binnasur sunmakde, sogded: “Ar dule an-bensulile, anbi an-bengusulid, Bab-Dummad-an-barmialid-bensurbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ar dule mag an-dakale an-doa-dule, dule-an-barmialid-mag-dakbardo. ");
INSERT INTO cuk09_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ani, we-napnegse gwallu-meegwadga, an nonikid, adi bela-angi-bensurmalad, mer bar neg-sichidgi gudigumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ar dule an-gaya-burba-itogedi, ar aba dasulile, ani an sogosulid, be dummad-nosye. Ar we-napnegse an nonigua, dulemarga sogega an nonisulid, be nue iskusmarye. Ar an nonikidi, dulemar-abonogegalad. ");
INSERT INTO cuk09_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ar dule an-abingasulile, degine, an-gaya-burba-sunmaked abingasurbalile, amargardi soglegodo, be dummad-nosye. Ar ibagan-napi-naiguoedgi an-ibmar-sogsadba dulemar-an-abingassurmaladga soglegoed, ‘Be Bab Dummadse sabsur odurdaklegoye.’ ");
INSERT INTO cuk09_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","“Ar an sunmaksad an-itolegedba an ibmar sogsasulid. Bab Dummad an-barmialid, a, igar anga uksad, igi an sogoe, degi, igi an sunmakbaloe. ");
INSERT INTO cuk09_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ar an wisdo, Bab-Dummad-igar-anga-uksadi, dulemar-anba-nagumaloedga burba-geg-bergued uked. Degisoggu, ibmar an sunmakedi, ar igi Bab Dummad anga sogsa, deyob an sunmaked.” ");
INSERT INTO cuk09_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba bane-nagudoed-iduar, Jesús deunni Jerusaléngi gudiid. Jesús na wisid, we-napneggi gudiid e-Babse gannar-naed-ibagan warmaksad. Ar Jesús na e-sapingan we-napneggi-bukwad nue sabgussoggu, na nue bela-bela sabgussunnad, e-burgwedse. ");
INSERT INTO cuk09_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesús na e-sapinganmala sedo mas gunbukwagua, nia-saila bato Judas-Iscariotegi burba-iskana oubosad Jesús-darba-ukega. We-Judasde Simón-e-machid. ");
INSERT INTO cuk09_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús na wisid, e-Bab bela ega igar-uksad bela ibmar imakegar. Degine, Jesús wisbalid, na Bab Dummadgi danikid, degi, na Bab Dummadse gannar nabaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","A-ulale, Jesús na mas gunsigua gwisgus imaksad, e-suba esusad, degine, toalla susgua, na e-sadergi edichad. ");
INSERT INTO cuk09_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Degi Jesús bormo-yagi dii eosad, e-sapingan-nag enukegar. Geb degi toalla e-sadergi-naidgi ega nag odinnoarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Geb degi Jesús Simón-Pedrose nonikid, geb Pedro ega sokalid: —¿Dummad, be anga nag enukoe? Suli, be anga nag enukosuli. ");
INSERT INTO cuk09_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús, abin-sogded: —An-emi-ibmar-imaknaid aku amba be itoged, geb sorba mag be itodapoed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro, Jesúsga sogded: —An-nag be enukosurguoed. Jesús, abin-sogded: —An bega nag enuksulile, geg be an-sapinga gued. ");
INSERT INTO cuk09_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Geb degi Simón-Pedro Jesúsga sogdesunnad: —Dummad, ar be deyob sogele, an-nagbi be anga enukosulid, an-argan, degi, an-nono be anga enukbalir-gebed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús, abin-sogded: —Ar dule bato obsamalad bar obed abesulid, unnila e-nagbi napi-enuked abeleged, ar ade bato guar swilidik gudiid. Ar bemar bato swilidik gudimalad, ar bela bemar swilidik gudisurmar-inigwer. ");
INSERT INTO cuk09_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ar ade Jesús na wisid doa darba e-ukoe, a-ulale sogsa-gusad: “Bela bemar swilidik gudisurmarye.” ");
INSERT INTO cuk09_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Degisoggu, Jesús e-sapinganga na nag-enuksad-sorba, gannar e-mor na yosgu, mesase gannar signonikid. Geb degi e-sapinganga sokalid: “¿Bemarga-an-nag-enuksad mag bemar itomala, we ibi obare? ");
INSERT INTO cuk09_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ar bemar Odurdaked-Sailaye, degine, Dummadye be anse gormalad, ar nabir deyob be anse gormardo, ar an adid. ");
INSERT INTO cuk09_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ar ani, an Dummadid, degine, an Odurdaked-Sailadde, degite bipii na san imaksad, bemar-nag an enuksadde, bemar na muchub-muchub nag na ga enuke-wilubmarmodo, na maikwaa na san sae-wilubmarmodo. ");
INSERT INTO cuk09_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ar bemarga an na oyosad, ar igi bemarga an be-imaksamala, deyob bemar na imake-wilubmarmodo. ");
INSERT INTO cuk09_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Napira an bemarga soged: Dule maiga-arbaed, e-dummadba geg dummad gued, degine, gege dule-barmilenaid e-barmisiidba bur dummad gued. ");
INSERT INTO cuk09_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ar we-ibmar bemar bato wismarsoggu, ar aba bemar imakele, bemargi nued binsalegodo. ");
INSERT INTO cuk09_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ar bemar belagwapaga an sogsulid. Ar an wisid doamar an susa, adi Bab-Dummad-Garda-narmakaledba guegala, bemar-wargwen dikarba an-ukoed, ar Bab-Dummad-Garda-narmakaledgi sognaid: Ar dule anba madu gunsiidi, angi aibinnoniye, an-istaradga gunoniye. ");
INSERT INTO cuk09_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Deyob gued iduar, an bemarga soged, adi degi-gunonikile, bemar mag-ittos-namalagar, ani an Cristod. ");
INSERT INTO cuk09_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Napira an bemarga soged: Ar an dule-barmidoed-abingamalale, an-abinganaid. Ar dule an-abinganaile, Bab-Dummad-an-barmialid a-abinganamogad.” ");
INSERT INTO cuk09_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesús degi-sogsad-sorba, e-ulubgi bukib-binsa-naded, degi, e-sapinganga sogdesunnad: —Napira an bemarga soged, bemar-wargwenadi darba an-ukoed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Degi e-sapingan na muchub-muchub dakdemalad, na wichurmalad doagi Jesús degi-soge. ");
INSERT INTO cuk09_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","E-sapingan-wargwen, ar Jesús na nue sabedi, e-dikarba sii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Asega, Simón-Pedro arbak achasad, adi Jesússe egisegar, doa-dulegi wede deyob soge. ");
INSERT INTO cuk09_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Degi a-dule, Jesús-binasgar-walik biligwa maid, Jesúsga sogded: —Dummad, ¿doa-dule arbak be-ukoe? ");
INSERT INTO cuk09_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús, abin-sogded: —Ar doa-dulega madu-waraa an ukoe, a-dule, darba an-ukoed. Jesús madu owardikusgu, Judas-Iscariote, Simón-e-machi, aga madu uksad. ");
INSERT INTO cuk09_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas, madu-bipi ega uklesad guchagu, nia-saila-Satanás egi dognonikid. Geb degi Jesús Judasga sogdesunnad: —Ar ibmar-be-imakoedi, gwae bur be imaknasun. ");
INSERT INTO cuk09_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ar e-sapingan mesa-naba-bukmaladi aku itosmalad, ar ibiga Jesús deyob Judasga sogsa. ");
INSERT INTO cuk09_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ar abar binsadmalad, Judas mani-saboged-e-sagu sedisoggu, Jesús Judasga sogdakleye: “Anmar-ibmar-ibaga-abegedi be baknaye,” ar ega sogbar-dibe: “Wileganaga wis be mani uknaye.” ");
INSERT INTO cuk09_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ar Judas madu guchagua, yog noar-imaksad. Ar nodgua, bato deun neg-mutikid. ");
INSERT INTO cuk09_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Degine, Judas-naded-sorba Jesús sogdesunnad: “Ar emigindi ani Dule-Machi, an-nug odummolesunnoed, degine, anba Bab-Dummad-e-nug odummolemosunnoed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ar ani Dule-Machi, angi Bab-Dummad-nug odummolegele, Bab Dummad an-nug odummomogoed, degi, ar emiskwaa an-nug odummogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mimmigan, wis ichesaar amba an bemar-abargi gudiguoed. Be an-amimalo-inigwele, ar igi Judiomarga an sogsa, deyob bemarga an sogmarmogad. Ar bia an nasokalidse, geg be anba namalad. ");
INSERT INTO cuk09_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Igar-binid an bemarga ukmarsunnad, na be muchub-muchub na be sabgumar, ar igi an be-sabgusmarmoga, na deyob be muchub-muchub sabgumarmosun. ");
INSERT INTO cuk09_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Agi bela mag be-dakmaloed, bemar an-sapingan gumalad, ar na be muchub-muchub nue sabgumalar.” ");
INSERT INTO cuk09_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón-Pedro Jesúsga sogded: —Dummad, ¿bia be nae? Jesús, abin-sogded: —An-emi-nasokalidse, emigindi geg be anba daggweled, sorbardi geb be anse naoed. ");
INSERT INTO cuk09_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro ega sogded: —Dummad, ¿ibiga emigindi geg an beba nae? An be-ular an burgweye sogele, an guakwaa gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús, abin-sogded: —¿Be guakwaa gudii an-ular burgwega? Suli, be guakwaa gudisuli. Napira an bega soged: Gannir-namaked-iduar, ilapaa be an-osulogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús na e-sapinganga sogded: “Mer surbinsa be-gwagegi be itomalo. Bab Dummadgi mer be bengumalo, degine, mer angi be bengumarbalo. ");
INSERT INTO cuk09_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","An-Bab-neggi neg-nuegan-bukidar nikad, ar degisulina, deyob an bega sogsasurmalanad. Ar emigindi an nae, bemar-idu bemarga neg guagwar sinaegar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","An bemar-idu namalad, bemarga neg guagwar sismalale, gannar an danibaloed, bemar-sudagegar, adi bia an gudiguoedgi, agi bemar anba gudigumogagar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ar bemar wismalad bia an nasokali, degine, igar-maid bemar wismarbalid.” ");
INSERT INTO cuk09_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás Jesúsga sogded: —Dummad, ar anmar wichulid bia be nasokali, degite, ¿igi anmar wisguosunna, bia igar maid? ");
INSERT INTO cuk09_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús, abin-sogded: —Anbi unnila Bab Dummadse be-sedoed, ani an napiragwadid, degine, dula gudigued angi danikid. Dule-wargwensaale geg Bab Dummadse warmaked, ar angi nasulir. ");
INSERT INTO cuk09_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ar mag be an-dakena, an doa-dule, an-Bab mag be dakmarmoganad. Ar emigindi bemar mag an-Bab-dakmaloed, ar ade bemar bato an-Bab-daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe Jesúsga sogded: —Dummad, Bab Dummad be anmarga oyoge, geb agine anmar gusbin itogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús, abin-sogded: —Felipe, ar dikasurgus an bemar-abargi gudiidde, degite, ¿amba be aku an-dakde? Ar dule an-daksale, a-dule bato an-Bab-daksamodo. Degite, ¿ibiga be anse egissunna: Bab be anga oyoye? ");
INSERT INTO cuk09_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ar be bensi, Babgi an gudiid, degine, Bab angi gudimogad? Ar ibmar an sogedi, an-itolegedba wargwen an sogsulid, ar Bab-angi-maiddi, a angi ibmar imaked. ");
INSERT INTO cuk09_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mer be bengumar, an-Babgi an gudiid, degi, Bab angi gudimogad. Ar degisulile, an-ibmar-imakedgi be dakmar, mer be an-bengumar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ar napira an bemarga soged: Ar dule angi bensulile, an-ibmar-saedi, imakmogoed. Degine, a-dule bur-bule ibmar-dummagan imakoed, ar ade an-Babse an naesokalid. ");
INSERT INTO cuk09_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ar bela an-nuggi an-Babse be ibmar egisele, an bega imakoed, adi Bab na E-Machigi nug-ganguegar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ar ibmar-gwensak an-nuggi be egisele, an bega imakoed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesús sogdebar: “Ar be an-sabmalale, an-igar-mamaidba be damaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","An-Babse an bemarga egisoed, adi be bendaked-baid, bemar-Gwage-Armaked, bemarga barmidagega, ar adi degi-sadegu bemarba gudiguegar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","We-Burba-Nued napiragwadbi Bab Dummadgi sunmaked. We-napneggi dulemar-Bab-Dummad-wichurmalad we-Burba-Napiragwad geg abingaed, ar ade daksurmalad, deginbali, amba aku dakmarbalid. Ar bemardi we-Burba-Napiragwad-mag-daked, ar bemarba gudiid, degine, bemargi gudigubaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Wargwen, nusgana-babgan-sulidyob, an bemar-metosurmalad. An bemarse gannar danibaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ar amba emi bipisaale, we-napneg-naidgi-bukmalad bar an-dakosulid, ar bemardi an-dakmaloed, ar an dula gudisoggu, bemar dula gudigumosunnoed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A-ibagine bemar mag itogoed, an-Babgi an gudiid, bemar angi gudimogad, degine, an bemargi gudimogad. ");
INSERT INTO cuk09_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ar dule an-igar-mamaid sediile, degine, ar aba gudiile, we-dule nue-an-sabed. Ar dule an-sabele, an-Bab sabgumogoed, degine, a-dule an sabgumogoed, degine, an ese magarobaloed an doa-dule gue.” ");
INSERT INTO cuk09_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jesúsga Judas sogded (Judas-Iscariotesur): —Dummad, ¿igi nabir anmarse be magarogoe, ar dulemar-beba-naisurmaladsedi be magarogosulid? ");
INSERT INTO cuk09_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús abin-imakdegu, sogded: —Ar dule an-sabele, an-gaya-burba-sunmakedba daoed, degine, an-Bab a-dule-sabgumogoed, degine, anmar a-dulese danikoed, a-dulegi megegar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ar dule an-sabsulile, an-gaya-burba-sunmakedba daosulid. Ar bemar-an-sunmaked-itosmaladi, an wargwen ibmar sogsasulid, an-Bab-an-barmialidi, a-sogedba ibmar an soged. ");
INSERT INTO cuk09_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“We-ibmar-an-bemarga-sogsadi, bemar-abargi gudigu, an bemarga sogsamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ar Dule-Bemar-Gwage-Armaked, Bab Dummad Burba Nued, an-nuggi Bab barmidagoedi, a bela bemar-odurdaknonikoed, degine, bela-an-ibmar-sogsad gannar insaega bemar-imakoed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ulubgi-bogidik-itogega an bemar-imaked, an na ulubgi-bogidik-itogedyob an bemar-imakmogad. Ulubgi bogidik itogega an bemar-imakedi we-napneg-naid imakedyobsulid. Mer be surbinsa be-gwagegi be itomar, mer be dobgumarbar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ar an-bega-sogsamalad bemar itosad: ‘An nae, gannar an bemarse danibaloed.’ Ar bemar an-sabmalana weligwar be itosmalanad, ar bemarga an sogsad an Babse an naye, ar an-Bab anba bur dummad. ");
INSERT INTO cuk09_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ar emigindi idu bemarga an sogsad, adi deyob gunonikile, mer be angi bengumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Bemarga bar suitii an sunmakosulid, ar we-napneggi-dummadga-gudiid, nia-saila danikid, ar angi e-gangued obinsur-inigwele, deyob guer-gebed. ");
INSERT INTO cuk09_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Adi we-napneggi-dulemar-bukmalad wisguegala, an Bab-sabed, degine, Bab Dummad an-barmialidba an ibmar imaked.” Jesús bela weyob odurdaksad-sorba e-sapinganga sogded: “Gwisgumar, wegi anmar namarsun.” ");
INSERT INTO cuk09_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ani an uva-e-saila-sunnadyobid, an-Babdi agi-arbaedyobmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","An-dub-gigwengi sanmaksulile, siklegoed. Ar an-dub-gigwengi sanmakerdi, nue nudakleged, adi bur-bule sanmakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ar bemar bato gwage-nudakles bukmalad, an gaya-burba sunmaksadgi. ");
INSERT INTO cuk09_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Angi be akamar, an bemargi akamarmogoed. Ar igi uva-dubmar e-sailagi akanaisulile, geg wargwen sanmake, ar bemar ambamodo, bemar angi akanaisulile, bemar geg an-Babga ibmar-nuegan imaked. ");
INSERT INTO cuk09_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ani an uva-e-saila-sunnadid, bemar e-dubgii gumalad. Ar dule angi akanaile, degine, an egi akanaimogale, we-a-dule ibmar-nuegan imakerbad. Ar bemar angi ollormalale, gege be ibmar-nuegan Babga imakmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ar angi dule akanaisulile, melledoed, igi uva-dub-giagan miled-daedyob. We-uva-dub-giagan dingudoed, geb degi dulemar wemaloed, geb degine soogi midmaloed ogumakegar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Ar bemar angi akanaile, degine, an-gaya-burba an-bemarga-sogsadba be damalale, ar bemar ibu Babse egisbimala, bela bemarga guoed. ");
INSERT INTO cuk09_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ar agi an-Bab-nug odummoleged, bemar gatik ibmar-nuegan-imakedba. Geb degine, bemar an-sapingan-sunnadga gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ar igi Bab an-sabgusa, deyob an bemar-sabgusmogad. An-sabguedgi be akamar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ar an-igar-mamaidba bemar daele, an-sabguedgi bemar gudimaloed. Ar igi an-Bab-igar-mamaidba an damoga, degine, e-sabguedgi an akanai-gumogad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“We-ibmar an bega sogsamalad, adi an-weligwaled-itogedyob bemar wergumarmogagar, degine, adi bemar nue bela-bela weligwar itomarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","We an-igar an bemarga ukmar: Ar igi an bemar-sabgusmarmoga, deyob na be muchub-muchub sabgumarmosun. ");
INSERT INTO cuk09_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dule emar-sabgued weba bur dummad sulid, na e-san-burba-dula-gudiid uked e-aimar-ular burgwegar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Bemar an-aimar gumalad, ar an-ibmar-sogedba be ibmar imakmalar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Bar bemarse an-maimarye an golosulid, ar mai wichulid ibu e-ibed imaknai. Ar bemarse an-aimarye an gochad, ar bela an-Babgi an itosadi, na bela bemarga odulosmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“Bemar an-sussurmalad, ani an be-susmalad, an be-susmaladi, adi bemar ibmar-nuegan imaknamalagar, degine, bemar-ibmar-saedi degi-sadegu guegar, adi ibu bela Babse an-nuggi be egisbimar-dibe, bemarga ukegar. ");
INSERT INTO cuk09_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","We an bemarga sogmarsun, be imakmar: Na muchub-muchub be sabgumar.” ");
INSERT INTO cuk09_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús na e-sapinganga sogdebar: “Ar we-napneggi-dulemar-bukwad istar be-dakmalale, be insamalo, bemar-idu bato istar an-daksamarmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ar bemar dulemar-we-napnegginedyob damalana, we-napneggi-dulemar-bukwad be-sabgumaloenad. Ar emigindi bemar we-napnegginedsursoggu, a-ular we-napneggi-dulemar-bukwad istar be-dakmalad. Ar dulemar-we-napneg-naid-bukmalad-abargi an be-susmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Be insamalo, an bemarga sogsamalad: Dule-mai e-ibedba geg dummad guye. Ar dulemar an-baregichamarsoggu, dulemar, bemar-bareginmarmogoed, ar degine, ar abar an-ibmar-sogsadba nanasmarsoggu, abar bemar-ibmar-sogedba nanamarmogoed. ");
INSERT INTO cuk09_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ar bemar-anba-naid-ular, weyob bemar-imakmaloed, ar ade dule-an-barmialid-aku-dakedba deyob bemar-imakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Ar we-napnegse an nonisulina, an wemarga sunmaksasulina, wemar iskued niksulinad, ar emigindi geg we sogmalad: ‘Anmar iskued surye.’ ");
INSERT INTO cuk09_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ar dule istar an-dakele, istar an-Bab dakbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ar ibmar-dakledisulid emar-abargi dule-gwen-imakdisulid an imaksasurmogana, adi iskued niksurmalando. Ar emigindi ibmar daksamalad, istar an-daksamalad, degine, istar an-Bab-daksamarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ar weyob degi-gusadi, adi emar-igar-maidgi narmakar-naidba guegalad. Bab-Dummad-Garda sognaid: Binsa igar-suli istar an-daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ar dule Gwage-Armaked, an-Bab-nuggi an barmidagoed. A-dule, Burba-Nued-Napiragwad. A bemarse nonikile, a angi sunmaknonikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ar bemar angi sunmakmarmogoed, ar bemar gebe an-arbaded-onoded-akar be anba gudimalad-ular.” ");
INSERT INTO cuk09_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús sogdebar: “Ar we-ibmar an bemarga sogsamalad, adi melle bemar-burba galakumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ar Judiomar-onmaked-neggi dulemar be-onomaloed. Ar ibagan danikoed, ar be-oburgwismalale, Bab Dummadga ibmar-nued imaknaiye bimaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ar we-dulemar Bab-wichulidba, degine, aku an-dakmarbalidba, weyob be-imakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ar we-ibmar na bega sogsamalad, adi a-ibagan nonikile, bemar insamalagar, bato we-ibmar idu an bega sogsamalad. “Ar an bemar-abargi gudiidba, iduardi an bega sogsasurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jesús na e-sapinganga sogdebalid: “Ar emigindi dule-an-barmialidse an naesokalid. Emigindi bemar bipisaale wis anse egissurmalad: ‘¿Bia be nae?’ ");
INSERT INTO cuk09_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ar we-ibmar-an-bemarga-sogsadba, bemar gwagegine nue-bukib-binsa be-ito nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ar napira an bemarga sogmalad: Ar bemar-idu an naele, bur bemarga ib-nuedid. Ar an bemar-idu nasulile, Dule-Gwage-Armaked geg bemarse daged. Ar an bemar-idu naerdina, an a-dule bemarga barmidagoed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ar Dule-Gwage-Armaked bemarse nonikile, dulemar-we-napneggined na e-iskunaid mag-itogega imakoed, degine, igar-inikigwad-maid mag-itogega imakbaloed, deginbali, Bab-Dummad-dulemar-sabsur-odurdakoed mag-ito imaknonibaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dule-Gwage-Armaked, dulemar an-benmalad-ular dulemar-iskudimalad mag-ito imaknonikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Degine, igar-inikigwad mag-itoge dulemar-imaknonibaloed, ar an-Babse an naesokalid-ular, degine, bemar bar an-dakosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Deginbali, Bab-Dummad-dulemar-sabsur-odurdakoed mag itononimarbaloed, ar ade we-napneggined-e-dummad bato sabsur-odurdaklegoye ega igar-megisad-ular. ");
INSERT INTO cuk09_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Amba bemarga ibmar-bukidar an soged-nika-inigwele, an bemarga sogosurmalad, ar ade bemar aku itomaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ar Burba-Napiragwad-nonikoeddi, adi igar-napiragwadgi bemar-idumaloed, ar na e-itolegedba sunmakosulid, ar sunmakoedi, bela-na-ibmar-itosadba, degine, yoedse ibmar guoed, idu bemar-owisononikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","A-Burba-Nued an-nug ogannononikoed, degi, an-ibmar bemarga odalononikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ar bela Bab-ibmar-nikadi angadmogad, a-ular an bemarga sogsad: ‘A-Burba-Nued an-ibmar suoye, geb degi bemarga odalononikoye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesús na e-sapinganga sogdebar: —Ar ichesaar bemar napi an-dakmaloed, geb ichesaar-nasad-sorba gannar bemar an-daknonimarbaloed, ar ade an-Bab-maidse an naesokalid. ");
INSERT INTO cuk09_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Geb degi abar e-sapingan na muchub-muchub sokarmalad: —¿Ar wede ibu anmarga obare: Ichesaale bemar napi an-dakmaloye, geb ichesaar-nasad-sorba gannar be an-daknonimarbaloye, ar an-Babse an naesokaliddeeye? ");
INSERT INTO cuk09_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Degi sogdemarsun: —¿Ar wede ibu obare: ‘Napi ichesaale?’ We sunmaked anmar aku itomalad. ");
INSERT INTO cuk09_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús mag daksasoggu, e-sapingan ese ibmar-egisbied, a-ular amarga sogdesunnad: “¿Ar bemar na be muchub-muchub egismalad, wede ibi an obarisa an sogsagu, ‘Ar ichesaale bemar napi an-dakmaloye, geb ichesaar-nasad-sorba gannar bemar an-daknonimarbaloye?’ ");
INSERT INTO cuk09_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","“Napira an bemarga soged, bemar bukib binsamaloed, bemar bomarbaloed, ar we-napneg-naidgi-bukmaladdi weligwar itomaloed. Ar bemar bukib binsamalo-inigwele, bukib-ito-bemar-imaked weligwar bemar-imaknonibaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ar ome-gwensak we-napnegse dule-wargwen-ode-sokalile, nunmaked-itononi-daed, ar e-wachigan mosadba. Ar mimmi-aidesad-sorbardi bar na e-naibi-itosadgi binsaosulid, ar weligwar itononi-daed, ar we-napnegse dule-wargwen aidenonikidba. ");
INSERT INTO cuk09_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ar amba bemar deyobmodo, bemar bukib emigindi itomardo. Ar gannar an be-dakmarbaloed, agi bemar gwagegi weligwar itononikoed, degine, bipisaale weligwaled dule bei osulogosurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A-ibagangi bemar anse bar ibmar-egised nikuosurmalad. “Napira an bemarga soged, ar ibu bemar Babse an-nuggi egisbimar-dibe, Bab bega ukmaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ar emi ibase, bipisaale amba yo be an-nuggi Babse ibmar egismalad. Babse be ibmar egismar, adi be ibmar-abingamalagar, adi bemar nue-weligwar itomalagar.” ");
INSERT INTO cuk09_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesús na e-sapinganga sogdebar: “We-ibmargi an bemarga sunmaksamaladi, odukuar an bega sogsamalad. Ibagan nonikoed, bar odukuar an bemarga sunmakosulid, bakar-buud an bemarga Babgi sunmaknonikoed. ");
INSERT INTO cuk09_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A-ibagangi an-nuggi bemar Babse ibmar egismaloed. An sogsurdo, bemar-ular Babgi an wilenai-guoye, bemarga ibmar ukegar. ");
INSERT INTO cuk09_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Suli, degisuli. Ar Bab na e-sunnad bemar-sabmogad, ar bemar an-sabgusad-ular, degine, an-Bab-Dummadgi-danikid bemar bengussulid-ular. ");
INSERT INTO cuk09_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Babgi an danikid, we-napnegse an nonikid. Emigindi gannar we-napneg an mete-sokalid, Babse gannar an naesokalid.” ");
INSERT INTO cuk09_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","E-sapingan Jesúsga sogdemar: —Ar emigindi nue bakar-buud be anmarga sunmaked, odukuar be anmarga ibmar sogsulid. ");
INSERT INTO cuk09_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ar emigindi anmar nue mag-itodo, bela be ibmar bato wis-daed, dule bese egised-iduar, degisoggu, dule-ibmar-bese-egised be abesursundo. Ar a-ular anmar wissundo, be Bab-Dummad-akar-danikid. ");
INSERT INTO cuk09_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús, abin-sogded: “¿Ar emigindi be an-bensurmala? ");
INSERT INTO cuk09_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ar emigindi ibagan danikid, ibagan nonisunnad, bemar na wala-walagwen aisakidmaloed, wargwen be an-metemaloed, degi-inigwele, wargwen be an-metosurmalad, ar Bab anba gudiid. ");
INSERT INTO cuk09_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ar we-ibmargi an bemarga sunmaksamalad, adi angi ulubgi bogidik-itoleged bemar itomalagar. We-napneggi bemar naibi itomaloed, degi-inigwele, be gandik imakmar, ar bato we-napneg-ibmar-iskanagi an nakwisad.” ");
INSERT INTO cuk09_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ar Jesús we-ibmargangi bela sunmaksad-sorba, niba atakdegu, sogded: “Baba, wachidi nonisun: Be-Machi-nug be odummo, adi Be-Machi be-nug odummomogagar. ");
INSERT INTO cuk09_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ar bela dulemar-dakega Be-Machiga gangued ega be uksasoggu, adi bela dulemar-ega-be-uksad amarga burba-geg-bergued ega ukegar. ");
INSERT INTO cuk09_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ar burba-geg-bergued weedo: Dulemar be-wisgued, bebi unnila Bab Dummad wargwennaa-sunsoged guye, degine, Jesucristo be barmialidi, a-Jesucristo-wisgumarbaligar. ");
INSERT INTO cuk09_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Arbaed-be-anga-uksad an obelosadba, we-napneggi be-nug an odummosad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Emigindi degisoggu, Baba, be-naba an-nug be odummomosun, ar igi nug-dummad beyob we-napneg-nagued-idu an nika-gusadyob. ");
INSERT INTO cuk09_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“We-napneggi dulemar-be-anga-uksadga an oyosad be doa gue. A-dulemar bato begadid, degine, amar be anga uksamogad. Amar, be-gaya-burbaba-nanadimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Emigi amar mag itosmalad, bela be-anga-ibmar-uksadi, begi danikid. ");
INSERT INTO cuk09_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ar gaya-burba-be-anga-uksadi amarga an uksamogad. Amar be-gaya-burba-abingasmalad, degine, amar mag nue-itosmalad an begi danikid, degine, gwen bengussurmalad, be an-barmialid.” ");
INSERT INTO cuk09_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jesús sogdebar: “Baba, dulemar-be-anga-uksad, a-ular ise-wilegar na bese egised, we-napneggi-dulemar-bukmaladga an bese ise-wilegar egissulid, be-anga-uksamaladbina na ise-wilegar na bese egised, ar amardi begadmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ar bela dulemar-angadid, begadmogad, degine, begadid, angadmogad. A-dulemargine an nug-odummolesad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ar andi we-napneggi bar gudiguosulid, andi bese naesokalid, ar wemardi amba-we-napneggi gudimalad. Bab be-gwage-swilidikid, dulemar-be-anga-uksamalad, be-nuggi na be nue ako, adi wargwennayob guegar, igi anmar wargwennaa gumoga. ");
INSERT INTO cuk09_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ar amarba we-napneggi an gudigu, be-nuggi nue an akwedii-gusad. Be-anga-uksamalad, an nue akwisad, ar amar gwen yoggussurmalad, unnila machi-wargwen gusgu-yogguoye-soglesadbi yoggusad, adi Be-Garda-narmakar-naidba guegar. ");
INSERT INTO cuk09_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ar emigindi andi bese naesokalid, ar we-napneggi amba an gudiidba we-ibmar an soged, adi an-weligwar-itogedyob wemar wegumarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Be-gaya-burba amarga an uksad. Ar dulemar-be-anga-uksamalad we-napnegginedsursoggu, ar igi an we-napnegginedsurmoga, a-ular dulemar-we-napnegginmalad amar-istar-daksamarmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","An bese egissur, dulemar-be-anga-uksamalad we-napneggi gudiid be onoye. Suli, an bese egisedi, nia-saila-idu be amar-odukuye. ");
INSERT INTO cuk09_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ar amar we-napnegginedsurmalad, ar igi an we-napnegginedsurmoga. ");
INSERT INTO cuk09_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Baba, ibmar-napiragwadgi amar bela begadga-gued be sae, bega arbaegar. Be-gaya-burba napiragwadid. ");
INSERT INTO cuk09_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ar igi we-napnegse be an-barmiarmoga, deyob dulemar-be-anga-uksamalad an we-napneggi-bukmaladse barmidmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ar wemar-ulale, an na dukin na bela begadga an gusun, adi amar napiragwadgi bela begadga gumarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Baba, unnila wemargarbi an bese wilesakwaa egissulid, an egisbalid wemar angi-sunmakmaloedba dulemar-angi-benguosurmaladga. ");
INSERT INTO cuk09_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Adi bela-angi-bengussurmalad unnila wargwennayob guegar, ar igi be, Baba, angi, degi, an begi wargwennamoga, adi amar anmargi wargwennaa gumarmogagar, adi dulemar-we-napneggi-bukwad mer bengumalagar, be an-barmialid, ");
INSERT INTO cuk09_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Baba, gangued-be-anga-uksad, amarga gangued an uksamogad, adi amar wargwennayob guegar, ar igi anmar wargwennamoga. ");
INSERT INTO cuk09_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Adi an amargi, degi, be angi na nue wargwennayob gumalagar, adi we-napneggi-dulemar-bukwad mag dakegar be an-barmialid, degine, igi be an-sabgusa, deyob wemar be sabgusmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Baba, anga-dulemar-be-uksamaladi, bia an mai-guoe, ase a-dulemar anba megbi an abemogad, adi amar dakega, be anga gangued uksad, ar amba yo we-napneg-nagued-idu bato be an-sabgusad. ");
INSERT INTO cuk09_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baba, be-inikigwad-ibmar-imaked, we-napneggi-dulemar-bukwad aku be-daked, andi be-wisid, degine, anba-nanaimaladdi wismalad be an-barmialid. ");
INSERT INTO cuk09_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Amarga an osanalosad be doa gue, degine, gatik bur-bule amarga an be-osanalobaloed adi igi be an-sabgusa, a-sabgusad amargi nai-gumogagar, degine, amargi an gudii-gumogagarbar.” ");
INSERT INTO cuk09_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús wegi-ibmar-sogsad-sorbali, na e-sapinganmala nade-gusad, dian-Cedrón-obakar, bia sapimar-digar-naidse, agi na e-sapinganmala ambikudapid. ");
INSERT INTO cuk09_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, darba-Jesús-uknaid, a-neg wismogad, ar ade gusgu Jesús na e-sapinganmala, ase ambikunad-damalad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas, suar-ibed-bukidar sedani-gusad, degine, Bab-Dummadse-goled-neggi-suar-ibed-arbamalad-e-dummagan eba dani-gusmarmogad. Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Fariseomar, amar Bab-Dummadse-goled-neggi-suar-ibed-arbamalad barmiar-gusmalad. Judasba-danimalad gwallu-abalagi, degi, acha-gwallu, degine, espunyar sedani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ar Jesúsdi na bela egi-ibmar-guoedi wissoggu, dulemar-abin ali, ega sogded: —¿Doa be amimala? ");
INSERT INTO cuk09_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Abin-sogdemar: —Jesús-Nazaretgined an amimalad. Jesús, abin-sogded: —Ani an a-duled. Amar-abargi Judas, darba-Jesús-uknaid, deun gwichi-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús amarga sogsagu, “Ani an a-duleye,” amar sorsik sikirmakdemalad, degi, napagi aimukudmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús gannar amarse egisdebarsun: —¿Doa be amimala? Amar, abin-sogdemar: —Jesús-Nazaretgined an amimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús, abin-sogded: —An bega sogsamalad, ani an a-duleye, ar be an-amimalale, an-sapingan naega be imakmardo. ");
INSERT INTO cuk09_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ar weyob gusdo, adi Jesús na Bab Dummadga ibmar-sogsadba guegar: “Be-anga-dulemar-uksamaladi, wargwensaar an oyoggussurye.” ");
INSERT INTO cuk09_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Degi Simón-Pedro, ar espunyar-na-naiddi e-uka-yaba-maidi onosgu, dule-irwa-Bab-Dummadse-gormalad-bur-dummad-mai naibi imaksad, e-uaya-nuedsikid siksad. A-maide Malcoye-nugad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús geb degi Pedroga sogded: —Be espunyar e-uka-yaba be odoge. ¿Ar dummad an naibiguoed an ina-gaibid goboedyob Bab anga uknaidgi an wilegosurde? Suli, an wilegoe. ");
INSERT INTO cuk09_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Degi suar-ibedmar, degine, e-dummad, degine, Judiomar-Bab-Dummadse-goled-neg-suar-ibmala Jesús-gasmarsun, geb degi Jesús-edichamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anás-nugadse Jesús-sesmargweled, ar ade Caifás-e-sakad. Ar deun a-birgagi Caifás, dule-irwa-Bab-Dummadse-gormalad-bur-dummadga maid. ");
INSERT INTO cuk09_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ar we-dule Caifás, deun Judiomarga binsaed uksadid, deun sogsa-gusgu: “Ar dule-wargwen neggwebur-anar bur burgwer nabirye.” ");
INSERT INTO cuk09_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús-sorba nadap-gusmalad, e-sapin-wargwen, degi, Simón-Pedro. We-sapin-wargwende, dule-irwa-Bab-Dummadse-gormalad-bur-dummad mag-daked. We-sapinde Jesúsba dule-irwa-Bab-Dummadse-gormalad-bur-dummad-e-neg-imbase dogsamogad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ar Pedrodi magaba gwisgusad, yawagak-naba. Sapin-wargwen, dule-irwa-Bab-Dummadse-gormalad-bur-dummad-mag-dakedi magaba noalid, geb ome-yawagak-dakedga sunmaksagu, neg-yaba Pedro-odosad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Geb degi ome-yawagak-dakedi Pedroga sokalid: —¿Ar be Jesús-e-sapinmosursi? Pedro, abin-sogded: —Suli, an e-sapinsuli. ");
INSERT INTO cuk09_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Agine, maigan, degi, suar-ibmala-Bab-Dummadse-goled-neg-dakmaladi, gwichimalad. Amarde soo ogasmalad, ar ade neg-damberbad. Amar deun soogi wabukmargu, amar-abargi Pedro gwichigusmogad, soogi waegar. ");
INSERT INTO cuk09_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad, Jesússe e-sapingan-egichialid, degine, e-ibmar-odurdakdiid ese egichiarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús, abin-sogded: —An-sunmaksadi bela bakar-buud dulemar-asabin an sunmaksad. An gusgu Judiomar-onmaked-neggi, degi, Bab-Dummadse-goled-neggi an ibmar-odurdaksad, bia Judiomar ambikunoni-daedgi. An-sunmaksadi, dukuar an sunmaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ar ibiga be anse egissunna? Be egise, dulemar-an-itosmaladse, igi an sunmaksa. Ar amar wisid igi an sogsa. ");
INSERT INTO cuk09_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ar Jesús degi-sogsagua, Bab-Dummadse-goled-neg-daked-suar-ibed-wargwen, Jesús-walik gwichidi, wagargi Jesús-bibyosgu, ega sogded: —¿Ar weyob be dule-irwa-Bab-Dummadse-gormalad-bur-dummad-abinsade? ");
INSERT INTO cuk09_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús, abin-sogded: —Ar noar an ibmar sogsale, be an-barsogdo ibigi noar an sogsa. Ar ibmar nabir an sogsardi, ¿ibiga be an-sarsosunna? ");
INSERT INTO cuk09_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Degi, Anás atinnar Jesús-barmissun, dule-irwa-Bab-Dummadse-gormalad-bur-dummadse, Caifás-nugadse. ");
INSERT INTO cuk09_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ar deun Pedrodi soo-naba amba wagwichi, agi ega sogdemalad: —¿Ar be we Jesús-e-sapin-wargwenmosursi? Degi Pedro osulod abin-sogded: —Suli, an a-e-sapinsuli. ");
INSERT INTO cuk09_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dule-irwa-Bab-Dummadse-gormalad-bur-dummad-mai-wargwen, Pedro dule-wargwen-ibe uaya-siksad-e-gwenad, a-dule Pedroga sokalid: —¿Ar be an be-daksasursi sapimar-digar-naidgi Jesúsba gudii? ");
INSERT INTO cuk09_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro gannar osulodbalid, geb agi gannir yog namakaled. ");
INSERT INTO cuk09_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Geb degi Caifás-neggi gunanaid, Jesús-sesmar, Pilato-neg-Pretorio-nugadse. Deun bato oibodanikid. Judio-dummagan melle na ised nikuegala, yapa Pilato-negse doggusmalad, adi nabir Judiomar-ibagi sibad-wawaad-gunmalagar. We-sibad-wawaad gundamalad Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Ibagi. ");
INSERT INTO cuk09_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Degi Pilato Judiomarse nononisun, ega sogdesun: —¿Degite ibi-ular we-dulede be anse sedanimarsunna? ¿Ibi oakalossunna? ");
INSERT INTO cuk09_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Abin-sogdemar: —Ar we dule-iskana-sulina, anmar bese sear-sulinad. ");
INSERT INTO cuk09_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Geb degi, Pilato Judio-dummaganga sogdesun: —Ar na be sumar, be-igar-maidba ega igar na be amimarsun. Judiomar, abin-imakdemalad: —An geg gumalad. Bemar-Roma-dulemar anmarga igar-uksasulid, dule-iskudimalad-oburgo-deeye. ");
INSERT INTO cuk09_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús-ibmar-sogsadba guegala, deyob gusad, ar ade sogsa-gusad, ede igi burgoe. ");
INSERT INTO cuk09_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Geb degi Pilato e-neg-Pretorio-nugadse gannar dogdebarsunnad, degi, Jesússe gordapid, ega sogded: —¿Ar be Judiomar-E-Rey-sunnadi? ");
INSERT INTO cuk09_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús, abin-sogded: —¿Ar na be dukin soge, igi, dule-baid-bega-sogedba be soge? ");
INSERT INTO cuk09_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato, abin-sogded: —¿Ar an Judio be an-daksii? Be-dulemar, degi, dule-irwa-Bab-Dummadse-gormalad-e-dummagan ar anga be-uksamalad. ¿Ar ibu be oakalossunna? ");
INSERT INTO cuk09_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús, abin-imakde: —Ar an Reyga-gued-igar we-napnegginedsulid, ar we-napnegginedina an-sordamar an-bina urwemaloenad, adi melle Judiomarse an-galegegar. Ar emigindi an na neg-gaoedi we-napnegginedsulid. ");
INSERT INTO cuk09_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Geb degi Pilato ega sogdesun: —¿Ar degisoggu, be reysunde? Jesús, abin-sogded: —Ar bede soged, an reyye. Ar a-ular an gwalulesad, degine, a-ular an we-napnegse nonikid, adi igar-napiragwadgi sunmakegar. Ar dule igar-napiragwad-sordale, an-gaya-burba-sogedba dado. ");
INSERT INTO cuk09_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Geb Pilato ega sogded: —¿Ar ibu igar-napiragwadsunna? Ar deyob Pilato Jesúsga sogsagu, gannar magaba Judiomarse noalid, amarga sokalid: —Ar we-dule gwen ibmar-oakalos an daksulid. ");
INSERT INTO cuk09_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ar bemar gusgu bemar-ibagi, anse egis damarsoggu, dule-wargwen-eskaryagi-mellesiid-onogegar, ¿ar bemarga an Judiomar-E-Rey-onobi be abemala? ");
INSERT INTO cuk09_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Geb degi bela gannar binnasur gotemarbalid, sogdemalad: —Suli, we melle be anmarga onomar, anmarga be onogedi, Barrabás. Barrabásde dakleargu, dule atursaed-duled. ");
INSERT INTO cuk09_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Geb degi Pilato Jesús-sesgua, Jesús-bibyogega imaksad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Geb degi suar-ibmala Jesúsgi dododmargu, iko-gurgin sobsamalad, geb Jesús-nonogi sismalad, rey-gurginyob, degi, ega mor-suir-akwagiid yosmarbalid, rey-moryob. ");
INSERT INTO cuk09_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Degi Jesúsga sogde-damalad, yamo egi dodoar: —Judiomar-E-Rey, be-nug dungusun. Degine, ei-wagar bibyos-damarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Geb degi Pilato gannar noarbargu, Judiomarga sogded: —Na be dakmar, an bemarse Jesús-sedanimalad, adi bemar mag dakmalagar, ar andi bipisaale iskued-gwen-nai an egi daksulid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Degi Jesús noarsun, iko-gurgin-sobaled sii, degi, mor-suir-akwagiid yoi. Geb degi Pilato emarga sogdesun: —Emigi we-dule be dakmar. ");
INSERT INTO cuk09_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Bab-Dummadse-goled-neg-suar-ibedmar Jesús-dakarmargu, binnasur oimakdemalad, sogdemalad: —¡Nakrusgi bioke, nakrusgi bioke! Geb Pilato emarga sogded: —Ar na be sumar, nakrusgi be biokmar, ar andi gwen iskus an daksulid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judiomar, Pilato-abin sogdemalad: —Anmar igar nikamalad, anmar-igar-maidba we burgwer-gebed, ar ade soged, an Bab-Dummad-Machiye. ");
INSERT INTO cuk09_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilato itoargu, dulemar deyob soge, aka-bur-bule dobe itoalid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Geb degi Pilato e-neg-Pretorio-nugadse gannar dogdebarsunnad. Agi Jesúsga sogdesunnad: —¿Be bialidi? Ar Jesúsdi gwen abin-imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Geb degi Pilato Jesúsga sogded: —¿Ar be anga sunmaksuli? ¿Ar be wichursi, an-sogedba igar-imakleged, nakrusgi be-biokega, degi, an-sogedba imaklebalid, be-onogegar? ");
INSERT INTO cuk09_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús, abin-sogded: —Ar Bab Dummad bega we-gangued uksasulina, be-sogedba angi ibmar imaklessuliled. Ar degisoggu, dule-bega-an-uksadi, a bur-bule nue iskusad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ar Pilato igar-aminai-gualid, Jesús-onogegar. Ar Judiomardi binnasur oimakbukwad, sogbukmalad: —Ar we-dule be onosale, Roma-saila, César-nugad, ar be a-e-aisurdo. Ar bela-dule na reyga san-saele, Césargi yolenai-daed. ");
INSERT INTO cuk09_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato itoargu, dulemar degi-soge, Jesús magaba onosad. Geb edi igar-itoged-gangi sigwisad, neg-akwa-biidye nugadgi, Hebreo-gayagindi Gabataye-nugad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Deunni yorukugusad, Judiomar-iba, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba bane-nagudoedgi. Geb degi Pilato Judiomarga sogdesun: —Emi be dakmar, bemar-e-Rey. ");
INSERT INTO cuk09_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ar Judiomardi oimakarmalad: —¡Oburgwed-sae, oburgwed-sae, nakrusgi bioked-sae! Pilato, abin-imakde, sogded: —¿Bemar-e-Rey nakrusgi an biokode? Dule-irwa-Bab-Dummadse-gormalad-e-dummagan, abin-sogdemalad: —Anmar rey-baid sulid, unnila Césarbi anmar-reyd. ");
INSERT INTO cuk09_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ar Pilato suar-ibmalaga Jesús-uksasun, nakrusgi biokmalagar. Suar-ibmala Jesús-susmargu, sesmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Geb degi Jesús dukin na e-nakrus semai nadsunnad, Dule-Nonogarye neg-nugadse, Hebreo-gayagindi Gólgotaye-bileged. ");
INSERT INTO cuk09_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Agi suar-ibmala nakrusgi Jesús-bioksamalad. Eba dule-walabo e-dikarba bioksamarmogad, Jesúsdi amar negabargi bioksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato Jesús-nakrus-birgi nasikega, nug narmaksad. Nug-narmakaled weyob sognaid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Weyob-narmakar-naid bukidar Judiomar absosmalad, ar ade Jesús nakrusgi-bioklesad neggwebur-walikagwad, degine, narmakar-naid Hebreo-gayaba, Griego-gayaba, degine, Latín-gayaba. ");
INSERT INTO cuk09_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Judiomar-irwa-Bab-Dummadse-gormalad-e-dummagan Pilatoga sogdemalad: —Mer be narmake: ‘We, Judiomar-E-Rey.’ Be narmake: ‘Ede Judiomar-E-Reyye soged.’ ");
INSERT INTO cuk09_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato, abin-sogded: —Ar an narmaksad, bato an narmaksado. An narmaksad, an ogwaosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ar suar-ibmala Jesús-nakrusgi-bioksamargu, e-mor susmalad, geb dule-warbake-wilub danar-danar urbismalad, adi sordamar-warbakegwad na egad-egad sumalagar. Degine, e-mor-aski-yolegeddi, ar unnila irgwen matar-dummadsoggu, ");
INSERT INTO cuk09_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","na ga sokarmalad: —Mer we-mor esirmakmalo, anmar wilubdakmaloed, ar mor doagadga guo-dibe. Weyob gusdo, ar adi Bab-Dummad-Gardagi-narmakar-naidba guegar. Ar Bab-Dummad-Gardagi weyob sognaid: An-mor na mimmismalad, degi, an-morgi wilubdaksamalad, adi doagadga guo-dibeye. Sal. 22:18 Ar weyob suar-ibmala imaksamardo. ");
INSERT INTO cuk09_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ar Jesús nakrus-walik bukwa-gusmalad: E-nan, degine e-nan-e-gwenad, María, Cleofas-e-ome, degine, María Magdalena. ");
INSERT INTO cuk09_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús na e-nan-dakargu, degi, e-sapin-wargwen na nue-sabedi, a-dakarbargu, na e-nanga sogded: —Omegwa, we be-machiga guoed. ");
INSERT INTO cuk09_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A-sorba Jesús e-sapinga sogdemogad: —Wegi, we be-nanga gumogoed. Ar a-ibagi yogsaar we-sapin na e-negse María-sear imaksad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","A-sorbali, ar Jesús na wissoggu, bela e-igargan bergusad, sogdesun, adi Bab-Dummad-Gardagi-narmakar-naidba guegar: —An uku-uku itoged. ");
INSERT INTO cuk09_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jesús-walikaa noggi vino-gaibid siid. Degi geb agi ibmar-buta-butadi owardikusad, geb hisopo-suargi edichagu, Jesús-gayagi nasiksamalad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús a-vino-gaibid gobsagu, sogded: —Bergussun. Geb degi Jesús nono dukin imakdegu, burgwissunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Deun dakargu, Bab-Dummad-Israel-Dulemar-Egiptogi-Wilebukwa-Onosad-Iba iduar guagwar-ambikued-iba naid. Ar we-obunnoged-iba, iba-dummadid. Mer obunnoged-ibagi nakrusgi-burgwenanaid nai gumalagala, Judio-dummagan Pilatogi wilenagusmalad, dulemar-nakrusgi-naid-ibe e-dua biskemalagar, adi gwae burgwemalagar. Geb degi nakrusgi-naid e-muimar odegegarbar. ");
INSERT INTO cuk09_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Geb degi suar-ibmala nonimarsunnad, geb wargwen-ibe dua bichismargu, baid Jesúsba-bioklesad-ibe dua bichismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ar Jesússedi nonimargu, bato burgwar-nai daknonimarsoggu, ei-e-dua bichissurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ar suar-ibed-wargwendi Jesús-dikargi espunyar-suidgi sikaa imaksad, geb degi abe diiba-mesa yog aryoar-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ar dule-we-daksad, ani, Juan, an bemarga soged. Ar an-ibmar-soged napiragwadid, gakansasulid, ar an na wisid, napiragwad an ibmar soged, adi bemar mer bengumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ar we ibmar-degi-gusadi, deyob gusad, adi Bab-Dummad-Gardagi-narmakar-naidba guegar: E-gar bipisaale gwen biskosulid. ");
INSERT INTO cuk09_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Deginbali, baidgi narmakar naibalid: Dulemar-espunyargi-ewarismalad a-dule-dakmaloed. ");
INSERT INTO cuk09_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Bela-wegi-gusad-sorbali, José, Arimateagined, Pilatose nonikid, egi wilenagusad, Jesús-burgwisad ega udagegar. We-Joséde Jesús-sapinmogad-wargwenad, ar edi na dukuar Jesús-sapinga gudiid, ar ade Judiomar-dobed. Pilato Joséga Jesús-uksasun. Geb degi José Jesús-nakrusgi-naidse nonigu, Jesús-e-mui sessun, neg-uanse dignaegar. ");
INSERT INTO cuk09_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Degi deun Nicodemo nonimogad, dule-Jesússe-mutik-nonigusad-dule. Nicodemo nibir-dulataled-ilagwen aidiku sapi-gunnugiid-wawaad senonikid. We sapi-gunnugiid-wawaad mirra, aloe-ebo oburaled. ");
INSERT INTO cuk09_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesús-e-mui susmargu, ina-wawaadba-mesa atue-sibugi Jesús-anwismalad, ar igi gusgu Judiomar na e-mui digdamaladyob imaksamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ar Jesús nakrusgi bioklesad-walik nainu-naid. Agi neg-uan-bini siid, dule-wargwensaar agi amba yo digleged. ");
INSERT INTO cuk09_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Agine, ar Judiomar-iba-idu bato guagwar-ambikued-iba omossoggu, deginbali, ar neg-uan agi itakabarsoggu, a-ular agi Jesús digsamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Gebe itoged-iba-onodedgi, wakudaryalaba, amba neg-sichi-sichigwa María-Magdalena neg-uanse nade-gusad. Neg-uanse modapgu, dakalid akwa-dummad onirar sii. ");
INSERT INTO cuk09_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Degi María-Magdalena abarmakded, Simón-Pedrose naded, degi, Jesús-sapin-baidse, Juanse, ar igid Jesús-na-e-sapin-nue-sabedse. Amarga sogdapid: —Anmar-Dummad-neg-uangi-digar-maid anmar-ibe sesmar, anmar emigindi wichurmalad bia mesismala. ");
INSERT INTO cuk09_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Geb degi Pedro, Jesús-sapin-baid-ebo, Juan-nugad, amala noarmalad, neg-uanse abarmaknonimalad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ebo neg-uanse dare abarmakarmar-inigwele, ar Jesús-sapin-baid Juan-nugad, a bur-binnasur abarmaksasoggu, a-inse neg-uanse noni-gusad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A-dule neg-uan-yaba nue dakega, dulluu imaksad. Dakdegu, dakar, atued-sipu bukwa. Ar edi neg-uan-yabardi dogsasulid. ");
INSERT INTO cuk09_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Geb degi Simón-Pedrodi sorba nonimogad. Neg-uan-yaba dogsagu, dakar, atued-sipu bukwa, ");
INSERT INTO cuk09_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","degine, daksabalid, mor-Jesús-nonogi-obirmaklesad atued-sipu-walik buksuli, nue-obipirmakar bachik bukwa. ");
INSERT INTO cuk09_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Geb degi Jesús-sapin-baid iduar-nonigusad, neg-uan-yaba dogsamosunnad. A-sapin daksagu, Jesús-mui sate, gwen bengussurmogad, Jesús gannar durgusad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ar ade Bab-Dummad-Gardagi-narmakaled amba yo nue mag itomalad, we-Jesús-burgwisad gannar durguer-gebye. ");
INSERT INTO cuk09_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Degi, wemar-Jesús-sapingan-warbogwad gannar negse nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ar Maríadi neg-uan-dikarba, neg-magaba bogwichid. Ar bogwisgua, nue neg-uan-yaba atakegala, dulluu imaksad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","María dulluu imaksagu, dakalid, angermar-warbo mor-sibu yoyoi, wargwen bia Jesús-megisad e-nono-inik sii, baiddi e-mali-duku-inik simogad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angermar Maríaga sogdemalad: —¿Omegwa, ibiga be boe? María, abin-sogded: —Ar an-Dummad an-ibe sesmalad, emigindi an wichulid, bia an-ibe mesismala. ");
INSERT INTO cuk09_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","María degi-sogsagua, aibiriargu, Jesús-e-walik gwichi dakalid. Ar ome wichursunnad, we Jesús e-walik gwichid. ");
INSERT INTO cuk09_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús ega sogded: —¿Omegwa, ibiga be boe? ¿Doa be amie? Ar ome, we dule-nainu-akwedye bisoggu, Jesúsga sogded: —Dummad, ar dule be sesale, anga be soge, bia be mesisa, adi an na sedegar. ");
INSERT INTO cuk09_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús ega sogded: —¡María! María Jesússik aibiris imasgu, ega sogded: —¡Raboni! (A sogleged, Odurdaked-Saila.) ");
INSERT INTO cuk09_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús Maríaga sogded: —Mer be an-ebu, ar amba yo an-Babse an nakwed. An-gwenadgansedi be nae, amarga be sogna: ‘An-Babse, degi bemar-Babse an nakwe-sokalid, an-Bab-Dummadse, degi, bemar-Bab-Dummadse.’ ");
INSERT INTO cuk09_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Degi María-Magdalena nadsun, Jesús-sapinganga sognaded: —Dummad an daksaye. Degine, igi Jesús ega sogsa-gusa, María bela amarga sogsabalid. ");
INSERT INTO cuk09_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A-ibagi mutikid-nagunonigu, gebe-itoged-iba nagudedgi, Jesús-sapingana na danar bukwa-gusmalad. Judiomar-dobed-ular bela yawagak-atibukwad. A-abargi Jesús ukiar magargunonikid. Jesús na e-sapinganga sogded: —¡Na, degite! Ulubgi bogidikid bemar itomarsun. ");
INSERT INTO cuk09_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ar Jesús e-sapinganga degi-sogsagu, emarga e-argan, degi, e-dikar oyoded. E-sapingan na e-Dummad-dakarmargu, bela weligwar ito nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Degi, gannar Jesús na e-sapinganga sogdebalid: —Ulubgi bogidik bemar itomarsun. Ar igi Bab an-barmiali, deyob an bemar-barmidmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ar Jesús emarga degi-sogsagu, e-burba amargi buu imaksagu, amarga sogdesun: —Bab Dummad Burba Nued bemar abingamarmosun. ");
INSERT INTO cuk09_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ar doamarga bemar iskued-osuloye sogele, amar iskued-suli gunonikoed. Ar doamarga bemar iskued-osulo-sulile, amar-iskued ega osulolegosurmogad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ar Tomásdi, e-ambe-gakabogwad-wargwen, Dídimoye-nugbalid, a-dule, Jesús nonigu, deun emar e-ambe-gakabogwadba sisulid. ");
INSERT INTO cuk09_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jesús-sapingan-baigan ega sogsamalad: —Anmar-Dummad, anmar daksamarye. Tomás, abin-sogded: Ar Jesús-argangi eskoro-yolesad-e-wilubgan an-sunnad an daksulile, degi, an-goo an agi odosulile, deginbali, an-argan e-dikargi an odosurbalile, gege an itoged. ");
INSERT INTO cuk09_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Itoged-irgwenad-sorba, Jesús-e-sapingana neg-yaba bela gannar bukwamaladgi Tomás eba sii-gusmogad. Deun bela yawagak-atibukwad-abargi Jesús ukiar na e-sapinganse magargunonikid. Amarga sogded: —¡Na, degite! Ulubgi bogidik bemar itomarsun. ");
INSERT INTO cuk09_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Geb degi Jesús Tomásga sogded: —Wegi be-goo be odoge, an-argan be dake. Degine, be-argan be seda, an-dikargi be ododage. Be an-bengusulir-gebed. An gannar durgusad mer be an-bengue. ");
INSERT INTO cuk09_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Geb degi Tomás, abin-imakde, sogded: —¡An-Dummad, degine, an-Bab-Dummadbar! ");
INSERT INTO cuk09_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús geb Tomásga sogded: —Be an-daksad-ular, be angi bengussulid. Ar dulemar-an-daksasurmaladdi, ar adi angi degite bengussurmaladdi, amar-dulemargi bur nued binsalesad. ");
INSERT INTO cuk09_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ar Jesús ibmar-wilubgan-dakledisurmalad bukidar e-sapingan-abargi imaksabalid, degite, we-gardagi bela narmakar naisulid. ");
INSERT INTO cuk09_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ar wemardi narmaklesad, adi bemar mer bengumalagar, we-Jesús, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-sunnadid, degine, we-Jesús, Bab-Dummad-Machi-sunnadbalid, adi bemar Jesúsgi-bensulidba burba-geg-bergued egi nikumalagar. ");
INSERT INTO cuk09_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","We-degi-gusad-sorbali, Jesús na e-sapinganse gannar magarosad, Tiberias-mata-dummad-gakaba. Weyob na magarosad: ");
INSERT INTO cuk09_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Deun danar na gudimalad, Simón-Pedro, Tomás, Dídimoye-nugbalid, Natanael, Caná Galileagined, Zebedeo-machimala, degine, Jesús-sapingan-baigan-warbobar. ");
INSERT INTO cuk09_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón-Pedro e-sordamarga sokalid: —Andi ua-ganagwelo. Emar ega sogdemarmogad: —Anmar beba namarmogoed. Degine, urgi nadmarsunnad. Deun a-mutik ua bipisaar gwen gassurmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ar bato neg-oibodanikidgi, Jesús mata-dummad-gakagi gudiid, ar e-sapingandi wichurmalad we Jesús-deeye. ");
INSERT INTO cuk09_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús amarga sogded: —Sapingan, ¿bemar ua-wis-gasmala? Abin-sogdemalad: —Suli. ");
INSERT INTO cuk09_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Geb Jesús amarga sogded: —Be saki be ur-argan-nuedsik mimar, geb agi bemar ua gamaloed. Geb degi saki mismargua, ar ua-bukidarad-ular, saki bene onakguarmalad. ");
INSERT INTO cuk09_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Geb degi Jesús-sapin-wargwen, na e-sapin-nue-sabedi, Pedroga sokalid: —¡Be dake, we Dummad-Jesús gudiid! Simón-Pedro itoargu, we Dummadye, e-mor-aski-yoleged yosaa imaksad, ar ade na mor esus-gunaid, geb degi Jesússe-naega demargi yog argwannar imaksad. ");
INSERT INTO cuk09_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ar Jesús-sapingan-baigandi urgi armalad, saki ua-ena ebipiarmalad, ar ade dogdar mata-gakagi dikasur gunaisurmalad, unnila mor-suar dulataled-irgwen-wilub-bangu gunanaid. ");
INSERT INTO cuk09_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jesús-sapingan gakase aidenonimargu, daknonimalad soo gasii, ua soo-birgi mai, degi, madu maibar. ");
INSERT INTO cuk09_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús amarga sogded: —Emi be ua-gasmalad wis sedamar. ");
INSERT INTO cuk09_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón-Pedro urgi nakwisad, degi saki, ua-dummagan-ena ebipialid, mata-gakase. Ua-dummagan dulagugle-gakambe-gakapaa (153) gasmalad. Ua ichesur-inigwele, saki gwen achirmaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús na e-sapinganga sogded: —Dagmar, mas gundagmar. Ar e-sapingan-wargwensaar gwen wis ese egisbi itossurmalad: “¿Be doa?” Ar ade wismalad, we Dummad-gudiid, Jesús. ");
INSERT INTO cuk09_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Geb Jesús madu susgua, e-sapinganga madu uksad, degi ua-susbargu, ua e-sapinganga uksabalid. ");
INSERT INTO cuk09_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ar Jesús burgwisgu, gannar-durgusad-sorba deun ilapaagus e-sapinganse na magaroed. ");
INSERT INTO cuk09_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Mas guchamargua, Jesús, Simón-Pedroga sogded: —Simón, be Jonás-machi, ¿be bur-bule wemarba be an-sabe? Pedro, abin-sogded: —Eye, Dummad, ar be wisid an be-sabed. Geb Jesús ega sogdesun: —An-dulemar sibad-wawaad-mimmiganyobid be anga akwena. ");
INSERT INTO cuk09_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Irbogwadgi gannar Jesús sogdebalid: —Simón, be Jonás-machi, ¿be an-sabe? Pedro, abin-sogded: —Eye, Dummad, be wisid an be-sabed. Geb Jesús, abin-sogded: —An-dulemar sibad-wawaadyobid nue be anga ako. ");
INSERT INTO cuk09_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Gannar irbaagwadgi Jesús sogdebar: —Simón, be Jonás-machi, ¿be an-sabe? Pedro bukib-ito naded, gannar irbaagus ega sogedba: “¿Be an-sabe?” Pedro, abin-sogded: —Dummad, ar bela ibmar be wisid, ar be wisid, an be-sabed. Jesús ega sogde: —An-dulemar sibad-wawaadyobid be anga akwena. ");
INSERT INTO cuk09_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jesús Simón-Pedroga sogdebar: “Napira an bega soged, be sapingwaunni, na be wargwen mor yo-daed, degi, bia-be-nabiedba na be nad-daed. Ar be sered gusardi, bega argan onakmaloed, degi, bega mor yomarbaloed, degine, be-sedmaloed, be nabisulidba.” ");
INSERT INTO cuk09_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","We Jesús degi-sogsadi, sogsa-gusdo, we igi Pedro oburgomaloedgi, Bab-Dummad-nug odummogoed. Weyob Jesús sogsagu, Pedroga sogdebar: —Anba be naiguo. ");
INSERT INTO cuk09_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro aibiriargu, dakar, Jesús-sapin-wargwen Jesús-na-nue-sabedi, igid napi sedo mas gunsigu e-dikarba sii-gusad, ese egichisad: “Dummad, ¿doa darba be ukoe?” ");
INSERT INTO cuk09_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro a-daksagu, Jesúsga sogded: —Dummad, ¿we-duledina? ");
INSERT INTO cuk09_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús ega sogded: —Ar we-dule an gannar-dagedse amba dula gudii an abegele, ¿ar be akar sogode? Ar bedi anba dage. ");
INSERT INTO cuk09_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","We-degi-soglesad, gwenadgan-abargi nasguddo, we Jesús-e-sapin burgosurye. Ar Jesús sogsasurdo: “We-sapin burgosurye.” Sogsado: “Ar we-dule an gannar-dagedse amba dula gudii an abegele, ¿ar be akar sogosi? Be akar sogosuli.” ");
INSERT INTO cuk09_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","We Jesús-sapin na ibmar daksad Juan-nugad bemarga sogdo, degine, we-ibmar narmaksado. Anmar wisdo, we-ibmar-sogedi, napiragwadid. ");
INSERT INTO cuk09_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ar Jesús ibmar-bukidar-imaksabalid, ar bela gwensak-gwensak narmakdele, an insagua, bela we-napneg-naid akusar an insado, gardamar-agi-narmakaled saboged. Be itomargua.");
INSERT INTO cuk09_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, gebesaila an garda narmaksadi, an narmaksado, igi Jesús we-napneggi gudigu, gebe ibmar-imaksadgi, degi, igi dulemar-odurdaksabalidgi. ");
INSERT INTO cuk09_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Geb degi Jesús nibnegse nakwidedse, ase an narmaksado. Emigindi an bega sogbalodo, Jesús yo nibnegse-nakwed-iduar na e-nuggi-barmilesmalad-susadga, Bab Dummad Burba Nuedbali ega sogsado ibu imakmaloe. ");
INSERT INTO cuk09_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús burgwisad-sorbali, na e-sapinganse magarodii nanasad, adi na sogmalaga, Jesús nue dula gudiiye. Iba-dulabo e-sapinganse na san oyodii-gusad, degine, Bab-Dummad-neg-dakmaidgi ega sunmakdii-gusbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesús na e-sapingan-abargi amba gudigu, amarga sogsa-gusad: “Mer Jerusaléngi bemar bangumargweloye. Igi ar bato an bemarga sogsa, Bab Dummad na E-Burba-Nued bemarga ukoed. Degisoggu, Bab-Dummad-Burba-Nued-nonikidse geb bemar Jerusaléngi bangudmaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ar Juan-Bautistadi Bab-Dummad-digi-ogleged-igar-imaksadi unnila diginbi dulemar-ogsad. Emiskwaa ibagan-danikoedgindi Bab Dummad Burba Nuedgi bemardi oglemaloed.” ");
INSERT INTO cuk09_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Bela Jesús-walik danakwaa bukwamaladi, Jesússe egichiarmar, ega sogdemar: —Degite, Dummad, ¿epenne Israel na yar bachikii ganigusadyob, we-ibagangi gannar deyob ega be ukoe? ");
INSERT INTO cuk09_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús, abin-sogde: —We-ibagan bemar wisguedsurmalad, ar unnila Bab na e-ganguedgi ibagan mesisad, na ebi wisid, sana we-ibagan deyob guoe. ");
INSERT INTO cuk09_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bab Dummad Burba Nued bemargi aidenonikile, agi bemar gangudmaloed, degine, geb bemar an-barsogdemaloed, gebe Jerusaléngi, agi bela Judea-yalaganba, degi, Samaria-yalaba, geb degi bela we-napneg-naid-ugakase. ");
INSERT INTO cuk09_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jesús wegi-ibmar-sogsad-sorba, e-sapingan amba dakbukwa, nibnegse Jesús seled-gusad, degi, mogir-darba emargi yoggudsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Amba e-sapingan niba atakbukwa, Jesús igi niba nakwemaid dakbukwa, dule-warbo, mola-sibu-yoi e-dikarba gwichi dakarmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Amar Jesús-sapinganga sokarmalad: —Galilea-sapingana, ¿ibiga bemar niba atakbukmala? We-Jesús igi bemargi sulesa, igi niba nakwid bemar daksamala, ayob we-Jesús-sunnad, napnegse gannar danikoed. ");
INSERT INTO cuk09_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Degi Jesús-sapingan Olivos-yar-nugad-birgi bukwa, gannar Jerusalénse nonimalad. A-yar dogdar Jerusaléngi dikasur sisulid, nabir obunnoged-ibagi minuto-irambe nanaleged-wilub egi siid. ");
INSERT INTO cuk09_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalén-neggweburse dognonimargu, bia neggi aila-niba na ambikusmaladse nonimalad. A-neggi mamaimalad: Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Santiago Alfeo-machi, Simón Zelote, degi, Judas, Santiago-e-mesad. ");
INSERT INTO cuk09_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jesús-urbamar nonidamarmogad, degi, María, Jesús-e-nan, agi omegan-baiganmo. Wemar belagwapa na danar ambikunoni-damalad Bab Dummadse golega. ");
INSERT INTO cuk09_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Deun gwenadgan-e-dulanergwasaar ambikunonimalad-abargi Pedro gwisgusgu, sogded: ");
INSERT INTO cuk09_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Gwenadgan, epenne Bab Dummad Burba Nued, Davidba bato sunmaksad, Judas-Iscariotegi. Bab-Dummad-Gardagi narmakar-naidba guegala, Judas dulemar-idumai-gusad, adi Jesús-gaegar. ");
INSERT INTO cuk09_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasde anmar sordamoganad, anmar-arbaedgi arbanai-gusmoganad. ");
INSERT INTO cuk09_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","We-Judas, Jesús-uksad-manigi nainu baksa-gusad. Agi Judas niba-nai argwannargu, saban-marid bela e-samur bupunmakde-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Belagwapa Jerusalénginmalad wisguarmargu, a-nainu e-gayaba onugsasmalad: Acéldama. A sogleged, Nainu-Abebiid. ");
INSERT INTO cuk09_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bato Salmosgi narmakar sognaid: A-neg metemaloed, aginbali, dule a-neggi bar megosulid. Sal. 69:25 Degine, sogbalid: Dule-baid a-sorba e-gan suoye, adi a-dule arbaegar. ");
INSERT INTO cuk09_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Degisoggu, dule-wargwen anmar Judas-sorba amier-gebed. Dummad-Jesús-anmar-abargi-gudigusgu, dule anmarba bipirmakdii-gusad, ");
INSERT INTO cuk09_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan Bab-Dummad-digi-ogleged-igar Jesúsga imaksad-akar anmarba gudigusmogad, Jesús nibnegse-nakwidedse. Dule degi-anmarba-gudigusad, a anmar suer-gebed. Adi a-dule sogmogagar, Jesús-burgwis-gusad gannar durgusbarye.” ");
INSERT INTO cuk09_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Degisoggu, warbo dulemar-amismarsun: José, Barsabásye-nugbalid, a bimarbalid, Justo, degi, Matías. ");
INSERT INTO cuk09_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Dulemar-bukmalad Bab Dummadse gotemargu, sogdemalad: “Bab Dummad, bedi bela dulemar-gwage mag daksoggu, anmarga be oyoge, we-ebogwad, biti bur be susadi, ");
INSERT INTO cuk09_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","adi anmarba arbaegar, Jesús-nuggi-barmilealidga gumogagar, Judas-ular dogegar. Ar Judasdi e-iskusad-ular we-igargi node-gusad na e-negse naegar, soo-sailase.” ");
INSERT INTO cuk09_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Degine, bulakwaa na suarmarsun, dakega, doa bur sulegoe. Wilubdaksamargu, daklear, Matías sules, geb a Jesús-nuggi-barmilealidga e-ambe-gakagwensakadba nugsalesmosunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés-Iba nonigu, bela Bab-Jesúsba-nanaimalad danakwaa na bukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ukiar nibneggi burwa-binnasur-goleyob gornonikid, bela emar-bukwadgi eunonikid. ");
INSERT INTO cuk09_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Degi daklealid ibmar soo-ditismakedyob ditismakdegu, belagwapa dulemar-irba signonikid. ");
INSERT INTO cuk09_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Belagwapa Bab Dummad Burba Nued bela-bela Jesúsba-nanaimaladgi ubononigu, gangudmalad, gaya akar-akar sunmakdemalad, ar igi Bab Dummad Burba Nued ega sogedba, aba sunmakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Deunni bela Judiomar-we-napneg-naid-ugakse-bukmalad nue-islikwaa-nanadimaladi Jerusalénse nonigusmalad, iba dakegar. ");
INSERT INTO cuk09_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","A-dulemar ibmar binnasur gote itoarmargu, bela danar ambikunonimalad. Agine, geger Bab-Jesúsba-nanaimalad-dakdemalad, ar ade dule-gaya-baid-baid-sunmakmalad itoarmalad Jesúsba-nanaimalad emar sunnaa sunmakmala. ");
INSERT INTO cuk09_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Degisoggu, bela geger dakdemarsundo, degi, aku-itomarbarsundo, wede igidbarsunna. Degisoggu, na sokarmarsundo: “Be dake, ¿wemarde sunmakbukmaladde Galilea-dorgansursi? ");
INSERT INTO cuk09_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ibiga wemarde nabir anmar na-gin-gwalulesad-gaya sunmakmarsunna? ");
INSERT INTO cuk09_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","“Anmardi Partia-dorgan, Media-dorgan, Elam-dorgan, degi, anmar Mesopotamiagi-bukwamalad, Judeaginmalad, Capadociaginmalad, Pontoginmalad, degi, Asiaginmalad, ");
INSERT INTO cuk09_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiaginmalad, degi, Panfiliaginmalad, agi, Egiptoginmalad, agi, Libia-dor-Cireneginmalad, degi, Roma-akar-danimalad, Judiomar, degi, Judio-igarba-dogsamalad, ");
INSERT INTO cuk09_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","degi, Cretaginmalad, Arabiaginmalad. Emide wemar-Galilea-dorgan, nabir anmar-gayaba Bab Dummad ibmar-geger-daklemalad imaksadgi sunmakmargu.” ");
INSERT INTO cuk09_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Degisoggu, belagwapa geger dakmalad, degi, aku itomarbalid, aga na muchub-muchub ega sokarmarsunnad: “¿Wede igid barsunna, gaya akar-akar sunmakmargu?” ");
INSERT INTO cuk09_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Degisoggu, abala Bab-Jesúsba-nanaimaladgi dododmar, sogdemarsun: “Wemardi mummu-bukwamalad.” ");
INSERT INTO cuk09_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Degi Pedro na e-ambe-gakagwensakad-gwichid-abargi gwichimoga, binnasur sunmakde, sogded: “Judea-dorgan, degi, bela bemar-Jerusalén-neggweburgi-bukwamalad, nue be an-itomalo. An bemarga sogodo, wede ibi nue obarsunna. ");
INSERT INTO cuk09_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","We-dulemar bemar mummuye bimaladi, mummusurmalad, ar amba neg wagdarad. ¿Dulemar neg-wagdar mungudii bemar dakdisi? Degisoggu, noar be sogmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Ar wemar bemar dakedi, bato Joel, Bab-Dummad-gaya-burba-berbeged sogsa-gusad: ");
INSERT INTO cuk09_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Bab Dummad soged: ‘We-napa-naid-ibagan-bergued mosale, An-Burba-Nued bela dulemargi an odegoed. Be-masmala, degi, be-bunamala, an-gaya-burba barsogmaloed, degi, be-sapingana ibya-apuredgii ibmar dake-gumaloed, degi, be-sergan gabdakedgi nabir ibmar dake-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Degi, a-ibagangi an-maigan-machergangi, agi, an-maigan-omegangi, An-Burba-Nued an odegoed. Geb amar an-gaya-burba-barsogega gudmaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Degine, nibneggi ibmar-geger-daklemalad an oyogoed, agine, we-napneggi ibmar-dakledisurmalad an oyobaloed; abe, soo, degine, waa booyobi bela neg-gaoed. ");
INSERT INTO cuk09_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Dad-ibeler a-ibagangindi bar gaosulid, agine, nii abeyob ginnidbi nagumogoed, Bab-Dummad-ibagan-danikoed-iduar, deyob neg guoed, dummarba neg degi-oyolegoed. ");
INSERT INTO cuk09_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ar ade doa-dule, Bab Dummadse abonoleged egisbiele, a-dule abonolegodo.’ ” ");
INSERT INTO cuk09_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro sogdebar: “Israel-dorgan, we an-bemarga-ibmar-sogoedi nue baritomalo: Jesús Nazaret-dola, bemardi nue wismalad, bemar-abargi Bab-Dummad-nuggi ibmar-dakledisurmaladi, ibmar-geger-daklemalad-wilubgan oyosad, ar a bemar bela-wisi bukwamalad, adi bemar dakega, na doa-dule gue. ");
INSERT INTO cuk09_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ar igi Bab Dummad na iduar igar-mesisadgii, bemarga Jesús uklenonigu, bemar gasmargu, dule-iskanamar bemar-bendaksadba nakrusgi be Jesús-bioksamalad, oburgwegar. ");
INSERT INTO cuk09_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","“Degi-inigwele, Bab Dummaddi Jesús-odulosad, burgwed-nunmaked-abargi ogwichisad, ar ade burgwed Jesúsgi geg obined. ");
INSERT INTO cuk09_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","A-ular, David Bab Dummadgi wegi-sogsa-gusad: Dule-Dummad an-idudii an dakdiguad, an-argan-nuedsik gudii, adi mer ibmar dobee an itogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Degisoggu, an-gwagegi an wergusun, weligwar an sunmaksun, degi, bela an-san unnila gannar durguoed bensuli edarbesun. ");
INSERT INTO cuk09_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Aga uangi an-san-burba gwen be oyogsaosulid, ar be-mai-gwage-swilidikid-e-san gwen uangi onunsaega be imakosulid. ");
INSERT INTO cuk09_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Be anga igar-nuegan dula-saila gudigued oyosad, degi, be anba gudidbali weligwar an itoged.” ");
INSERT INTO cuk09_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro sogdebar: “Gwenadgan, bela anmar wisid, anmar-dad-David-nugad burgwisad, degine, diglesad, agi e-neg-uan emi amba anmar-abargi daklediid. Degisoggu, David na e-sangi sunmaksasurdo. ");
INSERT INTO cuk09_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","“Ar David Bab-Dummad-gaya-burba-berbegedsoggu, nue wissunnad, igi Bab Dummad ega sogsagusa, gege-bar-osuloged-igargi ega sogsagu: Yoedse be-wagwa-wargwen beyobi reyga megmogoye. ");
INSERT INTO cuk09_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Degisoggu, bato daknaiyobi, David sogsad Cristo gannar durguoedgi. David deun weyob sogsa-gusad: ‘Bab-Dummad-dule-wargwen-bega-barmidagoye-sogsad-dule neg-uangi sadegu mai-guosulid, degine, agi nungumai-guosurbalid.’ ");
INSERT INTO cuk09_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“A-Jesús-sunnad, Bab Dummad gannar odulosad. Jesús-gannar-durgusad, bela anmar daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Degisoggu, Bab-Dummad-argan-nuedsik dummadga Jesús sigidapsunnad, degi, Bab Dummad Burba Nued ukoye sogsadi Jesúsga uklessunnad, geb A-Burba-Nued, Jesús anmarga uknaimogad. A-igar bemar daksamaladi, degi, itosmaladi, Jesúsgi bela danikid. ");
INSERT INTO cuk09_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ar ade David nibnegse nakwissulid, degite David-sunnad sogbalid: Bab Dummad an-Dummadga soged: ‘An-argan-nuedsik be sige, ");
INSERT INTO cuk09_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","bela be-istarmaladgi be nakwedse.’ ");
INSERT INTO cuk09_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Degisoggu, bela bemar-Israel-dorgan, nue itomarsun, napira an bemarga sogmalad, we Jesús bemar nakrusgine-oburgwismaladi, a-Jesús-sunnadi Bab Dummad Dule-Dummadga imaksad, degi, Cristoga imaksabalid.” ");
INSERT INTO cuk09_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Dulemar-Pedro-itobukmalad deyob Pedro soge itosmargu, nue gwagegi bukib itodmalad. Pedrose, degi, baigan-Jesús-nuggi-barmilearmaladse egichiarmarsunnad: —Degite gwenadgan, ¿igi anmar saer nabirsunna? ");
INSERT INTO cuk09_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro, abin-imakded: —Be-iskudiidga na be wargwen-wargwen bukib binsamar, degi, egi be bangumar, geb degi Bab Dummadse be dagmar, degi, Bab-Dummad-digi-ogleged-igar be Jesucristo-nuggi imakmarsun, adi Bab Dummad be-iskudiid bemarga eliegar, geb adi E-Burba-Nued bemarga ukegar. ");
INSERT INTO cuk09_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","“Ar Bab Dummad E-Burba-Nued bemarga ukoye sogsadi, ar bemarga ukegalad, degi, be-mimmiganga, degi, dulemar-dikasur-Bab-Dummadgi-gudimaladga, ar doa-dulemarse Dummad, anmar-Bab-Dummad na gorbiedse.” ");
INSERT INTO cuk09_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Deyob Pedro suibaksaar Jesús-igargi sunmakgwisgu, aimarga binsaed-nued-ukgwichi sogdebar: “Bemar we-dulemar-iskudididgi be bangumarsun, adi we-dulemar-iskanaba mer sabsur Bab Dummadse bemar odurdaklemalagar.” ");
INSERT INTO cuk09_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Dulemar Pedro-ibmar-sogsadba igar imaksamaladi, Bab-Jesús-digi-ogleged-igar imaksamarsunnad. Bab-Jesúsba-nanaimaladba a-ibagi milipaa-gubin eba nagusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Amar unnila Bab-Jesús-nuggi-barmilesmalad-e-odurdakedba nanabukwa-gusmalad. Degi, bulakwaa na muchub-muchub bendakbukwa, Bab Dummadse gorbukwa, degi, Bab-Jesús-burgwisad insaegala danakwaa na madu gunbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bela geger Bab-Jesúsba-nanaimalad-dakbukwa-gusmalad, ar ade Jesús-nuggi-barmilesmalad bukidar ibmar-geger-daklemalad, degine, ibmar-wilubgan-imakledisurmalad imakbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Bela Bab-Jesúsgi-bensurmalad danakwaa na bipirmakdii-guarmalad, degi, e-ibmar-nikamaladi muchub-muchub na ega uknanai-guarmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nainu-nikamalad na uknanai-guarmalad, degi, ibmar bela uknanai-guarmalad, geb a-mani na mimminanai-guarmalad, na ibmar abegedba. ");
INSERT INTO cuk09_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bab-Jesúsba-nanaimalad bane-bane Bab-Dummadse-goled-neggi na ambikubimaladba ambikubukwa, degi, na muchub-muchub neg-irba na madu mimmibukwa, weligwaledgi, danakwaa na gwagegi yeer-itogedgi na mas gunbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Amar Bab-Dummad-nug ogannobukwa, degi, dulemar, nabir Bab-Jesúsba-nanaimalad-dakbukwa-gusmalad. Degine, Bab Dummad bane-bane dulemar-gwage-abonolesmalad ega omelomai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ibagwengine, Bab-Dummadse-goled-wachigi, Pedro, Juan-ebo Bab-Dummadse-goled-negse sedo wachi-ilapaagi nadap-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Deunni Bab-Dummadse-goled-neg-yawagak, Yeer-Daklegedye-nugad-naba dule-wargwen mellesii-gusad. We-dulede gwalulesad-akar gusgu geg nanaed. Bane-bane Bab-Dummadse-goled-neg-yawagak-naba sinoni-damalad, adi dulemar-bela-ubomaidse mani egisegar. ");
INSERT INTO cuk09_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dule-geg-nanaed, Pedro, Juan-ebo Bab-Dummadse-goled-negse dogmai dakargu, amarse mani egichialid. ");
INSERT INTO cuk09_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro, Juan-ebo nue-nuu dakdemargu, geb Pedro ega sogded: —Nue be anmar-dake. ");
INSERT INTO cuk09_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Dule-geg-nanaed nue-nuu daksigis, ar mani ega ukoye bienad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedrodi ega sogded: —An mani sate, degi, olo satebar, degi-inigwele, an ibmar-nikad an bega ukoed: Jesucristo-Nazaretgined-nuggi, be gwisgu, yog be nanaar-sae. ");
INSERT INTO cuk09_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Deyob Pedro ega sogsagu, dule-argan-nuedsik gasa imasgu, ogwichiis imaksad. Agi yog e-nag gannaleded, degi, e-mali-garbirgwa yog nuguar-naded. ");
INSERT INTO cuk09_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Dule-geg-nanaed ichomakdegu, yog gwisguar imaksad-sorba, yog nanaar-naded. A-sorba dule-nugusad, Pedro, degi, Juanmala Bab-Dummadse-goled-negse dogdemalad. Dule-nugusad ganna-ganna nadapi, ichomakmai, degi, Bab-Dummad-nug odummonai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bela dulemar daksamalad, dule-nugusad igi ganna-ganna nadap-gusa, degi, igi Bab-Dummad-nug ogannonai-gusbali. ");
INSERT INTO cuk09_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Degisoggu, bela geger dakdemalad, degine, nue aku itomarbalid, wede igi gusa, ar ade wismalad, we-dule Bab-Dummadse-goled-neg-yawagak, Yeer-Daklegedye-nugad-naba sii-daed, mani emarse egichi-daed-duled. ");
INSERT INTO cuk09_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Dule-geg-gusgu-nanaed-nugusadi, Pedro, degi, Juan, amargi akani, geg indakgusad. Geb degi bela dulemar duurmaknonimalad Babse-goled-neg-ubebse, Salomónye-nugadse, ar ade agi gunanaimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro deyob dulemar-dakargu, sogdesun: “Israel-dorgan, ¿ibiga bemar geger dakmarsunna? ¿Ar ibiga bemar nuu anmar-dake, anmar Bab-Dummadba-nued-nanaed-ular we-dule-nudaksadyob? Ar we-dule anmar-ganguedgi anmarde gwen nudaksasulid, Jesús-Nazaretgined-nuggi anmar nudaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","“Anmar-dadgan, Abraham, Isaac, Jacob, amar-Bab-Dummad, na E-Machi-Jesús-nug odummosad. A-Jesús-oburgwega, Dummad-Pilatoga bemar uksa-gusmalad. Deun Pilato Jesús-onobiguargu, onogega bemar gwen imaksasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Bemar a-Jesús Dule-Gwage-Swilidikid, Dule-Igar-Napiragwadba-Ibmar-Imaked, a bemar egichissurmalad. Bur dule-iskana, dulemar-oburgwisad, a bemar Pilatose egichismalad bemarga onogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Deyob bemar dulega-san-burba-ukedi oburgwis-gusmalad. Degi-inigwele, Bab Dummad, Jesús-burgwarmaigu odurgusad. A-durgusad, bela anmar-ibyanugi anmar daksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Emide, we-dule nugus bemar dakedi, bemar nue wisidi, we Jesús-sunnad-nuggi-bensulidba nugusad. A Jesúsgi bensursoggu, we-dule nue nudakles bemar daksunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Gwenadgan, ar an wisid, bemar aku-neg-itomaladba Jesús-oburgwis-gusmalad, igi be-dummagan imaksamogadyob. ");
INSERT INTO cuk09_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","We degi-gusad, ar Bab Dummad bato idu anmarga E-gaya-burba-berbemaladba, sogsa-gusad, an-Machi-Cristo nue wilegoye. Agala deyob gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Degisoggu, be-iskudiidga, ulubgi na be bukib binsamar, be-daed be ogwamarsun, Bab Dummadse gannar be dagmarsun, be-iskudiid bega osulogegar, adi Bab Dummad bemar-weligwar-imakedgi bemarga gwage-bogidikid ukegar. ");
INSERT INTO cuk09_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Adi Bab Dummad, Cristo bato bemarga iduar uklegoye soglesad, barmidagegar. Ar a, Jesucristodo. ");
INSERT INTO cuk09_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Emidi a-Jesucristo bina nibneggi meggweler-gebed, bela Bab Dummad ibmar nue nudakedse. Ar deyob bato Bab Dummad epenne E-gaya-burba-berbemalad-gwage-swilidikmaladba sogsa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Degisoggu, Moisés anmar-dadganga sogsa-gusad. Dummad, bemar-Bab-Dummad, igi bemar-abargi an-susa, deyob bemar-abargi E-gaya-burba-berbeged-subaloed. Igi bemarga sogdagoe, a-dule nue be itomalo. ");
INSERT INTO cuk09_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ar doamar we-Bab-Dummad-gaya-burba-berbeged-sogedba ibmar imaksulile, Bab Dummad a-dulemar bemar-abargi oburgwemaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Degisoggu, bela Bab-Dummad-gaya-burba-berbemaladi, Samuel-akar, Cristogi bato iduar we-ibagangi sunmaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Bemar Bab-Dummad-gaya-burba-berbemalad-e-wagan-gumarsoggu, Bab Dummad E-gaya-burba-berbemaladga ibmar-sogsadi bemargadmogad. Agi Bab Dummad anmar-dadgan-ebo igar nabosad, deun Abrahamga sogsa-gusgu: Be-wagwa dulemar-bela-akar-akar-we-napneggi bukmaladga ib-nuedga guoye. ");
INSERT INTO cuk09_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Degisoggu, Bab Dummad na E-Machi-burgwar-maid odulosad-sorba, bemarse-inse barminonisunnad, adi ib-nuedga bemarga guegar, mer iskuedgi bemar bar nanaegar.” ");
INSERT INTO cuk09_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro, Juan-ebo amba dulemarga sunmakgwichi, dule-irwa-Bab-Dummadse-gormalad, degi, Bab-Dummadse-goled-neg-edarbed-e-dummad, degine, Saduceomala, Pedrose, degi, Juanse nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Amar nue sae-itomalad, ar ade Pedro, Juan-ebogwa aimar-odurdaknanaid, Jesúsgi gannar-durgued-igar nue maiye, ar Jesús gannar durgusaddeye. ");
INSERT INTO cuk09_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Degisoggu, dummagan Pedro, degi, Juan-ebogwa gasmarsun, geb eskaryagi metemarsun, ar bato neg-sedodsoggu, Pedro, Juan-ebogwa eskaryagi-sii oiboarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Dulemar-bukidar Bab-Jesús-igar-itosmalad Bab-Jesúsgi bensur-gunonimalad. A-ibagi unnila macherganbi ebisdele, miliatar-gubin Bab-Jesúsba-nagusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Banedgine, Jerusaléngi Judio-dummagan-neg-semamaid, degine, Judiomar-girmar-dummagan, degi, escribamar ambikunonimarsun, igar-itogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anás nonigusmogad, ar ade deun Anás, dule-irwa-Bab-Dummadse-gormalad-bur-dummadga-maid, degi, Caifás, Juan, Alejandro, degine, dule-irwa-Bab-Dummadse-gormalad-dummagan-e-gwenadgan bela nonigusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Geb degi dummagan Pedrose, degi, Juanse gochamarsun. E-abarse gwisgunonimargu, ese egichidmalad: “¿Doa-sogedba, degi, doa-nuggi wede bemar dule-nudaksamala?” ");
INSERT INTO cuk09_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Degi Pedro nue Bab-Dummad-Burba-Nued-nika sunmakded, sogded: “Neggwebur-dummagan, degi, girmar-dummagan, bemar Judiomar-neg-dakmamaid, ");
INSERT INTO cuk09_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ar emi bemar anmarse egismarsoggu, we dule-bonigwaled ibmar-nued ega imaklesadgi, wede igi we nudaklesye. ");
INSERT INTO cuk09_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Degisoggu, bemar-asabin nue anmar bemarga sogodo, adi bela Israel-dulemar wisgumarmogagar, we-dule bemar-abargi nue-nugus gwichi be dakmaladi, Jesucristo-Nazaretgined-nuggi nugusad. A-Jesucristo bemar nakrusgi bioksa-gusmaladi, Bab Dummad gannar odurgusad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","We-Jesús, akwa-iskanayob bemar-neg-sobmalad daksamalad, ar emigindi we-akwa bur-nuedga gunonikid, neg-gaedgar. Sal. 118:22 Degisoggu, we-Jesús bur Dule-Dummadga gunonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Degisoggu, dule-baid-nuggi geg anmar abonoleged. Ar we-napneggi dule-baid anmarga uklessulid, anmar egi abonolegegar, unnila Jesús-nugginbi anmar sunna abonoleged.” ");
INSERT INTO cuk09_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Dummagan dakarmargu, Pedro, degi, Juan, dobsuli ibmar soge-soge gwichi, geger dakdemalad, ar ade wismalad we-dulemarde garda bipisaar wis-wismalad, degine, dule-binsarmaladid. Degi-inigwele, magar daksamalad, wemarde Jesúsba-gudidamalad. Degisoggu, a-ular binsaed-nikarba sunmakmarye-nik sogdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Deyob dule-geg-nanaed-nugusad amar-abargi gwichi dakarmargu, geg Pedro, degi, Juan-oakalogusmarsundo. ");
INSERT INTO cuk09_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Geb degi dummagan Pedroga, degi, Juanga sogdemarsunnad: —Wegi anmar-igar-itobukwad-abargi bemar wis nomargwerye. Emardi na besmalad, emarbi igar-itomalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Na ga sogdemarsun: —¿We-machergande igi anmar imakmalosunna? Bela wegi-Jerusaléngi-bukwamalad wismalad, dule-geg-nanaed-nudaksad. Ar wemar ibmar-wilubgan-dakdisurmalad-geger-dakleged imaksasoggu, ar anmar geg we osulomalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mer we-igar dulemar-abargi nasgumai-guegala, Pedrose, degi, Juanse anmar urwemalodo, adi mer Jesús-nuggi dulemar-baiganga bar sunmakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Degi geb dummagan Pedrose, Juanse, gochamarsun, geb amarga sogdemarsun: —Mer bar Jesús-nuggi sunmakmaloye, degine, a-nuggi mer bar odurdakmarbaloye. ");
INSERT INTO cuk09_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Agi Pedro, Juan-ebogwa abin-imakdemar: —Nue bemar-sunnad itomarmogana, ¿igid bur-nabir sunna, bemar-sogedba ibsaedi, ar igi, Bab Dummadba bur ibsaedi? Be anmarga sogena. ");
INSERT INTO cuk09_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ar anmar-sunnad na ibmar daksamarsoggu, degi, an-uayar an ibmar itosmarsoggu, a-ular anmar ibmar geg sogsuli-gumalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Geb degine, dummagan unnila Pedrose, degi, Juanse ulusmargua, gannar onosmarsunnad. Dummagan geg Pedro, degi, Juan oakalogusmardo, ar ade bela dulemar Bab-Dummad-nug odummonanai naded, dule-nugusad-ular. ");
INSERT INTO cuk09_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ar dule-geg-nanaed-ibmar-dakledisulidba-nugusad, birga-durbo-gaka nikad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro, Juan-ebogwa onolesmargu, e-sordamar-bukwadse nade-gusmalad. Geb bela e-sordamarga sogdemalad, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, degi, Judiomar-girmar-dummagan anmarga sogye, mer Jesús-nuggi bar sunmakmaloye. ");
INSERT INTO cuk09_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jesúsba-nanaimalad, Pedro, Juan-ebogwa degi-ega-soge itosmargua, belagwapa na-danale Bab Dummadse gotemalad, sogdemalad: “Bab-Dummad-Bela-Neg-Semaid, nibneg, napneg, demar, degi, bela ibmar be obinnisadid. ");
INSERT INTO cuk09_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Be-Burba-Nued be-mai-Davidga sogsa-gusad, degi, David anmarga weyob sogsa-gusmogad: ¿Ibiga Judiosurmalad urwebukwa? ¿Ibiga dulemar binsa igar-aminanai Bab-abin-gwisguegar? ");
INSERT INTO cuk09_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","We-napneggined-rey-dummagan na bela danar ambikusmalad, degi, dule-dummagan na ese atononimalad, adi Bab Dummadgi gwisgumalagar, degi, e-Cristogi yolemalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ar ade nue-napiragwad, Herodes, degi, Poncio-Pilato, Judiosurmalad, degi, Israel-dulemarmala we-neggweburgi ambikusmalad, igar amibukwa-gusmalad, Be-Machi-gwage-swilidikid-Jesús oburgwegar. A-Jesús be susa-gusad, Cristoga guegar. ");
INSERT INTO cuk09_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bab Dummad, weyob Jesús gusadi, bato idu-be-ibmar-sogsadba guegala, dulemar deyob Jesús-imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Emigindi, Bab Dummad, nue be dake, ibiyobi anmar-bega-arbamalad-ular dummagan anmargi yolenanai. Degisoggu, anmarga gangued be uksun, adi dobsuli be-gaya-burbagi anmar sunmakmalagar, ");
INSERT INTO cuk09_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","degine, be-ganguedgi nabir dule-uelemalad nudakmalagar. Aginbali, Be-Machi-Jesús-gwage-swilidikid-nuggi nabir ibmar-wilubgan-dakledisurmalad, degine, ibmar-geger-daklemalad imakmalagar.” ");
INSERT INTO cuk09_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Bab-Jesúsba-nanaimalad Bab-Dummadse-goled bergusmargu, bia danar bukwamaladgi neg-giglimakded, agine, bela Bab Dummad Burba Nued egi ubononisunnad, geb degine, dobsuli Bab-Dummad-gaya-burbagi sunmakdemarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Bela Bab-Jesúsgi-bensurmaladi, na binsaed-gwennagwadyob ulubgi itobukwa-gusmalad. Dule-wargwensaale na ibmar egadye gwen itobukwa-gussurmalad, ar ibmar bela na emargadye itobukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesús-nuggi-barmilesmalad, Bab-Dummad-Burba-Nued-ganguedba Bab-Jesús-gannar-durgusadgi, dobsuli sunmakdii-guarmalad. Degine, Bab Dummad, Bab-Jesúsba-nanaimaladgi bela-bela dulemargi-nabir-binsaed-burba odemai-gualid. ");
INSERT INTO cuk09_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Bab-Jesúsba-nanaimalad emar-abargi ibmar-galakudii gwen gussurmalad, ar ade nainu-nikamalad, degi, neg-nikamalad, na manigi ibmar uknai-guarmalad, geb a-mani senoni-damalad, ");
INSERT INTO cuk09_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","geb agine, Jesús-nuggi-barmilesmaladga mani uknonidamalad. Geb a-mani na yopiraa mimmid-damalad igi na ibmar abemaladba. ");
INSERT INTO cuk09_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Deun Chipregined-wargwen, José-nugad, deyob imaksa-gusmogad. A-dulede Leví-wagwad, Jesús-nuggi-barmilesmalad Bernabéye ega nug uksamalad. Bernabé sogleged, Nabir-Itole-Dule-Saed Machiye. ");
INSERT INTO cuk09_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","A-dulede nainu nikasoggu, na manigi nainu uksadi, a-mani Jesús-nuggi-barmilesmaladse senonikid, adi Bab-Jesúsba-nanaimalad-wilemaladga a-mani mimmimalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Deunni dule-wargwen, Ananías-nugad, e-ome-Safira-ebo nainu manigi uksamogad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A-mani bela yamo Jesús-nuggi-barmilesmaladga senonikidyob imaksad, abala na obesad. E-ome nue wisi-gusmogad, Ananías mani-abala obesad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ananías mani uknonigu, Pedro ega sogded: —Ananías, ¿Ibiga nia-saila-Satanás burba-iskana begi oubononiki, emide Bab Dummad Burba Nuedga be gakansanonigu, mani-abala be susgu? ");
INSERT INTO cuk09_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yo be nainu ukegu, ¿nainu begadinsursi? ¿Nainu be uksagu, a-manide begadinsursi? ¿Ibiga be-gwagegi anmarga gakansaedgi be binsanoniki? Dulemarga be gakan imaksasulid, Bab Dummadga be gakan imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías weyob Pedro ega soge itosgu, Ananías yog aimukuar naded, degi, yog burgwar. Belagwapa dulemar degi-gusa-itosmaladi bela-nue-dobee ito nadmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Degine, sapingana gwisgusgu, atuedgi Ananías anwismarsunnad, geb degi neg-magaba onosmarsunnad, adi neg-uanse dignamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Degi-gusad wachi-ilapaagwad-sorbali Ananías-e-ome nonimogad, gwen wichuli dognonikid e-idu igar akargusad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Geb Pedro ese egichialid: —Anga be soge, ¿mani-senonikidgii-gargegu bemar nainu uksa? Ome, abin-sogded: —Eye, degi-mani anmar nainu uksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Geb degi Pedro ega sogded: —¿Ibiga bemar-bebo Bab Dummad Burba Nued wilub-dakye sokarmala, egi dodoarmargu? Sapingana-be-sui-digdimaladi emide yawagakgi dogdanimalad. Amar be-sedmarmogoed, neg-uanse be dignamalagarmo. ");
INSERT INTO cuk09_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Agi Safira, Pedro-asabin aimukudgu, yog burgwar naded. Ar sapingana ubononimargu, bato Safira burgwar-mai daknonimalad. Degi magaba onosmarsunnad, geb e-sui-dikarba digsamarmosunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Agine, belagwapa Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad, degine, bela degi-gusa-itosmaladi bela dobee ito-nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesús-nuggi-barmilesmalad, aimar-abargi ibmar-wilubgan-dakledisurmalad, degine, ibmar-geger-daklemalad imaknai-guarmalad. Degi bela Bab-Jesúsba-nanaimalad dule-wargwennayobi Babse-goled-neggi neg-ubeb Salomónye-nugadba ambikunoni-damalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dule-baigan, dobedba geg ese ato-guarmalad. Degi-inigwele, amar Bab-Jesúsba-nanaimalad-nug odummobukwa-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bukidar Bab-Jesúsgi bensuli-gudmalad, machergan, degi, omegan, Bab-Jesúsba-nanaimaladba nagumai-gudmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Degine, dulemar-gegumalad magaba gablegedgi-mai onos-damalad, igargi Pedro-idu mesis-damalad, adi Pedro-e-burba egi wis nasale, dule-gegumaid nabir nuguegar. ");
INSERT INTO cuk09_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Dulemar Jerusalén-neggwebur-dikarbarmalad bukidar Jerusalénse noni-damarmogad, dule-gegumalad, degi, dule-niaburba-nikamalad senoni-damalad. Jesús-nuggi-barmilesmalad a-dulemar belagwapa nudaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad, degi, e-sordamar, Saduceomar, Jesús-nuggi-barmilesmaladgi nobguarmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Amar Jesús-nuggi-barmilesmalad-gasmarsun, geb degi neggwebur-eskaryagi metemarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Neg-mutikidba, Bab-Dummad-anger eskarya-yawagak eganonikid, geb Jesús-nuggi-barmilesmalad-onosgu, amarga sogded: ");
INSERT INTO cuk09_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Be namar, Bab-Dummadse-goled-negse be gwisgudapmaloed, agi bela aimarga be sunmakmaloed, we-burba-binid-igargi.” ");
INSERT INTO cuk09_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Deyob anger ega sogsa itosmargu, banedgine wakudar Bab-Dummadse-goled-negse nadmalad, degi, agi odurdakdemarsunnad. Degidgine, dule-irwa-Bab-Dummadse-goled-bur-dummad, degi, eba-gudidimalad, Judio-dummagan-igar-nabiromaladse gochamarsunnad, igar itomalagar. Degisoggu, Israel-girmar-dummagan nonimargu, suar-ibmala-barmismalad, Jesús-nuggi-barmilesmalad-eskaryagi-mellebukwad sedamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eskaryase suar-ibmala modapmargu, Jesús-nuggi-barmilesmalad-sate dakdapmalad. Degisoggu, suar-ibmala gannar nonimargu, ");
INSERT INTO cuk09_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","sognonimarsunnad: —Anmar modapgu, eskarya nue atiar sii, suar-ibmala nue yawagakgi edarbe-gwichi anmar dakdapid. Anmar yawagak egasgu, Jesús-nuggi-barmilesmalad eskarya-yaba sate anmar dakalid. ");
INSERT INTO cuk09_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dule-irwa-Bab-Dummadse-gormalad-bur-dummad, Bab-Dummadse-goled-neg-edarbed-e-dummad, degi, dule-irwa-Bab-Dummadse-gormalad-e-dummagan, geger itodmalad, sogdemarsunnad, igi wede guo-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Degi-sunmakbukwa dule-wargwen nonikid, sognonikid: —Machergan-eskaryagi-bemar-metemaladi, emide Bab-Dummadse-goled-neggi dulemar-odurdakbukwad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Degi Bab-Dummadse-goled-neg-edarbed-e-dummad, suar-ibmalamala nade-gusmalad, geb degi sabsur-imaksasuli Jesús-nuggi-barmilesmalad-senonimalad, ar ade dobmalad, abakalegi dulemar akwagi e-makarmalarye binsamaladba, nuedgi searmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Senonimargu, Judio-dummagan-igar-nabiromalad-abarse ogwisnonimalad. Geb degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad Jesús-nuggi-barmilesmaladga sogdesun: ");
INSERT INTO cuk09_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Anmar bemarga sogsamarsursi: ‘Melle Jesús-nuggine bar dulemar-odurdakmaloye.’ Emide bela Jerusaléngi bemar-odurdakdid-igar, bela neg-gassunnad, degine, Jesús-burgwisad emide anmargi bemar nasikbi-gunaimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Degi Pedro, agi Jesús-nuggi-barmilesmalad-baiganmo, abin-imakdemarsun: “Anmar Bab-Dummad-sogedbar-inse bur igar saer nabirid, dulemar-ibmar-sogedba saedbar. ");
INSERT INTO cuk09_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Anmar-dadgan-Bab-Dummad, Jesús gannar odulos-gusad. A-Jesús bemar oburgwis-gusmalad, nakrusgi bioksamargu. ");
INSERT INTO cuk09_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","“Bab Dummad a-Jesús-nug odummosad, e-argan-nuedsik sisad, dulemar-idugegar, degi, dulemar-abonogegar, adi bela Israel-dulemar nabir e-iskudiidga bukib binsamalagar, e-daed ogwamalagar, degi, adi e-iskudiid Bab Dummad ega osulogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","We degi-gusad anmar-sunnad daksamarsoggu, we igar-nued barsogega anmardi gunonisunnad, degi, Bab Dummad Burba Nued amba aga gunonimogad. We-Burba-Nued Bab Dummad dulemar-eba-damaladga uksasunnad.” ");
INSERT INTO cuk09_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jesús-nuggi-barmilesmalad weyob emarga soge itoarmargua, dummagan sae-itodmalad, degisoggu, Jesús-nuggi-barmilesmalad oburgwebi-guarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Judio-dummagan-igar-nabiromalad-abargi Fariseo-wargwen, Gamaliel-nugad, Judiomar-igar-mamaid-nue-wisid, dule-bur-nug-nikagwad, emar-abargi gwisgusgua, sokar: “Jesús-nuggi-barmilesmalad sikwas wis onogwerye.” ");
INSERT INTO cuk09_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","A-sorba geb Gamaliel dummaganga sogded: “Israel-dorgan, nue salakarmar, we-dulemar igi imakbi bemar gubuk-dibe, nue itoakwaa imakmalo. ");
INSERT INTO cuk09_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nue bemar insamalo, we-ibagan-iduale, igi gusa. Deun Teudas dulemar-idudii-gusad, na sogdii-gusad, an Dule-Dummadye. Degi dulataled-ilabake dulemar eba nagus-gusad. A-dule-oburgwismargu, eba-nanaimalad bela aisakid, degi, bela yoggud-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","A-sorba, dulemar-ebisleged-ibagangi, Galilea-dor-wargwen, Judas-nugad, beedse dulemar-gadigusmogad. A-dule-oburgwismargu, eba-nanaimalad bela aisakid-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Degisoggu, we-dulemar mer be oakalomalo, mer be ebumalo. Ar we-igar dulemar-sogedba gudimalale, degi-yoggudoed. ");
INSERT INTO cuk09_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ar Bab-Dummad-sogedba gudimalardina, adi geg be osulomalad. Degisoggu, nue salakarmar, abakalegi anmar Bab Dummadgi yolenaile.” ");
INSERT INTO cuk09_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Igar-nabiromalad Gamaliel-soged nabir itosmalad. Degi geb Jesús-nuggi-barmilesmaladse gochamargu, bibyosmarsunnad. Geb a-sorba dummagan ega sogdemalad: “Mer Jesús-nuggine bar sunmakmaloye.” Geb a-sorba onosmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesús-nuggi-barmilesmalad Judio-dummagan-igar-nabiromalad-abargi noarmargu, weligwar noarmalad, ar Bab-Jesús-nug-ular nabir ise-mesagwar emar wilesad-ular. ");
INSERT INTO cuk09_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jesús-nuggi-barmilesmalad bane-bane Bab-Dummadse-goled-neggi, degi, negaya-negaya dulemar odurdakdii-gusmalad, Jesucristo, we Bab-Dummad-dule-wargwen-barmidagoye-sogsad-dule-sunnadye. Deyob Jesucristogi sunmakdii-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Deunni a-ibagangine, Bab-Jesúsba-nanaimalad mergumaisoggu, Judio-dorgan-Griego-gaya-sunmakmalad sunmakarmalad, Judiomar-e-gaya-sunmakmaladgi sokarmalad, e-mukwamar-ei-sui-burgwismalad mas bane-bane mimmilealile, bur amar baisur dakledamarye. ");
INSERT INTO cuk09_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Degi Jesús-nuggi-barmilesmalad-e-ambe-gakabo-guedi, bela Bab-Jesúsba-nanaimaladse gochamarsun, amarga sogdemar: “Anmar mas-mimmied-ular Bab-Dummad-gaya-burbagi-sunmaked-indaker, adi wis noar anmar itoged.” ");
INSERT INTO cuk09_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Degisoggu gwenadgan, na bemar sumalo, dule-walagugle, amar bemar-abargi nued gudiid, degi, bela-bela Bab-Dummad-Burba-Nued-nikabalid, geb nue-binsaed-nikaa dabalid, adi amar anmarga mas-mimmied-arbaed dakegar. ");
INSERT INTO cuk09_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Adi anmar Bab Dummadse goledginbi, degi, E-gaya-burbagi sunmakedginbi arbamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Belagwapa Bab-Jesúsba-nanaimalad nabir itosmalad. Degisoggu, Esteban-nugad susmalad, a-dule Babgi nue bensulid, degine, nue bela-bela Bab-Dummad-Burba-Nued-nikabalid, degi, Felipe, Prócoro, Nicanor, Timón, Parmenas, agi Nicolás, Antioquíagined, a-dulede Judio-igar-abingasad-duled. ");
INSERT INTO cuk09_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","We-dulemar Jesús-nuggi-barmilesmaladse senonimalad. Geb Jesús-nuggi-barmilesmalad amarga Bab Dummadse gochamargua, na e-argan dulemar-walagugled-e-nonogi mesismalad, oyogegar, we-dulemar Bab-Dummadga-arbaega sulesmarye. ");
INSERT INTO cuk09_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bab-Jesús-gaya-burba nasgumai, degi, Jerusalén-neggweburgi Bab-Jesúsba-nanaimalad mergumai-guarsunnad. Agine, bukidar dule-irwa-Bab-Dummadse-gormaladse-bakar Bab-Jesús-igarba nagudmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Bab Dummad bela-bela Esteban nabir daksoggu, degine, Esteban Bab-Dummad-Burba-Nued-gangued bela-bela nikabarsoggu, aimar-abargi ibmar-dummagan-geger-daklemalad, degine, ibmar-wilubgan-dakledisurmalad imakdii-gualid. ");
INSERT INTO cuk09_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Degi gwenna-gwenna Judiomar-onmaked-neg-Libertosmarba-nanaimalad, degi, Cireneginmalad, Alejandríaginmalad, Cilicia-dorgan, agi Asia-yalaganbarmalad, amar Esteban-ebo na undar abin-abin imaknanai-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amardi geg Esteban nue abin imak-guarmalad, ar ade Estebande nue-binsaed-nikaa, Bab-Dummad-Burba-Nued-ega-sogedba sunmaked. ");
INSERT INTO cuk09_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Degisoggu, amar dulemar-bennuksamalad, yamo-gakansaale Estebangi sunmakmalagar, adi sogmalagar, Esteban Moisés-nuggi, degi, Bab-Dummad-nuggi dododii anmar itosye. ");
INSERT INTO cuk09_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Degisoggu, Esteban-ebo abin-abin-imaknanaimaladi, dulemar, Judiomar-girmar-dummagan, degi, escribamar oulusmarsun, adi Estebangi gwisgumalagar. Agine Judiomar Esteban-ganonimarsun, geb Judio-dummagan-igar-nabiromaladse Esteban-sesmarsun. ");
INSERT INTO cuk09_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Agine Esteban-abin-abin-imaksamalad dulemar-senonimarsun, adi yamo-gakansaale ibmar sogmalagar. Amar sogdemar: “We dule Bab-Dummadse-goled-neg-islidikidgi, degi, Bab-Dummad-Moisésga-igar-uksadgi dodoar sunmakdiidgi geg surguye. ");
INSERT INTO cuk09_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","We soge anmar itosye, emi Jesús-Nazaretgined we Bab-Dummadse-goled-neg-siid osulogoye, degi, Moisés-anmarga-gusgu-igarmar-mesisad oakalobaloye.” ");
INSERT INTO cuk09_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bela dummagan Judiomar-igar-nabirogedgi bukwamalad, Esteban-dakdemargu, Esteban-wagar anger-wagarsuun-dakle dakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Degi dule-irwa-Bab-Dummadse-gormalad-bur-dummad Estebanse egichiar, ega sogde: “¿We bela begi-ibmar-sognanaid nabiridbi?” ");
INSERT INTO cuk09_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Degi Esteban, abin-imakdegu, sogded: “Gwenadgan, degi, babgan, nue an-itomalo. Anmar-dad-Abraham amba yo Haránse megdageun, deun amba Mesopotamiagi gudigu, Bab Dummad gandikidba yeer-daklegedgi anmar-dad-Abrahamse magarosad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Deun Bab Dummad ega sogsa-gusad: Be-neggweburgi be nae, degi, be-gwenadgangi be bangu, be nae, bia yar-baid an-bese oyogoedse. ");
INSERT INTO cuk09_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Degi Abraham Mesopotamia-yalagi, Caldeagi node-gusad, Haránse megnonikid. Agi e-bab burgwisgu, Bab Dummad we-yarse Abraham-senonisunnad. Emigindi a-yargi anmardi bukwasunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","A-yargi Abrahamga nainu gwen uklessulid, bipi-goakwasar-bela sate. Degite Bab Dummad ega sogsad: We-yar an bega ukoye, degi, be-waganga be-sorba an ukbaloye. Gn. 12:7 Deyob ega-sogsa-unni amba yo Abraham mimmi-nikueunnid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Weyob Bab Dummad Abrahamga sogsa-gusbalid: Be-wagandi yar-baid e-neg-sulidgi sikwas wis gudiguoed. Agine, dulemar-baigan na e-maiga imakoed, degi, birga-dulataled-ilabake amarse wilemaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Bab Dummad wegi-ega-sogsabalid: Yar-baidgined maiga-be-wagan-imakoedi, a-yarginmalad ani an sabsur odurdakoed, degi, be-wagan a-yargi nodagogu, geb we-yargi an-nug odummobukwa-gumaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Degi, Bab Dummad Abraham-ebo na igar mesisad. We-igar-megisad-e-wilub magar-daklegegala abgan-duku-siked-igar Bab Dummad Abrahamga uksad. Degisoggu, Abraham, na e-machi-Isaac ibabaabakgus-gwalulesad-sorba abgan-duku siksasunnad. Degine, Isaac, na e-machi-Jacob abgan-duku-siked imaksamogad. Geb Jacob na e-machimar, anmar-dadgan-ambe-gakabogwad abgan-duku siksamosunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Degine, Jacob-machimala, amar anmar-dadgan, na e-urba-Joségi nobguarmargu, Egiptogi-maiga-guega José manigi uksamalad. Ar Joséba Bab Dummad gudigusoggu, ");
INSERT INTO cuk09_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Joséga naibi-itoged-ibagan-bulegan-nagumaid, Bab Dummad ega osulomai-gusad. Degine, Bab Dummad Egipto-rey-Faraón imaksad José nabir dakega, degi, binsaed-nikarba dakega imaksabalid. Degisoggu, Faraón, José Egipto-yar dakega, degi, e-neggi neg-dakega, José-onugsassunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“A-ibagangi ukud-dummad, degi, wile-itoged-ibagan-bulegan bela Egipto-yargi, degi, Canaán-yargi nagunonikid. Degisoggu, anmar-dadgan mas-gunned-satedba ukumecharmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob wisguargu, Egipto-yargi madubur-gwagwaled nikaye, na e-masmala-barmid-gusad, mas bakegar. Degisoggu, anmar-dadgan Egipto-yarse deun gebe ali-gussunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","“Gannar anmar-dadgan Egipto-yarse mas bakarbargua, agi geb José e-iamarse na magarosad. Geb agi Faraón wisgunonisunnad doamar José-gwenadgan gue. ");
INSERT INTO cuk09_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","A-sorba José na e-babbina gochasunnad, adi e-bab, degi, e-gwenadgan belagwable e-dulapaa-gakambe-gakataled Egipto-yarse dagmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Weyob-gusadba Jacob Egipto-yarse megdapsunnad, degi, a-yargi burgwisad. Geb a-yargi anmar-dadgan-e-ambe-gakabogwadi burgwismarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Anmar-dadgan burgwisgu, Siquem-neg-nugadse seles-gusmalad, agi digledapmalad, bia dad-Abraham manigi Hamor-e-mimmiganse napa-baksa-gusadgi. ");
INSERT INTO cuk09_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Degine Bab Dummad Abrahamga sogsad, yoedse an bega we-napa ukoye. A-ibagan modanigu, deun Egipto-yargi anmar-dadgan dula-mergud-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A-ibagangi, rey-gwensak José Egipto-yar-bendaksad aku-dakedi Egipto-yargi neg-dakmai-gualid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A-rey yamo-yardakakwaa anmar-dadgan-sabsur-wioalid, adi e-mimmigan burgwegar, mer Israel-dula bar mergumai-guegar. ");
INSERT INTO cuk09_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“A-ibagangi Moisés gwalulesad. Bab Dummad a-machigwa mimmi nued daksad. E-babgandi na e-neggi arbakee nii-warbaa na odungudani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","E-babgan geg bar e-neggi-sediguedba, diwarse Moisés berbeapmarsunnad. Agi Faraón-sisgwadi Moisés-sussunnad, geb degi e-mimmibayobi na akwis-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Agine, Moisés Egipto-igargan nue durdaksad, degi, nue baramisad. Moisés gannarba ibmar-sae, degi, gannarba nue-yeer sunmake-gunoni-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moisés birga-dulabo-nikadgi na e-gwenadgan-Israel-dorgan daknaye na binsaalid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Modapgu, Egipto-dule-wargwen binsarsunna Israel-dule sabsur-imaknai dakalid. Moisés na e-gwenad-bendakega, Egipto-dule-oburgwisad, deyob buged-mai dule-binsa-sabsur-imaklesadga imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisésdi e-gwenad-Israel-dulemar mag e-itomaloye bienad, egi Bab Dummad emar-wilebukwad onogoed. Dakleargu, mag itossurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A-banedgine, Moisés, Israel-dulemar na ebo sarsonanai dakargu, aisaar emarga igar-naboye sokalinad, aga amarga sogdenad: ‘¿Gwenadgan, ibiga na be sarsonanai? Melle na be urwemar, ar bemar na gargwenad gumalad.’ ");
INSERT INTO cuk09_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Degi dule-e-ai sabsur-imaknaid Moisés-barmetegu, ega sogded: ¿Doa anmar-dummadga, degi, anmarga-igar-nabogedga be-onugsasa? ");
INSERT INTO cuk09_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Sae Egipto-dule oburgwisadyob be an-oburgwebimoga? ");
INSERT INTO cuk09_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Deyob dule ega soge itosgu, Madián-yalaganba Moisés wakite-gusad. A-yargine, e-yarsulidgi gudigualid. Moisés a-yargi machimala-warbo nikusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“A-birga-dulabogwad-sorbali, nega-dule-sulidganba, Sinaí-yar-nugad-itakasaar, sapi-gwabunye-gwichid-gummakmaidyob-abargi anger-wargwen Moisésse magarosad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés a-sapi-gwabunye-gwichid gummakmaid geg-bergu dakargu, geger dakedba, walikaa nue-nuu daknadgu, Bab Dummad ega soge itoalid: ");
INSERT INTO cuk09_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ani an be-dadgan-e-Bab-Dummad. Ani an Abraham, degi, Isaac, degi, Jacob e-Bab-Dummadid. Ex. 3:6 Moisés dobedba wawanmakde, sapi duu gagwichid gwen bar dakbi-ito-nadsulid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Degi Bab Dummad ega sogdesunnad: Be-naggi nag-uka-yoid be unge. Ar be napa-annagwichidgi napa-nuedid, nega-isligwaled-napad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Emide an daksad, degi, an itosbalid, igi an-dulemar Egipto-yargi-bukwadi wilebukwa. Degisoggu, aga an aidenonikid, an-dulemar-bendakegar. Degisoggu, Egipto-yarse an be-barmidoed, an-dulemar-ononaegar.” ");
INSERT INTO cuk09_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Degi Esteban sogdebar: “We Moisés yapa-abingamaladbali, ega sogsamalad: ‘¿Doa-dule anmar-dummadga, degi, anmarga-igar-nabogedga be-onugsasa?’ We-dulemar yapa na Moisés e-dummadga na imakgusmar-inigwele, Bab Dummad a-Moisés amar-dummadga onugsasad, degi, e-anger-ganguedba dulemar-wilebukwad-onogega Egipto-yarse Moisés-barmisad. We-angerde epenne sapi-gwabunye-gwichid-abargi Moisésse magaros-gusadid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","“We-a-Moisés anmar-dadgan Egipto-yargi-bukwad onosad. A-dule Egipto-yargi, degi, Demar-Ginnidye nugadgi, degi, birga-dulabo nega-dule-sulidganba ibmar-geger-daklemalad, degine, ibmar-wilubgan-dakledisurmalad oyodii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Amba we-Moisés-sunnad Israel-dulemarga sogsa-gusad: Igi bemar-abargi Bab Dummad an-susa, deyob bemar-abargi Bab Dummad E-gaya-burba-berbeged na subaloed. Igi bemarga sogdagoe, a-dule nue be itomalo. ");
INSERT INTO cuk09_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Amba we-Moisés anmar-dadgan-abargi nega-dule-sulidganba gudigusad. Deunni yar-Sinaígi anger-ese-magarosad-ebo na sunmakdii-gusad. Degi, Moisés anmar-dadganga sunmakdii-gusmogad. We-Moisés Bab-Dummad-gaya-burba-nued geg-burba-bergued abingas-gusad, adi anmarse ogwamarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Degite, dadgandi Moisésba ibmar imakbisur-gusmalad, bur obacha-gusmalad, gannar Egipto-yarse dagbi-guarmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aga Aarónga sogdemalad: Anmarga bab-dummad-orgi-sobaled be sobe, adi a anmar-idu nadap-guegar. Ar emide anmar wichulid, ar igi we-Moisés anmar Egipto-yargi onosad-gusa, ar wede bia nade. ");
INSERT INTO cuk09_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Degisoggu, moli-bebe-nikad-bipigwadgiid sobsamalad, a e-bab-dummadga na imaksamalad. Geb aga iba-dummad onosmalad, ega ibmar-durgan bukidar oburgwismalad, na dukin ibmar-sobsamaladgi wergunai-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Degisoggu, Bab Dummad anmar-dadgangi bangudsunnad, nibneggi-ib-dula-nanaidse ulubgi bab-dummadyob egi binsabukwa-guega imaksasunnad. Ar deyob Bab-Dummad-Gardagi E-gaya-burba-berbemalad bato narmaksad: ¿Bemarde Israel-dorgan, ar birga-dulabo nega-dule-sulidganba gudigusgua, anga wis ib-durgande ogumakar uksamarsi? ");
INSERT INTO cuk09_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Suli, anga uksasurmalad. Bur Moloc be-bab-dummadga bemar imaksamalad, degi, a-surba bur be sesmalad. Degi niskwa-Refán bab-dummadyob bemar na dukin sobsamalad, a bur be-bab-dummadga bemar imaksamalad. A-ulale, Babilonia-neggwebur-obinale an be-barmidmaloed, sabsur be-odurdakmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Nega-dule-sulidganba anmar-dadgan bipirmakdigu, Bab-Dummadse-goled-neg-sunna-seleged nika-gusmalad. A-neg Bab-ebo na igar-mesisad mag daklegega anmar-dadganga uklesad. We-negde igi Bab Dummad Moisésga oyosa, deyob Moisés neg-sobsa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","“Degi anmar-dadgande we-neg abingasmarsunnad, e-dadgan-burgwisad-sorba. A-neg anmar-dadgan-Josuémala sear-gusmalad, deun we-yarse ubononimargu, Bab Dummad gandikidba dulemar-e-idu-bukwadi onosgu. We-negde, David reyga-megisadse sii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Nabir Bab Dummad Davidgi binsassoggu, David Bab-Dummadse-goled-neg sobe-sokalinad, adi Jacob-e-wagan-Bab-Dummad na neg-meged nikuegar. ");
INSERT INTO cuk09_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Degi-inigwele, geb e-machi, Salomón-nugad, Bab-Dummadse-goled-neg sobsa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Bab-Dummad-Bur-Dummadid dulemar-neg-sobedgi gwen megosurguoed, Bab-Dummad-gaya-burba-berbeged sogsadyob: ");
INSERT INTO cuk09_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Bab Dummad soged: ‘Nibnega an-olo-ganad, degi, napnega an-nag-onakwed-ganad. ¿Degite, ibi-neg bemar anga sobmalosunna? ¿Ar bia degite an-obunnoged-neg be anga ukmalosunna? ");
INSERT INTO cuk09_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ar belagwapa we-ibmarmarde an obinnissursi?’ ” ");
INSERT INTO cuk09_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Degi, Esteban sogdebar: “Bemar gusgu Bab Dummad Burba Nuedgi yoledigumalad, bemar-dadgan-gusadyobmo. Bemar uaya-gwen-niksurmalad, degi, bemar gwagegi dulemar-Bab-Dummad-aku-dakmaladyob damalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Ar be-dadgan biti Bab-Dummad-gaya-burba-berbemalad wiossurmar be insae? Bela wiosmaladbiid. Bab-Dummad-gaya-burba-berbemalad sogsa-gusmalad, yoedse dule-wargwen, dule-gwage-swilidikid, bemarse danikoye. Degi-sogsamalad, be-dadgan amar-oburgwis-gusmalad. Degite, emigindi we-dule-gwage-swilidikid bemarse nonigu, bemar, darba manigi uksamalad, degi, bemar oburgwismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bab Dummad igar-mesisad na e-angermarba bemarga uksadi, degite, a-igarba bemar gwen ibmar imaksasurmalad.” ");
INSERT INTO cuk09_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban weyob emarga ibmar-soge itosmargu, Judio-igar-nabiromalad-dummagan na e-gwagegi sae-itodmalad, degi, bela nugar gunnar-gunnar Estebangi uludmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebandi Bab Dummad Burba Nued nue nikasoggu, niba atakdegu, Bab-Dummad-gangued-yeer-daklegedi daksad, degi, Jesús Bab-Dummad-argan-nuedsik gwichi daksabalid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Degi Esteban sogdesun: —¡Be dakmar! Nibneg argaar an daked, degi, Dule-Machi Bab-Dummad-argan-nuedsik gwichi an dakbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Judiomar mer Esteban itomalagala na uaya edismalad, degi, binnasur oimakdemargu, bela Estebangi duurmakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Esteban-gasmargu, neggwebur-magaba ebipidmalad, geb agi akwagi Esteban-maksamalad. Dulemar akwagi-Esteban-maknanaid na e-mor sapin-wargwen Saulo-nugadga uksamalad, adi ega gamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Akwagi Esteban maknanaimargu, Estebandi Bab Dummadse gote, sogded: “Dummad-Jesús, an-san-burba be sue.” ");
INSERT INTO cuk09_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","A-sorba Esteban yokorgi sindigar sigisad, geb binnasur gote, sogded: “Dummad, we-dulemar-sabsur-an-imaknanaidgi mer istar be binsao, iskunanaisurmalayobi be dakoed.” Wegi-sogsad-sorba, Esteban burgwissunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Judiomar Esteban-iblosmargu, Saulo yeer itogwichi-gusmogad. Deunni Jerusalén-neggweburgi Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad nue-ise-wilegar baregillearmalad. Degisoggu, bela amar duurmakde-gusmalad, Judea-yalaganba, degi, Samariase. Unnila Jesús-nuggi-barmilesmaladbi Jerusaléngi besa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dulemar-Bab-Jesúsba-nue-nanaimaladi Esteban-sesmarsun, neg-uangi digega. Amar nue Estebanba bobukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Deun Saulodi Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad baregindii-gualid, negaya-negayase machergan, degi, omegan barimakdigualid, eskaryase metenaegar. ");
INSERT INTO cuk09_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bab-Jesúsba-nanaimalad Jerusaléngi-ainidmaladi bela aisakidmargu, amar Bab-Jesúsgi-abonoleged-igargi bela dulemarga sognadap-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Degi aisakidmalad-wargwen, Felipe-nugadi, Samaria-neggweburse nade-gusad, agi Cristogine amarga sunmakdesunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dulemar itosmargu, Felipe ibmar-wilubgan-dakledisulid nue imaknaiye, degine, daksamarbargu, bela-dulemar Felipe-emarga-ibmar-sognaid nue itobukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Deginbali, bukidar niaburba-nikamaladi, binnasur gote, niaburbamar egi ainid-damalad, degi, bukidar dule-abgan-burgwar-nikamaladi, degi, dule-muya-muya-nanamaladi, Felipe amar-onudaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Degisoggu, Samaria-neggweburgi nue-weligwar itobukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Samaria-neggweburgine a-ibagi dule-wargwen, Simón-nugadi, gudigusmogad. A-dulede neled, iduar dulemar yardakdii-gusad, ar ade bukidar ibmar-dakledisurmalad imakdisoggu, dule-dummadye na san sadiid. ");
INSERT INTO cuk09_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bela dulemar-burwigana, degi, serganse-bakar nue boo itobukwa-damalad, degi, bukidar sogmalad: “We-dule, Bab-Dummad-gangued-nue-nikad-duleye.” ");
INSERT INTO cuk09_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bukidar Simón-ibmar-sogedba imakde-damalad, ar ade dikasurgus Simón dulemar-yardakar, ibmar-dakledisulid imakdisoggu, ese binsaed-galed-damarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipe gaya-burba-nued, Bab-Dummad-neg-dakmaidgi, degi, Jesucristo-nuggi sunmakdiidi, Samaria-dulemar e-gwagegi abingasmargu, machergan, degi, omeganse-bakar Bab-Jesús-digi-ogleged-igar imaksamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón Bab-Jesúsgi bengussurmogad. Simón Bab-Jesús-digi-oglesad-sorba, Felipe-walikaa bipirmakdii-gualid, ar ade Felipe ibmar-wilubgan, degine, ibmar-dakledisurmalad-dummagan-imakdiid geger daked. ");
INSERT INTO cuk09_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusaléngi Jesús-nuggi-barmilesmalad wisguarmargu, Samaria-dulemar Bab-Dummad-gaya-burba gwagegi abingasmarmoye, Pedro, degi, Juan-ebogwa, ega barmid-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Pedro, Juan-ebogwa Samariase mosmargu, Bab-Jesús-abingasmaladga Bab Dummadse gotemalad, adi Bab-Dummad-Burba-Nued-nikumarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ar ade Samaria-dorgan amba yo Bab-Dummad-Burba-Nued-abingamalad, unnila Jesús-nugginbi digi oglesmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Degi, Pedro, Juan-ebo, Samaria-dorgangi argan mesismargu, amar Bab-Dummad-Burba-Nued-nikunonimarmosunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jesús-nuggi-barmilesmalad e-argan dulemargi mesisale, Bab-Dummad-Burba-Nued-abingas-damar Simón daksagu, Jesús-nuggi-barmilesmaladga mani ukbi-gualid, ");
INSERT INTO cuk09_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","degi, amarga sogdesunnad: “We-gangued bemar nikad anga udamoye, adi doa-dulegi an-argan an mesisale, nabir Bab-Dummad-Burba-Nued-nikuegarmoye.” ");
INSERT INTO cuk09_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Degi Pedro, abin-imakdesun: “Be, degi, be-mani, beba bela soo-sailase naena-gadin, ar Bab-Dummad-nabir-anmargi-binsaed, anmarga ibmar-uked, manigi bakleye be bidager. ");
INSERT INTO cuk09_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Degisoggu, bega igar-gwen-maisulid anmarba Bab-Dummad-Burba-Nued-uked, ar ade be-gwage Bab Dummadgi dikasur bangus naid. ");
INSERT INTO cuk09_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Degisoggu be-gwagegi be-sunnasur-binsasad bukib be binsasun, na be nugusun, Bab Dummadse be gole, adi abakalegi be-gwagegi-sunnasur-binsasad Bab Dummad bega osuloalile. ");
INSERT INTO cuk09_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ar an be-dakgua, be-ulubgi ibmar-gaibidyob aimargi-nobed begi naid, degine, iskuedse be bipirmas-gudii an be-daked.” ");
INSERT INTO cuk09_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón, Pedroga, degi, Juanga sogdesun: “Anga Bab Dummadse be gormar, adi bela be-anga-ibmar-sogsad mer degi-guegar.” ");
INSERT INTO cuk09_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro, Juan-ebogwa, Bab-Dummad-gaya-burba-nued-barsogsamalad-sorba, degi, Jesús-nuggi sunmaksamargu, gannar Jerusalénse armarsunnad. Jerusalénse danimargu, igarba Samaria-yargi neggwebur-burwigana-bukmaladga Bab-Dummad-gaya-burba-nuedgi sunmakdani-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","We degi-gusad-sorbali, Bab-Dummad-e-anger Felipega sognonikid: “Be nae, dad-argwaned-argan-nuedsik. Jerusalénse be mosale, neggwebur-Gazase-nanaed-igar nega-dule-sulidba-nanalemaid-igarba be naoed.” ");
INSERT INTO cuk09_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Deyob, anger ega sogsagu, Felipe nade-gussun. Igarba nadapgu, dule-wargwen dakar, Etiopíagined, dule-alugwag-gwasualed. A-dulede dule-dummadid, ar ade Etiopíamar-reina-Candacega mani-daked-duled. A-dulede Jerusalén-neggweburse arbi-gusad, Bab-Dummadse-goledgi Bab-nug odummogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Etiopía-dorde gannar na e-negse nadapgu, e-moli-urgi sii, Bab-Dummad-gaya-burba-berbeged, Isaías narmaksa-gusad, a-absonadapid. ");
INSERT INTO cuk09_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Agi Bab Dummad Burba Nued Felipega sogded: “Ese walik be nae, e-moli-uryase.” ");
INSERT INTO cuk09_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe ese nadsun, degi, walikgusgu, Bab-Dummad-gaya-burba-berbeged, Isaías-narmaksadi, a-absonadap itoalid. Degi Felipe ese egisdesunnad: —¿Degite be-absonadapid mag be itoge? ");
INSERT INTO cuk09_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Dule-Etiopíagined, abin-sogded: —¿Sunna mag an itogosi, ar dule anga odulosulir, we ibi obare? Degisoggu, Felipega sogdesun: —An-moli-urse be nakwe, an-dikarba be sigdage. ");
INSERT INTO cuk09_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Etiopía-dule, Bab-Dummad-Garda-narmakaled-absonadapid wegi-narmakar naido: Sibad-wawaad-oburgwilenadapile, boo nadap-daedyob, we-dulede oburgwilegedse nade-gusad. Ar igi sibad-wawaad-sapin ei e-absar ibmiarmalar wichur boe, deyobi we-dulede gwen gaya nikudsulid. ");
INSERT INTO cuk09_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bela-bela egi dodosmaladgi, igar-maidba gwen ega imaksasurmalad, igar gwen nabirossurmalad. Degisoggu, ¿doa e-wagangi bar sunmakosunna? Ar ade oburgwismalad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopía-dule Felipese egisdesun: —Anga be soge, ¿we doagi Bab-Dummad-gaya-burba-berbeged sunmake? ¿An na dukin soge, ar igi, dule-baidgi sunmake? ");
INSERT INTO cuk09_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Degi Felipe, abin-imakdegu, ega sogdesun, Bab-Dummad-Gardagi narmakar naidba, agi ega onoded, geb degi Bab-Dummad-gaya-burba-nued-Jesúsgi-soglesadgi ega sunmaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Degi, igarba nadapmargu, dii-nai dakarmalad. Agi Etiopía-dule Felipega sogdesun: —Dii be dake. Degisoggu, ¿Bab-Jesús-digi-ogleged-igargi geg an oglege? ");
INSERT INTO cuk09_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe, abin-imakded: —Ar na be Jesucristogi nue bensulile, be sunna Jesús-nuggi digi oglegodo. Etiopía-dule, Felipe-abin sogded: —Gwen an bensulid, Jesucristo Bab-Dummad-Machi-sunnadid. ");
INSERT INTO cuk09_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Degi Etiopía-dule moli-ur bogi-nasiked imaksasunnad. Degine, ebo dise aidesmarsunnad. Geb Felipe Etiopía-dule Bab-Jesús-digi-ogleged-igargi ogsasunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Diyagi gwichi nakwiarmargu, Bab Dummad Burba Nued ukiar Felipe-sesa-gusad. Etiopía-duledi bar gwen Felipe-daksasulid, degi-inigwele, bela-bela weligwar e-negse nadap-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipedi bato Azotogi gudii daklealid. Felipe neggwebur-ilibali Bab-Dummad-gaya-burba-nuedgi sunmaknadap-gusad, deyob Cesarease warmaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ar Saulodi Bab-Jesúsba-nanaimalad-istar-daksoggu, sae-itogedba unnila amar-ogilogedginbi binsadisunnad. A-ulale, Saulo dule-irwa-Bab-Dummadse-gormalad-bur-dummadse nade-gusad, ");
INSERT INTO cuk09_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","garda amiega, adi nabir Damascogi Judiomar-onmaked-neg-bukmaladse dogegar. Ade a-gardade Sauloga igar-uknaid, adi nabir machergan, degi, omegan Bab-Jesúsba-nanaimalad gaegar, degi, amar gugmakar Jerusalénse sedagegar. ");
INSERT INTO cuk09_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saulo igarba nadapgu, Damasco omodanigu, ukiar nibneggi gwallu mee egi ganonikid. ");
INSERT INTO cuk09_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Agi Saulo napase aimukud-gusad. Geb degi nibneggi dule ega soge itoalid: “Saulo, Saulo, ¿ibiga be an-baregindii?” ");
INSERT INTO cuk09_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Degi Saulo ese egisdesun: “Dummad, ¿be doa-sunna?” Dule, abin-imakdebar: “Ani an Jesús, ar doa-dule be baregindiid, ani an a-duled. Iko be sarsoye sogele, na be dukin nunmaked amioed. Deyobmodo, Bab-Jesús-igargi be dodoye soger, na be dukin san wiogoed.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo nue dobe itoge, wawanmakde, sogded: “Dummad, degite, ¿ibi imakbi be an-abesunna?” Dummad, abin-imakde, ega sogdesun: “Be gwisgu, neggweburse be nae, agi bega sogmaloed, ibu be imakoe.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dulemar-Sauloba-nadapgusmalad nue-dobe itodmalad, geg sunmake-gudmalad, ar ade gaya-burba itosmalad, degi-inigwele, dule-gwen-daksurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo napagi-mai gwisgudgu, ibya na egadengu, dulemar-aku-dake naded. Degisoggu, argangi e-sordamar Saulo-gani Damascose sesmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Saulo, Damasco-neggweburgi ibapaa aku-atak megisad, degi, gwen mas guchasulid, agi gwen gobsasurbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Deun Damasco-neggweburgi Bab-Jesúsba-naid-wargwen mai-gusad. A-dulede Ananíasye-nugad. Ase Bab-Jesús gabgi gabdakeyob ega ibmar sognonikid: “¡Ananías!” A-dulede Bab-Jesús-abin imas: “Degite Dummad, wegi an mai, an be-itomai.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Agi Bab-Jesús ega sogded: “Be gwisgu, be nae, Igar-Inikigwad-nugadse, Judas-negse. A-neggi be egisdapoed Tarso-dola, Saulo-nugad. Ar a-neggi a-dule, Bab Dummadse gormaid. ");
INSERT INTO cuk09_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Agi a-dule-maid na gabgi bato dule-wargwen Ananías-nugad daksad, ese dogdani, e-sangi e-argan mesnai, adi nabir gannar atakegar.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías, Bab-Jesús ega degi-soge itosgu, sogded: “Dummad, nabir be sogendo, degi-inigwele, dule-bukidar we-dulegi sunmakmar an-itodiid igi Jerusaléngi begi-akananaimalad beedse wiodiid. ");
INSERT INTO cuk09_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Deginbali, wese Damascose nonibargu, dule-irwa-Bab-Dummadse-gormalad-e-dummagan-garda-nika nonikid, adi nabir beba-nanaimalad bela gaegar, eskaryagi metegar.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bab-Jesús, abin-imakded: “Be nae, ar we-dule an susad an-sapinga guegarmo, adi nabir Judiosurmaladga an-nuggi sunmakegar, degi, reymarga sunmakbaligar, degi, amba Israel-dulemarga sunmakbaligar. ");
INSERT INTO cuk09_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Degisoggu, ani an Sauloga oyogoed, an-sapinga guedi, beedse an-nug-ular wileger-gebye.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Deyob Bab-Jesús ega sogsagu, Ananías nadsun, Judas-negse. A-negse modapgu, Ananías na e-argan Saulogi mesisgu, ega sogded: —Gwenad-Saulo, Dummad-Jesús, igarba danigu bese magarosad-dule, a an-barmialid, adi nabir gannar be atakbaligar, degi, Bab Dummad Burba Nued bela-bela be nikubaligar. ");
INSERT INTO cuk09_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Degi-ega-sogsagu, Saulo-ibyagi ua-ukayobi naidi, yog babatiar-gusad, geb degi nabir gannar atak-naded. Geb Saulo a-sorba yog Bab-Jesús-digi-ogleged-igargi oglessunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saulo geb mas guchagu, wis gannaledsunnad. Agi Damascogi dulemar-Bab-Jesúsba-nanaimalad-walik ibbigbasaar gudigusad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A-sorba Saulo Damascogi Judiomar-onmaked-neg-irba Bab-Jesús-igargi sunmakde, sogdesunnad: “Jesús Bab-Dummad-Machi-sunnadye.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Belagwapa-Saulo-itobukmalad geger dakdemalad, sogdemarsunnad: “¿We-dule Jerusaléngine dulemar-Jesúsba-nanaimalad-baregindii-dasursi? ¿Ar amba we-dule wese nonisursi, dulemar-Jesúsba-nanaimalad gaegar, degi, Jerusalénse sedegar, adi dule-irwa-Bab-Dummadse-gormalad-e-dummaganga ukegar?” ");
INSERT INTO cuk09_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ar Saulodi aka-bur-bule Bab-Jesús-igargi sunmakdigualid, nue-ise-oyodiguarsunnad, Jesús, we Cristo-sunnadye, Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duleye. Degisoggu, Damascogi Judiomar-bukwadi geg Pablo-abin imakgusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A-ibbigbagwad-sorba, Judiomar na igar-amismalad, Saulo-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulodi wisgusad e-oburgwebimalad. Saulo-oburgwemalagala Judiomar bane-bane neggwebur-yawagak-nagaba, mutikidba, degi, ibginse-bakar Saulo-edarbebukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bab-Jesúsba-nanaimaladdi mutikidba neggwebur-galu-dikarba garbagi Saulo-mai odesmarsunnad, adi nabir wakinnegar. ");
INSERT INTO cuk09_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo Jerusalén mosgu, Bab-Jesúsba-nanaimaladba ambikubigualinad, ar Bab-Jesúsba-nanaimaladdi dobe itomalad, ar ade Bab-Jesúsba-naimo-deeye gwen Saulogi binsasurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Degi-inigwele, Bernabédi Saulo-sesa-gusad, bia Jesús-nuggi-barmilesmalad-bukwadse. Amarga sogdesunnad, igi Saulo Damasco-igarba nadapgu, Bab-Jesús-daksagusa. Agine, igi Jesús ega sogsagusbali, deginbali, igi Saulo dobsuli, nue-gandikidba Damascogi Jesús-nuggine sunmaksa-gusbalidgi. ");
INSERT INTO cuk09_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Agi, Saulo Jerusaléngi bessunnad, degi, Jesús-nuggi-barmilesmaladba bipirmakdii-guarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Deun Saulo, Bab-Jesús-nuggi, dobsuli sunmakdii-gualid, Judiomar-Griego-gaya-sunmakmalad-ebo dobsuli na abin-abin imakdii-gualid. Amardi Saulo-oburgwebi-gusmalanad, degite gwen oburgwissurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Gwenadgan-Bab-Jesúsba-nanaimalad degi-wisguarmargu, Cesarea-neggweburse Saulo-sesmalad, geb degi Tarso-neggweburse Saulo-barmismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Degisoggu, Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad bela Judea-yalagi, Galileagi, degi, Samariagi, nue bogidiki, dule e-bareginned-suli bukwa-gusmarsunnad. A-ulale, Bab-Jesúsba-nanaimalad burbar nue gangumai, Bab-Jesús dobee nanabukwa-gusmalad. Degine, Bab Dummad Burba Nued amar-ogannomai-gussunnad, ega Bab-Jesúsba-nanaimalad omelomai. ");
INSERT INTO cuk09_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro bela gwenadgan-bukmaladse atakdigua, Lida-neggweburgi gwenadgan-Jesucristogi-akananaimaladse ataknad-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A-neggweburgi Pedro dule-wargwen Eneas-nugad dakdapid, birga-baabakgus mai, geg nanae, ar ade bela e-abgan burgwaled. ");
INSERT INTO cuk09_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro Eneasga sogdesun: “Eneas, Jesucristo be-nudakoed. Be gwisgu, be-maid na be nudake, be nae.” Agi Eneas nugusgu, yog gwisguar imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pedro, Eneas-onudaksad-sorba belagwapa Lidagi, degi, Saróngi-bukwamalad daksamalad Eneas, nue-nugus gudii. A-ulale, amar Bab-Jesúsba nue nagunonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A-ibagangi Jope-neggweburgi ome-wargwen Bab-Jesúsba-nue-nai gusmogad, a-omede Tabita-nugad, Griego-gayabardi, Dorcasye-bileged. A-omede igar-nueganbi imakdiid, degi, wilegana nue bendakdii-daed-duled. ");
INSERT INTO cuk09_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","A-ibagangi Dorcasde uelealid, degine, burgwisad. Burgwisgu, nue ogsamalad-sorba, niba ailabirgi mesismalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope-neggwebur Lida-neggweburgi itakasaarsoggu, Bab-Jesúsba-nanaimalad Pedro Lida-neggweburgi gudiiye wisguarmargu, dule-warbo barmis-gusmalad, Pedro-sunamalagar. Amar Pedroga sogdapmalad: “Gwae Jopese dagoye, mer yoggudoye.” ");
INSERT INTO cuk09_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro dulemar-warbogwadba arsunnad. Jopese mosmargu, bia ailabirgi mui mai, ase Pedro-sesmalad. Mukwamar-ei-sui-burgwismalad Pedro-ebilis ambikusmargu, bela boedbimalad, suba, degi, mola ega oyodmalad, igi Dorcas dula gudigua, emarga mor maksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","A-sorba Pedro bela dulemar-onosgua, yokorgi sindigar sigisgu, Bab Dummadse goted. Pedro ome-burgwar-maid-sik dakdegu, ega sogded: “Tabita, gwisgu.” Degi a-ome ibya egad, agi Pedro-dakargu, sigiis imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro, argangi Dorcas gasaa imasgu, geb degi ogwichisad. Pedro a-sorba-Jesucristogi-akananaimaladse, degi, mukwamar-sui-ei-burgwismaladse, dula Dorcas-senonisunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Wegi-gusadi, bela Jope-neggweburgi wisgusmalad, degi, bukidar a-neggweburginmalad Bab-Jesúsgi bensur-gunonimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Agi Pedro Jopegi undar megialid, ibmar-ukagi-arbaed-walik, Simón-nugad-neggi. ");
INSERT INTO cuk09_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Deun Cesarea-neggweburgi dule-wargwen, Cornelio-nugadi, mai-gusmogad. A-dulede, Roma-sordamar-dulatar-sediid-duled, Roma-sordamar-danagwen-Italianaye-nugad, e-dummadid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ade, bane-bane Bab Dummadgi binsadiid-duled, nue bela e-neg-yaginmaladba Bab-Dummad-dobee-nanadimogad-dulebalid. Corneliode nue dule-wileganaga mani ukdibalid, deginbali, bane-bane Bab Dummadse gordii-dabalid-duled. ");
INSERT INTO cuk09_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","We-dulede e-ibya-apurud-gabdakeyob nue neg daksad, deun sedo wachi-irbaa-gusgu. Bab-Dummad-anger, Cornelio-maidse dognonikid, ega sognonikid: “Cornelio.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio nue-nuu anger-dakdegu, dobe itoded, ega sogded: “Dummad, ¿wede igid barsunna?” Anger, abin-sogde: “Be Bab Dummadse goledi, degi, be wileganaga mani ukedi, we-ibmar Bab Dummadse nakwisad, Bab Dummad we-ibmar gwen iegosulid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Degisoggu, Jope-neggweburse dulemar be barmid, adi Simón-sunamalagar. A-Simón, Pedroye-bimarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","We-Simónde, dule Simónye-nugmogad, ibmar-ukagi-arbaed, a-neggi maid. A-neg demar-gakasik siid. A-Simón-Pedro bega sogoed, ibu be imakoe.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Anger Cornelioga ibmar-sogsad-sorba nadgu, Cornelio ega-warbo-arbamaladse gochasun, degi, suar-ibed-wargwense gochabar, a-dulede Bab-Dummadse-nue-goled-dulemogad. Degisoggu, Cornelio a-dule-bensulid ega ibmar saoed. ");
INSERT INTO cuk09_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Corneliode amarga bela ibmar sogsagu, Jope-neggweburse barmissun, Pedro-sunamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Banedgine, Pedro-sunadapmalad igarba nadapmargu, bato Jope-neggwebur walikgusmargu, Pedro yorukudbali neg-uas-birgi nakwisad, Bab Dummadse golega. ");
INSERT INTO cuk09_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","A-wachigi Pedro nue-ukuur itoargu, mas gunbi-gualid. Mas imaknanaid edarbesigu, e-ibya apurud, gabdakeyob neg dakalid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Agi Pedro dakar nibneg argad, mor-sibu-dummadyob e-dukumar-bakegwadgi atinnar nibneggi aidedani, napnegse. ");
INSERT INTO cuk09_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mor-sibu-dummad-yagi ibdula-unimalad, ibdula napgi muski-muski nanamalad, degi, ibdula-gukualemalad, galagwensuli bukwa dakalid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Degi, dule ega soge itoalid: “Pedro, be gwisgu, ibmar-dula be oburgwe, be gunne.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Degi Pedro, abin-sogded: “Dummad, suli, an gunnosuli, ar ibmar-iskana, ibmar-isemaladi gwen an-gaya-yaba dogdisulid.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Degi, gaya-burba gannar gollarbalid, ega sogded: “Bab Dummad ibmar-ised-osulosadi, geg bar isedye be soged.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Deyob ilapaa Pedrose gaya-burba gocha-gusad. A-sorba ibmar mor-sibuyob-daklegedi gannar nibnegse nakwid-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro gabdakeyob na ibmar-daksadgi binsamai-gualid, wede, ibi nue obar-dibeye na ulubgi binsadsunnad. Pedro degi-binsamai, Cornelio machergan-walapaa-barmialidi, Simón-neg aminonimalad, degi, Simón-yawagak-naba gwisgunonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A-neggi, egisdemalad, “Wegi Simón-nugad, Pedroye-bimarbalid, mai sogeye.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pedro neg-burgan-daksadgi amba binsamai, Bab Dummad Burba Nued ega sognonikid: “Simón, be dake, dule-warbaa be-amididimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Degisoggu be gwisgu, be aide, degi, amarba be nae. Igi neg-burgan be daksa, ayobi we-dulemar an nudaksad, geg bar iseye be soged. Degisoggu, mer amar be benguo, eba be nao, ar ani an bese wemar-barmialid.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Degisoggu, Pedro aidearsun, bia Cornelio-dulemar-barmialid bukwadse, degi, amarga sognonikid: “Ani an Pedro, be an-amidimalad. ¿Degite, ibiga bemar an-amidimarsunna?” ");
INSERT INTO cuk09_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Amar, Pedro-abin sogded: “Roma-sordamar-dulatar-sediid, Cornelio-nugad, a-nuggi anmar danikid. A-dulede igar-napiragwadba-daed-duled, Bab-Dummad-dobegwaa-nanadiid-dulebalid. Deginbali, Judiomar bela a-dule nabir dakmalad, degi, bela bina sogedbimarbalid. Bab Dummad e-anger-swilidikba Cornelioga sogsad bese gordaye, ‘A ibmar-bega-sogoed, be nue itogoye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedro itosgu, degi-ega-ibmar-sogmala, neg-yaba amar-odossunnad. Agi ibagwen Pedro-walik gabismalad. Banedgine, amarba Pedro arsunnad, degi, gwenadgan-Jopegi-mamaid eba ali-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A-banedgine, Pedroba-nadapmalad Cesarea-neggweburse modapmalad. Agi Cornelio, degi, e-gwenadgan, degine, e-aimar-nuegan, Pedro-edarbe bukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro, Cornelio-negse dogdegu, Cornelio, Pedro-abin magaba noalid, degi, yokorgi Pedro-abin sindigar signonikid, Bab Dummadyob Pedro-odummogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedrodi Cornelio ogwichiis imaksad, ega sogded: “Mer Bab Dummadyob be an-imako. Be gwisgu, ar be-sunnaa an dulemogad.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pedro, Cornelio-ebo sunmaknadap neg-yaba dogdemargu, dulemar-bukidar-bukwa dakdapmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Degi Pedro amarga sogdesunnad: —Bemardi nue wismalad, anmar-Judiomar-igar-maidi ise-sailad, Judio-dule, Judiosulid-ebo igar itoged, degi e-negse geg dogbalid, ese ataknaegar. Degi-inigwele, Bab Dummad anga oyosad, mer ibmar-isediyobi, degi, ibmar-iskanayobi dulemar be dakoye. ");
INSERT INTO cuk09_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","A-ulale bemar anse gochamargu, gwen an binsassulid, mer nao-deeye, yog bemarse aligu an imaksad. Emigindi an wisgubisundo: ¿Ibiga bemar nue anse gorsimarsunna? ");
INSERT INTO cuk09_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio, Pedro-abin imakdesun: “Ibabakedo, we-wachigi, an-neggi Bab-Dummadse-golega deun mas-gunsuli an gudigu, sedogidbali, wachi-ilapaagi, Bab Dummadse an gorsigu, dule-wargwen, mola-dakar-dakar-gaed-yoi anse nonikid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Anga sognonikid: ‘Cornelio, Bab Dummad be-itosad ese be goled, degi, nue-yeer be-dakbalid wilegana be bendaked. ");
INSERT INTO cuk09_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Degisoggu, Jope-neggweburse be dulemar-barmid, Simón-sunaegar. A-dule, Pedroye-bimarbalid. We-Simónde, demar-gakasik maid, dule-ibmar-ukagi-arbaed-neggi, Simónye-nugmogad-walik. We-Simón-Pedro bese nonikile, bega ibmar sognonikoed.’ ");
INSERT INTO cuk09_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","“Degisoggu, aga dulemar an barmisad, be-sunaegar. Degisoggu, nued be imasdo, anmarse be argu. Emigindi, bela anmar Bab-Dummad-asabin ambikunonisunnad. Anmar be-itobimalad igi Bab Dummad anmarga sogoye bega sogsa.” ");
INSERT INTO cuk09_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro sunmakdesun, sogded: “Emigindi nue mag an itossunnad, inso Bab Dummad bela dulemar nue-emarbi-daked. ");
INSERT INTO cuk09_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ar doa-dule-dibe, Judio-dibe, Judiosur-dibe, a-dule nue Bab-Dummad-dobee nanadiile, degi, e-sogedbarbi gudiile, Bab Dummad a-dule geg obaned, nue abinga-daed. ");
INSERT INTO cuk09_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ar bemar wismalad Bab Dummad gaya-burba-nued Israel-dulemarga sogsad, ‘Gwage-bogidik-itoleged Jesucristoba an bemarga ukoye.’ We-Jesucristode bela dulemar Dummadga maisunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","“Emigindi belagwapa bemardi nue wismalad, Juan-Bautista Bab-Dummad-gaya-burbagi sunmaksagu, degi, Bab-Dummad-digi-ogleged-igar imaksad-sorba, igi Judea-yargi neg gusa, Galilea-yargi onodgu. ");
INSERT INTO cuk09_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Deginbali, bemardi nue wismarbalid, igi Bab Dummad Jesús-Nazaretginedga E-Burba-Nued uksa, degine, e-gangued ega uksabali. Degine, igi Jesús ibmar-nueganbi imakdii-gusbali, degi, igi dulemar-niaburbase-wiledimalad nudakdii-gusbali. Ar Jesús weyob gudigusad, ar ade Bab Dummad eba gudiguad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Emide nue-anmar-ibyagwar daksamalad, bela Jesús we-ibmar imaksad, Judea-yargi, degi, Jerusalén-neggweburgi. Anmar bela daksamarbalid igi Judiomar nakrusgi biokar Jesús-oburgwismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Degi-inigwele, Bab Dummaddi ibapaagi Jesús gannar odulosad, degi, anmarse magaroged imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Bela dulemarse Jesús magarossulid, unnila anmarse, gusgu Bab Dummad na idu anmar-susmaladse. Anmar, Jesús gannar durgusad-sorba, eba-mas-guchamalad, degi, eba-gobsamarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","“Degi, Jesús anmarga sogsad: ‘Be an-barsognamar, an-gaya-burbagi sunmaknamar, dulemarga sognamar: Bab Dummad, Jesús-barmiarye, dulemar-bukwadga, degi, dulemar-burgwismaladga igar-nabogega nugsalesye. ");
INSERT INTO cuk09_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Deginbali, bato Bab-Dummad-gaya-burba-berbemalad iduar sogsa-gusmogad, we-Jesúsgi, dulemar nue bensulile, a-dulemar abonolegoye, e-iskudiid, Jesús-nuggi Bab Dummad ega elioye.’ ” ");
INSERT INTO cuk09_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro amba sunmakgwichi, Bab Dummad Burba Nued belagwapa Pedro-itobukmaladgi ubononikid. ");
INSERT INTO cuk09_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Judiomar-Bab-Jesúsba-nanaimalad Pedroba-nonimaladi, geger dakdemalad, Judiosurmaladga Bab Dummad bela-bela E-Burba-Nued-uksamogad. ");
INSERT INTO cuk09_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ar ade itoarmalad, Judiosurmalad gaya-baid-baid sunmake, degi, Bab-Dummad-nug odummonanai. ");
INSERT INTO cuk09_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Geb degi Pedrodi sogdesun: —¿Doa Bab-Jesús-digi-ogleged-igargi we-dulemar mer ogoye sogmalosunna? ¿Ar anmar-sunnaa Bab-Dummad-Burba-Nued-abingasmarmosursi? ");
INSERT INTO cuk09_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Degisoggu, Jesucristo-nuggi a-dulemar Bab-Jesús-digi-ogleged-igar imakega, Pedrodi igar uksasunnad. A-sorba, a-dulemarde Pedrogi wilenagusmalad, wis ibabigbasaar emar-walik gudiguegar. ");
INSERT INTO cuk09_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jesús-nuggi-barmilesmalad, degi, gwenadgan-Bab-Jesúsba-nanaimalad Judeagi-bukwamalad, itoarmalad, dulemar-Judiosurmalad Bab-Dummad-gaya-burba abingasmarmoye. ");
INSERT INTO cuk09_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pedro Jerusalénse gannar nonigu, Judiomar-Jesúsba-nanaimalad, Pedrose uluarmalad, ");
INSERT INTO cuk09_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ega sogdemalad: —¿Ibiga Judiosurmalad-neg-yaba be dogdii, degi, eba be mas gundibali? ¿Wede isesursi? ");
INSERT INTO cuk09_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Agi Pedro ibmar-gebe-gualid-akar ilekwaa bela amarga sogdesunnad: ");
INSERT INTO cuk09_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jope-neggweburgi an mai, Bab Dummadse an gorsigu, neg-burgan an daksad, mola-sibu-dummadyobi, e-dukumar-bakegwadgi-atinnar nibneggi anse aidedani. ");
INSERT INTO cuk09_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nue an dakdegu, an dakalid, galagwensuli we-napneggi ibmar-durgan-unimalad, degi, achu-sapurbalid-bulegan, degi, nusmar-napagi-muskimakdimalad, degi, ibdula-sakan-nikamaladi, a-yagi bukwa an dakalid. ");
INSERT INTO cuk09_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","“Degi, dule niba anse gole an itosad: ‘Pedro, be gwisgu, we-ibmar be oburgwe, be gunne.’ ");
INSERT INTO cuk09_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Degi an abin-sogded: ‘Dummad, suli, an gunnosuli, ar ibmar-iskana, ibmar-isemaladi gwen an-gaya-yaba dogdisulid.’ ");
INSERT INTO cuk09_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Degi dule niba gannar anse gollarbalid: ‘Bab Dummad ibmar-ised-osulosadi, mer isedye be bar bie.’ ");
INSERT INTO cuk09_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Wegi-gusadi ilapaa gannar-gannar anga soglesad. A-sorbali gannar bela we-ibmar niba seled-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“A-sorbali, dulemar-warbaa Cesarea-akar an-amidanimalad, an-neg-maidse nonimalad, an-sedmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bab Dummad Burba Nued anga sokalid: ‘Eba be nae, mer benguo.’ Wemar-gwenadgan-walanergwadi anba nadmarmo, degi, dule-anse-gorsiid-negse an dogdapmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Agi a-dule anmarga sokalid, igi e-neggi ede anger-gwichi dakali, ega soge: ‘Jope-neggweburse dulemar be barmid, Simón bina naegar, a-dule, Pedroye-bimarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","A-Simón-Pedro bega sunmaknonikoed, agi be abonolegoed, degi, bela be-negginmalad abonolemogoed.’ ");
INSERT INTO cuk09_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“A-neggi an sunmakgwichi Bab Dummad Burba Nued Judiosurmaladgi aidenonikid, igi gebesaila anmargi aidenonigusmogadyob. ");
INSERT INTO cuk09_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Degi, Dummad-Jesús anmarga ibmar-sogsad insaas an naded, deun sogsa-gusgu: ‘Ar Juandi Bab-Dummad-digi-ogleged-igar imaksadi, unnila digi dulemar-ogsad, bemardi Bab Dummad Burba Nuedgi oglemaloed.’ ");
INSERT INTO cuk09_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bab Dummad, anmarga E-Burba-Nued-uksad anmar Dummad-Jesucristogi-bensulidba. Ayobi Bab Dummad dule-Judiosurmaladga E-Burba-Nued-uksamogad. Degite, ¿ande doa-dule-sunna, Bab Dummad igar an biskeye soger?” Geg an bisked. ");
INSERT INTO cuk09_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Bela Pedro ega ibmar sogsad itosmargu, bogidik ambikusmalad. Geb degi Bab-Dummad-nug ogannodmarsunnad, sogdemalad: “Degisoggu, Bab Dummad dulemar-Judiosurmalad na e-iskuedga ulubgi bukib-binsaed ega uksamogad, e-daed ogwaegar, adi nabir burba-geg-bergued nikumarmogagar.” ");
INSERT INTO cuk09_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Degidgine, Bab-Jesúsba-nanaimalad, Esteban-oburgwilesad-ular, deun baregilleargu, aisakid-gusmalad. Gwen-gwen nade-gusmalad, Feniciase, Chiprese, degi, Antioquíase. Amar dulemar-baiganga Bab-Jesús-gaya-burbagi gwen sunmaksasurmalad, unnila Judiomargarbi sunmaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Degi-inigwele, gwenadgan-aisakid-gusmalad gwen-gwen Chipre, degi, Cireneginmalad, Antioquíase modapmargu, Griego-dulemarga gaya-burba-nuedgi sunmakdapmalad, Bab-Jesúsgi. ");
INSERT INTO cuk09_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A-gwenadganba Bab-Dummad-gangued nue gudigusoggu, bukidar Bab-Jesúsgi bengussurmalad, degi, Bab-Jesúsba nagusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusaléngi Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad itoarmargu, Antioquíagi Judiosurmalad Bab-Jesúsba nagusmarmoye, Antioquíase Bernabé-barmiar-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Bernabé Antioquíase nonigu, daknonikid, Bab Dummad Judiomargi nued binsasayob, Judiosurmaladgi nued binsasmogad. Bernabé degi-daksagu, weligwar itosad, degi, gwenadgan-ogannoar, ega sokarsunnad, “Mer Bab-Jesús-igargi galakumaloye.” ");
INSERT INTO cuk09_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ar ade Bernabéde dule-nued-daed, degi, nue Bab-Dummad-Burba-Nued-nikabalid, agi Jesúsgi nue bensurbarsoggu, bukidar Bab-Jesúsba nagusmarbarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","A-sorba, Bernabé Tarsose nade-gusad, Saulo-amienaegar. Bernabé Saulo-amisgu, Antioquíase Saulo-senonikid. ");
INSERT INTO cuk09_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Agine, Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad-walik birgagwen gudigusmalad, Jesús-igargi dulemar-bukidar-odurdakdii-gusmalad. Deun a-neggweburgi gebe Bab-Jesúsba-nanaimalad, Cristianoye-binonimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A-ibagangi Bab-Dummad-gaya-burba-berbemalad Jerusaléngi bukwad, Antioquíase nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Agi Bab-Dummad-gaya-burba-berbeged-wargwen, Agabo-nugadi, sunmakdii-gualid, Bab-Dummad-Burba-Nued-nikadba dulemarga sokalid: “Bela we-napneg-naidgi, ukud-dummad daniye.” Dakleargu, Claudio Romagi dummadga maiunni, Agabo-sogsadyob gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Degisoggu, Antioquíagi Bab-Jesúsba-nanaimalad, gwenadgan-Judeagi-bukwamalad-bendake-sokarmarsunnad. Na ibmar-nikadba na ukdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Degisoggu, gwenadgan-bendakega gwenadgan-Judeagi-e-idumaladga-gudimaladse Sauloba, degi, Bernabéba ibmar barmis-gusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A-ibagangine Rey-Herodes gwen-gwen Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad wioar-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Rey-Herodes deun Santiago espunyargi oburgwed imaksad. Santiagode Juan-e-iad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herodes daksagu, deun ede Santiago-oburgwisad Judiomar yeer itosa, a-ulale, Pedro eskaryagi mete-sokarsunnad. Deunni a-ibagangi Madu-Inasuli-Gulleged-Iba naid. ");
INSERT INTO cuk09_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Herodes Pedro-gaega imaksagu, eskaryase metenad-gusmarsunnad. Geb degine, Pedrogi-nakulemalagala suar-ibmala-danabake-urbisbalid, danagwengi warbake. Herodesdi binsasad, iba-sorba dulemar-wagab Pedroga igar-itogoye, adi Pedro-oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Degisoggu, Pedrodi eskaryagi mellesiid, suar-ibedmardi egi nakulebukwa-gusmalad. Bab-Jesúsba-nanaimalad-danar-ambikunoni-damaladdi Pedroga ise Bab Dummadse gorbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herodes, Pedroga igar-itogoye sogsad-ibagi, a-mutik, deun oibodanigu, Pedro suar-ibmala-warbogwad-abargi, nue eskoro-dub-goabogwadgi ise-edinnar gabmai-gusad. Deginbali, suar-ibmala-baigan, yawagak-naba eskarya edarbegwichi-gusmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Agi Bab-Dummad-e-anger-wargwen Pedrose ukiar nonikid, eskaryagi gwallu-mee imaknonikid. Pedro-odakegala dikargi ebunonikid, ega sogdesunnad: “Gwae be gwisgu.” Degi, eskoro-dub-e-argangi-atinnaledi yog achikar naded. ");
INSERT INTO cuk09_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Degi, anger ega sogdebalid: “Mor be yoe, degi, nag-uka be yobar.” Anger-sogedba Pedrodi imaksasunnad. Degi anger Pedroga sogdebalid: “Be-suba be yobar, anba be dage.” ");
INSERT INTO cuk09_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro eskaryagi noargu, anger-sorba nai danisunnad. Anger-e-onodanikid Pedro nabirsurye bienad, na gabdakmaiye bienad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Anger, Pedro-ebo suar-ibmala-eskarya-edarbemalad-gebe-gwichimaladgi nasmalad, degi, a-sorba-gwichimaladgi nasmarbalid. Neggweburse-naed-yawagak eskoro-biidse modapmargu, wargwen ega argaded. Yawagakgi nosmargu, igar-wargwengi nasmalad, geb degi anger Pedrogi bangudsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Degi geb Pedro nue neg-itoargu, sogdesunnad: “Emigindi nue mag an neg-itosundo. Bab Dummad e-anger-barmialid, adi Herodesgi an wakinnega, degi, Judiomar bela bato an-oburgoedba weligwar-itobukmaladgi an-onosad.” ");
INSERT INTO cuk09_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pedro wegi-binsasad-sorba, María-negse modapsunnad. Maríade, Juan-e-nanad. Juan, Marcosye-bimarbalid. A-neggine deun dule-bukidar Bab Dummadse gorbukwa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro gebe-yawagak-idu-gwichidse gordapgu, yagwa-gwensak, Rode-nugadi abin noalid. ");
INSERT INTO cuk09_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","A-bunagwade Pedro-gaya mag itosgu, weligwar-itogedba ega yawagak gwen egassulid, aka gannar yaba abarmakde-gusad. Rode dulemarga sogdapid: “Pedro yawagak-naba gwichiye.” ");
INSERT INTO cuk09_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Amar bunagwaga sokarmalad: “Be goellebi-sii.” Bunagwa, “Napiraye,” amarga sognai-gualid. Degi amar sokarsunnad: “Wedi Pedro-e-anger gudiid.” ");
INSERT INTO cuk09_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedrodi binnasur yawagak ogornagusad. Ega yawagak egasmargu, Pedro-sunnad gwichi dakarmargu, nue geger dakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Mer dulemar oimakegala, Pedro argangi emarse achasad, degi, geb amarga sogdesunnad, igi Dummad-Jesús ede eskaryagi-siid e-onosa. Degi Pedro sogdebalid: “Santiagoga bela bemar sogoye, degi, gwenadgan-baiganga sogmarbaloye.” A-sorba Pedro node-gusad, degi, neg-baidsik edi nadsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Neg-oibosgu, suar-ibmaladi na beedse nue akusunna ito-guarmalad, ar wichurmalad igi Pedro gusa, bia nade. ");
INSERT INTO cuk09_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes suar-ibmala-barmissunnad, Pedro-aminaegar. Suar-ibmalade gwen Pedro-amissurgusmalad. Herodes Pedro-edarbismaladse nue egisnai-gualid. Ar ega nue ibmar sogmarsursoggu, igar uksasunnad, a-suar-ibmala oburgwemalagar. A-sorba Herodes Judea-akar Cesarease nadsunnad. A-neggweburgi Herodesdi megdapsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes deun a-ibagangi, Tiro-dorganse, degi, Sidón-dorganse urwediid. A-dulemar na igar-amismargu, Herodesse nonimalad. Blasto, rey-gabed-neg-ya-dakedse gornonimalad, ebo nue nuguegar, adi e-irwa Herodesga sunmakegar, ega igar-nabogegar. Ar ade Tiro, degi, Sidón-dorgan Herodesse mas bakbukmarsoggu, nue igar-nabobi guarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes, Tiro, degi, Sidón-dorganga iba uksagu, a-ibagi ese nonimarsunnad. A-ibagi Herodes rey-mor-yoed na yosad, degi, rey-gan-sigedgi na sigisad. Agi ega igar-nikaa yeer sunmaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dulemar-Herodes-itobukwad binnasur gotemalad: “We-dule-ibmar-sogsiidi dule gwen sunmaksulid, Bab Dummad sunmak an itoged.” ");
INSERT INTO cuk09_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Aka-a-wachigi Bab-Dummad-anger Herodesgi boni yononisunnad. Ar ade Herodes Bab-Dummad-nug odummossulid. Degisoggu, Herodes nusubi e-san-malemai burgwisad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bab-Jesús-gaya-burbadi nasgumai-gusad. We-gaya-burba-nued bela egi sunmaklemai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé, Saulo-ebo Jerusaléngi arbaed bergusmargu, Antioquíase nadmarsunnad. Juan eba nade-gusmogad. Juan, Marcosye-nugbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioquía-neggweburgine Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad-abargi Bab-Dummad-gaya-burba-berbemalad, degi, dulemar-odurdakmalad gudigusmarmogad. Amar Bernabé, Simón, Sichidye-bimarbalid, degi, Lucio-Cirenegined, agi Manaén, Rey-Herodes-tetrarca-ebo na dungusad, degi, Saulode. ");
INSERT INTO cuk09_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ibagwengi amar mas-gunsuli Bab Dummadse gorbukmargu, Bab Dummad Burba Nued ega sognonikid: “Bernabé, Saulo-ebo anga bachikii nugsamalo, adi an barmidega bia an oarbabi-gunaidse.” ");
INSERT INTO cuk09_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Degiid-sorba, gwenadgan mas-gunsuli Babse gochamargu, a-sorba Bernabé-nonogi, degi, Saulo-nonogi argan mesismalad, adi oyogegar, Bab Dummad wemar-susye, degi, wemar barminabarye. A-sorba gwenadgan Bernabé, degi, Saulo-barmismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Bernabé, Saulo-ebo Bab-Dummad-Burba-Nued-sogedba barmilesmargu, Seleuciase nadmalad, degi, agi mai, urgi Chipre-dupse obakdemar-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ar Bernabé, Saulo-ebo Salamina mosmargu, Judiomar-onmaked-negmargi Bab-Dummad-gaya-burbagi sunmakdemalad. Juan-Marcos, emar-bendakegala, eba nadapgusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bela Chipre-dupugi neggwebur-bukmaladse ataksamargu, Pafosse modapmalad. Agi Judio-wargwen, Barjesúsye-nugad abinguarmalad. A-dulede neled, degi, gakansaar dulemar-yardakdiid, sogdiid, ede Bab-Dummad-gaya-burba-berbegedye. ");
INSERT INTO cuk09_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","We-dulede, dule-dummad-wargwen, saila-Sergio-Paulo, dule-binsaed-ibed, aba gudiid. Saila-dummadde Bernabé, degi, Saulo-nik gocha-gusad, ar ade Bab-Dummad-gaya-burba itobimogad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ar ner-Elimasde, ar deyob e-nug oduloleged, saila-Sergio-Paulo-binsaed ganai-gualid, adi mer Bab-Jesús-igar abingaegar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Degi Saulo, Pabloye-nugbalid, nue Bab Dummad Burba Nued nikasoggu, ise-atakar Elimasgi atakdegu, ega sogded: ");
INSERT INTO cuk09_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Be bela-bela aimar-yardaked-dule, be dule-iskana, be nia-saila-machi, ibmar-nued-e-istarad. ¿Bab-Dummad-igar-nued-maid be ichodiid, ade be indakosurde? ");
INSERT INTO cuk09_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Degisoggu, emigindi Bab Dummad begi gwisgunonisunnoed; aku-atake be guoed, ibabigbasaale be dad-ibeler bar dakosulid.” A-sorba, yog Elimasgi nega-sichid nagunonisunnad, aku-atak gunonikid. Degisoggu, aka-aka dule-amidii-gualid, adi argangi e-nidmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Saila-dummad degi-ibmar-gusad daksagu, Bab-Jesúsgi bar gwen bengussulid, ar ade Bab-Jesús-igar-maid geger nue daked. ");
INSERT INTO cuk09_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo, degi, eba-gudimalad Pafosgi mai, urgi Pergese obakdemalad, Panfilia-yalaganba. Juan-Marcosdi egi banguded, adi Jerusalénse gannar ali-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","A-sorba Pergegi gudii, nade gusmalad Pisidia-yarse, Antioquía-neggweburse. Degi obunnoged-ibagi Judiomar-onmaked-negse dogdapmalad, agi sigidapmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moisés-igar-mesisad, degi, Bab-Dummad-gaya-burba-berbemalad-garda-narmaksamalad-absosmalad-sorba, Judiomar-onmaked-neg-e-dummagan Pabloga, degi, Bernabéga sokarmalad: “Gwenadgan, bemar gakagwensaar girmarga ibmar sogbiele, sunna bemar girmar-unaodo.” ");
INSERT INTO cuk09_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pablo gwisgus imaksagu, argan oyosad, adi bogidik ambikumalagar, nue e-itomalagar. Degi geb sogdesunnad: “Israel-dulemar, degi, bela bemar-Bab-Dummad-dobee-nanadimalad, nue an-itomalo: ");
INSERT INTO cuk09_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bab Dummad, anmar-Israel-dulemar-e-Bab-Dummad, anmar-dadgan-susa-gusad. Amba Egipto-yargi maiga gubukwamargu, Bab Dummad anmar-dadgan-omelosad. Geb degi na e-ganguedba a-yargi bukwa onosad, Canaán-yarse sedagegar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","“Birga-dulabosaar nega-dule-sulidganba anmar-dadgan-istar-nanaedba, Bab Dummad anmar-dadgan-bargadii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaán-yarse anmar-dadgan dognonigu, dulemar-akar-akar-sogagugle-bukmalad obelosad, geb amar-yar Bab Dummad anmar-dadganga uksa-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","We deyob gusadi, birga-dulataled-ilabake-gaka-dulabo-gakambe-wilub (450) deyob gusad. “Geb a-sorba, Bab Dummad anmar-dadganga dule-nabir-igar-nabiromalad ega uksa-gusad, Samuel, Bab-Dummad-gaya-burba-berbeged mai-gusadse. ");
INSERT INTO cuk09_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","A-sorba anmar-dadgan, rey-nikubi-guarmalad. Bab Dummadse rey-egichismargu, Bab Dummad ega Saúl, Cis-machi, uksa-gusad. A-dulede, anmar-dad-Benjamín-e-wagwad. Saúl birga-dulabo reyga mai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saúl-reyga-maid Bab Dummad obachagusad, geb David reyga mesnonikid. Bab Dummad David-nik sogsa-gusad: We-David, Isaí-machi, dule an-gwage-sunnaa-binsaed, a an-ibmar-abeged anga bela saoed. ");
INSERT INTO cuk09_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Bab Dummad bato iduar igar-mesisadba guegala we-dad-Davidgi Israel-dulemar-abonoged ogwisnonikid. We-dulede Jesúsye-nugad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesús amba yo nonikid-iduar, Juan-Bautista Bab-Dummad-igargi sunmaknonikid, Israel-dulemarga sognonikid: ‘Na be-ulubgi bukib binsamar, be-daed be gwagmarsun, degi, Bab-Dummad-digi-ogleged-igar be imakmarsun.’ ");
INSERT INTO cuk09_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan e-arbaed-wilubgan bergunaigua, sogde-gusad: ‘¿Doaye bemar an-bimala? ¿Bab-Dummad-dule-wargwen-barmidagoye-sogsad-duleye be an-bimala? An a-dulesulid. An-sorba-danikiddi anba bur-dule-dummadid, degisoggu, e-sapat-dubse-bakar geg an ei esiked.’ ");
INSERT INTO cuk09_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Gwenadgan, bemar-Abraham-e-waganye-sogbukmalad, degi, bemar-Judiosurmalad degi-inigwele Bab-Dummad-dobee-nanadimalad, bemarga we-gaya-burba-nued barmilenaid, adi bemar abonolemalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ar Jerusaléngi-bukmalad, degi, e-dummagan, Jesús-aku-daksamalad. Degine, Bab-Dummad-gaya-burba-berbemalad-narmakar-maid, itoged-irba obunnoged-ibagi absodimalan-inigwele, aku amba itosmalad. Degite, dummagan Bab-Dummad-Gardagi-narmakar-naidba imaksamalad, deun Jesús-oburgweye sognonimargu. ");
INSERT INTO cuk09_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Amarde gwen oburgwed-igar Jesúsga mai daksasurmalanad, degite Pilatose egisnanai-gusmalad, ega Jesús-oburgwegar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ar igi Bab-Dummad-Gardagi Jesúsgi narmakar nai, deyob bela gusgua, nakrusgi-naid odesmargu, geb degi neg-uangi digsa-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","“Ar Bab Dummaddi Jesús-burgwar-maid gannar odulos-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","A-Jesús, Galilea-akar-Jerusalénse-eba-nade-gusmaladse na ibbigbasaale magarodii-gusad. A-dulemar emide dulemar-baiganga Jesúsgi na-ibmar-daksamaladba sunmakdimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“We-gaya-burba-nued anmar-dadganga sogles-gusad, anmar bemarga egi sunmakdimarmosundo. ");
INSERT INTO cuk09_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ar anmar e-wagan gusoggu, anmarga Bab Dummad we-Jesús-burgwar-maid na odulononikid, ar igi bato narmakar Salmo-bogwadgi nai: Be An-Machi-sunnad, emi-ibagi an bega oyonaid, an be-Bab-sunnad guye. ");
INSERT INTO cuk09_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Degi, adi mer Jesús-san nunguegala, Bab Dummad gannar Jesús-odulosye sogedgi, Bab Dummad e-gaya-burbagi bato weyob idu sogsa gusad: Davidga ibmar-napiragwad an nue ukoye sogsadi, bega an ukoed. ");
INSERT INTO cuk09_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Aga Salmo-baidgi sognaibalid: Dule-swilidikid-e-san neg-uangi nungued be imakosulid. ");
INSERT INTO cuk09_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Ar David Bab-Dummad-sogedba e-dulamarga ibmar imaksad. David burgwisgu, e-dadgan-abargi diglesad, geb e-san nungusad. Degisoggu, David na dukin egi sunmaksasulid, Jesús-nik sogsagusad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ar we Jesúsdi, Bab Dummad ogwichisad, adi e-san nungussurgusad, ar ade Jesús burgwar-maigu, Bab Dummad odulosad, degisoggu e-san nungussurdo. ");
INSERT INTO cuk09_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Degisoggu gwenadgan, bemar wisgue-wilubbid, anmar bemarga-sogdiid anmar-gwage-iskudimalad, Jesúsgi nabir gwage iskussuliyob gunoni-daed. ");
INSERT INTO cuk09_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","A-ulale, bela dulemar Jesúsgi-bensurmalad, gwage nudaklenoni-daed, ar Moisés-igar-uksaddi geg dule-gwage nudaked. ");
INSERT INTO cuk09_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Degisoggu nue salakarmar, abakalegi Bab-Dummad-gaya-burba-berbemalad-narmaksad bemar-nik we sogele, deun sogsa-gusgu: ");
INSERT INTO cuk09_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Nue be itomar, bemar Bab-Dummadgi-dododimalad, degi, egi-bengudimarbalid. An ibmar-bemar-abargi-imakoedi, geger bemar dakmaloed, degi, bemar burgwemaloed. An ibmar-bemar-abargi-imakoedi dule-baid bemarga sogena, bemar bengumaloenad.” ");
INSERT INTO cuk09_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pablo, degi, e-sordamar Judiomar-onmaked-neggi noarmargu, Judiosurmalad egi wilenagusmalad, adi emarga gannar obunnoged-iba-baidse Jesús-igargi ega sunmakdamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pablo, degi, Bernabémala Judiomar-onmaked-neggi ainidmargu, Judiomar, degi, Judio-igar-abingasmalad, Pabloba, degi, Bernabéba bukidar nade-gusmalad. Amarga Pablo sunmakalid, “Nue salakarmarye, bemar Bab-Jesús-igar-amismalad mer a-igar be iemaloye.” ");
INSERT INTO cuk09_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Obunnoged-iba nonigu, neggwebur belasaale ambikunonimalad, adi Bab-Dummad-gaya-burba itomalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Judiomar dulemar-bukidar-bukwa dakargu, nobgudmalad. Pablo ibmar-soggwichidi ichodmalad, degi, ukabsadmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Degi Pablo, Bernabé-ebo nue-dobsuli sunmakdemalad, Judiomarga sogdemarsunnad: “Ar bemargar-insa Bab-Dummad-gaya-burba soglegoye igar soglesanad. Ar bemar abingasurmarsoggu, bemar baisur-dakedba burba-geg-bergued yapa niku-gusmalad. Degisoggu, anmar Judiosurmaladga we-gaya-burba sunmaknamarsunnoed. ");
INSERT INTO cuk09_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ar Bab Dummad bato deyob anmarga igar uksad, anmarga sogsad: Judiosurmaladga gwallu-mee saegala an be-ogwismar, adi bela napneg-ugakase mag itomalagar, ulubgi abonoleged-igar.” ");
INSERT INTO cuk09_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Judiosurmalad Pablo wegi-soge itosmargu, yeer itodmalad, degi, “Bab-Dummad-gaya-burba, nuedye,” sogdemarsunnad. Degi, bukidar burba-geg-bergued abingaoye ga igar-maidga, amar bela Bab-Jesúsgi-bengussurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Agi Bab-Jesús-gaya-burba-nued a-yalaganba bela aisakidsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ar Judiomardi, omegan nue-Bab-Dummadgi-binsadimaladse, degi, nue-nug-nikamaladse, degi, machergan-neggweburgi-nue-nug-nika-gudimaladse nade-gusmalad, adi Pablo, degi, Bernabé-bareginmalagar. A-yargi a-dulemar Pablo, degi, Bernabé-onoedse imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pablo, degi, Bernabé-ebo a-neggweburgi nodmargu, e-naggi-olli-nanaid obad-obad imaksamalad. Degi-saedi, sogleged: “An be bar wichur, an bega Bab-Jesús-igargi sunmaksamarmoganad, emigindi na be itolegedmarsundo.” Degi Pablo, degi, Bernabé Iconiose nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Bab-Jesúsba-nanaimalad bela nue-weligwar itosmalad, degi, nue Bab-Dummad-Burba-Nued-nika gudigusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconiogi Pablo, Bernabé-ebo Judiomar-onmaked-negse dogdapmalad. Agi Bab-Jesús-igargi nue-yeer sunmaksamarsoggu, bukidar Judiomar, degi, Griego-dorgan Bab-Jesúsgi bengussurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ar Judiomar-Bab-Jesús-bengusmaladdina yamo Judiosurmalad-binsaed gaarmalad, adi Bab-Jesúsba-nanaimaladgi aibinmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ar Bab-Jesús-bengussurmalad-ichesulidba, Pablo, Bernabé-ebo suibaksaar Iconiogi megiarmarsunnad. Pablo, Bernabé-ebo nue-dobsuli gandikidba Bab-Jesús-dulemar-abonoged-igargi sunmakarmalad, Bab-Jesúsgi bensuli-gudiguarmalad. Pablo, Bernabé-ebo ibmar-soged nabir guegala, Bab Dummad amarba ibmar-wilubgan-dakledisulid, degine, ibmar-geger-daklemalad-imakega imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iconio-neggweburginmalad darbo binsabukwa-guarmalad: Abar Judiomarba nai, abar Bab-Jesús-nuggi-barmilesmaladba nai. ");
INSERT INTO cuk09_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Judiomar, degi, Judiosurmalad na igar amismalad, neggwebur-sailamarbo, adi Pablo, degi, Bernabé sabsur imakmalagar, degi, akwagi-makar oburgwemalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ar Pablo, Bernabé-ebo degi-wisguarmargu, Listrase, degi, Derbese wakite-gusmalad. Agi nade-gusmarbalid, neggwebur-walik-nanaidse. A-neggweburmarde Licaonia-yargi naid. ");
INSERT INTO cuk09_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Agi Bab-Dummad-gaya-burba-nuedgi sunmakdii-gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra-neggweburgi dule-wargwen gusgu muu-neggi-geg-nanae-aidenonikid sii-gusmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A-dulede Pablo-sunmaked itosii-gusmogad. Pablo, dule-geg-nanaed nue-nuu dakdegu, mag daksad, we-dule sunna nudaklegega nue bensulid. ");
INSERT INTO cuk09_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Degisoggu, aga Pablo binnasur sogdesunnad: “Be-naggi be gwisguden.” Dule gwisgus imasgu, yog ichomakar, degi, yog nanaar-naded. ");
INSERT INTO cuk09_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Dulemar Pablo-wegi-ibmar-imaksad daksamargu, Licaonia-gayaba oimakdemalad, sogdemalad: “Bab-dummagan anmar-abargi dulemaryob aidenonimarye.” ");
INSERT INTO cuk09_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Amar Bernabé, Jupiterye-bismalad. Pablodi Mercurioye-sogdemalad, ar ade Pablo bur sunmaked. ");
INSERT INTO cuk09_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jupiterse-goled-neg, neggwebur-dogegwagi siid, a-neg yawagakse, dule-irwa-Jupiterse-goled, molimar-bebe-nikad, degi, dutumar-sobarmalad-nue-nudakar senonikid. A-dule, degi, dulemar-baiganmo, Pabloga, degi, Bernabéga, moli-oburgwebi-guarmalad, ar igi Bab Dummadga imakdamaladyob. ");
INSERT INTO cuk09_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jesúsgi-nuggi-barmilesmalad Pablo, Bernabé-ebo degi-dakarmargu, na e-mor esirmakdemalad, degi, dulemar-bukidarad-abargi dogdemalad, geb agi binnasur gotemalad, sogdemalad: ");
INSERT INTO cuk09_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“¡Girmar! ¿Ibiga bemar degi-damala? Anmar bemar-sunnaa dulemarmogad. Aga anmar bemarse danikid, bemarga sogegar, we igar-iskanamar-binsarmalad, be osulomar, Bab-Dummad-sunnadba bur be nagumar, ar a-Bab dula-maid, a nibneg nasiksad, napneg nasiksad, degi, demar nasiksabalid. Deginbali, bela ibmar-agi-dula-bukwad nasiksabalid. ");
INSERT INTO cuk09_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Epennedi, Bab Dummad dulemar-yar-baid-baidgi-bukmalad na e-itoleged, na e-daedba nanaega imaksasunnad, bar bai-daksasulid. ");
INSERT INTO cuk09_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Degi-inigwele, Bab Dummad wargwen anmar-obessulid, anmarga ibmar-nuegan-imakedba e-gangued, degi, e-sabgued oyomai-gusad. Anmarga di-owimai, yor-nued-ibmar-osanmaked nasikmai, mas unniguale ukmai, degi, weligwar-itoleged anmarga ukmai-gusad.” ");
INSERT INTO cuk09_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ar weyob Pablo, degi, Bernabé dulemarga ibmar sogsamargu, dulemar Pabloga, degi, Bernabéga moli-bebe-nikad-oburgwebimalad ugak bargasmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","A-ibagangi Judiomar-Antioquíaginmalad, degi, Iconioginmalad nonimalad, geb amar girmar-binsaed gasmargu, akwagi Pablo-maksamalad. Amar bato Pablo-oburgwisye bimarsoggu, neggwebur-dikarba Pablo-metemarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ar Bab-Jesúsba-nanaimaladdi Pablo-ebilis ambikunonimarsunnad. Pablo neg wisguargu, gwisgus imaksad, agi Pablo gannar neggweburse nade-gusad. Degine Pablo, Bernabé-ebo oibosgu, Derbe-neggweburse nade-gusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pablo, Bernabémala Derbe-neggweburgi Bab-Dummad-gaya-burba-nuedgi sunmaksamargu, bukidar Bab-Jesúsba nagusmalad. A-sorba Listrase, degi, Iconiose, agi, Antioquíase gannar nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","We-neggweburmargine, Pablo, Bernabé-ebo Bab-Jesúsba-nanaimalad gwage ogannodmalad, degi, nue unasmarbalid, Jesúsgi-bensulid-igargi. Amarga sogsamarbalid, “Bab-Dummad-neg-dakmaidse dogegala, anmar-idu beedse-igar-maiye, nue naibi-itoleged-igarye.” ");
INSERT INTO cuk09_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pablo, Bernabé-ebo Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad-irba na e-idumalad-nugsasmarbalid. Mas-gunsuli Bab-Dummadse-gochad-sorba, we-dummagan Bab-Jesúsga obessunnad. Ar amarde we-Jesús na bengussurmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","A-sorba Pablo, degi, Bernabé-ebo Pisidia-yargi nasmargu, Panfilia-yarse nonimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Agi Perge-neggweburgi Bab-Jesús-igargi sunmaksamarbargu, geb a-sorba Atalia-neggweburse nonimarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Agi Pablo, Bernabé-ebo urgi nakwismalad, Antioquíase armarsunnad, bia Bab Dummadga uklesmala, na Bab-Dummad-e-sogedba e-igargi sunmakegar. Emide Pablo, Bernabé-ebo a-arbaed nue-imaksa obelosmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Antioquía-neggweburse modapmargu, gwenadgan-Bab-Jesúsba-nanaimalad-danar-ambikunoni-damaladse gochamalad. Agi Pablo, Bernabé-ebo amarga sogdemalad, igi Bab Dummad Judiosurmaladga nabir igar egasmoga, adi amar nabir Bab-Jesúsgi bensuli-gunonimarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo, Bernabé-ebo Antioquía-neggweburgi gwenadgan-abargi suibaksaar megiar-gusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","A-ibagangi dulemar-Judeagi-danimalad Antioquíase nonimalad, gwenadgan-odurdakarmalad, sogdemalad: “Ar be abonolebiele, Moisés-igar-mesisadba abgan-duku-siked-igar be imaker-gebye.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo Bernabémala, dulemar-Judeagi-danimalad-ebo binnasur abin-abin na imakarmalad. Degisoggu, gwenadgan Pablo, degi, Bernabé, degi, gwenadgan-baiganmala-nugsasmarsunnad, adi Jerusalénse, Jesús-nuggi-barmilesmaladse, degi, Bab-Jesúsba-nanaimalad-e-idumaladse abgan-duku-siked-igar nue baraminamalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pablo, Bernabé, degi, gwenadgan-baigan Bab-Jesúsba-nanaimalad Antioquíagi-danar-ambikunoni-damalad-sogedba barmilesmargu, Fenicia-yalaganba, degi, Samaria-yalaganba nadap-gusmalad. Agi gwenadganga sognadap-gusmalad, igi Judiosurmalad yeer Bab-Jesús-abingasmarmoga. Gwenadgan we-gaya-burba-nued, nue yeer itosmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Pablo, Bernabé-ebo Jerusalénse mosmargu, Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad nue yeer abindaksamalad, degi, Jesús-nuggi-barmilesmalad, agi Bab-Jesúsba-nanaimalad-e-idumaladga gubukwad, amar nue yeer abindaksamarmogad. Pablo, degi, Bernabé, amarga sogdesunnad, igi Bab Dummad emargi igar imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Gwen-gwen Fariseomar, Bab-Jesúsgi-bensurmarmogad, sokarmalad: “Judiosurmalad-Bab-Jesúsba-nagusmarmogad Moisés-igar-mesisadba abgan-duku-siked-igar imaker-gebye, degi, bela Moisés-igar-maidba daer-gebye.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Degisoggu, Jesús-nuggi-barmilesmalad, degi, Bab-Jesúsba-nanaimalad-e-idumalad na ambikunonimarsunnad, adi na igar baramimalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Undar na abin-abin imaksamalad-sorba, Pedro amar-abargi gwisgusgu, sogdesun: “Gwenadgan, bemar nue wismalad, undargus Bab Dummad bemar-abargi an-susad, we-gaya-burba-nuedgi Judiosurmaladga sunmakegar, adi amar nabir abonolemogagar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bab Dummad ulubgi ar dulemar mag daksoggu, anmarga oyosad, a-dulemar ede abingamoye, degi, E-Burba-Nued anmar-sunnaa amarga uksamoye. ");
INSERT INTO cuk09_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Bab Dummad, Judiosurmalad, anmar-ebo akar gwen daksasulid. Anmar-sunnaa Dummad-Jesús bensurmogale, amarga gwage-swilidik imaksamogad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","“Emiginde, ¿ibiga bemar Bab-Dummad-wilubdakmarsunna? Emide gwenadgan-Judiosurmalad-Bab-Jesús-abingasmaladga bemar soggu: ‘Ar bemar Moisés-igar-mesisadba dasurmalale, geg be abonolemarye.’ Ar anmar-dadgan, degi, anmar-bela, a-igarba nanabimar-inigwele, anmar ese galakud-daed. ");
INSERT INTO cuk09_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ar anmar wisid, Bab-Jesús anmar-abonoge-wilubsulinad, ar emigindi nabir-anmargi-binsaedba, anmar abonoleged. Ar Judiosurmalad anmar-sunnaa abonoleged-igar ega maimogad.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pedro-itobukmalad bela nue bogidik ambikusmalad. Degi Pablo, Bernabé-ebo dulemarga sunmakarmarsunnad, igi Bab Dummad na e-nuggi, Judiosurmaladga ibmar-wilubgan-dakledisurmalad-dummagan, degine, ibmar-geger-daklemalad emarba imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pablo, Bernabé-ebo bela ibmar sogsamargu, Santiago sogded: “Gwenadgan, nue be an-itomarmogo: ");
INSERT INTO cuk09_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro anmarga sogsad, igi gebesaila Bab Dummad Judiosurmalad na susmoga, adi na e-dulemarga saegar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","We-igar ar bato Bab-Dummad-gaya-burba-berbemalad-sogsadgii gunonido, deun Bab-Dummad-Gardagi narmaksamargu, Bab Dummad sogye: ");
INSERT INTO cuk09_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ar sorba gannar an nonibalir, David-neg-sobsad ayarar-siid, gannar an sobbaloed. A-neg bibiskar-siid, gannar an nudakoed, degine, a-neg gannar an obino-nonikoed. ");
INSERT INTO cuk09_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Adi bela dulemar an-amimalagar, degi, Judiosurmalad-anse-gordimalad, amar an-amimarmogagar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Weyob, ani, Bab Dummad soged, ar ade nega-gebesailaunni bato weyob idu an owisos-gusad.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Degi Santiago sogdebar: “Degisoggu, a-ular an sogsundo, Judiosurmalad Bab-Jesúsba nagumalaga, igar-iskana-indakmaid, amar mer ei-igar an oburmaloed. ");
INSERT INTO cuk09_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Unnila anmar Judiosurmaladse garda narmakmalodo, ega sogmalodo: ‘Bab-dummadga-imaklegedga ibmar-uklesmalad mer gunmaloye, degi, mer galagwensuli neg-sichigi ome-dikarba, degi, sui-dikarba yoledigumarbaloye. Agine, ibmar-gammu-gaar-oburgwilesmalad mer gunmarbaloye, degi, mer abe gobmarbaloye.’ ");
INSERT INTO cuk09_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ar aga epenne neggwebur-irba, Judiomar-onmaked-neggi, Moisés-igar-mesisadgi-odurdakmalad nika-gusad, degi, aga itoged-irba obunnoged-ibagi we Moisés-garda absoledabalid.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Santiago-sunmaksad yeer itosmargu, Jesús-nuggi-barmilesmalad, degi, Bab-Jesúsba-nanaimalad-e-idumalad, degine, bela Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad nabir itosmalad, na e-sordamar Antioquíase Pabloba, degi, Bernabéba barmided. Judas-susmalad, a Barsabásye-bimarbalid, degi, Silas. Amarde gwenadgan-abargi nue nug-nikaa gudimarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Amarbali garda-wegi-narmaksa barmismardo: “Anmar Jesús-nuggi-barmilesmalad, degi, gwenadgan-Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad, degi, e-idumalad, anmar bemar-Judiosurmaladse garda wis narmakmar, bemar Antioquíagi, degi, Siria-yargi, deginbali, Cilicia-yargi-bukmaladse. ");
INSERT INTO cuk09_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Anmar wisgualid, wegi anmar-walik gudii bese nadmalad, anmar gwen ega igar-uksasulid, amarde e-sunmakedgi bemar igar-oburnoniye. Amar bemarga sogmarye: ‘Abgan-duku-siked-igar bemar imaker-gebye, degi, igar-baigan Moisés-mesisadba bemar daer-gebbarye.’ ");
INSERT INTO cuk09_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","“Degisoggu, aga anmar bela wegi nabir itosmalad, gwenadgan-anmar-na-nue-sabedba Pablo, degi, Bernabéba, anmar-sordamar barmided. Adi amar, anmar-nuggi bemarga ibmar sogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Aginbali anmar nue wisid, Pablo, degi, Bernabé, Dummad-Jesucristo-nuggi-sunmaked-ular burgwednaga gusmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","“Degisoggu, anmar bega Judas, degi, Silas barmidsunnad, adi bemarga bela ibmar nue gayagi sogegar. ");
INSERT INTO cuk09_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Bab Dummad Burba Nued, degi, anmarmo nabir itosmalad mer bemargi igar-dutusur mesed. Unnila we-igarmar nue-imaklebi-abelegedgindi nue salakarmalo: ");
INSERT INTO cuk09_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Bab-dummadga-imaklegedga-ibmar-uklesmalad mer gunmalo, degi, mer abe gobmarbalo, agine, ibmar-gammu-gaar-oburgwilesmalad mer gunmarbalo, degi, mer galagwensuli neg-sichigi ome-dikarba, degi, sui-dikarba yoledigumarbalo. Ar we ibmarmar bemar imaksulile, igar-nued be imakmalodo. Be itomargua.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Degi Judas, Silas, Bernabé, Pablo, amar gwenadgan-baiganmala, Antioquíase nadmarsunnad. Antioquíase modapmargu, gwenadgan-Bab-Jesúsba-nanaimalad-danar-ambikunoni-damaladse gochasun, degi, ega garda uksamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Gwenadgan garda absosmargu, bela weligwar itosmalad, ar ade ulubgi nue e-ogannonai itosmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ar Judas, degi, Silas, Bab-Dummad-gaya-burba-berbemaladbarsoggu, gwenadganga bela-bela sunmakdegu, gwenadgan yeer-ito imaksad, degi, gwenadgan aka-bur-bule Bab-Jesús-igargi gangudmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Amar undar-megedgine, gwenadgan-Jerusaléngi-bukmaladse, Judas, degi, gwenadgan-baigan-eba-nonimalad gannar nuedgi barmismarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silasdi na Antioquíagi beoye sokalid. ");
INSERT INTO cuk09_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo, degi, Bernabé Antioquíagi besmarmogad. Amar, gwenadgan-baiganmala, Bab-Jesús-igargi odurdakdii, degi, Bab-Dummad-gaya-burba-nuedgi sunmakdii-guarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","A-undarad-sorbali, Pablo Bernabéga sokar: “Anmar gannar neggwebur-irba namar, bia anmar Bab-Jesús-gaya-burbagi sunmakdii-gusadse. Gwenadganse ataknamalo, adi anmar dakega, igi gwenadgande gubukmar-dibe.” ");
INSERT INTO cuk09_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé, Juan, a Marcosye-bimarbalid, na emarba nidbi-gualid. ");
INSERT INTO cuk09_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablodi yapa Juan-Marcos nide-gualid, ar ade we-dule Panfilia-yargi emargi bangud-gusad, emarba Bab-Jesús-igargi bar arbadsulid. ");
INSERT INTO cuk09_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pablo, Bernabé-ebo nue abin-abin imaksamarsoggu, na egi bangudmarsunnad. Bernabé, Marcos sesa-gusad, degi, Chiprese urgi nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablodi eba naega Silas-susa-gusad. Gwenadgan-Bab-Jesúsba-nanaimalad ega Babse gochamargu, Bab Dummadga uksamarsunnad, adi Bab Dummad amar-dakega. Degi geb Pablo, Silas-ebo nadmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pablo Siria-yargi, degi, Cilicia-yargi Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad ogannodii-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo Derbe-neggweburse, degi, Listra-neggweburse modapsunnad. Agi dule-wargwen Bab-Jesúsba-naid mai dakdapid. A-dulede Timoteoye-nugad. Ade e-nan Judiod, Bab-Jesúsba-nue-naimogad. E-babdi Griego-dolad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Gwenadgan Listraginmalad, degi, Iconioginmalad, bela yeer Timoteogi sunmakedbimalad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo Timoteo-nidbigualid, aga abgan-duku-siked-igar imakega imaksad, adi Judiomar mer Timoteogi akar sogmalagar, ar bela wismalad, e-bab Griego-duled. ");
INSERT INTO cuk09_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pablo, Silas-ebo belagwapa neggwebur-irba gwenadganga sognadap-gusmalad, igi Jesús-nuggi-barmilesmalad, degi, Bab-Jesúsba-nanaimalad-e-idumalad Jerusaléngi-bukmalad, Judiosurmaladga igar-mesismala. ");
INSERT INTO cuk09_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Degisoggu, Bab-Jesúsba-nanaimalad-danar-ambikunoni-damalad ulubgi Bab-Jesús-igargi gannaledmarsunnad, degine, bane-bane Bab-Jesúsba-nanaimalad mergumai-gusad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pablo, Silas-ebo Frigia-yalaganba, degi, Galacia-yalaganba nadmarsun, ar ade Bab Dummad Burba Nued Asia-yargi Pablo Bab-Jesús-gaya-burbagi sunmaked gwen imaksasulid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Pablo, Silas-ebo Misia-yar-abingunaidse modapmargu, Bitinia-yarse dogoye sogsamalanad, degi-inigwele, Bab-Jesús-Burba-Nued a-yarse dogega gwen imaksasurbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Degisoggu, Misia-yargi bakar nasmargu, Troasse modapmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A-neggweburgi Pablo mutikba gabdakalid, neg-burgan dakalid, dule-wargwen Macedoniagined, e-asabin gwichi, egi wilenai, ega sognai: “Macedonia-yarse be dage, anmar-bendakega.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo we neg-burgan daksad-sorba, yog anmar Macedonia-yarse naesokarsunnad. Ar anmarga Bab Dummad nue oyos anmar itomalad, anmarse gornai, “An-gaya-burba-nuedgi we-neggweburmarse be sunmaknamarye.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Degisoggu, urgi anmar Troas-akar inik-baksa Samotracia-dupse nade-gusad. A-banedgi geb anmar Neápolisse omodapsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Neápolisgi geb anmar nadbalid, Filiposse. A-neggweburgi Romayob neg-selemaid, degi, Filipos-neggwebur Macedonia-yargi bur neg-nug-nikaa simogad. Agi anmar ibbigbasaar megialid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Obunnoged-iba mosgu, anmar neggweburgi bangudmalad, diwar-gakase anmar nadmarsunnad, bia gusgu Bab-Dummadse-golega nad-damaladse. Agi anmar sigisgua, Bab-Jesús-gaya-burba-nuedgi omegan-ambikunonimaladga sunmakdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ome-wargwen, Lidia-nugad, Tiatira-neggweburgined, anmar-itosii-gusmogad. A-omede mor-nued suir-akwagii-dakleged ukedid. Lidiade nue Bab Dummadse gordimosoggu, Bab-Jesús e-gwage ebunonisunnad, adi Pablo-ibmar-soged abingaegar. ");
INSERT INTO cuk09_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidia Bab-Jesús-abingassoggu, Bab-Jesús-digi-ogleged-igar imaksasunnad, degi, e-neg-yaurginmalad degi-imaksamogad. A-sorba Lidia anmargi wilenaigusad, anmarga sogded: “Nue-Bab-Jesúsba-nai be an-dakele, an-negse be obunnodamardo.” Degisoggu, e-neggi-meged anmar-imaksasundo. ");
INSERT INTO cuk09_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ibagwengi, anmar Bab Dummadse gornadapmargu, bunagwa-wargwen, igarba anmar-abingualid. A-bunagwade nelegwad, niaburba-nikadid, degine, dule-baid-maiga gudibalid. A-bunorde idu-ibmar-guoed-sogedgi e-ibmalaga mani-dummad onodiid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","We-bunagwade Pablo-sorba, degi, anmar-sorba nai, binnasur gordani-gualid, sogdani: “We-dulemar Bab-Dummad-Bur-Dummadidga-arbamalad-dulemalad, bemarga abonoleged-igargi wemar sunmakdanimalad.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Degi bane-bane bunagwa anmar-sorba gordigusoggu, Pablo sae-itoargusad. Pablo aibilis imaksagu, niaburba-bunagwagi-maidga sogded: “Jesucristo-nuggi an bega soged, bunagwagi-be-maid emispinne be nodasun.” Niaburba bunagwagi yog noar imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bunagwa-e-ibmala bar mani-dummad ega onogosur dakarmargu, Pablo, degi, Silas-gasmalad, geb dummaganse senonimalad, igar-itoged-negse. ");
INSERT INTO cuk09_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Igar-nabiromalad-asabin ogwisnonimargu, sogdemalad: “We-dulemar, Judio-dorgan, na-e-damaladba anmar-odurdakdanimalad, degisoggu, anmar-dulemar-ichodanimardo. ");
INSERT INTO cuk09_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ar anmardi Roma-dulemarsoggu, e-damalad geg anmar abingamalad, degi, geg anmar eba damarbalid.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Degisoggu, dule-bukidar Pablo, degi, Silasgi gwisguarmarsunnad, ese uludmarsunnad. Igar-nabiromalad ei-mor esuega imaksamalad, geb suargi bibyoged-igar ega mesismarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Pablo, degi, Silas-sabsur-sarsosmalad-sorba, eskaryagi metemalad. Eskarya-dakedga igar uksamalad: “Nue we-dulemar-dakoye, abakalegi begi wakinnalirye.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eskarya-daked degi-ega-igar-uklesgu, gatik eskarya-yaba bur-dogaledse Pablo, degi, Silas-odossunnad. Aginbali, cepo-yaba Pablo, degi, Silas-e-nag ise-odoar imaksabalid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nega-gabigwenadba Pablo, Silas-ebogwa Bab Dummadse gorbukwa, degi, namakar Bab-Dummad-nug odummobukwa-gusmalad. Deun dule-baigan-eskaryagi-mellesimalad, Pablo, degi, Silas-itobukwa-gusmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Degidgine, ukiar neg-obandur nagunonigu, neg-giglimakded, eskarya e-maliganse-bakar giglimakdemogad, eskarya-yawagakmar bela argaded, degi, dulemar-eskoro-dubgi-atinbukmalad bela achikdemalad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Eskarya-daked atakargu, yawagakmar-argasii dakargu, eskaryagi-mellebukmalad wakitemarye bialinsoggu, na dukin oburgwegala e-espunyar onos imaksad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablo degi-daksagu, binnasur eskarya-dakedse goted, ega sogded: “¡Mer na be dukin oburgwe, bela amba anmar wegi bukmalad!” ");
INSERT INTO cuk09_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Eskarya-daked gwallu egichisgu, eskarya-yaba dogdegu, ber-dobedba wawanmakded, Pablo-asabin, degi, Silas-asabin, yokorgi sindigar sigdapid. ");
INSERT INTO cuk09_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Eskarya-daked, Pablo, degi, Silas magadba onosgu, egi wilenagusad, ega sogded: “Dummagan, ¿igi an saele, geb an abonolesale?” ");
INSERT INTO cuk09_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pablo, degi, Silas, abin-imakdemar: “Dummad-Jesucristogi mer be bengu, ar degiir, geb be abonolegoed, degi, be-neg-yaurginmalad amba abonolemogoed.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Agi Pablo, Silas-ebo Bab-Jesús-gaya-burba-nuedgi eskarya-dakedga, degi, bela e-neggi-bukmaladga sunmakdemarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Eskarya-daked aka a-mutikidgi Pablo, degi, Silas-naibigusmalad ega nue enuksad. Eskarya-daked, degine, e-neg-yaurginmalad bela Bab-Jesús-digi-ogleged-igar a-mutikidgi imaksamarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A-sorba eskarya-daked, na e-negse, Pablo, degi, Silas-sesa-gusad, geb degi masgi oguchabalid. Eskarya-daked, degi, e-neg-yaurginmalad Bab-Jesús-bengusur-gunonimalad-ular, bela weligwar itosmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Neg-oibosgu, wakudar-yalaba igar-nabiromalad suar-ibmala barmismalad, adi eskarya-dakedga sogegar, we-dulemar be onogoye. ");
INSERT INTO cuk09_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Agi eskarya-daked Pabloga sokar: “Igar-nabiromalad-dummagan anga igar-uksado, be-onomalagar. Degisoggu, akarsundo bemar boni-gwen-niksurmardo, bemar namarsundo.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablo suar-ibmalaga sokar: “Anmar, emide Roma-dulemar-gue-inigwele, igar-nabiromalad dulemar-bukidarad-abargi, yo anmarga igar-itoge, sabsuli anmar-bibyosmalad, degi, eskaryagi anmar-metemarbalid. ¿Emide dukuakwagwa anmar-onoye sogmarde? ¡Adi suli! Igar-nabiromalad-sunnad wese anmar-onodagodo.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Suar-ibmala gannar modapmargu, igar-nabiromaladga bela sogdapmalad, igi Pablo emarga sogsa. Roma-dulemarye wisguarmargu, nue-dobee itoarmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Igar-nabiromalad, Pablo, degi, Silasse nonimarsun, ega sogdemar: “Anmar beedse begi nosmalad, degisoggu, eskaryagi-siid be nomarsun, bemar neggwebur-baidse namarsun.” ");
INSERT INTO cuk09_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pablo, Silas-ebo eskaryagi nosmargu, Lidia-negse nade-gusmalad. Gwenadgan-Bab-Jesúsba-nanaimalad-daksamargu, gwenadgan-gwage nue ogannosmalad. Geb a-sorba, nade-gusmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo, Silas-ebo nadmargu, Anfípolis-neggweburgi, degi, Apolonia-neggweburgi nasmalad. A-sorba Tesalónica-neggweburse modapmalad. A-neggweburgi Judiomar-onmaked-neg siid. ");
INSERT INTO cuk09_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ar gusgu Pablo Judiomar-onmaked-negse naddasoggu, ase nade-gusad. Agi itoged-ilapaa, obunnoged-ibagi dulemar-Judiomar-onmaked-negse-nonidamaladga, Bab-Jesús-igargi sunmakdii-gualid. ");
INSERT INTO cuk09_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Amarga Bab-Jesús-igar nue osanalodii-gusad, igi Cristogi Bab Dummad epenne sogsa-gusa, yoedse dule-wargwen an bega barmidagoye. A-dulegi bato Bab-Dummad-Gardagi sognaid: “We Cristo nue-wileger-gebed, degi, burgwisad-sorba gannar durgubalir-gebed, ar bato deyob ega igar maid.” Degi, Pablo emarga sogdii-guarbalid: “We-Jesúsgi an bega sunmakedi, we Cristo-sunnaddo.” ");
INSERT INTO cuk09_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Agi gwen-gwen Judiomar Bab-Jesúsgi-bengussurmalad. Amar Pabloba, degi, Silasba akadmarsunnad. Deginbali, bukidar Griegomar-Bab-Dummad-dobee-nanadimalad, agi omegan-bukidar-nue-nug-nikamaladi Bab-Jesúsgi-bengussurmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Degine, bukidar Judiomar-Bab-Jesús-bengusmalad, nobedba, dulemar-iskana, galimbaba-arbaed-suli-gudimalad-amisgu, neg-oimakarmalad. Jasón-negse nadmalad, Pablo, degi, Silas sabsuli onomalagar, degi geb dulemarga ukmalagar. ");
INSERT INTO cuk09_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ar Pablo, degi, Silas a-neggi satemarsoggu, Jasón, degi, gwenadgan-baigan-a-neggi-bukwamalad ebipidmarsunnad, neggwebur-dummaganga gudimaladse. Dummaganga binnasur sogdemalad: “Dulemar-bela-neggwebur-irba-neg-oimakdimalad, emide anmarse nonimarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Degine, we-Jasón a-dulemar e-neggi na abingasad. Bela a-dulemar Roma-Dummad-César-e-igargi annadimalad, ar sogdimalad, rey-baid maiye, a-rey Jesúsye-nugye.” ");
INSERT INTO cuk09_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Wegi-dulemar-ega-ibmar-soge itoarmargu, dulemar, degi, dummagan-neg-dakmamaid oimakarmalad, uluarmarsunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasón, degi, baigan nabir noegala, bennuksamalad, geb degi dummagan nabir amar-onossunnad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","A-mutikidba gwenadgan-Bab-Jesúsba-nanaimalad, Pablo, degi, Silas yog neggweburgi onoar imaksamalad, adi Berease namalagar. Pablo, degi, Silas Berease modapmargu, Judiomar-onmaked-negse yog naar imaksamalad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Judiomar-Bereaginmalad Tesalónicaginmaladba, bur dule-nuegan dae daklealid, ar ade bur nue-yeer Bab-Jesús-gaya-burba abingasmalad, degine, bane-bane Bab-Dummad-Gardagi na emar-sunnad amibukwa-guarmalad, dakega, ar bule nabir Pablo emarga ibmar sog-dibeye. ");
INSERT INTO cuk09_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Degisoggu, bukidar Judiomar Bab-Jesúsgi-bengussurmalad, degi, Griego-dulemar, omegan-nue-nug-nikamalad, degi, machergan, amar Bab-Jesúsgi-bengussurmarmogad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ar Judiomar-Tesalónicaginmalad wisguarmargu, Pablo, Bereagi Bab-Dummad-gaya-burbagi sunmakdibarye, amar Berease nade-gusmalad, degi, agi neg-oimakdapmarbalid. ");
INSERT INTO cuk09_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ar gwenadgan-Bab-Jesúsba-nanaimalad gwae-gwae demar-gakase Pablo-barmismarsunnad, Silasdi Timoteo-ebo Bereagi besmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pabloba-nade-gusmalad, Atenas-neggweburse Pablo-berbeapmargu, gannar Berease nonimalad. Amarga soglesad, Silasga, degi, Timoteoga sogoye, gwae-gwae ese dakmaloye Pablo sogye. ");
INSERT INTO cuk09_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo, Atenasgi, Silas, degi, Timoteo-edarbemaigu, e-gwagegi nue sae-itoalid, ar ade bab-dummadga-imakleged e-bab-dummadga neggweburgi na imakbukmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Degisoggu, Judiomar-onmaked-negse Pablo naddasunnad, agi Bab-Jesús-igargi Judiomar, degi, Judiosurmalad-nue-Bab-Dummad-dobee-itodimalad Pablo-ebo abin-abin gaar-daed. Deginbali, bane-bane Pablo dulemar-danar-ambikumalad-neggi, dulemar-bukwamalad Pablo-ebo na abin-abin gaar-dabalid. ");
INSERT INTO cuk09_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Dulemar-binsaed-ibegan Epicúreos-igar-durdaksamalad, degi, Estoicos-igar-nue-wisimalad Pablo-ebo abin-abin imakarmalad. Gwen-gwen sokarmalad: “¿Wede dule sunmakerbad ar ibi obare?” Baigandi sokarmalad: “We-dule bab-dummagan-gwapidmargi sunmaked an itoye.” Ar ade Pablo Bab-Dummad-gaya-burba-nued-Jesúsgi-soglesadgi sunmakdiid, degi, gannar-durguleged-igargi sunmakdibalid. ");
INSERT INTO cuk09_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Dulemar-nue-binsaed-nikamalad-igar-itoged-negse, Aerópago-neg-nugadse Pablo-sesmalad, ega sogdemalad: “Anmar nue wisgubimardo, ¿wede ibu-odurdaked-binidgi be sunmakdii? ");
INSERT INTO cuk09_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ar igar-gwapidsailadgi be anmar-uaya oburnonikid, degisoggu, anmar wisgubisundo, wede ibi be nue obare.” ");
INSERT INTO cuk09_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ar ade Atenasginmalad, degi, baigan-neg-ainesikmalad-Atenasgi-mamaid unnila ibmar-binigan-itogedginbi, degi, ibmar-binigan-sogedginbi binsabuk-damalad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Degisoggu, Pablo, igar-itoged-neggi Areópago-nugadgi emar-abargi gwisgudapgu, sogded: “Girmar-Atenasgi-be-bukmalad, an be-dakmargu, bemar bab-dummadye-sogmaladga-ibmar-imakbukwad nue-dobee nanabukmar an be-dakmardo. ");
INSERT INTO cuk09_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ar bia bemar-babse-gormaladgi, an atakdigu an dakardo, gwensakgi wegi-narmakar babga-ibmar-ukleged-galugi nai: ANMAR-BAB-DUMMAD-WICHULIDGAD. “Nabir, we Bab Dummadse bemar goled, amba bemar wichurmar-inigwele, a-Bab-Dummadgi an bemarga sunmakmalad. ");
INSERT INTO cuk09_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“A-Bab-Dummad we-napneg-naid nasiksad, degi, bela-agi-ibmar-bukwad obinnisad. Ar we-Bab-Dummad we-napneg, degi, we nibneg egadsoggu, dule-ese-goled-neg-sobedgi mego surguoed. ");
INSERT INTO cuk09_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Degi, dulemar geg Bab-Dummad-bendaked, ar Bab Dummad ibmar abe-deeye gwen binsamaisulid, ar na e belagwapa san-burba ukmaid, bunnoged, degi, belagwapa ibmar-ukmaibalid. ");
INSERT INTO cuk09_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Unnila ablis-gwennagi Bab Dummad dulemar-akar-akar urbisad, adi bela yarmar-naid-ugakse dulemar ambikuegar. Agi Bab Dummad sogsabalid, sanase dulemar-akar-akar ambikuoe, degi, biadse ambikubaloe. ");
INSERT INTO cuk09_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Adi a-dulemar Bab-Dummad-amimalagar, bule nabir baramimalo-dibe, ar Bab Dummad anmargi dikasur maisulin-inigwer. ");
INSERT INTO cuk09_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ar Bab Dummadgi anmar gudimalad, agi anmar nabir-nanadibalid, degi, agi anmar dula gudibalid. Ar igi bemar-namaked-onomalad-gwen-gwen bato sogsamarmoga: ‘Anmar Bab-Dummad-mimmigan guye.’ ");
INSERT INTO cuk09_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ar anmar Bab-Dummad-mimmigan gusoggu, anmar binsae-wilubsulid, dule