﻿USE sofia;
DROP TABLE IF EXISTS sofia.cui_vpl;
CREATE TABLE cui_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cui_vpl WRITE;
INSERT INTO cui_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Meje barapo diwese Jesucristo pia pamo susatopiwi tatsi yabara. Jesucristo pon Nacom itoroba itaboco wetsica xua jiwi pecapanenebiyaenexatsi. Bapon Abraham pia pemomoxi susato jiwanapin tatsi. Barapon Abraham pon bayatha caena tʉpa, pon copiya naebopa po cae pin nacuatha xua israelmonae pomonae judiomonaexae beya pinmonae tsoponae. Mataʉtano Jesucristo David pia pemomoxi susato jiwanapin tatsi. Barapon David pon bayatha caena tʉpa, pon caena bayatha Israel nacuapiwi itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaac paxa tatsi. Bapon Isaac Jacob paxa tatsi. Bapon Jacob, Judá paxa tatsi yawa Judá peweicho jiwi, bapontha cae axaba. ");
INSERT INTO cui_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Bapon Judá Fares irʉ Zara paxa tatsi. Tamar Fares pena tatsi irʉ Zara pena tatsi. Bapon Fares Esrom paxa tatsi. Bapon Esrom Aram paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Bapon Aram Aminadab paxa tatsi. Bapon Aminadab Naasón paxa tatsi. Bapon Naasón Salmón paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Bapon Salmón Booz paxa tatsi. Booz pena tatsi pewʉn Rahab. Bapon Booz Obed paxa tatsi. Obed pena tatsi pewʉn Rut. Bapon Obed Isaí paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Bapon Isaí David paxa tatsi, po David caena bayatha Israel nacuamonae itorobiya pia pepa peewatsinchi. Mataʉtano David pexanto tatsi pewʉn Salomón. Bapon Salomón pena tatsi pewʉn Betsabé, powa copiya bayatha Urías xeina. ");
INSERT INTO cui_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Bapon Salomón Roboam paxa tatsi. Bapon Roboam Abías paxa tatsi. Bapon Abías Asa paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Bapon Asa Josafat paxa tatsi. Bapon Josafat Joram paxa tatsi. Bapon Joram Uzías paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Bapon Uzías Jotam paxa tatsi. Bapon Jotam Acaz paxa tatsi. Bapon Acaz Ezequías paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Bapon Ezequías Manasés paxa tatsi. Bapon Manasés Amón paxa tatsi. Bapon Amón Josías paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Bapon Josías Jeconías paxa tatsi, irʉ Jeconías peweicho jiwi bapontha cae axaba. Bapon Jeconías poxonae israelmonae teicaeya capoinchi Babilonia nacua beya, barapo jinaebotha Jeconías naexana epatotha. ");
INSERT INTO cui_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bapoxonae pirapae Jeconías tanaexanatsi pexanto Babilonia nacuatha. Jeconías Salatiel paxa tatsi. Bapon Salatiel Zorobabel paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Bapon Zorobabel Abiud paxa tatsi. Bapon Abiud Eliaquim paxa tatsi. Bapon Eliaquim Azor paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Bapon Azor Sadoc paxa tatsi. Bapon Sadoc Aquim paxa tatsi. Bapon Aquim Eliud paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Bapon Eliud Eleazar paxa tatsi. Bapon Eleazar Matán paxa tatsi. Bapon Matán Jacob paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Bapon Jacob José paxa tatsi. Bapon José piowa tatsi pewʉn María. Barapowa María Jesús pena tatsi. Bapon Jesús icha wʉn wʉn dutatsi, po wʉn “Mesías”, jei, po wʉn xua jei: “Pon Nacom itoroba itaboco wetsica xua jiwi pecapanenebiyaenexa tsainchi”, jei. ");
INSERT INTO cui_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham pia xainya weya tatsi trece poyobe pebiwi naexana xua Abraham muxunano daxota daxita catorce poyobe naexana, beya pu ducua poxonae David naexana. Bapon irʉ Salomón pia xainya weya tatsi trece poyobe pebiwi naexana xua Salomón muxunano daxota daxita catorce poyobe pebiwi naexana beya pu ducua poxonae Israel nacuamonae teicaeya capoinchi Babilonia nacua beya, beya pu ducua poxonae Jeconías naexana. Salatiel pia xainya weya tatsi trece poyobe pebiwi naexanapona xua Jeconías muxunano. Daxota daxita catorce poyobe naexana, beya pu ducua poxonae Mesías naexana. ");
INSERT INTO cui_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Poxonae Jesucristo naexana bara iche: María Jesucristo pena tatsi, poxonae bapowa muxu pepichi pecotsiwa pon pewʉn José, poxonae abʉ cataunxuae jopa perʉ nacoyabiyo, bapoxonae María pexuyo bʉpana taecatsi. Barapo pexuyo Nacom pia Pejumope tʉnaxʉ tatsi María tsiperʉ weeca exanatsi. Barapo pexuyo pewʉn Jesús. ");
INSERT INTO cui_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José, María pia pebin tatsi tsane, poxonae pichina pon pejʉntʉ coyene xanepanaein. Daxota bapon José, María jopa beyabara paebichi xua catsa pexuyo pecapoponaexae xua bʉpana taecatsi xua María aura peexanaenexa tsainchi jiwi peitʉtha tatsi. Bapoxonae José namicha moyiya najʉntʉ cui coyene baraxuba xua jopa pepichiwa tsane, xua jiwi jopa cataunxuae pecui yabara yaputaenexa. ");
INSERT INTO cui_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Poxonae came cataunxuae baxua yabara nanta xeina, José maituncuataba. Bapoxonae José amachinae tsita naitʉtatsi matatsunpin po matatsunpin Nacom itoroba. Matatsunpin namchiya jeye: “José, David pia pemomoxi susato jiwanapin tatsim, jopa junuwinde xua nepichiwa tsane María xua jinseuri neexanaewa tsane. Tsipei barapo pexuyo, po pexuyo naexanaena, apara Nacom pia Pejumope tʉnaxʉ tatsi pia pexuyo tatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bapowa tanaexanaeinchi pexanto. Bapon wʉn dutsiname, po wʉn ‘Jesús’, jei. Barapo wʉn, wʉn dutsiname tsipei bapon pijimonae capanepaena xua abe pia peexanae cuiru coyenein weya tatsi, xua daxota Nacom jopa petsitanexatsi xua barapomonae pexeinaewa penatsicuentsiwa”, jei matatsunpin. ");
INSERT INTO cui_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Daxita baraxua exana penacui yabara jume wetsinexa pocotsiwa bayatha Nacom pia peitorobi jume pepaebin caena bayatha yabara tsiwʉnae muxu duta Nacom nexa, xua jeye: ");
INSERT INTO cui_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Matha taema, yabʉyo pexuyo bʉpana taecatsi powa jopa perʉ nacoyabiyo pebin. Yawa tanaexanatsi pexanto, po pexuyo wʉn dutatsi, po wʉn ‘Emanuel’, jei”, jei Nacom pia peitorobi jume pepaebin. (Barapo wʉn jei: “Nacom naca barʉ popona”, jei.) ");
INSERT INTO cui_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Poxonae José nacosataxuba, bapon exana pocotsiwa matatsunpin itoroba po matatsunpin Nacom itoroba. José María pitatsi. ");
INSERT INTO cui_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bequein cae botha nabarʉ poponabe daichitha jopa came imoxoyo naperʉ cuicuinaeyobe beya poxonae pexanto tanaexanatsi. José pexuyo wʉn duta, po wʉn “Jesús”, jei. ");
INSERT INTO cui_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús naexana Belén tomaratha, Judea nacuatha. Barapoxonaerʉ Herodes pon Judea nacuapiwi pia peyanacua ewatsinchi popona barapo Judea nacuatha. Poxonae Jesús naexana pebiwi pata Jerusalén tomaratha. Barapomonae opitei pecayabara wʉnae yaputaewi. Barapomonae pia tomara tajʉ taenatsi ichaxota pocotsiwa xometo weecoina. ");
INSERT INTO cui_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Barapomonae ichawa beya yayainyaba tsiniya, jeye: —¿Exota naexana pexuyo, po pexuyo judiomonae itorobiya pia pepa peewatsinchi exanaeinchi poxonae pinyo tsane? Paxan payaputan xua bapon naexana xote tsipei bapon pia opiteito tatsi panaitomatsiya punaenaponan pata nacua werena, po nacuatha ichaxota pocotsiwa xometo weecoina. Papatan xua pata wʉnae jainchiwa tsane barapo pexuyo, jei. ");
INSERT INTO cui_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes, pon Judea nacuapiwi pia peyanacua ewatsinchi poxonae bapon yabara jume tane xua ichʉn naexana pon jiwi itorobiya pia pepa peewatsinchi, bapoxonae bapon bichocono ʉnthʉthʉ deideijei Irʉrʉ Jerusalén tomarapiwino daxita bichocono ʉnthʉthʉ deideijei pejume taexae baxua. ");
INSERT INTO cui_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nexata Herodes waba sacerdotemonae pia pentacaponaewi tatsi xua pia petanacaetutsinexa tsainchi pia botha. Mataʉtano wabano pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi. Daxita barapomonaetha Herodes yainyaba, jeye: —¿Exota naexanaena Mesías, pon bepa pinae Nacom itorobei? jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Barapomonae jume nota, jeye: —Bapon naexanaena Belén tomaratha, po tomara Judea nacuatha eca. Bapon naexanaena barapo tomaratha, tsipei Nacom pia peitorobi jume pepaebin caena bayatha tsiwʉnaeya yabara muxu dutsiya tina xua Mesías yabara, Nacom nexa. Nacom jeye: ");
INSERT INTO cui_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Belén tomara bequein po tomariyo tsiqui tomariyo jiwana tomara xua Judea nacuatha, daichitha Judea nacua pentacaponaewi yabara nanta xeinaena xua Belén tomara peainya cui tomariyo tsane. Baxua nanta xeinaena tsipei barapo tomariyotha naexanaena, pon jiwi pia Pecanamataxeinaeinchi tatsi. Xan Nacom bapon itorobin tamonaetha, pomonae Israel nacuapiwixae, xua bapon barapo israelmonae itorobiya pia pepa Peewatsinchi tsainchi’, jei Nacom, xua Nacom tatinatsi pon Nacom peitorobi jume pepaebin, jei sacerdotemonae irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nexata Herodes namicha moyiya waba pomonae opitei pecayabara wʉnae yaputaewi. Herodes yainyaba barapomonaetha: “¿Eta poxonae yatsicaewa barapo opiteito paca tsita naitʉta?” jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Poxonae barapomonae jume nota bapontha bapoxonae Herodes itoroba barapo pebiwi Belén tomara beya. Herodes jeye barapomonaetha: —Paponare Belén tomara beya. Beta xanepanaya pajeire barapo pexuyo. Poxonae pataebiname barapo pexuyo, nexata pana netsipaebare, tsipei xan irʉ ponaein wʉnae tajainchinexa tsanerʉ barapo pexuyo, jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Poxonae Herodes najume weta, barapo pebiwi bara ponarʉcʉpa, pomonae opitei pecayabara wʉnae yaputaewi. Bapoxonae po opiteito bayatha tane pia nacuatha, barapo opiteito jemeicha caewa naitʉtaba. Yawa barapomonae matacapoinchi. Barapo opiteito ducuapona beya matapainya matatsun ducuatabica ichaxota barapo pexuyo boca. ");
INSERT INTO cui_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Poxonae barapo pebiwi tane barapo opiteito, barapo pebiwi bichocono jʉntʉ coyene weiweina. ");
INSERT INTO cui_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Barapomonae bo jojoniya ichaxota tane barapo pexuyo xua pena barʉ ecatsi, barapowa María. Bapoxonae barapo pebiwi pentabocotontha ena xua barapo pexuyo wʉnae pejainchinexa tsainchi, tsipei barapoyo pon Pecanamataxeinaein peexanaexae tsainchi poxonae pinyo tsane. Bapoxonae barapomonae piawan coibo isacapenta xua cajijinca. Barapo pexuyo catsibatsi xuan pocotsiwa pewʉn oro nain. Catsibatsino xua pocotsiwa pewʉn incienso xua pocotsiwa tuxusi tuxuei benata poxonae tauta exana. Mataʉtano muxuna catsibatsi icha petuxueiwa pocotsiwa pewʉn mirra xua pocotsiwa anaincuito. ");
INSERT INTO cui_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bapoxonae pirapae barapo pebiwi maitumenaeya amachinae xua jopa bewa equeicha patsi tsane ichaxota Herodes eca. Daxota barapomonae pia nacua be-iyiya, icha namto iyiya. ");
INSERT INTO cui_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Poxonae barapo pebiwi ponarʉcʉpa bapoxonae Nacom itoroba matatsunpin Josetha. Matatsunpin tsita naitʉta poxonae José amachinae. Matatsunpin José baraichi, jeye: “Asiya uncuare. Pexuyo pire yawa coxiwano. Egipto nacua bebarʉ naetsiriwiyama. Ecare barapo nacuatha, beya abʉ poxonae equeicha catsipaebinchi baxota. Tsipei Herodes pexuyo jeitsina pebexubinexa tsainchi pexuyo”, jeichichi José matatsunpin. ");
INSERT INTO cui_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Poxonae cataunxuae merawi, José nacosataxuba. José pexuyo pita, yawano José pita yabʉyo María xua pexuyo pena tatsi. Daxita barapoyobe warapa Egipto nacua beya poxonae cataunxuae quirei tsuncuae. ");
INSERT INTO cui_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Barapo nacuatha, Egipto nacuatha, barapoyobe ecabe beya poxonae juinya Herodes tʉpa. Baxua José cana exanatsi xua bayatha Nacom pia peitorobi jume pepaebin petsiwʉnae yabara paebixae Nacom nexa xua jeye: “Waban Taxanto Egipto nacua weya”, jei Nacom pon pia peitorobi jume pepaebin Nacom nexa pon jiwi Pecanamataxeinaeinchi. ");
INSERT INTO cui_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Poxonae Herodes yaputane xua pomonae opitei pecayabara wʉnae yaputaewi muxujainyabiya tsipaeba bapontha xua itara patapaeba, bapoxonae Herodes anaya bichocono anaepana. Nexata bapon itoroba, ichamonae itorobatsi xua pejutebinexatsi daxita pexui pebiwi wʉtixi, po pexui cataunxuae pencuetixi, po pencuetixi cataunxuae jopa yapu othopaeyo dos po weibe, irʉ po pexui xua bayatha yapu othopa dos po weibe. Barapon Herodes itoroba xua pejutebinexatsi barapo pexui pebiwi wʉtixi daxita poxi Belén tomara cuariya beya. Herodes baxua exana yaitama bayatha pomonae opitei pecayabara wʉnae yaputaewi yopita xua pinae tane pexuyo pia opiteito tatsi barapo dos po weibetha poxonae peputha tapona, opiteito peputha tatsi xua jinaebotha, poxonae Judea nacua beya pona. ");
INSERT INTO cui_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Baxua Herodes cana cui wetsiya exanatsi, xua bayatha Jeremías pon Nacom pia peitorobi jume pepaebin petsiwʉnae yabara paebixae, xua jeye: ");
INSERT INTO cui_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Jume tan xua wecoyei Ramá tomaratha, po tomara eca imoxoyo Belén tomaratha. Powa xua wecoyei, bapowa Raquel, powa bayatha tʉpa. Bapowa Raquel pia pemomoxi susatopiwi siwa wecoyei, tsipei daxita tajutebatsi. Barapowa jopa naitawanae copatsiyo tsipei pexui bayatha werapa bequein ichamonae jume matawenta”, jei Jeremías. ");
INSERT INTO cui_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes bapoxonae pirapae tʉpa. Bapoxonae matatsunpin pon Nacom itoroba, José tsita naitʉtatsi poxonae José amachinae Egipto nacuatha. Matatsunpin jeye Josetha: ");
INSERT INTO cui_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Natsixitabare. Pire barapo pexuyo yawa coxiwa María, pexuyo pena tatsi. Israel nacua beya caibe nawiyama. Tsipei bayatha werapa pomonae ichichipa xua barapo pexuyo pebexubiwatsi”, jei matatsunpin. ");
INSERT INTO cui_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bapoxonae José natsixitaba. José pita pexuyo yawa coxiwa. Israel nacua beya caibe nawiya. ");
INSERT INTO cui_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","José jume tane xua juinya pinae Arquelao naexana Judea nacuapiwi pia peyanacua ewatsin tatsi. Arquelao Herodes pexanto tatsi. Arquelao xuya peyanacua ewatsin naexana ichaxota bayatha coxiyan peyanacua ewatsin naexana bapon Herodes. Tsipei Arquelao eca Judea nacuatha daxota José junuwa xua peponaewa barapo nacuatha. Daxota José pona Galilea nacua beya, tsipei poxonae amachinae matatsunpin itoroba xua bewa pinae ponaena barapo nacuatha. ");
INSERT INTO cui_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Poxonae José patopa barapo nacuatha, bapoxonae popona po tomaratha, po tomara pewʉn Nazaret tomara. Baxua José cana cui wetsiya exanatsi, xua bayatha Nacom pia peitorobi jume pepaebiwi Jesús cayabara tsiwʉnae muxu dutsiya jeye: “Bapon wʉn dutinchi po wʉn jei: ‘Nazaret tomarapin’, jei”, jei barapo Nacom pia peitorobi jume pepaebiwi. ");
INSERT INTO cui_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pirapae poxonae ainya wei yapucaewa, poxonae abʉ cataunxuae Jesús eca Nazaret tomaratha, bapoxonae Juan pon jiwi Pebautisabin patopa ira xuepana susato tsurucuae nacua beya xua Judea nacuatha. Bapon Juan Nacom Pejume Diwesi paeba ducuanaebiya. ");
INSERT INTO cui_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan namchi: “¡Icha jʉntʉ coyene paxeinare Nacomtha painya neauraxae xua abe paexaname! Tsipei Nacom paca waba painya nenaexanaenexa piamonae tatsi jiwana pomonae Nacom itorobiya peewatsixae”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Barapo Juan apara bapon pon caena bayatha peyabara tinaexaetsi. Isaías pon Nacom pia peitorobi jume pepaebin, bapon caena bayatha yabara jume wʉnaeya tina, xua caena bayatha Juan yabara jume wʉnaeya tinatsi. Isaías jeye: “Jume tan pon wawai ira xuepana susato tsurucuae nacuatha. Bapon wawaya jeye: ‘Patsi najʉntʉ cui coyene wʉnaere pon jiwi pia pepa Pecanamataxeinaeinchi pia pepatopae wʉnaeya tsane’, jei pon wawai”, jei Isaías petinae diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan jumaina duwein nabocoto, po duwein pewʉn camello. Coreinya bocoto maraina. Juan xane pocotsiwan yapupuna, pocotsiwan be sure, mataʉtano bana daebano. ");
INSERT INTO cui_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jiwi pata Jerusalén tomara weya, irʉrʉ pata xua daxita tomaranpiwi xua Judea nacua weya, irʉrʉ pata po tomaranpiwi xua imoxoyo Jordán mene weya. Barapomonae pata Juan pejume taenexatsi. ");
INSERT INTO cui_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Poxonae barapomonae nayopita Nacomtha xua bepa pinae Nacom tsita auratsi, xua abe peexanaexae, barapoxonae Juan bautisaba barapomonae Jordán mentha. ");
INSERT INTO cui_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ichitha poxonae Juan tane xua nawita pata fariseomonae jiwana irʉrʉ xua saduceomonae jiwana pata ichaxota Juan bautisaba, Juan jeye barapomonaetha: “¡Paxam pomonae pemuxuitorobi jiwi pam! ¡Paxam be bara jomomonae pam, tsipei jomo ba cuitaya dʉcʉpa nawa! Bara paichim anoxuae, paichichipame Nacom pacuitaya dʉcʉpame xua abe paca exanaeyainwa. Jopa papanenebiyaem tsane bequein bara paca bautisabinchi tsipei jopa pajʉntʉ coyene xanepanaem Nacomtha. ");
INSERT INTO cui_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","9","Xaniwaicha pajinompare xain ichamonae paca cui tane, xua icha jʉntʉ coyene painya nexeinaewa Nacomtha xua painya neauraxae xua abe paexaname. Tsipei bequein paxam pajam: ‘Waxainchi Abraham pia pemomoxi susato jiwichixaetsi Nacom naca capanenebiya exanaena’, pajam, daichitha paxam jopa xaniwaicha pajume cowʉntsim Nacom. Daxota Nacom itacʉpatsi xua paca cui matawenta pia jopa paca nepaca capanenebiyaenexa tsane. Mataʉtano barichino Nacom itacʉpatsi xua jiwi forotsinchi barapo ibotixi weya, po ibotixi xote Jordán mene itapatha bobena. Barapo jiwi naexanaena, po jiwi yatsicaewa Abraham pia pemomoxi susato jiwi tatsi, pomonae pejume cowʉntsiwixaetsi Nacom. ");
INSERT INTO cui_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Poxonae pebin naein ʉba sipari ba canacui wʉnaeta xua pecaucubobinexa po naein jopa nacoichiyo. Poxonae barapo naein ucuboba nantatsun eta xua petautsinexa isototha. Paxam bara paca jʉta ichiya paca cana exanaena. Nacom paca yabara nacui wʉnaeta xua paca bebai tsane isototha, ichaxota po isototha jopa cuinaya itacounayiyo tsipei Nacom jopa xanepanaya pata exanaem. ");
INSERT INTO cui_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xan xaniwaicha paca bautisabatsi meratha painya neauraxae xua abe paexaname xua daxota icha jʉntʉ coyene painya nexeinaewa tsane Nacomtha. Paca bautisabatsi meratha, ichitha nama pon tsiwanaya patopan, apara bapon Mesías. Bapon paca bautisabina Nacom pia Pejumope tʉnaxʉtha tatsi poxonae Nacom paca najumope catsibina. Bapon paca jiwana cui copatsinchi xua atene tsane Cristo pejume cowʉntsixaetsi xua ichamonae atene exanaena. Bapon bichocono peayapusʉ itorobi coyenewa xeina beyacaincha xan. Bapon pon jiwi pia Pecanamataxeinaeinchi. Daxota bapon bichocono tsita pin ura xeinan xua tataxu mʉ isanaxubiwa tsane pia penataxu xatatsiwa tatsi. Tsipei xan bichocono tapawin, beyacaincha pomonae amanaya petanacuichiwi pia pentacaponaewi poxonae barʉ cui itura jina pia pentacaponaewichi. ");
INSERT INTO cui_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Bapon pon patopaena bapon bayatha tsinacobenata po paparato xua trigo xu nexa. Bapon trigo xu tsanaya seicaya matapepe jejebapona. Trigo xu jejebapona trigo xu matabotha. Matapepe jejebapona petautsinexa isototha, ichaxota po isoto jopa cuinaya itacounayiyo. Bapon bara jʉta cana ichi tsane jiwitha icha trigo xu cana ichiya ichi. Jiwi Nacom tsana nobina pomonae pejume cowʉntsixaetsi pia nacuatha nexa. Ichamonae tsana nobinchi pomonae jopa pejume cowʉntsiwichi, petautsinexa isototha ichaxota xua jopa itacounayiyo”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nexata Jesús patopa ichaxota Juan uncua Jordán mentha xua Galilea nacuatha. Jesús patopa xua Juan pebautisabinexa tsane. ");
INSERT INTO cui_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Copiya Juan juntucuru jume matawenta xua Jesús pebautisabiwatsi tsainchi tsipei anacuicaura. Juan jeye Jesustha: —Xan apara pon xua tanantawenonaewa xua xam bewa jame tana nebautisabiwam tsane. Nama xan jopa bewa cabautisabi tsainchi, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ichitha Jesús jume nota: —Anoxuae bara ‘je’ jande pocotsiwa xua xanepana, pocotsiwa ichichipan pocotsiwa xua xanepanaya exanatsi pocotsiwa xua Nacom naca itoroba, jei Jesús. Bapoxonae Juan jume jejei xua Jesús bautisabatsi. ");
INSERT INTO cui_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nexata poxonae Jesús bautisabatsi, Jesús nainya mene wejuina. Bapoxonae nainya peitaboco nayausaranaxuba. Jesús tane xua Nacom pia Pejumope tʉnaxʉ tatsi Jesús tapatopeicatsi, be topiboto yaruneica. ");
INSERT INTO cui_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Bapoxonae Jesús jume tane pocotsiwa peitaboco wetsipaebicatsi, jechichi: “Bapon apara Taxanto, pon bichocono antobein pon itapetan. Bapon nejʉntʉ coyene weiweina exana”, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nexata Nacom pia Pejumope tʉnaxʉ tatsi Jesús matacayatsi ira xuepana susato tsurucuae nacua beya. Baxotiya caurimonae pia pentacaponaein tatsi Jesús piraichi jʉntʉ coyene jʉjʉtatsi xua Jesús abe coyeneya petaexanaenexa tsane. ");
INSERT INTO cui_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús jopa nabanaeyo baraxotiya cuarenta po matacabibetha mataʉtano cuarenta po merawibetha. Poxonae barapo matacabin yapucaewaba bapoxonae Jesús bichocono jainpa. ");
INSERT INTO cui_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Caurimonae pia pentacaponaein tatsi imoxoyo patopa Jesustha. Bapon Jesús piraichi jʉntʉ coyene jʉjʉtatsi xua Jesús abe coyeneya petaexanaenexa tsane. Bapon Jesús baraichi: —Icha xam yatsicaya Nacom Pexantom, netsita itʉre. Barapo iboton itorobare xain pan naexanapenta, jei caurimonae pia pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ichitha Jesús jume nota: —Nacom Pejume Diwesitha namchi: ‘Jopa metha bepa meisa jiwi betiya una jinompaetsipae pan. Bara irʉ yawano Nacom Pejume Diwesi jiwi betiya yajʉntʉ cui coyeneya jʉntemiya jinompa’, jei Nacom Pejume Diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nexata caurimonae pia pentacaponaein tatsi Jesús matacapoinchi Jerusalén tomara beya. Baxotiya Jesús Nacom pin pia botha pentatupa beicha capoinchi. ");
INSERT INTO cui_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Caurimonae pia pentacaponaein tatsi Jesús baraichi, jeye: —Icha bara xaniwaicha Nacom Pexanto tatsim, wenaxoreinque. Yaitama tsipei Nacom Pejume Diwesitha namchi, jeye: ‘Nacom itorobina pia matatsunpiwi necayanabinexa. Barapo matatsunpiwi asiya cawaetaboutsina pecobetha, xua jopa necataxu tsaquituncuaenexa tsane ibototha, poxonae wenaxorecame’, jei Nacom Pejume Diwesitha, jei caurimonae pia pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús jume nota, jeye: —Barichi Nacom Pejume Diwesitha namchi, jeye: ‘Jopa jʉntʉ coyene jʉjʉtsiya wʉcaeinde Nacom pon jinya Necanamataxeinaein, xua necajume jejeiwa tsane xua necayawenaewa tsane poxonae jopa xapain exanaem’, jei Nacom Pejume Diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Equeicha caurimonae pia pentacaponaein tatsi Jesús matacapoinchi ichaxota po demxuwa bichocono atororo. Baraxotiya Jesús tsita itʉtatsi daxita nacuan xua barapo cae pin nacuathe. Mataʉtano Jesús tsita itʉtatsi daxita nacuan pia peitʉpanae coyenewan. ");
INSERT INTO cui_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Caurimonae pia pentacaponaein tatsi Jesús baraichi, jeye: —Ichaunxuae nentabocototha uncuaename taitabaratha, xua mataʉtano ichaunxuae newʉnae jaintsiname xua nenanta xeinaewaxae xua xan jinya tacacanamataxeinaeinchi. Bapoxonae barapo nacuan yawa muxuna nacuan pia peitʉpanae coyenewan, baxuan cacatsinchi xua jinya necanamataxeinaenexa barapo nacuan, jei caurimonae pia pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nexata Jesús jume nota: —Xam pon caurimonae pia pentacaponaem, bara nexubiriware. Yaitama Nacom Pejume Diwesitha namchi, jeye: ‘Meisa wʉnae jainde jinya Necanamataxeinaein Nacom. Meisa bapon yatsicaewa taexande pocotsiwa caitoroba’, jei Nacom Pejume Diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Bapoxonae caurimonae pia pentacaponaein tatsi Jesús pia xainya weya tatsi napitaba. Matatsunpiwi pata Jesustha xua Jesús pecui matateicaenexa tsainchi, mataʉtano xua peapatsinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Poxonae Jesús jume tane xua Juan jiwi pecʉbi botha eca, bapoxonae Jesús pona Galilea nacua beya. ");
INSERT INTO cui_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ichitha Jesús jopa ecaeyo Nazaret tomaratha, jame saya pona Capernaum tomara beya xua baxotiya pepoponaenexa. Barapo tomara eca, Galilea pucua itapatha ichaxota ainya nacuabe nacaquita ecabe po nacuiyo pewʉn Zabulón nacuiyo, yawa po nacuiyo irʉ pewʉn Neftalí nacuiyo. ");
INSERT INTO cui_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pocotsiwa Jesús exana poxonae Capernaum tomaratha popona, baxua Jesús yabara nacui wetatsi xua caena bayatha Nacom pia peitorobi jume pepaebin, pon Isaías, pecayabara cui wʉnae tsiwʉnaeya tinaexae poxonae jeye: ");
INSERT INTO cui_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Po ainya nacuabe pewʉn Zabulón nacuiyo mataʉtano Neftalí nacuiyo, barapo nacuabe ecabe ichaxota po namtotha pucua imoxoyo caquita ducuiya. Barapo nacuabe ecabe ichaxota po pin nacua, pewʉn Galilea nacua. Barapo Galilea nacua icha muxunenetha eca xua Jordán mentha. Barapo Galilea nacua weya jinompa pomonae jopa judiomonae naexanaeyo. ");
INSERT INTO cui_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Barapomonae caena bayatha jopa yaputaeyo Nacom, mataʉtano caena bayatha jopa nayabara yaputaeyo xua muxu bara nama pewerapaeba abe peexanaexae. Daxita barapomonae be pocotsi jiwimonae poxonae pona pequireiwatha xua poxonae mataʉtano jopa xeinaeyo xua penatsiwana itiyobiwa. Daichitha daxita barapomonae nama jume cowʉntsina, xua jume cowʉntsinchi pon Nacom itoroba. Bapon barapomonae jʉntʉ cui coyene babatsiya xanepanaya jinompaeya exanaeinchi ichi be jiwi ichi xua poxonae pin pecoichatha jinompa”, jei Isaías, pon Nacom pia peitorobi jume pepaebin. ");
INSERT INTO cui_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Bapoxonae Capernaum tomaratha Jesús tamropata pitaba xua jiwi cuidubatsi. Jesús namchi, jeye: “Icha jʉntʉ coyene paxeinare Nacomtha, painya neauraxae xua abe paexaname. Tsipei Nacom paca waba painya nenaexanaenexa piamonae tatsi pomonae Nacom itorobiya peewatsixae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús pona Galilea pucua itapatha. Jesús tane ponbe ainya caepipeweichobe. Ichʉn pewʉn Simón pon icha wʉnno Pedro. Ichʉn pewʉn Andrés. Baponbe duwei peyamonaeinbe. Baponbe mentha yamonauyabe duwei pocotsiwatha xua peyamonaewa. ");
INSERT INTO cui_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Nexata Jesús baraibe baponbe, jeye: —Anetha, pana nepuna pondebe. Paca cuidubinchibe. Anoxuae nama xan paca exanaeinchibe xua pinmonae payawenaenamebe xua barapomonae pejume cowʉntsiwa tsane Nacom icha bayatha paichimbe poxonae payamonamebe duwei nawita, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nainya caena baraponbe peyamonaewan xubotabe. Napuna ponabe Jesustha. ");
INSERT INTO cui_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bapoxonae pirapae Jesús tane ichʉnbe, ponbe ainya caepipeweichobe. Ichʉn pewʉn Santiago. Ichʉn pewʉn Juan. Baponbe Zebedeo pexantobe tatsi. Baponbe jeratha paxa barʉ ecabe. Baponbe peyamonaewan wʉnaetauyabe. Jesús waba, baponbe wabatsibe. ");
INSERT INTO cui_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Caena nainya jera xubotabe mataʉtano paxa cuenta ponabe. Baponbe Jesús puna poinchibe. ");
INSERT INTO cui_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús popona ducuanaeta daxita Galilea nacua beya. Bapon cuiduba ducuanaeta daxita judiomonae pia penacaetutsi bontha tatsi. Jesús paeba ducuanaeta Nacom pia pexeinya jume diwesi tatsi, po diwesi yabara xua Nacom waba jiwi, petanaexanaenexatsi piamonae pomonae Nacom jʉntʉ coyene itorobiya ewata. Mataʉtano Jesús axaibi exana jiwi xua daxita carepaya xoxi atene barapomonae yawa xua faefaena peatenexae. ");
INSERT INTO cui_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pin bicheitomonae jiwi jume tane xua juinya Jesús exana daxita carepaya Siria nacuatha. Barapomonae pomonae pejume taexae xua Jesús exana, barapomonae capona daxita pomonae domaebatsi, yawa pomonae peatenexae, mataʉtano pomonae caurimonae xeina, mataʉtano pomonae amameibatsi, mataʉtano pomonae mʉbatsi. Jesús axaibi exana daxita barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pin bicheitomonae jiwi Jesús puna poinchi pomonae Galilea nacua weya pona. Irʉrʉ Jesús puna poinchi pomonae Decápolis nacua tomaran weya pona, irʉrʉ pomonae Jerusalén tomara weya pona, irʉrʉ pomonae Judea nacua weya pona. Irʉrʉ Jesús puna poinchi pomonae jinompa ichaxota po nacua eca imoxoyo Jordán mentha xua icha muxunenetha xua tajʉthiya. ");
INSERT INTO cui_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Poxonae Jesús tane barapo pin bicheitomonae, bapoxonae Jesús pona demxuwatheicha. Mataʉtano Jesús baxoteicha eca. Bapoxonae Jesús pijimonae matawacaicha nacaetutarʉcʉpatsi pomonae pia pepuna ponaewichi. ");
INSERT INTO cui_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jesús tamropata pitaba xua diwesi cuiduba barapo pin bicheitomonae. ");
INSERT INTO cui_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jesús barai barapo pin bicheitomonae pomonae pijimonaexae tatsi, jeye: “Maisa bichocono jʉntʉ coyene weiweina pomonae yaputane xua Nacom pecanantawenonaewatsi xua xanepanaya pejinompaewa tsane. Tsipei barapomonae naexanaena Nacom piamonae pomonae Nacom jʉntʉ coyene itorobiya ewata. ");
INSERT INTO cui_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Maisa bichocono jʉntʉ coyene weiweina pomonae bequein anthʉthʉrewe xua siwa wecoyei petaexae xua ichamonae abe cana exana jiwitha. Daichitha barapomonae Nacom cui matateicaena, barapomonae cui matateicaeinchi xua anthʉthʉrewe, xua ichamonae siwa wecoyeichi. ");
INSERT INTO cui_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Maisa bichocono jʉntʉ coyene weiweina pomonae Nacom bichocono pebarʉ cui itura jinaewatsi xua jopa Nacom yabara ajʉntʉcoyenetsacatsi. Barapomonae nama patsina pena iratha po ira Nacom bayatha yabara paeba. ");
INSERT INTO cui_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Maisa bichocono jʉntʉ coyene weiweina pomonae ichichipa nawita xua exaneiba xua Nacom ichichipa, pexeinaenexa tsane pejʉntʉ coyene xanepanaewa Nacomtha xua Nacom jopa petsitanexatsi xua barapomonae pexeinaewa penatsicuentsiwa xua abe peexanaexae bapontha. Barapomonae yawenatsi, Nacom yawena xua barapomonae pexeinaenexa tsane barapo coyene. ");
INSERT INTO cui_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Maisa bichocono jʉntʉ coyene weiweina pomonae nantanuweya pecayabara cui cananta xeinaewi xua ichamonae peyawenaenexatsi. Barapomonae xuya Nacom nantanuweya cayabara cui nanta xeinaena xua peyawenaenexa tsane. ");
INSERT INTO cui_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Maisa bichocono jʉntʉ coyene weiweina pomonae pejʉntʉ xeicae jiwi xua pomonae jopa pecayabara nanta xeinaexae abe peexanae cuiru coyene. Barapomonae Nacom necotsinchi. ");
INSERT INTO cui_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Maisa bichocono jʉntʉ coyene weiweina pomonae jʉntema pejinompaexae xua peyawenaexae xua irʉ ichamonae jʉntema jinompa peexanaexaetsi pomonae copiya abe nata exaneiba. Barapomonae pomonae jʉntema pejinompaexae Nacom unuta ‘Tapexui’, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Maisa bichocono jʉntʉ coyene weiweina pomonae bequein bara aperʉtane exainchi mataʉtano bequein bara anthʉthʉtane exainchi, xua amsiya xaniwaicha peexanaexae pocotsiwa Nacom itoroba. Barapomonae nama Nacom pijimonae tatsi naexanaena pomonae Nacom jʉntʉ coyene itorobiya ewata. ");
INSERT INTO cui_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Maisa bichocono pajʉntʉ coyene weiweiname poxonae bequein bara ichamonae abeya paca yabara paeba, poxonae bequeinno abe pacata exana, mataʉtano poxonae bequeinno canaerabiya paca yabara paeba tapaneantobemxaem. ");
INSERT INTO cui_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pajʉntʉ coyene weiweinare. Mataʉtano jʉntema painompare tsipei Nacom paca catsina pia pexeinya peitʉpanaewan pocotsiwan Nacom paca jʉntana jeba pia nacuatheicha. Icha ichamonae abe pacata exana payabara nanta xeinare, matha caena barichi poxonae ichamonae abe exana pomonaetha pomonae Nacom pia peitorobi jume pepaebiwi. Barapomonae caena bayatha jinompa poxonae paxam cataunxuae jopa pajinompaem”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi jeye: “Sare beno bara beno wʉnae. Ichitha icha barapo sare beno jopa abenataeyo bapoxonae jopa peitacʉpaewatsi xua equeicha peabenataewa. Bapoxonae jiwi barapo sare beno xuba iratha. Mataʉta beno taxunaunaba iratha. Paxam pomonae tamonae pam be bara jʉtiya ichiya pam, icha sare beno cana ichichi. Paxam payawende jiwi pomonae jinompa barapo cae pin nacuathe xua daxita jiwi jopa abe peexanaewa tsane. Ichitha icha barapomonae jopa xapain payawenaem tsane, Nacom bara paca bebai tsane. Tsipei jopa wʉnae pam, Nacom bara paca bebai tsane icha jiwi ichi poxonae bebai sare beno mataʉta xua beno taxunaunaba, tsipei jopa abenataeyo. ");
INSERT INTO cui_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Icha pecoicha ichi poxonae pentha xua poxonae baxota jiwi yawenatsi, paxam bara jʉta ichiya paichim poxonae beta painompame. Barapocotsi coyenewatha jiwi payawename xua beta jinompa. Po tomara ba demxuwatha eca, barapo tomara ba jiwi tajʉ tane. Bara paca yabara jʉta coyene ichi, jiwi paca tane xua poxonae beta painya nejinompaewa. ");
INSERT INTO cui_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jiton dapon ba aibi xua pon pecoicha coicha exana xua pecoicha matacatetsinexa corototha. Jame, asiya coicha exanatsi xua pecoicha taenexa pomonae bomʉxʉtha ena. ");
INSERT INTO cui_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Bara paca yabara jʉta coyene ichi xua jiwi peitabaratha tatsi. Beta painompare xua jiwi painya nepaca cataenexa xua xanepanaya paexaname painya neantobemxae Nacom. Bapoxonae barapo jiwi Nacom wʉnae jainchinchi, pon painya Axa, pon itabocotha eca”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Jopa pananta xeinaeinde xua xan patopeican xua apara Moisés pia peitorobi diwesi jume tacana exanaewa tsane xua jiwi jopa equeicha pecanantawenonaewa tsane barapo Moisés pia peitorobi diwesi jume xuano irʉ bara cana ichin tsane pomonae Nacom pia peitorobi jume pepaebiwi pia pecuidubiwan tatsi. Jame apara patopeican tanayabara jume cui yabara wetsinexan tsane pocotsiwa caena bayatha neyabara tsiwʉnae paeba po diwesintha Moisés pia peitorobi coyenewa tatsi, irʉno Nacom pia peitorobi jume pepaebiwi pia penacuidubiwan jumeintha. ");
INSERT INTO cui_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Bara xaniyeya paca tsipaebatsi poxonae cataunxuae barapo itaboco ducue, mataʉtano poxonae cataunxuae barapo ira ducue, Moisés pia peitorobi diwesi jopa weraweracae tsane. Mataʉtano jopa cae itanetiyo aichurucuae tsane beya poxonae wetsina pocotsiwa bayatha Nacom tsiwʉnae yabara paeba xua wetapaeba. ");
INSERT INTO cui_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pon yabara nanta xeina pecuidubinexa ichamonaetha xua tsita jume ita xexenatsi Nacom pia peitorobi coyenewa bequein saya po peitorobi coyenewiyo peya itorobi coyenewiyo, bapon xuya, Nacom pia nacuatheicha cana jʉntʉ cui ita xexenecaeinchi. Ichitha nama pomonae cuiduba ichamonaetha Nacom pia peitorobi coyenewan, mataʉtano xua exana pocotsiwa Nacom itoroba, barapomonae peainya cui jiwi tsane Nacom pia peitorobi nacuatheicha tatsi. ");
INSERT INTO cui_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Paca tsipaebatsi jame bewa jʉntʉ coyene xanepanaya paexaneibiname ichamonaetha be pocotsi coyeneya xua Nacom paca itoroba, beyacaincha poxonae exana pomonae pecuidubiwi Moisés pia peitorobi coyenewa tatsi, mataʉtano xua poxonae beyacaincha jinompa fariseomonae. Icha jopa yatsicaewa beta jʉntʉ coyene xanepanaya paexanaem tsane beyacaincha xua poxonae barapomonae itara mexeya wʉnaeya exana, jopa papatsim tsane Nacom pia peitorobi nacua beicha tatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Paxam pajume taneme pocotsiwa Moisés namchi painya amo susato jiwitha, jeye: ‘Jopa ichʉn anaya bexubinde. Tsipei pon xua ichʉn bexotsi, ichamonae yabara paebina xua bapon natsicuenta xua abe peexanaexae’, jei. ");
INSERT INTO cui_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ichitha nama seicaya paca tsipaebatsi xua pon caseba ichʉntha ichamonae yabara paebina xua bapon natsicuenta xua abe peexanaexae. Irʉrʉ pon biatane ichʉntha ichamonae yabara paebina xua bapon natsicuenta xua abe peexanaexae. Pomonae pecanamata caitorobi bicheito bapon yabara paebinchi xua bapon natsicuenta tsipei bapon bichocono ʉnthʉthʉ anaepana. Mataʉtano irʉrʉ pon namchi xua ichʉn jeichichi: ‘Xam nabenecame’, jei pon, bapon xubinchi po nacua beya ichaxota isoto bapana jopa itacounayiyo. ");
INSERT INTO cui_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Equeicha paca tsipaebatsi. Ichacuitha ichʉn duwein becapona ichaxota xua be pexaethopaewa xua tuxusi exana Nacom nexa poxonae tauta. Poxonae cataunxuae jopa exanaeyo baxua, matha copiya tsiwanaya yabara nanta xeinaena pocotsiwa icha metha bayatha abe exana ichʉntha. Matha be ichi tsane meje xuaje: Bʉ abʉ cataunxuae bota pocotsiwa pia pecatuxusi exanaewanexa xua Nacom nexa. Matha copiya bewa ponaena ichʉn beya xua pia penaita coxone exanaewa tsanebe. Bapoxonae bapon caibeya bewa ponaena xua duwein petuxusi exanaewa tsane Nacom nexa poxonae tauta. ");
INSERT INTO cui_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Icha ichamonae be paca itoroba paca necacaponaenexa pontha pon jiwi peyabara paebin penatsicuentsiwa, nexata patsipaebare barapomonae, poxonae cataunxuae namtotha paca barʉ pona xua painya nenaita coxone exanaewa tsanebe. Xain bapoxonae barapomonae jopa paca caponaebe tsane pontha pon jiwi peyabara paebin penatsicuentsiwa. Tsipei icha barapomonae bara beya paca caponaetsipa, bapoxonae pon jiwi peyabara paebin penatsicuentsiwa equeicha dabeya policiamonae beya paca itorobichipa. Bapoxonae nama policiamonae jiwi pecʉbi bo beya paca itorobichipa. ");
INSERT INTO cui_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Bara xaniyeya paca tsipaebatsi. Paxam jopa paca pu copabi tsane jiwi pecʉbi bo weya, beya abʉ poxonae pana pu matomacaename daxita paratixi cuntha po paratixi xua paxeiname”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Paxam pajume taneme xua Moisés pia peitorobi coyenewan xua jeye caena bayatha: ‘Jopa ichowa pichinde powa ichʉn piowa tatsi, powa piseuri xeina taetham’, jei Moisés. ");
INSERT INTO cui_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ichitha nama xan paca tsipaebatsi. Icha pebin tane petsiriwa, yawa nanta xeinaeya jeye: ‘Barapowa ichichipan taisa maituncuaewa tsane, bequein bapowa jopa taseuriyo’, jei, bapoxonae barapara abe exana Nacomtha, icha be pocotsi coyene ichi, poxonae pita yabʉyotha powa jopa bequein piseuriyo tatsi. ");
INSERT INTO cui_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Bara xaniyeya paca tsipaebatsi. Icha po itamaiqueito painya necoxa werena ducua icha barapo itamaiqueito paca exana xua abe painya neexanaewa tsane panaitamaiquei jucuare, barapo itamaiqueiton yawa tajʉ beya pabebande. Metha wʉnae xua painya nebebeiwa tsane cae itamaiqueitoxi xua Nacom pia nacua beicha cae itamaiqueitoxi painya neyawa patsinexa. Baxua jame wʉnae yatsicaewa, beyacaincha xua poxonae painya pepon ompin paca bebai tsane ichaxota po nacuatha isoto bapana jopa itacounayiyo. ");
INSERT INTO cui_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Barichi icha painya necobe, po cobe painya necoxa weya, icha barapo cobe paca exana xua abe painya neexanaewa tsane panacobe ucubobare, yawa tajʉ beya pabebande. Metha wʉnae xua cae cobexi painya nebebeiwa tsane, xua cae cobexi painya neyawa patsinexa Nacom pia nacua beicha. Baxua jame wʉnae beyacaincha xua poxonae painya pepon ompin paca bebai tsane ichaxota po nacuatha isoto bapana jopa itacounayiyo”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi jeye: “Caena bayatha Moisés pia peitorobi jume diwesitha namchiya jeye: ‘Pon punaxuba piowa peaichaxaibixae xua pocotsiwa bapowa exana, bapon barabʉ piowa catsina papera, po paperatha tina xua pexubiwa tsane piseuri’, jei barapo Moisés pia peitorobi coyenetha. ");
INSERT INTO cui_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ichitha nama seicaya icha coyeneya paca tsipaebatsi. Icha pebin piowa punaxuba xua saya peaichaxaibixae poxonae bequein bapowa jopa nasi cui coyene exanaeyo bapoxonae Nacom tsita abetsi xua bapon cana exana piseuritha. Tsipei bapon cana exana piowa xua piseuri tatsi nasi cui matacaeta xua weiweina pebiwitha. Barichi pon pita petsiriwa, powa piseuri pepunaxubixae, bapon barichi pia coutha abe natsiexana, tsipei Nacom ichowa yabara nanta xeina xua bapowa cataunxuae ichʉn piowa tatsi bequein punaxuba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Bayatha pajume taneme xua painya amo susato jiwi tsipaebatsi, xua Moisés tsipaeba. Moisés jeye: ‘Paxam jopa bewa naerabiya pana cui wʉnae tsiwʉnaeya yabara paebim tsane xua painya neexanaewa pocotsiwa paexanapaebeibame xua Nacom peitabaratha tatsi. Ichitha jame bewa bara xainyeya paexaneibiname pocotsiwa papaebeibame xua Nacom peitabaratha tatsi’, jei Moisés pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ichitha xan seicaya icha coyeneya paca tsipaebatsi. Poxonae jiwi peitabaratha tatsi pana nacui wʉnae tsiwʉnaeya xainyeya yabara paebiname pocotsiwa xua paexanapaebame bara moya baxua paexande, xua jiwi pia painya nepaca cajume cowʉntsinexa. Jopa yawa muxuna icha jumein papaebinde. Jopa pajande ichʉntha: ‘Bara xaniyan xua exanaein. Nacui wʉnae tsiwʉnaeya xaniyeya yabara paeban Nacom peitabaratha xua exanaein’, jopa pajande. Mataʉtano jopa pajande: ‘Bara xaniyan. Baraxua paeban po wʉntha xua Nacom pia nacua wʉntheicha tatsi’, jopa pajande baxua, tsipei Nacom bara xoteicha eca pia pexeinya equeibithopeibiwa tatsi ichaxota bapon ewatsiya itorobeibeca jiwi. ");
INSERT INTO cui_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mataʉtano barapocotsi coyenewa jopa bewa pana cui wʉnae tsiwʉnaeya yabara paebim ichʉntha xua ira yabara. Tsipei barapo ira apara Nacom pia ira. Barapo iratha nataxu yʉyʉteca. Barichi mataʉtano barapocotsi coyenewa jopa bewa pana cui wʉnae tsiwʉnaeya yabara paebim ichʉntha xua Jerusalén tomara yabara, tsipei barapo tomara, po tomaratha ichaxota Nacom popona pon jiwi itorobiya pia pepa Peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mataʉtano barapocotsi coyene jopa bewa pana nacui wʉnae tsiwʉnaeya yabara paebim ichʉntha xua painya nentasipa yabara. Saya meisa Nacom paca yabara matasipa yaputane. Pomonae pam xua pewowi pam xua pantana tsaebiam jopa paca itacʉpaeyo xua equeicha pantana inyapaname. Mataʉtano pomonae pam pomonae amomonae pam xua pantana inyapaname jopa itacʉpaetsi xua equeicha pantana tsaebiam. Mataʉtano jopa baxua daichiyo xua caentanatoxitha. Saya meisa Nacom itacʉpatsi xua cana exana baxua. ");
INSERT INTO cui_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Saya meisa barapo jumethabe patsipaebare ichʉntha ichaxota po jumetha jei ‘Je, bara exanaein’, jei, mataʉtano ichaxota po jumetha jei ‘Jume jopa exanaein tsane’, jei. Tsipei poxonae pamuxuna paebame poxonae pana tsiwʉnae yabara paebame ichamonaetha Nacom pia wʉntha tatsi xua painya neexanaewa pocotsiwa paexanapaebeibame baraxua apara caurimonae pia pentacaponaein tatsi paca tsimuxu duba xua painya nepaebiwa baxua”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Paxam pajume taneme xua bayatha Moisés paeba xua jeye: ‘Pon itamaiquei esanopa ichʉn peitamaiqueito, bapon xuya bewa itamaiquei esanopaeinchi. Mataʉtano pon xua wano teranopa, xua ichʉn wano teranopatsi, bapon xuya wano teranopaeinchi’, jei. ");
INSERT INTO cui_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ichitha nama icha coyeneya paca tsipaebatsi: Jopa xuya pebin pacaitacueinchinde poxonae paca caitacueinta, pon peaitabein. Mataʉtano icha ichʉn paca jumata tsaquinopa pecobetha, moya equeicha icha jumata pana najumata caeware xua painya necajumata tsaquinopaenexa. ");
INSERT INTO cui_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Icha ichʉn paca yabara yopichiya paeba pontha pon jiwi peyabara paebin xua penatsicuentsiwa xua painya nentoma amanayabixae bapon, bapoxonae bara pacare xua paca itoroba. Icha painya camisa pacata pita bara yawa muxuna pacare camisa po camisa peamʉtiyʉ camisa, po camisa xua athawe peruyaewa. ");
INSERT INTO cui_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Icha soldadomonae paca itoroba xua jeye: ‘Painta caponde pocotsiwa arewe xua saya cae kilómetro beya’, jei, bara moya pacaponde pocotsiwa arewe xua equeicha icha cae kilómetrono pantaropatabare. ");
INSERT INTO cui_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Daxita coyenexi pocotsiwa ichamonae paca wʉca, moya bara pacaichabeibare. Pon paca nacowaeta painyawa moya bara patsicobe copabare. Jopa paasiwinde painyawan”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Mataʉtano pajume taneme xua caena bayatha Moisés namchi, xua jeye: ‘Paantobeinde pomonae painya jiwi. Mataʉtano pacasebare pomonae painya nepaca caaitafaetabi jiwi’, jei xua Moisés paeba. ");
INSERT INTO cui_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ichitha icha coyeneya paca tsipaebatsi: Paantobeinde pomonae bequein painya nepaca caaitafaetabi jiwi. Mataʉtano Nacomtha patawʉcare pomonae bequein abe pacata exana. ");
INSERT INTO cui_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Icha paexanaename daxita barapo coyenexi bapoxonae yatsicaewa Nacom piamonae tatsi pam tsane. Bara paichim tsane icha be painya Axa ichi pon Nacom, pon peitabocotha peecaexae xua daxita jiwi antobetsi. Nacom xometo pentha taexana daxita jiwi pomonae pejʉntʉ coyene xanepanae jiwi nexa irʉrʉ pomonae peajʉntʉcoyenebe jiwi nexa. Mataʉtano Nacom ema taitorobicano daxita jiwi pomonae xaniwaicha pejʉntʉ coyene xeicae jiwi nexa irʉrʉ pomonae peajʉntʉcoyenebe jiwi nexano. ");
INSERT INTO cui_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Icha saya meisa paantobem pomonae painya nepaca antobexae, Nacom jopa paca cui yabara matomacae tsane. Tsipei irʉrʉ barapo coyene exana pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa, bequein jiwi yabara nanta xeina xua bapomonae peajʉntʉcoyenebewi. Barapomonae antobe pomonae xua pia peantobewixaetsi. ");
INSERT INTO cui_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mataʉtano icha saya meisa painyamonae pajacobame pomonae irʉ pejume cowʉntsiwi poxonae paca siwa pona, xuano xua jopa pajacobim ichamonae, pomonae jopa pejume cowʉntsiwi, barapo coyene jopa xanepanaeyo. Tsipei pomonae Nacom jopa peyaputae jiwi, barapomonae irʉ ba jacoba piamonae. Ichitha nama bewa toxeinchiya pananta xeinaem beyacaincha barapomonae poxonae nanta xeina. ");
INSERT INTO cui_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Daxota paxam bewa bichocono xaniwaichiya beta painompaem. Mataʉtano xua caewiyo jopa bewa paexanaem tsane xua peabe coyenewa. Barapocotsi jʉta coyeneya paichim tsane icha painya Axa ichi pon Nacom, pon peitabocotha peecaexae xua bichocono xaniwaichiya beta popona. Mataʉtano bapon caewiyo jopa exanaeyo peabe coyenewa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Poxonae paxam paexaname pocotsiwan xua ichamonae tsita xanepanatsi xua Nacom paca itoroba, bapocotsiwan paexande xua Nacom painya nepaca cacuitaenexa. Saya meisa jopa paexanaeinde xua jiwi ʉ painya nepaca cacuitaenexa xanepanaeya painya nepaca cayabara paebinexa. Icha bapocotsi coyeneya paexanaetsipame nexata painya Axa Nacom pon itabocotha peecaexae jopa paca catsitsipae pocotsiwa paca yabara cui coyene matomacaewa tsipei jopa paexanaetsipaem Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Daxota poxonae peacopeibiwi xoxi pacatsibeibame jopa ichamonae patsipaebinde xua baxua painya neexanaexae. Jopa barapocotsi coyeneya bara paichinde icha be pomonae pemuxuitorobiwi ichi, poxonae itara mexeya pomonae xanepanaya pepaebiwi. Tsipei barapocotsimonae saya ichawa beya paeba xua pinae yawena nawita peacopeibi jiwitha. Barapomonae matha jiwi wabeibatsi xua barapomonae pejume taenexa tsainchi, bapoxonae judiomonae pia penacaetutsi botha yawa namtontha baxua yabara paeba nawita xua pinae yawena nawita pomonaetha pomonae peacopeibi jiwi. Barapomonae baxua exana pia xua jiwi beta yabara nanta xeinaetsi, pia xua jeichi jiwi: Maisa barapomonae betiya exana, xua pejeinexa jiwi. Ichitha xaniwaicha paca tsipaebatsi, barapomonae xeina pia pecui yabara matomacaewatsi poxonae jiwi baxua caunuta tsipei jopa moicha exanaeyo Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Ichitha poxonae paxam payawename peacopeibiwi namicha moicha pacare barapomonaetha xua painya jiwimonae jopa paca necacui taenexa. Mataʉtano poxonae Nacom painya Axa paca tane poxonae namicha moicha paexaname baxua bapoxonae bapon Nacom paca catsina pocotsiwa pia pecui yabara matomacaewa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Poxonae Nacom pawʉcame, jopa barapocotsi coyeneya paexanaeinde icha be pomonae pemuxuitorobiwi ichi, pomonae itara mexeya beta pepaebiwi. Barapomonae saya ichichipa xua jiwi pecui taenexa poxonae barapomonae Nacom wʉcatsi. Barapomonae ichichipa umena pewʉcaenexa Nacomtha judiomonae pia penacaetutsi bontha tatsi xua mataʉtano barichino namtontha. Barapomonae baxua exana xua pecui taenexatsi xua ichamonae pecui taenexa. Bara xaniyei paca tsipaebatsi. Barapomonae barompaya xeina pia pecui yabara matomatsiwatsi poxonae jiwi yabara paeba xua barapomonae pinae bara xanepanaeya exana. Nama bapoxonae Nacom jopa catsiyo pia pematomatsiwa barapomonaetha tsipei barapomonae jopa moicha exanaeyo Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ichitha poxonae Nacom pawʉcame, barompaya painya tutu beya paponde yawa bomʉxʉ tutu pacoibo xatababare. Bapoxonae painya Axa Nacom baraxotiya patsipaebare. Painya Axa paca yanta compa yawa daxita paca cui tane pocotsiwa namicha paexaname. Bapoxonae bapon Nacom paca catsina pocotsiwa pia paca yabara cui matomacaewa, xua beta painya neexanaexae poxonae Nacom patsipaebame. ");
INSERT INTO cui_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Poxonae Nacom patsipaebame, jopa equeicha matowa patsipaebinde po jumetha xua po jume jopa paca yawenaeyo. Jopa bara paichinde icha be pocotsimonae ichi pomonae jopa peyaputaewi Nacom. Barapomonae nanta xeina xua bara Nacom jume tane pocotsiwa barapomonae tsipaeba xua matowa pepaebixae. ");
INSERT INTO cui_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nexata jopa barapocotsi coyeneya bara paichinde icha be poxonae barapomonae icha ichi. Tsipei painya Axa Nacom bara yaputane pocotsiwa painya nenantawenonaewam, xua beya poxonae pawʉcame Nacom. ");
INSERT INTO cui_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Daxota Nacom patsipaebare, paichinde: ‘Pata Taxam, xam ponxaem peitabocotha athabeicha neecaein. Barabʉ daxita jiwi cabarʉ cui itura jina nejʉntʉ coyene xanepanaeinxae. ");
INSERT INTO cui_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Barabʉ jopaena matacabi, po matacabitha poxonae xam jiwi itorobiya ewatsiname barapo cae pin nacuathe. Barabʉ jiwi exanaena pocotsiwa jinya neichichipae coyenewa xua barapo cae pin nacuathe tsique. Barabʉ jiwi exanaena icha peitabocotha ichi xua exana pocotsiwa jinya neichichipae coyenewa. ");
INSERT INTO cui_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Daxita matacabin pexaewa pana catsibeibare xua po pexaewa daxita matacabin pata canantawenonaewa tsaibi tsane. ");
INSERT INTO cui_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pana neyabara cui cana jʉntemainare xua abe pata catsita exanaewatsi. Bapoxonae pana neyabara cui cana exaname xua jopa equeicha pata catsita natsicuentsiwatsi xua abe pata catsita exanaexaetsi. Baraxua painta exande icha paichin ichamonaetha. Tsipei paxan copiya payabara cui cana exanan xua ichamonae jopa pana netsita natsicuentsiyo xua abe pata tanetsita exanaexae. ");
INSERT INTO cui_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jopa pana copatsinde xua abe pata exanaewa tsane poxonae jiwi pana nejʉntʉ coyene jʉjʉta, xua abe pata exanaewa tsane. Ichitha pana necapanenebiya exande barapo abe peexanae coyene weya’, pajande poxonae Nacomtha patsipaebame”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Tsipei icha paxam pacui yabara jʉntemainame pocotsiwa ichamonae pacata abe exana, nexata xuya painya Axa Nacom pon peitabocotha peecaexae, xuya paca cui yabara jʉntemainaena pocotsiwa abe paexaname. ");
INSERT INTO cui_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ichitha icha paxam jopa pacui yabara jʉntemainaem pocotsiwa ichamonae abe pacata exana, nexata xuya painya Axa Nacom jopa paca cui yabara jʉntemainae tsane pocotsiwa abe paexaname”, jei Jesús barapo pin bicheitomonaetha pomonae pijimonaexae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Equeicha Jesús barai barapo pin bicheitomonae pomonae pijimonaexae tatsi, jeye: “Poxonae paxam payabara nainbotame xua Nacom beta painya newʉcaenexa tsane, jopa bara jʉta ichiya coyeneya paexanaeinde icha be pomonae ichi pomonae itara mexeya betiya peexanaewi daichitha abe exana. Barapomonae piyain itabara aenaenaca xua poxonae bequein peyabara nainbotsiwatha Nacom. Barapomonae jopa nanta cachetsiyo yawa jopa naitabara quiatsiyo. Barapomonae ichipa xua ichamonae yaputane xua barapomonae cou bara nainbota. Bara xainyeya paca tsipaebatsi xua barapomonae bayatha xeina barompaya pia peyabara cui matomacaewatsi xua poxonae jiwi yabara wʉnae jainta xua barapomonae cou bara nainbota. ");
INSERT INTO cui_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ichitha paxam poxonae payabara nainbotame, xua Nacom betiya painya newʉcaenexa tsane, pana naitabara iquicare yawa beta pananta caichere. ");
INSERT INTO cui_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bapoxonae jiwi jopa paca cui yaputae tsane xua paxam bara cou payabara nainbotame. Namicha painya netsita exanaexae Nacom barapo coyene. Meisa saya painya Axa Nacom paca cui yaputane, tsipei daxita yaputane pocotsiwa namicha paexaname. Bapon paca catsina pocotsiwa pia paca yabara cui matomacaewa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Barapo cae pin nacuathe copei jopa pacaetubinde xua painya nexeinaewa tsane nawita barapo cae pin nacuathe. Tsipei bocobocowaton abe exanaena poxonae xane pocotsiwan xua paxeiname. Ichacuitha abe exanaena poxonae painyawan axumainbatsi. Ichacuitha painyawan pocotsiwa paxeiname baxuan pomonae pecaibiwi paca caibina. ");
INSERT INTO cui_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ichitha jame paexande barapo pejʉntʉ coyene xanepanaewa po pejʉntʉ coyene xanepanaewa Nacom ichichipa. Bapoxonae Nacom paca catsibina pocotsiwa painya nepaca jʉntana jebiwa pia nacuatheicha. Baraxoteicha bapocotsiwa bocobocowaton jopa xaeyo. Yawa jopa axumainbichi. Mataʉtano pomonae pecaibiwi jopa paca caibiyo baxuan xuan Nacom paca necayabara cui matomacaewan. ");
INSERT INTO cui_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ichaxota ba pajebame xua painya neichichipaewan baxota ba payabara nanta xeiname nawita”, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Pecoicha ba yonoyonei merawi painya nepaca cayawenaenexa xua beta painya netaewa tsane quireitha. Barichi painya itamaiqueiton paca yawena xua beta painya netaewa tsane. Icha painya itamaiqueiton wʉnae, bara beta pataneme. ");
INSERT INTO cui_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ichitha icha painya itamaiqueiton abe, jopa beta pataetsipaem. Barichirʉ painya jʉntʉ coyenewan xua painya nenanta xeinaewan. Icha painya jʉntʉ coyenewan xanepanaetsipa bara beta Nacom payabara najʉntʉ coyene xeinaetsipame. Ichitha icha painya jʉntʉ coyenewan jopa xanepanaetsipae jopa beta Nacom payabara najʉntʉ coyene xeinaetsipaem. Painya jʉntʉ coyenewan paca cana exanaetsipa xua bichocono abe paexanaetsipame”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Jiton dapon aibi pon xeina ainya pia pecanamataxeinaeinchibe tatsi xua pon beta tanacuita barapo pia ainya pecanamataxeinaeinchibe tatsi. Tsipei barapo petanacuichin meisa antobeya taexana caeintha pon pia pecanamataxeinaeinchi poxonae itorobatsi. Icha pia pecanamataxeinaeinchi jopa taraichiyo. Cae pia pecanamataxeinaeinchi xanepanaeya taexana. Icha pia pecanamataxeinaeinchi abeya taexana. Barichi jiton pon bichocono antobe Nacom jopa itacʉpaetsi xua bichocono peantobewa paratixi poxonae yawa bichocono antobetsi Nacom”, jei Jesús barapo pin bicheitomonaetha, pomonae pijimonaexae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Paca tsipaebatsi, jopa bichocono payabara najʉntʉ coyene exabinde pexaewa xua painya neuna jinompaewa tsane yawano xua painya neapaewanno tsane. Barichi jopa bichocono payabara najʉntʉ coyene exabinde papabʉrʉ xua painya pepon nexa. Po coyene xua asʉ pejinompaewa xua Nacom naca cata jame baxua ainya cui, beyacaincha pexaewa xua peuna jinompaewa. Pepon ainya cui irʉ, beyacaincha papabʉrʉ xua pepon nexa. ");
INSERT INTO cui_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pataema peyapupunaewi. Barapoxi jopa ʉbiyo pabitha. Yawa xua penawetsiwa jopa notsiyo. Yawa jopa xeinaeyo bomʉxʉn xua pejebinexa pexaewan. Ichitha Nacom apata peyapupunaewi pexaewa. ¡Paxam nama bichocono Nacom patsita ainya cuim, beyacaincha peyapupunaewi xua Nacom tsita ainya cuichi, po Nacom painya Axa pon itabocotha eca! ");
INSERT INTO cui_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Dapon aibi pon paxam jiwana pon itacʉpatsi xua xeinaena icha matacabi xua po matacabitha pepoponaewa tsane poxonae tʉpaena. Bequein bapon bichocono nayabara najʉntʉ exaba baxua, ichitha jopa itacʉpaetsi xua xeinaena caentacabi equeicha. ");
INSERT INTO cui_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Paxam bichocono payabara najʉntʉ exabame papabʉrʉ. Jame pacayabara nanta xeinare pentonon, po pentonon wexotha xuwa, xua matono itʉpana. Pentonon jopa nacuichiyo yawa jopa natsiexanaeyo papabʉrʉ penama xatabinexa. ");
INSERT INTO cui_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ichitha paca tsipaebatsi xua pentonon matono itʉpana bichocono beyacaincha pocotsi paparuwa Salomón nama xatata xua pexeinya paparuwa. Bapon Salomón pon caena bayatha judiomonae itorobiya pia pepa peewatsinchi pon bayatha tʉpa. ");
INSERT INTO cui_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pentonon po matonon wexotha anoxuae xuwa, Nacom cana exana xua matono itʉpana. Ichitha pebiwi baya matono tautsina ichaxota pocotsiwatha pan seba, tsipei saya pentono. Nacom cana exana xua pentonon bichocono wʉnae bara bequein saya pentonon. Barichi Nacom itacʉpatsi xua beta paca neca-eenaewa xua beta painya nejinompaenexa. Mataʉtano Nacom paca catsina paparuwan. ¡Maisa pebiwi pam tsobenae, be conotha pajume cowʉntame Nacom! ");
INSERT INTO cui_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jopa paʉnthʉthʉ deideijeya jinompaeinde xua ichawa painya neyabara nanta xeinaexae. Jopa pajan tsaibinde: ‘¿Eta xua xaeinchi jane? ¿Eta xua apaeinchi jane? ¿Eta xua nama xatabinchi jane?’ jopa pajan tsaibinde. ");
INSERT INTO cui_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tsipei barapo cae pin nacuathe jiwi saya ʉ baxua pecayabara najʉntʉ coyene exabi pocotsiwa nantawenona. Ichitha nama paxam painya Axa Nacom panantaʉtame. Barapon Nacom pon peitabocopin, pon yaputane daxita pocotsiwa xua xoxi panantawenoname. ");
INSERT INTO cui_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Saya meisa jame bichocono copiya payabara nanta xeinare xua painya neexanaewa xua pocotsiwa Nacom ichichipa pon jiwi itorobiya pia pepa peewatsinchi. Mataʉtano jame bichocono payabara nanta xeinare painya nexeinaenexa pejʉntʉ coyene xanepanaewa Nacomtha. Icha paexanaename barapo coyenewan nexata bapoxonae Nacom paca catsibina xua daxita pocotsiwa panantawenoname. ");
INSERT INTO cui_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jopa payabara muxuna najʉntʉ exabinde anoxuae pocotsiwa baya tsane pocotsiwa painya neexanaewa tsane, tsipei barapo matacabi nama xeina pocotsiwa bichocono pacata ayapube. Daxita matacabi tsoponeibi pocotsiwa xua pacata ayapube xua pocotsiwa painya neexanaewan”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Jopa ichamonae payabara paebinde xua penatsicuentsiwa xua abe peexanaexae. Nexata bapoxonae Nacom jopa paca yabara paebi tsane painya nenatsicuentsiwa xua abe painya neexanaexae. ");
INSERT INTO cui_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nacom pia coya paca yabara paebina xua painya nenatsicuentsiwa xua abe painya neexanaewa icha po coyeneya paichim poxonae ichamonae payabara paebame xua penatsicuentsiwa xua abe peexanaexae. Icha daunweya payabara paebiname xua penatsicuentsiwa ichamonae xua abe peexanaexae, Nacom barichi daunweya paca yabara paebina xua painya nenatsicuentsiwa xua abe painya neexanaexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Equeicha Jesús paeba caeintha pomonae pijimonae jiwana pecayabara jʉta pepaebi diwesiyo jeye: “Xam ba jinya jiton itata taneme poxonae itata jopiyatsi naepʉtiyo, ichitha jopa taem xua irʉrʉ xam nama pin naepʉto neitamaiqueitotha ducua. Barapocotsi jʉta coyeneya ichi, xam ba jinya jiton cui taneme xua poxonae abe exana, ichitha jopa nayaputaem xua irʉrʉ xam baraichim nama bichocono abe exaname. ");
INSERT INTO cui_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Icha jopa taem pin naepʉto xua neitamaiqueitotha ducua jopa caitacʉpaeyo xua nejeiwa jinya jitontha: ‘Tajiton, cata jutinchi naepʉtiyo xua ducua neitamaiqueitotha’, xua nejeiwa. ");
INSERT INTO cui_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Xam nepaebim xua ichʉn exana xua baxua neexanaewatha irʉ. Xam copiya nata jure barapo pin naepʉto xua neitamaiqueitotha ducua. Bapoxonae beta taename nejutsinexa tsane naepʉtiyo xua jinya jiton peitamaiqueitotha tarucuatsi. ");
INSERT INTO cui_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Jopa patsipaebinde Nacom Pejume Diwesi pomonae anaya paca aeba, xuano anaya aeba Nacom Pejume Diwesi pomonae jopa pejume cowʉntsiwi Nacom. Tsipei barapomonae peajʉntʉcoyenebe jiwi bichocono. Barapomonae bara abe exana be barapocotsi jʉta coyeneya ichiya exana icha be auri ichi xua poxonae anaepanaya nawano webaba pocotsiwa pacatame. Mataʉtano barapomonae bara abe exana be barapocotsi jʉta coyeneya ichiya exana icha be marrano ichi, xua poxonae petaxutha taxunaunaba xua irainyaba po pexaewa paapatame”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Matowa Nacom pawʉcare, bapoxonae paca catsibina pocotsiwa xua pawʉcame. Baraxua matowa paexande icha paichim poxonae matowa pajeiteibame beya poxonae pataebame yawa icha paichim poxonae matowa pawawam bomʉxʉtha beya poxonae ichʉn paca jume nota. ");
INSERT INTO cui_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tsipei pon matowa wʉca ichʉn bara catatsi. Tsipei pon matowa necoba, bara taeba. Tsipei pon bomʉxʉ pecoibototha matowa wawai, bara tacoibo sarana xorenatsi, mataʉta jume notatsino. ");
INSERT INTO cui_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Paxam pomonae pexui paxeiname paca muxuwetatsi. Poxonae painya pexui paca wʉca pan, ¿pacatsipame iboto? ¡Jume! ");
INSERT INTO cui_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ichacuitha tsipae, poxonae painya pexui paca wʉca duwei, ¿pacatsipame jomo wito? ¡Jume! Jopa baxua paraichim tsane. ");
INSERT INTO cui_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bara bequein peajʉntʉcoyenebe jiwi pam, ichitha paxam payaputaneme xua xanepanaeya painya pexui pacatsibeibame. Ichitha nama Nacom painya Axa pon itabocotha peecaein bichocono jopa juniya paca catsiyo pejʉntʉ coyene xanepanaewan poxonae pawʉcame beyacaincha poxonae painya pexui pacatsibeibame poxonae paca wʉqueiba. ");
INSERT INTO cui_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Paexande ichamonaetha xua po coyene painya neichichipaewa xua barapomonae beta painya nepacata exanaewa tsane. Tsipei barapo coyenewa bayatha Moisés pia peitorobi coyenewatha paca itoroba, mataʉtano Nacom pia peitorobi jume pepaebiwi bayatha paca cui itoroba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Nexata equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Poxonae jiwi pona tomara beya, pomonae itapeta pin namto iya pona, barapo jiwi pinmonae, tsipei barapo tomara namto boupa iya xua jopa ayapubeyo. Pomonae nama itapeta, po namto tsica namtiyo iya pona, barapo jiwi tsiquimonaeyo tsipei barapo tsica boupayo ayapube iya. Barichi poxonae jiwi patsina Nacom pia nacua beicha saya tsiquimonaeyo patsina tsipei ichamonae jopa tsita jʉntʉ cui coyene xanepanaetsi xua xanepanaeya pejinompaewa Nacomtha. Daxota pomonae Satanás pia nacua beya patsina pinmonae tsane tsipei jopa taayapubetsi xua barapo Satanás pia jʉntʉ coyeneyatha tatsi jinompa. Nama itapeta pacananta xeinaeya jinompare Nacom pia jʉntʉ coyenewa tatsi xua icha jiwi ichi poxonae seicaya irʉrʉ barompaya pona tomara tsica namtiyo boupayo iya”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Dota pam, dota pomonae penaerabiwi, pomonae xua jeye: ‘Paxan papaeban Nacom nexa’, jei. Barapomonae painya xainya beya pata itara mexeya jopa jʉntʉ coyene anaepanaeyo icha be ichi pomonae xua Nacom pejume jejei jiwichi xua peexanaewa pocotsiwa Nacom itoroba xua mataʉtano icha be ovejamonae ichi xua pia cui coyene xeina xua jopa anaepanaeyo. Daichitha barapomonae bichocono antʉcuicoyeneyapube xua anaepana, icha be neʉthʉ ichi poxonae bichocono anaepana. ");
INSERT INTO cui_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ichitha paxam pacayabara ita coxoname barapomonae poxonae pataneme pocotsiwa barapomonae exana, icha be jiwi ichi xua poxonae yaputane nae, po nae penacoichixae. Mataʉtano jiwi jopa yaputaeyo xua bapana jiwi jopa teracae uva cuei po naetha sojei, tsipei apara uva cuei xuwa ʉnbototha po ʉnbo jopa e dubenaeyo. Mataʉtano jiwi jopa bapana teracae higo thei naexitha, tsipei apara higo thei xuwa higo naetha. ");
INSERT INTO cui_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tsipei daxita naein, po naein pexeinya naein bara nacoita po pethei pexeinya thei. Mataʉtano daxita naein, po naein camatsa naein bara nacoita po pethei camatsa thei. ");
INSERT INTO cui_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Po nae pexeinya nae jopa bapana nacoichi po pethei camatsa thei. Barichi po nae camatsa nae jopa bapana nacoichi po pethei pexeinya thei. ");
INSERT INTO cui_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Daxita naein, po naein jopa nacoichiyo po pethei pexeinya thei, jiwi barapo naein ʉncata. Bapoxonae jiwi barapo naein tauta isototha. ");
INSERT INTO cui_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Icha naein cana ichichi xua poxonae jopa penacoichiyoxaera, bara cana ichi tsainchi jiwi xua poxoru xanepanaeya jopa peexanaexaera tsane. Icha ichi xua payaputaneme naein poxonae pia pethei pataneme, barichi jiwi pantʉ cui coyene yaputaneme poxonae pataneme pocotsiwa barapomonae exana”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Pinmonae jiwi neyabara caunutsiya jei tsane: ‘Tanecanamataxeinaem’, jei tsane. Daichitha barapomonae jiwana tsicamonaeyo patsina Nacom pia peitorobi nacua beicha. Saya meisa patsina pomonae exana xua pocotsiwa Taxa ichichipa. Barapomonae patsina ichaxota Taxa po nacuatheicha ewatsiya itorobeibeca. ");
INSERT INTO cui_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Poxonae barapo matacabi jopaena, po matacabitha poxonae Nacom yabara paebina xua jiwi penatsicuentsiwa pinmonae jiwi pijunuwi neyabara caunutsiya jei tsane: ‘Pata Tanecanamataxeinaem, paxan pacueicueijan nejume diwesi xam nexa. Mataʉtano cauri paitawetan newʉntha. Mataʉtano jinya newʉntha papaeban poxonae pexeinya petsita itʉtsi coyenewa paexanan’, nejei tsane. ");
INSERT INTO cui_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Daichitha barapomonae jume notsin. Jan tsane: ‘Bʉ canta bapana jopa paca yaitaetsi. ¡Taxainya weya pana natsixibarʉcʉpare pomonae abe painya neexanae jiwi pamxaem!’ jan tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Equeicha Jesús barai barapo pin bicheitomonae, pomonae pijimonaexae tatsi, jeye: “Pon nejume naitomata pocotsiwa paeban mataʉtano exanano pocotsiwa ichichipan barapon beta popona Nacom nexa. Bara barapon barapocotsi jʉta coyeneya nacana exana icha be pocotsin peyaputaein ichi, pon bo acabanota peira matatsucaewatha xua ichaxota ira daunwei. Meje jeye: Copiya mʉthʉn tajʉ exanareca pecuaranobinexa bomʉxʉ naeton. ");
INSERT INTO cui_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Poxonae ema duneica yawa mene matacaewaxuba yawa joibo bomʉxʉ daunweya capubabanota, barapo bomʉxʉ jopa joparenaeyo, poxoru naeton tajʉ umenareca xuano poxoru barapo bomʉxʉ peira matatsucaewatha uncua ichaxota ira daunwei. ");
INSERT INTO cui_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ichitha nama pon nejume taetha xuano jopa exanaeyo pocotsiwa ichichipan jopa beta poponaeyo Nacom nexa. Bara barapon barapocotsi jʉta coyeneya nacana exana icha be pocotsin amameibatsi ichi. Bapon be meje: Bapon be pocotsin bo acabanota ichaxota ira matafatsana xuano naeton jopa tajʉ umenarecaeyo poxoru taetowa. Baraxota mene pateiba poxonae awʉbo tsaibi. ");
INSERT INTO cui_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Poxonae ema duneica, yawa mene matacaewaxuba, yawa pin joibo capubabanota barapo bo, bapoxonae barapo bomʉxʉ joparena poxoru naeton jopa tajʉ umenarecaeyo xuano poxoru bomʉxʉ uncua ichaxota ira matafatsana. ¡Maisa bomʉxʉ bichocono abe!” jei Jesús barapo pin bicheitomonaetha, pomonae pijimonaexae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Poxonae Jesús barapo diwesin najume weta, pomonae Jesús jume tainchi, barapomonae yabara najʉntʉ coyene cabenaeca xua Jesús pia pecuidubiwan tatsi. ");
INSERT INTO cui_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tsipei Jesús ba cuiduba be peyaputaein pia peayapusʉ itorobi coyeneya tatsi. Jesús jopa cuidubiyo be judiomonae pia pecuidubiwi pia picoyeneya tatsi. ");
INSERT INTO cui_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Poxonae Jesús peitapatororo wejuinca, pin bicheitomonae Jesús puna poinchi. ");
INSERT INTO cui_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jesús imoxoyo caquita poinchi pebin, pon peperʉ sawinchi. Bapon pentabocototha uncua Jesús peitabaratha tatsi xua Jesús pebarʉ cui itura jinaexaetsi. Bapon namchi Jesús beya, jeye: —Pon Necanamataxeinaem jiwi, icha bara ichichipame bara caitacʉpa xua axaibi tana neexanaewam, tsipei jinya neayapusʉ itorobi coyenewa nexeinaem, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nexata Jesús nacobe yota yawa mata jayaba barapo pebin. Jesús barai, jeye: —Bara ichichipan. ¡Bara axaibinde! ¡Bara caaperʉxaibi exanatsi! jei Jesús. Bapoxonae bapon nainya taaichurucuaetsi xua peperʉ sawiwatsi. ");
INSERT INTO cui_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nexata Jesús barai peperʉ sawinchi: —Taema, jopa yabara tsipaebinde ichamonaetha xua neaxaibiwam. Saya jame meisa ponde sacerdotemonaepintha xua nenaitʉtsinexa xua bapon necataenexa xua bayatha nejumewa. Bapontha care pocotsiwa xua pecatsiwa Nacomtha, pocotsiwa xua bayatha Moisés cui itoroba xua equeicha jopa jinya nenataxobinexa jinya pepontha. Bapoxonae daxita jiwi cayaputaena xua tsita ita peinya xeinatsi xua xam bara jumem yawa xua perʉ wʉnaem, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Poxonae Jesús joniya Capernaum tomaratha, bapoxonae pebin Jesús imoxoyo caquita poinchi. Bapon romanomonae soldadomonae pia pentacaponaein tatsi. Bapon nantaʉta pon tanacuiteibatsi pia botha. ");
INSERT INTO cui_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Barapo pentacaponaein Jesús jume daunweya baraichi, jeye: —Tanecanamataxeinaem, pon inta nacuiteiba camatha boca tabotha. Bapon mʉbatsi yawa bichocono atene, jei barapo pentacaponaein. ");
INSERT INTO cui_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús namchi: —Bara beya tha ponaetsi taaxaibi exanaenexa bapon, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Barapo soldadomonae pia pentacaponaein tatsi jume nota: —Tanecanamataxeinaem, xan saya tacui pawin. Auran xua xam nepatopaewa tsane tabotha tsipei xam ainya cuim. Icha saya paebiname xua bapon pia peatenewatha tatsi, bapoxonae bara axaibi tsane pon inta nacuiteiba. ");
INSERT INTO cui_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Xan barichi xeinan tananecanamataxeinaein pon neitoroba. Barichirʉ xeinan soldadomonae pomonae itorobeiban. Poxonae ichʉn itoroban: ‘ponde’, jan, bara bapon pona. Poxonae ichʉn waban: ‘antha’, jan, bara bapon patopa. Pon inta nacuita itoroban: ‘inta exande’, jan. Bara inta exana, jei barapon pon pentacaponaein. ");
INSERT INTO cui_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Poxonae Jesús baxua jume taeba, jume cui yabara cananthʉthʉ nanta xeinanaya cabenaeca, beta pepaebixae romanomonae soldadomonae pia pentacaponaein tatsi. Jesús necotaba pomonae puna poinchi, barai, jeye: —Xaniyeya paca tsipaebatsi, Israel nacuatha irʉ dapocotsin jopa caxinaeinyo pocotsin icha pon iche pon tana necui yabara jume cowʉntsin xua bara neitacʉpa xua axaibi taexanaewa jiwi. ");
INSERT INTO cui_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Paca tsipaebatsi, pinmonae patsina Nacom pia peitorobi nacuatha penabanaenexa tsane. Ichamonae pomonae ichaxota xometo ecoina, barapomonaepiwi patsinano. Ichamonae pomonae ichaxota xometo jopeica, barapomonaepiwi patsinano. Daxita carepaya barapomonae Abraham barʉ equiyaena, irʉ Isaac barʉ equiyaena irʉ Jacob barʉ equiyaena. Daxita carepaya barapo nacuanmonaepiwi barʉ nabanaeinchi peitaboco beicha. Abraham, barʉ nabanaena barapomonae ichaxoteicha Nacom itorobiya ewateiba jiwi. ");
INSERT INTO cui_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ichamonae nanta xeina xua bepa pinae patsina Nacom pia peitorobi nacua beicha tatsi, bara bequein jopa xanepanaeya peexanaewi. Daxota barapomonae bebai tsainchi ichawatha waxainya weya ichaxota pequireiwatha. Baraxota barapomonae bichocono wecoyei tsane yawa nantanuweya nantʉ jayabina, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nexata Jesús barai pentacaponaein, jeye: —Ponde jinya bo beya. Bara cata exanatsi tanecui yabara jume cowʉntsimxae xua bara taneitacʉpaewa xua tacata exanaewatsi, jei Jesús. Bapoxonae barapo pentacaponaein pia petanacuichin tatsi bara caena taaxaibi exanatsi. ");
INSERT INTO cui_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús joniya Simón Pedro pia botha tatsi. Baraxota Jesús tane Pedro pamiyo tatsi xua camatha boca yawa xua domaebatsi. ");
INSERT INTO cui_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús cobe pita, barapowa cobe pitatsi. Domae taaichurucuaetsi bapowa. Nainya barapowa nanta cotaxuba. Bapoxonae bapowa pexaewa apata barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Poxonae tabopiya tsanaicha, ichamonae pomonae cauri xeina barapomonae Jesús becarendenatsi. Jesús pia jumetha itaweta caurimonae. Barichi Jesús axaibi exana daxita pomonae peatenewi. ");
INSERT INTO cui_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Poxonae Jesús barapo coyenein exana, bara nayabara jume cui weta exana caena bayatha Isaías peyabara cui tsiwʉnaeya paebixae. Bapon Isaías Nacom peitorobi jume pepaebin. Bapon jeye Cristo yabara: “Bapon naca wenota wajʉntʉ coyene bojeiwa. Mataʉtano bapon naca wenota waatene coyenewan”, jei Isaías pejume diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Poxonae Jesús tane xua pin bicheitomonae nacaetuta bapontha, bapoxonae bapon pijimonae itoroba xua icha muxunene beya peponaenexa tsane xua pucua epataʉta iya. ");
INSERT INTO cui_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Poxonae cataunxuae Jesusbarʉ jopa torobabiyaeyo xua icha muxunene beya nexa, bapoxonae Jesús imoxoyo caquita uncuatabʉtsi pon jiwi pecuidubin Moisés pia peitorobi coyene. Jesús baraichi: —Pon jiwi Necuidubim, capuna ponaeinchi daxita jʉpaeyantha xua ichaxotan neponaewa tsane, jei. ");
INSERT INTO cui_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús jume nota: —Namomonae ba pia mʉthʉn xeina ichaxota pemaitathopeibiwa. Irʉ peyapupunaewi ba coton xeina, ichaxota peyamaitathopeibiwa. Ichitha nama xan ponxaein Nacom Tananeitapetsin nama jopa daichinyo. Nama jopa xeinaeinyo bo xua tabo xua xota nafifinacaecan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Bapoxonae ichʉn pon irʉ Jesús pijimonae jiwana bapon Jesustha namchi, jeye: —Tanecanamataxeinaem, bara nepu copare tha taxa matha mʉthʉtha xubichi copiya xua bapoxonae tacapuna ponaewatsi tsainchi, jei. ");
INSERT INTO cui_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús jume nota: —Maisa jame nepuna ponde. Bara copare xua petʉpaewi bara mʉthʉcaeinchi, pomonae be pewerapaewi, jopa be tana nejume cowʉntsiwixae, barapomonae mʉthʉcaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nexata Jesús jeratha nontabiya. Jesús pijimonae barʉ pona jeratha. ");
INSERT INTO cui_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bapoxonae jemeicha pin joibo naetaba mentha. Maratsacan jeratha mene othopa muxu pebunarecae. Daichitha Jesús maituncua. ");
INSERT INTO cui_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bapoxonae Jesús pijimonae yaʉbaxotsi, jeichichi Jesús: —¡Pata Necanamataxeinaem, pana capanepare! ¡Yanabunarecatsi! jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús jume nota: —¿Eta pocotsiwa metha bichocono pajunuwame? ¿Cataunxuae jopa pana neyabara jume cowʉntsim xua bara tana neitacʉpaewa xua tapaca yawenaewatsi? jei Jesús. Nexata Jesús asiya uncua. Bapoxonae Jesús itawetaxuba joibo, maratsacano. Daxita caewanaya joibo yawa maratsacano. ");
INSERT INTO cui_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Bapoxonae barapo pebiwi yabara najʉntʉ coyene cabenaecarʉcʉpa xua pocotsiwa Jesús peexanaexae. Barapomonae najei: —¿Metha jintamda baponda? ¡Jamaisa bapon itawetaxuba joibo yawa maratsacan xua daxita xainya dubenanaya! najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Poxonae Jesús patopa pucua icha muxunene beya xua po nacuatha Gadara nacua, bapoxonae pebinbe Jesús imoxoyo caquita uncuatabʉtsibe. Baponbe ibo wountha poponeibabe. Caena bayatha baponbe xeinabe caurimonae. Barapo caurimonae baponbe anaepana cana exanatsibe daxota daxita jiwi junuwa xua peponaewa barapo namtotha ichaxota baponbe poponabe. ");
INSERT INTO cui_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bapoxonae jemeicha caurimonae baponbe wawai exanatsibe, jeibe: —Nacom Pexantom tatsim, ¿eta pocotsiwa metha patopame pata xantha? ¿Patopame jinya painya neperaxa exanaetsibe pewʉnaeya xua po matacabitha xua poxonae Nacom atene pana exanaena xua abe pata exanaexae? jei baponbe xua caurimonae wawaya exana. ");
INSERT INTO cui_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tsiwiyo tajʉyo beya pin marrano duweimonae xayompa. ");
INSERT INTO cui_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Caurimonae Jesús jeichi: —Icha pana itawetame, moya pana nepu copabare marrano duweimonaetha, jei caurimonae. ");
INSERT INTO cui_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nexata Jesús jume nota caurimonaetha, jeye: —Moya pataema, jei. Nexata caurimonae pebinbe wepu ponatsibe, yawa marrano duweimonaetha pata. Barapo marrano duweimonae dʉcʉpa, pin pitapatororo othopareca. Pucuatha bunothopa. Caurimonae cabunothopatsi. ");
INSERT INTO cui_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pomonae yapu eena barapo marrano duweimonae, junuwiya cuinaenouta peyabara paebinexa tomarapiwitha. Barapomonae yabara paeba daxita pocotsiwa Jesús cana exana marrano duweimonaetha yawano pocotsiwa Jesús cana exana ponbetha ponbe xua cauri pexeinaeinbe. ");
INSERT INTO cui_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bapoxonae daxita tomarapiwi pona ichaxota Jesús eca. Poxonae Jesús tainchi, barapomonae Jesús jeichichi: “Maisa bewa warapaename Gadara nacua weya, po nacua pata nacua weya”, jei daxita barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nexata Jesús jeratha nontabiya. Jeratha pona icha muxunene beya xua pucua epataʉta iya. Jesús pia tomara beya patopa, barapo tomara icha muxunenetha eca. ");
INSERT INTO cui_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Baraxota pebiwi pata. Barapo pebiwi Jesús tacarendenatsi pon pecuenobinchi. Xua xota pocotsiwatha pemaiteibiwa, barapomonae barapocotsiwatha pecuenobinchi carendenatsi. Poxonae Jesús tane xua barapomonae yabara jume cowʉnta xua bara Jesús peitacʉpaewatsi xua axaibi peexanaewatsi pon pecuenobinchi, bapoxonae Jesús barai pecuenobinchi: —Tajiton, najʉntʉ coyene tsacatabare. Cacui yabara jʉntemainaya jʉntʉ puxana exanatsiba jinya abe neexanae cuiru coyenein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bapoxonae pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi, barapomonae daxita carepaya pia coutha nanta xeina. Najei: “Maisa bapon bichocono abe tsipei pocotsiwa bapon paeba bichocono Nacom tsita ajumebetsi. Jiton dapocotsin aibi pon xua jiwi cacui yabara jʉntemainaya jʉntʉ puxana exanatsi abe pia peexanae cuiru coyenein tatsi”, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Daichitha Jesús yaputane xua barapomonae pijʉntʉ coyeneintha natsipaeba. Jesús barai barapomonae, jeye: —¿Eta xua metha baxua abeya pana neyabara cananta xeiname? ");
INSERT INTO cui_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Eta po jumetha baran tsane pecuenobinchi? ¿Metha jan tsane: ‘Jinya abe neexanae cuiru coyenein cata jʉntemainatsi’, jan tsane? Ichacuitha ¿metha jan tsane: ‘Nontaponare, yawa bara ponare’, jan tsane? ");
INSERT INTO cui_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Daxota aunxuae paca tsita itapeinya xeinaeinchi xua xan ponxaein Nacom Tananeitapetsin, xua xeinan taayapusʉ itorobi coyenewa xua bara tana neitacʉpaewa xua jiwi tayabara cacui jʉntemainaya jʉntʉ puxana exanaewa abe pia peexanae cuiru coyenein tatsi pomonae jinompa barapo cae pin nacuathe, jei Jesús. Bara nexata pecuenobinchi Jesús barai, jeye: —Catsipaebatsi nontaponde. Jinya nemaituncuaewa pire. Jinya bo be-iyande, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bapoxonae pon pecuenobinchi caena nainya nontapona barapomonae peitʉtha tatsi, yawa pita xua pemaituncuaewa. Bapoxonae pia bo be-iya. ");
INSERT INTO cui_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Poxonae jiwi tane baxua, barapomonae yabara najʉntʉ coyene cabenaeca yawa Nacom wʉnae jaintatsi. Barapomonae nabarai: —Anoxuae waxainchi tainchi pocotsiwa pewʉnaewa pocotsiwa jopa yaputaetsi, yawa wʉnae jaintatsi xua Nacom barapo jitontha pecatsixae pia peayapusʉ itorobi coyenewa, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús bara weya pontaba ichaxota axaibi exana pon pecuenobinchi. Bapoxonae Jesús tane pebin pon pewʉn Mateo. Bapon eca ichaxota bapon paratixi matoma noteibeca po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. Jesús Mateo baraichi: —Nepuna ponde, jei Jesús. Bapoxonae Mateo caena nainya nontapona yawa napuna pona Jesustha. ");
INSERT INTO cui_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pirapaeyo Jesús barʉ ecatsi, Mateo barʉ eca pia botha pexaethopeibiwatha xua Jesús pebarʉ xaenexatsi. Barichi Jesús barʉ eca pinmonae barapo pexaethopeibiwatha pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. Irʉrʉ Jesús barʉ eca ichamonae pomonae abe peexanae cuiru coyenein peexanaewi. Daxita barapomonae Jesús barʉ eca pexaethopeibiwatha yawa Jesús pijimonae barʉ ecano penabanaenexa. ");
INSERT INTO cui_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ichitha poxonae fariseomonae tane xua Jesús dacotsiwa barʉ eca, barapomonae namchi. Jesús pijimonae tatsi baraichi: —Maisa Jesús abe exana poxoru barʉ xayeca pomonae paratixi pentoma noteibiwi. Mataʉtano, barʉ xayeca pomonae abe peexanae cuiru coyene peexanaewi, jeichichi Jesús pijimonae tatsi barapo fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Poxonae Jesús baxua jume tane, bapon Jesús namchi barapomonaetha: —Pomonae ba xaniwaicha jinompa xua jopa ateneyo barapomonae ba jopa canantawenonaeyo pon jiwi peyawʉbin. Saya jame meisa pomonae ba atene barapomonae jame canantawenona pon jiwi peyawʉbin. Bara jʉta coyene ichi barapomonae pomonae nebarʉ xane. Barapomonae nenantawenona xua tayabara cui jʉntemainaenexa abe pia peexanae cuiru coyenein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Panacuidubaponde xua Nacom Pejume Diwesi paeba. Meje xua Nacom namchi, jeye: ‘Ichichipan xua jiwi nantanuweya peyabara nanta xeinaewa ichamonaetha xua peyawenaewa tsane. Baxua jame ichichipan beyacaincha xua ichichipan po cui coyene xua jiwi duwei petautsiwa xua tuxusi exana xan nexa’, jei Nacom. Barichinno xan patopan apara tha jopa tawabinexa tsane pomonae pejʉntʉ coyene xanepanaewi. Apara jame patopan tha meisa tawabinexa tsane pomonae peajʉntʉcoyenebe jiwi, xua barapomonae icha jʉntʉ coyene pexeinaenexa tsane peauraxae xua abe exana, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nexata Juan pon jiwi Pebautisabin, bapon pia pepuna jinompaewichi barapomonae pata Jesús pia xantha tatsi. Barapomonae Jesús yainyabatsi, jeye: —Apara paxan irʉ fariseomonaerʉ jopa juniya Nacom payabara nainboteibinyo poxonae Nacom pawʉqueiban. ¿Eta xua metha jinyamonae daxua jopa cou daichiyo, saya cou ʉ penabaneibi? jei barapomonae pomonae Juan pia pepuna jinompaewichi tatsi. ");
INSERT INTO cui_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús jume nota barapomonae: —Jiwi ba jopa bewa wecoyeya yabara nainbotsi poxonae ichamonae pexaewa tsinacaetuta penabanaenexa xua poxonae pebin pecotsiwa pita. Poxonae cataunxuae awiya bapon eca pexaewa penabanaewatha, bapoxonae jiwi ba pebʉrʉya nabane, jopa bewa yabara nainbotsi tsane. Ichitha icha pon aena piowa pita, caena nainya waetabatsi, ichamonae waetaba xua bapon tajʉ pecaponaenexatsi, bapoxonae jame jiwi ba bewa wecoyeya yabara nainbotsi xua equeicha bapon caewa pepatopaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Jiwi ba jopa exanaeyo xua pena paparuwa tsiwiyo jiwana caxinaxubeta po paparuwa cataunxuae jopa matanaxubiyo, xua barapo paparuwa pewan botsinexa peru dorouto. Icha baxua exanaetsipa xua pena paparuwatha wan bota peru doroutotha, bapoxonae barapo dorouto abe tsipae. Tsipei poxonae barapo dorouto matanaxuba barapo pena paparuwa natsaquetabiya. Poxonae barapo pena paparuwa natsaquetabiya equeicha wan tsitsipanarena barapo dorouto. Bapoxonae equeicha nama bichocono pin wan tsanaya beyacaincha xua poxonae copiya. ");
INSERT INTO cui_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mataʉtano jiwi ba pena vino mera jopa eparecaeyo peru bocototha, tsipei icha baxua exanaetsipa, barapo pena vino mera abe exanaetsipa barapo bocoto. Tsipei barapo bocoto jopa nayeyetaponaeyo poxonae barapo vino mera atsaxa. Barapo pena vino mera naxuba yawa barapo bocoto naxuba poxonae barapo bocoto tsitsica. Daxota bewa jame pena vino mera eparecae pena bocototha. Bapoxonae pena vino mera jopa naxubiyo, yawa pena bocoto jopa naxubiyo poxoru boco yeyena yawa poxoru pena bocoto”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Poxonae cataunxuae Jesús cueicueijei barapomonaetha, bapoxonae pebin patopa. Bapon judiomonae pia penacaetutsi bo pia pecanamataxeinaein tatsi. Bapon pewʉn Jairo. Jesús petaxutha irabe tatayecarecatsi. Bapon baxua exana tsipei Jesús pon ainya cui peexanaeinchi. Bapon namchi Jesustha: —Taxantiyo anoxuaetha inta tʉpa. Icha xam ponaename yawa necobetha mata jayabiname, bapoxonae barapowa equeicha asʉ tsane xua equeicha nacosatsina, jei Jairo. ");
INSERT INTO cui_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús bapoxonae nontapona. Jairo puna poinchi. Irʉ Jesús pijimonae puna poinchi. ");
INSERT INTO cui_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Poxonae Jesús iya irʉ yabʉyo Jesús imoxoyo caquita poinchi. Barapowa caena bayatha be yadoce po weiyobe jopa xua pentabʉ janatha boca xua be nantawane. Barapowa Jesús pia paparuwa xainyowa tajayabapoinyatsi. Bapowa paparuwa tajayaba xua peopirawa xua Jesús pia penamaxatatsiwa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","22","Baxua exana tsipei bapowa nanta xeina, jeye: “Icha pia paparuwa tajayabin bapoxonae axaibin tsane”, jei bapowa. Poxonae bapowa Jesús tajayabatsi pia paparuwa, bapoxonae caena jʉntʉbʉ jana naruntaba. Nexata Jesús napatomeicha necota, yawa yabʉyo tainchi. Jesús namchi bapowatha: —Yabʉyo, najʉntemiya xore. Caaxaibi exanatsi jinya tana neyabara jume cowʉntsixaem xua bara tana neitacʉpaewa xua tacaaxaibi exanaewatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús equeicha pona. Poxonae Jesús patopa pecanamataxeinaein pia bo tatsitha, bapoxonae Jesús tane xua pebiwi oba tsipei yabʉyo bayatha tʉpa. Barapo pebiwi pomonae pecapu obiwi pewerapeibiwi. Mataʉtano Jesús tane pomonae pesiwa namtsebiya wecoyei jiwi. ");
INSERT INTO cui_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús namchi jiwitha: —Tutu weya paponde. Yabʉyo apara jopa tʉpaeyo, maituncua apara, jei Jesús. Poxonae Jesús baxua paeba, jiwi Jesús jume cui caponatsi. ");
INSERT INTO cui_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ichitha Jesús itoroba xua barapomonae tutu wejojoniya pesato beya. Bapoxonae Jesús bo tutu joniya. Jesús cobe pita, yabʉyo cobe pitatsi yawano asiya cuaranotatsino penacosatsixae. ");
INSERT INTO cui_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Xua Jesús yabʉyo axaibi exanatsi, barapo diwesi daxita jiwi jume taetaepona pomonae barapo nacuatha jinompa. ");
INSERT INTO cui_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Poxonae Jesús bara weya pona ichaxota yabʉyo caewa asʉ exanatsi, pebinbe Jesús puna poinchi. Baponbe peitata nacʉtsinbe. Baponbe wawaya jeibe: —Xam Jesús, David pia pemomoxi susatopin jiwanam ponxaem Nacom necaitapetsin pana neyabara najʉntʉ coyene xeinarebe xua pata tana neyawenaenexamebe, jeibe baponbe ponbe peitata nacʉtsinbe. ");
INSERT INTO cui_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Poxonae Jesús bomʉxʉ bejoniya, ponbe peitata nacʉtsinbe Jesús imoxoyo caquita poinchibe. Jesús yainyaba baponbetha: —¿Bara pana neyabara jume cowʉntamebe xua bara tana neitacʉpaewa xua axaibi tapaca caexanaewatsibe? jei. Jume notabe: —Aja, pata Tanecanamataxeinaem, bara paca cui yabara jume cui cowʉntatsibe, jeibe. ");
INSERT INTO cui_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Bapoxonae Jesús itamaiquei jayababe baponbe. Jesús namchi baponbetha, jeye: —Icha pana necui yabara jume cowʉntamebe xua bara tana neitacʉpaewa xua axaibi tapaca exanaewatsibe bara baxua pacata exanaeinchibe xua axaibi paca exanaeinchibe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bapoxonae caena nainya aitamaiqueixaibibe. Jesús jume daunweya baraibe baponbe, jeye: —Jopa pana necui yopichindebe ichamonaetha xua pacata exainchibe baxua, jei Jesús baponbetha. ");
INSERT INTO cui_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Daichitha poxonae Jesús weya ponabe, pejume taewathabe xua Jesús paeba, tsipaebabe ichamonaetha pomonae barapo nacuatha jinompa, daxita pocotsiwa xua Jesús cana exana baponbetha. ");
INSERT INTO cui_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Poxonae Jesús bo wejoniya irʉrʉ ponbe aitamaiqueixaibi exanatsibe, bapoxonae ichamonae Jesustha pata. Barapomonae capona pebin, pon muxusipana, mataʉtano jopa paebiyo, tsipei cauri xeina. ");
INSERT INTO cui_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bapoxonae Jesús itaweta cauri xua barapo pebin muxusipana exainchi. Caena nainya bapon cueicueijei. Nexata pomonae xua tane xua Jesús exana, barapomonae yabara najʉntʉ coyene benaeca. Barapomonae namchi, jeye: —Jopa bapana taetsi Israel nacuatha icha be ichi pocotsiwa Jesús exana, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ichitha poxonae fariseomonae jume tane baxua, barapomonae namchi Jesús yabara, jeye: —Barapon caurimonae itawetatsi tsipei xeina caurimonae pia pentacaponaein tatsi pia peayapusʉ itorobi coyene tatsi, jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús pona daxita pin tomarantha yawa po tomaraxi tsiqui tomaraxitha. Bapon cuiduba ducuanaeta judiomonae pia penacaetutsi bontha tatsi. Mataʉtano bapon paeba ducuanaeta Nacom pia pexeinya jume diwesi tatsi po diwesi yabara xua Nacom waba jiwi petanaexanaenexatsi piamonae pomonae Nacom jʉntʉ coyene itorobiya ewata. Mataʉta bapon jiwi axaibi exana ducuanaeta pomonae xua atene yawa xua cuenecuenona. ");
INSERT INTO cui_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Poxonae Jesús jiwi tainchi, Jesús yabara nanta xeina barapomonae xua peyawenaewa tsane. Tsipei barapomonae natsepa mataʉtano jopa itacʉpaetsi xua pia coutha penayawenaewa. Barapomonae bara be jʉta coyeneya ichi, icha be ovejamonae ichi xua poxonae iratha bobena tsipei natsepa mataʉtano tsipei dapon aibi, pon pe-eenaein ovejamonae xua peyawenaenexa. ");
INSERT INTO cui_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Nexata Jesús namchi pijimonaetha: —Bara xainyeya paca tsipaebatsi. Pabitha ba pocotsiwa peʉbiwan naweta nawita, daichitha ba penacuichiwi pomonae jota pinmonae aibi. Bara jʉta ichi barapo cae pin nacuathe. Jiwi pinmonae jinompa pomonae nantawenona xua pejume taewa tsane Nacom pia pexeinya jume diwesi tatsi. Daichitha pomonae Nacom Pejume Diwesi cueicueijei tsurubenanaebiya ichamonaetha, barapomonae pinmonae aibi, saya tsiquimonaeyo. ");
INSERT INTO cui_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Daxota Nacom pawʉcare xua pecaitorobinexa tsane ichamonae xua petacamuxu tsipaebinexa tsainchi pia pejume diwesi pomonaetha pomonae barapo cae pin nacuathe pejinompaewi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nexata Jesús pijimonae waba. Barapomonae jiwana itapetatsi doce poyobe, pomonae baraichi: “Jesús pia peitorobi jiwi tatsi”, jeichichi. Jesús barapomonae cata pia peayapusʉ itorobi coyenewa xua cauri ichamonae petaitawetsinexatsi pomonae xua cauri xeina. Mataʉtano Jesús cata pia peayapusʉ itorobi coyenewa xua pijimonae tatsi axaibi peexanaenexa pomonae xua atene, xuano xua cuenecuenona. ");
INSERT INTO cui_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Barapomonae pomonae doce poyobe pomonae peitorobiwichi, ichʉn pewʉn Simón, pon icha wʉnno “Pedro” baraichi. Irʉ ichʉn pewʉn Andrés, pon Simón peweicho tatsi. Irʉ ichʉn pewʉn Santiago. Irʉ ichʉn pewʉn Juan, pon Santiago peweicho tatsi. Baponbe Zebedeo pexantobe tatsi. ");
INSERT INTO cui_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","4","Irʉ ichʉn pewʉn Felipe, irʉ ichʉn pewʉn Bartolomé, irʉ ichʉn pewʉn Tomás, irʉ ichʉn pewʉn Mateo. Barapon Mateo pon paratixi pentoma noteibin po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. Irʉ ichʉn pewʉn Santiago, pon Alfeo pexanto tatsi. Irʉ ichʉn pewʉn Tadeo. Irʉ ichʉn pewʉn Simón, pon celotemonaepin. Irʉ ichʉn pewʉn Judas Iscariote, pon Jesús caenaetaxubatsi ichamonaetha xua pebexubinexatsi. ");
INSERT INTO cui_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Barapo doce poyobe Jesús itoroba, Jesús jeye: —Jopa paponaeinde po nacua ichaxota jinompa pomonae jopa judiomonae naexanaeyo. Jopa paponaeinde po tomaran ena Samaria nacuatha. ");
INSERT INTO cui_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Meisa saya paponde pomonae Israel nacuamonaepiwitha. Barapomonae payawende tsipei barapomonae Nacom tajʉ wepu jinompatsi xua pipato jinompa. Icha be pocotsi jʉta coyeneya ichi oveja, barapo ovejamonae napuxana poxoru wepu pona tajʉ beya, xua pon pe-eenaein barapo ovejamonae bapon tajʉ wepu poinchi icha xua poxonae napuxana. ");
INSERT INTO cui_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Poxonae papaeba dubenanaebiyame, papaebare barapomonaetha po coyene xua anoxuae Nacom waba jiwi xua petanaexanaenexatsi piamonae pomonae itorobiya peewatsixae. ");
INSERT INTO cui_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mataʉtano Nacom pia peayapusʉ itorobi coyenewatha po coyenewe meje baxua paexande: Axaibi paexande pomonae peatenewi; equeicha asʉ paexande pomonae werapeibina; axaibi paexande pomonae xua peperʉ sawichimonae; mataʉtano caurimonae pata taitawere pomonae caurimonae pexeinaewi. Nacom amanaya paca cata barapo pia peayapusʉ itorobi coyene, daxota poxonae jiwi payawename Nacom pia peayapusʉwatha, jopa jiwi paratixi pawʉcaeinde. ");
INSERT INTO cui_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Jopa pacaponaeinde paratixi xua poxonae painya newarapaenexa. ");
INSERT INTO cui_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jopa pacaponaeinde cote xua painya nejeyaenexa paparuwan poxonae pawarapame. Saya cae camisa panama xatabare, jopa icha camisa pacaponaeinde. Mataʉta jopa pacaponaeinde ichawan xua painya nenataxu xatabiwan, yawa icha iwaton jopa pacaponaeinde. Painya xoba paauram xua poxonae jiwi paca catsibeibina tsipei baraxua pocotsiwa paca cata apara bara painya matoma painya netanacuichixaemxae Nacom. ");
INSERT INTO cui_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Poxonae papanenebiyam pin tomaratha, ichacuitha tsiqui tomariyotha, pajeire pon jiwi barʉ cui itura jina xuano xua paca tsiwaba pia botha tatsi pia paca apatsinexa tsane. Bapon pia botha tatsi painya nepu enaeinde beya tsane poxonae barapo tomara weya pawarapaename. ");
INSERT INTO cui_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Poxonae bomʉxʉtha pajojoniyame, barapo bopiwi pajacobare, pajande: ‘Barabʉ Nacom jʉntema jinompa paca cana exanaena’, pajande. ");
INSERT INTO cui_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Icha baxota jinompa pomonae pomonaetha jiwi barʉ cui itura jina, bara baxua Nacom barapomonae taexanaeinchi pocotsiwa papaebame. Ichitha icha baxota jinompa pomonae pomonaetha jopa jiwi barʉ cui itura jinaeyo, baxua Nacom jopa taexanae tsane pocotsiwa papaebame barapomonaetha. Equeicha caewa pacata parenaena xua pocotsiwa papaebame. ");
INSERT INTO cui_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ichitha icha icha tomarapiwi jopa paca matenta weyataeya wabiyo yawano icha jopa xapain paca jume naitaewatsiyo, nexata bapoxonae panatsixibare. Namto beya paponde xua bomʉxʉ weya xua ichacuitha icha tomara weya. Po tsorobo painya taxutha dubena pana nataxu wenʉnʉbabare barapo tomaratha. Poxonae baxua paexaname patsita itapeinya xeinaename, apara xua barapomonae abe exana painya xainya berena xua poxonae barapomonae paca jume itaweta. ");
INSERT INTO cui_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Bara xainyeya paca tsipaebatsi matacabi patopaena, po matacabitha Nacom yabara paebina jiwi petsita natsicuentsixaetsi xua abe petsita exanaexaetsi. Barapo matacabitha jopa juniya bichocono atene tsane pomonae paca jume itaweta. Caena bayatha Sodoma tomarapiwi irʉ Gomorra tomarapiwi bichocono abe exana. Daxota Nacom atene exanaena barapo tomaramonaebe. Bara bequein Sodoma tomarapiwi atene mataʉta irʉ Gomorra tomarapiwi bequein atene tsipei bichocono abe exana barapomonae. Ichitha nama pomonae barapo tomaratha jinompa, pomonae paca jume itaweta, jopa juniya peraxa jʉbebi tsainchi, beyacaincha poxonae Sodoma tomarapiwi yawa Gomorra tomarapiwi peraxa jʉbebatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Equeicha Jesús jeye: “Paponde ichaxota paca itorobatsi. Paca caitorobatsi pia xainya beya pomonae jopa pejume cowʉntsiwi, pomonae itacʉpatsi xua abe painya nepaca exanaewa, icha ovejan ichi xua poxonae pona ichaxota neʉthʉ jinompa xua itacʉpatsi xua abe peexanaewatsi. Paxam pananthʉthʉ cui wʉnaetsiya tsaquiya jinompare, tsipei ichamonae beya paca pepeichipa. Baxua bara paichinde icha jomo ichi xua peita coxonaein poxonae waxouto cuitaya naetsiriwatsi. Paxam bara jʉtiya jopa paichim tsane jopa ichamonaetha abe paexanaeinde, icha topiboto ichi xua anaepana jopa nanta xeinecaeyo xua jʉntema yapoponeca. ");
INSERT INTO cui_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Paxam dota pam, dota pomonae peajʉntʉcoyenebe jiwi. Barapomonae paca teicaena pepaca caponaenexa tsane pomonaetha pomonae tomaran pentacaponaewi. Bapoxonae barapomonae paca cuainchina judiomonae pia penacaetutsi bontha tatsi. ");
INSERT INTO cui_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mataʉta barapomonae paca caponaena pomonae peyanacua ewatsi jiwi peitabaratha tatsi. Mataʉta paca caponaena pomonae jiwi itorobiya pia pepa peewatsiwichi pia peitabaratha tatsi. Baxua paca cana exanaena painya tana nejume cowʉntsixaemxae. Daichitha barapo pentacaponaewi peitabaratha tatsi paca itacʉpaena xua pata neyabara paebiwan pocotsiwa bayatha tapacata exanaewatsi paxam. Mataʉtano paca itacʉpaena xua pata neyabara paebiwan pomonae jopa judiomonae naexanaeyo peitabaratha tatsi. ");
INSERT INTO cui_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ichitha poxonae paca caponaena pentacaponaewi beya, jopa payabara najʉntʉ coyene exabinde pocotsiwa xua painya nejume notsiwa tsane barapomonaetha. Nama Nacom paca tsijume dubina po jume xua painya necaunutsiwam tsane. ");
INSERT INTO cui_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tsipei beta jopa papaebimchipae painya coutha, ichitha Nacom pia Pejumope tʉnaxʉ tatsi paca tsimuxu cueicueijei tsane. Bapon paca catsina po jumetha xua patsipaebiname. ");
INSERT INTO cui_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Jiwi caenaetsina barompaya peweicho jiwi ichamonaetha xua ichamonae pejutebinexa tsane. Irʉ coxiyeiwi ichamonaetha caenaetsina pia pexui xua ichamonae pejutebinexa tsane. Irʉ pexui paxeiwi caenaetsina ichamonaetha xua ichamonae pejutebinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Daxita nacuanpiwi paca casebina painya tana nejume cowʉntsixaemxae. Ichitha icha awiya paantʉyapusʉya nejume cowʉntsiya jinompaename xua beya payacuiya werapaeya othopaename, poxonae bequein abe pacata exana ichamonae Nacom napaeba paca cana exanaena. ");
INSERT INTO cui_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Icha cae tomarapiwi paca abe exanaena, parʉcʉpare icha tomara beya. Bara xainyeya paca tsipaebatsi xua xan ponxaein Nacom Tananeitapetsin, equeicha patopeicaein beya abʉ poxonae cataunxuae jopa panacui wetsim tsane xua paponame daxita israelmonae pia nacua tomarantha tatsi, xua papaeba dubenanaebiyame Nacom Pejume Diwesi. ");
INSERT INTO cui_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Pon ba aena nacuiduba xua peyaputaenexa, bapon jopa be bapocotsinyo, pon pecuidubin jiwi, pon peyaputaein. Mataʉta pon ba petanacuichin jopa ainya cuiyo, jopa be bapocotsinyo pon xua peitorobixaetsi pon pia pecanamataxeinaeinchi tatsi. ");
INSERT INTO cui_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pon ba penacuidubin bewa nanta xeinae, bewa najei: ‘Maisa ichamonae inta abe exanatsi pon tana necuidubin. Metha bara neichi tsane’, bewa najei. Irʉ pon ba tanacuita pia pecanamataxeinaeinchi bewa najei: ‘Maisa ichamonae inta abe exanatsi pon tanecanamataxeinaein. Metha bara neichi tsane’, bewa najei. Icha pocotsi coyeneya baponbe ichi poxonae baxua nayabara nanta xeinabe, bara pocotsi coyeneya paca cana ichiya exana jiwi icha poxonae neyabara ichiya namchi. Tsipei jiwi abe neyabara paeba xua jeye: ‘Maisa bapon Beelzebú tsecae pon caurimonae pia pentacaponaein tatsi’, jei. Mataʉta paca yabara jei tsane: ‘Maisa barapomonae Beelzebú pijimonae tatsi po Beelzebú caurimonae pia pentacaponaein tatsi’, paca yabara jei tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Equeicha Jesús jeye: “Jopa jiwi pacunuwinde xua tapana neyabara paebiwam. Tsipei daxita diwesin, xua po diwesin bequein anoxuae jiwi jopa yaputaeyo, bexa yaputaena. Pocotsiwa jiwi abe nameicha exana daichitha ichamonae bexa yaputaeponaena baxua. ");
INSERT INTO cui_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tsipei daxita baxua xua nameicha paca tsipaebatsi, baxua xuya patsipaebare jiwi. Po diwesi xua merawi paca tsipaebatsi, barapo diwesi xuya ichamonae mataqueitha patsipaebare. Po diwesi xua paxapaxeya paca tsipaebatsi, barapo diwesi xuya panatha pana nejume canawabiya wawande. ");
INSERT INTO cui_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tamonae pam, paca tsipaebatsi, jopa pacunuwinde pomonae itacʉpatsi xua paca jutebina xua saya meisa painya pepontha. Ichitha barapomonae jopa itacʉpaetsi xua equeicha paca jumopein tʉnaxʉ jutebina. Jame paca tsipaebatsi pon jame bewa pajume cuitaya cunuwim bapon apara jame Nacom. Tsipei barapon Nacom itacʉpatsi xua paca bebai pin isototha po pin isototha jopa bapana itacounayiyo xua weraweraca painya nepaca exanaenexa painya pepon yawa painya nejumope tʉnaxʉn. ");
INSERT INTO cui_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Jiwi ba caenaeta sito dos poyobe, saya cae paratiyotha nantomata. Bequein barapo sitobe caenaeta jiwi xua jopa matoma nautsiyo, poxoru saya sito, ichitha painya Axa Nacom yaputane yawa copata poxonae barapo sitobe jiwana iratha yajopeica xua yatʉpa. ");
INSERT INTO cui_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nacom daxita carepaya jopa juniya paca yabara yaputaeyo, daxota paca matana yaputane xua pontanatiyobe painya nexeinaewa. ");
INSERT INTO cui_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jopa pajunuwinde tsipei paxam bichocono Nacom patsita ainya cuim, beyacaincha siri”, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Equeicha Jesús namchi: “Yabara paca tsipaebatsi pomonae xua nayopita ichamonaetha pomonae xua najei: ‘Apara paxan Jesús pijimonae tatsi pan’, najei. Barichi xan xuya jan tsane Nacomtha: ‘Barapomonae apara tana nejume cowʉntsiwi’, jan tsane xuya barapo Nacom peitabaratha pon Taxa, pon peitabocotha peecaexae. ");
INSERT INTO cui_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ichitha pomonae xua neyabara jei ichamonaetha: ‘Jopa bapon yaitaeinyo’, jei, xan xuya barapomonae yabara jan tsane: ‘Apara barapomonae jopa yaitaeinyo’, jan tsane xuya Taxa beicha, pon peitabocotha peecaexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Equeicha Jesús namchi: “Jopa pananta xeinaeinde xua patopeican saya meisa xua jiwi jʉntema jinompa tacana exanaewa tsane. Jopa baxua tsipatopaeinyo. Apara jame tsipatopeican taexanaenexa po coyene jiwi naba exanatsi xua daxota ainya bicheiton penaexanaenexa. Pomonae jopa nejume cowʉntsiyo ita aenae-aenei pomonaetha pomonae tana nejume cowʉntsiwi. ");
INSERT INTO cui_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Coxiyan pexanto ita aenae-aenei tsainchi. Irʉ coxiwa pexantiyo ita aenae-aenei tsainchi. Irʉrʉ ichowayo pecopeinyo ita aenae-aenei tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Daxota pebin barompaya piamonae penaaitafaetabi jiwi nacana exanatsi. ");
INSERT INTO cui_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Pon antobe paxa yawa pena beyacaincha xua neantobe bapon jopa naexanae tsane pon tajiwimonae jiwanapin. Pon antobe pexanto beyacaincha xua neantobe, bapon jopa naexanae tsane pon tajiwimonae jiwanapin. Yawa pon antobe pexantiyo beyacaincha xua neantobe bapon jopa naexanae tsane pon tajiwimonae jiwanapin. ");
INSERT INTO cui_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mataʉtano pon jopa awiya exana ducuanaebiyaeyo pocotsiwa itoroban, tsipei jopa be peraxa exanaetsi icha be xua poxonae neichi nexata bapon jopa tajiwimonaepinyo. ");
INSERT INTO cui_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pon naantobeya nata exana pocotsiwa bapon ichichipa bapon jopa xeinaeyo peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. Ichitha pon neantobeya inta exana pocotsiwa ichichipan taneantobexae bapon xeinaena peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Equeicha Jesús namchi: “Pon xua paca matenta weyatane pia tana neyabara jume taenexa tsane pocotsiwa papaebiname, barapara bapon yawa neweyatanerʉ. Barapon pon xua neweyatane, barapara mataʉtano weyataenarʉ xua weyatainchi pon xua tana neitorobixae, bapon Nacom. ");
INSERT INTO cui_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pon cueicueijei Nacom pia peitorobi jume diwesi, Nacom bapontha catsina pia peyabara cui matomatsiwa tsipei barapon pon barapo peitorobi jume pepaebin Nacom tanacuitatsi. Po peyabara cui matomatsiwa catatsi pon Nacom peitorobi jume pepaebin Nacom barichi tsane jʉpa catsina pontha pon matenta weyatane, xua matenta weyatainchi pon Nacom pia peitorobi jume pepaebin. Mataʉta irʉ pon xua pejʉntʉ coyene xeicaein bapontha Nacom catsina peyabara cui matomatsiwa tsipei bapon xanepanaya popona Nacom nexa. Nacom barichi tsane jʉpa catsina pontha pon matenta weyatane xua matenta weyatainchi pon pejʉntʉ coyene xeicaein. ");
INSERT INTO cui_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pon xua apatsina tajiwimonae jiwana pintha bequein jopa matowa apatsiyo mera xua bequein cae corotiyo xua ameneque, daichitha Nacom bapontha catsina pia peyabara cui matomatsiwa tsipei bapon tajiwimonae jiwanapin yawenatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús najume weta xua pijimonae muxuwetsiya cuiduba, po jiwimonae tatsi xua doce poyobe tatsi. Bapoxonae Jesús bara weya natsixitaba xua tomarantha peponaenexa po tomaran ena barapo nacuatha xua jiwitha pecuidubinexa Nacom pia pexeinya jume diwesi tatsi. ");
INSERT INTO cui_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan pon jiwi Pebautisabin, bapon jiwi pecʉbi botha etatsi. Poxonae cataunxuae jiwi pecʉbi botha eca, bapon jume tane xua juinya Cristo exana. Bapoxonae Juan itorobabe Jesús beya ponbe pia pepuna jinompaewichi jiwanabe tatsibe xua petayainyabinexatsibe Jesús beya. ");
INSERT INTO cui_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Barapomonae Jesús yainyabatsi xua Juan najume caruta, xua jei: —¿Metha bara xaniwaicha xam baponda, pon bewa patopaena pon Mesías? ¿Ichacuitha metha bara ichʉn pawʉnae ewatan jampa? jei baraponbe xua Juan najume caruta. ");
INSERT INTO cui_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus jume nota baraponbe, jeye: “Papondebe, mataʉta Juan patsipaebarebe xuaunxuae pocotsiwa pana necui tanemebe, mataʉtano xuaunxuae pocotsiwa pana nejume tanemebeno. ");
INSERT INTO cui_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mataʉtano patsipaebarebe xua pomonae peitata nacʉtsi jiwi equeicha tane, mataʉta xua pomonae pejayujayujeiwi beta pona equeicha, mataʉtano xua pomonae peperʉ sawichimonae equeicha perʉ wʉnae, mataʉta pomonae xua pemuxusipanaewi equeicha muxu nasaba, mataʉta pomonae xua pewerapaewi equeicha asʉ tsane. Mataʉta pomonae xua peacopeibi jiwi jume tane Nacom pia pexeinya pecapanenebiyae diwesi jume. ");
INSERT INTO cui_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Patsipaebarebe Juan xua xan janje: ‘Jʉntʉ coyene weiweinaena pon jopa ainya ʉnthʉthʉnyo, pon xaniwaicha neyabara jume cowʉnta’, xua jan”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Poxonae Juan pia penacana jume caitorobinbe tatsi ponatababe, bapoxonae Jesús tamropata pitaba xua yabara paeba jiwitha xua Juan yabara paebatsi, jeye: “Ira xuepana susato tsurucuae nacuatha paponame. Poxonae bara beya poponame, ¿eta xua painyatsi, painya jume taetsi pebin pon ainya ʉnthʉthʉto cui xeina icha be naepanaewa ichi xua saya joibo ba jʉbabiya caya tsaibi? Jume apara. ");
INSERT INTO cui_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bara paichim. Paponame ¿painya nejumetaenexa pebin pon peitʉpanae paparuwa nama xatata? Jume apara. Payaputaneme pomonae peitʉpanae paparuwan nama xataba, barapomonae ba jinompa pexeinya bontha pomonae jiwi itorobiya pia pepa peewatsiwixaetsi. ");
INSERT INTO cui_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Jume. Jopa baxua patsiponaem xua jopa painya jume taenexa pebin pon ainya ʉnthʉthʉto cui xeina, mataʉtano xua jopa painya jume taenexa pebin pon peitʉpanae paparuwa nama xatata. Apara jame baxua patsiponame xua painya nejume taenexa pon Nacom peitorobi jume pepaebin. Bapon Juan bichocono peainya cuin pon Nacom pia peitorobi jume pepaebiwi jiwanapin beyacaincha ichʉn pon Nacom peitorobi jume pepaebin. ");
INSERT INTO cui_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan bapon apara, pon yabara paebatsi Nacom Pejume Diwesitha poxonae Nacom netsipaeba, nejei: ‘Catsiwanae itorobinchi copiya pon tana nacajume carutsin. Barapon jʉntʉ cui wʉnaetsina jiwi xua daxita jiwi najʉntʉ cui wʉnaetsina xam nexa, xua necantenta weyataeya wabinexa poxonae patopaename’, nejei Nacom Pejume Diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Bara xaniyeya paca tsipaebatsi xua daxita Nacom peitorobi jume pepaebiwi pomonae Juan tsiwanaya jinompatsi bayatha, dapocotsin aibi barapomonae jiwana pon yatsicaewa peainya cuin beyacaincha pon Juan, pon jiwi Pebautisabin. Juan peainya cui diwesi yabara cueicueijei po coyene xua Nacom itorobina jiwi. Ichitha po diwesi xua tamonae anoxuae paeba barapo diwesi bichocono ainya cui diwesi beyacaincha xua Juan cueicueijei, bequein jiwi nanta xeina xua tamonae jopa ainya cui jiwi. ");
INSERT INTO cui_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan pon jiwi Pebautisabin, poxonae bapon tamropata pitaba xua cueicueijei Nacom Pejume Diwesi xua beya anoxuae pin bicheitomonae nejume cowʉnta pia penaexanaenexa Nacom piamonae tatsi. Barapomonae pichichi xua penaexanaewa Nacom piamonae tatsi pomonae Nacom itorobiya peewatsixae bequein ichamonae ayapube taexana barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Daxita po petinae diwesin Nacom peitorobi jume pepaebiwi tina irʉrʉ Moisés pia peitorobi coyenewa tatsi barapo naxobe peitorobi coyenewathabe yabara tsiwʉnae muxu dutsiya paeba. Barapo peitorobi coyenewabe yabara paeba xua bexa tsane jopaena matacabi po mataqueitha xua Nacom jʉntʉ coyene itorobiya canamataxeinaena jiwi. Matapainya Juan patopa. Bapoxonae irʉ Nacom tamropata pitaba xua exana pocotsiwa bayatha yabara tsiwʉnae muxu duta. ");
INSERT INTO cui_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Icha paxam xaniwaicha paichichipame xua payabara jume cowʉntame xua pocotsiwa barapomonae bayatha yabara paeba, bapoxonae bara panejume cowʉntsiname xua paeban, xua jan: ‘Apara Juan bapon Elías pon caena bayatha tʉpa. Barapon apara pon Nacom peitorobi jume pepaebin, pon bayatha Nacom yabara paeba xua bepa pinae equeicha patopaena’, jan. ");
INSERT INTO cui_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Icha pamuxu dubename moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi. ");
INSERT INTO cui_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Eta pocotsimonae cui jʉpatsi barapomonae pomonae xote jinompe pomonae Nacom jume itawetatsi? ¿Etabe jʉta ichi barapomonae? Barapomonae be pexui, pocotsixi panatha nabarʉ jinompa. Nabarʉ wawai tsurubenanaebiya. ");
INSERT INTO cui_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Barapoxi nabarai, jeye: ‘Bayatha oibo paca tsimuxu obatsiba ichitha jopa panawirabim. Bayatha paca tsimuxu wecoyeichiba icha be ichi poxonae ichʉn tatʉpatsi ichitha jopa pana itanuwe jume notsim xua painya newecoyeinexarʉ’, jei barapoxi. ");
INSERT INTO cui_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan patopa pon jiwi Pebautisabin. Bapon jopa xaeyo pan, yawa jopa apaeyo vino mera. Ichitha paxam pajam: ‘Apara Juan xeina cauri’, pajam. ");
INSERT INTO cui_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bapoxonae xan ponxaein Nacom Tananeitapetsin patopan. Xan pan taxaein yawa vino mera taapaein. Paxam pana neyabara paebame pajam: ‘Bapon maisa jopa juniya nabanaeyo, yawa jopa juniya apaeyo. Peatsacaewi abe peexanae jiwi pia jiton tatsi, irʉ pomonae paratixi pentoma noteibiwi, barapomonae pia jiton tatsi’, pana neyabara jam. Nacom piamonae tatsi barapomonae tsita exana xua jiwi tsita exanatsi Nacom pia peyaputae coyeneintha tatsi. Po coyene barapomonae exana, baxua Nacom tsita pexainyei coyenetsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nexata Jesús tamropata pitaba xua biatane ainya tomaranpiwi, ichaxota bayatha copiya matha matowa exana pia petsita itʉtsi coyenewan. Bequein Jesús baxua matowa exana, ichitha barapomonae jopa icha jʉntʉ coyene xeinaeyo xua peauraxae xua abe exana. ");
INSERT INTO cui_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Daxota barapo tomaranpiwi beya, jeye: “¡Pai jaibo, Corazín tomarapiwi tsobenae! ¡Irʉ Betsaida tomarapiwi tsobenae! Po tsita itʉtsi coyenewan exanan Corazín tomaratha irʉ Betsaida tomarathano, ichʉn jopa bapana exanaeyo barapo tsita itʉtsi coyenewan Tiro tomaratha yawa Sidón tomaratha. Icha barapo tsita itʉtsi coyenewan exanaetsipa Tiro tomaratha Sidón tomarathano, barapo tomarabepiwi icha penanta xeinae coyenewatha yabara nanta pentsipa Nacomtha. Barapomonae iratha enaetsipa yawa paparuwan nama xatabichipa xua pocotsiwa be peru mapaton xua axʉn, yawa ipuna nacaxuebichipa pia pepontha. Barapomonae baxua exanaetsipa xua ichamonae petsita itapeinya xeinaewa tsainchi xua icha jʉntʉ coyenein Nacom petsita xeinaewatsi peauraxae abe peexanaexae bapontha. ");
INSERT INTO cui_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Paxam pomonae Corazín tomarapiwi pam irʉ Betsaida tomarapiwi pam, bara xaniyeya paca tsipaebatsi. Poxonae barapo matacabi patopeicaena po mataqueitha Nacom yabara paebina daxita jiwi petsita natsicuentsixaetsi abe petsita exanaexaetsi, Tiro tomarapiwi irʉ Sidón tomarapiwi daxita barapo tomarabepiwi bichocono peraxa jʉbebinchi. Ichitha nama paxam pomonae Corazín tomarapiwi pam, irʉrʉ Betsaida tomarapiwi pamdʉ, daxita paxam jopa juniya paca peraxa jʉbebi tsane, beyacaincha xua peraxa jʉbebinchi Tiro tomarapiwi irʉ Sidón tomarapiwi. ");
INSERT INTO cui_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¡Incane irʉ Capernaum tomarapiwi pamdʉ! ¿Bara pana nanta xeiname xua paca capanenebiya tsane peitaboco beicha? Jume, apara paca itorobina petʉpae coyene cuiru bereca. Po petsita itʉtsi coyenewan painya tomaratha exanan icha bayatha barapo petsita itʉtsi coyenewan exanaetsipa Sodoma tomaratha, bara cataunxuae barapo tomara ecaetsipa, xua beya anoxuae tsipae. Tsipei barapomonae metha bayatha xeinaetsipa icha jʉntʉ coyene xua peauraxae xua abe exana Nacomtha. Metha bapoxonae Nacom jopa jutebichipae barapo tomarapiwi. ");
INSERT INTO cui_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ichitha paca tsipaebatsi paxam Capernaum tomarapiwi pam, matacabi patopeicaena po mataqueitha Nacom yabara paebina daxita jiwi petsita natsicuentsixaetsi abe petsita exanaexaetsi. Barapo mataqueitha bichocono paca peraxa jʉbebina, beyacaincha xua Sodoma tomarapiwi peraxa jʉbebinchi bichocono”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Bara caena bapoxonae Jesús jʉntʉ coyene weiweina exanatsi Nacom pia Pejumope tʉnaxʉ tatsi. Jesús namchi, jeye: “Axa peitaboco Necanamataxeinaem, yawa ira Necanamataxeinaem. Wʉnae cajaintatsi tsipei jopa tsita itʉbim pocotsiwa pexainyei coyenewa xan yabara pomonaetha pomonae bichocono penacuidubiwi pomonae be pinyon penatsicotaewi tsipei nanta xeina xua bichocono peyaputaewi daxita. Jame tsita itʉtame barapo pexainyei coyenewa xua xan yabara pomonaetha pomonae jopa bichocono penacuidubiwi, pomonae be pexui penatsicotaewi tsipei jopa nanta xeinaeyo xua bichocono peyaputae jiwi daxita. ");
INSERT INTO cui_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Axa, baxua exaname necatsita xanepanaexae baxua”, jei Jesús Paxatha. ");
INSERT INTO cui_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Equeicha Jesús namchi pijimonaetha, jeye: “Taxa daxita necata xua pia peitorobi coyenewa tatsi, mataʉtano xua pia peyaputae coyenewa tatsi. Dapon aibi pon xaniwaicha nejʉntʉ cui coyene yaputane. Jame saya meisa Taxa Nacom, nejʉntʉ cui coyene yaputane. Dapon aibi pon Taxa jʉntʉ cui coyene yaputainchi. Saya jame meisa Taxaxae jʉntʉ cui coyene yaputan. Mataʉtano barichi Taxa meisa jʉntʉ coyene yaputainchi pon saya bara copatan xua bara Taxa pejʉntʉ cui coyene yaputaewa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Anetha xan berena daxita paxam xua tapaca yawenaewa tsainchi. Daxita paxam xua pocotsiwa paca jʉntʉ coyene natsepa exana painya abe neexanae cuiru coyene baxua paca jʉntʉ cui coyene canapuxanaeya yabara jʉntemainaeinchi xua painya nenafifinacaewatsinexa. Equeicha pena jʉntʉ coyene paca cana exanaeinchi, xua painya nejʉntʉ coyene weiweinaeya jinompaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pana necui coyene xeinare tacuidubi coyene painya nenacuidubinexam tsane yawa painya neyawenaenexa tsane xua painya necuidubiwa tsane ichamonae. Baxuan paexande tsipei xan jopa bapana jʉntʉ cui coyene anaepanaeya tacuidubin jiwi. Mataʉta bapana jopa tajʉntʉ cui coyene atsacaein. Mataʉtano jopa pajʉntʉ coyene deideijeya jinompaem tsane. Saya jame xanepanaeya painompaename tsipei paexanaename tacuidubi cui coyenein. ");
INSERT INTO cui_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Barapo tacuidubi cui coyenewan jopa ayapubeyo painya jʉntʉ cui coyenetha. Bara paca itacʉpa xua painya neexanaewa tsane barapo tacuidubi cui coyenewan”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Caentacabi poxonae judiomonae barompaya pia pentaquei seicae matacabitha tatsi barapo mataqueitha Jesús irʉ pijimonae tatsino pabi iyiya. Jesús pijimonae tatsi jainpa. Barapomonae tamropata notarʉcʉpa xua yaboto xunumenapona trigo xu, bapoxonae pecobetha xu mata pepeta yawa xu xane. ");
INSERT INTO cui_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Poxonae fariseomonae cui tane xua Jesús pijimonae tatsi exana, bapoxonae barapomonae Jesús tsipaebatsi, jeye: —Jamaisa jinya jiwimonae nacuita barapo matacabithe poxonae yaboto nota trigo xu. Apara jiwi jopa yabara copatichi xua penacuichiwa po mataqueithe xua judiomonae barompaya pia pentaquei seicae matacabi tatsi, jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús jume nota, jeye: —Barapo tajiwimonae jopa apara abe exanaeyo. Jopa payabara yorobim pocotsiwa bayatha David exana poxonae jainpa, poxonae irʉ pijimonae tajainpatsirʉ. Bapon David, pon caena bayatha israelmonae itorobiya pia pepa Peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Bapon David irʉ pijimonae tatsi barapomonae Nacom pin pia botha tatsi jojoniya. David xane pan, po pan ichamonae cana exana xua Nacomtha pecatsiwatsi. Irʉ barapo pan David pijimonae cata xua pexaenexarʉ. Barapomonae xane bequein bara Nacom pia peitorobi coyenewatha copata xua saya meisa sacerdotemonae itacʉpatsi xua pexaewa tsane barapo pan. ");
INSERT INTO cui_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Mataʉtano bequein payabara yorobame Moisés pia peitorobi coyenewatha ichaxota jei: ‘Sacerdotemonaepiwi nacuita judiomonae barompaya pia pentaquei seicae matacabitha tatsi poxonae Nacom pin pia botha tatsi duwei tauta xua petuxusi exanaenexa Nacom nexa’, jei. Apara barapo coyene jopa peabe coyenewiyo. Jiwi bara copata. Jopa cui matawentsiyo bequein bara barapo judiomonae barompaya pia pentaquei seicae matacabitha tatsi exana taetha. ");
INSERT INTO cui_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ichitha paca tsipaebatsi xua nama taayapusʉ itorobi coyenewa ainya cui beyacaincha Moisés pia peitorobi coyenewan tatsi, xuano beyacaincha barapo coyene po coyene poxonae Nacom pin pia botha exana. ");
INSERT INTO cui_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Paxam jopa xanepanaeya payaputaem xua Nacom jei pejume diwesitha: ‘Ichichipan xua painya nexeinaewa tsane nantanuweya peyabara nanta xeinae ʉnthʉto xua ichamonae painya neyawenaewa tsane. Baxua jame bichocono ichichipan beyacaincha xua duwei petautsiwa xua petuxusi exanaewa xan nexa’, jei Nacom Pejume Diwesitha. Icha bayatha payaputaetsipame pocotsiwa Nacom Pejume Diwesitha paeba, bapoxonae barapo tamonae jopa abe payabara paebimchipae pomonae bequein bara jopa abe exanaeyo. ");
INSERT INTO cui_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Xan ponxaein Nacom Tananeitapetsixae taitorobi coyene xeinan xua jiwi tacoya taitorobiwa pentaquei seicae matacabitha, jei Jesús, fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Poxonae Jesús najume weta xua fariseomonae tsipaebatsi, bapoxonae Jesús bara weya natsixitabiya ponataba trigo pabi weya. Bapoxonae pona judiomonae pia penacaetutsi bo tatsi beya, bapoxonaeno joniya barapo botha. ");
INSERT INTO cui_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Barapo botha pebin eca pon pecobe mʉbinchi. Baxotarʉ fariseomonae ena. Barapo fariseomonae ichipa piraichi Jesús yainyabatsi xua icha Jesús jume notsina icha jumetha xua bapoxonae Jesús pecui yabara paebinexatsi jiwitha xua Jesús abe exana. Barapo fariseomonae Jesús jeichichi: —¿Bara Moisés pia peitorobi coyene jumewatha yabara copata jampa xua pon atene bara axaibi peexanaewatsi pentaquei seicae mataqueitha jampa? jei. ");
INSERT INTO cui_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús jume nota, jeye: —¿Jintam metha pon paxam jiwana, pon xeina cae oveja, xua poxonae jopa jutsipae icha barapo oveja mʉthʉtha tajoparecatsi? Apara bara awiya jutsipa pia ovejaxae bara bequein pentaquei seicae matacabi taetha. ");
INSERT INTO cui_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nama apara bichocono jiwi yabara Nacom tsita ainya cuichi beyacaincha xua oveja yabara Nacom tsita ainya cuichi. Daxota Nacom copata xua bara jiwi pexanepanae coyene exaneibina, bara bequein xua poxonae pentaquei seicae matacabintha taetha, jei Jesús fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nexata Jesús barai pontha pon pecobe mʉbinchi jeye: —Nacobe doire, jei. Poxonae bapon nacobe doita, bapoxonae nainya cobe wʉnae tsanaya icha icha cobe ichi. ");
INSERT INTO cui_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bapoxonae fariseomonae Jesús weya ponarʉcʉpa xua Jesús pecui yabara paebinexatsi xua po cui coyenewatha Jesús pebexubiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Poxonae Jesús yaputane xua yabara cui paebatsi xua abe exana mataʉtano xua bexubapaebatsi, bapoxonae Jesús bara weya ponataba. Mataʉtano Jesús pinmonaeno puna poinchi. Jesús axaibi exana ducuanaebiya daxita pomonae peatenewi. ");
INSERT INTO cui_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mataʉta Jesús barapomonaetha itoroba, jei: “Jopa baxua ichamonaetha pana necui yopichinde xua jiwi axaibi taexanaewa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesús itoroba pomonae xua axaibi peexanaexae xua jopa peyabara cueicueijeinexa tsainchi ichamonaetha. Baxua exana xua penayabara jume cui wetsinexa xua Isaías pejume diwesitha bayatha yabara tsiwʉnaeya tina Nacom nexa pon Nacom peitorobi jume pepaebin. Nacom jeye, Jesús yabara: ");
INSERT INTO cui_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bapon apara pon inta nacuita, pon itapetan, pon bichocono antobein yawa xua nejʉntʉ coyene weiweina exana pon. Taitorobicaein tajumope tʉnaxʉ xua bapon peyantsiwa tsainchi. Bapon daxita nacuanpiwitha capona exanaena tapexeinya jume diwesi pomonaetha pomonae jopa judiomonae naexanaeyo. Barapon barapo pexeinya jume diwesi caponaena, xua pejume cowʉntsinexa tsane pomonae poxonae jume taibina barapo pexeinya jume diwesi xua bapoxonae barapomonae tayabara jʉntemainaenexa abe pia peexanae cuiru coyenein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mataʉta bapon jopa jume matsontsonobeibi tsane. Bapon jopa namtsebiya wawai tsaibi tsane namtotha xua jiwi bapon pejume taenexa tsaibi tsainchi, xua bapon pejume naitaewatsinexa tsaibi tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pomonae jopa peajʉntʉcoyenesʉwi xua tana nejume cowʉntsiwa, bapon jopa bebai tsaibi tsane. Barapomonae capanenebiya tsainchi. Mataʉtano pijimonae tatsi poxonae jʉntʉ coyene faefaenena, jopa anaya jutebi tsane. Bara bapon yawenaena barapomonae. Bapon baxua exanaena xua pijimonae yayawenaponaena beya tsane xua cui amanayabina pia peaitafaetabi jiwichi. ");
INSERT INTO cui_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mataʉta daxita nacuanpiwi jiwanamonae pomonae jopa judiomonae naexanaeyo barapomonae bapon wʉnae ewatatsi xua bara bapon barapomonae pecapanenebiwa tsainchi Nacom beicha”, jei Nacom Jesús yabara Isaías pejume diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bapoxonae jiwi Jesús tacapatʉtsi pebin pon muxusipana exainchi cauri, mataʉtano xua itata nacʉta exainchino. Bapon Jesús axaibi exana. Bapoxonae pebin muxu nasaba, beta necota, mataʉtano paebano. ");
INSERT INTO cui_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Daxita pomonae cui tane baxua, pocotsiwa Jesús exana, daxita barapomonae yabara najʉntʉ coyene benaecaeya najei: “Jina, ¿bapon apara David pia pemomoxi susato jiwi jiwanapin tatsi jampa, pon Nacom yabara wʉnae tsiwʉnaeya paeba xua pinae patopeicaena jampa?” jei. ");
INSERT INTO cui_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Poxonae baxua fariseomonae jume tane, jeye: “Bapon caurimonae itawetatsi apara pexeinaexae Beelzebú pia peayapusʉ itorobi coyenewa tatsi pon caurimonae pia pe ntacaponaein tatsi”, jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús yaputane xua fariseomonae nanta xeina poxonae natsipaeba baxua, daxota jei fariseomonaetha: “Icha cae nacuapiwi nawepu tsatabe mataʉta nababe, bapoxonae jopa xaexaenaecaeyo. Mataʉta irʉrʉ icha cae tomarapiwi nababe, bapoxonae jopa xapain jinompaeyo barapo tomarapiwi. Mataʉta irʉrʉ icha cae bo matabʉxʉyomonaebe nababe, yawa nawepu tsatajopabe bapoxonae jopa xaexaenaecaeyo. ");
INSERT INTO cui_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Barichi icha Satanás pijimonae tatsi nawepu tsatajopabe, mataʉtano nababe, bapoxonae jopa xaexaenaecaeyo. Satanás jopa itacʉpaetsi xua itoroba pijimonae, tsipei amsiya exana. ");
INSERT INTO cui_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Paxam pana neyabara jam: ‘Apara bapon itaweta cauri tsipei bapon xeina Beelzebú pia peayapusʉ itorobi coyenewa tatsi, pon Beelzebú caurimonae pia pentacaponaein tatsi’, pana neyabara jam. Icha baxua bara xainyei, ¿nexata eta po peayapusʉ itorobi coyeneya tatsi painyamonae itaweta cauri? ¿Irʉrʉ barapomonae itaweta cauri Beelzebú pia peayapusʉ itorobi coyenewatha tatsi? Daxota painyamonae paca yaputane xua apara paxam panaerabame. ");
INSERT INTO cui_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ichitha nama xan cauri itawetan Nacom pia pejumope tʉnaxʉ tatsi pia peayapusʉ itorobi coyenewatha tatsi, xua barapo pejumope tʉnaxʉ tana necatsixae pia peayapusʉ itorobi coyenewa. Baxua apara paca tsipaebatsi painya neyaputaenexa xua painya xantha patopan ponxaein Nacom Tananeitapetsin. ");
INSERT INTO cui_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Dapon aibi pon itacʉpatsi xua botha joniya po botha pon bichocono maxʉ daunwei pia bo tatsi xua daxita penotsiwa tsane pocotsiwa bapon xeina pon maxʉ daunwei, icha jopa copiya matha maxʉ cʉtanotsiyo. Barapocotsi jʉta coyeneya ichin. Xan cui amanayaban Satanás daxota neitacʉpa xua torotsiya itawetan bapon pijimonae tatsi pomonae caurimonae. ");
INSERT INTO cui_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Pomonae jopa neyawenaeyo, barapomonae apara inta abe exana. Barapomonae exana xua ichamonae jopa tana nejume cowʉntsiwa tsane. Barapomonae jopa yawenaeyo xua ichamonae nenacaetutsina tajiwimonaexae tsane. ");
INSERT INTO cui_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Daxota paca tsipaebatsi xua pocotsiwa jiwi abe peexanae cuiru coyenein exana mataʉtano pocotsiwa xua jiwi abe paeba, barapo coyene Nacom itacʉpatsi xua yabara jʉntemainaena daxita barapo coyenein. Pon abe yabara paeba Nacom pia Pejumope tʉnaxʉ tatsi Nacom bapana jopa yabara jʉntemainae tsane xua bapon paeba. ");
INSERT INTO cui_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mataʉtano xan ponxaein Nacom Tananeitapetsin pon abe neyabara paeba Nacom itacʉpatsi xua bapon peyabara jʉntemainaewatsi pocotsiwa bapon abe neyabara paeba. Ichitha pon nama bichocono abe yabara paeba Nacom pia Pejumope tʉnaxʉ tatsi, Nacom jopa bapana yabara jʉntemainae tsane bapon, anoxuae mataʉtano xua bexa tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Equeicha Jesús jeye: “Icha nae po nae pexeinya nae bara nacoita po pethei pexeinya thei. Icha nae po nae peabe nae bara nacoita po pethei camatsa thei. Jiwi ba nae yaputane tsipei po nae penacoichixae. ");
INSERT INTO cui_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Paxam pomonae bichocono abe peexanaewi pam! Icha jomomonae ichi xua abe exana jiwitha bara paichim, abe paexaname jiwitha. Paxam jopa paca itacʉpaeyo xua xanepanaeya painya nepaebiwa, tsipei pocotsiwa painya coibototha papaebame barapara baxua painya jʉntʉ coyenetha pacayabara nanta xeiname. ");
INSERT INTO cui_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pon ba pejʉntʉ coyene xanepanaein bapon ba xua xanepana paeba, tsipei ba pejʉntʉ coyene xeicaein. Pon ba peajʉntʉcoyenebein bapon ba xua abe paeba tsipei ba peajʉntʉcoyenebein. ");
INSERT INTO cui_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ichitha paca tsipaebatsi xua matacabi patopeicaena po mataqueitha Nacom yabara paebina daxita jiwi penatsicuentsiwa abe peexanaexae bapontha. Barapo matacabitha daxita jiwi bewa atene tsane pepaebixae po jumein jopa xanepanaeyo. ");
INSERT INTO cui_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Poxonae Nacom yabara paebina daxita jiwi penatsicuentsiwa abe peexanaexae bapontha, Nacom tsanaya tsabina pia pepaebixae jumeintha tsane. Pomonae paxam xanepanaya papaebame ichamonaetha poxonae cataunxuae pajinompame po irathe, Nacom xuya paca yabara jei tsane: ‘Barapomonae bara jopa abe exanaeyo’, paca yabara jei tsane. Paxam pomonae bayatha abe papaebame poxonae cataunxuae pajinompame po irathe Nacom xuya paca yabara jei tsane: ‘Maisa barapomonae abe pepaebiwi’, paca yabara jei tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nexata fariseomonae jiwanamonae irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi jiwanamonae, daxita barapomonae Jesús cui itorobatsi, jeichichi: —Pon jiwi Pecuidubim, paichichipan xua pata taewa tsane xua tapana netsita itʉtsiwam tsane cae jinya pexeinya netsita itʉtsi coyenewa pocotsiwa Nacom cacatsina pia peayapusʉ itorobi coyenewatha. Bapoxonae paca jume cowʉntsinchi, jei. ");
INSERT INTO cui_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Daxita barapomonaetha Jesús barai, jeye: —Pomonae peajʉntʉcoyenebe jiwi irʉrʉ pomonae jopa tana nejume cowʉntsi jiwi barapomonae necui itoroba xua taexanaewa cae coyenewa tapexeinya tsita itʉtsi coyenewa. Ichitha jopa tsita itʉtsin tsane icha tapexeinya tsita itʉtsi coyenewa. Saya meisa exanaein icha bayatha jʉta coyene cana ichichi Jonás pon Nacom peitorobi jume pepaebin, pon caena bayatha tʉpa. ");
INSERT INTO cui_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nacom Jonás itorobatsi Nínive tomarapiwi beya petsipaebinexa Nacom Pejume Diwesi barapomonaetha. Jonás jopa baxua peexanaexae daxota Nacom exana xua Jonás quianaxorecatsi duwein pon pinyo. Bapon barapo pin duwein tsijuntutha eca acoibi po matacabiyobe, mataʉtano acoibi po merawiyobe, beya poxonae equeicha yacabaxotsi xua asʉ popona. Barichi tsane xan ponxaein Nacom Tananeitapetsin tʉpaein. Bapoxonae mʉthʉtha nebotsina acoibi po matacabiyobe nexa tsane, mataʉtano acoibi po merawiyobe nexa tsane, beya poxonae equeicha Nacom asʉ juina neexanaena. ");
INSERT INTO cui_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Matacabi patopeicaena po matacabitha Nacom yabara paebina daxita jiwi peperaxa exanaenexatsi penatsicuentsixae abe peexanaexae. Barapo mataqueitha Nínive tomarapiwi pomonae caena bayatha jinompa barapomonae abeya paca yabara paebina poxonae umenaena Nacom peitabaratha. Baxua exanaena tsipei barapo Nínive tomarapiwi icha jʉntʉ coyene xeina Nacomtha peauraxae xua abe exana caena bayatha poxonae Jonás muxuwetsiya tsipaeba barapomonaetha Nacom pia pexeinya jume diwesi tatsi. Ichitha paxam jopa bara paichim, jopa icha jʉntʉ coyene paxeinaem. Nama apara xote uncuanje ponxaein taexanaein po coyenewa pepa peainya cui coyenewa xua tacaponaewa Nacom Pejume Diwesi daxita jiwitha. Bara pocotsi coyenewa toxeinchiya ainya cui coyenewa beyacaincha Jonás po cui coyene exana poxonae Nacom Pejume Diwesi capona Nínive tomarapiwitha. ");
INSERT INTO cui_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Mataʉta barapo matacabitha tsane petsiriwa, powa caena bayatha tʉpa, bapowa asiya uncuaena Nacom peitabaratha tatsi. Barapowa pia nacuapiwayo, po nacua pocotsiwa parowa bereca tajʉ bereca eca. Barapowa pia nacuapiwi tatsi itorobiya pia pepa peewatsiwayo. Barapowa yabara cueicueijei tsane pomonae xua anoxuae jinompa poxonae uncuaena Nacom peitabaratha tatsi. Jei tsane bapowa: ‘Maisa pomonae xua jinompa poxonae Mesías popona po irathe deque, barapomonae abe bichocono peexanaewi, tsipei ajʉntʉcoyenefaetabiya jume tane pocotsiwa Mesías cuiduba bequein Mesías bichocono peyaputaein’, jei tsane barapowa. Barapowa baxua paebina tsipei bapowa bayatha tajʉ werena pona, pesiwa ponaenexatsi Salomón, pon caena bayatha Israel nacuapiwi itorobiya pia pepa peewatsinchi. Bapowa yaputane xua Salomón bichocono peyaputaein Nacom yabara. Daxota bapowa ichichipa xua pecuidubiwatsi xua Salomón pecuidubinexa Nacom yabara. Nama apara xote uncuanje ponxaein taexanaein pocotsiwa pepa peainya cui coyenewa xua tacuidubin Nacom yabara daxita jiwitha. Barapocotsi coyenewa toxeinchiya ainya cui coyenewa beyacaincha Salomón po cui coyene exana poxonae cuiduba Nacom yabara barapo petsiriwatha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Equeicha Jesús jeye: “Poxonae pebin wepu poinchi cauri, bapoxonae cauri pona wexotha ichaxota ira tsewa pepoponaenexa tsane baxota. Ichitha poxonae jopa caxinaeyo xua ichaxota pepoponaenexa bapoxonae bapon nabarai: ‘Tha caibeya ponaetsi pebin beya ichaxota bayatha wepu ponan’, jei cauri. Poxonae caibeya pona cauri caxina, pebin caxinatsi xua xanepanaeya popona. ");
INSERT INTO cui_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nexata equeicha cauri pona pebin weya. Pirapaeyo bapon barʉ patopa siete poyobe cauri pomonae bichocono abe beyacaincha bapon pon copiya. Daxita barapo caurimonae pebin puna jinompatsi. Anoxuae bapon nama yatsicaya bichocono abe cana exainchi beyacaincha poxonae copiya abe cana exainchi poxonae saya caein. Barichi tsane caurimonae abe cana exanaena pomonaetha pomonae anoxuae jinompa, pomonaetha pomonae peajʉntʉcoyenebe jiwi, icha barapo caurimonae ichi poxonae pebin abe cana exainchi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús cataunxuae cueicueijei tsuncuae poxonae beya irʉ pena tatsi peyapin jiwi tatsino pata. Daxita barapomonaeyobe pesato beya umena bequein ichichipa Jesús barʉ cueicueijeichi canta pin bicheito. ");
INSERT INTO cui_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ichʉn Jesús baraichi, jeye: —Ena, irʉrʉ neyapin jiwino pesato beya umena. Bepara bequein cataei, necatsipaebinexa tsane, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ichitha Jesús jopa bara jume jejeyo, saya jame yainyaba bapontha, jeye: —¿Jintam powa be taena natsicotanera? ¿Jintam pomonae be tayapin jiwi natsicotanera? jei Jesús bapontha. Baxua Jesús caunuta pia pecuidubinexa xua peyabara caunutsinexa pomonae pia pepuna jinompaewichi. ");
INSERT INTO cui_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nexata Jesús pijimonae cowai yawa jei jiwitha: —Pomonae xua cowan apara barapomonae be taena tsicotan mataʉtano irʉ be tayapin jiwi tsicotanno. ");
INSERT INTO cui_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pomonae xua exana pocotsiwa Taxa Nacom itoroba, pon peitabocotha peecaeinxae, barapomonae be tayapin jiwi tsicotan, mataʉtano irʉ be tayapixi tsicotanno, mataʉtano irʉ be taena tsicotanno, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Barapo mataqueitha caena Jesús bo weya pona, bapoxonae pucua itapatha ecopa. ");
INSERT INTO cui_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tsipei pin bicheito nacaetuta Jesustha daxota Jesús jeratha nontabiya yawa tsiwiyo nayana toroya bapoxonae ecoundeca. Daxita barapo pin bicheito taetabo mene itapatha umena. ");
INSERT INTO cui_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús barapo pin bicheito cuiduba pecayabara jʉta pepaebi diwesintha. Cae diwesiyotha Jesús namchi, jeye: “Pebin pon peʉbin pontaba pia ʉbichi pabitha. ");
INSERT INTO cui_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Poxonae pon peʉbin ʉbauya, icha xu namtotha xu othopeica. Peyapupunaewi yapata yawa xu xane. ");
INSERT INTO cui_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Icha xu, xu othopeica ibowantha ichaxota ira itafafana. Barapoxonae barapo xu caena nainya xu xuwa tsipei jopa tajʉ xu xuwarecaeyo. ");
INSERT INTO cui_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ichitha poxonae xometo atsa tsina bapoxonae yaboto tsaquiwa yawa tʉpa tsipei jopa tajʉ tabʉ opina xuwarecaeyo. ");
INSERT INTO cui_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Icha xu, xu othopeica ichaxota pesoiwan xuwinaena. Barapo xu yaboto nanta capanaba poxoru yawa muxuna xuwina pesoiwan. ");
INSERT INTO cui_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Icha xu, xu othopeica ichaxota ira wʉnae. Poxonae barapo xu, xu xuwa, xu nawʉnaeta. Icha xun, xu nanacoitapona cien po xu matabʉxʉyobe tsiniya. Icha xun, xu nanacoitapona sesenta po xu matabʉxʉyobe tsiniya. Icha xun, xu nanacoitapona treinta po xu matabʉxʉyobe tsiniya. ");
INSERT INTO cui_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Icha pamuxu dubename, moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nexata Jesús pijimonae imoxoyo caquita umenarʉcʉpatsi yawa yainyabatsi, jeichichi: —¿Eta xua metha jiwitha paebame pecayabara jʉta pepaebi diwesin? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús jume nota barapomonaetha, jeye: “Meisa paxam yatsicaewa Nacom yabara paca yaputane exana po pecuidubiwa xua moya peyawʉn xeinaewa. Barapo moya peyawʉn xeinaewa xua jiwi jopa peyaputaewa apara xua Nacom paca cana exana xua painya nepaca itacʉpaewa xua painya nenaexanaewa Nacom piamonae tatsi pam, pomonae pamxaem Nacom itorobiya paca ewata. Ichitha jame ichamonae pomonae jopa nejume cowʉntsiyo jopa daichichi. Nacom jopa copatsiyo xua barapomonae peyabara yaputaewa baxua. Daxota barapomonae cuiduban pecayabara jʉta pepaebi diwesintha xua Nacom peyabara yaputaenexatsi. ");
INSERT INTO cui_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pon ba be conotha Nacom yabara yaputainchi, Nacom bapontha cana exanaena xua ichawa peyabara yaputaewa tsane beya poxonae bapon equeicha bichocono Nacom pejume cowʉntsiwa tsainchi. Pon ba jopa ichipaeyo xua Nacom peyabara yaputaewatsi, Nacom wepichina po coyene bapon yaputane xua beya daxota Nacom jopa pejume cowʉntsiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Daxota jiwitha paeban pecayabara jʉta pepaebi diwesintha. Baxua paeban barapomonaetha xua bequein pia tana necui taibenaewatha tsane ichitha jopa pia tana necui yaputaibenaewatha tsane. Yawa xua bequein pia tana nejume taibenaewatha tsane ichitha jopa pia tana nejume copi taibenaewatha tsane. ");
INSERT INTO cui_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Barapomonae baxua exana bayatha petsiwʉnae cui yabara paebixaetsi, xua bayatha Isaías pon Nacom peitorobi jume pepaebin, petsiwʉnae cui yabara paebixae pejume diwesitha pocotsiwa barapomonae poxonae baxua exanaena. Isaías Mesías nexa jeye barapomonaetha: ‘Xaniwaicha pana nejume taename ichitha jopa bepayaputaem tsane xua jopa painya tana nejume cowʉntsinexam tsane. Pana necui taename ichitha xaniwaicha jopa bepayaputaem tsane xua painya tana necui yabara jume cowʉntsinexam tsane. ");
INSERT INTO cui_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Paxam bichocono paainya ʉnthʉtom, xua jopa painya tana neyaputaexae jiwim. Mataʉtano jopa xanepanaeya pajume taem tsane, be pomonae penamuxujematsi jiwi pam tsane. Panaichaquetsiname icha be pomonae peitata nacʉtsi jiwi pam tsane. Baxua paexanaename tsipei jopa bepainya tana nejume taewam tsane, xua jopa painya tana nejume cowʉntsinexa tsane. Yawano mataʉta, baxua paexanaename tsipei jopa bepainya tana necui taewam tsane xua jopa painya tana nejume cowʉntsinexam tsane. Mataʉta baxua paexanaename tsipei jopa bepainya tana neyaputaewam tsane painya itamaiqueitontha. Mataʉtano jopa painya neauraxae xua abe paexaname daxota jopa paca jʉntʉ coyene xanepana exanaetsi’, jei Isaías barapomonaetha xua Mesías nexa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nexata Jesús pijimonaetha jeye: “Paxam pajʉntʉ coyene weiweiname tsipei poxonae pana necui taneme pocotsiwa exanan bapoxonae pana necui yaputaneme. Mataʉtano pajʉntʉ coyene weiweiname tsipei poxonae pana nejume taneme pocotsiwa paeban bapoxonae pana nejume cowʉntame. ");
INSERT INTO cui_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Xaniwaicha paca tsipaebatsi pin bicheitomonae, pomonae Nacom peitorobi jume pepaebiwi, mataʉtano irʉrʉ pomonae pejʉntʉ coyene xeicae jiwi, pomonae caena bayatha jinompa barapomonae newʉnae ewata xua tapatopeicaewa. Daxita barapomonae bequein bichocono betaena pocotsiwa pana necui taneme, daichitha jopa baxua taeyo. Mataʉtano bequein bejume taena pocotsiwa pana nejume taneme daichitha baxuan jopa nejume taeyo”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Equeicha Jesús jeye: “Pajume taema xua paca tsipaebatsi pecayabara jʉta pepaebi diwesiyo xua pon peʉbin yabara: ");
INSERT INTO cui_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pomonae bequein jume tane po pecuidubi coyenewa xua Nacom tamropata pitaba xua ewatsiya itoroba jiwi, barapomonae daichitha jopa yaputaeyo barapo coyenewa. Daxota barapomonae jopa xanepanaya exanaeyo icha be pocotsi jʉta coyeneya ichi xua pexuton xua po xuton namto othopeica. Bara jʉta coyeneya cana ichichi pomonae jopa yaputaeyo tacuidubiwa. Caurimonae pia pentacaponaein tatsi barapomonae omeicha bara jʉntʉ coyene weichichi tacuidubi coyenewa daxota barapomonae jopa nejume cowʉntsiyo. ");
INSERT INTO cui_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Po xuton xua xu othopa ibowantha, barapo xuton yabara caunuta po jiwi xanepanaya jume tane Nacom Pejume Diwesi xuano jʉntʉ coyene weiweinaya Nacom jume cowʉntatsi. Ichitha bara caeto jume cowʉnta poxoru barapomonae antʉfaetabiya jume jeba Nacom pejume diwesi pejʉntʉ coyeneintha. Poxonae yaitama barapomonae bichocono peatenexae, mataʉtano poxonae barapomonae yaitama abe petaexanaexaetsi ichamonae xua pejume cowʉntsixae Nacom, bapoxonae caurimonae abe exana barapomonaetha xua barapomonae jʉntʉ coyene wejʉntemaina exanatsi xua Nacom pecayabara jʉntemainaewatsi. ");
INSERT INTO cui_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Po xuton xua xu othopa pesoiwantha, barapo xuton caunuta xua pomonae Nacom Pejume Diwesi jume tane ichitha saya barompaya pia jʉntʉ coyenetha jinompa. Mataʉtano saya ʉ copei cayabara nanta xeina. Mataʉtano saya exana pocotsiwa jʉntʉ coyene weiweina cana exainchi. Po coyene pebiwi exana baxuan barapocotsi jʉta coyene exana icha ichi xua po xuton be pesoiwantha xu othopiya. Barapo xuton jopa thei dubenaeyo. Barapocotsi jʉta coyeneya ichi barapo jiwi. Jopa xanepanaya Nacom tsita jinompaetsi. ");
INSERT INTO cui_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Po xuton xua xu othopeica peira wʉnaewatha, bara nacoita. Barapo xuton yabara caunuta pomonae jume tane Nacom Pejume Diwesi, mataʉtano jume cowʉntano poxoru jʉntʉ coyene xanepanaeya jume tane. Mataʉtano beta exana dubenanaebiya beya matapainya jiwi cui tane xua barapomonae bara jʉntʉ coyene xanepana Nacom peitabaratha tatsi. Bapoxonae ichamonae barapomonae jiwana beta yawena ichamonaetha icha barapo xuto ichi xua cien po xu matabʉxʉyobe tsiniya tsoponae. Mataʉtano ichamonae barapomonae jiwana beta yawena ichamonaetha icha barapo xuto ichi xua sesenta po xu matabʉxʉyobe tsiniya tsoponae xua jume cowʉnta. Mataʉtano ichamonae barapomonae jiwana beta yawena ichamonaetha icha barapo xuto ichi xua treinta po xu matabʉxʉyobe tsiniya tsoponae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Bapoxonae Jesús equeicha cuiduba jiwi icha pecayabara jʉta pepaebi diwesiyo, jeye: “Yabara paca tsipaebatsi po coyene xua Nacom exanaena pon jiwi ewatsiya peitorobixaetsi. Bapon yabara paebina daxita jiwi penatsicuentsixae abe peexanaexae. Barapo coyenewa jʉpa, icha be pocotsi coyeneya jʉta ichi poxonae pebin ba ʉʉbapona pabitha peʉbi xuton po peʉbi xuton pexeinya xuton. ");
INSERT INTO cui_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ichitha poxonae cataunxuae jiwi maitumena, bapoxonae pon pabi pexeinaein pia peaitafaetabi jitontsi tapatopatsi pia pabitha tatsi. Bapoxonae bapon ayabo xu taʉbarecatsi ichaxoyo ʉbareca po pexu pexeinya xu. Poxonae nacobe weta xua ʉba ayabo xu, bapoxonae napitabiya ponataba. ");
INSERT INTO cui_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Poxonae trigo xu yaothopa bapoxonae irʉ ayabo xuwina. ");
INSERT INTO cui_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bapoxonae pon pabi pexeinaein baraichi pomonae pia petanacuichixaetsi: ‘Pata Tanecanamataxeinaem, icha bara metha ʉbame po xu pexeinya xu, ¿nexata eta werena metha ayabo pona xua xuwa?’ jei. ");
INSERT INTO cui_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pon pabi pexeinaein jume nota pomonae pia petanacuichiwixaetsi jeye: ‘Apara baxua inta exana pon tana neaitafaetabi jiton’, jei. Bapoxonae bapon baraichi pomonae pia petanacuichiwichi, jeye: ‘¿Ichichipame xua pata ponaewa tsane bara beya pata xunaenexa barapo ayabo?’ jei. ");
INSERT INTO cui_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ichitha bapon jume nota jeye: ‘Bara tsane itompaena tsipei icha barapo ayabo paxunaetsipame payawa xunaetsipame trigo xu. ");
INSERT INTO cui_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bara saya yawa umenaena barapo ayabo beya abʉ poxonae yawa nawetsina trigo xu. Tha nexata bapoxonae itorobichi penacuichiwi xua copiya pexunaenexa barapo ayabo xua pepa cunton peexanaenexa, xua petautsinexa tsane, xua bapoxonae trigo xu pejebinexa tabotha xua trigo xu matabotha’, jei pon pabi pexeinaein”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Equeicha Jesús jiwi cuiduba icha pecayabara jʉta pepaebi diwesiyo, jeye: “Nacom waba jiwi xua petanaexanaenexatsi pijimonae tatsi, pomonae itorobiya peewatsixae beya pinmonae tsoponae xua pomonae jume cowʉntapona Nacom. Barapo coyene jʉpa icha be poxonae pebin ichi poxonae ʉbanota pabitha po peʉbi xuto tsica xutiyo. Barapo xuto xuwa beya pin nae tsoponae. Barapo nae pepinnaexae daxota siri pemaxʉranantha coton exana”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús equeicha cuiduba jiwi icha pecayabara jʉta pepaebi diwesiyo, jeye: “Poxonae Nacom waba jiwi petanaexanaenexatsi pijimonae tatsi pomonae itorobiya peewatsixae barapomonae pin bicheitomonae naenaexanapona. Barapo coyene bara jʉta ichi, icha levadura matawʉn ichi pocotsiwa cotowa exana poxonae pan exana. Petsiriwa tres po tsoropabe trigo xu beno muxuna cauyentaba levadura matawʉn pocotsiwa xua cotowa exana pan. Bapoxonae pentʉbʉ naexananaya cocotowapona tsipei levadura matawʉn muxunaxuba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús cuiduba jiwi daxita barapo coyenein xua xuan saya ʉ pecayabara jʉta pepaebi diwesixitha. Jesús jopa cuidubeibiyo poxonae jopa paebeibiyo pecayabara jʉta pepaebi diwesixitha. ");
INSERT INTO cui_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Bara barapo coyeneintha Jesús cueicueijei xua penayabara jume wetsinexa xua bayatha pon Nacom peitorobi jume pepaebin pecui yabara wʉnae tsiwʉnaeya paebixae, xua jeye: “Jiwitha tsipaebin pecayabara jʉta pepaebi diwesintha. Mataʉtano muxuna yabara tsipaebin pocotsiwa moya yawʉn xeina xua jiwi jopa peyaputaewa, po coyene caena bayatha moya yawʉn xeina xua poxonae aena Nacom forota po cae pin nacuathe xua pocotsiwa beya anoxuae tsoponae”, jei bapon xua saya Jesús tapaebatsi. ");
INSERT INTO cui_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nexata Jesús napeyaba pin bicheito jiwimonae. Bapoxonae botha joniya. Irʉ baxota Jesús pijimonae tatsi barapo botha najojoniyarʉ. Jesús pijimonae baraichi, jeye: —Yabara pana neyaputane exande po diwesiyo xua ayabo po ayabo xuwa trigo pabitha, jei. ");
INSERT INTO cui_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nexata Jesús namchi, jeye: “Pon ʉba po xuton pexeinya xuton, trigo xuton jan, bapon apara bara xan ponxaein Nacom Tananeitapetsin. ");
INSERT INTO cui_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mataʉtano po pabitha ichaxota ʉba jan, apara jiwi pia jʉntʉ coyenein yabara caunutan. Pocotsi xuton xua yabara caunutan xua pexeinya xuton jan, apara yabara caunutan pocotsi jiwimonae xua patsina Nacom pia peitorobi nacua beicha tatsi. Po xuto peabe xuton, po xuton ayabo xu jan, apara yabara caunutan pocotsi jiwimonae caurimonae pia pentacaponaein tatsi pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pon ʉba po xuton abe xua ayabo xu jan, apara bapon caurimonae pia pentacaponaein tatsi yabara caunutan. Xua bayatha xu naweta jan, apara yabara caunutan, po mataqueitha xua Nacom daxita nacui wetsina. Mataʉtano barapo matacabitha Nacom yabara paebina jiwi penatsicuentsiwa abe peexanaexae bapontha. Pomonae xua trigo xu, xu siraca jan, apara yabara caunutan matatsunpiwimonae. ");
INSERT INTO cui_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Copiya matha xuexuetapona ayabo petautsinexa isototha. Jiwi bara jʉtiya ichainchi po matacabitha tsane Nacom daxita yabara paebina jiwi penatsicuentsiwa abe peexanaexae bapontha. Mataʉtano barapo cae pin nacue weraweracaena. ");
INSERT INTO cui_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xan ponxaein Nacom Tananeitapetsin itorobin tamatatsunpiwi xua jiwi penotsinexa tsainchi pomonae abe peexanaewi, pomonae xua cana exana ichamonaetha xua ichamonae xuya irʉ abe peexanaenexarʉ. Barapo matatsunpiwi wenotsina pomonae abe peexanaewi pomonae tajiwimonae barʉ jinompatsi. Barapo abe peexanaewi jopa tamonaeyo pomonae itorobiya taewatsixae. ");
INSERT INTO cui_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Daxita barapo jiwi pomonae abe peexanaewixae bebai tsainchi, matatsunpiwi bebai tsane ichaxota isoto jopa itacounayiyo ataya. Baxota daxita jiwi wecoyei tsane mataʉta baxota nantanuweya nantʉ jayabina, poxoru bichocono atene tsane. ");
INSERT INTO cui_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Bapoxonae pomonae exana pocotsiwa Nacom ichichipa barapomonae bichocono pexeinya coicha xeinaena po nacuatha ichaxota Nacom itorobiya ewata piamonae pon barapomonae pia paxaxae tatsi. Po pexeinya coicha xua barapomonae xeinaena, bichocono itʉpana icha be xometo ichi xua poxonae pentha. Icha pamuxu dubename, moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Equeicha Jesús namchi, jeye: “Yabara paca tsipaebatsi po coyene xua Nacom exana, pomonaetha pomonae pejʉntʉ coyene canamataxeinaexae pon jiwi itorobiya pia pepa peewatsinchi. Barapo coyene bara jʉta ichi, icha be pocotsiwa peitʉpanaewa ichi pocotsiwa ainya matoma xua ira bʉxʉpanatha boca pabitha. Poxonae pebin barapo peitʉpanaewa jemeicha ira bʉxʉpanatha namicha taebota, bichocono tsorobotha matatsaebota, bichocono peichichipaexae baxua. Jopa muxu tsipaebiyo ichamonaetha. Bichocono jʉntʉ coyene weiweina. Bapoxonae pia botha pona pecaenaetsinexa daxita xua xuan pocotsiwan xeina. Bapoxonae barapo paratixitha comota barapo pabi, po pabitha boca barapo peitʉpanaewa. Bewa barichi jiwi. Bewa jiwi bichocono beita cui jichatsi xua pexeinaewanexa tsane barapo peajʉntʉyapusʉwa, icha poxonae pebin ichi xua pitapeitʉpanaewatsi piraichi daxita caenaeta pocotsiwan xeina”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Equeicha Jesús namchi, jeye: “Barichirʉ yabara paca tsipaebatsi po coyene xua Nacom exanaena pon jiwi ewatsiya peitorobixaetsi po coyene bichocono wʉnae. Barapo coyene bara jʉta icha be ichi poxonae jiton warowan matowa jeita. Barapo warowan xua bapon jeita, pewʉn perla. Bapon jeita pecomotsinexa tsane barapo warowan, po warowan ainya matoman. ");
INSERT INTO cui_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Poxonae bapon cae warowaxuto taebota, po warowaxuto perla matawʉn xua bichocono ainya matoma, bapoxonae bapon pia botha pona mataʉta bapoxonae caenaeta daxita xua xuan pocotsiwa xeina. Bapoxonae comota po warowa bichocono ainya matoma, po warowa pewʉn perla. Bewa barichi jiwi. Bewa jiwi bichocono beita cui jichatsi xua pexeinaenexa peajʉntʉyapusʉwa po peajʉntʉyapusʉwa ataya tsiteca, icha poxonae pebin ichi xua pitaperlatsi piraichi daxita caenaeta pocotsiwan xeina”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Equeicha Jesús namchi, jeye: “Yabara paca tsipaebatsi po coyene xua Nacom exana pon jiwi ewatsiya peitorobixaetsi xua poxonae yabara paebina jiwi penatsicuentsixae abe peexanaexae. Barapo coyene bara jʉta ichi, icha be pocotsiwa xua xota jiwi yacamona duwei ichi. Jiwi peyacamonaewa xoya pepa mar mentha xua daxita duweimonaein tunto pecapirenaenexa. ");
INSERT INTO cui_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Poxonae bichocono wʉncaxuba xua peyacamonaewa pomonae peyaxunubiwi taetabo bejutaboreca. Bapoxonae enoundeca, xua naitaʉbiya tsana pejejebaponaenexa. Po duwei pepa duwei tsana naitaʉbiya jejebapona corotontha. Po duwei pocotsiwa camatsawan bebai tsoponae. ");
INSERT INTO cui_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Barapocotsi jʉta coyeneya ichi tsane poxonae matacabi patopeicaena, po mataqueitha xua poxonae nacua weraweracaena, mataʉtano Nacom daxita yabara paebina jiwi penatsicuentsixae abe peexanaexae bapontha. Bapo mataqueitha matatsunpiwi patsicaena xua daxita jiwi petsabinexa tsainchi, pomonae abe peexanae cuiru coyenein peexanae jiwi tsana nobinchi xua pomonae xanepanaya peexanae jiwi pia xainya weya tatsi. ");
INSERT INTO cui_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pomonae abe peexanae cuiru coyene peexanae jiwi bebai tsainchi isototha ichaxota jopa ataya itacounayiyo. Baraxota wecoyei tsane mataʉtano baxota nantanuweya nantʉ jayabina”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nexata Jesús pijimonae yainyaba, jeye: —¿Bara daxita baxuan payaputaneme xuaunxuae paca tsipaebatsi? jei. Barapomonae Jesús jume notatsi: —Aa, bara payaputan pocotsiwa xuaunxuae pana netsipaebame pon pata Tanecanamataxeinaemxaem, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Bapoxonae Jesús pijimonaetha namchi, jeye: —Pomonae pecuidubiwi Nacom pia peitorobi diwesi pomonae tamonaexae barapomonae yabara cuiduba ichamonaetha xua po coyene Nacom exana pon itorobiya peewatsin jiwi. Barapomonae xeina ainya diwesi coyenewabe, po diwesi xua xan yabara, peru diwesi poxonae cataunxuae aibin tsica po cae pin nacuathe tsique yabara. Mataʉtano xeina pena diwesi poxonae xua anoxuae poponan yabara. Barapo ainya diwesi coyenewabe barapomonae paeba jiwitha. Barapomonae bara be jʉta ichi icha be poxonae pon bo pexeinaein ichi. Poxonae piamonae tatsi nantawenona paparuwa yawa pexaewa, bapon baxua bara cata pijimonaetha, poxoru bapon jeba xua peruwa yawa xua penawa piamonae nexa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Poxonae Jesús najume weta xua cuiduba jiwi barapo pecayabara jʉta pepaebi diwesixi bapoxonae Jesús tomara weya pontaba. ");
INSERT INTO cui_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Bapoxonae Jesús patopa pia tomaratha, po tomara pewʉn Nazaret tomara. Baraxota Jesús cuiduba jiwi, judiomonae pia penacaetutsi botha tatsi. Pomonae jinompa Nazaret tomaratha yabara najʉntʉ coyene cabenaeca xua pocotsiwa Jesús cuiduba. Barapomonae natsipaeba, najei: —¿Exota metha bapon nacuiduba jane, xua daxota bapon daxita peyaputaein? ¿Jintam metha pia peayapusʉwatha tatsi jane, poxonae po petsita itʉtsi coyene bapon exana? ");
INSERT INTO cui_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Apara saya bapon pexanto tatsi pon xua pecobe coxonaein xua naepan pematabobiwa. Apara bapon pena tatsi María. Apara bapon Santiago pentapin tatsi, irʉ José pentapin tatsi, irʉ Simón pentapin tatsi, irʉ Judas pentapin tatsitʉ irʉ. ");
INSERT INTO cui_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mataʉtano irʉ pamcho jiwi tatsi apara jinompa barapo tomarathe. ¿Exota metha bapon nacuiduba jane, pocotsiwa xua beta naca cuiduba? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Daxota barapomonae Jesús casebatsi pecui uwixaetsi. Barapomonae uwa tsipei Jesús bichocono peyaputaein. Jesús namchi jiwitha, xua nayabara paeba, jeye: —Daxita jiwi ba barʉ cui itura jina pontha pon Nacom peitorobi jume pepaebin. Nama pia nacuapiwi tatsi irʉ pia bomonae matabʉxʉyomonaepiwi tatsi barapomonae ba jopa bapon barʉ cui itura jinaetsi, jei Jesús, xua nayabara paeba. ");
INSERT INTO cui_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Nazaret tomaratha, barapo tomaratha Jesús saya be conotha exana pexeinya petsita itʉtsi coyenewan tsipei barapo tomarapiwi Jesús jopa jume cowʉntichi. ");
INSERT INTO cui_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Bapoxonae caena Herodes pon Galilea nacuapiwi, pia peyanacua ewatsinchi, bapon jume tane daxita pocotsiwa juinya xua Jesús exana. ");
INSERT INTO cui_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes tsipaeba pomonae petanacuichiwixaetsi pia botha tatsi, xua Jesús yabara paebatsi. Herodes Jesús catsawiya yabara paebatsi, jeye: “Apara bapon Juan, pon jiw i Pebautisabin, pon bequein bayatha tʉpa, pon equeicha asʉ juina. Tsipei bapon peayapusʉ itorobi coyenewa xeina daxota petsita itʉtsi coyenewa exana”, jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Baxua Herodes paeba tsipei caena bayatha Herodes cui itoroba xua Juan pewaetabinexatsi, mataʉtano xua pemaxʉ cʉbinexatsi, mataʉtano xua jiwi pecʉbi botha peetsinexatsi. Baxua Herodes exana tsipei piowa tatsi powa pewʉn Herodías, pia coutha baxua peichichipaexae. Barapowa copiya Felipe xeina pon Herodes peweicho tatsi. Herodes peweicho yacaiba yabʉyo. ");
INSERT INTO cui_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan bayatha paeba Herodestha, jeye: “Nacom pia peitorobi coyenewa jopa copatsiyo xua nexeinaewa bapowa tsipei ichʉn piowa tatsi”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Daxota Herodes bichocono anaepana. Herodes ichichipa xua Juan pebexubiwatsi. Daichitha Herodes jopa baxua exanaeyo tsipei junuwa, jiwi cunuwatsi. Tsipei daxita jiwi nanta xeina xua Juan apara pon Nacom pia peitorobi jume pepaebin. ");
INSERT INTO cui_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ichitha poxonae Herodes yantacabi jopa po matacabitha poxonae caena bayatha nowaeuncua, barapo mataqueitha pinmonae nacaetuta xua pexaewa yabara nacaetuta pia xaetsi. Barapo penacaetutsiwi peitʉtha tatsi Herodías pexantiyo tatsi nawiraba. Herodes baxua bichocono ita cui xanepanatsi. ");
INSERT INTO cui_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Herodes barapowa beya paeba, jeye: —Nacom peitʉtha cata tsiwʉnae yabara paebatsi xua pocotsiwa tacacatsiwa tsainchi pocotsiwa xua tana newʉcaewam tsane tsipei inta pexeinya penawirabi coyene exaname, jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Bapoxonae pocotsiwa pena itorobatsi barapowa Herodes wʉcatsi baxua. Bapowa namchi, jeye: —Necare Juan pentasipa xua yʉtabore paratontha, pon jiwi Pebautisabin matasipa, jei Herodías pexantiyo tatsi. ");
INSERT INTO cui_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ichitha baxua Herodes jume taya wecoyei tsanareca poxoru jopa ichipaeyo xua Juan petʉpaewa tsane. Tsipei mexeya poxoru bayatha Nacom peitʉtha peyabara tsiwʉnae paebixae xua bepa pinae catsina xua pocotsiwa pewʉcaewaxae tsainchi, mataʉtano mexeya poxoru barapo pin bicheitotha peitʉtha pepaebixae baxua, daxota itoroba xua bapowa bara catinchi baxua. ");
INSERT INTO cui_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Daxota Herodes pomonae petanacuichiwixaetsi, barapomonae Herodes cui itoroba xua Juan pewisi ucuibinexatsi jiwi pecʉbi botha iya. ");
INSERT INTO cui_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bapoxonae barapomonae paratontha matasipa yʉtabota yawa carendena. Bapoxonae Herodías pexantiyo tatsi catatsi, equeicha barapowayo xuya pena cata, Herodías catatsi, xua peyaputaenexa xua bara cou Juan bayatha tʉpa. ");
INSERT INTO cui_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nexata pomonae Juan pia pepuna jinompaewichi, barapomonae pata jiwi pecʉbi botha. Juan petʉpaein pitatsi. Barapoxonae barapomonae Juan mʉthʉtha xotsi. Barapoxonae barapomonae pona Jesús beya xua baxua Jesús peyabara tsipaebinexatsi. ");
INSERT INTO cui_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Poxonae Jesús yaputane xua Juan tʉpa, bapoxonae compa jeratha pona icha muxunene beya ichaxota jiwi ajibi. Ichitha jiwi yaputane xua ichaxota Jesús pona. Daxota pinmonae xua carepaya tomaranpiwi pecae iya pona, ichaxota Jesús ponaena jeratha. ");
INSERT INTO cui_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Poxonae Jesús jera wenontounya, bapoxonae Jesús pin bicheito tane. Jesús yabara nanta xeina barapomonae xua peyawenaewa tsane. Bapoxonae Jesús axaibi exana peatenewi. ");
INSERT INTO cui_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsipei yaitama bayatha tabopiya tsanaichaba, daxota Jesús imoxoyo caquita umenarʉcʉpatsi pijimonae. Barapomonae Jesús baraichichi, jeye: —Apara bayatha tabopiya tsanaicha. Apara xote bomʉxʉn ajibi. Barapo jiwi itorobare bʉ tsiqui tomaraxi beya ponaena xua pecomocaenexa pexaewa xua pexaenexa, jei. ");
INSERT INTO cui_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús jume nota pijimonae, jeye: —Apara jopa bewa ponae barapomonae, paxam jame maisa paapare pexaewa, jei. ");
INSERT INTO cui_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jesús jume notatsi pijimonae, jeye: —Xote jopa pexaewa paxeinaeinyo. Saya apara cinco po panyobe paxeinan mataʉta saya ainyobe paxeinan duweiyobe, jei. ");
INSERT INTO cui_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús jume nota: —Painta xawena baxua, jei. ");
INSERT INTO cui_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bapoxonae Jesús najume caitoroba xua bepa daxita barapo jiwi iratha taenaetsei. Bapoxonae Jesús pecobetha pita cinco po panyobe yawa xua barapo duweiyobe xua ainyobe. Jesús peitaboco benecoicha yawa Nacomtha tsipaeba, jeye: “Axa, jʉntʉ coyene weiweinan xua pexaewa pata tanecatsiwaxaem”, jei. Poxonae Jesús najume weta xua Paxatha tsipaeba, bapoxonae pan epa janaca, yawano duwei epa janaqueba. Bapoxonae Jesús pijimonae caitoroba pexaewa xua pijimonae tatsi xuya pecacataponaenexa barapo jiwi. ");
INSERT INTO cui_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Daxita barapo jiwi nabane beya barapo jiwi jain cowʉntarʉcʉpatsi. Bapoxonae Jesús pijimonae tatsi doce po cote matabʉxʉyobe wʉnba xua bayatha nacopaba pocotsiwa xua bayatha barapo jiwi jopa xaeyo petonsanaexae. ");
INSERT INTO cui_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pomonae xua pexaewa nabane barapomonae cinco mil pebiwi. Yabʉxino irʉ nanabane. Mataʉtano pexuino irʉ nabane. Daichitha jopa ununaetsi pexui mataʉta yabʉxi jopa ununaetsi. ");
INSERT INTO cui_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nexata bapoxonae Jesús jera beitorobiya pijimonae, xua pijimonae copiya petsiwana warapaenexa tsainchi icha muxunene beya xua pucua iya. Poxonae barapomonae ponarʉcʉpaba bapoxonae Jesús barapo jiwi pu itoroba xua penawibiyaenexa pia tomaran beya. ");
INSERT INTO cui_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bapoxonae Jesús demxuwa beicha pona xua baxota compa petsipaebinexa Nacomtha. Poxonae quirei tsuxubi Jesús demxuwatha compa eca. ");
INSERT INTO cui_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Poxonae Jesús Paxa tsipaebauya, bapoxonae caena irʉrʉ Jesús pijimonae tatsi cataunxuae tuwʉtha yana pona. Jera maratsaca caewa carena tsaibi tsipei joibo dawerena daunwei. ");
INSERT INTO cui_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mataquei wʉnaeyo Jesús mene matatsun jumatha pona, pijimonae itiya pona. ");
INSERT INTO cui_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Poxonae Jesús pijimonae taerʉcʉpatsi, barapomonae nanthʉthʉ cui coyene nabenaeca. Junuwiya wawaya jeye: —¡Pai jaibo, jina! ¡Apara dowatsi! jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesús pijimonaetha caena nainya tsipaeba, jeye: —¡Apara xan! ¡Jopa pajunuwinde! ¡Maisa pajʉntʉ coyene weiweinare! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bapoxonae nexata Pedro Jesús baraichichi, jeye: —Tanecanamataxeinaem, icha bara metha xam yatsicaewa bapom, moya neitorobare xua mene matatsun juma ta-iyaenexa nexainya beya, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús jume nota, jeye: —¡Moya anetha denande! jei Jesús. Nexata Pedro mene matatsun juma nontabiya dunareca jera wereca. Bara Pedro mene matatsun juma iya pona pepatopaenexa Jesús pia xainya beya tatsi. ");
INSERT INTO cui_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Daichitha poxonae Pedro yabara nanta xeinanareca pin joibo, bapoxonae bichocono junuwanareca. Daxota bapoxonae Pedro yamene jopareca. Bapoxonae Pedro jume daunweya wawaya jeye: —¡Tanecanamataxeinaem, necapanepare, nepitaxuina! jei. ");
INSERT INTO cui_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bapoxonae Jesús nainya cobe pitaxuina. Jesús namchi, jeye: —¡Maisa be conotha neyabara jume cowʉntame xua bara tana neitacʉpaewa xua tacayawenaewa tsainchi! ¿Eta xua metha ainya jʉntʉ coyeneintha nanta xeiname? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Poxonae Jesús irʉ Pedro nontabiyabe jeratha, Jesús bapoxonae joibo yainjei tsanaya exana. ");
INSERT INTO cui_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Daxita pomonae jeratha ena, barapomonae Jesús wʉnae jaintatsi. Barapomonae Jesús baraichi, jeye: —Bara yatsicaya apara xam Nacom Pexantom tatsim, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bapoxonae Jesús irʉ pijimonae tatsi jeratha yana enapona beya poxonae Genesaret nacua beya pata. ");
INSERT INTO cui_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pomonae baxota jinompa, barapomonae Jesús caena yaitainchi. Daxota barapomonae najume caitoroba ichamonaetha daxita barapo Genesaret nacuapiwitha beya, xua Jesús pepatopaexae. Bapoxonae daxita jiwi carendena peatenewi ichaxota Jesús pucua itapatha uncua. ");
INSERT INTO cui_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Barapomonae pomonae peatenewi Jesús jume daunweya wʉcatsi, xua Jesús bara pecui copatsinexa xua bara petajayabinexatsi pia paparuwa tatsi xua peopirawa. Bapoxonae daxita barapomonae axaibi tsane. Pomonae Jesús pia paparuwa tajayabatsi daxita barapomonae equeicha axaibi exanatsi pocotsiwa bayatha atene. ");
INSERT INTO cui_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Fariseomonae irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, barapomonae jiwana Jerusalén tomara werendena. Barapomonae Jesús imoxoyo caquita umenarʉcʉpiya yainyabatsi, jeye: ");
INSERT INTO cui_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Eta xua metha jinyamonae jopa exanaeyo xua pocotsiwa wamo susato jiwi pia peitorobi cui coyenewatha itoroba? Barapomonae pomonae jinyamonae barapo cui jopa exanaeyo. Barapomonae jopa matha tsiwanaya nacobe quiateibiyo poxonae beya xaiba xua jopa penataxobinexa tsane pia jʉntʉ coyenewantha, jei daxita fariseomonae, irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. ");
INSERT INTO cui_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nexata Jesús xuya yainyaba, jeye: —Irʉrʉ paxamdʉ, ¿eta xua metha jopa paexanaem pocotsiwa Nacom Pejume Diwesitha itoroba? ¿Eta xua metha saya meisa paexaname pocotsiwa painya amo susato jiwi pia peitorobi cui coyenewantha tatsi itoroba? ");
INSERT INTO cui_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jopa bewa paexanaem tsane painya amo susato jiwi pia peitorobi coyenewa tatsi po peitorobi coyenewa paca tsita ainya cui bichocono beyacaincha xua Nacom Pejume Diwesi. Tsipei Nacom Pejume Diwesitha jeye: ‘Axatha barʉ cui itura jinare, irʉrʉ enatha barʉ cui itura jinare’, jei Nacom. Yawa equeicha Nacom jeye: ‘Pon paxa abe yabara paeba mataʉtano xua pena abe yabara paeba, bapon bewa tʉpaena’, jei Nacom Pejume Diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ichitha paxam ba papaebame xua pinae pebin ba itacʉpatsi xua pepaebiwa xua pejeiwa paxatha yawa penatha: ‘Jopa neitacʉpaeyo xua tapaca cayawenaewatsi bara bequein paacopeibim, tsipei daxita pocotsiwa xeinan baxua yabara tsiwʉnae paeban xua Nacomtha bexa catsin’, xua pejeiwa. Mataʉtano ba pajam: ‘Pon bapocotsiwa paeba, jopa nantawenonaeyo xua paxa yawenaena. Mataʉta jopa nantawenonaeyo xua pena yawenaena bara bequein acopeibi taetha’, ba pajam. Poxonae baxua pacaunutsiya paebame paxam pacana exaname xua painya amo susato jiwi pia peitorobi cui coyenewa tatsi bichocono ainya cui coyene, beyacaincha xua Nacom Pejume Diwesi xua ainya cui coyene. ");
INSERT INTO cui_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Itara mexeya pomonae xanepanaeya pepaebi jiwi pam, daichitha apara peajʉntʉcoyenebe jiwi pam! Bara apara Isaías caena bayatha xaniwaicha paca yabara paeba pon Nacom peitorobi jume pepaebin. Bapon paca yabara jeye poxonae tina pejume diwesitha: ");
INSERT INTO cui_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Barapomonae itara be xanepanaeya neyabara paebina jiwitha xua pinae neyabara barʉ cui itura jina. Daichitha barapomonae pia jʉntʉ coyenewatha jopa xaniwaicha neyabara barʉ cui itura jinae tsane. ");
INSERT INTO cui_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bequein barapomonae newʉnae jainteibina poxonae nacaetuteibina, daichitha baxua jopa yawenae tsaibi tsainchi tsipei barapomonae peajʉntʉcoyenebewi. Mataʉtano tsipei po peitorobi coyenewa cuidubina jiwitha, apara jopa taitorobi coyenewiyo tsane, apara xua saya jiwi barompaya pia peitorobi coyenewa tatsi tsane’, jei Isaías xua paca yabara paeba, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nexata bapoxonae Jesús waba daxita jiwi xua imoxoyo peumendenaenexa. Yawa namchi barapo jiwitha, jeye: —Pana nejume naitaeware, painya neyaputaenexa pocotsiwa paca tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Pocotsiwa ba pebin pecoiboto deca tsijain jojonecatsi pexaewan, bequein jopa tsiwʉnaeya matha nacobe quiatsiyo poxonae xaiba, barapo coyene apara ba jopa bapana pebin jʉntʉ coyene taxobichi xua poxonae pocotsiwa pexaexae. Jame pocotsiwa ba pebin pecoibototha caunuta, xua peabe jume barapo jume coyene apara pebin jʉntʉ coyene taxobatsi xua poxonae pecueicueijeixae baxua, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nexata Jesús imoxoyo caquita umenarʉcʉpatsi pijimonae. Jesús pijimonae yainyabatsi, jeichichi: —¿Bara yaputaneme xua fariseomonae cayabara muxu coniquiya anaepana, xua nepaebixae baxuan? jei. ");
INSERT INTO cui_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús jume nota pijimonae, jeye: —Taxa pon peitabocotha peecaexae xubina pon jopa pejume cowʉntsinchi. Taxa barapocotsi jʉta coyeneya cana ichi tsane jiwitha icha pebin ichi xua poxonae pabitha pona, mataʉta poxonae naeyo tabʉ opina jonta daxita, pexubinexa. ");
INSERT INTO cui_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bara barabʉ neyabara muxuconacaena, fariseomonae. Jopa payabara jume naitaewatsinde pocotsiwa barapomonae paeba. Tsipei barapomonae jopa xanepanaya peyawenae jiwi ichamonaetha. Barapomonae barapocotsi jʉta coyeneya exana, icha be pon peitata nacʉtsin ichi, xua poxonae matacapona ichʉn xua pon peitata nacʉtsin matacapoinchi. Bapoxonae barapo cae peitata nacʉtsinbe napuna joparecabe mʉthʉtha deca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nexata Pedro Jesús baraichi, jeye: —Yabara pana yaputane exande po pecayabara jʉta pepaebi diwesiyo xua pexaewa yabara, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús biataeya jume nota pijimonae, jeye: —¿Paxam bara paichimdʉ icha jiwi ichi? ¿Cataunxuae jopa painya yaputae jiwi pamdʉ? ");
INSERT INTO cui_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bayatha paxam payaputaneme pocotsiwa pebin tsijain jojonecatsi pexaewa pecoiboto deca baraxua jopa jʉntʉ coyene taxobichi, tsipei barapo pexaewa jopa ponaeyo pia jʉntʉ coyenewatha. Jame barapo pexaewa pecotsorotha pona, bapoxonae nawexacaeca. ");
INSERT INTO cui_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ichitha pocotsiwa pecoiboto tsina caunuta peabe jume, baxua apara seicaya pejʉntʉ coyene wetsina jume pichapa. Tsipei baxua penanta xeinae coyenewa, daxota pebin abeya paeba. Daxota Nacom tsitatsi xua bapon peajʉntʉcuicoyenebein Nacomtha. ");
INSERT INTO cui_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tsipei pejʉntʉ coyene wetsina jume pichapa pocotsiwa abeya penanta xeinae coyenewan, pocotsiwe meje: Ichʉn anaya pebexotsi coyenewa, irʉ ichʉn piseuri tatsi pepichi coyene, irʉ peita coxanae coyenewatsi coyene xua poxonae penayaputae jiwi naperʉ nacoyoba, irʉ ichʉn piawa tatsi pecaibi coyene, irʉ ichʉn yabara penaerabiwatsi coyene, irʉ ichʉn yabara peaebiwatsi coyene. ");
INSERT INTO cui_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nacom tsitatsi xua daxita barapocotsi coyenein pebin ajʉntʉcoyenebe exanatsi xua jʉntʉ coyene taxobatsi xua daxota jopa itacʉpaetsi xua beta exana. Ichitha pocotsiwa pebin nabane mataʉtano xua poxonae bequein tsiwanaya matha jopa nacobe quiatsiyo, barapocotsi coyenein pebin jopa jʉntʉ coyene taxobichi Nacom peitʉtha tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nexata bapoxonae Jesús barapo ira weya warapa Genesaret nacua weya. Mataʉtano pona icha nacua beya po nacuatha ichaxota Tiro tomara eca yawa Sidón tomara ecano. ");
INSERT INTO cui_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yabʉyo, powayo barapo cananeamonaewayo patopa Jesús pia xantha tatsi. Bapoxonae barapowa wawaya Jesustha jeye: —¡Tanecanamataxeinaem, David pia pemomoxi susato jiwi jiwanam! Neyabara najʉntʉ cui coyene cananta xeinare, xua tana neyawenaenexam tsane. Taxantiyo inta cauri xeina; inta bichocono atene exanatsi, jei bapowa. ");
INSERT INTO cui_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Daichitha Jesús jopa jume notsiyo, saya moya uncua. Nexata bapoxonae Jesús imoxoyo caquita umenarʉcʉpatsi pijimonae. Mataʉtano jume daunweya baraichichi pijimonae, jeye: —Barapowa itawere, tsipei barapowa waputha jume daunweya wawai, jei. ");
INSERT INTO cui_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nexata Jesús jume nota pijimonae, jeye: —Nacom meisa saya neitoroba Israel piamonae susato saineiwitha pomonae judiomonae xua tayawenaenexa barapomonae, tsipei barapomonae Nacom tsitatsi xua barapomonae nacabeta icha be ovejan ichi xua poxonae pipato napuxanompa, jei. ");
INSERT INTO cui_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ichitha barapowa pentabocotha uncua yawa irabe taeuncuareca Jesús peitabaratha tatsi tsipei bapowa barʉ cui itura jina peauraxae, yaitama tsipei Jesús pon jiwi pepa Pecanamataxeinaein. Bapowa namchi, jeye: —¡Pon Tanecanamataxeinaem, neyawende! jei. ");
INSERT INTO cui_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús jume nota barapowa, jeye: —Jopa xanepanaeyo icha matha cayawenatsi powayo nenanapaincha poponaewayom poxonae cataunxuae matha jopa yawenaeinyo pepa tamonae judiomonae. Icha baxua exanaetsipan, bapoxonae be pitan pexui pia pexaewa taapatsinexa aurimonae, jei. ");
INSERT INTO cui_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Barapowa Jesús jume notatsi, jeye: —Aa, bara barichi xuaunxuae netsipaebame ponxaem Tanecanamataxeinaem. Jopa bewa auri catsibi pexui pia pexaewa tatsi, yaitama auri irʉ xane pocotsiwa pexui sorobaba barapo pepʉrʉwixi pocotsiwa pexaethopaewa pebʉxʉpana tsica. Daxota bara ichiya neichinde: Neyawende, tsipei bara neayapusʉ itorobi coyenewa nawita xeiname jinya axaibi exanaenexa judiomonae. Po neayapusʉ itorobi coyenewa judiomonae jopa canantawenonaeyo barapo neayapusʉ itorobi coyenewatha inta axaibi exande taxantiyo, jei. ");
INSERT INTO cui_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nexata Jesús jume nota, jeye: —¡Yabʉyo, maisa bichocono neyabara jume cowʉntame xua bara tana neitacʉpaewa xua tacayawenaewatsi tsainchi! Bara cata exainchi pocotsiwa aunxuae newʉcame, jei Jesús. Poxonae Jesús baxua paeba, bapoxonae nainya barapo yabʉyo pexantiyo tatsi taaxaibi tsuxubichi. ");
INSERT INTO cui_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nexata bapoxonae Jesús bara weya pona. Galilea pucua itapa iya pona. Bapoxonae demxuwa icha juinya, baxota ecopa. ");
INSERT INTO cui_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ichaxota Jesús eca baxota pin bicheito jiwi ayei pata. Barapo bicheito jiwi carendena pejayujayujeiwi, irʉ peitata nacʉtsi jiwino, irʉ pemuxusipanaewino, mataʉta pomonae irʉ peacowaebi jiwi xua pomonae jopa xeinaeyo xua xota nacowaeba. Mataʉtano irʉ icha bicheitomonaeno, pomonae peatenewi. Pomonae peatenewi Jesús pexainya tajebarecatsi. Daxita barapomonae Jesús axaibi exana. ");
INSERT INTO cui_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Poxonae daxita jiwi baxua cui tane, pomonae jopa judiomonae naexanaeyo daxita barapo jiwi yabara cui coyene nanthʉthʉ cabenaeca. Bapoxonae Jesús xanepanaya peexanaexae, barapomonae Nacom wʉnae jaintatsi, po Nacom Israel nacuapiwi pia Nacom tatsi. Daxota barapomonae baxua exana, tsipei Jesús equeicha paeba cana exanaeya exana pomonae pemuxusipanaewi. Mataʉta tsipei Jesús taduba exana pomonae bayatha jopa xeinaeyo xua xota nacowaeba. Mataʉtano tsipei pomonae pejayujayujei jiwi equeicha beta pona. Mataʉtano tsipei pomonae peitata nacʉtsi jiwi equeicha beta tane. ");
INSERT INTO cui_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nexata Jesús waba pijimonae, jeye: —Yabara cui cananta xeinan barapo pin bicheitomonae tayawenaenexa, tsipei barapomonae acoibi po matacabiyobe jinompa taxantha, maisa ajibi xua barapomonae penabanaewa tsane. Jopa jainbotha bepu itorobinyo pia bon beya tatsi, tsipei icha barapomonae jainbotha pu itorobichipan, metha piyain namtotha xuirabathopaetsipa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jesús baraichi pijimonae, jeye: —Xote ira xuepana susato tsurucuae nacua ichaxota jiwi ajibi. ¿Eta beya tsijeitinchi pexaewa barapomonae pomonae pinmonaexae? jei. ");
INSERT INTO cui_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús yainyaba pijimonae jeye: —¿Eta po panyobe paxeiname? jei. Barapomonae Jesús jume notatsi, jeye: —Siete po panyobe paxeinan yawa be conothano duweixi, poxi tsiquirixi, jei. ");
INSERT INTO cui_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nexata Jesús pijimonae najume caitoroba xua bepa pinae barapo pin bicheito jiwi iratha taenaetsei. ");
INSERT INTO cui_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesús pecobetha pita barapo siete panyobe yawa duweixino. Bapoxonae Jesús Paxatha tsipaeba: “Axa, jʉntʉ coyene weiweinan xua pexaewa pata tanecatsiwaxaem”, jei Jesús. Bapoxonae Jesús pijimonae tsicobe epa nantarʉbiya jajanaquiya catsibapona xua xuya pijimonae tatsi pecatsibaponaenexa barapo jiwitha. ");
INSERT INTO cui_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Daxita barapomonae nabane, beya barapomonae bichocono jain cowʉntarʉcʉpatsi. Bapoxonae Jesús pijimonae tatsi siete po cotebe wʉnba pocotsiwa xua barapo jiwi jopa xaeyo petonsanaexae. ");
INSERT INTO cui_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pomonae xua nabane pexaewa barapomonae cuatro mil pebiwi. Mataʉtano irʉ yabʉxi nanabane mataʉtano irʉ pexui nanabane, daichitha daxita jopa ununaeyo. ");
INSERT INTO cui_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bapoxonae Jesús pu itoroba xua barapo jiwi penawibiyaenexa pia tomaran beya. Bapoxonae Jesús jeratha nontabiya, peponaenexa Magadán nacua beya. ");
INSERT INTO cui_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseomonae irʉ saduceomonae, barapomonae pona Jesús beya xua Jesús pejʉntʉ coyene jʉjʉtsinexatsi. Barapomonae Jesús cui itorobatsi pia petsita itʉtsi coyenewa pocotsi coyenewa xua cana exana itaboco wetsica. Icha Jesús jopa itacʉpaetsi xua exana baxua, barapomonae pepaebinexa tsane xua deta cou Jesús jopa apara Nacom Pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Daichitha Jesús jume nota barapomonaetha, jeye: “Poxonae tabopiya paxam ba pajam: ‘Baya tsane pexeinya matacabi tsane tsipei anoxuae quiripitha itaboco tsobia’, ba pajam. ");
INSERT INTO cui_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ichacuitha tsipae poxonae baya, paxam ba pajam: ‘Anoxuae ema duneicaena tsipei itaboco tsaebia yawa itʉrʉna’, ba pajam. ¡Itara mexeya pomonae xanepanaya pepaebiwi pam, daichitha abe painya neexanaewi pam! Paxam peitaboco payabara yaputaneme. Ema ba payabara wʉnae yaputaneme. Mataʉtano pexeinya matacabino ba payabara wʉnae yaputaneme, deta meisa paxam jopa pana neyabara yaputaem mataʉtano jopa payabara yaputaem pocotsiwa exanan tapexeinya tsita itʉtsi coyenewan. ");
INSERT INTO cui_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Barapo peajʉntʉcoyenebe jiwi irʉ pomonae jopa tana nejume cowʉntsi jiwi, barapomonae necui itoroba tapexeinya tsita itʉtsi coyenewa pocotsi coyene cana exanan itaboco wetsica daichitha jopa baxua beexanaeinyo pocotsiwa barapomonae necui itoroba. Saya meisa barapo petsita itʉtsi coyene exanaein, icha be pocotsi coyeneya Jonás cana ichichi pon Nacom peitorobi jume pepaebin xua poxonae pin duweintha tsijuntutha eca acoibi po matacabibe beya equeicha poxonae yacabaxotsi xua asʉ popona”, jei Jesús xua nayabara paeba xua tʉpaena xua equeicha Nacom asʉ exanaena acoibi po merawithabe. Bapoxonae Jesús ponataba, yawa cuenta pona barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Poxonae Jesús pijimonae tatsi icha muxunene beya pona jeratha xua pucua iya, barapomonae jʉntemaina xua pan capana. ");
INSERT INTO cui_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nexata Jesús pewʉnaeya muxuweta pijimonae xua jopa pejume cowʉntsinexa tsane fariseomonae irʉ saduceomonae pia pecuidubiwa coyenewa tatsi po pecuidubi coyenewa jopa Jesús pia pecuidubi coyenewa tatsi. Jesús jeye: —Dota pam jopa pajume naitaewatsinde fariseomonae pia pecuidubi coyenewa tatsi xua painya nejume cowʉntsiyainwa. Mataʉta dota pam xua saduceomonae pia pecuidubi coyenewa tatsi xua painya nejume cowʉntsiyainwa. Barapo pecuidubi coyenewan jiwi ichawa beya ajʉntʉcuicoyeneyapube cana exanapoinchi icha be pocotsi coyene ichi xua levadura matawʉn xua pan cotowa exanapona beya poxonae pin pan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Poxonae Jesús yabara paeba pocotsiwa xua pan cotowa exana, bapoxonae Jesús pijimonae tatsi catsawiya nanta xeinaeya natsipaeba caemonae, najei: —Metha Jesús daxota baxua paeba metha poxoru yaitama jopa caponaetsi pan, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús yaputane pocotsiwa barapomonae natsipaeba, daxota Jesús barai, jeye: —Pocotsiwa pana natsipaebame xua jopa painya necaponaexae pan, apara poxoru jopa pana nejume cowʉntsim. ");
INSERT INTO cui_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¡Cataunxuae jopa pana necui yabara yaputaem! Paxam pana necui yabara jʉntemainame poxonae cinco mil pebiwi apatan pexaewa xua yabara jʉntemainame poxonae saya cinco po panbe. Mataʉtano pana necui yabara jʉntemainame poxonae equeicha doce po cotebe pawʉwʉnbaponame pocotsiwa jiwi jopa xaeyo. ");
INSERT INTO cui_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mataʉtano paxam pana necui yabara jʉntemainame xua poxonae cuatro mil pebiwi apatan pexaewa xua poxonae saya siete po panbe. Mataʉtano pana necui yabara jʉntemainame poxonae equeicha siete po cotebe pawʉwʉnbaponame pocotsiwa jiwi jopa xaeyo. ");
INSERT INTO cui_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mataʉtano jopa payaputaem xua poxonae yabara paca tsipaebatsi fariseomonae pia pecuidubi coyenewa tatsi, irʉ saduceomonae pia pecuidubi coyenewa tatsi, apara jopa pan yabara paca tsipaebichi xua jopa painya necaponaexae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bapoxonae matapainya Jesús jume yaputaerʉcʉpatsi pijimonae, xua apara yabara paeba fariseomonae pia pecuidubi coyenewan yainwa tatsi, irʉrʉ saduceomonae pia pecuidubi coyenewan yainwa tatsi. Mataʉtano matapainya yaputaerʉcʉpa xua apara Jesús jopa yabara paebiyo pocotsiwa pan cotowa exana. ");
INSERT INTO cui_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Bapoxonae pirapae Jesús pona. Poxonae Jesús patopa Cesarea de Filipo tomara pecuariya xua pepa tomaratha, bapoxonae Jesús yainyaba pijimonae, jeye: —¿Eta po jiton, po jiton xua jiwi yabara paeba xua pinae bapon Nacom pia Peitapetsin tatsi? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jesús jume notatsi pijimonae, jeye: —Ichamonae cayabara jeye: ‘Apara bapon Juan pon jiwi Pebautisabin, pon equeicha petʉpaein asʉ juina’, jei. Irʉ ichamonae cayabara jeye: ‘Apara bapon Elías pon equeicha petʉpaein asʉ juina’, jei. Irʉrʉ ichamonae cayabara jeye: ‘Apara bapon Jeremías pon equeicha petʉpaein asʉ juina’, jei. Irʉrʉ ichamonae cayabara jeye: ‘Apara bapon jiwana pomonae Nacom peitorobi jume pepaebiwi’, jei, jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nexata Jesús pijimonae barai, jeye: —¿Incane irʉ paxamdʉ? ¿Eta pana neyabara jumichimdʉ xua xan eta pondʉn? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro Jesús jume notatsi, jeye: —Xam apara Mesías. Nacom caitorobica, pon asʉ popona. Xam apara Nacom Pexanto tatsim, jei Simón Pedro. ");
INSERT INTO cui_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús barai, Simón Pedro baraichi, jeye: —Simón, Jonás pexantom, maisa Nacom cajʉntʉ coyene weiweina exana, tsipei bapana jiton bapocotsiwa jopa cacuidubi pocotsiwa xua tana neyabara paebiwam. Saya apara meisa Nacom, Taxa, cacuiduba baxua pocotsiwa tana neyabara paebiwam, pon itabocotha eca. ");
INSERT INTO cui_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pocotsiwa xua tana neyabara paebiwam baxua natsita jume itapeinya xeiname xua bichocono tana necui yabara jume cowʉntsiwam. Daxota cawʉn dutatsi po wʉn xua jei: ‘Pedro’, jei, po wʉn caunuta xua jei: ‘iboto’, jei, tsipei ba iboto bichocono mata daunwei. Pocotsiwa xua xainyeya neyabara paebame baxua be iboto coyene jʉtiya paebame poxonae jam: ‘Xam apara Mesías. Nacom caitoroba, pon asʉ popona. Xam apara Nacom Pexanto tatsim’, jam. Daxita pomonae xua neyabara jume cowʉnta barapo pexainyeya jume tana neyabara paebiwathaxaemxae, barapomonae tajiwimonae exanaein. Tajiwimonae catsin taayapusʉ itorobi coyenewa xua barapo tajiwimonae jopa peamanayabinexa tsainchi pia peaitafaetabi jiwichi pomonae petʉpae cuiru nacua beya ponaena. ");
INSERT INTO cui_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xam Pedrom, cacatinchi taayapusʉ itorobi coyenewa xua copiyam tsane caponaename tajume diwesi xua xan yabara ponxaein Mesías, ponxaein Nacom Pexanton. Barapo tajume diwesi caponaename judiomonaetha mataʉtano caponaename pomonaetha pomonae jopa judiomonae naexanaeyo. Mataʉtano xam pon tajitonxaem, pocotsiwa xam jopa copatsim barapo cae pin nacuathe, xua pocotsiwa tamonae exana, baxuan bara irʉ Nacom jopa copatsiyo pia peitorobi nacua beicha xua barapomonae bara peexanaenexa baraxua. Pocotsiwa copatame xua tajiwimonae peexanaenexa barapo cae pin nacuathe, bapocotsiwa irʉ Nacom copata pia peitorobi nacua beicha xua barapomonae bara peexanaenexa baxua, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nexata Jesús pijimonae muxu barai xua pijimonae jopa peyabara pepaebinexatsi ichamonaetha baxua xua po coyene bapon apara Mesías. ");
INSERT INTO cui_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bapoxonae barapo matacabi weya Jesús tamropata pitaba xua pijimonaetha tsipaeba pocotsi coyene Jesús cana exanaeinchi ichamonae, jeye: —Bewa ponaein Jerusalén tomara beya ichaxota pitiri jiwi, irʉrʉ sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, daxita barapomonae bichocono neperaxa jʉbina. Mataʉtano barapomonae nebexubina. Daichitha poxonae acoibi po matacabiyobe tsuxubi tsane equeicha Nacom tatʉpaein asʉ neexanaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ichitha bapoxonae Pedro, Jesús barʉ natsixitabatsi aisowa beya. Pedro Jesús baraichichi, jeye: —Xam pon Necanamataxeinaem. ¡Jamaisa daxua paebameno, bara! Nacom jopa copatsi tsane xua jiwi cata exanaena baxua, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nexata Pedro peitabara beya tatsi Jesús napatomeicha cauncuatabiya namchi, jeye: —¡Xam newepu natsixitabare, tsipei be Satanám! ¡Nejʉntʉ coyene jʉjʉtame xua jopa xanepanaya taexanaewa tsane neaichaxaibixae xua tatsitʉpaewa tsane jiwi! Xam saya abe nanta xeiname icha pebiwi ichi. Saya jopa nanta xeinaem pocotsiwa Nacom necayabara nanta xeina xua tatsitʉpaewa tsane jiwi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nexata Jesús barai pijimonae, jeye: —Icha pebin ichichipa xua tajiwimonae jiwanapin penaexanaewa tsane, bewa bapon yabara naitematsi pocotsiwa xua bapon ichichipa pia peexanae coyenewan tatsi. Bapoxonae jame bapon bewa eexanaponae pocotsiwa itoroban, bequein bara bapon bexotsi ichamonae, tajiwimonae jitonxae. ");
INSERT INTO cui_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pon naantobeya nata exana pocotsiwa bapon ichichipa, bapon jopa xeinaeyo peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. Ichitha pon neantobeya inta exana pocotsiwa ichichipan tana neantobexae bapon xeinaena peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. ");
INSERT INTO cui_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Icha pebin bichocono copei xeina pocotsiwa xeina po cae pin nacuathe, ichitha jopa xeinaeyo peajʉntʉcoyenesʉwa po peajʉntʉcoyenesʉwa ataya tsiteca, bapoxonae bapon jopa itacʉpaetsi xua penajʉntʉ coyene capanepaewa xua jopa peweraweracaewa. Tsipei pebin jopa itacʉpaetsi xua barapo copeitha matomatsina Nacomtha xua bapon pecatsinexa tsainchi peajʉntʉcoyenesʉwa xua barapoxonae pepatopaewanexa tsane Nacom pia nacua beicha tatsi. ");
INSERT INTO cui_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tsipei xan ponxaein Nacom Tananeitapetsin bewa yawa muxuna patopeicaein Nacom pia peitʉpanaewa tatsi. Mataʉta matatsunpiwi barʉ patopeicaein. Daxita carepaya jiwitha catsibin pocotsiwa peyabara cui matomatsiwatsi. Pomonae jopa xapain exanaeyo ichamonaetha xuya barapocotsi coyeneya exanaein xua antomabeya catsin. Pomonae xua xanepanaya exana ichamonaetha pocotsiwa cui itoroban xuya barapocotsi coyeneya exanaein matoma xanepanaya catsibin. ");
INSERT INTO cui_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Bara xaniwaicha paca tsipaebatsi xua pomonae xote umene barapomonae jiwana abʉ, copiya matha yabara yaputaena poxonae xan ponxaein Nacom Tananeitapetsin tamropata pitabin xua itorobiya taewatsiwa tsane pomonae tana nejume cowʉntsiwi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Poxonae seis po matacabibe jopa, po matacabin weya poxonae Jesús paeba baxua, bapoxonae icha matacabitha Jesús pona demxuwa beicha. Pedro Jesús barʉ pona, irʉno Santiago Jesús barʉ pona, irʉno Juan Jesús barʉ pona, pon Santiago peweicho tatsi. Barapo acoibi poyobe Jesús matacapona demxuwatha, po demxuwatha bichocono taʉcha ichaxota jiwaibi. ");
INSERT INTO cui_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Baxoteicha daxita Pedrobarʉ peitʉtha tatsi Jesús pexeinya itʉpanae coicha tsanaya. Bichocono itabara daedaena icha be xometo ichi poxonae pentha. Mataʉtano pocotsiwa penama xatatsiwa bichocono inyapana tsanaya icha pecoicha ichi. ");
INSERT INTO cui_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Bapoxonae Pedrobarʉ taerʉcʉpa Moisés irʉ Elías xua baponbe Jesús barʉ cueicueijeichibe. ");
INSERT INTO cui_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bapoxonae Pedro namchi Jesustha, jeye: —Pata Tanecanamataxeinaem, maisa wʉnae xua xote pata umenaewa. Icha ichichipame, bapoxonae pacata acabinchi acoibi po boutiyobe, cae bouto xam nexa, icha bouto Moisés nexa, icha bouto Elías nexa, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Poxonae cataunxuae Pedro cueicueijei, xua Jesús barʉ cueicueijeichi, bapoxonae daxita barapomonae bematawacaicha taruneicatsi tsaquinaebowa po tsaquinaebowa bichocono pentha. Nexata barapomonae tsaquinaebowatha pejume jume tane xua Nacom namchi, jeye: “Bapon apara Taxanto, pon bichocono antobein, pon itapetan. Bapon bichocono nejʉntʉ coyene weiweina exana. Bapon beta pajume taema pocotsiwa paca tsipaeba”, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Poxonae Jesús pijimonae tatsi jume taerʉcʉpa baxua, bapoxonae barapomonae pia coutha iratha nabebeya, irabe taebobendeca. Barapomonae bichocono pijunuwi. ");
INSERT INTO cui_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bapoxonae Jesús pijimonae imoxoyo caquita uncuataba yawa pijimonae warʉba, jeye: —Panonobaponde, painya xoba pajunuwame, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Poxonae barapomonae necobarʉcʉpa beya meisa Jesús compa uncua, ichamonae aichurubenae. ");
INSERT INTO cui_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Poxonae Jesús pijimonae barʉ duneica demxuwa wetsica, pijimonae barai, jeye: —Ichamonaetha jopa baxua patsipaebinde pocotsiwa aunxuae pataneme xuaunxuae paca tsita itʉtatsi, beya abʉ poxonae xan ponxaein Nacom Tananeitapetsin equeicha asʉn poponaein tatʉpae coyene weya, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nexata Jesús yainyabatsi pijimonae, jeye: —Pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene jeye: ‘Mesías matha tsiwanaya patopaeinchi Elías’, jei. ¿Eta pocotsiwa metha jane? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús jume nota, jeye: —Bara xainyei, copiya matha netsiwanaya patopa pon icha be Elías ichi. Mataʉtano bapon cana exana jiwitha xua jiwi cana jʉntʉ coyene weta exanaya exanatsi xua tana nejume cowʉntsiwa tsane xua tapatopaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ichitha xan paca tsipaebatsi xua bayatha apara patopa pon copiya matha netsiwanaya patopa pocotsin xua icha Elías ichi. Poxonae bapon bayatha patopeica jiwi jopa yaitaeyo bapontha pon icha Elías ichi. Saya barapo jiwi bapon abe cana exanatsi be pocotsi coyeneya ichichipa beya poxonae bapon yatsicaya bexotsi. Icha bapon ichichi xua poxonae cana exanatsi, barapomonae bara neichi tsane ponxaein Nacom Tananeitapetsin. Barapomonae irʉ nebexubina, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesús pijimonae tatsi matapainya yaputane xua poxonae Jesús pijimonae tsipaeba Elías yabara, apara xua Juan yabara paebatsi pon jiwi Pebautisabin. ");
INSERT INTO cui_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Poxonae demxuwa weya pona, bapoxonae Jesús pijimonae barʉ patopa ichaxota pin bicheito jiwi jinompa. Bapoxonae pebin Jesús imoxoyo caquita uncatabatsi. Bapon pentabocototha uncua Jesús peitabaratha tatsi. Bapon Jesús baraichi, jeye: ");
INSERT INTO cui_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tanecanamataxeinaem, inta taxanto yabara najʉntʉ coyene xeinare xua jinya neyawenaenexa. Taxanto inta waetabatsi cauri. Inta papai exanatsi. Inta coibo thamthamei exanatsi. Matayaiba exanatsino. Mataʉta isototha inta bebai tsaibichino. Mataʉtano mentha inta bebai tsaibichino. ");
INSERT INTO cui_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Bequein barapo taxanto xote caponanje jinyamonaetha yawa janje: ‘Painta taxanto taitawere cauri’, jan, daichitha jopa itacʉpaetsi xua taxanto petaitawetsinexatsi cauri, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús namchi daxita barapomonaetha, jeye: —¡Paxam barapomonae pam pomonae jopa xapain cataunxuae pana nejume cowʉntsim! ¡Paxam barapomonae pam, peajʉntʉcoyenebe jiwi pam! ¿Eta po weibe nantawenonan xua bewa tapaca barʉ ecaewatsi tsainchi xua beya poxonae tapana nejume cowʉntsiwam tsane? Mataʉtano ¿eta po weibe equeicha nantawenonan xua tapaca cayawenaewatsi tsainchi? Inta xawena pewowin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bapoxonae Jesús itaweta cauri, mataʉtano pewowin wepu ponatsi exanatsi. Barapo pewowin nainya axaibi tsuxubi. ");
INSERT INTO cui_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bapoxonae pirapaeyo Jesús compa tsipaebatsi pijimonae. Jesús jeichichi: —¿Eta pocotsiwa metha jopa pana neitacʉpaeyo xua pata taitawetsiwa cauri? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús jume barai pijimonae jeye: —Jopa paca itacʉpaeyo xua painya itawetsiwa cauri tsipei jopa beta payabara jume cowʉntsim xua Nacom painya nepaca cayawenaewa. Bara xaniyeya paca tsipaebatsi. Icha paxeinaetsipame xua be peya pejume cowʉntsi coyenewiyo xua bequein, icha mostaza xutiyo jʉta ichi xua tsica xutiyo, ichitha bara paca itacʉpa xua urutotha painya nejeiwa: ‘Uruto bara jincoutha natabʉ jonde, icha ira beya naxore’, xua painya nejeiwa. Bara jopa bayathiyo tsipae barapo uruto. Dapocotsiwa apara pacata aibi, pocotsiwa peayapubeya daunweiwa icha paxeiname tapana nejume cowʉntsiwam xua peya jume cowʉntsiwiyo. ");
INSERT INTO cui_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Barapo cauri saya paca itacʉpa xua painya neitawetsiwa poxonae matha payabara nainbotame mataʉtano poxonae matha Nacomtha matowa pawʉcame, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Poxonae cataunxuae Jesús pijimonae barʉ popona Galilea nacuatha, pijimonae tsipaeba, jeye: —Xan ponxaein Nacom Tananeitapetsin, jiwi necaenaetsina ichamonaetha. ");
INSERT INTO cui_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Bapoxonae bequein nebexubina, ichitha poxonae acoibi po matacabiyobe yapucaewina Nacom equeicha tatʉpaein asʉ neexanaena, jei Jesús. Bichocono Jesús pijimonae tatsi anthʉthʉtane, xua poxonae Jesús pejume taexaetsi poxonae baxua paeba. ");
INSERT INTO cui_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús barʉ patopa pijimonae Capernaum tomaratha. Bapoxonae pomonae paratixi penoteibiwi po paratixi judiomonae bewa catsibeibina xua Nacom pin pia bo nexa, barapomonae Pedro pexainya beya taponatsi. Barapomonae Pedro yainyabatsi, jeichichi: —¿Pon painya nepaca cuidubin, bapon bepa pana catsei paratixi xua Nacom pin pia bo nexa? jei. ");
INSERT INTO cui_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro jume nota, jeye: —Aa, bepa paca catsei, jei Pedro. Poxonae Pedro botha joniya, Jesús copiya barai bapon, jeye: —Simón, ¿eta be caita cui jicha? Barapo cae pin nacuathe, ¿eta po jiwi wʉcatsi paratixi, po paratixi xua jiwi bewa catsibeibina pomonaetha pomonae jiwi itorobiya pia pepa peewatsiwichi poxonae pomonae jiwi itorobiya pia pepa peewatsiwichi wʉca? ¿Metha bara piamonae matabʉxʉ wʉca? Ichacuitha, ¿metha bara ichamonae wʉcatsi pomonae penanapaincha jinompaewi xua icha nacua werena peponaewi? ¿Eta pomonae cuita wʉcatsi? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro Jesús jume notatsi, jeye: —¡Apara jame wʉcaetsipa ichamonaetha! jei Pedro. Equeicha Jesús jume nota, jeye: —Nexata barapomonae jopa wʉcaeyo piamonae matabʉxʉyo. ");
INSERT INTO cui_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Barichin jopa bewa Taxa catsin tsane paratixi, yaitama tsipei apara Taxa Pexanton tatsin. Ichitha xua barapomonae jopa wanaca casebinexa, matha mene beya ponde. Curupobo xoyama mentha bapoxonae po duwein copiya wana pichina curupobo, pire barapo duwein. Bapoxonae barapo duwein coiboto tsina paratiyo taename po paratiyo xua naca yajʉpabe xua wamatomatsiwabe tsane Nacom pin pia bo nexa. Bapoxonae barapo paratiyo caponde pomonae paratixi penoteibiwi beya bara careno, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nexata bapoxonae Jesús imoxoyo caquita umenarʉcʉpatsi pijimonae, yawa pijimonae yainyabatsi, jeichichi: —¿Jintam paxan jiwana pan pon bichocono ainya cui cana exanaeinchi po mataqueitha poxonae Nacom wabina jiwi xua petanaexanaenexatsi pijimonae pomonae itorobiya pecanamataxeinaexae? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nexata Jesús waba pexuyo, yawa pijimonae tatsi peitabarayo deca tatsi tacuaranoreca. ");
INSERT INTO cui_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jesús namchi pijimonaetha, jeye: —Bara xainyeya paca tsipaebatsi bewa paxeinaem icha jʉntʉ coyenewa xua jopa pananta xeinaem peainya cui coyenewa yabara. Barapocotsi jʉntʉ coyenewa pexui ba xeina xua jopa taayapubetsi poxonae nejume cowʉnta. Bewa pananta xeinaem icha pexui ichi poxonae nanta xeina, icha paichichipame xua Nacom painya nepaca wabiwa xua pijimonae tatsi painya nepaca exanaewa pomonae pamxaem Nacom itorobiya paca ewata. ");
INSERT INTO cui_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Po jiton pon najʉntʉ coyene acaura, xua daxota bichocono Nacom canantawenonatsi xua pejume cowʉntsiwatsi, bapon jame ainya cui xua pecana exanaewatsi Nacom pijimonae tatsi jiwanapin pomonae pejume cowʉntsiwichi pomonae Nacom itorobiya peewatsixae. ");
INSERT INTO cui_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pon matenta weyataeya waba peyawenaenexa pontha pon tana nejume cowʉntsixae xua pocotsin icha be barapocotsi pexuyo ichi, barapon apara bara nententa weyataeya waba. Xan jopa meisa nententa weyataeya wabiyo apara bara irʉ matenta weyataeya wabatsi pon tana neitorobixae, xua pon bara Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Nacom tsitatsi xua pebin bichocono abe exana poxonae ichʉn cana exanatsi xua abe peexanae cuiru coyene exana, po barapo ichʉn pon cataunxuae aena tana nejume cowʉntsixae. Metha jame wʉnae tsipae xua barapo pebin pon abeya cana exanaeya taexana ichʉntha, barapon pin iboto wisi cʉtsipatsi yawa xua tuwʉtha xua pin mar mentha barapo iboto cayawa cabutabachipatsino. Tsipei jopa wʉnae tsipae xua bapon cana exana xua ichamonae abe peexanae cuiru coyene exana pomonae cataunxuae aena nejume cowʉnta. ");
INSERT INTO cui_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Maisa bichocono jopa xanepanaeyo barapo cae pin nacuathe nexa pomonae abe exaneiba. Barapo cae pin nacuathepiwi ataya xeineiba po jiwi pecana exanaexaetsi xua ichamonae cana exana xua barapo jiwi pecana exanaexaetsi xua ichamonae cana exana xua barapo jiwi abe peexanae cuiru coyene peexaneibinexa xua daxota jopa nejume cowʉnteibiyo. Ichitha pebin tsocuae xua bapon abe taexana xua ichʉn abe exanaeya taexanaetsi. ");
INSERT INTO cui_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Daxota paca tsipaebatsi icha painya cobe paca exana xua abe painya neexanaewa tsane maisa pana nacobe ucubobare yawa tajʉ beya pana nacobe bebande abe painya jopa neexanaenexa. Tsipei baxua xanepana xua cae cobexi pabebam tsane, xua saya cae cobexi painya neyawa patsiwa tsane Nacom pia nacua beicha tatsi. Baxua jame yatsicaewa xanepana beyacaincha xua ainya cobebe painya necayawa bebai tsane ichaxota po nacuatha isoto jopa itacounayiyo. Mataʉtano icha painya taxu paca exana xua abe painya neexanaewa tsane maisa pana nataxu ucubobare yawa tajʉ beya pana nataxu bebande xua abe painya neexanaeyainwa. Tsipei baxua xanepana xua cae taxuxi pabebam tsane, xua cae taxuxi painya neyawa patsinexa Nacom pia nacua beicha tatsi. Baxua jame yatsicaewa xanepana beyacaincha xua ainya taxube painya necayawa bebai tsane ichaxota po nacuatha isoto jopa itacounayiyo. ");
INSERT INTO cui_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mataʉtano icha pocotsiwa pataneme painya itamaiqueitotha xua icha baxua paca exana xua abe painya neexanaewa tsane painya netaexae painya itamaiqueitotha, maisa pana naitamaiquei jucuare. Yawa tajʉ beya pana naitamaiquei bebande abe painya neexanaeyainwa. Tsipei baxua xanepana xua cae itamaiqueitoxi pabebam tsane, xua cae itamaiqueitoxi painya neyawa patsiwa tsane Nacom pia nacua beicha tatsi. Baxua jame yatsicaewa xanepana beyacaincha xua poxonae ainya itamaiqueitobe painya necayawa bebai tsane ichaxota isoto jopa itacounayiyo”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Equeicha Jesús jeye: “Barapocotsi pexuyo jopa catsa jumeya pacayabara jande: ‘Maisa barapo pexuyo jopa peainya cuiyiyo’, jopa pajande. Mataʉta pomonae aena pejume cowʉntsiwi Nacom jopa pacayabara jande: ‘Maisa barapomonae jopa peainya cuimonaeyo’, jopa pajande. Paca tsipaebatsi pomonae Nacom pejume cowʉntsiwi barapomonae nantaʉta pia matatsunpiwi po matatsunpiwi barapomonae yawenatsi. Barapo matatsunpiwi, Taxa Nacom peitabaratha tatsi tajinompeibatsi pia nacuatheicha, xua barapo pejume cowʉntsiwi peyawenaenexa tsaibi tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tsipei xan, ponxaein Nacom Tananeitapetsin patopeican tayawenaenexa pomonae jopa pejume cowʉntsiwi xua barapomonae napaeba tacana exanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pana nejume naitaeware po pecayabara jʉta pepaebi diwesiyo xua paca tsipaebinchi. Barapo diwesiyo jeye: Jiton ba xeina oveja cien poyobe. Caein tanapuxanatsi. Jiton demxuwatha cuenta pona noventa y nueve poyobe oveja, pewenaweneinexa oveja, pon catsawa jopa, beya matapainya taeba. ");
INSERT INTO cui_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Xaniwaicha paca tsipaebatsi poxonae jiton oveja taeba, bapon bichocono weiweina petaebixae oveja pon catsawa jopa, beyacaincha xua poxonae weiweina poxonae saya noventa y nueve poyobe po ovejamonae jopa catsawa othopaeyo. ");
INSERT INTO cui_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Barichi barapocotsi jʉta coyeneya ichi, Nacom pon Taxa, pon peitabocotha eca, bapon jopa ichichipaeyo xua pebarapentsiwatsi pijiwimonae xua pejume cowʉntsiwatsi mataʉtano xua bara caeinno irʉ, pomonae aena pejume cowʉntsiwixaetsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Equeicha Jesús barai pijimonae, jeye: “Icha ichʉn pon irʉ pejume cowʉntsindʉ, icha bapon pacata abe exana, bapon baxua yabara patsipaebare xua bapon peyaputaewa tsane xua deta cou abe exana. Icha barapon paca jume taeya jejei tsane pocotsiwa xua bapon abe exana bara bapoxonae paca itacoxonaena. ");
INSERT INTO cui_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ichacuitha icha ichʉn pon pejume cowʉntsindʉ, icha bapon jopa paca jume cowʉntsiya jejeyo, bara nexata equeicha pawabare pebinbe nacueyatabe xua yoroba painya netsipaebinexa bapon xua abe peexanaexae. ");
INSERT INTO cui_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ichitha icha awiya bapon jopa cataunxuae paca jume cowʉntsiya jejeyo, bara nexata barapon pacaponde pomonaetha pomonae Nacom pejume cowʉntsiwichi, xua barapomonae bapon peyabara paebinexatsi. Icha bapon awiya cataunxuae jopa came jume cowʉntsiya jejeyo barapomonaetha barapoxonae barapomonae bewa yabara nanta xeinae xua bapon bara be pocotsi jiton pon jopa bapana pejume cowʉntsin Nacom. Ichacuitha bewa yabara nanta xeinae xua bapon bara be pocotsi jiton jiwana, pomonae peajʉntʉcoyenebewi, pomonae paratixi pentoma noteibiwi, po paratixi jiwi bewa catsibeibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. ");
INSERT INTO cui_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Xainyeya paca tsipaebatsi. Pocotsiwa paxam jopa pacopatsim barapo cae pin nacuathe xua pocotsiwa exana pomonae tana nejume cowʉntsiwi, bapocotsiwa bara irʉ Nacom jopa copatsiyo pia peitorobi nacua beicha xua barapomonae peexanaewa tsane baxua. Pocotsiwa pacopatame xua tajiwimonae peexanaenexa barapo cae pin nacuathe bapocotsiwa irʉ Nacom copata pia peitorobi nacua beicha xua barapomonae bara peexanaewa tsane baxua. ");
INSERT INTO cui_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mataʉtano paca tsipaebatsi icha paxam jiwana nacueyatabe barapo cae pin nacuathe icha baponbe pebʉrʉya jʉpaya yabara nanta xeinabe xua Nacomtha pewʉcaewabe, baponbe bara baxua taexanaeinchibe pocotsiwa pewʉcaexaebe xua Taxa Nacom bara taexanaena pon peitabocotha eca. ");
INSERT INTO cui_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsipei ichaxota ba nayantabe xua nacueyatabe poyobe, xua poxonae pewʉcaenexabe Nacom xua ichacuitha ichaxota acoibi poyobe, xua pomonae taneantobe jiwixae, bara bequein saya caeyobe daichitha xan baxota ba uncueiban irʉ”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nexata Pedro Jesús yainyabatsi, jeye: —Tanecanamataxeinaem, icha inta abe exana pon irʉrʉ jume cowʉnta, ¿eta po cuiyobe tsipaebocuaein xua bewa tacui yabara jʉntemainaewa tsane pocotsiwa inta abe exana? ¿Metha saya beya poxonae siete po jume cuiyobe tsipae? jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús jume nota, jeye: —Ichitha jopa catsipaebichi xua saya siete po cuiyobetham netsipaebiwa tsane xua jinya necui yabara jʉntemainaewa tsane pocotsiwa cata abe exana. Seicaya apara jame catsipaebatsi, xua jopa cuinaya najume baraxubim tsane xua jinya necui yabara jʉntemainaewa tsane pon cata abe exana xua beya bequein jame cuatrocientos noventa po cuiyobetham tsane xua netsipaebiwa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Equeicha Jesús pijimonae barai pecayabara jʉta pepaebi diwesiyo, jeye: “Anoxuae paca cuidubatsi xua Nacom yabara. Nacom pijimonae bichocono yabara jʉntemaina po abe peexanae coyenein pijimonae tatsi exana. Nacom baxua exana icha pebin ichi pon jiwi itorobiya pia pepa peewatsinchi. Bapon wʉca xua caewa equeicha pematomatsinexatsi xua po matoman caena bayatha penacowaebixaetsi. ");
INSERT INTO cui_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pon jiwi itorobiya pia pepa peewatsinchi tamropata pitaba xua waba pia petanacuichiwichi. Pon copiya, bapon pon jiwi itorobiya pia pepa peewatsinchi jopa equeicha caewa tacanawitichi diez millones po paratiximonaebe. ");
INSERT INTO cui_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Barapon pon copiya pon petanacuichinxae pon jiwi itorobiya pia pepa peewatsinchi nexa jopa xeinaeyo paratiximonae xua pon jiwi itorobiya pia pepa peewatsinchi caewa petacanawichinexa tsainchi. Daxota pon jiwi itorobiya pia pepa peewatsinchi itoroba ichʉntha xua barapo petanacuichinchi caenaetaxubinchi ichʉntha xua ichʉn pecomotsinexa tsane xua pon pebusi cui taetaeinchi pecanaexanaenexa tsainchi. Barapon pon jiwi itorobiya pia pepa peewatsinchi mataʉta cui itoroba xua yabʉyo pecaenaetsinexa tsainchino, powa barapo petanacuichin piowa tatsi. Yawano cui itoroba xua pexuino pemuxuna caenaetsinexa tsainchi. Yawano cui itoroba xua pemuxuna caenaetsinexa pocotsiwan xeina pon petanacuichin, xua barapo matoma pecatsinexatsi pon jiwi itorobiya pia pepa peewatsinchi. Ichitha daxita barapo matoma awiya seica, bequein bapon daxita baxua cana exanaetsipatsi. ");
INSERT INTO cui_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nexata pon petanacuichin pentabocototha uncua pon jiwi itorobiya pia pepa peewatsinchi itabaratha tatsi mataʉtano jume daunweya namchiya jeye: ‘Tanentacaponaem, abʉ necayabara najʉntʉ coyene xeinare, xua jopa bepijawa neaitaconaenexa. Barapara bexa daxita pentoman cacatsibinchi’, jei pon petanacuichin. ");
INSERT INTO cui_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pon jiwi itorobiya pia pepa peewatsinchi bara yabara najʉntʉ coyene xeina peyawenaenexa, yawa yabara jʉntemaina barapo paratiximonae, mataʉtano bara saya pu copata. ");
INSERT INTO cui_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Daichitha bapon pon petanacuichinxae poxonae pontaba pon jiwi itorobiya pia pepa peewatsinchi weya, jemeicha caxina pia jiton pon penabarʉ nacuichinxaebe. Pon caxinatsi bapon matoma amanayaba saya cien po paratiximonaebe. Pon jiwi itorobiya pia pepa peewatsinchi weya pona matoma amanayabatsi. Pon jiwi itorobiya pia pepa peewatsinchi weya pona bapon pia jiton coibotathʉ waetaba, muxu penaichatabi. Pon pecoibotathʉ waetabixae bapon jei: ‘¡Equeicha inta caewa canawire xua bayatha nentoma amanayabame!’ jei. ");
INSERT INTO cui_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Bapoxonae pon coibotathʉ waetabatsi pentabocototha uncua pia jiton itabaratha tatsi, mataʉtano jeye: ‘Abʉ, neyabara najʉntʉ coyene xeinare, xua jopa bepijawa neaitaconaenexa. Barapara bexa pentoma cacatsinchi’, jei pon coibotathʉ waetabatsi. ");
INSERT INTO cui_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ichitha pon jiwi itorobiya pia pepa peewatsinchi weya pona bapon aichaxaibi xua abʉ came pentoma ewatsiwa. Daxota bapon pia jiton capona jiwi pecʉbi bo beya, beya abʉ poxonae matoma catsinchi pia jiton, xua pon jiwi itorobiya pia pepa peewatsinchi weya pona matoma catsinchi. ");
INSERT INTO cui_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Poxonae ichamonae pomonae irʉrʉ petanacuichiwi baxua cui tane, barapomonae ʉnthʉthʉ wecoyei, tsipei ichʉn pon irʉ petanacuichin jiwi pecʉbi botha etatsi. Bapoxonae barapomonae pon jiwi itorobiya pia pepa peewatsinchi beya pona. Barapomonae tsipaeba pontha pon jiwi itorobiya pia pepa peewatsinchi daxita pocotsiwa pon petanacuichin cana exana ichʉntha pon irʉrʉ petanacuichin. ");
INSERT INTO cui_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bapoxonae pon jiwi itorobiya pia pepa peewatsinchi itoroba pijimonae xua petawabinexa tsainchi pon petanacuichinxaetsi pontha xua pon peyabara jʉntemainaexae pocotsiwa penacowaetsixaetsi. Pon jiwi itorobiya pia pepa peewatsinchi bapontha jeye: ‘¡Maisa pon inta nacuitame maisa bichocono abem! Xan cayabara jʉntemainatsi daxita barapo ainya paratiximonae tsipei tanebarʉ jumichimxaem. ");
INSERT INTO cui_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Xam bewa bayatha barichim. Bewa yabara najʉntʉ coyene xeinaem jinya jiton xua nejʉntemainaenexa pocotsiwa bapon cantoma amanayaba, icha xan ichin xua bayatha cayabara najʉntʉ coyene xeinatsi tacayawenaenexa tsainchi’, jei. ");
INSERT INTO cui_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pon jiwi itorobiya pia pepa peewatsinchi bichocono anaepana. Daxota bapon cui itoroba ichamonae, xua barapon pon petanacuichinxaetsi caponaeinchi jiwi pecʉbi bo beya. Baraxota peraxa exanaeinchi xua beya abʉ poxonae barapon pon petanacuichinxaetsi matoma catsinchi daxita po pentoma bayatha jopa caewa petacanawichixaetsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Equeicha Jesús jeye: —Bara jʉta coyeneya ichi tsane icha be pon jiwi itorobiya pia pepa peewatsinchi ichi. Poxonae bapon peraxa exana barapo pia petanacuichinxaetsi xua bapon pia jiton jopa pecui yabara jʉntemainaexae, Nacom pon itaboco peecaein barichi tsane pijiwitha. Nacom exanaena baxua poxonae barapomonae jopa xapain yabara jʉntemainaeyo pomonaetha pomonae abe petaexanaexaetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Poxonae Jesús najume weta xua tsipaeba pijimonae, bapoxonae Galilea nacua weya warapa. Bapoxonae Jordán mene deca bara bereca pona, equeicha dabeya barapo Jordán mene, mene epa ʉncatabiya xua patopa Judea nacuatha, po nacua eca ichaxota pocotsiwa xometo bejopiya xua po nacua Jordán mene weya eca. ");
INSERT INTO cui_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pin bicheitomonae puna poinchi. Baxotiya Judea nacuatha Jesús axaibi exana peatenewi. ");
INSERT INTO cui_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bapoxonae fariseomonae piraichi Jesús imoxoyo caquita umenarʉcʉpatsi xua Jesús pejuntʉ coyene jʉjʉtsinexatsi daxota jeye Jesustha: —¿Moisés pia peitorobi coyenewa copata xua pebin piseuri pepunaxubiwa ichi saya poxonae ichipa? jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús fariseomonae jume notatsi, jeye: —¿Jopa payorobim Nacom Pejume Diwesi? Barapo diwesitha jeye: ‘Poxonae aena Nacom forota, Nacom forota pebin yawa forota petsiriwa’, jei barapo Nacom Pejume Diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mataʉta jeyeno Nacom Pejume Diwesitha: ‘Daxota baxuaxae pebin paxa wepu natsata yawa pena wepu natsata xua piowabe imoxoyo penaperʉ nacoyobinexabe. Baraponbe be cae jiwimonae naexanabe’, jei Nacom Pejume Diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bapoxonae baponbe xua ainya jiwibe aibi, bara be caein naexanabe. Daxota pebin bapana jopa bewa punaxubi piowa, tsipei apara bayatha Nacom cana exana xua bara be bara caein naexanabe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nexata fariseomonae Jesús yainyabatsi, jeye: —¿Eta xua metha Moisés pia peitorobi coyenewa copata xua jiton itacʉpatsi xua pecatsiwa papera piseuri po paperatha tina xua pexubiwa tsane piseuri? jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús jume nota, jeye: —Moisés copata xua paxam painya seuriwi painya nepunapenteibiwa jopa painya nejume cowʉntsi jiwixae Nacom. Apara caena bayatha Nacom jopa baxua copatsiyo poxonae aena foforatapona jiwi. ");
INSERT INTO cui_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nama paca tsipaebatsi pon piowa punaxuba xua poxonae yabʉyo bequein jopa nasi cui exanaeyo ichʉntha, icha bapon ichowa pita, bapon abe exana Nacom peitʉtha tatsi tsipei Nacom tsitatsi xua powa copiya barʉ popona apara bara piowa tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nexata Jesús tsipaebatsi pijimonae, jeye: —Icha Nacom jopa copatsiyo xua pebin piowa punaxubina poxonae barapowa saya ʉ exana pocotsiwa pebin aichaxaibi, baxua bichocono ajumeyapube. Metha nexata pebin jopa jitha ecaetsipae. Bara saya pebin metha misa ecaetsipa, jeichichi Jesús pijimonae. ");
INSERT INTO cui_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús barai pijimonae, jeye: —Daxita jiwi ba jopa itacʉpaetsi xua peyabara yaputaewa pocotsiwa aunxuae payabara caunutame xua jopa jitha peenaewa. Saya meisa pomonae Nacom yabara yaputane exana barapo coyene, barapomonae itacʉpatsi xua pecana exanaewa barapo coyenetha xua jopa jitha peenaewa. ");
INSERT INTO cui_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Barichi acoibi po cui coyenewabe xua pebiwi jopa penotsiwa pecotsiwaxi jiwi. Ichamonae aichaxaibi xua jitha peenaewa tsipei barapocotsi jiwimonae bara yacuiya naexana xua jopa penotsiwa yabʉxitha. Ichamonae jopa itacʉpaetsi xua pecotsiwaxi penotsiwa tsipei bayatha tobʉ jucuatsi, xua ichamonae tobʉ jucua. Daxota jopa itacʉpaetsi xua pexui pecanaexanaewa. Ichamonae aichaxaibi xua pecotsiwaxi nota, peichichipaexae xua saya ʉ peexanaewa pocotsiwa Nacom itoroba. Pon itacʉpatsi xua peyabara yaputaewa xua pocotsi coyene jopa pepichiwa pecotsiwa, bara moya jopa exanae tsane xua pepichiwa tsane pecotsiwa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nexata jiwi Jesús tacaponatsi pexui xua Jesús pejayabinexa pecobetha yawa xua Nacomtha pewʉcaenexa barapo pexui nexa xua pejeinexa: “Barabʉ Nacom beta paca yawenaena”, pejeinexa. Ichitha Jesús pijimonae tatsi poxonae baxua tane, tamropata notarʉcʉpa xua barapomonae cui matawentatsi pomonae pexui carendena tsaibi. ");
INSERT INTO cui_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ichitha Jesús jume barai pijimonae, jeye: —Bara pacopabare pexui xua tana itata patsinexa. Jopa pexui paitawetsinde, tsipei Nacom pia peitorobi nacua tatsi saya meisa barapomonae nexa pomonae pejʉntʉ coyene xanepanaewi icha pexui ichi. Pexui pia cui xua tayapu xanepanatsi xua pia jʉntʉ coyeneintha jume cowʉnta Nacom, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Poxonae Jesús nacobe weta xua pexui jayabatsi yawa xua Nacomtha tawʉca barapo pexui, xua jeye: “Barabʉ Nacom beta paca yawenaena”, jei. Bapoxonae Jesús wepu pona barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pewowin pona xua Jesús petaenexatsi. Barapo pewowin jeye Jesustha: —Ja Tanecuidubim, maisa nejʉntʉ coyene xanepanaem. ¿Eta xua copiya matha exanocuaein xua ajʉntʉyapusʉya tapoponaewa tsane xua ataya tsane? jei. ");
INSERT INTO cui_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús jume barai, jeye: —¿Eta xua nebaram: ‘Nejʉntʉ coyene xanepanaem’, jam? Apara ichʉn dapon aibi pon pejʉntʉ coyene xanepanaein. Jame meisa apara bapon Nacom compa pejʉntʉ coyene xanepanaein. Icha ichichipame xua ajʉntʉyapusʉya nepoponaewa xua ataya tsane, moya matha exande pocotsiwa Moisés itoroba pia peitorobi jume coyenewantha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Pewowin Jesús jume baraichi jeye: —¿Eta po peitorobi jume coyenewara? jei. Jesús jume notsiya namchi xua Moisés pia peitorobi coyenewa namchi, jeye: —‘Jopa ichʉn bexubinde. Jopa ichowa pichinde ichʉn piowa tatsi. Jopa caibinde ichʉn piawan tatsi. Jopa naerabiya cayabara paebinde pocotsiwa ichamonae exana. ");
INSERT INTO cui_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Axatha barʉ jume cui itura jinare. Antobeinde necatsicuarabʉ enaewi icha ichim xua jincoutha naantobem’, jei Moises, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pewowin Jesús jume baraichi, jeye: —Daxita caena bayatha barapo coyenein exaneiban. Poxonae pexuyothan tamropata pitaban, beya anoxuae yacuiya pinyon. ¿Eta pocotsiwa meisa inta acoibi xua exanaein? jei barapo pewowin. ");
INSERT INTO cui_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús jume barai, jei: —Cataunxuae icha cui coyene cata seica xua pocotsiwa neexanaewam tsane. Icha ichichipame xua jopa necata acoibiyo nexa tsane xua pocotsiwa xanepanaya neexanaewa, matha daxita caenaere pocotsiwa xeiname yawa catsibare pomonaetha pomonae peacopeibi jiwi. Bapoxonae jame moya anetha, nepuna ponde. Bequein bara bapoxonae acopeibim tsane, daichitha Nacom cacatsina peitaboco beicha pocotsiwa Nacom necajʉntana botsiwa pocotsiwa bichocono wʉnae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Poxonae barapo pewowin baxua jume taeba bichocono ʉnthʉthʉ wecoyeya ponataba tsipei bichocono copei pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nexata Jesús barai pijimonaetha, jeye: —Bara xaniyeya paca tsipaebatsi. Maisa bichocono ayapubecai xua pomonae bichocono copei pexeinaewi naexana Nacom pijimonae tatsi jiwana pomonae Nacom itorobiya peewatsixae. Tsipei barapomonae bichocono antasiwayatane barapo pia copei beyacaincha xua Nacom antobetsi. ");
INSERT INTO cui_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Equeicha paca tsipaebatsi. Bichocono acuiruyapube xua duwein pon pewʉn camello xua pejoniyaewa acuicheto peetabʉ wan iya. Ichitha nama yatsicaewa pon bichocono copei pexeinaein taacuiruyapubetsi xua naexana Nacom pijimonae tatsi jiwana pomonae Nacom itorobiya peewatsixae beyacaincha xua poxonae acuiruyapube xua poxonae camello acuicheto peetabʉ wan iya pejoniyaewa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Poxonae baxua Jesús jume taerʉcʉpatsi pijimonae, barapomonae yabara najʉntʉ cui coyene cabenaeca, yawa Jesús jeichichi: —Bapoxonae ¿jintam metha nexata itacʉpatsi xua penacapanepaewa pia coutha? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús necotsiya jeye: —Pebiwi ba jopa itacʉpaetsi xua baxua exana, saya jame meisa Nacom compa itacʉpatsi xua jiwi napaeba cana exanatsi. Tsipei daxua ajibi pocotsiwa Nacom taacuiruyapubetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nexata Pedro jeye Jesustha: —Pata Tanecanamataxeinaem, paxan daxita pacuenta ponan pocotsiwa paxeinan pata paca puna ponaewa tsainchi. Tsipei baxua bayatha paexanan ¿eta pocotsiwa metha nexata pana necatsiname? jei. ");
INSERT INTO cui_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús jume nota, jeye: —Bara xaniyeya paca tsipaebatsi. Po mataqueitha tsane Nacom pena ira exanaena, barapo mataqueitha, xan ponxaein Nacom Tananeitapetsin ecaein tapexeinya itʉpanae ecaethopaewatha po tapexeinya itʉpanae caecaethopaewa bichocono itʉpana. Paxam pomonae tapana nepuna jinompaewim doce po itʉpanae eneibithopeibiwatha paenaename painya yabara paebinexam tsane pomonae doce po matabʉxʉyobe israelmonae pia penatsicuentsiwa abe peexanaexae. ");
INSERT INTO cui_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Daxita pomonae taneantobe jiwixae xua pecueicueijei tsurubenanaebiyaenexa Nacom Pejume Diwesi, Nacom beta cana exanaena barapomonae. Nacom beta cana exanaena pomonae pia bon pecuenta ponaexae, mataʉta ichacuitha ichamonae peweicho jiwi pecuenta ponaexae, mataʉtano ichacuitha pamcho jiwi pecuenta ponaexae, mataʉtano ichacuitha paxeiwi pecuenta ponaexae, mataʉtano ichacuitha pena jiwi pecuenta ponaexae, mataʉta ichacuitha pia pexui pecuenta ponaexae, mataʉtano ichacuitha pia iran pecuenta ponaexae. Barapomonae barapo coyenein exana tana neantobe jiwixae, daxota daxita barapomonaetha Nacom jopa juniya catsi tsane barapo cae pin nacuathe. Mataʉtano barapomonaetha Nacom catsina pia peitorobi nacuatheicha peajʉntʉcoyeneyapusʉwa, po peajʉntʉcoyeneyapusʉwa ataya tsiteca. ");
INSERT INTO cui_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pomonae xua anoxuae pomonae jiwi petsita ainya cui jiwichi po cae pin nacuathe, barapomonae bexa Nacom pia peitorobi nacuatheicha jopa peainya cui jiwi tsane. Pomonae xua anoxuae pepawi naexana, pomonae jiwi jopa petsita ainya cui jiwichi po cae pin nacuathe, barapomonae Nacom pia peitorobi nacuatheicha peainya cui jiwi tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Equeicha Jesús tsipaeba pijimonae pecayabara jʉta pepaebi diwesiyotha, jeye: “Nacom pijimonae matomatsina pia nacuatheicha xua be pematomatsiwa petaexanaexaetsi pia petanacuichiwa tatsi icha pon pabi pexeinaein ichi xua poxonae matoma catsiba pomonaetha pomonae petanacuichixaetsi. Pon pabi pexeinaein caemʉmbotha pona xua jeita pomonae pia petanacuichinexa tsainchi pia uva bacabo. ");
INSERT INTO cui_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Bapon muxu tsipaeba pia petanacuichiwichi, jeye: ‘Paxam painta nacuire ta uva bacabo, nexata paca matoma catsibebinchi pocotsi paratiyo xua caentaqueitha nexa’, jei. Bapoxonae bapon pia petanacuichiwichi itoroba pia uva bacabo beya. ");
INSERT INTO cui_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bapoxonae equeicha bapon pona poxonae xometo tajʉ beequeina xua pejeichinexa ichamonae pomonae petanacuichiwichinexa tsainchi pia uva bacabo. Bapoxonae bapon tane ichamonae, pomonae panatha saya jinompa xua jopa nacuitompaeyo. ");
INSERT INTO cui_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Bapon barai barapomonae jeye: ‘Paxam irʉrʉ painta nacuire ta uva pabi. Nexata beta paca matoma catsibinchi, xua pocotsi paratiyo po horatha panacuitame nexa’, jei. Bapoxonae barapomonae pona pabi beya penacuichinexa. ");
INSERT INTO cui_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Bapon mateinyaxae equeicha pona xua pejeichinexa ichamonae pomonae pia petanacuichiwichi tsainchi. Barichi equeicha poxonae tabopiya pona xua pejeichinexa ichamonae pomonae pia petanacuichiwichi tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bapon equeicha pona pana beya poxonae xometo iriya ducuanaicha xua pejeichinexa ichamonae pomonae pia petanacuichiwichi tsainchi. Bapon equeicha tane ichamonae pomonae xua jopa irʉ nacuitompaeyo. Bapon barai barapomonaetha, jeye: ‘¿Eta xua metha came saya anoxuae paumename po panathe, xua jopa panacuitompaem?’ jei pabi pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Barapomonae jume nota, jeye: ‘Canta dapon aibi pon pata tana neitorobiwa tsane’, jei. Nexata bapon barai barapomonae, jeye: ‘Paxam paponare, irʉrʉ painta nacuire ta uva pabi, nexata beta paca matoma catsibinchi xua pocotsi paratiyo po horatha painya nenacuichixae tsane’, jei pon pabi pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Poxonae quirei tsanaicha pon pabi pexeinaein, bapon itoroba pon pia petayapucaecaeinchi uva pabi, jeye: ‘Inta wabare pomonae inta nacuita yawa matoma catsibare. Tamroropata wabaponde yawa matoma catsibaponde. Copiya matha wabare pomonae opi dubena pomonae inta cotacaya nacuita poxonae xometo iriya ducuanaicha, beya poxonae papataponaena pomonae copiya inta nacuita caemʉmbotha’, jei. ");
INSERT INTO cui_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nexata copiya pata pomonae cotacaya nacuita poxonae xometo iriya ducuanaicha. Daxita barapoyobe pomonae cotacaya nacuita bara beta matoma catsibatsi xua pocotsi paratiyo caentaqueitha nexa, bequein bara jopa pin mataqueitha nacuichiyo. ");
INSERT INTO cui_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nexata bara irʉ bapoxonae pata pomonae tamropata notarʉcʉpa xua nacuita poxonae tabopiya, bara barapomonae irʉ beta matoma catsibatsi pocotsi paratiyo caentaqueitha nexa. Bapoxonae irʉ pata pomonae tamropata notarʉcʉpa xua nacuita poxonae mateinyaxae, bara barapomonae irʉ beta matoma catsibatsi, pocotsi paratiyo caentaqueitha nexa. Bapoxonae irʉ pata pomonae tamropata notarʉcʉpa xua nacuita poxonae xometo tajʉ beequeina, bara barapomonae irʉ beta matoma catsibatsi, pocotsi paratiyo caentaqueitha nexa. Bapoxonae irʉ nama pata pomonae tamropata notarʉcʉpa xua nacuita caemʉmbotha. Barapomonae najei: ‘Metha equeicha mataropeichiya naca catsibina paratixi tsipei nacuitatsi caemʉmbotha’, najei barapomonae. Daʉmetha barapomonae saya matoma catsibatsi, pocotsi paratiyo caentaqueitha nexa. ");
INSERT INTO cui_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ichitha poxonae barapomonae matoma nota, itaconacarʉcʉpa pontha pon peitorobixae barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Barapomonae anaya jei bapontha: ‘Pomonae nacuita cotacaya, saya cae horatha nacuita, barapomonae matoma catsibame pocotsi matoma pana catsibame. Nama apara paxan daunweya panacuitan, yawa atsatha daunweya panacuitan’, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ichitha pon pabi pexeinaein jume nota caeintha barapomonae jiwanapintha, jeye: ‘Tajiton, apara jopa bara abe pacata exanaetsi. Canaunxuae paca muxu tsipaebatsiba paca jeichi: Paca matoma catsibinchi xua pocotsi paratiyo caentaqueitha nexa, paca jeichi. ");
INSERT INTO cui_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Bara jinya matoma pire. Bara nawiyama. Xan ichichipan tacoya matoma catsiban pomonae quiripitha nacuita barapocotsi matoma, pocotsi matoma jʉpa paca catsibatsi. ");
INSERT INTO cui_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Apara xan tawaxae itacoxonan xua tantoma exanaewa. Apara pauwame ichamonae xua jopa taasiwaxae xua tantoma exanaewa ichamonaetha’, jei pon pabi pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Nacom barapocotsi jʉta coyeneya cana ichi tsane jiwitha icha pon pabi pexeinaein ichi poxonae cana exana pomonaetha pomonae pia petanacuichiwichi. Pomonae xua anoxuae pepawi naexana, pomonae jiwi jopa petsita ainya cui jiwichi po cae pin nacuathe, barapomonae Nacom pia peitorobi nacuatheicha peainya cui jiwi tsane. Pomonae xua anoxuae pomonae xua jiwi petsita ainya cui jiwichi po cae pin nacuathe, barapomonae bexa Nacom pia peitorobi nacuatheicha jopa peainya cui jiwi tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bapoxonae pirapae Jesús pona Jerusalén tomara beya. Poxonae cataunxuae Jesús pijimonae barʉ ecapona namtotha pomonae doce poyobe tatsi, barapo doce poyobe Jesús meisa waba aisowa beya petsipaebinexa. ");
INSERT INTO cui_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Jesús jeye: —Anoxuae ponaeinchi Jerusalén tomara beya. Barapo tomaratha xan ponxaein Nacom Tananeitapetsin necaenaetsina sacerdotemonae pia pentacaponaewitha tatsi yawa pomonaetha pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Barapomonae necaenaetsina ichamonaetha xua ichamonae tana nebexubiwa tsane. ");
INSERT INTO cui_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Bapoxonae daxita barapomonae necaenaetsina pomonaetha pomonae penanapaincha jinompaewi xua icha nacua werena peponaewi xua barapomonae tana necui caponaenexa. Mataʉtano barapo penanapaincha jinompaewi nebena yawano tʉparucua neexanaena naetotha. Daichitha poxonae acoibi po matacabibe yapu jopaena equeicha Nacom asʉ neexanaena petʉpae cuiru coyene weya, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nexata petsiriwa Jesús imoxoyo caquita uncuatabatsi. Barapowa, Juan pena tatsi yawa Santiago pena tatsi. Juan irʉ Santiago, baponbe Zebedeo pexantobe tatsi. Barapo petsiriwa pexantobe barʉ patopa Jesustha. Barapo petsiriwa pentabocototha uncua Jesús peitabaratha tatsi, xua Jesús pewʉcaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús barai bapowatha, jeye: —¿Eta pocotsiwa jinya newʉcaetsi? jei. Bapowa Jesús jume notatsi, jeye: —Poxonae matacabi patopaena po mataqueitha itorobiya ewatsiname jiwi barapo mataqueitha cawʉcatsi xua bara itorobiname barapo taxantobe, xua nantiyabe peecaewa tsanebe xamtha, xua ichʉn necoxa weya peecaewa tsane, xua ichʉn netsocona weya peecaewa tsane, jei. ");
INSERT INTO cui_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ichitha Jesús baraibe baraponbe, jeye: —Paxambe jopa payaputaembe xua pocotsiwa pana newʉcaenamebe. Poxonae ichamonae abe inta exanaena bara saya copatsin xua barapomonae bara neperaxa jʉbina. Barichi poxoru paxambe pana neantobem, ¿bara irʉ paca itacʉpabe xua bara pacopatsinamebe xua bara ichamonae paca peraxa jʉbinabe? Barichin bara saya copatsin xua ichamonae bara tʉpa neexanaena. Barichi, ¿bara irʉ paca itacʉpabe xua bara pacopatsinamebe xua bara ichamonae tʉpa paca exanaenabe? jei Jesús. Santiago peweichobe jume notabe, jeibe: —Aa, bara pana itacʉpabe, jeibe. ");
INSERT INTO cui_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús jume nota, jeye: —Bara bara xainyei barapocotsi coyene ichamonae paca cana exanaenabe. Ichamonae paca peraxa exanaenabe. Mataʉtano tʉpa paca exanaenabeno icha xan necana ichi tsane. Nama xua xantha nantiya paecamebe xua ichʉn pocotsiwa tacoxa weya eca, yawa xua ichʉn tatsocona weya eca, baxua jopa tacoya yabara itorobinyo. Saya jame Taxa Nacom meisa baxua taexanaena pomonaetha pomonae caena bayatha tsiwʉnaeta xua peenaewa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesús pijimonae pomonae umena, pomonae diez poyobe jume tane xua Santiago irʉ Juan Jesús wʉcatsibe. Bapoxonae barapo diez poyobe, Santiago irʉ Juan yabara anaepanarʉcʉpatsibe. ");
INSERT INTO cui_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ichitha Jesús pia xainya berena pijimonae waba yawa namchiya jeye barapomonaetha: —Paxam bayatha pataneme po coyenewa ba exana pomonae jopa judiomonae naexanaeyo. Barapomonae ba nantaʉta pomonae pia nacua tatsi pia petaewatsiwichi tatsi. Daichitha barapo nacua peewatsiwi aebiya itoroba piamonae, xua daxota bichocono jiwi taayapubetsi. ");
INSERT INTO cui_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ichitha nama paxam barapocotsi coyeneya jopa barapaichim tsane. Seicaya nama icha jʉntʉ coyeneyatha paca itorobatsi. Icha pon paxam jiwana icha bapon ichichipa naexana be pocotsin canamataxeina ichamonae, bapon matha bewa copiya daxita paxam beta amanaya pacata nacuichina. ");
INSERT INTO cui_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mataʉtano icha pon paxam jiwana icha bapon ichichipa naexana be pocotsin bichocono ainya cui penaexanaein xua beyacaincha ichamonae, bapon bewa copiya matha daxita paxam amanaya pacata nacuichina pia coya peichichipaexae. ");
INSERT INTO cui_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Icha be pocotsi coyeneya icha ichin, bara paichinde. Xan ponxaein Nacom Tananeitapetsin patopeican xua tanacuichinexa tsane ichamonae nexa. Apara jopa baxua tsipatopaeinyo xua ichamonae inta penacuichiwanexa tsane. Saya patopeican tsipei ichichipan xua daxita carepaya jiwi tayawenaewa tsane. Mataʉtano patopeican xua tatsitʉpaenexa tsane be pentoma xua daxita jiwi pepanenebiyaenexa abe pia peexanae cuiru coyenein weya tatsi, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Poxonae Jesús pijimonae barʉ pontaba Jericó tomara weya, bapoxonae Jesús puna poinchi pin bicheito. ");
INSERT INTO cui_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Barapo Jerusalén namto iya ecabe pon peitata nacʉtsinbe. Poxonae baponbe, ponbe peitata nacʉtsinbe jume yaputanebe xua juinya Jesús xentapona, bapoxonae jume daunweya wawaibe, jeibe: —¡Pon jiwi Necanamataxeinaem, ponxaem David pia pemomoxi susato jiwanapim, pana neyabara najʉntʉ coyene xeinarebe xua pata taneyawenaenexamebe! jei baraponbe ponbe peitata nacʉtsinbe. ");
INSERT INTO cui_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Barapo peitata nacʉtsinbe jume matawentatsibe barapo pin bicheito xua moya peecaenexabe. Ichitha baponbe equeicha jume daunweya wawaibe, beyacaincha xua poxonae copiya, jeyebe: —¡Pon jiwi Necanamataxeinaem, ponxaem David pia pemomoxi susato jiwanapim, pana neyabara najʉntʉ coyene xeinarebe xua pata taneyawenaenexamebe! jei baraponbe ponbe peitata nacʉtsinbe. ");
INSERT INTO cui_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nexata Jesús naruntaba yawa wabatsibe ponbe peitata nacʉtsinbe. Bapoxonae baponbe Jesús yainyaba, jeye: —¿Eta xua jinya pata cata exanaetsibe? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Baraponbe Jesús jume notatsibe, jeibe: —Pon jiwi Necanamataxeinaem, bepanecotsinbe cuinaya, jeibe baponbe. ");
INSERT INTO cui_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nexata baponbe Jesús yabara najʉntʉ coyene xeinabe xua pia peyawenaewa tsane. Bapoxonae baponbe Jesús itamaiquei jayababe. Bapoxonae baponbe nainya necotaxubabe. Jesustha napuna ponabe. ");
INSERT INTO cui_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Poxonae bara itiya pona Jerusalén tomara, Jesús bara muxu pebarʉ patopae pijimonae Betfagé tomaratha. Barapo Betfagé tomara demxuwa itapatororotha eca po demxuwa pewʉn Olivowa, tsipei baxota umena olivo naein. Bapoxonae Jesús itoroba pebinbe nacueyatabe xua doce poyobe jiwanabe. ");
INSERT INTO cui_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jesús baraibe baponbe, jeye: —Paponarebe po tomara painya itabaraya equiya. Poxonae papatopaenamebe barapo tomaratha pacaxinaenamebe burra pesowato xua pon quetanotatsi yawano xua penʉn quetanotatsi pon pebto. Barapo burra paisanaxorebe yawa payama carenandebe coxiwa yawa penʉnno. ");
INSERT INTO cui_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Icha ichʉn paca barai tsane: ‘¿Eta xua payama isanaxubamebe burra?’ jei tsane, nexata pajandebe: ‘Pon jiwi Pecanamataxeinaein bepa pata yama cayiyaeinjei, tsipei pinae nantawenona’, pajandebe. Nexata bapoxonae nainya bapon paca cobe itorobinabe xua painya neyama carenaenexambe tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Poxonae Jesús daxita baxua paeba bara bapoxonae nayabara jume weta pocotsiwa bayatha Isaías yabara paeba pijume diwesitha xua Mesías pepatopaewa tsane Jerusalén tomaratha, jeye: ");
INSERT INTO cui_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Patsipaebare Sión tomarapiwi. Pajande: ‘Pataename pon itorobiya painya pepa paca Ewatsin. Pacata jʉntema patopaena, xua burriyotha equeicaena, penʉntha xua burra pesowato coxi tatsi’ pajande”, jei pon Nacom pia peitorobi jume pepaebin, bapon Isaías, xua Mesías yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nexata Jesús pijimonae jitonbe tatsi ponabe. Mataʉtano baponbe exanabe pocotsiwa bayatha Jesús itoroba. ");
INSERT INTO cui_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Baponbe yama carenabe burra pesowato yawa yama carenabe penʉn. Baponbe pia paparuwan tsijuma jebicabe po paparuwan matha weruyabe coxiwathano yawa penʉnthano. Bapoxonae Jesús equeica penʉntha. ");
INSERT INTO cui_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jiwi, barapo jiwi pin bicheito bichocono. Bapoxonae barapo pin bicheito namtotha paparuwan yerababa jejebabapoinya. Ichamonae peaxu ucuboba po axu icha coichaxu axu ichi. Bapoxonae barapo axu, namtotha axu jejebabapoinya. Daxita barapomonae barapo coyene exana xua Jesús pebarʉ cui itura jinaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Pomonae, xua Jesús tsiwana enapoinchi irʉrʉ pomonae Jesús peputha taenapoinchi daxita barapomonae bichocono jume daunweya wawaya jeye: —¡Pai jayana, barabʉ jiwi barʉ cui itura jinaena bapon pon David pia pemomoxi susatopin tatsi! Bapon jiwi yabara jei: ‘¡Bapon David pexanto tatsi!’ jei. ¡Maisa Jesús pon jiwi itorobiya pia pepa peewatsinchi, maisa wʉnae! ¡Bapon patopa Nacom peitorobixae! ¡Maisa Nacom bichocono wʉnae jaintatsi pon athabeicha eca! jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Poxonae Jesús patopa Jerusalén tomaratha, daxita barapo tomarapiwi najume cayayatsiya paeba. Cae bicheitomonae nayainyaba, jeye: —¿Jintam metha bapon jane? najei. ");
INSERT INTO cui_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ichamonae jume nota, jeye: —Apara bapon Jesús pon Nacom pia peitorobi jume pepaebin, pon Nazaret tomarapin po tomara eca Galilea nacuatha, jei ichamonae xua irʉ ichamonae jume notatsi. ");
INSERT INTO cui_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Bapoxonae Jesús joniya Nacom pin pia botha, yawa aisowa benapuna torobabiya pomonae caenaeta baxota. Jesús tabʉ tayebiya bebai iratha pocotsiwa pexaethopaewan, po pexaethopaewantha nantiya nacatsiba paratixi yawa xua tabʉ tayebiya bebai iratha peenaewan po peenaewan ichaxota ena pomonae caenaeta topibo. ");
INSERT INTO cui_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús barai barapomonae: —Nacom Pejume Diwesitha namchi, jeye: ‘Tabo apara po botha jiwi tanetsipaebinexa tsaibi tsane barapo botha’, jei Nacom Pejume Diwesitha. Ichitha paxam barapo bo be pecaibiwi pia mʉthʉ tutu pacana exaname ichaxota pijunuwi nantsiyabeibathopa tsipei baxota panacaetutame saya ʉ xua painya necaibinexam tsane paratixi pomonaetha pomonae xua pateiba xua Nacom petsipaebinexatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Barapo Nacom pin pia botha tatsi, Jesús imoxoyo caquita umenarʉcʉpatsi pomonae peitata nacʉtsiwi. Irʉrʉ Jesús imoxoyo caquita umenarʉcʉpatsi pomonae pejayujayujeiwi. Jesús axaibi exana daxita barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdotemonae pia pentacaponaewi tatsi irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi, daxita barapomonae tane pocotsiwa Jesús exana pia pexeinya petsita itʉtsi coyenewatha. Daxita barapomonae jume tane xua pexui wawai Nacom pin pia botha tatsi xua pexui Jesús yabara jeichichi: “¡Pai jayana, barabʉ jiwi barʉ cui itura jinaena bapon pon David pia pemomoxi susato jiwanapin tatsi! Pon jiwi yabara jei: ‘Bapon David pexanto tatsi’, jei”, jei pexui. Bapoxonae daxita pomonae sacerdotemonae pia pentacaponaewi tatsi irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi anaepana poxonae Jesús cui tainchi yawa xua jume tainchino. ");
INSERT INTO cui_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Daxita barapomonae jopa ichipaeyo xua pexui paeba, daxota anaya Jesús jeichichi: —¿Bayatha jume taneme xua baxua pexui cayabara wawaya namchi? jei barapomonae. Jesús jume nota barapomonae, jeye: —Aa, bara bayatha jume tan xua pexui newʉnae jainta. Paxam bayatha payorobame Nacom Pejume Diwesi xua pexui bara cui copatatsi xua bara wʉnae pejainteibiwa tsane. David pexui yabara jeichichi Nacom Pejume Diwesitha, jeye: ‘Xam Nacom, cana exaname pexui poxi isainatsi, irʉ poxi jinompena, xua barapoxi pexeinya weixi cayabara caununaya naxʉna poxonae cawʉnae jainchina’, jei David Nacom Pejume Diwesitha, jei Jesús daxita barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nexata Jesús daxita barapomonae wepu pona Jerusalén tomara weya. Bapoxonae Betania tomara bewarapiya. Baxota merawi maiteca. ");
INSERT INTO cui_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Poxonae Jesús caemʉmbotha equeicha caibe iya Jerusalén tomara beya, bichocono jainpa pona. ");
INSERT INTO cui_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bapoxonae Jesús imoxoyo namtotha taenota higuera nae. Imoxoyo caquita pona piyain, pia taetsi pethei. Daichitha barapo naetha Jesús jopa taeyo pethei, saya ʉ noxu tane. Nexata Jesús biataenota higuera nae, jeye: —Bapana equeicha jopa nacoichim tsane pethei, jei Jesús higuera naetha. Bapoxonae caena nainya higuera nae yʉnuncua. ");
INSERT INTO cui_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Poxonae Jesús cui tainchi pijimonae baxua barapomonae yabara najʉntʉ coyene cui cabenaeca bichocono. Yawa Jesús yainyabatsi pijimonae, jeye: —¿Eta xua metha higuera nae nainya yʉnuncua? jeichichi Jesús pijimonae. ");
INSERT INTO cui_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús jume nota pijimonae, jeye: —Bara xaniyeya paca tsipaebatsi. Icha xanepanaya payabara jume cowʉntame xua Nacom painya nepaca cayawenaewa xuano xua jopa ainya ʉnthʉton paxeinaem bara paca itacʉpaena xua painya nepaebiwa icha ichin xua cana exanan higuera nae. Mataʉtano bara paca itacʉpaena xua painya nejeiwa uruto beya xua pajam: ‘Uruto natsixitabare, mar mene beya jopare’, xua painya nejeiwa. Bapoxonae bara baxua jopa bayathiyo tsane. ");
INSERT INTO cui_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Daxita xua xuan pocotsiwan Nacom beya pawʉcame, icha bara xanepanaya pajume cowʉntsiya wʉcame, bara Nacom paca catsibina baxuan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nexata bapoxonae Jesús joniya Nacom pin pia botha tatsi. Poxonae cataunxuae Jesús baxota cuidubuncua jiwi, bapoxonae Jesús imoxoyo caquita umenarʉcʉpatsi sacerdotemonae pia pentacaponaewi tatsi irʉ judiomonae pia pitiri jiwi tatsi. Daxita barapomonae Jesús yainyabatsi, jeye: —¿Eta po peayapusʉ itorobi coyenewatha cuidubame baxuan? ¿Jintam cacata barapo peayapusʉ itorobi coyenewa? ");
INSERT INTO cui_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús jume nota barapomonae, jeye: —Xan irʉrʉ tha barichichi paca yainyabinchi. Icha beta pana nejume notsiname, bapoxonae xuya yabara paca tsipaebinchi xua po peayapusʉ itorobi coyeneyatha taexanaewa baxuan. ");
INSERT INTO cui_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Jintam Juan cui itorobatsi xua bautisaba? ¿Metha bara Nacom cui itoroba jampa? ¿Metha bara jiwi cui itoroba jampa? Pana nejume nore, jei Jesús, xua Juan yabara paebatsi pon caena bayatha tʉpa. Nexata daxita barapomonae caemonae najume matsontsonoba, najei: “¿Eta xua metha jei tsainchi? Icha jei tsipaetsi: ‘Juan cui itorobatsi Nacom xua pebautisabiwa jiwi’, metha naca jei tsipae: ‘¿Eta xua metha nexata jopa pajume cowʉntsim Juan?’ metha naca jei tsipae Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jiwi cui cunuwatsi icha jeichi: ‘Juan cui itorobatsi jiwi xua bautisaba’, icha jeichi. Metha bapoxonae jiwi naca casebichipa anaya. Tsipei daxita jiwi Juan yabara jume cowʉntatsi xua bapon apara pon Nacom pia peitorobi jume tatsi pepaebi jiton”, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nexata barapomonae Jesús baraichi, jeye: —Canta jopa payaputaeinyo, jei barapomonae. Nexata Jesús barai barapomonae, jeye: —Nexata barichin tsane, jopa yabara paca tsipaebi tsainchi po peayapusʉ itorobi coyeneyatha xua daxita taexanaewan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Equeicha Jesús namchi Nacom pin pia botha daxita barapomonaetha, xua sacerdotemonae pia pentacaponaewitha tatsi, irʉ judiomonae pia pitiri jiwitha tatsino. Jesús jeye: —Moya pana nejume naitaeware pocotsiwa paca tsipaebinchi. Pebin nacueyatabe poyobe tatsi pexantobe tatsibe. Bapon caeintha nacoxi barai, jeye: ‘Owae, inta anoxuae uva bacabo pabi nacuire’, jei. ");
INSERT INTO cui_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Bapon jume notatsi pexanto jeye: ‘Bara, aichaxaibin’, jeichichi bapon pexanto. Daichitha equeicha bapon pexanto tatsi nanta xeinataba, bapoxonae pona xua penacuichinexa uva pabi, paxa tatsi pia pabi tatsi. ");
INSERT INTO cui_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Pirapae equeicha ichʉntha, nacoxi barai barapo jumetha, jeye: ‘Owae, inta anoxuae uva pabi nacuire’, jei bapon pexantotha. Bapon paxa jume nota, jeye: ‘Je, moya daichane, methaunxuae ponaein’, jei paxatha. Daichitha bapon jopa ponaeyo. ");
INSERT INTO cui_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Incane yabara paca yainyabinchi xua bapon barapo pexantobe tatsi, ¿eta po pewowinda pon exana pocotsiwa paxa itorobatsi? jei Jesús. Barapomonae Jesús jume notatsi, jeye: —Pon copiya paxa itorobatsi, jeichichi Jesús barapomonae. Nexata Jesús jume barai barapomonae, jeye: —Bara xaniyan yabara paca tsipaebatsi, pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa, irʉrʉ yabʉxi powaxi pesi cui weiweinaewaxi. Bara bequein barapomonae peantʉcoyenebewi, daichitha barapomonae naexanaena Nacom piamonae tatsi jiwana tatsi, beya poxonae paxam irʉ panaexaname Nacom piamonae tatsi jiwana tatsi. ");
INSERT INTO cui_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan pon jiwi Pebautisabin patopa xua pia nepaca cuidubinexa xua pocotsiwa bewa paexanaename painya nexeinaenexa tsane po jʉntʉ coyene pexanepanae jʉntʉ coyene. Daichitha paxam jopa pajume cowʉntsim pocotsiwa Juan paeba. Ichitha Juan yabara jume cowʉntatsi pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchichi nexa. Irʉrʉ yabʉxi powaxi pesi cui weiweinaewaxi Juan yabara jume cowʉntatsi po coyene Nacom Juan peitorobiwatsi. Nama paxam bequein bara Juan pacui taneme pocotsiwa exana, daichitha jopa painya neauraxae poxonae abe paexaname. Daxota icha jʉntʉ coyene jopa paxeinaem xua painya nejume cowʉntsinexa Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nexata Jesús equeicha namchi jiwitha, jeye: “Incane pana nejume naitaeware xua paca tsipaebinchi pecayabara jʉta pepaebi diwesiyo. Matha irʉrʉ pebin pia pabi xeina. Bapon ʉba po ʉnbo pewʉn uva cuei ʉnbo. Yawano yapu curarata barapo uva pabi ibowantha xua jopa pejojondenaenexa ichamonae barapo pabitha. Yawano baxota ibo feto exana, xua barapo ibo fetotha pecubinexa uva cuei. Mataʉtano baxota exananota bo po bo taʉcha xua baxota pebin bara wenecotequeica uva pabi. Bapoxonae bapon itoroba pomonae pia uva pabi pia petayapucaenaewichi tsainchi, xua bapoxonae barapomonae pejiwanaxaenexa pocotsiwa penawetsiwa. Bapoxonae bapon icha nacua beya pona. ");
INSERT INTO cui_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Barapo matacabi tsuxubi po matacabitha uva cuei naweta. Bapoxonae barapo mataqueitha pomonae pabi petayapucaenaewi jiwana itapetanota xua penawetsiwa. Bapoxonae pon uva pabi pexeinaein, bapon pomonae petanacuichiwichi jiwana itoroba, xua petawʉcaenexa tsainchi uva cuei pomonae beya, pomonae pabi petayapucaenaewichi. ");
INSERT INTO cui_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ichitha barapomonae, pomonae pabi petayapucaenaewichi teica, teiquebatsi pomonae itorobatsi, pomonae pabi pexeinaein itoroba uva pabi petayapucaenaewichi tatsi beya. Barapomonae pomonae petayapucaenaewi pabi, cuainta caeintha pomonae penajume carutsi jiwichi jiwanapintha. Ichʉn bexotsi. Ichʉn ibotontha cuinbabatsi. ");
INSERT INTO cui_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pon pabi pexeinaein barichi equeicha itoroba ichamonae pomonae pia petanacuichiwichi. Equeicha barichi pomonae pabi petayapucaenaewi bara jʉtiya cana exana barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Bara nama matapainya pexanto itoroba. Bapon najei: ‘Barapomonae metha taxanto inta yabara barʉ cui itura jinaeinchi, daxota itoroban bapon’, najei bapon. ");
INSERT INTO cui_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Dapo jumetha pomonae pabi petayapucaenaewi poxonae bapon tainchi barapomonae najei: ‘Apara bapon paxa copiniwa pichina. Daxota bapon bʉ bexotsi xainya xeinatsi barapo uva pabi’, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Barapo pexanto tatsi uva pabi juma bemaxʉ cayiyatsi. Baxotiya bexotsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nexata Jesús barai barapo jiwi Nacom pin pia botha, jeye: “Poxonae pabi pexeinaein patopaena, ¿eta be cana ichi tsane pomonaetha pomonae barapo uva pabi pia petayapucaenaewichi?” jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Barapomonae Jesús jume notatsi, jeye: —Bapon bewa jutebina barapomonae, jopa weyatae tsane barapomonaetha xua peantʉcoyeneyapube jiwixae. Bapoxonae itorobina ichamonae xua petayapucaenaenexa tsainchi barapo uva pabi. Barapo pabi petayapucaenaewi matha notsina uva cuei xua naweta. Bapoxonae tsabina pabi pexeinaein nexa yawa irʉrʉ barapomonae nexarʉ, jei barapo jiwitha pomonae peenaexae Nacom pin pia botha. ");
INSERT INTO cui_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nexata Jesús barai barapomonae xua nayabara paeba, jeye: —¡Paxam bara bayatha payorobameba Nacom Pejume Diwesitha! Barapo diwesitha neyabara caunuta poxonae iboto yabara paeba, xua jeye: ‘Pebiwi pomonae ibo bon peacabiwi, barapo pebiwi xuba po iboto tabʉ caboca po iboto peainya cui iboto. Ichitha Nacom itapeta barapo iboto xua petabʉ cabocaenexa barapo peainya cui ibotoxae. Waxainchi nanta xeinatsi jeichichi: Maisa pocotsiwa Nacom exana naca tsita xanepana’, jeichichi, jei Nacom Pejume Diwesitha xua neyabara caunuta. ");
INSERT INTO cui_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Daxota paca tsipaebatsi, Nacom paca itawetsina xua jopa painya nenaexanaenexa tsane Nacom piamonae jiwana tatsi pam. Barapo coyenewa xua Nacom piamonae jiwana tatsi penaexanae coyenewa Nacom pichina painya xainya weya xua ichamonaetha pecatsinexa pomonaetha pomonae petsita jʉntʉ coyene xanepanaewichi. ");
INSERT INTO cui_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Incane iboto yabara paca tsipaebinchi. Barapo ibototha poxonae ichauyo jopeica pepʉrʉwixi tsanaya. Mataʉtano poxonae barapo iboto ichauyo matatsun jopeicatsi pebeno tsanaya. Icha barapo iboto ichi poxonae cana exana ichauxitha peainya cui ibotoxae, xan barapocotsi jʉta coyeneya barichin pomonaetha pomonae jopa tana nejume cowʉntsiwi. Pia jopa tana neyaputaexae barapomonae daxota peraxa exanaein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdotemonae pia pentacaponaewi tatsi irʉ fariseomonae, poxonae jume tane barapo pecayabara jʉta pepaebi diwesi, xua Jesús paeba, barapomonae yaputane xua apara bara Jesús yabara paeba barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bequein barapomonae Jesús muxu pewaetabichi, ichitha barapomonae junuwa. Jiwi cunuwatsi, tsipei daxita jiwi Jesús xanepanaya yabara paebatsi xua pinae Jesús Nacom pia peitorobi jume pepaebiwi jiwana tatsi. ");
INSERT INTO cui_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Equeicha Jesús tsipaeba jiwitha pecayabara jʉta pepaebi diwesiyo, jeye: ");
INSERT INTO cui_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nacom cana exana piamonaetha pomonae jʉntʉ coyene itorobiya ewata, icha pocotsin ichi pon jiwi itorobiya pia pepa peewatsinchi poxonae waba, xua poxonae ichamonae wabatsi xua petsinacaetutsinexa pexaewa xua penabanaenexa. Baxua exana poxonae pexanto tatsi pecotsiwa pepichixae. ");
INSERT INTO cui_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Barapon pon jiwi itorobiya pia pepa peewatsinchi itoroba pomonae pia petanacuichiwichi xua petawabinexa tsainchi pomonae xua bayatha petsipaebixae xua petapatsiwa tsainchi pia botha xua bepa pinae petanabanaewa tsainchi pia botha. Daichitha barapomonae aichaxaibi xua pepatsiwa tsane. ");
INSERT INTO cui_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bapoxonae barapon pon jiwi itorobiya pia pepa peewatsinchi equeicha itoroba ichamonae pomonae pia petanacuichiwichi, jeye barapomonaetha: ‘Pomonae bayatha tsiwaban pexaewa xua penabanaenexa painta tsipaebare pajande: Bepa pinae nainya papatsim, tsipei pinae bayatha pexaewa canacui wʉnaeta. Tsipei caena bayatha pinae cobe itoroba xua petajutebiwa tsainchi vacan, yawano po duwein bichocono nasita. Daxota bewa pinae nainya paponaem bara beya xua painya nenanabanaenexa pexaewa, yaitama tsipei pinae pexanto tatsi pichina pecotsiwa, pajande’, jei barapon pon jiwi itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Daichitha barapomonae pomonae tsiwabatsi pexaewa, barapomonae jume naitemata, saya meisa ʉ naitomatsiya exana piawan. Barapomonae jiwanapin pia pabitha pona. Irʉ ichʉn piawa caenaetauya. ");
INSERT INTO cui_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ichamonaerʉ teica, pomonae pon jiwi itorobiya pia pepa peewatsinchi itoroba, barapomonae teicatsi. Yawano bichocono abe exainchi beya poxonae nama werapa. ");
INSERT INTO cui_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Nexata bapon pon jiwi itorobiya pia pepa peewatsinchi bichocono caseba pomonae petajutebixaetsi pomonae bapon itoroba. Nexata bapon itoroba pia soldadomonae xua barapomonae xuya pejutebinexa tsainchi mataʉta xua tomara petatautsinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Bapon pirapae equeicha barai ichamonaetha pomonae pia petanacuichiwichi jiwitha, jeye: ‘Bayatha bequein daxita wetan xua penabanaewa tsane, daichitha pomonae waban jopa xanepanaya nejume jejeyo daxota jopa bewa patsi tsane xua penabanaenexa. ");
INSERT INTO cui_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Daxota paponde tomara namtontha, po namtontha pin namtontha, baxotiya pomonae poxonae pacaxibeibame, barapomonae painta wabare’, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pomonae petanacuichiwi, barapomonae pona namton beya. Bapoxonae barapomonae, daxita pomonae caxiba namtontha, matacayiya pon jiwi itorobiya pia pepa peewatsinchi pia bo tatsi beya. Pomonae abe peexanaewino carendenatsi, pomonae xanepanaya peexanaewino carendenatsi, beya poxonae bo tutu nayʉcaxuba. ");
INSERT INTO cui_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nexata pon jiwi itorobiya pia pepa peewatsinchi bo tutu joniya petaenexa tsane pomonae pata. Bapon itabara tane pebin xua irʉrʉ pon baxota eca. Ichitha barapo pebin pexeinya paparuwa jopa nama xatatsiyo icha be jopa ichiyo ichamonae, tsipei ichamonae pexeinya paparuwa nama xataba xua po paparuwa jiwi ba nama xataba poxonae pona penacaetutsiwatha xua penabanaenexa pexaewa poxonae pebin pecotsiwa pita. ");
INSERT INTO cui_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pon jiwi itorobiya pia pepa peewatsinchi barai bapon, jeye: ‘Tajiton, ¿eta xua metha xote naecame xua mataʉta jopa pexeinya paparuwa nama xatatsim?’ jei bapon. Ichitha bapon saya moya eca. ");
INSERT INTO cui_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Bapoxonae pon jiwi itorobiya pia pepa peewatsinchi barai pomonaetha pomonae pexaewa carena tsaibi pexaethopaewatha, jeye: ‘Bapon pacobe caecunta cʉre yawa pataxu caecunta cʉre, yawa aisowa beya paxore ichaxota quirei. Baxota bapon wecoyei tsane yawa baxota nantanuweya nanta jayabina, bichocono peatenexae tsane’, jei pom jiwi itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Barapon pon jiwi itorobiya pia pepa peewatsinchi bequein pinmonae waba ichitha saya tsiquimonaeyo pata penabanaewatha. Icha barapon ichi Nacom bara jʉta coyene ichiya cana ichi tsane jiwi. Nacom bequein waba pin bicheitomonae, daichitha saya tsicamonaeyo itapetatsi, pomonae Nacom pijimonae tatsi penaexanaenexa tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nexata fariseomonae pona Jesús weya, caemonae natsipaeba najei: “¿Eta po peyainyabiwa Jesús taexanaeinchi xua catsawa wanaca jume notsinexa? Bapoxonae waxainchi xain yopitatsi ichamonaetha xua bapon abeya wanaca jume notsiwaxae”, najei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bapoxonae barapomonae itoroba pia pepuna ponaewichi, mataʉtano barapomonae itorobano pomonae Herodes pia pepuna jinompaewichi. Daxita barapo matabʉxʉyobe pata Jesustha pomonae fariseomonae itoroba. Barapomonae Jesús beya jeye: —Pon jiwi Necuidubim. Bara payaputan xua bara jume xainyeya tsipaebame jiwi, mataʉtano xua jiwi bara beta cuidubame xua pocotsiwa jiwi bewa exanaena pexeinaenexa tsane Nacomtha po jʉntʉ coyene pexanepanae jʉntʉ coyene. Mataʉtano jopa jiwi cunuwim poxonae cuidubame poxonae bequein jiwi jopa ichichipaeyo baxua, tsipei xam daxita jiwi bara catsita najʉpa. ");
INSERT INTO cui_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Incane yabara pana netsipaebare xua nanta xeiname xuaje: ¿Metha bara Nacom pia peitorobi coyene naca itoroba xua waxainchi paratixi catsibinchi pon romanomonae itorobiya pia pepa peewatsinchi xua wanaca itorobixae bapon bequein bara bapon pon penanapaincha poponaein xua icha nacua werena peponaein? Icha jopa tsipae ¿metha daxua abe tsipae? jeichichi Jesús barapomonae pomonae fariseomonae itoroba. ");
INSERT INTO cui_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Daichitha Jesús yaputane xua bichocono barapomonae abeya nanta xeina xua Jesús abe pecanaexanaenexa tsainchi. Jesús barai barapomonae, jeye: —Paxam pomonae itara mexeya xanepanaya pepaebiwi pam, daichitha abeya pepaebiwi pam. ¿Eta xua metha pana nejʉntʉ coyene jʉjʉtame poxonae baxua yabara pana neyainyabame? ");
INSERT INTO cui_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Incane moya painta xawena tha taetsi barapo paratiyo, jei Jesús. Bapoxonae barapomonae barapo paratiyo Jesús tacapoinchi. ");
INSERT INTO cui_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Poxonae Jesús tane barapo paratiyo, bapoxonae yainyaba barapomonae, jeye: —¿Jintam pejumopere? ¿Yawano jintam wʉn ducuare? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nexata Jesús jume notatsi barapomonae, jeye: —Apara romanomonae itorobiya pia pepa peewatsinchi, jei barapomonae. Nexata Jesús barai barapomonae, jeye: —Bara nexata romanomonae itorobiya pia pepa peewatsinchi pacare pocotsiwa xua bapon piawaxae tatsi. Mataʉtano bara Nacom pacare xua baxua irʉ piawaxae tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Poxonae barapomonae jume tane xua Jesús beta xanepanaya jume nota, bapoxonae barapomonae yabara najʉntʉ cui coyene cabenaeca. Bapoxonae ponarʉcʉpa Jesús weya. ");
INSERT INTO cui_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Bapoxonae caena barapo mataqueitha saduceomonae jiwana pata Jesús pia xantha tatsi xua Jesús piraichi petsipaebinexatsi. Saduceomonae barompaya pia pecuidubi coyenewa xeina xua pinae pomonae pewerapeibiwi equeicha jopa asʉ tsaibiyo. Barapo pecuidubi coyenewa jopa jʉpaeyo po pecuidubiwa Jesús pia pecuidubiwa tatsi xua pinae jiwi equeicha asʉ jinompaena poxonae werapa. Daxota barapo saduceomonae Jesús tsipaebatsi jeye: ");
INSERT INTO cui_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Pon jiwi Necuidubim, Moisés nacata tina, namchi: ‘Icha pebin piowa cuenta tʉpa, yawa jopa xeinaeyo pexui, xuyapin bewa xuya pentapin pecoutha coseuri pichina xua bapoxonae pentapin pecoutha pexeinaenexa tsane pexui’, jei Moisés. ");
INSERT INTO cui_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Barichi, matha irʉrʉ cae peweicho caepiwi nabarʉ jinompa siete poyobe. Matapin jitha eca. Bapon piowa cuenta naxuba. Pexui jopa xeinaeyo. Pon cotacaya naexana xuya pentapin coseuri pita xua bapoxonae pentapin pecoutha pexui pexeinaenexa. ");
INSERT INTO cui_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bapon irʉ cuenta tʉpa, irʉ jopa xeinaeyo pexui. Bapoxonae ichʉn xuyapin xuya barapowa pita xua pentapin coseuri pita. Bapon barichi irʉ cuenta tʉpa, irʉ pexui jopa xeinaeyo. Daxita barapo siete poyobe cuenta nanapentapona bapowa poxonae bequein xuya pecoutha nonotaponeiba. Barapo siete poyobe, caein jiwana jopa pecoutha tapoponaetsi pexuyo. ");
INSERT INTO cui_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bapoxonae matapainya irʉ bapowa tʉpa. ");
INSERT INTO cui_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Xam Jesús, ba paebame, ba jam: Matacabi jopaena po matacabitha Nacom asʉ exanaena, xua jiwi asʉ exanaeinchi mʉthʉn wetsina, ba jam. Poxonae barapo matacabi jopaena xua daxita jiwi asʉ jujuinaena, barapo matacabitha ¿jintam metha bapowa xuya pichinchi, xua ichʉn pichina, xua barapo siete poyobe caein jiwana? Tsipei caena bayatha barapo siete poyobe caepiwi cuenta nanapentapona barapowa, jei saduceomonae. ");
INSERT INTO cui_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nexata saduceomonae Jesús jume nota, jeye: —Paxam apara catsawiya pana nejume notame, tsipei jopa beta payaputaem xua Nacom Pejume Diwesitha payabara yorobame baxua. Mataʉtano jopa payaputaem Nacom pia peayapusʉ itorobi coyenewa tatsi. ");
INSERT INTO cui_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Poxonae petʉpaewi equeicha asʉ jujuinaena, jopa jitha eenaponae tsane. Yawa barapomonae jopa pexantixi jitha cuarebaponae tsane. Tsipei barapomonae barichi tsane icha be matatsunpiwimonae ichi, po matatsunpiwimonae Nacom pia nacuatheicha jinompa, xua po matatsunpiwi jopa jitha enaeyo. ");
INSERT INTO cui_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Paxam bequein bara bayatha payabara yorobame pocotsiwa Nacom namchi Pejume Diwesitha, po coyene xua pomonae pewerapaewi equeicha asʉ jujuina. Barapo diwesitha Nacom jeye: ");
INSERT INTO cui_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Xan Abraham pia Nacomʉn tatsin, irʉ Isaac pia Nacomʉn tatsin, irʉ Jacob pia Nacomʉn tatsin’, jei Nacom. Baxua Nacom paeba tsipei Abraham irʉ Isaac irʉ Jacob pomonae bayatha pewerapaewi anoxuae equeicha caewa asʉ jinompa Nacom pia nacuatheicha tatsi. Pomonae pewerapaewi pomonae jopa caewa equeicha asʉ pejinompaewi, barapomonae jopa pia Nacom tatsi, pon itabocotha eca. Saya jame meisa pomonae bayatha pewerapaewi xua caewa equeicha asʉ pejinompaewi, pomonae pejume cowʉntsiwixaetsi Nacom barapomonae jame pia Nacom tatsi, pon itabocotha eca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Poxonae jiwi jume tane pocotsiwa Jesús cuiduba, barapomonae yabara najʉntʉ cui coyene cabenaeca. ");
INSERT INTO cui_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Poxonae fariseomonae yaputane xua saduceomonae moya umena xua Jesús beta pejume notsixae, bapoxonae fariseomonae nacaetuta xua equeicha peyainyabiwanexa tsainchi Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Barapo fariseomonae caein jiwana, pon peyabara yaputaein Moisés pia peitorobi coyene tatsi, bapon ichichipa xua Jesús pejʉntʉ coyene jʉjʉtsiwatsi xua icha bara metha Jesús abeya jume notsina. Bapon jeye Jesustha: ");
INSERT INTO cui_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ja pon jiwi Necuidubim, ¿eta po peitorobi coyene pepa ainya cui coyenewara po peitorobi coyene beyacaincha xua icha peitorobi coyene? jei. ");
INSERT INTO cui_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús jume nota bapon, jeye: —Po peitorobi cui coyenewa pepa ainya cui coyenewa jeye: ‘Antobeinde pon jiwi Pecanamataxeinaein, bapon Nacom xua daxita nejʉntʉ coyene wetsina, mataʉtano xua daxita jinya nepoponae coyenewatha, mataʉtano xua daxita nenanta xeinaewatha nentasipatha’, jei. ");
INSERT INTO cui_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jame barapo peitorobi coyene bichocono ainya cui coyenewa beyacaincha icha peitorobi coyene. Barapo peitorobi coyene, po peitorobi coyene ainya cui coyenewa, Nacom copiya itoroba. ");
INSERT INTO cui_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Po peitorobi coyene cotacaya itoroba ichaxota ba ‘dos’ jei, barapo peitorobi coyene be jume jʉpa po peitorobi coyene copiya ducua. Irʉrʉ barapo peitorobi coyenewatha jeye: ‘Antobeinde jinya necatsicuarabʉ ecaein icha ichim xua jinya coutha naantobem’, jei barapo peitorobi coyenewatha. ");
INSERT INTO cui_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Barapo peitorobi coyene jumebe caunuta, xua Moisés pia peitorobi coyenewatha baxua yabara paeba, irʉ pomonae Nacom peitorobi jume pepaebiwi pia pecuidubi coyenewatha baxua yabara paebarʉ, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Poxonae fariseomonae cataunxuae nacaetutompa bapoxonae Jesús yainyaba barapo fariseomonae, jeye: ");
INSERT INTO cui_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Eta xua pacayabara nanta xeiname Mesías pon Nacom pia Peitapetsin? ¿Jintam pia pemomoxi susato jiwanapin tatsira? jei Jesús. Barapomonae Jesús jume notatsi, jeye: —Apara David, pon Israel nacuapiwi itorobiya pia pepa peewatsinchi, bapon pia pemomoxi susato jiwanapin tatsi, jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Bapoxonae Jesús barai barapomonae, jeye: —David yabara paeba xua Mesías apara pia Pecanamataxeinaeinchi tatsi poxonae David cueicueijei exanatsi Nacom pia Pejumope tʉnaxʉ tatsi. ");
INSERT INTO cui_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","David salmos penaxʉnae wei diwesitha bayatha jeye: ‘Nacom pon Pecanamataxeinaein jiwi, Tanecanamataxeinaein baraichi pon Mesías, jeichichi: Tacoxa werena ecare, beya abʉ tsane poxonae necaaitafaetabi jiwi pia pecanamataxeinaeinchi tatsi caexanaeinchi, jei Nacom’, jei David salmos penaxʉnae wei diwesitha. ");
INSERT INTO cui_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Icha David Mesías yabara jei: ‘Bapon Mesías Tanecanamataxeinaein’, jei, ¿eta xua metha tsipae xua Mesías apara David pia pemomoxi susato jiwanapin tatsi? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Daxita barapomonae jopa itacʉpaetsi xua Jesús pejume notsiwatsi tsainchi, poxonae pinae David paeba xua pinae jei: ‘Bapon Mesías Tanecanamataxeinaein’, jei. Bara nama barapo matacabitha weya, equeicha nama Jesús jopa bepeyainyabiwatsi barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nexata Jesús barai pin bicheito jiwi irʉ pijimonae, jeye: ");
INSERT INTO cui_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi irʉ fariseomonae daxita barapomonae pia pecuidubi coyene xeina xua po coyene jiwi yaputane exanatsi po coyene Moisés pia peitorobi coyenewatha paeba. ");
INSERT INTO cui_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pacui yabara jume cowʉnde pocotsiwa barapomonae pia pecuidubi coyenewan tatsi. Mataʉtano paexande pocotsiwa barapomonae paca itoroba. Daichitha jopa paexanaeinde pocotsiwa barapomonae exana tsipei barapomonae itara beta pepaebiwi daichitha yabara jume toxeinchiya catsawiya exana, barapo peitorobi coyenewan. ");
INSERT INTO cui_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Barapomonae be pocotsimonae poxonae ichamonae itorobatsi xua pecaponaewa pocotsiwa arewe, pocotsiwa jiwi bapana jopa itacʉpaetsi xua pecaponaewa. Daichitha barapomonae jopa yawenaeyo pocotsiwa ichamonae itorobatsi. Mataʉtano barapomonae jopa tayoichaeyo cae cobesitiyotha. Icha barapomonae ichi poxonae ichamonae itorobatsi xua pecaponaewa pocotsiwa bichocono arewe, barapocotsi jʉta coyeneya ichi pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, irʉ fariseomonae, daxita barapomonae itoroba pia pecuidubi coyenewatha pocotsiwa paxam painya neexanaenexa. Ichitha barapomonae jopa exanaeyo baxua. Pocotsiwa barapomonae paca cui itoroba pocotsiwa painya neexanaenexa, paxam bapana jopa paca itacʉpaeyo xua painya neexanaewa baxuan. ");
INSERT INTO cui_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Barapomonae ichichipa nawita xua jiwi pecui taewa tsane pocotsiwa poxonae barapomonae exana xua bapoxonae jiwi penanta xeinaenexa xua barapomonae bara pejʉntʉ coyene xanepanaewi. Daxota barapomonae tsica cajaxi peitapatha querabaduba xua pebocoton. Barapo bocotontha tututha iya jeya xua xoxitha tinaduba Nacom Pejume Diwesi. Yawa icha cajaxi pemaxʉtha querabaduba. Yawa barapo bocotontha tututha iya jeya xua xoxitha tinaduba Nacom Pejume Diwesi. Mataʉta barapomonae nama xataba po paparuwan bichocono apipiya deca, beyacaincha xua poxonae ichamonae nama xataba po paparuwan apipiya. ");
INSERT INTO cui_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mataʉta barapomonae nanta caxunaeneiba ichaxota nanta caxunaeneiba pomonae peainya cui jiwi penaexanaewi. Mataʉtano barapomonae judiomonae pia penacaetutsi bontha ichichipa nawita xua nanta caeneiba ichaxota enathopeiba pomonae peainya cui jiwi penaexanaewi. ");
INSERT INTO cui_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mataʉta barapomonae ichichipa xua jiwi pejacobeibiwa tsane namtontha barapomonaetha, xua jiwi pebarʉ cui itura jineibinexa barapomonae. Mataʉtano barapomonae ichichipa nawita xua jiwi ainya cui pecana exanaewa barapomonae poxonae jiwi pejei tsaibinexa ‘Pomonae jiwi pecuidubiwi’ poxonae pejei tsaibinexa jiwi. ");
INSERT INTO cui_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ichitha nama paxam jopa bewa pacopatsim xua bara jiwi jacobiya paca necajei tsaibinexa: ‘Pata pecuidubi jiwi pam’, paca necajei tsaibinexa xua ainya cui jiwi painya nepaca exanae jiwixae. Painya xoba jiwi baxua bara pajume copatame, tsipei apara paxam be caemonae jiwi pam, saya jame panantaʉtame bara caein pon ainya cui penaexanaein painya itʉtha. ");
INSERT INTO cui_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pomonae po irathe jinompe jopa bewa wabi pajam ‘Axa’, jopa bewa pajam xua painya barʉ cui itura jinaexae pomonae jopa bequein barompaya painya axeiwi. Painya xoba jiwi baxua bara pajume copatame, tsipei paxam panantaʉtame bara caein painya Axa, pon pabarʉ cui itura jiname pon peitabocotha eca. ");
INSERT INTO cui_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Mataʉtano jopa bewa pacopatsim xua bara jiwi jacobiya paca necajei tsaibiwa: ‘Pata necanamataxeinaewi pam’, paca necajei tsaibiwa xua ainya cui jiwi painya nepaca exanae jiwixae. Painya xoba jiwi baxua bara pajume copatame, tsipei apara paxam panantaʉtame bara caein pon painya Necanamataxeinaein, jame apara bapon meisa Cristo. ");
INSERT INTO cui_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Icha pon paxam jiwana, icha bapon ichichipa naexana be pocotsin canamataxeina ichamonae bapon matha bewa copiya daxita paxam beta amanaya pacata nacuichina. ");
INSERT INTO cui_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pon xua pia coutha peainya cui jiton naexana pejʉntʉ coyenetha, Nacom exanaena xua bapon pecui pawi jiton naexanaena. Ichitha pon xua pecui pawi jiton naexana, pejʉntʉ coyenetha, Nacom exanaena xua bapon peainya cui jiton naexanaena. ");
INSERT INTO cui_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Paxam pomonae Moisés pia peitorobi coyene tatsi painya necuidubiwi jiwi pam tsobenaem! ¡Paxam irʉ pomonae fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Paxam acuicoyeneyapubeya paexaname xua poxonae jiwi bequein ichichipa naexana Nacom piamonae tatsi jiwana. Paxam jopa pajume cowʉntsim Nacom yawa jopa pacopatsim xua ichamonae irʉ pejume cowʉntsiwa Nacom. ");
INSERT INTO cui_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Paxam pomonae Moisés pia peitorobi coyene tatsi painya necuidubiwi jiwi pam tsobenaem! ¡Paxam irʉ pomonae fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Powaxi pecuenta werapaewaxichi piseurixi, barapowaxi pacueranta ename pia bon. Naemata Nacom pawʉqueibame. Jopa cuinaya pana najume copababeibim poxonae pawʉqueibame Nacom tsipei paichichipame nawita xua jiwi xanepanaya paca necayabara paebiwa xua bara cou paxam pejʉntʉ coyene xanepanae jiwi pam. Daxota poxonae po mataqueitha Nacom yabara paebina daxita jiwi penatsicuentsiwa barapo mataqueitha Nacom bichocono paca peraxa jʉbina, beyacaincha poxonae peraxa jʉbinchi pomonae pacuidubame. ");
INSERT INTO cui_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Paxam pomonae Moisés pia peitorobi coyene tatsi painya necuidubiwi jiwi pam tsobenaem! ¡Paxam irʉ pomonae fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Paxam tajʉ beya paponame daxita carepayan beya, xua painya cana exanaenexa ichʉntha xua bapon pejume cowʉntsiwa tsane painya necuidubi coyenewan xua bapoxonae bapon be judiomonaepin penaexanaewa tsane. Bapon pacana exaname, xua bapon bichocono equeicha mataropeicha abe peexanaein. Daxota bapon bewa xubinchi ichaxota po nacuatha isoto jopa itacounayiyo, icha paca cana ichi tsane poxonae paca bebai tsane barapo nacuatha. ");
INSERT INTO cui_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Paxam abe peexanae jiwi tsobenae pam! Paxam barapocotsi coyeneya jʉta panacana exaname, icha be pon peitata nacʉtsin ichi xua poxonae ichʉn matacapoinchi pon irʉrʉ peitata nacʉtsin. Paxam ichamonae ba pacuidubeibame ba pajam tsaibim: ‘Icha ichʉn nayabara cui wʉnae tsimuxu duta xua jeye: Xaniwaicha exanaein pocotsiwa xua catsipaebatsi Nacom pia pin bo wʉnthaxae tatsi, poxonae jei, baxua ba jopa ainya cuiyiyo poxonae ichʉn nayabara cui wʉnae tsimuxu duta bapocotsi wʉntha’, ba pajam tsaibim xua ichamonae poxonae pacuidubeibame. Mataʉtano ba pajam tsaibim: ‘Icha ichʉn nayabara cui wʉnae tsimuxu duta xua jeye: Xaniwaicha bara exanaein pocotsiwa xua catsipaebatsi oro nainto wʉntha pocotsiwa daedaena po oro nain coroton Nacom pin pia botha tatsi eca, poxonae jei, baxua ba xua bapon exana bapocotsi wʉntha, baxua jame ainya cui poxonae barapon barapo wʉntha nayabara cui wʉnae tsimuxu dubeibina’, ba pajam tsaibim poxonae pacuidubeibame. ");
INSERT INTO cui_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Paxam barapocotsi coyeneya jʉta panacana exaname, icha be pomonae matasipa daunwei ichi poxonae jopa beta jume cowʉntsiyo Nacom! Nacom pin pia bo bichocono ainya cui beyacaincha oro nain, po oro nain coroton Nacom pin pia botha tatsi ena. Tsipei barapo oro nain poxonae aisowa beequiya Nacom pin pia bo weya jopa ainya cuiyiyo. Jame saya meisa poxonae bo tututha eca bapoxonae ainya cui barapo oro nain, tsipei barapo bo ainya cui cana exanatsi. ");
INSERT INTO cui_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mataʉta ba pajam tsaibim: ‘Icha ichʉn nayabara cui wʉnae tsimuxu duta, xua jeye: Xaniwaicha bara exanaein pocotsiwa xua catsipaebatsi xua be pexaethopaewa wʉntha xua ichaxota duwei tauteiba xua tuxusi exaneiba Nacom nexa, poxonae jei, baxua ba bapon jopa bewa exanae poxoru baraxua xua be pexaethopaewa jopa ainya cuiyiyo poxonae ichʉn nayabara cui wʉnae tsimuxu duta bapocotsi wʉntha’, ba pajam tsaibim poxonae ichamonae pacuidubeibame. Mataʉtano ba pajam tsaibim: ‘Icha ichʉn nayabara cui wʉnae tsimuxu duta xua jeye: Xaniwaicha bara exanaein pocotsiwa xua catsipaebatsi duwei wʉntha po duwei xua bocopiya ichaxota xua be pexaethopaewa wʉntha, poxonae jei, baxua ba bapon jame bewa exanae poxoru po duwei xua bocopiya ichaxota xua be pexaethopaewa, baxua jame ainya cui poxonae bapon barapo wʉntha nayabara cui wʉnae tsimuxu dubeibina’, ba pajam tsaibim poxonae pacuidubeibame. ");
INSERT INTO cui_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Paxam barapocotsi coyeneya jʉta pana cana exaname, icha be pomonae matasipa daunwei ichi poxonae jopa beta jume cowʉntsiyo Nacom! Pocotsiwa xua be pexaethopaewa ichaxota duwei tauteiba xua tuxusi exana Nacom nexa, poxonae tauta baraxua xua be pexaethopaewa bichocono ainya cui, beyacaincha ainya cui poxonae duwein aisowatha bexuba xua saya pexaenexa. Tsipei duwei saya ainya cui poxonae pocotsiwa xua be pexaethopaewatha bocopiya poxonae petuxusi exanaewa tsane Nacom nexa. Bapoxonae barapo duwein ainya cui, tsipei baraxua xua be pexaethopaewa ainya cui cana exanatsi. ");
INSERT INTO cui_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Daxota pon nayabara cui wʉnae tsimuxu duta xua be pexaethopaewa wʉntha, xua ichaxota duwei tauteiba xua tuxusi exaneiba Nacom nexa, saya meisa jopa barapo wʉnthiyo, mataʉtano jame nayabara cui wʉnae tsimuxu dutsina duwei wʉntha, po duwein baxota bocopiya. ");
INSERT INTO cui_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mataʉtano pon nayabara cui wʉnae tsimuxu duta Nacom pin pia bo wʉntha tatsi, saya jopa meisa barapo wʉnthiyo, mataʉtano jame nayabara cui wʉnae tsimuxu dutsina Nacom pewʉntha tatsi. Tsipei bara Nacom pin pia bothaxae eca. ");
INSERT INTO cui_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Daxota pon nayabara cui wʉnae tsimuxu duta itaboco wʉntha, saya meisa jopa barapo wʉnthiyo, mataʉtano jame nayabara cui wʉnae tsimuxu dutsina Nacom pia pexeinya peecaethopeibiwa tatsi wʉntha beicha mataʉta Nacom pewʉntha tatsi pon baxoteicha eca. ");
INSERT INTO cui_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Paxam pomonae Moisés pia peitorobi coyene painya necuidubi jiwi pam tsobenaem! ¡Paxam pomonae fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Paxam ba caewaxi pajiwana wetsabeibame xua painya catsibeibinexa Nacom poxonae diez xoyobe paxeineibame xua pocotsiwa painya neʉbiwan. Barichi pacana exaname tsiqui xutixitha po xutoxi pewʉn menta, mataʉtano po pexuno pewʉn anís barichi mataʉtano po pexuno pewʉn comino. Bara bequein barapo coyene paexaneibame, daichitha jopa paexanaem pocotsiwa bichocono ainya cui coyenewa pocotsiwa Nacom pia peitorobi coyenewatha itoroba. Mataʉtano jopa paexanaem po cui coyenewatha bewa bara xaniwaicha pata exanaename jiwi. Mataʉtano jopa paexanaem po cui coyenewatha bewa jiwi payabara najʉntʉ coyene xeinaename painya neyawenaenexa jiwi. Mataʉtano jopa paexanaem po cui coyenewatha xua pana cana exaname xua beta painya nejume cowʉntsinexa Nacom. Daxita barapo coyenein jame maisa paexanare, muxuna pa-eexanaponde po coyene copiya pa-eexanaponame, po coyene poxonae pajiwana nonotaponeibame poxonae pocotsiwan diez xoyobe paxeineibame, xua pocotsiwa painya neʉbiwan. ");
INSERT INTO cui_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Paxam barapocotsi coyeneya jʉta pana cana exaname, icha be pon peitata nacʉtsin ichi xua poxonae ichʉn matacapoinchi pon irʉrʉ peitata nacʉtsin! Paxam jopa juniya pacayabara jume exaneibim xua Moisés pia peitorobi coyenewatha itoroba. Daichitha jopa paexanaem po peitorobi coyene peainya cui coyenewa Nacomtha. Barapocotsi jʉta coyeneya paexaname icha jiton ichi poxonae mera mene caewata paparuwatha xua pichixi pemuxuna apaeyainwa, daichitha apara yawa apareca xua xuan poxi peconoxi. ");
INSERT INTO cui_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Paxam pomonae Moisés pia peitorobi coyene tatsi painya necuidubi jiwi pam tsobenaem! ¡Paxam pomonae irʉ fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Paxam jopa ba juniya paexaneibim poxonae meisa panaperʉ iquicame. Daichitha bʉpana iya painya jʉntʉ coyenetha pecaibi coyene paxeiname, peuwi coyeneno paxeiname. Be barapocotsi jiwi pam pocotsimonae coroton saya matawacaicha iquica yawa paratonno, ichitha atutuxuira bichocono. ");
INSERT INTO cui_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Paxam fariseomonae pam, pocotsi jiwimonae pam pomonae be peitata nacʉtsi jiwi pam. Copiya matha pana najʉntʉ cui coyene barapende barapo painya neajʉntʉcoyenebewan, bapoxonae jame xanepanaya painompaename. ");
INSERT INTO cui_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Paxam pomonae Moisés pia peitorobi coyene tatsi painya necuidubi jiwi pam tsobenaem! ¡Paxam irʉ pomonae fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Jiwi ba inyapana exana xua pocotsiwa jiton petʉpaein peyamʉthʉ acatabiwatsi. Bequein bara baxua inyapana daichitha xua matha bocareca bichocono ayei xua jiton petʉpaein. ");
INSERT INTO cui_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Barapocotsi jʉta coyeneya paexaname, icha be pocotsi coyene peayeiwa ichi xua jiton petʉpaein. Bequein panaperʉ wʉnaetame, daichitha painya jʉntʉ coyene abe bichocono. Bequein jiwi paca yabara nanta xeina poxonae paca cui tane xua paxam deta cou pejʉntʉ coyene xanepanae jiwi pam Nacomtha, daichitha painya jʉntʉ coyene bichocono paajʉntʉcoyenebem. Mataʉtano bara bequein paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya pepaebi jiwi pam. ");
INSERT INTO cui_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Paxam pomonae Moisés pia peitorobi coyene tatsi painya necuidubi jiwi pam tsobenaem! ¡Paxam pomonae irʉ fariseomonae pam tsobenaem! Daxita paxam itara mexeya xanepanaya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Paxam petʉpaewi pomonae Nacom pia peitorobi jume pepaebiwi payamʉthʉ acabame boutixi. Mataʉtano pomonae pejʉntʉ coyene xeicae jiwi payamʉthʉ itʉpana exaname. ");
INSERT INTO cui_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mataʉta naerabiya pana najam: ‘Icha caena bayatha jinompaetsipatsi poxonae wamo susato jiwi jinompa metha jopa cueicha yawenaetsipaetsi poxonae barapo Nacom peitorobi jume pepaebiwi jutebatsi’, pana najam. ");
INSERT INTO cui_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Barapo jumetha poxonae baxua pacaunutame, barapara barapo cui coyene paexaname, icha painya amo susato jiwi ichi poxonae barapo jʉntʉ coyeneya exana poxonae jutebatsi Nacom pia peitorobi jume pepaebiwi. ");
INSERT INTO cui_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Painya amo susato jiwi abe peexanaexae, caena bayatha bara paichinde! Poxonae pana nebexubiname moya pana necui yabara jume cui were icha matha painya amo susato jiwi ichi poxonae tamropata notarʉcʉpa xua barapo Nacom pia peitorobi jume pepaebiwi jutebatsi. ");
INSERT INTO cui_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Maisa paxam pomonae pemuxuitorobi jiwi pam! ¡Daxota be jomomonae pacui jʉpame poxoru jomo ba cuitaya dʉcʉpa nawa! Bara paichim anoxuae bequein paichichipame xua Nacom pacuitaya dʉcʉpame xua abe paca exanaeyainwa. Ichitha Nacom paca itorobina ichaxota isoto jopa itacounayiyo. Jopa papanenebiyaem tsane barapo isoto weya. ");
INSERT INTO cui_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Itorobicaein painya xantha pomonae taitorobi jume pepaebiwi. Mataʉta itorobicaein pomonae peyaputaewi. Mataʉtano itorobicaein pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Ichitha barapomonae pajiwana jutebiname. Ichamonae naetotha pacobe matabobiname painya jutebinexa tsane. Ichamonae judiomonae pia penacaetutsi bontha tatsi pabename. Daxita carepaya tomarantha abe pacana eexanaponaename pomonaetha pomonae taitorobi jiwi. ");
INSERT INTO cui_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Daxota Nacom paca cana exanaena xua paca peraxa exanaena xua daxita pomonae pejʉntʉ coyene xeicae jiwi pejujutebaponaexaetsi painya nacuatha. Painya amo susato jiwi jujutebapona pomonae pejʉntʉ coyene xeicae jiwi. Copiya matha Abel bexotsi pon pejʉntʉ coyene xeicaein pon bequein jopa abe exanaeyo, beya poxonae irʉrʉ Zacarías bexotsirʉ pon Berequías pexanto tatsi. Barapon Zacarías pabexubame Nacom pin pia botha ichaxota xua barapo bo tututha uncua pocotsiwa be pexaethopaewa xua ichaxota tuxusi exana Nacom nexa xua irʉ baxota uncua pepa Nacom pia boyo tatsi xua naitama taeuncuabe. ");
INSERT INTO cui_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Bara xaniwaicha paca tsipaebatsi pomonae xua anoxuae pajinompame bichocono paca peraxa jʉbebina tsipei daxita paxam barapara Nacom tsitatsi xua paxam patsita xeiname penatsicuentsiwa xua painya amo susato jiwi pejujutebaponaexae pomonae pejʉntʉ coyene xanepanae jiwi xua irʉrʉ paxam painya nejutebaponaexaerʉ”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Bapoxonae Jesús yabara ʉnthʉthʉ wecoyei Jerusalén tomarapiwi. Jesús wecoyeya namchi, jeye: “¡Maisa Jerusalén tomarapiwi pam pajutebeibame pomonae Nacom pia peitorobi jume pepaebiwi! ¡Mataʉta paxam pajutebeibame ibotontha pomonae Nacom pacata itoroba! ¡Maisa be paca caetucaetuteibinchi, tapaca cayawenaewatsi tsainchi, icha wacara ichi poxonae nacoxi caetucaetuteta pecuarafetha! ¡Maisa be barichocuaein tsane, daichitha jopa paichichipaem! ");
INSERT INTO cui_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Incane pataema Nacom nacui baraxuba xua jopa painya nepaca caewatsiwa tsane. Daxota Nacom jopa poponaeyo pia pin pia botha tatsi painya tomaratha. ");
INSERT INTO cui_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Paca tsipaebatsi xua equeicha jopa pana netaem tsane beya abʉ poxonae pana neyabara jam tsane: ‘¡Maisa bapon jiwi jʉntʉ coyene weiweina cana exanatsi pon patopa, Nacom peitorobixae, pon jiwi Pecanamataxeinaeinchi!’ pana neyabara jam tsane”, jei Jesús fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Nacom pin pia bo tatsi wejoniya. Poxonae nama bara weya pona, bapoxonae Jesús imoxoyo caquita umenarʉcʉpatsi pijimonae. Yawa pijimonae jeichichi: —Maisa Nacom pin pia bo tatsi bepa wʉnae, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Daichitha Jesús jume barai barapomonae, jeye: —¡Moya caepatiyo pataema! Bara xaniyan paca tsipaebatsi. Matacabi jopaena barapo mataqueitha ichamonae pomonae penanapaincha jinompaewi xua icha nacua werena peponaewi abe cana exanaena Nacom pin pia bo tatsi po bo anoxuae pataneme. Apara jopa cae ibotiyo nacopatuncuae tsane icha iboto peʉmatha. Daxita abe tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Bapoxonae Jesús pijimonae barʉ pona demxuwatheicha po demxuwa pewʉn demxu Olivowa tsipei baxota umena olivo naein. Poxonae Jesús demxuwatheicha ecopiya, bapoxonae Jesús pijimonae nameicha tsipaebatsi, jeye: —Paichichipan xua xam tapata netsipaebiwam tsane, ¿eta poxonae metha ichamonae baxua exanaena poxonae abe cana exanaena Nacom pin pia bo tatsi? ¿Eta pocotsiwa tsane metha xua pewʉnaeya tsita itapeinya xeinaena xua poxonae patopeicaename, mataʉtano xua poxonae imoxoyo daxita weraweracaenaba? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nexata Jesús barai, jeye: —Dota pam bʉ ichamonae naerabiya paca muxu tsipaeba xua daxota abe paexanaetsipame. ");
INSERT INTO cui_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tsipei tsana patsina ayei bicheito jiwi pomonae natsicotaena icha be xan ichin. Barapomonae jei tsane: ‘Apara xan Mesías’, jei tsane. Poxonae barapomonae muxuitorobiya paebina bapoxonae pinmonae jume cowʉntsina. ");
INSERT INTO cui_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pajume taename xua jiwi juinya nabenoutsina xote yawa xua juinya irʉrʉ nabenoutsina icha ira beya. Daichitha jopa pajunuwinde, tsipei baxua pewʉnaeya matha copiya tsane. Daichitha cataunxuae dapo matacabi aichica tsane xua poxonae daxita weraweracaenaba yatsicaewa. ");
INSERT INTO cui_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cae nacuapiwi irʉ icha nacuapiwino, barapo ainya nacuapiwibe nabenoutsina. Mataʉtano irʉ pon nacua peewatsin irʉ ichʉndʉ pon icha nacua peewatsin, baraponbe irʉrʉ nantiya nabenabe. Mataʉtano ainya nacuantha pin jainbo nacua tsane tsipei pin mayayo tsane. Mataʉtano domae tsurucuae tsane ainya nacuantha. Mataʉtano ainya nacuantha ira jijiyatsina. ");
INSERT INTO cui_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Baraxua copiya matha tsane xua jiwi atene tsoponae tsane bichocono, xua beya jopa nama juniya tsane. ");
INSERT INTO cui_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Bapoxonae jiwi paca teiquebina, paca atene exanaena mataʉtano paca jutebina. Daxita nacuanpiwi paca casebina painya tana nejume cowʉntsixaemxae. ");
INSERT INTO cui_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Barapo matacabintha jiwi pentsina xua Nacom pejume cowʉntsiwatsi. Mataʉtano daxita jiwi nacasebina, mataʉta barapomonae piamonae caenaetsina ichamonaetha. ");
INSERT INTO cui_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pinmonae tsana pateibina, pomonae jiwi pemuxuitorobiwi. Tsana jei tsane: ‘Xan Nacom peitorobi jume tapaebin, Nacom yabara paca cuidubinchi’, jei tsane. Barapo pemuxuitorobi diwesi jume pinmonae jume cowʉntsina barapo diwesi. ");
INSERT INTO cui_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pinmonae jopa juniya abe exanaponae tsane daxota jiwi, jopa caemonae nantiya naantobe tsaibi tsane. ");
INSERT INTO cui_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ichitha pon awiya xua antʉyapusʉya nejume cowʉntsiya poponaena xua beya yacuiya tʉpaeya jopaena poxonae bequein abe taexanatsi ichamonae, bapon jame Nacom napaeba cana exanaena. ");
INSERT INTO cui_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tamonae capanaena tapexeinya jume diwesi po diwesi xua Nacom waba jiwi petanaexanaenexatsi pijimonae pomonae itorobiya peewatsixae. Barapo diwesi tajiwimonae pomonae tanejume cowʉntsi jiwi paebinoutsina daxita jiwitha. Poxonae barapo diwesi daxita nacuanpiwi jume taena, bapoxonae daxita barapo jiwi yaputaena xua bara matacabi imoxoyo jopaena po mataqueitha poxonae daxita weraweracaenaba. ");
INSERT INTO cui_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Daniel, pon Nacom peitorobi jume pepaebin bapon caena bayatha yabara tsiwʉnaeya muxu dutsiya tina pocotsiwa xua bichocono abe, pocotsiwa xua weraweraca cana exana. Pataename pocotsiwa xua ichʉn Nacom pin pia bo tututha exananotsina, pocotsiwa jopa bewa notsi baxota, pocotsiwa Daniel bayatha yabara paeba. Bapoxonae payaputaename xua bara imoxoyo matacabi jopaenaba poxonae daxita weraweracaenaba”, jei Jesús. (Xan Mateon, paca baraichi: “Pon yorobina po jume diwesi tinan, moya jume naitaewatsina pia peyaputaenexa tsane”, paca jeichi.) ");
INSERT INTO cui_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Cataunxuae Jesús cueicueijei, jeye: “Poxonae bara pocotsiwa pataename bapoxonae pomonae Judea nacuatha jinompa, barapomonae bewa demxuwan berʉcʉpiyaena. ");
INSERT INTO cui_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Barapo matacabitha pon bo matatupatha uncua bapon jopa bewa botha joniya tsane xua penotsiwa tsane pocotsiwa tabobeinchi bomʉxʉ tututha. Saya jame bewa nainya benaetsiricuaena. ");
INSERT INTO cui_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Irʉrʉ pon pabitha popona bapon jopa bewa caibeya ponae tsane botha xua penotsiwa tsane pia paparuwan. Saya jame bewa nainya benaetsiricuaena. ");
INSERT INTO cui_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Pai yabʉxi tsobenae powaxi pexui bʉpana taenatsi barapo matacabitha! ¡Pai powaxi irʉ pexui isaina, barapowaxi tsobenaerʉ! Tsipei acabe tsobenae tsane pexui. ");
INSERT INTO cui_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Poxonae pewʉnaeya tsane baxua Nacom pawʉcare xua jopa painya nerʉcʉpaewa tsane poxonae awʉbo peaquexae bichocono, mataʉtano xua jopa painya nerʉcʉpaewa tsane poxonae pentaquei seicae matacabitha. ");
INSERT INTO cui_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tsipei barapo matacabintha jiwi bichocono pin peraxa exanaeinchi. Atene tsane beyacaincha poxonae jiwi atene tsaibi poxonae Nacom aena nacua exana, xua equeicha nama bichocono pin peraxa tsane. Equeicha bexa bapoxonae bapana jopa baxua exanae tsane poxonae bichocono jiwi pin peraxa. ");
INSERT INTO cui_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Icha Nacom jopa be caentacabiyobe exanaetsipae, metha dapomonae ajibi tsipae pomonae panenebiya barapo peatene coyenewa weya. Daichitha Nacom be caentacabiyobe exanaena peantobexae pijimonae, pomonae pia peitapetsiwixae tatsi. ");
INSERT INTO cui_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Bapoxonae icha ichʉn paca jei: ‘Pataema bapon apara Mesías uncue pon Nacom itorobica’, paca jei, irʉ icha ichʉn paca jei: ‘Pataema bapon Mesías xota uncuiye’, paca jei, baxuan jopa pajume cowʉntsinde barapo jumein. ");
INSERT INTO cui_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tsipei pomonae pemuxuitorobi jiwi tsana patsina. Barapomonae natsicotaena icha be xan ichi ponxaein Mesías. Mataʉtano barapomonae natsicotaena icha be pomonae Nacom peitorobi jume pepaebiwi ichi tsane. Barapomonae pexeinya petsita itʉtsi coyenewan exanaena peitabocotha, po irathe tsaneno xua jiwi pemuxuitorobinexa tsainchi, xua jiwi pejume cowʉntsinexa pocotsiwa barapomonae paeba. Barichirʉ pomonaetha pomonae Nacom pia peitapetsiwi tatsi pemuxuitorobinexa tsainchi, xua irʉrʉ icha metha barapomonae pejume cowʉntsinexa tsanerʉ pocotsiwa barapomonae paeba. Ichitha jopa itacʉpaetsi tsainchi xua barapomonae pemuxuitorobiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Baxua tsiwanaya yabara paca tsiwʉnae muxu dutatsi. ");
INSERT INTO cui_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Daxota icha jiwi paca jei tsane: ‘Pataema bapon Mesías uncuiye ira xuepana susato tsurucuae nacua beya’, icha paca jei, jopa bara beya paponaeinde. Mataʉta icha paca jei: ‘Pataema bapon Mesías xote uncue bomʉxʉ tututha’, icha paca jei, jopa baxua pajume cowʉntsinde. ");
INSERT INTO cui_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Icha yamʉxʉ ichi poxonae jemeicha yacoicha uncueica xua coicha nayotaxuba itabocotha, barichi tsane po matacabitha patopeicaein jemeicha. Xan ponxaein Nacom Tananeitapetsin tsita naitʉtsin daxita jiwi. ");
INSERT INTO cui_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Quequeremonae ba nacaetuta ichaxota baurin boca. Bara jʉta paichim tsane. Paxam pomonae tana nejume cowʉntsi jiwi pam, pana newʉnae ewatsiname po mataqueitha patopeicaein. Bara po mataqueitha pana nacaetutsiname”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Equeicha Jesús namchi: “Po matacabin poxonae nacui wetsina xua jiwi pin peraxa tsane, bapoxonae xometo nainya naquitabina. Jomocoichato jopa pentha tsane. Opiteiton peitaboco weothopeicaena. Mataʉta Nacom napuna torobabiyaena xua xuan itabocotha dubena. Bapoxonae jopa xapain dubenae tsane. ");
INSERT INTO cui_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Bapoxonae daxita jiwi taena peitabocotha xua cou equeicha apara tapatopaewa tsane ponxaein Nacom Tananeitapetsin. Poxonae daxita nacuanpiwi netaena xua patopaein, barapomonae pijunuwi wecoyei tsane. Jiwi netaena ponxaein Nacom Tananeitapetsin xua patopeicaein tsaquinaebowantha. Nacom pia peayapusʉ itorobi coyenewatha, mataʉtano bichocono pexeinya itʉpanae coichatha patopeicaein. ");
INSERT INTO cui_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mataʉtano itorobin tamatatsunpiwi xua bichocono daunweya peobinexa tsane, po peobiwa pewʉn trompeta. Poxonae baxua jume taena tamatatsunpiwi inta caetutsina pomonae taitapetsiwi. Nacaetutsina daxita nacuanpiwi jiwana, irʉ ichamonae pomonae ichaxota xometo weecoinapiwi jiwana, irʉ ichamonae pomonae ichaxota xometo bejopiyapiwi jiwana, irʉ ichamonae pomonae pocotsiwa werenepiwi jiwana, irʉ ichamonae pomonae pocotsiwa berequepiwi jiwana”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Equeicha Jesús jeye: “Pajume taema barapo pecayabara jʉta pepaebi diwesiyo xua higuera nae xua painya nenacuidubiwa tsane. Poxonae ba pataneme xua pena noxu xuxuwapona, bapoxonae ba payaputaneme xua bara imoxoyo wei tsurucuae tsoponae, xua pentono perubenaenexa. ");
INSERT INTO cui_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Barapocotsi jʉta coyeneya ichi tsane poxonae pataename daxita baxuan pocotsiwa aunxuae paca tsipaebatsi, pocotsiwa bexa exanaena, bapoxonae payaputaename, xua bara imoxoyo tsane xua tapatopae wʉnae tsane. ");
INSERT INTO cui_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Bara xainyeya paca tsipaebatsi daxita judiomonae naitapataya naexanaponaena beya yacui othopaena poxonae Nacom exanaena daxita baxuan pocotsiwa xuaunxuae paca tsipaebatsi. Bapoxonae barapo judiomonae weraweracaena. ");
INSERT INTO cui_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Peitaboco aichurucuae tsane, mataʉtano ira aichurucuae tsane. Meisa nama tajumein ataya tsitecaena xua daxota daxita nayabara jume wetsina be pocotsi coyeneya bayatha paeban”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Equeicha Jesús jeye: “Po matacabitha baxua exanaena, mataʉta po horatha baxua exanaena jiwi jopa baxuan yabara yaputaeyo. Irʉ matatsunpiwi pomonae peitaboco beicha jinompa baxuan irʉrʉ jopa yabara yaputaeyo. Irʉ xan, ponxaein Nacom Pexanton baxuan jopa yabara yaputaeinyo. Meisa saya Nacom pon Waxa yaputane poxonae po matacabitha baxua exanaena, mataʉtano yaputane poxonae po horatha daxita exanaena baxua xuaunxuae paca tsipaebatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Equeicha Jesús jeye: “Icha matha ichi poxonae Noé caena bayatha popona jiwi jopa tsaqueinaeyo xua Nacom pin awʉbo exanaena methaunxuae. Saya barompaya icha jʉntʉ cuitha jinompa daxota jiwi werapa. Barichi jʉta ichi tsane poxonae patopeicaein barapo cae pin nacuathe xua ponxaein Nacom Tananeitapetsin. Poxonae patopeicaein jiwi jopa tsaqueinae tsane xua Nacom werapa exanaena barapo jiwi pomonae jopa pejume cowʉntsiyoxaetsi. ");
INSERT INTO cui_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Barapo matacabintha poxonae Noé popona poxonae cataunxuae pin ema jopa duneicaeyo, jiwi jopa tsaqueinaeyo xua bexa pin awʉbo tsane. Barapo jiwi jʉntema nabaneiba yawa apeiba. Yawa jiwitha jijinapona, yawa pexantixi jitha dodoubapona beya yacuiya othopa poxonae po matacabitha Noé pin jera naetha joniya. Bapoxonae pin ema mʉ jopa. Daxita Noé wepu bunothopatsi pomonae jinompa poxonae Noé popona. ");
INSERT INTO cui_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Barapo jiwi jopa awʉbo yabara tsaca jinompaeyo. Barapoxonae jemeicha pin ema uncueica. Mataʉta monapentatsi barapo jiwi. Icha jiwi ichi poxonae Noé popona poxonae barapo jiwi jopa nanta xeinaeyo xua nacabetsina, barichi tsane poxonae xan patopeicaein ponxaein Nacom Tananeitapetsin, jiwi jopa baxua yabara tsaqueinae tsane xua poxonae equeicha patopeicaein. ");
INSERT INTO cui_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Barapo mataqueitha ainya pebinbe nacuara nacuitauyaenabe pabitha. Ichʉn matatsunpin pichina, pejume cowʉntsixaetsi Nacom. Ichʉn saya cuenta ponaeinchi jopa pejume cowʉntsixaetsi Nacom. ");
INSERT INTO cui_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Irʉrʉ ainya yabʉyobe nacuara yacatoyorobauyaenabe. Ichowa matatsunpin pichina, pejume cowʉntsixaetsi Nacom. Ichowa saya cuenta ponaeinchi, jopa pejume cowʉntsixaetsi Nacom. ");
INSERT INTO cui_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tsaca pajinompeibare xua tapatopae wʉnae tsane, tsipei jopa payaputaem po mataqueitha patopaein ponxaein jiwi Tacanamataxeinaein. ");
INSERT INTO cui_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Meje pocotsiwe payaputaema. Icha pon bo pexeinaein yaputaetsipa xua poxonae patopaena pon jiwi pecaibin, bapoxonae bapon jopa maitecaetsipae. Mataʉta bapon jopa copatsipae xua pon pecaibin petajondenaewatsi pia botha. ");
INSERT INTO cui_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Daxota bara paichinde. Tawanaetha pana nacui wʉnaere, tsipei xan, ponxaein Nacom Tananeitapetsin patopeicaein poxonae jopa tsaca payabara jinompaem tsane tsipei jopa payabara nanta xeinaem tsane xua tapatopaewa tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Equeicha Jesús namchi pijimonaetha pecayabara jʉta pepaebi diwesiyo xua pepatopaewa tsane, jeye: “Yabara paca tsipaebatsi pon matacapopona pomonae bo pexeinaein tanacuitatsi. Barapon xanepanaya yaputaeya matacapopona. Poxonae bo pexeinaein wepu warapa barapomonae, pon bo pexeinaein itoroba pontha pon bo petayapucaecaeinchi, jeye: ‘Inta beta matacapoponde, yawa inta beta pexaewa apare daxita matacabi pomonae xua inta nacuita’, jei bo pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pon bo petayapucaecaein bara jʉntʉ coyene weiweinaena poxonae patopaena pon bo pexeinaein petaexaetsi xua bara beta tayapucaeca bo, xuano bara beta peexanaexae pocotsiwa xua bo pexeinaein itoroba. ");
INSERT INTO cui_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Xaniwaicha paca tsipaebatsi. Bo pexeinaein itorobina xua pon petayapucaecaexaetsi bo xua bapon cana exanaeinchi xua equeicha daxita piawan beta petayapuenaewatsi xua xuan xeina pon bo pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ichitha ichacuitha pon bo petayapucaecaein bapon peantʉcuiyapubein tsipae. Bapon pia coutha nanta xeinaetsipa, najei tsipae: ‘Metha bo pexeinaein jopa cuinaya patopae tsane’, najei tsipae pon bo petayapucaecaein. ");
INSERT INTO cui_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Bapoxonae bapon cueinta pomonae pon bo pexeinaein tanacuitatsi. Mataʉtano bapon nanabanaetsipa nawita ichamonae yawa cʉpatsi nanaexanaetsipano. ");
INSERT INTO cui_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bapoxonae pon bo pexeinaein jemeicha patopaena poxonae pon bo petayapucaecaein jopa wʉnae tsaqueinaeyo. Poxonae bara po hora tsuxubi jopa yaputaeyo yawa poxonae barapo matacabi tsuxubi jopa yaputaeyo. ");
INSERT INTO cui_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pon bo pexeinaein itoroba ichamonaetha xua pebenexatsi yawa peperaxa jʉbinexatsi tsainchi pon bo petayapucaecaeinchi. Mataʉtano itoroba xua barapomonae bapon pexubinexatsi ichaxota jinompa pomonae itara mexeya wʉnaeya pepaebiwi ichitha abe peexanaewi. Barapo nacua bereca jiwi bichocono wecoyei pomonae abe peexanaewixae, mataʉtano nantanuweya nantʉ jayabina bichocono peatenexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nexata Jesús equeicha icha pecayabara jʉta pepaebi diwesiyo cuiduba pijimonae, jeye: “Nacom cana exanaena jiwi xua pomonae pejʉntʉ coyene itorobiya ewatsixae, icha pebin ichi poxonae diez powayobetha xua penowaxi cana exana powaxi bapana jopa perʉ nacoyabiyo pebiwi. Barapo diez powayobe nota pia lámparan xua peewatsinexa pon pia pecotsiwa nacoyobina. Barapowaxi barompaya capona pia lámparan xua aceite epaca. ");
INSERT INTO cui_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Icha cinco powayobe barapo diez powaxi jiwana, barapowaxi ita coxanatsi xua penacui wʉnaetsiwa. Icha cinco powayobe ita coxone xua penacui wʉnaetsiwa. ");
INSERT INTO cui_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Barapowaxi powaxi ita coxanatsi xua penacui wʉnaetsiwa barapowaxi poxonae lámparan cajijinca jopa muxuna cajijincaeyo icha aceite xua equeicha pemene epacaenexa poxonae ameneibi tsurubenae. ");
INSERT INTO cui_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Saya meisa powaxi yaputane xua penacui wʉnaetsiwa jame barapowaxi pia lámparan muxuna cajijinca aceite xua equeicha pemene epacaenexa poxonae ameneibi tsurubenae. ");
INSERT INTO cui_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsipei pon imoxoyo pecotsiwa nacoyobina bapon jopa cuinaya patopaeyo, daxota daxita barapo diez powayobe itamaipanarʉcʉpa. Matapainya maitarʉcʉpa. ");
INSERT INTO cui_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Poxonae papae tsuxubi poxonae barapowaxi cataunxuae maita, bapoxonae jume tane pon wawai xua barapowaxi jeichichi: ‘Bara juinya dawerena pebin pon pecotsiwa nacoyobina. Bapon panta enare painya necobe jacobinexa’, jei pon wawai. ");
INSERT INTO cui_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Daxita barapo diez powayobe nacosabarʉcʉpa. Mataʉta equeicha icha aceite epacarʉcʉpa xua bapoxonae pecoicha exanaenexa. ");
INSERT INTO cui_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bapoxonae icha cinco powayobe, powaxi jopa nacui wʉnaetsiyo jeye ichawaxitha xua cinco powayobetha: ‘Panecatsibare icha aceite meraxi pata tha equeicha mene epacaetsi, yaitama pata lámparan acueicheibi’, jei barapowaxi. ");
INSERT INTO cui_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ichitha powaxi penacui wʉnaetsiwaxi jume barai, jeye: ‘Aibi apara, canta peyauxi barompaya pacajijincan patauxi, jopa pacajijincaeinyo xua paxam nexarʉ. Maisa ichaxota pecaenaetsithopaewa aceite bara bepayiyande matha pacomocare aceite xua painya nemene epacaenexa’, jei barapowaxi poxonae xua jume barai ichawaxitha. ");
INSERT INTO cui_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Poxonae cataunxuae ichawaxi enapona xua pecomocaenexa aceite ichamonaetha, bapoxonaerʉ pebin pecoutha patopa, pon pecotsiwa imoxoyo nacoyobina. Powaxi bayatha nacui wʉnaeta napuna jojoniya bapontha xua penanabanaenexa pexaewa xua poxonae barapo pexaewa jiwi tsinacaetuta xua penabanaenexa poxonae barapo pebin pecotsiwa nacoyobina. Bapoxonae bomʉxʉ bichocono boupa cateitabanota. ");
INSERT INTO cui_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Bapoxonae pirapaeyo ichawaxi pata powaxi aceite siwayiya, jeye: ‘Pata Tanecanamataxeinaem, painta boupa saranaxorena’, jei bapowaxi. ");
INSERT INTO cui_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ichitha bapon barapowaxi jume baraichichi, jeye: ‘Canta jopa paca yaitaetsi’, jei bapon”, jei Jesús, xua pijimonae tsipaeba. ");
INSERT INTO cui_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Bapoxonae Jesús barai pijimonaetha, jeye: “Tawanaetha pana najʉntʉ coyene wʉnaere, tsipei jopa payaputaem po matacabitha patopaein, mataʉtano jopa payaputaem po horatha patopaein ponxaein Nacom Tananeitapetsin”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Equeicha Jesús pijimonae cuiduba pecayabara jʉta pepaebi diwesiyo xua paratixi, jeye: “Anoxuae ichichipan xua tapaca tsipaebiwatsi po coyene xua xan beta matomacan pomonae inta beta penacuichiwi pomonae Nacom jʉntʉ coyene itorobiya ewata. Barapo coyene jʉpa icha be poxonae pebin ichi poxonae bara juntucuru warapaenaba icha nacua beya. Pewʉnaeya poxonae warapaenaba matha waba pomonae pia petanacuichi jiwichi tsainchi. Barapomonaetha itoroba xua pia paratixi tatsi beta petacacomocaewa tsainchi poxonae cataunxuae wʉnae ewatatsi xua pepatopaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ichʉntha pomonae barapomonae jiwana cata cinco mil po paratiximonaebe. Irʉ ichʉntha cata dos mil po paratiximonaebe. Irʉ ichʉntha cata saya be cae mil po paratiximonaebe. Bapon daxita barapomonaetha barompaya catsiba be pocotsi coyeneya barapomonae yapu jʉpatsi xua poxonae pecacomocaewa tsane barapo paratiximonaetha. Bapoxonae bapon warapa. ");
INSERT INTO cui_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pon catatsi cinco mil po paratiximonaebe, barapo cinco mil po paratiximonaebetha equeicha icha cinco mil po paratiximonaebe matoma exana. ");
INSERT INTO cui_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Barichi pon catatsi dos mil po paratiximonaebe, barapo dos mil po paratiximonaebetha equeicha matoma exana icha dos mil po paratiximonaebe. ");
INSERT INTO cui_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ichitha pon catatsi cae mil po paratiximonaebe, bapon mʉthʉ cua iratha. Bapoxonae barapo mʉthʉtha bota barapo cae mil po paratiximonaebe”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Equeicha Jesús jeye: “Poxonae ainya matacabin yapucaewa, bapoxonae patopa pon paratixi catsiba barapomonaetha pon barapomonae pia pecanamataxeinaeinchi tatsi. Bapon pia petanacuichiwichi pia paratixi matoma yabara yainyaba. ");
INSERT INTO cui_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Copiya patopa pon cinco mil po paratiximonaebe catatsi. Bapon icha cinco mil po paratiximonaebe cata pia pecanamataxeinaeinchitha, yawa jeye: ‘Tanecanamataxeinaem, caena bayatha cinco mil po paratiximonaebe necatame, equeicha icha cinco mil po paratiximonaebe cata matoma exainchi’, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Pon pecanamataxeinaein jume nota, jeye: ‘Maisa jʉntʉ coyene wʉnaem mataʉtano xam ponxaem cayabara jume cowʉntatsi xua xanepanaya neexaneibiwam pocotsiwa caitorobatsi. Tsipei inta xanepanaya beta exaname bequein poxonae be conotha caitorobatsi, daxota equeicha ichawa caitorobatsi xua bichocono nawita. Moya tabotha nebarʉ joniyama yawa nebarʉ jʉntʉ coyene weiweinare’, jei pon pecanamataxeinaein. ");
INSERT INTO cui_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Bapoxonae pirapae ichʉn patopa pon dos mil po paratiximonaebe catatsi yawa jeye pia pecanamataxeinaeinchitha: ‘Tanecanamataxeinaem, caena bayatha dos mil po paratiximonaebe necatame, equeicha icha dos mil po paratiximonaebe cata matoma exainchi’, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pon pecanamataxeinaein jume nota, jeye: ‘Maisa jʉntʉ coyene wʉnaem mataʉtano xam ponxaem cayabara jume cowʉntatsi xua xanepanaya neexaneibiwam pocotsiwa caitorobatsi. Tsipei inta xanepanaya beta exaname bequein poxonae be conotha caitorobatsi, daxota equeicha ichawa caitorobatsi xua bichocono nawita. Moya tabotha nebarʉ joniyama yawa nebarʉ jʉntʉ coyene weiweinare’, jei pon pecanamataxeinaein”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Equeicha Jesús jeye: “Bapoxonae matapainya patopa pon cae mil po paratiximonaebe catatsi. Bapon atsaquiya jei pia pecanamataxeinaeinchitha: ‘Tanecanamataxeinaem, xan yaputan xua xam be barapocotsim pon jopa jiwi juniya itorobeibim. Mataʉtano jiwi cobe itorobeibame xua penoteibiwa pocotsiwa jopa jinyawiyo. Mataʉtano pexaewa xua naweta noteibame ichaxota jopa ʉbim. ");
INSERT INTO cui_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Daxota cacunuwatsi baxua neexanaeinxae tsipei metha inta pichipame barapo paratiximonaebe poxonae equeicha icha paratiximonaebe cata matoma exainchi daxota jinya paratiximonaebe mʉthʉtha xubotan. Xote barapo paratiximonaebe caewa cata canawitatsi’, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nexata pon pecanamataxeinaein namchi jeye: ‘¡Bepa maisa dapon abem, pon fifiname poxonae inta nacuitame! Xam apara neyabara nanta xeiname xua xan pexaewa tanoteibiwa pocotsiwa naweta ichaxota jopa tacoya ʉbeibinyo. Mataʉtano xua ichamonae cobe itorobeiban xua noteiba pocotsiwa jopa tawiyo. ");
INSERT INTO cui_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tsipei catsawiya neyabara nanta xeiname, xua bichocono daunwei itoroban daxota bayatha inta bewa barapo paratiximonaebe banco botha botsipame. Nexata poxonae equeicha patopan, icha paratiximonae equeicha matoma xeinaetsipan xua equeicha inta pemataropeicha botsixaetsipae poxonae ichamonae nacowaeta barapo taparatiximonaebe’, jei pon pecanamataxeinaein. ");
INSERT INTO cui_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bapoxonae pon pecanamataxeinaein barai pomonae baxota umena jeye: ‘Bapon pacobe wepire barapo cae mil po paratiximonaebe. Bapoxonae barapo paratiximonaebe pacare pon icha diez mil po paratiximonaebe xeina. ");
INSERT INTO cui_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pon ba be conotha Nacom yabara yaputainchi Nacom bapontha cana exanaena xua ichawa peyabara yaputaewa tsane xua beya poxonae bapon equeicha bichocono Nacom pejume cowʉntsiwa tsainchi. Pon ba jopa ichipaeyo xua Nacom peyabara yaputaewatsi, Nacom wepichina po coyene bapon yaputane xua beya daxota Nacom jopa pejume cowʉntsiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mataʉta bapon pon inta beta jopa nacuichiyo bapon paxore peitaquirei nacuatha, xua barapo nacuatha pewecoyeinexa, xua nantanuweya penantʉ jayabinexa tsane’, jei pon pecanamataxeinaein”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Equeicha Jesús pijimonae tsipaeba, jeye: “Xan, ponxaein Nacom Tananeitapetsin patopeicaein, irʉ matatsunpiwi nebarʉ patsicaena. Poxonae patopeicaein, bapoxonae ecaein pexeinya peitʉpanae ecaewatha xua tawa tayabara paebinexa daxita jiwi xua penatsicuentsiwa abe peexanaexae Nacomtha. ");
INSERT INTO cui_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jiwi nacaetutsina taitabaratha pomonae daxita nacuan werena pona. Barichin tsane icha pon oveja peewatsin ichi. Bapon ba tsaba ovejamonae, mataʉtano tsaba icha duweimonaeno, po duweimonae pewʉn cabra. ");
INSERT INTO cui_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pon ovejamonae peewatsin, bapon ovejamonae cuaranoba pecoxa weya. Cabra duweimonae petsocona weya cuaranoba. Bara cana jʉtiya ichin tsane jiwitha, icha pon ovejamonae peewatsin ichi. Pomonae xanepanaya peexanaewi tsana nobin. Pomonae abe peexanaewi tsana nobin. ");
INSERT INTO cui_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bapoxonae xan ponxaein jiwi itorobiya pepa Taewatsin baran tsane pomonae tacoxa weya inta umena, jan tsane: ‘Anetha paxam pomonae Nacom, Taxa, paca jʉntʉ coyene weiweina exana. Pajojoniyama Nacom pia peitorobi nacuatheicha. Bara xoteicha caena bayatha Nacom paca tsiwʉnaeta pocotsiwa xua paxam nexa, beya poxonae barapo nacue forota. ");
INSERT INTO cui_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Paca itacʉpa xua papatame baxoteicha, tsipei poxonae jainpan bayatha, bapoxonae pana neapatame pexaewa. Mataʉta tsipei poxonae meratsipan, bapoxonae mera pana neapatame. Mataʉta tsipei bayatha poxonae patopan painya botha poxonae be wawatsiyo coyeneya patopan daichitha pana nententa weyataeya wabame. ");
INSERT INTO cui_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mataʉtano tsipei poxonae bayatha jumasa patopan, bapoxonae paparuwa pana necatame. Mataʉtano tsipei poxonae bayatha neromaeba yawa poxonae atenein bara pana nesiwa poname painya tana neyawenaenexam. Mataʉtano tsipei poxonae jiwi pecʉbi botha neeta, paxam papatame painya tana nenecotsinexam’, jan tsane xua ponxaein jiwi itorobiya pepa Taewatsin. ");
INSERT INTO cui_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nexata barapomonae, pomonae tacoxa weya inta peumenaexae pomonae xanepanaya peexanaewi, nejei tsane: ‘Pata Tanecanamataxeinaem, ¿eta poxonae paca tainchi xua jainpame mataʉta xua poxonae paca apatʉtsi pexaewa? ¿Eta poxonae paca cui tainchi xua meratsipame xua bapoxonae mera paca apatatsi? ");
INSERT INTO cui_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Eta poxonae paca tainchi xua poxonae be wawatsiyo coyeneya patopame xua bapoxonae paca matenta weyataeya wabatsi? ¿Eta poxonae paca tainchi xua poxonae jumasa patopame xua bapoxonae paca catatsi paparuwa? ");
INSERT INTO cui_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Eta poxonae paca tainchi poxonae caromaeba xua poxonae atenemno xua bapoxonae paca siwa poinchi pata paca cayawenaenexatsi? ¿Eta poxonae paca tainchi poxonae jiwi pecʉbi botha caeta xua bapoxonae papatan pata cataenexatsi?’ nejei tsane barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bapoxonae xan ponxaein jiwi itorobiya pepa Taewatsin, jume notsin barapomonaetha jan tsane: ‘Xaniyan paca tsipaebatsi. Daxita po coyenewan paxam bayatha paexaname tamonae jiwitha poxonae bequein barapomonae jopa peainya cui jiwiyo, apara bara painta exaname’, jan tsane ponxaein jiwi itorobiya pepa Taewatsin. ");
INSERT INTO cui_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nexata xan ponxaein jiwi itorobiya pepa Taewatsin baran tsane pomonae tatsocona weya peumenaewi, pomonae jopa beta peexanaewi, jan tsane: ‘Panatsixibarʉcʉpare taxainya weya, tsipei paxam pomonae abe painya neexanae jiwi pam. Maisa po nacuatha isoto jopa cuinaya itacounayiyo baxota paponare. Barapo iso nacua caena bayatha Nacom yabara wʉnaeta caurimonae pia pentacaponaein tatsi nexa irʉrʉ pia matatsunpiwimonae tatsi nexa pomonae caurimonae. ");
INSERT INTO cui_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tsipei poxonae jainpan bayatha, jopa pexaewa pana necatsim. Mataʉta tsipei poxonae bayatha meratsipan, jopa mera pana neapatsim. ");
INSERT INTO cui_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mataʉtano tsipei caena bayatha poxonae be wawatsiyo coyeneya patopan, paxam jopa pana nententa weyataeya wabim. Mataʉta tsipei poxonae bayatha jumasa patopan, paxam paparuwa jopa pana necatsim. Mataʉtano tsipei caena bayatha poxonae neromaeba yawa poxonae jiwi pecʉbi botha ecan, paxam jopa pana nesiwa ponaem’, jan tsane. ");
INSERT INTO cui_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nexata pomonae abe peexanaewi nejume notsina, jei tsane: ‘Pata Tanecanamataxeinaem, ¿eta poxonae xua pata paca cui taewathatsi xua jopa paca yawenaetsi? ¿Eta poxonae xua pata paca cataebenaewathatsi poxonae jainpame? Mataʉtano ¿eta poxonae xua pata paca cataebenaewathatsi poxonae meratsipame? Mataʉtano, ¿eta poxonae xua poxonae pata paca cataebenaewathatsi poxonae be wawatsiyo coyeneya patopame? Mataʉtano, ¿eta poxonae xua poxonae pata paca cataebenaewathatsi poxonae caromaeba? Mataʉtano, ¿eta poxonae xua poxonae pata paca cataebenaewathatsi poxonae jiwi pecʉbi botha caeta? Daxita baxuan, ¿eta poxonae xua poxonae jopa paca yawenaetsi?’ nejei tsane barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Xan ponxaein jiwi itorobiya pepa Taewatsin jume notsin barapomonae jan tsane: ‘Xaniyan paca tsipaebatsi. Daxita po coyenewa bayatha jopa paexanaem tamonae jiwitha xua barapomonae jopa peainya cui jiwiyoxae, apara bara jopa painta exanaem’, jan tsane ponxaein jiwi itorobiya pepa Taewatsin. ");
INSERT INTO cui_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bexa bapoxonae tsane barapo abe peexanae jiwi ponaena po nacuatha bapana jopa nacui copatsi xua atene. Pomonae pentʉ cui xanepanae jiwi ponaena po nacuatha jiwi xeineiba peantʉcoyeneyapusʉwa, po peantʉcoyeneyapusʉwa ataya tsiteca”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Poxonae Jesús baxua daxita najume weta, bapoxonae pijimonae barai, jeye: ");
INSERT INTO cui_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Paxam payaputaneme xua poxonae po baya tsane, jiwi nacaetutsina penabanaenexa pexaewa peyabara nanta xeinaenexa barapo matacabi xua poxonae caena bayatha matha judiomonae Egipto nacua weya panenebiya, po matacabi pewʉn Pascua matacabi wʉn. Barapo mataqueitha ichamonae necaenaetsina xua tʉparucua tanaexanaenexa tsane naetotha, ponxaein Nacom Tananeitapetsin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Poxonae Jesús pijimonae baxua tsipaebuncua, bara caena barapo mataqueitha sacerdotemonae pia pentacaponaewi tatsi nacaetuta. Irʉrʉ baxota nacaetuta judiomonae pia pitiri jiwi tatsi. Barapomonae daxita nacaetuta po tututha pon pewʉn Caifás pon sacerdotemonae pia pepa pentacaponaein tatsi pia pexeinya tutu botha tatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Daxita barapomonae nabarʉ muxu jei xua bepa pinae eta bichi tsane poxonae Jesús nameicha waetabinchi xua pebexubiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Barapomonae najei: —Abʉ jopa waetabi tsainchi poxonae jiwi Pascua matacabi wʉntha nacaetuta penanabanaenexa pexaewa. Tsipei icha barapo mataqueitha waetabichipatsi pinmonae anaepanaya najume cayayataxubichipa, najei daxita barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pirapae Jesús popona Betania tomaratha. Barapo tomaratha Jesús popona Simón pia botha tatsi, pon copiya bayatha peperʉ sawinchi. ");
INSERT INTO cui_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Barapo botha petsiriwa powa pesi cui weiweinaewa Jesús imoxoyo caquita uncuatabatsi. Barapo petsiriwa capatopa alabastro ibo wʉn bosibʉ atsato, xua bichocono wʉnca penasiwa xua petuxueiwa, po petuxueiwa bichocono ainya matoma. Poxonae Jesús eca pexaethopaewatha, bapoxonae barapo petsiriwa Jesús mata epatabatsi barapo petuxuei tuxusi nasiwatha. ");
INSERT INTO cui_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Poxonae Jesús pijimonae tatsi tane baxua, barapomonae bichocono anaepana, yawa caemonae najeino: —¿Eta pocotsiwa metha saya baxua xuba jane? ");
INSERT INTO cui_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Barapo petuxueiwa becaenaetsipatsi bapoxonae bexeinaetsipatsi paratixi nawita xua bapoxonae barapo paratixitha beyawenaetsipatsi peacopeibi jiwi, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús yaputane xua pijimonae tatsi baxua pepaebiwa, daxota Jesús jeye: —¿Eta pocotsiwa metha barapowa pabiataneme? Pocotsiwa barapowa inta exana apara seicayarʉ xua pexeinya coyene inta exana. ");
INSERT INTO cui_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Barapo irathe peacopeibi jiwi paca barʉ jinompeibina painya neyawenaenexa tsaibi tsane barapo jiwi. Ichitha nama paxam jopa ataya paca barʉ poponae tsainchi xua pata tana neyawenaenexam barapo irathe. ");
INSERT INTO cui_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Barapowa xua nenta epataraba tapepontha xua petuxuei tuxusi nasiwatha apara xua tsiwanaya nenacui yabara nacui wʉnaeta xua mʉthʉ tana neboyaenexa poxonae tʉpaein. ");
INSERT INTO cui_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Bara xaniyan paca tsipaebatsi, daxita nacuantha poxonae jiwi cueicueijei tsane Nacom pia pecapanenebiyae diwesi, barapo jiwi yawa yabara paebina xua pocotsiwa poxonae bapowa inta exana xua jiwi barapowa peyabara cui nanta xeinaenexatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nexata Jesús pijimonae tatsi pomonae doce poyobe tatsi, barapo doce poyobe jiwana bara caein, bapon pewʉn Judas Iscariote. Bapon Judas pona sacerdotemonae pia pentacaponaewi tatsi beya xua petsipaebinexa barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Judas jeye barapomonaetha: —¿Eta po paratixi pana necatsiname icha Jesús caenaetaxubin, painya xantha? jei. Nexata barapomonae Judas pentoma catatsi treinta po paratiximonaebe, xua po paratixi bichocono matoma nawita. ");
INSERT INTO cui_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Barapoxonae Judas tamropata pitaba xua jeita xua po coyenetha Jesús pecaenaetaxubiwa tsainchi barapomonaetha, poxonae peyapu xanepanaewatha. ");
INSERT INTO cui_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nexata copiya matacabi jopa po matacabi tsiwana penantacarucuae matacabi, xua po matacabintha poxonae jiwi tsinacaetutsina xua penabanaewa tsane pan, po pan jopa muxunapentsiyo levadura matawʉn, pocotsiwa xua cotowa exana pan. Jesús imoxoyo caquita umenarʉcʉpatsi pijimonae yawa Jesús jeichichino: —¿Exota ichichipame xua ichaxota pexaewa paca tsinacui wʉnaetsinchi wanabanaenexa tsane xua Pascua wʉn matacabi nexa? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús barai pijimonae, jeye: —Tomara beya paponde, Jerusalén tomara beya. Paponde po botha pon bichocono pin tutu xeina. Bapontha painta jande: ‘Pon jiwi Pecuidubin namchi: Bara nama tatʉpae wʉnae tsane. Jinya tututha tajiwimonae tha barʉ nabanaetsi pexaewa Pascua wʉn matacabi nexa’, cajei pon jiwi Pecuidubin, pajande, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesús pijimonae tatsi bara exana pocotsiwa bayatha Jesús pijimonae peitorobixae. Mataʉtano barapomonae pexaewa nacui wʉnaetajeba Pascua wʉn matacabi nexa xua penabanaenexa. ");
INSERT INTO cui_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Poxonae quirei tsanaicha bapoxonae Jesús pijimonae barʉ eca pexaethopaewatha pomonae doce poyobe tatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Poxonae Jesús pijimonae barʉ xunaeca bapoxonae barai pijimonae, jeye: —Bara xaniyan paca tsipaebatsi caein pon paxam jiwana pam, bapon necaenaetaxubina ichamonaetha xua tana nebexubiwa tsane ichamonae, jei. ");
INSERT INTO cui_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nexata bapoxonae Jesús pijimonae tatsi ʉnthʉthʉ wecoyei tsʉrʉcʉpae, nexata daxita tsana jei tsoponae Jesustha: —Tanecanamataxeinaem, apara ¿xan cacaenaetaxubinchi? jei daxita barapomonae xua Jesús tsana yainyabapoinchi. ");
INSERT INTO cui_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús jume nota barapomonae, jeye: —Pon cae paratotha pana nabarʉ jajaucuncuaponanbe pan, bapon apara pon necaenaetaxubina ichamonaetha. ");
INSERT INTO cui_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xan ponxaein Nacom Tananeitapetsin bewa tʉpaein, tsipei Nacom Pejume Diwesitha baxua neyabara paeba caena bayatha. Ichitha pebin tsocuae pon necaenaetaxubina ichamonaetha. Metha jame wʉnae tsipae icha bapon bayatha jopa naexaenae tsipae, tsipei bexa tsane bichocono atene tsocuae tsane, bichocono abe tana necana exanaexae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nexata Judas pon Jesús caenaetaxubinchi bapon itacaretaba, jeye Jesustha: —Pon jiwi Necuidubim, ¿xan apara cacaenaetaxubinchi? jei Judas. Jesús jume nota, jeye: —A, xuaunxuae bara paebame, jei. ");
INSERT INTO cui_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Poxonae Jesús pijimonae barʉ xunaeca, bapoxonae Jesús pecobetha pita pan yawa Paxatha tsipaeba, jeye: “Axa, maisa jʉntʉ coyene weiweinan xua pan pata tana necatsiwam”, jei. Bapoxonae Jesús pecobetha pan epa janaca yawa catsiba pijimonae. Bapoxonae pijimonae barai, jeye: —Paxaema po pan epa janacan. Barapo pan apara yabara caunuta tapepon xua poxonae tapaca tsitʉpaewatsi tsainchi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Bapoxonae Jesús equeicha pecobetha pita corotiyo yawa Nacomtha tsipaeba, jeye: “Axa, maisa jʉntʉ coyene weiweinan xua corotiyotha ecareca pepa uva mera xua pata tana necatsiwam”, jei. Bapoxonae Jesús pijimonae cata corotiyo xua pejiwana aapaponaenexa. Bapoxonae jeye pijimonaetha: —Daxita pa-aapaponde xua barapo cae corotiyotha. ");
INSERT INTO cui_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Pena peyabara tsiwʉnae muxu dutsi coyenewa paca tsipaebatsi. Barapo uva mera xua tsijuntutu eca corotiyotha barapo mera yabara caunuta tajana xua jana othoparenaein poxonae tʉpaein. Barapo jana tsita itapeinya xeinaena xua jiwi pinmonae, yabara jʉntemainaein abe pia peexanae cuiru coyenein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Daxota paca tsipaebatsi barapo uva mera jopa equeicha paca barʉ apae tsainchi anoxuae. Meisa abʉ bexa tsane equeicha pena coyenewatha paca barʉ apaeinchi, barapo uva mera poxonae Nacom neexanaena xua itorobiya ewatsin jiwi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Poxonae Jesús pijimonae barʉ najume weta xua naxʉna Nacom nexa, bapoxonae Jesús pijimonae barʉ pona demxuwa beya. Barapo demxuwa pewʉn demxu Olivowa, olivo naein peumenaexae baxota. ");
INSERT INTO cui_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nexata Jesús barai pijimonae, jeye: —Anoxuae barapo merawithe daxita pam pana necuentarʉcʉpaename, tapaca urapentsixaetsi tsainchi. Baxua paexanaename tsipei Nacom Pejume Diwesitha paca yabara cui tsiwʉnaeya jeye: ‘Poxonae ovejamonae peewatsin bexubinchi, bapoxonae ovejamonae tsanarʉcʉpaena’, jei Nacom. Penamchixae poxonae ichamonae newaetabina tana nebexubinexa pana necuentarʉcʉpaename. ");
INSERT INTO cui_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ichitha taeyarapaeyo poxonae equeicha asʉ neexanaena, bapoxonae paca tsiwana patopiyaeinchi Galilea nacua beya poxonae bara beya paponaename, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nexata Pedro Jesús jume notatsi, jeye: —Bequein ichamonae cacuentarʉcʉpaena jinya neuraxubixae nama xan bapana jopa cacuenta naetsiricuae tsainchi tana neuraxubixaemxae, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Nexata Jesús Pedro jume baraichi, jeye: —Bara xainyeya catsipaebatsi po merawithe, pewʉnaeya poxonae beya ainya jume cuiyobetha wacara pebto fibina, bapoxonae xam copiya acoibi po jume cuiyobetha neyabara jam tsane: ‘Jopa dapon yaitaeinyo’, neyabara jam tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro Jesús baraichi: —Bara bequein capuna tʉpaeinchi ichitha baxua jopa cayabara paebi tsainchi, jei Pedro. Irʉrʉ daxita Jesús pijimonae tatsi bara jumichi, nanta jʉpiya paeba. ");
INSERT INTO cui_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nexata Jesús pijimonae barʉ patopa ichaxota tsica iriyo, po iriyo pewʉn Getsemaní. Baxota Jesús barai pijimonae, jeye: —Xote abʉ paenare tha matha Taxatha tsipaebichi painya cuariyatha xotiye, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús barʉ pona Pedro. Irʉ Zebedeo pexantobe tatsi Jesús barʉ pona. Bapoxonae Jesús bichocono ʉnthʉthʉ wecoyei, yawa bichocono ʉnthʉthʉ deideijei. ");
INSERT INTO cui_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nexata barapo acoibi poyobetha Jesús barai, jeye: —Bichocono jʉntʉ coyene natsepiya wecoyan, tsipei muxu tatʉpae. Xote paenare, yawa payoyocare xua painya tana nebarʉ naitaewatsinexam, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nexata Jesús equeicha tsiwiyo dabe natsixitabiya, irabe taeuncuareca tsipei jopa juniya ajʉntʉtaneyo. Bapoxonae Jesús Paxa tsipaeba, jeye: —Axa, icha ichichipame xua tana neyawenaewam tsane, newepire pocotsiwa anthʉthʉtane neexana. Ichitha jopa necana exanaeinde xua pocotsiwa ichichipan, saya jame necana exande xua pocotsiwa ichichipame, jei. ");
INSERT INTO cui_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nexata Jesús equeicha caibe iya pijimonae tatsi beya poyobe xua acoibi poyobe, ichitha barapomonae maita. Jesús Pedro baraichi, jeye: —Maisa jopa paca itacʉpaeyo xua pata tana nebarʉ yoyocaewam xua poxonae bequein bara cae horatha. ");
INSERT INTO cui_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Maisa payoyocare. Nacom patsipaebare xua jopa abe painya neexanaewa tsane poxonae caurimonae pia pentacaponaein tatsi piraichi paca jʉntʉ coyene jʉjʉta. Painya jʉntʉ coyene wetsina bichocono paichichipame xua Nacom painya netsipaebiwa ichitha painya pepon bichocono paacoyenefaetabim xua painya netsipaebiwa Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Equeicha Jesús bara nama caeto pona xua Paxa petsipaebinexa. Poxonae Paxa tsipaeba, jeye: —Axa, icha jopa ichichipaem xua tana newepichiwam, pocotsiwa neajʉntʉtane exana, bara jopa necana exanaeinde xua pocotsiwa ichichipan saya jame necana exande xua pocotsiwa ichichipame, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bapoxonae equeicha Jesús pijimonae beya pona xua acoibi poyobe daichitha barapo acoibi poyobe came maitumena, tsipei bichocono itata tsacatsaquei xua itamaipana. ");
INSERT INTO cui_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Bara nexata Jesús equeicha saya cuentapona. Equeicha Jesús pona xua Paxa petsipaebinexa xua equeicha acoibi po cuiyobetha, barapo jumetha equeicha Jesús Paxa tsipaeba. ");
INSERT INTO cui_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nexata equeicha Jesús pona pijimonae tatsi beya. Bapoxonae barai pijimonae, jeye: —¡Moya bara painya nepu maitumenaeinde aunxuae jopa Nacom patsipaebim xua painya nepaca cayawenaenexa! Bayatha tsuxubiba, po horatha poxonae xua xan ponxaein Nacom Tananeitapetsin ichʉn necaenaetaxubina ichamonaetha, pomonaetha pomonae peantʉcoyenebe jiwi. ");
INSERT INTO cui_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Panacosapende, panonobapondeno. Antha bʉ poinchi. Dota dawerena pon necaenaetaxubina ichamonaetha, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Poxonae Jesús cataunxuae tsipaebuncua pijimonae bapoxonae Judas patopa. Bapon Judas doce poyobe jiwana caein, xua Jesús pepa pijimonae tatsi. Judas pinmonae barʉ patopa. Ichamonae cusin cajijinca. Ichamonae iwabi cajijinca. Daxota daxita barapomonae pata, tsipei sacerdotemonae pia pentacaponaewi tatsi irʉ pitiri jiwirʉ daxita barapo pentacaponaewi itoroba barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, pon Jesús caenaetaxubinchi, pewʉnaeya tsane xua poxonae patopa bapon cou tsiwanaya paeba barapo pin bicheitotha, cou jeye: “Pon tsutsubin, bapon apara barapo pebin, nexata moya pawaetabare bapon”, cou jei. ");
INSERT INTO cui_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Daxota poxonae patopa, bapoxonae Judas Jesús imoxoyo caquita poinchi, mataʉta nainya Jesús jeichichi: —Pon jiwi Pecuidubim, xamda, jei Judas. Bapoxonae nainya Judas Jesús tsutsubatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nexata Jesús jume nota, jeye: —Ponxaem tajitom, moya bara exande xua jinya necana exanaetsi, jei. Nexata barapomonae pomonae Judas pebarʉ patopaexae barapomonae Jesús imoxoyo caquita umenarʉcʉpatsi, bapoxonae Jesús waetabatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Caein pon Jesús pijimonae tatsi jiwana, pon Pedro, bapon nainya cusi namara wejonta. Bapoxonae bapon muxuyoro catsoniba, pon sacerdotemonae pia pepa pentacaponaein tatsi tanacuitatsi, bapon muxuyoro catsonibatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nexata Jesús barai pijimonae jiwana jitontha, pon Pedro, jeye: —Maisa cusi jeinca pentacuerutha. Tsipei pon ba cusitha namawainta, bapon ba xuya bexubinchi cusitha. ");
INSERT INTO cui_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¡Maisa xam jopa yaputaem! Icha ichichipan bara neitacʉpa xua Taxatha tawʉcaewa, xua nainya inta peitorobinexa pia matatsunpiwi xua bichocono ayei pin bicheitomonae xua tana neyawenaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Icha Taxa wʉcaetsipan xua bapon tana neyawenaewa tsane bapoxonae jopa neyabara jume cui wetsipae po coyene bayatha Nacom Pejume Diwesitha neyabara paeba, po coyene xua tana newaetabiwa tsane xua tana nebexubiwa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nexata Jesús barai pomonaetha pomonae Judas barʉ patopa, jeye: —Pacapatame cusin yawa iwabi be poxonae pacana ichim pontha pon jiwi pecaibin. Daxita matacabin Nacom pin pia botha tatsi paca barʉ poponeibatsi, paca cuidubeibatsino, daichitha bapoxonae jame jopa pana newaetabim. ");
INSERT INTO cui_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ichitha daxita baxuan neyabara canacui jume weta exana, bayatha penecui yabara wʉnae tsiwanaya paebixae pomonae Nacom peitorobi jume pepaebiwi, Nacom Pejume Diwesitha, jei Jesús. Bapoxonae Jesús cuentarʉcʉpatsi pijimonae, meisa Jesús barʉ umeinchi pomonae Judas bayatha barʉ patopa. ");
INSERT INTO cui_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pomonae Jesús teicatsi barapomonae Jesús capoinchi pon pewʉn Caifás itabaratha tatsi. Bapon Caifás, pon sacerdotemonae pia pepa pentacaponaein tatsi pon peainya cuin yatsicaya. Baxota irʉ nanacaetuta pomonae judiomonae pecuidubiwichi Moisés pia peitorobi coyene tatsi, irʉrʉ pitiri jiwi pomonae judiomonaexae. ");
INSERT INTO cui_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Irʉ Pedro Jesús tsiwiyo tajʉ pu taetae tsiniyatsi beya poxonae patopa panatha, po panatha ichaxota sacerdotemonae pia pepa pentacaponaein tatsi tauncuatsi bo. Poxonae Pedro pana tututha joniya bapoxonae imoxoyo naeca policiamonaetha pecui taenexa xua po coyeneya Jesús cana exanaeinchi pomonae nacaetuta. ");
INSERT INTO cui_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sacerdotemonae pia pentacaponaewi tatsi irʉ ichamonaeno, pomonae pecanamata caitorobi jiwi bicheito, daxita barapomonae jeita ichamonae pomonae xua Jesús naerabiya peyabara paebinexatsi pocotsiwa xua Jesús paeba xuano xua exana, pia barapo jumetha paebichi xua bara Jesús tʉpa peexanaewa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Bara bequein pin bicheito pata xua Jesús abeya peyabara paebinexatsi, ichitha cataunxuae barapomonae pomonae pecanamata caitorobi bicheito, came jopa xeinaeyo po jume naemata jume tsita itapeinya xeina pocotsiwa xua Jesús paeba xua barapo jumetha Jesús pebexubinexatsi. Matapainya bapoxonae pebinbe nacueyatabe patopabe. Baponbe Jesús abeya yabara paebatsibe. ");
INSERT INTO cui_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Baraponbe jeibe Jesús yabara: —Bapon namchi: ‘Neitacʉpa xua Nacom pin pia bo abe taexanaewa. Bapoxonae equeicha acoibi po matacabibe barapo Nacom pin pia bo tatsi xanebin’, jei, jeibe baponbe. ");
INSERT INTO cui_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nexata bapoxonae sacerdotemonae pia pepa pentacaponaein tatsi asiya uncuataba yawa bapoxonae Jesús baraichi, jeye: —¿Jopa jume notsim barapomonae? ¿Bara xainyei xua po jumein barapomonae cayabara paeba? jei sacerdotemonae pia pepa pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Daichitha saya Jesús moya uncua. Daxota bapoxonae sacerdotemonae pia pepa pentacaponaein tatsi Jesús baraichi, jeye: —Caitorobatsi Nacom peitabaratha tatsi, pon asʉ popona. Yatsicaewa paebiname pocotsiwa bara xainyei nepaebiwa. Incane pana netsipaebare. ¿Bara yatsicaya xam Mesías, pon Nacom Pexantom, pon Nacom necaitorobin? jei. ");
INSERT INTO cui_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús jume nota, jeye: —Aa, xuaunxuae bara paebame. Paca tsipaebatsi xua pana netaename xan ponxaein Nacom Tananeitapetsin Nacom pia pecoxa weya tatsi ecaein pon peayapusʉ itorobi coyenewa pexeinaein. Mataʉtano pana netaename poxonae equeicha patopeicaein tsaquinaebowantha xua peitaboco wetsica, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nexata bapon pon sacerdotemonae pia pepa pentacaponaein tatsi pin anaetha anaya paparuwa nata tsitsinaxuba. Bapoxonae jeye: —Po jumetha xua bapon paeba barapo jume Nacom tsita abetsi. Nama equeicha jopa wanantawenonaewa ichamonae xua wanaca tsipaebiwa tsane xua bapon peyabara paebiwatsi. Bapon natsiaenae exana abe pepaebixae barapo jume poxonae Nacom Pexanto najainta. Paxam bara pajume taneme pocotsiwa bapon paeba, pocotsiwa Nacom jopa ichipaeyo. ");
INSERT INTO cui_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Eta xua pacayabara nanta xeiname xua paexanaename bapontha abe pepaebixae? jei. Daxita barapo bicheito po bicheito baxota ena, jeye: —Bara xainyeya paebame. Jesús abe pia pepaebixae Nacom tsitatsi xua bapon tsita natsicuentatsi. Daxota bapon bewa tʉpaena, jei barapo pecanamata caitorobi jiwi bicheito. ");
INSERT INTO cui_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Poxonae barapomonae Jesús itacuere cʉtatsi, bapoxonae peonetha Jesús itabara subabatsi, yawano bʉtsino. Ichamonae Jesús itabara tsaquibacotatsi. ");
INSERT INTO cui_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Bapoxonae barapomonae Jesús baraichi: —Xam jam: ‘Xan Mesías’, jam, incane pana netsipaebare: ¿Jintam caitabara tsaquibobara xua bequein paca itacuere cʉtatsi? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Poxonae cataunxuae Jesús cana exanompatsi bapoxonae irʉrʉ Pedro panatha eca xua pesato beya. Bapoxonae irʉrʉ yabʉyo, powa sacerdotemonae pia pepa pentacaponaein tatsi tanacuitatsi, bapowa Pedro imoxoyo caquita poinchi. Bapowa Pedro jeichichi: —Apara xam bayatha irʉrʉ napuna poneibame Jesús, pon Galilea nacuapin, jei yabʉyo. ");
INSERT INTO cui_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ichitha Pedro jume matawenta bapowa, daxita jiwi peitʉtha tatsi. Pedro jeye: —Jopa yaputaeinyo pocotsiwa xua yabara paebame, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Poxonae cataunxuae Pedro ecapona xua pia ponaetsi bomʉxʉ coiboto beya, bapoxonae irʉ ichawayo Pedro tainchi. Barapowa tsipaeba ichamonae pomonae baxota irʉ umena, Pedro yabara paebatsi, jeye: —Apara bapon, pon napuna poponeiba Jesús pon Nazaret tomarapin, jei barapowayo. ");
INSERT INTO cui_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Equeicha Pedro jume matawenta, jeye: —Bara xainyan jan. Jopa dapon yaitaeinyo pon aunxuae payabara paebame, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Equeicha bapoxonae pirapaeyo Pedro imoxoyo caquita poinchi pomonae baxota umena. Barapomonae Pedro jeichichi: —Apara bara xam irʉrʉ bapon pijimonae tatsi jiwanam, daxota barapo jume coyeneya paebame, icha barapomonae ichi, jei. ");
INSERT INTO cui_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nexata Pedro daunweya jeye: —Bara Nacom peitabaratha xainyeya paca tsipaebatsi pocotsiwa bara xaniwaicha tapaebiwa. Icha jopa xainyeya paca tsipaebichipaetsi metha barabʉ Nacom abe necana exanaetsipa. Equeicha paca tsipaebatsi, jopa dapon yaitaeinyo xuaunxuae pon payabara paebame, jei Pedro. Bapoxonae irʉrʉ caena nainya wacara pebto fibarʉ. ");
INSERT INTO cui_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nexata Pedro nanta xeinataba xua bayatha Jesús Pedro tsipaebatsi poxonae jeye: ‘Xam barapo merawithe, pewʉnaeya poxonae wacara pebto fibina xam copiya acoibi po jume cuiyobetha neyabara jam tsane: Jopa dapon yaitaeinyo, neyabara jam tsane. Bapoxonae irʉ nainya wacara pebto fibina’, jeichichi Pedro, xua Jesús paeba. Nexata Pedro pesato bejoniya bichocono wecoyei, peajʉntʉtanexae xua Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Poxonae pentha tsina sacerdotemonae pia pentacaponaewi tatsi irʉrʉ judiomonae pia pitiri jiwi tatsi, daxita barapomonae yabara nacaetuta xua nanta jʉpaeya pebʉrʉya penanta xeinaenexa po coyeneya xua Jesús pebexubiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Daxita barapomonae equeicha Jesús maxʉ cʉtatsi. Bapoxonae Jesús yamaxʉ cʉtsiya capoinchi Pilato beya, pon Judea nacuapiwi peyanacua ewatsinchi xua romanomonae peitorobixae. ");
INSERT INTO cui_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Jesús caenaetaxubatsi ichamonaetha. Poxonae bapon jume tane xua ichamonae Jesús yabara paebatsi xua bewa tʉpaena abe peexanaexae, poxonae bequein jopa abe exanaeyo, bapoxonae Judas bichocono aura xua Jesús pecaenaetaxubixaetsi. Daxota Judas equeicha caewa capona barapo treinta po paratiximonaebe. Sacerdotemonae pia pentacaponaewi catatsi irʉrʉ pitiri jiwi catatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas barai barapomonae, jeye: —Poxonae pebin caenaetaxuban, xua jopa pon abe exanaeyo, xua poxonae ichamonae pebexubinexa xua pejana pichapabarena, xan apara bara abe exanan, jei. Ichitha barapomonae Judas jume notatsi, jeye: —Apara baxua jopa painta ainya cuiyiyo. Jame apara xam jinya coyam poxonae baxua cana exaname, jei. ");
INSERT INTO cui_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nexata Judas barapo treinta po paratiximonaebe anaya xoya Nacom pin pia botha. Poxonae Nacom pin pia bo weya pona, bapoxonae Judas nabexuba pia coutha, nacoibo tathʉ catʉtaba athawetsica. ");
INSERT INTO cui_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bapoxonae sacerdotemonae pia pentacaponaewi tatsi nota po paratixi Judas bebaya. Bapoxonae barapomonae najei: —Jopa naca copatsiyo xua barapo paratixi bara wajebinexa Nacom pin pia botha tatsi nexa. Tsipei apara barapo paratixi taxoba poxonae barapo paratixitha comotatsi pebin xua ichamonae pebexubinexa, xua pejana pichapabarenaenexa, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bapoxonae daxita barapomonae pebʉrʉya nanta xeinarʉcʉpa, najei: “Waxainchi barapo paratixitha comotinchi tsica iriyo, po iriyotha jiton tsorobon noteiba xua juruwaton peexaneibinexa. Barapo iriyotha tsane xua pemʉthʉthʉqueibinexa tsainchi poxonae werapeibina pomonae penanapaincha jinompaewi xua icha nacua werena peponaewi”, najei. ");
INSERT INTO cui_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Daxota barapo iriyo barapomonae wʉn duta po wʉn jeye: “Pejana ira”, jei. Po iriyo barapo wʉntha cataunxuae jiwi wʉn ununutapona beya anoxuae. ");
INSERT INTO cui_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Baraxua barapomonae exana xua bayatha pecui yabara tsiwʉnaeya wʉnae tsimuxu dutsiya jeixae pon Nacom peitorobi jume pepaebin, pon pewʉn Jeremías pon caena bayatha tʉpa. Bapon Jeremías jeye: “Israelmonae pia pentacaponaewi tatsi catsina treinta po paratiximonaebe ichʉntha xua poxonae pecaenaetsixae tsainchi pon pejʉntʉ coyene xeicaein. Barapo matomatha cana matomatsinchi pon pejʉntʉ coyene xeicaein. Barapomonae baxua cana exanaena bapontha tsipei barapomonae pebʉrʉya nanta xeinarʉcʉpa pecana matomatsinexa. Bapoxonae equeicha barapomonae caewa pichina barapo treinta po paratiximonaebe. Barapo paratixitha barapomonae iriyo comotsina, po iriyotha jiton tsorobon noteibina xua exaneibina juruwaton. Baxua bara barapomonae exana be pocotsi coyeneya Nacom pon jiwi Pecanamataxeinaein nejume cui itoroba”, jei Jeremías. ");
INSERT INTO cui_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús cataunxuae uncua Pilato peitabaratha, pon Judea nacuapiwi peyanacua ewatsinchi. Bapon Pilato Jesús yainyabatsi, jeye: —¿Bara yatsicaya xam judiomonae itorobiya pia pepa Neewatsin? jei. Jesús jume nota, jeye: —A, xuaunxuae paebame bara baxua apara, jei Jesús Pilato beya. ");
INSERT INTO cui_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Sacerdotemonae pia pentacaponaewi tatsi irʉ judiomonae pia pitiri jiwi tatsi, daxita barapomonae Jesús abe yabara paebatsi xua pinae abe exana. Daichitha Jesús jopa jume barabotsiyo barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nexata daxota Pilato Jesús baraichi, jeye: —¿Jopa jume taem pocotsiwa barapomonae bichocono abe cayabara paeba? jei. ");
INSERT INTO cui_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ichitha Jesús jopa jume notsiyo Pilato xua pocotsiwa ichamonae Jesús abe peyabara paebiwatsi xua mataʉta cae jume coyenewatha jopa jume notsiyo. Daxota Pilato bichocono yabara nantʉ coyene cui cabenaeca baxua. ");
INSERT INTO cui_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bara nama, Pilato ba pia cui xeina poxonae ba jiwi tsinacaetuta pexaewa penanabanaenexa. Barapo matacabitha Pilato ba caein jiwana pu sotaba pomonae jiwi pecʉbi botha peenaewi. Pilato ba pu sotaba pon ba jiwi itapeta cowai xua Pilato peisanaxubinexa. ");
INSERT INTO cui_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Barapo jiwi pecʉbi botha irʉrʉ eca pon bichocono abe peexanaein, pon peyaputaeinchi daxita jiwi poxonae abe exaneiba. Bapon pewʉn Barrabás. ");
INSERT INTO cui_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Poxonae jiwi nacaetuta, Pilato barai barapo jiwi, jeye: —¿Eta pon pu sotabocuaein? ¿Metha Barrabás jampa? ¿Metha Jesús jampa, pon Mesías baraichi? jei Pilato. ");
INSERT INTO cui_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Baxua Pilato paeba tsipei bapon yaputane xua pomonae pecanamata caitorobi bicheito, Jesús peuwixaetsi, caenaetaxubatsi Pilatotha. ");
INSERT INTO cui_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Poxonae Pilato cataunxuae pia peecaethopeibiwatha eca xua Jesús peyabara paebinexatsi penatsicuentsiwa bapoxonae Pilato piowa tatsi najume caitoroba ichʉntha xua jeye: “Jopa copatsinde xua bapon pebexubinexatsi ichamonae, tsipei apara bapon pejʉntʉ coyene xeicaein. Yaitama tsipei merawi bapon camaitan daxota bichocono anthʉthʉrewein, tsipei bapon dacotsiwa bexotsi”, jei bapon xua Pilato piowa tatsi najume caitoroba. ");
INSERT INTO cui_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ichitha sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ judiomonae pia pitiri jiwi tatsi, daxita barapomonae jiwi cui tsacarabatsi, xua barapo jiwi Pilato pecui itorobinexatsi xua Barrabás pepu sotabinexatsi, mataʉtano xua Jesús pebexubinexatsino. ");
INSERT INTO cui_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bapon Pilato equeicha barai jiwi, jeye: —¿Eta pon pu sotabocuaein caein xua baponbe jiwana? jei. Barapomonae Pilatotha jeye: —Maisa Barrabás pu sotabare bara, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Equeicha Pilato yainyaba barapomonae, jeye: —¿Eta xua cana exanocuaein Jesús pon Mesías baraichi? jei. Nexata pinmonae Pilato jume daunweya jume notatsi, jeye: —¡Bewa maisa naetotha tʉparucua exanaem! jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nexata Pilato jume barai, jeye: —¿Eta pocotsiwa xua metha jane xua abe exana? jei. Equeicha daʉmetha barapomonae jume daunweya jeye: —¡Bewa maisa naetotha tʉparucua exanaem! jei. ");
INSERT INTO cui_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Poxonae Pilato yaputane xua nama taaibichiba pocotsiwa bapon pepaebinexa picoya, xua peajumetsacaxae barapomonae, daxota Pilato itoroba ichʉn xua petaxawenaenexa tsainchi mera. Bapoxonae barapo meratha nacobe quiataxuba barapo jiwi peitʉtha tatsi. Bapoxonae bapon namchi, jeye: —Xan apara jopa tacoutha bexuba exanaeinyo bapon xua daxota pejana pichapabarena pon jopa bequein abe exanaeyo. Poxonae nacobe quiataxuban meratha, baxua tsita itapeinya xeinan xua apara jopa tacouthinyo. Apara jame painya coutha pam poxonae bexuba paexaname pon abe jopa exanaeyo, jei Pilato. ");
INSERT INTO cui_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Daxita barapomonae equeicha namchi, jeye: —¡Paxan irʉ pata tamomoxi susato jiwi pata coutha pan apara xua bapon bexotsi paexanan! jei daxita barapo jiwi. ");
INSERT INTO cui_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Nexata Pilato nama pu sotaba Barrabás. Bapoxonae itoroba xua soldadomonae bara Jesús moya bichocono pecuainchinexatsi pocotsiwatha eewa xua bichocono amʉpiya xua xota ba jiwi cuainteibatsi poxonae abe exaneiba. Mataʉtano itorobano xua moya bara Jesús tʉparucua exanaeinchi naetotha. ");
INSERT INTO cui_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bapoxonae soldadomonae Jesús capoinchi Pilato pia bo tatsi beya po soldadomonae yapu eena Pilato pia bo tatsi. Bapoxonae barapo soldadomonae waba icha soldadomonae xua daxita barapo soldadomonae Jesús pematawacaicha umenaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bapoxonae Jesús pia paparuwa juma xuenatsi yawa juma xatatatsi icha paparuwa, po paparuwa tsobia xua Jesús be pecana exanaenexatsi pon jiwi itorobiya pepa Peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Bapoxonae cuane tepa xua pee tepa, yawa bapoxonae Jesús canamitontsiya mata xatatatsi baxua xua cana exanatsi icha be ichi pon jiwi itorobiya pepa peewatsin poxonae mata xatatatsi tepa. Mataʉtano Jesús cobenatatsi naewa icha be ichi pon jiwi itorobiya pepa peewatsinchi poxonae naewa cobenatatsi poxonae itoroba jiwi. Bapoxonae Jesús peitabaratha tatsi pentabocototha taenatsi xua Jesús naerabiya pebarʉ cui itura jinaenexa tsainchi. Bapoxonae Jesús cui caponatsi, jeye: —¡Jaco judiomonae itorobiya pepa Neewatsim! jei barapomonae xua Jesús canamitontatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mataʉtano Jesús yabara naone subabatsi. Mataʉtano Jesús cobe wepitatsi naewa. Bapoxonae barapo naewatha Jesús mata cuaintatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Poxonae Jesús canacui wetatsi xua cui caponatsi, equeicha bapoxonae Jesús caewa juma wejontatsi xua po paparuwa tsobia. Bapoxonae equeicha caewa juma xatatatsi po paparuwa pia paparuwaxae tatsi. Bapoxonae Jesús capoinchi xua tʉparucua peexanaenexatsi naetotha. ");
INSERT INTO cui_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Poxonae Jesús namtotha caenapoinchi soldadomonae, bapoxonae barapo soldadomonae taeba pebin, pon Cirene tomarapin. Bapon pewʉn Simón. Bapoxonae barapo soldadomonae Simón itorobatsi xua pecaponaenexa Jesús pia naeto tatsi, po naetotha tʉparucua peexanaenexatsi Jesús. ");
INSERT INTO cui_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bapoxonae Jesús barʉ patatsi ichaxota po uruto be jiton matasipa piwa. Daxota barapo uruto jiwi wʉn unuta “Gólgota”, jei. ");
INSERT INTO cui_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Baraxotiya Jesús apatatsi vino mera, po vino mera equeicha muxuna epareca hiel mera matawʉn po mera bichocono atsu wʉwa. Poxonae Jesús mene pana, bapoxonae Jesús aichaxaibi apa barapo mera. ");
INSERT INTO cui_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Poxonae Jesús canacobe wetatsi xua naetotha tʉparucua exanatsi, bapoxonae soldadomonae nata tsaba Jesús pia paparuwan tatsi. Barapomonae ibotixi bebeya penacueranta notsinexa Jesús pia paparuwan tatsi. Pon beta xoya ibotiyo bapon copiya pita Jesús pia paparuwan tatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nexata barapo soldadomonae Jesús yapu caenatsi poxoru jopa ichipaeyo xua Jesús pepanepaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jesús pentutu wetsica tadutatsi napaewa xua barapo napaewatha tina. Barapo petinadutsiwa jeye: “Baponje apara judiomonae itorobiya pia pepa Peewatsinchi”, jei barapo petinadutsiwa xua napaewatha tinaduta. ");
INSERT INTO cui_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Irʉrʉ ponbe jiwi pecaibinbe tʉparucua exanatsibe naetotha ichaxota imoxoyo Jesús ducua. Ichʉn Jesús petsocona wetauncuiyatsi, ichʉn pecoxa wetauncuarenatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pomonae Jesús xentapoinchi barapomonae Jesús cui capoinchi, yawa Jesús yabara itata naichaquebatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Barapomonae Jesús jeichichi: —Xam bayatha jam: ‘Nacom pin pia bo abe exanaein, bapoxonae equeicha acoibi po matacabibe xaneibin’, jam. Moya bara jinya coutha nacapanepare naeto wetsica icha bara metha Nacom Pexantom tatsim, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Irʉrʉ barichi sacerdotemonae pia pentacaponaewi tatsi irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi irʉrʉ judiomonae pia pitiri jiwi tatsi, daxita barapomonae Jesús cui capanatsi. Daxita barapomonae najei: ");
INSERT INTO cui_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Bapon cain capanepeibabei ichamonae, came jopa nacapanepaeyo. Icha bara bapon israelmonae itorobiya pia pepa Peewatsinchi, bʉ bapon pia coutha naeto wetsica ecoinca, xainya bapoxonae jume cowʉntatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bapon jume cowʉnta Nacom, xua bepa pinae capanepaeinchi, xua Nacom capanepaena. Icha Nacom ichichipa, bʉ bara moya capanepaena, tsipei caena bayatha naca jei: ‘Apara xan Nacom Pexanton’, naca jei, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Barichirʉ baxua paeba ponbe jiwi pecaibinbe, ponbe xua irʉrʉ cobe matatabarutatsibe naetotha. Baponbe irʉrʉ Jesús cui caponatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Poxonae Jesús cataunxuae ducua naetotha, bapoxonae daxita nacuantha bichocono aitaquiri xua poxonae mataeinyaxae weya, beya yatabopiya. Tres po horabe quirei tsuncuae. ");
INSERT INTO cui_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bapoxonae Jesús jume daunweya wawai, jeye: “Elí, Elí, ¿lema sabactani?” jei, (barapo jumetha xua jei: “Tanacom, Tanacom, ¿eta pocotsiwa metha nepunaxubame?” jei Jesús.) ");
INSERT INTO cui_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ichamonae pomonae Jesús baxota jume taeumeinchi, barapomonae jeye: —Pajume taema. Bapon waba, Elías wabatsi, pon Elías Nacom peitorobi jume pepaebin, pon caena bayatha tʉpa, jei. ");
INSERT INTO cui_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bapoxonae caein nainya cuinaepoinya pon barapomonae jiwana yawa pitaba esponja xua baxota pemene capichinexa vino mera xua po mera mene atsu. Poxonae bapon baxota mene capita, bapoxonae naewatha duta xua Jesús petayoichaenexatsi xua peapaenexa. ");
INSERT INTO cui_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ichitha ichamonae namchi, jeye. —Abʉ, abʉ jopa apatsinde. Waxainchi abʉ matha taeinchi icha Elías patopeicaena xua bapon pecapanepaenexatsi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Equeicha Jesús jume daunweya wawai, bapoxonae nama tʉpanaicha Jesús. ");
INSERT INTO cui_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bapoxonae paparuwa, po paparuwa Nacom pin pia botha ducua, barapo paparuwa nainya bopiya matonta tsitsiqueica ainya epatobe naexanabe. Mataʉtano ira jijiyataxuba, mataʉta ibo wacapouna. ");
INSERT INTO cui_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Po mʉthʉntha pomonae pewerapeibiwi bobena, barapo mʉthʉn coibo tupa wacapouna pocotsiwa coibo xatababanoba xua pin ibo panawan. Barapo mʉthʉntha cataunxuae abʉ saya bobena pomonae caena bayatha werapa. Pirapaeyo acoibi po matacabiyobe poxonae Jesús asʉ juina exanatsi, xua Nacom exana, bapoxonae irʉrʉ pomonae bayatha pejume cowʉntsiwichi Nacom pomonae xua bayatha pewerapaexae barapomonae irʉ asʉ jujuina exanatsi xua Nacom exana. ");
INSERT INTO cui_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bapoxonae daxita barapomonae mʉthʉ we-iyiya. Daxita barapomonae, Jerusalén tomara beya pona po tomaratha xeina Nacom pin pia bo tatsi. Barapomonae naitʉta pinmonaetha Jerusalén tomarapiwitha. ");
INSERT INTO cui_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Bapoxonae soldadomonae pomonae Jesús yapu enatsi irʉrʉ barapo soldadomonae pia pentacaponaein tatsi, pon romanomonaepin poxonae daxita barapomonae tane xua ira jijiyata yawa xua tane ichawanno, bapoxonae barapomonae bichocono junuwa. Bapoxonae barapomonae jeye: —¡Apara bara yatsicaya bapon Nacom pepa Pexanto tatsi! jei barapo soldadomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Barichi irʉ ainyawaxi yabʉxi, barapowaxi Jesús tsiwiyo tajʉ wetaeumeinyatsi. Barapowaxi Jesús bayatha matha puna jinompatsi xua poxonae Galilea nacua weya pona xua Jesús peyawenaenexatsi. ");
INSERT INTO cui_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Barapowaxi jiwana, ichowayo pewʉn María Magdalena, powa Magdala tomarapiwayo. Ichowayo pewʉn María, Santiago irʉ José baponbe penabe tatsi. Ichowayo pewʉn Salomé bapowa Zebedeo piowa tatsi, xua irʉ bapowa Santiago irʉ Juan baponbe pena tatsibe. ");
INSERT INTO cui_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Poxonae quirei tsanaicha, pebin patopa ichaxota Jesús naetotha tʉparucua. Bapon copei pexeinaein. Bapon pewʉn José. Bapon Arimatea tomarapin. Mataʉta bapon irʉ Jesús pia pepuna jinompaewichi jiwanapin tatsi pomonae Jesús pia pejume cowʉntsiwichixaetsi. ");
INSERT INTO cui_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Bapon pona Pilato beya pewʉcaenexa xua Jesús petʉpaein. Nexata Pilato najume caruta xua bara José pecatsinexatsi Jesús petʉpaein. ");
INSERT INTO cui_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José nexata pita Jesús petʉpaein. Bapoxonae pena paparuwatha mata quiyontabareca xua pexeinya paparuwa. ");
INSERT INTO cui_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Bapoxonae José mʉthʉ iya Jesús botatsi pena ibo mʉthʉtha, po mʉthʉ bequein José pia mʉthʉ tatsi xua poxonae petʉpaewa tsane. Poxonae José nacobe weta xua yauxatatababota pin ibo panawatha, bapoxonae ponataba. ");
INSERT INTO cui_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Baxotiya ibo mʉthʉ itapatha eca María Magdalena, powa Magdala tomarapiwayo. Irʉ ichowayorʉ María baxota naeca. ");
INSERT INTO cui_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Icha matacabitha po matacabitha pentaquei seica matacabi bapoxonae sacerdotemonae pia pentacaponaewi tatsi irʉrʉ fariseomonae daxita barapomonae pona Pilato beya. ");
INSERT INTO cui_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Barapomonae Pilato jeichichi: —Pon pata Tanecanamataxeinaem, pananta xeinan xua barapo pemuxuitorobin poxonae cataunxuae popona, pana tsipaeba, jeye: ‘Poxonae acoibi po matacabibe tsuxubi tsane equeicha asʉn tsane petʉpae coyene cuiru weya’, pana jei bapon. ");
INSERT INTO cui_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Daxota xam itorobare soldadomonae xua xaniwaicha peyapu eenaenexa mʉthʉ xua beya poxonae acoibi po matacabibe tsuxubi tsane. Baxua exande xua jopa pepatsinexa tsane mʉthʉ beya Jesús pia pepuna jinompaewichi, tsipei bʉ merawi barapomonae pichapa Jesús pia pepon. Tsipei pirapae naerabichipa jiwitha jei tsipae: ‘Bayatha equeicha asʉ exanatsi petʉpae cuiru coyene weya’, jei tsipae xua Jesús yabara naerabatsi. Barapomonae baxua naerabichipa jiwitha, baxua bichocono abe tsipae, beyacaincha poxonae Jesús bayatha pocotsiwa paeba xua pemuxuitorobiwa, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato barai barapomonae, jeye: —Bara moya pataema. Moya panore soldadomonae. Moya mʉthʉ beya pabarʉ ponde. Paexande pocotsiwa panantawenoname xua bʉ moya barapo soldadomonae xaniwaicha yapu eenaena, jei Pilato. ");
INSERT INTO cui_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nexata barapomonae irʉ soldadomonae bara be-iyiya. Bapoxonae mʉthʉ coibo daunwei exananota. Bichocono barapomonae cateitabanota xua pin ibo panawa xua mʉthʉ boupa ata. Mataʉtano bichocono barapomonae pemacatha epataʉtarena boupa cʉtabarena barapo peboupa patsiwa, xua peyaputaenexa icha ichʉn namicha patopa xua pecaibinexa Jesús petʉpaein. Bapoxonae barapomonae cuentadendena soldadomonae xua barapo soldadomonae peyapu eenaenexa mʉthʉ. ");
INSERT INTO cui_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Poxonae po pentaquei seicae matacabi yapu caewaba, bapoxonae matacabi jopa po matacabi xua nanta carucua xua cae semanatha xua penacuichi matacabi. Barapo mataqueitha María Magdalena, powa Magdala tomarapiwayo irʉ ichawayo María, barapowayobe caemʉmbotha siwa ponabe mʉthʉ ichaxota Jesús yamʉthʉ uncua. ");
INSERT INTO cui_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Bapoxonae nainya ira jijiyataxuba tsipei Nacom itoroba matatsunpin xua peitaboco wetsica pona. Barapo matatsunpin yaupataxubanota barapo pin ibo panawa. Bapoxonae barapo ibo panawatha ecopiya. ");
INSERT INTO cui_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Barapo matatsunpin bichocono daedaena icha be yamʉxʉ coicha ichi. Paparuwa bichocono inyapana. ");
INSERT INTO cui_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Poxonae soldadomonae baxua taerʉcʉpa bichocono cuitaya jijiyei tsʉrʉcʉpae, mexeya poxi werapa iratha bobena, tsipei bichocono junuwa. ");
INSERT INTO cui_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Barapo matatsunpin namchi barapowayobetha, jeye: —Jopa pajunuwindebe. Bara yaputan xua pawenawenambe Jesús xua painya taetsibe, pon tʉpa exanadutatsi naetotha jiwi. ");
INSERT INTO cui_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Xote apara bapon aibi. Apara bayatha equeicha asʉ juina exanatsi petʉpae cuiru coyene weya, xua caena bayatha painya nepaca catsipaebixae. Incane anetha xote, pacou taemabe ichaxota bapon petʉpaein botatsi bayatha. ");
INSERT INTO cui_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nainya papondebe weye, patsipaebarebe Jesús pijimonae tatsi. Pajandebe: ‘Bara bequein bapon bayatha tʉpa ichitha equeicha asʉ juina exanatsi petʉpae cuiru coyene weya. Bapon copiya paca tsiwana ponaena Galilea nacua beya. Baxotiya bapon pataename, pana nejei matatsunpin’, pajandebe Jesús pijimonaetha. Poxonae bapon pataename, bapoxonae payaputaename xuaunxuae paca tsipaebatsi bara apara xaniyei, jei matatsunpin. ");
INSERT INTO cui_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bapoxonae barapo yabʉyobe mʉthʉ weya nainya pontababe. Junuwiya jʉntʉ coyene weiweinabe. Barapowayobe cuinaepoinyabe Jesús pijimonae tatsi beya xua diwesi caponabe pocotsiwa matatsunpin paeba. ");
INSERT INTO cui_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Poxonae barapowayobe epathotha cataunxuae cuinaecaponabe bapoxonae Jesús jemeicha uncuataba barapowayobe pia xantha tatsi. Jesús jeye barapowayobetha: “Jaco”, jei Jesús. Barapowayobe imoxoyo caquita ponabe Jesustha bapoxonae pentabocototha uncuabe yawa taxu waetababe xua Jesús wʉnae pejainchinexatsi. ");
INSERT INTO cui_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús barai barapowayobe, jeye: —Jopa pana necunuwindebe. Paponarebe tajiwimonae beya. Patsipaebarebe pajandebe: Jesús paca itoroba bepa pinae paponaem Galilea nacua beya. Bepa pinae baxotiya pataem, pajandebe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Poxonae barapo yabʉyobe cataunxuae namtotha ecaponabe, bapoxonae icha soldadomonae jiwana, po soldadomonae Jesús yamʉthʉ eenatsi, barapo soldadomonae tomara beya pona. Mataʉta sacerdotemonae pia pentacaponaewi tatsi tsipaebatsi daxita pocotsiwa xua xuan tane. ");
INSERT INTO cui_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Barapo sacerdotemonae pia pentacaponaewi tatsi pona pitiri jiwi beya xua caemonae peyabara natsipaebinexa xua Jesús petʉpaein yabara. Bapoxonae daxita barapomonae soldadomonae paratixi nawita catsibatsi xua jiwi naerabiya petsipaebinexatsi. ");
INSERT INTO cui_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Bapoxonae barapomonae soldadomonae baraichi, jeye: —Patsipaebare jiwi xua merawi poxonae pamaitumename Jesús pijimonae tatsi pata, yawa xua bapoxonae petʉpaein pitatsi. ");
INSERT INTO cui_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Icha Pilato pon peyanacua ewatsin jiwi jume taebina xua Jesús petʉpaein aichurucuae, yawa icha bapon baxua yabara paca yainyabina, bapoxonae nexata paca yabara jume yawenaeinchi xua bapon jopa paca jutebi tsane, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nexata barapo soldadomonae nota paratixi yawa jiwi tsipaeba tsiniyatsi xua sacerdotemonae pia pentacaponaewi tatsi peitorobixae. Barapo penaerabi diwesi jume, judiomonae jume cocowʉntapona. Anoxuae barichi po judiomonae anoxuae jinompa, jume cocowʉntapona barapo diwesi. ");
INSERT INTO cui_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nexata once poyobe pomonae xua Jesús pijimonae tatsi barapomonae nawibiya Galilea nacua beya. Bapoxonae barapomonae demxuwa beya pona, po demxuwa pinae Jesús caunuta xua pinae baxota patopaena. ");
INSERT INTO cui_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Poxonae barapo once poyobe baxota Jesús taerʉcʉpatsi, ichamonae Jesús wʉnae jaintatsi, bequein ichamonae ainya jʉntʉ coyenein xeina xua Jesús xapain beta jopa yabara jume cowʉntichi. ");
INSERT INTO cui_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Nexata Jesús pijimonae imoxoyo caquita pona. Bapoxonae jeye: —Nacom necata daxita peayapusʉ itorobi coyene xua peitabocotha nexa, mataʉtano po cae pin nacuathe tsiquenexano. ");
INSERT INTO cui_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Paponare daxita carepaya jiwitha xua daxita nacuantha. Jiwi pacana exande xua tana nejume cowʉntsiwa tsane. Daxita pomonae tana nejume cowʉntsiwi pabautisabare. Poxonae pabautisabame Taxa pewʉn pawʉn taibare, mataʉtano pana newʉn taibare, ponxaein Nacom Pexanton, mataʉtano Nacom pia Pejumope tʉnaxʉ tatsi pawʉn taibare xua barapo acoibi wʉnthabe painya paca nepaca yawenaenexa pia peayapusʉ itorobi coyenewatha. ");
INSERT INTO cui_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Daxita barapomonae pacuidubare daxita xua xuan pocotsiwa bayatha paca itorobatsi. Mataʉtano painya xoba pajʉntemainame xua daxita matacabin bara ataya paca barʉ poponeibinchi beya poxonae tsane xua equeicha patopeicaein, jei Jesús pijimonaetha. Baja Mateo.");
INSERT INTO cui_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Baraxue tamropata pitaban xua Jesucristo pia pexeinya jume diwesi tatsi. Bapon Jesucristo, Nacom Pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bayatha Nacom pia peitorobi jume pepaebin, pon pewʉn Isaías, bapon tina petinae diwesitha. Isaías tina Nacom nexa, Nacom barapo diwesitha jeye Pexantotha: “Itorobin copiya pon tana najume caitorobin xua catsiwanaya itorobinchi. Bapon cana exanaena jiwitha xua jiwi yabara aura tsane abe pia peexanae cuiru coyenein tatsi, xua poxonae nepatopae wʉnaeya tsane. ");
INSERT INTO cui_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pon itorobin bapon jume tan pon xua wawai ira xuepana susato tsurucuae nacuatha. Bapon wawaya jeye: ‘Patsinajʉntʉ cui coyene wʉnaere, pon jiwi pia pepa Pecanamataxeinaeinchi nexa pia pepatopae wʉnaeya tsane’, jei pon xua wawai”, jei Isaías petinae diwesitha. ");
INSERT INTO cui_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nexata Juan pon Isaías peyabara paebixae bapon ira xuepana susato tsurucuae nacuatha patopa. Bapon Juan bautisaba ducuanaebiya, xua jiwi bautisabatsi merantha. Mataʉtano bapon tsipaeba jiwitha Nacom pia pexeinya jume diwesi tatsi. Bapon Juan jeye jiwitha: “Icha jʉntʉ coyene paxeinare painya neauraxae xua abe paexaname. Bapoxonae Nacom paca yabara jʉntemainaena abe painya neexanae cuiru coyenein”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Daxita Judea nacuamonae, irʉrʉ Jerusalén tomarapiwi, daxita barapomonae pona ichaxota beya Juan bautisaba jiwi ira xuepana susato tsurucuae nacuatha. Poxonae barapomonae nayopita Nacomtha xua bepa pinae Nacom tsita auratsi xua abe peexanaexae bapoxonae barapomonae Juan bautisaba Jordán mentha. ");
INSERT INTO cui_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan jumaina duwein nabocoto, po duwein pewʉn camello. Coreinya bocoto maraina. Xane pocotsiwa yapupuna pocotsiwan be sure poxi. Mataʉtano bana daeba. ");
INSERT INTO cui_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Barapon pomonaetha pebautisabixae tsipaeba, jeye: “Pon nepuna patopaena, apara bapon Mesías. Bapon bichocono peayapusʉ itorobi coyenewa xeina beyacaincha xan. Bapon pon jiwi pia Pecanamataxeinaeinchi. Xan bichocono tapawin daxota bapon bichocono tsita pin ura xeinan xua tataxu mʉ isanaxubiwa tsane pia penataxu xatatsiwa tatsi. Tsipei xan bichocono tapawin, beyacaincha pomonae amanaya petanacuichiwi pia pentacaponaewi poxonae barʉ cui itura jina pia pentacaponaewichi. ");
INSERT INTO cui_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Paca bautisabatsi meratha, ichitha nama barapon Mesías paca bautisabina Nacom pia Pejumope tʉnaxʉtha tatsi poxonae Nacom paca najumope catsibina”, jei Juan jiwitha xua Jesús yabara. ");
INSERT INTO cui_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Barapo dapaetha Jesús Nazaret tomara weya pona, po tomara eca Galilea nacuatha. Bapon Jordán mentha patopa, ichaxota Juan bautisaba. Baraxota Jesús bautisabatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Poxonae mene wejuina barapoxonae caena nainya Jesús itaboco necoicha xua peitaboco nayausaranaxuba. Jesús tane xua Nacom pia Pejumope tʉnaxʉ tatsi patopa bapontha xua be topiboto yaruneica. ");
INSERT INTO cui_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Barapoxonae Jesús jume tane pocotsiwa peitaboco wetsipaebicatsi, jeichichi: “Xam apara Taxantom, pom bichocono caantobetsi, pom caitapetatsi. Nejʉntʉ coyene weiweina exaname”, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Poxonae Jesús nanacui wetatsi xua bautisabatsi bapoxonae Nacom pia Pejumope tʉnaxʉ tatsi Jesús nainya itorobatsi ira xuepana susato tsurucuae nacua beya. ");
INSERT INTO cui_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesús ira xuepana susato tsurucuae nacuatha popona cuarenta po matacabibe. Baraxota pichiwan xua camatsawan jinompa ichaxota Jesús popona pocotsiwan bichocono atsaca. Caurimonae pia pentacaponaein tatsi pon Satanás Jesús piraichi jʉntʉ coyene jʉjʉtatsi xua Jesús abe coyeneya petaexanaenexa tsane. Pirapae matatsunpiwimonae po matatsunpiwimonae Nacom itoroba, barapomonae pata Jesustha xua Jesús pecui matateicaenexa tsainchi, mataʉtano xua peapatsinexatsi tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nexata poxonae ichamonae Juan maxʉ waetabatsi xua peetsinexatsi jiwi pecʉbi botha, bapoxonae Jesús Galilea nacuatha patopa. Jesús paeba ducuanaeta jiwitha Nacom pia pexeinya jume diwesi tatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús namchi jeye: “Nacom bayatha yabara necana cui weta exana po coyeneya xua poxonae tapatopaewa. Daxota jiwi itacʉpatsi xua naexana Nacom piamonae, pomonae Nacom itorobiya peewatsixae. Daxota icha jʉntʉ coyene paxeinare Nacomtha xua painya neauraxae xua abe paexaname, Nacom piamonae painya nenaexanaenexa tsane. Pajume cowʉnde Nacom pia pexeinya jume diwesi tatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Poxonae Jesús pona Galilea pucua itapatha, bapoxonae tane ponbe peyaxunubinbe duwei. Ichʉn pewʉn Simón, ichʉn pewʉn Andrés. Baponbe bara cae peweichobe. Baponbe peweichobe duwei yamonauyabe pucuatha. ");
INSERT INTO cui_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús waba, baraponbe wabatsibe. Jesús jeye: —Anetha, pana nepuna pondebe. Paca cuidubinchibe. Anoxuae nama xan paca exanaeinchibe xua pinmonae payawenaenamebe xua barapomonae pejume cowʉntsiwa tsane Nacom icha bayatha paichimbe poxonae payamonamebe duwei nawita, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bara caena baraponbe botabe barapo peyamonaewa. Bapoxonae napuna ponabe Jesustha. ");
INSERT INTO cui_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús equeicha pona. Bapoxonae equeicha ichʉnbe tainchibe. Baraponbe ichʉn pewʉn Santiago, irʉ ichʉn pewʉn Juan. Baponbe Zebedeo pexantobe tatsi. Jeratha mataquerabauyabe peyamonaewa xua ucupouna. ");
INSERT INTO cui_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús nainya waba, baponbe wabatsibe: Jesús baraibe: “Anetha, pana nepuna pondebe”, jei Jesús. Baponbe paxa cuenta ponabe jera weya, pon pewʉn Zebedeo. Mataʉtano cuenta ponabe pomonae Zebedeo pia peyawenae jiwichi tatsi xua yamona duwei. Baponbe Jesustha napuna ponabe. ");
INSERT INTO cui_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bapoxonae Jesús pijimonae barʉ pona Capernaum tomara beya. Bapoxonaerʉ judiomonae barompaya pia pentaquei seicae matacabi tatsi tsuxubi. Barapo matacabitha Jesús pijimonae barʉ joniya judiomonae pia penacaetutsi botha tatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Barapo jiwi yabara najʉntʉ coyene cabenaeca, tsipei pocotsiwa Jesús barapomonae cuidubatsi be pon peyaputaein pia peayapusʉ itorobi jume coyeneya tatsi paeba. Jesús jopa cuidubiyo be judiomonae pia pecuidubiwi pia coyeneya tatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pebin pon cauri xeina barapon eca barapo judiomonae pia penacaetutsi botha tatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Bapon wawaya jeye: —¡Jesús Nazaret tomarapim, pana wepu warapare! ¿Eta xua metha patopame pata xantha xua jinya apara abe pata neexanaetsim? ¿Apara patopame jinya pana nejutebichim? Paca yaputainchi yawa paca yaitainchi xam apara pon Nacom caitoroba, pon pepa Nentacuiruyapuxanepanaem, jei pebin pon cauri xeina. ");
INSERT INTO cui_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús taitaweta, pebin taitawetatsi cauri. Jesús cauritha jeye: —¡Moyande! ¡Barapon wepu ponde! jei Jesús cauritha. ");
INSERT INTO cui_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Barapoxonae cauri pebin naichababa exanatsi. Poxonae cauri barapo pebin bichocono wawai exanatsi, bapoxonae barapo cauri pebin wepu poinchi. ");
INSERT INTO cui_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Daxita barapomonae yabara najʉntʉ coyene cabenaeca. Daxota nayainyaba, jeye: —¿Eta pocotsiwa jane? ¿Jamaisa baxua mexeya pena pecuidubi coyenewa? Maisa barapo pebin Jesús bichocono peayapusʉ itorobi coyenewa pexeinaein. Mataʉtano caurimonae jume cowʉnta poxonae pocotsiwa bapon itoroba, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bapoxonae caena nainya daxita pomonae jinompa Galilea nacuatha jume taerʉcʉpa pocotsiwa juinya Jesús exana. ");
INSERT INTO cui_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús caena nainya pona judiomonae pia penacaetutsi bo tatsi weya. Bapoxonae Jesús joniya Simón pia botha tatsi po bo xua irʉ Andrés pia bo tatsi. Barapo botha Santiago irʉ Juan Jesús barʉ joniya. ");
INSERT INTO cui_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón pamiyo tatsi domae xainchi. Barapowa camatha boca. Poxonae Jesús patopa barapomonae caena nainya Jesús tsipaebatsi, jeye: “Simón pamiyo tatsi domae xainchi”, jei. ");
INSERT INTO cui_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús caquita pona Simón pamiyo tatsi. Bapoxonae bapowa cobe pitatsi. Barapowa asiya cuaranotatsi. Bapoxonae barapowa caena nainya taaichurucuaetsi domae. Nexata barapowa pexaewa apata barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Poxonae tabopiya tsanaicha xua quirei tsanaicha, bapoxonae jiwi Jesús tacapoinchi pomonae peatenemonaewi, irʉ pomonae caurimonae xeina. ");
INSERT INTO cui_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Daxita barapo tomarapiwi nacaetuta bomʉxʉ boupatha. ");
INSERT INTO cui_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús axaibi exana pinmonae pomonae xeina daxita coyenexi xua xoxi peatenewa. Mataʉtano Jesús taitaweta pomonae cauri xeina. Jesús jopa copatsiyo xua pecueicueijeiwa caurimonae, tsipei caurimonae Jesús cui yaputainchi. ");
INSERT INTO cui_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Baya poxonae caemʉmbotha poxonae cataunxuae quiriquirica Jesús nacosataxuba. Bapoxonae tomara weya pona xua ichaxota jiwaibi bara beya pona. Baraxotiya Jesús tsipaebauya, Nacom tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nexata Simón irʉ pomonae Jesús pepuna jinompae jiwichi, barapomonae Jesús pu barainatsi. ");
INSERT INTO cui_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Poxonae barapomonae Jesús caxibatsi, bapoxonae Jesús tsipaebatsi, jeye: —Daxita jiwi cawenawenei, jei. ");
INSERT INTO cui_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús jume nota jeye: —Barabʉ ponaeinchi icha tomaran beya, barapo tomarantha irʉ tacueicueijeinexa tsane Nacom pia pexeinya jume diwesi tatsi. Daxota apara baxua tsipatopeican, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Bapoxonae Jesús siwa pona ducuanaeta daxita tomaran Galilea nacuatha. Judiomonae pia penacaetutsi bontha tatsi Nacom pia pexeinya jume diwesi Jesús tsipaeba barapo judiomonaetha. Mataʉtano Jesús taitaweta caurimonae. ");
INSERT INTO cui_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Bapoxonaerʉ pebin, pon peperʉ sawinchi, Jesús caquita poinchi. Bapoxonae bapon pentabocototha uncua Jesús peitabaratha tatsi xua Jesús pebarʉ cui itura jinaexaetsi. Bapon matowa Jesús wʉcatsi, jeye: —Icha bara ichichipame bara caitacʉpa xua axaibi tana neexanaewam, tsipei jinya neayapusʉ itorobi coyenewa nexeinaem, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús yabara najʉntʉ coyene xeina bapon, xua peyawenaenexa. Jesús nacobe yota, bapoxonae bapon mata jayabatsi, jeye: —Bara ichichipan. ¡Bara axaibinde! ¡Bara caaperʉxaibi exanatsi! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bapoxonae bapon nainya taaichurucuaetsi xua peperʉ sawiwatsi. Mataʉtano axaibi tsanayano. ");
INSERT INTO cui_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Bapoxonae Jesús jume daunweya itorobiya jeye: —Jopa yabara tsipaebinde ichamonaetha xua neaxaibiwam. Saya jame meisa ponde sacerdotepintha xua nenaitʉtsinexa xua bapon necataenexa xua bayatha nejumewa. Care bapontha pocotsiwa xua pecatsiwa Nacomtha, pocotsiwa bayatha Moisés cui itoroba xua equeicha jopa jinya nenataxobinexa jinya pepontha. Bapoxonae daxita jiwi cayaputaena xua tsita itapeinya xeinatsi xua xam bara jumem yawa xua perʉ wʉnaem, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Daichitha poxonae bapon pona jopa moya yawʉn xeinaeyo. Bapon yabara tsipaebapona ichamonaetha pocotsiwa xua bayatha peaxaibiwa. Daxota Jesús jopa itacʉpaetsi xua naitʉtsiya pata ducuanaebiya tomarantha. Daxota Jesús tomaran cuariya popona xua aisowantha. Jiwi pomonae daxita ichawan werena pona, barapomonae Jesús pia xantha tatsi tapatatsi. ");
INSERT INTO cui_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Poxonae be caentacabiyobe yapucaewa, bapoxonae Jesús equeicha caibeya pona Capernaum tomara beya. Jiwi yopita xua pinae Jesús botha eca. ");
INSERT INTO cui_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pin bicheito nacaetuta ichaxota po botha Jesús patopa, beya poxonae mataʉta bo coibo quecona. Barapomonaetha Jesús tsipaeba Nacom pia pexeinya jume diwesi tatsi. ");
INSERT INTO cui_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bapoxonae pebiwi pata cuatro poyobe. Barapo pebiwi yapaparuwa capata pon pecuenobinchi. ");
INSERT INTO cui_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tsipei pin bicheito, daxota barapo pebiwi jopa itacʉpaetsi xua Jesús imoxoyo pecaquita ponaewatsi. Daxota barapo pebiwi bomʉxʉtha pentatupa wereca atsa caxinaxoreca ichaxoya Jesús uncuareca. Barapo mʉthʉ deca pon pecuenobinchi yapaparuwa yorecatsi. ");
INSERT INTO cui_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Poxonae Jesús yaputane xua barapomonae yabara cui jume cowʉnta xua bara Jesús peitacʉpaewatsi xua axaibi peexanaewatsi pon pecuenobinchi, bapoxonae pecuenobinchitha Jesús tsipaebiya jeye: —Tajitom cacui yabara jʉntemainaya jʉntʉ puxana exanatsiba abe jinya neexanae cuiru coyenein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ichitha baraxota irʉ naena pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Barapomonae nanta xeinaeya najei: ");
INSERT INTO cui_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Maisa bapon bichocono abe tsipei pocotsiwa bapon paeba bichocono Nacom tsita ajumebetsi. Jiton dapocotsin aibi pon xua jiwi cacui yabara jʉntemainaya jʉntʉ puxana exanatsi abe pia peexanae cuiru coyenein tatsi. Jame meisa apara caein Nacom yaputane xua jiwi cacui yabara jʉntemainaya jʉntʉ puxana exanatsi abe pia peexanae cuiru coyenein tatsi”, najei. ");
INSERT INTO cui_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Barapoxonae caena nainya Jesús yaputane pejʉntʉ coyenewatha pocotsiwa barapomonae pia coutha nayainyaba. Jesús jeye barapomonaetha: —¿Eta pocotsiwa metha baraxua pana natsipaebame? ");
INSERT INTO cui_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Eta po jumetha baran tsane pecuenobinchi? ¿Metha jan tsane: ‘Jinya abe neexanae cuiru coyenein cata jʉntemainatsi’, jan tsane? Ichacuitha ¿metha jan tsane: ‘Nontaponde, bara pire jinya nemaituncuaewa, yawa bara ponare’, jan tsane? ");
INSERT INTO cui_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Daxota anoxuae paca tsita itapeinya xeinaeinchi, xua xan ponxaein Nacom Tananeitapetsin, xua xeinan taayapusʉ itorobi coyenewa xua bara tana neitacʉpaewa xua jiwi tayabara cacui jʉntemainaya jʉntʉ puxana exanaewa abe pia peexanae cuiru coyenein tatsi pomonae jinompa barapo cae pin nacuathe, jei Jesús. Bapoxonae Jesús tsipaeba pontha pon pecuenobinchi. Jesús jeye: ");
INSERT INTO cui_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Catsipaebatsi, nontaponde. Jinya nemaituncuaewa pire. Jinya bo be-iyandeno, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bapoxonae bapon caena nainya nontapona barapomonae peitʉtha tatsi, yawa pita xua pemaituncuaewa. Bapoxonae bapon bo tutu weya pona barapo pin bicheito peitʉtha tatsi. Daxita barapomonae yabara najʉntʉ coyene cabenaeca, yawa Nacom wʉnae jaintatsi, jeye: —Maisa waxainchi bapana bayatha jopa taetsi pocotsiwa wʉnae pocotsiwe icha be iche, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Barapoxonae Jesús pona Galilea pucua itapatha. Bapoxonae baxotiya pin bicheito pata Jesús pia xantha tatsi. Barapomonaetha Jesús cuiduba. ");
INSERT INTO cui_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Poxonae Jesús cataunxuae ecapona Galilea pucua itapatha, bapoxonae Leví tainchi. Bapon Leví Alfeo pexanto tatsi. Bapon Leví eca ichaxota bapon paratixi matoma noteibeca po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi. Jesús Leví tsipaebatsi, Jesús jeye: —Nepuna ponde, jei Jesús. Bapoxonae Leví nontapona, yawa Jesús puna poinchino. ");
INSERT INTO cui_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pirapaeyo Jesús Leví barʉ eca pexaethopeibiwatha, xua Leví pia botha tatsi xua Jesús pebarʉ xaenexatsi. Barichi Jesús barʉ eca pinmonae barapo pexaethopeibiwatha pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. Irʉrʉ Jesús barʉ eca ichamonae pomonae abe peexanae cuiru coyenein peexanae jiwi. Mataʉtano Jesús pijimonae barʉ eca barapo pexaethopaewatha. Pinmonae Jesús barʉ eca tsipei pinmonae Jesús puna poinchi. ");
INSERT INTO cui_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ichitha pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi irʉrʉ fariseomonae, daxita barapomonae Jesús tainchi poxonae Jesús barʉ xayeca pomonae paratixi pentoma noteibiwi, irʉ pomonae abe peexanae cuiru coyenein peexanae jiwi. Pomonae Jesús tainchi daxita barapomonae Jesús pijimonae tatsi jeichichi: —Maisa Jesús pon painya nepaca cacuidubin abe exana poxoru barʉ xayeca pomonae paratixi penoteibiwi, mataʉtano, barʉ xayeca pomonae peajʉntʉcoyenebe jiwi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Poxonae Jesús jume tane baraxua, bapoxonae Jesús jume nota, jeye: —Pomonae ba xua xaniwaicha jinompa xua jopa ateneyo barapomonae ba jopa canantawenonaeyo pon jiwi peyawʉbin. Saya jame meisa pomonae ba atene barapomonae jame canantawenona pon jiwi peyawʉbin. Barichi xan patopan apara tha jopa tawabinexa tsane pomonae pejʉntʉ coyene xanepanae jiwi. Saya apara tawabinexa pomonae abe peexanae cuiru coyene peexanaewi tayawenaenexa tsane barapomonae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Caentaqueitha Juan pia pepuna jinompaewichi, irʉrʉ fariseomonae, nainbota Nacomtha xua saya pewʉcaenexa Nacomtha. Poxonae barapomonae nainbota, bapoxonae ichamonae Jesús siwa poinchi. Barapomonae Jesús yabara yainyabatsi barapo penainbotsi coyene. Barapomonae jeye Jesustha: —Juan pia pepuna jinompaewichi, irʉ fariseomonae jopa juniya Nacom peyabara nainbotsiwatsi poxonae Nacom wʉqueibatsi. Ichitha jinyamonae jopa daichiyo, jopa nainbotsiyo Nacomtha xua saya pewʉcaenexa Nacomtha, jei barapomonae Jesustha. ");
INSERT INTO cui_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús jume nota barapomonae, jeye: —Jiwi ba jopa bewa wecoyeya yabara nainbotsi poxonae ichamonae pexaewa tsinacaetuta penabanaenexa xua poxonae pebin pecotsiwa pita. Poxonae cataunxuae awiya bapon eca pexaewa penabanaewatha bapoxonae jiwi ba pebʉrʉya nabane. Jopa bewa yabara nainbotsi tsane. ");
INSERT INTO cui_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ichitha icha pon aena piowa pita, caena nainya waetabatsi, ichamonae waetaba xua tajʉ bapon pecaponaenexatsi, bapoxonae jame jiwi ba bewa wecoyeya yabara nainbotsi, xua equeicha bapon caewa pepatopaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Jiwi ba jopa exanaeyo xua pena dorouto tsiwiyo jiwana caxinaxubeta xua peru dorouto pewan botsinexa. Icha baxua exanaetsipa xua pena paparuwatha wan bota peru doroutotha, bapoxonae barapo dorouto abe tsanaya tsipae. Tsipei poxonae barapo dorouto matanaxuba barapo pena paparuwa natsaquetabiya. Poxonae barapo pena paparuwa natsaquetabiya equeicha wan tsitsipanarena barapo dorouto. Bapoxonae equeicha nama bichocono pin wan tsanaya beyacaincha xua poxonae copiya. ");
INSERT INTO cui_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mataʉtano jiwi ba pena vino mera jopa eparecaeyo peru bocototha, tsipei icha baxua exanaetsipa, barapo pena vino mera abe exanaetsipa barapo bocoto. Tsipei barapo bocoto jopa nayeyetaponaeyo poxonae barapo vino mera atsaxa. Barapo pena vino mera naxuba xuano barapo bocoto naxuba poxonae barapo bocoto tsitsica. Daxota bewa jame pena vino mera eparecae pena bocototha. Bapoxonae pena vino mera jopa naxubiyo. Yawa pena bocoto jopa naxubiyo poxoru boco yeyena yawa poxoru pena bocoto”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Caentacabi poxonae judiomonae barompaya pia pentaquei seicae matacabi tatsi, barapo matacabitha Jesús, irʉ pijimonae tatsino pabi iyiya. Jesús pijimonae tatsi jainpa. Barapomonae tamropata notarʉcʉpa xua yaboto xunumenapona trigo xu. Bapoxonae pecobetha xu mata pepeta. ");
INSERT INTO cui_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Poxonae fariseomonae cui tane xua Jesús pijimonae tatsi exana, bapoxonae fariseomonae Jesús tsipaebatsi, jeye: —Jamaisa jinya jiwimonae nacuita barapo matacabithe, poxonae yaboto nota trigo xu. Apara jiwi jopa yabara cui copatsiyo xua ichamonae penacuichiwa barapo matacabithe xua judiomonae barompaya pia pentaquei seicae matacabi tatsi, jei fariseomonae. ");
INSERT INTO cui_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús jume nota, jeye: —Barapomonae tajiwimonae jopa apara abe exanaeyo. ¿Jopa payabara yorobim pocotsiwa bayatha David exana poxonae jainpa, poxonae irʉ pijimonae tajainpatsirʉ? Bapon David, pon caena bayatha israelmonae itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Bapon David, irʉ pijimonae tatsi, barapomonae jojoniya Nacom pin pia botha tatsi poxonae pon pewʉn Abiatar tanacuita Nacom. Bapon Abiatar sacerdotemonae pia pepa pentacaponaein tatsi. David xane pan, po pan ichamonae cana exana xua Nacom pecatsiwatsi. Irʉ barapo pan David pijimonae cata xua pexaenexarʉ. Barapomonae xane bequein bara Nacom pia peitorobi coyenewatha copata xua saya meisa sacerdotemonae itacʉpatsi xua pexaewa tsane barapo pan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Equeicha Jesús namchi, jeye: —Nacom, jiwi pewʉnaeya taexanatsi pentaquei seicae matacabi. Barapo pentaquei seicae matacabi Nacom tsiexana jiwi, xua barapo matacabitha jiwi penafifinacaewatsinexa. Nacom jopa ainya cui cana exanaeyo pentaquei seicae matacabi xua beyacaincha jiwi. ");
INSERT INTO cui_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Daxota xan ponxaein Nacom tana neitapetsixae xeinan taitorobi coyenewa xua jiwi tacoya taitorobiwa pentaquei seicae matacabitha, jei Jesús fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús equeicha joniya judiomonae pia penacaetutsi botha tatsi. Baraxota pon pecobe mʉbinchi eca. ");
INSERT INTO cui_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Barichi pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, irʉ fariseomonae baxota ena. Daxita barapomonae Jesús necotenatsi pecui taenexatsi icha bara metha Jesús cobe wʉnae exanaena pentaquei seicae mataqueitha pon pecobe mʉbinchi. Icha Jesús pon pecobe mʉbinchi axaibi exanatsi, bapoxonae barapomonae xeinaena po coyenewa xua Jesús abe peyabara paebiwatsi tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Bapoxonae Jesús barai pontha pon pecobe mʉbinchi, jeye: —Nontaponare. Uncuare xote, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Pomonae Jesús tainchi Jesús barai barapomonae, jeye: —Paca yainyabinchi, ¿eta xua copata pentaquei seicae matacabitha? ¿Wʉnae jampa? ¿Abe jampa? ¿Eta xua metha tsipae? ¿Xua pebin capanepatsi jampa? ¿Xua pebin bexotsi jampa? ¿Eta xua jane? jei Jesús. Ichitha barapomonae jopa jume notsiyo, saya moya umena. ");
INSERT INTO cui_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nexata Jesús necota barapomonae. Anaya Jesús caseba barapomonae. Mataʉtano jʉntʉ coyene wecoyei, tsipei barapomonae jopa beyaputaeyo pocotsiwa bapon exana. Jesús barai pon pecobe mʉbinchi: —Nacobe doire, jei Jesús. Bapon nacobe doita. Bapoxonae bapon nainya cobe wʉnae tsanaya. ");
INSERT INTO cui_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bapoxonae fariseomonae Jesús weya ponarʉcʉpa. Bapoxonae barapomonae nacaetuta Herodes pijimonaetha tatsi xua pecui yabara paebinexatsi xua po cui coyenewatha Jesús pebexubiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús pijimonae barʉ pona Galilea pucua itapa beya. Irʉrʉ pin bicheitomonae Jesús puna poinchi pomonae Galilea nacua weya pona. ");
INSERT INTO cui_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Irʉrʉ pomonae Judea nacua werena pona irʉrʉ pomonae Jerusalén tomara werena pona, daxita barapomonae Jesús puna poinchi. Irʉrʉ Idumea nacuapiwi Jesús puna poinchi. Irʉrʉ ichamonae Jesús puna poinchi pomonae icha muxunenetha jinompa xua Jordán mentha. Irʉrʉ Tiro tomarapiwi Jesús puna poinchi. Irʉrʉ Sidón tomarapiwi Jesús puna poinchi. Daxita barapo bicheito Jesús itata patatsi poxonae jume tane daxita xua juinya pocotsiwan Jesús exana. ");
INSERT INTO cui_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsipei pin bicheito, daxota Jesús pijimonae itoroba xua jera petaxawenaewa tsainchi xua petsaquibabiyainwatsi barapo pin bicheito. ");
INSERT INTO cui_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yaitama Jesús axaibi exaneiba pin bicheito pomonae atenemonae, daxota irʉ ichamonae Jesús imoxoyo caquita poinchi. Barapomonae ichichipa xua Jesús pejayabiwatsi xua barapomonae irʉ axaibi peexanaenexatsirʉ. ");
INSERT INTO cui_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Pomonae caurimonae pexeinaewi, poxonae barapomonae Jesús tainchi, barapomonae pentabocototha umena Jesús peitabaratha tatsi. Barapomonae wawaya jeye xua caurimonae wawai peexanaexaetsi: —¡Maisa bara xam Nacom Pexantom! jei barapomonae xua wawaya exanatsi caurimonae. ");
INSERT INTO cui_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús jume daunweya itoroba barapomonae, jeye: —Jopa pana neyabara paebinde ichamonaetha xua xan Nacom Pexanton, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Bapoxonae Jesús demxuwatha pona. Barapo demxuwatha Jesús waba pomonaetha xua peichichipaexae xua itapetsiya waba. Barapoxonae barapomonae Jesús pia xantha tatsi tapatatsi. ");
INSERT INTO cui_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesús itapetsiya waba doce poyobe xua pomonae pebarʉ jinompaenexatsi. Mataʉtano barapomonae Jesús itoroba xua daxita jiwitha petacueicueijeinexatsi Nacom Pejume Diwesi. ");
INSERT INTO cui_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Barapomonaetha Jesús cata pia peayapusʉ itorobi coyenewa tatsi, xua cauri ichamonae petaitawetsinexatsi pomonae xua cauri pepuna jinompaewichi. ");
INSERT INTO cui_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Meje barapomonae pewʉnxi tatsi pomonae Jesús waba: Simón pon icha wʉn wʉn dutatsi “Pedro”, baraichi. ");
INSERT INTO cui_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ichʉn pewʉn Santiago. Ichʉn pewʉn Juan pon Santiago peweicho tatsi. Baraponbe Zebedeo pexantobe tatsi. Baraponbetha Jesús icha wʉn wʉn dutabe “Boanerges” jei (xua po wʉntha xua jei: “Yamʉxʉ pexantobe tatsi”, jei). Barapo wʉn wʉn duta tsipei peajʉntʉcoyenesʉnbe. ");
INSERT INTO cui_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ichʉn pewʉn Andrés. Irʉ ichʉn pewʉn Felipe. Irʉ ichʉn pewʉn Bartolomé. Irʉ ichʉn pewʉn Mateo. Irʉ ichʉn pewʉn Tomás. Irʉ ichʉn pewʉn Santiago pon Alfeo pexanto tatsi. Irʉ ichʉn pewʉn Tadeo. Irʉ ichʉn pewʉn Simón pon celotemonaepin. ");
INSERT INTO cui_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Irʉ ichʉn pewʉn Judas Iscariote. Barapon Judas pon Jesús caenaetaxubatsi ichamonaetha pebexubinexatsi. ");
INSERT INTO cui_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bapoxonae Jesús, irʉ pomonae pia peitapetsiwi tatsi botha jojoniya. Bapoxonae equeicha pin bicheito nacaetuta Jesús pia xantha tatsi. Daxota Jesús irʉ pijimonae tatsi jopa itacʉpaetsi xua penabanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesús piamonae matabʉxʉyo tatsi jume tane xua jiwi paeba xua pinae juinya Jesús matayaibatsi. Daxota barapomonae pata, xua Jesús pewaetabinexatsi, xua pia bo beya pecaponaenexatsi. ");
INSERT INTO cui_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mataʉtano pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, pomonae Jerusalén werena pona, barapomonae jiwitha jeye Jesús yabara: “Bapon caurimonae itawetatsi, apara pexeinaexae Beelzebú pia peayapusʉ itorobi coyene tatsi, pon caurimonae pia pentacaponaein tatsi”, jei barapomonae pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi. ");
INSERT INTO cui_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bapoxonae Jesús waba barapomonae pia xainya berena. Yawano Jesús pecayabara jʉta pepaebi diwesiyo tsipaeba, jeye: “Caurimonae pia pentacaponaein tatsi jopa itacʉpaetsi xua peitawetsiwa icha caurimonaetha, xua pecae caurimonaexae. ");
INSERT INTO cui_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Icha cae nacuapiwi nawepu tsatabe xua mataʉta nababe, bapoxonae jopa xaexaenaecaeyo. ");
INSERT INTO cui_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mataʉta irʉrʉ icha cae bo matabʉxʉyomonaebe nababe yawa nawepu tsatajopabe, bapoxonae jopa xaexaenaecaeyo. ");
INSERT INTO cui_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Barichi icha Satanás, pijimonae tatsi nawepu tsatajopabe mataʉtano xua nababe, bapoxonae jopa xaexaenaecaeyo. Satanás jopa itacʉpaetsi xua itoroba pijimonae, tsipei amsiya exana. ");
INSERT INTO cui_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Dapon ajibi, pon itacʉpatsi xua botha joniya po botha pon bichocono maxʉ daunwei pia bo tatsi xua daxita notsina pocotsiwa bapon xeina pon maxʉ daunwei icha jopa copiya matha maxʉ cʉtanotsiyo. ");
INSERT INTO cui_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Bara xaniyeya paca tsipaebatsi. Pocotsiwa jiwi abe peexanae cuiru coyenein exana, mataʉtano pocotsiwa xua jiwi abe paeba, barapo coyenein Nacom itacʉpatsi xua yabara jʉntemainaena xua barapo jiwi abe exana. ");
INSERT INTO cui_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pon abe yabara paeba Nacom pia Pejumope tʉnaxʉ tatsi, Nacom bapana jopa yabara jʉntemainae tsane xua bapon paeba. Bara bapon ataya atene tsane ichaxota jopa itacounayiyo isoto xua bapon abe peexanaexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús baraxua paeba, tsipei pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi barapomonae bayatha naerabiya paeba xua pinae Jesús cauri xeina. Ichitha pon Jesús xeina apara Nacom pia Pejumope tʉnaxʉ tatsi. Daxota barapomonae Nacom pia Pejumope tʉnaxʉ tatsi tsita natsicuentatsi, tsipei Nacom pia Pejumope tʉnaxʉ tatsi abe yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Pirapae Jesús pena tatsi, irʉ peyapin jiwi tatsi pata Jesustha. Ichitha barapomonae pesato beumeinya. Bapoxonae najume caruta ichamonaetha xua petawabinexa tsainchi Jesús. ");
INSERT INTO cui_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Po bicheito Jesús matawacaicha enatsi, barapomonae Jesús tsipaebatsi, jeye: —Ena, irʉrʉ neyapin jiwino, pesato beya umena. Bepara bequein cataei. Bepara bequein catsipaebei, jei. ");
INSERT INTO cui_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ichitha Jesús jume barai barapomonae, jeye: —¿Jintam powa be taena natsicotanera? ¿Jintam pomonae be tayapin jiwi natsicotanera? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bapoxonae Jesús necota pomonae pematawacaicha enaewichi. Jesús jeye: —Barapomonae pomonae xote umene apara be taena tsicotan, mataʉtano be tayapin jiwi tsicotan. ");
INSERT INTO cui_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pomonae exana pocotsiwa Nacom itoroba, pon peitabocotha peecaeinxae, barapomonae be tayapin jiwi tsicotan, mataʉtano irʉ be tayapixi tsicotanno, mataʉtano irʉ be taena tsicotanno, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Equeicha Jesús tamropata pitaba xua cuiduba Galilea pucua itapatha. Bapoxonae pin bicheito nacaetuta ichaxota Jesús cuidubuncua. Tsipei pin bicheito daxota Jesús jeratha nontabiya xua peecaenexa, po nae mentha ducuiya. Barapo pin bicheitomonae taetabo itapatha umena. ");
INSERT INTO cui_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús barapomonaetha cuiduba pecayabara jʉta pepaebi diwesintha. Poxonae Jesús cuiduba barapomonae, jeye: ");
INSERT INTO cui_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pana nejume naitaeware barapo diwesiyo: Pebin pon peʉbin ponataba pia ʉbichi pabitha. ");
INSERT INTO cui_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Poxonae pon peʉbin ʉbauya, icha xu namtotha othopeica. Pepupunaewi yapata. Bapoxonae barapo xu xu xane. ");
INSERT INTO cui_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Icha xu, xu othopeica ibowantha ichaxota xua ira itafafana. Barapoxonae barapo xu caena nainya xu xuwa, tsipei jopa tajʉ xu xuwarecaeyo. ");
INSERT INTO cui_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ichitha poxonae xometo atsa tsina, bapoxonae yaboto tsaquiwa yawa tʉpa tsipei jopa tajʉ tabʉ opina xuwarecaeyo. ");
INSERT INTO cui_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Icha xu, xu othopeica ichaxota pesoiwan xuwinaena. Barapo xu yaboto nanta capanaba poxoru yawa muxuna xuwina pesoiwan. Daxota barapo xu jopa xu nacoichiyo. ");
INSERT INTO cui_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Icha xu, xu othopeica ichaxota ira wʉnae. Poxonae barapo xu, xu xuwa, xu nawʉnaeta. Icha xun, xu nanacoitapona treinta po xu matabʉxʉyobe tsiniya. Icha xun, xu nanacoitapona sesenta po xu matabʉxʉyobe tsiniya. Icha xun, xu nanacoitapona cien po xu matabʉxʉyobe tsiniya”, jei Jesús barapo pin bicheitomonaetha. ");
INSERT INTO cui_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Equeicha Jesús jeye: “Icha pamuxu dubename, moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi”, jei Jesús poxonae pijimonae muxuconaquiya tsipaeba. ");
INSERT INTO cui_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nexata poxonae Jesús pipatotha eca, bapoxonae barʉ eca pomonae pia pepuna ponaewichi, irʉno pijimonae tatsi pomonae doce poyobe. Barapomonae Jesús yainyabatsi jeye: “¿Eta pocotsiwa yabara caunutame poxonae barapo pecayabara jʉta pepaebi diwesiyo cuidubame?” jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús jume nota barapomonae, jeye: “Meisa paxam yatsicaewa Nacom yabara paca yaputane exana po pecuidubiwa xua moya peyawʉn xeinaewa. Barapo moya peyawʉn xeinaewa apara xua Nacom paca cana exana xua painya nepaca itacʉpaewa xua painya nenaexanaewa Nacom piamonae tatsi pam, pomonae pamxaem Nacom itorobiya paca ewata. Ichitha meisa jame ichamonae pomonae jopa nejume cowʉntsiyo jopa daichichi. Nacom jopa copatsiyo xua barapomonae peyabara yaputaewa baxua. Daxota barapomonae cuiduban pecayabara jʉta pepaebi diwesintha, xua Nacom peyabara yaputaenexatsi. ");
INSERT INTO cui_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Baxua paeban xua bequein pia tana necui taibenaewatha tsane ichitha jopa pia tana necui yaputaibenaewatha tsane. Yawa xua bequein pia tana nejume taibenaewatha tsane ichitha jopa pia tana nejume copi taibenaewatha tsane. Poxoru bapomonae jopa icha jʉntʉ coyene xeinaeyo Nacomtha, daxota barapomonae Nacom tsita natsicuentatsi abe petsita exanaexaetsi xuano Nacom jopa yabara jʉntemainaeyo abe pia peexanae coyenein tatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Equeicha Jesús barapomonaetha muxu tsipaeba, jeye: “Tsipei jopa payaputaem po pecayabara jʉta pepaebi diwesiyo xua peʉbin yabara paeban daxota jopa payaputaemtsipae bequein ainya pecayabara jʉta pepaebi diwesin paca tsipaebichipatsi. ");
INSERT INTO cui_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Paca tsipaebatsi pecayabara jʉta pepaebi diwesiyo xua iche: Pon peʉbin jʉpa, icha be ichi pon Nacom Pejume Diwesi pepaebi ducuanaebiyaein. ");
INSERT INTO cui_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Po xuton xua namto beothopiya, aichurubenae. Barapo xuton yabara caunuta xua jiwi bara jʉntʉ weichichi caurimonae pia pentacaponaein tatsi, pon Satanás. Jiwi jʉntʉ coyene weajumetsurubenae exanatsi Nacom Pejume Diwesi xua bayatha po jume jume tane, xua bapoxonae jopa petajume cowʉntsinexa tsainchi Nacom, yawa xua jopa petanacapanenebiyaenexa tsainchi Nacom beya, xua Nacom exanaena. ");
INSERT INTO cui_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Po xuton xua xu othopa ibowantha, barapo xuton yabara caunuta po jiwi xanepanaya jume tane Nacom Pejume Diwesi, xuano jʉntʉ coyene weiweinaya Nacom jume cowʉntatsi. Ichitha bara caeto jume cowʉnta, poxoru barapomonae ajʉntʉfaetabiya jume jeba Nacom Pejume Diwesi pejʉntʉ coyeneintha. Poxonae yaitama barapomonae bichocono peatenexae, mataʉtano poxonae barapomonae yaitama abe petaexanaexaetsi ichamonae xua pejume cowʉntsixae Nacom, bapoxonae caurimonae abe exana barapomonaetha, xua barapomonae jʉntʉ coyene wejʉntemaina exanatsi xua Nacom pecayabara jʉntemainaewatsi. ");
INSERT INTO cui_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Po xuton xua xu othopeica pesoiwantha, barapo xuton caunuta xua pomonae Nacom Pejume Diwesi jume tane, ichitha saya barompaya pia jʉntʉ coyeneyatha jinompa, yawa saya ʉ copei cayabara nanta xeina, yawa saya exana pocotsiwa jʉntʉ coyene weiweina cana exainchi. Po coyene pebiwi exana baxuan bara jʉtiya ichiya exana xua po xuton be pesoiwantha othopiya. Barapo xuton jopa thei dubenaeyo. Barapocotsi jʉta coyeneya ichi, barapo jiwi. Jopa xanepanaya jinompaeyo Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Po xuton xua xu othopeica peira wʉnaewatha, bara nacoita. Barapo xuton yabara caunuta pomonae jume tane Nacom Pejume Diwesi, mataʉtano jume cowʉntano poxoru jʉntʉ coyene xanepanaya jume tane. Mataʉtano beta exana dubenanaebiya beya matapainya jiwi cui tane xua barapomonae jʉntʉ coyene xanepana Nacom peitabaratha tatsi. Bapoxonae ichamonae barapomonae jiwana beta yawena ichamonaetha icha barapo xuto ichi xua treinta po xu matabʉxʉyobe tsiniya tsoponae. Mataʉtano ichamonae barapomonae jiwana beta yawena ichamonaetha icha barapo xuto ichi xua sesenta po xu matabʉxʉyobe tsiniya tsoponae. Mataʉtano ichamonae barapomonae jiwana beta yawena ichamonaetha icha barapo xuto ichi xua cien po xu matabʉxʉyobe tsiniya tsoponae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Equeicha Jesús barapomonaetha tsipaeba, jeye: “Poxonae jiton pecoicha, coicha exana, bapoxonae jopa coicha matacatsiyo cajatha. Yawa jopa coicha exanaeyo cama peʉpana deca. Jame asiya coicha exanatsi, xua pecoicha taenexa pomonae jojoneibarena. ");
INSERT INTO cui_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Daxita pocotsiwa xua moya peyawʉn xeinaewa bexa tsane jiwi yabara yaputaena. Barichi po diwesin xua pecayabara jʉta pepaebi diwesin xua paebapona jiwi barapo diwesin jiwi itacʉpaeinchi xua peyabara yaputaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Icha pamuxu dubename, moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi”, jei Jesús poxonae pijimonae muxuconaquiya tsipaeba. ");
INSERT INTO cui_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Equeicha Jesús barapomonae barai, jeye: “Pana nejume naitaeware painya neexanaenexa pocotsiwa paca tsipaebatsi. Icha ichamonae daunweya payabara paebiname penatsicuentsiwa xua abe peexanaexae Nacom barichi daunweya paca yabara paebina painya nenatsicuentsiwa xua abe painya neexanaexae. Mataʉtano equeicha ichawano mataropeicha paca catsina. ");
INSERT INTO cui_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pon ba be conotha Nacom yabara yaputainchi Nacom bapontha cana exanaena xua ichawa peyabara yaputaewa tsane beya poxonae bapon equeicha bichocono Nacom pejume cowʉntsiwa tsainchi. Pon ba jopa ichipaeyo xua Nacom peyabara yaputaewatsi Nacom wepichina po coyene bapon yaputane xua beya daxota Nacom jopa pejume cowʉntsiwa tsainchi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nexata equeicha Jesús namchi, jeye: “Yabara paca cuidubatsi po coyene xua Nacom itorobiya ewata piamonae. Barapo coyene bara jʉta coyeneya ichi, icha pebin ichi poxonae peʉbi xu xu bebeya. ");
INSERT INTO cui_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Poxonae nacobe weta xua ʉba, bapoxonae pabi weya pona. Bara bequein bapon jopa yawenaeyo xua barapo xuton xuxuwapona mataqueitha, merawithano poxonae pebin maitequeiba, daichitha awiya barapo xu xuxuwapona. ");
INSERT INTO cui_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Daxota barapo xu xuxuwapona tsipei ira yawena xua barapo xu xuxuwapona. Copiya pepaboto xuwina, bapoxonae pepato naexana. Bapoxonae pepa xu xu dubena xua bichocono axucʉcʉ. ");
INSERT INTO cui_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Poxonae pepa xu xu naweta barapo matacabitha pebin pona xua penotsinexa pocotsiwa naweta”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús barapomonae tsipaeba, jeye: “Poxonae Nacom waba jiwi xua petanaexanaenexatsi piamonae tatsi pomonae itorobiya peewatsixae, ¿eta po coyene nacoyene jʉpabe? ¿Eta xua paca cuidubinchi xua baxua yabara? ");
INSERT INTO cui_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Nacom pijimonae tatsi mataropeicha bichocono pinmonae tsoponae xua pomonae jume cowʉntapona Nacom. Baraxua icha be mostaza xutiyo ichi po xutiyo bichocono tsica xutiyo beyacaincha xua icha pethei xutiyo. Barapo mostaza xutiyo pebin ʉba pia pabitha. Xuwa beya pin nae tsoponae. Pepinnaexae daxota siri coton exana pemaxʉranantha. Icha mostaza xutiyo ichi xua beya pin nae tsoponae, bara jʉta ichi Nacom pejume cowʉntsiwichi, pomonae bapon itorobiya peewatsixae. Bequein anoxuae tsica bicheitiyo, bexa tsane beya pin bicheito tsoponae tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús jiwitha ainya pecayabara jʉta pepaebi diwesixi tsipaeba poxonae cuiduba Nacom Pejume Diwesi, icha barapocotsi diwesixi ichi xuaunxuae po diwesixi paeba. Awiya cuidudubapona beya poxonae barapomonae xainwaicha yaputane. ");
INSERT INTO cui_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Saya meisa barapomonaetha Jesús cuidubeiba pecayabara jʉta pepaebi diwesixi coyenexitha. Poxonae Jesús meisa pijimonae barʉ eca, bapoxonae Jesús pijimonae yabara muxu yaputane exana pecayabara jʉta pepaebi diwesixi coyenexi. ");
INSERT INTO cui_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Barapo mataqueitha poxonae quirei tsanaicha Jesús pijimonae tsipaeba, jeye: —Antha poinchi icha muxunene beya, pucua beicha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bapoxonae Jesús pijimonae barʉ wepu pona barapo pin bicheito. Bapoxonae Jesús pijimonae barʉ poinchi jeratha, po jeratha Jesús cuidubeca barapo pin bicheito. Barichi icha jeranno naponano. ");
INSERT INTO cui_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bapoxonae mentha jemeicha naetaba pin joibo. Maratsacan jeratha mene othopa, muxu jera pebunarecae. ");
INSERT INTO cui_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ichitha Jesús jera tafetha maituncua, nantasipa yʉyʉtuncua paparuwatha xua xota nacuenacuena. Jesús pijimonae yaʉbatsi, jeichichi: —Pon pata Necuidubin, ¿jopa catsita ainya cuiyo xua waxainchi bunathopaeinchi? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bapoxonae Jesús asiya uncua, yawa joibo itawetaxuba. Jesús jeye maratsacantha: —¡Barande, bara xainya mene ducuanayama! jei Jesús. Bapoxonae joibo caewanaya, yawa mene xainya ducuanaya. ");
INSERT INTO cui_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nexata Jesús barai pijimonae, jeye: —¿Eta pocotsiwa metha bichocono pajunuwame? ¿Cataunxuae jopa pana nejume cui yabara jume cowʉntsim xua bara tana neitacʉpaewa xua tapaca yawenaewatsi? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Barapomonae bichocono najʉntʉ coyene cabenaeca, yawa caemonae natsipaeba najei: —¿Metha jintamda baponda? ¡Jamaisa bapon itawetaxuba joibo yawa maratsacan xua daxita xainya dubenanaya! najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús, irʉ pijimonae tatsi pata icha muxunene beya xua barapo pucuathiya. Po iratha Jesusbarʉ pata barapo ira pewʉn Gerasa nacua. ");
INSERT INTO cui_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Poxonae Jesús jera wenontouna bapoxonae patopa pebin pon caurimonae xeina. Bapon ibo wou weya patopa Jesustha. ");
INSERT INTO cui_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Barapo pebin poponeiba ibo wountha. Dapon aibi pon itacʉpatsi xua bapon pecʉtsiwatsi, mataʉtano metha bequein penaintotha tsipae. ");
INSERT INTO cui_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bapon matowa penaintotha taxu cʉbeibatsi, yawa maxʉ cʉbeibatsi xua bapon peyapucaeneibinexa tsainchi. Daichitha bapon barapo nain nain epa xuneiba. Dapon aibi xua bapon pecui amanayabiwatsi. ");
INSERT INTO cui_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Barapon mataqueitha poponeiba, yawa merawitha poponeiba. Mataʉtano atororotha yawa ibo wountha wawai tsopoponeibi. Mataʉtano ibotixitha pia coutha nathabeiba. ");
INSERT INTO cui_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Poxonae barapo pebin Jesús tajʉ taebatsi, bapoxonae cuinaepona Jesús beya. Bapon pentabocototha uncua Jesús peitabaratha tatsi xua Jesús pebarʉ cui itura jinaexaetsi peainya cuinxae. ");
INSERT INTO cui_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Bapon wawaya jeye Jesustha: —Jesús pon Nacom Pexantom, pon peitabocotha eca, ¿eta pocotsiwa metha taxantha patopame? Jume daunweya cabaraichi jopa neperaxa exanaeinde, jei. ");
INSERT INTO cui_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bapon baxua paeba tsipei Jesús copiya namchi, jeye: —¡Caurimonae pam, bapon pawepu ponare! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús yainyaba bapontha: —¿Eta po wʉm? jei. Bapon jume nota jeye: —Tawʉn Ayei, tsipei paxan caurimonae pan ayei jiwi pan, jei bapon xua paeba exanatsi caurimonae. ");
INSERT INTO cui_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Barapo caurimonae Jesús muxu fayacotatsi xua bepa pinae barapomonae jopa bewa itawetichi icha nacua beya. ");
INSERT INTO cui_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ichaxota imoxoyo peitapatororotha baxota jinompa pin marranomonae. Barapo marrano duweimonae xayompa peitapa tororotha. ");
INSERT INTO cui_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Caurimonae Jesús wʉcatsi, jeye: —Icha pana itawetame, moya pana nepu copabare marrano duweimonaetha, jei caurimonae. ");
INSERT INTO cui_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Bapoxonae Jesús copata xua bara caurimonae ponaena marrano duweimonaetha pebin weya. Barapo marranomonae dʉcʉpa. Pin pitapatororo othopareca. Pucuatha bunothopa. Yawa caurimonae cabunathopatsi. Barapo marranomonae dos mil po duweimonaebe. ");
INSERT INTO cui_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bapoxonae pomonae peyapu eenaewi marranomonae, barapomonae bichocono junuwiya cuinaepona tomara beya, jiwi petsipaebinexatsi baxua yabara, yawa jiwi petsipaebinexatsi tomara cuariya beya. Bapoxonae jiwi pata petaenexa pocotsiwa Jesús cana exana pebintha. ");
INSERT INTO cui_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Poxonae barapomonae pata Jesustha, bapoxonae barapomonae tane pebin pon bayatha cauri xeina. Barapo pebin moya eca, paparuwa nama xatatano, mataʉtano jʉntema eca. Bapoxonae barapomonae bichocono junuwa. ");
INSERT INTO cui_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Pomonae bayatha tane xua pocotsiwa Jesús bayatha cana exana pebintha, pontha pon cauri xeina, baxua yabara paeba ichamonaetha pomonae pata. Mataʉtano yabara paeba pocotsiwa Jesús cana exana marrano duweimonaetha. ");
INSERT INTO cui_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bapoxonae barapomonae tamropata notarʉcʉpa xua Jesús itawetatsi, jeye: “Maisa bewa warapaename Gerasa nacua weya, po nacua pata nacua weya”, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Poxonae Jesús jeratha nontabiya, bapo pebin pon bayatha caurimonae xeina, bapon Jesús wʉcatsi xua bepa pinae Jesús puna ponaetsi. ");
INSERT INTO cui_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ichitha Jesús jopa copatsiyo xua pepuna ponaenexa tsainchi bapon. Saya jame Jesús bapontha jeye: —Maisa jinya bo beya ponare ichaxota jinyamonae matabʉxʉyo beya. Barapomonaetha tsipaebare daxita pocotsiwa Nacom cacana exana. Mataʉtano barapomonaetha tsipaebare xua Nacom bara cayabara najʉntʉ coyene xeina pia necayawenaenexa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bapoxonae barapo pebin ponataba. Mataʉtano tamropata pitaba xua cueicueijei daxita pocotsiwa bayatha Jesús cana exana bapontha. Barapon baxua tsipaeba Decápolis tomarantha, po tomaran xua diez po tomaranbe xua imoxoyo nacacuita ena. Daxita jiwi barapo tomaran najʉntʉ coyene cabenaeca poxonae jume tane xua barapon paeba. ");
INSERT INTO cui_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Poxonae Jesús caibeya pona jeratha icha muxunene beya pucua iya, bapoxonae pin bicheito Jesús pia xantha tapatatsi pitapatha. ");
INSERT INTO cui_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bapoxonae caein patopa pon judiomonae pia penacaetutsi bo tatsi pecanamataxeinaewi jiwanamonaepin. Bapon pewʉn Jairo. Poxonae bapon Jesús tainchi, Jesús peitabaratha tatsi pentabocototha tauncuatsi. ");
INSERT INTO cui_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Bapon Jairo bichocono Jesús wʉcatsi. Jairo jeye: —Taxantiyo muxu imoxoyo petʉpae. Anetha, inta taxantiyo necobetha mata jayabare, axaibi jinya neexanaenexa tsane. Bapoxonae inta asʉ pepoponaenexa tsane, jei Jairo. ");
INSERT INTO cui_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Bapoxonae nexata Jairo Jesús puna pona. Pin bicheito Jesús puna poinchi, yawa barapo bicheito tsaquibabatsi. ");
INSERT INTO cui_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Barapo pin bicheitotha irʉ napona yabʉyo powa atene. Barapowa caena bayatha beya yadoce po weiyobe jopa xua pentabʉ janatha boca xua be nantawane. ");
INSERT INTO cui_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Barapowa bichocono atene tsaibi bequein siwa poneiba pomonaetha pomonae peyawʉbiwi jiwi. Barapomonae bapowa daxita cobe matapaeteibatsi paratixi xua bapowa peyawʉbixaetsi, daichitha bapowa jopa yawenaetsi baxua. Saya equeicha bichocono abe tsoponae bapowa. ");
INSERT INTO cui_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Poxonae bapowa jume tane xua pinae juinya Jesús axaibi exana jiwi, bapoxonae bapowa imoxoyo caquita uncuataba Jesús peputha tatsi xua pin bicheitotha. Barapowa Jesús pia paparuwa tatsi tajayabatsi xua peopirawa. ");
INSERT INTO cui_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Barapowa pia coutha natsipaeba, najei: “Icha saya Jesús pia paparuwa tajayabin, bapoxonae axaibin tsane”, najei. ");
INSERT INTO cui_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Poxonae barapowa tajayaba Jesús pia paparuwa tatsi, bapoxonae caena nainya bapowa ajaneibi tsanareca. Bapowa pia coutha nayaputane xua bayatha axaibi. ");
INSERT INTO cui_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús pia coutha nayaputane xua ichʉn axaibi peexanaewatsi, tsipei pia pepon weya taajiwanatsurucuaetsi pia peayapusʉ itorobi coyenewa tatsi. Bapoxonae Jesús napatomeicha necota jiwitha, jeye: —¿Jintam inta paparuwa jayabara? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nexata Jesús pijimonae jume notatsi, jeye: —Apara xam bayatha taneme xua pin bicheito catsaquibaba. ¿Eta xua metha pana yainyabame: ‘¿Jintam metha inta paparuwa jayabara?’ jam? jei pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ichitha Jesús daxita jʉpaya tane peyaputaenexa pon pejayabiwatsi. ");
INSERT INTO cui_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Barapowa bichocono junuwa, tsipei yaputane xua barapowa Jesús jayabatsi poxonae axaibi exanatsi. Barapowa jijiyeya patopa Jesustha, yawa pentabocototha uncua Jesús peitabaratha tatsi xua Jesús pebarʉ cui itura jinaexaetsi peainya cuinxae. Barapowa bara xainyeya paeba daxita pocotsiwa xua exana. ");
INSERT INTO cui_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús jeye barapowatha: —Yabʉyo, caaxaibi exanatsi tana neyabara jume cowʉntsixaem xua bara tana neitacʉpaewa xua tacaaxaibi exanaewatsi. Saya jʉntemiya poponde. Bara axaibim tsaibim tsane xua bara nepu tsitecae tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Poxonae Jesús cataunxuae cueicueijei tsuncuae barapowatha, bapoxonae pata pomonae Jairo pia botha petanacuichi jiwichi. Bapon Jairo pecanamataxeinaein judiomonae pia penacaetutsi bo tatsi. Barapomonae jeye Jairotha pon pexantiyo taatenetsi: —Nexantiyo bayatha cata tʉpa. ¿Eta xua metha came fayacotame pon jiwi Pecuidubin? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bequein bara baxua Jesús jume tane, ichitha baxua Jesús jopa jume naitaewatsiyo. Jesús jeye Jairotha: —Jopa junuwinde, saya maisa nejume cowʉnde, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bapoxonae Jesús jopa copatsiyo xua pepuna ponaewatsi tsainchi ichamonae. Saya meisa Jesús copata, xua pepuna ponaenexa tsainchi Pedro, irʉ Santiago irʉ Juan pon Santiago peweicho tatsi. ");
INSERT INTO cui_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Poxonae Jesusbarʉ pata Jairo pia botha tatsi, bapoxonae Jesusbarʉ tane pin bicheito xua ajumeyaexa. Barapomonae bichocono wecoyei, yawa wawai xua Jairo pexantiyo petatʉpaexaetsi. ");
INSERT INTO cui_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Bapoxonae Jesús joniya botha, yawa tsipaeba barapomonaetha, jeye: —¿Eta pocotsiwa metha paajumeyaexam, xua yawa pawecoyam? Barapo pexuyo apara jopa tʉpaeyo, apara maituncua, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ichitha barapomonae Jesús jume cui caponatsi. Nexata barapo pin bicheito Jesús pesato beitaweya. Meisa saya Jesús barʉ joniya coxiyʉn, coxiwano ichaxota Jairo pexantiyo tatsi petʉpaeyo tabocatsi. Mataʉtano Jesús pijimonae barʉ joniya poyobe acoibi poyobe. ");
INSERT INTO cui_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Barapowayo Jesús cobe pita, yawa jeye: —Talita, cum, jeichichi (xua apara jeichi: “Yabʉyo, asiya uncuare, catsipaebatsi”, jei Jesús.) ");
INSERT INTO cui_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Barapoxonae barapowa caena nainya nontapona, powa xua doce po weibe xeina powayo Jairo pexantiyoxae tatsi. Barapowa asiya uncua, yawa itacʉpatsi xua peponaewa. Barapoxonae barapo pin bicheito poxonae baxua Jesús cui tainchi najʉntʉ coyene cabenaeca. ");
INSERT INTO cui_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bapoxonae Jesús jume daunweya itoroba jiwitha xua baxua jopa peyabara paebinexatsi ichamonaetha pocotsiwa Jesús cana exana barapowayotha. Bapoxonae Jesús itoroba xua barapo pexuyo bara peapatsiwa tsainchi pexaewa. ");
INSERT INTO cui_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nexata Jesús Capernaum tomara weya warapa, equeicha caibeya pia tomara beya warapa xua Nazaret tomara beya. Irʉrʉ Jesús pijimonae puna poinchi. ");
INSERT INTO cui_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Poxonae judiomonae barompaya pia pentaquei seicae matacabi tatsi tsuxubi, barapo matacabitha Jesús tamropata pitaba xua cuiduba judiomonaetha judiomonae pia penacaetutsi botha tatsi. Pinmonae pomonae Jesús jume tayenatsi, barapomonae najʉntʉ coyene cabenaeca, jeye: —¿Eta xota metha bapon nacuiduba daxita baxua jane? ¿Jintam metha cata bapontha barapo peyaputae coyene jane, xua daxota bapon pexeinya petsita itʉtsi coyenewa exana? ");
INSERT INTO cui_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Apara bapon pon naepan pematabobin. Bapon apara María pexanto tatsi, apara irʉ Santiago pentapin tatsi, irʉ José pentapin tatsi, irʉ apara Judas pentapin tatsi, irʉ Simón pentapin tatsi. Apara bara irʉ pamchowaxi tatsi watomaratha jinompa, jei barapomonae. Daxota barapomonae jopa xapain Jesús yabara jume cowʉntsichi. ");
INSERT INTO cui_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ichitha Jesús jeye barapo jiwitha: —Daxita jiwi ba barʉ cui itura jina pontha pon Nacom peayapusʉ itorobi jume pepaebin. Nama pia tomarapiwi tatsi, irʉ piamonae tatsi irʉ pia bomonae matabʉxʉyomonaepiwi tatsi, barapomonae ba jopa bapon barʉ cui itura jinaetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Daxota Jesús jopa itacʉpaetsi xua pexeinya petsita itʉtsi coyenewan peexanaewa barapo Nazaret tomaratha po tomara pia tomaraxae tatsi. Saya meisa Jesús axaibi exana tsicamonaeyo pomonae peatenewi. ");
INSERT INTO cui_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús najʉntʉ coyene cabenaeca, tsipei barapomonae jopa yatsicaewa jume cowʉntsichi. Daxota Jesús cuidubapona tsiqui tomaraxitha po tomaraxi ena Nazaret tomara pecuariya. ");
INSERT INTO cui_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús waba pijimonae pomonae doce poyobe tatsi. Jesús tamropata pitaba xua tsana itoroba tsiniya tomarantha be dos poyobe tsiniya. Jesús pijimonae cata pia peayapusʉ itorobi coyenewa, xua pijimonae tatsi peitawetsinexa caurimonae. ");
INSERT INTO cui_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jesús pijimonae itoroba, xua pijimonae tatsi jopa pecaponaenexa pocotsiwan xua poxonae namtontha peponaenexa. Itoroba xua saya meisa pecaponaenexa naeton po naeton penacobena bababi naeton. Jopa bewa barapomonae pecaponaenexa cotein, yawa jopa bewa pecaponaenexa pexaewan, yawa jopa bewa pecaponaenexa paratixi. ");
INSERT INTO cui_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yawa Jesús pijimonae itoroba xua bara nataxu xatabina sapaton, po sapaton pebʉxʉmʉbiwan. Mataʉtano barapomonae bewa nama xatabina saya be cae camisan. Jopa bewa caponae icha camisan. ");
INSERT INTO cui_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jesús pijimonae barai, jeye: —Poxonae papatame tomaratha moya bara paenare po botha papatame, xua beya abʉ poxonae pawarapaename barapo tomara weya. ");
INSERT INTO cui_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Icha, icha tomarapiwi jopa paca matenta weyataeya wabiyo, mataʉtano icha jopa paca jume naitaewatsiyo pocotsiwa papaebame, nexata bapoxonae barapo tomara weya pawarapare. Po tsorobon painya taxutha dubena panataxu wenʉnʉbabare barapo tomaratha. Baxua paexande xua barapomonae peyaputaenexa xua apara barapomonae abe exana paxamtha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bapoxonae Jesús pijimonae tatsi ponarʉcʉpa Jesús pia xainya weya tatsi. Barapomonae cueicueijei jiwitha xua bewa pinae jiwi icha jʉntʉ coyene xeinae Nacomtha xua peauraxae xua abe peexanae cuiru coyene exana Nacomtha. ");
INSERT INTO cui_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Barichino barapomonae taitaweta cauri pomonae cauri xeina. Mataʉtano barapomonae caxueba penasiwatha pomonaetha pomonae peatenewi. Bapoxonae barapomonae axaibi exana pinmonae pomonae peatenewi. ");
INSERT INTO cui_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Herodes pon Galilea nacuapiwi itorobiya pia pepa peewatsinchi bapon jume tane xua juinya jiwi daxita jume tane pocotsiwa Jesús exana. Daxota bapon jeye: —Juan pon jiwi Pebautisabin pon bequein bayatha tʉpa, equeicha asʉ juina. Daxota barapon Jesús xeina barapo peayapusʉ itorobi coyenewa xua exana pexeinya petsita itʉbi coyenewan, jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ichamonae Jesús yabara jeichichi: —Bapon apara Elías xua equeicha asʉ, pon bayatha tʉpa, jei. Irʉrʉ ichamonae jeye: —Bapon apara pon Nacom peitorobi jume pepaebin icha pomonae ichi pomonae Nacom peitorobi jume pepaebiwi pomonae caena bayatha jinompa, jei xua ichamonae paeba. ");
INSERT INTO cui_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Poxonae Herodes baxua jume tane, jeye: —Apara bapon Juan, pon yabara xua bayatha najume carutan xua bapon pewisi ucuibiwatsi. Anoxuae bapon equeicha asʉ petʉpae cuiru coyene weya, jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes baxua paeba, tsipei caena bayatha Herodes cui itoroba xua Juan pewaetabinexatsi, mataʉtano xua pemaxʉ cʉbinexatsino mataʉtano xua jiwi pecʉbi botha peetsinexatsi. Herodes baxua exana tsipei piowa tatsi powa pewʉn Herodías pia coutha baxua peichichipaexae. Barapowa copiya Felipe xeina pon Herodes peweicho tatsi. Herodes peweicho yacaiba yabʉyo. ");
INSERT INTO cui_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Daxota Juan jiwi pecʉbi botha etatsi, tsipei Juan Herodes tsipaebatsi, jeichichi: “Nacom pia peitorobi coyenewa jopa copatsiyo xua xeiname bapowa tsipei bapowa eweicho piowa tatsi”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Daxota bapowa Herodías Juan bichocono casebatsi. Bequein bapowa ichichipa xua Juan pecaenaetaxubiwatsi xua ichamonae pebexubiwatsi tsainchi, ichitha jopa itacʉpaetsi bapowa. ");
INSERT INTO cui_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodías jopa itacʉpaetsi xua peexanaewa baxua, tsipei Herodes Juan cunuwatsi. Bapon yaputane xua Juan bara xaniwaicha peexanaein, xuano mataʉtano bara jʉntʉ coyene xanepana Nacomtha. Daxota jopa copatsiyo xua Juan bara abe pecana exanaenexa tsainchi. Bequein Herodes yabara ʉnthʉthʉ deideijei pocotsiwa Juan pepaebixae, daichitha awiya ichichipa pocotsiwa Juan pepaebiwa. ");
INSERT INTO cui_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ichitha matacabi jopa, po matacabitha Herodías itacʉpatsi xua Juan abe pecana exanaewatsi. Herodes yantacabi jopa, po matacabitha caena bayatha Herodes naexana poxonae pexuyo. Barapo matacabitha Herodes exana pin penabanaewa. Bapon waba pomonae irʉ pentacaponaewi, pomonaetha itoroba xua irʉ tacanamataxeinatsi icha tomarantha. Irʉno wabano pomonae soldadomonae pia pepa pentacaponaewi tatsi. Irʉno wabano pomonae ainya cui penaexanae jiwi Galilea nacuatha. ");
INSERT INTO cui_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodías pexantiyo tatsi patopa po tututha ichaxota nabanathopa. Barapowa tsita yaweibuncua xua barapomonae tane. Baxua Herodes ichichi xeica xua bapowa yaweibuncua. Irʉrʉ pomonae baxota naxayena, ichichi xeica baxua. Bapoxonae Herodes jeye bapowatha. —Newʉcare pocotsiwa xua neichichipaewa, bapoxonae cacatsinchi jinya beta neyaweibixae, jei Herodes. ");
INSERT INTO cui_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Bapon Herodes yabara tsiwʉnae muxu dutsiya jeye: —Bara cacatsinchi pocotsiwa xua newʉcame. Metha bequein newʉcaetsipame xua tanacua epa toyatsipan baraxua bara cacatsinchi, jei. ");
INSERT INTO cui_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Barapowa pona xua peyainyabinexa pena, jeye: —Ena, ¿eta pocotsiwa metha wʉcacuaein? jei. Barapowayo pena jume notatsi, jeye: —Wʉcare Juan pentasipa tatsi, pon jiwi Pebautisabin matasipa, jei Herodías. ");
INSERT INTO cui_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Barapowayo barapoxonae caena nainya pona ichaxota eca Herodes. Jeye bapontha: —Ichichipan xua nainya anoxuae tanecatsiwam tsane paratontha Juan pentasipa tatsi, pon jiwi Pebautisabin matasipa, jei. ");
INSERT INTO cui_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Barapoxonae Herodes bichocono ʉnthʉthʉ wecoyei. Ichitha tsipei bayatha yabara petsiwʉnae muxu dutsixae xua bepa pinae catsina pocotsiwa wʉcaeinchi, mataʉtano tsipei pejume taexaetsi pomonae bayatha waba, daxota Herodes jopa bejume totabiyo pocotsiwa wʉcatsi. ");
INSERT INTO cui_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bapoxonae caena nainya Herodes itoroba soldadomonaepin xua pecarenaenexa tsane paratontha Juan pentasipa tatsi. Bapon pona jiwi pecʉbi bo beya. Baraxotiya Juan wisi ucuibatsi. ");
INSERT INTO cui_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Barapo soldadomonaepin matasipa carena paratontha. Bapon cata yabʉyotha. Barapowayo xuya pena cata. ");
INSERT INTO cui_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pomonae Juan pia pepuna jinompaewichi jume tane xua pinae Juan bexotsi. Barapoxonae barapomonae pona jiwi pecʉbi bo beya xua Juan pepichinexa tsainchi petʉpaein, yawano xua peboyaenexa tsainchi ibo wou mʉthʉ iya. ");
INSERT INTO cui_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Barapoxonae pirapae Jesús pia peitorobiwi tatsi, Jesús barʉ nacaetutatsi. Barapomonae Jesús tsipaebatsi xua daxita pocotsiwan barapomonae peexanaexae, yawano pocotsiwa xua bayatha barapomonae cuiduba. ");
INSERT INTO cui_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús pijimonae tsipaeba, jeye: —Anetha poinchi, xua wanafifina ewatsinexa tsainchi saya caeto ichaxota jiwaibi beya, jei Jesús. Daxota Jesús baxua paeba, tsipei pinmonae Jesús itata pateibatsi, xua poxonae naepanaya poneiba. Daxota Jesús irʉ pijimonae tatsi jopa itacʉpaetsi xua pexaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Barapoxonae Jesús, irʉ pijimonae tatsi compa ponarʉcʉpa jeratha ichawatha beya xua ichaxota jiwaibi beya. ");
INSERT INTO cui_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ichitha pin bicheitomonae tane poxonae Jesús irʉ pijimonae tatsi jeratha pona. Barapo pin bicheitomonae Jesusbarʉ yaitainchi. Barapo pin bicheitomonae daxita tomaran wecuinaeyiya. Bapoxonae pata ichaxota jiwaibi beya. Barapomonae tsiwanaya patatsi Jesús. ");
INSERT INTO cui_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Poxonae Jesús jera wenontouna bapoxonae Jesús tane pin bicheito. Jesús yabara najʉntʉ coyene xeina xua barapomonae peyawenaenexatsi. Barapomonae jopa xeinaeyo pon peyawenaein barapomonaetha icha be oveja ichi poxonae jopa xeinaeyo pon peyapu eenaein. Daxota Jesús barapomonaetha cuiduba ainya coyenein. ");
INSERT INTO cui_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Poxonae tabopiya tsanaichaba Jesús pijimonae itata patatsi, jeye Jesustha: —Bayatha tabopiya tsanaicha. Xote apara bon ajibi xua ichaxota jiwi jinompa. ");
INSERT INTO cui_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Barapomonae itorobare ichaxota po bon pipatotha umena yawa ichaxota xua tomaranxitha xua imoxoyo wacuariya xua barapomonae pecomocaewa pexaewa. Tsipei xote pexaewa ajibi, jei pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ichitha Jesús pijimonae barai, jeye: —Paxam jame moya paapare pexaewa, jei. Barapomonae jeye: —¿Xam ichichipame xua pata ʉpain comocaewa tsane barapo bicheitomonae ainya panmonaein xua pata comocaenexa doscientos po paratiximonaebetha pocotsi paratiximonaebe xeineiba pomonae nacuiteiba doscientos matacabibetha? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús barai pijimonae, jeye: —Pan ¿eta xoyobe paxeiname? Incane matha pataema, jei. Poxonae barapomonae yaputane jeye Jesustha: —Cinco po panyobe, yawa dos poyobe duweiyobe, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús pijimonae najume caruta xua bepa daxita barapo bicheito iratha taenaetsei naepanaewatha xua pepa bicheiton tsana naexana tsiniya. ");
INSERT INTO cui_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Barapo pin bicheito pepa bicheito naexana tsiniya. Icha bicheito cien poyobe tsiniya. Icha bicheito cincuenta poyobe tsiniya. ");
INSERT INTO cui_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Barapoxonae Jesús pecobetha pita pan cinco po panyobe. Yawa pita duweiyobe xua dos poyobe. Bapoxonae Jesús peitaboco benecoicha, Nacomtha tsipaeba jeye: “Axa maisa jʉntʉ coyene weiweinan, xua pexaewa pata tanecatsiwaxaem”, jei Jesús. Barapoxonae Jesús epa janaxuba pan. Jesús pijimonae cata barapo pan, xua pijimonae tatsi xuya pecatsibaponaenexa barapo pin bicheitotha. Barichi Jesús duweiyobe epa janaxubabe. Bapoxonae apata barapo pin bicheitotha. ");
INSERT INTO cui_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Barapo pin bicheito bara daxita nabane. Bara jain cowʉntarʉcʉpatsi. ");
INSERT INTO cui_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Barapoxonae Jesús pijimonae tatsi doce po cotebe wʉmba xua nacopaba xua bayatha barapo jiwi jopa xaeyo petonsanaexae. ");
INSERT INTO cui_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pomonae xua barapo pan pexaexae barapomonae cinco mil pebiwimonae. ");
INSERT INTO cui_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pirapae Jesús pijimonae itoroba xua peponaenexa jeratha, xua icha muxunene beya. Barapomonae Jesús tsiwana payatsi Betsaida tomara beya. Barapoxonae Jesús napeyaba barapo pin bicheito. ");
INSERT INTO cui_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Poxonae Jesús napeyaba barapo pin bicheito, bapoxonae Jesús pona demxuwatheicha xua petsipaebinexa Nacomtha. ");
INSERT INTO cui_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Poxonae bayatha quirei tsanaicha, bapoxonae Jesús pijimonae tatsi irʉ jeratha tuwʉtha yanapona. Jesús irʉ compa pecaetha popona. ");
INSERT INTO cui_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús tane xua barapomonae bichocono daunweya nowaeta tsipei dawerena bichocono joibo daunwei. Poxonae mataqueiwʉnaeyo tsoponae, Jesús pijimonae imoxoyo caquita pona. Bapon mene matatsun jumatha pona. Jesús juntucuru xenta iya barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Poxonae Jesús pijimonae tainchi xua mene matatsun jumatha pona, barapomonae itaraerowiya nanta xeina, xua Jesús itara mexeya dowatsiwejei. Yawa barapomonae wawai. ");
INSERT INTO cui_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Daxota barapomonae bichocono wawai, tsipei daxita barapomonae tane, yawa bichocono cuitaya junuwa. Ichitha Jesús barai barapomonae, jeye: —¡Apara xan! ¡Jopa pajunuwinde! ¡Maisa pajʉntʉ coyene weiweinare! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bapoxonae Jesús jeratha nontabiya barapomonae pia xantha tatsi. Barapoxonae joibo caewanaya exana. Barapomonae bichocono najʉntʉ coyene cabenaeca. ");
INSERT INTO cui_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Barapomonae baxua exana, tsipei barapomonae cataunxuae jopa yaputaeyo xua apara Jesús pon Nacom itoroba. Bequein bapon pexeinya petsita itʉtsi coyenewa exana poxonae apata pan pin bicheitomonaetha, barapomonae jopa beyaputaeyo pia jʉntʉ coyenewantha. ");
INSERT INTO cui_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús, irʉ pijimonae tatsi bara pitapa berubenathopiya xua pucua weya. Genesaret nacuatha pata. Baxota jera quetanota pitapatha. ");
INSERT INTO cui_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Poxonae Jesús jera wenontouna, bapoxonae caena nainya pinmonae Jesús yaitaerʉcʉpatsi. ");
INSERT INTO cui_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Bapoxonae barapo jiwi bara wecuinaeyiya daxita barapo ira weya. Mataʉtano carendena pocotsiwa pemaichiwatha pomonae atenemonae, Jesús pia xainya betacayiyatsi. ");
INSERT INTO cui_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Daxitantha ichaxota Jesús ponaena, ichaxota bequein tsica tomaraxi, ichaxotano bequein pin tomaran, ichaxotano bequein tomaran cuariya, daxita barapomonae capona peatenewimonae. Barapo peatenewimonae jebatsi namtontha. Barapomonae Jesús wʉcatsi xua Jesús petajayabinexatsi pia paparuwa peopirato tatsi. Daxita pomonae Jesús pia paparuwa tajayabatsi daxita barapomonae axaibi tsʉrʉcʉpeibi. ");
INSERT INTO cui_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nexata fariseomonae, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi xua pomonae Jerusalén tomara werendena, daxita barapomonae Jesús imoxoyo caquita poinchi. ");
INSERT INTO cui_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Barapomonae tane xua Jesús pijimonae tatsi jiwana najʉntʉ coyene taxoba xuano xua daxota Nacom tsita natsicuentatsi abe peexanaexae poxoru jopa matha nacobe quiatsiyo poxonae xane. Daxota barapomonae nanta xeina xua Jesús pijimonae tatsi pomonae peantʉcuiruyapube jiwi. ");
INSERT INTO cui_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Barapomonae aichaxaibi xua Jesús pijimonae tatsi jopa matha nacobe quiatsiyo poxonae xane, tsipei fariseomonae irʉ daxita judiomonae jopa daichiyo. Barapomonae pia cui xeina xua jopa xaibiyo poxonae jopa matha tsiwanaya daunweya nacobe quiateibiyo. Barapomonae barapo cui coyene exana xua po cui coyene pia pamo susato jiwi tatsi copiya cananta forota. ");
INSERT INTO cui_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Poxonae barapomonae caibe nawibeibarena ichaxota po bon xua pexaewa pecaenaetsiwan weya, bapoxonae copiya tsiwanaya merantha naperʉ tsicababeiba xua poxonae xane. Barichi barapomonae icha coyeneinno exanapona xua peitorobi coyenewantha itoroba xua poxonae corotixi itapa quiata, yawano corotonno xua caseta itapa quiata yawano paraton po paraton pecaxae paraton itapa quiata yawa caman.) ");
INSERT INTO cui_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bapoxonae fariseomonae, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, jeye Jesustha: —¿Eta xua metha jinya jiwimonae jopa exanaeyo xua pocotsiwa wamo susato jiwi pia peitorobi cui coyenewatha itoroba xua penajʉntʉ coyene taxobiyainwa? Jinyamonae barapo cui jopa exanaeyo xua jopa matha tsiwanaya nacobe quiateibiyo poxonae beya xaiba. Daxota jinyamonae pomonae peantʉcuiruyapube jiwi xua penajʉntʉ coyene taxobixae, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús jume nota barapomonae, jeye: —Bara Isaías pon Nacom peitorobi jume pepaebin beta xaniwaicha paca yabara paeba xua paxam pomonae itara mexeya xanepanaeya pepaebi jiwi pam, daichitha apara abeya peexanae jiwi pam. Bapon paca yabara tinaeya jeye, xua Nacom paeba: ‘Barapomonae neyabara barʉ cui itura jina poxonae cueicueijei tsaibi, ichitha pejʉntʉ coyenewantha jopa neantobeyo. ");
INSERT INTO cui_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pocotsiwa poxonae barapomonae wʉnae nejainta saya pejume pawi. Po pecuidubiwa xua barapomonae cuiduba jiwitha saya apara jiwi pia peitorobi coyenewa tatsi’, jei Nacom xua Isaías tatina Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Equeicha Jesús jeye barapo fariseomonaetha irʉ pomonaetha pomonae pecuidubiwi Moisés pia peitorobi coyene tatsi: —Saya paxam panaitematame pocotsiwa Nacom pia peitorobi coyenewa tatsi painya exanaenexa po peitorobi coyenewa painya amo susato jiwi copiya canamata forota. Paxam baxua paexaname poxonae jiwi paitorobame xua jiwi matha penacobe quiateibinexa poxonae xaiba penajʉntʉ coyene taxobiyainwa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Equeicha Jesús barapomonaetha jeye: —Itapetsiya painya neexanaenexa pocotsiwa painya amo susato jiwi pia peitorobi coyenewatha itoroba, daxota bichoina pajume itawetame Nacom pia peitorobi coyenewa tatsi. ");
INSERT INTO cui_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Bayatha Moisés pia peitorobi coyenewatha itoroba, jeye: ‘Axa barʉ cui itura jinare, irʉ ena barʉ cui itura jinare’, jei. Equeicha bapon Moisés jeye: ‘Pon abe yabara paeba paxa, xua jopa peyawenaewa paxa ichacuitha tsipae xua penatha, bara bapon bewa tʉpaena’, jei Moisés. ");
INSERT INTO cui_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ichitha paxam papaebame, xua pinae pebin bara itacʉpatsi xua paxatha tsipaeba, ichacuitha xua penatha xua jeye: ‘Jopa neitacʉpaeyo xua tapaca cayawenaewatsi, tsipei daxita pocotsiwa xeinan xua bequein pocotsiwatha tapaca cayawenaewatsi tsainchi baxuan daxita Nacomtha catan’, xua jei pebin. ");
INSERT INTO cui_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Poxonae pebʉrʉya payabara nanta xeiname xua bapon baxua paeba, bapoxonae bara pacopatame xua barapo pebin jopa penantawenonaewa xua peyawenaewa paxatha, irʉrʉ xua penatha. ");
INSERT INTO cui_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Poxonae paexanaponame pocotsiwa painya amo susato jiwi pia peitorobi coyenewatha itoroba, xuano xua ichamonae pacana exaname xua baxua irʉ exana bapoxonae paxam Nacom pia peitorobi jume pecui pawi jume pacana exaname. Barichi ichawanno xua be jʉpa xua peabe coyenein paexanameno, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Equeicha Jesús waba barapo bicheito pia xainya berena, jeye: —Daxita paxam pana nejume taema yawa pana nejume copi yaputaema pocotsiwa paca tsipaebinchi. ");
INSERT INTO cui_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pocotsiwa ba pebin pecoiboto deca tsijain jojonecatsi pexaewan, barapo coyene apara ba jopa bapana pebin antʉcuiruyapube exanaetsi xua poxonae pocotsiwa peexanaexae. Jame pocotsiwa ba pebin nanta xeina xua pecoibototha caunuta xua peabe jume, barapo jume coyenewatha jame pebin antʉcuiruyapube exanatsi xua poxonae pecueicueijeixae baxua. ");
INSERT INTO cui_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Icha pamuxu dubename, moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Poxonae Jesús jiwi cuenta pona yawa bo bejoniya, bapoxonae Jesús pijimonae yabara yainyabatsi barapo pecayabara jʉta pepaebi diwesiyo. ");
INSERT INTO cui_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Jesús jume nota pijimonae jeye: —¡Paxam bara paichim icha fariseomonae ichi! Jopa payabara yaputaem barapo pecayabara jʉta pepaebi diwesiyo xua pexaewa yabara. Bayatha paxam payaputaneme pocotsiwa pebin tsijain jojonecatsi pexaewa pecoiboto deca, barapo pexaewa jopa abe cana exanaeyo pebin pia jʉntʉ coyenewa. Barapo pexaewa pebin jopa antʉcuiruyapube exanaetsi. Barapo pexaewa jopa ponaeyo pia jʉntʉ coyenewatha. Jame barapo pexaewa pecotsorotha pona. Bapoxonae pexaewa aichurucuae nawexacaeca, jei Jesús. Poxonae Jesús baxua paeba jiwi yaputane xua daxita pexaewan bara wʉnae pexaenexa. Jopa jiwi antʉcuiruyapube exanaetsi. ");
INSERT INTO cui_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Equeicha Jesús namchi, jeye: —Pocotsiwa pebin pecoibototha caunuta xua peabe jume, barapo jume coyenewatha jame pebin antʉcuiruyapube exanatsi. ");
INSERT INTO cui_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Tsipei pejʉntʉ coyenewatha pebin nanta xeina, xua meje bapocotsiwanje: Abe penanta xeinae coyenewa, irʉ peita coxanae coyenewatsi coyenewa xua poxonae penayaputae jiwi naperʉ nacoyaba, irʉ ichʉn piawa tatsi pecaibi coyenewa, irʉ ichʉn anaya pebexotsi coyenewa, irʉ ichʉn piseuri tatsi pepichi coyenewa, irʉ ichʉn piawa tatsi peichichipae coyenewa, irʉ abe peexanae coyenewa, irʉ ichʉn pemuxuitorobiwatsi coyenewa, irʉ peyʉyʉjei coyenewa, irʉ peuwi coyenewa, irʉ ichʉn peyabara naerabiwatsi coyenewa, irʉ ichamonae peaebi coyenewatsi, irʉ jopa xainyeya peexanae coyenewa poxonae bequein yaputaetha xua jopa bewa exanae. ");
INSERT INTO cui_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Daxita barapo coyenein pejʉntʉ coyene weya jume pichapa. Barapo jume coyeneintha pebin antʉcuiruyapube exanatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Bapoxonae Jesús bara weya pona. Tiro tomara beya pona. Sidón tomara beya ponano. Jesús botha joniya. Bequein Jesús aichaxaibi xua jiwi yaputane ichaxota bapon eca, ichitha Jesús jopa itacʉpaetsi xua nameicha eca. ");
INSERT INTO cui_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Barapoxonae caena nainya petsiriwa jume tane xua Jesús botha eca. Barapowa pexantiyo tatsi cauri xeina. Daxota barapo petsiriwa patopa Jesustha. Yawa pentabocototha uncua Jesús peitabaratha tatsi xua bapowa petsita ainya cuixaetsi. ");
INSERT INTO cui_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Barapowa penanapaincha poponaewayo pecueicueijeixae griegojume. Jopa judiomonae jitowayiyo. Bapowa sirofeniciamonaewayo naexana penaexanaexae Fenicia tomaratha xua Siria nacuatha. Barapowa Jesús wʉcatsi jeye: —Taxantiyo inta taitawere cauri, jei barapowa. ");
INSERT INTO cui_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ichitha Jesús jume nota barapowatha pecayabara jʉta pepaebi diwesiyotha, jeye: —Jopa bewa ba auri apatsi pexaewa pocotsiwa pexui pia pexaewa tatsi. Baxua caunutsiya apara yabara paeban xua jopa bewa catsin tsane pomonaetha pomonae penanapaincha jinompaewi pomonae jopa judiomonae naexanaeyo xua pocotsiwa barompaya judiomonae piawa tatsi. Daxota jopa wʉnaeyo xua cayawenatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Barapowa jume nota Jesustha pecayabara jʉta pepaebi diwesiyotha, jeye: —Aa, bara barichi xuaunxuae netsipaebame ponxaem Tanecanamataxeinaem. Xainyei paebame. Jopa ba bewa auri catsibi pexui pia pexaewa tatsi. Daichitha auri ba xane pocotsiwa pexui sorobaba barapo pepʉrʉwixi pocotsiwa pexaethopaewa pebʉxʉpana tsica othopeica. Bara jʉtiya ichiya necana ichinde, daichitha neyawende, jei bapowa. ");
INSERT INTO cui_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Barapoxonae Jesús barai barapowatha, jeye: —Bara xaniwaicha paebame daxota cayawenatsi. Moya bara bara beya ponare. Bara bayatha nexantiyo wepu poinchi cauri, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Poxonae barapowa patopa pia botha, pexantiyo taebota xua camatha jʉntema boca. Mataʉtano tane xua bapowayo bayatha wepu poinchi cauri. ");
INSERT INTO cui_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Bapoxonae Jesús Tiro tomara weya pona, xua caibeya pona, ichaxota Sidón tomara iya pona. Mataʉtano ichaxota diez po tomaranbe iya pona po tomaran pewʉn Decápolis. Bapoxonae Galilea pucuatha patopa. ");
INSERT INTO cui_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Baraxotiya Jesús pia xainya berena tacapoinchi pebin pon muxusipana, mataʉtano xua jopa itacʉpaetsi xua pecueicueijeiwa. Pomonae pecarendenaexae bapon, barapomonae Jesús wʉcatsi, xua Jesús penta jayabiwa tsane xua bapon axaibi peexanaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Barapo pebin Jesús aisowa bebarʉ poinya pin bicheito pia xainya weya tatsi. Jesús pecobesitobetha nantiyabe muxu yauxatata. Poxonae naone sutaba peone pecobetha bapoxonae barapo cobetha ebato jayaba bapontha. ");
INSERT INTO cui_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Bapoxonae Jesús peitaboco benecoicha, yawa najumei cajujuina, yawano jeino bapontha: “¡Efata!” jeichichi, (xua jeichichi: “¡Muxu nasabare!” jeichichi.) ");
INSERT INTO cui_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bapoxonae caena nainya bapon muxu nasaba nantiyabe. Mataʉtano bara ebato xanepana. Mataʉtano bara itacʉpatsi xua pecueicueijeiwa beta. ");
INSERT INTO cui_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Bapoxonae Jesús barai barapomonae, jeye: “Jopa ichamonaetha pana neyabara paebinde pocotsiwa exanan”, jei Jesús. Bequein Jesús matowa tsipaeba baxua, daichitha barapomonae awiya baxua yabara paebeiba ichamonaetha beyacaincha xua Jesús jume matawenta. ");
INSERT INTO cui_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Barapomonae najʉntʉ coyene cabenaeca, yawa jeino: “¡Maisa barapon bichocono daxita coyeneya xanepana exana! Pomonae pemuxusipanaewi equeicha beta jume tane, yawa bara cueicueijei”, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Bapoxonae icha matacabitha pinmonae nacaetuta Jesús pia xantha tatsi. Jopa xeinaeyo pocotsiwa xua pexaewa tsane. Bapoxonae Jesús waba pijimonae, yawa jeye: ");
INSERT INTO cui_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Barapomonae yabara najʉntʉ coyene xeinan tayawenaenexa, tsipei barapomonae bayatha xote nebarʉ jinompa acoibi po matacabibe. Anoxuae jopa xeinaeyo xua pocotsiwa pexaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Icha barapomonae jainbotha pu itorobichipan pia bon beya, piyain namtotha xuirabathopaetsipa. Metha xuirabathopaetsipa tsipei ichamonae bayatha tajʉ werendena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jesús pijimonae jume notatsi, jeye: —Paxan jopa pana itacʉpaeyo xua barapomonae pexaewa pata apatsiwa, tsipei xote jiwaibi xua pata comocaenexa pexaewa, jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús yainyaba pijimonae, jeye: —¿Eta po panyobe paxeiname? jei. Jesús jume notatsi pijimonae, jeye: —Siete po panyobe paxeinan, jei. ");
INSERT INTO cui_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nexata Jesús pijimonae najume caruta xua bepa pinae barapo jiwi iratha taenaetsei. Jesús pecobetha pita barapo siete panyobe. Bapoxonae Nacomtha tsipaeba jeye: “Axa, maisa jʉntʉ coyene weiweinan xua pexaewa pata tanecatsiwaxaem”, jei Jesús. Bapoxonae Jesús pan epa janaquiya nacobe weta. Bapoxonae Jesús pijimonae catsibapona, xua pijimonae tatsi xuya pecatsibaponaenexa barapo bicheitotha. ");
INSERT INTO cui_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Barichino barapomonae be conotha xeina duweixi poxi tsiquirixi. Jesús Paxa tsipaeba jeye: “Axa, maisa jʉntʉ coyene weiweinan xua pata tanecatsiwaxaem duweixi”, jei Jesús. Poxonae Jesús epa janaca, bapoxonae pijimonae cobe itoroba xua pecatsibaponaenexa barapo bicheitotha. ");
INSERT INTO cui_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Daxita barapomonae bara xane. Daxita bara jain cowʉntarʉcʉpatsi. Pirapae awiya equeicha wʉmba siete po cotebe xua nacopaba pocotsiwa xua barapomonae bayatha jopa xaeyo petonsanaexae. ");
INSERT INTO cui_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Pomonae nabane pexaewa, barapomonae cuatro mil pebiwi. Bapoxonae Jesús pu itoroba barapomonae, xua penawibiyaenexa pia tomaran beya. Bapoxonae caena nainya Jesús, irʉ pijimonae tatsi, jeratha nonobabiya pewarapaenexa Dalmanuta nacua beya. ");
INSERT INTO cui_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bapoxonae fariseomonae pata Jesustha. Barapomonae tamropata notarʉcʉpa xua najume matsontsonoba exana Jesustha. Barapomonae Jesús pejʉntʉ coyene jʉjʉtsinexatsi, daxota Jesús piraichi cui itorobatsi pia petsita itʉtsi coyenewa pocotsi coyenewa xua cana exana itaboco wetsica. Barapomonae jopa bapon jume cowʉntsichi icha jopa itacʉpaetsi xua exana petsita itʉtsi coyenewa. ");
INSERT INTO cui_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús najumeicauna pejʉntʉ coyene weya poxoru barapomonae bapon amuxucoyenefaetabi exanatsi. Bapoxonae jeye: —¿Eta pocotsiwa metha barapomonae tapexeinya tsita itʉtsi coyenewa necui itoroba jane? Bara xainyeya paca tsipaebatsi jopa bapana beexanaeinyo baxua, xua barapomonae necui itoroba, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bapoxonae Jesús cuenta pona barapomonae jeratha, peponaenexa icha muxunene beya xua pucua iya. ");
INSERT INTO cui_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús pijimonae tatsi jʉntemaina xua capona pan. Meisa cae pan capona jeratha, po nae pin naetha. ");
INSERT INTO cui_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús itoroba pijimonae, jeye: —Dota pam, jopa pajume naitaewatsinde fariseomonae pia pecuidubi coyenewa tatsi xua painya nejume cowʉntsiyainwa. Mataʉtano dota pam, xua Herodes pia pecuidubi coyenewa tatsi xua painya nejume cowʉntsiyainwa. Barapo pecuidubi coyenewan jiwi ichawa beya ajʉntʉcuicoyeneyapube cana exanapoinchi icha be pocotsi coyene ichi xua levadura matawʉn xua pan cocotowa exanapona beya poxonae pin pan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jesús pijimonae tatsi tamropata notarʉcʉpa xua caemonae natsipaeba, najei: “Metha apara poxoru jʉntemainatsi xua caponatsi po pan xua levadura cotowa exana, daxota metha baxua Jesús jʉntʉ coniquiya naca muxu tsipaeba”, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús yaputane pocotsiwa pijimonae tatsi natsipaeba. Ichitha poxoru Jesús yabara paeba xua fariseomonae irʉ Herodes pia pecuidubiwan tatsi daxota Jesús yainyaba piamonae: —¿Eta xua metha pana natsipaebame xua jopa painya necaponaexae pan? Baxua papaebame apara poxoru jopa pana nejume yabara cowʉntsim pocotsiwa paca cuidubatsi. Cataunxuae jopa pana necui yabara yaputaem poxoru jopa paichichipaem xua painya neyaputaewa tsane painya jʉntʉ coyeneintha. ");
INSERT INTO cui_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Paxam bequein pana necui taneme, ichitha jopa xaniwaicha pana necui yaputaem. Mataʉtano bequein bara pana nejume taneme ichitha jopa xaniwaicha pana nejume copi yaputaem. Mataʉtano pajʉntemainame poxonae pexeinya petsita itʉtsi coyenewa exanan jiwi nexa poxonae pan catan jiwitha. ");
INSERT INTO cui_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Poxonae janacan pan xua cinco po panbe xua cinco mil pebiwi nexa, ¿eta po cotethabe pawʉnbaponame xua pocotsiwa nacopaba? jei Jesús. Barapomonae Jesús jume notatsi, jeye: —Doce po cotebe apara, jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Poxonae janacan pan xua siete po panbe xua cuatro mil jiwi nexa, ¿eta po cotethabe pawʉnbaponame xua pocotsiwa nacopaba? jei Jesús. Barapomonae Jesús jume notatsi jeye: —Siete po cotebe apara, jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nexata Jesús pijimonae barai xua muxu jei: —Metha matapainya payaputaename xua apara jopa yabara paca tsipaebichi pan. Apara jame paca tsipaebatsi xua jopa bewa pajume cowʉntsim tsane fariseomonae irʉ Herodes pia pecuidubiwan tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesús pijimonae barʉ botouna jeratha Betsaida tomaratha. Barapo tomarapiwi jiwana carendena pon peitata nacʉtsin, Jesús pia xantha tatsi. Barapomonae Jesús wʉcatsi, xua bapon pemata jayabinexatsi xuano xua axaibi peexanaenexatsi. ");
INSERT INTO cui_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús cobe pita pon peitata nacʉtsin. Bapon cobe capoinchi aisowa beya xua tomara weya. Bapoxonae Jesús naone sutaba bapon peitamaiqueitobetha, itacuere jayabano. Jesús bapon yainyaba jeye: —¿Bara caitacʉpa xua netaewa? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bapon necotaxuba, bapoxonae Jesús jume notatsi, jeye: —Pebiwi tan, daichitha itanonojan. Jiwi saya be naewan jinompa, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Equeicha Jesús pecobetha itamaiquei jayaba nantiyabe. Barapo pebin daunweya naitata babatsiya tane. Bapoxonae itamaiquei xanepana. Bapon bara beta matapainya wʉnae tane. ");
INSERT INTO cui_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús itorobiya jeye bapon xua penawiyaenexa pia bo beya: —Jopa tomaratha ponaeinde xua jopa baxua taneyabara cueicueijeinexa jiwitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Bapoxonae Jesús, irʉ pijimonae tatsi pata tsiqui tomaraxitha, po tomaraxi pewʉn Cesarea de Filipo. Poxonae namtotha cataunxuae enapona, bapoxonae Jesús pijimonae yainyaba, jeye: —¿Eta jiwi neyabara jei po coyene xua xan bapon aparan? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Barapomonae Jesús jume notatsi, jeye: —Ichamonae cayabara jei: ‘Apara bapon Juan, pon jiwi Pebautisabin pon equeicha petʉpaein asʉ juina’, jei. Irʉ ichamonae cayabara jei: ‘Apara bapon Elías, pon equeicha petʉpaein asʉ juina’, jei. Irʉrʉ ichamonae cayabara jei: ‘Apara bapon jiwana, pomonae Nacom peitorobi jume pepaebiwi’, jei, jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Bapoxonae Jesús pijimonae yainyaba, jeye: —¿Incane irʉ paxamdʉ? ¿Eta paneyabara jumichimdʉ xua xan eta pondʉn? jei Jesús. Bapoxonae Pedro, Jesús jume notatsi, jeye: —Xam apara Mesías, pon Nacom caitorobica, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús pijimonae muxu barai xua pijimonae jopa peyabara paebinexatsi ichamonaetha baxua. ");
INSERT INTO cui_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Bapoxonae Jesús tamropata pitaba xua pijimonae tsipaeba pocotsi coyene xua Jesús cana exanaeinchi ichamonae, Jesús jeye: “Xan ponxaein Nacom Tananeitapetsin jiwi bichocono neperaxa jʉbina. Mataʉtano pitiri jiwi, irʉrʉ sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, daxita barapomonae neitawetsina. Mataʉtano barapomonae nebexubina. Ichitha equeicha asʉ poponaein poxonae acoibi po matacabiyobe tsuxubi tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Baxua Jesús pijimonae wʉnaeya muxu tsipaeba xua barapomonae bara xaniwaicha peyaputaenexa. Bapoxonae Pedro, Jesús compa aisowa bebarʉ poinyatsi, Pedro Jesús jume daunweya tsipaebatsi xua Jesús jopa pepaebinexa baxua. ");
INSERT INTO cui_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesús pijimonae napatomeicha necota. Bapoxonae jume daunweya jeye Pedrotha: —¡Xam be pon caurimonae pia pentacaponaein tatsim! Bara newepu ponare, tsipei xam jopa beta nanta xeinaem icha be jopa Nacom ichim poxonae xua beta nanta xeina. Saya xam nanta xeiname icha jiwi ichi poxonae nanta xeina, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bapoxonae Jesús waba pin bicheito, mataʉtano wabano pijimonae, yawa jeye daxita barapomonaetha: —Icha pebin ichichipa xua tajiwimonae jiwanapin penaexanaewa tsane, bewa bapon yabara naitematsi pocotsiwa xua bapon ichichipa pia peexanae coyenewan tatsi. Bapoxonae jame bapon bewa eexanaponae pocotsiwa itoroban, bequein bara bapon bexotsi ichamonae, tajiwimonae jitonxae. ");
INSERT INTO cui_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pon naantobeya nata exana pocotsiwa bapon ichichipa, bapon jopa xeinaeyo peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. Ichitha pon neantobeya inta exana pocotsiwa ichichipan tana neantobexae xuano xua pecueicueijeixae Nacom Pejume Diwesi, bapon xeinaena peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. ");
INSERT INTO cui_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Icha pebin bichocono copei xeina pocotsiwa xeina po cae pin nacuathe, ichitha jopa xeinaeyo peajʉntʉcoyenesʉwa po peajʉntʉcoyenesʉwa ataya tsiteca, bapoxonae bapon jopa itacʉpaetsi xua penajʉntʉ coyene capanepaewa xua peweraweracaewa tsane. ");
INSERT INTO cui_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tsipei pebin jopa itacʉpaetsi xua barapo copeitha Nacom pematomatsiwatsi, xua bapon pecatsinexa tsainchi peajʉntʉcoyenesʉwa xua barapoxonae pepatopaewa tsane Nacom pia nacua beicha tatsi. ");
INSERT INTO cui_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Icha ichʉn neacaura, yawa nejume diwesi acaurano jiwi peitabaratha tatsi, pomonaetha pomonae jopa tana nejume cowʉntsi jiwi, pomonaethano pomonae bichocono abe peexanaewi, xan xuya barichin tsane. Xan ponxaein Nacom Tananeitapetsin, bapon xuya acauran tsane. Baxua exanaein poxonae patopaetsicaein be jiwi pia Pecanamataxeinaein tatsi yaitʉpanae susato patopaetsicaein. Taxa pia peitʉpanaewa tatsi yawa patopeicaein. Mataʉtano Taxa pia matatsunpiwi tatsi nebarʉ patsicaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Barichino Jesús jeye: —Bara xaniwaicha paca tsipaebatsi xua pomonae xote umene barapomonae jiwana abʉ copiya matha yabara yaputaena xua po coyene Nacom waba jiwi xua petanaexanaenexatsi piamonae pomonae itorobiya taewatsixae taayapusʉwatha. Bapoxonae barapomonae werapaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Poxonae seis po matacabibe jopa, xua Jesús paeba baxua bapoxonae pirapae Jesús barʉ pona Pedro, irʉ Santiago irʉ Juan. Barapoyobe Jesús compa barʉ pona demxuwatheicha po demxuwa bichocono taʉcha. Baxoteicha barapoyobe peitʉtha tatsi, Jesús pexeinya itʉpanae coicha tsanaya. ");
INSERT INTO cui_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pocotsiwa Jesús pia penama xatatsiwa bichocono daedaena, yawa bichocono inyapana, beyacaincha poxonae jiwi bichocono paparuwa matanaca xua inyapana exana. ");
INSERT INTO cui_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Bapoxonae Pedro, irʉ Santiago irʉ Juan Elías taerʉcʉpatsi, irʉ Moisés ponbe caena bayatha naxubabe. Baponbe Jesús barʉ cueicueijeichibe. ");
INSERT INTO cui_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bapoxonae Pedro namchi, jeye Jesustha: —Pon jiwi Necuidubim maisa wʉnae xua xote pata umenaewa. Pacata acabinchi acoibi po boutiyobe, cae bouto xam nexa, icha bouto Moisés nexa, icha bouto Elías nexa, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro baxua paeba, bequein jopa yaputaeyo pocotsiwa yabara cueicueijei, tsipei poxoru saya barapomonae bichocono pijunuwi. ");
INSERT INTO cui_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bapoxonae daxita barapomonae pia xainya bematawacaicha taruneicatsi tsaquinaebowa. Barapo tsaquinaebowatha pejume jume tane, xua Nacom Jesús yabara cueicueijeichi, jeye: “Bapon apara Taxanto pon bichocono antobein pon itapetan. Bapon beta pajume taema pocotsiwa paca tsipaeba”, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Barapoxonae caena nainya poxonae necobarʉcʉpa barapomonae, baponbe jopa taetsi, meisa saya Jesús compa uncua. ");
INSERT INTO cui_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Poxonae Jesús pijimonae barʉ juinca demxuwa wetsica, bapoxonae Jesús tsipaeba barapo acoibi poyobe, jeye: “Ichamonaetha jopa yabara patsipaebinde pocotsiwa xuaunxuae pataneme xua tapaca catsita exanaewatsi. Jopa payabara paebinde beya abʉ poxonae equeicha asʉn poponaein tatʉpae coyene weya, xan ponxaein Nacom Tananeitapetsin”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Daxota barapoyobe jopa yabara paebiyo ichamonaetha xua tane. Saya barapoyobe pia coutha namicha natsipaebabe najeibe: “¿Eta xua metha baraxuara xua Jesús paeba xua pinae petʉpae coyene weya asʉ tsane?” najeibe. ");
INSERT INTO cui_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Barapoxonae barapo acoibi poyobe Jesús yainyabatsi, jeibe: —Pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, ¿eta xua metha bapomonae paeba xua pinae bewa copiya patopaena Elías, xua pinae beya poxonae patopaena Mesías? jei barapoyobe. ");
INSERT INTO cui_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús barapoyobe jume notatsi, jeye: —Bara xainyei, Nacom Pejume Diwesitha paeba xua pon be Elías copiya netsiwana patopaena. Mataʉtano paeba xua bapon cana nantʉ coyene weta exanaena jiwi pia jʉntʉ coyenewantha xua jiwi pejume cowʉntsinexa Nacom. Mataʉtano barapo Nacom Pejume Diwesitha paeba xua xan ponxaein Nacom Tananeitapetsin ichamonae neperaxa jʉbina. Mataʉtano bichocono abeya neyabara paebina. ");
INSERT INTO cui_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ichitha nama xan paca tsipaebatsi xua pon be Elías bayatha apara patopa. Bapontha abeya cana exanatsi ichamonae, icha be pocotsiwa barapomonae ichichipa xua bapon pecana exanaewatsi. Bayatha baxua Nacom Pejume Diwesitha peyabara tsiwʉnae muxu dutsixae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Bapoxonae pirapaeyo barapo acoibi poyobe Jesús barʉ nawiya ichaxota ichamonae pijimonae tatsi tajinompatsi. Bapoxonae barapomonae tane xua Jesús pijimonae tatsi pomonae baxota petajinompaewixaetsi barʉ nacaetutatsi pin bicheito. Irʉ baxota naena pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Barapo pecuidubiwi Jesús pijimonae tatsi jume matsontsonobatsi. ");
INSERT INTO cui_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Barapo pin bicheito najʉntʉ coyene nabenaeca poxonae Jesús taerʉcʉpatsi. Bapoxonae barapo pin bicheito caena nainya Jesús pexainya betacuinaeyiyatsi xua Jesús pejacobinexatsi. ");
INSERT INTO cui_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Bapoxonae Jesús yainyaba barapo pin bicheito, jeye: —¿Eta pocotsiwa metha tajiwimonae pajume matsontsonobame? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Caein pon uncua baxota, bapon Jesús jume notatsi, jeye: —Pon jiwi Pecuidubim, xote nexantha cata caponatsi taxanto. Bapon taxanto cauri xeina, xua daxota inta muxusipana exanatsi. ");
INSERT INTO cui_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Poxonae taxanto taibatsi cauri, inta iratha bebai tsaibichi. Bapoxonae inta coibo thamthamei exaneibatsi. Mataʉtano inta nawano xane exanatsi. Daxota inta cuenecuenona. Bequein wʉcan jinyamonae, janje: ‘Painta taxanto taitawere cauri’, jan, daichitha jopa itacʉpaetsi xua inta taxanto petaitawetsinexatsi cauri, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Bapoxonae Jesús anaya barai pijimonae, jeye: —¡Paxam barapomonae pam, pomonae jopa xapain cataunxuae pana nejume cowʉntsim! ¿Eta po weibe nantawenonan xua bewa tapaca barʉ ecaewatsi tsainchi xua beya poxonae tapana nejume cowʉntsiwam tsane? Mataʉtano ¿eta po weibe equeicha nantawenonan xua tapaca cayawenaewatsi tsainchi? Pon cauri xeina painta barʉ awena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bapoxonae Jesús pexantha tacapoinchi barapo pewowin. Poxonae Jesús tainchi cauri, bapoxonae pewowin naichababa exanatsi. Barapo pewowin bapoxonae iratha xotsi. Yawa iratha natorenababa exanatsi. Yawa coibo thamthamei exanatsi. ");
INSERT INTO cui_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pexuyo paxa tatsi, Jesús yainyaba, jeye: —¿Eta po weiyobe barapo pewowin xeina baxua xua cauri xeina? jei. Barapon Jesús jume notatsi, jeye: —Caena bayatha baxua xeina poxonae pexuyo tsecae. ");
INSERT INTO cui_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Matowa cauri inta taxanto isototha bebai tsaibichi. Mataʉtano inta mentha bebai tsaibichi pebexubinexatsi. Icha caitacʉpa xua neexanaewa tsane baxua, pana yabara najʉntʉ coyene xeinare jinya tapana neyawenaenexam tsane, jei pexuyo paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús jume nota bapon, jeye: —¿Eta pocotsiwa metha barapo jumetha netsipaebame xua tana neitacʉpaewa yabara? Tsipei ponba jume cowʉnta bara Nacom yawena xua peitacʉpaewatsi xua daxitantha beta cana exana, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bapoxonae pexuyo paxa tatsi jume daunweya wawaya jeye: —Bara cajume cowʉntatsi. Neyawende xua equeicha bichocono matowa tacajume cowʉntsinexa tsainchi, jei pexuyo paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Poxonae Jesús tane xua pin bicheito imoxoyo nacaetutapona, bapoxonae Jesús itaweta cauri, jeye: —Xam caurim pom muxusipana exaname jiwi, bara caitawetatsi. Bara xubiriware barapo pewowin. Equeicha bapana jopa caewa patopaeinde bapontha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Bapoxonae cauri pewowin papai exanatsi. Yawano naichababa exanatsi. Barapo cauri pewowin cuenta poinchi, barapoxonae barapo pewowin be petʉpaeyo boca iratha. Daxota daxita barapo pin bicheito paeba xua pinae barapo pewowin apara tʉpa. ");
INSERT INTO cui_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Barapo pewowin Jesús cobe pita, yawano asiya cuaranota. Bapoxonae barapo pewowin nantacotuncuataba. ");
INSERT INTO cui_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Bapoxonae Jesús joniya botha. Jesús pijimonae compa seicaya tsipaebatsi, jeichichi: —¿Eta pocotsiwa metha jopa pana neitacʉpaeyo xua pata taitawetsiwa cauri? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús pijimonae jume nota, jeye: —Barapocotsimonae caurimonae paca itacʉpa xua painya neitawetsiwa saya meisa poxonae memecabiya matowa pawʉcame Nacomtha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Poxonae Jesús, irʉ pijimonae tatsi bara weya pona, bapoxonae Galilea nacua iya pona. Bapon jopa beyaputaetsi xua ichaxota ponaena, xua ichamonae yaputaena. ");
INSERT INTO cui_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Baxua Jesús exana, tsipei pijimonae cuiduba. Jesús barai pijimonae xua nayabara paeba, jeye: —Xan ponxaein Nacom Tananeitapetsin jiwi necaenaetsina ichamonaetha. Yawano nebexubina. Ichitha poxonae acoibi po matacabibe yapucaewina, bapoxonae equeicha asʉ poponaein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ichitha barapomonae pomonae Jesús pijimonae jopa jume yaputaetsi xua Jesús yabara paeba. Mataʉtano barapomonae junuwa xua Jesús peyabara yainyabiwa tsainchi barapo jume. ");
INSERT INTO cui_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesús pijimonae barʉ patopa Capernaum tomaratha. Poxonae Jesús pijimonae botha barʉ patopa, bapoxonae pijimonae yainyaba, jeye: —¿Eta xua namtotha pana najume matsontsonobaponame? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Barapomonae saya moya umena peauraxae, tsipei namtotha najume matsontsonobapona xua po coyene metha jintam ainya cui peexanaewatsi tsainchi pon barapomonae jiwanaxae. ");
INSERT INTO cui_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nexata poxonae Jesús eca, bapoxonae pijimonae waba, pomonae doce poyobe, yawa jeye: —Pon ichichipa xua ichamonae ainya cui petsita naexanaewatsi, bapon bewa pia coutha pecui pawi jiton naexanae petanacuichinexa ichamonae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bapoxonae Jesús pita pexuyo, yawa pijimonae tatsi peitabarayo deca tatsi tacuaranoreca. Jesús isaeca barapo pexuyo, jeye: ");
INSERT INTO cui_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pon matenta weyataeya waba peyawenaenexa pontha pon tana nejume cowʉntsixae xua pocotsin icha be barapocotsi pexuyo ichi, barapon apara bara nententa weyataeya waba. Xan jopa meisa nententa weyataeya wabiyo, apara bara irʉ matenta weyataeya wabatsi pon tana neitorobixae xua pon bara Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nexata Juan namchi Jesustha, jeye: —Ja Tanecuidubim, paxan caein patan pon cawʉn taiba poxonae itaweta caurimonae, xua caurimonae itawetatsi. Paxan baxua pacui itawetan, tsipei jopa naca puna poponaeyo, jei Juan. ");
INSERT INTO cui_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ichitha Jesús Juan jume notatsi, jeye: —Bapon baxua jopa pacui itawetsinde, tsipei dapon aibi pon pexeinya petsita itʉtsi coyenewan exana poxonae newʉn taiba xua bapoxonae cotacaya abeya neyabara paeba. ");
INSERT INTO cui_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tsipei pon abe jopa nacata exanaeyo, bapon apara naca yawena. ");
INSERT INTO cui_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pon paca yawena xua mera paca cata xua bequein tsica corotiyotha xua irʉ pejume cowʉntsixae, xua xan Criston tajiwimonae pamxaem, baxua peexanaexae, Nacom catsina bapontha pematomatsiwa baxua nexa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Equeicha Jesús namchi, jeye: “Nacom tsitatsi xua pebin bichocono abe exana poxonae natsicuenta ichʉn cana exanatsi xua abe peexanae cuiru coyene exana, po barapo ichʉn pon cataunxuae aena tana nejume cowʉntsixae. Metha jame wʉnae tsipae xua barapo pebin pon abeya cana exanaeya taexana ichʉntha, barapon pin iboto wisi cʉtsipatsi yawa xua tuwʉtha xua pin mar menetha barapo ibototha cayawa cabutabachipatsino. ");
INSERT INTO cui_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Icha painya cobe paca exana xua abe painya neexanaewa tsane, maisa panacobe ucubobare. Tsipei baxua xanepana xua cae cobexi pabebam tsane, xua saya cae cobexi painya neyawa patsiwa tsane Nacom pia nacua beicha tatsi. Baxua jame yatsicaya xanepana beyacaincha xua ainya cobebe painya necayawa bebaiwa tsane ichaxota po nacuatha isoto jopa itacounayiyo, xua ataya tsiteca. ");
INSERT INTO cui_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mataʉtano icha painya taxu paca exana xua abe painya neexanaewa tsane, maisa panataxu ucubobare. Tsipei baxua xanepana xua cae taxuxi pabebam tsane, xua cae taxuxi painya neyawa patsinexa Nacom pia nacua beicha tatsi. Baxua jame yatsicaewa xanepana beyacaincha xua ainya taxube painya necayawa bebaiwa tsane ichaxota po nacuatha isoto jopa itacounayiyo xua ataya tsiteca. ");
INSERT INTO cui_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mataʉtano icha pocotsiwa pataneme painya itamaiqueitotha xua icha baxua paca exana xua abe painya neexanaewa tsane, painya netaexae painya itamaiqueitotha, maisa pana naitacuere jucuare. Tsipei baxua xanepana xua cae itamaiqueitoxi pabebam tsane, xua cae itamaiqueitoxi painya neyawa patsiwa tsane Nacom pia peitorobi nacua beicha tatsi. Baxua jame yatsicaewa xanepana, beyacaincha xua poxonae ainya itamaiqueitobe painya necayawa bebaiwa tsane ichaxota isoto jopa itacounayiyo. ");
INSERT INTO cui_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Barapo nacuatha isoto jopa itacounayiyo xua ataya tsiteca yawa oro jopa tʉpaeyo. ");
INSERT INTO cui_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tsipei daxita jiwi pia pejʉntʉ coyenein tatsi nacui wʉnaetsina Nacom nexa pocotsi coyenewantha xua jiwi taayapubetsi bichocono xua jiwi atene exanatsi pocotsiwa icha be isoto ichi. Mataʉtano daxita pocotsiwan jiwi tauta xua petuxusi exanaewa Nacomtha, barapocotsiwa copiya yawa muxuna nacui xaxainchina sare beno. ");
INSERT INTO cui_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sare beno, bara bena wʉnae. Ichitha icha barapo sare beno jopa abenataeyo bapoxonae jopa peitacʉpaewatsi xua equeicha peabenataewa. Bara paichinde poxonae icha be sare beno ichi. Paxeinare pocotsi coyene pexeinya jʉntʉ coyene xua jopa po jʉntʉ coyene abeyo. Mataʉtano jʉntema nantiya pana nabarʉ jinompare”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús ponataba Capernaum tomara weya. Bapoxonae Judea nacuatha patopa. Yawa patopa Jordán mene iya icha muxunenetha, po muxunene xua Judea nacua weya. Baxotiya equeicha jiwi pin bicheitomonae nacaetuta ichaxota Jesús uncua. Equeicha Jesús cuiduba barapomonaetha, tsipei pia cui xua cuidubeiba. ");
INSERT INTO cui_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bapoxonae ichamonae fariseomonae, barapomonae piraichi Jesús imoxoyo caquita umenarʉcʉpatsi xua Jesús pejʉntʉ cui coyene jʉjʉtsinexatsi, daxota jeye: —¿Metha bara Moisés copata jampa xua pebin pepunaxubiwa piowa icha saya metha ichichipa jampa? jei. ");
INSERT INTO cui_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús jume epa pita barapomonae, jeye: —¿Eta xua bapon Moisés paca itoroba? jei. ");
INSERT INTO cui_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Barapomonae Jesús jume notatsi, jeye: —Moisés copata xua jiton itacʉpatsi xua pecatsiwa papera piseuri, po paperatha tina xua pexubiwa tsane piseuri. Bara bapoxonae bapon xubina piseuri, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Bapoxonae Jesús jume nota barapomonaetha, jeye: —Moisés paca cata barapo peitorobi coyenewa, tsipei paxam jopa bepajume cowʉntsim painya jʉntʉ coyenewatha. ");
INSERT INTO cui_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tsipei poxonae Nacom aena forota daxita, pejume diwesitha jeye: ‘Nacom exana pebin, mataʉtano exana yabʉyo’, jei. ");
INSERT INTO cui_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Equeicha Nacom jeye: ‘Daxota pebin paxa wepu natsata, yawa pena wepu natsata xua piowabe imoxoyo penaperʉ nacoyobinexabe. ");
INSERT INTO cui_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Baraponbe be cae jiwimonae naexanabe’, jei. Bapoxonae baponbe xua ainya jiwibe aibi, bara be caein naexanabe. ");
INSERT INTO cui_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Daxota pebin bapana jopa bewa punaxubi piowa. Tsipei apara bayatha Nacom cana exana xua bara be caein naexanabe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Poxonae Jesús, irʉ pijimonae tatsi botha jinompa, bapoxonae Jesús pijimonae yabara yainyabatsi baxua. ");
INSERT INTO cui_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Bapoxonae Jesús jume epa pita, jeye: —Pon punaxuba piowa, yawa ichowa pita, bapon abe exana piseuritha yawa Nacom peitʉtha tatsi, tsipei Nacom tsitatsi xua powa copiya barʉ popona, apara bara piowa tatsi. ");
INSERT INTO cui_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Barichi icha petsiriwa punaxuba pia pebin, yawa pita icha pebin, bapoxonae bapowa abe exana pia pebintha, yawa Nacom peitʉtha tatsi, tsipei Nacom tsitatsi xua pon copiya xeina, apara bara pia pebin tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nexata jiwi Jesús pexui tacaponatsi xua Jesús pejayabinexa pecobetha, yawa xua Nacomtha pewʉcaenexa barapo pexui nexa xua pejeinexa: “Barabʉ Nacom beta paca yawenaena”, pejeinexa. Ichitha Jesús pijimonae tatsi poxonae baxua tane, tamropata notarʉcʉpa xua barapomonae cui matawentatsi pomonae pexui carendena tsaibi. ");
INSERT INTO cui_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Poxonae Jesús baxua jume tane, jopa ichipaeyo pocotsiwa pijimonae tatsi paeba, daxota anaya jeye: —Bara pacopabare pexui xua tana itata patsinexa. Jopa pexui paitawetsinde, tsipei Nacom pia peitorobi nacua tatsi saya meisa barapomonae nexa pomonae pejʉntʉ coyene xanepanaewi icha pexui ichi. Pexui pia cui xua tayapu xanepanatsi xua pia jʉntʉ coyeneintha jume cowʉnta Nacom. ");
INSERT INTO cui_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Bara xainyeya paca tsipaebatsi. Pon jopa yabara jume cowʉntsiyo xua icha be jopa pexui ichiyo xua ba pexui tayapu xanepanatsi xua jume cowʉnta, bapon bapana jopa naexanae tsane Nacom pijimonae tatsi pomonae Nacom itorobiya ewata, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bapoxonae Jesús tsana tamropata nonotapona pexui, yawa pecobetha pexui jayabiya tawʉcatsi Nacom. Jeye: “Barabʉ Nacom beta yawenaena barapo pexui”, jei. ");
INSERT INTO cui_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Poxonae Jesús aena warapa, bapoxonae pebin Jesús pia xainya betacuinaerenatsi. Bapon pentabocototha uncua Jesús peitabaratha tatsi, xua pebarʉ cui itura jinaenexatsi Jesús, tsipei Jesús pon peainya cuin. Bapon jeye Jesustha: —Ja Tanecuidubim, maisa nejʉntʉ coyene xanepanaem. ¿Eta xua copiya matha exanocuaein xua ajʉntʉyapusʉya tapoponaewa tsane xua ataya tsane? jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Bapoxonae Jesús jume nota, jeye: —¿Eta xua nebaram: ‘Nejʉntʉ coyene xanepanaem’, jam? Apara ichʉn dapon aibi pon pejʉntʉ coyene xanepanaein. Jame meisa apara bapon Nacom compa pejʉntʉ coyene xanepanaein. ");
INSERT INTO cui_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Xam bara yaputaneme po coyene Moisés pia peitorobi coyenewatha itoroba, xua jeye: ‘Jopa ichʉn bexubinde. Jopa ichowa pichinde ichʉn piowa tatsi. Jopa caibinde ichʉn piawan tatsi. Jopa naerabiya cayabara paebinde pocotsiwa ichamonae exana. Jopa ichamonae yabara muxujainyabinde xua caibame. Axatha barʉ jume cui itura jinare. Mataʉtano enatha barʉ jume cui itura jinare’, jei Moisés, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pewowin Jesús jume baraichi, jeye: —Pon jiwi Necuidubim, daxita caena bayatha barapo coyenein exaneiban. Poxonae pexuyothan tamropata pitaban, beya anoxuae yacuiya pinyon, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús antobeya necota bapontha, jeye: —Cataunxuae icha cui coyene cata seica xua pocotsiwa neexanaewam tsane. Icha ichichipame xua jopa necata acoibiyo nexa tsane xua pocotsiwa xanepanaeya neexanaewa, matha daxita caenaere pocotsiwa xeiname, yawa catsibare pomonaetha pomonae peacopeibi jiwi. Bapoxonae jame moya anetha, nepuna ponde. Bequein bara bapoxonae acopeibim tsane, daichitha Nacom cacatsina peitaboco beicha pocotsiwa Nacom necajʉntana botsiwa pocotsiwa bichocono wʉnae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Poxonae barapo pewowin baxua jume taeba, bichocono nantanuweya pontaba, tsipei bichocono copei pexeinaein. ");
INSERT INTO cui_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Bapoxonae Jesús necota jiwi, yawa jeye pijimonaetha: —¡Maisa bichocono ayapubecai xua copei pexeinaewi naexana Nacom pijimonae tatsi jiwana pomonae itorobiya canamataxeina! Tsipei barapomonae bichocono antasiwayatane barapo pia copei, beyacaincha xua Nacom antobetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesús pijimonae tatsi yabara najʉntʉ coyene cabenaeca pocotsiwa xua Jesús paeba. Ichitha Jesús pijimonae equeicha tsipaeba, jeye: —Pomonae tamonae pamxaem, ¡maisa bichocono ayapubecai xua pomonae copei pexeinaewi jume cowʉntsina Nacom! Barapomonae nanta xeina xua pia copeitha nayawena xua daxota jopa canantawenonaeyo xua Nacom pejume cowʉntsiwatsi. ");
INSERT INTO cui_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Bichocono acuiruyapube xua duwein, pon pewʉn camello xua bapon pejoniyaewa acuicheto peetabʉ wan iya. Ichitha nama yatsicaewa pon bichocono copei pexeinaein taacuiruyapubetsi xua naexana Nacom pijimonae tatsi jiwana pomonae itorobiya canamataxeina beyacaincha xua poxonae acuiruyapube xua poxonae camello acuicheto peetabʉ wan iya pejoniyaewa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Poxonae Jesús pijimonae jume taerʉcʉpatsi xua paeba bapoxonae najʉntʉ coyene cabenaeca bichocono. Barapomonae caemonae nayainyaba, najei: —Bapoxonae ¿jintam metha nexata itacʉpatsi xua pecapanepaewa pia coutha? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús tane barapomonae, yawa jeye: —Pebiwi ba jopa itacʉpaetsi xua baxua exana, saya jame meisa Nacom compa itacʉpatsi xua jiwi napaeba cana exanatsi. Tsipei daxua ajibi pocotsiwa Nacom taacuiruyapubetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nexata Pedro Jesús jume notatsi, jeye: —Paxan daxita pacuenta ponan pocotsiwa paxeinan pata paca puna ponaewatsi tsainchi, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús Pedro jume notatsi, jeye: —Bara xainyeya paca tsipaebatsi. Nacom beta cana exanaena daxita pomonae pecueicueijeixae Nacom pia pecapanenebiyae diwesi yawa taneantobexae beyacaincha xua ichamonae antobetsi. Nacom beta cana exanaena barapomonae pia bon pecuenta ponaexae inta peexanaexae. Mataʉtano beta cana exanaena pomonae peweichowi pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae pamchowi pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae paxeiwi pecuenta ponaexae, mataʉtano peniwi pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae pia pexui yawa pia iran pecuenta ponaexae. ");
INSERT INTO cui_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nacom barapomonaetha catsina po irathe pentoma xua cien po cuiyobe tsane. Barapomonae xeinaena bon, mataʉtano nantaʉtsina peweichowi, irʉ pamchowi tatsi, irʉ peniwi tatsi, irʉ pia pexui tatsi, yawa iranno. Daxita barapomonaetha tsicotane be barompaya piamonae tatsi. Barapo cae pin nacuathe barapomonae peraxa jʉbinchi taneantobexae, daichitha barapomonae xeinaena Nacom pia peitorobi nacuatheicha peajʉntʉyapusʉwa po peajʉntʉyapusʉwa ataya tsiteca. ");
INSERT INTO cui_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pomonae xua anoxuae, pomonae jiwi petsita ainya cui jiwichi po cae pin nacuathe, barapomonae bexa Nacom pia peitorobi nacuatheicha jopa peainya cui jiwi tsane. Pomonae xua anoxuae pepawi naexana pomonae jiwi jopa petsita ainya cui jiwichi, po cae pin nacuathe, barapomonae Nacom pia peitorobi nacuatheicha peainya cui jiwi tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Poxonae Jesús pijimonae cataunxuae namtotha barʉ ecapona xua Jerusalén tomara beya, Jesús pijimonae tsiwana nantacapona. Bapoxonae Jesús pijimonae tatsi najʉntʉ coyene cabenaeca, tsipei Jesús nainya nantacapona. Irʉ pomonae Jesús puna poinchi yabara junuwa, tsipei yaputane xua Jesús abe cana exanaeinchi barapo tomarapiwi. Bapoxonae Jesús pijimonae compa waba aisowa beya xua pomonae doce poyobe tatsi. Jesús tamropata pitaba xua tsipaeba pijimonae xua pocotsiwa imoxoyo ichamonae Jesús cana exanaeinchi. ");
INSERT INTO cui_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús jeye pijimonaetha: “Anoxuae ponaeinchi Jerusalén tomara beya. Baxotiya xan ponxaein Nacom Tananeitapetsin, necaenaetsina ichamonae sacerdotemonae pia pentacaponaewitha tatsi, yawa pomonaetha pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Barapomonae itorobina xua nebexubina. Mataʉtano necana cobenatsina pomonaetha pomonae penanapaincha jinompaewi xua pomonae icha nacua werena peponaewi. ");
INSERT INTO cui_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Barapomonae necui caponaena, yawa necueinchinano. Mataʉtano yawa necana one subabina. Bapoxonae nebexubina. Daichitha poxonae acoibi po matacabibe weraweracaena equeicha asʉ poponaein petʉpae coyene weya”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Bapoxonae Santiago irʉ Juan ponbe Zebedeo pexantobe tatsi, baponbe Jesús imoxoyo caquita uncuatabatsibe, jeibe Jesustha: —Pon jiwi Necuidubim, paichichipan xua painta exanaename pocotsiwa paca wʉcaeinchi, jei. ");
INSERT INTO cui_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nexata Jesús yainyaba baponbetha, jeye: —¿Eta pocotsiwa paichichipamebe xua pacata exanaeinchibe? jei. ");
INSERT INTO cui_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Baponbe Jesús jume notatsi, jeye: —Matacabi jopaena, po mataqueitha itorobiya ewatsiname jiwi poxonae ecaename jinyawa xua pexeinya itʉpanae ecaethopaewatha. Barapo mataqueitha copare xua paxanbe nantiyabe paecaeinbe patawantha xua pexeinya itʉpanae ecaethopaewatha. Ichʉn pocotsiwa necoxa weya ecaena. Ichʉn pocotsiwa netsocona weya ecaena, jeibe baponbe. ");
INSERT INTO cui_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bapoxonae Jesús baraibe baponbetha, jeye: —Paxambe jopa payaputaembe pocotsiwa pana newʉcamebe. Poxonae ichamonae abe inta exanaena, xan bara saya copatsin xua barapomonae bara neperaxa jʉbina. Barichi poxoru paxambe tapana neantobexaembe, ¿bara irʉ paca itacʉpabe xua bara pacopatsinamebe xua bara ichamonae paca peraxa jʉbinabe? Barichin bara saya copatsin xua ichamonae bara tʉpa neexanaena. Barichi, ¿bara irʉ paca itacʉpabe xua pacopatsinamebe xua bara ichamonae tʉpa paca exanaenabe? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Barapoyobe jume notabe Jesustha, jeye: —Aa, bara baxua pana neitacʉpabe, jeibe. Jesús jume notabe baponbetha, jeye: —Bara bara xainyei, barapocotsi coyene ichamonae paca cana exanaenabe. Ichamonae paca peraxa jʉbinabe. Mataʉtano ichamonae bara tʉpa paca exanaenabe, icha xan necana ichi tsane. ");
INSERT INTO cui_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nama xua xantha nantiya paecamebe xua ichʉn pocotsiwa tacoxa weya eca, yawa xua ichʉn tatsocona weya eca, baxua jopa tacoya yabara itorobinyo. Saya jame Taxa Nacom meisa baxua taexanaena pomonaetha pomonae caena bayatha tsiwʉnaeta xua peenaenexa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesús pijimonae tatsi pomonae umena, pomonae diez poyobe, barapomonae jume tane xua Santiago irʉ Juan Jesús wʉcatsibe. Bapoxonae barapo diez poyobe, Santiago irʉ Juan yabara anaepanarʉcʉpatsibe. ");
INSERT INTO cui_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ichitha Jesús pia xainya berena pijimonae waba yawa namchiya jeye barapomonaetha: —Paxam bayatha pataneme po coyenewa ba exana pomonae jopa judiomonae naexanaeyo. Barapomonae ba nantaʉta pomonae pia nacua tatsi pia petaewatsiwichi tatsi. Daichitha barapo nacua peewatsiwi aebiya itoroba piamonae xua daxota bichocono jiwi taayapubetsi. ");
INSERT INTO cui_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ichitha nama paxam barapocotsi coyeneya jopa bara paichinde. Seicaya nama icha jʉntʉ coyeneyatha paca itorobatsi. Icha pon paxam jiwana, icha bapon ichichipa naexana be pocotsin canamataxeina ichamonae, bapon matha bewa copiya daxita paxam beta amanaya pacata nacuichina. ");
INSERT INTO cui_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mataʉtano pon xua paxam jiwana, icha bapon ichichipa naexana be pocotsin bichocono ainya cui penaexanaein xua beyacaincha ichamonae, bapon matha bewa copiya daxita paxam beta amanaya pacata nacuichina icha pon pebusi cui taetaeinchi ichi. ");
INSERT INTO cui_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Icha be pocotsi coyeneya ichin bara paichinde. Xan ponxaein Nacom Tananeitapetsin patopeican xua tanacuichinexa tsane ichamonae nexa. Apara jopa baxua tsipatopaeinyo xua ichamonae inta penacuichiwanexa tsane. Saya patopeican tsipei ichichipan xua daxita carepaya jiwi tayawenaewa tsane. Mataʉtano patopeican xua tatsitʉpaenexa tsane be pentoma xua daxita jiwi pepanenebiyaenexa abe pia peexanae cuiru coyenein weya tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bapoxonae Jesús irʉ pijimonae tatsi pata Jericó tomaratha. Jesús irʉ pijimonae tatsi tomara we-iyiya xua irʉrʉ pin bicheitomonae napona. Irʉrʉ bapoxonae pebin pon pewʉn Bartimeo, pon Timeo pexanto tatsi, bapon namtotha eca. ");
INSERT INTO cui_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Poxonae Bartimeo jume tane xua juinya Jesús imoxoyo pona, pon Nazaret tomarapin, bapoxonae bapon Bartimeo tamropata pitaba xua wawaya jeye: —¡Jesús, David pia pemomoxi susato jiwanapim, ponxaem Nacom necaitapetsim neyabara najʉntʉ coyene xeinare jinya tana neyawenaenexam! jei. ");
INSERT INTO cui_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pinmonae jume matawenta bapontha xua moya peecaenexa. Ichitha bapon equeicha bichocono jume daunweya wawai, jeye: —¡Jesús, David pia pemomoxi susato jiwanapim, ponxaem Nacom Necaitapetsim neyabara najʉntʉ coyene xeinare jinya tana neyawenaenexam tsane! jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bapoxonae Jesús naruntaba yawa namchi pijimonaetha, jeye: —Maisa painta wabare, jei Jesús. Bapoxonae pon peitata nacʉtsin wabatsi, yawa barapomonae jeye bapontha: —Bara najʉntʉ tsacatabare, jopa amurande. Nontaponare, aunxuae cawaba, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bapoxonae pon peitata nacʉtsin pia penauyapatsiwa xubiriwa, yawa jirawʉna. Bapoxonae pona Jesustha. ");
INSERT INTO cui_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús yainyaba bapontha, jeye: —¿Eta xua jinya tacata exanaetsi? jei. Bapon Jesús jume notatsi, jeye: —Pon jiwi Pecuidubim, benecotsin cuinaya, jei. ");
INSERT INTO cui_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús jume nota bapontha, jeye: —Bara moya ponde. Bara bayatha caitacuere xanepana exanatsi, tana neyabara jume cowʉntsixaemxae xua bara tana neitacʉpaewa xua tacayawenaewatsi, jei Jesús. Bapoxonae caena nainya pon peitata nacʉtsin necotaxuba. Bapoxonae bapon Jesús puna poinchi namtotha. ");
INSERT INTO cui_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Poxonae Jesús, irʉ pijimonae tatsi muxu pepatsi Jerusalén tomaratha copiya pata Betfagé tomaratha yawa Betania tomaratha, po tomara xua nacacuita ecabe. Barapo tomarabe cuariya demxuwa eca, po demxuwa pewʉn Olivowa, xua baxota olivo naein peumenaexae. Bapoxonae Jesús nacueyatabe poyobe itoroba ponbe pijimonae tatsi jiwana. ");
INSERT INTO cui_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesús barai baponbetha, jeye: —Paponarebe, po tomara painya itabaraya equiya. Poxonae papatopaenamebe barapo tomaratha, bapoxonae pacaxinaenamebe burro pon penʉn pon pequetanotsin, po burro ichamonae jopa tsijuma enaeyo. Barapo burro paisanaxorebe. Bapoxonae payama carenandebe. ");
INSERT INTO cui_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Icha ichʉn paca yainyabiya jeye: ‘¿Eta xua payama isanaxubamebe burro?’ paca jei, nexata pajandebe: ‘Pon jiwi Pecanamataxeinaein bepa pata yama cayiyaeinjei tsipei pinae nantawenona. Bexa nainya equeicha payama carenaein’, pajandebe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Barapomonae ponarʉcʉpa. Yawa caxinarʉcʉpa barapo burro pebto, pon quetanota imoxoyo bo coibototha xua aisowa beya namtotha. Bapoxonae barapoyobe yama isanaxubabe barapo burro. ");
INSERT INTO cui_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pomonae baxota jinompa barapomonae baponbe yainyabatsi jeye: —¿Eta xua paexanamebe? ¿Eta xua burro paisanaxubamebe? jeichichibe baponbe. ");
INSERT INTO cui_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bara baraponbe jume notabe barapomonaetha pocotsiwa bayatha Jesús pejume itorobixae. Bara baraponbe tacopatatsibe xua bara peyama isanaxubinexabe. ");
INSERT INTO cui_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Bapoxonae baponbe tayama cayabe burro Jesús tayama cayatsibe. Bapoxonae pia paparuwan tsijuma jebicabe, yawa Jesús tsijuma equeica. ");
INSERT INTO cui_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bapoxonae jiwi pinmonae namtotha yerababa jejebabapoinya pia paparuwan. Ichamonae peaxu po axu be coichaxu axu ucuboba. Barapo axu namtotha jebapoinya xua Jesús ainya cui exanatsi. ");
INSERT INTO cui_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Pomonae Jesús tsiwana nanta cajinjincatsi, irʉ pomonae Jesús peputha tajinjincatsi, barapomonae Jesús yabara wawaya jeichichi: —¡Pai jayana, maisa Jesús pon jiwi itorobiya pia pepa peewatsinchi maisa wʉnae, bapon patopa Nacom peitorobixae! ");
INSERT INTO cui_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Bara wʉnae jaintatsi pon patopeica xua jiwi peitorobinexatsi, icha David ichi pon wamo susatopin poxonae bapon Israel nacua itorobiya ewata! ¡Maisa Nacom bichocono wʉnae jaintatsi pon athabeicha eca! jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Bara bapoxonae Jesús patopa Jerusalén tomaratha, yawa joniya Nacom pin pia botha tatsi. Jesús naita cui wetaba xua tane daxita pocotsiwa jiwi exana barapo botha. Bapoxonae equeicha Jesús pijimonae barʉ ponataba Betania tomara beya, poyobe xua doce poyobe, tsipei bayatha tabopiya. ");
INSERT INTO cui_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Icha matacabitha baya, poxonae Jesús irʉ pijimonae tatsi Betania tomara weya pona, Jesús jainpapona. ");
INSERT INTO cui_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tajʉ weya Jesús tane higuera nae xua noxu tsuncuae. Jesús higuera nae beya pona piyain petaenexa pethei, ichitha saya noxu tane, tsipei cataunxuae dapo dapae aibi po dapaetha higuera nae nacoita. ");
INSERT INTO cui_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Bapoxonae Jesús barai higuera nae, jeye: —Bapana jopa equeicha nacoichim tsane, xua jiwi jopa necathei xaenexa, jei Jesús. Jesús pijimonae jume tainchi baxua poxonae higuera nae barai. ");
INSERT INTO cui_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bapoxonae pirapaeyo Jesús pijimonae barʉ patopa Jerusalén tomaratha. Jesús joniya Nacom pin pia botha tatsi. Bapoxonae Jesús aisowa benapuna torobabiya barapo Nacom pin pia bo weya pomonae pecaenaeta jiwi baxota. Jesús tabʉ tayebiya bebai iratha pocotsiwa pexaethopaewa po pexaethopaewantha nantiya nacatsiba paratixi, yawa xua irʉrʉ baxota topibo caenaeta. ");
INSERT INTO cui_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús jopa copatsiyo xua jiwi piawan capona Nacom pin pia bo tatsi tutiya iya. ");
INSERT INTO cui_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesús cuiduba barapomonae, jeye: —Nacom Pejume Diwesitha jeye: ‘Tabo apara po botha xua daxita nacuanpiwi tanetsipaebinexa tsaibi tsane barapo botha’, jei Nacom Pejume Diwesitha. Ichitha paxam barapo bo be pecaibiwi pia mʉthʉ tutu pacana exaname, ichaxota pijunuwi nantiyabeibathopa. Tsipei baxota panacaetutame saya ʉ xua painya necaibinexam tsane paratixi pomonaetha pomonae xua pateiba xua Nacom petsipaebeibinexatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, daxita barapomonae jume tane xua Jesús paeba. Bapoxonae barapomonae tamropata notarʉcʉpa xua jeita po coyenewatha Jesús bexubinchi. Barapomonae bequein ichichipa Jesús bexotsi ichitha baxua jopa exanaeyo tsipei barapomonae junuwa xua jiwi anaepana xua barapo sacerdotemonae pia pentacaponaewi tatsi pecasebiwatsi irʉno xua pecasebiwatsi pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene. Tsipei barapomonae jiwi cunuwatsi, xua daxita jiwi peichichipaexae nawita pocotsiwa Jesús cuiduba. ");
INSERT INTO cui_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Poxonae xometo iriya ecanaicha bapoxonae Jesús pijimonae barʉ ponataba barapo tomara weya. ");
INSERT INTO cui_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Baya poxonae pentha tsina, Jesús pijimonae baxoyo barʉ ecapona yawa tane xua higuera nae yʉnuncua xua daxita petabaca opina wetsina. ");
INSERT INTO cui_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bapoxonae Pedro yabara nanta xeinataba xua mexuae Jesús biatane higuera nae. Bapoxonae jeye Jesustha: —Pon jiwi Necuidubim, taema po higuera nae mexuae biataneme, bayatha yʉnuncua, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Bapoxonae Jesús jeye pijimonaetha: —Paxam bichocono pajume cowʉnde Nacom. ");
INSERT INTO cui_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Bara xainyeya paca tsipaebatsi. Icha xanepanaeya pana neyabara jume cowʉntame xua Nacom painya nepaca cayawenaewa xuano xua jopa ainya ʉnthʉton paxeinaem, bara paca itacʉpaena xua painya nepaebiwa icha ichin xua cana exanan higuera nae. Mataʉtano bara paca itacʉpaena xua painya nejeiwa uruto beya, xua pajam: ‘Uruto, natsixitabare, mar mene beya jopare’, xua painya nejeiwa. Bapoxonae bara baxua jopa bayathiyo tsane. ");
INSERT INTO cui_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Daxita xua xuan pocotsiwan Nacom beya pawʉcame, icha bara xanepanaeya pajume cowʉntsiya wʉcame, bara Nacom paca catsibina baxuan. ");
INSERT INTO cui_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Poxonae Nacomtha patsipaebame, icha ichʉn abe pacata exana, copiya payabara jʉntemainare bapon pocotsiwa pacata abe exana, xua xuya beta painya necayabara canantaxeinaenexa. Barichi Nacom pon peitabocotha eca xuya paca yabara jʉntemainaena pocotsiwa abe painya neexanae cuiru coyenein paexaname. ");
INSERT INTO cui_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ichitha icha jopa payabara jʉntemainaem ichʉn pocotsiwa pacata abe exana, barichi Nacom pon itabocotha eca, jopa paca yabara jʉntemainae tsane pocotsiwa abe painya neexanae cuiru coyenein paexaname, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bapoxonae Jesús, irʉ pijimonae tatsi caibe nawibiya Jerusalén tomara beya. Poxonae Jesús Nacom pin pia botha joniya xua yawa tututha iya ponano, bapoxonae sacerdotemonae pia pentacaponaewi tatsi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi irʉ pitiri jiwi, barapomonae Jesús imoxoyo caquita umenarʉcʉpatsi. ");
INSERT INTO cui_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Barapomonae Jesús yainyabatsi, jeichichi: —¿Eta po peayapusʉ itorobi coyenewatha cuidubame baxuan? ¿Jintam cacata barapo peayapusʉ itorobi coyenewa? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús jume nota barapomonae, jeye: —Xan irʉrʉ tha barichichi paca yainyabinchi. Icha beta pana nejume notsiname, bapoxonae xuya yabara paca tsipaebinchi xua po peayapusʉ itorobi coyeneyatha exanan baxuan. ");
INSERT INTO cui_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Jintam Juan cui itorobatsi xua bautisaba? ¿Metha bara Nacom cui itoroba jampa? ¿Metha bara jiwi cui itoroba jampa? Pana nejume nore, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nexata daxita barapomonae caemonae najume matsontsonoba, najei: “¿Eta xua metha jei tsainchi? Icha jeichipaetsi: ‘Juan cui itorobatsi Nacom, xua pebautisabiwa jiwi’, metha naca jeichipae: ‘¿Eta xua metha nexata jopa pajume cowʉntsim Juan?’ metha naca jeichipae Jesús. ");
INSERT INTO cui_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jiwi cui cunuwinchi icha jei tsainchi: ‘Juan cui itorobatsi jiwi, xua bautisaba’, icha jei tsainchi. Metha bapoxonae jiwi naca casebichipa anaya”, najei barapomonae. Barapomonae jiwi cunuwatsi tsipei daxita jiwi Juan yabara jume cowʉntatsi, xua apara bapon Nacom pia peitorobi jume tatsi pepaebi jiton. ");
INSERT INTO cui_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Bapoxonae barapomonae namchi Jesús beya, jeye: —Canta jopa payaputaeinyo, jei barapomonae. Nexata Jesús barai barapomonaetha, jeye: —Nexata barichin tsane jopa yabara paca tsipaebi tsainchi po peayapusʉ itorobi coyeneyatha exanan xua daxita taexanaewan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Bapoxonae Jesús tamropata pitaba xua cuiduba jiwitha pecayabara jʉta pepaebi diwesiyotha, jeye: “Matha irʉrʉ pebin pin uva pabi xeina. Bapon ʉba po ʉnbo pewʉn uva cuei ʉnbo. Yawa yapucurarata barapo pia uva pabi ibowantha xua jopa pejojondenaenexa ichamonae barapo pabitha. Yawano baxota ibo feto exana, xua barapo ibo fetotha pecubinexa uva cuei. Mataʉtano baxota exananota bo, po bo bichocono taʉcha xua baxota pebin bara wenecotequeica uva pabi. Bapoxonae bapon itoroba pomonae pia uva pabi pia petayapucaenaewichi tsainchi, xua bapoxonae barapomonae pejiwanaxaenexa pocotsiwa penawetsiwa. Bapoxonae bapon icha nacua beya pona. ");
INSERT INTO cui_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Barapo matacabi tsuxubi, po matacabitha uva cuei naweta. Bapoxonae barapo mataqueitha pomonae pabi petayapucaenaewi jiwana itapeta nota xua penawetsiwa. Bapoxonae pon uva pabi pexeinaein, bapon pomonae petanacuichiwichi jiwana itoroba, xua petawʉcaenexa tsainchi uva cuei pomonae beya pomonae pabi petayapucaenaewichi. ");
INSERT INTO cui_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ichitha barapomonae pomonae uva pabi petayapucaenaewi barapomonae waetaba pon copiya patopa, pon uva pabi pexeinaein itoroba. Yawa bapon bʉtsino. Bapoxonae bapon caibe cobesa itorobiyatsi. ");
INSERT INTO cui_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pon uva pabi pexeinaein equeicha itoroba ichʉn pon pia petanacuichinchi. Barichirʉ bapon ibotontha matasipa cuinbabatsi, yawa abe jumetha biatainchi. ");
INSERT INTO cui_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Equeicha pon uva pabi pexeinaein itoroba ichʉn pon pia petanacuichinchi. Barichirʉ bapon bexotsirʉ. Equeicha ichamonae itorobatsi. Ichamonae bʉtsi, irʉ ichamonae jutebatsi. ");
INSERT INTO cui_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Cataunxuae awiya bapon pexanto tanacopatatsi, pon pexanto compa tatsi, po pexanto bichocono antobe. Matapainya bapon pexanto cotacaya itoroba bara beya. Bapon nanta xeinaeya jeye: ‘Metha barapomonae taxanto inta yabara barʉ cui itura jinaeinchi’, jei coxiyʉn. ");
INSERT INTO cui_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Dapo jumetha pomonae uva pabi petayapucaenaewi poxonae bapon tainchi, barapomonae najei: ‘Apara bapon paxa copiniwa pichina. Daxota bapon bʉ bexotsi xua xainya xeinatsi barapo uva pabi’, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Bapoxonae barapomonae pon uva pabi pexeinaein pexanto tatsi tawaetabatsi. Poxonae bexotsi bapoxonae petʉpaein aisowa beya xotsi uva pabi pecuariya beya”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bapoxonae Jesús yainyaba, jeye: “Pon uva pabi pexeinaein, ¿eta be cana ichi tsane pomonaetha pomonae barapo uva pabi pia petayapucaenaewichi? Apara bapon patopaena xua pejutebinexa tsane pomonae uva pabi pia petayapucaenaewichi. Bapoxonae barapo uva pabi catsina ichamonaetha xua petayapucaenaenexa tsainchi barapo uva pabi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Equeicha Jesús nayabara paeba barapomonaetha, jeye: “¡Paxam bara bayatha payorobameba Nacom Pejume Diwesi! Barapo diwesitha neyabara caunuta poxonae iboto yabara paeba, jeye: ‘Pebiwi pomonae ibo bon peacabiwi, barapo pebiwi xuba po iboto tabʉ caboca, po iboto peainya cui iboto. Ichitha Nacom itapeta barapo iboto xua petabʉ cabocaenexa peainya cui ibotoxae. Waxainchi nanta xeinatsi jeichichi: Maisa pocotsiwa Nacom exana naca tsita xanepana, jeichichi’, jei Nacom Pejume Diwesitha”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Poxonae bapomonae jume tane xua Jesús paeba, Jesús muxu pewaetabichi. Tsipei bapomonae yaputane xua apara barapomonae yabara paebatsi poxonae Jesús cueicueijei barapo pecayabara jʉta pepaebi diwesiyo. Daxota Jesús casebatsi. Tsipei barapomonae jiwi cunuwatsi, daxota Jesús jopa waetabichi. Bapoxonae bara saya ponarʉcʉpa. ");
INSERT INTO cui_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Bapoxonae pirapaeyo Jesús pia xainya betaitorobiyatsi fariseomonae jiwana, irʉrʉ pomonae Herodes pia pepuna jinompaewichi jiwana tatsi, xua daxita barapomonae piraichi Jesús petsipaebinexatsi xua Jesús xuya abeya pejume notsinexa. ");
INSERT INTO cui_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bara barapomonae Jesús pia xantha tatsi tapatatsi, jeye Jesustha: —Pon jiwi Necuidubim. Bara payaputan xua bara jume xainyeya tsipaebame jiwi, xua mataʉtano jiwi bara beta cuidubame xua pocotsiwa jiwi bewa exanaena pexeinaenexa tsane Nacomtha po jʉntʉ coyene pexanepanae jʉntʉ coyene. Mataʉtano jopa jiwi cunuwim poxonae cuidubame poxonae bequein jiwi jopa ichichipaeyo baxua, tsipei xam daxita jiwi bara catsita najʉpa. Xam jume xainyeya cuidubeibame jiwi Nacom pia peitorobi coyenewa. Incane yabara pana netsipaebare xua nanta xeiname, xuaje: ¿Metha bara Nacom pia peitorobi coyene naca itoroba xua waxainchi paratixi catsibinchi pon romanomonae itorobiya pia pepa peewatsinchi xua wanaca itorobixae bapon bequein bara bapon pon penanapaincha poponaein xua icha nacua werena pona? Icha jopa tsipae, ¿metha daxua abe tsipae? jeichichi Jesús barapomonae pomonae fariseomonae itoroba. ");
INSERT INTO cui_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Daichitha Jesús yaputane, xua barapomonae itara mexeya xanepanaeya pepaebi jiwi ichitha abeya peexanae jiwi. Jesús jeye: —¿Eta pocotsiwa metha painya daichi pana nejʉntʉ coyene jʉjʉtame? Moya painta xawena paratiyo, tha taetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bapoxonae barapomonae barapo paratiyo Jesús tacapoinchi. Poxonae Jesús tane barapo paratiyo, bapoxonae Jesús yainyaba barapomonae, jeye: —¿Jintam pejumopere? ¿Yawano jintam wʉn ducuare? jei Jesús. Barapomonae Jesús jume notatsi, jeye: —Apara romanomonae itorobiya pia pepa peewatsinchi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús barai barapomonae, jeye: —Bara nexata romanomonae itorobiya pia pepa peewatsinchi pacare pocotsiwa xua bapon piawaxae tatsi. Mataʉtano bara Nacom pacare xua baxua irʉ piawaxae tatsi, jei Jesús. Barapomonae yabara najʉntʉ cui coyene cabenaeca pocotsiwa xua Jesús xanepanaeya beta jume nota. ");
INSERT INTO cui_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bapoxonae saduceomonae jiwana pata Jesús pia xantha tatsi xua Jesús piraichi petsipaebinexatsi. Saduceomonae barompaya pia pecuidubi coyenewa xeina xua pinae pomonae pewerapeibiwi equeicha jopa asʉ tsaibiyo. Barapo pecuidubi coyenewa jopa jʉpaeyo po pecuidubiwa Jesús pia pecuidubiwa tatsi xua pinae jiwi equeicha asʉ jinompaena poxonae werapa. Daxota barapomonae Jesús tsipaebatsi, jeye: ");
INSERT INTO cui_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Pon jiwi Pecuidubim. Moisés nacata tina, namchi: ‘Icha pebin piowa cuenta tʉpa, yawa jopa xeinaeyo pexui, xuyapin bewa xuya pentapin pecoutha coseuri pichina xua bapoxonae pentapin pecoutha pexeinaenexa tsane pexui’, jei Moisés. ");
INSERT INTO cui_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Barichi, matha irʉ cae peweicho caepiwi nabarʉ jinompa siete poyobe. Matapin jitha eca. Bapon piowa cuenta naxuba. Pexui jopa xeinaeyo. ");
INSERT INTO cui_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pon cotacaya naexana xuya pentapin coseuri pita xua bapoxonae pentapin pecoutha pexeinaenexa pexui. Bapon irʉ cuenta tʉpa, irʉ jopa xeinaeyo pexui. Bapoxonae ichʉn xuyapin xuya barapowa pita xua pentapin coseuri pita. Bapon barichi irʉ cuenta tʉpa, irʉ pexui jopa xeinaeyo. ");
INSERT INTO cui_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Daxita barapo siete poyobe cuenta nanapentapona barapowa poxonae bequein xuya pecoutha nonotaponeiba. Barapo siete poyobe, caein jiwana jopa pecoutha tapoponaetsi pexuyo. Bapoxonae matapainya irʉ bapowa tʉpa. ");
INSERT INTO cui_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Xam, Jesús, ba paebame, ba jam: ‘Matacabi jopaena po matacabitha Nacom asʉ exanaena, xua jiwi asʉ exanaeinchi mʉthʉn wetsina’, ba jam. Poxonae barapo matacabi jopaena xua daxita jiwi asʉ jujuinaena, barapo matacabitha ¿jintam metha bapowa xuya pichinchi, xua ichʉn pichina, xua barapo siete poyobe caein jiwana? Tsipei caena bayatha barapo siete poyobe, caepi jiwi cuenta nanapentapona barapowa, jei saduceomonae. ");
INSERT INTO cui_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Bapoxonae Jesús jume nota barapomonae, jeye: —Paxam apara catsawiya pana nejume notame, tsipei jopa beta payaputaem xua Nacom Pejume Diwesitha payabara yorobame baxua. Mataʉtano jopa payaputaem Nacom pia peayapusʉ itorobi coyenewa tatsi. ");
INSERT INTO cui_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Poxonae petʉpaewi asʉ jujuinaena jopa jitha eenaponae tsane. Yawa barapomonae pexantixi jopa jitha cuarebaponae tsane. Tsipei barapomonae barichi tsane icha be matatsunpiwimonae ichi, po matatsunpiwi Nacom pia nacuatheicha jinompa, xua po matatsunpiwi jopa jitha enaeyo. ");
INSERT INTO cui_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Paxam bequein bara bayatha payorobame pocotsiwa Nacom yabara namchi pejume diwesitha xua pomonae equeicha asʉ jujuina pomonae pewerapeibiwi. Barapo diwesitha Nacom cueicueijei ichaxota xua poxonae po naewa taxuncua, Nacom jeye: ‘Xan Abraham pia Nacomʉn tatsin, irʉ Isaac pia Nacomʉn tatsin, irʉ Jacob pia Nacomʉn tatsin’, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Baxua Nacom paeba, tsipei Abraham, irʉ Isaac, irʉ Jacob pewerapaewi anoxuae equeicha caewa asʉ jinompa, Nacom pia nacuatheicha tatsi. Pomonae pewerapaewi, pomonae caewa equeicha asʉ jopa pejinompaewi, barapomonae jopa pia Nacom tatsi, pon itabocotha eca. Saya jame meisa pomonae pewerapaewi caewa equeicha asʉ pejinompaewi, barapomonae jame pia Nacom tatsi, pon itabocotha eca. Daxota paxam catsawa papaebame, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Caein pon jiwanamonaepin pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, bapon jume tane xua Jesús irʉ saduceomonae najume matsontsonobiya paeba. Mataʉtano bapon jume tane xua Jesús xanepanaeya betiya jume nota barapomonaetha. Daxota bapon yainyaba Jesustha, jeye: —¿Eta po peitorobi coyene pepa peainya cui coyenewara, po peitorobi coyene beyacaincha icha peitorobi coyene? jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús jume nota bapontha, jeye: —Po peitorobi cui coyenewa pepa peainya cui coyenewa jeye: ‘Paxam Israel nacuamonaepiwi pam pajume taema xuaje meje: Pon jiwi Pecanamataxeinaein bara compa pepa Pata Nacom, icha Nacom ajibi. ");
INSERT INTO cui_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Antobeinde Jinya Necanamataxeinaein bapon Nacom xua daxita nejʉntʉ coyene wetsina, mataʉtano xua daxita jinya nepoponae coyenewatha, mataʉtano xua daxita nenanta xeinaewatha nentasipatha, mataʉtano daxita nedaunwei coyenewatham’, jei barapo peitorobi coyenewatha, po peitorobi coyenewa pepa peainya cui coyenewa. ");
INSERT INTO cui_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Po peitorobi coyene cotacaya itoroba ichaxotaba ‘dos’ jei, barapo peitorobi coyene be jume jʉpa po peitorobi coyene copiya ducua. Irʉrʉ barapo peitorobi coyenewatha jeye: ‘Antobeinde jinya necatsicuarabʉ ecaein icha ichim xua jinya coutha naantobem’, jei barapo peitorobi coyenewatha. Icha peitorobi coyenewa aibi po peitorobi coyene peainya cui coyenewa, po peitorobi coyenewa xua beyacaincha po peitorobi coyenewe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Bapoxonae caein jiwanamonaepin pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, bapon jeye Jesustha: —Bara beta paebame pocotsiwa aunxuae paebame ponxaem jiwi Necuidubim. Bara xainyeya paebame xua pinae pepa Nacom bara compa popona xua icha pepa Nacom ajibi. ");
INSERT INTO cui_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mataʉtano bara xainyeya paebame xua pinae bewa Nacom antobetsi xua daxita wajʉntʉ coyene wetsina, mataʉtano xua daxita wajinompae coyenewatha, mataʉtano xua daxita wananta xeinaewatha wantasipantha, mataʉtano daxita wadaunwei coyenewantha. Mataʉtano bara xainyeya paebame xua wanacatsicuarabʉ enaewi bewa pinae antobe tsainchi icha ichichi xua wacoutha naantobetsi. Baraxua jame bichocono peainya cui coyenein pocotsiwa bewa exanaetsi, beyacaincha xua duwein ompin tautatsi yawa xua ichawan tautatsi xua watuxusi exanaenexa Nacom nexa, jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Poxonae Jesús jume tane xua bapon beta jume nota, Jesús jeye: —Bara saya tsiwiyo cata seica xua jinya nejume cowʉntsinexa xua nenantaʉtsinexa Nacom pon jiwi itorobiya pia pepa Peewatsinchi, jei Jesús. Bapoxonae nama dapon ajibi xua pon Jesús peyainyabinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Bapoxonae Jesús yabara cuiduba Nacom pin pia botha tatsi, xua pon Mesías baraichi xua nayabara paeba Jesús, jeye: —¿Eta pocotsiwa metha pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi paeba xua pinae Mesías bapon David pia pemomoxi susato jiwanapin tatsi? ");
INSERT INTO cui_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nacom pia Pejumope tʉnaxʉ tatsi David cueicueijei exanatsi. David jeye: ‘Nacom pon Pecanamataxeinaein jiwi, Tanecanamataxeinaein baraichi pon Mesías, jeichichi: Tacoxa werena ecare, beya abʉ tsane poxonae necaaitafaetabi jiwi pia pecanamataxeinaeinchi tatsi caexanaeinchi, jei Nacom pia Pejumope tʉnaxʉ tatsi’, jei David. ");
INSERT INTO cui_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Icha David Mesías yabara jei, ‘Bapon Mesías Tanecanamataxeinaein’, jei, ¿eta xua metha tsipae xua Mesías apara David pia pemomoxi susato jiwanapin tatsi? jei Jesús. Barapo pin bicheito bichocono tsimuxu wʉnaetsi pocotsiwa Jesús cueicueijei. ");
INSERT INTO cui_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Poxonae Jesús cuiduba jiwitha, jeye: “Dota pam, dota pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Barapomonae pia pecuidubi coyenewan tatsi pecuiyainwa pande. Jopa paexanaeinde icha bapomonae ichi xua barapomonae bichocono ichichipa xua penama xatabiwa po paparuwan apipiya deca xua be pomonae peainya cui jiwi penaexanaewi naexana. Barapomonae bichocono ichichipa xua jiwi namtontha jacobeibina barapomonaetha xua jiwi pebarʉ cui itura jineibinexa barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Barapomonae bichocono ichichipa xua nanta caeneiba judiomonae pia penacaetutsi bontha tatsi ichaxota ba enathopeiba pomonae peainya cui jiwi penaexanaewi. Mataʉtano barapomonae bichocono ichichipa xua eneiba ichaxota ba eneiba pomonae peainya cui jiwimonae poxonae pexaewan tsinacaetuteiba penabaneibinexa tsane. ");
INSERT INTO cui_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mataʉtano barapomonae powaxi pecuenta werapaewaxichi piseurixi barapowaxi cueranta enatsi pia bon. Barapomonae naemata jopa cuinaya najume copababeibiyo poxonae tsipaebeiba Nacom. Barapomonae bichocono peraxa jʉbebinchi poxonae po mataqueitha Nacom jiwi yabara paebina penatsicuentsiwa xua abe peexanaexae Nacomtha. Barapomonae atene tsane beyacaincha poxonae ichamonae atene exanaeinchi xua jopa pejume cowʉntsixaetsi Nacom”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Poxonae Jesús eca Nacom pin pia botha tatsi xua peitabara weya, xua ichaxota jiwi jeyeiba paratixi Nacom nexa, bapoxonae Jesús tane xua pinmonae pomonae copei pexeinaewi paratixi nawita jeya ichaxota jiwi jeyeiba paratixi Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Barapoxonaerʉ yabʉyo patopa, powa pecuenta tʉpaewatsi piseuri. Barapowa bichocono peacopeibiwayo. Bapowa jeca ainya pecacomocae paratiyobe Nacom nexa. Barapo paratiyobe tsiqui paratiyobe. ");
INSERT INTO cui_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bapoxonae Jesús pijimonae waba, yawa jeye barapomonaetha: —Bara xainyeya paca tsipaebatsi. Barapo yabʉyo, powa pecuenta tʉpaewatsi piseuri, bapowa peacopeibiwayo. Daichitha barapowa jeca ainya paratiyobe Nacom nexa. Bapowa cata beyacaincha ichamonae daxita pomonae xua jeya xua Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Daxita barapomonae jeya pocotsiwa tanacopabeibatsi. Ichitha nama bapowa bichocono peantobexae Nacom daxota omeicha jeca pocotsiwa bequein canantawenona xua pepoponaewa tsane bequein bichocono peacopeibiwayo, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Poxonae Jesús Nacom pin pia bo wejoniya, bapoxonae caein Jesús pijimonae jiwana tatsi, Jesús tsipaebatsi jeichi: —¡Pon jiwi Necuidubim, taema maisa pexeinya iboton, yawa pexeinya ibo bo! jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ichitha Jesús jume nota bapontha, jeye: —Aunxuae pataebename barapo iboton yawa xua pexeinya bon. Apara jopa cae ibotiyo nacopatuncuae tsane icha iboto peʉmatha. Daxita abe tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Bapoxonae Jesús pijimonae barʉ pona demxuwatheicha, po demxuwa pewʉn demxu Olivowa tsipei baxota umena olivo naein. Poxonae Jesús ecopiya demxuwatheicha, po demxuwa Nacom pin pia bo itama tayecatsi, bapoxonae Jesús pijimonae tatsi Pedro, irʉ Santiago irʉ Juan, irʉ Andrés, barapoyobe Jesús namicha tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Barapoyobe jeye: —Paichichipan xua xam tapata netsipaebiwam tsane ¿eta poxonae metha ichamonae baxua exanaena poxonae abe cana exanaena Nacom pin pia bo tatsi? ¿Eta pocotsiwa tsane metha xua pewʉnaeya tsita itapeinya xeinaena po coyene xua poxonae imoxoyo daxita weraweracaenaba? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús jume nota barapomonaetha, jeye: “Dota pam, bʉ ichamonae naerabiya paca muxu tsipaeba, xua daxota abe paexanaetsipame. ");
INSERT INTO cui_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tsipei tsana patsina ayei bicheito jiwi pomonae natsicotaena icha be xan ichin. Barapomonae jei tsane: ‘Apara xan Mesías’, jei tsane. Poxonae barapomonae muxuitorobiya paebina, bapoxonae pinmonae jume cowʉntsina. ");
INSERT INTO cui_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Pajume taename xua jiwi juinya nabenoutsina xote, yawa xua juinya irʉrʉ nabenoutsina icha ira beya. Daichitha jopa pajunuwinde, tsipei baxua pewʉnaeya matha copiya tsane. Daichitha cataunxuae dapo matacabi aichica tsane xua poxonae daxita weraweracaenaba yatsicaewa. ");
INSERT INTO cui_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cae nacuapiwi irʉ icha nacuapiwino, barapo ainya nacuapiwibe nabenoutsina. Mataʉtano irʉ pon nacua peewatsin irʉ ichʉndʉ pon icha nacua peewatsin, baponbe irʉ nantiya nabenabe. Mataʉtano ainya nacuantha ira jijiyatsina. Mataʉtano ainya nacuantha jainbo nacua tsane tsipei pin mayayo tsane. Baxua copiya matha tsane xua jiwi atene tsoponae tsane bichocono xua beya jopa nama juniya tsane. ");
INSERT INTO cui_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ichitha dota pam, tsipei poxonae baxua pewʉnaeya tsane jiwi paca teiquebina painya nepaca caenaetsinexa pomonaetha pomonae tomaran pentacaponaewi. Mataʉtano paca cuainchina judiomonae pia penacaetutsi bontha tatsi. Yawa paca caponaena nacua peewatsiwi peitabaratha tatsi, painya tana nejume cowʉntsixaemxae. Yawa paca caponaena pentacaponaewi peitabaratha tatsi pomonae irʉ itoroba jiwitha xua pon nacua peewatsin nexa painya tana nejume cowʉntsixaemxae. Barapoxonae bara paca cui itacʉpaena xua barapomonaetha tapana neyabara paebiwam pocotsiwa bayatha paca tsita exanatsi. ");
INSERT INTO cui_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Barapo pecapanenebiyae diwesi, tamonae bewa paebinoutsina daxita nacuanpiwitha xua poxonae pewʉnaeya tsane xua daxita weraweracaenaba. ");
INSERT INTO cui_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Poxonae barapomonae paca caponaena pomonaetha pomonae tomara pecanamataxeinaewi xua pia painya nepaca cayabara paebinexa tsane xua painya nenatsicuentsiwa xua abe painya neexanaexae bapoxonae jopa patsiwanaya junuwiya najʉntʉ coyene exabinde xua painya netsipaebiwa tsane barapomonae. Paxam jame papaebare pocotsiwa xua caena bapoxonae Nacom cueicueijei paca exanaena. Bapoxonae po jume pacueicueijam tsane apara jopa poxoru painya coya paichichipaem, apara jame Nacom pia Pejumope tʉnaxʉ tatsi baxua paca cueicueijei exanaena. ");
INSERT INTO cui_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jiwi barompaya pia peweicho jiwi caenaetsina ichamonaetha xua pejutebinexa tsainchi. Irʉrʉ coxiyeiwi ichamonaetha caenaetsina pia pexui. Irʉ pexui paxa jiwi caenaetsina ichamonaetha pejutebinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Daxita nacuanpiwi paca casebina painya tana nejume cowʉntsixaemxae. Ichitha pomonae awiya antʉyapusʉya nejume cowʉntsiya jinompaena xua beya yacuiya werapaeya othopaena poxonae bequein abe taexanatsi ichamonae barapomonae jame Nacom napaeba cana exanaena. ");
INSERT INTO cui_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Daniel pon Nacom peitorobi jume pepaebin, bapon caena bayatha yabara tsiwanaya muxu dutsiya tina pocotsiwa xua bichocono abe, pocotsiwa xua weraweraca cana exana. Pataename pocotsiwa xua ichʉn Nacom pin pia bo tututha exananotsina, pocotsiwa jopa bewa notsi baxota, pocotsiwa Daniel bayatha yabara paeba. Bapoxonae payaputaename xua bara imoxoyo matacabi jopaenaba poxonae daxita weraweracaenaba”, jei Jesús. (Xan Marcos paca baraichi: “Pon yorobina po jume diwesi tinan moya jume naitaewatsina pia peyaputaenexa tsane”, paca jeichi.) Equeicha Jesús jeye: “Poxonae barapocotsiwa pataename bapoxonae pomonae Judea nacuatha jinompa, barapomonae bewa demxuwan berʉcʉpiyaena. ");
INSERT INTO cui_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Barapo matacabitha pon bo matatupatha uncua, bapon jopa bewa botha joniyae tsane xua penotsiwa tsane pocotsiwa tabobeinchi bomʉxʉ tututha. Saya jame bewa nainya benaetsiricuaena. ");
INSERT INTO cui_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Irʉrʉ pon pabitha popona, bapon jopa bewa caibeya ponae tsane botha xua penotsiwa tsane pia paparuwan. Saya jame bewa nainya benaetsiricuaena. ");
INSERT INTO cui_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Pai yabʉxi tsobenae powaxi pexui bʉpana taenatsi barapo matacabitha! ¡Pai irʉ powaxi pexui isaina barapowaxi tsobenaerʉ! Tsipei acabe tsobenae tsane pexui. ");
INSERT INTO cui_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Poxonae pewʉnaeya tsane baxua Nacom pawʉcare xua jopa painya nerʉcʉpaewa tsane poxonae awʉbo peaquexae bichocono. ");
INSERT INTO cui_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tsipei barapo matacabintha jiwi bichocono pin peraxa exanaeinchi. Atene tsane beyacaincha poxonae jiwi atene tsaibi poxonae Nacom aena nacua exana, xua equeicha nama bichocono pin peraxa tsane. Equeicha bexa bapoxonae bapana jopa baxua exanae tsane poxonae bichocono jiwi pin peraxa. ");
INSERT INTO cui_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Icha Nacom jopa be caentacabiyobe exanaetsipae metha dapomonae ajibi tsipae pomonae panenebiya barapo peatene coyenewa weya. Daichitha Nacom be caentacabiyobe exanaena peantobexae pijimonae, pomonae pia peitapetsiwixae tatsi. ");
INSERT INTO cui_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Bapoxonae icha ichʉn paca jei: ‘Pataema bapon apara Mesías uncue pon Nacom itorobica’, paca jei, irʉ icha ichʉn paca jei: ‘Pataema bapon Mesías xota uncuiye’, paca jei, barapo jumein jopa pajume cowʉntsinde. ");
INSERT INTO cui_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tsipei pomonae pemuxuitorobi jiwi tsana patsina. Barapomonae natsicotaena icha be xan ichin ponxaein Mesías. Mataʉtano barapomonae natsicotaena icha be pomonae Nacom peitorobi jume pepaebiwi ichi tsane. Barapomonae pexeinya petsita itʉtsi coyenewan exanaena peitabocotha, po irathe tsaneno xua jiwi pemuxuitorobinexa tsainchi xua jiwi pejume cowʉntsinexa pocotsiwa barapomonae paeba. Barichirʉ pomonaetha pomonae Nacom pia peitapetsiwi tatsi pemuxuitorobinexa tsainchi xua irʉrʉ icha metha barapomonae pejume cowʉntsinexa tsanerʉ pocotsiwa barapomonae paeba. Ichitha jopa itacʉpae tsainchi xua barapomonae pemuxuitorobiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tsaca pajinompare, tsipei baxua tsiwanaya yabara paca tsiwʉnae muxu dutatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Equeicha Jesús namchi, jeye: “Po matacabintha poxonae nacui wetsina xua jiwi pin peraxa tsane, bapoxonae xometo nainya naquitabina. Jomocoichato jopa pentha tsane. ");
INSERT INTO cui_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Opiteiton peitaboco weothopeicaena. Mataʉta napuna torobabiyaena Nacom xua xuan itabocotha dubena. Bapoxonae jopa xapain dubenanaeyo tsane. ");
INSERT INTO cui_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Bapoxonae daxita jiwi taena peitabocotha xua po coyene apara tapatopeicaewa tsaneba tsaquinaebowatha peitaboco wetsica ponxaein Nacom Tananeitapetsin. Nacom pia peayapusʉ itorobi coyenewatha mataʉtano bichocono pexeinya itʉpanae coichathano patopeicaein. ");
INSERT INTO cui_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mataʉtano itorobin tamatatsunpiwi xua inta pecaetutsinexa pomonae taitapetsiwi. Nacaetutsina daxita nacuanpiwi jiwana, irʉ ichamonae pomonae ichaxota xometo weecoinapiwi jiwana, irʉ ichamonae pomonae ichaxota xometo bejopiyapiwi, jiwana, irʉ ichamonae pomonae pocotsiwa werenepiwi jiwana, irʉ ichamonae pomonae pocotsiwa berequepiwi jiwana. ");
INSERT INTO cui_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Payaputaema barapo pecayabara jʉta pepaebi diwesiyo xua higuera nae. Jeye: Poxonae ba pataneme xua pena noxu xuxuwapona, bapoxonae ba payaputaneme xua bara imoxoyo wei tsurucuae tsoponae, xua pentono perubenaenexa. ");
INSERT INTO cui_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Barapocotsi jʉta coyeneya ichi tsane poxonae pataename daxita baxuan pocotsiwa aunxuae paca tsipaebatsi pocotsiwa bexa exanaena, bapoxonae payaputaename, xua bara imoxoyo tsane xua tapatopae wʉnae tsane. ");
INSERT INTO cui_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Bara xainyeya paca tsipaebatsi daxita judiomonae naitapataya naexanaponaena beya yacuiya othopaena poxonae Nacom exanaena daxita baxuan pocotsiwa xuaunxuae paca tsipaebatsi. Bapoxonae barapo judiomonae weraweracaena pomonae poxonaerʉ barapo matacabitha jinompa. ");
INSERT INTO cui_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Peitaboco aichurucuae tsane. Mataʉtano ira aichurucuae tsane. Meisa nama tajumein ataya tsitecaena xua daxota daxita nayabara jume wetsina be pocotsi coyeneya bayatha paeban. ");
INSERT INTO cui_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Po matacabitha baxua exanaena, mataʉtano po horatha baxua exanaena jiwi jopa baxua yabara yaputaeyo. Irʉ matatsunpiwi pomonae peitaboco beicha jinompa baxuan irʉrʉ jopa yabara yaputaeyo. Irʉ xan ponxaein Nacom Pexanton baxua jopa yabara yaputaeinyo. Meisa saya Nacom, pon Waxa yaputane poxonae po matacabitha baxua exanaena. Mataʉtano yaputane poxonae po horatha daxita exanaena baxua xuaunxuae paca tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Tsaca pajinompeibare xua tapatopae wʉnae tsane. Yawa Nacomtha patsipaeba dubenanaebiyama, tsipei jopa payaputaem po mataqueitha patopaein. ");
INSERT INTO cui_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Barapocotsi coyeneya jʉta ichi poxonae xan patopeicaein taitorobinexa tsane jiwi, icha be poxonae pebin ichi poxonae warapaena icha nacua beya. Poxonae bapon pewʉnaeya tsane xua warapaena pia bo weya, copiya matha waba pia petanacuichiwichi. Bapon daxita pia petanacuichiwichi barompaya cobenata petanacuichiwantsi tatsi. Mataʉtano bapon itoroba pon bo coiboto eena xua xanepanaeya bo pe-eenaenexa. ");
INSERT INTO cui_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Paxam tsaca pajinompare, tsipei jopa payaputaem poxonae patopeicaein, icha be barapomonae ichi poxonae jopa yaputaeyo poxonae pepatopaewa tsane pia pecanamataxeinaeinchi pon bo pexeinaeinxae. Barapomonae jopa yaputaeyo icha barapon patopaena poxonae quirei tsanaicha, ichacuitha icha bapon patopaena papaetha, ichacuitha icha bapon patopaena mataqueiwʉnaeyo, ichacuitha icha bapon patopaena baya tsane. ");
INSERT INTO cui_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Barapomonae jopa yaputaeyo xua pia pecanamataxeinaeinchi nainya patopaena xua yaichamaicha mata taenabounaeinchi poxonae maitumena. ");
INSERT INTO cui_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Meje xuaje paca tsipaebatsi, xua paca jeichi: ‘Tsaca pajinompare’, paca jeichi, baxua irʉ daxita jiwitha tsipaeban”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Acoibi po matacabiyobe cataunxuae seica poxonae jiwi nacaetutsina penabanaenexa pexaewa, peyabara nanta xeinaenexa barapo matacabi xua poxonae caena bayatha matha judiomonae Egipto nacua weya panenebiya. Barapo matacabi pewʉn Pascua matacabi wʉn. Barapo Pascua matacabi wʉntha jiwi xane pan, po pan xua jopa cotowiyo. Sacerdotemonae pia pentacaponaewi tatsi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, daxita barapomonae nabarʉ muxu jei xua bepa pinae eta bichi tsane poxonae Jesús nameicha waetabinchi pebexubinexatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ichitha barapomonae najeye: —Abʉ jopa waetabi tsainchi poxonae jiwi Pascua matacabi wʉntha nacaetuta penanabanaenexa pexaewa. Tsipei icha barapo mataqueitha waetabichipatsi pinmonae anaepanaya najume cayayataxubichipa, najei daxita barapomonae xua Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Poxonae Jesús Betania tomaratha popona, bapoxonae Jesús Simón pia bo tatsi betajoniyatsi, pon peperʉ sawinchi. Poxonae Jesús eca pexaethopaewatha, bapoxonae patopa petsiriwa. Bapowa capatopa alabastro ibo bosibʉ atsato, xua bichocono wʉnca penasiwa xua petuxueiwa. Barapo petuxueiwa bichocono ainya matoma. Poxonae wacataba barapo bosibʉ, bapoxonae Jesús mata epatabatsi barapo petuxuei nasiwatha. ");
INSERT INTO cui_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pomonae irʉ baxota ena, barapomonae jiwana anaepana, yawa caemonae najei: —¿Eta pocotsiwa metha saya xuba jane barapo petuxuei nasiwa? ");
INSERT INTO cui_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Barapo petuxuei nasiwa becaenaetsipatsi. Bapoxonae bexeinaetsipatsi trescientos po paratiximonaebe po paratiximonaebe xua namatomata xua poxonae trescientos matacabibe nexa xua poxonae nacuita. Barapo paratixitha beyawenaetsipatsi peacopeibi jiwi, najei barapomonae. Bapoxonae barapomonae barapowa casebatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ichitha Jesús jeye barapomonaetha: —Moya pande, bara pacopare. ¿Eta pocotsiwa metha barapowa pabiataneme? Pocotsiwa barapowa inta exana apara seicayarʉ xua pexeinya coyene inta exana. ");
INSERT INTO cui_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Barapo irathe peacopeibi jiwi paca barʉ jinompeibina ataya tsaibi tsane. Paca itacʉpa xua beta pata exaname barapomonae poxonae paichichipame. Ichitha nama paxam jopa ataya paca barʉ poponae tsainchi barapo irathe poxonae paca itacʉpa xua pana neyawename. ");
INSERT INTO cui_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Barapowa xua nenta epataraba tapepontha xua petuxuei tuxusi nasiwatha apara xua tsiwanaya nenacui yabara nacui wʉnaeta xua mʉthʉ tana neboyaenexa poxonae tʉpaein. ");
INSERT INTO cui_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Bara xainyeya paca tsipaebatsi. Daxita nacuanthan poxonae jiwi cueicueijei tsane Nacom pia pecapanenebiyae diwesi barapo jiwi yawa yabara paebina xua pocotsiwa poxonae bapowa inta exana xua jiwi bapowa peyabara cui nanta xeinaenexatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Barapoxonae Judas Iscariote pon doce poyobe jiwana, pomonae Jesús pijimonaexae tatsi, bapon sacerdotemonae pia pentacaponaewi tatsi beya pona. Bapon pona xua petsipaebinexa xua Jesús caenaetaxubinchi barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Poxonae barapomonae baxua jume taerʉcʉpa bichocono ichichiparʉcʉpa baxua. Yawa barapomonae Judas Iscariote muxu tsipaebatsi xua paratixi catsibapaebatsi. Bapoxonae Judas tamropata pitaba xua jeita, xua po coyenetha Jesús pecaenaetaxubiwa tsainchi barapomonaetha poxonae peyapu xanepanaewatha. ");
INSERT INTO cui_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nexata copiya matacabi jopa po matacabi tsiwana penanta carucuae matacabi xua po matacabintha poxonae jiwi tsinacaetutsina, xua penabanaenexa pan, po pan jopa muxuna pentsiyo levadura matawʉn, pocotsiwa xua cotowa exana pan. Barapo penanta carucuae matacabitha ba corderoxi pebtoxi xua oveja coxi jutebatsi xua jiwi pexaenexa. Bapoxonae barapo jiwi cayabara nanta xeina xua caena bayatha pia pamo susato jiwi tatsi corderoxi juteba yawa xane beya poxonae panenebiya Egipto nacua weya. Barapo matacabitha Jesús pijimonae yainyabatsi, jeye: —¿Exota ichichipame xua xota pexaewa paca tsiwʉnaetsinchi wanabanaenexa tsane xua Pascua wʉn matacabi nexa? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bapoxonae Jesús itoroba nacueyatabe poyobe ponbe xua doce poyobe jiwana, pomonae Jesús pijimonae tatsi. Jesús jeye: —Tomara beya paponarebe. Barapo tomarathiya pantenta ponaenamebe pebin pon mera yantana ponaena juruwatotha. Bara bapon papuna pondebe. ");
INSERT INTO cui_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Bo beya paponarebe ichaxota bapon joniyaena. Pon bo pexeinaein pabarande: ‘Pon jiwi Pecuidubin cabarai: ¿Incane tutura, po tututha tajiwimonae barʉ nabanaein pexaewa Pascua wʉn matacabi nexa?’ jei bapon, pajandebe. ");
INSERT INTO cui_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Bapoxonae bapon paca tsita itacayopichinabe po tutu pin tutu po tutu xua asiyeicha po tutu xua bayatha tutu xaneba. Barapo tututha pexaewa pana cui wʉnaetajebare xua wanabanaenexa pexaewa barapo Pascua wʉn matacabi nexa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bara bapoxonae baponbe ponatababe. Bara patopabe tomaratha. Bara tanebe daxita be po coyeneya bayatha Jesús paeba. Bapoxonae pexaewa nacui wʉnaetajebabe Pascua wʉn matacabi nexa xua penabanaenexa. ");
INSERT INTO cui_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Poxonae quirei tsanaicha bapoxonae Jesús pijimonae barʉ patopa barapo tututha. ");
INSERT INTO cui_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Poxonae Jesús pijimonae cataunxuae barʉ xunaboca pexaethopaewatha, bapoxonae Jesús pijimonae barai, jeye: —Bara xainyeya paca tsipaebatsi caein pon paxam jiwana pam pon nebarʉ xaeuncua bapon necanaetaxubina ichamonaetha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nexata bapoxonae Jesús pijimonae tatsi ʉnthʉthʉ wecoyei tsʉrʉcʉpae, nexata daxita tsana jei tsoponae Jesustha: —¿Apara xan cacaenaetaxubinchi? jei daxita barapomonae xua Jesús tsana yainyabaponatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús jume nota barapomonaetha, jeye: —Pon paxam jiwana pam xua doce poyobe jiwana xua cae paratotha pana nabarʉ jajaucuncuaponanbe pan apara bapon necaenaetaxubina ichamonaetha. ");
INSERT INTO cui_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Xan ponxaein Nacom Tananeitapetsin bewa tʉpaein, tsipei Nacom Pejume Diwesitha baxua neyabara paeba caena bayatha. Ichitha pebin tsocuae pon necaenaetaxubina ichamonaetha. Metha jame wʉnae tsipae icha bapon bayatha jopa naexanaetsipae, tsipei bexa tsane bichocono atene tsocuae tsane, bichocono abe tana necana exanaexae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Poxonae Jesús pijimonae barʉ xaeuncua, bapoxonae Jesús pecobetha pita pan. Yawa Paxatha tsipaeba, jeye: “Axa, maisa jʉntʉ coyene weiweinan xua pan pata tanecatsiwam”, jei. Bapoxonae Jesús pecobetha pan epa janaca, yawa catsiba pijimonae. Bapoxonae pijimonae barai, jeye: —Paxaema po pan epa janacan. Barapo pan apara neyabara caunuta tapepon xua poxonae tapaca tsitʉpaewatsi tsainchi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bapoxonae Jesús equeicha pecobetha pita corotiyo, yawa Nacomtha tsipaeba, jeye: “Axa, maisa jʉntʉ coyene weiweinan xua corotiyotha ecareca pepa uva mera xua pata tanecatsiwam”, jei. Bapoxonae Jesús pijimonae cata corotiyo xua pejiwana aapaponaenexa. Daxita barapomonae bara jiwana aapapona. ");
INSERT INTO cui_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Bapoxonae Jesús jeye pijimonaetha: —Pena petsiwʉnae muxu dutsi coyenewa paca tsipaebatsi. Barapo uva mera po mera xua corotiyotha tsijuntu eca yabara caunuta tajana barapo uva mera xua jana othoparenaein poxonae tʉpaein. Barapo jana tsita itapeinya xeinaena xua jiwi pinmonae yabara jʉntemainaein abe pia peexanae cuiru coyenein tatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Bara xainyeya paca tsipaebatsi, barapo uva mera jopa equeicha paca barʉ apae tsainchi anoxuae. Meisa abʉ bexa tsane pena coyenewatha paca barʉ apaeinchi barapo uva mera poxonae Nacom neexanaena xua itorobiya ewatsin jiwi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Poxonae Jesús pijimonae barʉ najume weta xua naxʉna Nacom nexa, bapoxonae Jesús pijimonae barʉ pona demxuwa beya. Barapo demxuwa pewʉn demxu Olivowa, olivo naein peumenaexae baxota. ");
INSERT INTO cui_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nexata Jesús pijimonae barai, jeye: —Anoxuae barapo merawithe daxita pam pana necuentarʉcʉpaename tapaca urapentsixaetsi tsainchi. Baxua paexanaename, tsipei Nacom Pejume Diwesitha paca yabara cui tsiwʉnaeya jeye: ‘Poxonae ovejamonae peewatsin bexubin, bapoxonae ovejamonae tsanarʉcʉpaena’, jei Nacom. Penamchixae poxonae ichamonae newaetabina tanebexubinexa pana necuentarʉcʉpaename. ");
INSERT INTO cui_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ichitha taeyarapaeyo Nacom equeicha asʉ neexanaena. Bapoxonae paca tsiwana patopiyaeinchi Galilea nacua beya, poxonae bara beya paponaename, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nexata Pedro Jesús jume notatsi, jeye: —Bequein ichamonae cacuentarʉcʉpaena jinya neuraxubixae, nama xan bapana jopa cacuenta naetsiricuae tsainchi taneuraxubixaemxae, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Nexata Jesús Pedro jume baraichi, jeye: —Bara xainyeya catsipaebatsi, po merawithe pewʉnaeya poxonae ainya jume cuiyobetha wacara pebto fibina, bapoxonae xam copiya acoibi po jume cuiyobetha neyabara jam tsane: ‘Jopa dapon yaitaeinyo’, neyabara jam tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ichitha Pedro equeicha jume daunweya, jeye: —Bara bequein capuna tʉpaeinchi ichitha baxua jopa cayabara paebi tsainchi, jei Pedro. Irʉrʉ daxita Jesús pijimonae tatsi bara jumichi, nanta jʉpiya paeba. ");
INSERT INTO cui_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nexata Jesús pijimonae barʉ patopa ichaxota tsica iriyo po iriyo pewʉn Getsemaní. Baxota Jesús barai pijimonae, jeye: —Xote abʉ paenare tha matha Taxatha tsipaebichi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesús barʉ pona Pedro irʉ Santiago irʉ Juan. Bapoxonae Jesús bichocono ʉnthʉthʉ wecoyei, yawa bichocono ʉnthʉthʉ deideijei. ");
INSERT INTO cui_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nexata barapo acoibi poyobetha Jesús barai, jeye: —Bichocono jʉntʉ coyene natsepiya wecoyan, tsipei muxu tatʉpae. Xote paenare, yawa payoyocare xua painya tanebarʉ naitaewatsinexam, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nexata Jesús tsiwiyo dabe natsixitabiya, irabe taeuncuareca, tsipei jopa juniya ajʉntʉtaneyo. Jesús yaputane xua bichocono tsiatene tsane xua daxita jiwi abe pia peexanae coyenein tatsi. Daxota Jesús Paxa wʉca xua icha itacʉpatsi xua jopa penantawenonaewa xua peatenewa. ");
INSERT INTO cui_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Bapoxonae Jesús Paxa tsipaeba, jeye: “Axa caitacʉpa xua daxita exaname. Icha ichichipame xua taneyawenaewam tsane, newepire pocotsiwa neajʉntʉtane exana. Ichitha jopa necana exanaeinde xua pocotsiwa ichichipan. Saya jame necana exande xua pocotsiwa ichichipame”, jei. ");
INSERT INTO cui_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nexata Jesús equeicha caibe iya ichaxota pijimonae jiwana tatsi taenatsi xua acoibi poyobe. Ichitha barapomonae maita. Jesús Pedro baraichi, jeye: —Simón, ¿maituncuame? ¿Jopa caitacʉpaeyo xua yoyocame xua jinya tanebarʉ naitaewatsinexam, mataʉtano xua bara cae horathano? ");
INSERT INTO cui_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Maisa payoyocare. Nacom patsipaebare xua jopa abe painya neexanaewa tsane poxonae caurimonae pia pentacaponaein tatsi piraichi paca jʉntʉ coyene jʉjʉta. Painya jʉntʉ coyene wetsina bichocono paichichipame xua Nacom painya netsipaebiwa, ichitha painya pepon bichocono paacoyenefaetabim xua painya netsipaebiwa Nacom. ");
INSERT INTO cui_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Equeicha Jesús bara nama caeto caibeya pona xua Paxa petsipaebinexa barapo jumetha, po jumetha copiya Paxa tsipaeba. ");
INSERT INTO cui_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bapoxonae equeicha Jesús pijimonae beya pona xua acoibi poyobe. Daichitha barapo acoibi poyobe came maitumena, tsipei bichocono itata tsacatsaquei xua itamaipana. Barapomonae jopa yaputaeyo xua Jesús petsipaebiwatsi poxonae yaichamaicha mata taenanaboumeinchi. ");
INSERT INTO cui_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bara nexata equeicha Jesús saya cuenta pona pijimonae, xua Paxa equeicha petsipaebinexa. Equeicha pijimonaetha patopa acoibi po cuiyobetha. Jesús jeye pijimonaetha: —¡Moya bara painya nepu maitumenaeinde, aunxuae jopa Nacom patsipaebim xua painya necayawenaenexa! Bayatha tsuxubi po horatha xua xan ponxaein Nacom Tananeitapetsin, ichʉn necaenaetaxubina ichamonaetha, pomonaetha pomonae peantʉcoyenebe jiwi. ");
INSERT INTO cui_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Panacosabapende, panonobapondeno. Antha bʉ poinchi. Dota dawerena pon necaenaetaxubina ichamonaetha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Poxonae Jesús cataunxuae tsipaebuncua pijimonae, bapoxonae Judas patopa. Bapon Judas doce poyobe jiwana caein pomonae Jesús pepa pijimonaexae tatsi. Judas pinmonae barʉ patopa Jesustha. Ichamonae cusin cajinjinca. Ichamonae iwabi cajinjinca. Daxota daxita barapomonae pata tsipei sacerdotemonae pia pentacaponaewi tatsi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, irʉ pomonae pitiri jiwirʉ daxita barapo pentacaponaewi itoroba barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas pon Jesús caenaetaxubinchi beya poxonae bapon patopa cou tsiwanaya paeba barapo pin bicheitotha cou Jesús yabara paebatsi, cou jeye: “Pon tsutsubin bapon apara barapo pebin Jesús. Nexata moya bara pawaetabare. Pacaponde xua soldadomonae xainwaicha pecʉtsinexa tsane”, jei Judas. ");
INSERT INTO cui_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nexata Judas Jesús imoxoyo caquita poinchi. Bapoxonae nainya Jesús jeichichi: —Pon jiwi Necuidubim, ¿xamda? jei Judas. Bapoxonae nainya Judas Jesús tsutsubatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nexata barapomonae pomonae Judas pebarʉ patopaexae, Jesús imoxoyo caquita umenarʉcʉpatsi. Bapoxonae Jesús waetabatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Caein pon Jesús pijimonae tatsi jiwana, bapon nainya cusi namara wejonta. Bapoxonae bapon muxuyoro catsoniba, pon sacerdotemonae pia pepa pentacaponaein tatsi tanacuitatsi bapon muxuyoro catsonibatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Bapoxonae Jesús jeye jiwitha: —Pacapatame cusin, yawa iwabi ichi be poxonae pacana ichim pontha pon jiwi pecaibin. ");
INSERT INTO cui_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Daxita matacabin Nacom pin pia botha tatsi paca barʉ poponeibatsi. Paca cuidubeibatsino. Daichitha bapoxonae jame jopa pana newaetabim. Ichitha daxita baxuan neyabara canacui jume weta exana, bayatha Nacom Pejume Diwesitha tana necui yabara wʉnae tsiwanaya paebixae pomonae Nacom peitorobi jume pepaebiwi. ");
INSERT INTO cui_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bapoxonae Jesús daxita pijimonae cuentarʉcʉpatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bapoxonae pewowin Jesús puna poinchi pon saya meisa paparuwatha naepa yaraba. Barapo pewowin waetabatsi pomonae Judas barʉ patopa. ");
INSERT INTO cui_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ichitha barapo pewowin nama xuetacuta pia paparuwa epato. Tamasa naetsiricua. ");
INSERT INTO cui_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pomonae Jesús teicatsi, barapomonae Jesús capoinchi pon sacerdotemonae pia pepa pentacaponaein tatsi pia bo tatsi beya, pon yatsicaya peainya cuin. Baxota irʉ sacerdotemonae pia pentacaponaewi tatsi nanacaetuta. Irʉ pitiri jiwino nanacaetuta. Baxota irʉ nanacaetuta pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Daxita barapo penacaetutsi jiwi, barapomonaetha jiwi wʉn duta “Pecanamata caitorobi jiwi bicheito”, jei. ");
INSERT INTO cui_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Irʉ Pedro Jesús tsiwiyo tajʉ pu taetae tsiniyatsi beya poxonae patopa panatha, po panatha ichaxota sacerdotemonae pia pepa pentacaponaein tatsi tauncuatsi bo. Poxonae Pedro pana tututha joniya bapoxonae naeca imoxoyo policiamonaetha pomonae Nacom pin pia bo tatsi pe-eenaewi. Pedro cui tane po coyeneya xua Jesús cana exanatsi pomonae nacaetuta. Pedro nonopeca isototha. ");
INSERT INTO cui_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sacerdotemonae pia pentacaponaewi tatsi, irʉ ichamonaeno pomonae pecanamata caitorobi jiwi bicheito, daxita barapomonae jeita ichamonae pomonae xua Jesús naerabiya peyabara paebinexatsi pocotsiwa xua Jesús paeba, xuano xua exana, pia barapo jumetha paebichi xua bara Jesús tʉpa peexanaewa tsainchi. Bara bequein pin bicheito pata xua Jesús abeya peyabara paebinexatsi, ichitha cataunxuae barapomonae pomonae pecanamata caitorobi jiwi bicheito came jopa xeinaeyo po diwesi xua daxota Jesús pebexubinexatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pinmonae bequein Jesús yabara naerabiya paebatsi, ichitha tsanaya barompaya pia diwesin paeba. ");
INSERT INTO cui_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ichamonae asiya umena, yawa naerabiya Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Barapomonae jeye: —Paxan pajume tan xua bapon Jesús paeba, jeye: ‘Xan abe exanaein barapo Nacom pin pia bo, po bo jiwi pia coutha acaba. Acoibi po matacabibe icha bo equeicha exanaein po bo jiwi jopa exanaeyo’, jei Jesús, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Daichitha barapomonae awiya came cataunxuae tsanaya barompaya ichawan paeba. Barapomonae pia pepaebiwan xua Jesús peyabara paebiwatsi jopa pebʉrʉya nanta jʉpaya nanta xeinaeyo. ");
INSERT INTO cui_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bapoxonae sacerdotemonae pia pepa pentacaponaein tatsi asiya uncuataba xua daxita peitabaratha tatsi. Bapoxonae bapon Jesús yainyabatsi, jeichichi: —¿Jopa jume notsim barapomonae? ¿Bara xainyei xua po jumein barapomonae cayabara paeba? jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Daichitha Jesús saya moya uncua. Jopa jume notsiyo bapontha. Daxota equeicha sacerdotemonae pia pepa pentacaponaein tatsi jeye Jesustha: —¿Bara yatsicaya xam Mesías pon Nacom necaitorobin, pon Nacom Pexantom, po Nacom wʉnae pajainteiban? jei bapon. ");
INSERT INTO cui_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Bapoxonae Jesús jume nota bapontha jeye: —Aa, bara xan tsocuaein apara, Nacom Pexanton apara. Paxam pana netaename xua xan ponxaein Nacom Tananeitapetsin ecaein Nacom pecoxa weya tatsi, pon peayapusʉ itorobi coyenewa pexeinaein. Mataʉtano pana netaename poxonae equeicha patopeicaein tsaquinaebowantha xua peitaboco wetsica, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nexata bapoxonae sacerdotemonae pia pepa pentacaponaein tatsi, pin anaetha anaya pia paparuwa nata tsitsinaxuba, peyabara anaepanaexaetsi Jesús, jeye: —¡Nama equeicha jopa wanantawenonaewa ichamonae xua wanaca tsipaebiwa tsane xua bapon peyabara paebiwatsi! Bapon natsiaenae exana abe pepaebixae barapo jume poxonae Nacom pexanto najainta. ");
INSERT INTO cui_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bara paxam pajume taneme pocotsiwa bapon paeba pocotsiwa Nacom jopa ichipaeyo. ¿Eta xua pacayabara nanta xeiname xua paexanaename bapontha abe pepaebixae? jei. Daxita barapo pecanamata caitorobi jiwi bicheito jeye: —Bara xainyeya paebame. Jesús abe pia pepaebixae, Nacom tsitatsi xua bapon Nacom tsita natsicuentatsi. Daxota bapon bewa tʉpaena, jei barapo pecanamata caitorobi jiwi bicheito. ");
INSERT INTO cui_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bapoxonae barapomonae jiwana, peonetha Jesús anaya itabara subabatsi. Poxonae Jesús itacuere cʉtatsi, bapoxonae Jesús itabara tsaquibacotatsi pecobetha. Barapomonae jeye Jesustha: —Incane pana netsipaebare: ¿Jintam caitabara tsaquibobara xua bequein paca itabara cʉtatsi? jei barapomonae. Bapoxonae irʉ policiamonae pomonae Nacom pin pia bo tatsi peenaewi Jesús itabara cuaintatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Poxonae cataunxuae Jesús cana exanompatsi bapoxonae irʉrʉ Pedro eca panatha tsica xua bo peʉma werena. Bapoxonae yabʉyo patopa powa sacerdotemonae pia pepa pentacaponaein tatsi tanacuitatsi. ");
INSERT INTO cui_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Poxonae barapowa Pedro tainchi xua nonopeca, Pedro came taeuncuatsi. Pedro jeichichi: —Apara xam bayatha irʉrʉ napuna poneibame Jesús, pon Nazaret tomarapin, jei yabʉyo. ");
INSERT INTO cui_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ichitha Pedro jume matawenta bapowa, jeye: —Jopa dapon yaitaeinyo, mataʉtano jopa yaputaeinyo pocotsiwa xua yabara paebame, jei Pedro. Bapoxonae Pedro pona bomʉxʉ coiboto beya. Bapoxonae wacara pebto fiba. ");
INSERT INTO cui_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Equeicha bapowa Pedro tainchi. Bapoxonae bapowa tamropata pitaba xua tsipaeba pomonaetha pomonae baxota irʉ umena. Bapowa Pedro yabara paebatsi, jeye: —Apara bapon pomonae Jesús pijimonae tatsi jiwanapin, jei. ");
INSERT INTO cui_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Equeicha Pedro jume matawenta bapowa, jeye: —Jopa dapon yaitaeinyo, jei Pedro. Pirapaeyo pomonae umena baxota equeicha Pedro tsipaebatsi jeichichi: —Bara xaniwaicha barapomonae jiwanam. Apara xam Galilea nacuapim, jei pomonae umena. ");
INSERT INTO cui_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nexata Pedro jume daunweya, jeye: —Bara Nacom peitabaratha xainyeya paca tsipaebatsi pocotsiwa bara xainyeya tapaebiwa. Icha jopa xainyeya paca tsipaebichipaetsi metha barabʉ Nacom abe necana exanaetsipa. Equeicha paca tsipaebatsi: ‘Jopa dapon yaitaeinyo’, xuaunxuae pon payabara paebame, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bapoxonae irʉrʉ caena nainya wacara pebto equeicha fiba. Nexata Pedro nanta xeinataba xua bayatha Jesús Pedro tsipaebatsi poxonae jeye: ‘Xam barapo merawithe pewʉnaeya poxonae ainya jume cuiyobetha wacara pebto fibina xam copiya acoibi po jume cuiyobetha neyabara jam tsane: Jopa dapon yaitaeinyo neyabara jam tsane. Bapoxonae nainya irʉ wacara pebto fibina’, jeichichi Pedro xua Jesús paeba. Nexata bapoxonae Pedro bichocono wecoyei peanthʉthʉtanexae xua Jesús peyabara paebiwatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Poxonae pentha tsina sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ judiomonae pia pitiri jiwi tatsi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenein tatsi, irʉrʉ ichamonae pomonae pecanamata caitorobi bicheito jiwi jiwana, daxita barapomonae yabara nacaetuta xua nanta jʉpaya pebʉrʉya penanta xeinaenexa po coyeneya xua Jesús pebexubiwa tsainchi. Bapoxonae barapomonae Jesús maxʉ cʉtatsi. Bapoxonae capoinchi Pilato beya. ");
INSERT INTO cui_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato Jesús yainyabatsi, jeye: —¿Bara xam yatsicaya judiomonae itorobiya pia pepa neewatsin? jei. Jesús jume nota, jeye: —Xuaunxuae paebame bara baxua apara, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sacerdotemonae pia pentacaponaewi tatsi namchi Pilatotha, jeye: —Bapon Jesús bichocono exana pocotsiwa xua abe, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Equeicha Pilato yainyaba Jesustha, jeye: —¿Jopa jume notsim pocotsiwa barapomonae abe cayabara paeba? Maisa barapomonae bichocono abe cayabara paeba, jei Pilato. ");
INSERT INTO cui_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ichitha Jesús jopa equeicha jume notsiyo, Pilato jopa jume notichi. Daxota Pilato najʉntʉ coyene cabenaeca poxoru Jesús jopa nayabara paebiyo xua pia coya penayawenaenexa. ");
INSERT INTO cui_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bara nama matacabi jopa poxonae ba Pilato pia cui xeina poxonae ba jiwi tsinacaetuta pexaewa penanabanaenexa. Barapo matacabitha Pilato ba pu sotaba pon ba jiwi itapeta cowai xua Pilato peisanaxubinexa pomonae jiwi pecʉbi botha peenaewi jiwanamonaepin. ");
INSERT INTO cui_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Barapo jiwi pecʉbi botha irʉrʉ eca pon pewʉn Barrabás. Bapon bichocono abe peexanaein tsipei caena bayatha matacapona ichamonae xua barapomonae najume tsacaba cana exanatsi xuano xua jiwi jutebatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bapoxonae pin bicheito jiwi pata Pilatotha, xua Pilato pewʉcaenexa tsainchi xua bapon exanaena pia cui coyeneya poxonae xua isanaxubina caein pomonae jiwi pecʉbi botha peenaewi jiwanapin. ");
INSERT INTO cui_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bapoxonae Pilato yainyaba barapomonae Jesús yabara, jeye: —¿Paichichipame xua tapu sotabiwa tsane pon judiomonae itorobiya pia pepa peewatsinchi? jei. ");
INSERT INTO cui_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Baxua Pilato paeba, tsipei bapon yaputane xua sacerdotemonae pia pentacaponaewi tatsi Jesús uwatsi. Daxota barapomonae Jesús caenaetaxubatsi Pilatotha. ");
INSERT INTO cui_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ichitha barapo sacerdotemonae pia pentacaponaewi tatsi jiwi jume cui tsacabatsi xua anaepana cana exanatsi, xua Pilato pecui itorobinexatsi xua Barrabás pepu sotabinexatsi, xua Jesús jopa pepu sotabinexatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Equeicha Pilato yainyaba barapo jiwi, jeye: —¿Eta xua cana exanocuaein pon pawʉn dutame, xua pajam: ‘Judiomonae itorobiya pia pepa peewatsinchi?’ pajam, jei. ");
INSERT INTO cui_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Barapomonae Pilato daunweya jume notatsi, jeye: —¡Bewa maisa naetotha tʉparucua exanaem! jei. ");
INSERT INTO cui_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bapoxonae Pilato jeye barapomonaetha: —¿Eta pocotsiwa xua metha jane, xua abe exana? jei. Ichitha equeicha daʉmetha jume daunweya, jeye: —¡Bewa maisa naetotha tʉparucua exanaem! jei. ");
INSERT INTO cui_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato ichichipa xua bapon jopa peita aenae-aeneiwatsi jiwi. Daxota Pilato Barrabás nama pu sotabatsi. Bapoxonae Pilato itoroba xua soldadomonae bara Jesús moya pecuainchinexatsi pocotsiwatha eewa xua bichocono amʉpiya xua xota jiwi cuainteibatsi poxonae abe exaneiba. Mataʉtano itorobano xua moya bara Jesús tʉparucua exanaeinchi naetotha. ");
INSERT INTO cui_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bapoxonae soldadomonae Jesús capoinchi Pilato pia bo tatsi beya po soldadomonae yapu eena Pilato pia bo tatsi. Bapoxonae barapo soldadomonae waba icha soldadomonae xua daxita barapo soldadomonae Jesús pematawacaicha umenaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Bapoxonae Jesús pia paparuwa juma xuenatsi. Yawa juma xatatatsi icha paparuwa po paparuwa tsobia xua Jesús be pecana exanaenexatsi pon jiwi itorobiya pia pepa peewatsinchi. Yawa poxonae nacobe weta xua fata pee bapoxonae Jesús muxuna mata xatatatsi barapo pee tepa. ");
INSERT INTO cui_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bapoxonae barapomonae tamropata notarʉcʉpa xua Jesús cui caponaeya jeichichi: —¿Xamda? ¡Apara xam barapom pon judiomonae itorobiya pepa Neewatsin! jei. ");
INSERT INTO cui_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Po naewa xua Jesús cobenatatsi bayatha, barapo naewa Jesús cobe wepitatsi. Bapoxonae barapo naewatha Jesús mata cuaintatsi. Mataʉtano Jesús yabara naone subabatsi. Bapoxonae barapomonae Jesús peitabaratha tatsi pentabocototha taumeinchi, xua Jesús naerabiya wʉnae pejainchinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Poxonae Jesús cana cui wetatsi xua cui caponatsi equeicha bapoxonae Jesús caewa juma wejontatsi xua po paparuwa tsobia. Bapoxonae equeicha caewa juma xatatatsi po paparuwa pia paparuwaxae tatsi. Bapoxonae Jesús capoinchi xua pecobe matabobinexatsi naetotha pebexubinexatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Poxonae Jesús namtotha caenapoinchi soldadomonae, bapoxonae barapo soldadomonae taeba pebin, pon Cirene tomarapin pon pewʉn Simón. Bapon wexua werena pona. Bapon Alejandro paxa tatsi, irʉ xua Rufo paxa tatsi. Bapoxonae barapo soldadomonae Simón itorobatsi xua pecaponaenexa Jesús pia naeto tatsi, po naetotha tʉparucua peexanaenexatsi Jesús. ");
INSERT INTO cui_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bapoxonae Jesús capoinchi uruto beya, po uruto be jiton matasipa piwa, daxota barapo uruto jiwi wʉn unuta “Gólgota”, jei. ");
INSERT INTO cui_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Baraxotiya Jesús apatatsi vino mera, po vino mera equeicha muxuna epareca mirra mera matawʉn po mera bichocono atsu. Ichitha Jesús jopa apaeyo. ");
INSERT INTO cui_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mataʉtano bapoxonae Jesús tʉparucua exanatsi. Bapoxonae barapo soldadomonae nata tsaba Jesús pia paparuwan tatsi. Barapomonae bebeya ibotixi penacueranta notsinexa Jesús pia paparuwan tatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Poxonae baya a las nueve tsuxubi, bapoxonae Jesús tʉparucua exanatsi naetotha. ");
INSERT INTO cui_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jesús pentutu wetsica tadutatsi napaewa xua barapo napaewatha tina. Barapo petinae dutsiwa Jesús yabara jeichichi: “Baponje apara judiomonae itorobiya pia pepa peewatsinchi”, jei barapo petinae dutsiwa. ");
INSERT INTO cui_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Irʉrʉ ponbe jiwi pecaibinbe tʉparucua exanatsi naetotha imoxoyo ichaxota Jesús ducua. Ichʉn Jesús petsocona wetarucuiyatsi, ichʉn pecoxa wetarucueinatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Poxonae barapomonae baxua exana, bara barapomonae yabara jume cui weta pocotsiwa xua bayatha Nacom Pejume Diwesitha Mesías yabara paebatsi xua jiwi paeba, xua jeye: “Bapon pomonae abe peexanaewi jiwana”, jei. ");
INSERT INTO cui_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pomonae Jesús xenta poinchi barapomonae Jesús cui capoinchi. Yawa Jesús yabara itata naichaquebatsi. Barapomonae jeye Jesustha: —¡Xam bayatha jam: ‘Nacom pin pia bo abe exanaein, bapoxonae equeicha acoibi po matacabibe xanebin’, jam! ");
INSERT INTO cui_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Moya bara jinya coutha nacapanepare naeto wetsica icha bara metha Nacom Pexantom tsipaem! jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Irʉ sacerdotemonae pia pentacaponaewi tatsi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, barapomonae Jesús cui capoinchi, yawa najei Jesús yabara: —Bapon cain capanepeibabei ichamonae, came jopa nacapanepaeyo. ");
INSERT INTO cui_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Icha bara bapon Mesías, pon israelmonae itorobiya pia pepa peewatsinchi, bʉ bapon bara pia coutha naeto wetsica ecoinca! ¡Xainya bapoxonae jume cowʉntatsi xua wataexae tsane! najei barapomonae. Barichirʉ baxua paebabe ponbe jiwi pecaibinbe, ponbe xua irʉrʉ cobe matatabadutatsibe naetotha. Baponbe irʉrʉ Jesús cui caponatsi. ");
INSERT INTO cui_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Poxonae Jesús cataunxuae ducua naetotha, bapoxonae daxita nacuantha bichocono aitaquiri xua poxonae mateinyaxae weya, beya yatabopiya. Tres po horabe quirei tsuncuae. ");
INSERT INTO cui_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bapoxonae Jesús jume daunweya wawai jeye: “Eloi, Eloi, ¿lema sabactani?” jei, (barapo jumetha xua jei: “Tanacom, Tanacom, ¿eta pocotsiwa metha nepunaxubame?” jei Jesús.) ");
INSERT INTO cui_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ichamonae pomonae baxota Jesús jume taeumeinchi, barapomonae jeye: —Pajume taema, bapon waba, Elías wabatsi, pon Elías Nacom peitorobi jume pepaebin pon caena bayatha tʉpa, jei. ");
INSERT INTO cui_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Bapoxonae caein bapomonae jiwana nainya cuinaepoinya yawa pitaba esponja xua baxota pemene capichinexa vino mera xua po mera mene atsu. Poxonae bapon baxota mene capita, naewatha duta xua Jesús petayoichaenexatsi xua petsutsubinexa. Bapon jeye: —Abʉ, abʉ jopa apatsinde. Waxainchi abʉ matha taeinchi icha Elías patopeicaena xua bapon pepichinexatsi naeto wetsica, jei. ");
INSERT INTO cui_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Bapoxonae Jesús jume daunweya wawai. Bapoxonae nama tʉpanaicha Jesús. ");
INSERT INTO cui_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bapoxonae paparuwa, po paparuwa Nacom pin pia botha tatsi ducua, barapo paparuwa nainya bopiya epa matonta tsitsiqueica ainya epatobe naexanabe. ");
INSERT INTO cui_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Soldadomonae pia pentacaponaein tatsi, pon romanomonaepin pon Jesús peitabaratha tauncuatsi, poxonae bapon tane xua Jesús tʉparucua, bapon jeye: —Apara bara yatsicaya bapon Nacom pepa Pexanto tatsi, jei. ");
INSERT INTO cui_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Barichi irʉ ainyawaxi yabʉxi barapowaxi Jesús tsiwiyo tajʉ wetaeumeinyatsi. Barapowaxi jiwana, ichowayo pewʉn María Magdalena, powa Magdala tomarapiwayo. Ichowayo irʉ pewʉn María, Santiago pon xuyapin, irʉ José matapin, baponbe penabe tatsi. Ichowayo irʉ pewʉn Salomé. ");
INSERT INTO cui_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Barapowaxi Jesús bayatha matha puna jinompatsi xua Jesús peyawenaenexatsi xua poxonae Galilea nacuatha popona. Irʉ ichowaxi yabʉxi pinmonae powaxi Jesús barʉ patopa Jerusalén tomaratha. ");
INSERT INTO cui_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Po mataqueitha pewʉn penacui xaxainchi matacabi poxonae judiomonae ba weta daxita xua penacuichiwa pewʉnaeya poxonae jopaena pentaquei seicae matacabi, poxonae quirei tsanaicha barapo penacui xaxainchi matacabitha bapoxonae patopa pebin Pilatotha. ");
INSERT INTO cui_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Bapon pon pepatopaexae bapon pewʉn José, pon Arimatea tomarapin. Bapon pomonae pecanamata caitorobi jiwi bicheito jiwanapin. Bapon barʉ cui itura jineibatsi jiwi. Bapon yabara jume cowʉntsiya wʉnae ewateiba po coyenewa xua poxonae Mesías patopaetsica pon jiwi itorobiya peewetsinexatsi. José ajʉntʉcoyenetsaquiya patopa Pilato pia xantha tatsi pewʉcaenexa Jesús petʉpaein. ");
INSERT INTO cui_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bapoxonae Pilato yabara najʉntʉ coyene cabenaecataba xua bayatha Jesús tʉpa. Daxota bapon itoroba soldadomonae pia pentacaponaein tatsi pia yaputaetsi po coyene xua eta poxonae bayatha tʉpa. ");
INSERT INTO cui_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Poxonae barapo soldadomonae pia pentacaponaein tatsi paeba xua pinae bayatha Jesús tʉpa, bapoxonae Pilato copata xua José bara pichina Jesús petʉpaein. ");
INSERT INTO cui_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bapoxonae José pexeinya paparuwa comota. José naeto wepichica Jesús petʉpaein. Yawa mata quiyontabareca barapo pexeinya paparuwatha. Bapoxonae José ibo mʉthʉ iya boya Jesús petʉpaein. Yawa torenababapoinya pin ibo panawa. Yawa barapo ibo panawatha yauxatatabanota. ");
INSERT INTO cui_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, powa Magdala tomarapiwayo irʉ icha María powa José pena tatsi, barapowabe tanebe ichaxota Jesús petʉpaein boyatsi. ");
INSERT INTO cui_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nexata barapo judiomonae pia pentaquei seicae matacabi tatsi yapucaewaba poxonae quirei tsanaicha xua icha matacabi jopa. Bapoxonae María Magdalena, powa Magdala tomarapiwayo, irʉ icha María powa Santiago pena tatsi, irʉ ichowayorʉ powa pewʉn Salomé, daxita barapowaxi comoca petuxueiwan peponaenexa xua Jesús peperʉ epababinexatsi petʉpaein. ");
INSERT INTO cui_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bapoxonae baya caemʉmbotha, po matacabitha xua nanta carucua cae semanatha, barapowaxi capata petuxueiwan ichaxota Jesús ibo mʉthʉ iya boyatsi. Bapoxonae xometo pichatabina. ");
INSERT INTO cui_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Barapowaxi caewaxi natsipaebenapona, najei: —¿Jintam metha nacata pataxubina barapo ibo panawa xua yauxatatababotatsi? najei. ");
INSERT INTO cui_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Daichitha poxonae barapowaxi taerʉcʉpa xua po pin ibo panawatha yauxatatababota barapo ibo mʉthʉ bayatha cou yaupataxubanota. ");
INSERT INTO cui_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Barapowaxi jojoniya barapo ibo mʉthʉ iya. Barapo ibo mʉthʉ tutu iya pewowin eca po muxunene pecoxa weya. Bapon nama xatata paparuwa, po paparuwa bichocono apiya yawa bichocono inyapana. Barapo yabʉxi bichocono junuwa, pewowin cunuwatsi. ");
INSERT INTO cui_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ichitha barapo pewowin jeye barapo yabʉxitha: —Jopa pajunuwinde. Paxam pajeitame Jesús Nazaret tomarapin, pon bayatha naetotha tʉpa. Ichitha bapon anoxuae xote jopa bocaeyo. Bayatha asʉ petʉpae cuiru coyene weya. Pataema ichaxota Jesús bayatha botatsi petʉpaein. ");
INSERT INTO cui_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bara paponare, yawano patsipaebare Pedro irʉ ichamonae pomonae Jesús pijimonae tatsirʉ. Nexata pajande: ‘Bepa Jesús paca tsiwana patopiyaei Galilea nacua beya poxonae bara bepaiyiyaename. Bapoxonae baxotiya pataename bapon icha be pocotsi coyeneya paca tsipaeba bayatha’, pajande, jei pewowin barapo yabʉxitha. ");
INSERT INTO cui_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Barapo yabʉxi ibo mʉthʉ wejojondena. Yawa bara weya dʉcʉpa tsipei bichocono pijunuwi jijiyei. Barapo yabʉxi jopa paebiyo ichamonaetha poxoru bichocono junuwa. ");
INSERT INTO cui_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Poxonae Jesús asʉ exanatsiba petʉpaewa weya po mataqueitha opi carucua xua cae semanatha poxonae aena pentha, bapoxonae Jesús tsita naitʉta María Magdalena, powa Magdala tomarapiwayo. Barapowa caena bayatha Jesús taitaweta cauri siete poyobe xua bapowa xeina barapo cauri, xua equeicha bapowa jopa pexeinaenexa. ");
INSERT INTO cui_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Poxonae Jesús tainchi bapowa pona pemuxu tsipaebinexa pomonaetha pomonae anoxuae anthʉthʉtane yawa wecoyei xua Jesús petʉpaexae. Barapomonae bayatha Jesús pepuna jinompaewichi. ");
INSERT INTO cui_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Poxonae barapomonae jume tane xua juinya Jesús asʉ popona, yawa xua bapowa bayatha Jesús tainchi, barapomonae baxua jopa yabara jume cowʉntsiyo. ");
INSERT INTO cui_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pirapae bapoxonae equeicha Jesús tsita naitʉta pijimonae tatsi jiwanabetha icha cui coyeneyatha xua poxonae jopa xapain yaitaetsi poxonae namtotha pipatotha ecaponabe aisawatha. ");
INSERT INTO cui_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bapoxonae baponbe caibe nawiyabe. Yawa tsipaebabe ichamonaetha xua Jesús pijimonaetha tatsi xua po coyene bayatha Jesús baponbe tsita naitʉtatsibe. Ichitha barapomonae barichirʉ irʉ jopa jume cowʉntsiyorʉ barapo diwesi pocotsiwa baponbe paebabe. ");
INSERT INTO cui_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pirapae Jesús tsita naitʉta pijimonae pomonae once poyobe poxonae barapomonae pexaethopaewatha iratha ena. Jesús pin jumetha muxutaenaquiya exana xua jopa pejume cowʉntsixaetsi mataʉtano peyabara muxusipanaexaetsi mataʉta xua jopa peyabara jume cowʉntsixaetsi pocotsiwa paeba pomonae tane xua Jesús equeicha bayatha asʉ popona petʉpae cuiru coyene weya. ");
INSERT INTO cui_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús jeye pijimonaetha: “Paponare, daxita nacuantha beya. Patsipaebare daxita jiwitha barapo pecapanenebiyae diwesi jume. ");
INSERT INTO cui_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pomonae neyabara jume cowʉntsina xua xan apara Nacom Pexanton tatsi, mataʉtano xua bautisabatsi, barapomonae capanenebiyaeinchi xua jopa peweraweracaenexa. Ichitha pomonae jopa neyabara jume cowʉntsiyo xua xan Nacom Pexanton tatsi, barapomonae peraxa jʉbebinchi xua Nacom peyabara paebixae xua pinae barapomonae jopa jume cowʉntsiyo. ");
INSERT INTO cui_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","18","Pomonae neyabara jume cowʉntsina xua xan Nacom Pexanton tatsin muxuna exanaein xuaje pocotsiwe: Barapomonae taitawetsina ichamonae cauri poxonae tawʉntha wʉqueibina; mataʉtano barapomonae pena jumeintha cueicueijei tsane; icha barapomonae jomon notsina pecobetha, jopa barapomonae tʉpa exanae tsainchi jomon; mataʉtano icha barapomonae apaena po mera jiwi tʉpa exanatsi barapo mera jopa abe exanae tsainchi barapomonae; mataʉtano barapomonae itacʉpaeinchi xua jayabina pecobetha pomonae peatenewi, xua bapoxonae barapo peatenewi peaxaibinexa tsaibi tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesús pon jiwi Pecanamataxeinaeinchi, poxonae bapon najume weta xua cueicueijei pijimonaetha, bapoxonae Jesús asiya peitaboco beicha juinya exanatsi, xua Nacom exana. Bara xoteicha Jesús Paxa cuaretatsi pecoxa weya ainya cui peexanaenexatsi. ");
INSERT INTO cui_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bara barapomonae Jesús pijimonae tatsi ponarʉcʉpa. Yawano barapomonae cueicueijei tsurubenanaebiya jiwitha barapo pecapanenebiyae diwesi jumein daxita nacuantha. Bapon Jesús pon jiwi pepa Pecanamataxeinaeinchi yawena barapomonaetha. Mataʉtano Jesús cana exana barapomonaetha xua barapomonae muxuna exana pexeinya petsita itʉtsi coyenewan xua daxota pocotsiwa barapomonae cueicueijei jiwitha bara pexainyei jumein. Je, bara ichi tsane. Baja Marcos.");
INSERT INTO cui_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jaco Teófilo. Ponxaem nentʉ cui xanepanaein, cata tinatsi. Pinmonae bayatha xuya cou tina diwesi Jesús yabara, xua ichamonae cou paeba, xua pinae Jesús poxonae xanepanaya popona pata xantha. ");
INSERT INTO cui_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pomonae cou xua baxua pepaebixae barapomonae pinae copiya yatsicaewa tane daxita pocotsiwa Jesús exana pata xantha. Mataʉtano pinae barapomonae Nacom Pejume Diwesi tatsi cuidubeiba. ");
INSERT INTO cui_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Xan netsita wʉnae daxota nanta xeinan xua yabara tayainyabiwa pomonae petinaexae yawa pecueicueijeixae daxita barapo diwesin xua pinae juinya Jesús exana. Bapoxonae cuita cata tinapoinchi Teófilo jinya neyaputaenexa tsane daxita pocotsiwa Jesús exana juinya xua copiya tsoponae xuano xua bapoxonae tsoponaeno. ");
INSERT INTO cui_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Baraxua cata tinatsi jinya neyaputaenexa tsane barapo pexainyei jume po coyene ichamonae bayatha cacuiduba. ");
INSERT INTO cui_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Caena bayatha poxonae Herodes popona Judea nacuatha, xua pon Judea nacuapiwi peyanacua ewatsinchi, bapoxonaerʉ barichi popona barapo nacuatha sacerdotepin pon pewʉn Zacarías. Bapon jiwana po sacerdotepiwi pia matabʉxʉ jiwi pewʉn Abías. Piseuri tatsi pewʉn Isabel. Piseuribe pia pamo susato jiwanapin tatsibe, bapon pewʉn Aarón pon yatsicaya tabʉ ducua sacerdotepin. ");
INSERT INTO cui_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Piseuribe Nacom tsita jʉntʉ coyene xanepanatsibe xua bara xanepanaya peexanaewabe. Pocotsiwa Nacom pon jiwi Pecanamataxeinaein, nacana jume diwesi itoroba baxua itapeta beta exaneibabe. Daxota jopa yabara paebeibichibe jiwi po coyene xua baponbe natsiaenae cuentabe xua abe peexaneibiwabe. ");
INSERT INTO cui_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ichitha pexui jopa xeinaeyobe, tsipei Isabel mawecowa, mataʉtano tsipei bayatha acuewa irʉ tsipei pebin bayatha amo tsecae. ");
INSERT INTO cui_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Caentacabi poxonae Zacarías ʉ pia matabʉxʉ jiwi pia cuitha exana Nacom nexa, bapon Zacarías xuya piamonae itapetatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Barapomonae sacerdotemonae, pia cui coyene xeina xua caein piamonae jiwana itapetatsi poxonae daxita barapomonae nacuita Nacom pon jiwi Pecanamataxeinaein pin pia botha tatsi. Bapon Zacarías itapetatsi xua pejoniyaenexa po tutu peainya cui tutu Nacom pin pia botha po tututha ichaxota exaneiba xua Nacom nexa. Barapo tututha Zacarías tauta petuxusi exanaenexa Nacom nexa xua Nacom peitorobixae. ");
INSERT INTO cui_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Poxonae Zacarías cataunxuae tuxusi exanawiya petuxueiwa xua tauta Nacom nexa, barapoxonae daxita pomonae aisowa beumeinya barapomonae Nacom tsipaebompa. ");
INSERT INTO cui_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bapoxonae Zacarías tsita naitʉtatsi matatsunpin pon Nacom pon jiwi Pecanamataxeinaein itoroba. Po muxunene pecoxa weya matatsunpin iboto caquita uncua po ibototha xua ichaxota tauteiba petuxueiwa Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Poxonae Zacarías taeba matatsunpin jopa yaputaeyo xua peexanaewa, bichocono pejunuwixae. ");
INSERT INTO cui_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ichitha matatsunpin Zacarías baraichi, jeichichi: —Zacarías, jopa junuwinde. Nacom bara cajume tane poxonae tsipaebeibame bapon. Methaunxuae jinseuri Isabel tanaexanaeinchi pexuyo. Jinseuri cata pabetsina pebin wʉto. Xam wʉn dutsiname bapontha, po wʉn Juan, jei. ");
INSERT INTO cui_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jʉntʉ coyene weiweinaename. Barichi pinmonae jʉntʉ coyene weiweinaena xua bapon penaexanaexae tsane. ");
INSERT INTO cui_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Bapon Juan Nacom pon jiwi Pecanamataxeinaein tsita ainya cui tsainchi. Bapon peatsaxae mera jopa apae tsane. Vino mera jopa apae tsaneno. Poxonae cataunxuae bʉtiyotha eca bichocono jʉntʉ coyene yʉcaeinchi Nacom pia Pejumope tʉnaxʉ tatsi pia peayapusʉwa tatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bapon cana exanaena xua ainya Israel nacuapiwi jume cowʉntsina Nacom pon Pecanamataxeinaein jiwi xua barapomonae barapo Nacom pia Nacom tatsi tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan tsiwanaya poponaena xua pon xua Nacom itorobina bapon tsiwanaya poponaeinchi. Juan xeinaena Nacom pia Pejumope tʉnaxʉ tatsi pia peayapusʉwa tatsi icha cain Elías ichi pon Nacom peitorobi jume pepaebin. Bapon Elías bayatha tʉpa. Juan exanaena xua pexui paxeiwi antobe tsaibi tsainchi. Mataʉtano Juan cana exanaena xua jume cowʉntsina Nacom pomonae copiya Nacom pejumefebiwichi. Tsipei exanaena baxua, barapomonae tsiwanaya jume cui yabara najʉntʉ coyene wʉnaetsina, xua barapomonae pejume cowʉntsinexa Nacom pon Pecanamataxeinaein jiwi, jei matatsunpin. ");
INSERT INTO cui_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías yainyaba matatsunpin, jeye: —¿Eta nejumichim yatsicaewara xua inta naexanaena pexuyo? Apara xan amo tsecaein. Irʉ tapetsiriwa apara inta acue tsecaeba, jei. ");
INSERT INTO cui_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Matatsunpin Zacarías jume notatsi, jeye: —Apara xan Gabriel. Barapara Nacom ba imoxoyo caquita uncueiban. Nacom neitoroba bepara catsipaebichei barapo pexeinya jume diwesi. Daxota yatsicaya naexanaenaba nexanto. ");
INSERT INTO cui_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Incane jume taema. Yaitama jame maisa aunxuae jopa yabara nejume cowʉntsim, daxota methaunxuae jopa cuinaya paebim tsane. Yajume aunyeibiya yantacabi jopaename poxonae beya abʉ nexanto naexanaena xuaunxuae catsipaebatsi, jei. ");
INSERT INTO cui_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Poxonae Zacarías tsipaebauyatsi, Zacarías pesato beya ewatumeinchi pomonae Nacom tsipaeba pesatotha. Barapomonae nabarai: “¿Eta pocotsiwa metha Zacarías came jopa jondenaeyo Nacom pin pia bo werena?” najei. ");
INSERT INTO cui_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Poxonae Zacarías matapainya jondena jopa itacʉpaetsi xua petsipaebiwa barapomonaetha. Bapoxonae barapomonae nanta xeina xua metha bara Zacarías tsita naitʉtatsi xua wʉnae barapo tututha poxoru Zacarías pecobetha cowai barapomonaetha. Ichitha awiya came jopa cueicueijeiyo. ");
INSERT INTO cui_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Poxonae Zacarías daxita nacobe weta xua exana Nacom nexa, Nacom pin pia botha, bapoxonae pia botha pona. ");
INSERT INTO cui_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pirapaeyo Zacarías piseuri tatsi Isabel bʉpana taecatsi pexuyo. Barapowa jopa naitʉtsiyo cinco po xometiyobe. Saya pia botha eca. ");
INSERT INTO cui_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Barapowa nabarai, jeye: “Baxua Nacom inta exana pon Tanecanamataxeinaein. Bapon baxua inta exana xua jiwi jopa aura tana neexanaewa tsane”, najei bapowa. ");
INSERT INTO cui_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Poxonae Isabel seis po xometiyobe yapucaewa poxonae pexuyo bʉpana taecatsi, bapoxonae Nacom itoroba matatsunpin, pon pewʉn Gabriel. Gabriel Nazaret tomara beitorobiyatsi po tomara eca Galilea nacuatha. ");
INSERT INTO cui_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gabriel patopa pesiwa ponaenexa yabʉyo, powa bapana jopa pebin pichiyo. Bapowa muxu pepichi pecotsiwa, pon pewʉn José. Bapon José David pia pemomoxi susato jiwana tatsi. Caena bayatha David Israel nacuamonae itorobiya pia pepa peewatsinchi. Barapowa powa José pecotsiwaxae tatsi pewʉn María. ");
INSERT INTO cui_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Matatsunpin Gabriel, patopa ichaxota María eca. Gabriel barai, María baraichi, jeye: —María jaco. Nacom itapeta cayabara tsita jʉntʉ coyene xanepanatsi beyacaincha icha yabʉxi. Mataʉtano barapara Nacom pon jiwi Pecanamataxeinaein cabarʉ popona, jei matatsunpin. ");
INSERT INTO cui_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ichitha poxonae jume taeba bapowa, yabara jume cuitaya nabenaeca. Pia coutha nayainyaba jeye: “¿Eta xua bapon nejacoba jane?” najei. ");
INSERT INTO cui_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Matatsunpin María baraichi, jeichichi: —María, jopa junuwinde, Nacom cayabara tsita jʉntʉ coyene xanepanatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Matha taema xam methaunxuae pexuyo yapʉrʉwa jinaename xuano bara pabetsiname nexanto. Bapoyo wʉn dutsiname po wʉn Jesús. ");
INSERT INTO cui_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Bapon ainya cui peexanaeinchi tsainchi. Bapon wʉn dutinchi, icha wʉn jei tsainchi: ‘Nacom Pexanto tatsi pon peitabocotha eca’, jei tsainchi. Nacom pon Pecanamataxeinaein jiwi, bapon pexanto cana exanaena xua bapon jiwi itorobiya pia pepa Peewatsinchi tsane icha matha David cana ichichi, pon Jesús pia pamo susato jiton tatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Bapon yacui tsitecaena xua jiwi peewatsinchi penaexanaewa tsane Israel piamonae susato saineiwi pexantha tatsi. Pia peitorobi coyenewa tatsi jopa weraweracae tsane, jei Gabriel, pon matatsunpin. ");
INSERT INTO cui_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nexata María jume nota matatsunpin, jeye: —¿Eta xua yapʉrʉwa jinocuaein pexuyo? Apara cataunxuae jopa nacueyabinyo, jei María. ");
INSERT INTO cui_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Matatsunpin jume nota, jeye: —Nacom pia Pejumope tʉnaxʉ tatsi cata patopeicaena. Mataʉtano Nacom pon bichocono pepa pejʉntʉ coyene xanepanaein bapon, pia peayapusʉwa tatsi cantatsun matawacaicha nontsicaena icha be tsaquinaebowa ichi tsane. Daxota po pexuyo naexanaena, barapo pexuyo Nacom tsita jʉntʉ coyene xanepanaeinchi. Barapo pexuyo yabara jei tsainchi: ‘Nacom Pexanto tatsi’, jei tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Irʉrʉ barichi jinyamonaewayo Isabel, bequein bara acue tsecae, ichitha anoxuae pexanto yapʉrʉwa jina. Anoxuae barapowa seis po xometiyobe yapucaewa xua yapʉrʉwa jina bequein copiya mawecowa. ");
INSERT INTO cui_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dapocotsiwa aibi pocotsiwa Nacom tsita ayapubetsi, tsipei bapon daxita bara yaputane. ");
INSERT INTO cui_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nexata María namchi, jeye: —Xan bara barapowayʉn xua taexanaewayon pocotsiwa Nacom pon jiwi Pecanamataxeinaein neitoroba. Bʉ moya bara Nacom inta exanaena xuaunxuae netsipaebame, jei María, matatsunpintha. Bapoxonae matatsunpin napitaba. ");
INSERT INTO cui_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pirapaeyo María nainya pontaba tomara beya, po tomara eca ichaxota ira marafofowa xua Judea nacuatha. ");
INSERT INTO cui_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Baxota barapowa María joniya Zacarías pia botha tatsi. Bapoxonae Isabel jacobatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Poxonae Isabel jume tane xua María jacoba, bapoxonae pia pexuyo tsiperʉ natsixibecatsi Isabel. Bapoxonae Nacom pia Pejumope tʉnaxʉ tatsi pia peayapusʉwa tatsi Isabel jʉntʉ coyene yʉcatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Bapoxonae Isabel jume daunweya wawai xua María baraichi, jeye: —¡Nacom cayabara tsita jʉntʉ coyene xanepanatsi beyacaincha icha yabʉxi! ¡Barichi nexanto Nacom yabara tsita jʉntʉ coyene xanepanatsi! ");
INSERT INTO cui_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Xam powa Tanecanamataxeinaein pena tatsim, bichocono auran xua tana nesiwa ponaewam tsipei jopa taainya cuiwayon! ");
INSERT INTO cui_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Poxoru poxonae cajume tainchi xua nejacobame bapoxonae pexuyo netsiperʉ weiweinaya natsixibeca. ");
INSERT INTO cui_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jʉntʉ coyene weiweiname nejume cowʉntsixae tsipei bara nayabara jume cui wetsina pocotsiwa Nacom pon jiwi Pecanamataxeinaein yabara catsiwʉnae muxu duta pon Pecanamataxeinaein jiwi xua poxonae matatsunpin catsipaeba, jei Isabel. ");
INSERT INTO cui_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nexata María namchi, jeye: “Tajʉntʉ coyene Nacom wʉnae jaintatsi pon jiwi Pecanamataxeinaein. ");
INSERT INTO cui_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mataʉtano tajʉntʉ coyene Nacom yabara weiweinatsi pon Tanecapanepaein. ");
INSERT INTO cui_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nacom neweyatane xua xan saya tapawin. Bara barapowayʉn, powayʉn xua taexanaewa pocotsiwa Nacom neitoroba. Anoxuae xuano bexa tsaneno daxita jiwi pomonae naitapataya naexanaponaena wʉnae nejainchina tsipei Nacom nejʉntʉ coyene weiweina exana bichocono beyacaincha icha yabʉxi. ");
INSERT INTO cui_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bapon Nacom pon peayapusʉ itorobi coyene pexeinaein inta bichocono wʉnae exana. Bapon Nacom pepa pejʉntʉ coyene xanepanaein. ");
INSERT INTO cui_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Bapon Nacom yaweneibina jiwi pia peantobewaxae pomonaetha pomonae copiya pecunuweibixaetsi. ");
INSERT INTO cui_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nacom tsita itʉba xua peayapusʉ itorobi coyenewa xeina. Baxua exana poxonae jʉntʉ coyene amanayaba pomonaetha pomonae atsaquiya penayabara paebiwi xua ichamonae peaebiwichi. ");
INSERT INTO cui_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nacom cui pita cana exana pomonaetha pomonae pecanamataxeinaewi xua equeicha barapomonae jopa naexanae tsane xua pecanamataxeinaewa jiwi. Ichitha nama pomonaetha pomonae pecui pawi naexana barapomonaetha Nacom cana exana xua barapomonae penaexanaewa pomonae pecanamataxeinae jiwi. ");
INSERT INTO cui_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Pomonae xua piyain barapomonaetha Nacom cana exana xua barapomonae petonsanaewa xua penabanaewa po pexaewa pexeinya pexaewan. Mataʉtano copei pexeinaewi barapomonaetha Nacom cana exana xua barapomonae pecobesainaewa. ");
INSERT INTO cui_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Nacom yaweneiba pijimonae Israel nacuapiwi pomonae pia pamo susatopin tatsi, bapon Israel pon tanacuita Nacom. Nacom jopa yabara jʉntemainaeyo xua peyaweneibiwa barapo pijimonae peantobexae. ");
INSERT INTO cui_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nacom daxita exana pocotsiwa Abraham wamo susatopin yabara tsiwʉnae muxu dutatsi xuano xua yabara tsiwʉnae muxu dutatsi pia pemomoxi susato jiwi tatsi”, jei María. ");
INSERT INTO cui_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María cataunxuae acoibi po xometiyobe eca Isabel pia botha tatsi. Bapoxonae equeicha caibe nawiya pia bo beya. ");
INSERT INTO cui_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nexata Isabel xua bʉpana taecatsi pexuyo, perʉ cui nauchitane. Bapoxonae pexuyo tanowaeincuatsi xua pexanto. ");
INSERT INTO cui_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pomonae Isabel pia botha petaenaewichi, irʉrʉ piamonae tatsi pomonae pecuariya petaenaewichi daxita barapomonae Isabel siwa poinchi xua pejacobinexa tsainchi. Barapomonae yaputane xua Nacom pon Pecanamataxeinaeinxae jiwi Isabel beta taexanatsi poxonae Isabel dacotsiwa taitorobatsi pexuyo. ");
INSERT INTO cui_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Poxonae ocho po matacabibe yapucaewa barapoxonae pexuyo wi thabatsi xua pebin wʉtoxae xua ichaxota nareixacaeca. Barapomonae nanta xeina xua pexuyo wʉn dutsinchi po wʉn pexuyo paxa tatsi xeina, xua po wʉn “Zacarías”, jei. ");
INSERT INTO cui_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ichitha pexuyo pena tatsi namchi barapomonaetha, jeye: —Jume, jame bewa jei: ‘Juan’, jei, jei pexuyo pena tatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Bapoxonae barapomonae Isabel baraichi, jeye: —¿Exua? Jinyamonae dapocotsi wʉn aibiba, po wʉn: ‘Juan’, jei, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nexata barapomonae moya pecobetha cowai Zacariastha. Mataʉtano pecobetha cowaya yainyaba, Zacarías yainyabatsi jeichichi: “¿Eta po wʉn jinya nexanto wʉn dutsichi?” jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías wʉca napaewa petinaenexa tsane. Bapoxonae barapo napaewatha jei xua tina: ‘Apara pewʉn Juan’, jei. Bapoxonae barapomonae najʉntʉ coyene benaeca xua irʉ bapon namchi: ‘Bara pewʉn Juan’, jei. ");
INSERT INTO cui_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Poxonae baxua exana, caena bapoxonae jemeicha Zacarías equeicha caewa paeba. Equeicha ebato sadʉjei xua cueicueijei. Zacarías tamropata pitaba xua wʉnae jainta Nacom. ");
INSERT INTO cui_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Bapoxonae daxita pomonae imoxoyo jinompa ichaxota Zacarías piseuribe poponabe, daxita barapomonae junuwa. Mataʉtano pomonae xua pejinompaewi daxita ichaxota po ira xua marafofowa xua barapo Judea nacuatha, daxita barapomonae paebinouta pocotsiwa xua bayatha petaexae. ");
INSERT INTO cui_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Daxita pomonae jume tane, barapomonae najʉntʉ coyene yabara nanta xeina nawita. Mataʉtano caemonae nantiya nayainyaba najei: “¿Eta bichane metha pexuyo poxonae wichabina?” najei barapomonae. Apara poxoru Nacom pon Pecanamataxeinaein jiwi bichocono pexuyo petsita jʉntʉ coyene xanepanaexaetsi daxota barapomonae baxua paeba. ");
INSERT INTO cui_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pexuyo paxa tatsi Zacarías, jʉntʉ coyene yʉcatsi Nacom pia Pejumope tʉnaxʉ tatsi pia peayapusʉwa tatsi. Mataʉtano bapon cueicueijei po jumetha po jume Nacom cata. Zacarías namchi, jeye: ");
INSERT INTO cui_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nacom pon Pecanamataxeinaein jiwi, pon Israel pia Nacom tatsi, barabʉ wʉnae jainchinchi barapo Nacom. Tsipei bapon bayatha patopeica waxantha. Bapon bara piamonaetsi. Mataʉtano bapon bayatha naca capanepa. ");
INSERT INTO cui_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Pon Nacom nacata itorobica bapon pon jiwi pecapanenebiyaein pia peayapusʉwatha. Bapon David pia pemomoxi susato jiwana tatsi. Bapon David pon Nacom pia petanacuitinchi xua peexanaewa pocotsiwa Nacom itoroba. ");
INSERT INTO cui_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Caena bayatha Nacom yabara naca tsiwʉnae muxu duta, poxonae itoroba pia peitorobi jume petapaebiwichi xua wanaca tsipaebinexa. ");
INSERT INTO cui_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bara naca tsipaeba xua pinae bapon pon Nacom wanacata itorobicaexae, pinae naca capanepaena pomonae wanaca aitafaetabi jiwi pia xainya weya tatsi. Mataʉtano pinae naca capanepaena pomonae wanaca ita aenae-aenei jiwi pia xainya weya tatsi. ");
INSERT INTO cui_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mataʉtano Nacom naca tsipaeba xua pinae wamo susatopiwi yabara canantaxeinaeinchi xua peyawenaenexatsi. Mataʉtano pinae jopa jʉntemainae tsane xua wamo susatopiwi peyawenaponaewatsi xua bayatha Nacom yabara petsiwʉnae muxu dutsixae baxua. ");
INSERT INTO cui_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Baraxua Nacom naca tsiwʉnae muxu duta xua xainyeya bara paeba poxonae Abraham tsipaebatsi, pon wamo susatopin. ");
INSERT INTO cui_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nacom Abraham tsipaebatsi xua pinae naca capanenebiya tsane wanaca aitafaetabi jiwi weya. Baxua pinae nacata exanaena xua pinae waexanaewa tsane pocotsiwa naca itoroba, xuano jopa wacunuwinexa tsane ichamonae pinae. ");
INSERT INTO cui_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mataʉtano nacata exanaena xua pinae beta jinompaeinchi bapon peitabaratha, xuano xua jʉntʉ coyene xeicaeya jinompaeinchi daxita matacabintha xua jopa abe waexanaponaewa. ");
INSERT INTO cui_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Irʉ xam taxantom Juan jiwi cayabara wʉn dutsina pon Nacom peitorobi jume pepaebin, pon itabocotha eca, cayabara jei tsane. Baxua cayabara jei poxoru xam tsiwanaya patopaename pon jiwi pia pepa Pecanamataxeinaein. Daxita jiwi jʉntʉ coyene wʉnaetsiname pepatopaenexa tsane pon jiwi pia pepa Pecanamataxeinaein, pon Mesías. ");
INSERT INTO cui_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nacom caitoroba Juan xua jiwi neyaputane neexanaenexa tsane xua Nacom jʉntemainaena jiwi abe pia peexanae cuiru coyenein tatsi. Bapoxonae Nacom barapomonae capanenebiya exanaeinchi bapon beya xua jopa Nacom petsita natsicuentsixaetsi xua abe peexanaexae. ");
INSERT INTO cui_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Wanacom jopa juniya wanaca antobexae xuano xua wanaca yawenaexae nacata itorobicaena pexanto itaboco wetsica. Nacata wʉnae exanaena icha xometo ichi xua nacata wʉnae poxonae pentha pena matacabixae. ");
INSERT INTO cui_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Poxonae patopeicaena pon Nacom itorobicaena, bapoxonae bapon jiwi jʉntʉ cui weiweinaya exanaeinchi. Baxua exanaeinchi, pomonaetha pomonae pejume cowʉntsiwi bequein copiya barapomonae muxu pewerapae bichocono abe peexanaexae. Yawa Nacom naca jumope antasʉ exanaena, xua jʉntema wajinompaenexa tsainchi”, jei Zacarías xua pexanto barai pon Juan. ");
INSERT INTO cui_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Barapo pexuyo Juan wichabeca. Mataʉtano ajʉntʉyapusʉya popona xua Nacom yabara yaputaepona. Juan ira xuepana susato tsurucuae nacuatha tsana popona, beya poxonae po mataqueitha poxonae Juan tsita patopa Israel nacuapiwi pebautisabinexa barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Irʉrʉ bapoxonae popona romanomonae itorobiya pia pepa peewatsinchi, pon pewʉn Augusto. Bapon itoroba piamonae peexanaenexa censo matawʉn xua pewʉn tinaewan xua daxita carepaya tomaran jiwi wʉn tinaeinchi. ");
INSERT INTO cui_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Barapo censo matawʉn xua pewʉn tinaewan jiwi, baxua matapainya nacobe cui jʉta poxonae Cirenio Siria nacuapiwi pia peyanacua ewatsinchi naexana. ");
INSERT INTO cui_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Daxita jiwi tsanaya barompaya pia pepa tomaran bewa benawibiyaena, ichaxota pia pamo jiwi tatsi tanowaeumeinchi. ");
INSERT INTO cui_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Daxota José Nazaret tomara wewarapiya, xua Galilea nacua weya. Belén tomara bewarapiya po tomara eca Judea nacuatha. Baraxota caena bayatha David pon judiomonae itorobiya pia pepa peewatsinchi nacatsiwa, pon José pia pamo jiwi susato jiwana tatsi, pon yatsicaya tabʉ ducua. ");
INSERT INTO cui_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José pecotsiwa barʉ pona pewʉn tinaenexa tsainchibe. Barapowa pewʉn María. Barapowa pexuyo bʉpana taecatsi. ");
INSERT INTO cui_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Poxonae cataunxuae baraxota Belén tomaratha ecabe, bapoxonae María xua bʉpana taecatsi pexuyo, bara weaperʉtanetsiba. ");
INSERT INTO cui_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Bara bapowa tanaexanatsi pexanto pon copiya tanacatsiwatsi. Barapo pexuyo paparuwantha tsiwixitha mata quiyontababota jeriyotha, po naeyotha ichaxota vaca naepanaewa xayathopa. Tsipei tutu quecona po bomʉxʉtha ichaxota jiwi maiteiba pomonae pateiba pomonae siwa poneiba. ");
INSERT INTO cui_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Imoxoyo Belén tomaratha, pebiwi oveja duweimonae yapu eeneiba wexotha poxonae merawi. ");
INSERT INTO cui_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nexata jemeicha barapo pebiwi tsita naitʉtatsi matatsunpin po matatsunpin itorobicatsi xua pon jiwi Pecanamataxeinaein itorobica. Mataʉtano Nacom pon jiwi Pecanamataxeinaein pia peitʉpanae coicha tatsino barapomonae matawacaicha uncueicatsi. Barapo pebiwi bichocono junuwa. ");
INSERT INTO cui_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nexata matatsunpin barapomonae baraichi jeye: “Jopa pajunuwinde. Apara paca tsipaebatsi pexeinya jume diwesi xua po diwesi daxita jiwi jʉntʉ coyene weiweina exanaeinchi. ");
INSERT INTO cui_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Poxoru anoxuae ichowayo tanaexanatsi pexuyo. Barapo pexuyo naexana David pia tomaratha tatsi xua Belén tomara. Barapo pexuyo, pon jiwi pecapanenebiyaein. Bapon apara pewʉn Mesías pon Pecanamataxeinaein jiwi, pon Nacom weitorobicatsi. ");
INSERT INTO cui_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Bara barapo pexuyo paca ita cayopitatsi xua pataebotsiname vaca pia boyotha. Pataebotsiname barapo pexuyo xua paparuwatha mata quiontababotatsi jeriyotha ichaxota po naeyotha vaca naepanaewan xayathopa”, jei matatsunpin. ");
INSERT INTO cui_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bapoxonae jemeicha equeicha icha matatsunpiwi pin bicheito naitʉbarʉcʉpa ichaxota icha matatsunpin uncua. Barapo matatsunpiwi itaboco wepatsica. Barapomonae Nacom wʉnae jaintatsi. Barapo matatsunpiwi namchi, jeye: ");
INSERT INTO cui_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Maisa bichocono Nacom wʉnae jaintatsi pon itabocotha peecaein, peitorobixae pexanto! ¡Barabʉ jiwi jʉntema jinompa barapo irathe pomonae xua Nacom jʉntʉ coyene weiweina exanatsi!” jei matatsunpiwi. ");
INSERT INTO cui_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Poxonae matatsunpiwi athabe ichicha caibeicha itaboco beicha, bapoxonae pomonae oveja duweimonae peyapu eenaewi barapomonae nabarai, jeye: —Bʉ poinchi Belén tomara beya wataenexa tsane pocotsiwa bayatha Nacom exana, xuano xuaunxuae matatsunpin naca tsipaeba pon jiwi Pecanamataxeinaein nexa, jei barapomonae pomonae oveja duweimonae peyapu eenaewi. ");
INSERT INTO cui_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Barapoxonae oveja duweimonae peyapu eenaewi nainya ponarʉcʉpa. Barapoxonae María irʉ José caxibarʉcʉpatsi. Irʉ pexuyo poyo boqueca jeriyotha vaca matabotha caxibarʉcʉpatsi. ");
INSERT INTO cui_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Poxonae barapomonae taerʉcʉpa pexuyo, barapomonae tsipaeba nawita ichamonaetha pocotsiwa bayatha barapomonae petsipaebixaetsi matatsunpin xua pexuyo yabara. ");
INSERT INTO cui_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Daxita pomonae jume taerʉcʉpa baxua yabara najʉntʉ coyene cabenaeca xua pomonae oveja duweimonae peyapu eenaewi pepaebixae baxua. ");
INSERT INTO cui_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María barapo diwesi moya yawʉn xeina pejʉntʉ coyenewatha xua jume cui cayabara nanta exaba. ");
INSERT INTO cui_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bapoxonae oveja duweimonae peyapu eenaewi caibe nawibiya. Barapomonae Nacom wʉnae jaintatsi petaexae xuano pejume taexaeno xua bayatha matatsunpiwi pepaebixae. Barapomonae namchi, jeye: —Maisa Nacom pon pepa yatsicaewa pejʉntʉ coyene xanepanaein, jei. ");
INSERT INTO cui_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Poxonae ocho po matacabibe yapucaewa, pexuyo wi thabatsi, xua pebin wʉtoxae xua ichaxota nareixacaeca. Baxua judiomonae pia cui coyenetha tatsi. Barapoyo wʉn dutatsi pewʉn Jesús, po wʉn bayatha matatsunpin wʉn unuta xua María muxu tsipaebatsi poxonae María cataunxuae abʉ jopa bʉpana taecaetsi pexuyo. ");
INSERT INTO cui_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nexata matacabi jopa, xua po mataqueitha María irʉ José bewa pepon naxanebibe xua sacerdotemonaepin taexanaena be pocotsi coyeneya bayatha Moisés pia peitorobi coyenewa tatsi paeba xua daxota jopa penataxobinexa. Bapoxonae María irʉ José pexuyo caponabe Jerusalén tomara beya pecatsinexa tsanebe pexuyo Nacomtha pon jiwi Pecanamataxeinaein xua petsita itapeinya xeinaenexabe xua barapo pexuyo Nacom petanacuichiwa tsainchi poxonae pinyo tsane. ");
INSERT INTO cui_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","24","Baxua exana tsipei Nacom pia peitorobi diwesitha tatsi tina, jeyei: “Daxita jiwi pia pexui tatsi, pebin wʉtixi, poxi copiya nacatsiwena, bapoxi Nacom itapeta pia taexanaetsi pocotsiwa Nacom ichichipa”, jei Nacom pia peitorobi jume diwesitha tatsi. Yawa ponabe pecaponaenexabe pepupunaein xua pecatsiwa Nacomtha xua sacerdotemonaepin pebexubinexa xua petautsinexa xua petuxusi exanaenexa tsane Nacomtha María nexa yawa José nexa. Nacom peitorobi coyenewa tatsi jeyei: “Bara irʉ ainya tsaqueintobe care. Ichacuitha icha tsaqueintobe aibi, bara irʉ ainya topibotobe care”, jei. ");
INSERT INTO cui_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Irʉrʉ barapoxonae pebin popona Jerusalén tomaratha, bapon pewʉn Simeón. Bapon pejʉntʉ coyene xanepanaein. Bapon wʉnae jainteiba Nacom. Bapon wʉnae ewateiba xua Nacom itorobina pon Israel nacuapiwi pia Pecanamataxeinaein tatsi nexa. Bapon Israel nacuapiwi pu capanepaeinchi romanomonae weya. Barapo romanomonae icha nacua werena pona xua Israel nacuapiwi cueranta enatsi. Tsipei barapo romanomonae Israel nacuapiwi canamataxeinatsi. Nacom pia Pejumope tʉnaxʉ tatsi Simeón barʉ popoinchi. ");
INSERT INTO cui_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nacom pia Pejumope tʉnaxʉ tatsi Simeón yaputane exanatsi xua pinae copiya taena Mesías pon xua Nacom, pon jiwi Pecanamataxeinaein itorobina. Bapoxonae xua pinae pirapaeyo tʉpaena. ");
INSERT INTO cui_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nacom pia Pejumope tʉnaxʉ tatsi Simeón joniya exanatsi Nacom pin pia botha tatsi. Bara José irʉ pexuyo pena tatsino patopabe Nacom pin pia botha tatsi. Pexuyo capatopabe petacana exanaenexa tsainchibe icha be pocotsi coyeneya Moisés pia peitorobi coyenewatha tatsi itoroba. ");
INSERT INTO cui_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón isapita pexuyo. Nacom wʉnae jaintatsino. Simeón namchi, jeye: ");
INSERT INTO cui_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nacom pon Tanecanamataxeinaem, bara anoxuae caitacʉpa xua tanecopatsiwam xua bara jʉntemiya tatʉpaewa tsane. Tsipei anoxuae bara nayabara jume wetame pocotsiwa bayatha yabara netsiwʉnae muxu dutame. Poxoru xan bapon tsocuaein xua exanan xua neitorobame. ");
INSERT INTO cui_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xan yatsicaewa bara tanba, pon Pecapanenebiyaein jiwi. ");
INSERT INTO cui_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bapon tan pon xua itorobicapaebame, xua daxita jiwi taena xua bapon taeinchi. ");
INSERT INTO cui_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bapon yaputane exanaena xua Nacom yaputaeinchi pomonae jopa judiomonae naexanaeyo. Tsipei bapon be bapocotsin, xua poxonae jiwi beta tane exainchi merawi xua xota yonoyonei. Yawano bapon exanaena xua Israel nacuapiwi, pomonae jinyamonae xua wʉnae jaintinchi xua ichamonae wʉnae jainchina”, jei Simeón. ");
INSERT INTO cui_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","María irʉ José yabara najʉntʉ coyene cabenaecabe pocotsiwa Simeón pexuyo yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nexata Simeón barai, Nacom baraichi xua María yabara yawano xua José yabara, jeye: “Jʉntʉ coyene weiweina exande baraponbe”, jei. Nexata Simeón, María baraichi xua pexuyo pena tatsi: —Barapo pexuyo Nacom itapeta xua bapon peexanaenexa tsane po coyene xua Israel nacuapiwi ichamonae Nacom beya peponaenexa xua ichacuitha icha ichamonae Nacom beya jopa peponaenexa tsane. Yawa Nacom itoroba barapo pexuyo, peitʉbinexa Nacom pia peayapusʉwa ichitha ichamonae jume cui aitafaetabi tsaibi tsane. ");
INSERT INTO cui_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Daxota barapo pexuyo yaputaena pocotsiwa jiwi pejʉntʉ coyeneintha nanta xeineibina. Ichitha xam, María, daxita baxuan caajʉntʉcoyenerewe exanaena be poxonae ichʉn canthʉthʉ tsapinopaena cusitha, jei Simeón xua María tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Irʉrʉ baxota poponarʉ petsiriwa, pewʉn Ana. Barapowayo Nacom peitorobi jume pepaebiwayo. Barapowa Fanuel pexantiyo tatsi. Aser pon yatsicaya tabʉ ducua bapon pia pemomoxi susato jiwana tatsi. Barapowa bara nama penapataewa tsoponae. Barapowa caena bayatha poxonae penowayo tsecae jitha eca. Pia pebinbe siete po weiyobe nabarʉ poponabe. Bapoxonae pebin tʉpa. ");
INSERT INTO cui_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Barapowa caena bayatha piseuri cuenta tʉpatsi. Anoxuae nama barapowa yaochenta y cuatro po weiyobe jopaba. Barapowa Nacom pin pia bo weya jopa pichapeibiyo. Saya exaneiba pocotsiwa Nacom itoroba merawintha yawa matacabintha. Najainboteibano poxonae tsipaebeiba Nacomtha. ");
INSERT INTO cui_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Poxonae Jesús caponatsi Nacom pin pia botha xua Nacom pecatsinexatsi bapoxonae Ana imoxoyo caquita uncua barapomonaetha. Barapowa tsipaeba Nacomtha, jeye: “Nacom maisa jʉntʉ coyene weiweinan xua painta itorobame barapo pexuyo”, jei Ana. Bapoxonae Ana yabara paebaxoya pexuyo jiwitha pomonaetha pomonae wʉnae ewateiba po coyene xua Nacom itorobina Israel nacuapiwitha pon Israel nacuapiwi capanenebiya exanaeinchi romanomonae weya. ");
INSERT INTO cui_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nexata María irʉ José wetabeba daxita xua Nacom, pon jiwi Pecanamataxeinaein, peitorobi jume coyenewa paeba. Bapoxonae caibe canawiyabe pexuyo Galilea nacua beya xua pia tomara beyabe, Nazaret tomara beyabe. ");
INSERT INTO cui_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pexuyo wichabeca. Mataʉtano bichocono daunwei nawita, peyaputae coyene xexeinaponano. Nacom tsita jʉntʉ coyene xanepanapoinchi. ");
INSERT INTO cui_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús pena tatsi irʉ paxa tatsi daxita weitha poneiba Jerusalén tomara beya xua nataiba Pascua wʉn matacabin. Barapo Pascua wʉn jei, poxonae Israel nacuapiwi nanta xeina xua poxonae pinae bayatha pia pamo susato jiwi tatsi capanenebiya exanatsi Egipto nacua weya, xua Nacom capanenebiya. ");
INSERT INTO cui_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Poxonae Jesús doce po weiyobe yapu jopa, María irʉ José irʉ Jesús, Jerusalén tomara be-iyiya. Tsipei barapomonae pia cui xua poneiba barapo Pascua wʉn matacabin nexa. ");
INSERT INTO cui_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","María irʉ José caibe nawirenabe pia tomara berena poxonae barapo matacabin weta. Ichitha pewowin Jesús naruntaba Jerusalén tomaratha. Jesús pena tatsi irʉ José jopa taeyobe xua Jesús nacopataba. ");
INSERT INTO cui_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Nanta xeinabe xua Jesús mexeya itara napunaecaponawei pin bicheitotha. Caentacabitha María irʉ José namtotha naecaponabe, bapoxonae itaxanawiyabe pexanto. Necobauyabe pexanto pin bicheitotha pia matabʉxʉyo jiwimonaetha, pijiwimonaethano. ");
INSERT INTO cui_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Jopa pexanto caxinaebe. Bapoxonae equeicha caibe iyabe Jerusalén tomara beya, pewenaweneinexa tsanebe pexanto baxotiya equeicha. ");
INSERT INTO cui_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Poxonae acoibi po matacabiyobe yapucaewa Jerusalén tomaratha baxota pexanto caxinabe Nacom pin pia botha tatsi. Jesús naeca ichaxota pomonae jiwi pecuidubiwi Nacom pia peitorobi jume. Jesús jume tane barapomonae. Mataʉtano yainyabano nawita barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Daxita pomonae jume tane, najʉntʉ coyene cabenaeca tsipei Jesús peyaputaein tsecae, mataʉtano tsipei Jesús beta jume nota. ");
INSERT INTO cui_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","María irʉ José poxonae baxua cui tanebe najʉntʉ coyene cabenaecabe. María pexanto barai, jeye: —Owae, ¿eta xua metha baxua painta exaname? Axa irʉ xan paca yabara najʉntʉ coyene exabatsibe, paca jeitompatsi, jei. ");
INSERT INTO cui_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús jume nota pena, jeye: —¿Eta pocotsiwa metha ichawa beya pana nejeitompame? ¿Metha bara jopa payaputaem jampa xua bewa necui eenaena xua Taxa pia cui yabara tatsi? jei. ");
INSERT INTO cui_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ichitha María irʉ José jopa xapain yaputaeyobe pocotsiwa Jesús paeba. ");
INSERT INTO cui_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesús caibe nanawiya pena tatsibarʉtha Nazaret tomara beya. Jesús pena jume jejei tsaibi yawano José jume jejei tsaibichino xua daxita exana pocotsiwa Jesús itorobeibatsi. Jesús pena, daxita baxuan moicha cacui yabara cananta xeineibatsi pejʉntʉ coyenewatha. ");
INSERT INTO cui_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nexata Jesús wiwichabapona yawa jʉntʉ coyene ayapusʉya exanapoinchino Nacom pia Pejumopetha tʉnaxʉ tatsi. Nacom irʉ jiwi Jesús antobe tsoponaetsi. ");
INSERT INTO cui_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Irʉrʉ Tiberio pon romanomonae itorobiya pia pepa peewatsinchi tatsi yapu jopa quince po weibe xua itorobiya canamataxeina barapo nacuanthapiwi. Bapoxonae irʉ Poncio Pilato Judea nacuapiwi peyanacua ewatsinchi naexana. Barichi Herodes Galilea nacuapiwi peyanacua ewatsinchi naexana. Irʉ Herodes peweicho tatsi Felipe, bapon Iturea nacuapiwi peyanacua ewatsinchi naexana xua Traconite nacuathano. Barichirʉ Lisanias Abilinia nacuapiwi peyanacua ewatsinchi naexana. ");
INSERT INTO cui_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Barichirʉ Anás irʉ Caifás baponbe sacerdotemonae pia pepa pentacaponaeinbe tatsibe. Barapoxonaerʉ Nacom Juan tsipaebatsi poxonae ira xuepana susato tsurucuae nacuatha popona. Juan bapon Zacarías pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan popona ducuanaeta Jordán nacuatha ichaxota Jordán mene. Nacom Pejume Diwesi tsipaeba ducuanaeta jiwitha. Bapon barai jiwitha, jeye: —Icha jʉntʉ coyene paxeinare painya neauraxae xua abe paexaname. Paca bautisabina ichamonae xua Nacom paca necayabara jʉntemainaenexa abe painya neexanae cuiru coyenein, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Baxua exana, peyabara jeichixaetsi xua peyabara jeixae pon Nacom peitorobi jume pepaebin Isaías poxonae bapon tina pejume diwesi. Barapo diwesitha Isaías caena bayatha wʉnae tsiwʉnaeya yabara paeba xua Juan yabara. Isaías namchi, jeye: “Jume tan pon wawai ira xuepana susato tsurucuae nacuatha. Bapon wawai jeye: ‘Patsinajʉntʉ cui coyene wʉnaere pon jiwi pia pepa Pecanamataxeinaeinchi pia pepatopae wʉnaeya tsane. ");
INSERT INTO cui_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Daxita pemarafotontha paatsa jejebapoinyama. Daxita petsuton paatsa caxiquiyama. Pejeyajeyowa namton bopiya dubeinya paexande. Pemarafotofotowa namton, panamto dameyama. Apara jopa yabara janyo namton, jame apara yabara jan painya jʉntʉ coyenein. Ichi paichim xua namton paxanebame bara paichinde pana najʉntʉ cui wʉnaere painya Nepacacanamataxeinaein nexa poxonae bapon patopeicaena. ");
INSERT INTO cui_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Daxita nacuapiwimonae yaputaena Nacom pia pecapanenebiyae coyene tatsi’, jei pon wawai”, jei Isaías pejume diwesitha. ");
INSERT INTO cui_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pin bicheito pata, xua Juan pebautisabinexa tsane. Juan barai barapomonae jeye: “¡Paxam pomonae pemuxuitorobi jiwi pam! ¡Paxam be bara jomomonae pam, tsipei jomo ba cuitaya dʉcʉpa nawa! Bara paichim anoxuae paichichipame Nacom pacuitaya dʉcʉpame xua abe paca exanaeyainwa. Jopa papanenebiyaem tsane bequein bara paca bautisabinchi tsipei jopa pajʉntʉ coyene xanepanaem Nacomtha. ");
INSERT INTO cui_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xaniwaicha painompare xain ichamonae paca cui tane xua icha jʉntʉ coyene painya nexeinaewa Nacomtha, pon jiwi Pecanamataxeinaein. Tsipei bequein paxam pajam: ‘Waxainchi Abraham pia pemomoxi susato jiwichixaetsi Nacom naca capanenebiya exanaena’, pajam, daichitha paxam jopa xaniwaicha pajume cowʉntsim Nacom. Daxota Nacom itacʉpatsi xua paca cui matawenta pia jopa paca nepaca capanenebiyaenexa tsane. Mataʉtano barichino Nacom itacʉpatsi xua jiwi forotsinchi barapo ibotixi weya, po ibotixi xote Jordán mene itapatha bobena. Barapo jiwi naexanaena, po jiwi yatsicaewa Abraham pia pemomoxi susato jiwi tatsi, pomonae pejume cowʉntsixaetsi Nacom. ");
INSERT INTO cui_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Poxonae pebin naein ʉba, sipari ba canacui wʉnaeta pecaucubobinexa po naein jopa nacoichiyo. Poxonae barapo naein ucuboba nantatsun eta xua petautsinexa isototha. Paxam bara paca jʉta ichiya paca cana exanaena. Nacom paca yabara nacui wʉnaeta xua paca bebai tsane isototha, ichaxota po isototha jopa cuinaya itacounayiyo tsipei Nacom jopa xanepanaya pata taexanaem”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nexata barapomonae Juan yainyabatsi jeichichi: —¿Eta pocotsiwa Nacom ichichipa pocotsiwa pata exanaenexa xua ichamonae pata necui taenexa tsane xua bara pajʉntʉ coyene xanepanaein Nacomtha? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan jume nota, jeye: —Pon ainya camisabe xeina, bapon becatsipa pontha pon yatsicaewa jopa naʉma xatatsiyo camisa. Irʉrʉ pon tamatecatsi penabanaewa bapon becatsipa ichʉn pontha pon jopa xeinaeyo penabanaewa, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Barichirʉ pata, pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. Barapomonae pata xua Juan pebautisabinexa tsanerʉ barapomonae. Barapomonae Juan yainyabatsi, jeichichi: —Pon jiwi Necuidubim, ¿eta pocotsiwa Nacom ichichipa pocotsiwa pata exanaewa tsane? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan jume nota, jeye: —Saya meisa jiwi pawʉcaename paratixi xua romanomonae paca itoroba. Jopa yabara muxuitorobiya pawʉcaeinde ichawan, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Barichirʉ soldadomonae Juan yainyabatsi, jeichichi: —Irʉ paxan, ¿eta pocotsiwa Nacom ichichipa pocotsiwa pata exanaewa tsane? jei barapomonae. Juan jume nota, jeye: —Jopa payabara jume daunweya wecobe noteibinde ichamonae piawan tatsi. Mataʉtano ichamonae jopa pacui yopiteibinde pocotsiwa exana ichamonae poxonae apara jopa exaneibiyo. Bara saya pajʉntʉ coyene weiweinare poxonae paratixi paxeiname poxonae ichamonae xua pata exaname xua soldadomonae pamxaem, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Daxita pomonae wʉnae ewateiba xua Mesías pepatopeicaewa tsane, barapomonae poxonae Juan jume tainchi, barapomonae pejʉntʉ coyeneintha nanta xeina, xua apara Juan metha apara Mesíaswei. ");
INSERT INTO cui_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ichitha Juan barai daxita barapomonae, jeye: “Xan paca bautisabatsi meratha. Ichitha nama patopaena pon bichocono ainya cui beyacaincha xan. Bapon pon pepa Pecanamataxeinaein jiwi. Xan saya tapawin. Daxota auran xua tataxu mʉ isanaxubiwa pia penataxu xatatsiwa. Bapon paca jiwana bautisabina Nacom pia Pejumope tʉnaxʉtha tatsi. Bapon paca jiwana cui copatsinchi xua atene tsane Jesús pejume cowʉntsixaetsi tsane. ");
INSERT INTO cui_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Bapon pon patopaena bapon bayatha tsinacobenata po paparato xua trigo xu nexa. Bapon trigo xu tsanaya seicaya matapepe jejebapona. Trigo xu jejebapona, trigo xu matabotha. Matapepe jejebapona petautsinexa isototha, ichaxota po isoto jopa cuinaya itacounayiyo. Bara jʉta cana ichi tsane jiwitha icha trigo xu cana ichiya ichichi jiwi Nacom tsananobina pomonae pejume cowʉntsixaetsi pia nacuatha nexa. Ichamonae tsananobinchi pomonae jopa pejume cowʉntsiwichi, petautsinexa isototha ichaxota xua jopa itacounayiyo”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Icha diwesi yabara jumeno Juan barapomonaetha paeba Nacom pia pexeinya jume diwesi tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mataʉtano Juan biatane, Herodes biatainchi pon Judea nacuapiwi pia peyanacua ewatsinchi poxoru Herodes peweicho caiba yabʉyo powa Herodías. Herodes peweicho tatsi pewʉn Felipe. Mataʉtano Juan biatane poxoru bayatha Herodes abe exana nawita jiwitha. ");
INSERT INTO cui_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ichitha daʉmetha equeicha Herodes abe exana xua Juan caenaetatsi ichamonaetha xua pecaponaenexa tsainchi jiwi pecʉbi botha. ");
INSERT INTO cui_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Poxonae cataunxuae Juan jopa ecaeyo jiwi pecʉbi botha, Juan bautisaba ducuanaeta jiwi. Barichi irʉ Jesús nabautisabatsi. Poxonae Jesús tsipaebuncua paxa, peitaboco nayausaranaxuba. ");
INSERT INTO cui_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nacom pia Pejumope tʉnaxʉ tatsi patopeica Jesustha, be topiboto yaruneica. Jesús jume tane pocotsiwa peitaboco wetsipaebicatsi, jeichichi: —Xam apara Taxantom pom bichocono cantobetsi, pom caitapetatsi. Nejʉntʉ coyene weiweina exaname, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Poxonae Jesús treinta po weibe yapu jopa, bapoxonae nama tamropata pitaba barompaya pia pepa peexanae coyenewan po coyene Nacom Pejume Diwesi pecueicueijeiwa xuano jiwi axaibi exana ducuanaebiyano. Jesús, José pexanto tatsi. Daxita jiwi nanta xeina xua mexeya itara José yatsicaewa pexantowei. José, Elí pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Bapon Elí, Matat pexanto tatsi. Bapon Matat, Leví pexanto tatsi. Bapon Leví, Melqui pexanto tatsi. Bapon Melqui, Jana pexanto tatsi. Bapon Jana, José pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Bapon José, Matatías pexanto tatsi. Bapon Matatías, Amós pexanto tatsi. Bapon Amós, Nahúm pexanto tatsi. Bapon Nahúm, Esli pexanto tatsi. Bapon Esli, Nagai pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Bapon Nagai, Maat pexanto tatsi. Bapon Maat, Matatías pexanto tatsi. Bapon Matatías, Semei pexanto tatsi. Bapon Semei, Josec pexanto tatsi. Bapon Josec, Judá pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Bapon Judá, Joanán pexanto tatsi. Bapon Joanán, Resa pexanto tatsi. Bapon Resa, Zorobabel pexanto tatsi. Bapon Zorobabel, Salatiel pexanto tatsi. Bapon Salatiel, Neri pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Bapon Neri, Melqui pexanto tatsi. Bapon Melqui, Adi pexanto tatsi. Bapon Adi, Cosam pexanto tatsi. Bapon Cosam, Elmadam pexanto tatsi. Bapon Elmadam, Er pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Bapon Er, Josué pexanto tatsi. Bapon Josué Eliezer pexanto tatsi. Bapon Eliezer, Jorim pexanto tatsi. Bapon Jorim, Matat pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Bapon Matat, Leví pexanto tatsi. Bapon Leví, Simeón pexanto tatsi. Bapon Simeón, Judá pexanto tatsi. Bapon Judá, José pexanto tatsi. Bapon José, Jonam pexanto tatsi. Bapon Jonam, Eliaquim pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Bapon Eliaquim, Melea pexanto tatsi. Bapon Melea, Mena pexanto tatsi. Bapon Mena, Matata pexanto tatsi. Bapon Matata, Natán pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Bapon Natán, David pexanto tatsi. Bapon David, Isaí pexanto tatsi. Bapon Isaí, Obed pexanto tatsi. Bapon Obed, Booz pexanto tatsi. Bapon Booz, Sala pexanto tatsi xua icha wʉn Salmón. Bapon Sala, Naasón pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Bapon Naasón, Aminadab pexanto tatsi. Bapon Aminadab, Admin pexanto tatsi. Bapon Admin, Arni pexanto tatsi. Bapon Arni Esrom pexanto tatsi. Bapon Esrom, Fares pexanto tatsi. Bapon Fares, Judá pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Bapon Judá, Jacob pexanto tatsi. Bapon Jacob, Isaac pexanto tatsi. Bapon Isaac, Abraham pexanto tatsi. Bapon Abraham, Taré pexanto tatsi. Bapon Taré, Nacor pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Bapon Nacor, Serug pexanto tatsi. Bapon Serug, Ragau pexanto tatsi. Bapon Ragau, Peleg pexanto tatsi. Bapon Peleg, Heber pexanto tatsi. Bapon Heber, Sala pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Bapon Sala, Cainán pexanto tatsi. Bapon Cainán, Arfaxad pexanto tatsi. Bapon Arfaxad, Sem pexanto tatsi. Bapon Sem, Noé pexanto tatsi. Bapon Noé, Lamec pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Bapon Lamec, Matusalén pexanto tatsi. Bapon Matusalén, Enoc pexanto tatsi. Bapon Enoc, Jared pexanto tatsi. Bapon Jared, Mahalaleel pexanto tatsi. Bapon Mahalaleel, Cainán pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Bapon Cainán, Enós pexanto tatsi. Bapon Enós, Set pexanto tatsi. Bapon Set, Adán pexanto tatsi. Bapon Adán, Nacom pexanto tatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Poxonae Jesús jʉntʉ coyene yʉcatsi Nacom pia Pejumope tʉnaxʉ tatsi bapoxonae caibe nawiya Jordán mene weya. Nacom pia Pejumope tʉnaxʉ tatsi Jesús mata cayatsi ira xuepana susato tsurucuae nacua beya. ");
INSERT INTO cui_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Baraxotiya Jesús popona cuarenta po matacabibe. Caurimonae pia pentacaponaein tatsi Jesús piraichi jʉntʉ coyene jʉjʉtatsi xua Jesús abe coyeneya petaexanaenexa tsane. Barapo cuarenta po matacabibetha Jesús jopa nabanaeyo. Poxonae barapo matacabin yapucaewa Jesús bichocono jainpa. ");
INSERT INTO cui_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Caurimonae pia pentacaponaein tatsi, Jesús baraichi, jeichichi: —Icha xam yatsicaya Nacom Pexantom, netsita itʉre. Barapo iboto itorobare xain pan naexanaxoya, jei caurimonae pia pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús jume nota. Caurimonae pia pentacaponaein tatsi jume notatsi, jeye: —Nacom Pejume Diwesitha namchi: ‘Jopa metha bepa meisa jiwi betiya una jinompaetsipae pan’, jei Nacom Pejume Diwesi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Caurimonae pia pentacaponaein tatsi Jesús matacapoinchi ichaxota po demxuwa bichocono atororo. Baraxotiya Jesús tsita itʉtarabatsi daxita nacuan, xua barapo cae pin nacuathe. ");
INSERT INTO cui_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bapoxonae caurimonae pia pentacaponaein tatsi Jesús baraichi, jeichichi: —Daxita barapo nacuan cacatinchi jiwi neitorobinexa tsane. Mataʉtano daxita cacatinchi nacuan pia pewʉnaewan, tsipei bayatha necata daxita barapo nacuan xua taitorobeibiwa coyenewan. Tawaxae catsin ichʉntha pontha pon xua ichichipan xua tacatsiwa. ");
INSERT INTO cui_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ichaunxuae nentabocototha uncuaename taitabaratha, xuano ichaunxuae newʉnae jainchiname xua nenanta xeinaewaxae xua xan jinya tacacanamataxeinaeinchi, bapoxonae baxuan daxita bara cacatsinchi jinya Necanamataxeinaenexa barapo nacuan, jei caurimonae pia pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ichitha Jesús jume nota, jeye: —Yaitama Nacom Pejume Diwesitha namchi, jeye: ‘Meisa wʉnae jainde jinya Necanamataxeinaein Nacom. Meisa bapon yatsicaewa taexande pocotsiwa caitoroba’, jei Nacom Pejume Diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Cotacaya nama equeicha Jesús matacapoinchi Jerusalén tomara beya, Nacom pin pia botha pentatupa beicha capoinchi. Jesús baraichi, jeichichi: —Icha bara xaniwaicha Nacom Pexanto tatsim, wenaxoreinque. ");
INSERT INTO cui_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Nacom Pejume Diwesitha namchi, jeye: ‘Nacom itorobina pia matatsunpiwi necayanabinexa. ");
INSERT INTO cui_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Barapo matatsunpiwi asiya cawaetaboutsina pecobetha, xua jopa necataxu tsaquituncuaenexa tsane ibototha poxonae wenaxorecame’, jei Nacom Pejume Diwesitha, jei caurimonae pia pentacaponaein tatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús jume nota, jeye: —Barichi Nacom Pejume Diwesitha namchi, jeye: ‘Jopa jʉntʉ coyene jʉjʉtsiya wʉcaeinde Nacom pon jinya Necanamataxeinaein, xua cajume jejei tsane necayawenaenexa poxonae jopa xapain exanaem’, jei Nacom Pejume Diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Poxonae caurimonae pia pentacaponaein tatsi yaputane xua jopa xeinaeyo po coyenetha equeicha Jesús pejʉntʉ coyene jʉjʉtsiwa tsainchi, bapoxonae nama Jesús wepu poinchiba xua saya bara caeto nexa. ");
INSERT INTO cui_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús caibe iya Galilea nacua beya. Mataʉtano jopa juniya xeinaeyo Nacom pia Pejumope tʉnaxʉ tatsi pia peayapusʉ itorobi coyenewa tatsi. Daxita jiwi pomonae jinompa barapo nacuatha Jesús yabara paebinoutatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús cuidubeiba barapomonae judiomonae pia penacaetutsi bontha tatsi xua daxita tomarantha. Barapomonae Jesús wʉnae jainteibatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nexata Jesús Nazaret tomara beya pona, po tomaratha ichaxota wichaba. Judiomonae barompaya pia pentaquei seicae matacabitha tatsi Jesús joniya judiomonae pia penacaetutsi botha tatsi tsipei pia cui xeina xua peponeibiwa barapocotsi botha. Jesús xenta iya barapomonae peuncuaenexa peitabaratha, peyorobinexa Nacom Pejume Diwesi, xua barapomonae pejume taenexa. ");
INSERT INTO cui_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nexata Jesús catatsi Isaías pejume diwesi, pon Nacom peitorobi jume pepaebin, pon caena bayatha tʉpa. Poxonae Jesús diboro pataxuba baxota taeba pocotsiwa baxota paeba, xua jeye: ");
INSERT INTO cui_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nacom pia Pejumope tʉnaxʉ tatsi neyanta popona. Nacom neitapeta tatacueicueijeinexa tsane pia pexeinya jume diwesi tatsi pomonaetha pomonae peacopeibi jiwi. Mataʉtano neitoroba xua tayawenaenexa pomonae anthʉthʉtane. Mataʉtano neitorobano xua tayawenaenexa pomonae caurimonae itorobatsi nawita xua barapomonae pepanenebiyaenexa. Mataʉtano neitorobano xua tane tacana exanaenexa pomonae peitata nacʉtsi jiwi. Mataʉtano neitorobano xua tayawenaenexa pomonae xua bichocono taayapubetsi xua pejinompaewa tsane xua barapomonae jopa pexeinae dubenanaebiyaenexa tsane barapo coyenein. ");
INSERT INTO cui_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mataʉtano neitorobano xua jiwi tatsipaebinexa po coyene xua Nacom nacui wʉnaeta xua jiwi peyawenaewa tsainchi pomonae ichichipa xua Nacom pejume taewatsi”, jei Isaías pejume diwesitha, jei Jesús xua yoroba. ");
INSERT INTO cui_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Poxonae Jesús barapo diboro acataraba, bapoxonae cata pontha pon jiwi peyawenequeibin judiomonae pia penacaetutsi botha tatsi. Bapoxonae Jesús econeca. Daxita pomonae baxota ena, Jesús necotenatsi xua cui ewatenatsi xua pecueicueijeiwa tsane Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bapoxonae Jesús tamropata pitaba xua paeba, jeye: —Anoxuae xuaunxuae pajume taneme baxua apara barapo mataqueithe Nacom nayabara jume cui weta painya itʉtha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Daxita carepaya jiwi Jesús xanepanaya yabara paebatsi. Daxita barapomonae najʉntʉ coyene cabenaeca xua pejume taexae xua po jume barapomonae petsipaebixaetsi. Barapomonae nantiya nabarai, jeye: —Maisa jume xeica bapon, jume wʉnaeya paeba. ¿Bara bapon José pexanto tatsi jampa? najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús barai barapomonae, jeye: —Metha pana netsipaebichipame icha be pocotsi diwesiyo iche xua pecayabara jʉta pepaebi diwesiyo xua ba jei: ‘Pon jiwi neyawʉbin, jinya coutha nayawʉbare’, xua ba jei. Barichi anoxuae pana nejam tsane: ‘Xua paxan pajume tan xua juinya Capernaum tomaratha exaname, barichinde xote exande jinya tomaratha’, pana nejam tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Awiya cataunxuae Jesús cueicueijei. Equeicha namchi, jeye: —Xaniwaicha paca tsipaebatsi pon ba Nacom peitorobi jume pepaebin pia nacuamonaepiwi ba aitafaetabichi. ");
INSERT INTO cui_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Xaniyan paca baraichi xua caena bayatha poxonae Elías popona pon Nacom peitorobi jume pepaebin, ainyawaxi powaxi pecuenta werapaewaxichi pia seuriwi Israel nacuatha jinompa. Barapo nacuatha cuinaya jopa duneicaeyo acoibi po weiyobe xuano seis po xometiyobethano. Daxita jiwi piyain barapo nacuatha Israel nacuatha. ");
INSERT INTO cui_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nacom jopa itorobiyo, Elías jopa itorobichi xua peyawenaenexa tsane caewayo jiwana powaxi pecuenta werapaewaxichi pia seuriwi xua Israel nacuatha. Ichitha saya meisa Nacom itoroba, Elías itorobatsi powatha powa pecuenta tʉpaewayotsi piseuri, powa popona Sarepta tomaratha, xua Sidón nacuatha xua barapowayo peyawenaenexatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Barichi Israel nacuatha pinmonae jinompa pomonae peperʉ sawatsi jiwimonae, poxonae Eliseo popona pon Nacom peitorobi jume pepaebin. Eliseo jopa jiwana axaibi exanaeyo. Ichitha meisa Eliseo Naamán axaibi exanatsi pon bichocono peperʉ sawinchi. Bapon Naamán, Siria nacuapin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Poxonae barapomonae jume tane pocotsiwa Jesús paeba pomonae judiomonae pia penacaetutsi botha ena, bapoxonae barapomonae Jesús casebatsi. ");
INSERT INTO cui_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Asiya umenarʉcʉpa barapomonae. Jesús tomara peʉma beitaweyatsi. Jesús capoinchi pitapatororo itapa beya, po tsututha bomʉxʉn jeba, xua bara wepexorecaenexa tsainchi Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ichitha Jesús barapomonae xenta iya, pu seicataba. ");
INSERT INTO cui_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nexata Jesús pona Capernaum tomara beya po tomara eca Galilea nacuatha. Baxotiya Jesús cuiduba jiwi po mataqueitha pentaquei seicae matacabitha. ");
INSERT INTO cui_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Barapomonae yabara najʉntʉ coyene cabenaeca tsipei pocotsiwa bapon barapomonae cuidubatsi be pon peyaputaein pia peayapusʉ itorobi jume coyeneya tatsi paeba. ");
INSERT INTO cui_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Judiomonae pia penacaetutsi botha tatsi pebin baxota eca, pon cauri xeina. Bapon bichocono wawaya exanatsi cauri. Bapon Jesús baraichi xua namtsebiya wawai, jeye: ");
INSERT INTO cui_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesús Nazaret tomarapim, warapare pata xainya weya! ¿Eta xua metha patopame pata xantha xua jinya apara abe pata neexanaetsim? ¿Apara patopame jinya pana nejutebicham? Paca yaputainchi yawa paca yaitainchi. Xam apara pon Nacom caitoroba, pon pepa Nentacuiruyapuxanepanaem, jei cauri. ");
INSERT INTO cui_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús itaweta cauri, jeye: —¡Moyande! ¡Bapon wepu ponde! jei Jesús. Nexata cauri pebin iratha xotsi barapomonae peitʉtha tatsi. Pebin wepu poinchi cauri, saya jʉntema. Equeicha jopa ateneyono. ");
INSERT INTO cui_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Daxita barapomonae yabara najʉntʉ coyene cabenaeca, nayainyaba namchi: —¿Eta po jumera xua bapon paeba? Jamaisa barapo pebin itaweta caurimonae pia peayapusʉya itorobi coyenewatha. Mataʉtano barapo caurimonae bara pona. ");
INSERT INTO cui_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Daxita jiwi paebinouta Capernaum tomara cuariyatha pocotsiwa Jesús exana. ");
INSERT INTO cui_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bapoxonae Jesús judiomonae pia penacaetutsi bo tatsi wejoniya. Jesús joniya Simón pia botha tatsi. Simón pamiyo tatsi atene, domaebatsi. Barapowa piamonae tatsi Jesús jume daunweya wʉcatsi xua bapowa axaibi peexanaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús imoxoyo caquita uncua pentasipatha. Jesús domaetha namchi, jeye: —Barapowatha jopa bayatha yacacaewiyande, jei Jesús. Domae aichurucuae. Nainya barapowa nantacotaxuba. Bapoxonae bapowa pexaewa apata barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Poxonae tabopiya tsanaicha pomonae piamonae barompaya taatenetsi pomonae xua jopa nayaromae jʉpaeyo, daxita barapomonae Jesús betacarendenatsi. Jesús ichawa beya jayabapona pecobetha, bapoxonae daxita carepaya axaibi. ");
INSERT INTO cui_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Barichi pomonae cauri pexeinaewi Jesús taitaweta barapomonae. Barapo caurimonae wawaya jeye: —Apara xam Nacom Pexantom, jei. Bequein caurimonae baxua paeba ichitha Jesús awiya daʉmetha itaweta caurimonae. Jesús jopa najume copatsiyo xua equeicha pepaebiwa tsane poxoru barapo caurimonae yaputane xua bapon yatsicaewa Mesías pon Nacom itorobica. ");
INSERT INTO cui_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Poxonae baya juntucuru pentha tsina, Jesús tomara weiya ichaxota jiwaibi bara beya pona. Ichitha jiwi Jesús jeitatsi. Barapoxonae bapomonae pata ichaxota Jesús popona. Barapomonae aichaxaibi xua Jesús pewepu warapaewa barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ichitha Jesús namchi, jeye: —Bewa irʉ yabara paebin Nacom pia pexeinya jume diwesi tatsi, po diwesi yabara xua Nacom waba jiwi petanaexanaenexatsi piamonae pomonae Nacom jʉntʉ coyene itorobiya ewata. Apara baxua netsiyabara itorobica, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Daxota Jesús paeba ducuanaeta Nacom Pejume Diwesi Judea nacuatha xua judiomonae pia penacaetutsi bontha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Caentacabi Jesús Genesaret pucua itapatha uncua. Pin bicheito pata bichocono nacʉcʉnaxuba Jesustha, tsipei barapomonae ichichipa jume tane Nacom Pejume Diwesi tatsi. ");
INSERT INTO cui_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús ainya jerabe tane pucuatha taetabo itapatha, po jera saya naebe. Tsipei duwei peyamonaewi bayatha nacui wetarʉcʉpa, mataʉtano poxoru bayatha nonobouna taetabotha. Barapomonae pia peyamonaewan iquicompa. ");
INSERT INTO cui_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nexata Jesús jeratha nontabiya Simón pia naetha tatsi. Jesús Simón baraichi: —Tsiwiyo neyana torotaxoyam, jei Jesús. Bapoxonae Jesús eca jeratha. Jesús mene wecuidubecarena jiwi Nacom Pejume Diwesi. ");
INSERT INTO cui_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Poxonae Jesús najume weta, Simón baraichi, jeye: —Jeratha ponde ichaxota pentatheibʉ. Paxoyama painya neyacamonaewa painya necapirenaenexa duwei, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón, Jesús jume notatsi, jeye: —Pon jiwi Necuidubim, bequein barapo merawithe payamonompan, pacobesa patan. Yaitama aunxuae neitorobame, methaunxuae xoyaein tayamonaewa, jei Simón. ");
INSERT INTO cui_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Poxonae barapomonae xoya, duwei pin tunto capirena, muxu peucubabi xua peyamonaewa. ");
INSERT INTO cui_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nexata barapomonae moya pecobetha itacowaeba pomonae penabarʉ yaxunobompaexae, pomonae icha jeratha jinompa itacowaebatsi, penayawenaenexa. Barapomonae pata. Jera ainya naebe wʉntabe duwei. Muxu pebunopaebe jerabe. ");
INSERT INTO cui_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón pon Jesús icha wʉn duta, xua Pedro baraichi, bapon tane baxua. Bapoxonae bapon Jesús peitabaratha tauncuatsi pentabocotha. Simón, Jesús baraichi, jeye: —Tanecanamataxeinaein, newepu ponare, tsipei xan abe taexanaein, jei Simón Pedro. ");
INSERT INTO cui_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Poxoru Simón Pedro junuwiya najʉntʉ coyene cabenaeca yaitama peyacamonaewatha capirena duwei pin tunto. Irʉ pomonae Simón Pedro pia jeratha petaenaewichi barapomonae irʉ junuwiya najʉntʉ coyene cabenaeca. ");
INSERT INTO cui_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Irʉ Zebedeo pexantobe tatsi, Santiago irʉ Juan baponbe irʉ junuwiya najʉntʉ coyene cabenaecabe. Baponbe ponbe Simón pebarʉ yamonaeinbe tatsibe. Ichitha Jesús Simón baraichi, jeichichi: —Simón, jopa junuwinde, anoxuae caexanaeinchi xua pinmonae yawenaename xua barapomonae pejume cowʉntsiwa tsane Nacom icha bayatha ichim poxonae yamoname duwei nawita, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nexata poxonae barapo jerabe botounabe, barapoxonae barapomonae baxuan daxita nacui barapenta. Bapoxonae barapomonae Jesús puna poinchi. ");
INSERT INTO cui_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús icha tomara siwa pona. Bapoxonae pebin patopa pon peperʉ sawinchi. Poxonae Jesús taebatsi, bapon Jesús peitabaratha tatsi pentabocototha tauncuatsi yawa ira betaeuncuareca. Bapon Jesús jume daunweya wʉcatsi, jeichichi: —Pon Necanamataxeinaem jiwi, icha bara ichichipame bara caitacʉpa xua axaibi tana neexanaewam, tsipei jinya neayapusʉ itorobi coyenewa nexeinaem, jeichichi Jesús bapon. ");
INSERT INTO cui_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nexata Jesús, nacobe yota, yawa mata jayaba bapon, pon peperʉ sawinchi. Jesús barai, jeye: —Bara ichichipan. ¡Bara axaibinde! ¡Bara caaperʉxaibi exanatsi! jei Jesús. Bapoxonae bapon nainya taaichurucaetsi xua peperʉ sawiwatsi. ");
INSERT INTO cui_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nexata Jesús barai bapon, jeye: —Jopa yabara tsipaebinde ichamonaetha xua neaxaibiwam. Saya jame meisa ponde sacerdotemonaepintha xua nenaitʉtsinexa xua bapon necataenexa xua bayatha nejumewa. Bapontha care pocotsiwa xua pecatsiwa Nacomtha, pocotsiwa xua bayatha Moisés cui itoroba xua equeicha jopa jinya nenataxobinexa jinya pepontha. Bapoxonae daxita jiwi cayaputaena xua tsita itapeinya xeinatsi xua xam bara jumem yawa xua perʉ wʉnaem, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ichitha daxita jiwi tajʉ beya jume taetaepona pocotsiwa Jesús exana. Pin bicheiton nacaetutapona Jesustha pejume taenexa tsane pocotsiwa Jesús exana. Mataʉtano nacaetutapona xua Jesús peaxaibi exanaenexa barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ichitha Jesús ichaxota jiwaibi bara beya poneiba compa. Baxotiya Paxatha tsipaebeiba. ");
INSERT INTO cui_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Caentacabi Jesús cuidubauya. Irʉrʉ baxotiya ena pomonae fariseomonae jiwana tatsi. Irʉ baxota ena pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi. Barapomonae daxita tsiqui tomaraxi werendena po tomaraxi ena Galilea nacuatha. Irʉ daxita tsiqui tomaraxi werendena po tomaraxi ena Judea nacuatha, irʉ ichamonae Jerusalén tomara werendena. Nacom pia peayapusʉ itorobi coyenewa tatsi Jesús yawenatsi, daxota axaibi exana peatene jiwi. ");
INSERT INTO cui_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nexata pebiwi pata. Barapo pebiwi carendena pon pecuenobinchi. Xua xota pocotsiwatha maiteiba, barapomonae barapocotsiwatha carendenatsi pecuenobinchi. Barapomonae bepa bomʉxʉtha cajojoniyaei xua bepa Jesús peitabaratha tabotichei. ");
INSERT INTO cui_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ichitha barapomonae jopa cajojoniyaeyo bomʉxʉtha tsipei pin bicheito boupa quecona. Barapo bo matatupa pereca. Nexata daxota barapo bo matatupa beenoinya. Barapomonae barapo penta tupa weatsa caxina xoreca. Nexata barapomonae nantiya opi quetabe bʉmacatha barapo pemaiteibiwatha. Bapoxonae bara weyawa yorecatsi barapo pecuenobinchi jiwi pexainya deca tatsi, Jesús peitabarayo decano tatsi. ");
INSERT INTO cui_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús tane xua barapomonae yabara cui jume cowʉnta xua Jesús bara peitacʉpaewatsi xua axaibi peexanaewatsi pon pecuenobinchi. Daxota Jesús barai pecuenobinchi, jeye: —Tajiton cayabara cui jʉntemainatsiba abe jinya neexanae cuiru coyenein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nexata pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene, irʉ fariseomonae, daxita barapomonae caemonae natsipaeba, najei: “Maisa bapon bichocono abe tsipei pocotsiwa bapon paeba bichocono Nacom tsita ajumebetsi. Jiton dapocotsin aibi pon xua jiwi cacui yabara jʉntemainaya jʉntʉ puxana exanatsi abe pia peexanae cuiru coyenein tatsi. Jame meisa apara caein Nacom yaputane xua jiwi cacui yabara jʉntemainaya jʉntʉ puxana exanatsi abe pia peexanae cuiru coyenein tatsi”, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ichitha Jesús yaputane xua barapomonae caemonae natsipaeba. Jesús barai barapomonae, jeye: —¿Eta pocotsiwa metha baxua pana natsipaebame? ");
INSERT INTO cui_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Eta po jumetha baran tsane pecuenobinchin? ¿Metha jan tsane: ‘Abe jinya neexanae cuiru coyenein cata jʉntemainatsi’, jan tsane? Ichacuitha ¿metha jan tsane: ‘Asiya uncuatabare yawa ponare’, jan tsane? ");
INSERT INTO cui_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Daxota aunxuae paca tsita itapeinya xeinaeinchi xua xan ponxaein Nacom Tananeitapetsin, xua xeinan taayapusʉ itorobi coyenewa xua bara tana neitacʉpaewa xua jiwi tayabara cacui jʉntemainaya jʉntʉ puxana exanaewa abe pia peexanae cuiru coyenein tatsi pomonae jinompa barapo cae pin nacuathe, jei Jesús. Bara nexata pecuenobinchi Jesús barai, jeye: —Catsipaebatsi, nontaponde. Jinya nemaituncuaewa pire. Jinya bo be-iyandeno, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bapoxonae pon pecuenobinchi caena nainya nontapona barapomonae peitʉtha tatsi, yawa pita xua pemaituncuaewa. Pia bo be-iya yawa Nacom wʉnae jaintatsi poxonae namtotha ecapona. ");
INSERT INTO cui_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Barapomonae daxita yabara najʉntʉ coyene cabenaeca yawa Nacom wʉnae jaintatsi. Barapomonae junuwiya namchiya jeye: —Anoxuae waxainchi tainchi xua pewʉnaewa pocotsiwa jopa yaputaetsi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Poxonae baxua Jesús nacui weta, bapoxonae Jesús pontaba. Jesús tane pebin pon pewʉn Leví. Leví bapon pon paratixi pentoma noteibin po paratixi jiwi bewa catsibina pon romanomonae pia pepa peyanacua ewatsinchi nexa. Bapon eca ichaxota paratixi matoma noteibeca. Jesús Leví baraichi, jeichichi: —Nepuna ponde, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Bapoxonae Leví nontapona. Daxita baxua xubota, cuenta pona. Bapoxonae Jesús puna poinchi. ");
INSERT INTO cui_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Pirapaeyo Leví pin penabanaewa exana pia botha xua Jesús tsiexanatsi. Irʉ pebiwi pinmonae pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae pia pepa peyanacua ewatsinchi nexa, barapomonae Jesús barʉ eca pexaethopeibiwatha, irʉ ichamonaeno barʉ enatsi penabarʉ nabanaenexa tsane. ");
INSERT INTO cui_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ichitha fariseomonae irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa, daxita barapomonae Jesús pijimonae abeya tsipaebatsi xua Jesús yabara. Barapomonae namchi, Jesús pijimonae tatsi baraichi, jeichichi: —Maisa Jesús abe exana poxoru barʉ xayeca pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae pia pepa peyanacua ewatsinchi nexa. Mataʉtano barʉ xayeca pomonae abe peexanae cuiru coyene peexanaewi, jeichichi Jesús pijimonae tatsi barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús jume nota barapomonae, jeye: —Pomonae ba xua xaniwaicha jinompa xua jopa ateneyo barapomonae ba jopa canantawenonaeyo pon jiwi peyawʉbin. Saya jame meisa pomonae ba atene canantawenona pon jiwi peyawʉbin. ");
INSERT INTO cui_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Barichinno xan patopan apara tha jopa tawabinexa tsane pomonae pejʉntʉ coyene xanepanae jiwi. Apara tha meisa tawabinexa tsane pomonae peajʉntʉcoyenebe jiwi, xua barapomonae icha jʉntʉ coyene pexeinaenexa tsane Nacomtha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nexata barapomonae fariseomonae irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene, daxita barapomonae Jesús yainyabatsi, jeichichi: —Pomonae Juan pia pepuna jinompaewichi jopa juniya nainboteibiyo xua jopa juniya tsipaebeibiyo Nacomtha. Irʉ pomonae fariseomonae barichirʉ. Ichitha nama jinyamonae daxua jopa cou daichiyo, saya cou ʉ penabaneibi xuano saya ʉ peapeibi cou, jeichichi Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús jume nota barapomonae, jeye: —Paxam jopa bewa paexanaem tsane xua ichamonae nainbotsina, pomonae patsiwabame pexaewa xua penabanaenexa xua poxonae pebin pecotsiwa pita. Poxonae cataunxuae awiya bapon eca poxonae jiwi nabane, jopa ba bapoxonae nainbotsi. ");
INSERT INTO cui_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ichitha icha pon aena piowa pita, bapon caena nainya waetabatsi, ichamonae waetaba xua bapon tajʉ pecaponaenexatsi, bapoxonae jame jiwi ba bewa wecoyeya yabara nainbotsi, xua equeicha bapon caewa pepatopaewa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mataʉtano Jesús pecayabara jʉta pepaebi diwesiyo tsipaeba barapomonae, jeye: —Jiwi ba jopa exanaeyo xua pena dorouto tsiwiyo jiwana caxinaxubeta xua peru dorouto pewan botsinexa. Icha baxua exanaetsipa xua pena paparuwatha wan bota peru doroutotha, bapoxonae barapo dorouto abe tsanaya. Tsipei poxonae barapo dorouto matanaxuba barapo pena paparuwa natsaquetabiya. Poxonae barapo pena paparuwa natsaquetabiya equeicha wan tsitsipanarena barapo dorouto. Bapoxonae equeicha pin wan tsanaya beyacaincha xua poxonae copiya. ");
INSERT INTO cui_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mataʉtano jiwi ba pena vino mera jopa eparecaeyo peru bocototha, tsipei icha baxua exanaetsipa, barapo pena vino mera abe exanaetsipa barapo bocoto tsipei barapo bocoto jopa nayeyetaponaeyo poxonae barapo vino mera atsaxa. Barapo pena vino mera naxuba xuano barapo bocotono naxuba poxonae barapo bocoto tsitsica. ");
INSERT INTO cui_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Daxota bewa jame pena vino mera eparecae pena bocototha. Bapoxonae pena vino mera jopa naxubiyo, xuano pena bocoto jopa nacubiyo poxoru boco yeyena xuano poxoru pena bocoto. ");
INSERT INTO cui_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pon ba xua peru vino mera apa pirapaeyo jopa ichipaeyo pena vino mera. Bapon jei: ‘Maisa peru vino mera xeica, beyacaincha pena vino mera’, jei. ");
INSERT INTO cui_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Caentacabitha judiomonae barompaya pia pentaquei seicae matacabitha tatsi Jesús pijimonae barʉ iya pabi iyiya. Jesús pijimonae tatsi xunumenapona trigo xu, bapoxonae barapomonae pecobetha xu mata pepeta yawa xu xane. ");
INSERT INTO cui_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nexata Jesús pijimonae tatsi tayainyabatsi, fariseomonae yainyaba, jeye: —¿Eta pocotsiwa baxua paexaname? Apara jiwi jopa yabara cui copatsiyo xua ichamonae penacuichiwa barapo matacabithe, xua judiomonae barompaya pia pentaquei seicae matacabi tatsi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús jume nota barapomonae, jeye: —Barapo tajimonae jopa apara abe exanaeyo. ¿Jopa payabara yorobim pocotsiwa bayatha David exana poxonae jainpa poxonae irʉ pijimonae tajainpatsirʉ? Bapon David pon caena bayatha Israel nacuamonae itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Bapon David irʉ pijimonae tatsi barapomonae Nacom pin pia botha jojoniya. David xane pan, po pan ichamonae cana exana xua Nacomtha pecatsiwatsi. Irʉ barapo pan David pijimonae cata xua pexaenexarʉ. Barapomonae xane bequein barapo Nacom pia peitorobi coyenewatha copata xua saya meisa sacerdotemonae itacʉpatsi xua pexaewa barapo pan. ");
INSERT INTO cui_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús namchi, jeye: —Xan ponxaein Nacom Tananeitapetsin taitorobi coyenewa xeinan xua jiwi tacoya taitorobiwa pentaquei seicae matacabitha, jei Jesús fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Icha matacabitha judiomonae pia pentaquei seicae matacabitha tatsi Jesús joniya judiomonae pia penacaetutsi botha tatsi. Mataʉtano tamropata pitaba xua cuiduba barapomonae. Barapo botha eca pon pecoxa weya pecobe mʉbinchi. ");
INSERT INTO cui_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, irʉ fariseomonae baxota ena. Daxita barapomonae Jesús necotenatsi pecui taenexatsi icha bara metha Jesús cobe wʉnae exanaena pentaquei seicae mataqueitha pon pecobe mʉbinchi. Icha Jesús pon pecobe mʉbinchi axaibi exanatsi, bapoxonae barapomonae xeinaena po coyenewa xua Jesús abe peyabara paebiwatsi tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ichitha Jesús yaputane pocotsiwa barapomonae nanta xeina. Jesús barai pontha pon pecobe mʉbinchi, jeye: —Nontaponde, uncuare xote, jei Jesús. Bapon nontapona, asiya uncua Jesús peitabaratha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nexata Jesús barai ichamonae, jeye: —Paca yainyabinchi, ¿eta xua copata pentaquei seicae matacabitha? ¿Wʉnae jampa? ¿Abe jampa? ¿Eta xua, xua exana jane? ¿Xua pebin capanepatsi jampa? ¿Xua pebin bexotsi jampa? ¿Eta xua jane? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nexata Jesús naita muxunene cauncuapona, tane pomonae pematawacaicha enaewichi. Jesús barai pon pecobe mʉbinchi, jeye: —Nacobe doire, jei Jesús. Bapon nacobe doita. Nainya cobe wʉnae tsanaya. ");
INSERT INTO cui_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ichitha barapomonae bichocono Jesús casebarʉcʉpatsi. Barapomonae caemonae natsipaeba najei: —¿Etabe cui yabara ichainchi Jesús? jei barapomonae fariseomonae. ");
INSERT INTO cui_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Barapo matacabintha Jesús pona demxuwatha petsipaebinexa Paxa. Baraxotiya Jesús Paxa matowa tsipaeba barapo merawitha. ");
INSERT INTO cui_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Poxonae baya xometo pentha tsina bapoxonae Jesús pijimonae waba. Barapomonae jiwana itapetsiya waba doce poyobe, pomonae baraichi xua jeye: “Jesús pia peitorobi jiwi tatsi”, yabara jeichichi. ");
INSERT INTO cui_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Meje barapo doce poyobe pomonae Jesús pia peitorobiwi tatsi. Meje barapomonae: Simón, pon icha wʉn “Pedro”, baraichi, irʉ ichʉn pewʉn Andrés, pon Simón peweicho tatsi, irʉ ichʉn pewʉn Santiago, irʉ ichʉn pewʉn Juan, irʉ ichʉn pewʉn Felipe, irʉ ichʉn pewʉn Bartolomé. ");
INSERT INTO cui_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Irʉ ichʉn pewʉn Mateo, irʉ ichʉn pewʉn Tomás, irʉ ichʉn pewʉn Santiago, pon Alfeo pexanto tatsi, irʉ ichʉn pewʉn Simón, pon celotemonaepin. ");
INSERT INTO cui_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Irʉ ichʉn pewʉn Judas, pon Santiago pexanto tatsi, irʉ ichʉn pewʉn Judas Iscariote, pon Jesús caenaetaxubatsi ichamonaetha xua Jesús pebexubinexatsi. ");
INSERT INTO cui_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Barapo doce poyobe Jesús demxuwa webarʉ dunareca, peira matafatanaewatha barʉ patopa. Baxota peira matafatanaewatha pin bicheito Jesús ewatumeinchi. Ichamonae pomonae Jesús pejume cowʉntsiwichi baxota umena. Irʉ Jerusalén tomarapiwi pata xua Judea nacuapiwi. Barichi Tiro tomarapiwi, Sidón tomarapiwino pata. Barapo tomarabe mar mene itapatha ecabe. Daxita barapo pin bicheito pata xua Jesús pejume taenexatsi xua cueicueijei xuano xua Jesús pia axaibi exanaetsi peatene jiwi. ");
INSERT INTO cui_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Pomonae cauri pexeinaewi barapomonae Jesús taitaweta cauri. ");
INSERT INTO cui_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Daxita jiwi ichichipa xua Jesús pejayabiwatsi tsipei Jesús daxita jiwi axaibi exana pia peayapusʉwatha. ");
INSERT INTO cui_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nexata Jesús pijimonae necota. Jesús barai pijimonae, jeye: “Pajʉntʉ coyene weiweiname bequein anoxuae peacopeibi jiwi pam. Tsipei Nacom pia pejume cowʉntsiwichi tatsi piamonae tatsi pam, pomonae Nacom jʉntʉ coyene itorobiya ewata. ");
INSERT INTO cui_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Pajʉntʉ coyene weiweiname, bequein bara anoxuae pajainpame, bexa tsane patonsanaename. “Pajʉntʉ coyene weiweiname, bequein bara anoxuae pawecoyam, bexa tsane bichocono pajʉntʉ coyene weiweinaename. ");
INSERT INTO cui_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Pajʉntʉ coyene weiweiname poxonae bequein jiwi paca ita aenae-aenei, bequein paca itaweta bo weya xuano poxonae bequein abeya paca muxutainyaba. Mataʉtano poxonae bequein jiwi paca yabara abe paeba. Barapomonae baxua paca cana exana tamonae jiwi pamxaem xua xan ponxaein Nacom Tananeitapetsin. ");
INSERT INTO cui_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Bichocono pajʉntʉ coyene weiweinare barapo matacabitha, tsipei peitabocotheicha Nacom paca catsibina pia pexeinya peitʉpanaewan pocotsiwan Nacom paca jʉntana jeba pia nacuatheicha. Icha barapomonae paca ichi, barapomonae pia pamo susato jiwi tatsi, Nacom pia peitorobi jume pepaebiwi barichichi abeya biatainchi yawa abe exanatsi. ");
INSERT INTO cui_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“¡Ichitha pai jaibo paxam, anoxuae copei paacabem tsobenaem poxoru methaunxuae equeicha jopa painya neraichiwa tsane! ");
INSERT INTO cui_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Pai jaibo, paxam pomonae anoxuae patonsanabename tsipei methaunxuae bexa tsane pajainpabenaename! “¡Pai jaibo, paxam pomonae pajʉntʉ coyene weiweinabename tsipei anoxuae methaunxuae pajʉntʉ coyene wecoyam tsane! ");
INSERT INTO cui_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Pai jaibo, pomonae jiwi wʉnae paca jainteibena painya necueicueijeixae po diwesi jopa Nacom Pejume Diwesiyo! ¡Icha barapomonae paca ichi barichi barapomonae pia pamo susato jiwi tatsi, wʉnae jainta pomonaetha pomonae naerabiya paeba xua pinae barapomonae Nacom pia peitorobi jume pepaebiwi!” jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","28","Equeicha Jesús namchi, jeye: “Paxamtha pomonae beta pana nejume taneme, barapomonae paca baraichi: Paantobeinde pomonae bequein painya nepaca caaitafaetabi jiwi. Mataʉtano beta pata taexande pomonae paca ita aenae-aenei. Mataʉtano amanaya beta papaebare pomonaetha pomonae paca yabara abe paeba. Nacomtha patawʉcare pomonae xua paca biatane. ");
INSERT INTO cui_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Icha ichʉn paca jumata tsaquinopa pecobetha, moya equeicha icha jumata pana najumata caeware xua painya necajumata tsaquinopaenexa. Icha ichʉn pacata pita peamʉtiyʉ camisa, po camisa xua athawe peruyaewa yawa bara saya moya pacopare xua equeicha painya nepacata pichiwa tsane camisa. ");
INSERT INTO cui_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Daxita coyenexi pocotsiwa ichamonae paca wʉca moya bara pacaichabeibare. Pon pacata pita painyawa jopa equeicha caewa pawʉcaeinde. ");
INSERT INTO cui_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Paexande ichamonaetha xua po coyene painya neichichipaewa xua barapomonae beta painya nepacata exanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Icha saya meisa paantobem pomonae painya nepaca antobexae, Nacom jopa paca cui yabara matomacae tsane. Tsipei apara irʉ pomonae peajʉntʉcoyenebewi antobe ichamonae pomonae peantobewixaetsi. ");
INSERT INTO cui_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Barichi icha saya beta pata exaname pomonae beta pacata exana, Nacom jopa paca cui matomatsiyo tsaneno baxua. Tsipei pomonae peaitabe jiwi barapocotsi coyene irʉ exana ichamonaetha pomonae peaitabe jiwitha. ");
INSERT INTO cui_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Barichi icha saya pacatsibame ichamonae xua bexa xuya painya nepaca catsibinexa, Nacom jopa paca cui matomatsiyo tsane baxua. Tsipei pomonae peaitabe jiwi barichi icha peaitabe jiwitha catsiba xua xuya equeicha pecatsibeibinexatsi. ");
INSERT INTO cui_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Paxam jame bewa paantobem tsane painya nepaca caaitafaetabi jiwi, xuano jame beta bewa paexanaem ichamonaetha. Mataʉtano jame bewa bara pacatsibim ichamonae xua jopa painya neyabara ewateibiwa xua xuya painya nepaca catsibeibiwa tsane. Icha baxua paexanaename Nacom paca catsibina pia nacuatheicha pocotsiwa xua paca jʉntana jeba pia nacuatheicha. Mataʉtano Nacom paca cana exanaena pia pexanton jiwi tatsi pam, pon peitabocotha eca. Tsipei Nacom pejʉntʉ coyene xanepanaein, daxota yawena barapomonaetha, pomonae bequein xua jopa wecobe noteibiya jacobeibiyo xuano xua peaitabe jiwi. ");
INSERT INTO cui_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Payabara cui nanta xeinare po coyene xua ichamonae painya neyawenaewa. Icha be Nacom ichi xua yabara cui nanta xeina po coyene xua peyawenaenexatsi jiwi, bara paichinde”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Equeicha Jesús namchi, jeye: “Jopa ichamonae payabara paebinde xua penatsicuentsiwa xua abe peexanaexae. Nexata bapoxonae Nacom jopa paca yabara paebi tsane painya xua nenatsicuentsiwa xua abe painya exanaexae. Ichamonae jume daunweya jopa pajande: ‘Apara bapon picoya, apara bapon picoya’, jopa pajande. Nexata Nacom jopa paca daichi tsane baxua. Pacui yabara jʉntemainare po coyene ichamonae pacata abe exana, nexata Nacom paca cui yabara jʉntemainaena xua abe painya neexanaewa. ");
INSERT INTO cui_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ichamonaetha, jopa juniya pacatsibinde, nexata Nacom jopa juniya paca catsibi tsane. Painya dorotha paca catsina, beta pacata pesabina, yawa beta pacata xatabacorecaena pecobetha yawa pacata nʉnʉcʉtaxuina. Yawa pacata wʉnca exanaena. Icha daunweya payabara paebiname xua penatsicuentsiwa ichamonae xua abe peexanaexae, Nacom barichi daunweya paca yabara paebina xua painya nenatsicuentsiwa xua abe painya neexanaexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús tsipaeba barapomonae pecayabara jʉta pepaebi diwesiyo, jeye: “Pon ba peitata nacʉtsin jopa itacʉpaetsi xua pematacaponaewa ichʉn pon irʉ peitata nacʉtsin. Icha bapon baxua exanaetsipabe, baponbe fetotha joparecaetsipabe. ");
INSERT INTO cui_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pon ba aena nacuiduba xua peyaputaenexa, bapon jopa be bapocotsinyo, pon pecuidubin jiwi, pon peyaputaein. Ichitha pon poxonae wetsina xua nacuiduba, bapon be pia pecuidubin cui jʉpa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Barichi equeicha Jesús paeba caeintha pomonae pijimonae tatsi jiwana icha pecayabara jʉta pepaebi diwesiyo, jeye: “Xam be jinya jiton itata taneme poxonae naepʉtiyo itata jopiyatsi, ichitha jopa taem xua irʉrʉ xam nama pin naepʉto neitacueretotha ducua. Barapocotsi jʉta coyeneya ichi, xam ba jinya jiton cui taneme xua poxonae abe exana, ichitha jopa nayaputaem xua irʉrʉ xam bara ichim nama bichocono abe exaname. ");
INSERT INTO cui_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Icha jopa taem pin naepʉto xua neitacueretotha ducua, jopa caitacʉpaeyo xua nejeiwa jinya jitontha: ‘Tajiton, cata jutinchi naepʉtiyo xua ducua neitacueretotha’, xua nejeiwa. Xam nepaebin xua ichʉn exana xua baxua neexanaewatha irʉ. Xam copiya nata jure barapo pin naepʉto xua neitacueretotha ducua. Bapoxonae beta taename nejutsinexa tsane naepʉtiyo xua jinya jiton peitacueretotha tarucuatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesús namchi, jeye: “Po naein pexeinya naein jopa bapana nacoichiyo po pethei camatsa thei. Barichi po naein camatsa naein jopa bapana nacoichiyo po pethei pexeinya thei. ");
INSERT INTO cui_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jiwi yaputane nae po nae penacoichixae. Daxita jiwi yaputane xua higo thei, po pethei pexeinya thei jopa bapana teracae po naetha sojei xua camatsa nae. Mataʉtano jiwi yaputane xua uva thei po thei ʉnbototha xuwa jopa bapana teracae naexitha. Bara jʉta ichi jiwi yaputane xua pebin pejʉntʉ coyene xanepanaein pon xanepanaya peexanaeinxae. ");
INSERT INTO cui_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pon ba pejʉntʉ coyene xanepanaein, bapon ba jame ba paeba pocotsiwa pexeinya coyene, pejʉntʉ coyene xanepanaeinxae. Barichi pon ba peajʉntʉcoyenebein bapon ba abe paeba, peajʉntʉcoyenebeinxae. Pocotsiwa jiwi nanta xeina pejʉntʉ coyenetha, baxua ba pecoiboto tsina cueicueijei”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Equeicha Jesús namchi, jeye: “Paxam pana neyabara jam: ‘Patatanecanamataxeinaem’, pajam, daichitha jopa paexanaem pocotsiwa paca itorobatsi. ");
INSERT INTO cui_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Incane yabara paca tsipaebinchi pon xua patopa taxantha, nejume naitomata pocotsiwa paeban, mataʉtano exanano pocotsiwa ichichipan, bapon beta popona Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bapon barapocotsi jʉta coyeneya nacana exana icha be ichi pon bo acabanota peira matatsucaewatha xua ichaxota ira daunwei. Meje jeye: Copiya mʉthʉn tajʉ exanareca pecuaranobinexa bomʉxʉ naeton. Poxonae mene matacaewaxuba, barapo bomʉxʉ jopa joparenaeyo poxoru naeton tajʉ umenareca xuano poxoru bomʉxʉ uncua pematatsucaewatha ichaxota ira daunwei. ");
INSERT INTO cui_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ichitha nama pon nejume taetha, xuano jopa exanaeyo pocotsiwa ichichipan, bapon be meje: Bapon be pocotsin bo acabanota ichaxota ira matafatsana, xuano naeton jopa tajʉ umenarecaeyo. Poxonae mene matacaewaxuba, barapo bomʉxʉ joparena poxoru naeton jopa tajʉ umenarecaeyo, xuano poxoru bomʉxʉ uncua ichaxota ira matafatsana. Barapo bomʉxʉ nainya joparena. ¡Maisa bomʉxʉ bichocono abe!” jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Poxonae Jesús baxuan najume weta xua barapomonae jume tane, bapoxonae Capernaum tomara beya pona. ");
INSERT INTO cui_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Baxotiya popona romanomonae soldadomonae pia pentacaponaein tatsi, pon xeina pia petanacuiteibinchixaetsi. Barapon bichocono antobe pia petanacuitinchi. Bapon pon petanacuiteibin bichocono atene, xua awatha petʉpae. ");
INSERT INTO cui_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Poxonae romanomonae soldadomonae pia pentacaponaein tatsi Jesús yabara jume tainchi, bapoxonae itoroba pitiri jiwi judiomonae jiwanapiwi Jesús beya xua petaaxaibi exanaenexa tsainchi pia petanacuichin tatsi. ");
INSERT INTO cui_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Barapomonae Jesús imoxoyo caquita poinchi. Barapomonae Jesús jume daunweya tsipaebatsi, jeichichi: —Barapo pentacaponaein, pentacui xanepanaein, daxota yawende. ");
INSERT INTO cui_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Poxoru bapon wanacuamonae wʉnae yabara cananta xeineibatsi. Mataʉtano bapon itoroba xua acaba pata penacaetutsi bo pia paratixitha, jei barapo pitiri jiwi. ");
INSERT INTO cui_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nexata Jesús barʉ poinchi barapomonae. Ichitha poxonae Jesús muxu pepatopae, romanomonae soldadomonae pia pentacaponaein tatsi pia botha tatsi, barapo soldadomonae pia pepa pentacaponaein tatsi, bapon itoroba pia jiwi xua petacajume jeichinexa tsainchi Jesustha: “Tanecanamataxeinaein, xan saya tacui pawin. Auran xua xam nepatopaewa tsane tabotha tsipei xam ainya cuim. ");
INSERT INTO cui_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Daxota jopa patopaeinyo nexainya beya, tsipei xam ainya cuim, xua paebiname pia peatenewatha tatsi bapoxonae bapon axaibi bara tsane pon inta nacuiteiba. ");
INSERT INTO cui_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Xan bichi xeinan tanecanamataxeinaein, pon neitoroba. Barichirʉ xeinan soldadomonae pomonae itorobeiban. Poxonae ichʉn itoroban: ‘ponde’, jan, bapon pona. Poxonae ichʉn waban: ‘antha’, jan, bapon patopa. Pon inta nacuita, itoroban: ‘inta exande’, jan, inta exana”, jeye pentacaponaein, jei pomonae penacajume caitorobixaetsi. ");
INSERT INTO cui_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Poxonae Jesús baxua jume taeba, jume cui yabara cananthʉthʉ nanta xeinanaya cabenaeca beta pepaebixae romanomonae soldadomonae pia pentacaponaein tatsi. Jesús necotaba pomonae puna poinchi, barai, jeye: —Xaniyan paca tsipaebatsi Israel nacuatha irʉ dapocotsin jopa caxinaeinyo pocotsin icha pon iche pon tana necui yabara jume cowʉntsin xua bara neitacʉpa xua axaibi taexanaewa jiwi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Poxonae barapomonae botha caibe nawibiya, barapomonae taeba dʉcʉpa xua axaibiya boca romanomonae soldadomonae pia pentacaponaein tatsi pia petanacuichin tatsi. ");
INSERT INTO cui_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Poxonae Jesús baxua nacui weta, bapoxonae Naín tomara beya pona. Jesús cueyabatsi pijimonae, irʉ pin bicheitomonaeno napona. ");
INSERT INTO cui_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Poxonae Jesús muxu pepatopae tomaratha, Jesús tane xua pewowin petʉpaein cajojondenatsi xua pemʉthʉthʉ xubinexa tsainchiba, pon pena tsita compa. Barapo pewowin powa pecuenta tʉpaewayotsi piseuri barapowa pexanto tatsi. Barapowa puna poinchi pin bicheito. ");
INSERT INTO cui_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bapon Jesús pon Pecanamataxeinaeinxae jiwi, barapowa yabara cui nanta xeinatsi. Jesús barai bapowa, jeye: —Jopa wecoyande, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nexata Jesús imoxoyo caquita pona petʉpaein, yacaja jayabano. Pomonae yacaja capona yacaja caumenarʉcʉpa. Jesús barai petʉpaein, jeye: —Pewowin catsipaebatsi, nontaponde, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nexata pewowin pon tʉpa, nantacotecataba, yawa tamropata pitaba xua pecueicueijeiwa. Jesús coxiwatha cana cobenata pexanto. ");
INSERT INTO cui_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Poxonae pin bicheito taerʉcʉpa baxua, barapo pin bicheito bichocono junuwa. Barapoxonae barapo pin bicheito Nacom wʉnae jaintatsi, barapomonae namchi: —Nacom peitorobi jume pepaebin, pon ainya cui, waxantha patopa. Nacom siwa pona peyawenaenexa pijimonae pomonae pia pejume cowʉntsiwichi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Daxita jiwi jume tane xua Jesús exana Judea nacuatha, irʉ po nacuan imoxoyo caquita ena Judea nacuatha. ");
INSERT INTO cui_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan pijimonae tsipaebatsi daxita baxua xua Jesús exana. Juan waba ainya pebinbe pijimonae jiwana tatsi. ");
INSERT INTO cui_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Baponbe Juan itoroba Jesús beya xua najume caruta baponbetha mataʉta xua Jesús peyainyabinexatsi xua icha metha bara baponde jei pon bewa patopeicaena, bapon Cristo, jei. Ichacuitha metha ichʉn jampa, xua pawʉnae ewatsin jampa jei. ");
INSERT INTO cui_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bara baponbe ponbe Juan peitorobixaebe, baponbe imoxoyo Jesús caquita uncuatsibe. Baponbe Jesús baraichi: —Juan pon jiwi Pebautisabin, bapon pana nejume caruta, bapon namchi: ‘¿Metha bara xaniwaicha baponda, pon bewa patopeicaena, bapon Cristo?’ jei. ‘¿Ichacuitha metha bara ichʉn pawʉnae ewatan jampara?’ jei Juan, jei baponbe. ");
INSERT INTO cui_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Poxonae baponbe patopabe, Jesús axaibi exana peatenewi, irʉ pomonae pin domae xainchi, yawa taitaweta pomonae cauri xeina. Mataʉtano yawenano xua equeicha tane pomonae jopa necotsiyo. ");
INSERT INTO cui_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Baponbe jume notatsibe. Jesús jume nota, jeye: —Paponarebe Juan beya. Juan patsipaebarebe xuaunxuae pocotsiwa panecui tanemebe, mataʉtano xuaunxuae pocotsiwa pana nejume tanemebeno. Mataʉtano patsipaebarebe xua pomonae peitata nacʉtsi jiwi equeicha tane, mataʉtano xua pomonae pejayujayujeimonae beta pona equeicha. Mataʉtano xua pomonae peperʉ sawichimonae equeicha perʉ wʉnae, mataʉtano xua pomonae pemuxusipanaewi equeicha muxu nasaba, mataʉta xua pomonae pewerapaewi equeicha asʉ. Mataʉtano pomonae xua peacopeibiwi jume tane Nacom pia pexeinya pecapanenebiyae diwesi jume. ");
INSERT INTO cui_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Patsipaebare Juan xua xan janje: ‘Jʉntʉ coyene weiweinaena pon jopa ainya ʉnthʉthʉnyo, pon xaniwaicha neyabara cui jume cowʉnta’, xua jan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nexata ponbe Juan itorobabe ponabe Juan beya. Bapoxonae Jesús tsipaeba jiwitha, xua Juan yabara paebatsi, jeye barapomonaetha: “Ira xuepana susato tsurucuae nacuatha paponame. Poxonae bara beya paponame, ¿eta xua painyatsi? ¿Painya jume taetsi pebin pon ainya ʉnthʉthʉto cui xeina icha be naepanaewa ichi xua saya joibo ba jʉbabiya caya tsaibi? Jume apara. ");
INSERT INTO cui_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bara paichim paponame, ¿painya nejume taenexa pebin, pon peitʉpanae paparuwa nama xatata? Jume apara. Payaputaneme pomonae peitʉpanae paparuwan nama xataba, barapomonae jinompa pexeinya bontha pomonae jiwi itorobiya pia pepa peewatsiwixaetsi. ");
INSERT INTO cui_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Jume. Jopa baxua patsiponaem xua jopa painya jume taenexa pebin pon ainya ʉnthʉthʉto cui xeina, mataʉtano xua jopa painya jume taenexa pebin pon peitʉpanae paparuwa nama xatata. Apara jame baxua patsiponame xua painya nejume taenexa pon Nacom peitorobi jume pepaebin. Bapon Juan bichocono peainya cuin pon Nacom pia peitorobi jume pepaebiwi jiwanapin beyacaincha ichʉn pon Nacom peitorobi jume pepaebin. ");
INSERT INTO cui_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan bapon apara, pon yabara paebatsi Nacom Pejume Diwesitha poxonae Nacom netsipaeba, nejei: ‘Catsiwanae itorobinchi copiya pon tana nacajume carutsin. Barapon jʉntʉ cui wʉnaetsina jiwi, xua daxita jiwi najʉntʉ cui wʉnaetsina xam nexa, xua necantenta weyataeya wabinexa poxonae patopaename’, nejei Nacom Pejume Diwesitha. ");
INSERT INTO cui_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Paca tsipaebatsi, xua daxita Nacom peitorobi jume pepaebiwi pomonae Juan tsiwanaya jinompatsi bayatha, dapocotsin aibi barapomonae jiwana pon yatsicaewa peainya cuin beyacaincha pon Juan, pon jiwi Pebautisabin. Juan peainya cui diwesi yabara cueicueijei po coyene xua Nacom itorobina jiwi. Ichitha po diwesi xua tamonae anoxuae paeba barapo diwesi bichocono ainya cui diwesi beyacaincha xua Juan cueicueijei, bequein jiwi nanta xeina xua tamonae jopa ainya cui jiwi. ");
INSERT INTO cui_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Daxita barapomonae baxua jume taerʉcʉpa. Irʉrʉ jume taerʉcʉpa pomonae paratixi pentoma noteibiwi romanomonae pia pepa peyanacua ewatsinchi nexa, pomonae bayatha Juan bautisaba. Daxita barapomonae nanta xeinarʉcʉpa xua Nacom bara pepa pentacui xanepanaein. ");
INSERT INTO cui_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ichitha fariseomonae irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, barapomonae jume itaweta, Nacom jume itawetatsi pocotsiwa xua Nacom beexanaena barapomonae nexa. Mataʉtano barapomonae cui itaweta, Juan cui itawetatsi xua pia pebautisabi coyenewa. ");
INSERT INTO cui_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Jiwi pia Pecanamataxeinaeinchi tatsi, bapon Jesús namchi, jeye: ¿Eta pocotsimonae cui jʉpatsi barapomonae pomonae xote jinompe pomonae Nacom jume itawetatsi? ¿Etabe jʉta ichi barapomonae? ");
INSERT INTO cui_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Barapomonae be pexui, pocotsixi panatha nabarʉ jinompa. Nabarʉ wawai tsurubenanaebiya. Barapoxi nabarai, jeye: ‘Bayatha oibo paca tsimuxu obatsiba ichitha jopa panawirabim. Bayatha paca tsimuxu wecoyeichiba icha be ichi poxonae ichʉn tatʉpatsi, ichitha jopa pana itanuwe jume notsim xua painya newecoyeinexarʉ’, jei barapoxi. ");
INSERT INTO cui_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan patopa pon jiwi Pebautisabin. Bapon jopa xaeyo pan. Mataʉtano jopa apaeyo vino mera. Ichitha paxam pajam: ‘Apara Juan puna popoinchi cauri’, pajam. ");
INSERT INTO cui_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Bapoxonae xan, ponxaein Nacom Tananeitapetsin patopan. Xan pan taxaein yawa vino mera taapaein. Paxam pana neyabara paebame, pajam: ‘Bapon maisa jopa juniya nabanaeyo, yawa jopa juniya apaeyo. Peatsacae jiwi abe peexanae jiwi pia jiton tatsi, irʉ pomonae paratixi pentoma noteibiwi barapomonae pia jiton tatsi’, pana neyabara jam. ");
INSERT INTO cui_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nacom piamonae tatsi barapomonae tsita exana xua jiwi tsita exanatsi Nacom pia peyaputae coyeneintha tatsi. Po coyene barapomonae exana baxua Nacom tsita pexeinya coyenetsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Caein fariseomonaepin bapon Jesús wabatsi petaxaenexa tsainchi pia botha. Jesús pona bara beya yawa naeca pexaethopaewatha penanabanaenexa tsane. ");
INSERT INTO cui_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nexata petsiriwa patopa powa pesi cui weiweinaewa, powa barapo tomaratha popona. Barapowa yaputane xua Jesús nanabanaeicha fariseomonae jiwanapintha. Barapowa alabastro ibo wʉn bosibʉ atsato capatopa Jesustha xua petuxuei nasiwa xua bichocono wʉnca. ");
INSERT INTO cui_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Barapowa Jesús imoxoyo caquita wecoyei tsuncuaetsi yawa peitacuere mentha Jesús taxu atatsica exanatsi. Bapoxonae barapowa pia pentanatha baxota Jesús taxu tsewa exanatsi. Barapowa Jesús taxu tsutsubatsi poxoru Jesús Pecanamataxeinaein jiwi. Bapoxonae barapowa Jesús taxu epatabatsi petuxuei nasiwatha. ");
INSERT INTO cui_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Poxonae fariseomonae jiwanapin pon Jesús pewabixaetsi petaxaenexa tsane pia botha, poxonae bapon tane baxua, bapon pia coutha nabarai: “Icha bapon xaniwaicha tsipae pon Nacom peitorobi jume pepaebin tsipae metha yaputaetsipa xua powa jayabatsi apara powa pesi cui weiweinaewa, mataʉtano xua bapowa powa peatsacaewa. Ichitha bapon xaniwaicha jopa daponyo pon Nacom itoroba”, jei barapon pon fariseomonaepin. ");
INSERT INTO cui_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Nexata Jesús barai fariseomonae jiwana jiton, jeye: —Simón incane catsipaebinchi, jei. Bapon jume nota, jeye: —Pon jiwi Necuidubimxae, moya taema, jei. ");
INSERT INTO cui_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús barai, jeye: —Pebinbe nacueyatabe nacowaetabe paratixi ichʉntha. Ichʉn jopa cataunxuae xuya catsiyo quinientos po paratiximonaebe po paratixi quinientos po matacabibe nexa poxonae nacuita. Ichʉn jopa cataunxuae xuya catsiyo cincuenta po paratiximonaebe pontha pon penacowaetsixaetsi. ");
INSERT INTO cui_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Poxoru baponbe jopa itacʉpaetsibe xua xuya equeicha pecatsiwa tsanebe pontha pon penacowaetsixaebe, daxota pon penacowaetsixaetsi paratixi, bapon namchi, jeye: ‘Metha basaya paca cui yabara jʉntemainatsibe’, jei. Incane netsipaebare Simón xua baponbe, ¿jintam yatsicaewa antobetsira xua beyacaincha ichʉn antobetsi xua antobe pon nacowaetatsi paratixi? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón jume nota, Jesús jume notatsi, jeye: —Bʉ, metha moya pon bichocono cacui yabara jʉntemainatsi bichocono pon penacowaetsixae quinientos po paratiximonaebe, jei Simón. Jesús barai: —Bara beta nejume notame, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nexata Jesús necota barapo petsiriwa, bapoxonae Jesús Simón baraichi: Taema pocotsiwa barapo petsiriwa inta exana. Xan patopan jinya botha ichitha jopa meratha netaxu waexubim xua painya cui coyeneyathaxae xua judiomonae pamxaem. Nama barapowa peitacuere mentha netaxu atatsica exana yawa pia pentanatha netaxu tsewa exana. ");
INSERT INTO cui_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Xam jopa netsutsubim, ichitha bapowa poxonae caena jonarenan awiya came netaxu tsutsuba. ");
INSERT INTO cui_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jopa nenta epatabim petuxuei tuxusi nasi mera. Ichitha barapowa petuxuei tuxusi nasi mera netaxu epataba. ");
INSERT INTO cui_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Daxota catsipaebatsi xua bapowa matowa nasi cui matacaeta. Daxita baxuan yabara jʉntemainan, daxota bichocono neantobe. Ichitha nama pon be conotha nasi cui matacaeta, be conotha yabara cui jʉntemainan. Bapon be conotha neantobe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Equeicha Jesús namchi bapowatha. Petsiriwa baraichi, jei: —Cacui yabara jʉntemainaya jʉntʉ puxana exanatsiba abe jinya neexanae cuiru coyenewan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pomonae Jesús pebarʉ nabanaexaetsi, barapomonae nabarai, jeye: —Bapon, ¿jintamda, jamaisa bapowa cacui yabara jʉntemainaya jʉntʉ puxana exanatsi abe pia peexanae cuiru coyenewan tatsi? jei barapomonae pomonae baxota naena. ");
INSERT INTO cui_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús barai petsiriwa, jeye: —Bayatha necacapanepaewa caexainchi tsipei yabara tana nejume cowʉntsixaem. Saya jʉntemiya poponde, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Bapoxonae pirapae Jesús daxita tomarantha pona ducuanaeta, tsica tomaraxithano po tomarantha pin tomaranthano. Mataʉtano paeba ducuanaeta Nacom pia pexeinya jume diwesi tatsi po diwesi yabara xua Nacom waba jiwi petanaexanaenexatsi piamonae pomonae Nacom jʉntʉ coyene itorobiya ewata. Jesús yanabatsi pia peitorobiwi tatsi pomonae doce poyobe. ");
INSERT INTO cui_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Barichi Jesús yanabatsi petsiriwaxi, powaxi Jesús bayatha taitaweta cauri xuano axaibi exanano xua domae xainchi. Barapowaxi jiwana caewayo pewʉn María Magdalena, tsipei pia tomara tatsi pewʉn Magdala. Barapowa María powa bayatha taitawetatsi siete poyobe cauri. ");
INSERT INTO cui_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Bichirʉ petsiriwa, powa pewʉn Juana, bapowa napona. Bapowa Juana, Cuza piowa tatsi. Bapon Cuza pon Herodes pia bo tatsi tayapucaecatsi. Irʉ ichowa pewʉn Susana, bapowa napona. Irʉ ichowaxi ainya yabʉxirʉ napona. Daxita barapowaxi Jesús ʉpain exaneibatsi xua xoxi barapowaxi pexeinaexae. ");
INSERT INTO cui_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Daxita tomaranpiwi pata. Poxonae pin bicheito nacaetuta Jesús cuiduba barapo bicheito po diwesiyo pecayabara jʉta pepaebi diwesiyo. ");
INSERT INTO cui_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jesús barai: “Pebin pon peʉbin pontaba pia ʉbichi pabitha. Poxonae pon peʉbin ʉbauya, icha xu namtotha othopeica, pexu jiwi taxunaunaba, yawa pepupunaewi xu xane. ");
INSERT INTO cui_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Icha xu, xu othopeica ibowantha. Poxonae barapo xu xuwa, barapo xu, xu yʉnna poxoru jopa tajʉ xuwarecaeyo poxoru ibotixi nacʉcʉna yawa poxoru ira tsewa. ");
INSERT INTO cui_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Icha xu, xu othopeica ichaxota pesoiwan xuwinaena. Barapo xu yaboto nanta capanaba poxoru yawa muxuna xuwina pesoiwan. ");
INSERT INTO cui_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Icha xu, xu othopeica ichaxota ira wʉnae. Poxonae barapo xu, xu xuwa, xu nawʉnaeta. Cae xuto nacoita cien po xu matabʉxʉyobe”, jei Jesús. Poxonae Jesús baxua paeba, bapoxonae jume daunweya namchi: “Icha pamuxu dubename, moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nexata Jesús yainyabatsi pijimonae, barapomonae namchi, jeye: “¿Eta pocotsiwa yabara caunutame poxonae pana netsipaebame barapo pecayabara jʉta pepaebi diwesiyo?” jei bapomonae. ");
INSERT INTO cui_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús jume nota, jeye: “Meisa paxam yatsicaewa Nacom yabara paca yaputane exana po pecuidubiwa xua moya peyawʉn xeinaewa. Barapo moya peyawʉn xeinaewa apara xua Nacom exana xua paca cana exana xua painya nepaca itacʉpaewa xua painya nenaexanaewa Nacom piamonae tatsi pam, pomonae pamxaem Nacom itorobiya paca ewata. Ichitha jame ichamonae meisa pomonae jopa nejume cowʉntsiyo jopa daichichi Nacom jopa copatsiyo xua barapomonae peyabara yaputaewa baxua. Daxota barapomonae cuiduban pecayabara jʉta pepaebi diwesintha xua Nacom peyabara yaputaenexatsi. Baxua paeban xua bequein pia tana necui taibenaewatha tsane ichitha jopa pia tana necui yaputaibenaewatha tsane. Yawa xua bequein pia tana nejume taibenaewatha tsane ichitha jopa pia tana nejume copi taibenaewatha tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Equeicha Jesús namchi: “Meje apara baxua yabara caunutan poxonae paeban pecayabara jʉta pepaebi diwesiyo: Po xuto xua iratha xuwa nacoichiya xanepanaya exana. Barapo xuto yabara caunuta Nacom Pejume Diwesi xua poxonae pebin jʉntʉ coyene webocatsi pebin wʉnaeya xanepanaya cana exanatsi. ");
INSERT INTO cui_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Po xuton xua namto beothopiya, aichurubenae. Barapo xuton yabara caunuta xua jiwi bara jʉntʉ coyene weichichi caurimonae pia pentacaponaein tatsi. Jiwi jʉntʉ coyene weajumetsurubenae exanatsi Nacom Pejume Diwesi xua bayatha po jume jume tane, xua bapoxonae jopa petajume cowʉntsinexa tsainchi Nacom, yawa xua jopa petana capanenebiyaenexa tsainchi Nacom beya xua Nacom exanaena. ");
INSERT INTO cui_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Po xuton xua xu othopa ibowantha, barapo xuton yabara caunuta po jiwi xanepanaya jume tane Nacom Pejume Diwesi xuano jʉntʉ coyene weiweinaya Nacom jume cowʉntatsi. Ichitha bara caeto jume cowʉnta poxoru barapomonae antʉfaetabiya jume jeba Nacom Pejume Diwesi pejʉntʉ coyeneintha. Mataʉta cauri jʉntʉ coyene wemuxu paeba xua abe peexanaenexa tsane. Daxota barapomonae cayabara jʉntemaina Nacom. ");
INSERT INTO cui_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Po xuton xua xu othopa pesoiwantha barapo xuton caunuta xua pomonae Nacom Pejume Diwesi jume tane ichitha saya barompaya pia jʉntʉ coyeneyatha jinompa, yawa saya ʉ copei cayabara nanta xeina, yawa saya exana pocotsiwa jʉntʉ coyene weiweina cana exanatsi. Po coyene pebiwi exana baxuan barapocotsi jʉta coyeneya exana icha ichi xua po xuton be pesoiwantha xu othopiya. Barapo xuton jopa thei dubenaeyo. Barapocotsi jʉta coyeneya ichi, barapo jiwi jopa xanepanaya jinompaeyo Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Po xuton xua xu othopeica peira wʉnaewatha, bara nacoita. Barapo xuton yabara caunuta pomonae jume tane Nacom Pejume Diwesi xuano jume cowʉntano poxoru jʉntʉ coyene xanepanaya jume tane. Mataʉtano beta exana dubenanaebiya beya matapainya jiwi cui tane xua barapomonae jʉntʉ coyene xanepana Nacom peitabaratha tatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Equeicha Jesús namchi: “Poxonae jiton pecoicha coicha exana bapoxonae jopa coicha matacatsiyo. Mataʉta jopa coicha exanaeyo cama peʉpana deca. Jame asiya coicha exanatsi, pecoicha taenexa pomonae jojoneibarena. ");
INSERT INTO cui_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Daxita pocotsiwa xua moya peyawʉn xeinaewa bexa tsane jiwi yabara yaputaena. Barichi barapo diwesin xua pecayabara jʉta pepaebi diwesin xua paebaponan jiwi itacʉpaeinchi xua peyabara yaputaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Pana nejume naitaeware painya neexanaenexa pocotsiwa paca tsipaebatsi. Pon ba be conotha Nacom yabara yaputainchi, Nacom bapontha cana exanaena xua ichawa peyabara yaputaewa tsane beya poxonae bapon equeicha bichocono Nacom pejume cowʉntsiwa tsainchi. Pon ba jopa ichipaeyo xua Nacom peyabara yaputaewatsi, Nacom wepichina po coyene bapon yaputane xua beya daxota Nacom jopa pejume cowʉntsiwa tsainchi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nexata Jesús pena tatsi irʉrʉ peyapin jiwi tatsino pata ichaxota Jesús uncua. Ichitha jopa Jesús imoxoyo caquita ponaetsi tsipei bichocono pin bicheito. ");
INSERT INTO cui_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ichʉn Jesús baraichi: —Ena, irʉrʉ neyapin jiwino pesato beya umena. Bepara bequein cataei, jei bapon. ");
INSERT INTO cui_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús namchi barapomonaetha: —Apara jame be taena tsicotan yawano be tayapin jiwi tsicotan pomonae xua jume tane Nacom Pejume Diwesi xuano xua exana pocotsiwa Nacom itoroba, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Caentacabi Jesús barʉ pona pijimonae jeratha. Jesús pijimonae barai: —Antha, poinchi icha muxunene beya, pucua beya, jei Jesús. Bara ponarʉcʉpaba. ");
INSERT INTO cui_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Poxonae cataunxuae jeratha yana enapona bapoxonae Jesús maituncuataba. Bapoxonae jemeicha pin joibo naetaba mentha. Mataʉta bichocono jera mene wʉnca, muxu pebunarecae. ");
INSERT INTO cui_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nexata Jesús yaʉbaxotsi. Jesús baraichi: —¡Jesús, Patatanecuidubim, yana bunarecatsi! jei barapomonae. Nexata Jesús nacosataxuba. Jesús itawetaxuba joibo maratsacano. Daxita caewanaya joibo yawa maratsacano. ");
INSERT INTO cui_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nexata Jesús barai pijimonae: —¿Jopa pana nejume cui yabara jume cowʉntsim xua bara tana neitacʉpaewa xua tapaca yawenaewatsi? jei Jesús. Barapomonae bichocono junuwa yawa najʉntʉ coyene cabenaecarʉcʉpa. Barapomonae caemonae natsipaeba, jeye: —¿Jintam metha baponda? ¡Jamaisa bapon itaweta joibo yawa maratsacan xua daxita xainya dubenanaya! najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pirapaeyo jebouna Gerasa nacua itapatha, po itapa eca Galilea nacua icha itapa panawa beya. ");
INSERT INTO cui_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Poxonae Jesús muxu penontounae jeratha, pebin pon copiya tomarapin pon equeicha aisowapin naexana, bapon patopa. Jesús caquita uncuatabatsi. Caena bayatha bapon puna jinompatsi caurimonae. Paparuwa jopa yawa poponaeyo, mataʉtano botha jopa poponaeyo, saya ibo wountha poponeiba. ");
INSERT INTO cui_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Poxonae Jesús tainchi, iratha jopa. Pentabocototha uncua bapon, Jesús peitabaratha tatsi. Jume daunweya wawai: —Jesús, Nacom Pexantom, pon peitabocotha eca. ¿Eta pocotsiwa metha patopame taxantha? ¡Jume daunweya cabaraichi jopa neperaxa exanaeinde! jei. ");
INSERT INTO cui_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Daxota bapon baxua paeba yaitama Jesús taitaweta cauri xua peponaenexa bapon pia xainya weya tatsi. Bapon matowa teiqueibatsi cauri. Bayatha bequein jiwi taxu cʉbeiba yawa pemaxʉno penaintotha xua bapon xua jopa peponaenexa, ichitha bapon nain xuneiba. Bapon ira xuepana susato tsurucuae nacua beya itorobeibatsi cauri. ");
INSERT INTO cui_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús yainyaba: —¿Eta po wʉm? jei Jesús. Bapon jume nota exanatsi Jesustha. Bapon namchi, jeye: —Tawʉn ayei, jei. Baxua namchi tsipei bayatha cauri bicheito cunto pata bapontha. ");
INSERT INTO cui_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Equeicha barapo pebin cueicueijei exanatsi barapo cauri bicheito cunto. Barapo cauri cunto namchi, jeye: “Jesús jopa pana neitawetsinde po nacua ira bereca ichaxota jiwi atene tsaibi”, jei bapon xua cueicueijei exanatsi cauri. ");
INSERT INTO cui_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pin marrano duweimonae pitapatororotha jinompa xua yawa xayompano. Caurimonae Jesús jume daunweya wʉcatsi, jeye: “Pana nepu copabare marrano duweimonaetha”, jei. Jesús namchi: “Moya pataema”, jei. ");
INSERT INTO cui_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nexata caurimonae pebin wepu ponatsi, yawa marrano duweimonaetha pata. Barapo marrano duweimonae dʉcʉpa, pin pitapatororo othopareca. Pucuatha bunothopa. Caurimonae cabunothopatsi. ");
INSERT INTO cui_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pomonae yapu eena barapo marrano duweimonae junuwiya cuinaenouta tomarantha xuano tomaran aisowapiwi, xua pepaebinexa xua baxua exana. ");
INSERT INTO cui_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jiwi poxonae baxua tane, pata baxota ichaxota Jesús uncua. Tainchi pon wepu poinchi caurimonae. Bapon Jesús petaxu deca taecatsi, xuano paparuwa nama xatateca. Axaibiya eca, be pocotsin jopa matsiyaibichi. Barapo jiwi junuwa nawita. ");
INSERT INTO cui_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Pomonae copiya tane, barapomonae equeicha tsipaeba ichamonaetha pomonaetha pomonae jopa taeyo po coyene xua bapon equeicha jume xua copiya bequein caurimonae pexeinaewa. ");
INSERT INTO cui_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Poxonae daxita barapo Gerasa nacuapiwi jume tane baxua, daxita barapomonae Jesús itawetatsi xua pewarapaenexa bara weya xua Gerasa nacua weya, poxoru barapomonae junuwa bichocono. Daxota Jesús jeratha nontabiya bara warapano. ");
INSERT INTO cui_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pebin, pon wepu poinchi caurimonae, Jesús wʉcatsi xua bepara puna ponaetsei Jesús. Ichitha Jesús jopa copatsiyo xua pepuna ponaewa tsainchi bapon. ");
INSERT INTO cui_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Jinya bo beya ponare. Daxita paebare jiwitha xua bayatha Nacom cata exana, jei Jesús. Pebin nawiya tomara beya yawa daxita paebano tomaratha xua po coyene bayatha Jesús taexana xua bapon tacana exanatsi. ");
INSERT INTO cui_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Poxonae Jesús caibe patoparena Galilea nacua berena, jiwi Jesús matenta weiweinaya wabatsi, tsipei daxita barapomonae Jesús ewatatsi. ");
INSERT INTO cui_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nexata pebin patopa pon pewʉn Jairo. Bapon Jairo pon canamataxeina judiomonae pia penacaetutsi bo tatsi. Jesús petaxutha irabe tatayecarecatsi. Baxua Jairo exana poxoru Jesús pon ainya cui peexanaeinchi. Bapon Jairo Jesús jume daunweya wabatsi, jeye: “Antha tabotha ponare”, jei Jairo. ");
INSERT INTO cui_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Bapon baxua paeba tsipei Jairo pexantiyo saya compa tatsi. Barapowayo doce po weibe xeina. Bapowayo muxu petʉpae. Poxonae Jesús iya irʉ pin bicheito napona. Bichocono jiwi acʉcʉ. ");
INSERT INTO cui_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Barapo pin bicheitotha yabʉyo irʉ napona. Bapowa caena bayatha beya yadoce po weiyobe jopa xua pentabʉ janatha boca xua be nantawane. Barapowa daxita cobe caewitatsi xua peaxaibi exanaenexa tsainchi. Pomonae jiwi peyawʉbiwi cobe caewita daichitha jopa axaibi exanaetsi. ");
INSERT INTO cui_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Bapoxonae barapowa imoxoyo caquita uncuataba Jesús peputha tatsi. Barapowa Jesús pia paparuwa tatsi tajayabatsi xua peopirawa. Bapoxonae caena nainya bapowa ajaneibi tsanareca. ");
INSERT INTO cui_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nexata Jesús yainyaba barapo pin bicheitotha, jeye: —¿Jintam nejayabara? jei. Daxita barapomonae paeba xua pinae jopa jayabichiba. Daxota Pedro barai: —Patatanecuidubim, barapo pin bicheito acʉcʉ canapuna torobabiya tane, dacotsiwa jam: ‘¿Jintam nejayaba?’ jam, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ichitha Jesús jume nota: —Ichʉn nejayaba tsipei taayapusʉwa newepu jiwana aichurucuae xua axaibi exanan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Petsiriwa yaputane xua cobe yaputainchi xua Jesús cobe yaputane poxonae bapowa jayaba. Barapowa junuwiya patopa yawa pentabocototha uncua ira betaeuncuarecano Jesús petaxutha tatsi. Baxua exana bapowa poxoru Jesús ainya cui peexanaeinchi. Nexata barapowa namchi barapo bicheito peitabaratha, jeye: —Apara xan jayaban. Poxonae jayaban caena nainya axaibin, jei. ");
INSERT INTO cui_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nexata Jesús barai, bapowa baraichi, jeye: —Yabʉyo caaxaibi exanatsi tana neyabara jume cowʉntsixaem xua bara tana neitacʉpaewa xua tacaaxaibi exanaewatsi. Saya jʉntemiya poponde, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Poxonae cataunxuae Jesús tsipaebauya bapowatha, pebin patoparʉ pon Jairo pia bo tatsi weya pona. Bapon tsipaeba pontha pon pecanamataxeinaeinxae judiomonae pia penacaetutsi botha tatsi pon Jairo. Jairo baraichi, jeichichi: —Nexantiyo bayatha cata tʉpa. Jopa came fayacotsinde pon jiwi Pecuidubin, jeichichi Jairo bapon. ");
INSERT INTO cui_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ichitha poxonae Jesús jume tane baxua, xua Jairo baraichi, Jesús barai, Jairo baraichi, jeye: —Jopa junuwinde, maisa saya nejume cowʉnde. Nexantiyo cata axaibi tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Poxonae botha pata, Jesús jopa juntucuru bebarʉ joniyaeyo ichamonae. Saya meisa Pedro irʉ Santiago irʉ Juan irʉ powayo tʉpa paxa tatsi, bapon Jairo yawa pena tatsi, Jesús barʉ joniya barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Daxita barapomonae yabʉyo siwa wawaya wecoyeichi. Ichitha Jesús barai barapomonae, jeye: —Jopa pawecoyande, yabʉyo apara jopa tʉpaeyo, maituncua apara, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ichitha Jesús jume caponatsi barapomonae. Tsipei barapomonae yaputane xua yatsicaewa apara tʉpa barapowayo. ");
INSERT INTO cui_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Nexata Jesús jume daunweya cobe pichiya barai, jeye: —¡Ja, owae asiya uncuatabare! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Barapowayo equeicha petʉpaewa nacosataxuba, caena nainya asiya uncuataba. Jesús itoroba barapomonae xua barapowayo peapatsinexatsi pexaewa. ");
INSERT INTO cui_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Barapowayo paxa tatsi irʉ pena tatsi najʉntʉ coyene cabenaecaeya tanebe. Jesús barapomonae tsipaeba xua jopa cui yopichi tsainchi ichamonaetha xua po coyene bapon peexanaexae. ");
INSERT INTO cui_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús pijimonae caetuta pomonae xua doce poyobe. Yawa pijimonae cata pia peayapusʉwa. Mataʉtano catano peitorobi coyenewa xua barapomonae peitaweteibinexa tsane cauri xuano xua peaxaibi exanaenexa tsaibi tsane jiwi pomonae atene. ");
INSERT INTO cui_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jesús itoroba barapomonae xua barapomonae peyabara cueicueijeinexa tsane jiwitha xua po coyene Nacom waba jiwi xua petanaexanaenexatsi pijimonae pomonae itoroba peewatsixae. Mataʉtano itoroba xua barapomonae peaxaibi exanaenexa tsane jiwi pomonae atene. ");
INSERT INTO cui_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús barai pijimonae: —Jopa pacaponaeinde ichawa xua painya necawarapaenexa. Mataʉtano jopa iwabi pacaponaeinde, yawa jopa cote pacaponaeinde. Mataʉtano jopa pacaponaeinde pexaewa, yawa jopa pacaponaeinde paratixi. Saya cae camisa panama xatabare, jopa icha camisan pacaponaeinde. ");
INSERT INTO cui_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Botha po botha papatsiname, bara po botha painya nepu enaeinde bapoxonae barapo botha painya nepu warapaeinde. ");
INSERT INTO cui_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pomonae xua ichaxota jopa paca matenta weyataya wabiyo barapo tomara weya pawarapare. Pana taxu wenʉnʉbabare tsorobon po tsorobon painya taxutha dubena. Baxua paexande xua barapomonae peyaputaenexa xua abe exana paxamtha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bara barapomonae ponarʉcʉpa. Mataʉtano barapomonae pona daxita carepaya peya tomaraxitha. Mataʉtano papaeba tsiniya Nacom pia pecapanenebiyae diwesi jume tatsi. Yawa axaibi exana tsiniyano jiwi pomonae atene. ");
INSERT INTO cui_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Bapoxonae Herodes Galilea nacuapiwi pia peyanacua ewatsinchi daxita jume tane xua Jesús exana. Bapon Herodes jopa xapain beta nanta xeinaeyo. Tsipei ichamonae catsawa Jesús yabara namchichi: “Apara bapon Juan, pon bequein bayatha tʉpa, equeicha asʉ juina”, jei. ");
INSERT INTO cui_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Irʉ ichamonae namchi: “Bapon apara Elías, pon tsita naitʉta jiwitha”, jei. Irʉ ichamonae namchi: “Apara pomonae bayatha Nacom peitorobi jume pepaebiwi, barapomonae jiwana, bapon apara, pon petʉpaein equeicha juina”, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ichitha Herodes namchi: —Bara bayatha ichamonae cobe itorobacoumba xua Juan pewisi ucuibiwatsi. ¿Jintam metha bapon xua yabara jume tan nawita xua pinae peitʉpanaewan exana? jei. Herodes bichocono beyaitaena, Jesús beyaitaeinchi pon wʉnae peexanaein. ");
INSERT INTO cui_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Poxonae pata pomonae Jesús itoroba, barapomonae Jesús tsipaebatsi pocotsiwa xua barapomonae exana. Jesús tsana barʉ jopa barapo pijimonae tatsi xua pin bicheito weya. Ichaxota jiwi aibi, Jesús bara beya barʉ pona pijimonae, Betsaida tomara pecuariya beya barʉ pona. ");
INSERT INTO cui_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ichitha poxonae barapo bicheito yaputane xua xota Jesús ponaena, barapo bicheito irʉ Jesús puna poinchi. Jesús matenta weiweinaya waba barapo pin bicheito. Mataʉtano Jesús yabara tsipaeba barapo bicheitotha po coyene xua Nacom waba jiwi petanaexanaenexatsi pijimonae pomonae itorobiya pecanamataxeinaexae. Mataʉtano Jesús axaibi exana atenemonae. ");
INSERT INTO cui_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Poxonae imoxoyo tabopiya Jesús barompaya pijimonae tatsi pomonae xua doce poyobe, barapoyobe Jesús imoxoyo caquita umenarʉcʉpatsi. Jesús baraichichi, jeye: —Barapo bicheito itorobare pejeichinexa tsane xua ichaxota maichina xuano xua pexaewa pejeichinexa tsane tomaranxitha yawa po bon pipatotha umena, poxoru xote aibi pexaewa yawa bon xua ichaxota pemaichiwa tsane, jeichichi Jesús pijimonae. ");
INSERT INTO cui_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ichitha Jesús barai pijimonae: —Paxam paapare pexaewa, jei Jesús. Jesús jume notatsi pijimonae: —Saya apara cinco po panbe paxeinan mataʉtano saya ainyoyobe paxeinan duweiyobe. Apara acoibi tsipei pin bicheito. Metha paponan pata comotsinexa icha pexaewa, daxita barapomonae nexa, jei. ");
INSERT INTO cui_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Barapo bicheito be cinco mil pebiwi. Nexata Jesús pijimonae barai: —Pana nantaʉre xua ichamonae tsana eeniyaena be cincuenta po matabʉxʉyobe tsiniya, jei. ");
INSERT INTO cui_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bara Jesús pijimonae tatsi exana pocotsiwa xua Jesús paeba. Bapoxonae barapo pin bicheito iratha ena. ");
INSERT INTO cui_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bapoxonae Jesús pan pita cinco po panbe, yawa duwei ainyobe pitano. Jesús itaboco benecoicha, Paxa tsipaeba: “Axa, maisa jʉntʉ coyene weiweinan xua pexaewa pata tanecatsiwaxaem”, jei Jesús. Poxonae Jesús epa janaquiya nacobe weta, pijimonae caitoroba xua pecatsibaponaenexa tsane barapo bicheitotha. ");
INSERT INTO cui_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bara daxita nabane, yawa bara daxita jain cowʉntarʉcʉpatsi. Bapoxonae Jesús pijimonae tatsi doce po cote matabʉxʉyobe wʉnba xua bayatha nacopaba pocotsiwa xua bayatha barapo jiwi jopa xaeyo petonsanaexae. ");
INSERT INTO cui_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Caentacabitha Jesús Nacom tsipaebawiya, meisa pijimonae barʉ pona. Bapoxonae Jesús yainyaba pijimonae, jeye: —¿Eta jiwi neyabara jei po coyene xua xan bapon aparan? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Barapomonae Jesús jume notatsi, jeye: —Ichamonae cayabara, jei: ‘Apara bapon Juan pon jiwi Pebautisabin, pon equeicha petʉpaein asʉ juina’, jei. Irʉ ichamonae cayabara, jei: ‘Apara bapon Elías, pon equeicha petʉpaein asʉ juina’, jei. Irʉrʉ ichamonae cayabara, jei: ‘Apara bapon jiwana pomonae Nacom peitorobi jume pepaebiwi, pon petʉpaein equeicha asʉ juina’, jei, Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nexata Jesús pijimonae yainyaba, jeye: —Incane irʉ paxamdʉ, ¿eta pana neyabara jumichimdʉ xua xan eta pondʉn? jei Jesús. Pedro jume epa pita: —Xam apara Mesías, pon Nacom caitorobica, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús pijimonae muxu barai, xua pijimonae jopa peyabara paebinexatsi ichamonaetha baxua. ");
INSERT INTO cui_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yawa barai pijimonae po coyene xua bexa ichamonae Jesús cana exanaeinchi. Jesús namchi, jeye: —Xan ponxaein Nacom Tananeitapetsin, jiwi bichocono neperaxa jʉbina. Mataʉtano pitiri jiwi irʉrʉ sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi, daxita barapomonae neitawetsina. Mataʉtano barapomonae nebexubina. Ichitha equeicha asʉ poponaein poxonae acoibi po matacabiyobe tsuxubi tsane, jei Jesús poxonae nayabara paeba. ");
INSERT INTO cui_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Bapoxonae Jesús barai daxita pijimonae, jeye: —Icha pebin ichichipa xua tajiwimonae jiwanapin penaexanaewa tsane bewa bapon yabara naitematsi pocotsiwa xua bapon ichichipa pia peexanae coyenewan tatsi. Bapoxonae jame bapon bewa eexanaponae daxita matacabi pocotsiwa itoroban bequein bara bapon bexotsi ichamonae, tajiwimonae jitonxae. ");
INSERT INTO cui_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pon naantobeya nata exana pocotsiwa bapon ichichipa, bapon jopa xeinaeyo peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. Ichitha pon neantobeya inta exana pocotsiwa ichichipan bapon xeinaena peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. ");
INSERT INTO cui_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Icha pebin bichocono copei xeina pocotsiwa xeina po cae pin nacuathe, ichitha jopa xeinaeyo peajʉntʉcoyenesʉwa, po peajʉntʉcoyenesʉwa ataya tsiteca, bapoxonae bapon jopa itacʉpaetsi xua penajʉntʉ coyene capanepaewa xua jopa peweraweracaewa. ");
INSERT INTO cui_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Icha ichʉn neacaura, yawa nejume diwesi acaurano, xan ponxaein Nacom Tananeitapetsin xuya bapon acauran tsane. Baxua exanaein poxonae patopaetsicaein be jiwi pia pecanamataxeinaein tatsi yaitʉpanae susato patopaetsicaein. Taxa pia peitʉpanaewa tatsi yawa patopeicaein. Mataʉtano Taxa pia matatsunpiwi tatsi nebarʉ patsicaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bara xaniwaicha paca tsipaebatsi xua pomonae xote umene abʉ barapomonae jopa werapae tsane. Barapomonae jiwana copiya matha necotsina xua po coyene Nacom waba jiwi xua petanaexanaenexatsi piamonae pomonae itorobiya peewatsixae, bapoxonae barapomonae werapaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Poxonae ocho po matacabibe jopa xua poxonae Jesús barapo diwesi paeba, bapoxonae Jesús pona demxuwa beicha petsipaebinexa Nacom. Pedro irʉ Juan irʉ Santiago barapo matabʉxʉyobe barʉ poinchibe. ");
INSERT INTO cui_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Poxonae Jesús cataunxuae Nacom tsipaebauya, bapoxonae icha itabara tsanaya. Mataʉta penama xatatsiwano inyapana tsanaya yawa bichocono daedaena tsanaya. ");
INSERT INTO cui_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nexata pebinbe yaitʉpanae be damacu patopabe. Baponbe, irʉ Jesús, bapoyobe nabarʉ cueicueijeibe. Ponbe xua Jesús jemeicha tsita patopatsibe, bapon Moisés irʉ ichʉn pewʉn Elías, ponbe xua caena bayatha naxubabe. ");
INSERT INTO cui_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Baponbe yabara barʉ cueicueijeibe xua Jesús petʉpaewa tsane xua peraxa jʉbinchi ichamonae Jerusalén tomaratha. ");
INSERT INTO cui_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Bequein Pedrobarʉ bichocono itamaipana daichitha nacosatumena. Pedrobarʉ tane xua Jesús yamatawacaicha pexeinya itʉpanae be damacu tsuncuaetsi. Mataʉtano Pedrobarʉ tane ponbe Jesús barʉ uncua, Moisés irʉ Elías. ");
INSERT INTO cui_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisés irʉ Elías, poxonae baponbe Jesús weya naetababe, bapoxonae Pedro Jesús baraichichi, jeye: —Jiwi Necuidubin, maisa wʉnae xua xote pata umenaewa. Pacata acabinchi acoibi po boutobe, cae bouto xam nexa, icha bouto Moisés nexa, icha bouto Elías nexa. Ichitha Pedro beta jopa yaputaeyo xua baxua paeba. ");
INSERT INTO cui_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Poxonae Pedro cataunxuae barʉ cueicueijei Jesús, bapoxonae daxita pexainya bematawacaicha taruneicatsi tsaquinaebowa. Poxonae barapomonae tsaquinaebowa tututha nataerʉcʉpa bichocono junuwa. ");
INSERT INTO cui_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nexata barapomonae tsaquinaebowatha pejume jume tane xua Nacom namchi, jeye: “Bapon apara Taxanto, pon bichocono antobein, pon itapetan. Bapon beta pajume taema pocotsiwa paca tsipaeba”, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Poxonae Nacom najume weta, Pedrobarʉ necobarʉcʉpa xua Jesús beya compa uncua. Pedrobarʉ saya moya. Jopa pejumeyo ichamonaetha xua tane. ");
INSERT INTO cui_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Baya poxonae Jesús barapo acoibi poyobe pijimonaebe dabe barʉ dunareca Jesús pin bicheito matenta poinchi. ");
INSERT INTO cui_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nexata barapo bicheitotha jiwana pebin, bapon jume daunwei wawai, jeye: —Jiwi Necuidubin, incane inta taema taxanto. Bapon taxanto inta compa pebin. ");
INSERT INTO cui_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Taxanto inta waetabatsi cauri, inta papai exanatsi, yawa inta iratha bebaichi. Mataʉta inta coibo thamthamei exanatsi poxoru matayaibatsi exanatsi. Inta taxanto cui tatainchi jopa bepu sorobabeibichi barapo cauri. ");
INSERT INTO cui_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Bayatha bequein jinyamonae jume daunweya cui itoroban: ‘Painta taxanto taitawere cauri’, jan. Ichitha jopa itacʉpaetsi xua taxanto inta petaitawetsiwatsi cauri, jei pewowin paxa tatsi. ");
INSERT INTO cui_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús barai pin bicheitotha, jeye: —¡Paxam barapomonae pam pomonae jopa xapain cataunxuae pana nejume cowʉntsim! ¡Paxam barapomonae pam, peajʉntʉcoyenebe jiwi pam! ¿Eta po weibe nantawenonan xua bewa tapaca barʉ ecaewa tsainchi xua beya poxonae tapana nejume cowʉntsiwam tsane? ¿Mataʉtano eta po weibe equeicha nantawenonan xua tapaca cayawenaewatsi tsainchi? jei Jesús. Nexata Jesús barai pewowin paxa tatsi, jeye: —¡Nexanto inta carenande! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Poxonae pewowin cataunxuae Jesús itiya poinchi, bapoxonae equeicha pewowin iratha xotsi cauri. Equeicha pewowin coibo thamthamei exanatsi. Ichitha Jesús taitaweta cauri pewowin. Jesús axaibi exana pewowin. Equeicha Jesús caewa cata. Coxiyan caewa catatsi pexantoxae. ");
INSERT INTO cui_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Daxita barapo pin bicheito yabara najʉntʉ coyene cabenaeca pocotsiwa pewowin pexeinya coyene taexanatsi Nacom. Poxonae awiya cataunxuae yabara najʉntʉ coyene cabenaecompa barapo pin bicheito pocotsiwa Jesús exana, bapoxonae Jesús pijimonae barai: ");
INSERT INTO cui_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Incane beta pajume taema, yawa jopa pana nejume cayabara jʉntemainaeinde. Xan, ponxaein Nacom Tananeitapetsin jiwi, necaenaetsina ichamonaetha xua tanebexubinexa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ichitha Jesús pijimonae jopa xapain jume yaputaetsi xua barai. Barapomonae jopa tacopatichi Nacom xua Jesús pejume yaputaewa tsainchi. Barapomonae junuwa xua Jesús yabara peyainyabiwa tsainchi xua Jesús yaputane peexanaenexa xuaunxuae paeba. ");
INSERT INTO cui_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nexata Jesús pijimonae tatsi caemonae yabara nayainyaba, najei: “¿Jintam paxantha bichocono peainya cuinda xua beyacaincha ichʉn?” jei. ");
INSERT INTO cui_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús yaputane baxua pocotsiwa barapomonae yabara nanta xeina. Nexata Jesús cobe pita pexuyo yawa pexainya cuaranoreca. ");
INSERT INTO cui_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nexata Jesús barai pijimonae: —Pon matenta weyataeya waba peyawenaenexa pontha pon tana nejume cowʉntsixae xua pocotsin icha be barapocotsi pexuyo ichi barapon bara apara nententa weyataeya waba. Xan jopa meisa nententa weyataeya wabiyo apara bara irʉ matenta weyataeya wabatsi pon tana neitorobixae xua pon bara Nacom. Daxota pon paxam jiwana pam, pon jopa paca tsita ainya cuiyo, bapon jame Nacom tsita ainya cuichi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nexata Juan Jesús baraichi, jeye: —Ja Tanecuidubim, paxan caein patan pon cawʉn taiba poxonae itaweta caurimonae, xua caurimonae itawetatsi. Paxan baxua pacui itawetan tsipei jopa naca puna poponaeyo, jei Juan. ");
INSERT INTO cui_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ichitha Jesús jume nota, jeye: —Jopa pacui itawetsinde, tsipei pon jopa nacata abe exanaeyo bapon ba apara naca yawena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Poxonae imoxoyo matacabi jopaena, po matacabitha Jesús athabe icha tsane, xua Nacom exanaena, bapoxonae Jesús bichocono awiya nantʉsʉba xua peponaewa tsane Jerusalén tomara beya. ");
INSERT INTO cui_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús nawʉnae jume caitoroba pia jitonbe tatsi. Barapo Jesús pia jitonbe tatsi ponabe Samaria nacua beya. Ponabe xua bo tutu pewʉcaenexa tsanebe po tomara barapo Samaria nacuatha eca xua Jesús peecaenexa. ");
INSERT INTO cui_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ichitha barapo tomarapiwi xua Samaria nacuatha jinompa, barapomonae aichaxaibi xua Jesús weiweinaya pententa wabiwatsi baxota poxoru barapomonae yaputane xua Jesús pona Jerusalén tomara beya. ");
INSERT INTO cui_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ichitha Santiago irʉ Juan poxonae baxua tanebe, ponbe bequein tawʉcabe bo tutu Jesús nexa, baponbe Jesús baraichi, jeye: —Patatanecanamataxeinaem, ¿xam ichichipame xua paxan isoto pawʉcaein po isoto xua itaboco wetsica xua petautsinexatsi barapomonae? jei baponbe. ");
INSERT INTO cui_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nexata Jesús pijimonae napatomeicha necota yawa jume itaweta. ");
INSERT INTO cui_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nexata equeicha Jesús pijimonae barʉ pona icha tsiqui tomariyo beya. ");
INSERT INTO cui_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Poxonae namtotha enapona, pebin Jesús baraichi, jeye: —Patatanecanamataxeinaem, ichichipan xua tacapuna ponaewatsi xua ichaxota poname, jei pebin. ");
INSERT INTO cui_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús jume nota, jeye: —Namomonae ba pia mʉthʉn xeina ichaxota pemaitathopeibiwa. Irʉ peyapupunaewi ba coton xeina ichaxota peyamaitathopeibiwa. Nama xan ponxaein Nacom Tananeitapetsin nama jopa daichinyo. Nama jopa xeinaeinyo bo xua tabo xua xota nafifinacaecan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús barai ichʉntha, jeye: —Nepuna ponde. Ichitha bapon Jesús jume notatsi, jeye: —Tanecanamataxeinaem, nepu copare xua taxa matha mʉthʉtha xubichi copiya xua bapoxonae tacapuna ponaenexatsi, jei. ");
INSERT INTO cui_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús jume nota, jeye: —Bara copare xua petʉpaewi mʉthʉcaeinchi, pomonae xua be pewerapaewi jopa betanejume cowʉntsiwixae, barapomonae mʉthʉcaena. Ichitha xam ponare jinya neyabara tsipaebinexa jiwitha po coyene xua Nacom waba jiwi petanaexanaenexatsi pijimonae pomonae itorobiya pecanamataxeinaexae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nexata ichʉn Jesús baraichi, jeye: —Tanecanamataxeinaem, ichichipan xua tacapuna ponaewatsi. Ichitha copiya bara necopare xua tana napeyabiwa tsane tamonae, tabopiwi, jei bapon. ");
INSERT INTO cui_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús jume nota: —Pebinba jopa itacʉpaetsi xua beta penacuichiwa pabi icha saya napatomeicha necobiya nacuita. Barapocotsi jʉta coyeneya ichi, icha pebin exana Nacom pia petanacuichiwa tatsi jopa xapain exanaeyo xua peyabara paebiwa po coyene xua Nacom waba jiwi petanaexanaenexatsi pijimonae pomonae itorobiya pecanamataxeinaexae icha bapon saya cayabara nanta xeina pocotsiwa barapo cae pin nacuathe xeina, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Barapoxonae Jesús pon jiwi Pecanamataxeinaeinxae tatsi, bapon itapeta equeicha icha pijimonae tatsi setenta y dos poyobe. Daxita tomarantha Jesús itoroba be dos poyobe tsiniya, tsica tomaraxithano, pin tomaranthano xua ichaxota Jesús cotacaya ponaena. ");
INSERT INTO cui_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesús barai barapomonae poxonae muxu peitorobi, jeye: “Bara xaniyeya paca tsipaebatsi. Pabitha ba pocotsiwa peʉbiwan naweta nawita, daichitha ba penacuichiwi pomonae jota pinmonae aibi. Bara jʉta ichi barapo cae pin nacuathe. Jiwi pinmonae jinompa pomonae nantawenona pejume taenexa Nacom pia pexeinya jume diwesi tatsi. Daichitha pomonae Nacom Pejume Diwesi cueicueijei tsurubenanaebiya ichamonaetha barapomonae pinmonae aibi saya tsiquimonaeyo. Daxota Nacom pawʉcare xua pecaitorobinexa tsane ichamonae xua petacamuxu tsipaebinexa tsainchi pia pejume diwesi pomonae barapo cae pin nacuathe pejinompaewi nexa. ");
INSERT INTO cui_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Paponde ichaxota paca itorobatsi. Paca itorobatsi pia xainya beya pomonae jopa jume cowʉntsiyo, pomonae itacʉpatsi xua abe painya nepaca exanaewa icha oveja ichi xua poxonae pona ichaxota neʉthʉ jinompa xua itacʉpatsi xua abe peexanaewatsi. ");
INSERT INTO cui_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jopa pacaponaeinde cote. Yawa paratixi jopa pacaponaeinde. Yawa jopa pacaponaeinde painya nenataxu xatabiwan. Mataʉta jopa ichamonae namtotha paewatumeyaeinde xua saya painya netsipaebinexa. ");
INSERT INTO cui_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Poxonae bomʉxʉtha pajojoniyaename, barapo bopiwi pajacobare, pajande: ‘Barabʉ Nacom jʉntema jinompa paca cana exanaena’, pajande. ");
INSERT INTO cui_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Icha baxota jinompa pomonae jʉntema jinompa, baxua Nacom taexanaena xua papaebame. Ichitha icha baxota jinompa pomonae jopa jʉntema jinompaeyo, baxua Nacom jopa taexanae tsane xua papaebame. Equeicha caewa pacata parenaena xua baxua papaebame. ");
INSERT INTO cui_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Barapo botha paenare. Paxaema paapareno pocotsiwa barapomonae paca apata. Painya xoba paauram xua paca cata tsipei baraxua xua paca cata painya matoma painya netanacuichixae Nacom. Jopa ichawa beya paponaeinde bontha, saya bara po botha paenare. ");
INSERT INTO cui_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Poxonae tomaratha papanenebiyam, icha barapomonae paca matenta weyataeya waba, moya paxaema pocotsiwa barapomonae paca apata. ");
INSERT INTO cui_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Axaibi paexande peatene jiwi, pomonae xua barapo tomaratha ena. Barapomonae pabarande: ‘Anoxuae Nacom waba jiwi xua petanaexanaenexatsi piamonae tatsi pomonae itorobiya peewatsixae’, pajande. ");
INSERT INTO cui_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Ichitha poxonae icha tomaratha papatsiname icha barapo tomarapiwi jopa paca matenta weyataeya wabiyo, pajande barapomonaetha: ‘¡Po tsorobon panataxu wenʉnʉbaban painya tomaratha, apara xua abe paexaname pata xainya berena poxonae pana nejume itawetame! Payaputaema, anoxuae Nacom waba jiwi petanaexanaenexatsi piamonae tatsi pomonae itorobiya peewatsixae ichitha pana nejume itawetame pomonae Nacom pata tana neitorobiwi panxaein’, pajande. ");
INSERT INTO cui_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Xaniyeya paca tsipaebatsi matacabi patopaena. Barapo matacabitha Nacom yabara paebina jiwi xua penatsicuentsiwa xua petsita exanaexaetsi. Barapo matacabitha jopa juniya bichocono atene tsane pomonae paca jume itaweta. Ichitha nama pomonae barapo tomaratha jinompa pomonae paca jume itaweta jopa juniya atene tsane, beyacaincha poxonae Sodoma tomarapiwi atene”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús equeicha pijimonaetha namchi, pomonae setenta y dos poyobe xua ichamonae yabara paebatsi, jeye: “¡Pai jaibo Corazín tomarapiwi tsobenae! ¡Irʉ Betsaida tomarapiwi tsobenae! Po tsita itʉtsi coyenewan exanan Corazín tomaratha yawa Betsaida tomaratha ichʉn jopa bapana exanaeyo barapo tsita itʉtsi coyenewan Tiro tomaratha yawa Sidón tomaratha. Icha barapo tsita itʉtsi coyenewan exanaetsipa Tiro tomaratha Sidón tomarathano, barapo tomaranbepiwi icha penanta xeinae coyenewatha yabara nanta pentsipa Nacomtha. Barapomonae iratha enaetsipa yawa paparuwan nama xatabichipa xua pocotsiwa be peru mapaton xua axʉn, yawa ipuna nacaxuebichipa pia pepontha. Barapomonae baxua exanaetsipa xua ichamonae petsita itapeinya xeinaenexa tsainchi xua icha jʉntʉ coyenein Nacom petsita xeinaewatsi peauraxae xua abe peexanaexae. ");
INSERT INTO cui_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Poxonae barapo matacabi patopeicaena po matacabitha Nacom yabara paebina daxita jiwi xua petsita natsicuentsixaetsi xua abe petsita exanaexaetsi, Tiro tomarapiwi, Sidón tomarapiwino, daxita barapo tomarabepiwi bichocono peraxa jʉbebinchi. Ichitha nama paxam pomonae Corazín tomarapiwi pam, irʉrʉ Betsaida tomarapiwi pamdʉ, daxita paxam jopa juniya paca peraxa jʉbebi tsane, beyacaincha xua peraxa jʉbebinchi Tiro tomarapiwi irʉ Sidón tomarapiwi. ");
INSERT INTO cui_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¡Incane irʉ Capernaum tomarapiwi pamdʉ! ¿Bara pananta xeiname xua paca capanenebiya tsane peitaboco beicha? Jume, apara paca itorobina petʉpae coyene cuiru bereca. ");
INSERT INTO cui_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Pon xua paca jume naitaewata, barapara nejume naitaewatarʉ. Pon xua paca jume itaweta, barapara nejume itaweta xan berena. Pon xua nejume itaweta, barichi Nacom jume itawetatsi pon xua tana neitorobixae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Barapo setenta y dos poyobe jʉntʉ coyene weiweinaya caibe nawibarena, jeye: —Patatanecanamataxeinaem, caurimonae pana nejume cowʉnta xua paitawetan poxonae paca wʉn wʉn taibatsi, jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús jume nota, jeye: —Aa, bara bayatha cauri pia pentacaponaein tatsi Satanás tan xua jopeica itaboco wetsica icha yamʉxʉ ichi poxonae uncueica. ");
INSERT INTO cui_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Paxam paca catatsi taayapusʉwa painya netaxunaunabaponaewa tsane jomon yawa pʉtonno, xua jopa painya nepaca capepeichinexa. Po peayapusʉwa paca catatsi bichocono daunwei, beyacaincha painya nepaca caaitafaetabi jiton, pon cauri pia pentacaponaein pia peayapusʉwa tatsi xua xota jiwi abe exanatsi. Jiwi dapomonae aibi pomonae abe paca cana exana. ");
INSERT INTO cui_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jopa pajʉntʉ coyene weiweinaeinde xua caurimonae pia paca jume jejeixae xua dʉcʉpa poxonae paitawetame, saya jame pajʉntʉ coyene weiweinare xua Nacom painya nepaca wʉn dubixae pia diborotha itabocotheicha. ");
INSERT INTO cui_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Bara caena bapoxonae Jesús jʉntʉ coyene weiweina exanatsi Nacom pia Pejumope tʉnaxʉ tatsi. Jesús namchi, jeye: “Axa peitaboco Necanamataxeinaem, yawa ira Necanamataxeinaem. Wʉnae cajaintatsi tsipei jopa tsita itʉbim pocotsiwa pexainyei coyenewa xan yabara pomonaetha pomonae bichocono penacuidubiwi pomonae be pinyon penatsicotaewi tsipei nanta xeina xua bichocono peyaputaewi daxita. Jame nama tsita itʉtame barapo pexainyei coyenewa xan yabara pomonaetha pomonae jopa bichocono penacuidubiwi pomonae be pexui penatsicotaewi tsipei jopa nanta xeinaeyo xua bichocono peyaputae jiwi daxita. Axa baxua exaname necatsita xanepanaexae baxua”, jei Jesús Paxatha. ");
INSERT INTO cui_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Equeicha Jesús pijimonae barai pomonae xua setenta y dos poyobe, jeye: “Taxa daxita necata xua pia peitorobi coyenewa tatsi mataʉtano xua pia peyaputae coyenewan tatsi. Dapon aibi pon xaniwaicha nejʉntʉ cui coyene yaputane. Jame saya meisa Taxa Nacom, nejʉntʉ cui coyene yaputane. Dapon ajibi pon Taxa jʉntʉ cui coyene yaputainchi ichʉn, saya meisa Taxaxae jʉntʉ cui coyene yaputan. Mataʉta barichi Taxa meisa jʉntʉ coyene yaputainchi pon saya bara copatan xua bara Taxa pejʉntʉ cui coyene yaputaewa tsainchi pomonae ichichipan”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nexata Jesús pijimonae napatomeicha necota pomonae xua doce poyobe. Meisa barapomonaebetha barai, jeye: “Jʉntʉ coyene weiweina pomonae xua tane, pocotsiwan xua pataneme. ");
INSERT INTO cui_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Poxoru paca tsipaebatsi, xua Nacom pia peitorobi jume pepaebi jiwimonae irʉ nacuan peewatsiwimonae, pomonae bayatha napenta barapomonae bequein betaena pocotsiwa pataneme ichitha jopa taeyo. Mataʉta barapomonae bequein bejume taena pocotsiwa pajume taneme ichitha jopa jume taeyo”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nexata irʉrʉ pon jiwi pecuidubin Moisés pia peitorobi coyene tatsi, barapon Jesús piraichi jʉntʉ coyene jʉjʉtsiya yainyabatsi xua barapon pejume barabotsinexatsi. Barapon Jesús jeichichi: —Ja Tanecuidubim, ¿eta xua copiya matha exanocuaein xua ajʉntʉyapusʉya tapoponaewa tsane xua ataya tsane? jei. ");
INSERT INTO cui_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús jume nota, jeye: —¿Eta xuara xua barapo Moisés pia peitorobi coyene diwesitha tina? ¿Eta xua yabara yorobame barapo diwesitha? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pon jiwi pecuidubin Moisés pia peitorobi coyene bapon Jesús jume notatsi, jeye: —Antobeinde jinya Necanamataxeinaein, bapon Nacom, daxita xua nejʉntʉ coyene wetsina, mataʉtano xua daxita jinya nepoponae coyenewatha, mataʉtano xua nanta xeiname, daxita xua nenanta xeinaewatha nentasipatha, mataʉtano daxita xua nedaunwei coyenewatham, mataʉtano antobeinde necatsicuarabʉ ecaein icha ichim xua naantobem jinya coutha, jei pon jiwi pecuidubin Moisés pia peitorobi coyene. ");
INSERT INTO cui_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nexata Jesús jume nota, jeye: —Bara beta nejume notame. Icha baraxua exanaename peajʉntʉyapusʉwa xeinaename po peajʉntʉyapusʉwa xua ataya tsiteca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ichitha pon jiwi pecuidubin Moisés pia peitorobi coyene tatsi, barapon awiya nanta xeina nawita, pia jiwi nanta xeinaetsi xua bapon xeina pexeinya peyainyabiwa. Bapon Jesús yainyabatsi, jeye: —¿Jintam barʉ pomonae tanetsicuarabʉ enaewi? jei. ");
INSERT INTO cui_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nexata Jesús jume nota, jeye: —Irʉrʉ pebin Jericó tomara bereca pona, Jerusalén tomara namtotha weya pona. Poxonae awiya namtotha ecapona jemeicha waetabatsi pomonae jiwi pecaibiwi. Barapon daxita wecobe notatsi xua pocotsiwa xeina, yawa bʉtsi. Barapomonae aichurubenae, tsica cuiyotha copatabatsi. ");
INSERT INTO cui_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bapoxonae irʉ sacerdotemonaepin barapo namto ecapona. Poxonae barapon yasusʉinya taebotatsi sacerdotemonaepin tajʉ matawacaicha toquetaba. ");
INSERT INTO cui_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Irʉ levimonaepin baxoyo ecapona, bapon irʉ tajʉ matawacaicha toquetaba poxonae yasusʉinya taebota. ");
INSERT INTO cui_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ichitha Samaria nacuapin baxoyo irʉ ecapona poxonae yasusʉinya taebota, yabara najʉntʉ coyene xeinanareca peyawenaenexa. ");
INSERT INTO cui_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nexata Samaria nacuapin imoxoyo caquita uncuataba pon yasusʉinya boca. Bapon wan yawʉbecapona penasiwatha vino merathano. Bapoxonae paparuwatha wan yarabecapona. Bapoxonae burrotha cuaretsica piyʉntha. Bomʉxʉ beya capona ichaxota jiwi maiteibathopa. Baxota xanepanaeya bota. ");
INSERT INTO cui_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bapoxonae baya poxonae juntucuru Samaria nacuapin ponaenaba, pita ainya paratixi. Bapoxonae cata pontha pon bo pexeinaein. Samaria nacuapin barai pontha pon bo pexeinaein: ‘Barapon beta xanepanaya bore. Icha paratixi seicanaya, equeicha bexa cacatsinchi poxonae caewa denan tsane’, jei Samaria nacuapin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Equeicha Jesús namchi, jeye: “Barapo acoibi poyobe jiwana, ¿jintam yabara cananta xeiname xua wʉnae exana xua peantobexaetsi pon waetabatsi pomonae jiwi pecaibiwi, yawa xua bʉtsino?” jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Pon jiwi pecuidubin Moisés pia peitorobi coyene tatsi, bapon Jesús jume notatsi, jeye: —Pon xua yabara najʉntʉ coyene xeinanareca xua peyawenaenexa, jei bapon. Jesús jume nota, jeye: —Ponare, icha pocotsi coyeneya Samaria nacuapin ichi barichiya exande, xanepanaya exande ichamonaetha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús pijimonae cataunxuae barʉ ecapona namtotha Jericó tomara beya barʉ pona. Pijimonae barʉ patopa tsica tomariyotha ichaxota petsiriwa popona powa pewʉn Marta. Barapowa Jesús matenta weyataeya wabatsi pia botha. ");
INSERT INTO cui_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta peyapiyo nantaʉta powa pewʉn María. Barapowa María Jesús caquita ecatsi xua Jesús pejume taenexatsi pocotsiwa paeba. ");
INSERT INTO cui_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ichitha Marta enatsi pia penacuichiwa xua Jesús tsiexanatsi pexaewa xuano xua pijimonae tatsi nexano. Barapowa pona Jesús beya, namchi, jeye: —Tanecanamataxeinaem, ¿jopa taem xua tayapiyo necopata xua compa nacuitan? Awiya bobena penacuichiwan. Itorobare bʉ neyawena, jei Marta. ");
INSERT INTO cui_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ichitha Jesús jume nota, jeye: —Marta, caenauya jinya nenacuichiwan xua pocotsiwa xua ichichipame neexanaewa. ");
INSERT INTO cui_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Saya cae coyene ainya cui xua xam nantawenoname pocotsiwa xua María exana xua barompaya itapeta xua wʉnae exana poxonae nejume tayeca. Jiton dapocotsin aibi xua pon María jʉntʉ coyene weaichurubenae exainchi xua nejume tayeca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Caentacabi Jesús tsipaebauya Nacom ichawatha. Jesús najume weta, bapoxonae pijimonae tatsi jiwana poyobe xua doce poyobe Jesús baraichi, jei: —Jesús, Patatanecanamataxeinaem, pana necuidubare xua Nacomtha pata tsipaebiwa, icha Juan ichi xua pijimonae cuiduba, jei bapon. ");
INSERT INTO cui_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús barai barapomonae, jeye: —Poxonae Nacom patsipaebame, pajande: ‘Pata Taxam xam ponxaem peitabocotha athabeicha neecaein. Barabʉ daxita jiwi cabarʉ cui itura jina nejʉntʉ coyene wʉnaewa nexeinaexae. Barabʉ jopaena matacabi po matacabi xua poxonae xam jiwi itorobiya canamataxeinaename barapo cae pin nacuathe. ");
INSERT INTO cui_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Daxita matacabin pexaewa pana catsibeibare po pexaewa daxita matacabi pata canantawenonaewa. ");
INSERT INTO cui_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pana neyabara cui cana jʉntemainare xua abe pata catsita exanaewatsi. Bapoxonae pana neyabara cui cana exanare xua jopa equeicha pata catsita natsicuentsiwatsi tsainchi xua abe pata catsita exanaewatsi. Baraxua painta exande icha paichin ichamonaetha. Tsipei paxan copiya payabara cui cana exanan xua ichamonae jopa pana netsita natsicuentsiyo xua abe pata tanetsita exanaewa. Jopa pana copatsinde xua abe pata exanaewa tsane poxonae jiwi pana nejʉntʉ coyene jʉjʉta xua abe pata exanaewa tsane’, pajande poxonae Nacomtha patsipaebame, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Equeicha Jesús barai, jeye: —Metha beya tsipae xua caein paxam jiwana bapon nantaʉta pon peyaputaeinchi. Bapon pia peyaputaeinchi beya pona papaetha. Pia peyaputaeinchi barai: ‘Tamo, cacowaetatsi acoibi po panbe, yaitama icha taneyaputaein patopa pon anoxuae warapa tabo berena. Jopa xeinaeinyo xua taapatsiwa bapon’, jei pebin. ");
INSERT INTO cui_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Metha pon bomʉxʉ tututha boca bapon jume notsipa, jei tsipae: ‘Jopa nejume fayacotsinde bomʉxʉ boupa daunwei, tapexui barʉ maituncuan camatha. Jopa benontaponaeinyo xua pan tacacatsiwa tsane’, jei tsipae pon bomʉxʉ tututha boca. ");
INSERT INTO cui_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Paca tsipaebatsi bequein bapon bomʉxʉtha jopa benontaponaeyo, bequein bara pia peyaputaeinchi, daichitha cata poxoru jume fayacotatsi pia peyaputaeinchi. Mataʉtano cata daxita xua pia peyaputaeinchi nantawenona. ");
INSERT INTO cui_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Daxota paca tsipaebatsi. Matowa pawʉcare Nacom, bapoxonae paca catsibina pocotsiwa xua pawʉcame. Baraxua matowa paexande icha paichim poxonae matowa pajeiteibame beya poxonae pataebame, yawa icha paichim poxonae matowa pawawam bomʉxʉtha beya poxonae ichʉn paca jume nota. ");
INSERT INTO cui_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tsipei pon matowa wʉca ichʉn bara catatsi. Tsipei pon matowa necoba, bara taeba. Tsipei pon bomʉxʉ pecoibototha matowa wawai bara tacoibo sarana xorenatsi yawa jume notatsino. ");
INSERT INTO cui_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","12","“Paxam pomonae pexui paxeiname paca yainyabatsi. Poxonae painya pexui paca wʉca duwei, ¿painya pexui pacatsipame jomo? Jume. Ichacuitha tsipae poxonae painya pexui paca wʉca petobʉ, ¿painya pexui pacatsipame pʉto? Jume, jopa baxua paraichim tsane. ");
INSERT INTO cui_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bara bequein peajʉntʉcoyenebe jiwi pam, ichitha paxam payaputaneme xua pewʉnaewan painya pexui pacatsibeibame. Ichitha nama Nacom painya axa jopa juniya paca catsiyo Nacom pia Pejumope tʉnaxʉ tatsi poxonae pawʉcame. Nacom paca cata beyacaincha poxonae painya pexui pacatsibeibame poxonae paca wʉqueiba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Irʉrʉ Jesús taitawetauya cauri xua pebin muxusipana exainchi. Poxonae cauri pebin wepu poinchi, bapoxonae pebin equeicha paeba. Jiwi yabara najʉntʉ coyene cabenaeca poxonae baxua tane. ");
INSERT INTO cui_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ichitha ichamonae namchi: “Bapon caurimonae itawetatsi apara pexeinaexae Beelzebú pia peayapusʉ itorobi coyenewa tatsi pon caurimonae pia pentacaponaein tatsi”, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ichamonae Jesús wʉcatsi: “Pana netsita itʉre peitʉpanaewa xua peitaboco wetsica jopeicaena”, jei. Barapomonae baxua paeba poxoru ichichipa xua Jesús tsita itʉtsina, pia yaputaetsi icha barapon pon yatsicaewa Nacom itoroba. ");
INSERT INTO cui_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ichitha Jesús yaputane xua barapomonae nanta xeina. Jesús barai: “Icha cae nacuapiwi nawepu tsatabe xua mataʉta nababe, bapoxonae jopa xaexaenaecaeyo. Mataʉta irʉrʉ icha cae bo matabʉxʉyomonaebe nababe yawa nawepu tsatajopabe, bapoxonae jopa xaexaenaecaeyo. ");
INSERT INTO cui_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Barichi icha Satanás pijimonae tatsi nawepu tsatajopabe mataʉtano xua nababe bapoxonae jopa xaexaenaecaeyo. Satanás jopa itacʉpaetsi xua itoroba pijimonae tsipei amsiya exana. Baxua paca tsipaebatsi tsipei naerabiya pana baram: ‘Apara bapon cauri itaweta Beelzebú pia peayapusʉ itorobi coyenewa tatsi pexeinaexae pon cauri pia pentacaponaein tatsi’, pana neyabara jam. ");
INSERT INTO cui_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Icha Beelzebú pia peayapusʉ itorobi coyeneya tatsi cauri itawetan pon cauri pia pentacaponaein tatsi, ¿nexata eta po peayapusʉ itorobi coyeneya tatsi painyamonae cauri itaweta? ¿Irʉrʉ barapomonae cauri itawetatsi Beelzebú pia peayapusʉ itorobi coyeneya tatsi? Daxota painyamonae paca yaputane xua apara paxam panaerabame. ");
INSERT INTO cui_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ichitha nama xan cauri itawetan Nacom pia Pejumope tʉnaxʉ tatsi pia peayapusʉ itorobi coyenewatha tatsi xua barapo pia pejumope tʉnaxʉ tatsi tanecatsixae. Baxua apara paca tsipaebatsi painya neyaputaenexa, xua painya xantha patopan ponxaein Nacom Tananeitapetsin. ");
INSERT INTO cui_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Pebin ba pon bo pexeinaein pon xua maxʉ daunwei, bapon nayanaba xua xuan peopi sojeiwan. Daxota pocotsiwan xua xeina pia botha bara xaniwaicha tabobeinchi. ");
INSERT INTO cui_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ichitha icha ichʉn patopa pon beyacaincha maxʉ daunwei, bapon ba nawita yawa caiba barapo peopi sojeiwan xua xuan bomʉxʉ pexeinaein nanta xeina xua barapocotsiwantha bara xaniwaicha nayaewata. Poxonae barapo peopi sojeiwan bapon caiba tatsana ichamonae bichocono pematataeuncuaexae. ");
INSERT INTO cui_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Pomonae jopa neyawenaeyo, barapomonae apara inta abe exana. Barapomonae exana xua ichamonae jopa tana nejume cowʉntsiwa tsane. Barapomonae jopa neyawenaeyo xua ichamonae nenacaetutsina tajiwimonaexae tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Equeicha Jesús namchi, jeye: “Poxonae pebin wepu poinchi cauri, bapoxonae cauri pona wexotha ichaxota ira tsewa pepoponaenexa tsane baxota. Ichitha poxonae jopa caxinaeyo xua ichaxota pepoponaenexa bapoxonae bapon nabarai: ‘Tha caibeya ponaetsi pebin beya ichaxota bayatha wepu ponan’, jei cauri. ");
INSERT INTO cui_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Poxonae caibeya pona cauri caxina, pebin caxinatsi xua xanepanaya popona. ");
INSERT INTO cui_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nexata equeicha cauri pona pebin weya. Pirapaeyo bapon barʉ patopa siete poyobe cauri pomonae bichocono abe, beyacaincha bapon pon copiya. Daxita barapo caurimonae pebin xeina. Anoxuae bapon nama yatsicaya bichocono abe cana exainchi beyacaincha poxonae copiya abe cana exainchi poxonae saya caein”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Poxonae Jesús cataunxuae cueicueijei tsuncuae barapo diwesi, baxota pin bicheitotha petsiriwa jume daunwei wawai Jesustha, jeye: —¡Maisa ena jʉntʉ coyene weiweina powayo xua bayatha caexana yawa xua mito caapatano! jei petsiriwa. ");
INSERT INTO cui_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ichitha Jesús barai petsiriwa, jeye: —¡Bequein barichi, jame yatsicaewa jʉntʉ coyene weiweina pomonae jume tane xua Nacom paeba xuano xua exana pocotsiwa Nacom itoroba! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jesús imoxoyo matawacaicha umenatsi pin bicheito. Jesús barai barapo pin bicheito, jeye: “Jiwi pomonae anoxuae jinompa barapomonae peajʉntʉcoyenebe jiwi. Barapomonae necui itoroba xua bepa pinae tsita exanaein tatsita itʉtsi coyenewa xua pexeinya coyenewa. Ichitha jopa exanaein tsane icha tatsita itʉtsi coyenewa xua pexeinya coyenewa, saya meisa exanaein icha bayatha jʉta coyene cana ichichi Jonás pon Nacom peitorobi jume pepaebin, pon caena bayatha tʉpa. ");
INSERT INTO cui_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Caena bayatha Nínive tomarapiwi Jonás yaputainchi pon Nacom peitorobi jume pepaebin xua po coyene bapon Jonás Nacom peitorobinchi, tsipei Nacom bichocono Jonás ainya cui exanatsi. Xan ponxaein Nacom Tananeitapetsin Nacom ainya cui neexana. Daxita jiwi pomonae anoxuae jinompa barapomonae neyaputane po coyene xua xan Nacom neitorobica peitaboco wetsica. ");
INSERT INTO cui_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Matacabi patopeicaena po matacabitha Nacom yabara paebina jiwi xua penatsicuentsiwa daxita peperaxa exanaenexa xua abe peexanaexae. Barapo mataqueitha tsane petsiriwa powa caena bayatha tʉpa, bapowa asiya uncuaena Nacom peitabaratha tatsi. Barapowa pia nacua, nacuapiwayo, po nacua pocotsiwa parowa bereca tajʉ bereca eca. Barapowa pia nacuapiwi tatsi itorobiya pia pepa peewatsiwayo. Barapowa yabara cueicueijei tsane pomonae xua anoxuae jinompa poxonae uncuaena Nacom peitabaratha tatsi. Jei tsane bapowa: ‘Maisa pomonae xua jinompa poxonae Mesías popona po irathe deque, barapomonae abe bichocono peexanaewi tsipei ajʉntʉcoyenefaetabiya jume tane pocotsiwa Mesías cuiduba bequein Mesías bichocono peyaputaein’, jei tsane barapowa. Barapowa baxua paebina poxoru bapowa bayatha tajʉ werena pona pesiwa ponaenexatsi Salomón, pon caena bayatha Israel nacuapiwi itorobiya pia pepa peewatsinchi. Bapowa yaputane xua Salomón bichocono peyaputaein xua Nacom peyabara yaputaewatsi. Daxota bapowa ichichipa xua pecuidubinexatsi xua Salomón pecuidubinexa Nacom yabara. Nama xote uncuanje ponxaein taexanaein pocotsiwa pepa peainya cui coyenewa xua tacuidubin daxita jiwitha xua Nacom yabara. Barapocotsi coyenewa toxeinchiya ainya cui coyenewa beyacaincha po cui coyene Salomón exana poxonae cuiduba xua barapowa cuidubatsi xua Nacom yabara. ");
INSERT INTO cui_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Barichi barapo matacabitha Nínive tomarapiwi pomonae caena bayatha jinompa barapomonae abeya paca yabara paebina poxonae umenaena Nacom peitabaratha. Barapomonae baxua exanaena tsipei barapo Nínive tomarapiwi icha jʉntʉ coyene xeina Nacomtha peauraxae xua abe exana caena bayatha poxonae Jonás muxuwetsiya tsipaeba barapomonaetha Nacom pia pexeinya jume diwesi tatsi. Ichitha paxam jopa bara paichim, jopa icha jʉntʉ coyene paxeinaem. Nama apara xote uncuanje ponxaein taexanaein pocotsiwa pepa peainya cui coyenewa xua tacaponaewa Nacom Pejume Diwesi daxita jiwitha. Barapocotsi coyenewa toxeinchiya ainya cui coyenewa beyacaincha Jonás po cui coyene exana poxonae Nacom Pejume Diwesi capona Nínive tomarapiwitha”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús namchi jiwitha jeye: “Jiton dapon aibi pon pecoicha cueicha exana xua quirei pebʉxʉ pana wetsina, yawa xua cueicha matacateta cajatha. Jume, jame, asiya cueicha exanatsi xua pecoicha taenexa pomonae jojoneibarena. ");
INSERT INTO cui_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pecoicha ba yonoyonei merawi painya nepaca cayawenaenexa xua beta painya netaewa tsane quireitha. Barichi painya itacuereton painya nepaca cayawenaenexa xua beta painya netaewa tsane. Icha painya itacuereton wʉnae bara beta pataneme. Ichitha icha painya itacuereton abe jopa beta pataetsipaem. Barichirʉ painya jʉntʉ coyenewan xua painya nenanta xeinaewan. Icha painya jʉntʉ coyenewan xanepanaetsipa bara beta Nacom payabara najʉntʉ coyene xeinaetsipame. Ichitha icha painya jʉntʉ coyenewan jopa xanepanaetsipae jopa beta Nacom payabara najʉntʉ coyene xeinaetsipaem. ");
INSERT INTO cui_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Painya jʉntʉ coyenewan paca cana exanaetsipa xua bichocono abe paexanaetsipame daxota dota pam. Painya xoba merawi paponame icha jopa paxeinaem xua peyonoyoneiwa poxoru cotacaya panapapeichipame. Barichi pam, painya xoba pajinompame icha jopa paxeinaem xua pocotsiwa beta painya neyabara nanta xeinaewa Nacom poxoru cotacaya abe paexanaetsipame. ");
INSERT INTO cui_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Icha painya jʉntʉ coyene wʉnae, xuano xua jopa paxeinaem peabe coyenewa painya jʉntʉ coyenewa, bara xaniwaicha Nacom payabara yaputaneme icha poxonae pecoicha paca cana ichi xua beta pataneme”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Poxonae Jesús najume weta, fariseomonae jiwanapin Jesús wabatsi xua petaxaenexa tsainchi pia botha. Jesús joniya yawa ecoundeca pexaethopaewatha. ");
INSERT INTO cui_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fariseomonae najʉntʉ coyene cabenaecaeya necotecataba xua Jesús jopa matha tsiwanaya penacobe quiatsiyoxae poxonae xane icha judiomonae ichi, xua saya pia cui coyene tatsi xua barapomonae nanta xeina icha jopa matha nacobe quiatsiyo Nacomtha natsicuentsipa. ");
INSERT INTO cui_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nexata Jesús pon Pecanamataxeinaeinxae jiwi, fariseomonaepin baraichi: —Paxam fariseomonaepiwi pam, paxam jopa ba juniya paexaneibim poxonae meisa panaperʉ iquicame. Daichitha bʉpana iya painya jʉntʉ coyenetha pecaibi coyene paxeiname, peuwi coyeneno paxeiname. Be barapocotsi jiwi pam, pocotsimonae coroton saya matawacaicha iquica yawa paratonno, ichitha atutuxuira bichocono. ");
INSERT INTO cui_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jopa peyaputae jiwi pam. Nacom exana wapepon yawa exana wajʉntʉ coyenewa. ¡Baxua payaputanemeba! ");
INSERT INTO cui_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Xua xoxi paxeineibame matha abʉ copiya pajiwana tsabeibare pomonae peacopeibiwi nexa. Bapoxonae xua xoxi nacopabeiba baxua panata copabeibare. Icha bara paichim tsane, bara xaniwaicha pajʉntʉ coyene xanepaname Nacomtha. Yawa jopa panantawenonaem xua pana nacobe iquiqueibame jiwi peitʉtha xua be panatsicotaneme pocotsi pebin pejʉntʉ coyene wʉnaein. ");
INSERT INTO cui_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Equeicha Jesús namchi, jeye: “¡Paxam fariseomonaepiwi pam tsobenae, xua peperaxa perʉ jʉbiwa bexa paxeinaename! Daxita xua painya neʉbiwa Nacom pacatsibeibame caewaxi poxonae diez xoyobe paxeineibame. Irʉ xua tsiwaxino pacatsibeibame. Bequein baxua paexaneibame ichitha Nacom jopa paantobem. Mataʉta ichamonae jopa xapain pata exanaem. Bewa paexanaem xua Nacom pacatsibeibame caewaxi poxonae diez xoyobe paxeiname. Yawano bewa paantobem Nacom. Yawano bewa xainyeya paexanaem jiwitha”, jei Jesús fariseomonaepintha. ");
INSERT INTO cui_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bapoxonae Jesús fariseomonae baraichi, jeye: “¡Paxam fariseomonaepiwi pam tsobenae! Bexa paxeinaename xua peperaxa perʉ jʉbiwa. Paxam paichichipeibame xua painya nenanta caeneibiwa pexeinya peenaewantha judiomonae pia penacaetutsi botha po peenaewan ichaxota enathopeiba pomonae ainya cui penaexanaewi. Mataʉtano paichichipeibame xua jiwi paca wʉnae jainteiba poxonae paca jacoba namtotha, xua jiwi painya nepaca barʉ itura jinaenexa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Equeicha Jesús namchi, jeye: “¡Moisés pia peitorobi coyene tatsi, jiwi pecuidubiwi pam tsobenae! ¡Irʉ fariseomonae pam tsobenae! Poxonae jiton ba pona namtotha jopa tsaqueinaeyo xua jiton piwa baxoyo bocareca mʉthʉ deca, xua peayeiwa poxoru jopa wʉnaeyo. Paxam bara paichim. Jiwi imoxoyo paca caquita pona jopa tsaqueinaeyo xua pocotsiwa painya jʉntʉ coyenetha pananta xeiname xua abe xua jopa pecui wʉnaewiyo”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Nexata pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, barapomonae jiwana caein bapon Jesús baraichi, jeye: —Jiwi Necuidubin, poxonae baxua paebame, apara irʉ pana neyabara jam poxonae catsawiya paebame, jei. ");
INSERT INTO cui_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nexata Jesús jume nota, jeye: —¡Irʉ paxam Moisés pia peitorobi coyene tatsi jiwi pecuidubiwi pam tsobenaem! Tsipei paxam ichamonae paitorobame xua capona pocotsiwa arewe pocotsiwa jiwi bapana jopa itacʉpaetsi xua pecaponaewa, ichitha paxam jopa pata yoichaem, mataʉta bara cae cobesitiyotha jopa pata yoichaem. Jiton ba itoroba ichʉntha xua pecaponaenexa pocotsiwa jopa juniya arewiyo, xua pocotsiwa jopa itacʉpaetsi xua pecaponaewa pon itoroba. Bara paichim paxam ichamonae pacuidubame xua jopa itacʉpaetsi xua peexanaenexa baxuan xua pocotsiwa irʉ xua jopa paca itacʉpaeyo xua painya neexanaewa baxuan. ");
INSERT INTO cui_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Paxam patsobenaem! Paxam petʉpaewi pomonae Nacom peitorobi jume pepaebiwi payamʉthʉ acabame boutixi bequein painya amo susato jiwi juteba barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Poxonae baxua paexaname, ichamonae patsita itapeinya xeiname xua paxam bara irʉ paichichipamerʉ pocotsiwa xua painya amo susato jiwi juteba xua barapomonae pomonae Nacom peitorobi jume pepaebiwi jutebatsi. Daxota barapo petʉpaewi payamʉthʉ acabame boutixi. ");
INSERT INTO cui_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Daxota Nacom peyaputae jumetha namchi: ‘Itorobicaein barapomonaetha taitorobi jume pepaebiwi irʉ pomonae taitorobiwi. Ichamonae pomonae taitorobi jume pepaebiwi jutebinchi. Ichamonae pomonae taitorobi jume pepaebiwi abe exanaeinchi. Ichamonae, pomonae taitorobiwi jutebinchi. Ichamonae, pomonae taitorobiwi abe exanaeinchi’, jei Nacom peyaputae jumetha”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Equeicha Jesús namchi, jeye: “Pomonae anoxuae jinompa Nacom cana exanaena xua barapomonae peraxa jʉbebinchi petsitaxaetsi xua barapomonae penatsicuentsiwa xeina, tsipei jiwi juteba xua Nacom peitorobi jume pepaebiwi jutebatsi caena bayatha xua weya xua poxonae Nacom aena forota barapo cae pin nacue. ");
INSERT INTO cui_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Painya amo susato jiwi jujutebapona xua pomonae pejʉntʉ coyene xeicae jiwi jutebatsi. Copiya matha Abel bexotsi beya poxonae irʉrʉ Zacarías bexotsirʉ. Barapon Zacarías pabexubame Nacom pin pia botha ichaxota xua barapo bo tututha naitama taeuncuabe xua be pexaethopaewa xua ichaxota duwei tauteiba Nacom nexa irʉ ichaxota po tutu yatsicaewa Nacom pia tutu. Daxota paca tsipaebatsi Nacom cana exanaena xua daxita paxam pomonae anoxuae pajinompame paca peraxa jʉbebina tsipei Nacom patsitame xua paxeiname penatsicuentsiwa xua painya amo susato jiwi pejutebixae barapomonae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Equeicha Jesús namchi, jeye: “¡Paxam jiwi pecuidubiwi pam tsobenaem xua Moisés pia peitorobi coyene tatsi! Paxam ayapube paexaname xua jiwi peyaputaewa Nacom Pejume Diwesi poxoru icha caununaya pacuidubame, xua jopa xapain pocotsiwa Nacom paebiyo. Paxam jopa pajume cowʉntsim Nacom mataʉta jopa pacopatsim xua ichamonae irʉ pejume cowʉntsiwa Nacom”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Poxonae Jesús baxua paeba poxonae cataunxuae jopa natsixatabiyo, fariseomonae irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene, daxita barapomonae Jesús bichocono casebatsi. Barapomonae Jesús muxu fayacotatsi xua yainyabatsi nawita, peamuxuconae exanaenexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Barapomonae Jesús piraichi matowa yainyabatsi peyaputaenexa icha Jesús ajumebeya jume bara botsina. ");
INSERT INTO cui_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Poxonae cataunxuae Jesús cueicueijei tsuncuae, bapoxonae ayei jiwi nacaetutapona Jesustha. Jiwi nataxu taxunaunaba. Jesús tamropata pitaba xua cueicueijei jiwitha. Copiya matha Jesús pijimonae tsipaeba, jeye: “Dota pam jopa pajume naitaewatsinde fariseomonae pia pecuidubi coyenewa tatsi xua painya nejume cowʉntsiyainwa. Barapomonae itara beta paeba ichitha jopa xapain exanaeyo. ");
INSERT INTO cui_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Daxita diwesin xua po diwesin bequein anoxuae jiwi jopa yaputaeyo, bexa yaputaena. Pocotsiwa jiwi abe nameicha exana daichitha ichamonae bexa yaputaeponaena baxua. ");
INSERT INTO cui_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Paxam xua po diwesi merawi nameicha pana natsipaebame, barapo diwesi ichamonae mataqueitha jume taena. Mataʉtano pocotsiwa paxam aisawatha pana namuxu paxapaxeya tsipaebame, barapo diwesi ichamonae panatha paca jume canawabiya wawai tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Equeicha Jesús pijimonae barai, jeye: “Tamonae paxam paca tsipaebatsi jopa pacuitaya cunuwinde pomonae xua itacʉpatsi xua paca necajutebiwa xua meisa painya pepontha. Ichitha barapomonae jopa itacʉpaetsi xua equeicha paca jumopein tʉnaxʉ jutebina. ");
INSERT INTO cui_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ichitha yabara paca tsipaebatsi pontha jame bewa pacuitaya cunuwim, bapon apara jame Nacom. Tsipei bapon itacʉpatsi xua painya nepaca bebaiwa pin isototha po pin isototha jopa bapana itacounayiyo xua weraweraca painya nepaca exanaenexa painya pepon. Xaniyan paca tsipaebatsi bewa jame pacunuwim bapon Nacom. ");
INSERT INTO cui_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Jiwi ba caenaeta siri cinco poyobe, saya ainya paratiyobe nantomata. Bequein barapo siri caenaeta jiwi xua jopa matoma nautsiyo, ichitha Nacom jopa yabara jʉntemainaeyo siri, mataʉtano caeyono jopa yabara jʉntemainaeyo. ");
INSERT INTO cui_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Irʉ daxita painya nentanan Nacom daxita matapaeicha paca matana ununa. Jopa pajunuwinde tsipei paxam Nacom bichocono patsita ainya cuim beyacaincha siri”, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Equeicha Jesús namchi pijimonaetha, jeye: “Yabara paca tsipaebatsi pomonae xua nayopita ichamonaetha, pomonae xua najei: ‘Apara paxan Jesús pijimonae tatsi pan’, najei. Barichi xan, ponxaein Nacom Tananeitapetsin xuya jan tsane matatsunpiwitha. Barapomonae apara tana nejume cowʉntsiwi, jan tsane xuya barapo Nacom pia matatsunpiwi tatsi peitabaratha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ichitha pomonae xua neyabara jei ichamonaetha: ‘Jopa dapon payaitaeinyo’, jei, xan ponxaein Nacom Tananeitapetsin xuya barapomonae yabara jan tsane Nacom pia matatsunpiwi peitabaratha tatsi: ‘Apara barapomonae jopa yaitaeinyo’, jan tsane. ");
INSERT INTO cui_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Xan ponxaein Nacom Tananeitapetsin pon abe neyabara paeba Nacom itacʉpatsi xua bapon peyabara jʉntemainaewatsi pocotsiwa bapon abe neyabara paeba. Ichitha pon nama Nacom pia Pejumope tʉnaxʉ tatsi bichocono abe yabara paebatsi Nacom jopa bapana yabara jʉntemainae bapon. ");
INSERT INTO cui_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Paca caponaena judiomonae pia penacaetutsi bontha ichaxota nacaetuteiba pentacaponaewi. Paca caponaena pomonaetha pomonae peyabara paebi jiwi xua penatsicuentsiwa xua abe peexanaexae yawa tomara pia pentacaponaewi peitabaratha tatsi paca caponaena. Poxonae baxua paca exanaena, jopa payabara najʉntʉ coyene exabinde pocotsiwa xua painya nejume notsiwa xuano xua painya netsipaebiwa tsane barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Poxonae juntucuru pacaunutsiya paebiname, bapoxonae Nacom pia Pejumope tʉnaxʉ tatsi paca tsijume dubina pocotsiwa painya netsipaebiwa tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Caein pin bicheitotha, bapon Jesús baraichi, jeye: —Jiwi Necuidubim, taeweicho inta itorobare bʉ necata xua tawa xua taxa pecopiniwa xua xuan taxa bayatha pana nejʉntana jeba, jei. ");
INSERT INTO cui_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús jume epa pita, jei: —Maisacai, apara dapon aibi pon necana exana xua xan tapaca yabara paebiwatsi xua painya nenatsicuentsiwa xua abe painya neexanaexae. Mataʉtano apara dapon aibi pon necana exana xua xan be pon tapacata tsabibeiwatsi pocotsiwa painya axa pia pecopiniwan tatsi, xua bayatha paca jʉntana jebeiba painya axa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yawa Jesús namchi, jeye: —Dota xua asiwiya paantobem xua xoxi paxeiname. Bequein pebin copei nawita xeinaetha, ichitha barapo pebin jopa yawenaetsi xua beta pepoponaewa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nexata Jesús tsipaeba jiwitha pecayabara jʉta pepaebi diwesiyo, xua jeye: “Irʉ matha pebin popona pon copei pexeinaein. Pia pabi tatsi pexaewa tanawetatsi nawita. ");
INSERT INTO cui_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pon copei pexeinaein nexata pia coutha nabarai: ‘¿Eta bichocuaein tsane? ¿Eta xota jebocuaein pocotsiwan pabitha notan?’ jei. ");
INSERT INTO cui_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pia coutha najume nota: ‘Bara yaputan tha xubichi pexaewa matabon. Tha equeicha acabichi po bon bichocono pin bon. Barapo pin bontha daxita pexaewa etsin yawa etsinno daxita pocotsiwa xeinan. ");
INSERT INTO cui_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nexata najʉntʉ coyene baran tsane: Bara daxita xeiname ainya wei dapaein nexa. Nafifinacaecare, xaibare, apeibareno, jʉntʉ coyene weiweineibare’, najei xua najʉntʉ coyene barai pon copei pexeinaein. ");
INSERT INTO cui_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ichitha pon copei pexeinaein Nacom barai bapon, jeye: ‘Pebin pon jopa xapain nenanta xeinaem, methaunxuae anoxuae merawi tʉpaename. Daxita baxuan xua yabo notame, ¿jintam metha piawa tsane?’ jei Nacom. ");
INSERT INTO cui_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Baxua barichi pon xua saya copei yabara nanta xeina nawita pecaetubinexa. Bapon Nacom copei xeina taetha, Nacom tsitatsi xua bapon apara acopeibi, tsipei bapon pejʉntʉ coyene tatsi tsocuae xua Nacom jopa pejume cowʉntsixaetsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bapoxonae Jesús pijimonae tsipaeba, jeye: “Paca tsipaebatsi, jopa bichocono payabara najʉntʉ coyene exabinde pexaewa xua painya neuna jinompaewa tsane. Barichi jopa bichocono payabara najʉntʉ coyene exabinde papabʉrʉ xua painya pepon nexa. ");
INSERT INTO cui_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pocotsi asʉ pejinompaewa xua Nacom naca cata jame baxua ainya cui, beyacaincha pexaewa xua peuna jinompaewa. Pepon ainya cui irʉ, beyacaincha papabʉrʉ xua pepon nexa. ");
INSERT INTO cui_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Uni payabara yaputaema. Bapomonae jopa ʉbiyo pabitha. Mataʉtano jopa jotsiyo pocotsiwa penawetsiwa. Jopa xeinaeyo bomʉxʉn xua pejebinexa pexaewa. Ichitha Nacom, uni apatatsi pexaewa. Paxam nama bichocono Nacom patsita ainya cuim jame, beyacaincha peyapupunaewi xua Nacom tsita ainya cuichi. ");
INSERT INTO cui_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Dapon aibi pon paxam jiwana pon itacʉpatsi xua xeinaena icha matacabi xua po matacabitha pepoponaewa tsane poxonae tʉpaena. Bequein bapon nayabara nantʉ exaba nawita baxua, ichitha jopa itacʉpaetsi xua xeinaena caentacabi equeicha. ");
INSERT INTO cui_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Icha jopa paca itacʉpaeyo xua paexaname xua be conotha xua caentacabi nexa, ¿eta xua metha equeicha yabara panantʉ exabame ichawan xua daunwei bichocono? ");
INSERT INTO cui_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Jame pacayabara nanta xeinare pentonon xua xuwa, xua matono itʉpana. Pentonon jopa nacuichiyo yawa jopa natsiexanaeyo papabʉrʉ penamaxatabinexa. Ichitha paca tsipaebatsi xua pentonon matono itʉpana bichocono beyacaincha pocotsi paparuwa Salomón nama xatata xua pexeinya paparuwa. Bapon Salomón pon caena bayatha judiomonae itorobiya pia pepa peewatsinchi pon bayatha tʉpa. ");
INSERT INTO cui_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pentonon, po matonon wexotha anoxuae xuwa, Nacom cana exana xua matono itʉpana. Ichitha pebiwi baya matono tautsina ichaxota pocotsiwatha pan seba, tsipei saya pentono. Nacom cana exana xua pentonon bichocono wʉnae bara bequein saya pentonon. Barichi Nacom itacʉpatsi xua beta paca neca-eenaewa xua beta painya nejinompaenexa. Mataʉtano Nacom paca catsina paparuwan. ¡Maisa pebiwi pam tsobenae be conotha pajume cowʉntame Nacom! ");
INSERT INTO cui_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jopa payabara najʉntʉ coyene exabinde pexaewa xuano xua painya neapaewan yabara. Jopa panthʉthʉ deideijeya jinompaeinde xua ichawa pacayabara nanta xeiname. ");
INSERT INTO cui_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tsipei barapo cae pin nacuathe jiwi, saya i baxua pecayabara najʉntʉ coyene exabi pocotsiwa nantawenona. Ichitha nama paxam painya Axa Nacom panantaʉtame pon yaputane daxita pocotsiwa xua xoxi panantawenoname. ");
INSERT INTO cui_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Meisa saya bichocono pacayabara nanta xeinare xua painya neexanaewa xua Nacom ichichipa waba jiwi xua jiwi wabatsi xua petanaexanaenexatsi pijimonae pomonae itorobiya pecanamataxeinaexae. Icha baxua paexanaename nexata Nacom paca catsibina xua daxita pocotsiwa panantawenoname”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Equeicha Jesús namchi, jeye: “Tamonae pomonae be ovejamonae pam, painya nejunuwi jiwi pamxaem. Jopa pajunuwinde bequein bara tsiquimonaeyo pam. Painya Axa Nacom pia coya peichichipaexae pia coya paca cana exanaena pijimonae tatsi jiwana pam pomonae pejume cowʉntsiwichi pomonae itorobiya pecanamataxeinaexae. ");
INSERT INTO cui_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pacaenaere xua paxeiname. Barapo paratixi pomonae acopeibiwi pacatsibare. Poxonae baxua paexaname, bapoxonae xuya Nacom athabeicha paca catsibina pocotsiwa xua painya nepaca jʉntana jebiwa pocotsiwa xua jopa naxubiyo. Athabeicha pecaibin jopa patopaeyo painya nepaca caibinexa pocotsiwa pajebame bara xoteicha. Mataʉtano ofo jopa xaeyo pocotsiwa xua pajebame bara xoteicha. ");
INSERT INTO cui_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ichaxota ba pajebame xua painya neichichipaewan baxota ba payabara nanta xeiname nawita”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Equeicha Jesús namchi, jeye: “Pana najʉntʉ coyene cui wʉnaere xua tapatopaewa tsane. Barapocotsi jʉta coyeneya paichinde, icha pomonae petanacuichiwi ichi xua nacui wʉnaeta, xua pon bo pexeinaein imoxoyo pepatopaexae. Bapon pon bo pexeinaein nasiwa pona ichaxota jiwi nacaetuta xua pexaenexa pexaewa poxonae pebin piowa pita. Bapon nawirena bara werena, pomonae pia petanacuichiwichixaetsi nainya tayausaranaxorenatsi pecoiboto poxonae bapon patopa pia botha. Barapocotsi jʉta coyeneya paichinde. Paxam panacui wʉnaetsiya jinompare xua tapatopeicaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Poxonae bo pexeinaein patopa icha bapon tane xua pomonae pia petanacuichiwichixaetsi jopa maichiyo bapoxonae barapomonae jʉntʉ coyene weiweina. Bara xaniwaicha paca tsipaebatsi bapon pon bo pexeinaeinxae pia petanacuichiwichi cuareba pexaethopaewatha, bapoxonae apatsina pexaewa. ");
INSERT INTO cui_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pon bo pexeinaein, bara bequein papaetha patopaetha tsipae, ichacuitha bara bequein metha patopaetha tsipae mataquei wʉnaeyo, ichitha barapomonae pomonae petanacuichiwi jʉntʉ coyene weiweinaetsipa poxonae bo pexeinaein tane xua jopa maichiyo barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Barichi payaputaema, icha bo pexeinaein yaputaetsipa xua poxonae patopaena pon jiwi pecaibin jopa maitecaetsipae. Mataʉta bapon jopa copatsipae xua pon pecaibin petajondenaewatsi pia botha. ");
INSERT INTO cui_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Bara paichinde. Tawanaetha pana nacui wʉnaere tsipei xan ponxaein Nacom Tananeitapetsin patopeicaein poxonae jopa tsaca payabara jinompaem tsane poxonae jopa payabara nanta xeinaem tsane xua tapatopaewa tsane”, jei Jesús ");
INSERT INTO cui_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nexata Pedro Jesús yainyabatsi: —Jesús, pata Tanecanamataxeinaem, po diwesi xuaunxuae pana tsipaebame, xua pecayabara jʉta pepaebi diwesiyo, ¿saya meisa paxan nexa? ¿Irʉ ichamonae nexano? jei Pedro. ");
INSERT INTO cui_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús pon Pecanamataxeinaeinxae jiwi, Pedro jume notatsi pecayabara jʉta pepaebi diwesiyotha pepatopaewa tsane yabara, jeye: “Yabara catsipaebatsi pon matacapopona pomonae bo pexeinaein tanacuitatsi. Barapon xanepanaya yaputaeya matacapopona. Poxonae bo pexeinaein wepu warapa barapomonae, pon bo pexeinaein itoroba pontha pon bo petayapucaecaeinchi, jeye: ‘Inta beta matacapoponde, yawa inta beta pexaewa apare daxita matacabi pomonae xua inta nacuita’, jei bo pexeinaein. ");
INSERT INTO cui_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pon bo petayapucaecaein bara jʉntʉ coyene weiweinaena poxonae patopaena pon bo pexeinaein, petaexaetsi xua bara beta tayapucaeca bo, xuano bara beta peexanaexae xua bo pexeinaein itoroba. ");
INSERT INTO cui_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xaniwaicha paca tsipaebatsi. Bo pexeinaein itorobina, xua pon petayapucaecaexaetsi bo, bapon cana exanaeinchi xua equeicha daxita piawa beta petayapu enaewatsi xua xuan xeina pon bo pexeinaein. ");
INSERT INTO cui_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Ichitha ichacuitha pon yapucaeca bo bapon peantʉcuiyapubein tsipae. Bapon pia coutha nanta xeinaetsipa, najei tsipae: ‘Metha bo pexeinaein jopa cuinaya patopae tsane’, najei tsipae. Bapoxonae bapon cueinta pomonae pon bo pexeinaein tanacuitatsi, pebiwi yawa petsiriwaxi. Mataʉtano bapon nanabanaetsipa nawita ichamonae yawa cʉpatsi nanaexanaetsipano. Bapoxonae bo pexeinaein jemeicha patopaena poxonae pon bo petayapucaecaein jopa wʉnae tsaqueinaeyo. Poxonae barapo hora tsuxubi jopa yaputaeyo yawa poxonae barapo matacabi tsuxubi jopa yaputaeyo. Pon bo pexeinaein itorobina ichamonaetha xua pebenexatsi yawa peperaxa exabinexa tsainchi pon bo petayapucaecaein icha cana ichichi pomonae jopa pejume cowʉntsiwi. ");
INSERT INTO cui_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Pon bo yapucaeca, bapon bequein yaputane pocotsiwa pon bo pexeinaein itoroba xua ichichipa, ichitha jopa exanaeyo pocotsiwa itorobatsi, xua bo pexeinaein itoroba. Barapon bichocono peraxa jʉbinchi xua jopa peexanaexae pocotsiwa itorobatsi. ");
INSERT INTO cui_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ichitha ichʉn pon bo yapucaeca jopa cono yaputaeyo pocotsiwa bo pexeinaein itoroba yawa itatemaya abe exana. Bequein jopa cono yaputaeyo yawa itatemaya abe exana, ichitha nantawenona xua peperaxa exanaewatsi be conotha, tsipei abe exana be conotha. Pon ba be conotha Nacom yabara yaputaeinchi, Nacom bapontha cana exanaena xua ichawa peyabara yaputaewa tsane beya poxonae bapon equeicha bichocono Nacom pejume cowʉntsiwa tsainchi. Pon ba jopa ichipaeyo xua Nacom peyabara yaputaewatsi Nacom wepichina po coyene bapon yaputane xua beya daxota Nacom jopa pejume cowʉntsiwa tsainchi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Equeicha Jesús namchi, jeye: “Patopan barapo cae pin nacuathe Nacom tana neitorobixae xua jiwi aperaxatane taexanaenexa abe peexanaexae barapo jiwi. Tapatopaewaxae jiwi atene tsane icha be ichi poxonae barapo jiwi tautatsi isototha. ¡Maisa metha bayatha bena baxua exanocuaein barapo isoto! ");
INSERT INTO cui_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Xan barichin tsane daxita matapaeicha aperaxatanein tsane poxonae tʉpaein. Awiya bichocono anthʉthʉrewein xua beya baxua inta exanaena. ");
INSERT INTO cui_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Pananta xeiname xua xan apara patopan xua jiwi jʉntema pejinompaewa tsane? Apara aibi, jopa baxua tsipatopaeinyo. Apara jame patopeican taexanaenexa po coyene jiwi naba exanatsi xua daxota ainya bicheiton penaexanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Anoxuae, yawa bexa tsane cinco poyobe cae matabʉxʉyo xua bomʉxʉtha jinompa barapomonae nawepu tsatajopaenabe. Tres poyobe ita aenae-aenei tsane xua dos poyobe ita aenae-aenei tsainchibe. Nantiya barapo matabʉxʉyobe naita aenae-aenei tsanebe. Baxua exanaena xua ichamonae tana nejume cowʉntsi jiwixae xua irʉ ichamonae jopa tana nejume cowʉntsixae. ");
INSERT INTO cui_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Coxiyan pexanto ita aenae-aenei tsane. Coxiyan xuya pexanto ita aenae-aenei tsainchi. Coxiwa pexantiyo ita aenae-aenei tsane. Coxiwa xuya pexantiyo ita aenae-aenei tsainchi. Irʉrʉ pamiyobe naita aenae-aenei tsanebe. Pecopeinyobe naita aenae-aenei tsanebe”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yawa Jesús barai jiwitha, jeye: “Poxonae tsaquinaebowa pataneme xua pocotsiwe wejopeine: ‘Ema dawa jopeina’, pajam. Jopa jume bara duneica. ");
INSERT INTO cui_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Poxonae joibo jopa: ‘Wei imoxoyo’, pajam. Jopa jume bara coicha jopa. ");
INSERT INTO cui_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Itara mexeya pexeinya jʉntʉ coyene paxeiname ichitha peajʉntʉcoyenebe jiwi pam. Itaboco yawa irano panaita caewatame painya yaputaetsi icha ema yawa xua icha pexeinya matacabi. Ichitha jopa payabara yaputaem xua bequein peitʉpanaewan exanan, ichitha cataunxuae came awiya jopa payabara yaputaem po coyene xua baxua Nacom taneitorobiwa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Equeicha Jesús namchi jiwitha, jeye: “¿Eta xua metha painya coutha beta jopa pana nayabara nanta xeinaem xua icha metha wʉnae painya neexanaewa? ");
INSERT INTO cui_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Icha ichʉn bepaca itoroba paca necaponaenexa pontha pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae nexata bapon patsipaebare poxonae cataunxuae namtotha paca barʉ ecapona xua painya nenaita coxone exanaenexa. Xain bapoxonae bapon jopa paca caponae tsane pontha pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae. Tsipei icha bapon bara beya paca caponaetsipa, bapoxonae pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae equeicha dabeya policiamonae beya paca itorobichipa. Bapoxonae nama policiamonae jiwi pecʉbi bo beya paca itorobichipa. ");
INSERT INTO cui_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Bara xaniyeya paca tsipaebatsi. Paxam jopa paca pu copabi tsane jiwi pecʉbi bo weya, beya abʉ poxonae panatsipu matomacaename daxita paratixi cuntha po paratixi xua paxeiname”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Barapoxonae ichamonae pata. Jesús tsipaebatsi, jeye: —Galilea nacuapiwi Jerusalén tomaratha capata duweimonae, Nacom pin pia botha xua barapo duweimonae pejutebinexa petautsinexa xua petuxusi exanaenexa Nacom nexa. Ichitha poxonae cataunxuae baxua exanompa Galilea nacuapiwi pon Galilea nacuapiwi peyanacua ewatsinchi, pon pewʉn Pilato poxonae bapon baxua jume taeba, xua Galilea nacuapiwi exanompa Nacom pin pia botha, bapoxonae bapon pia soldadomonae itoroba Nacom pin pia bo beya xua pejutebinexatsi Galilea nacuapiwi. Daxita duwei jana, yawa Galilea nacuamonae jiwi jana cae jana naexananaya, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús jume nota, jeye: “¿Eta xua metha pananta xeiname? ¿Barapo pebiwi jutebatsi bichocono yatsicaya abe peexanaewixae beyacaincha pomonae abe peexanaewi pomonae jinompa Galilea nacuatha? ");
INSERT INTO cui_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Apara aibi. Icha jopa Nacom patsita xeinaem icha jʉntʉ coyene, bara paichipaem, paca weraweraca exanaetsipa. ");
INSERT INTO cui_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ichacuitha metha pacui cananta xeiname pomonae dieciocho poyobe, pomonae bayatha bomʉxʉtha mata perababatsi xua po botha bichocono taicha po bo pewʉn Siloé. ¿Barapomonae mata tsapababatsi bichocono abe peexanaexae beyacaincha pomonae jinompa Jerusalén tomaratha? ");
INSERT INTO cui_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Apara aibi. Icha Nacom jopa patsita xeinaem icha jʉntʉ coyene, paxam bara paichipaem paca weraweraca exanaetsipa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nexata Jesús tsipaeba pecayabara jʉta pepaebi diwesiyo. Bapon namchi, jeye: “Matha irʉrʉ pebin higuera nae xeina po nae ʉbanota pia pabitha. Barapo pebin pia pabitha pona pia taetsi icha yacuei dubena. Ichitha poxonae tane jopa yacuei dubenaeyo. ");
INSERT INTO cui_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Nexata pon pabi pexeinaein tsipaeba pontha pon pabi petayapu eenaeinchi, namchi, jeye: ‘Taema acoibi po weibe pabitha poneiban tha bequein taibichi pethei ichitha jopa yacuei dubeneibiyo. Ʉncataxore. Jopa ichichipaeinyo xua came barapo nae saya uncua ichaxota ʉbanotinchi icha nae, po nae penacoichi nae’, jei pon pabi pexeinaein poxonae tsipaeba pon pabi petayapu eenaeinchi. ");
INSERT INTO cui_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ichitha pon pabi petayapu eenaein jume nota: ‘Tanentacaponaem, abʉ barapo nae uncuaena barapo weithe. Tha yaira tabaca nacuenacuena exanaetsi paraparatotha, bapoxonae duwei petasin jebarecaetsi petabaca deca. ");
INSERT INTO cui_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Metha bapoxonae matono dubenaetsipa icha weitha. Icha jopa matono dubenae tsane icha weitha nexata moya beʉncataxotsi’, jei pon pabi petayapu eenaein”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Caentacabitha judiomonae barompaya pia pentaquei seicae matacabitha tatsi Jesús cuidubauya Nacom Pejume Diwesi judiomonae pia penacaetutsi botha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Barapo botha yabʉyo eca, powa caena bayatha atene dieciocho po weiyobe. Barapowa naepasi xurutsiya pona. Barapowa xua juntucuru epasi boipana ajibi. ");
INSERT INTO cui_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Poxonae barapowa Jesús tane, Jesús waba barai, jeye: —Yabʉyo anoxuae jopa neraichiwa, bayatha wʉnaem, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nexata barapowa Jesús pecobetha jayaba. Bapoxonae yabʉyo epasi naroitaba yawa barapowa wʉnae jainta, Nacom wʉnae jaintatsi. ");
INSERT INTO cui_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ichitha pon pecanamataxeinaein judiomonae pia penacaetutsi bo tatsi, bapon Jesús casebatsi xua axaibi peexanaexae pentaquei seicae matacabitha. Bapon barai jiwitha, jeye: —Bara irʉ seis po matacabibe xua be cae semanatha tsoponeibi xua barapo matacabintha benacuitatsi. Jame barapo seis matacabintha moya papare xua axaibi painya nepaca exanaewa tsane. Nama jopa papatsinde pentaquei seicae matacabitha, jei bapon pon pecanamataxeinaein judiomonae pia penacaetutsi bo tatsi. ");
INSERT INTO cui_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bapoxonae Jesús jume nota, jeye: —Itara mexeya pexeinya jʉntʉ coyene painya nexeinaewi ichitha peajʉntʉcoyenebe jiwi pam. Ichitha paxam irʉ panacuitame pentaquei seicae matacabitha. Burro ba payama isanaxubame, bueyno ba payama isanaxubame painya apatsinexa mera pepa mene beya barapo pentaquei seicae matacabitha. ");
INSERT INTO cui_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Barapowa powayo Abraham pia pemomoxi susatopiwi jiwanawayo tatsi. Barapowa caena bayatha atene exanatsi. Satanás atene exana dieciocho po weyobetha. Daxota irʉrʉ barapowa xan axaibi exanan pentaquei seicae mataqueitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Poxonae Jesús baxua caunuta, bapoxonae pomonae Jesús pia peaitafaetabiwichi aura tsumenae. Ichitha daxita jiwi jʉntʉ coyene weiweina petaexae xua Jesús pexeinya pewʉnaewa exana. ");
INSERT INTO cui_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Equeicha Jesús namchi, jeye: “Poxonae Nacom waba jiwi petanaexanaenexatsi pijimonae tatsi, pomonae itorobiya peewatsixae, ¿eta po coyene nacoyene jʉpabe? ¿Eta xua paca cuidubinchi xua baxua yabara? ");
INSERT INTO cui_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Baraxua apara icha be mostaza xutiyo ichi po mostaza xuto pebin ʉba pia pabitha. Xuwa beya pin nae tsoponae. Pepinnaexae daxota siri exana coton pemaxʉranantha. Icha mostaza xutiyo ichi xua beya pin nae tsoponae, bara jʉta ichi Nacom pejume cowʉntsiwi. Bequein anoxuae tsica bicheitiyo, bexa tsane beya pin bicheito tsoponae tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Barichi Jesús namchi, jeye: “Poxonae Nacom waba jiwi petanaexanaenexatsi pijimonae tatsi pomonae itorobiya peewatsixae barapomonae pin bicheitomonae naenaexanapona. ¿Eta po coyene nacoyene jʉpabe? ");
INSERT INTO cui_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Barapo coyene bara jʉta ichi icha levadura matawʉn ichi, pocotsiwa cotowa exana poxonae pan exana. Petsiriwa tres po tsoropabe trigo xu beno muxuna cauyentaba levadura matawʉn pocotsiwa xua cotowa exana pan. Bapoxonae pentʉbʉ naexananaya, cocotowapona tsipei levadura matawʉn muxunaxuba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Poxonae Jesús Jerusalén namto beya pona, cuiduba tsiniya Nacom Pejume Diwesi po bon epatotha bobena yawa tomaranthano. ");
INSERT INTO cui_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pomonae Jesús cuiduba barapomonae caein jiwana Jesús yainyabatsi, jeichichi: —Patatanecanamataxeinaem, ¿saya tsiquimonaeyo pomonae capanenebiyatsi? jeichichi Jesús. Nexata Jesús namchi jiwitha, jeye: ");
INSERT INTO cui_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Bequein bichocono ayapube xua naexana Nacom pijimonae pomonae Nacom itorobiya ewata, ichitha bichocono pajʉjʉre xua panaexaname Nacom pijimonae tatsi. Baraxua be poxonae pin bicheitomonae ichichipa xua pejojondenaewa tsica boupayo dena. Bichocono ayapube. Bequein barapomonae ichichipaena xua pejojondenaewa tsane ichitha jopa itacʉpae tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Barapoxonae matacabi jopaena po matacabitha poxonae pon bo pexeinaein pecoiboto daunwei exanaena. Paxam pomonae aisowatha paumename pecoiboto padacadacatsiname, pajam tsane: ‘Patatanecanamataxeinaem, painta coibo saranaxorena bomʉxʉ’, pajam tsane. Ichitha bapon paca jume notsina. Jei tsane: ‘Bʉ canta jopa paca yaitaetsi xua jopa paca yaputaetsi xua ichaxota werena painya neponaewi’, jei tsane. ");
INSERT INTO cui_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Paxam pajam tsane: ‘Bara cain bayatha paca barʉ xainchiba yawa paca barʉ apatsiba, yawa bayatha jiwi cuidubameba namtotha pata tomaratha’, pajam tsane. ");
INSERT INTO cui_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ichitha Nacom pon painya Nepacacanamataxeinaein paca jume notsina: ‘Aunxuae bayatha paca baraichiba: Bʉ canta jopa paca yaitaetsi. Jopa paca yaputaetsi xua ichaxota werena painya neponaewi’, jan. ‘Taxainya weya panatsixibarʉcʉpare. Apara paxam peajʉntʉcoyenebe jiwi pam, xua abe painya neexanaewi’, paca jei tsane. ");
INSERT INTO cui_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Barapoxonae pataename xua Abraham, irʉ Isaac, irʉ Jacob, irʉ daxita Nacom peitorobi jume pepaebiwi xua ena Nacom pia peitorobi nacuatheicha. Ichitha paxam baxoteicha jopa pana naenaem tsane poxoru paca bebai tsane Nacom pia peitorobi nacua weya. Daxota pawecoyam tsane anaya nantanuweya pana nawano tsaquibasinaename poxoru paca bebai tsane Nacom pia peitorobi nacua weya. ");
INSERT INTO cui_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Poxoru pinmonae patsina, Nacom pia peitorobi nacuatha penabanaenexa tsane. Ichamonae pomonae ichaxota xometo ecoina, barapomonaepiwi patsinano. Ichamonae pomonae ichaxota xometo jopeica, barapomonaepiwi patsinano. Ichamonae pomonae ena pocotsiwa bereca, barapomonaepiwi patsinano. Ichamonae pomonae pocotsiwa beweyabeicha ena, barapomonaepiwi patsinano. ");
INSERT INTO cui_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Pomonae xua anoxuae pepawi naexana pomonae jiwi jopa petsita ainya cui jiwichi po cae pin nacuathe barapomonae Nacom pia peitorobi nacuatheicha peainya cui jiwi tsane. Pomonae xua anoxuae, pomonae jiwi petsita ainya cui jiwichi po cae pin nacuathe, barapomonae bexa Nacom pia peitorobi nacuatheicha jopa peainya cui jiwi tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Barapoxonae fariseo jiwanamonae pata. Jesús tsipaebatsi. Jeichichi: —Bewa warapaetsipame barapo tomara weya. Dota bepa Herodes cabexubei, jei. ");
INSERT INTO cui_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ichitha Jesús jume nota, jeye: —Paponare painya netsipaebinexa pon jiwi pemuxujainyabin, bapon Herodes. Pana nejume yopire pajande: ‘Taema anoxuae yawa baya tsane itawetsin caurimonae jiwi weya yawa axaibi exanaein peatenewi. Popobaya tsane wetsin’, jei pajande. ");
INSERT INTO cui_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ichitha anoxuae yawa baya tsane nantawenonan xua bara beya Jerusalén tomara beya ponaein namtotha. Barapoxonae popobaya patopiyaein Jerusalén tomaratha. Jopa tana neitacʉpaexae xua tatʉpaewa tajʉ Jerusalén tomara pepuya beya ponxaein Nacom peitorobi jume tapaebin. Bewa tʉpaein Jerusalén tomaratha, jei Jesús fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Bapoxonae Jesús yabara ʉnthʉthʉ wecoyei Jerusalén tomarapiwi. Jesús wecoyeya namchi, jeye: “¡Maisa Jerusalén tomarapiwi pam, pajutebeibame pomonae Nacom pia peitorobi jume pepaebiwi! ¡Mataʉtano paxam pajutebeibame ibotontha pomonae Nacom pacata itoroba! ¡Maisa bepaca caetucaetuteibinchi, tapaca cayawenaewa tsainchi, icha wacara ichi poxonae nacoxi caetucaetuteta pecuarafetha! ¡Maisa bebarichocuaein tsane daichitha jopa paichichipaem! ");
INSERT INTO cui_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Incane pataema Nacom nacui baraxuba xua jopa painya nepaca caewatsiwa tsane. Daxota Nacom jopa poponaeyo pia pin pia botha tatsi painya tomaratha. Paca tsipaebatsi xua equeicha jopa pana netaem tsane, beya abʉ poxonae pana neyabara jam tsane: ‘¡Maisa bapon jiwi jʉntʉ coyene weiweina cana exanatsi, pon patopa Nacom peitorobixae, po Nacom jiwi Pecanamataxeinaeinchi!’ pana neyabara jam tsane”, jei Jesús fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Caentacabi pentaquei seicae matacabitha Jesús pona fariseomonae pia pentacaponaewi tatsi jiwanapin pia botha tatsi penanabanaenexa. Baxota fariseomonae ichamonae Jesús amanayabiya tainchi pecui yaputaenexa tsainchi xua exana. ");
INSERT INTO cui_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Irʉ baxota pebin patopa ichaxota Jesús naeca. Barapo pebin pon perʉ putsuna. ");
INSERT INTO cui_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nexata Jesús yainyaba pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene, yainyabano fariseomonae, jeye: —¿Bara Moisés pia peitorobi coyene jumewatha yabara copata jampa xua pon atene bara axaibi peexanaewatsi pentaquei seicae matacabitha jampa? ¿Ichacuitha metha jopa yabara copatsiyo jampa? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ichitha barapomonae moya umena. Bara Jesús jayaba pecobetha pontha pon atene, yawa axaibi exana, tsipaebano xua bara peponaenexa. ");
INSERT INTO cui_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesús tsipaeba, barapo fariseomonaetha, jeye: —Paxam panantawenoname xua panacuitame pentaquei seicae mataqueitha xua poxonae pajutsiname painya nexanto xua poxonae butecatsi irʉba bueyno bara bequein pentaquei seicae matacabi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Barapomonae jopa itacʉpaetsi xua Jesús pejume notsiwatsi. ");
INSERT INTO cui_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nexata Jesús tsipaeba barapomonae pecayabara jʉta pepaebi diwesiyo pomonaetha pomonae xua pata penabanaenexa. Baxua tsipaeba poxonae tane xua barapomonae nanta caeniya, copiya penabanaenexa. Jesús namchi barapomonaetha, jeye: ");
INSERT INTO cui_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Poxonae ichʉn cawaba jinya nenabanaenexa tsane, jopa nantacaecaeinde ichaxota enothopeiba pomonae peainya cui jiwi. Poxoru metha irʉrʉ patopaetsipa pon bichocono jiwi tsita ainya cuichi pon beyacaincha xam. ");
INSERT INTO cui_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Pon xua cawaba, irʉ xua wabatsi pon jiwi tsita ainya cui naexanatsi, bapon cabarai tsipae: ‘Incane nontaponde icha muxunenetha ecare. Cotacaya xaema. Ichaxota ecame, baxota ecaena pon jiwi tsita ainya cui naexanatsi’, jei tsipae pon xua paca mata canabane. Nexata icha muxunenetha uranaya ecoundecaetsipame. ");
INSERT INTO cui_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Daxota poxonae cawaba nenabanaenexa, cotacaya ecareinca necajeinexa poxonae patopa pon paca mata canabane: ‘Tajiton, icha muxunenetha ecare ichaxota xaiba pomonae jiwi tsita ainya cui naexanatsi’, jei. Bapoxonae pomonae pata xua penabanaenexa barapomonae cayaitaena xua xam pon jiwi tsita ainya cui naexaname. ");
INSERT INTO cui_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pon pia coutha peainya cui jiton naexana pejʉntʉ coyenetha, Nacom exanaena xua bapon pecui pawi jiton naexanaena. Ichitha pon xua pepawi naexana pejʉntʉ coyenetha Nacom exanaena xua bapon peainya cui jiton naexanaena, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yawano Jesús barai pontha pon pexaewa petsiwabixaetsi, jeye: —Poxonae pexaewa tsiexaname yawano ichacuitha xua poxonae pin penabanaewa tsiexaname, jopa wabinde jinya jiwimonae penabanaenexa. Irʉ jopa wabinde eweichomonae irʉ jinyamonae irʉ pomonae copei pexeinaewi. Poxoru barapomonae pentoma exanaetsipa xua xuya catsi wabichipa penabanaewa. ");
INSERT INTO cui_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jame maisa poxonae jiwi pexaewa tsiexaname yawano ichacuitha pin penabanaewa tsiexaname, wabare pomonae peacopeibi jiwi. Yawa wabare pomonae jopa peainya cui jiwi, irʉ pejayujayujei jiwino, irʉ pomonae peitata nacʉtsi jiwino. ");
INSERT INTO cui_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bapoxonae jʉntʉ coyene weiweinaename. Barapomonae jopa itacʉpaetsi xua xuya necatsi wabiwa penabanaewa xua pentoma nexa. Ichitha Nacom cata exanaena pentoma poxonae jiwi asʉ exanaeinchi pomonae pejʉntʉ coyene wʉnae jiwi, xuano xua exana pocotsiwa Nacom itoroba, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Poxonae baxua jume tane, pomonae xua xayena, barapomonae caein jiwana Jesús baraichichi, jeichichi: —¡Pon xua nanabane Nacom pia peitorobi nacuatheicha tatsi, bapon bichocono jʉntʉ coyene weiweina! jeichichi Jesús bapon. ");
INSERT INTO cui_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nexata Jesús jume nota, jeye: —Pebin pin penabanaewa tsiexana jiwi. Barapo pebin itoroba ichʉn, xua pewabinexa ayei bicheito. ");
INSERT INTO cui_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Poxonae barapo hora tsuxubi poxonae pexaewa nacui wʉnaeta, bapon itoroba pia petanacuichinchi xua pewabinexatsi pomonae bayatha wabatsi. Barapon namchi: ‘Pajande jiwi: Antha pajojondena jei. Pexaewa weta jei, pajande’, jei pon mata canabane. ");
INSERT INTO cui_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ichitha daxita barapomonae paeba xua pinae enatsi xua peexanaewa. Ichʉn namchi: ‘Bayatha pabi comotan, tha canta matha taetsi. Nexata nejume yopire pinae jopa casebinde yaitama pinae jopa patopae tsane, jande’, jei. ");
INSERT INTO cui_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ichʉn namchi: ‘Canta diez poyobe comotan buey. Tha canta matha taetsi. Nexata nejume yopire pinae jopa casebinde yaitama pinae jopa patopae tsane, jande’, jei. ");
INSERT INTO cui_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ichʉn namchi: ‘Canta anoxuaetha taseuri pitan. Nexata nejume yopire pinae jopa itacʉpaetsi xua pepatopaewa tsane, jande’, jei. ");
INSERT INTO cui_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Poxonae caibe nawiya pon penajume caitorobinchi bapon daxita baxua tsipaeba pia pecanamataxeinaeinchitha. Nexata pon pecanamataxeinaein caseba pomonaetha pomonae bequein pewabixae, xua jopa pepatsixae. Bapon barai pia petanacuichinchi, jeye: ‘Nainya ponde tomara namtontha, yawa tsiqui namtoxitha tomara cuariya. Berene peacopeibiwi caponde, penabenaewi caponde, pejayujayujeimonae caponde, pomonae peitata nacʉtsi jiwi berene caponde’, jei pon pecanamataxeinaein. ");
INSERT INTO cui_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pon petanacuichin pia pecanamataxeinaeinxaetsi, bapon pia pecanamataxeinaeinxaetsi barai: ‘Tanecanamataxeinaem, xua neitorobame bayatha exanan, ichitha bomʉxʉ jopa tutu canaʉpaxubiyo, jiwi yayatha’, jei. ");
INSERT INTO cui_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nexata bapon jume notatsi pia pecanamataxeinaeinchi: ‘Equeicha nainya ponde tomara cuariya beya po namton pin namtontha, yawa tsiqui namtoxithano tomara cuariya. Baxota jume daunweya itorobare pomonae xua taneme xua pepatsinexa tabotha petutu canaʉpaxubinexa tsane. ");
INSERT INTO cui_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Catsipaebatsi, pomonae bequein waban ichitha jopa patsiyo, barapomonae jopa nabanae tsane tabotha’, jei pon pecanamataxeinaein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pin bicheitomonae Jesús puna poinchi. Jesús napatomeicha necota, namchi barapomonaetha, jeye: ");
INSERT INTO cui_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Icha pebin ichichipa xua tajiwimonae jiwanapin penaexanaewa tsane, bapon bewa yabara naitematsi pia peexanaewa. Bapon jame bewa neantobe tsane beyacaincha xua paxatha, beyacaincha xua penatha, beyacaincha xua piowatha, beyacaincha xua pia pexuitha, beyacaincha xua peweichowitha, beyacaincha xua pamchoxitha, yawano xua beyacaincha naantobe pia coutha, nexata bapon bara tajiwimonaepin. Ichitha icha jopa baxua exanaeyo xua bichocono nama tana neantobewa, bapon jopa tajiwimonaeyo. ");
INSERT INTO cui_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mataʉtano pon jopa awiya exana ducuanaebiyaeyo pocotsiwa itoroban, tsipei jopa beperaxa exanaetsi icha be xua poxonae neichi nexata bapon jopa tajiwimonaepinyo. ");
INSERT INTO cui_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Poxonae pebin imoxoyo bo exana, po bo, pin bo, copiya matha nanta xeina xua bo yabara, copiya coichaxu ununa, icha jʉpa xua pecʉbaponaenexa pomonae nacuita bo. ");
INSERT INTO cui_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ichacuitharʉ saya naewa wetanota, poxoru coichaxu axu weraweraca. Daxota jopa yaputaeyo xua pewetsiwa. Ichamonae pata, barapomonae bo taenota. Poxonae tane barapomonae cui capona, bapon cui caponatsi. ");
INSERT INTO cui_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Barapomonae namchi tsane, jei tsane: ‘Barapon tamropata pitaba bo xua acaba, ichitha jopa itacʉpaetsi xua pewetsiwa’, jei tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Equeicha Jesús namchi: “Irʉrʉ pon jiwi itorobiya pia pepa peewatsinchi ichichipa xua jiwi naba exana ichʉn beya pontha pon irʉ jiwi itorobiya pepa peewatsin. Poxonae bapon baxua exana, copiya nanta xeina, najei tsane: ‘Jamaisa, saya beisa diez mil po soldadomonae bicheitobe neyaewatacua, bapon netsi veinte mil po soldadomonae bicheitobe yaewatatsi. Metha tamonae jopa inta itacʉpaetsi xua peamanayabiwa barapo veinte mil bicheitotha xua taxainya berena ponaena’, najei tsane. ");
INSERT INTO cui_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Icha barapon jopa itacʉpaetsi xua peamanayabiwa, bapon najume caitorobina ichʉntha, poxonae cataunxuae tajʉ eca, ichʉn pon icha nacuapiwi itorobiya pia pepa peewatsinchi xua petapaebinexa tsainchi xua jopa penabiwa tsane yabara, xua equeicha jʉntema pejinompaenexa. ");
INSERT INTO cui_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Icha bapon ichi pon jiwi itorobiya pia pepa peewatsinchi xua baraxuba xua nanta xeina, xua penabiwa tsane, barichi icha paxam jopa pabarapentsim daxita pocotsiwa paxeiname, jopa paca itacʉpaeyo xua tajiwimonae painya nenaexanaewam”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Equeicha Jesús jeye: “Sare beno, bara beno wʉnae. Ichitha icha barapo sare beno jopa abenataeyo, bapoxonae jopa peitacʉpaewatsi xua equeicha peabenataewa. ");
INSERT INTO cui_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Barapo sare jopa ira nexiyo tsipei naein jopa beta xuwa exanaetsi. Daxota barapo sare jiwi bewa xubi. Icha pamuxu dubename moya pana nejume naitaeware pocotsiwa tapaca tsipaebiwatsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pomonae paratixi pentoma noteibiwi, po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa, irʉ pomonae abe peexanae cuiru coyene peexaneibiwi daxita barapomonae Jesús imoxoyo caquita umenarʉcʉpatsi xua Jesús pejume taenexatsi. ");
INSERT INTO cui_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Daxota fariseomonae irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi daxita barapomonae Jesús abe yabara paebatsi. Barapomonae namchi, jeye: —Barapo pebin napona pomonaetha pomonae abe peexanae cuiru coyene peexanaewi, yawa barapomonaetha nanabane, jei. ");
INSERT INTO cui_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Tsipei Jesús yabara paebatsi barapomonae, daxota nexata Jesús tsipaeba pecayabara jʉta pepaebi diwesiyo jeye: ");
INSERT INTO cui_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Jiton ba xeina oveja cien poyobe, caein tanapuxanatsi. Jiton wexotha cuenta pona noventa y nueve poyobe oveja pewenaweneinexa oveja pon beya matapainya taeba. ");
INSERT INTO cui_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Poxonae jiton oveja taeba pon aichurucuae, jʉntʉ coyene weiweinaya bota peutucuratha. ");
INSERT INTO cui_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Poxonae jiton oveja capatopa botha bapoxonae piamonae waba pomonae petaenaewichi pia botha, pia jiwi wabano, wabano pomonae petsicuarabʉ enaewichi. Jiton daxita barapomonaetha barai, jeye: ‘Panebarʉ jʉntʉ coyene weiweinare tsipei oveja bayatha taeban pon bayatha inta aichurucuae’, jei bapon piamonaetha. ");
INSERT INTO cui_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Xaniyan paca tsipaebatsi. Icha jiton ichi poxonae jʉntʉ coyene weiweina petaebixae oveja, barichi pomonae peitaboco beicha ena. Bapomonae bichocono jʉntʉ coyene weiweina poxonae ichʉn Nacom tsita xeinatsi icha jʉntʉ coyene pon copiya penacui matacaetsin xua abe peexanae cuiru coyene exana. Barapomonae bapon yabara toxeinchiya jʉntʉ coyene weiweinatsi beyacaincha poxonae yabara jʉntʉ coyene weiweinatsi pomonae xua noventa y nueve poyobe jiwi pomonae xanepanaya peexanaewi, pomonae jopa Nacom pentichi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Equeicha Jesús paeba pecayabara jʉta pepaebi diwesiyo, jeye: “Petsiriwa diez po paratiyobe xeina xua pecacomocae paratixi. Cae paratiyo taaichurucuaetsi, daxota pecoicha coicha exana. Bo tutu camona bewayo, beya matapainya taeba. ");
INSERT INTO cui_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Poxonae barapowa paratiyo taeba bapoxonae pia jitowaxi waba, wabano powaxi petsicuarabʉ enaewaxichi. Barapowa namchi barapowaxitha: ‘Pana nebarʉ jʉntʉ coyene weiweinare poxoru bayatha taeban paratiyo, po paratiyo bayatha inta aichurucuae’, jei. ");
INSERT INTO cui_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Paca tsipaebatsi barichi peitabocotheicha Nacom pia matatsunpiwimonae tatsi bichocono jʉntʉ coyene weiweina poxonae ichʉn Nacom tsita xeinatsi icha jʉntʉ coyene pon copiya penacui matacaetsin xua abe peexanae cuiru coyene peexanaein”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Barichi equeicha Jesús paeba icha pecayabara jʉta pepaebi diwesiyo, jeye: “Jiton xeina pexantobe. ");
INSERT INTO cui_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pon xuyapin paxa barai: ‘Axa, necare xua necopiniwa tsane pocotsiwa xua pana nejʉntana jebame bequein cataunxuae poponame’, jei xuyapin. Nexata barapo jumetha coxiyan pexantobe tsata catabe. ");
INSERT INTO cui_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pirapaeyo xuyapin piawa caenaeta xua paxa catatsi. Barapo paratixi cuntha tajʉ beya pona icha nacua beya. Icha nacuatha abe exana. Barapo paratixi cobe caewitatsi xua nasi cui matacaeta yabʉxitha. ");
INSERT INTO cui_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Poxonae bapon daxita paratixi wetaxuba, irʉrʉ mayayo tsuxubirʉ barapo nacuatha, barapon muxu piyain petʉpae. ");
INSERT INTO cui_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nexata bapon jeita penacuichiwa ichʉntha xua barapo nacuatha. Bara barapon itorobatsi xua petayapu eenaenexa marranomonae. ");
INSERT INTO cui_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bapon piyain ichichipa xane marranomonae pexunenowa xua petsebocoton, tsipei bapon jopa catichi pexaewa. ");
INSERT INTO cui_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nexata bapon pia coutha nanta xeinanaya najei: ‘¡Maisa taxa pia petanacuichiwichi tatsi pexaewa ajainbe, tonsana nawita! Nama xota ecanje tain muxu tatʉpae. ");
INSERT INTO cui_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tha tacoyo beya nawiyaetsi ichaxota taxa popona. Metha jan tsane: Axa, Nacom tsita abe exanan, yawa catsita abe exanatsino. ");
INSERT INTO cui_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Daxota equeicha jopa be taxanto, nejam. Nenatsicotaema be jinya necata nacuichiwi jiwanan, jan tsane’, najei barapo xuyapin. ");
INSERT INTO cui_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nexata bapon paxa beya caibe nawiya. “Poxonae cataunxuae tajʉ jiniya, paxa taebiyatsi, coxiyan pexanto yabara nantanuweya cui nanta xeina. Coxiyan pexanto matenta cuinaepoinya. Nexata pexanto cobe jayaba. Jʉntʉ coyene weiweinaya pexanto naisa cateita waetaba peantobexae. ");
INSERT INTO cui_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nexata barapo xuyapinxae paxa barai: ‘Axa, Nacom abe tsita exanan, yawa abe catsita exanatsino. Daxota equeicha jopa be taxanto nejam. Nenatsicotaema be jinya necata nacuichiwi jiwanan’, jei barapo xuyapin. ");
INSERT INTO cui_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ichitha coxiyan barapo jumetha barai pia petanacuichiwichi: ‘Nainya papire pexeinya paparuwa pamaxatare taxanto. Yawa anillo pacobesi xatare. Yawa pataxu xatare xua penataxu xatatsiwa. ");
INSERT INTO cui_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Vacayo pebtiyo poyo nasiteca pacarenande. Pabexore. ¡Bʉ xainchi! ");
INSERT INTO cui_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Poxoru barapo taxanto mexeya nacata tʉpawejan, ichitha anoxuae asʉ. Bayatha nacata aichawiya, anoxuae matapainya netsita patopa’, jei coxiyan. Nexata bapoxonae tamropata notarʉcʉpa xua weiweina poxonae xane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Equeicha Jesús namchi, jeye: “Irʉrʉ pin penabanaewa exanompa, irʉrʉ matapin pabitha popona. Poxonae bo benawirena busi taeba xua busi tanbaba yawa jume tane xua juinya nawiraba. ");
INSERT INTO cui_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nexata barapon pon matapinxae waba caein pomonae penacuichiwi. Yainyaba, jeye: ‘¿Eta xua juinya busi exanompa?’ jei. ");
INSERT INTO cui_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nexata barapon pon penacuichiwi jiwana jume nota. Jeye: ‘Apara poxoru neyapin patopa. Axa pana itoroba bepa pinae pabexubin vaca pebtiyo poyo nasiteca, poxoru pinae neyapin xanepanaya asʉya pepatopaexae’, jei. ");
INSERT INTO cui_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ichitha barapon pon matapinxae barapo jumetha anaepana. Jopa bejoniyaeyo botha. Coxiyan pesato bejoniya, pexanto jume daunweya waba: ‘Owae, antha, antha jonarena’, jei coxiyan. ");
INSERT INTO cui_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nexata barapo coxiyan pexanto jume notatsi: ‘Bara xam caena bayatha yaputaneme xua ainya wei cata nacuitatsi yawa jopa cajumefebichi. Ichitha bapana jopa necatsim peweinyo cabritiyo, tajiwimonae tabarʉ nabanaenexa. ");
INSERT INTO cui_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ichitha barapo nexanto anoxuae cata patopa, xua jinya paratixi caewitaxuba xua penasi cui matacaetsiwa yabʉxitha. Xam penacuichiwi itorobame xua vacayo pebtiyo bexubina poyo nasiteca tayapin nexa’, jei barapon pon matapinxae. ");
INSERT INTO cui_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Nexata coxiyan jume nota pexanto: ‘Owae, apara xam cabarʉ poponeibatsi. Daxita pocotsiwan xeinan, apara bara jinyawa. ");
INSERT INTO cui_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ichitha anoxuae wʉnae nawita xua pin penabanaewa, yawa jʉntʉ coyene weiweinaeinchi poxoru barapo neyapin, pon xua mexeya nacata tʉpawejan, anoxuae asʉ popona. Caena bayatha nacata aichurucuae, yawa anoxuae matapainya naca tsita patopa’, jei coxiyan poxonae pexanto tsipaeba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Equeicha Jesús tsipaeba pijimonae pecayabara jʉta pepaebi diwesiyo. Jesús jeye: “Matha irʉ pebin popona pon copei pexeinaein. Bapon xeina pon bo petayapucaecaeinchi. Bapon pon copei pexeinaein tsipaebatsi ichamonae xua pinae pon bo petayapucaecaeinxaetsi jopa pinae xapain exanaeyo, saya pinae abe exana, jei ichamonae. ");
INSERT INTO cui_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nexata bo pexeinaein pon copei pexeinaeinxae, bapon waba pia petayapucaecaeinchi bo. Bapon barai pontha pon bo petayapucaecaeinchi, jeye: ‘¿Jame ichamonae jume tan xua pinae inta abe exaname xua tawan? Incane tha taetsi xua po paperantha tinadubame pocotsiwa inta caenaetame, xuano xua inta comocame. Tsipei jopa becaexanaetsi equeicha xua inta yapucaecame daxita tawan’, jei. ");
INSERT INTO cui_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nexata pon bo peyapucaecaeinxae nacui yabara nanta xeina pia coutha, nabarai: ‘¿Eta pocotsiwa exanocuaein anoxuae tsipei nama pon tanecanamataxeinaein imoxoyo necopata xua bapoxonae jopa taxeinaewa tsane pocotsiwa taexanaewa? Jopa nebusi coxonaeyo xua naein taʉncatsiwa pabitha. Auran tsipae xua saya amanaya i tawʉqueibiwa paratixi. ");
INSERT INTO cui_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jaina, bara yaputan xua po coyeneya exanaein poxonae tanecanamataxeinaein necopatsina, xua poxonae jopa xeinaein tsane tanacuichiwa xua ichamonae tanententa wabeibinexa pia botha’, jei. ");
INSERT INTO cui_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Nexata bapon pon bo petayapucaecaein daxita tamropatsiya wawabapona pomonae pia pecanamataxeinaeinchi petantoma amanayabixaetsi. Bapon matha yainyaba pontha pon copiya patopa jeye: ‘¿Eta xoyobe matoma amanayabame xua jopa cataunxuae catsim pontha pon tanecanamataxeinaein?’ jei. ");
INSERT INTO cui_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Bapon jume nota, pon bo peyapucaecaein, jume notatsi, jeye: ‘Cien po penasi mera bosibʉbe xua pin bosixibʉn tha baxua catichi, ichitha cataunxuae jopa baxota matomatsinyo barapo penasi mera bosibʉn’, jei. Pon bo petayapucaecaein xuya jume nota: ‘Taema xote xeinanje jinya papera xua tinadutame, cien po nasi bosixibʉn, jam, xua bexa matomatsiname. Xote nainya ecoundeinque barapo netinadutsiwa, iquinaxore. Icha itaneto dure xua saya cincuenta po penasi mera bosixibʉbe, jande’, jei pon bo petayapucaecaein. ");
INSERT INTO cui_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bapoxonae equeicha ichʉntha yainyaba: ‘Incane irʉ xamdʉ, ¿eta xoyobe tanecanamataxeinaein taacoibichi xua catsiname bapon?’ jei. Bapon jume nota, pon bo petayapucaecaein jume notatsi, jeye: ‘Tha catichi cien po sacube aro sacun’, jei bapon. Nexata pon bo petayapucaecaein xuya jume nota: ‘Taema xote xeinanje jinya papera xua bayatha tinadutame xua cien po sacube, jam, xua bexa matomatsiname pontha pon tanecanamataxeinaeintha. Xote nainya ecoundeinque barapo itaneto tsitsinaxore, icha pena netinadutsiwa tinadure xua saya ochenta po sacube, jande’, jei pon bo petayapucaecaein. ");
INSERT INTO cui_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ichitha bo pexeinaein yabara paeba pon bo petayapucaecaeinchi xua pinae bequein bara bapon abe taexana ichitha yaputane xua pocotsiwa pia coutha nayawena xua poxonae pia jiwimonae peexanaewa. Daxota paca tsipaebatsi pomonae anoxuae jinompa barapo cae pin nacuathe, pomonae jopa penejume cowʉntsiwi nama barichi. Barapomonae yabara najʉntʉ coyene wʉnaeta xua po coyene cae jiwimonae penaexanaewa xua daxota cae jiwimonae nantiya penayaweneibinexa. Baxua barapomonae exana beyacaincha pomonae Nacom pejume cowʉntsiwi. ");
INSERT INTO cui_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Paca tsipaebatsi ichamonae pacatsibeibare paratixi xua painya jiwi painya neexaneibinexa po paratixi xeina pomonae barapo cae pin nacuathepiwi pomonae abe peexanaewi. Bapoxonae poxonae jopa paxeinaem tsane paratixi pomonae bayatha payawename barapomonae paca matenta weiweinaya wabina po bontha xua ataya tsitecaeya pajinompaename. ");
INSERT INTO cui_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Pon xua xanepanaya yapucaeca xua poxonae peya penacuichiwiyo, barichi beta yapucaeca xua poxonae pin penacuichiwa. Pon naerabiya exana poxonae peya penacuichiwiyo, barichi naerabiya exanaena xua poxonae pin penacuichiwa. ");
INSERT INTO cui_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Icha paxam jopa xanepanaya patayapuenaem xua paratixi xua barapo cae pin nacuathe nexa, Nacom jopa paca itorobiyo xua patayapuenaename xua bapon pia pexeinya pexeinaewa tatsi. ");
INSERT INTO cui_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Icha jopa xanepanaya payapucaecaem ichʉn piawa, metha nexata jopa paca catsipae xua painyawa nexa tsane painya neyapucaenaewamxae. ");
INSERT INTO cui_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Jiton dapon aibi pon xeina ainya pia pecanamataxeinaeinchibe tatsi xua pon beta tanacuita barapo pia ainya pecanamataxeinaeinchibe tatsi. Tsipei barapo petanacuichin meisa antobeya taexana caeintha pon pia pecanamataxeinaeinchi poxonae itorobatsi. Icha pia pecanamataxeinaeinchi jopa taraichiyo. Cae pia pecanamataxeinaeinchi xanepanaya taexana. Icha pia pecanamataxeinaeinchi abeya taexana. Barichi jiton pon bichocono antobe Nacom, jopa itacʉpaetsi xua bichocono peantobewa paratixi poxonae yawa bichocono antobetsi Nacom”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ichitha fariseomonae pomonae xua bichocono antobe nawita paratixi, barapomonae baraxua Jesús jume tayenatsi, yawa Jesús cui caponatsi. ");
INSERT INTO cui_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Nexata Jesús fariseomonae baraichi, jeye: “Paxam barapomonae pam, xua ichamonae paca yabara nanta xeina xua pejʉntʉ coyene xanepanae jiwi pam. Ichitha Nacom paca jʉntʉ coyene yaputane xua peajʉntʉcoyenebe jiwi pam. Xua pocotsiwan jiwi bichocono tsita ainya cuichi, baxuan Nacom bichocono tsita abetsi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Equeicha Jesús namchi, jeye: “Caena bayatha jiwi xeina Moisés pia peitorobi coyenewa tatsi, yawano xua pomonae Nacom peitorobi jume pepaebiwi pia pecuidubiwa tatsi, beya Juan patopa. Barapoxonae caena poxonae Juan popona pon jiwi Pebautisabin, jiwi paebinouta po coyene Nacom xua waba jiwi petanaexanaenexatsi pijimonae tatsi pomonae itorobiya peewatsixae. Jiwi bewa yabara najʉntʉ coyene sʉbi awiya xua pepatsinexa Nacom pia peitorobi nacua beicha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Yapu xanepana xua itaboco yawa ira peweraweracaewa. Nama Nacom peitorobi jume ajumeyapusʉ bapana jopa peweraweracaewa bequein bara cae peitorobi coyene”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Equeicha Jesús namchi, jeye: “Pon punaxuba piowa yawa ichowa pichapa, bapon abe exana piseuritha yawa Nacom peitʉtha tatsi, tsipei Nacom tsitatsi xua powa copiya barʉ popona apara bara piowa tatsi. Barichi pon pita petsiriwa powa pepunaxubixae piseuri, bapon barichi pia coutha abe natsiexana, tsipei Nacom ichowa yabara nanta xeina xua bapowa cataunxuae pia pebin xeina bequein bara punaxuba”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Equeicha Jesús tsipaeba icha diwesi, jeye: “Matha irʉrʉ barichi pebin pon copei pexeinaein. Pexeinya paparuwan xua pena paparuwa nama xatabapona. Mataʉta daxita matacabi peitʉpanae nabanaewa exaneiba. ");
INSERT INTO cui_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Irʉrʉ ichʉn pebin popona, pon pewʉn Lázaro pon peacopeibin. Bapon Lázaro wan nawita xeina peparʉtotha. Bapon iratha eca pon copei pexeinaein pia bo boupatha weya tatsi. ");
INSERT INTO cui_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Xua pon copei pexeinaein pia pexaethopaewatha taothopeicatsi pexaewa pepʉrʉwan, baraxua Lázaro ichichipa xaiba. Yawa aurimonae pata xua Lázaro pewan daebinexatsi. ");
INSERT INTO cui_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Icha matacabitha Lázaro tʉpa. Matatsunpiwi Lázaro jumope pitatsi. Jumope capoinchi ichaxota Abraham popona athabeicha. Irʉrʉ pon copei pexeinaein tʉpa, yawa mʉthʉtha xotsi. ");
INSERT INTO cui_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Pon copei pexeinaein patopa ichaxota pateiba pomonae pewerapeibiwi barapo petʉpae cuiru coyene nacuatha. Bapon bichocono atene. Bapon athabeicha necoicha. Bapoxonae Abraham tajʉ taebiyatsi asiyeicha, yawa xua Lázaro barʉ equiyatsi. ");
INSERT INTO cui_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pon copei pexeinaein wawai: ‘Tamo susato jiwanam, Abraham, necui yabara nanta xeinare. Inta Lázaro itorobinca taneebato memeinyatsinexa meratha poxoru bichocono netaxua po isotothe uncuan’, jei. ");
INSERT INTO cui_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ichitha Abraham jume nota: ‘Tamonae susato jiwanam, nanta xeinatabare xua caena bayatha poxonae cataunxuae asʉ poponame, xeiname xua acabem xua pocotsiwan ichichipame xua nexeinaewa. Xanepanaya poponame. Ichitha nama Lázaro jopa daichiyo poxonae cataunxuae asʉ popona. Jopa xanepanaya poponaeyo. Xote bapon wʉnae yabara nantanuweya cananta xeinatsi xua peyawenaenexatsi. Ichitha nama xam jopa caraichiyo. Bichocono caperʉ weyawa. ");
INSERT INTO cui_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yawa pin pitapatororo naca yacaincha ducua. Daxota pomonae ichichipa bara bedunareca taxainya wereca jopa itacʉpaetsi xua bara beparecaena nexainya bereca. Irʉ pomonae nexainya weruneina jopa itacʉpaetsi xua taxainya betsina pepatsinaenexa’, jei. ");
INSERT INTO cui_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nexata pon copei pexeinaein jume nota: ‘Nexata tamo susatopim cawʉcatsi inta Lázaro itorobare taxa pia bo beya. ");
INSERT INTO cui_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Baxota xeinan cinco poyobe tayapin jiwi. Abraham Lázarotha najume carure xua bʉ tayapin jiwi jopa pepatsinexarʉ tsane ichaxota uncuan xua bichocono atenein’, jei. ");
INSERT INTO cui_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ichitha Abraham jume nota: ‘Apara neyapin jiwi xeina Moisés pia peitorobi coyene tatsi, yawa Nacom peitorobi jume pepaebiwi pia penacuidubiwan tatsi. Bʉ barapomonae exana pocotsiwa baraxua pejume coya’, jei Abraham. ");
INSERT INTO cui_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pon copei pexeinaein jume nota: ‘Aa, tamo susato jitom, Abraham, ichitha icha petʉpaewi jiwana caein siwa ponaena barapomonae beya, barapomonae jume cowʉntsina yawa icha jʉntʉ coyene pexeinaenexa tsane Nacomtha’, jei. ");
INSERT INTO cui_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ichitha Abraham jume nota: ‘Icha barapomonae jopa exanaeyo xua peexanaewa pocotsiwa Moisés pia peitorobi coyene tatsi itoroba, xuano xua Nacom peitorobi jume pepaebiwi pia pecuidubiwan tatsi, barapomonae jopa jume cowʉntsipae bara bequein Nacom taitorobichipa xua jiwana caein pomonae petʉpaewi’, jei Abraham”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús namchi pijimonaetha, jeye: “Barapo nacuathepiwi ataya xeineiba po jiwi pecana exanaexaetsi xua ichamonae cana exana xua barapo jiwi abe peexanae cuiru coyene peexaneibinexa xua daxota jopa nejume cowʉnteibiyo. Ichitha pebin tsocuae xua bapon cana exana, xua ichʉn cana exanatsi, xua ichʉn abe peexanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Metha jame wʉnae tsipae xua barapo pebin pin iboto wisi cʉtsipatsi pin mar mentha barapo iboto cayawa cabutabachipatsino. Tsipei jopa wʉnae tsipae xua bapon cana exana xua ichamonae abe peexanae xuiru coyene exana pomonae cataunxuae aena nejume cowʉnta. ");
INSERT INTO cui_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Dota pam, xua jopa bara paichim tsane! “Icha ichʉn pon irʉ pejume cowʉntsindʉ, icha bapon pacata abe exana, bapon baxua yabara patsipaebare. Icha icha jʉntʉ coyene paca tsita xeinaena peauraxae xua pacata exana, bapoxonae pacui yabara jʉntemainare pocotsiwa bapon pacata exana. ");
INSERT INTO cui_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Bequein bara bapon abe pacata exana, siete po cuiyobe xua cae matacabitha, yawa paca tsipaeba siete po jumeyobe, bapon jeye: ‘Maisa auran tsocuae xua abe pacata exanatsi, equeicha jopa pacata abe exanae tsainchi’, jei pon abe exana. Daxota paca jeichi xua nantawenona peyabara jʉntemainaewa baxua xua po coyene bapon pacata abe exana”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesús pon Pecanamataxeinaein jiwi, equeicha pia peitorobiwi baraichi, jeye: —Pana cana exande xua bichocono pata jume cowʉntsiwa beyacaincha xua anoxuae, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nexata Jesús pia peitorobiwi jume nota, jeye: —Icha paxeinaetsipame xua be peya pejume cowʉntsi coyenewiyo xua bequein icha mostaza xutiyo jʉta ichi xua tsica xutiyo ichitha bara paca itacʉpa xua naewatha painya nejeiwa: ‘Ee, naewa jinya coutha natabʉ jonde yawa pin mar mene beya equeicha uncuare’, painya nejeiwa. Bapoxonae barapo nae jopa bayatha tsipae poxonae pajam tsipae baxua, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Equeicha Jesús namchi, jeye: “Metha ba paxam jiwana caein xeina pia petanacuichinchi pon penacuichin bapon ira cacobauya, mataʉta vaca yapu capopona. Bapoxonae bapon pon penacuichin wexua wenawirena, bo benawirena. Pon paxam jiwana caein metha bapon jopa jei tsipae: ‘Anetha, jondena matha xaema’, jopa jei tsipae bapon. ");
INSERT INTO cui_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Jame bapon jei tsipae: ‘Pexaewa netsiʉpain exanare. Inta carena tsaibinde pexaewa pexaethopaewatha poxonae xunaecan. Bapoxonae cotacaya bexa nabanare’, jei tsipae pon paxam jiwana. ");
INSERT INTO cui_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pon penacuichin jopa jei tsipaetsi: ‘Jaco xua taneyawenaewam’, jopa jei tsipae pon paxam jiwana. Tsipei saya taexanatsi xua bapon peitorobixae. ");
INSERT INTO cui_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Icha pon petanacuichin ichi xua taexana peitorobixaetsi pia pentacaponaein, paxam bara jʉta paichinde. Poxonae pawetame pocotsiwa Nacom paca itoroba, pajande: ‘Paxan pata nebusi cui tataewimonae pan xuano pata pecui pawi pan, tsipei saya paexanan xua pocotsiwa bewa paexanaein’, pajande”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Poxonae Jesús cataunxuae ecapona Jerusalén tomara beya nexa, Samaria nacua iya pona yawa Galilea nacua iya pona. ");
INSERT INTO cui_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Poxonae Jesús tsica tomariyotha patopa, diez poyobe pebiwi pata Jesús pia xantha tatsi. Barapo diez poyobe peperʉ sawichimonae, ichitha barapomonae Jesús tajʉ wetaeumendenatsi. ");
INSERT INTO cui_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Barapomonae wawai, jeye: —Jesús, pon Patatanecuidubim, pana neyabara najʉntʉ coyene xeinare jinya pata tana neyawenaenexam, jei barapo peperʉ sawichimonae. ");
INSERT INTO cui_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Poxonae Jesús tane barapomonae, Jesús barai, jeye: —Paponare sacerdotemonaetha painya nepaca cataenexa, jei Jesús. Poxonae cataunxuae namtotha enapona, bapoxonae barapomonae perʉ jume tsʉrʉcʉpae xua peperʉ sawiwatsi barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Barapo diez poyobe jiwana caein, poxonae bapon taeba xua axaibi tsʉrʉcʉpae, bapoxonae Jesús beya pona, xua caibeya pona, yawa jume daunweya Nacom wʉnae jaintatsi. ");
INSERT INTO cui_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Barapon pentabocototha uncua Jesús peitabaratha tatsi. Yawa irabe taeuncuareca xua Jesús pejacobinexatsi. Barapo pebin apara pon seicaya Samaria nacuapin. ");
INSERT INTO cui_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nexata Jesús namchi, jeye: —¿Diez poyobe itara axaibi exanan? ¿Incane dapo nueve poyobe jane? ");
INSERT INTO cui_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Bapon apara penanapaincha jinompaewi jiwanapin. Yawa cou compa caiberena pia wʉnae jainchichi Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nexata Jesús equeicha pebin baraichi, jeye: —Nontaponde pondeno, bayatha axaibim tana neyabara jume cowʉntsixaemxae xua bara tana neitacʉpaewa xua axaibi tacaexanaewatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseomonae Jesús yainyabatsi namchi, jeye: —¿Eta poxonae Nacom itorobina pon peitapetsinxae pata tanecapanenebiwa exanaenexa, xuano xua itorobiya pata taneewatsiwa? jeichichi barapomonae Jesús. Jesús jume nota, jeye: —Poxonae Nacom itorobiya ewatsina jiwi, barapo coyene jiwi jopa itacʉpaetsi xua petaewa baxua. ");
INSERT INTO cui_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Daxota jiwi jopa jei tsane: ‘Baraxote bayatha patope’, jopa jei tsane. Mataʉtano jopa jei tsane ‘Xoteiche bayatha patope’, jopa jei tsane. Tsipei apara po coyene xua Nacom itorobiya ewatsina jiwi barapo coyene patopa jiwitha. Daxota Nacom jʉntʉ coyene itorobiya ewatsina jiwi pomonae pejume cowʉntsiwixaetsi Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nexata Jesús barai pijimonae, jeye: —Matacabin othopaena po matacabintha poxonae paichichipame xua painya tana netaewam xua ponxaein Nacom Tananeitapetsin xuano xua muxuna bepataebenaename caentacabi xua barapo matacabin jiwana. Dapo jumetha jopa painya nepaca itacʉpaewa tsane xua painya tana netaewam tsane xuano xua caentacabi xua barapo matacabin jiwana. ");
INSERT INTO cui_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ichamonae paca jei tsane: ‘Baraxote bayatha patopa bapon’, paca jei tsane. Ichacuitha paca jei tsane: ‘Baraxoteicha bayatha patopa bapon’, paca jei tsane, ichitha jopa paponaeinde bara beya yawa jopa pajume cowʉntsinde. ");
INSERT INTO cui_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Icha yamʉxʉ ichi xua jemeicha yacoicha uncueica, xua coicha nayotaxuba itabocototha, barichi tsane po matacabitha poxonae patopeicaein ponxaein Nacom Tananeitapetsin. ");
INSERT INTO cui_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ichitha copiya nantawenona xua neperaxa jʉbina ichamonae. Yawa neitawetsinano pomonae xua anoxuae jinompa. ");
INSERT INTO cui_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Icha matha ichi poxonae Noé caena bayatha popona jiwi jopa tsaqueinaeyo xua Nacom pin awʉbo exanaena methaunxuae. Saya barompaya icha jʉntʉ cuitha jinompa daxota jiwi werapa. Barichi jʉta ichi tsane poxonae patopeicaein barapo cae pin nacuathe xua ponxaein Nacom Tananeitapetsin. Poxonae patopeicaein jiwi jopa tsaqueinae tsane xua Nacom werapa exanaena barapo jiwi pomonae jopa pejume cowʉntsiyoxaetsi. ");
INSERT INTO cui_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pomonae jinompa poxonae Noé popona, barapomonae jʉntema nabaneiba, yawa apeiba, yawa apeiba yawa jiwitha jijinapona yawa pexantixi jitha dodoubapona, beya yantacabi othopa poxonae po matacabitha Noé pin jera naetha joniya. Bapoxonae pin ema mʉ jopa. Daxita Noé wepu bunothopatsi pomonae jinompa poxonae Noé popona. ");
INSERT INTO cui_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Barichirʉ jiwi pocotsiwa ichamonae exana poxonae ichʉn pebin popona pon pewʉn Lot. Barapomonae nabaneiba, yawa apeiba, yawa comaqueiba, yawa caenaeteiba, yawa pexaewa ʉbeiba, yawa bomʉxʉn acabeiba. ");
INSERT INTO cui_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Poxonae bapon Lot Sodoma tomara wenaetabiya, barapoxonae iso itere mʉ, mʉ othopeica tomaratha, yawa pocotsiwa be ibo pʉrʉ baxua itaboco weothopeicano xua bichocono atou. Daxita Sodoma tomarapiwi werapa. ");
INSERT INTO cui_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Icha Sodoma tomaratha ichi xua jemeicha iso itere mʉ, mʉ othopeica yawa xua jemeicha ibo pʉrʉ itaboco weothopeica, bara jʉta ichin tsane jemeicha patopeicaein ponxaein Nacom Tananeitapetsin poxonae jiwi tsita naitʉtsin. ");
INSERT INTO cui_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Barapo matacabitha icha ichʉn bo matatupatha uncua, barapon jopa bewa botha joniyae tsane xua penotsiwa tsane pocotsiwa tabobeinchi bomʉxʉ tututha. Irʉ pon pabitha popona jopa bewa caibeya ponae tsane botha, saya jame nainya benaetsiricuaena. ");
INSERT INTO cui_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pacui yabara nanta xeinare Lot piseuri tatsi xua tʉpa poxonae jopa nainya naetsiricuaeyo piawan caibe pesiwa necoyaexae. ");
INSERT INTO cui_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pon naantobeya nata exana pocotsiwa bapon ichichipa, bapon jopa xeinaeyo peajʉntʉyapusʉwa po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. Ichitha pon neantobeya inta exana pocotsiwa ichichipan bapon xeinaena peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca xua Nacom pia nacua beicha. ");
INSERT INTO cui_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Paca tsipaebatsi po mataqueitha patopaein, ainya pebinbe ponbe xua nanta jʉpaya maitecabe, caein matatsunpin pichina, pon pejume cowʉntsixae Nacom. Ichʉn saya cuenta ponaeinchi jopa pejume cowʉntsiyoxae Nacom. ");
INSERT INTO cui_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Irʉrʉ ainya yabʉyobe nacuara yacatoyorobauyaenabe, ichowa matatsunpin pichina pejume cowʉntsixae Nacom. Ichowa saya cuenta ponaeinchi jopa pejume cowʉntsixae Nacom. ");
INSERT INTO cui_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Irʉrʉ ainya pebinbe nacuara nacuitauyaenabe pabitha, ichʉn matatsunpin pichina, ichʉn saya cuenta ponaeinchi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Poxonae baxua Jesús pijimonae jume tainchi, Jesús yainyabatsi jeichichi, jeye: —Pata Tanecanamataxeinaem, ¿exota metha baxua exanaena? jeichichi pijimonae. Jesús pijimonae jume nota pecayabara jʉta pepaebi diwesiyotha, jeye: —Quequeremonae ba nacaetuta ichaxota baurin boca. Bara jʉta paichim tsane paxam pomonae tana nejume cowʉntsi jiwi pam pana newʉnae ewatsiname po mataqueitha patopeicaein, barapo mataqueitha panacaetutsiname, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús pijimonae tsipaeba pecayabara jʉta pepaebi diwesiyo xua pecuidubinexa, jeye: “Paxam daxita matacabi bewa pawʉqueibim Nacom. Painya xoba paajʉntʉcoyenefaetabim tsaibim poxonae pawʉqueibame”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Equeicha Jesús pijimonae barai, jeye: “Matha irʉrʉ tomaratha popona pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae. Bapon jopa Nacom cunuwichi. Yawa bapon jopa beta yabara nanta xeinaeyo jiwitha xua peyawenaenexa. ");
INSERT INTO cui_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Barapo tomaratha irʉrʉ popona petsiriwa, powa pecuenta tʉpaewayotsi piseuri. Barapowa siwa poneiba pontha pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae. Barapowa jei tsaibi bapontha: ‘Neyawende, ichʉn inta abe exana’, jei tsaibi. ");
INSERT INTO cui_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae bapon ainya matacabin juntucuru jopa beexaneibiyo pocotsiwa barapowa wʉqueiba. Ichitha bapon matapainya nanta xeina. Najei: ‘Xan apara jopa Nacom cunuwinyo. Mataʉta jopa beta tayabara nanta xeineibin jiwi xua tayawenaenexa. ");
INSERT INTO cui_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ichitha barapo pecuenta tʉpaewayotsi piseuri matowa nefayacota daxota neamuxufaetabi exana. Metha moya barapowa yawenaein, xua equeicha barapowa jopa penesiwa ponaenexa, tsipei bichocono amuxufaetabin’, najei pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús pon Pecanamataxeinaein jiwi equeicha namchi, jeye: “Baxua apara pocotsiwa paeba pon jiwi peyabara paebin xua penatsicuentsiwa xua abe peexanaexae xuano pon jopa beta yabara nanta xeinaeyo jiwitha xua peyawenaenexa. Pajume naitaeware pocotsiwa bapon paeba. ");
INSERT INTO cui_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Eta xua metha pananta xeiname? ¿Metha bara Nacom came bayatha tsaibi poxonae jiwi yaweneibatsi pomonae xua pewʉqueibixaetsi? ¡Jume, apara! Nacom nainya jiwi yaweneiba poxonae barapo jiwi abe exaneibatsi ichamonae, beyacaincha xua barapowa yawenatsi. Jame yatsicaewa Nacom yaweneiba pomonaetha pomonae peitapetsixae pewʉqueibixaetsi merawitha yawa mataqueithano. ");
INSERT INTO cui_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Paca tsipaebatsi xua Nacom jopa bayatha tsaibiyo xua peyaweneibinexa pomonae nejume cowʉnta. Xan ponxaein Nacom Tananeitapetsin poxonae patopeicaein, ¿metha bara pin bicheito taeyopeicaein jampa, pomonae xua xanepanaya beta tana nejume cowʉntsiya jinompaewi pomonae Nacom pewʉqueibiwichi?” jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús icha pecayabara jʉta pepaebi diwesiyo tsipaeba pomonaetha pomonae jiwi peaebiwi pomonae xua nayabara nanta xeina xua pinae beta jume cowʉnta xua pinae ichamonae jopa daichiyo. ");
INSERT INTO cui_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jesús namchi, jeye: “Irʉrʉ ainya pebinbe Nacom pin pia bo beya ponabe, xua baxotiya pewʉcaenexabe Nacom. Ichʉn fariseomonaepin, ichʉn bapon jiwana pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. ");
INSERT INTO cui_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseomonaepin nantacotuncua yawa penthʉtotha wʉca Nacomtha. Poxonae tsipaeba Nacom, jeye: ‘Nacom meisa xam nejʉntʉ coyene xanepanaein. Jʉntʉ coyene weiweinan xua tana neyawenaewam tsipei xan jopa be ichamonaeinyo pomonae xua jiwi pecaibiwi, yawa xua peabewi, xuano xua penasi cui matacaetsiwi yabʉxitha. Mataʉtano xan jopa dapomonae jiwananyo pomonae xua paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. ");
INSERT INTO cui_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Xan cayabara nainbotatsi ainya cuiyobe xua cae semanatha, beta tacawʉqueibinexatsi. Mataʉtano cae paratixi jiwana wetsabeiban xam nexa poxonae diez po paratiximonaebe xeineiban. Yawano daxita xua xeinan baxuano jiwana tsaban xam nexa’, jei fariseomonaepin. ");
INSERT INTO cui_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ichitha pon paratixi pentoma noteibin auranaya tajʉ beuncuiya. Saya irabe necoreca yawa jopa athabe necoichaeyo. Saya ʉ penantanuweya penanthʉthʉ jayabi abe peexanaeinxae. Bapon Nacom wʉca, jeye: ‘Jaibo, Nacom neyabara najʉntʉ coyene cui xeinare xua tana neyawenaewam tsane bequein bara taajʉntʉcoyeneyapubein’, jei pon paratixi matoma penoteibin. ");
INSERT INTO cui_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Barapon pon paratixi penoteibin poxonae najume weta xua wʉca Nacom, nawiya pia bo beya. Paca tsipaebatsi xua barapon Nacom tsitatsi xua jopa xeinaeyo xua penatsicuentsiwa xua abe peexanaexae. Ichitha fariseomonaepin jopa daichichi tsipei bapon awiya peajʉntʉcoyenebein. Pon xua pia coutha peainya cui jiton naexana pejʉntʉ coyenetha, Nacom exanaena xua bapon pecui pawi jiton naexanaena. Ichitha pon xua pepawi naexana pejʉntʉ coyenetha, Nacom exanaena xua bapon peainya cui jiton naexanaena”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nexata jiwi Jesús tacaponatsi pexui, xua Jesús pejayabinexa pecobetha yawa xua Nacomtha petawʉcaenexa barapo pexui xua pejeinexa: “Barabʉ Nacom beta paca yawenaena”, pejeinexa. Ichitha Jesús pijimonae tatsi poxonae baxua tane, tamropata notarʉcʉpa xua barapomonae cui matawentatsi pomonae pexui carendena tsaibi. ");
INSERT INTO cui_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ichitha Jesús waba pexui. Jesús pijimonae barai: —Bara pacopabare pexui xua tana itata patsinexa. Jopa pexui paitawetsinde, tsipei Nacom pia peitorobi nacua tatsi saya meisa barapomonae nexa pomonae pejʉntʉ coyene xanepanaewi icha pexui ichi. Pexui pia cui xua tayapu xanepanatsi xua pia jʉntʉ coyeneintha jume cowʉnta Nacom. ");
INSERT INTO cui_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xaniyan paca tsipaebatsi. Pon jopa yabara jume cowʉntsiyo xua icha be jopa pexui ichiyo xua ba pexui tayapu xanepanatsi xua jume cowʉnta, bapon bapana jopa naexanae tsane Nacom pijimonae tatsi pomonae Nacom itorobiya ewata, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Caein pon pentacaponaewi jiwanapin bapon Jesús yainyabatsi, jeichichi: —Ja Tanecuidubim, maisa nejʉntʉ coyene wʉnaem. ¿Eta xua copiya matha exanocuaein xua ajʉntʉyapusʉya tapoponaewa tsane xua ataya tsane? jei. ");
INSERT INTO cui_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús jume epa pita, jeye: —¿Eta xua nebaram: ‘Nejʉntʉ coyene xanepanaem’, jam? Apara ichʉn dapon aibi pon pejʉntʉ coyene xanepanaein. Jame meisa apara bapon Nacom compa pejʉntʉ coyene xanepanaein. ");
INSERT INTO cui_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Xam yaputaneme po coyene Moisés pia peitorobi coyenewatha itoroba xua jeye: ‘Jopa ichowa pichinde ichʉn piowa tatsi, jopa ichʉn bexubinde, jopa caibinde ichʉn piawan tatsi, jopa naerabiya cayabara paebinde pocotsiwa ichamonae exana. Axatha jume barʉ cui itura jinare. Mataʉtano enatha jume barʉ cui itura jinare’, jei Moisés, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pon pentacaponaein jume epa pita, jeye: —Daxita caena bayatha barapo coyenein exaneiban, poxonae pexuyothan tamropata pitaban, beya anoxuae yacuiya pinyon, jei. ");
INSERT INTO cui_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Poxonae Jesús baxua jume tane, Jesús barai, jeye: —Cataunxuae icha cui coyene cata seica xua pocotsiwa neexanaewam tsane. Icha ichichipame xua jopa necata acoibiyonexa tsane xua pocotsiwa xanepanaeya neexanaewa, matha daxita caenaere pocotsiwa xeiname, yawa catsibare pomonaetha pomonae peacopeibi jiwi. Bapoxonae jame moya anetha, nepuna ponde. Bequein bara bapoxonae acopeibim tsane, daichitha Nacom cacatsina peitaboco beicha, pocotsiwa Nacom necajʉntana botsiwa pocotsiwa bichocono wʉnae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Poxonae barapo pebin jume taeba, bichocono jʉntʉ wecoyei, tsipei bichocono copei pexeinaein. ");
INSERT INTO cui_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Poxonae Jesús tane xua barapon jʉntʉ coyene wecoyei, Jesús barai, jeye: —¡Maisa bichocono ayapubecai xua copei pexeinaewi naexana Nacom pijimonae tatsi jiwana pomonae itorobiya canamataxeina! Tsipei barapomonae bichocono antasiwayatane barapo pia copei, beyacaincha xua Nacom antobetsi. ");
INSERT INTO cui_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nama bichocono acuiruyapube xua duwein pon pewʉn camello xua bapon pejoniyaewa acuicheto peetabʉ wan iya. Ichitha nama yatsicaewa pon bichocono copei pexeinaein taacuiruyapubetsi xua naexana Nacom pijimonae tatsi jiwana pomonae itorobiya canamataxeina beyacaincha xua poxonae acuiruyapube xua poxonae camello acuicheto peetabʉ wan iya pejoniyaewa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pomonae xua baxua jume taerʉcʉpa, barapomonae Jesús yainyabatsi, jeye: —Bapoxonae ¿jintam metha nexata itacʉpatsi xua penacapanepaewa pia coutha? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús jume nota, jeye: —Pebiwi ba jopa itacʉpaetsi xua baxua exana, saya jame meisa Nacom compa itacʉpatsi xua jiwi napaeba cana exanatsi. Tsipei daxua ajibi pocotsiwa Nacom taacuiruyapubetsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro barai, Jesús baraichi: —Tapata Tanecanamataxeinaem, paxan daxita pacuenta ponan pocotsiwa paxeinan pata paca puna ponaewa tsainchi, jei Pedro. ");
INSERT INTO cui_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús jume nota, jeye: —Bara xainyeya paca tsipaebatsi. Nacom beta cana exanaena daxita pomonae peyabara cueicueijeixae po diwesi xua Nacom waba jiwi petanaexanaenexatsi pijimonae tatsi pomonae itorobiya peewatsixae. Nacom beta cana exanaena barapomonae pia bon pecuenta ponaexae, yawa piseuri pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae peweichowi pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae pamchowi pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae paxei jiwi pecuenta ponaexae, mataʉtano peniwi pecuenta ponaexae. Mataʉtano beta cana exanaena pomonae pia pexui pecuenta ponaexae. ");
INSERT INTO cui_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Barapomonae barapo coyenein exana taneantobe jiwixae, daxota daxita barapomonaetha Nacom jopa juniya catsi tsane barapo cae pin nacuathe. Mataʉtano barapomonaetha Nacom catsina pia peitorobi nacuatheicha peajʉntʉcoyeneyapusʉwa po peajʉntʉcoyeneyapusʉwa ataya tsiteca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bapoxonae Jesús pijimonae compa waba aisowa beya xua pomonae doce poyobe tatsi. Jesús barai barapomonae, jeye: “Anoxuae ponaeinchi Jerusalén tomara beya. Baraxotiya tana nayabara jume cui wetsinexa bara nama, po coyene Nacom pia peitorobi jume pepaebiwi newʉnae tsiwanaya yabara tina xua xan ponxaein Nacom Tananeitapetsin. ");
INSERT INTO cui_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yawa necaenaetsina pomonaetha pomonae penanapaincha jinompaewi, xua icha nacua werena peponaewi xua barapomonae tanecui caponaenexa. Mataʉtano abe neyabara paebina. Yawa neyabara naone subabina. ");
INSERT INTO cui_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yawa necuainchina, barapomonae nebexubina. Daichitha poxonae acoibi po matacabibe yapu caewina equeicha asʉ neexanaena petʉpae cuiru coyene weya”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ichitha Jesús pijimonae tatsi jopa yaputaeyo baxua xua pocotsiwa Jesús pijimonae tsipaeba. Barapomonae jopa jume ita cui cʉpaetsi poxoru Jesús barompaya nabarʉ jume yabara canamchi, baxua barapomonae taayapubetsi bichocono. ");
INSERT INTO cui_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Poxonae Jesús itiya pona Jericó tomara, pon peitata nacʉtsin namtotha eca, yawa jiwi wʉqueibeca paratixi. ");
INSERT INTO cui_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Poxonae bapon ponxae peitata nacʉtsin jume tane xua juinya pin bicheito pona, bapoxonae bapon yainyaba, ichamonae yainyabatsi, jeye: “¿Eta xua metha juinya pin bicheito pona?” jei pon peitata nacʉtsin. ");
INSERT INTO cui_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bapon ponxae peitata nacʉtsin jume notatsi, jeye: “Apara Jesús, Nazaret tomarapin xote imoxoyo patope”, jei. ");
INSERT INTO cui_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nexata bapon pon peitata nacʉtsin jume daunweya wawai, jeye: —Jesús, David pia pemomoxi susato jiwanapim, ponxaem Nacom necaitapetsim neyabara najʉntʉ coyene xeinare jinya tana neyawenaenexam, jei pon peita nacʉtsin. ");
INSERT INTO cui_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pomonae xua pin bicheito matacaenapoinchi, barapomonae pon peitata nacʉtsin jume matawentatsi xua moya peecaenexa. Ichitha bapon equeicha jume daunweya wawai, jeye: —Jesús, David pia pemomoxi susato jiwanapim ponxaem Nacom Necaitapetsim neyabara najʉntʉ coyene xeinare jinya tana neyawenaenexam, jei pon peitata nacʉtsin. ");
INSERT INTO cui_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nexata Jesús naruntaba. Jesús namchi, jeye: —Painta maxʉ xawena, jei. Poxonae pon peitata nacʉtsin imoxoyo patopa Jesustha, Jesús yainyaba, barai, jeye: ");
INSERT INTO cui_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Eta xua jinya tacata exanaetsi? jei. Pon peitata nacʉtsin jume nota, jeye: —Jesús Tananecanamataxeinaem, benecotsin cuinaya, jei. ");
INSERT INTO cui_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús jume nota, barai, jeye: —Moya necore antha. Axaibi caexanatsi tana neyabara jume cowʉntsixaemxae xua bara tana neitacʉpaewa xua tacayawenaewatsi, jei. ");
INSERT INTO cui_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Caena nainya bapon necotaxuba. Yawa Jesús puna poinchi. Mataʉtano Nacom wʉnae jaintatsi. Poxonae pin bicheito baxua cui tane, irʉrʉ daxita barapo bicheito Nacom wʉnae jaintatsi. ");
INSERT INTO cui_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericó tomaratha patopa. Bapoxonae bapon barapo tomara xenta iya. ");
INSERT INTO cui_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Baxota Jericó tomaratha pebin popona, pon copei bichocono pexeinaein. Bapon pewʉn Zaqueo. Bapon pon pecanamataxeinaein pomonae paratixi pentoma noteibiwi po paratixi jiwi bewa catsibina pon romanomonae itorobiya pia pepa peewatsinchi nexa. ");
INSERT INTO cui_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Barapon Zaqueo bequein ichichipa xua Jesús peyaitaewatsi, ichitha Jesús jopa taetsi tsipei pin bicheito, mataʉtano poxoru Zaqueo xataxatequeca. ");
INSERT INTO cui_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nexata Zaqueo nanta cacuinaepoinya, peitiya ecoinyaenexa tsane naetha, po nae imoxoyo namtotha uncua ichaxota Jesús ponaena, xua Jesús barapo naetheicha xaniwaicha peyaitaenexatsi. ");
INSERT INTO cui_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús barapo nae cacuita ecapona, bara asiya necoicha. Poxonae Zaqueo naetha tayeichatsi, Jesús namchi, jeye: —Zaqueo, nainya ecoinca tha jinya botha ecaetsi anoxuae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bapoxonae Zaqueo nainya dunatabica. Mataʉtano Jesús matenta weiweinaya wabatsi pia botha. ");
INSERT INTO cui_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Poxonae pin bicheito baxua tane, Jesús abe yabara paebatsi, jeye: —Maisa Jesús bewa jopa ponae barapo botha, tsipei bapon abe peexanae cuiru coyene peexanaein, jei barapo bicheito. ");
INSERT INTO cui_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nexata Zaqueo nantacotuncua pia botha, yawa jeye Jesustha: —Taema Jesús Tanecanamataxeinaem, tha daxita jiwana wetsabichi pocotsiwa xeinan, tacatsibinexa tsane pomonaetha pomonae peacopeibiwi. Mataʉtano pomonae xua naerabiya wʉcan cae paratixi equeicha caewa tha catsibichi cuatro po paratixibe, jei Zaqueo. ");
INSERT INTO cui_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús jume nota, jeye: —Anoxuae Nacom cana exana xua barapomonae pecapanenebiyae jiwichi, pomonae barapo botha peenaewi. Zaqueo, xam Abraham pia pemomoxi susatopiwi jiwanam. ");
INSERT INTO cui_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Daxota xan ponxaein Nacom Tananeitapetsin patopan tawenaweneinexa tsane pomonae abe peexanae cuiru coyene peexanaewi pomonae icha xam ichim, xua tacapanenebiyaenexa tsane barapomonae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Barapomonae jume tayena xua Jesús paeba barapo jiwitha poxonae Zaqueo yabara paebatsi. Daxota Jesús cuiduba barapo jiwi pecayabara jʉta pepaebi diwesiyotha, tsipei barapomonae nanta xeina xua Jesús pona Jerusalén tomara beya xua itara mexeya barapomonae itorobiya pia pepa peewatsinchi tatsi naexanaenawejei. ");
INSERT INTO cui_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Bapoxonae Jesús jeye: “Matha irʉrʉ pebin popona. Barapo pebin jiwanapin pomonae peainya cui jiwi pomonae barompaya piamonae matabʉxʉmonae. Barapo pebin tajʉ pona icha nacuatha xua barapon icha nacuatha peexanaenexa tsainchi pocotsin be jiwi itorobiya pia pepa peewatsinchi, xua itorobiya peewatsinexa piamonae. Barapoxonae caibe nawiyaena pia nacuatha. ");
INSERT INTO cui_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Poxonae cataunxuae jopa tajʉ ponaeyo matha waba diez poyobe pebiwi, xua petanacuichinexatsi. Daxita barapomonaetha barompaya catsina be cae paratixi xua pocotsiwa ainya matoma. Barapo pebin namchi pomonaetha pomonae pia petanacuichiwichi, jeye: ‘Barapo paratixitha pacomocare, equeicha pacaenaere xuya, painya xuya nawita nexeinaponaenexa paratixi. Payacobe cui othopare poxonae beya patopaein’, jei barapo pebin. ");
INSERT INTO cui_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ichitha bapon casebatsi piamonae, pomonae jinompa pia nacuatha tatsi. Pomonae bapon casebatsi, barapomonae itoroba ichamonae xua pecoyo wepetayiyaenexatsi poxonae bapon penta caponaein naexanopiya ichaxota pon jiwi itorobiya pia pepa peewatsinchi. Xua barapo penacajume caitorobiwichi pejeinexa: ‘Ponxaem jiwi itorobiya pia pepa neewatsin, taema, apara bapon piamonae aichaxaibichi xua peexanaewatsi pon jiwi itorobiya pia pepa peewatsinchi’, jei penacajume caitorobiwichi, xua saya tapaeba. ");
INSERT INTO cui_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Daichitha barapon cana exanatsi, pon jiwi itorobiya pia pepa peewatsinchi, xua ichʉn cana exana pon irʉ jiwi itorobiya pia pepa peewatsinchi, bapoxonae equeicha bapon caibe nawiya pia nacua beya. Poxonae bapon pia nacuatha patopa bapon waba pia petanacuichiwichi pomonaetha pomonae catsiba paratixi. Waba peyaputaenexa icha barapomonae metha comoca yawa caenaeta icha be pocotsi coyeneya bayatha bapon itoroba. ");
INSERT INTO cui_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pon copiya patopa bapon namchi: ‘Tanecanamataxeinaem, po paratixi necatame, barapo paratixitha comocan, xuya equeicha caenaetan, equeicha diez po paratixibe matoma xeineiban’, jei pon copiya patopa. ");
INSERT INTO cui_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pon pecanamataxeinaein jume nota, jeye: ‘Maisa xam beta exaname pon inta nenacuichim. Yaitama beta eexanaponame xua peyauyo caitorobatsi daxota pentacaponaein caexanatsi xua necanamataxeinaewa tsane diez po tomariyobepiwi’, jei. ");
INSERT INTO cui_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Irʉ icha petanacuichinchi patopa. Bapon jeye: ‘Tanecanamataxeinaem, po paratixi necatame, barapo paratixitha comocan, equeicha caenaetan, equeicha matoma xeineiban cinco po paratixibe’, jei. ");
INSERT INTO cui_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pon pecanamataxeinaein jume nota. Bapontha jeye: ‘Xam pentacaponaein caexanaeinchi xua necanamataxeinaenexa cinco po tomariyobepiwi’, jei. ");
INSERT INTO cui_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Irʉ icha pia petanacuichinchi patopa, bapon jeye: ‘Tanecanamataxeinaem, taema xote xeinanje jinya paratiyo, cata mata quiyontabatsi painyaweratha. ");
INSERT INTO cui_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Yaitama cacui cunuwatsi, tsipei be barapocotsim pon jopa jiwi juniya itorobeibim. Mataʉtano jiwi cobe itorobeibame xua noteibina pocotsiwa jopa jinyawiyo. Mataʉtano pexaewa xua naweta noteibame ichaxota jopa ʉbim’, jei. ");
INSERT INTO cui_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nexata pon jiwi itorobiya pia pepa peewatsinchi namchi: ‘Bepa maisa dapon abem. Apara xam jinya coutha nanatsicuentsi exaname abe nepaebixae. Xam yaputaneme xua xan pon jopa jiwi juniya taitorobeibin, xuano xua pexaewa naweta tanoteibiwa xua ichaxota jopa tacoya ʉbeibinyo, mataʉtano xua ichamonae cobe itorobeiban xua noteiba pocotsiwa jopa tawiyo. ");
INSERT INTO cui_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tsipei catsawiya neyabara nanta xeiname xua bichocono daunweya itoroban daxota bayatha inta bewa barapo paratiyo banco botha botsipame xua equeicha poxonae patopan, icha paratiyo equeicha matoma xeinaetsipan xua equeicha inta pemataropeichabotsixae tsipae poxonae ichamonae nacowaeta barapo paratiyo’, jei. ");
INSERT INTO cui_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pon jiwi itorobiya pia pepa peewatsinchi barai, pomonae xua ena baxota baraichi: ‘Barapon pacobe wepire barapo paratiyo, nexata barapo paratiyo pacare pon xua equeicha diez po paratixibe matoma exanaeya xeina’, jei pon jiwi itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pomonae ena, barapomonae jume epa nota, jeye: ‘Pon jiwi itorobiya pepa neewatsin, equeicha icha paratiyo jopa catsinde bapontha. Bayatha apara diez po paratixibe xeina’, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pon jiwi itorobiya pia pepa peewatsinchi barapomonae jume notatsi, jeye: ‘Paca tsipaebatsi, pon ba be conotha Nacom yabara yaputainchi Nacom bapontha cana exanaena xua ichawa peyabara yaputaewa tsane beya poxonae bapon equeicha bichocono Nacom pejume cowʉntsiwa tsainchi. Pon ba jopa ichipaeyo xua Nacom peyabara yaputaewatsi, Nacom wepichina po coyene bapon yaputane xua beya daxota Nacom jopa pejume cowʉntsiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yabara paca tsipaebatsi pomonae taneaitafaetabi jiwi. Barapomonae neaichaxaibi xua jiwi itorobiya pepa taewatsin tanecana exanaewa. Barapomonae pacarenenande ichaxota ecan. Barapomonae pajutebare ichaxota ecan’, jei pon jiwi itorobiya pia pepa peewatsinchi”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Poxonae Jesús baxua najume weta, bapoxonae pona Jerusalén tomara beya. ");
INSERT INTO cui_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jesús itiya patopa Betfagé tomara, Betania tomarano xua saya patopa demxuwatha po demxuwa pewʉn Olivowa tsipei baxota umena olivo naein. Bapoxonae nacueyatabe poyobe itoroba poyobe xua pijimonaexae tatsi jiwanabe pomonae xua doce poyobe. ");
INSERT INTO cui_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jesús barai baponbe, jeye: —Paponarebe po tomara painya itabaraya equiya. Poxonae papatopaenamebe barapo tomaratha, pacaxinaenamebe burro pon penʉn pon pequetanotsin, pon jopa ichamonae tsijuma enaeyo. Payama isanaxorebe bepayama carenandebe. ");
INSERT INTO cui_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Icha ichʉn paca barai: ‘¿Eta pocotsiwa payama isanaxubamebe burro?’ icha paca jei bapon, nexata pajandebe: ‘Pon Wanacanamataxeinaein bepa pata yama cayiyaeinjei, tsipei pinae nantawenona’, pajandebe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Poxonae baponbe tomaratha patopabe, tanebe be pocotsi coyeneya bayatha Jesús namchi. ");
INSERT INTO cui_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Poxonae baponbe burro yama isacauyabe, baponbe yainyabatsibe pomonae barapo burro pexeinaexae. Baponbe baraichibe: —¿Eta pocotsiwa burro payama isacauyamebe? jeichichibe baponbe. ");
INSERT INTO cui_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Baraponbe jume notabe barapomonaetha, jeye: —Pon Pecanamataxeinaein jiwi bepa pinae patayama cayiyaein, tsipei pinae nantawenona, jeibe baponbe. ");
INSERT INTO cui_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Baraponbe burro tayama cayabe, Jesús tayama cayatsi. Baraponbe burro paparuwa tsijuma jebicabe po paparuwan aitiyʉ xua baponbe pia paparuwan tatsi, bapoxonae Jesús cuaretsicatsi. ");
INSERT INTO cui_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús burrotha ecapona. Jiwi paparuwan namtotha yerababa jejebabapoinya. Barapo paparuwan Jesús matatsun ecapona burrotha. Barapomonae baxua exana tsipei Jesús matenta weyatainchi xua patopa. ");
INSERT INTO cui_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Poxonae Jesús muxu perunadecae demxuwa wereca, po demxuwa pewʉn Olivowa, tsipei baxota umena olivo naein barapoxonae pomonae Jesús pejume cowʉntsiwichi, barapomonae jʉntʉ coyene weiweinaya jume daunweya wawai. Yawano Nacom wʉnae jaintatsi xua bayatha pexeinya petsita itʉtsi coyenewan petaexae xua Nacom exana. ");
INSERT INTO cui_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Barapomonae jeye: —¡Pai jayana! ¡Maisa Jesús pon jiwi itorobiya pia pepa peewatsinchi, maisa wʉnae, bapon patopa Nacom peitorobixae! ¡Pomonae xua peitabocotha jinompa jʉntʉ coyene weiweina bichocono! ¡Maisa Nacom bichocono wʉnae jaintatsi pon athabeicha eca! jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Nexata fariseo jiwanamonae, pomonae naenapona pin bicheitotha, barapomonae Jesús baraichi: —Pon jiwi Necuidubim, jinya jiwimonae baxua jume matawende: ¡Moya pande! jande, jei fariseo jiwanamonae. ");
INSERT INTO cui_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ichitha Jesús jume epa pita, jeye: —Paca tsipaebatsi, icha barapomonae metha moya tsipae bara nexata iboton jume daunweya wawai tsipae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Poxonae Jesús imoxoyo Jerusalén tomaratha patopa, poxonae tomara tane, Jesús jʉntʉ coyene wecoyei tsanareca, poxoru Jerusalén tomaramonae yabara wecoyeichi. ");
INSERT INTO cui_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jesús namchi, jeye: “¡Pai maisa bepayaputaename xua pocotsi jʉntʉ coyene jʉntema jinompa paca cana exana! Nama anoxuae baxua nantsiyata. Jopa paca itacʉpaeyo xua painya nexeinaewa painya jʉntʉ coyenetha. ");
INSERT INTO cui_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Meisa matacabi pacata jopaena po matacabi abe. Barapo matacabitha painya nepaca caaitafaetabi jiwi paca yatomara yatoxoroto exanaxubina. Tsorobo paca yacaincha acabina. Yawa paca yacaincha umenaena daxita muxuneneintha. ");
INSERT INTO cui_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Paxam Jerusalén tomarapiwi pam, yawano painya pexuino, ichamonae paca jutebina. Painya bon iratha paca yawa bebai tsane. Jopa cae iboto asiya uncuiyae tsane, omeicha othopeicaena. Tsipei paxam jopa Nacom payaitaem xua poxonae paca necasiwa ponaewa”, jei Jesús Jerusalén tomarapiwimonae yabara. ");
INSERT INTO cui_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús Nacom pin pia botha joniya. Baxota Jesús aisowa benapuna torobabiya pomonae caenaeta baxota. ");
INSERT INTO cui_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús barai barapomonae, jeye: —Nacom Pejume Diwesitha jeye: ‘Tabo apara po botha xua jiwi tanetsipaebinexa tsaibi tsane barapo botha’, jei Nacom Pejume Diwesitha. Ichitha paxam barapo bo be pecaibiwi pia mʉthʉ tutu pacana exaname, ichaxota pijunuwi nantsiyabeibathopa, tsipei baxota panacaetutame saya ʉ xua painya necaibinexam tsane paratixi pomonaetha pomonae xua pateiba xua Nacom petsipaebeibinexatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nacom pin pia botha daxita matacabi Jesús cuidubeiba. Ichitha sacerdotemonae pia pentacaponaewi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, irʉrʉ tomara pia pentacaponaewi daxita barapomonae Jesús yabara nanta xeinatsi nawita xua pebexubinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ichitha jopa itacʉpaetsi barapomonae xua Jesús pebexubiwa tsainchi tsipei pin bicheito beta xanepanaya Jesús jume tayenatsi. ");
INSERT INTO cui_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Caentacabi Jesús Nacom pin pia botha joniya. Barapo botha Jesús cuiduba jiwi. Yawa Nacom pia pecapanenebiyae diwesi yabara cueicueijei. Bapoxonae irʉ sacerdotemonae pia pentacaponaewi tatsi pata. Irʉ pata pomonae jiwi pecuidubiwi xua Moisés pia peitorobi coyenewa tatsi. Irʉ pata pomonae penapatae jiwi. ");
INSERT INTO cui_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Daxita barapomonae Jesús baraichi, jeye: —Incane pana tsipaebare, ¿eta po peitorobi coyenewatha cuidubame baxuan? ¿Jintam cacata barapo peitorobi coyene? jei. ");
INSERT INTO cui_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nexata Jesús jume nota, jeye: —Xan irʉrʉ tha barichichi paca yainyabinchi pana nejume nore. ");
INSERT INTO cui_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Jintam Juan cui itorobatsi jane xua jiwi pebautisabinexa tsainchi? ¿Metha bara Nacom cui itoroba jampa? ¿Metha bara jiwi cui itoroba jampa? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Barapomonae caemonae yabara natsipaeba pocotsiwa Jesús pepaebiwa. Barapomonae jeye: “¿Eta xua metha jei tsainchi? Icha jei tsipaetsi xua Juan cui itorobatsi Nacom xua pebautisabiwa jiwi, metha naca jei tsipae: ‘¿Eta xua metha nexata jopa pajume cowʉntsim Juan?’ metha naca jei tsipae Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Icha jei tsipaetsi Juan cui itorobatsi jiwi, metha apara jiwi naca jutebina ibotoxitha, tsipei daxita barapo jiwi nanta xeina xua Juan pon Nacom peitorobi jume pepaebin”, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Barapomonae Jesús jume notatsi, jeye: —Canta jopa payaputaeinyo xua pon Juan cui itorobatsi xua jiwi pebautisabiwatsi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nexata Jesús barai barapomonae, jeye: —Nexata barichin tsane. Jopa yabara paca tsipaebi tsainchi, po peitorobi coyeneyatha exanan xua daxita taexanaewan, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nexata Jesús diwesi tsipaeba jiwitha po diwesi pecayabara jʉta pepaebi diwesiyo. Jesús jeye: “Matha irʉ pebin pin uva pabi xeina. Bapon ʉba po ʉnbo pewʉn uva cuei ʉnbo. Bapoxonae bapon itoroba pomonae pia uva pabi petayapucaenaewichi tsainchi, xua bapoxonae barapomonae pejiwanaxaenexa pocotsiwa penawetsiwa. Bapoxonae bapon icha nacua beya pona ainya wei nexa. ");
INSERT INTO cui_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Matacabi tsuxubi xua uva cuei naweta. Bapoxonae barapo mataqueitha pomonae pabi petayapucaenaewi jiwana itapeta nota xua penawetsiwa. Bapoxonae pon uva pabi pexeinaein, caein jiwana itoroba pomonae pia petanacuichiwichi jiwana, xua petawʉcaenexa tsainchi uva cuei pomonae beya pomonae pabi petayapucaenaewichi. Ichitha barapon pon najume caitorobatsi, bapon bʉtsi. Bapon caibe cobesa iya. ");
INSERT INTO cui_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pon uva pabi pexeinaein bapon equeicha caein jiwana itoroba pomonae pia petanacuichiwichi jiwana. Bapon barichi bichocono bʉtsi, caibe cobesa nawiya yawa jopa catichi. ");
INSERT INTO cui_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pon uva pabi pexeinaein equeicha caein jiwana itoroba pomonae pia petanacuichiwichi jiwana. Barichi pomonae pabi petayapucaenaewi barapon bʉtsi yawa wan exanatsi yawa pabi weya xotsi. ");
INSERT INTO cui_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Pon uva pabi pexeinaein matapainya nanta xeina najei: ‘¿Eta xua metha exanaein? Metha taxanto itorobin pon bichocono antobein. Metha poxonae taxanto taeinchi, metha inta yabara barʉ cui itura jinaeinchi’, najei. ");
INSERT INTO cui_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Dapo jumetha pomonae uva pabi petayapucaenaewi poxonae bapon taeinchi, barapo petayapucaenaewi uva pabi najei tsane: ‘Apara bapon paxa copiniwa pichina. Daxota bapon bʉ bexotsi xua xainya xeinatsi barapo uva pabi’, najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Barapo pexanto tatsi uva pabi juma bemaxʉ cayiyatsi. Baxotiya bexotsi”, jei Jesús. Nexata Jesús barai barapomonae, pomonae jume tayenatsi Jesús, jeye: “Pon uva pabi pexeinaein, ¿eta be cana ichi tsane pomonaetha pomonae barapo uva pabi pia petayapucaenaewichi? ");
INSERT INTO cui_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pon uva pabi pexeinaein patopaena pia uva pabitha, pomonae uva pabi peyapucaenaewi daxita barapomonae jutebinchi. Barapoxonae barapo uva pabi ichamonae xuya catinchi xua petayapucaenaenexa tsainchi barapo uva pabi”, jei Jesús. Pomonae Jesús jume tayenatsi poxonae baxua jume tane xua Jesús paeba, barapomonae Jesús jume itawetatsi, jeye: —¡Bara, jopa bepajume taeinyo baxua, tsipei xua paebame Nacom jopa copatsiyo pata xantha xua pata tanejutebinexa ichamonae! jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ichitha Jesús tane, barapomonae tainchi. Jesús jeye: —Incane pajume taema pocotsiwa Nacom Pejume Diwesitha neyabara caunuta poxonae iboto yabara paeba, jeye: ‘Pebiwi pomonae ibo bon peacabiwi, barapo pebiwi xuba po iboto tabʉ caboca, po iboto peainya cui iboto. Ichitha Nacom itapeta barapo iboto xua petabʉ cabocaenexa peainya cui ibotoxae’, jei Nacom Pejume Diwesitha. ");
INSERT INTO cui_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Incane iboto yabara paca tsipaebinchi. Barapo ibototha poxonae ichauyo jopeica pepʉrʉwixi tsanaya. Mataʉtano poxonae barapo iboto ichauyo matatsun jopeicatsi pebeno tsanaya. Icha barapo iboto ichi poxonae cana exana ichauxitha peainya cui ibotoxae, xan barapocotsi jʉta coyeneya barichin pomonaetha pomonae jopa tana nejume cowʉntsiwi. Pia jopa tana neyaputaexae barapomonae daxota peraxa exanaeinchi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sacerdotemonae pia pentacaponaewi tatsi, irʉ pomonae jiwi pecuidubiwi xua Moisés pia peitorobi coyenewa tatsi, daxita barapomonae juntucuru Jesús teicatsi poxoru barapomonae yaputane xua yabara paebatsi xua Jesús paeba. Nexata Jesús jopa teicaetsi poxoru jiwi cunuwatsi. ");
INSERT INTO cui_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Barapomonae itoroba, ichamonae itorobatsi xua petataenexa tsainchi. Pomonae xua itorobatsi, barapomonae naexana itara mexeya pentʉ cui xanepanaewi. Barapomonae pona Jesús beya, xua Jesús naerabiya pecui jume yopichinexa tsainchi xua exana yawa xua paeba. Pia bapoxonae Jesús waetabichi yawa pia caponaetsi pontha pon Judea nacuapiwi peyanacua ewatsinchi. Bapon peajumeyapusʉ itorobiwa xeina, xua po peajumeyapusʉ itorobiwa cata pon romanomonae itorobiya pia pepa peewatsinchi. ");
INSERT INTO cui_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Daxota barapomonae Jesús yainyabatsi jeye: —Pon jiwi Necuidubim. Bara payaputan xua bara jume xainyeya tsipaebame jiwi, mataʉtano xua jiwi bara beta cuidubame xua pocotsiwa jiwi bewa exanaena pexeinaenexa tsane Nacomtha po jʉntʉ coyene pexanepanae jʉntʉ coyene. Mataʉtano jopa jiwi cunuwim poxonae cuidubame poxonae bequein jiwi jopa ichichipaeyo baxua, tsipei xam daxita jiwi catsita najʉpa. ");
INSERT INTO cui_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Incane yabara pana netsipaebare xuaje: ¿Metha bara Nacom pia peitorobi coyene naca itoroba xua waxainchi paratixi catsibinchi pon romanomonae itorobiya pia pepa peewatsinchi xua wanaca itorobixae bapon bequein bara pon penanapainchi poponaein? Icha jopa tsipae, ¿metha daxua abe tsipae? jeichichi Jesús barapomonae pomonae fariseomonae itoroba. ");
INSERT INTO cui_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ichitha Jesús yaputane xua piraichi baxua yainyabatsi. ");
INSERT INTO cui_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Daxota jeye: —Incane moya painta xawena paratiyo, tha taetsi. ¿Jintam pejumopere? ¿Yawano jintam wʉn ducuare? jei Jesús. Barapomonae jume nota, jeye: —Apara romanomonae itorobiya pia pepa peewatsinchi, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nexata Jesús barai barapomonae, jeye: —Bara nexata romanomonae itorobiya pia pepa peewatsinchi pacare pocotsiwa xua bapon piawaxae. Mataʉtano Nacom pacare xua baxua irʉ piawaxae tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Barapomonae jopa itacʉpaetsi xua Jesús pewaetabiwatsi daxita jiwi peitʉtha, tsipei Jesús beta jume nota barapomonae. Barapomonae yabara najʉntʉ cui coyene cabenaeca pocotsiwa xua Jesús xanepanaya beta jume nota, daxota barapomonae saya moya umena. ");
INSERT INTO cui_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bapoxonae saduceomonae jiwana pata Jesús pia xantha tatsi xua Jesús piraichi petsipaebinexatsi. Saduceomonae barompaya pia pecuidubi coyenewa xeina xua pinae pomonae pewerapeibiwi equeicha jopa asʉ tsaibiyo. Barapo pecuidubiwa jopa jʉpaeyo po pecuidubiwa Jesús pia pecuidubiwa tatsi xua pinae jiwi equeicha asʉ jinompaena poxonae werapa. Daxota saduceomonae Jesús siwa poinchi. Saduceomonae Jesús baraichi: ");
INSERT INTO cui_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Pon jiwi Necuidubim. Moisés nacata tina, namchi: ‘Icha pebin piowa cuenta tʉpa, yawa jopa xeinaeyo pexui, xuyapin bewa pentapin pecoutha coseuri pichina xua bapoxonae pentapin pecoutha pexeinaenexa tsane pexui’, jei Moisés. ");
INSERT INTO cui_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Barichi, matha irʉ cae peweicho jiwi xua caepiwi nabarʉ jinompa siete poyobe. Matapin jitha eca. Bapon piowa cuenta naxuba. Pexui jopa xeinaeyo. ");
INSERT INTO cui_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pon cotacaya naexana xuya pentapin coseuri pita xua bapoxonae pentapin pecoutha pexeinaenexa pexui. Bapon irʉ cuenta tʉpa, irʉ jopa xeinaeyo pexui. ");
INSERT INTO cui_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Bapoxonae ichʉn xuyapin xuya barapowa pita xua pentapin coseuri pita. Bapon barichi irʉ cuenta tʉpa, irʉ pexui jopa xeinaeyo. Daxita barapo siete poyobe cuenta nanapentapona barapowa poxonae bequein xuya pecoutha nonotaponeiba. Barapo siete poyobe, caein jiwana jopa pecoutha tapoponaetsi pexuyo. ");
INSERT INTO cui_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Bapoxonae matapainya irʉ barapowa tʉpa. ");
INSERT INTO cui_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Xam, Jesús, ba paebame, ba jam: ‘Matacabi jopaena po matacabitha Nacom asʉ exanaena xua jiwi asʉ exanaeinchi mʉthʉ wetsina’, ba jam. Poxonae barapo matacabi jopaena xua daxita jiwi asʉ jujuinaena, barapo matacabitha, ¿jintam metha barapowa xuya pichinchi, xua ichʉn pichina, xua barapo siete poyobe caein jiwana? Tsipei caena bayatha barapo siete poyobe caepiwi cuenta nanapentapona barapowa, jei saduceomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nexata saduceomonae, Jesús jume nota. Jesús jeye: —Barapo nacuathe pebiwi yawa yabʉxi, barapomonae jitha eenapona. ");
INSERT INTO cui_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pomonae xua Nacom itapeta waba, poxonae barapomonae patsina Nacom pia nacuatha, barapomonae jopa equeicha jitha eenaponae tsane, yawa jopa pexantixi jitha cuarebaponae tsane. ");
INSERT INTO cui_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tsipei barapo nacuatheicha, barapomonae bexa jopa werapae tsane icha matatsunpiwi ichi xua jopa werapaeyo. Mataʉta barapomonae Nacom pia pexui, tsipei barapomonae equeicha asʉ barapo petʉpae coyene weya. ");
INSERT INTO cui_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Caena bayatha Moisés yabara naca cuiduba xua pomonae pewerapeibiwi xua equeicha asʉ tsaibi tsane, po diwesitha naewa yabara tina po naewa taxuncua. Barapo diwesitha Nacom pon Pecanamataxeinaein jiwi, namchi: ‘Xan Abraham pia Nacomʉn tatsin, irʉ Isaac pia Nacomʉn tatsin, irʉ Jacob pia Nacomʉn tatsin’, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Baxua Nacom paeba tsipei Abraham irʉ Isaac, irʉ Jacob pomonae bayatha pewerapaewi anoxuae equeicha caewa asʉ jinompa Nacom pia nacuatheicha tatsi. Pomonae pewerapaewi pomonae jopa caewa equeicha asʉ pejinompaewi, barapomonae jopa pia Nacom tatsi, pon itabocotha eca. Saya jame meisa pomonae bayatha pewerapaewi caewa equeicha asʉ pejinompaewi pomonae pejume cowʉntsiwixaetsi Nacom, barapomonae jame pia Nacom tatsi, pon itabocotha eca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Nexata pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, barapomonae jiwanamonae Jesús baraichi, jeye: —Pon jiwi Necuidubim, maisa bara beta xanepanaya paebame, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Saduceomonae equeicha jopa Jesús yainyabichi xua equeicha beta pejume notsiwatsiyainwa. ");
INSERT INTO cui_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Equeicha Jesús nayabara paeba pomonaetha pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Jesús jeye: —¿Eta pocotsiwa metha jiwi paeba xua pinae Mesías bapon David pia pemomoxi susato jiwanapin tatsi? ");
INSERT INTO cui_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Tsipei David jei salmos penaxʉnae weixi diwesintha: ‘Nacom pon Pecanamataxeinaein jiwi Tanecanamataxeinaein baraichi pon Mesías jeichichi: Tacoxa werena ecare, beya abʉ tsane poxonae necaaitafaetabi jiwi pia Pecanamataxeinaeinchi tatsi caexanaeinchi, jei Nacom’, jei David salmos penaxʉnae weixi diwesintha. ");
INSERT INTO cui_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Icha David yabara jei xua Mesías yabara jeichi: Bapon Mesías Tanecanamataxeinaein, jei, ¿eta xua metha tsipae xua Mesías apara David pia pemomoxi susato jiwanapin tatsi? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pomonae xua umena daxita barapomonae Jesús jume taeumeinchi poxonae Jesús pijimonae tsipaeba. Jesús namchi, jeye: ");
INSERT INTO cui_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Dota pam, dota pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Barapomonae pia pecuidubi coyenewan tatsi pecuiyainwa pande. Jopa paexanaeinde icha barapomonae ichi xua barapomonae bichocono ichichipa xua penama xatabiwa po paparuwan apipiya deca xua be pomonae peainya cui jiwi penaexanaewi naexana. Barapomonae bichocono ichichipa xua jiwi namtotha jacobeibina xua barapomonae pejacobinexatsi xua jiwi pebarʉ cui itura jineibinexa barapomonae xua barapomonae pebarʉ cui itura jineibinexatsi. Barapomonae bichocono ichichipa xua nanta caeneiba judiomonae pia penacaetutsi bontha tatsi ichaxota ba enathopeiba pomonae peainya cui jiwi penaexanaewi. Mataʉta barapomonae bichocono ichichipa xua eneiba ichaxota ba eneiba pomonae peainya cui jiwimonae poxonae pexaewan tsinacaetuteiba xua poxonae penabaneibinexa tsane. ");
INSERT INTO cui_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mataʉtano barapomonae powaxi pecuenta werapaewaxichi piseurixi, barapowaxi cueranta enatsi pia bon. Barapomonae naemata jopa cuinaya najume copababeibiyo poxonae tsipaebeiba Nacom. Barapomonae bichocono peraxa jʉbebinchi poxonae po mataqueitha Nacom yabara paebina jiwi xua pia penatsicuentsiwa xua abe petsita exanaexaetsi. Barapomonae bichocono atene tsane xua poxonae beyacaincha ichamonae atene exanaeinchi xua jopa pejume cowʉntsixaetsi Nacom”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nacom pin pia botha Jesús tane xua baxota pomonae copei xeinaewi paratixi jeya Nacom nexa ichaxota jiwi jebeiba paratixi. ");
INSERT INTO cui_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Barichi Jesús tane xua irʉ ainya tsica paratiyobe jeca baxota powa pecuenta tʉpaewatsi piseuri, yawa bapowa peacopeibiwayo. ");
INSERT INTO cui_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús jeye: —Bara xaniyeya paca tsipaebatsi. Barapo yabʉyo powa pecuenta tʉpaewatsi piseuri, barapowa peacopeibiwayo. Daichitha barapowa jeca ainya paratiyobe Nacom nexa. Bapowa cata beyacaincha ichamonae daxita pomonae nawita jeya xua Nacom nexa. ");
INSERT INTO cui_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Daxita barapomonae jeya pocotsiwa tanacopabeibatsi. Ichitha nama bapowa bichocono peantobexae Nacom daxota omeicha jeca po paratiyobe bequein canantawenona xua pexaewa tsane, bequein bichocono peacopeibiwayo, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ichamonae yabara natsipaeba nawita Nacom pin pia bo tatsi. Barapomonae najei: “¡Maisa Nacom pin pia bo tatsi bepa wʉnae! ¡Maisa bepa wʉnae xua jiwi tutu pepena peitʉpanaewan barapo Nacom pin pia botha xua Nacom nexa!” jei barapomonae. Nexata Jesús jeye: ");
INSERT INTO cui_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Matacabi jopaena po mataqueitha tsane ichamonae pomonae penanapaincha jinompaewi pomonae xua icha nacua werena peponaewi abe exanaena Nacom pin pia bo tatsi, xuaunxuae pataneme po bo. Jopa cae ibotiyo nacopatuncuae tsane icha iboto peʉmatha, daxita abe tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nexata jiwi Jesús yainyabatsi, jeye: —Pon jiwi pata Pecuidubim, ¿eta poxonae metha ichamonae baxua exanaena poxonae abe cana exanaena Nacom pin pia bo tatsi? ¿Eta pocotsiwa tsane xua pewʉnaeya tsita itapeinya xeinaena po coyene xua poxonae imoxoyo daxita weraweracaenaba? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús jume barai: “Dota pam bʉ ichamonae naerabiya paca muxu tsipaeba xua daxota abe paexanaetsipame. Tsipei tsane patsina ayei bicheito jiwi pomonae natsicotaena icha be xan ichin. Barapomonae jei tsane: ‘Apara xan, Mesías’, jei tsane. Ichʉn jei tsane: ‘Anoxuae Mesías patopaena’, jei tsane. Ichitha paxam jopa payabara jume cowʉntsinde pocotsiwa xua barapomonae paeba. ");
INSERT INTO cui_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pajume taename xua jiwi juinya nabenoutsina xote, yawa xua juinya irʉrʉ nabenoutsina icha ira beya. Daichitha jopa pajunuwinde, tsipei baxua pewʉnaeya matha copiya tsane. Daichitha cataunxuae dapo matacabi aichica tsane xua poxonae daxita weraweracaenaba yatsicaewa”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Equeicha Jesús namchi: “Cae nacuapiwi irʉ icha nacuapiwino barapo ainya nacuapiwibe nabenoutsina. Mataʉtano irʉ pon nacua peewatsin irʉ ichʉndʉ pon icha nacua peewatsin baponbe irʉ nantiya nabenabe. ");
INSERT INTO cui_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mataʉtano ainya nacuantha ira jijiyatsina. Mataʉtano ainya nacuantha jainbo nacua tsane, tsipei pin mayayo tsane. Mataʉtano domae tsurucuae tsane ainya nacuantha. Mataʉtano Nacom peitabocotha peitʉpanaewan itʉtsina, xua jiwi bichocono cunuwa. ");
INSERT INTO cui_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Poxonae baxua pewʉnaeya tsane jiwi paca teiquebina, paca atene exanaena. Judiomonae pia penacaetutsi botha paca caponaena painya paca yabara paebinexa painya nenatsicuentsiwa xua abe painya neexanaexae. Yawa paca caponaena jiwi pecʉbi botha. Paca caponaenano nacua peewatsiwi peitabaratha tatsi, painya tana nejume cowʉntsixaemxae. Yawano paca caponaena pentacaponaewi peitabaratha tatsi, pomonae irʉ itoroba jiwitha xua pon nacua peewatsin nexa painya tana nejume cowʉntsixaemxae. ");
INSERT INTO cui_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Barapoxonae paca cui itacʉpaena xua barapomonaetha tapana neyabara paebiwam pocotsiwa bayatha paca tsita exanatsi. ");
INSERT INTO cui_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pananta xeinare painya jʉntʉ coyenetha, pana najande: ‘Jopa tsiwanaya yabara nacui wʉnaetsi tsainchi xua ichamonae watsipaebiwatsi xua abe wanaca yabara paebiwa’, pana najande. ");
INSERT INTO cui_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tsipei xan paca tsimuxu dutinchi po jume xua pacaunutsiname, xua po jumetha beta paca yaputane exanaena. Barapo jume pacata exanatsi xua painya paca necaaitafaetabi jiwi jopa paca jume matanonopentsi tsane, xuano xua jopa peitacʉpaenexa tsainchi xua abe painya nepaca yabara paebiwa. ");
INSERT INTO cui_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Paca caenaetsina ichamonae icha jiwitha pomonaetha pomonae jiwi pecanamataxeinaewi. Irʉ painya axeiwi yawa painya ena jiwi paca caenaetsina ichamonaetha. Irʉ painya eweicho jiwi paca caenaetsina ichamonaetha. Irʉ painya amoyo jiwi paca caenaetsina ichamonaetha. Irʉ painya jiwimonae paca caenaetsina ichamonaetha. Barichi ichamonae pomonae paxam jiwana pam jutebinchi. ");
INSERT INTO cui_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Daxita nacuanpiwi paca casebina, painya tana nejume cowʉntsixaemxae. ");
INSERT INTO cui_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ichitha Nacom paca capanenebiyaena painya nejʉntʉ coyenein panenebiyaenexa. ");
INSERT INTO cui_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Awiya paantʉyapusʉya nejume cowʉntsiya jinompare poxonae bequein ichamonae abe pacata exana xua beya payacuiya werapaeya othopaename xua painya xeinaewa tsane peajʉntʉyapusʉwa po peajʉntʉyapusʉwa ataya tsiteca. ");
INSERT INTO cui_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Poxonae pataename xua soldadomonae xua icha nacuapiwi yacaincha matawacaicha yatoxoroto naexanaxubina Jerusalén tomara bapoxonae payaputaename xua barapo tomara bara imoxoyo abe exanaeinchi. ");
INSERT INTO cui_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Barapo mataqueitha, daxita pomonae Judea nacuatha jinompa barapomonae bewa demxuwan berʉcʉpiyaena. Irʉ pomonae Jerusalén tomarapiwi, barapomonae bewa bara berʉcʉpiyaena. Irʉ pomonae pabitha jinompa, barapomonae jopa bewa dʉcʉpaetsipae tomara beya. ");
INSERT INTO cui_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsipei barapo matacabintha Nacom cui itorobina, ichamonae cui itorobinchi, xua jiwi peraxa exanaeinchi, icha be po coyeneya Nacom Pejume Diwesitha yabara paeba baxua. ");
INSERT INTO cui_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Pai yabʉxi tsobenae powaxi pexui bʉpana taenatsi barapo matacabitha! ¡Pai powaxi irʉ pexui isaina, barapowaxi tsobenaerʉ! Tsipei acabe tsobenae tsane pexui. Mataʉtano Nacom cui itorobina barapo nacuathe, ichamonae cui itorobinchi xua barapo nacuathepiwi pin peperaxa jʉbiwatsi tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ichamonae cusitha jutebinchi. Ichamonae yamaxʉ cʉbiya caponaeinchi icha nacuan beya. Barapo Jerusalén tomaratha pomonae penanapaincha jinompaewi xua icha nacua werena peponaewi dubenanaebiyaena beya barapo matacabi yacobe cui othopaena, po matacabitha xua Nacom cobe matawentsina xua equeicha jopa enae tsane barapo tomaratha barapomonae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Equeicha Jesús jeye: “Bapoxonae xometotha naitʉtsina peitʉpanaewa, yawa jomocoichatotha, yawa opiteitontha. Barapo irathe daxita nacuanpiwi yabara najʉntʉ coyene cabenaenoutsina. Mataʉtano busi taena pin maratsacan busi xua busi jopa xainya mene ducuaeyo. Bichocono jiwi najuinyacaena. ");
INSERT INTO cui_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jiwi pijunuwi muxu pewerapae tsane poxonae nanta xeinaena po coyene Nacom exanaena barapo cae pin nacuathe. Mataʉta junuwina xua exanaena itabocotha poxonae Nacom napuna torobabiyaena xua xuan itabocotha dubena. Bapoxonae jopa xapain dubenanaeyo tsane. ");
INSERT INTO cui_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bapoxonae jiwi netaena ponxaein Nacom Tananeitapetsin xua tsaquinaebowatha patopeicaein. Nacom pia peayapusʉwa itorobi coyenewatha, mataʉtano bichocono pexeinya itʉpanae coichatha yawa patopeicaein. ");
INSERT INTO cui_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Poxonae baxuan juntucuru exanaenaba, panantʉsʉbarʉcʉpare, athabe panecotumeinyama, tsipei bara imoxoyo paca necapanenebiwa tsane”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nexata Jesús pijimonae tsipaeba pecayabara jʉta pepaebi diwesiyo xua higuera nae, jeye: “Pataema nae po nae pewʉn higuera nae, xuano ichacuitha icha naeinno xua pataneme xua pena noxu xuxuwa pona. Nexata bapoxonae payaputaema xua imoxoyo wei tsurucuae tsoponae. ");
INSERT INTO cui_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nexata barapocotsi jʉta coyeneya icha tsane xuaunxuae paca tsipaebatsi xua poxonae jiwi muxu pijunuwi pewerapae tsane. Bapoxonae payaputaename xua bara imoxoyo tsane poxonae xua tapatopae wʉnae tsane poxonae jiwi itorobiya ewatsin. ");
INSERT INTO cui_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Bara xaniyeya paca tsipaebatsi daxita judiomonae naitapataya naexanaponaena beya yacui othopaena poxonae Nacom exanaena daxita baxuan pocotsiwa xuaunxuae paca tsipaebatsi. Bapoxonae barapo judiomonae weraweracaena. ");
INSERT INTO cui_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Peitaboco aichurucuae tsane, mataʉta ira aichurucuae tsane. Meisa nama tajumein ataya tsitecaena xua daxota daxita nayabara jume wetsina be pocotsi coyeneya bayatha paeban. ");
INSERT INTO cui_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Dota pam, pana neyabara cananta xeinaeya jinompare. Painya xoba pana najʉntʉ coyene ararana exaname xua pana nasi cui matacaetame yabʉxitha xuano xua pana nacʉpa exaname peatsaxae meratha, yawano xua saya i pananta xeiname xua panantawenoname xua saya paxam nexa. Bapoxonae barapo matacabi xain jopa paca benaecae tsane poxonae jopaena. ");
INSERT INTO cui_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tsipei barapo matacabi jemeicha jopaena, icha be pocotsi jʉta coyeneya ichi poxonae duwein jemeicha aʉtabatsi mayatha. Barapo matacabi jopaena daxita barapo cae pin nacuathe yajiwi canaʉpaxuinchi. ");
INSERT INTO cui_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tsaca pajinompeibare xua tapatopae wʉnae tsane. Matowa patsipaeba dubenanaebiyama Nacom. Patsipaebeibare xua Nacom paca capanenebiya exanaena baxua weya xua poxonae Nacom cana exanaena ichamonaetha xuaunxuae paca tsipaebatsi. Barichi patsipaebeibareno xua painya nepaca itacʉpaewa tsane xua painya neumenaewa taitabaratha ponxaein Nacom Tananeitapetsin”, jei Jesús pijimonaetha. ");
INSERT INTO cui_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Daxita matacabi Jesús cuidubeiba jiwi Nacom pin pia botha Jerusalén tomaratha. Merawitha tsaibi demxuwa beya poneiba xua baxotiya peecaenexa tsaibi tsane, po demxuwa pewʉn Olivos. ");
INSERT INTO cui_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Daxita matacabi jiwi caemʉmbotha tsaibi pateiba Nacom pin pia botha xua Jesús pejume taenexa tsaibi tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Bara nama imoxoyo matacabi jopa po matacabitha xua jiwi nacaetuta pexaenexa pan xua jopa cotowiyo. Barapo matacabi pewʉn Pascua matacabi wʉn. Barapo Pascua matacabi wʉntha jiwi yabara nanta xeina po matacabi poxonae caena bayatha matha judiomonae Egipto nacua weya panenebiya. ");
INSERT INTO cui_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Sacerdotemonae pia pentacaponaewi tatsi, irʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi, daxita barapomonae nabarʉ muxu jei xua bepa pinae eta bichi tsane poxonae Jesús waetabinchi pebexubinexatsi. Cataunxuae jopa exanaeyo, canta jiwi cunuwatsi. ");
INSERT INTO cui_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bapon Judas caein jiwana pomonae doce poyobe pomonae Jesús pijimonaexae tatsi. Judas icha wʉn xeina, po wʉn “Iscariote”, baraichi. Nexata bapoxonae Satanás caurimonae pia pentacaponaein tatsi, Judas imoxoyo peinya caquita uncuatabatsi peitorobinexatsi xua abe peexanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas siwa pona sacerdotemonae pia pentacaponaewi tatsi, irʉ policiamonae xua pebarʉ cueicueijeinexa tsane. Barapomonae policiamonae pentacaponaewi, xua pomonae peyabara umenaewi Nacom pin pia bo tatsi. Daxita barapomonaetha Judas tsipaeba xua pocotsi coyeneya poxonae Jesús caenaetinchi barapomonaetha. ");
INSERT INTO cui_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Barapomonae bichocono ichichiparʉcʉpa baxua. Yawa barapomonae Judas muxu tsipaebatsi xua paratixi catsibapaebatsi. ");
INSERT INTO cui_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas bara yabara jejei xua barapomonae paeba. Bapoxonae Judas tamropata pitaba xua jeita xua po coyenetha Jesús pecaenaetaxubiwa tsainchi barapomonaetha poxonae peyapu xanepanaewatha poxonae jiwaibi tsʉrʉcʉpae. ");
INSERT INTO cui_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nama matacabi jopaba po matacabitha poxonae jiwi tsinacaetutsina xua penabanaenexa pan po pan jopa muxuna pentsiyo levadura matawʉn pocotsiwa xua cotowa exana pan. Barapo penantacarucuae matacabitha ba corderoxi pebtoxi xua oveja coxi jutebatsi xua jiwi pexaenexa. ");
INSERT INTO cui_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pedro irʉ Juan itorobatsibe, Jesús itoroba. Jesús barai, jeye: —Paponarebe panacui wʉnaerebe pexaewa Pascua wʉn matacabi nexa waxaenexa tsainchi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Baponbe, Pedro irʉ Juan, Jesús yainyabatsibe. Jeibe: —¿Exota ichichipame xua xota pexaewa paca tsiwʉnaetsinchi wanabanaenexa tsane xua Pascua wʉn matacabi nexa? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús jume nota. Jeye: —Poxonae tomaratha papatopaenamebe, pataenamebe pebin. Barapo pebin juruwatotha yantana ponaena mera. Bapon papuna ponarebe bo beya ichaxota bapon joniyaena. ");
INSERT INTO cui_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pon bo pexeinaein pabarande: ‘Pon jiwi Pecuidubin cabarai: ¿Incane tutura, po tututha tajiwimonae barʉ xaein Pascua wʉn matacabi nexa? jeye Pecuidubin’, pajandebe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Equeicha Jesús jeye: —Bapoxonae pon bo pexeinaein paca tsita ita cayopichinabe po tutu pin tutu. Barapo tutu, po tutu xua asiyeicha, barapo tutu bayatha xaneba. Barapo tututha pexaewa panacui wʉnaetajebare xua wanabanaenexa pexaewa barapo Pascua wʉn matacabi nexa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Barapoyobe ponabe, penamchixae daxita tanebe be pocotsi coyeneya Jesús bayatha paeba. Bapoxonae pexaewa nacui wʉnaetajebabe Pascua wʉn matacabi nexa xua penabanaenexa. ");
INSERT INTO cui_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Poxonae barapo hora tsuxubi poxonae quirei tsanaicha, Jesús barʉ ecoundeca pexaethopaewatha pijimonae pomonae doce poyobe pomonae pia peitorobiwixae tatsi Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nexata Jesús barai, jeye: —Maisa bichocono jʉntʉ coyene weiweinan xua tapaca cabarʉ nacaetutsiwatsi, yawa tapaca cabarʉ nabanaewatsi barapo Pascua wʉn nabanae matacabithe, xua baxua matha pewʉnaeye tsane xua poxonae tatʉpaewa tsane. ");
INSERT INTO cui_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Daxota paca tsipaebatsi xua equeicha jopa tapaca barʉ nacaetutsiwatsi tsainchi xua wanabanaewa tsane Pascua wʉn matacabitha. Equeicha exanaeinchi barapo penabanaewa po mataqueitha poxonae Nacom neexanaena xua jiwi itorobiya ewatsin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nexata Jesús pecobetha pita corotiyo, Nacomtha tsipaeba, jeye: —Axa, maisa jʉntʉ coyene weiweinan xua corotiyotha ecareca pepa uva mera xua pata tanecatsiwam, jei. Yawa barai pijimonae, jeye: —Barapo corotiye pana nacobe wenonotaponde tamropata tsiwixi pa-aapaponde. ");
INSERT INTO cui_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Daxota paca tsipaebatsi barapo uva mera jopa equeicha paca barʉ apae tsainchi anoxuae. Meisa abʉ bexa tsane pena coyenewatha paca barʉ apaeinchi barapo uva mera poxonae Nacom neexanaena xua jiwi itorobiya ewatsin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesús pecobetha pita pan, Nacomtha tsipaeba, jeye: —Axa, maisa jʉntʉ coyene weiweinan xua pan pata tanecatsiwam, jei. Bapoxonae Jesús pecobetha epa janaca pan, yawa catsiba pijimonae. Pijimonae barai, jeye: —Paxaema po pan epa janacan. Barapo pan apara neyabara caunuta tapepon xua poxonae tapaca tsitʉpaewatsi tsainchi. Baxua paexaneibare bapocotsiwa xuaunxuae pan paca barʉ xainchi. Barapo coyene paexaneibare painya tana neyabara jʉntanaineibinexa tsaibi tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Poxonae Jesusbarʉ najain weta, barapoxonae Jesús yabara paeba corotiyo, icha ichi xua yabara paeba pan. Jesús jeye: —Nacom exana pena pecapanenebiyae coyene jiwi nexa. Barapo pecaapaewiyotha uva mera paapame, xuaunxuae paapame, apara natsicotane be tajana xua tatʉpaein jana jopeicaein. Barapo pejanatha paca jʉntʉ coyene cui capanepaeinchi abe painya neexanae cuiru coyenein weya. ");
INSERT INTO cui_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pebin taxantha necacuita namaxʉ yʉtabota pexaethopaewatha, barapo pebin necaenaetsina ichamonaetha xua tanebexubinexa tsane ichamonae. ");
INSERT INTO cui_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Xan ponxaein Nacom Tananeitapetsin bewa tʉpaein, tsipei Nacom Pejume Diwesitha baxua neyabara paeba caena bayatha. Ichitha pebin tsocuae pon necaenaetaxubina ichamonaetha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nexata barapomonae caemonae nantiya nayainyaba, jeye: “¿Jintam metha caenaetatsi Jesús?” najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pirapaeyo Jesús pijimonae tatsi najume matsontsonoba xua barapoyobe caein ainya cui jiwana exanaeinchi pon xua barapo doce poyobe jiwana. ");
INSERT INTO cui_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Nexata Jesús jume barai: “Pomonae jopa judiomonae naexanaeyo, barapomonae ba nantaʉta piamonae pomonae nacua peewatsiwi. Barapomonae pomonae jiwi itorobiya pia pepa peewatsiwichi barompaya piamonaexae jopa juniya itorobeibiyo. Barapomonae pomonae jiwi itorobiya pia pepa peewatsiwichi baxua exana, xua daxita jiwi pia jeichi: ‘Maisa barapomonae pomonae jiwi itorobiya pia pepa peewatsiwichi wʉnae nacata exana xua naca itoroba’, pia jeichi jiwi. ");
INSERT INTO cui_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ichitha paxam jopa bewa paraichim tsane xua aebiya painya neitorobiwa tsane. Jame, icha cui bewa paxeinare. Pon ainya cui peexanaeinchi paxamtha xua beyacaincha ichamonae bapon bewa naexanaena be pon pecui pawi. Pon xua jiwi itorobeiba, bapon bewa naexanaena be pon amanaya tanacuita ichʉn nexa. ");
INSERT INTO cui_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Irʉ ainya pebinbe. Ichʉn pexaethopaewatha ecoundeca. Ichʉn pexaewa apata. Pon ecoundeca apatatsi. ¿Jintamda pon ainya cui peexanaeinchira xua beyacaincha ichʉn? Pon xua jiwi apata pexaewa bapon jopa ainya cui peexanaeinchi. Jame pon pententa apatinchi bapon jame pon peainya cui peexanaeinchi, xua beyacaincha ichʉn. Nama painya xantha ecan, xua tacoya nacana exanan be pon xua pexaewa jiwi taapatsin, pocotsin jopa ainya cuiyiyo. ");
INSERT INTO cui_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Paxam barapomonae pam, pomonae meisa pana nebarʉ jinompeibame poxonae bequein ichamonae inta abe exana. ");
INSERT INTO cui_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Daxota paca catatsi taitorobi coyenewan icha Taxa Nacom neichi xua necata barapo peitorobi coyenewan. ");
INSERT INTO cui_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Barapo peitorobi coyenewan paca catatsi, painya nenabarʉ nabanaenexa taitorobeibi nacuatheica. Paenaename pexeinya peitʉpanae enaewantha, painya neyabara paebinexa tsane pomonae doce po bicheito cuntiyobe, pomonae Israel pia pemomoxi susato jiwimonae tatsi xua penatsicuentsiwa abe pia peexanaexae”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Equeicha Jesús jeye: —Simón jan, caurimonae pia pentacaponaein tatsi, bapon Satanás newʉca: ‘Jinyamonaepin necare’, nejei. Bapon ichichipa xua abe cata exanaena xua taneitawetsinexam tsane. Icha jiwi ichi xua pebeno daunweya yasisita pexubinexa pesiberapewa. Barichi caurimonae pia pentacaponaein tatsi ichichipa cajʉntʉ coyene itorobina xua taneitawetsinexam tsane. ");
INSERT INTO cui_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ichitha xan Taxa beicha cata tsipaebatsi xua jopa tana neyabara jʉntemainaenexam tsane xua tana nejume cowʉntsiwam. Ichitha Satanás cacana exanaena xua tana nejumefebiwam saya bara caeto tsane. Bapoxonae equeicha caewa nejume cowʉntsiname. Poxonae equeicha caewa nejume cowʉntsiname, nexata ichamonae pomonae tana nejume cowʉntsiwi barapomonae yawenaename xua ajʉntʉyapusʉya tana nejume cowʉntsiwa tsane, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Jesús jume notatsi, jeye: —Tanecanamataxeinaem, maisa be cabarʉ poponaeinchi. Bara bequein ichamonae cacaponaena jiwi pecʉbi botha ichitha awiya capuna tʉpaeinchi. Mataʉta bequein tʉpaename ichitha awiya capuna tʉpaeinchi, jei Simón Pedro. ");
INSERT INTO cui_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús jume nota, jeye: —Pedro, catsipaebatsi bexa necaunutsiname acoibi po jume cuiyobe neyabara jam tsane: ‘Dapon jopa yaitaeinyo’, neyabara jam tsane. Barapoxonae irʉ tsane wacara pebto fibina, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nexata Jesús pijimonae yainyaba, jeye: —Poxonae bayatha paca itorobatsi paca jeichi: ‘Jopa paratixi doro pacaponaeinde, jopa cote pacaponaeinde, jopa panataxu xatabinde xua penataxu xatabiwa’, jan. ¿Eta xoyo pacata seica xua xoyo pacobena poname? jei Jesús. Barapomonae Jesús jume notatsi, jeye: —Ajibi, bara paxeinan pocotsiwa panantawenonan, jei. ");
INSERT INTO cui_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nexata Jesús jume nota. Barapomonae jume notatsi. Namchi: —Anoxuae paca tsipaebatsi xua icha cui coyeneya. Pon cote xeina, moya bewa caponae. Pon xeina paratixi doro, moya bewa caponae. Pon peaitiyʉ camisa xeina, bapon bewa caenaetsina barapo camisa, barapo paratixitha bewa comotsina cusi. ");
INSERT INTO cui_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Poxoru paca tsipaebatsi caena bayatha Nacom Pejume Diwesitha neyabara paeba, jeye: ‘Bapon cayabara cananta xeinaeinchi jei tsane bapon jiwana caein pomonae peabewi’, jei Nacom Pejume Diwesitha xua pinae jiwi jei tsane. Jiwi nantawenona xua baxua neyabara caunutsina xua Nacom peneyabara jumichixae baxuan pejume diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Barapomonae Jesús jume notatsi. Jeye: —Patatanecanamataxeinaem, xote bayatha paxeinan ainya watobe cusi, jei. Jesús jume nota, jeye: —Bara, bare, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nexata Jesús tomara weya pona. Bapon pona demxuwa beya po demxuwa pewʉn demxu Olivowa, olivo naein peumenaexae baxota poxoru pia cui xua poneiba baxota petsipaebeibinexa Paxa. Jesús pijimonae puna poinchi. ");
INSERT INTO cui_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Poxonae barapo demxuwatha patopa, Jesús pijimonae barai: —Nacom patsipaebare xua jopa abe painya neexanaewa tsane xua caurimonae paca itoroba. ");
INSERT INTO cui_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nexata Jesús pijimonae tsiwiyo wepu natsixitaba. Saya jopa tajʉyo. Be poxonae pebin ibotiyo xoya xua be pocotsiwatha naruntabiya jopeica. Jesús pentabocototha ecoundeca. Paxa tsipaeba. ");
INSERT INTO cui_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jesús namchi: “Axa, icha ichichipame xua tana neyawenaewam, inta pire xua ajʉntʉcoyenerewe neexana. Ichitha jopa neexanaeinde be pocotsi coyeneya ichichipan. Saya jame necana exande be pocotsi coyeneya ichichipame”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bapoxonae Jesús tsita naitʉtatsi matatsunpin pon itaboco wetsica pona. Barapo matatsunpin Jesús antʉsʉya cana exanatsi poxonae yawenatsi. ");
INSERT INTO cui_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Bichocono Jesús ajʉntʉtane tsipei Paxa copatatsi xua jiwi petsitʉpaewa tsainchi. Paxa beya bichocono matowa jume daunweya tsipaeba. Yawano bichocono najaneta. Barapo penajanetsiwa poxonae iratha othopeica be pejana othothopeica. ");
INSERT INTO cui_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Poxonae najume wetaba xuano xua asiya uncuano bapoxonae pijimonae beya pona. Jesús tane pijimonae xua tamaitumeinchi. Barapomonae maita tsipei jʉntʉ cuerona xua wecoyei, xua Jesús yaitama petʉpapaebixae. ");
INSERT INTO cui_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nexata Jesús pijimonae barai, jeye: —¿Eta xua metha pamaitame? Panonobaponde Nacom patsipaebare xua jopa abe painya neexanaenexa tsane pocotsiwa caurimonae paca itoroba, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Cataunxuae abʉ Jesús pijimonae tsipaebuncua poxonaerʉ jiwi pin bicheito pata. Caein Jesús pijimonae tatsi jiwana, pon pewʉn Judas, pomonae xua doce poyobexae, bapon pin bicheito matacapona. Judas Jesús imoxoyo caquita uncuatabatsi xua Jesús petsutsubinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Nexata Judas baraichi, Jesús barai, jeye: —Xan ponxaein Nacom Tananeitapetsin, ¡Judas, jamaisa netsutsubame, apara metha jinya necaenaetichi ichamonaetha! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pomonae Jesús pijimonae tatsi caquita umeinchi, poxonae barapomonae baxua tane xua Judas Jesús tsutsubatsi xua pecaenaetsinexatsi ichamonaetha, bapoxonae barapomonae Jesús baraichi: —Pata Tanecanamataxeinaem, ¿barapomonae cusitha paucuboban? jei Jesús pijimonae tatsi. ");
INSERT INTO cui_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jesús pijimonae tatsi jiwana caein, bapon muxuyoro catsoniba, pon sacerdotemonae pia pepa pentacaponaein tatsi tanacuitatsi bapon muxuyoro catsonibatsi po muxuyoroto pecoxa werucuiya. ");
INSERT INTO cui_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ichitha Jesús barai bapon jeye: —Bara, bara, jei Jesús. Pon muxuyoro catsonibatsi Jesús muxuyoro jayaba pecobetha. Bapoxonae bapon equeicha muxuyoro ducuanaya. ");
INSERT INTO cui_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús tsipaeba, sacerdotemonae pia pentacaponaewi tatsi tsipaebatsi. Yawano tsipaebano pomonaetha pomonae penapataewi. Barichi tsipaebano pomonaetha pomonae Nacom pin pia bo peyapu enaewi. Daxita barapomonaetha Jesús cueicueijei, pomonae ichichipa xua Jesús pewaetabiwatsi. Jesús jeye: —¡Pacapatame cusin yawa iwabi, icha paichim poxonae pacana exaname pontha pon jiwi pecaibin! ");
INSERT INTO cui_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Poxonae daxita matacabi Nacom pin pia botha paca barʉ poponeibatsi, jopa pana newaetabim. Ichitha anoxuae barapo matacabi tsuxubi nama po matacabitha Nacom paca yabara cui copata xua painya neexanaewa tsane pocotsiwa paca necaitorobixae cauri, bapon Satanás pon peyaitaquireya jinaein. ");
INSERT INTO cui_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nexata daxita barapomonae Jesús teicatsi. Yawano capoinchino sacerdotemonae pia pepa pentacaponaein tatsi pia bo beya tatsi. Pedro, Jesús tsiwiyo tajʉ pu taetae tsiniyatsi. ");
INSERT INTO cui_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Baraxotiya sacerdotemonae pia pentacaponaein tatsi pia botha tatsi bara po botha aisowa beya panatha tututha isoto itutaeta. Soldadomonae barapomonae nayatoxoroto exanaxubiya ena isototha. Baraxota irʉ Pedro naeca. ");
INSERT INTO cui_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yabʉyo powa sacerdotemonae pia pepa pentacaponaein tatsi tanacuitatsi, poxonae Pedro tainchi barapowa, xua irʉ naeca baxota isototha barapowa Pedro caununaya baraichichi, jeichichi: —Bapon irʉ apara bayatha Jesús puna poponeibatsi, jei. ");
INSERT INTO cui_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ichitha Pedro jume matawenta, jei: —¡Petsiriwa, barapo pebin jopa yaitaeinyo! jei Pedro. ");
INSERT INTO cui_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bapoxonae pirapaeyo irʉ ichʉndʉ pebin patopa. Bapon Pedro irʉ tainchi xua irʉ naeca baxota. Pedro baraichi bapon, jeye: —Xam apara irʉ Jesús pijimonae tatsi jiwanam, jei. Ichitha Pedro jume barai, jeye: —¡Pebin, jopa dapomonae jiwananyo apara! jei Pedro. ");
INSERT INTO cui_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Poxonae cae hora yapucaewa, irʉrʉ ichʉn Pedro matowa baraichichi: —Bapon apara napuna poneiba Jesús, tsipei bapon Galilea nacuapindʉ, jei. ");
INSERT INTO cui_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ichitha Pedro jume barai, jeye: —¡Pebin, daʉmetha jopa taeinyo xua paebame! jei Pedro. Poxonae Pedro cataunxuae baxua cueicueijei, bapoxonae caena nainya wacara pebto caein fiba. ");
INSERT INTO cui_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nexata Jesús napatomeicha necota, Pedro necoyatsi. Nexata Pedro nanta xeinataba xua bayatha Jesús Pedro tsipaebatsi, poxonae jeye: “Xam barapo merawithe, pewʉnaeya poxonae wacara pebto fibina xam copiya acoibi po jume cuiyobetha neyabara jam tsane: ‘Jopa dapon yaitaeinyo’, neyabara jam tsane. Barapoxonae irʉ nainya wacara pebto fibina”, jeichi Pedro xua Jesús paeba. ");
INSERT INTO cui_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nexata Pedro pesato bejoniya. Bichocono wecoyei, peajʉntʉtanexae xua Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pomonae Jesús yapucaumeinchi, daxita barapomonae Jesús cui caponatsi, yawa bʉtsino. ");
INSERT INTO cui_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jesús itacuere cʉtatsi, paparuwatha yawa itabara cuaintatsino. Barapomonae Jesús baraichi: —Incane pana netsipaebare, ¿jintam caitabara tsaquibobara xua bequein paca itabara cʉtatsi? jei. ");
INSERT INTO cui_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Daxita barapomonae Jesús tsʉmʉ jume barʉ paebatsi ainya jumeintha. ");
INSERT INTO cui_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Poxonae pentha tsina nabarʉ nacaetuta penapataewi judiomonae, irʉ sacerdotemonae pia pentacaponaewi tatsi, irʉrʉ pomonae jiwi pecuidubiwi Moisés pia peitorobi coyene tatsi. Daxita barapomonae Jesús capoinchi pecanamata caitorobi bicheito itabaratha tatsi xua peyainyabinexatsi, jeichi: ");
INSERT INTO cui_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Incane pana netsipaebare, ¿Xam Mesías, pon Nacom necaitorobin? jei. Jesús jume epa pita jeye: —Icha: ‘Aa’, paca jei tsipaetsi, apara jopa pana nejume cowʉntsitsipaem. ");
INSERT INTO cui_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Icha paca yainyabichipatsi tayainyabiwan apara jopa pana nejume notsipaem. ");
INSERT INTO cui_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ichitha ponxaein Nacom Tananeitapetsin ecaein Nacom pia pecoxa weya tatsi, po Nacom peayapusʉ itorobi coyenewa pexeinaein, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bapoxonae daxita barapomonae Jesús baraichi: —¿Nexata metha xam Nacom Pexanto tatsim? jei. Jesús jume epa pita jeye: —Aa, barichi xuaunxuae papaebame painya coutha, jei. ");
INSERT INTO cui_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nexata barapomonae caemonae natsipaeba najei: —Anoxuae jopa nantawenonaetsi xua ichamonae Jesús peyabara paebiwatsi. Tsipei anoxuae nama yatsicaewa jume tainchi, xua bapon pia coutha nayabara paeba, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nexata daxita penayatoxoroto exanaxubiya enae jiwi barapomonae asiya umenarʉcʉpa, Jesús teicatsi yawa capoinchi Pilato peitabaratha tatsi. Pilato bapon pon Judea nacuapiwi peyanacua ewatsinchi. ");
INSERT INTO cui_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Baxota daxita barapomonae Jesús cui yopitatsi xua abe exana, jeye: —Barapo pebin patan xua wajiwimonae jume cui tsacabatsi xua anaepana cana exanatsi. Yawano pajume tanno pocotsiwa jopa bewa pinae paratixi matoma catsi pontha pon romanomonae itorobiya pia pepa peewatsinchi. Mataʉta bapon nayabara paeba: ‘Xan apara Mesías pon jiwi itorobiya pepa Taewatsin’, jei, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nexata Pilato Jesús yainyabatsi, jeye: —¿Xam judiomonae itorobiya pia pepa Neewatsin? jei. Jesús jume nota namchi, jeye: —Xuaunxuae paebame bara baxua apara, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nexata Pilato barai sacerdotemonae pia pentacaponaewi tatsi yawa baraino jiwi, jeye: —Jopa jume itaraerowinyo bapon xua po jumetha penayaita anae exanaewa, xua pebexubinexatsi barapo pebin, jei. ");
INSERT INTO cui_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ichitha barapomonae jume daunweya cueicueijei, jeye: —Jiwi jopa juniya jume cui tsacabichi xua anaepana exanatsi pia pecuidubiwantha, daxita Judea nacuatha. Baxua Galilea nacuatha tamropata pitaba, equeicha aunxuae waxainya becui joparene, jei. ");
INSERT INTO cui_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Poxonae Pilato baxua jume taeba barapo bicheito baraichi, jeye: —¿Jesús bara Galilea nacuapin? jei Pilato barapo bicheitotha. ");
INSERT INTO cui_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Barapo bicheito namchi, jeye: —Aa, bapon Galilea nacuapin, jei barapomonae. Bapoxonae Pilato itoroba, Jesús itorobatsi, Herodes peitabaratha beya. Bapon Herodes pon Galilea nacuapiwi peyanacua ewatsinchi. Herodes siwa poneiba Jerusalén tomara. ");
INSERT INTO cui_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Poxonae Jesús taebatsi Herodes, bapon bichocono jʉntʉ coyene weiweinanareca, tsipei bayatha Herodes cuinaya betaena. Herodes saya jume taiba xua Jesús yopiteibatsi. Herodes ichichipa tane xua Jesús petsita itʉtsi coyenewa exanaena. ");
INSERT INTO cui_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes Jesús matowa yainyabatsi. Ichitha Jesús jopa jume notsiyo. ");
INSERT INTO cui_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Baraxota irʉ ena sacerdotemonae pia pentacaponaewi tatsi. Irʉrʉ baxota ena pomonae jiwi pecuidubiwi Moisés pia peitorobi coyenewa tatsi. Daxita barapomonae Jesús bichocono abe yabara paebatsi Herodes pia xantha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nexata Herodes yawano pia soldadomonae tatsino daxita barapomonae Jesús tsʉmʉ jume barʉ paebatsi. Jesús cui caponatsi, pexeinya paparuwa juma xatatatsi pocotsi paparuwan nama xataba pomonae peyanacua ewatsi jiwi. Equeicha Jesús itorobatsi Pilato peitabaratha beya, Herodes bara beitorobiya. ");
INSERT INTO cui_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Barapo matacabitha Herodes irʉno Pilato naitacoxonabe. Baponbe caena bayatha saya penaita aenae-aenei jitonbe. ");
INSERT INTO cui_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sacerdotemonae pia pentacaponaewi tatsi irʉrʉ judiomonae pia pentacaponaewi, irʉrʉ daxita jiwi, daxita barapo bicheito Pilato waba xua barapo bicheito penacaetutsinexa. ");
INSERT INTO cui_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilato barai barapo bicheito, jeye: —Paxam barapo pebin pacaponame taxantha. Pajam: ‘Barapo pebin daxita jiwi jume cui tsacabatsi xua anaepana exanatsi’, pajam. Bayatha bequein baxua barapo pebin yabara yainyaban painya itabaratha pocotsiwa bayatha payabara paebame taxantha, ichitha jopa jume itaraerowinyo bapon, xua po jumetha penayaita anae exanaewa xua yabara pana netsipaebame. ");
INSERT INTO cui_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Icha ichin xua jopa jume itaraerowinyo Herodes barichi. Daxota equeicha Jesús caibe itorobarenatsi waxainya berena. Yaitama Jesús jopa abe exanaeyo, daxota jopa bewa bexubi. ");
INSERT INTO cui_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tha cueintichi bapon. Tha bapoxonae pu copatichi, jei Pilato. ");
INSERT INTO cui_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Poxonae Pascua matacabintha ichʉn ba bewa isanaxubichi. Pilato barapo Pascua matacabintha nantawenona xua isanaxubina caein pon jiwi pecʉbi botha peecaein, pon xua jiwi ichichipa, xua bapon peisanaxubinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bapoxonae daxita jiwi jume daunweya wawai, jeye: —¡Soldadomonae itorobare xua bapon pebexubinexatsi! ¡Barrabás painta pu sotabare! jei. ");
INSERT INTO cui_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás jiwi pecʉbi botha etatsi, tsipei caena bayatha matacapona ichamonae xua barapo tomarapiwi najume tsacaba cana exanatsi xuano xua jiwi jutebatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ichichipa xua Jesús pu copatatsi. Daxota equeicha barapo bicheito tsipaebatsi xua Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ichitha equeicha barapo bicheito jume daunweya wawai Pilatotha, jeye: —¡Bewa maisa naetotha tʉparucua exanaem! ¡Bewa maisa naetotha tʉparucua exanaem! jei. ");
INSERT INTO cui_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Equeicha Pilato tsipaeba barapo bicheito, jeye: —¿Eta pocotsiwa xua metha jane xua abe exana? Xan jopa jume itaraerowinyo bapon xua po jumetha penayaita anae exanaewa xua pebexubinexatsi bapon. Tha cueintichi, tha bapoxonae pu copatabichi, jei. ");
INSERT INTO cui_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Barapo bicheito jopa juniya wawayo xua naetotha tʉparucua peexanaenexatsi Jesús. Irʉrʉ sacerdotemonae pia pentacaponaewi tatsi jume daunweya wawairʉ, beya capanepa po coyene ichichipa pecana exanaewa. ");
INSERT INTO cui_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Daxota Pilato namchi: “Moya paexande be pocotsi coyeneya paichichipame”, jei Pilato. ");
INSERT INTO cui_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nexata Pilato nama pu sotaba pon jiwi pecʉbi botha peecaein, pon jiwi ichichipa xua bapon peisanaxubiwa tsainchi. Bapon pewʉn Barrabás, pon waetabatsi poxonae jiwi najume tsacaba xuano poxonae jiwi jutebatsi. Bapoxonae Jesús copatatsi, Pilato copata, xua Jesús bara pebexubinexatsi judiomonae pejumeyainwa tatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Poxonae Jesús cataunxuae caenapoinchi tʉpa peexanadutsinexatsi naetotha, pebin waetabatsi, soldadomonae waetaba. Bapon pewʉn Simón, Cirene tomarapin. Bapon wexua werena pona. Bapon peutucuratha tabotsicatsi naeto, xua pecaponaenexa Jesús peputha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesús peputha tapoinchi pin bicheito, irʉ ainya yabʉxino Jesús peputha tapoinchi. Daxita barapowaxi nantanuweya siwa namtsebiya wecoyeichi Jesús. ");
INSERT INTO cui_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ichitha Jesús necotabiya barai barapowaxi, jeye: —Yabʉxi Jerusalén tomarapiwaxi pam, jopa pana nesiwa namtsebiya wecoyande. Jame maisa painya coutha pana nasiwa wecoyande, painya pexuino pasiwa wecoyande. ");
INSERT INTO cui_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tsipei matacabin othopaena po matacabintha jiwi atene tsane. Barapo mataqueintha, jiwi jei tsane: ‘Jʉntʉ coyene weiweina po yabʉxi jopa pexui xeinaeyo. Jʉntʉ coyene weiweina po yabʉxi jopa bapana bʉtixitha taenaetsi pexui. Jʉntʉ coyene weiweina po yabʉxi bapana pexui jopa isainae’, jei tsane jiwi barapo matacabintha. ");
INSERT INTO cui_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yawano jiwi namchi tsane: ‘Maisa xanepana xua wawerapaewa xua wanaca cʉnʉbabiwa demxuwan, yawano tsorobon naca matatsun wetoxebabina xua jopa wanaca itʉtsiwa tsane’, jei tsane jiwi barapo matacabintha. ");
INSERT INTO cui_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Xan wʉnae exanan dacotsiwa jiwi jopa juniya neperaxa exanaeyo. Ichitha pomonae abe peexanaewi nama jopa juniya bichocono peraxa exanaetsi beyacaincha xua neperaxa exana, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Cataunxuae Jesús ecapona. Irʉrʉ ponbe abe matowa peexanaeinbe, baponbe Jesús peputha tacapoinchibe, xua baponbe irʉ pebexubinexa tsainchibe poxonae Jesús bexotsi. ");
INSERT INTO cui_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Daxita jiwi Jesús barʉ patatsi ichaxota po uruto be jiton matasipa piwa. Po uruto wʉn caunuteiba xua jei tsaibi: “La Calavera”, jei. Barapo uruto matasoitotha Jesús tʉparucua exanatsi naetotha. Irʉrʉ ponbe jiwi pecaibinbe tʉparucua exanatsibe naetotha ichaxota imoxoyo Jesús ducua. Ichʉn Jesús petsocona wetauncuiyatsi, irʉ ichʉn pecoxa wetauncuarenatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Poxonae Jesús naetotha ducua, Jesús jeye: —Axa yabara cui jʉntemainare po coyene barapomonae necana exana, tsipei barapomonae jopa yaputaeyo xua necana exana, jei Jesús. Soldadomonae nata tsaba Jesús pia paparuwan tatsi. Bapomonae ibotixi bebeya penacueranta notsinexa Jesús pia paparuwan tatsi. Pon beta xoya ibotiyo bapon copiya pita Jesús pia paparuwan tatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Baraxota Jesús taeumeinchi jiwi. Ichitha nama pentacaponaewi Jesús cui caponatsi, barapomonae jeye: —Bapon cain capanepeibabei ichamonae, came jopa nacapanepaeyo. Icha bara bapon Mesías, pon Nacom pia peitapetsin, bʉ bara bapon pia coutha nacapanepa naeto wetsica, jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldadomonae irʉ Jesús cui capoinchi, imoxoyo caquita umenapoinchino. Barapo soldadomonae Jesús apatatsi po mera pewʉn vino, po mera mene atsu. ");
INSERT INTO cui_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Barapo soldadomonae Jesús baraichi, jeye: —¡Icha xaniwaicha judiomonae itorobiya pia pepa Neewatsim, moya jinya coutha nacapanepare! ¡Naeto wetsica ecoinca! jei soldadomonae. ");
INSERT INTO cui_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesús pentutu wetsica tadutatsi napaewa xua barapo napaewatha tina. Barapo petinadutsiwa jeye: “Baponje apara judiomonae itorobiya pia pepa peewatsinchi”, jei barapo petinadutsiwa. ");
INSERT INTO cui_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ponbe Jesús pecuariya tacobe matatabarutatsibe, ponbe matowa abe peexanaeinbe, baponbe caein ichʉn, bapon Jesús biatainchi petʉpaeyainwa naetotha. Bapon namchi: —¡Icha xaniwaicha xam Mesías, ponxaem Nacom caitapeta, moya jinya coutha nacapanepare! ¡Yawano pana necapaneparebe! jei bapon. ");
INSERT INTO cui_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pon icha naetotha ducua, bapon jume matawenta, pon Jesús casebatsi, bapon jume matawentatsi. Pon icha naetotha ducua namchi, jeye: —¿Xam jopa cuitaya junuwim Nacom? Aparaunxuae tʉpaeinchibe ichaunxuae Jesús ichi tsane. ");
INSERT INTO cui_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Waxainchibe jopa juniya naca peraxa jʉbiyobe abe waexanaexaebe, apara bara xainwaicha xua nacata exana tsipei bayatha apara abe exanatsibe. Ichitha nama ponje jopa apara abe exanaeyo, jei. ");
INSERT INTO cui_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nexata pon baxua penamchixae, bapon Jesús baraichi, jei: —Jesús, neyabara cananta xeinare xua tana neyawenaenexam po matacabitha poxonae patopeicaename xua jiwi neitorobinexam tsane, jei bapon. ");
INSERT INTO cui_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús jume nota, jeye: —Xaniwaicha bara catsipaebatsi, anoxuae tsane cabarʉ ecaeinchi ichaxota jiwi jʉntʉ coyene weiweinathopeiba, peitʉpanae nacuatheicha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Poxonae Jesús cataunxuae ducua naetotha, bapoxonae daxita nacuantha bichocono aitaquiri xua poxonae mateinyaxae weya, beya yatabopiya. Tres po horabe quirei tsuncuae. ");
INSERT INTO cui_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Poxonae cataunxuae xometo jopa penthiyo, bapoxonae paparuwa, po paparuwa Nacom pin pia botha ducua, barapo paparuwa nainya bopiya matonta tsitsiqueica. ");
INSERT INTO cui_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nexata Jesús jume daunweya wawai, jeye: —Axa, nejumope pire, po jumope tana necatsixaemxae, jei Jesús. Poxonae Jesús baxua caunuta, bapoxonae Jesús tʉpanaicha. ");
INSERT INTO cui_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Soldadomonae pia pentacaponaein tatsi Roma nacuapin, poxonae bapon baxua taeba, bapoxonae Nacom wʉnae jaintatsi, jeye: —Jaina, apara baraponje jopa abe exanaeyo, itara ichamonae yopita xua abe exana, jei bapon. ");
INSERT INTO cui_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Daxita pomonae xua baxua taeumena baxota, barapomonae pia bo benawibiya. Poxonae namtotha enapona, daxita barapomonae nantacari cuainbobenapona poxoru bichocono ajʉntʉcoyenetane xua Jesús pewisiwatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ichitha pomonae Jesús peyaitae jiwi, irʉ yabʉxino, powaxi Jesús puna dendenatsi Galilea nacua werena, daxita barapomonae Jesús tajʉ wetaeumeinyatsi poxonae ichamonae Jesús bexotsi. ");
INSERT INTO cui_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Irʉrʉ pebin popona, bapon pewʉn José, Arimatea tomarapin. Arimatea tomara eca Judea nacuatha. Bapon pentacui xanepanaein. Yawano beta pepoponaein Nacom peitʉtha tatsi. José, bapon jiwana caein pomonae judiomonae pia pecanamata caitorobi bicheito tatsi. ");
INSERT INTO cui_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Barapon José yabara jume cowʉntsiya wʉnae ewateiba po coyenewa xua poxonae Mesías patopaetsica pon jiwi itorobiya peewatsinexatsi. Poxonae pomonae pecanamata caitorobi bicheito exana poxonae Jesús bexotsi, baxua José jopa pebʉrʉya nacayabara nanta xeinaeyo. ");
INSERT INTO cui_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","José Pilato siwa poinchi. Pilato wʉcatsi Jesús petʉpaein, José wʉca. ");
INSERT INTO cui_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José naeto wepichica Jesús petʉpaein. Bapoxonae José mata quiyontabareca barapo pexeinya paparuwatha. Bapoxonae José ibo mʉthʉ iya boya, po mʉthʉ jiwi mʉthʉ tofobobapona. Barapo mʉthʉtha cataunxuae petʉpaein ichʉn jopa boyaetsi. ");
INSERT INTO cui_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","José baxua exana po mataqueitha pewʉn penacui xaxainchi matacabi poxonae judiomonae ba weta daxita xua penacuitsiwa pewʉnaeya poxonae jopaena pentaquei seicae matacabi. Barapo pentaquei seicae matacabi imoxoyo jopaena. ");
INSERT INTO cui_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Powaxi Jesús puna dendenatsi Galilea nacua werena, barapowaxi pona mʉthʉtha, petaenexa xua Jesús mʉthʉtha xotsi. ");
INSERT INTO cui_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Poxonae barapowaxi bo benawibiya, bapoxonae nacui wʉnaetajeba petuxueiwan yawa penasiwanno, xua Jesús petʉpaein tsixaxaintajebatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Barapowaxi botha cuicuina peseicae matacabitha, Moisés pia peitorobi coyeneya pepaebixae, barapo matacabi yabara. Poxonae judiomonae pia pentaquei seicae matacabi tatsi yapu caewaba bapoxonae patopa matacabi po matacabi xua copiya ducua cae semanatha. Barapo matacabitha poxonae aena pentha tsina, yabʉxi pona mʉthʉ beya ichaxota Jesús boca. Barapowaxi capona petuxueiwan yawa penasiwanno xua bayatha xaxaintajeba. Barapowaxi cueyabatsi icha yabʉxi. ");
INSERT INTO cui_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Poxonae barapowaxi barapo mʉthʉ beya pata, barapowaxi taerʉcʉpa xua po ibo panawatha yauxatatababota xua pin ibo panawa barapo ibo mʉthʉ bayatha cou yaupataxubabota. ");
INSERT INTO cui_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Barapowaxi jojoniya mʉthiya ichitha barapowaxi jopa taeyo xua Jesús pon Pecanamataxeinaein petʉpaein pebocuaewa. ");
INSERT INTO cui_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Barapowaxi yabara najʉntʉ coyene cabenaeca. Jopa yaputaeyo xua exana tsipei jopa taeyo xua Jesús petʉpaein boca. Barapowaxi tsita naitʉtatsi nacueyatabe pebinbe ponbe xua asiya uncuabe, xuano xua yawa paparuwa nama xatatabe, po paparuwa bichocono daedaena. ");
INSERT INTO cui_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Barapowaxi bichocono junuwa, pijunuwi irabe necobareca. Barapo pebinbe barapowaxi baraichi, jeibe: —¿Eta xua metha petʉpae cuiru coyenewatha panecobompame pon equeicha asʉ barapo petʉpae cuiru coyene weya? ");
INSERT INTO cui_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Xote jopa bocaeyo bapon. Bayatha bapon asʉ petʉpae cuiru coyene weya. Payabara jume nanta xeinare xua bayatha bapon paca tsipaeba poxonae cataunxuae Galilea nacuatha popona. ");
INSERT INTO cui_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Paca jeye: ‘Xan ponxaein Nacom Tananeitapetsin, bewa necaenaetsina pomonaetha pomonae abe peexanaewi. Barapo abe peexanaewi naetotha tʉparucua neexanadutsina. Ichitha equeicha po matacabi acoibibetha asʉn juina neexanaena petʉpae cuiru coyene weya’, paca jei Jesús, jei barapo pebinbe xua barapowaxi tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nexata barapowaxi baxua jume cui yabara nanta xeinarʉcʉpa xua bayatha barapowaxi tsipaebatsi, xua Jesús tsipaeba. ");
INSERT INTO cui_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Poxonae barapowaxi mʉthʉ wenawibiya tomara beya, barapowaxi daxita paeba pocotsiwa tane. Jesús pia peitorobiwi tatsi pomonae xua once poyobe barapomonae tsipaebatsi, ichamonaeno tsipaebatsino, pomonae Jesús jume cowʉntatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Powaxi yopita, xua powaxi Jesús pia peitorobiwi tsipaebatsi, ichowayo pewʉn María Magdalena powa Magdala tomarapiwayo, irʉ ichowayo Juana, ichowayo María, Santiago pena tatsi, yawanorʉ ichowaxino powaxi saya napona. ");
INSERT INTO cui_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ichitha Jesús pia peitorobiwi tatsi nanta xeina xua barapowaxi jopa xainyeyo, yawano jopa jume cowʉntsichi barapowaxi. ");
INSERT INTO cui_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bapoxonae Pedro mʉthʉ becuinaepoinya. Mʉthʉ tututha tane xua meisa paparuwa boca. Bapon pia bo benawiya. Bapon baxua yabara nanta xeina nawita. ");
INSERT INTO cui_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Barapo matacabitha Jesús pijimonae tatsi jiwanabe namtotha ecaponabe, siwa ponabe tomara, po tomara pewʉn Emaús. Barapo tomara eca once po kilómetrobe xua Jerusalén tomara weya. ");
INSERT INTO cui_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Baraponbe yabara natsipaebecaponabe namtotha xua mexuaetha exana. ");
INSERT INTO cui_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Poxonae cataunxuae yabara natsipaebecaponabe yawa yabara najume matsontsonobecaponabe, bapoxonae Jesús imoxoyo caquita uncuatababe yawa naponano. ");
INSERT INTO cui_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bequein baraponbe Jesús tainchi, ichitha baponbe jopa ita cui canaʉpaetsibe xua Jesús peyaitaewatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nexata Jesús yainyaba, baponbe baraichibe, jeye: —¿Eta xua namtotha yabara pana natsipaebecaponamebe? jei Jesús. Baponbe jʉntʉ wecoyeya naruntababe peyabara natsipaebecaponaexaebe xua mexuaetha exana. ");
INSERT INTO cui_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ponbe penacueyatsixaebe caein pewʉn Cleofas. Bapon Cleofas Jesús jume notatsi, jeye: —Daxita pomonae jinompa Jerusalén tomaratha, daxita barapomonae yaputane xua exana barapo matacabintha. ¿Meisa xam compam jopa yaputaem xua mexuaetha exana? jei. ");
INSERT INTO cui_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nexata Jesús baraibe baponbe, jei: —¿Eta xua exanara barapo tomaratha? jei. Baraponbe jume notabe, jeibe: —Apara pana natsipaebecaponanbe xua jiwi exana, pajan: ‘Xua po coyeneya Jesús Nazaret tomarapin cana exanatsi’, pajan. ‘Pon Nacom peitorobi jume papaebin, pon peitʉpanae petsita itʉtsi coyenein exana Nacom pia peayapusʉ itorobi coyeneya tatsi’, pajan. ‘Pon xanepanaya pecueicueijein Nacom peitʉtha tatsi, xuano xua jiwi peitʉtha tatsi’, pajan. ");
INSERT INTO cui_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sacerdotemonae pata tanecanamataxeinaewi irʉ pata pecanamata caitorobiwi piraichi Jesús cobe waetabatsi pia Pilato peitorobinexa soldadomonae xua Jesús tʉparucua peexanaenexa tsainchi naetotha. ");
INSERT INTO cui_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bequein pawʉnae ewatan xua Jesús patopa xua peyawenaenexa tsane Israel nacuapiwi xua barapo Israel nacuapiwi panenebiya peexanaenexatsi, ichitha bapon jopa capanenebiyaeyo barapomonae. Yawano acoibi po matacabibe pu caewa poxonae Jesús bexotsi. ");
INSERT INTO cui_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yabʉxi, powaxi xua paxan jiwana pan, barapowaxi pona mʉthʉ beya poxonae aena pentha tsina. Pona ichaxota Jesús boca. Barapowaxi pana tsipaeba xua tane. Daxua pana nenabenaeca exana bichocono. ");
INSERT INTO cui_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Barapowaxi pinae jopa taeyo Jesús petʉpaein. Bapoxonae pana netsipaeba xua pinae barapowaxi tsita naitʉtatsi matatsunpiwi. Pinae matatsunpiwi namchi: ‘Bayatha Jesús asʉ’, jei pinae. ");
INSERT INTO cui_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bapoxonae pata jiwimonae, barapomonae jiwana mʉthʉ beya pona. Barapomonae bara tane baxua, xua yabʉxi yopita. Ichitha Jesús petʉpaein jopa taetsi, jeibe xua Jesús tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nexata Jesús jume nota baraponbe, jeye: —Paxam pomonae jopa peyaputae jiwi pam, xuano xua bewayo pajume cocowʉntaponame pocotsiwa bayatha Nacom peitorobi jume pepaebiwi paeba. ");
INSERT INTO cui_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Paxam payaputaneme xua Mesías pon Nacom itapeta, copiya bewa peraxa exanaeinchi. Nacom cana exanaena xua bapon patopaena Nacom pia peitorobi nacua beicha xua pexeinaenexa tsane Nacom pia peayapusʉ itorobi coyenewa tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nexata Jesús tsipaeba baraponbe xua daxita i dapo diborontha Jesús yabara paebatsi Nacom Pejume Diwesitha. Copiya matha Jesús yaputane exana po diwesin xua Moisés tina xua Jesús yabara paebatsi. Bapoxonae equeicha Jesús yaputane exana xua po diwesi Nacom peitorobi jume pepaebiwi tina, xua Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jesús, irʉ barapo pebinbe imoxoyo pata tomaratha, po tomara siwa ponaena. Barapo pebinbe naruntababe, ichitha Jesús mexeya maisa pona namto tomara weya. ");
INSERT INTO cui_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ichitha baponbe Jesús jume daunweya baraichi, jeye: —Pana nebarʉ ecare, apara bayatha tabopiya tsanaicha, quirei tsanaicha apara, jeibe. Daxota Jesús puna joniya ichaxota baraponbe patopabe xua barponbe pebarʉ ecaenexa tsainchibe. ");
INSERT INTO cui_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nexata poxonae Jesús barʉ eca pexaethopaewatha baponbe, bapoxonae Jesús wecobe pita pan. Paxa barai: “Axa, maisa jʉntʉ coyene weiweinan xua pata tana necatsiwam barapo pan”, jei. Bapoxonae Jesús epa janaxuba pan. Baponbe catatsibe. ");
INSERT INTO cui_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Poxonae Jesús baxua exana, caena bapoxonae baponbe Jesús yaitainchi. Baponbe yaitaebabe. Bapoxonae Jesús yacuinaya jemeicha aichurucuae tsanaya. ");
INSERT INTO cui_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Baponbe natsipaebabe, najeibe: —Maisa jʉntʉ coyene weiweinatsibe poxonae namtotha naca tsipaebecaponabe. Bapon naca yaputane exanabe xua bapon peyabara paebiwatsi Nacom Pejume Diwesitha, jei baponbe. ");
INSERT INTO cui_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bapoxonae caena yacuinaya caibe iyabe Jerusalén tomara beya. Baraxotiya Jerusalén tomaratha baponbe caxinabe penacaetutsi jiwi pomonae once poyobe pomonae Jesús pia peitorobiwi tatsi. Irʉrʉ nanacaetuta pomonae cueyaba xua pomonae once poyobe pia pecueyabiwichi. ");
INSERT INTO cui_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Barapo penacaetutsi jiwi namchi baponbetha, jeye: —Apara xainyei. Bara Jesús pon Pecanamataxeinaein, asʉ. Apara bapon Jesús Simón tsita naitʉtatsi, jei barapo penacaetutsimonae. ");
INSERT INTO cui_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nexata baponbe daxita yabara paebabe barapo penacaetutsi jiwitha xua baponbe namtotha cuidubecapoinchibe. Mataʉta paebabeno xua baponbe matapainya yaitaebabe xua Jesús yaitaebatsi poxonae Jesús pan epa janaxuba, xuano xua poxonae catatsibeno pan. ");
INSERT INTO cui_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Poxonae cataunxuae tsipaebabe barapo diwesi, bapoxonae Jesús jemeicha tsita naitʉta barapomonae peitabaratha. Jesús jacoba barapomonae, jeye: —Barabʉ Nacom jʉntema jinompa paca cana exana, jei Jesús barapo penacaetutsimonaetha. ");
INSERT INTO cui_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Barapomonae bichocono nabenaeca, yawa bichocono cuitaya junuwa. Barapomonae nanta xeina xua metha Jesús perowatsi tainchi. ");
INSERT INTO cui_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ichitha Jesús barai barapo penacaetutsimonae, jeye: —¿Eta xua metha junuwiya pana nabenaecame? ¿Eta xua metha ainya ʉnthʉton pam? ");
INSERT INTO cui_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pana necobe taema, yawa pana netaxu taema. Apara bara xan tsocuaein. Pana nejayabare, yawa pana neyaputaema xua xan pepa jiton. Dowatsi bapana jopa wi ducuae, yawa bapana jopa piwa ducuae. Ichitha aunxuae nama yatsicaewa xaniwaicha pana netaneme xua xan pepa jiton icha paxam paichim, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Poxonae baxua Jesús najume weta, nacobe wan itʉba, yawa nataxu wan itʉba. ");
INSERT INTO cui_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ichitha came awiya barapomonae jopa jume cowʉntsiyo poxoru barapo diwesi barapomonae tsita jume xeicatsi yawa barapo diwesi yabara najʉntʉ coyene cabenaeca exanatsi. Jesús jeye: —¿Paxam xote penabanaewiyo paxeiname? jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nexata barapomonae Jesús catatsi duweiyo, poyo seba. ");
INSERT INTO cui_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús wecobe pita, yawa xane barapomonae peitʉtha tatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bapoxonae Jesús namchi barapomonaetha: —Caena bayatha paca tsipaebatsi poxonae cataunxuae paca barʉ ecatsi. Paca jeichiche: ‘Daxita po coyenein neyabara tina, daxita baxuan peneyabara jeixae, bewa necana exanaena. Daxita xua Moisés po diwesintha neyabara tina, bewa necana exanaena. Daxita pocotsiwa Nacom peitorobi jume pepaebiwi neyabara tina, bewa necana exanaena. Daxita xua salmos penaxʉnae weixi diwesintha neyabara tina, bewa necana exanaena’, paca jeichiche, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jesús barapomonae yaputane exana xua Nacom Pejume Diwesi paeba. ");
INSERT INTO cui_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jesús barai barapomonae, jeye: —Nacom Pejume Diwesitha neyabara jei: ‘Mesías bewa tʉpaena, yawa equeicha asʉ tsane po matacabi acoibibe petʉpae coyene cuiru weya. ");
INSERT INTO cui_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yawano bewa barapomonae Mesías pia pejume cowʉnchiwichi bewa tsipaebina daxita nacuantha Nacom Pejume Diwesi tatsi Mesías pia peayapusʉ itorobi coyeneyatha tatsi. Copiya petamropata notsinexa Jerusalén tomara weya. Barapomonae jei tsane jiwitha: Bewa icha jʉntʉ coyene Nacom patsita xeinaem xua bapoxonae Nacom painya nepaca cayabara jʉntemainaewa tsane abe painya neexanae cuiru coyenewa, jei tsane barapomonae’, jei Nacom Pejume Diwesitha, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Equeicha Jesús barai pijimonae, jeye: —Paxam daxita jiwi patsipaebiname daxita xua pataneme. ");
INSERT INTO cui_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mataʉta pataemano xua pacata itorobicaeinchi Nacom pia Pejumope tʉnaxʉ tatsi xua bayatha Taxa yabara paca tsiwʉnae muxu duta. Barapo Nacom pia Pejumope tʉnaxʉ tatsi yawa patopaena peayapusʉ itorobi coyenewa. Paenare xote Jerusalén tomaratha, beya poxonae barapon yawa pacata patopaena pia peayapusʉ itorobi coyenewa Nacom pia nacua tatsi wetsica, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nexata Jesús pijimonae barʉ pona Jerusalén tomara weya, Betania tomara bebarʉ iya. Jesús namaxʉ yoicha itaboco beicha yawa tsipaeba Nacomtha xua pijimonae tatsi nexa, xua pijimonae petayawenaenexatsi. ");
INSERT INTO cui_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Poxonae cataunxuae Jesús tsipaebuncua Nacom xua pijimonae tatsi nexa, bapoxonae Jesús athabe juinya exanatsi peitaboco beicha, Nacom exana. ");
INSERT INTO cui_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Poxonae Jesús pijimonae tatsi baxua tane, bapoxonae barapomonae Jesús pecoutha tatsi namchi: “Maisa Wanacanamataxeinaein wʉnae”, jei. Barapomonae Jerusalén tomara beya jʉntʉ coyene weiweinaya caibe nawibiya. ");
INSERT INTO cui_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Barapomonae Jesús pia peitorobi jiwi tatsi Nacom pin pia botha, baxota Nacom jopa juniya wʉnae jainteibichi. Baja Lucas.");
INSERT INTO cui_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Poxonae cataunxuae daxita nacuan jopa forotsiyo, bapoxonae irʉrʉ caena bayatha Mesías popona, pon Nacom Pexanto tatsi, pon pewʉn “Pejume”, baraichi. Bapon Nacom caena bayatha barʉ poponeiba. Bapon apara bara Nacom. ");
INSERT INTO cui_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Poxonae aena copiya, bapoxonae bapon caena bayatha Nacom barʉ popona. ");
INSERT INTO cui_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nacom cana exana xua Mesías daxita nacuan foforota. Dapocotsiwa aibi xua yaseicanaya xua pocotsiwa bapon jopa exanaeyo. ");
INSERT INTO cui_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Bapon Mesías, pon “Pejume” baraichi bapon asʉ cana exana daxita jiwi tsipei bapon ataya xeina peasʉ coyenewa. Mataʉtano bapon pena jʉntʉ coyeneno cana catsiya taexanano jiwi xua jiwi yaputaena po coyene pexainyei coyenewa. ");
INSERT INTO cui_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Icha pecoicha ichi xua jiwi yaweinchi xua beta pejinompaenexa poxonae quirei, bara jʉta ichi Mesías. Bapon jiwi yaweinchi xua beta xanepanaya pejijinaponaenexa poxonae bapon Mesías cuiduba jiwi. Caurimonae pia pentacaponaein tatsi bequein ichichipa xua Mesías peamanayabiwatsi, ichitha caurimonae pia pentacaponaein tatsi jopa itacʉpaetsi xua Mesías peamanayabiwatsi tsipei bichocono Mesías peayapusʉwa xeina. ");
INSERT INTO cui_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bapoxonae irʉ Nacom itoroba pebin, pon pewʉn Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Bapon patopa xua Mesías peyabara paebinexatsi, po wʉn xua jei “Pon Nacom itorobica”, jei. Bapon Juan daxita jiwi jʉntʉ coyene cui tsacaraba xua jiwi Mesías pewʉnaeya tatsi, penajʉntʉ cui wʉnaetsinexa xua daxita jiwi Mesías pejume cowʉntsinexa tsainchi. ");
INSERT INTO cui_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan apara Mesías aibi. Apara saya pia Mesías wʉnae yabara paebichi xua Juan peitorobixaetsi baxua. ");
INSERT INTO cui_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Bapon Mesías patopeica po cae pin nacuathe tsique peyawenaenexa daxita carepaya jiwitha pia pecuidubi coyenewantha. ");
INSERT INTO cui_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Bapon popona barapo cae pin nacuathe tsique. Bara bequein bapon exana pia coya barapo nacue, po cae pin nacuatha tsica pona, daichitha barapo cae pin nacuathepiwi jopa Mesías yaitaetsi po coyene xua bapon po cae pin nacuathe tsique forota daxita. ");
INSERT INTO cui_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Bequein bapon bara pia nacuatha patopeica, daichitha barapo cae pin nacuapiwi bapon jopa weiweinaya matenta wabichi. Mataʉtano jopa yaputaetsi xua po coyene bapon Mesías apara pon Nacom itoroba. ");
INSERT INTO cui_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ichitha ichamonae pomonae bapon matenta weiweinaya wabatsi xuano xua bapon jume cowʉntatsi, barapomonae Mesías cana exana xua po coyeneya barapomonae Nacom piamonae tatsi penaexanaewa tsane. ");
INSERT INTO cui_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tsipei barapomonae jopa naexanaeyo Nacom pia pexui xua poxoru be jiton coyeneya penaexanumenaponaexae. Mataʉtano barapomonae jopa naexanaeyo Nacom pia pexui xua poxoru pebin peichichipaexae xua pepichiwa piowa. Mataʉtano barapomonae jopa naexanaeyo Nacom pia pexui xua poxoru coxiyʉn peichipaexae xua pexeinaewa pia pexui. Saya jame barapomonae Nacom pia pexui tatsi naexana, tsipei Nacom cana exana baxua. ");
INSERT INTO cui_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Barapon Mesías pon pewʉn “Pejume”, baraichichi, bapon poxonae naexana po cae pin nacuathe tsique bara bapon yatsicaya pepa jiton. Mataʉtano naca barʉ popona bapon. Bapon wʉn ununatatsi “Jesús” baraichichi. Mataʉtano bapon pejʉntʉ coyene wetsina bichocono jiwi antobetsi. Mataʉtano bapon xainyeya pepaebin. Mataʉtano paxan pacui tan xua Jesús exaneiba pia pexeinya peayapusʉwatha po pexeinya peayapusʉwa Jesús Paxa catatsi. Bapon Nacom Pexanto tatsi, bara yatsicaya compa tatsi pepa Pexanto. ");
INSERT INTO cui_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan yabara paeba, Jesús yabara paebatsi. Juan jeye: “Bara barapon apara pon bayatha yabara paeban xua poxonae janje: ‘Pon cotacaya patopa xua xan tsiwana patopan, bapon jame bichocono peainya cuin, beyacaincha xan. Tsipei bapon caena bayatha popona poxonae xan aibin xua poxonae abʉ cataunxuae jopa naexanaeinyo’, janje”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bapon Jesús naca cata daxita pia peyaputae coyenewan. Jopa juniya amanaya naca catsiyo baxuan, xua pocotsiwa nantawenonatsi jʉntema watsita jinompaenexa tsane bapon. ");
INSERT INTO cui_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés naca cata Nacom pia peitorobi coyenewan tatsi. Baxuan bichocono jopa juniya ayapubeyo. Ichitha Jesucristo, pon “Mesías” baraichi xua pocotsiwa naca cuiduba xua pinae Nacom jopa juniya antobeyo jiwi, xuano xua pocotsiwa naca cuiduba bara baxua yatsicaya pexainyei jume. ");
INSERT INTO cui_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dapon aibi pon Nacom petaewatsi. Nacom Pexanto tatsi, pon yatsicaewa compa tatsi bapon naca cana exana xua Nacom wayaputaewatsi, paxa imoxoyo pebarʉ poponaexaetsi. ");
INSERT INTO cui_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judiomonae pomonae ena Jerusalén tomaratha barapomonae sacerdotemonae itorobatsi irʉrʉ levitamonae itorobatsi Juan beya, xua Juan peyainyabinexatsi xua pejeinexatsi: “¿Xam jintamʉmda?” pejeinexatsi. ");
INSERT INTO cui_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan beta nayabara paeba, jeye: —Xan Mesías apara aibin, pon Nacom itorobicaena, pon wanaca capanenebiwa tsane, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Nexata equeicha Juan yainyabatsi, jeichichi: —¿Metha nexata xam jintamʉmda? ¿Bara xam bapom pon Nacom peitorobi jume pepaebim pon pewʉn Elías, pon bayatha tʉpa? jei barapomonae. Juan jume nota, jeye: —Xan bapon apara aibin, jei. Equeicha Juan yainyabatsi, jeichichi: —¿Nexata jintam metham? ¿Xam bapom pon Nacom peitorobi jume nepaebim pon bewa patopeicaena juinya pata tanecuidubinexa tsane Nacom Pejume Diwesi? jei barapomonae. Equeicha Juan jume nota, jeye: —Jume, xan apara aibin dapon, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nexata daxita barapomonae Juan baraichi, jeye: —¿Eta pom metham? Tsipei xua pata tanejume notsiwam pata tha xuya tsipaebichi pomonae pana nejume caitoroba. ¿Etabe pana nejumichim tsane xua jinya coutha nenayabara paebiwam? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nexata Juan jume nota, jeye: —Xan bapon aparan pon wawan ichaxota ira xuepana susato tsurucuae nacua beya, xua jan: ‘Patsi najʉntʉ cui coyene wʉnaere, pon jiwi pia pepa Pecanamataxeinaeinchi nexa pia pepatopae wʉnaeya tsane’, xua jan ponxaein xua wawan ira xuepana susato tsurucuae nacua beya. Bayatha Isaías pejume diwesitha taneyabara jume cui wʉnae tsiwanaya paebixae pon Nacom peitorobi jume pepaebin, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Daxita pomonae Juan barʉ cueicueijeichi, barapomonae fariseomonae itoroba. ");
INSERT INTO cui_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Daxita barapomonae Juan yainyabatsi, jeichichi: —Icha xam bapon Mesías aibim xuano xua icha Elías aibim, yawa icha xam bapon aibim pon Nacom peitorobi jume nepaebin, ¿nexata jintam cacui itoroba xua nebautisabiwa jiwi? jei barapomonae. ");
INSERT INTO cui_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan jume nota, jeye: —Xan meratha bautisaban, ichitha ichʉn beta exanaena beyacaincha xan. Bapon bara bequein painyamonae pia xantha tatsi popona ichitha bapon jopa payaitaem. ");
INSERT INTO cui_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Bequein bapon nepuna patopaena, ichitha pocotsiwa bapon exana bichocono ainya cui beyacaincha pocotsiwa exanan. Bichocono pin ura tsita xeinan xua tataxu mʉ isanaxubiwa tsane pia penataxu xatatsiwa tatsi, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Daxita baxuan Juan yainyabatsi ichaxota po tomara pewʉn Betania. Barapo tomara eca icha pocotsiwa xometo weecoina xua icha muxunenetha eca Jordán mentha. Barapo muxunenetha Juan bautisaba jiwi. ");
INSERT INTO cui_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Icha mataqueitha Juan tane, Jesús tainchi xua Juan pexainya tarenatsi. Bapoxonae Juan jiwitha jeye: “Incane pataema pon pejʉntʉ coyene xeicaein pon Nacom itorobica, pon ‘Cordero’, baraichichi xua oveja pebto penʉn. Apara bapon pon jiwi petsitʉpaewa tsainchi xua abe pia peexanae cuiru coyenein tatsi icha poxonae ovejiyo ichi poxonae tsitʉpa jiwi abe pia peexanae cuiru coyenein tatsi. ");
INSERT INTO cui_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Bara bapon apara pon bayatha yabara paeban poxonae janje: ‘Pon cotacaya patopa xua xan tsiwʉna patopan, bapon jame bichocono peainya cuin, beyacaincha xan. Tsipei bapon caena bayatha popona poxonae xan aibin xua poxonae abʉ cataunxuae jopa naexanaeinyo’, janje. ");
INSERT INTO cui_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xan copiyatha jopa yaputaeinyo xua Jesús bapon barapara Mesías, pon icha wʉn Cristo, pon Nacom itorobica. Ichitha xan patopan tabautisabinexa meratha Israel piamonae susato saineiwi xua barapomonae bapon peyaputaewa tsainchi”, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan yawa namchi, jeye: “Poxonae bapon bautisaban bapoxonae tan Nacom pia Pejumope tʉnaxʉ tatsi xua peitaboco weruneica xua be topiboto yaruneica. Barapo Nacom pia Pejumope tʉnaxʉ tatsi, bapon pexantha tapatopatsi. ");
INSERT INTO cui_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Xan cataunxuae bapoxonae xaniwaicha jopa yaitaeinyo bapon. Ichitha pon xua necui itoroba xua jiwi bautisaban meratha, nejei bapon: ‘Taename tajumope tʉnaxʉ xua be topiboto tsecae xua peitaboco weruneica, po tajumope tʉnaxʉ bapon pia xantha tapatopatsi. Poxonae baxua taename bapoxonae yaputaename xua barapo pebin apara pon jiwi pebautisabiwa tsainchi tajumope tʉnaxʉtha. Bapon barompaya pia pebautisabi coyenewa exanaena xua poxonae barapo tajumope tʉnaxʉ catsibina pomonaetha pomonae piamonaethaxae. Barapoxonae barapo tajumope tʉnaxʉ barapomonae yanaba jinompaeinchi’, jei Nacom. ");
INSERT INTO cui_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Bapoxonae bapon yaitan xua deta cou apara Mesías, yaitama tan xua poxonae bayatha Nacom netsipaeba. Daxota paca tsipaebatsi xua bapon barapara Nacom Pexanto tatsi”, jei Juan jiwitha. ");
INSERT INTO cui_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Icha mataqueitha equeicha Juan pon jiwi Pebautisabin pecoutha patopa xuano xua pebinbe nacueyatabe puna poinchi ponbe xua pia pepuna ponaewichi jiwanabe tatsi. ");
INSERT INTO cui_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Poxonae Juan tane xua Jesús dawerena ichaxoyo Juan dena, bapoxonae Juan jeye xua Jesús yabara jeichi: —¡Pataema apara bapon pon ‘Cordero’ baraichi xua oveja pebto penʉn pon Nacom itorobica xua petsitʉpaenexa jiwi abe pia peexanae cuiru coyenein tatsi! jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Barapo pebinbe ponbe Juan pia pepuna ponaewichi jiwanabe tatsi, baraponbe Juan jume tainchibe xua Juan baxua paeba. Bapoxonae barapo pebinbe Jesús puna poinchibe. ");
INSERT INTO cui_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nexata Jesús napatomeicha necota caibeya yawa tanebe xua barapo pebinbe Jesús puna poinchibe. Bapoxonae baponbe Jesús yainyaba, jeye: —¿Painya eta xuatsi? Jesús jume notatsibe baponbe, jeibe: —Pon jiwi Necuidubim, ¿exota poponame? jeibe. ");
INSERT INTO cui_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús jume nota baponbe, jeye: —Anetha, matha pataema, jei Jesús. Nexata napuna ponabe yawa natanebe ichaxota Jesús popona. Barapo mataqueitha naecabe ichaxota Jesús popona. Jopa nawiyaebe tsipei xometo tabopiya tsanaichaba. ");
INSERT INTO cui_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ponbe Juan pejume taexaetsibe xuano pepuna ponaexaetsibe Jesús, caein pewʉn Andrés, Simón Pedro peweicho tatsi. ");
INSERT INTO cui_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés copiya matha peweicho wenawenei pon pewʉn Simón. Andrés barai peweicho, jeye: —Paxan pacaxinan pon pewʉn Mesías, jei Andrés. (Barapo wʉn yabara caunuta xua jei “Cristo”, jei.) ");
INSERT INTO cui_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Bapoxonae Andrés peweicho capona, Simón capoinchi ichaxota Jesús uncua. Poxonae Jesús tane xua poxonae Simón tainchi, jeye: —Xam Simón Juan pexanto tatsim. Ichitha xam anoxuae newʉn Cefas tsane, barapo wʉn Cefas wʉn jei: ‘Iboto’, jei, jei Jesús. Seicaya griego jume wʉn ‘Pedro’, jei barapo wʉn irʉ jei: ‘Iboto’, jei. ");
INSERT INTO cui_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Bapoxonae icha mataqueitha Jesús ichichipa xua peponaewa Galilea nacua beya. Bapoxonae Jesús, Felipe caxinatsi, yawa jeichichi: —Nepuna ponde, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Barapon Felipe Betsaida tomarapin, po tomaratha irʉ Andrés popona irʉ Pedro. ");
INSERT INTO cui_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nexata Felipe Natanael wenaweneichi, yawa Felipe barai bapon, jeye: —Pebin pacaxinan, pon bayatha Moisés yabara tsiwʉnae cui tina pia peitorobi diwesi jume coyenewatha. Mataʉtano pon bayatha irʉrʉ Nacom peitorobi jume pepaebiwi yabara tsiwʉnae cui tina. Bapon apara Jesús, José pexanto tatsi. Bapon Jesús pon Nazaret tomarapin, jei Felipe. ");
INSERT INTO cui_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael jeye: —Dapon pebin pon pejʉntʉ coyene xanepanaein Nazaret tomara weya bapana jopa ponae. Tsipei daxita barapo tomarapiwi apara peajʉntʉcuiruyapubewi, jei Natanael. Felipe jume barai, jeye: —Anetha incane matha taema, jei Felipe. ");
INSERT INTO cui_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Poxonae Jesús tane xua Natanael imoxoyo caquita pona, Jesús jeye: —Patopa pebin pepa israelmonaepin, pon jopa jiwi pemuxuitorobin, pon xaniwaicha pejume cowʉntsin Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nexata Natanael Jesús yainyabatsi. Natanael jeye: —¿Eta ichim xua taneyaitaewam? jei. Jesús jume nota, jeye: —Bayatha catainchi poxonae higuera nae tabacatha uncuame poxonae cataunxuae Felipe jopa cawabiyo, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Bapoxonae Natanael jume nota, jeye: —Pon jiwi Necuidubim. ¡Apara xam bara Nacom Pexantom! ¡Apara bara xam Israel nacuamonae itorobiya pia pepa Neewatsim! jei Natanael. ");
INSERT INTO cui_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús jume nota, jeye: —Xam nejume cowʉntame poxonae xua saya catsipaebatsi xua cacataewatsi higuera naetha. Ichitha bexa necotsiname xua exanaein pocotsiwa pexeinya peitʉpanae tsita itʉtsiwan, beyacaincha xua saya aunxuae catsipaebatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Equeicha Jesús jeye: —Xaniyan paca tsipaebatsi paxam pataename xua Nacom peitaboco saranaxuicaena. Mataʉtano pataename matatsunpiwi xua jujuneibicaena xote tsique taxantha pia taneyawenaetsi. Mataʉtano pataename xua equeicha caibe jujuneibiyaena taxainya weicha, ponxaein Nacom Tananeitapetsin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Poxonae acoibi po matacabibe yapucaewa, bapoxonae irʉrʉ pexaewa tsinacaetuta Caná tomaratha xua Galilea nacuatha xua pebin pecotsiwa pepichixae. Jesús pena tatsi irʉ baxota natane pewabixaetsi. ");
INSERT INTO cui_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Irʉ Jesús wabatsi, irʉ pijimonae tatsi wabatsi xua penaponaewa tsane barapo pexaewa petsinacaetutsiwatha xua poxonae pebin pecotsiwa pita. ");
INSERT INTO cui_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Vino mera omeicha mene weranapenta tsipei daxita jiwi apa. Daxota Jesús pena baraichi, jeye: —Nama equeicha ameneibi vino mera omeicha mene weranapenta, jei Jesús pena tatsi. ");
INSERT INTO cui_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús jume nota, jeye: —Ena, abʉ bexabʉ abʉ jopa yabara neyainyabinde baxua. Canta daxua aichica xua petsita itʉbiwa taexanaewa, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bapoxonae barapowa barai pomonaetha pomonae pexaewa carena tsaibi, jeye: —Moya paexande xua pocotsiwa bapon paca itoroba, jei barapowa. ");
INSERT INTO cui_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Baxota iratha ena seis po juruwatobe sayawan. Barapo pin juruwaton barompaya cae juruwatontha tsiniya cincuenta po mera bosibʉ matabʉxʉyobe tutu canaʉpa. Icha juruwatontha tsiniya setenta po mera bosibʉ matabʉxʉyobe tutu canaʉpa. Barapo juruwatontha ba judiomonae mene yaebeiba xua barapo merantha penacobe quiateibinexa xua daxota jopa Nacom petsita najʉntʉ coyene taxobeibinexatsi. ");
INSERT INTO cui_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pomonae pexaewa carena tsaibi barapomonae Jesús barai, jeye: —Barapo saya juruwatontha pawʉnbare mera, jei. Bapoxonae barapomonae barapo juruwaton wʉnba. ");
INSERT INTO cui_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Bapoxonae Jesús barai, jeye: —Anoxuae barapo juruwaton tsiwixi pajiwana mene wenore xua po mera equeicha vino mera exanan. Pacaponare pontha pexaewa mata canabane, jei Jesús. Daxota barapomonae bara baxua exana xua Jesús peitorobixae. ");
INSERT INTO cui_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pon mata canabane pexaewa, bapon mene pana barapo vino mera, po vino mera copiya saya mera. Ichitha bapon jopa yabara yaputaeyo xua barapo vino mera xua eta werena metha mene capona. Saya meisa pomonae mene eepacapona barapo juruwatontha barapomonae yaputane xua barapo juruwatontha jiwana mene nota xua po mera vino mera naexana. Bapoxonae pon mata canabane pexaewa waba, pon pecotsiwa pita bapon wabatsi. ");
INSERT INTO cui_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Bapon barai, pon pecotsiwa pita baraichi, jeye: —Daxita jiwi ba poxonae aena copiya matha apata po vino mera mene xeica. Poxonae jiwi ba wenaxuba po vino mera xeica, bapoxonae ba barapo jiwi ba equeicha apatatsi po vino mera be conotha xaexaeca. Ichitha nama xam icha coyene exaname. Po vino mera be conotha mene xaexaeca matha copiya apatame jiwi barapo vino mera. Poxonae barapo vino mera jiwi wenaxuba po vino mera be conotha mene xaexaeca bapoxonae apatame po vino mera bichocono xeica, jei bapon. ");
INSERT INTO cui_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Baxua xua Jesús exana Caná tomaratha xua Galilea nacuatha. Barapo pexeinya petsita itʉtsi coyenewa poxonae xua aena copiya matha exana pia peayapusʉwatha. Poxonae baxua Jesús pijimonae cui tainchi, Jesús jume cowʉntatsi pijimonae. ");
INSERT INTO cui_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Poxonae baxua pexaewa najain weta bapoxonae Jesús pona Capernaum tomara beya. Bapon pena barʉ pona yawa peweicho jiwi barʉ pona, mataʉtano pijimonae barʉ pona. Baxota Capernaum tomaratha daxita Jesusbarʉ be caentacabiyobe ena. ");
INSERT INTO cui_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tsipei poxoru imoxoyo barapo matacabi tsaneba xua Pascua wʉn matacabin daxota Jesusbarʉ Jerusalén tomara beya pona. Barapo Pascua wʉn matacabin, po matacabin poxonae judiomonae yabara nanta xeina xua pinae caena bayatha pia pamo susato jiwi tatsi panenebiya Egipto nacua weya. ");
INSERT INTO cui_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Baxota Jesús caxina Nacom pin pia botha pomonae baxota caenaeta buey duweimonae, yawa ovejamonaeno yawa topibomonae caenaetano. Mataʉtano Jesús tane xua pomonae ena pexaethopaewantha ichaxota paratixi nantiya nacatsiba jiwi. ");
INSERT INTO cui_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Poxonae Jesús tane barapomonae, Jesús bapoxonae exana xua pocotsiwa xota cuainta xua duwein perʉ mʉto. Daxita barapomonae Jesús Nacom pin pia bo wenapuna torobabiya. Yawano Jesús muxuna itaweta xua barapomonae piawanxae, bueymonaeno, ovejamonaeno. Pomonae xua ena pexaethopaewantha xua ichaxota nantiya nacatsiba paratixi Jesús iratha tabebai paratixi, yawa irabe tayebabareca torobabiya pexaethopaewan. ");
INSERT INTO cui_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Pomonae baxota caenaeta topibo, Jesús barai barapomonae, jeye: —¡Daxita baxuan panore barapo Nacom pin pia bo weya pocotsiwan pacaenaetame! ¡Barapo Nacom pin pia bo jopa pacana exanaeinde xua be pocotsi bo jiwi ichaxota caenaeta pexaewa! jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Bapoxonae Jesús pijimonae tatsi yabara jume cui nanta xeinarʉcʉpa xua Nacom Pejume Diwesitha namchi xua Cristo yabara jeichichi xua jeye: “Yabara nejʉntʉ coyene yʉca xua yabara nanta xeinan xua pocotsiwa Taxa pia pin pia botha tatsi xeina. Daxota jiwi necaseba”, jei Nacom Pejume Diwesitha xua Cristo yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nexata judiomonae Jesús yainyabatsi, jeye: —¿Eta po pexeinya petsita itʉtsi coyenewa pana netsita itʉtsiname? Bapoxonae xain payaputaein xua bara cou xam deta xeiname Nacom pia peitorobi coyenewa tatsi xua daxota jiwi cui itawetame Nacom pin pia bo tatsi weya, jei. ");
INSERT INTO cui_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús jume nota, jeye: —Icha barapo bo weraweraca paexanaename, equeicha acoibi po matacabibetha beta caewa xanebin, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nexata barapo judiomonae Jesús tsipaebatsi, jeye: —Jiwi barapo Nacom pin pia bo tatsi acaba ainya wei, cuarenta y seis po weibetha nacobe weta. ¿Eta pocotsiwa baxua paebame xua jinya saya acoibi po matacabibetha equeicha wʉnae exanaetsi? jei judiomonae. ");
INSERT INTO cui_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Po bo xua Jesús yabara paeba apara xua nayabara paeba pia pepon. ");
INSERT INTO cui_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Daxota poxonae Jesús equeicha asʉ juina petʉpae cuariyatha Jesús pijimonae yabara jume cui nanta xeinatsi xua bayatha Jesús paeba. Daxota jume cowʉnta Nacom Pejume Diwesi. Yawano Jesús jume cowʉntatsi pocotsiwa xua paeba. ");
INSERT INTO cui_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Poxonae Jesús Jerusalén tomaratha popona xua Pascua wʉn matacabintha bapoxonae pin bicheitomonae Jesús jume cowʉntatsi. Daxota barapo bicheiton jume cowʉnta tsipei tane Jesús pia pexeinya petsita itʉtsi coyenewan tatsi. ");
INSERT INTO cui_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús jopa yabara jume cowʉntsiyo barapomonae bequein jume cowʉntatsi taetha. Tsipei Jesús daxita jʉntʉ coyene yaputane jiwi xua ainya jʉntʉ coyene pexeinaewa. ");
INSERT INTO cui_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Daxota jopa nantawenonaeyo xua ichamonae Jesús petsipaebiwatsi icha jiwi yabara. Tsipei bapon Jesús daxita jʉntʉ coyenein yaputane jiwi. ");
INSERT INTO cui_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Irʉrʉ pebin popona pon fariseomonaepin, pon pewʉn Nicodemo. Bapon judiomonae canamataxeinatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bapon Nicodemo merawi Jesús siwa poinchi, yawa Jesús jeichichi: —Pon jiwi Necuidubim, bara paxan payaputan xua Nacom caitoroba xua jinya pata tanecuidubiwam tsane. Tsipei ichʉn jopa itacʉpaetsi xua pexeinya petsita itʉtsi coyenewan peexanaewa Nacom pia peayapusʉwatha tatsi icha Nacom jopa yantsiyo bapon icha be xua poxonae ichim poxonae xua exaname Nacom necayantsixae, jei Nicodemo. ");
INSERT INTO cui_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nexata Jesús Nicodemo jume notatsi, Jesús jeye: —Xaniyan catsi paebatsi. Pon equeicha jopa caewa naexanaeyo xua pena jiton penaexanaenexa, bapon jopa itacʉpaetsi xua Nacom piamonae tatsi penaexanaewa pomonae Nacom itorobiya peewatsixae, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo Jesús jume epa notsiya yainyabatsi. Nicodemo jeye: —¿Eta bichi xua pebin pon bayatha pinyo xua equeicha caewa pena jiton naexana? ¿Metha bara itacʉpatsi xua pena equeicha tsiperʉ wepatopa xua equeicha caewa penaexanaenexa pena jiton? jei Nicodemo. ");
INSERT INTO cui_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús jume nota, jeye: —Xaniyan catsipaebatsi. Pon meratha jopa bautisabichi xuano xua icha jopa xeinaeyo Nacom pia Pejumope tʉnaxʉ tatsi po jumope tʉnaxʉ bapon icha jʉntʉ coyene xeina pecana exanaenexatsi, bapon jopa itacʉpaetsi xua Nacom piamonae tatsi penaexanaewa pomonae Nacom itorobiya peewatsixae. ");
INSERT INTO cui_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pomonae pena jiwi tsiperʉ wenaexana bara jiwi coyeneya yacuiya naexana. Pomonae naexana Nacom piamonae tatsi barapomonae Nacom pia Pejumope tʉnaxʉ tatsi cana exana xua barapomonae pexeinaewa icha jʉntʉ coyene. Barapomonae yacuiya naexana Nacom piamonae tatsi tsipei exana pocotsiwa Nacom pia Pejumope tʉnaxʉ tatsi itoroba. ");
INSERT INTO cui_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jopa najʉntʉ coyene cabenaecaeinde xua tacatsipaebiwatsi xua tacajeiwatsi: ‘Daxita jiwi bewa pena jiwi naexanae equeicha’, tacajeichiwatsi xua. ");
INSERT INTO cui_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Joibo ba pona ichaxota ichichipa peponaewa. Joibo busi taneme, ichitha jopa yaputaem xua ichaxota weponarena, yawa jopa yaputaem xua xota ponaena. Icha jiwi ichi xua jopa taeyo joibo ichitha tane xua joibo bubujei barichi jiwi jopa taeyo Nacom pia Pejumope tʉnaxʉ tatsi. Saya jiwi yaputane xua icha jiwi jʉntʉ coyene xeica cana exainchi barapo Nacom pia Pejumope tʉnaxʉ tatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nexata Nicodemo equeicha Jesús yainyabatsi, jeye: —¿Eta metha bichi Nacom pia Pejumope tʉnaxʉ tatsi? jei Nicodemo. ");
INSERT INTO cui_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús jume barai, Nicodemo jume baraichi, Jesús jeye: —Xam pon daxita neyaputaein israelmonae pexantha tatsi yawa pon jiwi necuidubim barapomonae pexantha tatsi. Bequein barapo jitom ichitha jopa baxua yabara yaputaem xua tacatsipaebiwatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xaniyan catsipaebatsi xua paxanbe, Juan, pon jiwi Pebautisabin, irʉ xan Jesús paca tsipaebatsi xua pocotsiwan payaputanbe. Mataʉtano paxanbe bara yatsicaewa pata paebinbe xua patanbe bayatha. Ichitha paxam pomonae judiomonae pam jopa yabara pana nejume cowʉntsim pocotsiwa paxanbe paca tsipaebatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Icha jopa pana nejume cowʉntsim pocotsiwan xua barapo cae pin nacuathe yabare paca tsipaebatsi bara paichim jopa pana nejume cowʉntsipaem icha yabara paca tsipaebichipatsi pocotsiwan Nacom pia peitorobi nacua beicha tatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Dapon aibi pon peitaboco beicha pona Nacom beicha xua equeicha caewa patopeica bara wetsica. Daxota jiwi jopa yabara yaputaeyo Nacom pia peitorobi nacua beicha tatsi. Saya meisa jame xan ponxaein Nacom Tananeitapetsin patopeican tanacua wetsica daxota yabara yaputan Nacom pia peitorobi nacua beicha tatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Caena bayatha ira xuepana susato tsurucuae nacuatha, pinmonae werapa poxoru jomon sinebatsi. Daxota Moisés penainto asiya duta xua be jomo canaxobiya exana. Pomonae jomon sinebatsi, poxonae barapomonae tane barapo penain jomo, bapoxonae jopa werapaeyo. Icha Moisés ichi bara neichi tsane jiwi. Xan ponxaein Nacom Tananeitapetsin, ichamonae asiya naetotha tʉparucua neexanaena. Barichi tsane pomonae yabara nejume cowʉntsina po coyene xua xan naetotha tatsitʉpaewa tsane xua barapomonae abe pia peexanae cuiru coyenein tatsi, barapomonae jopa weraweracae tsane. Barapomonae xeinaena peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa ataya tsiteca”, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Equeicha Jesús nayabara paeba poxonae Nicodemo tsipaebatsi. Jesús jeye: “Nacom antobe bichocono daxita carepaya jiwi xua barapo cae pin nacuathe. Daxota Nacom Pexanto itoroba pon yatsicaya compa tatsi. Pon Nacom Pexanto tatsi jume cowʉntatsi, bapon jopa weraweracae tsane. Bapon peajʉntʉyapusʉwa xeinaena, po peajʉntʉyapusʉwa ataya tsiteca. ");
INSERT INTO cui_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nacom Pexanto jopa itorobicaeyo xua saya barapo cae pin nacuepiwi atene peexanaenexatsi xua penatsicuentsixae xua abe peexanaexae Nacomtha. Saya apara jame Nacom Pexanto itorobica xua jiwi pecapanenebiyaenexatsi penatsicuentsiwa weya. ");
INSERT INTO cui_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Pon Nacom Pexanto tatsi yabara jume cowʉntatsi, bapon jopa Nacom tsitatsi xua atene peexanaewa tsainchi xua penatsicuentsixae xua abe peexanaexae Nacomtha. Ichitha nama pon Nacom Pexanto tatsi jopa yabara jume cowʉntsichi bapon Nacom bayatha tsitatsi xua atene peexanaewatsi tsainchi xua penatsicuentsixae jopa peyabara jume cowʉntsixaetsi Nacom Pexanto tatsi, pon bara compa. ");
INSERT INTO cui_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pomonae jopa Nacom Pexanto tatsi yabara jume cowʉntichi, barapomonae Nacom bayatha tsitatsi xua atene peexanaewatsi xua penatsicuentsixae xua abe peexanae cuiru coyenein peexanaexae. Tsipei poxonae Nacom Pexanto tatsi patopeica po cae pin nacuathe tsique, barapomonae ichichipa exana abe peexanaewan beyacaincha xua peexanaewa pocotsiwa Nacom itoroba. ");
INSERT INTO cui_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tsipei daxita pomonae abe peexanaewi barapomonae Nacom Pexanto tatsi aichaxaibichi daxota jopa imoxoyo caquita ponaetsi bapon. Barapomonae jopa ichipaeyo xua peyaputaewatsi, xua Nacom Pexanto tatsi peyaputaewa xua pocotsiwa barapomonae abe exana. ");
INSERT INTO cui_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ichitha pomonae pejume cowʉntsiwi, pomonae yatsicaewa beta xanepanaya exana, barapomonae Nacom Pexanto tatsi imoxoyo caquita poinchi. Tsipei barapomonae ichichipa xua peyaputaewatsi xua Nacom Pexanto tatsi peyaputaewa tsane xua pocotsiwa barapomonae wʉnae peexanaexae, xua pocotsiwa Nacom peitorobixae”, jei Jesús Nicodemotha poxonae nayabara paeba. ");
INSERT INTO cui_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Poxonae Jesús najume weta xua poxonae Nicodemo tsipaebatsi, bapoxonae pirapae Jesús pijimonae barʉ pona Judea nacua beya. Barapo nacuatha Jesús ainya matacabintha pijimonae barʉ popona. Mataʉtano baxota Jesús pijimonae cui itoroba xua jiwi pebautisabiwa tsainchi. ");
INSERT INTO cui_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Irʉrʉ Juan bautisaba jiwi Enón tomaratha, po tomara eca ichaxota imoxoyo po tomara pewʉn Salim. Tsipei baxota menein nawita. Pinmonae Juan itata patatsi, yawa Juan bautisaba barapomonae. ");
INSERT INTO cui_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Juan baxua pewʉnaeya exana xua poxonae jiwi pecʉbi botha etatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bapoxonae pomonae Juan pia pepuna jinompaewichi tatsi irʉ judiomonaeno, barapomonae yabara barʉ najume matsontsonobatsi pebautisabi coyenewa. ");
INSERT INTO cui_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Barapomonae Juan siwa poinchi xua Juan yabara peyainyabinexa tsainchi baxua. Jeye Juantha: —Pon jiwi Necuidubim, incane matha taema. Pon caniwi cabarʉ popona Jordán mentha xua icha muxunene beya, pon bayatha yabara pana netsipaebame, bapon nama anoxuae bautisabauya jiwi yawa bapon puna poinchi daxita jiwi, jei Juan pijimonae tatsi xua Jesús yabara paebatsi. ");
INSERT INTO cui_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Nexata Juan barai barapomonae, jeye: —Jiwi ba jopa xeinaeyo icha Nacom jopa catsiyo. ");
INSERT INTO cui_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Paxam bara yatsicaewa pana nejume taneme xua paca jeichi: ‘Xan dapon aibin Mesías’, jan. ‘Apara bapon pia pewʉnaeya tatsi Nacom neitoroba’, jan. ");
INSERT INTO cui_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Poxonae ba pebin pecotsiwa pita bapon pona yabʉyo pia botha tatsi. Pon piowa pepichixae bapon pia jiton tatsi bichocono jʉntʉ coyene weiweina xua bapon piowa pepichixae poxonae jume taeuncua xua pia jiton tatsi piowa pita. Icha pebin cana ichichi pia jiton, bara jʉta ichin Jesucristotha anoxuae. Bichocono jʉntʉ coyene weiweinan tsipei daxita jiwi Mesías puna poinchi. ");
INSERT INTO cui_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Bapon bewa mataropeicha ainya cui naexanaponae jiwi peitʉtha tatsi. Xan bewa jopa ainya cui naexanaponaein tsane jiwi peitʉtha tatsi, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Equeicha Juan piamonae barai, jeye: —Pon peitaboco wetsica pona, bapon jame bichocono peyaputaein beyacaincha xua ichamonae. Pon xua po irathepin bapon apara saya jiton. Bapon saya yabara cueicueijei pocotsiwa po irathe yabara. Ichitha pon peitaboco wetsica pona, bapon daxita canamataxeina. ");
INSERT INTO cui_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Bapon bequein jiwi yabara tsipaebatsi pocotsiwa xua bayatha tane peitabocotha, xuano xua pocotsiwa bayatha jume tane peitabocotha, ichitha jiwi jopa jume cowʉntsiyo pocotsiwa bapon paeba. ");
INSERT INTO cui_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Icha pebin jume cowʉnta pocotsiwa paeba pon peitaboco wetsica peponaexae xua Nacom yabara paebatsi, barapon tsita itapeinya xeina ichamonaetha, xua apara Nacom bara xaniwaicha pepaebin. ");
INSERT INTO cui_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pon xua Nacom itoroba bara bapon cueicueijei Nacom pejumein tatsi, tsipei Nacom jopa juniya nacana jumope tʉnaxʉ catsiyo xua bapon peyawenaewa tsainchi. ");
INSERT INTO cui_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nacom bichocono antobe Pexanto. Pexanto cata peayapusʉ itorobi coyenewa xua bapon daxitan pecanamataxeinaewa tsane. ");
INSERT INTO cui_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pon Nacom Pexanto tatsi yabara jume cowʉntinchi, bapon peajʉntʉyapusʉwa xeinaena, po peajʉntʉyapusʉwa jopa bapana weraweracaeyo. Ichitha pon Nacom Pexanto tatsi jopa yabara jume cowʉntichi, bapon jopa xeinae tsane barapo peajʉntʉyapusʉwa. Nama bapon Nacom cana exanaena xua bapon bichocono atene peexanaewa tsainchi, jei Juan. ");
INSERT INTO cui_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesús jume tane xua jiwi tsipaeba fariseomonaetha xua jeye: “Jesús pinmonae xeina, pomonae pia pepuna ponaewichi. Jesús toxeinchiya jopa juniya bautisabiyo jiwi beyacaincha xua poxonae Juan bautisaba jiwi”, jei jiwi fariseomonaetha. ");
INSERT INTO cui_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Daʉmetha Jesús apara jopa bautisabiyo. Apara jame Jesús pijimonae tatsi bautisaba jiwi.) ");
INSERT INTO cui_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Poxonae Jesús jume yaputane xua jiwi paeba fariseomonaetha, bapoxonae Jesús pijimonae Judea nacua webarʉ warapiya. Caibeya warapa Galilea nacua beya. ");
INSERT INTO cui_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Poxonae warapa Galilea nacua beya bewa ponaena ichaxoyo Samaria nacua iya, tsipei namto baxoyo ducuiya. ");
INSERT INTO cui_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Bapoxonae Jesús pijimonae barʉ patopa Sicar tomaratha, po tomara eca Samaria nacuatha. Barapo tomara, Sicar tomara eca ichaxota imoxoyo po iriyo caena bayatha Jacob pexanto cata. Barapo Jacob pexanto tatsi pewʉn José. Jacob irʉ pexanto tatsi caena bayatha tʉpabe. ");
INSERT INTO cui_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Barapo iriyotha mene mʉthʉ eca, barapo mene mʉthʉ pewʉn, “Jacob pia mʉthʉ”, jei. Tsipei Jesús natsepapona namto dena, tsipei tajʉ werena pona, daxota barapo mene mʉthʉ mʉxʉbʉrʉtha ecopa. Mataʉtano bapoxonae mateinyaxae tsuxubi irʉ. ");
INSERT INTO cui_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Irʉ bapoxonae Jesús pijimonae tatsi tomara be-iyiya pecomocaenexa pexaewa. Barapomonae pecoutha tatsi yabʉyo Samaria nacuapiwayo patopa ichaxota Jesús po mene mʉthʉ mʉxʉbʉrʉtha eca. Jesús barai bapowa, jeye: —Mera necare, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Bapoxonae barapo Samaria nacuamonaepiwayo Jesús jume notatsi. Barapowa jeye: —¿Eta pocotsiwa metha mera nebarʉ ununame? Apara judiomonaepim irʉ xan apara Samaria nacuamonaewayon, jei. Barapowa baxua paeba tsipei judiomonae irʉ Samaria nacuamonae daxita barapomonae jopa naita coxonaeyo. ");
INSERT INTO cui_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nexata Jesús jume nota, jeye: —Icha xam yaputaetsipame xua pocotsiwa Nacom cata jiwitha, yawa icha neyaputaetsipame pon aunxuaein mera cawʉcatsi, bapoxonae jame newʉcaetsipame mera, xua icha mera, po mera jiwi peajʉntʉyapusʉwa xeina cana exainchi, po peajʉntʉyapusʉwa jopa bapana weraweracaeyo, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Bapowa Jesús jume notatsi, jeye: —Pon jiwi Necanamataxeinaem, apara jopa xeinaem xua xota mene capatame. Yawa po mene mʉthe apara tajʉ deca. ¿Jinya exota po mene boca inta mene capitichi, po mera jiwi ajʉntʉyapusʉ exainchi? ");
INSERT INTO cui_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Barapon Jacob pata tamo susatopin pana cata barapo mene mʉthʉ. Bapon barapo mene mʉthʉ mene capaneiba peapeibinexa, irʉ pia pexui tatsi mene capaneiba xua peapeibinexa, mataʉtano mene capaneiba peapateibinexa pia duweimonaein. ¿Metha bara Jacob toxeincha ainya cuim, beyacaincha bapon? jei bapowa. ");
INSERT INTO cui_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús jume nota, jeye: —Daxita pomonae xua po mene mʉthʉthe mene capaneiba xua peapeibinexa equeicha meratsipouneibina. ");
INSERT INTO cui_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ichitha pon apa xua po mera catan, bapon equeicha jopa caewa meratsipae tsane. Barapo mera icha ira bʉpana mene ichi xua epatoya mene jujuina poxoru bichocono ira bʉxʉpana mene nayʉca. Barichi po coyene xua cacatinchi barapo coyene cajʉntʉ coyene yʉca cacana exanaena, bapoxonae xeinaename peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa xua ataya tsiteca, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nexata bapowa Jesús jume notatsi, bapowa jeye: —Pon jiwi Necanamataxeinaem, dapo mera necare xua jopa caewa tameratsipouneibiwa tsane yawa xua equeicha po mene mʉthʉthe jopa tapateibiwa tsane xua mera tacapanathopeibinexa, jei barapowa. ");
INSERT INTO cui_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús jume nota, jeye: —Moya matha iyande, matha jinseuri wabare. Nexata bapoxonae xote papatoparebe, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Bapowa jume nota, Jesús jume notatsi, jeye: —Taseuri apara jopa xeinaeinyo, jei. Nexata Jesús jume barai, jeye: —Bara xainyeya paebame poxonae jam, ‘Taseuri jopa xeinaeinyo’, jam. ");
INSERT INTO cui_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tsipei caena bayatha cinco poyobe pebiwi punaxubame. Pon xua anoxuae barʉ poponame, apara jinseuri aibi. Poxonae paebame baxua bara xainyeya paebame, bara jopa naerabim, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Barapowa poxonae Jesús baxua jume tainchi barapowa jeye: —Pon jiwi Necanamataxeinaem, bara catainchi xua xam apara pon Nacom peitorobi jume nepaebim. ");
INSERT INTO cui_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pata tamo susato jiwi, Samaria nacuamonaepiwi, barapomonae wʉnae jainteiba Nacom xote po demxuwathe. Ichitha paxam judiomonae pam, papaebame xua pinae bewa jiwi wʉnae jainteibina Nacom bomʉxʉtha po bo uncua Jerusalén tomaratha po bo Nacom pin pia bo tatsi, jei barapowa. ");
INSERT INTO cui_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús jume nota, jeye: —Yabʉyo moya yabara nejume cowʉnde xua tacatsipaebiwatsi. Tsipei barapo matacabi imoxoyo patopaena, po mataqueitha xua wʉnae pajainteibiname Nacom. Nama jopa painya nenantawenonaewam tsane xua painya neponaewa, po demxuwathe yawa Jerusalén tomara beya xua wʉnae painya nejainteibiwa tsane Nacom. ");
INSERT INTO cui_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Paxam Samaria nacuamonae pam, jopa payaputaem pon wʉnae pajainteibame. Paxan nama judiomonae pan payaputan pon wʉnae pajainteiban, tsipei pon pecapanenebiyaein jiwi apara bapon judiomonae jiwanapin. ");
INSERT INTO cui_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ichitha anoxuae nama patopa po mataqueitha poxonae pomonae xaniwaicha wʉnae pejainchiwa Nacom, barapomonae icha coyene cuitha Nacom wʉnae jaintinchi, xua barapomonae pia Paxaxae tatsi. Barapomonae xaniwaicha pia pejʉntʉ coyenewatha wʉnae jainchina Nacom. Tsipei Nacom baxua ichichipa xua wʉnae pejainchiwatsi xua jiwi wʉnae pejainchiwa pejʉntʉ coyenewatha. ");
INSERT INTO cui_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nacom pejʉntʉ coyene xanepanaein pon peinya jumopein. Daxota pomonae Nacom wʉnae pejainchiwatsi, barapomonae bewa xaniwaicha pejʉntʉ coyenewatha wʉnae jainchina Nacom, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Barapowa jume nota, jeye: —Yaputan xua patopeicaena pon pewʉn Mesías, (xua pon icha wʉn “Cristo” baraichi). Poxonae bapon patopeicaena daxita yabaran pana necuidubina, jei bapowa. ");
INSERT INTO cui_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús jume nota, jeye: —Apara xan bapon, pon aunxuaein catsipaebatsi, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Bapoxonae equeicha Jesús pijimonae tatsi pata. Daxita barapomonae yabara najʉntʉ cui coyene cabenaeca xua Jesús tsipaeba Samaria nacuamonaewayo. Ichitha dapon aibi xua pon pejeiwa Jesustha, “¿Eta xua metha jinya xuatsi? ¿Eta pocotsiwa metha bapowa tsipaebame?” xua pon pejeiwa. ");
INSERT INTO cui_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nexata bapowa juruwato cuenta iya tomara be-iya, nainya yacuinaya iya. Bapowa jiwi tsipaeba, jeye: ");
INSERT INTO cui_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Anetha, pataema pebin ichaxota mʉthʉ mene. Bapon yabara netsipaeba daxita pocotsiwa bayatha caena exanan. ¡Apara bapon metha Mesías! jei bapowa. ");
INSERT INTO cui_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bapoxonae jiwi tomara we-iyiya peponaenexa ichaxota Jesús popona. ");
INSERT INTO cui_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Irʉrʉ Jesús pijimonae jume daunweya baraichichi, jeye: —Pon Patatanecuidubim, matha xaema, jeichichi pijimonae. ");
INSERT INTO cui_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús jume barai pijimonae, jeye: —Xan xeinan pexaewa, po pexaewa jopa payaputaem, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jesús pijimonaexae tatsi nexata bara caemonae nayainyaba, jeye: —¿Metha bara ichʉn Jesús apatatsi pexaewa? najei barapomonae. ");
INSERT INTO cui_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ichitha Jesús pijimonae jume barai, jeye: —Icha pebin ichi xua bewa nabanaena, barichin xan bewa exanaein pocotsiwa Nacom ichichipa pocotsiwa bapon tana necui itorobixae. Mataʉtano bewa nacui wetsin Nacom pia penacuichiwa tatsi xua tana neitorobixae. Daxota xua bapoxonae tanejʉntʉ coyene yʉcaewa tsane be poxonae pebin xua pexaewa una tonsana. ");
INSERT INTO cui_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Paxam ba pajam: ‘Abʉ cataunxuae cuatro po xometobe yapu seica pabitha xua pexaewa penawetsiwa tsane’, ba pajam. Ichitha nama paca jeichi: ‘Pataema bayatha pexaewa naweta xua pabitha’, paca jeichichi. Barapocotsi jʉta coyeneya paca jeichi: ‘Jiwi barapo cae pin nacuathe bayatha najʉntʉ cui coyene wʉnaetaba xua pejume taenexa Nacom Pejume Diwesi xua pejume cowʉntsinexa’, paca jeichi. ");
INSERT INTO cui_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Catsibin pomonae tamonaexae pocotsiwa xua pematomatsiwa xua inta ichamonae peyawenaexaetsi xua irʉrʉ be tamonae jiwi penaexanaenexa. Pomonae nejume cowʉnta barapomonae catsibin peajʉntʉyapusʉwa, po peajʉntʉyapusʉwa jopa weraweracaeyo. Tsipei pomonae tajume diwesi pecueicueijeiwi copiya xuano irʉ pomonae tajume diwesi cotacaya xuya yaputane cana exana xua daxota jiwi nejume cowʉnta, daxita barapomonae matabʉxʉyobe nabarʉ jʉntʉ coyene weiweina xua ichamonae nejume cowʉnta pecana exanaexaetsi. ");
INSERT INTO cui_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tsipei po diwesiyo xua tsica diwesiyo, po diwesiyo yabara canaʉta jʉtsiya pepaebiwa bara apara xaniwaicha, po diwesiyo xua ba jeye: ‘Ichʉn ʉba, irʉ ichʉn xuya jota poxonae naweta’, xua jei po diwesiyo. ");
INSERT INTO cui_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Paca itorobatsi xua inta payawename jiwi xua tajiwimonae penaexanaenexa xua po coyene jopa pacata ayapubeyo xua poxonae paexaname baxua. Baxua paexanaename bequein bara jopa dapomonae pam pocotsimonae copiya tajume diwesi paeba barapo jiwitha. Jame paxam apara barapomonae pam, xua xuya cotacaya yaputane pacana exaname barapo tajiwimonae. Baraxua icha be poxonae ichi poxonae ichʉn xuya jota cotacaya poxonae ichʉn copiya ʉba, jei Jesús. ");
INSERT INTO cui_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bapoxonae pin bicheitomonae pomonae barapo tomaratha jinompa xua Samaria nacuatha, Jesús jume cowʉntatsi, tsipei barapo petsiriwa pejeixae: “Bapon Jesús yabara netsipaeba daxita pocotsiwa bayatha caena exanan”, jei. ");
INSERT INTO cui_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Poxonae barapo Samaria nacuapiwi Jesustha pata, bapoxonae Jesús jume daunweya jeichichi: “Pana barʉ ecare pata tomaratha”, jeichichi. Daxota Jesús ainya matacabibe naeca barapo tomaratha. ");
INSERT INTO cui_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bichocono pinmonae Jesús jume cowʉntaponatsi poxonae jume tane