﻿USE sofia;
DROP TABLE IF EXISTS sofia.cug_vpl;
CREATE TABLE cug_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cug_vpl WRITE;
INSERT INTO cug_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kələ kɔ kiyɛli ki chwɔŋkijuŋ ki bətii Jisɔs Klistus: Jisɔs Klistus nì kɔ waiŋ i chwɔŋkijuŋ ki Ŋkuŋ Dɛbit wə wi nì kɔ waiŋ i chwɔŋkijuŋ ki Ablaham wə. ");
INSERT INTO cug_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaham num tii Ayjik, ayaka Ayjik num tii Yakɔb, Yakɔb num tii Juda bəh bwa bə ba wi, ");
INSERT INTO cug_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ayaka Juda num tii Bɛlɛs bəh Sɛla wə nih wi nì kɔ Tama. Ayaka Bɛlɛs num tii Ɛslɔn, Ɛslɔn num tii Lam. ");
INSERT INTO cug_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lam num tii Aminada, Aminada num tii Nashɔn, Nashɔn num tii Salmɔn. ");
INSERT INTO cug_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmɔn num tii Bɔas wə nih wi nì kɔ Lahab. Bɔas num tii Ɔbɛt wə nih wi nì kɔ Lut. Ɔbɛt num tii Jɛse. ");
INSERT INTO cug_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jɛse num tii Ŋkuŋ Dɛbit. Ŋkuŋ Dɛbit num tii Sɔlɔmɔn wə nih wi nì kɔ kpə Ulia. ");
INSERT INTO cug_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sɔlɔmɔn num tii Lɛhubuam, Lɛhubuam num tii Abija, Abija num tii Asi. ");
INSERT INTO cug_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asi num tii Jɛhushɛfat, Jɛhushɛfat num tii Jɔlam, Jɔlam num tii Usaya. ");
INSERT INTO cug_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya num tii Jɔtam, Jɔtam num tii Ahas, Ahas num tii Ɛsikaya, ");
INSERT INTO cug_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ɛsikaya num tii Manase, Manase num tii Ɛmɔn, Ɛmɔn num tii Jɔsaya. ");
INSERT INTO cug_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jɔsaya num tii Jɛkɔnaya bəh bwa bə nih wi. Bə nì bwɔ bɔ num a bɛsi a twɛsi ka jɔbi wə bəni bə Babilɔn nì kwayi bəni bə Islae tsə bəh bɔ i tumi kibɔ wə i Babilɔn. ");
INSERT INTO cug_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Si yəmaka nì tsə, asi bə nì kwayi bəni bə Islae tsə bəh bɔ i Babilɔn, Jɛkɔnaya num tii Shiltia, Shiltia num tii Sɛlubabɛl, ");
INSERT INTO cug_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sɛlubabɛl num tii Abiud, Abiud num tii Ɛliakim, Ɛliakim num tii Adzu, ");
INSERT INTO cug_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Adzu num tii Sadɔk, Sadɔk num tii Akim, Akim num tii Ɛliyud, ");
INSERT INTO cug_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ɛliyud num tii Ɛliɛsa, Ɛliɛsa num tii Matan, Matan num tii Yakɔb. ");
INSERT INTO cug_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakɔb num tii Yɔsɛf wə nyum Meli, Meli num wə wi nì bwɔ Jisɔs wə bə bɔɔŋki a Klistus. ");
INSERT INTO cug_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ayakadəiŋ, chwɔŋkijuŋ ki bətii Jisɔs kələ nì kɔ jwɔfi ntsɔ bənaa i yisi i Ablaham wə i dzə buku i Ŋkuŋ Dɛbit wə, chu num jwɔfi ntsɔ bənaa i yisi i Ŋkuŋ Dɛbit wə i dzə buku i jɔbi wə bə nì kwayi bəni bə Islae tsə bəh bɔ i Babilɔn. Ayaka i yisi i jɔbi wə bə nì kwayi bəni bə Islae i dzə buku i jɔbi wə bə nì bwɔ Klistus, chwɔŋkijuŋ ki bəba wi num tə jwɔfi ntsɔ bənaa. ");
INSERT INTO cug_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mbwɔ wi Jisɔs Klistus nì nyani i dzəh yələ wə. Nih wi Meli nì kɔ bə kɛiŋsi lɔ a wi bi numki kpə Yɔsɛf. Na ka bə nì nəŋki i ndzɔ wi, yi buku lɔ a wi kɔ bəh tɔɔ i ŋga bi Kiŋ'waka ki Baiŋni wə. ");
INSERT INTO cug_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Si yi num yakadəiŋ, a nì kɔ Yɔsɛf nyuwi num mi wi chəŋ, wi kɔŋ kə i gəmsi wi, ka fasi a ŋgaiŋ ni gaali lə bəh wi i jum wə. ");
INSERT INTO cug_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Si wi nì kɛiŋki wi fasi i fə yakadəiŋ, yi ka num a chinda wi Bah dza dzə i wi i ndəmsi wə i jɔbi wə wi nì nɔki ka dzaka i wi a, “Yɔsɛf, waiŋ Ŋkuŋ Dɛbit, ki lwâ kə i dzɔ̂ Meli ka nih juŋ wa, kɔm tɔɔ wələ wi kwati lə wi kwati num i ŋga bi Kiŋ'waka ki Baiŋni wə. ");
INSERT INTO cug_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wi bi bwɔ lə waiŋ nyukuni, wɔ bi dû yɛli wi a Jisɔs, kɔm wi bi bwiliki lə bəni bu i chu bibɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Gia yələ yichi nì num i fə ka yi dzə kpɛiŋ asi Bah nì dzaka i mi wi ntum wə a, ");
INSERT INTO cug_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mbɛiŋ wɔ̂kɔli, shu wi waiŋkpaŋni widɔkɔ bi num lə bəh tɔɔ, wi bi bwɔ waiŋ nyukuni bə bi bɔɔŋki wi a Ɛmanwɛl.” Yɛli wələ kɔ a, “Nyɔ kɔlə bəh bukumbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Si ndəmsi biələ nɔ wi yakadəiŋ, Yɔsɛf yɔmi i kinu wə ka fə asi chinda wi Bah dzaka i wi. Wi dzɔ Meli ka nih juŋ wi, ");
INSERT INTO cug_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ayakalə bɔ nəki kiəni kə gwu ka mi bəh kpə wi i tsə buku i jɔbi wə Meli nì bwɔ. Si wi bwɔ Yɔsɛf ka du yɛli wi waiŋ a Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bə nì bwɔ Jisɔs i kwili wi Bɛtelɛhɛm wə i kimbu ki Judea wə. A num i jɔbi wə Hɛlɔd nì kɔ ŋkuŋ wi Judea wiwɔ. Yi num a bəni bəmfi bədɔkɔ nì buku i tumi kidɔkɔ wə i kimbu kə wɔŋ bukuki yɛiŋ, dzə i Jɛlusalɛm ka bikəyiki a, ");
INSERT INTO cug_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Ŋkuŋ wi Bəju wə bə bwɔ kɔ i faiŋ a? Buku bikəyiki lə kɔm buku si yɛiŋ jɔŋ wi i kimbu kə wɔŋ bukuki yɛiŋ, ka dzəki i beŋŋ wi.” ");
INSERT INTO cug_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jɔbi wə Ŋkuŋ Hɛlɔd nì wɔkɔ gia yələ, yi nəŋni shɔm yi, nəŋni tasi bəh yi bəni bə Jɛlusalɛm bəchi. ");
INSERT INTO cug_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wi ka bɔɔŋ bətii mfə gia bəmbum bəchi, bəh bəni bəchi bə̀ bɔ nì laniki bənchi bə Nyɔ, bɔ juŋni dzə. Wi bikə i bɔ a, akɔ i faiŋ wə bə nì kaŋaki i bi bwɔ Kimbwili wə Nyɔ nì kaka a? ");
INSERT INTO cug_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Bɔ chukuli i wi a, “Bə nì kɔ i bi bwɔ wi i di bi Bɛtelɛhɛm wə i Judea. Yələ gia kɔ asi mi wi ntum wi Nyɔ nì nyaka a, ");
INSERT INTO cug_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Wɔ Bɛtelɛhɛm i kwili wi Juda wə, kiə wɔ ki kwâka kə a wɔ kɔ fidini finchiŋ nalə i tumi ki Juda wə. Wɔ kîə a mi wi sakani bi bukuki lə i di biələ wə, a num wə wi bi numki i sakaki bəni bəŋ bə Islae.’” ");
INSERT INTO cug_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ŋkuŋ Hɛlɔd ka bɔɔŋ tə bəni bəmfi bə̀ i jum wə jum wə ka kɛiŋsi bikəyi i wɔkɔ i bɔ jɔbi wə jɔŋ wiwɔ si buku. ");
INSERT INTO cug_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Si wi wɔkɔ yakadəiŋ ka chiŋsi bɔ i Bɛtelɛhɛm, ka dzaka a, “Mbɛiŋ tsə̂ kɛ̂iŋsi nə̂ŋ ndzɔŋ waiŋ wiwɔ. Mbɛiŋ ka nəŋ yɛiŋ, mbɛiŋ fîəni dzə̂ fûku i mih, ka mih tə ni tsə beŋŋ wi.” ");
INSERT INTO cug_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Si bəni bəwɔ wɔkɔ, si ŋkuŋ dzaka yakadəiŋ, ka buku dzɔ dzəh yibɔ. Si bɔ nì nyəki, yi ka num a jɔŋ wə bɔ si yɛiŋ i kimbu kə wɔŋ bukuki, wi nyani tsə i bɔ nshiŋ chusi dzəh i bɔ. Wi ka tsə buku i di biə waiŋ wiwɔ nì kɔ, ka num fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Si bɔ yɛiŋ jɔŋ wiwɔ yakadəiŋ, kinsaŋli jikə i bɔ wə nalə, gia yiwɔ ka ndzɔŋki i bɔ nalə. ");
INSERT INTO cug_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Bɔ ka tsə liə i juŋ yə waiŋ wiwɔ nì kɔ yɛiŋ, ka yɛiŋ waiŋ bəh nih wi Meli, ka gwuŋ i waiŋ wiwɔ nshiŋ ka beŋŋ wi. Si bɔ beŋŋ wi ka wɛli biba bibɔ bwili biɛiŋ bi beŋŋni bi Ŋkuŋ ka nya i waiŋ wiwɔ. Biɛiŋ biələ nì kɔ chwaka ki kpɔ ki bɔkɔli bəh ŋkaiŋni wi njiəŋ widɔkɔ bə bɔɔŋ a flaŋkɛŋsins, bəh ŋkaiŋni bifiaŋsi bidɔkɔ bə bɔɔŋ a mɛɛl. ");
INSERT INTO cug_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nyɔ ka kiŋ i bɔ i ndəmsi mə a bɔ ma fîəni tsə̂, i tsə̂ yɛ̂iŋ Ŋkuŋ Hɛlɔd. Bɔ ka fiəni num i dzəh yidɔkɔ wə chi chi i tsə i tumi kibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Si bəni bəmfi bə̀ nì buku i dzəh i tsəki, yi num a chinda wi Bah nì dza dzə i Yɔsɛf i ndəmsi mə ka dzaka i wi a, “Dzâ bɛiŋ dzɔ̂ waiŋ wələ bəh nih wi ma mbɛiŋ bɔ gɛ̂iŋ tsə̂ i tumi ki Ijib wə, ma wɔ nûm fɛiŋ i tsə̂ bûku i jɔbi wə mih bi dzakaki a mbɛiŋ fîəni. Mih dzakaki lə kɔm Ŋkuŋ Hɛlɔd ni nəŋki lə waiŋ wiwɔ i wɔɔ.” ");
INSERT INTO cug_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yɔsɛf ka dza bɛiŋ, dzɔ waiŋ wiwɔ bəh nih wi nchɔkɔ ka gɛiŋ tsə i Ijib, ");
INSERT INTO cug_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ka numki fɛiŋ i tsə buku i jɔbi wə Ŋkuŋ Hɛlɔd nì laka. Yələ nì num lə i fə a yi dzə kpɛiŋ si Nyɔ nì dzaka i dzaka ki mi wi, wi ntum wə a, “Mih bɔɔŋ Waiŋ wuŋ wi buku i tumi ki Ijib mə.” ");
INSERT INTO cug_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jɔbi wə Hɛlɔd ni kiə a bəni bəmfi bə̀ fwɔkyi ŋgaiŋ, yi fə wi bɔksi tɔɔ nalə. Wi ka faaŋ bəni a bɔ tsə i Bɛtelɛhɛm bəh i bimbu biə bi kɔmsiki dzəki fɛiŋ wə bichi, bɔ wɔɔyi bwa bənyuku bə̀ bɔ kɔ i yisi jía yifa wə i shi. Wi nì tsəsi ja yələ biəli asi wi nì bikə i bəni bəmfi bə̀ ka wɔkɔ ndzɔŋ jɔbi wə bɔ nì yɛiŋ jɔŋ wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Bɔ tsə wɔɔyi bwa bəwɔ yakadəiŋ, yi ka dzə kpɛiŋ asi mi wi ntum wi Nyɔ Jɛlimia nì dzaka lɔ a, ");
INSERT INTO cug_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bɔ wɔkɔ wili wi tɔŋni i kwili wi Lama wə, a num mi wi fee bəh mindəm, də kpi. A num Lashɛl si wi dəki bwa bu. Ayaka bə chumsi wi chumsi mɔŋ, kɔm bwa bu chu kɔkə.” ");
INSERT INTO cug_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Asi Ŋkuŋ Hɛlɔd nì laka, yi num a chinda wi Bah nì tumbuku i Yɔsɛf i ndəmsi mə i tumi ki Ijib mə, dzaka i wi a, ");
INSERT INTO cug_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Dzâ bɛiŋ dzɔ̂ waiŋ wələ bəh nih wi ma mbɛiŋ bɔ fîəni chû i tumi ki Islae mə, kɔm bɔ bə̀ bɔ nì nəŋki i wɔɔ waiŋ wələ kpiyi lɔ.” ");
INSERT INTO cug_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yɔsɛf ka dza bɛiŋ dzɔ waiŋ wiwɔ bəh nih wi bəh bɔ ka fiəniki dzəki i tumi ki Islae wə. ");
INSERT INTO cug_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ayakalə, asi wi nì dzəki, wɔkɔ a waiŋ Ŋkuŋ Hɛlɔd Akilius kɔ num wi dzi kiŋgbɔkɔ ki ba wi ka ŋkuŋ wi Judea i sakaki, Yɔsɛf ka lwaki i tsə fɛiŋ. Bə ka chu kiŋ i wi i ndəmsi mə a wi ma mɔ̂m i tsə fɛiŋ. Wi ka ya dzəh tsə num i kimbu ki Galili wə, ");
INSERT INTO cug_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","wi tsə i nɔki i kwili wə bə bɔɔŋki a Nasali. Yi dzə num lə i kpɛiŋni asi mi wi ntum wi Nyɔ nì dzaka lɔ a, “Bə bi bɔɔŋki wi a Mi wi Nasali.” ");
INSERT INTO cug_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","A nì kɔ i jɔbi wiwɔ wə, Jɔn Njulibɔkɔ nì nyə tsə i chwa i kimbu ki Judea wə ka fukuki i bəni a, ");
INSERT INTO cug_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mbɛiŋ kwûni shɔ́m yimbɛiŋ, kɔm ŋkuŋ bi bɛiŋ si num kɔmsi dzə.” ");
INSERT INTO cug_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jɔn wələ kɔ mi wi ntum wi Nyɔ wə Isaya, nì dzakaki kɔm wi i jɔbi wə wi nì dzaka a, “Ja yi mi wiliki i chwa a, ‘Bə kɛ̂iŋsi dzəh yi Bah, bə lûmsi yi a yi nûm chəŋ.’” ");
INSERT INTO cug_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jɔn nì lɔɔki bəmbuŋ num bə kɛiŋsi bəh kiluli ki nyam yidɔkɔ yə bə bɔɔŋki a kamɛl, wi kaŋa bəh chiŋnih num bə kɛiŋsi bəh dzu yi nyam, biɛiŋ bi bidzini nì kɔ chúmi bəh nyu yi chwa. ");
INSERT INTO cug_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Si wi nì fukuki yakadəiŋ, bəni ka bukuki i Jɛlusalɛm bəh i kidi kichi wə i Judea bəh bimbu biə bi kɔmsiki dzəki i Bɔkɔ yi Jɔdan wə bichi, tsə i wi. ");
INSERT INTO cug_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Si bɔ nì tsəki yakadəiŋ də kɔm bə chu bibɔ, wi ka juliki bɔ i Bɔkɔ yi Jɔdan mə. ");
INSERT INTO cug_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ayakalə, jɔbi wə wi nì yɛiŋ si Bəfalasi bəh Bəsadusi bədɔkɔ bəduli dzəki a wi juli bɔ i bɔkɔ, wi dzaka i bɔ a, “Chwɔŋkijuŋ ki fə́kəh, a təfi ndə mbɛiŋ a mbɛiŋ yɔ̂kɔ gɛ̂iŋ shɔm yi lɔli yi Nyɔ yə yi bi dzəki i mbɛiŋ wə a? ");
INSERT INTO cug_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mbɛiŋ fə̂ki gia yə yi chusiki a mbɛiŋ kwuni shɔ́m yimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kiə mbɛiŋ ki dzâkaki kə i gwu yimbɛiŋ wə a, Ablaham kɔ tii wimbɛiŋ. Mih fukuki i mbɛiŋ a Nyɔ kɔlə i fiəni kitəh kələ ki fiəni chu bwa bə Ablaham. ");
INSERT INTO cug_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mbɛiŋ kîəki a, bə kɔ bə jiə lɔ fɔkɔ i chwɔŋ bi kɛiŋ wə. Kɛiŋ yichi yə yi wumki kə mintam mi ndzɔŋni, bə bi gbaki yi i gaaŋ wə, bə kpa i gbuku wə. ");
INSERT INTO cug_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Mih juliki mbɛiŋ i bɔkɔ mə, kɔm mbɛiŋ kwuni lɔ shɔ́m yimbɛiŋ. Ayakalə, mi wə wi dzəki i mih jum wi tsəki lə mih. Na mih kpɛiŋniki kə i giŋ dzu yi yi gvu. Wi bi juliki mbɛiŋ num i Kiŋ'waka ki Baiŋni wə bəh i gbuku wə. ");
INSERT INTO cug_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Wi kaŋa naka i kaŋ i gbəkəki gəŋ yɛiŋ, i yaŋa di biə wi gbəkəki yɛiŋ, i juŋni gəŋ yi i jiə i gba wə, i kɔh chi yiwɔ i kpa i gbuku wə wi bi nyumi kə.” ");
INSERT INTO cug_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Si Jɔn nì juliki bəni i bɔkɔ yakadəiŋ, Jisɔs nyə i kimbu ki tumi ki Galili wə ka dzə i Bɔkɔ yi Jɔdan wə a Jɔn juli tə ŋgaiŋ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ayakalə, Jɔn ka nəiŋki, dzaka i wi a, “A kaŋaki wɔ i juli mih i bɔkɔ, wɔ bə́ dzə lɔ a mih juli wɔ dəiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisɔs chukuli i wi a, “Bee ma yi num yakadəiŋ i liə. Akɔ i dzəh yələ wə buku wɔ ni fə gia yichi yi num chəŋ i Nyɔ nshiŋ.” Ayakadəiŋ, Jɔn ka bum juli Jisɔs i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Asi Jisɔs nì bukuki dzəki i bɔkɔ yakadəiŋ, wi yɛiŋ bɔɔli wɛli gwu, Kiŋ'waka ki Nyɔ shi dzə aka mbumi, dzə num i gwu yi wə. ");
INSERT INTO cug_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yi num, a ja nì dzaka dzə i bɛiŋ a, “Wələ kɔ Waiŋ wuŋ. Wi num shɔm yiŋ. Mih kɔ bəh kinsaŋli nalə kɔm wi.” ");
INSERT INTO cug_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kiŋ'waka ki Baiŋni ka dzɔ Jisɔs tsə bəh wi i chwa a ŋkpɛli mɔmsi wi. ");
INSERT INTO cug_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Wi tsə ka numki fɛiŋ nshi bəh nchɔkɔ bam dzaka i kaŋ wə mbaŋnyani. Asi yəmaka nì tsə dzɔŋ bə́ wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wi wə wi shi kɔ a mɔmsiki bəni ka dzə dzaka i wi a, “Wɔ kabə num waiŋ Nyɔ, dzâka la a kitəh kələ fiəni chu chɔkɔ yi blɛd.” ");
INSERT INTO cug_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jisɔs chukuli wi a, “Yi kɔ num bə nyaka a, ‘Mi nɔki kə a kɔm bə dzɛiŋ shəŋ. Mi nɔki tə kɔm gia yichi yə yi bukuki i dzaka ki Nyɔ wə.’” ");
INSERT INTO cug_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ayakadəiŋ, ŋkpɛli ka dzɔ tsə bəh wi i kwili wi baiŋni Jɛlusalɛm, ka tɔm wi i findɔŋ fi fwu wi juŋ yi fəni yi gia wə, ");
INSERT INTO cug_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","dzaka i wi a, “Wɔ kabə num waiŋ Nyɔ, jə̄ŋ shi la fa, kɔm yi kɔ num bə nyaka a, ‘Nyɔ ni dzaka i bəchinda bu a bɔ tɔkni bəh wɔ.’ Yi chu num bə nyaka a, ‘Bɔ ni kwa wɔ, maka wɔ chɔkɔ gbu wa i təh wə.’” ");
INSERT INTO cug_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisɔs chukuli i wi a, “Bə nyaka tə a, ‘Ma mɔ̂msi Bah Nyɔ wa.’” ");
INSERT INTO cug_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ŋkpɛli chu dzɔ Jisɔs fɛiŋ, tsə bəh wi i fwu wi ŋkwuŋ widɔkɔ wi dəŋə i bɛiŋ nalə, ka chusi kitumi kichi i mbi wələ wə bəh mbum biwɔ yɛiŋ i wi. ");
INSERT INTO cug_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ayaka wi ka dzaka i wi a, “Mih ni nya lə biɛiŋ biələ bichi i wɔ, i jɔbi wə wɔ ka gbɔ i mih nshiŋ kɔksi mih.” ");
INSERT INTO cug_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisɔs chukuli i wi a, “Dzâ nyə̂ fa Satan! Bə nyaka a, ‘Wɔ kɔ̂ksi a Bah Nyɔ wa, ma wɔ nɔ̂mki a wi shəŋ.’” ");
INSERT INTO cug_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ayakadəiŋ, ŋkpɛli ka bee Jisɔs, ka nyə. Yi num a bəchinda bə Nyɔ nì dzə ka tsɛiŋki wi. ");
INSERT INTO cug_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jisɔs ka bi dza wɔkɔ a bə kwa Jɔn Njulibɔkɔ ka fa i juŋ yi nsəŋ mə, wi nyə ka fiəni chu i kimbu ki Galili wə. ");
INSERT INTO cug_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wi tsə buku i Nasali, dza fɛiŋ tsə ka nɔki i kwili wi Kafanaum wə. Kwili wələ num kɔmsi i kinchwɔ kimbum ki Galili wə bəh i kɔmsi tsə i bimbu bi bəni bə Sɛbulun bəh bi Naftali wə. ");
INSERT INTO cug_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Gia yələ nì dzə kpɛiŋ asi mi wi ntum wi Nyɔ Isaya nì dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Kimbu ki Sɛbulun bəh ki Naftali biə bi kɔ kɔmsi i waka wi Bɔkɔ yi Jɔdan wəyaka wə, i nshwaiŋ yi Galili wə i bəni bə̀ bɔ kɔkə Bəju, ");
INSERT INTO cug_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","bəni bə̀ bɔ ni nɔki i jisi wə, bɔ yɛiŋ baiŋni bimbum. Wɔŋ kaka i bəni bələ bɔ ni nɔki i di bi jisi bi kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","I yisi i jɔbi wiwɔ wə, Jisɔs ka yisi i fukuki i bəni dzaka a, “Mbɛiŋ kwûni shɔ́m yimbɛiŋ, kɔm ŋkuŋ bi bɛiŋ si num kɔmsi dzə.” ");
INSERT INTO cug_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisɔs bi nyə ka nyaniki tsəki i kinchwɔ kimbum ki Galili kpəŋ, ka yɛiŋ bəni bədɔkɔ bəfa, num mi bəh waiŋnih wi. Bəni bələ nì kɔ Samɔn wə bə nì bɔɔŋki a Bita, bəh waiŋnih wi Andulu, bɔ tum gbi i bɔkɔ, kɔm bɔ nì kɔ bəni bə kwani bwɔ́kɔ. ");
INSERT INTO cug_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisɔs dzaka i bɔ a, “Mbɛiŋ bîəliki mih, ma mih ni fə mbɛiŋ kwaki num lɔ bəni.” ");
INSERT INTO cug_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Akisəkə bɔ dza bee gi yibɔ ka biəliki wi. ");
INSERT INTO cug_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jisɔs ka bi kini tsə i ninshiŋ, chu tsə yɛiŋ bəni bədɔkɔ bəfa a num mi bəh waiŋnih wi. Bəni bələ nì kɔ Jɛm bəh waiŋnih wi Jɔn bɔ nì kɔ bwa bə Sɛbide, bɔ num bəh ba wibɔ Sɛbide i ŋgwuki mə kwɔ gi yibɔ. Wi ka bɔɔŋ tə bɔ. ");
INSERT INTO cug_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Akisəkə bɔ dza bee ŋgwuki bəh ba wibɔ ka biəli wi. ");
INSERT INTO cug_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisɔs ka nyaniki i kimbu ki Galili kichi lani bəni i júŋ yi bijuŋni bibɔ wə chu fuku ntum wi ndzɔŋni kɔm ŋkuŋ bi Nyɔ. Wi chuku tə na yi naiŋ jwɛiŋ i bəni wə. ");
INSERT INTO cug_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ayakadəiŋ, ntum wələ kɔm wi waŋ tsə i tumi ki Silia wə kichi. Bəni ka dzəki bəh bəni bəchi bə̀ bɔ nì gwɛiŋki, bəh bə̀ bɔ nì kɔ i nshili wə i wi, kɔŋ a nì kɔ na bə̀ bəchinda bə ŋkpɛli nì njiŋsiki bɔ, nabə bə̀ bɔ nì gbɔki kiŋgbɔ, bəh bə̀ bɔ nì kɔ bɔ kpi wa wimu. Si bɔ nì dzəki bəh bɔ yakadəiŋ wi chuku bɔ bəchi. ");
INSERT INTO cug_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na faiŋ wi nì tsəki mbaŋ wi bəni wimbum ka kwuki i wi chɛiŋ. Bəni bələ nì nyəki dzəki i bimbu bi tumi ki Galili wə, bədɔkɔ nyə dzə i Bikwili Jɔfi wə, bədɔkɔ i Jɛlusalɛm bəh i di bi Judea bidɔkɔ wə. Bədɔkɔ nyə dzə i kiwuŋ ki Bɔkɔ ki Jɔdan wə. ");
INSERT INTO cug_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jɔbi wə Jisɔs nì yɛiŋ mbaŋ wi bəni yakadəiŋ, ka dza yaka tsə shinum i ŋkwuŋ bɛiŋ, bwa bu bə mbaŋ juŋni dzə kɔmsi i wi wə. ");
INSERT INTO cug_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Wi ka yisi i laniki bɔ dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ndzɔŋni bimbum kɔ i bəni bə̀ bɔ kiəki a bɔ kɔ bə kifuu i kimbu ki Nyɔ wə, kɔm ŋkuŋ bi bɛiŋ kɔ bibɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ndzɔŋni bimbum kɔ i bəni bə̀ bɔ dəki, kɔm Nyɔ bi chumsi lə bɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ndzɔŋni bimbum kɔ i bəni bə̀ bɔ dzɔki gwu yibɔ i kuku, kɔm bɔ bi dzi lə mbi. ");
INSERT INTO cug_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ndzɔŋni bimbum kɔ i bəni bə̀ dzɔŋ wɔɔki bɔ, kindɔŋ wɔm bɔ kɔm nɔni ki chəŋ, kɔm Nyɔ bi fə lə ma bɔ fwuli. ");
INSERT INTO cug_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ndzɔŋni bimbum kɔ i bəni bə̀ bɔ kwasiki nshɛiŋ i bədɔkɔ, kɔm Nyɔ bi kwasiki lə nshɛiŋ i bɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ndzɔŋni bimbum kɔ i bəni bə̀ shɔ́m yibɔ baiŋki, kɔm bɔ bi yɛiŋ lə Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ndzɔŋni bimbum kɔ i bəni bə̀ bɔ dzəki bəh kimbɔiŋni, kɔm bə bi bɔɔŋki bɔ a bwa bə Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ndzɔŋni bimbum kɔ i bəni bə̀ bəni bwaŋki gvu i bɔ chɛiŋ kɔm a bɔ nɔki nɔni ki chəŋ, kɔm ŋkuŋ bi bɛiŋ kɔ bibɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ndzɔŋni bimbum kɔ bimbɛiŋ, jɔbi wə bəni tɔyiki mbɛiŋ, bwaŋ gvu i mbɛiŋ chɛiŋ, dzaka gia yichu yichi kɔm mbɛiŋ a kilɔlɔ kɔm mbɛiŋ kɔ bəni bəŋ. ");
INSERT INTO cug_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jɔbi wə yi bi numki yakadəiŋ, mbɛiŋ ka wɔ̂kɔki ndzɔŋni lâŋ gwu, kɔm bəmbee bəmbɛiŋ bəmbum kɔ num i tumi ki bɛiŋ wə. Mbɛiŋ kîəki a, akɔ ayaka si bəni nì bwaŋki gvu i bəni bə ntum bə Nyɔ chɛiŋ bə̀ bɔ nì yisi dzə i ninshiŋ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Akɔ mbɛiŋ ŋkaka yi mbi wələ. Ayakalə, ŋkaka kabə num yi chu njwɔŋ kə, bə kɔ i chu fə dəiŋ bəh yi ka yi chu fiəni njwɔŋki a? Bə kɔkə i chu fə gia yindzɔŋni yidɔkɔ bəh yi, yi kɔ a shuku tɔkɔ bəni tsəki dəŋyiki bəh gvu. ");
INSERT INTO cug_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Akɔ mbɛiŋ tə baiŋni bi mbi wələ. Kwili wimbum wə bə maa wi i ŋkwuŋ bɛiŋ wi si nyumi kə. ");
INSERT INTO cug_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mi si baiŋsi kə naka ki baiŋsini i chu dzɔ kah i kwusi baŋ yɛiŋ bɛiŋ. Wi si tɔm num i di biə bə tɔmki naka ki baiŋsini yɛiŋ, ka ki baiŋki ki chusi baiŋni i mi wichi wə wi kɔ i dzu. ");
INSERT INTO cug_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Akɔ yakadəiŋ si baiŋni bimbɛiŋ kaŋaki i baiŋki i bəni nshiŋ, ka bɔ yɛiŋki nɔm wimbɛiŋ wi ndzɔŋni nya kiŋkɔksi i Tii wimbɛiŋ wə wi kɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Kiə mbɛiŋ ki kwâka kə a mih dzə i chiksi gia yə yi kɔ i Kiŋwakti ki Bənchi bə Muses wə bəh yə yi kɔ i Biŋwakti bi bəni bə ntum bə Nyɔ wə. Mih dzə i fə a yi dzə kpɛiŋ ŋkɔŋ. Mih ka dzə dəkə i chiksi yi. ");
INSERT INTO cug_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mih fukuki ŋkɔŋ i mbɛiŋ a, i tsə buku na ka bɔɔli bəh nshwaiŋ bi kaa, fidzəkəhni fi gia i Kiŋwakti ki Bənchi mə, na kɔŋ fi sɛiŋniki na dəiŋ, bi tsə kə i kuku maka gia yiwɔ dzə kpɛiŋ asi yi chusiki. ");
INSERT INTO cug_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Yi kɔ a, na ndə wə wi bi bwiŋki nchi i bənchi bələ wə, kɔŋ nchi wiwɔ sɛiŋniki na dəiŋ, ka laniki bəni a bɔ bwîŋki yakadəiŋ tə, wəmaka mi bi numki mi wi nchiŋ i kintəəŋ ki ŋkuŋ bi bɛiŋ wə. Ayakalə, mi wə wi jiəki bənchi bələ, chu lani tə bəni a bɔ jîəki, wəmaka mi bi numki mi wimbum i kintəəŋ ki ŋkuŋ bi bɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ayakadəiŋ, mih fukuki i mbɛiŋ a, nɔni kimbɛiŋ ki chəŋ kabə tsəki kə ki bəni bə̀ bɔ laniki bənchi bə Nyɔ bəh ki Bəfalasi, mbɛiŋ bi ma lansi liə i ŋkuŋ bi bɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mbɛiŋ nì wɔkɔ lɔ asi bə nì dzaka i bəni i kikpu wə a, ‘Kiə wɔ bi wɔ̂ɔ kə mi. Mi ka wɔɔ mi, yaka wi kaŋaki lə nsaka.’ ");
INSERT INTO cug_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ayakalə, mih fukuki i mbɛiŋ a mi wichi wə wi bɔksiki shɔ́m bəh waiŋnih wi, yaka wi kaŋaki lə tə nsaka. Mi wə wi tɔyi waiŋnih wi, wi kîəki a wi bi numki lə i bəni bə̀ bɔ sakaki bənsaka nshiŋ. Mi wə wi bɔɔŋki waiŋnih wi a, ‘Kiyuŋ’ wi kîəki a wi bi liəki lə i gbuku wimbum wə. ");
INSERT INTO cug_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ayakadəiŋ, yi kɔ a, wɔ kabə nəŋ i nya kinya ka i tɔŋ wi fəni wi gia wə, kwaka a waiŋnah kaŋaki lə wɔ i wi shɔm, ");
INSERT INTO cug_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wɔ bêe kinya ka kə i tɔŋ wi fəni wi gia kpəŋ, wɔ tsə̂ mbɛiŋ wi yisi kɛ̂iŋsi gia yiwɔ, ka wɔ fiəni tsə nya kinya ka. ");
INSERT INTO cug_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mi ka dzɔ wɔ i tsə bəh wɔ i juŋ yi nsaka wə, wɔ mɔ̂msi a mbɛiŋ wi kɔmsi kɛ̂iŋsi ka mbɛiŋ wi fiəni chu bəh nsɛiŋ a kɛiŋ i dzəh, ka wi ma ni tsə nya daŋsi wɔ i kaŋ yi mi wə wi sakaki bənsaka, wi ni nya daŋsi wɔ tə i kaŋ yi bəni bə jum wə, ma bɔ ni fah wɔ i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mih fukuki ŋkɔŋ i wɔ a wɔ ni buku kə fɛiŋ maka wɔ gɔm kaasi finini fichi fiə bɔ bikəki. ");
INSERT INTO cug_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mbɛiŋ nì wɔkɔ lɔ asi bə nì dzaka a, ‘Kiə wɔ ki nɔ̂ kə bəh kpə mi.’ ");
INSERT INTO cug_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ayakalə, mih fukuki i mbɛiŋ a, na ndə wə wi tsɛiŋki miŋkpaŋa bəh kiŋkɔŋ ki nɔni, ma yi numki a wi nɔ lɔ bəh wi i shɔm yi mə. ");
INSERT INTO cug_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yi kabə num a dzəkəh wa wi tsɛiŋ yiləkəli ka fəki a wɔ fə chu, wɔ kâmbwili dzəkəh wiwɔ wɔ lɔ̂tɔkɔ. Yi ndzɔŋki a wɔ laksi kimbu ka ki gwu kimu, a kɔbi lɔ a bə bi lɔɔ gwu ya yichi i gbuku wimbum mə. ");
INSERT INTO cug_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tsɛiŋ ya yiləkəli kabə fəki a wɔ fə chu, wɔ tə̂iŋ bwili tsɛiŋ yiwɔ wɔ lɔ̂tɔkɔ. Yi ndzɔŋki lə a wɔ laksi kimbu ka ki gwu kimu, a kɔbi lɔ a gwu ya yichi bi tsə i gbuku wimbum mə. ");
INSERT INTO cug_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bə kɔ bə dzaka tə a, ‘Mi ka bee kpə wi, wi kaŋaki i nyâka kiŋwakti i nyâ i miŋkpaŋa wiwɔ ki chusi a ŋgaiŋ bee wi.’ ");
INSERT INTO cug_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ayakalə, mih fukuki i mbɛiŋ a, mi ka bee kpə wi, a kɔbi a miŋkpaŋa wiwɔ kɔ bəh nɔni ki tɔkɔlini, ma yi numki a wi fə, miŋkpaŋa wiwɔ tsə ka numki wi tɔkɔlini. Mi ka dzɔ miŋkpaŋa wə wi buku i minyuku dzu ka jiə dzu, ma yi numki a wi nɔki bəh kpə mi. ");
INSERT INTO cug_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mbɛiŋ chu wɔkɔ lɔ tə si bə nì dzaka i bəni i kikpu wə a, ‘Jɔbi wə wɔ dzaka gia ka kaiŋ, ki bêe kə i fə̂ yi. Wɔ kaŋaki i fə gia yə wɔ dzaka ka kaiŋ i Bah nshiŋ a wɔ ni fə lə.’ ");
INSERT INTO cug_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ayakalə, mih fukuki i mbɛiŋ a, kiə mi ki dzî kə ŋkaiŋ. Kiə wi ma kâiŋ yɛli wi bɛiŋ wə, kɔm bɛiŋ kɔ kiŋgbɔkɔ ki Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Kiə wi ki kâiŋ kə na nshwaiŋ, kɔm nshwaiŋ kɔ kiŋgbɔkɔ ki Nyɔ kigvu. Kiə wi ki kâiŋ kə Jɛlusalɛm, kɔm Jɛlusalɛm kɔ kwili wi Ŋkuŋ wimbum. ");
INSERT INTO cug_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kiə wi ki kâiŋ kə na fwu wi wə, kɔm wi kɔkə i fə juŋ yifwu a yi fiəni juŋ yi fukuli nabə yi jisi. ");
INSERT INTO cug_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mi ka bum gia bəh dzaka ki a, ‘Aaŋ,’ yi kpɛiŋ yakadəiŋ. Wi ka nəiŋma a, ‘Aayi,’ ma yi kpɛiŋ yakadəiŋ. Wi ka chu kpɛiŋsi gia yidɔkɔ yɛiŋ, ma gia yiwɔ numki a yi nyə num i mi wichu wə. ");
INSERT INTO cug_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mbɛiŋ wɔkɔ lɔ si bə nì kɔ bə dzaka tə a, ‘Mi ka bwili dzəkəh wi mi, bə bwili tə ŋ'wi. Mi ka babwili jəŋ wi mi, bə babwili tə ŋ'wi.’ ");
INSERT INTO cug_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ayakalə, mih fukuki i mbɛiŋ a, kiə mi ki sîni kə bəh mi wichu. Mi ka twɛiŋ kimbaŋ ka ki tsɛiŋ yiləkəli, wɔ fîəni ki tsɛiŋ yi kimiəkə wi twɛiŋ kaasi. ");
INSERT INTO cug_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi ka sɔmi wɔ a ŋgaiŋ dzɔ mbuŋ wa wi nintəəŋ, wɔ nyâ kaasi na bəh wi nimbɛiŋ wə i wi. ");
INSERT INTO cug_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mi ka kaŋyi wɔ a wɔ nyani tsə may wimu, wɔ nyâni mbɛiŋ wi na bəmay bəfa. ");
INSERT INTO cug_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mi ka nywa fiɛŋ i wɔ, wɔ nyâ. Mi ka fwa fiɛŋ i wɔ, kiə wɔ ki nə̂iŋ kə i nya. ");
INSERT INTO cug_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mbɛiŋ wɔkɔ lɔ si bə kɔ bə dzaka a, ‘Wɔ kɔ̂ŋki mi wə wi kɔ kɔmsi i wɔ wə, wɔ bâiŋŋ mi wə wi baiŋŋki wɔ.’ ");
INSERT INTO cug_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ayakalə, mih fukuki i mbɛiŋ a, mbɛiŋ kɔ̂ŋki bəni bə̀ bɔ baiŋŋki mbɛiŋ, ma mbɛiŋ tsâki i bə̀ bɔ bwaŋki gvu i mbɛiŋ chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ayakadəiŋ, mbɛiŋ ni numki bwa bə Ba wimbɛiŋ wə wi kɔ i bɛiŋ. Akɔ wi wə wi si fə ka wɔŋ baiŋki i bəni bəchu wə bəh i bəndzɔŋni wə. Asi faaŋ wi tə dzaŋ a yi dzə i bəni bə̀ bɔ fəki gia yi chəŋ, bəh i bə̀ bɔ fəki kə gia yi chəŋ. ");
INSERT INTO cug_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mbɛiŋ kwakaki a mbɛiŋ ka kɔŋki a bəni bə̀ bɔ kɔŋki mbɛiŋ, mbee wiwɔ ni numki na nə i mbɛiŋ a? Na bəni bə̀ bɔ kwaki kiŋwakti fəki kə ayaka tə a? ");
INSERT INTO cug_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mbɛiŋ ka bɔniki a bwa bə nih bəmbɛiŋ shəŋ, gia yə mbɛiŋ fəki chi chi bəni bədɔkɔ fə kə kɔ la nə a? Bəni bə tumi si bɔŋ fə kə a yakadəiŋ a? ");
INSERT INTO cug_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yi kɔ a mbɛiŋ kâŋaki i ndzɔŋki bwiliki fwu asi Ba wimbɛiŋ wə wi kɔ i bɛiŋ ndzɔŋki bwiliki fwu.” ");
INSERT INTO cug_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Mbɛiŋ tɔ̂kniki a, jɔbi wə mbɛiŋ fəki ndzɔŋni i bəni nshiŋ, yi ma numki a mbɛiŋ fəki a bɔ yɛ̂iŋki. Mbɛiŋ kabə fəki yakadəiŋ, ma tii wimbɛiŋ wə wi kɔ i bɛiŋ bi ma chu makti mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ayakadəiŋ, jɔbi wə wɔ nyaki fiɛŋ i mi wə wi kaŋaki kə, ma tɔ̂ŋki sɔŋ asi bəni bə̀ bɔ dzakaki chi fə chi si shi fə i júŋ yi tsani wə bəh i dzə́h wə, ka bəni kɔ̂ksiki bɔ. Mih fukuki ŋkɔŋ i mbɛiŋ a bɔ kwati lɔ bəmbee bəbɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ayakalə, jɔbi wə wɔ nyaki fiɛŋ i mi, kiə wɔ ki fə̂ kə a tsɛiŋ ya yi ki miəkə kiə gia yə tsɛiŋ yiləkəli fəki. ");
INSERT INTO cug_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ayakadəiŋ, ka kinya ka ni numki i nyumi wə, ayaka Ba wa wə wi si yɛiŋ gia yə bə fəki i nyumi wə ni makti wɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jɔbi wə mbɛiŋ tsaki, mbɛiŋ ma fə̂ki ka bəni bə̀ bɔ dzakaki chi fə chi si shi fə. Bɔ si shi kɔŋ a numki i bɛiŋ i júŋ yi tsani wə, bəh i dzə́h yi baŋsini wə i tsaki, ka bəni yɛ̂iŋki bɔ. Mih fukuki ŋkɔŋ i mbɛiŋ a bɔ kwati lɔ mmakti wibɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ayakalə, jɔbi wə wɔ nəŋki i tsa, liə tsə i kintəəŋ ki juŋ mə, wɔ baŋ baka kijuŋ ka wɔ tsaki i Ba wa wə wi kɔ i nyumi wə. Ba wa wə wi si yɛiŋ gia yə bə fəki i nyumi wə ni ka makti wɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jɔbi wə mbɛiŋ tsaki, kiə mbɛiŋ ki bâaŋ kə a dzâkaki gia yiyəə yiyəə asi bəni bə̀ bɔ si kiə kə Nyɔ si shi fə. Bɔ si fə yakadəiŋ bəh kiŋkwaka a bə ni wɔkɔ lə ntsa wibɔ kɔm gia yiduli yə bɔ faaki. ");
INSERT INTO cug_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kiə mbɛiŋ ma nûmki ka bɔ. Mbɛiŋ kîəki a Ba wimbɛiŋ nì kɔ wi si kiə lɔ gia yə mbɛiŋ nəŋki, na ka mbɛiŋ bikəki i wi. ");
INSERT INTO cug_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Akɔ lə si mbɛiŋ kɔ i tsaki: ‘Ba wibuku wə wi kɔ i bɛiŋ, fə̂ bəni kɔksiki yɛli wa, ");
INSERT INTO cug_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","fə̂ ŋkuŋ bia dzə, fə̂ a gia yə wɔ nəŋki yi numki i fa kuku asi yi kɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nyâ buku bəh dzɛiŋ bidaiŋ. ");
INSERT INTO cug_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma wɔ dâlinya chu bibuku, asi buku dalinyaki chu biə bəni bədɔkɔ fəki i buku. ");
INSERT INTO cug_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kiə wɔ ki bêe kə a buku liə i mmɔmsi wə. Bwîli buku i kaŋ yi mi wichu wə.’ Ŋkuŋ bi bɛiŋ kɔ mbia, ŋga num mbia, mbum num mbia i jɔbi wichi wə kiŋgɔksi kɔbi. Ma yi num ayaka. ");
INSERT INTO cug_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Mbɛiŋ kabə dalinyaki chu biə bəni bədɔkɔ fəki i mbɛiŋ, ma Ba wimbɛiŋ wə wi kɔ bɛiŋ ni dalinya tə bimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ayakalə, mbɛiŋ kabə dalinyaki kə chu biə bəni bədɔkɔ fəki i mbɛiŋ, ma Ba wimbɛiŋ ma ni dalinya tə bimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jɔbi wə mbɛiŋ bamki dzaka, kiə mbɛiŋ ma nûmki bəh shi bi gwuŋni asi bəni bə̀ bɔ ghaŋsiki gwu si shi fə. Bɔ si kwuni kishi kibɔ i jɔbi wiwɔ wə, ka bəni yɛ̂iŋki dzaka kibɔ ki bamni. Mih fukuki ŋkɔŋ i mbɛiŋ a bɔ kwati lɔ mmakti wibɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ayakalə, jɔbi wə wɔ bamki dzaka, wɔ wɔ̂kɔ shi bia, wɔ fîaŋsi fwu wa, ");
INSERT INTO cug_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ka mbam wa wi dzaka ma yɛ̂iŋki num bəni, a yɛiŋki num Ba wa wə wi kɔ i nyumi wə. Ka Ba wa wə wi si yɛiŋ gia yə bəni fəki i nyumi wə ni makti wɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Kiə mbɛiŋ ma jîəki biba bimbɛiŋ fa kuku a num i di biə shəkə kɔ mɛiŋni, bi num tə i chami, bəji num i bwiŋ liə i chwɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mbɛiŋ jîəki biba bimbɛiŋ num i tumi ki bɛiŋ wə, a num di biə shəkə kɔkə i mɛiŋni, bi kɔbi tə i chami, ayaka bəji kɔbi tə i bwiŋ liə i chwɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mbɛiŋ kîəki a di biə mi jiəki kiba ki akɔ fɛiŋ wə shɔm yi kɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Dzəkəh wi mi kɔ naka ki baiŋsini ki gwu. Ayakadəiŋ, dzə́kəh ya kabə baiŋ, yaka gwu ya yichi ni numki yi jikə bəh baiŋni. ");
INSERT INTO cug_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ayakalə, dzə́kəh ya kabə ji num jini, gwu ya yichi ni numki yi jikə bəh jisi. A kabə num baiŋni i gwu ya wə fiəni chu num jisi, ma ŋgumi bi jisi biwɔ ni numki dəiŋ a? ");
INSERT INTO cug_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mi kɔkə i nɔmki i bətikwili bəfa. Yi kabə num yakadəiŋ, ma wi ni baiŋŋki widɔkɔ, wi kɔŋ widɔkɔ, yudɔkɔ wi ni wɔkɔki i widɔkɔ nalə, wi sɛiŋsi widɔkɔ. Mbɛiŋ kɔkə nɔmki i Nyɔ chu nɔm i kpɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ayakadəiŋ, mih fukuki i mbɛiŋ a kiə mbɛiŋ ma fûmsiki gwu kɔm nɔni kimbɛiŋ a mbɛiŋ ni dzi nə, nabə i mu nə, yudɔkɔ kɔm gwu yimbɛiŋ bəh a mbɛiŋ ni lɔh nə. Kiŋ'waka ki mi tsəki kə biɛiŋ bidzini, ayaka gwu yi mi bɔŋ tsə kə tə bəmbuŋ a? ");
INSERT INTO cug_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mbɛiŋ yɛ̂iŋ si minyəni mə mɔ fuliki bɛiŋ kɔ. Mɔ si gbɛli kə, mɔ si kɔh kə dzɛiŋ i juŋni jiə i bəshaŋkwa wə. Ayakalə, Ba wimbɛiŋ wə wi kɔ i bɛiŋ saŋsi mɔ. Mbɛiŋ kiəki kə a mbɛiŋ kɔkniki tsəki lə minyəni a? ");
INSERT INTO cug_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Akɔ ndə i mbɛiŋ kintəəŋ wə wi fumsiki gwu, wi num i kpɛiŋsi jɔbi twɛsi i nɔni ki wə a? ");
INSERT INTO cug_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kɔm nə mbɛiŋ fumsiki gwu kɔm bə bəmbuŋ a? Mbɛiŋ yɛ̂iŋ si bəfluwa kɔɔki i chwa bɔ num. Bəfluwa si nɔm kə nabə i kɛiŋsi bəmbuŋ bəbɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ayakalə, mih fukuki i mbɛiŋ a, na Ŋkuŋ Sɔlɔmɔn bəh mbum bi bichi biə wi nì kaŋaki jɔbi wə wi nì lafiki gwu bəh bəmbuŋ, wi nì ka num buku dəkə ka fluwa widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A kabə num lə si Nyɔ lafiki mfwaŋ i chwa, mfwaŋ biə bi kɔɔki daiŋ, bi kaŋa i buku kpiyi kijiəli a bə kpa i gbuku wə, wi ma ni lafi mbɛiŋ tsə yaka? Ɔɔɔ bəni bə kimbum ki twɛsi! ");
INSERT INTO cug_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ayakadəiŋ, mbɛiŋ ma fûmsiki gwu yimbɛiŋ a mbɛiŋ ni dzi nə, i mu nə, nabə i lɔh nə i gwu wə a. ");
INSERT INTO cug_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Biɛiŋ biələ bichi kɔ biə bəni bə̀ bɔ kiəki kə Nyɔ si jiə shɔm yɛiŋ wə. Mbɛiŋ kɔ fimbɛiŋ num Ba wimbɛiŋ wə wi kɔ i bɛiŋ kiəki lə a mbɛiŋ nəŋki lə biɛiŋ biələ bichi. ");
INSERT INTO cug_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mbɛiŋ yisi jîə shɔm yimbɛiŋ num i ŋkuŋ bi Nyɔ wə, bəh gia yə yi kɔ chəŋ i wi nshiŋ, ka wi ni nyaki mbɛiŋ tə bəh biɛiŋ biələ bichi. ");
INSERT INTO cug_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ayakalə, si yi kɔ lə, kiə mbɛiŋ ma fûmsiki gwu kɔm kijiəli. Bə ni buku fumsiki gwu kɔm biɛiŋ bi kijiəli, a num kijiəli. Bəŋgəkə bə chɔkɔ kpɛiŋki a bəh chɔkɔ biwɔ biə.” ");
INSERT INTO cug_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Kiə mbɛiŋ ki sâka kə bimfə bi bəni bədɔkɔ, ka Nyɔ bi ma saka tə bimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mbɛiŋ kîəki a dzəh yə mbɛiŋ sakaki kimfə ki mi widɔkɔ yɛiŋ, kɔ a yi Nyɔ bi sakaki tə kimbɛiŋ yɛiŋ. Fiɛŋ fiə mi fəkəki biɛiŋ yɛiŋ i nya i mi, kɔ a fi Nyɔ ni fəkə yɛiŋ i nya i wəmaka mi. ");
INSERT INTO cug_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Akɔ kɔm nə wɔ tsɛiŋki shəkə yi kpɛiŋ i dzəkəh wi waiŋnah wə, ayakalə wɔ yɛiŋ kə kimfuŋ ki kpɛiŋ kə ki kɔ i ŋ'wa dzəkəh wə a? ");
INSERT INTO cug_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Wɔ kɔ i dzaka dəiŋ i waiŋnah a, ‘Waiŋnih nûm ma mih bwili shəkə yi kpɛiŋ i dzəkəh wa mə,’ ayakalə kimfuŋ ki kpɛiŋ num i ŋ'wa dzəkəh wə a? ");
INSERT INTO cug_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wɔ kɔ mi wə wi chusiki gwu! Yisi bwîli kimfuŋ ki kpɛiŋ kə ki kɔ i dzəkəh wa wə na ka wɔ ni yɛiŋ ndzɔŋ shəkə yi kpɛiŋ yə yi kɔ i dzəkəh wi waiŋnah wə, i bwîli. ");
INSERT INTO cug_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mbɛiŋ ma dzɔ̂ nyâ fiɛŋ fi Nyɔ i bíə. Mbɛiŋ ka fə yakadəiŋ, ma yi ni fiəni gwu yi nɔmyi lɔ mbɛiŋ. Mbɛiŋ ma dzɔ̂ nyâ tə bənsəŋ bəmbɛiŋ bə kpɔ bələkəli i bifi. Mbɛiŋ ka fə yakadəiŋ, ma bi ni nyufi lɔ bəh gvu. ");
INSERT INTO cug_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mbɛiŋ bikə, ayaka ma Nyɔ ni nya i mbɛiŋ. Mbɛiŋ nəŋki, ayaka ma Nyɔ ni fə mbɛiŋ yɛiŋ. Mbɛiŋ kɔmyiki bakakijuŋ, ayaka ma Nyɔ ni wɛli i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mbɛiŋ kiəki a mi wichi wə wi bikəki, ni kwati lə, mi wichi wə wi nəŋki, wi ni yɛiŋ lə, mi wichi wə wi kɔmyiki bakakijuŋ bə ni wɛli lə i wi. ");
INSERT INTO cug_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Akɔ ndə i mbɛiŋ kintəəŋ wə waiŋ wi ka bikəki nyəə, wi ni nya num təh i wi a? ");
INSERT INTO cug_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma wi kabə bikə bwɔkɔ, wi ni nya num juŋŋ i wi a? ");
INSERT INTO cug_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na yaka mbɛiŋ bə̀ mbɛiŋ kɔ bəni bəchu kabə kiə i nyaki biɛiŋ bindzɔŋni i bwa bəmbɛiŋ, ma Ba wimbɛiŋ wə wi kɔ i bɛiŋ wi ma ni nya tə biɛiŋ bindzɔŋni i bəni bə̀ bɔ bikəki i wi tsə na ayaka a? ");
INSERT INTO cug_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ayakadəiŋ, na finə fiə mbɛiŋ kɔŋki a bəni fə̂ki i mbɛiŋ, numki a fi mbɛiŋ kɔ i fə̂ki tə i bɔ, kɔm yələ kɔ na gia yichi yə Kiŋwakti ki Bənchi bə Muses bəh Biŋwakti bi bəni bə ntum bə Nyɔ laniki. ");
INSERT INTO cug_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mbɛiŋ lîə i mbaiŋ wə num i dzaka kifiəŋə kifaaŋnini wə, kɔm dzaka ki mbaiŋ kə ki kɔ kiyamni bəh dzəh yə yi bɔniki, tsəki i di biə bəni bi lakaki lakani, ayaka a num i fɛiŋ wə bəni bəduli liəki. ");
INSERT INTO cug_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mbɛiŋ kîəki a dzaka ki mbaiŋ kə ki kɔ kifaaŋnini, bəh dzəh yi ləkəki akɔ yə yi tsəki i nɔni kə ki bi tsə kaa kə. Bəni bə̀ bɔ yɛiŋki i yi wə kɔ twɛsi. ");
INSERT INTO cug_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mbɛiŋ tɔ̂kniki kɔm bəni bə̀ bɔ nyiki ntəkə a bɔ kɔ bəni bə ntum bə Nyɔ. Bɔ dzəki i mbɛiŋ chusi a bɔ kɔ shwáŋ, ayakalə i kintəəŋ bɔ num bəkwula bɔ num i kaasi shwáŋ num kaasini. ");
INSERT INTO cug_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mbɛiŋ bi kiəki bɔ num i kimfə kibɔ wə a num a liŋ asi bə si kiə kpɛiŋ i mintam mə mɔ wumki yɛiŋ wə. Bə kɔlə i kɔ mintam mi glɛb i bifaka wə, nabə i kɔ mintam mi fig i kpɛiŋ wi bwayini wə a? ");
INSERT INTO cug_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yi kɔ a na winaiŋ kpɛiŋ wi ndzɔŋni si wum a mintam mə mɔ ndzɔŋki, kpɛiŋ wichu si wum mintam mə mɔ kɔ michu. ");
INSERT INTO cug_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Kpɛiŋ wi ndzɔŋni kɔkə bi wum mintam michu. Asi kpɛiŋ wichu kɔkə tə i bi wɔm mintam mi ndzɔŋni. ");
INSERT INTO cug_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na winaiŋ kpɛiŋ wə wi wumki kə mintam mi ndzɔŋni bə si gba lɔɔ wi i gbuku wə. ");
INSERT INTO cug_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ayakadəiŋ, mbɛiŋ bi kiəki bəni bə ntəkə bə̀ num i kimfə kibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","A kɔkə dəkə mi wichi wə wi bɔɔŋki mih a, ‘Bah, Bah’, wi bi liəki i ŋkuŋ bi bɛiŋ wə. A bi liəki a mi wə wi fəki gia yə Ba wuŋ wə wi kɔ i bɛiŋ nəŋki. ");
INSERT INTO cug_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A bi numki i chɔkɔ bi nsaka wi gɔksini wə, bəni bəduli bi bikəki i mih a, ‘Bah, Bah, ntə buku nì fukuki lə bəntum bə Nyɔ i yɛli wa wə, bwili bəchinda bə ŋkpɛli i bəni wə i yɛli wa wə, chu fə gia yi kaŋyini i yɛli wa wə a?’ ");
INSERT INTO cug_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mih ka ni chukuli i bɔ a, ‘Mih nì ka num kiə dəkə mbɛiŋ. Mbɛiŋ lâkyi i dzə́kəh yiŋ wə, bəmfə chu.’ ");
INSERT INTO cug_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ayakadəiŋ, mi wichi wə wi wɔkɔki ndzaka wuŋ wələ fə asi ndzaka wiwɔ nəŋki, wi kɔ aka mi wi mfi wə wi nì maa juŋ yi i biaŋa bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Dzaŋ dzə, bɔ́kɔ buku, fiəkə tsə chini juŋ yiwɔ, yi kɔbi i muku, kɔm wi nì kɔ wi chɔkɔ chaka kiwɔ i biaŋa wə. ");
INSERT INTO cug_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ayakalə, mi wichi wə wi wɔkɔki ndzaka wuŋ wələ, tsə nəki fə kə asi wi kɔ, yaka wi kɔ aka mi wi kiyuŋ wə wi nì maa n'yi juŋ i mishambu bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Dzaŋ dzə, bɔkɔ buku, fiəkə tsə chini juŋ yiwɔ muku, gbɔ lə gbuuu.” ");
INSERT INTO cug_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Asi Jisɔs nì dzaka kaasi gia yələ yichi, mbaŋ wi bəni wə ka num bəh ŋkaiŋyi i nlani wiwɔ wə, ");
INSERT INTO cug_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kɔm wi nì laniki ka mi wə wi kaŋaki ŋga bi lanini. Wi nì laniki kə ka bəni bəbɔ bə̀ bɔ laniki bənchi bə Nyɔ nì laniki. ");
INSERT INTO cug_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisɔs dza shi dzə i ŋkwuŋ bɛiŋ, mbaŋ wi bəni wimbum kwu i wi chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yi num a mi widɔkɔ wə wi nì gwɛiŋki bəh jwɛiŋ yi kumyini, nì dza dzə tum binyu i Jisɔs nshiŋ ka dzaka i wi a, “Bah, wɔ kabə kɔŋki wɔ fə̂ mih bâiŋki.” ");
INSERT INTO cug_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisɔs ka nani tsə tsɛiŋ yi kɔm wi ka dzaka a, “Mih kɔŋki lə, bɔ̂nih ma wɔ bâiŋki.” Akisəkə, jwɛiŋ yi kumyini yiwɔ kaa i gwu yi wə, wi ka baiŋki. ");
INSERT INTO cug_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jisɔs ka kiŋ i wi a, “Yɛiŋ, kiə wɔ ki fûku kə yi i mi widɔkɔ. Ayakalə, tsə̂ chûsi gwu ya i tii mfə gia, ma wɔ nyâ kinya kə Muses nì dzaka a mi kaŋaki i nyâ i chusi i bəni a ŋgaiŋ bɔnih lɔ i jwɛiŋ yələ wə ka baiŋki.” ");
INSERT INTO cug_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisɔs dza nyə tsə liə i kwili wi Kafanaum wə, fwu wi bəni bə jum widɔkɔ dzə yɛiŋ wi ka kwuŋki kaŋ i wi dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Bah, waiŋ wuŋ wi nɔm nɔki dzu wi gwɛiŋ na bəh ŋga, num wi kpi wa wimu.” ");
INSERT INTO cug_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisɔs dzaka i wi a, “Mih ni dzə chuku lə wi.” ");
INSERT INTO cug_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ayakalə, tikwili wi bəni bə jum wiwɔ chukuli i Jisɔs a, “Bah, mih kpɛiŋniki kə i mi wə wɔ kɔ i dzə i wi dzu. Dzâka shəŋ a ja ma waiŋ wuŋ wi nɔm bɔnih. ");
INSERT INTO cug_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Mih kɔ mi i ŋga bi mi widɔkɔ chɛiŋ, bəh bəni bə jum i mih chɛiŋ. Mih si dzə mih dzaka i widɔkɔ a, ‘Tsə̂,’ wi ka tsəki a tsəni, i widɔkɔ a, ‘Dzə̂,’ wi ka dzəki a dzəni. Mih si dzə mih dzaka tə i mfa wuŋ a, ‘Fə̂ lə,’ wi ka fəki ayakadəiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jɔbi wə Jisɔs nì wɔkɔ gia yə wi dzaka yakadəiŋ, dzaka wɔm wi. Wi ka dzaka i bəni bə̀ bɔ nì biəliki wi a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mih kɛiŋki ki yɛiŋ kə mi na i Islae ka wələ, wi jiə ŋkaiŋni wi shɔm yələ i mih lə. ");
INSERT INTO cug_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mih fukuki i mbɛiŋ a, bəni bəduli bi dzə lə i bimbu bichi i yisi i di biə wɔŋ bubuki bəh i tsə buku i di biə wi tsəki liəki, bɔ bi dzə num i kuku i dziki bəh bətii bəmbɛiŋ Ablaham bəh Ayjik bəh Yakɔb i ŋkuŋ bi Nyɔ wə i bɛiŋ, ");
INSERT INTO cug_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ayakalə, bwa bə̀ tumi kiwɔ kɔ kibɔ, a bi numki num bə lɔɔ bwili bɔ i biŋ bi jisi wə, i di biə bəni bi dəki bɔ dzi jəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Si Jisɔs dzaka yakadəiŋ ka dzaka i fwu wi bəni bə jum wiwɔ a, “Wɔ kwɛ̂ tsə̂, yi nûm i wɔ asi wɔ jiə shɔm ya i mih.” Waiŋ wi nɔm wi fwu wi bəni bə jum wiwɔ ka bɔnih akisəkə. ");
INSERT INTO cug_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisɔs nì dza tsə liə i juŋ yi Bita wə, ka yɛiŋ nih kpə Bita num wi nɔ, gwu yaka wi na bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisɔs kɔm tsɛiŋ yi, jwɛiŋ yiwɔ ka bee wi, wi ka dza bɛiŋ tsɛiŋ fiɛŋ Jisɔs dzi. ");
INSERT INTO cug_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A dzə num i fijɔbi, bəni ka dzəki bəh bəni bəduli bə̀ bəchinda bə ŋkpɛli nì njiŋsiki bɔ. Jisɔs ka bwiliki biŋ'waka biwɔ a bəh ja shəŋ. Wi chuku tə bəni bəchi bə̀ bɔ nì gwɛiŋki. ");
INSERT INTO cug_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yələ gia nì num i fə ka yi dzə kpɛiŋ asi mi wi ntum wi Nyɔ wə Isaya nì kɔ wi dzaka lɔ a, “Wi dzɔ jwɛ́iŋ yibukumbɛiŋ, giŋ tasi bəh mijwɛiŋni mi bukumbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jɔbi wə Jisɔs nì yɛiŋ mbaŋ wi bəni wimbum juŋni kɔmsi dzə i wi wə, wi dzaka i bwa bu bə mbaŋ a, “Bukumbɛiŋ dâŋ buku tsə̂ i kiwuŋ ki bɔkɔ kə yaka wə.” ");
INSERT INTO cug_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mi widɔkɔ wə wi nì laniki bənchi bə Nyɔ ka dza dzə dzaka i Jisɔs a, “Mi wi Lanini, mih ni biəliki lə wɔ i na faiŋ wə wɔ tsəki.” ");
INSERT INTO cug_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisɔs chukuli i wi a, “Migumasha kaŋaki lə dzə́ŋə yibɔ, minyəni mə mɔ fuliki i bɛiŋ kaŋa tə júŋ yibɔ, ayakalə mi wə yɛli wi kɔ Waiŋmi kaŋaki kə na di wi kɔ i jiə fwu wi yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Mi wi mbaŋ widɔkɔ dzaka i wi a, “Bah, bêe ma mih tsə yisi lə̂ə ba wuŋ ka mih biəliki wɔ.” ");
INSERT INTO cug_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ayakalə, Jisɔs chukuli i wi a, “Wɔ bîəli mih, bêe ma bəni bə̀ bɔ kpiyi ləəki bəni bəbɔ bə kpiyini.” ");
INSERT INTO cug_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisɔs dza tsə liə i ŋgwuki mə, bwa bu bə mbaŋ ka bɔŋ biəli tə wi fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yi dzə num a, fuŋni kiləkəli kidɔkɔ nì dzə tumbuku yisi i nəŋniki kinchwɔ kimbum, mwi liə i ŋgwuki mə wi ka nəŋki i mini. A nì kɔ Jisɔs nɔ mfih nɔni. ");
INSERT INTO cug_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Bwa bu bə mbaŋ tsə ka yɔmsiki wi dzaka a, “Bah, gâmti, bukumbɛiŋ ki kpiyiki lə.” ");
INSERT INTO cug_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wi ka dza yaka bɛiŋ dzaka i bɔ a, “Ɔɔɔ bəni bə kimbum kibɔli. Mbɛiŋ lwaki nə a?” Si wi dzaka yakadəiŋ ka dza bɛiŋ wam kaŋyi fuŋni kiləkəli kiwɔ bəh kinchwɔ kimbum kiwɔ, di ka kpichumi lə mɔɔɔŋ. ");
INSERT INTO cug_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dzaka wɔm bəni bəwɔ lə kuss. Bɔ yisi i dzakaki a, “Wələ kɔ winaiŋ mi lə, na fuŋni kiləkəli bəh bɔkɔ wɔkɔ i wi a?” ");
INSERT INTO cug_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisɔs dza daŋ buku i kiwuŋ i kimbu ki bəni bə Gadala wə. Wi baŋsi bəh bəni bəfa bɔ num bəh bəchinda bə ŋkpɛli i bɔ wə. Bəni bəwɔ nì buku i bitaa biə bə nì ləəki bəni yɛiŋ, bɔ nì chəfiki lə, mi nì kɔkə i tsə dzəh fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yi dzə num a bɔ nì yisi ka wiliki na bəh ŋga bikəyi a, “Waiŋ Nyɔ, wɔ nəŋki nə i buku wə a? Wɔ dzə fa i nya buku bəh ŋgəkə maka jɔbi kpɛiŋ na?” ");
INSERT INTO cug_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A nì kɔ mbaŋ wi bifi biduli bidɔkɔ dzi fɛiŋ i kimbu kiwɔ wə bi du. ");
INSERT INTO cug_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Bəchinda bə ŋkpɛli bəwɔ ka tsa Jisɔs a, “Buku tsaki wɔ, wɔ ka bwili buku, wɔ chîŋsi buku i mbaŋ wi bifi biəyaka wə.” ");
INSERT INTO cug_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisɔs ka dzaka i bɔ a, “Mbɛiŋ tsə̂.” Bɔ ka buku, tsə liə i bifi biwɔ wə. Yi num a mbaŋ wi bifi biwɔ bichi nì sɛiŋ shi i káŋ wə, gbɔyi shi i kinchwɔ kimbum kiwɔ wə ka kpiyi fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bəni bə̀ bɔ nì tɔkniki bəh bifi biwɔ kwuni bəh n'yɔkɔ tsə i kwili kintəəŋ, fuku gia yichi na bəh yə yi num bəh bəni bə̀ bɔ nì kɔ bəh bəchinda bə ŋkpɛli i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yi dzə num a kwili wiwɔ wichi nì buku dzə yɛiŋ Jisɔs. Si bɔ dzə yɛiŋ wi, tsa a wi nyə i di bibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisɔs liə i ŋgwuki wə, fiəni daŋ tsə i kwili wi wə. ");
INSERT INTO cug_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yi dzə num a bəni bədɔkɔ nì dzə bəh mi widɔkɔ i wi, num wi kpi wa wimu, i kimbuŋ wə. Jɔbi wə Jisɔs yɛiŋ si bəni bəwɔ jiə shɔ́m yibɔ i wi, wi dzaka i mi wə wi nì kpi wa wimu a, “Nsɛiŋ wuŋ, kâŋa shɔm ya. Mih dalinya lɔ chu bia.” ");
INSERT INTO cug_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yi num a bəni bədɔkɔ bə̀ bɔ nì laniki nnyaki bənchi bə Nyɔ yisi i shwiŋyiki a bɔ bɔ dzakayi a, “Mi wələ fəkəliki bəh Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisɔs kiə gia yə bɔ kwakaki, ka bikə i bɔ a, “Mbɛiŋ kaŋaki kiŋkwaka kichu i shɔ́m yimbɛiŋ wə lə kɔm nə a? ");
INSERT INTO cug_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yə yi bɔniki i dzaka kɔ yi naiŋ a? I dzaka i mi wələ a mih dalinya lɔ chu bia, ma i dzaka a wi dzâ bɛiŋ wi nyani a? ");
INSERT INTO cug_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ayakalə, mih nəŋki i fə a mbɛiŋ kiə a mi wə yɛli wi kɔ Waiŋmi kaŋaki lə ŋga fa kuku i dalinya chu.” Si wi dzaka yakadəiŋ ka dzaka i mi wə wi nì kpi wa wimu a, “Dzâ bɛiŋ, dzɔ̂ kimbuŋ ka wɔ tsə̂ki i wa wa.” ");
INSERT INTO cug_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wi dza bɛiŋ ka tsəki i wa wi. ");
INSERT INTO cug_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Si mbaŋ wi bəni yɛiŋ gia yə yinum yakadəiŋ ndzaŋ liəni i bɔ wə, bɔ ka tumyiki bikum bi Nyɔ wə wi nya biələ ŋga i mi wiwɔm. ");
INSERT INTO cug_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Si Jisɔs nì nyə fɛiŋ ka nyaniki tsəki ka yɛiŋ mi widɔkɔ bə bɔɔŋ a Matiɔ, num mi wi kwani kiŋwakti, num wi num kuku i di bi bi nɔm wə. Jisɔs dzaka i wi a, “Wɔ bîəli mih.” Wi ka dza bɛiŋ ka biəliki wi. ");
INSERT INTO cug_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisɔs dza tsə shinum i Matiɔ dzu, jɔbi wə wi nì dziki, yi dzə num a bəni bədɔkɔ bəduli bə̀ bɔ nì kwaki biŋwakti, bəh bəni bəchu bədɔkɔ bɔ ni dzə tə ka shinum i dzi bɔ bəh Jisɔs bəh bwa bu bə mbaŋ. ");
INSERT INTO cug_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jɔbi wə Bəfalasi yɛiŋ si bəh bɔ dziki yakadəiŋ ka bikə i bwa bu bə mbaŋ a, “Akɔ kɔm nə mi wimbɛiŋ wi lanini dziki bəh bəni bə̀ bɔ kwaki kiŋwakti bəh bəni bəchu bədɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisɔs wɔkɔ si bɔ bikəki, ka dzaka i bɔ a, “Bəni bə̀ bɔ kɔ bəh gwu yiləkəli si nəŋ kə mi wi tsa. Asi nəŋ num bə̀ bɔ gwɛiŋki. ");
INSERT INTO cug_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mbɛiŋ tsə̂ kwaka yɛiŋ a fwu wi gia yə bə nyaka si Nyɔ dzakaki a, ‘Mih nəŋki a bəni kwâsiki num nshɛiŋ i bəni wə, mih nəŋki kə a bə fə̂ki gia i mih’, yəmaka kɔ a nə a? Mbɛiŋ kîə a mih ka dzə dəkə i bɔɔŋ bəni bə̀ bɔ kɔ chəŋ. Mih dzə i bɔɔŋ num bə̀ bɔ kɔ bəchu.” ");
INSERT INTO cug_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Bwa bə mbaŋ bə Jɔn Njulibɔkɔ nì dza dzə bikə i Jisɔs a, “Akɔ kɔm nə wə buku bəh Bəfalasi si bam dzaka, bwa ba bə mbaŋ bam kə a?” ");
INSERT INTO cug_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisɔs chukuli i bɔ a,“Bə kɔlə i laka bəni i dzini bi miŋkpaŋa wimfiaŋ wə, bɔ kɔlə i tsə i gwuŋki tsəŋəki nyum miŋkpaŋa wimfiaŋ wiwɔ num fɛiŋ bəh bɔ a? Ayakalə, kaŋ dzəki lə yə bə bi dzɔ bwili nyum miŋkpaŋa wiwɔ i bɔ, ma bɔ bi ka bamki dzaka. ");
INSERT INTO cug_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mi widɔkɔ kɔkə i dzɔ kinchumni kimbuŋ kimfiaŋ i kwɔyi mbuŋ wikpu yɛiŋ. Wi ka fə yakadəiŋ, ma kinchumni kimbuŋ kiwɔ ni ŋgwuŋyi taŋa buku i kikpu kə wə, dzəŋə yiwɔ ni fiəni kpali tsə si yi nì kɔ. ");
INSERT INTO cug_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mi kɔkə tə i dzɔ mbih mimfiaŋ i jiə i kiŋgəə ki mbih mə num bə kɛiŋsi bəh dzu yi nyam num ki jɛkə, wi ka fə yakadəiŋ, mbih mimfiaŋ miwɔ ni biəŋ, kiŋgəə ki mbih kiwɔ ni bumi baka mɔ ni tsə i kuku. Yi chəŋ kɔ a, bə kaŋaki i jîə mbih mimfiaŋ i kiŋgəə kimfiaŋ mə. Ayakadəiŋ, ma mbih miwɔ bəh kiŋgəə kiwɔ ni numki bindzɔŋ.” ");
INSERT INTO cug_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Asi Jisɔs nì kɛiŋki wi dzaka i bɔ yakadəiŋ, yi dzə num a mi wimbum widɔkɔ, liə dzə tum binyu i wi nshiŋ ka tsaki wi a, “Waiŋ wuŋ wikpaŋni kpi a liə, ayakalə, dzə̂ kɔm wi bəh kaŋ ma wi fiəni chu wiwɔm.” ");
INSERT INTO cug_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jisɔs ka dza bɛiŋ bɔ wi ka tsəki, bwa bu bə mbaŋ biəli tə wi. ");
INSERT INTO cug_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yi num a miŋkpaŋa widɔkɔ nì gwɛiŋki lə bəh bikpakali i jía wə jwɔfi ntsɔ yifa, wi dzə i Jisɔs jum ka kɔm jəŋ wi wimbuŋ. ");
INSERT INTO cug_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wi nì kɔm yakadəiŋ, num wi nì kɔ wi dzaka i wi shɔm a, “Mih ka kɔm shəŋ a mbuŋ wi, yaka mih bɔnih.” ");
INSERT INTO cug_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Si wi kɔm yakadəiŋ, Jisɔs fiəni gwu yɛiŋ wi, dzaka i wi a, “Nih wuŋ, kiə wɔ ki lwâ kə. Shɔm ya yə wɔ jiə i mih yi fə lɔ wɔ bɔnih.” Akisəkə, miŋkpaŋa wiwɔ ka bɔnih. ");
INSERT INTO cug_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jɔbi wə Jisɔs nì tsə buku i juŋ yi mi wimbum wə, ka yɛiŋ bəni bə̀ bɔ nì tɔŋki kisɔŋ ki kpi tasi bəh mbaŋ wi bəni. Bɔ gɔkɔ di bəh mindəm mi kpi. ");
INSERT INTO cug_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jisɔs dzaka i bɔ a, “Mbɛiŋ dzâ nyə̂ fa, waiŋ wiwɔ ka kpi dəkə, wi nɔki lə.” Bəni bəwɔ ka suŋuki wi num suŋuni. ");
INSERT INTO cug_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jɔbi wə bɔ nì bwili bəni bəwɔ i biŋ, wi ka liə tsə i dzu, kaŋa waiŋ wiwɔ i tsɛiŋ yi wə, wi ka dza bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ntum kɔm gia yiwɔ fiəli tali i kimbu ki tumi kiwɔ kichi. ");
INSERT INTO cug_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Si Jisɔs nì buku i fɛiŋ fibiŋ, ka nyaniki tsəki, bimfəkə bidɔkɔ bifa, a num bənyuku ka yɔkɔki biəliki wi wamyi bəh ŋga dzakayi a, “Waiŋ Ŋkuŋ Dɛbit, kwâsi nshɛiŋ i buku wə.” ");
INSERT INTO cug_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jɔbi wə Jisɔs nì tsə liə i dzu, bimfəkə biwɔ biəli wi, wi bikə i bɔ a, “Mbɛiŋ bum a mih kɔlə i fə gia yələ mbɛiŋ dəki lə a?” Bɔ bum a, “Aaŋ Bah.” ");
INSERT INTO cug_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jisɔs ka kɔm dzəkəh yibɔ dzaka a, “Kɔm bə shɔm yə mbɛiŋ jiə i mih wə, ma yi nûm ayakadəiŋ i mbɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Dzə́kəh yibɔ baiŋ. Jisɔs ka lansi kiŋ i bɔ a, “Kiə mbɛiŋ ki mɔ̂m kə i fə̂ a mi widɔkɔ kîə.” ");
INSERT INTO cug_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ayakalə, bɔ tsə ka waŋki tsəki lɔ gia yiwɔ kɔm nɔm wə Jisɔs fə i kimbu ki tumi kiwɔ kichi wə. ");
INSERT INTO cug_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Si bəni bəwɔ nì dza i nyəki, yi num a bəni nì dzə bəh kinchini kidɔkɔ i Jisɔs chinda wi ŋkpɛli num i wi wə. ");
INSERT INTO cug_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisɔs ka bwili chinda wi ŋkpɛli wiwɔ i mi wiwɔ wə wi yisi ka dzakaki. Mbaŋ wi bəni yɛiŋ yakadəiŋ dzaka wɔm bɔ, bɔ ka dzakayiki a, “Bɔ ka num yɛiŋ dəkə ŋkaiŋni wi gia ka yələ i tumi ki Islae wə.” ");
INSERT INTO cug_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ayakalə, Bəfalasi dzaka yibɔ a, “Wi bwiliki bəchinda bəh ŋkpɛli bələ num bəh ŋga bi ŋkuŋ wi bəchinda bə ŋkpɛli bə̀.” ");
INSERT INTO cug_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisɔs ka nyaniki i kikwili kimbum kichi, bəh i kidi wə lani bəni i júŋ yi tsani kibɔ mə, chu fuku tə ntum wi ndzɔŋni kɔm ŋkuŋ bi Nyɔ. Wi nì nyaniki yakadəiŋ chuku tə jwɛ́iŋ yichi bəh mijwɛiŋni michi. ");
INSERT INTO cug_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jɔbi wə wi nì yɛiŋ mbaŋ wi bəni, nshɛiŋ kwa wi bəh bɔ kɔm bɔ nì kɔ i biluŋ wə, na mi widɔkɔ num kə i gamti bɔ, bɔ num aka shwáŋ yə yi kaŋaki kə mi wi tɔknini. ");
INSERT INTO cug_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wi ka dza dzaka i bwa bu bə mbaŋ a, “Ŋkɔh duki lə na bəh ŋga, ayakalə bəni bə kɔhni num a twɛsi. ");
INSERT INTO cug_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ayakadəiŋ, mbɛiŋ tsâki a Bah wə wi kaŋaki khə wiwɔ chîŋsi bəni bə kɔhni i wi khə.” ");
INSERT INTO cug_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisɔs dza bɔɔŋ bwa bu bə mbaŋ jwɔfi ntsɔ bəfa bɔ dzə. Wi nya ŋga i bɔ a bɔ bwîliki biŋ'waka bichu i bəni wə chu chûku jwɛ́iŋ yichi bəh mijwɛiŋni michi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kələ kɔ kiyɛli ki bwa bə ntum bə Jisɔs bə̀ jwɔfi ntsɔ bəfa: Wi ninshiŋ num Samɔn wə bə bɔɔŋki tə a Bita, bəh Andulu waiŋnih wi. Bədɔkɔ num Jɛm wə wi nì kɔ waiŋ Sɛbide bəh waiŋnih wi Jɔn bəh ");
INSERT INTO cug_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filib bəh Batɔlɔmu, Tɔmɔs bəh Matiɔ wə wi nì kwaki kiŋwakti, Jɛm waiŋ Alfiyus, Tadeus bəh ");
INSERT INTO cug_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Samɔn wə wi nì kɔ i mbaŋ wi dzɛlɔt wə bəh Judas waiŋ Iskaliɔt wə wi nì taŋni Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisɔs nì faaŋ bəni bələ jwɔfi ntsɔ bəfa , dzaka i bɔ a, “Mbɛiŋ ka tsəki, kiə mbɛiŋ ki tsə̂ kə i di bi bəni bə̀ bɔ kɔkə Bəju. Kiə mbɛiŋ ki tsə̂ kə i kikwili ki bəni bə Samalia wə. ");
INSERT INTO cug_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mbɛiŋ tsə̂ num i bwa bə Islae bə̀ bɔ kɔ ka shwáŋ yə yi lakayi. ");
INSERT INTO cug_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Si mbɛiŋ tsə̂ki mbɛiŋ fukuki i bɔ a, ‘Ŋkuŋ bi bɛiŋ si num a dzəh.’ ");
INSERT INTO cug_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbɛiŋ chûkuki tə bəni bə̀ bɔ gwɛiŋki, fə̂ bəni bə kpili fiəni dza i kpi wə, chûku bəni bə̀ bɔ kaŋaki jwɛ́iŋ yi kumyini, bwîli bəchinda bə ŋkpɛli i bəni wə. Mih nya ŋga biələ i mbɛiŋ kilɔlɔ. Mbɛiŋ tsə̂ gâmtiki tə bəni yɛiŋ kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mbɛiŋ kabə nyə, kiə mi ki dzɔ̂ kə kpɔ i shu i chiŋnih wə, nabə kpɔ wimbum, nabə wi nchiŋ, nabə wə wi sɛiŋniki. ");
INSERT INTO cug_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kiə mi ki dzɔ̂ kə kiba. Kiə mi ki dzɔ̂ kə bəmbuŋ bəfa nabə dzuyigvu yidɔkɔ, nabə mbəŋ. Mbɛiŋ kîə a mi wi nɔm kaŋaki i kwatiki dzɛiŋ i di biə wi nɔmki. ");
INSERT INTO cug_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mbɛiŋ ka tsə liə i kwili wə, yudɔkɔ i di wə, mbɛiŋ nə̂ŋ mi wi kpɛiŋni, mbɛiŋ ka nɔ̂ki a bəh wi i tsə̂ bûku i jɔbi wə mbɛiŋ bi nyəki fɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mbɛiŋ ka tsə, asi mbɛiŋ liəki tsəki i mi dzu, mbɛiŋ bɔ̂nih i juŋ yiwɔ a kimbɔiŋni nûm bəh mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Juŋ yiwɔ kabə kpɛiŋni, kimbɔiŋni kimbɛiŋ bâaŋ i yɛiŋ dzu. Juŋ yiwɔ kabə kpɛiŋniki kə, kimbɔiŋni kimbɛiŋ fîəni dzə i mbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi ka nəiŋ i dzɔ mbɛiŋ nabə i wɔkɔ gia yə mbɛiŋ dzakaki, mbɛiŋ bə́ buku yɛiŋ dzu nabə i kwili wiwɔ wə mbɛiŋ chûmni kwɔŋɔ bibɔ i gvu yimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mih fukuki ŋkɔŋ i mbɛiŋ a, a bi numki i chɔkɔ bi nsaka wi gɔksini wə, gia bi bɔniki lə i kwili wi Sɔdɔm wə bəh ki Gɔmɔla tsə kwili wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Mbɛiŋ wɔ̂kɔli, mih faaŋki mbɛiŋ, mbɛiŋ ni tsə mbɛiŋ numki ka shwáŋ i bəkwula kintəəŋ. Ayakadəiŋ, mbɛiŋ bə́ nyani mbɛiŋ ka fifiki ka júŋŋ, mbɛiŋ num tə alə mɔɔɔŋ aka mbumi. ");
INSERT INTO cug_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mbɛiŋ bə́ nyani mbɛiŋ ka tɔ̂kni kɔm bəni. Mbɛiŋ kîəki a bɔ bi kwa nya lə mbɛiŋ i kaŋ yi bəni bə̀ bɔ sakaki bənsaka. Bɔ bi twɛiŋki mbɛiŋ i júŋ yibɔ yi tsani wə. ");
INSERT INTO cug_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Bɔ bi guku tsə bəh mbɛiŋ i bəni bə̀ bɔ sakaki bimbu bi tumi nshiŋ, bəh i bəŋkuŋ nshiŋ kɔm mih, ka mbɛiŋ dzakaki i bɔ bəh bəni bə̀ bɔ kɔkə Bəju kɔm mih. ");
INSERT INTO cug_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bɔ bi ka nya mbɛiŋ i bɔ yaka, kiə mbɛiŋ bi ma fûmsi gwu a yuwidɔkɔ mbɛiŋ ni tsə dzaka a nə i dzəh yi naiŋ wə, kɔm Nyɔ bi nyaki lə gia yə mbɛiŋ bi dzaka i jɔbi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A bi numki kə mbɛiŋ i dzakaki. A bi dzakaki Kiŋ'waka ki Ba wimbɛiŋ i mbɛiŋ dzəkə. ");
INSERT INTO cug_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mi bi dza dzɔ waiŋnih wi nya bə wɔɔ, ayaka tii waiŋ dzɔ waiŋ wi nya bə wɔɔ. Bwa bi dza bwaŋki lə gvu i bətii bəbɔ chɛiŋ, fə bə wɔɔyi bɔ. ");
INSERT INTO cug_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Bəni bəchi bi baiŋŋki lə mbɛiŋ kɔm yɛli wuŋ. Ayakalə, mi wə wi bi kaŋaki shɔm i tsə buku i kiŋgɔksi wə akɔ wə wi bi bɔiŋki. ");
INSERT INTO cug_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jɔbi wə bəni bi ka bwaŋ gvu i mbɛiŋ chɛiŋ i kwili wimu wə, mbɛiŋ yɔ̂kɔ tsə i kidɔkɔ wə. Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ bi nyani tali kə kikwili ki Islae wə kichi maka mi wə yɛli wi kɔ Waiŋmi dzə. ");
INSERT INTO cug_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Waiŋ wi kiŋwakti kɔkə i tsə mi wi lanini, waiŋ wi nɔm si tsə kə tə tikwili wi. ");
INSERT INTO cug_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yi kpɛiŋniki lə a waiŋ wi kiŋwakti numki aka mi wi lanini, ayaka waiŋ wi nɔm num tə ka tikwili wi. Bə kabə bɔɔŋ tii juŋ a wi kɔ Bɛlsebu, ma bə ma ni bɔɔŋki bwa bə dzu i yɛli wə wi gumi tsə ŋ'wi a? ");
INSERT INTO cug_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ayakadəiŋ, mbɛiŋ ma lwâ bɔ. Mbɛiŋ kîəki a gia kɔkə yə bə baŋ, yi kɔbi i bi baaŋ i buku i biŋ. Ayaka gia yidɔkɔ kɔkə tə yə bə nyumiki a bə bi baaŋki i kiə yi. ");
INSERT INTO cug_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Gia yə mih fukuki i mbɛiŋ nchɔkɔ, mbɛiŋ dzâkaki i bəni a num nshifɔkɔ. Ayaka yə mih chumyiki dzakaki i mbɛiŋ, mbɛiŋ lâka i kifwu ki juŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mbɛiŋ ma lwâki bəni bə̀ bɔ kɔ i wɔɔ a ntsaŋa ki gwu shəŋ kɔbi i wɔɔ tə kiŋ'waka. Mbɛiŋ lwâ Nyɔ wə wi kɔ i kaasi kiŋ'waka ki mi bəh ntsaŋa ki gwu i gbuku wimbum wə. ");
INSERT INTO cug_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ntə bə si taŋni lə minsii mifa i finini wə a? Ayakalə, fimu kɔbi i shi gbɔ i kuku maka Ba wimbɛiŋ bum. ");
INSERT INTO cug_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yi mbɛiŋ kɔ num Nyɔ kiə na júŋ yimbɛiŋ yifwu yichi yə yi kɔ i mbɛiŋ fuŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ayakadəiŋ, mbɛiŋ ma lwâki. Mbɛiŋ tsəki lə minsii miduli. ");
INSERT INTO cug_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Na ndə wə wi bum mih i bəni nshiŋ a wi kiəki lə mih, yaka mih bi bum lə wi tə i Ba wuŋ nshiŋ wə wi kɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ayakalə, na ndə wə wi nəiŋ mih i bəni nshiŋ, akɔ wi mih bi nəiŋki tə i Ba wuŋ nshiŋ wə wi kɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Kiə mbɛiŋ ma kwâkaki a mih dzə num bəh kimbɔiŋni i fa kuku. A kɔkə gia yə mih dzə bəh yi. Mih dzə num bəh jum. ");
INSERT INTO cug_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mbɛiŋ kîəki a mih dzə i fə a waiŋ nyukuni jwɔki bəh tii, waiŋkpaŋni jwɔ tə bəh nih, kpə waiŋ jwɔ bəh nih nyuwi. ");
INSERT INTO cug_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Bəmbaiŋŋni bə mi bi numki bəni i wi dzu. ");
INSERT INTO cug_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mi wə wi kɔŋki ba wi nabə nih wi tsə mih, yaka wi kpɛiŋniki kə i numki mi wuŋ. Mi ka kɔŋki tə waiŋ wi wi nyukuni nabə wi kpaŋni tsə mih, yaka wi kpɛiŋniki kə i numki tə mi wuŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na ndə wə wi ka baaŋ i giŋ kintasi ki i biəliki mih, yaka wi kpɛiŋniki kə i numki mi wuŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mi wə wi tɔkniki bəh nɔni ki, bi laksiki lə nɔni kiwɔ. Ayakalə, na ndə wə wi laksi nɔni ki kɔm mih, wi bi kwatiki lə nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mi wə wi dzɔ mbɛiŋ wi dzɔ num mih. Mi wə wi dzɔ mih, yaka wi dzɔ num mi wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mi wə wi dzɔ mi wi ntum wi Nyɔ, kɔm wi kiəki a, a faaŋ Nyɔ wi, wi bi kwatiki lə mmakti wə Nyɔ maktiki bəni bu bə ntum yɛiŋ, mi wə wi dzɔ mi wi chəŋ, kɔm wi kiəki a wi kɔ mi wi chəŋ, wi bi kwatiki lə mmakti wə Nyɔ maktiki bəni bə chəŋ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mih fukuki ŋkɔŋ i mbɛiŋ a, mi ka nya na bwam wi mwi midəli i mi wimu i mbaŋ wi bəni bə nchiŋ bələ wə kɔm wi kiə a wi kɔ mi wuŋ wi mbaŋ, wəmaka mi bi dza kə mmakti wi.” ");
INSERT INTO cug_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jɔbi wə Jisɔs nì kaasi i təfiki bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa wi ka nyə fɛiŋ kabə nyaniki tsəki i kikwili kə wə fɛiŋ lani bəni chu fuku ntum wi ndzɔŋni. ");
INSERT INTO cug_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","A nì kɔ i jɔbi wiwɔ wə, Jɔn Njulibɔkɔ num i juŋ yi nsəŋ mə. Wi ka bi dza wɔkɔ kɔm gia yə Klistus nì fəki, ka faaŋ bwa bu bə mbaŋ a bɔ tsə̂, ");
INSERT INTO cug_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bîkə i wi a, akɔ a wi wə wi nì kaŋaki i bi dzə a, ma buku wɔkɔliki mi widɔkɔ chi chi a. ");
INSERT INTO cug_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bɔ tsə ka bikə, Jisɔs chukuli i bɔ a, “Mbɛiŋ fîəni tsə̂ fûku i Jɔn gia yə mbɛiŋ wɔkɔ bəh yə mbɛiŋ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Bimfəkə si yɛiŋ lɔ di, bəŋgbɔ nyani dza nyani chəŋ, bəni bə̀ bɔ gwɛiŋki bəh jwɛiŋ yi kumyini bɔnih, binchini wɔkɔ gia, bəni bə̀ bɔ nì kpiyi fiəni dzayi, bə chu fuku tə ntum wi ndzɔŋni wi Nyɔ i bəni bə kifuu. ");
INSERT INTO cug_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kimbɔiŋsi kimbum kɔ i mi wə wi ka məŋni dəkə mih.” ");
INSERT INTO cug_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bwa bə Jɔn bə mbaŋ ni dza i nyəki, Jisɔs ka yisi i dzakaki i mbaŋ wi bəni kɔm Jɔn, bikə a, “Mbɛiŋ nì buku tsə chwa i tsə yɛiŋ num nə a? Gaŋ biə fiəkə tsəki nəŋniki a? ");
INSERT INTO cug_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Asi kɔkə dəkə yakadəiŋ, mbɛiŋ bə́ buku tsə fɛiŋ kɔm nə la? Mbɛiŋ ni tsəki i yɛiŋ mi wə wi si tum bəmbuŋ bə bɔnini i gwu wə a? Mbɛiŋ wɔ̂kɔli, bəni bə̀ bɔ tumki bəmbuŋ bə bɔnini i gwu wə si shi num a bəntɔŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Asi kɔkə dəkə yakadəiŋ, mbɛiŋ bə́ buku tsə i yɛiŋ nə a? I tsə yɛiŋ mi wi ntum wi Nyɔ ma? Aaŋ, mih fukuki i mbɛiŋ a, akɔ mi wi tsə mi wi ntum wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Akɔ wi wə bə nì nyaka kɔm wi Nyɔ dzaka a, ‘Wɔ̂kɔli, mih ni chiŋsi lə mi wuŋ wi ntum ma wi tsə i wɔ nshiŋ wi kɛiŋsi dzəh ya ka wɔ bi dzəki.’ ");
INSERT INTO cug_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mih fukuki ŋkɔŋ i mbɛiŋ a, i kintəəŋ ki bəni bə̀ a bwɔ miŋkpaŋa, mi widɔkɔ kɔkə yɛiŋ wə wi kɔkniki tsə Jɔn Njulibɔkɔ. Ayakalə, mi wə wi kɔ na wi nchiŋ i kintəəŋ ki ŋkuŋ bi bɛiŋ wə wi kɔ wi kɔkni tsə Jɔn. ");
INSERT INTO cug_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","I yisi i chɔkɔ biə Jɔn Njulibɔkɔ nì yisi nɔm wi i dzə buku bidaiŋ a nì kɔ bəni jwɔ ŋkuŋ bi bɛiŋ, ayaka bəni bə ŋga ka lɔkɔki bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bəni bə ntum bə Nyɔ bəchi bəh bənchi bə Muses nì dzakaki kɔm ŋkuŋ bi bɛiŋ i dzə buku i jɔbi wi Jɔn Njulibɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mbɛiŋ kabə yɛiŋ a mbɛiŋ kɔlə i bum, mbɛiŋ bûm a Jɔn wələ kɔ Ɛlaja wə wi nì kaŋaki i dzə. ");
INSERT INTO cug_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mi wə wi kaŋaki bintuni i wɔkɔ, wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jisɔs dza bə́ kaiŋyi a, “Mih kɔ i fəkəni ŋgɔkɔ wi liə wələ bəh finə a? Bɔ kɔ ka bwa bənchiŋ bə̀ bɔ numyi i bi di bishi wə, bədɔkɔ bɔɔŋ bədɔkɔ bikəyi a, ");
INSERT INTO cug_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Buku tɔŋ sɔŋ mbɛiŋ na biŋ a? Nya júm yi kpi mbɛiŋ bum kə a?’ ");
INSERT INTO cug_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mih dzakaki lə kɔm Jɔn nì dzə dzi kə na mu kə, mbɛiŋ ka dzakaki a wi kaŋaki lə chinda wi ŋkpɛli i gwu yi mə. ");
INSERT INTO cug_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mi wə yɛli wi kɔ Waiŋmi dzə, wi dzi chu mu, mbɛiŋ dzaka a bə yɛ̂iŋ, si wi məyiki nnyaki dzɛiŋ bəh mbih mɔ kwa wi, chu num nsɛiŋ yiləkəli bəh bəni bə̀ bɔ kwaki kiŋwakti bəh bəni bəchu bədɔkɔ. Mbɛiŋ kîə a mfi si chusi gwu num i fiɛŋ fiə bi nɔmki.” ");
INSERT INTO cug_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jisɔs ka dza yisi i shaaŋki nɔni bikwili bimbum bidɔkɔ biə wi nì kɔmsiki fəki nnyaki gia yi dzaka kiwɔmni yiduli fɛiŋ, na si wi ni fə yakadəiŋ, bəni bəwɔ fɛiŋ nì ka kwuni i nɔni kibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wi nì shaaŋki yakadəiŋ dzakayi a, “Ŋgəkə wimbum kɔ wimbɛiŋ bəni bə Kɔlasen, ŋgəkə wimbum kɔ tə wimbɛiŋ bəni bə Besayda. Mbɛiŋ kîə a, gia yi dzaka ki wɔmni yə mih nì dzə fə i kidi kimbɛiŋ wə, a nì kɔ a mih fə yi i Taya bəh Sidɔn, ma bɔ nì fiəni i chu bibɔ wə ka lɔh bəmbuŋ bə kpi, fukuh kibwuŋ i gwu wə jiakɔbi i kɔmsi chusi a bɔ kwuni lɔ shɔ́m yibɔ. ");
INSERT INTO cug_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mih fukuki i mbɛiŋ a, a bi numki i chɔkɔ bi nsaka wi gɔksini wə, gia bi bɔniki lə i bəni bə Taya bəh bə Sidɔn tsə yimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ayaka mbɛiŋ bəni bə Kafanaum, mbɛiŋ kwakaki a, akɔ mbɛiŋ bə̀ bə bi yaksiki i bɛiŋ a? Aayi! Bə bi shisi mbɛiŋ shisini i tumi ki bəni bə kpili wə. Mbɛiŋ kiə a, a nì kɔ a gia yi dzaka kiwɔmni yə mih nì fə i mbɛiŋ, a nì kɔ a yi num i Sɔdɔm, ma kwili wiwɔ kɛiŋki lə fɛiŋ i dzə buku bidaiŋ. ");
INSERT INTO cug_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mih fukuki i mbɛiŋ a, a bi numki i chɔkɔ bi nsaka wi gɔksini wə gia bi bɔniki lə i bəni bə Sɔdɔm tsə yimbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","I jɔbi wiwɔ wə, Jisɔs dza dzaka a, “Mih nyaki kiyɔŋni i wɔ Ba wuŋ Ŋkuŋ wi bɔɔli bəh nshwaiŋ kɔm wɔ nyumi gia yələ i bəmfi bəh bəŋkiəgia, chusi yi num i bəni bə kilɔlɔ bəh i bwa bənchiŋ. ");
INSERT INTO cug_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yi num yakadəiŋ Ba wuŋ, kɔm akɔ ayaka si wɔ nì kɔŋki a yi numki. ");
INSERT INTO cug_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ba wuŋ kɔ num wi nya lɔ biɛiŋ bichi i mih. Mi widɔkɔ kɔkə wə wi kiəki Waiŋ Nyɔ a kɔbi a Ba wi. Ayaka mi widɔkɔ num kə wə wi kiəki Ba wuŋ a kɔbi a Waiŋ bəh bəni bə̀ Waiŋ wi kɔ wi sabibwili i chusi Ba wi i bɔ. ");
INSERT INTO cug_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mbɛiŋ bəchi bə̀ mbɛiŋ kɔ bəh biluŋ bi jii gaka mbɛiŋ, mbɛiŋ dzə̂ i mih, ma mih fə mbɛiŋ waka. ");
INSERT INTO cug_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mbɛiŋ dzɔ̂ tûŋ num kimbuŋ kəŋŋ, ma mbɛiŋ bîəliki nlani wuŋ, kɔm mih kɔ mfiŋ mi wi mbɔnini, kaŋa shɔm yi wakani, ka mbɛiŋ dzə kwati ŋ'waka i shɔ́m yimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Kimbuŋ kəŋŋ kɔkə i gaka mbɛiŋ i tuŋ, ayaka biluŋ biŋ jii kə.” ");
INSERT INTO cug_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","I jɔbi wiwɔ wə, Jisɔs bəh bwa bu bə mbaŋ nyə ka nyaniki tɔliki tsəki i kikhə kigəŋ kidɔkɔ wə, a num i chɔkɔ bimbam wə. A nì kɔ dzɔŋ si wɔɔ bwa bu bə mbaŋ, bɔ ka dza yisi i təiŋyiki kifwu kigəŋ dzi. ");
INSERT INTO cug_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jɔbi wə Bəfalasi nì yɛiŋ, bɔ dzaka i Jisɔs a, “Tsɛiŋ, bwa ba bə mbaŋ fəki gia yə nchi bumki kə a mi kɔlə i fəki i chɔkɔ bimbam wə.” ");
INSERT INTO cug_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Wi bikə i bɔ a, “Mbɛiŋ ka num fa dəkə i Kiŋwakti ki Nyɔ wə si dzɔŋ nì wɔɔki Dɛbit bəh mbaŋ wi, wi fə a? ");
INSERT INTO cug_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wi nì liə i juŋ yi Nyɔ wə, dzi blɛd wə bə nì baa jiə a akɔ wi Nyɔ, num nchi nì bumki kə a wi nabə bəni bə̀ bɔ nì kɔ bəh wi kɔlə i dzî. A nì kɔ a dzî a bətii mfə gia. ");
INSERT INTO cug_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma mbɛiŋ ka num fa tə i bənchi bə Muses wə si asi num i chɔkɔ bimbam wə, bətii mfə gia bwiŋ nchi i bimbam wə, bɔ fə bənɔm bəbɔ i juŋ yi fəni yi gia wə, ayakalə nsaka kɔbi a? ");
INSERT INTO cug_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mih fukuki i mbɛiŋ a gia yidɔkɔ kɔlə fa i liə yimbum yi tsə juŋ yi fəni gia. ");
INSERT INTO cug_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bə kɔ num bə nyaka i Kiŋwakti ki Nyɔ wə a Nyɔ dzakaki a, ‘Mih nəŋki a bəni kwâsiki num nshɛiŋ i bəni wə, mih nəŋki kə a bə fə̂ki gia i mih.’ A nì kɔ a mbɛiŋ kiəki gia yə di biələ dzakaki, ma mbɛiŋ kɔkə i sakaki bəni bə̀ bɔ kɔ maka bɔ gbɔ. ");
INSERT INTO cug_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yi kɔ a mi wə yɛli wi kɔ Waiŋmi kɔ Tikwili wi chɔkɔ bimbam.” ");
INSERT INTO cug_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisɔs nì nyə fɛiŋ, tsə liə i juŋ yi tsani yibɔ mə. ");
INSERT INTO cug_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yi num a, mi widɔkɔ nì kɔlə fɛiŋ num tsɛiŋ yi kpi. Bəfalasi bədɔkɔ dza bikə i Jisɔs a, “Nchi bumki lə a bə kɔlə i chûku mi i chɔkɔ bimbam wə a?” Bɔ nì bikəki yakadəiŋ nəŋ num gia yə bɔ ki jiəki i wi fuŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisɔs chukuli i bɔ a, “Akɔ ndə i mbɛiŋ kintəəŋ wə wi kabə kaŋaki shwáŋ yi yimu gbɔ i fəŋ mə i chɔkɔ bimbam wə, wi ma ni kaŋa guku bwili yi a? ");
INSERT INTO cug_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mi wiwɔm tsəki kə shwaŋ nalə a? Yaka kɔ a bənchi bumki lə a mi kɔlə i fə̂ nɔm wi ndzɔŋni i chɔkɔ bimbam wə.” ");
INSERT INTO cug_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wi ka dzaka i mi wə wi nì kpi wa wimu a, “Nâni tsɛiŋ ya.” Mi wiwɔ nani, yi bɔnih ka num aka yidɔkɔ yə. ");
INSERT INTO cug_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ayakalə, Bəfalasi buku tsə ka fasi si bɔ ni fə ka bɔ wɔɔ Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisɔs kîə kɔm kimfasi kə bɔ kɔ bɔ jiə, ka dza nyə fɛiŋ. Bəni bəduli biəli wi. Wi chuku bɔ bəchi bə̀ bɔ nì gwɛiŋki, ");
INSERT INTO cug_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kiŋ a bɔ ma ni fə a bəni kiə ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yi num yakadəiŋ i fə a yi dzə kpɛiŋ asi mi ntum wi Nyɔ Isaya nì dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mbɛiŋ tsɛ̂iŋ, wələ kɔ waiŋ wuŋ wi nɔm wə mih saiŋbwili. Mih kɔŋki lə wi, ayaka shɔm yiŋ wɔkɔki lə ndzɔŋni bəh wi. Mih ni nya lə Kiŋ'waka kəŋŋ i wi, ma wi bi fukuki i bitumi kɔm dzə́h yi chəŋ yə mih təiŋyiki bənsaka bəŋ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wi bi yɔliki kə bəh bəni, nabə i kɔmyiki dzaka. Mi bi lansi wɔkɔ kə ja yi i dzə́h wə. ");
INSERT INTO cug_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wi bi bwiŋ kaasi kə mfwaŋ biə bi kɔ bi si bwiŋ. Wi bi nyumsi kə baiŋni biə bi kɔ bi si libli baiŋ. Yi bi num yakadəiŋ i tsə buku asi wi bi fəki dzəh yi chəŋ yə wi təiŋyiki bənsaka yɛiŋ, dzi. ");
INSERT INTO cug_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ayaka bitumi bichi bi tsɛiŋki tsəki a ninshiŋ num bɔ jiə mfi bibɔ i wi wə.” ");
INSERT INTO cug_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Bəni bədɔkɔ nì dza dzə bəh mi widɔkɔ i wi num wi fəkə wi chu num kinchini, chinda wi ŋkpɛli num i gwu yi wə. Jisɔs chuku wi, wi ka dzakaki chu yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Dzaka wɔm bəni bə̀ bɔ nì kɔ fɛiŋ bəchi, bɔ ka bikəki a, “Yi kɔlə numki a mi wələ kɔ waiŋ Ŋkuŋ Dɛbit a?” ");
INSERT INTO cug_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ayakalə, Bəfalasi ka wɔkɔ si bɔ bikəki yakadəiŋ dzaka a, “Mi wələ bwiliki bəchinda bə ŋkpɛli num bəh ŋga bi Bɛlsebu wə wi kɔ ŋkuŋ wi bəchinda bə ŋkpɛli.” ");
INSERT INTO cug_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisɔs kîə gia yə bɔ kwakaki ka dzaka i bɔ a, “Na kinaiŋ tumi ki gaali gwu ka jwɔki a kiki, ki bi fiəni chu chi. Kwili nabə juŋ yə yi gaali gwu ka jwɔki a yiyi, yi bi num kə. ");
INSERT INTO cug_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ayakadəiŋ, Satan kabə kɔɔŋki bwiliki Satan widɔkɔ i mi wə, ma yi numki a wi gaali lɔ gwu yi. Yi ka numki yakadəiŋ, ma ŋkuŋ bi bi ma num. ");
INSERT INTO cug_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A kabə num a mih bwiliki bəchinda bə ŋkpɛli num bəh ŋga bi Bɛlsebu, ma bwa bəmbɛiŋ ni bwiliki num bəh bi ndə a? Gia yə bwa bəmbɛiŋ fəki ni chusiki a mbɛiŋ gbɔ lɔ nsaka. ");
INSERT INTO cug_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ayakalə, mih kabə bwiliki bəchinda bələ num bəh ŋga bi Kiŋ'waka ki Nyɔ, ma yi numki a ŋkuŋ bi Nyɔ dzə lɔ i mbɛiŋ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Mbɛiŋ kwakaki a mi kɔ i liə dəiŋ i juŋ yi mi wi ləkəli wə, i kɔ buku bəh biɛiŋ bi, maka wi yisi kwa kaŋa mi wi ləkəli wiwɔ a? Jɔbi wə wi kaŋa yakadəiŋ wi ka ni kɔ buku bəh biɛiŋ bi ŋkɔŋ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mbɛiŋ kîə a, mi wə wi kɔkə bəh mih, wəmaka bwaŋki lə gvu i mih chɛiŋ. Mi wə wi gamtiki kə mih i juŋniki, wi shakyiki num shakyini. ");
INSERT INTO cug_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ayakadəiŋ, mih fukuki i mbɛiŋ a Nyɔ kɔlə i dalinya gia yichu bəh ja yichu yichi yə bəni dzakaki. Ayakalə, mi wə wi dzakaki ja yichu kɔm Kiŋ'waka ki Baiŋni, Nyɔ kɔkə i lansi dalinya wi. ");
INSERT INTO cug_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mi wə wi dzakaki ja yichu kɔm mi wə yɛli wi kɔ Waiŋmi, Nyɔ kɔlə i dalinya wi. Ayakalə, mi wə wi dzakaki ja yichu kɔm Kiŋ'waka ki Baiŋni, Nyɔ kɔkə bi lansi dalinya wi, na i jɔbi wi liə wə nabə i wi dzəni wə. ");
INSERT INTO cug_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mi kabə kaŋaki kpɛiŋ wi ndzɔŋni, wi kaŋaki i wumki mintam mi ndzɔŋni. Mi kabə kaŋaki kpɛiŋ wichu, wi kaŋaki i wumki mintam michu. Bə si kiə kpɛiŋ num i mintam mə mɔ wumki yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Chwɔŋbijuŋ bi fə́kəh biələ. Mbɛiŋ kɔ dəiŋ i dzakaki ndzaka wi ndzɔŋni, mbɛiŋ num bəni bəchu a? Mbɛiŋ kîə a gia yə yi kɔ yi jikə i shɔm yi mi wə, kɔ yə yi si buku i dzaka ki wə. ");
INSERT INTO cug_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mi kabə num wi kaŋa kiba ki biɛiŋ bindzɔŋni i wi mə, ma wi ni bwiliki a biɛiŋ bindzɔŋni yɛiŋ. Aka bə́ num wə wi kaŋaki kiba ki biɛiŋ bichu, wi ni bwiliki a biɛiŋ bichu yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mih fukuki i mbɛiŋ, jɔbi wə chɔkɔ bi nsaka wi gɔksini bi numki, mi kaŋaki i bi kɔmyi dzaka ki i ja yə yi nì bukuki i dzaka ki wə yi kpɛiŋni kə. ");
INSERT INTO cug_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mbɛiŋ kiəki a, jɔbi wə bə bi sakaki mi, a bi num já yə yi bukuki i dzaka ki wə, yə yi bi fə wi gia na kwa wi, a num tə já yə yi bukuki i dzaka ki wə, yi bi fə wi gbɔ nsaka.” ");
INSERT INTO cug_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Bəni bədɔkɔ bə̀ bɔ nì laniki bənchi bə Nyɔ bəh Bəfalasi ka bi dzaka i Jisɔs a, “Mi wi lanini, buku nəŋki a wɔ fə̂ gia yə yi chusiki ŋga bia ma buku yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisɔs chukuli i bɔ a, “Ŋgɔkɔ wichu wə wi bee Nyɔ, ka fiəni chu aka miŋkpaŋa wi tɔkɔlini, nəŋki i yɛiŋ gia yə yi chusiki ŋga biŋ! Ayakalə, mih ni chusi kə gia yidɔkɔ i ŋgɔkɔ wələ a kɔbi a yi mi wi ntum wi Nyɔ Jɔna. ");
INSERT INTO cug_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Asi Jɔna nì nɔ i bwɔkɔ yimbum shɔm kaŋ yitali, kɔ a liŋ asi mi wə yɛli wi kɔ Waiŋmi bi numki i kuku i kaŋ yitali wə. ");
INSERT INTO cug_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","A bi numki i jɔbi bi nsaka wi gɔksini wə, bəni bə Ninewi bi num bəh ŋgɔkɔ wi liə wələ fə bə jiə wi i ŋgəkə wə, kɔm bɔ, bəni bə Ninewi nì wɔkɔ gia yə Jɔna nì fukuki, kwuni shɔm yibɔ. Ayakalə, mbɛiŋ wɔkɔli, mi widɔkɔ kɔlə fa bəh gia yimbum yi tsə yi Jɔna. ");
INSERT INTO cug_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","A bi numki chɔkɔ bi nsaka wi kaasini wə, Yaa wə wi nì sakaki tumi ki Shɛba bi numki lə tə bəh ŋgɔkɔ wi liə wələ, fə wi liə i ŋgəkə wə, kɔm wi nì dza dzə i kiŋgɔksi ki mbi wə, i wɔkɔ mfi bi ŋkuŋ Sɔlɔmɔn. Ayakalə, mbɛiŋ wɔkɔli, mi widɔkɔ kɔlə fa bəh gia yimbum yi tsə yi Sɔlɔmɔn. ");
INSERT INTO cug_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jɔbi wə kiŋ'waka kichu si buku i mi wə ki tsə i chwa i nəŋki di biə ki ni nɔki. Ayakalə, jɔbi wə ki ka nəŋ mɔŋ, ");
INSERT INTO cug_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ki ni dzaka i gwu yi a, ‘Mih ni fiəni tsə i mih dzu i di biə mih ni buku.’ Jɔbi wə ki fiəni dzə yɛiŋ juŋ yiwɔ kɛiŋ yiyəə, num bə yaŋa kɛiŋsi yi ka yi baiŋki, ");
INSERT INTO cug_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ki ka fiəni dzə bəh biŋ'waka bichu bidɔkɔ nanitaŋ bi bəkə tsə wi, bɔ ka liə i nɔki yɛiŋ. Ayaka nɔni ki wəmaka mi ka fiəni bəkə tsə si ki nì kɔ i ninshiŋ. Akɔ ayaka si yi bi numki bəh ŋgɔkɔ wichu wələ.” ");
INSERT INTO cug_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Asi Jisɔs nì kɛiŋki wi dzaka i bəni yaka, yi num a, nih wi bəh bwa bə nih, dzə num i biŋ, bɔ nəŋ i dzaka bəh wi. ");
INSERT INTO cug_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mi widɔkɔ dzaka i Jisɔs a, “Nih wa bəh bwa bə nah kɔ i biŋ nəŋ a mbɛiŋ bɔ dzaka.” ");
INSERT INTO cug_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisɔs chukuli wi a, “Nih wuŋ kɔ ndə, bwa bə nih bəŋ num bənaiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Si wi bikə yakadəiŋ ka sɔkɔki bəni bu bə mbaŋ, ka dzaka a, “Nih wuŋ bəh bwa bə nih bəŋ kɔ bələ. ");
INSERT INTO cug_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mbɛiŋ kîə a na ndə wə wi fəki gia yə Ba wuŋ i bɛiŋ kɔŋki akɔ wi wə wi kɔ waiŋnih wuŋ, bəh jɛmi yiŋ, bəh nih wuŋ.” ");
INSERT INTO cug_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","A i chɔkɔ biwɔ wə, Jisɔs ni dza buku i dzu, ka tsə shinum kɔmsi i kinchwɔ kimbum kpəŋ. ");
INSERT INTO cug_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mbaŋ wi bəni wimbum kwu juŋni tali wi lə maaa. Wi ka dza liə shinum lɔ i ŋgwuki mə i bɔkɔ, mbaŋ wiwɔ ka shinumyi i bɔkɔ kpəŋ. ");
INSERT INTO cug_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Wi yisi i fukuki gia yiduli i bɔ i bəndi wə. Wi dzaka a, “Mi widɔkɔ nì laa i tsə mu ŋgɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Asi wi nì muki, bədɔkɔ gbɔyi i dzəh, minyəni dzə chumyi dzi. ");
INSERT INTO cug_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bəŋgɔkɔ bədɔkɔ gbɔyi i di biə nshwaiŋ nì num i biaŋa bɛiŋ, nshwaiŋ num ndzɔŋ kə fɛiŋ, ŋgɔkɔ wiwɔ kɔmsi buku yaka, kɔm nshwaiŋ nì chumiki kə fɛiŋ ");
INSERT INTO cug_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jɔbi wə wɔŋ nì yisi i baiŋki ka twɛiŋ ŋgɔkɔ wiwɔ. Si gaaŋ yiwɔ nì ka liə ndzɔŋ dəkə i kuku, wi ka kpiyi. ");
INSERT INTO cug_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bəŋgɔkɔ bədɔkɔ gbɔyi i bifaka wə. Bifaka biwɔ ka kɔ baŋ ŋgɔkɔ wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bəŋgɔkɔ bədɔkɔ gbɔyi num i nshwaiŋ yindzɔŋni wə, ka buku yaka ka kɔ ka wum nalə. Ayaka chwɔŋ bidɔkɔ kaŋa dzə́kəh gbi, bidɔkɔ mbaŋbisɔ, bidɔkɔ mbaŋtia. ");
INSERT INTO cug_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mi wə wi kaŋaki bintuni, wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Bwa bə mbaŋ bə Jisɔs dza dzə bikə i wi a, “Akɔ kɔm nə wɔ dzakaki i bəni bələ num i bəndi wə a?” ");
INSERT INTO cug_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Wi chukuli i bɔ a, “Akɔ mbɛiŋ bə̀ Nyɔ kɔ wi fə lɔ a mbɛiŋ kîə gia yə yi nyumiki i ŋkuŋ bi bɛiŋ wə. Ayakalə, wi nəki fə kə a bəni bələ kîə. ");
INSERT INTO cug_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mbɛiŋ kîəki a mi wə wi kaŋaki fiɛŋ bə ni kpɛiŋsiki lə ma wi kaŋaki biduli. Ayakalə, mi wə wi kaŋaki kə fiɛŋ, bə ni dzɔ bwili lə i wi na fi twɛsi fiə wi kaŋaki. ");
INSERT INTO cug_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Akɔ gia yə mih dzakaki i bɔ num i bəndi wə, kɔm bɔ tsɛiŋki lə di yɛiŋ kə. Bɔ wɔkɔliki lə gia, kɔbi i wɔkɔ nabə i kiə yi gia. ");
INSERT INTO cug_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gia yə mi ntum wi Nyɔ Isaya nì dzaka, yi dzə lansi kpɛiŋ nalə bəh gia yə bəni bələ fəki. Wi nì kɔ wi dzaka a, ‘Mbɛiŋ bi wɔkɔliki lə gia na bindzɔŋ, ayakalə wɔkɔ kiə kə. Mbɛiŋ bi tsɛiŋki lə di na bindzɔŋ, yɛiŋ kə. ");
INSERT INTO cug_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yi num yakadəiŋ kɔm shɔ́m yi bəni bələ kɔ yi də lɔ, bintuni bibɔ chini, num bɔ baŋ lɔ dzə́kəh yibɔ. Bɔ fə yakadəiŋ ka bɔ ma yɛiŋki di bəh dzə́kəh yibɔ, wɔkɔ gia bəh bintuni bibɔ, ka shɔ́m yibɔ shiliki, bɔ bi fiəni dzə i mih wə, ma mih chuku bɔ.’ ");
INSERT INTO cug_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ayakalə, kimbɔiŋsi kimbum kɔ kimbɛiŋ kɔm dzə́kəh yimbɛiŋ kɔ yə yi yɛiŋki, bintuni bimbɛiŋ num biə bi wɔkɔki. ");
INSERT INTO cug_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mih fukuki ŋkɔŋ i mbɛiŋ a, bəni bə ntum bə Nyɔ bəduli bəh bəni bə chəŋ bədɔkɔ nì shiki dəki lə i yɛiŋ gia yə mbɛiŋ yɛiŋki, bɔ nəki yɛiŋ kə. Bɔ nì dəki lə tə i wɔkɔ gia yə mbɛiŋ wɔkɔki, bɔ nəki wɔkɔ kə. ");
INSERT INTO cug_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mbɛiŋ wɔkɔ la gia yə ndi wələ chusiki kɔm mi wə wi nì muki ŋgɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jɔbi wə mi wɔkɔki gia kɔm ŋkuŋ bi bɛiŋ maka wi wɔkɔ kiə, Satan mi wichu ka dzə chufi bwili gia yə bə si gbɛli i wi shɔm. Wələ kɔ ŋgɔkɔ wə bə nì muki wi gbɔyi i dzəh. ");
INSERT INTO cug_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ŋgɔkɔ wə bə nì muki tsəki wi gbɔyi i di bi kitəh wə kɔ mi wə wi wɔkɔki gia yi Nyɔ akisəkə dzɔ yi bəh kinsaŋli. ");
INSERT INTO cug_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ayakalə, gaaŋ yiwɔ num maka yi liəni i gwu yi wə. Yi mɔti a twɛsi. Jɔbi wə ŋgəkə yisi nabə mbwaŋ gvu i wi chɛiŋ kɔm gia yiwɔ, wi gbɔ i kimbum ki wə akisəkə. ");
INSERT INTO cug_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ŋgɔkɔ wə bə nì muki tsəki wi gbɔyi i bifaka wə, kɔ mi wə wi wɔkɔki gia yi Nyɔ, ayakalə kifum kɔm biɛiŋ bi mbi biələ, bəh kiŋkɔŋ i kaŋa mbum bi juŋni baaŋ gia yiwɔ i wi shɔm yi laka kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ŋgɔkɔ wə bə nì muki tsəki wi gbɔyi i nshwaiŋ yindzɔŋni wə wi bə́ kɔ, kɔ mi wə wi wɔkɔki gia yiwɔ, wɔkɔ yi na bindzɔŋ ka fəki asi yi nəŋki, wəmaka mi kɔ aka ŋgɔkɔ wə wi nì wumki mintam bədɔkɔ nya dzə́kəh gbi, bədɔkɔ dzə́kəh mbaŋbisɔ, bədɔkɔ mbaŋtia.” ");
INSERT INTO cug_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisɔs chu ti ndi widɔkɔ i bɔ a, “Bə kɔ i fəkəli ŋkuŋ bi bɛiŋ bəh mi wə wi nì tsə i mu ŋgɔkɔ wi gəŋ wi ndzɔŋni i wi khə. ");
INSERT INTO cug_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jɔbi wə bəni nì nɔki, mbaiŋŋni wi dzə ka mu ŋgɔkɔ wi mfwaŋ wə wi bwɔsiki gəŋ i ŋgɔkɔ wi gəŋ kintəəŋ ka nyə. ");
INSERT INTO cug_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jɔbi wə gəŋ yiwɔ nì kɔ yaka lɔ ka yisi i nyaki nchaiŋki, ŋgɔkɔ wi mfwaŋ wə ka chusi tə. ");
INSERT INTO cug_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Bəni bə nɔm bə mi wiwɔ dzə bikə i wi a, ‘Tikwili, wɔ nì tsə mu num ŋgɔkɔ wi gəŋ i khə, ŋgɔkɔ wi mfwaŋ wələ ka nyani na dəiŋ ka wi numki i yɛiŋ kintəəŋ a?’ ");
INSERT INTO cug_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wi chukuli i bɔ a, ‘A fə mbaiŋŋni wuŋ gia yiwɔ yakadəiŋ.’ Bəni bə nɔm bəwɔ bikə i wi a, ‘Wɔ nəŋki a buku tsə̂ bâayi a?’ ");
INSERT INTO cug_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tikwili wibɔ nəiŋ dzaka i bɔ a, ‘Aka bə́ num yaka jɔbi wə mbɛiŋ ni saŋaki ma mbɛiŋ ni saŋa tasiki bəh gəŋ yɛiŋ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mbɛiŋ bêe ma bɔ bəchi kɔɔki i tsə buku jɔbi wi kɔhni wə. Ka a ni numki i jɔbi wi kɔhni wə, mih ni dzaka i bəni bə kɔhni bəwɔ a bɔ yisi bâayi mfwaŋ biwɔ bɔ jûŋni kâŋa jîə i kaka kaka wə, ka bə ni kpa, ma bə ni ka juŋni jiə gəŋ i mih gba.’” ");
INSERT INTO cug_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisɔs chu ti ndi widɔkɔ i bɔ a, “Ŋkuŋ bi bɛiŋ kɔ aka dzəkəh wi ŋgɔkɔ wi fintam fidɔkɔ, wə mi nì dzɔ mu i wi khə. ");
INSERT INTO cug_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ŋgɔkɔ wələ kɔ dzəkəh yiwɔ sɛiŋni na bəh ŋga tsə bəŋgɔkɔ bədɔkɔ bəchi. Ayakalə, jɔbi wə wi buku yaka wi ni kɔɔ, wi kpali tsə nteŋ wi biɛiŋ bichi, wi fiəni chu kpɛiŋ ka minyəni mə mɔ fuliki bɛiŋ dzə maa júŋ yibɔ i cha yiwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisɔs chu ti bɔ bəh ndi widɔkɔ a, “Ŋkuŋ bi bɛiŋ kɔ aka dzɔɔŋ yə miŋkpaŋa nì fəkə muku i biŋkuŋɔ bimbum wə bitali, ka fwɛŋni ka chwali dzɔɔŋ yiwɔ fə muku miwɔ yaka.” ");
INSERT INTO cug_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisɔs nì dzaka gia yələ yichi i mbaŋ wi bəni, a num i bəndi wə. I yi ŋkɔŋ wə wi nì ka dzaka dəkə gia yidɔkɔ i bɔ a kɔbi i bəndi wə. ");
INSERT INTO cug_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wi nì fəki yakadəiŋ ka yi dzə kpɛiŋ asi mi wi ntum wi Nyɔ widɔkɔ nì dzaka a, “Mih bi wɛliki dzaka kəŋŋ a bəndi wə. Mih bi tɔyi gia yə yi nì num i nyumi wə i yisi asi bə nì maa mbi.” ");
INSERT INTO cug_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisɔs nyə bee mbaŋ wi bəni ka liə tsə dzu. Bwa bu bə mbaŋ biəli wi bikə i wi a, “Fûku baiŋsi i buku kɔm gia yə ndi wi mfwaŋ wə i khə chusiki.” ");
INSERT INTO cug_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Wi ka dzaka a, “Mi wə wi nì muki ŋgɔkɔ wi ndzɔŋni wə, akɔ mi wə yɛli wi kɔ Waiŋmi. ");
INSERT INTO cug_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Khə wiwɔ kɔ mbi wələ. Ŋgɔkɔ wi ndzɔŋni wiwɔ num bwa bə̀ bɔ kɔ bə ŋkuŋ bi Nyɔ. Mfwaŋ biwɔ num bwa bə mi wichu wə. ");
INSERT INTO cug_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ayaka mbaiŋŋni wə wi nì mu ŋgɔkɔ wi mfwaŋ wiwɔ akɔ ŋkpɛli. Jɔbi wi kɔhni wiwɔ bi numki jɔbi wə mbi wələ bi kigɔksiki. Bəni bə kɔhni bəwɔ kɔ bəchinda bə Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Asi bə si baayi mfwaŋ juŋni ka bə kpa i gbuku wə, kɔ yakadəiŋ si yi bi numki i jɔbi wə mbi wələ bi gɔksiki. ");
INSERT INTO cug_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mi wə yɛli wi kɔ Waiŋmi bi chiŋsiki lə bəchinda bu, i nyani juŋni nnya biɛiŋ bichi biə bi dzəki bəh chu i bəni wə bəh bəni bəchu bəchi bə̀ bɔ fəki chu bə bi bwili bɔ i ŋkuŋ bi wə, ");
INSERT INTO cug_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ayaka bə lɔɔ bəchu i gbuku wi ghəkəni wə. A num di biə bəni bi dəki dzi jəŋ. ");
INSERT INTO cug_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ayakadəiŋ, bəni bə̀ bɔ kɔ chəŋ bi baiŋki aka wɔŋ i ŋkuŋ bi Ba wibɔ wə. Mi wə wi kaŋaki bintuni, wi wɔ̂kɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ŋkuŋ bi bɛiŋ kɔ aka bəkə ki kpɔ kə mi nì tsə yɛiŋ num bə nyumi i khə. Wi ka fiəni baŋ ki, ka kwɛki wɔkɔ ndzɔŋni, ka tsə taŋni biɛiŋ bichi biə wi nì kaŋaki, ka tsə taŋ khə wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ayaka ŋkuŋ bi bɛiŋ chu kɔ aka mi wi shi widɔkɔ wə wi nì nyaniki nəŋki ŋkaiŋni kitəh kidɔkɔ ki ndzɔŋki nalə. ");
INSERT INTO cug_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jɔbi wə wi nì nəŋ yɛiŋ widɔkɔ wə wi kɔ na wi ləkəli. Wi ka tsə taŋni biɛiŋ bichi biə wi nì kaŋaki wi tsə taŋ tə wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ŋkuŋ bi bɛiŋ chu kɔ aka gbi wə bə si tum i bɔkɔ, ayaka ŋgɔkɔ yi bwɔ́kɔ yichi juŋni yɛiŋ mə, ");
INSERT INTO cug_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","yi jikə. Bəni guku bwili wi i kpa. Shinum kuku, sabibwili bwɔ́kɔ yindzɔŋni jiə i káh wə, shukutɔkɔ yichu yə. ");
INSERT INTO cug_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Lə yibi numki ayaka i jɔbi wə mbi wələ bi gɔksiki. Bəchinda bə Nyɔ bi buku dzə i gaali bəni bəchu i bəni bə chəŋ wə, ");
INSERT INTO cug_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ayaka bə lɔɔ bəchu i gbuku wi ghəkəni wə, a num di biə bəni bi dəki dzi jəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisɔs ka bikə i bwa bu bə mbaŋ a, “Mbɛiŋ wɔkɔ kiə alə gia yələ yichi a?” Bɔ bum a “Aaŋ.” ");
INSERT INTO cug_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wi ka dzaka i bɔ a, “Yi kɔ a, mi wichi wə wi laniki bənchi bə Nyɔ, num bə lani lɔ wi kɔm ŋkuŋ bi bɛiŋ, wi kɔ aka tii juŋ wə wi kaŋaki kiba ki ki biɛiŋ, wi num i bwili biɛiŋ bimfiaŋ nabə bikpu yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jɔbi wə Jisɔs nì kaasi i tiki bəndi bələ, wi ka dza nyə fɛiŋ, ");
INSERT INTO cug_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","dzə i kwili wə, tsə liə ka laniki bəni i juŋ yibɔ yi tsani wə. Bɔ ka wɔkɔliki nlani wi ka numki lɔ bəh ŋkaiŋyi, yisi i kaiŋyiki a, “Mi wələ dzɔ faiŋ biələ mfi bimbum bəh ŋga i fəki ŋkaiŋni wi gia yələ yɛiŋ na? ");
INSERT INTO cug_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A fa kɔkə a waiŋ tikwili wə wi kaaŋŋki kɛiŋ na? Ntə nih wi kɔ Meli a? Ntə bwa bə nih wi kɔ Jɛm bəh Yɔsɛf bəh Samɔn bəh Judas a? ");
INSERT INTO cug_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ntə jɛ́mi yi yichi kɔ bəh bukumbɛiŋ fa wə a? Mi wələ nyə faiŋ bəh yələ gia yichi lə a?” ");
INSERT INTO cug_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Si bɔ kaiŋyiki yakadəiŋ ka nəiŋ wi. Jisɔs ka dzaka i bɔ a, “Bə si kɔksi lə mi wi ntum wi Nyɔ i di bichi wə, a kɔbi a i tumi ki wə, bəh i chwɔŋkijuŋ ki wə.” ");
INSERT INTO cug_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jisɔs na chu fə gia yi kaŋyini yiduli fɛiŋ, kɔm bɔ nì ka jiə dəkə shɔm i wi. ");
INSERT INTO cug_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A nì kɔ i jɔbi wiwɔ wə, Ŋkuŋ Hɛlɔd wə wi nì sakaki kimbu ki tumi ki Galili, wi wɔkɔ kɔm nɔm wi Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wi dzaka i bətii di bu a, “Mi wələ kɔ Jɔn Njulibɔkɔ si wi fiəni dza i kpi wə. Akɔ gia yə yi fə wi, na ka wi kaŋaki ŋga i fəki gia yi kaŋyini yələ lə.” ");
INSERT INTO cug_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","A nì kɔ num Hɛlɔd nì dzaka, bə kwa kaŋa Jɔn, bə fa i juŋ yi nsəŋ mə kɔm bə Hɛlɔdia kpə Filib wə wi nì kɔ waiŋnih Hɛlɔd, wə Hɛlɔd nì dzɔ ka kpə wi. ");
INSERT INTO cug_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jɔn nì nəiŋki lə ka dzaka a nchi bumki kə a wi kɔlə i dzɔ̂ wi ka kpə wi. ");
INSERT INTO cug_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hɛlɔd ka nəŋki dzəh i wɔɔ Jɔn, ayakalə wi lwa bəni, kɔm bəni nì dzɔki Jɔn ka mi wi ntum wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Yi dzə num i chɔkɔ biə Ŋkuŋ Hɛlɔd nì fəki dzini, i kwakaki chɔkɔ biə bə nì bwɔ wi yɛiŋ. Waiŋ Hɛlɔdia wi kpaŋni ka liə biŋ i bəni nshiŋ, Hɛlɔd yɛiŋ yaka gwu shili wi nalə. ");
INSERT INTO cug_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wi kaka i waiŋkpaŋni wiwɔ, dzi ŋkaiŋ a ŋgaiŋ ni fiali lə wi bəh na finə fiə wi bikə a ŋgaiŋ nya i wi. ");
INSERT INTO cug_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nih waiŋkpaŋni wiwɔ ka nyini waiŋ wi a wi dzaka i wi a, wi nyâ ŋgaiŋ bəh fwu wi Jɔn Njulibɔkɔ i nsaŋa wə. ");
INSERT INTO cug_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wi ka dzaka, Ŋkuŋ Hɛlɔd wɔkɔ gia yiwɔ yakadəiŋ gwu kpi wi. Ayakalə, kɔm bə ŋkaiŋ biə wi nì dzi lɔ i bəni bə bini nshiŋ, wi ka dzaka a bɔ fə̂ asi waiŋkpaŋni wiwɔ dzaka. ");
INSERT INTO cug_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wi ka faaŋ bəni, bɔ tsə̂ i juŋ yi nsəŋ mə gbâ fwu wi Jɔn, ");
INSERT INTO cug_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","dzə bəh wi i nsaaŋ wə nya i waiŋkpaŋni wiwɔ, wi tsə bəh wi nya i nih wi. ");
INSERT INTO cug_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Bwa bə Jɔn bə mbaŋ tsə dzɔ wini wi Jɔn ka ləə, ka tsə fuku ntum wiwɔ i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jɔbi wə Jisɔs nì wɔkɔ gia yə yi num bəh Jɔn, ka liə i ŋgwuki mə baka gwu tsə i di biə bəni nì kɔkə fɛiŋ. Ayakalə, mbaŋ wi bəni wɔkɔ, ka buku i kikwili wə nyani bəh gvu biəli wi. ");
INSERT INTO cug_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jɔbi wə Jisɔs nì tsə buku fɛiŋ kpa, wi yɛiŋ mbaŋ wi bəni lə maaa. Ayaka nshɛiŋ kwa wi bəh bɔ, wi ka chukuki bəni bə̀ bɔ nì gwɛiŋki. ");
INSERT INTO cug_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","A bə́ num i fijɔbi, bwa bu bə mbaŋ dza dzə yɛiŋ wi ka dzaka i wi a, “Fa kɔ i chwa, num jɔbi tsə lɔ, dzâka a mbaŋ wi bəni bələ tsə̂ i kikwili ki kɔmsini wə i tâŋ dzɛiŋ bibɔ.” ");
INSERT INTO cug_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisɔs chukuli i bɔ a, “Bɔ kaŋaki kə i nyə. Mbɛiŋ mwi nyâ bɔ bəh dzɛiŋ bɔ dzî.” ");
INSERT INTO cug_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Bɔ chukuli i wi a, “Buku kaŋaki a chɔkɔ yi blɛd yite bəh bwɔ́kɔ yifa shəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wi dzaka i bɔ a, “Mbɛiŋ dzə̂ nyâ i mih.” ");
INSERT INTO cug_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Bɔ dzə nya, wi ka dzaka a mbaŋ wi bəni bəwɔ numyi kuku i mfwaŋ wə. Wi dzɔ chɔkɔ yi blɛd yə yite bəh bwɔ́kɔ yifa yə, tsɛiŋ yaka i bɛiŋ, nya kiyɔŋni i Nyɔ, ka gbɛyi chɔkɔ yiwɔ ka nya i bwa bu bə mbaŋ, bɔ gaa i mbaŋ wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bəni bəchi dzi fwuli. Bwa bə Jisɔs bə mbaŋ ka juŋni biŋka biə bi nì bɛsi bi jikə i káh wə jwɔfi ntsɔ yifa. ");
INSERT INTO cug_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Bəni bə̀ bɔ nì dzi biɛiŋ bidzini biwɔ a nì kɔ bənyuku ka bənchuku bəte, na ka bə faaki bəkaŋa bəh bwa. ");
INSERT INTO cug_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jisɔs ka dzaka i bwa bu bə mbaŋ a bɔ lîə i ŋgwuki mə ma bɔ dâŋki tsə̂ki i ninshiŋ i kiwuŋ kidɔkɔ kəyaka wə, a ŋgaiŋ baaŋ bɔni i mbaŋ wi bəni wə ka bɔ kwɛki. ");
INSERT INTO cug_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Si wi ni baaŋ ka bɔni i bɔ, ka dza yaka i ŋkwuŋ bɛiŋ a wi mbɔŋ i tsa. Biŋ jii, wi kɛiŋ fɛiŋ a wi mbɔŋ. ");
INSERT INTO cug_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ayakalə, a nì kɔ i jɔbi wiwɔ wə, ŋgwuki wiwɔ nì kɔ num wi liə tsə i bɔkɔ kintəəŋ nanu, bɔkɔ fiəli bəh wi, kɔm fiəkə nì dzəki i bɔ nshiŋ chini ŋgwuki wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ayaka a num asi chɔkɔ wɔɔki dzəki, Jisɔs nyə ka dzəki i bɔ wə nyani dzə i mwi bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bwa bu bə mbaŋ ka yɛiŋ wi si wi nyaniki dzəki i mwi bɛiŋ, ndzaŋ kwa bɔ. Ayaka bɔ ka dzakaki a, “Akɔ ŋkwusa.” Bɔ ka wiliki bəh ŋga lwa. ");
INSERT INTO cug_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Akisəkə Jisɔs ka dzaka i bɔ a, “Mbɛiŋ kâŋa shɔ́m yimbɛiŋ, akɔ mih. Mbɛiŋ ma lwâki.” ");
INSERT INTO cug_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bita dzaka i wi a, “Bah a kabə num wɔ, wɔ dzâka ma mih tə nyâni dzə̂ i mwi bɛiŋ i dzə i wɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisɔs dzaka i wi a, “Dzə̂ la.” Bita ka buku i ŋgwuki mə ka nyaniki tsəki i mwi bɛiŋ i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Si wi nì nyaniki tsəki yakadəiŋ, wi ka yɛiŋ si fiəkə fəki, wi bə̀ lwa, ka yisi i miniki i mwi mə. Si wi ni miniki shiki yakadəiŋ, wi ka də bwili a, “Bah gâmti mih!” ");
INSERT INTO cug_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Akisəkə Jisɔs ka nani tsə tsɛiŋ ka kaŋa wi dzaka i wi a, “Ɔ ɔɔ, mbum wa sɛiŋniki lə na bəh ŋga! Wɔ si məŋniki kɔm nə?” ");
INSERT INTO cug_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bɔ wi ka yaka liə i ŋgwuki mə, fiəkə yiwɔ ka kpichumi. ");
INSERT INTO cug_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Bwa bu bə mbaŋ bə̀ bɔ nì kɔ i ŋgwuki mə ka nya ŋkɔksi i wi dzaka a, “Ŋkɔŋ, wɔ kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bɔ daŋ bɔkɔ yə buku tsə i kimbu ki Genesalet wə. ");
INSERT INTO cug_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bəni bə fɛiŋ yɛiŋ kiə wi, ka faaŋ ntum i bimbu biwɔ wə bichi, bəni ka dzəki bəh bəni bə jwɛ́iŋ bəchi i Jisɔs, ");
INSERT INTO cug_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","bɔ tsa wi a wi bêe ma bɔ kɔ̂m shəŋ a jəŋ wi wimbuŋ. Ayaka bɔ bəchi bə̀ bɔ nì kɔmki wi, ka bɔniki. ");
INSERT INTO cug_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Bəfalasi bəh bəni bədɔkɔ bə̀ bɔ nì laniki bənchi bə Nyɔ, nyə i Jɛlusalɛm dzə i Jisɔs ka bikə i wi a, ");
INSERT INTO cug_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Akɔ kɔm nə wə bwa ba bə mbaŋ bəkəliki nɔni ki kwili ki bətii bəbuku bə kikpu wə a? Bɔ si wɔkɔ kə kaŋ i dzəh yə nchi nəŋki ka bɔ dzi.” ");
INSERT INTO cug_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisɔs chukuli i bɔ a, “Akɔ kɔm nə wə mbɛiŋ bwiŋki fimbɛiŋ bənchi bə Nyɔ, mbɛiŋ biəli num lɔ nɔni kimbɛiŋ ki kwili a? ");
INSERT INTO cug_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mih dzakaki yələ, kɔm Nyɔ nì kɔ wi dzaka lɔ a, ‘Kɔ̂ksi ba wa bəh nih wa.’ Chu dzaka tə a, ‘Mi ka tɔyi ba wi nabə nih wi, bə wɔ̂ɔ tɔ̂kɔ wəmaka mi.’ ");
INSERT INTO cug_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ayakalə, mbɛiŋ dzaka yimbɛiŋ a, ‘Mi ka dza dzaka i ba wi nabə nih wi a, “Fiɛŋ fiə wɔ si kɔ i kwati i mih, mih nya lɔ i Nyɔ,”’ ");
INSERT INTO cug_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","yaka kɔ wi kɔkə i chu kɔksi ba wi nabə nih wi i dzɔ fiɛŋ fiwɔ i nya i bɔ. Akɔ alə si mbɛiŋ biəliki nɔni kimbɛiŋ ki kwili, fə a gia yi Nyɔ fiəni chu gia yi kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Bəni bə̀ bɔ dzakaki chi fə chi! Gia yə mi wi ntum wi Nyɔ Isaya nì dzaka kɔm mbɛiŋ kɔ na ŋkɔŋ, si wi nì dzakaki a, ");
INSERT INTO cug_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bəni bələ kɔksiki mih a dzu yi dzaka wə, shɔ́m yibɔ num na i dzəh yi dəəŋ i mih wə. ");
INSERT INTO cug_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ntsa wibɔ i mih kɔ a wi kilɔlɔ, kɔm bɔ dzɔ gia yə a kwakaki bəni lani a, akɔ bənchi bəŋ.’” ");
INSERT INTO cug_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisɔs bi dza bɔɔŋ mbaŋ wi bəni bɔ dzə, ka dzaka i bɔ a, “Mbɛiŋ wɔ̂kɔli ndzɔŋ nalə. ");
INSERT INTO cug_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fiɛŋ fiə fi liəki i dzaka ki mi wə, si bəkəli kə mi. Akɔ num fiə fi bukuki bukuni i dzaka ki mi wə, fikɔ i bəkəli wi.” ");
INSERT INTO cug_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bwa bə Jisɔs bə mbaŋ dza dzə dzaka i wi a, “Wɔ kiəki lə a Bəfalasi si wɔkɔ gia yə wɔ si dzakaki ayaka yi lɔ bɔ a?” ");
INSERT INTO cug_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisɔs chukuli i bɔ a, “Na winaiŋ kpɛiŋ wə Ba wuŋ wə wi kɔ i bɛiŋ nì ka yəə dəkə bə bi baa lə wi. ");
INSERT INTO cug_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mbɛiŋ dâli kɔm bə bɔ, bɔ kɔ bimfəkə bi chusiki dzəh i bəni. Kimfəkə ka chusiki dzəh i kidɔkɔ, bɔ bəchi ni tsə gbɔyi i fəŋ mə.” ");
INSERT INTO cug_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bita dzaka i Jisɔs a, “Fûku bâiŋsi i buku gia yə ndi wələ dzakaki.” ");
INSERT INTO cug_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisɔs bikə a, “Yaka mbɛiŋ tə wɔkɔki kiəki kə gia a? ");
INSERT INTO cug_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mbɛiŋ kiəki kə a biɛiŋ bichi biə bi liəki i dzaka ki mi wə bi shi i tɔɔ wi wə bi si fiəni buku bukuni a? ");
INSERT INTO cug_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ayakalə, fiɛŋ fiə fi bukuki i dzaka ki mi wə, fi nyəki dzəki num i wi shɔm. Akɔ fiɛŋ fiə fi kɔ i bəkəliki mi. ");
INSERT INTO cug_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Fi si nyə num i shɔm mə, na ka mi kaŋaki kiŋkwaka kichu, ka wi wɔɔ mi, dzɔ kpə mi nabə nyum mi, tɔkɔli, chwɔ, beeŋ nsaka wi ntəkə nabə i bəkəli yɛli wi mi. ");
INSERT INTO cug_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yələ kɔ gia yə yi kɔ i bəkəli mi. Ayakalə, i dzi maka bə wɔkɔ kaŋ kɔkə i bəkəli mi.” ");
INSERT INTO cug_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisɔs ni dza fɛiŋ baka gwu ka tsə i kimbu ki Taya bəh ki Sidɔn wə. ");
INSERT INTO cug_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ayakadəiŋ, yi dzə num a miŋkpaŋa widɔkɔ i Kanan nì kɔlə fɛiŋ, wi nyə dzə yɛiŋ Jisɔs, də i wi a, “Ɔ Bah, waiŋ Ŋkuŋ Dɛbit, kwasi nshɛiŋ i mih. Waiŋ wuŋ wi kpaŋni kɔ chinda wi ŋkpɛli widɔkɔ njiŋsiki wi na bəh ŋga.” ");
INSERT INTO cug_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ayakalə, Jisɔs wɔkɔ, nəki dzaka kə gia yidɔkɔ. Bwa bu bə mbaŋ kini dzə tsa wi dzaka a, “Dzâka a miŋkpaŋa wələ dzâ nyə̂. Kɔm wi biəliki bukumbɛiŋ wi də nya ŋgəkə.” ");
INSERT INTO cug_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisɔs chukuli a, “Bə nì faaŋ mih num i bəni Islae shəŋ bə̀ bɔ kɔ ka shwáŋ yə yi nyə ka njiŋki tsəki.” ");
INSERT INTO cug_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ayakalə, miŋkpaŋa wiwɔ ka tum binyu i Jisɔs nshiŋ dzaka a, “Bah, gâmti mih.” ");
INSERT INTO cug_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisɔs chukuli i wi a, “Yi ndzɔŋki kə i dzɔ dzɛiŋ bi bwa i lɔɔ i bíə.” ");
INSERT INTO cug_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Miŋkpaŋa wiwɔ dzaka a, “Akɔ ŋkɔŋ Ba wuŋ. Ayakalə, jɔbi wə tikwili si dzi, bíə si bɔŋyi lə biŋka biə bi si gbɔyi.” ");
INSERT INTO cug_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jisɔs ka chukuli i wi a, “Ɔ miŋkpaŋa wələ, mbum wa ləkəki lə. Ma yi num i wɔ asi wɔ kɔŋki.” A fɛiŋ wə waiŋ wiwɔ bɔnih. ");
INSERT INTO cug_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisɔs bi dza nyə fɛiŋ ka tsəki, tsə daŋsi i kɔmsi tsə i kinchwɔ kimbum ki Galili wə, ka yaka tsə i ŋkwuŋ bɛiŋ, shinum fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mbaŋ wi bəni widuli ka juŋni dzə i wi kpəŋ lə maaa. Bədɔkɔ nì dzəki bəh bəni bə̀ bɔ nì gbɔki nyaniki, bəh bə̀ bɔ nì kaŋaki bəŋgəkə i gwu wə, bəh bə̀ bɔ nì kɔ bimfəkə, bəh bə̀ bɔ nì kɔ binchini, bəh bə jwɛ́iŋ bədɔkɔ bəduli. Si bɔ nì dzəki bəh bɔ yakadəiŋ, nɔsi i wi nshiŋ wi chuku bɔ. ");
INSERT INTO cug_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mbaŋ wiwɔ ka num bəh ŋkaŋyi si bɔ nì yɛiŋki binchini dzaka, bəni bə̀ bɔ nì kaŋaki bəŋgəkə i gwu wə bɔnih, bəŋgbɔ nyani nyani tə chəŋ, bimfəkə yɛiŋ di. Bɔ tum bikum bi Nyɔ wi bəni bə Islae. ");
INSERT INTO cug_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisɔs ka bɔɔŋ bwa bu bə mbaŋ bə̀ dzaka i bɔ a, “Mih kwasiki lə nshɛiŋ i mbaŋ wələ, kɔm bɔ num bəh mih i kaŋ yitali wə, fiɛŋ fiə bɔ kɔ i dzi kɔbi. Mih kɔŋki kə i bee bɔ, a bɔ tsəki bəh dzɔŋ, kɔm bɔ kɔlə i tsə gbɔyi kɔm dzɔŋ i dzəh.” ");
INSERT INTO cug_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Bwa bu bə mbaŋ bikə i wi a, “Buku ki dzɔki faiŋ biɛiŋ bidzini i fa chwa biə buku kɔ i saaŋ ŋkaiŋni wi mbaŋ wi bəni bələ yɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisɔs bikə i bɔ a, “Mbɛiŋ kaŋaki chɔkɔ yi blɛd yi maiŋ?” Bɔ chukuli a, “Yi kɔ nanitaŋ bəh mibwɔkɔni midɔkɔ twɛsi.” ");
INSERT INTO cug_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jisɔs ka dzaka a mbaŋ wi bəni bəwɔ nûmyi i kuku. ");
INSERT INTO cug_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bɔ numyi, wi dzɔ chɔkɔ yi blɛd yə nanitaŋ bəh bwɔ́kɔ yə, nya kiyɔŋni i Nyɔ, ka gbɛyi nya i bwa bu bə mbaŋ, bɔ gaa i bəni bəwɔ. ");
INSERT INTO cug_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mi wichi dzi fwuli. Bɔ ka juŋni biŋka biə bi nì bɛsi, bi jikə káh nanitaŋ. ");
INSERT INTO cug_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Bəni bə̀ bɔ nì dzi, a nì kɔ bənyuku bənchuku bənaa, na ka bə faaki bəkaŋa bəh bwa. ");
INSERT INTO cug_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wi ka bee mbaŋ wiwɔ bɔ kwɛ. Wi liə i ŋgwuki mə tsə i kimbu ki Magadan wə. ");
INSERT INTO cug_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Bəfalasi bəh Bəsadusi nì dza dzə i Jisɔs, i mɔmsi wi, ka dzakaki a wi fə̂ gia yə yi chusiki ŋga biə bi nyə i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jisɔs dzaka i bɔ a, “Jɔbi wə asi num i fijɔbi bɔɔli bɔkɔ, mbɛiŋ ka dzakaki a, ‘Biŋ ni buku ndzɔŋ lə’, kɔm mbɛiŋ si yɛiŋ bɔɔli bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ayaka jɔbi wə asi num kinchɔŋɔchɔŋɔ bɔɔli bɔkɔ num bikwu baŋ, mbɛiŋ ka dzakaki a, ‘Dzaŋ yi fiəkə yiləkəli ni numki lə daiŋ’, kɔm mbɛiŋ si yɛiŋ si bɔɔli bɔkɔki num bikwu baŋ. Mbɛiŋ kiəki i tsɛiŋ bɔɔli i kiə si biŋ ni num, ayakalə akɔ kɔm nə la mbɛiŋ kiəki kə bənchəsi bə̀ bɔ chusiki gia yə yi numki i jɔbi wi liə wə a? ");
INSERT INTO cug_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ŋgɔkɔ wichu wə wi bee Nyɔ ka fiəni chu aka miŋkpaŋa wi tɔkɔlini, nəŋki gia yə yi chusiki ŋga biə bi nyə bɛiŋ. Mih ni chusi kə gia yidɔkɔ i ŋgɔkɔ wələ a kɔbi a yi mi wi ntum wi Nyɔ Jɔna.” Si wi dzaka yakadəiŋ ka bee bɔ, dza nyə. ");
INSERT INTO cug_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jɔbi wə bwa bə mbaŋ bə Jisɔs nì daŋ buku i kiwuŋ kəyaka wə ka kwaka a bɔ si dali i dzɔ blɛd. ");
INSERT INTO cug_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisɔs ka bi dza dzaka i bɔ a, “Mbɛiŋ tɔ̂kniki chu dzɔ jɔbi kɔm bəh dzɔɔŋ yi Bəfalasi bəh yi Bəsadusi.” ");
INSERT INTO cug_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Bwa bu bə mbaŋ yisi i dzakaki a bɔ bɔ kɔm gia yiwɔ, dzakayi a, “Wi dzakaki gia yi dzɔɔŋ yələ lə kɔm bukumbɛiŋ si ka dzə dəkə bəh blɛd.” ");
INSERT INTO cug_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisɔs kîə gia yə bɔ dzakaki kɔm yi ka dzaka a, “Ɔ ɔɔ bəni bə kimbum ki twɛsi bələ! Kɔm nə mbɛiŋ dzakaki a mbɛiŋ mbɛiŋ kɔm a mbɛiŋ kaŋaki kə blɛd a? ");
INSERT INTO cug_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mbɛiŋ kɛiŋki ki yɛiŋ kə gia a? Mbɛiŋ yiŋtiki kə chɔkɔ yi blɛd yite yə bəni bənchuku bəte ni dzi a? Biŋka biə mbɛiŋ ni juŋni a ni kɔ káh yimaiŋ a? ");
INSERT INTO cug_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mbɛiŋ chu yiŋtiki kə tə chɔkɔ yi blɛd nanitaŋ yə bəni bənchuku bənaa si dzi a? Mbɛiŋ si juŋni biŋka biə bi buku káh yimaiŋ a? ");
INSERT INTO cug_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","A fə nə mbɛiŋ si ka kiə dəkə a mih si dzakaki kə kɔm blɛd a? Mih chu dzakaki i mbɛiŋ a mbɛiŋ dzɔ̂ki jɔbi kɔm bə dzɔɔŋ yi Bəfalasi bəh yi Bəsadusi.” ");
INSERT INTO cug_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Si wi dzaka yakadəiŋ bɔ ka kiə a wi si dzakaki kə a bɔ dzɔ jɔbi kɔm dzɔɔŋ yə bə si fuŋni i blɛd wə, a wi si dzakaki kɔm nlani wi Bəfalasi bəh wi Bəsadusi. ");
INSERT INTO cug_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jɔbi wə Jisɔs nì tsə buku i kimbu ki tumi ki Kaysalia Filibi, ka dza bikə i bwa bu bə mbaŋ a, “Bəni dzakaki a mi wə yɛli wi kɔ Waiŋmi akɔ ndə a?” ");
INSERT INTO cug_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Bɔ chukuli i wi a, “Bəni bədɔkɔ dzakaki a wɔ kɔ Jɔn Njulibɔkɔ, bədɔkɔ a Ɛlaja, ayaka bədɔkɔ dzakaki a wɔ kɔ Jɛlimia yuwidɔkɔ a wɔ kɔ mi wi ntum wi Nyɔ widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wi bikə i bɔ a, “Mbɛiŋ dzakaki yimbɛiŋ a mih kɔ ndə a?” ");
INSERT INTO cug_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Samɔn Bita chukuli a, “Wɔ kɔ Kimbwili wə Nyɔ nì kaka, wə Waiŋ Nyɔ, Nyɔ wə wi kaŋaki nɔni.” ");
INSERT INTO cug_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisɔs chukuli i wi a, “Samɔn waiŋ Jɔna, ndzɔŋni bimbum kɔ i wɔ, kɔm gia yələ ka fuku dəkə mi wiwɔm i wɔ, a fuku Ba wuŋ wə wi kɔ bɛiŋ i wɔ. ");
INSERT INTO cug_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mih fukuki i wɔ a wɔ kɔ Bita, a num i biaŋa wələ wə mih bi maaki kijuŋni kəŋŋ ki bəni bə bumni yɛiŋ. Ayaka ŋga bi kpi bi ma gaka kijuŋni kiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mih ni nya lə biŋ'wɛli bi ŋkuŋ bi bɛiŋ i wɔ. Gia yə wɔ ni kaŋa i fa kuku, yaka kɔ bə kaŋa lɔ i bɛiŋ. Gia yə wɔ ni shwa i fa kuku, yaka kɔ bə shwa lɔ i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Si Jisɔs dzaka yakadəiŋ, ka lansi kiŋ i bwa bu bə mbaŋ a kiə bɔ ki mɔm kə i fuku yi i mi a ŋgaiŋ kɔ Kimbwili wə Nyɔ nì kaka. ");
INSERT INTO cug_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","I yisi i jɔbi wiwɔ wə, Jisɔs ka yisi i chusiki i bwa bu bə mbaŋ a ŋgaiŋ kaŋaki i tsə i Jɛlusalɛm. Ŋgaiŋ tsə yɛiŋ bəŋgəkə bəduli i kaŋ yi bəni bə̀ bɔ sakaki tumi bəh bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ. Bɔ ni wɔɔ lə ŋgaiŋ, i buku i kaŋ yitali wə ma ŋgaiŋ bi fiəni dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bita ka dzɔ wi, bɔ wi baka gwu. Wi ka yisi i yɔliki i wi, i gia yiwɔ wə, wi dzaka a, “Bah, Nyɔ bâŋ dzəh yiwɔ. Gia yələ bi mɔ̂m kə i nûm bəh wɔ.” ");
INSERT INTO cug_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jisɔs fiəni gwu dzaka i Bita a, “Fiəni mih chɛiŋ Satan! Wɔ yɛiŋki gia ka mi wiwɔm. Wɔ yɛiŋki kə si Nyɔ yɛiŋki.” ");
INSERT INTO cug_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Si Jisɔs dzaka yakadəiŋ, ka dzaka i bwa bu bə mbaŋ a, “Mi wə wi nəŋki i num mi wuŋ wi mbaŋ, wi kaŋaki i nə̂iŋ gwu yi, i gîŋ kintasi ki i bîəliki mih. ");
INSERT INTO cug_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mbɛiŋ kîəki a mi wə wi tɔkniki bəh nɔni ki a wi ma laksi wi bi laksi lə. Ayakalə, mi wə wi laksi nɔni ki kɔm bə mih bi kwatiki lə nɔni. ");
INSERT INTO cug_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Bə ka juŋni mbi wələ wichi, nya i mi, a wi dzi, wi num i laksi nɔni ki, ma mbee wiwɔ bi numki na nə? Ma a, akɔ na finə mi kɔ i təiŋ fwu wi yɛiŋ na? ");
INSERT INTO cug_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mbɛiŋ kîə a mi wə yɛli wi kɔ Waiŋmi bi dzəki bəh bəchinda bu i mbum bi Ba wi wə, wi ka bi gɔm mi wichi i nɔm wə wi fə. ");
INSERT INTO cug_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mih fukuki ŋkɔŋ i mbɛiŋ a, bəni bədɔkɔ kɔlə fa bɔ kɔbi i bi musi kpi maka bɔ yɛiŋ mi wə yɛli wi kɔ Waiŋmi si wi dzəki bəh ŋkuŋ bi.” ");
INSERT INTO cug_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Asi kaŋ nì tsə yisɔ, Jisɔs dzɔ Bita bəh Jɛm bəh Jɔn waiŋnih Jɛm bəh bɔ yaka i ŋkwuŋ wi dəəŋ widɔkɔ bɛiŋ, ka numki fɛiŋ a bɔ bɔ. ");
INSERT INTO cug_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bɔ dzaka a bɔ tsɛiŋ, yɛiŋ num kimbwɔsi ki kwuni i bɔ nshiŋ, shi bi baiŋ ŋwayi aka wɔŋ, bəmbuŋ bu fuku tə mwayi alə mwaŋmwaŋmwaŋ. ");
INSERT INTO cug_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Yi dzə num a Muses bəh Ɛlaja təkəli tumbuku i bɔ nshiŋ, ka dzakaki bɔ bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bita dza təkəli dzaka i Jisɔs a, “Bah, yi si ndzɔŋki lə a bukumbɛiŋ numki fa. Wɔ kabə kɔŋ ma mih ni maa bitaŋ bitali, kidɔkɔ numki ŋka, kidɔkɔ num ki Muses, kidɔkɔ num ki Ɛlaja.” ");
INSERT INTO cug_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Asi wi nì kɛiŋki wi dzaka, yi dzə num a bikwu bi fuku lə buuu nyə dzə baŋ bɔ, ja ka dzaka i bikwu biwɔ kintəəŋ a, “Wələ kɔ Waiŋ wuŋ wi shɔm. Mih kɔ bəh kinsaŋli nalə kɔm wi. Mbɛiŋ wɔ̂kɔki num i wi.” ");
INSERT INTO cug_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jɔbi wə bwa bu bə mbaŋ wɔkɔ ja yiwɔ ndzaŋ kwa bɔ, bɔ gbɔyi bəh bishi i kuku. ");
INSERT INTO cug_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ayakalə, Jisɔs tsə ka kɔm bɔ ka dzaka a, “Mbɛiŋ dzâyi bɛiŋ. Kiə mbɛiŋ ki lwâ kə.” ");
INSERT INTO cug_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jɔbi wə bɔ nì dzasi dzə́kəh yibɔ i bɛiŋ na chu yɛiŋ mi widɔkɔ fɛiŋ a kɔbi a Jisɔs shəŋ. ");
INSERT INTO cug_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Si bɔ nì nyə i ŋkwuŋ wiwɔ bɛiŋ ka shiki dzəki, Jisɔs kiŋ i bɔ a, “Kiə mbɛiŋ ki fûku kə gia yə dzə́kəh yimbɛiŋ si yɛiŋ i mi, maka mi wə yɛli wi kɔ Waiŋmi dza i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Bwa bu bə mbaŋ bikə i wi a, “Akɔ kɔm nə wə bəni bə̀ bɔ laniki bənchi dzakaki a Ɛlaja kaŋaki i bi yisi dzə i Kimbwili wə Nyɔ nì kaka a?” ");
INSERT INTO cug_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisɔs chukuli a, “Akɔ ŋkɔŋ, Ɛlaja kaŋaki i bi yisi dzə i kɛiŋsi gia yichi. ");
INSERT INTO cug_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ayakalə, mih fukuki i mbɛiŋ a Ɛlaja dzə lɔ, ayaka bə nəki kiə kə wi, bə fə bəh wi asi bə kɔŋki. Yi kɔ a liŋ asi mi wə yɛli wi kɔ Waiŋmi bi yɛiŋki ŋgəkə i bɔ kaŋ.” ");
INSERT INTO cug_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Si wi dzaka yakadəiŋ, bwa bu bə mbaŋ ka kiə a wi dzakaki kɔm Jɔn Njulibɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jɔbi wə Jisɔs bəh bwa bu bə mbaŋ shi dzə i di biə mbaŋ wi bəni nì kɔ. Mi widɔkɔ dza dzə tum binyu i Jisɔs nshiŋ, ka dzaka i wi a, ");
INSERT INTO cug_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Bah, kwâsi nshɛiŋ i waiŋ wuŋ wi nyukuni wələ. Wi gwɛiŋki bəh jwɛiŋ yi kiŋgbɔ, wi wɔkɔ ŋgəkə na bəh ŋga. Wi si fə wi dza gbɔ i fitɔŋ, jɔbi widɔkɔ wi dza gbɔ i mwi mə. ");
INSERT INTO cug_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mih si dzə bəh wi i bwa ba bə mbaŋ bɔ mɔmsi wɔkɔ mɔŋ i chuku wi.” ");
INSERT INTO cug_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisɔs dzaka a, “Ɔɔɔ! Ŋgɔkɔ wi kilɔlɔ wələ, wi ka jiə dəkə shɔm i Nyɔ. Mih bi numki bəh mbɛiŋ i tsə buku dəiŋ na? Mih ni kaŋa shɔm bəh mbɛiŋ i tsə buku dəiŋ na? Mbɛiŋ dzə̂ nyâ waiŋ wiwɔ i mih fa.” ");
INSERT INTO cug_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Bɔ dzə bəh wi, Jisɔs kaŋyi chinda wi ŋkpɛli wə wi nì kɔ i waiŋ wiwɔ mə wi buku, wi ka bɔnih akisəkə. ");
INSERT INTO cug_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Bwa bə Jisɔs bə mbaŋ dza tsə i wi i jum wə jum wə, bikə i wi a, “Akɔ kɔm nə wə buku si mɔmsi wɔkɔ mɔŋ i bwili chinda wi ŋkpɛli wiwɔ a?” ");
INSERT INTO cug_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Wi chukuli i bɔ a, “Akɔ kɔm kimbum kimbɛiŋ kɔ kinchiŋ. Mih fukuki ŋkɔŋ i mbɛiŋ a, asi kɔ a mbɛiŋ kaŋaki kimbum ki sɛiŋni aka mintam mi ntɔtɔ, ma mbɛiŋ kɔlə i dzaka i ŋkwuŋ wələ a wi muku fa wi tsə num fi, ma wi ni muku, gia yidɔkɔ ma ni numki yə yi kɔ i gaka mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ayakalə, ŋkaiŋni wi chinda wi ŋkpɛli wələ kɔkə i buku i mi wə a kɔbi a i ntsa wə bəh mbam wi dzaka. ” ");
INSERT INTO cug_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Si Jisɔs bəh bwa bu bə mbaŋ nì juŋni i Galili, wi dzaka i bɔ a, “Mi wə yɛli wi kɔ Waiŋmi bə kaŋaki i nya wi i kaŋ yi bəni wə, ");
INSERT INTO cug_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","bɔ ni wɔɔ wi, i kaŋ yitali wə, wi ni fiəni dza i kpi wə.” Si bɔ wɔkɔ yakadəiŋ, gwu bɔhyi bɔ nalə. ");
INSERT INTO cug_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisɔs bəh bwa bu bə mbaŋ nì tsə buku i Kafanaum, bəni bə̀ bɔ nì kwaki kiŋwakti ki juŋ yi fəni yi gia dzə yɛiŋ Bita ka bikə i wi a, “Mi wimbɛiŋ wi Lanini si lɔɔ alə kpɔ wi kiŋwakti i juŋ yi fəni yi gia wə a?” ");
INSERT INTO cug_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Wi bum a, “Aaŋ.” Jɔbi wə Bita nì kwɛ, Jisɔs yisi jiə gia yiwɔ i kuku, bikə i wi a, “Samɔn, wɔ yɛiŋki n'ya a nə? Bəŋkuŋ bə fa kuku si kwa biŋwakti bəh mintsuti num i bə ndə a? Bɔ si dzɔ num i bwa bəbɔ ma, i bəni bədzəni a?” ");
INSERT INTO cug_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bita chukuli a, “Bɔ si dzɔ num i bəni bədzəni.” Jisɔs dzaka i wi a, “Yaka kɔ a bwa bəbɔ kaŋaki kə i lɔɔki. ");
INSERT INTO cug_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ayakalə, i fə a buku wɔ ma nəŋni shɔ́m yi bəni bələ, tsə̂ lɔ̂ɔ ŋgɔlɔ i kinchwɔ kimbum wə, bwɔkɔ yə wɔ yisi kwa, yâsi dzaka kiwɔ wɔ ni yɛiŋ dzəkəh wi kpɔ yɛiŋ wɔ dzɔ̂ wi ma wɔ tsə̂ nyâ i bɔ i lɔɔ kiŋwakti ki buku wɔ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","A jɔbi wiwɔ wə, bwa bə Jisɔs bə mbaŋ dzə bikə i wi a, “Mi wə wi kɔ mi wimbum tsə bəni bəchi i ŋkuŋ bi bɛiŋ wə akɔ winaiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisɔs ka bɔɔŋ waiŋ wi nchiŋ tɔm i bɔ kintəəŋ, ");
INSERT INTO cug_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ka dzaka a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ ka baaŋ i kwuni i numki ka bwa bənchiŋ bənchiŋ, yaka kɔ a mbɛiŋ bi lansi liə kə i ŋkuŋ bi bɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Na ndə wə wi shishi gwu yi i kuku i numki ka waiŋ winchiŋ wələ, wəmaka mi kɔ mi wimbum i kintəəŋ ki ŋkuŋ bi bɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mi ka dzɔ waiŋ winchiŋ ka wələ i yɛli wuŋ wə, wi dzɔ num mih.” ");
INSERT INTO cug_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yi kɔ a, “Na ndə wə wi fə a waiŋ wimu i mbaŋ wi bwa bəŋ bələ kintəəŋ bɔ jiə shɔm yibɔ i mih fə chu, ma yi ndzɔŋki a bə shu shəŋsi nəkə wimbum i məkə ki wəmaka mi wə, bə chini shi wi i kinchwɔ kimbum wə. ");
INSERT INTO cug_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ŋgəkə wimbum kɔ i bəni bə mbi wələ wə. Kɔm gia yə yi taaŋki bəni bɔ fə chu bi lansi baaŋ kə i dzə, ayakalə, ŋgəkə wimbum i mi wə wi bi dzəki bəh gia yiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Yi kabə num a tsɛiŋ ya nabə gbu wa kabə fəki a wɔ fə chu, wɔ tə̂iŋ tsɛiŋ yiwɔ nabə gbu wiwɔ wɔ lɔ̂tɔkɔ. Yi ndzɔŋki a wɔ liə i nɔni kə ki bi tsə kaa kə bəh kinchumni ki tsɛiŋ nabə kinchumni ki gbu, tsə a wɔ kaŋaki tsɛ́iŋ yichi nabə gvu yichi yi num i dzɔ lɔɔ wɔ i gbuku wə wi bi tsə nyumi kə. ");
INSERT INTO cug_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yi kabə num a dzəkəh wa kabə fəki a wɔ fə chu, wɔ kâmbwili lɔ̂tɔkɔ. Yi ndzɔŋki a wɔ bi liə i nɔni kə ki bi tsə kaa kə bəh dzəkəh wimu, tsə a wɔ kaŋaki dzə́kəh yichi, yi num i bi lɔɔ wɔ i gbuku wimbum mə.” ");
INSERT INTO cug_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Mbɛiŋ tɔ̂kniki, kiə mbɛiŋ ki tsisiki waiŋ widɔkɔ i bwa bənchiŋ bələ wə. Mih fukuki i mbɛiŋ a, i bɛiŋ bəchinda bə Nyɔ bə̀ bɔ tɔkniki bəh bɔ, bɔ shi kɔ jɔbi wichi i Ba wuŋ nshiŋ wə wi kɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","A mi wə yɛli wi kɔ Waiŋmi nì dzə i bwili bəni bə̀ bɔ kɔ bɔ laka lɔ. ");
INSERT INTO cug_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mbɛiŋ kwakaki a nə? A mi kabə kaŋa shwáŋ gbi, yimu laka yɛiŋ kintəəŋ, wi ma ni yisi bee yə mbaŋ bwukə ntsɔ bwukə i ŋkwuŋ wə, i tsə yisi nəŋ shwaŋ yimu yə yi si laka a? ");
INSERT INTO cug_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mih fukuki ŋkɔŋ i mbɛiŋ a, wi ka ni nəŋ yɛiŋ yi, ma wi ni laŋki kɔm shwaŋ yiwɔ yimu, tsə yə mbaŋ bwukə ntsɔ bwukə yi si ka laka dəkə. ");
INSERT INTO cug_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yi kɔ a liŋ tə si Ba wimbɛiŋ wə wi kɔ i bɛiŋ kɔŋki kə a mi wimu i mbaŋ wi bwa bə nchiŋ bələ laka. ");
INSERT INTO cug_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Waiŋnah ka fə gia yichu i wɔ, tsə̂ yɛ̂iŋ wi wɔ fûku ŋgəkə wiwɔ i wi a mbɛiŋ wi bəfa. Wi ka wɔkɔ gia yə wɔ dzaka, yi numki a wɔ fiəni kwati lɔ waiŋnah. ");
INSERT INTO cug_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","A kabə num a wi kɔŋki kə i wɔkɔli gia yə wɔ dzakaki, wɔ dzɔ̂ mi wimu yuwidɔkɔ bəfa mbɛiŋ bɔ fiəni tsə i wi, ka ndzaka wiwɔ wichi ni kwati bəni bəfa yuwidɔkɔ bətali bə̀ bɔ beeŋki nsaka wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wi ka tsə nəiŋ i wɔkɔli gia yə bə dzakaki, wɔ dzɔ̂ tsə̂ bəh wi i kijuŋni ki bəni bə bumni wə. Wi ka nəiŋ i wɔkɔli na i kijuŋni ki bəni bə bumni wə, wɔ dzɔ̂ wi ka mi wə wi kiəki kə Nyɔ yudɔkɔ na ka mi wə wi kwaki kiŋwakti. ");
INSERT INTO cug_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mih fukuki ŋkɔŋ i mbɛiŋ a Gia yə mbɛiŋ ni kaŋa i fa kuku, yaka kɔ bə kaŋa lɔ i bɛiŋ. Gia yə mbɛiŋ ni shwa i fa kuku, yaka kɔ bə shwa lɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mih chu fukuki ŋkɔŋ i mbɛiŋ a, bəni bəfa i mbɛiŋ kintəəŋ ka bum i gia wə fa kuku, nywa i ntsa wə, Ba wuŋ wə wi kɔ i bɛiŋ ni fə gia yiwɔ i bɔ. ");
INSERT INTO cug_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mbɛiŋ kiəki a di biə bəni bəfa yudɔkɔ bətali ka juŋni i yɛli wuŋ wə, yaka mih kɔlə i bɔ kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Bita ka kɔmsi i Jisɔs wə bikə i wi a, “Bah, akɔ kiŋkani kimaiŋ waiŋnih wuŋ kɔ i fə chu i mih a mih dâlinyaki wi a? Yi kɔlə i tsə buku na kiŋkani nanitaŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisɔs chukuli i wi a, “Mih kɔkə i dzaka i wɔ a, akɔ a kiŋkani nanitaŋ shəŋ. Akɔ numki mbaŋnanitaŋ kiŋkani nanitaŋ. ");
INSERT INTO cug_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Akɔ fiɛŋ fiə bə kɔ i fəkəli ŋkuŋ bi bɛiŋ bəh ŋkuŋ widɔkɔ wə wi nì nəŋki i sisi gia yi kpɔ bəh bəni bu bə nɔm kɔm kpɔ wə wi nì kɔ i bɔ kaŋ. ");
INSERT INTO cug_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Asi wi nì yisi i tsɛiŋki, bə dzə bəh mi widɔkɔ wi kaŋa fwa yi biba bi kpɔ bənchuku jwɔfi. ");
INSERT INTO cug_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Asi wi nì kɔkə i gɔm, ŋkuŋ wiwɔ ka dzaka a, bə dzɔ̂ wi bəh kpə wi bəh bwa bu i tâsi bəh biɛiŋ bi bichi bə tâŋni, bə dzə̂ bəh kpɔ wiwɔ i gɔ̂m fwa yi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Si ŋkuŋ dzaka yakadəiŋ, mi wiwɔ gbɔ i wi nshiŋ kwuŋ kaŋ i wi ka dzaka a, ‘Bah, kaŋa shɔm bəh mih, mih ni gɔm lə biɛiŋ bichi.’ ");
INSERT INTO cug_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nshɛiŋ fə a tikwili wiwɔ bee wi ka dali fwa yiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ayakalə, si mi wələ mwi nì buku ka tsəki, baŋsi bəh mi wə bəh bɔ nɔmki i ŋkuŋ, mi wiwɔ kaŋa wi bəh fwa kiba ki kpɔ kimu. Wi ka kaŋa wi i kindɔŋ wə dzaka i wi a, ‘Gɔm fwa ya.’ ");
INSERT INTO cug_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mi wi nɔm wiwɔ ka gbɔ tə i wi nshiŋ, ka tsaki wi dzaka a, ‘Kaŋa shɔm bəh mih, mih ni gɔm lə wɔ.’ ");
INSERT INTO cug_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ayaka wi nəiŋma, dzɔ wi tsə fah i juŋ yi nsəŋ mə a wi numki fɛiŋ i tsə buku i jɔbi wə wi bi gɔmki fwa yiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bəni bədɔkɔ bə̀ bəh bɔ nì nɔmki ka yɛiŋ gia yə yi num, yi nya bɔ bəh ŋgəkə nalə. Bɔ ka tsə fuku gia yichi yə yi si num i ŋkuŋ. ");
INSERT INTO cug_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ŋkuŋ bɔɔŋ wi wi dzə, wi dzaka i wi a, ‘Wɔ kɔ mi wi nɔm wichu. Mih si dalinya fwa ya yichi kɔm wɔ si kwuŋ kaŋ i mih. ");
INSERT INTO cug_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Wɔ si kɔkə i bɔŋ kwasi tə nshɛiŋ i mi wə mbɛiŋ bɔ nɔmki asi mih si kwasi tə i wɔ a?’ ");
INSERT INTO cug_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ŋkuŋ bɔksi shɔm, ka nya wi a bə tsə̂ fâh i juŋ yi nsəŋ mə bə chə̂bsiki wi, i tsə̂ bûku jɔbi wə wi bi gɔmki fwa yi yichi. ");
INSERT INTO cug_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ayakadəiŋ, yi kɔ a liŋ asi Ba wuŋ wə wi kɔ i bɛiŋ bi fə tə bəh mi wimu wimu i mbɛiŋ kintəəŋ, jɔbi wə mi ka dalinya gia yichu yə waiŋnih wi fə i wi bəh shɔm yi yichi.” ");
INSERT INTO cug_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jɔbi wə Jisɔs nì kaasi ndzaka wələ, wi nyə i kimbu ki tumi ki Galili wə, ka tsə i ki Judea wə, i kiwuŋ ki Bɔkɔ yi Jɔdan wə. ");
INSERT INTO cug_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Si wi tsə, mbaŋ wi bəni wimbum kwu i wi chɛiŋ, wi chuku bɔ bəchi bə̀ bɔ nì gwɛiŋki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Bəfalasi dza dzə i wi i mɔmsi wi, ka bikə i wi a, “Nchi bumki lə a mi kɔlə i kɔŋŋ kpə wi na i yi naiŋ gia wə a?” ");
INSERT INTO cug_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisɔs chukuli i bɔ a, “Mbɛiŋ ka num fa dəkə gia yə bə nyaka a, ‘I kin'yisi wə mi wə wi nì maa bəni nì maa bɔ num minyuku bəh miŋkpaŋa’ a? ");
INSERT INTO cug_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wi nì maa yaka ka dzaka a, ‘Akɔ kɔm yələ minyuku kaŋaki i bee ba wi bəh nih wi i chiŋni bəh kpə wi, ma bɔ bəfa bi fiəni num i mi wimu.’ ");
INSERT INTO cug_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ayakadəiŋ, bɔ chu mɔŋ bəni bəfa, bɔ kɔ i mi wimu. Yaka yi kɔ a, fiɛŋ fiə Nyɔ kɔ wi chiŋni lɔ, kiə mi ki mɔ̂m kə i gâli.” ");
INSERT INTO cug_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Bəni bəwɔ ka bikə i Jisɔs a, “Akɔ kɔm nə wə Muses nì dzaka a mi kɔlə i nyâka kiŋwakti i nyâ i kpə wi ki chusi a ŋgaiŋ bee wi, ka wi bee wi a?” ");
INSERT INTO cug_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisɔs chukuli a, “A nì kɔ kɔm kifwu kimbɛiŋ kiləkəli ki nì fə ka Muses bee a mi kɔlə i kɔŋŋ kpə wi. Ayakalə, a kɔkə dəkə yakadəiŋ si yi nì kɔ i kin'yisi wə. ");
INSERT INTO cug_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mih fukuki i mbɛiŋ a, mi wə wi bee kpə wi ka dzɔ widɔkɔ, a kɔbi a miŋkpaŋa wiwɔ tɔkɔliki lə i biŋ, ma yi numki a wi fə chu i nɔ bəh miŋkpaŋa widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Bwa bə Jisɔs bə mbaŋ wɔkɔ yi yakadəiŋ ka dzaka i wi a, “A kabə num si gia yiwɔ kɔ yaka kɔm minyuku bəh miŋkpaŋa, yi ndzɔŋki a mi baaŋ mfih yaka maka wi liə i ndzɔ miŋkpaŋa wə.” ");
INSERT INTO cug_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jisɔs dzaka i bɔ a, “A kɔkə dəkə mi wichi wə wi kɔ i bum gia yələ. Akɔ a bum a bəni bə̀ Nyɔ kɔ wi fə a bɔ bum. ");
INSERT INTO cug_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mbɛiŋ kîəki a bəni bədɔkɔ kɔlə, gwu yibɔ dza kə, num ayaka si bə nì bwɔ bɔ. Ayaka bədɔkɔ kɔ yaka num a fə bəni bəh kaŋ a bɔ numki yakadəiŋ. Bədɔkɔ num fibɔ yaka num a fə bɔ gwu yibɔ a bɔ numki yakadəiŋ kɔm ŋkuŋ bi bɛiŋ. Mi wə wi kɔ i bum yələ wi bûm.” ");
INSERT INTO cug_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Bəni dza ka dzəki bəh bwa bəbɔ i Jisɔs a wi jîəki kaŋ i bɔ fuŋ, bəh i tsâ i bɔ wə, ayaka bwa bu bə mbaŋ yisi i yɔliki i bəni bəwɔ. ");
INSERT INTO cug_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisɔs dzaka mfih a, “Mbɛiŋ bêe ma bwa bənchiŋ dzə̂ki i mih wə. Kiə mbɛiŋ ki chî kə bɔ, kɔm ŋkuŋ bi bɛiŋ kɔ num i bəni ka bələ.” ");
INSERT INTO cug_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Si wi dzaka yakadəiŋ, ka jiə kaŋ yi i bɔ wə ka dza nyə. ");
INSERT INTO cug_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yi num a, mi widɔkɔ nì dza dzə i Jisɔs, ka bikə i wi a, “Mi wi Lanini, gia yindzɔŋni yə mih kaŋaki i fə ka mih kaŋa nɔni kə ki bi tsə kaa kə kɔ na nə a?” ");
INSERT INTO cug_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisɔs ka bikə i wi a, “Wɔ bikəki num i mih gia yə yi ndzɔŋki kɔm nə? Mi wi ndzɔŋni kɔ shəŋ a wimu. Wɔ kabə nəŋ i liə i nɔni kə ki bi tsə kaa kə, wɔ ka jîəki bənchi bə Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Mi wiwɔ bikə i Jisɔs a, “Bənchi bə Nyɔ kɔ bənaiŋ a?” Jisɔs ka chukuli a, “Kiə wɔ ki wɔ̂ɔ kə mi, kiə wɔ ki nɔ̂ kə bəh kpə mi, kiə wɔ ki chwɔ̂ kə, kiə wɔ ki bêeŋ kə nsaka wi ntəkə, ");
INSERT INTO cug_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wɔ kɔ̂ksiki ba wa bəh nih wa, bəh a, wɔ kɔ̂ŋki mi wə wi kɔ kɔmsi i wɔ kpəŋ asi wɔ kɔŋki gwu ya.” ");
INSERT INTO cug_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sumi yiwɔ ka dzaka i wi a, “Bənchi bələ bəchi kɔ num mih ni jiəki lə. A chu baaŋ finə a?” ");
INSERT INTO cug_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisɔs chukuli i wi a, “Wɔ kabə nəŋki i num mi wə wi ndzɔŋki wi bwili fwu, wɔ tâŋni biɛiŋ biə wɔ kaŋaki, wɔ gâa kpɔ wiwɔ i bə kifuu, wɔ bi ka kwati kiba num i bɛiŋ. Wɔ ka fə yakadəiŋ wɔ dzə̂ ka bîəliki mih.” ");
INSERT INTO cug_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Sumi yiwɔ wɔkɔ yakadəiŋ, ka dza ka tsəki num a nshɛiŋ nshɛiŋ, kɔm wi nì kaŋaki lə mbum nalə. ");
INSERT INTO cug_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisɔs ka dzaka i bwa bu bə mbaŋ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a yi bi ləkə lə i mi wimbum i liə i ŋkuŋ bi bɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mih chu fukuki i mbɛiŋ a, yi bɔniki alə i kikum i liə i dzəŋə yi nsala wə tsə si mi wimbum kɔ i liə i ŋkuŋ bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Bwa bə Jisɔs bə mbaŋ wɔkɔ yi yakadəiŋ, ndzaka wiwɔ fumsi bɔ nalə. Bɔ bikə i wi a, “Yi kabə num yakadəiŋ, ma ndə bi lansi bɔiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisɔs tsɛiŋ bɔ lə, ka dzaka i bɔ a, “I mi wiwɔm, yələ ləkəki alə. Ayakalə, i Nyɔ gia yidɔkɔ kɔkə yə yi ləkəki i wi.” ");
INSERT INTO cug_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Bita dzaka i wi a, “Tsɛiŋ, buku bee biɛiŋ bichi ka biəliki wɔ. Buku bi kwatiki nə?” ");
INSERT INTO cug_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisɔs dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a jɔbi wə mi wə yɛli wi kɔ Waiŋmi bi numki i kiŋgbɔkɔ kimbum wə i tumi kimfiaŋ wə, mbɛiŋ bələ mbɛiŋ si biəli mih, bi num lə tə i biŋgbɔkɔ wə jwɔfi ntsɔ bəfa i sakaki chwɔŋbijuŋ bi Islae biə jwɔfi ntsɔ bəfa . ");
INSERT INTO cug_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mi wichi wə wi bee juŋ yi, nabə bwa bə nih wi, nabə jɛ́mi yi, nabə ba wi, bəh nih wi, nabə bwa bu, nabə kikhə ki, a wi bee kɔm mih, bi kwati lə bəni bəh biɛiŋ kiŋkani gbi tsə si wi nì kaŋaki. Wi bi kwati tə nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ayakalə, bəni bəduli bə̀ bɔ kɔ i ninshiŋ i liə bi numki num i jum wə, bəduli bə̀ bɔ kɔ i jum wə i liə bi numki num i ninshiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisɔs chu dzaka a, “Ŋkuŋ bi bɛiŋ kɔ aka tikwili widɔkɔ wi nì buku dza kinchɔŋɔchɔŋɔ tsə i dzɔ bəni bə nɔm i jiə i wi khə. ");
INSERT INTO cug_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Si wi nì tsə yɛiŋ bɔ, ayaka bəh bɔ ka kɛiŋsi a wi ni gɔm bɔ nchuku nchuku i chɔkɔ wə. Wi ka faaŋ bɔ, bɔ tsə ka nɔmki i wi khə. ");
INSERT INTO cug_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ayaka jɔbi dzə num ka mbiəŋə bwukə, wi buku tsə yɛiŋ bəni bədɔkɔ bɔ numyi i bɛiŋ i shibɛiŋ a kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wi dzaka i bɔ a, ‘Mbɛiŋ tsə̂ tə mbɛiŋ nɔ̂mki i mih khə, mih ni gɔm mbɛiŋ bəh fiɛŋ fiə fi kpɛiŋniki.’ Ayakadəiŋ, bɔ ka tsə. ");
INSERT INTO cug_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wi chu buku tsə ka nshichuŋ, ka chu buku ka mbiəŋə mitali dzɔ a bəni bə nɔm. ");
INSERT INTO cug_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ayaka a num ka mbiəŋə mite wə i fijɔbi, wi chu buku tsə yɛiŋ bəni bədɔkɔ bɔ numyi. Wi bikə i bɔ a, ‘Akɔ kɔm nə mbɛiŋ numyi fa bɛiŋ chɔkɔ bichili a kilɔlɔ lə a?’ ");
INSERT INTO cug_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Bɔ chukuli a, ‘Akɔ kɔm mi ka dzɔ dəkə buku i nɔm wə.’ Wi ka dzaka i bɔ a, ‘Mbɛiŋ bɔŋ tsə̂ nɔ̂mki la i mih khə.’ ");
INSERT INTO cug_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","A dzə num i fijɔbi, tii khə wiwɔ ka dzə dzaka i fwu wi bəni bu bə nɔm a, wi bɔ̂ɔŋ bəni bə nɔm wi gɔ̂m bɔ, wi yîsi bəh bəni bə̀ bɔ si dzə i jum wə, i tsə̂ kâasi bəh bə̀ bɔ si dzə i ninshiŋ. ");
INSERT INTO cug_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Wi ka yisi i gɔmki. Bəni bə̀ bə nì dzɔ i nɔm wə i mbiəŋə mite wə wi gɔm bɔ nchuku nchuku. ");
INSERT INTO cug_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ayaka bəni bə̀ bə nì yisi dzɔ i nɔm wə nì dzə ka kwakaki a bə ni gɔm lə bɔ tsə bədɔkɔ bə̀. Ayakalə, bə gɔm bɔ tə a nchuku nchuku. ");
INSERT INTO cug_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bɔ dzɔ ŋgɔm wibɔ yisi i shwiŋyiki tikwili wiwɔ, ");
INSERT INTO cug_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","dzaka a, ‘Bəni bələ wɔ si dzɔ i jum wə bɔ nɔm shəŋ a mbiəŋə wimu wə, wɔ gɔm buku bɔ a liŋ, num buku si shi fa, ka muki nɔm i chɔkɔ bichili wə wɔŋ twɛiŋ buku.’ ");
INSERT INTO cug_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tii khə wiwɔ chukuli i widɔkɔ i bɔ kintəəŋ a, ‘Nsɛiŋ wuŋ, mih ka fə dəkə gia yichu yidɔkɔ i wɔ. Buku wɔ si ka kɛiŋsi a wɔ ni fə nɔm wələ i nchuku wimu a? ");
INSERT INTO cug_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Dzɔ̂ ŋgɔm wa, wɔ nyə̂. A kɔŋ mih i gɔm bəni bələ bɔ dzə i jum wə a liŋ asi mih gɔm mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Mih kaŋaki kə ŋga i fə gia yə mih kɔŋki bəh fiɛŋ fiə akɔ mfiŋ a? Ma kindɔŋ finiki wɔ kɔm mih baŋyiki kə kaŋ i bəni a?’” ");
INSERT INTO cug_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Si Jisɔs dzaka yakadəiŋ, ka gɔksi a, “Akɔ asi bəni bə̀ bɔ kɔ i jum wə i liə bi numki bə ninshiŋ, bə ninshiŋ num bə jum wə.” ");
INSERT INTO cug_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Asi Jisɔs nì yakaki tsəki i Jɛlusalɛm, bəh bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa num i dzəh, wi baka gwu bəh bɔ, ka dzaka i bɔ a, ");
INSERT INTO cug_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mbɛiŋ wɔkɔli, bukumbɛiŋ yakaki tsəki i Jɛlusalɛm, bə num i tsə nya mi wə yɛli wi kɔ Waiŋmi i kaŋ yi bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ, ka bɔ saka wi, bɔ təiŋ nsaka a bə wɔ̂ɔ wi, ");
INSERT INTO cug_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","bə ni nya wi i kaŋ yi bəni bə̀ bɔ kɔkə Bəju, bə suŋu wi, bə twɛiŋ wi bəh ŋgaŋa, ka bə baŋŋ wi i kintasi wə, a ni num i kaŋ yitali wə Nyɔ fiəni dzasi wi i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ayaka nih bwa bə Sɛbide dza dzə yɛiŋ Jisɔs bəh bwa bu, tum binyu i wi nshiŋ i nywa fiɛŋ fidɔkɔ i wi. ");
INSERT INTO cug_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisɔs bikə i wi a, “Wɔ nəŋki nə?” Wi chukuli i wi a, “Kâka a, a bi numki i jɔbi wə wɔ bi sakaki ŋkuŋ bia, ma bwa bəŋ bələ bəfa bi nûm kɔmsi i wɔ kpəŋ, widɔkɔ i tsɛiŋ ya yiləkəli wə, widɔkɔ i yi kimiəkə wə.” ");
INSERT INTO cug_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisɔs chukuli i bwa bəwɔ a, “Mbɛiŋ kiəki kə gia yə mbɛiŋ bikəki. Mbɛiŋ kɔlə i bi mu bwam wi ŋgəkə wə mih bi mu a?” Bɔ chukuli a, “Buku kɔlə i bi mu.” ");
INSERT INTO cug_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wi dzaka i bɔ a, “Ŋkɔŋ mbɛiŋ bi mu lə bwam wuŋ. Ayakalə, i shinum i tsɛiŋ yiŋ yiləkəli nabə i yi kimiəkə wə a kɔkə mih i nya i mbɛiŋ. Di biələ kɔ num i bəni bə̀ Ba wuŋ kɔ num wi kɛiŋsi jiə lɔ i bɔ.” ");
INSERT INTO cug_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jɔbi wə kiŋka ki bwa bə mbaŋ bə Jisɔs bə̀ jwɔfi nì wɔkɔ kɔm gia yiwɔ, shɔ́m bɔkɔ bɔ kɔm bwa bəfa bəwɔ. ");
INSERT INTO cug_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ayakalə, Jisɔs bɔɔŋ bɔ bəchi, ka dzaka i bɔ a, “Ntə mbɛiŋ kiəki lə a bəni bə sakani bə̀ bɔ kɔkə Bəju si yaka num i bəni bəbɔ bɛiŋ, bəni bəbɔ bəmbum chusi ŋga bibɔ num i bɔ bɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yəmaka kaŋaki kə i numki yakadəiŋ i mbɛiŋ kintəəŋ. Mi wə wi nəŋki i num mi wimbum i mbɛiŋ kintəəŋ wi kaŋaki i num wə wi nɔmki num nɔmni i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Mi wə wi nəŋki i num mi wi ninshiŋ i mbɛiŋ kintəəŋ, wi kaŋaki i numki mfa i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yi kɔ a liŋ asi mi wə yɛli wi kɔ Waiŋmi nì ka dzə dəkə a bə nɔ̂mki i wi. Wi nì dzə i nɔmki i bəni, i nya nɔni ki ka n'yɛlih i yɛlih bəni bəduli i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisɔs bəh bwa bu bə mbaŋ ni bukuki i Jɛliku, mbaŋ wi bəni ka kwu i wi chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Yi num a, bimfəkə bidɔkɔ bifa a num bənyuku, bə̀ bɔ nì shiki numki a dzəh kpəŋ, jɔbi wə bɔ nì wɔkɔ a Jisɔs si tsə wə, bɔ ka wamyiki dzakayi a, “Bah, Waiŋ Ŋkuŋ Dɛbit, kwâsi nshɛiŋ i buku wə.” ");
INSERT INTO cug_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mbaŋ wi bəni ka kaŋyi bɔ, dzaka a bɔ bâŋ. Ayakalə, bɔ chu wam tsə a ninshiŋ, “Bah, Waiŋ Ŋkuŋ Dɛbit kwâsi nshɛiŋ i buku wə.” ");
INSERT INTO cug_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisɔs ka num, bɔɔŋ bɔ, bɔ dzə, wi bikə a, “Mbɛiŋ nəŋki a mih fə nə i mbɛiŋ?” ");
INSERT INTO cug_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Bɔ chukuli a, “Bah, fə̂ ma dzə́kəh yibuku wɛli.” ");
INSERT INTO cug_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ayaka nshɛiŋ kwa Jisɔs, wi kɔm dzə́kəh yibɔ. Akisəkə bɔ ka yɛiŋki di, nyə ka biəliki Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisɔs bəh bwa bu bə mbaŋ nì kɔmsiki tsəki i Jɛlusalɛm, bɔ tsə buku i kwili wi Bɛtfajə wə i Ŋkwuŋ wi Kɛiŋ yi Ɔlif wə, wi ka faaŋ bwa bu bə mbaŋ bədɔkɔ bəfa, ");
INSERT INTO cug_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","dzaka i bɔ a, “Mbɛiŋ tsə̂ i kwili wi ninshiŋ wəyaka wə. Jɔbi wə mbɛiŋ tsə, mbɛiŋ ni yɛiŋ nih njakas num bə shu bəh waiŋ wi, num wi num kɔmsi i yi kpɛiŋ, ma mbɛiŋ shwâli dzə̂ bəh yi i mih. ");
INSERT INTO cug_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi widɔkɔ ka bikə a mbɛiŋ shwaki yi kɔm nə, mbɛiŋ chukuli a Bah kaŋaki lə nɔm bəh yi, wi ni bee yi akisəkə mbɛiŋ dzɔ dzə bəh yi.” ");
INSERT INTO cug_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gia yələ nì num i fə a yi dzə̂ kpɛ̂iŋ asi mi wi ntum wi Nyɔ widɔkɔ nì fukuki, dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mi dzâka i kwili wi Sayɔŋ a, ‘Mbɛiŋ tsɛiŋ, Ŋkuŋ wimbɛiŋ si wi dzəki i mbɛiŋ. Wi kɔ wi shishi gwu yi i kuku, yaka i njakas wə, a num waiŋ njakas, yi kɛiŋ yinchiŋ.’” ");
INSERT INTO cug_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Bwa bə Jisɔs bə mbaŋ ka tsə fə asi wi si dzaka. ");
INSERT INTO cug_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bɔ dzɔ dzə bəh njakas wiwɔ tasi bəh waiŋ, jiə bəmbuŋ bəbɔ i yi bɛiŋ, Jisɔs yaka num i yidɔkɔ bɛiŋ ka tsəki. ");
INSERT INTO cug_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mbaŋ wi bəni bəduli ka tɔkɔki tsəki bəmbuŋ bəbɔ i dzəh, bədɔkɔ fakayi cha yi kɛiŋ tɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mbaŋ wə wi nì tsəki i Jisɔs nshiŋ bəh bə̀ bɔ nì biəliki wi i jum wə wili a, “Lilili, kiŋkɔksi kɔ i waiŋ Ŋkuŋ Dɛbit wə ɔɔɔ! Ma kimbɔiŋsi ki Nyɔ dzə i mi wə wi dzəki i yɛli wi Bah wə ɔɔɔ! Lilili, kiŋkɔksi kɔ i Nyɔ wi bɛiŋ wə ɔɔɔ!” ");
INSERT INTO cug_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisɔs tsə buku i Jɛlusalɛm, kwili wiwɔ wichi nəŋni. Ayaka bəni ka kaiŋyiki, bikəyi a, “Wələ kɔ ndə a?” ");
INSERT INTO cug_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mbaŋ wə chukuli a, “Akɔ mi wi ntum wi Nyɔ wə Jisɔs wə wi nyə i kwili wi Nasali wə i Galili.” ");
INSERT INTO cug_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisɔs nì tsə liə i tɔkɔ wi juŋ yi fəni yi gia yi Nyɔ mə, kɔŋŋ bəni bəchi bə̀ bɔ nì taŋniki bəh bə̀ bɔ nì taŋki biɛiŋ, beeŋsi bibaŋ biə bəni nì kwuniki kpɔ yɛiŋ, bəh biŋgbɔkɔ bi bəni bə̀ bɔ nì taŋniki bibumi. ");
INSERT INTO cug_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wi nì kɔŋŋki yaka dzaka i bɔ a, “Yi kɔ bə nyaka i kiŋwakti wə, a Nyɔ dzakaki a, ‘Bə bi bɔɔŋki juŋ yiŋ a juŋ yi tsani.’ Mbɛiŋ ka fiəni yi a yi chu taa wi bəji.” ");
INSERT INTO cug_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisɔs num i juŋ yi fəni yi gia mə, bimfəkə bəh bəŋgbɔ nyani ni dzəki i wi, wi chuku bɔ. ");
INSERT INTO cug_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ayakalə, bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ ka yɛiŋ gia yi kaŋyini yə wi nì fəki, bəh si bwa bənchiŋ bənchiŋ wiliki i juŋ yi fəni yi gia mə, dzakayi a, “Lilili, kiŋkɔksi kɔ i waiŋ Ŋkuŋ Dɛbit wə ɔɔɔ,” bɔ ka bɔksi lɔ tɔɔ. ");
INSERT INTO cug_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bɔ ka bikə i Jisɔs a, “Wɔ wɔkɔki alə gia yə bwa bələ dzakaki a?” Wi chukuli i bɔ a, “Aaŋ, mih wɔkɔki lə. Yi kɔ a mbɛiŋ ka num fa dəkə gia yə bə nì nyaka a, ‘Nyɔ kɔ wi fə kiŋkɔksi kindzɔŋni kə ki kɔ ki tsə bwili fwu a ki bukuki i dzaka ki bwa bənchiŋ bənchiŋ wə, bəh i dzaka ki bwa bə̀ bɔ kɛiŋki bɔ mah mbɛiŋŋ a?’” ");
INSERT INTO cug_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisɔs ka dza nyə bee bɔ fɛiŋ ka buku nyə i kwili wiwɔ kintəəŋ, ka tsə i di bi Bɛtani wə, nɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A dzə num kinchwɔŋɔnchwɔŋɔ, asi Jisɔs nì fiəniki tsəki i kwili wi Jɛlusalɛm wə, dzɔŋ wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wi yɛiŋ kpɛiŋ widɔkɔ wi num kɔmsi i dzəh, num bə si dzi lə mintam miwɔ, wi ka tsə fɛiŋ, nəki yɛiŋ kə fiɛŋ fidɔkɔ i yɛiŋ bɛiŋ, wi yɛiŋ a num a bidzɛni i yɛiŋ wə shəŋ. Ayaka wi ka liŋŋ kpɛiŋ wiwɔ dzaka a, “Kiə mintam bi ma chu lansi wûm i wɔ wə!” Akisəkə, kpɛiŋ wiwɔ ka kpiyi. ");
INSERT INTO cug_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jɔbi wə bwa bə mbaŋ bə Jisɔs yɛiŋ yakadəiŋ, dzaka wɔm bɔ. Ayaka bɔ ka dzakayi a, “Kpɛiŋ wiwɔ nyani dəiŋ ka wi kpiyi lɔ akisəkə lə a?” ");
INSERT INTO cug_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisɔs chukuli i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ ka jiə shɔm i Nyɔ wə, mbɛiŋ məŋni kə, mbɛiŋ ma ni fə shəŋ a gia yə mih fə i kpɛiŋ wələ. Ayaka mbɛiŋ ka kɔŋ i dzaka i ŋkwuŋ wələ a, ‘Mûku gwu ya fa ma wɔ tsə̂ gbɔ̂ i kinchwɔ kimbum wə,’ ma yi ni num ayaka. ");
INSERT INTO cug_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ayaka kɔŋ a numki na finaiŋ fiɛŋ fiə mbɛiŋ nywaki i ntsa wə, ma mbɛiŋ ni kwati i jɔbi wə mbɛiŋ jiə shɔm i Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisɔs chu fiəni tsə liə i juŋ yi fəni yi gia wə, bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi ki Bəju dzə yɛiŋ si wi laniki bəni, ka bikə i wi a, “Wɔ dzɔ faiŋ ŋga na ka wɔ fəki gia yələ a? A nya ndə ŋga biwɔ i wɔ a?” ");
INSERT INTO cug_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisɔs chukuli i bɔ a, “Mih tə ki bikəki lə kimbikə i mbɛiŋ. Mbɛiŋ ka chukuli mih, mih ka ni fuku i mbɛiŋ mi wə wi nya ŋga a mih fə̂ki gia yələ. ");
INSERT INTO cug_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jɔn nì juliki bəni i bɔkɔ num ŋga biwɔ nyə faiŋ? Bi nì nyə i bɛiŋ, ma nì nya mi wiwɔm a?” Si wi bikə yaka, bɔ ka yisi i dzakayiki a bɔ bɔ a, “Bukumbɛiŋ ka chukuli a bi nì nyə i bɛiŋ, wi ni bikə i bukumbɛiŋ a aka fə nə ka bukumbɛiŋ ma bum i Jɔn a? ");
INSERT INTO cug_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ayakalə, bukumbɛiŋ kɔkə i chukuli a, ‘A nì nya mi wiwɔm,’ kɔm bukumbɛiŋ lwaki mbaŋ wi bəni, kɔm bɔ bəchi nì kɔ num bɔ bum a Jɔn kɔ mi wi ntum wi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ayakadəiŋ, bɔ ka chukuli i Jisɔs a, “Buku kiəki kə.” Jisɔs ka dzaka i bɔ a, “Yaka mih tə ki fukuki kə i mbɛiŋ mi wə wi nya ŋga biwɔ i mih ka mih fəki gia yələ.” ");
INSERT INTO cug_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisɔs tsə a ninshiŋ bikə a, “Mbɛiŋ kwakaki a nə kɔm yələ? Mi widɔkɔ nì kaŋaki lə bwa bənyuku bəfa. Wi nyə tsə i waiŋ wi ninshiŋ wə, dzaka i wi a, ‘Waiŋ wuŋ, lâ tsə̂ shî nɔ̂mki i khə daiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wi chukuli a, ‘Mih laki kə.’ Ayakalə, wi baaŋ ka fiəni kwuni shɔm yi ka la tsə i fɛiŋ khə. ");
INSERT INTO cug_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mi wiwɔ tsə i wi kɔmsini wə ka dzaka tə a gia yə wi si dzaka i wi i ninshiŋ wə. Wi chukuli i wi a, ‘Mih ki laki lə ba wuŋ.’ Ayakalə, wi nəki la kə. ");
INSERT INTO cug_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","I kintəəŋ ki bwa bələ bəfa wə, akɔ winaiŋ wi nì fə gia yə ba wi nì nəŋki a?” Bɔ chukuli a, “Akɔ wi ninshiŋ wə.” Jisɔs ka dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, bəni bə kwani kiŋwakti bəh bəkaŋa bə tɔkɔlini si liə tsə lɔ i ŋkuŋ bi Nyɔ wə i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mih dzakaki lə kɔm Jɔn Njulibɔkɔ nì kɔ wi dzə chusi dzəhh yi chəŋ i mbɛiŋ, mbɛiŋ nəki bum kə wi, ayakalə bəni bə kwani kiŋwakti bəh bəkaŋa bə tɔkɔlini bum wi. Ayaka i jɔbi wə mbɛiŋ nì yɛiŋ na si bɔ bum yaka, nəki kwuni kə shɔ́m yimbɛiŋ i bum tə i wi.” ");
INSERT INTO cug_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisɔs chu dzaka a, “Mbɛiŋ chu wɔkɔ ndi widɔkɔ. Mi widɔkɔ nì nɔm khə wi mintam wə bə kɛiŋsiki mbi yɛiŋ, ka ta fiəli mbaiŋ, chum kishwa kə bə ni dəŋki mintam mbi buku yɛiŋ, ka maa kibaŋ ki mi wə wi ni chəniki khə wiwɔ, ka jiə bəni i yɛiŋ khə, ka nyə tsə i tumi kidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jɔbi wə bə si kɔh mintam miwɔ dzə kpɛiŋ, wi fâaŋ bəni bu bə nɔm i bəni bə̀ wi nì jiə i yɛiŋ khə, a bɔ tsə̂ dzɔ̂ mmu mintam. ");
INSERT INTO cug_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ayaka bɔ tsə, bəni bə̀ wi nì jiə i yɛiŋ khə kwa bɔ, twɛiŋ widɔkɔ, wɔɔ widɔkɔ, tumyi widɔkɔ bəh kitəh. ");
INSERT INTO cug_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wi chu faaŋ bəni bə nɔm bədɔkɔ bɔ du tsə bə ninshiŋ bə̀, bəni bəwɔ chu fə a liŋ asi bɔ si fə bəh bə ninshiŋ bə̀. ");
INSERT INTO cug_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Si yəmaka nì tsə wi faaŋ num waiŋ wi, kwaka a bɔ ni tsə kɔksi lə waiŋ wi ŋgaiŋ wələ. ");
INSERT INTO cug_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ayakalə, wi tsə, bəni bə nɔm bəwɔ ka yɛiŋ wi, dzaka a bɔ bɔ a, ‘Wələ kɔ ndzi kwili wi khə wələ. Mbɛiŋ dzə̂ ma bukumbɛiŋ wɔ̂ɔ wi ka bə dzi biɛiŋ bi.’ ");
INSERT INTO cug_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ayaka bɔ kwa guku buku bəh wi yɛiŋ khə, ka wɔɔ.” ");
INSERT INTO cug_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Si Jisɔs dzaka yakadəiŋ, ka bikə a, “Tii khə wələ jɔbi wə wi bi dzə wi bi fə dəiŋ bəh bəni bəwɔ a?” ");
INSERT INTO cug_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Bɔ chukuli a, “Wi bi dzə kaasiki lə minyamni miwɔ, wi jiə bəni bədɔkɔ i yɛiŋ khə bə̀ bɔ bi nyaki mmu mintam i jɔbi wi kɔhni wə.” ");
INSERT INTO cug_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisɔs bikə i bɔ a, “Mbɛiŋ ka num fa dəkə i Kiŋwakti ki Nyɔ wə a, ‘Təh wə bəni bə maani nì nəiŋ, akɔ wi wə wi nì fiəni chu təh wi bu wi juŋ a? Yələ kɔ mfə wi Bah, buku ka tsɛiŋki num bəh ŋkaiŋyi’ a? ");
INSERT INTO cug_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ayakadəiŋ mih fukuki i mbɛiŋ a, Nyɔ bi dzɔ bwili lə ŋkuŋ bi i kaŋ yimbɛiŋ wə, wi nya num i kitumi kə ki kɔ i fəki si wi nəŋki.” ");
INSERT INTO cug_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","“Na ndə wə wi bi gbɔki i təh wələ wə, wi mi wiwɔ bi shakyi i biŋka wə, ayaka təh wiwɔ ka bi gbɔ i mi bɛiŋ, ma wi ni gɔksi wi i kwɔŋɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Si Jisɔs ti ndi wiwɔ yakadəiŋ, bətii mfə gia bəmbum bəh Bəfalasi wɔkɔ, ka kiə a wi ti kɔm bɔ ŋgaiŋni. ");
INSERT INTO cug_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Bɔ ka nəŋki i kwa wi, ayakalə, fiəni lwa mbaŋ wi bəni, kɔm mbaŋ wiwɔ nì dzɔki Jisɔs a wi kɔ na mi wi ntum wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisɔs chu dzaka i bɔ i bəndi wə, widɔkɔ num a, ");
INSERT INTO cug_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Bə kɔ i fəkəni ŋkuŋ bi bɛiŋ bəh ŋkuŋ widɔkɔ wə wi nì sisi dzini bi ndzɔ wi miŋkpaŋ wimfiaŋ i waiŋ wi wi nyukuni. ");
INSERT INTO cug_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wi faaŋ bəchinda bu a bɔ tsə̂ bɔ̂ɔŋ bəni bə̀ wi ni laka bɔ i dzini bi ndzɔ wi miŋkpaŋ wimfiaŋ biələ wə a bɔ dzə̂. Ayakalə, bəchinda bə̀ tsə bəni bəwɔ nəki dzə kə. ");
INSERT INTO cug_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wi chu faaŋ bəchinda bədɔkɔ ka dzaka i bɔ a, ‘Mbɛiŋ tsə̂ fûku i bəni bə̀ mih ni laka bɔ i dzini bi ndzɔ wi miŋkpaŋ wimfiaŋ biələ wə a bɔ wɔ̂kɔ, a mih kɔ mih kɛiŋsi lɔ dzɛiŋ, ka kum nyám yi bwilini bəh dɔmi bi bwa bə nyám. Mih kɛiŋsi lɔ biɛiŋ bichi, a bɔ dzə̂ bini wə.’ ");
INSERT INTO cug_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ayakalə, bɔ tsə, bəni bəwɔ chasi bɔ nəki tsə kə. Widɔkɔ la i khə wi wə, widɔkɔ la shi yi. ");
INSERT INTO cug_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kiŋka ki bəni bədɔkɔ kwa bəchinda bədɔkɔ chəbsi bɔ, ka wɔɔyi. ");
INSERT INTO cug_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Shɔm bɔkɔ ŋkuŋ wiwɔ, wi faaŋ bəni bu bə jum, bɔ tsə laksi bəni bəwɔ bə̀ bɔ wɔɔyi bəchinda bu, ka kpa kwili wibɔ. ");
INSERT INTO cug_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Si wi fə yakadəiŋ, ka dzaka i bəchinda bu a, ‘Mih kɔ mih kɛiŋsi lɔ dzini bi ndzɔ wi miŋkpaŋa wimfiaŋ . Ayakalə, bəni bə̀ mih ni laka bɔ kɔkə bəni nalə kpaaa. ");
INSERT INTO cug_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mbɛiŋ tsə̂ i bi ntasi bi dzə́h yichi wə, mbɛiŋ lâka bəni bəchi bə̀ mbɛiŋ ni yɛiŋ, a bɔ dzə̂ i dzini bi ndzɔ wi miŋkpaŋa wimfiaŋ biələ wə.’ ");
INSERT INTO cug_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bəchinda bəwɔ ka buku tsə i dzə́h yichi wə, juŋni bəni bəchi bə̀ bɔ ni yɛiŋ, bəni bə ndzɔŋni bəh bə chu dzə bəh bɔ fɛiŋ. Juŋ yi ndzɔ wi miŋkpaŋa yiwɔ jikə bəh bəni. ");
INSERT INTO cug_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ŋkuŋ dza liə i juŋ yi ndzɔ wi miŋkpaŋa yiwɔ wə i yɛiŋ bəni bə̀ bɔ dzə i dzini biwɔ wə, ka yɛiŋ mi widɔkɔ wi num maka wi lɔh mbuŋ wi ndzɔni wi miŋkpaŋa. ");
INSERT INTO cug_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wi bikə i wi a, ‘Nsɛiŋ wuŋ, wɔ nyani dəiŋ i liə fa wɔ kaŋa kə mbuŋ wi bini a?’ Mi wiwɔ kpichumi a mɔɔŋ. ");
INSERT INTO cug_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ŋkuŋ ka dzaka i bəchinda bu a, ‘Mbɛiŋ kâŋa kaŋ yi bəh gvu yi, mbɛiŋ lɔ̂ɔ wi i biŋ bi jisi wə, i di biə bəni bi dəki dzi jəŋ.’” ");
INSERT INTO cug_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Si Jisɔs dzaka yakadəiŋ, ka dzaka a, “Ma mbɛiŋ kîəki a Nyɔ bɔɔŋ bəni bəduli, ayakalə wi sabibwili a twɛsi.” ");
INSERT INTO cug_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Bəfalasi ka nyə tsə kɛiŋsi si bɔ ni fə Jisɔs fini bəh ndzaka ka bɔ kwa wi. ");
INSERT INTO cug_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Bɔ ka faaŋ bwa bəbɔ bə mbaŋ bəh bəni i mbaŋ wi Ŋkuŋ Hɛlɔd i Jisɔs. Bɔ tsə dzaka i wi a, “Mi wi lanini buku kiəki lə a wɔ kɔ mi wi ŋkɔŋ, wɔ laniki bəni bəh dzə́h yi Nyɔ biəli ŋkɔŋ. Wɔ si lansi dzɔ kə a mi widɔkɔ kɔ chi chi, kɔm wɔ si lansi tsɛiŋ kə mi kɔm fiɛŋ fiə wi kɔ fi. ");
INSERT INTO cug_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Fuku i buku i liə gia yə wɔ kwakaki. Nchi bumki lə a bukumbɛiŋ lɔ̂ɔki kiŋwakti i Kaysa ŋkuŋ wi Lum, ma bə ma lɔ̂ɔki a?” ");
INSERT INTO cug_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ayakalə, Jisɔs kiə gia yə bɔ finiki bəh yi, ka dzaka i bɔ a, “Mbɛiŋ bəni bələ mbɛiŋ dzakaki chi fə chi, mbɛiŋ taaŋki mih kɔm nə? ");
INSERT INTO cug_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mbɛiŋ dzə bəh kpɔ wə mbɛiŋ si lɔɔ kiŋwakti yɛiŋ mih yɛiŋ.” Bɔ dzə bəh dzəkəh wi kpɔ, nya i wi. ");
INSERT INTO cug_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jisɔs bikə i bɔ a, “Fwu wələ bəh yɛli wələ yɛiŋ kɔ wi ndə?” ");
INSERT INTO cug_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Bɔ chukuli a, “Akɔ wi Kaysa.” Wi ka dzaka i bɔ a, “Mbɛiŋ nyâki i Kaysa fiɛŋ fiə fi kɔ fi Kaysa, mbɛiŋ nyâki i Nyɔ fiɛŋ fiə fi kɔ fi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Si bɔ nì wɔkɔ yi yakadəiŋ, dzaka wɔm bɔ. Bɔ ka bee wi ka nyəki a nyəni. ");
INSERT INTO cug_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","A chɔkɔ biwɔ wə, Bəsadusi nyə dzə i Jisɔs wə. Bəsadusi bələ kɔ mbaŋ wi bəni bə̀ bɔ si dzaka a bəni bi dza kə i kpi wə. Si bɔ dzə, ka bikə i Jisɔs a, ");
INSERT INTO cug_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mi wi lanini, Muses nì dzaka a, ‘Mi ka kpi wi kaŋa kə waiŋ bəh kpə wi, waiŋnih wi kaŋaki i nɔ̂si miŋkpaŋa wiwɔ ka bɔ wi bwɔ̂ bwa i yɛli wi ŋkwu wiwɔ wə.’ ");
INSERT INTO cug_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","I liə, bwa bə mi widɔkɔ nì kɔlə nanitaŋ. Wi ninshiŋ bi dzɔ miŋkpaŋa, wi nyani dzə kpi maka bɔ wi kwati waiŋ, bee kpə wi i waiŋnih wi wi kɔmsini. ");
INSERT INTO cug_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Yi num ayaka i wi kɔmsini wiwɔ, bəh i shi buku i bə̀ nanitaŋ bəchi. ");
INSERT INTO cug_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Si yəmaka nì tsə miŋkpaŋa wiwɔ bɔŋ kpi. ");
INSERT INTO cug_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","I liə si bɔ bəchi nanitaŋ nì kɔ bɔ nɔsi lɔ miŋkpaŋa wiwɔ, a bi numki i chɔkɔ biə bəni bi dzaki i kpi wə, miŋkpaŋa wiwɔ bi numki kpə ndə a?” ");
INSERT INTO cug_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisɔs chukuli i bɔ a, “Mbɛiŋ kɔ na fikpəŋ bəh ŋga, num kɔm mbɛiŋ kiəki kə gia yə bə nyaka i Kiŋwakti ki Nyɔ wə. Nabə i kiə tə ŋga bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ma mbɛiŋ kîəki a, a bi numki i chɔkɔ biə bəni bi dzayiki i kpi wə, bənyuku bəh bəkaŋa bi chu chiŋni kə i ndzɔ wi bəkaŋa wə, bəni bi chu nyaki kə bwa bəbɔ i chiŋni i ndzɔ wi bəkaŋa wə. Bə bi numki aka bəchinda bə Nyɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ayaka i dzaka kɔm ndza wə bəni bi dzayiki i kpi wə, mbɛiŋ ka num fa Kiŋwakti ki Nyɔ i wɔkɔ gia yə wi dzakaki i mbɛiŋ a? Nyɔ nì dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Akɔ mih Nyɔ wi Ablaham bəh wi Ayjik bəh wi Yakɔb.’ Yi num a Nyɔ kɔkə Nyɔ wi bəŋkwu, wi kɔ Nyɔ wi bəni bəwɔm.” ");
INSERT INTO cug_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jɔbi wə mbaŋ wə wi nì kɔ fɛiŋ wɔkɔ gia yə Jisɔs dzaka, dzaka wɔm bɔ bəh nlani wi. ");
INSERT INTO cug_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jɔbi wə Bəfalasi nì dzə wɔkɔ a Jisɔs baŋ dzaka ki Bəsadusi, bɔ juŋni gwu yibɔ ka dzə i yɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mi widɔkɔ i bɔ kintəəŋ wə wi nì lansiki kiəki bənchi bə Nyɔ, ka mɔmsi wi bəh kimbikə kidɔkɔ a, ");
INSERT INTO cug_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Mi wi lanini, nchi wi ləkəli wə wi tsəki bənchi bəchi kɔ winaiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisɔs chukuli i wi a, “Nchi wə wi ləkəli kɔ wə wi dzakaki a, ‘Kɔ̂ŋ Bah Nyɔ wa bəh shɔm ya yichi, nyâ gwu ya i wi yichi, jîə mfi bia i wi bichi.’ ");
INSERT INTO cug_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Wələ kɔ nchi wi ləkəli wi ninshiŋ wə wi tsəki bənchi bəchi. ");
INSERT INTO cug_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Wə wi kɔmsiki i wi, kɔ aka wi. Wi num a, ‘Wɔ kɔ̂ŋki mi wə wi kɔ kɔmsi i wɔ kpəŋ asi wɔ kɔŋki gwu ya.’ ");
INSERT INTO cug_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gia yichi yə yi kɔ i Kiŋwakti ki Bənchi wə, bəh yə yi kɔ i Biŋwakti bi bəni bə ntum bə Nyɔ wə, bɔ kɔ a bənchi bəfa bələ kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Asi Bəfalasi nì kɔ bɔ juŋni dzə fɛiŋ, Jisɔs ka dza bikə kimbikə kidɔkɔ i bɔ a, ");
INSERT INTO cug_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mbɛiŋ kwakaki a nə kɔm Kimbwili wə Nyɔ nì kaka a? Mbɛiŋ kwakaki fimbɛiŋ a wi kɔ waiŋ ndə?” Bɔ chukuli a, “Akɔ waiŋ Ŋkuŋ Dɛbit.” ");
INSERT INTO cug_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisɔs fiəni bikə i bɔ a, “Si akɔ waiŋ Ŋkuŋ Dɛbit yi ka nyani dəiŋ a Kiŋ'waka ki Nyɔ fə Dɛbit bɔɔŋki wi a Bah wi ŋgaiŋ a? Dɛbit nì dzaka a, ");
INSERT INTO cug_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bah Nyɔ nì dzaka i Bah wuŋ a, wi shînum i tsɛiŋ yi yiləkəli wə, i tsə̂ bûku jɔbi wə wi bi nɔsi bəmbaiŋŋni bu wi tɔmyi gvu yi i bɔ bɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dɛbit kabə bɔɔŋki wi a Bah wi ŋgaiŋ, wi fiəni nyani dəiŋ ka wi numki waiŋ wi a?” ");
INSERT INTO cug_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Si Jisɔs dzaka yakadəiŋ, mi widɔkɔ nəki kaŋa kə gia i chukuli i wi. Na i yisi chɔkɔ biwɔ, mi widɔkɔ na chu mɔm i bikə wi bəh kimbikə kidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jisɔs ka dza dzaka i mbaŋ wi bəni bəh bwa bu bə mbaŋ a, ");
INSERT INTO cug_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Bəni bə̀ bɔ laniki bənchi bəh Bəfalasi kɔ bəni bə̀ bɔ num i kiŋgbɔkɔ ki Muses wə. ");
INSERT INTO cug_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ayakadəiŋ, yi kɔ a, mbɛiŋ wɔ̂kɔki gia yichi yə bɔ fukuki i mbɛiŋ, mbɛiŋ fə̂. Ayakalə, kiə mbɛiŋ ma fəki gia yə bɔ fəki, kɔm bɔ fukuki chi, fə chi. ");
INSERT INTO cug_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bɔ si dza kaŋa bəntiə bə̀ bɔ jiki tsəki ŋga bi bəni, jikli bəni yɛiŋ, na bɔ mwi kɔbi i tɔbi na waiŋkpaŋ i gamti bɔ. ");
INSERT INTO cug_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Gia yichi yə bɔ fəki kɔ a bəni yɛiŋki bɔ. Mintaiŋtaiŋ bibɔ bi Kiŋwakti ki Nyɔ num na bimbum. Dzaka kijəŋ kibɔ ki bəmbuŋ num na bi dəəŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bɔ si tsə i bini wə kɔŋ i numki a i di biə bəni ni kɔksiki bɔ yɛiŋ, bɔ si tsə i júŋ yi tsani wə kɔŋ a numki num a biŋgbɔkɔ bi ninshiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bɔ si kɔŋ tə i nyaniki i kidi ki shi wə bəni bɔni bɔ, chu kɔŋ tə a bəni bɔ̂ɔŋki bɔ a Bəlabay. ");
INSERT INTO cug_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ayakalə, kiə mi ki bûm kə a bəni bɔɔŋki wi a Labay, kɔm mbɛiŋ kaŋaki a Mi wi Lanini wimu shəŋ, mbɛiŋ bəchi kɔ bwa bə nih wimu. ");
INSERT INTO cug_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kiə mbɛiŋ ki bɔ̂ɔŋ kə mi widɔkɔ i fa kuku a, akɔ Ba wimbɛiŋ, kɔm mbɛiŋ kaŋaki a Ba wimbɛiŋ wimu wə wi kɔ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kiə mi ki bûm kə a bə bɔɔŋki wi a Tikwili, kɔm Tikwili wimbɛiŋ kɔ a wimu wə wi kɔ Klistus. ");
INSERT INTO cug_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mi wimbum i mbɛiŋ kintəəŋ kaŋaki i nûmki mi wə wi nɔmki i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Na ndə wə wi yaksiki gwu yi, Nyɔ bi shisiki lə wi, na ndə wə wi shisiki gwu yi, Nyɔ bi yaksiki lə wi. ");
INSERT INTO cug_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ŋgəkə wimbum kɔ wimbɛiŋ, mbɛiŋ bəni bə̀ bɔ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi, fə chi! Mbɛiŋ numki i bəni nshiŋ kəŋ baŋ dzəh yə yi liəki i ŋkuŋ bi bɛiŋ wə. Mbɛiŋ kɔŋ kə i liə i yɛiŋ wə, chu baŋ dzəh i bəni bə̀ bɔ kɔŋki i liə yɛiŋ.  ");
INSERT INTO cug_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ŋgəkə wimbum kɔ wimbɛiŋ, mbɛiŋ bəni bə̀ bɔ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ sɛiŋsiki biɛiŋ bi bəkaŋa bəŋkwu, ka kwayiki fəki bəh bəntsa bədəəŋ. Mbɛiŋ kîə a ŋgəkə wimbɛiŋ bi gumi tsə lə wi bəni bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ŋgəkə wimbum kɔ wimbɛiŋ, mbɛiŋ bəni bə̀ bɔ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi, fə chi! Mbɛiŋ si dza nyani tumi kichi chu daŋ bɔ́kɔ yimbum alə a mbɛiŋ nəŋki mi wimu a wi fiəni chu mi wimbɛiŋ wi bumni, jɔbi wə wi fiəni chu mi wimbɛiŋ wi bumni, mbɛiŋ chu fiəni fə wi, wi fɔɔ num fɔni, wi ka numki mi wi gbuku wimbum aka mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ŋgəkə wimbum kɔ wimbɛiŋ. Mbɛiŋ kɔ bimfəkə dzaka a mbɛiŋ chusiki dzəh i bəni! Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki a, ‘A mi ka dzaka gia, kaiŋ yɛli wi juŋ yi fəni gia, a yəmaka mɔŋ gia yidɔkɔ. Ayakalə, mi ka dzaka gia yidɔkɔ ka kaiŋ num i yɛli wi chwaka ki kpɔ ki juŋ yi fəni yi gia mə, yaka ka wi kaŋaki i fə gia yə wi si dzaka ka kaiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Bimfəkə biələ! Mbɛiŋ kɔ biyuŋ! Fiɛŋ fiə fi kpaliki tsəki fidɔkɔ kɔ fi naiŋ a? Fi kpalini kɔ chwaka ki kpɔ ki baiŋni, ma juŋ yi fəni yi gia yə yi fəki chwaka kiwɔ ka ki numki fiɛŋ fiə fi kɔ fi Nyɔ a? ");
INSERT INTO cug_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mbɛiŋ dzaka tə a, ‘Mi ka dzaka gia ka kaiŋ i yɛli wi tɔŋ wi fəni wi gia wə, ma yi numki kə gia yidɔkɔ. Ayakalə, mi ka dzaka gia yidɔkɔ ka kaiŋ num i yɛli wi fiɛŋ fiə wi nya kiyɔŋni yɛiŋ, ma wi kaŋaki i fə gia yiwɔ asi wi dzaka ka kaiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Bimfəkə biələ! Fiɛŋ fiə fi kpaliki tsəki fidɔkɔ kɔ fi naiŋ a? Akɔ kinya kə, ma tɔŋ wi fəni wi gia wə wi fə ka kinya kiwɔ ni numki biɛiŋ biə bi kɔ bi Nyɔ a? ");
INSERT INTO cug_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gia yə yi kɔ, kɔ a, mi ka kaiŋ i yɛli wi tɔŋ wi fəni wi gia wə, ma yi numki a wi kaiŋ yaka ka kaiŋ tasi bəh biɛiŋ bichi biə bi kɔ i tɔŋ wi fəni wi gia wə. ");
INSERT INTO cug_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mi ka kaiŋ i yɛli wi juŋ yi fəni yi gia wə, ma yi numki a wi kaiŋ yaka ka kaiŋ tasi i Nyɔ wə wi nɔki yɛiŋ dzu. ");
INSERT INTO cug_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mi wə wi kaiŋ num i tumi ki bɛiŋ wə, ma yi numki a wi kaiŋ num i kiŋkii ki Nyɔ wə, bəh wi Nyɔ wə wi num yɛiŋ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ŋgəkə wimbum kɔ wimbɛiŋ bəni bə̀ bɔ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi, fə chi! Mbɛiŋ si nya kimbu kimu i jwɔfi kintəəŋ i Nyɔ i biɛiŋ bi jwa biə mbɛiŋ kəkəki jiə i jwa wə, ayakalə mbɛiŋ tsɛiŋ kə gia yi ləkəli yə nchi dzakaki kɔm yi a mbɛiŋ fə̂ki, yə yi kɔ i fə̂ki gia yi chəŋ i bəni, kwâsi nshɛiŋ i bəni, jîə shɔm i Nyɔ. Mbɛiŋ si kaŋaki i fə̂ki gia yələ yichi bee kə yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bimfəkə biə bi chusiki dzəh i bəni! Mbɛiŋ yəliki bwiliki michuchu i mbi wə, ayakalə yiŋni məyi mu num nyam yimbum! ");
INSERT INTO cug_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ŋgəkə wimbum kɔ wimbɛiŋ mbɛiŋ bəni bə̀ bɔ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi, fə chi! Mbɛiŋ wɔkɔki kibwam bəh bətasa i gwu wə, ayakalə kintəəŋ kiwɔ num ki jikə bəh biɛiŋ biə mbɛiŋ lɔkɔ i bəni bəh biə mbɛiŋ bukuki bəh dzə́kəh yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Bimfəkə bi Bəfalasi, mbɛiŋ yisi wɔ̂kɔ kibwam bəh bətasa i numə, ka bi baiŋki tə i gwu wə. ");
INSERT INTO cug_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ŋgəkə wimbum kɔ wimbɛiŋ mbɛiŋ bəni bə̀ bɔ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi, fə chi! Mbɛiŋ kɔ aka júm yə bə kɔ num bə kɛiŋsi fiaŋsi yi bəh fiəŋ yi baiŋ ndzɔŋ i dzəkəh wə, ayakalə i yɛiŋ kintəəŋ num yi jikə bəh biŋkuŋu bi bəni bə kpili bəh biɛiŋ bi kinyɛŋ bichi. ");
INSERT INTO cug_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ayaka yi kɔ tə a liŋ si mbɛiŋ chusiki gwu i bəni nshiŋ a mbɛiŋ kɔ bəni bə chəŋ, ayakalə i kintəəŋ, num mbɛiŋ jikə bəh mfwɔkyi bəh nɔni kichu. ");
INSERT INTO cug_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ŋgəkə wimbum kɔ wimbɛiŋ mbɛiŋ bəni bə̀ mbɛiŋ laniki bənchi bəh mbɛiŋ Bəfalasi. Mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi, fə chi! Mbɛiŋ maaki júm yi bəni bə ntum bə Nyɔ, kɛiŋsi ndzɔŋ júm yi bəni bə̀ bɔ nì kaŋaki nɔni ki chəŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mbɛiŋ fəki yakadəiŋ dzaka a, ‘A nì kɔ a buku numki i jɔbi wi bətii bəbuku wə, ma buku nì ka ləkə dəkə kaŋ yibuku i gia yə bɔ nì fəki wɔɔyi bəni bə ntum bə Nyɔ.’ ");
INSERT INTO cug_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mbɛiŋ dzakaki yakadəiŋ, dzaka num kɔm i gwu yimbɛiŋ wə tɔbi bəh dzaka kimbɛiŋ a mbɛiŋ kɔ bwa bə bəni bə̀ bɔ nì wɔɔyiki bəni bə ntum bə Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mbɛiŋ tsə̂ bəh nɔm i ninshiŋ mbɛiŋ kâasi nɔm wə bətii bəmbɛiŋ nì yisi! ");
INSERT INTO cug_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Júŋŋ yələ! Bwa bə fə́kəh bələ! Mbɛiŋ kwakaki a mbɛiŋ bi numki lə maka bə jiə mbɛiŋ i gbuku wimbum wə a? ");
INSERT INTO cug_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Si yi kɔ yakadəiŋ, mih faaŋ bəni bə ntum bə Nyɔ i mbɛiŋ bəh bəni bə mfi bəh bəni bə lanini bənchi. Mbɛiŋ bi wɔɔyi bədɔkɔ, baŋŋyi bədɔkɔ i kintasi wə, twɛiŋ bədɔkɔ i júŋ yimbɛiŋ yi tsani mə, bwaŋ gvu i bədɔkɔ chɛiŋ i kikwili kichi kə bɔ tsəki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Mbɛiŋ bi fəki yakadəiŋ ka mwa mi bəni bəchi bə̀ bɔ nì nɔki nɔni ki chəŋ fa kuku bə̀ bə nì wɔɔyi bi numki i mbɛiŋ fuŋ. Mwa mələ bi numki i mbɛiŋ fuŋ i yisi i Abɛl wə bə nì wɔɔ wi kaŋa kə ŋgəkə widɔkɔ, i tsə buku i Sakalia wə waiŋ Belekaya wə mbɛiŋ nì wɔɔ i fintəŋ ki juŋ yi fəni yi gia wə bəh i tɔŋ wi fəni wi gia wə. ");
INSERT INTO cug_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mih fukuki ŋkɔŋ i mbɛiŋ a, lɔiŋ wi gia yələ bi kwati lə ŋgɔkɔ wi liə wələ.” ");
INSERT INTO cug_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Si Jisɔs dzaka lə, wi ka chu dzaka a, “Yəbɛɛy Jɛlusalɛm! Yəbɛɛy Jɛlusalɛm! Wɔ wɔɔyiki bəni bə ntum bə Nyɔ, chu tumyi bəni bə̀ Nyɔ faaŋki i mbɛiŋ bəh kitəh! Akɔ kiŋkani kimaiŋ si mih mɔmsi i juŋni bwa ba asi nih shyə si juŋni bwa bu wi kwumi baŋ bəh bəkəli bi, wɔ nəiŋma a? ");
INSERT INTO cug_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tsɛ̂iŋ, bə kɔ num bə lɔtɔkɔ lɔ juŋ ya, yi fiəni num chii. ");
INSERT INTO cug_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mih fukuki i mbɛiŋ a, mbɛiŋ bi chu yɛiŋ kə mih, i tsə buku jɔbi wə mbɛiŋ bi dzakaki a, ‘Nyɔ jiə kimbɔiŋsi i mi wə wi dzəki i yɛli wi Bah wə.’” ");
INSERT INTO cug_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisɔs nì buku i juŋ yi fəni yi gia wə, si wi tsəki, bwa bu bə mbaŋ kɔmsi dzə i wi wə ka chusiki júŋ yə yi kɔ i di bi juŋ yi fəni yi gia wə i wi. ");
INSERT INTO cug_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ayakalə, Jisɔs dzaka i bɔ a, “Mbɛiŋ yɛiŋ júŋ yələ a? Mih fukuki ŋkɔŋ i mbɛiŋ a, təh wimu bi baaŋ kə i widɔkɔ bɛiŋ maka bə baka tɔkɔ wi i kuku.” ");
INSERT INTO cug_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jɔbi wə Jisɔs nì tsə shinum i Ŋkwuŋ wi Kɛiŋ yi Ɔlif wə, bwa bu bə mbaŋ dza dzə i wi wə a bɔ bɔ ka bikə a, “Fûku i buku jɔbi wə gia yələ bi numki, bəh kinchəsi kə ki bi chusiki jɔbi wə wɔ fiəniki dzəki yɛiŋ bəh a mbi si kaa tsə lə?” ");
INSERT INTO cug_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jisɔs chukuli i bɔ a, “Mbɛiŋ tɔkniki, ka mi bi ma fwɔkyi mbɛiŋ a mbɛiŋ ndzani dzəh. ");
INSERT INTO cug_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mbɛiŋ kiəki a bəni bəduli bi dzə lə dzɔ yɛli wuŋ kəŋ i bɔ nshiŋ, mi dzaka a ŋgaiŋ kɔ Kimbwili wə Nyɔ nì kaka. Bɔ bi fəki yakadəiŋ fwɔkyi bəni bəduli a bɔ ndzani dzəh. ");
INSERT INTO cug_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mbɛiŋ bi wɔkɔki lə a bə tumki jum, chu wɔkɔ tə gia kɔm jum. Jɔbi wə mbɛiŋ bi wɔkɔki yakadəiŋ, kiə shɔm bi tə̂iŋyi kə mbɛiŋ. Yələ kɔ gia yə yi kaŋaki i bi num. Ayakalə, yi chusi kə a mbi si kaa tsəki lə. ");
INSERT INTO cug_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tumi bi tumki jum bəh kidɔkɔ, ayaka ntɔŋ widɔkɔ tum jum bəh widɔkɔ. Dzɔŋ tə bi numki, nshwaiŋ bi nəŋniki i di di wə. ");
INSERT INTO cug_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Yəmaka gia yichi bi numki aka lɔli bi miŋkpaŋa wə wi yisi i nɔmhki. ");
INSERT INTO cug_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Bəni bi dzɔki nyaki mbɛiŋ a bə chəbsiki mbɛiŋ, wɔɔyi mbɛiŋ. Bitumi bichi bi baiŋŋki lə mbɛiŋ kɔm bə yɛli wuŋ. ");
INSERT INTO cug_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ayakadəiŋ, bəni bəduli bi ka gbɔyiki i kimbum kibɔ wə, baiŋŋ gwu yibɔ, taŋni gwú yibɔ. ");
INSERT INTO cug_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bəni bəduli bə̀ bɔ nyiki ntəkə a, a faaŋ Nyɔ bɔ bi tumbuku lə i fwɔkyiki bəni bəduli. ");
INSERT INTO cug_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Si chu bi duki tsəki i ninshiŋ, kɔ num lə si yi bi fəki kiŋkɔŋ ki bəni bəduli bi dəki. ");
INSERT INTO cug_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ayakalə, mi wə wi bi kaŋaki shɔm i tsə buku i kiŋgɔksi wə akɔ wə wi bi bɔiŋki. ");
INSERT INTO cug_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Bə kâŋa i bi fuku ntum wi ndzɔŋni wələ kɔm ŋkuŋ bi Nyɔ i tsə buku i kiŋgɔksi ki mbi wə kichi ka kitumi kichi bi wɔkɔ, na ka yi bi numki a mbi tsɛiŋki i kaa. ");
INSERT INTO cug_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Ayakadəiŋ, jɔbi wə mbɛiŋ bi yɛiŋki gia yi gumini yə yi kɔ i bəkəli di num yi dzə num i juŋ yi fəni yi gia wə, a num yə mi wi ntum wi Nyɔ Daniəl nì kɔ wi dzaka kɔm yi, (mi wə wi faki kiŋwakti kələ wɔ̂kɔ yi na bindzɔŋ), ");
INSERT INTO cug_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","bəni bə̀ bɔ kɔ i Judea bi gɛ̂iŋ yâka i ŋkwúŋ wə. ");
INSERT INTO cug_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mi wə wi kɔ i fwu wi juŋ bɛiŋ wi bi ma chu shî lîə i dzu a ŋgaiŋ dzɔ̂ki fiɛŋ fidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Wə wi kɔ i khə bi ma chu kwɛ̂ a wi tsə̂ dzɔ̂ mbuŋ wi baŋni wi gwu. ");
INSERT INTO cug_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ŋgəkə wimbum bi numki wi bəkaŋa bə̀ bɔ bi numki bəh kitɔɔ, bəh bə̀ bɔ masiki bwa. ");
INSERT INTO cug_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mbɛiŋ tsâki a n'yɔkɔ ŋgɛiŋ wələ bi ma num i jɔbi wi fiəkə yiləkəli wə, nabə i chɔkɔ bimbam wə, ");
INSERT INTO cug_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","kɔm ŋgəkə wimbum bi numki lə i jɔbi wiwɔ wə, ayaka wəmaka ŋkaiŋni wi ŋgəkə kɛiŋki ki num kə na si mbi nì yisi i dzə buku bidaiŋ, ayaka wəmaka ŋkaiŋni wi ŋgəkə kɔbi i bi chu lansi num. ");
INSERT INTO cug_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A nì kɔkə a Nyɔ gaali kaŋ yi ŋgəkə yiwɔ, ma mi wiwɔm na wimu bi bɔiŋ kə. Ayakalə, Nyɔ kɔ wi gaali kaŋ yiwɔ kɔm bə bəni bu bə̀ wi kɔ wi sabibwili. ");
INSERT INTO cug_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mi ka bi dzaka i mbɛiŋ i kaŋ yiwɔ wə a ‘Mbɛiŋ tsɛ̂iŋ, Kimbwili wə Nyɔ nì kaka a bə wi lə fa!’ Yudɔkɔ a, ‘Bə wi yaka fi!’ Kiə mbɛiŋ bi bûm kə yi. ");
INSERT INTO cug_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mbɛiŋ kîə a bəni bi dzə lə nyi ntəkə a bɔ kɔ bəmbwili bə̀ Nyɔ nì kaka, bədɔkɔ dzaka a bɔ kɔ bəni bə ntum bə Nyɔ, bɔ fə bənchəsi bə̀ bɔ chusiki ŋga bibɔ, fə tə gia yi dzaka ki wɔmni, ka yi fwɔkyiki bəni a bɔ dali dzəh, i tasi na bəh bəni bə̀ Nyɔ kɔ wi sabibwili, i jɔbi wə dzəh ka num. ");
INSERT INTO cug_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mbɛiŋ wɔ̂kɔ, mih fukuki gia yələ i mbɛiŋ lə ka yi bi dzə kpɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ayakadəiŋ, bəni ka dza dzaka i mbɛiŋ a, ‘Mbɛiŋ tsɛ̂iŋ, Kimbwili wə Nyɔ nì kaka bə wi yaka i chwa,’ kiə mbɛiŋ bi tsə̂ kə fɛiŋ. Yudɔkɔ a, ‘Mbɛiŋ tsɛiŋ, bə wi yaka i fintəŋ fi juŋ mə,’ kiə mbɛiŋ ki bûm kə i bɔ. ");
INSERT INTO cug_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mbɛiŋ kîə a, asi dzaŋ si mwaiŋ yi baiŋ i kimbu kə wɔŋ bukuki, yi baiŋ i tsə buku i di biə wɔŋ liəki, yi bi numki a liŋ asi ndzə wi mi wə yɛli wi kɔ Waiŋmi bi numki. ");
INSERT INTO cug_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‘Na faiŋ wə kiŋkpili ki fiɛŋ kɔ, akɔ fɛiŋ wə bəŋguluŋ si juŋni.’ ");
INSERT INTO cug_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Akisəkə asi kaŋ yi ŋgəkə wimbum wələ bi dzə tsəki, wɔŋ bi dza jiki num jini, fiəŋŋ bi ma chu baiŋki tə, bijɔŋ bi gbɔyiki i bɛiŋ, biɛiŋ bichi biə bi kaŋaki ŋga i bɛiŋ bi nəŋniki. ");
INSERT INTO cug_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ma kinchəsi ki mi wə yɛli wi kɔ Waiŋmi bi chusi i bɔɔli bɛiŋ. Kitumi kichi i nshwaiŋ wə bi ka yisi i nyufiki gwu bəh mindəm. Bəni bi ka yɛiŋ mi wə yɛli wi kɔ Waiŋmi si wi dzəki i bikwu wə i bɛiŋ bəh ŋga bəh kiŋkɔkni kimbum. ");
INSERT INTO cug_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jɔbi wə jəŋ bi nyaki ja yi ləkəli i bɛiŋ, wi ka bi chiŋsi bəchinda bu i bimbu bi mbi binaa i bɛiŋ, a bɔ dzə juŋni bəni bu bə̀ wi kɔ wi sabibwili lɔ. ");
INSERT INTO cug_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mbɛiŋ lâni dzɔ̂ gia i kpɛiŋ wi fidəiŋ wə. Jɔbi wə cha yiwɔ yisi i nyaki mwi, bwili bindzɛni, mbɛiŋ ka kiəki a nyum kwuni lɔ gwu. ");
INSERT INTO cug_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yi kɔ a liŋ i jɔbi wə mbɛiŋ bi yɛiŋki gia yələ yichi, mbɛiŋ ka kiəki a, wi si num dzə a i dzaka kifiəŋə wə. ");
INSERT INTO cug_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mih fukuki ŋkɔŋ i mbɛiŋ a, ŋgɔkɔ wi liə wələ bi tsə kaa kə maka gia yələ yichi num lɔ. ");
INSERT INTO cug_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Bɔɔli bəh nshwaiŋ bi tsə kaa lə, ayakalə gia yiŋ kɔbi i bi lansi nəŋni. ");
INSERT INTO cug_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mi widɔkɔ kɔkə wə wi kiəki chɔkɔ biwɔ nabə jɔbi wiwɔ. Na bəchinda bə Nyɔ bə̀ i bɛiŋ bəh Waiŋ Nyɔ kiəki kə tə chɔkɔ biwɔ. Akɔ a Nyɔ Ba wi mbɔŋ wə wi kiəki. ");
INSERT INTO cug_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Asi yi nì kɔ i jɔbi wi Nɔa wə, lə yi bi numki i chɔkɔ biə Mi wə yɛli wi kɔ Waiŋmi bi fiəni dzə. ");
INSERT INTO cug_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A nì kɔ maka mwi buku baŋ mbi wələ wichi, bəni nì kɔ fibɔ dzi a dzini chu mu, ayaka bəkaŋa bəh bənyuku chiŋni i ndzɔ wi bəkaŋa wə, bəni nya bwa bə̀ bɔ i ndzɔ wi bəkaŋa wə, i tsə buku i chɔkɔ biə Nɔa nì liə i ŋgwuki mə, ");
INSERT INTO cug_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","bəni bəwɔ nəki kiə kə gia yə yi kaŋaki ni num, i tsə buku i jɔbi wə mwi nì buku jikə i mbi wələ wichi wə, kɔh nyə bəh bɔ bəchi. Akɔ ayaka si yi bi numki i chɔkɔ biə mi wə yɛli wi kɔ Waiŋmi bi fiəni dzəki. ");
INSERT INTO cug_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Bənyuku bəfa bi numki i khə, bə bi dzɔ wimu ma wimu bi baaŋ. ");
INSERT INTO cug_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bəkaŋa bəfa bi gɔkɔki nyəə i nəkə bɛiŋ, ma bə bi dzɔ wimu ma wimu bi baaŋ. ");
INSERT INTO cug_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ayakadəiŋ, mbɛiŋ nûmki bəh ŋkɛiŋsi wi gwu kɔm mbɛiŋ kiəki kə chɔkɔ biə Bah bi fiəniki numki i dzə yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mbɛiŋ kîəki a, tikwili kabə kiəki jɔbi wə ji kaŋaki i dzə nchɔkɔ fɔkɔ, ma wi ni tɔkniki, wi ma ni buku bee a wi dzə bwiŋ juŋ yi. ");
INSERT INTO cug_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yi kɔ a mbɛiŋ tə kaŋaki i nûmki bəh ŋkɛiŋsi wi gwu, kɔm mi wə yɛli wi kɔ Waiŋmi bi dzəki i jɔbi wə mbɛiŋ kwakaki kə. ");
INSERT INTO cug_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Waiŋ wi nɔm wə wi kɔ wi ŋkɔŋ chu kaŋa mfi kɔ winaiŋ? Ntə akɔ wə tikwili wi nì jiə a wi tɔkniki bəh juŋ yi a jɔbi wə jɔbi ka kpɛiŋ, wi ni nyaki biɛiŋ bidzini i bwa bu bə nɔm a? ");
INSERT INTO cug_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kinsaŋli kimbum bi numki i waiŋ wi nɔm wə tikwili wi bi dzə yɛiŋki num wi fə nɔm wi a liŋ asi wi si nəŋki. ");
INSERT INTO cug_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mih fukuki ŋkɔŋ i mbɛiŋ a, tikwili wi bi yaksi wi a wi tɔkniki bəh biɛiŋ bi bichi. ");
INSERT INTO cug_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ayakalə, waiŋ wi nɔm wiwɔ kabə num wi kaŋa nɔni kichu, ka dza dzaka i gwu yi a, ‘Tikwili wuŋ ni kɔmsi fiəni dzə kə’, ");
INSERT INTO cug_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ka yisi i twɛiŋki bwa bə nɔm bədɔkɔ bə̀ bəh bɔ nɔmki, wi dzi a dzini chu mu bəh bəni bə̀ bɔ məki mbih məni, ");
INSERT INTO cug_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","tikwili wi waiŋ wi nɔm wiwɔ bi təkəli tumbuku i chɔkɔ biə wi si kwakaki kə bəh i jɔbi wə wi si kiəki kə. ");
INSERT INTO cug_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ayaka i jɔbi wiwɔ wə wi bi nya ŋgəkə i waiŋ wi nɔm wiwɔ, wi bi chiŋsi wi i tsə numki bəh mbaŋ wi bəni bə̀ bɔ dzakaki chi fə chi, a num i di biə bəni bi dəki dzi jəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“I jɔbi wiwɔ wə bə bi siniki ŋkuŋ bi bɛiŋ bəh kishu ki bəkaŋa bədɔkɔ jwɔfi bə̀ bɔ nì dzɔ bimbaiŋsi bibɔ, buku tsə i wɔkɔliki mi wə wi dzɔ miŋkpaŋa wimfiaŋ. ");
INSERT INTO cug_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Bɔ nì kɔ yakadəiŋ, bəte num biyuŋ, bəte fifi. ");
INSERT INTO cug_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yi num a, bə̀ bɔ nì kɔ biyuŋ dzɔ bimbaiŋsi bibɔ nəki dzɔ kə miə midɔkɔ, ");
INSERT INTO cug_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ayakalə bə̀ bɔ nì fifiki dzɔ bimbaiŋsi bibɔ, dzɔ tasi bəh miə midɔkɔ i bənsɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Si bɔ tsə ka wɔkɔliki mi wə wi dzɔ miŋkpaŋa wimfiaŋ , wi bə́ ndɔmi i dzə, kinu ka yisi i jiŋki bɔ bəchi, bɔ ka gbɔ kinu. ");
INSERT INTO cug_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Aka numki nchɔkɔ kintəəŋ, bɔ wɔkɔ si mi yɔŋsiki lə, ‘Lilili, mbɛiŋ tsɛ̂iŋ, mi wə wi dzɔ miŋkpaŋa wimfiaŋ bə wi lə ɔɔɔ. Mbɛiŋ bûku dzə̂ dzɔ̂ wi ɔɔɔ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ayaka kishu ki bəkaŋa bəwɔ bəchi ka dza bɛiŋ, yaksi naka bibɔ bi baiŋsini. ");
INSERT INTO cug_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bə̀ bɔ nì kɔ biyuŋ ka dzaka i bə̀ bɔ ni fifiki a, ‘Mbɛiŋ nyâ buku bəh miə mimbɛiŋ midɔkɔ, kɔm bimbaiŋsi bi buku si shi tsə lə.’ ");
INSERT INTO cug_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ayakalə, bəfifini bə̀ ka chukuli a, ‘Miə mibuku mɔŋ dəkə i kpɛiŋ i bukumbɛiŋ bəchi. Mbɛiŋ tsə̂ num i bəni bə̀ bɔ taŋniki, mbɛiŋ tâŋ mimbɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Asi bɔ nì tsə i taŋ, mi wiwɔ baaŋ dzə, bəkaŋa bə̀ bɔ nì kɛiŋsi gwu, ka liə bəh wi i juŋ yi dzɔni miŋkpaŋa, bə ka fah dzaka ki juŋ. ");
INSERT INTO cug_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Si yəmaka nì tsə bədɔkɔ bə̀ bɔ ni tsə i taŋ mibɔ miə bɔŋ tsə dzəh, ka dzakaki a, ‘Tikwili tikwili, wɛ̂li dzaka ki juŋ ma buku liə.’ ");
INSERT INTO cug_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ayakalə, wi chukuli i bɔ a, ‘Mih fukuki ŋkɔŋ i mbɛiŋ a, mih kiəki kə mbɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yi kɔ a, mbɛiŋ kɛ̂iŋsi gwu yimbɛiŋ, i wɔkɔliki, kɔm mbɛiŋ kiəki kə chɔkɔ, nabə jɔbi wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","I jɔbi wiwɔ wə, yi bi numki aka mi wə wi nì tsəki nyani, wi bɔɔŋ bwa bu bə nɔm ka nya jiə kpɔ wi i bɔ kaŋ. ");
INSERT INTO cug_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wi nya waiŋ wi wi nɔm widɔkɔ bəh biba bi kpɔ bite, nya widɔkɔ bəh biba bifa, ka nya widɔkɔ bəh kiba ki kpɔ kimu. Wi nì nyaki biəli asi ŋga bi mi kɔ. Si wi nya yakadəiŋ, ka tsə nnyani wi. ");
INSERT INTO cug_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Waiŋ wi nɔm wə wi nì dzɔ biba bi kpɔ bite ka tsə akisəkə ka fəki shi yɛiŋ, dzi mbee biba bite. ");
INSERT INTO cug_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ayaka wə wi nì dzɔ biba bifa ka fə tə shi yɛiŋ, dzi mbee biba bifa. ");
INSERT INTO cug_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ayakalə, waiŋ wi nɔm wə wi nì dzɔ kiba kimu tsə mfih chum dzəŋə nyumi kpɔ wi tikwili wiwɔ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tikwili wi bwa bə nɔm bə̀ wi nì tsə nyani yaka ka tsə baaŋ fɛiŋ i jɔbi wi dəəŋ wə. Wi bɔɔŋ bwa bu bə nɔm a bəh bɔ sîsi gia. ");
INSERT INTO cug_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Waiŋ wi nɔm wə wi nì dzɔ biba bi kpɔ bite ka dzə bəh biba jwɔfi, ka dzaka i wi a, ‘Tikwili, wɔ nì nya mih biba bi kpɔ bite. Yɛ̂iŋ, mih nì baaŋ ka fəki shi bəh wi, kwati biba bidɔkɔ bite i yɛiŋ bɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ayaka tikwili wiwɔ dzaka i wi a, ‘Wɔ fə bindzɔŋ. Wɔ kɔ waiŋ wi nɔm wi ndzɔŋni, bəh wi ŋkɔŋ! Wɔ nì baaŋ ka kiə i tɔkni bəh fiɛŋ fi nchiŋ na bindzɔŋ. Ayakadəiŋ, i liə mih ni jiə lə wɔ a wɔ tɔkniki num bəh biɛiŋ biduli. Lîə la i kintəəŋ kindzɔŋni bi tikwili wa wə.’ ");
INSERT INTO cug_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Waiŋ wi nɔm wə ŋ'wi kpɔ nì kɔ biba bifa dzə tə, ka dzaka i wi a, ‘Tikwili, wɔ nì nya mih biba bi kpɔ bifa. Yɛ̂iŋ, mih baaŋ ka fəki shi bəh wi, ka kwati biba bi kpɔ bidɔkɔ bifa i yɛiŋ bɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ayaka tikwili wiwɔ dzaka i wi a, ‘Wɔ fə bindzɔŋ. Wɔ kɔ waiŋ wi nɔm wi ndzɔŋni bəh wi ŋkɔŋ! Wɔ nì baaŋ ka kiə i tɔkni bəh fiɛŋ fi nchiŋ na bindzɔŋ. Ayakadəiŋ, i liə mih ni jiə lə wɔ a wɔ tɔkniki num bəh biɛiŋ biduli. Lîə la i kintəəŋ kindzɔŋni bi tikwili wa wə.’ ");
INSERT INTO cug_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Waiŋ wi nɔm widɔkɔ wə wi nì dzɔ kiba ki kpɔ kimu dzə tə, ka dzaka i wi a, ‘Tikwili, mih kiəki lə a wɔ kɔ mi wi ləkəli. Wɔ si kɔh lə maka wɔ gbɛli, juŋni gəŋ maka wɔ mu. ");
INSERT INTO cug_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ayakadəiŋ, mih nì baaŋ ka lwaki, ka tsə nyumi kpɔ wa wiwɔ i kuku. Tsɛiŋ, bə kpɔ wa wiwɔ lə, kaŋa.’ ");
INSERT INTO cug_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tikwili wi chukuli i wi a, ‘Wɔ kɔ waiŋ wi nɔm wichu, wɔ chu num bəh kiŋkpəŋ! Wɔ nì kiəki yaka a mih si kɔh lə maka mih gbɛli, juŋni gəŋ maka mih mu. ");
INSERT INTO cug_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Si wɔ nì kiəki yakadəiŋ a fə nə, a wɔ ma tsə jiə kpɔ wuŋ i juŋ yi kpɔ wə ka mih ni fiəni dzə dzɔ kpɔ wuŋ bəh mbee i yɛiŋ bɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Si wi dzaka yakadəiŋ, ka dzaka a bə dzɔ̂ kiba ki kpɔ kiwɔ i wi, bə nyâ i wə wi kaŋaki biba bi kpɔ jwɔfi. ");
INSERT INTO cug_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mbɛiŋ kîəki a, mi wə wi kaŋaki bə ni kpɛiŋsiki lə ma wi kaŋaki biduli. Ayakalə, mi wə wi kaŋaki kə, na fi twɛsi fiə wi kaŋaki bə bi dzɔ bwili lə fi i wi. ");
INSERT INTO cug_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Si wi dzaka yakadəiŋ ka dzaka a, ‘Mbɛiŋ lɔ̂ɔ bwîli waiŋ wi nɔm wi kilɔlɔ wiwɔ i biŋ bi jisi wə, i di biə bəni bi dəki dzi jəŋ.’ ");
INSERT INTO cug_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","A bi numki i jɔbi wə mi wə yɛli wi kɔ Waiŋmi bi fiəni dzəki i mbum bi wə, wi bi dzəki bəh bəchinda bə Nyɔ bəchi, wi bi ka num i kiŋgbɔkɔ ki kimbum wə. ");
INSERT INTO cug_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Bitumi bichi biə bi kɔ fa kuku bi juŋni lə i wi nshiŋ, wi bi ka gaali bɔ asi mi wə wi si tɔkni bəh shwáŋ si gaali bwili shwáŋ i bíi kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Wi bi jiə shwáŋ yiwɔ i tsɛiŋ yi yiləkəli wə, wi jiə bíi i tsɛiŋ yi yi kimiəkə wə. ");
INSERT INTO cug_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wi wə wi kɔ Ŋkuŋ ni ka dzaka i bə̀ bɔ kɔ i tsɛiŋ yi yiləkəli wə a, ‘Bəni bə̀ Ba wuŋ kɔ wi bɔiŋsi bɔ, mbɛiŋ dzə̂ kwâti di i ŋkuŋ biə wi nì kɛiŋsi jiə i mbɛiŋ i yisi si bə nì maa mbi, ");
INSERT INTO cug_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","kɔm dzɔŋ nì wɔɔki lə mih, mbɛiŋ nya mih bəh fiɛŋ fidzini. Kindɔŋ nì wɔmki lə mih, mbɛiŋ nya mih bəh fiɛŋ mih mu. Mih nì kɔ mi wi dzəni, mbɛiŋ dzɔ mih. ");
INSERT INTO cug_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mih nì kɔ bəh chwɔŋ kiyəə, ayaka mbɛiŋ lɔh mbuŋ i mih wə. Mih ni gwɛiŋki lə mbɛiŋ dzə bɔni i mih. Mih nì kɔ i juŋ yi nsəŋ mə, ayaka mbɛiŋ dzə bɔni i mih.’ ");
INSERT INTO cug_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jɔbi wə wi ni dzaka yakadəiŋ, bəni bə chəŋ bə̀ ka ni bikə i wi a, ‘Bah, akɔ i jɔbi winaiŋ wə buku nì dzə yɛiŋ wɔ dzɔŋ wɔɔ wɔ, buku nya wɔ bəh fiɛŋ wɔ dzi, nabə yə a kindɔŋ nì wɔɔmki wɔ, buku nya wɔ bəh fiɛŋ wɔ mu a? ");
INSERT INTO cug_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A nì kɔ i jɔbi winaiŋ wə buku nì yɛiŋ wɔ, wɔ num mi wi dzəni, buku dzɔ wɔ, nabə yə a wɔ nì chu kɔ bəh chwɔŋ kiyəə, buku lɔh mbuŋ i wɔ wə a? ");
INSERT INTO cug_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A nì kɔ jɔbi winaiŋ wə buku nì yɛiŋ wɔ, wɔ gwɛiŋ chu num i juŋ yi nsəŋ mə, buku dzə jikə wɔ a?’ ");
INSERT INTO cug_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ŋkuŋ wiwɔ ka ni chukuli i bɔ a, ‘Mih fukuki ŋkɔŋ i mbɛiŋ a, si mbɛiŋ nì fə gia yələ, i na winaiŋ mi winchiŋ i bwa bə nih bəŋ bələ, yi kɔ a mbɛiŋ nì fə num i mih.’ ");
INSERT INTO cug_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ayakadəiŋ, wi ka bi dzaka i bə̀ bɔ kɔ i tsɛiŋ yi yi kimiəkə wə a, ‘Mbɛiŋ bə̀ mbɛiŋ kɔ num lɔiŋ kwa mbɛiŋ, mbɛiŋ dzâ nyə̂ i mih nshiŋ, mbɛiŋ tsə̂ lîə i gbuku wə bə nì kɛiŋsi jiə i ŋkpɛli bəh bəchinda bu, ");
INSERT INTO cug_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","kɔm dzɔŋ nì wɔɔki lə mih, mbɛiŋ na nya mih bəh fiɛŋ i dzi. Kindɔŋ nì wɔmki lə mih, mbɛiŋ na nya mih bəh fiɛŋ i mu. ");
INSERT INTO cug_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mih nì kɔ mi wi dzəni, mbɛiŋ na dzɔ mih. Mih nì kɔ chwɔŋ kiyəə, mbɛiŋ na lɔh mbuŋ i mih wə. Mih nì gwɛiŋki lə, ayaka chu num i juŋ yi nsəŋ mə, mbɛiŋ na dzə i bɔni mih.’ ");
INSERT INTO cug_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Bɔ tə bi ka bɔŋ bikə i wi a, ‘Bah, akɔ i jɔbi winaiŋ wə buku nì yɛiŋ wɔ dzɔŋ wɔɔ wɔ, nabə a kindɔŋ nì wɔɔmki wɔ, nabə a wɔ num mi wi dzəni, nabə a wɔ chu num chwɔŋ kiyəə, nabə yə a wɔ gwɛiŋ, bəh yə a wɔ chu num i juŋ yi nsəŋ mə, buku na gamti wɔ a?’ ");
INSERT INTO cug_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wi bi ka chukuli i bɔ a, ‘Mih fukuki ŋkɔŋ i mbɛiŋ a, si mbɛiŋ nì ka fə dəkə gia yələ, i na winaiŋ mi winchiŋ i bwa bə nih bəŋ bələ, yi kɔ a mbɛiŋ nì ka fə dəkə num i mih.’ ");
INSERT INTO cug_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Bəmaka bəni bi ka dza nyə tsə liə num i ŋgəkə wə wi bi tsə kaa kə. Ayakalə, bə chəŋ bə̀ tsə liə fibɔ num i nɔni kə ki bi tsə kaa kə.” ");
INSERT INTO cug_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jɔbi wə Jisɔs nì dzaka kaasi gia yələ yichi, ka dzaka i bwa bu bə mbaŋ a, ");
INSERT INTO cug_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mbɛiŋ kîə a, a baaŋ a kaŋ yifa ka dzini bi Ntsədaŋ yisi, bə num i ni nya mi wə yɛli wi kɔ Waiŋmi i bəni kaŋ ma bɔ baŋŋ wi i kintasi wə.” ");
INSERT INTO cug_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","A i jɔbi wiwɔ wə, bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi tsə ka juŋni gwu yibɔ i ntɔŋ wi Kayfas wə a num wi Kayfas wiwɔ fwu wi bətii mfə gia, ");
INSERT INTO cug_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","bɔ ka jiə kimfasi i ni wɛli kwa Jisɔs, i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Si bɔ fasiki yakadəiŋ, ka dzaka a, “Bukumbɛiŋ ma mɔ̂m i fə̂ gia yələ i jɔbi wi Dzini wə, kɔm bukumbɛiŋ ka mɔm yi, ma yi ni dzə bəh ŋgəkə i bəni kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jɔbi wə Jisɔs nì kɔ i kwili wi Bɛtani wə, i juŋ yi Samɔn wə mi wi kiŋkumi. ");
INSERT INTO cug_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jɔbi wə bɔ nì shi num ka dziki, miŋkpaŋa widɔkɔ liə dzə bəh finsɔkɔ fi fiaŋsi fidɔkɔ num bə kɛiŋsi bi bəh təh, a num fi fiaŋsi bi tsɛŋə yindzɔŋni, bi ləkə i kpɔ wə nalə, ka shuku i fwu wi Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bwa bə Jisɔs bə mbaŋ nì yɛiŋ yakadəiŋ gia yiwɔ fə bɔ bɔksi lɔ tɔɔ. Bɔ ka dzakayiki a, “Wi bəkəli fiaŋsi biələ lə kɔm nə a? ");
INSERT INTO cug_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Bə si kɔlə i taŋni fiaŋsi biələ i kpɔ widuli wə, i nya kpɔ wiwɔ i bəni bə kifuu.” ");
INSERT INTO cug_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ayakalə, Jisɔs kiə kiŋkwaka kibɔ, ka dzaka i bɔ a, “Mbɛiŋ nyaki ŋgəkə i miŋkpaŋa wələ kɔm nə? Wi fə num gia yindzɔŋni i mih. ");
INSERT INTO cug_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mbɛiŋ kîəki a bəni bə kifuu ni numki lə bəh mbɛiŋ jɔbi wichi ayakalə, mih bi numki kə bukumbɛiŋ i jɔbi wichi wə. ");
INSERT INTO cug_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wi shuku fiaŋsi biələ i gwu yiŋ wə lə, wi kɛiŋsi mih num kɛiŋsini i nləə wə. ");
INSERT INTO cug_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mih fukuki ŋkɔŋ i mbɛiŋ a, na faiŋ bə bi fukuki ntum wi ndzɔŋni wələ i mbi wichi wə, gia yələ miŋkpaŋa wələ fə, bə bi fukuki yi, bə kwaka wi.” ");
INSERT INTO cug_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mi widɔkɔ i mbaŋ wi bwa bə Jisɔs wə, i bə̀ wə jwɔfi ntsɔ bəfa kintəəŋ, a num wə bə nì bɔɔŋki a Judas Iskaliɔt nyə tsə yɛiŋ bətii mfə gia bəmbum, ");
INSERT INTO cug_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka bikə i bɔ a, “Mih ka nya Jisɔs i mbɛiŋ kaŋ, ma mbɛiŋ ni nya nə i mih a?” Bɔ ka fa kpɔ mbaŋtia num bə nì kɛiŋsi wi bəh chwaka ki kpɔ kifukuli, ka nya i wi. ");
INSERT INTO cug_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","I yisi jɔbi wiwɔ wə, wi ka yisi i nəŋki dzəh yə wi ni nya Jisɔs yɛiŋ i bɔ kaŋ. ");
INSERT INTO cug_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","A dzə num i chɔkɔ bi ninshiŋ i Dzini bi Blɛd wə bə ka jiə dəkə Dzɔŋɔ yɛiŋ, bwa bə mbaŋ bə Jisɔs dzə yɛiŋ wi, ka bikə i wi a, “Wɔ nəŋki a buku tsə kɛiŋsi faiŋ di biə wɔ ni dzi Dzini bi Ntsədaŋ yɛiŋ na?” ");
INSERT INTO cug_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Wi chukuli i bɔ a, “Mbɛiŋ tsə̂ i kwili kintəəŋ, mbɛiŋ ni yɛiŋ lə nchiŋ mi widɔkɔ fɛiŋ, mbɛiŋ dzâka i wi a, ‘Mi wi Lanini dzaka a, jɔbi wi ŋgaiŋ kpɛiŋ lɔ. Ŋgaiŋ bəh bwa bu bə mbaŋ kaŋaki i dzi Dzini bi Ntsədaŋ i wi dzu.’” ");
INSERT INTO cug_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ayaka bwa bə mbaŋ bə̀ tsə fə asi Jisɔs si dzaka i bɔ, ka kɛiŋsi biɛiŋ bidzini bi Dzini bi Ntsədaŋ biwɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A dzə num i fijɔbi, wi shinum bəh bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa i dziki. ");
INSERT INTO cug_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jɔbi wə bɔ nì dziki, wi dza dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mi widɔkɔ i mbɛiŋ kintəəŋ ni taŋni lə mih.” ");
INSERT INTO cug_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Si wi dzaka yakadəiŋ, bwa bu bə mbaŋ dza ka numki a bəh nshɛiŋ nshɛiŋ, yisi i bikəki a wimu wimu a, “Akɔ num mih ma Bah?” ");
INSERT INTO cug_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wi chukuli i bɔ a, “Mi wə wi ni taŋni mih akɔ wə wi ləkə kaŋ i fwɔti wə buku wi. ");
INSERT INTO cug_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Mi wə yɛli wi kɔ Waiŋmi kaŋaki bi nyə asi bə nì nyaka kɔm wi. Ayakalə, ŋgəkə wimbum kɔ i mi wə wi taŋni Mi wə yɛli wi kɔ Waiŋmi. Yi nì ndzɔŋki a bə ma bwɔ wəmaka mi.” ");
INSERT INTO cug_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas wə wi ni kaŋaki i taŋni Jisɔs bɔŋ bikə tə i wi a, “Mi wi Lanini akɔ num mih ma?” Jisɔs chukuli i wi a, “Wɔ dzaka bəh dzaka ka.” ");
INSERT INTO cug_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Asi bɔ nì dziki, Jisɔs dza dzɔ blɛd, nya kiyɔŋni i Nyɔ, gbɛyi nya i bwa bu bə mbaŋ ka dzaka a, “Mbɛiŋ kɔ̂ dzî, fa kɔ gwu yiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wi dzɔ tə bwam, nya kiyɔŋni i Nyɔ ka nya bwam wiwɔ i bɔ ka dzaka a, “Mbɛiŋ bəchi mû. ");
INSERT INTO cug_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mələ kɔ mwa məŋŋ mə Nyɔ dzi miŋkaiŋ bəh mɔ, mɔ shukuki bukuki kɔm bəni bəduli, ka wi ni dalinya chu bibɔ. ");
INSERT INTO cug_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mih fukuki i mbɛiŋ a, mih ni chu mu kə mbi mi kpɛiŋ wi lani wələ i yisi i liə i tsə buku i chɔkɔ biə mih bi muki mɔ mimfiaŋ bukumbɛiŋ i kintəəŋ ki ŋkuŋ bi Ba wuŋ wə.” ");
INSERT INTO cug_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jɔbi wə Jisɔs bəh bwa bu bə mbaŋ kaasi, bɔ yəəŋ njaŋ wi kɔksini, buku ka yaka tsə i Ŋkwuŋ wi Kɛiŋ yi Ɔlif wə. ");
INSERT INTO cug_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Si Jisɔs bəh bwa bu bə mbaŋ nì tsəki, wi dzaka i bɔ a, “Daiŋ nchɔkɔ mbɛiŋ bəchi ni fiəni gɛiŋ chu lə i jum wə kɔm gia yə yi ni num bəh mih. Yi num asi bə nyaka a, Nyɔ dzakaki a, ‘Mih ni wɔɔ lə ntɔkni shwáŋ, ma mbaŋ wi shwáŋ yiwɔ ni gaali.’ ");
INSERT INTO cug_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ayakalə, jɔbi wə Nyɔ bi bwili mih i kpi wə, mih bi tsə i mbɛiŋ nshiŋ i Galili.” ");
INSERT INTO cug_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bita ka dzaka lɔ mfih i wi a, “Kɔŋ bəni bəchi ni gɛiŋ fiəni chu i jum wə kɔm gia yə yi ni num bəh wɔ, mih kɔkə ni lansi gɛiŋ chu i jum wə.” ");
INSERT INTO cug_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisɔs fiəni chukuli i wi a, “Mih fukuki ŋkɔŋ i wɔ a daiŋ nchɔkɔ, ka kwɔkɔ ni tɔŋki, num wɔ nəiŋ lɔ mih kiŋkani kitali.” ");
INSERT INTO cug_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bita dzaka i wi a, “Kɔŋ mih ni numki i kpi bəh wɔ, mih kɔkə ni lansi nəiŋ wɔ.” Si wi dzaka yakadəiŋ, bwa bə mbaŋ bə Jisɔs bədɔkɔ bə̀ bəchi bɔŋ dzaka ayaka tə. ");
INSERT INTO cug_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisɔs bəh bwa bu bə mbaŋ tsə liə i khə wi kɛiŋ yi mintam midɔkɔ wə, bə bɔɔŋ a Gɛsɛmane, Jisɔs dzaka i bwa bu bə mbaŋ a, “Mbɛiŋ shînumyi fa mih kini tsə tsa.” ");
INSERT INTO cug_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wi dzɔ Bita bəh bwa bə Sɛbide bəfa, bəh bɔ ka tsə. Wi yisi i numki bəh nshɛiŋ nshɛiŋ, shɔm yi fumsi wi. ");
INSERT INTO cug_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Wi ka dzaka i bɔ a, “Shɔm yiŋ kɔ a bəh nshɛiŋ nshɛiŋ nalə na ka mih kpi num kpini. Mbɛiŋ bâaŋ a fa bukumbɛiŋ wɔ̂kɔliki.” ");
INSERT INTO cug_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Si wi dzaka yakadəiŋ, ka kini tsə i ninshiŋ, gbɔ tum kwusi shi bi i kuku ka bə́ tsa a, “Ba wuŋ, dzəh kabə nûm yə wɔ kɔ i fə ka bwam wi ŋgəkə wələ tsə mih a mih ma mu, wɔ fə̂. Ayakalə, ma fə̂ si mih nəŋki. Fə̂ yi num asi wɔ nəŋki.” ");
INSERT INTO cug_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wi fiəni dzə buku i bɔ wə, ka ti bɔ nɔ wə. Wi bikə i Bita a, “Yaka mbɛiŋ kɔkə i num bɛiŋ bəh mih i tsə buku i mbiəŋə wimu wə a? ");
INSERT INTO cug_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mbɛiŋ tsə̂ŋəki, mbɛiŋ tsâ a kiə kimɔmsi ki dzə kə i mbɛiŋ wə. Yi kɔ ŋkɔŋ a shɔm kɔŋki lə, ayakalə nyam yi gwu bɔhyi.” ");
INSERT INTO cug_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wi fiəni tsə fɛiŋ i kiŋkani kifa wə ka tsa a, “Ba wuŋ, aka bə́ num a bwam wələ kɔkə i tsə maka mih mu wi, wɔ fə̂ asi wɔ nəŋki.” ");
INSERT INTO cug_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Si wi ni fiəni dzə, ka chu ti bwa bu bə mbaŋ nɔ wə kɔm kinu nì kɔ i dzəkəh yibɔ wə nalə. ");
INSERT INTO cug_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wi fiəni bee bɔ ka tsə i tsaki i kiŋkani kitali wə, wi tsa, dzaka num a gia yə wi si kɔ wi dzaka lɔ yi. ");
INSERT INTO cug_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wi chu fiəni dzə i bwa bu bə mbaŋ dzaka i bɔ a, “Mbɛiŋ kɛiŋki mbɛiŋ nɔ waka fimbɛiŋ na? Mbɛiŋ tsɛ̂iŋ, jɔbi kpɛiŋ lɔ. Bə taŋni lɔ mi wə yɛli wi kɔ Waiŋmi i kaŋ yi bəni bəchu wə. ");
INSERT INTO cug_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mbɛiŋ dzâ bɛiŋ bukumbɛiŋ tsə̂ki. Mbɛiŋ tsɛ̂iŋ, mi wə wi taŋni mih bə wi yaka wi dzəki.” ");
INSERT INTO cug_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Asi Jisɔs nì kɛiŋki wi dzaka, Judas wə wi nì kɔ mi i mbaŋ wi bwa bə Jisɔs bə̀ jwɔfi ntsɔ bəfa dzə tumbuku. Wi nì dzəki bəh mbaŋ wi bəni bəduli, bɔ kaŋa bənywɔ bəh bibɔkɔ, num a faaŋ bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi. ");
INSERT INTO cug_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A nì kɔ num mi wə wi taŋni Jisɔs, tsə kɛiŋsi lɔ kinchəsi bəh bəni bəwɔ ka dzaka a, “Mi wə mih ni bɔni mih maŋni yaŋyi, akɔ wi mbɛiŋ ni kwâ.” ");
INSERT INTO cug_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Si bəh bɔ ni dzə, wi chəm tsə a chəŋ i Jisɔs wə ka bɔni i wi, “Mih bɔniki i wɔ Mi Lanini.” Si wi bɔni yakadəiŋ, ka maŋni wi bə́ yaŋyi wi. ");
INSERT INTO cug_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jisɔs ka dzaka i wi a, “Nsɛiŋ wuŋ, fə̂ a gia yə wɔ dzə i fə.” Ayaka bəni bəwɔ ka tsə kwa Jisɔs, kaŋa wi. ");
INSERT INTO cug_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yi num a mi widɔkɔ wə wi nì kɔ bɔ bəh Jisɔs ka guku baa nywɔ wi jum ka gba chwiŋ təiŋ kintuni ki mfa wi fwu wi bətii mfə gia. ");
INSERT INTO cug_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jisɔs dzaka i mi wiwɔ a, “Fîəni lə̂kə nywɔ wa i di biə wi si kɔ. Na ndə wə wi dzasi nywɔ i bɛiŋ wi kîəki a, wi bi kpiki i nywɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wɔ kwakaki a mih kɔkə i bɔɔŋ Ba wuŋ a wi chiŋsi bəchinda bu bənchuku bɔ tsə bəmbaŋ jwɔfi ntsɔ bəfa akisəkə a? ");
INSERT INTO cug_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ayakalə, mih ka fə yakadəiŋ, ma yi ni nyani dəiŋ ka yi dzə kpɛiŋ asi bə nyaka i Kiŋwakti ki Nyɔ wə a, a yi kaŋaki i bi num a?” ");
INSERT INTO cug_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","I fɛiŋ wə, Jisɔs ka bikə i mbaŋ wiwɔ a, “Mbɛiŋ dzə i kwa mih, ka dzəki bəh bənywɔ bəh bibɔkɔ ka mbɛiŋ dzəki i kwa num ji a? Mih nì shi kɔ bəh mbɛiŋ chɔksi chɔksi i juŋ yi fəni yi gia mə lani bəni mbɛiŋ kwa kə mih kɔm nə la? ");
INSERT INTO cug_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ayakalə, gia yələ yichi num i fə a yi dzə kpɛiŋ asi bəni bə ntum bə Nyɔ nì nyaka.” Bwa bə Jisɔs bə mbaŋ bəchi ka lɔtɔkɔ wi fɛiŋ, yɔkɔ gɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Bəni bə̀ bɔ nì kwa Jisɔs ka dzɔ tsə bəh wi i Kayfas dzu fwu wi bətii mfə gia. A nì kɔ num bəni bə̀ bɔ nì laniki bənchi bə Nyɔ bəh bə̀ bɔ nì sakaki tumi nì juŋni. ");
INSERT INTO cug_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bɔ nì tsəki bəh Jisɔs Bita biəli i jum wə i dzəh yi dəəŋ. Wi ka tsə buku na i fitɔkɔ wi fwu wi bətii mfə gia wə, ka liə tsə num bəh bəni bə̀ bɔ nì tɔkniki bəh di biwɔ, wi tsɛiŋ, i yɛiŋ si yi ni nyani num. ");
INSERT INTO cug_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bətii mfə gia bəmbum bəh bəni bəchi bə̀ bɔ nì sakaki bənsaka ka nəŋki gia yi ntəkə yə bɔ kɔ i jiə i Jisɔs fuŋ ka bɔ ni wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ayakalə, bɔ nəki kwati kə gia yidɔkɔ, na ayaka si bəni bəduli ni bukuki dzəki i ninshiŋ beeŋ nsaka bəntəkə. Gia yiwɔ nyani lə, i kiŋgɔksi wə bəni bədɔkɔ bəfa buku dzə num i ninshiŋ, ");
INSERT INTO cug_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ka dzakaki a, “Mbwə wələ nì dzaka a, ŋgaiŋ kɔlə i shakyi juŋ yi fəni yi gia yi Nyɔ i fiəni maa yi i kaŋ yitali wə.” ");
INSERT INTO cug_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Fwu wi bətii mfə gia wiwɔ ka dza bɛiŋ bikə i Jisɔs a, “Yaka wɔ kaŋaki kə gia yidɔkɔ i chukuli a? Wɔ wɔkɔ alə gia yə bəni bələ dzakaki i wɔ wə a?” ");
INSERT INTO cug_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jisɔs kpichumi mɔŋ. Fwu wi bətii mfə gia wiwɔ fiəni dzaka i wi a, “I yɛli wi Nyɔ wə wi kaŋaki nɔni, wɔ fa kabə num Kimbwili wə Nyɔ nì kaka, wə Waiŋ Nyɔ, fûku i buku.” ");
INSERT INTO cug_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisɔs chukuli a, “Yi kɔ asi wɔ dzaka. Ayakalə, mih fukuki i mbɛiŋ a, jɔbi wələ ni tsə mbɛiŋ ni yɛiŋ lə mi wə yɛli wi kɔ Waiŋmi, num wi shinum i tsɛiŋ yiləkəli yi Mi wə wi kaŋaki ŋga, mbɛiŋ bi chu yɛiŋ si wi dzəki i bikwu wə i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Fwu wi bətii mfə gia wə wɔkɔ yakadəiŋ, ka taŋyi bəmbuŋ i gwu yi wə, dzaka a, “Wi dzɔki di bi Nyɔ. Bukumbɛiŋ nəŋki a mi widɔkɔ chu dzə dzaka gia yidɔkɔ a? Mbɛiŋ wɔkɔ lɔ si wi dzɔki di bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mbɛiŋ kwakaki a nə?” Bɔ chukuli a, “Akɔ mi wə bə kaŋa i wɔ̂ɔ wi num wɔɔni.” ");
INSERT INTO cug_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Bɔ yisi i chuhyiki mindzəŋ i shi bi wə chɔkɔ twɛiŋ wi bəh biŋkɔɔ, bədɔkɔ twɛiŋ bəh kaŋ, dzakaki i wi a, ");
INSERT INTO cug_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Wɔ wə wɔ kɔ Mbwili wə Nyɔ nì kaka, fûku la ntum wi Nyɔ wa wə i liə. Kaŋsi i buku mi wə wi twɛiŋ wɔ.” ");
INSERT INTO cug_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","A nì kɔ Bita num i kuku i biŋ i fitɔkɔ. Waiŋ kpaŋni widɔkɔ wə wi nì nɔmki fɛiŋ, dzə kɔmsi i wi kpəŋ ka dzaka i wi a, “Wɔ tə si kɔ mbɛiŋ Jisɔs wi Galili.” ");
INSERT INTO cug_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ayakalə, Bita nəiŋ i bəni bəchi nshiŋ ka dzaka a, “Mih kiəki kə gia yə wɔ dzakaki.” ");
INSERT INTO cug_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bita ka buku tsə ka numki bɛiŋ i dzaka ki mbaiŋ wə. Waiŋkpaŋni widɔkɔ wə wi nì nɔmki tə fɛiŋ, yɛiŋ wi, ka dzaka i bəni bə̀ bɔ nì numyi i bɛiŋ fɛiŋ a “Mi wələ si kɔlə bəh Jisɔs wi Nasali.” ");
INSERT INTO cug_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Bita chu nəiŋ ka kaiŋ, dzaka a, “Mih kîəki kə mi wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","I jɔbi wi twɛsi wə, bəni bə̀ bɔ nì numyi kɔmsi tsə i Bita wə ka dzaka i wi a, “I yi ŋkɔŋ wə, wɔ kɔ tə mi wibɔ, kɔm ndzaka wa tsəki aka wibɔ.” ");
INSERT INTO cug_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ayaka Bita ka kaiŋ, bɔɔŋ num lɔiŋ i fwu wi wə dzaka a, “Mih kiəki kə mi wələ.” Akisəkə kwɔkɔ ka tɔŋ. ");
INSERT INTO cug_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bita kwaka ndzaka wə Jisɔs si dzaka i wi a, “Ka kwɔkɔ ni nəŋki i tɔŋki, num wɔ nəiŋ lɔ mih kiŋkani kitali.” Wi nyə fɛiŋ buku tsə i biŋ, ka də nalə. ");
INSERT INTO cug_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Asi chɔkɔ nì wɔɔki dzəki, bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi, num jiə ja kɔm Jisɔs, i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Bɔ ka kaŋa wi, dzɔ tsə nya i kaŋ yi Baylɛ wə mi wi nsaka i kimbu kiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jɔbi wə Judas wə wi nì taŋni Jisɔs nì yɛiŋ a bə təiŋ a bə ki wɔɔki lə Jisɔs, wi bə́ təm, dzɔ kpɔ wə mbaŋtia fiəni tsə nya i bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi. ");
INSERT INTO cug_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Wi tsə, dzaka i bɔ a, “Mih fə chu i taŋni mi wi kaŋa kə ŋgəkə widɔkɔ.” Bɔ chukuli i wi a, “Yəmaka kaŋaki nə i fə bəh buku? A kiəki wɔ yəmaka.” ");
INSERT INTO cug_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas waŋ kpɔ wiwɔ i kuku i juŋ yi fəni yi gia wə, ka buku tsə shiəŋ. ");
INSERT INTO cug_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bətii mfə gia bəmbum fwɔkyi kpɔ wiwɔ dzaka a, “Wələ kɔ kpɔ wi mwa, nchi bumki kə a bə jîə wələ kpɔ i kiba ki juŋ yi fəni yi gia mə.” ");
INSERT INTO cug_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Bɔ num jiə ja, tsə taŋ di i mi wə wi nì mwəmki mishwali bəh wi a bɔ ni ləəki bəni bədzəni fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Akɔ gia yə bə bɔɔŋki di biwɔ i dzə buku bidaiŋ a, “Di bi Mwa.” ");
INSERT INTO cug_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Yi nì num yaka ka gia yə mi wi ntum wi Nyɔ wə Jɛlimia nì dzaka, ka yi dzə kpɛiŋ si wi nì dzaka a, “Bə nì dzɔ kpɔ mbaŋtia num kpɔ wə bwa bə Islae nì sisi i dzɔ i fwu wi wə, ");
INSERT INTO cug_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","taŋ di yɛiŋ i mi wə wi nì mwəmki mishwali bəh wi, asi Bah Nyɔ nì dzaka i mih.” ");
INSERT INTO cug_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Si Jisɔs nì numbɛiŋ i Baylɛ mi wi nsaka nshiŋ, Baylɛ bikə i wi a “Akɔ wɔ Ŋkuŋ wi Bəju wə a?” Jisɔs chukuli a, “Yi kɔ asi wɔ dzaka.” ");
INSERT INTO cug_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ayakalə, bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì sakaki tumi kiwɔ yisi i jiəki gia i wi fuŋ, wi na chu chukuli gia yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Baylɛ ka bikə i wi a, “Wɔ wɔkɔki alə ŋkaiŋni wi gia yə bə dzakaki kɔm wɔ a?” ");
INSERT INTO cug_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ayakalə, Jisɔs na chukuli na gia yimu i wi kɔm yə bɔ nì jiəki i wi fuŋ. Mi wi sakani wiwɔ tsɛiŋ lə dzaka wɔm wi nalə. ");
INSERT INTO cug_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","A nì dzəki numki i jɔbi wi dzini bi Ntsədaŋ wə, mi wi sakani bwili mi wimu i juŋ yi nsəŋ mə, wə bəni kɔŋki a wi bwîli. ");
INSERT INTO cug_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","A nì kɔ i jɔbi wiwɔ wə, mi widɔkɔ num i juŋ yi nsəŋ mə, bə kiə nalə a wi nì fəki lə chu, yɛli wi num a Balabas. ");
INSERT INTO cug_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jɔbi wə bəni nì juŋni, Baylɛ bikə i bɔ a, “Mbɛiŋ kɔŋki a mih bwili num ndə i juŋ yi nsəŋ mə a? Mbɛiŋ kɔŋki a mih bwili yatɔkɔ num Balabas, ma Jisɔs wə bə bɔɔŋki a Kimbwili wə Nyɔ nì kaka a?” ");
INSERT INTO cug_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wi nì bikəki yaka kɔm wi nì kiəki lə a bɔ nì nya Jisɔs i wi, kɔm kindɔŋ nì finiki lə bɔ bəh wi. ");
INSERT INTO cug_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","I chu kpɛiŋ i yi wə, a nì kɔ jɔbi wə wi nì shinum i di biə bə si num i saka bənsaka, kpə wi faaŋ ntum i wi, dzaka a, “Kiə wɔ ki fə̂ kə gia yidɔkɔ bəh mi wə. Akɔ mi wi chəŋ. Mih dzakaki lə kɔm ndəmsi si fumsi mih daiŋ nchɔkɔ nalə kɔm wi.” ");
INSERT INTO cug_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Si Baylɛ bikə yakadəiŋ, bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi nyini bəni a bɔ dzaka a wi bwîli yatɔkɔ num Balabas, ma bə kâasi bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mi wi sakani chu dza bikə i bɔ a, “Mi wə mbɛiŋ kɔŋki a mih bwili yatɔkɔ i bəni bəfa bələ kintəəŋ kɔ winaiŋ?” Bɔ chukuli a, “Balabas.” ");
INSERT INTO cug_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Baylɛ chu bikə i bɔ a, “Mih ka bwili yatɔkɔ yakadəiŋ i liə, mih ni fə dəiŋ bəh Jisɔs wə bə bɔɔŋki a Klistus a?” Bɔ bəchi dzaka a, “Bə bâŋŋ wi num bâŋŋni i kintasi wə.” ");
INSERT INTO cug_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Wi fiəni bikə a, “Bə bâŋŋ wi kɔm nə a? Gia yichu yə wi fə kɔ nə a?” Ayakalə, bɔ chu wili tsə a ninshiŋ lɔ a, “Bə bâŋŋ wi i kintasi wə.” ");
INSERT INTO cug_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jɔbi wə Baylɛ nì yɛiŋ a dzəh kɔkə, ka ŋgaiŋ kaasi gia yələ, dzaka yiŋni dza lɔ dzani. Wi dzɔ mwi, wɔkɔ kaŋ yi yɛiŋ i mbaŋ wi bəni nshiŋ dzaka a, “Kaŋ yiŋ kɔkə i kpi yi mi wələ wə. A kiəki mbɛiŋ i yi wə.” ");
INSERT INTO cug_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Bəni bəchi chukuli i wi a, “Aaŋ, bêe ma mwa mi nûmki i kifwu kibuku wə bəh i bwa bəbuku wə.” ");
INSERT INTO cug_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Baylɛ ka bwili yatɔkɔ Balabas asi bɔ nì kɔŋki, ka nya Jisɔs a bə twɛ̂iŋ bə tsə̂ bâŋŋ i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Bəni bə jum bə mi wi sakani ka dzɔ Jisɔs liə bəh wi i ntɔŋ wə bə nì bɔɔŋki a Blitɔlium, ka juŋni kiŋka ki mbaŋ wi bəni bə jum bəchi bɔ fiəli baŋ wi. ");
INSERT INTO cug_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Bɔ baayi bəmbuŋ bu, dzɔ mbuŋ wi bəŋkuŋ wi bɔkɔli tum i wi wə. ");
INSERT INTO cug_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ka bwaŋ kifɔ ki bəŋkuŋ ki num bə kɛiŋsi bəh bəbwaŋyi, bwaŋ i wi fuŋ, ka nya mbəŋ i tsɛiŋ yi yiləkəli wə a, akɔ mbeŋ wi bəŋkuŋ. Bɔ dzə ŋgwuŋyi i wi nshiŋ nyiksi wi dzakayi a, “Mbɛɛ jum yibɔkɔli! Ŋkuŋ wi Bəju!” ");
INSERT INTO cug_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Si bɔ nì fə yakadəiŋ, ka chuhyiki mindzəŋ i gwu yi wə, dzɔ mbəŋ wə ka twɛiŋki wi yɛiŋ i fuŋ. ");
INSERT INTO cug_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jɔbi wə bɔ nì nyiksi kaasi yakadəiŋ, babwili mbuŋ wi ŋkuŋ wə i gwu yi wə, lɔh num bəmbuŋ bu i gwu yi wə, ka dzɔ tsə bəh wi i baŋŋ i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Si bə nì tsəki, bɔ dzə buku i mi wi Sɛlin widɔkɔ, yɛli wi num a Samɔn. Bɔ kaŋyi mi wiwɔ wi giŋ kintasi ki Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jɔbi wə bɔ nì tsəki bɔ tsə buku i di bidɔkɔ wə, bə bɔɔŋ a Gɔlgɔta, (Yɛli wələ kɔ a Di bi Ŋkuŋu Kifwu), ");
INSERT INTO cug_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","bɔ ka nya mbih i wi num bɔ chwali bəh biəə yi lɔli jiə a wi mû. Ayakalə, si wi mɔm, wi nəiŋma i mu. ");
INSERT INTO cug_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Bɔ ka baŋŋ wi i kintasi wə, dzɔ bəmbuŋ bu tum kaaŋ yɛiŋ i gaa a bɔ bɔ. ");
INSERT INTO cug_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Si bɔ fə yakadəiŋ ka shinum fɛiŋ ka chəniki wi. ");
INSERT INTO cug_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Bɔ nyaka kiŋwakti kə ki nì chusiki gia yə yi fə ka bɔ baŋŋ wi i kintasi wə, ka baŋyi i kintasi wə i fwu wi bɛiŋ yi num a, “Wələ kɔ Jisɔs, Ŋkuŋ wi Bəju.” ");
INSERT INTO cug_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Bɔ baŋŋ tə bəji bəfa i kintasi wə bɔ bəh Jisɔs, widɔkɔ i tsɛiŋ yiləkəli wə, widɔkɔ i tsɛiŋ yi yi kimiəkə wə. ");
INSERT INTO cug_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bəni ka tsəki daŋsiki yɛiŋ Jisɔs nəŋni fwu, bəkəli wi bəh ntɔyi, ");
INSERT INTO cug_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","dzakayi a, “Wɔ wələ wɔ nì kɔ i shakyi juŋ yi fəni yi gia i fiəni maa i kaŋ yitali wə, gâmti gwu ya! Wɔ kabə num Waiŋ Nyɔ, shi dzə i kintasi kiwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bəh bəni bə̀ bɔ sakaki tumi ka nyiksiki tə wi dzakayi a, ");
INSERT INTO cug_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wi nì gamtiki bəni bədɔkɔ i liə wi kɔkə i gamti gwu yi. Ntə wi kɔ Ŋkuŋ wi bəni bə Islae. Wi shî la i kintasi kiwɔ wə i liə ma buku ka ni bum wi. ");
INSERT INTO cug_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wi ni jiə fwu wi i Nyɔ wə. Nyɔ wiwɔ kabə kɔŋ wi, ma wi gamti la wi i liə si wi ni dzakaki a ŋgaiŋ kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Bəji bə̀ bə nì baŋŋ bɔ bəh Jisɔs i kintasi wə, tɔyi wi bəh bəntɔyi tə. ");
INSERT INTO cug_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","A dzə num nshichuŋ biŋ ji, tumi kichi ji i tsə buku i mbiəŋə mitali wə nshi. ");
INSERT INTO cug_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","A dzə num ka mbiəŋə mitali, Jisɔs dza wam bəh ŋga a, “Ɛli, Ɛli, lama sabaktani.” Yi num a, “Nyɔ wuŋ, Nyɔ wuŋ, wɔ lɔtɔkɔ mih lə kɔm nə?” ");
INSERT INTO cug_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bəni bədɔkɔ bə̀ bɔ nì num kɔmsi fɛiŋ wɔkɔ, ka dzaka a, “Mi wiwɔ bɔɔŋki Ɛlaja.” ");
INSERT INTO cug_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mi widɔkɔ i bɔ kintəəŋ ka yɔkɔ akisəkə tsə dzɔ kuncha, juli i mbih migbaŋlini mə, bwaŋ i mbəŋ wə, ka sɔkɔ tsə a wi mu. ");
INSERT INTO cug_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ayakalə, bəni bədɔkɔ dzaka a, “Bə wɔ̂kɔli yɛ̂iŋ a yuwidɔkɔ Ɛlaja kɔlə i dzə gamti wi!” ");
INSERT INTO cug_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisɔs ka chu wam bəh ŋga nya kiŋ'waka ki i Nyɔ kaŋ. ");
INSERT INTO cug_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yi dzə num a, mbuŋ wə bə nì təiŋni juŋ yi fəni yi gia yɛiŋ i fintəŋ, yisi i bɛiŋ taŋa shi buku i kuku i bimbu bifa wə. Nshwaiŋ nəŋni, biaŋa bakayi, ");
INSERT INTO cug_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","júm tə wɛli gwu, bəni bəduli bə̀ bɔ nì kɔ bə Nyɔ num bɔ nì kɔ bɔ kpiyi lɔ fiəni dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jɔbi wə Jisɔs nì dza i kpi wə, bəni bəwɔ nyə tsə i kwili wi baiŋni wə Jɛlusalɛm, bəni bəduli yɛiŋ i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Tikwili wi bəni bə jum wə bəh bəni bə̀ bɔ nì kɔ fɛiŋ chəni Jisɔs, yɛiŋ si nshwaiŋ nəŋniki bəh gia yichi yə yi nì dzɔki di, ndzaŋ kwa bɔ na bəh ŋga. Bɔ ka dzaka a, “I yi ŋkɔŋ wə mi wələ nì kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bəkaŋa bəduli nì kɔlə tə fɛiŋ i dzəh yi dəəŋ bɔ tsɛiŋ. Bəkaŋa bələ kɔ bə̀ bɔ nì buku i Galili biəli Jisɔs gamti wi. ");
INSERT INTO cug_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","I mbaŋ wibɔ wə nì kɔ Meli Magdalen bəh Meli wə nih Jɛm bəh Yɔsɛf, bəh nih bwa bə Sɛbide. ");
INSERT INTO cug_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","A dzə num i fijɔbi, tii kpɔ widɔkɔ a num mi wi Alimatia dzə, yɛli wi num a Yɔsɛf. Wi tə nì kɔ mi widɔkɔ i mbaŋ wi Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wi tsə yɛiŋ Baylɛ tsa a wi nyâ wini wi Jisɔs ka ŋgaiŋ tsə ləə. Baylɛ ka dzaka a bə tsə̂ dzɔ̂ nyâ i wi. ");
INSERT INTO cug_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yɔsɛf dzɔ wini wiwɔ ka kii i mbuŋ wi baiŋni wə, ");
INSERT INTO cug_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ka tsə jiə i jum yi wə, yi kɛiŋ a yimfiaŋ, num wi nì tɔ jum yiwɔ i biaŋa mə, wi ka biŋsi təh wimbum ka baŋ dzaka ki jum kiwɔ yɛiŋ, ka nyə. ");
INSERT INTO cug_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meli Magdalen bəh Meli widɔkɔ wə nì kɔ fɛiŋ, num bɔ shinum i tsɛiŋ daŋsi jum yiwɔ. ");
INSERT INTO cug_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Chɔkɔ buku wɔɔ, num chɔkɔ biə bɔ si sisiki gia yi bimbam bibɔ yɛiŋ bi tsə, bətii mfə gia bəmbum bəh Bəfalasi tsə yɛiŋ Baylɛ, ");
INSERT INTO cug_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","dzaka i wi a, “Tikwili, buku kwakaki gia yə mi wi ntəkə wələ nì dzakaki jɔbi wə wi nì kɛiŋki wiwɔm. Wi nì dzakaki a, a bi numki i kaŋ yitali wə, ma ŋgaiŋ bi fiəni dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Si yi kɔ yakadəiŋ, dzâka a bəni bûku tsə̂ chə̂niki jum yiwɔ i tsə̂ bûku i kaŋ yitali wə, kɔm buku lwaki a bwa bu bə mbaŋ kɔlə ni wɛɛli tsə chwɔ wini wi i nyə bəh wi, ka bɔ fukuki i bəni a, ‘Wi dza i kpi wə.’ Bɔ ka fə yakadəiŋ, ma ntəkə biələ i liə ni gumi tsə bi ninshiŋ biə.” ");
INSERT INTO cug_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Baylɛ dzaka i bɔ a, “Mbɛiŋ dzɔ̂ bəni bə jum ma mbɛiŋ bɔ tsə̂, mbɛiŋ dzâka bɔ chə̂niki jum yiwɔ bindzɔŋ asi mbɛiŋ si kɔ i chəniki.” ");
INSERT INTO cug_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ayakadəiŋ, bɔ ka tsə kɛiŋsi baŋ dzaka ki jum kiwɔ, ka fə kinchəsi i təh wə bɔ nì baŋ dzaka ki jum kiwɔ yɛiŋ, ka jiə bəni bə jum i chəniki. ");
INSERT INTO cug_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Asi chɔkɔ bimbam nì tsə, chɔkɔ wɔɔ dzə, i buku nya i chɔkɔ bi ninshiŋ wə i shi wə, Meli Magdalen bəh Meli widɔkɔ wə tsə i tsɛiŋ jum. ");
INSERT INTO cug_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yi num a, nshwaiŋ nì dza nəŋni bəh ŋga, kɔm chinda wi Bah nì shi dzə bɛiŋ biŋsi təh wimbum wə bə nì baŋ dzaka kijum kiwɔ yɛiŋ ka shinum i yɛiŋ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chinda wiwɔ nì kɔ shi bi mwaŋyi aka dzaŋ yi mwaŋyini, bəmbuŋ bu fuku lə buuu. ");
INSERT INTO cug_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bəni bə̀ bɔ nì chəniki jum yiwɔ yɛiŋ wi, lwa na bəh ŋga, nyumyi lə kəkəkə, gbɔyi i kuku nɔyi aka bi kpili bəni. ");
INSERT INTO cug_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Chinda wi Nyɔ wiwɔ dzaka i bəkaŋa bəwɔ a, “Mbɛiŋ ma lwâki. Mih kiəki lə a mbɛiŋ nəŋki Jisɔs wə bə ni baŋŋ i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wi fa kɔkə, wi dza lɔ i kpi wə asi wi nì dzaka. Mbɛiŋ dzə̂ yɛ̂iŋ di biə wi ni nɔ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mbɛiŋ tsə̂ fûku wakali i bwa bu bə mbaŋ a wi dza lɔ i kpi wə, wi tsəki i mbɛiŋ nshiŋ i Galili. Mbɛiŋ ni yɛiŋ lə wi fɛiŋ. Mbɛiŋ wɔ̂kɔli, mbɛiŋ wɔkɔ lɔ si mih fuku i mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ayakadəiŋ, bəkaŋa bə̀ ka kɔmsi dza nyə i jum yiwɔ bɛiŋ bəh nlwa, ayakalə bɔ num tə bəh kinsaŋli nalə, ka yɔkɔ tsə i fuku i bwa bə Jisɔs bə mbaŋ. ");
INSERT INTO cug_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Si bɔ nì tsəki, yi dza num a bɔ nì baŋsi bəh Jisɔs, wi dzaka i bɔ a, “Mih bɔniki mbɛiŋ.” Bɔ ka dzə kɔmsi i wi wə, ka gbɔ ka bwam gvu yi, ka kɔksi wi. ");
INSERT INTO cug_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisɔs dzaka i bɔ a, “Mbɛiŋ ma lwâki. Mbɛiŋ tsə̂ dzâka i bwa bə nih bəŋ a bɔ tsə̂ki i Galili ma bɔ ni yɛiŋ mih fɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jɔbi wə bəkaŋa bəwɔ ni dza i tsəki, num bəni bə jum bədɔkɔ bə̀ bɔ nì chəniki jum yiwɔ si nyə tsə i kwili kintəəŋ i tsə fuku gia yichi yə yi si num i bətii mfə gia bəmbum. ");
INSERT INTO cug_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bətii mfə gia bəmbum bə̀ ka juŋni bəh bəni bə̀ bɔ sakaki tumi bəh bɔ num jiə ja, ka baŋyi kaŋ yi bəni bə jum bəh kpɔ widuli, ");
INSERT INTO cug_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","dzaka i bɔ a, “Mbɛiŋ dzâkaki i bəni a mbɛiŋ si nɔki lə bwa bu bə mbaŋ dzə chwɔ wini wi ka nyə bəh wi. ");
INSERT INTO cug_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mbɛiŋ kabə dzakaki yakadəiŋ, yi ka liə i kintuni ki mi wi sakani wə, wi ni kabə nəŋ i nya ŋgəkə i mbɛiŋ, ma buku ni tsə yɛiŋ wi, wi ma ni chu nya ŋgəkə i mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ayakadəiŋ, bɔ ka dzɔ kpɔ wiwɔ ka fukuki asi bə si dzaka i bɔ. Kichum kiwɔ ka waŋ tsə i kintəəŋ ki Bəju wə i dzə buku i bidaiŋ wə a bə nì chwɔ wini wi Jisɔs chwɔni. ");
INSERT INTO cug_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Bwa bə mbaŋ bə Jisɔs bə̀ jwɔfi ntsɔ mu ka nyə tsə i Galili, yaka tsə i ŋkwuŋ wə Jisɔs nì fuku i bɔ. ");
INSERT INTO cug_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jɔbi wə bɔ ni yɛiŋ wi, ka kɔksi wi. Ayakalə, bədɔkɔ məŋni lɔ wi. ");
INSERT INTO cug_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisɔs dza kini dzə dzaka i bɔ a, “Ba wuŋ kɔ num wi nya lɔ ŋga bichi i bɛiŋ bəh i kuku i mih. ");
INSERT INTO cug_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ayakadəiŋ, mbɛiŋ tsə̂ i bitumi wə bichi, mbɛiŋ fə̂ki bəni numki bəni mbəŋ bə mbaŋ, jûli bɔ i bɔkɔ i yɛli wi Nyɔ Ba bəh Waiŋ bəh Kiŋ'waka ki Baiŋni. ");
INSERT INTO cug_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mbɛiŋ lâniki bɔ a bɔ fə̂ki gia yichi yə mih nì laniki mbɛiŋ yɛiŋ. Mbɛiŋ wɔ̂kɔli, mih ni numki lə bəh mbɛiŋ i jɔbi wichi wə i tsə buku na jɔbi wə mbi bi tsə kaaki.”");
INSERT INTO cug_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Fa kɔ ntum wi ndzɔŋni kɔm Jisɔs Klistus Waiŋ Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ntum wiwɔ nì yisi asi Isaya mi wi ntum wi Nyɔ nì nyaka a Nyɔ dzakaki a, “Wɔ̂kɔli, mih ni chiŋsi lə mi wuŋ wi ntum i wɔ nshiŋ, ma wi tsə kɛiŋsi dzəh ya. ");
INSERT INTO cug_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ja yi mi wiliki i chwa a bə kɛiŋsi dzəh yi Bah, bə lûmsi yi a yi nûm chəŋ.” ");
INSERT INTO cug_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ayakadəiŋ, mi widɔkɔ bə nì bɔɔŋki a Jɔn Njulibɔkɔ nì nyə tsə i chwa, ka fukuki i bəni a bɔ kwûni shɔ́m yibɔ, ma ŋgaiŋ juli bɔ i bɔkɔ ka Nyɔ bi dalinya chu bibɔ. ");
INSERT INTO cug_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Bəni nì bukuki i bimbu bi tumi bi Judea wə bichi bəh i kwili wi Jɛlusalɛm wə wichi tsə i wi, də kɔm bə chu bibɔ, wi ka juliki bɔ i Bɔkɔ yi Jɔdan mə. ");
INSERT INTO cug_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jɔn nì lɔɔki bəmbuŋ num bə kɛiŋsi bəh kiluli ki nyam yidɔkɔ yə bə bɔɔŋki a kamɛl, wi kaŋa bəh chiŋnih num bə kɛiŋsi bəh dzu yi nyam, wi nì dziki a chúmi bəh nyu yi chwa. ");
INSERT INTO cug_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jɔn nì lakaki a, “Mi widɔkɔ dzəki lə i mih jum wi tsə mih, mih kpɛiŋniki kə na i ŋgwuŋ shi i kuku i baayi bəlaba bu. ");
INSERT INTO cug_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mih juliki mbɛiŋ num i bɔkɔ, yakadəiŋ, wi ni juliki mbɛiŋ num i Kiŋ'waka ki Baiŋni wə.” ");
INSERT INTO cug_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A nì kɔ i kaŋ yə wə, Jisɔs nyə i Nasali i kimbu ki tumi ki Galili wə, dzə a Jɔn juli ŋgaiŋ i Bɔkɔ yi Jɔdan mə. ");
INSERT INTO cug_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Asi Jisɔs nì bukuki dzəki i bɔkɔ yakadəiŋ, wi yɛiŋ bɔɔli wɛli gwu, Kiŋ'waka ki Baiŋni shi dzə i gwu yi wə ka kimbumi. ");
INSERT INTO cug_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ja dzaka i bɛiŋ a, “Wɔ kɔ Waiŋ wuŋ wi shɔm, mih wɔkɔki lə ndzɔŋni kɔm wɔ nalə.” ");
INSERT INTO cug_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Akisəkə Kiŋ'waka ki Baiŋni ka fə Jisɔs tsə ka nɔki i chwa. ");
INSERT INTO cug_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wi nì kɔ fɛiŋ i kaŋ wə mbaŋnyani, ŋkpɛli mɔmsi wi. Wi nì kɔ fɛiŋ yakadəiŋ bəh nyám yi chwa, ayaka bəchinda bə Nyɔ dzə ka tsɛiŋki wi. ");
INSERT INTO cug_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Bə dza kwa Jɔn ka jiə i juŋ yi nsəŋ mə. Si yəmaka nì tsə, Jisɔs nyə dzə i Galili, ka fukuki ntum wi ndzɔŋni wi Nyɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wi nì fukuki, dzaka a, “Jɔbi dzə kpɛiŋ lɔ, wə ŋkuŋ bi Nyɔ si num a kaŋ. Mbɛiŋ kwûni shɔm yimbɛiŋ, ma mbɛiŋ bûm ntum wi ndzɔŋni wələ.” ");
INSERT INTO cug_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisɔs bi nyə ka nyaniki tsəki i kinchwɔ kimbum ki Galili kpəŋ, ka yɛiŋ Samɔn bəh waiŋnih wi Andulu tum gbi i bɔkɔ, kɔm bɔ nì kɔ bəni bə kwani bwɔ́kɔ. ");
INSERT INTO cug_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisɔs dzaka i bɔ a, “Mbɛiŋ bîəli mih ma mih ni fə mbɛiŋ numki bəni bə̀ bɔ kwaki num lɔ bəni.” ");
INSERT INTO cug_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Akisəkə, bɔ ka bee gi yibɔ, ka biəliki wi. ");
INSERT INTO cug_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisɔs kini tsə i ninshiŋ, yɛiŋ Jɛm bəh waiŋnih wi Jɔn, bə̀ bɔ nì kɔ bwa bə Sɛbide, bɔ num i ŋgwuki mə kwɔ gi yibɔ. ");
INSERT INTO cug_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jisɔs ka bɔɔŋ tə bɔ akisəkə. Bɔ bee ba wibɔ Sɛbide i ŋgwuki mə bəh bəni bə̀ bɔ nì dzɔ a bəh bɔ nɔmki, ka biəli wi. ");
INSERT INTO cug_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Bɔ bəh Jisɔs nyə tsə i kwili wi Kafanaum wə. Aka dzə num i chɔkɔ bimbam wə, Jisɔs tsə liə i juŋ yi tsani mə akisəkə ka laniki bəni. ");
INSERT INTO cug_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bəni ka wɔkɔliki num lɔ bəh dzaka ki wɔmni i nlani wiwɔ wə, kɔm wi nì laniki ka mi wə wi kaŋaki ŋga bi lanini. Wi nì laniki kə ka bəni bə̀ bɔ laniki bənchi bə Nyɔ si lani. ");
INSERT INTO cug_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A jɔbi wiwɔ wə, mi widɔkɔ nyə dzə num i juŋ yi tsani yiwɔ mə, a num mi wi kaŋa kiŋ'waka kichu i gwu yi mə. ");
INSERT INTO cug_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Si wi liə fɛiŋ, ka wam a, “Jisɔs wi Nasali, wɔ nəŋki nə i buku wə a? Wɔ dzə i kaasi buku a? Mih kiəki lə wɔ. Akɔ wɔ mi wi baiŋni wə wi nyə i Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisɔs kaŋyi kiŋ'waka kichu kiwɔ, dzaka a, “Kpîchumi mɔŋ, bûku i mi wələ mə.” ");
INSERT INTO cug_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kiŋ'waka kiwɔ ka fə wi gbɔ i kuku ka jwɔki, ki wam bəh ŋga, ka buku i gwu yi mə. ");
INSERT INTO cug_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Bəni bəchi yɛiŋ yakadəiŋ, dzaka wɔm bɔ, ayaka bɔ ka dzakayiki a bɔ bɔ bikəyi a, “Yələ kɔ yi naiŋ lə a? Akɔ nlani wimfiaŋ widɔkɔ a bəh ŋga yɛiŋ na? Mi wələ kaŋaki ŋga i kaŋyi biŋ'waka bichu bi wɔkɔ i wi.” ");
INSERT INTO cug_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Akisəkə, ntum wiwɔ kɔm Jisɔs waŋ tsə i bidi bichi wə i kimbu ki Galili wə. ");
INSERT INTO cug_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Akisəkə Jisɔs buku i juŋ yi tsani yiwɔ mə, ka tsə i juŋ yi Samɔn bəh Andulu wə, Jɛm bəh Jɔn num bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A nì kɔ nih kpə Samɔn nɔ i naŋbɛiŋ, gwu yi yakani yiləkəli yaka wi. Asi Jisɔs liə i yɛiŋ dzu, bə ka fuku i wi kɔm kpaŋa wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jisɔs tsə i naŋ kə wi nì nɔki yɛiŋ, kaŋa wi i tsɛiŋ wə, dzasi wi i bɛiŋ. Ayaka jwɛiŋ yi yakani yiləkəli yiwɔ ka bee wi, wi dza bɛiŋ, tsɛiŋ fiɛŋ bɔ dzi. ");
INSERT INTO cug_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","A dzə num i fijɔbi i chɔkɔ biwɔ wə asi wɔŋ ni shiki tsəki i liə, bə ka dzəki bəh bəni bəchi bə̀ bɔ nì gwɛiŋki bəh bəni bə̀ bəchinda bə ŋkpɛli nì njiŋsiki bɔ i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kwili wiwɔ wichi juŋni i fifiəŋə. ");
INSERT INTO cug_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Wi chuku bəni bəduli bə̀ bɔ nì kaŋaki jwɛiŋ chi chi, chu bwili bəchinda bə ŋkpɛli i bəni bədɔkɔ bəduli wə. Wi nì bwiliki, wi chu bum kə a bəchinda bəwɔ dzaka gia yidɔkɔ, kɔm bɔ ni kiəki lə mi wə wi kɔ wi. ");
INSERT INTO cug_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A bi dzə num na kinchɔŋɔchɔŋɔ, Jisɔs dza bɛiŋ, buku tsə i di bidɔkɔ wə wi mbɔŋ ka tsaki. ");
INSERT INTO cug_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Samɔn bəh bəni bə̀ bəh bɔ nì kɔ, baaŋ i jum wə ka buku tsə ka nəŋki wi. ");
INSERT INTO cug_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Bɔ yɛiŋ wi, dzaka i wi a, “Bəni bəchi baaŋ ka nəŋki wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisɔs chukuli mfih i bɔ a, “Bukumbɛiŋ dâŋ tsə̂ i bidi bidɔkɔ wə ka mih kɔlə i fuku tə gia yi Nyɔ fɛiŋ. Akɔ gia yə mih dzə kɔm yi.” ");
INSERT INTO cug_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ayaka wi ka nyaniki i bimbu bi Galili wə bichi fuku gia yi Nyɔ i juŋ yi tsani yibɔ wə, bwili bəchinda bə ŋkpɛli i bəni wə. ");
INSERT INTO cug_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mi widɔkɔ wi nì gwɛiŋki bəh jwɛiŋ yi kumyini nyə dzə tum binyu i Jisɔs nshiŋ, tsa wi dzaka a, “Wɔ kabə kɔŋki wɔ fə̂ mih bâiŋki.” ");
INSERT INTO cug_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ayaka nshɛiŋ kwa Jisɔs, wi nani tsə tsɛiŋ kɔm wi, dzaka i wi a, “Mih kɔŋki lə, bɔ̂nih, ma wɔ bâiŋki.” ");
INSERT INTO cug_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Akisəkə, jwɛiŋ yi kumyini yiwɔ ka bee wi, wi bɔnih ka baiŋki. ");
INSERT INTO cug_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jisɔs ka dzaka a wi tsə̂ki, ka lansi kiŋ i wi, ");
INSERT INTO cug_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","dzaka a, “Kiə wɔ ki fûku kə gia yiwɔ i mi widɔkɔ. Ayaka, tsə̂ chûsi gwu ya i tii mfə gia, ma wɔ nyâ kinya kə Muses nì dzaka a mi kaŋaki i nyâ i chusi i bəni a wi bɔnih lɔ i jwɛiŋ yi kumyini wə ka baiŋki.” ");
INSERT INTO cug_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Si Jisɔs kiŋ yakadəiŋ, mi wiwɔ ka buku tsə yisi i fukuki tsəki gia yiwɔ. Ayaka kwili wiwɔ ka waŋ tsə i bidi bichi wə, yi fə Jisɔs na chu liə nyani i kintəəŋ ki tumi wə. Wi ka baaŋ a numki i chwa, bəni nyə dzə i bidi di wə, dzə yɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Asi kaŋ yidɔkɔ ni tsə, Jisɔs fiəni tsə i Kafanaum. Bəni wɔkɔ a wi si num lɔ i dzu, ");
INSERT INTO cug_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","bɔ ka juŋniki dzəki i fɛiŋ bəduli, dzəh nì kɔkə fɛiŋ ka mi tɔm gvu na bəh i dzaka kifiəŋə wə. Wi ka bə́ fuku gia yi Nyɔ i bɔ. ");
INSERT INTO cug_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bəni bədɔkɔ bənaa ka dzəki bəh mi widɔkɔ i wi num bɔ buŋ wi i kimbuŋ wə, num wi kpi wa wimu. ");
INSERT INTO cug_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yi gaka bɔ i liə tsə bəh wi i Jisɔs wə kɔm bəni ni faaŋniki lə nalə. Bɔ ka yaka num i fwu wi juŋ bɛiŋ, tɔ kiyəə i di biə Jisɔs nì num. Si bɔ tɔ yakadəiŋ, ka shisi mi wiwɔ i kimbuŋ kə wi nì nɔki yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisɔs yɛiŋ si bɔ jiə shɔm i wi wə, wi ka dzaka i mi wə wi nì kɔ num wi kpi wa wimu a, “Nsɛiŋ wuŋ, mih dalinya lɔ chu bia.” ");
INSERT INTO cug_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bəni bədɔkɔ bə̀ bɔ nì laniki bənchi bə Nyɔ bɔ num fɛiŋ ka wɔkɔ yaka, ka shwiŋyiki i shɔm yibɔ wə, bikə a, ");
INSERT INTO cug_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mi wələ dzakaki dəiŋ lə a? Wi dzɔki di bi Nyɔ. Akɔ ndə wə wi kɔ i dalinya chu a kɔbi a Nyɔ shəŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jisɔs ka kiə i shɔm yi wə gia yə bɔ ni kwakaki, ka bikə i bɔ a, “Mbɛiŋ biələ biŋkwaka kaŋaki i shɔ́m yimbɛiŋ wə lə kɔm nə a? ");
INSERT INTO cug_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Yə yi bɔniki i dzaka i mi wələ kɔ yi naiŋ a? I dzaka a mih dalinya lɔ chu bi, ma a wi dzɔ̂ kimbuŋ ki wi tsə̂ki a? ");
INSERT INTO cug_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ayakalə, mih nəŋki i fə a mbɛiŋ kiə a mi wə yɛli wi kɔ Waiŋmi kaŋaki lə ŋga i fa kuku i dalinya chu.” Ayaka wi ka dzaka i mi wə wi nì kpi wa wimu a, ");
INSERT INTO cug_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mih dzakaki i wɔ, dzâ bɛiŋ wɔ dzɔ̂ kimbuŋ ka wɔ tsə̂ i wɔ dzu.” ");
INSERT INTO cug_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wi dza bɛiŋ, ka dzɔ kimbuŋ ki ka buku, bəni bəchi tsɛiŋ wi. Ayaka bɔ tsɛiŋ lə, dzaka wɔm bɔ, bɔ ka tumki bikum bi Nyɔ, dzaka a, “Buku kɛiŋki ki yɛiŋ kə gia yidɔkɔ ka yələ.” ");
INSERT INTO cug_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisɔs chu nyə ka tsə kɔmsi i kinchwɔ kimbum kpəŋ, mbaŋ wi bəni dzə i wi kpəŋ, wi ka yisi i laniki bɔ. ");
INSERT INTO cug_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Asi wi nì nyaniki tsəki, wi yɛiŋ Lɛwi waiŋ Alfiyus, wi num i di bi bi nɔm wə, wi kwa kiŋwakti. Jisɔs ka dzaka i wi a, “Wɔ bîəli mih.” Wi ka dza bɛiŋ ka biəli wi. ");
INSERT INTO cug_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisɔs bəh bwa bu bə mbaŋ ni tsə ka dziki i Lɛwi dzu bəh bəni bə̀ bɔ nì kwaki kiŋwakti bəh bəni bəchu bədɔkɔ tə, kɔm bəni ka bələ nì biəliki lə wi bəduli nalə. ");
INSERT INTO cug_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jɔbi wə Bəfalasi bə̀ bɔ nì laniki nnyaki bənchi bə Nyɔ yɛiŋ si Jisɔs dziki bəh bəni bəchu bəh bə̀ bɔ nì kwaki kiŋwakti, ka bikə i bwa bu bə mbaŋ a, “Akɔ kɔm nə wi dziki bəh bəni bə̀ bɔ kwaki kiŋwakti bəh bəni bəchu bədɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisɔs wɔkɔ si bɔ bikəki, ka dzaka i bɔ a, “Bəni bə̀ bɔ gwɛiŋki kə si nəŋ kə mi wi chukuni. Asi nəŋ num bə̀ bɔ gwɛiŋki. Mih ka dzə dəkə i bɔɔŋ bəni bə̀ bɔ kɔ chəŋ. Mih dzə i bɔɔŋ num bəchu.” ");
INSERT INTO cug_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yi dzə num a, bwa bə mbaŋ bə Jɔn Njulibɔkɔ, bəh Bəfalasi nì bamki lə dzaka. Bəni bədɔkɔ ka dzə bikə i Jisɔs a, “Akɔ kɔm nə wə bwa bə mbaŋ bə Jɔn, bəh bə Bəfalasi bamki dzaka, bwa ba bə mbaŋ bam kə a?” ");
INSERT INTO cug_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisɔs chukuli i bɔ a, “Bə kɔlə i laka bəni i dzini bi miŋkpaŋa wimfiaŋ wə, ma bɔ chu dzə bamki dzaka nyum miŋkpaŋa wiwɔ num fɛiŋ bəh bɔ a? Bɔ kɔkə i bamki dzaka wi num bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ayakalə, kaŋ dzəki lə yə bə bi dzɔ bwili nyum miŋkpaŋa wiwɔ i bɔ, ma bɔ bi ka yisi i bamki dzaka i jɔbi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mi kɔkə i dzɔ kinchumni kimbuŋ kimfiaŋ, i kwɔyi mbuŋ wikpu yɛiŋ. Wi ka fə yakadəiŋ, ma kinchumni kimbuŋ kimfiaŋ kiwɔ ni taŋa kaasi mbuŋ wikpu wiwɔ, ma dzəŋə yiwɔ ni chu na yimbum. ");
INSERT INTO cug_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mi kɔkə i dzɔ tə mbih mimfiaŋ i jiə i kiŋgəə ki mbih kikpu kə bə kɛiŋsi bəh dzu yi nyam. Wi ka fə yakadəiŋ, mbih mimfiaŋ miwɔ ni biəŋə wɔɔ kiŋgəə kikpu kiwɔ, mbih miwɔ i kiŋgəə kiwɔ wə ni laka kilɔlɔ. Yi kɔ a, bə kaŋaki i jiə mbih mimfiaŋ num i kiŋgəə kimfiaŋ wə.” ");
INSERT INTO cug_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","A nì kɔ i chɔkɔ bimbam bidɔkɔ wə, Jisɔs bəh bwa bu bə mbaŋ ka nyaniki tsəki tɔliki i kikhə kigəŋ kidɔkɔ wə. Bwa bu bə mbaŋ ka yisi i təiŋyiki kifwu kigəŋ fiksi dzi. ");
INSERT INTO cug_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Bəfalasi yɛiŋ yakadəiŋ, bikə i Jisɔs a, “Yɛiŋ na, akɔ kɔm nə wə bwa ba bə mbaŋ fəki gia yə nchi ka bum dəkə a mi fə̂ki i chɔkɔ bimbam wə a?” ");
INSERT INTO cug_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisɔs bikə tə i bɔ a, “Mbɛiŋ ka num fa dəkə i Kiŋwakti ki Nyɔ wə si dzɔŋ nì wɔɔki ŋkuŋ Dɛbit bəh mbaŋ wi, wi fə a? ");
INSERT INTO cug_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","A nì kɔ jɔbi wə Abiata nì kɔ fwu i bətii mfə gia, Dɛbit liə i juŋ yi Nyɔ mə wi dzɔ blɛd wə bə nì baa jiə a akɔ wi Nyɔ, dzi chu nya tə mbaŋ wi yɛiŋ, num a nì kɔ nchi bum kə a mi kɔlə i dzî blɛd wiwɔ a kɔbi a bətii mfə gia.” ");
INSERT INTO cug_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisɔs dzaka kaasi i bɔ a, “Nyɔ nì jiə chɔkɔ bimbam kɔm mi. Wi nì ka maa mi kɔm chɔkɔ bimbam. ");
INSERT INTO cug_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ayakadəiŋ, mi wə yɛli wi kɔ Waiŋmi kɔ Bah na bəh wi chɔkɔ bi mbam.” ");
INSERT INTO cug_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ayakadəiŋ, Jisɔs nì chu tsə liə i juŋ yi tsani wə. Mi widɔkɔ num bəh tsɛiŋ yi kpili. ");
INSERT INTO cug_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bəni bədɔkɔ bə̀ bɔ nì kɔ fɛiŋ bɔ nì nəŋki gia yə bɔ ki jiəki i wi fuŋ, ka bwaŋ dzəkəh i gwu yi wə ka tsɛiŋki a wi ni chuku lə mi wiwɔ i chɔkɔ bimbam wə a. ");
INSERT INTO cug_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisɔs dzaka i mi wə tsɛiŋ yi nì kɔ yi kpi a, “Dzâ bɛiŋ wɔ dzə̂ fa.” ");
INSERT INTO cug_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Si wi dzə, Jisɔs bikə i bəni a, “Gia yə nchi bumki a mi fə̂ i chɔkɔ bimbam wə kɔ yi naiŋ na? I fə̂ gia yindzɔŋni, ma yichu a? I bwîli mi, ma i wɔ̂ɔ lɔ a?” Ayakalə, bɔ kpichumi mɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisɔs tsɛiŋ tali bɔ bəchi bəh tɔɔ wi bɔkɔli, gwu kpi wi kɔm bə shɔm yibɔ yichu. Wi dzaka i mi wə tsɛiŋ yi nì kɔ yi kpi a, “Nâni tsɛiŋ ya.” Wi nani yi kaa ka bɔnih. ");
INSERT INTO cug_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bəfalasi ka buku, tsə bəh mbaŋ wi bəni bə Ŋkuŋ Hɛlɔd i kɛiŋsi akisəkə si bɔ nì fə ka bɔ wɔɔ Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisɔs bəh bwa bu bə mbaŋ ka nyə fɛiŋ tsə i kinchwɔ kimbum ki Galili wə. Mbaŋ wi bəni bəduli biəli wi. Bəni bədɔkɔ nì nyəki dzəki i bimbu ki Galili wə bəh ki Judea wə. ");
INSERT INTO cug_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bədɔkɔ nì nyə i Jɛlusalɛm, bədɔkɔ nyə i kimbu ki Idumea wə, bədɔkɔ nyə i kimbu ki Bɔkɔ yimbum yi Jɔdan wə i waka, bədɔkɔ i bimbu bi Taya bəh Sidɔn wə. Mbaŋ wiwɔ nì dzə yaka kɔm bɔ nì wɔkɔ gia yə wi nì fəki yichi. ");
INSERT INTO cug_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisɔs dza dzaka a bwa bu bə mbaŋ nəŋ kɛiŋsi jiə ŋgwuki ka wi liə yɛiŋ kɔm mbaŋ nì dzə kwu baŋ wi. ");
INSERT INTO cug_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wi nì dzaka yakadəiŋ kɔm wi nì kɔ wi chuku lɔ bəni bəduli, ka bəni bə jwɛiŋ ma dzəki kɔmki wi. ");
INSERT INTO cug_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Bəni bə̀ biŋ'waka bichu nì njiŋsiki bɔ nì yɛiŋki Jisɔs bɔ ka gbɔyiki i wi nshiŋ wamyi dzaka a, “Wɔ kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Si bɔ wamyi yaka, Jisɔs lansi kiŋ i bɔ a kiə bɔ ki fə̂ kə a bəni kiə ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wi dza yaka tsə i ŋkwuŋ bɛiŋ, bɔɔŋ bəni bə̀ wi nì nəŋki, bɔ dzə i wi. ");
INSERT INTO cug_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Wi babwili bəni jwɔfi ntsɔ bəfa, bɔɔŋ bɔ a bwa bu bə ntum, ka bəh bɔ nûmki, wi fâaŋki bɔ a bɔ nyâniki fûkuki gia yi Nyɔ, ");
INSERT INTO cug_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","chu kaŋa ŋga i bwiliki bəchinda bə ŋkpɛli i bəni wə. ");
INSERT INTO cug_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Bəni bəwɔ nì kɔ: Samɔn, wə wi nì nya yɛli wi widɔkɔ a Bita. ");
INSERT INTO cug_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jɛm bəh waiŋnih wi Jɔn bə̀ bɔ nì kɔ bwa bə Sɛbide, bə̀ wi nì nya yɛli i bɔ a “Bɔanɛgɛs” num a, “Bwa bə dzaŋ yi wamyini.” ");
INSERT INTO cug_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Bədɔkɔ nì kɔ Andulu, Filib, Batɔlɔmu, Matiɔ, Tɔmɔs, Jɛm wə waiŋ Alfiyus, Tadeus, Samɔn wə wi nì kɔ mi wi mbaŋ wi dzɛlɔt, ");
INSERT INTO cug_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","bəh Judas Iskaliɔt wə wi nì nyani lə dzə taŋni Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisɔs nì nyə tsə i di biə wi nì nɔki, mbaŋ wi bəni chu juŋni fɛiŋ, bɔ bwa bu bə mbaŋ nəki kaŋa kə na dzəh lɔ i dzi. ");
INSERT INTO cug_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jɔbi wə chwɔŋkijuŋ ki nì wɔkɔ, ka tsə i dzɔ wi kɔm bəni nì dzaka a wi yuŋsiki lə. ");
INSERT INTO cug_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Bəni bə̀ bɔ nì laniki nnyaki bənchi bə Nyɔ bəh bə̀ bɔ nì buku dzə i Jɛlusalɛm shi tsə fɛiŋ ka dzakaki a, “Bɛlsebu kɔ i wi mə, wi bwiliki bəchinda bə ŋkpɛli bələ num bəh ŋga bi ŋkuŋ wi bəchinda bəwɔ.” ");
INSERT INTO cug_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ayakadəiŋ, Jisɔs bɔɔŋ bɔ, bikə i bɔ i ndi wə a, “Satan kɔ i fiəni bwili gwu yi i mi wə dəiŋ wə a? ");
INSERT INTO cug_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tumi ka gaali dza ka jwɔki a kiki, ki ni chu num kə. ");
INSERT INTO cug_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Juŋ ka gaali, dza ka jwɔki a yiyi, yi ni chu num kə. ");
INSERT INTO cug_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan ka dza gaali bəh mbaŋ wi ka bə́ jwɔki a bɔ bɔ, wi nì chu num kə, ayakalə yaka kiŋgɔksi ki si tsə a ŋka wə. ");
INSERT INTO cug_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mbɛiŋ kîə a mi kɔkə wə wi kɔ i liə juŋ yi mi wi ləkəli wə, i kɔ biɛiŋ biə wi kɔŋki i gɛiŋ nyə fɛiŋ, na ma wi yisi kaŋa mi wi ləkəli wiwɔ na ka wi kɔ biɛiŋ biwɔ. ");
INSERT INTO cug_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mih fukuki ŋkɔŋ i mbɛiŋ a, Nyɔ kɔlə i dalinya gia yichu bəh ja yichu yichi yə bəni dzakaki kɔm wi. ");
INSERT INTO cug_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ayakalə, na ndə wə wi dzaka ja yichu i fwu wi Kiŋ'waka ki Baiŋni wə, yi kɔ a Nyɔ bi dalinya kə wi, kɔm wi fə chu bi kpamu.” ");
INSERT INTO cug_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisɔs nì dzaka yaka kɔm bəni bədɔkɔ nì dzaka a kiŋ'waka ki jisi kɔlə i gwu yi wə. ");
INSERT INTO cug_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nih Jisɔs bəh bwa bə nih bə Jisɔs ka dzə, num i biŋ, faaŋ mi widɔkɔ a wi bɔɔŋ wi. ");
INSERT INTO cug_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A nì kɔ mbaŋ wi bəni num fiəli ka juŋni baŋ wi. Bɔ dzaka i wi a, “Nih wa bəh bwa bə nah kɔ i biŋ bikə wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisɔs chukuli wi a, “Nih wuŋ bəh bwa bə nih bəŋ kɔ ndə?” ");
INSERT INTO cug_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Si wi bikə yaka ka tsɛiŋ bəni bə̀ bɔ nì numyi fiəli wi, ka dzaka a, “Nih wuŋ bəh bwa bə nih bəŋ kɔ bələ. ");
INSERT INTO cug_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mbɛiŋ kîəki a, na ndə wə wi fəki gia yə Nyɔ nəŋki, kɔ wi wə wi kɔ waiŋnih wuŋ bəh jɛmi yiŋ bəh nih wuŋ.” ");
INSERT INTO cug_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisɔs ka chu yisi i laniki bəni i kɔmsi tsə i bɔkɔ kpəŋ mbaŋ wi bəni ka juŋniki dzəki fɛiŋ lə mɔɔɔŋ. Wi ka nyə liə lɔ i ŋgwuki mə shinum yɛiŋ i bɔkɔ, mbaŋ wiwɔ ka numyi i bɔkɔ kpəŋ i kpa. ");
INSERT INTO cug_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Wi ka laniki bɔ bəh gia yiduli i bəndi wə. Ayaka wi dza ti bɔ bəh ndi widɔkɔ a, ");
INSERT INTO cug_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mbɛiŋ wɔ̂kɔli, mi nì laa i tsə mu ŋgɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Asi wi nì muki widɔkɔ gbɔyi i dzəh, minyəni dzə chumi dzi. ");
INSERT INTO cug_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ŋgɔkɔ widɔkɔ gbɔyi i di bi kitəh wə nshwaiŋ num kə fɛiŋ bindzɔŋ. Wi ka kɔmsi buku kɔm nshwaiŋ nì kɔkə fɛiŋ bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jɔbi wə wɔŋ nì yisi i baiŋki, ka twɛiŋ ŋgɔkɔ wiwɔ wi kpiyi, kɔm gaaŋ yiwɔ nì ka liə. ");
INSERT INTO cug_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ŋgɔkɔ widɔkɔ gbɔyi i bifaka wə. Bifaka biwɔ ka kɔ kwu baŋ ŋgɔkɔ wiwɔ ka wi ma wum mintam. ");
INSERT INTO cug_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ayaka ŋgɔkɔ widɔkɔ gbɔyi num i nshwaiŋ yindzɔŋni wə, ka buku yaka ka kɔɔ ka wum, tsə si bə nì mu, dzəkəh yi ŋgɔkɔ yiwɔ wum dzə́kəh mbaŋtia, yidɔkɔ dzə́kəh mbaŋbisɔ, yidɔkɔ dzə́kəh gbi.” ");
INSERT INTO cug_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Si Jisɔs ti yaka ka kaasi a, “Mi wə wi kaŋaki bintuni i wɔkɔ wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jɔbi wə Jisɔs nì kɔ wi mbɔŋ, bəni bədɔkɔ bə̀ bɔ nì kɔ bəh wi bəh bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa, bikə i wi kɔm ndi wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wi chukuli i bɔ a, “Akɔ i mbɛiŋ Nyɔ kɔ wi fə lɔ a mbɛiŋ kiə gia yə yi nyumiki i ŋkuŋ bi Nyɔ wə. Ayakalə, i bəni bədɔkɔ kɔ gia yichi num a bəndi wə, ");
INSERT INTO cug_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ka bɔ nì tsɛiŋki, ayakalə yɛiŋ kə, wɔkɔli, wɔkɔ kə. Asi mɔŋ yaka ma bɔ kwuni shɔ́m yibɔ, Nyɔ dalinya chu bibɔ.” ");
INSERT INTO cug_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisɔs dza bikə i bəni bə̀ bɔ nì kɔ bəh wi a, “Yi kɔ a mbɛiŋ ka kiə dəkə gia yə ndi wələ dzakaki a? A mbɛiŋ ka baaŋ maka mbɛiŋ kiə ndi wələ, mbɛiŋ ni kiə bəndi bədɔkɔ dəiŋ la? ");
INSERT INTO cug_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ŋgɔkɔ wə mi wə nì muki kɔ gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ŋgɔkɔ wə wi nì gbɔyi i dzəh kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, Satan dzə akisəkə bwili gia yiwɔ i shɔ́m yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ŋgɔkɔ wə wi nì gbɔyi i di bi kitəh wə kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, dzɔ akisəkə bəh kinsaŋli, ");
INSERT INTO cug_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ayakalə, maka gaaŋ yiwɔ nyani liə i shɔ́m yibɔ wə. Yi mɔti kə yɛiŋ twɛsi, bəŋgəkə ka dzə, nabə a bəni bwaŋ gvu i bɔ chɛiŋ kɔm gia yiwɔ, bɔ ka fiəni gbɔyi lɔ i jum wə akisəkə. ");
INSERT INTO cug_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ŋgɔkɔ wə wi nì gbɔyi i bifaka wə kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, ");
INSERT INTO cug_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ayakalə, kifum ki mbi wələ bəh kiŋkɔŋ ki mbum bəh kiŋkɔŋ ki biɛiŋ bidɔkɔ dzə juŋni baŋ gia yiwɔ i shɔm yibɔ wə yi laka kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ŋgɔkɔ wə wi nì gbɔyi i nshwaiŋ yindzɔŋni wə akɔ num bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, bɔ dzɔ, ka tsəki a ninshiŋ ninshiŋ, ka ŋgɔkɔ wiwɔ wum dzə́kəh mbaŋtia, dzə́kəh yidɔkɔ mbaŋbisɔ, dzə́kəh yidɔkɔ gbi.” ");
INSERT INTO cug_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisɔs dza bikə a, “Mi si liə bəh naka ki baiŋsiki i dzu wi kwusi baŋ bəh kah, ma wi si jiə i kigasi wə a? Ma wi si liə tɔm num i di biə bə si tɔm naka ki baiŋsiki yɛiŋ wə a? ");
INSERT INTO cug_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mbɛiŋ kîəki a gia yichi yə yi nì kɔ i nyumi wə kɔ yi bə bi chusiki i ndaiŋ wə, yə yi nì kɔ i nyumi nyumi wə, yichi bə bi chusiki yi i baiŋni wə. ");
INSERT INTO cug_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mi wə wi kaŋaki bintuni i wɔkɔ, wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisɔs chu dzaka a, “Mbɛiŋ kabə wɔkɔliki gia yi Nyɔ mbɛiŋ ka wɔ̂kɔliki ndzɔŋki, kɔm dzəh yə mbɛiŋ wɔkɔliki yɛiŋ, kɔ ayaka si Nyɔ bi fəkə i mbɛiŋ, wi bi fəkə na yi du tsə. ");
INSERT INTO cug_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mi wə wi kaŋaki fiɛŋ kɔ wi bə bi kpɛiŋsiki. Mi wə wi kaŋaki kə fiɛŋ kɔ na wi bə bi dzɔ bwili fi twɛsi fiə wi kaŋaki i wi.” ");
INSERT INTO cug_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisɔs chu dzaka a, “Ŋkuŋ bi Nyɔ kɔ aka ŋgɔkɔ wə mi nì mu i khə. ");
INSERT INTO cug_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jɔbi wə asi num nchɔkɔ wi ka nɔ, chɔkɔ ka wɔɔ wi dza. Num ŋgɔkɔ wiwɔ si buku ka kɔɔki, wi chu kɔbi i kiə a ŋgɔkɔ wiwɔ fə dəiŋ ka wi kɔki a, ");
INSERT INTO cug_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","nshwaiŋ si fə wi ka kɔki. Wi dza yisi i nyaki binchaiŋki, wi ka wum tum dzəkəh yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jɔbi wə ŋgɔkɔ wiwɔ biəŋ, wi ka ni dzɔ fiŋkɔfi fi, liə i khə, kɔm jɔbi wi kɔhni kpɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisɔs chu dza dzaka a, “Bukumbɛiŋ kɔ i fəkəli ntɔŋ bi Nyɔ bəh nə? Bukumbɛiŋ kɔ i fəkəli bəh ndi winaiŋ a? ");
INSERT INTO cug_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Wi kɔ ka ŋkaiŋni wi ŋgɔkɔ wi fintam finchiŋ fidɔkɔ fi sɛiŋni tsə na bəŋgɔkɔ bəchi, ");
INSERT INTO cug_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jɔbi wə bə ka gbɛli i khə wi ni buku yaka wi kɔɔ ka numki i kpɛiŋ wi kpali tsə ntəŋ wi biɛiŋ bichi biə bə gbɛli i khə, wi fiəni chu kpɛiŋ ka nya cha ka minyəni mə mɔ fuliki i bɛiŋ kɔ i maa júŋ yibɔ i wi wə, i kinjiŋjiŋ ki wi wə.” ");
INSERT INTO cug_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Akɔ lə si Jisɔs nì fukuki gia yi Nyɔ i bəni, i bəndi wə ka bələ, i dzəh yə bɔ kɔ i wɔkɔ kiə. ");
INSERT INTO cug_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wi nì ka num dzaka gia i bɔ kɔbi i bəndi wə. Ayakalə, jɔbi wə wi nì kɔ wi mbɔŋ num a bɔ bwa bu bə mbaŋ a bɔ bɔ, wi ka fiəni fuku baiŋsi bəndi bəwɔ bəchi i bɔ. ");
INSERT INTO cug_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jisɔs kaasi i laniki bəni chɔkɔ biwɔ a num i fijɔbi, wi dzaka i bwa bu bə mbaŋ wə a, “Bukumbɛiŋ dâŋ bûku tsə̂ i kiwuŋ ki bɔkɔ kə yaka wə.” ");
INSERT INTO cug_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Bɔ ka bee mbaŋ wi bəni wə wi nì kɔ fɛiŋ, ka liə i ŋgwuki wə Jisɔs nì kɔ wi si num lɔ yɛiŋ, bəh bɔ ka daŋki, bəŋgwuki bədɔkɔ biəli bɔ. ");
INSERT INTO cug_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Si bɔ nì daŋki, fuŋni kiləkəli dzə tumbuku yisi ka nəŋniki mwi, mɔ liə i ŋgwuki mə ka nəŋki i jikə. ");
INSERT INTO cug_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisɔs nì kɔ i ŋgwuki mə i jum wə wi nɔ wə, num wi nɔsi fwu wi i kiŋgbɔŋ wə. Bɔ ka tsə yɔmsi wi ka dzaka a, “Mi wi lanini, kpi nəŋki i dzɔ bukumbɛiŋ wɔ kaŋa kə mfia jɔbi kɔm nə a?” ");
INSERT INTO cug_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisɔs dza bɛiŋ, kaŋyi fuŋni kiləkəli kiwɔ, dzaka i mwi miwɔ a, “Kpîchumi mɔŋ.” Fuŋni kiləkəli kiwɔ ka kpichumi, di chimi alə mɔɔɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wi ka bikə i bwa bu bə mbaŋ a, “Mbɛiŋ lwaki nə? Mbɛiŋ kɛiŋki maka mbɛiŋ jiə shɔm i mih a?” ");
INSERT INTO cug_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dzaka wɔm bɔ, bɔ ka dzakayiki a bɔ bɔ a, “Wələ kɔ winaiŋ mi lə a, na fuŋni kiləkəli bəh mwi mi bɔkɔ wɔkɔ i wi a?” ");
INSERT INTO cug_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisɔs bəh bwa bu bə mbaŋ daŋ kinchwɔ kimbum ka buku tsə i waka, i kimbu ki bəni bə Gɛlasen wə. ");
INSERT INTO cug_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Si wi nì bukuki i ŋgwuki mə, wi baŋsi bəh mi widɔkɔ biŋ'waka bichu njiŋsi wi, num wi buku i bita biə bə nì ləəki bəni yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mi wiwɔ nì nɔki i bita biwɔ mə. Mi widɔkɔ kɔbi fɛiŋ wə wi nì kɔ i kaŋa wi, na bəh nsəŋ. ");
INSERT INTO cug_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","I kaŋ yiduli wə, bə nì shiki jiəki wi i biŋkɔm wə, kaŋa tsɛ́iŋ yi bəh bənsəŋ, wi guku təiŋyi bənsəŋ bəwɔ, shakyi biŋkɔm. Mi nì mɔŋ wə wi nì kɔ i kaŋa wi. ");
INSERT INTO cug_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Mi wiwɔ nì fiəliki nnyaki i bita biwɔ yaka wi tsə buku i ŋkwuŋ wə nchɔkɔ bəh nshi, wamyi, kwɔksi gwu yi bəh kitəh. ");
INSERT INTO cug_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Si wi yɛiŋ Jisɔs wi kɛiŋ nanu, wi yɔkɔ tsə tum binyu i wi nshiŋ, ");
INSERT INTO cug_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","wi də bwili bəh ŋga a, “Jisɔs Waiŋ Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə, wɔ nəŋki nə i mih wə a? Mih tsâki wɔ i yɛli wi Nyɔ wə kiə wɔ ki nyâ kə ŋgəkə i mih.” ");
INSERT INTO cug_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Wi nì dzakaki yakadəiŋ, kɔm Jisɔs nì kɔ wi kaŋyi lɔ a, “Kiŋ'waka kichu kələ bûku i mi wələ wə.” ");
INSERT INTO cug_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisɔs bikə i wi a, “Yɛli wa kɔ ndə.” Wi chukuli a, “Yɛli wuŋ kɔ mbaŋ, kɔm buku duki lə.” ");
INSERT INTO cug_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Si wi chukuli yakadəiŋ, ka tsaki Jisɔs a fɛiŋ fɛiŋ a wi ma kɔ̂ŋŋ bɔ i kimbu kələ wə. ");
INSERT INTO cug_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","A nì kɔ yaka mbaŋ wi bifi biduli dzi i ŋgaŋni chɛiŋ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Biŋ'waka bichu biwɔ ka tsa Jisɔs a, “Chîŋsi buku num i bifi biə yaka wə, ma buku liə i bi wə.” ");
INSERT INTO cug_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jisɔs bum. Ayaka biŋ'waka biwɔ ka buku i mi wiwɔ wə, tsə liə i bifi wə. Mbaŋ wiwɔ nì kɔ bifi ka bənchuku bəfa. Bi sɛiŋ shi i fəŋ wə, shi tsə gbɔyi i bɔkɔ yiwɔ wə fɛiŋ ləŋ ka kpiyi. ");
INSERT INTO cug_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Bəni bə̀ bɔ nì tɔkniki bəh bifi biwɔ dza fɛiŋ, gɛiŋ, tsə fuku gia yiwɔ i kwili kintəəŋ bəh i di bichi wə fɛiŋ. Bəni ka wɔkɔ, buku dzə i yɛiŋ gia yə yi si num. ");
INSERT INTO cug_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bɔ dzə i di biə Jisɔs nì kɔ, yɛiŋ mi wə mbaŋ wi bəchinda bə ŋkpɛli nì shiki njiŋsiki wi, num wi shinum fɛiŋ, ka lɔh bəmbuŋ bu, num mfi bi fiəni dzə. Bɔ lwa na bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Bəni bə̀ bɔ nì yɛiŋ gia yə yi num, ka fuku i bəni si yi nì num bəh mi wə mbaŋ wi biŋ'waka bichu biə nì kɔ i wi wə, i tasi bəh gia yi bifi. ");
INSERT INTO cug_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Si bɔ wɔkɔ yakadəiŋ, yisi i tsaki Jisɔs a wi nyə̂ i di bibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisɔs ka liə i ŋgwuki mə, mi wə bəchinda bə ŋkpɛli nì buku i gwu yi mə ka tsaki Jisɔs a bɔ wi nyə. ");
INSERT INTO cug_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisɔs nəiŋ, ka dzaka i wi a, “Nyə̂ tsə̂ i wɔ dzu, ma wɔ tsə̂ fûku i bəni ba gia yə Bah fə i wɔ, bəh si wi kwasi nshɛiŋ i wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ayakadəiŋ, mi wiwɔ ka nyə, tsə ka nyaniki fukuki i tumi kichi kə bə bɔɔŋki a Kikwili Jwɔfi, gia yə Jisɔs fə i wi. Bəni ka wɔkɔ yaka, num lɔ bəh ŋkaŋyi. ");
INSERT INTO cug_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisɔs fiəni daŋ i ŋgwuki wə tsə i kiwuŋ kəyaka wə i kɔmsi tsə i kinchwɔ kimbum kpəŋ, mbaŋ wi bəni chu juŋni dzə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tikwili wi juŋ yi tsani widɔkɔ ka dzə fɛiŋ, yɛli wi num Jaylus. Si wi yɛiŋ Jisɔs, ka tsə tum binyu i wi nshiŋ, ");
INSERT INTO cug_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tsa wi a fɛiŋ fɛiŋ ka dzaka a, “Waiŋ wuŋ wi nchiŋ wi kpaŋni kɔ a i kpi. Mntee wɔ, dzə̂ ma wɔ kɔ̂m kaŋ ya i wi wə ma wi bɔnih ka wi ma kpi” ");
INSERT INTO cug_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisɔs ka dza bɛiŋ bəh wi ka tsəki, mbaŋ wi bəni kwu biəli Jisɔs faaŋni. ");
INSERT INTO cug_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kpaŋa widɔkɔ nì kɔlə i kintəəŋ ki mbaŋ wiwɔ wə num jɔbi wi shi baaŋ a baaŋni i jía wə jwɔfi ntsɔ yifa. ");
INSERT INTO cug_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wi nì kɔ wi bɔh nalə i bəni bə tsa bəduli chɛiŋ, bəkəli biɛiŋ bichi biə wi nì kaŋaki, jwɛiŋ tsə a ninshiŋ tsəni. ");
INSERT INTO cug_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Si wi nì kɔ wi wɔkɔ lɔ kɔm Jisɔs, wi ka dzə i wi jum i mbaŋ kintəəŋ, kɔm mbuŋ wi, ");
INSERT INTO cug_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","kɔm wi nì kɔ wi dzaka i wi shɔm a, “Mih ka kɔm na a mbuŋ wi, ma mih nì bɔnih.” ");
INSERT INTO cug_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Si wi nì kɔm yakadəiŋ, jwɛiŋ yi kaa akisəkə. Miŋkpaŋa wiwɔ wɔkɔ na i gwu yi wə si wi bɔnih. ");
INSERT INTO cug_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisɔs ka wɔkɔ asi ŋga buku i gwu yi wə, wi fiəni gwu akisəkə, bikə i bəni a, “A kɔm ndə mbuŋ wuŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Bwa bu bə mbaŋ chukuli i wi a, “Wɔ yɛiŋ si bəni faaŋniki wɔ, wɔ chu bikə mi wə wi kɔm wɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jisɔs baaŋ a tsɛiŋki i yɛiŋ mi wə wi kɔm wi. ");
INSERT INTO cug_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ayakadəiŋ, kpaŋa wiwɔ ka kiə gia yə yi num bəh wi, wi ka dzə, lwa nyumi, tum binyu i Jisɔs nshiŋ fuku ŋkɔŋ wi wichi i wi. ");
INSERT INTO cug_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jisɔs dzaka i wi a, “Waiŋ wuŋ, shɔm ya yə wɔ jiə i mih yi fə wɔ bɔnih lɔ, tsə̂ bindzɔŋ. Wɔ ta lɔ i jwɛiŋ ya wə.” ");
INSERT INTO cug_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Asi Jisɔs ni kɛiŋki wi dzaka i miŋkpaŋa wiwɔ yakadəiŋ, bəni bədɔkɔ dzə fɛiŋ num bɔ nyə i juŋ yi Jaylus wə tikwili wi juŋ yi tsani, dzaka i wi a, “Waiŋ wa kpi lɔ. Ma chu nyâ ŋgəkə i Mi wi Lanini wələ?” ");
INSERT INTO cug_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Si bɔ dzaka yakadəiŋ, Jisɔs wɔkɔ, ayakalə wi fə aka wi ka wɔkɔ dəkə ka dzaka i Jaylus a, “Kiə wɔ ki lwâ kə, jîə a shɔm ya i mih shəŋ.” ");
INSERT INTO cug_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Asi bɔ nì tsəki, Jisɔs ka bum dəkə a mi widɔkɔ bîəli wi a kɔbi a Bita bəh Jɛm bəh Jɔn wə waiŋnih Jɛm. ");
INSERT INTO cug_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Asi bɔ ni tsə buku i juŋ yi tikwili wi juŋ yi tsani wə, Jisɔs yɛiŋ si bəni gɔkɔki di bəh midɛm fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wi liə dzu, bikə a, “Mbɛiŋ gɔkɔki di bəh midɛm kɔm nə? Waiŋ wiwɔ ka kpi dəkə, wi nɔki num nɔni.” ");
INSERT INTO cug_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bɔ ka suŋuki lɔ wi suŋuni. Wi dza bwili bəni bəchi i biŋ, dzɔ shəŋ tii waiŋ bəh nih waiŋ bəh bəni bu bə mbaŋ bətali bəh bɔ liə tsə i di biə waiŋ wiwɔ nì nɔki. ");
INSERT INTO cug_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wi kaŋa waiŋ wiwɔ i tsɛiŋ wə dzaka i já yibɔ a, “Talita kumi!” Yi num a, “Waiŋkpaŋni, mih dzakaki i wɔ, dzâ bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Akisəkə yakadəiŋ, wi ka dza bɛiŋ ka nyani. Waiŋkpaŋni wiwɔ nì kɔ jía jwɔfi ntsɔ yifa. Bɔ yɛiŋ yaka dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisɔs kiŋ i bɔ nalə a kiə bɔ ki fə̂ kə a mi widɔkɔ kîə gia yə yi num, ka dzaka a bɔ tsɛiŋ fiɛŋ wi dzi. ");
INSERT INTO cug_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisɔs nyə fɛiŋ, bəh bwa bu bə mbaŋ dzə i kwili wə. ");
INSERT INTO cug_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","A num i chɔkɔ bibɔ bimbam, wi tsə i juŋ yi tsani wə yisi i laniki bəni. Bəni bəduli wɔkɔ si wi laniki ka numki bəh ŋkaŋyi. Bɔ ka nyə ka kaiŋyiki dzaka a, “Mi wələ nyə faiŋ bəh wələ nlani fa lə a? Wi dzɔ biələ mfi faiŋ a? Wi nyani dəiŋ na ka wi fəki yələ gia yi kaŋyini lə a? ");
INSERT INTO cug_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A kɔkə a wi wə kaminda waiŋ Meli a? Wi num waiŋnih Jɛm bəh Yɔsɛs bəh Judas bəh Samɔn wə a? Ntə jɛ́mi yi kɔ fa bukumbɛiŋ bɔ a?” Si bɔ kaŋyi yakadəiŋ ka nəiŋ wi. ");
INSERT INTO cug_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisɔs ka dzaka i bɔ a, “Bə si kɔksi lə mi wi ntum wi Nyɔ i di bichi wə a kɔbi a tumi ki wə, bəh i chwɔŋkijuŋ ki wə bəh i wi dzu.” ");
INSERT INTO cug_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Si bə məŋni wi yakadəiŋ, yi ka gaka wi i chu fəki gia yi kaŋyini fɛiŋ yiduli, a kɔbi alə wi nì kɔmyi bəni twɛsi bə̀ bɔ nì gwɛiŋki fɛiŋ bəh kaŋ bɔ bɔnih. ");
INSERT INTO cug_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wi num lɔ bəh ŋkaŋyi si bɔ nì ka jiə dəkə shɔm i wi wə. Jisɔs bi nyə fɛiŋ ka nyaniki i bidi biə fɛiŋ wə lani bəni. ");
INSERT INTO cug_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wi dza bɔɔŋ bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa, ka faaŋ bwili bɔ bəfa bəfa, nya ŋga i bɔ a bɔ bwîliki biŋ'waka bichu i bəni wə. ");
INSERT INTO cug_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Wi bə́ nəŋ i faaŋ bɔ ka dzaka a kiə bɔ ki dzɔ̂ kə na fiɛŋ kɔbi a mbəŋ. Kiə bɔ ki dzɔ̂ kə biɛiŋ bidzini. Kiə bɔ ki dzɔ̂ kə kiba nabə kpɔ i chiŋnih bibɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Bɔ lə̂kə dzuyigvu, yakadəiŋ a kiə bɔ ma lɔh bəmbuŋ bəfa. ");
INSERT INTO cug_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wi chu dzaka i bɔ a, “Mbɛiŋ ka tsə i kwili wə, juŋ yə mbɛiŋ liə yɛiŋ, mbɛiŋ ka nɔ̂ki shəŋ a yi wə i tsə buku chɔkɔ biə mbɛiŋ bi nyəki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kwili widɔkɔ ka nəiŋ i dzɔ mbɛiŋ, nabə i wɔkɔli gia yə mbɛiŋ dzakaki, mbɛiŋ bə́ nəŋ i nyə mbɛiŋ chûmni kwɔŋɔ biə bi kɔ i gvu yimbɛiŋ wə, ka kinchəsi ki gia yə bɔ mɔm.” ");
INSERT INTO cug_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Bɔ ka nyə tsə ka nyaniki fukuki a bəni kwûni shɔ́m yibɔ. ");
INSERT INTO cug_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Bɔ chu bwili tə bəchinda bə ŋkpɛli bəduli i bəni wə, təkəsi fiaŋsi bəni bə jwɛ́iŋ bəduli, chuku bɔ. ");
INSERT INTO cug_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ŋkuŋ Hɛlɔd nì wɔkɔ ntum wiwɔ kɔm Jisɔs, si bəni kɔ bɔ kiəni lɔ yɛli wi i di bichi wə, bəni bədɔkɔ dzaka fibɔ a, “Jisɔs wələ kɔ Jɔn Njulibɔkɔ si wi fiəni dza i kpi wə. Akɔ gia yə yi fə wi na ka wi kaŋaki ŋga i fəki gia yi kaŋyini yələ lə.” ");
INSERT INTO cug_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bədɔkɔ dzakayi fibɔ a, “Akɔ Ɛlaja si wi fiəni dzə.” Bədɔkɔ a, “Wi kɔ mi wi ntum wi Nyɔ widɔkɔ, wi num ka wi kikpu.” ");
INSERT INTO cug_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ayakalə, Hɛlɔd wɔkɔ gia yiwɔ yakadəiŋ ka dzaka mfih a, “Akɔ Jɔn Njulibɔkɔ wə mih nì gba bwili fwu wi si wi fiəni dza i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jɔn kɔ num Hɛlɔd mwi nì faaŋ bəni tsə kwa wi, fah i juŋ yi nsəŋ mə kɔm bə Hɛlɔdia kpə Filib wə wi nì kɔ waiŋnih Hɛlɔd, num Hɛlɔd nì kɔ wi dzɔ wi ka kpə wi. ");
INSERT INTO cug_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yi nì num yaka kɔm Jɔn nì kɔ wi dzaka i Hɛlɔd a, “Nchi ka bûm dəkə a mi kɔlə i dzɔ̂ kpə waiŋnih wi i kpə wi.” ");
INSERT INTO cug_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Si Jɔn nì dzakaki yakadəiŋ, Hɛlɔdia ka fasi wi i shɔm yi wə ka nəŋki dzəh i wɔɔ wi, kwati kə, ");
INSERT INTO cug_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","kɔm Hɛlɔd nì lwaki Jɔn a wi kɔ mi wi chəŋ wi chu num mi wi Nyɔ. Wi ka tɔkniki a bə ma wɔ̂ɔ wi. Hɛlɔd nì shiki wɔkɔliki gia yə Jɔn nì dzakaki, shɔm ka nyaki wi ŋgəkə nalə, yakadəiŋ wi ka wɔkɔki ndzɔŋni i wɔkɔliki gia yə wi dzakaki. ");
INSERT INTO cug_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Dzəh dzə baiŋ i Hɛlɔdia wə kpə Hɛlɔd, i jɔbi wə nyuwi nì fəki bini, wi bɔɔŋ bənji bu bəh kifwu ki bəni bə jum, bəh bəni bəmbum bəmbum bə Galili, i kwaka chɔkɔ biə bə nì bwɔ wi. ");
INSERT INTO cug_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Waiŋ Hɛlɔdia wi kpaŋni liə dzə nyaka bini bindzɔŋni i Hɛlɔd bəh bəni bu bə bini nshiŋ. Wi ka dzaka i waiŋ wiwɔ a, “Bîkə na finə fiə wɔ kɔŋki, ma mih ni fə̂ i wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wi chu dzi ŋkaiŋ dzaka a, “Bîkə na nə i mih, kɔŋ a numki na kiŋka ki tumi kəŋŋ, ma mih ni nya i wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Waiŋkpaŋni wiwɔ ka buku tsə bikə i nih wi a, “Mih dzaka a bə nyâ mih bəh nə?” Nih wi chukuli a, “Tsə̂ dzâka a bə nyâ fwu wi Jɔn Njulibɔkɔ i wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Wi ka kɔmsi fiəni tsə akisəkə, dzaka i Ŋkuŋ Hɛlɔd a, “Mih nəŋki a wɔ nyâ fwu wi Jɔn Njulibɔkɔ i mih i liə i nsaŋa wə.” ");
INSERT INTO cug_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ŋkuŋ wɔkɔ yaka, gwu kpi wi na bəh ŋga. Ayakalə, wi nəki nəiŋ kə gia yə wi nì dzaka, kɔm ŋkaiŋ biə wi nì kɔ wi dzi lɔ i bəni nshiŋ num bəni bə̀ bɔ nì kɔ i bini biwɔ wə, wi na chu kwuni ja yi yə wi nì dzaka i waiŋ wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wi ka faaŋ chinda akisəkə a wi tsə̂ dzə̂ bəh fwu wi Jɔn. Wi ka tsə i juŋ yi nsəŋ mə gba fwu wi Jɔn, ");
INSERT INTO cug_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","jiə i nsaŋa wə, dzə bəh wi nya i waiŋ wiwɔ. Wi dzɔ, buku fɛiŋ tsə nya i nih wi. ");
INSERT INTO cug_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Bwa bə mbaŋ bə Jɔn wɔkɔ, ka tsə dzɔ wini wi Jɔn ka ləə. ");
INSERT INTO cug_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Bwa bə faaŋni bə Jisɔs bə̀ fiəni dzə yɛiŋ wi, fuku gia yichi yə bɔ nì fə, bəh yə bɔ nì lâniki bəni yɛiŋ i wi. ");
INSERT INTO cug_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wi ka dza dzaka i bɔ a, “Mbɛiŋ dzə̂ a mbɛiŋ mbɛiŋ, bə yâka tsə i di biə bəni mɔŋ fɛiŋ wə, bə wâka twɛsi.” Wi nì dzaka yaka kɔm bəni bəduli nì dzəki i di biə bɔ nì kɔ, bədɔkɔ nì nyəki, bədɔkɔ dzə. Bɔ kɔbi na i kaŋa na jɔbi i dzi. ");
INSERT INTO cug_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Bə bɔ ka dza liə i ŋgwuki wə ka baka gwu a bɔ bɔ ka tsə i di biə bəni nì kɔkə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ayakalə, bəni bəduli yɛiŋ bɔ si bɔ nì tsəki, ka kiə bɔ, ka buku i kikwili kichi wə ka yɔ̂kɔ tə̂iŋ bɔ. Bɔ yisi tsə buku fɛiŋ, na ka Jisɔs bəh bwa bu bə mbaŋ tsə buku fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jɔbi wə Jisɔs nì tsə buku fɛiŋ kpa, wi yɛiŋ mbaŋ wi bəni lə maaa, nshɛiŋ kwa wi bəh bɔ, kɔm bɔ nì kɔ aka shwáŋ bə jîə mi wi tɔknini kɔ̂bi. Wi ka yisi i laniki bɔ bəh gia yiduli. ");
INSERT INTO cug_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jɔbi wə wɔŋ nì liəki tsəki, bwa bu bə mbaŋ dza dzə yɛiŋ wi ka dzaka a, “Fa kɔ i chwa num jɔbi tsə lɔ, ");
INSERT INTO cug_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","bêe bəni bələ ma bɔ tsə̂ i kikwili bəh i kidi ki kɔmsini wə fa, i tâŋ biɛiŋ bibɔ bidzini.” ");
INSERT INTO cug_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ayakalə, Jisɔs chukuli n'yi a, “Mbɛiŋ mwi nyâ bɔ bəh dzɛiŋ i dzî.” Bɔ bikə i wi a, “Wɔ nəŋki a buku tsə̂ nə̂ŋ bədanali gi yifa ka bə tâŋ biɛiŋ bidzini yɛiŋ i dzə̂ nyâ i bɔ ka bɔ dzi a?” ");
INSERT INTO cug_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisɔs bikə i bɔ a, “Mbɛiŋ kaŋaki chɔkɔ yi blɛd yi maiŋ? Mbɛiŋ tsə̂ tsɛ̂iŋ.” Bɔ tsə tsɛiŋ, ka fuku a, “Chɔkɔ yi blɛd yite bəh bwɔ́kɔ yifa.” ");
INSERT INTO cug_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jisɔs ka dzaka a bwa bu bə mbaŋ dzâka a bəni nûmyi i mfwaŋ wə i mbaŋ wə mbaŋ wə, i kaka kaka wə. ");
INSERT INTO cug_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ayakadəiŋ, bəni bəwɔ ka nûmyi i kuku i mbaŋ wə gbi gbi bədɔkɔ mbaŋshi mbaŋshi. ");
INSERT INTO cug_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jisɔs dzɔ chɔkɔ yi blɛd yə yite bəh bwɔkɔ yə yifa, tsɛiŋ yaka i bɛiŋ, nya kiyɔŋni i Nyɔ, ka gbɛyi nya i bwa bu bə mbaŋ, a bɔ gâa i bəni. Wi gaa tə bwɔkɔ yifa yə i bɔ bəchi. ");
INSERT INTO cug_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Bəni bəchi dzi fwuli. ");
INSERT INTO cug_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bwa bə Jisɔs bə mbaŋ juŋni biŋka bi blɛd bəh bwɔkɔ yə yi nì bɛsi, bi jikə káh jwɔfi ntsɔ yifa. ");
INSERT INTO cug_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Bəni bə̀ bɔ nì dzi biɛiŋ bidzini biwɔ nì kɔ bənyuku bənchuku bəte. ");
INSERT INTO cug_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jisɔs ka dzaka akisəkə a bwa bu bə mbaŋ lîə i ŋgwuki wə bɔ dâŋ tsə̂ i ninshiŋ i Besayda, wi baaŋ ka bɔni bəni a bɔ kwɛ̂. ");
INSERT INTO cug_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Si wi baaŋ bɔni bɔ yakadəiŋ, ka dza yaka i ŋkwuŋ bɛiŋ i tsa. ");
INSERT INTO cug_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Biŋ ji, ŋgwuki num lɔ i bɔkɔ kintəəŋ, Jisɔs kɛiŋ a ŋkwuŋ bɛiŋ wi mbɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wi yɛiŋ si bwa bu bə mbaŋ fumki bəh ŋgwuki, kɔm fiəkə nì dzəki i bɔ nshiŋ chini ŋgwuki wiwɔ. A num asi chɔkɔ wɔɔki dzəki wi nyə ka dzəki i bɔ wə, nyani i mwi bɛiŋ. Wi nì dzəki ka wi nəŋki i tsə daŋsi bɔ. ");
INSERT INTO cug_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bɔ ka yɛiŋ wi si wi nyaniki dzəki i mwi bɛiŋ, ka kwakaki a, akɔ ŋkwusa. Bɔ wam bəh ŋga, ");
INSERT INTO cug_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","kɔm bɔ bəchi nì yɛiŋ wi yaka ndzaŋ kwa bɔ. Akisəkə, Jisɔs ka dzaka i bɔ a, “Mbɛiŋ kâŋa shɔ́m, akɔ mih. Kiə mbɛiŋ ki lwâ kə akɔ mih.” ");
INSERT INTO cug_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Si wi dzaka yakadəiŋ, ka liə num i ŋgwuki mə bəh bɔ, fiəkə yiwɔ ka kpichumi. Ayaka bɔ tsɛiŋ lə, dzaka wɔm bɔ, ");
INSERT INTO cug_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","kɔm bɔ nì ka kiə dəkə gia yə chɔkɔ yi blɛd yə nì chusiki kɔm Jisɔs, num kɔm bɔ nì ka wɛli dəkə shɔ́m yibɔ. ");
INSERT INTO cug_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jɔbi wə bɔ nì daŋ bɔkɔ yə buku tsə i kimbu ki Genesalet wə, ka fasi ŋgwuki wiwɔ i bɔkɔ kpəŋ. ");
INSERT INTO cug_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Si bɔ nì buku i ŋgwuki wə, bəni bəduli ka kiə Jisɔs fɛiŋ akisəkə, ");
INSERT INTO cug_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","bɔ yɔkɔ tsə i bidi bibɔ bichi wə fɛiŋ, bwili bəni bə jwɛiŋ dzə bəh bɔ i di biə bɔ nì wɔkɔ a Jisɔs kɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na faiŋ Jisɔs nì tsəki, na i midini wə i chwa, nabə i kikwili kimbum wə nabə i kitumi wə, bəni ka dzəki bəh bəni bə jwɛiŋ i di biə bəni si juŋni, bɔ ka tsaki wi a bɔ kɔ̂m a jəŋ wi wimbuŋ. Mi wichi wə wi nì kɔmki wi, wi bɔnih a bɔnihni. ");
INSERT INTO cug_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Chɔkɔ bidɔkɔ Bəfalasi bəh bəni bədɔkɔ bə̀ bɔ nì laniki bənchi bə Nyɔ, nyə i Jɛlusalɛm dzə juŋni kɔmsi i Jisɔs kpəŋ. ");
INSERT INTO cug_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Bɔ dza yɛiŋ bwa bə mbaŋ bə Jisɔs bədɔkɔ bɔ dzi bəh kaŋ yi baiŋ kə, yi num a bɔ nì ka wɔkɔ dəkə kaŋ. ");
INSERT INTO cug_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Bəfalasi, na bəh Bəju bəchi si biəli a nɔni ki kwili ki bətii bəbɔ bə kikpu, a mi ma dzî fiɛŋ maka wi wɔ̂kɔ kaŋ si bɔ si shi wɔ̂kɔ. ");
INSERT INTO cug_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jɔbi wə mi kwɛ i shibɛiŋ wi kɔkə i dzi fiɛŋ maka wi wɔkɔ kaŋ yi bəh gvu yi i yəmaka dzə́h wə, na ka wi numki i dzi. Bɔ chu fə gia yidɔkɔ i nɔni ki kwili wə yiduli, ka i wɔkɔ kibwam bəh bətasa bəh kəŋə. ");
INSERT INTO cug_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Bəfalasi bəh bəni bə̀ bɔ nì laniki bənchi ka bikə i Jisɔs a, “Akɔ kɔm nə bwa ba bə mbaŋ biəliki kə nɔni ki kwili ki bətii bəbuku bə kikpu a? Akɔ kɔm nə wə bɔ dziki bəh kaŋ yi baiŋ kə a?” ");
INSERT INTO cug_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisɔs chukuli i bɔ a, “Isaya mi wi ntum wi Nyɔ nì dzâka ŋkɔŋ kɔm mbɛiŋ a mbɛiŋ kɔ bəni bə̀ bɔ dzakaki chi fə chi. Mbɛiŋ fə̂ki a gia yə wi nì nyaka a, Nyɔ dzakaki a, ‘Bəni bələ kɔksiki mih a bəh dzu yi dzaka, Shɔ́m yibɔ num nanu i mih wə. ");
INSERT INTO cug_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ntsa wibɔ i mih num a kilɔlɔ, kɔm bɔ dzɔki gia yə bəni kwakaki, lani a, akɔ ja yiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yi kɔ tə asi mbɛiŋ bee bənchi bə Nyɔ, ka kɔksiki num bə̀ a jiə bəni.” ");
INSERT INTO cug_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisɔs dzaka i bɔ a, “Mbɛiŋ tɔksiki kiəki lə na bindzɔŋ i nəiŋ bənchi bə Nyɔ ka mbɛiŋ biəliki num nɔni kimbɛiŋ ki kwili. ");
INSERT INTO cug_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yi kɔ a Muses nì nya nchi a, ‘Kɔ̂ksi ba wa bəh nih wa.’ Wi chu dzaka tə a, ‘Mi ka tɔyi ba wi nabə nih wi, bə wɔ̂ɔ wəmaka mi.’ ");
INSERT INTO cug_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ayakalə, mbɛiŋ dzakaki fimbɛiŋ a, ‘Mi kabə kaŋa fiɛŋ fiə wi kɔ i gamti ba wi nabə nih wi yɛiŋ, wi ka dza dzaka i ba wi nabə i nih wi a fiɛŋ fiwɔ kɔ Kɔban,’ yi num a fi si num lɔ fi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mbɛiŋ bum a wi ma chu fə gia yidɔkɔ i gamti ba wi nabə nih wi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mbɛiŋ fəki yakadəiŋ, fə ka gia yi Nyɔ fiəni chu gia yi kilɔlɔ kɔm nɔni kimbɛiŋ ki tumi kə mbɛiŋ laniki bəni yɛiŋ. Gia yiduli chu num tə yə mbɛiŋ fəki yaka.” ");
INSERT INTO cug_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisɔs chu bɔɔŋ mbaŋ wi bəni bɔ dzə, wi dzaka i bɔ a, “Mbɛiŋ bəchi wɔ̂kɔli gia yə mih dzakaki, ka mbɛiŋ wɔ̂kɔ kîə bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fiɛŋ fidɔkɔ mɔŋ i biŋ fiə fi kɔ i liə i mi wə fi num i jisi mi wiwɔ. Akɔ num fiɛŋ fiə fi bukuki i mi wə fi si jisi mi.  ");
INSERT INTO cug_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mi wə wi kaŋaki bintuni i wɔkɔ, wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisɔs ka bee bəni bəwɔ, liə i dzu, bwa bu bə mbaŋ ka bikə i wi kɔm ndi wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Wi chukuli i bɔ a, “Yaka mbɛiŋ tə ka wɔkɔ kiə dəkə a? Mbɛiŋ kiəki kə a fiɛŋ fiə fi bukuki i dzaka ki mi wə akɔ fi, fi si bəkəli mi wiwɔ a? ");
INSERT INTO cug_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yi num yakadəiŋ, kɔm fi si liə kə num i shɔm yi mi wiwɔ wə, fi si shi num i tɔɔ wi wə, na ka fi fiəni buku.” (Si Jisɔs nì dzaka yakadəiŋ, yi ka num a biɛiŋ bichi baiŋki lə). ");
INSERT INTO cug_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ayaka wi chu tsə a ninshiŋ bəh ndzaka a, “Akɔ fiɛŋ fiə fi bukuki i mi wə fi jisiki mi, ");
INSERT INTO cug_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","kɔm fiɛŋ fiə fi bəkəli mi, fi nyəki dzəki i shɔm yi wə. Fiɛŋ fiwɔ dzəki bəh biŋkwaka bichu i nɔni ki mi wiwɔ wə ka nɔni ki tɔkɔlini, bəh ji, bəh i wɔɔ mi, bəh i dzɔ kpə mi nabə nyum mi, ");
INSERT INTO cug_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","bəh i bukuki bəh dzəkəh i biɛiŋ wə, chu nyi ntəkə, bəh i fəki kinyɛŋ, bəh i ghəkəki, bəh i lɔɔki ja i bəni, ghaŋsi gwu, bəh i yuŋki. ");
INSERT INTO cug_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gia yichu yichi yələ kɔ yə yi jisiki shɔm yi mi ka wi bəkəki.” ");
INSERT INTO cug_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisɔs nì nyə fɛiŋ, tsə i kimbu ki tumi bi Taya wə bəh i bi Sidɔn. Si wi tsə fɛiŋ, liə i juŋ yidɔkɔ wə fɛiŋ nəki kɔŋ kə a mi widɔkɔ kələ i kiə a wi kɔ fɛiŋ. Ayakadəiŋ, bəni kɔbi i baaŋ ki kiə kə a wi kɔlə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Miŋkpaŋa widɔkɔ nì kɔlə fɛiŋ kiŋ'waka kichu num i waiŋ wi wi kpaŋni wə. Akisəkə wi wɔkɔ kɔm Jisɔs, ka tsə gbɔ i gvu yi wə. ");
INSERT INTO cug_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Miŋkpaŋa wiwɔ nì kɔ num mi wi Glik, a nì kɔkə mi wi Ju. Bə nì bwɔ wi i Fɔnishia i tumi ki Silia wə. Si wi gbɔ yaka, ka tsa Jisɔs a wi bwîli chinda wi ŋkpɛli wiwɔ i waiŋ wi wə. ");
INSERT INTO cug_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisɔs chukuli i wi a, “Bêe ma bə yisi sâŋ bwa, kɔm yi mɔŋ chəŋ i dzɔ dzɛiŋ bi bwa i lɔɔ i bíə.” ");
INSERT INTO cug_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Miŋkpaŋa wiwɔ chukuli i wi a, “Akɔ ŋkɔŋ ba wuŋ. Ayakalə, na bíə si dzi lə biŋka biə bi si gbɔyi i bwa kaŋ.” ");
INSERT INTO cug_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jisɔs ka dzaka i wi a, “Kɔm bə nchukuli wa, wɔ kɔlə i tsə̂ki mfia, chinda wi ŋkpɛli wiwɔ bee lɔ waiŋ wa.” ");
INSERT INTO cug_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Miŋkpaŋa wiwɔ nyə ka tsəki i wi dzu, ka tsə yɛiŋ waiŋ wi nɔ i naŋbɛiŋ num chinda wi ŋkpɛli wiwɔ buku lɔ i wi wə. ");
INSERT INTO cug_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisɔs nyə i kimbu ki Taya wə, tsə tɔli i Sidɔn ka chu tɔli i kimbu ki Tumi ki Jɔfi wə, ka dzə buku i kinchwɔ kimbum ki Galili wə. ");
INSERT INTO cug_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ayaka bəni bədɔkɔ nì nyə dzə bəh mi widɔkɔ num kinchini i wi, mi wiwɔ kiə kə i dzaka. Ayaka bɔ tsa Jisɔs a wi jiə kaŋ yi i mi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ayaka Jisɔs dzɔ wi, bəh wi buku i mbaŋ kintəəŋ. Wi jiə bwa bu bə kaŋ i bintuni bi mi wiwɔ wə, chuh midziŋ ka kɔm lɔm wi mi wiwɔ yɛiŋ, ");
INSERT INTO cug_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","tsɛiŋ bɛiŋ, ka cham, dzaka i wi a, “Ɛfata,” yi num a, “Wɛ̂li.” ");
INSERT INTO cug_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ayaka bintuni bi mi wiwɔ ka wɛli akisəkə, lɔm wi yaŋsi, wi yisi i dzakaki na bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisɔs ka kiŋ i bəni bəwɔ a bɔ ki fûku kə i mi widɔkɔ. Ayakalə, si wi nì kiŋ yakadəiŋ, bɔ ka tsə a ninshiŋ ninshiŋ i fukuki tsəki yi. ");
INSERT INTO cug_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dzaka ka wɔm bəni na bəh ŋga. Bɔ dza ka dzakayiki a, “Jisɔs kiəki lə i fə gia yichi na bindzɔŋ. Wi fəki binchini biə bi wɔkɔki kə bi wɔkɔ, biə bi dzakaki kə bi dzaka.” ");
INSERT INTO cug_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","A nì kɔ i kaŋ yiwɔ wə, mbaŋ wi bəni widuli widɔkɔ juŋni. Yi nì num yaka bɔ kaŋa kə biɛiŋ bidzini, Jisɔs bɔɔŋ bwa bu bə mbaŋ dzaka i bɔ a, ");
INSERT INTO cug_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mih kwasiki lə nshɛiŋ i mbaŋ wi bəni bələ, kɔm bɔ num bəh mih i kaŋ yitali wə, maka bɔ dzi fiɛŋ. ");
INSERT INTO cug_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mih ka dzaka a bɔ tsəki i kikwili kibɔ wə bəh dzɔŋ, ma bɔ ni tsə gbɔyi i dzəh, kɔm bədɔkɔ nyə i dzə́h yi dəəŋ wə” ");
INSERT INTO cug_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Bwa bu bə mbaŋ chukuli a, “Yi kɔ i liə a mi kɔ i dzɔ faiŋ biɛiŋ bidzini i fa chwa i saŋa bəni bələ yɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Wi ka bikə i bɔ a, “Mbɛiŋ kaŋaki chɔkɔ yi blɛd yi maiŋ?” Bɔ chukuli a, “Yi kɔ nanitaŋ.” ");
INSERT INTO cug_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jisɔs ka dzaka a mbaŋ wi bəni bəwɔ nûmyi kuku. Bɔ shinumyi, wi ka dzɔ chɔkɔ yi blɛd yə nanitaŋ, nya kiyɔŋni i Nyɔ, gbɛyi nya i bwa bu bə mbaŋ a bɔ gâa i bɔ. Ayaka bɔ ka gaa. ");
INSERT INTO cug_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Bɔ nì kaŋaki lə tə mibwɔkɔni midɔkɔ twɛsi. Wi dzɔ, nya kiyɔŋni i Nyɔ, dzaka a bɔ gâa i bəni bəwɔ. ");
INSERT INTO cug_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mi wichi dzi fwuli. Bɔ ka juŋni biŋka biə bi nì bɛsi, bi jikə káh nanitaŋ. ");
INSERT INTO cug_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Bəni bə̀ bɔ nì dzi a nì kɔ ka bəni bənchuku bənaa. ");
INSERT INTO cug_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Wi ka bee bɔ kwɛ. Wi liə i ŋgwuki mə akisəkə bəh bwa bu bə mbaŋ ka nyə tsə i kimbu ki Dalmanuta wə. ");
INSERT INTO cug_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Bəfalasi dza dzə i Jisɔs, ka yisi i gukuliki bəh wi, dzaka a wi fə̂ gia yə yi chusiki ŋga biə bi nyə i bɛiŋ. Ayaka bɔ nì dzakaki yaka mɔmsi lɔ wi mɔmsini. ");
INSERT INTO cug_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jisɔs cham na bəh ŋga, ka dzaka a, “Ŋgɔkɔ wələ nəŋki gia yə yi chusiki ŋga biə bi nyə bɛiŋ i fə nə a? Mih fukuki ŋkɔŋ i mbɛiŋ a mih ni lansi chusi kə gia yidɔkɔ i ŋgɔkɔ wələ.” ");
INSERT INTO cug_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wi ka dza bee bɔ, fiəni liə i ŋgwuki mə, ka daŋ tsə i waka widɔkɔ wəyaka wə. ");
INSERT INTO cug_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisɔs nì tsəki num bwa bu bə mbaŋ dali i dzɔ blɛd, kaŋa shəŋ a chɔkɔ yimu yə yi si baaŋ i ŋgwuki mə. ");
INSERT INTO cug_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wi ka təfiki bɔ dzakayi a, “Mbɛiŋ tɔ̂kniki, chu dzɔ̂ jɔbi i dzɔɔŋ yi Bəfalasi bəh yi Hɛlɔd.” ");
INSERT INTO cug_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Bwa bu bə mbaŋ yisi i dzakaki a bɔ bɔ kɔm gia yiwɔ, dzakayi a, “Wi dzakaki gia yi dzɔɔŋ yələ lə kɔm bukumbɛiŋ kaŋaki kə blɛd.” ");
INSERT INTO cug_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisɔs kiə gia yə bɔ dzakaki kɔm yi, ka dzaka i bɔ a, “Kɔm nə mbɛiŋ dzakaki a mbɛiŋ kaŋaki kə blɛd a? Yaka mbɛiŋ ka yɛiŋ kiə dəkə nabə i wɔkɔ kiə gia yiwɔ a? Yaka mfi bimbɛiŋ ka wɛli dəkə a? ");
INSERT INTO cug_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kɔm nə mbɛiŋ kaŋaki dzə́kəh mbɛiŋ kɔbi i yɛiŋ di a? Mbɛiŋ kaŋa bintuni kɔbi i wɔkɔ gia kɔm nə a? Mbɛiŋ kɔbi tə i kwakaki gia kɔm nə a? ");
INSERT INTO cug_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jɔbi wə mih ni gbɛyi chɔkɔ yi blɛd yə yite, bəni bənchuku bəte dzi fwuli, mbɛiŋ ni juŋni biŋka biə bi ni bɛsi bi jikə káh yimaiŋ a?” Ayaka bɔ ka chukuli a, “Jɔfi ntsɔ yifa.” ");
INSERT INTO cug_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Wi ka chu bikə, “Kɔm bə chɔkɔ yə nanitaŋ bəni bənchuku bənaa si dzi, mbɛiŋ si juŋni biŋka biə bi si bɛsi bi jikə káh yimaiŋ a?” Ayaka bɔ ka chukuli a, “Nanitaŋ.” ");
INSERT INTO cug_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wi ka bikə i bɔ a, “Yaka mbɛiŋ kɛiŋki maka mbɛiŋ wɔkɔ kiə gia yiwɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jisɔs bə bwa bu bə mbaŋ daŋ buku i Besayda, bəni bədɔkɔ dzə bəh kifəkə kidɔkɔ i wi ka tsaki a wi kɔ̂m shəŋ wi a bəh kaŋ ka wi bɔnih. ");
INSERT INTO cug_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisɔs kaŋa wi i tsɛiŋ wə ka dzɔ buku bəh wi i kwili kintəəŋ. Wi chuh midziŋ i dzə́kəh yi wə, jiə kaŋ i wi wə ka bikə i wi a, “Wɔ yɛiŋ lə fiɛŋ fidɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ayaka kifəkə kiwɔ giŋsi dzə́kəh i bɛiŋ, tsɛiŋ di ka dzaka i wi a, “Mih yɛiŋ bəni bɔ num aka kɛiŋ bɔ nyani.” ");
INSERT INTO cug_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisɔs chu jiə kaŋ i dzə́kəh yi mi wiwɔ wə, mi wiwɔ tsɛiŋ lə tulululu, dzə́kəh yi baiŋ, wi ka yɛiŋki biɛiŋ bichi na bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisɔs ka dzaka i wi a, “Kwɛ̂ dzu, asi wɔ tsəki kiə wɔ ki fəini lîə kə i kwili wə.” ");
INSERT INTO cug_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisɔs bəh bwa bu bə mbaŋ nyə fɛiŋ ka nyaniki taliki i kidi ki Kaysalia Filibi wə. Si bɔ nì tsəki i dzəh, wi bikə i bɔ a, “Bəni dzakaki a mih kɔ ndə?” ");
INSERT INTO cug_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Bɔ chukuli i wi a, “Bəni bədɔkɔ dzakaki a wɔ kɔ Jɔn Njulibɔkɔ, bədɔkɔ a Ɛlaja, bədɔkɔ dzaka a wɔ kɔ mi wi ntum wi Nyɔ widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wi ka fiəni bikə i bɔ a, “Mbɛiŋ dzakaki yimbɛiŋ a mih kɔ ndə?” Bita chukuli a, “Wɔ kɔ Kimbwili wə Nyɔ nì kaka.” ");
INSERT INTO cug_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jisɔs ka kiŋ a bɔ ki mɔ̂m kə i fûku yi i mi. ");
INSERT INTO cug_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wi ka yisi i laniki bwa bu bə mbaŋ dzaka kɔm gwu yi a, “Mi wə yɛli wi kɔ Waiŋmi kaŋaki i bi yɛiŋ bəŋgəkə bəduli, ma bəni bə̀ bɔ sakaki tumi bəh bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ bɔ bi nəiŋ wi. Bɔ bi wɔɔ wi, i kaŋ yitali wə Nyɔ bi fiəni dzasi wi i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wi nì fuku baŋsi gia yələ i bwa bu bə mbaŋ nshiŋ. Bita ka dzɔ wi, bɔ wi baka gwu, wi ka yisi i yɔliki i wi i gia yiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jisɔs fiəni gwu, tsɛiŋ bwa bu bə mbaŋ, wam kaŋyi Bita dzaka i wi a, “Fîəni mih chɛiŋ Satan! Wɔ yɛiŋki gia ka mi wiwɔm. Wɔ yɛiŋki kə si Nyɔ yɛiŋki.” ");
INSERT INTO cug_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ayaka wi ka bɔɔŋ mbaŋ wi bəni bəh bwa bu bə mbaŋ, dzaka i bɔ a, “Na ndə wə wi nəŋki i biəliki mih, wi kaŋaki i nə̂iŋ gwu yi, i gîŋ kintasi ki i bîəliki mih. ");
INSERT INTO cug_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mbɛiŋ kîəki a mi wə wi tɔkniki bəh nɔni ki wi kîəki a wi bi laksiki num laksini. Ayakalə, mi wə wi laksi nɔni ki kɔm mih bəh kɔm ntum wi ndzɔŋni, wi kɛiŋsi jiə num jiəni. ");
INSERT INTO cug_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Bə ka juŋni na mbi wələ wichi ka nya a mi dzi, wi num i ni laksi nɔni ki, ma mbee wiwɔ ni numki na nə a? ");
INSERT INTO cug_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Fiɛŋ fiə mi kɔ i təiŋ fwu wi yɛiŋ akɔ nə a? ");
INSERT INTO cug_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mbɛiŋ kîə a mi kabə ŋgəmni i biəli mih bəh gia yiŋ i ŋgɔkɔ wichu wələ kintəəŋ wə wi kɔ aka bəni bə̀ bɔ tɔkliki i biŋ, wi kîəki a mi wə yɛli wi kɔ Waiŋmi bi bɔŋ ŋgəmni lə tə bəh wəmaka mi i jɔbi wə wi bi fiəni dzəki i mbum bi wə, biə bi kɔ bi Ba wi bəh bəchinda bə Nyɔ bə baiŋni.” ");
INSERT INTO cug_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisɔs chu dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, bəni bədɔkɔ kɔlə fa bɔ kɔbi i bi musi kpi maka bɔ yɛiŋ ŋkuŋ bi Nyɔ bi dzə bəh ŋga bi.” ");
INSERT INTO cug_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Asi kaŋ nì tsə yisɔ, Jisɔs dzɔ Bita bəh Jɛm bəh Jɔn bəh bɔ yaka tsə i ŋkwuŋ wi dəəŋ widɔkɔ bɛiŋ, ka numki fɛiŋ a bɔ bɔ. Bɔ dzaka a bɔ tsɛiŋ, yɛiŋ num kimbwɔsi ki kwuni i bɔ nshiŋ, ");
INSERT INTO cug_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","bəmbuŋ i gwu yi wə fuku ŋwaŋyi na tsə si mi kɔ i wɔkɔ fa kuku a wi baiŋ yaka. ");
INSERT INTO cug_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","I fɛiŋ wə bɔ dza yɛiŋ num Ɛlaja bəh Muses təkəli tumbuku i bɔ nshiŋ, ka dzakaki bɔ bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bita dza təkəli dzaka i Jisɔs a, “Tikwili, yi si ndzɔŋki lə a bukumbɛiŋ numki fa. Bee ma buku maa bintaŋ bitali, kidɔkɔ num ŋka, kidɔkɔ num ki Muses, kidɔkɔ num ki Ɛlaja.” ");
INSERT INTO cug_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wi nì dzakaki yakadəiŋ kɔm ndzaŋ nì kɔ bi kwa bɔ na bəh ŋga wi chu kiə kə gia yə wi kɔ i dzaka. ");
INSERT INTO cug_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Asi wi dzaka yakadəiŋ, bikwu dza dzə baaŋ bɔ, ja dzaka dzə i bikwu biwɔ kintəəŋ a, “Wələ kɔ Waiŋ wuŋ, wi num shɔm yiŋ. Mbɛiŋ wɔ̂kɔki num i wi.” ");
INSERT INTO cug_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bɔ dzaka a bɔ tsɛiŋ na chu yɛiŋ i bəni bəwɔ wə, yɛiŋ num a Jisɔs shəŋ. ");
INSERT INTO cug_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Si bɔ nì nyə i ŋkwuŋ wiwɔ bɛiŋ ka shiki dzəki, Jisɔs kiŋ i bɔ a kiə bɔ ki fûku kə gia yə bɔ yɛiŋ i mi, maka mi wə yɛli wi kɔ Waiŋmi dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Bɔ wɔkɔ yakadəiŋ ka jiə yi a bɔ shɔm, ka dzakayiki a bɔ bɔ, ayakalə ndzaka wələ kɔm ndza wi kpi chusiki a nə. ");
INSERT INTO cug_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bɔ ka dza bikə i Jisɔs a, “Akɔ kɔm nə wə bəni bə̀ bɔ laniki bənchi dzakaki a Ɛlaja kaŋaki i bi yisi dzə i Kimbwili wə Nyɔ nì kaka a?” ");
INSERT INTO cug_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisɔs chukuli i bɔ a, “Akɔ ŋkɔŋ, Ɛlaja kaŋaki i bi yisi dzə i kɛiŋsi gia yichi a yi fiəni num asi yi nì kɔ. Ayakalə, akɔ kɔm nə bə nì nyaka a mi wə yɛli wi kɔ Waiŋmi kaŋaki i bi yɛiŋ bəŋgəkə bəduli, ka bəni məŋni wi a? ");
INSERT INTO cug_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ayakalə, mih fukuki i mbɛiŋ a Ɛlaja dzə lɔ, ayaka bəni fə a gia yə bɔ kɔŋki bəh wi. Yi num asi bə nì nyaka kɔm wi.” ");
INSERT INTO cug_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jɔbi wə Jisɔs bəh bwa bu bə mbaŋ bə̀ nì shi dzə buku i bwa bu bə mbaŋ bədɔkɔ bə̀ wə, yɛiŋ mbaŋ wi bəni wimbum num wi fiəli baŋsi bɔ, bəni bədɔkɔ bə̀ bɔ nì laniki bənchi bə Nyɔ gukuli bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Akisəkə asi mbaŋ wichi nì yɛiŋ Jisɔs, təkəli nalə ka sɛiŋ a bɔ bəchi, yɔkɔ tsə i bɔnih i wi. ");
INSERT INTO cug_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Wi bikə i bɔ a, “Mbɛiŋ gukuliki kɔm nə?” ");
INSERT INTO cug_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mi widɔkɔ i mbaŋ kintəəŋ chukuli wi a, “Mi wi lanini, mih si dzə bəh waiŋ wuŋ i wɔ, kɔm kiŋ'waka kidɔkɔ kɔ i gwu yi wə, num ki fə wi, wi chu kinchini. ");
INSERT INTO cug_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kiŋ'waka kiwɔ si chufi lɔɔ wi i kuku, bifu ka bukuki i dzaka ki wə wi dzi jəŋ, wi dza ləkə kɔbi i chu ŋgwuŋ. Mih ka dzaka a bwa ba bə mbaŋ bwîli kiŋ'waka kiwɔ, bɔ mɔmsi wɔkɔ mɔŋ.” ");
INSERT INTO cug_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisɔs wɔkɔ yakadəiŋ, dzaka i bɔ a, “Ɔɔɔ! Ŋgɔkɔ wələ wi kɛiŋki maka wi jiə shɔm i Nyɔ. Mih kɔ num bəh mbɛiŋ i tsə buku dəiŋ a? Mih ni kaŋa shɔm bəh mbɛiŋ i tsə buku dəiŋ na? Mbɛiŋ dzə̂ nyâ waiŋ wiwɔ i mih fa.” ");
INSERT INTO cug_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Bɔ ka dzɔ dzə bəh waiŋ wiwɔ i Jisɔs. Si kiŋ'waka kiwɔ yɛiŋ Jisɔs, ka chufi waiŋ wiwɔ akisəkə wi gbɔ i kuku ka jwɔki fɛiŋ, bifu buku i dzaka ki wə. ");
INSERT INTO cug_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisɔs bikə i tii waiŋ wiwɔ a, “Gia yələ nì yisi wi yibwiŋ na?” Wi chukuli a, “Yi nì yisi wi, wi kɛiŋ a waiŋ. ");
INSERT INTO cug_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kiŋ'waka kiwɔ si dza chufi lɔɔ wi i gbuku wə i jɔbi jɔbi wə bəh i mwi mə lansi nəŋ a bəkəli wi. Wɔ kabə num i fə gia, mntee, wɔ kwâsi nshɛiŋ i buku, wɔ gâmti buku.” ");
INSERT INTO cug_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisɔs bikə i wi a, “Yaka mih kɔlə i fə gia yidɔkɔ a? Gia yichi kaŋaki lə dzəh i mi wə wi jiə shɔm.” ");
INSERT INTO cug_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Akisəkə tii waiŋ wiwɔ ka wam bəh ŋga a, “Mih jiə shɔm i Nyɔ. Fə̂ ma mih jiə tsə yaka.” ");
INSERT INTO cug_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jɔbi wə Jisɔs nì yɛiŋ a mbaŋ wi bəni yɔkɔki juŋniki dzəki i wi wə, wi wam kaŋyi kiŋ'waka ki ŋkpɛli kiwɔ dzaka i ki a, “Wɔ, kiŋ'waka ki ŋkpɛli kələ ki fəki a waiŋ wələ ma dzakaki chu wɔkɔ kə tə gia, mih dzakaki i wɔ, bûku i waiŋ wələ wə, wɔ tsə̂ki. Kiə wɔ bi ma fiə̂ni lîə i gwu yi wə.” ");
INSERT INTO cug_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ayaka kiŋ'waka kiwɔ wam bəh ŋga, chu chufi lɔ waiŋ wiwɔ i dzəh yichu wə, ka buku i gwu yi wə. Wi ka nɔ i kuku ka kiŋkpili ki mi. Si bəni bəduli yɛiŋ yakadəiŋ, ka dzakaki a, “Wi kpi lɔ.” ");
INSERT INTO cug_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jisɔs ka kaŋa wi i tsɛiŋ wə giŋsi wi, wi dza num i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jisɔs bəh bwa bu bə mbaŋ ka tsə liə i dzu, bɔ bikə i wi i jum wə jum wə a, “Akɔ kɔm nə wə buku si mɔmsi wɔkɔ mɔŋ i bwili chinda wi ŋkpɛli wiwɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Wi chukuli i bɔ a, “Fiɛŋ fiə fi kɔ i bwili ŋkaiŋni wi chinda wiwɔ kɔ a ntsa shəŋ. Fiɛŋ fidɔkɔ chi chi mɔŋ i bwili.” ");
INSERT INTO cug_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Bɔ nyə fɛiŋ tsə dzəh i Galili, Jisɔs kɔŋ kə a mi widɔkɔ kiə di biə bɔ kɔ, ");
INSERT INTO cug_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","kɔm wi nì nyaniki tsəki wi lani tsə bwa bu bə mbaŋ. Wi nì laniki bɔ a bəni bi nya lə mi wə yɛli wi kɔ Waiŋmi i kaŋ yi bəni a bɔ wɔɔ wi. Bɔ ka bi wɔɔ wi, ma a bi numki i kaŋ yitali wə, wi bi dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Si wi dzaka yakadəiŋ, bɔ nəki wɔkɔ kiə kə gia yə wi dzakaki ayakalə, bɔ ka lwaki i bikə. ");
INSERT INTO cug_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Bɔ dzə buku i Kafanaum, i jɔbi wə wi liə num i dzu wi bikə i bɔ a, “Mbɛiŋ si gukuliki i dzəh a nə?” ");
INSERT INTO cug_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bɔ kpichumi mɔŋ, kɔm bɔ nì nyaniki i dzəh gukuli a bɔ bɔ a, mi wimbum i bɔ kintəəŋ kɔ ndə a. ");
INSERT INTO cug_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisɔs num kuku, bɔɔŋ bɔ bəchi jwɔfi ntsɔ bəfa, dzaka i bɔ a, “Mi wə wi nəŋki i num mi wi ninshiŋ, wi kaŋaki i dzɔ̂ki gwu yi ka mi wi jum wə bəh ka mi wə wi nɔmki i bəni bəchi.” ");
INSERT INTO cug_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Si wi dzaka yakadəiŋ, ka dzɔ waiŋ wi nchiŋ tɔm i bɔ kintəəŋ, ka chu giŋ kumi wi i tsɛiŋ yi wə ka dzaka i bɔ a, ");
INSERT INTO cug_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mi wə wi dzɔ waiŋ wələ kɔm bəh yɛli wuŋ, yaka wi dzɔ num mih. Mi wə wi dzɔ mih, wi ka dzɔ dəkə num mih, wi dzɔ num mi wə wi faaŋ mih.” ");
INSERT INTO cug_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jɔn dzaka i wi a, “Mi wi lanini, buku si yɛiŋ mi widɔkɔ wi bwili bəchinda bə ŋkpɛli i bəni wə i yɛli wa wə, buku ka kaŋyi wi, kɔm wi kɔkə mi wibuku wi mbaŋ widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisɔs ka chukuli i bɔ a, “Kiə mbɛiŋ ki chî kə wəmaka mi. Mbɛiŋ kîə a mi wə wi fəki gia yi kaŋyini bɔɔŋ num yɛli wuŋ, wi kɔkə i chu dzakaki gia yichu kɔm mih. ");
INSERT INTO cug_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mi kabə jwɔki kə bukumbɛiŋ, yaka wi tɔbiki lə bukumbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mih fukuki ŋkɔŋ i mbɛiŋ a, na ndə wə wi nya na bwam wi mwi i mbɛiŋ i mu i yɛli wuŋ wə, bəh kɔm tə a mbɛiŋ kɔ bəni bə Klistus, wəmaka mi kɔkə i bi laksi mmakti wi.” ");
INSERT INTO cug_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisɔs ka chu dzaka a, “Na ndə wə wi fə a waiŋ wimu i mbaŋ wi bwa bəŋ bələ kintəəŋ bɔ jiə shɔm yibɔ i mih fə chu, ma yi ndzɔŋki a bə shû shə̂ŋsi nəkə wimbum i məkə ki wəmaka mi wə, bə chîni shî wi i kinchwɔ kimbum wə. ");
INSERT INTO cug_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Yi chu num a, tsɛiŋ ya kabə fəki a wɔ fə chu, wɔ tə̂iŋ bwîli tsɛiŋ yiwɔ. Yi ndzɔŋki a wɔ liə i nɔni kə ki bi tsə kaa kə bəh tsɛiŋ yimu, kɔbi a wɔ kaŋaki tsɛiŋ yichi bə num i bi lɔɔ wɔ i gbuku wimbum mə, wi kɔbi i bi nyumi. ");
INSERT INTO cug_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Gbu wa kabə fəki a wɔ fə chu, wɔ tə̂iŋ bwîli gbu wiwɔ. Yi ndzɔŋki a wɔ liə i nɔni kə ki bi tsə kaa kə bəh gbu wimu, kɔbi a wɔ kaŋaki gvu yichi bə num i bi lɔɔ wɔ i gbuku wimbum mə. ");
INSERT INTO cug_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Dzəkəh wa kabə fəki a wɔ fə chu, wɔ kâmbwili dzəkəh wiwɔ. Yi ndzɔŋki a wɔ liə i ŋkuŋ bi Nyɔ wə bəh dzəkəh wimu, kɔbi a wɔ kaŋaki dzə́kəh yichi, bə num i bi lɔɔ wɔ i gbuku wimbum mə. ");
INSERT INTO cug_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Di biələ kɔ num n'yíŋ yə yi si kpiyi kə num fɛiŋ dzi bəni, gbuku wə wi si nyumi kə num fɛiŋ fisi bɔ. ");
INSERT INTO cug_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Mbɛiŋ kîəki a gbuku bi kɔmki mi wichi asi bə si fiaŋsi fiɛŋ bəh ŋkaka. ");
INSERT INTO cug_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ŋkaka kɔ fiɛŋ fi ndzɔŋni, ayaka yi ka laksi njwɔŋni bi bə kɔ i chu fə na dəiŋ ka yi chu fiəni njwɔŋki a? Mbɛiŋ numki aka ŋkaka yə yi njwɔŋki, mbɛiŋ num bəh bəni i mbɔiŋni wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisɔs dza fɛiŋ, tsə i kimbu ki tumi ki Judea wə, daŋ Bɔkɔ yi Jɔdan ka tsə i kiwuŋ. Mbaŋ wi bəni ka chu juŋniki dzəki i wi kpəŋ, wi ka laniki bɔ asi wi nì shiki wi lani. ");
INSERT INTO cug_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Bəfalasi dza dzə i mɔmsi wi, ka bikə i wi a, “Nchi bumki lə a mi kɔlə i kɔ̂ŋŋ kpə wi a?” ");
INSERT INTO cug_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisɔs fiəni bikə tə i bɔ a, “Muses nì nya nchi a mbɛiŋ fə̂ki dəiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Bɔ chukuli a, “Muses nì kɔ wi bêe a mi kɔlə i bee kpə wi. Jɔbi wə wi bee, wi nyâka kiŋwakti ki chusi a ŋgaiŋ bee wi, wi nyâ i wi.” ");
INSERT INTO cug_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisɔs chukuli i bɔ a, “Akɔ kɔm kifwu kimbɛiŋ kiləkəli ka Muses nyaka nchi wələ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ayakalə, a nì kɔ i kin'yisi ki mbi wə Nyɔ nì maa num minyuku bəh miŋkpaŋa. Si wi maa yakadəiŋ ka dzaka a, ");
INSERT INTO cug_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Akɔ kɔm yələ minyuku bi bêe ba wi bəh nih wi wi chîŋni bəh kpə wi, ");
INSERT INTO cug_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ayaka ma bɔ bəfa bi fiəni num i mi wimu wə.’ Ayakadəiŋ, bɔ bi chu num kə ka bəni bəfa, bɔ bi numki i mi wimu. ");
INSERT INTO cug_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yi kɔ a, fiɛŋ fiə Nyɔ kɔ wi chiŋni lɔ, kiə mi bi mɔ̂m kə i gâli.” ");
INSERT INTO cug_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jɔbi wə Jisɔs bəh bwa bu bə mbaŋ nì kɔ dzu, bɔ chu bikə i wi kɔm gia yiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wi chukuli i bɔ a, “Na ndə wə wi bee kpə wi ka dzɔ widɔkɔ, yaka wi fə chu i kpə wi i nɔki bəh miŋkpaŋa widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Miŋkpaŋa ka buku nyuwi, tsə dzɔ minyuku widɔkɔ, yaka wi fə chu, i tsə nɔki bəh minyuku widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Bəni nì dza ka dzəki bəh bwa i Jisɔs a wi kɔm bɔ a bəh kaŋ, bwa bu bə mbaŋ kabə kaŋyi bɔ. ");
INSERT INTO cug_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jɔbi wə Jisɔs nì yɛiŋ yakadəiŋ, shɔm bɔkɔ wi, wi dzaka i bɔ a, “Mbɛiŋ bêe ma bwa bəwɔ dzə̂ki i mih wə, kiə mbɛiŋ ki chî kə bɔ, kɔm ŋkuŋ bi Nyɔ kɔ num i bəni ka bələ. ");
INSERT INTO cug_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mih fukuki ŋkɔŋ i mbɛiŋ a, mi wə wi ka dzɔ dəkə ŋkuŋ bi Nyɔ ka waiŋ wi nchiŋ wələ, wi mɔŋ i bi liə i bi wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Si wi dzaka yakadəiŋ, dzɔ kumi bɔ, jiə kaŋ i bɔ wə, bɔiŋsi bɔ. ");
INSERT INTO cug_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisɔs dza a ŋgaiŋ nyə wə, mi widɔkɔ yɔkɔ dzə tum binyu i wi nshiŋ ka dzaka a, “Mi wi Lanini, wɔ wə wɔ kɔ mi wi ndzɔŋni, gia yə mih kaŋaki i fə̂ ka mih ni kwati nɔni kə ki bi tsə kaa kə kɔ na nə a?” ");
INSERT INTO cug_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisɔs chukuli i wi a, “Wɔ bɔɔŋ mih a mi wi ndzɔŋni kɔm nə? Mi widɔkɔ kɔkə wə wi ndzɔŋki. A kɔbi a Nyɔ shəŋ wə wi ndzɔŋki. ");
INSERT INTO cug_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ntə wɔ kiəki lə bənchi bə Nyɔ bə̀ bɔ dzakaki a, ‘Kiə wɔ ki wɔ̂ɔ kə mi, kiə wɔ ki nɔ̂ kə bəh kpə mi, kiə wɔ ki chwɔ̂ kə, kiə wɔ ki bêeŋ kə nsaka wi ntəkə, kiə wɔ ki fə̂ kə kimfikili, bəh wə a wɔ kɔ̂ksi ba wa bəh nih wa?’” ");
INSERT INTO cug_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mi wiwɔ chukuli i Jisɔs a, “Mi wi lanini, bənchi bələ bəchi kɔ num mih nì jiəki lə bɔ i yisi si mih nì kɛiŋki waiŋ wi sumi.” ");
INSERT INTO cug_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisɔs bwaŋ dzəkəh i wi wə lə tulululu, kɔŋ wi, ka dzaka i wi a, “Fiɛŋ fidɔkɔ baaŋ fimu fiə wɔ kɛiŋki i fə̂. Tsə̂ tâŋni biɛiŋ bia bichi biə wɔ kaŋaki, ma wɔ gâa kpɔ wiwɔ i bəni bə kifuu, ka wɔ bi kwati mbum num i tumi ki bɛiŋ wə. Wɔ ka fə yakadəiŋ, wɔ dzə̂ bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Si Jisɔs dzaka yakadəiŋ, mi wiwɔ wɔkɔ yaka shi wuuŋ wi i fuŋ, wi fiəni gwu ka tsəki num a nshɛiŋ nshɛiŋ, kɔm wi nì kaŋaki lə mbum nalə. ");
INSERT INTO cug_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisɔs dza fiəni gwu tsɛiŋ tali bwa bu bə mbaŋ, dzaka i bɔ a, “Yi ləkəki lə na bəh ŋga i bəni bə kpɔ i bi liə i ŋkuŋ bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ndzaka wiwɔ fumsi bwa bu bə mbaŋ. Jisɔs ka chu dzaka i bɔ a, “Bwa bəŋ, yi ləkəki lə na bəh ŋga i mi i liə i ŋkuŋ bi Nyɔ wə! ");
INSERT INTO cug_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yi bɔniki alə i kikum i liə i dzəŋə yi nsala wə, tsə si mi wi kpɔ kɔ i liə i ŋkuŋ bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bɔ wɔkɔ yaka, yi fumsi bɔ na bəh ŋga, bɔ ka dzakayiki a bɔ bɔ a, “Aka bə num yaka, ma ndə bi bɔiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisɔs fiəni tsɛiŋ bɔ lə, ka dzaka i bɔ a, “Yələ ləkəki alə i mi wiwɔm, ayakalə i Nyɔ gia yidɔkɔ kɔkə yə yi ləkəki i wi.” ");
INSERT INTO cug_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bita ka dza dzaka i Jisɔs a, “Tsɛ̂iŋ, buku bee biɛiŋ bichi ka biəliki wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jisɔs chukuli i wi a, “Mih fukuki ŋkɔŋ i wɔ a, Mi kɔkə wə wi bee juŋ yi, nabə bwa bə nih wi, nabə jɛ́mi yi, nabə nih wi, nabə ba wi, nabə bwa bu, nabə khə wi, a wi bee kɔm mih bəh kɔm ntum wi ndzɔŋni wi Nyɔ, ");
INSERT INTO cug_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a wi bi num wi kaŋa kə júŋ bəh bwa bə nih wi, bəh jɛ́mi yi, bəh nih wi, bəh bwa, bəh kikhə kiŋkani gbi tsə si wi nì kaŋaki. Ayaka bəni bi bwaŋki lə gvu tə i wi chɛiŋ, i jɔbi wi dzəni wə, wi bi kwati nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ayakalə, bəni bəduli bə̀ bɔ kɔ i ninshiŋ i liə bi numki num i jum wə, bəduli bə̀ bɔ kɔ i jum wə i liə bi numki num i ninshiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisɔs bəh bwa bu bə mbaŋ ka chu dza kwa dzəh, ka yakaki tsəki i Jɛlusalɛm wi tsə i ninshiŋ. Ayaka bwa bu bə mbaŋ num bəh ŋkaiŋyi. Bəni bə̀ bɔ nì biəliki wi tə bə́ lwa. Jisɔs chu dzɔ bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa bəh bɔ baka gwu wi fuku i bɔ gia yə yi ni num bəh wi. ");
INSERT INTO cug_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wi dzaka i bɔ a, “Mbɛiŋ wɔ̂kɔli, bukumbɛiŋ si yaka tsə i Jɛlusalɛm, bə num i tsə nya mi wə yɛli wi kɔ Waiŋmi i kaŋ yi bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ, bɔ ni saka təiŋ nsaka wi a bə wɔ̂ɔ wi, ka bɔ nya i kaŋ yi tumi wə, ");
INSERT INTO cug_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ayaka bɔ ni tɔyi wi, chuhyi midziŋ i gwu yi wə, bə twɛiŋ wi, bə wɔɔ wi, a bi ka num i kaŋ yitali wə, wi bi dza i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jɛm bəh Jɔn bə̀ bɔ nì kɔ bwa bə Sɛbide, dza dzə yɛiŋ Jisɔs ka dzaka i wi a, “Mi wi lanini, gia yidɔkɔ kɔlə yə buku nəŋki a wɔ fə̂ i buku.” ");
INSERT INTO cug_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Wi bikə i bɔ a, “Mbɛiŋ nəŋki a mih fə̂ nə i mbɛiŋ?” ");
INSERT INTO cug_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Bɔ chukuli a, “Buku nəŋki a jɔbi wə wɔ bi numki i mbum bia wə, ma buku bi num i biŋgbɔkɔ bimbum wə, mi widɔkɔ i tsɛiŋ ya yiləkəli wə, widɔkɔ i yi kimiəkə wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisɔs chukuli i bɔ a, “Mbɛiŋ kiəki kə gia yə mbɛiŋ bikəki. Mbɛiŋ kɔlə i bi mu bwam wi ŋgəkə wə mih bi mu, nabə i liə i ŋkaiŋni wi ŋgəkə wimbum wə mih bi liə yɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Bɔ chukuli a, “Buku kɔlə i fə.” Jisɔs dzaka i bɔ a, “Mbɛiŋ kɔlə i mu bwam wi ŋgəkə wə mih ni mu, bəh i liə tə i ŋkaiŋni wi ŋgəkə wimbum wə mih bi liə yɛiŋ, ");
INSERT INTO cug_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ayakalə i shinum i kimbu kəŋŋ ki tsɛiŋ yiləkəli wə nabə i yi kimiəkə wə a kɔkə di biŋ i nya i mi. Di biwɔ kɔ i bəni bə̀, bə nì kɛiŋsi di biwɔ i bɔ.” ");
INSERT INTO cug_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jɔbi wə kiŋka ki bwa bə mbaŋ bə Jisɔs bə̀ jwɔfi bɔ nì wɔkɔ kɔm gia yiwɔ bɔksi tɔɔ i Jɛm bəh Jɔn. ");
INSERT INTO cug_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisɔs bɔɔŋ bɔ bəchi, ka dzaka i bɔ a, “Ntə mbɛiŋ kiəki lə a bəni bə̀ bɔ sakaki kitumi ki bəni bədɔkɔ si yaka num i bəni bəbɔ bɛiŋ, bəni bəmbum bəbɔ chusi ŋga bibɔ i bɔ bɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yəmaka kaŋaki kə i numki yakadəiŋ i mbɛiŋ kintəəŋ. Mi wə wi nəŋki i num mi wimbum i mbɛiŋ kintəəŋ wi kaŋaki i nûm wə wi nɔmki num nɔmni i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Mi wə wi nəŋki i num mi wi ninshiŋ i mbɛiŋ kintəəŋ, wi kaŋaki i nûmki mfa wi mi wichi. ");
INSERT INTO cug_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mbɛiŋ kîəki a mi wə yɛli wi kɔ Waiŋmi nì ka dzə dəkə a bə nɔ̂mki i wi. Wi nì dzə i nɔmki i bəni, i nya nɔni ki ka n'yɛlih i yɛlih bəni bəduli i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Bɔ nyani tsə buku i kwili wi Jɛliku wə. Jɔbi wə Jisɔs nì nyəki fɛiŋ bəh bwa bu bə mbaŋ bəh mbaŋ wi bəni wimbum, kifəkə kidɔkɔ shi num a dzə kpəŋ nywa biɛiŋ, yɛli wi num Batimayus, waiŋ Timayus. ");
INSERT INTO cug_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jɔbi wə wi si wɔkɔ a akɔ Jisɔs wi Nasali, wi yisi ka wamki bəh ŋga a, “Jisɔs, waiŋ Ŋkuŋ Dɛbit kwâsi nshɛiŋ i mih.” ");
INSERT INTO cug_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Bəni bəduli dza yisi i kaŋyi wi dzaka a wi bâŋ. Ayakalə, wi chu fiəni wam na bəh ŋga a, “Waiŋ Ŋkuŋ Dɛbit kwâsi nshɛiŋ i mih.” ");
INSERT INTO cug_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jisɔs ka num, ka dzaka a bə bɔɔŋ wi. Bɔ bɔɔŋ kifəkə kiwɔ, ka dzaka i wi a, “Kâŋa shɔm, dzâ bɛiŋ, wi bɔɔŋki wɔ.” ");
INSERT INTO cug_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kifəkə kiwɔ ka saka baa mbuŋ i gwu yi wə lɔɔ i kuku, saka dza bɛiŋ tsə i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisɔs bikə i wi a, “Wɔ nəŋki a mih fə̂ nə i wɔ a?” Kifəkə kiwɔ chukuli a, “Mi wi Lanini, mih nəŋki i yɛiŋki biɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisɔs ka dzaka i wi a, “Wɔ tsə̂ mfia. Shɔm yə wɔ jiə i mih fə wɔ bɔnih.” Akisəkə dzə́kəh yi baiŋ wi ka yɛiŋki biɛiŋ, ka biəliki Jisɔs i di biə wi nì tsəki. ");
INSERT INTO cug_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisɔs bəh bwa bu bə mbaŋ ni kɔmsiki tsəki i Jɛlusalɛm, bɔ kɛiŋ num kɔmsi tsə i kwili wi Bɛtfajə bəh bi Bɛtani wə biə bi kɔmsiki tsəki i ŋkwuŋ wi Kɛiŋ yi Ɔlif wə, wi ka faaŋ bwa bu bə mbaŋ bədɔkɔ bəfa, ");
INSERT INTO cug_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","dzaka i bɔ a, “Mbɛiŋ tsə̂ i kwili wi ninshiŋ wəyaka wə. Jɔbi wə mbɛiŋ ni liəki tsəki fɛiŋ akisəkə, mbɛiŋ ni yɛiŋ lə waiŋ njakas num bə shu, maka mi num yaka yɛiŋ bɛiŋ, mbɛiŋ shwâli dzə̂ bəh yi fa. ");
INSERT INTO cug_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi widɔkɔ ka bikə a mbɛiŋ shwaki yi kɔm nə a, mbɛiŋ chukuli a Bah kaŋaki lə nɔm bəh yi, a wi ki fiəniki dzəki lə bəh yi a liə liə.” ");
INSERT INTO cug_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Bɔ ka nyə tsə yɛiŋ yi num bə shu i fifiəŋə i dzəh kpəŋ. Ayaka bɔ ka shwaki. ");
INSERT INTO cug_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Si bɔ nì shwaki waiŋ njakas wiwɔ bəni bədɔkɔ bə̀ bɔ nì kɔ fɛiŋ bikə i bɔ a, “Mbɛiŋ fəki nə yaka?” ");
INSERT INTO cug_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Bɔ ka fuku i bɔ gia yə Jisɔs si dzaka. Bəni bəwɔ ka bee yi bɔ nyə bəh yi. ");
INSERT INTO cug_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Si bɔ nì dzə bəh yi i Jisɔs, jiə bəmbuŋ bəbɔ i njakas yiwɔ bɛiŋ, Jisɔs ka yaka. ");
INSERT INTO cug_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bəni bəduli ka tɔkɔki tsəki bəmbuŋ bəbɔ i dzəh, bədɔkɔ fakayi cha yi kɛiŋ yi chwa, tɔkɔ tə i dzəh. ");
INSERT INTO cug_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Bəni bə̀ bɔ nì tsəki i Jisɔs nshiŋ bəh bə̀ bɔ nì biəliki i jum wə wili a, “Lilili, kiŋkɔksi kɔ Nyɔ wə ɔɔɔ! Nyɔ lɔɔ kimbɔiŋsi ki i mi wə wi dzəki i yɛli wi Bah wə ɔɔɔ Lilili. ");
INSERT INTO cug_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Nyɔ lɔɔ kimbɔiŋsi ki i ŋkuŋ bi wə tii wibuku wə Dɛbit wə wi si dzə lɔ! Ɔɔɔ, kiŋkɔkni kɔ i Nyɔ wi bɛiŋ wə Eeee!” ");
INSERT INTO cug_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jisɔs tsə buku i Jɛlusalɛm, liə i juŋ yi fəni yi gia wə, jɔbi wə wi nì tsɛiŋ tali si gia yichi kɔ. Si a nì kɔ asi num i fijɔbi wi ka fiəni bəh bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa tsə i Bɛtani. ");
INSERT INTO cug_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chɔkɔ buku wɔɔ Jisɔs bəh bwa bu bə mbaŋ nyə i Bɛtani chu tsə i Jɛlusalɛm, ayaka dzɔŋ wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wi lɔ dzəkəh yɛiŋ kpɛiŋ wi fig widɔkɔ wi num nanu, kidzɛni num yɛiŋ nalə num bə si dzi lə mitam miwɔ. Wi ka tsə buku fɛiŋ i yɛiŋ a yuwidɔkɔ ŋgaiŋ kɔlə kwati fiɛŋ yɛiŋ i dzi. Wi ka tsə buku fɛiŋ nəki yɛiŋ kə fiɛŋ yɛiŋ wə, yɛiŋ shəŋ a kidzɛni yɛiŋ, kɔm a nì kɔkə jɔbi wə mitam si wum yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wi ka dzaka i kpɛiŋ wiwɔ a, “Kiə mi bi ma chu lansi dzî fiɛŋ i wɔ wə.” Si wi dzaka yakadəiŋ bwa bu bə mbaŋ wɔkɔ yi. ");
INSERT INTO cug_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Si bɔ tsə buku i Jɛlusalɛm, Jisɔs tsə liə i tɔkɔ wi juŋ yi fəni yi gia mə yisi ka kɔŋŋki bəni bə̀ bɔ nì taŋniki bəh bə̀ bɔ nì taŋki biɛiŋ, beeŋsi bibaŋ biə bəni nì kwuniki kpɔ yɛiŋ, bəh biŋgbɔkɔ bi bəni bə̀ bɔ nì taŋniki bibumi. ");
INSERT INTO cug_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wi nəki bum kə a mi kɔlə i giŋ fiɛŋ i tsə daŋsi bəh fi i tɔkɔ wi fəni wi gia wə. ");
INSERT INTO cug_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wi ka laniki bɔ dzaka a, “Ntə bə kɔ bə nyaka a, Nyɔ dzakaki a, ‘Juŋ yiŋ kɔ bə bi bɔɔŋki a juŋ yi tsani i mbi wichi a?’ Mbɛiŋ ka fiəni yi a yi chu taa wi bəji.” ");
INSERT INTO cug_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ wɔkɔ yi ka nəŋki dzəh i wɔɔ wi. Bɔ ka lwaki wi kɔm mbaŋ wi bəni nì wɔkɔliki nlani wi wɔkɔ ndzɔŋni nalə. ");
INSERT INTO cug_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Asi fijɔbi nì dzə, Jisɔs bəh bwa bu bə mbaŋ buku i kwili kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Si Jisɔs bəh bwa bu bə mbaŋ nì buku ka ghaniki kinchɔŋɔchɔŋɔ, bɔ yɛiŋ kpɛiŋ wiwɔ num wi kpiyi lɔ wichi shi buku i gaaŋ wə. ");
INSERT INTO cug_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bita ka kwaka gia yə yi ni num, ka dzaka i Jisɔs a, “Mi wi Lanini, yɛiŋ kpɛiŋ wə wɔ ni liŋ si wi kpiyi a.” ");
INSERT INTO cug_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisɔs chukuli i bɔ a, “Mbɛiŋ jîə shɔm i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mih fukuki ŋkɔŋ i mbɛiŋ a, mi ka dzaka i ŋkwuŋ wələ a, ‘Mûku gwu ya fa tsə̂ gbɔ̂ i kinchwɔ kimbum wə’, Wi ka dzakaki yakadəiŋ məŋni kə yi i wi shɔm, num wi bum a gia yələ ŋgaiŋ dzakaki lə ni num lə, ma yi ni nûm i wi. ");
INSERT INTO cug_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ayakadəiŋ, mih fukuki i mbɛiŋ a, na finaiŋ fiɛŋ fiə mbɛiŋ nywaki i ntsa wə, num mbɛiŋ bum a mbɛiŋ ni kwati lə, ma mbɛiŋ ni kwati. ");
INSERT INTO cug_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mbɛiŋ ka num i tsa, mi kaŋa mi widɔkɔ i shɔm, wi dâlinya wi. Mbɛiŋ ka fəki yakadəiŋ ma Ba wimbɛiŋ wə wi kɔ i bɛiŋ ni dalinya chu bimbɛiŋ tə.  ");
INSERT INTO cug_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mbɛiŋ ka baaŋ i dalinyaki chu bi bəni bədɔkɔ, ma Ba wimbɛiŋ wə wi kɔ bɛiŋ bi ma dalinya bimbɛiŋ tə. ” ");
INSERT INTO cug_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisɔs bəh bwa bu bə mbaŋ chu tsə liə i Jɛlusalɛm. Jɔbi wə wi nì nyaniki nnyaki i juŋ yi fəni yi gia wə, bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ bəh bəni bə̀ bɔ nì sakaki tumi ki Bəju nyə dzə yɛiŋ wi, ");
INSERT INTO cug_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","bikə i wi a, “Wɔ dzɔ faiŋ ŋga biələ na ka wɔ fəki gia yələ a? A nya ndə ŋga biwɔ i wɔ, a wɔ fə̂ki gia yiwɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisɔs chukuli i bɔ a, “Mih ki bikəki lə kimbikə kimu i mbɛiŋ, mbɛiŋ ka nì chukuli, mih ka ni fuku i mbɛiŋ mi wə wi nya ŋga a mih fə̂ki gia yələ. ");
INSERT INTO cug_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A nì nya ndə ŋga i Jɔn na ka wi juliki bəni i bɔkɔ a? Bi nì nyə i bɛiŋ ma nì nya mi wiwɔm a? Mbɛiŋ chukuli mih!” ");
INSERT INTO cug_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Bɔ dza ka gukuliki a bɔ bɔ a, “Bukumbɛiŋ ka chukuli a, bi nì nyə i bɛiŋ, wi ni bikə i bukumbɛiŋ aka fə nə a bukumbɛiŋ ma bum i Jɔn a? ");
INSERT INTO cug_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bukumbɛiŋ ka ni chukuli a, a nì nya mi wiwɔm, dəiŋ na?” Bɔ nì lwaki bəni kɔm bɔ bəchi nì kɔ num bɔ bum a Jɔn kɔ na mi ntum wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ayakadəiŋ, bɔ ka chukuli i Jisɔs a, “Buku kiəki kə.” Jisɔs ka dzaka i bɔ a, “Yaka mih tə ki fukuki kə i mbɛiŋ mi wə wi nya ŋga i mih ka mih fəki gia yələ.” ");
INSERT INTO cug_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisɔs ka yisi i dzakaki i bɔ i bəndi wə a, “Mi widɔkɔ nì nɔm khə wi mintam wə bə kɛiŋsiki mbih yɛiŋ, num wi ta fiəli bəh mbaiŋ, chum di biə bə nì dəŋki mintam miwɔ yɛiŋ mbih buku, ka maa kibaŋ ki chənini fɛiŋ, ka jiə bəni i khə wiwɔ wə, ka nyə tsə i tumi kidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jɔbi wə bɔ nì kaŋaki i yisi ŋkɔh dzə kpɛiŋ, tii khə wiwɔ ka faaŋ waiŋ wi wi nɔm widɔkɔ i bəni bə̀ wi nì jiə khə wiwɔ i bɔ a bɔ tsə̂ dzɔ̂ mmu mintam. ");
INSERT INTO cug_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ayakalə, bɔ tsə kwa lɔ wi ka twɛiŋ kɔŋŋ wi bəh kaŋ yiyəə wi nyə. ");
INSERT INTO cug_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ayaka mi wi khə wiwɔ ka chu faaŋ waiŋ wi nɔm wi widɔkɔ i bɔ, wi tsə bɔ chu twɛiŋ wi, wi kaŋa bali i fwu wi wə, ŋgəmsi wi. ");
INSERT INTO cug_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wi chu faaŋ widɔkɔ, bɔ wɔɔ wəmaka. Wi chu faaŋ bədɔkɔ bəduli, bɔ twɛiŋ bədɔkɔ, wɔɔyi bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wi faaŋ lə, a dzə baaŋ a wimu, wəmaka num waiŋ wi wi shɔm. Ayaka wi fiəni faaŋ wi i bɔ kwaka a bɔ ni tsə kɔksi lə waiŋ wi ŋgaiŋ wələ. ");
INSERT INTO cug_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ayakalə, bəni bə nɔm bə̀ dzaka a bɔ bɔ a, ‘Wələ kɔ ndzi kwili wi tii khə wələ, mbɛiŋ dzə̂ ma bukumbɛiŋ wɔ̂ɔ wi ka biɛiŋ biwɔ numki bibukumbɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ayaka bɔ kwa wi, ka wɔɔ, guku buku bəh wi yɛiŋ khə.” ");
INSERT INTO cug_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Si Jisɔs dzaka yakadəiŋ, ka bikə a, “Gia yə tii khə wiwɔ nì fə kɔ nə? Wi ni tsə kaasi bəni bəwɔ, wi nya khə wiwɔ num i bəni bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mbɛiŋ ka fa dəkə di biələ i Kiŋwakti ki Nyɔ wə a? Bə kɔ bə nyaka a, ‘Təh wə, bəni bə maani nì nəiŋ, wi dzə fiəni num təh wi bu wi juŋ. ");
INSERT INTO cug_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yələ kɔ mfə wi Bah, buku ka tsɛiŋki num bəh ŋkaiŋyi.’” ");
INSERT INTO cug_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Bəni bəwɔ wɔkɔ ndi wələ, ka kiə a Jisɔs tiki num i bɔ. Bɔ ka nəŋki dzəh i kwa wi, ka lwa num mbaŋ wi bəni wə wi nì kɔ fɛiŋ. Bɔ ka bee wi ka nyə. ");
INSERT INTO cug_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kifwu ki tumi ka dza faaŋ Bəfalasi bəh bəni bədɔkɔ bə mbaŋ wi Ŋkuŋ Hɛlɔd a bɔ tsə̂ tâaŋ Jisɔs i kwâ wi i ndzaka wi wə. ");
INSERT INTO cug_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bɔ dzə dzaka i Jisɔs a, “Mi wi lanini, buku kiəki lə a wɔ si dzaka a ŋkɔŋ, kɔm wɔ lwaki kə dzə́kəh yi mi kɔŋ wəmaka kɔ na ndə. Wɔ laniki ŋkɔŋ num dzəh yi Nyɔ. Fûku i buku a nchi bumki lə a bə lɔ̂ɔki kiŋwakti i Kaysa ŋkuŋ wimbum wi Lum, ma wi bumki kə a? ");
INSERT INTO cug_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Bukumbɛiŋ lɔ̂ɔki, ma bə ma lɔ̂ɔki a?” Ayakalə, Jisɔs kiə gia yə bɔ nì wɛɛliki bəh yi, ka chukuli a, “Mbɛiŋ taaŋki mih kɔm nə? Mbɛiŋ dzə̂ bəh chwaka ki kpɔ mih yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Bɔ dzə bəh wi, wi dzɔ, bikə i bɔ a, “Fwu wələ yɛiŋ kɔ wi ndə a, yɛli wələ num wi ndə a?” Ayaka bɔ chukuli a, “Akɔ yɛli wi Kaysa ŋkuŋ wi Lum.” ");
INSERT INTO cug_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jisɔs ka dzaka i bɔ a, “Mbɛiŋ nyâki fiɛŋ fiə fi kɔ fi Kaysa i wi, ma mbɛiŋ nyâki fi Nyɔ i Nyɔ.” Bɔ wɔkɔ yaka, gwu kpi lɔ bɔ kɔm wi. ");
INSERT INTO cug_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Bəsadusi bəwɔ nyə dzə i bikə gia i Jisɔs. Bəsadusi bələ nì kɔ bəni bə̀ bɔ nì dzaka a bəni bi fiəni dzayiki kə i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Si bɔ dzə yaka, dzaka a, “Mi wi lanini, Muses nì nyaka i bənchi i buku a, ‘Waiŋnih mi ka kpi bee miŋkpaŋa bɔ wi kaŋa kə waiŋ, wanih mi wiwɔ kaŋaki lə i nɔsi kpə ŋkwu wiwɔ, ka bɔ wi bwɔ bwa i yɛli wi waiŋnih wiwɔ wə.’ ");
INSERT INTO cug_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ayakadəiŋ, bwa bə mi widɔkɔ nì kɔlə nanitaŋ, wi ninshiŋ dzə dzɔ miŋkpaŋa ka kpi maka bɔ wi bwɔ waiŋ. ");
INSERT INTO cug_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Wi kɔmsini wə nɔsi miŋkpaŋa wiwɔ, ayakalə ka kpi tə maka bɔ wi bwɔ waiŋ. Yi bi num tali ayaka i bwa bəwɔ nanitaŋ bəchi, mi i bɔ kintəəŋ nəki bwɔ kə waiŋ bəh miŋkpaŋa wiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bɔ nɔsi fiəli wi yaka bɔ bəchi, mi widɔkɔ kɔbi i bɔ bələ nanitaŋ wə bəh miŋkpaŋa wiwɔ bwɔ waiŋ. I kiŋgɔksi wə miŋkpaŋa wiwɔ bɔŋ kpi tə. ");
INSERT INTO cug_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","I liə si bɔ bəchi nanitaŋ nì kɔ bɔ nɔsi lɔ miŋkpaŋa wiwɔ, a bi numki jɔbi wə bəni dzayiki i kpi wə, ma wi bi numki kpə ndə a?” ");
INSERT INTO cug_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisɔs chukuli i bɔ a, “Mbɛiŋ dzakaki lə mbɛiŋ kiə alə a mbɛiŋ kɔ fikpəŋ a? Mbɛiŋ kɔ fikpəŋ kɔm mbɛiŋ kiəki kə gia yə bə nyaka i Kiŋwakti ki Nyɔ wə, chu kiə kə tə ŋga bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gia yə yi bi numki jɔbi wə bəni bi dzaki i kpi wə, bənyuku bəh bəkaŋa bi chu baŋsiki kə i ndzɔ wi bəkaŋa wə. Bɔ bi numki aka bəchinda bə Nyɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Gia kɔm ndza wi kpi, mbɛiŋ ka num fa di bi Kiŋwakti ki Muses kə kɔm kpɛiŋ wə wi nì fiiki a? Nyɔ nì dzaka i wi Muses a, ‘Akɔ mih Nyɔ wi Ablaham bəh wi Ayjik bəh wi Yakɔb a?’ ");
INSERT INTO cug_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yi kɔ a Nyɔ kɔkə Nyɔ wi bəŋkwu, wi kɔ Nyɔ wi bəni bəwɔm. Mbɛiŋ dzani bəh ŋga.” ");
INSERT INTO cug_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mi widɔkɔ wə wi nì laniki bənchi bə Nyɔ, nì dzə ka wɔkɔ si Jisɔs bəh bəni bəwɔ gukuliki, chu yɛiŋ si wi chukuliki gia yə bɔ nì bikəki i wi i dzəh yindzɔŋni wə, ayaka wi ka bikə tə i Jisɔs a, “Nchi wə wi tsəki bənchi bəchi kɔ winaiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisɔs chukuli i wi a, “Nchi wə wi tsəki bənchi bəchi kɔ wələ wi dzakaki a, ‘Ɔ bəni bə Islae mbɛiŋ wɔ̂kɔ, Bah Nyɔ wə, Nyɔ wibukumbɛiŋ, Bah Nyɔ wiwɔ kɔ a wimu. ");
INSERT INTO cug_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wɔ kɔ̂ŋki Bah Nyɔ wa bəh shɔm ya yichi, nyâ gwu ya yichi, jîə mfi bia i wi wə bichi, nɔ̂m i wi bəh ŋga bia bichi.’ ");
INSERT INTO cug_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nchi wə wi biəli wələ kɔ a, ‘Wɔ kɔ̂ŋki mi wə wi kɔ kɔmsi i wɔ kpəŋ asi wɔ kɔŋki gwu ya.’ Nchi widɔkɔ chu kɔkə wə wi tsəki bələ.” ");
INSERT INTO cug_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Mi wə wi nì laniki bənchi bə Nyɔ dzaka i Jisɔs a, “Mi wi Lanini, wɔ chukuli na chəŋ. Wɔ dzaka num ŋkɔŋ a Nyɔ kɔ a wimu widɔkɔ chu kɔkə a kɔbi a wi shəŋ. ");
INSERT INTO cug_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","I kɔŋki wi bəh shɔm ya yichi, jiə mfi i wi wə bichi, nɔm i wi bəh ŋga bichi bəh i kɔŋki mi wə wi kɔ kɔmsi i wɔ kpəŋ asi wɔ kɔŋki gwu ya, yi tsəki lə na i fəki bimfə gia bəh nyám yi waŋni bəh bimfə gia bidɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisɔs ka yɛiŋ si wi chukuli ka mi wi mfi, wi ka dzaka i wi a, “Wɔ kɔkə dzəh yi dəəŋ i liə ntɔŋ bi Nyɔ wə.” I jum wə fɛiŋ wə, mi nəki chu mɔm kə i dzə bikə gia i wi. ");
INSERT INTO cug_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisɔs dzə ka laniki bəni i tɔkɔ wi juŋ yi fəni yi gia wə, ka dza bikə i bɔ a, “Bəni bə̀ bɔ laniki bənchi nyani dəiŋ na ka bɔ dzakaki a Kimbwili wə Nyɔ nì kaka kɔ waiŋ Ŋkuŋ Dɛbit a? ");
INSERT INTO cug_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kiŋ'waka ki Baiŋni nì fə lɔ Ŋkuŋ Dɛbit wələ dzaka kɔm Kimbwili wiwɔ dzakaki a, ‘Bah Nyɔ nì dzaka i Bah wuŋ a, wi nûm i tsɛiŋ yi yiləkəli wə, i tsə̂ buku jɔbi wə ŋgaiŋ bi jiəki bəni bu bə̀ bɔ baiŋki wi wi tɔmyi gvu yi i bɔ bɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dɛbit mwi ka bɔɔŋki wi a Bah wi, wi chu nyani dəiŋ ka wi numki waiŋ wi a?” Si Jisɔs ni dzakaki gia yiwɔ yakadəiŋ, mbaŋ wi bəni wə wi nì kɔ fɛiŋ, ka wɔkɔliki i wi bəh kinsaŋli bɔ wɔkɔ ndzɔŋni. ");
INSERT INTO cug_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Asi wi nì laniki bəni, wi dza dzaka i bɔ a, “Mbɛiŋ tɔ̂kniki, kɔm bə bəni bə̀ bɔ laniki bənchi bə Nyɔ, bɔ kɔŋki i nyaniki nnyaki bəh bəmbuŋ bədəəŋ tsə i kidi ki shi wə, a bəni bɔ̂niki bɔ bəh kiŋkɔksi. ");
INSERT INTO cug_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chu kɔŋ i numki i di bi kɔknini wə i juŋ yi tsani wə, bəh i di bi bini wə. ");
INSERT INTO cug_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","A chu num a bɔ bə̀ bɔ laksiki biɛiŋ bi bəkaŋa bəŋkwu, fwɔkyi dzɔ biɛiŋ bibɔ, kwayi fə bəntsa bədəəŋ. Ŋgəkə wibɔ bi numki na wimbum.” ");
INSERT INTO cug_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisɔs nyə tsə shinum i kimbu kə ki nì tsɛiŋki daŋsiki ki kintaiŋntaiŋ ki nya kə i tɔkɔ wi juŋ yi fəni yi gia wə, ka tsɛiŋki si bəni dzəki jiəki kpɔ i kintaiŋntaiŋ ki nya mə. Bəni bə kpɔ bəduli nì dzəki jiəki kpɔ fɛiŋ wi duli. ");
INSERT INTO cug_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kpə ŋkwu wi kifuu widɔkɔ nì dza dzə, jiə bədəli bəfa yɛiŋ, wi kpɛiŋ kə i fiɛŋ fidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ayaka Jisɔs bɔɔŋ bwa bu bə mbaŋ dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a kpə ŋkwu wələ wi kɔ mi wi kifuu lə, wi nya tsə bəni bəchi bə̀ bɔ jiəki biɛiŋ i kintaiŋntaiŋ kələ mə. ");
INSERT INTO cug_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Bəni bəchi bə̀ bɔ si nyaki, bɔ si nyaki num biŋka bibɔ bi kpɔ biə bi si jikə ka gbɔyiki kuku. Ayakalə, kpaŋa wələ dzə bəh gwu yi yichi nya biɛiŋ bichi biə wi kaŋaki, num a biə wi nɔki yɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jɔbi wə Jisɔs nì buku dzə i juŋ yi fəni gia mə, waiŋ wi mbaŋ widɔkɔ dzə ka kaiŋyiki i wi a, “Mi wi Lanini tsɛ̂iŋ kitəh kimbum kələ bə maa juŋ yələ yɛiŋ. Akɔ na mmaa wi juŋ wi ndzɔŋni lə!” ");
INSERT INTO cug_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisɔs chukuli i wi a, “Mbɛiŋ yɛiŋ alə ŋkaiŋni wi maani wimbum wələ a? Təh wimu bi baaŋ kə i widɔkɔ bɛiŋ maka bə baka tɔkɔ wi i kuku.” ");
INSERT INTO cug_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jɔbi wə Jisɔs nì tsə shinum i Ŋkwuŋ wi Kɛiŋ yi Ɔlif wə i kimbu kə ki tsɛiŋki daŋsiki juŋ yi fəni yi gia, i fɛiŋ wə Bita bəh Jɛm bə Jɔn bəh Andulu tsə a bɔ bɔ ka bikə i wi a, ");
INSERT INTO cug_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Fûku buku jɔbi wə gia yələ yichi bi numki, bəh binchəsi biə bi chusiki a jɔbi wi gia yələ yichi si num a kpɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisɔs yisi i dzakaki i bɔ a, “Mbɛiŋ tɔ̂kniki ka mi bi ma fwɔ̂kyi mbɛiŋ a mbɛiŋ ndzani dzəh. ");
INSERT INTO cug_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bəni bəduli bi dzə lə dzɔ yɛli wuŋ kəŋ i ninshiŋ, mi dzaka a, ‘Akɔ mih wiwɔ.’ Jɔbi wə bɔ bi fəki yakadəiŋ ka fwɔkyiki bəni bəduli. ");
INSERT INTO cug_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jɔbi wə mbɛiŋ bi wɔkɔki a bə tumki jum, chu wɔkɔ tə gia kɔm jum, kiə shɔm bi ma tə̂iŋyiki mi. Yələ kɔ gia yə yi kaŋaki i bi num. Ayakalə, kiŋgɔksi kɛiŋ ki dzə kə. ");
INSERT INTO cug_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tumi bi tumki lə jum bəh kidɔkɔ, ayaka ntɔŋ widɔkɔ tum jum bəh widɔkɔ. Nshwaiŋ bi nəŋniki i di di wə, dzɔŋ tə bi numki. Yəmaka gia bi numki aka lɔli bi miŋkpaŋa wə wi yisi i nɔmki. ");
INSERT INTO cug_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mbɛiŋ kaŋaki i tɔ̂kniki. Mbɛiŋ kîəki a bə bi nya daŋsi lə mbɛiŋ i kaŋ yi bəni bə̀ bɔ sakaki bənsaka. Bə bi twɛiŋki lə mbɛiŋ i juŋ yi tsani wə. Mbɛiŋ bi numyiki lə i bəni bə̀ bɔ sakaki tumi nshiŋ, bəh i bəŋkuŋ nshiŋ kɔm mih, i beeŋ nsaka wuŋ. ");
INSERT INTO cug_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ayakalə, bə kaŋaki i bi yisi fuku ntum wi ndzɔŋni wi Nyɔ i kitumi kichi wə. ");
INSERT INTO cug_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jɔbi wə bɔ bi kwayi mbɛiŋ i tsə nya i juŋ yi nsaka wə, kiə fwu bi ma bɔ̂kɔ mbɛiŋ a mbɛiŋ ni tsə dzaka a nə a. Jɔbi wə mbɛiŋ tsə, mbɛiŋ ka dzakaki shəŋ a gia yə yi bukuki dzəki i shɔm yimbɛiŋ wə i jɔbi wiwɔ wə, kɔm ndzaka wiwɔ bi numki kə wimbɛiŋ. A bi nyaki Kiŋ'waka ki Baiŋni ndzaka i dzaka kimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mi bi dza dzɔ lə waiŋnih wi nya a bə wɔɔ, tii waiŋ dzɔ waiŋ wi nya a bə wɔɔ. Bwa bi dza lə bwaŋ gvu i bətii bəbɔ bəh bənih bəbɔ chɛiŋ, fə bə wɔɔyi bɔ. ");
INSERT INTO cug_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Bəni bəchi bi baiŋŋki lə mbɛiŋ kɔm yɛli wuŋ. Ayakalə, mi wə wi bi kaŋaki shɔm i tsə buku i kiŋgɔksi wə akɔ wə wi bi bɔiŋki. ");
INSERT INTO cug_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","(Mi wə wi faaki kiŋwakti kələ wɔ̂kɔ ndzɔŋ,) jɔbi wə mbɛiŋ bi yɛiŋki gia yi gumini yə yi kɔ i bəkəli di num yi dzə num i juŋ yi fəni yi gia wə, bəni bə̀ bɔ kɔ i Judea bi gɛ̂iŋ yâka i ŋkwúŋ wə. ");
INSERT INTO cug_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mi wə wi kɔ i fwu wi juŋ bɛiŋ wi bi ma chu shî lîə i dzu a ŋgaiŋ dzɔ̂ki fiɛŋ fidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mi wə wi kɔ i khə wi bi ma chu fîəni kwɛ̂ a ŋgaiŋ tsə̂ dzɔ̂ mbuŋ wi. ");
INSERT INTO cug_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ŋgəkə wimbum bi numki wi bəkaŋa bə̀ bɔ bi numki bəh kitɔɔ, bəh bə̀ bɔ masiki bwa. ");
INSERT INTO cug_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mbɛiŋ tsâki a kiə gia yiwɔ bi ma nûm i jɔbi wi fiəkə yiləkəli wə. ");
INSERT INTO cug_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Bəni bi yɛiŋki lə bəŋgəkə i chɔkɔ biwɔ wə, maka wəmaka ŋkaiŋni wi ŋgəkə num num na i yisi si Nyɔ nì maa mbi wələ bəh i dzə buku bidaiŋ. Ayaka wəmaka ŋkaiŋni wi ŋgəkə kɔbi i bi chu num. ");
INSERT INTO cug_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ayaka asi mɔŋ a Bah gaali kaŋ yi bəŋgəkə yiwɔ, ma na mi wimu bi bɔiŋ kə i kaŋ yiwɔ wə. Ayakalə, a akɔ kɔm bəni bu bə̀ wi nì sabi jiə, yi fə wi gaali kaŋa yiwɔ. ");
INSERT INTO cug_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mi ka bi dzaka i mbɛiŋ i kaŋ yiwɔ wə a ‘Tsɛ̂iŋ, Kimbwili wə Nyɔ nì kaka a bə wi lə fa!’ Yudɔkɔ a, ‘Mbɛiŋ tsɛ̂iŋ bə wi yaka fi!’ Kiə mbɛiŋ bi ma bûm. ");
INSERT INTO cug_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mbɛiŋ kîəki a bəni bi dzə lə nyi ntəkə a bɔ kɔ bəmbwili bə̀ Nyɔ nì kaka, bədɔkɔ dzaka a bɔ kɔ bəni bə ntum bə Nyɔ, bɔ bi fəki bənchəsi bə̀ bɔ chusiki ŋga bibɔ, fə tə gia yi dzaka ki wɔmni, mɔmsi i fwɔkyi bəni bə̀ Nyɔ kɔ wi sabibwili bɔ ka jiə a bɔ dali dzəh. ");
INSERT INTO cug_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mbɛiŋ tsɛ̂iŋ, mih fuku lɔ gia yələ yichi i mbɛiŋ jɔbi kɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","A bi numki i kaŋ yiwɔ wə num bəŋgəkə bəwɔ tsə, wɔŋ bi dza jiki num jini, fiəŋŋ bi ma chu baiŋki tə, ");
INSERT INTO cug_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bijɔŋ bi gbɔyiki i bɛiŋ, biɛiŋ bichi biə bi kaŋaki ŋga i bɛiŋ bi nəŋniki. ");
INSERT INTO cug_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ayakadəiŋ, bəni bi yɛiŋ si mi wə yɛli wi kɔ Waiŋmi si wi shiki dzəki i bikwu wə kaŋa ŋga bimbum bəh kiŋkɔkni. ");
INSERT INTO cug_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma wi bi ka chiŋsi bəchinda bu bɔ tsə i bimbu bi mbi binaa wə i di biə nshwaiŋ gɔksiki bəh biə bɔɔli gɔksiki, a bɔ dzə juŋni bəni bu bə̀ wi kɔ wi sabibwili lɔ. ");
INSERT INTO cug_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mbɛiŋ lâni dzɔ̂ gia i kpɛiŋ wi fidəiŋ wə. Jɔbi wə cha yiwɔ yisi i nyaki mwi, bwili bindzɛni, mbɛiŋ ka kiəki a nyum kwuni lɔ gwu. ");
INSERT INTO cug_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Yi kɔ a liŋ, i jɔbi wə mbɛiŋ bi yɛiŋki gia yələ dzɔ di, mbɛiŋ ka kiəki a jɔbi si num a kaŋ. ");
INSERT INTO cug_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mih fukuki ŋkɔŋ i mbɛiŋ a ŋgɔkɔ wi liə wələ bi tsə kaa kə maka gia yələ yichi num. ");
INSERT INTO cug_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Bɔɔli bəh nshwaiŋ bi tsə kaa lə, ayakalə gia yiŋ kɔbi i bi lansi nəŋni. ");
INSERT INTO cug_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ayakalə, mi widɔkɔ kɔkə wə wi kiəki chɔkɔ biwɔ nabə jɔbi wiwɔ. Na bəchinda bə Nyɔ bə̀ i bɛiŋ nabə Waiŋ Nyɔ tə kiəki kə. A kiəki a Ba, wi mbɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ayakadəiŋ, mbɛiŋ tɔ̂kniki chu wɔkɔli kɔm mbɛiŋ kiəki kə jɔbi wə wi bi dzəki, ");
INSERT INTO cug_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","yi kɔ aka mi wə wi tsəki nyani, jɔbi wə wi ni nyəki, wi bee kwili wi i kaŋ yi bwa bu bə nɔm, na ndə bəh chɔkɔ bi bi nɔm, na ndə bəh chɔkɔ bi bi nɔm, ka dzaka i mi wə wi chəniki dzaka ki mbaiŋ a wi bâaŋ chə̂niki bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ayakadəiŋ, mbɛiŋ nûmki bəh ŋkɛiŋsi wi gwu, kɔm mbɛiŋ kiəki kə jɔbi wə tikwili wiwɔ bi fiəni dzəki. Yudɔkɔ a bi numki i fijɔbi, yudɔkɔ nchɔkɔ kintəəŋ, yudɔkɔ i jɔbi wə kwɔkɔ ki ninshiŋ tɔŋki, yudɔkɔ kinchɔŋɔchɔŋɔ. ");
INSERT INTO cug_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kiə wi bi ma təkəli tumbuku wi yɛiŋ mbɛiŋ nɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ayaka gia yə mih dzakaki i mbɛiŋ fa mih dzakaki yi i mi wichi tə a, ‘Mi wichi nûmki bəh kinchəni.’” ");
INSERT INTO cug_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A nì baaŋ a kaŋ yifa ka bə liə i Dzini bi Ntsədaŋ bəh bi Blɛd wə bə ka jiə dəkə dzɔɔŋ yɛiŋ. Bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ ka nəŋki dzəh yi wɛlini yə bɔ ni kwa Jisɔs yɛiŋ i wɔɔ. ");
INSERT INTO cug_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bɔ jiə ja a bɔ bɔ a, “Kiə bukumbɛiŋ ki mɔ̂m kə gia yələ i jɔbi wə bə fəki Dzini biələ yɛiŋ, kɔm bukumbɛiŋ ka mɔm yi, ma yi ni dzə bəh ŋgəkə i bəni kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jɔbi wə Jisɔs nì kɔ i Bɛtani, i kwili wi Samɔn wə wi nì yisi kɔ mi wi kumyini, bɔ nì kɔ fɛiŋ bɔ dzi wə, miŋkpaŋa widɔkɔ dza liə dzə bəh finsɔkɔ fi fiaŋsi fidɔkɔ a num bi tsɛŋə yindzɔŋni. Fiaŋsi biwɔ nì kɔ bi kpɔ wi ləkəli, num bə kɛiŋsi a bəh nad shəŋ. Si wi liə, ka bwiŋ dzaka ki finsɔkɔ fiwɔ shuku fiaŋsi biwɔ i fwu wi Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Bəni bədɔkɔ bə̀ bɔ nì kɔ fɛiŋ yisi i shwiŋyiki dzakayi a, “Wi bəkəliki fiaŋsi biələ kilɔlɔ kɔm nə lə? ");
INSERT INTO cug_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Num bə si kɔ taŋni fiaŋsi biwɔ i kpɔ wə wi tsə bənchuku gi yitali, i nyaki kpɔ wiwɔ i bəni bə kifuu.” Bɔ bə́ yɔli i wi. ");
INSERT INTO cug_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ayakalə, Jisɔs dzaka i bɔ a, “Mbɛiŋ bêe wi mɔŋ. Mbɛiŋ nyaki ŋgəkə i wi kɔm nə? Wi fə num gia yindzɔŋni i mih. ");
INSERT INTO cug_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mbɛiŋ kiə a bəni bə kifuu kɔ bəh mbɛiŋ jɔbi wichi. Mbɛiŋ num i gamtiki bɔ i na winaiŋ jɔbi wə mbɛiŋ kɔŋki. Ayakalə, i mih, mih ni numki kə bukumbɛiŋ jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kpaŋa wələ fə gia yə wi si kɔ i fə. Wi shukuyi fiaŋsi biələ i mih wə lə kɛiŋsi num gwu yiŋ jɔbi kɛiŋ, si bə bi ləəki mih. ");
INSERT INTO cug_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mih fukuki ŋkɔŋ i mbɛiŋ a, na faiŋ bə bi fukuki ntum wi ndzɔŋni wələ i mbi wichi wə, gia yələ miŋkpaŋa wələ fə bə bi fukuki yi, bə kwaka wi.” ");
INSERT INTO cug_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iskaliɔt wə wi nì kɔ mi i mbaŋ wi bwa bə Jisɔs bə̀ jwɔfi ntsɔ bəfa, ka nyə tsə yɛiŋ bətii mfə gia bəmbum taŋni Jisɔs i bɔ. ");
INSERT INTO cug_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jɔbi wə bɔ nì wɔkɔ yaka bɔ laŋ nalə, ka kaka wi a bɔ ni nya lə wi bəh kpɔ. Wi yisi i nəŋki dzəh yə wi ni nya Jisɔs yɛiŋ i bɔ kaŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A dzə num i chɔkɔ bi ninshiŋ i Dzini bi Blɛd wə bə ka jiə dəkə dzɔɔŋ yɛiŋ, biə bə si kum waiŋ jaka i Dzini bi Ntsədaŋ biwɔ wə. I fɛiŋ wə bwa bə Jisɔs bə mbaŋ bikə i wi a, “Wɔ nəŋki a buku tsə kɛiŋsi faiŋ di biə bə ni dzi Dzini bi Ntsədaŋ yɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wi ka faaŋ bwa bu bə mbaŋ bədɔkɔ bəfa, dzaka i bɔ a, “Mbɛiŋ lîə tsə̂ i kwili wə, mbɛiŋ ni baŋsi lə bə mi num wi bəkə kpəŋə wi mwi, mbɛiŋ bîəli wi. ");
INSERT INTO cug_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jɔbi wə wi ni tsə liə, juŋ yə wi liə yɛiŋ, mbɛiŋ dzâka i tii juŋ wiwɔ a, Mi wi Lanini bikəki a lum wi juŋ yi bəni bə dzəni kɔ faiŋ ka bɔ bwa bu bə mbaŋ num dzi Dzini bi Ntsədaŋ yɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wi ka ni chusi lum wimbum i juŋ yi bɛiŋ wə num bə kɛiŋsi jiə, yi wɔkɔli a wɔkɔlini, mbɛiŋ liə kɛiŋsi biɛiŋ bidzini yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bwa bu bə mbaŋ bə̀ ka nyə tsə i kwili kintəəŋ, tsə yɛiŋ biɛiŋ bichi num a liŋ asi Jisɔs si dzaka i bɔ. Bɔ ka kɛiŋsi biɛiŋ bi Dzini bi Ntsədaŋ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","A dzə num i fijɔbi, Jisɔs bəh bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa juŋni fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jɔbi wə bɔ nì num kuku ka dziki, Jisɔs yisi i dzakaki i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mi widɔkɔ i mbɛiŋ kintəəŋ ni taŋni lə mih, mi wiwɔ kɔlə fa wi dzi buku wi.” ");
INSERT INTO cug_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Si bɔ wɔkɔ yakadəiŋ, ka numki a nshɛiŋ nshɛiŋ, bɔ bə́ bikə i wi a wimu wimu a, “Akɔ mih ma?” ");
INSERT INTO cug_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Wi chukuli i bɔ a, “Akɔ a mi i mbɛiŋ bələ jwɔfi ntsɔ bəfa kintəəŋ a num wə buku wi ni chiŋni n'yɔkɔ blɛd i tasa mə. ");
INSERT INTO cug_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi wə yɛli wi kɔ Waiŋmi kaŋaki i bi nyə̂ asi bə nì nyaka kɔm wi. Ayakalə, ŋgəkə wimbum kɔ i mi wə wi taŋni mi wə yɛli wi kɔ Waiŋmi. Yi nì ndzɔŋki a bə ma bwɔ wəmaka mi.” ");
INSERT INTO cug_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Asi bɔ nì dziki, Jisɔs dza dzɔ blɛd, nya kiyɔŋni i Nyɔ, gbɛyi, nya i bwa bu bə mbaŋ ka dzaka i bɔ a, “Mbɛiŋ kɔ̂, a fa kɔ gwu yiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wi ka dzɔ tə bwam, nya kiyɔŋni i Nyɔ, ka nya bwam wiwɔ bɔ bəchi mu fiəli. ");
INSERT INTO cug_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Wi ka dzaka i bɔ a, “Mələ kɔ mwa məŋŋ mə Nyɔ dzi miŋkaiŋ bəh mɔ, mɔ shuku buku kɔm bəni bəduli. ");
INSERT INTO cug_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mih fukuki ŋkɔŋ i mbɛiŋ a, mih ni chu mu kə mbih mi kpɛiŋ wi laani wələ i tsə buku i chɔkɔ biə mih bi muki mɔ mimfiaŋ i kintəəŋ ki ntɔŋ bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jɔbi wə Jisɔs bəh bwa bu bə mbaŋ kaasi, bɔ yəəŋ njaŋ wi kɔksini, buku ka yaka tsə i ŋkwuŋ wi Kɛiŋ yi Ɔlif wə. ");
INSERT INTO cug_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisɔs ka dzaka i bɔ a, “Mbɛiŋ bəchi ni fiəni gɛiŋ chu lə i jum wə kɔm gia yə yi ni num bəh mih. Yi num asi bə nyaka a, Nyɔ dzakaki a, ‘Mih ni wɔɔ lə ntɔkni shwáŋ ma shwáŋ yiwɔ ni gaali.’ ");
INSERT INTO cug_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ayakalə, jɔbi wə Nyɔ bi dzasi mih i kpi wə, mih bi tsə i mbɛiŋ nshiŋ i Galili.” ");
INSERT INTO cug_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bita chukuli i wi a, “Kɔŋ Bəni bəchi gɛiŋ chu i jum wə, mih kɔkə ni mɔm i fiəni.” ");
INSERT INTO cug_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisɔs fiəni chukuli i wi a, “Mih fukuki ŋkɔŋ i wɔ a, daiŋ nchɔkɔ, na ka kwɔkɔ ni tɔŋki kiŋkani kifa, num wɔ məŋni lɔ mih kiŋkani kitali.” ");
INSERT INTO cug_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bita baaŋ a dzakaki a dzakani a, “Kɔŋ mih ni numki i kpi buku wɔ, mih kɔkə i ni lansi nəiŋ wɔ.” Si wi dzaka yaka, bədɔkɔ bə̀ bəchi bɔŋ dzaka ayaka tə. ");
INSERT INTO cug_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Bɔ dza tsə sə i di bidɔkɔ wə, bə ni bɔɔŋki a Gɛsɛmane, Jisɔs ka dzaka i bwa bu bə mbaŋ a, “Mbɛiŋ shînumyi fa, mih kini tsə tsa.” ");
INSERT INTO cug_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wi ka dzɔ Bita bəh Jɛm bəh Jɔn, bəh bɔ tsə sə fɛiŋ. Wi dza ka kwakaki gia yiwɔ yi fumsi wi, shɔm yi nya ŋgəkə i wi. ");
INSERT INTO cug_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Wi ka dzaka i bɔ a, “Shɔm yiŋ kɔ a bəh nshɛiŋ nshɛiŋ nalə na ka mih kpi num kpini. Mbɛiŋ bâaŋ a fa bukumbɛiŋ wɔ̂kɔliki.” ");
INSERT INTO cug_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Si wi dzaka yakadəiŋ, ka kini tsə i ninshiŋ, gbɔ i kuku, bə́ tsa a, dzəh kabə num wɔ fə ma jɔbi wi ŋgəkə wələ tsə daŋsi wi. ");
INSERT INTO cug_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wi ka tsa a, “Abba, Ba wuŋ, gia yichi bɔniki lə i wɔ i fə. Dzɔ̂ bwîli bwam wi ŋgəkə wələ i mih wə. Ayakalə, ma yi num asi wɔ kɔŋki. Kɔbi si mih kɔŋki.” ");
INSERT INTO cug_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wi fiəni dzə buku i bɔ wə, ka ti bɔ nɔ wə. Wi bikə i Samɔn a, “Yi kɔ a mbɛiŋ kɔkə i num bɛiŋ bəh mih i tsə buku i mbiəŋə wimu wə a? ");
INSERT INTO cug_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mbɛiŋ tsə̂ŋəki, mbɛiŋ tsâ a kiə kimɔmsi ki dzə kə i mbɛiŋ wə. Yi kɔ ŋkɔŋ a shɔm kɔŋki lə, ayakalə nyam yi gwu bɔhyi.” ");
INSERT INTO cug_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Si wi dzaka yakadəiŋ chu fiəni tsə i tsa, ka tsaki a gia yə wi si yisi tsa. ");
INSERT INTO cug_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Si wi ni fiəni dzə, ka chu ti bwa bu bə mbaŋ nɔ wə kɔm kinu nì kɔ i dzə́kəh yibɔ wə nalə. Ayaka bɔ nəki kiə kə gia yə bɔ kɔ i chukuli. ");
INSERT INTO cug_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wi chu fiəni dzə i kiŋkani kitali wə, bikə i bɔ a, “Mbɛiŋ kɛiŋki mbɛiŋ nɔ a nɔni waka fimbɛiŋ a? Yi dzə kpɛiŋ i liə. Jɔbi wiwɔ dzə kpɛiŋ. Bə kɔ bə taŋni lɔ mi wə yɛli wi kɔ Waiŋmi i kaŋ yi bəni bəchu wə. ");
INSERT INTO cug_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mbɛiŋ dzâ bɛiŋ bukumbɛiŋ tsə̂ki. Mbɛiŋ tsɛ̂iŋ, mi wə wi taŋni mih bə wi yaka wi dzə.” ");
INSERT INTO cug_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Asi Jisɔs nì kɛiŋki wi dzaka, akisəkə Judas wə wi nì kɔ mi i mbaŋ wi bwa bə Jisɔs bə̀ jwɔfi ntsɔ bəfa dzə tumbuku. Wi ni dzəki bəh mbaŋ wi bəni bɔ kaŋa bənywɔ bəh bibɔkɔ, num a faaŋ bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bəh bəni bə̀ bɔ sakaki tumi. ");
INSERT INTO cug_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","A nì kɔ num mi wə wi taŋni Jisɔs, tsə kɛiŋsi lɔ kinchəsi bəh bəni bəwɔ ka dzaka a, “Mi wə mih ni bɔni, mih maŋni yaŋyi, akɔ wi mbɛiŋ ni kwâ, mbɛiŋ tɔ̂kniki ka wi ma gɛ̂iŋ.” ");
INSERT INTO cug_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Si Judas dzaka yaka, akisəkə ka nyə tsə i Jisɔs wə, bɔni wi a, “Mi wi Lanini.” Si wi bɔni yaka, bə́ maŋni wi yaŋyi. ");
INSERT INTO cug_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bəni bəwɔ ka kwa kaŋa Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mi widɔkɔ wə wi nì kɔ bɔ bəh Jisɔs ka guku baa nywɔ wi jum, gba chwiŋ təiŋ kintuni ki mfa wi fwu wi bətii mfə gia yɛiŋ, ki təiŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisɔs bikə i bəni bəwɔ a, “Mbɛiŋ dzə i kwa mih ka dzəki bəh bənywɔ tasi bəh bibɔkɔ ka mbɛiŋ dzəki i kwa num ji a? ");
INSERT INTO cug_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mih nì shi kɔ bəh mbɛiŋ chɔksi chɔksi i juŋ yi fəni yi gia mə, lani bəni, mbɛiŋ na dzə kwa mih. Ayakalə, yələ num lə ka gia yə bə nì nyaka i Kiŋwakti ki Nyɔ wə ni dzə kpɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bwa bə Jisɔs bə mbaŋ bəchi sɛiŋ bee wi fɛiŋ ka gɛiŋ bəchi. ");
INSERT INTO cug_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ayaka waiŋ sumi widɔkɔ bə́ biəli wi, maka wi lɔh fiɛŋ fidɔkɔ i gwu yi wə, a num shəŋ a tsɛiŋ yi mbuŋ i gwu yi wə. Bɔ tsə i kwa tə wi, ");
INSERT INTO cug_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Wi shwa bee tsə mbuŋ wiwɔ, ka yɔkɔ gɛiŋ bəh chwɔŋ kiyəə. ");
INSERT INTO cug_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Bɔ ka dzɔ Jisɔs, tsə bəh wi i fwu wi bətii mfə gia wə. Bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi bəh bəni bə̀ bɔ laniki bənchi bɔ juŋni fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bɔ nyə bəh Jisɔs, Bita biəli i jum wə i dzəh yi dəəŋ. Wi tsə buku na i tɔkɔ wi fwu wi bətii mfə gia wə, ka shinum bəh bəni bə̀ bɔ nì chəniki kwili wiwɔ ka jɔkɔki gbuku. ");
INSERT INTO cug_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","I fɛiŋ wə bətii mfə gia bəmbum bəh bəni bəchi bə̀ bɔ sakaki bənsaka bə́ nəŋ gia yə bɔ ki jiəki i Jisɔs fuŋ, ka bɔ ni wɔɔ wi. Ayakalə, bɔ nəki kwati kə gia yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bəni bəduli ka beeŋki nsaka wi ntəkə i jum wə kɔm Jisɔs. Ayakalə, bəndzaka bəbɔ nì kɔ chi chi bɔ na kwati dzəh yə bə kɔ i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Bəni bədɔkɔ dza numbɛiŋ, ka beeŋki nsaka wi ntəkə i wi fuŋ dzaka a, ");
INSERT INTO cug_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Buku ni wɔkɔ wi dzaka a ŋgaiŋ ni shakyi lə juŋ yi fəni yi gia yələ mi wiwɔm maa, ma ŋgaiŋ dzɔ kaŋ yitali i fiəni maa yə aka maa dəkə mi wiwɔm.” ");
INSERT INTO cug_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na si bɔ nì dzakaki yakadəiŋ, bəndzaka bəbɔ nì kɔ chi chi bɔ na kwati dzəh yə bə kɔ i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Fwu wi bətii mfə gia wiwɔ ka dza numbɛiŋ i bɔ nshiŋ, ka bikə i Jisɔs a, “Yaka wɔ kaŋaki kə gia i chukuli i gia yə bəni bələ dzakaki kɔm wɔ a?” ");
INSERT INTO cug_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ayakalə, Jisɔs kpichumi mɔŋ, nəki chukuli kə. Fwu wi bətii mfə gia wiwɔ chu bikə i Jisɔs a, “Akɔ wɔ Kimbwili wə Nyɔ nì kaka, Waiŋ Nyɔ wə bə kɔksiki a?” ");
INSERT INTO cug_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisɔs chukuli a, “Akɔ mih. Mbɛiŋ ni yɛiŋ lə mi wə yɛli wi kɔ Waiŋmi num wi shinum i tsɛiŋ yiləkəli yi Wi wə wi kaŋaki Ŋga, mbɛiŋ chu fiəni yɛiŋ si wi shiki dzəki i bɛiŋ i bikwu wə.” ");
INSERT INTO cug_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","I fɛiŋ wə fwu wi bətii mfə gia wɔkɔ yaka, ka taŋyi bəmbuŋ i gwu yi wə, bikə a, “Bukumbɛiŋ nəŋki i chu wɔkɔ a nə, num wi dzaka kaasi lɔ gia yichi a? ");
INSERT INTO cug_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mbɛiŋ wɔkɔ alə si wi dzɔki di bi Nyɔ a? Mbɛiŋ dzaka yimbɛiŋ a nə?” Bəni bəchi təiŋ a wi kɔ mi ka bə wɔɔ num wɔɔni. ");
INSERT INTO cug_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bəni bədɔkɔ yisi i chuhyiki mindzəŋ i Jisɔs wə, kaŋa baŋ dzə́kəh yi, ka twɛiŋki wi bikə i wi a, fuku mi wə wi twɛiŋ wɔ, “Fuku la ntum wi Nyɔ wa wə i liə.” Bəni bə jum yisi i nyiksiki Jisɔs twɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Si Bita nì kɔ num wi num i kimbu ki dzəshi ki tɔkɔ wə, waiŋkpaŋni widɔkɔ wə wi nì nɔmki i kwili wi tii mfə gia wə, dza kɔmsi dzə i Bita wə. ");
INSERT INTO cug_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Si wi yɛiŋ Bita wi jɔkɔki gbuku, wi tsɛiŋ wi lə tulululu, ka dzaka a, “Wɔ tə si kɔlə mbɛiŋ bəh Jisɔs wi Nasali wəyaka.” ");
INSERT INTO cug_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bita nəiŋ, ka dzaka a, “Mih kiəki kə gia yə wɔ dzakaki yaka. Mih kiəki kə.” Si wi dzaka yakadəiŋ, nyə fɛiŋ ka tsə i dzaka ki mbaiŋ wə, kwɔkɔ ka tɔŋ. ");
INSERT INTO cug_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jɔbi wə waiŋkpaŋni wə nì chu yɛiŋ wi, dzaka i bəni bə̀ bɔ ni numyi fɛiŋ a, “Mi wələ kɔ mi i bɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bita chu nəiŋ. A i jɔbi wi twɛsi wə, bəni bə̀ bɔ ni numyi fɛiŋ bɔ chu dzaka i Bita a, “I yi ŋkɔŋ wə akɔ mbɛiŋ bɔ, kɔm wɔ kɔ tə mi wi Galili.” ");
INSERT INTO cug_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bita ka kaiŋ, bɔɔŋ num lɔiŋ i fwu wi wə i dzaka a, “Mih kiəki kə mi wə mbɛiŋ dzaka kɔm wi.” ");
INSERT INTO cug_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Akisəkə kwɔkɔ chu tɔŋ i kiŋkani kifa wə. Si wi wɔkɔ yaka ka kwaka ndzaka wə Jisɔs nì dzaka i wi a, “Ka kwɔkɔ ni tɔŋki i kiŋkani kifa wə, a ni numki num wɔ nəiŋ lɔ mih i kiŋkani kitali wə.” I fɛiŋ wə, wi gbɔ mindəm ka dəki. ");
INSERT INTO cug_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Asi biŋ nì baiŋki dzəki, bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi bəh bəni bə̀ bɔ laniki bənchi, bəh kansi wichi shinum ka jiə kimfasi, kaŋa Jisɔs, dzɔ wi tsə nya i kaŋ yi Baylɛ Gɔmna wi Lum. ");
INSERT INTO cug_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Baylɛ bikə i Jisɔs a, “Akɔ wɔ Ŋkuŋ wi Bəju a?” Jisɔs chukuli i wi a, “Yi kɔ asi wɔ dzaka.” ");
INSERT INTO cug_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bətii mfə gia bəmbum ka yisi i jiəki gia i Jisɔs fuŋ yiduli. ");
INSERT INTO cug_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ayakadəiŋ, Baylɛ chu bikə i Jisɔs a, “Wɔ kaŋaki kə gia i chukuli a? Wɔ wɔkɔ alə gia yə bə jiəki i wɔ fuŋ a?” ");
INSERT INTO cug_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ayakalə, Jisɔs na chu chukuli wi. Baylɛ num bəh ŋkaŋyi. ");
INSERT INTO cug_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","A nì dzəki numki i jɔbi wi Dzini bi Ntsədaŋ biələ wə, Baylɛ bwili mi wi juŋ yi nsəŋ wimu wə Bəju tsa a wi bwîli. ");
INSERT INTO cug_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","A nì kɔ i jɔbi wiwɔ wə, mi widɔkɔ num i juŋ yi nsəŋ mə yɛli wi num a Balabas, wi nì kɔ i mbaŋ wi bəni bə̀ bɔ nì kɔ i juŋ yi nsəŋ mə, num bɔ nì yisi ndani i tumi wə wɔɔyi bəni. ");
INSERT INTO cug_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mbaŋ wi bəni dzə yisi i bikəki a Baylɛ fə̂ asi wi nì fəki wi fə i bɔ. ");
INSERT INTO cug_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Baylɛ ka bikə i bɔ a, “Mbɛiŋ nəŋki a mih bwili num ŋkuŋ wi Bəju wələ a?” ");
INSERT INTO cug_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wi nì bikəki yaka kɔm wi nì kɔ wi kiə a bətii mfə gia bəmbum nya Jisɔs i kaŋ yi wə kɔm bɔ ni chiniki kindɔŋ bəh wi. ");
INSERT INTO cug_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ayakalə, bətii mfə gia bəmbum nyini mbaŋ wi bəni a bɔ dzaka a wi bwîli num Balabas. ");
INSERT INTO cug_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Baylɛ chu bikə i bɔ a, “Ayakadəiŋ, mih ki fəki dəiŋ bəh mi wələ mbɛiŋ bɔɔŋki a ŋkuŋ wi Bəju a?” ");
INSERT INTO cug_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Bɔ ka wam na bəh ŋga a, “Bə bâŋŋ wi i kintasi wə.” ");
INSERT INTO cug_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Baylɛ bikə i bɔ a, “Bə bâŋŋ wi kɔm nə? Gia yichu yə wi fə kɔ nə?” Ayakalə, bɔ ka chu wili tsə a ninshiŋ a, “Bə bâŋŋ wi i kintasi wə.” ");
INSERT INTO cug_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ayakadəiŋ, Baylɛ ka bwili yatɔkɔ Balabas kɔm wi nì nəŋki i fə a mbaŋ wi bəni kɔŋki ŋgaiŋ. Wi dzaka a bə twɛ̂iŋ Jisɔs, ma bə tsə̂ bâŋŋ i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Bəni bə jum bə Baylɛ ka dzɔ Jisɔs liə bəh wi i ntɔŋ wə bə nì bɔɔŋki a Blitɔlium. Si bɔ liə, ka bɔɔŋ juŋni mbaŋ wi bəni bə jum bəchi. ");
INSERT INTO cug_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ayaka bɔ ka dzɔ mbuŋ wi bəŋkuŋ tum i wi wə, chu bwaŋ kifɔ ki bəŋkuŋ num bə bwaŋyi bəbwaŋyi yɛiŋ ka bwaŋ i wi fuŋ. ");
INSERT INTO cug_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Bɔ yisi ka beeŋki wi dzaka a, “Mbɛɛ jum yi bɔkɔli. Ŋkuŋ wi Bəju.” ");
INSERT INTO cug_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Si bɔ fə yakadəiŋ ka twɛiŋki wi bəh bəmbəŋ i fwu wə, chuhyi midziŋ i gwu yi wə, dzə tum binyu i wi nshiŋ, beŋŋ wi. ");
INSERT INTO cug_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Si bɔ nì nyiksi kaasi wi yaka, ka fiəni babwili mbuŋ wi ŋkuŋ wə i gwu yi wə, fiəni dzɔ lɔh num bəmbuŋ bu i gwu yi wə, ka dzɔ tsə bəh wi baŋŋ i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jɔbi wə bɔ nì tsəki bəh wi, mi widɔkɔ baŋsi bəh bɔ wi kwɛ i chwa yɛli num Samɔn, a num mi wi Sɛlin. Wi num tii Alɛksanda bəh Lufus. Ayaka bɔ ka kaŋyi wi a wi gîŋ kintasi ki Jisɔs. ");
INSERT INTO cug_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bɔ tsə buku bəh Jisɔs i di biə bɔ nì bɔɔŋki a Gɔlgɔta, (Ayaka yɛli wələ kɔ a di bi Ŋkuŋu Kifwu), ");
INSERT INTO cug_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","bɔ ka nya mbih i wi a wi mu num bɔ chwali bəh tsa yidɔkɔ bə nì bɔɔŋki a mɛɛl. Ayaka Jisɔs nəki mu kə. ");
INSERT INTO cug_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bɔ ka baŋŋ wi i kintasi wə. Bɔ dzɔ bəmbuŋ bu gaa a fwu fwu wə ka tumki kaaŋ bəh bəmbuŋ bəwɔ i kiə si mi wimu kɔ i kwati. ");
INSERT INTO cug_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jɔbi wə bə nì baŋŋ Jisɔs i kintasi wə, a nì kɔ jɔbi num mbiəŋə bwukə kinchɔŋɔchɔŋɔ. ");
INSERT INTO cug_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Bɔ nì nyaka kiŋwakti ka baŋŋ i kintasi ki chusi gia yə yi fə ka bɔ baŋŋ wi, yi num a, wi kɔ, “Ŋkuŋ wi Bəju.” ");
INSERT INTO cug_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bɔ baŋŋ tə bəji bəfa i kintasi wə, widɔkɔ i tsɛiŋ yi Jisɔs yiləkəli wə, widɔkɔ i tsɛiŋ yi kimiəkə wə.  ");
INSERT INTO cug_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yələ dzə kpɛiŋ asi bə nì nyaka i Kiŋwakti ki Nyɔ wə a, “Bə nì fa chiŋni wi i mbaŋ wi bəni bə̀ bɔ nì mɔmki gia.” ");
INSERT INTO cug_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Bəni ka tsəki daŋsiki yɛiŋ Jisɔs nəŋni fwu, bəkəli wi bəh ntɔyi dzaka a, “Aŋghaaa! Wɔ wələ wɔ nì kɔ i shakyi juŋ yi fəni yi gia i fiəni maa i kaŋ yitali wə, ");
INSERT INTO cug_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","gamti la gwu ya i shi dzə i kintasi kiwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bɔ ka suŋuki tə wi a bɔ bɔ dzakayi a, “Wi nì gamtiki bəni bədɔkɔ i liə wi kɔkə i gamti gwu yi. ");
INSERT INTO cug_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wi wə wi kɔ Kimbwili wə Nyɔ nì kaka, wi num ŋkuŋ wi bəni bə Islae wi shî la i kintasi kiwɔ wə i liə ma buku yɛiŋ ka buku bum wi.” Bəni bə̀ bə nì baŋŋ bɔ bəh Jisɔs i kintasi wə bɔŋ lɔyi tə Jisɔs bəh já. ");
INSERT INTO cug_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A dzə num nshichuŋ biŋ ji, tumi kichi ji i tsə buku i mbiəŋə mitali wə nshiŋ fɔkɔ. ");
INSERT INTO cug_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","A dzə num ka mbiəŋə mitali, Jisɔs dza wam bəh ŋga a, “Ɛlɔy Ɛlɔy lama sabaktani,” Yi num a, “Nyɔ wuŋ, Nyɔ wuŋ, wɔ lɔtɔkɔ mih kɔm nə lə a?” ");
INSERT INTO cug_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Bəni bədɔkɔ bə̀ bɔ nì num kɔmsi fɛiŋ wɔkɔ ka dzaka a, “Mbɛiŋ wɔ̂kɔ, wi bɔɔŋki Ɛlaja.” ");
INSERT INTO cug_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Mi widɔkɔ i bɔ kintəəŋ ka yɔkɔ tsə dzɔ kuncha, juli i mbih migbaŋlini mə, bwaŋ i mbəŋ wə sɔkɔ tsə a wi mu, ka dzaka a, “Bə bee wi yaka bə yɛiŋ yudɔkɔ Ɛlaja ni dzə bwili lə wi i kintasi kələ wə.” ");
INSERT INTO cug_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jisɔs dza wam bəh ŋga ka waka kiŋ'waka ki kigɔksini. ");
INSERT INTO cug_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mbuŋ wə bə nì təiŋni juŋ yi fəni yi gia yɛiŋ i numə taŋa shi i fintəŋ i bimbu bifa wə i yisi bɛiŋ shi buku kuku. ");
INSERT INTO cug_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tikwili wi bəni bə jum wə num i Jisɔs nshiŋ ka yɛiŋ dzəh yə Jisɔs kpi yɛiŋ, ka dzaka a, “Mi wələ nì kɔ Waiŋ Nyɔ ŋkɔŋ.” ");
INSERT INTO cug_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Bəkaŋa bədɔkɔ nì kɔ fɛiŋ num bɔ num i dzəh yi dəəŋ bə́ tsɛiŋ. I mbaŋ wiwɔ wə nì kɔ Meli Magdalen bəh Salɔme bəh Meli wə nih Jɛm winchiŋ bəh Yɔsɛs. ");
INSERT INTO cug_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Bəkaŋa bələ kɔ bə̀ bɔ nì biəliki Jisɔs i Galili gamti wi. Bɔ nì kɔ fɛiŋ bəh bəkaŋa bədɔkɔ tə bəduli bə̀ bɔ nì biəli Jisɔs bəh bɔ dzə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A dzə num i fijɔbi, kɔm a nì kɔ Chɔkɔ bi Sisini i dza liə i chɔkɔ bimbam wə, ");
INSERT INTO cug_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mi wi Alimatia widɔkɔ bə bɔɔŋ a Yɔsɛf, kaŋa shɔm tsə yɛiŋ Baylɛ ka nywa wini wi Jisɔs i tsə ləə. Yɔsɛf wələ nì kɔ i mbaŋ wi bəni bə̀ bɔ sakaki tumi, bəni nì kɔksiki lə wi na bindzɔŋ. Ayaka wi mwi nì wɔkɔliki lə tə jɔbi wə ŋkuŋ bi Nyɔ bi dzəki. ");
INSERT INTO cug_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Si Baylɛ wɔkɔ yakadəiŋ, dzaka wɔm wi a Jisɔs si kpi lɔ. Wi bɔɔŋ fwu wi bəni bə jum, ka bikə wɔkɔ i wi a Jisɔs si kpi lɔ a. ");
INSERT INTO cug_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Wi ka wɔkɔ i fwu wi bəni bə jum wiwɔ a Jisɔs si kpi lɔ, wi ka nya wini wiwɔ i Yɔsɛf. ");
INSERT INTO cug_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yɔsɛf ka nyə tsə taŋ mbuŋ wi ndzɔŋni, tsə shisi wini wi Jisɔs, kii wini wiwɔ, tsə jiə i jum yə bə nì chum i biaŋa wə, ka beeŋsi təh wimbum baŋ dzaka ki jum kiwɔ bəh wi. ");
INSERT INTO cug_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meli Magdalen bəh Meli wə nih Yɔsɛs yɛiŋ di biə bə ləə Jisɔs yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Si chɔkɔ bimbam nì tsə, Meli Magdalen bəh Meli wə nih Jɛm, bəh Salɔme taŋ kidzɛni ki tsɛŋə yindzɔŋni ka bə́ tsə i fiaŋsi wini wi Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","A dzə num na kinchɔŋɔchɔŋɔ i chɔkɔ bi ninshiŋ i shi wə, asi wɔŋ kakaki dzəki, bɔ nyə tsə i jum bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Bɔ ka tsəki yaka dzakayi a bɔ bɔ a, ni numki ndə i biŋsi təh wə bəh ni baŋ dzaka ki jum kə yɛiŋ na? ");
INSERT INTO cug_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Si bɔ tsəki yaka, bɔ ka lɔ dzəkəh, yɛiŋ num bə biŋsi bwili lɔ təh wiwɔ. Təh wələ nì kɔ na kimfaaŋ ki təh. ");
INSERT INTO cug_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bɔ ka liə tsə i jum mə, yɛiŋ sumi yidɔkɔ si wi shinum i jum mə i tsɛiŋ yiləkəli wə num wi lɔh mbuŋ wi dəəŋ a num wi fukuli. Gwu yɔkɔ bɔ lə wiii. ");
INSERT INTO cug_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sumi yiwɔ dzaka i bɔ a, “Kiə dzaka ki wɔ̂m kə mbɛiŋ. Mih kiəki lə a mbɛiŋ nəŋki num Jisɔs wi Nasali wə bə ni baŋŋ i kintasi wə. Wi chu mɔŋ fa. Wi dza lɔ i kpi wə. Mbɛiŋ tsɛ̂iŋ yɛ̂iŋ di biə bə ni nɔsi wi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mbɛiŋ tsə̂ fûku i bwa bu bə mbaŋ bəh i Bita a wi tsə lɔ i ninshiŋ i Galili. Mbɛiŋ ni yɛiŋ lə wi fɛiŋ asi wi nì dzakaki i mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bəkaŋa bə̀ buku i jum yiwɔ wə nyumyi lə kəkəkə, dza fɛiŋ gɛiŋ num lɔ gɛiŋni, num dzaka wɔm bɔ nalə. Bɔ nəki dzaka kə gia yiwɔ i mi, kɔm bɔ nì lwaki lə.  ");
INSERT INTO cug_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisɔs nì dza i kpi wə i chɔkɔ bi ninshiŋ i shi wə biŋ kɛiŋ bilibili, yisi tumbuku num i Meli Magdalen wə wi nì bwili bəchinda bə ŋkpɛli i gwu yi wə nanitaŋ. ");
INSERT INTO cug_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Meli ka tsə fuku i bəni bə̀ bɔ bəh Jisɔs nì shi kɔ. Bəni bələ nì kɔ bɔ də ka chuŋsi kifwu. ");
INSERT INTO cug_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Si bɔ nì wɔkɔ si miŋkpaŋa wələ dzakaki a ŋgaiŋ si yɛiŋ Jisɔs, wi num wiwɔm, bɔ nəki bum kə. ");
INSERT INTO cug_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Si yəmaka nì tsə Jisɔs chu chusi gwu yi i bəni bu bə mbaŋ bədɔkɔ bəfa bə̀ bɔ nì tsəki i kwili widɔkɔ wə, ayaka bɔ nəki yɛiŋ kiə kə wi. ");
INSERT INTO cug_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bɔ fiəni i jum wə, tsə fuku i kiŋka ki bəni bə mbaŋ bəbɔ, bɔ nəki bum kə bɔ. ");
INSERT INTO cug_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Si yəmaka nì tsə Jisɔs chusi gwu yi na i bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ mu mwi bɔ dzi wə. Wi yɔli i bɔ, kɔm bɔ nì kaŋaki kə kimbum kiləkə, bəh shɔm yiləkəli i bum i bəni bə̀ bɔ nì yɛiŋ wi, i jɔbi wə wi nì dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wi ka dzaka i bɔ a “Mbɛiŋ tsə̂ i mbi wichi wə i tsə̂ fûkuki ntum wi ndzɔŋni wi Nyɔ i bəni bəchi. ");
INSERT INTO cug_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mi wə wi bum gia yiwɔ, bə jûli wi i bɔkɔ, wi ni bɔiŋ. Mi wə wi nəiŋma i bum, kɔ wi, wə wi gbɔ nsaka. ");
INSERT INTO cug_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Bəni bə̀ bɔ kɔ bɔ bum bɔ bi fəki lə bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ ka bələ: Bɔ bi bwiliki lə bəchinda bə ŋkpɛli i bəni wə i yɛli wuŋ wə. Bɔ num i ni dzakaki já yimfiaŋ. ");
INSERT INTO cug_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bɔ num i kaŋaki júŋ bəh kaŋ. Bɔ num i mu kiləfi, ki kɔbi i fə gia yidɔkɔ bəh bɔ. Bɔ jiəki kaŋ i bəni bə jwɛiŋ wə, bɔ bɔnih.” ");
INSERT INTO cug_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Si Bah Jisɔs dzaka kaasi i bɔ yakadəiŋ, Nyɔ ka dzɔ yaka bəh wi i bɛiŋ wi tsə shinum i tsɛiŋ yiləkəli yi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Bwa bu bə mbaŋ bə̀ buku ka nyaniki fukuki ntum wi ndzɔŋni wiwɔ i di bichi wə. Bah num bəh bɔ tɔbi gia yə bɔ fukuki a yi kɔ ŋkɔŋ bəh bənchəsi bə̀ bɔ nì fəki yi chusi ŋga bi Nyɔ.");
INSERT INTO cug_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mi wimbum Teɔfilus, bəni bəduli nì mɔmsi lɔ i nyaka kɔm gia yə yi nì num i buku kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Bɔ nì nyaka gia yiwɔ a liŋ liŋ num a yə buku nì wɔkɔ i bəni bə̀ bɔ nì yɛiŋ bəh dzə́kəh yibɔ, ka fukuki yi asi yi nì yisi. ");
INSERT INTO cug_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Si mih dzɔ jɔbi, nəŋ gia yiwɔ yichi na i kin'yisi wə, ka yɛiŋ a yi si ndzɔŋki lə i mih i chiŋni nyaka tə i wɔ i dzəh yindzɔŋni wə. ");
INSERT INTO cug_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mih fə lə ka wɔ kîə ŋkɔŋ bi gia yə bə kɔ bə fuku lɔ i wɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jɔbi wə Ŋkuŋ Hɛlɔd nì sakaki Judea, tii mfə gia widɔkɔ nì kɔlə bə bɔɔŋ a Sakalia. Wi nì nɔmki i mbaŋ wi tii mfə gia wi Abija wə, nih juŋ wi tə nì buku i chwɔŋkijuŋ ki Ɛlɔŋ wə, bə bɔɔŋ wi a Ɛlisabɛt. ");
INSERT INTO cug_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Bəni bələ bəfa nì kɔ bəni bɔ num chəŋ i Nyɔ nshiŋ, bɔ jiə bənchi bə Bah bəchi, bɔ kaŋa kə ŋgbɔ widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ayakalə, bɔ nì kaŋaki kə waiŋ, kɔm Ɛlisabɛt nì kɔ kaiŋni, num bɔ bəchi nì kɔ bɔ jwiŋ lɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jɔbi dzə kpɛiŋ wə, mbaŋ wi Sakalia ni nɔmki i juŋ yi fəni yi gia yi Bah wə. A nì kɔ wi tii mfə gia i Nyɔ nshiŋ chɔkɔ biwɔ, ");
INSERT INTO cug_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","bə nì babwili wi, biəli asi bɔ nì bayiki bətii mfə gia i nɔni kibɔ wə. Wi ka liə i juŋ yi fəni yi gia wə i kpa njiəŋ. ");
INSERT INTO cug_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ayaka jɔbi kpɛiŋ i kpa njiəŋ, bəni bəchi bə̀ bɔ nì kɔ biŋ bɔ tsa wə. ");
INSERT INTO cug_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Chinda wi Bah tumbuku alə i wi nshiŋ, ka num i tsɛiŋ yiləkəli yi tɔŋ wi njiəŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jɔbi wə Sakalia ni yɛiŋ wi, shɔm təiŋ wi, wi lwa. ");
INSERT INTO cug_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ayakalə, chinda wə dzaka i wi a, “Sakalia ki lwâ kə. Nyɔ wɔkɔ lɔ ntsa wa. Nih juŋ wa Ɛlisabɛt bi bwɔ lə waiŋ wi nyukuni, wɔ ni du yɛli wi a Jɔn. ");
INSERT INTO cug_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wi bi dzə bəh kinsaŋli bəh nlaŋ i wɔ, ayaka bəni bəduli bi num lə bəh kinsaŋli kɔm mbwɔ wi. ");
INSERT INTO cug_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wi bi num mi wimbum i Nyɔ nshiŋ. Kiə wi bi mû kə mbih, kighə miləkəli. Kiŋ'waka ki Baiŋni bi jiksiki lə wi, wi kɛiŋ i nih wi shɔm. ");
INSERT INTO cug_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wi bi fə ka bəni bə Islae bəduli kwuni shɔ́m yibɔ, yi fiəni chu i Bah Nyɔ wibɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Wi bi tsə i Bah nshiŋ, bəh shɔm bəh ŋga bi Ɛlaja, i kwuni shɔm yi bətii bwa, yi bi num i bwa bəbɔ. Wi bi fə bəni bə ləkəni kifwu, bee kifwu kiləkəli, kwuni nɔni bibɔ, kaŋa kiŋkwaka ki num ki bəni bə chəŋ. Wi bi fə yaka ka bəni bi numki bəh ŋkɛiŋsi wi gwu i wɔkɔliki Bah.” ");
INSERT INTO cug_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ayaka Sakalia nì bikə i chinda wi Nyɔ a, “Mih bi kiə gia yələ dəiŋ num buku nih juŋ wuŋ jwiŋ lɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chinda wi Nyɔ chukuli a, “Akɔ mih Gabliya, mih numki a bəh gvu i Nyɔ nshiŋ jɔbi wichi, a faaŋ wi mih a mih dzə fuku ntum wi ndzɔŋni wələ i wɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wɔ̂kɔli, si wɔ ka bum dəkə ja yiŋ yələ, jɔbi bi dzə kpɛiŋ lə wə yi kaŋa i bi num, i liə wɔ ki fîəniki lə kinchini, chu dzaka kə, i tsə̂ bûku i jɔbi wə gia yələ bi numki.” ");
INSERT INTO cug_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Si yi nì numki yaka, bəni bə̀ bɔ nì kɔ i biŋ wɔkɔli Sakalia ka num bəh ŋkaŋyi a, a num nə wi mɔtsəsi i fɛiŋ numə i juŋ yi fəni yi gia lə a? ");
INSERT INTO cug_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jɔbi wə wi nì buku dzə fɛiŋ, wi chu kiə kə i dzaka i bɔ. Ayaka bɔ ka kiə a Nyɔ si chusi gia yi kaŋyini i wi fɛiŋ numə i juŋ yi fəni yi gia wə. Wi bə́ fəkəliki kinchəsi ki gia i bɔ bəh kaŋ, chu dzaka kə. ");
INSERT INTO cug_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jɔbi wə Sakalia nì kaasi nɔm wi i juŋ yi fəni yi gia wə, wi ka fiəni tsə i wi dzu. ");
INSERT INTO cug_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Asi kaŋ yidɔkɔ tsə, kpə wi Ɛlisabɛt num bəh tɔɔ, ka numki a dzu i kifiəŋŋ kite wə. ");
INSERT INTO cug_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ayaka Ɛlisabɛt ka dzaka a, “I liə Bah nì kwasi lɔ nshɛiŋ i mih, ka bwili kiŋgəmni i fwu wuŋ wə i bəni kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ayaka tɔɔ wi Ɛlisabɛt buku kifiəŋŋ kisɔɔ, Nyɔ faaŋ chinda wi Gabliya i kwili widɔkɔ wə i Galili bə bɔɔŋ a Nasali. ");
INSERT INTO cug_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Wi nì tsə bəh ntum i waiŋ sumi widɔkɔ bə bɔɔŋ a Meli wi kɛiŋ a shu wi waiŋkpaŋni. Wi nì kɔ num bə kɛiŋsi a wi bi num kpə Yɔsɛf wə wi nì kɔ i chwɔŋkijuŋ ki Ŋkuŋ Dɛbit wə. ");
INSERT INTO cug_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chinda wi Nyɔ wiwɔ tsə yɛiŋ Meli ka bɔni i wi a, “Mih bɔniki wɔ, Bah chusi lɔ shɔm yi yindzɔŋni i wɔ ka num bəh wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Meli wɔkɔ yaka yi fumsi wi bəh ŋga, wi ka məŋki a kələ ki bɔni kɔ kinaiŋ lə. ");
INSERT INTO cug_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ayakalə, chinda wi Nyɔ dzaka i wi a, “Meli ki lwâki kə, Nyɔ baa wɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wɔ̂kɔli, wɔ bi num lə bəh tɔɔ, wɔ bwɔ waiŋ nyukuni, ma wɔ bi du yɛli wi a Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wi bi num mi wimbum, ma bə bi bɔɔŋki wi a Waiŋ Nyɔ, Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə. Bah Nyɔ bi tɔm lə wi i kiŋgbɔkɔ ki Ŋkuŋ Dɛbit wə wi kɔ tikwili i chwɔŋkijuŋ kibɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Wi bi sakaki lə chwɔŋkijuŋ ki Yakɔb jɔbi wichi, ayaka ŋkuŋ bi bi kaŋa kə kiŋgɔksi.” ");
INSERT INTO cug_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Meli ka bikə i chinda wi Nyɔ wiwɔ a, “Yələ gia bi num dəiŋ na, mih kɛiŋ shu wi waiŋkpaŋni a?” ");
INSERT INTO cug_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chinda wi Nyɔ wiwɔ chukuli i wi a, “Kiŋ'waka ki Baiŋni bi dzə lə i wɔ wə, ayaka ŋga bi Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə bi kumi baŋ wɔ. Ayakadəiŋ, waiŋ wə wɔ bi bwɔki bi numki wə wi baiŋki, bə bi bɔɔŋki wi a Waiŋ Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wɔ̂kɔli, waiŋ winnah Ɛlisabɛt kɔ wi jwiŋ, a num wə bə nì bɔɔŋki a kaiŋni, wi kɔ i liə bəh tɔɔ i kifiəŋŋ kisɔɔ wə, wi bi bwɔ lə waiŋ nyukuni. ");
INSERT INTO cug_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kîə a gia yidɔkɔ kɔkə yə yi kɔ i gaka Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ayaka Meli ka dzaka a, “Yɛ̂iŋ, bə mih lə fa waiŋ wi nɔm wi Bah. Ma yi nûm ayaka i mih asi wɔ dzaka.” Si wi dzaka yaka, chinda wi Nyɔ ka nyə. ");
INSERT INTO cug_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","A kaŋ yiwɔ wə, Meli kɛiŋsi gwu ka kɔmsi nyə tsə i kwili widɔkɔ wə i tumi ki ŋkwuŋ wi Judea wə, ");
INSERT INTO cug_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","wi tsə buku fɛiŋ, liə i Sakalia dzu ka bɔni i nih juŋ wi Ɛlisabɛt. ");
INSERT INTO cug_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Si Ɛlisabɛt nì wɔkɔ mbɔni wi Meli yaka, waiŋ ka təkəli i wi shɔm. Kiŋ'waka ki Baiŋni jikə i wi wə. ");
INSERT INTO cug_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wi ka yɔŋsi bəh ŋga, dzaka a, “Kimbɔiŋsi ki Nyɔ kɔ i gwu ya wə tsə bəkaŋa bəchi, ayaka kimbɔiŋsi num i waiŋ wə wɔ bi bwɔki. ");
INSERT INTO cug_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yələ gia yimbum lə num dəiŋ lə, a nih Bah wuŋ laa njikə i mih a? ");
INSERT INTO cug_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wɔ̂kɔli, jɔbi wə mih si wɔkɔ mbɔni wa, waiŋ təkəli i mih shɔm bə kinsaŋli. ");
INSERT INTO cug_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kinsaŋli kimbum kɔ i wɔ kɔm wɔ bum a, gia yə Ba nì dzaka i wɔ, bi dzə kpɛiŋ lə.” ");
INSERT INTO cug_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Meli dzaka a, “Shɔm yiŋ kɔksiki Bah, ");
INSERT INTO cug_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","mih saŋliki lə bəh Nyɔ wə wi kɔ Mbwili wuŋ. ");
INSERT INTO cug_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wi kwaka mih, mih num kanti waiŋ wi, wi nɔm wi nchiŋ. Yɛ̂iŋ i yisi i liə i tsəki ninshiŋ ŋgɔkɔ wichi bi bɔɔŋki mih a, mi wə Nyɔ jiə kimbɔiŋsi i wi wə, ");
INSERT INTO cug_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","kɔm Nyɔ wi Ŋga Bichi fə lɔ, gia yimbum yiduli i mih. Yɛli wi kaŋaki kə kinsini. ");
INSERT INTO cug_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wi chusiki nshɛiŋ i bəni bə̀ bɔ kɔksiki wi, nshɛiŋ yələ num i ŋgɔkɔ wichi. ");
INSERT INTO cug_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wi chusi ŋga bi bəh tsɛiŋ yi, wi shakyi bəni bə̀ bɔ ghaŋsiki gwu, kimfasi kibɔ shakyi. ");
INSERT INTO cug_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wi shisi bəŋkuŋ bəmbum bəmbum i biŋgbɔkɔ bibɔ wə, ka yaksi a num kanti bəni bə kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wi saŋsi bəni bə dzɔŋ, bɔ fwuli bəh biɛiŋ bindzɔŋni, ayaka ka kɔŋŋ bəni bə kidəəŋ bəh kaŋ yiyəə. ");
INSERT INTO cug_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Wi gamti mi wi wi nɔm wə Islae, ka kwaka i chusi nshɛiŋ i Ablaham bəh chwɔŋkijuŋ ki, i tsə buku asi wi nì kaka i bətii tii bəbuku.” ");
INSERT INTO cug_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Si Meli dzaka yaka wi nɔ bəh Ɛlisabɛt i kifiəŋŋ kitali wə ka fiəni kwɛ i wa wibɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ayaka jɔbi dzə kpɛiŋ wə Ɛlisabɛt nì kɔ i bwɔ, wi bwɔ waiŋ nyukuni. ");
INSERT INTO cug_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chwɔŋkijuŋ ki bəh bəni bə̀ bɔ nì nɔki kɔmsiki i di biwɔ wə nì wɔkɔ a Bah chusi nshɛiŋ yi i wi, bɔ ka laŋki bəh wi. ");
INSERT INTO cug_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Si kaŋ nì dzə buku nyaŋ, bɔ dzə i suuŋ waiŋ, ka nəŋki i du yɛli wi i yɛli wi ba wi wə a Sakalia, ");
INSERT INTO cug_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ayakalə nih wi nəiŋ chiksi, dzaka a bə bɔ̂ɔŋ wi a Jɔn. ");
INSERT INTO cug_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ayaka bɔ dzaka i wi a, “Mi widɔkɔ mɔŋ i chwɔŋkijuŋ kimbɛiŋ wə bəh yɛli wələ.” ");
INSERT INTO cug_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ayaka bɔ ka fəkəliki kinchəsi ki gia bəh kaŋ i kiə i tii waiŋ, a wi nəŋki a bə du yɛli wi waiŋ a ndə a. ");
INSERT INTO cug_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wi tə ka fəkəli tsə a bɔ dzə bəh naka ki nyakani, bɔ dzə bəh ki wi ka nyaka yɛiŋ a “Yɛli wi kɔ Jɔn.” Bɔ yɛiŋ yaka dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Akisəkə, dzaka ki Sakalia ka yasi, lɔm wi yaŋsi, wi ka chu yisi ndzaka. Wi yisi i tumki bikum bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ayaka bəni bə̀ bɔ nì nɔki i kwili wiwɔ wə num bəh ŋkaŋyi. Gia yiwɔ yichi waŋ tsə i tumi ki ŋkwuŋ wi Judea wə kichi. ");
INSERT INTO cug_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Bəni bəchi bə̀ bɔ nì wɔkɔ gia yiwɔ yichi num bəh ŋkaŋyi ka bikəki a wələ waiŋ bi num winaiŋ na, kɔm yi nì chusiki a kimbɔiŋsi ki Nyɔ kɔlə i wi wə. ");
INSERT INTO cug_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ayaka Kiŋ'waka ki Baiŋni dza jikə i Sakalia wə tii Jɔn, wi yisi i dzakaki aka mi wi ntum wi Nyɔ, dzakayi a, ");
INSERT INTO cug_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Bukumbɛiŋ kɔ̂ksi Bah wə wi kɔ Nyɔ wi bəni bə Islae. Wi nì dzə i yɛlih bəni bu. ");
INSERT INTO cug_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Wi jiə mi wi, wi ləkəli wə wi ni bwili buku, num wi buku i chwɔŋkijuŋ ki mi wi, wi nɔm Ŋkuŋ Dɛbit. ");
INSERT INTO cug_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yələ gia kɔ asi wi nì kaka i dzaka ki bəni bu bə ntum bə̀ bɔ baiŋki, bə̀ wi nì jiə a kɛiŋ i kikpu wə, ");
INSERT INTO cug_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a wi bi bwili buku i kaŋ yi bəni bə̀ bɔ baiŋŋki buku, bəh bəni bə̀ bɔ kɔŋki kə buku. ");
INSERT INTO cug_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Wi nì kaka a wi bi kwasi lə nshɛiŋ i bətii tii bəbuku, ka baaŋ a kwakaki ŋkaiŋ biə wi Nyɔ nì dzi. ");
INSERT INTO cug_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wi nì təfi kichumi i tii bətii bəbukumbɛiŋ wə Ablaham, ka kaiŋ a, ");
INSERT INTO cug_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wi bi bwili lə buku i kaŋ yi bəni bə̀ bɔ baiŋŋki buku, ka buku bi nɔmki i wi, chu lwa kə, ");
INSERT INTO cug_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nɔ nɔni ki baiŋni bəh ki chəŋ i wi nshiŋ, i kaŋ yichi wə, i nɔni kibukumbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ayaka wɔ waiŋ wuŋ, bə bi bɔɔŋki wɔ a mi ntum wi Nyɔ, Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə, kɔm wɔ bi tsəki i Bah nshiŋ i kɛiŋsi dzəh yi. ");
INSERT INTO cug_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Wɔ bi fuku i bəni bu dzəh yə bɔ kɔ i kwatiki mbɔiŋ yɛiŋ, num ndalinya wə Nyɔ bi dalinyaki chu bibɔ, ");
INSERT INTO cug_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","kɔm bə nshɛiŋ yimbum yə Nyɔ wibukumbɛiŋ kaŋaki i bəni wə. Wi bi chiŋsiki Mbwili wi, ma wi bi shiki dzəki i bɛiŋ aka wɔŋ wə wi kaka. ");
INSERT INTO cug_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wi bi nya baiŋni i bəni bə̀ bɔ kɔ i jisi wə, bəh bə̀ bɔ kɔ a dzaka ki kpi wə, wi jiə bukumbɛiŋ i dzəh yi kimbɔiŋni wə.” ");
INSERT INTO cug_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ayaka waiŋ Sakalia wiwɔ ka kɔki i nyam yi gwu wə, kɔ tə i kiŋ'waka wə. Wi dza tsə ka nɔki i chwa, i tsə buku jɔbi wə wi nì buku i chusi gwu yi i bəni bə Islae. ");
INSERT INTO cug_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","A nì kɔ i jɔbi wiwɔ, ndzaka buku a bə fâ bəni bəchi i kitumi ki mbi wi Lum wə. Ndzaka wələ nì tsəsi Kaysa Augustus wə wi nì kɔ ŋkuŋ wimbum fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Mfa wələ nì kɔ wi ninshiŋ i jɔbi wə Kpwilinus nì kɔ mi wi sakani wi saka i Silia i kimbu ki mbi wi Lum wə. ");
INSERT INTO cug_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ayakadəiŋ, bəni bəchi ka fiəniki i jum wə i di bibɔ wə, i nyaka kiyɛli kibɔ, ka bə fa bɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ayaka Yɔsɛf tə nyə i kwili wi Nasali wə i Galili, bɔ yaka tsə i Bɛtelɛhɛm i kimbu ki tumi ki Judea wə i kwili wə bə nì bwɔ Ŋkuŋ Dɛbit. Wi nì tsə fɛiŋ kɔm wi nì kɔ mi i chwɔŋkijuŋ ki Ŋkuŋ Dɛbit wə. ");
INSERT INTO cug_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yɔsɛf nì nyə tsə i nyaka yɛli bəh Meli wə wi nì laaki wi a a bi numki kpə wi, ayaka wi num bəh tɔɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Si bɔ nì tsə buku fɛiŋ, jɔbi wi wi bwɔni dzə kpɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ayaka wi bwɔ waiŋ wi, wi ninshiŋ a num waiŋ nyukuni, kii wi i mbuŋ wə, jiə i gbɔkɔ wi nyam mə, kɔm di nì kɔkə i bɔ i juŋ yi bəni bə dzəni wə. ");
INSERT INTO cug_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A nì kɔ i jɔbi wiwɔ wə, bətɔkni shwáŋ bədɔkɔ num kɔmsi i kwili wiwɔ wə, tɔkni bəh shwáŋ yibɔ nchɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chinda wi Bah chiŋ tumbuku alə i bɔ nshiŋ, baiŋni bi Nyɔ baiŋ i bɔ wə, ndzaŋ kwa bɔ nalə. ");
INSERT INTO cug_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ayakalə, chinda wiwɔ dzaka i bɔ a, “Kiə mbɛiŋ ki lwâ kə. Mbɛiŋ wɔ̂kɔ, mih dzə num bəh ntum wi ndzɔŋni i mbɛiŋ, ayaka wi ni nya lə ndzɔŋni bimbum i bəni bəchi. ");
INSERT INTO cug_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","I chɔkɔ bidaiŋ wə bə bwɔ Kimbwili wimbɛiŋ i kwili wi Ŋkuŋ Dɛbit wə, wi num Klistus Bah. ");
INSERT INTO cug_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kələ ni numki kinchəsi i chusi waiŋ wiwɔ i mbɛiŋ. Mbɛiŋ ni tsə yɛiŋ lə wi num bə kii wi i mbuŋ wə ka jiə i gbɔkɔ wi nyam wə.” ");
INSERT INTO cug_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ayakadəiŋ, bɔ dza təkəli yɛiŋ chinda wiwɔ bəh mbaŋ wi bədɔkɔ bəduli, bɔ yaksi Nyɔ, dzakayi a, ");
INSERT INTO cug_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ma kiŋkɔkni nûm i Nyɔ wə wi kɔ bɛiŋ ayaka ma kimbɔiŋni nûm i fa kuku, i bəni kintəəŋ bə̀ Nyɔ kɔ bəh kinsaŋli kɔm bɔ.” ");
INSERT INTO cug_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jɔbi wə bəchinda bə Nyɔ bəwɔ nì bee bɔ ka fiəni yaka bɛiŋ, ayaka bətɔkni shwáŋ bəwɔ ka dzaka a bɔ bɔ a, “Bukumbɛiŋ tsə̂ i liə i Bɛtelɛhɛm, i tsə yɛiŋ gia yə yi num, yə Nyɔ fə a bukumbɛiŋ kiə.” ");
INSERT INTO cug_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A jɔbi wiwɔ kisəkə, bɔ ka kɔmsi nyə tsə yɛiŋ Yɔsɛf bəh Meli tasi bəh waiŋ wi nɔ i gbɔkɔ wi nyam mə. ");
INSERT INTO cug_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Si bɔ yɛiŋ wi, bɔ ka yisi i fukuki gia yichi yə chinda wi Nyɔ si fuku i bɔ kɔm waiŋ wələ. ");
INSERT INTO cug_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dzaka ka wɔm bəni bəchi bə̀ bɔ nì wɔkɔ gia yə bətɔkni shwáŋ bəwɔ nì fukuki i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ayakalə, Meli wɔkɔ yi yakadəiŋ ka jiə yi i kiŋkwaka wə, ka kwakaki jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bətɔkni shwáŋ bəwɔ fiəni yaksi Nyɔ tumyi bikum bi kɔm bɔ nì tsə yɛiŋ gia yichi a liŋ asi chinda wi Nyɔ nì fuku i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Si waiŋ wiwɔ nì buku kaŋ nyaŋ, bɔ ka suuŋ wi ka du yɛli wi a Jisɔs, ayaka yɛli wələ num a wə chinda wi Nyɔ nì fuku ka nih wi dzə num bəh tɔɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jɔbi wi fəni gia dzə kpɛiŋ i wɔkɔ shi bibɔ asi bənchi bə Muses nì nəŋki. Bɔ ka dzɔ waiŋ wiwɔ yaka tsə bəh wi i Jɛlusalɛm i nya i Bah. ");
INSERT INTO cug_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Yələ gia kɔ asi bə nì nyaka i Kiŋwakti ki Bənchi ki Bah wə a, “Mi ka bwɔ waiŋ wi ninshiŋ a num waiŋ nyukuni, yi num a wi nyâ wi, ma wi numki wi Bah.” ");
INSERT INTO cug_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Bɔ nì tsə i fə gia yələ bəh mbumi bifa yudɔkɔ bəh bwa bə minduŋɔ mifa, asi Kiŋwakti ki Bənchi bə Bah fukuki. ");
INSERT INTO cug_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A nì kɔ jɔbi wiwɔ wə, tikwili widɔkɔ num i Jɛlusalɛm bə bɔɔŋ a Semeɔn. Wi nì kɔ mi wi chəŋ wi nɔ asi Nyɔ nəŋki, ayaka wi nì wɔkɔliki mi wə wi bi dzə i bɔiŋsi shɔ́m yi bəni bə Islae. Num Kiŋ'waka ki Baiŋni jikə i gwu yi wə, ");
INSERT INTO cug_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ayaka ki nì fə wi kiə a kpi bi dzɔ kə ŋgaiŋ maka ŋgaiŋ yɛiŋ Kimbwili wi Bah wə wi nì kaka. ");
INSERT INTO cug_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ayaka Kiŋ'waka ki Baiŋni fə Semeɔn tsə i juŋ yi fəni yi gia wə. Si Yɔsɛf bəh Meli nì dzə bəh waiŋ wiwɔ i juŋ yi fəni yi gia wə i fə asi bənchi nəŋki, ");
INSERT INTO cug_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Semeɔn ka dzɔ waiŋ wiwɔ kumi ka yisi i chɔŋyiki Nyɔ dzakayi a, ");
INSERT INTO cug_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Bah, si wɔ fə kiŋkaka ka dzə kpɛiŋ, dzɔ̂ la mi wa wi nɔm i liə i kimbɔiŋni wə. ");
INSERT INTO cug_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Dzə́kəh yiŋ yɛiŋ lɔ Kimbwili wə, ");
INSERT INTO cug_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wɔ faaŋ a bəni bəchi bi yɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wi ni numki baiŋni i bəni bə̀ bɔ kɔkə bə Islae, ayakadəiŋ, ka bɔ tə bi kiə wɔ, fə ka bɔ dzasi yɛli wi bəni ba bə Islae i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ayaka tii waiŋ bəh nih waiŋ nì wɔkɔ gia yə Semeɔn dzakaki i waiŋ wələ bɛiŋ, dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Wi ka jiə Kimbɔiŋsi i bɔ wə, dzaka i Meli nih wi a, “Wɔ̂kɔli Nyɔ kɔ wi saiŋbwili lɔ waiŋ wələ, ndzə wi ni fə lə ka bəni bə Islae bəduli gbɔyi, ayakalə bədɔkɔ dzayi bɛiŋ. Wi kɔ kinchəsi ki gia ka bəni bi dzakaki gia kɔm wi. ");
INSERT INTO cug_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ayakadəiŋ, ka yələ bi chusiki gia yə bəni nyumiki i shɔ́m yibɔ wə. Gia yiwɔ yichi bi fə shɔ́m ya numki ka bə bwaŋ bəh fiŋkɔfi.” ");
INSERT INTO cug_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A nì kɔ jɔbi wiwɔ wə, kpaŋa widɔkɔ nì kɔlə bə bɔɔŋ wi a, Ana, a num mi wi ntum wi Nyɔ. Wi nì kɔ waiŋ Fanuwɛl wi num mi i chwɔŋkijuŋ ki Ashɛl wə. Kpaŋa wiwɔ nì kɔ wi jwiŋ lɔ nalə. Wi nì kɔ num wi fə bəh nyuwi jía nanitaŋ shəŋ, ayaka nyuwi ka kpi. ");
INSERT INTO cug_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Wi ka baaŋ mfih kpə ŋkwu, wi shi a i juŋ yi fəni yi gia wə kɔksi Nyɔ nchɔkɔ bəh nshi, wi bam dzaka, tsa. Jia yi nì kɔ mbaŋ nyaŋ ntsɔ yinaa (84). ");
INSERT INTO cug_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A jɔbi wiwɔ wə bɔ nì dzə bəh waiŋ i juŋ yi fəni gia wə, kpaŋa wə dzə yɛiŋ bɔ, ka nya kiyɔŋni i Nyɔ, dzaka kɔm waiŋ wələ i bəni bəchi bə̀ bɔ nì wɔkɔliki jɔbi wə Nyɔ bi təiŋ bəni bə Jɛlusalɛm i kaŋ yi ŋgəkə wə. ");
INSERT INTO cug_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jɔbi wə Yɔsɛf bəh Meli nì kaasi gia yichi yə bənchi bə Bah nì nəŋki, bɔ fiəni chu i kwili wibɔ wə i Nasali i kimbu ki tumi ki Galili wə. ");
INSERT INTO cug_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ayaka Waiŋ wiwɔ ka kɔɔki kaŋa ŋga, num wi jikə bəh mfi bimbum, ayaka kaŋ yi Nyɔ num i wi wə. ");
INSERT INTO cug_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Tii Jisɔs bəh nih wi nì fəki bɔ yaka tsə i Jɛlusalɛm jía yichi i Dzini bi Ntsədaŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jɔbi wə Jisɔs nì buku jía jwɔfi ntsɔ yifa, bɔ ka chu yaka tsə i Dzini biwɔ wə asi bɔ nì fəki bɔ yaka. ");
INSERT INTO cug_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Si bɔ nì dzi kaasi Dzini biwɔ, bɔ bə́ fiəni kwɛ, waiŋ wə Jisɔs ka baaŋ i jum wə i Jɛlusalɛm, ayakalə ba wi bəh nih wi kiə kə. ");
INSERT INTO cug_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Bɔ ni nyani chɔkɔ bichili, kwaka alə wi kɔ i mbaŋ wi bəni kintəəŋ bə̀ bəh bɔ nì nyaniki. Bɔ ka yisi i nəŋki wi i kintəəŋ ki chwɔŋkijuŋ kibɔ wə bəh nsɛ́iŋ, ");
INSERT INTO cug_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ka nəŋ mɔŋ, ka fiəni chu i Jɛlusalɛm i nəŋ wi fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kaŋ tsə yitali si bɔ nì yisi i nəŋki, bɔ yɛiŋ wi i juŋ yi fəni yi gia wə, wi num fɛiŋ bəh bəni bə lanini, wɔkɔli bənlani, bikə bəmbikə. ");
INSERT INTO cug_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Bəni bəchi bə̀ bɔ nì wɔkɔliki num bəh ŋkaŋyi nalə, wi kiə gia nalə chukuli bəmbikə chəŋ. ");
INSERT INTO cug_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Si nih wi bəh ba wi yɛiŋ wi, dzaka wɔm bɔ nalə. Nih wi ka bɔɔŋ wi dzaka a, “Waiŋ, wɔ njiŋsiki nə buku lə? Tsɛ̂iŋ, buku ba wa si nəŋ wɔ nalə ka bɔh.” ");
INSERT INTO cug_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wi chukuli a, “Mbɛiŋ si nəŋki mih kɔm nə? Mbɛiŋ si kiəki kə a mih kaŋaki i numki i juŋ yi Ba wuŋ wə fa?” ");
INSERT INTO cug_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ayakalə, bɔ nəki wɔkɔ kiə kə gia yə wi dzakaki. ");
INSERT INTO cug_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wi ka nyə bəh bɔ shi tsə i Nasali. Wi tsə ka wɔkɔki i bɔ na bindzɔŋ. Si gia yiwɔ nì num yakadəiŋ, nih wi jiə yi i kiŋkwaka wə ka bə́ kwakaki yi jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisɔs ka kɔki, kaŋa mfi bimbum bəh ŋga, Nyɔ kɔŋ wi, bəni tə kɔŋ wi. ");
INSERT INTO cug_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","A nì kɔ jɔbi wə Jɔn wə waiŋ Sakalia nì kɔ i chwa, ntum wi Nyɔ dzə i wi. I jía yiwɔ wə Tibɛliu nì sakaki ka Ŋkuŋ wimbum i Lum i jía jwɔfi ntsɔ yite. I jɔbi wiwɔ wə Bɔntiu Baylɛ bɔŋ sakaki bimbu bi tumi ki Judea, Hɛlɔd tə saka Galili. Filib wə waiŋnih Hɛlɔd nì sakaki bimbu ki Itulea bəh ki Tɛlakɔniti, Lisania saka Abilən. A nì kɔ tə i jɔbi wiwɔ wə Anas bəh Kayfas num kifwu ki bətii mfə gia. ");
INSERT INTO cug_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Si Jɔn wɔkɔ ntum wi Nyɔ wiwɔ, ka nyə tsə i bimbu bi tumi bichi biə bi kɔmsiki i Bɔkɔ yi Jɔdan wə, ka fukuki i bəni a bɔ kwûni shɔ́m yibɔ, ma ŋgaiŋ juli bɔ i bɔkɔ ka Nyɔ bi dalinya chu bibɔ. ");
INSERT INTO cug_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gia yələ kɔ asi Isaya mi wi ntum wi Nyɔ nì nyaka i Kiŋwakti ki wə a, “Ja yi mi wiliki i chwa a, bə kɛ̂iŋsi dzəh yi Bah, bə lûmsi yi a yi nûm chəŋ, ");
INSERT INTO cug_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","bə bi mukuyiki lə ŋkwúŋ yimbum bəh ŋgáŋni yichi ma bə bi jiksi kaŋŋ yichi, ka yi bi num jiəli yichi, bə i nani dzə́h yi ŋkwuyini ka yi num chəŋ, bə i jiksi káŋŋ yichi ka dzə́h bi num lə lwɛɛɛs, ");
INSERT INTO cug_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ka bəni bəchi bi yɛiŋ si Nyɔ bwili bəni.” ");
INSERT INTO cug_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Si Jɔn nì fukuki i bɔ yakadəiŋ, mbaŋ wi bəni ka dzə a wi juli bɔ i bɔkɔ. Wi dzaka i bɔ a, “Chwɔŋkijuŋ ki fə́kəh, a təfi ndə mbɛiŋ a mbɛiŋ yɔ̂kɔ gɛ̂iŋ shɔm yi Nyɔ yi bɔkɔsini yə wi bi bɔkɔsi i mbɛiŋ, ka mbɛiŋ dzəki lə a? ");
INSERT INTO cug_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mbɛiŋ fə̂ki gia yə yi chusiki a mbɛiŋ kwuni shɔ́m yimbɛiŋ. Kiə mbɛiŋ ma dzâkaki i gwu yimbɛiŋ wə a, Ablaham kɔ tii wimbɛiŋ. Mih fukuki i mbɛiŋ a, Nyɔ kɔlə i fiəni kitəh kələ ki fiəni chu bwa bə Ablaham. ");
INSERT INTO cug_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mbɛiŋ kîəki a, bə kɔ bə jiə lɔ fɔkɔ i chwɔŋ bi kɛiŋ wə. Kɛiŋ yichi yə yi wumki kə mintam mi ndzɔŋni, bə bi gba shisi lə yi i kuku, bə kpa i gbuku wə.” ");
INSERT INTO cug_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Si mbaŋ wi bəni wɔkɔ gia yiwɔ yaka, ka bikə i Jɔn a, “Buku kɔ fə̂ na dəiŋ i liə a?” ");
INSERT INTO cug_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Wi chukuli a, “Mi wə wi kaŋaki bəmbuŋ bəfa wi nyâ wimu i mi wə wi kaŋaki kə, ma wə wi kaŋaki biɛiŋ bidzini wi gâa bəh mi wə wi kaŋaki kə.” ");
INSERT INTO cug_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Bəni bə kwani kiŋwakti bədɔkɔ dzə i wi a wi juli bɔ i bɔkɔ mə, ka bikə i wi a, “Mi wi lanini, buku kɔ i fə̂ na dəiŋ?” ");
INSERT INTO cug_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Wi chukuli bɔ a, “Kiə mbɛiŋ ki dzɔ̂ kə kpɔ wi kwani kiŋwakti wi du tsə si bənchi nəŋki.” ");
INSERT INTO cug_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Bəni bə jum bədɔkɔ bɔŋ dzə bikə i wi a, “Buku kɔ i fə̂ na dəiŋ?” Wi chukuli a, “Mbɛiŋ tɔ̂kniki i lɔ̂kɔki kpɔ i bəni bəh ŋga, bəh i jîəki gia i bəni fuŋ kilɔlɔ. Mbɛiŋ nûmki bəh kinsaŋli i fiɛŋ fiə bə gɔmki mbɛiŋ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Si bəni nì wɔkɔli Kimbwili wə Nyɔ nì kaka, bɔ ka yisi i kwakaki i shɔ́m yibɔ wə a, jɔbi widɔkɔ Jɔn kɔ Kimbwili wiwɔ si Nyɔ faaŋ. ");
INSERT INTO cug_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jɔn chukuli bɔ a, “Mih kɔ a, juliki mbɛiŋ i bɔkɔ mə, ayakalə mi wə wi gumiki tsəki mih, kɛiŋki wi dzə i jum wə, mih kpɛiŋniki kə i ŋgwuŋ shi i shwa dzu yi yigvu. Akɔ wi wə wi bi juliki mbɛiŋ i Kiŋ'waka ki Baiŋni wə bəh i gbuku wə. ");
INSERT INTO cug_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Wi kaŋa naka i kaŋ i gbəkəki gəŋ yɛiŋ, i juŋni jiə i kiba wə, i kɔh chi yiwɔ i kpa i gbuku wə wi bi nyumi kə.” ");
INSERT INTO cug_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Akɔ lə si Jɔn nì fukuki ntum wi ndzɔŋni wi Nyɔ i bəni, chu nya bɔ bəh nlani i dzə́h yiduli wə. ");
INSERT INTO cug_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ayakalə, wi dzaka i Hɛlɔd mi wi sakani kɔm nɔni ki, tɔyi chwɔŋ ki, kɔm Hɛlɔd nì kɔ wi fiəni dzɔ Hɛlɔdia kpə waiŋnih wi i kpə wi, ka chu dzaka kɔm gia yichu yiduli yə Hɛlɔd nì kɔ wi fə. ");
INSERT INTO cug_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hɛlɔd ka chu bəkəli gia yiwɔ, ka dzaka a bə kwâ fâh Jɔn i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jɔbi wə Jɔn nì juli kaasi bəni i bɔkɔ, Jisɔs ka bɔŋ dzə tə a wi jûli ŋgaiŋ i bɔkɔ mə. Si wi juli wi i bɔkɔ mə yaka, wi ka tsaki, bɔɔli wɛli, ");
INSERT INTO cug_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kiŋ'waka ki Baiŋni shi dzə num i wi wə ka kimbwɔsi kimbumi, ja buku i bɛiŋ a, “Wɔ kɔ waiŋ wuŋ wi shɔm, mih kɔ bəh kinsaŋli nalə kɔm wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jɔbi wə Jisɔs nì buku ka jía mbaŋtia, wi ka yisi nɔm wi. Bəni nì kwakaki a wi kɔ waiŋ Yɔsɛf, Yɔsɛf wiwɔ num waiŋ Ɛli. ");
INSERT INTO cug_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ɛli nì kɔ waiŋ Matat, Matat num waiŋ Lɛwi, Lɛwi num waiŋ Mɛlki, Mɛlki num waiŋ Janay, Janay num waiŋ Yɔsɛf. ");
INSERT INTO cug_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yɔsɛf wələ nì kɔ waiŋ Matatia, Matatia num waiŋ Ɛmɔs, Ɛmɔs num waiŋ Naum, Naum num waiŋ Ɛsli, Ɛsli num waiŋ Nagay. ");
INSERT INTO cug_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay nì kɔ waiŋ Mat, Mat num waiŋ Matatia, Matatia num waiŋ Semein, Semein num waiŋ Yɔsek, Yɔsek num waiŋ Jɔda. ");
INSERT INTO cug_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jɔda nì kɔ waiŋ Jɔanan, Jɔanan num waiŋ Lesa, Lesa num waiŋ Sɛlubabɛl, Sɛlubabɛl num waiŋ Shiltia, Shiltia num waiŋ Nɛli. ");
INSERT INTO cug_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nɛli nì kɔ waiŋ Mɛlki, Mɛlki num waiŋ Adi, Adi num waiŋ Kɔsam, Kɔsam num waiŋ Ɛlmadam, Ɛlmadam num waiŋ Ɛl. ");
INSERT INTO cug_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ɛl nì kɔ waiŋ Yɔshwa, Yɔshwa num waiŋ Ɛliesa, Ɛliesa num waiŋ Yɔlem, Yɔlem num waiŋ Matat, Matat num waiŋ Lɛwi. ");
INSERT INTO cug_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lɛwi nì kɔ waiŋ Semeɔn, Semeɔn num waiŋ Juda, Juda num waiŋ Yɔsɛf, Yɔsɛf num waiŋ Yɔnam, Yɔnam num waiŋ Ɛliakim. ");
INSERT INTO cug_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ɛliakim nì kɔ waiŋ Melia, Melia num waiŋ Mena, Mena num waiŋ Matata, Matata num waiŋ Natan, Natan num waiŋ Dɛbit. ");
INSERT INTO cug_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dɛbit nì kɔ waiŋ Jɛse, Jɛse num waiŋ Ɔbɛt, Ɔbɛt num waiŋ Bɔas, Bɔas num waiŋ Sala, Sala num waiŋ Nashɔn. ");
INSERT INTO cug_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashɔn nì kɔ waiŋ Aminada, Aminada num waiŋ Admin, Admin num waiŋ Alni, Alni num waiŋ Ɛslɔn, Ɛslɔn num waiŋ Bɛlɛs, Bɛlɛs num waiŋ Juda. ");
INSERT INTO cug_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judas nì kɔ waiŋ Yakɔb, Yakɔb num waiŋ Ayjik, Ayjik num waiŋ Ablaham, Ablaham num waiŋ Tɛla, Tɛla num waiŋ Naɔl. ");
INSERT INTO cug_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naɔl nì kɔ waiŋ Sɛlug, Sɛlug num waiŋ Leu, Leu num waiŋ Bɛlɛg, Bɛlɛg num waiŋ Ɛbɛ, Ɛbɛ num waiŋ Shɛla. ");
INSERT INTO cug_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shɛla nì kɔ waiŋ Kaynan, Kaynan num waiŋ Alfasad, Alfasad num waiŋ Shɛm, Shɛm num waiŋ Nɔa, Nɔa num waiŋ Lamek. ");
INSERT INTO cug_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek nì kɔ waiŋ Metusɛla, Metusɛla num waiŋ Ɛnɔk, Ɛnɔk num waiŋ Jalɛd, Jalɛd num waiŋ Malalɛl, Malalɛl num waiŋ Kaynan. ");
INSERT INTO cug_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynan wələ nì kɔ waiŋ Ɛnɔsh, Ɛnɔsh num waiŋ Sɛt, Sɛt num waiŋ Adam, ayaka Adam num waiŋ Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisɔs nì fiəni i Bɔkɔ yi Jɔdan wə, num wi jikə bəh Kiŋ'waka ki Baiŋni. Ki dzɔ wi, wi nyə tsə i nɔki chwa. ");
INSERT INTO cug_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wi nì kɔ fɛiŋ i kaŋ wə mbaŋnyani ŋkpɛli mɔmsi wi, wi dzi kə fiɛŋ. Asi yəmaka nì tsə i kiŋgɔksi wə dzɔŋ bə́ wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ŋkpɛli ka dzaka i wi a, “Wɔ kabə num waiŋ Nyɔ, dzâka la a təh wələ fîəni chû dzɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisɔs chukuli i wi a, “Yi kɔ num bə nyaka a, ‘Mi nɔki kə a kɔm bə dzɛiŋ shəŋ.’” ");
INSERT INTO cug_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ŋkpɛli chu dzɔ Jisɔs fɛiŋ yaka tsə bəh wi i di bidɔkɔ wə, chusi bəntɔŋ bəchi i bitumi bichi wə i fa kuku i wi. Jisɔs ka yɛiŋ lə wɛɛɛs. ");
INSERT INTO cug_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ayaka wi ka dzaka i wi a, “Bə nì nya lɔ bəntɔŋ bə mbi wələ i mih bəchi, a na ndə wə mih kɔŋki mih nya i wi. Mih ni nya lə ki i wɔ ma wɔ sakaki, kaŋa mbum bəh ŋga biwɔ bichi. ");
INSERT INTO cug_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Yi kɔ a wɔ kɔ̂ksi mih, ka mih ni nya biɛiŋ bichi i wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisɔs chukuli i wi a, “Yi kɔ num bə nyaka a, ‘Wɔ kɔ̂ksiki Bah Nyɔ wa, ma wɔ nɔ̂mki a wi shəŋ.’” ");
INSERT INTO cug_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ŋkpɛli ka dzɔ tsə bəh wi i kwili wi Jɛlusalɛm wə, ka tɔm wi i fwu wi juŋ yi fəni yi gia wə, dzaka i wi a, “Wɔ kabə num Waiŋ Nyɔ, jə̂ŋ shî la fa, ");
INSERT INTO cug_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","kɔm yi kɔ bə nyaka a, ‘Nyɔ ni dzaka i bəchinda bu a bɔ tɔkni bəh wɔ.’ ");
INSERT INTO cug_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ayaka yi chu num bə nyaka a, ‘Bɔ ni kwa wɔ maka wɔ chɔkɔ gbu wa i təh wə.’” ");
INSERT INTO cug_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisɔs chukuli i wi a, “Kiŋwakti ki Nyɔ dzakaki tə a, ‘Ma mɔ̂msi Bah Nyɔ wa.’” ");
INSERT INTO cug_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jɔbi wə ŋkpɛli nì mɔmsi kaasi Jisɔs i dzə́h yichi yə wi nì nəŋki, wi nyə ka wɔkɔliki jɔbi widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jisɔs ka nyə fiəni chu i Galili, num wi jikə bəh ŋga bi Kiŋ'waka ki Baiŋni. Ntum kɔm wi waŋ tsə i bimbu bi tumi bichi wə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wi nì laniki bəni i júŋ yi tsani wə, bəni bəchi kɔksi wi. ");
INSERT INTO cug_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisɔs ka nyə dzə i Nasali i kwili wə wi nì kɔ yaka yɛiŋ. Ayaka a bi dzə num chɔkɔ bibɔ bimbam, wi nyə tsə i juŋ yi tsani wə, asi wi si fə. Wi dza num i bɛiŋ i fa Kiŋwakti ki Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Bɔ ka nya wi bəh kiŋwakti ki Isaya mi ntum wi Nyɔ nì nyaka. Wi shwa tsɛiŋ di biə bə nì nyaka a, ");
INSERT INTO cug_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Kiŋ'waka ki Bah Nyɔ kɔ i gwu yiŋ wə, kɔm wi kɔ wi babwili mih, a mih dzə̂ lâka ntum wi ndzɔŋni i bəni bə kifuu. Wi faaŋ mih a mih dzə̂, lâka i bəni bə̀ bɔ kɔ i juŋ yi nsəŋ mə, a bə bi bwiliki lə bɔ, ma mih bi fiəni dzə́kəh yi bimfəkə ma yi bi wɛli gwu. Wi faaŋ tə mih a mih dzə̂, bwîli bəni bu bə̀ bə chəbsiki bɔ i nsəŋ wə, ");
INSERT INTO cug_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","i chu laka tə a jia dzə kpɛiŋ yə Bah ni kwasi nshɛiŋ i bwili bəni bu, ma bɔ bi kɔksiki wi.” ");
INSERT INTO cug_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Si Jisɔs fa kaasi, fiəni kii kiŋwakti kiwɔ nya i mi wə wi nì jiəki bi, ka num i kuku. Bəni bəchi bə̀ bɔ nì kɔ fɛiŋ i juŋ yi tsani yiwɔ wə lumsi dzə́kəh i gwu yi wə. ");
INSERT INTO cug_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wi yisi i dzakaki i bɔ a, “Gia yə mbɛiŋ wɔkɔ i Kiŋwakti ki Nyɔ kələ wə yi dzə kpɛiŋ ŋkɔŋ daiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Bəni wɔkɔli yi lə, yi ndzɔŋ i bɔ nalə, bɔ num bəh ŋkaŋyi ka dzakaki kɔm bə ndzaka wi ndzɔŋni wə wi bukuki i dzaka ki wə. Ayakalə, ka yisi i məŋki, bikəyi a, “Wələ kɔ a waiŋ Yɔsɛf wə a?” ");
INSERT INTO cug_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisɔs ka dzaka i bɔ a, “Asi kɔkə gia yi məŋnini a mbɛiŋ ni ti lə ndi kɔm mih a, ‘Mi wə wi chukuki bəni, chûku gwu ya.’ Mbɛiŋ ni dzaka a, ‘Gia yə buku ni wɔkɔ a wɔ ni fə i Kafanaum, fə̂ tə yi fa i wa wa.’” ");
INSERT INTO cug_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jisɔs chu dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, bə mɔŋ dəkə i kɔksi mi wi ntum wi Nyɔ i tumi ki wə. ");
INSERT INTO cug_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","I yi ŋkɔŋ wə, mih fukuki i mbɛiŋ a, a nì kɔ i jɔbi wi mi wi ntum wi Nyɔ wə Ɛlaja, dzaŋ nì num baaŋ i bɛiŋ i jía wə yitali bəh kifiəŋŋ kisɔɔ, ayaka dzɔŋ kwa tumi kichi. I jɔbi wiwɔ bəkaŋa bəŋkwu bəduli num fɛiŋ i tumi ki Islae wə. ");
INSERT INTO cug_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nyɔ nì ka faaŋ dəkə Ɛlaja i mi widɔkɔ fɛiŋ i bɔ, wi nì faaŋ lɔ wi a num i kpə ŋkwu wi Dzalafat, i tumi ki Sidɔn wə. ");
INSERT INTO cug_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","A nì kɔ i jɔbi wi mi wi ntum wi Nyɔ Ɛlisha, bəni bə Islae bəduli kaŋa jwɛiŋ yi kumyini yiduli, mi widɔkɔ i bɔ wə nì ka bɔiŋ. A kɔbi shəŋ a Naman wi mbɔŋ wə mi wi Silia, bə nì chuku wi, wi baiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Si Jisɔs dzaka yakadəiŋ, bəni bəchi bə̀ bɔ nì kɔ i juŋ yi tsani wə, wɔkɔ yaka, bɔ bɔksi tɔɔ na bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Bɔ dza bɛiŋ ka chini wi, buku bəh wi i kwili kintəəŋ, ka tsə buku i dzaka ki kaŋŋ wə i di biə bə nì maa gɔksi kwili wiwɔ bə nɔ fɛiŋ, ka bə́ nəŋ i chini shi wi a wi gbɔ bəh fwu. ");
INSERT INTO cug_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ayakalə, wi tsə tɔli i bɔ kintəəŋ ka tsəki mfih. ");
INSERT INTO cug_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisɔs ka nyə shi tsə i Kafanaum, i kwili widɔkɔ wə i Galili. A num i chɔkɔ bimbam wə, wi tsə ka laniki bəni i juŋ yi tsani mə. ");
INSERT INTO cug_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Bəni bəwɔ bəchi wɔkɔ, num bəh ŋkaŋyi i nlani wiwɔ wə, kɔm nlani wiwɔ nì kaŋaki lə ŋga. ");
INSERT INTO cug_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Mi widɔkɔ num i juŋ yi tsani yiwɔ mə, kiŋ'waka kichu num i gwu yi wə. Wi ka wiliki ja yaka bɛiŋ a, ");
INSERT INTO cug_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yəbɛɛy Jisɔs wi Nasali, wɔ nəŋki nə i buku wə a? Wɔ dzə lɔ i bəkəli buku a? Mih kiəki lə mi wə wɔ kɔ wi. Akɔ wɔ wə wɔ baiŋki, a num wɔ wə wɔ nyə i Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisɔs kaŋyi kiŋ'waka kichu kiwɔ, dzaka a, “Kpîchumi mɔŋ, bûku i mi wələ mə.” Ayaka ki ka giŋ tɔkɔ wi i kuku i bəni kintəəŋ, ka buku i gwu yi mə, ayakalə ki nəki bɛiŋsi kə wi. ");
INSERT INTO cug_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Bəni bəchi yɛiŋ yakadəiŋ, dzaka wɔm bɔ. Bɔ ka məŋki, bikəyi a, “Wələ ndzaka kɔ winaiŋ lə mi wələ kaŋaki a? Wi kaŋaki ŋga biə bi kɔ bimbum i kaŋyi biŋ'waka bichu bi buku i gwu yi bəni wə.” ");
INSERT INTO cug_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ntum wiwɔ kɔm Jisɔs waŋ tsə i bidi bichi wə i kimbu kə wə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisɔs dza buku i juŋ yi tsani yiwɔ mə, ka tsə liə i Samɔn dzu. A nì kɔ nih kpə Samɔn gwɛiŋ bəh gwu yi yakani yiləkəli. Bɔ tsa a Jisɔs gâmti wi. ");
INSERT INTO cug_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Wi ka tsə i di biə wi ni nɔki, num i wi bɛiŋ, kaŋyi jwɛiŋ yiləkəli yiwɔ. Yi ka bee wi, wi bɔnih. Akisəkə, kpaŋa wiwɔ ka dza bɛiŋ, tsɛiŋ fiɛŋ fidzini nya bɔ dzi. ");
INSERT INTO cug_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Si jɔbi nì shiki tsəki, bəni bəchi bə̀ bɔ nì kaŋaki bəni bə̀ bɔ gwɛiŋki bəh jwɛiŋ chi chi, ka dzɔki dzəki bəh bɔ i Jisɔs. Wi ka kɔmyiki bɔ bəchi bɔ bɔnih. ");
INSERT INTO cug_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Bəchinda bə Satan ka bukuyiki tə i gwu yi bəni bəduli bədɔkɔ wə, wili a, “Wɔ kɔ waiŋ Nyɔ.” Ayakalə, Jisɔs kaŋyi a bɔ ma dzâkaki, kɔm bɔ ni kiə Jisɔs a akɔ Kimbwili wə Nyɔ nì kaka. ");
INSERT INTO cug_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Si chɔkɔ ni buku wɔɔ, Jisɔs buku tsə i kwili widɔkɔ wə wi mbɔŋ. Bəni ni baŋ yisi i nəŋki wi. Jɔbi wə bɔ ni yɛiŋ wi, wi ni nəŋki lə i nyə i kwili wiwɔ wə. Bɔ ka mɔmsiki dzəh a wi baaŋ bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ayakalə, wi nəiŋ ka dzaka i bɔ a, “Mih kaŋaki i fuku ntum wi ndzɔŋni kɔm ŋkuŋ bi Nyɔ i kwili widɔkɔ wə tə, kɔm akɔ gia yə Nyɔ faaŋ mih a mih dzə̂ fə̂.” ");
INSERT INTO cug_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wi ka dza tsə ka nyaniki fukuki ntum wi ndzɔŋni wiwɔ i juŋ yi tsani wə i tumi kiwɔ wə kichi. ");
INSERT INTO cug_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A nì kɔ chɔkɔ bidɔkɔ, Jisɔs num kɔmsi i bɔkɔ yi Genesalet wə, num bəni fiəli baŋ wi faaŋni, ka wɔkɔliki gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wi dza yɛiŋ bəŋgwuki bəfa i bɔkɔ kpəŋ, num bəni bə̀ bɔ nì kaŋaki bəŋgwuki bəwɔ, buku ka bə́ wɔkɔki gi yibɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ayaka wi tsə liə i ŋgwuki widɔkɔ wə, a num wi Samɔn, wi dzaka i wi a, wi chîni lîə tsə̂ bəh wi i bɔkɔ twɛsi. Ayaka wi chini, Jisɔs ka num yɛiŋ ka laniki bəni bə̀ bɔ nì kɔ i kpa. ");
INSERT INTO cug_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Si wi nì lani kaasi, ka dzaka i Samɔn a, “Nâa lîə tsə̂ i limi bɛiŋ ma mbɛiŋ tûm gi yimbɛiŋ, ma mbɛiŋ ni kwa bwɔ́kɔ.” ");
INSERT INTO cug_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Samɔn chukuli a, “Tikwili, buku si nɔ a bɛiŋ i tumki gi chɔkɔ wɔɔ, ayakalə buku nəki kwa kə fiɛŋ fidɔkɔ. Si wɔ dzaka yaka, mih ki tumki lə.” ");
INSERT INTO cug_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bɔ tsə tum, ka kwa bwɔ́kɔ yiduli, yi shi lə shiiim, jɔbi wə bɔ nì nəŋki i bwili gi yibɔ yi ka nəŋki i təiŋyi. ");
INSERT INTO cug_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ayakadəiŋ, bɔ lasi bəni bəbɔ bə mbaŋ bəŋgwuki bədɔkɔ, a bɔ dzə̂ gâmti bɔ. Bɔ ka dzə bwili bwɔ́kɔ yiwɔ yi jikə i bəŋgwuki bəbɔ wə, bɔ ka nəŋki i mini i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jɔbi wə Samɔn Bita yɛiŋ gia yiwɔ yaka, ka tsə tum binyu i Jisɔs nshiŋ dzaka a, “Mih tsaki wɔ Bah, dzâ nyə̂ mfia fa i mih kpɛiŋ, kɔm mih kɔ mi wichu.” ");
INSERT INTO cug_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wi nì dzaka yakadəiŋ, kɔm wi bəh bəni bu bə mbaŋ nì yɛiŋ bwɔ́kɔ yə bɔ nì kwa, dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ayaka ki wɔm tə Jɛm bəh Jɔn bwa bə Sɛbide bɔ nì kɔ i mbaŋ wi Samɔn wə. Jisɔs dzaka i Samɔn a, “Ma lwâki. I yisi i liə i tsə, wɔ ni kwâki num lɔ bəni.” ");
INSERT INTO cug_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Si bɔ wɔkɔ yakadəiŋ, ka bwili bəŋgwuki bəbɔ i kpa, bee biɛiŋ bichi ka biəliki wi. ");
INSERT INTO cug_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","A dzə num i jɔbi widɔkɔ wə, Jisɔs num i kwili widɔkɔ wə, mi widɔkɔ num fɛiŋ num jwɛiŋ yi kumyini dzi kaasi wi. Asi mi wiwɔ yɛiŋ Jisɔs, ka dzə gbɔ i wi nshiŋ, tsa wi, “Bah, wɔ kabə kɔŋki wɔ fə̂ mih baiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisɔs nani tsɛiŋ yi ka kɔm wi, dzaka a, “Mih kɔŋki lə, bɔ̂nih ma wɔ bâiŋki.” Akisəkə, jwɛiŋ yi kumyini yiwɔ kaa. ");
INSERT INTO cug_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisɔs ka kiŋ i wi a, “Tɔ̂kni ma fûku i mi widɔkɔ. Ayakalə, tsə̂ chûsi gwu ya i tii mfə gia, ma wɔ ka nyâ kinya kə Muses nì dzaka a mi kaŋaki i nyâ i chusi i bəni a, ŋgaiŋ bɔnih i jwɛiŋ yələ wə ka baiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jisɔs nì kiŋ i mi wiwɔ yaka, gia yiwɔ kɔm Jisɔs ka chu waŋ tsə lɔ, mbaŋ wi bəni bəduli ka juŋniki dzəki i wɔkɔki nlani wi, bə a wi chukuki jwɛiŋ yibɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ayakalə, Jisɔs si dza bee bɔ wi tsə i chwa i tsaki. ");
INSERT INTO cug_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A num chɔkɔ bidɔkɔ Jisɔs lani bəni, ŋga bi Nyɔ num i gwu yi wə i chuku jwɛ́iŋ yɛiŋ. Bəfalasi bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ num fɛiŋ, num bɔ nì buku i bidi bichi wə i Galili bəh i bimbu bi Judea wə bəh bi Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yi dzə num a bəni bədɔkɔ nì kɔ bɔ buŋ mi i kimbuŋ wə ka dzəki, num wi kpi wa wimu. Bɔ nì nəŋki a bɔ dzə liə bəh wi i dzu i nɔsi i Jisɔs nshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ayakalə, bɔ nəki kaŋa kə dzəh, kɔm bəni ni faaŋniki lə nalə. Bɔ ka yaka num i fwu wi juŋ bɛiŋ, tɔ kiyəə, shisi shi mi wiwɔ i bəni kintəəŋ i Jisɔs nshiŋ i wɔkɔ gia yə wi ki dzakaki. ");
INSERT INTO cug_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Si Jisɔs nì yɛiŋ a bəni bəwɔ jiə shɔ́m yibɔ i wi wə, wi ka dzaka i wi a, “Nsɛiŋ wuŋ, mih dalinya lɔ chu bia.” ");
INSERT INTO cug_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bəni bə̀ bɔ nì laniki nnyaki bənchi bə Nyɔ, bəh Bəfalasi bə̀, ka yisi i wamki dzakaki a, “Wələ fa kɔ fində wi dzɔ di bi Nyɔ a? Akɔ ndə wə wi kɔ i dalinya chu, kɔbi a Nyɔ shəŋ a?” ");
INSERT INTO cug_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisɔs kîə gia yə bɔ chumyiki dzakaki, wi bikə i bɔ a, “Mbɛiŋ biələ biŋkwaka kaŋaki i shɔ́m yimbɛiŋ wə lə kɔm nə a? ");
INSERT INTO cug_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yə yi bɔniki i dzaka kɔ yi naiŋ, i dzaka a mih dalinya lɔ chu bi mi wələ, ma i dzaka a wi dzâ bɛiŋ wi nyâni a? ");
INSERT INTO cug_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ayakalə, mih ki chusiki lə i mbɛiŋ i liə a mi wə yɛli wi kɔ Waiŋmi kaŋaki lə ŋga i fa kuku, i dalinya chu.” Ayaka wi ka dzaka i mi wə wi nì kɔ wi kpi wa wimu a, “Mih dzakaki i wɔ, dzâ bɛiŋ, dzɔ̂ kimbuŋ ka wɔ tsə̂ki i wɔ dzu.” ");
INSERT INTO cug_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Akisəkə, wi dza bɛiŋ num i bəni nshiŋ, ka dzɔ naka kə wi nì nɔki i yɛiŋ wə ka tsəki i wi dzu, tumyi bikum bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Bəni yɛiŋ yaka, dzaka wɔm bɔ, bɔ num bəh ŋkaŋyi, ka chɔŋyiki Nyɔ ka dzakaki a, “Buku si yɛiŋ gia yi kaŋyini daiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jisɔs dza buku fɛiŋ ka nyə. Si wi shiki tsəki, wi yɛiŋ mi widɔkɔ a num mi wi kwani kiŋwakti, bə bɔɔŋ wi a Lɛwi, wi num i di bi, bi nɔm wə. Jisɔs dzaka i wi a, “Bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ayaka Lɛwi dza bɛiŋ, bee biɛiŋ bi bichi ka biəliki Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lɛwi ka bi fə dzini bimbum i wi dzu i laŋki Jisɔs. Mbaŋ wi bəni bə kwani kiŋwakti ni kwu fɛiŋ, bəh chiŋni bəni bədɔkɔ, num i kibaŋ kidzini wə ka dziki bəh wi. ");
INSERT INTO cug_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bəfalasi bəh mbaŋ wi bəni bə̀ bɔ nì laniki bənchi bə Nyɔ, ka yisi i shwiŋyiki kɔm bwa bə mbaŋ wi Jisɔs, dzakayi a, “Akɔ kɔm nə mbɛiŋ dziki, mbɛiŋ mu bəh bəni bə̀ bɔ kwaki kiŋwakti bəh bəni bəchu bədɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisɔs chukuli i bɔ a, “Bəni bə̀ bɔ kɔ bəh gwu yiləkəli si nəŋ kə mi wi tsa. Asi nəŋ num bə̀ bɔ gwɛiŋki. ");
INSERT INTO cug_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mih ka dzə dəkə i bɔɔŋ bəni bə̀ bɔ kɔ chəŋ. Mih dzə i bɔɔŋ num bəni bə̀ bɔ kɔ bəchu ka bɔ kwuni i shɔ́m yibɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bɔ bikə i Jisɔs a, “Bwa bə mbaŋ bə Jɔn Njulibɔkɔ si kɔmsi bam lə dzaka tsa, a num ayaka si bwa bə mbaŋ bə Falasi nì fəki, ayakalə mba baaŋ a dziki a dzini mu.” ");
INSERT INTO cug_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisɔs chukuli i bɔ a, “Bə kɔlə i laka bəni i dzini bi miŋkpaŋa wimfiaŋ wə, bɔ dzə, ma mi wiwɔ nì fiəni fə a bɔ bamki dzaka, ti bini kɛiŋ fɛiŋ bəh bɔ a? ");
INSERT INTO cug_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ayakalə, kaŋ dzəki lə yə bə bi dzɔ bwili nyum miŋkpaŋa wiwɔ i bɔ, ma bɔ bi ka yisi i bamki dzaka i jɔbi wiwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wi chukuli bəh ndi widɔkɔ i bɔ a, “Mi kɔkə wə wi kɔ i taŋa mbuŋ wimfiaŋ i kwɔyi i wikpu wə. Wi ka fə yakadəiŋ, yi ni numki a wi taŋa bəkəli kinchumni kimfiaŋ kə. Ki kɔbi i ni kpɛiŋ bəh kikpu kə liŋ. ");
INSERT INTO cug_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mi mɔŋ i dzɔ mbih mimfiaŋ, i jiə i kiŋgəə kikpu mə, wi ka fə yakadəiŋ, mbih mimfiaŋ miwɔ ni biəŋə, mɔ ni wɔɔ kiŋgəə kikpu kiwɔ, ma mbih miwɔ ni laka kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yi ndzɔŋni kɔ a, bə kaŋaki i jiə mbih mimfiaŋ num i kiŋgəə kimfiaŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mbɛiŋ kiəki tə a, mi mɔŋ i muki mbih mi biəni, a wi chu kɔŋki mimfiaŋ, ma wi ni kɔŋki a mi biəni mə.” ");
INSERT INTO cug_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","A nì kɔ i chɔkɔ bimbam bidɔkɔ, Jisɔs bəh bwa bu bə mbaŋ nì nyaniki tsəki i khə wi gəŋ widɔkɔ wə. Bwa bu bə mbaŋ dza yisi i təiŋyiki kifwu ki gəŋ fiksi i bɔ kaŋ dzi. ");
INSERT INTO cug_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Bəfalasi bədɔkɔ yɛiŋ yaka, bikə a, “Akɔ kɔm nə mbɛiŋ fəki gia yə bənchi kɔŋki kə a mi fəki i chɔkɔ bimbam wə a?” ");
INSERT INTO cug_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisɔs bɔŋ bikə tə i bɔ a, “Mbɛiŋ ka num fa dəkə i Kiŋwakti ki Nyɔ wə si dzɔŋ nì wɔɔki Ŋkuŋ Dɛbit bəh mbaŋ wi, wi fə a? ");
INSERT INTO cug_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wi nì liə i juŋ yi Nyɔ wə dzɔ blɛd wə bə nì baa jiə a akɔ wi Nyɔ, dzi ka nya tə mbaŋ wi, a nì kɔ nchi i mi i dzî blɛd wiwɔ a kɔbi a bətii mfə gia.” ");
INSERT INTO cug_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jisɔs ka dzaka kaasi i bɔ a, “Mi wə yɛli wi kɔ Waiŋmi, akɔ tikwili wi chɔkɔ bimbam.” ");
INSERT INTO cug_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aka bi chu num chɔkɔ bimbam bidɔkɔ, Jisɔs tsə liə i juŋ yi tsani wə i lani bəni. Mi widɔkɔ num fɛiŋ num kimbu ki ki tsɛiŋ yiləkəli kpi. ");
INSERT INTO cug_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bəni bə̀ bɔ nì laniki bənchi bə Nyɔ bəh Bəfalasi yisi i nəŋki gia yə bɔ ki jiəki i Jisɔs fuŋ. Bɔ ka bwaŋ dzə́kəh i wi wə i yɛiŋ a wi ni chuku lə mi wiwɔ i chɔkɔ bimbam wə a. ");
INSERT INTO cug_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jisɔs kiə gia yə bɔ nì finiki bəh yi, wi dzaka i mi wə tsɛiŋ yi nì kɔ yi kpi a, “Dzâ bɛ̂iŋ, dzə̂ nûm fa.” Wi ka dzə numbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jisɔs bikə i bɔ a, “Mih bikəki num i mbɛiŋ a, gia yə bənchi bumki a mi kɔlə i fə̂ i chɔkɔ bimbam wə kɔ yi naiŋ? I fə̂ ndzɔŋni, ma i fə̂ chu a? I gâmti mi, ma i wɔ̂ɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wi tsɛiŋ tali bɔ bəchi i shi chɛiŋ, ka dzaka i mi wiwɔ a, “Nâni tsɛiŋ ya.” Wi nani, yi kaa ka bɔnih. ");
INSERT INTO cug_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ayakalə, yi ka nya lɔ ŋgəkə i shɔ́m yi bəni bəwɔ wə, bɔ ka yisi i sisiki kɛiŋsi si bɔ ki fəki bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","A nì kɔ a kaŋ yiwɔ wə, Jisɔs nyə yaka i ŋkwuŋ wə i tsə tsa, wi nì baaŋ fɛiŋ a tsaki Nyɔ chɔkɔ wɔɔ. ");
INSERT INTO cug_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Si chɔkɔ wɔɔ, wi bɔɔŋ bəmbiəli bu, bɔ dzə. Wi sabi bədɔkɔ jwɔfi ntsɔ bəfa bɔɔŋ bɔ a bwa bu bə ntum. ");
INSERT INTO cug_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kiyɛli ki bəni bəwɔ nì kɔ: Samɔn wə wi nì nya yɛli wi widɔkɔ a Bita, bəh Andulu wə waiŋnih Samɔn. Bədɔkɔ num Jɛm, Jɔn, Filib, Batɔlɔmu, ");
INSERT INTO cug_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiɔ, Tɔmɔs bəh Jɛm wə waiŋ Alfiyus, Samɔn wə wi nì kɔ mi i mbaŋ wi Bədzɛlɔt, ");
INSERT INTO cug_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas wə waiŋ Jɛm bəh Judas Iskaliɔt wə wi nì tsə taŋni Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Si wi sabi bɔ yakadəiŋ, bəh bɔ bəchi ka nyə shi dzə. Si bɔ shi dzə wi num i baa wi di wə, bəh bwa bu bə mbaŋ bə̀ bəh bɔ nì kɔ bɔ si num fɛiŋ bəh mbaŋ wi bəni wimbum bə̀ bɔ ni kwu fɛiŋ bəduli, num bɔ buku dzə i Judea bəh i Jɛlusalɛm wə. Bəni bədɔkɔ nì nyəki dzəki i bidi biə bi kɔ kɔmsiki i kinchwɔ kimbum wə ka Taya bəh Sidɔn. ");
INSERT INTO cug_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Bɔ nì dzə i wɔkɔ nlani wi Jisɔs, a wi bɔŋ chûku tə jwɛ́iŋ yibɔ. Bəni bə̀ biŋ'waka bichu nì nyaki ŋgəkə i bɔ, nì dzəki tə wi bwili biŋ'waka biwɔ i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ayaka bəni bəchi ka jwɔki i kɔm i wi wə, kɔm ŋga biə bi nì bukuki i wi wə, nì chukuki lə bəni bəchi bə̀ bɔ nì kɔmyiki wi. ");
INSERT INTO cug_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisɔs dza tsɛiŋ tali bəni bu bə mbaŋ dzaka i bɔ a, “Kimbɔiŋsi kimbum kɔ kimbɛiŋ bə kifuu, kɔm ŋkuŋ bi Nyɔ kɔ bimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kimbɔiŋsi kimbum kɔ kimbɛiŋ bə̀ mbɛiŋ kpiki dzɔŋ i liə, kɔm Nyɔ bi fə lə ma mbɛiŋ bi fwuli. Kimbɔiŋsi kimbum kɔ kimbɛiŋ bə̀ mbɛiŋ dəki i liə, kɔm mbɛiŋ bi suŋɔyiki lə. ");
INSERT INTO cug_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kimbɔiŋsi kimbum kɔ kimbɛiŋ , i jɔbi wə mbɛiŋ biəli mi wə yɛli wi kɔ Waiŋmi, ayaka bəni baiŋŋ mbɛiŋ, kɔŋŋ bwili mbɛiŋ i mbaŋ wibɔ wə, tɔyi mbɛiŋ chu nya kiyɛli kichu i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jɔbi wə yi bi numki yakadəiŋ, mbɛiŋ bi numki bəh kinsaŋli i chɔkɔ biə yi bi numki i mbɛiŋ, ma mbɛiŋ bi ka laŋki, biŋ, wɔkɔ ndzɔŋni, kɔm mmakti wimbɛiŋ widuli kɔ i tumi ki bɛiŋ wə. Mbɛiŋ kîəki a, akɔ asi bətii tii bəbɔ nì chəbsiki bəni bə ntum bə Nyɔ i kikpu wə. ");
INSERT INTO cug_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ayakalə, Ŋgəkə wimbum kɔ i mbɛiŋ, bəni bəmbum, kɔm ndzɔŋni bibɔ bi kaaki num a fa kuku. ");
INSERT INTO cug_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ŋgəkə wimbum kɔ i mbɛiŋ, bə̀ kitɔɔ kibɔ kɔ kifwuli i liə, kɔm bɔ bi kpiki lə dzɔŋ. Ŋgəkə wimbum kɔ i mbɛiŋ, bə̀ mbɛiŋ suŋuki i liə, kɔm mbɛiŋ bi dəki lə chuŋsi kifwu kimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ŋgəkə wimbum kɔ i mbɛiŋ, i jɔbi wə bəni bəchi kɔksiki mbɛiŋ. Mbɛiŋ kîə a, yi kɔ asi bətii tii bəbɔ nì kɔksiki bəni bəntəkə bə̀ bɔ nì nyiki ntəkə a bɔ kɔ bəni bə ntum bə Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ayakalə, mih fukuki i mbɛiŋ bələ mbɛiŋ wɔkɔliki gia yə mih dzakaki a, mbɛiŋ kɔ̂ŋki bəni bə̀ bɔ baiŋŋki mbɛiŋ, mbɛiŋ fə̂ki num gia yindzɔŋni i bə̀ bɔ baiŋŋki mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mbɛiŋ tsâ a Nyɔ faaŋ kimbɔiŋsi i bəni bə̀ bɔ tsaki a lɔiŋ kwaki mbɛiŋ, mbɛiŋ chu tsâ i bə̀ bɔ chəbsiki mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mi ka twɛiŋ wɔ i kimbaŋ wə, wɔ fîəni kidɔkɔ kə, wi twɛiŋ kaasi. Ayaka mi ka ba dzɔ mbuŋ wa wi nimbɛiŋ, wɔ bêe wi dzɔ kaasi wi numə. ");
INSERT INTO cug_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nyâ na ndə wə wi nywa fiɛŋ i wɔ, ayaka mi ka dzɔ biɛiŋ bia, kiə wɔ ki fiəni bikə kə. ");
INSERT INTO cug_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mbɛiŋ fə̂ki gia i bəni, asi mbɛiŋ kɔŋki a bɔ fə̂ki tə i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mbɛiŋ ka kɔŋki a bəni bə̀ bɔ kɔŋki mbɛiŋ, gia yə bə bi kɔksi mbɛiŋ yɛiŋ kɔ yi naiŋ? Na bəni bəchu si bɔŋ fə kə ayaka tə a? Bɔ kɔŋki tə a bə̀ bɔ kɔŋki bɔ. ");
INSERT INTO cug_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mbɛiŋ ka fəki ndzɔŋni a bəni bə̀ bɔ fəki tə i mbɛiŋ, gia yə bə bi kɔksi mbɛiŋ yɛiŋ kɔ yi naiŋ? Na bəni bəchu si bɔŋ fə kə a yakadəiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mbɛiŋ ka fwasiki biɛiŋ i bəni bə̀ mbɛiŋ yɛiŋki a bɔ kɔlə i chukuli bi, gia yə bə bi kɔksi mbɛiŋ yɛiŋ kɔ yi naiŋ? Bəni bəchu tə si fwasi lə biɛiŋ i nsɛiŋ yibɔ kɔm bɔ kiəki a bɔ bi chukuki lə bichi. ");
INSERT INTO cug_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yi kɔ chəŋ a mbɛiŋ kɔ̂ŋki bəni bə̀ bɔ baiŋki mbɛiŋ, mbɛiŋ fə̂ki num gia yindzɔŋni i bɔ, mbɛiŋ ma fwâsiki biɛiŋ i bəni bəh kiŋkwaka i bi fiəni kwati. Ayakadəiŋ, mbɛiŋ bi ka kwati mmakti wimbɛiŋ wimbum, ma mbɛiŋ ka bi num bwa bə Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə. Kɔm yi kɔ tə ayaka si wi fəki gia yindzɔŋni i bəni bə̀ bɔ bukuki bəh dzə́kəh, bəh bə̀ bɔ kɔ bəh shɔ́m yichu. ");
INSERT INTO cug_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mbɛiŋ kwâsiki nshɛiŋ i bəni wə, asi Ba wimbɛiŋ wə wi kɔ i bɔɔli bɛiŋ kwasiki tə i bəni. ");
INSERT INTO cug_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Kiə mbɛiŋ ki sâka kə bimfə bi bəni bədɔkɔ, ka Nyɔ bi ma saka tə bimbɛiŋ. Kiə mbɛiŋ bi ma bwâŋki gvu i bəni bədɔkɔ chɛiŋ a bɔ lîə i ŋgəkə wə, ka Nyɔ tə bi ma bwaŋ gvu i mbɛiŋ chəŋ. Mbɛiŋ dâlinyaki chu bi bəni bədɔkɔ, ka Nyɔ tə bi dalinya bimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mbɛiŋ nyâ kinya i bəni, Nyɔ bi nya tə i mbɛiŋ. Ka Nyɔ bi bə́ nya wi fəkə ndzɔŋ nalə wi chəŋ, wi nəŋni ka bi shukuki i kuku. Fiɛŋ fiə mi wiwɔ fəkə biɛiŋ bi yɛiŋ kɔ fi Nyɔ bi fiəni fəkəki yɛiŋ i nya i mi wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisɔs chu ti bɔ bəh ndi widɔkɔ a, “Kimfəkə kidɔkɔ kɔ i chusi dəiŋ dzə i kidɔkɔ a? Wi ka mɔm bɔ bəchi ma ni gbɔyi i fəŋ mə a? ");
INSERT INTO cug_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mbɛiŋ kîəki a waiŋ wi kiŋwakti kɔkə tsə mi wi wi lanini. Ayakalə, jɔbi wə wi ka lani kiə kaasi, ma wi numki aka mi wə wi lani wi. ");
INSERT INTO cug_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Akɔ kɔm nə wɔ tsɛiŋki shəkə yi kpɛiŋ i dzəkəh wi waiŋnah wə, ayakalə wɔ yɛiŋ kə kimfuŋ ki kpɛiŋ kə ki kɔ i ŋ'wa dzəkəh wə a? ");
INSERT INTO cug_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wɔ kɔ i dzaka dəiŋ i waiŋnah a, ‘Waiŋnih nûm ma mih bwili shəkə yi kpɛiŋ i dzəkəh wa mə,’ ayakalə kimfuŋ ki kpɛiŋ num i ŋ'wa dzəkəh wə a? Wɔ kɔ mi wə wi chusiki gwu! Yisi bwili kimfuŋ ki kpɛiŋ kə ki kɔ i dzəkəh wa wə, na ka wɔ ni yɛiŋ ndzɔŋ shəkə yi kpɛiŋ yə yi kɔ i dzəkəh wi waiŋnah wə i bwili.” ");
INSERT INTO cug_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisɔs chu dzaka a, “Yi kɔ a, kpɛiŋ wi ndzɔŋni kɔkə i wum mintam michu. Ayaka kpɛiŋ wichu kɔbi tə i wum mintam mi ndzɔŋni. ");
INSERT INTO cug_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bə si kiə kpɛiŋ a num i mintam mə mɔ wumki yɛiŋ wə. Mi kɔkə i kɔh fimbi i bifaka wə, ayaka mi kɔbi tə i kɔh migaali i kpɛiŋ wi chwa wə. ");
INSERT INTO cug_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mi wə wi kaŋaki kiba ki biɛiŋ bindzɔŋni i shɔm yi mə, ayaka wi si bwili num a biɛiŋ bindzɔŋni yɛiŋ. Mi wə wi kaŋaki kiba ki biɛiŋ bichu i shɔm yi mə, ayaka wi si bwili num a biɛiŋ bichu yɛiŋ. Yi kɔ yakadəiŋ kɔm gia yə yi kɔ yi jikə i shɔm yi mə, kɔ yə yi si buku i dzaka ki wə.” ");
INSERT INTO cug_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisɔs ka bikə a, “Akɔ kɔm nə wə mbɛiŋ bɔɔŋki mih a, ‘Bah, Bah’, mbɛiŋ fə kə gia yə mih dzakaki i mbɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mi wə wi dzəki i mih wi wɔkɔ nlani wuŋ, wi ka tsə fəki asi wi wɔkɔ, mih ni chusi lə i mbɛiŋ fiɛŋ fiə wi kɔ fi. ");
INSERT INTO cug_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wi kɔ aka mi wə wi nì nəŋki i maa juŋ, wi yisi chum shi, tsə kɔm i biaŋa wə, ka chɔkɔ chaka ki juŋ yɛiŋ wə, ka maa. Jɔbi wə bɔkɔ nì jikə buku dzə chɔkɔ juŋ yiwɔ, yi nəki gbɔ kə, kɔm wi nì kɔ wi maa yi bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ayakalə, mi wə wi dzə, i wɔkɔ nlani wuŋ wələ tsə nəki fə kə asi yi kɔ, yaka wi kɔ aka mi wə wi nì nəŋki i maa juŋ ka tsə takyi a di maa a kuku chaka kɔbi, bɔkɔ buku dzə chɔkɔ chini juŋ yiwɔ, yi shi gbɔ akisəkə lə gbuuu, ka shakyi yichi.” ");
INSERT INTO cug_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisɔs nì kaasi nlani wələ wichi i bəni bəchi bə̀ fɛiŋ, wi ka nyə tsə i kwili wi Kafanaum wə. ");
INSERT INTO cug_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tikwili wi mbaŋ wi bəni bə jum widɔkɔ wi Lum num fɛiŋ wi kaŋa mfa wi widɔkɔ, wi kɔŋ wi nalə. Mfa wiwɔ gwɛiŋ wi num a dzaka ki kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jɔbi wə tikwili wiwɔ nì wɔkɔ kɔm Jisɔs, wi ka faaŋ kifwu kə bɔ nì sakaki tumi ki Bəju, a bɔ tsə̂ tsâ Jisɔs a wi dzə̂ chûku mfa wi ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Bɔ ka tsə yɛiŋ Jisɔs, kwuŋ kaŋ i wi dzaka a, “Buku tsaki wɔ a tsə̂ gâmti mi wibuku wələ, kɔm wi lansiki nəŋki lə ŋgamti i wɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Akɔ mi wi kɔŋ tumi kibukumbɛiŋ nalə, a num wi wə wi nì maa juŋ yibuku yi tsani.” ");
INSERT INTO cug_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jisɔs ka nyə bəh bɔ ka tsəki, si bɔ ni shiki kɔmsiki tsəki i juŋ yi tikwili wi bəni bə jum wiwɔ, tikwili wiwɔ ka faaŋ nsɛ́iŋ yi yidɔkɔ a bɔ tsə̂ chîi Jisɔs, bɔ tsə bəh bɔ baŋsi, bɔ fuku i wi a, “Bah, tikwili wi bəni bə jum dzaka a wɔ ma nyâ ŋgəkə i gwu ya wə. Kɔm ŋgaiŋ baiŋki kə ka wɔ liə i ŋgaiŋ dzu. ");
INSERT INTO cug_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Akɔ gia yə ŋgaiŋ yɛiŋ a ŋgaiŋ kpɛiŋniki kə ka ŋgaiŋ dzə buku i wɔ wə. Ayakalə, a wɔ dzâka a dzakani ma mfa wi ŋgaiŋ bɔnih. ");
INSERT INTO cug_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","A ŋgaiŋ tə kɔ mi i mi widɔkɔ chɛiŋ wə wi kaŋaki ŋga, ŋgaiŋ tə num mi bəh bəni bə jum i ŋgaiŋ chɛiŋ, a ŋgaiŋ si dzaka i widɔkɔ a, ‘Tsə̂,’ wi tsə a tsəni, i widɔkɔ a, ‘Dzə̂,’ wi dzə a dzəni, ŋgaiŋ dzaka i mfa wi ŋgaiŋ tə a, ‘Fə̂ lə,’ wi fə a fəni.” ");
INSERT INTO cug_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jɔbi wə Jisɔs nì wɔkɔ gia yiwɔ yakadəiŋ, dzaka wɔm wi, wi fiəni gwu ka dzaka i mbaŋ wi bəni bə̀ bɔ nì biəliki wi a, “Mih fukuki gia yi ŋkɔŋ i mbɛiŋ a, mih kɛiŋki ki yɛiŋ kə mi widɔkɔ i Islae, wə wi jiə ŋkaiŋni wi shɔm ka mi wələ.” ");
INSERT INTO cug_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Asi bəni bə̀ tikwili wi bəni bə jum nì faaŋ nì fiəni tsə dzu, ka yɛiŋ num mfa wiwɔ si bɔnih lɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Asi yəmaka nì tsə, Jisɔs bəh bwa bu bə mbaŋ nyə ka tsəki i kwili widɔkɔ wə bə bɔɔŋ a Nayin, mbaŋ wi bəni kwu i wi chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Asi bɔ nì bukuki tsəki i dzaka ki mbaiŋ kə ki liəki tsəki i kwili wiwɔ wə, bɔ dzaka a bɔ tsɛiŋ ka yɛiŋ bə giŋ buku dzə bəh waiŋ num wi kpi, a num a wi i nih wi kaŋ. Nih wi nì kɔ kpə ŋkwu. Mbaŋ wi bəni i kwili wiwɔ wə fɛiŋ num bɔ kwu i nih waiŋ wiwɔ chɛiŋ biəli wi. ");
INSERT INTO cug_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jɔbi wə Bah nì yɛiŋ kpaŋa wiwɔ, nshɛiŋ kwa wi, wi dzaka i wi a, “Ki də̂ kə.” ");
INSERT INTO cug_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Si wi dzaka yakadəiŋ, ka tsə kɔm kimbuŋ kə bə nì giŋ wini wiwɔ yɛiŋ. Bəni bə̀ bɔ nì giŋ wi ka num. Wi dzaka a, “Waiŋ sumi, mih dzakaki i wɔ, dzâ bɛiŋ!” ");
INSERT INTO cug_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wi ka dza num bəh chwɔŋ, yisi i dzakaki, Jisɔs kaŋa wi i tsɛiŋ wə ka nya i nih wi. ");
INSERT INTO cug_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Si bəni bəchi yɛiŋ yakadəiŋ, dzaka wɔm bɔ. Bɔ yisi i chɔŋyiki Nyɔ dzakayi a, “Mi wi ntum wi Nyɔ wimbum dzə buku i buku kintəəŋ. Nyɔ dzə i gamti bəni bu.” ");
INSERT INTO cug_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ntum wələ kɔm Jisɔs waŋ tsə Judea wichi bəh i bitumi biə bi kɔ kɔmsi fɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jɔbi wə bwa bə mbaŋ bə Jɔn nì wɔkɔ tə gia yiwɔ yichi, tsə fuku i wi. Wi bɔɔŋ bədɔkɔ bəfa, ");
INSERT INTO cug_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Faaŋ i Bah a bɔ tsə̂ bîkə i wi a, “Akɔ a wi wə wi nì kaŋaki i bi dzə ma buku wɔ̂kɔliki num widɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jɔbi wə bɔ nì tsə yɛiŋ Jisɔs dzaka i wi a, “Jɔn Njulibɔkɔ faaŋ buku i bikə i wɔ a, akɔ a wɔ wə wɔ ni kaŋaki i bi dzə a? Ma buku wɔ̂kɔliki num widɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bɔ nì bikəki yakadəiŋ, a num a jɔbi wə Jisɔs si chuku bəni bə jwɛ́iŋ bəduli, wi bwili biŋ'waka bichu i gwu yi bəni wə, wɛli dzə́kəh yi bimfəkə bəduli. ");
INSERT INTO cug_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jisɔs chukuli i bɔ a, “Mbɛiŋ fîəni tsə̂ fûku i Jɔn gia yə mbɛiŋ yɛiŋ bəh yə mbɛiŋ wɔkɔ. Bimfəkə yɛiŋ di, bəni bə̀ bɔ gbɔki nyaniki nyani chəŋ, bəni bə̀ bɔ gwɛiŋki bəh jwɛiŋ yi kumyini bɔ bɔnih. Bichini wɔkɔ gia, bəni bə̀ bɔ kpiyi fiəni dza bəwɔm, bə chu fuku tə ntum wi ndzɔŋni wi Nyɔ i bəni bə kifuu. ");
INSERT INTO cug_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kimbɔiŋsi kimbum kɔ i mi wə wi ka məŋni dəkə mih.” ");
INSERT INTO cug_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jɔbi wə bəni bə̀ Jɔn nì faaŋ nì fiəni nyə, Jisɔs ka yisi i dzakaki i mbaŋ wi bəni kɔm Jɔn, bikə a, “Mbɛiŋ nì buku tsə chwa i tsə yɛiŋ num nə a? Gaŋ biə fiəkə tsəki bi nəŋni a? ");
INSERT INTO cug_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mbɛiŋ ni buku tsə i yɛiŋ nə? Mi wə wi si tum bəmbuŋ bə bɔnini i gwu wə a? Mbɛiŋ wɔ̂kɔli, bəni bə̀ bɔ si kaŋa gwu bəh bəmbuŋ bə ləkəli chu wɔkɔ ndzɔŋni, bəmaka si nɔ num i bəntɔŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mbɛiŋ bə́ buku tsə i yɛiŋ nə a? Mi wi ntum wi Nyɔ ma? Aaŋ, mih fukuki i mbɛiŋ a, akɔ mi wi tsə mi wi ntum wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Akɔ wi wə bə nì nyaka kɔm wi, Nyɔ nì dzaka a, ‘Wɔ̂kɔli, mih ni chiŋsi lə mi wuŋ wi ntum, ma wi tsə i wɔ nshiŋ, wi tsə kɛiŋsi dzəh ya ka wɔ bi dzəki.’ ");
INSERT INTO cug_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mih fukuki i mbɛiŋ a, i kintəəŋ ki bəni bə̀ a bwɔ miŋkpaŋa, mi widɔkɔ kɔkə yɛiŋ wə wi kɔ mi wimbum wə wi tsəki Jɔn Njulibɔkɔ. Ayakalə, mi wə wi kɔ na wi nchiŋ i kintəəŋ ki ŋkuŋ bi Nyɔ wə, wi kɔ wi kɔkni tsə Jɔn.” ");
INSERT INTO cug_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bəni bəchi na bəh bəni bə̀ bɔ nì kwaki kiŋwakti nì wɔkɔ si Jisɔs dzaka a Jɔn nì kɔ mi wi ntum wi Nyɔ, bɔ kɔksi ŋkuŋ bi Nyɔ a bi kɔ bi chəŋ, kɔm bɔ tə nì bum Jɔn juli bɔ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ayakalə, Bəfalasi bəh bəni bə̀ bɔ nì tɔksiki kiəki bənchi bə Nyɔ nəiŋma fibɔ ntum wi ndzɔŋni wi Nyɔ wiwɔ, ka nəiŋma a Jɔn ma juli bɔ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisɔs ka dza dzaka i bɔ a, “Mih ki fəkəniki ŋgɔkɔ wi bəni wi liə wələ bəh finə a? Bɔ kɔ ka finə a? ");
INSERT INTO cug_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mih ki fukuki lə si bɔ kɔ, bɔ kɔ aka bwa, bɔ numyi i di bi shi wə, ka bɔɔŋki bədɔkɔ bikə i bɔ a, ‘Buku tɔŋki sɔŋ mbɛiŋ biŋ kə kɔm nə? Nya ja yi kpi mbɛiŋ bum kə kɔm nə?’ ");
INSERT INTO cug_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jɔn Njulibɔkɔ nì dzə, wi dzi kə biɛiŋ bidzini mu kə mbih, mbɛiŋ ka dzakaki a wi kaŋaki lə chinda wi ŋkpɛli i gwu yi mə. ");
INSERT INTO cug_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mi wə yɛli wi kɔ Waiŋmi dzə, wi dzi, chu mu, mbɛiŋ dzaka a bə yɛ̂iŋ si wi məyiki nnyaki dzɛiŋ, məyiki mbih, wi chu num nsɛiŋ bəh bəni bə̀ bɔ kwaki kiŋwakti bəh bəni bəchu bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ayakalə, bəni bə̀ bɔ bumki mfi bi Nyɔ, kɔ bə̀ bɔ yɛiŋ a, bi kɔ chəŋ.” ");
INSERT INTO cug_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mi wi Falasi widɔkɔ nì dza laka Jisɔs a wi dzə dzi i ŋgaiŋ dzu. Jisɔs bum ka tsə num ka dziki bəh wi. ");
INSERT INTO cug_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kpaŋa wi tɔkɔlini widɔkɔ num fɛiŋ i kwili wiwɔ wə. Wi ka wɔkɔ a Jisɔs dziki i mi wi Falasi dzu, wi ka dzɔ finsɔkɔ fi fiaŋsi fidɔkɔ fi fitsɛŋə yindzɔŋni, tsə bəh fi fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wi tsə liə num i Jisɔs jum, ka yisi i dəki, mindəm shi i gvu yi Jisɔs wə. Wi ka ŋgwuŋ kuku, ka sɔki gvu yi Jisɔs bəh juŋyifwu, kɔmyi yi ka fiaŋsiki bəh fiaŋsi biwɔ. ");
INSERT INTO cug_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Mi wi Falasi wə wi nì bɔɔŋ Jisɔs a wi dzə̂ dzî, yɛiŋ yaka, kwaka i shɔm yi wə a, “Asi kɔ a mi wələ fa numki mi ntum wi Nyɔ, ma wi kiə gia yə kpaŋa wələ wi kɔmyiki wi lə kɔ bəh yi, a wi kɔ kpaŋa wi tɔkɔlini.” ");
INSERT INTO cug_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisɔs ka dza dzaka i mi wi Falasi wiwɔ a, “Samɔn, mih kaŋaki lə gia i dzaka i wɔ.” Wi chukuli a, “Mi wi lanini, dzâka.” ");
INSERT INTO cug_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisɔs ka yisi a, “Mi widɔkɔ nì kɔ num wi fwasi bəni bəfa bəh kpɔ, fwasi mi widɔkɔ bəh bədanali gi yite, fwasi widɔkɔ bədanali mbaŋshi. ");
INSERT INTO cug_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wi nì gaka bɔ bəchi i fiəni gɔm, wi ka bee kpɔ wiwɔ i bɔ. I liə wɔ yɛiŋ a i bəni bəfa bələ kintəəŋ, mi wə wi kɔŋki wi nalə kɔ winaiŋ a?” ");
INSERT INTO cug_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Samɔn chukuli a, “Akɔ i numki mi wə wi nì fwa widuli.” Jisɔs bum a, “Wɔ chukuli ndzɔŋ.” ");
INSERT INTO cug_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Si wi bum yakadəiŋ, fiəni gwu tsɛiŋ kpaŋa wə, ka dzaka i Samɔn a, “Wɔ yɛiŋ kpaŋa wələ? Si mih si dzə i wɔ dzu, wɔ si ka kɔŋ i nya na mih bəh mwi, i wɔkɔ gvu yiŋ yɛiŋ. Ayakalə, kpaŋa wələ wɔkɔ lɔ gvu yiŋ num bəh mindəm, sɔ bəh juŋyifwu. ");
INSERT INTO cug_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wɔ si ka bɔni i mih na i kɔmyi mih. Ayakalə, na jɔbi wə mih si dzə fa, kɔ a kpaŋa wələ si wi kɔmyi gvu yiŋ. ");
INSERT INTO cug_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wɔ si ka fiaŋsi dəkə fwu wuŋ bəh fiaŋsi. Ayakalə, kpaŋa wələ fiaŋsi lɔ gvu yiŋ num bəh fiaŋsi bi tsɛŋə yindzɔŋni. ");
INSERT INTO cug_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ayakadəiŋ, mih fukuki i wɔ a, kpaŋa wələ chusi kiŋkɔŋ kimbum kɔm bə chu bi biduli biə mih dalinya. Ayakalə, mi wə bə dalinya chu bi num bi twɛsi chusiki kiŋkɔŋ kitwɛsi.” ");
INSERT INTO cug_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jisɔs ka dzaka i kpaŋa wiwɔ a, “Mih si dalinya lɔ chu bia.” ");
INSERT INTO cug_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bəni bə̀ bəh bɔ nì dziki ka yisi i shwiŋyiki dzakayi a bɔ bɔ a, “Wələ kɔ ndə wə wi kɔ na i dalinya chu bi bəni a?” ");
INSERT INTO cug_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisɔs ka fiəni dzaka i kpaŋa wiwɔ a, “Nyə̂ mfia bindzɔŋ, kɔm bə shɔm yə wɔ jiə i mih, yi bwili wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","I Jɔbi widɔkɔ wə twɛsi, Jisɔs nyə ka nyaniki i kikwili kimbum wə bəh bidi wə i fukuki ntum wi ndzɔŋni kɔm ŋkuŋ bi Nyɔ. Bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa biəli wi, ");
INSERT INTO cug_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","bəh bəkaŋa bədɔkɔ bə̀ wi nì chuku jwɛiŋ yibɔ bəh bə̀ wi nì bwili biŋ'waka bichu i bɔ wə. Bəkaŋa bələ nì kɔ Meli wə bə nì bɔɔŋki a Magdalen, wə wi nì bwili bəchinda bə ŋkpɛli i gwu yi wə nanitaŋ. ");
INSERT INTO cug_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jɔana wə nyuwi nì kɔ Chusa wi nì nɔmki i Hɛlɔd, bəh Susana bəh bəkaŋa bədɔkɔ bəduli. Bɔ nì nyaniki yakadəiŋ, bwili biɛiŋ i biba bibɔ wə, i gamti Jisɔs bəh bwa bu bə mbaŋ. ");
INSERT INTO cug_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bəni nì dza nyəki dzəki i di di wə ka dzəki i Jisɔs. Jɔbi wə mbaŋ wi bəni nì jikə fɛiŋ, wi ti ndi i bɔ a. ");
INSERT INTO cug_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mi nì laa i tsə mu ŋgɔkɔ. Asi wi nì muki ŋgɔkɔ wiwɔ, bədɔkɔ gbɔyi i dzəh, bəni dəŋyi bəh gvu, minyəni mə mɔ fuliki bɛiŋ dzə chumyi dzi. ");
INSERT INTO cug_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ŋgɔkɔ widɔkɔ gbɔyi i di bi kitəh wə, ka buku yaka ka kpiyi kɔm di biwɔ nì kɔ di bi wɔmni. ");
INSERT INTO cug_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ŋgɔkɔ widɔkɔ gbɔyi i bifaka wə, ka buku yaka bə́ kɔ bəh bifaka biwɔ, bi ka baŋ ŋgɔkɔ wiwɔ a wi ma kɔki. ");
INSERT INTO cug_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Widɔkɔ gbɔyi num i nshwaiŋ yindzɔŋni wə, wi buku yaka ka kɔ, ka wum mintam gbi mɔ du tsə si bə nì mu.” Si Jisɔs ti ndi wiwɔ yakadəiŋ ka dzaka a, “Mi wə wi kaŋaki bintuni i wɔkɔ, wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bwa bu bə mbaŋ nì dza fiəni bikə i wi a ndi wələ chusiki a nə a? ");
INSERT INTO cug_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Wi chukuli a, “Akɔ i mbɛiŋ bələ bə̀ Nyɔ fə a mbɛiŋ kiə gia yə yi nyumiki i ŋkuŋ bi Nyɔ wə. Ayakalə, bəni bədɔkɔ wɔkɔki fibɔ num i bəndi wə, ka yi ni num asi yi nì kɔ lɔ a, ‘Bɔ bi tsɛiŋki di, bɔ yɛiŋ kə, bɔ bi wɔkɔki gia, bɔ wɔkɔ kiə kə.’ ");
INSERT INTO cug_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Mbɛiŋ wɔkɔ la fwu wi gia wə ndi wələ chusiki. Ŋgɔkɔ wiwɔ kɔ gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ŋgɔkɔ wə wi nì gbɔ i dzəh, kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ Satan dzə dzɔ bwili gia yiwɔ i shɔ́m yibɔ wə, ka bɔ ma bum i buku i chu wə. ");
INSERT INTO cug_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ŋgɔkɔ wə wi nì gbɔ i di bi kitəh wə, kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, bɔ dzɔ yi bəh kinsaŋli, ayakalə, yi kaŋa kə gaaŋ i shɔ́m yibɔ wə, kimbum kibɔ kɔ a dzu yi dzaka wə. Jɔbi wə mɔmsi dzə, bɔ gbɔyi i mbum wibɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ŋgɔkɔ wə wi nì gbɔ i bifaka wə kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, jɔbi wə bɔ tsəki kifum, bəh mbum, bəh ndzɔŋni bi biɛiŋ bi mbi wələ dzə jikə baŋ gia yiwɔ yi laka. ");
INSERT INTO cug_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ŋgɔkɔ wə wi nì gbɔ i nshwaiŋ yindzɔŋni wə, akɔ num bəni bə̀ bɔ nì kaŋaki shɔ́m yindzɔŋni, bə̀ bɔ wɔkɔki gia yi Nyɔ, jiə yi i shɔ́m yibɔ wə, ka kaŋa shɔm, ka fəki asi yi nəŋki tsə a ninshiŋ ninshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mi si baiŋsi kə naka ki baiŋsini i chu dzɔ kah i kwusi baŋ yɛiŋ bɛiŋ, nabə i ləkə jiə i kigasi. Wi kaŋaki i tuŋ ki i di biə bə si tuŋ ka ki baiŋki i na ndə wə wi liə i dzu, wi yɛiŋ baiŋni biwɔ. ");
INSERT INTO cug_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Gia yichi yə yi nyumiki bi bukuki lə i baiŋni wə, bəh biɛiŋ bi jum wə jum wə biə bi nyumiki bi bukuki lə i baiŋni wə. ");
INSERT INTO cug_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ayakadəiŋ, jɔbi wə mbɛiŋ wɔkɔliki gia yi Nyɔ, mbɛiŋ ka wɔ̂kɔliki bindzɔŋ, kîə a mi wə wi kaŋaki, bə bi kpɛiŋsiki lə. Ayakalə, mi wə wi kaŋaki kə, na fi twɛsi fiə wi kwakaki a wi kaŋaki lə bə bi dzɔ bwiliki lə fi i wi.” ");
INSERT INTO cug_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nih Jisɔs bəh bwa bə nih bə Jisɔs ka dzə num i biŋ, yi gaka bɔ i liə tsə kɔm mbaŋ wi bəni nì kwu fɛiŋ nalə. ");
INSERT INTO cug_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mi widɔkɔ fuku i wi a, “Nih wa bəh bwa bə nah kɔ i biŋ nəŋ i yɛiŋ wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wi dzaka i bɔ a, “Nih wuŋ bəh bwa bə nih bəŋ kɔ bəni bə̀ bɔ wɔkɔki gia yi Nyɔ, fə asi yi nəŋki.” ");
INSERT INTO cug_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","A num chɔkɔ bidɔkɔ, Jisɔs dzaka i bwa bu bə mbaŋ a, “Bukumbɛiŋ dâŋ bûku tsə̂ i kiwuŋ ki bɔkɔ kə yaka wə.” Bɔ ka liə i ŋgwuki wə ka daŋki. ");
INSERT INTO cug_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Si bɔ nì daŋki, Jisɔs dza gbɔ kinu. Fuŋni kiləkəli dzə tumbuku, yisi ka nəŋniki bɔkɔ na bəh ŋga, mwi liə i ŋgwuki mɔ bə́ nəŋ i jiksi ŋgwuki wiwɔ, bɔ nì kɔ a dzaka ki kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bɔ tsə ka yɔmsiki Jisɔs dzaka a, “Tikwili, Tikwili, bukumbɛiŋ ki kpiyiki lə.” Jisɔs yɔmi ka kaŋyi fuŋni kiləkəli kiwɔ bəh bɔkɔ yi fəyini yiwɔ ka kpichumi lə mɔɔɔŋ. ");
INSERT INTO cug_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wi ka bikə i bɔ a, “Mbɛiŋ lansi jiə shɔ́m yimbɛiŋ i ndə a?” Gwu kpi bɔ, bɔ lwa na bəh ŋga ka məŋki a, “Wələ kɔ winaiŋ mi wə wi kaŋyiki na fuŋni kiləkəli bəh bɔkɔ, yi wɔkɔ i wi a?” ");
INSERT INTO cug_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Bɔ daŋ bɔkɔ yiwɔ buku i waka i kimbu ki Gɛlasen wə, kə ki tsɛiŋki daŋsiki kimbu ki Galili. ");
INSERT INTO cug_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Si Jisɔs nì buku i ŋgwuki wə, a wi tsə buku tsə i kpa, bɔ mi widɔkɔ fɛiŋ i kwili wiwɔ wə baŋsi, wi num bəh bəchinda bə ŋkpɛli i wi mə bɔ njəŋsiki wi. I jɔbi wi dəəŋ wə wi lɔ kə mbuŋ i gwu wə, num bɔ nì nɔ i gwu yi wə nalə wi nyani nnya a bəh chwɔŋ kiyəə, wi nɔ num i bita biə bə nì ləki bəni yɛiŋ. Wi nì chu nɔki kə i dzu. ");
INSERT INTO cug_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Si wi yɛiŋ Jisɔs wə, ka tɔŋ wili, tsə gbɔ i wi nshiŋ, wam bəh ŋga a, “Jisɔs, Waiŋ Nyɔ, Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə, wɔ nəŋki nə i mih wə a? Mih tsaki wɔ ma nya ŋgəkə i mih.” ");
INSERT INTO cug_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wi nì dzaka yakadəiŋ kɔm Jisɔs nì kɔ wi kaŋyi lɔ kiŋ'waka kichu kiwɔ a ki bûku i gwu yi mi wiwɔ mə. Ki nì chufi lɔɔki wi i kuku i jɔbi jɔbi wə. Ayaka wi nì kɔ bə kɔm chini kaŋ yi bəh kaka bi bəh bənsəŋ ka bə tɔkniki bəh wi. Bɔ kɔm yakadəiŋ wi təiŋyi bənsəŋ bəwɔ, ki chufi wi wi ka yɔkɔki tsəki i chwa. ");
INSERT INTO cug_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisɔs ka bikə i mi wiwɔ a, “Yɛli wa kɔ ndə?” Wi chukuli a, “Yɛli wuŋ kɔ mbaŋ.” Wi nì chukuli yakadəiŋ kɔm bəchinda bə ŋkpɛli nì kɔ bɔ chini i gwu yi wə. ");
INSERT INTO cug_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Bəchinda bəwɔ tsa a Jisɔs ma chîŋsi bɔ num i fəŋ kə ki shiki lə ŋɔɔɔŋ. ");
INSERT INTO cug_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A nì kɔ mbaŋ wi bifi dzi nnya i ŋgaŋni chɛiŋ, bəchinda bə ŋkpɛli bəwɔ ka tsa Jisɔs a wi bêe ma bɔ tsə liə num i bifi biwɔ mə. Wi bum. ");
INSERT INTO cug_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Bɔ ka buku i mi wiwɔ mə, daŋsi tsə liə i bifi biwɔ mə. Bɔ gbɔyi shi i fəŋ mə, liə shi i bɔkɔ yiwɔ wə, ka ləŋ. ");
INSERT INTO cug_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jɔbi wə bəni bə̀ bɔ nì tɔkniki bəh bifi biwɔ yɛiŋ gia yə yi num yakadəiŋ, dza fɛiŋ kɔmsi yɔkɔ tsə fuku gia yiwɔ i kwili kintəəŋ bəh i di biə fɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bəni wɔkɔ ka, bukuyi tsə i yɛiŋ tə gia yə yi num. Bɔ dzə i di biə Jisɔs nì kɔ, yɛiŋ mi wə bəchinda bə ŋkpɛli bə̀ nì buku i wi wə, num wi num kɔmsi i Jisɔs wə, bə lɔh bəmbuŋ i wi wə, num mfi bi fiəni dzə. Bɔ lwa bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bəni bə̀ bɔ nì yɛiŋ gia yə yi nì num, ka fuku i bɔ asi yi nì num, mi wə wi nì kaŋaki bəchinda bə ŋkpɛli si wi bɔnih. ");
INSERT INTO cug_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bəni bəchi bə̀ i bimbu bi Gɛlasen wə kaŋa nlwa, ka tsa Jisɔs a wi nyə̂ fɛiŋ wi tsə̂ki. Jisɔs ka nyə mfih, liə i ŋgwuki mə a ŋgaiŋ nyəki lə, ");
INSERT INTO cug_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","mi wə bəchinda bə ŋkpɛli nì buku i gwu yi mə ka tsaki Jisɔs a bɔ wi nyə̂. Jisɔs nəiŋma fiəni chiŋsi wi i jum wə, dzaka i wi a, ");
INSERT INTO cug_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tsə̂ mfia i wɔ dzu ma wɔ tsə̂ fûku gia yi dzaka ki wɔmni yə Nyɔ si fə i wɔ.” Ayaka, mi wiwɔ ka fiəni tsə ka nyaniki nnyaki i kwili wiwɔ wə kichi, fuku gia yi kaiŋni yə Jisɔs si fə i wi. ");
INSERT INTO cug_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisɔs nì fiəni daŋ chu i kiwuŋ ki bɔkɔ kəyaka wə. Mbaŋ wi bəni bə̀ bɔ ni kɔ bɔ si wɔkɔli wi fɛiŋ, dzɔ wi. ");
INSERT INTO cug_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nyuku widɔkɔ dzə fɛiŋ bə bɔɔŋ a Jaylus, num fwu i juŋ yi tsani wə fɛiŋ. Si wi dzə, ka tsə tum binyu i Jisɔs nshiŋ, kwuŋ kaŋ a wi dzə̂ i ŋgaiŋ dzu, ");
INSERT INTO cug_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","kɔm waiŋ wi ŋgaiŋ kɔ a dzaka ki kpi wə. Wi nì kaŋaki a waiŋ wikpaŋani shəŋ num a kaa a wi, wi num jía jwɔfi ntsɔ yifa. Bɔ Jisɔs nyə ka tsəki num mbaŋ wi bəni kwu faaŋni i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Miŋkpaŋa widɔkɔ nì kɔlə i kintəəŋ ki mbaŋ wi bəni bə̀ wə, num jɔbi wi shi baaŋ a baaŋni i jía wə jwɔfi ntsɔ yifa. Num wi nì bəkəli biɛiŋ bichi biə wi nì kaŋaki i jwɛiŋ yiwɔ wə, yi gaka bəni bə tsa bəchi i chuku. ");
INSERT INTO cug_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wi faaŋni liə tsə kɔm jəŋ wimbuŋ wi Jisɔs i jum wə, akisəkə jwɛiŋ yiwɔ kaa. ");
INSERT INTO cug_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisɔs bikə a, “A kɔm ndə mih a?” Bəni bəchi məŋni. Bita bikə a, “Tikwili wuŋ, tə wɔ yɛiŋ a mbaŋ wi bəni kwu faaŋni i wɔ wə a?” ");
INSERT INTO cug_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisɔs ka dzakaki a dzakani, “Mi widɔkɔ kɔm mih, mih wɔkɔ si ŋga buku i mih mə.” ");
INSERT INTO cug_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Si kpaŋa wiwɔ yɛiŋ a dzəh mɔŋ ka ŋgaiŋ nyumi, wi ka nyumyiki dzə gbɔ i Jisɔs nshiŋ. Ka fukuki bəni bəchi fɛiŋ wɔkɔ gia yə yi si fə ka wi kɔm Jisɔs, asi wi kɔm wi yakadəiŋ jwɛiŋ yiwɔ kaa akisəkə. ");
INSERT INTO cug_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisɔs dzaka i wi a, “Waiŋ wuŋ, shɔm ya yə wɔ jiə i mih wə, yi fə wɔ bɔiŋ. Ayaka wɔ tsə̂ bindzɔŋ.” ");
INSERT INTO cug_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Asi Jisɔs nì kɛiŋki wi dzaka i kpaŋa wiwɔ yakadəiŋ, mi widɔkɔ dzə fɛiŋ num wi nyə dzə i Jaylus dzu, tikwili wi juŋ yi tsani, ka dzaka i wi a, “Waiŋ wa kpi lɔ. Ma chu nyâ ŋgəkə i mi wi lanini.” ");
INSERT INTO cug_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Asi wi nì dzakaki yakadəiŋ, Jisɔs wɔkɔ, ka dzaka i Jaylus a, “Yi ma nyâ ŋgəkə i wɔ, jîə a shɔm ya i mih shəŋ, ma waiŋ wa ni bɔnih.” ");
INSERT INTO cug_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bɔ ka dza dzə i Jaylus dzu, wi nì ka bum a mi widɔkɔ liə yɛiŋ dzu. Wi bɔɔŋ a Bita, Jɛm, Jɔn, tii waiŋ bəh nih waiŋ bəh bɔ liə. ");
INSERT INTO cug_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","A nì kɔ bəni bəchi də, fii bəh mindəm, kɔm bə kpi yi waiŋ wiwɔ. Jisɔs dzaka i bɔ a, “Mbɛiŋ ki də̂ kə, waiŋ wələ ka kpi dəkə, wi nɔki lə.” ");
INSERT INTO cug_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bəni bəchi fɛiŋ dza ka suŋuki wi, kɔm bɔ ni kiəki na bindzɔŋ a waiŋ wiwɔ kɔ num wi kpi lɔ. ");
INSERT INTO cug_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wi tsə i di biə waiŋ wiwɔ nì nɔ, kaŋa wi i tsɛiŋ wə, bɔɔŋ wi a, “Waiŋkpaŋni, dzâ bɛiŋ!” ");
INSERT INTO cug_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wi ka fiəni dza wiwɔm, ka dza yaka bɛiŋ akisəkə. Jisɔs dzaka a bɔ tsɛ̂iŋ fiɛŋ ma wi dzî. ");
INSERT INTO cug_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nih wi bəh ba wi yɛiŋ gia yə yi num, dzaka wɔm bɔ. Jisɔs kîŋ a bɔ ma fûku i mi widɔkɔ gia yə yi num. ");
INSERT INTO cug_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisɔs ka dza bɔɔŋ bwa bu bə mbaŋ jwɔfi ntsɔ bəfa, bɔ juŋni dzə. Wi nya bɔ bəh ŋga bəh dzəh i bwîliki bəchinda bə ŋkpɛli i bəni wə bəh i chûkuki jwɛ́iŋ, ");
INSERT INTO cug_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ka faaŋ bɔ a bɔ tsə̂ fûkuki i bəni kɔm ŋkuŋ bi Nyɔ, bəh i chûku bəni bə jwɛ́iŋ. ");
INSERT INTO cug_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wi chu dzaka i bɔ a, “Si mbɛiŋ tsəki, kiə mi ki dzɔ̂ kə fiɛŋ. Kiə mi ki dzɔ̂ kə mbəŋ, nabə kiba, nabə fiɛŋ fidzini, nabə kpɔ. Kiə mi ki dzɔ̂ kə bəmbuŋ bəfa. ");
INSERT INTO cug_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mbɛiŋ ka ni tsə liə i kwili wə, juŋ yə bə jiə mbɛiŋ yɛiŋ, mbɛiŋ ka nɔ̂ki a yɛiŋ, i tsə̂ bûku i jɔbi wə mbɛiŋ bi dza nyə i kwili wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Kwili wiwɔ ka nəiŋ i dzɔ mbɛiŋ, mbɛiŋ bûku fɛiŋ, jɔbi wə mbɛiŋ nəŋki i buku fɛiŋ mbɛiŋ chûmyi kwɔŋɔ i gvu yimbɛiŋ wə, i num ka kinchəsi i gia yə bɔ mɔm.” ");
INSERT INTO cug_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Bɔ ka nyə ka tsəki, ka nyaniki i di di wə, fuku ntum wi ndzɔŋni wə kɔm ŋkuŋ bi Nyɔ, bɔ chuku bəni bə jwɛiŋ bəchi. ");
INSERT INTO cug_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ŋkuŋ Hɛlɔd wə wi nì sakaki kimbu ki tumi ki Galili, wɔkɔ gia yichi yə yi nì num, yi fumsi wi kɔm bəni bədɔkɔ nì dzakaki a Jisɔs wələ kɔ Jɔn Njulibɔkɔ si wi fiəni dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Bədɔkɔ dzaka a, akɔ Ɛlaja si wi fiəni dzə. Bədɔkɔ dzaka fibɔ a, akɔ mi wi ntum wi Nyɔ wi kikpu widɔkɔ wi fiəni dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hɛlɔd ka kaiŋyiki a, “Jɔn kɔ num mih nì gba bwili fwu wi. Wələ mi chu kɔ ndə mih wɔkɔki kələ kintəŋsi ki gia kɔm wi a?” Wi ka nəŋki a ŋgaiŋ bɔŋ yɛiŋ Jisɔs wiwɔ. ");
INSERT INTO cug_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Bwa bə ntum bə Jisɔs ni fiəni dzə, fuku gia yichi yə bɔ fə i wi. Wi ka dzɔ bɔ a bəh bɔ baka gwu, ka dzɔ dzəh yi kwili wi Besayda. ");
INSERT INTO cug_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ayakalə, mbaŋ wi bəni kiə yaka ka biəli wi, wi dzɔ bɔ yisi i fukuki kɔm ŋkuŋ bi Nyɔ chu chuku bəni bə̀ bɔ gwɛiŋki. ");
INSERT INTO cug_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Si jɔbi nì shiki tsəki i liə, bwa bə Jisɔs bə mbaŋ bə̀ jwɔfi ntsɔ bəfa, ka kɔmsi dzə i wi kpəŋ ka dzaka i wi a, “Dzâka i bəni bələ a bɔ tsə̂ i kikwili ki kɔmsini wə, i nə̂ŋ biɛiŋ bibɔ bidzini bəh di bibɔ bi nɔni, kɔm fa kɔ chwa.” ");
INSERT INTO cug_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ayakalə, Jisɔs chukuli n'yi a, “Mbɛiŋ mwi nyâ bɔ bəh fiɛŋ ma bɔ dzî.” Bɔ dzaka i wi a, “Fiɛŋ fiə buku kaŋaki kɔ a chɔkɔ yi blɛd yite bəh bwɔ́kɔ yifa shəŋ, yaka kɔ a wɔ nəŋki a buku tsə̂ tâŋ biɛiŋ bidzini taŋni i dzə̂ nyâ i bəni bələ bəchi a?” ");
INSERT INTO cug_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Bɔ nì dzakaki yaka kɔm bəni nì duki lə fɛiŋ bənyuku shəŋ nì kɔ ka bənchuku bəte. Jisɔs ka dzaka i bwa bu bə mbaŋ a, “Mbɛiŋ dzâka a bəni nûmyi i kuku i di di wə, mbaŋshi mbaŋshi.” ");
INSERT INTO cug_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Bɔ ka dzaka bɔ bəchi numyi kuku. ");
INSERT INTO cug_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisɔs dzɔ chɔkɔ yi blɛd yite bəh bwɔ́kɔ yifa yə, tsɛiŋ yaka bɛiŋ, nya kiyɔŋni i Nyɔ, ka gbɛyi nya i bwa bu bə mbaŋ a bɔ gâa i bəni bəwɔ. ");
INSERT INTO cug_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bɔ gaa, bəni bəchi dzi fwuli, bwa bə Jisɔs bə mbaŋ juŋni biŋka biə bi bɛsi, bi jikə káh jwɔfi ntsɔ yifa. ");
INSERT INTO cug_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A dzə num chɔkɔ bidɔkɔ, Jisɔs ka tsaki wi mbɔŋ, bwa bu bə mbaŋ num kɔmsi i wi wə. Wi dza bikə i bɔ a, “Bəni dzakaki a mih kɔ ndə?” ");
INSERT INTO cug_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Bɔ chukuli a, “Bəni bədɔkɔ dzakaki a wɔ kɔ Jɔn Njulibɔkɔ, bədɔkɔ a Ɛlaja, ayaka bədɔkɔ dzaka a wɔ kɔ mi wi ntum wi Nyɔ wi kikpu widɔkɔ wi fiəni dza i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jisɔs ka bikə i bɔ a, “Mbɛiŋ dzakaki yimbɛiŋ a mih kɔ ndə?” Bita chukuli a, “Wɔ kɔ Kimbwili wə Nyɔ nì kaka.” ");
INSERT INTO cug_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jisɔs ka lansi kiŋ i bɔ a kiə bɔ bi mɔ̂m kə i fûku yi i mi. ");
INSERT INTO cug_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Wi ka dzaka i bɔ a, “Mi wə yɛli wi kɔ Waiŋmi kaŋaki i bi yɛiŋ bəŋgəkə bəduli, ma bəni bə̀ bɔ sakaki tumi, bəh bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ bɔ bi məŋni wi. Bɔ wɔɔ wi, i kaŋ yitali wə, Nyɔ bi fiəni dzasi wi i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jisɔs ka dzaka num i bəni bəchi a, “Mi wə wi nəŋki i num mi wuŋ, wi kaŋaki i nəiŋ gwu yi, i giŋ kintasi ki chɔkɔ bichi i biəliki mih. ");
INSERT INTO cug_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mbɛiŋ kîəki a mi wə wi tɔkniki bə nɔni ki a wi ma laksi, wi bi laksi ki num laksini. Ayakalə, mi wə wi laksi nɔni ki kɔm mih, wi bi kwatiki lə ki. ");
INSERT INTO cug_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Bə ka juŋni na mbi wələ wichi ka nya i mi, a wi dzi, wi num i laksi nɔni ki, wi kɔbi i bi kwati ki, ma mbee wiwɔ bi numki nə a? ");
INSERT INTO cug_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mbɛiŋ kîə a mi wə wi gəmniki i biəli mih bəh gia yiŋ, wi kîə a mi wə yɛli wi kɔ Waiŋmi bi bɔŋ gəmni lə tə bəh wəmaka, i jɔbi wə wi bi fiəni dzəki i baiŋni bi wə, biə bi kɔ bi Ba wi, bə bəchinda bu bə baiŋni. ");
INSERT INTO cug_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mih fukuki ŋkɔŋ i mbɛiŋ a, bəni bədɔkɔ kɔlə fa bɔ kɔbi i bi musi kpi maka bɔ yɛiŋ si Nyɔ sakaki ntɔŋ bi.” ");
INSERT INTO cug_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","A bi dzə num aka kaŋa nyaŋ si Jisɔs nì dzaka gia yələ, wi dzɔ Bita bəh Jɔn bəh Jɛm bəh bɔ yaka tsə i ŋkwuŋ widɔkɔ wə i tsə tsa. ");
INSERT INTO cug_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Si wi nì tsaki, shi bi dza kwuni, bəmbuŋ bu tə kwuni ka fukuki alə buuu mwayi alə mwaŋmwaŋmwaŋ. ");
INSERT INTO cug_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yi dzə num a bəni bədɔkɔ bəfa nì kɔ fɛiŋ, a num Muses bəh Ɛlaja, bɔ nì təkəli tumbuku alə ka dzakaki bɔ bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Baiŋni bi Nyɔ baiŋ i bɔ wə. Ayaka bəh bɔ bə́ dzaka kɔm kpi yə Jisɔs ni kaŋaki i tsə kpi i Jɛlusalɛm, ayaka yi dzə kpɛiŋ si Nyɔ ni jiə. ");
INSERT INTO cug_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Si bɔ ni dzakaki yaka, Bita bəh Jɔn bəh Jɛm gɔkɔ kinu. Si bɔ dza yaka, ka yɛiŋ si baiŋni bi Nyɔ baiŋki i Jisɔs wə, bɔ yɛiŋ bəni bəfa bələ num bəh wi. ");
INSERT INTO cug_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Si bəni bəfa bələ ni fiəniki nyəki, Bita dza təkəli dzaka i Jisɔs a, “Tikwili, yi si ndzɔŋki lə a bukumbɛiŋ numki fa. Bêe ma buku maa bintaŋ bitali, kidɔkɔ numki ŋka, kidɔkɔ num ki Muses, kidɔkɔ num ki Ɛlaja.” Wi nì dzakaki yakadəiŋ wi kiə kə na gia yə wi dzakaki. ");
INSERT INTO cug_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Asi wi ni kɛiŋki wi dzaka yaka, bimba nyə dzə i bɔ bɛiŋ baŋ bɔ. Ndzaŋ kwa bɔ, si bɔ nì kɔ i yɛiŋ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ja buku i kintəəŋ kiwɔ wə dzaka a, “Wələ kɔ Waiŋ wuŋ wə mih kɔ mih babwili. Mbɛiŋ wɔ̂kɔki num i wi.” ");
INSERT INTO cug_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Si ja yiwɔ dzaka kaasi yaka, bɔ dza yɛiŋ Jisɔs num fɛiŋ a wi mbɔŋ. Ayaka bɔ kpi chumi bəh yi, i jɔbi wiwɔ bɔ nəki fuku kə i mi widɔkɔ gia yə bɔ yɛiŋ i ŋkwuŋ wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chɔkɔ buku wɔɔ, bɔ bəh Jisɔs nyə i ŋkwuŋ wiwɔ wə ka shiki dzəki, si bɔ ni shiki dzəki baŋsi bə mbaŋ wi bəni wimbum. ");
INSERT INTO cug_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","A bɔ tsɛiŋ yɛiŋ, bɔ yɛiŋ mi widɔkɔ i mbaŋ wiwɔ kintəəŋ wi dza ka yisi i wiliki a, “Mi wi lanini, mih tsaki wɔ a wɔ tsɛ̂iŋ i waiŋ wuŋ wələ, akɔ a wi shəŋ. ");
INSERT INTO cug_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wɔ̂kɔli, kiŋ'waka kidɔkɔ dzaki ki chufi wi, ki lɔɔ wi i kuku, wi ka jwɔki, jumi, bifuu buku i dzaka ki wə. Ki baaŋ tsə a bəh wi bum kə a wi waka. ");
INSERT INTO cug_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mih si tsa bwa ba bə mbaŋ bə̀ a bɔ bwîli kiŋ'waka kiwɔ bɔ mɔmsi mɔŋ.” ");
INSERT INTO cug_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisɔs wɔkɔ yaka, dzaka a, “Ɔ ɔɔ! Ŋgɔkɔ wi kilɔlɔ wələ wi ka jiə dəkə shɔm i Nyɔ wə. Mih kɔ ni num bukumbɛiŋ i tsə buku dəiŋ, mih ni kaŋa shɔm bəh mbɛiŋ i tsə buku dəiŋ na?” Wi ka dzaka i tii waiŋ wiwɔ a, “Dzə̂ bəh waiŋ wa fa.” ");
INSERT INTO cug_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Asi wi dzɔ wi ka dzəki, chinda wi ŋkpɛli wə chu chufi waiŋ wiwɔ tɔkɔ kuku, wi ka jwɔki. Jisɔs kaŋyi kiŋ'waka kichu kiwɔ ki buku i waiŋ wiwɔ wə, wi ka bɔnih. Jisɔs ka nya wi i ba wi. ");
INSERT INTO cug_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Bəni bəchi yɛiŋ ŋga biə bi kɔ bi Nyɔ, dzaka wɔm bɔ. Si bɔ nì kɛiŋki num bəh ŋkaŋyi i gia yichi yə Jisɔs nì fəki, wi dza dzaka i bwa bu bə mbaŋ wə a, ");
INSERT INTO cug_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mbɛiŋ lûmsi ndzɔŋ bintuni bimbɛiŋ i gia yə mih nəŋki i dzaka. Mi wə yɛli wi kɔ Waiŋmi bə ni nya lə wi i kaŋ yi bəni wə.” ");
INSERT INTO cug_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Si wi dzaka yakadəiŋ, bɔ nəki wɔkɔ kiə kə gia yə wi dzakaki, kɔm gia yiwɔ nì kɔ yi nyumi a bɔ ma kiə, ayakalə bɔ ka lwaki i bikə i wi kɔm ndzaka wiwɔ. ");
INSERT INTO cug_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bɔ ka yisi ŋgukuli a bɔ bɔ a mi wimbum wə wi tsəki bɔ bəchi i bɔ kintəəŋ kɔ ndə a. ");
INSERT INTO cug_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisɔs kîə gia yə bɔ kwakaki i shɔm yibɔ wə, ka dzɔ waiŋ wi nchiŋ tɔm kɔmsi i wi wə, ");
INSERT INTO cug_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","dzaka i bɔ a, “Mi wə wi ka dzɔ waiŋ winchiŋ wələ i yɛli wuŋ wə, wi dzɔ num mih. Mi wə wi dzɔ mih, wi dzɔ num mi wə wi faaŋ mih. Yi kɔ a, mi wə wi jiə gwu yi i kuku i mbɛiŋ kintəəŋ akɔ wi wə wi kɔ mi wimbum wi tsə mbɛiŋ bəchi.” ");
INSERT INTO cug_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jɔn chukuli i Jisɔs a, “Tikwili, buku si yɛiŋ mi widɔkɔ wi bwili bəchinda bə ŋkpɛli i bəni wə i yɛli wa wə, buku ka kaŋyi wi, kɔm wi kɔkə mi widɔkɔ i mbaŋ wibukumbɛiŋ wə ” ");
INSERT INTO cug_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisɔs chukuli mfih a, “Kiə mbɛiŋ ki chî kə wəmaka mi, kɔm mi wə wi ka nəiŋ dəkə mbɛiŋ, wi tɔbiki lə mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Si jɔbi nì kpɛiŋniki dzəki ka Nyɔ dzɔ Jisɔs i bɛiŋ, Jisɔs fasi i tsə i Jɛlusalɛm, wi ka nyə bə́ tsə. ");
INSERT INTO cug_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wi bə́ nəŋ i nyə ka faaŋ bəni bədɔkɔ i ninshiŋ. Bɔ tsə liə i kwili widɔkɔ wə i Samalia, i kɛiŋsi di fɛiŋ i wi. ");
INSERT INTO cug_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bəni bə̀ fɛiŋ nəiŋ i dzɔ wi kɔm bɔ nì kiəki lə a wi tsəki səki num i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jɛm bəh Jɔn num bwa bə Jisɔs bə mbaŋ wə fɛiŋ ka wɔkɔ gia yiwɔ, bikə i wi a, “Bah, buku bɔɔŋ gbuku i bɛiŋ ma wi shi dzə kaasi bəni bələ a?” ");
INSERT INTO cug_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisɔs chu fiəni gwu kaŋyi lɔ bɔ, ");
INSERT INTO cug_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","wi bəh bwa bu bə mbaŋ ka nyə ka tsəki səki dzəh i kwili widɔkɔ wə chi. ");
INSERT INTO cug_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Asi bɔ nì nyaniki dzəki i dzəh, mi widɔkɔ dzə dzaka i Jisɔs a, “Mih ni biəliki lə wɔ, i na faiŋ wə wɔ tsəki.” ");
INSERT INTO cug_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisɔs chukuli i wi a, “Migumasha kaŋaki lə dzə́ŋə yibɔ, minyəni mə mɔ fuliki bɛiŋ kaŋa júŋ yibɔ, ayakalə mi wə yɛli wi kɔ Waiŋmi kaŋaki kə na di i jiə fwu wi yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisɔs ka chu dzaka i mi widɔkɔ a, “Bîəli mih.” Ayaka mi wiwɔ chukuli a, “Bah, bêe ma mih tsə yisi ləə ba wuŋ, ka mih biəliki wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ayakalə, Jisɔs chukuli i wi a, “Bêe ma bəni bə̀ bɔ kpiyi, ləəki bəni bəbɔ bə kpiyini, tsə̂ mfia wɔ fûkuki kɔm ŋkuŋ bi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Mi widɔkɔ chu dzaka a, “Bah, mih ni biəliki lə wɔ, ayaka yisi bêe ma mih tsə bɔni i chwɔŋ kəŋŋ ki juŋ ka mih dzə biəliki wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisɔs chukuli i mi wiwɔ a, “Mi wə wi kwa dzəkə i kaŋ ŋguŋ shi kuku fiəni tsɛiŋ i jum wə, wəmaka ka kpɛiŋ dəkə i num i kintəəŋ ki ŋkuŋ bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","I jum wə fɛiŋ wə, Bah baayi bəni bədɔkɔ mbaŋnanitaŋ ntsɔ bəfa ka faaŋ i wi nshiŋ, bəfa bəfa a bɔ tsə̂ i kikwili kə, i nyani di biə wi nì kaŋaki i tsə i bi wə bichi. ");
INSERT INTO cug_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Wi bə́ nəŋ i faaŋ bɔ, ka dzaka a, “Ŋkɔh duki lə na bəh ŋga, ayakalə bəni bə kɔhni num a twɛsi. Mbɛiŋ tsâki a Bah wə wi kaŋaki khə wiwɔ chîŋsi bəni bə kɔhni. ");
INSERT INTO cug_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mbɛiŋ tsə̂ki la. Yɛ̂iŋ, mbɛiŋ kîəki a, mih faaŋki mbɛiŋ i tsə numki ka bwa bə shwáŋ i júm kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Si mbɛiŋ tsəki kiə mi ki dzɔ̂ kə kpɔ, nabə kiba bəh dzuyigvu yidɔkɔ. Jɔbi wə mbɛiŋ ka buku i dzəh, mbɛiŋ ma ni nûmki i bɔ̂niki i bəni. ");
INSERT INTO cug_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mbɛiŋ ka tsə liə i juŋ yə mbɛiŋ liə yɛiŋ wə, mbɛiŋ bɔ̂ni bəni bəwɔ yɛiŋ dzu a, ‘Kimbɔiŋni nûm ya dzu.’ ");
INSERT INTO cug_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","A kabə num mi wə wi kɔŋki a kimbɔiŋni num yɛiŋ dzu, ma kimbɔiŋni kiwɔ baaŋ i gwu yi wə. Wə wi kɔŋki kə kimbɔiŋni kiwɔ ki fiəni chu jum wə i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jɔbi wə mbɛiŋ ka liə i dzu, mbɛiŋ ka nɔ̂ki a yɛiŋ dzu, mbɛiŋ ma kwuniki júŋ. Mbɛiŋ dzîki, mbɛiŋ mû biɛiŋ bichi biə bə nya i mbɛiŋ, kɔm mi wi nɔm kaŋaki lə i kwati ŋgɔm wi. ");
INSERT INTO cug_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jɔbi wə mbɛiŋ ka tsə liə i kwili wiwɔ, bə dzɔ mbɛiŋ, mbɛiŋ dzî na finə bə nya i mbɛiŋ i dzî. ");
INSERT INTO cug_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jɔbi wə mbɛiŋ ka numki fɛiŋ mbɛiŋ ka chûkuki bəni bə jwɛiŋ, fiəni fûku i bəni bəchi a ŋkuŋ bi Nyɔ si kɔmsi dzə i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ayakalə, na yibwiŋ mbɛiŋ liə i kwili wiwɔ, bə nəiŋ i dzɔ mbɛiŋ, mbɛiŋ bûku tsə̂ i dzə́h wə mbɛiŋ dzaka a, ");
INSERT INTO cug_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kwɔŋɔ kikwili kimbɛiŋ kələ buku dzɔ i gvu yibuku wə bə bi lə buku chumni, gia yichi fiəni dzə i kifwu kimbɛiŋ wə. Ayakalə, mbɛiŋ kîə a ŋkuŋ bi Nyɔ kɔ bi si num a fiəŋə.’ ");
INSERT INTO cug_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mih fukuki i mbɛiŋ a, a bi numki i chɔkɔ bi nsaka wi gɔksini wə, gia bi bɔniki lə i kwili wi Sɔdɔm wə, tsə kwili wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wi nì shaaŋki yakadəiŋ dzakayi a, “Ŋgəkə wimbum i mbɛiŋ bəni bə Kɔlasen, ŋgəkə wimbum kɔ tə wimbɛiŋ bəni bə Besayda. Mbɛiŋ kîə a, gia yi dzaka ki wɔmni yə mih nì dzə fə i kidi kimbɛiŋ wə, a nì kɔ a mih fə yi i Taya bəh Sidɔn, ma bɔ nì fiəni i chu bibɔ wə ka lɔh bəmbuŋ bə kpi, fuku kibwuŋ i gwu wə jiakɔbi, i kɔmsi chusi a bɔ kwuni lɔ shɔ́m yibɔ. ");
INSERT INTO cug_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mbɛiŋ kîəki a, a bi numki i chɔkɔ bi nsaka wi gɔksini wə, gia bi bɔniki lə i bəni bə Taya bəh Sidɔn tsə yimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ayaka mbɛiŋ bəni bə Kafanaum, mbɛiŋ kwakaki a, bə bi yaksiki lə mbɛiŋ i bɛiŋ a? Aayi. Bə bi shisi mbɛiŋ shisini i tumi ki bəni bə kpili wə.” ");
INSERT INTO cug_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisɔs ka dzaka i bəni bə̀ wi nì faaŋ a, “Mi wə wi wɔkɔ i mbɛiŋ, wi wɔkɔ num i mih. Mi wə wi məŋni mbɛiŋ, wi məŋni num mih. Ayaka wi wə wi məŋni mih, wi məŋni num wə wi faaŋ mih.” ");
INSERT INTO cug_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Bəni bə̀ mbaŋnanitaŋ ntsɔ bəfa ka fiəni dzə wɔkɔ ndzɔŋni, ka dzaka i Jisɔs a, “Bah, buku si bɔɔŋki yɛli wa, na bəchinda bə ŋkpɛli, wɔkɔ i buku.” ");
INSERT INTO cug_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisɔs chukuli i bɔ a, “Mih ni yɛiŋ Satan gbɔ i bɛiŋ aka dzaŋ yi mwaŋ i bɛiŋ liə kuku. ");
INSERT INTO cug_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mbɛiŋ wɔ̂kɔli, mih nyâ lɔ ŋga i mbɛiŋ, biə mbɛiŋ kɔ i nyaniki i júŋ bɛiŋ bəh i nyɛiŋ bɛiŋ. Ayaka num mih chu nyâ ŋga bichi i mbɛiŋ i tumdzi Satan wə mbaiŋŋni wimbɛiŋ, ayaka fiɛŋ fidɔkɔ kɔbi bi nəŋni mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ayakalə, mbɛiŋ ma wɔkɔki ndzɔŋni a bəchinda bə ŋkpɛli wɔkɔki lə i mbɛiŋ. Mbɛiŋ wɔ̂kɔki ndzɔŋni a num a kiyɛli kimbɛiŋ kɔ num Nyɔ nyaka lɔ i kiŋwakti wə i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","A jɔbi wiwɔ wə, Kiŋ'waka ki Baiŋni fə Jisɔs wɔkɔ ndzɔŋni. Wi ka dzaka a, “Mih nyaki kiyɔŋni i wɔ Ba wuŋ Ŋkuŋ wi bɔɔli bəh nshwaiŋ kɔm wɔ nyumi gia yələ i bəmfi, bəh bəŋkiəgia, chusi yi num i bəni bə kilɔlɔ bəh i bwa bənchiŋ. Yi num yakadəiŋ Ba wuŋ, kɔm akɔ ayaka si wɔ nì kɔŋki a yi numki.” ");
INSERT INTO cug_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jisɔs chu dzaka a, “Ba wuŋ kɔ wi nya lɔ biɛiŋ bichi i mih. Mi widɔkɔ kɔkə wə wi kiəki Waiŋ Nyɔ, a kɔbi a Ba wi. Ayaka mi widɔkɔ num kə wə wi kiəki Ba wuŋ, a kɔbi a Waiŋ bəh bəni bə̀ Waiŋmi kɔ wi sabibwili i chusi Ba wi i bɔ.” ");
INSERT INTO cug_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wi dza fiəni gwu dzaka i bwa bu bə mbaŋ a bɔ bɔ a, “Kimbɔiŋsi kimbum kɔ kimbɛiŋ a dzə́kəh yimbɛiŋ yɛiŋ gia yiwɔ. ");
INSERT INTO cug_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mbɛiŋ kîəki a bəni bə ntum bə Nyɔ bəduli bəh bəŋkuŋ nì dəki i yɛiŋ gia yə mbɛiŋ yɛiŋki, kɔbi i yɛiŋ. Ka nəŋki tə i wɔkɔ gia yə mbɛiŋ wɔkɔki, kɔbi i wɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yi dzə num a, mi widɔkɔ wə wi nì lansi kiəki bənchi bə Nyɔ, nyə dzə i mɔmsi Jisɔs, ka bikə i wi a, “Mi wi lanini, gia yə mih kaŋaki i fə ka mih kwati nɔni kə ki bi tsə kaa kə, kɔ nə a?” ");
INSERT INTO cug_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisɔs bikə i wi a, “Bə nyaka i Kiŋwakti ki Bənchi bə Nyɔ wə a nə? Wɔ si fa wɔkɔ a nə?” ");
INSERT INTO cug_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wi chukuli a, “Bə nyaka a, ‘Wɔ kɔ̂ŋki Bah Nyɔ wa bəh shɔm ya yichi, wɔ nyâ gwu ya yichi i wi, wɔ nɔ̂mki i wi bəh ŋga bia bichi, wɔ jîə mfi bia bichi i wi wə, wɔ kɔ̂ŋki mi wə wi kɔ kɔmsi i wɔ kpəŋ asi wɔ kɔŋki gwu ya.’” ");
INSERT INTO cug_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisɔs ka dzaka a, “Wɔ chukuli ndzɔŋ. Wɔ fə a yakadəiŋ ma wɔ bi kwati nɔni kə ki bi tsə kaa kə.” ");
INSERT INTO cug_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mi wiwɔ dza ka nəŋki i chusi a ŋgaiŋ kɔ mi, ka bikə i Jisɔs a, “Mi wə wi kɔ kɔmsi i mi kpəŋ kɔ ndə a?” ");
INSERT INTO cug_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisɔs chukuli lɔ bəh ndi a, “Mi widɔkɔ nì buku i Jɛlusalɛm kabə shi tsə i Jɛliku, i dzə wi liə i kaŋ yi bəji wə. Bɔ twɛiŋ wi, wi baaŋ a twɛsi i kpi, bɔ baayi bəmbuŋ bu, dzɔ tasi bəh biɛiŋ bi bichi, ka bee wi fɛiŋ ka gɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yi dzə num a, mi widɔkɔ ni shiki tsəki i dzəh yiwɔ wə num tii mfə gia, wi yɛiŋ wi ka kwaŋ tsə i fikpəŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mi widɔkɔ tə ka nyə ka dzəki, num mi i chwɔŋkijuŋ ki Lɛwi wə, ka dzə buku fɛiŋ, yɛiŋ wi ka bɔŋ kwaŋ tsə tə a fikpəŋ. ");
INSERT INTO cug_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ayakalə, mi widɔkɔ bə́ nyani dzə a num mi wi Samalia. Wi dzə buku fɛiŋ, ka yɛiŋ wi, nshɛiŋ kwa wi. ");
INSERT INTO cug_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Wi tsə buku i wi wə, jiə mbih bəh miə i biəkə yi wə, kaŋa baŋ biəkə yiwɔ bəh mbuŋ, ka giŋ wi i nyam yi yə wi nì nyaniki i yɛiŋ bɛiŋ, ka tsə bəh wi i juŋ yi bəni bə dzəni wə ka bə́ tɔkniki bəh wi. ");
INSERT INTO cug_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Bɔ wi nɔ, chɔkɔ buku wɔɔ, wi bwili bədanali bəfa nya i mi wi juŋ yiwɔ, ka dzaka i wi a, ‘Bâaŋ wɔ tɔ̂kniki bəh mi wələ. Wɔ ka baaŋ ka bəkəli kpɔ wi dutsə, mih ni fiəni dzə nya chukuli i wɔ.’” ");
INSERT INTO cug_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Si Jisɔs ti yakadəiŋ, ka bikə i mi wə wi nì kɛiŋsi kiəki bənchi a, “I bəni bətali bələ kintəəŋ, wɔ yɛiŋki n'ya a mi wə wi nì chusi, a wi kɔ waiŋnih mi wə bəji bə̀ nì twɛiŋ akɔ winaiŋ na?” ");
INSERT INTO cug_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wi chukuli a, “Akɔ mi wə wi nì kwasi nshɛiŋ i mi wə bəji bə̀ nì twɛiŋ.” Jisɔs ka dzaka i wi a, “Tsə, wɔ fəki ayaka tə.” ");
INSERT INTO cug_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisɔs bəh bwa bu bə mbaŋ ka nyə ka tsəki, tsə liə i kwili widɔkɔ wə, kpaŋa widɔkɔ num fɛiŋ bə bɔɔŋ a Mata. Wi dzɔ Jisɔs i wi dzu. ");
INSERT INTO cug_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wi nì kaŋaki lə waiŋnih wi widɔkɔ bə bɔɔŋ a Meli. Si Jisɔs nì tsə liə fɛiŋ, Meli ka tsə num kɔmsi i wi kpəŋ bə́ wɔkɔliki gia yə wi laniki. ");
INSERT INTO cug_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mata fum fɔbli bəh ntati. Wi nyə tsə ka bikə i Jisɔs a, “Bah, wɔ yɛiŋ a waiŋnih wuŋ kɔ fa bəh wɔ, mih fum a mih mbɔŋ, wɔ kaŋa kə jɔbi ndzɔ nə? Dzâka a wi dzə̂ gâmti mih.” ");
INSERT INTO cug_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bah chukuli i wi a, “Mata, Mata, wɔ fumsiki gwu ya, wɔ wɔkɔ ŋgəkə kɔm biɛiŋ bi duli, fwu wa bɔkɔ kilɔlɔ, ");
INSERT INTO cug_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","fiɛŋ fiə bə nəŋki kɔ a fimu. Meli nûm wi sabibwili lɔ fiəmaka, a num findzɔŋni, fiə mi widɔkɔ kɔbi i bi chu dzɔbwili i wi.” ");
INSERT INTO cug_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A nì kɔ chɔkɔ bidɔkɔ, Jisɔs ka tsaki i di bidɔkɔ wə, wi tsa kaasi, waiŋ wi widɔkɔ i mbaŋ wi bwa bu kintəəŋ dzə dzaka i wi a, “Bah, lâni buku si buku kɔ i tsaki, asi Jɔn nì lani bəni bu bə mbaŋ si bɔ kɔ i tsaki.” ");
INSERT INTO cug_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisɔs ka dzaka i bɔ a, “Mbɛiŋ bə́ tsa mbɛiŋ ka dzâkaki a, ‘Ba wibuku, fə̂ bəni kɔksiki yɛli wa, fə̂ ma ŋkuŋ bia dzə. ");
INSERT INTO cug_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nyâ buku bəh dzɛiŋ bidaiŋ, ");
INSERT INTO cug_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma wɔ dâlinya chu bibuku, asi buku dalinyaki chu biə bəni bədɔkɔ fəki i buku. Kiə wɔ ki bêe kə a buku liə i mɔmsi wə.’” ");
INSERT INTO cug_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Si wi dzaka yaka ka fəkəni i bɔ a, “Mbɛiŋ dzɔ̂ a, mi widɔkɔ i mbɛiŋ si nyə tsə kɔmyi juŋ yi nsɛiŋ wi nchɔkɔ kintəəŋ dzaka i wi a, ‘Nsɛiŋ wuŋ, dzâ bɛiŋ wɔ fwâsi mih bəh chuku yi nyə yitali. ");
INSERT INTO cug_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nsɛiŋ wuŋ widɔkɔ dzə tumbuku alə, mih kaŋa kə fiɛŋ fiə mih kɔ i tati wi yɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bə dzɔ a nsɛiŋ wa wə wɔ si kɔmyiki dzaka ki kifiəŋə, ka fiəni chukuli dzə mfih i dzu a, ‘Ma nyâki mih bəh ŋgəkə. Buku bwa bəŋ kɔ buku nɔ lɔ ka fa dzaka ki juŋ. Mih kɔkə i dza bɛiŋ a mih nəŋki fiɛŋ i nya wɔ.’” ");
INSERT INTO cug_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Si Jisɔs fəkəni yaka, chu dzaka a, “Mih fukuki i mbɛiŋ a, namana yaka wi ka baaŋ i dza nya wɔ bəh nyəə kɔm wɔ kɔ nsɛiŋ wi, wi ni dza bɛiŋ ma wi nya biɛiŋ bichi biə wɔ nəŋki i jɔbi wə wɔ baaŋ a fɛiŋ ka kɔmyiki wɔ bɔh kə. ");
INSERT INTO cug_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ayakadəiŋ, mih fukuki i mbɛiŋ a, mbɛiŋ bîkəki, ma Nyɔ ni nya i mbɛiŋ. Mbɛiŋ nə̂ŋki, ma Nyɔ ni fə mbɛiŋ yɛiŋ. Mbɛiŋ kɔ̂myiki dzaka ki juŋ, ma Nyɔ ni wɛli i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mbɛiŋ kîəki a mi wichi wə wi bikəki, wi ni kwati lə, mi wichi wə wi nəŋki, ni yɛiŋ lə, wə wi kɔmyiki bakakijuŋ bə ni wɛli lə i wi. ");
INSERT INTO cug_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Akɔ tii waiŋ winaiŋ i mbɛiŋ kintəəŋ wə waiŋ wi ka bikə bwɔkɔ, wi ni nya num juŋŋ i wi a? ");
INSERT INTO cug_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma waiŋ ka bikə ŋgəəŋ, wi ni nya num nyɛiŋ i wi a? ");
INSERT INTO cug_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Na yaka mbɛiŋ bə̀ mbɛiŋ kɔ bəni bəchu ka kiəki i nya biɛiŋ bindzɔŋni i bwa bəmbɛiŋ, ma Ba wimbɛiŋ wə wi kɔ i bɛiŋ wi ma ni nya tə Kiŋ'waka ki Baiŋni i bəni bə̀ bɔ bikəki i wi tsə yaka?” ");
INSERT INTO cug_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jisɔs nì bwiliki chinda wi ŋkpɛli i mi widɔkɔ wə wi num kinchini. Si chinda wi ŋkpɛli wiwɔ nì buku i mi wiwɔ mə, wi ka yisi i dzakaki. Mbaŋ wi bəni yɛiŋ yaka dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ayakalə, bəni bədɔkɔ ka dzakaki a, “Wi bwiliki bəchinda bə ŋkpɛli num bəh ŋga bi Bɛlsebu wə ŋkuŋ wi bəchinda bə ŋkpɛli.” ");
INSERT INTO cug_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Bəni bədɔkɔ ka nəŋki i mɔmsi wi, ka dzakaki a, wi fə̂ gia yə yi chusiki ŋga biə bi nyə i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisɔs kiə kiŋkwaka kibɔ, wi ka dzaka a, “Na kinaiŋ tumi kə ki gaali gwu ka jwɔki a kiki, ki kɔkə i bi num, chwɔŋkijuŋ kə ki gaali gwu ka jwɔki a bɔ bɔ ki gaali lɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Yi kɔ a liŋ asi Satan bəh mbaŋ wi ka gaali gwu bə jwɔ a bɔ bɔ, ma ŋkuŋ bi ni num dəiŋ a? Mih dzaka lə kɔm mbɛiŋ dzakaki a, mih bwiliki bəchinda bə ŋkpɛli num bəh ŋga bi Bɛlsebu. ");
INSERT INTO cug_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A kabə num a mih bwiliki bəchinda bə ŋkpɛli num bəh ŋga bi Bɛlsebu, ma bwa bəmbɛiŋ ni bwiliki num bəh ŋga bi ndə? Gia yə bwa bəmbɛiŋ bədɔkɔ fəki ni chusiki a, mbɛiŋ gbɔ lɔ nsaka. ");
INSERT INTO cug_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ayakalə, a kabə num a mih bwiliki bəchinda bə ŋkpɛli bəh kaŋ yi Nyɔ, yi numki a ŋkuŋ bi Nyɔ dzə lɔ i mbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Mbɛiŋ kîə a, jɔbi wə mi wi ləkəli ka kɛiŋsi gwu yi bəh biɛiŋ bi jum ka num bə́ tsɛiŋ na finaiŋ fiɛŋ, wi ni chu lwaki kə fiɛŋ fidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ayakalə, mi wi ŋga widɔkɔ ka tsə dzəh, jwɔ tsə wi bəh ŋga, lɔkɔ biɛiŋ bi bi jum biə wi si jiəki fwu wi yɛiŋ wə, wi lɔkɔ biɛiŋ bi bichi wi tsə gaa bəh bəni . ");
INSERT INTO cug_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mbɛiŋ kîə a, mi wə wi kɔkə bəh mih, wəmaka bwaŋki lə gvu i mih chɛiŋ. Mi wə wi gamtiki kə mih i juŋniki, wi shakyiki num shakyini. ");
INSERT INTO cug_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jɔbi wə kiŋ'waka kichu si buku i mi wə ki tsə i chwa i nəŋki di biə ki ni nɔki. Jɔbi wə ki ka nəŋ mɔŋ ki ni dzaka i gwu yi a, ‘Mih kaŋaki i fiəni tsə i mih dzu, i di biə mih ni buku.’ ");
INSERT INTO cug_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jɔbi wə ki fiəni dzə yɛiŋ juŋ yiwɔ kɛiŋ yiyəə, num bə yaŋa kɛiŋsi yi ka yi baiŋki, ");
INSERT INTO cug_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ki ka fiəni dzə bəh biŋ'waka bidɔkɔ nanitaŋ bi bəkə tsə wi, bɔ ka ni liə i nɔki yɛiŋ. Ayaka nɔni ki wəmaka mi ni fiəni bəkə tsə si ki nì kɔ i ninshiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Asi Jisɔs nì kɛiŋki wi dzaka gia yiwɔ lə, kpaŋa widɔkɔ təkəli dzaka i mbaŋ wi bəni kintəəŋ a, “Kimbɔiŋsi kimbum kɔ i miŋkpaŋa wə wi nì bwɔ wɔ, na bəh mbɛiŋŋ wə wɔ nì mah.” ");
INSERT INTO cug_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ayakalə, Jisɔs chukuli a, “Kimbɔiŋsi kimbum kɔ num i bəni bə̀ bɔ wɔkɔ gia yi Nyɔ fə asi yi nəŋki.” ");
INSERT INTO cug_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Si mbaŋ wi bəni ni juŋniki dzəki kɔmsi tsə i wi wə, wi ka dza dzaka a, “Chwɔŋkijuŋ ki liə kələ kɔ kichu. Bɔ nəŋki i yɛiŋ gia yi dzaka ki wɔmni, yə yi chusiki ŋga biŋ, ayakalə bɔ bi yɛiŋ kə gia yi dzaka ki wɔmni yidɔkɔ a kɔbi a yə mi ntum wi Nyɔ wə Jɔna nì chusi. ");
INSERT INTO cug_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gia yə Jɔna nì fə, a nì kɔ gia yi dzaka ki wɔmni i bəni bə Ninewi wə, yi kɔ a liŋ asi mi wə yɛli wi kɔ Waiŋmi bi fə gia yi dzaka ki wɔmni i ŋgɔkɔ wi liə wələ. ");
INSERT INTO cug_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","A bi numki chɔkɔ bi nsaka wi kaasini wə, Yaa wə wi nì sakaki tumi ki Shɛba bi numki lə tə bəh ŋgɔkɔ wi liə wələ, fə bɔ liə i ŋgəkə wə, kɔm wi nì dza dzə i tumi ki kiŋgɔksi ki mbi wə, i wɔkɔ mfi bi Ŋkuŋ Sɔlɔmɔn. Ayakalə, mbɛiŋ wɔ̂kɔli, mi widɔkɔ kɔlə fa bəh gia yimbum yi tsə yi Sɔlɔmɔn. ");
INSERT INTO cug_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","A bi numki i jɔbi bi nsaka wi gɔksini wə, bəni bə Ninewi bi num bəh ŋgɔkɔ wi liə wələ fə bə jiə wi i ŋgəkə wə, kɔm bɔ nì wɔkɔ gia yə Jɔna nì fukuki, kwuni shɔm yibɔ. Mbɛiŋ wɔ̂kɔli mi widɔkɔ kɔlə fa bəh gia yimbum yi tsə yi Jɔna, mbɛiŋ kwuni kə shɔ́m yimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mi si baiŋsi kə naka ki baiŋsini i ləkə i kigasi. Wi mɔŋ dəkə tə i chu fiəni dzɔ kah i kwusi baŋ yɛiŋ bɛiŋ. Wi si baiŋsi tɔm num i di biə bə si tɔm naka ki baiŋsini yɛiŋ, a bəni ka liə dzu bɔ yɛiŋki baiŋni biwɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dzəkəh ya kɔ baiŋni i gwu ya wə. Dzəkəh ya kabə baiŋ, yaka gwu ya yichi ni numki yi jikə bəh baiŋni. Ayaka, dzəkəh ya ka baiŋki kə, gwu ya yichi ni numki yi jikə bəh jisi. ");
INSERT INTO cug_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yi kɔ a, mbɛiŋ tɔkniki a baiŋni biə i gwu yimbɛiŋ wə ma fiəni chu jisi. ");
INSERT INTO cug_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Gwu ya yichi ka num yi jikə bəh baiŋni, kimbu kidɔkɔ num kə i jisi wə, biɛiŋ bichi ka baiŋki asi naka ki baiŋsiki si nya baiŋni i gwu ya wə.” ");
INSERT INTO cug_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisɔs nì kaasi ndzaka wi, mi wi Falasi widɔkɔ ka bɔɔŋ wi a wi dzə bɔ wi tsə dzi. Jisɔs ka tsə liə, num bɔ wi ka dziki, ");
INSERT INTO cug_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","num ma wi yisi wɔkɔ kaŋ yi. Mi wi Falasi wə tsɛiŋ yi gaka wi. ");
INSERT INTO cug_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bah kiə gia yə wi kwakaki, ka dzaka i wi a, “Mbɛiŋ Bəfalasi wɔkɔki kibwam bəh bətasa a i jum yiwɔ wə, ayakalə gia yichu bəh dzə́kəh yi bukuni jikə i shɔm yimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Biyuŋ biələ! Nyɔ wə wi nì maa biŋ kɔkə a wə wi ni maa kintəəŋ a? ");
INSERT INTO cug_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mbɛiŋ nyaki biɛiŋ biə bi kɔ i bətasa wə bəh kibwam kimbɛiŋ wə i bəni bə kifuu, ka biɛiŋ bichi ni baiŋki i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ŋgəkə wimbum kɔ wimbɛiŋ Bəfalasi. Mbɛiŋ nyaki lə i Nyɔ kimbu kimu i jwɔfi kintəəŋ i nəŋŋ biə mbɛiŋ kəkəki bəh biɛiŋ biə mbɛiŋ jiəki i jwa wə a yi fuliki, ayakalə mbɛiŋ bee lɔ i fəki gia yi chəŋ i bəni bəh i kaŋaki kiŋkɔŋ i Nyɔ. Mbɛiŋ kâŋaki i fə̂ki gia yiwɔ yichi bêe kə yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ŋgəkə wimbum kɔ wimbɛiŋ Bəfalasi. Mbɛiŋ si kɔŋ a numki i biŋgbɔkɔ bi ninshiŋ i júŋ yi tsani wə, chu kɔŋ a bə bɔniki mbɛiŋ i di bi shi wə bəh kiŋkɔksi. ");
INSERT INTO cug_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ŋgəkə wimbum kɔ wimbɛiŋ, kɔm mbɛiŋ kɔ ka júm yə yi chusiki kə, bəni nyani yɛiŋ bɛiŋ kiə kə.” ");
INSERT INTO cug_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Si Jisɔs nì dzaka yaka, mi widɔkɔ wi kɛiŋsiki kiəki bənchi bə Nyɔ, dzaka i wi a, “Mi wi lanini, wɔ kiəki a gia yə wɔ dzakaki lə a yi kɔmki lə buku tə a?” ");
INSERT INTO cug_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisɔs chukuli a, “Ŋgəkə wimbum kɔ tə wimbɛiŋ mbɛiŋ bəni bə̀ mbɛiŋ kɛiŋsiki kiəki bənchi bə Nyɔ. Mbɛiŋ jikəliki bəni bəh ntiə wi tsə ŋga bibɔ ka mbɛiŋ kɔlə i jiə na waiŋkpaŋ i gamti bɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ŋgəkə wimbum kɔ wimbɛiŋ. Mbɛiŋ maaki júm yi bəni bə ntum bə Nyɔ bə̀ bətii tii bəmbɛiŋ nì wɔɔyi. ");
INSERT INTO cug_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ayakadəiŋ, yələ chusiki a mbɛiŋ tɔksiki tɔbiki lə mfə wi bətii tii bəmbɛiŋ. Bɔ nì kɔ bɔ wɔɔyi bəni bə ntum bə Nyɔ, mbɛiŋ ka baaŋ ka sisiki i maa júm yibɔ. ");
INSERT INTO cug_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Akɔ gia yə yi nì fə ka Nyɔ bəh mfi bi dzaka a, ‘Mih ni chiŋsi lə bəni bəŋ bə ntum bəh bwa bəŋ bə ntum i bɔ, bɔ ni wɔɔyi bədɔkɔ bwaŋ gvu i bədɔkɔ chɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ayakadəiŋ, Nyɔ bi bikə i ŋgɔkɔ wi liə wələ kɔm mwa mi bəni bu bə ntum bəchi bə̀ bɔ nì wɔɔyi i yisi si mbi nì yisi. ");
INSERT INTO cug_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wi bi bikə i yisi i mwa mi Abɛl i tsə buku i mi Sakalia wə bɔ nì wɔɔ i kintəəŋ ki tɔŋ wi fəni gia bəh juŋ yi fəni yi gia wə. Mih fukuki ŋkɔŋ i mbɛiŋ a Nyɔ bi bikə lə i ŋgɔkɔ wi liə wələ, kɔm kpi yi bəni bəwɔ bəchi. ");
INSERT INTO cug_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ŋgəkə wimbum kɔ wimbɛiŋ bəni bə̀ bɔ kɛiŋsiki kiəki bənchi bə Nyɔ. Mbɛiŋ nyumi kiŋwɛli kə bə wɛliki bakakijuŋ kə mi liəki yɛiŋ i kiə gia yə yi kɔ chəŋ. Mbɛiŋ nəiŋ i liə, ka chu kəŋki bəni bə̀ bɔ nəŋki i liə a bɔ ma lîə.” ");
INSERT INTO cug_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisɔs ka bi dza fɛiŋ a ŋgaiŋ nyə wə, Bəfalasi bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ yisi ka lɔyiki wi bəh ja, bikə gia i wi yiduli yiduli, ");
INSERT INTO cug_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bɔ ni fəki yaka bɔ taaŋ wi, i kwa wi i gia yə wi ki dzaki. ");
INSERT INTO cug_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Si Jisɔs nì dzakaki, mbaŋ wi bəni ka juŋniki dzəki fɛiŋ, i bənchuku, bənchuku wə faaŋni. Bədɔkɔ dəiŋyi gvu yi bədɔkɔ. Jisɔs dza yisi i dzakaki num i bwa bu bə mbaŋ wə a, “Mbɛiŋ dzɔ̂ki jɔbi i dzɔɔŋ yi Bəfalasi, yə akɔ mfə wibɔ, bɔ dzakaki chi, fə chi. ");
INSERT INTO cug_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mbɛiŋ kîəki a, gia yidɔkɔ kɔkə yə bə baŋ, a yi bi baaŋ maka yi buku i baiŋni wə. Gia yidɔkɔ kɔbi yə bə nyumi a yi bi baaŋ maka bə kiə. ");
INSERT INTO cug_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mbɛiŋ kiə a gia yichi yə mbɛiŋ dzakaki nchɔkɔ, bə bi wɔkɔki lə nshi. Gia yichi yə mbɛiŋ si baŋ juŋ, ka mbɛiŋ chumyiki dzakaki, bə bi lakaki yi num i kifwu ki juŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Nsɛ́iŋ yiŋ, mih nəŋki i fuku i mbɛiŋ a, mbɛiŋ ma lwâki bəni bə̀ bɔ kɔ i wɔɔ a nyam yi gwu shəŋ, i yəmaka chɛiŋ bɔ nəki kaŋa kə gia yidɔkɔ i fə. ");
INSERT INTO cug_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mbɛiŋ wɔ̂kɔ mi wə mbɛiŋ kɔ i lwâki. Mbɛiŋ lwâki num Nyɔ kɔm akɔ wi wə wi kaŋaki ŋga i wɔɔ mi, chu num i ləkə wəmaka i gbuku wimbum wə. Mih chu fuku ŋkɔŋ i mbɛiŋ a, mbɛiŋ lwâki num wi. ");
INSERT INTO cug_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ntə mbɛiŋ kiəki lə a bə si taŋni minsii mite i minini mifa shəŋ a? Ayakalə, fidɔkɔ num kə fimu fiə Nyɔ kɔ wi dali fi. ");
INSERT INTO cug_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mbɛiŋ kɔ Nyɔ kiə na júŋ yimbɛiŋ yifwu yichi, yə yi kɔ i mbɛiŋ fuŋ. Mbɛiŋ ma lwâki. Mbɛiŋ tsəki lə minsii miduli. ");
INSERT INTO cug_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mih chu fukuki i mbɛiŋ a, na ndə wə wi bum mih i bəni nshiŋ, a wi kiəki lə mih, ma mi wə yɛli wi kɔ Waiŋmi bi bum lə tə wəmaka i bəchinda bə Nyɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ayakalə, mi wə wi nəiŋ mih i bəni nshiŋ, mih bi nəiŋ lə tə wəmaka i bəchinda bə Nyɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yi chu num a, Nyɔ bi dalinya lə já yichu yə mi dzakaki kɔm mi wə yɛli wi kɔ Waiŋmi, ayakalə Nyɔ bi lansi dalinya kə já yichu yə mi dzakaki kɔm Kiŋ'waka ki Baiŋni. ");
INSERT INTO cug_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Jɔbi wə bɔ bi kwa mbɛiŋ i tsə bəh mbɛiŋ i juŋ yi tsani wə, yuwidɔkɔ, i bəni bə̀ bɔ sakaki tumi nshiŋ, yuwidɔkɔ i bəni bə̀ bɔ kaŋaki ŋga bi sakani, a bɔ tsə saka mbɛiŋ, fwu ma bi bɔ̂kɔ mbɛiŋ a mbɛiŋ ni tsə baŋyiki gwu yimbɛiŋ bəh chukuli winaiŋ a, yuwidɔkɔ i dzaka a nə. ");
INSERT INTO cug_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","A ni num i jɔbi wiwɔ wə Kiŋ'waka ki Baiŋni ni nya lə mbɛiŋ bəh gia yə mbɛiŋ ni dzaka.” ");
INSERT INTO cug_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Si Jisɔs nì təfiki bwa bu bə mbaŋ yakadəiŋ, mi widɔkɔ i mbaŋ wi bəni kintəəŋ dza dzaka a, “Mi wi lanini, dzâka i waiŋnih wuŋ a, wi gâa nyâ mbiŋ biɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisɔs bikə i wi a, “Nyuku wələ, a jiə ndə mih i numki mi wi nsaka wimbɛiŋ, chu gaa biɛiŋ bimbɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Si wi bikə yaka ka dzaka i bəni bəchi a, “Mbɛiŋ tɔ̂kniki nalə, kiə mbɛiŋ ma bûkuki bəh dzə́kəh i biɛiŋ wə, kɔm kiŋ'waka ki mi kɔkə kɔm bə biɛiŋ biə wi kaŋaki, kɔŋ wi kaŋaki biɛiŋ nalə.” ");
INSERT INTO cug_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Si wi nì dzaka yakadəiŋ, ka ti ndi a, “Tii kpɔ widɔkɔ nì kaŋaki khə wi, dzɛiŋ buku yɛiŋ nalə. ");
INSERT INTO cug_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Wi ka yisi i kwakaki a, ŋgaiŋ ki fə̂ki na dəiŋ na? Ŋgaiŋ ni jîə dzɛiŋ bi ŋgaiŋ naiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Wi ka jiə kimfasi a, ‘Mih kiə gia yə mih ki fə̂ki. Mih ki shayiki lə bəshaŋkwa bəŋ ma, mih fiəni kpɛiŋsi, ka mih bi jiə dzɛiŋ bəh biɛiŋ biŋ yɛiŋ wə bichi. ");
INSERT INTO cug_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jɔbi wə mih ka fə yakadəiŋ, mih ni dzaka i gwu yiŋ a, mih kɔ mi wi kidəəŋ. Mih kwati biɛiŋ biə mih bi dziki i buku jía yiduli wə, chu wɔkɔ kə ŋgəkə. Mih kɔ liə i dziki a dzini, chu mu a muni wɔkɔ ndzɔŋni.’ ");
INSERT INTO cug_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Si wi nì kɛiŋsi yakadəiŋ, Nyɔ ka bɔɔŋ wi a, ‘Kiyuŋ kələ! Daiŋ nchɔkɔ mih ni fiəni dzɔ lə kiŋ'waka ka. Biɛiŋ biələ bichi wɔ kɛiŋsi jiə lə bi ni numki bi ndə a?’” ");
INSERT INTO cug_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Si Jisɔs dzaka yakadəiŋ ka dzaka a, “Yi kɔ ayaka i mi wə wi juŋniki mbum bi mbi i gwu yi wə, kaŋa kə mbum bidɔkɔ i kimbu ki Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wi chu dza ka dzakaki num i bwa bu bə mbaŋ a, “Kiə mbɛiŋ ma fûmsiki gwu kɔm nɔni kimbɛiŋ, a mbɛiŋ ni dzi nə, na yudɔkɔ kɔm gwu yimbɛiŋ a mbɛiŋ ni lɔh nə. ");
INSERT INTO cug_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mbɛiŋ kiəki a kiŋ'waka ki mi tsəki lə biɛiŋ bi dzini, gwu yi mi tsə bəmbuŋ. ");
INSERT INTO cug_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mbɛiŋ yɛiŋ biŋaŋa, bi nɔmki kə, gbɛli kə. Na bi si kɔh kə dzɛiŋ i juŋni jiə i bəshaŋkwa wə nabə gba. Ayakalə, Nyɔ saŋsi bi bichi. Mbɛiŋ kiəki kə a mbɛiŋ kɔkniki tsəki lə minyəni a? ");
INSERT INTO cug_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Akɔ ndə i mbɛiŋ kintəəŋ wə wi fumsiki gwu, wi num i kpɛiŋsi jɔbi twɛsi i nɔni ki wə a? ");
INSERT INTO cug_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Si mbɛiŋ mɔŋ i fə na yi twɛsi yələ, mbɛiŋ bə́ fumsi gwu i nə a? ");
INSERT INTO cug_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mbɛiŋ yɛ̂iŋ si bəfluwa kɔɔki bɔ num. Bəfluwa si nɔm kə nabə i kɛiŋsi bəmbuŋ bəbɔ. Ayakalə, mih fukuki i mbɛiŋ a, na Ŋkuŋ Sɔlɔmɔn bəh mbum bi bichi biə wi nì kaŋaki, jɔbi wə wi nì lafiki gwu bəh bəmbuŋ wi nì ka num buku dəkə ka fluwa widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A kabə num lə si Nyɔ lafiki mfwaŋ i chwa, mfwaŋ biə bi kɔki daiŋ, kijiəli bə kpa i gbuku wə, ma wi Nyɔ ni lafi mbɛiŋ i tsə buku dəiŋ a? Ɔ ɔɔ bəni bə mbum wi twɛsi! ");
INSERT INTO cug_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yi kɔ a mbɛiŋ ma fûmsiki gwu yimbɛiŋ i kwakaki kɔm fiɛŋ fiə mbɛiŋ kaŋaki i dzi bəh i mu, ");
INSERT INTO cug_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","kɔm gia yələ si kwaka bəni bə mbi bə̀ bɔ kiəki kə Nyɔ. Mbɛiŋ kîəki a, Ba wimbɛiŋ kiəki lə a mbɛiŋ nəŋki lə biɛiŋ biələ bichi. ");
INSERT INTO cug_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mbɛiŋ jîə mfi bimbɛiŋ num i ŋkuŋ bi Nyɔ wə, ka wi ni nyaki mbɛiŋ tə bəh biɛiŋ biələ bichi. ");
INSERT INTO cug_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mbaŋ wuŋ, si mbɛiŋ kɔ twɛsi lə kiə mbɛiŋ ki lwâ kə kɔm Ba wimbɛiŋ kɔ bə kinsaŋli i nya ŋkuŋ bi i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mbɛiŋ tâŋni biɛiŋ biə mbɛiŋ kaŋaki, ma mbɛiŋ gâa kpɔ wiwɔ i bəni bə kifuu, mbɛiŋ nə̂ŋki biba bi kpɔ a num biə bi kɔkə i shakyi. Mbɛiŋ jîəki kpɔ wimbɛiŋ num i tumi ki Nyɔ wə, i di biə bəji kɔkə i chwɔ, bəh i di biə nchami kɔkə i kwa, bəh i di biə shəkə kɔkə i mɛni. ");
INSERT INTO cug_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mbɛiŋ kîəki a, di biə mi jiəki kiba ki akɔ fɛiŋ wə shɔm yi kɔ. ");
INSERT INTO cug_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mbɛiŋ kâŋa chiŋni bimbɛiŋ ma mbɛiŋ bâiŋsi naka bimbɛiŋ bi baiŋki, ma mbɛiŋ wɔ̂kɔliki nɔm, ");
INSERT INTO cug_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","aka bwa bə nɔm bə̀ bɔ kɛiŋsi gwu ka wɔkɔliki tikwili wibɔ, si wi fiəniki dzəki i di bi dzɔni bi miŋkpaŋa wimfiaŋ wə. Ka jɔbi wə wi ni fiəni dzə kɔmyi dzaka ki juŋ, ma bɔ ni wɛli akisəkə wi liə. ");
INSERT INTO cug_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kinsaŋli kimbum kɔ ki bwa bə nɔm bə̀ tikwili wibɔ ni fiəni dzə yɛiŋ bɔ kɛiŋ wɔkɔli wi. Mih fukuki ŋkɔŋ i mbɛiŋ a, wi ni tum mbuŋ i gwu yi wə, ma bɔ num i kuku, wi tsəsi dzɛiŋ i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kinsaŋli kimbum bi numki ki bwa bə nɔm bə̀ wi bi kwatiki bɔ wɔkɔli, kɔŋ wi numki i bi fiəni dzə na nchɔkɔ kintəəŋ, yudɔkɔ na i jɔbi wə kwɔkɔ tɔŋki. ");
INSERT INTO cug_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mbɛiŋ kîəki a, tikwili kabə kiəki jɔbi wə ji kaŋaki i dzə nchɔkɔ fɔkɔ, wi ma ni chu bee a wi dzə bwiŋ juŋ yi. ");
INSERT INTO cug_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mbɛiŋ tə kaŋaki i nûmki bəh ŋkɛiŋsi wi gwu, kɔm mi wə yɛli wi kɔ Waiŋmi bi fiəni dzə lə i jɔbi wə mbɛiŋ kiə kə.” ");
INSERT INTO cug_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bita ka dza bikə i wi a, “Bah, wɔ ti ndi wələ num i buku, ma i bəni bəchi a?” ");
INSERT INTO cug_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bah chukuli a, “Waiŋ wi nɔm wə wi kɔ wi ŋkɔŋ, chu kaŋa mfi, kɔ winaiŋ? Ntə akɔ wə tikwili wi nì jiə a wi tɔkniki bəh juŋ yi, a jɔbi wə, jɔbi ka kpɛiŋ ma wi ni nyaki biɛiŋ bidzini i bwa bu bə nɔm a? ");
INSERT INTO cug_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kinsaŋli kimbum bi numki i waiŋ wi nɔm wə tikwili wi bi dzə yɛiŋki num wi fə nɔm wi a liŋ asi wi si nəŋki. ");
INSERT INTO cug_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mih fukuki ŋkɔŋ i mbɛiŋ a, tikwili wi bi yaksi wi a wi tɔkniki bəh biɛiŋ bi bichi. ");
INSERT INTO cug_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ayakalə, waiŋ wi nɔm wiwɔ ka dza dzaka i gwu yi a, ‘Tikwili wuŋ ni kɔmsi fiəni dzə kə,’ ka yisi i twɛiŋki bwa bə nɔm bənyuku bəh bəkaŋa, dzi a dzini chu mu mbih mɔ kwa wi, ");
INSERT INTO cug_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","yaka yi kɔ a tikwili wi waiŋ wi nɔm wiwɔ bi təkəli tumbuku i chɔkɔ biə wi si kwakaki kə bəh i jɔbi wə wi si kwakaki kə bəh i jɔbi wə wi si kiəki kə. Ayaka wi bi gbayi waiŋ wi nɔm wiwɔ, wi chiŋsi wi i tsə numki bəh bəni bə̀ bɔ kɔkə bə ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Waiŋ wi nɔm wə wi kiəki gia yə tikwili wi nəŋki a wi fəki, wi nəki kɛiŋsi kə gwu yi i fəki yi, ma yi numki a bə bi twɛiŋ lə wi bəh ŋgaŋa yiduli. ");
INSERT INTO cug_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Waiŋ wi nɔm wə wi kiəki kə gia yə tikwili wi nəŋki a wi fəki, wi fə gia yə bə kɔ i twɛiŋ wi bəh ŋgaŋa yiduli ma yi numki a bə bi twɛiŋki a wi twɛsi. Mi wə bə nya biɛiŋ biduli i wi, bə bi bikəki biduli i wi.” ");
INSERT INTO cug_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisɔs chu dzaka i bwa bu bə mbaŋ a, “Mih dzə i kpa num gbuku i fa kuku. Bə dzɔ a wi si bɛli lɔ. ");
INSERT INTO cug_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mih kaŋaki i liə i ŋgəkə wimbum widɔkɔ wə, shɔm yiŋ ni də a jɔbi wə mih ni liə i wi wə. ");
INSERT INTO cug_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mbɛiŋ kwakaki a, mih dzə num bəh kimbɔiŋni i fa kuku a? Ŋgaŋ, mbɛiŋ kîəki a, mih dzə num bəh kiŋgaali. ");
INSERT INTO cug_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","I yisi i liə i tsə ninshiŋ, juŋ yə yi kɔ bəh bəni bəte ni gaali lə. Bəni bətali ni gaali bəh bəfa, bəfa ni gaali bəh bətali. ");
INSERT INTO cug_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tii waiŋ ni gaali lə bəh waiŋ wi, winyukuni, waiŋ wi winyukuni gaali bəh ba wi. Nih waiŋ ni gaali bəh waiŋ wi wikpaŋni, waiŋ wi wikpaŋni gaali bəh nih wi. Nih nyuku ni gaali bəh kpə waiŋ wi, kpə waiŋ gaali bəh ni nyuwi.” ");
INSERT INTO cug_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisɔs dzaka i mbaŋ wi bəni wə a, “Mbɛiŋ ka yɛiŋ jɔbi wə bimba yakaki dzəki i kimbu kə wɔŋ liəki, mbɛiŋ yisi i dzakaki a, ‘Dzaŋ nəŋki lə i dzə.’ Ayaka yi dzə. ");
INSERT INTO cug_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Mbɛiŋ ka yɛiŋ tə fiəkə fəkə i kimbu ki shiŋ wə, mbɛiŋ ka dzakaki a, ‘Di ni shili lə nalə.’ Ayaka bi num. ");
INSERT INTO cug_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Mbɛiŋ bəni bə̀ mbɛiŋ dzakaki chi, fə chi, si mbɛiŋ tsɛiŋki bɔɔli bəh kuku mbɛiŋ ka kiəki si biŋ ni numki, akɔ tə kɔm nə wə mbɛiŋ kɔkə i kiə gia yə Nyɔ chusiki i liə a? ");
INSERT INTO cug_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mbɛiŋ mɔŋ tə i bɔŋ kwakaki gia yi chəŋ yə yi kɔ a mbɛiŋ fəki a? ");
INSERT INTO cug_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mi ka dzɔ wɔ, i tsə bəh wɔ i juŋ yi nsaka wə, wɔ mɔmsi mbɛiŋ wi kɛiŋsi a kɛiŋ i dzəh, ka wi ma guku tsə nya wɔ i kaŋ yi mi wə wi sakaki bənsaka, ma wi nya daŋsi wɔ i kaŋ yi bəni bə jum wə, ma bɔ ni fa wɔ i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mih fukuki i wɔ a, wɔ ni buku kə fɛiŋ maka wɔ gɔm kaasi finini fichi fiə bɔ bikəki.” ");
INSERT INTO cug_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","A nì kɔ i jɔbi wiwɔ wə, bəni bədɔkɔ dza ka fukuki i Jisɔs kɔm bəni bə Galili bədɔkɔ bə̀ bɔ nì tsəki i fə mfə gia i Nyɔ, Baylɛ faaŋ bəni bɔ tsə gbayi bɔ, mwa mibɔ chiŋni bəh minyam yə bɔ nì fə mfə gia yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisɔs wɔkɔli lə, bikə i bɔ a, “Mbɛiŋ kwakaki a, bəni bə̀ bɔ nì kpiyi i dzəh yələ wə, a bɔ nì kɔ na bəni bəchu tsə bəni bə Galili bəchi ma? ");
INSERT INTO cug_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ŋgaŋ, mih fukuki i mbɛiŋ a, mbɛiŋ baaŋ ki kwûni kə shɔ́m yimbɛiŋ, ma mbɛiŋ bəchi bi kpiyi ayaka. ");
INSERT INTO cug_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mbɛiŋ kwakaki alə bəni bə̀ jwɔfi ntsɔ nyaŋ bə̀ juŋ yi dəəŋ yə i Silɔam nì muku wɔɔyi bɔ a? Mbɛiŋ kwakaki a bɔ bədɔkɔ nì kpiyi yaka kɔm bɔ nì kɔ na bəni bəchu tsə bəni bə Jɛlusalɛm bəchi ma? ");
INSERT INTO cug_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ŋgaŋ, mih fukuki i mbɛiŋ a, mbɛiŋ baaŋ ki kwûni kə shɔ́m yimbɛiŋ, ma mbɛiŋ bəchi bi kpiyi ayaka.” ");
INSERT INTO cug_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jisɔs ka ti ndi widɔkɔ i bɔ a, “A nì kɔ jɔbi widɔkɔ wə, mi widɔkɔ yəə kpɛiŋ widɔkɔ i wi khə. Jɔbi nì kpɛiŋ i wi i tsə kɔhyi mintam miwɔ wi tsə nəki yɛiŋ kə na fimu. ");
INSERT INTO cug_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wi ka dzaka i mi wi wi nɔm a, ‘Tsɛ̂iŋ kpɛiŋ wələ, i jía yitali wə mih si shi dzə fa i tsɛiŋ mintam i kpɛiŋ wələ wə, mih yɛiŋ kə na fimu. Gbâ tɔ̂kɔ kuku, wi baŋki lə di kilɔlɔ.’ ");
INSERT INTO cug_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mi wi nɔm wiwɔ chukuli a, ‘Tikwili, bêe dəkə wi yaka, mih ki chəkyiki taliki lə chwɔŋ kiwɔ mih jiə chi yɛiŋ chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jɔbi wə wi ka wum mintam i jia yələ yi dzəki lə, ma yi ndzɔŋki, wi ka baaŋ i wum, ma wɔ ni gba tɔkɔ wi.’” ");
INSERT INTO cug_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","A nì kɔ chɔkɔ bimbam bidɔkɔ, Jisɔs ka laniki bəni i juŋ yi tsani yidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kpaŋa widɔkɔ num fɛiŋ kiŋ'waka kichu kidɔkɔ num i wi wə, num kə ki si fə mi wi chu mi wi jwɛiŋ, ki nì fə wi gwɛiŋ i jía jwɔfi ntsɔ nyaŋ, jum yi ŋgwuŋ, wi kɔbi i chu num i bɛiŋ chəŋ. ");
INSERT INTO cug_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jɔbi wə Jisɔs nì yɛiŋ kpaŋa wiwɔ, ka bɔɔŋ wi, wi dzə, wi dzaka i wi a, “Nih wuŋ, wɔ bɔnih lɔ i jwɛiŋ ya wə daiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Si wi dzaka yakadəiŋ, ka nani tsɛiŋ yi kɔm wi. Akisəkə, jum yi fiəni nani gwu ka kaa, wi num bɛiŋ chəŋ, ka chɔŋyiki Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tikwili wi juŋ yi tsani yiwɔ yɛiŋ si Jisɔs chuku kpaŋa wiwɔ, a num i chɔkɔ bimbam wə, gia yiwɔ nya lɔ wi bəh ŋgəkə. Wi ka yɔliki i bəni a, “Kaŋ kɔ yisɔ yə bukumbɛiŋ kaŋaki i nɔmki yɛiŋ. Mbɛiŋ dzə̂ki bə chukuki jwɛiŋ yimbɛiŋ i kaŋ yələ wə, ayakalə a kɔbi i chɔkɔ bimbam wə!” ");
INSERT INTO cug_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bah chukuli i wi a, “Mbɛiŋ bəni bə̀ mbɛiŋ dzakaki chi, fə chi. I chɔkɔ bimbam wə, ntə mi wimu wimu i mbɛiŋ kintəəŋ, si dzɔ lə naʼ wi, yuwidɔkɔ njakas wi i di biə yi nɔki, i tsə nya yi bəh mwi a? ");
INSERT INTO cug_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kpaŋa wələ kɔ waiŋ Ablaham, wə Satan nì kaŋa i bənsəŋ wə jía jwɔfi ntsɔ nyaŋ, yaka yi si ndzɔŋki kə si mih gamti wi i ŋgəkə wi wələ, i chɔkɔ bimbam wə a?” ");
INSERT INTO cug_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Si Jisɔs dzaka yakadəiŋ, bəni bə̀ bɔ nì baiŋŋki wi, gəmni i gwu yibɔ wə, bəni bəduli bədɔkɔ num fibɔ bəh kinsaŋli, kɔm bə gia yi kaŋyini yichi yə Jisɔs nì fəki. ");
INSERT INTO cug_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisɔs ka təmki a, mih ki fəkəliki a, “Ntɔŋ bi Nyɔ kɔ aka finə a? Fiɛŋ fiə mih ki fəkəliki yɛiŋ kɔ nə a? ");
INSERT INTO cug_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bi kɔ aka ŋgɔkɔ wi fintam fidɔkɔ mi nì buku tsə i gbɛli i wi khə, ŋgɔkɔ wiwɔ kɔ yaka ka fiəni chu num kpɛiŋ, minyəni mə mɔ fuliki i bɛiŋ dzə maa júŋ yibɔ i cha yiwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wi ka chu təmki a, “Akɔ finaiŋ fiɛŋ mih ki fəkəniki ŋkuŋ bi Nyɔ bəh fi a? ");
INSERT INTO cug_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bi kɔ aka dzɔɔŋ yə miŋkpaŋa ni fəkə muku i biŋkuŋɔ bimbum wə bitali ka fwɛŋni, ka chwali yi fə muku miwɔ yaka.” ");
INSERT INTO cug_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisɔs dza ka tsəki i bikwili wə bəh i bidi wə si wi nì tsəki lani tsə bəni, tsə sə dzəh yi i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mi widɔkɔ dza bikə i wi a, “Bah, akɔ a bəni twɛsi bɔ bi bɔiŋki a?” Jisɔs ka chukuli lɔ i bɔ bəchi a, ");
INSERT INTO cug_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mbɛiŋ jwɔ̂ki na bəh ŋga i liə num i dzaka kifiəŋə kifaaŋnini. Mbɛiŋ kiəki a, bəni bəduli bi nəŋki lə i liə i ki wə, dzəh kɔbi. ");
INSERT INTO cug_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jɔbi bi kpɛiŋ lə wə, tii juŋ wiwɔ bi dza fah dzaka ki juŋ. Jɔbi wə wi bi fa, mbɛiŋ bi baaŋ i biŋ i kɔmyiki dzaka ki juŋ dzakayi a, ‘Tikwili, wɛ̂li a dzaka ki juŋ ka buku liə.’ Wi bi chukuli i mbɛiŋ a, ‘Mih kiəki kə di biə mbɛiŋ buku.’ ");
INSERT INTO cug_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mbɛiŋ ka bi nɔmyiki dzakaki, ‘A kɔkə a buku bə̀ bukumbɛiŋ nì shiki dziki chu mu a? Ayaka wɔ nì nyaniki laniki nnyaki bəni i bidi bibuku wə.’ ");
INSERT INTO cug_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wi bi fiəni chukuli shəŋ a, ‘Mih fukuki i mbɛiŋ a mih kiəki kə di biə mbɛiŋ buku. Mbɛiŋ nyə̂ i mih fiəŋə mbɛiŋ bə̀ mbɛiŋ nyaniki fəki chu.’ ");
INSERT INTO cug_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mbɛiŋ bi yɛiŋ lə Ablaham bəh Ayjik bəh Yakɔb bəh bəni bə ntum bə Nyɔ bəchi i kintəəŋ ki ŋkuŋ bi Nyɔ wə, num bə baŋ mbɛiŋ i biŋ, mbɛiŋ bi ka dəki dzi jəŋ. ");
INSERT INTO cug_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bəni bi dza i bimbu bichi wə, i yisi i di biə wɔŋ bukuki dzəki, bəh i di biə wi tsəki liəki, bəh i di bi bɛiŋ bɛiŋ wə bəh bi shiŋ i mbi wə, bɔ bi dzə shinum i dziki i kintəəŋ ki ŋkuŋ bi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mbɛiŋ wɔ̂kɔli bəni bəduli bə̀ bɔ kɔ i ninshiŋ i liə bi numki num i jum wə, bəduli bə̀ bɔ kɔ i jum wə i liə bi numki num i ninshiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","A nì kɔ a jɔbi wiwɔ wə, Bəfalasi dzə dzaka i Jisɔs a, “Bûku nyə̂ fa, tsə i kimbu kidɔkɔ wə kɔm Ŋkuŋ Hɛlɔd nəŋki i wɔɔ wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisɔs chukuli i bɔ a, “Mbɛiŋ tsə̂ dzâka i fifinchɔŋ fiwɔ a mih ki bwiliki lə bəchinda bə ŋkpɛli i bəni wə daiŋ, mih chuku jwɛiŋ, i yisi i daiŋ bəh kijiəli, mih bi buku kaasi nɔm wuŋ shitsə kijiəli. ");
INSERT INTO cug_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ayakalə, mih ni yisi nyani wuŋ wi Jɛlusalɛm daiŋ, bəh i buku nyani kijiəli i tsə buku shitsə kijiəli. Yi kpɛiŋniki kə a bə wɔɔ mi wi ntum wi Nyɔ i di bidɔkɔ wə a kɔbi a i Jɛlusalɛm.” ");
INSERT INTO cug_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Si Jisɔs dzaka lə, wi ka chu dzaka a, “Yəbɛɛy Jɛlusalɛm! Yəbɛɛy Jɛlusalɛm! Wɔ wɔɔyiki bəni bə ntum bə Nyɔ, chu tumyi bəni bə̀ Nyɔ faaŋki i mbɛiŋ bəh kitəh. Akɔ kiŋkani kimaiŋ si mih mɔmsi i juŋni bwa ba asi nih shyə si juŋni bwa bu wi kwumi baŋ bəh bəkəli bi, wɔ nəiŋma a? ");
INSERT INTO cug_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Tsɛ̂iŋ, bə kɔ num bə lɔtɔkɔ lɔ juŋ ya yi fiəni num chii. Ayaka mih fukuki i mbɛiŋ a, mbɛiŋ bi chu yɛiŋ kə i mih wə, i tsə buku jɔbi wə mbɛiŋ bi dzakaki a, ‘Nyɔ jiə kimbɔiŋsi i mi wə wi dzəki i yɛli wi Bah wə.’” ");
INSERT INTO cug_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A nì kɔ i chɔkɔ bimbam bidɔkɔ wə, Jisɔs tsə i dzi i juŋ yi mi wimbum wi Falasi widɔkɔ. Bəni bə̀ bɔ nì kɔ fɛiŋ nì tsɛiŋki Jisɔs i yɛiŋ gia yə wi ni fə. ");
INSERT INTO cug_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","A nì kɔ mi widɔkɔ num fɛiŋ i Jisɔs nshiŋ wi gwɛiŋ bəh jwɛiŋ yidɔkɔ yi fə kaŋ yi bəh kaka bi mɔyi. ");
INSERT INTO cug_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisɔs bikə i Bəfalasi bə̀ bɔ nì kɔ fɛiŋ, bəh bəni bə̀ bɔ nì kɛiŋsiki kiəki bənchi bə Nyɔ, “Bənchi bəbukumbɛiŋ bumki lə a bə chûku mi i chɔkɔ bimbam wə, ma nə a?” ");
INSERT INTO cug_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bɔ nəki kaŋa kə gia yidɔkɔ i chukuli. Jisɔs kaŋa mi wiwɔ, chuku wi, ka dzaka a wi tsə̂ki. ");
INSERT INTO cug_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jisɔs ka fiəni bikə i bəni bəwɔ a, “Mi widɔkɔ kabə kaŋa waiŋ nabə naʼ, wi gbɔ i fəŋ mə i chɔkɔ bimbam wə, wi ma ni bwili akisəkə a?” ");
INSERT INTO cug_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bɔ məŋni gia yə bɔ ki chukuliki. ");
INSERT INTO cug_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisɔs dza yɛiŋ si bəni dzəki sabi di bibɔ num i ninshiŋ i numyi yɛiŋ, wi ka ti bɔ bə ndi a, ");
INSERT INTO cug_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Jɔbi wə bə laka wɔ i dzini bi ndzɔ wi miŋkpaŋa wimfiaŋ wə, wɔ tsə ma nûm i di bi ninshiŋ wə, kɔm mi wimbum widɔkɔ kɔlə fɛiŋ num bə si laka tə wi fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Tikwili wə wi si laka mbɛiŋ bəchi, wi ni dza dzə dzaka i wɔ a, ‘Dzâ nyâ di biələ i mi wimbum wələ.’ Ma wɔ ka ni dza, num bəh kiŋgəmni i tsə num lɔ num i jum wə. ");
INSERT INTO cug_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jɔbi wə bə laka wɔ i dzini bi dzɔni bi miŋkpaŋa wimfiaŋ, wɔ tsə̂ nûm num i jum wə, ka tii dzini bi miŋkaŋa wimfiaŋ ni dzə dzaka i wɔ a, ‘Nsɛiŋ wuŋ, dzâ fa, tsə̂ nûm num i ninshiŋ.’ Ayaka, wɔ ka ni kaŋa kiŋkɔksi i bəni bəchi nshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yi kɔ a liŋ i mi wichi wə wi yaksiki gwu yi, bə bi shisi lə wi. Mi wə wi shisiki gwu yi, bə bi yaksiki lə wi.” ");
INSERT INTO cug_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisɔs ka dza fiəni dzaka i tii juŋ wə a, “Jɔbi wə wɔ nəŋki i bɔɔŋ bəni a bɔ dzə dzi, ma ni bɔɔŋ num nsɛ́iŋ ya na bwa bə nah, na chwɔŋ ki juŋ ka, na bəni bə kpɔ, bə̀ bɔ nɔki kɔmsiki i wɔ wə. Kɔm bɔ bi fiəni bɔɔŋ lə wɔ tə i juŋ yibɔ wə, ma yi ka bi numki a, bɔ nì chukuli lɔ kaŋ ya. ");
INSERT INTO cug_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jɔbi wə wɔ fəki dzini, laka num bəni bə kifuu, bəh biŋkəŋni, bəh bə̀ bɔ gbɔki nyaniki, bəh bimfəkə. ");
INSERT INTO cug_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Wɔ ka fə yakadəiŋ, ma Kimbɔiŋsi ki Nyɔ numki i wɔ wə, kɔm bəni bələ kaŋaki kə fiɛŋ fidɔkɔ, i bi fiəni chukuli i wɔ. Ma gɔm wa bi numki i Nyɔ, i chɔkɔ biə bəni bə̀ bɔ kɔ chəŋ bi dzayiki i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Si Jisɔs dzaka yakadəiŋ, mi widɔkɔ wə, bəh bɔ nì dziki wɔkɔ gia yiwɔ ka dzaka i wi a, “Kimbɔiŋsi kimbum kɔ i mi wə wi bi dziki blɛd i kintəəŋ ki ŋkuŋ bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisɔs ka chukuli i wi a, “A nì kɔ jɔbi widɔkɔ wə, mi widɔkɔ kɛiŋsi bini bimbum, wi laka bəni bəduli. ");
INSERT INTO cug_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Si chɔkɔ bi bini biwɔ nì dzə kpɛiŋ, wi faaŋ waiŋ wi wi nɔm a wi nyani fuku i bəni bəchi bə̀ wi nì laka bini i bɔ, a ŋgaiŋ kɛiŋsi lɔ biɛiŋ bichi. ");
INSERT INTO cug_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Waiŋ wi nɔm wiwɔ ka tsə yɛiŋ bɔ, bɔ yisi ka təmki wimu wimu. Mi wi ninshiŋ wə wi nì yɛiŋ dzaka i wi a, ‘Yɛ̂iŋ mih si kɔ mih taŋ khə wuŋ wimfiaŋ, mih kaŋaki i tsə tsɛiŋ wi. Tɛsi, mih ni numki kə.’ ");
INSERT INTO cug_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Wi chu yɛiŋ widɔkɔ wə wi bɔŋ chukuli tə a, ‘Mih si kɔ mih taŋ bənaʼ bəŋ bə nɔm jwɔfi, mih kaŋaki i tsə̂ mɔ̂msi yi i liə. Tɛsi, mih ni numki kə.’ ");
INSERT INTO cug_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Wi chu yɛiŋ widɔkɔ wi bɔŋ chukuli tə a, ‘Mih dzɔ a kpə wuŋ wimfiaŋ daiŋ, tɛsi, akɔ gia yə mih ni dzə kə.’ ");
INSERT INTO cug_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Si bɔ chukuli yakadəiŋ, waiŋ wi nɔm wiwɔ ka fiəni tsə fuku gia yichi i tikwili wi. Tikwili wiwɔ wɔkɔ gia yiwɔ, shɔm bɔkɔ wi. Wi ka fiəni faaŋ waiŋ wi nɔm wiwɔ, dzaka i wi a, ‘Bûku wakli, tsə̂ i kwili kintəəŋ, nyâni nnyâ i dzə́h yi tasini bəh i dzə́h yinchiŋ yinchiŋ wə, jûŋni bəni bə̀ bɔ gbɔki nyaniki bəh bimfəkə bəh biŋkəŋni, ma wɔ dzə̂ bəh bɔ.’ ");
INSERT INTO cug_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wi tsə fiəni dzə dzaka a, ‘Tikwili, mih fə lɔ gia yichi asi wɔ si dzaka ayakalə, juŋ kɛiŋki ki jikə kə.’ ");
INSERT INTO cug_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Tikwili wi dzaka i wi a, ‘Tsə̂ i dzə́h yimbum bəh yinchiŋ yichi ma wɔ dzɔ̂ dzə̂ bəh bəni bəduli ka bɔ dzə jiksi juŋ yichi. ");
INSERT INTO cug_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mih fukuki i mbɛiŋ a, mi i kintəəŋ ki bəni bə̀ mih si yisi laka bɔ bi mɔ̂m kə fiɛŋ fidzini i bini biŋ wə.’” ");
INSERT INTO cug_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jisɔs chu nyə ka tsəki, mbaŋ wi bəni kwu biəli wi. Wi ka dza fiəni dzaka i bɔ a, ");
INSERT INTO cug_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mi wə wi nəŋki i biəli mih i num mi wuŋ wi mbaŋ wi kɔbi i kɔŋ mih i tsə ba wi, bəh nih wi, chu kɔbi i kɔŋ mih i tsə kpə wi bəh bwa bu, bəh bwa bə nih wi, bəh jɛ́mi yi, nabə i kɔŋ mih tə tsə si wi kɔŋki gwu yi, wi kɔkə i num mi wuŋ wi mbaŋ. ");
INSERT INTO cug_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mi wə wi nəŋki i num i mbaŋ wuŋ wə, wi kaŋaki i gîŋ kintasi ki i bîəliki mih. ");
INSERT INTO cug_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Akɔ ndə i mbɛiŋ kintəəŋ wə wi nəŋki i maa juŋ yi dəŋə yaka i bɛiŋ, wi ma nì yisi i shi num i kuku i kwaka fwu wi, a kpɔ wə wi kaŋaki kɔlə bi kpɛiŋ ka wi bi maa kaasi yɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wi ka baaŋ i fə yakadəiŋ, wi ka yisi a chɔkɔki chaka ki juŋ kiwɔ, ki ni gaka wi i kaasi. Jɔbi wə bəni bi tsəki fɛiŋ ma bɔ bi suŋuki wi dzaka a, ");
INSERT INTO cug_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Mbwə wələ nì yisi juŋ, yi gaka wi i kaasi.’ ");
INSERT INTO cug_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yi ni numki a liŋ tə a, akɔ winaiŋ ŋkuŋ wə wi nəŋki i laa tum jum bəh ŋkuŋ widɔkɔ, wi kɔbi i yisi num kuku i kwaka a ŋgaiŋ bəh bəni bu bə jum bənchuku jwɔfi kɔlə i tsə jwɔ ŋkuŋ widɔkɔ wə wi kaŋaki bəni bu bə jum bɔ num i buku bənchuku mbaŋfia a? ");
INSERT INTO cug_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wi ka kwaka yɛiŋ a yi ləkəki lə, wi kaŋaki i bâayi bəni bu bədɔkɔ i fâaŋ a bɔ tsə̂ yɛ̂iŋ ŋkuŋ widɔkɔ wə wi kɛiŋ i dzəh yi dəəŋ, i tsâ wi a wi fə̂ dzəh yə kimbɔiŋni kɔ i nûmki i bɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Yi ka numki a i dzəh yələ wə, mi wə wi ka baaŋ ki dali kə biɛiŋ bi bichi, wəmaka mi kɔkə i num i mbaŋ wi bwa bəŋ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ŋkaka kɔ fiɛŋ fi ndzɔŋni. Ayakalə, yi ka laksi njwɔŋni bi, bə kɔ i chu fə na dəiŋ bəh yi ka yi fiəni njwɔŋki a? ");
INSERT INTO cug_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yi numki a, yi laka lɔ kilɔlɔ. Yi kɔkə ka bə shuku i khə nabə i di bi chi wə. Yi kɔ a shuku tɔkɔ kilɔlɔ. Mi wə wi kaŋaki bintuni i wɔkɔ wi wɔ̂kɔ.” ");
INSERT INTO cug_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Bəni bə̀ bɔ ni kwaki kiŋwakti, bəh bəni bəchu bədɔkɔ ni dzəki i Jisɔs i wɔkɔ gia yə wi laniki. ");
INSERT INTO cug_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bəfalasi bəh bəni bə̀ bɔ ni laniki bənchi bə Nyɔ, yisi i shwiŋyiki dzakayi a, “Mi wələ dzɔ bəni bəchu kabə dzi bəh bɔ.” ");
INSERT INTO cug_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ayakadəiŋ, Jisɔs ti ndi wələ i bɔ a. ");
INSERT INTO cug_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Akɔ ndə i mbɛiŋ kintəəŋ wə, wi kabə kaŋaki shwáŋ yi gbi, yimu laka, wi ni chəŋ num alə a? Wi ma ni yisi bee yə mbaŋ bwukə ntsɔ bwukə i chwa, i tsə nəŋ yimu yiwɔ, i tsə buku jɔbi wə wi ni yɛiŋ i yi wə a? ");
INSERT INTO cug_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wi ka ni nəŋ yɛiŋ yi, ma wi laŋki, wi giŋ yi i kimbəkəli wə, ");
INSERT INTO cug_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","wi kwɛki tsəki bəh yi i dzu. Jɔbi wə wi kwɛ, wi ni bɔɔŋ juŋni nsɛ́iŋ yi, bəh bəni bə̀ bɔ nɔki kɔmsiki i wi kpəŋ wi dzaka i bɔ a, ‘Mbɛiŋ dzə̂ bukumbɛiŋ lâŋki, kɔm mih yɛiŋ shwaŋ yiŋ yi si laka.’ ");
INSERT INTO cug_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mih fukuki ŋkɔŋ i mbɛiŋ a, yi kɔ a liŋ asi, kinsaŋli kimbum bi numki i tumi ki bɛiŋ wə, kɔm bə mi wichu wimu wə wi kɔ wi kwuni shɔm yi. Bə bi laŋki wəmaka mi tsə bəni bə̀ mbaŋ bwukə ntsɔ bwukə bɔ kɔ chəŋ chu nəŋ kə ŋkwuni. ");
INSERT INTO cug_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma akɔ winaiŋ miŋkpaŋa wə wi kabə kaŋa chwaka bi kpɔ jwɔfi, kimu laka, wi ma ni baiŋsi naka ki baiŋsini i yaŋa juŋ i nəŋ ndzɔŋ, i tsə buku i jɔbi wə wi ni yɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Wi ka ni nəŋ yɛiŋ, wi ni bɔɔŋ juŋni nsɛ́iŋ yi bəh bəni bə̀ bɔ nɔki kɔmsiki i wi kpɛŋ, wi dzaka i bɔ a, ‘Mbɛiŋ dzə̂ bukumbɛiŋ lâŋki kɔm mih si fiəni bɔŋ kpɔ wuŋ si wi si laka, mi ka fiəni yɛiŋ wi.’ ");
INSERT INTO cug_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mih fukuki i mbɛiŋ a, yi kɔ a liŋ tə, asi bəchinda bə Nyɔ laŋki kɔm bə mi wichu wimu wə wi kɔ wi kwuni shɔm yi.” ");
INSERT INTO cug_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisɔs chu dzaka a, “Mi widɔkɔ nì kaŋaki lə bwa bu bənyuku bəfa. ");
INSERT INTO cug_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Waiŋ wi jum wə dza dzaka i ba wi a, ‘Ba, gâa nyâ mbiŋ biɛiŋ i liə.’ Ba wi ka gaa biɛiŋ bi i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","A nəki num kə i jɔbi wi dəəŋ wə, waiŋ wi jum wə dzɔ biɛiŋ bi, ka juŋni bi bichi ka taŋni, nyə tsə i tumi ki dzəh yi dəəŋ wə. I fɛiŋ wə wi bəkəli kaasi kpɔ wiwɔ i nɔni kichu wə. ");
INSERT INTO cug_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jɔbi wə wi nì bəkəli kaasi kpɔ wi, dzɔŋ yiləkəli ka kwa tumi kiwɔ, wi chu kaŋa kə fiɛŋ fidzini. ");
INSERT INTO cug_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ayakadəiŋ, wi ka tsə nəŋ nɔm i mi widɔkɔ i tumi kiwɔ wə, a wi nɔmki i wi. Mi wiwɔ ka faaŋ wi, wi tsə ka tɔkniki bəh bifi bi. ");
INSERT INTO cug_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wi dza ka nəŋki i dziki biɛiŋ bi dzini bi bifi, ayakalə mi widɔkɔ kɔbi i nya wi bəh fɛiŋ fidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wi ka yisi i təmki gia, fiəni bɔɔŋ mfi bi, ka dzaka a, ‘Bəni bə nɔm bə ba wuŋ kaŋaki biɛiŋ bidzini biduli bi gaka bɔ, mih num fa kpi dzɔŋ. ");
INSERT INTO cug_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mih ni fiəni tsə lə i ba wuŋ, mih dzaka i wi a, “Ba, mih fə chu i Nyɔ nshiŋ bəh i wɔ tə. ");
INSERT INTO cug_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mih chu kpɛiŋniki kə ka bə bɔɔŋki mih a waiŋ wa. Dzɔ̂ jîə mih aka mi wa wi nɔm.”’ ");
INSERT INTO cug_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ayakadəiŋ, wi ka dza fiəni tsə i ba wi. Jɔbi wə wi nì bukuki kɔmsiki tsəki i kwili wə, ba wi lɔɔ dzəkəh ka yɛiŋ wi. Nshɛiŋ kwa wi bəh waiŋ, wi dza bɛiŋ, yɔkɔ tsə, maŋni wi, bə́ yaŋayi. ");
INSERT INTO cug_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Waiŋ wiwɔ ka dzaka i wi a, ‘Ba, mih fə chu i Nyɔ nshiŋ bəh i wɔ. Mih chu kpɛiŋniki kə ka bə chu bɔɔŋki mih a waiŋ wa.’ ");
INSERT INTO cug_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ayakalə, ba wi ka bɔɔŋ bəni bu bə nɔm dzaka a, ‘Mbɛiŋ tsə̂ wakali, mbɛiŋ nə̂ŋ dzə̂ bəh mbuŋ wə wi ndzɔŋki nalə, mbɛiŋ dzə̂ lɔ̂ɔ i wi wə, mbɛiŋ lə̂kə finsəŋ i kpaŋ wi wə bəh dzuyigvu i gvu yi wə. ");
INSERT INTO cug_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mbɛiŋ tsə̂ kwâ dzə̂ waiŋ naʼ wimbum, mbɛiŋ kûm yi, ka bukumbɛiŋ dziki bə laŋ, ");
INSERT INTO cug_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","kɔm waiŋ wuŋ wələ nì kpi, wi fiəni yɔmmi. Wi nì laka, wi fiəni tumbuku.’ Ayakadəiŋ, bɔ ka yisi i laŋki. ");
INSERT INTO cug_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Gia yələ nì num lə, waiŋ wi ninshiŋ num i chwa. Jɔbi wə wi nì kwɛki dzəki i buku kɔmsi dzə i dzu, wi wɔkɔ biɛiŋ bi kwuŋni jumi bəni biŋ. ");
INSERT INTO cug_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wi bɔɔŋ mi wibɔ wi nɔm widɔkɔ bikə a, a num nə, bə biŋki fa? ");
INSERT INTO cug_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wi chukuli i wi a, ‘Waiŋnah si fiəni dzə daiŋ. Ayakadəiŋ, ba wimbɛiŋ ka kum dɔmi ki naʼ kimbum, kɔm wi si yɛiŋ waiŋnah wi num wiwɔm chu ləkə.’ ");
INSERT INTO cug_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wi wɔkɔ yaka shɔm ka bɔkɔ lɔ wi, wi ka nəiŋ i liə dzu. Ba wi buku tsə ka tsaki wi a wi lîə a dzu. ");
INSERT INTO cug_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ayakalə, wi chukuli i ba wi a, ‘Tsɛ̂iŋ, mih ni nɔmki i wɔ ka mfa i jía yələ wə yichi, mih ka num nəiŋ i fə gia ya yidɔkɔ. Wɔ ka num nya mih na bəh waiŋ bii a, mih laŋki buku nsɛ́iŋ yiŋ. ");
INSERT INTO cug_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Waiŋ wa wələ, wə wi nì tsə bəkəli biɛiŋ bia bəh bəkaŋa bə tɔkɔlini, jɔbi wə wi si dzə, wɔ ka tsə kwa waiŋ naʼ wimbum ka kum kɔm wi.’ ");
INSERT INTO cug_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ba wi chukuli i wi a, ‘Waiŋ wuŋ, buku wɔ shi kɔ a fa jɔbi wichi, biɛiŋ bichi biə mih kaŋaki akɔ mbia. ");
INSERT INTO cug_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ayakalə, yi si ndzɔŋki lə, a bə lâŋki kɔm waiŋnah wələ nì kpi lɔ, wi fiəni yɔmmi, wi nì laka, wi fiəni tumbuku.’” ");
INSERT INTO cug_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisɔs chu dzaka i bwa bu bə mbaŋ a, “Mi wi kpɔ widɔkɔ nì kaŋaki lə waiŋ wi wi nɔm, wi nì jiə a wi tsɛ̂iŋki mbum bi. Wi ka dza wɔkɔ a, waiŋ wi wi nɔm wə bəkəliki lə kpɔ wi. ");
INSERT INTO cug_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wi ka bɔɔŋ waiŋ wi nɔm wiwɔ, bikə i wi a, ‘Yələ kɔ yinaiŋ gia mih wɔkɔki kɔm wɔ lə a? Bâkti biŋwakti bichi biə wɔ nyakaki kpɔ wuŋ yɛiŋ, wɔ dzə̂ fîəni nyâ i mih. Kɔm wɔ ni chu nɔmki kə i mih.’ ");
INSERT INTO cug_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Waiŋ wi nɔm wiwɔ tsə num kwaka a, ‘Si tikwili wuŋ kɔŋŋki mih i nɔm wə, mih ni fə dəiŋ a? Si mih kɔ mih kaŋa kə ŋga i nɔmki bəh dzəkə, mih chu ŋgəmni i nywaki.’ ");
INSERT INTO cug_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Wi ka fiəni kwaka a, ‘Mih kiə lɔ gia yə mih ni fə̂, i jɔbi wə wi kɔŋŋ mih i nɔm wə, mih kaŋaki lə nsɛ́iŋ yə yi kɔ i dzɔ mih i bɔ dzu.’ ");
INSERT INTO cug_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ayakadəiŋ, wi ka bɔɔŋ bəni bə̀ bɔ ni kaŋaki fwa yi tikwili wi wimu wimu, wi ninshiŋ dzə wi bikə i wi a, ‘Wɔ gɔmki tikwili wuŋ dəiŋ?’ ");
INSERT INTO cug_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Wi chukuli a, ‘Akɔ bibeli bimiə bimbum gbi.’ Ayaka wi dzaka a, ‘Kɔ̂ kiŋwakti ki fwa kələ nûm kuku wakli, kwûni nyâka a mbaŋshi.’ ");
INSERT INTO cug_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wi fiəni bikə i widɔkɔ a, ‘Wɔ gɔmki ŋ'wa dəiŋ na?’ Wi chukuli a, ‘Akɔ biba bigəŋ gbi.’ Ayaka wi dzaka a, ‘Kɔ̂ kiŋwakti ki fwa kələ kwûni nyâka a biba mbaŋnyani.’ ");
INSERT INTO cug_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Tikwili wi waiŋ wi nɔm wələ nì yɛiŋ si wi finiki bəh wi yaka, ka kɔksi wi a wi ni fifi lə.” Jisɔs ka kaasi a, “Bəni bə fa kuku fifiki i gia yə bɔ fəki tsə si bəni bə baiŋni fifiki i gia yibɔ yi baiŋni wə. ");
INSERT INTO cug_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ayakadəiŋ, mih fukuki i mbɛiŋ a, mbɛiŋ dzɔ̂ki mbum bimbɛiŋ bi fa kuku, i kwaki nsɛ́iŋ yɛiŋ, ka jɔbi wə bi bi kaa, Nyɔ bi ka dzɔ mbɛiŋ i wi dzu i di biə mbɛiŋ bi numki jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mi wə wi kiəki kə i tɔkni bəh fiɛŋ finchiŋ, wi kɔkə i tɔkni tə bəh fiɛŋ fimbum. Ayaka mi wə wi fəki kimfikili i gia yi nchiŋ wə, wi kɔlə i fəki tə kimfikili i yimbum wə. ");
INSERT INTO cug_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si mbɛiŋ kɔkə tɔkni bəmbum bi fa kuku, a ni nya ndə mbɛiŋ mbum bi ŋkɔŋ a? ");
INSERT INTO cug_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mbɛiŋ kabə kiəki kə i tɔkniki bəh biɛiŋ bi bəni bədɔkɔ, ma ndə ni nya mbɛiŋ bəh fiə fi kɔ fimbɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Waiŋ wi nɔm kɔkə i nɔ̂mki i bətikwili bəfa. Yi kabə num yakadəiŋ, ma wi ni baiŋŋki widɔkɔ wi kɔŋ widɔkɔ, yudɔkɔ, wi ni wɔkɔki i widɔkɔ nalə wi sɛiŋni widɔkɔ. Mbɛiŋ kɔkə nɔmki i Nyɔ chu nɔm i kpɔ.” ");
INSERT INTO cug_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Si Jisɔs dzaka yaka, Bəfalasi wɔkɔ gia yichi, ka yisi i suŋuki wi, kɔm bɔ nì kɔŋki kpɔ nalə. ");
INSERT INTO cug_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisɔs ka dzaka i bɔ a, “Akɔ mbɛiŋ bələ bə̀ mbɛiŋ chusiki gwu a mbɛiŋ kɔ bəni bə ndzɔŋni i bəni nshiŋ, ayakalə Nyɔ kiə gia yichi yə yi kɔ i shɔ́m yimbɛiŋ wə. Mbɛiŋ kiəki a gia yə bəni kɔksiki a, akɔ gia, akɔ yə Nyɔ tsɛiŋki yi nyɛŋ i wi.” ");
INSERT INTO cug_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jisɔs chu dzaka a, “A nì kɔ i kikpu wə, bə nì laniki num bənchi bə Muses bəh gia yə bəni bə ntum bə Nyɔ nì nyakaki. Ayakalə, i yisi si Jɔn nì dzə, bə ka fuku num ntum wi ndzɔŋni kɔm ŋkuŋ bi Nyɔ. Mi wichi ka jwɔki i liə kintəəŋ ki ŋkuŋ bi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yi bɔniki alə i bɔɔli bəh nshwaiŋ i dza nyə, yi bɔniki kə i fidzəkəni fi Kiŋwakti ki Bənchi i bi laka kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Yi kɔ a, mi ka bee kpə wi, dzɔ widɔkɔ, ka nɔki bəh wi, yaka wi fə chu. Mi ka dzɔ miŋkpaŋa wə wi buku i mi widɔkɔ dzu, yəmaka numki a wi dzɔ kpə mi.” ");
INSERT INTO cug_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisɔs ka dza chu dzaka a, “Mi wimbum widɔkɔ nì kɔlə, wi lafi gwu bəh bəmbuŋ bə kpɔ wi ləkəli bɔ ndzɔŋ nalə, dzi kidəəŋ ki chɔkɔ bichi. ");
INSERT INTO cug_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Mi wi kifuu widɔkɔ num fɛiŋ, yɛli wi num Lasalus. Wi num biəkə kwa gwu yi yichi. Bə nì dzəki jiəki wi i shiki i dzaka ki mbaiŋ ki mi wimbum wə mə, ");
INSERT INTO cug_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","wi wɔkɔli a yuwidɔkɔ jɔbi wə wi ni dziki, biɛiŋ biə bi ni bɛsiki ma ŋgaiŋ ni bɔŋyiki dziki. Si wi nì nɔki fɛiŋ yakadəiŋ, bíə dzə chu mɛni kaasi lɔ biəkə yi. ");
INSERT INTO cug_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Aka numki i jɔbi widɔkɔ wə, mi wi kifuu wə kpi, bəchinda bə Nyɔ dzə giŋ wi, ka tsə jiə i di bindzɔŋni wə i kɔmsi i Ablaham wə. Ayaka mi wi kpɔ wə ni kpi tə bə ləə wi. ");
INSERT INTO cug_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wi tsə num i tumi ki bəni bə kpili wə, wi ka numki fɛiŋ i ŋgəkə wimbum wə. Wi dza lɔɔ dzəkəh, yɛiŋ Ablaham nanu bəh Lasalus, i wi kpəŋ. ");
INSERT INTO cug_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wi bɔɔŋ tsə a, ‘Ba Ablaham, kwâsi nshɛiŋ i mih, wɔ fâaŋ dzə̂ Lasalus, wi ləkə waiŋkpaŋ wi i mwi mə i dzə̂ də̂si kindɔŋ kəŋŋ yɛiŋ. Mih kɔ i nshili wimbum wə fa i gbuku wələ mə.’ ");
INSERT INTO cug_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ablaham chukuli mfih a, ‘Waiŋ wuŋ, kwaka jɔbi wə wɔ nì kɛiŋki i mbi. Wɔ nì kaŋaki lə biɛiŋ bindzɔŋni bichi i jɔbi wiwɔ, Lasalus nì yɛiŋki mfih num ŋgəkə. I liə akɔ Lasalus wə, wi kɔ i ndzɔŋni mə, wɔ num i nshili wə. ");
INSERT INTO cug_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A kɔkə shəŋ a yələ. Kîə a fəŋ kimbum kɔ num bə kɛiŋsi jiə, kə mi kɔkə i dza fa i daŋsi dzə i wɔ wə fɔkɔ, yi kɔbi tə i mi i dza fɔkɔ i daŋsi dzə fa i buku wə.’ ");
INSERT INTO cug_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Mi wimbum wə chu tsa a, ‘Mintee Ba, fâaŋ Lasalus i kwili wibuku wə. ");
INSERT INTO cug_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Mih kaŋaki bwa bə nih bəŋ bəte, a wi tsə kîŋ i bɔ ka bɔ bi ma dzə̂ tə i di bi ŋgəkə biələ wə.’ ");
INSERT INTO cug_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ablaham chukuli mfih a, ‘Bwa bə nah kaŋaki lə biŋwakti bi Muses, bəh biə bəni bə ntum bə Nyɔ nì nyaka, bɔ wɔ̂kɔli gia yə bi dzakaki.’ ");
INSERT INTO cug_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Mi wi kpɔ wə nəiŋ dzaka a, ‘Aayi Ba Ablaham, yi kɔ a mi widɔkɔ dza i kpi wə, wi tsə fuku i bɔ ka bɔ wɔkɔ, ma bɔ kwuni shɔ́m yibɔ.’ ");
INSERT INTO cug_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ablaham chukuli i wi a, ‘Bɔ ka nəiŋ i wɔkɔ gia yə biŋwakti bi Muses bəh bəni bə ntum bə Nyɔ dzakaki, bɔ kɔkə i wɔkɔ tə na yə mi wə wi dza i kpi wə dzakaki.’” ");
INSERT INTO cug_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisɔs dzaka i bwa bu bə mbaŋ a, “Gia yə yi taaŋki bəni bɔ fə chu bi lansi baaŋ kə i dzə. Ayakalə, ŋgəkə kɔ i mi wə wi bi dzəki bəh gia yiwɔ, a bəni gbɔyiki i chu wə. ");
INSERT INTO cug_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yi ni ndzɔŋki a bə shû shə̂ŋsi nəkə wimbum i məkə ki wəmaka mi, bə chîni shî wi i kinchwɔ kimbum wə, tsə a wi fəki bwa bələ gbɔyiki i chu wə. ");
INSERT INTO cug_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jɔbi wə mbɛiŋ kɔ, mbɛiŋ ka tɔ̂kniki bəh gwu yimbɛiŋ. Jɔbi wə waiŋnah fə gia yichu i wɔ, dzâka i wi. Wi ka kwuni, wɔ dâlinya wi. ");
INSERT INTO cug_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na yaka wi kabə fəki gia yichu i wɔ kiŋkani nanitaŋ i chɔkɔ wə, jɔbi wə wi fəki ka fiəniki dzəki kwuŋki kaŋ a ŋgaiŋ si gbɔ, wɔ kaŋaki i dâlinyaki wi.” ");
INSERT INTO cug_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bwa bə Bah bə ntum ka dzaka i wi a, “Kpɛ̂iŋsi kimbum kibuku ki ləkə ndzɔŋ.” ");
INSERT INTO cug_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Bah chukuli a, “Asi kɔ a mbɛiŋ kaŋaki kimbum ki sɛiŋni aka fintam fi ntɔtɔ, ma mbɛiŋ kɔlə i dzaka i kpɛiŋ wimbum wələ a wi mûku i gaaŋ wə, i tsə̂ nûm i kinchwɔ kimbum wə, ma wi ni wɔkɔ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mbɛiŋ dzɔ̂ a, mi wimu i mbaŋ wimbɛiŋ wə, kabə kaŋa waiŋ wi wi nɔm, wi shi nɔm i khə, yudɔkɔ wi tɔkni bəh shwáŋ. Jɔbi wə wi kwɛ dzə, wɔ kɔlə i dzaka i waiŋ wi nɔm wiwɔ a, wi dzə̂ dzɔ̂ biɛiŋ bi bidzini ma wi num dzî a? ");
INSERT INTO cug_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yi mɔŋ ayaka. Gia yə wi kɔ dzaka akɔ a, kɔmsi tsə̂ kwûni bəmbuŋ ba, ma wɔ fə̂ biɛiŋ biŋ bidzini, ma wɔ dzə̂ bəh bi, ma wɔ kɛ̂iŋsi gwu ya wɔ wɔ̂kɔliki i jɔbi wə, ŋgaiŋ ni dzi, ŋgaiŋ mu kaasi, ka wi juŋni biɛiŋ wi tsə dzi a? ");
INSERT INTO cug_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wɔ kɔlə i dzaka i waiŋ wi nɔm wiwɔ a, kiyɔŋni ka, kɔm wɔ fə gia yichi yə mih si dzaka? ");
INSERT INTO cug_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yi kɔ a liŋ asi yimbɛiŋ kɔ. Jɔbi wə mbɛiŋ fə kaasi nɔm wə bə si nya i mbɛiŋ, mbɛiŋ dzaka a, ‘Buku kɔ shəŋ a bwa bə nɔm, buku fə nɔm wibuku.’” ");
INSERT INTO cug_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Si Jisɔs nì tsəki i Jɛlusalɛm, wi ka tsə dzəh i ji bi kimbu ki Samalia bəh ki Galili wə. ");
INSERT INTO cug_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Si wi tsə liə i kwili widɔkɔ wə, bənyuku bədɔkɔ jwɔfi bɔ gwɛiŋ bəh jwɛiŋ yi kumyini, bɔ yɛiŋ wi kɛiŋ i dzəh yi dəəŋ, ");
INSERT INTO cug_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ka bɔɔŋ bəh ja yiləkəli a, “Jisɔs Tii wi bəni, kwâsi nshɛiŋ i buku wə.” ");
INSERT INTO cug_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Si Jisɔs nì yɛiŋ bɔ, dzaka i bɔ a, “Mbɛiŋ tsə̂ chûsi gwu yimbɛiŋ i bətii mfə gia.” Si bɔ nyə bə́ tsə, jwɛiŋ yibɔ kaa, bɔ baiŋ a kɛiŋ a dzəh. ");
INSERT INTO cug_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Mi wimu i bɔ kintəəŋ yɛiŋ a ŋgaiŋ si bɔnih, wi ka fiəni dzə i Jisɔs ka yaksi Nyɔ nalə. ");
INSERT INTO cug_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Si wi dzə, ka gbɔ i Jisɔs nshiŋ nya kiyɔŋni i wi. Ayaka mi wiwɔ nì kɔ mi wi Samalia. ");
INSERT INTO cug_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisɔs dzaka a, “Bəni si kɔ jwɔfi bə̀ mih si chuku bɔ bɔnih ka baiŋ, bədɔkɔ bə̀ bwukə kɔ faiŋ na? ");
INSERT INTO cug_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yaka kɔ mi widɔkɔ i bɔ ka yɛiŋ dəkə a wi kɔlə i fîəni dzə̂ nyâ kiyɔŋni i Nyɔ, a kɔbi a mi wi dzəni wələ a?” ");
INSERT INTO cug_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisɔs ka dzaka i wi a, “Dzâ wɔ tsə̂ki mfia. Shɔm yə wɔ jiə i mih, yi fə wɔ bɔnih.” ");
INSERT INTO cug_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Bəfalasi bədɔkɔ ka bi dza bikə i Jisɔs a, ŋkuŋ bi Nyɔ bi dzə yibwiŋ na? Wi chukuli i bɔ a, “Ŋkuŋ bi Nyɔ bi dzə kə bəh kinchəsi kə ki bi chusiki i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mi widɔkɔ kɔkə wə wi bi dzakaki i mbɛiŋ a, ‘Mbɛiŋ tsɛ̂iŋ, bə Nyɔ lə wi sakaki fa,’ Na a, ‘Bə Nyɔ yaka wi sakaki fi.’ Mbɛiŋ wɔ̂kɔli ndzɔŋ, ŋkuŋ bi Nyɔ kɔ i kintəəŋ kimbɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wi ka fiəni dzaka lɔ i bwa bu bə mbaŋ a, “Jɔbi bi dzə lə wə mbɛiŋ bi nəŋki i yɛiŋ mi wə yɛli wi kɔ Waiŋmi a i chɔkɔ bimu shəŋ, mbɛiŋ kɔbi i chu yɛiŋ i wi wə. ");
INSERT INTO cug_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A bi numki i jɔbi wiwɔ bəni bədɔkɔ bi dzakaki lə a, ‘Mbɛiŋ tsɛ̂iŋ, bə wi yaka fi,’ Na a, ‘Mbɛiŋ tsɛ̂iŋ, bə wi lə fa.’ Bə ka dzakaki yakadəiŋ i mbɛiŋ kîə mbɛiŋ bi bîəli kə bɔ na i tsə tsɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mbɛiŋ kiə asi dzaŋ si mwaiŋ i bɛiŋ lə mwaŋ bimbu bi mbi binaa bichi baiŋ lə mwaŋŋ bəni bəchi yɛiŋ, akɔ ayaka si bəni bəchi bi yɛiŋ mi wə yɛli wi kɔ Waiŋmi i chɔkɔ biə wi bi fiəni dzəki. ");
INSERT INTO cug_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ayakalə, si wi bi fiəni dzəki, wi bi yisi yɛiŋ lə bəŋgəkə bəduli, i tsə kaasi, ma ŋgɔkɔ wi liə wələ bi məŋni wi. ");
INSERT INTO cug_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Asi yi nì kɔ i jɔbi wi Nɔa wə, lə yi bi numki i jɔbi wi Waiŋmi wə. ");
INSERT INTO cug_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Bəni nì dziki lə, bɔ mu, bəni dzɔ bəkaŋa, bənyuku bəh bəkaŋa nì nyaki lə bwa bəbɔ i bəni i dzɔki, i tsə buku i chɔkɔ biə Nɔa nì liə i ŋgwuki mə, ayaka mwi nì buku dzə laksi bɔ bəchi. ");
INSERT INTO cug_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Yi bi numki a liŋ asi yi nì kɔ i jɔbi wi Lɔt wə. Bəni nì dziki lə, bɔ mu, fə shi yibɔ, nɔm kikhə, chu mwəm júŋ. ");
INSERT INTO cug_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","I chɔkɔ biə Lɔt nì buku i Sɔdɔm, Nyɔ ka shisi gbuku i bɛiŋ, wi ka shiki dzəki bɛli aka miŋkaiŋ migbuku, wi shi dzə kaasi bəni bə Sɔdɔm bəchi. ");
INSERT INTO cug_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Yi bi num a liŋ asi yi bi numki i chɔkɔ biə mi wə yɛli wi kɔ Waiŋmi bi tum buku. ");
INSERT INTO cug_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","A bi numki i chɔkɔ biwɔ wə, mi wə wi kɔ i fwu wi juŋ wə bəh biɛiŋ bi i dzu, wi bi chu fiəni shî lîə kə i dzu a wi dzɔ̂ bi. Yi bi numki a liŋ tə, i mi wə wi kɔ i chwa, wi bi chu kwɛ̂ kə a wi tsə̂ dzɔ̂ biɛiŋ bi. ");
INSERT INTO cug_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mbɛiŋ yiŋti gia yə yi nì num bəh kpə Lɔt. ");
INSERT INTO cug_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mi wə wi nəŋki i tɔkni bəh kiŋ'waka ki a ki ma lâka, wi bi laksi lə ki. Mi wə wi laksi kiŋ'waka ki, wi kɛiŋsi jiə ki. ");
INSERT INTO cug_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mih dzakaki i mbɛiŋ a, a bi numki nchɔkɔ biwɔ, bəni bəfa bi nɔki i naŋ bɛiŋ, ma bə bi dzɔ wimu, widɔkɔ baŋ. ");
INSERT INTO cug_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Bəkaŋa bəfa bi gɔkɔki nyəə i nəkə bɛiŋ, bə bi dzɔ wimu, widɔkɔ bâaŋ.  ");
INSERT INTO cug_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Bənyuku bəfa bi numki i chwa, bə bi dzɔ wimu, widɔkɔ bâaŋ.” ");
INSERT INTO cug_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bwa bu bə mbaŋ ka bikə i wi a, “Bah, gia yiwɔ bi numki, num i faiŋ na?” Wi chukuli num bəh ndi a, “Mbɛiŋ kîəki a di biə kiŋkpili ki fiɛŋ kɔ, akɔ di biə bəŋguluŋ si juŋni.” ");
INSERT INTO cug_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisɔs ka ti ndi widɔkɔ, i bwa bu bə mbaŋ a bɔ ki bɔ̂h kə i tsâki jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Wi dzaka a, “Mi wi sakani bənsaka widɔkɔ nì kɔ i kwili widɔkɔ wə, wi lwa kə Nyɔ, nabə i tsɛiŋ mi a wi kɔ fiɛŋ fidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kpə ŋkwu widɔkɔ num tə i kwili wiwɔ wə. Wi nì shiki tsəki jɔbi wichi wi kwuŋ kaŋ i mi wə wi sakani bənsaka dzaka i wi a, ‘Gâmti mih ma wɔ tə̂iŋ nsaka wuŋ wələ mih kaŋaki bəh mi wələ wi baiŋŋki mih lə.’ ");
INSERT INTO cug_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","I jɔbi wi dəəŋ wə mi wi sakani bənsaka wə jiə kə tunni ki i gia yə kpə ŋkwu wə dzakaki. Wi baaŋ a shiki tsəki a fɛiŋ, i jum wə mi wi sakani bə bənsaka wiwɔ, ka bi kwaka i gwu yi a, ‘Namana yaka mih lwaki kə Nyɔ, mih tsɛiŋ dzə́kəh yi mi yi kpɛiŋni kə i mih, ");
INSERT INTO cug_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ayakalə si kpə ŋkwu wələ nyaki ŋgəkə i mih lə, mih ni yɛiŋ lə a, mih ki sakaki nyaki lə nsaka wi wələ, a kɔbi yaka ma wi ni shiki dzəki nyaki ŋgəkə i mih, ma mi ni kpi i wi kaŋ.’” ");
INSERT INTO cug_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Si Bah ti ndi wiwɔ yakadəiŋ, ka dzaka i bɔ a, “Mbɛiŋ wɔ̂kɔ gia yə mi wə wi sakaki kə bənsaka chəŋ si wi nì dzaka. ");
INSERT INTO cug_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Si wi nì gamti kpə ŋkwu wiwɔ yaka, yaka kɔ Nyɔ tə bi bɔŋ gamti kə mbu bəni bə̀ wi nì sabibwili, bəh bə̀ bɔ dəki i wi nchɔkɔ bəh nshi a? Ma wi bi chu guku gwu a? ");
INSERT INTO cug_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mih fukuki i mbɛiŋ a Nyɔ bi təiŋ lə nsaka wibɔ na ma wi mɔti. Ayaka mi wə yɛli wi kɔ Waiŋmi bi fiəni dzəki, wi bi yɛiŋ lə bəni fa kuku num bɔ jiə shɔm yibɔ i Nyɔ wə a?” ");
INSERT INTO cug_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisɔs dza fiəni ti ndi widɔkɔ a num i bəni bə̀ bɔ ni yɛiŋki gwu yibɔ a bɔ kɔ bəni bə chəŋ, nyɛŋsi bəni bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Wi dzaka a, “Bəni bədɔkɔ bəfa nì yaka tsə liə i juŋ yi fəni yi gia wə i tsa. Mi widɔkɔ nì kɔ mi wi Falasi, widɔkɔ num mi wi kwani kiŋwakti. ");
INSERT INTO cug_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bɔ tsə liə, mi wi Falasi wə tsə num mfih wi mbɔŋ tsa a, ‘Nyɔ, mih nyaki kiyɔŋni i wɔ kɔm mih kɔkə ka bəni bədɔkɔ. Mih bukuki kə bəh dzə́kəh i biɛiŋ wə. Fə kə kimfikili, biəli kə bəkaŋa bə bəni. Mih kɔkə na ka mi wi kwani kiŋwakti wəyaka. ");
INSERT INTO cug_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mih si bam lə dzaka kaŋ yifa i shi wə. I biɛiŋ biŋ bichi biə mi kaŋaki, mih si nya lə fimu i jwɔfi kintəəŋ i wɔ.’ ");
INSERT INTO cug_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ayakalə, mi wi kwani kiŋwakti wə nì num mfih i dzəh yi dəəŋ, wi nəki giŋsi kə shi bi i tsɛiŋ i bɔɔli bɛiŋ, wi chuŋsi fwu wi, ka kwumi tsɛiŋ tsa a, ‘Ɔ Nyɔ, kwâsi nshɛiŋ i mih, kɔm mih kɔ mi wichu.’” ");
INSERT INTO cug_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Si Jisɔs ti ndi wiwɔ yaka, ka dzaka a, “Mih nəŋki i fuku i mbɛiŋ a, mi wi kwani kiŋwakti wələ nì buku ka bə shi tsə i wi dzu wi num chəŋ bəh Nyɔ, a kɔbi ka mi wi Falasi wəyaka. Yi kɔ a liŋ i mi wichi wə wi yaksiki gwu yi, bə bi shisi lə wi, mi wichi wə wi shisiki gwu yi, bə bi yaksiki lə wi.” ");
INSERT INTO cug_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bəni dza ka dzəki bəh bwa bənchiŋ i Jisɔs a wi kɔm bɔ. Si bwa bu bə mbaŋ nì yɛiŋ yaka, ka kaŋyiki bɔ. ");
INSERT INTO cug_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ayakalə, Jisɔs bɔɔŋ bwa bəwɔ a bɔ dzəki, ka dzaka i bwa bu bə mbaŋ a, “Mbɛiŋ bêe ma bwa bənchiŋ bəwɔ dzə̂ki i mih. Kiə mbɛiŋ ki kâŋyi kə bɔ, kɔm ŋkuŋ bi Nyɔ kɔ num i bəni ka bələ. ");
INSERT INTO cug_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mih fukuki ŋkɔŋ i mbɛiŋ a, mi wə wi ka dzɔ̂ dəkə ŋkuŋ bi Nyɔ ka waiŋ wi nchiŋ wələ, wi mɔŋ i bi liə i bi wə.” ");
INSERT INTO cug_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Mi wimbum widɔkɔ bikə i Jisɔs a, “Mi wi lanini wɔ wə wɔ kɔ mi wi ndzɔŋni, gia yə mih kaŋaki i fə̂ ka mih kaŋa nɔni kə ki bi tsə kaa kə, kɔ na nə a?” ");
INSERT INTO cug_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisɔs bikə i wi a, “Wɔ bɔɔŋ mih a mi wi ndzɔŋni kɔm nə? Mi widɔkɔ kɔkə wə wi ndzɔŋki. Akɔ a Nyɔ shəŋ wə wi ndzɔŋki. ");
INSERT INTO cug_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ntə wɔ kiəki lə bənchi bə Nyɔ bə̀ bɔ dzakaki a, ‘Kiə wɔ ki nɔ̂ kə bəh kpə mi, kiə wɔ ki wɔɔ̂ kə mi, kiə wɔ ki chwɔ̂ kə, kiə wɔ ki bêeŋ kə nsaka wi ntəkə’, bəh wə a, ‘Wɔ kɔ̂ksi ba wa bəh nih wa?’” ");
INSERT INTO cug_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wi chukuli a, “Bənchi bələ bəchi kɔ mih nì yisi i jiəki mih kɛiŋ waiŋ sumi.” ");
INSERT INTO cug_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisɔs ni wɔkɔ yakadəiŋ, dzaka i wi a, “Ayaka gia yimu kɛiŋki lə yə yi baaŋ ka wɔ fə. Tsə̂ tâŋni biɛiŋ bia bichi, wɔ gâa kpɔ wiwɔ i bəni bə kifuu, ma wɔ bi ka kwati mbum num i tumi ki Nyɔ wə. Wɔ ka fə yakadəiŋ, wɔ bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wi wɔkɔ yakadəiŋ, gwu kpi wi, kɔm wi nì kaŋaki lə mbum nalə. ");
INSERT INTO cug_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisɔs tsɛiŋ wi lə, ka dzaka a, “Yi ləkəki lə i mi wimbum i liə i ŋkuŋ bi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yi ləkəki lə na bəh ŋga i mi wimbum i liə i ŋkuŋ bi Nyɔ wə, tsə si yi ləkəki i kikum i liə i dzəŋə yi nsala wə.” ");
INSERT INTO cug_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bəni bə̀ bɔ nì wɔkɔ yi, ka bikə a, “Yi kabə num yakadəiŋ, ma ndə bi lansi bɔiŋ a?” ");
INSERT INTO cug_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisɔs chukuli a, “Gia yə yi kɔ i gaka bəni i fə yi kɔkə i gaka Nyɔ i fə.” ");
INSERT INTO cug_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bita dzaka i wi a, “Tsɛ̂iŋ, buku bee biɛiŋ bibuku, ka biəliki wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisɔs chukuli i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mi widɔkɔ kɔkə wə wi bee kwili wi, nabə kpə wi nabə bwa bə nih wi, nabə ba wi bəh nih wi nabə bwa bu kɔm bə ŋkuŋ bi Nyɔ, ");
INSERT INTO cug_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wə wi bi baaŋ i kwati bəni, bəh biɛiŋ biduli i jɔbi wi liə wələ wə tsə biə wi nì bee, i jɔbi wi dzəni wə wi bi baaŋ kə i kwati nɔni kə ki bi tsə kaa kə.” ");
INSERT INTO cug_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisɔs ka dza dzɔ bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ bəfa bəh bɔ baka gwu. Wi dzaka i bɔ a, “Mbɛiŋ wɔ̂kɔli, bukumbɛiŋ si yaka tsə i Jɛlusalɛm jɔbi wə bukumbɛiŋ ni yaka liə fɛiŋ, gia yichi yə bəni bə ntum bə Nyɔ nì nyaka kɔm mi wə yɛli wi kɔ Waiŋmi ni dzə kpɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yi ni ka num a bə ni nya lə wi i kaŋ yi bəni bə dzəni wə, bɔ suŋu wi, bə tɔyi wi, bə chuhyi mindzəŋ i shi bi wə. ");
INSERT INTO cug_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Bɔ ni twɛiŋ wi bə ŋgaŋa, bə wɔɔ wi, a ni num i kaŋa yitali wə, wi ni dza i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jisɔs dzaka yaka, yi fumsi bɔ, bɔ nəki wɔkɔ kiə kə a wi dzakaki a nə, kɔm gia yidɔkɔ nì fə a bɔ ma kiə. ");
INSERT INTO cug_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jɔbi wə Jisɔs nì kɔmsiki tsəki i kwili wi Jɛliku wə, kimfəkə kidɔkɔ num i dzəh kpəŋ nywa biɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wi wɔkɔ si mbaŋ wi bəni nì kɔmki tsəki, wi ka bikə a, a numki dzəki nə? ");
INSERT INTO cug_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bɔ chukuli i wi a, akɔ Jisɔs wi Nasali wi tsəki. ");
INSERT INTO cug_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wi ka yisi i wiliki a, “Jisɔs, waiŋ Ŋkuŋ Dɛbit, kwâsi nshɛiŋ i mih.” ");
INSERT INTO cug_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Bəni bə̀ bɔ nì tsəki i ninshiŋ wam kaŋyi wi dzaka a wi bâŋ. Ayakalə, wi chu fiəni wam na bəh ŋga a, “Waiŋ Ŋkuŋ Dɛbit, kwâsi nshɛiŋ i mih.” ");
INSERT INTO cug_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisɔs ka num, ka dzaka a bə dzə̂ bəh wi. Bə dzə bəh wi, Jisɔs bikə i wi a, ");
INSERT INTO cug_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wɔ nəŋki a mih fə̂ nə i wɔ a?” Wi chukuli a, “Bah, fə̂ ma mih yɛ̂iŋki.” ");
INSERT INTO cug_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jisɔs ka dzaka i wi a, “Yɛ̂iŋ, shɔm ya yə wɔ jiə i mih, yi fə lɔ dzə́kəh ya baiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Akisəkə i jɔbi wiwɔ wə, wi ka fiəni yisi i yɛiŋki di. Wi dza ka biəli Jisɔs, chɔŋyi Nyɔ. Bəni bəchi bə̀ bɔ nì kɔ fɛiŋ yɛiŋ yaka, ka nya kiŋkɔksi i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisɔs nì tsə liə i kwili wi Jɛliku wə, ka tsəki daŋsiki. ");
INSERT INTO cug_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mi widɔkɔ num fɛiŋ yɛli wi num Sakiɔ, a num fwu wi bəni bə̀ bɔ nì kwaki kiŋwakti, wi num tə tii kpɔ. ");
INSERT INTO cug_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wi bə nəŋ i yɛiŋ Jisɔs si wi tsəki. Ayakalə, yi gaka wi kɔm wi ni juliki lə, num mbaŋ wi bəni nì kɔ bɔ baŋ wi. ");
INSERT INTO cug_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wi ka yɔkɔ tsə i ninshiŋ, ka tsə yaka i kpɛiŋ widɔkɔ bɛiŋ, i yɛiŋ Jisɔs si wi tsəki, kɔm wi nì kaŋaki i tsə dzəh fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisɔs ka tsə buku fɛiŋ, lɔɔ yaka dzəkəh yi i bɛiŋ ka yɛiŋ ka bɔɔŋ “Sakiɔ, shî dzə̂ wakli, kɔm mih kaŋaki i nɔ i wɔ dzu daiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wi ka kɔmsi shi i kpɛiŋ wiwɔ wə, ka dzɔ Jisɔs bəh kinsaŋli. ");
INSERT INTO cug_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bəni bəchi bə̀ bɔ nì yɛiŋ si Jisɔs nì tsəki bəh wi ka yisi i shwiŋyiki dzakaki a, “Mi wələ tsəki i tsə nɔ bəh mi wichu.” ");
INSERT INTO cug_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bɔ tsə num, Sakiɔ ka dza num i bɛiŋ ka dzaka i Jisɔs a, “Bah, tsɛ̂iŋ yɛ̂iŋ, mih ki gaaliki lə biɛiŋ biŋ i fintəŋ mih nya i bəni bə kifuu. Aka num a, mih nì fə kimfikili i mi widɔkɔ, mi ni fiəni nya kiŋkani kinaa i wi.” ");
INSERT INTO cug_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisɔs wɔkɔ yakadəiŋ, ka dzaka i wi a, “Daiŋ mbɔiŋ dzə lɔ yaa dzu i bəni bələ, kɔm tikwili wələ kɔ tə waiŋ Ablaham. ");
INSERT INTO cug_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mi wə yɛli wi kɔ Waiŋmi nì dzə i nəŋ num bəni bə̀ bɔ laka, bəh i bwili bɔ.” ");
INSERT INTO cug_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Si bəni nì wɔkɔliki si Jisɔs nì dzakaki gia yələ, wi ka dza kini tsə ninshiŋ ti ndi widɔkɔ i bɔ, kɔm a nì baaŋ a twɛsi i wi i liə i Jɛlusalɛm, bəni nì kwakaki a, jɔbi widɔkɔ Nyɔ si num i yisi i sakaki ŋkuŋ bi. ");
INSERT INTO cug_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wi dzaka a, “A nì kɔ jɔbi widɔkɔ, waiŋ ŋkuŋ widɔkɔ nì bee tumi kibɔ ka tsəki i tumi ki dzəh yi dəəŋ wə a bə tsə̂ tɔ̂m wi i ŋkuŋ, ka wi ni fiə̂ni dzə̂ sâkaki ŋkuŋ bi. ");
INSERT INTO cug_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Si wi nì nəŋki i nyə, wi bɔɔŋ bwa bu bə nɔm jwɔfi, ka gaa kpɔ i bɔ kiba kiba, dzaka a, ‘Mbɛiŋ kɔ̂ mbɛiŋ bâaŋ fə̂ki shi yɛiŋ, i tsə buku i jɔbi wə mih bi fiəni dzə.’ ");
INSERT INTO cug_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wi ka nyə, ayakalə bəni bə tumi kiwɔ nì baiŋŋki wi nalə. Bɔ ka baaŋ faaŋ bəni i wi jum a bɔ tsə̂ dzâka a bɔ kɔŋki kə a mi wiwɔ nûmki ŋkuŋ wibɔ. ");
INSERT INTO cug_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Bə tsə tɔm a wi tɔmni. Wi ka fiəni i jum wə, ka bɔɔŋ bwa bu bə nɔm bə̀ wi nì gaa kpɔ wə i bɔ a ŋgaiŋ yɛiŋ mbee wə bɔ nì baaŋ ka fəki shi. ");
INSERT INTO cug_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Wi ninshiŋ nì dzə dzaka a, ‘Tikwili, kiba ka ki kpɔ kə wɔ nì nya i mih, mih baaŋ ka kwati mbee yɛiŋ biba jwɔfi.’ ");
INSERT INTO cug_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wi wɔkɔ ndzɔŋni, ka nya kiyɔŋni i wi ka dzaka a, ‘Wɔ kɔ waiŋ wi nɔm wi ndzɔŋni. Si wɔ nì baaŋ ka kiə i tɔkniki bəh fiɛŋ finchiŋ nalə, mih ni jiə lə wɔ a wɔ sâkaki bidi jwɔfi.’ ");
INSERT INTO cug_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ayaka wi kɔmsini dzə dzaka a, ‘Tikwili, kiba ka ki kpɔ kə wɔ nì nya i mih, mih nì baaŋ ka kwati mbee yɛiŋ biba bite.’ ");
INSERT INTO cug_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wi dzaka i wi a, ‘Mih jiə wɔ, a wɔ sâkaki bidi bite.’ ");
INSERT INTO cug_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Waiŋ wi nɔm widɔkɔ wə nì dzaka mfih a, ‘Tikwili, kiba ka ki kpɔ kələ fa, mih nì baaŋ ka kaŋa i kinchumni kimbuŋ wə ka jiə. ");
INSERT INTO cug_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mih nì jiə kɔm wɔ kɔ mi wiləkəli, mih lwa wɔ. Wɔ dzɔki lə maka wɔ jiə, i jɔbi widɔkɔ wə wɔ kɔh maka wɔ gbɛli fiɛŋ.’ ");
INSERT INTO cug_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Tikwili wə dzaka i wi a, ‘Wɔ kɔ waiŋ wichu. Ndzaka wə wi bukuki i dzaka ka wə, akɔ wə mih ni dzɔ i saka wɔ yɛiŋ. Wɔ nì kiəki a mih kɔ mi wi ləkəli a mih dzɔki lə biɛiŋ maka mih jiə, a mih kɔhki lə biɛiŋ maka mih gbɛli. ");
INSERT INTO cug_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Wɔ nì kiəki yaka, a fə nə a wɔ dzɔ kpɔ wuŋ i tsə jiə i juŋ yə bə jiəki kpɔ yɛiŋ wə, ka jɔbi wə mih fiəni dzə ma mih ni dzə kwati mbee yɛiŋ?’ ");
INSERT INTO cug_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wi ka dzaka i bəni bə̀ bɔ nì num kɔmsi i wi wə a, ‘Mbɛiŋ dzɔ̂ kiba ki kpɔ kiwɔ i wi, mbɛiŋ nyâ i wə wi kaŋaki biba bi kpɔ jwɔfi.’ ");
INSERT INTO cug_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Bɔ ka fiəni dzaka lɔ a, ‘Tikwili, wi si kaŋaki lə biba bi kpɔ jwɔfi.’ ");
INSERT INTO cug_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wi dzaka a, ‘Mih fukuki i mbɛiŋ a mi wə wi kaŋaki biɛiŋ biduli bə ni kpɛiŋsi lə. Ayaka mi wə wi kaŋaki kə, na fi twɛsi fiə wi kaŋaki bə ni dzɔ bwili lə i wi. ");
INSERT INTO cug_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","I liə, bəni bə̀ bɔ nì baiŋŋki mih, ka nəiŋki a mih kɔkə i numki ŋkuŋ wibɔ, mbɛiŋ tsə̂ dzɔ̂ dzə̂ bəh bɔ ma mbɛiŋ wɔ̂ɔyi i mih nshiŋ.’” ");
INSERT INTO cug_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Asi Jisɔs nì dzaka gia yiwɔ, ka dza bee bɔ i jum wə ka tsə i ninshiŋ i yaka tsə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jɔbi wə wi nì kɔmsi tsə i kwili wi Bɛtfajə bəh wi Bɛtani wə wi nì kɔmsiki i ŋkwuŋ wi Ɔlif wə, wi ka faaŋ bwa bu bə mbaŋ bədɔkɔ bəfa, ");
INSERT INTO cug_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ka dzaka a, “Mbɛiŋ tsə̂ i kwili wi ninshiŋ wəyaka wə, mbɛiŋ ni yɛiŋ waiŋ njakas num bə shu, maka mi num yaka yɛiŋ bɛiŋ, mbɛiŋ shwâli dzə̂ bəh yi fa. ");
INSERT INTO cug_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mi widɔkɔ ka bikə a mbɛiŋ shwaki yi kɔm nə, mbɛiŋ chukuli a Bah kaŋaki lə nɔm bəh yi.” ");
INSERT INTO cug_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Bwa bə mbaŋ bə̀ tsə yɛiŋ gia yichi a liŋ asi wi si dzaka. ");
INSERT INTO cug_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jɔbi wə bɔ nì shwaki waiŋ njakas wiwɔ, mi wə wi nì kaŋaki yi, ka bikə i bɔ a, “Mbɛiŋ shwaki waiŋ njakas wə kɔm nə a?” ");
INSERT INTO cug_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bɔ chukuli a, “Tikwili nəŋki yi.” ");
INSERT INTO cug_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Bɔ ka dzɔ dzə bəh yi i Jisɔs, jiə bəmbuŋ bəbɔ i njakas yiwɔ wə, ka yaksi Jisɔs i yi bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Si wi nì tsəki, bəni ka tɔkɔki bəmbuŋ bəbɔ i dzəh, a wi tsə i yɛiŋ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","I jɔbi wə wi nì dzə buku, i shiki tsəki i ŋkwuŋ wi Ɔlif wə, mbaŋ wi bəni bu bə mbaŋ yisi ka wiliki yaksi Nyɔ bəh ŋga kɔm bə gia yi kaiŋyini yichi yə bɔ nì yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Bɔ ka wiliki dzaka a, “Nyɔ kɔ wi bɔiŋsi Ŋkuŋ wə wi dzəki i yɛli wi Bah wə. Kimbɔiŋni kɔ i bɛiŋ, kiŋkɔkni num ki Nyɔ wə bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bəfalasi bədɔkɔ bə̀ bɔ nì kɔ i mbaŋ kintəəŋ ka dza dzaka i Jisɔs a, “Mi wi lanini, dzâka i bəni ba bə mbaŋ bələ a bɔ kpîchumi.” ");
INSERT INTO cug_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisɔs chukuli a, “Mih fukuki i mbɛiŋ a, bɔ ka kpichumi, na ma kitəh kələ ni wiliki.” ");
INSERT INTO cug_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","I jɔbi wə Jisɔs nì kɔmsi tsə i Jɛlusalɛm, wi tsɛiŋ kwili wiwɔ lə, ka gbɔ mindəm, ");
INSERT INTO cug_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ka dzaka, “Ɔ Jɛlusalɛm, mbɛiŋ bələ si kiəki na gia yə yi kɔ i dzə bəh kimbɔiŋni i mbɛiŋ wə i chɔkɔ bidaiŋ. Ayakalə, i liə mbɛiŋ kɔkə i kiə dəkə. ");
INSERT INTO cug_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mbɛiŋ kiəki a jɔbi bi dzə lə wə bəni bəmbɛiŋ bə̀ bɔ baiŋŋki mbɛiŋ bi dzə maa tali mbiaŋ wi fiəli baŋ mbɛiŋ i fintəŋ. ");
INSERT INTO cug_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Bɔ bi bəkəliki lə mbɛiŋ na bəh bwa bəmbɛiŋ, shakyi júŋ yimbɛiŋ, na təh widɔkɔ bi chu baaŋ kə i widɔkɔ bɛiŋ. Yi bi num yaka kɔm mbɛiŋ nì kiəki kə jɔbi wə Nyɔ bi dzə i mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisɔs tsə i tɔkɔ wi juŋ yi fəni yi gia wə, ka yisi i kɔŋŋki bəni bə̀ bɔ nì taŋniki biɛiŋ fɛiŋ, ");
INSERT INTO cug_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ka dzakaki i bɔ a, “Yi kɔ num bə nyaka a, Nyɔ dzaka a, ‘Juŋ yiŋ kɔ num juŋ yi tsani.’ Ayakalə, mbɛiŋ fiəni yi, yi chu ‘Taa wi bəji.’” ");
INSERT INTO cug_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jisɔs bə́ shi wi lani bəni i tɔkɔ wi juŋ yi fəni yi gia wə chɔkɔ bichi. Bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ bəh bəni bəmbum bə̀ fɛiŋ ka wɛɛliki i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ayakalə, bɔ nəki kaŋa kə dzəh, kɔm bəni bəchi nì kɔ kɔmsi a Jisɔs wə, kɔm bɔ nì kɔŋki kə a gia yə wi laniki, a yimu ma tsə̂ bɔ. ");
INSERT INTO cug_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A num chɔkɔ bidɔkɔ, Jisɔs num i juŋ yi fəni yi gia mə wi lani bəni, chu fuku ntum wi ndzɔŋni i bɔ kɔm Nyɔ, bətii mfə gia bəmbum, bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ, bəh bəni bə̀ bɔ sakaki tumi ki Bəju dzə, ");
INSERT INTO cug_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ka bikə i wi a, “Fûku i buku, mi wə wi nya ŋga biələ i wɔ a fə̂ki gia yələ a? A nya ndə ŋga biwɔ i wɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jisɔs chukuli i bɔ a, “Mih tə ki bikəki lə kimbikə i mbɛiŋ. Mbɛiŋ fûku mih i liə. ");
INSERT INTO cug_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","A nì nya ndə ŋga i Jɔn na ka wi jûliki bəni i bɔkɔ a? Bi nì nyə i bɛiŋ, ma a nì nya mi wiwɔm a?” ");
INSERT INTO cug_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bɔ ka dzaka a bɔ bɔ a, “Bukumbɛiŋ ka chukuli a, bi nì nyə i bɛiŋ, ma wi ni bikə i bukumbɛiŋ a, aka fə nə a bukumbɛiŋ ma bum i Jɔn a? ");
INSERT INTO cug_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bukumbɛiŋ ka chukuli a, a nì nya mi wiwɔm, ma mbaŋ wi bəni bələ fa ni tumyi bukumbɛiŋ bəh kitəh, kɔm bɔ bəchi nì bum ŋkɔŋ ŋkɔŋ a, Jɔn nì kɔ mi wi ntum wi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ayakadəiŋ, bɔ ka chukuli a, “Buku kiəki kə mi wə wi nì nya ŋga biwɔ.” ");
INSERT INTO cug_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jisɔs ka dzaka i bɔ a, “Yaka mih tə ki fukuki kə i mbɛiŋ mi wə wi nya ŋga biwɔ i mih a mih fə̂ki gia yələ.” ");
INSERT INTO cug_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisɔs ka yisi i tiki ndi widɔkɔ i bəni a, “Mi widɔkɔ nì nɔm khə wi mintam wə bə kɛiŋsiki mbih yɛiŋ. Ka nya khə wiwɔ i bəni, ka nyə tsə i tumi kidɔkɔ wə, i tsə nɔ dzɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jɔbi wə bɔ nì kaŋaki i yisi ŋkɔh dzə kpɛiŋ, tii khə wiwɔ ka faaŋ waiŋ wi wi nɔm, a wi tsə̂ dzɔ̂ mmu mintam i bɔ. Wi tsə, ayakalə, bəni bə̀ bə nì nya khə i bɔ, twɛiŋ wi kɔŋŋ fiəni wi bəh kaŋ yiyəə. ");
INSERT INTO cug_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Mi wiwɔ chu faaŋ waiŋ wi wi nɔm widɔkɔ, ayakalə bɔ chu twɛiŋ wi, ŋgəmsi wi, kɔŋ fiəni wi bəh kaŋ yiyəə. ");
INSERT INTO cug_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mi wiwɔ ka chu faaŋ kpɛiŋsi kiŋkɔmsi kitali widɔkɔ i bɔ, bɔ bɛiŋsi wi, lɔɔ bwili wi i biŋ. ");
INSERT INTO cug_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tii khə wiwɔ kwaka a, ‘Mih ki fəki na dəiŋ a? Mih ki faaŋki i liə num waiŋ wuŋ wi shɔm. Yudɔkɔ bɔ kɔlə i ni kɔ̂ksi wi.’ ");
INSERT INTO cug_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ayakalə, jɔbi wə bəni bə nɔm bə̀ wi nì nya khə i bɔ yɛiŋ waiŋ wiwɔ dzə, bɔ ka yisi i dzakayiki a bɔ bɔ a, ‘Wələ kɔ ndzi kwili wi tii khə wələ. Mbɛiŋ dzə̂ ma bukumbɛiŋ wɔ̂ɔ wi ka biɛiŋ biwɔ nûmki bibukumbɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ayaka bɔ kwa kuku buku bəh wi yɛiŋ khə ka wɔɔ.” Si Jisɔs dzaka yakadəiŋ, ka bikə a, “Mbɛiŋ kwakaki a, mi wi khə wə ni dzə fə dəiŋ bəh bəni bəwɔ a? ");
INSERT INTO cug_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mih fukuki i mbɛiŋ a, wi bi dzə kaasi lə bəni bəwɔ, wi nya khə wiwɔ num i bəni bədɔkɔ chi chi.” Si bəni bəwɔ ni wɔkɔ yakadəiŋ, ka nəiŋ, dzaka a, “Nyɔ bâŋ dzəh yiwɔ.” ");
INSERT INTO cug_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisɔs tsɛiŋ bɔ lə, bikə a, “Yaka kɔ a gia yə bə nyaka i Kiŋwakti ki Nyɔ wə, dzakaki a nə, ‘A təh wə bəni bə maani nì nəiŋ, wi fiəni chu num na təh wi bu wi juŋ wi ndzɔŋni a?’ ");
INSERT INTO cug_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na ndə wə wi bi gbɔki i təh wiwɔ wə, wi mi wiwɔ bi shakyi i biŋka wə, ayaka təh wiwɔ ka bi gbɔ i mi bɛiŋ, ma wi ni gɔksi wi i kwɔŋɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Si Jisɔs ti ndi wiwɔ yakadəiŋ, bəni bə̀ bɔ laniki bənchi bə Nyɔ bəh bətii mfə gia bəmbum ka nəŋki a bɔ kwâ wi fɛiŋ akisəkə. Bɔ nì nəŋki i kwa wi kɔm bɔ nì kɔ bɔ wɔkɔ kiə a wi si ti ndi wiwɔ num i bɔ, ayakalə bɔ ka lwa gaka bəni. ");
INSERT INTO cug_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Bɔ yisi i biəliki gvu yi, taŋyi bəni bədɔkɔ faaŋ bɔ, a bɔ tsə̂ kwâyiki fə̂ki a bɔ kɔ bəni bə ndzɔŋni. Bɔ ni fə lə i kwâ gia yi kintəŋsi i dzaka ki wə. Ka bɔ ni kwa nya wi i kaŋ yi bəni bə̀ bɔ sakaki tumi i kimbu ki Lum wə. ");
INSERT INTO cug_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Bəni bəwɔ dza ka bikə i Jisɔs a, “Mi wi lanini, buku kiəki lə a gia yə wɔ dzakaki bəh yə wɔ laniki kɔ na gia yi chəŋ, wɔ tsɛiŋ kə mi i dzə́kəh wə. Wɔ lani gia yi ŋkɔŋ yə Nyɔ nəŋki a bəni fəki. ");
INSERT INTO cug_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","I liə fûku i buku, jɔbi widɔkɔ bənchi bəbukumbɛiŋ bumki lə a, bə gɔ̂mki kiŋwakti i Kaysa ŋkuŋ wi Lum, ma bə ma gɔ̂mki a?” ");
INSERT INTO cug_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jisɔs kiə gia yə bɔ wɛɛliki bəh yi, ka dzaka a, ");
INSERT INTO cug_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mbɛiŋ dzə̂ bəh kpɔ wə mbɛiŋ si lɔɔ kiŋwakti yɛiŋ mih yɛiŋ.” Bɔ dzə bəh wi, wi bikə a, “Fwu wələ wi kɔ yɛiŋ kɔ wi ndə, yɛli wələ num wi ndə a?” Ayaka bɔ chukuli a, “Akɔ wi Kaysa, yɛli num ŋ'wi.” ");
INSERT INTO cug_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jisɔs ka dzaka a, “Mbɛiŋ ka nyâki i Kaysa fiɛŋ fiə fi kɔ fi Kaysa, nyâ i Nyɔ fiə fi kɔ fi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Bəni bəwɔ wɔkɔ gia yiwɔ yaka yi fumsi bɔ, bɔ baŋ dzaka kibɔ nəki kwati kə dzəh yə bɔ si kɔ i kwa wi fɛiŋ i bəni kintəəŋ. Dzaka bə́ wɔm bɔ i gia yə wi si dzaka. ");
INSERT INTO cug_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Bəni bədɔkɔ i mbaŋ wi Bəsadusi wə nì dza dzə i bikə gia i Jisɔs. Bəsadusi bələ nì kɔ bəni bə̀ bɔ nì dzaka a bəni bi fiəni dzayiki kə i kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bɔ nì dzə ka bikə i Jisɔs a, “Mi wi lanini, Muses nì nyaka i bənchi i buku a, ‘Mi ka kpi bee kpə wi, maka bɔ wi bwɔ waiŋ, waiŋnih wi kaŋaki lə i nɔ̂si kpə ŋkwu wiwɔ, ma bɔ wi bwɔ bwa i yɛli wi ŋkwu wiwɔ.’ ");
INSERT INTO cug_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","I liə, bwa bə mi widɔkɔ nì kɔlə nanitaŋ, wi ninshiŋ bi dzɔ miŋkpaŋa, dzə kpi waiŋ kɔbi. ");
INSERT INTO cug_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Wi kɔmsini wə nɔsi miŋkpaŋa wiwɔ, ka kpi tə maka bɔ wi bwɔ waiŋ. ");
INSERT INTO cug_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Wə wi biəliki wəmaka bɔŋ nɔsi tə miŋkpaŋa wiwɔ, ka dzə kpi tə waiŋ kɔbi. Ayaka yi bi num tali ayaka i bwa bəwɔ nanitaŋ bəchi, mi i bɔ kintəəŋ nəki bwɔ kə waiŋ bəh miŋkpaŋa wiwɔ. ");
INSERT INTO cug_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","I kiŋgɔksi wə miŋkpaŋa wiwɔ bɔŋ kpi tə. ");
INSERT INTO cug_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","I liə si bɔ bəchi nanitaŋ nì kɔ bɔ nɔsi lɔ miŋkpaŋa wiwɔ, a bi numki i jɔbi wə bəni bi fiəni dzayiki i kpi wə, ma wi bi numki kpə ndə a?” ");
INSERT INTO cug_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisɔs chukuli i bɔ a, “I mbi wi liə bənyuku bəh bəkaŋa dzɔki lə gwu yibɔ, bəni nya bwa bəbɔ bɔ dzɔ gwu yibɔ. ");
INSERT INTO cug_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ayakalə, bəni bə̀ bɔ kpɛiŋniki i bi kwati di i mbi wi dzəni wə i chɔkɔ biə bəni bi dzayiki i kpi wə, bɔ bi chu dzɔ kə bəkaŋa bəh bənyuku. Bəni bi chu nya kə bwa bəbɔ i bənyuku bəh i bəkaŋa. ");
INSERT INTO cug_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Bɔ bi chu kpi kə kɔm bɔ bi numki aka bəchinda bə Nyɔ. Bɔ kɔ bwa bə Nyɔ kɔm bɔ dzayi lɔ i kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Gia yi ŋkɔŋ kɔ a, na Muses mwi nì fuku baiŋsi yi a bəni bi dzayiki lə i kpi wə si wi nì nyaka i di bi kiŋwakti biə bi dzakaki kɔm kpɛiŋ wə wi nì bɛliki. Wi bɔɔŋki Bah i di bi kiŋwakti kiwɔ a, wi kɔ Nyɔ wi Ablaham, bəh wi Ayjik bəh wi Yakɔb. ");
INSERT INTO cug_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wi kabə bɔɔŋki yakadəiŋ, yaka kɔ bəŋkwu bələ kɔ bəwɔm, Nyɔ kɔkə wi bəni bə kpili, a num kə Nyɔ wi bəni bəwɔm, i wi bəni bəchi kɔ bəwɔm.” ");
INSERT INTO cug_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Si Jisɔs dzaka yakadəiŋ, bəni bə̀ bɔ nì laniki bənchi bə Nyɔ kɔksi wi, chukuli a, “Mi wi lanini, wɔ chukuli yi chəŋ.” ");
INSERT INTO cug_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ayakadəiŋ, mi i bɔ nəki chu mɔm kə i bikə kimbikə kidɔkɔ i wi. ");
INSERT INTO cug_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisɔs ka dza bikə i bɔ a, “Bəni nyani dəiŋ i dzakaki a, Kimbwili wə Nyɔ nì kaka, numki waiŋ Ŋkuŋ Dɛbit a? ");
INSERT INTO cug_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ntə mbɛiŋ kiəki lə a Dɛbit mwi nì nyaka i Kiŋwakti ki N'yaksi wə a, ‘Bah Nyɔ nì dzaka i Bah wuŋ a, “Shînum i tsɛiŋ yiŋ yiləkəli wə, ");
INSERT INTO cug_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","i tsə̂ bûku jɔbi wə mih bi nɔsi bəni bə̀ bɔ baiŋŋki wɔ i wɔ nshiŋ, ma wɔ tɔmyi gvu ya i bɔ bɛiŋ ka kiŋgbɔkɔ ka kigvu.”’ ");
INSERT INTO cug_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dɛbit kabə bɔɔŋki wi a Bah wi, wi chu nyani dəiŋ ka wi numki waiŋ wi a?” ");
INSERT INTO cug_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jisɔs ka dza dzaka i bwa bu bə mbaŋ bəh bəni bəchi bə̀ bɔ nì kɔ fɛiŋ wɔkɔli gia yə wi dzakaki a, ");
INSERT INTO cug_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mbɛiŋ tɔ̂kniki, kɔm bə bəni bə̀ bɔ laniki bənchi bə Nyɔ, bɔ kɔŋki i nyaniki nnyaki bəh bəmbuŋ bədəəŋ. Ayaka chu kɔŋ a, bəni bɔniki bɔ bəh kiŋkɔksi i di bi shi wə. Chu kɔŋ i nûmki i di bi kɔksini i juŋ yi tsani wə, bəh i di bi bini wə. ");
INSERT INTO cug_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","A chu num a bɔ bə̀ bɔ laksiki biɛiŋ bi bəkaŋa bəŋkwu, fwɔkyi dzɔ biɛiŋ bibɔ, kwayi fə bəntsa bədəəŋ. Bəni bələ kɔ ŋgəkə wibɔ bi numki na wimbum.” ");
INSERT INTO cug_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisɔs dza lɔɔ dzə́kəh, yɛiŋ si bəni bə kpɔ jiəki kinya kibɔ i kintaiŋntaiŋ kinya mə i juŋ yi fəni yi gia mə. ");
INSERT INTO cug_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wi yɛiŋ si kpə ŋkwu wi kifuu widɔkɔ jiəki bədəli bəfa i kintaiŋntaiŋ kinya mə. ");
INSERT INTO cug_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wi ka dzaka a, “Mih fukuki ŋkɔŋ i mbɛiŋ a kpə ŋkwu wələ wə wi kɔ mi wi kifuu lə wi nya tsə bəni bəchi bə̀ bɔ si nyaki. ");
INSERT INTO cug_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Bəni bəchi bə̀ bɔ si nyaki, bɔ si nyaki num biŋka bibɔ bi kpɔ biə bi si jikə ka gbɔyiki kuku. Ayakalə, kpaŋa wələ si wi kɔ na kifuu kifuu lə, wi si nya na biɛiŋ bichi biə wi nɔki yɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Bwa bə Jisɔs bə mbaŋ bədɔkɔ nì dza ka dzakaki kɔm bə juŋ yi fəni yi gia, si yi ndzɔŋki bəh kitəh kindzɔŋni kə bə nì maa yɛiŋ, bəh kinya kiwɔ i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Jisɔs dzaka i bɔ a, mbɛiŋ yɛiŋ biɛiŋ biələ a? Chɔkɔ dzəki lə wə təh wimu bi baaŋ kə i widɔkɔ bɛiŋ maka bə baka tɔkɔ wi i kuku, na winaiŋ təh bi numki i di bi wə.” ");
INSERT INTO cug_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bɔ bikə i wi a, “Mi wi lanini, gia yələ bi numki i jɔbi winaiŋ wə a? Kinchəsi kə ki bi chusiki a yi si num a gvu wə akɔ nə?” ");
INSERT INTO cug_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisɔs chukuli a, “Mbɛiŋ tɔ̂kniki, ka mi bi ma fwɔ̂kyi mbɛiŋ a mbɛiŋ ndzâni dzəh. Mbɛiŋ kîəki a bəni bəduli bi dzə lə dzɔ yɛli wuŋ kəŋ i ninshiŋ, ma mi bi dzakaki a, akɔ ŋgaiŋ Kimbwili, a jɔbi dzə kpɛiŋ lɔ. Jɔbi wə bɔ bi dzakaki yaka, kîə mbɛiŋ bi wɔ̂kɔli kə. ");
INSERT INTO cug_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jɔbi wə mbɛiŋ bi wɔkɔki a bə tumki júm bəh bəŋgəkə i bidi bidi wə, kiə mbɛiŋ ki lwâ kə, gia yələ kaŋaki lə i bi yisi nûm, ayakalə, yi kɔbi a kiŋgɔksi ki mbi dzə lɔ.” ");
INSERT INTO cug_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jisɔs chu dzaka i bɔ a, “Tumi bi tumki lə jum bəh kidɔkɔ, ayaka ntɔŋ widɔkɔ tum jum bəh widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gia yi gumini bi numki lə i di di wə. Nshwaiŋ bi nəŋniki na bəh ŋga. Dzɔŋ bi numki lə, ma jwɛiŋ bi numki i bidi bichi wə. Bənchəsi bə̀ bɔ gumiki bi chusiki lə i bɔɔli wə nya nlwa i bəni. ");
INSERT INTO cug_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Mbɛiŋ kîəki a gia yələ bi dzə i num, num bə kwâ mbɛiŋ, njə̂ŋsi nnyâ mbɛiŋ. Bə bi tsə bəh mbɛiŋ i juŋ yi nsaka wə, bəh i juŋ yi tsani wə, i chiŋsi mbɛiŋ i juŋ yi nsəŋ wə. Bə bi fiəni dzɔ mbɛiŋ kɔm bə yɛli wuŋ, bə tsə bəh mbɛiŋ i bəŋkuŋ nshiŋ bəh i bəni bə̀ bɔ sakaki bitumi, ");
INSERT INTO cug_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","wəmaka bi numki jɔbi ka mbɛiŋ fukuki i bɔ kɔm mih. ");
INSERT INTO cug_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jɔbi wə bə bi dzɔ mbɛiŋ yaka, mbɛiŋ ki twɛ̂iŋ kə gwu a mbɛiŋ ni tsə dzaka a nə a, ");
INSERT INTO cug_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","kɔm a ni nya mih gia i dzaka kimbɛiŋ wə, bəh mfi i mbɛiŋ, ka bəni bə̀ bɔ baiŋŋki mbɛiŋ ma bi chu num i gukuliki bəh mbɛiŋ na twɛsi. ");
INSERT INTO cug_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bəni bə̀ bɔ bi taŋniki mbɛiŋ, bi numki bətii bəmbɛiŋ bəh bənih bəmbɛiŋ, bəh bwa bə nih bəmbɛiŋ, bəh na chwɔŋkijuŋ kimbɛiŋ mwi, bəh nsɛiŋ yimbɛiŋ. A bi numki bɔ bədɔkɔ, bɔ bi wɔɔyiki mbɛiŋ bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Bəni bəchi bi baiŋŋki lə mbɛiŋ kɔm yɛli wuŋ. ");
INSERT INTO cug_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ayakalə, na juŋ yi fwu yimu i mbɛiŋ fuŋ bi laka kə i fwu wimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mbɛiŋ kâŋa shɔ́m yimbɛiŋ bindzɔŋ, ma mbɛiŋ bi kwati nɔni. ");
INSERT INTO cug_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jɔbi wə mbɛiŋ bi yɛiŋki bəni bə jum bɔ fiəli tali kwili wi Jɛlusalɛm, mbɛiŋ ka kîəki a jɔbi dzə kpɛiŋ i kaasi ki. ");
INSERT INTO cug_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yi bi ka num yaka, bəni bə̀ bɔ kɔ i Judea bi gɛ̂iŋ yâka i ŋkwúŋ wə, bə̀ bɔ kɔ i kwili kiwɔ kintəəŋ bi bûkuyi. Mi wə wi kɔ i chwa bi chu tsə̂ lîə kə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kaŋ yiwɔ kɔ yə Nyɔ bi lɔɔki ŋgəkə i Jɛlusalɛm wə kɔm bə nɔni kibɔ, yi fə gia yichi dzə kpɛiŋ asi bə nì nyaka i kiŋwakti ki wə. ");
INSERT INTO cug_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ŋgəkə wimbum bi numki wi bəkaŋa bə̀ bɔ bi numki bəh kitɔɔ, bəh bə̀ bɔ masiki bwa. Nyɔ bi bɔksiki lə shɔ́m bəh bəni bələ, wi faaŋ ŋgəkə wimbum i tumi kələ wə. ");
INSERT INTO cug_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Bə bi gbayiki lə bəni bədɔkɔ bəh bənywɔ, bə kwayi bədɔkɔ tsə fah i nsəŋ wə i tumi bichi wə ka bəni bə̀ bə tumdzi i jum chɛiŋ. Bəni bə̀ bɔ kɔkə Bəju bi yaka i Jɛlusalɛm, i tsə buku asi jɔbi wibɔ bi kpɛŋki. ");
INSERT INTO cug_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Gia yi kaiŋni bəh bənchəsi bi chusiki lə i wɔŋ wə bəh i fiəŋŋ wə bəh i bijɔŋ wə, bəh i nshwaiŋ wə si bitumi bi numki i nshili wə, bə bi gɛsiki numki alə si kinchwɔ kimbum chɔkɔki yi fɛɛ lə wɔɔɔ. ");
INSERT INTO cug_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bəni bi kpiki bəh ndzaŋ i gia yi gumini yə yi dzəki i mbi wə kɔm ŋga bi nshwaiŋ bi nəŋniki lə kəkəkə. Kɔm biɛiŋ biə bi kɔ bɛiŋ bichi bi nəŋniki lə bəh ŋga nalə. ");
INSERT INTO cug_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ayakadəiŋ, bəni bi ka yɛiŋ si mi wə yɛli wi kɔ Waiŋmi shiki dzəki i bikwu wə kaŋa ŋga bəh kiŋkɔkni kimbum. ");
INSERT INTO cug_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jɔbi wə gia yələ bi yisi i numki, mbɛiŋ ka bi nûmki tsɛ̂iŋ yaka a bɛiŋ, kɔm jɔbi wə Nyɔ kɔ i bwili mbɛiŋ, si num kɔmsi dzə.” ");
INSERT INTO cug_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Si Jisɔs dzaka yakadəiŋ, ka chukuli i ndi wə a, “Mbɛiŋ lâni dzɔ̂ gia i kpɛiŋ wi fidəiŋ wə, bəh kɛiŋ yidɔkɔ, si yi fiəni nyaki ndzɛni bibɔ, ");
INSERT INTO cug_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","mbɛiŋ ka kiəki, a nyum kwuni lɔ gwu. ");
INSERT INTO cug_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yi kɔ a liŋ si mbɛiŋ bi yɛiŋki jɔbi wə gia yələ dzɔ di, mbɛiŋ ka kîəki a ŋkuŋ bi Nyɔ si num kɔmsi dzə lə. ");
INSERT INTO cug_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mih fukuki ŋkɔŋ i mbɛiŋ a, ŋgɔkɔ wi liə wələ bi tsə̂ kâa kə maka gia yələ yichi dzɔ̂ di. ");
INSERT INTO cug_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Bɔɔli bəh nshwaiŋ bi kaa lə, ayakalə gia yiŋ kɔbi i bi lansi nəŋni. ");
INSERT INTO cug_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mbɛiŋ tɔ̂kni bəh kifwu kimbɛiŋ, mbɛiŋ ma nyâ gwu yimbɛiŋ i dzini bi mbi bəh muni wə, i laksi mfi i nɔni ki fa kuku wə, ka chɔkɔ biwɔ bi ma dzə̂ tûmbuku i kwâ mbɛiŋ ka kintaŋ. ");
INSERT INTO cug_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Gia yiwɔ, i chɔkɔ biwɔ wə bi dzə i bəni bəchi bə̀ bɔ kɔ fa i nshwaiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mbɛiŋ ka nûmki bəh gwu yiləkəli tsa Nyɔ jɔbi wichi, ka gia yələ bi dzə i jɔbi wələ wə, mbɛiŋ kaŋa ŋga i bi ŋgbaksi tsə fɛiŋ ka mbɛiŋ bi num i Waiŋmi nshiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jisɔs ka shiki wi lani bəni i juŋ yi fəni yi gia wə i kaŋ yiwɔ yichi. Asi num i fijɔbi, wi yaka tsə nɔ i ŋkwuŋ wi Ɔlif wə. ");
INSERT INTO cug_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bəni bəchi ka bukuki tsəki kinchɔŋɔchɔŋɔ i juŋ yi fəni yi gia wə i wɔkɔ nlani wi. ");
INSERT INTO cug_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jɔbi wi Dzini bi Blɛd wə bə ka jiə dəkə dzɔɔŋ yɛiŋ, bə nì bɔɔŋki a, Dzini bi Ntsədaŋ, bi nì kɔmsiki dzəki. ");
INSERT INTO cug_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ, ka nəŋki dzəh i wɔ̂ɔ Jisɔs fɛiŋ i nyumi wə, kɔm bɔ nì lwaki bəni. ");
INSERT INTO cug_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Satan ka liə i shɔm yi Judas wə bə nì bɔɔŋki a Iskaliɔt, num mi i mbaŋ wi bwa bə Jisɔs bə̀ jwɔfi ntsɔ bəfa. ");
INSERT INTO cug_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Wi ka tsə i bətii mfə gia bəmbum bəh kifwu ki bəni bənchi bə̀ bɔ nì tɔkniki bəh juŋ yi fəni yi gia. Ayaka bəh bɔ ka kɛiŋsi asi wi ki nyaniki ka wi taŋni Jisɔs i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Bɔ wɔkɔ ndzɔŋni ka kɛiŋsi i gɔm wi bəh kpɔ. ");
INSERT INTO cug_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wi bum, ka tsə yisi i nəŋki dzəh i nya Jisɔs fɛiŋ i kaŋ yibɔ wə mbaŋ wi bəni du kə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chɔkɔ biə Dzini bi Blɛd wə bə kɔ maka bə jiə dzɔɔŋ yɛiŋ, bɔ si kum waiŋ jaka kɔm bə Dzini bi Ntsədaŋ biələ jɔbi wə bi nì dzə kpɛiŋ, ");
INSERT INTO cug_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jisɔs ka faaŋ Bita bəh Jɔn ka dzaka a, “Mbɛiŋ tsə̂ kɛ̂iŋsi biɛiŋ biə bukumbɛiŋ ni dzî Dzini biələ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bɔ bikə i wi a, “Wɔ nəŋki a buku tsə̂ kɛ̂iŋsi num faiŋ?” ");
INSERT INTO cug_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Wi chukuli a, “Mbɛiŋ wɔ̂kɔ, asi mbɛiŋ liəki tsəki i kwili wə, mbɛiŋ ni baŋsi bəh mi, num wi bəkə mwi i kpəŋə mə, mbɛiŋ bîəli wi i juŋ yə wi ni tsə liə yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jɔbi wə mbɛiŋ biəli, mbɛiŋ dzâka i tii juŋ wiwɔ a, Mi wi Lanini bikəki di bi juŋ yi bəni bə dzəni a ŋgaiŋ bəh bwa bu bə mbaŋ ni dzi Dzini bi Ntsədaŋ yɛiŋ kɔ faiŋ a? ");
INSERT INTO cug_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wi ka ni chusi lum wimbum i juŋ yi bɛiŋ wə num bə kɛiŋsi jiə lɔ, mbɛiŋ ka ni tsə̂ num yɛiŋ i kɛ̂iŋsi biɛiŋ bichi.” ");
INSERT INTO cug_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Bɔ tsə yɛiŋ a liŋ si Jisɔs nì dzakaki i bɔ. Ayaka bɔ ka kɛiŋsi biɛiŋ bi dzini bi Dzini bi Ntsədaŋ biə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jɔbi nì dzə kpɛiŋ, Jisɔs bəh bwa bu bə ntum dzə shinum ka dziki. ");
INSERT INTO cug_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Wi dza dzaka i bɔ a, “Mih si kɔŋki lə nalə a mih dzi Dzini bi Ntsədaŋ biələ bukumbɛiŋ ka mih yɛiŋ ŋgəkə wə wi dzəki lə. ");
INSERT INTO cug_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mbɛiŋ kîəki lə a mih bi chu dzi kə Bini biələ i tsə buku jɔbi wə bi bi dzə kpɛiŋki, ka Nyɔ bi sakaki ŋkuŋ bi.” ");
INSERT INTO cug_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wi dzɔ bwam nya kiyɔŋni i Nyɔ dzaka a, “Mbɛiŋ kɔ̂ mû tsə̂si dâŋsi mbɛiŋ bəchi. ");
INSERT INTO cug_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Mih fukuki i mbɛiŋ a i yisi i liə i tsə, mih ni chu mu kə mbih mi kpɛiŋ wi laani wələ na ka ŋkuŋ bi Nyɔ bi dzə.” ");
INSERT INTO cug_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wi dzɔ blɛd, nya kiyɔŋni i Nyɔ, gbɛyi nya i bɔ, dzaka a, “Fa kɔ gwu yiŋ, mih nyaki i mbɛiŋ, mbɛiŋ fə̂ki ayaka i kwâkaki mih.” ");
INSERT INTO cug_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Yi num ayaka, asi bɔ dzi kaasi kichiŋni, wi dzɔ bwam wi mbih ka dzaka a, “Bwam wələ kɔ miŋkaiŋ mi Nyɔ mimfiaŋ mə Nyɔ dzi bəh mwa məŋŋ mə mɔ shuku buku kɔm mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ayakalə, mbɛiŋ wɔ̂kɔ mi wə wi ni taŋni mih, wi dziki lə fa bəh mih. ");
INSERT INTO cug_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mbɛiŋ kîəki a mi wə yɛli wi kɔ Waiŋmi bi nyə asi Nyɔ nì sisi jiə. Ayakalə, ŋgəkə wimbum kɔ wi mi wə wi taŋni wi.” ");
INSERT INTO cug_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bɔ yisi i bikəki a bɔ bɔ mi wə wi kɔ i fə̂ yələ gia i bɔ kintəəŋ akɔ ndə a? ");
INSERT INTO cug_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bɔ dza yisi i ŋgukuli a bɔ bɔ a, akɔ ndə mi wimbum i bɔ kintəəŋ a? ");
INSERT INTO cug_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisɔs dzaka i bɔ a, “Bəŋkuŋ bə fa kuku kaŋaki lə ŋga i bəni bəbɔ bɛiŋ, ayaka bəni bə̀ bɔ sakaki tumi, bə bɔɔŋ bɔ a bimba bi bəni. ");
INSERT INTO cug_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ayakalə, yi mɔŋ dəkə i num yaka bəh mbɛiŋ. Wəmaka mi i mbɛiŋ kintəəŋ kaŋaki i dzɔki gwu yi ka waiŋ wi nchiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mi wimbum kɔ winaiŋ, mi wə wi yəkəli ka dziki a dzini, ma mi wə wi tsəsiki dzɛiŋ a? Ntə asi num mi wə wi yəkəli ka dziki a dzini a? Ayakalə, mih kɔ i mbɛiŋ kintəəŋ ka mi wə wi nɔmki i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Akɔ mbɛiŋ bə̀ mbɛiŋ ni numki bəh mih bəh ŋga i jɔbi wuŋ wi ŋgəkə wə wichi. ");
INSERT INTO cug_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yi kɔ a liŋ asi Ba wuŋ nya mih bəh ntɔŋ a mih sakaki, mih ni nya lə tə ŋga biwɔ a mbɛiŋ i sakaki. ");
INSERT INTO cug_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Mih nya lə, ka bukumbɛiŋ ni dziki bə mu i di bi ntɔŋ wuŋ wə, ka mbɛiŋ bi num i biŋgbɔkɔ wə, i sakaki chwɔŋbijuŋ bi Islae biə jwɔfi ntsɔ bəfa.” ");
INSERT INTO cug_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisɔs ka dza bɔɔŋ Bita a, “Samɔn, Samɔn wɔ̂kɔli, Satan dzɔ ŋga i kpəkə mbɛiŋ bəchi i bwili mbɛiŋ bədɔkɔ asi mi si kpəkə chi i gəŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ayakalə, mih tsa i wɔ, a shɔm ya ma bûku i mih. Jɔbi wə wɔ fiəni bɔɔŋ mfi bia, wɔ nyâ ŋga i bwa bə nah.” ");
INSERT INTO cug_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bita dzaka a, “Bah, mih kpɛiŋniki lə i tsə nsəŋ nabə i kpi, bəh wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisɔs chukuli i wi a, “Bita wɔ̂kɔli, mih fukuki i wɔ, ka kwɔkɔ ni numki i tɔŋ daiŋ, wɔ ni məŋni lə mih kiŋkani kitali, a wɔ kiəki kə mih.” ");
INSERT INTO cug_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wi dza bikə i bɔ a, “Mbɛiŋ kwaka jɔbi wə mih nì faaŋ mbɛiŋ kpɔ kɔbi kiba kɔbi bəh dzuyigvu kɔbi, mbɛiŋ nì nyaniki yaka mbɛiŋ nì num dzah finə a?” Ayaka bɔ chukuli a, “Aayi, buku nì ka num dza dəkə fiɛŋ.” ");
INSERT INTO cug_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wi ka dzaka i bɔ a, “I liə, mi kabə kaŋa kpɔ nabə kiba wi dzɔ̂. Mi kabə kaŋaki kə nywɔ wi jum, wi tâŋni mbuŋ wi i tâŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mih dzakaki lə kɔm gia yə bə nì nyaka i Kiŋwakti ki Nyɔ wə a, ‘Bə nì fa wi bəh bəni bəchu,’ yi kaŋaki lə i kpɛiŋ kɔŋ kɔm mih i liə. Mbɛiŋ kiəki a gia yə bə nì nyaka kɔm mih yichi si dzə i kpɛiŋ” ");
INSERT INTO cug_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bɔ ka chiŋ təkəli dzaka a, “Bah yɛ̂iŋ, buku kaŋaki lə bənywɔ bə jum bəfa.” Wi chukuli a, “Mbɛiŋ bêe yaka.” ");
INSERT INTO cug_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisɔs ka dza buku i kwili wiwɔ wə bəh bwa bu bə mbaŋ, ka yisi i yakaki tsəki i ŋkwuŋ wi kɛiŋ yi Ɔlif wə, num asi wi si shi fə. ");
INSERT INTO cug_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bɔ yaka tsə buku i di biə bɔ nì tsəki, wi dzaka i bɔ a, “Mbɛiŋ tsâki ka kimɔmsi ma dzə i mbɛiŋ, i gaka mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Si wi dzaka yakadəiŋ, wi dza nyə i bɔ kpəŋ, ka kini tsə, asi mi kɔ i tum təh a wi tsə buku, ka tum binyu i kuku ka tsa Nyɔ a, ");
INSERT INTO cug_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ba wuŋ, wɔ kabə kɔŋ, wɔ dzɔ̂ bwîli bwam wi ŋgəkə wələ i mih wə. Ayakalə fə̂ asi wɔ kɔŋki a kɔbi si mih kɔŋki.”  ");
INSERT INTO cug_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Si wi tsa yakadəiŋ, chinda wi Nyɔ shi dzə i wi wə, nya wi bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisɔs nì kɔ shɔm yi nya ŋgəkə nalə. Wi chu tsa na bəh ŋga ka bɔɔŋŋki, kiliəkə bə́ təkə i kuku aka mwa. ");
INSERT INTO cug_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wi tsa kaasi, fiəni dzə i bwa bu bə mbaŋ wə, yɛiŋ num nshɛiŋ fə bɔ bɔh ka nɔki. ");
INSERT INTO cug_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Wi bikə i bɔ a, “Mbɛiŋ nɔki lɔ nɔni a? Mbɛiŋ dzâ bɛiŋ mbɛiŋ tsâki ka kimɔmsi ma dzə i mbɛiŋ, i gaka mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Asi wi nì kɛiŋki wi dzaka, mbaŋ wi bəni dzə buku a num lɔ Judas, wə wi nì kɔ mi i mbaŋ wi bwa bə Jisɔs bə̀ jwɔfi ntsɔ bəfa, a num wi i ninshiŋ. Wi tsə kɔmsi i Jisɔs wə ka maŋni wi. ");
INSERT INTO cug_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ayakalə, Jisɔs bikə i Judas a, “Wɔ nəŋki i maŋni mi wə yɛli wi kɔ Waiŋmi i chusi a bə kwa a?” ");
INSERT INTO cug_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bwa bu bə mbaŋ bə̀ bɔ nì kɔ i wi kpəŋ yɛiŋ gia yə yi nəŋki i num, bikə a, “Bah, buku gbâyi bəni bələ a?” ");
INSERT INTO cug_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mi widɔkɔ i bɔ kintəəŋ ka gba chwiŋ bwili kintuni ki tsɛiŋ yiləkəli yi mfa wi fwu wi bətii mfə gia. ");
INSERT INTO cug_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jisɔs kaŋyi a, “Kiə mi ki chu mɔ̂m kə,” ka kɔm kintuni ki mi wiwɔ ki ka fiəni num fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bəni bə̀ bɔ nì dzə i kwa Jisɔs nì kɔ bətii mfə gia bəmbum, bəh kifwu ki bəni bənchi, bəh bə̀ bɔ nì tɔkniki bəh juŋ yi fəni yi gia, bəh bəni bə̀ bɔ nì sakaki tumi. Wi bikə i bɔ a, “Mbɛiŋ dzəki i kwa mih, ka dzəki num bəh bənywɔ bəh bibɔkɔ ka mbɛiŋ dzəki i kwa num ji a? ");
INSERT INTO cug_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mih nì kɔ bəh mbɛiŋ chɔksi chɔksi i juŋ yi fəni yi gia mə, mbɛiŋ kɔbi i kɔm mih kɔm nə a? Ayakalə, i liə kɔ jɔbi wimbɛiŋ wə mbɛiŋ kɔ i fə gia yɛiŋ, a num jɔbi wi ŋga bi jisi.” ");
INSERT INTO cug_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Bəni bəwɔ ka kwa Jisɔs tsə bəh wi i kwili wi fwu wi bətii mfə gia wə, Bita biəli i jum wə i dzəh yi dəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bɔ tsə kpa gbuku i kintəəŋ ki tɔkɔ wə shinum ka jɔkɔki. Bita dzə shinum bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Si gbuku wiwɔ nì bɛli, waiŋkpaŋni widɔkɔ wə wi nì nɔmki i kwili wiwɔ wə dza yɛiŋ Bita si wi shinum. Wi tsɛiŋ wi i dzəkəh wə bindzɔŋ dzaka a, “Mi wələ si kɔlə tə bəh mi wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bita ka nəiŋ dzaka a, “Kpaŋa wələ, mih kiəki kə mi wələ.” ");
INSERT INTO cug_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Asi jɔbi tsə twɛsi, mi widɔkɔ chu yɛiŋ wi, ka dzaka a, “Wɔ kɔ mi i mbaŋ wibɔ wə tə.” Ayaka Bita dzaka a, “Nyuku wələ, mih kɔkə mi wibɔ.” ");
INSERT INTO cug_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Asi mbiəŋə wimu tsə, mi widɔkɔ ka chu bwaŋ alə a, “Ŋkɔŋ ŋkɔŋ mi wələ si kɔlə bəh mi wiwɔ, kɔm wi kɔ mi wi Galili.” ");
INSERT INTO cug_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bita chukuli a, “Nyuku wələ, mih kiəki kə gia yə wɔ dzakaki yaka.” Asi wi nì kɛiŋki wi dzaka yaka, kwɔkɔ ka tɔŋ. ");
INSERT INTO cug_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bah fiəni gwu, dzə́kəh yibɔ Bita baŋsi, Bita kwaka ja yə Bah si dzaka i wi a, “Ka kwɔkɔ ni tɔŋ daiŋ a ni numki num wɔ nəiŋ lɔ mih i kiŋkani kitali wə.” ");
INSERT INTO cug_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bita nyə fɛiŋ buku tsə i biŋ, ka də nalə. ");
INSERT INTO cug_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Bəni bə̀ bɔ nì chəniki Jisɔs ka yisi i fəki nshəŋ i wi, twɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bɔ baŋ shi bi bəh mbuŋ, twɛiŋ wi dzaka i wi a, “Fûku la ntum wi Nyɔ wa wə i liə. Kâŋsi i buku mi wə wi twɛiŋ wɔ.” ");
INSERT INTO cug_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Bɔ lɔyi wi bəh ja yiduli. ");
INSERT INTO cug_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Si chɔkɔ ni wɔɔ, bəni bə̀ bɔ sakaki tumi bəh bətii mfə gia bəmbum bəh bəni bə̀ bɔ laniki bənchi bə Nyɔ, bɔ juŋni gwu yibɔ bɔ bəchi, ka dzɔ Jisɔs dzə bəh wi i di biə bə si saka bənsaka. ");
INSERT INTO cug_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Si bɔ tsə bəh wi yaka, bɔ dzaka i wi a, “A kabə num wɔ Kimbwili wə Nyɔ nì kaka wɔ fûku i buku.” Wi chukuli i bɔ a, “Mih ka fuku i mbɛiŋ, mbɛiŋ ma ni bum mih. ");
INSERT INTO cug_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ayaka mih ka bikə gia i mbɛiŋ, mbɛiŋ ma ni chukuli. ");
INSERT INTO cug_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ayakalə, i yisi i liə, mi wə yɛli wi kɔ Waiŋmi ni num i kimbu ki tsɛiŋ yiləkəli yi Nyɔ wə wi kaŋaki ŋga.” ");
INSERT INTO cug_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bɔ bəchi ka dzaka a “Akɔ a wɔ Waiŋ Nyɔ a?” Wi chukuli i bɔ a, “Yi kɔ asi mbɛiŋ dzaka” ");
INSERT INTO cug_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ayaka bɔ ka dzaka a, “Bə chu nəiŋki mi a wi dzə dzaka a nə a? Bə wɔkɔ lɔ ndzaka wə wi buku i dzaka ka wə.” ");
INSERT INTO cug_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Si mbaŋ wi bəni bə̀ bɔ nì sakaki bənsaka dzaka yaka, ka dza bɔ bəchi dzɔ Jisɔs ka tsəki bəh wi i Baylɛ. ");
INSERT INTO cug_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Si bɔ tsə buku fɛiŋ, ka yisi i jiəki gia i wi fuŋ, dzaka a, “Mi wələ nyaniki bəkəli tumi kibuku, nəiŋma a bəni ma gɔmki kpɔ wi kiŋwakti i Kaysa ŋkuŋ wi Lum, chu dzaka a wi kɔ Kimbwili wə Nyɔ nì kaka, yi chu chusi a wi kɔ ŋkuŋ widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Baylɛ bikə i Jisɔs a, “Akɔ a wɔ Ŋkuŋ wi Bəju a?” Jisɔs chukuli i wi a, “Yi kɔ asi wɔ dzaka.” ");
INSERT INTO cug_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Baylɛ ka dza dzaka i bətii mfə gia bəmbum bəh mbaŋ wi bəni bə̀ bɔ nì kɔ fɛiŋ a, “Mih ka yɛiŋ dəkə gia yə mi wələ gbɔ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bɔ bəchi ka bwaŋki alə, “Mi wələ nyaniki wi lani bəni i bi tumi bi Judea wə bichi, nyini a bɔ lə̂kəki bəh kifwu. Wi ni yisi i Galili, i liə wi si num lɔ fa i tumi kələ wə.” ");
INSERT INTO cug_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Si Baylɛ wɔkɔ yi yaka, ka bikə a, “Mi wələ kɔ mi wi Galili a?” ");
INSERT INTO cug_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bɔ bum, wi ka faaŋ Jisɔs i Ŋkuŋ Hɛlɔd, kɔm a nì kɔ wi wə wi ni sakaki kimbu ki tumi kiwɔ, wi num tə i Jɛlusalɛm i jɔbi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bɔ tsə bəh Jisɔs, Ŋkuŋ Hɛlɔd yɛiŋ wi, wɔkɔ ndzɔŋni i jɔbi wə wi nì yɛiŋ Jisɔs, kɔm wi nì kɔ wi wɔkɔ lɔ kɔm Jisɔs, i jɔbi wi dəəŋ wə wi nì kɔ wi wɔkɔli i yɛiŋ Jisɔs, kwaka a jɔbi widɔkɔ ŋgaiŋ ni yɛiŋ wi fə gia yi chusi ŋga bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wi dzɔ jɔbi ka bikəyiki gia yiduli i Jisɔs, ayakalə wi nəki chu chukuli kə gia yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Wi nì bikə yaka, bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ num fɛiŋ, bɔ buku tsə i ninshiŋ i kɛiŋsi gia yiləkəli i jiə i Jisɔs fuŋ. ");
INSERT INTO cug_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ŋkuŋ Hɛlɔd bəh bəni bu bə jum ka dza yisi i suŋuki wi, tum mbuŋ wi kwili i gwu yi wə, ka fiəni chiŋsi wi i Baylɛ. ");
INSERT INTO cug_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","A nì kɔ Baylɛ bəh Ŋkuŋ Hɛlɔd baiŋŋni. I chɔkɔ biwɔ, bɔ kwa nsɛ́iŋ. ");
INSERT INTO cug_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Si bɔ chiŋsi Jisɔs i jum wə, Baylɛ juŋni bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì sakaki tumi kiwɔ, ka bɔɔŋ juŋni tə bəni bəchi. ");
INSERT INTO cug_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Bɔ juŋni dzə, wi dzaka i bɔ a, “Mbɛiŋ si dzə bəh mi wələ fa a wi fəki bəni ləkə bəh kifwu, mih tsɛiŋ ləkə i gia yə mbɛiŋ bwamki kɔm yi i mbɛiŋ nshiŋ, mbɛiŋ tsɛ̂iŋ, mih ka yɛiŋ dəkə gia yə wi gbɔ yɛiŋ, i gia yichi yə mbɛiŋ jiəki i gwu yi wə, wi ka fə dəkə gia yidɔkɔ, ");
INSERT INTO cug_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","num Ŋkuŋ Hɛlɔd ka yɛiŋ dəkə tə yi. Akɔ gia yə yi ni fə wi fiəni chiŋsi mi wələ i bukumbɛiŋ. Mbɛiŋ yɛ̂iŋ tə a, mi wələ ka fə dəkə gia yidɔkɔ yə bə kɔ i wɔ̂ɔ wi wɔɔni. ");
INSERT INTO cug_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ayakadəiŋ, mih ki twɛiŋki wi a twɛiŋni, ma mih bêeka wi, ma wi tsə̂ki.” ");
INSERT INTO cug_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","A nì kɔ i jɔbi wiwɔ wə a num Dzini bi Ntsədaŋ, Baylɛ kaŋa i bwîli mi wimu i juŋ yi nsəŋ wə i nyâ i bəni. ");
INSERT INTO cug_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bəni bəchi ka dza yisi i wiliki fɛiŋ a, “Kâasi mi wələ, bwîli Balabas i juŋ yi nsəŋ mə ma wɔ nyâ i buku.” ");
INSERT INTO cug_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Balabas wələ nì kɔ i juŋ yi nsəŋ mə kɔm wi nì kɔ wi yisi ŋgəkə i kwili wə ka chu wɔɔ mi. ");
INSERT INTO cug_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Baylɛ wɔkɔ yaka chu dzaka i bəni bəchi nalə kɔm wi ni nəŋki i bee Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ayakalə, bɔ ka wiliki a, “Bə bâŋŋ wi i kintasi wə, bə bâŋŋ wi i kintasi wə.” ");
INSERT INTO cug_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Baylɛ chu dzaka i bəni i kiŋkani kitali wə a, “Bə baŋŋ wi kɔm nə? Gia yichu yə wi fə akɔ nə? Mih ka yɛiŋ ŋgəkə wə wi fə ka bə wɔɔ wi wɔɔni. Mih ki twɛiŋki wi a twɛiŋni, ma mih bee wi.” ");
INSERT INTO cug_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bɔ ka baŋŋ a wiliki bəh ŋga a “Bə bâŋŋ wi i kintasi wə.” Ŋ'wili wibɔ gaka Baylɛ. ");
INSERT INTO cug_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ayakadəiŋ, Baylɛ təiŋ nsaka ka bee wi, a bɔ fə bəh wi asi bɔ nəŋki. ");
INSERT INTO cug_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wi ka bwili yatɔkɔ mi wə i juŋ yi nsəŋ wə, num wə bɔ ni bikəki, wə wi nì yisi ŋgəkə i kwili wə chu wɔɔ mi. Si wi bwili, ka nya Jisɔs i bɔ si bɔ nəŋki. ");
INSERT INTO cug_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bɔ ka dzɔ Jisɔs i tsə baŋŋyi. Si bɔ ni tsəki, bɔ baŋsi bəh mi widɔkɔ wi kwɛ dzə i chwa yɛli wi num Samɔn, num mi wi Sɛlin. Bɔ kwa wi ka jiə kintasi ki Jisɔs i kimbəkəli ki wə, wi ka giŋ ka biəli Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bəh bɔ ka tsəki, mbaŋ wi bəni wimbum biəli wi. I bɔ kintəəŋ bəkaŋa bədɔkɔ nì dəki lə, fa gia. ");
INSERT INTO cug_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisɔs dza fiəni gwu dzaka i bɔ a, “Bəkaŋa bə Jɛlusalɛm, kiə mbɛiŋ ki də̂ kə i mih. Mbɛiŋ də̂ki num i gwu yimbɛiŋ, bəh i bwa bəmbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mbɛiŋ kîəki a jɔbi bi dzəki lə wə bə bi dzakaki a, ‘Kinsaŋli kimbum kɔ ki bəkaŋa bə̀ bɔ kɔ kaiŋni maka bɔ num bwɔ waiŋ, maka bɔ num masi waiŋ.’ ");
INSERT INTO cug_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","A bi numki i jɔbi wiwɔ wə, bəni bi wamki dzakaki i ŋkwuŋ yimbum yimbum a, ‘Mbɛiŋ gbɔ̂yi i buku wə,’ dzaka i ŋkwuŋ yinchiŋ yinchiŋ a, ‘Mbɛiŋ bâŋ buku.’ ");
INSERT INTO cug_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Bɔ ni wiliki yakadəiŋ kɔm bəni ka fə gia yələ a num i kpɛiŋ wi kɛiŋ wi dəli, bɔ bi ka fə na dəiŋ bəh wə wi kɔ wi wɔm lɔ.” ");
INSERT INTO cug_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Si bɔ ni tsəki bəh Jisɔs yakadəiŋ, bɔ nì kaŋaki lə bəni bə nsəŋ bəfa bə̀ bɔ ni tsəki i wɔɔ tə. ");
INSERT INTO cug_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bɔ tsə buku i di biə bə bɔɔŋki a Ŋkuŋu Kifwu, ka baŋŋ Jisɔs fɛiŋ i kintasi wə, ka baŋŋyi tə bəni bə nsəŋ bəfa i kintasi wə, wimu i tsɛiŋ yi Jisɔs yiləkəli wə, widɔkɔ i kimbu ki tsɛiŋ yi kimiəkə wə. ");
INSERT INTO cug_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisɔs dza dzaka a, “Ba, dâlinya chu bi bəni bələ, kɔm bɔ kiəki kə gia yə bɔ fəki.” Bəni bəwɔ dzɔ bəmbuŋ bə Jisɔs, ka tum kaaŋ yɛiŋ i gaa bəmbuŋ bəwɔ i bɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gia yələ yichi nì numki bəh Jisɔs yakadəiŋ, num bəni num fɛiŋ tsɛiŋ. Bəni bə̀ bɔ nì sakaki kwili wiwɔ ka dza fibɔ ka suŋuki dzaka a, “Wi nì gamtiki bəni, wi gâmti la gwu yi i liə, wi kabə num Kimbwili wə Nyɔ nì saiŋbwili.” ");
INSERT INTO cug_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Bəni bə jum bə̀ tə ka nyiksiki wi, nya mbih miŋgbɛnini i wi, ");
INSERT INTO cug_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","dzaka a, “Wɔ kabə num ŋkuŋ wi Bəju, wɔ gâmti la gwu ya.” ");
INSERT INTO cug_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Bɔ nì nyaka kiŋwakti baŋŋ i fwu wi Jisɔs bɛiŋ a, “Wələ kɔ ŋkuŋ wi Bəju.” ");
INSERT INTO cug_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mi wi nsəŋ widɔkɔ i bə̀ wə bə nì baŋŋ i kintasi wə dza ka tɔyiki Jisɔs, dzaka a, “A mɔŋ a wɔ wə Kimbwili wə Nyɔ nì kaka a? Bwîli gwu ya, ma wɔ bwîli tə buku.” ");
INSERT INTO cug_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Widɔkɔ wə wɔkɔ gia yə wi dzaka, kaŋyi wi, bikə i wi a, “Wɔ lwaki kə Nyɔ a? Wɔ kɔ i ŋgəkə wə tə asi wi kɔ. ");
INSERT INTO cug_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yi kpɛiŋniki lə i buku wɔ i kpi i kwati mbee wi gia yichu yə buku wɔ fə, ayakalə mi wələ kpiki lə maka wi fə gia yichu yidɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mi wi nsəŋ wələ ka dzaka a, “Jisɔs, wɔ bi kwâka mih i jɔbi wə wɔ bi sakaki ntɔŋ bia.” ");
INSERT INTO cug_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisɔs dzaka i wi a, “Mih fukuki ŋkɔŋ i wɔ a daiŋ lə buku wɔ ni numki lə i di bindzɔŋni bi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A nì kɔ asi wɔŋ ni nəŋki i yaka lumsi, biŋ dza ji tumi kichi ji tsə buku i mbiəŋə witali wə nshifɔkɔ, ");
INSERT INTO cug_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","kɔm wɔŋ nì chu baiŋki kə. Mbuŋ wə wi nì təiŋni juŋ yi fəni yi gia i fintəəŋ taŋa shi buku i biwa bifa wə. ");
INSERT INTO cug_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisɔs num i kintasi wə, ka dza wam bəh ŋga a, “Ba wuŋ, mi nyaki kiŋ'waka kəŋŋ i wɔ kaŋ.” Si wi dzaka yakadəiŋ, ka waka kiŋ'waka ki kigɔksini. ");
INSERT INTO cug_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Fwu wi bəni bə jum wə wi nì kɔ fɛiŋ, si wi yɛiŋ gia yə yi num, nya kiŋkɔksi i Nyɔ dzaka a, “Ŋkɔŋ, ŋkɔŋ, mi wələ nì kaŋaki kə gbɔ widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bəni bəchi bə̀ bɔ nì juŋni fɛiŋ i yɛiŋ gia yə yi numki, si bɔ yɛiŋ yakadəiŋ ka dza fiəni kwɛ i kwili kibɔ wə num bɔ kwumi tsɛ́iŋ. ");
INSERT INTO cug_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nsɛ́iŋ yi Jisɔs yichi, nì dzə fibɔ num i dzəh yi dəəŋ ka tsɛiŋki gia yə yi num. Bədɔkɔ num bəkaŋa bə̀ bɔ nì buku i Galili biəli dzə wi. ");
INSERT INTO cug_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Mi widɔkɔ nì kɔ i jɔbi wiwɔ wə bə bɔɔŋ a Yɔsɛf, num wi nì buku i Alimatia i kwili wi Bəju kidɔkɔ wə. Wi nì kɔ mi wi ndzɔŋni chu num mi wi chəŋ i Nyɔ nshiŋ, chu wɔkɔli jɔbi wə Nyɔ bi dzə sakaki ŋkuŋ bi. Wi nì kɔ tə mi wi mbaŋ wi bəni bə̀ bɔ sakaki bənsaka. Ayakalə, wi nì ka bum mfih gia yə bɔ nì sisi i fə bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wi tsə i Baylɛ, tsa wi i dzɔ wini wi Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Baylɛ bum, wi ka tsə shishi wini wiwɔ, ka kii i mbuŋ wə, ka tsə lɔsi i jum yə bə nì chum i biaŋa wə, maka bə num jiə mi yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A nì kɔ Chɔkɔ bi Sisini i buku nya i chɔkɔ bimbam wə, a ni baaŋ a twɛsi ka mbam wiwɔ yisi. ");
INSERT INTO cug_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Bəkaŋa bə̀ bɔ nì buku i Galili biəli Jisɔs, bɔ biəli Yɔsɛf i jum wə, i tsə yɛiŋ si wi jiəki wini wi Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bɔ ni dza fɛiŋ, ka kwɛ i wa wibɔ, tsə kɛiŋsi bifiaŋsi bi tsɛŋə yindzɔŋni biə bə si fə i fiaŋsi wini yɛiŋ. A num chɔkɔ bimbam wə, bɔ shi mbam si bənchi bəbɔ nì nəŋki. ");
INSERT INTO cug_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Asi chɔkɔ bimbam nì tsə, a num kinchɔŋɔchɔŋɔ i chɔkɔ bi ninshiŋ i shi wə. Bəkaŋa bə̀ buku dza kinchɔŋɔchɔŋɔ, dzɔ fiaŋsi biə bɔ nì kɛiŋsi jiə ka tsə bəh bi i jum bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jɔbi wə bɔ nì tsə buku fɛiŋ, bɔ ti num bə biŋsi bwili təh wə bə nì baŋ dzaka ki jum kiwɔ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Asi bɔ liə tsə i jum yiwɔ kintəəŋ nəki yɛiŋ kə wini wi Bah Jisɔs. ");
INSERT INTO cug_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bɔ chiŋ num fɛiŋ alə nəki kiə kə gia yə bɔ kɔ i fə. Yi num a bənyuku bədɔkɔ bəfa nì dzə num kɔmsi i bɔ kpəŋ, num bɔ lɔh bəmbuŋ bə fukuli bɔ ŋwaŋyi alə. ");
INSERT INTO cug_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ndzaŋ kwa bəkaŋa bəwɔ na bəh ŋga, bɔ chuŋsi kifwu kibɔ i kuku. Bənyuku bə̀ bikə i bɔ a, “Akɔ kɔm nə mbɛiŋ nəŋki mi wiwɔm i bəŋkwu kintəəŋ a? ");
INSERT INTO cug_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Wi fa kɔkə, wi si dza lɔ i kpi wə. Mbɛiŋ yîŋti gia yə wi nì dzaka i mbɛiŋ jɔbi wə mbɛiŋ bɔ nì kɔ i Galili. ");
INSERT INTO cug_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Wi nì dzaka a, ‘Mi wə yɛli wi kɔ Waiŋmi bə kaŋaki lə i bi nyâ wi i kaŋ yi bəni bəchu wə, ma bɔ baŋŋ wi i kintasi wə, i buku i kaŋ yitali wə, wi bi fiəni dza i kpi wə.’” ");
INSERT INTO cug_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bɔ ka yiŋti gia yə Jisɔs nì dzaka i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Bɔ dza fiəni i jum yiwɔ bɛiŋ, ka tsə fuku gia yiwɔ yichi i bwa bu bə mbaŋ bə̀ jwɔfi ntsɔ mu bəh bəni bəchi bə̀ bɔ nì biəliki wi. ");
INSERT INTO cug_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Bəkaŋa bə̀ bɔ nì fuku gia yiwɔ yichi asi yi nì num i bwa bə ntum bə Jisɔs a nì kɔ, Meli Magdalen, Jɔana bəh Meli nih Jɛm bəh bəkaŋa bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bɔ wɔkɔ ndzaka wiwɔ aka kiyuŋ ki gia, nəki bum kə yi. ");
INSERT INTO cug_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ayakalə, Bita ka dza kɔmsi, yɔkɔ tsə buku fɛiŋ i jum bɛiŋ, ka ŋgwuŋ tsɛiŋ ləkə i jum yiwɔ kintəəŋ ka yɛiŋ shəŋ a bəmbuŋ bə̀ bə nì kii i Jisɔs wə. Wi bə́ fiəni tsə i dzu bəh dzaka ki wɔmni, kɔm gia yə yi num. ");
INSERT INTO cug_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","A dzə num a i chɔkɔ biwɔ wə, bəni bəfa bədɔkɔ bə̀ bɔ nì biəliki Jisɔs, bɔ nì buku i Jɛlusalɛm nyə ka bə́ tsə i kwili widɔkɔ bə bɔɔŋ a, Ɛmayus, dzəh yiwɔ num aka bəmay nanitaŋ i tsə buku fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Bɔ nì nyə ka tsəki bɔ dzakayi a bɔ bɔ, kɔm gia yichi yə yi nì num. ");
INSERT INTO cug_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Si bɔ nì nyaniki tsəki yakadəiŋ dzakayi, kaiŋyi, Jisɔs mwi kɔmsi dzə i bɔ wə, bəh bɔ bə́ nyaniki tsəki. ");
INSERT INTO cug_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Gia yidɔkɔ fə a bɔ ma kîə mi wiwɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisɔs ka dza bikə i bɔ a, “Akɔ nə mbɛiŋ nyaniki, dzakayi kɔm yi a?” Si wi bikə yaka, bɔ num bəh nshɛiŋ i shi bibɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Mi widɔkɔ i bɔ kintəəŋ yɛli wi num Kleɔfas, bikə i wi a, “Yaka akɔ a wɔ mbɔŋ shəŋ mi wi dzəni i Jɛlusalɛm, wə wɔ kiəki kə gia yə yi num i kaŋ yələ wə a?” ");
INSERT INTO cug_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Wi bikə i bɔ a, “Yi naiŋ gia a?” Bɔ chukuli a, “Gia yə yi ni num bəh Jisɔs wi Nasali. Mi wələ nì kɔ mi wi ntum wi Nyɔ, gia yə wi nì fəki bəh yə wi nì dzakaki a nì kɔ yi kaiŋyini. Wi nì kɔ mi wimbum i Nyɔ nshiŋ bəh i bəni bəchi wə. ");
INSERT INTO cug_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki kikwili kibuku nì nya wi a bə wɔ̂ɔ, bə baŋŋ wi i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Buku nì kaŋaki lə kiŋkwaka i wi a, akɔ wi wə wi bi təiŋ bəni bə Islae i kaŋ yi ŋgəkə wə. Ayakalə, a tsə a kaŋ yitali si gia yiwɔ num. ");
INSERT INTO cug_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yidɔkɔ chu num a bəkaŋa bədɔkɔ i mbaŋ wibuku wə, bɔ si dzaka i buku gia yi dzaka ki wɔmni, a bɔ si tsə i jum bɛiŋ kinchɔŋɔchɔŋɔ, ");
INSERT INTO cug_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bɔ nəki yɛiŋ kə wini wi Jisɔs wiwɔ. Bɔ ka fiəni dzə fuku i buku a, bɔ si yɛiŋ bəchinda bə Nyɔ aka ndəmsi, bɔ fuku i bɔ a Jisɔs kɔ wiwɔm. ");
INSERT INTO cug_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bəni bədɔkɔ i mbaŋ wibuku wə, si tsə i jum bɛiŋ, ka yɛiŋ yi asi bəkaŋa bə̀ si fuku, ayakalə bɔ nəki yɛiŋ kə wini wi Jisɔs wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jisɔs dzaka i bɔ a, “Ɔ ɔɔ, biyuŋ biələ, shɔ́m yimbɛiŋ dəki na bəh ŋga i bum gia yə bəni bə ntum bə Nyɔ nì dzakaki. ");
INSERT INTO cug_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mbɛiŋ kiəki kə a, Kimbwili wə Nyɔ nì kaka a wi kaŋaki i yɛ̂iŋ bəŋgəkə bələ, ka wi lîə i mbum bi wə a?” ");
INSERT INTO cug_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jisɔs ka yisi i fukuki baiŋsiki i bɔ gia yichi yə bə nì nyaka i biŋwakti bi Nyɔ wə bichi kɔm wi, bəh i yisi i Muses wə, i tsə buku tə i biə bəni bə ntum bə Nyɔ nì nyaka. ");
INSERT INTO cug_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Asi bɔ nì dzə kɔmsi i kwili wə bɔ nì tsəki fɛiŋ, Jisɔs ka fə aka wi tsəki daŋsiki lə. ");
INSERT INTO cug_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bɔ buku tsə, ka tsaki wi nalə a, “Bukumbɛiŋ tsə̂ nɔ̂, kɔm jɔbi kɔ wi tsə nalə, biŋ chu num bi yisi i jiki.” Ayakadəiŋ, wi bum i tsə nɔ bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Bɔ tsə, i jɔbi wə bɔ nì num i dzi, wi dzɔ chɔkɔ yi blɛd, ka nya kiyɔŋni i Nyɔ, gbɛyi gaa i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Akisəkə dzəkəh yibɔ baiŋ, bɔ ka yɛiŋ kiə wi. Ayakalə, wi fiəni laka i bɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bɔ baaŋ ka dzakayiki a bɔ bɔ a, “Ntə shɔm yibuku wɔ si shiliki alə i jɔbi wə wi si dzakaki i buku wɔ i dzəh, fuku baiŋsi gia i Kiŋwakti ki Nyɔ wə i buku wɔ a?” ");
INSERT INTO cug_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bɔ dza akisəkə a i jɔbi wiwɔ i fijɔbi fiəni chu i Jɛlusalɛm. Si bɔ tsə ka yɛiŋ bwa bə mbaŋ bə Jisɔs bə̀ jwɔfi ntsɔ mu num bɔ juŋni gwu yibɔ di bimu bəh bəni bədɔkɔ bə̀ bɔ nì kɔ bɔ biəli bɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bɔ dzaka a, “Ŋkɔŋ, Bah wibukumbɛiŋ si dza i kpi wə. Wi si tumbuku i Samɔn nshiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bɔ ka fuku tə i bɔ gia yə yi si num bəh bɔ i dzəh, chu fuku baiŋsi asi bɔ si yɛiŋ kiə wi i jɔbi wə wi si gbɛki blɛd. ");
INSERT INTO cug_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Asi bɔ ni kɛiŋki bɔ dzaka yakadəiŋ, Jisɔs wi mwi ka chiŋ tumbuku i bɔ kintəəŋ ka bɔni i bɔ a, “Ma kimbɔiŋni num bəh mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ndzaŋ kwa bɔ, bɔ bə́ lwa, ka bə́ kwaka a yudɔkɔ bɔ yɛiŋ num ŋkwusa. ");
INSERT INTO cug_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wi bikə i bɔ a, “Mbɛiŋ lwaki nə? Akɔ kɔm nə wə mbɛiŋ məŋniki mih a? ");
INSERT INTO cug_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mbɛiŋ tsɛ̂iŋ kaŋ yiŋ bəh gvu yiŋ ka mbɛiŋ kîə a, akɔ na mih. Mbɛiŋ mɔ̂myi gwu yiŋ mbɛiŋ ka ni kîə, kɔm ŋkwusa si kaŋa kə nyam yi gwu bəh bikuŋɔ asi mbɛiŋ yɛiŋki mih kaŋa.” ");
INSERT INTO cug_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Asi wi dzaka yakadəiŋ, ka chusi kaŋ yi bəh gvu yi i bɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bɔ tsɛiŋ Jisɔs, kinsaŋli wɔɔ bɔ, bɔ ka chiŋ num alə. Yi gaka bɔ i bum a, akɔ wi. Wi dza bikə i bɔ a, “Mbɛiŋ kaŋaki lə fiɛŋ fidzini fa a?” ");
INSERT INTO cug_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bɔ dzɔ kiŋka ki bwɔkɔ yi waŋni, nya i wi. ");
INSERT INTO cug_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Wi dzɔ dzi i bɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wi ka dzaka i bɔ a, “Gia yələ mbɛiŋ yɛiŋ daiŋ, akɔ gia yə mih nì dzakaki i mbɛiŋ kɔm yi mih kɛiŋ bəmbɛiŋ. Mih nì dzaka a, gia yichi yə bə nì nyaka kɔm mih i kiŋwakti ki Muses wə, bə i biŋwakti bi bəni bə ntum bə Nyɔ wə, bəh i kiŋwakti Kinyaksi wə, kaŋaki i dzə̂ kpɛ̂iŋ.” ");
INSERT INTO cug_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wi ka wɛli mfi bibɔ, bɔ kiə gia yə yi kɔ i Kiŋwakti ki Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Wi ka dzaka i bɔ a, “Bə ni nyaka a Kimbwili wə Nyɔ nì kaka kaŋaki lə i yɛ̂iŋ bəŋgəkə i kpî, i kaŋ yitali wə, wi bi fîəni dzâ i kpi wə. ");
INSERT INTO cug_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Yi kɔ tə a, bə bi yîsi i kintəəŋ ki Jɛlusalɛm i fûkuki i bitumi bichi kɔm yɛli wi a bəni bəchi kwûni shɔ́m yibɔ ka Nyɔ bi dâlinya chu bibɔ. ");
INSERT INTO cug_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Akɔ mbɛiŋ bələ mbɛiŋ kaŋaki i ni fûkuki asi mbɛiŋ nì yɛiŋ yi. ");
INSERT INTO cug_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mbɛiŋ wɔ̂kɔli, mih ni chiŋsi lə kinya kə Ba wuŋ nì kaka i mbɛiŋ. Ayakadəiŋ, mbɛiŋ bâaŋ a fa i kwili kintəəŋ mbɛiŋ wɔ̂kɔliki, i tsə̂ bûku i jɔbi wə ŋga biə bi nyə bɛiŋ bi shi dzə i mbɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wi dzɔ bɔ buku i kwili kintəəŋ, ka tsə bəh bɔ i dzəh yi dəəŋ i kɔmsi i kwili wi Bɛtani wə, wi gəŋsi kaŋ yi i bɛiŋ, jiə kimbɔiŋsi i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Asi wi nì kɛiŋki wi jiə kimbɔiŋsi i bɔ wə yaka, wi dza bee bɔ ka bə́ yaka tsə i bɛiŋ, ka yaka laka i dzə́kəh yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Bɔ nya kiŋkɔksi kimbum i wi, ka dza fiəni tsə i Jɛlusalɛm bəh kinsaŋli i shɔ́m yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bɔ tsə ka shiki a juŋ yi fəni yi gia wə, kɔksi Nyɔ jɔbi wichi.");
INSERT INTO cug_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","I kin'yisi wə a nì kɔ num Ja si num lɔ. Ja yiwɔ nì kɔ bəh Nyɔ, Ja yiwɔ num Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Wi nì kɔ wi si num lɔ i kin'yisi wə bəh Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nyɔ nì maa biɛiŋ bichi tsə i kaŋ yi wə. Fiɛŋ fidɔkɔ kɔkə na fimu fiə Nyɔ nì maa wi kɔbi. ");
INSERT INTO cug_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","I wi mə kɔ nɔni, ayaka nɔni kələ num baiŋni i bəni wə. ");
INSERT INTO cug_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Baiŋni biwɔ baiŋki i jisi wə, ayaka jisi biwɔ kɔbi i nyumsi bi. ");
INSERT INTO cug_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mi widɔkɔ nì kɔlə wə Nyɔ nì faaŋ, yɛli wi num Jɔn. ");
INSERT INTO cug_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wi nì dzə i dzaka kɔm baiŋni, bəh i beeŋ nsaka wi baiŋni biwɔ, ka wi fə bəni bəchi bi jîə shɔ́m i baiŋni biwɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jɔn mwi nì kɔkə baiŋni biwɔ. Wi nì dzə a beeŋ nsaka i baiŋni biwɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Baiŋni bi ŋkɔŋ biwɔ biə bi chusiki baiŋni i bəni bəchi nì dzəki lə i mbi wələ mə. ");
INSERT INTO cug_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Wi nì kɔlə i mbi wələ mə, mbi wələ num Nyɔ nì maa tsə i kaŋ yi wə, ayakalə bəni bə̀ bɔ kɔ bə mbi wələ nəki kiə kə wi. ");
INSERT INTO cug_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wi nì dzə i mbu, ayaka bɔ nəki dzɔ kə wi. ");
INSERT INTO cug_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ayakalə, bəni bəchi bə̀ bɔ nì dzɔ wi, jiə shɔm i yɛli wi wə, wi nya ŋga i bɔ a bɔ nûmki bwa bə Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ayaka bwa bə Nyɔ bələ kɔkə bə̀ bə bwɔ biəli mwa mi chwɔŋkijuŋ, nabə i kiŋkɔŋ ki mi wə, nabə mbwɔ wi mi wiwɔm. Bə bwɔ bɔ biəli a num mbwɔ wə akɔ wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ja yiwɔ nì fiəni chu mi wiwɔm ka nɔki i buku kintəəŋ, num wi jikə bəh kiŋkɔŋ ki Nyɔ bəh ŋkɔŋ. Ayaka buku yɛiŋ kiŋkɔkni ki. Kiŋkɔkni kiwɔ num ki Waiŋ wi shəŋ wə wi nyə i Ba wi wə. ");
INSERT INTO cug_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jɔn nì num mbeeŋ nsaka kɔm wi, ka wiliki dzaka a, “Wələ kɔ mi wə mih ni dzakaki kɔm wi, dzaka a, ‘Mi wə wi dzəki i mih jum kɔkniki lə tsə mih, kɔm wi nì kɔlə na ka mih numki.’” ");
INSERT INTO cug_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Si wi kɔ wi jikə bəh kiŋkɔŋ ki Nyɔ, wi ka nyaki bukumbɛiŋ bəchi bəh kiŋkɔŋ i kiŋkɔŋ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bukumbɛiŋ kiə a Nyɔ nì nya bənchi tsə i kaŋ yi Muses wə. Ayakalə, mbum bi Nyɔ bəh ŋkɔŋ dzə ka tsəki i kaŋ yi Jisɔs Klistus wə. ");
INSERT INTO cug_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mi widɔkɔ kɔkə wə wi num yɛiŋ Nyɔ. Akɔ a Waiŋ wi wimu wə shəŋ wə wi num kɔmsi i Ba wi kpəŋ wə wi fə bukumbɛiŋ kiə wi. ");
INSERT INTO cug_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yələ kɔ gia yə Jɔn nì dzaka i jɔbi wə kifwu ki Bəju i Jɛlusalɛm nì faaŋ bətii mfə gia bəh bəni bə Lɛwi a bɔ tsə̂ bîkə i Jɔn a, akɔ wi ndə a. ");
INSERT INTO cug_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jɔn nì ka nəiŋma dəkə i chukuli kimbikə kibɔ. Wi nì dzaka bəh dzaka ki a, “Mih kɔkə Kimbwili wə Nyɔ nì kaka.” ");
INSERT INTO cug_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Bɔ bikə i wi a, “Wɔ kɔ la ndə? Akɔ wɔ Ɛlaja ma?” Wi chukuli i bɔ a, “Mih kɔkə Ɛlaja.” Bɔ ka chu bikə i wi a, “Akɔ wɔ wə Mi wi Ntum wi Nyɔ wə ma?” Wi nəiŋma. ");
INSERT INTO cug_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Bɔ ka chu bikə i wi a, “Wɔ kɔ la ndə? Wɔ dzaka la a nə kɔm bə gwu ya? Fûku ka buku kwati gia yə buku kɔ fiəni tsə chukuli i bəni bə̀ bɔ si faaŋ buku.” ");
INSERT INTO cug_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jɔn ka chukuli i bɔ si Isaya mi wi ntum wi Nyɔ nì dzakaki a, “Akɔ mih ja yə yi wiliki i chwa a, ‘Bə lûmsi dzəh yi Bah a yi nûm chəŋ.’” ");
INSERT INTO cug_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Bəni bələ kɔ num a nì faaŋ Bəfalasi bɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bɔ ka bikə i Jɔn a, “Wɔ kabə num kə Kimbwili wə Nyɔ nì kaka, wɔ num kə Ɛlaja, nabə Mi wi Ntum wi Nyɔ wə, wɔ ka bə juliki bəni i bɔkɔ kɔm nə la?” ");
INSERT INTO cug_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jɔn ka chukuli i bɔ a, “Mih kɔ mfiŋ a juliki bəni i bɔkɔ mə, ayakalə mi widɔkɔ kɔlə i mbɛiŋ kintəəŋ wə mbɛiŋ kiəki kə wi. ");
INSERT INTO cug_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wi kɔ wə wi dzəki i mih jum, na mih kpɛiŋni kə i shwali dzu yi yigvu.” ");
INSERT INTO cug_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gia yələ yichi nì dzɔ di a num i Bɛtani i kiwuŋ ki Bɔkɔ yi Jɔdan wə i di biə Jɔn nì juliki bəni i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Si chɔkɔ ni buku wɔɔ, Jɔn yɛiŋ si Jisɔs dzəki, wi ka dzaka a, “Mbɛiŋ tsɛ̂iŋ, wələ kɔ Waiŋ Jaka wi Nyɔ wə wi dzɔki bwiliki chu bi mbi wələ! ");
INSERT INTO cug_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wələ kɔ wi wə mih nì dzakaki kɔm wi a, ‘Mi widɔkɔ dzəki i mih jum kɔkni tsə mih, kɔm wi nì kɔlə na ka mih numki.’ ");
INSERT INTO cug_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mih mwi nì kiəki kə wi. Ayakalə, mih ni dzə ka juliki bəni i bɔkɔ ka bəni bə Islae kîə wi.” ");
INSERT INTO cug_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jɔn nì kɔ wi dzaka a ŋgaiŋ kɔ mbeeŋ nsaka wiwɔ, ka dzaka a, “Mih nì yɛiŋ Kiŋ'waka ki shi dzə bɛiŋ ka kimbumi, dzə num i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mih mwi nì kiəki kə wi. Ayakalə, mi wə wi nì faaŋ mih a mih dzə̂ jûliki bəni i bɔkɔ a nì kɔ wi dzaka i mih a, ‘Mi wə wɔ ni yɛiŋ Kiŋ'waka shi dzə i bɛiŋ ka num i wi wə, akɔ wi wə wi ni juliki bəni num i Kiŋ'waka ki Baiŋni wə.’ ");
INSERT INTO cug_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yələ kɔ gia yə mih nì yɛiŋ, ka numki mbeeŋ nsaka wiwɔ a mi wələ kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chɔkɔ buku wɔɔ, Jɔn ka chu numki i fɛiŋ i di biə wi nì kɔ bəh bwa bu bə mbaŋ bəfa. ");
INSERT INTO cug_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wi dza yɛiŋ si Jisɔs nyaniki tsəki, ka dzaka a, “Mbɛiŋ tsɛ̂iŋ, wələ kɔ Waiŋ Jaka wi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bwa bu bə mbaŋ bə bəfa bə̀ wɔkɔ si wi dzaka yakadəiŋ, dza ka biəliki Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisɔs fiəni gwu yɛiŋ si bɔ biəliki, ka bikə i bɔ a, “Mbɛiŋ nəŋki nə?” Bɔ chukuli i wi a, “Labay, wɔ nɔki faiŋ?” (Yɛli wələ a Labay kɔ a, “Mi wi Lanini wi Mbum.”). ");
INSERT INTO cug_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jisɔs chukuli i bɔ a, “Mbɛiŋ dzə̂ yɛ̂iŋ.” Bɔ tsə ka yɛiŋ di biə wi nì nɔki. Bəh bɔ shi fɛiŋ fuu dzə jum. Jɔbi wə bɔ nì biəliki wi a nì kɔ ka mbiəŋə mina i fijɔbi. ");
INSERT INTO cug_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Mi wimu widɔkɔ i bəni bəfa bə̀ kintəəŋ bɔ nì wɔkɔ si Jɔn dzaka ka biəli Jisɔs, a nì kɔ num Andulu wə waiŋnih Samɔn Bita. ");
INSERT INTO cug_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andulu wiwɔ nyə akisəkə tsə nəŋ waiŋnih wi Samɔn, fuku i wi a, “Buku si yɛiŋ Kimbwili wə Nyɔ nì kaka” (a num a Klistus). ");
INSERT INTO cug_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ayakadəiŋ, wi ka dzɔ dzə bəh Samɔn i Jisɔs. Jisɔs tsɛiŋ wi ləəə, ka dzaka a, “Wɔ kɔ Samɔn waiŋ Jɔn. Bə ni bɔɔŋki wɔ a Sɛfas.” (Yɛli wələ a Sɛfas kɔ a Bita). ");
INSERT INTO cug_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chɔkɔ buku wɔɔ, Jisɔs yɛiŋ a ŋgaiŋ si kɔlə i tsə i kimbu ki Galili wə. Wi tsə ka yɛiŋ Filib, dzaka i wi a, “Wɔ bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filib wələ nì kɔ mi i kwili wi Besayda wə. Kwili wələ nì kɔ wi Andulu bəh Bita. ");
INSERT INTO cug_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filib tsə nəŋ Natanial dzaka i wi a, “Buku yɛiŋ lɔ mi wə Muses nì nyaka i Kiŋwakti ki Bənchi wə kɔm wi, bəh wə bəni bə ntum bə Nyɔ nì nyaka tə kɔm wi. Mi wələ kɔ num Jisɔs wi Nasali waiŋ Yɔsɛf.” ");
INSERT INTO cug_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanial chukuli i wi a, “Gia yindzɔŋni yidɔkɔ kɔlə i buku dzə i Nasali a?” Filib dzaka i wi a, “Dzə̂ yɛ̂iŋ.” ");
INSERT INTO cug_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisɔs dza yɛiŋ si Natanial dzəki i wi wə, wi ka dzaka i wi kɔm wi, “Mbɛiŋ tsɛ̂iŋ, mi wələ kɔ na mi wi Islae wi ŋkɔŋ. Nɔni kintəkə kidɔkɔ kɔkə i wi wə.” ");
INSERT INTO cug_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanial bikə i Jisɔs a, “Wɔ nyani dəiŋ ka wɔ kiə mih?” Jisɔs chukuli i wi a, “Na ka Filib tsɛiŋki i dzə bɔɔŋ wɔ, asi kɔ num mih si yɛiŋ lɔ wɔ i chwɔŋ ki kpɛiŋ wi fig wə.” ");
INSERT INTO cug_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanial chukuli i wi a, “Labay, wɔ kɔ Waiŋ Nyɔ! Wɔ num Ŋkuŋ wi Islae!” ");
INSERT INTO cug_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisɔs dzaka i wi a, “Wɔ bum mih i liə kɔm mih dzaka i wɔ a mih si yɛiŋ wɔ i chwɔŋ ki kpɛiŋ wə a? Wɔ bi yɛiŋki lə gia yimbum yi tsə yələ.” ");
INSERT INTO cug_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisɔs chu dzaka i wi a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ bi yɛiŋ lə si bɔɔli wɛli gwu, bəchinda bə Nyɔ yaka chu shi, i mi wə yɛli wi kɔ Waiŋmi wə.” ");
INSERT INTO cug_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A dzə num i kaŋ yitali wə, bə ka fəki bini bi ndzɔ wi miŋkpaŋa wimfiaŋ, a nì kɔ i kwili wi Kana wə i kimbu ki Galili wə, ayaka nih Jisɔs num fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Bə nì kɔ bə laka tə Jisɔs bəh bwa bu bə mbaŋ i bini biwɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mbih dza kaa, nih Jisɔs ka dzaka i wi fɛiŋ a, “Bə chu kaŋaki kə mbih.” ");
INSERT INTO cug_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisɔs chukuli i wi a, “Miŋkpaŋa, yələ kaŋaki i fə nə bəh mih a? Jɔbi wuŋ ka kpəŋ dəkə.” ");
INSERT INTO cug_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nih wi ka dzaka i bəni bə gaani a, “Gia yichi yə wi ni dzaka a mbɛiŋ fə̂, mbɛiŋ fə̂.” ");
INSERT INTO cug_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A nì kɔ bikəŋə bisɔ num fɛiŋ num bə kɛiŋsi bəh təh. Kəŋə yələ nì kɔ yə Bəju nì jiəki mwi yɛiŋ a bɔ wɔkɔki gwu yibɔ yɛiŋ yi baiŋ i Nyɔ nshiŋ. Kpəŋə wimu nì dzɔki lə mwi ka bəlita mbaŋnanitaŋ ntsɔ bəte (75) i tsə buku bəlita gbi jwɔfi ntsɔ bəte (115). ");
INSERT INTO cug_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisɔs ka dza dzaka i bəni bə gaani bəwɔ a, “Mbɛiŋ tɔ̂kɔ jîksi mwi i kəŋə yələ mə.” Bɔ ka jiə mwi i kəŋə yiwɔ mə yi jikə. ");
INSERT INTO cug_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wi ka dzaka i bɔ a, “I liə mbɛiŋ tɔ̂kɔli midɔkɔ mbɛiŋ tsə̂ nyâ i fwu wi bəni bə gaani.” Bɔ ka tɔkɔli tsə nya. ");
INSERT INTO cug_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Fwu wi bəni bə gaani wə ka dzɔ mɔm mwi miwɔ, wɔkɔ num mɔ fiəni lɔ i mbih. Wi bə́ məŋ a mələ mbih nyə faiŋ na. (Ayakalə, bəni bə gaani bə̀ bɔ nì tɔkɔ mwi miwɔ nì kiəki lə di biə mɔ buku). Ayaka fwu wi bəni bə gaani ka bɔɔŋ nyum miŋkaŋa wimfiaŋ wiwɔ, ");
INSERT INTO cug_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","bikə i wi a, “Bəni si yisi gaa fibɔ num mbih mi ndzɔŋni i bini wə, i jɔbi wə bəni mu fwuli, bɔ ka gaa mə mɔ ndzɔŋki kə. Wɔ ka yiŋni jiə mbih mə mɔ ndzɔŋki ka dzəki bəh mɔ num i liə a?” ");
INSERT INTO cug_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kələ nì kɔ kinchəsi ki ninshiŋ kə Jisɔs nì fə yi chusi kiŋkɔkni ki. Wi nì fə yi num i kwili wi Kana wə i kimbu ki Galili wə. Si wi fə yakadəiŋ yi chusi kiŋkɔkni ki, bwa bu bə mbaŋ ka jiə shɔm yibɔ i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Si yəmaka nì tsə, Jisɔs ka nyə shi tsə i Kafanaum bəh nih wi bəh bwa bə nih wi bə nyuku bəh bwa bu bə mbaŋ, bəh bɔ nɔ dzɔ fɛiŋ i kaŋ yidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Chɔkɔ bi Dzini bi Bəju bə nì bɔɔŋki a Ntsədaŋ nì kɔmsiki dzəki, Jisɔs nyə yaka tsə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Si wi nì tsə buku i juŋ yi fəni yi gia wə, yɛiŋ bəni bɔ taŋni bənaʼ bəh shwáŋ bəh bimbumi bəh bəni bə̀ bɔ nì kwuniki kpɔ num bɔ numyi i kuku fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wi dzɔ bəkwu ka kɛiŋsi figbaŋa yɛiŋ, kɔŋŋ bwili bɔ bəchi tasi bəh shwáŋ bəh bənaʼ bəwɔ i juŋ yi fəni yi gia wə. Wi chu shuku tɔkɔ kpɔ wi bəni bə̀ bɔ nì kwuniki, chini shi bibaŋ bibɔ, ");
INSERT INTO cug_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","dzaka i bəni bə̀ bɔ nì taŋniki bimbumi a, “Mbɛiŋ dzɔ̂ bûku bəh biɛiŋ biələ fa. Kiə mbɛiŋ ki dzɔ̂ kə juŋ yi Bah wuŋ i fîəni i juŋ yi shi wə.” ");
INSERT INTO cug_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Si wi dzaka yakadəiŋ, bwa bu bə mbaŋ ka kwaka gia yə bə nyaka i Kiŋwakti ki Nyɔ wə a, “Kiŋkɔŋ kimbum kə mih kaŋaki i wɔ dzu ki kɔlə i wɔɔ mih num wɔɔni.” ");
INSERT INTO cug_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Kifwu ki Bəju ka bikə i wi a, “Gia yə yi chusiki kiŋkɔkni ka, yə wɔ kɔ i fə i chusi i buku a bə nya ŋga i wɔ i fə̂ yələ akɔ na nə?” ");
INSERT INTO cug_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisɔs chukuli i bɔ a, “Mbɛiŋ shâkyi juŋ yi fəni yi gia yələ, ma mih ni dzɔ kaŋ yitali mih fiəni dzasi yaksi yi i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Bəju bəwɔ ka dzaka i wi a, “Yi nì dzɔ jía mbaŋnyani ntsɔ bəsɔ i maa juŋ yi fəni yi gia yələ, wɔ bə́ dzaka mfia a wɔ kɔlə i dzɔ a kaŋ yitali i fiəni dzasi yaksi yi a?” ");
INSERT INTO cug_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ayakalə, juŋ yi fəni yi gia yələ Jisɔs nì dzakaki, a nì kɔ num gwu yi. ");
INSERT INTO cug_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ayakadəiŋ, jɔbi wə wi nì dza i kpi wə, bwa bu bə mbaŋ ka kwaka a fa kɔ gia yə wi nì dzaka. Bɔ ka bum gia yə yi kɔ i Kiŋwakti ki Nyɔ wə, chu bum ndzaka wə Jisɔs nì dzakaki. ");
INSERT INTO cug_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jɔbi wə Jisɔs nì kɔ i Jɛlusalɛm i Dzini bi Ntsədaŋ biə wə, bəni bəduli nì jiə shɔm yibɔ i yɛli wi wə kɔm bə binchəsi biə wi nì fəki ki chusi kiŋkɔkni ki. ");
INSERT INTO cug_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ayakalə, Jisɔs nì ka jiə dəkə mfi bi i bɔ, kɔm wi nì kiəki lə bəni bəchi si bɔ kɔ. ");
INSERT INTO cug_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wi nì nəŋki kə i wɔkɔ gia yidɔkɔ yə mi wiwɔm widɔkɔ fukuki i wi kɔm mi, kɔm wi nì kiəki lə fiɛŋ fiə fikɔ i mi wiwɔm shɔm. ");
INSERT INTO cug_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mi wi mbaŋ wi Bəfalasi widɔkɔ nì kɔ bə bɔɔŋ a Nikɔdəmus, wi num mi i mbaŋ wi kifwu ki tumi ki Bəju wə. ");
INSERT INTO cug_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mi wələ nì dza dzə i Jisɔs nchɔkɔ, ka dzaka i wi a, “Labay, buku kiəki lə a wɔ kɔ mi wi lanini wə wi nyə i Nyɔ, kɔm mi widɔkɔ kɔkə wə wi kɔ i fə kinchəsi ki gia yələ wɔ fəki lə, yi chusi kiŋkɔkni ki Nyɔ, Nyɔ kɔbi bəh wi.” ");
INSERT INTO cug_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisɔs chukuli i wi a, “Mih fukuki ŋkɔŋ i wɔ a, a kɔbi a bə bwɔ lə mi, i mbwɔ wimfiaŋ wə, wəmaka mi kɔkə bi yɛiŋ ŋkuŋ bi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikɔdəmus bikə i Jisɔs a, “Yi kɔ i num na dəiŋ, i chu bwɔ mi num wi ta lɔ a? Wi kɔlə i chu fiəni liə i nih wi shɔm ka wi chu fiəni bwɔ wi a?” ");
INSERT INTO cug_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisɔs chukuli i wi a, “Mih fukuki ŋkɔŋ i wɔ a, a kɔbi a bə bwɔ lə mi i mwi mə bəh i Kiŋ'waka wə, wi kɔkə i bi liə i ŋkuŋ bi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Mi wiwɔm bwɔki mi wiwɔm, kiŋ'waka bwɔ Kiŋ'waka. ");
INSERT INTO cug_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Kiə dzaka ma wɔ̂mki wɔ, a mih dzakaki i wɔ a bə kaŋaki i bwɔ̂ mbɛiŋ bəchi i mbwɔ wimfiaŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Fiəkə si tsə asi yi kɔŋki, wɔ wɔkɔ si yi tsəki, ayakalə wɔ kɔbi i fuku a yi nyə faiŋ na, yi tsə sə faiŋ na. Yi kɔ a liŋ i mi wichi wə wi kɔ num bə bwɔ wi i Kiŋ'waka wə.” ");
INSERT INTO cug_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikɔdəmus ka təmki a, “Yələ kɔ i nyani dəiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisɔs chukuli i wi a, “Wɔ kɔ mi wi lanini wi bəni bə Islae, wɔ kiə kə yələ a? ");
INSERT INTO cug_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mih fukuki ŋkɔŋ i wɔ a, buku dzakaki gia num yə buku kiəki, beeŋ nsaka wi gia, a num yə buku kɔ buku yɛiŋ, ayakalə mbɛiŋ bum kə gia yə buku dzakaki. ");
INSERT INTO cug_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mih kabə fuku gia i mbɛiŋ a num yi fa kuku mbɛiŋ bum kə, mbɛiŋ bi nyani na dəiŋ i bum yə mih dzakaki a num yi tumi ki bɛiŋ wə a? ");
INSERT INTO cug_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mi widɔkɔ mɔŋ wə wi num yaka i bɛiŋ. Akɔ shəŋ a wi wə wi nì nyə dzə fɛiŋ ka shi dzə fa kuku, mi wələ kɔ mi wə yɛli wi kɔ Waiŋmi. ");
INSERT INTO cug_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Asi Muses nì shəŋsi juŋŋ yə bə nì kɛiŋsi bəh chwaka i kpɛiŋ bɛiŋ i chwa, yi kɔ a liŋ asi bə kaŋaki i ni shə̂ŋsi mi wə yɛli wi kɔ Waiŋmi, ");
INSERT INTO cug_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ka na ndə wə wi kɔ wi jiə shɔm i wi wə, wi ni kwati nɔni kə ki bi tsə kaa kə.” ");
INSERT INTO cug_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nyɔ nì kɔŋ mbi wələ nalə, ka faaŋ Waiŋ wi wimu shəŋ, a na ndə wə wi jiə shɔm i wi bi laka kə, wi bi kwatiki num nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyɔ nì ka faaŋ dəkə Waiŋ wi i mbi wələ wə a wi dzə̂ sâka bəni a bɔ gbɔ nsaka. Wi nì faaŋ a wi dzə̂ bwîli bɔ num bwilini. ");
INSERT INTO cug_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","A na ndə wə wi kɔ wi jiə shɔm i wi wə, bi gbɔ kə nsaka. Ayakalə, mi wə wi ka jiə dəkə shɔm i wi wə, wəmaka gbɔ lɔ nsaka, kɔm wi ka jiə dəkə shɔm i yɛli wi Waiŋ Nyɔ wə akɔ a wi shəŋ. ");
INSERT INTO cug_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yələ kɔ dzəh yə bə bi təiŋki nsaka wiwɔ yɛiŋ, kɔm baiŋni kɔ bi dzə i mbi wə, bəni yiŋni kɔŋ fibɔ num lɔ jisi tsə baiŋni. Bɔ kɔŋki yakadəiŋ kɔm kimfə kibɔ kɔ kichu. ");
INSERT INTO cug_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Na ndə wə kimfə ki kɔ kichu wi si baiŋŋ lə baiŋni, wi kɔkə i buku dzə i di biə baiŋni kɔ ka kimfə ki ma ni chusi. ");
INSERT INTO cug_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ayakalə, na ndə wə wi fəki gia yi chəŋ wi si dzə num i baiŋni wə, ka kimfə ki ni chusiki a, akɔ ki mi wə wi kɔ bəh Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Si yəmaka nì tsə, Jisɔs bəh bwa bu bə mbaŋ nyə tsə i kimbu kidɔkɔ wə i Judea. Bəh bɔ tsə ka num fɛiŋ, wi ka juliki bəni i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jɔn tə nì juliki bəni i bɔkɔ i kwili wi Ɛnɔn wə i kɔmsi i Salim kɔm mwi nì kɔ fɛiŋ nalə. Bəni ka dzəki wi juli bɔ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yələ gia nì num maka bə fah Jɔn i juŋ yi nsəŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Bwa bə Jɔn bə mbaŋ bədɔkɔ bəh mi wi Ju widɔkɔ ni dza yisi kiŋgukuli kɔm bə gwu yi wɔkɔni i baiŋki i Nyɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bwa bə mbaŋ bə Jɔn nyə tsə yɛiŋ Jɔn, dzaka i wi a, “Labay, mi wə mbɛiŋ wi nì kɔ i waka wi Jɔdan wəyaka wə wɔ lansi dzaka kɔm wi yaka, bə wi yaka wi juliki bəni i bɔkɔ, bəni bəchi tsə num i wi.” ");
INSERT INTO cug_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jɔn chukuli i bɔ a, “Mi kɔkə i num fiɛŋ fidɔkɔ maka a fə Nyɔ a wi num fi. ");
INSERT INTO cug_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mbɛiŋ mwi kɔlə i beeŋ nsaka wuŋ a mih nì dzaka a, mih kɔkə Kimbwili wə Nyɔ nì kaka. Ayakalə, bə nì faaŋ mih a mih tsə̂ i wi nshiŋ. ");
INSERT INTO cug_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nyum miŋkpaŋa wimfiaŋ kɔ mi wə wi kaŋaki miŋkpaŋa wiwɔ. Nsɛiŋ wi nyum miŋkpaŋa wiwɔ wə wi num bɛiŋ kɔmsi i wi wə wɔkɔ ja yi, si num bə kinsaŋli na bəh ŋga si wi wɔkɔ ja yi. Yi kɔ a liŋ si mih kɔ i liə num mih jikə bəh kinsaŋli. ");
INSERT INTO cug_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wi kaŋaki i kɔki tsəki a ninshiŋ, mih dzə i jum wə. ");
INSERT INTO cug_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Mi wə wi nyə bɛiŋ wi tsəki lə bəni bəchi. Mi wi kuku kɔ mi wi kuku, gia yichi yə wi dzakaki akɔ yi fa kuku. Mi wə wi nyə i tumi ki bɛiŋ wə tsəki lə bəni bəchi, ");
INSERT INTO cug_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","wi beeŋki nsaka wi gia a num yə wi kɔ wi yɛiŋ ka chu wɔkɔ. Ayakalə, mi widɔkɔ kɔkə wə wi bumki gia yə wi dzakaki. ");
INSERT INTO cug_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mi wə wi bumki gia yə wi dzakaki, akɔ wi wə wi chusi a ŋgaiŋ tɔbi gia wiwɔ a Nyɔ dzakaki ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mi wə Nyɔ faaŋ si dzaka shəŋ a ja yi Nyɔ, kɔm Nyɔ nya Kiŋ'waka ki i wi kimfəkəli kɔbi. ");
INSERT INTO cug_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tii Waiŋ kɔŋ Waiŋ, ka nya biɛiŋ bichi i wi kaŋ. ");
INSERT INTO cug_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Na ndə wə wi kɔ wi jiə shɔm i Waiŋ wələ wi kwati lɔ nɔni kə ki bi tsə kaa kə. Mi wə wi wɔkɔki kə i wi bi kwati kə nɔni. Wəmaka mi kɔ num shɔm yi Nyɔ bɔkɔ lɔ bəh wi.” ");
INSERT INTO cug_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jisɔs ka kiə a, Bəfalasi wɔkɔ lɔ a ŋgaiŋ nɔmki lə, mbaŋ wi bəni dzə ŋgaiŋ juli bɔ i bɔkɔ tsə Jɔn. ");
INSERT INTO cug_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ayakalə, a nì mɔŋ dəkə Jisɔs si wi nì juliki mbɛiŋ i bɔkɔ, a nì juliki num bwa bu bə mbaŋ shəŋ. ");
INSERT INTO cug_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jɔbi wə wi nì kiə yakadəiŋ, ka nyə i kimbu ki tumi ki Judea wə, ka fiəni tsəki i ki Galili wə. ");
INSERT INTO cug_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wi nì kaŋaki i tsə dzəh i kimbu ki Samalia wə. ");
INSERT INTO cug_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Wi tsə buku i kwili wi Samalia widɔkɔ wə bə bɔɔŋ a Sika, wi num kɔmsi i khə wə Yakɔb nì nya i waiŋ wi Yɔsɛf. ");
INSERT INTO cug_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Dzəŋə yi mwi yə Yakɔb nì chum num fɛiŋ. Si Jisɔs nì kɔ wi nyani lɔ nalə ka bɔh, wi ka num kɔmsi i dzəŋə yi mwi yiwɔ wə. Jɔbi num wi si num ka mbiəŋə jwɔfi ntsɔ bəfa nshifɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Miŋkpaŋa widɔkɔ i fɛiŋ Samalia dza dzə i tɔkɔ mwi fɛiŋ, Jisɔs dzaka i wi a, “Nyâ mih bəh mwi mih mu.” ");
INSERT INTO cug_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","A nì kɔ num bwa bə mbaŋ bə Jisɔs tsə i kwili kintəəŋ i taŋ biɛiŋ bidzini. ");
INSERT INTO cug_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Miŋkpaŋa wiwɔ bikə i Jisɔs a, “Wɔ kɔ mi wi Ju, mih num mi wi Samalia, wɔ nyani dəiŋ na ka wɔ nywaki mwi i mih a?” Miŋkpaŋa wiwɔ nì dzakaki yakadəiŋ, kɔm Bəju nì nyɛnsiki lə bəni bə Samalia. ");
INSERT INTO cug_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisɔs chukuli i wi a, “Wɔ kabə kiə kinya kə ki kɔ ki Nyɔ, bəh ŋkaiŋni mi wə wi dzakaki i wɔ a wɔ nyâ ŋgaiŋ bəh mwi, ma wɔ tsa wi, a wi nyâ wɔ bəh mwi mə mɔ nyaki nɔni jɔbi wichi.” ");
INSERT INTO cug_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Miŋkpaŋa wiwɔ fiəni bikə i Jisɔs a, “Bah wuŋ, wɔ kaŋaki kə fiɛŋ fidɔkɔ ka wɔ tɔkɔli mwi yɛiŋ, dzəŋə yi mwi yiwɔ liə nalə, wɔ ki dzɔki faiŋ mwi mə mɔ nyaki nɔni jɔbi wichi a? ");
INSERT INTO cug_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yi kɔ a wɔ tsəki lə tii wibuku Yakɔb wə wi nì chum jiə dzəŋə yələ i buku, na wi mwi nì muki lə mwi yɛiŋ wə, bwa bu mu, nyám yi mu tə a?” ");
INSERT INTO cug_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisɔs chukuli i wi a, “Mi wichi wə wi mu mwi mələ, kindɔŋ ki mwi bi fiəni wɔmki lə wi. ");
INSERT INTO cug_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ayakalə, na ndə wə wi mu mwi mə mih nya i wi, kindɔŋ ki mwi bi chu wɔmki kə wi. Mwi mə mih ni nya i wi mɔ bi fiəni chu ntɔŋ wi mwi mə mɔ bukuki i wi wə jɔbi wichi, mɔ dzə nya wi bəh nɔni kə ki bi tsə kaa kə.” ");
INSERT INTO cug_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Miŋkpaŋa wiwɔ ka dzaka i Jisɔs a, “Bah wuŋ, nyâ mih bəh ŋkaiŋni wi mwi mələ, mə kindɔŋ ki mwi bi chu wɔmki kə mih ka mih ma chu dzə̂ki fa i dzə̂ tɔ̂kɔ mwi.” ");
INSERT INTO cug_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisɔs dzaka i wi a, “Tsə̂ bɔ̂ɔŋ nyu wa ma mbɛiŋ wi dzə̂.” ");
INSERT INTO cug_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Miŋkpaŋa wiwɔ chukuli i wi a, “Mih kaŋaki kə minyuku.” Jisɔs ka dzaka i wi a, “Wɔ dzaka ŋkɔŋ si wɔ dzaka a wɔ kaŋaki kə minyuku. ");
INSERT INTO cug_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wɔ kɔ wɔ si kaŋa lɔ bənyuku bəte, wə mbɛiŋ wi kɔ i liə a mɔŋ nyu wa. Gia yə wɔ dzakaki akɔ ŋkɔŋ.” ");
INSERT INTO cug_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Miŋkpaŋa wiwɔ dzaka i Jisɔs a, “Bah wuŋ, mih yɛiŋ i liə a wɔ kɔ mi wi ntum wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Bətii bəbuku nì shiki tsaki Nyɔ i ŋkwuŋ wələ wə, ayaka mbɛiŋ Bəju dzaka fimbɛiŋ a di biə bəni kaŋaki i tsâki Nyɔ kɔ a i Jɛlusalɛm.” ");
INSERT INTO cug_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jisɔs chukuli i wi a, “Miŋkpaŋa, bum gia yə mih fukuki i wɔ. Jɔbi bi dzəki lə wə mbɛiŋ bi tsaki i Ba Nyɔ a chu num kə i ŋkwuŋ wələ wə nabə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mbɛiŋ bəni bə Samalia tsaki fiɛŋ fiə mbɛiŋ kiəki kə, ayaka buku Bəju tsa fiɛŋ fiə buku kiəki, kɔm mbɔiŋ tsəki dzəh i Bəju wə. ");
INSERT INTO cug_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ayakalə, jɔbi dzəki lə, ayaka wi dzə lɔ wə bəni bə̀ bɔ tsaki Nyɔ ŋkɔŋ ŋkɔŋ bi tsaki Nyɔ Ba i kiŋ'waka wə bə i ŋkɔŋ wə. Fa kɔ ŋkaiŋni wi bəni bə̀ Nyɔ Ba nəŋki a bɔ tsaki i wi. ");
INSERT INTO cug_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyɔ kɔ kiŋ'waka, bəni bə̀ bɔ tsaki i wi, kaŋa i tsaki i kiŋ'waka wə bə i ŋkɔŋ wə.” ");
INSERT INTO cug_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Miŋkpaŋa wiwɔ dzaka i Jisɔs a, “Mi kiəki lə a Kimbwili wə Nyɔ nì kaka dzəki lə, wə bə bɔɔŋ a Klistus. I jɔbi wə wi bi dzəki, wi bi fuku baiŋsi lə gia yichi i bukumbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jisɔs dzaka i wi a, “Mih wələ mih dzakaki i wɔ akɔ wi wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","A jɔbi wiwɔ wə, bwa bə Jisɔs bə mbaŋ ka fiəni dzə. Dzaka wɔm bɔ a wi dzakaki bə miŋkpaŋa. Ayakalə, mi widɔkɔ i bɔ wə nəki bikə kə i wi a wi nəŋki nə a, nabə a Jisɔs dzakaki bə miŋkpaŋa wələ kɔm nə a. ");
INSERT INTO cug_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Miŋkpaŋa wiwɔ ka jiə bee kpəŋə wi wi mwi fɛiŋ, tsə i kwili kintəəŋ fuku i bəni a, ");
INSERT INTO cug_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mbɛiŋ dzə̂ yɛiŋ mi widɔkɔ wə wi dzə ka fukuki gia yichi yə mih num fə. Yi kɔlə i numki a mi wələ kɔ Kimbwili wə Nyɔ nì kaka a?” ");
INSERT INTO cug_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bəni buku i kwili wə ka tsəki i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A nì kɔ bwa bə mbaŋ bə Jisɔs baaŋ a tsaki Jisɔs dzaka i wi a, “Labay, dzî.” ");
INSERT INTO cug_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ayakalə, Jisɔs chukuli i bɔ a, “Mih kaŋaki lə biɛiŋ bidzini i dzi mbɛiŋ kiə kə bi.” ");
INSERT INTO cug_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Bwa bu bə mbaŋ ka kaiŋyiki dzakayi a bɔ bɔ a, “Mi widɔkɔ baaŋ dzə nya lə biɛiŋ bidzini i wi a?” ");
INSERT INTO cug_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisɔs dzaka i bɔ a, “Biɛiŋ biŋ bidzini kɔ i fə̂ki gia yə wi wə wi faaŋ mih kɔŋki, bəh i kâasi nɔm wi wichi. ");
INSERT INTO cug_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ntə mbɛiŋ dzakaki fimbɛiŋ a baaŋ kifiəŋŋ kinaa, ka jɔbi wi kɔhni kpɛiŋ na? Mih dzaka i mbɛiŋ a, mbɛiŋ gîŋsi dzə́kəh i bɛiŋ ma mbɛiŋ tsɛ̂iŋ yɛ̂iŋ asi biɛiŋ kpɛiŋ i kikhə wə ka bə kɔ̂hki. ");
INSERT INTO cug_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mi wə wi kɔhki kaŋaki lə ŋgɔm wi, wi juŋniki jiəki dzɛiŋ i nɔni kə ki bi tsə kaa kə, ayaka ka mi wə wi gbɛli bəh mi wə wi kɔhki bi chiŋniki laŋki lə i mi wimu wə. ");
INSERT INTO cug_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gia yələ chusiki a ndi wələ kɔ ŋkɔŋ wə wi dzakaki a, ‘Mi widɔkɔ si gbɛli lə, ayaka mi widɔkɔ kɔh.’ ");
INSERT INTO cug_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mih faaŋ mbɛiŋ a mbɛiŋ tsə̂ kɔ̂h biɛiŋ biə mbɛiŋ nì ka nɔm dəkə. Bəni bədɔkɔ nɔm, mbɛiŋ liə i ndzɔŋni bi nɔm wibɔ wə.” ");
INSERT INTO cug_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Bəni bə Samalia bəduli i kwili wiwɔ wə nì jiə shɔm i Jisɔs wə kɔm bə gia yə miŋkpaŋa wiwɔ nì dzaka i bɔ, a wi fuku ŋgaiŋ gia yichi yə ŋgaiŋ nì kɔ num ŋgaiŋ fə. ");
INSERT INTO cug_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ayakadəiŋ, jɔbi wə bɔ nì dzə yɛiŋ Jisɔs, tsa a bəh bɔ nɔ̂. Wi bum, bəh bɔ nɔ kaŋ yifa. ");
INSERT INTO cug_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bəni bəduli ka chu jiə shɔm i Jisɔs wə kɔm bə ndzaka wi. ");
INSERT INTO cug_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Bəni bəwɔ dzaka i kpaŋa wiwɔ a, “Buku ka jiə dəkə shɔm i wi a kɔm gia yə wɔ si dzaka shəŋ. Buku mwi si wɔkɔ lɔ bəh bintuni bibuku, ka kiə lɔ a mi wələ kɔ Mbwili wi mbi wələ ŋkɔŋ.” ");
INSERT INTO cug_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kaŋ yiwɔ yifa tsə, Jisɔs nyə ka tsəki i Galili. ");
INSERT INTO cug_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wi mwi nì kɔ num wi dzaka lɔ a bə si kɔksi kə mi wi ntum wi Nyɔ i tumi ki wə. ");
INSERT INTO cug_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jɔbi wə wi nì tsə buku i Galili, bəni bə fɛiŋ dzɔ wi bindzɔŋ, kɔm bɔ nì kɔ bɔ yɛiŋ gia yə wi nì fə i bini wə i Jɛlusalɛm, kɔm bɔ tə nì kɔlə i bini biwɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisɔs ka bi chu fiəni tsə i Kana i kimbu ki Galili wə di biə wi nì fiəni mwi i mbih. A nì kɔ tikwili widɔkɔ num i kwili wi Kafanaum wə, waiŋ wi winyukuni gwɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jɔbi wə tikwili wiwɔ nì wɔkɔ a Jisɔs buku lɔ i Judea ka dzə i Galili, wi tsə i wi, kwuŋ kaŋ a wi shî dzə̂ chûku waiŋ wi ŋgaiŋ, a wi si num lɔ a dzaka ki kpi wə. ");
INSERT INTO cug_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisɔs ka dzaka i wi a, “Mbɛiŋ kabə num maka mbɛiŋ yɛiŋ kinchəsi kə ki chusiki kiŋkɔkni ki Nyɔ, i yɛiŋ tə gia yi dzaka ki wɔmni, mbɛiŋ bi ma lansi jiə shɔm i mih.” ");
INSERT INTO cug_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mi wimbum wiwɔ dzaka i wi, “Ba wuŋ, dzə̂ bə kɔmsi nyə̂, ka waiŋ wuŋ ma kpi.” ");
INSERT INTO cug_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisɔs chukuli i wi a, “Wɔ tsə̂, waiŋ wa ni baaŋ lə wiwɔm.” Mi wiwɔ nì bum gia yə Jisɔs dzaka i wi, nyə ka tsəki. ");
INSERT INTO cug_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Si wi nì shiki, wi bəh bwa bu bə nɔm baŋsi, bɔ fuku i wi a waiŋ wi kɔlə wiwɔm. ");
INSERT INTO cug_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Wi ka bikə i bɔ jɔbi wə wi ni yisi i bɔniki. Bɔ dzaka i wi a, “A nì kɔ i ŋgbu aka mbiəŋə wimu nshifɔkɔ, gwu yi yakani yiwɔ bee wi.” ");
INSERT INTO cug_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tii waiŋ wiwɔ ka kwaka asi kɔ na jɔbi wə Jisɔs si dzaka i wi a, “Waiŋ wa ni baaŋ lə wiwɔm.” Wi bəh juŋ yi yichi ka jiə shɔm i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Gia yələ kɔ yi kɔmsini yə yi chusiki kiŋkɔksi yə Jisɔs nì fə asi wi buku i Judea ka dzə i Galili. ");
INSERT INTO cug_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Si yəmaka nì tsə, bini bi Bəju bidɔkɔ num i Jɛlusalɛm, Jisɔs yaka tsə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Dzəŋə yi mwi yidɔkɔ num fɛiŋ i Jɛlusalɛm bə bɔɔŋ i já yi Hibulu wə a Bɛtɛsda, ayaka yi num kɔmsi tsə i Dzaka Ki mbaiŋ ki Shwáŋ wə. Bɔ nì kɔ bɔ maa kidi ki shini fɛiŋ kite, ");
INSERT INTO cug_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","bəni bə jwɛ́iŋ nì shi kwu kɔ a fɛiŋ bəduli nalə, a nì kɔ num bimfəkə, bəh bə̀ bɔ nì gbɔki nyaniki bəh bə̀ bɔ nì kpiyi wa wimu. Bɔ nì shiki nɔyiki fɛiŋ wɔkɔli i jɔbi wə mwi miwɔ ni dza nəŋni. ");
INSERT INTO cug_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Chinda wi Bah widɔkɔ nì fəki wi dza dzə i jɔbi jɔbi wə, wi liə nəŋni mwi miwɔ. Mi wi ninshiŋ wə wi yisi liə yɛiŋ kintəəŋ i jɔbi wə chinda wiwɔ nəŋni mwi miwɔ, ma wi ni bɔnih i jwɛiŋ yiwɔ wə, kɔŋ a numki na yi naiŋ jwɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Mi widɔkɔ nì kɔlə fɛiŋ num wi gwɛiŋ i jía mbaŋtia ntsɔ nyaŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jɔbi wə Jisɔs nì dzə fɛiŋ yɛiŋ wi, kiə a wi nɔ fɛiŋ na i jɔbi wi dəəŋ wə, ka bikə i wi a, “Wɔ kɔŋki lə i bɔnih a?” ");
INSERT INTO cug_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mi wi jwɛiŋ wiwɔ chukuli a, “Tikwili, mih kaŋaki kə mi widɔkɔ wə wi kɔ i ləkəsi mih i bɔkɔ yələ wə jɔbi wə yi nəŋni. Asi num jɔbi wə yi nəŋni, mih ka nəŋki i liə num mi widɔkɔ si yisi liə lɔ i ninshiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jisɔs dzaka i wi a, “Dzâ bɛiŋ, dzɔ̂ kiga ka, wɔ tsə̂ki.” ");
INSERT INTO cug_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Akisəkə, mi wiwɔ ka bɔnih, dzɔ kiga ki ka tsəki. A nì kɔ chɔkɔ biwɔ num chɔkɔ bimbam. ");
INSERT INTO cug_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Bəju ka dzaka i mi wə bə nì chuku a, “Daiŋ kɔ chɔkɔ bimbam nchi bum kə a wɔ gîŋ kiga ka.” ");
INSERT INTO cug_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wi chukuli i bɔ a, “Mi wə wi si chuku mih si dzaka a mih dzɔ̂ kiga kəŋŋ mih tsə̂ki.” ");
INSERT INTO cug_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Bɔ bikə i wi a, “Akɔ ndə wiwɔ wi si dzaka i wɔ a wɔ dzɔ kiga ka ma wɔ tsəki a?” ");
INSERT INTO cug_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mi wə bə nì chuku, nì lansiki kiəki kə mi wə wi chuku wi, kɔm Jisɔs nì kɔ wi dza liə tsə i kintəəŋ ki mbaŋ wi bəni bə̀ bɔ nì kɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Si yəmaka nì tsə, Jisɔs yɛiŋ wi i juŋ yi fəni yi gia mə, dzaka i wi a, “Tsɛîŋ si wɔ kɔ wɔ bɔnih lɔ. Kiə wɔ ma chu fə̂ki chu. Wɔ ka baaŋ a fəki chu, gia yi gumini yidɔkɔ ni gbɔ i wɔ fuŋ tsə yələ.” ");
INSERT INTO cug_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Mi wiwɔ nyə tsə fuku i Bəju a, akɔ Jisɔs wə wi si chuku ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bəju ka yisi ka bwaŋki gvu i Jisɔs chɛiŋ, kɔm wi nì chuku mi wiwɔ a num chɔkɔ i bimbam wə. ");
INSERT INTO cug_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisɔs dzaka i bɔ a, “Ba wuŋ si nɔm jɔbi wichi, mih tə nɔmki ayaka.” ");
INSERT INTO cug_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ndzaka wələ fə Bəju ka fiəni nəŋki wi na bəh ŋga i wɔ̂ɔ, kɔm a nì kɔkə shəŋ a chɔkɔ bimbam wi nì bwiŋ. Wi nì bɔɔŋki tə Nyɔ a Ba wi, chu fəkəni a ŋgaiŋ kɔ a liŋ bəh Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisɔs dza dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a mih Waiŋ kɔkə fə gia yidɔkɔ i ŋga mbiŋ wə. Mih fəki shəŋ a gia yə mih yɛiŋ Ba wuŋ fə. Gia yə Tii Waiŋ fəki, akɔ a yə Waiŋ fəki tə, ");
INSERT INTO cug_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","kɔm Tii Waiŋ wiwɔ kɔŋki lə Waiŋ ka chusi i Waiŋ gia yichi yə wi Tii Waiŋ fəki. Wi kɛiŋ i chu chusi gia i wi yi tsə yələ, ka wi fəki, mbɛiŋ yɛiŋ dzaka wɔm mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Si Tii Waiŋ dzasiki bəni i kpi wə nya nɔni i bɔ, kɔ a liŋ si Waiŋ nyaki nɔni i na ndə wə wi kɔŋki. ");
INSERT INTO cug_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","I kpɛiŋsi yɛiŋ kɔ a Tii Waiŋ sakaki kə mi widɔkɔ. Wi kɔ num wi nya bənsaka bəchi i Waiŋ kaŋ, ");
INSERT INTO cug_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ka bəni bəchi kɔ̂ksiki Waiŋ a liŋ si bɔ kɔksiki Ba wi. Mi kabə num wə wi kɔksiki kə Waiŋ, yaka wi kɔksiki kə Ba wi wə wi faaŋ wi. ");
INSERT INTO cug_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Mih fukuki ŋkɔŋ i mbɛiŋ a mi wə wi wɔkɔ ja yiŋ, ka bum i mi wə wi faaŋ mih, kɔ wə wi kaŋaki nɔni kə ki bi tsə kaa kə. Wəmaka bi chu kaŋa kə nsaka. Wəmaka mi kɔ wi buku lɔ i kaŋ yi kpi wə, ka liə i nɔni wə. ");
INSERT INTO cug_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mih fukuki ŋkɔŋ i mbɛiŋ a jɔbi dzəki lə, num wi dzə lɔ, a bəni bə̀ bɔ kɔ bɔ kpiyi lɔ bi wɔkɔ ja yi Waiŋ Nyɔ, ayaka bə̀ bɔ bi wɔkɔki, bɔ bi kwati lə nɔni. ");
INSERT INTO cug_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yi kɔ yakadəiŋ kɔm si nɔni nyəki dzəki i Ba, yi kɔ a liŋ si wi nya ŋga biwɔ i Waiŋ wi a nɔni nyəki dzə̂ki tə i wi. ");
INSERT INTO cug_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wi kɔ wi nya tə ŋga i Waiŋ a wi təiŋyiki bənsaka, kɔm akɔ wi mi wə yɛli wi kɔ Waiŋmi. ");
INSERT INTO cug_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kiə dzaka ma wɔ̂mki mbɛiŋ kɔm yi. Jɔbi dzəki lə wə bəni bəchi bə̀ bɔ kɔ i júm kintəəŋ bi wɔkɔki ja yiŋ, ");
INSERT INTO cug_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","bɔ bukuyi i júm wə, ma bə̀ bɔ nì fəki gia yindzɔŋni bi bukuyi liə i nɔni kə ki bi tsə kaa kə, ma bə̀ bɔ nì fəki gia yichu bi bukuyi lə ma bə saka bɔ, bɔ gbɔ nsaka. ");
INSERT INTO cug_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mih kɔkə i fə gia yidɔkɔ i ŋga mbiŋ wə. Mih sakaki bənsaka biəli asi mih wɔkɔki, dzəh yə mih təiŋki yɛiŋ num yi chəŋ, kɔm mih nəŋki kə i fəki num gia yə a kɔŋki mih. Mih fəki num gia yə, mi wə wi faaŋ mih kɔŋki. ");
INSERT INTO cug_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mih ka fiəni beeŋ nsaka wuŋ, ma gia yə mih dzakaki ma yi ma numki chəŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ayakalə, mi widɔkɔ kɔlə wə wi beeŋki nsaka wuŋ, ayaka mih kiəki lə a gia yə wi dzakaki kɔm mih kɔ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mbɛiŋ nì faaŋ bəni i Jɔn, wi tsə beeŋ nsaka kɔm ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yi kɔkə a mih nəŋki a mi wiwɔm dzâkaki mi wə mih kɔ wi. Ayakalə, mih dzakaki lə ka mbɛiŋ kələ bi bɔiŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jɔn nì kɔ aka naka ki baiŋsiki num bə baiŋsi ki bɛli ki nya baiŋni, mbɛiŋ nì kɔŋki a numki i baiŋni biwɔ kintəəŋ, a jɔbi wi juli wə, laŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Fiɛŋ fidɔkɔ kɔlə fiə fi chusiki mi wə mih kɔ wi fi tsə Jɔn. Yi num a, nɔm wə Ba wuŋ kɔ wi nya a mih nɔ̂m kâasi, a num gia yələ mih fəki lə, yi chusiki a faaŋ Ba wuŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ba wuŋ wə wi faaŋ mih akɔ wi mwi tə wi kɔ mbeeŋ nsaka wuŋ. Mbɛiŋ ka num wɔkɔ dəkə lɔ ja yi, ayaka mbɛiŋ ka num yɛiŋ dəkə si wi kɔ. ");
INSERT INTO cug_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mbɛiŋ kaŋaki kə tə ja yi i shɔ́m yimbɛiŋ wə, kɔm mbɛiŋ ka jiə dəkə shɔm i mi wə wi faaŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mbɛiŋ nəŋki i Kiŋwakti ki Nyɔ mə kɔm mbɛiŋ kwakaki a, akɔ yɛiŋ di biə mbɛiŋ bi kwatiki fiɛŋ fiə fi kɔ i fəki a mbɛiŋ kwati nɔni kə ki bi tsə kaa kə. Gia yə yi kɔ i Kiŋwakti kələ mə yi dzakaki num kɔm bə mih. ");
INSERT INTO cug_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ayakalə, mbɛiŋ ka chu nəiŋki i dzə i mih i kwati nɔni. ");
INSERT INTO cug_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mih nəŋki kə kiŋkɔksi kə ki nyəki dzəki i mi wiwɔm wə. ");
INSERT INTO cug_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ayakalə, mih kiəki lə mbɛiŋ. Mih kiə a mbɛiŋ kaŋaki kə na kiŋkɔŋ ki Nyɔ i shɔ́m yimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mih dzə i yɛli wi Ba wuŋ wə, mbɛiŋ nəki dzɔ kə mih. Asi kɔ mi widɔkɔ si wi dzə i yɛli wi wə, ma kɔ wəmaka mbɛiŋ si dzɔ. ");
INSERT INTO cug_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mbɛiŋ kɔ i nyani dəiŋ i bum i mih, mbɛiŋ num bəni bə̀ bɔ nəŋki kiŋkɔksi kə ki nyəki dzəki a i mbɛiŋ wə, nəŋ kə kiŋkɔksi kə ki nyəki dzəki num i Nyɔ a num a ki shəŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mbɛiŋ ma kwakaki a, akɔ mih wə mih bi tɔyiki chwɔŋ kimbɛiŋ i Ba wuŋ wə. Akɔ Muses wə mbɛiŋ jiə mfi bimbɛiŋ i wi, a num wi wə wi tɔyiki chwɔ kimbɛiŋ i Ba wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","A nì kɔ a mbɛiŋ bum i Muses wə ŋkɔŋ, ma mbɛiŋ bum mih kɔm wi nì nyaka kɔm mih. ");
INSERT INTO cug_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ayakalə, na si mbɛiŋ nì ka bum dəkə gia yə wi nì nyaka, mbɛiŋ kɔ i nyani dəiŋ i bum gia yə mih dzakaki a?” ");
INSERT INTO cug_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Si yəmaka nì tsə Jisɔs nyə tsə daŋ kinchwɔ kimbum ki Galili, tsə i waka widɔkɔ wə. Bɔkɔ yələ kɔ yə bə bɔɔŋki tə a yi Tibɛlias. ");
INSERT INTO cug_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mbaŋ wi bəni kwu i wi chɛiŋ kɔm bɔ nì kɔ bɔ yɛiŋ bənchəsi bə̀ bɔ chusiki kiŋkɔkni ki, si wi nì fəki i bəni bə̀ bɔ nì gwɛiŋki bəh jwɛiŋ wi chukuki bɔ. ");
INSERT INTO cug_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisɔs bəh bwa bu bə mbaŋ nyə yaka tsə shinum i ŋkwuŋ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A nì kɔ jɔbi wiwɔ wə, Dzini bi Bəju bi Ntsədaŋ nì kɔ bi si kɔmsi dzə. ");
INSERT INTO cug_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jɔbi wə Jisɔs nì lɔ dzə́kəh, ka yɛiŋ si mbaŋ wi bəni dzəki i wi wə, wi ka bikə i Filib a, “Bukumbɛiŋ ki nyaniki dəiŋ ka bə taŋ biɛiŋ bidzini biə bəni bələ kɔ i dzi a?” ");
INSERT INTO cug_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Wi nì bikəki yakadəiŋ mɔmsi Filib mɔmsini, kɔm wi mwi nì kiəki lə gia yə wi kɔ i fə. ");
INSERT INTO cug_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filib chukuli i wi a, “Bədanali gi yifa kɔkə i kpɛiŋ na ka bə taŋ biɛiŋ bidzini biə mi wimu i bɔ wə kɔ i kwati twɛsi twɛsi.” ");
INSERT INTO cug_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Waiŋ wi mbaŋ widɔkɔ yɛli wi nì kɔ Andulu a num waiŋnih Samɔn Bita ka dzaka i wi a, ");
INSERT INTO cug_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Waiŋ wi nyukuni widɔkɔ kɔlə fa wi kaŋa chɔkɔ yi blɛd yite bəh bwɔkɔ yifa, ayakalə yələ kɔ i fə na nə bəh ŋkaiŋni bəni bəduli bələ a?” ");
INSERT INTO cug_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisɔs dzaka a, “Mbɛiŋ dzâka bəni nûmyi kuku.” A nì kɔ mfwaŋ num fɛiŋ nalə, bɔ ka dzaka a bɔ numyi, bənyuku shəŋ nì kɔ bənchuku bəte. ");
INSERT INTO cug_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jisɔs ka dzɔ chɔkɔ yi blɛd yə, nya kiyɔŋni i Nyɔ, ka gaa i bəni bə̀ bɔ nì numyi fɛiŋ. Wi fə a liŋ bəh bwɔkɔ yiwɔ. Ayaka mi wichi kwati asi wi nì kɔŋki. ");
INSERT INTO cug_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Bɔ dzi fwuli, wi dzaka i bwa bu bə mbaŋ a, “Mbɛiŋ jûŋni biŋka biə ka fiɛŋ fidɔkɔ ma lâka kilɔlɔ.” ");
INSERT INTO cug_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ayakadəiŋ, bɔ ka juŋni biŋka bi blɛd biə bi nì bɛsi i chɔkɔ yi blɛd yə wə yite, bi jikə káh jwɔfi ntsɔ yifa. ");
INSERT INTO cug_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jɔbi wə bəni bəwɔ nì yɛiŋ gia yələ yi chusiki kiŋkɔkni ki yə wi fə, ka dzaka a, “Mi wələ lansi kɔ ŋkɔŋ Mi wi Ntum wi Nyɔ wə wi nì kaŋaki i bi dzə̂ i mbi wələ wə.” ");
INSERT INTO cug_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jɔbi wə Jisɔs nì kiə a bəni bədɔkɔ nəŋki i dzə kwa ŋgaiŋ bəh ŋga, i tɔm ka ŋkuŋ wibɔ, wi baka gwu fiəni yaka tsə i ŋkwuŋ bɛiŋ ka numki fɛiŋ wi mbɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Aka dzə num i fijɔbi, bwa bu bə mbaŋ shi tsə i kinchwɔ kimbum wə, ");
INSERT INTO cug_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","liə i ŋgwuki mə yisi i daŋki tsəki i Kafanaum. I jɔbi wiwɔ wə nì kɔ biŋ ji lɔ, Jisɔs kɛiŋ maka wi dzə buku i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Bɔkɔ dza ka fəyiki, kɔm fuŋni kiləkəli nì tsəki lə. ");
INSERT INTO cug_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jɔbi wə bɔ ni na ŋgwuki tsə buku ka bəmay bətali yudɔkɔ ka bənaa, bɔ dza təkəli yɛiŋ Jisɔs si wi nyaniki dzəki i mwi bɛiŋ wi kɔmsi dzə i ŋgwuki wibɔ wə. Ndzaŋ kwa bɔ. ");
INSERT INTO cug_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ayakalə, wi dzaka i bɔ a, “Kiə mbɛiŋ ki lwâ kə. Akɔ mih.” ");
INSERT INTO cug_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Si bɔ wɔkɔ yakadəiŋ, ka kɔŋki i dzɔ wi i ŋgwuki wiwɔ mə. Akisəkə, ŋgwuki wiwɔ tsə buku i bɔkɔ kpəŋ i di biə bɔ nì tsəki. ");
INSERT INTO cug_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chɔkɔ buku wɔɔ, bəni bə̀ bɔ nì baaŋ i kiwuŋ ki bɔkɔ kəyaka wə ka yɛiŋ a, asi baaŋ a ŋgwuki wimu fɛiŋ, bɔ kiə a Jisɔs si ka liə dəkə ŋgwuki wə bwa bu bə mbaŋ si liə yɛiŋ, a bwa bu bə mbaŋ si dza nyə a bɔ bɔ. ");
INSERT INTO cug_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ayakalə, bəŋgwuki bədɔkɔ nì dza i kimbu ki Tibɛlias daŋ dzə, i kɔmsi i di biə Bah nì dzɔ blɛd ka nya kiyɔŋni yɛiŋ i Nyɔ, bəni dzi. ");
INSERT INTO cug_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Si bəni bəwɔ ni yɛiŋ a Jisɔs nabə bwa bu bə mbaŋ nì kɔkə fɛiŋ, bɔ ka liəyi i bəŋgwuki mə bə́ daŋ tsə i Kafanaum i nəŋ Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jɔbi wə bɔ nì tsə yɛiŋ wi i kiwuŋ kidɔkɔ kəyaka wə, bɔ bikə i wi a, “Labay, wɔ si dzə fa yibwiŋ?” ");
INSERT INTO cug_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisɔs chukuli i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ nəŋki kə mih kɔm mbɛiŋ yɛiŋki mih fə kinchəsi kə ki chusiki kiŋkɔkni kiŋ. Mbɛiŋ nəŋki mih kɔm mbɛiŋ ni dzi chɔkɔ yi blɛd yə ka fwuli. ");
INSERT INTO cug_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kiə mbɛiŋ ma nɔ̂mki a i kwâti biɛiŋ bidzini biə bi kɔ i bəkə. Mbɛiŋ nɔ̂mki i kwâti num biɛiŋ bidzini biə bi bi baaŋki a fɛiŋ i tsə buku i nɔni kə ki bi tsə kaa kə. Biələ kɔ biə mi wə yɛli wi kɔ Waiŋmi wi ni nya i mbɛiŋ. A num wi wə Nyɔ Ba kɔ wi jiə kaŋ yi i wi wə i chusi a ŋgaiŋ bum wi.” ");
INSERT INTO cug_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Bɔ ka bikə i wi a, “Na gia yə buku kaŋaki i fə̂ki, ka yi numki a buku fəki num nɔm wi Nyɔ, akɔ yi naiŋ?” ");
INSERT INTO cug_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jisɔs chukuli i bɔ a, “Nɔm wi Nyɔ kɔ wələ, a mbɛiŋ jîə shɔ́m yimbɛiŋ i mi wə wi faaŋ.” ");
INSERT INTO cug_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ayakadəiŋ, bɔ ka bikə i wi a, “Gia yə yi kɔ yi chusi kiŋkɔkni ka, yə wɔ kɔ i fə a buku yɛiŋ, ka buku jiə shɔ́m yibuku i wɔ kɔ yi naiŋ? Gia yə wɔ kɔ i fə kɔ na nə a? ");
INSERT INTO cug_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bətii bəbuku nì dziki mana i chwa, yi num asi bə nyaka a, ‘Wi nì nya bɔ bəh biɛiŋ bidzini biə bi nì nyə i bɛiŋ bɔ dzi.’” ");
INSERT INTO cug_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Si bɔ dzaka yakadəiŋ, Jisɔs ka chukuli i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ, a kɔkə dəkə Muses wə wi nì nya biɛiŋ bidzini biə bi nyəki dzəki i bɛiŋ i mbɛiŋ. Akɔ num Ba wuŋ wə wi nyaki biɛiŋ bidzini bi ŋkɔŋ biə bi nyəki dzəki i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mbɛiŋ kîəki a biɛiŋ bidzini bi Nyɔ kɔ biə bi nyə bɛiŋ shi dzə ka nyaki nɔni i bəni i mbi wələ wə.” ");
INSERT INTO cug_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Bɔ dzaka i wi a, “Bah, ma wɔ nyâki buku bəh biɛiŋ bidzini biwɔ jɔbi wichi.” ");
INSERT INTO cug_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisɔs ka dzaka i bɔ a, “Akɔ mih biɛiŋ bidzini biwɔ bi nyaki nɔni. Na ndə wə wi dzə i mih, dzɔŋ bi chu wɔɔ kə wi. Ayaka na ndə wə wi jiə shɔm yi i mih, kindɔŋ bi chu wɔm kə wi. ");
INSERT INTO cug_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ayakalə, mih fuku lɔ i mbɛiŋ a mbɛiŋ yɛiŋ mih, ayaka mbɛiŋ kɛiŋ ki jiə kə shɔm i mih. ");
INSERT INTO cug_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bəni bəchi bə Ba wuŋ kɔ wi nya i mih, bɔ ni dzəki i mih. Ayaka mi wə wi dzə i mih, mih bi kɔŋŋ kə wi. ");
INSERT INTO cug_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mih nyə bɛiŋ dzə fa kuku. Mih ka dzə dəkə i fə̂ num gia yə mih kɔŋki. Mih dzə i fə̂ num gia yə mi wə wi faaŋ mih kɔŋki. ");
INSERT INTO cug_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Gia yə mi wə wi faaŋ mih kɔŋki kɔ yələ a, kiə mih bi ma lâksi na mi wimu i bəni bə wi nya i mih, ayakalə a mih bi bwîli bɔ num bwilini i kpi wə i chɔkɔ bi gɔksini wə. ");
INSERT INTO cug_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Mbɛiŋ kiə a gia yə Ba wuŋ kɔŋki kɔ yələ a, yi num a na ndə wə wi kɔ wi yɛiŋ waiŋ wi, ka jiə shɔm i wi, wəmaka bi kwatiki lə nɔni kə ki bi tsə kaa kə, ayaka mih bi dzasi wi i kpi wə i chɔkɔ bi gɔksini wə.” ");
INSERT INTO cug_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Bəju ka yisi i shwiŋyiki wi kɔm wi nì kɔ wi dzaka a, ŋgaiŋ kɔ biɛiŋ bidzini biə bi nyə bɛiŋ ka shi dzə i fa kuku. ");
INSERT INTO cug_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Bɔ ni shwiŋyiki bikəyi a, “Ntə wələ kɔ a Jisɔs wə waiŋ Yɔsɛf wə a? Ntə ba wi bəh nih wi kɔ a bə̀ bukumbɛiŋ kiəki bɔ a? Yi ka nyani dəiŋ i liə ka wi dzakaki a ŋgaiŋ nyə num bɛiŋ?” ");
INSERT INTO cug_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisɔs chukuli i bɔ a, “Mbɛiŋ ki shuŋyi kə a mbɛiŋ mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mi widɔkɔ kɔkə i dzə i mih wə məŋni si Ba wuŋ wə wi faaŋ mih guku dzə bəh wi i mih wə. Ayaka ka mih bi dzasi wi i kpi wə i chɔkɔ bi gɔksini wə. ");
INSERT INTO cug_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Bəni bə ntum bə Nyɔ nì nyaka a, ‘Nyɔ ni laniki lə bɔ bəchi.’ Ayakadəiŋ mi wichi wə wi wɔkɔ nlani wi Ba wuŋ wi kiə, yi ni numki a wi ni dzə lə i mih wə. ");
INSERT INTO cug_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Mih dzakaki kə lə a mi widɔkɔ kɔlə num wi num yɛiŋ Ba wuŋ. Akɔ a wi shəŋ wə wi nyə dzə i Nyɔ wə, wi kɔ num wi yɛiŋ Ba wi. ");
INSERT INTO cug_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mih fukuki ŋkɔŋ i mbɛiŋ a, mi wə wi kɔ num wi bum, wi bi kwati lɔ nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Mih kɔ biɛiŋ bidzini biə bi nyaki nɔni i bəni. ");
INSERT INTO cug_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Bətii bəmbɛiŋ nì dzi mana i chwa, ayakalə ka dzə kpi a kpini. ");
INSERT INTO cug_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Biɛiŋ bidzini biələ kɔ biə bi nyə bɛiŋ ayaka ka dzə, a mi wə wi ka dzi bi wi bi chu kpi kə. ");
INSERT INTO cug_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Akɔ mih biɛiŋ bidzini biwɔ biə bi nyə bɛiŋ, biə bi nyaki nɔni i bəni. Mi ka dzi i biɛiŋ bidzini biələ, wi bi baaŋ lə wiwɔm jɔbi wichi kiŋgɔksi kɔbi. Ayaka biɛiŋ bidzini biwɔ biə mih bi nyaki ka bəni bə mbi wələ bi kwati nɔni akɔ num gwu yiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Bəju ka dza yisi i gukuliki a bɔ bɔ bikə a, “Mi wələ kɔ nyani dəiŋ ka wi nya gwu yi a bukumbɛiŋ dziki a?” ");
INSERT INTO cug_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisɔs ka dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, a kɔbi a mbɛiŋ dzi lə gwu yi mi wə yɛli wi kɔ Waiŋmi, ka chu mu tə mwa mu, ma mbɛiŋ ma ni kaŋaki nɔni i mbɛiŋ mə. ");
INSERT INTO cug_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mi wə wi dziki gwu yiŋ chu mu mwa məŋŋ wi kaŋaki lə nɔni kə ki bi tsə kaa kə. Ayaka mih bi bwiliki lə wi i kpi wə i chɔkɔ bi gɔksini, ");
INSERT INTO cug_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","kɔm gwu yiŋ kɔ na biɛiŋ bidzini, mwa məŋŋ num na biɛiŋ bi muni. ");
INSERT INTO cug_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mi wə wi dziki gwu yiŋ chu mu mwa məŋŋ wi nɔki i mih wə mih tə nɔ i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ba wuŋ wə wi faaŋ mih wi kaŋaki lə nɔni, mih tə kaŋaki lə nɔni kɔm Ba wuŋ. Ayakadəiŋ, mi wə wi dziki gwu yiŋ bi kaŋaki lə tə nɔni kɔm mih. ");
INSERT INTO cug_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Biələ kɔ biɛiŋ bidzini biə bi nyə bɛiŋ dzə. Bi kɔbi ka biə bətii bəmbɛiŋ nì dzi ka dzə kpi a kpini. Mi wə wi dziki biɛiŋ bidzini biələ wi bi baaŋ a wiwɔm jɔbi wichi kiŋgɔksi kɔbi.” ");
INSERT INTO cug_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Gia yələ kɔ yə Jisɔs nì dzakaki i jɔbi wə wi nì laniki bəni i juŋ yi tsani mə i Kafanaum. ");
INSERT INTO cug_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bəni bə Jisɔs bə mbaŋ bəduli nì wɔkɔ nlani wələ ka dzaka a, “Wələ kɔ ndzaka wi ləkə! Akɔ ndə i bum ŋkaiŋni wi ndzaka wələ lə a?” ");
INSERT INTO cug_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ayakalə, Jisɔs kîə a bəni bu bə mbaŋ shwiŋyiki a bɔ bɔ kɔm ndzaka wiwɔ, ka bikə i bɔ a, “Gia yələ mih dzaka, yi nəŋni lə shɔm yimbɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A kabə num yaka mbɛiŋ bi fə nə i jɔbi wə mbɛiŋ bi yɛiŋ mi wə yɛli wi kɔ Waiŋmi wi fiəni yaka tsə i di biə wi nì yisi kɔ a? ");
INSERT INTO cug_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Kiŋ'waka ki Nyɔ kɔ fiɛŋ fiə fi nyaki nɔni. Nyam yi gwu kaŋaki kə na gia yidɔkɔ i fə. Ndzaka wə mih dzakaki i mbɛiŋ lə kɔ Kiŋ'waka, a num fiɛŋ fiə fi nyaki nɔni. ");
INSERT INTO cug_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ayakalə, mbɛiŋ bədɔkɔ ka bum dəkə ndzaka wiwɔ.” Jisɔs nì dzaka yələ kɔm wi ni kiəki lə i kin'yisi wə bəni bə̀ bɔ ka jiə dəkə shɔ́m i wi wə, wi kiə tə mi wə wi ni taŋni wi. ");
INSERT INTO cug_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Wi chu dzaka i bɔ a, “Akɔ gia yə mih si kɔ mih dzaka lɔ i mbɛiŋ a, mi widɔkɔ kɔkə i dzə i mih maka Ba wuŋ nya dzəh i wi.” ");
INSERT INTO cug_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Asi yəmaka nì tsə, bəni bu bə mbaŋ bəduli ka gbɔyi i jum wə na chu nyaniki bəh wi. ");
INSERT INTO cug_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisɔs dza bikə i bwa bu bə mbaŋ, bə jwɔfi ntsɔ bəfa a, “Mbɛiŋ tə kɔŋki lə i dza nyə a?” ");
INSERT INTO cug_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Samɔn Bita chukuli i wi a, “Bah, buku kɔ i tsə i ndə. A kaŋa wɔ ndzaka wə wi nyaki nɔni kə ki bi tsə kaa kə, ");
INSERT INTO cug_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","num buku bum, chu kiə a wɔ kɔ wə wi Baiŋki num wi wə wi nyə i Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisɔs dzaka i bɔ a, “Ntə a sabi mih mbɛiŋ bələ jwɔfi ntsɔ bəfa a? Ayakalə, mi widɔkɔ i mbɛiŋ kintəəŋ kɔ ŋkpɛli.” ");
INSERT INTO cug_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jisɔs nì dzakaki yakadəiŋ a num kɔm Judas waiŋ Samɔn Iskaliɔt. Wi nì kɔ i mbaŋ wi bwa bə Jisɔs bə jwɔfi ntsɔ bəfa, a num wi wə wi kaŋaki i ni taŋni Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Si yəmaka nì tsə, Jisɔs ka baaŋ a nyaniki a i kimbu ki Galili wə. Wi nì ka chu tsə i ki Judea wə, kɔm Bəju nì nəŋki i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dzini bi Bəju biə bə nì bɔɔŋki a Dzini bi Bintaŋ bi ni kiniki dzəki lə. ");
INSERT INTO cug_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Bwa bə nih bə Jisɔs ka dzaka i wi a, “Bêe di biələ ma wɔ tsə̂ i Judea ka bəni ba bə mbaŋ ni yɛ̂iŋ nɔm wə wɔ nɔmki. ");
INSERT INTO cug_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mi kabə nɔm nnɔm nəŋ a bəni kîə wi, wi kɔkə i nɔmki wi nyumi nyumi. Si wɔ fəki gia yələ lə, tsə̂ chûsi gwu ya i mbi.” ");
INSERT INTO cug_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bwa bə nih wi bə̀ nì dzakaki yakadəiŋ kɔm bɔ nì ka lansi jiə dəkə shɔm yibɔ i wi. ");
INSERT INTO cug_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisɔs chukuli i bɔ a, “Jɔbi wuŋ ka kpɛiŋ dəkə. I mbɛiŋ jɔbi wichi si num wi kpɛiŋnini. ");
INSERT INTO cug_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Bəni bə mbi wələ kɔkə i baiŋŋki mbɛiŋ. Ayakalə, bɔ baiŋŋki mih kɔm mih dzakaki i bɔ a kimfə kibɔ kɔ kichu. ");
INSERT INTO cug_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mbɛiŋ yâkaki tsə̂ki fimbɛiŋ i Dzini biwɔ wə. Mih yakaki kə mfiŋ fɛiŋ. Jɔbi wuŋ ka dzə kpɛiŋ dəkə.” ");
INSERT INTO cug_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Si wi dzaka yakadəiŋ, ka baaŋ mfih i Galili. ");
INSERT INTO cug_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ayakalə, jɔbi wə bwa bə nih wi nì yaka tsə i Dzini biwɔ wə, wi baaŋ bɔŋ yaka tsə fɛiŋ. Jɔbi wə wi ni yakaki wi nì ka yaka n'yaka wə bəni kɔ yɛiŋki wi, wi nì yaka mfih num i nyumi wə. ");
INSERT INTO cug_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A nì kɔ Bəju si nəŋ lɔ wi i Dzini biwɔ wə, bɔ ka bikəki a, “Bə winaiŋ na?” ");
INSERT INTO cug_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bəni ka chumyiki dzakaki kɔm wi nalə, bədɔkɔ dzaka a, “Wi kɔ mi wi ndzɔŋni.” Bədɔkɔ dzaka a, “Wi fwɔkyiki bəni.” ");
INSERT INTO cug_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ayakalə, mi widɔkɔ fɛiŋ nəki dzaka bwili kə kɔm wi, kɔm bɔ nì lwaki kifwu ki Bəju. ");
INSERT INTO cug_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Si kaŋ yi dzini yiwɔ ni tsə buku i fintəŋ, Jisɔs tsə liə i juŋ yi fəni gia mə ka laniki bəni. ");
INSERT INTO cug_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kifwu ki Bəju wɔkɔ yaka num bəh ŋkaŋyi, ka bikəyiki a, “Mi wələ nyani dəiŋ na ka wi kiəki gia yələ məŋni si wi lani Kiŋwakti ki Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisɔs ka dza chukuli bɔ a, “Nlani wələ mih laniki lə kɔkə wuŋ. Akɔ wi mi wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mi kabə nəŋki num i fəki gia yə Nyɔ kɔŋki, wi ni ka kiə a nlani wələ nyəki dzəki num i Nyɔ wə, ma mih laniki num i ŋga biŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mi wə wi dzakaki i ŋga bi wə wi si nəŋ yɛli wimbum i wi wə. Ayakalə, mi wə wi si nəŋ yɛli wimbum num i yɛli wi mi wə wi faaŋ wi, wəmaka kɔ mi wi ŋkɔŋ ayaka ntəkə bidɔkɔ kɔbi i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ntə Muses nì nya bənchi i mbɛiŋ na? Ayakalə, na mi widɔkɔ i mbɛiŋ kintəəŋ jiəki kə bənchi bəwɔ! Mbɛiŋ nəŋki i wɔɔ mih kɔm nə?” ");
INSERT INTO cug_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Bəni bəwɔ chukuli i wi a, “Wɔ kaŋaki lə chinda wi ŋkpɛli i wɔ wə. Mi wə wi nəŋki i wɔɔ wɔ kɔ ndə a?” ");
INSERT INTO cug_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisɔs chukuli i bɔ a, “Mih nì fə nɔm wimu, mbɛiŋ num bəh ŋkaŋyi kɔm yi. ");
INSERT INTO cug_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muses nì kɔ wi nya nchi a mbɛiŋ suuŋki bwa. Na yaka wi nì ka buku dəkə num i Muses. Wi nì buku num i bətii bəmbɛiŋ. Mbɛiŋ ka suuŋki bwa na i chɔkɔ bimbam wə. ");
INSERT INTO cug_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Bə ka suuŋ mi i chɔkɔ bimbam ka bə ma bwiŋ nchi wi Muses, mbɛiŋ kabə bɔksi tɔɔ kɔm mih a mih chuku mi, wi bɔnih kaasi a num i chɔkɔ bimbam kɔm nə? ");
INSERT INTO cug_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mbɛiŋ ma chiŋki sakaki təiŋki nsaka maka mbɛiŋ tsɛiŋ ndzɔŋ. Mbɛiŋ sakaki num i dzəh yi chəŋ wə.” ");
INSERT INTO cug_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Bəni bə Jɛlusalɛm bədɔkɔ ka dza bikə a, “Wələ kɔkə a mi wə bə si nəŋki i wɔ̂ɔ wi a? ");
INSERT INTO cug_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mbɛiŋ yɛ̂iŋ bə wi lə fa, wi dzakaki i bəni kintəəŋ, na mi dzaka kə gia yidɔkɔ i wi. Yi kɔlə i numki a kifwu ki tumi si lansi kiə a mi wələ kɔ Kimbwili wə Nyɔ nì kaka a? ");
INSERT INTO cug_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ayakalə, bukumbɛiŋ kiəki lə di biə mi wələ buku. Ayaka jɔbi wə Kimbwili wə Nyɔ nì kaka bi dzəki mi widɔkɔ bi kiə kə di biə wi buku.” ");
INSERT INTO cug_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ayakadəiŋ, si Jisɔs nì laniki bəni i juŋ yi fəni gia mə wi dza ka wam bəh ŋga a “Mbɛiŋ kiəki lə mih kiə tə di biə mih buku. Ayakalə, mih ka dzə dəkə i ŋga biŋ wə, wi wə wi faaŋ mih kɔ mi wi ŋkɔŋ, ayaka mbɛiŋ kiə kə wi. ");
INSERT INTO cug_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Mih kiəki lə wi kɔm mih nyə i wi wə a num wi wə wi nì faaŋ mih,” ");
INSERT INTO cug_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Si wi dzaka yakadəiŋ, bəni bədɔkɔ ka nəŋki i kwa wi. Ayakalə, mi widɔkɔ nəki kɔm kə wi bəh kaŋ, kɔm jɔbi wi nì kɛiŋki ki kpɛiŋ kə. ");
INSERT INTO cug_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ayakalə, bəni bəduli jiə shɔm i wi dzakayi a, “Jɔbi wə Kimbwili wə Nyɔ nì kaka bi dzə, ma wi bi chu fə kinchəsi kə ki chusiki kiŋkɔkni ki Nyɔ tsə yə mi wələ fəki lə a?” ");
INSERT INTO cug_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jɔbi wə Bəfalasi nì wɔkɔ si mbaŋ wi bəni chumyiki dzakayiki kɔm Jisɔs, bɔ bəh bətii mfə gia bəmbum ka faaŋ bəni bə jum a bɔ tsə̂ kwâ wi. ");
INSERT INTO cug_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Si bɔ tsə, Jisɔs dzaka i bɔ a, “Mih ni num lə bəh mbɛiŋ a i jɔbi wə twɛsi, ma mih ka fiəni tsə i mi wə wi nì faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mbɛiŋ ni baaŋ nəŋ lə mih mbɛiŋ kɔbi i chu yɛiŋ i mih wə. Di biə mih tsəki mbɛiŋ kɔkə i dzə fɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kifwu ki Bəju ka dzakaki a bɔ bɔ a, “Mi wələ nəŋki i tsə faiŋ wə bukumbɛiŋ ni nəŋ wi bə kɔbi i ni chu yɛiŋ i wi wə a? Wi nəŋki i tsə i kitumi kə bəni bəbuku waŋ tsə i nɔki fɛiŋ, i tsə laniki bəni bə tumi bəwɔ a? ");
INSERT INTO cug_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Gia yə wi dzakaki a, ‘Mbɛiŋ ni baaŋ nəŋ lə mih mbɛiŋ kɔbi i chu yɛiŋ i mih wə, ayaka di biə mih tsəki mbɛiŋ kɔkə i dzə fɛiŋ,’ yəmaka kɔ a nə?” ");
INSERT INTO cug_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","A nì kɔ asi num chɔkɔ bi gɔksini bi Dzini, a num chɔkɔ bi dzini bimbum biwɔ, Jisɔs dza num bɛiŋ wam bə ja yiləkəli a, “Na ndə wə kindɔŋ wɔmki wi, wi dzə̂ i mih wi mû. ");
INSERT INTO cug_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mi wə wi kɔ wi jiə shɔm i mih yi bi num num asi Kiŋwakti ki Nyɔ dzakaki a, ‘Mwi mə mɔ nyaki nɔni mɔ ni bukuki i wi shɔm shi lə kɔkɔkɔ.’” ");
INSERT INTO cug_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yələ kɔ Jisɔs nì dzakaki kɔm Kiŋ'waka kə bəni bə̀ bɔ nì kɔ bɔ jiə shɔm i wi bi kwatiki. A nì kɔ i jɔbi wələ wə bə kɛiŋ maka bə nya Kiŋ'waka kiwɔ i bɔ, kɔm Jisɔs nì kɛiŋki maka bə yaksi wi ka wi liə i kiŋkɔkni ki wə. ");
INSERT INTO cug_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jɔbi wə bəni nì wɔkɔ gia yələ Jisɔs nì dzaka, bədɔkɔ ka dzakaki a, “Mi wələ kɔ na Mi wi Ntum wi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bədɔkɔ dzaka a, “Wələ kɔ Kimbwili wə Nyɔ nì kaka.” Ayakalə, bədɔkɔ bikə fibɔ a, “Yaka kɔ Kimbwili wə Nyɔ nì kaka kaŋaki i bi bûku num i Galili a? ");
INSERT INTO cug_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ntə Kiŋwakti ki Nyɔ dzakaki a Kimbwili wələ bi bukuki num i chwɔŋkijuŋ ki Ŋkuŋ Dɛbit wə, i kwili wi Bɛtelɛhɛm wə, a num kwili wi Dɛbit a?” ");
INSERT INTO cug_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Si bəni bəwɔ dzaka yakadəiŋ, kiŋgaali ka num i kintəəŋ kibɔ wə kɔm Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Bɔ bə bədɔkɔ ka nəŋki i kwa wi, ayakalə mi widɔkɔ nəki kɔm kə wi bəh kaŋ. ");
INSERT INTO cug_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Bəni bə jum bə̀ ka fiəni dzə i bətii mfə gia bəmbum bəh Bəfalasi, bɔ bikə i bəni bə jum bəwɔ a, “Mbɛiŋ ka dzə bəh wi fa kɔm nə?” ");
INSERT INTO cug_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Bəni bə jum bəwɔ chukuli i bɔ a, “Mi widɔkɔ nì ka num dzaka dəkə ka mi wələ” ");
INSERT INTO cug_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Bəfalasi bikə i bɔ a, “Yaka ka wi bɔŋ tsə fwɔkyi tə mbɛiŋ? ");
INSERT INTO cug_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mbɛiŋ yɛiŋ lə si kifwu ki tumi nabə Bəfalasi si bɔ jiə shɔm i wi wə a? ");
INSERT INTO cug_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Akɔ a mbaŋ wələ wi kiəki kə nchi wi Nyɔ. Lɔiŋ kɔ i bɔ fuŋ.” ");
INSERT INTO cug_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikɔdəmus wə wi nì kɔ mi widɔkɔ i mbaŋ wi Bəfalasi wə, num wi nì yisi tsə yɛiŋ Jisɔs i jɔbi widɔkɔ wə nì kɔlə fɛiŋ. Wi bikə i bɔ a, ");
INSERT INTO cug_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nchi wibukumbɛiŋ bum a bə kɔlə i tə̂iŋ nsaka wi mi maka bə yisi wɔ̂kɔli wɔ̂kɔ gia yə wi fə a?” ");
INSERT INTO cug_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Bɔ ka bikə i wi a, “Wɔ bɔŋ buku tə i Galili a? Nə̂ŋ i Kiŋwakti ki Nyɔ mə bindzɔŋ ma wɔ ni yɛiŋ a mi wi ntum wi Nyɔ widɔkɔ bi lansi buku kə i Galili.” ");
INSERT INTO cug_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Bɔ ka nyə, mi tsə i wi dzu, mi tsə i wi dzu. ");
INSERT INTO cug_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisɔs dza mfih ka tsə i Ŋkwuŋ yi Kɛiŋ yi Ɔlif wə. ");
INSERT INTO cug_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chɔkɔ buku wɔɔ, wi chu fiəni tsə i juŋ yi fəni yi gia mə. Bəni bəchi ka juŋniki kɔmsi dzəki i wi wə, wi shinum i kuku ka yisi i laniki bɔ. ");
INSERT INTO cug_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Bəni bə̀ bɔ nì laniki bənchi bəh Bəfalasi nyə dzə bəh miŋkpaŋa widɔkɔ si bɔ kwa wi, wi nɔ bə mi nyuku widɔkɔ. Si bɔ nì dzə bəh wi, ka tɔm wi i bɔ nshiŋ, ");
INSERT INTO cug_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","dzaka i Jisɔs a, “Mi wi Lanini, miŋkpaŋa wələ kɔ num bə si kwa wi, wi nɔ bəh minyuku widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","I bənchi wə kɔ num Muses nì dzaka a wələ miŋkpaŋa kɔ wə bə kaŋaki i tûmyi a tumyini bəh kitəh a wi kpî. Wɔ dzaka n'ya a nə a?” ");
INSERT INTO cug_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Bɔ nì fəki yakadəiŋ taaŋ lɔ Jisɔs taaŋni ka wi fîini bəh ndzaka ma bɔ ka ni kwâti gia yə bɔ ki jîəki i wi fuŋ. Ayakalə, Jisɔs ŋgwuŋ shi kuku ka nyakaki gia i kuku bəh waiŋkpaŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bɔ baaŋ a numki fɛiŋ i bikəyiki gia i wi. Wi giŋsi yaka gwu yi i bɛiŋ ka dzaka i bɔ a, “Mi kabə num i mbɛiŋ kintəəŋ wi kaŋa kə chu, wi nûm mi wi ninshiŋ i yisi tûm wi bəh təh.” ");
INSERT INTO cug_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Si Jisɔs dzaka yakadəiŋ, ka chu fiəni ŋgwuŋ shi i nyakaki gia i kuku bəh waiŋkpaŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Si bɔ wɔkɔ gia yə Jisɔs dzaka, bɔ yisi i gaaliki a fimu fimu yisi num bəh bəkukuli. Bɔ gaali, a dzə num baaŋ a miŋkpaŋa wiwɔ fɛiŋ i Jisɔs nshiŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jisɔs fiəni giŋsi gwu i bɛiŋ, ka bikə i miŋkpaŋa wiwɔ a, “Miŋkpaŋa, bə bɔ naiŋ? Mi widɔkɔ ka baaŋ dəkə wə wi dzaka a wɔ kaŋaki i kpî a?” ");
INSERT INTO cug_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wi chukuli a, “Mi widɔkɔ mɔŋ dəkə, Bah.” Jisɔs ka dzaka a, “Mih kɔkə i chu dzaka tə a wɔ kaŋaki lə i kpî. Wɔ tsə̂, ayakalə kiə wɔ ma chu fə̂ki chu.” ");
INSERT INTO cug_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisɔs chu dzaka i bəni a, “Mih kɔ baiŋni bi mbi wələ. Na ndə wə wi biəli mih wi ni nyaniki kə i jisi wə. Wi ni kaŋaki lə baiŋni biə bi nyaki nɔni i bəni.” ");
INSERT INTO cug_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Bəfalasi ka dzaka i wi a, “Wɔ beeŋki kiəki nsaka wa. Gia yə wɔ dzakaki yi kɔkə chəŋ.” ");
INSERT INTO cug_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisɔs chukuli i bɔ a, “Mih kabə beeŋki na nsaka wuŋ, gia yə mih dzakaki kɔ chəŋ, kɔm mih kiəki lə di biə mih nyə, kiə tə di biə mih tsəki. Ayakalə, mbɛiŋ kiəki kə di biə mih nyə nabə di biə mih tsəki. ");
INSERT INTO cug_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mbɛiŋ sakaki bəni ka bəni bəwɔm. Mih saka kə mfiŋ mi. ");
INSERT INTO cug_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ayakalə, mih si kɔ i saka na mi, yaka mih sakaki i dzəh yi chəŋ wə, kɔm mih sakaki kə mih mbɔŋ. Mih sakaki bəh Ba wuŋ wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","I kiŋwakti kimbɛiŋ ki bənchi wə kɔ bə nyaka a, bəni bəfa ka beeŋ nsaka i gia wə, yaka yi kɔ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mih beeŋki nsaka wuŋ, ayaka Ba wuŋ wə wi faaŋ mih beeŋ tə nsaka wuŋ.” ");
INSERT INTO cug_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Bɔ ka bikə i wi a, “Bə Ba wa naiŋ?” Jisɔs chukuli a, “Mbɛiŋ kiəki kə mih nabə Ba wuŋ. Mbɛiŋ kabə kiə mih, ma mbɛiŋ ni kiəki tə Ba wuŋ.” ");
INSERT INTO cug_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisɔs nì dzakaki gia yiwɔ yichi si wi laniki bəni i juŋ yi fəni yi gia mə, num wi num kɔmsi i di biə bə nì nyaki kpɔ i juŋ yi fəni yi gia mə. Ayakalə, mi na kwa wi, kɔm jɔbi wi nì kɔ maka wi kpɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisɔs chu dzaka i bɔ a, “Mih ni nyə lə, ayaka mbɛiŋ num i ni baaŋ nəŋki mih, mbɛiŋ ka bi kpiyi i chu bimbɛiŋ wə. Di biə mih tsəki mbɛiŋ kɔkə i dzə fɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Bəju ka bikə a, “Wi ni wɔɔ lə gwu yi ma, si wi dzakaki a ŋgaiŋ tsəki i di biə bukumbɛiŋ kɔkə i dzə fɛiŋ na?” ");
INSERT INTO cug_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisɔs dzaka i bɔ a, “Mbɛiŋ kɔ bəni bə fa kuku, mih nyə mfiŋ i bɛiŋ. Mbɛiŋ kɔ bəni bə mbi wələ. Mih kɔkə mi i mbi wələ. ");
INSERT INTO cug_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mih kɔ mih yisi dzaka lɔ a mbɛiŋ bi kpiyiki lə i kintəəŋ kichu bimbɛiŋ wə. Mbɛiŋ kiə a mbɛiŋ bi kpiyi i kintəəŋ kichu bimbɛiŋ wə i jɔbi wə mbɛiŋ ka bum dəkə a, akɔ mih wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Bɔ bikə i wi a, “Akɔ wɔ ndə?” Jisɔs chukuli a, “Mih kɔ mi wə mih si dzakaki i mbɛiŋ i kin'yisi wə. ");
INSERT INTO cug_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mih kaŋaki lə gia yiduli yə mih kɔ i dzaka kɔm mbɛiŋ bəh gia yiduli yə mih kɔ i sakaki mbɛiŋ yɛiŋ wə. Ayakalə, mi wə wi faaŋ mih akɔ mi wi ŋkɔŋ. Gia yə mih fukuki i mbi wələ wə kɔ yə mih wɔkɔ i wi.” ");
INSERT INTO cug_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Si wi dzaka yakadəiŋ, bɔ nì ka wɔkɔ kiə dəkə a wi dzakaki kɔm Ba wi. ");
INSERT INTO cug_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ayakadəiŋ, Jisɔs ka dzaka i bɔ a, “Jɔbi wə mbɛiŋ bi giŋsiki mi wə yɛli wi kɔ Waiŋmi i bɛiŋ, ma mbɛiŋ ka bi kiə a, akɔ mih wiwɔ, ayaka a mih fəki kə gia yidɔkɔ i ŋga biŋ wə, a mih dzakaki lə num asi Ba wuŋ lani mih. ");
INSERT INTO cug_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mi wə wi faaŋ mih wi kɔ buku wi. Wi ka bee dəkə mih a mih numki mih mbɔŋ, kɔm mih si fə gia i jɔbi wichi a num yə yi ndzɔŋki i wi.” ");
INSERT INTO cug_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Si Jisɔs ni dzakaki gia yiwɔ yakadəiŋ, bəni bəduli jiə shɔm i wi. ");
INSERT INTO cug_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisɔs ka dzaka i Bəju bə̀ bɔ nì jiə shɔm i wi a, “Mbɛiŋ ka baaŋ a ja yiŋ wə, mbɛiŋ numki na bəni mbəŋ bə mbaŋ ŋkɔŋ, ");
INSERT INTO cug_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","mbɛiŋ ka ni kiə ŋkɔŋ, ma ŋkɔŋ biwɔ ni bwili mbɛiŋ i mfa wə.” ");
INSERT INTO cug_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Bɔ chukuli i wi a, “Buku kɔ chwɔŋkijuŋ ki Ablaham, buku ka num, num dəkə mfa i mi widɔkɔ. Yi nyani dəiŋ ka wɔ dzakaki a buku bi buku lə i mfa wə a?” ");
INSERT INTO cug_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisɔs chukuli i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a mi wichi wə wi fəki chu kɔ mfa i chu wə. ");
INSERT INTO cug_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mfa kɔkə i bi baaŋ mi i chwɔŋkijuŋ kə wi kɔ yɛiŋ wə kpamu. Asi baaŋ a waiŋ yɛiŋ dzu mi wi chwɔŋkijuŋ kiwɔ wə kpamu. ");
INSERT INTO cug_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ayakadəiŋ, Waiŋ ka bwili mbɛiŋ i mfa wə, ma yi numki a mbɛiŋ buku lɔ i mfa wə ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mih kiəki lə a mbɛiŋ kɔ kimbwɔ ki Ablaham, ayakalə mbɛiŋ bə́ nəŋ i wɔɔ mih kɔm ja yiŋ kaŋaki kə di i mbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mih dzakaki num gia yə mih yɛiŋ i Ba wuŋ, mbɛiŋ fə fimbɛiŋ num gia yə mbɛiŋ wɔkɔ i ba wimbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Bɔ chukuli i wi a, “Ba wibuku kɔ Ablaham.” Jisɔs dzaka i bɔ a, “Asi kɔ a mbɛiŋ numki bwa bə Ablaham, ma mbɛiŋ fəki lə gia yə wi nì fəki. ");
INSERT INTO cug_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mih kɔ mi wə mih kɔ mih fuku gia yi ŋkɔŋ i mbɛiŋ yə mih wɔkɔki i Nyɔ. Ayakalə, i liə mbɛiŋ bə́ nəŋ i wɔɔ mih, yələ num kə gia yə Ablaham nì fəki. ");
INSERT INTO cug_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mbɛiŋ fəki num gia yə tii wimbɛiŋ fəki.” Bɔ dzaka i wi a, “Bə nì ka bwɔ dəkə buku i kuku. Buku kaŋaki a Ba wimu, a num Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisɔs dzaka i bɔ a, “Asi kɔ a Nyɔ numki tii wimbɛiŋ, ma mbɛiŋ kɔŋki lə mih, kɔm mih nyə i Nyɔ kpəŋ ka mih numki fa. Mih nì ka dzə dəkə i ŋga biŋ wə. A faaŋ wi mih. ");
INSERT INTO cug_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Akɔ kɔm nə mbɛiŋ wɔkɔki kə gia yə mih dzakaki a? Akɔ kɔm mbɛiŋ nəiŋki i wɔkɔ ja yiŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mbɛiŋ kɔ bwa bə tii wimbɛiŋ ŋkpɛli, yi num a gia yə mbɛiŋ kɔŋki i fəki kɔ yə tii wimbɛiŋ kɔŋki. I yisi i kin'yisi wə wi nì kɔ ŋ'wɔɔyi bəni. Wi kaŋaki kə gia yidɔkɔ i fə bəh ŋkɔŋ, kɔm wi kaŋaki kə ŋkɔŋ i wi wə na twɛsi. Jɔbi wə wi nyiki ntəkə, wi dzakaki asi nɔni ki kɔ, kɔm wi kɔ mi wi ntəkə a num wi tii ntəkə. ");
INSERT INTO cug_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ayakalə, mih dzakaki yiŋ a num ŋkɔŋ, akɔ gia yə mbɛiŋ bumki kə mih. ");
INSERT INTO cug_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Akɔ ndə i mbɛiŋ kintəəŋ wə wi kɔ i chusi chu biə mih fə a? Si mih dzakaki ŋkɔŋ i mbɛiŋ, Aka fə nə a mbɛiŋ ma bum mih a? ");
INSERT INTO cug_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mi wə wi kɔ mi wi Nyɔ si shi wɔkɔli a gia yi Nyɔ. Gia yə mbɛiŋ kɔŋki kə i wɔkɔli gia yi Nyɔ akɔ kɔm mbɛiŋ kɔkə bəni bə Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Bəju ka dzaka i Jisɔs a, “Buku si ka dzaka ŋkɔŋ i wɔ a, a wɔ kɔ mi wi Samalia chinda wi ŋkpɛli num i gwu ya wə a?” ");
INSERT INTO cug_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisɔs chukuli i bɔ a, “Chinda wi Satan kɔkə i mih wə. Mih kɔksiki lə mfiŋ Ba wuŋ, ayakalə mbɛiŋ kɔksi kə mih. ");
INSERT INTO cug_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yi kɔkə a mih nəŋki yɛli wimbum i mih wə. Mi widɔkɔ kɔlə wimu wə wi nəŋki wi, a num wi wə wi təiŋyiki bənsaka. ");
INSERT INTO cug_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mih fukuki ŋkɔŋ i mbɛiŋ a na ndə kabə wɔkɔ ja yiŋ, wi bi yɛiŋ kə kpi.” ");
INSERT INTO cug_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Bəju dzaka i wi a, “Buku kiə lɔ i liə a chinda wi ŋkpɛli kɔlə i gwu ya wə. Ablaham nì kpi, bəni bə ntum bə Nyɔ kpiyi tə, wɔ kabə dzaka a mi wə wi wɔkɔ gia ya, wi bi lansi musi kə kpi. ");
INSERT INTO cug_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wɔ tsəki lə tii wibuku Ablaham wə wi nì kpi, tsə tə bəni bə ntum bə Nyɔ bə̀ bɔ nì kpiyi tə a? Wɔ kwakaki a wɔ kɔ na nə?” ");
INSERT INTO cug_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisɔs chukuli a, “Mih kabə kɔksi num gwu yiŋ, ma kiŋkɔksi kiwɔ numki kilɔlɔ. Wə wi kɔksiki mih kɔ Ba wuŋ, a num wi wə mbɛiŋ dzakaki a, akɔ Nyɔ wimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ayakalə, mbɛiŋ kiə kə wi. A kiəki a mih wi. Mih ka dzaka a mih kiəki kə wi, ma yi numki a mih kɔ mi wi ntəkə aka mbɛiŋ. Ayakalə, mih kiəki lə wi, mih wɔkɔ gia yi. ");
INSERT INTO cug_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ba wimbɛiŋ Ablaham nì kɔ bəh kinsaŋli a ŋgaiŋ bi yɛiŋ lə chɔkɔ biŋ. Ayaka wi dzə yɛiŋ bi, ka numki bəh kinsaŋli.” ");
INSERT INTO cug_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Bəju ka dza bə́ dzaka i wi a, “Wɔ kɔ maka wɔ buku jía mbaŋshi, num wɔ nì yɛiŋ lɔ Ablaham a?” ");
INSERT INTO cug_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisɔs chukuli bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, na ka Ablaham numki, Mih num.” ");
INSERT INTO cug_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bɔ wɔkɔ yakadəiŋ, ka dzɔ kitəh a bɔ tumyi Jisɔs yɛiŋ. Jisɔs nyumi gwu yi ka buku i juŋ yi fəni yi gia yiwɔ mə. ");
INSERT INTO cug_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Si Jisɔs dza ka nyaniki nnyaki, wi yɛiŋ minyuku widɔkɔ num bə nì bwɔ wi kifəkə. ");
INSERT INTO cug_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Bwa bu bə mbaŋ bikə i wi a, “Labay, a nì fə ndə chu ka bə bwɔ mi wələ kifəkə a? A nì fə mi wiwɔ ma ba wi bəh nih wi a?” ");
INSERT INTO cug_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisɔs chukuli i bɔ a, “Yi kɔkə a, mi wələ nabə ba wi bəh nih wi nì fə chu. Bə nì bwɔ wi yakadəiŋ ka bə bi yɛiŋ nɔm wi Nyɔ i gwu yi wə. ");
INSERT INTO cug_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bukumbɛiŋ kaŋaki i nɔ̂mki nɔm wi mi wə wi faaŋ mih a kɛiŋ nshi. Nchɔkɔ dzəki lə, a num jɔbi wə mi widɔkɔ kɔkə i nɔm fiɛŋ fidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","I tsə buku na winaiŋ jɔbi wə mih kɔ i fa mbi wələ wə, mih kɔ baiŋni bi mbi wələ.” ");
INSERT INTO cug_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Si Jisɔs dzaka ndzaka wələ yaka, ka chuh midziŋ i kuku, nayi nshwaiŋ bəh mɔ ka fiaŋsi dzə́kəh yi mi wiwɔ yɛiŋ, ");
INSERT INTO cug_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ka dzaka i wi a, “Tsə̂ wɔ̂kɔ i di bi Limi bi Silɔam wə.” (Yɛli wələ Silɔam kɔ a, “Bɔ faaŋ.”). Wi ka tsə wɔkɔ, bə fiəni dzə yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Bəni bə̀ bɔ nì nɔki kɔmsi i wi kpəŋ bəh bəni bə̀ bɔ nì shiki yɛiŋki wi, ka mi wi nywani ka kaiŋyiki a, “Ntə wələ kɔ a mi wə wi ni shiki numki i kuku wi nywa biɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Bədɔkɔ ka dzakaki a, “Akɔ wi.” Bədɔkɔ a, “Aayi wi bwɔsiki wi bwɔsini.” Mi wiwɔ ka dzaka i bɔ a, “Akɔ mih mi wiwɔ.” ");
INSERT INTO cug_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ayakadəiŋ, bɔ ka bikə i wi a, “Dzə́kəh ya nyani dəiŋ ka yi baiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Wi chukuli a, “Mi wə bə bɔɔŋki a Jisɔs si nayi nshwaiŋ ka fiaŋsi i dzə́kəh yiŋ wə, ka dzaka a mih tsə̂ i Silɔam mih wɔ̂kɔ. Mih ka tsə wɔkɔ, dzə́kəh yiŋ ka baiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Bɔ bikə i wi a, “Bə wi naiŋ?” Wi chukuli a, “Mih kiəki kə.” ");
INSERT INTO cug_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Bɔ ka dza dzɔ mi wə wi ni shi kɔ kifəkə yaka ka tsə bəh wi i Bəfalasi. ");
INSERT INTO cug_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Chɔkɔ biə Jisɔs ni na nshwaiŋ chu wɛli dzə́kəh yi mi wiwɔ yɛiŋ, a nì kɔ num i chɔkɔ bi mbam wə. ");
INSERT INTO cug_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Bəfalasi bəwɔ chu bikə i wi si wi nyani ka dzə́kəh yi baiŋ. Wi chukuli i bɔ a, “Wi si fiaŋsi dzə́kəh yiŋ bəh nshwaiŋ, mih ka tsə wɔkɔ yi, ka mih yɛiŋki di.” ");
INSERT INTO cug_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Bəfalasi bəwɔ ka dzaka a, “Mi wələ ka nyə dəkə i Nyɔ wə, kɔm wi nɔmki i chɔkɔ bi mbam wə.” Bədɔkɔ dzaka fibɔ a, “Mi wə wi fəki chu wi kɔ nyani dəiŋ na ka wi fəki biələ binchəsi biə bi chusiki kiŋkɔkni ki Nyɔ a?” Ayaka kiŋgaali ka dzə i bɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bɔ chu fiəni bikə i mi wiwɔ a, “Wɔ dzaka mfia a nə kɔm mi wələ si wi si wɛli dzə́kəh ya?” Wi chukuli i bɔ a, “Mi wələ kɔ mi wi ntum wi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bəju nì ka bum dəkə a mi wələ nì kɔ num wi fəkə, ka bə wɛli dzəkəh yi. Bɔ nyani lə ka bi tsə bɔɔŋ ba wi bəh nih wi, bɔ dzə. ");
INSERT INTO cug_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Bɔ bikə i bɔ a, “Wələ kɔ a waiŋ wimbɛiŋ wə mbɛiŋ dzakaki a bə nì bwɔ wi, num wi fəkə lɔ a? Wi nyani dəiŋ na ka wi yɛiŋki di i liə a?” ");
INSERT INTO cug_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nih wi bəh ba wi chukuli a, “Buku kiəki lə a wələ kɔ na waiŋ wibuku num bə nì bwɔ wi kimfəkə. ");
INSERT INTO cug_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ayakalə, buku kiəki kə a yi jikə na dəiŋ na ka wi yɛiŋki di i liə. Ayaka buku kiə kə tə mi wə wi wɛli dzə́kəh yi. Mbɛiŋ bîkə num i wi. Wi si num lɔ i mi. Wi num i fuku bəh dzaka ki.” ");
INSERT INTO cug_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nih wi bəh ba wi nì dzakaki yakadəiŋ kɔm bɔ nì lwaki lə Bəju, yi num, num Bəju nì jiə a, mi ka mɔm i dzaka bəh dzaka ki a Jisɔs kɔ Kimbwili wə Nyɔ nì kaka, bɔ kɔ̂ŋŋ bwîli wəmaka mi i juŋ yi tsani mə. ");
INSERT INTO cug_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Akɔ gia yə nih wi bəh ba wi nì dzaka a wi si num lɔ i mi, a bɔ bîkə num i wi. ");
INSERT INTO cug_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","I ŋkaiŋni kifa wə, bɔ chu bɔɔŋ mi wə wi nì kɔ wi fəkə, ka dzaka i wi a, “Dzâka gia yi ŋkɔŋ ma kiŋkɔksi tsə̂ i Nyɔ. Buku kiəki yibuku a mi wələ kɔ mi wə wi fəki chu.” ");
INSERT INTO cug_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wi chukuli a, “Yaka wi fəki lə chu, mih kiəki kə. Gia yimu yə mih kiəki kɔ a, mih ni kɔ kimfəkə, i liə mih yɛiŋki lə di.” ");
INSERT INTO cug_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Bɔ chu bikə i wi a, “Wi si fə dəiŋ bəh wɔ? Wi si fə dəiŋ ka wi wɛli dzə́kəh ya?” ");
INSERT INTO cug_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wi chukuli i bɔ a, “Mih si fuku lɔ i mbɛiŋ, mbɛiŋ na kɔŋ dəkə i wɔkɔli. Mbɛiŋ bə́ chu nəŋ i wɔkɔ fə nə a? Mbɛiŋ tə nəŋki i num bəni bu bə mbaŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ayaka bɔ tɔyi num tɔyini dzaka a, “Akɔ wɔ mi wi wi mbaŋ. Buku num fibuku bəni bə mbaŋ wi Muses. ");
INSERT INTO cug_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Buku kiəki a Muses kɔ num Nyɔ nì dzakaki lə bəh wi. Ayakalə, i wələ mi buku kiəki kə di biə wi buku.” ");
INSERT INTO cug_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mi wiwɔ chukuli a, “Yəbɛɛy, akɔ gia yi kaiŋni! Mbɛiŋ dzakaki a mbɛiŋ kiəki kə di biə wi buku a? Ayakalə, wi wɛli dzə́kəh yiŋ. ");
INSERT INTO cug_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Buku kiəki lə a Nyɔ si wɔkɔ kə ntsa wi mi wə wi fəki chu. Ayakalə, na winaiŋ mi wi yaksiki Nyɔ, fə gia yə wi kɔŋki, Nyɔ wɔkɔki lə ntsa wi. ");
INSERT INTO cug_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","I yisi na si mbi nì yisi, bə ka num wɔkɔ dəkə a, mi num wɛli dzə́kəh yi mi num bə nì bwɔ wi, wi num kimfəkə. ");
INSERT INTO cug_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Asi kɔkə a mi wələ numki a wi nyə i Nyɔ wə, ma wi si ka fə yələ gia lə.” ");
INSERT INTO cug_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Bɔ dzaka i wi a, “Wɔ kɔ num bə nì bwɔ wɔ na i chu kintəəŋ mwi, wɔ bə nəŋ i lani buku a?” Si bɔ dzaka yakadəiŋ, ka kɔŋŋ wi i bɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisɔs ka bi wɔkɔ a bə kɔŋŋ bwili mi wə i bɔ kintəəŋ, wi ka nəŋ yɛiŋ wi, bikə i wi a, “Wɔ jiə alə shɔm ya i mi wə yɛli wi kɔ Waiŋmi a?” ");
INSERT INTO cug_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Wi bikə a, “Mi wiwɔ kɔ ndə, ba wuŋ? Fûku mih, ka mih jîə shɔm yiŋ i wi.” ");
INSERT INTO cug_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jisɔs dzaka i wi a, “Wɔ yɛiŋ lɔ wi. Akɔ wi wə mbɛiŋ wi dzakaki i liə.” ");
INSERT INTO cug_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mi wiwɔ ka dzaka a, “Bah mih jiə.” Si wi dzaka yakadəiŋ, ka tum binyu i wi nshiŋ nya kiŋkɔksi i wi. ");
INSERT INTO cug_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisɔs dzaka a, “Mih dzə i fa mbi wələ wə ka bə saka bəni, ka bə̀ bɔ yɛiŋki kə di ni yɛiŋki, ka bə̀ bɔ yɛiŋki di ni fiəni bimfəkə.” ");
INSERT INTO cug_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Si Jisɔs dzaka yakadəiŋ, Bəfalasi bədɔkɔ bə̀ bɔ nì kɔ kɔmsi i wi kpəŋ wɔkɔ yakadəiŋ ka bikə i wi a, “Buku tə kɔ bimfəkə a?” ");
INSERT INTO cug_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisɔs dzaka i bɔ a, “Asi kɔ a mbɛiŋ numki bimfəkə, ma kaŋ yimbɛiŋ kɔ yiyəə i kimbu kichu wə. Ayakalə, i liə si mbɛiŋ dzakaki a mbɛiŋ yɛiŋki lə di, chu bimbɛiŋ ni baaŋ a numki i kifwu kimbɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Mih fukuki ŋkɔŋ i mbɛiŋ a, mi wə wi liəki i mbaiŋ wi shwáŋ wə, maka wi liə num i dzaka ki mbaiŋ wə, wi yaka lɔ yakani ka wi liə i mbaiŋ wə, wəmaka mi kɔ ji, wi num mi wə wi lɔkɔki biɛiŋ bəh ŋga. ");
INSERT INTO cug_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ayakalə, mi wə wi si nchəni shwáŋ si shi liə mfih num i dzaka ki mbaiŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wəmaka mi kɔ mi wə, mi wə wi si chəniki dzaka kimbaiŋ si wɛli dzaka kimbaiŋ i wi, wi liə ka bɔɔŋki shwáŋ yə yi kɔ n'yi i yɛli wə, yi wɔkɔ ja yi, wi ka dzɔ buku bəh yi. ");
INSERT INTO cug_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jɔbi wə wi bwili n'yi yichi i biŋ, wi ni tsəki i yi nshiŋ wi bɔɔŋ yi yi biəli wi, kɔm yi kiəki lə ja yi. ");
INSERT INTO cug_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A kabə num mi wi dzəni yi kɔkə i biəli wi. Yi ni yɔkɔ gɛiŋ lɔ gɛiŋni, kɔm yi kiəki kə ja yi mi wi dzəni.” ");
INSERT INTO cug_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisɔs nì ti ndi wələ i bɔ yakadəiŋ, bɔ nəki wɔkɔ kiə kə gia yə wi dzaka i bɔ i ndi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ayakadəiŋ, Jisɔs chu dzaka i bɔ a, “Mih fukuki ŋkɔŋ i mbɛiŋ a, akɔ mih dzaka ki mbaiŋ di biə shwáŋ tsəki. ");
INSERT INTO cug_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Bəni bəchi bə̀ bɔ nì yisi dzə i mih, a nì kɔ num bəji bəh bəni bə̀ bɔ ni lɔkɔki biɛiŋ i bəni bəh ŋga. Ayakadəiŋ, shwáŋ yiwɔ nəki wɔkɔli kə gia yə bɔ ni dzakaki. ");
INSERT INTO cug_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Akɔ mih dzaka ki mbaiŋ. Mi ka tsə i mih wə ka wi liə wi bi bɔiŋ. Wi bi numki aka shwaŋ yə yi bukuki tsə dzi fiəni dzə liə i mbaiŋ mə. ");
INSERT INTO cug_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ji si dzə a i chwɔ, bəh i wɔɔ, bəh i bəkəli biɛiŋ. Mih dzə mfiŋ a bəni kwati nɔni, a num nɔni kə ki kɔ na kichili. ");
INSERT INTO cug_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Akɔ mih ntɔkni wi shwáŋ wi ndzɔŋni. Ntɔkni wi shwáŋ wə wi ndzɔŋki si nya lə nɔni ki i kpi kɔm shwáŋ yi. ");
INSERT INTO cug_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mi wə bə dzɔ num dzɔni i nnɔm wə, wi num kə ntɔkni wi shwáŋ wiwɔ, shwáŋ yiwɔ chu kɔbi n'yi, wi si yɛiŋ jɔbi wə kuula dzəki, wi yatɔkɔ shwáŋ yiwɔ wi yɔkɔ gɛiŋ, kuula wiwɔ baaŋ kwayi shwáŋ saŋ gaali yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wi si yɔkɔ kɔm bə dzɔ wi dzɔni aka mi wi nɔm, wi kaŋa kə jɔbi kɔm shwáŋ yiwɔ. ");
INSERT INTO cug_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mih kɔ ntɔkni wi shwáŋ wi ndzɔŋni. Mih kiəki lə shwáŋ yə yi kɔ yiŋ, shwáŋ yiŋ kiə tə mih, ");
INSERT INTO cug_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","a liŋ asi Ba wuŋ kiəki mih, mih kiə tə Ba wuŋ, mih nya nɔni kəŋŋ i kpi kɔm shwáŋ yiŋ. ");
INSERT INTO cug_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mih kaŋaki lə tə shwáŋ yidɔkɔ yə yi kɔkə i mbaŋ wələ wə. Mih kaŋa i tsə dzəh bəh yi tə a yi wɔkɔki ja yiŋ, ka mbaŋ wi shwáŋ yiwɔ fiəni chu wimu, ma ntɔkni wi shwáŋ yiwɔ numki a wimu. ");
INSERT INTO cug_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Mih kɔ num mih nì nya nɔni kəŋŋ i kpi ka mih bi fiəni dzɔ nɔni kəŋŋ. Akɔ gia yə Ba wuŋ kɔŋki mih. ");
INSERT INTO cug_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mi widɔkɔ dzɔki kə nɔni kəŋŋ i mih. A nyaki mih nɔni kəŋŋ i ŋkɔŋ wuŋ wə. Mih kaŋaki lə ŋga i nya nɔni kəŋŋ i kpi, mih kaŋa ŋga i fiəni dzɔ nɔni kəŋŋ. Gia yələ kɔ gia num a dzaka Ba wuŋ a mih fə.” ");
INSERT INTO cug_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jisɔs dzaka gia yiwɔ yakadəiŋ, kiŋgaali chu num i kintəəŋ ki Bəju wə. ");
INSERT INTO cug_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bɔ bəduli ka dzakayiki a, “Wi kaŋaki lə chinda wi ŋkpɛli, wi dzaki lə. Mbɛiŋ wɔkɔliki nə i wi a?” ");
INSERT INTO cug_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ayakalə, bədɔkɔ dzakayi a, “Fa kɔkə bəndzaka bə mi wə wi kaŋaki chinda wi ŋkpɛli. Chinda wi ŋkpɛli kɔlə i wɛli dzə́kəh yi kifəkə a?” ");
INSERT INTO cug_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A dzə num i jɔbi widɔkɔ wə bə nì fəki Dzini bidɔkɔ i fiəni kwaka si bə nì wɛli juŋ yi fəni yi gia i Jɛlusalɛm, ");
INSERT INTO cug_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisɔs tsə bə́ ghani nnya i kintəəŋ ki juŋ yi fəni yi gia wə, i gbəŋ wi Sɔlɔmɔn wə. A num i jɔbi wi fiəkə wə. ");
INSERT INTO cug_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Bəju dza dzə juŋni fiəli wi, bikə i wi a, “Wɔ ni bee buku a buku baaŋ nûmki kîə kə fwu wibuku i tsə̂ bûku dəiŋ a? A kabə num a wɔ kɔ Kimbwili wə Nyɔ nì kaka, wɔ fûku i buku chəŋ.” ");
INSERT INTO cug_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisɔs chukuli i bɔ a, “Mih kɔ num mih dzaka lɔ i mbɛiŋ, mbɛiŋ na bum yiŋ. Bənɔm bə̀ mih fəki i yɛli wi Ba wuŋ wə akɔ bɔ bə̀ bɔ chusiki mi wə mih kɔ wi. ");
INSERT INTO cug_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ayakalə, mbɛiŋ ka bum dəkə, kɔm mbɛiŋ kɔkə i mbaŋ wi shwáŋ yiŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Shwáŋ yiŋ si wɔkɔ lə ja yiŋ. Mih kiə yi, ayaka yi biəli mih, ");
INSERT INTO cug_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","mih nya yi bəh nɔni kə ki bi tsə kaa kə. Ayaka yi bi lansi laka kə. Mi widɔkɔ kɔbi wə wi bi lansi lɔkɔ yi i mih kaŋ. ");
INSERT INTO cug_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ba wuŋ wə wi nya shwáŋ yiwɔ i mih tsəki lə mi wichi, mi widɔkɔ kɔkə i lɔkɔ yi i wi kaŋ. ");
INSERT INTO cug_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Buku Ba wuŋ kɔ fiɛŋ fimu.” ");
INSERT INTO cug_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Bəju chu dzɔ kitəh i tumyi wi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jisɔs bikə i bɔ a, “Mbɛiŋ yɛiŋ lɔ bənɔm bə̀ ndzɔŋni bəduli bə̀ Ba wuŋ dzaka a mih fəki. Akɔ winaiŋ wə mbɛiŋ nəŋki i tumyi mih bəh kitəh kɔm wi a?” ");
INSERT INTO cug_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Bɔ chukuli i wi a, “Buku tumyiki kə wɔ kɔm bə nɔm wi ndzɔŋni wə wɔ fəki. Buku tumyiki wɔ kɔm wɔ bəkəliki yɛli wi Nyɔ. Wɔ kɔ a liŋ mi wiwɔm, dzaka a wɔ kɔ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisɔs chukuli i bɔ a, “Ntə bə nyaka i Kiŋwakti kimbɛiŋ ki bənchi wə a, Nyɔ dzakaki yɛiŋ a, ‘Mih dzakaki a mbɛiŋ kɔ bənyɔ’ a? ");
INSERT INTO cug_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nyɔ bɔɔŋki bəni bə̀ a bənyɔ, a num bɔ bə̀ ja yiwɔ nì tsəki i bɔ, ayaka buku kiəki a gia yə yi kɔ i Kiŋwakti ki Nyɔ mə kɔkə bi kwuni. ");
INSERT INTO cug_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Si yi kɔ yakadəiŋ, akɔ kɔm nə wə mbɛiŋ dzakaki i mi wə Ba wi kɔ wi saiŋbwili wi ka faaŋ i fa mbi wələ wə, a wi bəkəliki yɛli wi Nyɔ, kɔm wi dzaka a ŋgaiŋ kɔ waiŋ Nyɔ a? ");
INSERT INTO cug_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mih kabə num mih fə kə bənɔm bə Ba wuŋ, mbɛiŋ ma bum mih. ");
INSERT INTO cug_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ayakalə, mih kabə fəki num bɔ, kɔŋ yi numki a mbɛiŋ ka bum dəkə i mih, mbɛiŋ bum num i bɔ, ka mbɛiŋ ni kiə na bindzɔŋ a Ba wuŋ kɔ i mih wə, mih num i Ba wuŋ wə.” ");
INSERT INTO cug_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bəju ka nəŋki i chu kwa wi, wi tɔsi buku i kaŋ yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jisɔs chu tsə ndaŋ Bɔkɔ yi Jɔdan tsə i kiwuŋ kə Jɔn nì yisi i juliki bəni i bɔkɔ, ka numki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bəni bəduli ka nyəki dzəki yɛiŋki wi. Bɔ dza dzaka a, “Jɔn nì ka kɛiŋsi fə na gia yidɔkɔ yə yi chusiki kiŋkɔkni ki Nyɔ. Ayakalə, gia yichi yə wi nì dzakaki kɔm mi wələ nì kɔ na ŋkɔŋ.” ");
INSERT INTO cug_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ayakadəiŋ, bəni bəduli jiə shɔm i Jisɔs wə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mi widɔkɔ nì kɔlə yɛli wi num Lasalus, wi dza yisi jwɛiŋ. Wi num mi i kwili wi Bɛtani wə, wi nì nɔki fɛiŋ bəh jɛ́mi yi Meli bəh Mata. ");
INSERT INTO cug_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Meli wələ wə waiŋnih wi Lasalus nì gwɛiŋki lə, akɔ wə wi nì fiaŋsi gvu yi Bah bəh fiaŋsi bi tsɛŋə yindzɔŋni, ka sɔ bəh juŋ yi yifwu. ");
INSERT INTO cug_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Si wi nì gwɛiŋki yakadəiŋ, jɛ́mi yi ka faaŋ ntum i Jisɔs a, “Bah, wə wi kɔ shɔm ya gwɛiŋki lə.” ");
INSERT INTO cug_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Si Jisɔs wɔkɔ ntum wiwɔ, ka dzaka a, “Jwɛiŋ yələ kɔkə yi kpi. Yi kɔ i chusi num kiŋkɔkni ki Nyɔ, ka Waiŋ Nyɔ ni kwati yɛli wimbum i yi wə.” ");
INSERT INTO cug_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisɔs nì kɔŋki lə Mata bəh waiŋnih wi Meli bəh Lasalus nalə. ");
INSERT INTO cug_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ayakalə, jɔbi wə wi nì wɔkɔ a Lasalus gwɛiŋki lə, wi chu nɔ baaŋ i di biə wi nì kɔ i kaŋ yifa wə. ");
INSERT INTO cug_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Si yəmaka nì tsə, wi ka dzaka i bwa bu bə mbaŋ a, “Bukumbɛiŋ fîəni chû i Judea.” ");
INSERT INTO cug_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Bɔ ka bikə i wi a, “Labay, ntə akɔ a ŋgbu ŋgbu si Bəju ni nəŋki i tumyi wɔ bəh kitəh a wɔ kpî, wɔ bə́ chu nəŋ i fiəni tsə i fɛiŋ na?” ");
INSERT INTO cug_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisɔs chukuli i bɔ a, “Ntə chɔkɔ kaŋaki mbiəŋə jwɔfi ntsɔ bəfa? Mi kabə nyaniki nshifɔkɔ, wi kɔkə i damti i biɛiŋ bɛiŋ, kɔm baiŋni bi mbi wələ baiŋki lə i wi. ");
INSERT INTO cug_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ayakalə, na ndə wə wi nyaniki nchɔkɔ, wi kɔlə i damti, kɔm wi kaŋaki kə baiŋni i wi.” ");
INSERT INTO cug_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Si wi dzaka yakadəiŋ, ka dzaka i bɔ a, “Nsɛiŋ wibukumbɛiŋ Lasalus gbɔ kinu. Ayakalə, mih ki tsəki lə fɛiŋ i yɔmsi wi i kinu kiwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Bwa bu bə mbaŋ ka dzaka i wi a, “Bah, yi kabə num a wi gbɔ kinu, ma wi ni bɔnih.” ");
INSERT INTO cug_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisɔs nì dzakaki num kɔm kpi yi Lasalus, ayakalə, bwa bu bə mbaŋ wɔkɔ yaka ka kwakaki a wi dzakaki kɔm kinu ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jisɔs ka fuku baiŋsi yi i bɔ a, “Lasalus kɔ num wi kpi lɔ. ");
INSERT INTO cug_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ayakalə, mih kɔ bəh kinsaŋli kɔm bə mbɛiŋ, a mih ni kɔkə fɛiŋ, ka mbɛiŋ ni jîə shɔm i mih. Ayakadəiŋ, bə tsə̂ bûku fɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tɔmɔs wə bə nì bɔɔŋki yɛli wi widɔkɔ a Bimaŋsi, ka dzaka i bwa bə mbaŋ bədɔkɔ bə̀ a, “Bukumbɛiŋ tsə̂ tə ka bukumbɛiŋ ni kpî bəh wi.” ");
INSERT INTO cug_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisɔs tsə buku fɛiŋ, ka wɔkɔ a Lasalus kɔ num wi nɔ lɔ i jum kintəəŋ kaŋ yina. ");
INSERT INTO cug_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani wələ nì kɔ ka bəmay bəfa i kɔmsi tsə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bəju bəduli nì dzə i Mata bəh Meli i kwasi nshɛiŋ bəh bɔ kɔm kpi yi waiŋnih wibɔ. ");
INSERT INTO cug_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jɔbi wə Mata nì wɔkɔ a Jisɔs si dzə wə, wi ka buku tsə a bɔ wi baŋsi, ayakalə Meli baaŋ dzu. ");
INSERT INTO cug_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata tsə dzaka i Jisɔs a, “Bah, a ni kɔ a wɔ numki fa, ma waiŋnih wuŋ ni ka kpi dəkə. ");
INSERT INTO cug_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ayakalə, mih kiəki lə a i liə, na finə wɔ bikə i Nyɔ wi ni nya i wɔ.” ");
INSERT INTO cug_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisɔs dzaka i wi a, “Waiŋnih wa ni fiəni dza lə i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mata ka dzaka i wi a, “Mih kiəki lə a wi bi fiəni dza lə i chɔkɔ bi gɔksini biə bəni bi dzaki i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisɔs dzaka i wi a, “Akɔ mih wə mih bwiliki bəni i kpi wə, a num mih wə mih nyaki nɔni. Mi wə wi jiə shɔm yi i mih bi baaŋ lə wiwɔm, kɔŋ yi numki a wi kpi, ");
INSERT INTO cug_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ayaka na ndə wə wi kɛiŋki wiwɔm ka jiə shɔm yi i mih, bi kpi kə. Wɔ bum alə yakadəiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Wi bum a, “Aaŋ Bah, mih bum a wɔ kɔ Kimbwili wə Nyɔ nì kaka. Wɔ kɔ Waiŋ Nyɔ wə wi nì kaŋaki i bi dzə fa mbi wələ wə.” ");
INSERT INTO cug_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Si Mata dzaka yakadəiŋ, ka tsə bɔɔŋ Meli waiŋnih wi, dzaka i wi a kuku kuku a, “Mi wi lanini si num lɔ fa, ayaka wi bɔɔŋki wɔ.” ");
INSERT INTO cug_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Si Meli wɔkɔ yakadəiŋ, ka saka dza bɛiŋ i tsə yɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","A nì kɔ maka Jisɔs dzə liə i kwili wiwɔ wə. Wi nì kɛiŋki a di biə Mata ni tsə yɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Bəju bə̀ bɔ nì kɔ bəh Meli i dzu kwasi nshɛiŋ bəh wi, ka yɛiŋ si wi saka dza bɛiŋ buku biŋ, bɔ ka biəliki wi kwaka a wi tsəki i jum bɛiŋ i tsə dəki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jɔbi wə Meli nì tsə buku i di biə Jisɔs ni kɔ, yɛiŋ wi, ka gbɔ i gvu yi wə dzaka a, “Bah, a ni kɔ a wɔ numki fa, ma waiŋnih wuŋ ni ka kpi dəkə.” ");
INSERT INTO cug_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Si Jisɔs yɛiŋ si wi dəki, bəh Bəju bə̀ bɔ nì biəli wi bɔŋ də tə, gia yiwɔ nya ŋgəkə i shɔm yi wə nalə, gwu kpi wi nalə. ");
INSERT INTO cug_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Wi ka bikə a, “Mbɛiŋ ləə faiŋ wi a?” Bɔ dzaka i wi a, “Bah, dzə yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisɔs də. ");
INSERT INTO cug_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Bəju yɛiŋ yakadəiŋ ka dzaka a, “Mbɛiŋ yɛ̂iŋ si wi ni kɔŋki wi.” ");
INSERT INTO cug_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ayakalə, bɔ bədɔkɔ dzaka lɔ a, “Ntə wələ kɔ wi wə wi nì wɛli dzə́kəh yi kimfəkə a? Kɔm nə wə wi ni ka yɛlih fwu wi mi wələ i kpi wə a?” ");
INSERT INTO cug_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Shɔm chu nəŋni Jisɔs na bəh ŋga. Wi dza tsə buku i jum bɛiŋ. Jum yələ nì kɔ num taa wə bə nì baŋ dzaka kiwɔ bəh təh wimbum. ");
INSERT INTO cug_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisɔs dzaka a, “Mbɛiŋ gîŋsi təh wə.” Mata jɛmi yi mi wi kpili dzaka i Jisɔs a, “Bah, i liə ni numki num wi si fwuli lɔ. I liə si num lɔ kaŋ yina si wi ni kpi.” ");
INSERT INTO cug_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisɔs bikə i wi a, “Mih si dzaka alə i wɔ, a wɔ ka jiə shɔm ya i mih, ma wɔ ni yɛiŋ mbum biə bi kɔ bi Nyɔ a?” ");
INSERT INTO cug_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ayakadəiŋ, bɔ ka giŋsi təh wiwɔ. Jisɔs giŋsi dzə́kəh yi i bɛiŋ ka dzaka a, “Ba wuŋ, mih nyaki kiyɔŋni i wɔ si wɔ wɔkɔ ntsa wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mih kiəki lə na bindzɔŋ a wɔ si wɔkɔ lə ntsa wuŋ i jɔbi wichi wə. Ayakalə, mih dzakaki yələ kɔm bəni bələ bɔ kɔ fa, ka bɔ bûm a, a faaŋ wɔ mih.” ");
INSERT INTO cug_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Si wi dzaka yakadəiŋ, ka wam bəh ja yiləkəli a, “Lasalus, bûku!” ");
INSERT INTO cug_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ayaka mi wi kpili wiwɔ dza buku dzə, kaŋ yi bəh gvu yi num bə lim bəh kinchumni ki mbuŋ, lim tə shi bi bəh kinchumni ki mbuŋ. Jisɔs ka dzaka i bɔ a, “Mbɛiŋ shwâ wi, mbɛiŋ bêe wi tsə̂ki.” ");
INSERT INTO cug_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jɔbi wə Bəju bəduli bə̀ bɔ nì dzə i Meli yɛiŋ gia yə Jisɔs fə, ka jiə shɔm i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ayakalə, bədɔkɔ tsə fibɔ ka yɛiŋ num Bəfalasi, fuku i bɔ gia yə Jisɔs fə. ");
INSERT INTO cug_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Bətii mfə gia bəmbum bəh Bəfalasi ka juŋni kifwu ki tumi dzaka i bɔ a, “Bukumbɛiŋ ki fəki dəiŋ na? Mi wələ fəki binchəsi biduli biə bi chusiki kiŋkɔkni ki Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Bukumbɛiŋ ka bee a wi tsəki a bəh yi i ninshiŋ, ma bəni bəchi ni jiə shɔm i wi, ayaka ma bəni bə Lum bə̀ bɔ sakaki bukumbɛiŋ ni dza dzə bəkəli di bibukumbɛiŋ bi baiŋni bəh tumi kibukumbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ayakalə, mi widɔkɔ i bɔ kintəəŋ yɛli wi num Kayfas, wə wi nì kɔ fwu wi bətii mfə gia i jia yiwɔ wə ka dza dzaka mfih i bɔ a, “Mbɛiŋ kiəki kə na gia yidɔkɔ lə kpaaa. ");
INSERT INTO cug_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mbɛiŋ kiəki kə a yi ndzɔŋki lə i mbɛiŋ a mi wimu kpî i bəni bəchi, tsə a kitumi kichi laka num lakani a?” ");
INSERT INTO cug_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayfas nì dzakaki gia yələ num kə i mfi bi wə. Si wi nì kɔ fwu wi bətii mfə gia i jía yiwɔ wə, dzaka yakadəiŋ laka num ntum wi Nyɔ, a Jisɔs nì kaŋaki lə i kpi i kitumi ki Bəju wə. ");
INSERT INTO cug_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","A num kə a kitumi kiwɔ shəŋ, kpi yi nì kaŋaki i juŋni bwa bəchi bə̀, bɔ kɔ bə Nyɔ i kitumi kidɔkɔ wə, ka bɔ numki i fiɛŋ fimu wə. ");
INSERT INTO cug_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","I yisi chɔkɔ biwɔ wə, kifwu kitumi ka yisi i fasiki si bɔ bi wɔɔki Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ayakadəiŋ, Jisɔs nəki chu nyani kə i kintəəŋ ki Bəju wə. Wi dza nyə mfih fɛiŋ bəh bwa bu bə mbaŋ ka tsə nɔki i kwili widɔkɔ wə wi kɔ kɔmsi i tumi ki mishambu kə bə nì bɔɔŋki a Ɛfelɛm. ");
INSERT INTO cug_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Dzini bi Bəju bi Ntsədaŋ nì kɔ num bi si kɔmsi dzə lɔ, bəni ka nyəki dzəki i bimbu wə dzə i Jɛlusalɛm i dzə wɔkɔ kishi kibɔ ka bini biwɔ ni dzə kpɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Bɔ tsə yisi i nəŋki Jisɔs bikə a bɔ bɔ i jɔbi wə bɔ nì numyi i bɛiŋ i juŋ yi fəni yi gia mə dzaka a, “Mbɛiŋ kwakaki a nə? A wi ni dzə kə i dzini biələ wə a?” ");
INSERT INTO cug_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","A nì kɔ bətii mfə gia bəmbum bəh Bəfalasi tsəsi ja a na ndə kabə kiəki di biə Jisɔs kɔ, wi fə̂ ma bɔ kîə, ka bɔ ni kwâ wi. ");
INSERT INTO cug_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A nì baaŋ a kaŋ yisɔ ka Dzini bi Ntsədaŋ yisi, Jisɔs nyə tsə i kwili wi Bɛtani wə i di biə Lasalus wə Jisɔs nì dzasi i kpi wə nì kɔ. ");
INSERT INTO cug_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Si wi tsə fɛiŋ, bə fə biɛiŋ bidzini i tati wi yɛiŋ. Mata num mi wə wi nì gaaki, Lasalus num mi widɔkɔ i mbaŋ wi bəni bə̀ bɔ ni shinum ka dziki bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Meli dza dzɔ finsɔkɔ fi fiaŋsi fidɔkɔ bi tsɛŋə yindzɔŋni, shuku i gvu yi Jisɔs wə, ka sɔ bəh juŋ yi yifwu. Fiaŋsi biələ nì ləkəki lə i kpɔ wə nalə, num bə nì kɛiŋsi bəh fiɛŋ fidɔkɔ a fi fi bə bɔɔŋ a nad. Si wi shuku yakadəiŋ, kintəəŋ ki juŋ kiwɔ kichi dza ka fwuliki a tsɛŋə yindzɔŋni. ");
INSERT INTO cug_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iskaliɔt wə wi nì kɔ mi i mbaŋ wi bwa bə Jisɔs, (wə wi nì nyani lə dzə taŋni Jisɔs) dza dzaka lɔ a, ");
INSERT INTO cug_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“A fə nə a bə ma taŋni fiaŋsi biələ i bənchuku gi yitali, i nya kpɔ wiwɔ i bəni bə kifuu a?” ");
INSERT INTO cug_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ni dzaka yakadəiŋ yi kɔbi a wi kwakaki kɔm bəni bə kifuu. Wi nì kɔ ji a num wi mi wibɔ wi kiba, wi nì shiki ləkəki lə kaŋ yɛiŋ wi gamti gwu yi yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisɔs dzaka a, “Bêe wi mɔŋ. Wi jiə fiaŋsi biələ lə i bi kɛiŋsi chɔkɔ biŋ bi ləəni yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Bəni bəkifuu ni shiki numki lə bəh mbɛiŋ jɔbi wichi ayakalə, mih ni numki kə bəh mbɛiŋ jɔbi wichi.” ");
INSERT INTO cug_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jɔbi wə mbaŋ wi Bəju nì wɔkɔ a Jisɔs kɔ fɛiŋ, bɔ ka dzə fɛiŋ. Bɔ nì dzəki kə a kɔm Jisɔs shəŋ. Bɔ nì dzəki tə i yɛiŋ Lasalus wə Jisɔs nì dzasi i kpi wə. ");
INSERT INTO cug_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ayakadəiŋ, bətii mfə gia bəmbum ka fasiki a bɔ ni wɔ̂ɔ lə Lasalus tə, ");
INSERT INTO cug_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","kɔm a nì kɔ kɔm wi, Bəju bəduli nì beeki bɔ ka jiə shɔm yibɔ num i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chɔkɔ buku wɔɔ, mbaŋ wi bəni wə wi nì dzə i dzini biələ wə ka wɔkɔ a Jisɔs si num i dzəh wi dzə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bɔ ka dzɔ biali yi sɔ́m buku tsə i dzɔ wi i dzəh. Bɔ ka tsəki wili dzakayi a, “Lilili, kiŋkɔksi kɔ i Nyɔ wə ɔɔɔ! Nyɔ kɔ wi jiə kimbɔiŋsi i mi wə wi dzəki i yɛli wi Bah wə ɔɔɔ! Akɔ wi Ŋkuŋ wi Islae ɔɔɔ!” ");
INSERT INTO cug_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisɔs nəŋ waiŋ njakas, yaka yɛiŋ bɛiŋ. Ayaka yi ka num asi bə nyaka a, ");
INSERT INTO cug_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bəni bə Sayɔŋ, kiə mbɛiŋ ma lwâki. Mbɛiŋ tsɛ̂iŋ, Ŋkuŋ wimbɛiŋ si wi dzəki, num wi yaka i waiŋ njakas bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Bwa bə Jisɔs bə mbaŋ nì ka kiə dəkə gia yə gia yiwɔ nì chusiki i kin'yisi wə. Jɔbi wə wi nì liə i mbum bi wə, bɔ ka kwaka a bə nì nyaka gia yələ num kɔm wi, ayaka yi num bəh wi asi bə nì nyaka. ");
INSERT INTO cug_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mbaŋ wə wi nì kɔ bəh Jisɔs i chɔkɔ biə wi nì bɔɔŋ Lasalus i jum mə, bwili wi i kpi wə bɔ nì tsəki fuku tsə gia yə bɔ nì yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Fwu wi gia wə mbaŋ wələ nì buku tsə i dzɔ wi i dzəh a nì kɔ kɔm bɔ nì kɔ num bɔ wɔkɔ a wi nì kɔ wi fə gia yə yi chusiki mbum bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ayakadəiŋ, Bəfalasi ka dzakayiki a bɔ bɔ a, “Si mbɛiŋ yɛiŋ a? Gia yidɔkɔ chu kɔkə yə bukumbɛiŋ kɔ i fə. Mbi wichi kɔ num wi kwu lɔ i wi chɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Bəni bədɔkɔ nì kɔ i mbaŋ wi bəni bə̀ bɔ nì yaka tsə i Jɛlusalɛm i tsa Nyɔ i jɔbi wi dzini biələ wə, a num Bəglik. ");
INSERT INTO cug_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bəglik bələ tsə yɛiŋ Filib wə wi ni buku dzə i kwili wi Besayda wə i kimbu ki Galili wə, dzaka i wi a, “Kukuli, buku nəŋki i yɛ̂iŋ Jisɔs.” ");
INSERT INTO cug_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filib ka tsə fuku yi i Andulu, bɔ wi ka tsə fuku i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisɔs chukuli i bɔ a, “Jɔbi dzə kpɛiŋ wə bə ni yakasi mi wə yɛli wi kɔ Waiŋmi i liə i mbum bi wə. ");
INSERT INTO cug_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mih fukuki ŋkɔŋ i mbɛiŋ a, ŋgɔkɔ wi fiɛŋ ka baaŋ i gbɔ i nshwaiŋ wə i kpi, ŋgɔkɔ wiwɔ ni baaŋ a wi. Ayakalə, wi ka kpi, ma wi ni wum mintam miduli. ");
INSERT INTO cug_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Na ndə wə wi kɔŋki nɔni ki nalə ni laksi lə nɔni kiwɔ, ayaka na ndə wə wi baiŋŋki nɔni ki fa mbi wələ wə wi jiəki num jiəni i bi kwati nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mi kabə nɔmki i mih, wi kaŋaki i bîəliki mih, na faiŋ wə mih kɔ, mi wuŋ wi nɔm kaŋaki i nûmki tə fɛiŋ. Mi wə wi nɔmki i mih, Ba wuŋ ni kɔksi wi.” ");
INSERT INTO cug_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisɔs dza dzaka a, “I liə shɔm yiŋ fumsiki lə mih. Mih kɔ i dzakaki a nə? A Ba wuŋ, bwîli mih i kintəəŋ ki jɔbi wi ŋgəkə wələ wə a? Aayi, akɔ kɔm jɔbi wələ mih nì dzə. ");
INSERT INTO cug_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ba wuŋ, fə̂ yɛli wa kaŋa mbum.” Si wi dzaka yakadəiŋ, ja shi dzə i bɛiŋ a, “Mih fə lɔ wi wimbum, mih kɛiŋ i ni chu fə.” ");
INSERT INTO cug_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Mbaŋ wə wi nì kɔ fɛiŋ wɔkɔ ja yiwɔ, ka dzaka fibɔ a, “A wamyiki dzaŋ.” Bədɔkɔ dzaka a, “A dzakaki chinda wi Nyɔ i wi.” ");
INSERT INTO cug_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisɔs chukuli a, “Ja yələ dzə kɔm bə mbɛiŋ. Yi ka dzə dəkə kɔm mih. ");
INSERT INTO cug_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","I liə si num lɔ jɔbi wə bə ki sakaki mbi wələ. I liə si num jɔbi i shisi kɔŋŋ bwili ŋkuŋ wə wi sakaki mbi wələ. ");
INSERT INTO cug_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ayakalə, yiŋ num a jɔbi wə bə bi giŋsiki mih i bɛiŋ fa kuku, mih ni guku bəni bəchi ma bɔ dzə i mih wə.” ");
INSERT INTO cug_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisɔs nì dzakaki yakadəiŋ, wi chusi num ŋkaiŋni yi kpi yə wi bi kpiki. ");
INSERT INTO cug_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mbaŋ wi bəni bəwɔ chukuli i wi a, “Buku wɔkɔki i Kiŋwakti ki Bənchi wə a, Kimbwili wə Nyɔ nì kaka bi fiəli lə. Wɔ nyani dəiŋ i dzakaki a, bə kaŋaki i bi giŋsi mi wə yɛli wi kɔ Waiŋmi i bɛiŋ a? Wəmaka mi wə yɛli wi kɔ Waiŋmi kɔ winaiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisɔs dzaka i bɔ a, “Baiŋni ni numki bəh mbɛiŋ a jɔbi wi juli wələ wə. Mbɛiŋ nyâniki si baiŋni biwɔ kɛiŋki bəh mbɛiŋ, ka jisi bi ma gaka mbɛiŋ. Mi wə wi si nyani i jisi wə si kiə kə di biə wi tsəki. ");
INSERT INTO cug_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Si baiŋni biwɔ kɔ bəh mbɛiŋ, mbɛiŋ jîə shɔm i baiŋni biwɔ wə, ka mbɛiŋ bi num bwa bə baiŋni.” Si Jisɔs dzaka gia yələ lə, ka nyə tsə nyumi gwu yi i bɔ. ");
INSERT INTO cug_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Namana yaka, si wi nì kɔ wi fə lɔ binchəsi biduli biə bi chusiki kiŋkɔkni ki i bɔ nshiŋ, ayaka bɔ nəki jiə kə shɔm i wi. ");
INSERT INTO cug_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Yi nì num yakadəiŋ ka yi kpɛiŋ asi Isaya mi ntum wi Nyɔ nì dzaka a, “Bah, akɔ ndə wə wi kɔ num wi bum gia yə buku dzakaki a? Ayaka a num i bə ndə Bah chusi ŋga bi bitsɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ayakadəiŋ, bɔ nì kɔkə i jiə shɔm i wi, kɔm Isaya nì kɔ wi chu dzaka i di bidɔkɔ wə a, ");
INSERT INTO cug_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wi baŋ dzə́kəh yibɔ, fə shɔ́m yibɔ də, ka bɔ ma yɛiŋki di bəh dzə́kəh yibɔ, kɔbi i kiə bəh shɔ́m yibɔ, ka bɔ fiəni dzə i mih a mih chuku bɔ.” ");
INSERT INTO cug_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya nì dzakaki gia yələ kɔm wi nì kɔ wi yɛiŋ lɔ mbum bi Jisɔs, ka dzakaki kɔm wi. ");
INSERT INTO cug_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na ayaka si bəni nì ka jiə dəkə shɔm i Jisɔs, a nì kɔ bəni bəduli na bə̀ bɔ nì kɔ kifwu i tumi wə nì jiə shɔm i wi, ayakalə bɔ nəiŋ i dzaka bəh dzaka kibɔ, kɔm bɔ nì lwaki Bəfalasi ka bɔ ma ni kɔŋŋ bɔ i juŋ yi tsani wə. ");
INSERT INTO cug_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Bɔ nì lwaki yaka kɔm bɔ nì kɔŋki i kwatiki kiŋkɔksi ki bəni tsə kə ki dzəki i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisɔs dza wam bəh ŋga dzaka a, “Mi wə wi jiə shɔm i mih, wi ka jiə dəkə a mih shəŋ. Wi jiə num i mi wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mi ka yɛiŋ mih, yaka wi yɛiŋ num mi wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mih dzə fa i mbi wələ wə ka baiŋni, ka na ndə wə wi jiə shɔm yi i mih ni baaŋ kə i jisi wə. ");
INSERT INTO cug_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mi ka wɔkɔ ja yiŋ, nəki jiə kə, mih ni saka kə wi, kɔm mih ka dzə dəkə i saka bəni bə mbi wələ a bɔ gbɔ nsaka. Mih nì dzə i bwili bɔ num bwilini. ");
INSERT INTO cug_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mi wə wi məŋni mih ka nəiŋ i dzɔ ja yiŋ, wi kaŋaki lə gia yə yi bi sakaki wi. Ja yə mih kɔ mih dzaka i wi akɔ yi yə yi bi sakaki wi, wi gbɔ nsaka i chɔkɔ bi gɔksini wə. ");
INSERT INTO cug_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yi kɔ yakadəiŋ kɔm mih dzakaki kə i ŋga biŋ wə. Ba wuŋ wə wi faaŋ mih akɔ wi wə wi dzaka a mih dzâkaki, a nya wi gia yə mih kaŋaki i dzâkaki, fuku si mih kɔ i dzâkaki. ");
INSERT INTO cug_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mih kiəki lə a gia yə wi dzaka a mih dzakaki akɔ yə yi nyaki nɔni kə ki bi tsə kaa kə. Ayakadəiŋ, gia yə mih dzakaki akɔ yə Ba wuŋ kɔ wi dzaka a mih dzâkaki.” ");
INSERT INTO cug_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A dzə num i buku dza i chɔkɔ bi Dzini bi Ntsədaŋ wə, Jisɔs kîə a jɔbi wi kpɛiŋ i bee mbi wələ, i fiəni tsə i Ba wi kpəŋ. Si wi nì kɔŋki bəni bə̀ bɔ nì kɔ mbu i mbi wələ wə, wi kɔŋ bɔ tsə bwili fwu. ");
INSERT INTO cug_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","A dzə num si bɔ nì dziki i fijɔbi, num ŋkpɛli jiə lɔ kiŋkwaka i shɔm yi Judas wə waiŋ Samɔn Iskaliɔt, a wi taŋni Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Si Jisɔs nì kɔ wi si kiə lɔ a Ba wi nya biɛiŋ bichi i wi kaŋ, bəh a wi nì nyə i Nyɔ wi fiəni tsə i Nyɔ, ");
INSERT INTO cug_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","wi ka dza i biɛiŋ bidzini bɛiŋ, baa bəmbuŋ bu bə nimbɛiŋ, dzɔ batali ka kaŋa i bwɛli ki wə, ");
INSERT INTO cug_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ka dza shuku mwi i naka ki mwi mə, yisi ka wɔkɔki gvu yi bwa bu bə mbaŋ, sɔ bəh batali wə wi si kaŋa i bwɛli ki wə. ");
INSERT INTO cug_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wi wɔ̂kɔ ka dzə buku i Samɔn Bita wə, wi bikə i wi a, “Bah, wɔ nəŋki i wɔkɔ gvu yiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisɔs chukuli i wi a, “Gia yə mih fəki wɔ kɔkə i kiə i liə. Wɔ bi kiəki yi num i jum wə” ");
INSERT INTO cug_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bita dzaka i Jisɔs a, “Wɔ bi lansi wɔkɔ kə gvu yiŋ.” Jisɔs chukuli i wi a, “Mih ka baaŋ i wɔkɔ wɔ, wɔ ma ni kaŋaki gia yidɔkɔ bəh mih.” ");
INSERT INTO cug_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Samɔn Bita ka dzaka i Jisɔs a, “Bah, a kabə num yaka, ma wɔkɔ shəŋ a gvu yiŋ, wɔkɔ tasi bəh tsɛiŋ yiŋ bəh fwu wuŋ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisɔs dzaka i wi a, “Mi wə wi kɔ wi wɔkɔ lɔ gwu yi wi baiŋki lə gwu yichi wi kaŋaki kə i chu wɔ̂kɔ gwu, a kɔbi a gvu yi. Mbɛiŋ kɔ mbɛiŋ si baiŋ lɔ, ayakalə a kɔbi mbɛiŋ bəchi bə̀ mbɛiŋ baiŋki.” ");
INSERT INTO cug_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisɔs nì dzakaki yakadəiŋ kɔm wi nì kɔ wi si kiə lɔ mi wə wi ni taŋni wi. Akɔ gia yə wi nì dzaka a, “A kɔkə mbɛiŋ bəchi bə̀ mbɛiŋ baiŋki.” ");
INSERT INTO cug_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jɔbi wə Jisɔs nì wɔkɔ kaasi gvu yibɔ, wi lɔh bəmbuŋ bu, fiəni chu i di bi wə, ka bikə i bɔ a, “Mbɛiŋ kiə gia yə mih fə i mbɛiŋ lə a? ");
INSERT INTO cug_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mbɛiŋ bɔɔŋki mih a Mi wi Lanini chu bɔɔŋ a Bah, mbɛiŋ bɔɔŋki num ŋkɔŋ, kɔm akɔ fiɛŋ fiə mih kɔ. ");
INSERT INTO cug_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mih ka Bah wimbɛiŋ chu num Mi wimbɛiŋ wi Lanini, mih wɔkɔ gvu yimbɛiŋ, mbɛiŋ tə kaŋaki i wɔ̂kɔki gvu yi mi bəh mi. ");
INSERT INTO cug_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mih fə lə i chusi i mbɛiŋ a mbɛiŋ fə̂ki tə asi mih fə i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mih fukuki ŋkɔŋ i mbɛiŋ a, waiŋ wi nɔm si mbɔm tsə kə tikwili wi, mi wə bə faaŋ wi si kɔkni tsə kə wə wi faaŋ wi. ");
INSERT INTO cug_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mbɛiŋ kabə kiə gia yələ kabə fə̂ yi, kinsaŋli kimbum ni numki kimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mih dzakaki kə num i mbɛiŋ bəchi. Mih kiəki lə bəni bə̀ mih kɔ mih babwili. Ayakalə, yi kɔ a gia yə yi kɔ i Kiŋwakti ki Nyɔ wə kaŋaki i dzə kpɛiŋ si bə nì nyaka a, ‘Mi wə wi dzi biɛiŋ biŋ bidzini, wi chumki gvu yiŋ.’ ");
INSERT INTO cug_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mih fukuki gia yələ i mbɛiŋ i liə, ka yi bi dzə num, ka yi bi ka num mbɛiŋ bi bum a akɔ na mih wiwɔ. ");
INSERT INTO cug_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mih fukuki ŋkɔŋ i mbɛiŋ a mi wə wi dzɔ na ndə wə mih faaŋ, wi dzɔ num mih. Ayaka mi wə wi dzɔ mih wi dzɔ num mi wə wi faaŋ mih.” ");
INSERT INTO cug_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Si Jisɔs dzaka gia yələ lə, shɔm yi dza ka nyaki wi bəh ŋgəkə. Wi dza dzaka baiŋsi a, “Mih fukuki ŋkɔŋ i mbɛiŋ a mi widɔkɔ i mbɛiŋ kintəəŋ ni taŋni lə mih.” ");
INSERT INTO cug_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Bwa bu bə mbaŋ dza ka tsɛiŋki taliki gwu a wi dzakaki num mi winaiŋ a. ");
INSERT INTO cug_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mi widɔkɔ i mbaŋ wi bwa bə Jisɔs mə, wə Jisɔs nì kɔŋki ni yəkəli kɔmsi i Jisɔs wə dzi. ");
INSERT INTO cug_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Samɔn Bita lasi wi dzaka i wi a wi bikə a akɔ ndə a. ");
INSERT INTO cug_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wi yəkəli tsə i Jisɔs wə bikə i wi a, “Bah, akɔ ndə?” ");
INSERT INTO cug_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisɔs chukuli i wi a, “Akɔ mi wə mih ni gbɛɛ blɛd mih n'yɔkɔ i mwi mijwa mə mih nya i wi.” Ayakadəiŋ, wi ka n'yɔkɔ blɛd i mwi mijwa mə gbɛɛ nya i Judas waiŋ Samɔn Iskaliɔt. ");
INSERT INTO cug_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Asi Judas dzɔ blɛd wiwɔ yakadəiŋ, Satan ka liə i wi mə. Jisɔs dzaka i wi a, “Kɔmsi fə̂ gia yə wɔ nəŋki i fə̂.” ");
INSERT INTO cug_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mi widɔkɔ i mbaŋ wibɔ wə nì ka kiə dəkə gia yə wi dzaka i wi yakadəiŋ. ");
INSERT INTO cug_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Bədɔkɔ nì kwakaki a, asi Judas kɔ mi wə wi jiəki kiba, ayaka a Jisɔs dzakaki i wi a wi tsə̂ tâŋ biɛiŋ biə bɔ kɔŋki i dzi Dzini biələ yɛiŋ, yudɔkɔ a wi tsə̂ nyâ fiɛŋ i bəni bə kifuu. ");
INSERT INTO cug_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Si Judas dzɔ blɛd wiwɔ yakadəiŋ dzi, ka buku akisəkə nyə. Ayaka a nì kɔ num nchɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Si Judas buku tsə yakadəiŋ, Jisɔs baaŋ dzaka a, “Akɔ i liə bə kɔ i yisi i yɛiŋki kiŋkɔkni ki mi wə yɛli wi kɔ Waiŋmi, na i yɛiŋ tə mbum biə bi kɔ bi Nyɔ i gwu yi wə. ");
INSERT INTO cug_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Bə ka yɛiŋ mbum bi Nyɔ i gwu yi wə, ma Nyɔ ni chusi tə mbum bi Waiŋ wi i wi Nyɔ wə. Ayaka wi ni chusi lə akisəkə. ");
INSERT INTO cug_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Bwa bəŋ, mih ni num lə bəh mbɛiŋ a i jɔbi wi juli wə. Ayaka mbɛiŋ num i ni baaŋ nəŋki mih chu kɔbi i yɛiŋ i mih wə. Asi mih nì dzaka i Bəju, yi kɔ a liŋ si mih dzakaki i mbɛiŋ i liə a, ‘Di biə mih tsəki mbɛiŋ kɔkə i dzə fɛiŋ’ ");
INSERT INTO cug_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mih nyaki nchi wələ i mbɛiŋ, num nchi wimfiaŋ, a mbɛiŋ bâaŋ mbɛiŋ kɔ̂ŋniki. Mbɛiŋ kɔ̂ŋniki a liŋ asi mih kɔŋ mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mbɛiŋ baaŋ ka kɔŋniki yakadəiŋ, yələ ni fə bəni bəchi kiə a mbɛiŋ kɔ bwa bəŋ bə mbaŋ.” ");
INSERT INTO cug_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Samɔn Bita ka bikə i Jisɔs a, “Bah, wɔ tsəki i faiŋ a?” Jisɔs chukuli a, “Di biə mih tsəki wɔ mɔŋ i biəli mih i liə. Wɔ bi baaŋ biəliki lə.” ");
INSERT INTO cug_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bita fiəni bikə i wi a, “Bah, akɔ kɔm nə mih mɔŋ dəkə i biəli i liə a? Mih ni nya lə nɔni kəŋŋ i kpi kɔm wɔ.” ");
INSERT INTO cug_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisɔs bikə i wi a, “Wɔ kɔlə i nya nɔni ka i kpi kɔm mih a? Mih fukuki ŋkɔŋ i wɔ a, ka kwɔkɔ ni tɔŋki num wɔ nəiŋ mih kiŋkani kitali.” ");
INSERT INTO cug_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisɔs chu dzaka i bwa bu bə mbaŋ a, “Kiə mbɛiŋ ki bêe kə a shɔ́m yimbɛiŋ fûmsiki mbɛiŋ. Mbɛiŋ jîə shɔm i Nyɔ wə, bəh i mih tə. ");
INSERT INTO cug_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","I Ba wuŋ dzu, bəlum bəduli kɔlə. Asi mɔŋ a yi numki yaka, ma mih ka fuku dəkə a mih tsəki i kɛiŋsi di i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jɔbi wə mih ka tsə kɛiŋsi di i mbɛiŋ, mih ni fiəni dzə dzɔ mbɛiŋ bukumbɛiŋ numki, ka di biə mih kɔ, mbɛiŋ ni nûmki tə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mbɛiŋ kiəki lə dzəh yə yi tsəki i di biə mih tsəki.” ");
INSERT INTO cug_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tɔmɔs ka dzaka i wi a, “Bah, buku kiəki kə di biə wɔ tsəki. Buku kɔ i nyani na dəiŋ i kiə dzəh yiwɔ a?” ");
INSERT INTO cug_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisɔs chukuli a, “Akɔ mih dzəh, a num mih ŋkɔŋ, a num mih nɔni. Mi kɔkə i tsə i Ba wuŋ maka wi tsə dzəh i mih wə. ");
INSERT INTO cug_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Asi kɔ a mbɛiŋ kiəki mih ma mbɛiŋ kiəki lə tə Ba wuŋ. Ayaka i yisi i liə yi kɔ a mbɛiŋ si kiə lɔ wi, mbɛiŋ chu yɛiŋ tə wi.” ");
INSERT INTO cug_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filib dzaka i wi a, “Bah chûsi Ba wa i buku, ma buku yɛ̂iŋ wi ka buku fwuli.” ");
INSERT INTO cug_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisɔs chukuli wi a, “Filib, buku mbɛiŋ nɔ nalə wɔ kiə kə mih filib? Mi wə wi yɛiŋ mih, wi yɛiŋ lɔ Ba wuŋ. Wɔ nyani dəiŋ na i chu dzaka a mih chûsi Ba wuŋ i mbɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yaka wɔ ka bum dəkə a mih kɔ i Ba wuŋ mə, Ba wuŋ num i mih mə a? Ndzaka wə mih dzakaki i mbɛiŋ kɔkə a mih dzakaki i ŋga biŋ wə. Ba wuŋ wə wi kɔ i mih wə akɔ wi wə wi fəki bənɔm bu. ");
INSERT INTO cug_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mbɛiŋ bûm mih a mih kɔ i Ba wuŋ mə, Ba wuŋ num i mih mə. Mbɛiŋ kabə num maka mbɛiŋ bum mih kɔm gia yə mih dzakaki, mbɛiŋ bûm kɔm bə bənɔm bə̀ mih fəki. ");
INSERT INTO cug_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mih fukuki ŋkɔŋ i mbɛiŋ a mi wə wi kɔ wi jiə shɔm i mih, wi ni fəki tə bənɔm bə̀ mih fəki. Ayaka wi ni numki i fə bənɔm tsə na bə̀ mih fəki, kɔm mih si tsə lɔ i Ba wuŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Na finə fiə mbɛiŋ bikə i yɛli wuŋ wə, mih ni fə, ka Tii Waiŋ ni numki i kaŋa yɛli wimbum kɔm Waiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mbɛiŋ ka bikə na finə i yɛli wuŋ wə, ma mih ni fə. ");
INSERT INTO cug_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mbɛiŋ kabə kɔŋ mih, mbɛiŋ ni jîəki bənchi bəŋ, ");
INSERT INTO cug_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","mih ni tsa Ba wuŋ wi ni nya mbɛiŋ bəh Mi wi Gamtini widɔkɔ wə wi bi numki mbɛiŋ bɔ jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mi wələ kɔ Kiŋ'waka ki ŋkɔŋ. Wi kɔkə mi wə bəni bə̀ bɔ kɔ bə mbi wələ kɔ i dzɔ wi kɔm bɔ yɛiŋki kə i wi wə nabə i kiə wi. I yimbɛiŋ wə, mbɛiŋ kiəki lə wi, kɔm wi nɔki mbɛiŋ bɔ, ayaka wi ni numki i mbɛiŋ mə. ");
INSERT INTO cug_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mih ni beeka kə mbɛiŋ a mbɛiŋ bâaŋ ka bwa bəŋkwu. Mih ni fiəni dzə baaŋ lə bəh mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Baaŋ a twɛsi lə bəni bə̀ bɔ kɔ bə mbi ma ni chu yɛiŋ i mih wə. Ayakalə, mbɛiŋ ni yɛiŋ lə i mih wə. Si mih kɔ wiwɔm, mbɛiŋ tə ni numki bəwɔm. ");
INSERT INTO cug_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","A bi numki chɔkɔ biwɔ, mbɛiŋ bi kiə a mih kɔ i Ba wuŋ mə, mbɛiŋ num i mih mə, ayaka mih num i mbɛiŋ mə. ");
INSERT INTO cug_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mi wə wi kiəki bənchi bəŋ wi jiə, akɔ mi wə wi kɔŋki mih. Mi wə wi kɔŋki mih Ba wuŋ kɔŋki lə wi. Mih tə ni kɔŋki wi, mih ni chusi gwu yiŋ i wi.” ");
INSERT INTO cug_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas widɔkɔ (a kɔbi wə bə nì bɔɔŋki a Iskaliɔt) bikə i wi a, “Bah, yi ni nyani na dəiŋ a wɔ ni numki i chusi gwu ya num i buku, a kɔbi i bəni bə̀ bɔ kɔ bə mbi wələ a?” ");
INSERT INTO cug_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisɔs chukuli i wi a, “Mi kabə kɔŋki mih, wi ni jîəki ndzaka wuŋ, Ba wuŋ ni kɔŋki wi, buku Ba wuŋ ni dzə i wi wə buku ni nɔki bəh wi. ");
INSERT INTO cug_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mi wə wi kɔŋki kə mih, wəmaka mi si jiə kə ndzaka wuŋ. Ndzaka wə mbɛiŋ wɔkɔki a kɔkə wuŋ. Akɔ wi Ba wuŋ wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Gia yələ kɔ yə mih dzakaki i mbɛiŋ mih kɛiŋ bəh mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ayakalə, Mi wi Gamtini wə wi kɔ Kiŋ'waka ki Baiŋni wə Ba wuŋ bi faaŋ i yɛli wuŋ wə bi lani lə mbɛiŋ bəh gia yichi, wi chu fə mbɛiŋ i kwaka gia yichi yə mih nì kɔ mih dzaka lɔ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mih jiə kimbɔiŋni a ki nûm bəh mbɛiŋ. Mih nyaki kimbɔiŋni kə akɔ kəŋŋ i mbɛiŋ. Mih nyaki kə kimbɔiŋni kələ i mbɛiŋ si bəni bə̀ bɔ kɔ bə mbi si nya. Mbɛiŋ ki bee kə shɔ́m yimbɛiŋ a yi fumsiki mbɛiŋ nabə i kaŋa ndzaŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mbɛiŋ wɔkɔ lɔ si mih dzakaki a mih si nyə lə, mih num i bi fiəni dzə num bəh mbɛiŋ. Asi kɔ a mbɛiŋ kɔŋki mih, ma mbɛiŋ lâŋki laŋni, kɔm mih tsəki num i Ba wuŋ wə, si Ba wuŋ kɔ wi kɔkni tsə mih. ");
INSERT INTO cug_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","I liə mih fuku gia yələ i mbɛiŋ ka yi bi num, ayaka ka yi bi dzə kpɛiŋ, mbɛiŋ ka bi bum mih. ");
INSERT INTO cug_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mih ni chu baaŋ kə a dzakaki bəh mbɛiŋ nalə, kɔm ŋkuŋ wə wi sakaki mbi wələ si dzə lɔ. Yi kɔkə a wi kaŋaki lə ŋga i mih bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ayakalə, mih fəki num asi Ba wuŋ kɔ wi dzaka a mih fə̂ki ka bəni bə̀ bɔ kɔ bə mbi wələ ni kîə a mih kɔŋki lə Ba wuŋ. Mbɛiŋ dzâ bɛiŋ bə nyə̂.” ");
INSERT INTO cug_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Akɔ mih kpɛiŋ wi laani wi mintam mi ŋkɔŋ, Ba wuŋ num mi wə wi kɛiŋsiki kpɛiŋ wi laani wiwɔ. ");
INSERT INTO cug_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cha yichi i mih wə yə yi wumki kə mintam, wi si gba bwili lə yi, yə yi wumki mintam wi si kɛiŋsi kaŋŋ lə yi ka yi baiŋki yi wum mintam miduli. ");
INSERT INTO cug_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ndzaka wə mih kɔ mih dzaka i mbɛiŋ lə wi fə lɔ mbɛiŋ kabə baiŋki. ");
INSERT INTO cug_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mbɛiŋ bani baaŋ i mih wə, mih tə ni numki i mbɛiŋ wə. Cha kɔkə i wumki mintam a yiyi a kɔbi a yi bani baaŋ i kpɛiŋ wiwɔ wə. Yi kɔ tə a liŋ asi mbɛiŋ kɔkə bi fə gia yidɔkɔ maka mbɛiŋ bani i mih wə. ");
INSERT INTO cug_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Akɔ mih kpɛiŋ wi laani wi mintam wiwɔ, mbɛiŋ num cha yiwɔ. Mi wə wi bani baaŋ i mih wə, mih tə num i wi wə, wəmaka mi kɔ aka cha yə yi wumki mintam miduli, kɔm mih kabə kɔbi, mi kɔkə i fə gia yidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mi wə wi ka baaŋ dəkə i numki a bəh mih, wi kɔ aka cha yə bə ni gba tɔkɔ yi a yi wɔm. Ŋkaiŋni yi cha yələ kɔ yə bə si juŋni lɔɔ i gbuku wə a yi fîki. ");
INSERT INTO cug_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mbɛiŋ ka bani baaŋ a numki i mih mə, ja yiŋ num i mbɛiŋ mə, mbɛiŋ kɔlə i bikə na finə fiə mbɛiŋ nəŋki, ma bə ni fə yi i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mbɛiŋ kabə num cha yə yi wumki mintam miduli, yi nyaki yɛli wimbum i Ba wuŋ, yi ni ka chusiki a mbɛiŋ kɔ bəni mbəŋ bə mbaŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Asi Ba wuŋ kɔŋki mih akɔ ayaka si mih kɔŋki mbɛiŋ. Mbɛiŋ bani baaŋ a i numki i kiŋkɔŋ kəŋŋ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mbɛiŋ ka jiəki bənchi mbəŋ, mbɛiŋ ni baaŋ a numki a kiŋkɔŋ kəŋŋ kintəəŋ, asi mih jiə bənchi bə Ba wuŋ, ka chu baaŋ a numki i kiŋkɔŋ ki mə. ");
INSERT INTO cug_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mih dzakaki gia yələ i mbɛiŋ lə ka kinsaŋli kəŋŋ ni nûmki i mbɛiŋ mə, mbɛiŋ ka ni kaŋaki kinsaŋli num ki jikə. ");
INSERT INTO cug_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nchi wuŋ kɔ wələ wə wi kɔ a mbɛiŋ kɔŋniki asi mih kɔŋki mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kiŋkɔŋ kidɔkɔ chu kɔkə kə ki tsəki kə a mi nyâ nɔni ki i kpî kɔm bə nsɛ́iŋ yi. ");
INSERT INTO cug_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Mbɛiŋ kabə fəki gia yə mih dzakaki a mbɛiŋ fə̂ki, yaka kɔ a mbɛiŋ kɔ nsɛ́iŋ yiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mih ni chu bɔ̂ɔŋki kə mbɛiŋ a bwa bə nɔm, kɔm bwa bə nɔm si kiə kə gia yichi yə tikwili wibɔ fəki. Mih si bɔɔŋ lɔ mbɛiŋ a nsɛ́iŋ yiŋ kɔm gia yichi yə mih wɔkɔ i Ba wuŋ kɔ num mih fə lɔ mbɛiŋ kiə yi. ");
INSERT INTO cug_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A nì ka saiŋbwili dəkə mbɛiŋ mih. A nì saiŋbwili mih mbɛiŋ, bwili jiə a mbɛiŋ tsə̂ nûmki ka chá yə yi wumki mintam, mintam mə mɔ bi tsə kaa kə. Mbɛiŋ kabə fəki lə, ma na finə fiə mbɛiŋ bikə i Ba wuŋ, i yɛli wuŋ wə wi ni nya i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nchi wə mih nyaki i mbɛiŋ kɔ a wələ, a mbɛiŋ kɔ̂ŋniki. ");
INSERT INTO cug_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Bəni bə̀ bɔ kɔ bə mbi wələ kabə baiŋŋki mbɛiŋ, mbɛiŋ kiəki a bɔ nì yisi baiŋŋ mih na ka bɔ baiŋŋki mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mbɛiŋ kabə num bəni bə̀ bɔ kɔ bə mbi wələ, ma bəni bə mbi wələ ni kɔŋki mbɛiŋ ka bəni bəbɔ. Ayakalə, mbɛiŋ kɔkə bəni bə mbi wələ, mih baa mbɛiŋ i kintəəŋ ki bəni bə mbi wələ wə. Akɔ gia yə bəni bə mbi bələ baiŋŋki mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mbɛiŋ kwâka ndzaka wə mih si dzaka i mbɛiŋ, a waiŋ wi nɔm si mbɔm tsə kə tikwili wi. Bɔ ka bwaŋki gvu i mih chɛiŋ, ma bɔ ni bwaŋki tə i mbɛiŋ chɛiŋ. Bɔ ka wɔkɔki ndzaka wuŋ, ma bɔ ni wɔkɔki tə wimbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yələ yichi kɔ gia yə bə bi fəki i mbɛiŋ kɔm mih, kɔm bɔ kiəki kə mi wə wi faaŋ mih. ");
INSERT INTO cug_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","A nì kɔ a mih nì ka dzə dzaka i bɔ, ma yi numki a bɔ kaŋaki kə ŋgbɔ widɔkɔ. Ayakalə, i liə bɔ kaŋaki kə gia yidɔkɔ yə bɔ kɔ dzaka kɔm chu bibɔ. ");
INSERT INTO cug_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mi wə wi baiŋŋki mih wi baiŋŋki lə tə Ba wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","A nì kɔkə a mih nì fə ŋkaiŋni bənɔm bədɔkɔ i bɔ kintəəŋ bə̀ mi widɔkɔ kɛiŋki ki fə kə, ma bɔ ka kaŋa dəkə ŋgəkə widɔkɔ. Ayakalə, bɔ kɔ bɔ yɛiŋ, bɔ kɛiŋ baiŋŋ mih bəh Ba wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yələ kɔ i fə a ja yiwɔ dzə kpɛiŋ asi bə nì nyaka i Kiŋwakti ki Bənchi bəbɔ wə a, ‘Bɔ baiŋŋ mih kilɔlɔ.’ ");
INSERT INTO cug_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ayakalə, Mi wi Gamtini wə mih ni chiŋsi bi dzə lə, num wi buku dzə i Ba wuŋ wə. Mi wi Gamtini wələ akɔ num Kiŋ'waka ki ŋkɔŋ kə ki nyə dzə i Ba wuŋ wə. I jɔbi wə wi ni dzə wi ni num mbêeŋ nsaka wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mbɛiŋ tə bi nûmki bəmbeeŋ nsaka bəŋ, kɔm mbɛiŋ kɔ num bukumbɛiŋ nì kɔlə i kin'yisi wə bəh i dzə buku bidaiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mih dzakaki gia yələ yichi i mbɛiŋ ka mbɛiŋ bi ma gbɔ i kimbum kimbɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bə bi kɔŋŋki lə mbɛiŋ i júŋ yi tsani mə. Yi ŋkɔŋ kɔ a, jɔbi dzəki lə wə na ndə wə wi bi wɔɔki mi i mbɛiŋ wə, wi ni kwakaki a ŋgaiŋ fəki num nɔm wi ndzɔŋni i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Bə bi fə yakadəiŋ, kɔm bɔ ka kiə dəkə Ba wuŋ nabə mih. ");
INSERT INTO cug_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mih dzakaki gia yələ yichi i mbɛiŋ lə, ka jɔbi wiwɔ bi dzə kpɛiŋ mbɛiŋ bi kwaka a mih nì kɔ num mih dzaka lɔ yi i mbɛiŋ. Mih nì ka fuku dəkə gia yələ i mbɛiŋ i kin'yisi wə kɔm mih nì shi kɔ a bəh mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","I liə si num a mih fiəniki tsəki i wi wə wi nì faaŋ mih. Ayakalə, mi widɔkɔ i mbɛiŋ kintəəŋ na bikə i mih a mih tsəki faiŋ na. ");
INSERT INTO cug_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mbɛiŋ kɔ a nshɛiŋ nshɛiŋ kɔm mih dzaka gia yələ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na si yi kɔ yakadəiŋ lə, mih fukuki ŋkɔŋ i mbɛiŋ a, akɔ num gia yindzɔŋni i mbɛiŋ a mih nyə. Mih ka baaŋ maka mih nyə̂, ma Mi wi Gamtini wə bi ma dzə̂. Ayakalə, mih ka nyə, mih bi ka chiŋsi wi i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jɔbi wə wi bi dzəki, wi bi tɔyi gia yi bəni bə̀ bɔ kɔ bə mbi wələ, fə̂ bɔ yɛ̂iŋ chu bibɔ, fə̂ bɔ yɛ̂iŋ gia yə yi kɔ nɔni ki chəŋ, fə̂ tə a bɔ yɛ̂iŋ yə yi kɔ i nsaka wi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wi bi fə̂ a bɔ yɛ̂iŋ chu bibɔ si bɔ nì ka jiə dəkə shɔm i mih, ");
INSERT INTO cug_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","fə̂ a bɔ yɛ̂iŋ gia yə yi kɔ i nɔni ki chəŋ wə si mih tsəki i Ba wuŋ, mbɛiŋ kɔbi i ni chu yɛiŋ i mih wə. ");
INSERT INTO cug_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wi bi fə̂ lə ka bɔ yɛ̂iŋ gia yə yi kɔ i nsaka wi Nyɔ wə kɔm ŋkuŋ wi mbi wələ kɔ num nsaka kwa wi. ");
INSERT INTO cug_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mih kɛiŋki mih kaŋa na gia yiduli i dzaka i mbɛiŋ ayakalə, yi kɔbi i liə ndzɔŋ i bintuni bimbɛiŋ wə i liə. ");
INSERT INTO cug_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jɔbi wə, Kiŋ'waka ki ŋkɔŋ bi dzəki, wi bi gamti mbɛiŋ a mbɛiŋ kiə ŋkɔŋ bichi. Wi bi dzakaki kə num i ŋga bi wə. Gia yichi yə wi kɔ wi wɔkɔ akɔ yə wi bi dzakaki, wi fuku i mbɛiŋ gia yichi yə yi kɔ i bi dzə. ");
INSERT INTO cug_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wi bi chusi lə mbum biŋ, si wi bi dzɔ gia yə akɔ yiŋ wi fuku i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Biɛiŋ bichi biə Ba wuŋ kaŋaki akɔ biŋ. Akɔ gia yə mih dzakaki a wi bi dzɔki gia yə yi kɔ yiŋ wi fuku i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","A baaŋ a twɛsi mbɛiŋ ma chu yɛiŋ i mih wə, ayaka bə ni mɔti a twɛsi ma mbɛiŋ ni fiəni chu yɛiŋ mih.” ");
INSERT INTO cug_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Si Jisɔs dzaka yakadəiŋ, bwa bu bə mbaŋ bədɔkɔ dzaka i bədɔkɔ a, “Wi dzakaki a nə i bukumbɛiŋ lə, a baaŋ a twɛsi bukumbɛiŋ ma chu yɛiŋ ŋgaiŋ, ayaka a bə ni mɔti a twɛsi bukumbɛiŋ ni fiəni chu yɛiŋ ŋgaiŋ, bə a ŋgaiŋ tsəki i Ba wi ŋgaiŋ na? ");
INSERT INTO cug_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Gia yə wi dzakaki lə, a baaŋ a twɛsi yəmaka kɔ a nə a? Bukumbɛiŋ ka kiə dəkə gia yə wi dzakaki yakadəiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisɔs dza yɛiŋ a bɔ nəŋki i bikə i ŋgaiŋ gia yə wi dzakaki, wi ka bikə i bɔ a, “Mbɛiŋ shwiŋyiki a mbɛiŋ mbɛiŋ kɔm a gia yə mih si dzaka a, ‘A baaŋ a twɛsi mbɛiŋ ma ni chu yɛiŋ mih, ayaka a bə ni mɔti a twɛsi ma mbɛiŋ ni fiəni chu yɛiŋ i mih’ a? ");
INSERT INTO cug_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ bi dəki lə mindəm wili, bəni bə̀ bɔ kɔ bə mbi wələ bi laŋki fibɔ. Mbɛiŋ bi numki a i nshɛiŋ wə, ayakalə nshɛiŋ yiwɔ bi dza fiəni i kinsaŋli wə. ");
INSERT INTO cug_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jɔbi wə miŋkpaŋa si nɔmh, wi ka wɔkɔki lɔli, kɔm jɔbi wi bwɔni kpɛiŋ lɔ. Jɔbi wə wi bwɔ waiŋ wi, wi na chu kwakaki lɔli biwɔ, kɔm wi wɔkɔki num ndzɔŋni a mi wiwɔm dzə i mbi wə. ");
INSERT INTO cug_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Akɔ asi yi kɔ i mbɛiŋ i liə. Mbɛiŋ kɔ a nshɛiŋ nshɛiŋ, ayakalə jɔbi wə mih bi fiəni dzə yɛiŋ mbɛiŋ, ka mbɛiŋ bi numki bəh kinsaŋli i shɔ́m yimbɛiŋ wə, kəmaka kinsaŋli bi numki kə mi widɔkɔ kɔkə bi dzɔ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","A bi numki i jɔbi wiwɔ wə, mbɛiŋ bi ma chu bikə gia yidɔkɔ i mih. Mih fukuki ŋkɔŋ i mbɛiŋ a, mbɛiŋ ka bikə na finə i Ba wuŋ i yɛli wuŋ wə, wi ni nya fi i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Na i dzə buku i liə, mbɛiŋ ka bikə dəkə fiɛŋ fidɔkɔ i Ba wuŋ, i yɛli wuŋ wə. Mbɛiŋ bikə, ma mbɛiŋ ni kwati, ka kinsaŋli kimbɛiŋ ni jikə. ");
INSERT INTO cug_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Mih dzakaki ndzaka wələ num a ŋkwiŋ ŋkwiŋ, ayakalə jɔbi dzəki lə wə mih bi chu dzakaki kə i mbɛiŋ ŋkwiŋ ŋkwiŋ. Mih bi dzaka baiŋsi lə i mbɛiŋ kɔm Ba wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","A bi numki i jɔbi wiwɔ wə, mbɛiŋ bi bikəki lə fiɛŋ i Ba wuŋ, i yɛli wuŋ wə. Mih dzakaki kə a mih bi nywaki lə fiɛŋ i Ba wuŋ kɔm mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ba wuŋ mwi kɔŋki lə mbɛiŋ, kɔm mbɛiŋ kɔŋ mih ka chu bum a mih nyə i wi Ba wuŋ. ");
INSERT INTO cug_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mih nì nyə i Ba wuŋ wə ka mih dzə i mbi wələ wə, i liə mih beeki mbi wələ i fiəni tsə i Ba wuŋ wə.” ");
INSERT INTO cug_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Si Jisɔs dzaka yakadəiŋ bwa bu bə mbaŋ tɔbi ka dzaka a, “Aaŋ! I liə wɔ dzaka bwili chu kɔbi ŋkwiŋ ŋkwiŋ! ");
INSERT INTO cug_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","I liə buku yɛiŋ lɔ a wɔ kiəki lə gia yichi chu wɔkɔli kə a mi widɔkɔ bikə num bikəni i wɔ. Gia yələ fə buku ka bum a wɔ nyə i Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisɔs chukuli i bɔ a, “Yaka mbɛiŋ bum i liə a? ");
INSERT INTO cug_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jɔbi dzəki lə, num wi si dzə lɔ, wə mbɛiŋ bi gaaliki fimu fimu na ndə tsə i wi dzu, mbɛiŋ ni gɛiŋ bee mih, mih mbɔŋ. Ayakalə, mih kɔkə mih mbɔŋ, kɔm Ba wuŋ kɔlə buku wi. ");
INSERT INTO cug_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mih fukuki gia yələ i mbɛiŋ lə si mbɛiŋ kɔ i mih mə, mbɛiŋ ni kaŋa lə kimbɔiŋni. I mbi wələ wə mbɛiŋ kaŋaki lə bəŋgəkə, ayakalə mbɛiŋ nûmki bəh shɔm yi kaŋani. Kɔm mih gaka lɔ mbi wələ.” ");
INSERT INTO cug_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jɔbi wə Jisɔs nì dzaka kaasi ndzaka wələ, ka dza giŋsi dzə́kəh yi tsɛiŋ i bɛiŋ tsa a, “Ba wuŋ, jɔbi kpɛiŋ lɔ. Chûsi kiŋkɔkni ki Waiŋ wa ka Waiŋ tə ni chûsi kiŋkɔkni ka. ");
INSERT INTO cug_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Wi kɔlə i chusi kɔm wɔ nya ŋga i wi i bəni bəchi bɛiŋ a wi nyâ nɔni kə ki bi tsə kaa kə, i bə̀ bəchi bə̀ wɔ kɔ wɔ nya i wi. ");
INSERT INTO cug_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nɔni kələ ki bi tsə kaa kə akɔ num kələ a bɔ kîəki wɔ Nyɔ a num a wɔ Nyɔ wi ŋkɔŋ, bəh mih Jisɔs Klistus wə wɔ nì faaŋ. ");
INSERT INTO cug_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mih chusi lɔ mbum bia i fa kuku asi mih kaasi nɔm wə wɔ nì nya a mih nɔ̂m. ");
INSERT INTO cug_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","I liə Ba wuŋ, fiəni nyâ mih kiŋkɔkni i wɔ nshiŋ kə mih nì kaŋaki buku wɔ i ninshiŋ ka mbi yisi. ");
INSERT INTO cug_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mih chusi lɔ wɔ i bəni bə̀ wɔ nì sabi i fa mbi wələ wə ka nya i mih. Bəni bələ nì kɔ mba, ayaka wɔ ka nya bɔ i mih. Bɔ ka wɔkɔ ja ya. ");
INSERT INTO cug_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","I liə bɔ kiə lɔ a biɛiŋ bichi biə mih kaŋaki kɔ num bi nyə i wɔ. ");
INSERT INTO cug_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mih dzakaki lə kɔm mih kɔ mih nya lɔ gia yə wɔ nì nya i mih i bɔ, bɔ dzɔ yi, ka kiə ŋkɔŋ a mih nyə dzə i wɔ wə, ka bum tə a, a nì faaŋ wɔ mih. ");
INSERT INTO cug_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mih tsaki lə a num i bələ. Mih tsaki kə num i bə̀ bɔ kɔ num bə mbi wələ. Mih tsaki num i bələ wɔ nya i mih, kɔm akɔ bəni ba. ");
INSERT INTO cug_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Biɛiŋ bichi biə mih kaŋaki akɔ mbia, biɛiŋ bichi biə wɔ kaŋaki akɔ mbiŋ. Akɔ i bəni bələ mbum biŋ chusiki. ");
INSERT INTO cug_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","I liə mih chu mɔŋ i fa mbi wələ wə. Ayakalə, bɔ kɛiŋki lə i fa mbi wələ wə, ayaka mih si fiəni dzə i wɔ. Ba wuŋ wi baiŋni, jîə bɔ i yɛli wa wə wɔ nya i mih, ka bɔ numki i mi wimu wə asi buku wɔ kɔ i mi wimu wə. ");
INSERT INTO cug_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jɔbi wə mih nì kɔ bəh bɔ, mih nì jiə bɔ i yɛli wa wə wɔ nya i mih. Mih tɔkni bəh bɔ mi i bɔ wə na laka, a kɔbi a wə wi nì kɔ num wə wi nì kaŋaki i laka. Ayaka yələ num ka gia yə bə nì nyaka i Kiŋwakti ki Nyɔ wə, a yi dzə kpɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","I liə mih si fiəni dzə i wɔ wə, mih dzaka gia yələ mih kɛiŋ i mbi wələ wə ka bɔ ni kaŋa kinsaŋli kə ki kɔ kəŋŋ num ki jikə i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mih kɔ mih nya ja ya i bɔ kaŋ, bəni bə̀ bɔ kɔ bə mbi wələ ka bə baiŋŋ bɔ, kɔm bɔ chu mɔŋ bəni bə mbi wələ, a liŋ asi mih kɔkə mi i mbi wələ wə. ");
INSERT INTO cug_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mih tsaki kə lə a wɔ bwîli bɔ i mbi wələ wə. Mih tsaki num a wɔ tɔ̂kni bəh bɔ, kiə bɔ ki lîə kə i kaŋ yi mi wichu wə. ");
INSERT INTO cug_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Bɔ kɔkə bəni bə mbi wələ, a liŋ asi mih kɔkə mi i mbi wələ wə. ");
INSERT INTO cug_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kɛ̂iŋsi bɔ wɔ jîə chi chi ma bɔ baiŋki i ŋkɔŋ kintəəŋ. Ja ya kɔ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Asi wɔ nì faaŋ mih i mbi wələ wə, akɔ a liŋ asi mih faaŋ bɔ tə i mbi wə. ");
INSERT INTO cug_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mih ka kɛiŋsi jiə gwu yiŋ chi chi kɔm bəh bɔ, ka bɔ tə kɛiŋsi jiə gwu yibɔ chi chi i ŋkɔŋ wə. ");
INSERT INTO cug_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mih tsaki kə a bəni bələ shəŋ. Mih tsaki tə i bəni bəchi bə̀ bɔ bi wɔkɔki ndzaka wibɔ jiə shɔm i mih wə. ");
INSERT INTO cug_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mih tsaki a bɔ bəchi bi dzə num i mi wimu wə, na asi wɔ Ba wuŋ kɔ wɔ num i mih wə mih num tə i wɔ wə. Mih tsa a bɔ tə bi nûmki i buku wɔ wə, ka bəni bə mbi wələ bi bûm a, a nì faaŋ wɔ mih. ");
INSERT INTO cug_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mbum biə wɔ nì duksi mih yɛiŋ mih nya lɔ i bɔ, ka bɔ bi nûmki i mi wimu wə, asi buku wɔ kɔ i mi wimu wə, ");
INSERT INTO cug_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","mih kɔ i bɔ mə, wɔ num i mih mə. A bɔ nûmki nalə i mi wimu wə, ayakadəiŋ ka bəni bə̀ bɔ kɔ bə mbi wələ kîə a, a nì faaŋ wɔ mih, wɔ kɔŋ bɔ asi wɔ kɔŋki mih. ");
INSERT INTO cug_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ba wuŋ, mih nəŋki a bə̀ wɔ nya i mih a bɔ bi dzə̂ nûm tə bəh mih i di biə mih kɔ, ka bɔ bi yɛ̂iŋ kiŋkɔkni kə wɔ nì nya i mih kɔm bə kiŋkɔŋ ka i mih wə na ka mbi wələ yisi. ");
INSERT INTO cug_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Wɔɔɔ Ba wuŋ wi chəŋ, bəni bə mbi wələ kiəki kə wɔ ayakalə, mih kiəki lə wɔ, bəni bəŋ bələ kiə a nì faaŋ wɔ mih. ");
INSERT INTO cug_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mih fə lɔ bɔ kiə wɔ, mih kɛiŋ i ni fəki bɔ kiə wɔ, ka kiŋkɔŋ ka kə wɔ kɔŋ mih yɛiŋ numki i bɔ mə, mih tə num i bɔ mə.” ");
INSERT INTO cug_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jɔbi wə Jisɔs nì tsa kaasi, wi bəh bwa bu bə mbaŋ ka nyə fɛiŋ, tsə ndaŋ kaŋŋ yə bə nì bɔɔŋki a Kidlɔn ka tsə i waka widɔkɔ wəyaka wə, khə wi kɛiŋ yi mitam num fɛiŋ, bɔ bwa bu bə mbaŋ ka liə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A nì kɔ Judas wə wi nì taŋni Jisɔs kîə tə di biwɔ, kɔm Jisɔs bəh bwa bu bə mbaŋ nì kɔmsiki tsəki lə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ayakadəiŋ, Judas ka tsə fɛiŋ bəh mbaŋ wi bəni bə jum bəh bəni bədɔkɔ bə̀ bɔ nì tsɛiŋki juŋ yi fəni yi gia. Bəni bələ num a faaŋ bətii mfə gia bəmbum bə Bəfalasi bɔ. Bɔ nì tsəki kaŋa gbuku wi baiŋsini bəh naka bi baiŋsini bəh biɛiŋ bi jum. ");
INSERT INTO cug_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Si Jisɔs ni kiə gia yə yi kaŋaki i nûm bəh wi, wi ka buku dzə i ninshiŋ, bikə i bɔ a, “Mbɛiŋ nəŋki num ndə?” ");
INSERT INTO cug_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Bɔ ka chukuli i wi a, “Jisɔs wi Nasali.” Jisɔs ka dzaka i bɔ a, “Akɔ mih wiwɔ.” A nì kɔ Judas wə wi nì taŋni wi, wi num i bɛiŋ bəh bəni bəwɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jɔbi wə Jisɔs fuku i bɔ a, akɔ ŋgaiŋ wiwɔ, bɔ ka chu lɔ bəh jum bəh jum, gbɔyi i kuku. ");
INSERT INTO cug_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wi ka chu bikə i bɔ a, “Mbɛiŋ nəŋki num ndə a?” Bɔ chukuli a, “Jisɔs wi Nasali.” ");
INSERT INTO cug_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisɔs dzaka i bɔ a, “Mih si fuku lɔ i mbɛiŋ a, akɔ mih wiwɔ. Yaka mbɛiŋ fa nəŋki num mih, mbɛiŋ bêe bəni bələ nyə̂.” ");
INSERT INTO cug_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Wi nì dzaka yaka i fə a yi dzə kpɛiŋ i ja yə wi nì kɔ wi dzaka lɔ i Nyɔ a, ŋgaiŋ ka laksi dəkə mi wimu i bə̀ wi nì nya i ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Samɔn Bita nì kaŋaki lə nywɔ wi jum. Wi ka baa nywɔ i kimbaka wə ka gba chwiŋ təiŋ kintuni ki tsɛiŋ yiləkəli yi mfa wi fwu wi bətii mfə gia. Yɛli wi mfa wiwɔ num a Malkus. ");
INSERT INTO cug_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisɔs ka dzaka i Bita a, “Fîəni lə̂kə nywɔ wa i kimbaka wə. Yaka mih ni mu kə bwam wi ŋgəkə wə Ba wuŋ kɔ wi nya i mih ma?” ");
INSERT INTO cug_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Fwu wi bəni bə jum bəh mbaŋ wi bəni bə jum bəh bəni bə̀ bɔ nì tsɛiŋki juŋ yi fəni yi gia yi Bəju ka kwa Jisɔs ka kaŋa wi bəh bəkwu. ");
INSERT INTO cug_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Bɔ yisi dzɔ wi tsə bəh wi i Anas, kɔm Anas nì kɔ tii kpə Kayfas wə wi nì kɔ fwu wi bətii mfə gia i jia yiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayfas wələ kɔ wə wi nì yisi nya kintəfi i Bəju a yi ndzɔŋki a mi wimu kpi i bəni bəchi fuŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Si bɔ nì tsəki bəh Jisɔs yakadəiŋ, Samɔn Bita bəh waiŋ wi mbaŋ wi Jisɔs widɔkɔ ka biəli Jisɔs. Si waiŋ mbaŋ wi Jisɔs wələ nì kɔ fwu wi bətii mfə gia kiə wi, wi ka biəli Jisɔs tsə liə i tɔkɔ wi fwu wi bətii mfə gia wə. ");
INSERT INTO cug_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bita num baaŋ i biŋ i dzaka ki mbaiŋ kpəŋ. Waiŋ mbaŋ wi Jisɔs wə fwu wi bətii mfə gia nì kiəki wi, fiəni buku tsə dzaka i waiŋkpaŋni wə wi nì tsɛiŋki dzaka ki mbaiŋ, dzɔ liə dzə bəh Bita. ");
INSERT INTO cug_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Waiŋkpaŋni wiwɔ bikə i Bita a, “Ntə wɔ kɔ tə mi wi mbaŋ wi mi wələ a?” Bita chukuli a, “A mɔŋ mih.” ");
INSERT INTO cug_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A nì kɔ biŋ də, bwa bə nɔm bəh bəni bə̀ bɔ nì tsɛiŋki juŋ yi fəni yi gia kpa gbuku ka numyi bɛiŋ ka bə́ jɔkɔki. Bita ka tsə num tə bɛiŋ bə́ jɔkɔ. ");
INSERT INTO cug_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Fwu wi bətii mfə gia ka bikə kimbikə i Jisɔs kɔm bə bwa bu bə mbaŋ bəh kɔm nlani wi. ");
INSERT INTO cug_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisɔs chukuli i wi a, “Mih si fuku baiŋsi lɔ yi i mbi wichi. Mih si lani lə bəni i juŋ yi tsani wə bəh i juŋ yi fəni yi gia wə i di biə Bəju bəchi si juŋni. Mih ka num dzaka dəkə gia yidɔkɔ i nyumi wə. ");
INSERT INTO cug_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wɔ bikəki gia yələ num i mih kɔm nə? Bîkə num i bəni bə̀ bɔ si wɔkɔ si mih dzakaki. Bɔ kiəki lə gia yə mih si dzaka.” ");
INSERT INTO cug_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Si Jisɔs dzaka yakadəiŋ, mi widɔkɔ i mbaŋ wi bəni bə̀ bɔ nì tsɛiŋki juŋ yi fəni yi gia num wi num bɛiŋ i kɔmsi i wi kpəŋ ka wɔɔ kaŋ i kimbaŋ ki wə, bikə i wi a, “Akɔ dzəh yə wɔ chukuliki fwu wi bətii mfə gia lə a?” ");
INSERT INTO cug_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisɔs bikə i wi a, “A kabə num a mih si dzaka i fikpəŋ, wɔ chûsi kiŋgbɔ kəŋŋ. A kabə num a mih si dzaka num ŋkɔŋ, wɔ ka twɛiŋ lɔ mih kɔm nə?” ");
INSERT INTO cug_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anas ka dza chiŋsi Jisɔs i Kayfas fwu wi bətii mfə gia. Jisɔs nì kɛiŋki a bəkwu wə. ");
INSERT INTO cug_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Si Samɔn Bita nì kɛiŋki num wi num i bɛiŋ jɔkɔ gbuku, bəni bikə i wi a, “Ntə wɔ kɔ mi widɔkɔ i mbaŋ wi bəni bu wə a?” Bita nəiŋ ka dzaka a, “A mɔŋ dəkə mih.” ");
INSERT INTO cug_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Waiŋ wi nɔm wi fwu wi bətii mfə gia widɔkɔ chu bikə i Bita a, “Mih si ka yɛiŋ mbɛiŋ wi i khə wi mbaiŋ wə a?” Waiŋ wi nɔm wələ nì kɔ mi i chwɔŋkijuŋ ki mi wə Bita si təiŋ kintuni ki. ");
INSERT INTO cug_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bita ka chu nəiŋ. A i jɔbi wiwɔ wə kwɔkɔ ka tɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Bəni ka dzɔ Jisɔs i juŋ yi Kayfas wə ka tsəki bəh wi i ntɔŋ wi mi wi Lum wə wi sakaki fɛiŋ. A nì kɔ a kɛiŋ kinchɔŋɔchɔŋɔ. Jɔbi wə bɔ nì tsə bɔ nì ka liə fibɔ i ntɔŋ wi mi wiwɔ wə, kɔm a nì kɔ a bɔ liə, ma bɔ nì jisi shi bibɔ, na dzi dəkə Dzini bi Ntsədaŋ. ");
INSERT INTO cug_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ayakadəiŋ, Baylɛ ka buku dzə yɛiŋ bɔ bikə i bɔ a, “Akɔ yi naiŋ gia mbɛiŋ yɛiŋ mi wələ gbɔ yɛiŋ a?” ");
INSERT INTO cug_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Bɔ chukuli i wi a, “Asi kɔ a mi wələ ma numki mi wichu, ma buku ka dzə dəkə bəh wi i nya a bə wɔɔ.” ");
INSERT INTO cug_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Baylɛ ka chukuli i bɔ a, “Mbɛiŋ dzɔ̂ wi, ma mbɛiŋ sâka kiə wi a mbɛiŋ mbɛiŋ asi bənchi bəmbɛiŋ nəŋki.” Bəju ka dzaka i wi a, “Buku kaŋaki kə ŋga i wɔɔ mi.” ");
INSERT INTO cug_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ndzaka wələ dzə kpɛiŋ i ja yə Jisɔs nì kɔ wi dzaka lɔ chusi ŋkaiŋni yi kpi yə wi kaŋaki i bi kpî. ");
INSERT INTO cug_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Baylɛ fiəni liə tsə i ntɔŋ wi wə, ka dzaka a bə dzə bəh Jisɔs, wi ka bikə i wi a, “Akɔ wɔ Ŋkuŋ wi Bəju a?” ");
INSERT INTO cug_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisɔs bikə i wi a, “Wɔ dzaka yələ num i kiŋkwaka ka wə, ma a dzaka bəni bədɔkɔ i wɔ kɔm mih a?” ");
INSERT INTO cug_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Baylɛ bikə i wi a, “Mih kɔ mi wi Ju a? Akɔ bəni ba bə kwili bəh bətii mfə gia bəmbum bɔ dzɔ wɔ ka dzə nya i mih. Wɔ fə num nə?” ");
INSERT INTO cug_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisɔs chukuli i wi a, “Ŋkuŋ biŋ kɔkə ka bi fa mbi wələ wə. Asi kɔ a ŋkuŋ biŋ numki ka bi fa mbi wələ, ma bəni bəŋ bə nɔm si jwɔ a bə ki nyâ kə mih i kaŋ yi Bəju wə. Ayakalə, ŋkuŋ biŋ kɔkə dəkə biə bi nyə i mbi wələ wə.” ");
INSERT INTO cug_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Baylɛ ka bikə i wi a, “Yaka wɔ kɔ ŋkuŋ a?” Jisɔs chukuli i wi a, “Yi kɔ asi wɔ dzaka a mih kɔ ŋkuŋ. Bə nì bwɔ mih kɔm yələ, ayaka mih nì dzə i mbi wələ wə kɔm bə yələ a mih dzakaki kɔm bəh ŋkɔŋ. Na ndə wə wi biəliki ŋkɔŋ wi wɔkɔki lə ja yiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Baylɛ bikə i wi a, “Ŋkɔŋ kɔ nə a?” Si wi dzaka yakadəiŋ ka fiəni buku tsə yɛiŋ Bəju i biŋ dzaka i bɔ a, “Mih ka yɛiŋ dəkə ŋgbɔ widɔkɔ i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ayakalə, mbɛiŋ si kaŋa lə nɔni kimbɛiŋ kidɔkɔ a i jɔbi wi Dzini bi Ntsədaŋ wə mih bwîli mi wi juŋ yi nsəŋ wimu. Mbɛiŋ nəŋki a mih bwîli num ŋkuŋ wi Bəju wələ a?” ");
INSERT INTO cug_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Bəju bəwɔ wili bəh ŋga a, “Aayi, buku nəŋki kə num mi wələ, bwîli num Balabas!” Balabas wə wi nì kɔ mi i mbaŋ wi bəni bə̀ bɔ nì jwɔki Gɔmna wi Lum. ");
INSERT INTO cug_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Baylɛ ka dzɔ Jisɔs nya bə shɛli wi bəh ŋgaŋa. ");
INSERT INTO cug_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Bəni bə jum fə kifɔ ki ŋkuŋ kii bə bwaŋyi yɛiŋ ka bwaŋ i wi fuŋ, dzɔ mbuŋ wi bəŋkuŋ wi bɔkɔli, ka tum i wi wə. ");
INSERT INTO cug_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Bɔ ka dzə i wi dzaka a, “Mbɛɛ, jum yi bɔkɔli. Ŋkuŋ wi Bəju.” Si bɔ nì dzakaki yakadəiŋ twɛiŋ wi bəh kaŋ. ");
INSERT INTO cug_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Baylɛ ka chu buku tsə i biŋ dzaka i bəni a, “Mbɛiŋ yɛ̂iŋ, mih ki bwiliki lə mi wələ i biŋ mih nya i mbɛiŋ, ka mbɛiŋ kiə a mih ka yɛiŋ dəkə gia yə wi gbɔ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jisɔs ka bukuki dzəki bəh kifɔ ki bəmbwaŋyi kə i wi fuŋ bəh mbuŋ wi bəŋkuŋ i wi wə. Baylɛ ka dzaka i bɔ a, “Mbɛiŋ yɛ̂iŋ bə mi wiwɔ lə!” ");
INSERT INTO cug_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì chəniki juŋ yi fəni yi gia, yɛiŋ wi yakadəiŋ, ka yisi i wiliki a, “Bâŋŋ wi i kintasi wə, bâŋŋ wi i kintasi wə!” Baylɛ dzaka i bɔ a, “Mbɛiŋ dzɔ̂ la wi bəh kaŋ yimbɛiŋ ma mbɛiŋ bâŋŋ i kintasi wə, kɔm mih ka yɛiŋ dəkə gia yə wi gbɔ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Bəju bəwɔ fiəni chukuli i wi a, “Buku kaŋaki lə nchi wibuku, nchi wiwɔ chusiki a wi kaŋaki lə i kpî, kɔm wi fə gwu yi a ŋgaiŋ kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jɔbi wə Baylɛ wɔkɔ ndzaka wiwɔ yaka chu num lwa nalə. ");
INSERT INTO cug_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Bɔ Jisɔs fiəni liə tsə i saŋ wi wi shini wə, wi bikə i Jisɔs a, “Wɔ nyə faiŋ?” Ayakalə, Jisɔs nəki chukuli kə gia yidɔkɔ i wi. ");
INSERT INTO cug_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Baylɛ bikə i Jisɔs a, “Wɔ dzakaki kə i mih a? Wɔ kiəki kə a mih kaŋaki lə ŋga i bwili wɔ, mih chu kaŋa ŋga i dzaka a bə baŋŋ wɔ i kintasi wə a?” ");
INSERT INTO cug_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisɔs chukuli i wi a, “Wɔ si kɔkə i kaŋa ŋga i mih bɛiŋ a kɔbi a bə nì nya ŋga biwɔ i wɔ i bɛiŋ. Ayakadəiŋ, kɔm yələ, mi wə wi nya mih i wɔ kaŋ, kaŋaki lə chu bi kpali tsə mbia.” ");
INSERT INTO cug_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Si Baylɛ wɔkɔ ndzaka wələ, ka yisi i nəŋki dzəh i yatɔkɔ wi. Ayakalə, Bəju wam bəh ŋga a, “Wɔ ka mɔm i bee mi wələ, yi numki a wɔ kɔkə nsɛiŋ wi Kaysa ŋkuŋ wimbum wi Lum. Na ndə wə wi fə gwu yi a ŋgaiŋ kɔ ŋkuŋ wi kɔ baiŋŋni wi Kaysa.” ");
INSERT INTO cug_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jɔbi wə Baylɛ chu wɔkɔ ndzaka wiwɔ, ka buku bəh Jisɔs i biŋ, shinum i kiŋgbɔkɔ ki nsaka wə kə bə nì bɔɔŋki a Di biə bə maa bəh Kitəh, num i já yi Hibulu wə a Gabata. ");
INSERT INTO cug_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A nì kɔ Chɔkɔ bi Nsisi bi Dzini bi Ntsədaŋ, jɔbi nì kɔ aka mbiəŋə jwɔfi ntsɔ bəfa nshifɔkɔ. Baylɛ dzaka i Bəju a, “Mbɛiŋ yɛ̂iŋ bə ŋkuŋ wimbɛiŋ lə!” ");
INSERT INTO cug_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bəju bəwɔ wamyi a, “Nyə̂ bəh wi, nyə̂ bəh wi, bâŋŋ wi i kintasi wə!” Baylɛ bikə i bɔ a, “Mih baŋŋ ŋkuŋ wimbɛiŋ i kintasi wə a?” Bətii mfə gia bəmbum chukuli i wi a, “Buku kaŋaki kə ŋkuŋ widɔkɔ a kɔbi a Kaysa.” ");
INSERT INTO cug_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Baylɛ ka nya Jisɔs i bɔ a bɔ tsə̂ bâŋŋ i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Bɔ ka dzɔ Jisɔs, buku bəh wi. Wi giŋ kintasi ki ka tsəki i di biə bə nì bɔɔŋki a Ŋkuŋu Kifwu, yi num i já yi Hibulu wə a Gɔlgɔta. ");
INSERT INTO cug_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Bɔ ka tsə baŋŋ wi fɛiŋ i kintasi wə, baŋŋ tasi bəh bəni bədɔkɔ bəfa i bintasi wə, widɔkɔ i tsɛiŋ yiləkəli wə, widɔkɔ i tsɛiŋ yi kimiəkə wə, Jisɔs num i fintəŋ. ");
INSERT INTO cug_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Baylɛ bɔŋ nyaka gia yidɔkɔ ka baŋŋ i kintasi ki Jisɔs wə. Gia yə wi nì nyaka yɛiŋ nì kɔ a, “Jisɔs wi Nasali, Ŋkuŋ wi Bəju.” ");
INSERT INTO cug_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Bəju bəduli fa gia yə wi nyaka yɛiŋ, kɔm di biə bɔ nì baŋŋ Jisɔs i kintasi wə nì kɔ kɔmsi tsə i kwili wə, wi nì nyaka gia yələ i já yi Hibulu wə bəh yi Latin wə bəh yi Glik wə. ");
INSERT INTO cug_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Bətii mfə gia bəmbum bə Bəju tsə dzaka i Baylɛ a, “Kiə wɔ ki nyâka kə a, ‘Ŋkuŋ wi Bəju.’ Nyâka a, ‘Mi wələ dzaka a ŋgaiŋ kɔ ŋkuŋ wi Bəju.’” ");
INSERT INTO cug_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Baylɛ chukuli i bɔ a, “Gia yə mih kɔ mih nyaka mih nyaka lɔ.” ");
INSERT INTO cug_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jɔbi wə bəni bə jum nì baŋŋ Jisɔs i kintasi wə, bɔ ka dzɔ bəmbuŋ bu gaa i bidi binaa wə ayaka di bimu num i mi wi jum wimu. Bɔ dzɔ tə mbuŋ wi nimbɛiŋ. Ayakalə, mbuŋ wələ nì kɔ num bə nì tum wi wiyamni i yisi i məkə wə i shi buku i gvu wə. ");
INSERT INTO cug_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ayakadəiŋ, bɔ ka dzaka a bɔ bɔ a, “Kiə bukumbɛiŋ ki tâŋa kə mbuŋ wələ. Bukumbɛiŋ tâ shaŋ bəh wi, bə yɛiŋ mi wə wi ki kwatiki mbuŋ wiwɔ.” Gia yələ nì num i fə a yi dzə̂ kpɛ̂iŋ asi bə nì nyaka i Kiŋwakti ki Nyɔ wə a, “Bɔ nì gaa bəmbuŋ bəŋ a bɔ bɔ, ka ta shaŋ bəh mbuŋ wuŋ.” Ayakadəiŋ, yələ kɔ gia yə bəni bə jum bəwɔ nì fə lə. ");
INSERT INTO cug_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bəkaŋa bədɔkɔ nì num bɛiŋ kɔmsi fɛiŋ i kintasi ki Jisɔs wə. Bəkaŋa bələ nì kɔ nih Jisɔs bəh waiŋnih nih Jisɔs bəh Meli wə kpə Klɔbas bəh Meli Magdalen. ");
INSERT INTO cug_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Asi Jisɔs dzaka a wi tsɛiŋ ka yɛiŋ nih wi bəh waiŋ wi wi mbaŋ wə wi nì kɔŋki num bɔ num kɔmsi i wi kpəŋ i bɛiŋ, wi dzaka i nih wi a, “Miŋkpaŋa, tsɛ̂iŋ, fa si num waiŋ wa.” ");
INSERT INTO cug_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Si wi dzaka yakadəiŋ fiəni dzaka tə i waiŋ wi wi mbaŋ wə a, “Tsɛ̂iŋ, fa si num nih wa.” I yisi i jɔbi wiwɔ wə waiŋ wi wi mbaŋ wiwɔ ka dzɔ nih Jisɔs bɔ wi tsə ka nɔki i wi dzu. ");
INSERT INTO cug_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Si yəmaka nì tsə, si Jisɔs nì kɔ wi si kiə lɔ a gia yichi kaa, i fə a yi dzə kpɛiŋ asi bə nì nyaka i Kiŋwakti ki Nyɔ wə, ka dza dzaka a, “Kindɔŋ wɔmki lə mih.” ");
INSERT INTO cug_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kilɛti kidɔkɔ nì kɔ fɛiŋ bəh mbih migbaŋlini yɛiŋ num mɔ jikə i yɛiŋ mə. Bəni bə jum bəwɔ ka juli kuncha yɛiŋ ka bwaŋ i kpɛiŋ wi yisɔp wə ka bwaŋ ləkə tsə i dzaka ki wə. ");
INSERT INTO cug_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jɔbi wə Jisɔs nì dzɔ mbih miwɔ ka dzaka a, “Yi kaa lɔ.” Si wi dzaka yakadəiŋ, chuŋsi fwu wi, kiŋ'waka ki kaa. ");
INSERT INTO cug_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Si chɔkɔ biwɔ nì kɔ a chu num Chɔkɔ bi Kɛiŋsini gwu i nya i chɔkɔ bimbam wə, Bəju nì nəŋki i fə a biwini biwɔ ma bâaŋ i bintasi wə i chɔkɔ bimbam wə, (kighə si bimbam biwɔ nì kɔ bi mbum). Bɔ ka tsə yɛiŋ Baylɛ ka tsa wi dzaka a bɔ tsə̂ bwîŋyi kaka bi bəni bə̀ bɔ nì kɔ i bintasi wə ka bɔ kɔmsi kpîyi ka bɔ shîsi, dzɔ̂ bwîli bɔ. ");
INSERT INTO cug_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ayakadəiŋ, bəni bə jum bə̀ ka bwiŋyi kaka bi mi wi ninshiŋ wə, ka bwiŋyi tə widɔkɔ wə bə nì baŋŋ bəh wi. ");
INSERT INTO cug_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ayakalə, jɔbi wə bɔ nì dzə buku i Jisɔs wə, yɛiŋ num wi si kpi lɔ, bɔ nəki chu bwiŋyi kə kaka bi. ");
INSERT INTO cug_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mi widɔkɔ i mbaŋ wi bəni bə jum wə bwaŋ biəli yi Jisɔs bəh gɔŋ. Si wi bwaŋ yaka, akisəkə mwa bəh mwi tumbuku fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mi wə wi nì yɛiŋ gia yələ kɔ num wi mbeeŋ nsaka wiwɔ, ayaka ndzaka wiwɔ num ŋkɔŋ, wi kiə a ŋgaiŋ dzakaki num ŋkɔŋ ka mbɛiŋ kɔ i bûm. ");
INSERT INTO cug_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Gia yələ nì num i fə gia yə bə nì nyaka i Kiŋwakti ki Nyɔ wə dzə̂ kpɛ̂iŋ si bə nyaka a, “A ŋkuŋu ki kimu bi bwiŋ kə.” ");
INSERT INTO cug_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ayaka yi chu num bə nì nyaka i di bidɔkɔ wə i Kiŋwakti ki Nyɔ wə a, “Bəni bi tsɛiŋki lə mi wiwɔ wə bə bwaŋ.” ");
INSERT INTO cug_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Si yəmaka nì tsə Yɔsɛf wi Alimatia nyə tsə yɛiŋ Baylɛ ka tsa a wi bûm a ŋgaiŋ dzɔ̂ bwîli wini wi Jisɔs. Yɔsɛf wələ nì kɔ mi wi mbaŋ wi Jisɔs ayakalə wi num a jum wə jum wə kɔm wi nì lwaki Bəju. Baylɛ bum, wi ka tsə i dzɔ bwili wini wiwɔ. ");
INSERT INTO cug_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikɔdəmus wə wi nì yisi tsə yɛiŋ Jisɔs chɔkɔ bidɔkɔ nchɔkɔ, wi nì tsə tə bəh fiaŋsi bidɔkɔ bi kaŋa tsɛŋə yindzɔŋni num bə chiŋni kɛiŋsi bəh mɛɛl bəh alɔs nji wi ntiə wiwɔ nì kɔ bəkilɔ mbaŋtia ntsɔ yitali. ");
INSERT INTO cug_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Bɔ wi ka tsə dzɔ bwili wini wi Jisɔs wiwɔ ka kii bə bəmbuŋ num bɔ fiaŋsi bəh fiaŋsi biə wi nì dzə bəh bi, asi nləə wi Bəju kɔ i nɔni ki tumi kibɔ wə. ");
INSERT INTO cug_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A nì kɔ khə wi mbaiŋ num kɔmsi tsə i di biə bə nì baŋŋ Jisɔs i kintasi wə. Ayaka khə wiwɔ num yaka jum yimfiaŋ yidɔkɔ num fɛiŋ maka bə num ləə lɔ mi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ayakadəiŋ, si chɔkɔ biwɔ nì kɔ Chɔkɔ bi Bəju bi Sisini wi chɔkɔ Bimbam, ayaka jum yiwɔ num kɔmsi fɛiŋ, bɔ ka jiə Jisɔs yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","A dzə num i chɔkɔ bi ninshiŋ i shi wə, Meli Magdalen buku dza na kinchɔŋɔchɔŋɔ biŋ kɛiŋ bi ji, ka tsə i jum bɛiŋ, yɛiŋ num bə dzasi lɔ təh wə bə nì baŋ dzaka kijum yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ayakadəiŋ, wi ka yɔkɔ tsə yɛiŋ Samɔn Bita bəh waiŋ wi mbaŋ wi Jisɔs widɔkɔ wiwɔ wə Jisɔs nì kɔŋki nalə, ka dzaka i bɔ a, “Bə bwili Bah i jum mə, buku ka kiə dəkə di biə bə nɔsi wi yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bita bəh waiŋ wi mbaŋ wi Jisɔs wə ka buku i tsəki i jum bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bɔ nì tsəki yaka yɔkɔ num yɔkɔni, ayakalə waiŋ wi mbaŋ wi Jisɔs widɔkɔ wiwɔ wə yɔkɔ tsə Bita ka yisi tsə buku i jum bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Si wi tsə buku, ŋgwuŋ shi tsɛiŋ ləkə, ka yɛiŋ shəŋ a bəmbuŋ bə̀, bə nì kii i Jisɔs wə bɔ nɔ fɛiŋ. Si wi tsɛiŋ yakadəiŋ nəki liə kə yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Samɔn Bita biəli wi dzə buku fɛiŋ, ka liə tsə akisəkə i jum yiwɔ kintəəŋ. Si wi liə, yɛiŋ shəŋ a bəmbuŋ bə̀ bɔ nɔ fɛiŋ, ");
INSERT INTO cug_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ayaka kinchumni ki mbuŋ kə bə nì kii fwu wi Jisɔs yɛiŋ nì ka nɔ chiŋni bəh bidɔkɔ bə̀. Ayakalə, num bə lim ka jiə a mbi di wə a kiki. ");
INSERT INTO cug_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Waiŋ mbaŋ wi Jisɔs widɔkɔ wiwɔ wə wi nì yisi tsə buku fɛiŋ ka bɔŋ liə tsə i jum yiwɔ mə yɛiŋ gia yiwɔ ka bum. ");
INSERT INTO cug_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A nì kɔ bɔ kɛiŋ ki kiə kə fwu wi gia yə yi kɔ i Kiŋwakti ki Nyɔ mə a Jisɔs nì kaŋaki lə i dzâ i kpî wə. ");
INSERT INTO cug_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Bwa bə mbaŋ bə Jisɔs bə̀ fiəni kwɛ i kikwili wə. ");
INSERT INTO cug_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ayakalə, Meli ka num baaŋ bɛiŋ i biŋ i jum kpəŋ ka dəki. Si wi nì dəki yaka ka dza ŋgwuŋ shi tsɛiŋ ləkə i jum yiwɔ kintəəŋ, ");
INSERT INTO cug_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","yɛiŋ bəchinda bə Nyɔ bəfa num bɔ lɔh bəmbuŋ bə fukuli num bɔ shinum i di biə bə nì nɔsi wini wi Jisɔs, widɔkɔ nì shinum i di biə fwu wi Jisɔs nì kɔ, widɔkɔ i di biə gvu yi nì kɔ. ");
INSERT INTO cug_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Bəchinda bə Nyɔ bəwɔ bikə i wi a, “Miŋkpaŋa, wɔ dəki nə a?” Wi chukuli a, “Mih dəki kɔm bə giŋ buku bəh Bah wuŋ mih kiə kə di biə bə jiə wi.” ");
INSERT INTO cug_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Si wi dzaka yakadəiŋ, wi bə́ nəŋ i fiəni gwu yi ka yɛiŋ Jisɔs num wi num bɛiŋ. Ayakalə, wi nəki kiə kə a, akɔ Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jisɔs bikə i wi a, “Miŋkpaŋa, wɔ dəki nə a? Wɔ nəŋki num ndə a?” Meli ka kwakaki a, yuwidɔkɔ akɔ mi wə wi tsɛiŋki khə wiwɔ. Wi ka dzaka i wi a, “Tikwili, aka bə́ num a wɔ giŋ nyə bəh wi, wɔ fûku i mih di biə wɔ jiə wi yɛiŋ, ka mih tsə giŋ nyə bəh wi.” ");
INSERT INTO cug_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisɔs dza bɔɔŋ wi a, “Meli.” Wi fiəni gwu bɔɔŋ wi i já yibɔ yi Hibulu wə a, “Labɔni,” yi num a, “Mi wi lanini.” ");
INSERT INTO cug_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisɔs dzaka i wi a, “Ma kâŋa mih, kɔm mih kɛiŋki ki yaka kə i Ba wuŋ wə. Tsə̂ i bwa bə nih bəŋ ma wɔ fûku i bɔ a mih si yaka tsə i Ba wuŋ wə wi num tə Ba wimbɛiŋ, Nyɔ wuŋ num tə Nyɔ wimbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Meli Magdalen ka tsə fuku i bwa bə Jisɔs bə mbaŋ a ŋgaiŋ yɛiŋ Bah, ka fukuki tə i bɔ gia yə wi si dzaka i ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A nì kɔ i fijɔbi a chɔkɔ biwɔ, a num chɔkɔ bi ninshiŋ i shi yiwɔ wə, bwa bə mbaŋ bə Jisɔs num dzu num bɔ baŋ dzaka bifiəŋə, kɔm bɔ nì lwaki Bəju. Jisɔs dza tumbuku i bɔ kintəəŋ, ka bɔni i bɔ a, “Ma kimbɔiŋni nûm bəh mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Si wi bɔni i bɔ yakadəiŋ, ka chusi kaŋ yi bəh biəli yi i bɔ. Bwa bə Jisɔs bə mbaŋ ka numki bəh kinsaŋli nalə si bɔ yɛiŋ Bah. ");
INSERT INTO cug_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisɔs chu fiəni dzaka i bɔ a, “Kimbɔiŋni nûm bəh mbɛiŋ. Si Ba wuŋ nì faaŋ mih, yi kɔ a liŋ si mih ki faaŋki mbɛiŋ i liə.” ");
INSERT INTO cug_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Si wi dzaka yakadəiŋ, ka waka i bɔ wə ka dzaka a, “Mbɛiŋ dzɔ̂ Kiŋ'waka ki Baiŋni. ");
INSERT INTO cug_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mbɛiŋ ka dalinya chu bi mi, ma yi numki a Nyɔ dalinya lɔ wi. Mbɛiŋ baaŋ ki dalinya kə wi, yaka Nyɔ ka dalinya dəkə wi.” ");
INSERT INTO cug_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","A nì kɔ i jɔbi wə Jisɔs nì dzə i bwa bu bə mbaŋ wə, Tɔmɔs wə wi nì kɔ i mbaŋ wi bwa bə Jisɔs bə jwɔfi ntsɔ bəfa wə bə nì bɔɔŋki yɛli wi widɔkɔ a bimaŋsi nì kɔkə dəkə bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Bwa bə mbaŋ bə Jisɔs bədɔkɔ ka dzaka i Tɔmɔs a, “Buku si yɛiŋ Bah.” Ayakalə, Tɔmɔs dzaka mfih i bɔ a, “A kɔbi a mih yɛiŋ lə dzaka ki bali ki mibaiŋ i kaŋ yi wə, ka jiə waiŋkpaŋ wuŋ i dzaka biwɔ wə, jiə tə kaŋ yiŋ i biəli yi wə, mih ma ni lansi bum gia yiwɔ.” ");
INSERT INTO cug_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Shi dzə kpɛiŋ, bwa bə Jisɔs bə mbaŋ chu num i dzu, Tɔmɔs num tə bəh bɔ, dzaka bifiəŋə num bə fah. Ayakalə, Jisɔs dzə tumbuku i bɔ kintəəŋ, ka bɔni i bɔ a, “Kimbɔiŋni nûm bəh mbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Si wi bɔni i bɔ yakadəiŋ, ka dzaka i Tɔmɔs a, “Jîə waiŋkpaŋ wa fa i káŋ yiŋ wə, wɔ yɛiŋ si yi kɔ, ma wɔ chu jîə tə kaŋ ya i biəli yiŋ wə. Ma wɔ ma chu nûmki bəh ŋkaŋyi i bûm.” ");
INSERT INTO cug_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tɔmɔs ka chukuli i Jisɔs a, “Bah wuŋ, bəh Nyɔ wuŋ.” ");
INSERT INTO cug_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisɔs dzaka i wi a, “Wɔ bum i liə kɔm wɔ yɛiŋ i mih wə a? Ndzɔŋni bimbum kɔ i bəni bə̀ bɔ ka yɛiŋ dəkə i mih wə, ayakalə bum mih.” ");
INSERT INTO cug_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisɔs nì kɔ wi fə binchəsi bəduli bə̀ bɔ chusiki ŋga bi Nyɔ i bwa bu bə mbaŋ nshiŋ, maka bə nyaka yi i kiŋwakti kələ mə. ");
INSERT INTO cug_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ayakalə, yələ bə nyaka kɔ i fə̂ a mbɛiŋ bûm a Jisɔs kɔ Kimbwili wə Nyɔ nì kaka, num waiŋ Nyɔ. A mbɛiŋ ka bum yakadəiŋ, mbɛiŋ ni kwati nɔni kə ki bi tsə kaa kə kɔm yɛli wi. ");
INSERT INTO cug_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Si yəmaka nì tsə, Jisɔs chu chusi gwu yi i bwa bu bə mbaŋ i kinchwɔ kimbum ki Tibɛlias kpəŋ. Yələ kɔ dzəh yə yi nì num: ");
INSERT INTO cug_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Samɔn Bita bəh Tɔmɔs wə bə nì bɔɔŋki a bimaŋsi, bəh Natanial wi Kana i kimbu ki Galili wə, bəh bwa bənyuku bə Sɛbide, bəh bwa bə mbaŋ bə Jisɔs bədɔkɔ bəfa nì juŋni kɔ i di bimu wə. ");
INSERT INTO cug_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Samɔn Bita ka dzaka i bɔ a, “Mih laki bwɔkɔ.” Bɔ ka dzaka i wi a, “Bukumbɛiŋ lâa.” Bɔ buku tsə liə i ŋgwuki mə. Ayakalə, bɔ nɔ a bəh tsəŋə nəki kwa kə fiɛŋ. ");
INSERT INTO cug_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Asi chɔkɔ ni wɔɔki dzəki, Jisɔs dzə num i bɛiŋ i kpa wi bɔkɔ wə, bwa bu bə mbaŋ nəki kiə kə a, akɔ Jisɔs. ");
INSERT INTO cug_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisɔs ka bikə i bɔ a, “Bwa mbəŋ, mbɛiŋ kwa alə bwɔkɔ a?” Bɔ chukuli a, “Aayi.” ");
INSERT INTO cug_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Wi dzaka i bɔ a, “Mbɛiŋ tûm gbi i kimbu ki tsɛiŋ yiləkəli yi ŋgwuki wə ma mbɛiŋ kwa fiɛŋ.” Bɔ ka tum, si bɔ tum, wi gbi bə́ gaka bɔ i guku bwili, kɔm bə bwɔkɔ yiduli yə yi nì kɔ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Waiŋ wi mbaŋ wi Jisɔs wə Jisɔs nì kɔŋki ka yɛiŋ yakadəiŋ ka dzaka i Bita a, “Akɔ Bah.” Si Samɔn Bita wɔkɔ a, akɔ Bah, ka lɔh bəmbuŋ i gwu wə kɔm wi nì kɔ a bəh gwu yiyəə. Si wi lɔ yakadəiŋ ka jiŋ shi i bɔkɔ ka bə́ tsəki i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Bwa bə mbaŋ bədɔkɔ bə̀ ka biəli wi i ŋgwuki mə ka gukuki gbi wiwɔ num wi jikə bəh bwɔkɔ. A nì dəŋəki kə i buku tsə i kpa. A nì baaŋ aka bəntəm mbaŋshi. ");
INSERT INTO cug_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Jɔbi wə bɔ nì tsə buku i kpa yɛiŋ bikaa bigbuku gbuku ghəkə yɛiŋ, bwɔkɔ num yɛiŋ, blɛd num tə yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisɔs dzaka i bɔ a, “Mbɛiŋ dzə̂ bəh bwɔkɔ yidɔkɔ yə mbɛiŋ kwa.” ");
INSERT INTO cug_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ayakadəiŋ, Samɔn Bita tsə yaka liə i ŋgwuki mə, ka guku bwili gbi wiwɔ i kpa num wi jikə bəh bifaaŋ bi bwɔkɔ gbi bəh mbaŋshi ntsɔ yitali (153). Na si yi nì duki yakadəiŋ lə, gbi wiwɔ nì ka təiŋyi dəkə. ");
INSERT INTO cug_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisɔs ka dzaka i bɔ a, “Mbɛiŋ dzə̂ dzî.” Na mi wimu i bwa bu bə mbaŋ wə nì ka mɔm na i bikə i wi a, akɔ wɔ ndə a? Kɔm bɔ nì kɔ num bɔ kiə a, akɔ Bah. ");
INSERT INTO cug_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisɔs ka tsə dzɔ blɛd wə nya i bɔ, bəh bwɔ́kɔ yə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yələ nì kɔ kiŋkani kitali si Jisɔs nì kɔ num wi chusi gwu yi i bwa bu bə mbaŋ si wi nì dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jɔbi wə bɔ nì dzi kaasi, Jisɔs bɔɔŋ Bita bikə i wi a, “Samɔn waiŋ Jɔn, wɔ kɔŋki lə mih tsə bədɔkɔ bələ a?” Wi chukuli a, “Aaŋ Bah, wɔ kiəki lə a mih kɔŋki lə wɔ.” Jisɔs dzaka i wi a, “Wɔ sâŋ bwa bəŋ bə shwáŋ.” ");
INSERT INTO cug_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jisɔs chu bɔɔŋ wi i kiŋkani kifa wə bikə i wi a, “Samɔn waiŋ Jɔn, wɔ kɔŋki alə mih a?” Wi chukuli a, “Aaŋ Bah, wɔ kiəki lə a mih kɔŋki lə wɔ.” Wi ka dzaka i wi a, “Wɔ tɔ̂kniki bəh shwáŋ yiŋ.” ");
INSERT INTO cug_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisɔs chu bɔɔŋ wi i kiŋkani ki kitali wə bikə i wi a, “Samɔn waiŋ Jɔn, wɔ kɔŋki alə mih a?” Si Bita wɔkɔ Jisɔs bikə i wi i kiŋkani ki kitali wə yakadəiŋ, a wi kɔŋki lə ŋgaiŋ na, yi nya ŋgəkə i wi. Wi dzaka i Jisɔs a, “Bah, wɔ kiəki lə gia yichi, wɔ kiə a mih kɔŋki lə wɔ.” Jisɔs ka dzaka i wi a, “Wɔ sâŋ shwáŋ yiŋ. ");
INSERT INTO cug_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mih fukuki ŋkɔŋ i wɔ a, jɔbi wə wɔ nì kɛiŋki waiŋ sumi, a nì shiki lɔɔki wɔ mbuŋ wa wɔ tsə na faiŋ wə wɔ kɔŋki. Ayakalə, jɔbi wə wɔ ni jwiŋ wɔ ni giŋsiki tsɛiŋ ya i bɛiŋ mi widɔkɔ chi chi lɔh mbuŋ wa, wi dzɔ tsə bəh wɔ i di biə wɔ kɔŋki kə i tsə.” ");
INSERT INTO cug_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisɔs nì dzakaki yələ i chusi kaiŋni yi kpi yə Bita ni kaŋaki i bi dzə kpi, yi dzə bəh yɛli wimbum i Nyɔ. Si Jisɔs dzaka yakadəiŋ ka dzaka i wi a, “Wɔ bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bita bə́ nəŋ i fiəni gwu yɛiŋ a waiŋ wi mbaŋ wə Jisɔs nì kɔŋki wi biəli bɔ. Waiŋ wi mbaŋ wələ kɔ wə wi nì num yəkəli i Jisɔs wə i jɔbi wə bɔ nì dziki i fijɔbi wi gɔksini wə wi bikə i wi a, “Bah, akɔ ndə wə wi nəŋki i ni taŋni wɔ a?” ");
INSERT INTO cug_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jɔbi wə Bita yɛiŋ waiŋ wi mbaŋ wiwɔ biəli bɔ, wi bikə i Jisɔs a, “Bah, yi mi wələ kɔ a nə a?” ");
INSERT INTO cug_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisɔs chukuli i wi a, “A kabə num a mih nəŋki a wi bâaŋ wiwɔm i tsə̂ bûku jɔbi wə mih bi fiəni dzəki, yəmaka kaŋaki nə i fə bəh wɔ a? Wɔ bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Si Jisɔs dzaka yakadəiŋ, ndzaka wiwɔ ka nyani i kintəəŋ ki bəni bə bumni wə, a waiŋ wi mbaŋ wi Jisɔs wələ bi kpi kə. Ayakalə, Jisɔs nì ka dzaka dəkə lɔ a wi bi kpi kə. Wi nì dzaka shəŋ a, “A kabə num a mih nəŋki a wi bâaŋ wiwɔm i tsə̂ bûku jɔbi wə mih bi fiəni dzəki, yəmaka kaŋaki nə i fə bəh wɔ.” ");
INSERT INTO cug_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Waiŋ wi mbaŋ wələ kɔ wə wi dzakaki kɔm gia yələ, a chu num wi wə wi nyaka gia yələ, ayaka buku kiə a gia yə wi dzakaki kɔ yi ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Gia yiduli yidɔkɔ kɔlə tə yə Jisɔs nì fə, a nì kɔ a bə nyakaki gia yiwɔ yichi, ma mih yɛiŋki a di kɔkə i fa mbi wələ wə wichi bə kɔ i jiə biŋwakti biwɔ yɛiŋ.");
INSERT INTO cug_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tikwili Teɔfilus, i kiŋwakti ki ninshiŋ kə mih nì nyaka i wɔ, mih nì nyaka yɛiŋ kɔm gia yichi yə Jisɔs nì fəki bəh yə wi nì laniki bəni yɛiŋ, i kin'yisi wə si wi nì yisi nɔm wi, ");
INSERT INTO cug_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","i tsə buku chɔkɔ biə Nyɔ nì dzɔ wi i bɛiŋ. Ka Nyɔ dzɔ wi wi yaka i bɛiŋ, wi nì tsə dzəh i ŋga bi Kiŋ'waka ki Baiŋni wə, i təfi bwa bu bə ntum bə̀ wi nì sabibwili. ");
INSERT INTO cug_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jɔbi wə wi nì dza i kpi wə, wi nì chusi gwu yi i bɔ i kaŋ wə mbaŋnyani i dzə́h yiduli yiduli wə, yi chusi a wi kɔ wiwɔm. Wi ka chu dzakaki i bɔ kɔm ŋkuŋ bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Si wi nì kɔ bəh bɔ yakadəiŋ, wi dzaka i bɔ a, “Kiə mbɛiŋ bi bûku kə i Jɛlusalɛm. Mbɛiŋ wɔ̂kɔliki kinya kə Ba wuŋ nì kaka i mbɛiŋ num yə mbɛiŋ nì wɔkɔ mih dzaka kɔm yi. ");
INSERT INTO cug_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Mbɛiŋ kiəki a Jɔn nì juliki bəni i bɔkɔ mə, ayakalə i kaŋ yidɔkɔ wə twɛsi Nyɔ ni juliki mbɛiŋ num i kaŋ yi Kiŋ'waka ki Baiŋni wə.” ");
INSERT INTO cug_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jisɔs bəh bwa bu bə ntum juŋni dzə num i jɔbi widɔkɔ wə, bɔ bikə i wi a, “Bah, jɔbi kpɛiŋ lɔ ka wɔ fə bəni bəbuku bə Islae fîəni sâkaki ntɔŋ wibɔ a?” ");
INSERT INTO cug_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Wi chukuli i bɔ a, “Jɔbi wiwɔ nabə chɔkɔ biwɔ bi kpɛiŋki num asi Ba wuŋ kɛiŋsi bəh ŋga bi, yi kɔkə i mbɛiŋ i bi kiə jɔbi wiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gia yə mbɛiŋ kaŋaki i kiəki kɔ a Kiŋ'waka ki Baiŋni bi dzə jiksiki lə mbɛiŋ, ma mbɛiŋ bi kwati ŋga, mbɛiŋ yisi i fukuki kɔm mih i Jɛlusalɛm bəh bimbu bi Judea bəh bi Samalia wə bichi, i tsə buku i bimbu bi mbi binaa wə.” ");
INSERT INTO cug_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Asi wi dzaka yaka, Nyɔ dzɔ wi, wi dza ka yakaki i bɛiŋ bɔ bwaŋ dzə́kəh ka tsɛiŋki si wi yakaki tsəki i bɛiŋ, wi yaka tsə bikwu baŋ wi, wi laka i dzə́kəh yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Si bɔ nì bwaŋ dzə́kəh yibɔ bɛiŋ i tsɛiŋki si wi yakaki tsəki, yi dzə num a, bənyuku bədɔkɔ bəfa dza tumbuku i bɔ nshiŋ num kɔmsi i bɔ wə num bɔ tum bəmbuŋ bə fukuli i gwu wə, ");
INSERT INTO cug_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","bikə i bɔ a, “Bənyuku bə Galili, mbɛiŋ num ka tsɛiŋki nə i bɛiŋ na? Jisɔs wələ Nyɔ dzɔ i mbɛiŋ kintəəŋ lə, wi yaka i bɛiŋ, wi bi fiəni dzə a liŋ asi mbɛiŋ si yɛiŋ wi yaka i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Bwa bə faaŋni bə Jisɔs ka dza i ŋkwuŋ wə bə bɔɔŋki a wi Kɛiŋ yi Ɔlif ka fiəni tsəki i Jɛlusalɛm, a nì kɔ aka kiŋka ki may i tsə buku fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Si bɔ liə fɛiŋ, ka yaka tsə i kimbu ki lum wi juŋ yi bɛiŋ wə bɔ nì tsəki shiki yɛiŋ. Bəni bələ nì kɔ Bita, Jɔn, Jɛm bəh Andulu, Filib bəh Tɔmɔs, Batɔlɔmu bəh Matiɔ, Jɛm waiŋ Alfiyus, Samɔn wə wi nì kɔ mi wi mbaŋ wi Bədzɛlɔt bəh Judas waiŋ Jɛm. ");
INSERT INTO cug_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Bɔ bəh bəkaŋa bədɔkɔ bəh Meli nih Jisɔs bəh bwa bə nih Jisɔs nì fəki bɔ juŋni i fiɛŋ fimu wə i tsaki jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A nì kɔ i kaŋ yə wə, bwa bə mbaŋ bə Jisɔs juŋni. Bɔ nì kɔ fɛiŋ ka bəni gbi ntsɔ mbaŋfia (120). Bita dza bɛiŋ dzaka i bɔ a, ");
INSERT INTO cug_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Bwa bə nih bəŋ, gia yə Kiŋwakti ki Nyɔ dzakaki nì kaŋaki lə i dzə kpɛiŋ. Akɔ gia yə Kiŋ'waka ki Baiŋni nì fə Dɛbit dzaka, a kɛiŋ i kikpu wə kɔm Judas wə wi nì num i ninshiŋ ka bə dzə kwa Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Mbɛiŋ kiə a Judas wələ nì kɔ mi widɔkɔ i mbaŋ wibuku wə, wi kaŋa nɔm wi i bukumbɛiŋ kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Ka Bita dzakaki yaka num Judas dzɔ lɔ kpɔ wə bɔ nì nya i wi i gia yichu yə wi nì mɔm ka taŋ di bidɔkɔ yɛiŋ. Di biələ kɔ biə wi nì gbɔ yɛiŋ bəh fwu tɔɔ wi tɔ bilaa buku bichi. ");
INSERT INTO cug_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Bəni bə Jɛlusalɛm bəchi wɔkɔ, ka bɔɔŋki di biwɔ i já yibɔ wə a Akɛldema, yi num a, “Di bi Mwa.”). ");
INSERT INTO cug_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Bita chu dzaka a, “Dɛbit nì nyaka i Kiŋwakti ki Ŋkɔksi wə a, ‘Bə bêe ma kwili wi fîəni chû chi, ka mi ma chu nɔ fɛiŋ.’ Yi kɔ wi chu nyaka a, ‘Mi widɔkɔ kaŋaki i dzɔ̂ di bi bi nɔm.’ ");
INSERT INTO cug_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Si yi kɔ yaka, mi widɔkɔ kaŋaki i chîŋni i buku wə, ma buku bɔ fûkuki a Bah Jisɔs nì dza i kpi wə. Mi wiwɔ kɔ i num mi wə wi ni nyaniki buku bɔ jɔbi wichi asi Jisɔs nì nyaniki buku bɔ i yisi i jɔbi wə Jɔn nì juliki bəni i bɔkɔ mə, i tsə buku i jɔbi wə Nyɔ nì dzɔ Jisɔs i buku kintəəŋ wi yaka i bɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Si wi dzaka yaka, bɔ baayi jiə bəni bəfa. Wimu nì kɔ Yɔsɛf wə bə nì bɔɔŋki a Basabas bə chu bɔɔŋ tə a Justus, widɔkɔ num Matias. ");
INSERT INTO cug_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Si bɔ baayi jiə yaka, ka tsa a, “Bah, wɔ kiəki lə shɔ́m yi bəni bəchi. Ayakadəiŋ, chûsi i buku mi wə wɔ kɔ wɔ saiŋbwili i kintəəŋ ki bəni bəfa bələ, ");
INSERT INTO cug_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ayakadəiŋ, ka wi nûm waiŋ ntum wi Jisɔs, wə wi ni dzɔ di bi nɔm biə Judas nì bee ka tsə i di bi wə.” ");
INSERT INTO cug_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Si bɔ tsa yakadəiŋ, ka nyaka kiyɛli kibɔ, ka tum, wi Matias ka buku gbɔ. Bɔ ka kpɛiŋsi wi i mbaŋ wi bwa bə ntum bə Jisɔs bə̀ jwɔfi ntsɔ mu. ");
INSERT INTO cug_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Jɔbi wi Dzini biə bɔ nì bɔɔŋki a Bɛntekɔs nì dzə kpɛiŋ, bəni bəchi bə̀ bɔ nì kɔ bɔ jiə shɔ́m i Jisɔs wə nì juŋni i di bimu wə. ");
INSERT INTO cug_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Bɔ ka təkəli wɔkɔ fiɛŋ fi jumi shi dzə i bɛiŋ aka fiəkə yiləkəli. Fi shi liə jiksi juŋ yichi yə bɔ nì kɔ yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Bɔ dzaka a bɔ tsɛiŋ, bɔ yɛiŋ fiɛŋ fidɔkɔ fi num aka kilɔm kigbuku, fi ka waŋ tsə i bɔ wə mi wimu wimu. ");
INSERT INTO cug_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kiŋ'waka ki Baiŋni ka jikə i bɔ bəchi wə, fə bɔ ka dzakaki já yi tumi chi chi. ");
INSERT INTO cug_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","A nì kɔ i jɔbi wiwɔ wə, Bəju bə̀ bɔ nì kɔ bɔ jiə shɔm i Nyɔ wə nalə bɔ num i Jɛlusalɛm, num bɔ dza i bitumi bichi biə bi kɔ fa nshwaiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Si bɔ wɔkɔ yakadəiŋ, ka juŋni dzə bɔ bəduli i bəni bə̀ bɔ nì kɔ bɔ jiə shɔm i Jisɔs wə. Bəni bə̀ bɔ nì jiə shɔ́m i Jisɔs ka dzakayiki, na winaiŋ mi wɔkɔ i já yibɔ wə. Yi fumsi bɔ. ");
INSERT INTO cug_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Dzaka wɔm bɔ, bɔ ka kaiŋyiki, dzakayi a, “Ntə bəni bələ bəchi bɔ dzakaki lə, akɔ num bəni bə Galili a? ");
INSERT INTO cug_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yi nyani dəiŋ a mi i bukumbɛiŋ wɔkɔki si bɔ dzakaki i já yi tumi bibukumbɛiŋ wə a? ");
INSERT INTO cug_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Buku bədɔkɔ buku i Batia, bədɔkɔ buku i Mɛdes bəh i Ɛlam, bədɔkɔ buku i Misɔbɔtɛmia bəh i Judea bəh i Kafadɔsia, bədɔkɔ buku i Bɔntus bəh i Ɛsia. ");
INSERT INTO cug_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Buku bədɔkɔ buku i Fligia bədɔkɔ i Bamfilia, bədɔkɔ i Ijib bəh i bimbu bi Libia wə, bə̀ bɔ kɔ kɔmsi i kwili wi Sɛlin wə. Buku bədɔkɔ buku i Lum, a num Bəju bəh bəni bə̀ bɔ kwuni kwunini ka numki i mbum wi Bəju wə. ");
INSERT INTO cug_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Buku bədɔkɔ buku i Klɛt bəh i Alɛbia. Buku wɔkɔki lə, i já yi tumi kibukumbɛiŋ wə si bəni bələ dzakaki gia yi kaŋyini yə Nyɔ fə.” ");
INSERT INTO cug_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Dzaka wɔm bɔ, bɔ ka kaiŋki a bɔ bɔ a yələ gia chusiki a nə. ");
INSERT INTO cug_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bəni bədɔkɔ ka nyiksiki lɔ fibɔ dzaka a, “Bəni bələ kɔ mbih kwa bɔ.” ");
INSERT INTO cug_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ayakadəiŋ, Bita ka dza num i bɛiŋ bəh bwa bə ntum bə Jisɔs bə jwɔfi ntsɔ mu. Bita ka yisi ka dzaka i mbaŋ wi bəni wə bəh ŋga a, “Mbɛiŋ Bəju bəh bəni bəchi bə̀ bɔ nɔki i Jɛlusalɛm, mih nəŋki a mbɛiŋ kîə gia yələ. Mbɛiŋ nyâ bintuni bimbɛiŋ i gia yə mih ki dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mbih ka kwa dəkə bəni bələ si mbɛiŋ kwakaki. I liə kɛiŋki a mbiəŋə bwukə i kinchɔŋɔchɔŋɔ. ");
INSERT INTO cug_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gia yələ yi numki i liə akɔ yə Juɛl mi wi ntum wi Nyɔ nì dzaka lɔ a, ");
INSERT INTO cug_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Nyɔ dzakaki a, a bi numki i chɔkɔ bi gɔksini wə, ma ŋgaiŋ bi shuku Kiŋ'waka ki i bəni bəchi wə. Ayakadəiŋ, bwa bəmbɛiŋ bənyuku bəh bəkaŋa bi wɔkɔki lə gia yə ŋgaiŋ dzakaki, fuku i bəni, sumi yimbɛiŋ bi yɛiŋki lə fiɛŋ aka dəmsi, ma dəmsi bi kwaki bəni bəkukuli bəmbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A bi numki i chɔkɔ biwɔ wə, ma ŋgaiŋ bi shuku Kiŋ'waka ki i bəni bu bə nɔm wə bəchi, bənyuku bəh bəkaŋa, bɔ bi wɔkɔki gia yə ŋgaiŋ dzakaki, bɔ fuku i bəni. ");
INSERT INTO cug_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ŋgaiŋ bi fə lə gia yi dzaka ki wɔmni i bɛiŋ, ma ŋgaiŋ bi fiəni fə tə kinchəsi kə ki chusiki ŋga bi i kuku. Mwa bəh gbuku bəh fimiəkə figumini bi num lə. ");
INSERT INTO cug_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wɔŋ bi ji lə, fiəŋŋ bi bɔkɔki aka mwa, ka chɔkɔ bimbum bi Bah bi kaiŋni bi dzə. ");
INSERT INTO cug_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ayakadəiŋ, na ndə wə wi bi bɔɔŋki yɛli wi Bah, bi bɔiŋki lə.’” ");
INSERT INTO cug_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bita chu dzaka a, “Bəni bə Islae, mbɛiŋ wɔkɔli ndzɔŋ gia yə mih dzakaki. Jisɔs wi Nasali nì kɔ mi wə Nyɔ nì lansi chusi i mbɛiŋ a, a faaŋ ŋgaiŋ wi asi wi nì fə Jisɔs a wi fəki binchəsi biə bi chusiki ŋga bi Nyɔ bəh gia yi dzaka ki wɔmni bəh yi kaŋyini yə Nyɔ nì fə i mbɛiŋ kintəəŋ. Mbɛiŋ kiəki lə na gia yiwɔ bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jisɔs wələ kɔ mi wə bə nì nya wi i mbɛiŋ, akɔ Nyɔ wə wi nì fasi, ka yi numki yaka num wi si kiə lɔ. Mbɛiŋ nì wɔɔ wi si mbɛiŋ nì nya wi i kaŋ yi bəni bəchu wə, bɔ baŋŋ wi i kintasi wə. ");
INSERT INTO cug_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ayakalə, Nyɔ fiəni dzasi wi i kpi wə, bwili wi i kaŋ yi kpi wə kɔm kpi nì kaŋaki kə i kaŋa baaŋ bəh wi. ");
INSERT INTO cug_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Dɛbit nì kɔ wi dzaka kɔm Jisɔs wələ a, ‘Mih yɛiŋki lə Bah wə wi kɔ buku wi jɔbi wichi i tsɛiŋ yiŋ yiləkəli wə, ka gia yidɔkɔ ma kɔm mih. ");
INSERT INTO cug_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ayakadəiŋ, shɔm yiŋ wɔkɔki lə ndzɔŋni, mih dzakaki bəh kinsaŋli. Na si mih kaŋaki i kpi, ayakalə mih tsɛiŋki tsəki a ninshiŋ, ");
INSERT INTO cug_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","kɔm wɔ Nyɔ kɔkə ni bee kiŋ'waka kəŋŋ i tumi ki bəni bəkpili wə. Ayaka wɔ kɔbi i ni bee a Waiŋ wa wi nɔm wi Baiŋni, fɔɔ i jum kintəəŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wɔ fə mih kiə dzəh yə mih kɔ i tsə yɛiŋ i kwati nɔni. Si mih ni numki i wɔ nshiŋ wɔ ni jiksi mih bəh kinsaŋli.” ");
INSERT INTO cug_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Bita chu dzaka a, “Bwa bə nih bəŋ, mih kɔlə i dzaka i mbɛiŋ məŋ kə a tii tii wibukumbɛiŋ ŋkuŋ Dɛbit nì kpi, bə ləə wi, jum yi kɔlə fa i dzə buku bidaiŋ. ");
INSERT INTO cug_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wi nì kɔ mi wi ntum wi Nyɔ ayaka wi chu kiə kiŋkaka kə Nyɔ nì kaka i wi bəh ŋkaiŋ, a ŋgaiŋ bi tɔm lə Waiŋ i chwɔŋ ki ki juŋ wə i kiŋgbɔkɔ ki bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wi ka kɔmsi yɛiŋ gia yə Nyɔ nì kɔ i fə, wi ka dzaka a Kimbwili wə Nyɔ nì kaka bi dza lə i kpi wə. Akɔ gia yə wi nì dzaka a, ‘Wi nì ka baaŋ dəkə i tumi ki bəni bəkpili wə, gwu yi nì ka fɔɔ dəkə i jum kintəəŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jisɔs wələ nì kɔ num Nyɔ nì dzasi wi i kpi wə, buku bəchi bə buku kɔ bəni bu bə mbaŋ nì yɛiŋ yi bəh dzə́kəh. ");
INSERT INTO cug_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyɔ dzasi lɔ wi ka tɔm wi i tsɛiŋ yi yiləkəli wə, nya Kiŋ'waka ki Baiŋni i wi asi wi nì kaka. Gia yə mbɛiŋ yɛiŋki chu wɔkɔ i liə kɔ Kiŋ'waka kiwɔ si Jisɔs nya i buku. ");
INSERT INTO cug_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","A nì kɔkə dəkə Dɛbit wə wi nì yaka i bɛiŋ. Dɛbit mwi nì kɔ wi dzaka a, ‘Bah Nyɔ nì kɔ wi dzaka i Ba wuŋ a, nûm i tsɛiŋ yiŋ yiləkəli wə, ");
INSERT INTO cug_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","i tsə̂ bûku jɔbi wə mih bi nɔsi bəni bə̀ bɔ baiŋŋki wɔ i wɔ nshiŋ, ma wɔ tɔ̂myi gvu ya i bɔ bɛiŋ ka kiŋgbɔkɔ ka kigvu.’ ");
INSERT INTO cug_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ayakadəiŋ, mbɛiŋ bəni bə Islae bəchi ma mbɛiŋ kîə bindzɔŋ a Jisɔs wələ mbɛiŋ nì baŋŋ i kintasi wə akɔ wi wə Nyɔ jiə a wi nûmki Bah chu nûm Kimbwili wə wi nì kaka.” ");
INSERT INTO cug_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Si bəni bəwɔ nì wɔkɔ yakadəiŋ, shɔm təiŋ bɔ. Bɔ ka bikə i Bita bəh bwa bə ntum bə Jisɔs bədɔkɔ a, “Bwa bə nih bəbuku, buku ki fə̂ki dəiŋ i liə a?” ");
INSERT INTO cug_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bita chukuli i bɔ a, “Mi wimu wimu i mbɛiŋ kintəəŋ kwûni shɔm yi, ma bə juli wi i bɔkɔ i yɛli wi Jisɔs Klistus wə, ka Nyɔ dalinya chu bi wi nya tə kinya kə ki kɔ Kiŋ'waka ki Baiŋni. ");
INSERT INTO cug_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kiŋkaka kələ kɔ i mbɛiŋ wə, bəh i bwa bəmbɛiŋ wə, chu num i bəni bəchi bə̀ bɔ kɔ i dzəh yi dəəŋ. Wi kɔ i bəni bəchi bə̀ Bah Nyɔ wibuku bɔɔŋki bɔ dzə i wi wə.” ");
INSERT INTO cug_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bita chu dzaka gia yiduli, təfi bɔ, tsa a bɔ gamti gwú yibɔ i ŋgəkə wə wi dzəki i ŋgɔkɔ wichu wələ wə. ");
INSERT INTO cug_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Bəni wɔkɔ ndzaka wi Bita wiwɔ lə, bəduli bum, bɔ ka juli bɔ i bɔkɔ. Chɔkɔ biwɔ bəni kpɛiŋsi i mbaŋ wibɔ wə, ka bənchuku bətali (3,000). ");
INSERT INTO cug_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Bɔ ka nya shɔm yibɔ i wɔkɔliki gia yə bwa bə ntum bə Jisɔs nì laniki. Bəh bɔ ka numki i kijuŋni wə, gbɛyi blɛd, chu tsa ka kijuŋni. ");
INSERT INTO cug_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bwa bə faaŋni bə Jisɔs ka fəki gia yi dzaka ki wɔmni bəh binchəsi biduli biə bi chusiki ŋga bi Nyɔ, bəni ka yɛiŋki yaka yi gaka bɔ. ");
INSERT INTO cug_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Mbaŋ wi bəni bə bumni bəchi nì kɔ a fiɛŋ fimu, kaŋa biɛiŋ bibɔ a fiɛŋ fimu wə. ");
INSERT INTO cug_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Bɔ nì fəki bɔ taŋni di bibɔ bəh biɛiŋ bibɔ, gaa kpɔ wiwɔ a bɔ bɔ asi ŋgəkə wi mi kɔ. ");
INSERT INTO cug_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bɔ ka shiki juŋniki i juŋ yi fəni yi gia wə kaŋ yichi, chiŋni dzi i juŋ juŋ wə bəh kinsaŋli i shɔm yibɔ wə buku kə bəh dzə́kəh, ");
INSERT INTO cug_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","kɔksi Nyɔ. Bəni bəchi kɔŋ bɔ. Bah ka bwiliki bəni kaŋ yichi, kpɛiŋsi i mbaŋ wibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","A nì kɔ i chɔkɔ bidɔkɔ wə, Bita bəh Jɔn nyə ka yakaki tsəki i juŋ yi fəni yi gia wə jɔbi num mbiəŋə witali nshifɔkɔ, a num i jɔbi wi tsani wə. ");
INSERT INTO cug_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A jɔbi wiwɔ wə bəni nì giŋ mi widɔkɔ ka dzəki bəh wi dzə jiə i kuku i dzaka ki mbaiŋ kə wə bə nì bɔɔŋki a ki Ndzɔŋni ki liə tsə i juŋ yi fəni yi gia mə. Mi wiwɔ num bə nì bwɔ wi kiŋkəni. Bəni shi giŋ wi chɔkɔ bichi dzə jiə fɛiŋ i nywâki kpɔ i bəni bə̀ bɔ tsəki liəki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wi yɛiŋ Bita bəh Jɔn si bɔ dzəki i liə fɛiŋ, ka nywaki kpɔ i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Bɔ lumsi dzə́kəh i wi wə. Bita dzaka i wi a, “Tsɛ̂iŋ buku!” ");
INSERT INTO cug_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Wi ka tsɛiŋ bɔ, kwaka a bɔ ki nyaki lə fiɛŋ i ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bita dzaka i wi a, “Mih lansiki kaŋaki kə kpɔ ayakalə, mih ki nyaki lə wɔ bəh fiɛŋ fiə mih kaŋaki. Mih dzakaki i wɔ, i yɛli wi Jisɔs Klistus wi Nasali wə, dzâ bɛiŋ wɔ nyâniki!” ");
INSERT INTO cug_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Si wi dzaka yakadəiŋ, ka kaŋa wi i wa wi tsɛiŋ yi yiləkəli wə giŋsi wi i bɛiŋ. Akisəkə kaka bi mi wiwɔ bəh mikɔkɔ ka ləkə. ");
INSERT INTO cug_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wi jiŋ num i bɛiŋ, ka yisi i nyaniki. Bəh bɔ ka tsə liə i juŋ yi fəni yi gia mə, wi bə́ nyani fɛiŋ wi jiŋyi, yaksi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Bəni bəchi bə̀ bɔ nì yɛiŋ si wi nyaniki wi yaksi Nyɔ, ");
INSERT INTO cug_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","bɔ kiə a, fa kɔ mi wə wi nì shiki numki wi nywa a nywani i dzaka ki mbaiŋ kə bə nì bɔɔŋki a Ndzɔŋni ki liə tsə i juŋ yi fəni yi gia mə. Dzaka wɔm bɔ, bɔ ka numki bəh ŋkaiŋyi i gia yə yi num i wi. ");
INSERT INTO cug_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mi wiwɔ shu baaŋ i Bita chɛiŋ bəh Jɔn. Bəni yɛiŋ yaka dzaka wɔm bɔ, bɔ ka yɔkɔki tsəki chiŋni i saŋ wi Sɔlɔmɔn wə. ");
INSERT INTO cug_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Bita yɛiŋ si bəni juŋni dzə, wi dzaka i bɔ a, “Bəni bə Islae, akɔ kɔm nə wə dzaka wɔmki mbɛiŋ kɔm gia yələ, mbɛiŋ tsɛiŋki buku lə kɔm nə? Mbɛiŋ kwakaki yimbɛiŋ a, a fə ŋga bibuku ka mi wələ nyaniki a? Ma mbɛiŋ kwakaki yimbɛiŋ a, a fə nɔni kibuku ki baiŋni na? Yi mɔŋ dəkə yakadəiŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yi kɔ a Nyɔ wi Ablaham bəh wi Ayjik bəh wi Yakɔb, wə wi kɔ Nyɔ wi bətii tii bəbukumbɛiŋ bəchi a num wi wə wi nì kɔ num wi yaksi lɔ Jisɔs mi wi wi nɔm jiə i wi kpəŋ. Jisɔs wələ kɔ wə mbɛiŋ nì nəiŋ ka dzɔ nya i bəni bə nsaka, Baylɛ kabə nəŋ i bee wi, ayakalə mbɛiŋ nəiŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jisɔs nì kɔ mi wi baiŋni, chu num chəŋ, mbɛiŋ nəiŋ wi, dzaka a bə bwîli num mi wə wi nì wɔɔyiki bəni, bə nyâ i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mbɛiŋ fə yakadəiŋ ka wɔɔ mi wə wi nì nyaki nɔni i bəni ayakalə, Nyɔ fiəni dzasi wi i kpi wə, buku yɛiŋ wi ka fukuki. ");
INSERT INTO cug_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Akɔ i yɛli wi Jisɔs wələ wə, wi fə ka kiŋkəni kələ mbɛiŋ yɛiŋki lə, mbɛiŋ chu kiə wi, si wi nyaniki. Yi num yaka kɔm buku jiə shɔm i Jisɔs, shɔm yə buku jiə i wi wə, yi fə mi wələ ta na bindzɔŋ asi mbɛiŋ yɛiŋki lə. ");
INSERT INTO cug_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","I liə bwa bə nih bəŋ, mih kiəki lə a gia yə mbɛiŋ bəh kifwu ki kwili nì fə i Jisɔs, mbɛiŋ nì fəki yaka kɔm mbɛiŋ nì kiəki kə. ");
INSERT INTO cug_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Yi nì num i dzəh yələ wə lə i fə̂ a yi dzə̂ kpɛ̂iŋ asi Nyɔ nì kɔ wi fuku lɔ i kikpu wə i dzaka ki bəni bu bə ntum wə a, Kimbwili wə wi nì kaka bi yɛiŋ lə ŋgəkə. ");
INSERT INTO cug_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ayakadəiŋ, mbɛiŋ kwûni shɔ́m yimbɛiŋ mbɛiŋ fîəni chû i wi wə, ka wi dalinya chu bimbɛiŋ, ");
INSERT INTO cug_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ka wi fə shɔ́m yimbɛiŋ dəki, wi bi chiŋsi lə Jisɔs Kimbwili wə wi nì babwili i mbɛ̂iŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jisɔs wələ kaŋaki i bâaŋ bɛiŋ i tsə̂ bûku i jɔbi wə Nyɔ bi kɛiŋsiki biɛiŋ bichi ma bi fiəni chu bimfiaŋ asi wi nì dzaka i dzaka ki bəni bu bə baiŋni bə ntum a kɛiŋ i kikpu wə. ");
INSERT INTO cug_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muses nì kɔ wi dzaka lɔ a, ‘Bah Nyɔ bi bwili lə mi wi ntum widɔkɔ i bwa bə nih bəmbɛiŋ kintəəŋ, ma wi chiŋsi i mbɛiŋ, asi wi nì bwili mih, ayaka mbɛiŋ kaŋaki i wɔ̂kɔki gia yə wi dzakaki i mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mi wə wi bi baaŋki i wɔ̂kɔ gia i mi wi ntum wiwɔ, bə bi bwîli wəmaka wi i mbaŋ wi bəni bə Nyɔ kintəəŋ, bə kaasi bəh wi.’ ");
INSERT INTO cug_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Yi kɔ tə ayaka si bəni bə ntum bə Nyɔ i yisi i Samwɛl, bəh bə̀ bɔ nì dzə i jum wə, bɔ nì dzə chiŋni dzaka lɔ kɔm gia yə yi numki i chɔkɔ bidaiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gia yichi yə Nyɔ nì kaka i dzaka ki bəni bu bə ntum bələ wə, bəh miŋkaiŋ mə Nyɔ nì dzi bəh bətii tii bəmbɛiŋ bi kɔ tə i mbɛiŋ. Yi kɔ asi Nyɔ nì dzaka i Ablaham a, ‘Mih ni bɔiŋsi lə bəni bəchi i shwaiŋ wə tsə dzəh i waiŋ i wɔ dzu.’ ");
INSERT INTO cug_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nyɔ ka saiŋbwili mi wi wi nɔm, ka yisi faaŋ wi a num i mbɛiŋ a wi dzə̂ bəh kimbɔiŋsi i mbɛiŋ wə, ma wi fə̂ ma mbɛiŋ bêe dzə́h yimbɛiŋ yichu.” ");
INSERT INTO cug_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Asi Bita bəh Jɔn nì kɛiŋki bɔ dzaka i bəni yakadəiŋ, bətii mfə gia bədɔkɔ bəh fwu wi bəni bə jum bə̀ bɔ nì chəniki juŋ yi fəni yi gia bəh Bəsadusi bədɔkɔ dzə jəŋ liə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Bɔ nì bɔksi shɔ́m kɔm Bita bəh Jɔn nì laniki bəni, fuku a Jisɔs nì dza i kpi wə, ayaka a bəni bə̀ bɔ nì kpiyi bi dzayiki lə tə i kpi wə. ");
INSERT INTO cug_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bɔ ka kwa bɔ tsə fa i juŋ yi nsəŋ mə kɔm a nì kɔ i fijɔbi, bɔ ka bee a chɔkɔ buku wɔ̂ɔ ka bə wɔ̂kɔ. ");
INSERT INTO cug_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ayakalə, bəni bəduli bə̀ bɔ nì wɔkɔliki nlani wi Bita bəh Jɔn ka bum, mbaŋ wibɔ kpɛiŋsi, bənyuku nì kɔ ka bənchuku bəte (5,000). ");
INSERT INTO cug_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chɔkɔ ka buku wɔɔ, kifwu ki kwili kiwɔ bəh bəni bə̀ bɔ nì sakaki kwili wiwɔ, bəh bəni bə̀ bɔ nì laniki bənchi bə Nyɔ, juŋni di bimu i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas fwu wi bətii mfə gia bəh Kayfas bəh Jɔn bəh Alɛksanda bəh bəni bədɔkɔ bə̀ bɔ nì kɔ tə i chwɔŋkijuŋ ki fwu wi bətii mfə gia wə, num fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Bɔ ka tɔm Bita bəh Jɔn i bɔ nshiŋ, bikə i bɔ a, “Mbɛiŋ ni dzɔ faiŋ ŋga ka mbɛiŋ chuku mi wələ yɛiŋ na? Mbɛiŋ ni chuku i yɛli wi ndə wə a?” ");
INSERT INTO cug_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Kiŋ'waka ki Baiŋni num ki jikə i Bita wə, wi ka chukuli bɔ a, “Bətii di bəh bəni bə̀ bɔ sakaki di, ");
INSERT INTO cug_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","buku daiŋ fa kɔmyiki dzaka kɔm nɔm wi ndzɔŋni wə buku ni fə i kiŋkəni, ka wi nyaniki. Si mbɛiŋ nəŋki i kiə si yi ni tsə, ");
INSERT INTO cug_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","mbɛiŋ bəh bəni bə Islae bəchi kîə a, mi wələ wi num i mbɛiŋ nshiŋ wi ləkəli i liə, akɔ kɔm yɛli wi Jisɔs Klistus wi Nasali. Jisɔs wiwɔ num wə mbɛiŋ nì dzɔ baŋŋ i kintasi wə, wi kpi, ayakalə Nyɔ fiəni dzasi wi i kpi wə. ");
INSERT INTO cug_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Wi kɔ təh wə Kiŋwakti ki Nyɔ dzakaki kɔm wi a, ‘Təh wə mbɛiŋ bəni bə maani nì nəiŋ wi fiəni chu lɔ wi bu wi juŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Akɔ a Jisɔs shəŋ wə wi bwiliki bəni. Yɛli wi mi widɔkɔ kɔkə fa kuku wə Nyɔ kɔ wi jiə a wi kɔ i bwiliki bukumbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Bəni bə̀ bɔ nì sakaki, wɔkɔ si Bita bəh Jɔn dzakaki chu lwa kə, chu yɛiŋ a bɔ kɔ a nchiŋ bəni bɔ kiə kə kiŋwakti, dzaka wɔm bɔ. Bɔ ka kiə a, akɔ kɔm bɔ kɔ bəni bə̀ bɔ nì nyaniki bəh Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bɔ nəki chu kaŋa kə gia yə bɔ kɔ gukuliki kɔm Bita bəh Jɔn i fɛiŋ wə, kɔm bɔ nì yɛiŋki lə mi wə bɔ nì chuku, wi num bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Bəni bə̀ bɔ nì sakaki dza bwili bɔ i biŋ, ka baaŋ ka saniki fasi a bɔ bɔ dzakayi a, ");
INSERT INTO cug_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Bukumbɛiŋ ni fə dəiŋ bəh bəni bələ a? Bəni bəchi i Jɛlusalɛm bɔ si kiə lɔ kɔm gia yələ yi chusiki ŋga bi Nyɔ daiŋ si bɔ fə, bukumbɛiŋ kɔbi i nəiŋ yi. ");
INSERT INTO cug_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ayakalə, i fə a gia yələ ma chu wâŋ tsə̂ i bəni, bukumbɛiŋ kiŋ i bəni bələ a bɔ ma chu mɔ̂m i dzâka gia yidɔkɔ i mi widɔkɔ kɔm yɛli wi Jisɔs wələ.” ");
INSERT INTO cug_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Bɔ ka fiəni bɔɔŋ Bita bəh Jɔn bɔ fiəni liə. Bɔ ka kiŋ i bɔ a bɔ ma chu mɔ̂m i dzaka nabə i lani mi widɔkɔ kɔm yɛli wi Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bita bəh Jɔn chukuli fibɔ a, “Mbɛiŋ kwâka tə a, gia yə yi kɔ chəŋ i Nyɔ kɔ a buku wɔkɔ num i mbɛiŋ, ma i wi Nyɔ a? ");
INSERT INTO cug_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Buku mɔŋ i bee i dzakaki kɔm gia yə buku kɔ buku yɛiŋ ka chu wɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Bəni bə̀ bɔ nì sakaki, chu kîŋ i bɔ nalə, bee bɔ ka tsəki, kɔm bɔ ni dza gia yə bɔ kɔ i jiə ŋgəkə yɛiŋ i bɔ fuŋ, kɔm bəni bəchi nì kɔksiki lə Nyɔ i gia yə yi nì num, ");
INSERT INTO cug_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","i kpɛiŋsi i yi wə, mi wə bɔ nì fə gia yə yi nì chusiki ŋga bi Nyɔ, i chuku wi, a nì kɔ wi tsə jía mbaŋnyani. ");
INSERT INTO cug_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Asi bɔ nì yatɔkɔ Bita bəh Jɔn yakadəiŋ, bɔ fiəni tsə i mbaŋ wibɔ wə ka fuku gia yə bətii mfə gia bəmbum bəh bəni bə̀ bɔ nì sakaki kwili dzaka i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Si bɔ wɔkɔ yakadəiŋ, bɔ bəchi juŋni i fiɛŋ fimu wə tsa Nyɔ a, “Bah Tikwili, a nì maa wɔ bɔɔli bəh nshwaiŋ bəh kinchwɔ kimbum bəh biɛiŋ bichi biə bi kɔ i kidi kələ wə. ");
INSERT INTO cug_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wɔ nì fə tii tii wibuku Dɛbit waiŋ wa wi nɔm dzaka i ŋga bi Kiŋ'waka ki Baiŋni wə a, Akɔ kɔm nə bəni bə̀ bɔ kɔkə Bəju, gia yakaki i bɔ shɔ́m, ayaka bəni jiə kimfasi kə ki kɔkə i nyani a? ");
INSERT INTO cug_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Bəŋkuŋ bə fa kuku fasiki jum, bəni bə̀ bɔ sakaki kwili juŋni i jwɔ Bah bəh mi wi wə wi kɔ wi fiaŋsi tɔm a wi numki Kimbwili. ");
INSERT INTO cug_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Akɔ a gia yə yi nì kɔ fa kwili wələ wə. Ŋkuŋ Hɛlɔd bəh Bɔntiu Baylɛ nì kɔ bɔ chiŋni bəh bəni bə dzəni, bəh bəni bə Islae dzi minaŋ i jum wə kɔm Jisɔs wə Waiŋ wa wi nɔm wi baiŋni wə wɔ nì fiaŋsi tɔm ka Kimbwili. ");
INSERT INTO cug_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Bɔ nì juŋni i fə num gia yə wɔ nì kɛiŋsi lɔ bəh ŋga bia, a wɔ kɔŋki a yi bi num. ");
INSERT INTO cug_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ayakadəiŋ, i liə Bah, yɛ̂iŋ dzəh yə bəni bələ gumsiki buku yɛiŋ. Nyâ buku bəni ba bə nɔm bəh shɔ́m yiləkəli i fukuki ntum wa lwa kə. ");
INSERT INTO cug_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nyâ buku bəh ŋga bia i chukuki bəni chu fə binchəsi biə bi chusiki ŋga bia bəh yi dzaka kiwɔmni i yɛli wi Jisɔs Waiŋ wa wi nɔm wi baiŋni wə.” ");
INSERT INTO cug_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jɔbi wə bɔ nì tsa kaasi di biə bɔ nì juŋni fɛiŋ nəŋni. Kiŋ'waka ki Baiŋni jikə i bɔ wə bɔ yisi ka fukuki gia yi Nyɔ lwa kə. ");
INSERT INTO cug_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mbaŋ wi bəni bə bumni num i shɔm yimu, ka numki a mi wimu wə, mi kɔbi i bɔɔŋ fiɛŋ fidɔkɔ a, akɔ mfih wimbɔŋ. Fiɛŋ fi mi wimu num fi bəni bəchi. ");
INSERT INTO cug_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nyɔ nya ŋga bimbum i bwa bə ntum bə Jisɔs, bɔ ka chu fukuki i bəni nalə, a Bah Jisɔs nì dza i kpi wə. Bɔ num ŋgamti wi Nyɔ wimbum num i bɔ wə nalə. ");
INSERT INTO cug_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mi widɔkɔ nì kɔkə i bɔ kintəəŋ wə wi nì dzaki fiɛŋ fidɔkɔ, kɔm bəni bə̀ bɔ nì kaŋaki kikhə nabə júŋ, nì fəki bɔ taŋni dzə bəh kpɔ wiwɔ, ");
INSERT INTO cug_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","nya i bwa bə ntum bə Jisɔs kaŋ, bɔ ka gaa i bəni bəchi asi ŋgəkə wi mi kɔ. ");
INSERT INTO cug_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Mi widɔkɔ nì kɔlə bə bɔɔŋ a Yɔsɛf, num bwa bə ntum bə Jisɔs nì du yɛli wi widɔkɔ a Banabas, (wi num a Mi Wi shili Shɔ́m yi bəni). Wi nì kɔ mi i chwɔŋkijuŋ ki Lɛwi wə, num bə nì bwɔ wi i Sayblus. ");
INSERT INTO cug_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wi tsə ka taŋni tə khə wi, dzə nya kpɔ wiwɔ i bwa bə ntum bə Jisɔs kaŋ. ");
INSERT INTO cug_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Mi widɔkɔ bə nì bɔɔŋki a Ananias bəh kpə wi Safilia taŋni tə di bibɔ. ");
INSERT INTO cug_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ayakalə, wi gaali kpɔ wiwɔ jiə kiŋka kiwɔ kpə wi kiə yɛiŋ, tsə nya kiŋka i kaŋ yi bwa bə ntum bə Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Si wi nya yakadəiŋ, Bita bikə i wi a, “Ananias, akɔ kɔm nə wɔ bee a Satan lîə i shɔm ya mə, fə a wɔ nyî ntəkə i Kiŋ'waka ki Baiŋni, wɔ ka gaali kpɔ wə wɔ taŋni di yɛiŋ na? ");
INSERT INTO cug_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ntə wɔ si taŋni di biələ a num mbia? Wɔ taŋni di kpɔ wiwɔ kɛiŋ a ŋ'wa? Aka fə nə a wɔ fə ŋkaiŋni wi gia ka yələ a? Wɔ ka nyi dəkə ntəkə num i bəni, wɔ nyi num i Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Akisəkə asi Ananias wɔkɔ ndzaka wiwɔ yakadəiŋ, ka gbɔ kpi. Ayaka bəni bəchi bə̀ bɔ nì wɔkɔ gia yiwɔ ndzaŋ kwa bɔ nalə. ");
INSERT INTO cug_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Bwa bə sumi bənyuku dzə kii wini wi bəh mbuŋ, dzɔ buku tsə ləə. ");
INSERT INTO cug_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","I yɛiŋ jum, asi mbiəŋə mitali tsə, kpə wi ka liə dzə, kiə kə gia yə yi si num bəh nyuwi. ");
INSERT INTO cug_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bita bikə i wi a, “Fûku mih, a wələ kɔ kpɔ wichi wə mbɛiŋ nyu wa si taŋni di yɛiŋ?” Ayaka wi chukuli a, “Aaŋ, akɔ wi wichi yaka.” ");
INSERT INTO cug_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bita chu bikə i wi a, “Akɔ kɔm nə mbɛiŋ nyu wa si kɛiŋsi i mɔmsi Kiŋ'waka ki Bah a? Wɔ̂kɔli wɔ̂kɔ si gvu yi bəni bə̀ bɔ tsə ləə nyu wa kɔmki dzəki i fifiəŋə, bɔ kaŋa i bɔŋ giŋ buku bəh wɔ yakadəiŋ tə i tsə ləə.” ");
INSERT INTO cug_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Si Bita dzaka yakadəiŋ, akisəkə Safilia gbɔ ka kpi i wi nshiŋ. Ayakalə, bwa bə sumi bə̀ liə dzə num wi kpi lɔ, bɔ ka giŋ wi buku tsə ləə kɔmsi i nyuwi kpəŋ. ");
INSERT INTO cug_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kijuŋni ki bəni bə bumni kichi bəh bəni bəchi bə̀ bɔ nì wɔkɔ kɔm gia yiwɔ ndzaŋ liəni i bɔ wə nalə. ");
INSERT INTO cug_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Bwa bə faaŋni bə Jisɔs ka fəki bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ bəh gia yi dzaka ki wɔmni yiduli i bəni kintəəŋ. Bəni bə bumni bəchi nì shiki juŋniki i saŋ wi Sɔlɔmɔn wə i juŋ yi fəni yi gia mə. ");
INSERT INTO cug_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Na nchiŋ mi nəki mɔmsi kə i chiŋni i mbaŋ wibɔ wə. Ayakalə, bəni bəduli nì kɔksiki lə bɔ nalə. ");
INSERT INTO cug_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Bənyuku bəh Bəkaŋa bəduli bə̀ bɔ nì jiə shɔm i Bah wə, ka kpɛiŋsiki i mbaŋ wibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Gia yə bwa bə ntum bə Jisɔs nì fəki, yi fə bəni ka giŋki bəni bə jwɛiŋ tsə nɔsi i dzə́h kpəŋ, i binaŋ wə, bəh i biga wə, a jɔbi wə Bita ni tsəki, yuwidɔkɔ kinjəŋnjəŋ ki ni tsə i bɔ bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mbaŋ wi bəni ka nyəki dzəki i kikwili kə ki kɔ kɔmsi i Jɛlusalɛm bəh bəni bə jwɛiŋ bəh bə̀ bɔ nì kaŋaki biŋ'waka bi jisi i bɔ wə, bɔ chuku bɔ bəchi. ");
INSERT INTO cug_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Fwu wi bətii mfə gia bəh mbaŋ wi a num Bəsadusi, dza ka yisi i ghəkəki bwa bə ntum bə Jisɔs, ");
INSERT INTO cug_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ka faaŋ bəni, bɔ tsə kwa fah bɔ i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ayakalə, a dzə num nchɔkɔ, chinda wi Bah dzə wɛli dzaka bifiəŋə ki juŋ yi nsəŋ bwili bɔ. Si wi bwili bɔ, ka dzaka a, ");
INSERT INTO cug_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mbɛiŋ tsə̂ i juŋ yi fəni yi gia mə, mbɛiŋ fûkuki gia yichi i bəni kɔm nɔni kimfiaŋ kələ.” ");
INSERT INTO cug_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Si bɔ wɔkɔ yakadəiŋ, ka tsə. Asi biŋ nì baiŋki dzəki, bɔ ka tsə i juŋ yi fəni yi gia mə, ka yisi i laniki bəni. Jɔbi wiwɔ, fwu wi bətii mfə gia bəh bəni bu bə mbaŋ, ni bɔŋ juŋni bəni bə Islae bə̀ bɔ sakaki kikwili kichi bəh bɔ shinum, ka faaŋ bəni bə jum a bɔ tsə̂ dzə̂ bəh bwa bə ntum bə Jisɔs i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bɔ tsə buku fɛiŋ nəŋ bɔ nəki yɛiŋ kə i bɔ wə ka fiəni dzə fuku a, ");
INSERT INTO cug_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Buku tsə buku i juŋ yi nsəŋ mə, yɛiŋ dzaka bifiəŋə num bə lansi fah bi nalə, bəni bə jum num fɛiŋ chəni. Asi buku wɛli juŋ yiwɔ ka liə nəki yɛiŋ kə mi widɔkɔ fɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Fwu wi bəni bə jum wə bɔ nì chəniki juŋ yi fəni yi gia bəh bətii mfə gia bəmbum, wɔkɔ yakadəiŋ, yi fumsi bɔ, bɔ ka dzaka a, buku ni tsə faiŋ bəh gia yələ lə. ");
INSERT INTO cug_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mi widɔkɔ nyə dzə liə fuku i bɔ a, “Mbɛiŋ wɔ̂kɔli, bəni bə̀ mbɛiŋ si fah i juŋ yi nsəŋ mə, bə bɔ yaka lɔ i juŋ yi fəni yi gia mə, bɔ laniki bəni.” ");
INSERT INTO cug_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Si bɔ wɔkɔ yakadəiŋ, fwu wi bəni bə jum bəh mbaŋ wi ka buku tsə dzɔ bɔ, ka dzəki bəh bɔ. Ayakalə, bɔ nì dzəki kə bəh bɔ bəh ŋga, kɔm bəni bə jum bəwɔ nì lwaki lə a bəni nì tumyi lə bɔ bəh kitəh. ");
INSERT INTO cug_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bɔ dzə bəh bwa bə ntum bə Jisɔs, liə tɔm bɔ i bəni bə̀ bɔ sakaki kwili nshiŋ. Ayaka fwu wi bətii mfə gia ka bikəki bəmbikə i bɔ dzaka a, ");
INSERT INTO cug_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Buku nì lansi kiŋ a mbɛiŋ ma chu mɔ̂m i lâni mi kɔm yɛli wi mi wələ. Ayakalə, mbɛiŋ yɛ̂iŋ gia yə mbɛiŋ mɔm! Mbɛiŋ fə nlani wimbɛiŋ waŋ Jɛlusalɛm wichi. Mbɛiŋ nəŋki i fə yi chusiki ka buku kiəki lə gia kɔm kpi yi.” ");
INSERT INTO cug_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bita bəh mbaŋ wi bwa bə ntum bə Jisɔs chukuli a, “Buku kaŋaki i wɔkɔ num i Nyɔ, a kɔbi i mi. ");
INSERT INTO cug_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mbɛiŋ nì baŋŋ Jisɔs i kintasi wə wi kpi. Ayakalə, Nyɔ wi bətii tii bəbukumbɛiŋ fiəni dzasi wi i kpi wə, ");
INSERT INTO cug_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","giŋsi wi, tɔm i tsɛiŋ yi yiləkəli wə, a wi num Tikwili bəh Kimbwili, ka bəni bə Islae kɔlə ni kwûni shɔ́m yibɔ, ma Nyɔ ni dalinya chu bibɔ. ");
INSERT INTO cug_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Buku yɛiŋ gia yələ kabə fukuki i bəni, ayaka Kiŋ'waka ki Baiŋni kə Nyɔ nyaki i bəni bə̀ bɔ wɔkɔki i wi, ki bɔŋ tɔbi a gia yələ kɔ ŋkɔŋ.” ");
INSERT INTO cug_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Si bəni bə̀ bɔ nì sakaki tumi wɔkɔ ndzaka wiwɔ yaka, shɔ́m bɔkɔ lɔ bɔ bɔkɔni. Bɔ ka nəŋki i wɔɔyi bwa bə ntum bə Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ayakalə, mi widɔkɔ i mbaŋ wi bəni bə̀ bɔ nì sakaki kwili dza bɛiŋ, yɛli wi num Gamalia, a num mi wi Falasi a chu num mi wə wi laniki bənchi bə Nyɔ, bəni bəchi kɔksi wi na bindzɔŋ. Si wi dza bɛiŋ yakadəiŋ, ka dzaka a bə bwîli dəkə bwa bə ntum bə Jisɔs i biŋ. ");
INSERT INTO cug_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Wi baaŋ dzaka i bəni bə̀ bɔ nì sakaki kwili a, “Bəni bə Islae, mbɛiŋ dzɔ̂ jɔbi i gia yə mbɛiŋ nəŋki i fə bəh bəni bələ. ");
INSERT INTO cug_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Mbɛiŋ yîŋti a, a nì kɔ i jɔbi widɔkɔ wə, mi widɔkɔ nì dza fa, bə bɔɔŋ a Teɔdas ka chusiki a ŋgaiŋ kɔ mi wimbum. Bəni kwu i wi chɛiŋ, ka gi yina. Bə nyani dzə wɔɔ wi, mbaŋ wiwɔ gaali, ayaka gia yə wi nì dzəki bəh yi ka laka kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Asi yəmaka nì tsə, widɔkɔ chu tumbuku dzə i jɔbi wə bə nì faaki bəni bə bɔɔŋ wi a Judas, a num mi wi Galili. Wi guku bəni bəduli i wi chɛiŋ. Bə nyani dzə wɔɔ tə wi, ayaka mbaŋ wi waŋyi tə. ");
INSERT INTO cug_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","I yələ wə, mih təfiki mbɛiŋ a, mbɛiŋ ma mɔ̂m i fə̂ gia yidɔkɔ bə bəni bələ. Mbɛiŋ bêe dzəh yibɔ. A kabə num a gia yə bɔ dzəki bəh yi chu lani bəni bəh yi a, akɔ gia num a yisi mi, ma yi ni laka kilɔlɔ. ");
INSERT INTO cug_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","A kabə num a gia yiwɔ yisi Nyɔ, ma yi ni numki a mbɛiŋ kɔkə i gaka bɔ. Mbɛiŋ baaŋ ki tɔkni kə yi bi baiŋ buku a mbɛiŋ jwɔki num bəh Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Si Gamalia dzaka yaka, bəni bə̀ bɔ nì sakaki kwili wɔkɔ ntəfi wi, fiəni bɔɔŋ bwa bə ntum bə Jisɔs, a bɔ lîə dzə̂. Si bɔ liə dzə yaka, bɔ twɛiŋ bɔ ka kiŋ a bɔ bi ma chu mɔ̂m i lani mi widɔkɔ kɔm yɛli wi Jisɔs ka bee bɔ nyə. ");
INSERT INTO cug_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Si bɔ buku fɛiŋ kabə tsə fibɔ num bəh kinsaŋli, a bɔ kɔ num bɔ kpɛiŋ i bəni bə̀ bɔ kɔ i ŋgəmsi bɔ kɔm yɛli wi Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Bɔ tsə yakadəiŋ, ka chu laniki bəni chɔkɔ bichi i juŋ yi fəni yi gia mə bəh i kikwili wə, fuku ntum wi ndzɔŋni, a Jisɔs kɔ Kimbwili wə Nyɔ nì kaka. ");
INSERT INTO cug_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","A dzə num i jɔbi widɔkɔ wə, si mbaŋ wi bəni bə bumni nì kɔki tsəki a ninshiŋ, Bəju bə̀ bɔ nì dzakaki já yi Glik yisi i shwiŋyiki, Bəju bə̀ bɔ nì dzakaki já yi kwili, a bɔ gaaki biɛiŋ i bəkaŋa bəŋkwu chɔkɔ bichi tsɛiŋ kə bəbɔ. ");
INSERT INTO cug_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ayakadəiŋ, bwa bə ntum bə Jisɔs bə̀ jwɔfi ntsɔ bəfa juŋni bəh mbaŋ wi bəni bə bumni bəchi dzaka i bɔ a, “Yi ndzɔŋki kə a, buku bêe i fûkuki gia yi Nyɔ, i tsə̂ num, i gâaki num biɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bwa bə nih bəbuku, yi ndzɔŋki lə a mbɛiŋ bâyi bəni nanitaŋ i mbɛiŋ kintəəŋ ma buku nya nɔm wələ i bɔ kaŋ. Mbɛiŋ kabə bayi, mbɛiŋ ka tsɛ̂iŋki num bəni bə̀ bɔ kaŋaki nɔni kindzɔŋni, num bɔ jikə bəh Kiŋ'waka ki Baiŋni chu kaŋa mfi. ");
INSERT INTO cug_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ayakadəiŋ, ma buku ni nyâ gwu yibuku num i ntsa wə bəh i nɔm i gia yi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Bəni bəchi wɔkɔ ndzaka wiwɔ, wi ndzɔŋ i bɔ nalə. Bɔ ka babwili Stifɛn num mi wə kimbum ki jikə nalə, num wi jikə tə bəh Kiŋ'waka ki Baiŋni. Bədɔkɔ num Filib bəh Blukɔlus, Nikanɔ bəh Timɔn, Balmɛnas bəh Nikɔlaus wə wi nì kɔ mi wi Antiɔk, num wi nì fiəni fiənini i kimbum ki Bəju wə. ");
INSERT INTO cug_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Bɔ ka dzɔ bəni bələ ka tɔm bɔ i bwa bə ntum bə Jisɔs nshiŋ, bɔ jiə kaŋ yibɔ i bɔ wə ka tsa i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Gia yi Nyɔ ka waŋki tsəki. Mbaŋ wi bəni bə bumni i Jɛlusalɛm kɔ tsə a i ninshiŋ. Bətii mfə gia bəduli jiə tə shɔ́m i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stifɛn nì kɔ num wi jikə bəh ŋgamti wi Nyɔ bəh ŋga, i fəki gia yi dzaka ki wɔmni bəh bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ i bəni kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bəni bədɔkɔ dza yisi i ŋgukuliki bəh Stifɛn. Bəni bələ nì kɔ Bəju bə̀ bɔ nì buku dzə i Sɛlin bəh Alɛksandia bəh Silishia bəh Ɛsia. Bəni bəwɔ nì kɔ bəni bə juŋ yi tsani yə bə nì bɔɔŋki a juŋ yi Mfá yə bɔ Buku i Mfa wə. ");
INSERT INTO cug_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Si bɔ nì gukuliki yakadəiŋ, Kiŋ'waka ki Baiŋni nya Stifɛn bəh mfi mi widɔkɔ chu kɔbi i gaka wi. ");
INSERT INTO cug_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Bɔ ka dza nyini bəni bədɔkɔ i jum wə jum wə, a bɔ nyiki ntəkə a, bɔ nì wɔkɔ Stifɛn dzaka gia yichu kɔm Muses bəh kɔm Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Si bɔ fə yaka, ka nəŋni shɔm yi bəni bəh yi bəni bə̀ bɔ sakaki kwili, bəh yi bəni bə̀ bɔ laniki bənchi bə Nyɔ. Bɔ ka liəni i Stifɛn wə, dzɔ tsə bəh wi i bəni bə kwili bə̀ bɔ sakaki bənsaka nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Bəni bələ chu dzə bəh bəni bədɔkɔ a bɔ bêeŋki bənsaka bəntəkə, bɔ jiə gia i Stifɛn fuŋ dzaka a, “Mi wələ si lansi baaŋ kə i dzaka gia yichu kɔm juŋ yi fəni yi gia yələ, bəh i bənchi bə Muses. ");
INSERT INTO cug_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Buku wɔkɔ si wi dzakaki a Jisɔs wi Nasali wə bi shakyi lə juŋ yi fəni yi gia yələ, wi bi chu kwuni tə nɔni kibukumbɛiŋ bi kwili biə Muses nì laniki bukumbɛiŋ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Bəni bəchi bə̀ bɔ nì kɔ i juŋ yi nsaka yiwɔ wə bwaŋ dzə́kəh i Stifɛn wə, a bɔ tsɛiŋ, yɛiŋ num shi bi kwuni lɔ gwu ka bwɔsiki bi chinda wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Fwu wi bətii mfə gia bikə i Stifɛn a, “Gia yələ bə dzakaki lə akɔ a ŋkɔŋ a?” ");
INSERT INTO cug_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stifɛn chukuli a, “Bəba bəh bwa bə nih, mbɛiŋ wɔ̂kɔli. Nyɔ wi kiŋkɔkni nì tumbuku i tii wibuku Ablaham, wi kɛiŋ i Misɔbɔtɛmia, ka wi bi nyə tsə i nɔki i Alan, ");
INSERT INTO cug_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ka dzaka i wi a, ‘Bêe chwɔŋ ka ki juŋ, wɔ bûku i kwili wimbɛiŋ wə, wɔ tsə̂ i tumi kə mih ni chusi i wɔ.’ ");
INSERT INTO cug_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ayakadəiŋ, wi buku nyə fɛiŋ i Kaldia, ka tsə i nɔki i Alan. Jɔbi wə ba wi nì kpi, Nyɔ fə wi dza dzə fa i di biə mbɛiŋ nɔki i liə lə. ");
INSERT INTO cug_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Wi nì kɔ fa Nyɔ nəki nya kə wi na bəh fidini fidɔkɔ fiə wi kɔ i tɔm gvu yɛiŋ. Ayakalə, Nyɔ kaka a ŋgaiŋ bi nya lə mbi wələ i wi a a nûmki ŋ'wi bəh ŋgɔkɔ wi. I jɔbi wə Nyɔ nì fə kiŋkaka ki kələ, a nì kɔ maka Ablaham kwati waiŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nyɔ ka dzaka tə i wi a, ‘Bwa ba bi numki bəni bə dzəni i tumi ki bəni bədɔkɔ wə. Bɔ bi numki mfa fɛiŋ, bə bi chəbsiki bɔ i jía wə gi yina (400). ");
INSERT INTO cug_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mih bi lɔ lə ŋgəkə i tumi kiwɔ wə, bwa ba bi buku dzə fɛiŋ, bɔ dzə tsaki i mih fa.’ ");
INSERT INTO cug_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nyɔ chu dzi tə miŋkaiŋ bəh Ablaham, kinchəsi ki miŋkaiŋ miwɔ num a Ablaham ni sûuŋki lə bwa bu. Ablaham ka bi bwɔ Ayjik, jɔbi kpɛiŋ kaŋ nyaŋ wi suuŋ wi. Ayjik ka bi bwɔ Yakɔb suuŋ tə wi. Yakɔb tə ka bi suuŋ bwa bu jwɔfi ntsɔ bəfa bə̀ bɔ kɔ bətii tii bəbuku a num i bɔ wə chwɔŋkijuŋ kibuku nì yisi. ");
INSERT INTO cug_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Bətii tii bəbuku bəwɔ bi ka dza bə́ ghəkəki Yɔsɛf waiŋnih wibɔ, ka taŋni wi, wi tsə ka numki mfa i tumi ki Ijib wə. Ayakalə, Nyɔ bə́ tɔkni bəh wi fɛiŋ, ");
INSERT INTO cug_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","gamti wi i bəŋgəkə bu wə bəchi. Nyɔ chu nya tə wi bəh mfi, fə Fɛlɔ ŋkuŋ wi Ijib ka kɔŋki wi, ka jiə wi, i nûmki mi wə wi kɔmsiki i wi wə chu nûm mi wə wi tsɛiŋki chwɔŋ ki ki juŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dzɔŋ ka bi dza kwa Ijib wichi bəh tumi ki Kanan, bəni yɛiŋ ŋgəkə nalə. Bətii tii bəbuku nəki chu kaŋa kə biɛiŋ bidzini. ");
INSERT INTO cug_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yakɔb ka bi wɔkɔ a biɛiŋ bidzini kɔlə i Ijib, ka faaŋ bwa bu bə̀ bɔ kɔ bətii tii bəbuku, bɔ ka tsə fɛiŋ i chɔkɔ bibɔ bi ninshiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Bɔ ka fiəni tsə fɛiŋ i ntsə wibɔ wi kɔmsini wə, Yɔsɛf ka fə bwa bə nih wi kiə wi. Wi ka chusi tə bɔ i Fɛlɔ. ");
INSERT INTO cug_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Yɔsɛf ka faaŋ ntum i Yakɔb ba wi, a wi bəh chwɔŋ ki ki juŋ kichi shi dzə i Ijib. Chwɔŋkijuŋ ki Yakɔb nì kɔ i jɔbi wiwɔ wə bəni mbaŋnanitaŋ ntsɔ bəte (75). ");
INSERT INTO cug_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakɔb wɔkɔ yaka, ka dzɔ chwɔŋkijuŋ ki kichi, shi bəh bɔ i Ijib. Wi bəh bətii tii bəbuku nì dzə kpiyi i fɛiŋ wə bɔ bəchi. ");
INSERT INTO cug_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Bɔ dzə giŋ biwini biwɔ ka fiəni dzə bəh bi i Shɛkɛm, ləə i jum yə Ablaham nì taŋ i bwa bə Amɔl. ");
INSERT INTO cug_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Si jɔbi nì kpɛiŋniki dzəki wə Nyɔ nì kɔ i fə gia yə wi nì kaka i Ablaham, num bəni bəbuku du i Ijib nalə. ");
INSERT INTO cug_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Bəni bə̀ fɛiŋ bi dzə tɔm ŋkuŋ widɔkɔ wi nəki kiə kə Yɔsɛf. ");
INSERT INTO cug_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ŋkuŋ wiwɔ ka wɛɛliki chəbsiki bəni bəbuku i dzəh yi mfi wə kaŋyi a bətii tii bəbuku lɔ̂ɔtɔkɔki bwa bənchiŋ i biŋ a bɔ kpiyiki. ");
INSERT INTO cug_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","A nì kɔ i jɔbi wələ wə, bə nì bwɔ Muses, a num waiŋ wi ndzɔŋ nalə i Nyɔ. Bə kuku yaka wi i ba wi dzu, i kifiəŋŋ kitali wə, ");
INSERT INTO cug_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ka dzɔ tsə jiə wi i biŋ. Ayaka waiŋ ŋkuŋ Fɛlɔ wi kpaŋni ka bi tsə bɔŋ wi, kuku yaka wi ka waiŋ wi. ");
INSERT INTO cug_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Bə ka lani Muses bəh mfi bi bəni bə Ijib bichi, wi num mi wə wi kiəki ndzaka bəh i fəki gia nalə. ");
INSERT INTO cug_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","I jɔbi wə wi nì kɔ yaka buku jía mbaŋnyani, yi dzə i wi shɔm a ŋgaiŋ tsə yɛiŋ bwa bə nih bə ŋgaiŋ bəni bə Islae. ");
INSERT INTO cug_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jɔbi wə wi nì tsəki, wi yɛiŋ mi wi Ijib widɔkɔ twɛiŋ mi wi Islae. Wi ka liə i jwɔ biwɔ wə i chukuli, ka wɔɔ mi wi Ijib wiwɔ ka ləə. ");
INSERT INTO cug_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wi nì kwakaki a bwa bə nih wi ni kiə lə, a faaŋ Nyɔ ŋgaiŋ a ŋgaiŋ dzə̂ bwîli bɔ i bəŋgəkə wə. Ayakalə, bɔ nəki kiə kə. ");
INSERT INTO cug_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chɔkɔ buku wɔɔ, Muses ka tsəki, tsə tumbuku i bəni bə Islae bədɔkɔ wə bəfa bɔ dza ka jwɔki. Ayaka wi liə yɛiŋ i gaali jwɔ biwɔ, ka bikə i bɔ a, ‘Bwa bə nih, mbɛiŋ bəchi kɔ mi bəh waiŋnih, akɔ kɔm nə mbɛiŋ jwɔki a mbɛiŋ mbɛiŋ a?’ ");
INSERT INTO cug_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ayakalə, mi wə wi nì la jwɔ i waiŋnih wi chini Muses chinini, bikə i wi a, ‘A jiə ndə wɔ i sakaki buku chu təiŋyi bənsaka bəbuku a? ");
INSERT INTO cug_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wɔ nəŋki i bɔŋ wɔɔ mih asi wɔ ni wɔɔ mi wi Ijib wə i ŋgbufɔkɔ a?’ ");
INSERT INTO cug_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Asi Muses wɔkɔ yakadəiŋ, wi lwa ka gɛiŋ buku i tumi ki Ijib wə, gɛiŋ tsə i nɔki i tumi ki Midian wə, ka bwɔ bwa bənyuku bəfa fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Asi jía nì tsə mbaŋnyani, chinda wi Nyɔ tumbuku i Muses nshiŋ i gbuku wə wi nì bɛli i kpɛiŋ wə i chwa i kɔmsi tsə i ŋkwuŋ wi Sina wə. ");
INSERT INTO cug_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Muses yɛiŋ yaka yi gaka wi, wi kini tsə i tsɛiŋ ndzɔŋ. Si wi kɔmsi tsə, wi wɔkɔ Bah Nyɔ dzaka i wi a, ");
INSERT INTO cug_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Akɔ mih Nyɔ wi bətii tii bəmbɛiŋ, Nyɔ wi Ablaham bəh wi Ayjik bəh wi Yakɔb.’ Muses wɔkɔ yakadəiŋ, ndzaŋ kwa wi, wi ka nyumki bəh nlwa, na chu mɔm i tsɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bah Nyɔ chu dzaka i wi a, ‘Bâyi dzu ya yigvu, kɔm di biə wɔ num yɛiŋ yaka akɔ di bi baiŋni. ");
INSERT INTO cug_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mih lansi yɛiŋ si bə chəbsiki bəni mbəŋ i Ijib, chu wɔkɔ si bɔ kwiŋki, ayaka mih ka shi dzə i bwili bɔ i ŋgəkə wiwɔ mə, wɔ̂kɔli, i liə mih ki faaŋki lə wɔ i Ijib.’ ");
INSERT INTO cug_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Muses wələ kɔ wə bɔ nì yisi nəiŋ, bikə i wi a, ‘A jiə ndə wɔ i sakaki buku chu təiŋyi bənsaka bəbuku a?’ Akɔ wi wə Nyɔ nì faaŋ a wi tsə̂ nûmki mi wi nsaka wibɔ, i bwîli bɔ i bəŋgəkə wə. Nyɔ nì faaŋ num chinda wi, wi dzə i kpɛiŋ wə wi nì bɛliki, a wi dzə̂ lâka ntum wiwɔ i wi. ");
INSERT INTO cug_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Muses ka tsə i Ijib, fə gia yi dzaka ki wɔmni bəh bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ, ka bwili bɔ fɛiŋ. Wi fə yidɔkɔ i Bɔkɔ yi Mbum yi Bɔkɔli wə, chu fə yidɔkɔ i chwa i di biə bɔ nì nyani i jía wə mbaŋnyani. ");
INSERT INTO cug_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ayaka Muses nì kɔ wi dzaka i bəni bə Islae a, ‘Nyɔ bi bwili lə mi wi ntum widɔkɔ i bwa bə nih bəmbɛiŋ kintəəŋ, wi chiŋsi i mbɛiŋ asi wi nì bwili mih.’ ");
INSERT INTO cug_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","A chu num wi Muses wə chinda wi Nyɔ nì dzaka i wi i ŋkwuŋ wi Sina wə, jɔbi wə kijuŋni ki bəni bə Islae nì kɔ i chwa bəh bətii tii bəbuku, Nyɔ nì nya já yə yi nyaki nɔni a wi tsə̂si i bukumbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Ayakalə, bətii tii bəbuku ka nəiŋ i wɔkɔ i Muses, ka nyɔkɔ jum i wi, ka kɔŋki a bɔ fiəni tsə i Ijib. ");
INSERT INTO cug_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bɔ ka dzaka i Ɛlɔŋ a, ‘Mwə̂m bənyɔ i buku bə̀ bɔ nì tsəki i bukumbɛiŋ nshiŋ, kɔm buku kiəki kə gia yə yi num bəh Muses wə wi bwili bukumbɛiŋ i tumi ki Ijib wə.’ ");
INSERT INTO cug_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bɔ ka kɛiŋsi fimɔsɔ fi bwɔsi waiŋ naʼ, kum nyám, fə gia yɛiŋ i fi, ka laŋki i fi wə num a kɛiŋsi bɔ bəh kaŋ yibɔ. ");
INSERT INTO cug_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Si bɔ fə yakadəiŋ, Nyɔ ka nyɔkɔ jum i bɔ, bɔ ka yisi lɔ i tsaki num i wɔŋ bəh fiəŋŋ bəh bijɔŋ. Yi num asi bə nyaka i kiŋwakti ki bəni bə ntum bə Nyɔ wə, num Nyɔ nì dzaka a, ‘Bəni bə Islae, mbɛiŋ nì kumki nyám i chwa i jía mbaŋnyani, fə gia yɛiŋ i mih a? ");
INSERT INTO cug_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Mbɛiŋ nì nyaniki giŋki kintaŋ a num ki nyɔ wə yɛli wi kɔ a Mɔlɔk, chu giŋ jɔŋ wə mbɛiŋ nì kɛiŋsi a, akɔ nyɔ wə, yɛli wi kɔ Lefan, a num mimɔsɔ mə mbɛiŋ nì kɛiŋsi i tsaki i mɔ, kɔm yələ lə mih ni kɔŋŋ bwili lə mbɛiŋ, ma mbɛiŋ ni dza tsə daŋsi na i Babilɔn.’ ");
INSERT INTO cug_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bətii tii bəbuku nì nyaniki i chwa bɔ kaŋa kintaŋ ki chusi a, Nyɔ kɔlə bəh bɔ, num bɔ nì maa kintaŋ kiwɔ biəli a liŋ aka kə Nyɔ nì chusi i Muses. ");
INSERT INTO cug_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Bwa bə bətii tii bəbuku nì dzɔ kintaŋ kələ i bətii bəbɔ, giŋ dzə bəh ki i fa i jɔbi wə bɔ bə Jɔshua nì lɔkɔki kidi i bitumi biə bi nì kɔ fa, num a nì tsəki Nyɔ i bɔ nshiŋ kɔŋŋ bwili bitumi biwɔ. Kintaŋ kələ ka numki fa i tsə buku jɔbi wə Ŋkuŋ Dɛbit nì sakaki kwili wələ. ");
INSERT INTO cug_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ayaka wi ka yɛiŋ a kaŋ yi Nyɔ kɔlə i wi wə nalə, wi ka tsa a Nyɔ bûm ma ŋgaiŋ maa juŋ, i nya i wi Nyɔ wi Yakɔb, a wi nɔki yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ayakalə, a nì kɔ num Sɔlɔmɔn i bi dzə maa juŋ yi Nyɔ yiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Na ayaka Bah Nyɔ wə wi kɔ Fwu wi Biɛiŋ Bichi wə, si nɔ kə i júŋ wə num a maa bəni bəh kaŋ. Yi kɔ a liŋ si mi wi ntum wi Nyɔ widɔkɔ nì nyaka a, Nyɔ nì dzaka a, ");
INSERT INTO cug_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Bɛiŋ kɔ kiŋgbɔkɔ kəŋŋ, ayaka fa kuku num kiŋgbɔkɔ kəŋŋ kigvu. Juŋ yə mi kɔ i maa a yi numki yiŋ, yi kɔ i numki na dəiŋ na? Ma di kɔlə biə mih kɔ i numki fɛiŋ na? ");
INSERT INTO cug_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A kɔkə mih wə mih fə biɛiŋ biələ bichi a?’” ");
INSERT INTO cug_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stifɛn ka dza dzaka i bɔ a, “Mbɛiŋ ləkəki bəh kifwu nalə, shɔm yimbɛiŋ bəh bintuni bimbɛiŋ kɔ num maka bə suuŋ. Mbɛiŋ bəh bətii tii bəmbɛiŋ kɔ a liŋ. Jɔbi wichi mbɛiŋ nəiŋ i wɔkɔli i Kiŋ'waka ki Baiŋni wə. ");
INSERT INTO cug_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mi wi ntum wi Nyɔ widɔkɔ nì kɔlə wə bətii tii bəmbɛiŋ nì baaŋ i bwaŋ gvu i wi chɛiŋ a? Bɔ nì wɔɔyi bəni bə ntum bə Nyɔ bə̀ bɔ nì dzaka a mi wi nɔm wi Nyɔ wi Chəŋ bi dzə lə. Ayaka wi bi dzə, mbɛiŋ taŋni wi, ka chu wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Akɔ mbɛiŋ bələ bəchinda bə Nyɔ nì dzə bəh bənchi bə Nyɔ i mbɛiŋ, mbɛiŋ nəiŋma i biəli bɔ.” ");
INSERT INTO cug_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Si bəni bə̀ bɔ nì sakaki kwili wɔkɔ gia yə Stifɛn dzaka, shɔm bɔkɔ bɔ, bɔ ka dziki jəŋ. ");
INSERT INTO cug_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ayaka Kiŋ'waka ki Baiŋni jikə i Stifɛn wə, wi bə́ tsɛiŋ mfih num i bɛiŋ, ka yɛiŋ baiŋni bi Nyɔ, yɛiŋ tə Jisɔs num wi numbɛiŋ i tsɛiŋ yiləkəli yi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stifɛn dza dzaka i bɔ a, “Mbɛiŋ tsɛ̂iŋ, mih yɛiŋ bɔɔli wɛli, num mi wə yɛli wi kɔ Waiŋmi num wi numbɛiŋ i tsɛiŋ yiləkəli yi Nyɔ wə.” ");
INSERT INTO cug_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bɔ wɔkɔ yəmaka gia, ka baŋ bintuni bibɔ bəh kaŋ, ka wiliki bəh ŋga, i fɛiŋ wə bɔ bəchi sɛiŋ, ka chiŋni i Stifɛn wə, ");
INSERT INTO cug_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","guku buku bəh wi i kwili kintəəŋ, tsə ka yisi i tumyiki wi bəh kitəh. Ayaka bəni bə̀ bɔ nì kɔ bəmbeeŋ nsaka baayi bəmbuŋ bəbɔ, nya i sumi widɔkɔ wə bə nì bɔɔŋki a Sɔɔl ka bɔ tumyiki. ");
INSERT INTO cug_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Si bɔ nì tumyi Stifɛn bəh kitəh yakadəiŋ, wi tsa a, “Bah Jisɔs, dzɔ̂ kiŋ'waka kəŋŋ.” ");
INSERT INTO cug_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ayaka wi ka tum binyu i kuku, wam bəh ŋga a, “Bah, ki tsɛ̂iŋ kə gia yichu yələ bəni bələ fəki.” Si wi dzaka yakadəiŋ, ka kpi. ");
INSERT INTO cug_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Si bə nì wɔɔki Stifɛn yakadəiŋ Sɔɔl nì tɔbiki lə a bə wɔɔ wi. A chɔkɔ biwɔ wə, bə yisi i nyaki ŋgəkə wi ləkəki i kijuŋni ki bəni bə bumni i Jɛlusalɛm. Kijuŋni kiwɔ kichi dza buku fɛiŋ ka waŋ tsə buku i bimbu bi Judea wə bichi bəh bi Samalia wə, a nì baaŋ a bwa bə ntum bə Jisɔs fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bənyuku bədɔkɔ bə̀ bɔ nì kɔ num bɔ jiə shɔ́m i Nyɔ wə nalə, dzə dzɔ wini wi Stifɛn ka tsə ləə, də wi nalə. ");
INSERT INTO cug_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ayakalə, Sɔɔl num mfih a kaasiki kijuŋni ki bəni bə bumni, daŋ a juŋ bəh juŋ kwayi bəni bə bumni, bənyuku bəh bəkaŋa, chiŋsi i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Bəni bə̀ bɔ nì gaali tsə i bidi bichi wə, tsə ka fukuki gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filib shi tsə mfih i kwili wi Samalia wə, ka fukuki ntum wi ndzɔŋni, kɔm Kimbwili wə Nyɔ nì kaka. ");
INSERT INTO cug_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bəni bəduli wɔkɔ chu yɛiŋ bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ, yə wi nì fəki, bɔ ka nya ntuni i wi nalə. ");
INSERT INTO cug_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Biŋ'waka bi jisi nì bukuki lə i bəni wə, bi wili bəh ŋga, bəni bəduli bə̀ bɔ nì kɔ bɔ kpiyi kiwa kimu bəh bəŋkəkni bɔnih tə. ");
INSERT INTO cug_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ayakadəiŋ, kinsaŋli kimbum num i tumi kiwɔ wə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Mi widɔkɔ nì kɔ i tumi kiwɔ wə yɛli wi num Samɔn, a nì kɔ mi wi fə mfim, bəni bə Samalia bəchi nì yɛiŋki yakadəiŋ dzaka wɔm bɔ. Ayaka wi chu dzaka a ŋgaiŋ kɔ mi wimbum widɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Bəni bəchi i kwili wiwɔ wə i yisi i bənchiŋ bənchiŋ i tsə buku i bəmbum bəmbum wə, nya ntuni i wi ka dzakaki a, “Mi wələ kɔ ŋga bi Nyɔ biə bə bɔɔŋki a, Ŋga bi Mbum.” ");
INSERT INTO cug_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Bɔ nì nya ntuni i wi yakadəiŋ, kɔm wi nì kɔ wi si chusi mfim i jɔbi wi dəəŋ wə bəni yɛiŋ dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ayakalə, i jɔbi wə Filib nì dzə ka fukuki kɔm ntum wi ndzɔŋni kɔm ŋkuŋ bi Nyɔ, bəh kɔm yɛli wi Jisɔs Klistus, bənyuku bəh bəkaŋa bum gia yə Filib nì fukuki wi ka juli bɔ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Samɔn wə mwi bum tə gia yə Filib nì fukuki, wi ka juli wi i bɔkɔ. Wi ka baaŋ a bəh Filib ka yɛiŋki gia yi kaŋyini yimbum yimbum bəh bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ, yə Filib nì fəki dzaka wɔm wi. ");
INSERT INTO cug_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Bwa bə faaŋni bə Jisɔs bi ka wɔkɔ i Jɛlusalɛm a bəni bə Samalia nì dzɔ lɔ gia yi Nyɔ, bɔ ka faaŋ Bita bəh Jɔn i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Bɔ tsə buku fɛiŋ, tsa i bəni bə bumni bə̀ a, bɔ kwati Kiŋ'waka ki Baiŋni, ");
INSERT INTO cug_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","kɔm Kiŋ'waka ki Baiŋni nì ka dzə dəkə na i mi wimu wə i bɔ wə. Bə nì juli bɔ i bɔkɔ shəŋ a i yɛli wi Bah Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Bita bəh Jɔn jiə kaŋ i bɔ wə tsa i bɔ, bɔ ka kwati Kiŋ'waka ki Baiŋni. ");
INSERT INTO cug_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jɔbi wə Samɔn nì yɛiŋ a bwa bə ntum bə Jisɔs jiəki kaŋ i bəni wə Kiŋ'waka ki Baiŋni dzə i bɔ wə, wi ka nyaki kpɔ i Bita bəh Jɔn, ");
INSERT INTO cug_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka dzakaki a, “Mbɛiŋ nyâ mih bəh ŋga biələ tə, ka na ndə wə mih jiə kaŋ yiŋ i wi wə, ma wi ni kwati Kiŋ'waka ki Baiŋni.” ");
INSERT INTO cug_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ayaka Bita chukuli i wi a, “Mbɛiŋ kpɔ wa wiwɔ lâka. Wɔ kɔ dəiŋ i kwakaki a wɔ kɔlə i taŋ kinya kə ki kɔ ki Nyɔ bəh kpɔ a? ");
INSERT INTO cug_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wɔ kaŋaki kə na gia yidɔkɔ i nɔm wələ kintəəŋ, kɔm shɔm ya baiŋki kə i Nyɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kwûni shɔm ya i gia yichu yələ wɔ fəki, ma wɔ tsâ yuwidɔkɔ Bah Nyɔ ni dalinya kiŋkwaka kichu kələ wɔ kaŋaki i shɔm ya wə. ");
INSERT INTO cug_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mih yɛ̂iŋ a, dzə́kəh yi bukuni bəh chu jikə i wɔ shɔm.” ");
INSERT INTO cug_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ayaka Samɔn tsa Bita bəh Jɔn a, “Mintee mbɛiŋ tsâ i mih i Bah, a gia yidɔkɔ i kintəəŋ ki gia yə mbɛiŋ dzaka lə, a yidɔkɔ ma nûm bəh mih.” ");
INSERT INTO cug_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Bita bəh Jɔn kaasi i fukuki gia yi Nyɔ, bəh i dzaka gia yə bɔ kiəki kɔm Jisɔs, ka nyə bə́ fiəni tsə i Jɛlusalɛm. Si bɔ nì fiəniki tsəki, bɔ nì tsəki daŋsiki lə i bidi biduli bi Samalia wə, fuku tsə ntum wi ndzɔŋni kɔm Nyɔ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ayaka chinda wi Bah dza dzaka i Filib a, “Dzâ shî tsə̂ i kimbu kishɛiŋ wə, i dzəh yə yi nyəki i Jɛlusalɛm yi tsə tɔli i chwa tsə sə i Gasa.” ");
INSERT INTO cug_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filib ka dza i shiki. Mi wimbum wi Itɔfia widɔkɔ num fɛiŋ dzəh. Mi wiwɔ num bə nì bwili wi, wi nì kɔ mi wə wi nì tsɛiŋki mbum bi Yaa Kanda wə wi nì sakaki tumi ki Itɔfia kiwɔ. Mi wiwɔ nì buku i Jɛlusalɛm i di biə wi nì tsə i tsa Nyɔ, ");
INSERT INTO cug_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ka fiəniki kwɛki i kɔdɔk wi bɛiŋ a guku num nyám, num wi num i yɛiŋ wə ka faaki gia i Kiŋwakti kə mi wi ntum wi Nyɔ Isaya nì nyaka. ");
INSERT INTO cug_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Kiŋ'waka ki Baiŋni dzaka i Filib a, “Kîni kɔ̂msi tsə̂ i kɔdɔk wəyaka wə.” ");
INSERT INTO cug_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filib yɔkɔ kɔmsi tsə i wi kpəŋ, wɔkɔ si mi wiwɔ faaki Kiŋwakti ki Isaya. Wi bikə i wi a, “Wɔ faaki lə wɔ wɔkɔ kiə gia yə ki dzakaki a?” ");
INSERT INTO cug_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wi chukuli a, “Mih kɔ i wɔkɔ kiə dəiŋ maka mi fuku baiŋsi yi i mih a?” Wi ka dzaka a Filib yâka nûm bəh wi i kɔdɔk wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Di biə wi nì faaki i Kiŋwakti kiwɔ wə nì dzakaki a, “Wi nì kɔ aka shwaŋ yə bə tsəki i kum, wi chu num tə aka waiŋ jaka wə bə kəə kiluli ki, yi də kə. Akɔ yakadəiŋ tə si wi nì kɔ a mɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Bɔ nì ŋgəmsi wi, nəiŋ i saka nsaka wi chəŋ. A bi dzə lansi dzakaki ndə kɔm bwa bu, num bə təiŋ lɔ nɔni ki i fa kuku a?” ");
INSERT INTO cug_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ayaka mi wimbum wiwɔ dzaka i Filib a, “Mintee, fuku mih, mi wi ntum wi Nyɔ wələ dzakaki kɔm ndə a? Wi dzakaki kɔm gwu yi, ma kɔm mi widɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filib ka yisi a bəh di bi Kiŋwakti kiwɔ, ka fuku baiŋsi ntum wi ndzɔŋni wiwɔ kɔm Jisɔs i wi. ");
INSERT INTO cug_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Si bɔ wi nì tsəki səki i dzəh, bɔ ka tsə buku i di bidɔkɔ wə bɔkɔ num fɛiŋ. Mi wimbum wiwɔ dzaka a, “Yɛiŋ bɔkɔ fa, akɔ chu nəiŋ nə a wɔ ma jûli mih i bɔkɔ a?”  ");
INSERT INTO cug_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filib chukuli i wi a, “A kabə num a wɔ bum i Jisɔs Klistus bəh shɔm ya yichi mih juli wɔ i bɔkɔ.” Wi chukuli a, “Mih bum a Jisɔs Klistus kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Mi wimbum wiwɔ ka dzaka a bə nûm bəh kɔdɔk wiwɔ. Bɔ Filib shi tsə liə i bɔkɔ, Filib ka juli wi i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Asi bɔ buku yaka i bɔkɔ, Kiŋ'waka ki Bah Nyɔ chufi nyə bəh Filib fɛiŋ, mi wimbum wiwɔ na chu yɛiŋ i wi wə. Ayakalə, wi nyə ka laŋki tsəki mfih. ");
INSERT INTO cug_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filib dza ka təkəli yɛiŋ wi num lɔ i Asɔtus, wi dza ka tɔliki tsəki bəh dzəh i kwili wiwɔ bichi, fuku tsə ntum wi ndzɔŋni wi Nyɔ, ka tsə buku i tumi ki Kaysalia wə. ");
INSERT INTO cug_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A nì kɔ i jɔbi wiwɔ wə, Sɔɔl kɛiŋ shili gumsi bəni bə mbaŋ wi Bah a ŋgaiŋ ni wɔ̂ɔyi lə bɔ. Wi ka tsə i fwu wi bətii mfə gia, ");
INSERT INTO cug_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","bikə biŋwakti a ŋgaiŋ tsə bəh bi i júŋ yi tsani wə i Damaskus, biə bi chusiki a ŋgaiŋ ka yɛiŋ bəni num fɛiŋ bə̀ bɔ biəliki Dzəh yi Bah, na bənyuku bəh bəkaŋa, ma ŋgaiŋ ni kwâ kâŋa fîəni dzə̂ bəh bɔ i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wi nya, Sɔɔl nyə ka tsəki i Damaskus, si wi nì kɔmsiki tsəki i kwili wiwɔ wə, baiŋni bidɔkɔ nyə a bɛiŋ lə, baiŋ shi dzə i wi wə. ");
INSERT INTO cug_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wi gbɔ i kuku, wɔkɔ ja dzaka i wi a, “Sɔɔl, Sɔɔl, akɔ kɔm nə wɔ bwaŋki gvu i mih chɛiŋ lə a?” ");
INSERT INTO cug_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Wi bikə a, “Bah, akɔ wɔ ndə?” Ja yiwɔ chukuli a, “Akɔ mih Jisɔs, a num mih wə wɔ bwaŋki gvu i mih chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","I liə dzâ bɛiŋ, lîə tsə̂ i kwili mə, ma bə ni fuku i wɔ gia yə wɔ kaŋaki i fə̂.” ");
INSERT INTO cug_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Bəni bə̀ bɔ nì nyaniki bəh Sɔɔl chiŋ num fɛiŋ alə, si bɔ nì wɔkɔ ja yiwɔ, yɛiŋ kə i mi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔl ka dza bɛiŋ, dzaka a ŋgaiŋ yasi dzə́kəh yi, na chu yɛiŋ di. Bɔ ka kaŋa wi i tsɛiŋ wə, ka tati liə bəh wi i Damaskus. ");
INSERT INTO cug_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Wi tsə ka numki i kaŋ yitali wə yɛiŋ kə di. Wi ka numki yakadəiŋ, wi dzi kə fiɛŋ, nabə i mu tə fiɛŋ. ");
INSERT INTO cug_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Mi wi bumni widɔkɔ num fɛiŋ i Damaskus wiwɔ, yɛli wi num Ananias. Bah Jisɔs dza bɔɔŋ wi i fiɛŋ wə ka ndəmsi a, “Ananias.” Wi bum a, “Bah, bə mih lə fa.” ");
INSERT INTO cug_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bah dzaka i wi a, “Dzâ bɛiŋ, wɔ tsə̂ki i dzəh yə bə bɔɔŋki a Chəŋ, wɔ ka ni buku i kwili wi Judas wə, bîkə mi wi Tasus widɔkɔ wə bə bɔɔŋki a Sɔɔl. Wɔ̂kɔli, wi kɔ fɛiŋ wi tsaki, ");
INSERT INTO cug_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","wi si yɛiŋ lɔ mi widɔkɔ i fiɛŋ wə aka ndəmsi bə bɔɔŋ wi a Ananias, num wi si dzə jiə kaŋ yi i wi wə, a wi fiəni yɛiŋki di.” ");
INSERT INTO cug_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ayakalə, Ananias dzaka a, “Bah, mih kɔ num mih wɔkɔ lɔ i bəni bəduli kɔm mi wələ i gia yichu yə wi fəki i bəni bə̀ bɔ kɔ bə Nyɔ i kintəəŋ ki Jɛlusalɛm wə. ");
INSERT INTO cug_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wi dzə lə, num wi dzɔ ŋga i bətii mfə gia bəmbum, a ŋgaiŋ dzə̂ kwâyi bəni bəchi fa bə̀ bɔ tsaki bɔ bɔɔŋ yɛli wa.” ");
INSERT INTO cug_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bah chukuli i wi a, “Tsə̂ a tsəni. Mih babwili lɔ mi wiwɔ, ka mi wuŋ wi nɔm, wə wi ni fukuki kɔm yɛli wuŋ i bəni bə̀ bɔ kɔkə Bəju, bəh i bəŋkuŋ bəbɔ, bəh i bəni bə Islae. ");
INSERT INTO cug_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mih mwi ni chusi lə i wi si wi kaŋaki i yɛ̂iŋ ŋgəkə kɔm yɛli wuŋ.” ");
INSERT INTO cug_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ayakadəiŋ, Ananias ka tsə liə fɛiŋ dzu, jiə kaŋ yi i Sɔɔl wə, bɔɔŋ a, “Sɔɔl waiŋnih wuŋ, a faaŋ Bah Jisɔs mih. Akɔ wi Jisɔs wə wi ni chusi gwu yi i wɔ i dzəh i jɔbi wə wɔ ni dzəki fa. Wi faaŋ mih, a mih dzə fə ma wɔ fiəni yɛiŋki di, ma Kiŋ'waka ki Baiŋni dzə jikə i gwu ya wə.” ");
INSERT INTO cug_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Asi wi dzaka yakadəiŋ, fiɛŋ fidɔkɔ ka bibami nyə i dzə́kəh yi Sɔɔl wə, gbɔ i kuku, wi fiəni ka yɛiŋki di. Wi dza bɛiŋ, bɔ ka juli wi i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wi ka dzi, ŋga fiəni dzə i wi wə. Sɔɔl nɔ i Damaskus bəh mbaŋ wi bəni bə bumni, i kaŋ yidɔkɔ wə, ");
INSERT INTO cug_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","wi ka yisi akisəkə ka tsəki i júŋ yi tsani wə, fuku a, “Jisɔs kɔ Waiŋ Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Bəni bəchi bə̀ bɔ nì wɔkɔki, bɔ ka kaiŋyiki a, “Wələ kɔkə a mi wə wi nì kaasiki bəni bə̀ bɔ nì tsaki bɔ bɔɔŋ yɛli wələ i Jɛlusalɛm a? Ntə wi dzə fa lə i kwayi bə̀ bɔ kɔ fa i chu tsə nya i kaŋ yi bətii mfə gia bəmbum wə a?” ");
INSERT INTO cug_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ayaka Sɔɔl baaŋ tsə a mfih i fukuki kɔm Jisɔs nalə, chusi a Jisɔs kɔ Kimbwili wə Nyɔ nì kaka. Bəju bə̀ bɔ nì kɔ i Damaskus məŋni gia yə bɔ kɔ i chukuli i wi. ");
INSERT INTO cug_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Asi kaŋ yiduli nì tsə, Bəju bəwɔ shinum, jiə kimfasi i wɔɔ Sɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bɔ ka dzəki shiki, bɔ wɔkɔli wi i dzaka ki mbaiŋ ki Damaskus wə, nchɔkɔ bəh nshiŋ, a wi bə́ tsə ma bɔ wɔɔ wi. Ayakalə, Sɔɔl kiə kimfasi kibɔ. ");
INSERT INTO cug_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bəni bu bə mbaŋ ka dzɔ wi nchɔkɔ, ləkə i kah mə, bwili i wundu wi mbaiŋ wə, shisi shi wi i kuku i biŋ. ");
INSERT INTO cug_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔl fiəni tsə i Jɛlusalɛm, ka nəŋki i chiŋni bəh mbaŋ wi bəni bə bumni, bɔ ka lwaki wi lwani, kɔm bɔ nì bumki kə a wi lansi kɔ mi wi mbaŋ wibɔ. ");
INSERT INTO cug_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ayakalə, Banabas dzɔ wi, bɔ wi tsə i bwa bə ntum bə Jisɔs. Wi fuku i bɔ asi Sɔɔl ni yɛiŋ Bah i dzəh Bah dzaka i wi, ka chu fuku i bɔ asi Sɔɔl nì fukuki kɔm Jisɔs i Damaskus lwa kə. ");
INSERT INTO cug_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ayakadəiŋ, Sɔɔl ka numki bəh bɔ nyani di bichi i Jɛlusalɛm, fuku kɔm Jisɔs, lwa kə. ");
INSERT INTO cug_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Wi ka dzakaki tə i Bəju bə̀ bɔ nì dzakaki já yi Glik, gukuli gia bəh bɔ, bɔ dza ka nəŋki i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Bəni bə bumni kiə a bə nəŋki i wɔɔ wi, ka dzɔ wi shi bəh wi i kwili wi Kaysalia wə, faaŋ tsə wi i Tasus . ");
INSERT INTO cug_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","I jɔbi wiwɔ wə, kijuŋni ki bəni bə bumni i bimbu bitumi bi Judea bəh bi Galili bəh bi Samalia, waka i ŋgəkə wə. Ayaka Kiŋ'waka ki Baiŋni fə bijuŋni biwɔ num, chu gamti mbaŋ wiwɔ kɔ tsə a ninshiŋ. Bɔ ka nɔki, kɔksi a Bah shəŋ. ");
INSERT INTO cug_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Bita bə́ nyani tsə i bəni bə̀ bɔ kɔ bə Nyɔ i bidi bichi wə, wi nyani tsə buku i bə̀ bɔ kɔ i Lida. ");
INSERT INTO cug_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Si wi nì kɔ fɛiŋ wi yɛiŋ mi widɔkɔ num wi kpi wa wimu, yɛli wi num Ɛnias, num wi fə jía nyaŋ i naŋ bɛiŋ wi nyani kə. ");
INSERT INTO cug_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Si Bita yɛiŋ wi ka bɔɔŋ a, “Ɛnias, Jisɔs Klistus si chuku wɔ. Dzâ yâka ma wɔ kîi kiga ka.” Akisəkə Ɛnias ka dza yaka bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bəni bə Lida bəh bəni bə baa wi Shalɔn wə yɛiŋ si mi wiwɔ bɔnih, bɔ jiə shɔm yibɔ i Bah Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","A nì kɔ kpaŋa widɔkɔ num i kwili wi Jɔba wə, a num mi wi bumni, yɛli wi num Tabita i já yi Alamiak wə, num Dɔkas i já yi Glik wə. Wi nì fəki lə gia yindzɔŋni jɔbi wichi, wi gamti bəni bə kifuu. ");
INSERT INTO cug_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I kaŋ yiwɔ wə wi gbɔ jwɛiŋ ka kpi. Bə wɔkɔ wini wi ka tsə nɔsi i lum widɔkɔ wə i juŋ yi bɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Si Jɔba nì kɔ kɔmsi i Lida, mbaŋ wi bəni bə bumni wɔkɔ a Bita kɔ i Lida, bɔ faaŋ bənyuku bəfa a bɔ tsə̂ tsâ wi, a wi tâiŋ a taiŋni wi ma mɔ̂ti. ");
INSERT INTO cug_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Bita ka dza yaka bəh bɔ ka tsəki, si wi tsə buku fɛiŋ, bɔ dzɔ wi ka yaka tsə bəh wi i lum wi juŋ wi bɛiŋ mə. Num bəkaŋa bəŋkwu bəchi fɛiŋ juŋni i wi kpəŋ, də chusi bəmbuŋ bə̀ Dɔkas nì tumki i jɔbi wə wi nì kɛiŋki wiwɔm bəh bɔ. ");
INSERT INTO cug_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bita bwili bəni bəchi i biŋ. Wi ka tum binyu bi i kuku ka tsa, dza fiəni gwu yi dzaka i wini wiwɔ a, “Tabita dzâ yaka!” Wi ka yasi dzə́kəh yi ka yɛiŋ Bita ka dza num i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bita kaŋa tsɛiŋ yi ka gamti wi, wi dzə num bəh gvu yi. Wi ka fiəni bɔɔŋ bəni bə̀ bɔ kɔ bə Nyɔ bəh bəkaŋa bəŋkwu bə, ka chusi Tabita i bɔ wi fiəni num wiwɔm. ");
INSERT INTO cug_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Gia yiwɔ waŋ tsə i Jɔba wichi. Bəni bəduli jiə shɔm yibɔ i Bah wə. ");
INSERT INTO cug_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bita num i Jɔba kaŋ yiduli, wi nɔ bəh mi widɔkɔ bə bɔɔŋ a Samɔn wə wi nì kɛiŋsiki dzu yi nyam. ");
INSERT INTO cug_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Mi widɔkɔ nì kɔlə i kwili wi Kaysalia wə bə bɔɔŋ a Kɔniliɔs, wi num fwu i mbaŋ wi bəni bə jum bədɔkɔ i Lum wə bə nì bɔɔŋki a wi Itali. ");
INSERT INTO cug_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wi nì kɔ mi num wi bəh chwɔŋ ki kijuŋ kichi jiə shɔm i Nyɔ nalə. Wi kɔksi Nyɔ chu tsa wi jɔbi wichi, chu nya kinya i bəni bə kifuu nalə. ");
INSERT INTO cug_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","A num chɔkɔ bidɔkɔ aka mbiəŋə mitali i fijɔbi, fiɛŋ fidɔkɔ ka ndəmsi dzə i wi, wi yɛiŋ chinda wi Nyɔ i ndəmsi biwɔ wə. Ayaka chinda wiwɔ liə dzə ka bɔɔŋ wi a, “Kɔniliɔs.” ");
INSERT INTO cug_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kɔniliɔs lwa, bwaŋ dzə́kəh i wi wə bikə a, “Tikwili, akɔ nə?” Chinda wiwɔ chukuli a, “Nyɔ kɔ wi wɔkɔ lɔ ntsa wa, ka chu yɛiŋ binya biə wɔ nyaki i bəni bə kifuu, ka kwaka wɔ. ");
INSERT INTO cug_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","I liə, fâaŋ bəni i Jɔba a bɔ tsə̂ bɔ̂ɔŋ mi widɔkɔ wə yɛli wi kɔ Samɔn, yɛli wi widɔkɔ num a Bita. ");
INSERT INTO cug_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wi nì dzə ka nɔki bəh Samɔn widɔkɔ wə wi si kɛiŋsi dzú yi nyám, juŋ yi num kɔmsi i kinchwɔ kimbum kpəŋ.” ");
INSERT INTO cug_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Si chinda wi Nyɔ wə dzaka yakadəiŋ ka nyə. Kɔniliɔs baaŋ ka bɔɔŋ bəni bu bə nɔm bəfa, chu bɔɔŋ tə mi wi jum widɔkɔ wə wi nì kɔ wi tɔkni bəh wi, ayaka a nì kɔ mi num wi jiə tə shɔm i Nyɔ nalə. ");
INSERT INTO cug_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Bɔ dzə, wi fuku gia yichi yə yi si num i bɔ, ka faaŋ bɔ i Jɔba. ");
INSERT INTO cug_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Asi chɔkɔ nì buku wɔɔ, a num asi wɔŋ nì kɔ a yaka lumsi, a num jɔbi wə bɔ nì kɔmsiki dzəki i kwili wi Jɔba wiwɔ wə. Bita dza yaka tsə i kimbu ki juŋ ki bɛiŋ wə i tsa. ");
INSERT INTO cug_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Dzɔŋ yisi i wɔɔki wi, wi bə̀ nəŋ fiɛŋ i dzi, ayaka bə kɛiŋ fə biɛiŋ bidzini. Fiɛŋ fidɔkɔ ka ndəmsi dzə i wi. ");
INSERT INTO cug_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Wi yɛiŋ i fiɛŋ fiwɔ mə, si bɔɔli wɛli, fiɛŋ fidɔkɔ shi dzə i bɛiŋ num aka fwu wimbuŋ, num bə kaŋa i bimbu binaa wə fi shi dzə fa kuku. ");
INSERT INTO cug_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","I yɛiŋ kintəəŋ num ŋgɔkɔ yi nyám yichi, yə yi nyaniki, bəh yə yi sɛiŋki kuku, bəh minyəni mə mɔ fuliki bɛiŋ, num i mbuŋ wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ja dza dzaka i wi a, “Bita, dzâ bɛiŋ kûm dzî.” ");
INSERT INTO cug_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bita chukuli a, “Bah, mih kɔkə i mɔm, kɔm mih kɛiŋki ki dzi kə fiɛŋ fi kilɔlɔ nabə fiə fi baiŋki kə.” ");
INSERT INTO cug_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ja yiwɔ chu dzaka kpɛiŋsi i wi a, “Kiə wɔ ki nyɛ̂ŋsi kə fiɛŋ fiə Nyɔ kɔ wi fə fi num fibaiŋni.” ");
INSERT INTO cug_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Yi num ayaka i buku kiŋkani kitali, bə ka fiəni giŋsi fiɛŋ fiwɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Bita ka məŋki a gia yə yi dzə i wi lə chusiki a nə. A jɔbi wiwɔ wə bəni bə̀ Kɔniliɔs nì faaŋ, num bɔ dzə ka bikəki kwili wi Samɔn wə wi kɛiŋsiki dzú. Num bɔ si num lɔ a dzaka ki mbaiŋ kiwɔ wə, ");
INSERT INTO cug_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ka bɔɔŋki bikəyi a, “Mi wi dzəni widɔkɔ kɔ alə fa yɛli num Samɔn Bita a?” ");
INSERT INTO cug_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Si Bita nì kɛiŋki wi kwaka kɔm gia yə yi num i wi, Kiŋ'waka ki Baiŋni dzaka i wi a, “Yɛ̂iŋ, bəni bətali nəŋki wɔ. ");
INSERT INTO cug_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Dzâ bɛiŋ, ma wɔ shî mbɛiŋ bɔ tsə̂ki gvu wimu. Kiə wɔ ki gûku kə gwu, a faaŋ mih bɔ.” ");
INSERT INTO cug_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ayakadəiŋ, Bita ka nyə shi tsə, dzaka i bəni bəwɔ a, “Akɔ mih wə mbɛiŋ nəŋki. Mbɛiŋ dzə a nə?” ");
INSERT INTO cug_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Bɔ chukuli a, “Kɔniliɔs wə wi kɔ fwu i mbaŋ wi bəni bə jum bədɔkɔ i Lum si faaŋ buku. Wi kɔ mi wi chəŋ, wi lwa Nyɔ, ayaka Bəju bəchi kɔksi wi. Chinda wi baiŋni widɔkɔ nì kɔ wi dzaka i wi a, a wi chîŋsi ntum i wɔ a wɔ dzə̂ i ŋgaiŋ dzu, ka wi wɔkɔ gia yə wɔ ni dzaka i wi.” ");
INSERT INTO cug_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Si bɔ chukuli yakadəiŋ, Bita ka dzaka a, bɔ lîə ma bəh bɔ nɔ̂. Si chɔkɔ buku wɔɔ, wi nyə bəh bɔ ka tsəki. Bəni bə bumni bə Jɔba bədɔkɔ biəli wi. ");
INSERT INTO cug_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Bɔ nyani lə ka nɔ i dzəh, chɔkɔ buku wɔɔ ka bɔ liə i Kaysalia. Kɔniliɔs bəh bəni bu bə chwɔŋkijuŋ bəh nsɛ́iŋ yi yi shɔm, bəh bəni bə̀ wi nì laka nì wɔkɔliki bɔ. ");
INSERT INTO cug_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Asi Bita nì liəki tsəki yɛiŋ dzu bɔ Kɔniliɔs baŋsi. Kɔniliɔs gbɔ i wi nshiŋ kɔksi wi. ");
INSERT INTO cug_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ayakalə, Bita dzasi wi i bɛiŋ ka dzaka a, “Dzâ bɛiŋ, mih kɔ tə mfiŋ a mi wiwɔm ka wɔ.” ");
INSERT INTO cug_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Wi nì dzakaki bəh Kɔniliɔs bɔ wi liə tsə i dzu, si bɔ liə tsə, wi yɛiŋ num bəni num fiəli baŋsi i dzu. ");
INSERT INTO cug_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Wi dzaka i bɔ a, “Mbɛiŋ kiəki lə bindzɔŋ a, nchi wibuku bûmki kə, a mi wi Ju lâa njikə nabə i tâsi nsɛiŋ bəh mi wə wi kɔkə mi wi Ju. Ayakalə, Nyɔ chusi i mih a mih kaŋaki kə i bɔ̂ɔŋki mi widɔkɔ a, wi kɔ mi wi kilɔlɔ nabə a wi baiŋki kə. ");
INSERT INTO cug_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ayakadəiŋ, jɔbi wə mbɛiŋ si faaŋ ntum a mih dzə̂, mih si ka nəiŋ dəkə i dzə, mih ka dzə. I liə mih bikəki i mbɛiŋ a, akɔ kɔm nə mbɛiŋ si bɔɔŋki mih a?” ");
INSERT INTO cug_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kɔniliɔs ka chukuli a, “Daiŋ si num kaŋ yina si mih nì kɔ i mih dzu mih tsa, a nì kɔ ka jɔbi wələ wə i mbiəŋə witali wə nshifɔkɔ. I fɛiŋ wə mi widɔkɔ num wi tum bəmbuŋ bə mwaŋyini i gwu wə, dza təkəli tumbuku alə i mih nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Wi dzaka i mih a, ‘Kɔniliɔs, Nyɔ wɔkɔ lɔ ntsa wa, ka yɛiŋ kinya kə wɔ nyaki i bəni bə kifuu wi ka kwaka wɔ. ");
INSERT INTO cug_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ayakadəiŋ, fâaŋ bəni i Jɔba a bɔ tsə̂ bɔ̂ɔŋ mi widɔkɔ wə yɛli wi kɔ Samɔn, widɔkɔ num a Bita. Wi nì dzə ka nɔki bəh Samɔn wə wi si kɛiŋsi dzú yi nyám, kwili wi num kɔmsi i kinchwɔ kimbum kpəŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Akisəkə mih ka faaŋ ntum a wɔ dzə̂. Si wɔ dzə lə, yi ndzɔŋ nalə. I liə buku kɔ i Nyɔ nshiŋ i wɔkɔ gia yə Bah si faaŋ wɔ a wɔ dzə̂ fûku i buku.” ");
INSERT INTO cug_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bita ka yisi i dzakaki a, “Mih yɛiŋ ŋkɔŋ ŋkɔŋ a, Nyɔ chusiki kə chi chi. ");
INSERT INTO cug_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Mi wichi wə wi lwaki Nyɔ chu fə gia yə yi kɔ chəŋ i Nyɔ nshiŋ, wəmaka mi kɔ num Nyɔ dzɔki lə wi, kɔŋ wi numki na mi wi tumi kinaiŋ. ");
INSERT INTO cug_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mbɛiŋ kiəki lə ntum wə Nyɔ nì chiŋsi i bəni bə Islae, fuku ntum wi ndzɔŋni a Jisɔs Klistus nì dzə ka kimbɔiŋni nûmki. Jisɔs Klistus wələ kɔ Tikwili wi bəni bəchi. ");
INSERT INTO cug_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mbɛiŋ kiəki lə gia yə yi nì num i tumi ki Judea wə kichi, yi nì yisi i Galili asi jɔbi wə Jɔn nì fukuki ntum wi ndzɔŋni juli bəni i bɔkɔ nì tsə. ");
INSERT INTO cug_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mbɛiŋ kiəki lə tə si Nyɔ nì shuku Kiŋ'waka ki Baiŋni i Jisɔs wi Nasali wə, chu nya ŋga i wi, ka num bəh wi. Si Nyɔ nì num bəh wi, wi yisi i nyaniki i di bichi wə, fə nɔm wi ndzɔŋni chu chuku bəni bə̀ Satan nì chəbsiki bɔ. ");
INSERT INTO cug_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Akɔ buku bə̀ buku nì yɛiŋ gia yə wi nì fəki i tumi ki Bəju wə kichi bəh yə wi nì fəki i Jɛlusalɛm. Bə nì baŋŋ wi i kintasi wə wi kpi. ");
INSERT INTO cug_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Ayakalə, asi kaŋ yitali nì kpɛiŋ, Nyɔ dzasi wi i kpi wə, fə bəni yɛiŋ wi. ");
INSERT INTO cug_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A nì kɔkə bəni bəchi bə̀ bɔ nì yɛiŋ wi, a nì yɛiŋ a buku bə̀ wi Nyɔ nì sabi a buku fûkuki kɔm Jisɔs. Buku nì dzi ka mu bəh Jisɔs i jɔbi wə wi nì dza i kpi wə. ");
INSERT INTO cug_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Wi dzaka a, buku bi fûkuki ntum wi Nyɔ i bəni, chu fûku i bɔ a, ŋgaiŋ kɔ wə Nyɔ nì babwili a ŋgaiŋ bi sakaki bəni bəwɔm bəh bəkpili. ");
INSERT INTO cug_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jisɔs wələ kɔ wi wə bəni bə ntum bə Nyɔ bəchi nì dzakaki kɔm wi a, na ndə wə wi jiə shɔm yi i wi ma Nyɔ bi dalinya chu bi, tsə dzəh i yɛli wi wə.” ");
INSERT INTO cug_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Asi Bita nì kɛiŋki wi dzaka gia yiwɔ, Kiŋ'waka ki Baiŋni nyə shi dzə i mi wichi wə wi nì kɔ fɛiŋ wi wɔkɔli ndzaka wiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Dzaka wɔm bəni bə bumni bə̀ Bəju bə̀ bɔ nì biəli Bita, si bɔ nì yɛiŋ a, Nyɔ nya tə kinya ki kə ki kɔ Kiŋ'waka ki Baiŋni i bəni bə̀ bɔ kɔkə Bəju. ");
INSERT INTO cug_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bəju bəwɔ wɔkɔ si bɔ dzakaki i já yə bɔ kiəki kə, yaksi Nyɔ, Bita ka bikə a, ");
INSERT INTO cug_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“I liə si Kiŋ'waka ki Baiŋni dzə i bəni bələ wə asi ki nì dzə i bukumbɛiŋ wə, akɔ ndə wə wi kɔ i nəiŋ a bə ma juli bɔ i bɔkɔ a?” ");
INSERT INTO cug_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Si Bita bikə yakadəiŋ, ka dzaka a bə jûli bɔ i bɔkɔ i yɛli wi Jisɔs Klistus wə. I fɛiŋ wə, bɔ ka tsa wi a, wi nɔ̂ baaŋ bəh bɔ i kaŋ yidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Bwa bə faaŋni bə Jisɔs bəh bəni bə bumni bə Judea bəchi ka wɔkɔ a bəni bə̀ bɔ kɔkə Bəju ni dzɔ tə gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jɔbi wə Bita nì fiəni yaka tsə i Jɛlusalɛm, bəni bə bumni bədɔkɔ ka sakaki wi. Bəni bələ kɔ bəni bə̀ bɔ nì bwaŋki a bə kaŋaki i suuŋ mi wə wi kɔkə wi Ju, ka wi numki mi wi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Bɔ ka sakaki wi bikə a, “Wɔ si nyani dəiŋ i laa njikə i bəni bə̀ bɔ kɛiŋki maka bə̀ suuŋ bɔ, chu fiəni dzi mbɛiŋ bɔ kɔm nə a?” ");
INSERT INTO cug_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Bita ka kɛiŋsi fuku baiŋsi gia yichi yə yi si num, ka dzaka i bɔ a, ");
INSERT INTO cug_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Mih nì kɔ i kwili wi Jɔba wə mih tsa, fiɛŋ fidɔkɔ ka ndəmsi dzə i mih. Mih tsɛiŋ i fiɛŋ fiwɔ kintəəŋ ka yɛiŋ fiɛŋ fidɔkɔ shi dzə i bɛiŋ num aka fwu wimbuŋ num bə kaŋa i bimbu binaa wə. Ayaka fi shi dzə ka num i mih nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mih tsɛiŋ ndzɔŋ i yɛiŋ kintəəŋ, yɛiŋ ŋgɔkɔ yi nyám yichi a chwɔŋkijuŋ chwɔŋkijuŋ wə, yidɔkɔ num yi dzu, yidɔkɔ num yi chwa bəh yə yi sɛiŋki kuku, bəh minyəni mə mɔ fuliki i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mih dza wɔkɔ ja yi dzaka i mih a, ‘Bita, dzâ bɛiŋ kûm dzî.’ ");
INSERT INTO cug_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mih ka chukuli a, ‘Bah, mih kɔkə i mɔm, kɔm mih kɛiŋki ki dzi kə fiɛŋ fi kilɔlɔ nabə fiə fi baiŋki kə, fi ka num liə dəkə i dzaka kəŋŋ wə.’ ");
INSERT INTO cug_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ja yiwɔ chu dzaka kpɛiŋsi i mih a, ‘Kiə wɔ ki nyɛ̂ŋsi kə fiɛŋ fiə Nyɔ kɔ wi fə fi fi baiŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gia yiwɔ num yaka i buku kiŋkani kitali, bə ka fiəni guku yakasi fiɛŋ fiwɔ fichi i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","A jɔbi wiwɔ wə, bəni bədɔkɔ bətali dzə buku i juŋ yə mih nì nɔki yɛiŋ, num bɔ nyə i Kaysalia, num bə fâaŋ bɔ a bɔ dzə̂ bɔ̂ɔŋ mih. ");
INSERT INTO cug_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kiŋ'waka ki Baiŋni dzaka i mih a, mih ma nyɛŋsi i tsə bəh bəni bəwɔ. Ayaka bwa bə nih bəbuku bələ bəsɔ i Jɔba, biəli mih, buku bɔ bəchi chiŋni tsə liə i juŋ yi mi wiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Si buku tsə liə, wi fuku i buku a, ŋgaiŋ si yɛiŋ chinda wi Nyɔ i ŋgaiŋ dzu, wi dzaka a ŋgaiŋ fâaŋ mi i Jɔba a wi tsə bɔɔŋ mi widɔkɔ wə bə bɔɔŋki a Samɔn Bita. ");
INSERT INTO cug_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mi wiwɔ ni dzə lə bəh ntum wə ŋgaiŋ bəh bəni bəchi bə̀ bɔ kɔ i ŋgaiŋ dzu ni bɔiŋ. ");
INSERT INTO cug_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Asi mih nì yisi ndzaka, Kiŋ'waka ki Baiŋni nyə shi dzə i bəni bəwɔ bɛiŋ a liŋ asi ki nì dzə i bukumbɛiŋ i kin'yisi wə. ");
INSERT INTO cug_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ayaka si mih yɛiŋ yakadəiŋ, ka kwaka gia yə Bah nì dzaka a, ‘Jɔn nì juliki bəni i bɔkɔ, ayakalə, Nyɔ bi juliki mbɛiŋ num i Kiŋ'waka ki Baiŋni wə.’ ");
INSERT INTO cug_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Si Nyɔ kɔ num wi nya bəni bəwɔ bə kinya a num kə wi nì nya i bukumbɛiŋ i jɔbi wə bukumbɛiŋ nì jiə shɔm i Bah Jisɔs Klistus, mih si kɔ numki ndə i nəiŋ gia yə a fəki Nyɔ a?” ");
INSERT INTO cug_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","I jɔbi wə bəni bəwɔ nì wɔkɔ si Bita dzaka yakadəiŋ, bɔ na chu saka wi. Ayaka bɔ ka dza yisi ka kɔksiki Nyɔ, dzakayi a, “Aka bə num yakadəiŋ, yaka kɔ a Nyɔ nya tə dzə i bəni bə̀ bɔ kɔkə Bəju, a bɔ kwûni shɔ́m yibɔ i ni kwati nɔni kə ki bi tsə kaa kə.” ");
INSERT INTO cug_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bəni bə bumni bə̀ bɔ nì gaali si ŋgəkə nì yisi i jɔbi wə bə nì wɔɔ Stifɛn, bɔ nì waŋ tsə i di di wə tsə buku i Fɔnishia, bədɔkɔ tsə num i Sayblus, bədɔkɔ i Antiɔk. Si bɔ tsə yaka, ka fukuki ntum wi Nyɔ num a i Bəju shəŋ. ");
INSERT INTO cug_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ayakalə, bəni bə bumni bədɔkɔ bɔ nì buku dzə i Sayblus bəh i Sɛlin, tsə i Antiɔk ka fukuki tə ntum wi ndzɔŋni wiwɔ kɔm Bah Jisɔs i bəni bə̀ bɔ kɔkə Bəju. ");
INSERT INTO cug_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","I ŋga bi Bah Nyɔ wə, bɔ fə bəni bəduli jiə shɔm i Bah Jisɔs wə, ka kwuni fiəni chu i wi. ");
INSERT INTO cug_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ntum kɔm gia yələ ka liə i ntuni ki mbaŋ wi bəni bə bumni bə i Jɛlusalɛm. Bɔ ka faaŋ Banabas i fɛiŋ Antiɔk. ");
INSERT INTO cug_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Jɔbi wə wi nì tsə buku fɛiŋ, ka yɛiŋ si Nyɔ chusi kiŋkɔŋ, gia yiwɔ ndzɔŋ i wi, wi ka təfiki bɔ a bɔ bîəli Bah bəh shɔ́m yibɔ yichi. ");
INSERT INTO cug_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas wələ nì kɔ mi wi ndzɔŋni, num wi jikə bəh Kiŋ'waka ki Baiŋni chu kaŋa kimbum nalə. Ayakadəiŋ, wi fə bəni bəduli fɛiŋ jiə shɔ́m yibɔ i Bah. ");
INSERT INTO cug_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Banabas ka dza tsə i Tasus i nəŋ Sɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wi nəŋ yɛiŋ wi, ka dzɔ wi, bɔ wi fiəni chu i Antiɔk. Bɔ wi num fɛiŋ i jia yichili wə bəh kijuŋni ki bəni bə bumni, lani bəni bəduli. A nì kɔ i fɛiŋ Antiɔk bə nì yisi i bɔɔŋki mbaŋ wi bəni bə bumni a, bəni bə Klistus. ");
INSERT INTO cug_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","A jɔbi wiwɔ wə, bəni bədɔkɔ bə̀ bɔ si fuku i bəni gia yə Nyɔ dzaka i bɔ, nyə i Jɛlusalɛm shi tsə i Antiɔk. ");
INSERT INTO cug_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kiŋ'waka ki Baiŋni fə mi wə yɛli wi nì kɔ Agabus wi ka dza num bɛiŋ, laka a dzɔŋ yiləkəli bi kwa lə kitumi kiwɔ kichi. Dzɔŋ yiwɔ nì dzə dzɔ di num i jɔbi wə Klawdius nì kɔ ŋkuŋ wi Lum. ");
INSERT INTO cug_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Mbaŋ wi bəni bə bumni i Antiɔk wɔkɔ yakadəiŋ, kɛiŋsi a mi wichi tsû kpɔ si wi kaŋaki, ma bɔ ni gâmti bwa bə nih bəbɔ, bə̀ bɔ kɔ i Judea bəh wi. ");
INSERT INTO cug_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Bɔ ka tsu, ka faaŋ Banabas bəh Sɔɔl, a bɔ tsə̂ nyâ i bətii kijuŋni ki bəni bə bumni fɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","A nì kɔ i jɔbi wiwɔ wə, Ŋkuŋ Hɛlɔd nì yisi i nyaki ŋgəkə i kijuŋni ki bəni bə bumni bədɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Wi dzaka bə gba wɔɔ Jɛm waiŋnih Jɔn bəh nywɔ. ");
INSERT INTO cug_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wi yɛiŋ a yi ndzɔŋki lə i Bəju, wi bə́ tsə a bəh yi i ninshiŋ dzaka bə kwa tə Bita. Bɔ nì kwa wi a num i kaŋ yi Dzini bi Blɛd wə bə ka jiə dəkə dzɔɔŋ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Si bɔ kwa wi, ka fah i juŋ yi nsəŋ mə, jiə mbaŋ wi bəni bə jum bənaa, a bɔ chə̂niki wi bəni bənaa bənaa. Hɛlɔd nì jiə Bita yaka a Dzini bi Ntsədaŋ kaa, ka wi bwîli jîə wi i bəni nshiŋ ma bɔ sâka wi. ");
INSERT INTO cug_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bita ka numki a i juŋ yi nsəŋ mə. Ayakalə, kijuŋni ki bəni bə bumni ka tsaki Nyɔ kɔm wi nalə. ");
INSERT INTO cug_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","A bə́ num nchɔkɔ ka chɔkɔ buku wɔɔ a Hɛlɔd bwili Bita ma bɔ saka wi, Bita nì nɔki i fintəŋ fi bəni bə jum wə bəfa num bɔ kaŋa wi bəh bənsəŋ bəfa, ka chəniki. Bəni bə jum bədɔkɔ num i dzaka kifiəŋə wə chəəŋni juŋ yi nsəŋ yiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yi num a chinda wi Bah nì dza tumbuku alə, baiŋni baiŋ i juŋ yi nsəŋ yiwɔ mə. Chinda wiwɔ kɔmyi Bita i kimbəkəli wə, wi yɔmi. Chinda wiwɔ dzaka i wi a, “Dzâ yaka bɛiŋ wakli.” Si wi dzaka yakadəiŋ, bənsəŋ bə̀ ka shwali i tsɛiŋ yi Bita wə gbɔyi i kuku. ");
INSERT INTO cug_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wi chu dzaka i wi a, “Lɔ̂h mbuŋ i gwu ya wə, ma wɔ ləkə dzú ya yigvu.” Bita ka fə ayaka. Chinda wiwɔ chu dzaka a, “Kîi mbuŋ wa ma wɔ bîəli mih.” ");
INSERT INTO cug_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bita kii, ka biəli wi i biŋ. Asi wi tsəki wi na kiə gia yələ chinda wiwɔ fəki akɔ ŋkɔŋ. Wi nì kwakaki a akɔ fiɛŋ ka ndəmsi si fi dzə i wi. ");
INSERT INTO cug_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Bɔ wi nyani tsə daŋsi di bi ninshiŋ, i di biə bəni bə jum bə̀ nì chəniki, chu tsə bi kɔmsini, ka dzə i dzaka ki mbaiŋ kə ki bukuki tsəki i kwili wə, num bɔ nì kɛiŋsi bəh chwaka. Ayaka dzaka ki mbaiŋ kiwɔ wɛli a ki, bɔ buku. Si bɔ buku yaka, ka nyaniki shiki tsəki a dzəh dzəh, chinda wi Bah Nyɔ wiwɔ ka nyə laka i wi nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Bita baaŋ, mfi bi fiəni dzə wi dzaka a, “I liə mih kiə lɔ a, akɔ ŋkɔŋ a asi faaŋ Bah chinda wi a wi dzə̂ bwîli mih i kaŋ yi Hɛlɔd wə, ka mih bɔiŋ i ŋgəkə wə Bəju ni wɔkɔliki a bɔ ni nyaki i mih.” ");
INSERT INTO cug_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Si wi kiə yakadəiŋ, ka dza tsə i Meli dzu nih Jɔn Mak, bəni num fɛiŋ bə juŋni bəduli tsa wə. ");
INSERT INTO cug_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Wi tsə buku fɛiŋ, kɔmyi dzaka ki mbaiŋ, waiŋ kpaŋni widɔkɔ yɛli wi num Lɔda, wə wi nì nɔmki i yɛiŋ dzu dzə i wɛli. ");
INSERT INTO cug_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ayaka wi ka wɔkɔ num ja yi Bita, kinsaŋli dzɔ wi, wi na wɛli dzaka ki mbaiŋ kiwɔ, wi fiəni yɔkɔ liə tsə lɔ i dzu, fuku i bəni a, “Bita kɔ dzaka ki mbaiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Bɔ chukuli i wi a, “Wɔ dzaki lə.” Ayaka wi baaŋ a bəh ndzaka a akɔ Bita. Bɔ ka dza dzaka a “A kɔlə numki chinda wi wi Nyɔ.” ");
INSERT INTO cug_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Si bɔ nì dzakaki yakadəiŋ, Bita baaŋ a kɔmyiki. Bɔ ka wɛli, yɛiŋ ŋkɔŋ a num wi, dzaka wɔm bɔ. ");
INSERT INTO cug_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wi fəkəni bəh kaŋ a bɔ baŋ dzaka, ka fuku i bɔ si Bah si bwili wi i juŋ yi nsəŋ mə, chu dzaka a bɔ fûku i Jɛm bəh i bəni bə bumni bəchi. Si wi dzaka yakadəiŋ, ka dza tsə i di bidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Chɔkɔ wɔɔ, mfi bi bəni bə jum ka shakyi shakyini a, a num nə bəh Bita. ");
INSERT INTO cug_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hɛlɔd bwili bəni a bɔ nyâni nə̂ŋ wi. Bɔ nəŋ, nəŋ mɔŋ. Wi ka bɔɔŋ bəni bə jum bə̀ bɔ nì chəniki Bita bikə gia i bɔ, ka dza dzaka a bə dzɔ̂ bɔ bə tsə̂ lâksi. I jum wə fɛiŋ, Hɛlɔd nyə i kimbu ki tumi ki Judea wə, shi tsə ka numki i kwili wi Kaysalia wə. ");
INSERT INTO cug_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","A num i jɔbi wiwɔ wə Ŋkuŋ Hɛlɔd nì bɔksiki shɔm bəh bəni bə Taya bəh bə Sidɔn. Bəni bəwɔ ka juŋni gwu i tsə kwuŋ kaŋ a kimbɔiŋni nûmki, kɔm tumi kibɔ nì kwatiki biɛiŋ bidzini num i tumi kiwɔ wə. Ayaka bɔ tsə, yisi kwa nsɛiŋ bəh Blastus wə wi nì kɔ tantɔ. ");
INSERT INTO cug_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Chɔkɔ ka dzə kpɛiŋ, Ŋkuŋ Hɛlɔd tum bəmbuŋ bə kwili i gwu wə, shinum i kiŋgbɔkɔ wə, ka tsəsi ja i bəni bəwɔ. ");
INSERT INTO cug_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Bɔ nyə ka wiliki, kɔksi wi dzakayi a, “Wələ ndzaka kɔ wi nyɔ, a kɔkə i numki wi mi wiwɔm.” ");
INSERT INTO cug_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Akisəkə, chinda wi Bah ka faaŋ jwɛiŋ i Ŋkuŋ Hɛlɔd wə, kɔm wi nì ka daŋsi dəkə kiŋkɔksi kiwɔ i Nyɔ. Ayaka ŋgɛni ka dzi wi, wi kpi. ");
INSERT INTO cug_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ayakalə, gia yi Nyɔ ka liəki i shɔ́m yi bəni wə, waŋ tsə a ninshiŋ ninshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Banabas bəh Sɔɔl ka kaasi gia yə bə nì faaŋ bɔ i Jɛlusalɛm, ka fiəni tsə i Antiɔk. Si bɔ nì fiəniki tsəki bɔ dzɔ Jɔn Mak. ");
INSERT INTO cug_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Bəni bədɔkɔ nì kɔ i kijuŋni ki bəni bə bumni wə i Antiɔk, a num bə̀ bɔ nì fukuki gia yə bɔ nì wɔkɔki Nyɔ dzaka, chu lani bəni. Bəni bəwɔ nì kɔ Banabas bəh Semeɔn wə bə nì bɔɔŋki a Wi Jisi, bəh Lushus wi Sɛlin bəh Sɔɔl bəh Manɛɛn wə bə nì kuku yaka bəh Hɛlɔd mi wi nsaka ");
INSERT INTO cug_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Si bɔ nì bamki dzaka tsa Bah, Kiŋ'waka ki Baiŋni dza dzaka i bɔ a, “Mbɛiŋ bâbwili jîə Banabas bəh Sɔɔl chi chi, i nɔmki nɔm wə mih bɔɔŋ bɔ a bɔ nɔmki.” ");
INSERT INTO cug_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Bɔ wɔkɔ yakadəiŋ baaŋ a bamki dzaka tsa, si yəmaka tsə bɔ ka jiə kaŋ i bɔ fuŋ ka chiŋsi bɔ, bɔ ka tsəki. ");
INSERT INTO cug_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Banabas bəh Sɔɔl ka dza ka tsəki asi Kiŋ'waka ki Baiŋni nì faaŋ bɔ. Bɔ nyə shi tsə i tumi ki Sɛlusia wə, liə i ŋgwuki wimbum mə i bɔkɔ, ka daŋki tsəki i tumi ki Sayblus wə. ");
INSERT INTO cug_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Asi bɔ nì daŋ buku i kwili wi Salamis wə, bɔ ka nyaniki fukuki gia yi Nyɔ i júŋ yi tsani yi Bəju wə. Num Jɔn Mak nì nyaniki bəh bɔ wi gamti bɔ. ");
INSERT INTO cug_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Bɔ nì nyani tɔli i tumi bi bɔkɔ bichi kintəəŋ, daŋsi tsə buku na i kwili wi Bafɔs wə. Si bɔ tsə bɔ tumbuku i mi wi Ju widɔkɔ wə fɛiŋ, a num mi wi mfim yɛli wi num Bal Jisɔs, wi nì shiki nyiki ntəkə a ŋgaiŋ kɔ mi wə wi fukuki gia yə ŋgaiŋ si wɔkɔ si Nyɔ dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wi nì shiki a bɔ Sɛgus Bɔɔlus wə wi nì sakaki tumi kiwɔ. Mi wi nsaka wiwɔ nì kɔ mi wi kaŋa mfi nalə. Wi dza bɔɔŋ Banabas bəh Sɔɔl kɔm wi nì nəŋki i wɔkɔ gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bɔ dzə, ayakalə Ɛlimas mi wi mfim asi yɛli wiwɔ kɔ i já yi Glik wə ka jwɔki a bɔ ma fə̂ a mi wi nsaka wiwɔ jîə shɔm i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kiŋ'waka ki Baiŋni jikə i Sɔɔl, wə yɛli wi widɔkɔ nì kɔ a Bɔɔl, wi bwaŋ dzə́kəh i mi wi mfim wiwɔ wə, ");
INSERT INTO cug_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","dzaka i wi a, “Wɔ kɔ waiŋ Satan, wɔ kɔ mi wə wi baiŋŋki gia yichi yə yi kɔ yindzɔŋni. Mfwɔkyi bəh ntəkə kɔ bi jikə i wɔ shɔm. Yaka wɔ mɔŋ i baaŋ maka wɔ kwuni ŋkɔŋ wi Bah a bi fiəni ntəkə a? ");
INSERT INTO cug_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wɔ̂kɔli, tsɛiŋ yi Bah ni gbɔ lə i gwu ya wə ma wɔ fəkə, yi bi dzɔ jɔbi ka wɔ fiəni yɛiŋ na wɔŋ.” Akisəkə i jɔbi wiwɔ, fiɛŋ fidɔkɔ shi aka bikwu, baŋ dzə́kəh yi Ɛlimas. Wi dza ka mɔmyiki di, nəŋ mi wə wi ni chiŋsi wi. ");
INSERT INTO cug_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Mi wi nsaka wə yɛiŋ yakadəiŋ, ka jiə shɔm i Jisɔs, si wi nì kaŋaki ŋkaiŋyi i gia yə bɔ nì laniki kɔm Bah Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bɔɔl bəh mbaŋ wi liə i ŋgwuki wimbum wə i Bafɔs, daŋ kinchwɔ kimbum buku i kwili wi Bɛlga wə i tumi ki Bamfilia wə. Si bɔ buku fɛiŋ, Jɔn Mak bee bɔ ka fiəni chu i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bɔ nyə fɛiŋ, ka tsəki i kwili wi Antiɔk wi Bisidia. Ayaka a bi num chɔkɔ bimbam wə, bɔ tsə liə ka num i juŋ yi tsani wə. ");
INSERT INTO cug_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Bəni dza fa kaasi i Kiŋwakti ki Bənchi bə Muses bəh ki bəni bə ntum bə Nyɔ, bətii kwili bə juŋ yi tsani yiwɔ ka faaŋ ntum i bə Bɔɔl a, “Bwa bə nih bəbuku, mbɛiŋ kabə kaŋaki gia yidɔkɔ i təfi bəni bəh yi, mbɛiŋ dzâka.” ");
INSERT INTO cug_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bɔɔl ka dza bɛiŋ, ka fəkəliki i bəni bəh kaŋ dzaka a, “Bəni bə Islae bəh bəni bə̀ bɔ kɔkə Bəju bə̀ bɔ kɔksiki tə Nyɔ, mbɛiŋ wɔ̂kɔli. ");
INSERT INTO cug_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nyɔ wi bəni bə Islae nì sabibwili bətii tii bəbuku, fə chwɔŋkijuŋ kibɔ num kimbum i jɔbi wə bɔ nì kɔ bəni bə dzəni i tumi ki Ijib wə. Wi ka bi bwili bɔ fɛiŋ bəh ŋga bi, ");
INSERT INTO cug_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","wi kaŋa shɔm bəh bɔ, bə́ tɔkniki bəh bɔ i chwa i jía wə mbaŋnyani. ");
INSERT INTO cug_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wi ka fə bɔ tumdzi kitumi nanitaŋ i nshwaiŋ yi Kanan wə, ka nya nshwaiŋ yiwɔ a yi numki yibɔ. ");
INSERT INTO cug_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Gia yələ yichi nì dzɔ jía ka gi yina bəh mbaŋshi (450). Si wi nya nshwaiŋ yiwɔ i bɔ, ka jiə bəni bə̀ bɔ ni sakaki bɔ. Bɔ ka sakaki i tsə buku i jɔbi wə mi wi wi ntum Samwɛl nì sakaki. ");
INSERT INTO cug_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","I jɔbi wiwɔ wə bɔ dza ka tsaki a bɔ kwâti num ŋkuŋ, Nyɔ ka nya Sɔɔl waiŋ Kish i bɔ, i chwɔŋkijuŋ ki Bɛnjamen wə. Ayaka wi saka ntɔŋ wiwɔ i jía mbaŋnyani. ");
INSERT INTO cug_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nyɔ bi shishi Sɔɔl, ka tɔm Dɛbit ka ŋkuŋ wibɔ. Nyɔ nì kɔ wi dzaka kɔm Dɛbit wələ a, ‘Mih yɛiŋ a Dɛbit waiŋ Jɛse kɔ shɔm yiŋ. Wi ni fəki lə gia yichi yə mih nəŋki.’ ");
INSERT INTO cug_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","A nì kɔ i chwɔŋkijuŋ ki Ŋkuŋ Dɛbit kələ wə Nyɔ nì bwili Kimbwili, nya i bəni bə Islae asi wi nì kaka. Kimbwili wələ num Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ka Jisɔs wələ yisi nɔm wi, Jɔn nì kɔ wi si fuku lɔ i bəni bə Islae bəchi a bɔ kwûni shɔ́m yibɔ ma ŋgaiŋ juli bɔ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jɔbi wə Jɔn nì kɔ a kaasi nɔm wi, ka dza bikə i bəni a, ‘Mbɛiŋ kwakaki a mih kɔ ndə? Mih kɔkə mi wə mbɛiŋ wɔkɔliki. Mi wiwɔ dzəki lə i jum wə, mih lansi kpɛiŋniki kə i ŋgwuŋ shi i shwa dzu yi yigvu.’” ");
INSERT INTO cug_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Bɔɔl tsə a ninshiŋ, ka dzakaki a, “Bwa bə nih bəŋ bə̀ akɔ chwɔŋkijuŋ ki Ablaham bəh bəni bəchi bə̀ bɔ kɔkə Bəju bɔ kɔksi tə Nyɔ, Nyɔ nì faaŋ ntum wələ bəni num i bɔiŋ yɛiŋ num i bukumbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Ayakalə, bəni bə Jɛlusalɛm bəh bəni bə̀ bɔ nì sakaki tumi, nəki dzɔ kə Jisɔs ka Kimbwili. Ayaka bɔ nəki kiə kə kifwu ki gia kə bəni bə ntum bə Nyɔ nì nyaka kɔm wi. A num yə bɔ nì shiki faaki i chɔkɔ bimbam bichi. Jɔbi wə bɔ nì dzaka a bə wɔ̂ɔ wi yaka, yi ka fə a yi dzə kpɛiŋ asi bəni bə ntum bə Nyɔ bə nì dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Na si bɔ nì ka yɛiŋ ŋgbɔ widɔkɔ wə bɔ nì wɔɔ wi yɛiŋ, bɔ tsə a ninshiŋ ka dzakaki i Baylɛ a bə wɔ̂ɔ wi. ");
INSERT INTO cug_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jɔbi wə bɔ nì fə gia yichi si Kiŋwakti ki Nyɔ nì dzakaki kɔm Jisɔs, bɔ shishi wi i kintasi wə ka tsə nɔsi wi i jum yi taa mə. ");
INSERT INTO cug_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ayakalə, Nyɔ fiəni dzasi wi i kpi mə. ");
INSERT INTO cug_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Wi chusi gwu yi i kaŋ yiduli wə i bəni bə̀ bɔ nì nyə i Galili tsə i Jɛlusalɛm. Akɔ bɔ bə̀ bɔ fukuki kɔm wi i liə i bəni bə Islae. ");
INSERT INTO cug_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ayakadəiŋ, buku kɔ tə fa i liə i fukuki ntum wi ndzɔŋni wiwɔ i mbɛiŋ. Ntum wiwɔ kɔ, a gia yə Nyɔ nì kaka i bətii tii bə bəni bə Islae bəh yi, ");
INSERT INTO cug_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","kɔ yi wi fə yi dzə kpɛiŋ i liə i jɔbi wibukumbɛiŋ wə, bukumbɛiŋ bə̀ bə kɔ bwa bəbɔ. Yələ kpɛiŋni asi Nyɔ nì dzasi Jisɔs i kpi wə. Bə nì kɔ bə nyaka lɔ kɔm gia yələ i Kiŋwakti ki N'yaksi wə i bimbu bifa wə Nyɔ dzakaki a, ‘Wɔ kɔ Waiŋ wuŋ, mih num Ba wa daiŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kɔm ndzasi wə Nyɔ nì dzasi Jisɔs i kpi wə a wi ma fɔɔ, Nyɔ nì kɔ wi dzaka i dzəh yələ wə a, ‘Mih bi nya lə mbɛiŋ bəh kimbɔiŋsi kə akɔ kəŋŋ, kə mih nì kaka i Dɛbit, ka dzi ŋkaiŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Yi kɔ bə chu nyaka i di bidɔkɔ wə i Kiŋwakti ki N'yaksi wə Dɛbit dzakaki a, ‘Wɔ bi bee kə Waiŋ wa wi nɔm wi Baiŋni, a wi fɔɔ i jum kintəəŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Yə kɔm Dɛbit kɔ a wi nì nɔm nnɔm wi wə Nyɔ nì nya i wi i jɔbi wi wə, ka kpi bə ləə kɔmsi wi i ba wi kpəŋ, wi fɔɔ. ");
INSERT INTO cug_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ayakalə, mi wələ wə Nyɔ nì dzasi i kpi wə nì ka fɔɔ dəkə i jum mə. ");
INSERT INTO cug_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ayakadəiŋ, bwa bə nih bəŋ, mbɛiŋ kiəki bindzɔŋ a, ntum wələ bə fukuki a Nyɔ dalinyaki lə chu bi bəni, wi dalinyaki kɔm Jisɔs wələ. ");
INSERT INTO cug_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mi wə wi jiə shɔm yi i Jisɔs wə, wi kɔ wi bɔiŋ lɔ i chu bi bichi wə, a num gia yə bənchi bə Muses kɔkə i fə. ");
INSERT INTO cug_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ayakadəiŋ, mbɛiŋ tɔkniki a gia yə bə nyaka i kiŋwakti ki bəni bə ntum bə Nyɔ mə ma bi kwa mbɛiŋ. Bɔ dzakaki i yɛiŋ wə a, ");
INSERT INTO cug_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Mbɛiŋ wɔ̂kɔ mbɛiŋ bə̀ mbɛiŋ shwiŋyiki Nyɔ. Dzaka bi wɔm lə mbɛiŋ, ma mbɛiŋ kpiyi. Mih ni fə lə gia i jɔbi wimbɛiŋ wə, num yə na kɔŋ mi widɔkɔ fuku yi i mbɛiŋ mbɛiŋ bi ma bum.’” ");
INSERT INTO cug_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Si Bɔɔl bəh Banabas nì bukuki i juŋ yi tsani wə, bəni bəwɔ ka tsa a bɔ bi fîəni dzə̂ i bimbam bi dzəni biəyaka wə i dzə̂ chû fûku gia yələ. ");
INSERT INTO cug_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Asi bəni nì bukuki i juŋ yi tsani wə, bəni bəduli bə̀ bɔ nì kɔ Bəju bəh bəni bə̀ bɔ nì fiəni num fiənini i num bəni bə kimbum ki Bəju wə, ka biəli Bɔɔl bəh Banabas. Bɔ ka dzakaki lani bəni bəwɔ a bɔ bâaŋ a nûmki i ŋgamti wi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","A dzə num i bimbam biə bi biəliki bimbam biwɔ, bəni juŋni a nì baaŋ alə twɛsi ka kwili wiwɔ wichi buku dzə i wɔkɔ gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Bəju yɛiŋ si mbaŋ wi bəni juŋniki yaka, kindɔŋ ka finiki bɔ, bɔ ka waliki gia yə Bɔɔl dzakaki, tɔyi wi. ");
INSERT INTO cug_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Bɔɔl bəh Banabas ka dzakaki lwa kə, dzaka a, “Yi kɔ chəŋ a buku kaŋaki i yîsi fûku gia yi Nyɔ num i mbɛiŋ Bəju. Si mbɛiŋ chasiki yi, dzɔ gwu yimbɛiŋ a mbɛiŋ kpɛiŋniki kə i kwati nɔni kə ki bi tsə kaa kə, buku ni fiəni lə gwu yibuku i tsə fukuki num i bəni bə̀ bɔ kɔkə Bəju. ");
INSERT INTO cug_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Yi kɔ asi Nyɔ nì dzaka i buku, a ŋgaiŋ nì dzaka a, ‘Mih jiə wɔ a wɔ nûmki ka baiŋni i bəni bə̀ bɔ kɔkə Bəju, wɔ fə ka bəni bə bimbu bi mbi bichi bi bɔiŋ.’” ");
INSERT INTO cug_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Bəni bə̀ bɔ kɔkə Bəju wɔkɔ yakadəiŋ, ka wɔkɔki ndzɔŋni, kɔksi gia yi Bah. Bəni bəduli bum gia yiwɔ, a num bə̀ Nyɔ nì kɔ wi babwili lɔ a bɔ bi kwati lə nɔni kə ki bi tsə kaa kə. ");
INSERT INTO cug_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Gia yi Bah ka nyani tumi kiwɔ kichi. ");
INSERT INTO cug_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ayakalə, Bəju ka dza nyini bətii kwili bəh bəkaŋa bəmbum, bəkaŋa bələ, kɔ bə̀ bɔ nì shiki dzəki i juŋ yi tsani wə, bɔ ka baiŋŋki Bɔɔl bəh Banabas, kɔŋŋ bɔ a bɔ bûku fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jɔbi wə bɔ nì nyəki, bɔ chumni kwɔŋɔ i gvu yibɔ wə ka kinchəsi ki gia yə bɔ mɔm, ka tsə i kwili wi Ikɔnium wə. ");
INSERT INTO cug_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mbaŋ wi bəni bə bumni, baaŋ fibɔ ka wɔkɔki ndzɔŋni nalə, Kiŋ'waka ki Baiŋni num ki jikə i bɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Asi Bɔɔl bəh Banabas tsə i Ikɔnium, bɔ fə asi bɔ nì fə i Antiɔk, i liə i juŋ yi tsani yi Bəju wə fɛiŋ, i fuku ntum wi ndzɔŋni fɛiŋ. Bɔ lansi fuku, Bəju bəh bəni bə̀ bɔ nì kɔkə Bəju bum bəduli. ");
INSERT INTO cug_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ayakalə, Bəju bə̀ bɔ ni nəiŋ i bum dza nyini bəni bədɔkɔ bə̀ bɔ nì kɔkə Bəju, fiəni shɔ́m yibɔ a bɔ bɔ̂ksiki shɔ́m bəh bəni bə bumni. ");
INSERT INTO cug_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bɔɔl bəh Banabas nì nɔ dzɔ fɛiŋ i jɔbi wi dəəŋ wə, ka fukuki ntum wi ndzɔni kɔm Bah lwa kə. Bah nya bɔ bəh ŋga i fəki bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ bəh gia yi dzaka ki wɔmni yi chusi a, gia yə bɔ fukuki kɔm Bah, asi wi chusi shɔm yi yindzɔŋni i bəni kɔ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Bəni bə kwili wiwɔ nì gaa gwu. Bədɔkɔ tsə i kimbu ki Bəju bə̀ bɔ nì ka bum, bədɔkɔ tsə i kimbu ki bwa bə ntum bə Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Bəju bə̀ bəh bəni bə̀ bɔ nì kɔkə Bəju bəh kifwu ki tumi juŋni, jiə kimfasi i chəbsiki bwa bə ntum bə Jisɔs, i tumyi bɔ bəh kitəh a bɔ kpiyi. ");
INSERT INTO cug_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Bɔ kiə kimfasi kibɔ, ka gɛiŋ tsə i tumi ki Likɔnia wə, ka nyaniki i di bi Lista bəh bi Dɛlbi wə bəh i bidi biə bi kɔmsiki fɛiŋ, ");
INSERT INTO cug_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","i fukuki nnyaki ntum wi ndzɔŋni fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Mi widɔkɔ nì kɔlə i Lista, num wi nì shi kɔ a kuku wi kɔbi i dza nyani, kɔm bə nì bwɔ wi num kiŋkəni, num wi nì ka num nyani na chɔkɔ bidɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A dzə num jɔbi widɔkɔ wə wi num ka wɔkɔliki gia yə Bɔɔl nì laniki. Bɔɔl ka bwaŋ dzə́kəh i wi wə, yɛiŋ a mi wiwɔ kaŋaki lə kimbum a Nyɔ kɔlə i chuku ŋgaiŋ, ");
INSERT INTO cug_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ka dzaka i wi bəh ŋga a, “Dzâ nûm bɛiŋ.” Wi ka jiŋ num i bɛiŋ, yisi i nyaniki. ");
INSERT INTO cug_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Si mbaŋ wi bəni yɛiŋ gia yə Bɔɔl fə, yisi i tɔŋki wili, dzaka i já yi Likɔnia wə a, “Bənyɔ fiəni i bəni ka shi dzə i bukumbɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bɔ ka bɔɔŋki Banabas a Siyus, bɔɔŋ Bɔɔl a Ɛmis kɔm wi nì shi kɔ a mi wə wi nì kɔmsiki dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A nì kɔ num juŋ yi fəni yi gia yi nyɔ yələ bɔ bɔɔŋki a Siyus num kɔmsi i kwili wiwɔ wə. Tii mfə gia wə fɛiŋ ka dzɔ bənaʼ bənyuku ka dzəki bəh yi i dzaka ki mbaiŋ wə a bɔ bəh bəni fə̂ gia yɛiŋ i Banabas bəh Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jɔbi wə Bwa bə faaŋni bə Jisɔs bələ nì kiə gia yə bəni bəwɔ nì nəŋki i fə, bɔ taŋyi bəmbuŋ i gwu yibɔ wə, yɔkɔ liə i bəni bəwɔ kintəəŋ, ka wamki kaŋyiki a, ");
INSERT INTO cug_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Bəni bələ, mbɛiŋ fəki num nə lə a? Buku kɔ a bəni liŋ ka mbɛiŋ, buku dzə fa i fukuki ntum wi ndzɔŋni wə wi nyəki dzəki i Nyɔ wə, a mbɛiŋ bêe bənyɔ bə kilɔlɔ bələ, i bîəli num Nyɔ wiwɔm. Nyɔ wələ kɔ wə wi nì maa bɔɔli bəh nshwaiŋ bəh kinchwɔ kimbum bəh biɛiŋ bichi biə bi kɔ i kidi kələ wə. ");
INSERT INTO cug_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","A nì kɔ i kikpu wə, wi nì beeki lə bəni i kitumi kichi wə, bɔ fə asi bɔ kɔŋki. ");
INSERT INTO cug_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ayakalə, wi ka fəki a gia yə yi ndzɔŋki i bəni, i chusi a ŋgaiŋ kɔ lə. Wi ka nyaki bɔ bəh dzaŋ, bɔ kwati dzɛiŋ i jɔbi wi ndzɔŋni wə, bɔ dzi wɔkɔ ndzɔŋni.” ");
INSERT INTO cug_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Na si Banabas bəh Bɔɔl dzakaki gia yiwɔ i bɔ yakadəiŋ, yi nì ləkə i bɔ i bee mfə gia i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Bəju bədɔkɔ ka dza dzə fɛiŋ, num bɔ nyə i Antiɔk bəh Ikɔnium, nyini bəni bəduli bɔ ka tumyiki Bɔɔl bəh kitəh. Si bɔ tumyi yakadəiŋ, ka guku buku bəh wi i kwili kintəəŋ kwaka a wi kpi lɔ. ");
INSERT INTO cug_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ayakalə, mbaŋ wi bəni bə bumni dzə juŋni i wi bɛiŋ, wi fiəni dza i bɛiŋ, ka fiəni dzə i kwili wiwɔ mə. Si chɔkɔ buku wɔɔ, wi bəh Banabas dza fɛiŋ ka tsəki i kwili ki Dɛlbi wə. ");
INSERT INTO cug_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Si Bɔɔl bəh Banabas liə i Dɛlbi, ka fukuki ntum wi ndzɔŋni kɔm Jisɔs, ka kwati bəni bə bumni fɛiŋ bəduli. Bɔ nyə fɛiŋ ka chu fiəniki i jum wə, ka tsəki daŋsiki i kwili ki Lista bəh ki Ikɔnium bəh Antiɔk wi Bisidia. ");
INSERT INTO cug_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bɔ ka tsəki daŋsiki yakadəiŋ, shili shɔ́m yi bəni bə bumni, təfi bɔ a, bɔ bâaŋ nûmki a bindzɔŋ i kimbum kibɔ wə, kiə a bəh bɔ kaŋaki lə i yɛiŋ bəŋgəkə bəduli ka bɔ bi tsɛiŋki i liə i ŋkuŋ bi Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Bɔ ka chu bayiki bətii kijuŋni ki bəni bə bumni, ka jiəki i bijuŋni bi bəni bə bumni bichi wə. Jɔbi wə bɔ ni jiəki bɔ, bɔ ka bamki dzaka tsa, nya bɔ i kaŋ yi Bah Jisɔs wə bɔ nì bum i wi. ");
INSERT INTO cug_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Bɔɔl bəh Banabas ka bi tsə tɔli i tumi ki Bisidia wə, ka daŋ tsə i Bamfilia, ");
INSERT INTO cug_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","i fuku gia yi Nyɔ i kwili wi Bɛlga wə, ka shi tsə i kwili wi Atalia wə. ");
INSERT INTO cug_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Si bɔ shi fɛiŋ, liə i ŋgwuki mə, ka fiəni dzə i Antiɔk. Antiɔk fa kɔ di biə bə nì nya bɔ i kaŋ yi Nyɔ wə, wi nya bɔ bəh ŋgamti wi na ka bɔ nyaniki fəki nɔm wələ wə bɔ kɔ bɔ kaasi. ");
INSERT INTO cug_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Si bɔ dzə buku fɛiŋ i Antiɔk, juŋni kijuŋni ki bəni bə bumni, fuku gia yichi i bɔ si Nyɔ nì nɔmki yakaki bəh bɔ, bəh si wi nì wɛli shɔ́m yi bəni bə̀ bɔ kɔkə Bəju, bɔ jiə shɔm i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Bɔɔl bəh Banabas nɔ bəh mbaŋ wi bəni bə bumni bəwɔ i jɔbi wi dəəŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Bəni bədɔkɔ nì nyə i Judea, shi dzə i Antiɔk, ka laniki bəni bə bumni a, Nyɔ kɔkə i bwili mi maka bə suuŋ wi asi bənchi bə Muses chusiki. ");
INSERT INTO cug_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bɔɔl bəh Banabas nəiŋma nlani wiwɔ, bɔ bəh bəni bəwɔ shi i gukuniki kɔm gia yiwɔ ŋgukuni wiwɔ kɔbi wi twɛsi. Ayakadəiŋ, yi ka gaka, kijuŋni ki bəni bə bumni i Antiɔk bɔ babwili Bɔɔl bəh Banabas bəh bəni bə bumni bədɔkɔ, faaŋ bɔ i yâka tsə̂ i Jɛlusalɛm a bɔ yâka tsə̂ yɛ̂iŋ bwa bə ntum bə Jisɔs bəh bətii kijuŋni ki bəni bə bumni fɛiŋ, ma bɔ jiə gia yələ i bɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ayakadəiŋ, kijuŋni ki bəni bə bumni i Antiɔk ka faaŋ bɔ, bɔ ka tsəki tɔliki i bimbu bi Fɔnishia bəh bi Samalia wə fuku i bəni bə bumni bə fɛiŋ a bəni bə̀ bɔ kɔkə Bəju kwuni lɔ. Bəni bəchi ka wɔkɔ yakadəiŋ, gia yiwɔ ndzɔŋ i bɔ nalə. ");
INSERT INTO cug_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Bɔ bi ka yaka dzə i Jɛlusalɛm, kijuŋni ki bəni bə bumni bəh bwa bə ntum bə Jisɔs bəh bətii kijuŋni ki fɛiŋ dzɔ bɔ. Bɔ ka fuku gia yichi i bɔ si Nyɔ nɔm i kaŋ yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ayakalə, bəni bə bumni bədɔkɔ bə̀ bɔ nì kɔ tə i mbaŋ wi Bəfalasi wə, dza yaka i bɛiŋ ka dzaka a, “Bɔ kaŋaki i sûuŋ bəni bə̀ bɔ kɔkə Bəju, ka dzaka a bɔ kaŋaki i jîəki bənchi bə Muses.” ");
INSERT INTO cug_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Si bɔ dzaka yakadəiŋ, bwa bə ntum bə Jisɔs bəh bətii kijuŋni chu num i tsɛiŋ ləkə i kintəəŋ ki gia yiwɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Bɔ sisi yi i tsə buku i jɔbi wi dəəŋ wə, Bita ka dza num bɛiŋ dzaka a, “Bwa bə nih bəŋ, mbɛiŋ kiə a, a nì kɔ i kikpu wə Nyɔ nì babwili mih i mbɛiŋ kintəəŋ a, akɔ i dzaka kəŋŋ wə bəni bə̀ bɔ kɔkə Bəju bi wɔkɔki ntum wi wi ndzɔŋni, ma bɔ bumki yi. ");
INSERT INTO cug_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nyɔ wə wi kiəki shɔ́m yi bəni bəchi, wi nì chusi a ŋgaiŋ dzɔ bəni bə̀ bɔ kɔkə Bəju, nya bɔ bəh Kiŋ'waka ki Baiŋni a liŋ asi wi nì nya i bukumbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Wi nì ka chusi dəkə chi chi i bukumbɛiŋ bəh bɔ. Wi nì kɔ wi fə shɔ́m yibɔ ka baiŋki kɔm bɔ nì kɔ bɔ jiə shɔm i Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Si yi kɔ yaka, mbɛiŋ nyani dəiŋ i nəŋniki shɔm yi Nyɔ, mbɛiŋ dzɔki bəntiə jiə i mbaŋ wi bəni bə bumni wə, num bəntiə bələ nì gaka lɔ bukumbɛiŋ bəh bətii tii bəbukumbɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Yi kɔkə chəŋ. Bukumbɛiŋ kɔ bə bum a Nyɔ bwiliki bukumbɛiŋ, num a fə shɔm yindzɔŋni yə Bah Jisɔs chusi i bukumbɛiŋ. Yi kɔ a liŋ tə si wi bwiliki bəni bə̀ bɔ kɔkə Bəju.” ");
INSERT INTO cug_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Si Bita dzaka kaasi, bəni bəchi kpichumi mɔŋ, ka wɔkɔliki si Banabas bəh Bɔɔl təkəki gia asi bɔ nì nyaniki tsəki i bəni bə̀ bɔ kɔkə Bəju, num Nyɔ nya bɔ bəh ŋga a bɔ fə̂ki bənchəsi bə̀ bɔ chusiki ŋga bi Nyɔ bəh gia yi dzaka ki wɔmni yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Bɔ dzaka kaasi, Jɛm ka dzaka a, “Bwa bə nih bəŋ, mbɛiŋ wɔ̂kɔli wɔ̂kɔ gia yə mih ki dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Samɔn nì fuku lɔ i bukumbɛiŋ si Nyɔ nì yisi chusiki tə tɔkni wi i bəni bə̀ bɔ kɔkə Bəju, ka sabibwili bəni bu bədɔkɔ i bɔ kintəəŋ a, akɔ mbu. ");
INSERT INTO cug_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Gia yə bəni bə ntum bə Nyɔ nì nyaka yi nyaniki a fiɛŋ fimu bəh yə Nyɔ nì fə. Bɔ nì nyaka a, ");
INSERT INTO cug_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Jɔbi dzəki lə wə mih bi fiəni dzə, i kɛiŋsi juŋ yi Dɛbit yə yi kɔ yi gbɔ lɔ. Mih ni fiəni maa lə chaka kiwɔ, ki fiəni num bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ayakadəiŋ, biŋka bi bəni bi nəŋki lə Bah, bəni bələ bəchi kɔ bə̀ bɔ kɔkə Bəju bə̀ mih babwili a, akɔ bəni mbəŋ. ");
INSERT INTO cug_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Yələ gia kɔ a dzaka Nyɔ, wi nì fə bəni kiə lɔ yi a kɛiŋ na i kikpu wə.’ ");
INSERT INTO cug_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Mih ka yɛiŋ yiŋ a bukumbɛiŋ ma nyaki ŋgəkə i bəni bə̀ bɔ kɔkə Bəju, bə̀ bɔ kɔ num bɔ jiə shɔm i Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bukumbɛiŋ nyâka a num kiŋwakti i bɔ, i dzaka a, bɔ ma dzîki biɛiŋ biə bəni fə gia yɛiŋ i bənyɔ, kɔm akɔ biɛiŋ bi kinyɛŋ. A bɔ bwîli kaŋa yibɔ i nɔni ki tɔkɔlini wə. Kiə bɔ ma dziki nyam yə yi kɔ maka bə kum a mwa buku. Kiə bɔ ma dzîki mwa mi nyam. ");
INSERT INTO cug_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Bə nyaka yaka, kɔm bɔ nì kɔ num bɔ nì lani lɔ bənchi bə Muses bələ i jɔbi wi dəəŋ wə i di bichi wə bəni wɔkɔ, a num yi yə bə faaki daiŋ i júŋ yi tsani wə i kaŋ yi mbam yichi.” ");
INSERT INTO cug_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ayakadəiŋ, bwa bə ntum bə Jisɔs bəh bətii kijuŋni bəh kijuŋni ki bəni bə bumni kichi bum gia yiwɔ, ka yɛiŋ a yi ndzɔŋki lə a bɔ bâ bəni bədɔkɔ i bɔ kintəəŋ i fâaŋ bɔ bəh Banabas bəh Bɔɔl i tsə̂ i Antiɔk. Bɔ ka babwili Judas wə yɛli wi widɔkɔ kɔ a Basabas, chu babwili tə Silas. Bəni bəfa bələ nì kɔ kifwu i kintəəŋ ki bəni bə bumni wə. ");
INSERT INTO cug_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Bɔ nyaka kiŋwakti kibɔ ka faaŋ ki i bɔ num a: “Buku bwa bə nih bəmbɛiŋ bə̀ bɔ kɔ bwa bə ntum bə Jisɔs bəh bətii kijuŋni bɔniki i mbɛiŋ bəni bə bumni bəchi bə̀ bɔ kɔkə Bəju, bəh bə̀ bɔ kɔ i kwili wi Antiɔk wə bəh bə̀ bɔ kɔ i kimbu ki Silia wə bəh bə̀ bɔ kɔ i kimbu ki Silishia wə. ");
INSERT INTO cug_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Buku wɔkɔ a bəni bədɔkɔ buku i buku kintəəŋ dzə ka nyaki ŋgəkə, shakyi mfi bimbɛiŋ bəh nlani widɔkɔ na məŋni si buku faaŋ bɔ. ");
INSERT INTO cug_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Buku ka shinum bəchi bum a bə bâ bəni bədɔkɔ bə fâaŋ i mbɛiŋ, a bɔ bəh Banabas bəh Bɔɔl dzə, bɔ num nsɛiŋ yibuku yi shɔm. ");
INSERT INTO cug_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Bəni bələ kɔ num bɔ musi lɔ kpi kɔm nɔm wi Bah wibukumbɛiŋ Jisɔs Klistus. ");
INSERT INTO cug_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Buku ka faaŋ Judas bəh Silas a bɔ dzə bɔŋ fuku tə bəh dzaka kibɔ gia yə yi kɔ i kiŋwakti kələ wə. ");
INSERT INTO cug_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Buku bəh Kiŋ'waka ki Baiŋni num ka yɛiŋ a yi ndzɔŋki kə i jikəli mbɛiŋ bəh ntiə widɔkɔ wə wi tsəki bənchi bələkəli bələ bɔ kɔ a: ");
INSERT INTO cug_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Kiə mbɛiŋ ma dzîki biɛiŋ bidzini biə bə kɔ num bə fə bimfə gia yɛiŋ i bənyɔ. Kiə mbɛiŋ ma dzîki mwa mi nyam. Kiə mbɛiŋ ma dzîki nyam yə yi kɔ maka bə kum yi a mwa buku. Kiə mbɛiŋ ma lə̂kəki kaŋ i nɔni ki tɔkɔlini wə. Mbɛiŋ ka yɔkɔ gɛiŋ gia yələ, mbɛiŋ fəki num gia yi chəŋ. Bə bɛsi.” ");
INSERT INTO cug_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Bɔ nyaka yaka ka faaŋ bəni bə̀ fɛiŋ a bɔ shî tsə̂ i Antiɔk. Bɔ tsə juŋni bəni bə bumni fɛiŋ bəchi, ka nya kiŋwakti kiwɔ i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Bɔ fa kiŋwakti kiwɔ, ntum wiwɔ dəsi shɔ́m yibɔ, bɔ jikə bəh kinsaŋli nalə. ");
INSERT INTO cug_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas bəh Silas bə̀ bɔ nì kɔ bəni bə̀ bɔ fukuki gia yə bɔ wɔkɔki si Nyɔ dzakaki, nya bətəfi bəduli i bəni bə bumni, fə bɔ ka kaŋaki ŋga i shɔ́m yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Bɔ nì nɔ dzɔ fɛiŋ i jɔbi widɔkɔ wə. Bəni bə bumni bə fiəni chiŋsi bɔ, bɔ ka tsəki bəh kimbɔiŋsi i bəni bə̀ bɔ nì faaŋ bɔ. ");
INSERT INTO cug_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Bɔɔl bəh Banabas baaŋ fɛiŋ i Antiɔk, bɔ bəh bəni bədɔkɔ ka laniki fuku gia yi Bah. ");
INSERT INTO cug_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Asi kaŋ nì tsə twɛsi, Bɔɔl dzaka i Banabas a, “Bukumbɛiŋ fîəni tsə̂ i jum wə bə nyani nnya i bitumi biə buku wɔ nì fukuki gia yi Bah i bi wə, ma bə yɛ̂iŋ a bəni bə bumni bə fɛiŋ fəki dəiŋ a.” ");
INSERT INTO cug_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas ka nəŋki i dzɔ Jɔn Mak a bəh bɔ nyaniki. ");
INSERT INTO cug_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bɔɔl nəki kɔŋ kə a bɔ dzɔ wi, kɔm wi nì nyə bee bɔ i Bamfilia na kɔŋ i kaasi nyani wə bəh bɔ nì kaŋaki. ");
INSERT INTO cug_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bɔɔl bəh Banabas baaŋ a gukuliki gia yiwɔ nalə, ka gaali. Banabas dzɔ Mak, bɔ wi liə i ŋgwuki wimbum mə, ka tsə i Sayblus. ");
INSERT INTO cug_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bɔɔl baa mfih num Silas. Ka bɔ nyə, num bəni bə bumni nya bɔ i kaŋ yi ŋgamti wi Bah wə. ");
INSERT INTO cug_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bɔ tsə dzəh i bimbu bi Silia wə bəh bi Silishia wə, ka nyaniki shili shɔ́m yi bijuŋni bi bəni bə bumni. ");
INSERT INTO cug_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bɔɔl nyani tsə buku i kwili wi Dɛlbi wə, ka dza tsə i ki Lista wə. Mi wi mbaŋ wi Jisɔs widɔkɔ num fɛiŋ i Lista yɛli wi num Timɔti, nih wi num mi wi Ju, a num tə mi wi bumni, ayakalə ba wi nì kɔ mi wi Glik. ");
INSERT INTO cug_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Timɔti wələ nì kɔ mi i bəni bə bumni bə Lista bəh bə Ikɔnium, bɔ bəchi kɔksi wi. ");
INSERT INTO cug_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bɔɔl ka nəŋki i dzɔ wi a bɔ wi nyâniki, ka suuŋ wi. Wi nì suuŋ wi yakadəiŋ, kɔm Bəju bəchi bə̀ bɔ nì nɔki i kimbu kiwɔ wə nì kiəki lə a tii Timɔti nì kɔ mi wi Glik. ");
INSERT INTO cug_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Bɔ ka nyaniki tsəki i bitumi wə, si bɔ nì tsəki dzaka i bəni bə bumni kɔm bənchi bə̀ bwa bə ntum bə Jisɔs, bəh kifwu ki kijuŋni ki Jɛlusalɛm nì shinum bum a bɔ jîə. ");
INSERT INTO cug_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ayakadəiŋ, kijuŋni ki bəni bə bumni bəwɔ ka ləkəki tsəki a ninshiŋ ninshiŋ i mbum wibɔ wə. Bəni kpɛiŋsi i bɔ wə chɔkɔ bichi. ");
INSERT INTO cug_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bɔɔl bəh mbaŋ wi nyə a bɔ tsə̂ fûku gia yi Nyɔ i tumi ki Ɛsia wə, Kiŋ'waka ki Baiŋni nəiŋ. Bɔ ka nyani tsə num i kimbu ki Fligia bəh ki Galɛshia wə. ");
INSERT INTO cug_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Bɔ ka tsə buku kɔmsi i tumi ki Misia wə ka nəŋki i liə tsə i kimbu ki Bitinia wə, Kiŋ'waka ki Jisɔs chu nəiŋ. ");
INSERT INTO cug_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ayakadəiŋ, bɔ ka tsə i tumi ki Misia wə, daŋsi tsə i kwili wi Tɔwas wə. ");
INSERT INTO cug_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","A dzə num nchɔkɔ, fiɛŋ ka ndəmsi dza dzə i Bɔɔl wə. Wi yɛiŋ i fiɛŋ fiwɔ mə a mi widɔkɔ i Masedɔnia tsaki wi a, “Mntee, dâŋ dzə̂ i fa Masedɔnia wɔ gâmti buku.” ");
INSERT INTO cug_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Si fiɛŋ fiwɔ dzə i Bɔɔl yakadəiŋ, buku bɔ ka yɛiŋ a Nyɔ chusi i buku a buku tsə̂ fûku ntum wi ndzɔŋni i tumi ki Masedɔnia wə. Akisəkə, buku ka kɛiŋsi i tsə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Buku nyə i Tɔwas, daŋ bɔkɔ chəŋ i ŋgwuki wimbum mə, tumbuku i Samɔtɛs. Chɔkɔ buku wɔɔ buku tsə i ninshiŋ ka buku i Niabɔlis. ");
INSERT INTO cug_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Buku nyə fɛiŋ nyani tsə i Filibi, num i kwili wi kimbu ki ninshiŋ ki Masedɔnia. Kwili wiwɔ nì kɔ wi gɔmna wi Lum. Ayaka buku nɔ fɛiŋ i kaŋ yidɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","A dzə num i chɔkɔ bimbam wə, buku dza i kwili wiwɔ wə, ka tsə i bɔkɔ yidɔkɔ kpəŋ i di biə buku nì kwakaki a Bəju kɔlə i kaŋaki di bi tsani fɛiŋ. Si buku tsə yakadəiŋ, bəkaŋa bədɔkɔ num bɔ juŋni dzə fɛiŋ, buku ka shinum ka dzakaki i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kpaŋa widɔkɔ nì kɔ yɛiŋ wə wi wɔkɔli buku yɛli wi num Lidia, wi nì shi kɔ a kɔksiki Nyɔ. Wi nì buku i kwili wi Tayatila wə, wi nì shi kɔ a taŋniki bəmbuŋ bɔ num ka bɔ bɔkɔki bɔkɔni, bɔ ləkə i kpɔ wə. Bah wɛli shɔm yi, wi bum gia yə Bɔɔl nì dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Bə bi dzə juli wi i bɔkɔ bəh bəni bu bə dzu, wi ka tsa buku dzaka a, “Mntee, mbɛiŋ ka yɛiŋ a mih jiə shɔm yiŋ yichi i Bah wə, mbɛiŋ dzə̂ nɔ̂ i mih dzu.” Wi baaŋ a tsaki a tsani, buku bum ka tsə. ");
INSERT INTO cug_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","A dzə num chɔkɔ bidɔkɔ buku bə́ tsə i di bi tsani wə, baŋsi bəh waiŋ kpaŋni widɔkɔ num mfa. Wi nì kaŋaki kiŋ'waka kidɔkɔ i wi mə, a num kə ki si fə a mi numki mi wi n'yɛiŋ. Bəni bə̀ bɔ nì kaŋaki waiŋ kpaŋni wiwɔ nì kɔki lə kpɔ i gwu yi wə na bindzɔŋ kɔm wi nì shiki fukuki a gia yə yi kɔ i num. ");
INSERT INTO cug_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Waiŋ kpaŋni wiwɔ ka yɛiŋ buku Bɔɔl, ka biəli buku, wili dzaka a, “Bəni bələ kɔ bəni bə nɔm bə Nyɔ wə wi kɔ Fwu wi biɛiŋ Bichi wə, bɔ chusiki dzəh yə yi kɔ i mbɛiŋ i nyaniki yɛiŋ ka mbɛiŋ bi bɔiŋ yɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Wi fə yakadəiŋ lə i buku i kaŋa yiduli wə, Bɔɔl bɔksi tɔɔ, wi fiəni gwu yi kaŋyi kiŋ'waka kiwɔ dzaka a, “Mih fukuki i wɔ i yɛli wi Jisɔs Klistus wə, bûku i waiŋ wələ wə.” Ayaka ki ka buku i gwu yi mə akisəkə. ");
INSERT INTO cug_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bəni bə̀ bɔ nì kaŋaki mfa wiwɔ yɛiŋ a dzəh yibɔ yi kpɔ kaa, bɔ ka kwa Bɔɔl bəh Silas guku tsə bəh bɔ i di bi shi wə i bətii di nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Si bɔ nì tsə bəh bɔ, jiə i bəgɔmna bə Lum nshiŋ bə̀ bɔ nì sakaki bənsaka ka dzaka a, “Bəni bələ kɔ Bəju, bɔ nya ŋgəkə i kwili wibuku wə. ");
INSERT INTO cug_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Bɔ laniki bəni bəh nɔni kə bənchi bəbukumbɛiŋ bumki kə. Buku kɔ bəni bə Lum, buku kɔbi i biəliki nɔni kiwɔ.” ");
INSERT INTO cug_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mbaŋ wi bəni bə̀ bɔ nì kɔ fɛiŋ bɔ ka tɔbi bɔ, kwu i Bɔɔl bəh Silas wə. Bəgɔmna bə̀ bɔ nì sakaki bənsaka ka shakyi bəmbuŋ i Bɔɔl bəh Silas wə, dzaka a bə twɛ̂iŋ bɔ. ");
INSERT INTO cug_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Bɔ twɛiŋ bɔ nalə, dzɔ bɔ tsə fah i juŋ yi nsəŋ wə, dzaka i mi wə wi tɔkniki bəh juŋ yi nsəŋ a wi kɛ̂iŋsiki tsɛ̂iŋki bɔ bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Si wi wɔkɔ yaka, ka dzɔ bɔ tsə fah na i kimbu kintəəŋ ki juŋ yi nsəŋ wə, fah kaka bibɔ i kikɔm mə. ");
INSERT INTO cug_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","A num ka nchɔkɔ kintəəŋ, Bɔɔl bəh Silas tsa wə yəəŋ kɔksi Nyɔ, bəni bə nsəŋ wɔkɔli, ");
INSERT INTO cug_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","akisəkə nshwaiŋ dza ka nəŋni bəh ŋga, juŋ yi nsəŋ nəŋni tsə buku i chaka wə. Akisəkə, dzaka bifiəŋə bichi wɛli gwu, bənsəŋ shwali i bəni bə nsəŋ wə bəchi. ");
INSERT INTO cug_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Mi wə wi ni tɔkniki bəh juŋ yi nsəŋ yiwɔ dza yaka, ka yɛiŋ dzaka bifiəŋə num bi wɛli, wi ka kwakaki a bəni bə nsəŋ kɔ num bɔ gɛiŋ lɔ. Wi ka babwili nywɔ i kimbaka wə ka nəŋki i wɔɔ gwu yi yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bɔɔl wam bəh ŋga dzaka a, “Ma wɔ̂ɔ gwu ya. Buku bəchi kɔ fa.” ");
INSERT INTO cug_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Mi wə wi nì tɔkniki bəh juŋ yi nsəŋ yiwɔ bɔɔŋ a bə dzə̂ ŋgaiŋ bəh naka ki baiŋsini, wi yɔkɔ liə i dzu, tsə tum binyu i Bɔɔl bəh Silas nshiŋ nyumi bəh lwa. ");
INSERT INTO cug_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Wi dza dzɔ bɔ, buku bəh bɔ i biŋ, bikə i bɔ a, “Bəba, mih kɔ i fə dəiŋ ka mih bɔiŋ a?” ");
INSERT INTO cug_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Bɔ chukuli i wi a, “Jîə shɔm ya i Bah Jisɔs, ma wɔ bəh bəni ba i wɔ dzu bi bɔiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ayaka bɔ ka fuku ntum wə kɔm Bah i wi bəh i bəni bəchi i wi dzu. ");
INSERT INTO cug_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Wi dzɔ bɔ fɛiŋ nchɔkɔ ka wɔkɔ biəkə yibɔ. Akisəkə, bɔ ka juli wi bəh bəni bəchi bə̀ i wi dzu i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wi ka dzɔ bɔ, bəh bɔ yaka tsə i wi dzu, wi nya bɔ bəh biɛiŋ bidzini bɔ dzi. Bɔ bəh bəni bəchi bə i wi dzu ka laŋki a bɔ jiə shɔm yibɔ i Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Chɔkɔ buku wɔ, bəgɔmna bə Lum bə̀ bɔ nì sakaki bənsaka faaŋ bəni bə jum, a bɔ tsə̂ dzâka i mi wə wi tɔkniki bəh juŋ yi nsəŋ a, wi bwîli bəni bə̀ ma bɔ tsə̂ki. ");
INSERT INTO cug_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Mi wə wi nì tɔkniki bəh juŋ yi nsəŋ yiwɔ ka tsə yɛiŋ Bɔɔl dzaka i wi a, “Bəgɔmna faaŋ ntum a mih dzə̂ bwîli mbɛiŋ, a mbɛiŋ tsə̂ki i kimbɔiŋni wə.” ");
INSERT INTO cug_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ayakalə, Bɔɔl dzaka i bəni bə jum bəwɔ a, “Bɔ ni twɛiŋ buku i bəni kintəəŋ maka bɔ yisi saka nsaka wibuku dəkə, na yaka buku num tə bəni bə Lum, chu fah buku i juŋ yi nsəŋ mə, ka dzakaki i liə a, bə bwîli buku i jum wə jum wə dəiŋ na? Yi kɔkə num yaka. Akɔ a Gɔmna wiwɔ i bwili buku.” ");
INSERT INTO cug_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Bəni bə jum bəwɔ fiəni tsə fuku i bəgɔmna gia yə Bɔɔl dzaka. Si bɔ wɔkɔ a Bɔɔl bəh Silas kɔ tə bəni bə Lum, ka lwaki. ");
INSERT INTO cug_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Bɔ dzə ka kwuŋ kaŋ i bɔ, bwili bɔ i juŋ yi nsəŋ mə, chiŋsi bɔ, tsa a bɔ bûku i kwili wiwɔ mə. ");
INSERT INTO cug_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bɔɔl bəh Silas buku i juŋ yi nsəŋ mə, tsə i juŋ yi Lidia wə ka kwati bəni bə bumni fɛiŋ, bɔ təfi bɔ ka nyə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Bɔɔl bəh Silas ka tsəki, tsə daŋsi i kikwili ki Amfibɔlis bəh Abɔlɔnia wə, daŋsi tsə buku i Tɛsalɔnika. Juŋ yi tsani yi Bəju num fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bɔɔl ka tsə liə i juŋ yi tsani yiwɔ mə asi wi si fə jɔbi wichi, ka yisi i dzakaki i bəni fɛiŋ kɔm gia yi Nyɔ i shi yitali wə i kaŋ yi mbam wə, wi chusi gia yichi i Kiŋwakti ki Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ayaka wi ka chusiki fɛiŋ, tɔyi a Kimbwili wə Nyɔ nì kaka nì kaŋaki i yɛ̂iŋ ŋgəkə, i fîəni dza i kpi wə. Jisɔs wələ ŋgaiŋ fukuki kɔm wi kɔ Kimbwili wiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ayaka bəni bədɔkɔ wɔkɔ yaka, bum ka chiŋni Bɔɔl bəh Silas. Ayaka Bəglik bədɔkɔ bə̀ bɔ nì kɔksiki Nyɔ bəh bəkaŋa bəmbum bədɔkɔ bum tə bəduli. ");
INSERT INTO cug_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ayakalə, kindɔŋ ka finiki Bəju bədɔkɔ kɔm Bɔɔl bəh Silas, bɔ juŋni bəni bədɔkɔ bə̀ bɔ nì nyaniki nnyaki kilɔlɔ bəh bɔ chiŋni i mbaŋ wə, yisi bəndzaka i kwili kintəəŋ. Bɔ ka nyə tsə bwiŋ juŋ yi Jasɔn a bɔ nəŋki Bɔɔl bəh Silas i bwili nya i bəni i biŋ. ");
INSERT INTO cug_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ayaka bɔ ka nəŋ mɔŋ, ka guku Jasɔn bəh bəni bə bumni bədɔkɔ tsə bəh bɔ i bətii kwili nshiŋ, ka wiliki dzakayi a, “Bəni bələ kɔ bə̀ bɔ nyaniki beensiki mbi jiəli, bɔ dzə buku lɔ fa, ");
INSERT INTO cug_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ayaka Jasɔn dzɔ bɔ jiə i wi dzu. Bɔ bəchi bwiŋki bənchi bə ŋkuŋ wi Lum, ka dzaka a ŋkuŋ widɔkɔ kɔlə yɛli wi num a Jisɔs.” ");
INSERT INTO cug_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ayaka bətii kwili bəh bəni wɔkɔ yaka, bɔ dza ka wɛsiki. ");
INSERT INTO cug_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Bɔ ka kaŋyi Jasɔn bəh bəni bə bumni, bɔ gɔm kpɔ, a yi bi ka chu num, bɔ bi ma chu fiəni nya kpɔ wiwɔ i bɔ. Bɔ ka bee a bɔ nyə̂. ");
INSERT INTO cug_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Si fuu nì jum dzə, bəni bə bumni dzɔ Bɔɔl bəh Silas chiŋsi bɔ ka tsəki i kwili wi Bɛlia wə. Si bɔ liə fɛiŋ, tsə i juŋ yi tsani yi Bəju mə. ");
INSERT INTO cug_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bəju bə fɛiŋ nì kɔ bəni bɔ kiə gia tsə bə Tɛsalɔnika, kɔm bɔ nì dzɔ nlani wiwɔ bəh kiŋkɔŋ, bɔ nəŋ i Kiŋwakti ki Nyɔ wə kaŋ yichi i yɛiŋ a gia yə Bɔɔl laniki bɔ yɛiŋ akɔ a ŋkɔŋ a. ");
INSERT INTO cug_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bɔ bəduli ka bum gia yi Nyɔ. Bəkaŋa bəmbum bəduli bə̀ bɔ nì kɔ Bəglik , bəh bənyuku bəduli bə̀ bɔ nì kɔ tə Bəglik bum tə. ");
INSERT INTO cug_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ayakalə, Bəju bə Tɛsalɔnika bi wɔkɔ a Bɔɔl tsə lɔ ka fukuki gia yi Nyɔ i Bɛlia, bɔ ka bɔŋ tsə tə fɛiŋ, nyini mbaŋ wi bəni bɔ yisi bəŋgəkə. ");
INSERT INTO cug_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Bəni bə bumni ka dzaka a Bɔɔl nyə akisəkə wi tsə i kinchwɔ kimbum kpəŋ. Ayakalə, Silas bəh Timɔti baaŋ a Bɛlia. ");
INSERT INTO cug_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Bəni bə̀ bɔ nì tsə i chiŋsi Bɔɔl, tsə buku i Atɛn ka bee wi fɛiŋ. Jɔbi wə bɔ nì fiəniki dzəki Bɔɔl faaŋ bɔ bəh ntum, a bɔ tsə̂ lâka i Silas bəh Timɔti a bɔ mɔ̂msi wâkli i dzə̂ bûku i ŋgaiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bɔɔl ka wɔkɔliki Silas bəh Timɔti i Atɛn. Jɔbi wə wi nì nyaniki fɛiŋ, wi yɛiŋ num kwili wiwɔ jikə bəh mimɔsɔ, yi nəŋni shɔm yi nalə. ");
INSERT INTO cug_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ayakadəiŋ, wi ka tsə i juŋ yi tsani yi Bəju wə dzaka bəh bɔ, tasi bəh bəni bə̀ bɔ nì kɔkə Bəju bɔ tsa tə Nyɔ fɛiŋ. Wi chu dzaka tə chɔkɔ bichi i di bi shi wə bəh bəni bə̀ bɔ nì shiki dzəki fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bəni bə lanini bədɔkɔ bə̀ bə nì bɔɔŋki bɔ a Ɛbikɔlia bəh bə̀ bə nì bɔɔŋki bɔ a Sitɔyik nì nyə dzə tə ka gukuliki bɔ bəh Bɔɔl. Si Bɔɔl nì fukuki kɔm Jisɔs bəh ndza wi kpi, bədɔkɔ ka bikəki a, “Kiyuŋ kələ kɔmki dzaka a nə a?” Bədɔkɔ dzaka fibɔ a, “Yi kɔ ka wi fukuki kɔm bənyɔ bə bəni bədɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ayakadəiŋ, bɔ ka dzɔ Bɔɔl bəh bɔ tsə i kijuŋni kə bɔ nì bɔɔŋki i já yibɔ wə a Aleɔbagus bɔ dzaka i wi a, “Buku nəŋki i chu wɔkɔ kɔm nlani wimfiaŋ wələ wɔ dzəki bəh wi lə. ");
INSERT INTO cug_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wɔ dzakaki gia yidɔkɔ maka buku num wɔkɔ yi. Ayakadəiŋ, buku nəŋki i kiə fwu wi gia yiwɔ.” ");
INSERT INTO cug_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Bəni bə Atɛn bəh bəni bədzəni bə̀ fɛiŋ nì shi kɔ fibɔ a wɔkɔliki gia yimfiaŋ chu dzaka kɔm yi). ");
INSERT INTO cug_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Bɔɔl ka dza num bɛiŋ i kintəəŋ ki Aleɔbagus nshiŋ, dzaka a, “Bəni bə Atɛn, mih yɛiŋ a i dzə́h yichi wə a mbɛiŋ kɔksiki bənyɔ nalə. ");
INSERT INTO cug_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mih dzakaki lə, kɔm mih ni nyaniki nnyaki i kwili wimbɛiŋ kintəəŋ, mih tsɛiŋ bidi biə mbɛiŋ tsaki bənyɔ yɛiŋ, mih yɛiŋ bitɔŋ bi fəni gia bidɔkɔ num bə nyaka i yɛiŋ wə a, ‘I nyɔ wə bə kiəki kə.’ Nyɔ wiwɔ wə mbɛiŋ tsaki i wi, wə bə kiəki kə, akɔ wi wə mih ki fukuki i mbɛiŋ i liə. ");
INSERT INTO cug_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nyɔ wələ kɔ wə wi nì maa mbi wələ bəh biɛiŋ bichi biə bi kɔ yɛiŋ wə. Akɔ wi Ŋkuŋ wi bɔɔli bəh nshwaiŋ, wi nɔ kə i juŋ yi fəni yi gia wə yə a maa bəni. ");
INSERT INTO cug_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Wi dzaki kə fiɛŋ fidɔkɔ fiə wi tsɛiŋki a mi nɔm i wi, kɔm akɔ wi wə wi nyaki bəni bəchi kiŋ'waka ka bɔ numki bəwɔm bəh biɛiŋ bichi biə bɔ nəŋki. ");
INSERT INTO cug_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Wi nì kɔ wi fə chwɔŋkijuŋ ki bəni bəchi buku i mi wimu ka bɔ bi nɔ i nshwaiŋ yələ yichi wə. Ka wi fə yakadəiŋ num wi nì kɛiŋsi lɔ jɔbi wə bɔ bi numki fɛiŋ bəh kiŋgɔksi ki di biə bɔ bi nɔki yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Wi nì fə yakadəiŋ, ka bəni bi nəŋki nnyaki wi, a jɔbi widɔkɔ bɔ bi yɛiŋ lə i wi wə. Ayakalə, Nyɔ kɔkə i dzəh yi dəəŋ i mi widɔkɔ wə i bukumbɛiŋ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Gia yələ kɔ a liŋ asi mi widɔkɔ nì dzaka lɔ a, ‘Akɔ wi, wi fəki ka bukumbɛiŋ nɔki, nyani, chu num asi bukumbɛiŋ kɔ.’ Mi wimbɛiŋ wi kichum widɔkɔ nì dzaka tə a, ‘Buku tɔksi kɔ bwa bu.’ ");
INSERT INTO cug_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Asi bukumbɛiŋ kɔ bwa bə Nyɔ, yakadəiŋ bukumbɛiŋ ma kwakaki a Nyɔ bwɔsiki fiɛŋ fiə a kɛiŋsi mi bəh mfi bi, biəŋə bəh chwaka ki kpɔ, nabə a bə kɛiŋsi bəh təh. ");
INSERT INTO cug_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","A nì kɔ i jɔbi wiwɔ bəni kɛiŋ i jisi wə, fə biɛiŋ bichu biələ, Nyɔ beeka. Ayakalə, i liə wi dzaka i mi wichi a bɔ kwûni shɔ́m yibɔ. ");
INSERT INTO cug_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Bɔ kwûni kɔm wi jiə chɔkɔ biə wi bi saka mbi wichi yɛiŋ biəli i dzəh yi chəŋ wə. Wi babwili lɔ mi wə wi ni sakaki. Yələ kɔ num wi chusi lɔ i mi wichi a, akɔ ŋkɔŋ asi wi nì dzasi mi wiwɔ i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Si Bɔɔl dzaka yakadəiŋ, bɔ wɔkɔ kɔm ndza wi kpi, bəni bədɔkɔ dza ka suŋuki wi. Bədɔkɔ dzaka fibɔ a, “Buku nəŋki lə i chu wɔkɔ kɔm gia yələ wɔ dzakaki lə.” ");
INSERT INTO cug_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ayakadəiŋ, Bɔɔl ka buku bee bɔ. ");
INSERT INTO cug_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ayakalə, bəni bədɔkɔ bum gia yə wi nì dzakaki, ka chiŋni wi. Mi widɔkɔ i bɔ wə nì kɔ Diɔnisius wə wi nì kɔ mi wi kijuŋni wi Aleɔbagus, widɔkɔ nì kɔ miŋkpaŋa yɛli wi num Damalis bəh bəni bədɔkɔ tə. ");
INSERT INTO cug_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","I yəmaka jum, Bɔɔl nyə i Atɛn tsə i kwili wi Kɔlɛn. ");
INSERT INTO cug_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Si wi tsə fɛiŋ, bɔ mi wi Ju widɔkɔ baŋsi yɛli wi num Akpwila, num bə nì bwɔ wi i Bɔntus. Akpwila nì kukti dzə i Itali bəh kpə wi Blisilia, kɔm Klawdius ŋkuŋ wi Lum nì kɔ wi tsəsi ja a, Bəju bəchi buku i Lum. Bɔɔl ka laa njikə i bɔ, ");
INSERT INTO cug_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ka tsə yɛiŋ bɔ kɛiŋsi dzú yə bə baŋki bitaŋ yɛiŋ, a num tə a nɔm wə wi Bɔɔl nì nɔmki. Kɔm yaka, wi ka nɔki fɛiŋ, bəh bɔ nɔm. ");
INSERT INTO cug_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Aka numki i kaŋ yi mbam wə yichi, wi ka tsəki i juŋ yi tsani wə, dzaka i Bəju bəh i Bəglik mɔmsi i fə a bɔ bûm gia yə wi laniki. ");
INSERT INTO cug_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","I jɔbi wə Silas bəh Timɔti nì buku i Masedɔnia dzə, Bɔɔl ka dzɔ jɔbi wi wichi ka fukuki num gia yi Nyɔ, chusi i Bəju a, Kimbwili wə Nyɔ nì kaka kɔ Jisɔs. ");
INSERT INTO cug_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ayakalə, Bəju bəwɔ ka nyə ka waliki gia yə wi nì dzakaki, tɔyi wi. Wi ka nəŋni bəmbuŋ i gwu yi wə dzaka i bɔ a, “Kpi yimbɛiŋ kɔ i mbɛiŋ kaŋ. Kaŋ yiŋ kɔkə yɛiŋ. Ayaka i yisi i liə, mih tsəki num i bəni bə̀ bɔ kɔkə Bəju.” ");
INSERT INTO cug_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Wi ka bee bɔ, buku tsə ka nɔki num bəh mi widɔkɔ a num kə mi wi Ju, mi wiwɔ nì kɔ mi wi kɔksi Nyɔ, yɛli wi num Titius Justus, kwili wi num kɔmsi i juŋ yi tsani wə. ");
INSERT INTO cug_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Klisbus wə wi kɔ fwu i juŋ yi tsani wə bəh bəni bəchi bə̀ i wi dzu jiə shɔ́m yibɔ i Bah. Bəni bə Kɔlɛn bəduli ka wɔkɔki si Bɔɔl fukuki kɔm Jisɔs, bum, bə ka juliki bɔ i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","A dzə num chɔkɔ bidɔkɔ nchɔkɔ, Bah dzaka i Bɔɔl i fiɛŋ wə aka ndəmsi a, “Ma lwâki, wɔ fûku tsə a bəh gia yiŋ. Kiə wɔ ki bêe kə yi, ");
INSERT INTO cug_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","kɔm mih kɔlə bəh wɔ, ayaka mi widɔkɔ kɔkə i fə na gia yidɔkɔ bəh wɔ fɛiŋ. Bəni bəŋ kɔlə i kikwili kələ wə bəduli.” ");
INSERT INTO cug_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ayakadəiŋ, Bɔɔl ka fə jia yichili fɛiŋ bəh kiŋka, lani bəni bəh gia yi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","I jɔbi wə Bɔɔl nì kɔ fɛiŋ, Galiɔ dzə num mi wi nsaka i kimbu ki Akɛya wə, Bəju ka juŋni gwu yibɔ kwa wi tsə bəh wi i juŋ yi nsaka wə, ");
INSERT INTO cug_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","dzaka i Galiɔ a, “Mi wələ mɔmsiki i fiəniki fwu ki bəni a bɔ kɔksiki Nyɔ i dzə́h yidɔkɔ wə chi chi a num kə si bənchi nəŋki.” ");
INSERT INTO cug_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Asi Bɔɔl nì dza a ŋgaiŋ dzaka, Galiɔ dza bəh ndzaka, dzaka i Bəju bəwɔ a, “Bəju mbɛiŋ wɔ̂kɔli, asi kɔ a gia yələ numki gia yichu yidɔkɔ mi wələ fə, nabə a wi gbɔ i nchi widɔkɔ wə, ma mih kaŋa shɔm i wɔkɔli gia yə mbɛiŋ dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ayakalə, si akɔ gia yi gukulini kɔm já bəh kiyɛli bəh bənchi bəmbɛiŋ, mbɛiŋ kɛ̂iŋsi yi a mbɛiŋ mbɛiŋ. Kɔm mih ni saka kə yəmaka gia.” ");
INSERT INTO cug_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Si wi dzaka yaka, ka kɔŋŋ bɔ, bɔ buku i juŋ yi nsaka mə. ");
INSERT INTO cug_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Bɔ bəchi ka dza liəni i Sɔstɛnes tikwili wi juŋ yi tsani wə, ka twɛiŋ wi i juŋ yi nsaka nshiŋ. Galiɔ nəki kaŋa kə jɔbi i yəmaka gia wə. ");
INSERT INTO cug_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","I yəmaka jum, Bɔɔl chu nɔ i Kɔlɛn bəh bəni bə bumni i kaŋ yiduli wə, ka bi dza bee bɔ, bɔ bəh Blisilia bəh Akpwila ka liə i ŋgwuki wimbum mə i tsəki i Silia. Si bɔ dza i Sɛŋklia di biə bɔ nì liə i ŋgwuki wimbum mə, Bɔɔl kəə fwu wi kɔm kiŋkaka kə wi nì fə i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Bɔ tsə buku i Ɛfɛsus, Bɔɔl bee Blisilia bəh Akpwila fɛiŋ, tsə mfih num i juŋ yi tsani yi Bəju wə, dzaka bɔ Bəju bə̀ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Bɔ tsa a wi chû nɔ̂ bəh bɔ i kaŋ yiduli wə, wi nəiŋma. ");
INSERT INTO cug_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ayakalə, i jɔbi wə wi nì nyəki, wi dzaka i bɔ a, “Mih ni fiəni dzə lə i jɔbi wə Nyɔ ka bum.” Si wi dzaka yakadəiŋ, ka liə i ŋgwuki wə nyə i Ɛfɛsus. ");
INSERT INTO cug_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ŋgwuki wiwɔ tsə buku i Kaysalia, Bɔɔl buku fɛiŋ, yaka tsə bɔni i kijuŋni ki bəni bə bumni i Jɛlusalɛm, ka nyə shi tsə i Antiɔk. ");
INSERT INTO cug_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Wi nì tsəsi jɔbi widɔkɔ fɛiŋ, ka fiəni nyə ka nyaniki i di di wə i bimbu bi Galɛshia wə bəh bi Fligia wə, shili shɔ́m yi bəni bə bumni fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Mi wi Ju widɔkɔ nì nyə dzə i Ɛfɛsus yɛli wi num Abɔlɔs, num bə nì bwɔ wi i Alɛksandia. A nì kɔ mi wi kiə ndzaka, chu kiə Kiŋwakti ki Nyɔ nalə. ");
INSERT INTO cug_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Bə nì kɔ bə lani lɔ wi bəh dzəh yə Bah chusiki, wi ka fiki bəh nlani kɔm Jisɔs, lani bəni chəŋ. Ayakalə, wi nì kiəki shəŋ a gia yə Jɔn nì fukuki juli bəni i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Si wi dzə i Ɛfɛsus, ka yisi i laniki bəni i juŋ yi tsani wə chu lwa kə. Blisilia bəh Akpwila ka wɔkɔ si wi laniki yaka, dzɔ wi, tsə ka chu təfi baiŋsi wi nalə si Dzəh yi Nyɔ chusiki. ");
INSERT INTO cug_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Abɔlɔs dza ka kwakaki a ŋgaiŋ si kɔlə i ndaŋ tsə i kimbu ki Akɛya wə. Bəni bə bumni bə̀ bɔ nì kɔ i Ɛfɛsus ka gamti wi, nyaka kiŋwakti i mbaŋ wi bəni bə bumni bə̀ bɔ nì kɔ i Akɛya, tɔbi a, bɔ dzɔ̂ wi. I jɔbi wə wi ni tsə fɛiŋ, wi lansi gamti bəni bə bumni nalə, bəni bələ nì kɔ bə̀ Nyɔ nì chusi shɔm yi yindzɔŋni i bɔ, ayaka fə bɔ jiə shɔ́m i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wi gukuli bəh Bəju i shi bɛiŋ, ŋgukuli wiwɔ num kə wi twɛsi, wi gaka bɔ, chusi i Kiŋwakti ki Nyɔ wə a Jisɔs kɔ Kimbwili wə Nyɔ nì kaka. ");
INSERT INTO cug_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","A nì kɔ i jɔbi wə Abɔlɔs nì kɔ i Kɔlɛn, Bɔɔl dza dzɔ dzəh yi jum wə i kimbu kə wi nì nyani yɛiŋ, dzə i Ɛfɛsus. Si wi dzə fɛiŋ wi yɛiŋ mbaŋ wi bəni bə bumni bədɔkɔ, ");
INSERT INTO cug_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","bikə i bɔ a, “Kiŋ'waka ki Baiŋni nì dzə alə i mbɛiŋ wə, i jɔbi wə mbɛiŋ nì jiə shɔm i Jisɔs wə a?” Bɔ chukuli a, “Buku ka num wɔkɔ dəkə a gia yidɔkɔ kɔlə ka Kiŋ'waka ki Baiŋni.” ");
INSERT INTO cug_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bɔɔl bikə i bɔ a, “A kabə num yaka, bə nì juli mbɛiŋ i bɔkɔ kɔm nə la?” Bɔ chukuli a, “Bə nì juli buku i bɔkɔ biəli si Jɔn nì fukuki.” ");
INSERT INTO cug_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bɔɔl ka dzaka i bɔ a, “Jɔn nì juliki bəni i bɔkɔ i chusi a bɔ nì kwuni shɔ́m yibɔ, wi nì dzakaki a bɔ bûm num i mi wə wi dzəki i ŋgaiŋ jum, ayaka mi wə wi nì dzakaki kɔ Jisɔs.” ");
INSERT INTO cug_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Bəni bəwɔ wɔkɔ si Bɔɔl dzaka yakadəiŋ, bə ka juli bɔ i bɔkɔ num i yɛli wi Bah Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bɔɔl jiə kaŋ i bɔ wə, Kiŋ'waka ki Baiŋni ka dzə i bɔ wə. Bɔ dza ka dzakaki já yidɔkɔ bɔ kiə kə yi, ka chu fukuki tə i bəni gia yə bɔ wɔkɔ si Nyɔ dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Bəni bəwɔ nì kɔ ka jwɔfi ntsɔ bəfa. ");
INSERT INTO cug_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bɔɔl ka numki a i Ɛfɛsus, ka tsəki i juŋ yi tsani wə i kifiəŋŋ kitali wə, dzaka i bəni chu lwa kə. Bəh bɔ gukuli bəŋgukuli, wi mɔmsi i fə a bɔ bûm gia yə wi dzakaki kɔm ŋkuŋ bi Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bəni bədɔkɔ ləkə kifwu, nəiŋ i bum, ka dzakaki ja yichu i bəni nshiŋ kɔm dzəh yi Bah. Bɔɔl ka bee bɔ, dzɔ mbaŋ wi bəni bə bumni bəh bɔ tsə num i juŋ yi lanini yi Taylanus wə, ka dzakaki i bɔ fɛiŋ chɔkɔ bichi. ");
INSERT INTO cug_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bɔɔl fə yaka lə i jía wə yifa. Ayakadəiŋ, Bəju bəh Bəglik bəchi bə̀ i tumi ki Ɛsia wə fɛiŋ wɔkɔ gia yi Bah. ");
INSERT INTO cug_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bɔɔl nì kɔ, Nyɔ nì fəki, wi ka fəki gia yi kaŋyini num yi dzaka ki wɔmni. ");
INSERT INTO cug_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Bə nì dzɔki na finaiŋ fiɛŋ fi, ka kinchumni kimbuŋ nabə mbuŋ wi nɔm, tsə kɔm mi wi jwɛiŋ yɛiŋ, wi bɔnih a bɔninih kɔŋ a numki na mi wə wi kaŋaki kiŋ'waka kichu i gwu wə, ki buku. ");
INSERT INTO cug_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Bəju bədɔkɔ bə̀ bɔ nì nyaniki bwiliki biŋ'waka bichu i bəni wə, bɔ dza ka mɔmsiki i bɔɔŋki yɛli wi Bah Jisɔs, ka bɔ bwili biŋ'waka bichu biwɔ. Mi ka dzaki dzakaki i biŋ'waka bichu a, “Mih bwiliki wɔ i yɛli wi Jisɔs wə Bɔɔl fukuki.” ");
INSERT INTO cug_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Bəni bə̀ bɔ nì mɔmsiki gia yiwɔ nì kɔ nanitaŋ, a nì kɔ bwa bə Sikɛfa wə fwu wi bətii mfə gia wi Bəju. ");
INSERT INTO cug_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ayaka kiŋ'waka kichu ka bi bikə i bɔ a, “Mih kiəki lə Jisɔs, kiə tə Bɔɔl, mbɛiŋ kɔ fimbɛiŋ num bə ndə a?” ");
INSERT INTO cug_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mi wə kiŋ'waka kichu kiwɔ nì kɔ i gwu yi wə dza chufi kwa lɔ bəni bəwɔ bəchi, kwɔksi bɔ i kuku, bɔ kwini buku i juŋ yi mi wiwɔ mə, a bəh chwɔŋ kiyəə bəh biəkə i gwu wə. ");
INSERT INTO cug_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Bəju bəh Bəglik bəchi bə̀ bɔ nì nɔki i Ɛfɛsus wɔkɔ kɔm gia yiwɔ, ka lwaki. Ayaka bəni yisi i kɔksiki yɛli wi Bah Jisɔs, tsə a ninshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Bəni bəduli bə̀ bɔ nì kɔ num bəni bə bumni ka dzəki fukuki chu tɔyi gia yichi yichu yə bɔ nì fəki i nyumi wə. ");
INSERT INTO cug_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Bədɔkɔ bəduli bə̀ bɔ nì fəki mfim, juŋni biŋwakti bibɔ bi mfim, dzə fɛiŋ ka kpa i bəni nshiŋ. Ayaka bə fa kpɔ wi biŋwakti biwɔ wichi, wi buku bənchuku mbaŋshi (50,000). ");
INSERT INTO cug_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ayakadəiŋ, gia yələ yichi fə gia yi Bah liə i shɔ́m yi bəni wə nalə, ka waŋki tsəki a ninshiŋ ninshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Si yəmaka nì tsə, Bɔɔl yɛiŋ a ŋgaiŋ ni tsə lə i Jɛlusalɛm, a i jɔbi wə ŋgaiŋ ni nyəki, ŋgaiŋ ni tsə dzəh i bimbu bi Masedɔnia bəh bi Akɛya. Wi ka chu dzaka a, “Mih ka ni tsə buku i Jɛlusalɛm, ma mih ni kaŋaki i tsə buku tə i Lum.” ");
INSERT INTO cug_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Wi ka yisi faaŋ bəni bəfa i ninshiŋ, a num Timɔti bəh Ɛlastus bə̀ bɔ nì gamtiki wi, bɔ tsə i ninshiŋ i Masedɔnia. Wi baaŋ chu nɔ dzɔ i Ɛsia twɛsi. ");
INSERT INTO cug_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A num jɔbi wiwɔ, ndani nì dza yisi i Ɛfɛsus kɔm dzəh yi Bah a kɔbi kə wi twɛsi. ");
INSERT INTO cug_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tii wi biəŋni biɛiŋ widɔkɔ nì kɔ fɛiŋ, yɛli num Dɛmitiyus, wi nì shi kɔ a biəŋki biɛiŋ biə bi bwɔsiki juŋ yi fəni yi gia yi nyɔ wə bɔ nì bɔɔŋki a Atɛmis. Nɔm wələ nì dzəki lə bəh kpɔ i bəni bə̀ bɔ biəŋki biɛiŋ biwɔ a kɔbi kə wi twɛsi. ");
INSERT INTO cug_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Dɛmitiyus ka juŋni bəni bə̀ bɔ nì biəŋki biɛiŋ biwɔ bichi, bəh bəni bə̀ bɔ nì nɔmki ŋkaiŋni wi nɔm wiwɔ, bɔ juŋni dzə. Wi ka dzaka i bɔ a, “Bwa bə nih bəŋ, mbɛiŋ kiəki alə, a nɔm wələ kɔ wə bukumbɛiŋ kafiki kpɔ yɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mbɛiŋ yɛiŋki lə chu wɔkɔ gia yə fimbwə fiələ bə bɔɔŋki a Bɔɔl si wi fəki. Wi nyaniki dzakaki a bənyɔ bə̀, bə kɛiŋsi a num bəh kaŋ kɔkə bənyɔ. Wi fə lɔ yaka, ka fiəni mfi bi bəni bəduli i fa Ɛfɛsus, wi si bɔɔŋ fiəni tə bəni bə Ɛsia bəchi, bɔ ka bum i wi. ");
INSERT INTO cug_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Mih yɛiŋ a nɔm wibukumbɛiŋ wələ ni kwati lə yɛli wichu. A kɔbi shəŋ ayaka, juŋ yi fəni yi gia yi nyɔ wimbum wi kpaŋni wə Atɛmis wələ yi ni fiəni i fiɛŋ fi kilɔlɔ. Yi ka num yakadəiŋ, ma yi ni numki a bə ŋgəmsi lɔ nyɔ wimbum wələ wə wi kɔ bə kɔksi i Ɛsia wichi, mbi wələ wichi kɔksi tə wi.” ");
INSERT INTO cug_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Si bəni bəwɔ wɔkɔ yaka, shɔ́m bɔkɔ bɔ. Bɔ ka yisi i wiliki, dzakayi a, “Atɛmis wi Ɛfɛsus kɔ nyɔ wimbum.” ");
INSERT INTO cug_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kwili wiwɔ wichi nəŋni. Mbaŋ wi bəni bə̀ bɔ nì juŋni ka liəni i Gayus bəh Alistakus wə, a num bəni bə Masedɔnia bə̀ bɔ nì nyaniki bɔ bəh Bɔɔl, guku tsə bəh bɔ i juŋ yi juŋnini a chu num yi nəni. ");
INSERT INTO cug_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bɔɔl ka nəŋki i liə tsə i ninshiŋ wi mbaŋ wiwɔ, bəni bə bumni nəiŋ. ");
INSERT INTO cug_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Bəni bəmbum bədɔkɔ, a kaŋa bɔ tumi kiwɔ bɔ num nsɛiŋ yi fɛiŋ, chu faaŋ ntum i wi, tsa a, wi ma mɔ̂m i tɔ̂m gvu wi fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Mbaŋ wi bəni bə̀ bɔ juŋni dza nəŋni ka wiliki na dəiŋ. Ayaka bədɔkɔ ni wiliki tsəki lə, bədɔkɔ wili tsə lə. Bəni bəduli nəki kiə kə gia yə bɔ si juŋni fɛiŋ kɔm yi. ");
INSERT INTO cug_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Bəju ka dzɔ Alɛksanda tsəsi i ninshiŋ i mbaŋ wi bəni wə, bəni bədɔkɔ yɛiŋ ka kwakaki a wi kiəki lə gia yidɔkɔ yɛiŋ. Wi ka chiki bəni bəh kaŋ ka wi baŋyiki gwu yi. ");
INSERT INTO cug_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Jɔbi wə bəni bəwɔ nì kiə a Alɛksanda kɔ mi wi Ju, bɔ chu wili kaasi tsə sə a ninshiŋ a i mi wimu wə, dzakayi a, “Atɛmis wi Ɛfɛsus kɔ nyɔ wimbum.” Ayaka bɔ wili yakadəiŋ, i tsə buku i mbiəŋə wifa wə. ");
INSERT INTO cug_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mi wi nyakani wi Kwili wimbum wiwɔ ka dza chi bɔ, bɔ kpichumi. Wi bikə i bɔ a, “Bəni bə Ɛfɛsus, mi kɔlə wə wi məŋniki a, akɔ bukumbɛiŋ bəni bə Ɛfɛsus bə̀ bɔ kaŋaki juŋ yi fəni yi gia yi nyɔ wi Atɛmis, bəh təh wi nyɔ wə wi nì gbɔ i bɛiŋ a? ");
INSERT INTO cug_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Si mi mɔŋ wə wi kɔ i gukuliki gia yələ, mbɛiŋ kaŋaki i kpîchumi mɔŋ, mbɛiŋ ma fə̂ki ka bəni bə yuŋsini. ");
INSERT INTO cug_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mbɛiŋ dzə bəh bəni bələ fa maka bɔ chwɔ fiɛŋ i juŋ yi bənyɔ wə, nabə i dzaka ja yichu yidɔkɔ kɔm bənyɔ wi kpaŋni wibukumbɛiŋ wələ. ");
INSERT INTO cug_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","A kabə num a, Dɛmitiyus bəh bəni bu kaŋaki lə nsaka bəh mi widɔkɔ, chɔkɔ biə bə si saka bənsaka yɛiŋ kɔlə, biə bɔ kɔ tsə yɛiŋ bəni bə̀ bɔ sakaki bənsaka bəh bɔ saka. ");
INSERT INTO cug_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Gia yidɔkɔ kabə kɛiŋki yə mbɛiŋ nəŋki yi tsə yələ, bə ni tsɛiŋ ləkə i yɛiŋ kintəəŋ i kijuŋni ki bətii kwili wə. ");
INSERT INTO cug_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mih dzakaki lə, kɔm mih yɛiŋ a gia yi daiŋ kɔlə i ləkə bukumbɛiŋ i gia wə, a bukumbɛiŋ kɔ, num bə yisi ndani. Yi ka num yakadəiŋ, bukumbɛiŋ ma ni chu kaŋa na gia yi chəŋ yə bə kɔ i chukuli.” ");
INSERT INTO cug_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Si wi dzaka yakadəiŋ, ka dzaka i kijuŋni kiwɔ gâali. ");
INSERT INTO cug_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Asi ndani biə i Ɛfɛsus nì kaa, Bɔɔl bɔɔŋ mbaŋ wi bəni bə bumni, təfi bɔ ka bɔni bɔ ka nyə i tsəki i Masedɔnia. ");
INSERT INTO cug_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Wi tsə nyani jikə bimbu biwɔ fɛiŋ wə, shili shɔ́m yi bəni bə bumni nalə, ka daŋsi tsə i Glees, ");
INSERT INTO cug_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","nɔ fɛiŋ kifiəŋŋ kitali. Wi dza a ŋgaiŋ nəŋki i tsə liə i ŋgwuki wimbum wə i tsə i Silia, ka wɔkɔ a Bəju gbɔki wi i dzəh. Wi ka yɛiŋ a yi ndzɔŋki lə a ŋgaiŋ fiəni tsə dzəh i Masedɔnia. ");
INSERT INTO cug_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Wi ni nyaniki bɔ bəh Sɔbata wə waiŋ Bilus wi Bɛlia, bəh Alistakus bəh Sɛkundus bə Tɛsalɔnika, bəh Gayus wi Dɛlbi, bəh Timɔti, bəh Tichikus bəh Tɔfimus bə̀ bɔ nì kɔ bəni bə Ɛsia. ");
INSERT INTO cug_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Bəni bələ ka tsə i ninshiŋ ka wɔkɔli buku bəh Bɔɔl i Tɔwas. ");
INSERT INTO cug_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ayaka Dzini bi Blɛd wə bə ka jiə dəkə dzɔɔŋ yɛiŋ tsə, buku liə ŋgwuki wimbum i Filibi, dzɔ kaŋ yite i kwati bɔ ka chiŋni bəh bɔ i Tɔwas, buku bɔ nɔ fɛiŋ kaŋ nanitaŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","A dzə num i chɔkɔ bi ninshiŋ wə i shi wə, buku bəh kijuŋni, juŋni i fijɔbi i gbɛ blɛd. Si Bɔɔl nì kɔ i buku nyə kichwɔŋɔchwɔŋ, wi ka yisi i dzakaki i bɔ, ka dzaka i tsə buku nchɔkɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Buku bɔ nì kɔ num i kimbu ki juŋ yi bɛiŋ wə, bimbaiŋsi baiŋ fɛiŋ numə biduli. ");
INSERT INTO cug_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Waiŋ sumi widɔkɔ yɛli wi num Yutikus num i wundu wə. Wi ka dza yisi i nɔki, si Bɔɔl nì dzakaki tsəki a dzakani. I jɔbi wiwɔ wə wi gɔkɔ kinu, ka dza fɛiŋ gbɔ shi i kuku, fɛiŋ nì kɔ juŋ yi tumnini yitali i yisi i kuku. Ayaka bɔ tsə dzɔ wi num wi kpi lɔ. ");
INSERT INTO cug_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bɔɔl shi tsə ŋgwuŋ i wi bɛiŋ, maŋni wi dzaka i bəni a, “Wi kɛiŋki lə, mbɛiŋ ki nyûfiki kə gwu yimbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bɔɔl fiəni yaka i kimbu ki bɛiŋ kiwɔ mə, gbɛ blɛd dzi, ka chu yisi i dzakaki bəndzaka chɔkɔ wɔɔ wi ka nyə. ");
INSERT INTO cug_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Bəni ka dzɔ sumi wiwɔ kwɛ bəh wi i dzu wi num wiwɔm, shɔm yibɔ də nalə. ");
INSERT INTO cug_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Buku liə i ŋgwuki wimbum mə i bɔkɔ, ka tsə i Asɔs, si Bɔɔl nì sisi jiə a, akɔ fɛiŋ di biə buku nì dzɔ wi. Wi nì dzaka yakadəiŋ, kɔm wi nì nəŋki i nyani bəh gvu. ");
INSERT INTO cug_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wi ka kwati buku i Asɔs, buku ka dzɔ wi i ŋgwuki wə, buku bɔ tsə buku i Mitilin. ");
INSERT INTO cug_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Buku ka nyə fɛiŋ i ŋgwuki wə, chɔkɔ buku wɔɔ, buku dzə i kɔmsi i Kiɔs, tsə, chɔkɔ chu buku wɔɔ, buku dzə buku i Samɔs, chu tsə, chɔkɔ chu buku wɔɔ, buku ka liə i Miletus. ");
INSERT INTO cug_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Buku nì nyaniki yakadəiŋ, kwaŋ tsə i Ɛfɛsus kɔm Bɔɔl nì kɔŋki kə i wɔɔ jɔbi i Ɛsia. Wi nì fɔbliki tsəki yaka kɔm a yuwidɔkɔ ŋgaiŋ kɔlə ni tsə buku i Jɛlusalɛm i chɔkɔ bi Dzini bi Bɛntekɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Si buku liə i Miletus, Bɔɔl faaŋ ntum i bətii kijuŋni ki bəni bə bumni i Ɛfɛsus a bɔ dzə yɛiŋ ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Bɔ dzə, wi dzaka i bɔ a, “Mbɛiŋ kiəki lə si nɔni kəŋŋ nì kɔ bəh mbɛiŋ i yisi i chɔkɔ bi ninshiŋ biə mih nì tɔm gvu yiŋ i nshwaiŋ yi Ɛsia wə. ");
INSERT INTO cug_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mih nì kɔ num mih shisi gwu yiŋ, ka nɔmki i Nyɔ bə mindəm i dzə́kəh yiŋ chɛiŋ. Mih chu yɛiŋ bəŋgəkə i dzə́h yiduli wə si Bəju nì bwaŋki gvu i mih chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Mbɛiŋ chu kiəki lə tə si mih nì laniki mbɛiŋ i bəni kintəəŋ, chu nyani nlani i juŋ juŋ wə. Mih nì nyumiki kə gia yidɔkɔ yə yi kɔ i gamti mbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mih nì fukuki shəŋ num a gia yimu i Bəju bəh bəni bə̀ bɔ kɔkə Bəju, fuku a bɔ kwûni shɔ́m yibɔ, yi fiə̂ni dzə̂ i Nyɔ, bəh i jîə shɔ́m i Bah wibukumbɛiŋ wə Jisɔs Klistus. ");
INSERT INTO cug_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","I liə, mbɛiŋ wɔ̂kɔli, mih tsəki i Jɛlusalɛm num asi Kiŋ'waka ki Baiŋni dzaka i mih, mih kiəki kə a, akɔ tsə num nə bəh mih fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Gia yə mih kiəki kɔ a di bichi biə mih tsəki i fɛiŋ, Kiŋ'waka ki Baiŋni fukuki lə i mih, a nsəŋ bəh ŋgəkə wɔkɔliki mih i ninshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ayakalə, mih yɛiŋki kə nɔni kəŋŋ, a akɔ fiɛŋ fidɔkɔ, a kɔbi a mih kâasi lə nɔm wə Bah Jisɔs kɔ wi nya i mih, yi num a, mih fûkuki ntum wi ndzɔŋni kɔm si Nyɔ chusi shɔm yi yindzɔŋni i bəni. ");
INSERT INTO cug_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","I liə, mbɛiŋ wɔ̂kɔli, mih kiəki kə a mi widɔkɔ i mbɛiŋ kintəəŋ kɔlə wə buku bɔ nì kɔ mih fuku kɔm ŋkuŋ bi Nyɔ, bi chu yɛiŋ lə shi mbiŋ a. ");
INSERT INTO cug_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Mih lansiki dzakaki i mbɛiŋ daiŋ a mi widɔkɔ kabə num i mbɛiŋ kintəəŋ wi num i laka i liə, mih kaŋaki kə kaŋ yɛiŋ, ");
INSERT INTO cug_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","kɔm mih nì ka nyumi i fuku gia yichi i mbɛiŋ yə Nyɔ kɔŋki. ");
INSERT INTO cug_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Jɔbi wə mbɛiŋ baaŋ, mbɛiŋ ka tɔ̂kniki bəh gwu yimbɛiŋ, bəh mbaŋ wi bəni bə bumni bə̀ bɔ kɔ ka shwáŋ, bə̀ Kiŋ'waka ki Baiŋni kɔ ki fə mbɛiŋ num kifwu i bɔ bɛiŋ. Mbɛiŋ nûmki bəntɔkni shwáŋ i kijuŋni ki bəni bə Nyɔ bə̀ wi nì taŋ bəh mwa mi Waiŋ wi. ");
INSERT INTO cug_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mih kiəki lə a mih nì ka fiəni gbaksi gwu, bəkwula ni dzə liə i mbaŋ wimbɛiŋ wə, ma bɔ ma ni bee mi widɔkɔ i kwa. ");
INSERT INTO cug_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Bəni bədɔkɔ ni buku lə na i mbɛiŋ kintəəŋ, i fwɔkyiki mbaŋ wi bəni bə bumni, guku bɔ, bɔ tsə i mbaŋ wibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ayakadəiŋ, mbɛiŋ tɔ̂kniki, mbɛiŋ kwaka a mih lani mbɛiŋ bəchi i jía yitali wə, nchɔkɔ bəh nshi bəh mindəm i dzə́kəh yiŋ chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Mih nyaki mbɛiŋ i liə i kaŋ yi Nyɔ wə, bəh gia yi yə yi kɔ kɔm ŋgamti wi Nyɔ i bəni. Gia yələ kɔlə i fə mbɛiŋ kɔɔki, ka mbɛiŋ bi kwati di i di biə Nyɔ jiə i bəni bə̀ wi fə a bɔ kɔ mbu. ");
INSERT INTO cug_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mih nì kaŋaki kə kindzəŋ i kpɔ wi mi wə nabə bəmbuŋ bu. ");
INSERT INTO cug_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Mbɛiŋ kiə bindzɔŋ a, akɔ kaŋ yiŋ yələ yi nì nɔmki biɛiŋ bichi biə buku mbaŋ wuŋ nì nəŋki. ");
INSERT INTO cug_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","I biɛiŋ bichi biələ, mih nì chusiki i mbɛiŋ a, mi kaŋaki i nɔmki bindzɔŋ, ka wi ni gamtiki bəni bə ŋgəkə, kwaka si Bah Jisɔs nì dzaka a, ‘Ndzɔŋni bimbum kɔ bi mi wə wi nyaki, tsə bi mi wə wi dzɔki.’” ");
INSERT INTO cug_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Si Bɔɔl dzaka kaasi yakadəiŋ, bəh bɔ ka tum binyu i kuku bəchi, tsa. ");
INSERT INTO cug_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ayaka bɔ dza gbɔ bəh mindəm ka dəki, maŋni Bɔɔl kɔmyi wi, a bə bɛsi. ");
INSERT INTO cug_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Gia yə yi nì fə bɔ ka dəki bəh ŋga akɔ gia yə Bɔɔl nì dzaka a bɔ bi chu yɛiŋ kə shi bi. Bɔ ka tsə chiŋsi wi, wi liə i ŋgwuki wimbum mə. ");
INSERT INTO cug_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Asi buku bəh Bɔɔl bɔni, buku ka nyə fɛiŋ daŋ i ŋgwuki wimbum mə chəŋ, tsə buku i Kɔs. Chɔkɔ buku wɔɔ, buku tsə i Lɔdəs, nyə fɛiŋ, tsə i Batala. ");
INSERT INTO cug_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Si buku tsə buku fɛiŋ, yɛiŋ ŋgwuki wimbum widɔkɔ wi tsə i Fɔnishia, buku liə yɛiŋ ka tsəki. ");
INSERT INTO cug_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Buku yɛiŋ Sayblus, ka bee i tsɛiŋ yi kimiəkə wə ka daŋsi tsə buku i Taya i tumi ki Silia wə i di biə ŋgwuki nì kaŋaki i bwili biɛiŋ fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Buku nəŋ bəni bə bumni fɛiŋ, buku bɔ nɔ kaŋ nanitaŋ. Kiŋ'waka ki Baiŋni fə, ka bɔ təfi Bɔɔl a wi ma mɔ̂m i tsə̂ i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Buku bɔ nɔ, chɔkɔ dzə kpɛiŋ ka buku nyə, buku ka kwa dzəh. Bɔ bəchi buku, bəkaŋa bəbɔ bəh bwa bəbɔ, i chiŋsi buku, buku bɔ buku i kwili wiwɔ kintəəŋ tsə buku i kinchwɔ kimbum kpəŋ, buku bɔ tum binyu i kuku, tsa ka bɔni. ");
INSERT INTO cug_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Buku liə i ŋgwuki mə, bɔ ka fiəni tsə i juŋ yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Buku ka nyə i Taya, kwa dzəh, tsə buku i Tɔlɛmay. Buku bwa bə nih bə bumni bɔni, ka nɔ kpaŋ wimu. ");
INSERT INTO cug_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Chɔkɔ buku wɔɔ, buku nyə tsə buku i Kaysalia, ka tsə i Filib dzu wə wi nì nyaniki fukuki gia yi Nyɔ, buku bɔ nɔ. Filib wələ nì kɔ mi wimu i mbaŋ wi bəni bə̀ wə nanitaŋ bə̀ bə nì sabi. ");
INSERT INTO cug_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wi kaŋa bwa bəkaŋa bənaa, bɔ kɛiŋ ki kiə kə bənyuku, bɔ nì fukuki i bəni gia yə bɔ wɔkɔki Nyɔ dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Buku num fɛiŋ i kaŋ yiduli wə, mi widɔkɔ wə wi nì fukuki gia yə wi wɔkɔki si Nyɔ dzakaki bi nyə i Judea shi dzə fɛiŋ, yɛli wi num Agabus. ");
INSERT INTO cug_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Agabus dzə yɛiŋ buku, dzɔ chiŋni wi Bɔɔl, ka fiəni kaŋa gvu bəh kaŋ yi yɛiŋ, ka dzaka a, “Kiŋ'waka ki Baiŋni dzakaki a, akɔ asi Bəju bə Jɛlusalɛm bi kaŋa mi wə wi kaŋaki chiŋni wələ, i nya wi i kaŋ yi bəni bə̀ bɔ kɔkə Bəju.” ");
INSERT INTO cug_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Buku wɔkɔ yakadəiŋ, buku bəh bəni bəchi bə̀ bɔ nì kɔ fɛiŋ ka tsaki Bɔɔl a wi ma tsə̂ i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Wi chukuli a, “Mbɛiŋ fəki num nə lə a? Mbɛiŋ kiəki kə a mbɛiŋ dəki lə mbɛiŋ nəŋni num shɔm yiŋ a? Mih kɔ mih kɛiŋsi gwu a kɔbi a i liə i nsəŋ wə i Jɛlusalɛm shəŋ. Mih kɔ num mih chu kɛiŋsi tə gwu na i kpi fɛiŋ kɔm yɛli wi Bah Jisɔs.” ");
INSERT INTO cug_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Si dzəh nì ka num fɛiŋ i fə a wi kwûni kiŋkwaka ki, buku ka bee, ka dzaka shəŋ a, “Ma yi nûm asi Bah nəŋki.” ");
INSERT INTO cug_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kaŋ yidɔkɔ tsə, buku juŋni biɛiŋ bibuku, ka yakaki tsəki i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Bəni bə bumni bədɔkɔ bə̀ i Kaysalia yaka buku bɔ, dzɔ tsə bəh buku i juŋ yi Manasi wə, i di biə buku nì kaŋaki i nɔki. Ayaka Manasi wələ nì kɔ mi wi Sayblus, a num mi widɔkɔ i kintəəŋ ki bəni bə̀ bɔ nì yisi jiə shɔm i Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Asi buku nì tsə buku i Jɛlusalɛm, bəni bə bumni bə fɛiŋ dzɔ buku bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Chɔkɔ buku wɔɔ, buku bəh Bɔɔl laa njikə i Jɛm, bətii bə kijuŋni bəchi nì kɔ tə fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bɔɔl ka bɔni bɔ, ka dzaka gia yichi i bɔ yə Nyɔ nì fə i bəni bə̀ bɔ kɔkə Bəju tsə dzəh i nɔm wə wi nì nɔmki. ");
INSERT INTO cug_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Bɔ wɔkɔ yaka, ka yisi i tumki bikum bi Nyɔ. Ayakalə, bɔ dzaka i Bɔɔl a, “Waiŋnih wibuku, tsɛ̂iŋ si Bəju kɔ bɔ jiə shɔm i Jisɔs wə bənchuku bənchuku. Ayakalə, bɔ num yakadəiŋ bɔ kɛiŋ bɔ num i bənchi bə Muses wə na bəh ŋga, ");
INSERT INTO cug_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Bə kɔ bə fuku lɔ i bɔ kɔm wɔ, a wɔ nyaniki laniki Bəju bə̀ bɔ nɔki i tumi kidɔkɔ wə, a bɔ bee bənchi bə Muses, dzaka a, kiə bɔ ma sûuŋki bwa bəbɔ, bəh a kiə bɔ ma bîəliki nɔni ki tumi kiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Si yi kɔ yaka bɔ kaŋaki lə i ni kiə a wɔ dzə, bukumbɛiŋ ki fə̂ki dəiŋ i liə? ");
INSERT INTO cug_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Buku ni fuku lə i wɔ gia yə wɔ ni fə̂. Buku kaŋaki lə bəni fa bənaa num bɔ fə kiŋkaka i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Dzɔ̂ bɔ, mbɛiŋ bɔ tsə̂ wɔ̂kɔ shi bimbɛiŋ, wɔ gɔ̂m biɛiŋ bichi biə bə kaŋaki i gɔm ka bɔ tsə̂ kə̂ə kifwu kibɔ. Wɔ ka fə yakadəiŋ, bəni bəchi ka ni kiə a wɔ jiəki lə tə bənchi bə Muses, ayaka gia yichi yə bə dzakaki kɔm wɔ yi ma ni numki ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","I bəni bə bumni bə̀ bɔ kɔkə Bəju, buku kɔ num buku nì jiə kimfasi ka nyaka kiŋwakti chiŋsi i bɔ a, kiə bɔ ma dzîki biɛiŋ bidzini biə bə fə bimfə gia yɛiŋ i bənyɔ wə. Kiə bɔ ma dzîki mwa mi nyam. Kiə bɔ ma dzîki nyam yə yi kɔ maka bə kum yi mwa buku. A bɔ bwili kaŋ yibɔ i nɔni ki tɔkɔlini wə.” ");
INSERT INTO cug_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ayakadəiŋ, Bɔɔl ka dzɔ bəni bəwɔ, chɔkɔ buku wɔɔ bəh bɔ tsə wɔkɔ shi bibɔ. Bɔɔl ka tsə i juŋ yi fəni yi gia mə, fuku chɔkɔ biə kaŋ yi wɔkɔni shi ni tsə, bə ni ka nya binya i bɔ i mi wimu wimu. ");
INSERT INTO cug_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Asi kaŋa yiwɔ nanitaŋ nì kɔ a kaa, Bəju bədɔkɔ bə̀ bɔ nì buku dzə i Ɛsia yɛiŋ Bɔɔl i juŋ yi fəni yi gia mə, ka nyini mbaŋ wi bəni, kwa wi, ");
INSERT INTO cug_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","bɔ ka wiliki dzakayi a, “Bəni bə Islae, mbɛiŋ gamti buku. Akɔ mi wələ wi nyaniki laniki gia yichu, i bəni i di bichi kɔm tumi kibuku bəh bənchi bə Muses bəh kɔm juŋ yi fəni gia yələ. Wi fiəni bəkəli kaasi i dzɔki bəni bə̀ bɔ kɔkə Bəju, dzə bəh bɔ i juŋ yi fəni yi gia mə fa, ka bəkəli di bi baiŋni biələ.” ");
INSERT INTO cug_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Bɔ nì dzakaki yaka, kɔm bɔ nì yɛiŋ Bɔɔl wi nyani nnya i kwili wə bəh Tɔfimus mi wi Ɛfɛsus. Bɔ ka kwaka a Bɔɔl liə bəh wi i juŋ yi fəni gia mə. ");
INSERT INTO cug_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ayaka wili wiwɔ fə kwili wichi nəŋni, bəni ka yɔkɔki dzəki fɛiŋ. Bɔ bwam kaŋa Bɔɔl, guku buku bəh wi i juŋ yi fəni gia mə, akisəkə, bɔ ka baŋ dzaka bifiəŋə. ");
INSERT INTO cug_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Bɔ ka nəŋki i wɔɔ Bɔɔl, ntum wiwɔ liə i ntuni ki tikwili wi fwu wi bəni bə jum bə Lum a, Jɛlusalɛm wichi si shakyi. ");
INSERT INTO cug_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Wi ka nyə akisəkə, dzɔ bəni bənchi bəh kifwu ki mbaŋ wi bəni bə jum bədɔkɔ bəh bɔ yɔkɔ shi tsə fɛiŋ. Si bəni nì yɛiŋ bəni bə jum bəh tikwili wi fwu wi bəni bə jum num fɛiŋ, bɔ ka bee i twɛiŋki Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tikwili wi bəni bə jum wiwɔ ka dzə kwa Bɔɔl, dzaka a bɔ kaŋa wi bəh bənsəŋ bəfa. Wi bikə i bɔ a, “Wələ kɔ ndə? Wi fə nə?” ");
INSERT INTO cug_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","I fɛiŋ wə, bəni dza ka wiliki tsəki lə, bədɔkɔ wili tsə lə. Wi nəki kiə kə gia yə yi num. Wi ka dza dzaka i bəni bu a bɔ dzɔ̂ Bɔɔl bɔ yâka bəh wi i di bi bəni bə jum wə. ");
INSERT INTO cug_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Bəni bə jum bəwɔ dzɔ wi, jɔbi wə bɔ nì yakaki tsəki i dzəh yə yi kɔ i bəntəm bəntəm wə, bɔ dza giŋ lɔ Bɔɔl giŋni kɔm mbaŋ wi bəni nì jumki i lɔkɔ wi. ");
INSERT INTO cug_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Bɔ nì biəliki yaka, wili dzakayi a, “Bə laksi wi.” ");
INSERT INTO cug_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Asi bɔ nì liə bəh Bɔɔl i di bi bəni bə jum wə, wi tsa tikwili wi fwu wi bəni bə jum a, “Mih kɔlə i dzaka gia yidɔkɔ i wɔ a?” Wi wɔkɔ yaka, ka bikə i Bɔɔl a, “Wɔ kiəki lə já yi Glik a? ");
INSERT INTO cug_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","A mɔŋ wɔ mi wi Ijib wə wi nì yisi ndani bəh kifwu ki tumi i jɔbi widɔkɔ wə, wi guku mbaŋ wi bəni bənchuku bənaa (4,000), bə̀ bɔ nì wɔɔyiki bəni bə̀ bɔ tsə ka numki i chwa a?” ");
INSERT INTO cug_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bɔɔl chukuli a, “Mih kɔ mi wi Ju, bə nì bwɔ mih i Tasus i tumi ki Silishia wə, Tasus num kə kwili wi nchiŋ. Mih tsaki wɔ, nyâ mih bəh dzəh mih dzâka i bəni bələ.” ");
INSERT INTO cug_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tikwili wi fwu wi bəni bə jum bəwɔ ka nya dzəh a wi dzaka. Bɔɔl ka num i di biə bi nì kɔ i bəntəm bəntəm wə, ka chi bəni bəh kaŋ. Bɔ ka kpichumi mɔŋ, wi dzaka i bɔ i já yi Hibulu wə a. ");
INSERT INTO cug_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Bəba bəh bwa bə nih bəŋ, mbɛiŋ wɔ̂kɔ ndzaka wuŋ i mbɛiŋ nshiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Bɔ ka wɔkɔ si wi dzakaki num i já yibɔ yi Hibulu wə, bɔ ka kpichumi lə mɔɔɔŋ. Bɔɔl ka dzaka a, ");
INSERT INTO cug_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mih kɔ mi wi Ju, bə nì bwɔ mih i Tasus i tumi ki Silishia wə, ayakalə bə kuku yaka mih i fa Jɛlusalɛm, mih lani kiŋwakti i kaŋ yi Gamalia wə. Wi nì kɛiŋsi lani mih bəh bənchi bə bətii bəbuku, mih ka numki bəh ŋga i gia yi Nyɔ wə nalə, asi mbɛiŋ bəchi bələ mbɛiŋ kɔ fa daiŋ lə. ");
INSERT INTO cug_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mih nì dzəki nyaki lə ŋgəkə bwaŋ gvu i bəni bə̀ bɔ biəliki Dzəh yi Bah, fə bə wɔɔyi bɔ, kwa bənyuku bəh bəkaŋa chiŋsi i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Fa kɔ gia yə kifwu ki bətii mfə gia bəh bəni bə̀ bɔ sakaki kwili kiəki lə yi lə gbuuŋ. A nì nyaki bɔ biŋwakti a mih tsə̂ kwâyiki bwa bə nih bəbuku bə̀ bɔ kɔ i Damaskus. Mih bə́ tsə i kwâyi bəni bə̀ bɔ biəliki Dzəh yi Bah, kâŋa dzə̂ bəh bɔ i Jɛlusalɛm bə nya ŋgəkə i bɔ. ");
INSERT INTO cug_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","A jɔbi wə mih nì kɔmsiki tsəki i Damaskus a num ka nshichuŋ, baiŋni bimbum bidɔkɔ dza mwaiŋ shi i mih bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mih gbɔ i kuku, ka wɔkɔ ja yi dzaka dzə i mih a, ‘Sɔɔl, Sɔɔl, wɔ bwaŋki gvu i mih chɛiŋ lə kɔm nə?’ ");
INSERT INTO cug_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mih bikə a, ‘Bah, akɔ wɔ ndə?’ Ja yiwɔ chukuli a, ‘Akɔ mih Jisɔs wi Nasali, num mih wə wɔ bwaŋki gvu i wi chɛiŋ.’ ");
INSERT INTO cug_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Bəni bə̀ bɔ nì kɔ buku bɔ nì yɛiŋ baiŋni biwɔ, ayakalə nəki wɔkɔ kə ja yi mi wə wi nì dzakaki buku wi. ");
INSERT INTO cug_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mih ka chu bikə a, ‘Bah, mih kɔ i fə dəiŋ a?’ Wi chukuli i mih a, ‘Dzâ bɛiŋ, lîə tsə̂ i Damaskus, ma bə fûku i wɔ fɛiŋ, nɔm wichi wə Nyɔ kɔ wi kɛiŋsi jiə i wɔ a wɔ nɔmki.’ ");
INSERT INTO cug_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Mih ka dza fɛiŋ, num baiŋni biə fə mih fəkə, bəni bə buku bɔ nì nyaniki ka tati liə tsə bə mih i Damaskus. ");
INSERT INTO cug_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Mi widɔkɔ num fɛiŋ i Damaskus, yɛli wi num Ananias, wi kɔksi Nyɔ nalə, jiə bənchi bəbuku Bəju bəchi bə̀ bɔ nì kɔ fɛiŋ kɔksi wi. ");
INSERT INTO cug_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Wi dzə yɛiŋ mih, num bɛiŋ i kɔmsi i mih kpəŋ ka dzaka i mih a, ‘Sɔɔl waiŋnih wuŋ, fîəni yɛ̂iŋ di.’ Akisəkə yakadəiŋ, mih fiəni ka yɛiŋki di, ka yɛiŋ tə wi Ananias. ");
INSERT INTO cug_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Wi dzaka i mih a, ‘Nyɔ wi bətii bəbuku kɔ wi babwili lɔ wɔ a wɔ kîə gia yə wi kɔŋki, bəh i yɛ̂iŋ Mi wi Nɔm wi Chəŋ, i wɔ̂kɔ ndzaka wə wi bukuki dzaka ki wə. ");
INSERT INTO cug_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Wɔ bi numki mi wə wi fukuki kɔm wi, fuku i bəni bəchi gia yə wɔ yɛiŋ bəh yə wɔ wɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Si yi kɔ yaka i liə, wɔ chu wɔkɔliki nə? Dzâ bɛiŋ bə juli wɔ i bɔkɔ, i wɔkɔ chu bia, asi wɔ tsaki i Bah.’ ");
INSERT INTO cug_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Mih nì fiəni tsə i Jɛlusalɛm, mih bə́ tsa i juŋ yi fəni yi gia wə, fiɛŋ ka ndəmsi dzə i mih wə. ");
INSERT INTO cug_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mih yɛiŋ Bah i fiɛŋ fiwɔ wə, wi dzaka i mih a, ‘Kɔmsi nyə̂ fa i Jɛlusalɛm wakli kɔm bəni bə fa ni bum kə gia yə wɔ fukuki kɔm mih.’ ");
INSERT INTO cug_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mih chukuli i wi a, ‘Bah, bɔ kiəki lə na bindzɔŋ a mih nì liəki i júŋ yi tsani mə, kwayi bəni bə̀ bɔ jiə shɔ́m i wɔ wə twɛiŋ bɔ. ");
INSERT INTO cug_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Jɔbi wə bə nì wɔɔki Stifɛn wə wi nì fukuki i bəni kɔm wɔ, akɔ mih wə mih nì kɔ na fɛiŋ mih tɔbi. Ayaka akɔ mih wə bəni bə̀ bɔ nì wɔɔ Stifɛn nì baayi nya bəmbuŋ bəbɔ mih kaŋa.’ ");
INSERT INTO cug_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Bah chu dzaka i mih a, ‘Nyə̂ fa, kɔm mih ni faaŋ lə wɔ i dzəh yi dəəŋ i bəni bə̀ bɔ kɔkə Bəju.’” ");
INSERT INTO cug_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Si Bɔɔl nì dzakaki bəni wɔkɔli, jɔbi wə ndzaka nì bukuki i dzaka ki wə, bɔ yisi ka wiliki na bəh ŋga, dzakayi a, “Bə kâasi bəh ŋkaiŋni mi wələ i fa nshwaiŋ wə. Akɔ kə mi wə wi kɔ i nûmki wiwɔm.” ");
INSERT INTO cug_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Bɔ nì wiliki yaka, sɛksi bəmbuŋ bəbɔ i bɛiŋ, ka waŋki kwɔŋɔ i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tikwili wi fwu wi bəni bə jum ka dza dzaka a bəni bə jum dzɔ̂ Bɔɔl ma bɔ tsə̂ bəh wi i di bibɔ wə, jɔbi wə bɔ ka tsə̂ bɔ twɛ̂iŋ wi, bɔ bîkə gia i wi, a wi fuku gia yə yi fə ka Bəju wiliki lə. ");
INSERT INTO cug_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Bɔ ka tsə bəh wi ka kaŋa a bɔ twɛiŋki, Bɔɔl bikə i fwu wi mbaŋ wi bəni bə jum widɔkɔ wə wi nì kɔ fɛiŋ a, “Nchi bumki lə a bə twɛ̂iŋki mi wi Lum maka bə saka nsaka wi a?” ");
INSERT INTO cug_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Fwu wi mbaŋ wi bəni bə jum wiwɔ wɔkɔ yakadəiŋ, ka tsə yɛiŋ tikwili wibɔ, dzaka i wi a, “Wɔ nəŋki mɔm num nə lə? Kîə a mi wələ kɔ mi wi Lum.” ");
INSERT INTO cug_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tikwili wiwɔ wɔkɔ yakadəiŋ, ka tsə yɛiŋ Bɔɔl bikə i wi a, “Lansi fûku i mih, a wɔ kɔ mi wi Lum a?” Ayaka wi bum. ");
INSERT INTO cug_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Tikwili wiwɔ dzaka i wi a, “Mih nì taŋ bəh kpɔ widuli, ka mih numki mi wi Lum.” Bɔɔl chukuli i wi a, “Mih kɔ mfiŋ mi wi Lum i bwɔ wə.” ");
INSERT INTO cug_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Bəni bə̀ bɔ nì kɔ i bikəyiki bəmbikə bəwɔ i wi ka fiəni chu i jum wə akisəkə. Tikwili wibɔ ka lwaki tə, kɔm wi nì kɔ wi dzaka bə kaŋa Bɔɔl a num mi wi Lum. ");
INSERT INTO cug_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Tikwili wiwɔ ka nəŋki i kɛiŋsi kiə gia yə Bəju nì jiəki i Bɔɔl wə. Ayaka chɔkɔ buku wɔɔ, wi dzaka a bə shwâ Bɔɔl, wi bɔɔŋ bətii mfə gia bəmbum bəh bəni bəchi bə̀ bɔ sakaki tumi, bɔ dzə, wi jiə Bɔɔl i bɔ nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bɔɔl lɔmsi dzə́kəh i bəni bə̀ bɔ sakaki tumi kiwɔ, ka dzaka a, “Bwa bə nih bəŋ, i nɔni kəŋŋ wə i dzə buku daiŋ, mih si fə num a gia yə mih kiəki a yi kɔ chəŋ i Nyɔ nshiŋ, gia yidɔkɔ kɔbi yə yi sakaki mih i shɔm yiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ananias wə wi nì kɔ fwu wi bətii mfə gia, dzaka i bəni bə̀ bɔ nì numbɛiŋ i kɔmsi i Bɔɔl kpəŋ, a bɔ chɔ̂kɔ wi i dzaka wə. ");
INSERT INTO cug_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bɔɔl chukuli i wi a, “Nyɔ ni chɔkɔ lə wɔ tə. Wɔ bwɔsiki kimbu ki juŋ kə bə chikə bəh fiəŋ wi fuku a biŋ. Wɔ lansi num a wɔ sakaki mih biəli nchi, chuku bwiŋ nchi wiwɔ chu dzaka a bə twɛ̂iŋ mih a?” ");
INSERT INTO cug_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Bəni bə̀ bɔ nì num bɛiŋ i kɔmsi i Bɔɔl wə bikə i wi a, “Wɔ tɔyi fwu wi bətii mfə gia wi Nyɔ a?” ");
INSERT INTO cug_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Wi chukuli a, “Bwa bə nih bəŋ, mih si kiəki kə a, akɔ fwu wi bətii mfə gia. Bə nyaka a, ‘Kiə mi ki dzâka kə gia yichu kɔm mi wə wi sakaki bəni.’” ");
INSERT INTO cug_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Jɔbi wə Bɔɔl nì yɛiŋ a bəni bədɔkɔ nì kɔ fɛiŋ a num Bəsadusi, bədɔkɔ num Bəfalasi, wi ka dzaka bə ja yiləkəli i kintəəŋ ki bəni bə̀ bɔ sakaki tumi a, “Bwa bə nih bəŋ, mih kɔ mi wi Falasi, mih num waiŋ wi Bəfalasi. Mih kɔ fa i nsaka wə kɔm mih tsɛiŋki tsəki a ninshiŋ, kiə a bəŋkwu bi dza lə i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Si wi dzaka yakadəiŋ, Bəsadusi bəh Bəfalasi ka yisi i yɔliki, kijuŋni kiwɔ gaali. ");
INSERT INTO cug_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Bɔ nì yɔliki yakadəiŋ, kɔm Bəsadusi nì shiki dzakaki a bəŋkwu bi dza kə i kpi wə, chu dzaka a fiɛŋ fidɔkɔ kɔkə ka bəchinda bə Nyɔ nabə biŋ'waka. Ayakalə, Bəfalasi nì bumki lə a biɛiŋ biələ bichi kɔlə. ");
INSERT INTO cug_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","N'yɔli wiwɔ ləkə tsə a ninshiŋ, bəni bədɔkɔ bə̀ bɔ nì laniki bənchi num i mbaŋ wi Bəfalasi wə, numbɛiŋ fɛiŋ dzaka bəh ŋga, dzakayi a, “Buku ka yɛiŋ gia yə mi wələ gbɔ yɛiŋ. A kɔlə numki kiŋ'waka kidɔkɔ, yuwidɔkɔ chinda wi Nyɔ wi dzakaki i wi.” ");
INSERT INTO cug_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","N'yɔli wiwɔ ka nəŋki a fiəni chu jwɔ, tikwili wi fwu wi bəni bə jum ka lwaki a yudɔkɔ bɔ kɔlə i shakyi Bɔɔl fɛiŋ i biŋka wə. Wi ka dzaka a bəni bə jum shî tsə̂ lɔ̂kɔ Bɔɔl fɛiŋ i kaŋ yibɔ wə, fîəni yâka dzə̂ bəh wi i kwili wi bəni bə jum wə. ");
INSERT INTO cug_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","A num nchɔkɔ, Bah numbɛiŋ i kɔmsi i Bɔɔl wə, dzaka i wi a, “Kaŋa shɔm. Si wɔ kɔ wɔ fuku lɔ i bəni kɔm mih i Jɛlusalɛm, akɔ tə a liŋ si wɔ ni fuku tə i Lum kɔm mih.” ");
INSERT INTO cug_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Chɔkɔ buku wɔɔ, Bəju bədɔkɔ jiə kimfasi, dzi ŋkaiŋ a bɔ ni dzi kə fiɛŋ nabə i mu a kɔbi a bɔ ni wɔɔ lə Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Bəni bə̀ bɔ nì jiə kimfasi kiwɔ dzi ŋkaiŋ biwɔ nì tsəki lə bəni mbaŋnyani. ");
INSERT INTO cug_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Bɔ ka tsə i bətii mfə gia bəmbum, bəh bəni bə̀ bɔ sakaki kwili, dzaka i bɔ a, “Buku kɔ buku lansi dzi ŋkaiŋ, a buku ki ləkəsiki kə fiɛŋ i dzaka wə a kɔbi a buku ni wɔɔ lə Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","I liə wə, mbɛiŋ bəh bəni bəchi bə̀ bɔ sakaki tumi chîŋsi ntum i tikwili wi fwu wi bəni bə jum, mbɛiŋ kwâyi dzaka i wi a wi fîəni chîŋsi shî dzə̂ Bɔɔl, wi dzə i mbɛiŋ nshiŋ, a mbɛiŋ nəŋki i tsɛiŋ baiŋsi i nsaka wi nalə. Ayakadəiŋ, buku ni gbɔ wi i dzəh, jɔbi wə bɔ ni shiki dzəki bəh wi, buku ka ni wɔɔ wi a kɛiŋ i dzəh.” ");
INSERT INTO cug_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Si bɔ nì jiə kimfasi kiwɔ yakadəiŋ, waiŋ jɛmi wi Bɔɔl wi nyukuni wɔkɔ, wi ka tsə i di bi bəni bə jum wə, fuku i Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Wi ka bɔɔŋ fwu wi mbaŋ wi bəni bə jum widɔkɔ dzaka i wi a, “Dzɔ̂ sumi wələ ma wɔ tsə̂ bəh wi i tikwili wi fwu wi bəni bə jum, wi kaŋaki lə gia i fuku i wi.” ");
INSERT INTO cug_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Wi ka dzɔ wi, ka tsə bəh wi i tikwili wi fwu wi jum wə, dzaka i wi a, “Bɔɔl mi wi nsəŋ bɔɔŋ mih, dzaka a mih dzɔ̂ sumi wələ ma mih dzə̂ bəh wi i wɔ, a wi kaŋaki lə gia i fuku i wɔ.” ");
INSERT INTO cug_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tikwili wiwɔ ka kaŋa wi i tsɛiŋ wə, bəh wi baka gwu, wi bikə i wi a, “Akɔ nə wɔ nəŋki i fuku i mih a?” ");
INSERT INTO cug_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Sumi wiwɔ chukuli a, “Bəju bədɔkɔ jiə kimfasi a bɔ ni dzaka lə i wɔ a wɔ nyâ shî dzə̂ Bɔɔl wi dzə i bəni bə̀ bɔ sakaki kwili kijiəli, a bɔ nəŋki tsɛiŋ ləkə baiŋsi i nsaka wi wə bindzɔŋ, bɔ dzakaki yaka kwayi fə fəni i wɔɔ wi. ");
INSERT INTO cug_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kiə wɔ ki bûm kə, kɔm bəni kɔlə fɛiŋ bɔ tsə bəni mbaŋnyani num bɔ gbɔ wi i dzəh, bɔ dzi ŋkaiŋ a bɔ ni dzi kə fiɛŋ nabə i mu fiɛŋ a kɔbi a bɔ wɔɔ lə Bɔɔl. Bɔ kɔ i liə num bɔ kɛiŋsi lɔ gwu, ka wɔkɔliki num gia yə wɔ ni dzaka.” ");
INSERT INTO cug_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tikwili wi fwu wi bəni bə jum wiwɔ ka dzaka a sumi yiwɔ tsə̂ki, ka kiŋ i wi a si wi tsəki kiə wi ki fə̂ kə a mi widɔkɔ kîə a wi fuku gia yiwɔ i ŋgaiŋ. ");
INSERT INTO cug_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tikwili wi fwu wi bəni bə jum wə ka bɔɔŋ kifwu kimbaŋ ki bəni bə jum bəfa dzaka i bɔ a, “Mbɛiŋ kɛ̂iŋsi jîə bəni bə jum gi yifa (200) bəh bəni bə bikum mbaŋnanitaŋ (70) bəh bəni bəgɔŋ gi yifa (200), i mbiəŋə wə bwukə nchɔkɔ, bɔ ni nyə tsə i Kaysalia. ");
INSERT INTO cug_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Mbɛiŋ kɛ̂iŋsi tə kikum i Bɔɔl, mbɛiŋ dzɔ̂ tsə̂ bəh wi i Fɛlek mi wi nsaka fiɛŋ fidɔkɔ ma kɔ̂m wi i dzəh.” ");
INSERT INTO cug_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Si wi dzaka yaka, ka nyaka kiŋwakti ki dzaka a. ");
INSERT INTO cug_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Akɔ mih Klawdius Lisias. Mih nyakaki kiŋwakti kələ i wɔ mi wimbum Fɛlek wə mi wi sakani. Mih bɔniki dzəki i wɔ. ");
INSERT INTO cug_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Bəju si kwa mi wələ ka nəŋki i wɔɔ. Mih ka wɔkɔ a, akɔ mi wi Lum, buku bəni mbəŋ bə jum ka liə fɛiŋ lɔkɔ wi i kaŋ yibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mih bə́ nəŋ i wɔkɔ gia yə bɔ jiəki i wi fuŋ, mih ka shi bəh wi i bəni bəbɔ bə̀ bɔ sakaki tumi. ");
INSERT INTO cug_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Jɔbi wə bə ni tsɛiŋ ləkə i yɛiŋ, mih ka yɛiŋ a gia yə bə bwaŋki i wi chɛiŋ akɔ a kiŋgukuli kɔm bənchi bəbɔ maka wi fə gia yidɔkɔ yə bə si kɔ i wɔɔ wi yɛiŋ, nabə i jiə wi i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Jɔbi wə mi si fuku i mih a Bəju bədɔkɔ jiə kimfasi i wɔɔ mi wələ, mih ka chiŋsi wi i wɔ akisəkə. Mih dzaka tə a bəni bə̀ bɔ jiəki gia i wi fuŋ dzə̂ yɛ̂iŋ num wɔ, bɔ dzaka gia yə bɔ kaŋaki bəh wi.” ");
INSERT INTO cug_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Bəni bə jum ka fə asi tikwili wibɔ dzaka, dzɔ Bɔɔl nchɔkɔ, bəh bɔ tsə buku i Antibati. ");
INSERT INTO cug_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Chɔkɔ buku wɔɔ, bəni bə jum bə̀ bɔ ni nyaniki bəh gvu bee Bɔɔl i kaŋ yi bəni bə̀ bɔ ni nyaniki i bikum bɛiŋ a bɔ tsəki bəh wi a ninshiŋ ka fiəni i jum wə i di bibɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Bɔ tsə liə i Kaysalia, ka nya kiŋwakti kiwɔ i mi wi sakani wiwɔ chu nya tə Bɔɔl i wi. ");
INSERT INTO cug_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Wi fa kiŋwakti kiwɔ, ka bikə i Bɔɔl di biə wi buku yɛiŋ. Wi ka wɔkɔ a Bɔɔl kɔ mi wi Silishia, ");
INSERT INTO cug_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ka dzaka i wi a, “Mih ni wɔkɔli lə nsaka wa i jɔbi wə bəni bə̀ bɔ kaŋaki nsaka bəh wɔ ni dzə buku fa.” Wi ka dzaka a bɔ dzɔ̂ Bɔɔl ma bɔ tsə̂ jîə wi i ntɔŋ wi Hɛlɔd wə, ma bə tsɛ̂iŋki wi. ");
INSERT INTO cug_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Si kaŋ dzə buku yite, Ananias fwu wi bətii mfə gia wə, bəh bəni bədɔkɔ bə̀ bɔ nì sakaki tumi, bəh Tɛtulus wə wi nì kɔ wi kɛiŋsi lani nchi, shi tsə i Kaysalia. Bɔ ka tsə yɛiŋ Fɛlek mi wi nsaka, jiə nsaka wibɔ kɔm Bɔɔl i wi nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Bɔ ka bɔɔŋ Bɔɔl, Tɛtulus ka yisi i jiəki gia i wi wə, dzaka i Fɛlek a, “Mi wimbum, kimbɔiŋni kɔlə i tumi kələ wə i dzə buku i liə, a num kɔm nsaka wa wi ndzɔŋni, bəŋkwuni bəh ndzɔŋni kɔ fa bəduli i tumi kələ wə num kaŋ ya. ");
INSERT INTO cug_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Bəni bəchi wɔkɔki lə ndzɔŋni bimbum chu dzɔ nsaka wa i di bichi jɔbi wichi. ");
INSERT INTO cug_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mih nəŋki kə i dzɔ jɔbi wa wichi, mih tsaki wɔ, a wɔ wɔ̂kɔli a twɛsi, wɔ wɔ̂kɔ gia yə buku ki dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Buku kɔ buku yɛiŋ a mi wələ kɔ mi wi gia. Wi nyaniki nəŋniki ndani i kintəəŋ ki Bəju wə i kifwu ki nshwaiŋ wə kichi. Ayaka a chu num wi tikwili wi mbaŋ wə bə bɔɔŋki a wi Nasali. ");
INSERT INTO cug_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Wi nì nəŋki i bəkəli tə juŋ yi fəni yi gia, buku kwa wi. ");
INSERT INTO cug_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Wɔ ka bikəyi gia i mi wələ, wɔ ni wɔkɔ i wi gia yichi yə buku dzaka kɔm wi.” ");
INSERT INTO cug_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Si Tɛtulus dzaka yakadəiŋ, Bəju tɔbi, kɔksi a gia yələ yichi kɔ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mi wi nsaka wiwɔ fəkəni i Bɔɔl a wi dzaka. Wi ka dzaka a, “Mih kiəki a wɔ kɔ wɔ saka lɔ bənsaka i tumi kələ wə i jía yiduli wə. Mih kɔ bəh kinsaŋli i num i wɔ nshiŋ i kɔmyi dzaka kəŋŋ. ");
INSERT INTO cug_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wɔ ka dza ka bikəyiki, wɔ ni wɔkɔ a kaŋ ka tsə dəkə jwɔfi ntsɔ yifa si mih nì yaka i Jɛlusalɛm i tsə tsa Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Bəju nì ka yɛiŋ, mih gukuli bəŋgukuli buku mi, bɔ nì ka yɛiŋ mih, mih nyini bəni i juŋ yi fəni gia wə nabə i juŋ yi tsani wə, nabə i di bidɔkɔ wə i kwili wə. ");
INSERT INTO cug_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bɔ kaŋaki kə na gia yə yi chusiki a mih nì fə gia yələ yə bɔ jiəki i mih wə. ");
INSERT INTO cug_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mih bum yələ i wɔ nshiŋ, a mih tsaki Nyɔ wi bətii bəbuku biəli Dzəh yə bɔ bɔɔŋki a yi kɔ yichu. Ayaka mih bumki num gia yichi yə yi kɔ i Kiŋwakti ki Bənchi bə Muses wə bəh yə yi kɔ i Biŋwakti bi bəni bə ntum bə Nyɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mih tsɛiŋki tsəki a ninshiŋ i Nyɔ, a liŋ asi bəni bələ tə tsɛiŋki, a bəni bə ndzɔŋni bəh bəchu bəchi bi dza lə i kpi wə. ");
INSERT INTO cug_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ayakadəiŋ, mih mɔmsiki nalə i jɔbi wichi wə i nɔki nɔni ki chəŋ i Nyɔ nshiŋ bəh bəni, ka gia ma numki yə yi sakaki mih i shɔm yiŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Akɔ jía yiduli si mih nì buku i Jɛlusalɛm, mih ka fiəni tsə fɛiŋ i nya kpɔ i bəni mbəŋ bə kwili, bəh i fə gia. ");
INSERT INTO cug_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Akɔ gia yələ bɔ nì yɛiŋ mih i juŋ yi fəni yi gia mə si mih fəki, num mih wɔkɔ shi mbiŋ. Bəni nì mɔŋ fɛiŋ nabə dzaka ki kɔmni. ");
INSERT INTO cug_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","A nì kɔ shəŋ a Bəju bədɔkɔ bə Ɛsia si bɔ nì kɔ fɛiŋ, ayaka bɔ si kaŋaki i numki fa i dzaka i wɔ gia yə bɔ kaŋaki kɔm mih, jɔbi wə gia yidɔkɔ kɔ. ");
INSERT INTO cug_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","A kɔbi yakadəiŋ, ma bəni bələ ni fuku gia yə bɔ ni yɛiŋ a mih gbɔ jɔbi wə mih nì numbɛiŋ i bəni bə̀ bɔ sakaki tumi nshiŋ, ");
INSERT INTO cug_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","a kɔbi a gia yə mih ni də bwili bəh ja yiləkəli i bɔ a, mih kɔ i bɔ nshiŋ jɔbi wələ lə i nsaka wə kɔm mih ni bum a bəŋkwu bi dza lə i kpi wə.” ");
INSERT INTO cug_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Si Bɔɔl dzaka yakadəiŋ, Fɛlek wɔkɔli lə, a nì kɔ mi wi tɔksi kiə kɔm Dzəh yi Bah, wi ka jiə nsaka dzaka a, “Jɔbi wə Lisias wə tikwili wi fwu wi bəni bə jum, ni shi dzə, ka mih ni təiŋ nsaka wimbɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Wi ka dzaka a fwu wi mbaŋ wi bəni bə jum dzɔ̂ Bɔɔl wi tsə̂ jîə i dzu, wi chəniki wi. Ayakalə, a bɔ nyâ wi bəh dzəh, ka nsɛ́iŋ yi dzə̂ki gâmtiki wi. ");
INSERT INTO cug_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kaŋ yidɔkɔ tsə, Fɛlek bəh Dusila kpə wi wə wi nì kɔ mi wi Ju bɔ dzə. Fɛlek tsə bɔɔŋ Bɔɔl a wi dzə, wi ka wɔkɔliki gia yə Bɔɔl dzakaki kɔm njiə wi shɔm i Klistus Jisɔs wə. ");
INSERT INTO cug_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Si wi dzaka kɔm si mi kɔ numki mi wi chəŋ bəh si mi kɔ i tɔkniki bəh gwu yi bəh si Nyɔ bi saka bəni, Fɛlek wɔkɔ yaka lə ka lwa. Ayaka wi ka dzaka i Bɔɔl a, “Wɔ kɔlə tsəki i liə, jɔbi wə mih ni kaŋa jɔbi mih ni fiəni bɔɔŋ wɔ.” ");
INSERT INTO cug_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Wi ni dzaka yakadəiŋ, kaŋa kiŋkwaka a jɔbi widɔkɔ Bɔɔl ni taŋyi lə ŋgaiŋ. Ayaka wi shi a bɔɔŋki Bɔɔl a fɛiŋ fɛiŋ a bɔ wi təkəki biɛiŋ bi təkəni. ");
INSERT INTO cug_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ayaka, yaka, jía yifa tsə. Bə bi ka jiə Bɔlsius Fɛstus i kimgbɔkɔ ki Fɛlek wə, Fɛlek ka nəŋki a ŋgaiŋ fə Bəju kɔŋki ŋgaiŋ, wi ka bee Bɔɔl i juŋ yi nsəŋ mə. ");
INSERT INTO cug_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","A dzə num i kaŋ yitali wə si Fɛstus yisi i sakaki kimbu ki tumi ki Judea, wi nyə i Kaysalia ka yaka tsə i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Bətii mfə gia bəmbum bəh kifwu ki Bəju i tumi kiwɔ wə ka dzə yɛiŋ wi, jiə nsaka wə bɔ kaŋaki bəh Bɔɔl i wi nshiŋ, ka tsa wi a, ");
INSERT INTO cug_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","wi chûsi shɔm yindzɔŋni i bɔ i fə a bə chîŋsi Bɔɔl a wi dzə i Jɛlusalɛm. Bɔ nì fəki yaka, num bɔ kɛiŋsi lɔ a bɔ ni gbɔ wi i dzə i wɔɔ. ");
INSERT INTO cug_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fɛstus chukuli i bɔ a, “Bɔɔl kɔ i juŋ yi nsəŋ mə i Kaysalia, mih mwi ni fiəni tsə lə fɛiŋ i kaŋ yələ wə. ");
INSERT INTO cug_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Bəni bə̀ bɔ kaŋaki ŋga i saka bənsaka, bədɔkɔ bîəli mih i tsə̂ i Kaysalia, i dzâka gia yə wi gbɔ yɛiŋ i jɔbi wə gia yidɔkɔ kɔ.” ");
INSERT INTO cug_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstus nì nɔ bəh bɔ i tsə buku ka kaŋ nyaŋ yuwidɔkɔ jwɔfi, ka wi fiəni shi tsə i Kaysalia. Si chɔkɔ buku wɔɔ, wi tsə i juŋ yi nsaka mə, dzaka a bə dzə̂ bəh Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Si Bɔɔl dzə, Bəju bə̀ bɔ nì buku dzə i Jɛlusalɛm shi tsə fɛiŋ, ka numbɛiŋ fiəli tali wi, ka yisi i jiəki gia yiduli i wi fuŋ, yi nchiŋ kɔbi. Ayakalə, gia yidɔkɔ nì kɔkə yə bɔ nì kɔ i fuku yi chusi a wi fə gia yidɔkɔ i yə wə bɔ nì dzakaki. ");
INSERT INTO cug_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bɔɔl baŋyi gwu yi bəh ndzaka, ka dzaka a, “Mih ka gbɔ dəkə nchi wi Bəju, nabə wi juŋ yi fəni yi gia, nabə bəh wi Ŋkuŋ wi Lum.” ");
INSERT INTO cug_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ayakalə, Fɛstus bə nəŋ a ŋgaiŋ fə Bəju kɔŋki ŋgaiŋ, ka bikə i Bɔɔl a, “Wɔ kɔŋki lə i yaka tsə i Jɛlusalɛm a mih mwi ni saka nsaka wa fɛiŋ i gia yələ wə a?” ");
INSERT INTO cug_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bɔɔl chukuli a, “Mih si num lɔ fa i di bi nsaka nshiŋ, a num bi Ŋkuŋ wi Lum. A num i fa wə bə kɔ i saka nsaka wuŋ. Wɔ mwi kiə na bindzɔŋ a mih ka gbɔ dəkə gia yidɔkɔ i Bəju. ");
INSERT INTO cug_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","A kabə num a mih bwiŋ nchi widɔkɔ, nabə i gbɔ gia yə yi kɔ i fə a bə wɔɔ mih, mih ma ni nəiŋ i kpi. Ayakalə, a kabə num a gia yə bɔ jiəki i mih fuŋ a, akɔ ntəkə, ayaka mi widɔkɔ mɔŋ wə wi kɔ i nya mih i kaŋ yi Bəju bələ wə. Mih tsaki a nsaka wuŋ tsə i Ŋkuŋ wi Lum nshiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fɛstus wɔkɔ yakadəiŋ, bəh bəni bu bə̀ bɔ nì sakaki bənsaka chumyi dzaka. Wi ka dzaka i Bɔɔl a, “Si wɔ kɔ wɔ tsa lɔ a nsaka wa tsə̂ i Ŋkuŋ wi Lum nshiŋ, yaka wi ki tsə̂ki lə fɛiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kaŋ yidɔkɔ tsə, Ŋkuŋ Aglifa bəh Bɛnis laa njikə i Fɛstus i Kaysalia i bɔni i wi. ");
INSERT INTO cug_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Si bɔ ni nɔ fɛiŋ i kaŋ yiduli wə, Fɛstus dza fuku i Ŋkuŋ kɔm nsaka wi Bɔɔl, ka dzaka a, “Mi widɔkɔ kɔ fa si Fɛlek nì bee i juŋ yi nsəŋ mə, ");
INSERT INTO cug_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","si mih ni tsə i Jɛlusalɛm, bətii mfə gia bəmbum bəh bəni bə̀ bɔ sakaki tumi ki Bəju jiə nsaka wiwɔ i mih nshiŋ a mih dzaka a wi gbɔ nsaka. ");
INSERT INTO cug_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mih dzaka i bɔ a, nɔni ki bəni bə Lum ka bum dəkə i təiŋ a mi gbɔ nsaka, maka bə nya dzəh i mi wiwɔ i liə numbɛiŋ i kintəəŋ kintaiŋntaiŋ ki nsaka mə i bəni nshiŋ bə̀ bəh bɔ kaŋaki nsaka, i baŋyi gwu yi kɔm gia yə bɔ jiəki i wi fuŋ. ");
INSERT INTO cug_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Jɔbi wə bɔ nì dzə fa, mih nì ka mɔti. Si chɔkɔ buku wɔɔ, mih tsə num i juŋ yi nsaka wə ka dzaka a bə dzə̂ bəh mi wiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Bəni bə̀ bɔ ni kaŋaki nsaka ka num bɛiŋ, bɔ nəki chusi kə ŋgbɔ wə mih nì kwakaki asi bɔ dzakaki i mih. ");
INSERT INTO cug_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bɔ ka dzakaki lɔ, a num gia yi ŋgukulini bəh mi wiwɔ kɔm dzəh yə bɔ tsaki Nyɔ yɛiŋ, bəh kɔm bəh mi widɔkɔ bə bɔɔŋki a Jisɔs num wi nì kpi lɔ, ayaka Bɔɔl bwaŋ alə a wi kɛiŋki wiwɔm. ");
INSERT INTO cug_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Si mih si kiəki kə si mih kɔ i liə i kintəəŋ ki gia yiwɔ wə, mih ka bikə i Bɔɔl yuwidɔkɔ wi kɔŋki i yaka i Jɛlusalɛm a bə saka nsaka wi fɛiŋ kɔm gia yələ. ");
INSERT INTO cug_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Wi chukuli a ŋgaiŋ ni baaŋ a juŋ yi nsəŋ mə, a a bi təiŋki a Ŋkuŋ wi Lum nsaka wi ŋgaiŋ. Mih ka dzaka a bɔ jîə wi i dzu, i wɔ̂kɔliki i tsə̂ bûku i jɔbi wə mih ni chiŋsi wi i Ŋkuŋ wi Lum.” ");
INSERT INTO cug_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Aglifa wɔkɔli lə, dzaka i Fɛstus a, “Mih mwi kɔŋki lə i wɔkɔ gia yələ i dzaka ki mi wiwɔ wə.” Fɛstus chukuli a, “Wɔ bi buku wɔkɔki lə kijiəli.” ");
INSERT INTO cug_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Si chɔkɔ buku wɔɔ, Aglifa bəh Bɛnis ka nyaniki dzəki bəh kiŋkɔkni kimbum. Bɔ bətii kifwu ki bəni bənchi bəh bəni bəmbum bə kwili, nyani dzə liə i saŋ mə. Fɛstus ka dzaka a bə dzə̂ bəh Bɔɔl. ");
INSERT INTO cug_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Si bɔ dzə bəh wi, Fɛstus dzaka a, “Ŋkuŋ Aglifa bəh bəni bəchi bə̀ bɔ kɔ fa, mbɛiŋ yɛ̂iŋ mi wələ. Akɔ mi wə Bəju bəchi dzəki yɛiŋki mih fa bəh i Jɛlusalɛm kɔm wi, wamyi, dzaka a wi kɔkə mi wə wi kaŋaki i chu numki wiwɔm. ");
INSERT INTO cug_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ayakalə, mih ka yɛiŋ dəkə a wi fə gia yidɔkɔ yə bɔ kɔ i wɔɔ wi yɛiŋ. Si wi nì tsa a nsaka wi tsə i Ŋkuŋ wi Lum nshiŋ, mih ka yɛiŋ a mih ni chiŋsi lə wi i wi. ");
INSERT INTO cug_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ayakalə, mih tɔksiki kiəki kə gia yə mih kaŋaki i nyaka i Ŋkuŋ tikwili wuŋ kɔm wi. Ayakadəiŋ, mih ka tɔm wi i liə i mbɛiŋ bəchi nshiŋ i na bə wɔ Ŋkuŋ Aglifa, a mbɛiŋ tsɛ̂iŋ lə̂kə i nsaka wi wələ, yudɔkɔ mih ni kwati gia yə mih kɔ i nyaka. ");
INSERT INTO cug_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Mih yɛiŋ na yi kɔkə chəŋ i mih i chiŋsi mi wi nsəŋ i Ŋkuŋ mih kɔbi i chusi gia yə bə kɔ i dzakaki a wi gbɔ yɛiŋ wə.” ");
INSERT INTO cug_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Ŋkuŋ Aglifa ka dzaka i Bɔɔl a, “Akɔ di bia i liə i dzâka bəh dzaka ka.” Bɔɔl ka giŋsi kaŋ i bɛiŋ, yisi i kɔmyiki dzaka dzaka a, ");
INSERT INTO cug_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Mbɛɛ, mih yɛiŋ a, akɔ fwu wi ndzɔŋni a mih num i wɔ nshiŋ i dzaka bəh dzaka kəŋŋ daiŋ gia yichi yə Bəju jiəki i mih fuŋ. ");
INSERT INTO cug_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Mih dzakaki lə, kɔm wɔ tɔksiki kiəki lə nɔni kə tumi ki Bəju bəh bəŋgukuli bə̀ bɔ si kaŋa. Ayakadəiŋ, mih tsaki wɔ i kâŋa shɔm twɛsi i wɔ̂kɔli gia yə mih nəŋki i dzaka. ");
INSERT INTO cug_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Bəju bəchi kiəki lə nɔni kəŋŋ i yisi na mih kɛiŋ sumi. Bɔ kiə si mih nì nɔki i tumi kibuku wə bəh i Jɛlusalɛm. ");
INSERT INTO cug_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Bɔ kiəki lə na bindzɔŋ a, i yisi i jɔbi wi dəəŋ wə a mih kɔ mi wi mbaŋ wi Bəfalasi num mbaŋ wə wi ləkəki i gia yi Nyɔ wə, tsə bəmbaŋ bəchi. Yələ kɔ gia num bɔ kabə kɔŋ, ma bɔ ni fuku bəh dzaka kibɔ, bɔ num i bum a, akɔ ŋkɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Mih num fa i liə i nsaka wələ wə kɔm mih tsɛiŋki tsəki a ninshiŋ, kiə kiŋkaka kə Nyɔ nì kaka i bətii bəbuku. ");
INSERT INTO cug_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Kiŋkaka kələ kɔ kə chwɔŋkijuŋ kibuku jwɔfi ntsɔ bəfa wɔkɔliki, si bɔ tsaki Nyɔ kɔksi wi nchɔkɔ bəh nshi. Mbɛɛ, akɔ kɔm kiŋkaka kələ Bəju kaŋaki nsaka yɛiŋ buku bɔ. ");
INSERT INTO cug_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Mih bikəki i mbɛiŋ i liə, akɔ kɔm nə mbɛiŋ ləkəki i bum a Nyɔ kɔlə i dzasi mi i kpi wə a? ");
INSERT INTO cug_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Mih mwi nì kwakaki a mih kɔlə i fə gia yichi, i yɛiŋ a mih chiksi yɛli wi Jisɔs wi Nasali. ");
INSERT INTO cug_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ayaka yələ kɔ gia num mih nì fə lɔ yi i Jɛlusalɛm. Mih nì dzɔki ŋga i bətii mfə gia bəmbum, kwayi bəni bəduli bə̀ bɔ nì kɔ bə Nyɔ, fah i juŋ yi nsəŋ mə. A nì kɔkə a yələ shəŋ. Jɔbi wə bə nì kɔ a bə nəŋki i wɔɔyi bɔ mih tə nì tɔbiki lə. ");
INSERT INTO cug_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mih nya ŋgəkə i bɔ a fɛiŋ fɛiŋ i juŋ yi tsani wə yichi, kaŋyi a bɔ dzakaki já yichu kɔm mi wə Jisɔs. Shɔm bɔkɔ mih bəh bɔ nalə, mih nì bwaŋki lə gvu i bɔ chɛiŋ, i tsə buku i kikwili ki bəni bədɔkɔ wə. ");
INSERT INTO cug_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Mih ka nyə ka tsəki i Damaskus, num bətii mfə gia bəmbum nya mih bəh ŋga, ka chu nyaka kiŋwakti nya i mih. ");
INSERT INTO cug_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Mbɛɛ, mih kabə tsə a num nshichuŋ asi wɔŋ yaka lumsi, mih yɛiŋ baiŋni bidɔkɔ bi dza baiŋ lə mwaiŋ i bɛiŋ bi baiŋ tsə wɔŋ, bi baiŋ shi i mih wə bəh i bəni bə̀ buku bɔ nì nyaniki. ");
INSERT INTO cug_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Buku bəchi dza gbɔyi i kuku, mih ka wɔkɔ ja yi dzaka dzə i mih i já yi Hibulu wə a, ‘Sɔɔl, Sɔɔl, wɔ bwaŋki gvu i mih chɛiŋ kɔm nə lə? Wɔ fəki lə, wɔ chɔkɔ num gwu ya, asi naʼ yi nɔm si chɔkɔ gwu yi i mbəŋ wi ba wi wə.’ ");
INSERT INTO cug_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mih ka bikə a, ‘Bah Akɔ wɔ ndə?’ Ayaka wi chukuli a, ‘Akɔ mih Jisɔs, a num mih wə wɔ bwaŋki gvu i wi chɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Dzâ nûmbɛiŋ. Gia yə yi fə mih, a mih tumbuku i wɔ akɔ i babwili wɔ ka mi wuŋ wi nɔm, ka wɔ bi fûkuki gia yə wɔ yɛiŋ ndaiŋ bəh yə mih kɛiŋki i ni chusi i wɔ. ");
INSERT INTO cug_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mih ni gamti lə wɔ i kaŋ yi Bəju wə bəh bəni bə̀ bɔ kɔkə Bəju, a num bɔ bə̀ mih ni faaŋ wɔ i bɔ, ");
INSERT INTO cug_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","wɔ tsə̂ wɛ̂li dzə́kəh yibɔ, wɔ bwîli bɔ i jisi wə, wɔ jîə bɔ i baiŋni wə, bɔ ka ni buku i kaŋ yi Satan wə, i num bəh Nyɔ, bɔ ni jiə shɔm i mih wə, ka Nyɔ ni dalinya chu bibɔ. Bɔ ni ka kwati kimbu i di bi bəni bə̀ wi nì fə a, akɔ na mbu.’ ");
INSERT INTO cug_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Mbɛɛ, si yi nì num yakadəiŋ, mih ka fə asi wi nì dzaka i mih i bɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Mih ka yisi, yisi i fukuki i Damaskus, ka mih tsə i Jɛlusalɛm. Ayaka mih nyani i bitumi bichi i Judea bəh i bitumi bichi biə bi kɔkə bi Bəju, i fukuki i bɔ a bɔ kwûni shɔ́m yibɔ, bɔ chû i Nyɔ, bɔ fə̂ki num gia yə yi chusiki a bɔ kwuni. ");
INSERT INTO cug_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Akɔ gia yə yi fə ka Bəju kwa mih i juŋ yi fəni yi gia wə, kabə nəŋ i wɔɔ. ");
INSERT INTO cug_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ayakalə, i dzə buku bidaiŋ mih kɔ kɔm bə ŋgamti wə Nyɔ gamtiki mih yɛiŋ. Na ka mih num fa i liə i fukuki i bəni bəmbum bəh i bənchiŋ. Gia yə mih fukuki kɔ a yə Muses bəh bəni bə ntum bə Nyɔ nì lakaki a yi bi dzə num lə. ");
INSERT INTO cug_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Bɔ nì dzakaki a Kimbwili wə Nyɔ nì kaka kaŋaki lə i bi dzə̂ yɛ̂iŋ ŋgəkə, a nûm mi wi ninshiŋ i bi dzâ i kpi wə, wi bi chusiki lə baiŋni i Bəju bəh i bəni bə̀ bɔ kɔkə Bəju.” ");
INSERT INTO cug_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Si Bɔɔl nì kɛiŋki wi baŋyi gwu yi, Fɛstus dza kiŋ lɔ kiŋni ka dzaka a, “Bɔɔl wɔ si yuŋsi yuŋsini. Nlani wa wimbum wələ fə wɔ bə yuŋsi.” ");
INSERT INTO cug_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bɔɔl chukuli i Fɛstus a, “Mih yuŋsiki kə yuŋsini mi wimbum. Gia yə mih dzakaki akɔ ŋkɔŋ, mih dzakaki mfi mbiŋ num fɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Mih dzakaki i Ŋkuŋ lə lwa kə, kɔm wi kiəki lə gia yələ, yi ni ka num dəkə i nyumi wə, yidɔkɔ chu num kə yə wɔ məŋniki. ");
INSERT INTO cug_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Mbɛɛ, wɔ bum alə a gia yə Biŋwakti bi bəni bə ntum bə Nyɔ dzakaki a? Mih kiəki lə a wɔ bum.” ");
INSERT INTO cug_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Ayaka Ŋkuŋ Aglifa bikə i Bɔɔl a, “Wɔ kwakaki a wɔ ki fiəniki lə mih i num mi wi Klistus i jɔbi wi juli wələ wə a?” ");
INSERT INTO cug_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bɔɔl chukuli a, “Kɔŋ a numki i jɔbi wi juli wə nabə wi dəəŋ wə, ntsa wuŋ i Nyɔ kɔ a, a ma numki a wɔ shəŋ. Mi wichi wə wi kɔ fa daiŋ wi wɔkɔliki si mih dzakaki wi fiəni numki aka mih tə, ayaka wi ma baaŋ i bənsəŋ bələ wə.” ");
INSERT INTO cug_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ŋkuŋ ka dza bɛiŋ, mi wi sakani bəh Bɛnis bəh bəni bə̀ bɔ nì kɔ bəh bɔ ka biəliki. ");
INSERT INTO cug_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Bɔ buku, ka dzakaki a bɔ bɔ a, “Mi wələ ka fə dəkə gia yə bə kɔ i wɔɔ wi, nabə i jiə wi i juŋ yi nsəŋ mə.” ");
INSERT INTO cug_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ŋkuŋ Aglifa ka dzaka i Fɛstus a, “Asi kɔkə a mi wələ numki num wi tsa lɔ a nsaka wi tsə i Ŋkuŋ wi Lum, ma bə bee wi.” ");
INSERT INTO cug_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Jɔbi wə bə nì kɛiŋsi a buku bəh Bɔɔl i liə i ŋgwuki wimbum wə i tsə i tumi ki Itali wə, bɔ ka nya Bɔɔl bəh bəni bə nsəŋ bədɔkɔ i kaŋ yi Julius wə wi nì kɔ fwu i mbaŋ wi bəni bə jum bədɔkɔ a num wi Ŋkuŋ wi Lum. ");
INSERT INTO cug_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Buku bɔ liə i ŋgwuki wimbum wə wi buku i Adamitium, wi num i ni numyiki tsəki i kpa i kimbu ki di ki bɔkɔ yi Ɛsia wə. Alistakus mi wi Tɛsalɔnika, i tumi ki Masedɔnia num tə buku bɔ. Buku bɔ ka tsəki. ");
INSERT INTO cug_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Chɔkɔ buku wɔɔ, buku dzə buku i Sidɔn, Julius chusi kiŋkɔŋ i Bɔɔl, ka bee wi a wi tsə yɛiŋ nsɛ́iŋ yi i kwili kintəəŋ ka bɔ gamti wi bə biɛiŋ biə wi nəŋki. ");
INSERT INTO cug_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Jɔbi wə buku ni fiəni liə i ŋgwuki mə fɛiŋ, kabə tsəki, fiəkə dzə i buku nshiŋ chini, buku ka kwaŋki tsəki i fikpəŋ fikpəŋ i tumi ki Sayblus kə ki kɔ i bɔkɔ kintəəŋ ki kəŋki fiəkə. ");
INSERT INTO cug_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Buku tsə daŋ kinchwɔ kimbum kə ki kɔ i fintəŋ kitumi ki Silishia bəh ki Bamfilia, ka dzə i kwili wi Mila i tumi ki Lisia wə. ");
INSERT INTO cug_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Fwu wi mbaŋ wi bəni bə jum wə ka yɛiŋ ŋgwuki i bɔkɔ num wi buku dzə i Alɛksandia daŋsi tsə sə i Itali, wi bwili buku, ləkə buku yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Buku bi dza fɛiŋ, nyani alə tɛsi tɛsi i kaŋ yiduli wə, buku fum i bəŋgəkə bələ wə i tsə buku i kwili wi Sinidus wə. Si fiəkə nì bumki kə a buku tsə i ninshiŋ chəŋ, ayaka buku ka kwuni ka kwaŋ tsə dzəh i Klɛt tumi ki bɔkɔ kintəəŋ wə, di biwɔ ka kəŋki buku bəh fiəkə, buku ka tsə daŋsi Salmɔni di biə bi liəki tsəki i bɔkɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Buku ka kwaŋki tsəki a bɔkɔ kpəŋ bɔkɔ kpəŋ, fum num fumni ka buku buku i di biə bə nì bɔɔŋki a Kpa wi Bɔkɔ wi Kimbɔiŋni, kə ki nì kɔ kɔmsi i kwili wi Lasia wə. ");
INSERT INTO cug_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Si buku nì kɔ num buku bəkəli lɔ jɔbi wi dəəŋ i dzəh, a nì kɔ yaka num Chɔkɔ Bimbam bi Ndalinya Chu tsə lɔ, a num i jɔbi wi fuŋni kiləkəli wə, Bɔɔl ka nya kintəfi i bəni bə̀ i ŋgwuki mə a, ");
INSERT INTO cug_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Bəba, mih yɛiŋ a i yisi fa i tsə ninshiŋ nyani wibukumbɛiŋ ni bəkə lə, kinlaka kimbum ni numki lə, nlaka wiwɔ ni numki kə a biɛiŋ shəŋ bəh ŋgwuki, bəni tə ni kpiyi lə.” ");
INSERT INTO cug_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ayakalə, fwu wi bəni bə jum wə nəki wɔkɔ kə ndzaka wi Bɔɔl, ka wɔkɔ n'yi num i fwu wi bəni bə ŋgwuki bəh tii ŋgwuki wiwɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Yɛiŋ si chwɛiŋ wi bɔkɔ yiwɔ nì ndzɔŋki kə ka bɔ num fɛiŋ i jɔbi wi fuŋni kiləkəli wə, mi wi duli ka tɔbi a yi ndzɔŋki lə a bə mɔ̂msiki tsə̂ki a ninshiŋ, yuwidɔkɔ bə ni tsə buku i chwɛiŋ wi bɔkɔ yi Fɔniks wə, a num tumi i Klɛt ki kəŋ fiəkə, i tsəsi jɔbi wiwɔ fɛiŋ. Chwɛiŋ wi bɔkɔ wiwɔ nì kɔ ki tsɛiŋ daŋsi i kimbu ki nimbɛiŋ bəh kishɛiŋ i di biə wɔŋ tsəki liəki. ");
INSERT INTO cug_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Fiəkə yidɔkɔ dza ka yakaki dzəki i kimbu kishɛiŋ wə a tɛsi tɛsi, bəni bə ŋgwuki bəwɔ ka kwakaki a bɔ kwati fiɛŋ fiə bɔ si nəŋki. Bɔ ka babwili ntukpa wi ŋgwuki, ka tsəki a i chwɛiŋ wə chwɛiŋ wə i bɔkɔ yi Klɛt wə. ");
INSERT INTO cug_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Bə bɔɔŋ fubi kiləkəli kiwɔ a, “Fubi ki kimbu kitsɛiŋ yi kimiəkə i di biə wɔŋ bukuki”, fubi kiwɔ dza tumbuku dzə i tumi kə wə, ka shi i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Si ki shi dzə, chɔkɔ i ŋgwuki wə, dzəh nəki num kə fɛiŋ ka ŋgwuki wiwɔ tsəki i fuŋni kiwɔ wə, bɔ ka bee ŋgwuki wiwɔ i fuŋni kiləkəli kiwɔ wə ki giŋ ka tsəki bəh wi. ");
INSERT INTO cug_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Buku ka tsəki a tsəni, tsə daŋsi tsə i kimbu kishɛiŋ wə i tumi kinchiŋ kidɔkɔ wə i kintəəŋ ki bɔkɔ yə bə bɔɔŋki a Kawda. Tumi kiwɔ bə́ kəŋ buku bəh fiəkə, buku ka fumki i yaksi ŋgwuki i chwɛiŋ wi bɔkɔ wimbum wə. ");
INSERT INTO cug_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Buku yaksi, ka shu kaŋa ŋgwuki wimbum wiwɔ bəh bəkwu a wi ma shakyi, jɔbi wə buku nì tsəki buku bə́ lwa a ŋgwuki wiwɔ ni tsə chɔkɔ lə gwu yi i dumi kinshambu wə i bɔkɔ kintəəŋ i kɔmsi tsə i tumi ki Libia wə. Bɔ ka shisi mbuŋ wi fiəkə, ka bee ŋgwuki wiwɔ bə́ tsə a wi wi. ");
INSERT INTO cug_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Si fuŋni kiləkəli kiwɔ ni ləkəki tsəki a ninshiŋ, chɔkɔ ka buku wɔɔ, bə ka yisi i bwiliki biɛiŋ i ŋgwuki wimbum wiwɔ mə, lɔɔyiki i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Chɔkɔ chu buku wɔɔ, bəni bə ŋgwuki bəwɔ ka bwili biɛiŋ bi ŋgwuki mə lɔɔyi i bɔkɔ bəh kaŋ yibɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kaŋ yiduli tsə maka buku yɛiŋ wɔŋ nabə bijɔŋ, fuŋni kiləkəli kiwɔ kɛiŋ jumi a jumini a num kə ki twɛsi, buku ka kiəki a yibuku kaa lɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Si bəni nì kɔ num bɔ nɔ i kaŋ yiduli wə dzi kə fiɛŋ, Bɔɔl dzə num i ninshiŋ ka dzaka a, “Bəba, a nì kɔ a mbɛiŋ bum i wɔkɔ yiŋ a bə baaŋ a Klɛt, ma bukumbɛiŋ ka kwati dəkə ŋgəkə wələ bə kinlaka kələ lə. ");
INSERT INTO cug_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ayakalə, mih tsaki a mbɛiŋ kâŋa shɔm, kɔm mi i mbɛiŋ kintəəŋ ni laka kə, a ni laka shəŋ a ŋgwuki wimbum wələ. ");
INSERT INTO cug_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mih dzakaki lə kɔm Nyɔ wə wi kaŋaki mih, a num wə mih tsaki i wi, wi si faaŋ chinda wi i mih daiŋ nchɔkɔ wi dzə num i mih kpəŋ, ");
INSERT INTO cug_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ka dzaka i mih a, ‘Bɔɔl, ma lwâki. Wɔ kaŋaki i bi num i Ŋkuŋ wi Lum nshiŋ. Tsɛ̂iŋ, si Nyɔ chusi kiŋkɔŋ i wɔ ka fə a mi widɔkɔ i mbaŋ wi bəni bə̀ mbɛiŋ bɔ kɔ i ŋgwuki wimbum wələ wə ni laka kə.’ ");
INSERT INTO cug_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ayakadəiŋ, bəba, mbɛiŋ kâŋa shɔm. Mih jiə shɔm i Nyɔ wə, a gia yə wi dzaka i mih ni num ayaka si wi dzaka. ");
INSERT INTO cug_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ayakalə, ŋgwuki wimbum wələ kaŋaki lə i ni tsə chɔkɔ gwu yi i tumi kidɔkɔ wə i bɔkɔ kintəəŋ.” ");
INSERT INTO cug_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","A dzə num i kaŋ jwɔfi ntsɔ bənaa fuŋni kiləkəli kə kɛiŋ fiəli a fiəlini bəh buku i kinchwɔ kimbum ki Adia wə. A dzə num ka nchɔkɔ kintəəŋ, bəni bə̀ bɔ nɔmki i ŋgwuki wiwɔ wə dza ka kwakaki a yudɔkɔ bɔ si kɔmsi tsə i chwɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Bɔ ka fəkəni bɔkɔ si yi liəki bəh kwu num bɔ shiŋsi fiɛŋ fi jili yɛiŋ wə, ka yɛiŋ yi num a bəntəm mbaŋfia. Ayaka bɔ tsə kpɛiŋsi i ninshiŋ, chu fəkəni , ka yɛiŋ yi num a bəntəm jwɔfi ntsɔ bəte. ");
INSERT INTO cug_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Bɔ ka lwaki a yudɔkɔ ŋgwuki kɔlə i chɔkɔ i biaŋa wə, ka shisi bəntukpa bənaa i bɔkɔ i ŋgwuki jum, ka tsaki alə chɔkɔ wɔɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Bəni bə̀ bɔ nɔmki i ŋgwuki mə dza ka nəŋki i yɔkɔ buku i ŋgwuki wimbum wiwɔ mə, bɔ ka nəŋki i shisi ŋgwuki winchiŋ i bɔkɔ, ka bə kwayi fə a bɔ nəŋki i shisi bəntukpa i shi bi ŋgwuki wə i bɔkɔ. ");
INSERT INTO cug_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bɔɔl ka dzaka i fwu wi bəni bə jum wə bəh i bəni bu a, “Bəni bələ ka mɔm i buku i ŋgwuki wimbum wələ wə, na ma mi widɔkɔ i mbɛiŋ wə ma ni bɔiŋ.” ");
INSERT INTO cug_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Bəni bə jum ka təiŋyi bəkwu bə̀ bɔ nì kaŋa ŋgwuki winchiŋ wiwɔ yɛiŋ i wimbum wə, ka bee a wi ləŋki tsəki. ");
INSERT INTO cug_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Asi chɔkɔ nì wɔɔki dzəki, Bɔɔl ka tsa bəni bəchi a bɔ dzî fiɛŋ, ka dzaka a, “Daiŋ si num kaŋ jwɔfi ntsɔ bənaa mbɛiŋ num a bəh nlwa maka mbɛiŋ ləkə fiɛŋ i dzaka mə. ");
INSERT INTO cug_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ayakadəiŋ, mih tsaki mbɛiŋ a mbɛiŋ dzî fiɛŋ, ka bi nya mbɛiŋ bəh ŋga. Ayaka na juŋ yi fwu i mi fuŋ ni laka kə.” ");
INSERT INTO cug_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Si wi dzaka yakadəiŋ, ka dzɔ blɛd, nya kiyɔŋni i Nyɔ, gbɛ ka dziki i bəni bəchi nshiŋ. ");
INSERT INTO cug_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Bɔ bəchi ka kaŋa shɔm ka dzi. ");
INSERT INTO cug_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Buku bəchi bə̀ buku nì kɔ i ŋgwuki wimbum wiwɔ mə nì kɔ bəni gi yifa bəh mbaŋnanitaŋ ntsɔ bəsɔ (276). ");
INSERT INTO cug_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Jɔbi wə bəni bəchi nì dzi fwuli, bɔ ka bwili gəŋ yə yi nì kɔ i ŋgwuki mə, lɔɔyi i bɔkɔ i fə a wi yaŋsi. ");
INSERT INTO cug_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Jɔbi wə chɔkɔ nì wɔɔ dzə, bɔ yɛiŋ tsə kpa, bəni bə̀ bɔ nɔmki i ŋgwuki mə nəki kiə kə di biwɔ. Ayakalə, bɔ yɛiŋ nchisi wi bɔkɔ num wi tsə buku i mishambu wə, bɔ ka yɛiŋ a bɔ kɔlə i mɔmsi a ŋgwuki liə tsə num fɛiŋ i bɔkɔ kpəŋ. ");
INSERT INTO cug_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bɔ ka təiŋyi bəshəiŋ bɔ mini shi tsə i bɔkɔ, ka chu fiəni shwa bəkwu bə̀ bɔ nì kaŋayi bəmbəŋ bə̀ bɔ lumsiki ŋgwuki yɛiŋ, ka yaksi mbuŋ wi fiəkə i ninshiŋ fiəkə liə yɛiŋ ka chiniki ŋgwuki wiwɔ wi bə́ tsə i nchisi wə i bɔkɔ kpəŋ. ");
INSERT INTO cug_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ayakalə, wi tsə chɔkɔ gwu yi i dumi ki mishambu wə i bɔkɔ. Kimbu ki ŋgwuki ki ninshiŋ liə baaŋ fɛiŋ chu nəŋni kə. Bəwaa bə ləkəli shakyi tɔkɔ kimbu ki jum wə kə. ");
INSERT INTO cug_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Bəni bə jum dza kabə nəŋ a bɔ wɔɔyi bəni bə nsəŋ bəchi ka bədɔkɔ ma ni châli bûku i gɛ̂iŋ. ");
INSERT INTO cug_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ayakalə, fwu wi bəni bə jum wə ka nəŋki i lɔkɔ Bɔɔl, ka kaŋyi a bɔ ma fə̂ yakadəiŋ, ka dzaka n'yi a bəni bə̀ bɔ kiəki nchali yisi gbɔyi chali buku i kpa, ");
INSERT INTO cug_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ma kiŋka ki bəni bədɔkɔ baaŋ biəli num i bibaŋ bi kɛiŋ bɛiŋ bəh i bishakli biŋka bi ŋgwuki wə. Yələ kɔ dzəh yə buku nì mɔmsi i buku yaka kpa wə alə nyiki. ");
INSERT INTO cug_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Si buku nì tsə buku i kpa wə alə nyiki yakadəiŋ, ka wɔkɔ a, bə bɔɔŋki di biwɔ a Malta, a num tumi i bɔkɔ kintəəŋ. ");
INSERT INTO cug_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Bəni bə tumi kiwɔ chusi kiŋkɔŋ kiləkəli i buku, dzɔ buku, kpa gbuku buku ka jɔkɔki, kɔm dzaŋ nì kɔ yi yisi lɔ i dzəki fiəkə num. ");
INSERT INTO cug_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bɔɔl nyani juŋni ŋgaŋa, ka tsə i kpa, ayaka fəkə num i ŋgaŋa yiwɔ mə, gbuku shili fə fəkə kiwɔ buku ka nɔm tsɛiŋ yi ka shəiŋ baaŋ yɛiŋ wə. ");
INSERT INTO cug_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Bəni bə tumi kiwɔ ka yɛiŋ si ki shəiŋ baaŋ i tsɛiŋ yi wə, ka dzakaki a bɔ bɔ a, “Mi wələ nì wɔɔ mi. Wi si bɔiŋ i bɔkɔ, ayakalə lɔiŋ kwa wi, wi ni baaŋ kə wiwɔm.” ");
INSERT INTO cug_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ayakalə, Bɔɔl mikə fəkə kiwɔ ki gbɔ i gbuku mə, gia yidɔkɔ nəki num kə bəh wi. ");
INSERT INTO cug_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Bəni bəwɔ ka wɔkɔliki, kwaka a gwu yi Bɔɔl ni yisi lə i mɔki, yudɔkɔ a wi ki gbɔki kpiki lə. Si bɔ ni wɔkɔli wɔkɔ mɔŋ mɔŋ, bɔ ka yɛiŋ a gia yidɔkɔ ka num dəkə bəh wi, bɔ kwuni kiŋkwaka kibɔ dza ka dzakaki a, “Mi wələ kɔ nyɔ widɔkɔ.” ");
INSERT INTO cug_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Mi wə wi nì sakaki di biwɔ fɛiŋ nì kaŋaki lə kikhə, ki kɔmsi tsə i di biə buku nì kɔ. Yɛli wi mi wiwɔ num a Bublius. Wi dzɔ buku fɛiŋ, buku bɔ nɔ i kaŋ yitali wə wi tɔkni yaka bəh buku na bindzɔŋ. ");
INSERT INTO cug_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Yi num a tii Bublius nì kɔ i naŋbɛiŋ gwu num bəh wi tasi bəh chwɔ yi bɔkɔli. Bɔɔl ka liə tsə i lum wə wi nì nɔki yɛiŋ, jiə kaŋ i wi wə, tsa ka chuku wi. ");
INSERT INTO cug_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Si yi nì num yakadəiŋ, bəni bə tumi kiwɔ kichi bə̀ bɔ nì kaŋaki jwɛ́iŋ ka dzəki Bɔɔl chuku tə bɔ. ");
INSERT INTO cug_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Bɔ ka nyaki buku bəh biɛiŋ biduli. Jɔbi wə buku nì nyəki fɛiŋ, bɔ chu dzə a bəh biɛiŋ bichi biə buku nì kɔŋki jiə i ŋgwuki mə. ");
INSERT INTO cug_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Buku liə i ŋgwuki wimbum mə ka tsəki num buku nɔ lɔ i Malta i tumi ki bɔkɔ kintəəŋ kifiəŋŋ kitali. Ŋgwuki wiwɔ nì kɔ wi Alɛksandia wə bə nì bɔɔŋki a Bənyɔ bə̀ bɔ kɔ Bimaŋsi, ayaka wi nì kɔ i tumi kiwɔ wə wɔkɔli a jɔbi wi fiəkə yiləkəli nì tsə daŋsi. ");
INSERT INTO cug_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Buku tsə buku i bɔkɔ kpəŋ i kwili wi Silakus wə, nɔ fɛiŋ i kaŋ yitali wə, ");
INSERT INTO cug_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ka nyə fɛiŋ, tsə buku i kwili wi Lɛgium wə ka nɔ tə fɛiŋ. Si chɔkɔ buku wɔɔ, fiəkə yisi i yakaki dzəki i kimbu ki shɛiŋ wə, buku ka tsəki, i kaŋ yifa wə, buku dzə buku i kpa wi Butiɔli wə. ");
INSERT INTO cug_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Si buku dzə buku fɛiŋ, yɛiŋ bəni bə bumni fɛiŋ, bɔ tsa a buku dzə̂ ma buku bɔ nɔ̂ kaŋ nanitaŋ. Buku bɔ ka nɔ, buku ka nyə dzə i Lum. ");
INSERT INTO cug_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Si buku nì tsəki, bəni bə bumni bə Lum ka wɔkɔ a buku si dzə wə, bɔ buku ka nyaniki dzəki a buku bɔ baŋsi. Ayaka bɔ dzə buku na i shi yi Abiyus wə, bəh i Juŋ yi Bəni bə Nyanini wə Yitali. Asi Bɔɔl yɛiŋ bɔ, shɔm yi də, wi nya kiyɔŋni i Nyɔ. ");
INSERT INTO cug_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Buku dzə buku i Lum, bɔ bee Bɔɔl wi ka numki mfih wi mbɔŋ, mi wi jum widɔkɔ chəəŋni kə wi. ");
INSERT INTO cug_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kaŋ ni tsə yitali, Bɔɔl bɔɔŋ kifwu ki Bəju bə̀ fɛiŋ. Asi bɔ dzə, wi dzaka i bɔ a, “Bwa bə nih bəŋ, mih kɔ i bənsəŋ wə lə num bə nì kwa mih i Jɛlusalɛm, nya i kaŋ yi bəni bə Lum wə na maka mih gbɔ na i gia yidɔkɔ wə i bəni bəbukumbɛiŋ nabə i nɔni ki bətii bəbukumbɛiŋ. ");
INSERT INTO cug_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Jɔbi wə bəni bə Lum ni tsɛiŋ ləkə i nsaka wuŋ wə, nəki yɛiŋ kə gia yə bɔ kɔ i wɔɔ mih yɛiŋ. Bɔ ka nəŋki i bee mih, ");
INSERT INTO cug_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ayakalə, Bəju nəki bum kə. Mih nì kaŋaki a tsâ a nsaka wuŋ tsə̂ i ninshiŋ i Ŋkuŋ wi Lum. Mih nì dzakaki yakadəiŋ, a kɔbi a mih kaŋaki lə gia yidɔkɔ i jiə i bəni mbəŋ fuŋ. ");
INSERT INTO cug_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Akɔ gia yə yi fə mih ka mih bɔɔŋ mbɛiŋ a bukumbɛiŋ dzâka. Mih kɔ i bənsəŋ bələ wə lə num kɔm bə mi wə bukumbɛiŋ bəni bə Islae nì wɔkɔliki.” ");
INSERT INTO cug_vpl VALUES ("AC28_21","074_28_21"