﻿USE sofia;
DROP TABLE IF EXISTS sofia.cucNT_vpl;
CREATE TABLE cucNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cucNT_vpl WRITE;
INSERT INTO cucNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","I⁴la³ ti²ton³ la⁴jang³⁴ sa¹jeun³ quian¹ Jesucristo a³lang⁴³ jon⁴³tyie¹ A³brang²³ jian³ Da³vei²³. ");
INSERT INTO cucNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A³brang²³ lang⁴³ jmai³ I³sa²³. Jian³ i²con²³ I³sa²³ a⁴hyon²³ Ja³co²³. I² i²con²³ Ja³co²³ ra⁵sian³ Judá jian³ si³reunh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","I² i²con²³ Judá jian²³ A¹ta³mar²³ ra⁵sian³ Fares jian³ Zara. Jian³ i²con²³ Fares ra⁵sian³ Esrom. Jian³ i²con²³ Esrom ja³⁴ Aram. ");
INSERT INTO cucNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","I² i²con²³ Aram ja³⁴ Aminadab. I² Aminadab ja³⁴ Naasón i²con²³i³. Jian³ i²con²³ Naasón ja³⁴ Salmón. ");
INSERT INTO cucNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jian³ i²con²³ Salmón jian²³ A¹ra³hab²³ ra⁵sian³ Booz. Jian³ i²con²³ Booz jian²³ A¹rut² ra⁵sian³ Obed. I² i²con²³ Obed ja³⁴ Isaí. ");
INSERT INTO cucNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jian³ i²con²³ Isaí hain⁴ ra⁵sian³ re¹ Da³vei²³. Jian³ i²con²³ re¹ Da³vei²³ jian²³i³ a³m⁴ a³ma²lang⁴³ i³cúa³ Urías hain⁴ ra⁵sian³ Salomón. ");
INSERT INTO cucNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jian³ i²con²³ Salomón ra⁵sian³ Roboam. Jian³ i²con²³ Roboam ra⁵sian³ Abías. Jian³ i²con²³ Abías ra⁵sian³ Asa. ");
INSERT INTO cucNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jian³ i²con²³ Asa ra⁵sian³ Josafat. Jian³ i²con²³ Josafat ja³⁴ Joram. Jian³ i²con²³ Joram ja³⁴ Uzías. ");
INSERT INTO cucNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jian³ i²con²³ Uzías ja³⁴ Jotam. Jian³ i²con²³ Jotam ja³⁴ Acaz. Jian³ i²con²³ Acaz ja³⁴ Ezequías. ");
INSERT INTO cucNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jian³ i²con²³ Ezequías ra⁵sian³ Manasés. Jian³ i²con²³ Manasés ra⁵sian³ A³mong²³. Jian³ i²con²³ A³mong²³ ra⁵sian³ Josías. ");
INSERT INTO cucNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jian³ i²con²³ Josías hain⁴ cuan³⁴ Jeconías jian²³ si³reunh¹ ma²a⁴han⁵ Israel chion³² ta⁵jeu³ Babilonia. ");
INSERT INTO cucNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","I² coh⁵ a⁴húan³i³ chion³² jeu³ Babilonia jon³, jon³ ra⁵sian³ a³jon⁴³ Jeconías liah⁴ a³sain³ Salatiel. I² Salatiel hain⁴ ra⁵sian³ Zorobabel i²con²³. ");
INSERT INTO cucNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jian³ i²con²³ Zorobabel ra⁵sian³ Abiud. Jian³ i²con²³ Abiud ja³⁴ Eliaquim. Jian³ i²con²³ Eliaquim ja³⁴ Azor. ");
INSERT INTO cucNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jian³ i²con²³ Azor ja³⁴ Sadoc. Jian³ i²con²³ Sadoc ja³⁴ Aquim. Jian³ i²con²³ Aquim hain⁴ ja³⁴ Eliud. ");
INSERT INTO cucNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jian³ i²con²³ Eliud ra⁵sian³ Eleazar. Jian³ i²con²³ Eleazar ra⁵sian³ Matán. Jian³ i²con²³ Matán ja³⁴ Ja³co²³. ");
INSERT INTO cucNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","I² i²con²³ Ja³co²³ hain⁴ ra⁵sian³ Se¹, a³hain⁴ i³cúa³ Ma³rei² a³cuan³⁴ Jesús i²con²³, a³teh²i³ Ua⁵lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","I² la⁴ne³ ja³⁴ quia⁵quin⁴ sa¹jeun³ liah⁴ma²sian³ A³brang²³ la⁴teg⁴ Da³vei²³; jian³ quia⁵quin⁴ liah⁴ma²sian³ Da³vei²³ la⁴teg⁴ jm² i⁴a⁴han⁵ a³jeu³ Israel chion³² ta⁵ Babilonia; conh⁴liah⁴ i²quia⁵quin⁴ liah⁴ma²tionh²i³ chion³² Babilonia la⁴teg⁴ i²cuan³⁴ A³ua⁵lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","La⁴la³ ra⁵sian³ Jesucristo: A⁴leg³⁴ re³ i⁴sanh⁴ Ma³rei² sie²³i³ jian²³ Se¹ ma²jon³. I² jon³ ne⁵, naih⁵i² ra⁵jian²³i³, jon³ a⁴can³⁴ Ma³rei² a³jon⁴³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","I² Se¹ a³lain⁴ i³cúa³i³ lang⁴³ jan³ a³ñih³ a³ni²taih⁴³, sa⁴hnie³⁴i³ sainh³i³ Ma³rei² o³hyeih² i²con²³ chie³; quie¹ hnie³⁴i³ ma⁵tyan³i³ jau²³ i⁴ma²quian¹i³ ta⁵si²hma². ");
INSERT INTO cucNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","I² con³ma²júan³i³ co³hei²tsei³ nei² ne³, jon³ ma⁴jnia³² jan³ ángel quian¹ Se³ño²³ con⁴juah⁴ gui³sie⁴, a⁴sagh⁴³i³: ―Hnei³ Se¹, sa¹jeun³ Da³vei²³, a⁵júan³ hnei³ canh⁴³ i⁴hyeinh³²ˉ³ Ma³rei² i⁴lain⁴ i³cúah³ˉ³, quie¹ i⁴ua²chieh¹i³ jon³, i⁴quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹pa². ");
INSERT INTO cucNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Quie¹ li⁴sian³ jan³ a³jon⁴³i³, a³ñih³, a³hain⁴ a³teh³²ˉ³ jm³i⁴sain³ JESÚS, quie¹ lion⁴³i³ chie³ quian¹ i⁴hain³⁴i³ chie³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","La⁴jeg³⁴ i⁴ne³ si³lei⁴ canh⁴a² li⁴tei⁴³ jau²³ quieh¹ Se³ño²³ i⁴a⁴hleh⁴i³ con⁴juah⁴ jan³ a³sain² quian¹i³ a³a⁴juah⁴: ");
INSERT INTO cucNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Can³⁴ jan³ a³m⁴ maih³ yein³, li⁴sian³ jan³ a³jon⁴³i³, a³ñih³; jian³ ma²sainh²ˉ³ yein³ hain⁴ Emanuel, hnie³⁴ ra³juah⁴: Jon⁴dai¹ jie³ jnia¹. ");
INSERT INTO cucNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","I² con³ma²a⁴ñei³⁴ Se¹ ma²qui³tian⁴, jon³ ma⁴tei⁵i³ liah⁴ heih⁴³ i⁴a⁴júan⁴ ángel quian¹ Se³ño²³ i²con²³i³, a⁴hyein⁴³i³ Ma³rei² i⁴lang⁴³ i³cúa³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Quie¹ a⁵sia³ a⁴cua⁴i³ liah⁴i² tionh² chie³ jian²³ i³cúa³ la⁴conh⁴i² ra⁵sian³ a³jon⁴³i³ a³nai², a³hain⁴ a³ma⁴sain³i³ JESÚS. ");
INSERT INTO cucNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Con³ma²ra⁵sian³ Jesús je¹jeu³ Belén i²tei⁴³ Judea, ñi³ ma²lang⁴³ Herodes re¹, i² jon³ a⁴tyie³⁴ co⁴meih³ chie³ je¹jeu³ Jerusalén a³ma³tang²³ nei² quieh¹ jah⁴nai⁴³, a³sian³ ta⁵ja³⁴ hyie³, ");
INSERT INTO cucNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","juah⁴i³: ―¿Jainh¹ ra³quian³ re¹ quian¹ judío tionh² a³ra⁵sian³? Quie¹ a⁴nia³² jnie³² jah⁴nai⁴³ quian¹i³, con³ma²tieh² jnie³² ta⁵jia²³ hyie³, i⁴jon³ jo³⁴ jnie³² a⁵ma⁵con³²i³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","I² con³ma²a⁴nau⁴ re¹ Herodes jau²³, ta² a⁴tanh⁴³ tsei⁴³i³ jian³ la⁴jang³⁴ a³tionh² je¹jeu³ Jerusalén liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I² jon³ a⁴júan⁴i³ heih⁴³ i⁴ŋangh⁴³ la⁴jang³⁴ m³chie³ tyein² liah⁴ma³jian²³ a²teg²³ quian¹ lai²³ a³he²³ i²con²³ a³jeu³, a⁴ŋang⁴i³ i²con²³ a³hain⁴ tionh² jainh¹ li⁴sian³ A³ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―Belén pa² i²tei⁴³ húa³⁴ Judea, quie¹ la⁴ne³ a⁴sag⁴ jan³ a³sain²: ");
INSERT INTO cucNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Hnei³, jeu³ Belén, i²tei⁴³ húa³⁴ Judá, ua²liah⁴a² peih¹ hnei³, ta² hlion⁴ queinh⁴³ˉ³ la⁴conh⁴a² a³tyein² tionh² húa³⁴ Judá; quie¹ i²conh² hnei³ li⁴sian³ jan³ a³quian³ ma³tyi² a³hion⁵ Israel, a³jeu³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","I² jon³ ne⁵, a⁴te⁴ Herodes, a⁴teh³i³ a³ma³tang²³ nei² quieh¹ jah⁴nai⁴³ hain⁴ ta⁵ni²hma², a⁴ŋang⁴i³ ta¹ jon³ hain³ mah² ma⁴jnia³² jah⁴nai⁴³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","I² jon³ a⁴sai⁴i³ ta⁵ Belén, juah⁴i³: ―Cua³ ua⁴han² hnei³ tionh²ˉ³, ua⁴ŋang² hnei³ o³re³ hion²³ nei² quieh¹ yein³; i² tei⁴³i² ma³a⁴chianh³²ˉ³ ne⁵, jon³ nioh¹ˉ³ ni²júanh²ˉ³ jau²³ i²con²³ˉ⁵ canh⁴a² la⁴jon³ nai³²ˉ⁴ liah⁴ ni¹ma⁴con³²ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","I² con³ma²a⁴nau⁴i³ tionh² jau²³ quieh¹ re¹, jon³ ua⁵han²i³. I² jon³ ma⁴jnia³² jah⁴nai⁴³ hain⁴ ta⁵nei²i³ tionh² liah⁴i² a⁴tyie³⁴i³ a³a⁴hang⁴ i²ra³quian³ yein³, a³ma²a⁴jen³i³ ta⁵ja³⁴ hyie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","I² con³ma²a⁴jen³i³ jah⁴nai⁴³, hlion⁴ mai²³ si³hyonh³i³ a⁴leg³⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","I² con³ma²a⁴han⁵i³ jauh³², jon³ a⁴jen³i³ yein³ jian²³ Ma³rei² sie²³. I² jon³ a⁴si⁴jnei⁵i³, a⁴ma⁴con⁴³i³ yein³. Jian³ a⁴nia³⁴i³ a²cúa⁴³ quieh¹. A⁴húa⁴i³ o¹cau³²nie¹, jian³ sein³, jian³ mirra i⁴jia²³ ma³jeu³ liah⁴, a⁴cúah³i³ yein³. ");
INSERT INTO cucNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","I² coh⁵ jon³ ne⁵, a⁵ra⁵ñi³i³ tionh² con⁴juah⁴ gui³sie⁴ i⁴so⁵hniah³ chianh³i³ jeu³ cua⁴³ Herodes; i² jon³ ŋah³i³ jeu³ co²³ jeu³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","I² con³ma²ŋah³ a³hain⁴ tionh², jon³ ma⁴jnia³² jan³ ángel quian¹ Se³ño²³ i²con²³ Se¹ liah⁴ con⁴juah⁴ gui³sie⁴, juah⁴i³: ―No³ hnei³, te⁴³ hnei³ yein³ jian²³ sie²³, cm² hnei³ ta⁵húa³⁴ Egipto, i²jon³ ua²neih⁴ˉ³ la⁴conh⁴i² juah¹ˉ⁴ liah⁴ i⁴seg³⁴. Quie¹ júan³⁴ Herodes hnoh⁴³i³ liah⁴ li⁴jŋangh³i³ yein³. ");
INSERT INTO cucNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jon³ ra⁴hang³² Se¹, a⁴te¹i³ yein³ jian²³ sie²³ to⁵je¹nai³ jon³, ŋah³i³ ta⁵ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","I²jon³ a⁴cua⁴i³ la⁴conh⁴i² jaun² Herodes, canh⁴a² la⁴jon³ li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ Se³ño²³ con⁴juah⁴ jan³ a³sain² quian¹ con³ma²a⁴juah⁴i³: “A⁴te³²ˉ⁴ a³jon³⁴ a³ma²hein² ta⁵ Egipto.” ");
INSERT INTO cucNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","I² jon³ ne⁵, con³ma²ra⁵ñi³ Herodes i⁴ma⁴co³ a³ma³tang²³ nei² quieh¹ jah⁴nai⁴³ hain⁴ quieh¹i³, jon³ jain²³ tsei⁴³i³ hlion⁴ mai²³. Ma²jon³ a⁴júan⁴i³ heih⁴³ i⁴jŋangh³i³ la⁴jang³⁴ si³maih² peih¹, a³ñih³, a³hein² to⁵ñi³ ta⁵jeuh³ a³tionh² je¹jeu³ Belén jian³ la⁴con³ hloh³² jon³, con⁴juah⁴ jm² i⁴a⁴juah⁴ a³ma³tang²³ nei² quieh¹ jah⁴nai⁴³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","I² la⁴ne³ ra⁵tei⁴³ jau²³ quieh¹ Jeremías, a³sain² quian¹ Jon⁴dai¹ hain⁴, con³ma²a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","A⁴naih⁵ i⁴hoh⁵ chie³ je¹jeu³ Ramá, i⁴hoh⁵i³ tia⁴, chionh⁴ tsei⁴³i³, jian³ hien²³i³ liah⁴. Hoh⁵ A¹ra³que² nei² quieh¹ si³jon⁴³. Sa⁴i²lai⁴³ tsei⁴³i³ quie¹ a⁴chian³⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","I² con³ma²a⁴jaun³⁴ Herodes, jon³ ma⁴jnia³² jan³ ángel quian¹ Se³ño²³ i²con²³ Se¹ húa³⁴ Egipto jon³ con⁴juah⁴ gui³sie⁴, ");
INSERT INTO cucNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","juah⁴i³: ―Ra⁴hang³² hnei³, te⁴³ hnei³ yein³ jian²³ sie²³, cuanh³ ta⁵húa³⁴ Israel; quie¹ ma³a⁴chian³⁴ a³ma²i²jŋangh³ yein³. ");
INSERT INTO cucNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","I² jon³ a⁴no³i³, a⁴te¹i³ yein³ jian²³ sie²³, jonh³i³ ta⁵húa³⁴ Israel. ");
INSERT INTO cucNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","I² con³ma²ra⁵ñi³i³ i⁴lang⁴³ Arquelao ta¹ húa³⁴ Judea nei² quieh¹ Herodes jmai³i³, jon³ ra⁵coh⁴³i³, so⁵i²chianh³i³ i²jon³. I² jon³ a⁴júan⁴ Jon⁴dai¹ jau²³ i²con²³i³ con⁴juah⁴ gui³sie⁴, jon³ ŋah³i³ ta⁵ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","I² con³ma²cúan³⁴i³ i²jon³, jon³ a⁴cua⁴i³ con³ jeu³ i²sain³ Nazaret, canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ a³sain² quian¹ Jon⁴dai¹ i⁴teh³i³ Cristo jan³ a³sian³ Nazaret. ");
INSERT INTO cucNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jm² jon³ ja³⁴ Juan³ Tei³², hleh²i³ jau²³ quieh¹ Jon⁴dai¹ con³ i²a⁵sian⁴³ a³sian³ ta⁵húa³⁴ Judea, ");
INSERT INTO cucNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","juah⁴i³: ―Sag¹ hnei³ co³hei²tsei³ quianh³ tionh²ˉ³, quie¹ ma³ja²³ hloh³² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Quie¹ Juan²³ la³ hain⁴ a³a⁴hleh⁴ Isaías nei² quieh¹, a³sain² quian¹ Jon⁴dai¹, con³ma²a⁴juah⁴i³: Si²hleh² jan³ tia⁴ con³ i²a⁵sian⁴³ a³sian³, juah⁴i³: “Júanh¹ hnei³ jeu³ quieh¹ Se³ño²³ tionh²ˉ³; o³chie⁴³ ñeih¹ hnei³ jeu³ quieh¹i³.” ");
INSERT INTO cucNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","I² Juan²³ hain⁴ hein² a²hmh³ leg⁴³ a²lo³² camello, jian³ ya¹hñih²i³ con³ a²lo³, jian³ ma³⁴ quieh¹i³ leg⁴³ a¹nangh³ jian³ o¹jm³ro⁴ quieh¹ jah⁴toh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","I² jon³ a⁴húan³ jeun⁴³ a³tionh² je¹jeu³ Jerusalén i²con²³i³, jian³ la⁴jang³⁴ a³sian³ húa³⁴ Judea, jian³ a³sian³ la⁴tan² hloh³² jm³ Jordán, a⁵han²i³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","I² jon³ a⁴sie⁴³ Juan²³ jm³ quieh¹i³ jm³ Jordán, jian³ a⁴tion⁴i³ chie³² quieh¹ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","I² con³ma²a⁴je³⁴ Juan²³ i⁴a⁵han² jeun⁴³ fariseo jian³ saduceo tionh² a³hnie³⁴ son⁵ jm³, jon³ a⁴juah⁴i³: ―¡Hnei³ tionh²ˉ³ jeun³ a⁵mh³! ¿Hain³ a⁴sag⁴³ hnei³ i⁴hnoh³ˉ³ lionh⁴ˉ³ ma²eu⁴³ pain⁴ i⁴jia²³? ");
INSERT INTO cucNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ma⁴jnia³² hnei³ liah⁴i² haih¹ ma⁵jnia³² a³ma³a⁴sag²³ co³hei²tsei³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jian³ sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ naih⁵ m⁴tyi⁴ quianh³ˉ³ tionh²ˉ³, i⁴lainh⁴ˉ³: “Sa¹jeun³ A³brang²³pa² jnia¹.” Quie¹ juah³ jnia⁴, la⁴teg⁴ m⁴caun² la³ li⁴júan³⁴ Jon⁴dai¹ i⁴lain⁴³ sa¹jeun³ A³brang²³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jian³ ma³ya¹hei⁴³ re³ a²ñi²³ tyi² i⁴gmh⁴ a²hma³ la⁴teg⁴ o¹júan⁴³. I² la⁴jon³ ne⁵, la⁴jeg³⁴ a²hma³ i⁴sa⁴cúa²³ o¹m⁴ tsei³⁴ hniah³ gmh⁴, jian³ ton³⁴i³ joh⁴³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Quie¹ i⁴chie⁴³pa² jnia⁴ ne⁵, sion⁵ˉ⁵ hnei³ jm³ tionh²ˉ³ con⁴juah⁴ o¹jm³ i⁴júan³ lei³ i⁴ma³a⁴sag²³ co³hei²tsei³ quianh³ˉ³. I² a³jia²³ coh⁵ ne³ ne⁵, a³júanh⁴³ a⁵hei⁴³ lia⁴ jnia⁴, jian³ sa⁴haih¹ can¹ jnia⁴ a²lo³ tsei²³ tag³² hei⁴i³. Hei⁴ pi²³i³ júan³⁴ i⁴hyeih² hnei³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ tionh²ˉ³, jian³ i⁴quie⁴ co³hei²tsei³ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jian³ sianh³i³ a²ñi²³ jleg³ cúa²³ quieh¹ i⁴quiah³i³ o¹m⁴ trigo i⁴qui³⁴i³ ma²qui³. Jon³ ro³⁴i³ o¹m⁴ trigo joh⁴³ a²quei³, jian³ jeng³⁴i³ ma²qui³ jeu³ o¹jyi³ loh⁴³ sa⁴legh⁴ ua²a⁴au³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jon³ ua⁵hag⁴³ Jesús húa³⁴ Galilea, a⁴tyie³⁴i³ jm³ Jordán i²sainh⁴³ Juan²³ canh⁴a² sie⁵i³ jm³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","I² Juan²³ ne⁵, sa⁴ma²hyein⁴³i³, juah⁴i³: ―Ta⁵si²quian¹ jm² pe²³ˉ⁴ hno⁵ˉ⁵ sieh³²ˉ³ jnia⁴ jm³. I² hnei³ ne⁵, ta⁵a⁴niah³pa² hnei³ i²con²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","I² jon³ a⁴juah⁴ Jesús, a⁴jainh³i³ jau²³: ―Ua²lei⁴ la⁴ne³ tieh²la³, quie¹ haih¹ i⁴ma²tei³²ˉ¹ la⁴jeg³⁴ nai² i⁴tsei³⁴. I² jon³ a⁴hyein⁴³ Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","I² con³ma²a⁴son⁴ Jesús jm³, jon³ a⁴hyon²³i³ nei² jm³ liah⁴ma²jon³. I² jon³ a⁴na⁴ ñi⁴jeu⁵, jian³ a⁴je³⁴i³ i⁴jyie²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³i³ la⁴jan³ a⁵ta³cuah³, ja³⁴i³ la⁴teg⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jon³ a⁴hain³² i⁴hleh² jan³ ñi⁴jeu⁵, juah⁴i³: ―A³ne³pa² A³jon³⁴ˉ⁴ a³hno⁵ˉ⁵, a³eu⁴³ teg³ tsei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jon³ a⁴te¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹; a⁴te¹i³ Jesús la⁴teg⁴ con³ i²a⁵sian⁴³ a³sian³, canh⁴a² con⁴³ a³sa⁴tsein³⁴ jau²chie⁴³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","I² con³ma²ua⁴jeu³² to⁴lo⁵ jm² jian³ to⁴lo⁵ húa²³ i⁴sa⁴a⁴queuh³i³ i¹ca³leuh², jon³ ra⁵cúanh⁴³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jon³ ja³⁴ a³sa⁴tsein³⁴ i²con²³i³, a⁴juah⁴i³: ―Juah⁴ne³ hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹, li⁴júanh²ˉ³ heih⁴³ m⁴caun² la³ i⁴lai⁴³ a²hei⁴³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","I² jon³ a⁴juah⁴ Jesús: ―Quie¹ ra³juah⁴ ra³sag² Ma²jyi³: “A⁵jon⁴³ con⁴juah⁴ jmah³ a²hei⁴³ñih¹ sian³ chie³, quie¹ con⁴juah⁴ la⁴jeg³⁴ jau²³ i⁴hleh² Jon⁴dai¹pa².” ");
INSERT INTO cucNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","I² jon³ a⁴te¹ a³sa⁴tsein³⁴ quieh¹i³ la⁴teg⁴ je¹jeu³ hen² Jerusalén, a⁴saih⁴i³ yeih³² hnei⁴³ cuah³júah². ");
INSERT INTO cucNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","I² jon³ a⁴sagh⁴³i³ Jesús: ―Juah⁴ne³ hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹, jon³ juan⁴³ hnei³ con³ teg⁴ húa³⁴, quie¹ ra³juah⁴ ra³sag² Ma²jyi³: Júan³⁴ Jon⁴dai¹ heih⁴³ i²con²³ ángel quian¹ i⁴hie⁵i³ hnei³. Jian³ sieh⁴³i³ hnei³ jeu³ si¹cúa³, canh⁴a² sa⁴jainh⁴³ˉ³ eu⁴³ i⁴jnoh³ m⁴caun² si¹tagh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","I² jon³ a⁴juah⁴ Jesús: ―Quie¹ ra³juah⁴ ra³sag² liah⁴: “Sa⁴hniah³ con⁴³ chie³ jau²chie⁴³ i²con²³ Se³ño²³ Jon⁴dai¹ quian¹.” ");
INSERT INTO cucNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Conh⁴liah⁴ a⁴te¹ a³sa⁴tsein³⁴ quieh¹i³ teg⁴ con³ nei² mah⁴ i⁴ñei⁴³ don⁵, i² jon³ a⁴heh³i³ Jesús la⁴jeg³⁴ nación quieh¹ cuah³²húa³⁴ la³ jian³ la⁴conh⁴ tei⁴³ i⁴co³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jian³ a⁴juah⁴i³: ―Jeh³², la⁴tan² jno³ cúa¹ˉ⁴ quianh³ˉ³ juah⁴ne³ si²jneih³²ˉ³ ta⁵nei³⁴ˉ⁴ i⁴ma²coh³²ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jon³ a⁴juah⁴ Jesús: ―Cuanh³ hnei³, a⁵lainh³², quie¹ ra³juah⁴ ra³sag² Ma²jyi³: “Jan³ Se³ño²³ Jon⁴dai¹pa² hniah³ ma⁵con⁴³ chie³, jian³ jan³ hain⁴pa² hniah³ cúa³⁴i³ cúa³tag³² i²con²³.” ");
INSERT INTO cucNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","I² jon³ ne⁵, a⁴tai³⁴ a³sa⁴tsein³⁴ quieh¹i³, jian³ a⁵han² ángel a³a⁴cúa⁴ cúa³tag³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Con³ma²ra⁵ñi³ Jesús i⁴hein² Juan²³ ni⁴ñi²³, jon³ ŋah³i³ ta⁵ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","I² jon³ ua⁵hag⁴³i³ je¹jeu³ Nazaret, ni²cua³i³ je¹jeu³ Capernaum, con³ si³da²³ i⁴nie⁴³ quien¹i²jm¹ jm³ñei³ hloh³² húa³⁴ Zabulón jian³ Neftalí. ");
INSERT INTO cucNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ Isaías, a³sain² quian¹ Jon⁴dai¹ hain⁴, con³ma²a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Hnei³ tionh²ˉ³, a³tionh² húa³⁴ Zabulón jian³ húa³⁴ Neftalí jeu³ nie⁴³ jeu³ chie²³i³ jm³ñih¹, ta⁵hŋoh³ jm³ Jordán, i²tei⁴³ húa³⁴ Galilea i²tionh² a³sa⁴lang⁴³ judío. ");
INSERT INTO cucNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Jeu³ a³ma²tionh² i²naih³ a⁴je³⁴ con³ joh¹ pain⁴, jian³ a³ma²tionh² i²ma²jaun⁴ a⁴tagh⁴ joh¹ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","I² ta⁵i²ŋo³⁴ jon³, a⁴ma⁴lie⁵ Jesús a⁴hleh⁴ jau²³ quieh¹ Jon⁴dai¹, juah⁴i³: ―Sag¹ hnei³ co³hei²tsei³ quianh³ tionh²ˉ³, quie¹ ma³ja²³ hloh³² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","I² con³ma²si²ŋeng²³ Jesús quien¹i²jm¹ jm³ñei³ Galilea, jon³ a⁴jen³i³ on³⁴ chie³ la⁴can³ si³reunh¹, Si²úan¹ a³teh²i³ Pe³², jian³ Dre¹ reunh¹i³, a³ma²ti²saih⁵ a²nai²³; quie¹ lang⁴³i³ a³jo³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I² jon³ a⁴juah⁴ Jesús: ―Nia³ hnei³ coh⁵cah³ˉ⁴, canh⁴a² júan³²ˉ⁴ i⁴lainh⁴ˉ³ a³jo³ a³sanh² chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Liah⁴ma²jon³ a⁴ton³⁴i³ a²nai²³ quieh¹, ua⁵han²i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ŋo³⁴ pi¹ Jesús, jon³ a⁴jen³i³ i²on³⁴ chie³ la⁴can³ reunh¹, Jacobo jian³ Juan²³, si³jon⁴³ Zebedeo, a³ti²tionh² joh⁴³ a²úan⁴³ jian²³i³ Zebedeo jmai³i³, a³ti²júanh² a²nai²³ quieh¹. I² jon³ a⁴teh³i³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Liah⁴ma²jon³ a⁴ton³⁴i³ a²úan⁴³ quieh¹ jian³ a⁴ton³⁴i³ jmai³, ua⁵han²i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ma²jon³ a⁴ŋeng⁴ Jesús la⁴tan² húa³⁴ Galilea la⁴jeg³⁴ cuah³ judío conh⁴ con³ jeu³, a⁴heh³i³ chie³ jau²³ tsei²³ quieh¹ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵, jian³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ la⁴jang³⁴ a³ti²lang⁴³ chie² ma⁵quein²³. ");
INSERT INTO cucNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma²jon³ ta⁴tsei¹ jau²³ nei² quieh¹i³ la⁴tan² húa³⁴ Siria. I² jon³ ua⁴jan³i³ la⁴jang³⁴ a³ti²lang⁴³ chie² ma⁵quein²³, jian³ a³ti²can²³ ma²eu⁴³, jian³ a³ti²quian³ m⁴tyi⁴ hlagh³², jian³ a³ti²lang⁴³ chie² jaun⁴ ñei⁴, jian³ a³ti²lo³. I² jon³ a⁴júan⁴ Jesús i⁴a⁴huan⁴ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","I² jon³ ua⁵han² jeun⁴³ chie³ coh⁵cah³²i³, a³sian³ Galilea, jian³ a³sian³ Decápolis, jian³ a³tionh² Jerusalén, jian³ Judea, jian³ jo³² ta⁵hŋoh³ jm³ Jordán liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Con³ma²a⁴jen³i³ chie³ a³jeun⁴³, jon³ a⁴eu⁴i³ con³ nei²cuanh³, i² jon³ a⁴cua⁴i³. Jian³ a⁴tyie³⁴ chie³ quian¹i³ hlonh²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","I² jon³ ma⁴lie⁵i³ a⁴hleh⁴i³, a⁴heh³i³ a³hain⁴ tionh², juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ta² tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³ti⁴ñeih⁵ m⁴tyi⁴ quieh¹, quie¹ tain⁴³ hei⁴ pi²³i³ han⁵i³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ta² tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³ti²hoh⁵, quie¹ jia²³ jm² lai⁴³ tsei⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ta² tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³huan³², quie¹ hyieh⁴i³ cuah³²húa³⁴ i⁴a⁴juah⁴ Jon⁴dai¹ cúa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ta² tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³ya¹queunh³ tsei⁴³ i⁴júan³⁴i³ i⁴tsei³⁴, quie¹ ma⁵ho³² Jon⁴dai¹ quieh¹i³ i⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Jian³ eu⁴³ tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³jieh⁴ ñei⁴ tsei⁴³, quie¹ i²con²³ hei⁴ pi²³i³ jieh⁴ ñei⁴ tsei⁴³ Jon⁴dai¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Jian³ eu⁴³ tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³cag⁴ m⁴tyi⁴ quieh¹ tionh², quie¹ hei⁴i³ tionh² jen⁴³i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Jian³ eu⁴³ tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³ma³tyan³ hnai³qui³ i⁴tionh² chie³, quie¹ teh³i³ a³hain⁴ jon⁴³segh³² Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Jian³ ta² tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³qui³hag²³ chie³ quieh¹ nei² quieh¹ i⁴júan³i³ i⁴tsei³⁴, quie¹ tain⁴³ hei⁴ pi²³i³ han⁵i³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Jian³ ta² tsei³⁴ jm² li⁴renh³ˉ³ tionh²ˉ³ tei⁴³i² hleh⁴³i³ hnei³ jau²hlagh³² nei² quien⁴ˉ⁴, jian³ i⁴qui³hag²³i³ hnei³, jian³ i⁴hleh³i³ la⁴jeg³⁴ nai² i⁴hlagh³² nei² quianh³ˉ³ i⁴ta³jaun²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Júan² hnei³ si³hyonh³ˉ³ hlion⁴ mai²³ nei² ne³ quie¹ eu⁴³ hlion⁴ ma⁵hmah³² Jon⁴dai¹ quianh³ˉ³ tionh²ˉ³ ñi⁴jeu⁵; quie¹ la⁴ne³ a⁴júanh¹i³ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ jm² ma³ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Hnei³ tionh²ˉ³ langh⁴³ˉ³ la⁴con³ o¹ñi² quieh¹ cuah³²húa³⁴. I² juah⁴ne³ a⁴chia³⁴ ua³pei⁴ quieh¹, ¿hain³liah⁴a² ma⁵li⁴ñih¹? Quie¹ i¹leuh² so⁵tsei³⁴, hniah³ ton³⁴i³ o³tan² jian³ he⁵soh³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Conh⁴liah⁴ langh⁴³ hnei³ tionh²ˉ³ joh¹ quieh¹ m⁵cu³. Con³ jeu³ i⁴nie⁴³ nei² con³ mah⁴ ton³²nie⁴³ lain³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jian³ sa⁴hainh²i³ con³ o¹jyi³ juah⁴ i⁴seih³i³ naih⁵ a²hma³ ca³jeun²³, quie¹ seih²i³ con³ i²leg⁴³ yeih³² canh⁴a² jnia⁴ joh¹ quieh¹ i²con²³ la⁴jang³⁴ a³tionh² jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","I² la⁴ne³ jon³ júan² hnei³ i⁴ya¹hainh² joh¹ quianh³ˉ³ tionh²ˉ³ i²con²³ la⁴jang³⁴ chie³, canh⁴a² li⁴júan³⁴i³ i⁴júanh⁴³ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵ tei⁴³i² a⁴je³⁴i³ la⁴jeg³⁴ i⁴tsei³⁴ i⁴júanh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jian³ sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ tionh²ˉ³ juah⁴ i⁴a⁴nia³⁴ˉ⁴ ni³jeun⁵ˉ⁵ lai²³ quieh¹ M³se²³ jian³ o⁴ jau²³ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ juah⁴ i⁴qui²³ˉ⁵ i⁴jon³. Quie¹ cuan⁵ˉ⁵ ni³ma⁴jnia³²ˉ⁴ liah⁴ leg⁴³ i⁴chie⁴³ o³tan². ");
INSERT INTO cucNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, ta¹la⁴ sia³ ñi⁴jeu⁵ jian³ cuah³²húa³⁴, i¹con³ letra jian³ o⁴ la⁴jeg³⁴ ya¹caun⁴³ peih¹ quieh¹ letra i⁴hei¹ lai²³, sa⁴li⁴qui⁴ naih⁵i² sa⁴li⁴tei⁴³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","I⁴jon³ ne⁵, a³hain⁴ a³sa⁴ro³ jeu³ con³ heih⁴³ peih¹ quieh¹ lai²³ i⁴heh³i³ chie³ la⁴jon³, lain⁴i³ a³sa⁴quein⁴³ la⁴conh⁴a² la⁴jang³⁴ a³tionh² naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. I² a³hain⁴ a³ma³tei⁵ heih⁴³ jon³ jian³ heh³i³ a³sang²³ la⁴ne³, hei⁴i³ lain⁴ a³tyein² naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, juah⁴ne³ sa⁴ma⁵teih³²ˉ³ tionh²ˉ³ hlion⁴ la⁴conh⁴a² júan³ a²teg²³ quian¹ lai²³ jian³ fariseo, sa⁴li⁴heuh¹ˉ³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Quie¹ ma³a⁴naih³ˉ³ i⁴a⁴sagh⁴³i³ a³tionh² ya⁴jo³⁴: “A⁵jŋangh⁴³ hnei³ chie³; quie¹ a³hain⁴ a³jŋangh² chie³, ren³i³ chie³² i⁴gmh⁴ heih⁴³ i²con²³i³.” ");
INSERT INTO cucNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","I² jnia⁴ ne⁵, jeu³⁴ˉ⁴ hnei³ tionh²ˉ³: a³hain⁴ a³m³tsainh² i²con²³ a³m⁵cu³ reunh¹, ren³i³ chie³² i⁴li⁴gmh⁴ heih⁴³ i²con²³i³. Jian³ a³hain⁴ a³sagh⁴³ m⁵cu³ reunh¹: “A³can³ tsei⁴³”, ren³i³ chie³² i⁴queih³ Júa¹ Canh² heih⁴³ i²con²³i³. Jian³ a³hain⁴ a³sagh⁴³ m⁵cu³ reunh¹: “I¹con³ sa⁴queinh⁴³ hnei³”, ren³i³ chie³² i⁴li⁴si⁵hain⁴i³ qui⁴jeu⁵ i⁴leg⁴³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’I² la⁴jon³ liah⁴ juah⁴ne³ tyieh⁴ˉ³ ni²hyie⁴ quianh²ˉ³ con³ i⁴cúah²ˉ³ i²con²³ Jon⁴dai¹, i² i²jon³ a⁴tyon²³ hoh⁴³ˉ³ i⁴sa⁴re³ tionh²ˉ³ jianh²ˉ³ a³m⁵cu³ reunh³, ");
INSERT INTO cucNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jon³ hniah³ tyah²ˉ³ i⁴jon³ ta⁵nei² ni²hyie⁴ ñeih³², ta¹la⁴ jon³ tyieh⁴ˉ³ yi⁴lainh²ˉ³ jianh²ˉ³ a³m⁵cu³ reunh³. I² ma²jon³ a²ma⁴ cúah²ˉ³ ua²cúah²ˉ³ i⁴jon³ i⁴quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Ma⁴tyan²³ hnei³ hnai³qui³ jianh²ˉ³ a³si³tangh⁴ˉ³ ta¹la⁴ tionh²ˉ³ jeu³ tyieh⁴ˉ³ nei²ta¹, canh⁴a² sa⁴cúah⁴³i³ hnei³ i²con²³ júa¹, jian³ ma²jon³ cúah⁴³ hnei³ júa¹ i²con²³ po³li³sei¹, jian³ po³li³sei¹ liah⁴ tonh⁴³i³ hnei³ ni⁴ñi²³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, sa⁴legh⁴ ua²a⁴jauh²ˉ³ i²jon³ la⁴conh⁴i² sa⁴ma⁴hmah³²ˉ³ la⁴jeg³⁴ la⁴conh⁴ ni²hyan³² a²ñi²³ yein⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Quie¹ ma³a⁴naih³ˉ³ i⁴sagh⁴³i³ chie³: “A⁵hlenh⁴³ hnei³ i³cúa³ chie³.” ");
INSERT INTO cucNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","I² jnia⁴ juah³ ne⁵, la⁴jang³⁴ a³jen³ a³m⁴, i⁴hnie³⁴i³ hleh⁵i³, ma³a⁴hlenh⁴³ pi²³i³ a³m⁴ hain⁴ naih⁵ m⁴tyi⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Jian³ la⁴jon³ liah⁴, juah⁴ne³ júan³⁴ m⁴mah²ˉ³ jo³² ta⁵chie³⁴ i⁴tianh⁵ˉ³ chie³², tyi² hnei³, tien³ hnei³ i²gm⁴; quie¹ eu⁴³a² quein⁴³ i⁴si⁵hain⁴ con³ i⁴quian³ heh³²ˉ³ la⁴conh⁴a² si⁵tien⁴³i³ hnei³ la⁴tan² janh³ˉ³ qui⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jian³ juah⁴ne³ júan³⁴ si¹cúah³ˉ³ jo³² ta⁵chie³⁴ i⁴tianh⁵ˉ³ chie³², queih¹ hnei³, i²gm⁴ tien³; quie¹ eu⁴³a² quein⁴³ i⁴si⁵hain⁴ con³ i⁴quian³ heh³²ˉ³ la⁴conh⁴a² si⁵tien⁴³i³ hnei³ la⁴tan² janh³ˉ³ qui⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Conh⁴liah⁴ a⁴juah⁴i³ liah⁴ma²jia⁴³: “La⁴jang³⁴ a³tyon⁴ jian²³ a³m⁴ quian¹, hniah³ cúah³i³ con³ ma²jyi³ i⁴ra³juah⁴ i⁴ti²tyon²i³.” ");
INSERT INTO cucNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","I² juah³ jnia⁴ ne⁵, la⁴jang³⁴ a³tyon⁴ jian²³ a³m⁴ quian¹, i⁴sa⁴sia³ nei² quieh¹ a³m⁴ juah⁴ i⁴a⁴hleh⁴³ a³sang²³ quieh¹i³, júan³i³ i⁴ta³canh¹ a³m⁴ quian¹i³ hain⁴ chie³² i⁴hlenh⁴³i³ a³sang²³. Jian³ a³sanh⁴ jian²³ a³m⁴ a³a⁴tyon⁴ hain⁴ coh⁵ jon³, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ i³cúa³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Conh⁴liah⁴ ma³a⁴naih³ˉ³ i⁴a⁴sagh⁴³i³ a³sian³ ya⁴jo³⁴: “Sa⁴hniah³ jlianh³²ˉ³ jau²³ quianh³ i⁴a⁴cúah²ˉ³, quie¹ hniah³ ma²teih³²ˉ³ jau²³ quianh³ i⁴a⁴cúah²ˉ³ i²con²³ Se³ño²³.” ");
INSERT INTO cucNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","I² jnia⁴ juah³ ne⁵, sa⁴hniah³ cúah²ˉ³ jau²³ quianh³ i¹con³. Sa⁴heh²ˉ³ ta⁵ñi⁴jeu⁵, quie¹ i²jon³ cua⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A⁵ga⁴ cuah³²húa³⁴, quie¹ leg⁴³ la⁴con³ i²si²tyein¹ Jon⁴dai¹. Jian³ a⁵ga⁴ ta⁵ Jerusalén cúah²ˉ³ jau²³ quianh³, quie¹ leg⁴³ si³da²³ quieh¹ Jon⁴dai¹, Re¹ júanh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A⁵ga⁴ con⁴juah⁴ ma³tyih³ˉ³ sa⁴hniah³ cúah²ˉ³ jau²³ quianh³, quie¹ i¹con³ m⁴jñi³ tyih³ˉ³ sa⁴li⁴júanh²ˉ³ i⁴tie³ jian³ o⁴ i⁴liah³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Quie¹ eu⁴³a² re³ juah²ˉ³ “i⁴chie⁴³pa²” jian³ o⁴ “a⁵sia³pa²”, quie¹ i⁴he²³i³ hlion⁴ leg⁴³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Jian³ ma³a⁴naih³ˉ³ i⁴a⁴juah⁴i³ liah⁴ma²jia⁴³: “Hniah³ lei⁴ co³nai² eu⁴³, m⁴nei²i³ jeu³ m⁴nei²i³ jian³ m⁴jan²i³ jeu³ m⁴jan²i³.” ");
INSERT INTO cucNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","I² jnia⁴ juah³ ne⁵, i⁴sa⁴jainh²ˉ³ jm² i²con²³ a³hlangh². Quie¹ juah⁴ne³ quein³i³ ma³mah²ˉ³ jo³² ta⁵chie³⁴, hai⁴ hnei³ ta⁵ca³jo³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jian³ juah⁴ne³ sian³ a³hnie³⁴ hnang⁵ hnei³ nei² quieh¹ a²cúanh³ˉ³ ta⁵nei² si³ta¹, eu⁴³a² re³ cúah³²i³ hnei³ liah⁴ma³jian²³ a²hmh³ tsei²³ coh⁵ quianh³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jian³ juah⁴ne³ sian³ a³quien³⁴ hnei³ lie²³ ta⁵li⁴hnai³ con³ mai²³ ton⁴ metro, eu⁴³a² re³ quian³ hnei³ to⁵jeunh³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jian³ a³hain⁴ a³m²³ i²conh²ˉ³, cúah³²i³ hnei³. Jian³ a³hain⁴ a³tyi³ liah⁴ i²conh²ˉ³, sa⁴hniah³ juah⁴ sa⁴ronh³²i³ hnei³ jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Jian³ ma³a⁴naih³ˉ³ i⁴a⁴juah⁴i³ liah⁴ma²jia⁴³: “Ma⁴hno³² hnei³ a³m⁵cu³ reunh³, jian³ ma⁵hion²³ hnei³ a³hie²³ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","I² juah³ jnia⁴ ne⁵, ma⁴hno³² hnei³ a³hie²³ hnei³ tionh²ˉ³, jian³ hleh² hnei³ con³ i⁴tsei³⁴ i²con²³ a³hleh² jau²hlagh³² i²conh²ˉ³, jian³ júan² hnei³ i⁴tsei³⁴ i²con²³ a³hie²³ hnei³ liah⁴, jian³ mh³² hnei³ Jon⁴dai¹ nei² quieh¹ a³júanh¹ hnei³ jian³ a³hag²³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Canh⁴a² la⁴ne³ lei³ jnia⁴ langh⁴³ˉ³ si³jon⁴³ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵; quie¹ hei⁴ pi²³i³ júan³ i⁴jia²³ hyie³ i²con²³ a³hlangh² jian³ a³tsein²³, jian³ júan³i³ i⁴tiah² o¹jm⁴³ i²con²³ a³ni²taih⁴³ jian³ a³sa⁴ni²taih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Quie¹ juah⁴ne³ ma⁵hnoh³²ˉ³ jmah³ a³hnie³⁴ hnei³ tionh²ˉ³, ¿o⁴ ma⁵hmah³² Jon⁴dai¹ quianh³ˉ³, lainh⁴ˉ³? ¿O⁴ jon⁴³ la⁴ne³ júan³ a³can²³ hmah¹ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jian³ juah⁴ne³ ma⁵conh³²ˉ³ jmah³ si³reunh³ˉ³ tionh²ˉ³, ¿henh⁴ i⁴tsei³⁴ júanh³ˉ³, lainh⁴ˉ³? ¿O⁴ jon⁴³ la⁴ne³ júan³ chie³ sang²³ tionh² sa⁴cm²³ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","I² la⁴jon³ ne³, júan² hnei³ tionh²ˉ³ i⁴tseinh³ˉ³ o³tan² liah⁴i² tsein³⁴ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’A⁵júan³ hnei³ i⁴tsei³⁴ i⁴júanh³ˉ³ ta⁵nei² chie³, o⁴ canh⁴a² je³⁴i³ tionh². Quie¹ juah⁴ne³ júanh³ˉ³ la⁴ne³, jon³ a⁵sie⁴³ ma⁵hmah³² Naih⁴³ˉ³ quianh³ˉ³ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","I² la⁴jon³ ne⁵, tei⁴³i² ma⁵honh³²ˉ³ a³ti⁴ñei³, sa⁴hniah³ júanh²ˉ³ ti³jan²³ liah⁴i² júan³ a³ti²júan⁴³ a³ni²taih⁴³ cuah³ judío jian³ jeu³júan²³, canh⁴a² hnie³⁴i³ hleh³ chie³ tsein³⁴i³. I⁴chie⁴³pa² juah³ˉ⁴, ma³ni²hmah²pa² quieh¹i³ i⁴júan³i³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","I² hnei³ ne⁵, tei⁴³i² ma²honh³²ˉ³ a³ti⁴ñei³, i¹ sa⁴hniah³ li⁴ñi³ a³ñi³reunh³ˉ³ hion²³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Canh⁴a² la⁴jon³ ma²honh³²ˉ³ a³ti⁴ñei³ ta⁵ni²hma². I² Naih⁴³ˉ³ a³je³ hnei³ ta⁵ni²hma² hain⁴, ma⁵hmah³² quianh³ˉ³ ta⁵nei² la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’I² tei⁴³i² mh³²ˉ³ Jon⁴dai¹, sa⁴júanh²ˉ³ liah⁴i² júan³ a³ti²júan⁴³ a³ni²taih⁴³. Quie¹ si³hyonh³i³ mh²i³ Jon⁴dai¹ jeu³ si²sainh⁴³i³ cuah³ judío jian³ la⁴jeg³⁴ cua¹ jeu³júan²³ canh⁴a² je⁴³ chie³ quieh¹i³. I⁴chie⁴³pa² juah³ˉ⁴, ma³ni²hmah²pa² quieh¹i³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","I² hnei³ ne⁵, la⁴teg⁴i² mh³²ˉ³ Jon⁴dai¹ hniah³ heuh¹ˉ³ coh⁵ a²jneng²³ quianh³ jian³ jnaih²ˉ³ o²hnei³², jon³ li⁴mh³²ˉ³ Jon⁴dai¹ a³sainh⁴³ ta⁵ni²hma². I² Naih⁴³ˉ³ a³je²³ ta⁵ni²hma² hain⁴, ma⁵hmah³² quianh³ˉ³ ta⁵nei² la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’I² tei⁴³i² mh³²ˉ³ sa⁴hniah³ hleh²ˉ³ hlion⁴ nie⁴³ con³ jau²³ quie¹ sa⁴tei⁴³ ta¹, liah⁴i² júan³ a³sa⁴lang⁴³ judío, quie¹ lain⁴i³ jon³pa² nau³ Jon⁴dai¹ juah⁴ne³ hleh²i³ hlion⁴ jau²³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","A⁵júan³ hnei³ liah⁴ júan³ a³hain⁴ tionh²; quie¹ ma³ñi³ Naih⁴³ˉ³ henh⁴ hniah³ quianh³ˉ³ naih⁵i² mh²ˉ³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","I² jon³ hniah³ mh²ˉ³ la⁴la³ tionh²ˉ³: Hnei³ Jmai³ jnie³², a³cua⁴³ ñi⁴jeu⁵, ua²lei⁴ hen² jm³i⁴sainh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jian³ ua²jia³ jm² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quianh³ˉ³. Ua²lei⁴ liah⁴ hnoh³ˉ³ nei² cuah³²húa³⁴ la³ liah⁴i² leg⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cúa² hnei³ a²hei⁴³ i⁴hniah³ quian⁴ jnie³² ne³⁴ conh⁴ con³ jm². ");
INSERT INTO cucNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jian³ hain⁴³ hnei³ chie³² quian⁴ jnie³², quie¹ hain⁵ jnie³² chie³² quieh¹ a³júan³ hlagh³² i²con²³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jian³ a⁵con⁴ hnei³ jau²chie⁴³ i²con²³ jnie³², eu⁴³a² re³ lie³² hnei³ jnie³² la⁴jeg³⁴ i⁴hlagh³². Quie¹ jan³ hnei³pa² tainh⁴³ júanh² heih⁴³, jian³ i⁴quianh²ˉ³ ua³pei⁴, jian³ i⁴júanh⁴³ˉ³, sa⁴legh⁴ jm² ua²a⁴toh⁴. Ua²lei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Quie¹ juah⁴ne³ hainh⁵ˉ³ chie³² quieh¹ chie³, jon³ hain³⁴ Naih⁴³ˉ³ chie³² quianh³ˉ³ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jian³ juah⁴ne³ sa⁴hainh⁵ˉ³ chie³² quieh¹ chie³ liah⁴, jon³ sa⁴hain³⁴ Naih⁴³ˉ³ chie³² quianh³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Jian³ la⁴teg⁴i² júanh²ˉ³ he² i⁴sa⁴queuh²ˉ³ a²hei⁴³, sa⁴hniah³ jeh²ˉ³ liah⁴i² je²³ a³chionh⁴ tsei⁴³ la⁴jon³ liah⁴i² júan³ a³ti²júan⁴³ a³ni²taih⁴³, quie¹ júan³i³ i⁴hlagh³² jnia⁴ ma³nei²i³, canh⁴a² li⁴laih² chie³ i⁴júan³i³ he² sa⁴queuh³i³. I⁴chie⁴³pa² juah³ˉ⁴, ma³ni²hmah²pa² quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","I² jon³ ne⁵, tei⁴³i² júanh³ˉ³ he² sa⁴queuh³ˉ³, jyie⁴³ hnei³ o¹tyih³ jian³ raunh³² mah², ");
INSERT INTO cucNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","canh⁴a² sa⁴lei³ jnia⁴ i⁴ma⁵jniah³²ˉ³ júanh³ˉ³ he² i⁴sa⁴queuh³ˉ³; quie¹ i²con²³ Jon⁴dai¹ Naih⁴³ˉ³ a³sa⁴lain³pa², lei³ jnia⁴. Jian³ Naih⁴³ˉ³ a³je²³ ta⁵ni²hma² hain⁴, ma⁵hmah³² quianh³ˉ³ ta⁵nei² la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jian³ sa⁴hniah³ tyah²ˉ³ i⁴jlanh² quianh³ nei² cuah³²húa³⁴ la³, i²tionh² a¹sanh¹ jian³ i²hya²³ jeuh², i²si³hain⁴, jian³ i²si³hei⁴ chie³ a³júan³ hang³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Quie¹ hniah³ tyah²ˉ³ i⁴jlanh² quianh³ ñi⁴jeu⁵ i²so⁵toh² jah⁴, jian³ i²sa⁴hya²³ jeuh² i²sa⁴si³hain⁴, jian³ i²sa⁴li⁴tyie¹ a³júan³ hang³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Quie¹ i²jon³ i²nie⁴³ i⁴jlanh² quianh³ˉ³, i²jon³pa² ya¹queunh³ hoh⁴³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Quie¹ m⁴mah²ˉ³ leg⁴³ liah⁴i² leg⁴³ o¹jyi³ heh³²ˉ³. I² juah⁴ne³ tsei³⁴ m⁴mah²ˉ³, jon³ joh¹ heh³²ˉ³ la⁴tan² con³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","I² juah⁴ne³ sa⁴tsei³⁴ m⁴mah²ˉ³, la⁴tan² heh³²pa² hnei³ naih³ liah⁴. I² jon³ ne⁵, juah⁴ne³ a⁴liah⁴ o¹jyi³ quianh³ˉ³, ¡la⁴conh⁴a² sa⁴naih³ lei⁴! ");
INSERT INTO cucNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’I¹jan³ chie³ sa⁴li⁴cúa³⁴ cúa³tag³² i²con²³ on³⁴ jeu³², quie¹ jan³pa² ma⁵hnio³⁴i³ jian³ jan³ li⁴hion²³i³ liah⁴, jian³ o⁴ jan³pa² ma⁵con⁴³i³ re³, jian³ jan³ sa⁴jain¹i³ liah⁴. Jian³ la⁴ne³ liah⁴, sa⁴tian⁴ juah⁴ i⁴li⁴cúa³⁴ chie³ cúa³tag³² i²con²³ Jon⁴dai¹ jian³ o¹cau³² liah⁴ co⁴chia³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’I² la⁴ne³ jon³ juah³ˉ⁴: A⁵júan³ hnei³ hlion⁴ co³hei²tsei³ liah⁴ sianh³ˉ³, henh⁴ queuh²ˉ³ o⁴ henh⁴ hauh²ˉ³, jian³ o⁴ nei² quieh¹ heh³²ˉ³ henh⁴ heuh¹ˉ³. ¿O⁴ a⁵sia³ quein⁴³ hlion⁴ m⁵cu³ quieh¹ chie³ la⁴conh⁴a² i⁴queuh³ hangh²i³, jian³ he³² chie³ la⁴conh⁴a² i⁴hein²i³? ");
INSERT INTO cucNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jen³² hnei³ jon⁴³tan²³ ti¹hang⁵ yeih³², sa⁴jnei³i³, a⁵ga⁴ jaih²i³ a⁵ga⁴ ro³i³ joh⁴³ a²quei³; i² Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵pa² gueh⁴ quieh¹i³. ¿O⁴ a⁵sia³ queinh⁴³ˉ³ hlion⁴ tionh²ˉ³ la⁴conh⁴a² jon⁴³tan²³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Jian³ hain³ hnei³ li⁴si⁵cúanh³ˉ³ tionh²ˉ³ i²ca³leg³ nei² quieh¹ hlion⁴ co³hei²tsei³ i⁴sianh³ˉ³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Jian³ e⁴le³⁴ hlion⁴ co³hei²tsei³ sianh³ˉ³ tionh²ˉ³ nei² quieh¹ a²cúanh³ˉ³? Je² hnei³ con³ o¹lei²³ i⁴sia³ i²nau³, jeh³² liah⁴ si³cúan³, quie¹ sa⁴júan³ ta¹ a⁵ga⁴ ta²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","I² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i¹ re¹ Salomón, ua²liah⁴a² a³tyein² ma²jlanh², a⁵sia³ a²hmh³ a⁴hei³⁴i³ i⁴tyein² tsei³⁴ jnia⁴ liah⁴i² jnia⁴ o¹lei²³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Quie¹ juah⁴ne³ la⁴ne³ cúa²³ Jon⁴dai¹ a²cúan³ o¹nau³ i⁴tsei³⁴ jnia⁴ i⁴sia³ i²nau³ con³ ne³⁴, jian³ hie³⁴ jon³ co³⁴ joh⁴³ a²gm², ¿conh⁴a² sa⁴cúa³⁴i³ i²conh²ˉ³ tionh²ˉ³, hnei³ chie³ sa⁴hain⁴ hlion⁴ tionh²? ");
INSERT INTO cucNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","I⁴jon³ sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ i⁴juah²ˉ³: “¿Henh⁴ quih³²ˉ¹? ¿O⁴ henh⁴ hneih²ˉ¹? ¿O⁴ henh⁴ hei³²ˉ¹?” ");
INSERT INTO cucNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Quie¹ jmah³ i⁴ne³pa² hnoh³ chie³ sang²³ tionh², a³sa⁴cm²³ Jon⁴dai¹; quie¹ ñi³ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵ i⁴hniah³ quianh³ˉ³ la⁴jeg³⁴ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","I⁴jon³ tyein² hniah³ tonh²ˉ³ co³hei²tsei³ nei² quieh¹ hain³liah⁴ leg⁴³ i⁴tionh²i³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹ jian³ i⁴ma²teih³²ˉ³ i²con²³i³. I² ma²jon³ hyeih²ˉ³ la⁴jeg³⁴ i⁴hniah³ quianh³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","I² la⁴jon³ sa⁴júanh²ˉ³ co³hei²tsei³ nei² quieh¹ jm² hie³⁴. Quie¹ hie³⁴ jon³pa² lei⁴ li⁴júanh²ˉ³ co³hei²tsei³ nei² quieh¹. Quie¹ sia³ nei² si³lei⁴ i⁴sian³ chie³ co³hei²tsei³ nei² quieh¹ conh⁴ con³ jm². ");
INSERT INTO cucNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’A⁵tyan⁴³ hnei³ hei²³ chie³, canh⁴a² sa⁴can³⁴ Jon⁴dai¹ jau²chie⁴³ i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Quie¹ liah⁴i² si⁴henh⁵ˉ³ chie³ la⁴ne³ júan³⁴ Jon⁴dai¹ i²conh²ˉ³ liah⁴. Jian³ con⁴juah⁴ heih⁴³ i⁴queih⁴ˉ³ i²con²³ chie³, la⁴ne³pa² gmh⁴ heih⁴³ i²conh²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Quie¹ ¿liah⁴ cúan²³ jeh⁴ˉ³ con³ ma²qui³ peih¹ i⁴hei¹ m⁴nei² a³m⁵cu³ reunh³ˉ³, jian³ sa⁴jeh⁴ˉ³ con³ teinh³² hma³ pa¹ i⁴hei¹ m⁴mah²ˉ³ húanh⁴³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Jian³ o⁴ ¿liah⁴ cúan²³ li⁴jeuh³²ˉ³ a³m⁵cu³ reunh³: “Cúa² hnei³ jeu³ tyi¹ˉ⁴ ma²qui³ hei¹ m⁴mah²ˉ³ ne³”? Jian³ tsei³⁴, hei¹ con³ teinh³² a²hma³ pa¹ m⁴mah²ˉ³ húanh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hnei³, chie³ a³lain⁴ ni²taih⁴³, tyi² hnei³ ñeih³²jia⁴³ teinh³² a²hma³ pa¹ i⁴hei¹ m⁴mah²ˉ³. Ma²jon³ li⁴jeh²ˉ³ re³ i⁴tyih²ˉ³ ma²qui³ peih¹ hei¹ m⁴nei² a³m⁵cu³ reunh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’A⁵cúa³ hnei³ jau²³ hen² quieh¹ Jon⁴dai¹ i²con²³ chie³ a³lang⁴³ a¹tsai³, canh⁴a² sa⁴jie³⁴i³ hnei³. Jian³ a⁵ton³ hnei³ o¹m⁴ seg⁴³ tsei³⁴ ta⁵nei² a¹ñi⁴³, canh⁴a² sa⁴he⁵soh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’M² hnei³ tionh²ˉ³, quie¹ cúa³⁴ Jon⁴dai¹; hnieh³ hnei³, jian³ tyanh³²ˉ³ liah⁴; te² hnei³ o²hnei³², quie¹ nia³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Quie¹ la⁴jang³⁴ a³m²³, hyei³i³; jian³ la⁴jang³⁴ a³hnoh³, tyieh¹i³; jian³ la⁴jang³⁴ a³te²³ o²hnei³², nia²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Jian³ hain³ hnei³ tionh²ˉ³, lainh⁴ˉ³, li⁴cúah³²ˉ³ a³jonh³ m⁴caun² juah⁴ne³ m²³i³ a²hei⁴³ i²conh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jian³ juah⁴ne³ m⁴³i³ jon⁴³júa³², ¿o⁴ li⁴cúanh³²i³ hnei³ a⁵mh³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Quie¹ ua²liah⁴a² hlangh² hnei³ tionh²ˉ³, ñih¹ˉ³ cúah⁵ˉ³ si³jonh³ i⁴tsei³⁴. ¿La⁴conh⁴a² sa⁴ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵ cúa³⁴i³ i⁴tsei³⁴ i²con²³ a³m²³ i²con²³i³? ");
INSERT INTO cucNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’I² la⁴jon³ la⁴jeg³⁴ i⁴hnoh³ˉ³ júan³⁴ chie³ i⁴tsei³⁴ i²conh²ˉ³ tionh²ˉ³, la⁴ne³ hniah³ júanh²ˉ³ i²con²³i³ liah⁴; quie¹ la⁴ne³ hnie³⁴ ra³juah⁴ lai²³ quieh¹ M³se²³ jian³ la⁴jeg³⁴ ma²jyi³ i⁴a⁴sag⁴ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Heu²³ hnei³ jeu³ o²hnei³² tsai³, quie¹ ta² heu⁴ o²hnei³² jian³ júah³ jeu³, jeu³ i⁴tyie²³ chie³ si³hain⁴, jian³ ta² jeun⁴³ chie³ si³han² jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Quie¹ ta² tsai³ o²hnei³² jian³ tsai³ jeu³, jeu³ i²hyieh⁴i³ m⁵cu³, jian³ co⁴meih³pa² chie³ tyieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Jianh³ˉ³ júan² hnei³ tionh²ˉ³ i²con²³ a³ta³jaun²³ a³juah⁴ lang⁴³ a³sain². Quie¹ jia²³i³ i²conh²ˉ³ tionh²ˉ³ a³jnia⁴ liah⁴i² jnia⁴ a⁵a³siah³ ta⁴coh⁵, jian³ naih⁵ m⁴tyi⁴ quieh¹i³ lang⁴³i³ liah⁴i² lang⁴³ a¹tsai³nau²³ con³, a³si³hag³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Quie¹ li⁴cmh⁴³ hnei³ a³hain⁴ con⁴juah⁴ i⁴júan³i³. ¿O⁴ hag³ o¹m⁴ ya¹gm³jeh² o¹sieh³² a²ton⁴³, lainh⁴ˉ³? Jian³ ¿o⁴ o¹m⁴jyi³ nei² o¹sieh³² hma³ hlagh³², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quie¹ la⁴ne³ leg⁴³ liah⁴, la⁴jeg³⁴ a²hma³ tsei²³ cúa²³ o¹m⁴ tsei³⁴, jian³ la⁴jeg³⁴ a²hma³ hlagh³² cúa²³ o¹m⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Quie¹ con³ a²hma³ tsei²³ sa⁴li⁴cúa³⁴ o¹m⁴ hlagh³², jian³ i¹con³ a²hma³ hlagh³², sa⁴li⁴cúa³⁴ o¹m⁴ tsei³⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jian³ la⁴jeg³⁴ a²hma³ sa⁴cúa²³ o¹m⁴ tsei³⁴, queih²i³, jian³ jeng³i³ je¹ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","I² la⁴ne³ ne⁵, li⁴cmh⁴³ˉ³ chie³ con⁴juah⁴ i⁴júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jian³ a⁵hei⁴³ la⁴jang³⁴ a³hleh² “Hnei³ Se³ño²³, Se³ño²³ quian³⁴ˉ⁴”, han⁵ i²ua²júan³ Jon⁴dai¹ heih⁴³, quie¹ jmah³ a³ma³tei⁵ heih⁴³ quieh¹ Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵pa² han⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jm² jon³ jeun⁴³ juah⁴ i²con²³ˉ⁵: “Hnei³ Se³ño²³, Se³ño²³ quian³⁴ˉ⁴, ¿o⁴ sa¹ chie⁴³ a⁴hleh² jnie³² jau²³ quianh³ˉ³ con⁴juah⁴ jm³i⁴sainh³ˉ³, jian³ con⁴juah⁴ jm³i⁴sainh³ˉ³ a⁴húa² jnie³² hlion⁴ m⁴tyi⁴ hlagh³² liah⁴? ¿Jian³ con⁴juah⁴ jm³i⁴sainh³ˉ³ a⁴júan² jnie³² hlion⁴ ua³júah²?” ");
INSERT INTO cucNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","I² jon³ jeu¹i³ jnia⁴: “I¹conh⁴ sa⁴ra⁵cm⁴³ˉ⁴ hnei³. Quein⁴³ hnei³ i²gm⁴ i²con²³ jnia⁴ tionh²ˉ³, hnei³ a³júan³ jmah³ i⁴hlagh³².” ");
INSERT INTO cucNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’A³hain⁴ a³nau³ jau²³ quien⁴ˉ⁴ la³, jian³ ma³tei⁵i³, juah³ˉ⁴, i⁴lang⁴³i³ liah⁴i² lang⁴³ jan³ chie³ a³ŋang⁴ a³a⁴júan⁴ a²hnei⁴³ quieh¹ si²tyi¹ nei² a²caun². ");
INSERT INTO cucNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jon³ a⁴tah⁴ o¹jm⁴³ jian³ ja³⁴ jm³júah², jian³ a⁴tah⁴ tyi⁴ tia⁴ liah⁴, a⁴hlia⁴ a²hnei⁴³ jon³; jian³ a⁵sia³ a⁴quegh³, quie¹ si²tyi¹ nei² a²caun². ");
INSERT INTO cucNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jian³ a³hain⁴ a³nau³ jau²³ quien⁴ˉ⁴ la³, i⁴sa⁴ma³tei⁵i³, juah³ˉ⁴, lang⁴³i³ liah⁴i² lang⁴³ jan³ chie³ hmengh² tsei⁴³ a³a⁴júan⁴ a²hnei⁴³ quieh¹ si²seih⁴³ nei² o¹sag² lang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jon³ a⁴tah⁴ o¹jm⁴³ jian³ ja³⁴ jm³, jian³ a⁴tah⁴ tyi⁴ tia⁴ liah⁴, a⁴hlia⁴ a²hnei⁴³ jon³, i² jon³ a⁴quegh³. ¡Jian³ a⁴cúan⁴ o³tan²! ");
INSERT INTO cucNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","I² con³ma²a⁴toh⁴ a⁴hleh⁴ Jesús jau²³ ne³, ta² co³ ŋo³⁴ tsei⁴³ chie³ tionh² jau²³ i⁴he²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Quie¹ he²³i³ i⁴quian³i³ heih⁴³ pain⁴, a⁵hei⁴³ liah⁴ a²teg²³ quian¹ lai²³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","I² con³ma²a⁴jyon²³ Jesús nei²cuanh³ jon³, ta² jeun⁴³ chie³ ua⁵han² coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","I² jon³ ja³⁴ jan³ a³jyih² o¹ŋeu⁴³ quieh¹, a⁴si⁴jnei⁵i³ ta⁵nei² Jesús, a⁴juah⁴i³: ―Hnei³ Se³ño²³, a¹juah⁴ne³ hyon³ hoh⁴³ˉ³, li⁴júanh²ˉ³ i⁴huan⁴ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jon³ a⁴ñeih³ Jesús si¹cúa³, a⁴tei³⁴i³ he³² a³hain⁴, juah⁴i³: ―Hno⁵ˉ⁵; ua²huan⁴ quianh³ˉ³. I² liah⁴ma²jon³ ua⁵conh⁴ chie² i⁴ma²jyih² o¹ŋeu⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","I² jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ a³hain⁴: ―Jeh³², a⁵jeuh⁴³ hnei³ i¹jan³ nei² ne³. Cua³, tyieh⁴ˉ³ yi⁴ma⁴jniah³²ˉ³ ta⁵nei² m³chie³, jian³ yi⁴cúah²ˉ³ i²con²³ Jon⁴dai¹ i⁴jon³ i⁴a⁴júan⁴ M³se²³ heih⁴³, canh⁴a² li⁴ñi³i³ tionh² i⁴a⁴huan⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","I² con³ma²a⁴hei³⁴ Jesús je¹jeu³ Capernaum, jon³ a⁴tyie³⁴ jan³ jeu³² a²hlie⁴ a³a⁴m⁴ jau²³ i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","a⁴juah⁴i³: ―Hnei³ Se³ño²³, jan³ a³cúa²³ cúa³tag³² i²con²³ˉ⁵ ra³quian³ jauh³² quien⁴ˉ⁴, lo³i³ jian³ ra³can²³i³ ma²eu⁴³ hlion⁴ mai²³ i⁴chieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jon³ a⁴juah⁴ Jesús: ―Nai³²ˉ⁴ ni¹júan³⁴ˉ⁴ i⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","I² jon³ a⁴juah⁴ jeu³² a²hlie⁴ hain⁴: ―Hnei³ Se³ño²³, sa⁴haih¹ juah⁴ i⁴cúah²ˉ³ jauh³² quien⁴ˉ⁴; eu⁴³a² re³ heih⁴³pa² júanh²ˉ³, jian³ li⁴huan⁴ quieh¹ a³cúa²³ cúa³tag³² quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Quie¹ jnia⁴ liah⁴, sian³ a³júan³ heih⁴³ i²con²³ˉ⁵, jian³ tionh² a²hlie⁴ a³júan³⁴ˉ⁴ heih⁴³ i²con²³ liah⁴. Quie¹ tei⁴³i² jeu³⁴ˉ⁴ jan³, “cua³”, jon³ chie²³i³. Jian³ tei⁴³i² jeu³⁴ˉ⁴ i²jan³, “nia³”, jon³ jia²³i³. Jian³ tei⁴³i² jeu³⁴ˉ⁴ a³cúa²³ cúa³tag³² quian³⁴, “júan² i⁴ne³”, jon³ júan³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","I² con³ma²a⁴nau⁴ Jesús jau²³ jon³, ta² co³ a⁴jainh⁴³i³, jon³ a⁴sagh⁴³i³ a³ya¹han² coh⁵cah³²i³, juah⁴i³: ―I⁴chie⁴³pa² juah³ˉ⁴, i¹ jen² a³jeu³ Israel sa⁴ma³a⁴chianh³²ˉ⁴ chie³ a³hain⁴ i²con²³ˉ⁵ hlion⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, ta² jeun⁴³ chie³ a³tionh² ta⁵ja³⁴ hyie³, yi⁴han² jian³ ta⁵tyan³ hyie³ i⁴cua³⁴i³ queuh⁴³i³ a²hei⁴³ jian²³i³ A³brang²³ jian³ I³sa²³ jian³ Ja³co²³ naih⁵ heinh² quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","I² a³ma²tain⁴³ naih⁵ heinh² quieh¹ Jon⁴dai¹ hain⁴ tionh² ne⁵, ton³⁴i³ a³hain⁴ ta⁵i²naih³ quieh¹ ta⁴coh⁵; i²jon³ hoh⁵i³, queuh⁴³i³ m⁴jan². ");
INSERT INTO cucNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jon³ a⁴juah⁴ Jesús i²con²³ jeu³² a²hlie⁴ hain⁴: ―Cuanh³, ua²lei⁴ i²conh²ˉ³ liah⁴ ra⁵hainh⁴ˉ³. Jon³ a⁴huan⁴ quieh¹ a³cúa²³ cúa³tag³² quian¹i³ hain⁴ lia⁴ o²ra³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","I² jon³ ŋo³⁴ Jesús jauh³² quieh¹ Pe³², i²jon³ a⁴jen³i³ a³don⁵ a¹sie²³i³ ra³tsain²³ jain³² a³ra³tyein⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jon³ a⁴sanh³ Jesús si¹cúa³ a³chieh¹ hain⁴, jian³ a⁴qui³ tyei⁴; i² jon³ a⁴no³ a³don⁵ m⁴ hain⁴, a⁴cúa⁴i³ cúa³tag³² i²con²³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","I² con³ma²a⁴nai³, jon³ ua⁵jan³i³ jeun⁴³ a³quian³ m⁴tyi⁴ hlagh³² i²con²³ hei⁴i³. I² con⁴juah⁴ jau²³ quieh¹ pi²³i³ a⁴húa⁴i³ m⁴tyi⁴ hlagh³², jian³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ la⁴jang³⁴ a³chieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A⁴leg³⁴ la⁴ne³ canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ Isaías, a³sain² hain⁴, con³ma²a⁴juah⁴i³: “Hei⁴ pi²³i³ a⁴qui³⁴ chie² i⁴ma²lang⁴³ˉ¹, jian³ ma²eu⁴³ i⁴ma²le²ˉ¹ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","I² con³ma²a⁴je³⁴ Jesús i⁴tionh² jeun⁴³ chie³ co⁴la⁴lagh⁵, jon³ a⁴júan⁴i³ heih⁴³ i²con²³ chie³ quian¹ i⁴chie³⁴i³ ta⁵hŋoh³ jm³ñei³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","I² jon³ a⁴tyie³⁴ jan³ a²teg²³ quian¹ lai²³ i²con²³i³, a³a⁴juah⁴: ―Hnei³ A²teg²³, hno⁵ˉ⁵ nai³²ˉ⁴ coh⁵cah³²ˉ³ ua²jainh¹ i²tyieh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","I² jon³ a⁴juah⁴ Jesús: ―Sia³pa² i²cm²³ a²hyah³, jian³ sia³pa² sag³² jon⁴³tan²³ liah⁴; i² A³a⁴lang³⁴ Chie³ hain⁴ ne⁵, a⁵sia³ i²li⁴quie⁴³i³ sia³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jon³ a⁴juah⁴ i²jan³ chie³ quian¹i³: ―Hnei³ Se³ño²³, cúa² hnei³ jeu³ ñeih³² ni¹hon⁵ˉ⁵ neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","I² a⁴juah⁴ Jesús ne⁵: ―Nia³ hnei³ coh⁵cah³ˉ⁴, ua²hon³⁴ a³ti²jaun² m⁴tyi⁴ quieh¹ a³jaun² quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jon³ a⁴hei³⁴ Jesús joh⁴³ a²úan⁴³ jian³ a⁴han⁵ chie³ quian¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","I² con³ma²tionh²i³ nei² jm³ñei³, jon³ ja³⁴ con³ tyi⁴ tia⁴ i⁴quian³ jm³ si²ha¹ joh⁴³ a²úan⁴³. I² hei⁴i³ ne⁵, ra³cm² pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jon³ ŋo³⁴ chie³ quian¹i³ ua⁵sie⁴³, juah⁴i³: ―Hnei³ Se³ño²³, ¡lie³² hnei³ jnie³²! ¡Quie¹ ma³o¹tyan⁴³ˉ¹! ");
INSERT INTO cucNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","I² jon³ a⁴juah⁴i³: ―¿E⁴le³⁴ canh⁴³ˉ³ tionh²ˉ³, hnei³ a³sa⁴hain⁴ hlion⁴? I² jon³ ra⁴hang³²i³, a⁴júan⁴i³ heih⁴³ i²con²³ tyi⁴ jian³ jm³ñei³ i⁴jian³⁴; jon³ a⁴nie³⁴ tai³² o³tan². ");
INSERT INTO cucNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","I² chie³ hain⁴ tionh², ta² co³ ŋo³⁴ tsei⁴³i³, a⁴juah⁴i³: ―¿Hain³ chie³ ne³, lainh⁴ˉ³? Quie¹ la⁴teg⁴ tyi⁴ jian³ jm³ñei³ ma³co⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Con³ma²a⁴tyie³⁴ Jesús ta⁵hŋoh³ jm³ñei³, húa³⁴ Gadara, jon³ a⁵han² on³⁴ a³sian³ Gadara jon³ a³a⁴húan³ o³san² a³quian³ m⁴tyi⁴ hlagh³² a³eu⁴³ con³. I² jon³ i²sa⁴li⁴ua⁵jeun³² i¹jan³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A⁴hleh⁴i³ tia⁴ tionh², a⁴juah⁴i³: ―¿Henh⁴ hnoh³ˉ³ i²con²³ jnie³², hnei³ Jesús, A³jon⁴³ Jon⁴dai¹? ¿O⁴ a⁴niah³ˉ³ i²la³ i⁴heh³²ˉ³ jnie³² ma²eu⁴³ pain⁴ naih⁵i² teg³⁴ jm², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jian³ ma²tionh² jeun⁴³ a¹ñi⁴³ i²gm⁴ meih³ a³ti²queuh³. ");
INSERT INTO cucNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","I² jon³ a⁴m⁴ m⁴tyi⁴ hlagh³² i²con²³ Jesús: ―Juah⁴ne³ húah³²ˉ³ jnie³², sai⁴³ hnei³ jnie³² i²con²³ a¹ñi⁴³ jno³ i⁴han⁵ jnie³² naih⁵ ni²tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Cua³. I² jon³ a⁴húan³i³. A⁴han⁵i³ naih⁵ ni²tsei⁴³ a¹ñi⁴³ hain⁴ tionh². I² a¹ñi⁴³ hain⁴ la⁴jang³⁴, a⁴juan³⁴i³ i²ma²tionh²i³ nei² a²hlo³ ñei⁴³ la⁴teg⁴ joh⁴³ jm³ñei³, i²a⁴chian³⁴i³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jon³ a⁴cm⁴ a³ma²hion⁴³ a¹ñi⁴³ hain⁴, jonh³i³ ta⁵je¹jeu³, a⁴tya⁴i³ jau²³ la⁴jeg³⁴ i⁴a⁴leg³⁴ jian³ liah⁴ a⁴jainh⁴³ li⁵uan⁴ a³ma²quian³ m⁴tyi⁴ hlagh³² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","I² jon³ a⁵han² la⁴jang³⁴ a³jeu³ teg⁴ i²sainh⁴³ Jesús; i² con³ma²a⁴je³i³, jon³ a⁴sagh⁴³i³ Jesús i⁴ua⁴hag⁵i³ jeu³ co²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ma²jon³ a⁴hei³⁴ Jesús joh⁴³ a²úan⁴³, a⁴han³i³ jm³, a⁴tyanh³i³ jeu³ co²³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","I² jon³ jian³i³ jan³ a³ñih³ a³lo³ a³ra³hein² joh⁴³ a²hyei²³. I² con³ma²a⁴je³⁴ Jesús conh⁴ tei⁴³ i⁴hain⁴i³ tionh², jon³ a⁴sagh⁴³i³ a³lo³ hain⁴: ―Júan² hnei³ si³hyonh³, jon²³ quian³⁴ˉ⁴; quie¹ ma³a⁴hain³⁴ chie³² quianh³ˉ³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","I² jon³ a⁴júan⁴ co⁴meih³ a²teg²³ quian¹ lai²³ co³hei²tsei³, lain⁴i³: “Hleh² a³ne³ jau²³ i⁴hieh¹ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Quie¹ ñi³ Jesús co³hei²tsei³ i⁴ti²júan³i³ tionh², i² jon³ a⁴sagh⁴³i³ a³hain⁴: ―¿E⁴le³⁴ co³hei²tsei³ hlagh³² ti²júanh³ˉ³ naih⁵ m⁴tyi⁴ quianh³? ");
INSERT INTO cucNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Júan³²ˉ¹, ¿henh⁴a² tyein² sa⁴jeuh⁴³ li⁴hleh¹ˉ⁴ li⁴tei⁴³ la⁴conh⁴a² li⁵teun⁴ la³, lainh⁴ˉ³? ¿O⁴ li⁴juah¹ˉ⁴: “Ma³a⁴hain⁵ˉ⁵ chie³² quianh³ˉ³”, jian³ o⁴: “No³ hnei³, ŋeng²”? ");
INSERT INTO cucNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","I² jon³ ne⁵, canh⁴a² li⁴ñih¹ˉ³ i⁴quian³ A³a⁴lang³⁴ Chie³ hain⁴ heih⁴³ i⁴hain³⁴i³ chie³² quieh¹ chie³ cuah³²húa³⁴ la³, ua²ma²jnia³²ˉ⁴ i⁴la³. Jon³ a⁴sagh⁴³i³ a³lo³ hain⁴: ―No³ hnei³, quien²³ hnei³ a²hyei²³ quianh³, cuanh³ quianh³ jauh³² quianh³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jon³ a⁴no³ a³chieh¹ hain⁴, ŋah³i³ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","I² con³ma²a⁴je³⁴ chie³, ta² co³ ŋo³⁴ tsei⁴³i³ tionh², jon³ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹ a³a⁴cúa⁴ ua³pei⁴ ne³ i²con²³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","I² con³ma²ua⁵hag⁴³ Jesús i²ma²si²sainh⁴³ jon³, jon³ a⁴jen³i³ jan³ a³ñih³ a³sain³ Ma³te³² a³ua²cua⁴³ jauh³² i²can²³i³ hmah¹, i² jon³ a⁴juah⁴i³: ―Nia³ hnei³ coh⁵cah³ˉ⁴. Jon³ a⁴no³ Ma³te³², ŋo³⁴i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","I² jon³ ne⁵, ua²queuh³ Jesús a²hei⁴³ jauh³², i² jon³ a⁴tyie³⁴ jeun⁴³ a³can²³ hmah¹ jian³ a³ren³ chie³² a³ti²queuh³ a²hei⁴³ jian²³ Jesús jian³ chie³ quian¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","I² con³ma²a⁴je³⁴ fariseo i⁴jon³ tionh², jon³ a⁴sagh⁴³i³ chie³ quian¹ Jesús: ―¿E⁴le³⁴ queuh³ A²teg²³ quianh³ˉ³ jian²³ a³can²³ hmah¹ jian³ a³ti²ren³ chie³²? ");
INSERT INTO cucNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","I² con³ma²a⁴nau⁴ Jesús jau²³ jon³, jon³ a⁴juah⁴i³: ―La⁴jang³⁴ a³hei⁴³ tsei⁴³ a⁵sian⁴³ teg³m⁴³ hniah³ quian¹i³, a³chieh¹pa² hniah³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cua³ ua⁴ma⁴tang²³ henh⁴ ra³juah⁴ ra³sag²: “Quie¹ hno⁵ˉ⁵ i⁴li⁴ñeih⁴ hoh⁴³ˉ³, a⁵jon⁴³ i⁴jangh²ˉ³ jah⁴ i²con²³ˉ⁵”, ra³juah⁴. Quie¹ a⁵sia³ cuan⁵ˉ⁵ juah⁴ i⁴ni³teh⁵ˉ⁵ a³ni²taih⁴³ tionh², a³ren³ chie³²pa², canh⁴a² sag³⁴i³ co³hei²tsei³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ma²jon³ a⁴tyie³⁴ chie³ quian¹ Juan³ Tei³² i²con²³i³ a³a⁴ŋang⁴, juah⁴i³: ―¿E⁴le³⁴ júan³ jnie³² he² i⁴sa⁴quih⁴³ jnie³² hlion⁴ nie⁴³, jian³ fariseo liah⁴? I² chie³ quianh³ˉ³ ne⁵, sa⁴júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","I² jon³ a⁴juah⁴ Jesús: ―¿O⁴ li⁴júan³⁴ a³ten² quian¹ a³sanh⁴ chionh⁴ tsei⁴³i³ ta¹la⁴ cua⁴³ a³ñih³ a³sanh⁴ jian²³i³, lainh⁴ˉ³? Quie¹ jia²³ jm² la⁴teg⁴i² te⁴³i³ a³sanh⁴. Ma²jon³ júan³⁴i³ he² tionh² i⁴sa⁴queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Quie¹ i¹jan³ sa⁴tien²³ a²hmh³ don⁵ ca³leuh² a²hmh³ hm²³, quie¹ leuh² hmh³ hm²³ jon³ chieh², jon³ li⁴jeun⁴ a²hmh³ don⁵, jian³ tsei³⁴sa² júah³ i²tseih³² lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jian³ la⁴jon³ liah⁴, i¹jan³ sa⁴ro³ o¹bein² hm³⁴ joh⁴³ a²lo³ don⁵; quie¹ juah⁴ne³ la⁴ne³, jon³ li⁴naih⁵ a²lo³, jon³ tain³⁴ o¹bein² jian³ si⁵hain⁴ a²lo³. I⁴jon³ ro³i³ o¹bein² hm³⁴ joh⁴³ a²lo³ hm²³, canh⁴a² i¹con³ a⁵sia³ i⁴lei⁴ o¹bein² a⁵ga⁴ a²lo³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","I² ta¹la⁴ si²hleh²i³ jon³, jon³ ja³⁴ jan³ chie³ tyein², a⁴si⁴jnei⁵i³ ta⁵nei²i³, a⁴juah⁴i³: ―A³m⁴ jon³⁴ˉ⁴ jeu³ la⁴jaun³⁴. ¿Sa¹ cúah²ˉ³ ua²teih⁴³ˉ³ si¹cúah³ he³²i³, canh⁴a² li⁴jainh¹i³? ");
INSERT INTO cucNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","I² jon³ a⁴no³ Jesús, ŋo³⁴i³ jian²³ a³hain⁴, jian³ ua⁵han² chie³ quian¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","I² jon³ a⁴tyie³⁴ jan³ a³m⁴ coh⁵cah³²i³, a³chieh¹ ma³quia⁵teun⁴ ñi³, a³lang⁴³ ua³pei⁴ quieh¹, a⁴tang⁴i³ he⁴³ a²cúan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Quie¹ ma²juah⁴i³ naih⁵ m⁴tyi⁴ quieh¹: “A⁴leg³⁴ na¹a⁴tang⁴ˉ⁴ a²cúan³ pi²³i³, huan⁴ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","I² Jesús ne⁵, jon³ ua⁵lang⁴i³, a⁴jen³i³ a³m⁴ hain⁴, juah⁴i³: ―Júan² hnei³ si³hyonh³, jon²³ quian³⁴ˉ⁴. Ma³a⁴huan⁴pa² quianh³ˉ³ quie¹ ra⁵hainh⁴ˉ³. I² a³m⁴ hain⁴ a⁴huan⁴ quieh¹i³ lia⁴ o²ra³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","I² con³ma²a⁴hei³⁴ Jesús jauh³² quieh¹ chie³ tyein² hain⁴, i²jon³ a⁴jen³i³ a³ti²jai²³ lau⁴³ jian³ chie³ a³ti²hoh⁵ tia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I² jon³ a⁴juah⁴i³: ―Húan³ hnei³ tionh²ˉ³; quie¹ a⁵sian⁴³ yein³ ra³jaun², ra³cm² pi²³i³. I² jon³ ji⁴ŋang⁴ chie³ hain⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","I² con³ma²a⁴júan⁴ Jesús heih⁴³ i⁴a⁴húan³ a³hain⁴ tionh², i² jon³ a⁴hei³⁴i³ i²ra³quian³ a³maih² hain⁴, a⁴tang⁴i³ si¹cúa³i³, jon³ a⁴no³ a³peih¹ m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jian³ ta² ta⁴tsei¹ jau²³ la⁴tan² húa³⁴ jon³ nei² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","I² con³ma²ua⁵hag⁴³ Jesús i²jon³, jon³ ya¹tyein¹ on³⁴ a³taun³² coh⁵cah³²i³, ti²hleh² tia⁴, juah⁴i³: ―Hnei³ Sa¹jeun³ Da³vei²³, ¡ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnie³²! ");
INSERT INTO cucNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","I² con³ma²a⁴hei³⁴ Jesús jauh³², jon³ a⁴tyie³⁴ a³taun³² hain⁴ i²con²³i³, i² jon³ a⁴ŋang⁴ Jesús i²con²³i³: ―¿O⁴ hainh⁴ˉ³ cagh³²ˉ⁴ jm² júan³²ˉ⁴ i⁴ne³, lainh⁴ˉ³? Jon³ a⁴juah⁴i³ tionh²: ―Jen³⁴, Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","I² jon³ a⁴tei³⁴ Jesús si¹cúa³ m⁴nei²i³ tionh², a⁴juah⁴i³: ―Ua²lei⁴ i²conh²ˉ³ liah⁴i² hainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I² jon³ a⁴jnia⁵ m⁴nei²i³ tionh². Jian³ a⁴júan⁴ Jesús heih⁴³ pain⁴ i²con²³i³, juah⁴i³: ―Yo⁴ua²li⁴ñi³ i¹jan³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","I² con³ma²a⁴húan³i³ tionh², a⁴ta⁴tsei³i³ jau²³ nei² quieh¹ Jesús la⁴tan² húa³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","I² con³ma²ti²húan⁵i³ jauh³², i² jon³ jian³i³ jan³ a³sa⁴hleh² a³quian³ m⁴tyi⁴ hlagh³², jian³i³ i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","I² con³ma²ua⁵hag⁴³ m⁴tyi⁴ hlagh³², jon³ ma⁴lie⁵i³ hleh²i³. Ta² co³ ŋo³⁴ tsei⁴³ chie³ tionh², a⁴juah⁴i³: ―I¹conh⁴ sa⁴ma³a⁴niah³²ˉ¹ la⁴ne³ jen² sa¹jeun³ Israel. ");
INSERT INTO cucNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","I² a⁴juah⁴ fariseo tionh² ne⁵: ―Con⁴juah⁴ ua³pei⁴ quieh¹ jeu³² m⁴tyi⁴ hlagh³² húa³ a³ne³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","I² jon³ ne⁵, ŋeng²³ Jesús la⁴jeg³⁴ si³da²³ jian³ la⁴jeg³⁴ jeu³ peih¹, he²³i³ jau²³ quieh¹ Jon⁴dai¹ cuah³ judío, jian³ hleh²i³ jau²³ tsei²³ liah⁴ han⁵ chie³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵, jian³ júan³i³ i⁴huan⁴ quieh¹ la⁴jang³⁴ a³jeu³ a³ti²lang⁴³ chie² la⁴jeg³⁴ nai² jian³ a³ti²can²³ ma²eu⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","I² con³ma²a⁴jen³i³ chie³ jeun⁴³ hain⁴, jon³ joh³ ñei⁴ tsei⁴³i³ i²con²³ a³hain⁴ tionh², quie¹ tionh²i³ i⁴sian³i³ co³hei²tsei³, a³ra³jan⁴ liah⁴i² lang⁴³ a⁵a³siah³ a³sa⁴sian³ jeu³². ");
INSERT INTO cucNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jon³ a⁴sagh⁴³i³ chie³ quian¹: ―I⁴chie⁴³pa² juah³ˉ⁴, ta² hlion⁴ i⁴jnia² je¹, a³júan³ ta¹pa² co⁴meih³ leg⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","I⁴jon³ hniah³ mh³²ˉ³ A³don⁵ quieh¹ je¹ i⁴sain³⁴i³ mozo quian¹ i⁴si⁵queun³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","I² jon³ a⁴teh³i³ quia⁵teun⁴ chie³ quian¹. A⁴cúah³i³ heih⁴³ i⁴húa³⁴i³ m⁴tyi⁴ hlagh³² jian³ i⁴júan³⁴i³ i⁴huan⁴ quieh¹ a³ti²lang⁴³ chie² la⁴jeg³⁴ nai² jian³ a³ti²can²³ ma²eu⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jian³ i⁴la³ jm³i⁴sain³ a³quia⁵teun⁴ hain⁴ a³a⁴quian³i³ ta¹ quieh¹: co⁴ra⁴lie⁵ Si²úan¹ a³teh²i³ Pe³², jian³ Dre¹ reunh¹i³; Jacobo a³jon⁴³ Zebedeo, jian³ Juan²³ reunh¹i³; ");
INSERT INTO cucNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Lei³² jian³ Bartolomé; To³ma²³ jian³ Ma³te³² a³can²³ hmah¹; Jacobo a³jon⁴³ Alfeo, jian³ Lebeo a³ni²tsei¹ jm³i⁴sain³ Tadeo; ");
INSERT INTO cucNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Si²úan¹ a³ma²hein² jo³² cananista; jian³ Judas Iscariote, a³hain⁴ a³a⁴cúanh³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A³quia⁵teun⁴ ne³ a⁴sain⁴ Jesús, con³ma²a⁴ron⁴³i³ jau²³ co³re³, juah⁴i³: ―Sa⁴hniah³ cúah²ˉ³ i²tionh² a³sa⁴lang⁴³ judío, jian³ a⁵ga⁴ jeu³ co²³ chie³ samaritano; ");
INSERT INTO cucNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","quie¹ hniah³ cúah²ˉ³ i²con²³ jmah³ sa¹jeun³ Israel a³ti²lang⁴³ a⁵a³siah³ a³ŋeng²³ conh²pa². ");
INSERT INTO cucNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cua³ hnei³ ya⁴hleh²ˉ³, juah²ˉ³: “Ma³ja²³ jm² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵.” ");
INSERT INTO cucNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Júan² hnei³ i⁴huan⁴ quieh¹ a³chieh¹ jian³ a³ti²lang⁴³ chie² jyih² o¹ŋeu⁴³ quieh¹, jian³ júan² hnei³ i⁴jainh¹ a³jaun² liah⁴, húa² hnei³ m⁴tyi⁴ hlagh³². Quie¹ ta² a⁴hyanh³pa² hnei³ tionh²ˉ³ ua³pei⁴ la³; a⁵can³ hnei³ hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’A⁵can³ hnei³ o¹cau³²nie¹, a⁵ga⁴ o¹cau³² tie³, a⁵ga⁴ a²ñi²³ yein⁴ joh⁴³ to³lo³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jian³ sa⁴canh²ˉ³ a²mo³ra² ho³²jeu³, jian³ sa⁴canh²ˉ³ a²cúanh³, conh⁴ heinh² ne³pa² hnei³, jian³ sa⁴hniah³ canh²ˉ³ a²lo³ tsei²³ tagh¹ˉ³ liah⁴ a⁵ga⁴ a²hma³heu¹; quie¹ haih¹ guenh⁴³i³ a³júan³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’I² tei⁴³i² a⁴heuh³ˉ³ con³ si³da²³ jian³ o⁴ con³ jeu³ peih¹, hniah³ ŋangh²ˉ³ jainh¹ cua⁴³ jan³ chie³ tsein²³. Jian² hnei³ jauh³² quieh¹ a³hain⁴ la⁴conh⁴i² a⁴jauh²ˉ³ jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","I² tei⁴³i² heuh¹ˉ³ jauh³², cúan³²i³ hnei³ dai¹ i⁴tionh²i³ hyon³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","I² juah⁴ne³ tsein³⁴ a³tionh² jauh³² jon³, jon³ li⁴tei⁴³ jau²³ i⁴tionh²i³ hyon³ tsei⁴³i³. I² juah⁴ne³ sa⁴tsein³⁴i³ tionh², jon³ sa⁴li⁴tei⁴³ jau²³ quianh³ˉ³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","I² juah⁴ne³ sa⁴a⁴hyei⁴³i³ hnei³ jian³ a⁵ga⁴ a⁴nau⁴i³ jau²³ quianh³ˉ³, jon³ jau²³ hnei³ jauh³² jon³ jian³ o⁴ jeu³ jon³, jian³ poh⁴³ hnei³ o¹hlie³ ti²quin⁴³ si¹tagh¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴teg⁴i² ma³a⁴teg⁴ jm² queih³ Jon⁴dai¹ heih⁴³ i²con²³ chie³, pain⁴ ma²eu⁴³ hyieh⁴ a³tionh² jeu³ jon³ la⁴conh⁴a² a³ma²tionh² jeu³ Sodoma jian³ Gomorra. ");
INSERT INTO cucNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Jeh³²! Sain¹ˉ⁴ hnei³ la⁴jan³ a⁵a³siah³ tionh²ˉ³ jen² a¹tsai³nau²³. I⁴jon³ júan² hnei³ nei²³ hoh⁴³ˉ³ la⁴jan³ a⁵mh³, jian³ júan² hnei³ i⁴huanh³²ˉ³ la⁴jan³ a⁵ta³cuah³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jianh³ˉ³ júan² hnei³ quie¹ cúah⁴³i³ hnei³ joh⁴³ cúa³ si³ta¹, jian³ po³⁴i³ hnei³ cuah³ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Jian³ si⁵jo⁴i³ hnei³ ta⁵nei² si²mah⁴ tyein² tionh² jian³ ta⁵nei² re¹ nei² quien⁴ˉ⁴. I² la⁴ne³ li⁴hleh² hnei³ i²con²³i³ nei² quien⁴ˉ⁴ jian³ i²con²³ a³sa⁴lang⁴³ judío tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","I² tei⁴³i² cúah⁴³i³ hnei³, sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ henh⁴ jau²³ jainh²ˉ³ i²con²³i³ jian³ o⁴ henh⁴ hleh²ˉ³; quie¹ o²ra³ jon³ jia²³ jau²³ liah⁴ hniah³ hleh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Quie¹ a⁵hei⁴³ hnei³ hleh²ˉ³, M⁴tyi⁴ quieh¹ Naih⁴³ˉ³pa² hleh³ con⁴juah⁴ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Quie¹ cúanh⁴³ chie³ a³reunh¹ i⁴jŋangh³i³, jian³ cúanh⁴³ ca³chion²³ si³jon⁴³; jian³ ca³chion²³ li⁴hion²³ jmai³sie²³ i⁴cúanh⁴³i³ i⁴jŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jian³ la⁴jang³⁴pa² li⁴hie²³ hnei³ tionh²ˉ³ nei² quien⁴ˉ⁴; i² a³hain⁴ a³tieh¹ liah⁴i² a⁴toh⁴, a³ne³pa² lion⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","I² tei⁴³i² hag²³i³ hnei³ con³ jeu³, cm² hnei³ la⁴teg⁴ i²con³. I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, naih⁵i² cúah²ˉ³ la⁴jeg³⁴ jeu³ i²tionh² chie³ Israel, jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’I¹jan³ a³ma³tang²³ sa⁴júanh⁴³ la⁴conh⁴a² a²teg²³ jeu³², a⁵ga⁴ júanh⁴³ a³cúa²³ cúa³tag³² la⁴conh⁴a² jeu³². ");
INSERT INTO cucNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Quie¹ hniah³ hyein⁴³ a³ma³tang²³ i⁴júanh¹ chie³ quieh¹i³ la⁴jon³ liah⁴i² júanh¹i³ jeu³²i³. Jian³ la⁴jon³ a³cúa²³ cúa³tag³² hniah³ hyein⁴³ i⁴júanh¹ chie³ quieh¹i³ liah⁴i² júanh¹i³ jeu³²i³. Quie¹ juah⁴ne³ teh²i³ a³don⁵ quieh¹ jauh³² a⁵lainh³² Beelzebú, ¿conh⁴a² sa⁴teh³i³ a³tionh² jauh³², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’I² la⁴ne³ ne⁵, sa⁴hniah³ canh⁴³ˉ³ chie³. Quie¹ i¹con³ i⁴ni²jleg³ sa⁴sia³ juah⁴ i⁴sa⁴jñeih³. Jian³ i¹con³ i⁴ni²hma² sa⁴sia³ juah⁴ i⁴sa⁴li⁴ñi³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","I² la⁴jon³ la⁴jeg³⁴ i⁴hleh³ jnia⁴ ta⁵i²nai³, hniah³ hleh² hnei³ ta⁵i²joh¹; la⁴jeg³⁴ i⁴jeu³⁴ˉ⁴ hnei³ ta⁵si²hma², hniah³ hleh²ˉ³ i⁴si²tyeinh¹ˉ³ yeih³². ");
INSERT INTO cucNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A⁵júan³ hnei³ canh⁴³ a³jŋangh² heh³²ˉ³, quie¹ sa⁴li⁴jŋangh³i³ m⁴tyi⁴ quianh³ˉ³; eu⁴³a² re³ hniah³ júanh²ˉ³ canh⁴³ a³li⁴jeun³⁴ m⁴tyi⁴ quianh³ˉ³ jian³ li⁴tonh³i³ heh³²ˉ³ qui⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿O⁴ sa¹ chie⁴³ hnang⁴³i³ on³⁴ jon⁴³tan²³ peih¹ conh⁴ con³ ñi²hña⁴, liah²? Ua²liah⁴a² leg⁴³ la⁴ne³, i¹jan³ sa⁴li⁴tianh⁵ juah⁴ne³ sa⁴cúa²³ Jon⁴dai¹ jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Quie¹ la⁴teg⁴ hmh⁴jñi³ tyih³ˉ³ ni²hei²³ la⁴jeg³⁴ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","I² la⁴ne³ jon³ a⁵júan³ hnei³ canh⁴³; quie¹ eu⁴³a² hlion⁴ queinh⁴³ˉ³ tionh²ˉ³ la⁴conh⁴a² jeun⁴³ jon⁴³tan²³ peih¹. ");
INSERT INTO cucNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Jian³ la⁴jang³⁴ a³hleh² i⁴lang⁴³ chie³ quian³⁴ˉ⁴ ta⁵nei² chie³, jon³ hleh¹ jnia⁴ liah⁴ i⁴lang⁴³i³ a³quian³⁴ˉ⁴ ta⁵nei² Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jian³ la⁴jang³⁴ a³hleh² i⁴sa⁴lang⁴³ chie³ quian³⁴ˉ⁴ ta⁵nei² chie³, jon³ hleh¹ jnia⁴ liah⁴ i⁴sa⁴lang⁴³i³ a³quian³⁴ˉ⁴ ta⁵nei² Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’¿O⁴ cuan⁵ˉ⁵ i⁴júan³²ˉ⁴ i⁴cua³⁴ chie³ tai³² cuah³²húa³⁴ la³, lainh⁴ˉ³ tionh²ˉ³? A⁵sia³ cuan⁵ˉ⁵ la⁴ne³, quie¹ i⁴han⁵ chie³ ma⁵quein²³ co³hei²tsei³pa². ");
INSERT INTO cucNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Quie¹ cuan⁵ˉ⁵ i⁴ua⁵júan³⁴ˉ⁴ i⁴han⁵ chie³ ma⁵quein²³ jo³² a³ñih³ jian²³ jmai³ jian³ a³m⁴ jian²³ sie²³, jian³ a³lo²³i³ jian²³ a³don⁵ a¹sie²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","I² a³li⁴hie²³ quieh¹ chie³ tionh² ne⁵, a³tionh² jauh³² quieh¹ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’I² a³hain⁴ a³hnio³⁴ jmai³sie²³ la⁴conh⁴a² jnia⁴, sa⁴haih¹ li⁴lain⁴i³ chie³ quian³⁴ˉ⁴; conh⁴liah⁴ a³hain⁴ a³hnio³⁴ a³ñih³ jon⁴³ jian³ o⁴ a³m⁴ jon⁴³ la⁴conh⁴a² jnia⁴, sa⁴haih¹ li⁴lain⁴i³ chie³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jian³ a³sa⁴i²can³⁴ ma²eu⁴³ i⁴si⁴tyein⁵i³ coh⁵cah³ˉ⁴, sa⁴haih¹ li⁴lain⁴i³ chie³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A³hain⁴ a³hnie³⁴ lion⁴ m⁵cu³ quieh¹ nei² cuah³²húa³⁴ la³, jon³ si⁵hain⁴ pi²³i³; i² a³si³hain⁴ m⁵cu³ quieh¹ nei² quien⁴ˉ⁴, hyieh⁴i³ m⁵cu³ quieh¹ i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’A³hain⁴ a³hyei⁴³ hnei³ tionh²ˉ³, jnia⁴pa² hyei⁴³i³; jian³ a³hain⁴ a³hyei⁴³ jnia⁴, hyein⁴³i³ a³a⁴sai⁴ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jian³ a³hain⁴ a³hyein⁴³ jan³ a³sain² quie¹ ta⁵la⁴ lang⁴³i³ jan³ a³sain² quian¹ Jon⁴dai¹, hyieh⁴i³ hmah¹ liah⁴i² hyei³⁴ a³sain²; jian³ a³hain⁴ a³hyein⁴³ jan³ a³ni²taih⁴³ quie¹ ta⁵la⁴ lang⁴³i³ jan³ a³ni²taih⁴³, hyieh⁴i³ hmah¹ quieh¹ liah⁴i² hyieh⁴ jan³ a³ni²taih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jian³ a³hain⁴ a³cúa³⁴ con³ a²va²so³ o¹jm³cuh⁵ i²con²³ jan³ a³peih¹ la⁴la³, nei² quieh¹ i⁴lang⁴³i³ chie³ quian³⁴ˉ⁴, i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, hyieh⁴i³ hmah¹ quieh¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","I² con³ma²a⁴toh⁴ i⁴a⁴ron⁴³ Jesús jau²³ a³quia⁵teun⁴ chie³ quian¹, jon³ ŋo³⁴i³ ua⁵he³i³ jian³ ua⁵hleh³i³ jau²³ la⁴jeg³⁴ jeu³ i²tei⁴³ húa³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","I² con³ma²ra⁵ñi³ Juan²³ a³hein² ni⁴ñi²³ la⁴conh⁴ i⁴júan³ Cristo, jon³ a⁴sain⁴i³ on³⁴ chie³ quian¹ i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","a³ua⁵ŋang⁴: ―¿O⁴ hnei³ a³ma²jia²³, jian³ o⁴ hniah³ jian³² jnie³² a³sang²³? ");
INSERT INTO cucNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","I² jon³ a⁴ŋangh³ Jesús, juah⁴i³: ―Cua³ ua⁴saih³² hnei³ Juan²³ la⁴jeg³⁴ i⁴ti²jeh⁴ˉ³ jian³ i⁴ti²nauh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Saih³²i³ hnei³ i⁴jnia⁵ m⁴nei² a³taun³² jian³ i⁴ŋeng²³ a³ma²tein⁴, jian³ i⁴huan⁴ quieh¹ a³ti²lang⁴³ chie² i⁴jyih² o¹ŋeu⁴³, jian³ i⁴li⁴naih¹ a³teun³, jian³ jainh¹ a³ma²jaun², jian³ i⁴si³hleh² jau²³ quieh¹ Jon⁴dai¹ i²con²³ a³ti⁴ñei³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jian³ ta² tsei³⁴ jm² li⁴ren³ a³sa⁴hieh¹ jau²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","I² con³ma²ŋah³ a³hain⁴ tionh², jon³ ma⁴lie⁵ Jesús hleh² nei² quieh¹ Juan²³ i²con²³ chie³ tionh², juah⁴i³: ―¿Henh⁴ ni²jeh¹ˉ³ tionh²ˉ³ i²a⁵sian⁴³ a³sian³ jon³? ¿O⁴ con³ a²ma³cu⁴³ si²can⁵ tyi⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Jian³ o⁴ ¿henh⁴ ni²jeh¹ˉ³ i²jon³? ¿O⁴ ni²jenh³²ˉ³ jan³ a³ñih³ a³hein² a²hmh³ jlanh²? Quie¹ a³tionh² a²hmh³ jlanh², tionh² jauh³² quieh¹ re¹pa². ");
INSERT INTO cucNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","I² jon³ ne⁵, ¿henh⁴ ni²jeh¹ˉ³ i²jon³? ¿O⁴ jan³ a³sain² quian¹ Jon⁴dai¹, lainh⁴ˉ³? I⁴chie⁴³pa², quie¹ lang⁴³i³ jian³ eu⁴³ pi¹ júanh⁴³i³ la⁴conh⁴a² a³sain². ");
INSERT INTO cucNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Quie¹ lang⁴³ hei⁴i³ a³ra³sag² Ma²jyi³ quieh¹ Jon⁴dai¹ nei² quieh¹, ra³juah⁴: Jeh³², sain¹ˉ⁴ a³sain² quian³⁴ ta⁵mah²ˉ³, a³hain⁴ a³júanh³ jeu³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, júanh⁴³ Juan³ Tei³² la⁴conh⁴a² la⁴jang³⁴ a³ma³ra⁵sian³. I² a³hain⁴ a³peih¹ jen² a³tionh² naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵, júanh⁴³i³ la⁴conh⁴a² Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’I² jon³ ne⁵, liah⁴ma²ja³⁴ Juan²³ la⁴teg⁴ tieh²la³ jeun⁴³ a³hnie³⁴ han⁵ cúah²i³ pei⁴ ta⁵li⁴hnai³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵, jian³ a³cúah² pei⁴ hain⁴pa² cagh¹ jm². ");
INSERT INTO cucNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Quie¹ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ jian³ lai²³ quieh¹ M³se²³ a⁴ta⁴ron³² i⁴ua⁵hleh² nei² quieh¹ heih⁴³ jon³ la⁴teg⁴ jm² i⁴cuan³⁴ Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jian³ juah⁴ne³ hyeinh³²i³ hnei³, hei⁴ pi²³i³ lang⁴³ I³lie²³ a³ma²hniah³ jia²³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","A³hain⁴ a³ho³ ta³ra³cua¹ hniah³ nau³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’I² jon³ ne⁵, ¿liah⁴a² li⁴juah¹ˉ⁴ liah⁴ lang⁴³ chie³ a³sian³ tieh²la³, lainh⁴ˉ³? Quie¹ lang⁴³i³ liah⁴i² lang⁴³ si³maih² a³tionh² je¹hmah¹ a³ti²hlenh⁴³ jon²reunh¹, ti²hleh²i³ tia⁴: ");
INSERT INTO cucNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Jeh³², a⁴jai³² jnie³² a²lau⁴³ i²conh²ˉ³, i² a⁵sia³ jan¹ ñeih²ˉ³ tionh²ˉ³; jian³ a⁴he² jnie³² seun²³ quieh¹ a³jaun², jian³ a⁵sia³ a⁴hoh³²ˉ³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Quie¹ cuan³⁴ Juan²³ i⁴sa⁴queuh³i³ a⁵ga⁴ hangh²i³, i² juah⁴ˉ³ tionh²ˉ³: “A³quian³ m⁴tyi⁴ hlagh³².” ");
INSERT INTO cucNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jon³ cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ a³queuh³ a³hangh², i² juah⁴ˉ³ tionh²ˉ³ ne⁵: “Lang⁴³ a³ñih³ ne³ a³jlen⁴ a³hangh² jm³, jian³ a³ñi³reunh¹ a³ren³ chie³² jian³ a³can²³ hmah¹.” Quie¹ lei³ jnia⁴ i⁴ŋang⁴ Jon⁴dai¹ con⁴juah⁴ i⁴ma³jnia³ si³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma²jon³ ma⁴lie⁵ Jesús a⁴jain³⁴i³ a³tionh² jeu³ i²a⁴júan⁴i³ hlion⁴ ua³júah², quie¹ sa⁴ma³a⁴sag²³ a³hain⁴ tionh² co³hei²tsei³ quieh¹, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ti⁴³ jeuh² hnei³ a³tionh² jeu³ Corazín! ¡Ti⁴³ jeuh² hnei³ a³tionh² jeu³ Betsaida! Quie¹ juah⁴ne³ ma²a⁴leg³⁴ ua³júah² la⁴ne³ jeu³ Tiro jian³ jeu³ Sidón liah⁴i² a⁴leg³⁴ i²conh²ˉ³, ma³jon⁵ne³⁴pa² ma²a⁴sag²³ a³hain⁴ tionh² co³hei²tsei³ quieh¹, i⁴ma³a⁴hei³⁴i³ a²hmh³ quieh¹ a³chionh⁴ tsei⁴³i³, jian³ i⁴ma³a⁴sie⁴i³ o¹jua³ ma³tyi². ");
INSERT INTO cucNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","I² jon³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, jm² i⁴queih³ Jon⁴dai¹ heih⁴³ i²con²³ m⁵cu³, hyanh⁴ˉ³ pain⁴ ma²eu⁴³ tionh²ˉ³ la⁴conh⁴a² jeu³ Tiro jian³ jeu³ Sidón. ");
INSERT INTO cucNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jian³ hnei³, jeu³ Capernaum, ¿o⁴ euh²ˉ³ ta⁵ñi⁴jeu⁵, lainh⁴ˉ³? Ta⁵jeuh³pa² cúah²ˉ³, la⁴teg⁴ I²tionh² A³jaun². Quie¹ juah⁴ne³ ma²a⁴leg³⁴ ua³júah² la⁴ne³ jeu³ Sodoma liah⁴i² a⁴leg³⁴ i²conh²ˉ³, ma²nie⁴³pa² jeu³ jon³ la⁴teg⁴ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","I² jon³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, jm² i⁴queih³ Jon⁴dai¹ heih⁴³ i²con²³ m⁵cu³, hyanh⁴ˉ³ pain⁴ ma²eu⁴³ la⁴conh⁴a² a³ma²tionh² húa³⁴ Sodoma. ");
INSERT INTO cucNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","I² o²ra³ jon³ a⁴hleh⁴ Jesús, juah⁴i³: ―Júan³⁴ˉ⁴ i⁴júanh⁴³ˉ³, hnei³ Neih³ˉ⁴, Se³ño²³ quian¹ ñi⁴jeu⁵ jian³ cuah³²húa³⁴ la³, quie¹ ma³ma⁴jniah³²ˉ³ la⁴jeg³⁴ i⁴ne³ nei² quien⁴ˉ⁴ i²con²³ chie³ peih¹, jian³ a⁴hmah²ˉ³ i²con²³ a³tang³ hlion⁴ jian³ a³ŋang⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","I⁴chie⁴³, hnei³ Neih³ˉ⁴, quie¹ la⁴ne³ ra⁵hnoh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Jian³ ma³a⁴tonh³ Neih³ˉ⁴ joh⁴³ cúa³⁴ˉ⁴ la⁴jeg³⁴. I⁴jon³ i¹jan³ sa⁴cm²³ A³jon⁴³ Jon⁴dai¹, jan³ Jon⁴dai¹ Jmai³pa² cu²³; jian³ i¹jan³ sa⁴cm²³ Jmai³i³, jan³ A³jon⁴³ pi²³i³ cu²³, jian³ a³hain⁴pa² cu²³ a³hnie³⁴ A³jon⁴³i³ ma⁵jnia³²i³ Jmai³i³ i²con²³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nia³ hnei³ i²con²³ jnia⁴ tionh²ˉ³ la⁴jangh³ˉ³ a³ma³a⁴húah⁴³ hoh⁴³ˉ³ ta¹ i⁴júanh³ˉ³ jian³ lie²³ i⁴quianh²ˉ³, jon³ júan³²ˉ⁴ i⁴neih²ˉ³ tai³². ");
INSERT INTO cucNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Quian³ hnei³ a²hma³ yugo quien⁴ˉ⁴ tionh²ˉ³, jian³ ma⁴tang²³ hnei³ liah⁴ lang⁴³ˉ⁴, quie¹ lang⁴³ jnia⁴ jan³ a³huan³² jian³ a³ti⁴ñeih⁵ m⁴tyi⁴ quieh¹; jon³ li⁴nie³⁴ tai³² m⁴tyi⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Quie¹ sa⁴jeuh⁴³ li⁴can³⁴i³ a²hma³ yugo quien⁴ˉ⁴, jian³ panh⁴pa² lie²³ quien⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jm² jon³ hein² Jesús jeu³ je¹ i²ti²jnia² o¹m⁴ trigo con³ jm² sa⁴júan³i³ ta¹. Jon³ ra⁵cúanh⁴³ chie³ quian¹i³ tionh². Ma²jon³ a⁴queun⁴i³ o¹m⁴ trigo, a⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","I² con³ma²a⁴je³⁴ fariseo tionh², jon³ a⁴sagh⁴³i³ Jesús: ―Jeh³², ti²júan³ chie³ quianh³ˉ³ i⁴sa⁴haih¹ li⁴júan³⁴i³, jm² ne³⁴, jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","I² a⁴juah⁴ Jesús i²con²³i³: ―¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ liah⁴ a⁴júan⁴ re¹ Da³vei²³ con³ma²ra⁵cúanh⁴³i³ tionh² jian²³i³ a³ma²jian²³i³? ");
INSERT INTO cucNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Quie¹ a⁴hei³⁴i³ jauh³² quieh¹ Jon⁴dai¹, a⁴queuh³i³ a²hei⁴³ñih¹ hen² i⁴sa⁴ra³cúa²³ i⁴queuh⁴³ Da³vei²³, a⁵ga⁴ a³ma²jian²³i³ liah⁴, quie¹ jmah³ m³chie³pa² tain⁴³ queuh³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Jian³ o⁴ a⁵sia³ ma³a⁴heih³ˉ³ lai²³ quieh¹ M³se²³ i⁴júan³ m³chie³ ta¹ quieh¹ tionh² cuah³júah² jm² sa⁴júan³i³ ta¹, jian³ a⁵jon⁴³ chie³²? ");
INSERT INTO cucNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ i⁴sainh⁴³ jan³ i²la³ a³júanh⁴³ a⁵jon⁴³ liah⁴ cuah³júah². ");
INSERT INTO cucNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Quie¹ ra³juah⁴ ra³sag²: “Quie¹ hno⁵ˉ⁵ i⁴li⁴ñeih⁴ hoh⁴³ˉ³, a⁵jon⁴³ i⁴jangh¹ˉ³ jah⁴ i²con²³ˉ⁵.” Quie¹ juah⁴ne³ ma²ra⁵ñih¹ˉ³ henh⁴ hnie³⁴ ra³juah⁴ jau²³ ne³, a⁵sia³ ma²si²henh³²ˉ³ a³sa⁴ren³ chie³² tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Quie¹ A³a⁴lang³⁴ Chie³ hain⁴ lang⁴³ a³júan³ heih⁴³ liah⁴ ra³cúa²³ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jon³ ŋo³⁴ Jesús, a⁴tyie³⁴i³ con³ cuah³ judío. ");
INSERT INTO cucNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","I²jon³ ua²cua⁴³ jan³ a³ñih³ a³lo³ ca³jo³² si¹cúa³; jian³ quie¹ hnie³⁴i³ tionh² liah⁴ li⁴hnang⁵i³ Jesús, jon³ a⁴ŋang⁴i³ i²con²³, a⁴juah⁴i³: ―¿O⁴ ra³cúa²³ júan³⁴i³ i⁴huan⁴ quieh¹ a³chieh¹ jm² sa⁴júan³i³ ta¹? ");
INSERT INTO cucNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―¿Hain³ hnei³ tionh²ˉ³ a³sainh⁴³ jan³ a⁵a³siah³ quian¹ juah⁴ne³ a⁴tanh⁴ jah⁴ joh⁴³ to³ con³ jm² sa⁴júan³i³ ta¹, o⁴ sia³ si⁵te¹i³ si⁵tyein³i³? ");
INSERT INTO cucNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","I² jon³ ne⁵, ¡la⁴conh⁴a² sa⁴quein⁴³ jan³ chie³ la⁴conh⁴a² a⁵a³siah³! I⁴jon³ ra³cúa²³ i⁴júan³⁴i³ i⁴tsei³⁴, jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jon³ a⁴sagh⁴³i³ a³ñih³ hain⁴: ―Sieh¹ si¹cúah³. I² con³ma²a⁴sieh³i³ si¹cúa³, jon³ a⁴huan⁴ quieh¹i³, a⁴lag³⁴ liah⁴i² leg⁴³ ta⁵ca³jo³². ");
INSERT INTO cucNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma²jon³ a⁴húan³ fariseo tionh², a⁴júan⁴i³ re³ liah⁴ li⁴jŋangh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","I² con³ma²ra⁵ñi³ Jesús nei² jon³, jon³ ua⁵hag⁴³i³ i²jon³, jian³ ta² jeun⁴³ chie³ ua⁵han² coh⁵cah³²i³. Jian³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ la⁴jang³⁴ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jian³ a⁴júan⁴i³ heih⁴³ i⁴sa⁴tya³⁴i³ jau²³ i²con²³ chie³ nei² quieh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ Isaías, a³sain² hain⁴, con³ma²a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","A³la³pa² a³cúa²³ cúa³tag³² i²con²³ jnia⁴, a³a⁴hnah³²ˉ⁴. Hei⁴ pi²³i³ hno⁵ˉ⁵, jian³ júan³⁴i³ i⁴teg³ tsei⁴³ m⁴tyi⁴ quien⁴ˉ⁴. Jian³ cúa¹ˉ⁴ M⁴tyi⁴ quien⁴ i²con²³i³, jian³ hleh³i³ jau²³ quien⁴ˉ⁴ i²con²³ a³sa⁴lang⁴³ judío tionh² liah⁴ hniah³ ma⁴tei⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jian³ sa⁴jang⁴³i³, a⁵ga⁴ hleh³i³ tia⁴. Jian³ sa⁴naih⁵ i⁴hleh²i³ jeu³júan²³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jian³ ma⁵hon³²i³ a³sa⁴huanh³ a³lang⁴³ liah⁴i² leg⁴³ a²ma³cu⁴³ i⁴ni²jeunh³, jian³ ma⁵hon³²i³ chie³ a³jeu²³ a³lang⁴³ liah⁴i² leg⁴³ o¹me²cha³ i⁴ma³o¹ai³⁴; júan³⁴i³ la⁴ne³ la⁴conh⁴i² cagh¹i³ jm² i⁴ma⁴tei⁵ chie³ heih⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jian³ li⁴hain³² tsei⁴³ a³tionh² la⁴jeg³⁴ nación i²con²³ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jon³ jian³i³ i²con²³ Jesús jan³ a³ñih³ a³quian³ m⁴tyi⁴ hlagh³², a³taun³² jian³ a³con². I² jon³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹i³. I² la⁴ne³ a⁴je³⁴ a³ma²taun³² jian³ i⁴con² hain⁴ a⁴hleh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ta² co³ ŋo³⁴ tsei⁴³ la⁴jang³⁴ chie³ tionh², jian³ a⁴juah⁴i³: ―¿A¹hei⁴ a³ne³ lang⁴³ Sa¹jeun³ Da³vei²³ a³ma²jia²³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","I² con³ma²a⁴nau⁴ fariseo jau²³ jon³ tionh², jon³ a⁴juah⁴i³: ―Con⁴juah⁴ ua³pei⁴ quieh¹ Beelzebú, jeu³² m⁴tyi⁴ hlagh³²pa², húa³ a³ne³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jian³ si²ñi³ Jesús co³hei²tsei³ i⁴ti²júan³i³ tionh², jon³ a⁴sagh⁴³i³ a³hain⁴: ―La⁴jeg³⁴ nación i²si³tang⁴ chie³ i⁴tionh²i³ ma⁵quein²³ jo³², tyan⁴³i³; jian³ la⁴jeg³⁴ jeu³ jian³ o⁴ jauh³² i²si³tang⁴i³ sa⁴li⁴úan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jian³ la⁴ne³ juah⁴ne³ tyein³ a⁵lainh³² a³jian²³ tionh², la⁴can³ húan⁴ pi²³i³ si³tang⁴ tionh². I⁴jon³ si⁴li⁴úan⁴ heih⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Quie¹ juah⁴ne³ i⁴chie⁴³ húa³⁴ˉ⁴ m⁴tyi⁴ hlagh³² con⁴juah⁴ ua³pei⁴ quieh¹ a³sa⁴tsein³⁴, i² chie³ quianh³ˉ³ ne⁵, ¿hain³ con⁴juah⁴ ua³pei⁴ quieh¹ húa³i³ tionh²? I² la⁴jon³ hei⁴ pi²³i³ ma³jnia³ i⁴sa⁴re³ co³hei²tsei³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","I² juah⁴ne³ húa³⁴ˉ⁴ m⁴tyi⁴ hlagh³² con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, lei³ jnia⁴ la⁴ne³ i⁴ma³a⁴tyie³⁴ jm² i⁴hanh⁵ˉ³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Júan³²ˉ¹ ne⁵, ¿liah⁴ cúan²³ li⁴hei⁴ jan³ chie³ jauh³² quieh¹ jan³ a³huanh⁴³ i⁴con⁴³i³ la⁴jeg³⁴ i⁴quieh¹, juah⁴ne³ sa⁴hñi³⁴i³ ñeih³²jia⁴³? Jon³ a²ma⁴ li⁴húa³⁴i³ la⁴conh⁴ i⁴tieh³² jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’I² jon³ ne⁵, a³hain⁴ a³sa⁴quein⁴³ tsei⁴³ jian²³ˉ⁵, a³hain⁴pa² hie²³ jnia⁴; jian³ a³hain⁴ a³sa⁴jaih² chie³ i²con²³ˉ⁵, júan³i³ i⁴so³jenh² chie³ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’I⁴jon³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i⁴li⁴jlenh⁴³pa² la⁴jeg³⁴ chie³² jian³ la⁴jeg³⁴ jau²hlagh³² i⁴hleh² chie³ i²con²³ Jon⁴dai¹; i² jau²hlagh³² i⁴hleh²i³ nei² quieh¹ m⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, sa⁴legh⁴ ua²a⁴jlenh³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","La⁴jang³⁴ a³hleh³ jau²hlagh³² i²con²³ A³a⁴lang³⁴ Chie³ hain⁴ li⁴jlenh⁴³pa² chie³² quieh¹i³. I² a³hleh³ jau²hlagh³² i²con²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, sa⁴li⁴jlenh⁴³ chie³² ne³ m⁵cu³ la³ a⁵ga⁴ m⁵cu³ con³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Quie¹ juah⁴ne³ tsei³⁴ a²hma³, jon³ cúa²³ o¹m⁴ tsei³⁴; jian³ juah⁴ne³ hlagh³² a²hma³, jon³ cúa²³ o¹m⁴ hlagh³² liah⁴. Quie¹ cuh²i³ a²hma³ con⁴juah⁴ o¹m⁴ i⁴hag³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Sa¹jeun³ a⁵mh³ hnei³ tionh²ˉ³! ¿Hain³liah⁴ li⁴hleh²ˉ³ jau²³ tsei²³ juah⁴ne³ hlangh²ˉ³ tionh²ˉ³? Quie¹ la⁴conh⁴ tei⁴³ i⁴jia²³ m⁴tyi⁴ quieh¹i³, húa²³ ho³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A³hain⁴ a³tsein²³ hleh² jmah³ jau²³ tsei²³ quie¹ tsei³⁴ co³hei²tsei³ júan³i³; jian³ a³hain⁴ a³hlangh² hleh² jau²hlagh³² quie¹ hlagh³² co³hei²tsei³ júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Quie¹ chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴jeg³⁴ jau²³ con³ i⁴hleh² chie³, hniah³ cúah³i³ jau²chie⁴³ quieh¹ ta⁵nei² Jon⁴dai¹ jm² i⁴queih³i³ heih⁴³ i²con²³ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Quie¹ con⁴juah⁴ jau²³ quianh³ˉ³ je⁴³ hnei³ Jon⁴dai¹ la⁴jan³ a³tsein²³, jian³ con⁴juah⁴ jau²³ quianh³ˉ³ gmh⁴ heih⁴³ i⁴si⁵hainh⁴ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jon³ a⁴juah⁴ co⁴meih³ a²teg²³ quian¹ lai²³ jian³ fariseo tionh² i²con²³ Jesús: ―Hnei³ A²teg²³, hnie³⁴ jnie³² niah¹ jnie³² ua³júah² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Chie³ hlangh² tionh² jian³ a³sa⁴ni²taih⁴³ m²³ ua³júah²; quie¹ a⁵sie⁴³ ua³júah² ma⁵li⁴lei⁴ i⁴seg³⁴, con³ ua³júah² i⁴a⁴leg³⁴ i²con²³ Jonás a³sain² hain⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Quie¹ la⁴jon³ liah⁴i² a⁴hei³⁴ Jonás naih⁵ hein² jon⁴³júa³² pa¹ hneng³ jm² jian³ hneng³ nai⁴³, la⁴ne³ chie³⁴ A³a⁴lang³⁴ Chie³ hain⁴ naih⁵ húa³⁴ hneng³ jm² jian³ hneng³ húa²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jian³ tei⁴³i² can³⁴ Jon⁴dai¹ jau²chie⁴³ i²con²³ m⁵cu³, jon³ ma⁵jnia³² a³ma²tionh² je¹jeu³ Nínive i⁴hnang⁵i³ chie³ a³sian³ tieh²la³; quie¹ a⁴sag²³ a³ma²sian³ Nínive hain⁴ co³hei²tsei³ quieh¹ con⁴juah⁴ jau²³ i⁴a⁴hleh⁴ Jonás, jian³ sainh⁴³ jan³ i²la³ a³júanh⁴³ a⁵hei⁴³ lia⁴ Jonás. ");
INSERT INTO cucNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jian³ la⁴teg⁴i² can³⁴ Jon⁴dai¹ jau²chie⁴³ i²con²³ m⁵cu³, jon³ ra⁵hang³² a¹si²re¹ quian¹ Ta⁵ñei³⁴ jian²³ chie³ a³sian³ tieh²la³, jian³ hnang⁵i³ hnei³ tionh²ˉ³, quie¹ cuan³⁴ a¹si²re¹ i⁴ja³⁴i³ i²gm⁴ don⁵, i⁴ua⁵nai³i³ jau²³ i⁴ŋang⁴ re¹ Salomón. Jian³ sainh⁴³ jan³ i²la³ a³júanh⁴³ a⁵hei⁴³ lia⁴ Salomón. ");
INSERT INTO cucNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’La⁴teg⁴i² si³hag⁴³ con³ m⁴tyi⁴ hlagh³² naih⁵ ni²tsei⁴³ jan³ a³ñih³, jon³ ŋeng²³i³ ta⁵húa³⁴ quein³ hnoh³i³ i²jian³⁴i³, i² sa⁴tyieh¹i³ ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","I² jon³ juah⁴i³: “Naih²ˉ⁵ jauh³² quien⁴ˉ⁴ i²ma²a⁴jau³⁴ˉ⁴.” I² tei⁴³i² a⁴tyanh³i³, jon³ jen³i³ a³ñih³ hain⁴ liah⁴i² leg⁴³ con³ jauh³² i²sa⁴sian³ i¹jan³, i⁴re³ si²hyah² jian³ si²lag¹. ");
INSERT INTO cucNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jon³ chie²³i³ si⁵quian⁴i³ i²quie³⁴ m⁴tyi⁴ tyein² hlangh² la⁴conh⁴a² hei⁴i³, ma²jon³ han⁵i³ la⁴jang³⁴i³ la⁴jon³ naih⁵ ni²tsei⁴³ a³hain⁴, cua³⁴i³. I² jon³ eu⁴³ pi¹ hlagh³² hie⁴³ quionh⁴ a³ñih³ hain⁴ i²a⁴toh⁴ la⁴conh⁴a² ma²ra⁴lie⁵. Jian³ la⁴ne³ si⁵lei⁴ i²con²³ chie³ a³sian³ tieh²la³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","I² con³ma²si²hlenh⁴³ pi¹ Jesús chie³, jon³ a⁴tyie³⁴ sie²³i³ jian³ si³reunh¹i³. Tionh²i³ coh⁵hnei³², jian³ sia³ con³ jau²³ hnie³⁴i³ sagh⁵i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","I² jon³ a⁴júan⁴ jan³ chie³ jau²³ i²con²³ Jesús, juah⁴i³: ―Jeh³², sieh³ˉ³ jian²³ si³reunh³ˉ³ ti²tionh² coh⁵hnei³², hnie³⁴i³ hleh⁴³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","I² jon³ a⁴jainh³i³ jau²³ i²con²³ a³ŋang²³ jau²³ hain⁴, juah⁴i³: ―¿Hain³ lang⁴³ sia³⁴ˉ⁴ jian³ si³reunh³ˉ⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jon³ a⁴júan⁴i³ si¹cúa³ ta⁵i²tionh² chie³ quian¹i³, juah⁴i³: ―A³ne³pa² sia³⁴ˉ⁴ jian³ si³reunh³ˉ⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Quie¹ la⁴jang³⁴ a³ma³tei⁵ heih⁴³ quieh¹ Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵, a³hain⁴pa² a³ñih³ reunh³ˉ⁴, a³m⁴ reunh³ˉ⁴, jian³ sia³⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jm² jon³ ua⁵hag⁴³ Jesús jauh³², ŋo³⁴i³ ua⁵cua³i³ quien¹i²jm¹ jm³ñei³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","I²jon³ a⁴ŋangh³ jeun⁴³ chie³ hlonh²i³. I² jon³ a⁴hei³⁴ Jesús joh⁴³ a²úan⁴³, a⁴cua⁴i³, i² la⁴jang³⁴ chie³ liah⁴ tionh² i²chie³². ");
INSERT INTO cucNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jon³ a⁴hlenh⁴³i³ a³hain⁴ tionh² hlion⁴ jau²³ i⁴a⁴can³⁴i³, a⁴juah⁴i³: ―Jan³ chie³ ŋo³⁴ ua⁵jñi³ o¹m⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","I² con³ma²si²jnei³i³, jon³ a⁴jyih³ co⁴meih³ o¹m⁴ hloh³² ho³²jeu³; i² jon³ a⁵han² jon⁴³tan²³, a⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Conh⁴liah⁴ a⁴jyih³ co⁴meih³ je¹ na²caun² i²sa⁴ra³tsei²³ hlion⁴ o¹cuah³²; jon³ a⁴hya³ o¹m⁴ jon³ ta¹tia⁴, quie¹ ta⁵la⁴ sa⁴hmh² o¹cuah³². ");
INSERT INTO cucNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","I² con³ma²ja³⁴ hyie³ ne⁵, jon³ a⁴co⁴, ra⁵quein³ o³tan² quie¹ sa⁴re³ ya¹quian³ o¹júan⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Conh⁴liah⁴ a⁴jyih³ co⁴meih³ je¹ a²ton⁴³; i² jon³ ra⁵jang¹ a²ton⁴³ jon³, a⁴loh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jian³ co⁴meih³ a⁴jyih³ húa³⁴ tsei³⁴; i² i⁴jon³ ta² re³ a⁴cúa⁴ o¹m⁴; ca³chie³² a⁴cúa⁴ nia⁴lo⁴ m⁴, jian³ ca³chie³² a⁴cúa⁴ to⁴lo⁵quia⁴ ni²tsei¹ quia³⁴, jian³ ca³chie³² a⁴cúa⁴ qui⁴quia⁴ liah⁴, la⁴ne³ a⁴cúa⁴ conh⁴ con³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","A³hain⁴ a³ho³ ta³ra³cua¹ i⁴nau³⁴i³, ua²nai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","I² jon³ ua⁵han² chie³ quian¹i³ hlonh²i³, a³a⁴juah⁴ tionh²: ―¿E⁴le³⁴ hleh³ˉ³ jmah³ jeu³ jau²³ i⁴canh³ˉ³ i²con²³ chie³? ");
INSERT INTO cucNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","I² jon³ a⁴ŋangh³i³: ―Quie¹ hnei³pa² tionh²ˉ³ júan³ Jon⁴dai¹ i⁴li⁴ñih¹ˉ³ jau²³ ni²hma² liah⁴ tionh² chie³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵; i² hei⁴i³ tionh² ne⁵, sa⁴júan³ Jon⁴dai¹ i⁴li⁴ñi³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Quie¹ la⁴jang³⁴ a³ma³ñi³, hyieh⁴ pi¹i³ i⁴li⁴ŋang⁴i³; jian³ la⁴jang³⁴ a³sa⁴ñi³, jon³ qui³⁴ la⁴teg⁴ ca³leuh² peih¹ i⁴ŋang⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","I⁴jon³ hleh³ˉ⁴ i²con²³i³ tionh² con⁴juah⁴ jmah³ jau²³ i⁴can³⁴ˉ⁴; quie¹ ua²liah⁴a² je²³i³, la⁴con³ sa⁴ho³ m⁴nei²i³; jian³ ua²liah⁴a² nau³i³, la⁴con³ sa⁴ho³ ta³ra³cua¹i³, a⁵ga⁴ li⁴ŋang⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","I² la⁴ne³ li⁴tei⁴³ jau²³ i²con²³i³ i⁴a⁴sag⁴ Isaías, a³sain² hain⁴, a³a⁴juah⁴: Ua²liah⁴a² nauh³ˉ³, sa⁴legh⁴ ua²ra⁵ŋangh⁴ˉ³ tionh²ˉ³; jian³ ua²liah⁴a² jeh⁴ˉ³, sa⁴legh⁴ ua²a⁴henh³ tyih³ˉ³ tionh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","quie¹ eu⁴³ huah³ m⁴tyi⁴ quieh¹ a³jeu³ ne³, jian³ sa⁴legh⁴ ua²a⁴henh³ jau²³ ta³ra³cua¹i³, ua²liah⁴a² nau³i³, quie¹ ma³a⁴tau⁴ m⁴nei²i³, canh⁴a² so⁵je³⁴i³, jian³ so⁵naih¹i³, jian³ a⁵ga⁴ li⁴ŋang⁴i³, jian³ sa⁴i²sag³⁴i³ co³hei²tsei³ quieh¹, canh⁴a² ma²júan³²ˉ⁴ i⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’I² hnei³ tionh²ˉ³ ne⁵, ta² tsei³⁴ jm² renh³ˉ³, quie¹ jeh⁴ˉ³ jeu³ m⁴mah²ˉ³ jian³ nauh³ˉ³ jeu³ ta³ra³cuah⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, jeun⁴³ a³sain² jian³ chie³ ni²taih⁴³ ma²i²je³⁴ i⁴ti²jeh⁴ˉ³ tionh²ˉ³, jian³ a⁵sia³ a⁴teg⁴ nei²i³; jian³ ma²i²nau³⁴i³ i⁴ti²nauh³ˉ³, jian³ a⁵sia³ a⁴tang⁴i³ a⁴nau⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Nai³ hnei³ tionh²ˉ³ henh⁴ hnie³⁴ ra³juah⁴ jau²³ sa⁴lei³ quieh¹ a³jnei³ o¹m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","La⁴teg⁴i² nau³ jan³ jau²³ quieh¹ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹ jian³ sa⁴li⁴ŋang⁴i³, jon³ jia²³ a³sa⁴tsein³⁴ si³qui⁴³i³ jau²³ i⁴jnia² naih⁵ ni²tsei⁴³i³. A³la⁴ne³ hain⁴ lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ hloh³² ho³²jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jian³ a³hain⁴ a³lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ je¹ na²caun² júan³ la⁴la³: nau³i³ jau²³ quieh¹ Jon⁴dai¹, jian³ liah⁴ma²jon³ hyei³i³ si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jian³ sa⁴re³ ya¹quian³i³ o¹júan⁴³, quie¹ sa⁴tieh¹i³ úa⁴; quie¹ tei⁴³i² jia²³ ma²eu⁴³ jian³ o⁴ i⁴hag²³ chie³ nei² quieh¹ jau²³ i⁴quian³i³, jon³ teinh³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jian³ a³hain⁴ a³lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ je¹ a²ton⁴³ júan³i³ la⁴la³: nau³i³ jau²³ quieh¹ Jon⁴dai¹, i² hlion⁴ co³hei²tsei³ júan³i³ nei² quieh¹ i⁴sia³ m⁵cu³ la³ jian³ i⁴ma³can³i³ tsei⁴³ hña³ con⁴juah⁴ o¹cau³². La⁴jeg³⁴ co³hei²tsei³ ne³ júan³ i⁴ai²³ jau²³ jon³, jian³ sa⁴tyie²³ i²ma³jnia³i³ i⁴tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","I² a³hain⁴ a³lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ nei² húa³⁴ tsei³⁴ ne⁵, la⁴la³ júan³i³: nau³i³ jau²³ quieh¹ Jon⁴dai¹ jian³ ŋang⁴i³, jian³ cúa²³i³ o¹m⁴ i⁴ma³jnia³i³ i⁴tsei³⁴; ca³chion²³ cúa²³ nia⁴lo⁴ m⁴, ca³chion²³ cúa²³ to⁴lo⁵quia⁴ ni²tsei¹ quia³⁴ m⁴, jian³ i²ca³chion²³ cúa²³ qui⁴quia⁴ m⁴ liah⁴, la⁴ne³ cúa²³ la⁴con⁴jan³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jon³ a⁴hleh⁴i³ i²con³ jau²³ i⁴a⁴can³⁴i³, juah⁴i³: ―I⁴tionh²i³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ jan³ a³ñih³ a³a⁴jnei⁴ o¹m⁴ tsei³⁴ je¹ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","I² con³ma²ti²cm²i³ tionh², jon³ ja³⁴ jan³ a³hie²³, a⁴jnei⁴i³ o¹nau³ hlagh³² je¹ o¹m⁴ trigo, jon³ a⁴cm⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","I² con³ma²a⁴hya³ trigo, jon³ a⁴hya³ o¹nau³ hlagh³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","I² jon³ a⁵han² mozo quian¹ a³quieh¹ húa³⁴ jon³, a⁴sagh⁴³i³ jeu³², juah⁴i³: “Hnei³ a³don⁵, ¿o⁴ a⁵sia³ a⁴jñih⁴ˉ³ o¹m⁴ tsei³⁴ je¹ quianh³? ¿I² liah⁴ cúan²³ a⁴hya³ o¹nau³ hlagh³² ne⁵?” ");
INSERT INTO cucNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I² jon³ a⁴juah⁴ jeu³²i³: “A⁴júan⁴ jan³ a³hie²³pa² ne³.” Jon³ a⁴juah⁴ mozo tionh²: “¿O⁴ hnoh³ˉ³ i⁴si²quei² jnie³² o¹nau³ hlagh³² jon³?” ");
INSERT INTO cucNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I² jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: “A⁵sia³, quie¹ juah⁴ne³ ua²queih³ˉ³ o¹nau³ hlagh³², jon³ lei⁴ li⁴quei³⁴ o¹m⁴ trigo co⁴chia³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Eu⁴³a² re³ ua²yi⁵cúan³ co⁴chia³ li⁵teun⁴ nai² la⁴conh⁴i² a⁴lo³. I² tei⁴³i² lo³⁴ ne⁵, jon³ jeu¹ˉ⁴ a³si⁵queih⁴ tionh²: Yi⁴tyah²ˉ³ co⁴lagh⁴³ ñeih³² o¹nau³ hlagh³², jian³ yi⁴hñeih⁴ˉ³ canh⁴a² co³⁴; i² jaih¹ hnei³ o¹m⁴ trigo, tyah²ˉ³ joh⁴³ a²quei³ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jon³ a⁴can³⁴i³ i²con³ jau²³ liah⁴ i⁴seg³⁴, a⁴juah⁴i³: ―I⁴tionh²i³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² leg⁴³ con³ o¹m⁴ mostaza i⁴a⁴can³⁴ jan³ a³ñih³, jian³ ni²jñi³i³ je¹ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Quie¹ i⁴chie⁴³pa² tyein² peih¹ o¹m⁴ jon³ la⁴conh⁴a² la⁴jeg³⁴ o¹m⁴; i² tei⁴³i² ma³jang¹ ne⁵, jon³ júah³ la⁴conh⁴a² la⁴jeg³⁴ o¹sieh³² i⁴queuh³i³, leg⁴³ con³ a²hma³ o³tan², i²jon³ ua³tsei³² jon⁴³tan²³, júan³i³ sag³² je¹ o¹cúah² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jon³ a⁴can³⁴i³ i²con³ jau²³ liah⁴ i⁴seg³⁴, a⁴sagh⁴³i³ a³hain⁴ tionh²: ―I⁴tionh²i³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² leg⁴³ o¹sieh³² hei⁴³ñih¹ i⁴a⁴can³⁴ jan³ a³m⁴ jian³ a⁴conh³i³ hneng³ tieh³² hma³ ca³jeun²³ o¹a³ri²na³, jian³ a⁴yienh⁴ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","La⁴jeg³⁴ i⁴ne³ a⁴hleh⁴ Jesús i²con²³ chie³ con⁴juah⁴ jau²³ i⁴a⁴can³⁴i³; i¹con³ jau²³ sa⁴a⁴hlenh⁴³i³ chie³ juah⁴ne³ sa⁴a⁴hlenh⁴³i³ con⁴juah⁴ jau²³ i⁴a⁴can³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A⁴leg³⁴ la⁴ne³ canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ jan³ a³sain² con³ma²a⁴juah⁴i³: Hlenh²i³ jnia⁴ jmah³ jau²³ i⁴can¹ˉ⁴; tya¹ˉ⁴ jau²³ i⁴ma²ni²hma² liah⁴ma²a⁴leg³⁴ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","I² con³ma²a⁴sainh³i³ chie³ jeun⁴³ hain⁴, jon³ a⁴hei³⁴ Jesús jauh³², jon³ ua⁵han² chie³ quian¹i³ hlonh²i³ a³a⁴juah⁴ tionh²: ―Tyie³² hnei³ jnie³² jau²³ i⁴a⁴quianh³ˉ³ nei² quieh¹ o¹nau³ hlagh³² i⁴jnia² je¹. ");
INSERT INTO cucNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―A³hain⁴ a³jnei³ o¹m⁴ tsei³⁴ lang⁴³ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","I² je¹ ne⁵, leg⁴³ m⁵cu³pa². Jian³ o¹m⁴ tsei³⁴ lang⁴³ a³tionh² naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵, jian³ o¹nau³ hlagh³² lang⁴³ jon⁴³segh³² a³sa⁴tsein³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jian³ a³hie²³ a³a⁴jnei⁴ o¹nau³ hlagh³² hain⁴, a³sa⁴tsein³⁴pa². I² i⁴a⁴lo³ o¹m⁴ jon³ leg⁴³ jm² i²a⁴toh⁴ m⁵cu³. I² a³jaih² hain⁴ lang⁴³ ángel tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jian³ la⁴ne³ liah⁴i² cag²³i³ o¹nau³ hlagh³², jian³ jeng³i³ je¹ o¹jyi³ loh⁴³, la⁴ne³ lei⁴ tei⁴³i² a⁴toh⁴ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Quie¹ sain³⁴ A³a⁴lang³⁴ Chie³ hain⁴ ángel quian¹ i⁴si⁵jaih²i³ la⁴jang³⁴ a³júan³ i⁴tianh⁵ chie³ chie³² jian³ a³júan³ i⁴hlagh³², húan⁵i³ a³hain⁴ i²júan³⁴i³ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ron⁵i³ joh⁴³ a²gm² je¹ o¹jyi³ loh⁴³; i²jon³ hoh⁵i³ jian³ queuh⁴³i³ m⁴jan². ");
INSERT INTO cucNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","I² jon³ li⁴joh¹ la⁴jang³⁴ a³tsein²³ liah⁴i² joh¹ hyie³ i⁴tionh²i³ naih⁵ heih⁴³ quieh¹ Jon⁴dai¹ Jmai³i³. A³hain⁴ a³ho³ ta³ra³cua¹ i⁴nau³⁴i³, ua²nai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Jian³ i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² leg⁴³ con³ i⁴quein⁴³ hlion⁴ i⁴ma²ni²hma² con³ húa³⁴. Jon³ a⁴chieh¹ jan³ chie³, conh⁴liah⁴ a⁴hma⁴i³ liah⁴ i⁴seg³⁴; ta² si³hyonh³i³ ŋah³i³, ua⁵hnang⁴i³ la⁴jeg³⁴ i⁴ma²sia³ quieh¹, i² jon³ a⁴la³⁴i³ húa³⁴ jon³ o¹cau³² jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Conh⁴liah⁴ i⁴han⁵ chie³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ jan³ a³hnang³ a³hnoh³ m⁴caun² seg⁴³ perla i⁴tyein² tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","I² con³ma²a⁴chieh¹i³ con³ m⁴caun² seg⁴³ perla i⁴quein⁴³ hlion⁴ mai²³, jon³ ŋah³i³ ua⁵hnang⁴i³ la⁴jeg³⁴ i⁴ma²sia³ quieh¹, i² jon³ a⁴la³⁴i³ m⁴caun² seg⁴³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Jian³ la⁴ne³ liah⁴, naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² leg⁴³ con³ a²nai²³ saih⁵i³ joh⁴³ jm³ñei³ jian³ tyan⁴³i³ co⁴lagh⁴³ la⁴jang³⁴ nai² jon⁴³júa³². ");
INSERT INTO cucNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jian³ tei⁴³i² a⁴canh³ a²nai²³, jon³ cmh²i³ ta⁵i²quein³; i²jon³ cua²³i³ tionh², jon³ quianh⁴³i³ jmah³ a³tsein²³; ron⁴³i³ joh⁴³ a²mh³ta²³, i² a³hlangh² ne⁵, ton²³i³ ta⁵co⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jian³ la⁴ne³ lei⁴ liah⁴ jm² i²a⁴toh⁴ m⁵cu³; chie³⁴ ángel tionh² húan⁴³i³ la⁴jang³⁴ a³hlangh² jen² a³tsein²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jon³ ron⁵i³ a³hlangh² joh⁴³ a²gm² i⁴ni²co²³ o¹jyi³ loh⁴³; i²jon³ hoh⁵i³, jian³ queuh⁴³i³ m⁴jan² tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿O⁴ ra⁵ŋangh⁴ˉ³ la⁴jeg³⁴ jau²³ ne³? Jon³ a⁴juah⁴i³ tionh²: ―Jen³⁴, Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jon³ a⁴juah⁴i³ i²con²³i³: ―I⁴jon³ la⁴la³ lang⁴³ la⁴jang³⁴ a²teg²³ quian¹ lai²³ a³ma³tang²³ re³ liah⁴ leg⁴³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵: lang⁴³i³ liah⁴i² lang⁴³ jan³ a³quieh¹ jauh³² a³húa³ i⁴quein⁴³ hlion⁴ i⁴hm³⁴ jian³ i⁴don⁵ i⁴sia³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","I² con³ma²a⁴toh⁴ a⁴hleh⁴ Jesús la⁴jeg³⁴ jau²³ i⁴can²³i³ jon³, jon³ ŋah³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A⁴tyanh³i³ jeu³ co²³, i² jon³ heh³i³ chie³ cuah³ quieh¹ tionh², jian³ ta² co³ chie²³ tsei⁴³ chie³ tionh², juah⁴i³: ―¿Jainh¹ ja³⁴ i⁴ŋang⁴ a³ne³, lainh⁴ˉ³, jian³ ua³júah² i⁴júan³i³? ");
INSERT INTO cucNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿A¹hei⁴ a³ne³ a³jon⁴³ teg³hma³ hain⁴, lainh⁴ˉ³? ¿Jian³ a¹jon⁴³ Ma³rei² sain³ sie²³i³, jian³ si³reunh¹i³ sain³ Jacobo, jian³ Se¹, jian³ Si²úan¹, jian³ Judas liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿O⁴ sa¹ chie⁴³ tionh² si³m⁴ reunh¹i³ jen²ˉ¹? I² jon³ ne⁵, ¿jainh¹ ni²quian⁴i³ la⁴jeg³⁴ i⁴tang³i³ i⁴ne³? ");
INSERT INTO cucNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","I⁴jon³ sa⁴a⁴ron⁴³i³ Jesús jeu³. I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―La⁴tan²pa² ron⁴³i³ jeu³ a³sain² quian¹ Jon⁴dai¹; jeu³ co²³ pi²³i³ sa⁴ro⁴³i³ jeu³ jian³ jauh³² quieh¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I⁴jon³ a⁵sie⁴³ a⁴júan⁴i³ hlion⁴ ua³júah² i²jon³ nei² quieh¹ i⁴sa⁴hain⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jain³ jon³ a⁴nau⁴ Herodes, si²mah⁴ quian¹ húa³⁴ Galilea, jau²³ liah⁴ júan³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jon³ a⁴sagh⁴³i³ a³cúa²³ cúa³tag³² i²con²³i³: ―Juan³ Tei³²pa² a³hain⁴ a⁴hyon²³ jen² a³jaun², i⁴jon³da³ quian³i³ ua³pei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Quie¹ ta⁵la⁴ a⁴sanh³ Herodes hain⁴ Juan²³ liah⁴ma²jia⁴³, a⁴hñi⁴³i³ jian³ a⁴tonh³i³ ni⁴ñi²³ nei² quieh¹ Herodías, a³m⁴ quian¹ Lei³² reunh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Quie¹ ma²a⁴juah⁴ Juan²³ i²con²³i³: ―Sa⁴ra³cúa²³ juah⁴ i⁴jianh¹ˉ³ a³m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","I² jon³ hnie³⁴ Herodes jŋangh³ quieh¹i³; i² Herodes ne⁵, con⁴³i³ a³jeu³, quie¹ ñi³i³ tionh² i⁴lang⁴³ Juan²³ jan³ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","I² con³ma²ti²júan³i³ jm² i⁴a⁴tagh³ Herodes ñi³ ra⁵sian³, jon³ ŋo³⁴ a³m⁴ jon⁴³ Herodías jan¹ jen² chie³ tionh². Ta² a⁴teg⁴ tsei⁴³ re¹ Herodes. ");
INSERT INTO cucNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jon³ a⁴cúa⁴i³ jau²³ quieh¹ jang³⁴ tsei⁴³ i⁴cúa³⁴i³ la⁴conh⁴ i⁴m³⁴ a³m⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Quie¹ ma³a⁴sag⁴³ sie²³i³ quieh¹i³ nei² jon³ ñeih³², i² jon³ a⁴sagh⁴³i³ Herodes: ―Hno⁵ˉ⁵ ma³tyi² Juan³ Tei³² hei¹ joh⁴³ a²gm⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","I² re¹ ne⁵, ta² ra⁵chionh⁴ tsei⁴³i³ jau²³ jon³; i² nei² quieh¹ i⁴ma³a⁴cúa⁴i³ jau²³ quieh¹ jian³ i⁴a⁴nau⁴ a³tionh² nei² mesa hain⁴, a⁴júan⁴i³ heih⁴³ i⁴si⁵quian⁴i³ ma³tyi² jon³ i²con²³ a³m⁴ peih¹ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A⁴sain⁴i³ chie³ i⁴si⁵queih⁴i³ ma³lau² Juan²³ la⁴teg⁴ ni⁴ñi²³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jon³ quien²³i³ hei¹ joh⁴³ a²gm⁴³, a⁴cúah³i³ a³m⁴ peih¹ hain⁴, jian³ ni²cúah²i³ sie²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","I² jon³ a⁵han² chie³ quian¹ Juan²³, a⁴con²³i³ he³² ni²ho⁴³i³; ma²jon³ ua⁵han²i³ tionh² ua⁵saih¹i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","I² con³ma²a⁴nau⁴ Jesús jau²³ jon³, jon³ ŋo³⁴i³ joh⁴³ a²úan⁴³ la⁴teg⁴ con³ i²a⁵sian⁴³ a³sian³. I² con³ma²ra⁵ñi³ chie³ tionh², jon³ a⁴húan³i³ la⁴jeg³⁴ jeu³, a⁵han²i³ coh⁵cah³²i³ jeu³ tag³². ");
INSERT INTO cucNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","I² con³ma²ua⁵hag⁴³ Jesús joh⁴³ a²úan⁴³, jon³ a⁴jen³i³ jeun⁴³ chie³; i² jon³ joh³ ñei⁴ tsei⁴³i³ i²con²³i³, jian³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ la⁴jang³⁴ a³ma²ti²chieh¹ quian¹ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","I² con³ma²ma³si³li⁴nai³, jon³ ua⁵han² chie³ quian¹i³ hlonh²i³, a⁴juah⁴i³: ―Ta² a⁴hlo⁴, i² i²tieh²ˉ¹ la³ i²a⁵sian⁴³ a³sian³pa². Sain⁴³ hnei³ a³jeu³ canh⁴a² si⁵lia⁴³i³ i⁴queuh⁴³ la⁴jeg³⁴ jeu³ peih¹. ");
INSERT INTO cucNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","I² a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Quie¹ sa⁴hniah³ si⁵han²i³ tionh²; guenh³²i³ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jon³ a⁴juah⁴i³ tionh²: ―Ta² sa⁴hlion⁴ le² jnie³² i²la³, hña⁴ a²hei⁴³ñih¹pa² jian³ on³⁴ jon⁴³júa³². ");
INSERT INTO cucNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―Na⁴ŋang³² hnei³ i²con²³ˉ⁵ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jon³ a⁴júan⁴i³ heih⁴³ i²con²³ a³jeu³ i⁴cua³⁴i³ je¹ o¹ñei³. I² jon³ a⁴tang⁴i³ li⁵hña⁴ a²hei⁴³ñih¹ jian³ li⁵uan⁴ jon⁴³júa³² hain⁴, i² jon³ a⁴je³⁴i³ ta⁵ñi⁴jeu⁵, a⁴ma⁴cúah¹i³; ma²jon³ a⁴jeun³⁴i³, jian³ a⁴cúah³i³ chie³ quian¹ a²hei⁴³ñih¹ jon³, ma²jon³ a⁴tyieh⁵ chie³ quian¹i³ i²con²³ a³jeu³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A⁴queuh³ la⁴jang³⁴ a³hain⁴ tionh², jian³ a⁴canh³ hein²i³ tionh²; ma²jon³ a⁴jaih³i³ la⁴jeg³⁴ o¹leuh² i⁴a⁴sion³⁴, a⁴canh³ quia⁵teun⁴ a²mh³ta²³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jian³ la⁴jang³⁴ a³a⁴queuh³ tain⁴³ conh⁴ hña⁴ mai²³ a³ñih³, a⁵sian⁴³ hen⁴³ a³m⁴ jian³ si³maih² peih¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Liah⁴ma²jon³ a⁴júan⁴ Jesús i⁴han⁵ chie³ quian¹ joh⁴³ a²úan⁴³, jian³ chie³⁴i³ ta⁵jo³² hŋoh³ naih⁵ chie³⁴ hei⁴i³, ta¹la⁴ sainh³i³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","I² con³ma²a⁴sainh³i³ a³jeu³, jon³ ŋo³⁴i³ nei² mah⁴ ua⁵mh²i³ Jon⁴dai¹ hña³. I² con³ma²a⁴nai³, jon³ si²sainh⁴³i³ hña³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","I² a²úan⁴³ jon³ ne⁵, ma³a⁴tyie³⁴ la⁴teg⁴ yi⁴jo²³ jm³, hei¹ jeu³ con⁴juah⁴ i⁴jnoh² jm³, quie¹ jia²³ tyi⁴ jeu³ chie²³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jon³ a⁴tyie³⁴ Jesús hlonh²i³ tionh² to⁵hie³ nai³, ŋeng²³i³ jeu³ nei² jm³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","I² chie³ quian¹i³ ne⁵, con³ma²a⁴jen³i³ Jesús ya¹ŋeng²³ jeu³ nei² jm³, ta² yi⁴hang³²i³ tionh², a⁴juah⁴i³: ―¡Jeh³², jan³ a²nai³²! Jian³ a⁴hoh⁵i³ tia⁴ coh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Liah⁴ma²jon³ a⁴hleh⁴ Jesús i²con²³i³, a⁴juah⁴i³: ―¡Re³ tya² hnei³ hoh⁴³ tionh²ˉ³; jnia⁴pa² la³, a⁵júan³ hnei³ canh⁴³! ");
INSERT INTO cucNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jon³ a⁴ŋangh³ Pe³² i²con²³i³, a⁴juah⁴i³: ―Se³ño²³, juah⁴ne³ hnei³, júan² hnei³ heih⁴³ i⁴nai³²ˉ⁴ i²conh²ˉ³ jeu³ nei² jm³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","I² jon³ a⁴juah⁴ Jesús: ―Nia³. Jon³ ua⁵hag⁴³ Pe³² joh⁴³ a²úan⁴³, a⁴ŋeng⁴i³ jeu³ nei² jm³ i⁴chie³⁴i³ i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","I² con³ma²a⁴je³⁴i³ i⁴pain⁴ tyi⁴, jon³ joh³ tsei⁴³i³; jon³ ra⁴lie⁵ hon²³i³, a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―¡Hnei³ Se³ño²³, lie³² jnia⁴! ");
INSERT INTO cucNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Liah⁴ma²jon³ a⁴ñeih³ Jesús si¹cúa³ i²con²³i³, a⁴sionh³i³, a⁴juah⁴i³: ―¡Hnei³ a³sa⁴hain⁴ hlion⁴! ¿E⁴le³⁴ teun³⁴ co³hei²tsei³ a⁴júanh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","I² con³ma²a⁴han⁵i³ joh⁴³ a²úan⁴³ tionh², jon³ a⁴jian⁴ tyi⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","I² a³tionh² joh⁴³ a²úan⁴³ hain⁴ ne⁵, a⁴tyie³⁴i³ hlonh² Jesús a⁴ma⁴con⁴³i³, a⁴juah⁴i³: ―I⁴chie⁴³pa² langh⁴³ hnei³ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","I² con³ma²a⁴han³i³ jm³ñei³ tionh², jon³ a⁴tyie³⁴i³ húa³⁴ Genesaret. ");
INSERT INTO cucNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","I² con³ma²ra⁵cu²³ a³sian³ húa³⁴ jon³ quieh¹ Jesús, jon³ a⁴sain⁴i³ jau²³ la⁴tan² la⁴conh⁴ hloh³² jon³; i² jon³ jian³i³ la⁴jang³⁴ a³chieh¹ quian¹ i²con²³ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jian³ a⁴mh³i³ Jesús i⁴cúa³⁴i³ jeu³ i⁴tei³⁴ la⁴jang³⁴ a³chieh¹ si¹cúa³ he⁴³ a²cúan³i³; i² la⁴jang³⁴ a³a⁴tang⁴ he⁴³ a²cúan³i³ hain⁴, a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jon³ a⁴tyie³⁴ a²teg²³ quian¹ lai²³ jian³ fariseo i²con²³ Jesús, a³sian³ Jerusalén tionh², a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿E⁴le³⁴ sa⁴ma³co⁴³ chie³ quianh³ˉ³ i⁴tang²³ quieh¹ a³don⁵ ma⁴³teg²³? Quie¹ sa⁴raunh⁵i³ si¹cúa³ tei⁴³i² queuh³i³ a²hei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","I² jon³ a⁴jainh³ Jesús jau²³, a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ liah⁴, ¿e⁴le³⁴ sa⁴ma⁵coh³²ˉ³ heih⁴³ quieh¹ Jon⁴dai¹ nei² quieh¹ i⁴ma⁵coh³²ˉ³ i⁴tang²³ quianh³? ");
INSERT INTO cucNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Quie¹ a⁴júan⁴ Jon⁴dai¹ heih⁴³, a⁴juah⁴i³: “Ma⁴con³² hnei³ naih⁴³sieh³”, jian³ “A³hain⁴ a³sagh⁴³ jmai³ jau²hlagh³² jian³ o⁴ sie²³i³, hniah³ jaun⁴i³ i⁴so⁵sia³ i⁴hain⁴ chie³².” ");
INSERT INTO cucNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","I² hnei³ tionh²ˉ³ juah⁴ ne⁵, i⁴li⁴juah⁴ chie³ i²con²³ jmai³ jian³ o⁴ sie²³: “Sa⁴li⁴ma²hon³²ˉ⁴ hnei³, quie¹ ma³a⁴jeu³⁴ˉ⁴ Jon⁴dai¹ i⁴tain⁴³ hei⁴ pi²³i³ la⁴jeg³⁴ i⁴sia³ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jian³ a³hain⁴ a³juah⁴ la⁴ne³, jon³ a⁵sie⁴³ li⁴ma⁵hon³²i³ jmai³ jian³ o⁴ sie²³i³, juah⁴ˉ³. I² la⁴ne³ júanh³ˉ³ i⁴sa⁴quein⁴³ jau²³ quieh¹ Jon⁴dai¹ nei² quieh¹ i⁴ma⁵coh³²ˉ³ i⁴tang²³ quianh³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Hnei³ chie³ a³júan³ ni²taih⁴³! Ta² re³ a⁴hleh⁴ Isaías a³sain² quian¹ Jon⁴dai¹ hain⁴, nei² quianh³ˉ³ tionh²ˉ³, con³ma²a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ma³co⁴³ jnia⁴ a³jeu³ ne³ jeu³ ho³². I² m⁴tyi⁴ quieh¹i³ ne⁵, sa⁴hei¹ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Quie¹ sa⁴tei⁴³ ta¹ liah⁴ ma³co⁴³i³ jnia⁴. Quie¹ jau²³ i⁴he²³i³ leg⁴³ jmah³ heih⁴³ quieh¹ a³ñih³pa². ");
INSERT INTO cucNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jon³ a⁴teh³i³ a³jeu³ tionh², a⁴sagh⁴³i³: ―Nai³ hnei³, jian³ ua²li⁴ŋangh⁴ˉ³: ");
INSERT INTO cucNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A⁵jon⁴³ i⁴si³ha¹ to³lau² chie³ júan³ i⁴hlianh⁴ chie³. Quie¹ i⁴húa²³ to³lau² pi²³i³ júan³ i⁴hlianh⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","I² jon³ con³ma²a⁴tyie³⁴ chie³ quian¹i³ hlonh²i³ a³a⁴juah⁴: ―¿O⁴ ñih¹ˉ³ i⁴ra³hieh¹ fariseo tionh² con³ma²a⁴nau⁴i³ jau²³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","I² jon³ a⁴ŋangh³i³, a⁴juah⁴i³: ―La⁴jeg³⁴ sieh³² hma³ i⁴sa⁴a⁴jnei⁴ Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵ hniah³ quei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ua²leg⁴³pa² quieh¹i³ tionh²; quie¹ lang⁴³i³ a³taun³² a³he²³ jeu³ i²con²³ a³taun³² sang²³. Jian³ juah⁴ne³ he²³ a³taun³² jeu³ i²con²³ a³taun³² sang²³, jon³ tianh⁵i³ li⁵uan⁴i³ jon³ joh⁴³ to³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Tya² hnei³ jau²³ i²con²³ jnie³² henh⁴ hnie³⁴ ra³juah⁴ jau²³ i⁴a⁴quianh³ˉ³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jon³ a⁴juah⁴ Jesús: ―¿O⁴ hnei³ tionh²ˉ³ liah⁴, sa⁴quienh⁴ tyih³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿O⁴ sa⁴ñih¹ˉ³ i⁴la⁴jeg³⁴ si³ha¹ to³lau² chie³ chie²³ hein²i³? I² tei⁴³i² ma³a⁴con³⁴, jon³ húa²³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","I² la⁴jeg³⁴ i⁴húa²³ ta³lau²i³ ne⁵, jia²³ teg⁴ m⁴tyi⁴ quieh¹ chie³; i⁴ne³ jon³ hlianh⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Quie¹ la⁴teg⁴ m⁴tyi⁴ quieh¹ chie³ jia²³ co³hei²tsei³ hlagh³² la⁴la³, i⁴jŋangh²i³ chie³, i⁴hlenh⁴³i³ i³cúa³ chie³, i⁴hlenh⁴³i³ a³m⁴ sang³⁴, jian³ i⁴júan³i³ hang³, jian³ i⁴hleh²i³ jau²ta³jau²³, jian³ i⁴hleh²i³ hlagh³² nei² quieh¹ a³sang²³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","La⁴jeg³⁴ i⁴ne³ júan³ i⁴hlianh⁴ chie³; i² i⁴queuh³i³ jeu³ si¹cúa³ i⁴sa⁴cag⁴ ne⁵, a⁵sia³ hlianh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jon³ ua⁵hag⁴³ Jesús jeu³ jon³, ŋo³⁴i³ húa³⁴ i²nie⁴³ jeu³ Tiro jian²³ Sidón. ");
INSERT INTO cucNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","I² jon³ ja³⁴ jan³ a³m⁴ cananea a³cua⁴³ i²jon³, hleh²i³ tia⁴, juah⁴i³: ―Hnei³ Se³ño²³, Sa¹jeun³ re¹ Da³vei²³, ¡ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ˉ⁵! Ta² hlion⁴ ma²eu⁴³ can²³ a³m⁴ jon³⁴ˉ⁴ con⁴juah⁴ con³ m⁴tyi⁴ hlagh³² i⁴quian³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","I² Jesús ne⁵, i¹con³ jau²³ sa⁴a⁴ŋangh³i³. Jon³ a⁴tyie³⁴ chie³ quian¹i³ hlonh²i³, a⁴mh³i³ Jesús, juah⁴i³: ―Sainh³² hnei³ a³m⁴ ne³, quie¹ ta² tia⁴ hleh²i³ coh⁵cah³²ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","I² jon³ a⁴juah⁴ Jesús: ―A⁴sai⁴ jnia⁴ Jon⁴dai¹ i²con²³ jmah³ sa¹jeun³ Israel, a³lang⁴³ a⁵a³siah³ a³ŋeng²³ conh². ");
INSERT INTO cucNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","I² jon³ a⁴tyie³⁴ a³m⁴ hain⁴ hlonh²i³, a⁴si⁴jnei⁵i³ ta⁵nei²i³, juah⁴i³: ―¡Ma⁴ho³² hnei³ jnia⁴, Se³ño²³! ");
INSERT INTO cucNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","I² jon³ a⁴juah⁴ Jesús: ―Sa⁴re³ juah⁴ i⁴qui³⁴i³ a²hei⁴³ñih¹ quieh¹ si³jon⁴³ juah⁴ i⁴cúah³i³ a¹tsai³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","I² a⁴juah⁴ a³m⁴ hain⁴ ne⁵: ―Hnei³ Se³ño²³, i⁴chie⁴³pa² jau²³ quianh³ˉ³; jian³ ton³²nie⁴³ queuh³pa² a¹tsai³ o¹leuh² i⁴jyih² nei² a²me²sa³ quieh¹ jeu³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","I² jon³ a⁴ŋang³ Jesús i²con²³i³, juah⁴i³: ―Hnei³ a³m⁴, ¡ta² hlion⁴ hainh⁴ˉ³! Ua²lei⁴ i²conh²ˉ³ liah⁴ hnoh³ˉ³. I² jon³ a⁴huan⁴ quieh¹ a³m⁴ jon⁴³i³ lia⁴ o²ra³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jon³ ua⁵hag⁴³ Jesús i²jon³, a⁴tyie³⁴ quien¹i²jm¹ jm³ñei³ Galilea; i² jon³ a⁴eu⁴i³ nei² con³ mah⁴, jon³ a⁴cua⁴i³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","I² jon³ a⁴tyie³⁴ jeun⁴³ chie³ hlonh²i³ a³jian³ a³tein⁴ quian¹, a³taun³², a³con², a³leun²³, jian³ jeun⁴³ a³ti²lang⁴³ chie² seg³⁴. A⁴quion³i³ la⁴jang³⁴ a³chieh¹ hain⁴ ta⁵nei² Jesús, i² jon³ a⁴júan⁴i³ a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","I² la⁴ne³ ta² co³ ŋo³⁴ tsei⁴³ chie³ a³jeun⁴³ hain⁴ tionh² con³ma²je²³i³ i⁴hleh² a³con², i⁴a⁴hyan⁴³ a³leun²³ jian³ i⁴ŋeng²³ a³tein⁴, jian³ i⁴je²³ a³taun³². Ma²jon³ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹ quian¹ a³jeu³ Israel tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jon³ a⁴teh³ Jesús chie³ quian¹, a⁴sagh⁴³i³: ―Ta² jieh⁴ ñei⁴ tsei³⁴ˉ⁴ i²con²³ chie³ la³ tionh², quie¹ ma³a⁴teg⁴ hneng³ jm² jie³i³ jnia¹, jian³ sa⁴sia³ i⁴li⁴queuh⁴³i³. Jon³ sa⁴hno⁵ˉ⁵ sainh³²i³ jnia⁴ liah⁴ma²cúanh⁴³i³ tionh² con³na¹i⁵neih³i³ ho³²jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jon³ a⁴juah⁴ chie³ quian¹i³ i²con²³i³: ―¿Jainh¹ li⁴tyanh³²ˉ¹ hlion⁴ a²hei⁴³ñih¹ i²a⁵sian⁴³ a³sian³ la³, canh⁴a² li⁴queuh⁴³ chie³ jeun⁴³ ne³ tionh² liah⁴a² a⁴lag³⁴ tsei⁴³i³? ");
INSERT INTO cucNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―¿Jah⁴ a²hei⁴³ñih¹ quianh²ˉ³ tionh²ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―Quie³⁴, jian³ co⁴meih³ jon⁴³júa³² peih¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³ chie³ jeun⁴³ hain⁴ i⁴cua³⁴i³ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","I² con³ma²a⁴tang⁴ Jesús li⁵quie³⁴ a²hei⁴³ñih¹ jon³ jian³ jon⁴³júa³² hain⁴, jon³ a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, jon³ a⁴jeun³⁴i³; i² jon³ a⁴cúah³i³ chie³ quian¹, i² chie³ quian¹i³ a⁴tyieh⁵ i²con²³ a³jeun⁴³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I² jon³ a⁴queuh³ la⁴jang³⁴, jian³ a⁴lag³⁴ tsei⁴³i³. Ma²jon³ a⁴jaih³i³ o¹leuh² i⁴a⁴sion³⁴, jon³ a⁴canh³ quie³⁴ a²mh³ta²³. ");
INSERT INTO cucNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jian³ la⁴jang³⁴ a³a⁴queuh³ hain⁴ tain⁴³ quin⁴ mai²³ a³ñih³, a⁵sian⁴³ hen⁴³ a³m⁴ jian³ si³maih² peih¹. ");
INSERT INTO cucNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","I² coh⁵ jon³ a⁴sainh³ Jesús chie³ hain⁴ tionh². Jon³ a⁴hei³⁴i³ joh⁴³ a²úan⁴³, ŋo³⁴i³ ta⁵i²sain³ Magdala. ");
INSERT INTO cucNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jon³ a⁴tyie³⁴ fariseo jian³ saduceo tionh² hlonh² Jesús i⁴con⁴³i³ jau²chie⁴³ i²con²³i³, a⁴m⁴i³ i⁴júan³⁴i³ con³ ua³júah² i⁴jia²³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","I² a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Tei⁴³i² ma³si³li⁴nai³ juah⁴ˉ³ tionh²ˉ³: “Ta² li⁴tsei³⁴ jm² quie¹ joh¹ ñi⁴jeu⁵.” ");
INSERT INTO cucNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jian³ si⁵hie³ juah⁴ˉ³ liah⁴: “Ta² hlagh³² jm² lei⁴ quie¹ si³ha¹ o¹jnai⁴³ jian³ jnia⁵ joh¹.” ¡Hnei³ chie³ a³júan³ ni²taih⁴³! Ta² ñih¹ˉ³ liah⁴ si⁵lei⁴ jm² con⁴juah⁴ lei³ ñi⁴jeu⁵, i² sa⁴ŋangh⁴ˉ³ henh⁴ hnie³⁴ ra³juah⁴ la⁴jeg³⁴ i⁴júan³ lei³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Chie³ hlangh² tionh² jian³ a³sa⁴ni²taih⁴³ m²³ i⁴lei⁴ ua³júah². A⁵sie⁴³ ua³júah² ma⁵li⁴lei⁴ i⁴seg³⁴, con³ ua³júah² i⁴a⁴leg³⁴ i²con²³ Jonás a³sain² hain⁴pa². I² jon³ a⁴tai³⁴ Jesús quieh¹i³ tionh², ŋo³⁴i³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","I² con³ma²a⁴tyie³⁴ chie³ quian¹i³ tionh² ta⁵hŋoh³ jm³ñei³, jon³ ua⁴conh⁵ tsei⁴³i³ i⁴ma²can³⁴i³ a²hei⁴³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Jeh³²; jianh³ˉ³ júan² hnei³ o¹sieh³² hei⁴³ñih¹ tionh²ˉ³ quieh¹ fariseo jian³ saduceo tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jon³ a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―Si²hleh²i³ jau²³ ne³ quie¹ sa⁴le²ˉ¹ a²hei⁴³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Quie¹ ñi³ Jesús co³hei²tsei³ i⁴ti²júan³i³, jon³ a⁴juah⁴i³: ―Hnei³ chie³ a³sa⁴hain⁴ hlion⁴, ¿e⁴le³⁴ co³hei²tsei³ ti²júanh³ˉ³ i⁴sa⁴quianh²ˉ³ a²hei⁴³ñih¹ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿O⁴ sa⁴ra⁵ŋangh⁴ pi¹ hnei³ jian³ o⁴ sa⁴tyon²³ hoh⁴³ˉ³ liah⁴ i⁴a⁴leg³⁴ hña⁴ a²hei⁴³ñih¹ jon³ jen² hña⁴ mai²³ a³ñih³, jian³ jah⁴ a²mh³ta²³ o¹leuh² a⁴jaih¹ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jian³ ¿o⁴ sa¹ tyon²³ hoh⁴³ˉ³ liah⁴ a⁴leg³⁴ quie³⁴ a²hei⁴³ñih¹ jon³ jen² quin⁴ mai²³ chie³, jian³ jah⁴ a²mh³ta²³ o¹leuh² a⁴jaih¹ˉ³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Liah⁴ cúan²³ sa⁴li⁴ŋangh⁴ˉ³ quie¹ a⁵sia³ ma²hleh³ˉ⁴ nei² quieh¹ a²hei⁴³ñih¹, con³ma²a⁴jeu³⁴ˉ⁴ hnei³ i⁴jianh³ˉ³ júanh²ˉ³ o¹sieh³² hei⁴³ñih¹ quieh¹ fariseo jian³ saduceo tionh²? ");
INSERT INTO cucNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","I² jon³ ra⁵ŋang⁴i³ tionh² i⁴a⁵sia³ a⁴hleh⁴i³ nei² quieh¹ o¹sieh³² hei⁴³ñih¹ o³tan² i⁴júan³⁴i³ jian³i³, quie¹ a⁴hleh⁴i³ nei² quieh¹ jau²³ i⁴he²³ fariseo jian³ saduceo pa². ");
INSERT INTO cucNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","I² con³ma²a⁴tyie³⁴ Jesús i²nie⁴³ jeu³ Cesarea quieh¹ Filipo, jon³ a⁴ŋangh³i³ chie³ quian¹, a⁴juah⁴i³: ―¿Hain³ juah⁴ chie³ tionh² i⁴lang⁴³ A³a⁴lang³⁴ Chie³ hain⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jon³ a⁴juah⁴i³ tionh²: ―Juan³ Tei³²pa² hnei³ juah⁴ ca³chion²³; jian³ ca³chion²³ juah⁴pa² hnei³ I³lie²³; jian³ i²ca³chion²³ juah⁴ i⁴langh⁴³ˉ³ Jeremías jian³ o⁴ jan³ a³sain² sang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―I² hnei³ tionh²ˉ³ ne⁵, ¿hain³ jnia⁴ juah⁴ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","I² jon³ a⁴ŋangh³ Si²úan¹ Pe³², a⁴juah⁴i³: ―Hnei³ langh⁴³ A³ma²ya⁴lion³² Chie³ hain⁴, A³jon⁴³ Jon⁴dai¹ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Tsei³⁴ jm² li⁴renh³ hnei³, Si²úan¹, a³jon⁴³ Jonás, quie¹ i¹jan³ chie³ sa⁴ma⁴jnia³² i⁴ne³ i²conh²ˉ³; Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵pa² a⁴he⁴ i⁴jon³ i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","I² jon³ jeu³⁴ˉ⁴ hnei³ liah⁴ i⁴sainh³ˉ³ Pe³², jian³ nei² a²caun² la³ seih¹ˉ⁴ cuah³ quien⁴; jian³ la⁴teg⁴ ua³pei⁴ quieh¹ húan³⁴ sa⁴cagh¹ jm² i²con²³ cuah³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jian³ cúa¹ˉ⁴ heih⁴³ i²conh²ˉ³ i⁴niah²ˉ³ o²hnei³² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵; la⁴jeg³⁴ i⁴sa⁴cúah²ˉ³ jeu³ i⁴lei⁴ cuah³²húa³⁴, a⁵sia³ cúa³⁴pa² A³cua⁴³ ñi⁴jeu⁵ liah⁴, jian³ la⁴jeg³⁴ i⁴cúah²ˉ³ jeu³, cúa³⁴pa² A³cua⁴³ ñi⁴jeu⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jon³ a⁴júan⁴i³ heih⁴³ i²con²³ chie³ quian¹ i⁴sa⁴sagh⁵i³ i¹jan³ i⁴lang⁴³ Jesús A³ma²ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Liah⁴ma²jm² jon³ ma⁴lie⁵ Jesús hleh² i²con²³ chie³ quian¹ i⁴hniah³ chie³⁴i³ ton³²nie⁴³ Jerusalén, jian³ i²si⁵quian⁴i³ hlion⁴ ma²eu⁴³ i⁴he³⁴ a³don⁵ ma⁴³teg²³, jian³ m³chie³ tyein², jian³ a²teg²³ quian¹ lai²³ tionh². Jian³ hniah³ jaun⁴i³ jian³ hyon⁴³i³ tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jon³ a⁴te¹ Pe³² quieh¹i³ ta⁵co⁴³ meih³, i² jon³ a⁴sagh⁴³i³ Jesús ta² sa⁴cúan²³ li⁴lei⁴ la⁴ne³, a⁴juah⁴i³: ―¡Júan² hnei³ i⁴henh²ˉ³ húanh⁴³, hnei³ Se³ño²³! ¡Sa⁴ua²jainh⁴³ hnei³ la⁴ne³! ");
INSERT INTO cucNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","I² jon³ ua⁵lang⁴ Jesús, a⁴sagh⁴³i³ Pe³²: ―¡Quein⁴³ hnei³ i²gm⁴ i²con²³ˉ⁵, hnei³ a⁵lainh³², quie¹ hnoh³ˉ³ júan³²ˉ⁴ i⁴hlagh³²! A⁵sia³ co³hei²tsei³ quieh¹ Jon⁴dai¹ júanh³ˉ³, co³hei²tsei³ quieh¹ chie³pa² júanh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","I² jon³ a⁴juah⁴ Jesús i²con²³ chie³ quian¹: ―Juah⁴ne³ sian³ a³hnie³⁴ si⁴tyein⁵ coh⁵cah³ˉ⁴, hniah³ ma⁵hain³i³ tsei⁴³ i²con²³ hña³, jian³ hniah³ can³⁴i³ ma²eu⁴³ jian³ jia²³i³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","La⁴jang³⁴ a³hnie³⁴ lion⁴ m⁵cu³ quieh¹, si⁵hain⁴i³; jian³ la⁴jang³⁴ a³si³hain⁴ m⁵cu³ quieh¹ nei² quien⁴ˉ⁴, hyieh⁴i³ m⁵cu³ quieh¹ i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Quie¹ ¿henh⁴ ta¹ tei⁴³ i²con²³ jan³ chie³ juah⁴ne³ laih⁴i³ la⁴tan² m⁵cu³ la³, jian³ si⁵hain⁴ m⁴tyi⁴ quieh¹i³ i²a⁴toh⁴? ¿I² henh⁴ li⁴hmah² quieh¹ m⁴tyi⁴ quieh¹i³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Quie¹ jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴ i⁴quian³i³ joh¹ quieh¹ Jmai³i³ jian²³i³ ángel quian¹, ma²jon³ ma⁵hmah³²i³ quieh¹ con⁴jan³ con⁴juah⁴ liah⁴ a⁴júan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, ca³chion²³ hnei³ a³tionh² i²la³ sa⁴jaunh⁴ˉ³ naih⁵i² sa⁴jenh³²ˉ³ A³a⁴lang³⁴ Chie³ hain⁴ jionh⁴i³ i⁴júanh⁴³i³ i⁴quian³i³ heih⁴³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","I² con³ma²ua⁴jeu³² jñei⁴ jm² jon³, jon³ jian³ Jesús Pe³², Jacobo jian³ Juan²³ reunh¹i³, jian³i³ jmah³ a³hain⁴ la⁴teg⁴ con³ nei² mah⁴ ñei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","I² jon³ a⁴sang²³i³ ta⁵nei² a³hain⁴ tionh², ra⁵joh¹ ma³nei²i³ liah⁴i² joh¹ hyie³, jian³ ra⁵tie³ a²cúan³i³ liah⁴i² tie³ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jon³ ma⁴jnia³² M³se²³ jian²³ I³lie²³ i²con²³i³ tionh² a³ti²tya²³ jau²³ jian²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","I² jon³ a⁴juah⁴ Pe³² i²con²³ Jesús: ―Hnei³ Se³ño²³, ¡ta² re³ quie¹ tieh²ˉ¹ i²la³! A¹juah⁴ne³ hnoh³ˉ³, júan³² jnie³² hneng³ cuah²hnei⁴³ peih¹; con³ quianh³ˉ³, con³ quieh¹ M³se²³, jian³ con³ quieh¹ I³lie²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ta¹la⁴ ma²si²hleh² pi¹ Pe³², jon³ ja³⁴ con³ o¹jnai⁴³ joh¹, a⁴quionh³ a³hain⁴ tionh², jian³ je¹ o¹jnai⁴³ jon³ ja³⁴ con³ jau²³ ho³², i⁴juah⁴i³: ―A³ne³pa² A³jon³⁴ˉ⁴ a³hno⁵ˉ⁵, a³júan³ i⁴teg³ tsei³⁴ˉ⁴; nai³ hnei³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","I² con³ma²a⁴nau⁴ chie³ quian¹ Jesús ho³² a³hain⁴, jon³ a⁴quionh³i³ húa³⁴ ta⁵ra³hain²³i³, jian³ ta² yi⁴hang³²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","I² jon³ ŋo³⁴ Jesús hlonh²i³, a⁴tei⁴i³ si¹cúa³ a³hain⁴, a⁴juah⁴i³: ―No³ hnei³ tionh²ˉ³; a⁵júan³ hnei³ canh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","I² con³ma²a⁴sieh³i³ nei² tionh², jon³ a⁵sion⁴³ a³ma⁵a³jen³i³, hña³pa² Jesús júah³ si²sainh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","I² con³ma²ti²jyon²³i³ mah⁴ tionh², jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³, a⁴juah⁴i³: ―A⁵jeu⁴³ hnei³ i¹jan³ henh⁴ i⁴ma⁴jnia³² i²conh²ˉ³ tionh²ˉ³ la⁴conh⁴i² hyon⁴³ A³a⁴lang³⁴ Chie³ hain⁴ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jon³ a⁴ŋang⁴ chie³ quian¹i³ i²con²³i³, a⁴juah⁴i³: ―I² jon³ ne⁵, ¿e⁴le³⁴ juah⁴ a²teg²³ quian¹ lai²³ i⁴hniah³ jia²³ I³lie²³ ñeih³²jia⁴³? ");
INSERT INTO cucNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I² jon³ a⁴ŋangh³ Jesús i²con²³i³, juah⁴i³: ―I⁴chie⁴³pa² jia²³ I³lie²³ ñeih³²jia⁴³ i⁴ya⁴júanh¹i³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jian³ jeu³⁴ˉ⁴ hnei³ liah⁴ i⁴ma³cuan²³ I³lie²³, i² sa⁴ra⁵cu²³ chie³ quieh¹i³, quie¹ a⁴júan⁴i³ i²con²³i³ la⁴conh⁴ i⁴m²³ tsei⁴³i³ tionh². Jian³ la⁴ne³ he³⁴i³ ma²eu⁴³ i²con²³ A³a⁴lang³⁴ Chie³ hain⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jon³ ra⁵ŋang⁴ chie³ quian¹i³ i⁴a⁴hleh⁴i³ i²con²³i³ nei² quieh¹ Juan³ Tei³². ");
INSERT INTO cucNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","I² con³ma²a⁴tyie³⁴i³ i²tionh² chie³ jeun⁴³, jon³ ja³⁴ jan³ a³ñih³, a⁴si⁴jnei⁵i³ ta⁵nei²i³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Hnei³ Se³ño²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ a³jon³⁴ˉ⁴, quie¹ jaun⁴ ñei⁴i³ jian³ can²³i³ hlion⁴ ma²eu⁴³; quie¹ hlion⁴ nie⁴³ cangh²i³ je¹ o¹jyi³ loh⁴³ jian³ joh⁴³ jm³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ma³ni²jan⁴³ˉ⁴ i²con²³ chie³ quianh³ˉ³ tionh², i² sa⁴a⁴cagh¹i³ jm² júan³⁴i³ i⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―¡Hnei³ a³sa⁴hain⁴ tionh² jian³ a³hlangh²! ¿Hain³la⁴conh⁴a² sa⁴hniah³ tie³²ˉ⁴ jian²³ˉ⁵ hnei³ tionh²ˉ³, liah²? ¿Jian³ hain³la⁴conh⁴a² sa⁴hniah³ cúah²ˉ⁵ tsei³⁴ i²conh²ˉ³ tionh²ˉ³? Jian⁴³ hnei³ yein³ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","I² jon³ a⁴jain³⁴ Jesús m⁴tyi⁴ hlagh³² hain⁴, jon³ ua⁵hag⁴³ naih⁵ ni²tsei⁴³ a³maih² hain⁴, jon³ a⁴huan⁴ quieh¹ a³peih¹ hain⁴ lia⁴ o²ra³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","I² jon³ a⁴tyie³⁴ chie³ quian¹ Jesús hlonh²i³ con³ i²sa⁴tionh² chie³, a⁴juah⁴i³: ―¿E⁴le³⁴ sa⁴a⁴cangh³² jnie³² jm² ma²tyi² jnie³² m⁴tyi⁴ hlagh³² jon³? ");
INSERT INTO cucNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Quie¹ sa⁴re³ hainh⁴pa² hnei³. I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, juah⁴ne³ ma²tei⁴³ i⁴hainh⁴ˉ³ tionh²ˉ³ conh⁴i² tei⁴³ con³ o¹m⁴ peih¹ quieh¹ mostaza, jon³ ma²li⁴jeuh³²ˉ³ mah⁴ ne³: “Quein⁴³ hnei³ i²ne³, cua³ hnei³ ta⁵jno³”; i² jon³ chie³⁴ ta⁵co⁴³. I¹con³ a⁵sia³ i⁴sia³ juah⁴ i⁴sa⁴li⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","I² m⁴tyi⁴ hlagh³² la⁴jon³ ne⁵, sa⁴li⁴ua⁵hag⁴³ a¹juah⁴ne³ sa⁴mh²i³ Jon⁴dai¹ jian³ i⁴júan³i³ he² i⁴sa⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","I² con³ma²tionh²i³ húa³⁴ Galilea, jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Cúan⁵i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","I² jon³ jŋangh³i³, jian³ hyon⁴³i³ tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³. I² con³ma²a⁴nau⁴i³ tionh² jau²³ jon³, ta² ra⁵chionh⁴ tsei⁴³i³ hlion⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","I² con³ma²a⁴tyie³⁴i³ je¹jeu³ Capernaum tionh², jon³ a⁴tyie³⁴ a³jai²³ o¹cau³² quieh¹ cuah³júah² i²con²³ Pe³², a⁴sagh⁴³i³ Pe³², juah⁴i³: ―¿O⁴ cúa²³ a²teg²³ quianh³ˉ³ o¹cau³² i⁴hain²³i³ cuah³júah²? ");
INSERT INTO cucNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","I² jon³ a⁴juah⁴ Pe³²: ―Jen³⁴. Con³ma²a⁴hei³⁴ Pe³² jauh³², jon³ ma³sia² a⁴hleh⁴ Jesús i²con²³i³, a⁴juah⁴i³: ―¿Liah⁴ lainh⁴ˉ³, Si²úan¹? ¿Hain³ i²con²³ can²³ re¹ quian¹ m⁵cu³ la³ tionh² hmah¹ impuesto jian³ cau³² i⁴hain²³i³? ¿O⁴ i²con²³ si³jon⁴³i³ jian³ o⁴ a³sang²³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","I² jon³ a⁴juah⁴ Pe³²: ―I²con²³ chie³ sang²³pa². I² jon³ a⁴juah⁴ Jesús liah⁴: ―I⁴jon³ sa⁴hniah³ ma⁵hmah³² si³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","I² canh⁴a² sa⁴jain³⁴ tsei⁴³i³ ne⁵, cua³ la⁴teg⁴ jm³ñei³, ua⁴tien³ a²ma³cau³² joh⁴³; i² jon⁴³júa³² a³jonh⁴ˉ³ co⁴ra⁴lie⁵, sianh³², nia¹ ho³². I² tei⁴³i² a⁴niah¹ˉ³, jon³ tyanh³²ˉ³ con³ o¹cau³² tie³; quien²³ hnei³, jon³ cúah³²i³ hnei³ nei² quien⁴ˉ⁴ jian³ nei² quianh³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jm² jon³ a⁴tyie³⁴ chie³ quian¹i³ i²con²³ Jesús, juah⁴i³: ―¿Hain³ a³tyein² júanh⁴³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵? ");
INSERT INTO cucNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jon³ a⁴teh³ Jesús jan³ a³peih¹ ñih³, a⁴sainh⁴i³ jen²i³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a⁴juah⁴i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, juah⁴ne³ sa⁴lainh⁴ˉ³ i⁴seg³⁴ jian³ i⁴júanh³²ˉ³ la⁴jan³ a³peih¹, sa⁴li⁴cúah²ˉ³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","I² la⁴ne³ jon³, a³hain⁴ a³júan³⁴ ti⁴ñeih⁵ liah⁴i² lang⁴³ a³peih¹ la³, a³hain⁴pa² tyein² júanh⁴³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jian³ la⁴jang³⁴ a³hyein⁴³ jan³ a³peih¹ a³la⁴la³ nei² quien⁴ˉ⁴, jnia⁴pa² hyei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Jian³ la⁴jang³⁴ a³júan³⁴ i⁴tianh⁵ jan³ si³peih¹ la³ chie³² a³ti²hain⁴ i²con²³ˉ⁵, eu⁴³a² re³ ma²hñei³⁴i³ lau² con³ a²hnai³² ya¹hñei⁴³ con³ a²caun² pa¹. Jon³ si⁵tiah³i³ joh⁴³ jm³ñih¹ la⁴teg⁴ i²jeuh³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ti⁴³ jeu²³ a³m⁵cu³ i⁴júan³i³ i⁴tianh⁵ chie³ chie³²! Quie¹ i⁴chie⁴³pa² hniah³ jia²³ i⁴júan³⁴ i⁴tianh⁵ chie³ chie³². Jian³ ¡ta² jeu²³ a³hain⁴ a³júan³ i⁴tianh⁵i³! ");
INSERT INTO cucNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’I⁴jon³ juah⁴ne³ júan³⁴ si¹cúah³ˉ³ jian³ o⁴ si¹tagh¹ˉ³ i⁴tianh⁵ˉ³ chie³², queih¹ hnei³, tien³ hnei³ i²gm⁴; quie¹ eu⁴³ re³ quianh³ˉ³ i⁴hyeih²ˉ³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ i⁴langh⁴³ˉ³ a³tein⁴ jian³ o⁴ a³leun²³, la⁴conh⁴a² i⁴si⁵hainh⁴ˉ³ je¹ o¹jyi³ loh⁴³ sa⁴ton³ jm² ua²a⁴chia³⁴ i⁴ni²hyan³² cúah³tagh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jian³ juah⁴ne³ júan³⁴ m⁴mah²ˉ³ i⁴tianh⁵ˉ³ chie³², tyi² hnei³, tien³ i²gm⁴; quie¹ eu⁴³ re³ quianh³ˉ³ i⁴hyeih²ˉ³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ i⁴ho³ co³jo³² m⁴mah²ˉ³, la⁴conh⁴a² i⁴si⁵hainh⁴ˉ³ qui⁴jeu⁵ je¹ o¹jyi³ loh⁴³ i⁴ni²hyan³² m⁴mah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Jianh³ˉ³ júan² hnei³ tionh²ˉ³ i⁴sa⁴ronh⁵ˉ³ jeu³ jan³ si³peih¹ a³la⁴la³. Quie¹ jeu³⁴ˉ⁴ hnei³ i⁴tionh² ángel quian¹i³ ta⁵nei² Neih³ˉ⁴ la⁴jeg³⁴ nie⁴³ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Quie¹ cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ ua⁵lion³²i³ a³ma³ua⁵hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Liah⁴ lainh⁴ˉ³ nei² la³? Juah⁴ne³ sian³ jan³ chie³ a³ma²tionh² nia⁴lon⁴ a⁵a³siah³ quian¹, i² jon³ ua⁵conh⁴ jan³, ¿o⁴ a⁵sia³ tain³⁴i³ jan³ a²sa⁴tain⁴³ nia⁴lon⁴ a⁵a³siah³ hain⁴ i²tionh², lainh⁴ˉ³, i⁴chie³⁴i³ si⁵hniah³i³ ta⁵je¹sieh³² mah⁴ a³hain⁴ a³ma²ua⁵conh⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","I⁴chie⁴³pa² juah³ˉ⁴, juah⁴ne³ a⁴chianh¹i³ jah⁴, ta² si³hyonh³i³ lei⁴ nei² quieh¹ jan³ hain⁴ la⁴conh⁴a² jan³ a²sa⁴tain⁴³ nia⁴lon⁴ hain⁴ a³tionh² tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jian³ la⁴ne³ liah⁴ sa⁴hnie³⁴ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵ juah⁴ i⁴si⁵hain⁴ si³peih¹ la³ i¹jan³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Jian³ juah⁴ne³ a⁴tanh⁴ jan³ a³reunh³ˉ³ chie³² i²conh²ˉ³, cua³ ua⁴saih³²i³ hnei³ liah⁴ a⁴júan⁴i³ i²conh²ˉ³, hnei³ jian³ hei⁴i³. I² juah⁴ne³ a⁴can³⁴i³ jau²³ ne⁵, jon³ a⁴langh³ˉ³ a³reunh³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","I² juah⁴ne³ sa⁴a⁴can³⁴i³ jau²³ ne⁵, jon³ jian⁴³ hnei³ jan³ jian³ o⁴ on³⁴ jianh²ˉ³ i⁴ua²jenh³²ˉ³ a³hain⁴, canh⁴a² ta⁵nei² on³⁴ on³ a³tei⁴³ nei² hain⁴ hlenh³²i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","I² juah⁴ne³ sa⁴a⁴ron⁴³i³ jeu³ a³hain⁴ tionh², jon³ saih³²i³ júah³ cuah³; i² juah⁴ne³ sa⁴a⁴nau⁴i³ jau²³ quieh¹ cuah³ ne⁵, jon³ hniah³ jenh³²i³ hnei³ la⁴jan³ chie³ sang²³ a³sa⁴cm²³ Jon⁴dai¹ jian³ o⁴ la⁴jan³ a³can²³ hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴jeg³⁴ i⁴sa⁴cúah²ˉ³ jeu³ i⁴lei⁴ nei² cuah³²húa³⁴ la³, sa⁴cúa³⁴pa² ñi⁴jeu⁵ liah⁴, jian³ la⁴jeg³⁴ i⁴cúah²ˉ³, cúa³⁴pa² ñi⁴jeu⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Conh⁴liah⁴ jeu³⁴ˉ⁴ hnei³ liah⁴ i⁴seg³⁴, juah⁴ne³ on³⁴ hnei³ hyon³ hoh⁴³ˉ³ nei² cuah³²húa³⁴ la³ i⁴mh³²ˉ³ co³nai² ua²henh⁴pa² Jon⁴dai¹, jon³ júan³⁴ Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵ i⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Quie¹ jainh¹ i²ti²ŋangh³ on³⁴ on³ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴, i²jon³ sainh⁴³ jnia⁴ jen²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jon³ ŋo³⁴ Pe³² hlonh²i³, a⁴juah⁴i³: ―Hnei³ Se³ño²³, juah⁴ne³ a⁴tanh⁴ a³reunh³ˉ⁴ chie³² i²con²³ˉ⁵, ¿jah⁴ nie⁴³ hniah³ hain²³ˉ⁵ chie³²? ¿O⁴ teg⁴ quie³⁴ nie⁴³pa²? ");
INSERT INTO cucNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―A⁵sia³ juah³ˉ⁴ teg⁴ quie³⁴ nie⁴³, quie¹ hniah³ hainh³²ˉ³ teg⁴ to⁴lo⁵quia⁴ ni²tsei¹ quie⁴ nie⁴³ quie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’I⁴jon³ liah⁴i² tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ jan³ re¹ a³júanh² cuenta quieh¹ jian²³ a³cúa²³ cúa³tag³² i²con²³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","I² con³ma²ma⁴lie⁵i³ a⁴júanh³i³ cuenta, jon³ quian³i³ jan³ a³ren³ quia³⁴ mai²³ o¹cau³² talento i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","I² ma⁵sa⁴sia³ quieh¹ a³hain⁴ li⁴ma⁵hmah³². Jon³ a⁴júan⁴ jeu³²i³ heih⁴³ i⁴hnang⁵i³ a³hain⁴ liah⁴ma³jian²³ a³m⁴ quian¹ jian³ liah⁴ma³jian²³ si³jon⁴³ jian³ la⁴jeg³⁴ i⁴sia³ quieh¹i³, canh⁴a² li⁴ma⁵hmah³²i³ i⁴ren³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jon³ a⁴si⁴jnei⁵ a³cúa²³ cúa³tag³² hain⁴ ta⁵nei² jeu³², a⁴mh³i³ jeu³² jang³⁴ tsei⁴³, juah⁴i³: “Hnei³ a³don⁵, júanh³ júan² hoh⁴³ i²con²³ˉ⁵, ma²hmah³² pe²³ˉ⁴ quianh³ˉ³ la⁴jeg³⁴ i⁴ren³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","I² jon³ joh³ ñei⁴ tsei⁴³ jeu³²i³ i²con²³ a³cúa²³ cúa³tag³² hain⁴, a⁴lion³i³, a⁴ma⁴hain³i³ tsei⁴³ la⁴jeg³⁴ i⁴ma²ren³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jon³ ua⁵hag⁴³ a³cúa²³ cúa³tag³² hain⁴; i² con³ma²ua⁵hag⁴³i³, jon³ a⁴jainh³i³ i²jan³ a³cúa²³ cúa³tag³² reunh¹ a³ma²ren³ nia⁴lo⁴ o¹cau³² denario quieh¹i³. I² jon³ a⁴sanh³i³ a³hain⁴, a⁴cuh³i³ lau², a⁴sagh⁴³i³: “¡Ma⁴hmah³² hnei³ i⁴renh³ˉ³ jon³ quien⁴ˉ⁴!” ");
INSERT INTO cucNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jon³ a⁴si⁴jnei⁵ a³cúa²³ cúa³tag³² reunh¹i³ hain⁴ ta⁵nei² a³ma²ren³ quieh¹i³, a⁴mh³i³, juah⁴i³: “Júanh³ júan² hoh⁴³ i²con²³ˉ⁵, ma²hmah³² pe²³ˉ⁴ quianh³ˉ³ la⁴jeg³⁴ i⁴ren³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","I² hei⁴i³ ne⁵, a⁵sia³ liah⁴ hnie³⁴i³, quie¹ ni²tianh³i³ a³hain⁴ ni⁴ñi²³ la⁴conh⁴i² ma⁴hmah³²i³ i⁴ren³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jian³ a⁴je³⁴ la⁴jang³⁴ a³cúa²³ cúa³tag³² reunh¹ liah⁴ a⁴leg³⁴; ta² ra⁵chionh⁴ tsei⁴³i³ hlion⁴ mai²³, jon³ ua⁵han²i³, ua⁵júan⁴i³ jau²³ i²con²³ jeu³² tionh² la⁴jeg³⁴ i⁴a⁴leg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","I² jon³ a⁴teh³ jeu³²i³ a³hain⁴, a⁴juah⁴i³: “¡Hnei³ a³cúa²³ cúa³tag³² hlangh²! A⁴ma⁴hain¹ˉ⁴ tsei³⁴ la⁴jeg³⁴ i⁴ma²renh³ˉ³ quien⁴ˉ⁴ quie¹ ta⁵la⁴ a⁴mh³²ˉ³ jnia⁴ jang³⁴ hoh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿O⁴ a⁵sia³ hniah³ ma²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ a³cúa²³ cúa³tag³² reunh³ liah⁴i² joh³ ñei⁴ tsei³⁴ˉ⁴ i²conh²ˉ³, lainh⁴ˉ³?” ");
INSERT INTO cucNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I² jeu³²i³ ne⁵, ta² jain²³ tsei⁴³i³, jon³ a⁴cúanh³i³ a³hain⁴ joh⁴³ cúa³ a³he²³ ma²eu⁴³ la⁴conh⁴i² ma⁵hmah³²i³ la⁴jeg³⁴ i⁴ren³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Jian³ la⁴ne³ júan³⁴ Neih³ˉ⁴ a³cua⁴³ ñi⁴jeu⁵ i²conh²ˉ³ tionh²ˉ³, juah⁴ne³ sa⁴hainh⁵ˉ³ i⁴jang³⁴ hoh⁴³ con⁴jan³ hnei³ chie³² quieh¹ a³m⁵cu³ reunh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","I² con³ma²a⁴toh⁴ i⁴a⁴hleh⁴ Jesús jau²³ ne³, jon³ ua⁵hag⁴³i³ húa³⁴ Galilea, a⁴tyie³⁴i³ i²tei⁴³ húa³⁴ Judea, jo³² ta⁵hŋoh³ jm³ Jordán, ta⁵jia²³ hyie³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jian³ jeun⁴³ chie³ ua⁵han² coh⁵cah³²i³, i² jon³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ a³chieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","I² jon³ a⁴tyie³⁴ co⁴meih³ fariseo hlonh² Jesús, a⁴con²³i³ jau²chie⁴³ i²con²³i³, a⁴sagh⁴³i³: ―¿O⁴ ra³cúa²³ i⁴li⁴tyon⁴ a³ñih³ jian²³ a³m⁴ quian¹ ua²hain³ nei²? ");
INSERT INTO cucNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ ma²jyi³ i⁴ra³juah⁴ i⁴a⁴júan⁴³ Jon⁴dai¹ co⁴ra⁴lie⁵ a³ñih³ jian³ a³m⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jian³ a⁴juah⁴i³: “I⁴jon³da³ quein²³ a³ñih³ i²con²³ jmai³sie²³ i⁴cua²³i³ jian²³ a³m⁴ quian¹. Jon³ lain⁴ li⁵uan⁴i³ la⁴jon³ jan³ chie³.” ");
INSERT INTO cucNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","I² la⁴ne³ a⁵sie⁴³ ma⁵lang⁴³i³ on³⁴, quie¹ lang⁴³i³ jan³pa² júah³. Quie¹ la⁴conh⁴ i⁴a⁴júan⁴ Jon⁴dai¹ i⁴a⁴sanh⁴i³, i¹jan³ chie³ sa⁴li⁴tyon³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jon³ a⁴juah⁴ a³hain⁴ tionh²: ―Juah⁴ne³ la⁴ne³, ¿e⁴le³⁴ a⁴júan⁴ M³se²³ heih⁴³ i⁴cúah³i³ a³m⁴ con³ ma²jyi³ i⁴ra³juah⁴ i⁴ma³a⁴tyon⁴i³? I² jon³ ton²³i³ a³m⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―A⁴cúa⁴ M³se²³ jeu³ la⁴ne³ quie¹ i⁴eu⁴³ huah³ m⁴tyi⁴ quianh³pa² hnei³ tionh²ˉ³; i² liah⁴ma²ra⁴lie⁵ ne⁵, a⁵sia³ ma²leg⁴³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jon³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³tyon⁴ jian²³ a³m⁴ quian¹ i⁴sa⁴sia³ nei² juah⁴ i⁴hleh⁴³ a³sang²³ quieh¹ a³m⁴, i² juah⁴ne³ sanh⁴i³ jian²³ a³sang²³ ne⁵, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ i³cúa³ chie³; jian³ a³ñih³ a³sanh⁴ jian²³ a³tyon²³ jian²³ i³cúa³, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ i³cúa³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jon³ a⁴juah⁴ chie³ quian¹i³ tionh²: ―Juah⁴ne³ la⁴ne³ leg⁴³ i²con²³ a³ñih³ jian²³ a³m⁴ quian¹, eu⁴³a² quein⁴³ sa⁴hniah³ sanh⁴ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―A⁵sian⁴³ la⁴jang³⁴ li⁴hyei³⁴ jau²³ ne³. Quie¹ jmah³ a³hain⁴pa² tionh² a³a⁴cúa⁴ Jon⁴dai¹ i²con²³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Quie¹ sian³ a³ñih³ sa⁴hnio³⁴ a³m⁴, la⁴ne³ ra⁵sian³i³; jian³ sian³ a³ñih³ a³sa⁴hnio³⁴ a³m⁴ i⁴a⁴júan⁴ chie³ teh⁴³ quieh¹i³; conh⁴liah⁴ sian³ a³ñih³ a³júan³ co³hei²tsei³ hña³ i⁴sa⁴hnio³⁴i³ a³m⁴ nei² quieh¹ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. A³hain⁴ a³lei⁴ li⁴hyei³⁴ jau²³ la³, ua²hyei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","I² jon³ jian³i³ co⁴meih³ si³maih² peih¹ ta⁵nei² Jesús, canh⁴a² tei³⁴i³ si¹cúa³ jian³ mh³i³ Jon⁴dai¹ nei² quieh¹i³; i² chie³ quian¹ Jesús ne⁵, a⁴jain³⁴i³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","I² jon³ a⁴juah⁴ Jesús: ―Cúa² hnei³ jeu³ i⁴ya⁴han² si³maih² peih¹ i²con²³ˉ⁵, a⁵hnia³ hnei³; quie¹ a³la⁴ne³ tionh² han⁵ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jon³ a⁴tei³⁴i³ si¹cúa³ i²con²³ si³maih² peih¹ hain⁴, ma²jon³ ŋo³⁴i³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","I² jon³ a⁴tyie³⁴ jan³ i²con²³i³, a⁴juah⁴i³: ―Hnei³ A²teg²³ tsein²³, ¿henh⁴ i⁴tsei³⁴ hniah³ júan³²ˉ⁴ canh⁴a² li⁴sia³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quien⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿E⁴le³⁴ teh⁵ˉ³ jnia⁴ a³tsein²³? Quie¹ i¹jan³ a³tsein²³ sa⁴sian³, jan³ Jon⁴dai¹pa². Jian³ juah⁴ne³ hnoh³ˉ³ hyanh⁴ˉ³ m⁵cu³ tsei²³, hie² hnei³ heih⁴³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jon³ a⁴juah⁴ a³hain⁴: ―¿Hain³ heih⁴³ ne⁵? Jon³ a⁴juah⁴ Jesús: ―I⁴la³pa²: A⁵jŋangh² hnei³ chie³; a⁵hlenh⁴³ hnei³ a³sa⁴lang⁴³ i³cúah³ˉ³; a⁵júan³ hang³; a⁵hleh³ hnei³ jau²ta³jau²³ nei² quieh¹ i¹jan³; ");
INSERT INTO cucNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma⁴con³² hnei³ naih⁴³sieh³; jian³ ma⁴hno³² hnei³ m⁵cu³ reunh³ liah⁴i² hnoh⁴³ˉ³ húanh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jon³ a⁴juah⁴ a³maih² hain⁴ i²con²³i³: ―La⁴jeg³⁴ heih⁴³ ne³ ma⁵tei³²ˉ⁴ liah⁴ma²maih⁴³ˉ⁴. ¿Henh⁴a² júah³ si³hain⁴ quien⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Juah⁴ne³ hnoh³ˉ³ lainh⁴ˉ³ a³tsein²³ o³tan², hniah³ cúah²ˉ³, cua³ ua⁴hnang² la⁴jeg³⁴ i⁴sia³ quianh³ˉ³, ma²jon³ cúah³²ˉ³ a³ti⁴ñei³ o¹cau³² jon³, canh⁴a² li⁴sia³ i⁴quein⁴³ hlion⁴ quianh³ˉ³ ñi⁴jeu⁵; ma²jon³ niah²ˉ³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","I² con³ma²a⁴nau⁴ a³maih² hain⁴ jau²³ jon³, jon³ ŋah³i³ chionh⁴ tsei⁴³i³ quie¹ eu⁴³ hlion⁴ sia³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jon³ a⁴juah⁴ Jesús i²con²³ chie³ quian¹ tionh²: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, ti⁴³ jeuh⁴³ nie⁴³ i⁴si⁵hei⁴ jan³ a³jlanh² naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Conh⁴liah⁴ juah³ˉ⁴ liah⁴, i⁴eu⁴³a² sa⁴jeuh⁴³ i⁴si⁵hei⁴ jan³ a²ca³me²llo³ to³ a²ma³cau³² la⁴conh⁴a² i⁴hei⁴ jan³ a³jlanh² naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","I² con³ma²a⁴nau⁴ chie³ quian¹i³ jau²³ jon³, ta² co³ ŋo³⁴ tsei⁴³i³ tionh², a⁴juah⁴i³: ―Juah⁴ne³ la⁴ne³, ¿hain³ pi² lei⁴ li⁴lion⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","I² jon³ a⁴jen³ Jesús a³hain⁴ tionh², a⁴sagh⁴³i³: ―Quie¹ chie³ tionh² sa⁴tieh¹i³ li⁴júan³⁴i³, i²con²³ Jon⁴dai¹ ne⁵, la⁴jeg³⁴pa² li⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Jeh³², ma³a⁴tien² jnie³² la⁴jeg³⁴ jian³ ma³ya¹han² jnie³² coh⁵cah³²ˉ³. ¿Henh⁴ li⁴sia³ quian⁴ jnie³² ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴teg⁴i² ma³a⁴lag³⁴ m⁵cu³ la³, jian³ cua³⁴ A³a⁴lang³⁴ Chie³ hain⁴ nei² a²ma³sei² tyein² a³quian³ joh¹, jon³ hnei³ tionh²ˉ³ liah⁴ a³si⁴tyeinh³²ˉ³ coh⁵cah³ˉ⁴ neih²ˉ³ quia⁵teun⁴ a²ma³sei² jlanh² i²júanh²ˉ³ heih⁴³ i²con²³ quia⁵teun⁴ sa¹jeun³ Israel. ");
INSERT INTO cucNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jian³ a³hain⁴ a³ma³a⁴teinh³ tsei⁴³ a²hnei⁴³ quieh¹ jian³ o⁴ si³reunh¹i³, si³ñih³ si³m⁴, jian³ o⁴ jmai³i³ jian³ o⁴ sie²³i³, jian³ o⁴ a³m⁴ quian¹i³ jian³ o⁴ si³jon⁴³i³, jian³ o⁴ húa³⁴ quieh¹i³, la⁴jang³⁴ a³júan³⁴ la⁴ne³ nei² quien⁴ˉ⁴, hyei³⁴i³ nia⁴lo⁴ jeunh³ jian³ hyieh⁴i³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","I² jeun⁴³ a³ya¹jian⁴³ nei² tieh²la³ tang³⁴i³ ta³ra³pei¹; jian³ a³tionh² ta³ra³pei¹ tieh²la³ si⁵jian⁴³i³ nei². ");
INSERT INTO cucNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Quie¹ i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ jan³ chie³ a³ra³quia³ con³ je¹ júah³ quieh¹, a³ŋo²³ to⁵hie³ hion²³ ua⁵hyon³² a³si⁵júan⁴ ta¹ je¹ quieh¹ i⁴jnia² o¹m⁴ ya¹gm³jeh². ");
INSERT INTO cucNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","I² con³ma²a⁴júan⁴i³ re³ jian²³ a²mo²zo³ tionh² i⁴ma⁵hmah³²i³ con³ o¹cau³² denario con³ jm², ma²jon³ a⁴sai⁴i³ je¹ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Coh⁵ jon³ ua⁵hag⁴³ a³quieh¹ je¹ hain⁴ la⁴conh⁴ ni¹ñi³⁴, i² jon³ a⁴jen³i³ a³sang²³ a³ta² ti²tionh² je¹hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I² jon³ a⁴sagh⁴³i³: “Cua³ ua⁴júan² ta¹ je¹ quien⁴ˉ⁴ tionh²ˉ³, jon³ ma²hmah³²ˉ⁴ quianh³ˉ³ conh⁴ haih¹ li⁴hlianh²ˉ³.” Jon³ ua⁵han² a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Conh⁴liah⁴ ua⁵hag⁴³ a³quieh¹ je¹ hain⁴ la⁴conh⁴ i⁵hyie³ jian³ la⁴conh⁴ ni¹hneng³ ta⁵hlo⁴, ni²hyon³²i³ a³sang²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","I² con³ma²ua⁵hag⁴³i³ la⁴conh⁴ ni¹hña⁴, jon³ a⁴chianh¹i³ a³sang²³ a³sa⁴ti²júan³ ta¹, a⁴sagh⁴³i³ a³hain⁴ tionh²: “¿E⁴le³⁴ ta² ti²tionh²ˉ³ i²la³ i⁴sa⁴júanh³ˉ³ ta¹ la⁴tan² jm²?” ");
INSERT INTO cucNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jon³ a⁴juah⁴ a³hain⁴ tionh² i²con²³i³: “Quie¹ i¹jan³ sa⁴te²³ jnie³².” Jon³ a⁴juah⁴i³: “Cua³ ua⁴han² tionh²ˉ³ liah⁴ jon³, ua⁴júan² ta¹ je¹ quien⁴ˉ⁴, jon³ hyeih²ˉ³ hmah¹ quianh³ la⁴conh⁴ haih¹ li⁴hlianh²ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","I² ta⁵nai³ jon³, jon³ a⁴juah⁴ a³quieh¹ je¹ i²con²³ a³jian³ mozo: “Cua³ ua⁴te⁴³ hnei³ mozo tionh², jian³ ma⁴hmah³² hnei³ quieh¹i³, ma²lieh¹ˉ³ ma²hmah³²ˉ³ quieh¹ ñeih³² a³a⁴tyie³⁴ i²a⁴toh⁴, la⁴ne³ la⁴teg⁴ a³a⁴tyie³⁴ liah⁴ma²ra⁴lie⁵.” ");
INSERT INTO cucNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","I² con³ma²a⁴tyanh³ a³a⁴han⁵ la⁴conh⁴ ni¹hña⁴ hain⁴, a⁴hyei⁴i³ ma⁵con³ o¹cau³² denario quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","I² con³ma²a⁴tyanh³ a³a⁴han⁵ co⁴ra⁴lie⁵ hain⁴ tionh² liah⁴, ma²lain⁴i³ hyei³⁴i³ hlion⁴ pi¹; i² a⁴hyei⁴i³ ne⁵, ma⁵con³ o¹cau³² denario pa² a⁴hyei⁴i³ con⁴jan³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","I² con³ma²a⁴hyei⁴i³ o¹cau³² jon³, jon³ a⁴jain²³ tsei⁴³i³ tionh² i²con²³ a³quieh¹ je¹ hain⁴, ");
INSERT INTO cucNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","juah⁴i³: “A³a⁴han⁵ i²a⁴toh⁴ ne³ tionh², con³ o²ra³ tan²pa² a⁴júan⁴i³ ta¹, i² co³nai²pa² a⁴júanh²ˉ³ jian²³i³ jnie³²; i² jnie³² ne⁵, a⁴le¹ jnie³² ma²eu⁴³ la⁴tan² jm² jian³ i⁴tyei⁴ hyie³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","I² jon³ a⁴ŋangh³ a³quieh¹ je¹ hain⁴, a⁴juah⁴i³ i²con²³ jan³ a³hain⁴: “Hnei³ ming³²go⁴ quian³⁴ˉ⁴, a⁵sia³ hlagh³² a⁴júan³⁴ˉ⁴ i²conh²ˉ³. ¿O⁴ a⁵sia³ ra⁵hyon³ hoh⁴³ˉ³ i⁴li⁴hlianh²ˉ³ con³ o¹cau³² denario, heh⁵ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Janh³ hnei³ i⁴tainh⁴³ˉ³, jian³ tyanh⁴ˉ³. Quie¹ hno⁵ˉ⁵ ma²hmah³²ˉ⁴ co³nai² i²con²³ a³a⁴han⁵ i²a⁴toh⁴ ne³ liah⁴i² hlianh² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿O⁴ a⁵sia³ cúa²³ li⁴júan³²ˉ⁴ liah⁴ hyon³ tsei³⁴ˉ⁴ i⁴sia³ quien⁴ˉ⁴, lainh⁴ˉ³? ¿Jian³ o⁴ eu⁴³ hoh⁴³ˉ³ quie¹ i⁴tsei³⁴ tsei³⁴ˉ⁴?” a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jian³ la⁴ne³ a³ya¹jian⁴³ nei² tieh³²la³ tionh², tang³⁴ ta³ra³pei¹; jian³ la⁴jang³⁴ a³tionh² ta³ra³pei¹ liah⁴, tang³⁴ nei². Quie¹ jeun⁴³ ten², jian³ co⁴meih³pa² lang⁴³ a³ti²quianh². ");
INSERT INTO cucNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","I² con³ma²hein² Jesús jeu³ ŋo³⁴i³ Jerusalén, jon³ a⁴teh³i³ quia⁵teun⁴ chie³ quian¹ con³ ta⁵co⁴³, a⁴juah⁴i³ i²con²³i³: ");
INSERT INTO cucNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jeh³², tieh²la³ tieh²ˉ¹ jeu³ chie²³ˉ¹ Jerusalén, i²jon³ cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³ tionh², jian³ queih³i³ heih⁴³ i⁴jaun⁴i³, ");
INSERT INTO cucNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","jian³ cúanh⁴³i³ a³hain⁴ joh⁴³ cúa³ a³sa⁴lang⁴³ judío canh⁴a² ji⁵ŋang⁴i³, jian³ po³⁴i³, jian³ tion³⁴i³ crau¹ liah⁴; i² tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³, jon³ hyon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jon³ a⁴tyie³⁴ si³jon⁴³ Zebedeo jian²³ sie²³ i²con²³ Jesús, i² jon³ si⁴jnei⁵ sie²³i³ ta⁵nei² Jesús i⁴sia³ con³ i⁴a⁴m⁴i³ i²con²³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","I² jon³ a⁴juah⁴ Jesús: ―¿Henh⁴ ma²hnoh³ˉ³? Jon³ a⁴juah⁴ a³m⁴ hain⁴: ―Júan² hnei³ heih⁴³ la⁴teg⁴i² ma³ua²júanh³ˉ³ heih⁴³ m⁵cu³ la³, i⁴cua³⁴ on³⁴ si³jon³⁴ˉ⁴ la³ hlonh²ˉ³, jan³ jo³² ta⁵chie³⁴ jian³ jan³ jo³² ta⁵quegh³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","I² jon³ a⁴ŋangh³ Jesús jau²³, a⁴juah⁴i³: ―Ta² sa⁴ñih¹ˉ³ i⁴mh³ˉ³ tionh²ˉ³. ¿O⁴ tianh³²ˉ³ canh²ˉ³ ma²eu⁴³ liah⁴ can¹ˉ⁴, jian³ i⁴júanh¹i³ hnei³ liah⁴i² júanh¹i³ jnia⁴? I² jon³ a⁴ŋangh³i³ tionh², a⁴juah⁴i³: ―Tian⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² li⁴canh²ˉ³ ma²eu⁴³ liah⁴ can¹ˉ⁴, jian³ li⁴júanh¹i³ hnei³ liah⁴i² júanh¹i³ jnia⁴; i² nei² quieh¹ i⁴mh³ˉ³ i⁴neih²ˉ³ jo³² ta⁵chie³⁴ jian³ jo³² ta⁵quegh³ quien⁴ˉ⁴ ne⁵, sa⁴tain⁴³ˉ⁴ cúa¹ˉ⁴, quie¹ cua³⁴ a³hain⁴pa² tionh² a³a⁴quianh⁴³ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","I² con³ma²a⁴nau⁴ i²quian³⁴ chie³ quian¹i³ hain⁴, ta² a⁴jain²³ tsei⁴³i³ i²con²³ li⁵uan⁴ si³reunh¹ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","I² Jesús ne⁵, a⁴teh³i³ a³hain⁴ tionh², a⁴juah⁴i³: ―Quie¹ ñih¹ˉ³ liah⁴ tionh² la⁴jeg³⁴ nación a³sa⁴lang⁴³ judío, i⁴pain⁴ heih⁴³ júan³ gobierno quian¹i³ tionh², jian³ la⁴jang³⁴ a³ti²quian³ ta¹ liah⁴ queih²i³ heih⁴³ pain⁴ i⁴sa⁴hain²³i³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","I² jenh²ˉ³ tionh²ˉ³ ne⁵, sa⁴hniah³ lei⁴ la⁴ne³. Quie¹ a³hain⁴ a³hnie³⁴ li⁴júanh⁴³ jenh²ˉ³ tionh²ˉ³, hniah³ cúa³⁴i³ cúa³tag³² i²conh²ˉ³ tionh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","jian³ a³hain⁴ a³hnie³⁴ lain⁴ a³tyein² jenh²ˉ³, hniah³ júan⁵i³ i²conh²ˉ³ la⁴jan³ a³júan³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Quie¹ la⁴ne³pa² cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ i⁴cúa³⁴i³ cúa³tag³² i²con²³ chie³, a⁵jon⁴³ ta⁵cúa³⁴ chie³ cúa³tag³² i²con²³i³, jian³ cuan³⁴i³ i⁴cúa³⁴i³ m⁵cu³ quieh¹ i⁴lion⁴ jeun⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","I² con³ma²a⁴húan³i³ jeu³ Jericó jon³, ta² jeun⁴³ chie³ ua⁵han² coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","I² jon³ ti²tionh² on³⁴ a³taun³² hloh³² ho³²jeu³, jeu³ ŋo²³i³; i² con³ma²a⁴nau⁴i³ i⁴ja³⁴ Jesús, jon³ a⁴hleh⁴i³ tia⁴, juah⁴i³: ―¡Hnei³ Se³ño²³, Sa¹jeun³ Da³vei²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnie³²! ");
INSERT INTO cucNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","I² jon³ a⁴jai³⁴ chie³ jeun⁴³ hain⁴ quieh¹i³ tionh² canh⁴a² cauh³i³ lau²; i² hei⁴i³ tionh² ne⁵, tsei³⁴sa² tia⁴ a⁴hleh⁴i³, juah⁴i³: ―¡Hnei³ Se³ño²³, Sa¹jeun³ Da³vei²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnie³²! ");
INSERT INTO cucNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","I² jon³ a⁴jian⁴ Jesús, a⁴teh³i³ a³taun³² hain⁴, a⁴sagh⁴³i³: ―¿Henh⁴ hnoh³ˉ³ júan³²ˉ⁴ i²conh²ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","I² jon³ a⁴juah⁴i³ tionh²: ―Hnei³ Se³ño²³, hnie³ jnie³² jnia⁵ m⁴nei² jnie³². ");
INSERT INTO cucNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jon³ joh³ ñei⁴ tsei⁴³ Jesús i²con²³i³, a⁴tei³⁴i³ si¹cúa³ m⁴nei² a³hain⁴ tionh². Liah⁴ma²jon³ a⁴jnia⁵ m⁴nei²i³, jon³ ŋo³⁴i³ ua⁵han²i³ coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","I² con³ma²a⁴tyie³⁴i³ tionh² jeu³ Betfagé, mah⁴ quieh¹ a²hma³ Olivos, hloh³² Jerusalén, jon³ a⁴sain⁴ Jesús on³⁴ chie³ quian¹, ");
INSERT INTO cucNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a⁴sagh⁴³i³: ―Cua³ jeu³ peih¹ nie⁴³ ta⁵nei² ne³ tionh²ˉ³. I²jno³ tyanh³²ˉ³ jan³ a¹si²lo¹siah³ a³si²hñih² jian²³ jan³ jon⁴lo¹ jon⁴³. Jon³ sainh³²ˉ³ jian³ teh³²ˉ³ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jian³ juah⁴ne³ sian³ a³hleh⁴³ hnei³, saih³²i³ hnei³ i⁴hniah³ quian¹ Se³ño²³pa², ma²jon³ sainh³i³ to⁴ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A⁴leg³⁴ la⁴jeg³⁴ i⁴ne³ canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ jan³ a³sain², con³ma²a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Saih³² hnei³ a³tionh² si³da²³ Sión: “Jeh³², ma³ja²³ re¹ quianh³ˉ³ i²conh²ˉ³, a³ti⁴ñeih⁵ quie¹ ua²tsain¹i³ jan³ a¹si²lo¹siah³, jan³ a²lo¹ peih¹, a³jon⁴³ jah⁴ a³can²³ lie²³.” ");
INSERT INTO cucNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jon³ ua⁵han² chie³ quian¹i³ hain⁴, a⁴ma⁴tei⁵i³ heih⁴³ i⁴a⁴júan⁴ Jesús i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Quie¹ jian³i³ a¹si²lo¹ hain⁴ jian²³ a³jon⁴³, ma²jon³ a⁴ja³⁴i³ a²cúan³ ma³cah³² jah⁴ hain⁴ tionh², ma²jon³ ua⁴tsei³² Jesús nei². ");
INSERT INTO cucNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jian³ ta² jeun⁴³ chie³ liah⁴, ti²ja²³i³ a²cúan³ ho³²jeu³; jian³ ca³chion²³ ti²queih² o¹cúah² hma³ i⁴ja²³i³ ho³²jeu³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jian³ ya¹han² jeun⁴³ chie³ ta⁵nei²i³ jian³ coh⁵cah³²i³ a³ti²hleh² tia⁴, juah⁴i³: ―¡Júanh⁴³ Sa¹jeun³ re¹ Da³vei²³! ¡Ta² tsei³⁴ jm² ren³ a³ja²³ con⁴juah⁴ jm³i⁴sain³ Se³ño²³ Jon⁴dai¹! ¡Júanh⁴³ Jon⁴dai¹ a³cua⁴³ ñi⁴jeu⁵! ");
INSERT INTO cucNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","I² con³ma²a⁴hei³⁴i³ Jerusalén ne⁵, jon³ ta² co³ ŋo³⁴ tsei⁴³ la⁴jang³⁴ chie³ a³tionh² jeu³ jon³, a⁴juah⁴i³: ―¿Hain³ chianh² ne³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","I² jon³ a⁴juah⁴ a³jeu³: ―Jesús pa² a³ne³, a³sain², a³sian³ jeu³ Nazaret i²tei⁴³ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jon³ a⁴hei³⁴ Jesús cuah³júah² quieh¹ Jon⁴dai¹, a⁴húan⁴³i³ la⁴jang³⁴ a³ti²hnang³ jian³ a³ti²la²³ i²jon³. A⁴quegh³i³ a²me²sa³ quieh¹ a³sag²³ o¹cau³² tionh² jian³ a²ma³sei² quieh¹ a³ti²hnang⁴³ a⁵ta³cuah³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jian³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―Quie¹ ra³sag² Ma²jyi³: “Jauh³² quien⁴ˉ⁴ jauh³² i²mh²i³ Jon⁴dai¹pa² teh²i³.” I² hnei³ tionh²ˉ³ júanh³ˉ³ jauh³² la³ la⁴con³ to³hlo³ quieh¹ hang³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","I² jon³ a⁵han² a³taun³² jian³ a³tein⁴ i²con²³i³ cuah³ jon³. Jian³ a⁴júan⁴ Jesús i⁴a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ta² a⁴jain²³ tsei⁴³ m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³, con³ma²a⁴je³⁴i³ la⁴jeg³⁴ ua³júah² i⁴júan³ Jesús jian³ a⁴jen³i³ i⁴ti²hleh² la⁴jang³⁴ si³maih² tia⁴ cuah³júah², i⁴juah⁴i³: “Júanh⁴³ Sa¹jeun³ re¹ Da³vei²³.” ");
INSERT INTO cucNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jon³ a⁴sagh⁴³i³ Jesús, juah⁴i³: ―¿O⁴ nauh³ˉ³ i⁴ti²hleh² a³ne³? I² jon³ a⁴juah⁴ Jesús: ―Jen³⁴, nau³⁴ˉ⁴. ¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ i²ra³juah⁴: Ma³a⁴júanh²ˉ³ i⁴hleh³ si³maih² peih¹ jian³ a³teih⁴, liah⁴ júanh⁴³ hnei³ o³tan²? ");
INSERT INTO cucNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jon³ a⁴tai³⁴ Jesús quieh¹i³, ua⁵hag⁴³i³ si³da²³ jon³, ŋo³⁴i³ jeu³ Betania i²a⁴jian⁴i³ je¹nai³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","I² con³ma²a⁴jnia³⁴, jon³ jonh³i³ ta⁵si³da²³ jon³ liah⁴ i⁴seg³⁴, jian³ ra⁵cúanh⁴³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I² jon³ a⁴je³⁴i³ con³ a²hma³ m⁴jyi³ hloh³² ho³²jeu³, jon³ a⁴tyie³⁴i³ hloh³², i¹con³ o¹m⁴ quieh¹ sa⁴a⁴chieh¹i³, jmah³ o¹úan³²pa² si²leg⁴³. Jon³ a⁴sagh⁴³i³ a²hma³, juah⁴i³: ―I¹conh⁴ so⁵hag³⁴ hnei³ o¹m⁴. Tyi¹ a⁴la³ ra⁵quein³ a²hma³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","I² con³ma²a⁴je³⁴ chie³ quian¹i³ tionh², ta² co³ a⁴jainh⁴³i³, juah⁴i³: ―¿Liah⁴ cúan²³ ra⁵quein³ a²hma³ m⁴jyi³ ne³ liah⁴ma²jon³? ");
INSERT INTO cucNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jon³ a⁴ŋangh³ Jesús i²con²³i³, a⁴juah⁴i³: ―I⁴chie⁴³pa² juah³ˉ⁴, juah⁴ne³ hainh⁴ˉ³ jian³ sa⁴júanh³ˉ³ teun³⁴ co³hei²tsei³, a⁵jon⁴³ jmah³ i²con²³ a²hma³ m⁴jyi³ ne³ li⁴júanh²ˉ³ la⁴ne³, quie¹ li⁴jeuh³²ˉ³ a²mah⁴ ne³: “Quein⁴³ hnei³ i²gm⁴; cua³ la⁴teg⁴ joh⁴³ jm³ñih¹”, jian³ lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jian³ la⁴jeg³⁴ i⁴mh²ˉ³ i²con²³ Jon⁴dai¹ i⁴hainh⁴ˉ³, hyanh⁴ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jon³ a⁴tyanh³ Jesús cuah³júah², i² ta¹la⁴ ma³si²heh²i³ chie³, jon³ a⁴tyie³⁴ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³ quian¹ a³jeu³ hlonh²i³ a³a⁴juah⁴ i²con²³i³: ―¿Hain³ heih⁴³ quianh²ˉ³ i⁴júanh³ˉ³ la⁴jeg³⁴ i⁴ne³? ¿Jian³ o⁴ hain³ a⁴cúa⁴ heih⁴³ ne³ i²conh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Hno⁵ jnia⁴ liah⁴ ŋang¹ˉ⁴ con³ i²conh²ˉ³ tionh²ˉ³. I² juah⁴ne³ a⁴jainh¹ˉ³ jau²³ ne⁵, jon³ jeu¹ˉ⁴ hnei³ liah⁴ hain³ heih⁴³ quian³²ˉ⁴ i⁴júan³⁴ˉ⁴ la⁴jeg³⁴ i⁴la³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","I² jon³ ne⁵, ¿hain³ a⁴júan⁴ heih⁴³ i²con²³ Juan³ Tei³² i⁴ua⁵sion⁴³ chie³ jm³? ¿O⁴ Jon⁴dai¹ jian³ o⁴ chie³, lainh⁴ˉ³? Jon³ a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: ―Juah⁴ne³ juah²ˉ¹ i⁴ Jon⁴dai¹pa² a⁴júan⁴ heih⁴³ i²con²³i³, jon³ sag⁵i³ jnia¹: “¿E⁴le³⁴ sa⁴ra⁵hainh⁴ˉ³ jau²³ quieh¹i³ ne⁵?” ");
INSERT INTO cucNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jian³ juah⁴ne³ juah²ˉ¹ i⁴a⁴sai⁴ chie³pa² quieh¹i³, jeh³² a³jeu³ tionh², co³ jia²³; quie¹ la⁴jang³⁴pa² ti²ñi³ i⁴ma²lang⁴³ Juan²³ jan³ a³sain². ");
INSERT INTO cucNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","I² jon³ a⁴jainh³i³ jau²³ i²con²³ Jesús, a⁴juah⁴i³: ―Sa⁴nia² jnie³². I² jon³ a⁴juah⁴ Jesús i²con²³i³ liah⁴: ―Jian³ jnia⁴ liah⁴, a⁵sia³ jeu¹ˉ⁴ hnei³ tionh²ˉ³ hain³ heih⁴³ quian³²ˉ⁴ i⁴júan³⁴ˉ⁴ la⁴jeg³⁴ i⁴la³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’¿Liah⁴ lainh⁴ˉ³ jau²³ la³? Jan³ a³ñih³ ma²sian³ on³⁴ si³jon⁴³; jon³ a⁴tyie³⁴ a³hain⁴ i²con²³ jan³ co⁴ra⁴lie⁵, a⁴juah⁴i³: “Hnei³ a³jon³⁴ˉ⁴, cua³ ua⁴júan² ta¹ ne³⁴ je¹ o¹m⁴ ya¹gm³jeh² quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","I² jon³ a⁴juah⁴ a³jon⁴³i³: “Sa⁴i²nai³²ˉ⁴.” I² coh⁵ jon³ ne⁵, a⁴júan⁴i³ co³hei²tsei³ seg²³, jon³ ŋo³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma²jon³ a⁴tyie³⁴ a³don⁵ hain⁴ liah⁴ i²con²³ i²jan³ jon⁴³, conh⁴liah⁴ la⁴jon³pa² a⁴juah⁴i³ liah⁴; i² jon³ a⁴ŋangh³i³, juah⁴i³: “Jen⁴, pa²³ quian³⁴, nai³²ˉ⁴.” I² a⁵sia³ ŋo³⁴i³ ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Hain³ conh⁴ li⁵uan⁴ hain⁴ ma⁴tei⁵ heih⁴³ quieh¹ jmai³i³, lainh⁴ˉ³? Jon³ a⁴juah⁴i³ tionh²: ―A³a⁴hlenh⁴³i³ co⁴ra⁴lie⁵pa². Jon³ a⁴juah⁴ Jesús i²con²³i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³can²³ hmah¹ jian³ a³m⁴ sa⁴jmh³ han⁵ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹ ñeih³² la⁴conh⁴a² hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Quie¹ cuan³⁴ Juan³ Tei³² i²conh²ˉ³, a⁴hleh⁴i³ liah⁴ hniah³ ma²teih³²ˉ³, i² sa⁴ra⁵hainh⁴ˉ³ jau²³ quieh¹i³ tionh²ˉ³; i² a³can²³ hmah¹ jian³ a³m⁴ sa⁴jmh³ tionh² ra⁵hain⁴. I² hnei³ tionh²ˉ³ ne⁵, con³ma²a⁴jeh¹ˉ³ i⁴jon³, jon³ a⁵sia³ co³hei²tsei³ quianh³ˉ³ a⁴sagh¹ˉ³ juah⁴ i⁴ma²li⁴hainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Nai³ hnei³ i²con³ jau²³ i⁴can¹ˉ⁴ la³ liah⁴: Ma²sian³ jan³ chie³ a³jnia² o¹m⁴ ya¹gm³jeh² quieh¹, jian³ a⁴júan⁴i³ con³ a²ha⁴ co⁴la⁴lagh⁵; jian³ a⁴júan⁴i³ con³ i²jianh²i³ o¹m⁴ ya¹gm³jeh², jian³ a⁴júan⁴i³ con³ a²cuah³² ñei⁴³ i²hie³⁴i³ je¹. ’Ma²jon³ a⁴tonh³i³ je¹ jon³ joh⁴³ cúa³ co⁴meih³ a³júan³ ta¹, jon³ ŋo³⁴i³ ta⁵jeu³ gm⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","I² con³ma²a⁴tyie³⁴ jm² a⁴lo³, jon³ a⁴sain⁴i³ co⁴meih³ a³cúa²³ cúa³tag³² quian¹ i²con²³ a³júan³ ta¹ je¹ hain⁴ canh⁴a² ma²cúah³i³ co⁴meih³ o¹m⁴ ya¹gm³jeh² jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","I² a³júan³ ta¹ hain⁴ tionh² ne⁵, jon³ a⁴sanh³i³ a³cúa²³ cúa³tag³² hain⁴, a⁴pan³⁴i³ jan³, a⁴jŋangh⁴i³ i²jan³, jian³ a⁴quinh⁴³i³ m⁴caun² a³i²jan³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Conh⁴liah⁴ a⁴sain⁴ a³quieh¹ je¹ hain⁴ i²co⁴meih³ a³cúa²³ cúa³tag³² quian¹, jeun⁴³ la⁴conh⁴ ma²co⁴ra⁴lie⁵; conh⁴liah⁴ la⁴jon³pa² a⁴júan⁴ a³júan³ ta¹ hain⁴ i²con²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’I² a⁴toh⁴ ne⁵, a⁴sain⁴i³ a³jon⁴³ hña³, juah⁴i³: “Leg⁴³ re³pa² ma⁵con⁴³i³ a³jon³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","I² a³júan³ ta¹ ne⁵, con³ma²a⁴jen³i³ a³jon⁴³i³, jon³ a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: “A³ne³pa² li⁴quieh¹ je¹ la³. Ma³²ˉ¹ ma⁵jŋangh¹i³ jnia¹ canh⁴a² li⁴quian⁴ˉ¹ je¹ i⁴ma²li⁴quieh¹i³.” ");
INSERT INTO cucNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jon³ a⁴sanh³i³, a⁴ton³⁴i³ ta⁴coh⁵ je¹ jon³, jian³ a⁴jŋangh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","I² ne³ ne⁵, tei⁴³i² ma³jonh² a³quieh¹ je¹ jon³, ¿liah⁴ júan³⁴i³ i²con²³ a³júan³ ta¹ hain⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jon³ a⁴juah⁴ a³hain⁴ tionh² i²con²³ Jesús: ―Jŋangh³i³ a³hlangh² hain⁴ tionh² i⁴so⁵ñeih⁴ tsei⁴³i³, jon³ tonh³i³ je¹ quieh¹ joh⁴³ cúa³ a³júan³ ta¹ sang³⁴ tionh² a³cúah³ i⁴quieh¹ je¹ i⁴lo³⁴ tei⁴³i² a⁴tyie³⁴ jm² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ i⁴ra³sag²: A²caun² i⁴a⁴ton³⁴ teg³hyah³ tionh², a²caun² jon³pa² re³ a⁴seih³ ta³jmh¹ a²hnei⁴³. A⁴júan⁴ Se³ño²³ i⁴a⁴leg³⁴ la⁴ne³, jian³ ta² co³ a⁴jain⁴³ˉ¹ a⁴niah³²ˉ¹ i⁴jon³? ");
INSERT INTO cucNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","I² jon³ ne⁵, jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, júan³⁴ Jon⁴dai¹ i⁴a⁵sie⁴³ tain⁴³ hnei³ tionh²ˉ³ i⁴cúah²ˉ³ naih⁵ heih⁴³ quieh¹i³, quie¹ cúa³⁴i³ i⁴tain⁴³ chie³ a³ma⁴tei⁵ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jian³ a³hain⁴ a³cangh² nei² a²caun² jon³, jon³ jeun⁴i³ o¹leuh²; jian³ juah⁴ne³ sian³ a³neh³ a²caun² ne³, jon³ lain⁴i³ o¹jeu². ");
INSERT INTO cucNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Con³ma²a⁴nau⁴ m³chie³ tyein² jian²³ fariseo tionh² jau²³ i⁴a⁴can³⁴ Jesús jon³, jon³ ra⁵ŋang⁴i³ i⁴hleh²i³ nei² quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","I² jon³ ma²hnoh³i³ hain³liah⁴ li⁴sanh³i³ Jesús; i² con⁴³i³ a³jeu³ ne⁵, quie¹ la⁴jang³⁴ a³jeu³ laih² i⁴lang⁴³i³ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","I² jon³ a⁴hleh⁴ Jesús i²con²³i³ tionh² liah⁴ i⁴seg³⁴ con⁴juah⁴ jau²³ a⁴can³⁴i³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―I⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ jan³ re¹ a³a⁴júan⁴ jm² i⁴a⁴sianh³ a³jon⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A⁴sain⁴i³ a³cúa²³ cúa³tag³² quian¹ i⁴si⁵teh²i³ a³ten² tionh² i⁴jia²³i³ jm² i²sanh⁴. I² a³hain⁴ tionh² ne⁵, sa⁴hnie³⁴i³ chie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Conh⁴liah⁴ a⁴sain⁴i³ i²co⁴meih³ a³cúa²³ cúa³tag³² liah⁴, con³ma²ra⁵juah⁴i³: “Saih³² hnei³ a³ten² hain⁴ tionh² i⁴ma³a⁴júan³⁴ˉ⁴ co³jian¹ ma³⁴ quien⁴ˉ⁴. Ma³a⁴jŋangh³ˉ⁴ cua³²jeu²³ quian³⁴ jian³ jah⁴ a³re³ heunh³², ma³nie⁴³ la⁴jeg³⁴; saih³²i³ hnei³ i⁴jia²³ tionh² jm² i²sanh⁴ a³jon³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","I² a³ten² hain⁴ tionh² ne⁵, i¹leuh² jeu³ sa⁴a⁴ro⁴i³. Quie¹ ŋo³⁴ jan³ je¹ quieh¹, jian³ i²jan³ ŋo³⁴ i²hnang³i³ lie²³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jian³ a³ten² sang³⁴ tionh², jon³ a⁴sanh³i³ a³cúa²³ cúa³tag³² hain⁴, a⁴júanh¹i³ jian³ a⁴jŋangh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","I² con³ma²ra⁵ñi³ re¹ hain⁴, ta² a⁴jain²³ tsei⁴³i³, jon³ a⁴sain⁴i³ jeun⁴³ a²hlie⁴ quian¹ ua⁵ma⁵hain¹i³ a³jŋangh² chie³ hain⁴ tionh², jian³ a⁴jeng⁴i³ jeu³ co²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jon³ a⁴juah⁴ re¹ i²con²³ a³cúa²³ cúa³tag³²: “Ma³nie⁴³ re³ i⁴quieh¹ jm² sanh⁴ a³jon³⁴ˉ⁴. I² a³ten² hain⁴ tionh² ne⁵, sa⁴haih¹ i⁴li⁴jia²³i³ jm² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eu⁴³a² re³ cua³ hnei³ la⁴jeg³⁴ i²tyi¹ jeu³, ua⁴teh⁴³ hnei³ la⁴jang³⁴ a³tyanh³²ˉ³ i²jon³ i⁴jia²³i³ jm².” ");
INSERT INTO cucNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jon³ a⁴húan³ a³cúa²³ cúa³tag³² hain⁴, ua⁵han² la⁴jeg³⁴ i²tyi¹ jeu³, jaih³i³ i⁴nei² chie³ la⁴conh⁴ a³a⁴chianh¹i³, a³hlangh² jian³ o⁴ a³tsein²³; jon³ a⁴canh³ jauh³² i²tionh²i³ jm² i²sanh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’I² jon³ a⁴hei³⁴ re¹ i⁴jen⁴³i³ a³ten² hain⁴ tionh², i²jon³ a⁴jen³i³ jan³ a³ñih³ a³sa⁴hein² a²hmh³ quieh¹ i²sanh⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","I² jon³ a⁴juah⁴i³: “Hnei³ a³ñi³reunh³ˉ⁴, ¿hain³liah⁴ a⁴heuh³ˉ³ i²la³ i⁴sa⁴heinh³²ˉ³ a²hmh³ quieh¹ i²sanh⁴ chie³?” I² a³hain⁴ ne⁵, so⁵ñi³i³ liah⁴ hleh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jon³ a⁴juah⁴ re¹ i²con²³ a³ti²tyieh⁵: “Hñi⁴³ hnei³ a³ne³, si¹cúa³i³ si¹tag³²i³, jon³ tion²³ coh⁵hnei³² i²naih³; i²jno³ hoh⁵i³, queuh⁴³i³ m⁴jan².” ");
INSERT INTO cucNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Quie¹ jeun⁴³ a³ten², i² co⁴meih³pa² lang⁴³ a³ti²quianh². ");
INSERT INTO cucNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jon³ ŋah³ fariseo hain⁴ tionh², ti²júanh⁴i³ húan⁴i³ tionh², hnoh³i³ liah⁴ li⁴si⁵seun³ Jesús jau²³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","I² jon³ a⁴sain⁴ fariseo chie³ quian¹ tionh² jian²³ chie³ quian¹ Herodes i²con²³ Jesús, a⁴juah⁴i³: ―Hnei³ A²teg²³, nia² jnie³² i⁴hleh³ˉ³ jmah³ jau²³ tei⁴³, jian³ heh³ˉ³ jeu³ quieh¹ Jon⁴dai¹ con⁴juah⁴ jau²³ tei⁴³ liah⁴, jian³ a⁵sia³ jm² si²quianh¹ˉ³ liah⁴ lang⁴³ chie³, quie¹ sa⁴roh³ˉ³ jeu³ liah⁴ jnia⁴ chie³ ta⁴coh⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","I² ne³ ne⁵, sai³² hnei³ jnie³² liah⁴ lainh⁴ˉ³ nei² la³: ¿O⁴ ra³cúa²³ i⁴ma²hmah³²ˉ¹ i²tain⁴³ gobierno, jian³ o⁴ a⁵sia³? ");
INSERT INTO cucNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","I² Jesús ne⁵, si²ñi³i³ re³ i⁴a⁴juah⁴ a³hain⁴ tionh² la⁴ne³ con⁴juah⁴ co³hei²tsei³ hlagh³², i² jon³ a⁴sagh⁴³i³: ―¿E⁴le³⁴ jau²chie⁴³ conh⁴ˉ³ jnia⁴ tionh²ˉ³, hnei³ a³júan³ teun³⁴ nei² tionh²? ");
INSERT INTO cucNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","He³a² hnei³ con³ o¹cau³² i⁴ma³hmah³²i³ i²tain⁴³ gobierno. Jon³ ni²quian⁴i³ con³ o¹cau³² denario. ");
INSERT INTO cucNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","I² jon³ a⁴juah⁴ Jesús: ―¿Hain³ ma³nei² ra³ton³ o¹cau³² la³, jian³ hain³ jm³i⁴sain³ ra³sag²? ");
INSERT INTO cucNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jon³ a⁴juah⁴i³ tionh²: ―Gobierno César pa². I² jon³ a⁴juah⁴ Jesús: ―Juah⁴ne³ la⁴ne³, cúah³² hnei³ gobierno i²tain⁴³; jian³ cúah³² hnei³ Jon⁴dai¹ i²tain⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","I² con³ma²a⁴nau⁴i³ tionh² jau²³ jon³, jon³ ta² co³ a⁴jainh⁴³i³; jon³ ua⁵han²i³ tionh², a⁴tain³⁴i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jm² jon³ a⁴tyie³⁴ saduceo tionh² i²con²³ Jesús, a³hain⁴ tionh² a³juah⁴ i⁴sa⁴hyon⁴³ a³jaun², a³a⁴ŋang⁴, ");
INSERT INTO cucNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","i⁴juah⁴i³: ―Hnei³ A²teg²³, la⁴la³ a⁴juah⁴ M³se²³: Juah⁴ne³ a⁴jaun³⁴ jan³ a³ñih³ a³sa⁴ra⁵sian³ si³jon⁴³ jian²³ i³cúa³, jon³ hniah³ sanh⁴ a³reunh¹ a³jaun² jian²³ a³m⁴ hain⁴ canh⁴a² li⁴sian³ si³jon⁴³i³ nei² quieh¹ a³jaun² reunh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","I² jon³ ne⁵, ma²sian³ quion³⁴ si³reunh¹i³, jmah³ a³ñih³, jen² jnie³². I² a³co⁴ra⁴lie⁵ a⁴sanh⁴ jian²³ a³m⁴, jon³ a⁴jaun³⁴i³. Jian³ nei² quieh¹ sa⁴ra⁵sian³ si³jon⁴³i³, jon³ a⁴leg³⁴ i³cúa³ a³m⁴ hain⁴ a³reunh¹i³ a²teg⁴ on³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Coh⁵ jon³ liah⁴, la⁴jon³pa² a⁴jainh⁴³ a²teg⁴ on³⁴ hain⁴ co³nai² jian²³ a³ma³jaun², conh⁴liah⁴ la⁴jon³pa² a²teg⁴ on³ jian³ liah⁴a² a⁴tyie³⁴ a²teg⁴ quion³⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","I² con³ma²a⁴chian³⁴ la⁴jang³⁴ a³hain⁴ ne⁵, jon³ jaun² a³m⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","I² jon³ ne⁵, tei⁴³i² hyon⁴³ la⁴jang³⁴ a³jaun², ¿hain³ li⁴quian¹ a³m⁴ hain⁴, quie¹ la⁴jang³⁴ la⁴jon³ pi²³ ra⁵jian²³i³? ");
INSERT INTO cucNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jon³ a⁴ŋangh³ Jesús i²con²³i³, juah⁴i³: ―Ta² can³ hoh⁴³ˉ³ tionh²ˉ³, quie¹ sa⁴ŋangh⁴ˉ³ jau²³ quieh¹ Jon⁴dai¹ i⁴ra³sag², a⁵ga⁴ cmh²ˉ³ ua³pei⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Quie¹ la⁴teg⁴i² ma³a⁴hyon²³ a³jaun² tionh², a⁵sie⁴³ sanh⁴i³, jian³ a⁵ga⁴ cúan⁵i³ si³jon⁴³ i⁴sanh⁴i³, quie¹ lain⁴i³ liah⁴i² lang⁴³ ángel quian¹ Jon⁴dai¹ a³tionh² ñi⁴jeu⁵pa². ");
INSERT INTO cucNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","I² nei² quieh¹ i⁴hyon⁴³ a³jaun² ne⁵, ¿o⁴ a⁵sia³ ma³a⁴heih³ˉ³ henh⁴ a⁴hleh⁴ Jon⁴dai¹ i²conh²ˉ³ tionh²ˉ³, i⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Jnia⁴ lang⁴³ˉ⁴ Jon⁴dai¹ quian¹ A³brang²³, jian³ I³sa²³ jian³ Ja³co²³”, a⁴juah⁴i³? Quie¹ a⁵sia³ lang⁴³i³ Jon⁴dai¹ juah⁴ Jon⁴dai¹ quian¹ a³jaun², quie¹ Jon⁴dai¹ quian¹ a³sian³pa². ");
INSERT INTO cucNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","I² con³ma²a⁴nau⁴ a³jeu³ i⁴jon³, ta² co³ ŋo³⁴ tsei⁴³i³ jau²³ i⁴he²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","I² con³ma²ra⁵ñi³ fariseo tionh² a⁴cauh³ Jesús lau² saduceo hain⁴, jon³ a⁴ŋangh³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","I² jon³ jan³ a²teg²³ quian¹ lai²³ a³hein² jen² a³hain⁴ tionh² a⁴ŋang⁴ i²con²³ Jesús, i⁴con²³i³ jau²chie⁴³, juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Hnei³ A²teg²³, ¿hain³ heih⁴³ tyein² quein⁴³ i⁴hei¹ lai²³? ");
INSERT INTO cucNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","I² jon³ a⁴juah⁴ Jesús: ―“Ma⁴hno³² hnei³ Se³ño²³ Jon⁴dai¹ quianh³ i⁴jang³⁴ hoh⁴³ˉ³, i⁴lie²³ m⁴tyi⁴ quianh³ˉ³, jian³ la⁴jeg³⁴ co³hei²tsei³ quianh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","I⁴ne³pa² i⁴tyein² jian³ heih⁴³ ya¹jian⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jian³ a²teg⁴ teun³⁴ heih⁴³ meih³i² sa⁴co³nai² leg⁴³ i⁴ra³juah⁴: “Ma⁴hno³² hnei³ m⁵cu³ reunh³ liah⁴i² hnoh⁴ˉ³ húanh⁴³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Quie¹ li⁵teun⁴ heih⁴³ ne³ leg⁴³ o¹sieh³² quieh¹ la⁴tan² lai²³ quieh¹ M³se²³ jian³ jau²³ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jian³ ta¹la⁴ tionh² fariseo i²jon³, jon³ a⁴ŋang⁴ Jesús i²con²³i³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","a⁴juah⁴i³: ―¿Henh⁴ co³hei²tsei³ ti²júanh³ˉ³ nei² quieh¹ A³ya⁴lion³² Chie³ hain⁴? ¿Jian³ o⁴ hain³ sa¹jeun³? Jon³ a⁴juah⁴ a³hain⁴ tionh² i²con²³i³: ―Sa¹jeun³ re¹ Da³vei²³pa². ");
INSERT INTO cucNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","I² jon³ a⁴juah⁴ Jesús: ―¿I² liah⁴ cúan²³ Da³vei²³ hña³ a⁴teh³i³ Se³ño²³ quian¹ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹, con³ma²a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","A⁴juah⁴ Se³ño²³ Jon⁴dai¹ i²con²³ Se³ño²³ quian³⁴ˉ⁴: “Nei⁴ hnei³ jo³² ta⁵chie³⁴ quien⁴ˉ⁴ la⁴conh⁴i² júan³²ˉ⁴ i⁴cangh³²ˉ³ jm² i²con²³ la⁴jang³⁴ a³hie²³ hnei³”? ");
INSERT INTO cucNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Liah⁴ cúan²³ lang⁴³ A³ya⁴lion³² Chie³ hain⁴ sa¹jeun³ Da³vei²³ juah⁴ne³ juah⁴ Da³vei²³ hña³ i⁴lang⁴³ Se³ño²³ quian¹i³? ");
INSERT INTO cucNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","I² jon³ ne⁵, i¹jan³ so⁵tieh¹ li⁴ŋangh³ jau²³ i²con²³i³, jian³ liah⁴ma²jm² jon³ i¹jan³ so⁵tia⁴ tsei⁴³ ŋang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jon³ a⁴hleh⁴ Jesús i²con²³ a³jeu³ jian³ i²con²³ chie³ quian¹, juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Quie¹ lai²³ quieh¹ M³se²³ hei¹ joh⁴³ cúa³ a²teg²³ quian¹ lai²³ jian³ chie³ fariseo i⁴he²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","I⁴jon³ hniah³ ma²teih³²ˉ³ jian³ júanh²ˉ³ la⁴jeg³⁴ i⁴juah⁴i³ tionh²; i² liah⁴i² júan³i³ ne⁵, sa⁴hniah³ júanh²ˉ³, quie¹ tsei³⁴ hleh²i³ con³ jau²³. Jian³ i⁴seg³⁴pa² júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Quie¹ cúa²³i³ heih⁴³ hyei³ i⁴sa⁴tieh¹ chie³ ma⁴tei⁵i³, la⁴con³ lie²³, neh³i³ chie³ tionh²; i² hei⁴i³ ne⁵, i¹ sa⁴i²tei³⁴i³ si¹cúa³ i⁴ma⁵ho³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jian³ la⁴jeg³⁴ i⁴júan³i³, júan³i³ canh⁴a² je⁴³ chie³ quieh¹i³ tionh². Quie¹ júan³i³ i⁴cah² ma²jyi³ ti²hleh² jau²³ quieh¹ Jon⁴dai¹ i⁴tieh³² lauh¹ cúa³i³ jian³ ma³qui⁴³i³. Jian³ júan³i³ i⁴cúa³ he⁴³ a²cúan³ la⁴conh⁴a² a³sang²³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jian³ si³hyonh³i³ cua²³i³ queuh³i³ a²hei⁴³ hien²³ a³canh² i²júan³i³ jm², jian³ si³hyonh³i³ cua²³i³ hien²³ a³tyein² cuah³ judío. ");
INSERT INTO cucNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jian³ si³hyonh³i³ i⁴ma³co⁴³ chie³ quieh¹i³ je¹hmah¹ jian³ i⁴te²³ chie³ quieh¹i³ a²teg²³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’I² hnei³ tionh²ˉ³ ne⁵, sa⁴hniah³ hnoh²ˉ³ i⁴te³⁴ hnei³ chie³ a²teg²³, quie¹ co³nai²pa² hnei³ tionh²ˉ³ jianh²ˉ³ si³reunh³ˉ³, jian³ jan³pa² A²teg²³ quianh³ˉ³ leg⁴³, a³hain⁴ Cristo. ");
INSERT INTO cucNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jian³ i¹jan³ sa⁴hniah³ teh⁴³ˉ³ tionh²ˉ³ a³lang⁴³ naih⁴³ˉ³ nei² cuah³²húa³⁴ la³, quie¹ jan³pa² Naih⁴³ˉ³ leg⁴³, a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jian³ sa⁴hniah³ cúah²ˉ³ i⁴te³⁴i³ hnei³ a²teg²³ tyein² tionh²ˉ³, quie¹ jan³pa² A²teg²³ tyein² quianh³ˉ³ leg⁴³, a³hain⁴ Cristo. ");
INSERT INTO cucNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","A³hain⁴ a³júanh⁴³ jenh²ˉ³ tionh²ˉ³, ua²cúa⁴i³ cúa³tag³² i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Quie¹ a³hain⁴ a³júan³ i⁴júanh⁴³, sainh³i³ o³hyeih², jian³ a³hain⁴ a³júan³ ti⁴ñeih⁵, lei⁴ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo, a³júan³ ni²taih⁴³! Quie¹ jnaih⁴ˉ³ o²hnei³² i²han⁵ chie³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵. A⁵ga⁴ heuh¹ˉ³ tionh²ˉ³, a⁵ga⁴ cúah²ˉ³ jeu³ i⁴han⁵ a³hnie³⁴ hei⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo, a³júan³ ni²taih⁴³! Quie¹ quih⁵ˉ³ jauh³² quieh¹ a³don⁵ m⁴ hnang⁴, jon³ mh⁵ˉ³ Jon⁴dai¹ i⁴úa⁴ i⁴ma⁵canh²ˉ³ chie³. I⁴jon³ hyanh⁴ˉ³ ma²eu⁴³ pain⁴ la⁴conh⁴a² a³sang²³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo, a³júan³ ni²taih⁴³! Quie¹ ŋengh³ˉ³ i⁴hanh³ˉ³ jm³ jian³ jeu³ quein³ hnah⁵ˉ³ jan³ a³lain⁴ chie³ quianh³ˉ³, jian³ la⁴teg⁴i² ma³a⁴lang³⁴i³ ne⁵, jon³ júanh³ˉ³ i⁴haih¹ tyie¹ a³hain⁴ qui⁴jeu⁵ to⁵jeunh³ la⁴conh⁴a² hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, i⁴heh³ˉ³ jeu³ i²con²³ chie³, i⁴taunh³²ˉ³! Quie¹ juah⁴ˉ³: “Juah⁴ne³ cúa²³ jan³ jau²³ quieh¹ i⁴he²³i³ cuah³júah², i¹con³ a⁵sia³ i⁴leg⁴³ juah⁴ sa⁴ra⁵tei⁴³; i² juah⁴ne³ cúa²³ jan³ jau²³ quieh¹ i⁴he²³i³ con⁴juah⁴ o¹cau³²nie¹ tieh³² cuah³ jon³, hniah³ ma⁴tei⁵i³ ton³²nie⁴³.” ");
INSERT INTO cucNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Hnei³ a³can³ tsei⁴³ tionh², a³taun³²! ¿Henh⁴ i⁴tyein² quein⁴³, o⁴ o¹cau³²nie¹ jian³ o⁴ cuah³júah² i²ma³cúah¹ o¹cau³²nie¹ jon³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Conh⁴liah⁴ juah⁴ˉ³: “Juah⁴ne³ cúa²³ jan³ jau²³ quieh¹ i⁴he²³i³ ni²hyie⁴, i¹con³ a⁵sia³ i⁴leg⁴³ juah⁴ sa⁴ra⁵tei⁴³; i² juah⁴ne³ cúa²³ jan³ jau²³ quieh¹ i⁴hen⁴³i³ jah⁴ a³jang³i³ ni²hyie⁴ jon³ ne⁵, jon³ hniah³ ma⁴tei⁵i³”, juah⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Hnei³ a³hyei³ tyi², a³taun³² tionh²! Quie¹ ¿henh⁴ tyein² quein⁴³, o⁴ jah⁴ a³jang³i³ nei² jian³ o⁴ ni²hyie⁴ i²ma³cúanh¹ jah⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Quie¹ a³cúa²³ jau²³ quieh¹ i⁴he²³i³ ni²hyie⁴, cúa²³i³ i⁴he²³i³ ni²hyie⁴ jian³ la⁴jang³⁴ jah⁴ a³jang³i³ nei² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Conh⁴liah⁴ a³cúa²³ jau²³ quieh¹ i⁴he²³i³ cuah³júah², cúa²³i³ i⁴he²³i³ cuah³ jon³, jian³ hen⁴³i³ Jon⁴dai¹ a³hein² i²jon³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jian³ a³cúa²³ jau²³ quieh¹ i⁴he²³i³ ñi⁴jeu⁵, cúa²³i³ i⁴he²³i³ a²ma³sei² tyein² quieh¹ Jon⁴dai¹ jian³ a³ua²tsei¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo a³júan³ ni²taih⁴³! Quie¹ cúah³ˉ³ a²teg⁴ quia³⁴ chieh³² o¹a³siah³, jian³ anís jian³ m⁴yi¹ma³⁴, i² i⁴tyein² quein⁴³ i⁴hei¹ lai²³ ne⁵, a⁵sia³ ma⁵teih³²ˉ³ i⁴ra³juah⁴: i⁴júan³i³ i⁴tsei³⁴, i⁴jieh⁴ ñei⁴ tsei⁴³i³ jian³ i⁴hain⁴i³. I⁴ne³pa² tyein² hniah³ júanh²ˉ³ ton³²nie⁴³. Jian³ liah⁴ma³cúah³ ne³pa² hnei³ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Hnei³ a³heh³ˉ³ jeu³ i²con²³ chie³ i⁴taunh³²ˉ³! ¡Quie¹ quianh⁵ˉ³ a¹leu³ a³hein² a²va²so³ jian³ nangh⁵ˉ³ jan³ a²ca³me²llo³! ");
INSERT INTO cucNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo, a³júan³ ni²taih⁴³! Quie¹ raunh⁵ˉ³ jmah³ ta⁴coh⁵ a²va²so³ jian³ a²gm⁴³. I² ta⁵joh⁴³ ne⁵, si²canh³ i⁴hang³ jian³ i⁴langh³ˉ³ con⁴juah⁴ i⁴hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hnei³ fariseo taun³², raunh³² hnei³ ñeih³²jia⁴³ ta⁵joh⁴³ a²va²so³ jian³ a²gm⁴³ liah⁴ canh⁴a² li⁴quei⁴ ta⁴coh⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo a³júan³ ni²taih⁴³! Quie¹ langh⁴³ˉ³ liah⁴i² leg⁴³ i²ra³hon³ a³jaun² i²ra³jñei²³ lo¹tie³ i⁴tsei³⁴ jnia⁴ ta⁴coh⁵, i² ta⁴naih⁵ ne⁵, si²canh³ a²úan²³ quieh¹ a³jaun² jian³ la⁴jeg³⁴ nai² i⁴ni²hain⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Quie¹ la⁴ne³ langh⁴³ˉ³ tionh²ˉ³ jeu³ coh⁵, ta² tseinh³ˉ³, lain⁴ chie³, i² naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³ ne⁵, si²canh³ la⁴jeg³⁴ nai² i⁴hlagh³² jian³ i⁴ma⁵canh²ˉ³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo, a³júan³ a³ni²taih⁴³! Quie¹ júanh³ˉ³ hyah³ i⁴leg⁴³ a²hnei⁴³ peih¹ i²ti²hon³ a³sain² quian¹ Jon⁴dai¹, jian³ júanh⁴ˉ³ jain²³ lo¹ i²ti²hon³ a³tsein²³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jian³ juah⁴ˉ³ tionh²ˉ³: “Juah⁴ne³ ma²sian³ˉ¹ jm² ma²sian³ jmai³sie²³ˉ¹, a⁵sia³ ma³a⁴jŋangh³²ˉ¹ a³sain² hain⁴ tionh² jie³i³ jnia¹.” ");
INSERT INTO cucNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","I⁴hleh³ˉ³ la⁴ne³ lei³ jnia⁴ i⁴langh⁴³ˉ³ jon⁴³segh³² a³a⁴jŋangh⁴ a³sain² hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Ma⁴tieh² hnei³ chie³² quieh¹ naih⁴³sieh³ˉ³ tionh²ˉ³! ");
INSERT INTO cucNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡A⁵mh³ tionh², sa¹jeun³ jah⁴ hion²³! ¿Hain³liah⁴ li⁴lionh⁴ˉ³ i⁴gmh⁴ heih⁴³ i²conh²ˉ³ i⁴cúah²ˉ³ qui⁴jeu⁵, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","I⁴jon³ sain¹ˉ⁴ a³sain² i²conh²ˉ³ tionh²ˉ³ jian³ sain¹ˉ⁴ a³ŋang⁴ jian³ a²teg²³. I² hei⁴i³ tionh² ne⁵, jŋangh¹ˉ³ ca³chion²³, jian³ ca³chion²³ tionh³²ˉ³ crau¹, jian³ ca³chion²³ panh¹ˉ³ cuah³ quianh³ˉ³, jian³ hangh¹i³ hnei³ conh⁴ con³ jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Júanh²ˉ³ la⁴ne³ tionh²ˉ³ canh⁴a² canh²ˉ³ chie³² quieh¹ la⁴jang³⁴ a³tsein²³ a³a⁴chian³⁴ a³a⁴taun³ jm³yein⁴ quieh¹ nei² cuah³²húa³⁴ liah⁴ma²ra⁴lie⁵ a⁴tain³⁴i³ jm³yein⁴ quieh¹ Abel, a³tsein²³ hain⁴, la⁴teg⁴ Zacarías, a³jon⁴³ Berequías, a³a⁴jŋangh⁴³ˉ³ hloh³² ni²hyie⁴ i²jang³i³ jah⁴ cuah³júah². ");
INSERT INTO cucNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, la⁴jeg³⁴ chie³² ne³ canh²ˉ³ a³sianh³ˉ³ tieh²la³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Hnei³ tionh²ˉ³ a³tionh² Jerusalén, jŋangh⁵ hnei³ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ jian³ quinh⁵ˉ³ m⁴caun² la⁴jang³⁴ a³sain³i³ i²conh²ˉ³! ¡Ta² hlion⁴ nie⁴³ ma²hno⁵ˉ⁵ ma²jaih³²ˉ⁴ hnei³ tionh²ˉ³, liah⁴i² júan³ a¹si²hyie²³, tyan⁴³i³ co⁴lagh⁴³ jon⁴³yein³ hyie²³ quian¹ naih⁵ ya¹cúa⁴³i³! I² hnei³ sa⁴ra⁵hnoh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Quie¹ ton³⁴ Jon⁴dai¹ i²tionh²ˉ³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jian³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ i⁴a⁵sie⁴³ jeh³²ˉ³ jnia⁴ la⁴conh⁴i² a⁴tyie³⁴ jm² i⁴juah²ˉ³: “Ta² tsei³⁴ jm² ren³ a³ja²³ con⁴juah⁴ jm³i⁴sain³ Se³ño²³.” ");
INSERT INTO cucNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","I² con³ma²ua⁵hag⁴³ Jesús cuah³júah² jian³ ma³hein²i³ jeu³, jon³ a⁴tyie³⁴ chie³ quian¹i³ hlonh², a⁴he⁴i³ la⁴jeg³⁴ a²hnei⁴³ quieh¹ cuah³júah² i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","I² hei⁴i³ ne⁵, a⁴juah⁴i³: ―¿Sa¹ jeh⁴ˉ³ la⁴jeg³⁴ i⁴ne³ tionh²ˉ³? I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, i¹con³ a²caun² a⁵sie⁴³ ni²tsei¹ nei² a²caun² reunh¹ lei⁴ juah⁴ i⁴sa⁴si⁵cúan⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Coh⁵ jon³ con³ma²ua²cua⁴³ Jesús mah⁴ quieh¹ a²hma³ Olivos, jon³ a⁴tyie³⁴ chie³ quian¹i³ hlonh²i³ con³ i²sa⁴sian³ chie³, a⁴sagh⁴³i³ Jesús: ―Sai³² hnei³ jnie³² legh⁴ lei⁴ la⁴jeg³⁴ i⁴ne³. ¿Henh⁴ júan³⁴ lei³ la⁴teg⁴i² nioh¹ˉ³ jian³ i⁴si⁵hain⁴ m⁵cu³? ");
INSERT INTO cucNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Jianh³ˉ³ júan² hnei³ yo⁴ua²lainh²ˉ³ ca³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Quie¹ jeun⁴³ jia²³ con⁴juah⁴ jm³i⁴sain³⁴ jnia⁴, i⁴juah⁴i³: “Jnia⁴pa² lang⁴³ A³lion³ Chie³ hain⁴.” Jian³ ma⁵can³i³ jeun⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jon³ nauh²ˉ³ i⁴ma³si³tang⁴ nación jian³ nauh²ˉ³ jau²³ i⁴sia³ hnai³ ta⁵seg³⁴ liah⁴, a⁵júan³ hnei³ canh⁴³, quie¹ ton³²nie⁴³ hniah³ si⁵lei⁴ i⁴ne³ ñeih³²; i² si³hain⁴ pi¹ i²tieh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Quie¹ júan³⁴ con³ nación hnai³ i²con²³ nación seg³⁴, jian³ júan³⁴ re¹ hnai³ i²con²³ re¹ sang³⁴ liah⁴, jian³ jia²³ chie² jian³ ho³²cúan⁴, jian³ qui³⁴ húa³⁴ hlion⁴ jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","La⁴jeg³⁴ i⁴ne³ leg⁴³ ma²eu⁴³ quieh¹ co⁴ra⁴lie⁵ pi¹. ");
INSERT INTO cucNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jon³ cúah⁴³i³ hnei³ joh⁴³ cúa³ chie³ i⁴he³⁴i³ ma²eu⁴³ jian³ jŋangh³i³ hnei³ liah⁴, quie¹ la⁴jang³⁴ chie³ li⁴hie²³ hnei³ jm² jon³ nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jian³ jeun⁴³ a³jlian³⁴, jian³ li⁴hion²³i³ a³jan³ jan³ jian³ cúanh⁴³i³ a³jan³ jan³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jian³ jia²³ jeun⁴³ a³ta³jaun²³ a³juah⁴ i⁴lang⁴³i³ a³sain² quian¹ Jon⁴dai¹, jian³ ma⁵can³i³ jeun⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jian³ ai³⁴ i⁴hnio⁴i³ nei² quieh¹ hlion⁴ i⁴hlagh³² lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","I² a³hain⁴ a³sa⁴teinh³ tsei⁴³ jau²³ quien⁴ˉ⁴ liah⁴i² a⁴toh⁴, a³ne³pa² lion⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jian³ hniah³ si⁵hleh³i³ jau²³ la³ liah⁴ leg⁴³ naih⁵ heih⁴³ hm³⁴ quieh¹ A³cua⁴³ ñi⁴jeu⁵ la⁴tan² m⁵cu³ canh⁴a² li⁴ñi³ la⁴jeg³⁴ nación; i² jon³ a²ma⁴ tieh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’I² jon³ ne⁵, liah⁴i² a⁴hleh⁴ Da³nie²³, a³sain² quian¹ Jon⁴dai¹ hain⁴, nei² quieh¹ i⁴jon³ i⁴hieh¹ Jon⁴dai¹ jian³ i⁴ma³tya³; la⁴teg⁴i² jeh²ˉ³ i⁴jon³ seih⁴³ cuah³ hen² ―a³hain⁴ a³heg³ i⁴la³, hniah³ li⁴ŋang⁴i³―, ");
INSERT INTO cucNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jon³ hniah³ cm³⁴ la⁴jang³⁴ a³tionh² húa³⁴ Judea la⁴teg⁴ mah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jian³ a³hain⁴ a³sainh⁴³ yeih³² cah³² a²hnei⁴³, sa⁴hniah³ jyon⁴³i³ juah⁴ i⁴si⁵quien²³i³ meih³ quieh¹ i⁴nie⁴³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Conh⁴liah⁴ a³sainh⁴³ je¹, sa⁴hniah³ chianh³i³ juah⁴ i⁴si⁵quien²³i³ a²cúan³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jian³ ¡ti⁴³ jeu²³ la⁴jang³⁴ a³m⁴ a³ti²chieh¹ jm² jon³ jian³ a³m⁴ a³sian³ yein³ teih⁴ quian¹! ");
INSERT INTO cucNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mh³² hnei³ Jon⁴dai¹ canh⁴a² sa⁴hniah³ jauh¹ˉ³ jain³ cu⁴ i⁴cmh²ˉ³, jian³ o⁴ con³ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Quie¹ eu⁴³ pain⁴ ma²eu⁴³ jia²³ jm² jon³ i⁴sa⁴ma³a⁴leg³⁴ i¹conh⁴ liah⁴ma²ra⁴lie⁵ m⁵cu³ la⁴teg⁴ tieh²la³, jian³ a⁵sie⁴³ lei⁴ la⁴ne³ ta⁵cang³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jian³ juah⁴ne³ sa⁴júan³⁴ Jon⁴dai¹ i⁴co⁴le⁴ jm² jon³, i¹jan³ sa⁴lion⁴; i² nei² quieh¹ a³quianh² ne⁵, júan³⁴i³ i⁴sa⁴si⁵úa⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’I⁴jon³ sa⁴hniah³ hainh⁴ˉ³ i²con²³ chie³ juah⁴ne³ juah⁴i³: “Jeh³², A³ua⁵lion³² Chie³ hain⁴ sainh⁴³ la³”, jian³ o⁴ “Jeh³²i³ sainh⁴³ jno³.” ");
INSERT INTO cucNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Quie¹ jeun⁴³ a³ma³co³ jia²³ a³juah⁴ lang⁴³i³ Cristo jian³ o⁴ a³sain² quian¹ Jon⁴dai¹; jian³ júan³⁴i³ ua³júah² pain⁴ i⁴co³ jnia⁴, canh⁴a² ma⁵can³i³ la⁴teg⁴ a³quianh² a¹juah⁴ li⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Quie¹ ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ liah⁴ma²jia⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","I⁴jon³ sa⁴hniah³ hainh⁴ˉ³ i²con²³ chie³ juah⁴ne³ juah⁴i³: “Jeh³², si²sainh⁴³i³ con³ i²a⁵sian⁴³ a³sian³ jno³”, jian³ o⁴ “Jeh³², ua²cua⁴³ jauh³².” ");
INSERT INTO cucNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Quie¹ liah⁴i² jnia⁵ o¹jyi³ quieh¹ a⁵ñih³ jia²³ ta⁵jia²³ hyie³ teg⁴ ta⁵tyan³ hyie³, la⁴ne³ lei⁴ la⁴teg⁴i² jionh⁴ A³a⁴lang³⁴ Chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Quie¹ i²ra³quian³ he³² jaun², i²jon³ ŋangh³ a¹teu³júa⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’I² tei⁴³i² ma³ua⁴jeu³² ma²eu⁴³ pain⁴ jm² jon³, liah⁴ma²jon³ liah⁴ hyie³, jian³ segh³ liah⁴ a⁵sie⁴³ ma⁵li⁴joh¹, jian³ jyinh³ jah⁴nai⁴³, jian³ jai⁴³ i⁴sia³ ta⁵ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","I² jon³ jnia⁵ con³ i⁴júan³⁴ lei³ ñi⁴jeu⁵ i⁴jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴, jon³ hoh⁵ la⁴jang³⁴ sa¹jeun³ a³tionh² cuah³²húa³⁴, jian³ jen⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ jionh⁴ jeu³ je¹ o¹jnai⁴³ i⁴quian³i³ ua³pei⁴ jian³ i⁴eu⁴³ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jon³ sain³⁴i³ ángel quian¹ con⁴juah⁴ i⁴hain³² tia⁴ a²lau⁴³ trompeta, a³si⁵jaih² la⁴jang³⁴ a³quianh² quian¹i³, a³tionh² li⁵quin⁴ queih³² m⁵cu³ a³jo³² liah⁴ a³jo³². ");
INSERT INTO cucNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Júan² hnei³ i⁴li⁴ŋangh⁴ˉ³ tionh²ˉ³ jau²³ i⁴can¹ˉ⁴ quieh¹ a²hma³ m⁴jyi³: La⁴teg⁴i² si²m²³ a²hma³ jian³ ma³si³hyie²³ o¹úan³² quieh¹, jon³ ñih¹ˉ³ tionh²ˉ³ i⁴ma³hloh³² jain³ jm⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jian³ la⁴ne³ liah⁴ tionh²ˉ³, la⁴teg⁴i² jeh⁴ˉ³ si³lei⁴ la⁴jeg³⁴ i⁴ne³, jon³ ñih¹ˉ³ ma³ja²³ hloh³² i⁴ma³si²sainh⁴³i³ o²hnei³². ");
INSERT INTO cucNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, la⁴jeg³⁴ i⁴la³ lei⁴ naih⁵i² tyan⁴³ chie³ a³sian³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Si⁵hain⁴ ñi⁴jeu⁵ jian³ cuah³²húa³⁴, i² jau²³ quien⁴ˉ⁴ ne⁵, liah⁴ma³li⁴tei⁴³pa². ");
INSERT INTO cucNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Jian³ i¹jan³ sa⁴ñi³ hain³ jm² jian³ o⁴ hain³ o²ra³ si⁵lei⁴, i¹ ángel quian¹ ñi⁴jeu⁵ tionh² sa⁴ñi³; jan³ Neih³ pe²³ˉ⁴ ñi³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’La⁴jon³ liah⁴i² a⁴leg³⁴ jm² ya⁴jo³⁴ ma²sian³ Noé, la⁴ne³ lei⁴ liah⁴ la⁴teg⁴i² jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quie¹ naih⁵i² so³⁴ jm³ ti²queuh³i³ hangh²i³, ti²sanh⁴i³ jian³ ti²cúan⁴³i³ si³jon⁴³ i⁴sanh⁴, la⁴conh⁴i² a⁴tyie³⁴ jm² i⁴a⁴hei³⁴ Noé joh⁴³ a²úan⁴³ leg⁴³ a²hnei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Quie¹ sa⁴ra⁵ŋang⁴ a³ma²tionh² ma²jon³ la⁴conh⁴i² a⁴canh³ jm³ ua⁵guen⁴ la⁴jang³⁴. La⁴ne³ si⁵lei⁴ liah⁴ la⁴teg⁴i² jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jm² jon³ tionh² on³⁴ chie³ je¹; jan³pa² te⁴³i³, jian³ jan³ jian³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jian³ on³⁴ a³m⁴ ti²húah² ti²tionh² nei² a²to²³; jan³pa² te⁴³i³, jian³ jan³ jian³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’I⁴jon³ hniah³ júanh²ˉ³ i⁴naih²ˉ³ tionh²ˉ³, quie¹ sa⁴ñih¹ˉ³ hain³ o²ra³ jionh⁴ Se³ño²³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jian³ ñih¹ˉ³ i⁴la³ liah⁴, juah⁴ne³ ma²ñi³ a³quieh¹ jauh³² hain³ o²ra³ ma²tyie¹ a³júan³ hang³ jauh³² quieh¹i³, jon³ ma²si²jian³i³, jian³ sa⁴ma²cúa³⁴i³ i⁴si⁵hei⁴i³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jian³ la⁴jon³ hnei³ tionh²ˉ³ liah⁴, hniah³ júanh²ˉ³ i⁴tionh²ˉ³ re³; quie¹ jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴ jm² sa⁴jianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Hain³ hnei³ tionh²ˉ³ lang⁴³ la⁴jan³ a³cúa²³ cúa³tag³² ni²taih⁴³ jian³ a³sian³ tsei⁴³, a³a⁴ron⁴³ jeu³² joh⁴³ cúa³ la⁴jang³⁴ a³tionh² jauh³² quieh¹ canh⁴a² guenh⁴³i³ a³hain⁴ tionh² o²ra³ quieh¹? ");
INSERT INTO cucNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Eu⁴³ tsei³⁴ jm² li⁴ren³ a³cúa²³ cúa³tag³² a³ma³tei⁵ la⁴ne³ la⁴teg⁴i² ma³jonh² jeu³²i³ jian³ je⁴³i³ i⁴si²júan³i³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, jon³ tonh³i³ joh⁴³ cúa³ a³cúa²³ cúa³tag³² hain⁴ la⁴jeg³⁴ i⁴sia³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","I² juah⁴ne³ hlangh² a³cúa²³ cúa³tag³² hain⁴ jian³ júan³i³ co³hei²tsei³, lain⁴i³: “Len⁴ pi¹ jeu³²ˉ⁴ i⁴jionh⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jon³ ma⁴lie⁵i³ júanh¹i³ a³cúa²³ cúa³tag³² reunh¹, jian³ la⁴teg⁴ a²hei⁴³ queuh³i³ jian³ hangh²i³ jian²³i³ a³ti²hain⁴³, ");
INSERT INTO cucNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","i² jon³ jionh⁴ jeu³² a³cúa²³ cúa³tag³² hain⁴ jm² sa⁴si²jian²³i³ jian³ o²ra³ sa⁴ñi³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","I² jon³ he³⁴ jeu³²i³ ma²eu⁴³ pain⁴ i²con²³i³, i⁴jainh⁴³i³ liah⁴i² jainh⁴³ a³júan³ a³ni²taih⁴³; i²jon³ hoh⁵i³ tionh² jian³ queuh⁴³i³ m⁴jan² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’I² jon³ ne⁵, i⁴han⁵ chie³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ quian³⁴ a³m⁴ si³yein³ a³a⁴can³⁴ o¹jyi³ jm³co²³ quieh¹ tionh², ua⁵han²i³ ua⁵hyeinh³²i³ a³ñih³ sanh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hña⁴ a³m⁴ hain⁴ re³ nie⁴³ tsei⁴³ tionh², jian³ hña⁴ a³hyein³ tsei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I² a³hyein³ tsei⁴³ hain⁴ tionh², quian³i³ o¹jyi³ jm³co²³ quieh¹, i² a⁵sia³ o¹jm³co²³ quian³i³ jian²³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","I² a³re³ nie⁴³ tsei⁴³ hain⁴ ne⁵, quian³i³ o¹jm³co²³ quieh¹ i⁴tieh³² a²lo³, jian³ quian³i³ o¹jyi³ jm³co²³ quieh¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","I² jon³ a⁴len⁴ a³ñih³ a³sanh⁴ hain⁴. I² hei⁴i³ tionh² ne⁵, ja³⁴ sie⁴ m⁴nei²i³ tionh², a⁴cm³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","I² jon³ ne⁵, con³ma²a⁴teg⁴ i⁴húa²³, jon³ a⁴naih⁵ hleh²i³ tia⁴, juah⁴i³: “¡Jeh³² a³ñih³ a³sanh⁴ ma³ja²³! ¡Cua³ ua⁴hyeinh³² hnei³ tionh²ˉ³!” ");
INSERT INTO cucNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","I² jon³ ra⁴hang³² la⁴jang³⁴ a³m⁴ si³yein³ hain⁴ tionh², a⁴júan⁴i³ co³jian¹ o¹jyi³ a²heu³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","I² a³hyein³ tsei⁴³ hain⁴ tionh² ne⁵, a⁴sagh⁴³i³ a³re³ nie⁴³ tsei⁴³ hain⁴: “Cúa² hnei³ co⁴meih³ o¹jm³co²³ hnie³ jnie³², quie¹ ma³si³liah⁴ o¹jyi³ a²heu³ quian⁴ jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","I² a³m⁴ a³re³ nie⁴³ tsei⁴³ hain⁴ tionh² ne⁵, jon³ a⁴sagh⁴³i³ a³hain⁴: “A⁵sia³, canh⁴a² sa⁴lei⁴ quian⁴ jnie³² i⁴si³hain⁴ liah⁴i² a⁴jainh⁴³ˉ³ tionh²ˉ³. Eu⁴³a² re³ ua⁴lia⁴³ quianh³ teg⁴ i²hnang³i³.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","I² con³ma²ua⁵han² li⁵hña⁴ a³m⁴ hyein³ tsei⁴³ hain⁴ i⁴ua⁵lia⁴³i³, jon³ a⁴tyie³⁴ a³ñih³ a³sanh⁴ hain⁴. I² a³m⁴ a³tionh² co³jian¹ hain⁴, a⁴han⁵i³ jian²³i³ a³ñih³ hain⁴ jauh³² i²júan³i³ jm² i²sanh⁴, jian³ a⁴jnang³⁴ o²hnei³². ");
INSERT INTO cucNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Coh⁵ jon³ a²ma⁴ a⁵han² a³m⁴ si³yein³ sang³⁴ hain⁴ tionh², a⁴juah⁴i³: “¡A³don⁵, a³don⁵ ta³, nia¹ quian⁴ jnie³²!” ");
INSERT INTO cucNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","I² hei⁴i³ ne⁵, a⁴ŋangh³i³: “I⁴chie⁴³pa² juah³ˉ⁴, sa⁴cm⁴³ˉ⁴ hnei³ tionh²ˉ³”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’I⁴jon³ hniah³ júanh²ˉ³ i⁴naih²ˉ³, quie¹ sa⁴ñih¹ˉ³ hain³ jm² a⁵ga⁴ o²ra³ jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Conh⁴liah⁴ i⁴han⁵ chie³ naih⁵ heih⁴³ quieh¹ A³cua⁴³ ñi⁴jeu⁵ leg⁴³ liah⁴i² lang⁴³ jan³ a³ñih³ a³ŋo²³ i²gm⁴; i² naih⁵i² chie³⁴i³ ne⁵, a⁴teh³i³ a³cúa²³ cúa³tag³² i²con²³i³ jian³ a⁴tonh³i³ joh⁴³ cúa³ a³hain⁴ tionh² la⁴jeg³⁴ i⁴sia³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’I² jon³ a⁴cúa⁴i³ hña⁴ o¹cau³² tie³ talento i²con²³ jan³ hain⁴, jian³ a⁴cúa⁴i³ teun³⁴ talento i²con²³ i²jan³ liah⁴, conh⁴liah⁴ i²jan³ a⁴cúah³i³ con³ talento liah⁴, a⁴cúa⁴i³ i²con²³ con⁴jan³ hain⁴ la⁴conh⁴ tieh¹i³ i⁴li⁴hion⁴i³. I² jon³ ŋo³⁴ jeu³²i³ jeu³ gm⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","I² a³ma³a⁴hyei⁴ hña⁴ o¹cau³² talento hain⁴, jon³ a⁴júan⁴i³ ta¹ o¹cau³² jon³, jian³ ta⁴tsain¹ hña⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jian³ la⁴ne³ liah⁴ a³a⁴hyei⁴ teun³⁴, ta⁴tsain¹ teun³⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","I² a³a⁴hyei⁴ con³ ne⁵, a⁴cag³⁴i³ con³ to³ húa³⁴, a⁴hma⁴i³ o¹cau³² quieh¹ jeu³². ");
INSERT INTO cucNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’I² con³ma²ua⁴jeu³² hlion⁴ jm², jon³ a⁴tyanh³ jeu³² a³cúa²³ cúa³tag³² hain⁴ tionh², i² jon³ a⁴con²³i³ jau²chie⁴³ ta¹ quieh¹ a³hain⁴ tionh² jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Co⁴ra⁴lie⁵ a⁴tyie³⁴ a³a⁴hyei⁴ hña⁴ o¹cau³² talento hain⁴, jian³ quien²³i³ i²hña⁴, juah⁴i³: “Hnei³ a³don⁵, hña⁴ o¹cau³² talento ma²a⁴cúah³²ˉ³ jnia⁴ jon³, jeh³² la³, jian³ a⁴lag³⁴ˉ⁴ i²hña⁴ nei² jon³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jon³ a⁴juah⁴ jeu³²i³ i²con²³i³: “Tsei³⁴, hnei³ a³cúa²³ cúa³tag³² a³tsein²³ jian³ a³ni²taih⁴³; quie¹ re³ ma⁴teih³²ˉ³ ua²liah⁴a² co⁴meih³, i⁴jon³ tonh¹ˉ⁴ joh⁴³ cúah³ˉ³ hlion⁴. Júan² hnei³ si³hyonh³ jianh² jnia⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Conh⁴liah⁴ a⁴tyie³⁴ a³a⁴hyei⁴ teun³⁴ o¹cau³² talento hain⁴, juah⁴i³: “Hnei³ a³don⁵, teun³⁴ o¹cau³² talento ma²a⁴cúah³²ˉ³ jnia⁴ jon³; jeh³² la³, jian³ a⁴lag³⁴ˉ⁴ i²teun³⁴ nei² jon³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jon³ a⁴juah⁴ jeu³²i³ i²con²³i³: “Tsei³⁴, hnei³ a³cúa²³ cúa³tag³² a³tsein²³ jian³ a³ni²taih⁴³; quie¹ re³ ma⁴teih³²ˉ³ ua²liah⁴a² co⁴meih³, i⁴jon³ tonh¹ˉ⁴ hlion⁴ joh⁴³ cúah³ˉ³. Júan² hnei³ si³hyonh³ jianh² jnia⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","I² jon³ a⁴tyie³⁴ a³ma³a⁴hyei⁴ con³ o¹cau³² talento hain⁴ liah⁴, juah⁴i³: “Hnei³ a³don⁵, quie¹ yan³²ˉ⁴ i⁴langh⁴³ˉ³ jan³ a³hyan³ tsei⁴³, quie¹ queunh³ˉ³ i²sa⁴a⁴jñih⁴ˉ³, quie¹ lainh⁴ˉ³ ta¹ quieh¹ a³sang²³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","I⁴jon³ ra⁵co⁴³ˉ⁴, ñei³²ˉ⁴ ni²hma³⁴ˉ⁴ o¹cau³² quianh³ˉ³ naih⁵ húa³⁴. Jeh³² la³, janh³ hnei³ quianh³.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","I² jon³ a⁴juah⁴ jeu³²i³: “Hnei³ a³cúa²³ cúa³tag³² hlangh² a³jeunh³; ñih¹ hnei³ i⁴queun³⁴ˉ⁴ i²sa⁴jan³⁴ˉ⁴, jian³ jaih³²ˉ⁴ i²sa⁴a⁴jnei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","I⁴jon³ ma²hniah³ ma²tonh²ˉ³ o¹cau³² quien⁴ˉ⁴ jauh³² banco canh⁴a² ma²ta⁵tsain¹, jon³ ma²li⁴hyeih³²ˉ⁴ tei⁴³i² ma³cúan⁵ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","I² jon³ ne⁵, qui⁴³ hnei³ o¹cau³² quieh¹ a³la³, jian³ cúah³² a³quian³ quia³⁴ o¹cau³² talento. ");
INSERT INTO cucNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Quie¹ a³hain⁴ a³ma³quian³, hyieh⁴ pi¹i³. I² a³hain⁴ a³sa⁴quian³ ne⁵, la⁴teg⁴ i⁴peih¹ i⁴quian³i³ jon³, qui⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","I² a³cúa²³ cúa³tag³² a³sa⁴tei⁴³ ta¹ la³, cua³ ua⁴tion²³ coh⁵hnei³² i²naih³; i²jon³ hoh⁵ chie³ jian³ queuh⁴³i³ m⁴jan².” ");
INSERT INTO cucNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’La⁴teg⁴i² jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴ i⁴eu⁴³ júanh⁴³i³ jian²³i³ la⁴jang³⁴ ángel tsein²³ quian¹, jon³ cua³⁴i³ nei² a²ma³sei² tyein² quieh¹ i⁴quian³ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","I² jon³ ŋangh⁴³ chie³ a³sian³ la⁴jeg³⁴ nación ta⁵nei² hei⁴i³, jon³ ron⁵i³ a³hain⁴ tionh² teun³⁴ hna³, liah⁴i² júan³ jeu³² a⁵a³siah³ jen² a²sain²ñih³ jian²³ a⁵a³siah³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I² jon³ ron⁵i³ la⁴jang³⁴ a⁵a³siah³ jo³² ta⁵chie³⁴, jian³ sainh³i³ a²sain²ñih³ jo³² ta⁵quegh³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","I² jon³ juah⁴ Re¹ i²con²³ a³tionh² jo³² ta⁵chie³⁴ quieh¹: “Nia³ hnei³ tionh²ˉ³, a³tsei³⁴ jm² ren³ quian¹ Neih³ˉ⁴ i⁴hanh⁵ˉ³ con³ i²júan³i³ heih⁴³ i⁴a⁴leg³⁴ re³ quianh³ˉ³ liah⁴ma²ra⁴lie⁵ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Quie¹ ra⁵cúan⁴³ˉ⁴, jian³ a⁴cúah²ˉ³ i⁴a⁴queuh³ˉ⁴; ra⁵quein³ tsei³⁴ˉ⁴, jian³ a⁴cúah²ˉ³ i⁴a⁴lauh⁵ˉ⁵; a⁴ŋeng³⁴ˉ⁴ la⁴jan³ a³sian³ ta⁵seg³⁴, jian³ a⁴cúah²ˉ³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jian³ i⁴sa⁴sia³ a²cúan³⁴ˉ⁴, jian³ a⁴cúah²ˉ³ a⁴heu³⁴ˉ⁴; ra⁵chieh¹ˉ⁴, jian³ ma⁴hoh³²ˉ³ jnia⁴; ma²hein³²ˉ⁴ ni⁴ñi²³, jian³ ni²jeh³²ˉ³ jnia⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","I² jon³ li⁴ŋangh³ a³ni²taih⁴³ hain⁴ tionh² i²con²³i³: “Hnei³ Se³ño²³, ¿legh⁴ a⁴nia³² jnie³² hnei³ i⁴cuanh⁴³ˉ³, jian³ a⁴cúa² jnie³² i⁴a⁴cauh⁴³ˉ³, jian³ o⁴ i⁴quein³ hoh⁴³ˉ³, jian³ a⁴cúa² jnie³² i⁴a⁴hainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jian³ o⁴ legh⁴ a⁴nia³² jnie³² hnei³ i⁴a⁴ŋengh²ˉ³ la⁴jan³ a³sian³ ta⁵seg³⁴, jian³ a⁴cúa² jnie³² jauh³²? ¿Jian³ o⁴ legh⁴ a⁴nia³² jnie³² hnei³ i⁴sa⁴sia³ a²cúanh³ˉ³, jian³ a⁴cúa² jnie³² i⁴a⁴heuh³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jian³ o⁴ legh⁴ a⁴nia³² jnie³² hnei³ ma²ra³chieh¹ˉ³, jian³ ma⁴hon³² jnie³² hnei³? ¿Jian³ o⁴ legh⁴ a⁴nia³² jnie³² hnei³ a³ma²heinh³²ˉ³ ni⁴ñi²³, jian³ i⁴ni²nia³² jnie³² hnei³ liah⁴?” ");
INSERT INTO cucNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","I² jon³ a⁴jainh³ Re¹ jau²³, juah⁴i³: “I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, con³ma²ma⁴honh³²ˉ³ jan³ a³peih¹ jen² si³reunh³ˉ⁴ la³, i²con²³ jnia⁴pa² a⁴júanh²ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’I² jon³ juah⁴ Re¹ i²con²³ a³tionh² jo³² ta⁵quegh³ quieh¹: “Quein⁴³ hnei³ i²gm⁴ i²con²³ˉ⁵, a³ma³ua⁵hain⁴ tionh² la⁴teg⁴ je¹ o¹jyi³ loh⁴³ i⁴sa⁴legh⁴ ua²a⁴au³, i⁴a⁴júan⁴ Jon⁴dai¹ quieh¹ a³sa⁴tsein³⁴ jian³ ángel quian¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Quie¹ ra⁵cúan⁴³ˉ⁴, i² sa⁴a⁴gueh³²ˉ³ jnia⁴; ma²i²quein³ tsei³⁴ˉ⁴, i² sa⁴a⁴cúah²ˉ³ i⁴lauh³²ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jian³ ma²ŋeng³⁴ˉ⁴ la⁴jan³ a³sian³ ta⁵seg³⁴, i² sa⁴a⁴cúah³²ˉ³ jnia⁴ jauh³²; jian³ i⁴sa⁴sia³ a²cúan³⁴ˉ⁴, i² a⁵sia³ a⁴cúah²ˉ³ a⁴heu³⁴ˉ⁴; ra⁵chieh¹ˉ⁴ liah⁴, jian³ sa⁴ma⁴hoh³²ˉ³ jnia⁴; jian³ ma²hein³²ˉ⁴ ni⁴ñi²³, i² sa⁴ni²jeh³²ˉ³ jnia⁴ tionh²ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","I² jon³ li⁴ŋangh³ a³hain⁴ i²con²³i³: “Hnei³ Se³ño²³, ¿legh⁴ a⁴nia³² jnie³² hnei³ i⁴cuanh⁴³ˉ³, i⁴quein³ hoh⁴³ˉ³, jian³ sa⁴ma⁴hon³² jnie³² hnei³? ¿Jian³ legh⁴ a⁴nia³² jnie³² hnei³ i⁴a⁴ŋengh²ˉ³ la⁴jan³ a³sian³ ta⁵seg³⁴, jian³ o⁴ i⁴sa⁴sia³ a²cúanh³ˉ³, jian³ o⁴ ra⁵chieh¹ˉ³, jian³ o⁴ ma²heinh³²ˉ³ ni⁴ñi²³, jian³ sa⁴ma⁴hon³² jnie³² hnei³ liah⁴?” ");
INSERT INTO cucNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","I² jon³ juah⁴ Re¹ i²con²³i³ tionh²: “I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴jeg³⁴ i⁴sa⁴a⁴júanh²ˉ³ i²con²³ jan³ jen² chie³ peih¹ la³, i²con²³ jnia⁴pa² sa⁴a⁴júanh²ˉ³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jon³ si⁵han² a³hain⁴ si⁵quian⁴i³ ma²eu⁴³ i⁴sa⁴ton³ jm² ua²tya⁴³, i² a³ni²taih⁴³ hain⁴ tionh² ne⁵, hyei³⁴i³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","I² con³ma²a⁴toh⁴ i⁴a⁴hleh⁴ Jesús la⁴jeg³⁴ jau²³ ne³, jon³ a⁴juah⁴i³ i²con²³ chie³ quian¹: ");
INSERT INTO cucNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Quie¹ ñih¹ˉ³ tionh²ˉ³ yie⁴ la³ teg³⁴ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, jian³ cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ i⁴tion³⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","I² la⁴jang³⁴ m³chie³ tyein², jian³ a²teg²³ quian¹ lai²³, jian³ a³don⁵ ma⁴³teg²³ quian¹ judío, jon³ a⁴ŋangh³i³ coh⁵hnei³² jauh³² quieh¹ jeu³² m³chie³ a³sain³ Caifás. ");
INSERT INTO cucNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","I² jon³ a⁴júan⁴i³ re³ i⁴sanh³i³ Jesús con⁴juah⁴ jau²ta³jau²³ i⁴jŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","I² a⁴júanh⁴i³ tionh²: ―Sa⁴hniah³ júan³²ˉ¹ ta¹la⁴ jm², canh⁴a² sa⁴ra⁵hang³² a³jeu³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma²hein² Jesús jeu³ Betania jauh³² quieh¹ Si²úan¹ a³ma²teh²i³ a³lang⁴³ chie² i⁴jyih² o¹ŋeu⁴³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","I² jon³ a⁴tyie³⁴ jan³ a³m⁴ i²con²³i³ a³quian³ con³ m⁴tsai³² peih¹ i⁴leg⁴³ alabastro i⁴tieh³² o¹jm³no¹ ma³jeu³ jian³ i⁴quein⁴³ hlion⁴ mai²³, jon³ a⁴sie⁴i³ ma³tyi² Jesús a³ua²cua⁴³ mesa. ");
INSERT INTO cucNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","I² con³ma²a⁴je³⁴ chie³ quian¹i³, ta² a⁴jain²³ tsei⁴³i³ tionh², juah⁴i³: ―¿Henh⁴le³⁴ ma⁴hain³i³ i⁴quein⁴³ hlion⁴ ne³? ");
INSERT INTO cucNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Quie¹ ma²li⁴hnang³⁴i³ hmah¹ húanh², canh⁴a² ma²ma⁵hon³²i³ a³ti⁴ñei³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","I² jon³ ra⁵laih² Jesús jau²³ i⁴ti²hleh²i³, a⁴juah⁴i³: ―¿Henh⁴le³⁴ si⁵quianh³²ˉ³ tsei⁴³ a³m⁴ la³ tionh²ˉ³? Quie¹ a⁴júan⁴i³ con³ i⁴tsei³⁴ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Quie¹ la⁴jeg³⁴ nie⁴³pa² tionh² a³ti⁴ñei³ jenh²ˉ³ tionh²ˉ³, i² jnia⁴ ne⁵, a⁵sie⁴³ ma⁵jeh³²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Quie¹ i⁴a⁴sie⁴i³ o¹jm³no¹ ma³jeu³ ne³ i²con²³ˉ⁵ i⁴a⁴júanh³i³ he³⁴ˉ⁴ naih⁵i² ho³⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴tan² i²hleh³i³ jau²³ quien⁴ˉ⁴ la³, la⁴tan² m⁵cu³, jian³ tya³⁴i³ jau²³ liah⁴ a⁴júan⁴ a³m⁴ la³ i²con²³ˉ⁵, canh⁴a² tyon⁴³ tsei⁴³ chie³ tionh² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","I² jon³ ŋo³⁴ jan³ a³hein² jen² quia⁵teun⁴ chie³ quian¹i³, a³sain³ Judas Iscariote, ua⁵jen³²i³ m³chie³ tyein² tionh², ");
INSERT INTO cucNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a⁴juah⁴i³ i²con²³i³: ―¿Conh⁴ cúah²ˉ³ i²con²³ˉ⁵ juah⁴ne³ cúanh³²ˉ⁴ Jesús joh⁴³ cúah³ˉ³ tionh²ˉ³? I² jon³ ma⁴hmah³² a³hain⁴ quieh¹i³ qui⁴quia⁴ o¹cau³² i⁴leg⁴³ o¹cau³² tie³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","I² jon³ a⁴hnoh³ Judas liah⁴ma²jm² jon³ liah⁴ li⁴tag³⁴ i⁴li⁴cúanh⁴³i³ Jesús joh⁴³ cúa³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","I² con³ma²a⁴teg⁴ jm² co⁴ra⁴lie⁵ i⁴júan³i³ jm² i⁴queuh³i³ a²hei⁴³ñih¹ i⁴sa⁴hei¹ o¹sieh³², jon³ a⁴tyie³⁴ chie³ quian¹ Jesús i²con²³i³, a⁴juah⁴i³: ―¿Jainh¹ hnoh³ˉ³ si²júan²³ jnie³² co³jian¹ ma³⁴ i⁴queuh²ˉ³ jm² la³, jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto? ");
INSERT INTO cucNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","I² jon³ a⁴juah⁴ Jesús: ―Cua³ la⁴teg⁴ je¹jeu³ i²con²³ jan³ a³ñih³, i² jon³ saih³²i³ hnei³ jau²³ la³: “La⁴la³ juah⁴ A²teg²³: Ma³ja²³ hloh³² o²ra³ quien⁴ˉ⁴; tieh²la³ júan³²ˉ⁴ jm² la³ jauh³² quianh³ˉ³ jian²³ˉ⁵ chie³ quian³⁴, jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto.” ");
INSERT INTO cucNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jon³ a⁴júan⁴ chie³ quian¹ Jesús heih⁴³ i⁴a⁴júan⁴i³, a⁴júan⁴i³ ma³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","I² con³ma²a⁴nai³, jon³ a⁴cua⁴ Jesús a²me²sa³ jian²³i³ quia⁵teun⁴ chie³ quian¹i³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","I² con³ma²ti²queuh³i³ a²hei⁴³, jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i⁴jan³ hnei³ cúah⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jon³ ta² chionh⁴ tsei⁴³i³ tionh² a⁴leg³⁴, jon³ ma⁴lie⁵ con⁴jan³ a⁴sagh⁴³i³ Jesús: ―¿O⁴ jnia⁴ Se³ño²³? ¿O⁴ jnia⁴ Se³ño²³? ");
INSERT INTO cucNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―A³hain⁴ a³queuh⁴³ con³ a²gm⁴³ jian²³ˉ⁵, a³hain⁴pa² cúah⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","I⁴chie⁴³pa² hniah³ lei⁴ i²con²³ A³a⁴lang³⁴ Chie³ hain⁴ liah⁴i² ra³sag² nei² quieh¹i³; i² a³cúah⁴³ quieh¹i³ ne⁵, ¡ti⁴³ jeu²³ a³hain⁴! Eu⁴³ ma²re³ juah⁴ne³ sa⁴ma²ra⁵sian³ a³ñih³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jon³ a⁴hleh⁴ Judas, a³hain⁴ a³cúanh⁴³ Jesús, a⁴juah⁴i³: ―Hnei³ A²teg²³, ¿o⁴ jnia⁴ a³hain⁴? Jon³ a⁴juah⁴ Jesús: ―Jen³⁴, liah⁴ a⁴juah¹ˉ³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","I² con³ma²ti²queuh³i³ a²hei⁴³, jon³ a⁴tang⁴ Jesús a²hei⁴³ñih¹, a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, a⁴jeun³⁴i³, jian³ a⁴cúah³i³ chie³ quian¹, a⁴juah⁴i³: ―Janh³ i⁴la³ tionh²ˉ³, cauh⁴³; quie¹ i⁴la³ leg⁴³ he³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jon³ a⁴tang⁴i³ a²va²so³ liah⁴, a⁴cúa⁴i³ ti²hmah³², jon³ a⁴cúa⁴i³ i²con²³i³ tionh², a⁴juah⁴i³: ―Hainh⁴ hnei³ la⁴jangh³ˉ³ i⁴tieh³² a²va²so³ la³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Quie¹ i⁴la³ leg⁴³ jm³yein⁴ quien⁴ˉ⁴ i⁴lei⁴ re³ con³ jau²³ hm³⁴, jian³ tain³⁴ jm³yein⁴ quien⁴ˉ⁴ nei² quieh¹ jeun⁴³ canh⁴a² jlenh⁴³ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ liah⁴, la⁴teg⁴ jm² i⁴tieh²ˉ¹ ne³⁴, a⁵sie⁴³ ma⁵lauh³²ˉ⁴ o¹bein² quieh¹ o¹m⁴ ya¹gm³jeh² i⁴lauh³²ˉ⁴ jian²³ˉ⁵ hnei³ tionh²ˉ³ liah⁴ i⁴seg³⁴, la⁴teg⁴ jm² i⁴júan³⁴ Neih³ˉ⁴ heih⁴³ nei² m⁵cu³ la³pa². ");
INSERT INTO cucNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","I² con³ma²a⁴he⁴i³ con³ seun²³ quieh¹ Jon⁴dai¹, jon³ ua⁵han²i³ mah⁴ quieh¹ a²hma³ Olivos tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Tonh³²ˉ³ jnia⁴ la⁴jangh³ˉ³ tionh²ˉ³ je¹nai³ ne³⁴; quie¹ ra³juah⁴ ra³sag² Ma²jyi³: “Júanh²ˉ⁵ jeu³² a⁵a³siah³, jian³ ma⁵quein²³ so⁵jenh³ a⁵a³siah³.” ");
INSERT INTO cucNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","I² la⁴teg⁴i² ma³a⁴hyon²³ˉ⁵ ne⁵, jon³ naih²ˉ⁵ húa³⁴ Galilea naih⁵i² cuanh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Ua²liah⁴a² la⁴jang³⁴ ton³⁴ hnei³, i² jnia⁴ ne⁵, a⁵sian⁴³ hnei³ ton²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, je¹nai³ ne³⁴, naih⁵i² hoh⁵ a¹hyie²³, juah²ˉ³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ hnang²³ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","I² jon³ a⁴juah⁴ Pe³²: ―Ua²liah⁴a² hniah³ jaun⁴ˉ⁴ jian²³ˉ⁵ hnei³, sa⁴legh⁴ ua²a⁴jlian²³ˉ⁵. Conh⁴liah⁴ la⁴jon³ a⁴juah⁴ la⁴jang³⁴ chie³ quian¹i³ co³nai². ");
INSERT INTO cucNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jon³ a⁴tyie³⁴ Jesús jian²³ chie³ quian¹i³ con³ i²sain³ Getsemaní, i² jon³ a⁴sagh⁴³i³ chie³ quian¹: ―Nei⁴ hnei³ i²la³ tionh²ˉ³ ta¹la⁴ nai³²ˉ⁴ i²jno³ ni¹mh⁵ˉ⁵ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jon³ jian³i³ Pe³² jian³ li⁵uan⁴ si³jon⁴³ Zebedeo. I² jon³ eu⁴³ chionh⁴ tsei⁴³ Jesús a⁴leg³⁴ jian³ so⁵ñi³i³ liah⁴ sian³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Ta² chionh⁴ tsei³⁴ˉ⁴ hlion⁴ mai²³, ta² li⁴jaun⁴ˉ⁴, lain³⁴ˉ⁴. Jian² hnei³ i²la³ tionh²ˉ³, ua²ti²naih²ˉ³ jianh²ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jon³ ŋo³⁴i³ ta⁵nei² i²co⁴meih³, a⁴quie³i³ húa³⁴ ta⁵ra³hain²³i³, a⁴mh³i³ Jon⁴dai¹, i⁴juah⁴i³: ―Hnei³ Neih³ˉ⁴, qui⁴³ hnei³ ma²eu⁴³ pain⁴ i⁴jia²³ i²con²³ˉ⁵, a¹juah⁴ li⁴lei⁴; i² ua²lei⁴ liah⁴ hnoh³ hnei³, a⁵jon⁴³ liah⁴ hno⁵ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jon³ jonh² Jesús i²tionh² chie³ quian¹i³, a⁴jen³i³ i⁴ti²cm²i³, jon³ a⁴sagh⁴³i³ Pe³²: ―¿O⁴ la⁴ne³ sa⁴tianh³²ˉ³ júanh²ˉ³ ti²naih²ˉ³ jianh²ˉ³ jnia⁴ con³ o²ra³? ");
INSERT INTO cucNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Júan² hnei³ ti²naih²ˉ³ tionh²ˉ³ jian³ mh³² hnei³ Jon⁴dai¹ canh⁴a² sa⁴tianh⁵ˉ³ tei⁴³i² jia²³ jau²chie⁴³ i²conh²ˉ³. Quie¹ i⁴chie⁴³pa² hnie³⁴ m⁴tyi⁴ quianh³ˉ³ i⁴ma⁴tei⁵, i² heh³²ˉ³ ne⁵, sa⁴tieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jon³ ŋo³⁴i³ liah⁴ i⁴seg³⁴, ua⁵mh²i³ Jon⁴dai¹ a²teg⁴ taun³⁴ nie⁴³, juah⁴i³: ―Hnei³ Neih³ˉ⁴, juah⁴ne³ sa⁴tian⁴ i⁴li⁴qui⁴ ma²eu⁴³ pain⁴ ne³ i²con²³ˉ⁵, ua²lei⁴ heih⁴³ quianh³ˉ³ júah³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jon³ jonh²i³ liah⁴ i⁴seg³⁴ i²tionh² chie³ quian¹, a⁴jen³i³ i⁴ti²cm²i³, quie¹ eu⁴³ si²canh³ sie⁴ nei²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","I² jon³ a⁴tain³⁴i³ liah⁴, ŋo³⁴i³ liah⁴ i⁴seg³⁴ ua⁵mh²i³ Jon⁴dai¹ a²teg⁴ hnang²³ nie⁴³, a⁴hleh⁴i³ la⁴jon³pa² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","I² jon³ a⁴tyanh³i³ i²con²³ chie³ quian¹ ne⁵, a⁴juah⁴i³: ―Cm³ hnei³ quianh³ tionh²ˉ³ júah³, tai³² san⁴ hnei³. Quie¹ ma³a⁴teg⁴ o²ra³ i⁴cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ a³ti²ren³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ra⁴hang³², ma³²ˉ¹; jeh³², ma³ja²³ a³cúah⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","I² ma²si²hleh² pi¹ Jesús, con³ a⁴la³ a⁴tyie³⁴ Judas, a³hein² jen² quia⁵teun⁴ chie³ quian¹i³, jian³ jian²³i³ jeun⁴³ chie³ a³ti²quian³ a²ñi²tag⁴ jian³ a²hma³, a³sain² quian¹ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³ quian¹ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","I² Judas, a³cúah⁴³ hain⁴, a⁴júan⁴i³ re³ ñeih³² jian²³i³ a³hain⁴ tionh² i⁴júan³⁴i³ con³ lei³, juah⁴i³: ―A³hain⁴ a³seinh¹ˉ⁴ nei², a³hain⁴pa² hain⁴; sianh³² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Con³ a⁴la³ a⁴tyie³⁴ a³hain⁴ i²con²³ Jesús, a⁴cúan⁴³i³ dai¹, a⁴juah⁴i³: ―Hnei³ A²teg²³. Ma²jon³ a⁴seinh⁴i³ nei². ");
INSERT INTO cucNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","I² jon³ a⁴juah⁴ Jesús: ―Hnei³ a³ñi³reunh³ˉ⁴, ¿henh⁴ ta¹ a⁴niah³ˉ³? I² jon³ a⁴tyie³⁴ a³jeun⁴³ tionh² hlonh² Jesús, a⁴sanh³i³, a⁴júan⁴i³ chion³². ");
INSERT INTO cucNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","I² jan³ a³jian²³ Jesús hain⁴, a⁴tyi³i³ a²ñi²tag⁴ quieh¹, a⁴júanh¹i³ jan³ a³cúa²³ cúa³tag³² i²con²³ jeu³² m³chie³, a⁴queih³i³ ta³ra³cua¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Tienh³ a²ñi²tag⁴ quianh³ a²lo³. Quie¹ la⁴jang³⁴ a³si³tang⁴ jeu³ a²ñi²tag⁴ jaun⁴ jeu³ a²ñi²tag⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿O⁴ a⁵sia³ lei⁴ li⁴mh³²ˉ⁴ Neih³ˉ⁴ tieh²la³, lainh⁴ˉ³, i⁴sain³⁴i³ quia⁵teun⁴ hna³ ángel, ta⁵la⁵mai²³, i²con²³ˉ⁵? ");
INSERT INTO cucNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","I² juah⁴ne³ júan¹ˉ⁴ la⁴ne³, ¿liah⁴ li⁴tei⁴³ jau²³ ra³sag² liah⁴ hniah³ jain⁴³ˉ⁴ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","O²ra³ jon³ a⁴juah⁴ Jesús i²con²³ chie³ jeun⁴³ hain⁴: ―¿O⁴ a⁴niah³ˉ³ tionh²ˉ³ i⁴jmah³²ˉ³ jnia⁴ ti²quianh²ˉ³ a²ñi²tag⁴ jian³ a²hma³ liah⁴i² sanh²i³ hang³? Quie¹ la⁴jeg³⁴ jm² ma²he³⁴ˉ⁴ jau²³ jenh²ˉ³ tionh²ˉ³ cuah³júah², jian³ sa⁴a⁴sienh²ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","I² la⁴jeg³⁴ i⁴la³ lei⁴ tieh²la³ canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴sag⁴ a³sain² tionh². I² la⁴jang³⁴ chie³ quian¹ Jesús ne⁵, a⁴ton³⁴i³ quieh¹i³, a⁴cm⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","I² a³a⁴sanh³ Jesús tionh², jon³ ni²jan³i³ i²con²³ jeu³² m³chie³ Caifás, i²ti²ŋangh³ a²teg²³ quian¹ lai²³ jian³ a³don⁵ ma⁴³teg²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","I² Pe³² ne⁵, ya¹tyein¹ coh⁵ i²ma³gm⁴ la⁴conh⁴i² a⁴hei³⁴i³ coh⁵hnei³² quieh¹ jeu³² m³chie³; i² con³ma²a⁴hei³⁴i³, jon³ a⁴cua⁴i³ jian²³ po³li³sei¹, canh⁴a² je³⁴i³ liah⁴ si⁵lei⁴ la⁴jeg³⁴ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","I² la⁴jang³⁴ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³ jian³ la⁴jang³⁴ si³ta¹ canh² sang³⁴, jon³ a⁴hnoh³i³ chie³² jau²ta³jau²³ liah⁴ li⁴hnang⁵i³ Jesús canh⁴a² cúanh⁴³i³ i⁴jŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","I² sa⁴a⁴chieh¹i³ ne⁵, ua²liah⁴a² ma⁴jnia³² jeun⁴³ a³a⁴cúa⁴ chie³² jau²ta³jau²³. I² i²a⁴toh⁴, jon³ a⁴tyie³⁴ on³⁴ a³a⁴cúa⁴ chie³² jau²ta³jau²³ liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a³a⁴juah⁴: ―A⁴juah⁴ a³ne³: “Quie¹ li⁴jeun²³ˉ⁵ cuah³júah² quieh¹ Jon⁴dai¹, i² tei⁴³i² ma³a⁴teg⁴ hneng³ jm², jon³ li⁴sieh³²ˉ⁴ liah⁴”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jon³ a⁴no³ jeu³² m³chie³, a⁴sagh⁴³i³ Jesús: ―¿O⁴ i¹con³ jau²³ sa⁴li⁴jainh²ˉ³? Jeh³² ¿henh⁴ hleh²i³ nei² quianh³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","I² Jesús ne⁵, i¹con³ sa⁴ŋang³i³. Jon³ a⁴juah⁴ jeu³² m³chie³ i²con²³i³: ―Jeu³⁴ˉ⁴ hnei³ con⁴juah⁴ jm³i⁴sain³ Jon⁴dai¹ a³sian³ i⁴jeuh³²ˉ³ jnie³² juah⁴ne³ hnei³ langh⁴³ A³ya⁴lion³² Chie³ hain⁴, A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Chie⁴³pa² liah⁴ jau²³ a⁴juah¹ˉ³ ne³, jian³ sia³ con³ jau²³ i⁴jeu¹ˉ⁴ hnei³ tionh²ˉ³ liah⁴, ta⁵i²chie³²ˉ¹ la³ jenh³²ˉ³ A³a⁴lang³⁴ Chie³ hain⁴ a³ua²cua⁴³ jo³² ta⁵chie³⁴ quieh¹ Jon⁴dai¹ a³li⁴júan³⁴ la⁴jeg³⁴, jian³ jionh⁴i³ jeu³ je¹ o¹jnai⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jon³ a⁴cag³⁴ jeu³² m³chie³ a²cúan³ i⁴jain²³ tsei⁴³i³, juah⁴i³: ―¡A⁴hleh⁴ a³ne³ jau²³ i⁴hieh¹ Jon⁴dai¹! ¿Henh⁴a² ma⁵hniah³ a³hnang⁵ quieh¹i³ ton³²nie⁴³? Jeh³², húanh⁴pa² hnei³ a⁴naih³ˉ³ tieh²la³ jau²³ i⁴hieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","I² ne³ ne⁵, ¿liah⁴ co³hei²tsei³ quianh³ˉ³? Jon³ a⁴ŋangh³ a³hain⁴ tionh², juah⁴i³: ―Ren³i³ chie³² pain⁴ i⁴hniah³ jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","I² jon³ a⁴hñei³⁴i³ tionh² jm³teuh¹ nei² Jesús, jian³ ma⁴jno³i³. Jian³ ca³chion²³ a⁴quein⁴ nei²i³, ");
INSERT INTO cucNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","juah⁴i³: ―Hnei³ a³juah⁴ lang⁴³ A³lion³ Chie³, ¡tyi² hnei³ jau²³, hain³ a⁴po³⁴ hnei³! ");
INSERT INTO cucNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","I² jon³ ne⁵, ua²cua⁴³ Pe³² coh⁵hnei³², i² jon³ a⁴tyie³⁴ jan³ a³m⁴ peih¹, a³júan³ ta¹ jauh³², juah⁴i³: ―Hnei³pa² ma²ŋengh³ jianh²ˉ³ Jesús a³sian³ húa³⁴ Galilea liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","I² Pe³² ne⁵, a⁴jlian³⁴i³ ta⁵nei² la⁴jang³⁴, juah⁴i³: ―Sa⁴yan³²ˉ⁴ henh⁴ hleh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","I² jon³ ra⁴hang³² Pe³², ŋo³⁴i³ hloh³² o²hnei³² jeu³ si³hei⁴i³ a²jneng²³ hyah³, i² jon³ a⁴je³ i²jan³ a³m⁴, i² jon³ a⁴juah⁴ a³m⁴ hain⁴ i²con²³ a³tionh² i²jon³: ―Jeh³², a³ne³pa² ma²ŋeng²³ jian²³ Jesús a³sian³ jeu³ Nazaret. ");
INSERT INTO cucNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jon³ a⁴jlian³⁴i³ liah⁴ i⁴seg³⁴ i⁴hen⁴³i³ Jon⁴dai¹, juah⁴i³: ―Sa⁴cm⁴³ˉ⁴ hain³ chie³ henh⁵ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","I² con³ma² liah⁴ma³co⁴le⁴sa² jon³, jon³ a⁴tyie³⁴ a³ti²tionh² i²jon³ hlonh²i³, a⁴sagh⁴³i³ Pe³²: ―I⁴chie⁴³pa² hnei³ langh⁴³ jan³ chie³ quian¹i³, quie¹ lei³ naih⁵ liah⁴ hleh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jon³ ma⁴lie⁵ Pe³² i⁴hen⁴³i³ Jon⁴dai¹ i⁴jang³⁴ tsei⁴³ i⁴he³⁴i³ ma²eu⁴³ i²con²³i³ a¹juah⁴ne³ sa⁴chie⁴³ jau²³ quieh¹i³, a⁴cúa⁴i³ jau²³ quieh¹, juah⁴i³: ―Sa⁴cm⁴³ˉ⁴ hain³ chie³ henh⁵ˉ³. I² con³ma²a⁴hleh⁴i³ jon³, con³ a⁴la³ a⁴hoh⁵ a¹hyie²³. ");
INSERT INTO cucNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","I² jon³ a⁴tyon²³ tsei⁴³ Pe³² jau²³ quieh¹ Jesús i⁴ma²a⁴juah⁴i³ i²con²³i³: “Naih⁵i² hoh⁵ a¹hyie²³, jlianh³²ˉ³ i⁴juah²ˉ³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ hnang²³ nie⁴³.” I² jon³ ua⁵hag⁴³ Pe³² coh⁵ a²jneng²³ hyah³, a⁴hoh⁵i³ i⁴hei¹ queuh³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","I² con³ma²a⁴jnia³⁴, jon³ a⁴ŋangh³ la⁴jang³⁴ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³ quian¹ a³jeu³, ra⁵hyon³ tsei⁴³i³ i⁴cúanh⁴³i³ jŋangh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jon³ jian³i³ Jesús ya¹hñi⁴³, ni²cúanh³²i³ joh⁴³ cúa³ Poncio Pilato, si²mah⁴ tyein² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","I² Judas a³a⁴cúanh⁴³ Jesús hain⁴, con³ma²a⁴je³⁴i³ i⁴a⁴gmh⁴ heih⁴³ i⁴jaun⁴, jon³ a⁴júan⁴i³ co³hei²tsei³ seg²³, a⁴jainh³i³ qui⁴quia⁴ o¹cau³² tie³ jon³ i²con²³ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³, ");
INSERT INTO cucNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","juah⁴i³: ―A⁴tanh⁴ˉ⁴ chie³² quie¹ a⁴cúanh³²ˉ⁴ jan³ a³sa⁴ren³ chie³² i⁴jaun⁴. I² a⁴juah⁴ a³hain⁴ tionh² ne⁵: ―¿Henh⁴ jm² si²quian¹ jnie³² nei² ne³? ¡Quie¹ tainh⁴³ húanh⁴³pa² hnei³! ");
INSERT INTO cucNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jon³ a⁴ton³⁴ Judas la⁴jeg³⁴ o¹cau³² tie³ jon³ cuah³júah²; ua⁵hag⁴³i³, ŋah³i³, ua⁵jŋangh³i³ hña³, a⁴hñei⁴i³ lau² yeih³² hma³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","I² m³chie³ tyein² hain⁴ tionh², jon³ a⁴jaih³i³ la⁴jeg³⁴ o¹cau³² tie³ jon³, a⁴juah⁴i³: ―Sa⁴ra³cúa²³ juah⁴ i⁴tien³²ˉ¹ o¹cau³² la³ joh⁴³ a²cúa⁴³ quieh¹ cuah³, quie¹ leg⁴³ hmah¹ quieh¹ jm³yein⁴ quieh¹ jan³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","I² con³ma²a⁴júan⁴i³ re³ tionh², jon³ a⁴la³⁴i³ con³ húa³⁴ o¹cau³² jon³ i⁴sain³ Húa³⁴ quieh¹ Teg³teuh³, canh⁴a² li⁴sia³ con³ i²hon³⁴i³ a³sian³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","I⁴jon³ la⁴teg⁴ tieh²la³ teh²i³ húa³⁴ jon³, Húa³⁴ quieh¹ Jm³yein⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","La⁴ne³ ra⁵tei⁴³ jau²³ i⁴a⁴hleh⁴ Jeremías, a³sain² hain⁴, con³ma²a⁴juah⁴i³: “A⁴hyei⁴i³ qui⁴quia⁴ o¹cau³² tie³ (hmah¹ i⁴a⁴juah⁴ sa¹jeun³ Israel i⁴quein⁴³ a³hain⁴), ");
INSERT INTO cucNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","jian³ a⁴la³⁴i³ húa³⁴ quieh¹ teg³teuh³ o¹cau³² jon³, la⁴jon³ liah⁴i² a⁴júan⁴ Se³ño²³ heih⁴³ i²con²³ˉ⁵.” ");
INSERT INTO cucNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jon³ si²sainh⁴³ Jesús ta⁵nei² si²mah⁴ tyein² hain⁴ a³a⁴ŋang⁴ i²con²³i³, juah⁴i³: ―¿O⁴ hnei³ langh⁴³ Re¹ quian¹ judío tionh²? Jon³ a⁴juah⁴ Jesús: ―Liah⁴ juah⁴ ne³pa² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jian³ la⁴jang³⁴ m³chie³ tyein² jian²³ a³don⁵ ma⁴³teg²³, a⁴hnang⁴³i³ Jesús. I² Jesús ne⁵, i¹con³ jau²³ sa⁴ŋangh²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jon³ a⁴juah⁴ Pilato i²con²³i³: ―¿O⁴ sa¹ nauh³ˉ³ i⁴hlion⁴ chie³² ti²cúa²³i³ hnei³? ");
INSERT INTO cucNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","I² Jesús ne⁵, i¹con³ jau²³ sa⁴a⁴ŋangh³i³; i⁴jon³ ta² co³ ŋo³⁴ tsei⁴³ si²mah⁴ tyein² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I² jon³ ne⁵, quie¹ la⁴jeg³⁴ jm² jon³, jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, tang²³ si²mah⁴ tyein² hain⁴ lion³ jan³ a³chion³², a³hain⁴ a³hen⁴³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jm² jon³ ma²hein² jan³ a³chion³² ni⁴ñi²³ a³sain³ Barrabás, a³ñi³ a³jeu³ la⁴jang³⁴ nei² quieh¹ liah⁴ lang⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","I² con³ma²ti²tionh²i³ la⁴jang³⁴ tionh², jon³ a⁴juah⁴ Pilato i²con²³i³: ―¿Hain³ a³chion³² hnoh³ˉ³ lion³²ˉ⁴: Barrabás jian³ o⁴ Jesús, a³teh²i³ A³ya⁴lion³² Chie³ hain⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Quie¹ ñi³i³ i⁴a⁴cúanh⁴³i³ joh⁴³ cúa³i³ i⁴eu⁴³ tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","I² con³ma²ua²cua⁴³ Pilato i²can²³ jau²chie⁴³, jon³ a⁴sain⁴ a³m⁴ quian¹i³ jau²³, juah⁴i³: “Sa⁴hniah³ teih³²ˉ³ si¹cúah³ o³tan² a³tsein²³ hain⁴. Quie¹ je¹nai³ ma³hm⁴ hlion⁴ ma²eu⁴³ a⁴can³⁴ˉ⁴ nei² quieh¹i³, qui⁴tian³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","I² la⁴jang³⁴ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³, a⁴cagh¹i³ jm² i²con²³ a³jeu³ canh⁴a² m³⁴ a³jeu³ i⁴lion⁴ Barrabás, jian³ i⁴jaun⁴ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jon³ a⁴juah⁴ si²mah⁴ tyein² i²con²³i³ tionh² liah⁴ i⁴seg³⁴: ―¿Hain³ chianh² la⁴conh⁴ li⁵uan⁴ hain⁴ hnoh³ˉ³ lion³²ˉ⁴? I² jon³ a⁴juah⁴i³ tionh²: ―Barrabás pa². ");
INSERT INTO cucNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jon³ a⁴juah⁴ Pilato i²con²³i³: ―¿Henh⁴ júan³²ˉ⁴ i²con²³ Jesús, a³teh²i³ A³ya⁴lion³² Chie³ hain⁴ ne⁵? I² jon³ a⁴juah⁴ la⁴jang³⁴ a³jeu³ tionh²: ―¡Hniah³ tionh³²ˉ³ crau¹! ");
INSERT INTO cucNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Conh⁴liah⁴ a⁴juah⁴ si²mah⁴ tyein² i²con²³i³: ―¿Henh⁴ i⁴hlagh³² a⁴júan⁴i³ ne⁵? I² hei⁴i³ tionh² ne⁵, tsei³⁴sa² tia⁴ a⁴hleh⁴i³, a⁴juah⁴i³: ―¡Hniah³ tionh³²ˉ³ crau¹pa²! ");
INSERT INTO cucNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","I² con³ma²a⁴je³⁴ Pilato i⁴sa⁴cang³ jau²³ quieh¹i³, jian³ i⁴tsei³⁴sa² ra³hang³² a³jeu³, jon³ a⁴tang⁴i³ o¹jm³cuh⁵, a⁴raunh⁵i³ si¹cúa³ ta⁵nei² a³jeu³, juah⁴i³: ―A⁵sia³ chie³² ren³⁴ˉ⁴ i⁴tain³⁴ jm³yein⁴ quieh¹ a³ñih³ a³tsein²³ la³; tainh⁴³ hnei³pa² tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jon³ a⁴ŋangh³ la⁴jang³⁴ a³jeu³, a⁴juah⁴i³: ―Ua²yi⁴hei⁴ lau² jnie³² liah⁴ma³jie³ jnie³² jon⁴³segh³² jnie³² jm³yein⁴ quieh¹ a³ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","I² jon³ a⁴lion³i³ Barrabás; i² con³ma²a⁴júan⁴i³ heih⁴³ i⁴a⁴pan³⁴i³ Jesús jeu³ a²lo³, jon³ a⁴cúanh⁴³i³ i⁴si⁵tion⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","I² jon³ jie³ a²hlie⁴ quian¹ si²mah⁴ tyein², jian³i³ Jesús la⁴teg⁴ jauh³²tyie³; i²jon³ a⁴ŋangh³ la⁴jang³⁴ a²hlie⁴ la⁴co⁴la⁴lagh⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I² con³ma²a⁴tyi³i³ a²cúan³ Jesús, jon³ a⁴tanh³i³ con³ a²hmh³ sein³² cúa³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jian³ a⁴tonh³i³ con³ a²sag³ i⁴leg⁴³ a²ton⁴³ ma³tyi²i³, jian³ con³ a²ma³cu⁴³ joh⁴³ cúa³i³ jo³² ta⁵chie³⁴. I² jon³ ji⁴ŋang⁴i³, a⁴si⁴jnei⁵i³ ta⁵nei²i³, juah⁴i³: ―¡Ta⁵yeih³² Re¹ quian¹ judío tionh²! ");
INSERT INTO cucNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I² jon³ a⁴hñi³i³ jm³teuh¹. I² con³ma²a⁴qui³⁴i³ a²ma³cu⁴³ jon³, jon³ a⁴pa³⁴i³ ma³tyi²i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","I² con³ma²a⁴toh⁴ a⁴ji⁴ŋang⁴i³, jon³ a⁴tyi³i³ a²hmh³ cúa³ jon³ quieh¹, jian³ a⁴tonh³i³ a²cúan³ hña³ liah⁴ i⁴seg³⁴. Jon³ jian³i³ ua⁵tion⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","I² jon³ ne⁵, con³ma²tionh²i³ jeu³ jon³, a⁴jainh³i³ jan³ a³ñih³ a³sian³ je¹jeu³ Cirene, a³sain³ Si²úan¹, a⁴júan⁴i³ ta⁵li⁴hnai³ i⁴jian³⁴ a³hain⁴ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","I² con³ma²a⁴tyie³⁴i³ tionh² con³ i²sain³ Gólgota, hnie³⁴ ra³juah⁴ Hien²³ quieh¹ Ma³tyi² Húan³⁴, ");
INSERT INTO cucNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","i²jon³ a⁴cúa⁴i³ o¹bein² jeinh³ i²con²³ Jesús i⁴hangh³i³ i⁴ni²conh² con³ o¹jm³ i⁴eu⁴³ tseih³; i² con³ma²a⁴con³⁴ Jesús jau²chie⁴³ i⁴jon³, jon³ a⁵sie⁴³ ma⁵hnie³⁴i³ hangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I² con³ma²a⁴tion⁴i³ crau¹ tionh², jon³ a⁴tyonh⁴i³ a²cúan³ Jesús jen²i³ con⁴juah⁴ i⁴a⁴tyi³i³ jau²chie⁴³ hain³ teg³⁴ quieh¹, canh⁴a² li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ jan³ a³sain² i⁴ra³juah⁴: “A⁴tyonh⁴i³ a²cúan³⁴ˉ⁴ jen²i³ tionh², nei² quieh¹ a²hmh³ quien⁴ˉ⁴ a⁴tyi³i³ jau²chie⁴³.” ");
INSERT INTO cucNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","I²jon³ a⁴cua⁴i³ tionh², a⁴hion⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jian³ a⁴tien⁴i³ con³ jo³²hma³ ma³tyi² crau¹ i⁴ra³hleh² hain³ chie³² a⁴cúah³i³, ra³juah⁴: A³LA³PA² JESÚS, RE¹ QUIAN¹ JUDÍO TIONH². ");
INSERT INTO cucNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jon³ a⁴tion⁴i³ on³⁴ a³júan³ hang³ hlonh² Jesús, jan³ jo³² ta⁵chie³⁴ jian³ jan³ jo³² ta⁵quegh³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jian³ la⁴jang³⁴ a³ua³jeun³² jeu³ jon³, sagh⁴³i³ Jesús jau²hlagh³² i⁴jaih²i³ ma³tyi², ");
INSERT INTO cucNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","juah⁴i³: ―Hnei³ a³ma²jeunh³²ˉ³ cuah³júah² jian³ i⁴ma²júanh³²ˉ³ liah⁴ i⁴seg³⁴ tei⁴³i² ma³a⁴teg⁴ hneng³ jm², lion³² hnei³ húanh⁴³. Juah⁴ne³ langh⁴³ˉ³ A³jon⁴³ Jon⁴dai¹, jyon²³ hnei³ si²tonh³ˉ³ crau¹ ne³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Conh⁴liah⁴ la⁴jon³ a⁴ji⁴ŋang⁴ m³chie³ tyein² jian²³ a²teg²³ quian¹ lai²³ jian³ fariseo jian³ a³don⁵ ma⁴³teg²³ tionh², juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―A³sang²³pa² a⁴lion³i³, i² hña³i³ ne⁵, sa⁴cagh¹i³ jm² lion⁴³i³. Juah⁴ne³ lang⁴³i³ Re¹ quian¹ a³jeu³ Israel, ua²jyon³ chie³ con³ hña³i³ si²ton³i³ crau¹; jian³ ma²jon³ li⁴hain⁴ˉ¹ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ra⁵hain³² tsei⁴³i³ i²con²³ Jon⁴dai¹; ua²lie³ta³ quian¹i³ tieh²la³ juah⁴ne³ i⁴chie⁴³ hnie³⁴i³; quie¹ a⁴juah⁴i³: “Lang⁴³ˉ⁴ A³jon⁴³ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Conh⁴liah⁴ co⁴jon³ hleh² hang³ a³ti²ton³ jian²³i³ jau²hlagh³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Con³ma²a⁴teg⁴ yi⁵hyie³, jon³ a⁴naih³ la⁴tan² nei² cuah³²húa³⁴ la⁴teg⁴ ni¹hneng³ ta⁵hlo⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jian³ la⁴conh⁴ ni¹hneng³ ta⁵hlo⁴ jon³, a⁴hleh⁴ Jesús con³ i⁴tia⁴, juah⁴i³: ―Elí, Elí, ¿lama sabactani? ―hnie³⁴ ra³juah⁴: Jon⁴dai¹ quian³⁴ˉ⁴, Jon⁴dai¹ quian³⁴ˉ⁴, ¿henh⁴le³⁴ a⁴tienh³ˉ³ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","A⁴nau⁴ co⁴meih³ a³ti²tionh² i²jon³ jau²³ quieh¹i³, jon³ a⁴juah⁴i³: ―Teh² a³ne³ I³lie²³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Con³ a⁴la³ ra⁴hang³² jan³ jen² a³hain⁴ tionh² jeu³ra³tyi⁴ ni²quian⁴i³ con³ i⁴nah³ i⁴a⁴yeinh³ o¹bein² jeinh³, jon³ si⁴tyi⁵i³ naih¹ a²ma³cu⁴³, a⁴cúah³i³ Jesús i⁴hangh³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","I² a³sang²³ hain⁴ tionh² ne⁵, jon³ a⁴juah⁴i³: ―A⁵conh⁴³; niah²ˉ¹ o⁴ jia²³ I³lie²³ ya⁴lie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","I² Jesús ne⁵, con³ma²a⁴hleh⁴i³ tia⁴ liah⁴ i⁴seg³⁴, jon³ a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tyi¹ a⁴la³ a⁴cag³ a²hmh³ sai²³ quieh¹ cuah³júah² to⁵chieh³² teg⁴ yeih³² la⁴teg⁴ húa³⁴. Jian³ a⁴qui³⁴ húa³⁴, jian³ a⁴ŋoh⁴³ la⁴jeg³⁴ a²caun², ");
INSERT INTO cucNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","jon³ a⁴na⁴ to³ ti²hon³ a³jaun²; jian³ a⁴hyon²³ jeun⁴³ a³tsein²³ a³ma²ti²jaun². ");
INSERT INTO cucNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","I² ta⁵ma³a⁴hyon²³ Jesús, jon³ a⁴húan³ a³hain⁴ to³ i²ma²ti²hon³ jon³, a⁵han²i³ ta⁵si³da²³ hen² Jerusalén, i²jon³ ma⁴jnia³²i³ i²con²³ jeun⁴³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","I² ne³ ne⁵, sainh⁴³ jan³ jeu³² a²hlie⁴ liah⁴ma³jian²³ a²hlie⁴ quian¹i³ a³ti²hion⁴³ Jesús; i² con³ma²a⁴je³⁴i³ a⁴qui³⁴ húa³⁴ jian³ la⁴jeg³⁴ i⁴a⁴leg³⁴, jon³ yi⁴hang³² tsei⁴³i³ hlion⁴ mai²³ tionh², a⁴juah⁴i³: ―I⁴chie⁴³pa² li⁴ ma²lang⁴³ a³ne³ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jian³ tionh² jeun⁴³ a³m⁴ i²gm⁴ a³ti²je²³, a³ma²ya¹han² coh⁵cah³² Jesús liah⁴ma²ja³⁴i³ húa³⁴ Galilea, jian³ ma²cúa²³i³ cúa³tag³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","I² jen² a³m⁴ hain⁴, sainh⁴³ Ma³rei² Ma³da³len², jian³ Ma³rei² sie²³ Jacobo jian²³ Se¹, jian³ sie²³ si³jon⁴³ Zebedeo. ");
INSERT INTO cucNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","I² con³ma²a⁴nai³, jon³ a⁴tyie³⁴ jan³ a³jlanh² a³sain³ Se¹, a³sian³ jeu³ Arimatea, jian³ a⁴lang³⁴i³ chie³ quian¹ Jesús liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jon³ ñei² a³hain⁴ i²con²³ Pilato, ni²m¹i³ he³² Jesús. I² jon³ a⁴júan⁴ Pilato heih⁴³ i⁴cúanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","I² con³ma²a⁴hyeih³ Se¹ he³² jaun² quieh¹ Jesús, jon³ a⁴lion³i³ con³ a²hmh³ tie³ i⁴re³ ni²queg³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jon³ a⁴quion³i³ con³ to³hlo³ quieh¹ hña³ i²can¹ a⁴cag³⁴i³. I² con³ma²a⁴pa⁴legh³i³ con³ a²caun² ni²legh³ júah² i⁴a⁴jleg³⁴i³ ho³²to³, ma²jon³ ŋah³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jian³ i²jon³ tionh² Ma³rei² Ma³da³len² jian³ i²jan³ Ma³rei² hain⁴, a³ti²tionh² ho³²to³ jon³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","I² con³ma²a⁴jnia³⁴, hnie³⁴ ra³juah⁴, con³ma²ua⁴jeu³² i⁴a⁴júan⁴i³ co³jian¹ quieh¹ jm² sa⁴júan³i³ ta¹, jon³ ŋo³⁴ m³chie³ tyein² jian³ fariseo tionh² i²con²³ Pilato, ");
INSERT INTO cucNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","juah⁴i³: ―Hnei³ a³don⁵, tyon²³ tsei⁴³ jnie³² i⁴a⁴juah⁴ a³ñih³ a³ma³co³ hain⁴ ma²sian³i³: “Tei⁴³i² ma³a⁴teg⁴ hneng³ jm², jon³ hyon⁴³ˉ⁴”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","I⁴jon³ júan² hnei³ heih⁴³ i⁴re³ hie³⁴i³ ho³²to³ quieh¹ a³jaun² jon³ liah⁴i² a⁴teg⁴ hneng³ jm², canh⁴a² sa⁴si⁵han² chie³ quian¹i³ je¹nai³ i⁴si⁵te¹i³, jian³ li⁴sagh⁴³i³ a³jeu³ i⁴a⁴hyon²³i³ jen² a³jaun². I² la⁴ne³ hlion⁴ pi¹ li⁴ma⁵can³i³ chie³ la⁴conh⁴a² ma²ra⁴lie⁵. ");
INSERT INTO cucNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","I² jon³ a⁴juah⁴ Pilato i²con²³i³ tionh²: ―Jeh³², a²hlie⁴ tionh² ne³. Cua³, ua²yi⁴hie⁴i³ re³ liah⁴i² ñih¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jon³ ua⁵han²i³ tionh² i⁴ua⁵jleg⁴³i³ re³ ho³²to³, jian³ a⁴jieh³i³ con³ sello a²caun² jon³ jian³ a⁴sainh³i³ a²hlie⁴ hain⁴ tionh² a³hie³⁴ i²jon³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","I² con³ma²ua⁴jeu³² jm² sa⁴júan³i³ ta¹ jon³, jian³ ma³a⁴jnia³⁴ jm² ra⁴lie⁵ sa³ma², jon³ a⁴tyie³⁴ Ma³rei² Ma³da³len² jian²³ i²jan³ Ma³rei² hain⁴, ua⁵je⁴i³ i²ra³hon³ Jesús jon³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Con³ a⁴la³ a⁴qui³⁴ húa³⁴ tia⁴ hion²³. Quie¹ a⁴jyon²³ jan³ ángel quian¹ Se³ño²³ ñi⁴jeu⁵, a⁴tyie³⁴i³ jian³ a⁴qui³⁴i³ a²caun² si²jneng³ jon³, jian³ a⁴cua⁴i³ nei² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jian³ ta² joh¹ jnia⁴i³ liah⁴i² joh¹ o¹jyi³ quieh¹ a⁵ñih³, jian³ ta² tie³ a²cúan³i³ liah⁴i² tie³ o¹húan³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","I² con³ma²a⁴je³ a²hlie⁴ a³ti²hie³ hain⁴ tionh², ta² yi⁴hang³²i³ i⁴jlen²³i³, a⁴quionh³i³ húa³⁴ la⁴jan³ a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","I² jon³ a⁴juah⁴ ángel hain⁴ i²con²³ a³m⁴ hain⁴: ―A⁵júan³ hnei³ canh⁴³ tionh²ˉ³. Quie¹ yan³²ˉ⁴ i⁴hnah⁵ˉ³ Jesús, a³ta⁴ton³² crau¹ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A⁵sion⁴³ i³sian³ i²la³, quie¹ ma³a⁴hyon²³i³ la⁴jon³ liah⁴i² a⁴juah⁴i³. Nia³ ni³je¹ i²a⁴quion³i³ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jian³ ua⁴han² hnei³ ta¹tia⁴ ua⁴saih³² hnei³ chie³ quian¹i³ i⁴ma³a⁴hyon²³i³ jen² a³jaun², jian³ ñeih³² pi¹ tyanh¹i³ húa³⁴ Galilea naih⁵i² cuanh²ˉ³ tionh²ˉ³; i²jon³ jenh³²i³ hnei³ tionh²ˉ³. I⁴ne³pa² a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","I² a³m⁴ hain⁴, jon³ ua⁵han²i³ i²tionh²i³ ho³²to³ jon³ i⁴coh⁴³i³ jian³ si³hyonh³i³ hlion⁴ mai²³ liah⁴. Ua⁵han²i³ jeu³ra³tyi⁴ ua⁵júan⁴i³ jau²³ i²con²³ chie³ quian¹ Jesús. I² ta¹la⁴ tionh²i³ jeu³ ua⁵júan⁴i³ jau²³ i²con²³ chie³ quian¹i³ jon³, ");
INSERT INTO cucNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","con³ a⁴la³ ma⁴jnia³² Jesús i²con²³i³ ho³²jeu³, a⁴cúa⁴i³ dai¹ i²con²³ a³m⁴ hain⁴ tionh². Jon³ ŋo³⁴ a³m⁴ hain⁴ tionh² hlonh²i³, a⁴sanh³i³ si¹tag³², a⁴ma⁴co⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―A⁵júan³ hnei³ canh⁴³. Cua³ ua⁴júan² jau²³ i²con²³ si³reunh³ˉ⁴ canh⁴a² chianh³i³ Galilea, i²jon³ je⁴³i³ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","I² ta¹la⁴ ua⁵han² a³m⁴ hain⁴ tionh², jon³ ŋo³⁴ co⁴meih³ a²hlie⁴ a³hie³ hain⁴ ta⁵si³da²³, ua⁵júan⁴i³ jau²³ i²con²³ m³chie³ tyein² la⁴jeg³⁴ la⁴conh⁴ i⁴a⁴leg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","I² jon³ a⁴ŋangh³i³ tionh² jian²³ a³don⁵ ma⁴³teg²³. I² con³ma²a⁴júan⁴i³ re³ tionh², jon³ a⁴cúa⁴i³ hlion⁴ o¹cau³² i²con²³ a²hlie⁴ hain⁴, ");
INSERT INTO cucNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","juah⁴i³: ―Hniah³ jeuh³² hnei³ chie³ tionh²ˉ³ la⁴la³: “Ni²han² chie³ quian¹i³ je¹nai³ ni²júan⁴i³ hang³ he³² Jesús ta¹la⁴ ma²ti²cm² jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Quie¹ juah⁴ne³ ra⁵ñi³ si²mah⁴ tyein² jau²³ ne³, jon³ júan³² jnie³² re³ jie³ jnie³² hei⁴i³, canh⁴a² i¹con³ a⁵sia³ i⁴lei⁴ i²conh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","I² jon³ a⁴hyei⁴i³ o¹cau³² tionh², a⁴ma⁴tei⁵i³ liah⁴ jau²³ a⁴ro⁴³ a³hain⁴ quieh¹i³ tionh². I² jon³ ta⁴tsei¹ jau²ta³jau²³ jon³ la⁴tan² jen² judío tionh² la⁴teg⁴ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","I² la⁴ne³ jon³ ua⁵han² quia⁵con³ chie³ quian¹i³ hain⁴ tionh² húa³⁴ Galilea, la⁴teg⁴ mah⁴ i²a⁴juah⁴ Jesús chie³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","I² con³ma²a⁴jen³i³ Jesús, jon³ a⁴ma⁴con⁴³i³; i² ca³chion²³ ne⁵, sa⁴lain⁴i³ o⁴ i⁴chie⁴³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","I² jon³ ŋo³⁴ Jesús ta⁵hlonh²i³ tionh² a³a⁴hleh⁴ quieh¹i³, a⁴juah⁴i³: ―La⁴jeg³⁴ heih⁴³ ma³a⁴hyie³⁴ˉ⁴ i⁴júan³²ˉ⁴ ñi⁴jeu⁵ jian³ cuah³²húa³⁴ la³. ");
INSERT INTO cucNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","I² nei² ne³ ne⁵, cua³ ua⁴han² ua⁴júan² i⁴lain⁴ chie³ quian³⁴ˉ⁴, a³sian³ la⁴jeg³⁴ nación; jian³ sionh³²i³ hnei³ jm³ con⁴juah⁴ jm³i⁴sain³ Jon⁴dai¹ Jmai³, jian³ Jon⁴dai¹ Jon⁴³ jian³ M⁴tyi⁴ quieh¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jian³ heh³²i³ hnei³ i⁴ma⁴tei⁵i³ la⁴jeg³⁴ heih⁴³ i⁴a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³. Jian³ quian³ hnei³ hei²³ i⁴la³ i⁴jian²³ˉ⁵ hnei³ tionh²ˉ³ la⁴jeg³⁴ jm², la⁴conh⁴ jm² i⁴nie⁴³ m⁵cu³. La⁴ne³pa².");
INSERT INTO cucNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","La⁴la³ ra⁴lie⁵ jau²³ tsei²³ quieh¹ Jesucristo, A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Liah⁴i² a⁴sag⁴ Isaías a³sain² quian¹ Jon⁴dai¹ hain⁴, ra³juah⁴: Jeh³², sain¹ˉ⁴ a³sain² quian³⁴ ta⁵mah²ˉ³, a³júanh³ jeu³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Si²hleh² jan³ tia⁴ con³ i²a⁵sian⁴³ a³sian³, juah⁴i³: “Júanh¹ hnei³ jeu³ quieh¹ Se³ño²³ tionh²ˉ³; o³chie⁴³ ñeih¹ hnei³ jeu³ quieh¹i³.” ");
INSERT INTO cucNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","I² la⁴ne³ jon³ ja³⁴ Juan²³, sion⁴³i³ chie³ jm³ ta⁵i²a⁵sian⁴³ a³sian³ jon³, jian³ hleh²i³ i⁴hniah³ sag⁴ co³hei²tsei³ quieh¹ chie³, jian³ i⁴hniah³ son⁵i³ chie³ jm³ canh⁴a² hain³⁴ Jon⁴dai¹ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jon³ a⁴húan³ la⁴jang³⁴ a³tionh² húa³⁴ Judea jian³ la⁴jang³⁴ a³tionh² Jerusalén, a⁵han²i³ i²con²³i³; i² jon³ a⁴sie⁴³ Juan²³ jm³ quieh¹i³ tionh² jm³ Jordán, jian³ a⁴tion⁴i³ chie³² quieh¹ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","I² jon³ ne⁵, hein² Juan²³ a²hmh³ i⁴leg⁴³ a²lo³² camello, jian³ ya¹hñih²i³ con³ a²lo³; jian³ ma³⁴ quieh¹i³ leg⁴³ a¹nangh³ jian³ hangh²i³ o¹jm³ro⁴ quieh¹ jah⁴toh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Hleh²i³, juah⁴i³: ―Jia²³ jan³ coh⁵ ne³ a³júanh⁴³ a⁵hei⁴³ lia⁴ jnia⁴, a³hain⁴ a³sa⁴haih¹ juah⁴ i⁴li⁴júan³²ˉ⁴ i²jeunh³ cah³ˉ⁴ i⁴li⁴saih²ˉ⁵ a²lo³ tsei²³ tag³² hei⁴i³ i⁴tyi¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Quie¹ i⁴chie⁴³pa² jnia⁴ ne⁵, sion⁵ˉ⁵ hnei³ jm³ tionh²ˉ³ con⁴juah⁴ o¹jm³; i² hei⁴ pi²³i³ júan³⁴ i⁴hyeih² hnei³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jm² jon³ ja³⁴ Jesús con³ma²ua⁵hag⁴³i³ jeu³ Nazaret i²tei⁴³ húa³⁴ Galilea, i² jon³ a⁴sie⁴³ Juan²³ jm³ quieh¹i³ jm³ Jordán jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","I² con³ma²a⁴hyon²³ Jesús nei² jm³, liah⁴ma²jon³ a⁴je³⁴i³ i⁴a⁴na⁴ ñi⁴jeu⁵, jian³ a⁴je³⁴i³ i⁴jyie²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³i³ la⁴jan³ a⁵ta³cuah³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jon³ a⁴hain³² i⁴hleh² jan³ ñi⁴jeu⁵, juah⁴i³: ―Hnei³pa² A³jon³⁴ˉ⁴ a³hno⁵ˉ⁵, a³eu⁴³ teg³ tsei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jon³ a⁴te¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, a⁴te¹i³ Jesús con³ i²a⁵sian⁴³ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","I²jon³ a⁴cua⁴i³ to⁴lo⁵ jm² i²a⁵sian⁴³ a³sian³ jon³, jian³ a⁴con²³ a⁵lainh³² jau²chie⁴³ i²con²³i³, jian³ tionh² jah⁴ nau³ liah⁴. I² jon³ a⁵han² ángel a³a⁴cúa⁴ cúa³tag³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","I² con³ma²a⁴tanh³i³ Juan²³ hain⁴ ni⁴ñi²³, jon³ ŋah³ Jesús ta⁵ Galilea; i² jon³ a⁴hleh⁴i³ jau²³ tsei²³ liah⁴ han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, ");
INSERT INTO cucNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a⁴juah⁴i³: ―Ma³a⁴tyie³⁴ jm², quie¹ ma³ja²³ hloh³² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. I² la⁴jon³ sag¹ hnei³ co³hei²tsei³ quianh³ tionh²ˉ³, jian³ ua²li⁴hainh⁴ hnei³ jau²³ tsei²³ la³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","I² con³ma²si²ŋeng²³ Jesús quien¹i²jm¹ jm³ñei³ Galilea, jon³ a⁴jen³i³ Si²úan¹ jian³ Dre¹ reunh¹i³, a³ma²ti²saih⁵ a²nai²³; quie¹ lang⁴³i³ a³jo³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I² jon³ a⁴juah⁴ Jesús: ―Nia³ hnei³ coh⁵cah³ˉ⁴, canh⁴a² júan³²ˉ⁴ i⁴lainh⁴ˉ³ a³jo³ a³sanh² chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Liah⁴ma²jon³ a⁴ton³⁴i³ a²nai²³ quieh¹, ua⁵han²i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ŋo³⁴ pi¹ Jesús con³ i²meih³, i² jon³ a⁴jen³i³ Jacobo, a³jon⁴³ Zebedeo, jian³ Juan²³ reunh¹i³, a³ti²tionh² joh⁴³ a²úan⁴³, a³ti²júanh² a²nai²³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Liah⁴ma²jon³ a⁴teh³i³ a³hain⁴ tionh²; jon³ a⁴ton³⁴i³ Zebedeo jmai³i³ a³tionh² joh⁴³ a²úan⁴³ jian²³ chie³ quian¹, ua⁵han²i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","I² jon³ a⁴tyie³⁴i³ jeu³ Capernaum tionh²; jian³ la⁴jeg³⁴ jm² sa⁴júan³i³ ta¹, chie²³ Jesús cuah³ judío i²heh²i³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ta² co³ a⁴jainh⁴³ chie³ tionh² jau²³ i⁴he²³i³; quie¹ he²³i³ i⁴quian³i³ heih⁴³ pain⁴, a⁵jon⁴³ liah⁴ he²³ a²teg²³ quian¹ lai²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","I² cuah³ quieh¹i³ jon³ tionh², ma²sainh⁴³ jan³ chie³ a³quian³ m⁴tyi⁴ hlagh³² a³a⁴hleh⁴ tia⁴, ");
INSERT INTO cucNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","juah⁴i³: ―Hnei³ Jesús a³sian³ Nazaret, ¿henh⁴ hnoh³ˉ³ i²con²³ jnie³²? ¿O⁴ a⁴niah³ˉ³ i⁴ma²tyieh²ˉ³ jnie³²? Quie¹ cm⁴³ˉ⁴ hain³ hnei³, hnei³pa² A³hen² a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","I² Jesús ne⁵, a⁴jain³⁴i³ m⁴tyi⁴ hlagh³² hain⁴, a⁴juah⁴i³: ―¡Cauh¹ lauh²! ¡Jau²³ i²con²³ a³ne³! ");
INSERT INTO cucNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I² m⁴tyi⁴ hlagh³² jon³, a⁴júan⁴i³ i⁴a⁴jlen³⁴ a³ñih³ hain⁴ tia⁴ don⁵; i² con³ma²a⁴hoh⁵ m⁴tyi⁴ hlagh³² tia⁴, jon³ ua⁵hag⁴³i³ naih⁵ ni²tsei⁴³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ta² co³ ŋo³⁴ tsei⁴³ la⁴jang³⁴i³, i⁴jon³ a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―¿Henh⁴ si³lei⁴ ne³? ¿Hain³ jau²³ hm²³ hleh² a³ne³, lainh⁴ˉ³? Quie¹ quian³i³ heih⁴³ i⁴júan³i³ heih⁴³ i²con²³ la⁴teg⁴ m⁴tyi⁴ hlagh³², jian³ ma³co⁴³ quieh¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jian³ ta² ta¹tia⁴ ra⁵sia³ jau²³ nei² quieh¹ Jesús la⁴tan² húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","I² con³ma²a⁴húan³i³ cuah³ judío jon³, jon³ ŋo³⁴ Jesús jian²³ Jacobo jian³ Juan²³ jauh³² quieh¹ Si²úan¹ jian³ Dre¹. ");
INSERT INTO cucNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","I² a³don⁵ a¹sie²³ Si²úan¹ ne⁵, ra³tyein⁴i³ ra³quian³i³; liah⁴ma²jon³ a⁴sagh⁴³i³ Jesús nei² quieh¹ a³m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","I² jon³ a⁴tyie³⁴ Jesús hlonh²i³, a⁴sanh³i³ si¹cúa³ a³m⁴ hain⁴, jian³ a⁴sion⁴³i³; jian³ liah⁴ma²jon³ a⁴qui³ tyei⁴, i² jon³ a⁴cúa⁴ a³m⁴ hain⁴ cúa³tag³² i²con²³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","I² con³ma²ta⁵a⁴nai³, ma³a⁴chia³⁴ hyie³, jon³ ti²jian³ la⁴jang³⁴ a³chieh¹ tionh² jian³ a³ti²quian³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jian³ la⁴jang³⁴ a³jeu³ a⁴ŋangh³ o²hnei³². ");
INSERT INTO cucNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","I² jon³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ jeun⁴³ a³ti²lang⁴³ chie² ma⁵quein²³, jian³ a⁴húa⁴i³ hlion⁴ m⁴tyi⁴ hlagh³²; jian³ sa⁴a⁴cúa⁴ Jesús i⁴hleh³ m⁴tyi⁴ hlagh³² quie¹ ta⁵la⁴ cm²³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I² con³ma²a⁴jnia³⁴, to⁵hie³ hion²³ ni²nai³ pi¹, jon³ a⁴no³ Jesús, ŋo³⁴i³ con³ i²a⁵sian⁴³ a³sian³ ua⁵mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jon³ ni²hnieh³ Si²úan¹ jian²³ a³jian²³i³ tionh², ni²hniah³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","I² con³ma²a⁴chieh¹i³ tionh², jon³ a⁴sagh⁴³i³ Jesús: ―Hnoh³ hnei³ la⁴jang³⁴ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","I² jon³ a⁴juah⁴ Jesús: ―Ma³²ˉ¹ jeu³ la⁴con³ hloh³² ne³, canh⁴a² ni¹hleh³ˉ⁴ jau²³ tsei²³ i²con²³i³ tionh² i²jon³ liah⁴; quie¹ i⁴jon³pa² cuan⁵ˉ⁵ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","I² la⁴ne³ a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ cuah³ judío, la⁴tan² húa³⁴ Galilea, jian³ a⁴húa⁴i³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jon³ ja³⁴ jan³ a³jyih² o¹ŋeu⁴³ quieh¹, a⁴si⁴jnei⁵i³ ta⁵nei² Jesús, a⁴mh³i³, a⁴juah⁴i³: ―A¹juah⁴ne³ hyon³ hoh⁴³ˉ³, Se³ño²³, li⁴júanh²ˉ³ i⁴huan⁴ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jon³ joh³ ñei⁴ tsei⁴³ Jesús i²con²³i³, a⁴ñeih³i³ si¹cúa³, a⁴tei³⁴i³ he³² a³chieh¹, a⁴juah⁴i³: ―Hno⁵ˉ⁵; ua²huan⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","I² con³ma²a⁴juah⁴ Jesús jau²³ ne³, liah⁴ma²jon³ ua⁵conh⁴ chie² i⁴ma²jyih² o¹ŋeu⁴³ quieh¹ a³hain⁴, a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","I² jon³ a⁴saih³ Jesús quieh¹i³ liah⁴ma²jon³, ta⁵ma³a⁴júan⁴i³ heih⁴³ pain⁴ i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","i⁴juah⁴i³: ―Jeh³², a⁵jeuh⁴³ hnei³ i¹jan³ nei² ne³; quie¹ tyieh⁴ˉ³ yi⁴ma⁴jniah³²ˉ³ ta⁵nei² m³chie³ jian³ yi⁴cúah²ˉ³ i²con²³ Jon⁴dai¹ canh⁴a² so⁴heinh⁵ˉ³ i⁴jon³ i⁴a⁴júan⁴ M³se²³ heih⁴³, canh⁴a² li⁴ñi³ tionh² i⁴a⁴huan⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","I² con³ma²ŋah³i³, jon³ ma⁴lie⁵i³ a⁴hleh⁴i³ hlion⁴ nei² ne³, jian³ a⁴jan³⁴i³ jau²³. I⁴jon³ so⁵li⁴ŋeng³⁴ Jesús je¹jeu³ jon³ ta⁵nei² chie³, quie¹ a⁴ŋeng⁴i³ i²a⁵sian⁴³ a³sian³; i² jon³ tyie²³ chie³ i²con²³i³ a³sian³ la⁴tan². ");
INSERT INTO cucNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","I² con³ma²ua⁴jeu³² co⁴meih³ jm², jon³ a⁴tyie³⁴ Jesús jeu³ Capernaum liah⁴ i⁴seg³⁴; i² jon³ ra⁵sia³ jau²³ i⁴ua²cua⁴³i³ con³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Liah⁴ma²jon³ a⁴ŋangh³ jeun⁴³ chie³, i¹ so⁵hainh²o³ chie³ la⁴teg⁴ o²hnei³² si²canh³; i² jon³ a⁴hleh⁴ Jesús jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jon³ a⁴tyie³⁴ quin⁴ a³ñih³ a³jian³ jan³ a³lo³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","I² sa⁴tian⁴ tyie¹i³ hlonh² Jesús, quie¹ eu⁴³ jeun⁴³ chie³; jon³ a⁴qui³⁴i³ co⁴meih³ a²cuah³² jleg¹ cah³² a²hnei⁴³ i²ua²cua⁴³ Jesús, jian³ a⁴jyon³i³ a³chieh¹ hain⁴ jeu³ to³ jon³, jeu³ a²hyei²³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","I² con³ma²a⁴je³⁴ Jesús conh⁴ tei⁴³ i⁴hain⁴i³ tionh², jon³ a⁴sagh⁴³i³ a³lo³ hain⁴: ―Hnei³ jon²³ quian³⁴ˉ⁴, ma³a⁴hain³⁴ chie³² quianh³ˉ³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jian³ ma²tionh² co⁴meih³ a²teg²³ quian¹ lai²³ a³ti²júan³ co³hei²tsei³, lain⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿E⁴le³⁴ la⁴ne³ hleh² a³ne³? Quie¹ hleh²i³ jau²³ i⁴hieh¹ Jon⁴dai¹, quie¹ ¿hain³ ma⁵li⁴hain³⁴ chie³² quieh¹ chie³? Jan³ Jon⁴dai¹pa².” ");
INSERT INTO cucNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","I² Jesús ne⁵, ñi³i³ la⁴jeg³⁴ co³hei²tsei³ i⁴ti²júan³ a³hain⁴ tionh² naih⁵ m⁴tyi⁴ quieh¹, jon³ a⁴juah⁴i³: ―¿E⁴le³⁴ co³hei²tsei³ la⁴ne³ ti²júanh³ˉ³ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Júan³²ˉ¹, ¿henh⁴ i⁴tyein² sa⁴jeuh⁴³ li⁴hleh¹ˉ⁴ li⁴tei⁴³ la⁴conh⁴a² li⁵teun⁴ la³, lainh⁴ˉ³? ¿O⁴ li⁴juah¹ˉ⁴: “Ma³a⁴hain⁵ˉ⁵ chie³² quianh³ˉ³”, jian³ o⁴: “No³ hnei³, quian³ a²hyei²³ quianh³, ŋeng²”? ");
INSERT INTO cucNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","I² jon³ ne⁵, canh⁴a² li⁴ñih¹ˉ³ i⁴quian³ A³a⁴lang³⁴ Chie³ hain⁴ heih⁴³ i⁴hain³⁴i³ chie³² quieh¹ chie³ cuah³²húa³⁴ la³, ua²ma²jnia³²ˉ⁴ i⁴la³. Jon³ a⁴sagh⁴³i³ a³lo³ hain⁴: ");
INSERT INTO cucNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Jeu³⁴ˉ⁴ hnei³ tieh²la³, no³ hnei³, quien²³ a²hyei²³ quianh³, cuanh³ quianh³ jauh³² quianh³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jon³ a⁴no³ a³hain⁴ liah⁴ma²jon³, quien²³i³ a²hyei²³ quieh¹, ua⁵hag⁴³i³ ta⁵nei² la⁴jang³⁴. Jian³ ta² co³ a⁴jainh⁴³ a³hain⁴ tionh², i² jon³ a⁴júan⁴i³ i⁴júanh⁴³ Jon⁴dai¹, a⁴juah⁴i³: ―I¹conh⁴ a⁵sia³ ma³a⁴niah³²ˉ¹ juah⁴ i⁴ma³a⁴leg³⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Coh⁵ jon³ ŋo³⁴ Jesús liah⁴ i⁴seg³⁴ la⁴teg⁴ quien¹i²jm¹ jm³ñei³; jian³ la⁴jang³⁴ chie³ ua⁵han² i²con²³i³, i² jon³ a⁴heh³i³ chie³ hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","I² con³ma²si²ŋeng²³i³ i²jon³, jon³ a⁴jen³i³ Leví, a³jon⁴³ Alfeo, a³ua²cua⁴³ jauh³² i²can²³i³ hmah¹, jon³ a⁴sagh⁴³i³: ―Nia³ hnei³ coh⁵cah³ˉ⁴. Jon³ a⁴no³ a³hain⁴, ŋo³⁴i³ coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","I² con³ma²ua²queuh³ Jesús a²hei⁴³ jauh³² quieh¹ Leví, ta² jeun⁴³ a³can²³ hmah¹ jian²³ a³ti²ren³ chie³² liah⁴ tionh² a²me²sa³ jian²³ Jesús jian³ chie³ quian¹i³ liah⁴; quie¹ jeun⁴³ ma³ya¹han² coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","I² a²teg²³ quian¹ lai²³ ne⁵, jian²³ fariseo, con³ ma²a⁴je³⁴i³ i⁴queuh³ Jesús jian²³ a³can²³ hmah¹ jian³ a³ti²ren³ chie³² tionh², i² jon³ a⁴sagh⁴³i³ chie³ quian¹ Jesús, juah⁴i³: ―¿E⁴le³⁴ queuh³ hangh² A²teg²³ quianh³ˉ³ jian²³ a³can²³ hmah¹ jian³ a³ti²ren³ chie³² tionh²? ");
INSERT INTO cucNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","I² con³ma²a⁴nau⁴ Jesús jau²³ ne³, jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―La⁴jang³⁴ a³hei⁴³ tsei⁴³ a⁵sian⁴³ teg³m⁴³ hniah³ quian¹i³, a³chieh¹pa² hniah³ quian¹. Jian³ la⁴ne³pa² cuan⁵ˉ⁵ ni³teh⁵ˉ⁵ a³ren³ chie³²pa²; a⁵sia³ cuan⁵ˉ⁵ juah⁴ i⁴ni³teh⁵ˉ⁵ a³ni²taih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Con³ jm² con³ma²ti²júan³ he² chie³ quian¹ Juan²³ jian²³ chie³ quian¹ fariseo tionh² i⁴sa⁴queuh³i³, jon³ a⁴tyie³⁴ co⁴meih³ chie³ i²con²³ Jesús, jian³ a⁴ŋang⁴i³, juah⁴i³: ―¿E⁴le³⁴ júan³ he² chie³ quian¹ Juan²³ jian³ chie³ quian¹ fariseo tionh² i⁴sa⁴queuh³i³ a²hei⁴³? I² chie³ quianh³ˉ³ ne⁵, sa⁴júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","I² jon³ a⁴juah⁴ Jesús: ―¿O⁴ li⁴júan³⁴ a³ten² quian¹ a³sanh⁴ he² i⁴sa⁴queuh³i³ ta¹la⁴ cua⁴³ a³ñih³ a³sanh⁴ jian²³i³, lainh⁴ˉ³? Quie¹ ta¹la⁴ cua⁴³ a³sanh⁴ jian²³i³, sa⁴li⁴júan³⁴i³ he² i⁴sa⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Quie¹ jia²³ jm² la⁴teg⁴i² te⁴³i³ a³sanh⁴; i² ma²jon³ a²ma⁴ júan³⁴i³ he² tionh² i⁴sa⁴queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Quie¹ i¹jan³ sa⁴tien²³ a²hmh³ don⁵ ca³leuh² a²hmh³ hm²³; quie¹ leuh² hmh³ hm²³ jon³ chieh², jon³ li⁴jeun⁴ a²hmh³ don⁵, jian³ tsei³⁴sa² júah³ i²tseih³² lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jian³ la⁴jon³ liah⁴, i¹jan³ sa⁴ro³ o¹bein² hm³⁴ joh⁴³ a²lo³ don⁵; quie¹ juah⁴ne³ la⁴ne³, jon³ li⁴naih⁵ a²lo³, jon³ tain³⁴ o¹bein² jian³ si⁵hain⁴ a²lo³. I⁴jon³ hniah³ ro³⁴i³ o¹bein² hm³⁴ joh⁴³ a²lo³ hm³⁴ ton³²nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Con³ jm² sa⁴júan³i³ ta¹, hein² Jesús jeu³ je¹ i²ti²jnia²; jian³ ua⁴han² chie³ quian¹i³ ti²queun²³i³ o¹m⁴ trigo. ");
INSERT INTO cucNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jon³ a⁴juah⁴ fariseo tionh² i²con²³ Jesús: ―Jeh³², ¿e⁴le³⁴ ti²júan³ chie³ quianh³ˉ³ i⁴sa⁴haih¹ li⁴júan³⁴i³ jm² ne³⁴, jm² sa⁴júan³i³ ta¹? ");
INSERT INTO cucNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","I² a⁴juah⁴ Jesús i²con²³i³: ―¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ liah⁴ a⁴júan⁴ re¹ Da³vei²³ con³ma²so⁵sia³ i⁴li⁴queuh⁴³i³ jian³ ra⁵cúanh⁴³i³ jian²³i³ a³ma²jian²³i³? ");
INSERT INTO cucNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Quie¹ a⁴hei³⁴i³ jauh³² quieh¹ Jon⁴dai¹ con³ma²lang⁴³ Abiatar jeu³² m³chie³, jian³ a⁴queuh³i³ a²hei⁴³ñih¹ hen² i⁴sa⁴ra³cúa²³ i⁴queuh⁴³ chie³ta²chie³, quie¹ jmah³ m³chie³pa² tain⁴³ queuh³; jian³ a⁴guenh⁴ Da³vei²³ la⁴jang³⁴ a³ma²jian²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Conh⁴liah⁴ a⁴juah⁴i³ i²con²³ a³hain⁴ tionh²: ―A⁴júan⁴ Jon⁴dai¹ jm² sa⁴júan³i³ ta¹ nei² quieh¹ chie³, a⁵sia³ a⁴júan⁴³i³ chie³ nei² quieh¹ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","I² jon³ ne⁵, A³a⁴lang³⁴ Chie³ hain⁴ lang⁴³ a³júan³ heih⁴³ liah⁴ ra³cúa²³ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jon³ a⁴tyie³⁴ Jesús cuah³ judío liah⁴ i⁴seg³⁴; i²jon³ ua²cua⁴³ jan³ a³ñih³ a³lo³ ca³jo³² si¹cúa³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jian³ ti²tan³ chie³ tionh², hnie³⁴i³ je³⁴i³ o⁴ júan³⁴ Jesús i⁴huan⁴ quieh¹ a³hain⁴, jm² sa⁴júan³i³ ta¹, canh⁴a² li⁴hnang⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ a³lo³ ca³jo³² si¹cúa³ hain⁴: ―Ra⁴hang³² hnei³, no³ hnei³ to⁵chieh³² la³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jon³ a⁴juah⁴ Jesús i²con²³ a³hain⁴ tionh²: ―¿O⁴ ra³cúa²³ i⁴júan³⁴i³ i⁴tsei³⁴ jm² sa⁴júan³i³ ta¹ jian³ o⁴ i⁴hlagh³², lainh⁴ˉ³? ¿O⁴ ra³cúa²³ i⁴tainh⁴³i³ jan³ chie³ jian³ o⁴ i⁴jŋangh³i³ chie³? I² hei⁴i³ tionh² ne⁵, i¹con³ so⁵hain²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jon³ a⁴je³⁴ Jesús m³tsainh² jian³ chionh⁴ tsei⁴³i³, quie¹ eu⁴³ huah³ m⁴tyi⁴ quieh¹i³ tionh², a⁴jen³i³ a³hain⁴ tionh² co⁴la⁴lagh⁵, jon³ a⁴sagh⁴³i³ a³ñih³ hain⁴: ―Sieh¹ si¹cúah³. I² con³ma²a⁴ñeih³i³ si¹cúa³, jon³ a⁴huan⁴ quieh¹i³, a⁴lag³⁴ si¹cúa³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","I² fariseo tionh², con³ma²a⁴húan³i³, jon³ a⁴júan⁴i³ re³ jian²³ chie³ quian¹ Herodes liah⁴ li⁴jŋangh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jon³ ua⁵han² Jesús jian²³ chie³ quian¹ quien¹i²jm¹ jm³ñei³, jian³ jeun⁴³ lio⁴mai²³ chie³ a³tionh² húa³⁴ Galilea ua⁵han² coh⁵cah³²i³ liah⁴, jian³ jeun⁴³ lio⁴mai²³ a³sian³ Judea, ");
INSERT INTO cucNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","jian³ a³sian³ Jerusalén jian³ a³sian³ Idumea jian³ a³tionh² ta⁵hŋoh³ jm³ Jordán jian³ a³tionh² la⁴con³ hloh³² jeu³ Tiro jian³ Sidón liah⁴, con³ma²a⁴nau⁴i³ tionh² la⁴conh⁴ tei⁴³ ua³júah² pain⁴ i⁴júan³ Jesús, jon³ ua⁵han² la⁴jang³⁴ a³jeun⁴³ hain⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","I² jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ chie³ quian¹i³ i⁴júan³⁴i³ co³jian¹ con³ a²úan⁴³ i⁴si⁵hei⁴i³, nei² quieh¹ eu⁴³ jeun⁴³ chie³, canh⁴a² sa⁴ua⁵tsai³² chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Quie¹ jeun⁴³ chie³ ma³a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹, i⁴jon³ ti²hlie⁴³ la⁴jang³⁴ a³chieh¹ quieh¹i³, i⁴hnie³⁴i³ tei³⁴i³ si¹cúa³ he³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jian³ la⁴jeg³⁴ m⁴tyi⁴ hlagh³², tei⁴³i² a⁴jen³i³ Jesús, jon³ si³jnei⁵i³ ta⁵nei² Jesús, hleh²i³ tia⁴, juah⁴i³: ―Hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","I² Jesús ne⁵, a⁴júan⁴i³ heih⁴³ pain⁴ i²con²³ m⁴tyi⁴ hlagh³² i⁴sa⁴hleh³i³ hain³ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Con³ma²a⁴leg³⁴ ne³, jon³ ŋo³⁴ Jesús con³ nei² mah⁴, i² jon³ a⁴teh³ Jesús la⁴conh⁴ a³hnie³⁴i³ teh³i³, i² jon³ a⁵han² a³hain⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I² jon³ a⁴quianh⁴³i³ a³quia⁵teun⁴ a³hnio³⁴i³ ŋeng³⁴i³ jian²³i³ jian³ a³sain³⁴i³ a³si⁵hleh³ jau²³ quieh¹ Jon⁴dai¹ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jian³ a⁴cúa⁴i³ heih⁴³ i²con²³i³ tionh² i⁴júan³⁴i³ i⁴huan⁴ quieh¹ a³chieh¹ jian³ i⁴húa³⁴i³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jian³ a⁴quianh⁴³i³ Si²úan¹ a³ma⁴sain³i³ Pe³², ");
INSERT INTO cucNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","jian³ Jacobo a³jon⁴³ Zebedeo, jian³ Juan²³ reunh¹ Jacobo hain⁴, a³ma⁴sain³ Jesús Boanerges, i⁴hnie³⁴ ra³juah⁴, Jon⁴³segh³² A⁵ñih³; ");
INSERT INTO cucNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","jian³ Dre¹, jian³ Lei³², jian³ Bartolomé, Ma³te³², To³ma²³, Jacobo a³jon⁴³ Alfeo; Tadeo, Si²úan¹ a³ma²hein² jo³² cananista, ");
INSERT INTO cucNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jian³ Judas Iscariote, a³hain⁴ a³a⁴cúanh³ Jesús. Jon³ ua⁵han²i³ con³ jauh³² tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","I² jon³ a⁴ŋangh³ jeun⁴³ chie³ liah⁴ i⁴seg³⁴, i¹ so⁵tag³ júah³ queuh⁴³i³ a²hei⁴³ jian²³i³ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","I² con³ma²ra⁵ñi³ si³reunh¹ Jesús jau²³ jon³, jon³ ua⁵han²i³ ma²ua⁵te¹i³, quie¹ juah⁴i³ ma³ŋo⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","I² a²teg²³ quian¹ lai²³ a³a⁵han² Jerusalén a⁴juah⁴ jian³ Jesús Beelzebú, jeu³² m⁴tyi⁴ hlagh³², jian³ con⁴juah⁴ ua³pei⁴ quieh¹ a³hain⁴ húa³i³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","I² con³ma²a⁴teh³ Jesús a³hain⁴ tionh², jon³ a⁴hlenh⁴³i³ con⁴juah⁴ jau²³ i⁴a⁴can³⁴i³, juah⁴i³: ―¿O⁴ li⁴tyein⁵ a⁵lainh³² a³jian²³ tionh², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Juah⁴ne³ tionh² chie³ ma⁵quein²³ jo³² con³ nación, sa⁴li⁴úan⁴ nación jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jian³ juah⁴ne³ si³tang⁴ a³tionh² con³ jauh³², sa⁴li⁴úan⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jian³ la⁴ne³ juah⁴ne³ tyein³ a⁵lainh³² a³jian²³ tionh², la⁴can³ húan⁴ pi²³i³ si³tang⁴ tionh², jian³ sa⁴li⁴úan⁴i³, quie¹ tya⁴³ ua³pei⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Júan³²ˉ¹ ne⁵, i¹jan³ sa⁴li⁴hei⁴ jauh³² quieh¹ jan³ a³huanh⁴³ i⁴con⁴³i³ la⁴jeg³⁴ i⁴quieh¹, juah⁴ne³ sa⁴hñi³⁴i³ ñeih³²jia⁴³; jon³ a²ma⁴ li⁴húa³⁴i³ la⁴conh⁴ i⁴tieh³² jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ i⁴li⁴jlenh⁴³pa² la⁴jeg³⁴ chie³² quieh¹ chie³, jian³ la⁴jeg³⁴ jau²hlagh³² i⁴hleh²i³ i²con²³ Jon⁴dai¹; ");
INSERT INTO cucNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","i² a³hain⁴ a³hleh³ jau²hlagh³² nei² quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, sa⁴legh⁴ ua²a⁴jlenh³ chie³² jon³ quieh¹i³, quie¹ ren³i³ chie³² i⁴hyieh⁴i³ ma²eu⁴³ sa⁴ton³ jm² ua²a⁴chia³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Quie¹ ma³a⁴juah⁴ a³hain⁴ tionh² i⁴quian³ Jesús m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Con³ma²a⁴leg³⁴ ne³, jon³ a⁴tyie³⁴ sie²³i³ jian³ si³reunh¹i³, tionh²i³ coh⁵hnei³²; i² jon³ a⁴sain⁴i³ jau²³ i⁴teh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","I² jon³ a⁴júan⁴ chie³ jau²³ a³ti²tionh² hlonh²i³, a⁴juah⁴i³: ―Jeh³², sieh³ˉ³ jian²³ si³reunh³ˉ³ ti²tionh² coh⁵hnei³² la³, hnoh³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I² jon³ a⁴jainh³i³ jau²³ i²con²³ a³hain⁴ tionh², juah⁴i³: ―¿Hain³ lang⁴³ sia³⁴ˉ⁴ jian³ si³reunh³ˉ⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","I² con³ma²a⁴jen³i³ a³tionh² co⁴la⁴lagh⁵ hlonh²i³, a⁴juah⁴i³: ―A³ne³pa² sia³⁴ˉ⁴ jian³ si³reunh³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Quie¹ la⁴jang³⁴ a³ma³tei⁵ heih⁴³ quieh¹ Jon⁴dai¹, a³hain⁴pa² a³ñih³ reunh³ˉ⁴, a³m⁴ reunh³ˉ⁴, jian³ sia³⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Conh⁴liah⁴ i⁴seg³⁴ a⁴ma⁴lie⁵ Jesús a⁴heh³i³ chie³ quien¹i²jm¹ jm³ñei³, i² jon³ a⁴ŋangh³ jeun⁴³ chie³ co⁴la⁴langh⁵i³; jon³ a⁴hei³⁴ Jesús con³ joh⁴³ a²úan⁴³ i⁴ra³quia³ quien¹i²jm¹, i² jon³ a⁴cua⁴i³; i² la⁴jang³⁴ chie³ hain⁴, tionh² i²chie³² jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jon³ a⁴heh³i³ a³hain⁴ tionh² con⁴juah⁴ hlion⁴ jau²³ i⁴a⁴can³⁴i³, a⁴juah⁴i³ la⁴la³ con³ma²ua²he²³i³: ");
INSERT INTO cucNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Nai³ hnei³ jau²³ la³ tionh²ˉ³: Jan³ chie³ ŋo³⁴ ua⁵jñi³ o¹m⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","I² con³ma²si²jnei³i³, jon³ a⁴jyih³ co⁴meih³ o¹m⁴ hloh³² ho³²jeu³; i² jon³ a⁵han² jon⁴³tan²³, a⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Conh⁴liah⁴ a⁴jyih³ co⁴meih³ je¹ na²caun² i²sa⁴ra³tsei²³ hlion⁴ o¹cuah³², i² jon³ a⁴hya³ o¹m⁴ jon³ ta¹tia⁴, quie¹ ta⁵la⁴ sa⁴hmh² o¹cuah³². ");
INSERT INTO cucNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","I² con³ma²ja³⁴ hyie³ ne⁵, jon³ a⁴co⁴, ra⁵quein³ o³tan² quie¹ sa⁴re³ ya¹quian³ o¹júan⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Conh⁴liah⁴ a⁴jyih³ co⁴meih³ je¹ a²ton⁴³; i² jon³ ra⁵jang¹ a²ton⁴³ jon³, a⁴tseinh³i³ o¹jeun³ jon³, a⁵sia³ o¹m⁴ a⁴cúa⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jian³ a⁴jyih³ co⁴meih³ húa³⁴ tsei³⁴. I² i⁴jon³ ta² re³ a⁴cúa⁴ o¹m⁴, quie¹ a⁴hya³ jian³ ra⁵jang¹; ca³chie³² a⁴cúa⁴ qui⁴quia⁴ m⁴, jian³ ca³chie³² a⁴cúa⁴ to⁴lo⁵quia⁴ ni²tsei¹ quia³⁴, jian³ ca³chie³² a⁴cúa⁴ nia⁴lo⁴ liah⁴; la⁴ne³ a⁴cúa⁴ la⁴conh⁴ con³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jon³ a⁴juah⁴ Jesús: ―A³hain⁴ a³ho³ ta³ra³cua¹ i⁴nau³⁴i³, ua²nai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","I² con³ma²a⁴quionh³ Jesús húan⁴ jian²³ a³tionh² hlonh²i³ jian²³ quia⁵teun⁴ chie³ quian¹i³ i²jon³, a⁴ŋang⁴i³ i²con²³ Jesús henh⁴ hnie³⁴ ra³juah⁴ jau²³ i⁴a⁴can³⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Quie¹ i²conh² hnei³pa² tionh²ˉ³ júan³ Jon⁴dai¹ i⁴li⁴ñih¹ˉ³ jau²³ ni²hma² liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹; i² a³sa⁴lang⁴³ chie³ quian³⁴ˉ⁴ ne⁵, con⁴juah⁴ jmah³ jau²³ i⁴can³⁴ˉ⁴ la⁴ne³pa² hleh³ˉ⁴ i²con²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Quie¹ ua²liah⁴a² je²³i³, je²³i³ la⁴con³ sa⁴ho³ m⁴nei²i³, jian³ ua²liah⁴a² nau³i³, sa⁴li⁴ŋang⁴i³, canh⁴a² sa⁴li⁴sag⁴ co³hei²tsei³ quieh¹i³, jian³ a⁵ga⁴ jlenh⁴³ chie³² quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Conh⁴liah⁴ a⁴juah⁴ Jesús: ―¿O⁴ sa⁴ŋangh⁴ˉ³ tionh²ˉ³ jau²³ i⁴a⁴can³⁴ˉ⁴ ne³? ¿Liah⁴ cúan²³ li⁴ŋangh⁴ˉ³ la⁴jeg³⁴ jau²³ i⁴can¹ˉ⁴ la⁴ne³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jau²³ ne³ hnie³⁴ ra³juah⁴: A³jnei³ o¹m⁴ hain⁴ lang⁴³ a³hleh² jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jian³ la⁴la³ lang⁴³ chie³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ hloh³² ho³²jeu³: nau³i³ jau²³ quieh¹ Jon⁴dai¹, i² con³ma²a⁴nau⁴i³ tionh², jon³ jia²³ a⁵lainh³² liah⁴ma²jon³ si³qui⁴³i³ jau²³ i⁴jnia² naih⁵ ni²tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jian³ i²ca³chion²³ lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ je¹ na²caun²: nau³i³ jau²³ quieh¹ Jon⁴dai¹, jian³ liah⁴ma²jon³ hyei³i³ si³hyonh³i³, ");
INSERT INTO cucNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","jian³ sa⁴re³ ya¹quian³i³ o¹júan⁴³, quie¹ sa⁴tieh¹i³ úa⁴; quie¹ tei⁴³i² jia²³ ma²eu⁴³ jian³ o⁴ i⁴hag²³ chie³ nei² quieh¹ jau²³ i⁴quian³i³, liah⁴ma²jon³ cangh²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jian³ co⁴meih³ lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ je¹ a²ton⁴³: nau³i³ jau²³ quieh¹ Jon⁴dai¹, ");
INSERT INTO cucNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","i² hlion⁴ co³hei²tsei³ júan³i³ nei² quieh¹ i⁴sia³ m⁵cu³ la³, jian³ i⁴ma³can³i³ tsei⁴³ hña³ con⁴juah⁴ o¹cau³², jian³ i⁴hnie³⁴i³ hlion⁴ i⁴seg³⁴. La⁴jeg³⁴ co³hei²tsei³ ne³ júan³ i⁴ai²³ jau²³ jon³, jian³ sa⁴tyie²³ i²ma³jnia³i³ i⁴tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jian³ i²ca³chion²³ lang⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴a⁴jyih³ nei² húa³⁴ tsei³⁴: nau³i³ jau²³ quieh¹ Jon⁴dai¹ jian³ hyei³i³, jian³ cúa²³i³ o¹m⁴. Ca³chion²³ cúa²³ qui⁴quia⁴, jian³ ca³chion²³ cúa²³ to⁴lo⁵quia⁴ ni²tsei¹ quia³⁴, jian³ ca³chion²³ cúa²³ nia⁴lo⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jon³ a⁴sagh⁴³i³ chie³ quian¹ liah⁴: ―¿O⁴ li⁴can³⁴i³ con³ o¹jyi³ i⁴li⁴seih³i³ naih⁵ hma³ ca³jeun²³, lainh⁴ˉ³, jian³ o⁴ naih⁵ a²jain³²? ¿O⁴ a⁵sia³ can³⁴i³ juah⁴ i⁴seih³i³ yeih³², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Quie¹ i¹con³ i⁴ni²hma² sa⁴sia³ juah⁴ i⁴sa⁴li⁴ñi³ chie³; jian³ i¹con³ i⁴ni²jleg³ sa⁴sia³ juah⁴ i⁴sa⁴jñeih³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","A³hain⁴ a³ho³ ta³ra³cua¹ i⁴nau³⁴i³, ua²nai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jian³ a⁴juah⁴i³ liah⁴: ―I² ne³ ne⁵, jianh³ˉ³ nai³ hnei³ jau²³ quien⁴ˉ⁴ tionh²ˉ³. Quie¹ la⁴conh⁴i² roh³ˉ³ jeu³ jau²³ quieh¹ Jon⁴dai¹, la⁴ne³pa² cúa³⁴i³ hnei³ tionh²ˉ³; jian³ cúa³⁴ pi¹i³ hnei³ a³ti²nauh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quie¹ a³hain⁴ a³ma³ñi³, hyieh⁴ pi¹i³ i⁴li⁴ŋang⁴i³; jian³ a³hain⁴ a³sa⁴ñi³, jon³ qui³⁴ la⁴teg⁴ ca³leuh² peih¹ i⁴ŋang⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jon³ a⁴juah⁴ Jesús liah⁴: ―I⁴tionh²i³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹ leg⁴³ liah⁴i² leg⁴³ o¹m⁴ i⁴jnei³ jan³ chie³ naih⁵ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jian³ cm²³ a³hain⁴ la⁴jeg³⁴ húa²³ jian³ no²³i³ la⁴jeg³⁴ hie³, jian³ hya²³ o¹m⁴ jian³ si³cúan³ i⁴sa⁴ñi³i³ liah⁴ lei⁴ hña³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Quie¹ hña³pa² húa³⁴ ra³júan³ ta¹; co⁴ra⁴lie⁵ ñeih³² si³cúan³ ma³tag³², jon³ a²ma⁴ hya²³ o¹yein¹, i² naih⁵ o¹yein¹ jon³, jon³ a²ma⁴ si³ha¹ o¹m⁴ i⁴canh³ naih⁵ o¹yein¹. ");
INSERT INTO cucNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","I² tei⁴³i² ma³don³ ne⁵, jon³ a²ma⁴ si⁵queih⁴i³, quie¹ ma³a⁴tyie³⁴ jm² a⁴lo³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jon³ a⁴juah⁴i³ liah⁴: ―¿Hain³ liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, lainh⁴ˉ³, jian³ o⁴ hain³ jau²³ li⁴le²ˉ¹ liah⁴ leg⁴³? ");
INSERT INTO cucNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Quie¹ leg⁴³ heih⁴³ jon³ liah⁴i² leg⁴³ con³ o¹m⁴ mostaza. Quie¹ tei⁴³i² jnei³i³ o¹m⁴ jon³, leg⁴³ con³ i⁴tyein² peih¹ la⁴conh⁴a² la⁴jeg³⁴ o¹m⁴ i⁴sia³ nei² cuah³²húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","I² tei⁴³i² ma³a⁴jnia² ne⁵, jon³ si³cúan³ jian³ li⁴júah³ la⁴conh⁴a² la⁴jeg³⁴ o¹sieh³² i⁴queuh³i³, jian³ cah² o¹cúah² quieh¹ lei⁴, i²jon³ júan³ jon⁴³tan²³ sag³² je¹ o¹cúah² quieh¹ o¹sieh³² jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Hlion⁴ jau²³ a⁴can³⁴ Jesús la⁴ne³ i⁴a⁴hlenh⁴³i³ chie³ la⁴conh⁴ tieh¹i³ nau³⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I¹con³ jau²³ sa⁴a⁴hlenh⁴³i³ chie³ juah⁴ne³ sa⁴a⁴hlenh⁴³i³ con⁴juah⁴ jau²³ i⁴a⁴can³⁴i³; i² i²con²³ chie³ quian¹i³ ne⁵, a⁴tya⁴i³ ra³jia⁵ la⁴jeg³⁴ con³ma²tionh²i³ húan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jm² jon³ con³ma²a⁴nai³, jon³ a⁴juah⁴ Jesús i²con²³ chie³ quian¹: ―Ma³²ˉ¹ ta⁵hŋoh³ jm³ñei³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","I² con³ma²a⁴sainh³i³ chie³ jeun⁴³ hain⁴, jon³ a⁴te¹ chie³ quian¹i³ quieh¹i³ liah⁴ma³hein²i³ joh⁴³ a²úan⁴³ jon³, jian³ ua⁵ha¹ meih³ a²úan⁴³ seg³⁴ jian²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","I² jon³ ra⁴hag³² con³ tyi⁴ tia⁴ i⁴quian³ jm³ si²ha¹ joh⁴³ a²úan⁴³ la⁴con³ i⁴ma²si³canh³ o³tan². ");
INSERT INTO cucNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","I² Jesús ne⁵, ra³cm² pi²³i³ la⁴teg⁴ ya¹caun⁴³ a²úan⁴³ ra³tsain⁵ con³ a²teun⁴³ ma³tyi²i³; i² jon³ a⁴sion⁴³i³ Jesús tionh², a⁴juah⁴i³: ―Hnei³ A²teg²³, ¿o⁴ a⁵sia³ jeu³ roh³ˉ³? Jeh³², ma³o¹tyan⁴³ˉ¹ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I² jon³ ra⁴hang³²i³, a⁴júan⁴i³ heih⁴³ i²con²³ tyi⁴ i⁴jian³⁴; jian³ a⁴sagh⁴³i³ jm³ñei³: ―¡Tai³² san⁴! ¡A⁵júan³ ti³jan²³! Jon³ a⁴jian⁴ tyi⁴, jian³ a⁴nie³⁴ huan³² jm³. ");
INSERT INTO cucNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","I² jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―¿E⁴le³⁴ canh⁴³ˉ³ tionh²ˉ³? ¿E⁴le³⁴ sa⁴hainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","I² jon³ yi⁴hang³²i³ hlion⁴ mai²³ tionh², a⁴júanh⁴i³ húan⁴i³, a⁴juah⁴i³: ―¿Hain³ chie³ ne³, lainh⁴ˉ³? Quie¹ la⁴teg⁴ tyi⁴ jian³ jm³ñei³ ma³co⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jon³ a⁴tyie³⁴i³ ta⁵hŋoh³ jm³ñei³, húa³⁴ Gadara. ");
INSERT INTO cucNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","I² con³ma²ua⁵hag⁴³ Jesús joh⁴³ a²úan⁴³, liah⁴ma²jon³ a⁴tyie³⁴ jan³ a³ñih³ i²con²³i³ a³ua⁵hag⁴³ to³ quieh¹ a³jaun², a³quian³ con³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Quie¹ cua⁴³ a³hain⁴ to³ quieh¹ a³jaun², jian³ i¹jan³ sa⁴tieh¹ hñi³⁴ a³hain⁴, i¹ jeu³ a²ca³den² sa⁴tian⁴ hñi³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Quie¹ hlion⁴ nie⁴³ ma³a⁴hñei⁴i³ si¹cúa³i³ jian³ si¹tag³²i³ jeu³ a²ca³den²; i² a²ca³den² ne⁵, jeun²³i³ o¹leuh², i¹jan³ sa⁴a⁴cagh¹ jm² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jian³ ŋeng²³ a³hain⁴ la⁴húa²³ la⁴jm²³ mah⁴ jian³ to³ quieh¹ a³jaun², hoh⁵i³ tia⁴ jian³ júanh¹i³ hña³ jeu³ a²caun². ");
INSERT INTO cucNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","I² con³ma²a⁴jen³i³ Jesús i²gm⁴ meih³, jon³ a⁴ŋeng⁴i³ jeu³ra³tyi⁴ i²con²³i³, i² jon³ a⁴si⁴jnei⁵i³ ta⁵nei²i³, ");
INSERT INTO cucNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a⁴hleh⁴i³ tia⁴, juah⁴i³: ―¿Henh⁴ hnoh³ˉ³ i²con²³ˉ⁵, hnei³ Jesús, A³jon⁴³ Jon⁴dai¹ Júanh⁴³? Mh⁵ˉ⁵ hnei³ con⁴juah⁴ jm³i⁴sain³ Jon⁴dai¹ i⁴sa⁴heh²ˉ³ ma²eu⁴³ pain⁴ i²con²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Quie¹ si²juah⁴ Jesús i²con²³i³: ―¡Hnei³ m⁴tyi⁴ hlagh³², jau²³ i²con²³ a³ne³! ");
INSERT INTO cucNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jon³ a⁴ŋang⁴ Jesús i²con²³i³, juah⁴i³: ―¿Henh⁴ sainh³ˉ³? I² a⁴jainh³ a³hain⁴ jau²³, juah⁴i³: ―Ta⁵la⁵mai²³ A²hlie⁴pa² sain³ˉ⁴ quie¹ eu⁴³ jeu⁴³ jnie³² leg⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jon³ a⁴mh³i³ Jesús hlion⁴ i⁴sa⁴sai³⁴i³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jian³ ma²tionh² jeun⁴³ a¹ñi⁴³ hloh³² mah⁴ a³ti²queuh³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","I² jon³ a⁴m⁴ la⁴jeg³⁴ m⁴tyi⁴ hlagh³², juah⁴i³: ―Sai⁴³ hnei³ jnie³² i²con²³ a¹ñi⁴³ jno³ i⁴han⁵ jnie³² naih⁵ ni²tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jon³ a⁴cúa⁴ Jesús jeu³, i² jon³ a⁴húa³ la⁴jeg³⁴ m⁴tyi⁴ hlagh³² jon³, a⁴han⁵i³ naih⁵ ni²tsei⁴³ a¹ñi⁴³ a³tain⁴³ conh⁴ to⁵mai²³. I² a¹ñi⁴³ hain⁴ la⁴jang³⁴, a⁴juan³⁴i³ i²ma²tionh² nei² a²hlo³ ñei⁴³ la⁴teg⁴ joh⁴³ jm³ñei³, i²a⁴chian³⁴ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jon³ a⁴cm⁴ a³ma²hion⁴³ a¹ñi⁴³ hain⁴, a⁴tya⁴i³ jau²³ je¹jeu³ la⁴jeg³⁴ i⁴a⁴leg³⁴ jian³ i²nau³ liah⁴. I² jon³ a⁵han² a³tionh² i²jon³ ua⁵je⁴i³ liah⁴ a⁴leg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","A⁴tyie³⁴i³ i²con²³ Jesús, jian³ a⁴jen³i³ a³hain⁴ a³ma²quian³ ma²eu⁴³ con⁴juah⁴ m⁴tyi⁴ hlagh³² i⁴ma²quian³i³ ta⁵la⁵mai²³, a⁴jen³i³ a³hain⁴ a³ua²cua⁴³ ma³ua²hein² a²cúan³ jian³ i⁴ma³ni²hyan³² co³hei²tsei³ quieh¹i³ o³re³; i² jon³ ra⁵coh⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","I² a³hain⁴ a³a⁴teg⁴ nei², a⁴tya⁴i³ jau²³ liah⁴ a⁴jainh⁴³ a³ma²quian³ m⁴tyi⁴ hlagh³², jian³ liah⁴ a⁴jainh⁴³ a¹ñi⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jon³ ma⁴lie⁵i³ tionh² a⁴mh³i³ Jesús i⁴ua⁵hag⁴³ jeu³ co²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","I² con³ma²a⁴hei³⁴ Jesús joh⁴³ a²úan⁴³, jon³ a⁴m⁴ a³ma²quian³ m⁴tyi⁴ hlagh³² hain⁴ i²con²³i³ i⁴cúa³⁴i³ jeu³ i⁴chie³⁴i³ jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","I² Jesús sa⁴a⁴cúa⁴ jeu³, quie¹ a⁴sagh⁴³i³ a³hain⁴: ―Cuanh³ jauh³² quianh³ i²con²³ si³reunh³, yi⁴tyah²ˉ³ jau²³ la⁴jeg³⁴ i⁴co³ jnia⁴ i⁴ma⁴jnia³ Se³ño²³ i²conh²ˉ³, jian³ liah⁴ joh³ ñei⁴ tsei⁴³i³ i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jon³ ŋah³ a³hain⁴, a⁴tya⁴i³ jau²³ Decápolis la⁴jeg³⁴ i⁴co³ jnia⁴ i⁴a⁴júan⁴ Jesús i²con²³i³; jian³ ta² co³ a⁴jainh⁴³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","I² con³ma²jonh³ Jesús jeu³ joh⁴³ a²úan⁴³ jo³² ta⁵hŋoh³ jm³ñei³, jon³ a⁴ŋangh³ jeun⁴³ chie³ hlonh²i³, i² hei⁴i³ si²sainh⁴³ quien¹i²jm¹. ");
INSERT INTO cucNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jon³ a⁴tyie³⁴ jan³ a³tyein² quian¹ cuah³ judío a³sain³ Jairo; i² con³ma²a⁴jen³i³ Jesús, jon³ a⁴si⁴jnei⁵i³, ");
INSERT INTO cucNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","a⁴mh³i³ hlion⁴, a⁴juah⁴i³: ―A³m⁴ jon³⁴ˉ⁴ ra³can²³ tyi⁴. ¿Sa¹ cúah²ˉ³ ua²teih⁴³ˉ³ si¹cúah³ he³²i³, canh⁴a² huan⁴ jian³ li⁴jainh¹i³? ");
INSERT INTO cucNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","I² jon³ ŋo³⁴ Jesús jian²³i³; jian³ ta² jeun⁴³ chie³ ua⁵han², i⁴si²hnauh⁴o³ tionh²i³ jeu³ hlian⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","I² jen²i³ tionh² hein² jan³ a³m⁴ a³chieh¹ ma³quia⁵teun⁴ ñi³, a³lang⁴³ ua³pei⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hlion⁴ ma²eu⁴³ ma³a⁴can³⁴i³ con⁴juah⁴ teg³m⁴³, jian³ ma³a⁴chia³⁴ la⁴jeg³⁴ i⁴sia³ quieh¹i³ i⁴júan³i³ hei²³ jon³, jian³ i¹leuh² sa⁴lag¹ tsei⁴³i³; tsei³⁴sa² hlion⁴ a⁴jainh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","I² con³ma²a⁴nau⁴ a³m⁴ hain⁴ i⁴tya²³ chie³ jau²³ nei² quieh¹ Jesús, jon³ a⁴tyie³⁴i³ ta⁴coh⁵cah³²i³ jen²i³ chie³ jeun⁴³ hain⁴, a⁴tang⁴i³ he⁴³ a²cúan³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Quie¹ ma²juah⁴i³ naih⁵ m⁴tyi⁴ quieh¹: “A⁴leg³⁴ na¹a⁴tang⁴ˉ⁴ a²cúan³ pi²³i³, huan⁴ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Liah⁴ma²jon³ a⁴jian⁴ ua³pei⁴ i⁴ma²lang⁴³i³; jian³ ra⁵laih²i³ i⁴ma³a⁴huan⁴ chie² i⁴ma²lang⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","I² Jesús ne⁵, ra⁵laih²i³ liah⁴ma²jon³ liah⁴ i⁴ma³a⁴huan⁴ quieh¹ jan³ chie³ con⁴juah⁴ ua³pei⁴ quieh¹i³; jon³ ua⁵lang⁴i³, a⁴sagh⁴³i³ chie³ jeun⁴³ hain⁴, juah⁴i³: ―¿Hain³ a⁴tang⁴ a²cúan³⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","I² a⁴juah⁴ chie³ quian¹i³ tionh²: ―Hnei³ A²teg²³, jeh⁴ˉ³, chie³pa² si²hnauh⁴, hlie⁴³ hnei³. ¿E⁴le³⁴ ŋangh³ˉ³: “¿Hain³ a⁴tang⁴ a²cúan³⁴ˉ⁴?” ");
INSERT INTO cucNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jon³ a⁴je³⁴ Jesús co⁴la⁴langh⁵i³ canh⁴a² jen⁴³i³ hain³ chianh² a⁴tang⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","I² a³m⁴ hain⁴, coh⁴³i³ jian³ jlen²³i³, quie¹ ra⁵laih²i³ liah⁴ a⁴jainh⁴³i³; jon³ a⁴tyie³⁴i³ hlonh²i³, a⁴si⁴jnei⁵i³ ta⁵nei²i³, jian³ a⁴sagh⁴³i³ Jesús liah⁴ a⁴jainh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Hnei³ jon²³ quian³⁴ˉ⁴, ma³a⁴huan⁴pa² quianh³ˉ³ quie¹ ra⁵hainh⁴ˉ³. Cuanh³ hnei³ si³hyonh³ˉ³, ma³a⁴huan⁴ quianh³ˉ³ chie² i⁴ma²langh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma²si²hleh² pi¹ Jesús, con³ma²a⁴tyie³⁴ chie³ a³ma²tionh² jauh³² quieh¹ a³tyein² quian¹ cuah³ hain⁴, a³a⁴sag⁴³ quieh¹i³: ―Ma³jaun²pa² a³jonh³ˉ³. ¿E⁴le³⁴ ma⁵si⁵quianh³²ˉ³ tsei⁴³ A²teg²³? ");
INSERT INTO cucNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","I² Jesús ne⁵, con³ma²a⁴nau⁴i³ jau²³ i⁴a⁴juah⁴i³ tionh², jon³ a⁴sagh⁴³i³ a³tyein² quian¹ cuah³ hain⁴, juah⁴i³: ―A⁵júan³ hnei³ canh⁴³. Hniah³ hainh⁴pa² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jian³ sa⁴a⁴cúa⁴i³ juah⁴ i⁴chie³⁴ i¹jan³ jian²³i³, Pe³², Jacobo jian³ Juan²³ reunh¹ Jacobo pa². ");
INSERT INTO cucNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","I² jon³ a⁴tyie³⁴ Jesús jauh³² quieh¹ a³tyein² quian¹ cuah³ hain⁴, jian³ a⁴je³⁴i³ i⁴nie⁴³ ti³jan²³, jian³ i⁴tionh² a³ti²hoh⁵ tia⁴ jian³ i⁴chionh⁴ tsei⁴³i³ hlion⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I² con³ma²a⁴hei³⁴i³, jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―¿E⁴le³⁴ ti²júanh³ˉ³ ti³jan²³ i⁴ti²hoh⁵ˉ³ tionh²ˉ³? A⁵sian⁴³ yein³ ra³jaun², ra³cm²pa². ");
INSERT INTO cucNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","I² hei⁴i³ tionh² ne⁵, a⁴ji⁴ŋang⁴i³ Jesús. I² con³ma²a⁴húan⁴³i³ la⁴jang³⁴ a³hain⁴ tionh² coh⁵hnei³², jon³ jian³i³ jmai³sie²³ a³peih¹ m⁴ hain⁴ jian³ li⁵on³ a³ma²jian²³ Jesús, a⁴hei³⁴i³ i²ra³quian³ yein³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I² jon³ a⁴tang⁴i³ si¹cúa³ yein³, a⁴sagh⁴³i³: ―Talita cumi ―i⁴hnie³⁴ ra³juah⁴: Hnei³ a³peih¹, jeu³⁴ˉ⁴ hnei³ tieh²la³, ra⁴hang³² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Liah⁴ma²jon³ a⁴no³ yein³ jian³ a⁴ŋeng⁴i³, jian³ yein³ hain⁴, hein² quia⁵teun⁴ ñi³. I² con³ma²a⁴je³⁴i³ i⁴jon³, ta² yi⁴hag³² tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","I² Jesús ne⁵, jon³ a⁴júan⁴i³ heih⁴³ pain⁴ i²con²³i³ tionh² i⁴sa⁴tyieh³i³ jau²³ i¹jan³ liah⁴ a⁴leg³⁴, jian³ a⁴juah⁴i³ i⁴hniah³ guenh⁴³i³ a³peih¹ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","I² jon³ ua⁵hag⁴³ Jesús i²jon³, a⁴tyanh³i³ jeu³ co²³ jian²³i³ la⁴jang³⁴ chie³ quian¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","I² con³ma²a⁴tyie³⁴ jm² sa⁴júan³i³ ta¹, jon³ a⁴heh³i³ chie³ cuah³ judío. Jian³ ta² jeun⁴³ chie³ ŋo³⁴ co³ tsei⁴³, con³ma²a⁴nau⁴i³ jau²³ quieh¹i³, a⁴juah⁴i³ tionh²: ―¿Jainh¹ ni²quian⁴ a³ne³ la⁴jeg³⁴ i⁴ne³, lainh⁴ˉ³? ¿Jian³ liah⁴ cúan²³ a⁴hyieh³i³ i⁴ŋang⁴i³ la⁴ne³ jian³ i⁴júan³i³ la⁴jeg³⁴ ua³júah² ne³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿A¹hei⁴ teg³hma³ hain⁴ ne³, a³jon⁴³ Ma³rei², a³reunh¹ Jacobo, jian²³ Se¹, jian³ Judas jian³ Si²úan¹ liah⁴? ¿O⁴ sa¹ chie⁴³ tionh² si³m⁴ reunh¹i³ jen²ˉ¹ la³? I⁴jon³ sa⁴a⁴ron⁴³i³ Jesús jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―La⁴tan²pa² ron⁴³i³ jeu³ a³sain² quian¹ Jon⁴dai¹; jeu³ co²³ pi²³i³ sa⁴ro⁴³i³ jeu³ jian³ jen² si³reunh¹i³ jian³ jauh³² quieh¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I⁴jon³ i¹con³ ua³júah² pain⁴ a⁵sie⁴³ ma⁵júan⁴i³, con⁴hie³² a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ co⁴meih³ a³chieh¹pa² i⁴a⁴tei³⁴i³ si¹cúa³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jian³ ta² co³ a⁴jainh⁴³ Jesús nei² quieh¹ sa⁴i²li⁴hain⁴i³ tionh². I² jon³ a⁴ŋeng⁴i³ la⁴jeg³⁴ jeu³ peih¹ i⁴nie⁴³ hloh³² jon³, a⁴heh³i³ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","I² coh⁵ jon³ a⁴teh³ Jesús quia⁵teun⁴ chie³ quian¹, jon³ a⁴sain⁴i³ a³hain⁴ tionh² ma⁵on³⁴, jian³ a⁴cúah³i³ heih⁴³ i⁴húa³⁴i³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jian³ a⁴júan⁴i³ heih⁴³ i²con²³i³ tionh² liah⁴ i⁴sa⁴can³⁴i³ i¹con³ i⁴quieh¹ ho³²jeu³, con³ a²hma³heu¹pa²; jian³ sa⁴hniah³ can³⁴i³ a²mo³ra², jian³ sa⁴hniah³ can³⁴i³ a²hei⁴³, jian³ a⁵ga⁴ o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jian³ hniah³ can³⁴i³ a²lo³ tsei²³ tag³² liah⁴, jian³ sa⁴hniah³ can³⁴i³ a²cúan³ i⁴seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jian³ a⁴juah⁴i³ liah⁴: ―Juah⁴ jainh¹ i²a⁴heuh³ˉ³ con³ jauh³² tionh²ˉ³, jian² hnei³ jauh³² jon³ la⁴conh⁴i² a⁴jauh²ˉ³ jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","I² juah⁴ne³ sa⁴hyei⁴³i³ hnei³ con³ jeu³ a⁵ga⁴ a⁴nau⁴i³ jau²³ quianh³ˉ³, i⁴jon³ jau²³ hnei³ i²jon³ tionh²ˉ³, jian³ poh⁴³ hnei³ o¹hlie³ ti²quin⁴³ si¹tagh¹ˉ³, i⁴júan³ lei³ i⁴sa⁴jaih¹ a³hain⁴ tionh². Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, tei⁴³i² teg³⁴ jm² queih³ Jon⁴dai¹ heih⁴³ i²con²³ chie³, eu⁴³a² pain⁴ ma²eu⁴³ hyieh⁴ a³tionh² jeu³ jon³ la⁴conh⁴a² hyieh⁴ jeu³ Sodoma jian³ Gomorra. ");
INSERT INTO cucNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","I² jon³ ua⁵han²i³ tionh² ua⁵hleh³i³ jau²³ tsei²³ i²con²³ chie³ i⁴hniah³ sag⁴ co³hei²tsei³ quieh¹ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jian³ a⁴húa⁴i³ hlion⁴ m⁴tyi⁴ hlagh³², jian³ a⁴jñei³⁴i³ o¹a³sai²te³ he³² jeun⁴³ a³chieh¹, jon³ a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","I² la⁴jon³ ne⁵, a⁴nau⁴ re¹ Herodes nei² quieh¹ Jesús, quie¹ ma³ta⁴tsei¹ jau²³ nei² quieh¹i³. Jon³ a⁴juah⁴i³: ―Juan³ Tei³²pa² a³hain⁴ a⁴hyon²³ jen² a³jaun², i⁴jon³da³ quian³i³ ua³pei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","I² a⁴juah⁴ ca³chion²³: ―I³lie²³pa² a³hain⁴. Conh⁴liah⁴ a⁴juah⁴ ca³chion²³: ―Jan³ a³sain² quian¹ Jon⁴dai¹pa² a³hain⁴, jian³ o⁴ i²jan³ a³sain² quian¹ ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Con³ma²a⁴nau⁴ Herodes i⁴ne³, jon³ a⁴juah⁴i³: ―Juan³ Tei³²pa² a³hain⁴, a³a⁴hyon²³ jen² a³jaun², a³a⁴júan³⁴ˉ⁴ heih⁴³ i⁴a⁴gmh⁴ ma³lau²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Quie¹ hña³pa² Herodes a⁴sain⁴i³ chie³ quian¹ i⁴a⁴sanh³i³ Juan²³ liah⁴ma²jia⁴³, jian³ a⁴hñi⁴i³ a²ca³den², jian³ a⁴tanh³i³ ni⁴ñi²³. A⁴júan⁴i³ la⁴jon³ nei² quieh¹ Herodías, a³m⁴ quian¹ Lei³² reunh¹i³, quie¹ a⁴sanh⁴i³ jian²³ a³m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Quie¹ ma²a⁴juah⁴ Juan²³ i²con²³ Herodes: ―Sa⁴ra³cúa²³ juah⁴ i⁴jianh¹ˉ³ a³m⁴ quian¹ a³reunh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","I² a³m⁴ Herodías hain⁴, hion²³i³ Juan²³, ma²hnie³⁴i³ jŋangh³i³; i² sa⁴tian⁴ ne⁵, ");
INSERT INTO cucNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","quie¹ ta⁵la⁴ coh⁴³ Herodes, con⁴³i³ Juan²³, quie¹ ñi³i³ i⁴lang⁴³i³ chie³ tsein²³ a³ni²taih⁴³. I⁴jon³ hion⁴³i³ i⁴sa⁴hnie³⁴i³ jainh⁴³i³ i¹con³; jian³ tei⁴³i² ma²nau³i³ jau²³ i⁴hleh² Juan²³, ta² so⁵ñi³i³ liah⁴ sian³i³ lei⁴, i² ton³²nie⁴³ ma²nau³i³ si³hyonh³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","I² a³m⁴ Herodías ne⁵, a⁴tyie³⁴ con³ jm² i⁴a⁴cagh¹i³ jm² con³ma²ti²júan³i³ jm² i⁴a⁴tagh³ Herodes ñi³ ra⁵sian³, jian³ ti²queuh³i³ a²hei⁴³ jian²³ a³tyein² jian³ jeu³² a²hlie⁴ jian³ chie³ canh² quian¹ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","I² jon³ a⁴hei³⁴ a³m⁴ jon⁴³ Herodías, ŋo³⁴i³ jan¹, jian³ ta² a⁴teg⁴ tsei⁴³ Herodes jian³ la⁴jang³⁴ a³tionh² mesa jian²³i³. I² jon³ a⁴juah⁴ re¹ i²con²³ a³m⁴ peih¹: ―M² hnei³ henh⁴ hnoh³ˉ³ i²con²³ˉ⁵, jon³ cúa¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jian³ a⁴cúa⁴ re¹ jau²³ quieh¹ liah⁴ i⁴jang³⁴ tsei⁴³i³ o³tan², juah⁴i³: ―La⁴jeg³⁴ i⁴mh²ˉ³ i²con²³ˉ⁵, cúa¹ˉ⁴; la⁴teg⁴ to⁵chieh³² húa³⁴ i²júan³⁴ˉ⁴ heih⁴³pa² cúa¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I² jon³ ua⁵hag⁴³ a³m⁴ peih¹ hain⁴ ua⁵saih¹i³ sie²³, a⁴juah⁴i³: ―¿Henh⁴ m¹ˉ⁴, lainh⁴ˉ³? I² jon³ a⁴juah⁴ sie²³i³: ―M² hnei³ ma³tyi² Juan²³pa² mh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","I² jon³ a⁴hei³⁴ a³m⁴ peih¹ hain⁴ ta¹tia⁴ ta⁵i²cua⁴³ re¹, a⁴m⁴i³ i²con²³i³, a⁴juah⁴i³: ―Hno⁵ˉ⁵ ma³tyi² Juan³ Tei³² hei¹ joh⁴³ a²gm⁴³ to⁴ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","I² re¹ ne⁵, ta² ra⁵chionh⁴ tsei⁴³i³ jau²³ jon³; quie¹ sa⁴i²jlian³⁴i³ nei² quieh¹ jau²³ i⁴a⁴cúa⁴i³ jian³ nei² quieh¹ a³tionh² mesa jian²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Liah⁴ma²jon³ a⁴sain⁴ re¹ jan³ a²hlie⁴ quian¹, a⁴júan⁴i³ heih⁴³ i⁴si⁵quian⁴i³ ma³tyi² Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jon³ ŋo³⁴ a²hlie⁴ hain⁴ ua⁵queih⁴i³ ma³lau² Juan²³ la⁴teg⁴ ni⁴ñi²³, jon³ quien²³i³ hei¹ joh⁴³ a²gm⁴³. Jon³ a⁴cúah³i³ a³m⁴ peih¹ hain⁴, i² a³m⁴ peih¹ hain⁴, ni²cúah²i³ sie²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","I² con³ma²ra⁵ñi³ chie³ quian¹ Juan²³ jau²³ jon³, jon³ a⁵han²i³, a⁴con²³i³ he³²i³, ni²ho⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","I² jon³ a⁴ŋangh³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Se³ño²³ hain⁴ tionh² hlonh² Jesús, jon³ a⁴tya⁴i³ jau²³ tionh² i²con²³i³ la⁴jeg³⁴ i⁴a⁴he⁴i³ jian³ i⁴a⁴júan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","I² jon³ a⁴juah⁴ Jesús: ―Ma³²ˉ¹, ma⁵jian³²ˉ¹ co⁴le⁴ con³ i²a⁵sian⁴³ a³sian³. Quie¹ jeun⁴³ chie³ si³han² i²con²³ Jesús jian³ ma⁵a³ma³jonh² liah⁴, i¹ sa⁴tag³ o³tan² i⁴queuh⁴³i³ a²hei⁴³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jon³ ua⁵han²i³ húan⁴i³ tionh² la⁴teg⁴ con³ i²a⁵sian⁴³ a³sian³ jeu³ joh⁴³ a²úan⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","I² jeun⁴³ chie³ a⁴je³⁴ ne⁵, con³ma²ua⁵han²i³, jian³ ra⁵cm²³i³ Jesús; i² jon³ ua⁵han² jeun⁴³ chie³ hain⁴ jeu³ tag³² tionh², a⁴tyie³⁴i³ i²jon³ naih⁵i² a⁴tyie³⁴ Jesús jian²³ chie³ quian¹, i² jon³ a⁴ŋangh³ jeun⁴³ chie³ hain⁴ hlonh²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","I² con³ma²ua⁵hag⁴³ Jesús joh⁴³ a²úan⁴³, jon³ a⁴jen³i³ chie³ jeun⁴³ lio⁴mai²³ hain⁴; i² jon³ joh³ ñei⁴ tsei⁴³i³ i²con²³i³ tionh², quie¹ lang⁴³i³ liah⁴i² lang⁴³ a⁵a³siah³ a³sa⁴sian³ jeu³²; i² jon³ ma⁴lie⁵i³ a⁴heh³i³ a³hain⁴ tionh² hlion⁴ jau²³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","I² con³ma²a⁴hlo⁴, jon³ ua⁵han² chie³ quian¹i³ hlonh²i³, a⁴juah⁴i³ tionh²: ―Ta² a⁴hlo⁴, i² i²tieh²ˉ¹ la³ i²a⁵sian⁴³ a³sian³pa². ");
INSERT INTO cucNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Sain⁴³ hnei³ a³jeu³ canh⁴a² si⁵lia⁴³i³ i⁴queuh⁴³ la⁴jeg³⁴ jeu³ peih¹ jian³ i²nau³ la⁴con³ hloh³² ne³, quie¹ sa⁴quian³i³ i⁴queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Guenh³²i³ hnei³ tionh²ˉ³. Jon³ a⁴juah⁴i³ tionh²: ―¿O⁴ sa¹ re³ chie³² jnie³² si²lia³² jnie³² teun³⁴ nia⁴lo⁴ o¹cau³² tie³ a²hei⁴³ñih¹ jian³ guenh³²i³ jnie³², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","I² a⁴juah⁴ Jesús: ―¿Jah⁴ a²hei⁴³ñih¹ quianh²ˉ³ tionh²ˉ³ ne⁵? Cua³ ua⁴je¹ hnei³. I² con³ma²ra⁵ñi³i³ tionh², jon³ a⁴juah⁴i³: ―Hña⁴ a²hei⁴³ñih¹pa² leg⁴³ jian³ on³⁴ jon⁴³júa³². ");
INSERT INTO cucNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","I² jon³ a⁴júan⁴i³ heih⁴³ i²con²³ chie³ quian¹ i⁴sagh⁵i³ la⁴jang³⁴ a³jeu³ i⁴cua³⁴i³ ma⁵conh⁴ ni²quian⁴ o¹ñei³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jon³ a⁴cua⁴i³ tionh² ma⁵nia⁴lon⁴, ma⁵to⁴lo⁵quian⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","I² jon³ a⁴tang⁴ Jesús li⁵hña⁴ a²hei⁴³ñih¹ jian³ li⁵uan⁴ jon⁴³júa³²; i² con³ma²a⁴je³⁴i³ ta⁵ñi⁴jeu⁵, jon³ a⁴ma⁴cúah¹i³ jian³ a⁴jeun³⁴i³, i² jon³ a⁴cúah³i³ chie³ quian¹, ma²jon³ a⁴tyieh⁵ chie³ quian¹i³ i²con²³ chie³ jeun⁴³ hain⁴ tionh². Jian³ la⁴ne³ a⁴tyieh⁵i³ jon⁴³júa³² liah⁴ i²con²³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jon³ a⁴queuh³ la⁴jang³⁴ a³hain⁴ tionh², jian³ a⁴lag³⁴ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","I² con³ma²a⁴leg³⁴ jon³, jon³ a⁴jaih³i³ o¹leuh² a²hei⁴³ñih¹ i⁴a⁴sion³⁴ jian³ o¹leuh² quieh¹ jon⁴³júa³², jon³ a⁴canh³ quia⁵teun⁴ a²mh³ta²³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jian³ la⁴jang³⁴ a³a⁴queuh³ hain⁴ tain⁴³ hña⁴ mai²³ a³ñih³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Liah⁴ma²jon³ a⁴júan⁴ Jesús i⁴han⁵ chie³ quian¹ joh⁴³ a²úan⁴³ jian³ chie³⁴i³ ta⁵jo³² hŋoh³, ta⁵jeu³ Betsaida, naih⁵i² chie³⁴ hei⁴i³ ta¹la⁴ sainh³i³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","I² con³ma²a⁴sainh³i³ a³jeu³, jon³ ŋo³⁴i³ nei² mah⁴ ua⁵mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","I² con³ma²a⁴nai³, jon³ ma³a⁴tyie³⁴ a²úan⁴³ jon³ la⁴teg⁴ yi⁴jo²³ jm³; i² hei⁴i³ hña³ ne⁵, i²quein³ pi¹ sainh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","I² jon³ a⁴jen³i³ chie³ quian¹ a³ti²can²³ ma²eu⁴³ i⁴jua²³i³ a²hma³júah¹, quie¹ jia²³ tyi⁴ jeu³ chie²³i³ tionh². I² jon³ a⁴tyie³⁴ Jesús hlonh²i³, to⁵hie³ nai³, ŋeng²³i³ jeu³ nei² jm³, ma²hnie³⁴i³ ua⁵jeun³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","I² con³ma²a⁴je³⁴ chie³ quian¹i³ i⁴ya¹ŋeng²³i³ jeu³ nei² jm³, jon³ a⁴júan⁴i³ co³hei²tsei³ tionh², lain⁴i³, a²nai³²pa²; jon³ a⁴hoh⁵i³ tia⁴; ");
INSERT INTO cucNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","quie¹ a⁴je³ la⁴jang³⁴, jian³ ta² yi⁴hang³²i³ tionh². I² hei⁴i³ ne⁵, liah⁴ma²jon³ a⁴hlenh⁴³i³ a³hain⁴ tionh², a⁴juah⁴i³: ―¡Re³ tya² hnei³ hoh⁴³ tionh²ˉ³; jnia⁴pa² la³, a⁵júan³ hnei³ canh⁴³! ");
INSERT INTO cucNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","I² jon³ a⁴hei³⁴ Jesús joh⁴³ a²úan⁴³ i²tionh²i³, jian³ a⁴jian⁴ tyi⁴; ta² a⁴tanh⁴³ tsei⁴³i³ tionh², jian³ ta² co³ a⁴jainh⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Quie¹ a⁵sia³ ma³ŋang⁴i³ tionh² ua³júah² nei² quieh¹ a²hei⁴³ñih¹ jon³, quie¹ huah³ pi¹ m⁴tyi⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I² con³ma²a⁴han³i³ jm³ñei³ tionh², jon³ a⁴tyie³⁴i³ húa³⁴ Genesaret. I² jon³ a⁴hñei³⁴i³ a²úan⁴³ quien¹i²jm¹. ");
INSERT INTO cucNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","I² con³ma²a⁴húan³i³ joh⁴³ a²úan⁴³ tionh², liah⁴ma²jon³ ra⁵cu²³ a³sian³ húa³⁴ jon³ quieh¹ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jian³ liah⁴ma²jon³ ua⁵han²i³ la⁴conh⁴ i²tei⁴³ húa³⁴ jon³ la⁴conh⁴ hloh³² jon³, ua⁵quian⁴i³ a³chieh¹ a³sian³ la⁴tan² jon³ a³hein² a²hyei²³, jian³i³ la⁴teg⁴ i²nau³i³ sainh⁴³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jian³ la⁴tan² i²ŋeng²³ Jesús ua²jainh¹i², jeu³ peih¹, jeu³ júah², jian³ o⁴ i²nau³, a⁴quion³i³ la⁴jang³⁴ a³ti²chieh¹ jeu³júan²³, jian³ a⁴mh³i³ Jesús i⁴cúa³⁴i³ jeu³ i⁴tei³⁴ a³chieh¹ si¹cúa³ he⁴³ a²cúan³i³; i² la⁴jang³⁴ a³a⁴tang⁴ he⁴³ a²cúan³i³ hain⁴, a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jon³ a⁴ŋangh³ fariseo jian³ a²teg²³ quian¹ lai²³ i²con²³ Jesús, a³a⁵han² Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","I² a³hain⁴ tionh² a⁴jen³i³ chie³ quian¹ Jesús i⁴queuh³i³ a²hei⁴³ liah⁴ma³heinh⁵ si¹cúa³i³, hnie³⁴ ra³juah⁴, i⁴sa⁴ra³cag⁴ si¹cúa³i³, i⁴jon³ a⁴si⁴he⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Quie¹ la⁴jang³⁴ fariseo jian³ la⁴jang³⁴ judío ma³co⁴³ i⁴tang²³ quieh¹ a³don⁵ ma⁴³teg²³ i⁴sa⁴queuh³i³ a²hei⁴³ juah⁴ne³ sa⁴a⁴raunh⁵i³ si¹cúa³ hlion⁴ nie⁴³ ñeih³². ");
INSERT INTO cucNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Conh⁴liah⁴ la⁴jon³ la⁴teg⁴i² jonh³i³ je¹hmah¹, sa⁴queuh³i³ juah⁴ne³ sa⁴ra⁵cang⁴i³ ñeih³². Jian³ hlion⁴ pi¹ i⁴tang²³ quieh¹i³ i⁴seg³⁴ hie³i³ liah⁴, i⁴raunh⁵i³ a²va²so³ jian³ a²tsai³² jian³ a²teuh³ ñi²³ jian³ tag³²jain³².) ");
INSERT INTO cucNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","I⁴jon³ a⁴ŋang⁴ fariseo jian³ a²teg²³ quian¹ lai²³ tionh² i²con²³ Jesús, a⁴juah⁴i³: ―¿E⁴le³⁴ sa⁴ma³co⁴³ chie³ quianh³ˉ³ i⁴tang²³ quieh¹ a³don⁵ ma⁴³teg²³? Quie¹ queuh³i³ a²hei⁴³ liah⁴ma³heinh⁵ si¹cúa³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I² jon³ a⁴jainh³ Jesús jau²³, a⁴juah⁴i³: ―Hnei³ chie³ a³júan³ ni²taih⁴³, re³ a⁴hleh⁴ Isaías, a³sain² quian¹ Jon⁴dai¹ hain⁴, nei² quianh³ˉ³ tionh²ˉ³, liah⁴i² ra³sag²: Ma³co⁴³ jnia⁴ a³jeu³ ne³ jeu³ ho³², i² m⁴tyi⁴ quieh¹i³ ne⁵, sa⁴hei¹ i²con²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Quie¹ sa⁴tei⁴³ ta¹ liah⁴ ma³co⁴³i³ jnia⁴, quie¹ jau²³ i⁴he²³i³ leg⁴³ jmah³ heih⁴³ quieh¹ a³ñih³pa². ");
INSERT INTO cucNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Quie¹ tonh³ˉ³ heih⁴³ quieh¹ Jon⁴dai¹ tionh²ˉ³ i⁴ma⁵coh³²ˉ³ i⁴tang²³ quieh¹ a³ñih³, i⁴raunh³ˉ³ a²tsai³² jian³ a²va²so³, jian³ hlion⁴ pi¹ i⁴co³nai² i⁴júanh³ˉ³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jian³ a⁴sagh⁴³i³ a³hain⁴ tionh² liah⁴: ―I² la⁴ne³ ta² re³ tyah³ˉ³ ta⁵co⁴³ heih⁴³ quieh¹ Jon⁴dai¹ canh⁴a² ma²coh³²ˉ³ i⁴tang²³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Quie¹ a⁴juah⁴ M³se²³: “Ma⁴con³² hnei³ naih⁴³sieh³”, jian³ “A³hain⁴ a³sagh⁴³ jmai³sie²³ jau²hlagh³², hniah³ jaun⁴ i⁴so⁵sia³ i⁴hain⁴i³ chie³².” ");
INSERT INTO cucNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","I² hnei³ tionh²ˉ³ juah⁴ˉ³ ne⁵, i⁴li⁴juah⁴ chie³ i²con²³ jmai³ jian³ o⁴ sie²³: “La⁴jeg³⁴ i⁴sia³ quien⁴ˉ⁴ i⁴ma²li⁴ma²hon³²ˉ⁴ hnei³ leg⁴³ Corbán” (hnie³⁴ ra³juah⁴, i⁴ma³a⁴jeu³⁴ˉ⁴ Jon⁴dai¹ i⁴tain⁴³ hei⁴ pi²³i³); ");
INSERT INTO cucNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","a³hain⁴ a³juah⁴ la⁴ne³, jon³ a⁵sie⁴³ li⁴ma⁵hon³²i³ jmai³sie²³, juah⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","I² la⁴ne³ júanh³ˉ³ i⁴sa⁴quein⁴³ jau²³ quieh¹ Jon⁴dai¹ nei² quieh¹ i⁴ma⁵coh³²ˉ³ i⁴tang²³ quianh³ˉ³ i⁴si³tyeinh³. Jian³ hlion⁴ pi¹ i⁴seg³⁴ júanh³ˉ³ i⁴co³nai² la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jon³ a⁴teh³i³ chie³ jeun⁴³ hain⁴ tionh² liah⁴, a⁴sagh⁴³i³: ―Nai³ hnei³ la⁴jangh³ˉ³ tionh²ˉ³, jian³ ua²li⁴ŋangh⁴ˉ³: ");
INSERT INTO cucNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Quie¹ i¹con³ i⁴si³ha¹ hein² chie³ sa⁴júan³ i⁴hlianh⁴ chie³, ua²henh⁴a², quie¹ i⁴húa²³ to³lau² pi²³i³ júan³ i⁴hlianh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","A³hain⁴ a³ho³ ta³ra³cua¹, ua²nai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","I² con³ma²a⁴tain³⁴i³ chie³ jeun⁴³ hain⁴, jon³ a⁴hei³⁴i³ jauh³², i² jon³ a⁴ŋang⁴ chie³ quian¹i³ i²con²³i³ nei² quieh¹ jau²³ sa⁴lei³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","I² jon³ a⁴juah⁴ Jesús: ―¿O⁴ jeg⁵ hnei³ tionh²ˉ³ liah⁴ sa⁴quienh⁴ tyih³ˉ³? ¿O⁴ sa⁴ñih¹ˉ³ i⁴la⁴jeg³⁴ si³ha¹ hein² chie³ sa⁴li⁴júan³⁴ i⁴hlianh⁴i³? ");
INSERT INTO cucNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Quie¹ sa⁴si³ha¹ naih⁵ m⁴tyi⁴ quieh¹i³, quie¹ hein² pi²³i³ si³ha¹; i² tei⁴³i² a⁴leg³⁴ jon³, jon³ húa²³. A⁴hleh⁴ Jesús i⁴ne³, hnie³⁴ ra³juah⁴, i⁴tsei³⁴pa² la⁴jeg³⁴ i⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jian³ a⁴juah⁴i³: ―La⁴jeg³⁴ i⁴jia²³ teg⁴ naih⁵ m⁴tyi⁴ quieh¹ chie³, i⁴ne³pa² júan³ i⁴hlianh⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Quie¹ teg⁴ naih⁵ m⁴tyi⁴ quieh¹ chie³ tionh², naih⁵ ni²tsei⁴³i³, jia²³ co³hei²tsei³ hlagh³² la⁴la³, i⁴hlenh⁴³i³ i³cúa³ chie³, i⁴hlenh⁴³i³ a³m⁴ sang³⁴, i⁴jŋangh²i³ chie³, ");
INSERT INTO cucNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","i⁴júan³i³ hang³, i⁴tsainh³i³ hnie³⁴i³ hlion⁴, i⁴júan³i³ i⁴hlagh³², i⁴ma³can³i³ chie³, i⁴júan³i³ i⁴ua³hyeih² jnia⁴, i⁴eu⁴³ tsei⁴³i³, i⁴hleh²i³ hlagh³² nei² quieh¹ a³sang²³, i⁴júan³i³ ron⁴, jian³ i⁴júan⁴³i³ a³sa⁴ŋang⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","La⁴jeg³⁴ i⁴hlagh³² ne³ jia²³ teg⁴ naih⁵ m⁴tyi⁴ quieh¹ chie³, jian³ júan³ i⁴hlianh⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jon³ ua⁵hag⁴³ Jesús i²jon³, ŋo³⁴i³ ta⁵húa³⁴ i²nie⁴³ jeu³ Tiro jian²³ Sidón. I² con³ma²a⁴tyie³⁴i³ con³ jauh³², jon³ sa⁴ma²hnie³⁴i³ li⁴ñi³ i¹jan³ i⁴cua⁴³i³; i² sa⁴tian⁴ li⁴si⁵hma³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Quie¹ a⁴nau⁴ jan³ a³m⁴ nei² quieh¹i³ a³sian³ jan³ a³m⁴ jon⁴³ a³quian³ con³ m⁴tyi⁴ hlagh³²; i² jon³ a⁴tyie³⁴ a³m⁴ hain⁴, a⁴si⁴jnei⁵i³ ta⁵nei² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","I² a³m⁴ hain⁴ lang⁴³ jan³ chie³ sang²³, a³sian³ húa³⁴ sirofenicia. I² jon³ a⁴mh³i³ Jesús i⁴tyi⁴³i³ m⁴tyi⁴ hlagh³² i⁴quian³ a³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","I² a⁴juah⁴ Jesús ne⁵: ―Hniah³ queuh⁴³ si³jon⁴³ liah⁴a² a⁴lag³⁴ tsei⁴³i³ ñeih³², quie¹ sa⁴re³ juah⁴ i⁴qui³⁴i³ a²hei⁴³ñih¹ quieh¹ si³jon⁴³ i⁴cúah³i³ a¹tsai³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","I² a⁴juah⁴ a³m⁴ hain⁴ ne⁵: ―Hnei³ Se³ño²³, i⁴chie⁴³pa² jau²³ quianh³ˉ³; quie¹ to³²nie⁴³pa² queuh³ jon⁴³ tsai³ peih¹ o¹leuh² i⁴jyih² naih⁵ a²me²sa³, i⁴quieh¹ si³jon⁴³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","I² jon³ a⁴juah⁴ Jesús: ―Ta² re³ a⁴hleh²ˉ³; ma³li⁴cuanh³pa² hnei³. Quie¹ ma³ua⁵hag⁴³ m⁴tyi⁴ hlagh³² ma²quian³ a³m⁴ jonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","I² con³ma²a⁴tyanh³ a³m⁴ hain⁴ jauh³² quieh¹, jon³ a⁴je³⁴i³ i⁴ma³ua⁵hag⁴³ m⁴tyi⁴ hlagh³² jon³, jian³ ra³quian³ a³jon⁴³i³ nei² a²jain³². ");
INSERT INTO cucNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jon³ ua⁵hag⁴³ Jesús liah⁴ i⁴seg³⁴ húa³⁴ i²nie⁴³ jeu³ Tiro jon³, ua⁴jeun³²i³ Sidón jian³ i²sain³ Decápolis, ŋo³⁴i³ jm³ñei³ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","I² jon³ jian³i³ jan³ a³ñih³ a³teun³ a³hleh² so³heih³, a⁴mh³i³ Jesús i⁴tei³⁴i³ si¹cúa³ i²con²³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I² jon³ ua⁵jo³ Jesús quieh¹i³ con³ ta⁵co⁴³, jian³ a⁴tia³⁴i³ jon⁴³ si¹cúa³ ta³ra³cua¹ a³hain⁴, jian³ a⁴hñei³⁴i³ jon⁴³ si¹cúa³, ma²jon³ a⁴tei³⁴i³ nei² o¹segh³² a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","I² con³ma²a⁴je³⁴ Jesús ñi⁴jeu⁵, jian³ a⁴sionh³i³ tsei⁴³, jon³ a⁴sagh⁴³i³ a³chieh¹: ―¡Efata! ―hnie³⁴ ra³juah⁴: ¡Ua²nia⁴ hnei³! ");
INSERT INTO cucNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Liah⁴ma²jon³ a⁴na⁴ ta³ra³cua¹i³, jian³ ra⁵hua³² o¹segh³²i³ liah⁴, a⁴hleh⁴i³ re³. ");
INSERT INTO cucNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","I² jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³ tionh² i⁴sa⁴sagh⁵i³ i¹jan³ liah⁴ a⁴leg³⁴; i² hei⁴i³ tionh² ne⁵, conh⁴a² sa⁴ma²a⁴júan⁴ Jesús heih⁴³ i²con²³i³, tsei³⁴sa² a⁴jan³⁴i³ jau²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Quie¹ ta² co³ ŋo³⁴ tsei⁴³i³ tionh², a⁴juah⁴i³: ―Ta² re³ júan³ a³ne³ la⁴jeg³⁴; la⁴teg⁴ a³teun³ júan³i³ i⁴naih¹, jian³ i⁴hleh² a³con². ");
INSERT INTO cucNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jm² jon³ tionh² jeun⁴³ lio⁴mai²³ chie³, jian³ sa⁴quian³i³ i⁴li⁴queuh⁴³i³. I⁴jon³ a⁴teh³ Jesús chie³ quian¹, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ta² jia²³ ñei⁴ tsei³⁴ˉ⁴ i²con²³ chie³ ne³ tionh², quie¹ ma³a⁴teg⁴ hneng³ jm² jie³i³ jnia¹, jian³ sa⁴sia³ i⁴li⁴queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jian³ juah⁴ne³ sainh³²i³ jnia⁴ liah⁴ma³cúanh⁴³i³ tionh², lei⁴ li⁴lei⁴ i⁵neih³i³ ho³²jeu³, quie¹ sian³ ca³chion²³ a³ja²³ i²gm⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","I² jon³ a⁴juah⁴ chie³ quian¹i³: ―¿Jainh¹ li⁴tyieh⁴³ a²hei⁴³ñih¹ i²a⁵sian⁴³ a³sian³ la³ i⁴queuh⁴³ chie³ jeun⁴³ ne³ tionh² liah⁴a² a⁴lag³⁴ tsei⁴³i³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","I² jon³ a⁴ŋang⁴ Jesús i²con²³ chie³ quian¹: ―¿Jah⁴ a²hei⁴³ñih¹ quianh²ˉ³ tionh²ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―Quie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³ chie³ jeun⁴³ hain⁴ i⁴cua³⁴i³ húa³⁴; i² con³ma²a⁴tang⁴ Jesús li⁵quie³⁴ a²hei⁴³ñih¹ jon³, jian³ a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, jon³ a⁴jeun³⁴i³. I² jon³ a⁴cúah³i³ chie³ quian¹ canh⁴a² tyieh⁵i³, jon³ a⁴tyieh⁵i³ i²con²³ a³jeun⁴³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jian³ jian³i³ co⁴meih³ jon⁴³júa³² peih¹ liah⁴; i² con³ma²ma⁴cúanh¹ Jesús, jon³ a⁴júan⁴i³ heih⁴³ i⁴tyieh⁵ chie³ quian¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","I² jon³ a⁴queuh³i³, jian³ a⁴lag³⁴ tsei⁴³i³ tionh². Ma²jon³ a⁴jaih³i³ o¹leuh² i⁴a⁴sion³⁴, jon³ a⁴canh³ quie³⁴ a²mh³ta²³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jian³ la⁴jang³⁴ a³a⁴queuh³ hain⁴ tain⁴³ conh⁴ quin⁴ mai²³ chie³. Ma²jon³ a²ma⁴ a⁴sainh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","I² jon³ a⁴hei³⁴ Jesús joh⁴³ a²úan⁴³ jian²³i³ chie³ quian¹, ŋo³⁴i³ ta⁵i²sain³ Dalmanuta. ");
INSERT INTO cucNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jon³ a⁴tyie³⁴ chie³ fariseo, a⁴jang²³i³ jian²³i³ Jesús, a⁴m⁴i³ i⁴júan³⁴i³ con³ ua³júah² jia²³ ñi⁴jeu⁵ i⁴con⁴³i³ jau²chie⁴³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jon³ a⁴sionh³ Jesús tsei⁴³ nei² quieh¹ a³hain⁴ tionh², a⁴juah⁴i³: ―¿E⁴le³⁴ a³sian³ tieh²la³ m²³ i⁴lei⁴ ua³júah²? Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i¹con³ ua³júah² a⁵sie⁴³ ma⁵li⁴lei⁴ i²conh²ˉ³ a³sian³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jon³ a⁴tai³⁴ Jesús quieh¹i³ tionh², a⁴hei³⁴i³ joh⁴³ a²úan⁴³ liah⁴ i⁴seg³⁴, ŋo³⁴i³ ta⁵hŋoh³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","I² jon³ ne⁵, ua⁵conh⁴ tsei⁴³i³ i⁴ma²can³⁴i³ a²hei⁴³ñih¹ tionh² joh⁴³ a²úan⁴³, con³ tan²pa² quian³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","I² jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³, juah⁴i³: ―Jeh³², jianh³ˉ³ júan² hnei³ o¹sieh³² hei⁴³ñih¹ tionh²ˉ³ quieh¹ fariseo jian³ Herodes tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jon³ a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―Si²hleh²i³ jau²³ ne³ quie¹ sa⁴le²ˉ¹ a²hei⁴³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Quie¹ ñi³ Jesús co³hei²tsei³ i⁴ti²júan³i³, jon³ a⁴juah⁴i³: ―¿O⁴ ti²júanh⁴ˉ³ húanh⁴ˉ³ tionh²ˉ³ nei² quieh¹ i⁴a⁴juah³ˉ⁴ i⁴sa⁴quianh²ˉ³ a²hei⁴³ñih¹? ¿O⁴ i¹ sa⁴ra⁵ŋangh⁴ˉ³ tionh²ˉ³ jian³ a⁵ga⁴ a⁴quienh³ tyih³ˉ³? ¿O⁴ li⁴huah³ pi¹ m⁴tyi⁴ quianh³ˉ³ tionh²ˉ³, heh⁵ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Quie¹ jeh⁴ˉ³, jian³ la⁴con³ sa⁴jeh⁴pa² hnei³ leg⁴³, quie¹ nauh³ˉ³, jian³ sa⁴li⁴ŋangh⁴ˉ³. ¿O⁴ sa⁴tyon²³ hoh⁴³ˉ³ o³tan²? ");
INSERT INTO cucNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Con³ma²a⁴tyieh⁵ˉ⁵ li⁵hña⁴ a²hei⁴³ñih¹ jon³ i²con²³ hña⁴ mai²³ chie³, ¿jah⁴ a²mh³ta²³ a⁴canh³ o¹leuh² i⁴a⁴jaih¹ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―Quia⁵teun⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―I² con³ma²a⁴tyieh⁵ˉ⁵ li⁵quie³⁴ a²hei⁴³ñih¹ i²con²³ quin⁴ mai²³ chie³, ¿jah⁴ a²mh³ta²³ a⁴canh³ o¹leuh² i⁴a⁴jaih¹ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―Quie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jon³ a⁴juah⁴ Jesús: ―¿Liah⁴ cúan²³ sa⁴li⁴ŋangh⁴ pi¹ hnei³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jon³ a⁴tyie³⁴i³ jeu³ Betsaida; i² jon³ jian³i³ jan³ a³taun³² i²con²³ Jesús, jian³ a⁴mh³i³ i⁴tei³⁴i³ si¹cúa³ he³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I² jon³ a⁴tang⁴ Jesús si¹cúa³ a³taun³², te¹i³ ta⁵co⁴³ je¹jeu³ peih¹ jon³. Ma²jon³ a⁴hñei³⁴i³ jm³teuh¹ m⁴nei²i³, jian³ a⁴tei³⁴i³ si¹cúa³, i² jon³ a⁴ŋang⁴i³ i²con²³i³ o⁴ ma³je²³i³ meih³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","I² a³hain⁴, con³ma²a⁴je³⁴i³, jon³ a⁴juah⁴i³: ―Jen³²ˉ⁴ chie³ a³ti²ŋeng²³ a³jnia⁴ liah⁴i² jnia⁴ a²hma³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I² jon³ a⁴tei³⁴ Jesús si¹cúa³ m⁴nei² a³hain⁴ liah⁴ i⁴seg³⁴, jon³ a⁴je³⁴ a³hain⁴ tia⁴, a⁴huan⁴ quieh¹i³. Jon³ a²ma⁴ a⁴je³⁴i³ i²gm⁴ jian³ a⁴jen³i³ re³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","I² jon³ a⁴sainh³i³ a³hain⁴ jauh³² quieh¹i³, a⁴juah⁴i³: ―Sa⁴hniah³ cúah²ˉ³ jeu³ peih¹ ne³ tieh²la³, jian³ i¹jan³ sa⁴hniah³ jeuh³²ˉ³ liah⁴ a⁴leg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","I² jon³ ŋo³⁴ Jesús jian²³ chie³ quian¹ jeu³ peih¹ i²tei⁴³ Cesarea quieh¹ Filipo. I² con³ma²tionh²i³ jeu³, jon³ a⁴ŋangh³i³ chie³ quian¹, a⁴juah⁴i³: ―¿Hain³ jnia⁴ juah⁴ chie³ tionh²? ");
INSERT INTO cucNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jon³ a⁴juah⁴i³ tionh²: ―Ca³chion²³ juah⁴ i⁴langh⁴³ hnei³ Juan³ Tei³², jian³ ca³chion²³ juah⁴ i⁴langh⁴³ˉ³ I³lie²³, jian³ i²ca³chion²³ juah⁴ i⁴langh⁴³ˉ³ jan³ a³sain² quian¹ Jon⁴dai¹ a³ma²sian³ ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","I² jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―I² hnei³ tionh²ˉ³ ne⁵, ¿hain³ jnia⁴ juah⁴ˉ³ tionh²ˉ³? I² jon³ a⁴ŋangh³ Pe³², a⁴juah⁴i³: ―Hnei³ langh⁴³ A³ma²ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","I² Jesús ne⁵, jon³ a⁴júan⁴i³ heih⁴³ i²con²³i³ tionh² i⁴sa⁴sagh⁵i³ i¹jan³ nei² ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jon³ ma⁴lie⁵ Jesús hleh² i²con²³ chie³ quian¹ i⁴hniah³ can³⁴ A³a⁴lang³⁴ Chie³ hain⁴ hlion⁴ ma²eu⁴³, jian³ i⁴ton³⁴ a³don⁵ ma⁴³teg²³ quieh¹i³, jian³ m³chie³ tyein² tionh², jian³ a²teg²³ quian¹ lai²³; jian³ hniah³ jaun⁴i³ jian³ hyon⁴³i³ tei⁴³i² ma³a⁴teg⁴ hneng³ jm². ");
INSERT INTO cucNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A⁴sagh⁴³i³ chie³ quian¹ jau²³ ne³ ra³jia⁵. Jon³ a⁴te¹ Pe³² quieh¹i³ ta⁵co⁴³ meih³, i² jon³ a⁴sagh⁴³i³ Jesús, ta² sa⁴cúan²³ li⁴lei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","I² Jesús ne⁵, jon³ ua⁵lang⁴i³, a⁴jen³i³ chie³ quian¹, jon³ a⁴jain³⁴i³ Pe³², a⁴juah⁴i³: ―¡Quein⁴³ hnei³ i²gm⁴ i²con²³ˉ⁵, hnei³ a⁵lainh³²! Quie¹ a⁵sia³ co³hei²tsei³ quieh¹ Jon⁴dai¹ júanh³ˉ³, co³hei²tsei³ quieh¹ chie³pa². ");
INSERT INTO cucNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jon³ a⁴teh³i³ chie³ quian¹ jian²³ la⁴jang³⁴ a³sang²³, a⁴juah⁴i³: ―Juah⁴ne³ sian³ a³hnie³⁴ si⁴tyein⁵ coh⁵cah³ˉ⁴, hniah³ ma⁵hain³i³ tsei⁴³ i²con²³ hña³, jian³ hniah³ can³⁴i³ ma²eu⁴³ jian³ jia²³i³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Quie¹ la⁴jang³⁴ a³hnie³⁴ lion⁴ m⁵cu³ quieh¹, si⁵hain⁴i³, jian³ la⁴jang³⁴ a³si³hain⁴ m⁵cu³ quieh¹ nei² quien⁴ˉ⁴ jian³ nei² quieh¹ jau²³ quien⁴ˉ⁴, hyieh⁴i³ m⁵cu³ quieh¹ i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Quie¹ ¿henh⁴ ta¹ tei⁴³ i²con²³ jan³ chie³ juah⁴ne³ laih⁴i³ la⁴tan² m⁵cu³ la³, jian³ si⁵hain⁴ m⁴tyi⁴ quieh¹i³ i²a⁴toh⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿I² henh⁴ li⁴hmah² quieh¹ m⁴tyi⁴ quieh¹i³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Quie¹ a³hain⁴ a³hyeih¹ nei² quien⁴ˉ⁴ jian³ nei² quieh¹ jau²³ quien⁴ˉ⁴ ta⁵nei² chie³ a³ma³a⁴ton³⁴ Jon⁴dai¹ jian³ a³ti²ren³ chie³², jon³ hyeih¹ A³a⁴lang³⁴ Chie³ hain⁴ jen⁴³i³ a³hain⁴ tionh² liah⁴, la⁴teg⁴i² jionh⁴i³ jian²³i³ ángel quian¹, i⁴quian³i³ joh¹ quieh¹ Jmai³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Conh⁴liah⁴ a⁴juah⁴ Jesús i²con²³i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, ca³chion²³ hnei³ a³tionh² i²la³ jeh²ˉ³, naih⁵i² jaunh⁴ˉ³, i⁴ua²júan³ Jon⁴dai¹ heih⁴³ nei² m⁵cu³ la³ jian³ quian³i³ hlion⁴ ua³pei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","I² con³ma²ua⁴jeu³² jñei⁴ jm² jon³, jon³ ŋo³⁴ Jesús con³ nei² mah⁴ ñei⁴³, jian³i³ Pe³², Jacobo jian³ Juan²³; i² jon³ a⁴sang²³i³ ta⁵nei² a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ra⁵joh¹ a²cúan³i³, ra⁵tie³ liah⁴i² tie³ o¹húan³, i¹jan³ a³sian³ m⁵cu³ la³ sa⁴tieh¹ júan³⁴ i⁴tie³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jon³ ma⁴jnia³² I³lie²³ jian²³ M³se²³ i²con²³i³ tionh², a³ti²tya²³ jau²³ jian²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","I² jon³ a⁴juah⁴ Pe³² i²con²³ Jesús: ―Hnei³ A²teg²³, ¡ta² re³ quie¹ tieh²ˉ¹ i²la³! Ua²júan³² jnie³² hneng³ cuah²hnei⁴³ peih¹: con³ quianh³ˉ³, con³ quieh¹ M³se²³, jian³ con³ quieh¹ I³lie²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","I¹ sa⁴ñi³ Pe³² henh⁴ hleh²i³, quie¹ eu⁴³ yi⁴hang³²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jon³ ja³⁴ con³ o¹jnai⁴³ a⁴quionh³i³ tionh², jian³ je¹ o¹jnai⁴³ jon³ ja³⁴ con³ jau²³ ho³², i⁴juah⁴i³: ―A³ne³pa² A³jon³⁴ˉ⁴ a³hno⁵ˉ⁵; nai³ hnei³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I² con³ma²a⁴sieh³i³ nei², jon³ a⁵sion⁴³ a³ma⁵a³jen³i³, hña³pa² Jesús júah³ si²sainh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","I² con³ ma²ti²jyon²³i³ mah⁴ tionh², jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³ i⁴sa⁴sagh⁵i³ i¹jan³ i⁴a⁴je³⁴i³, quie¹ la⁴teg⁴ i²hyon⁴³ A³a⁴lang³⁴ Chie³ hain⁴ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jon³ a⁴hma⁴i³ jau²³ jon³ jen²i³ tionh², jian³ a⁴júanh⁴i³ húan⁴i³ tionh² henh⁴ hnie³⁴ ra³juah⁴ i⁴hyon⁴³ chie³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","I² jon³ a⁴ŋang⁴i³ i²con²³ Jesús, a⁴juah⁴i³: ―I² jon³ ne⁵, ¿e⁴le³⁴ juah⁴ a²teg²³ quian¹ lai²³ i⁴hniah³ jia²³ I³lie²³ ñeih³²jia⁴³? ");
INSERT INTO cucNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I² jon³ a⁴ŋangh³ Jesús i²con²³i³, juah⁴i³: ―I⁴chie⁴³pa² jia²³ I³lie²³ ñeih³²jia⁴³ i⁴ya⁴júanh¹i³ la⁴jeg³⁴. I² ne³ ne⁵, ¿liah⁴ cúan²³ ra³sag² nei² quieh¹ A³a⁴lang³⁴ Chie³ hain⁴ i⁴hniah³ can³⁴ hlion⁴ ma²eu⁴³ jian³ sa⁴ro⁵ chie³ jeu³ quieh¹i³? ");
INSERT INTO cucNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jian³ jeu³⁴ˉ⁴ hnei³ liah⁴ i⁴ma³cuan²³pa² I³lie²³, jian³ a⁴júan⁴i³ i²con²³i³ la⁴conh⁴ i⁴m²³ tsei⁴³i³ tionh², liah⁴i² ra³sag² nei² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","I² con³ma²a⁴tyanh³i³ i²tionh² chie³ quian¹, jon³ a⁴jen³i³ jeun⁴³ chie³ a³tionh² hlonh²i³ tionh², jian³ a⁴jen³i³ a²teg²³ quian¹ lai²³ a³ti²jang²³ jian²³ chie³ quian¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","I² liah⁴ma²jon³ con³ma²a⁴je³ la⁴jang³⁴ chie³ hain⁴ quieh¹i³, jon³ ta² co³ a⁴jainh⁴³i³, jian³ ua⁵han²i³ jeu³ra³tyi⁴ i²con²³i³, a⁴ma⁴con⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿Henh⁴ ti²jangh²ˉ³ jianh²ˉ³ chie³ quian³⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jon³ a⁴ŋangh³ jan³ a³hein² jen² chie³ a³jeun⁴³ hain⁴, a⁴juah⁴i³: ―Hnei³ A²teg²³, ma³ni²jan⁴³ˉ⁴ a³jon³⁴ i²conh²ˉ³ a³quian³ m⁴tyi⁴ hlagh³² i⁴júan³ i⁴con²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jian³ jainh¹ i²sonh³i³ quieh¹i³ i²jon³ ton²³i³ húa³⁴, jian³ húah²i³ o¹jan³, queuh³i³ m⁴jan² liah⁴, jian³ ma³si³tianh⁵ he³²i³. A⁴mh⁵ˉ⁵ chie³ quianh³ˉ³ i⁴ma²tyi⁴³i³ m⁴tyi⁴ hlagh³²; a⁵sia³ a⁴cagh¹i³ jm². ");
INSERT INTO cucNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jon³ a⁴ŋangh³ Jesús, a⁴sagh⁴³i³ a³hain⁴ tionh²: ―¡Hnei³ a³sa⁴hain⁴ tionh²! ¿Hain³ la⁴conh⁴a² sa⁴hniah³ tie³²ˉ⁴ jian²³ˉ⁵ hnei³ tionh²ˉ³, liah²? ¿Jian³ hain³ la⁴conh⁴a² sa⁴hniah³ cúah²ˉ⁵ tsei³⁴ i²conh²ˉ³ tionh²ˉ³? Jian⁴³ hnei³ yein³ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jon³ ni²jan³i³ i²con²³i³, i² con³ma²a⁴je³ m⁴tyi⁴ hlagh³² quieh¹ Jesús, jon³ a⁴júan⁴i³ i⁴a⁴hma³⁴ yein³, a⁴quionh³i³ húa³⁴ jian³ pa⁴langh³i³, jian³ a⁴húah³i³ o¹jan³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","I² jon³ a⁴ŋang⁴ Jesús i²con²³ jmai³ a³maih² hain⁴: ―¿Ma³legh⁴ lang⁴³i³ chie² ne³? Jon³ a⁴juah⁴ a³hain⁴: ―Liah⁴ma²peih¹pa² lang⁴³i³; ");
INSERT INTO cucNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","jian³ hlion⁴ nie⁴³ júan³ m⁴tyi⁴ hlagh³² i⁴cangh³i³ je¹ o¹jyi³ loh⁴³ jian³ joh⁴³ jm³, hnie³⁴i³ jŋangh³ yein³. I² juah⁴ne³ li⁴cangh³²ˉ³ jm² i²con²³i³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnie³², ma⁴ho³² hnei³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","I² a⁴juah⁴ Jesús: ―Quie¹ juah⁴ne³ hainh⁴ hnei³, quie¹ la⁴jeg³⁴pa² li⁴lei⁴ i²con²³ a³hain⁴ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Liah⁴ma²jon³ a⁴hleh⁴ jmai³ a³maih² tia⁴, a⁴juah⁴i³: ―¡Hain⁴ jnia⁴! ¡Ma⁴ho³² hnei³ jnia⁴ i⁴li⁴hain⁴ˉ⁴ o³re³! ");
INSERT INTO cucNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","I² con³ma²a⁴je³⁴ Jesús i⁴a⁴ŋangh³ chie³ a³jeun⁴³ hain⁴, jon³ a⁴jain³⁴i³ m⁴tyi⁴ hlagh³², a⁴juah⁴i³: ―Hnei³ m⁴tyi⁴ hlagh³² a³júan³ i⁴con²i³ jian³ i⁴teun³i³, júan³⁴ˉ⁴ heih⁴³ i²conh²ˉ³ i⁴jauh²ˉ³ i²con²³ yein³, jian³ i⁴so⁵heuh¹ˉ³ o³tan² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I² jon³ a⁴hoh⁵ m⁴tyi⁴ hlagh³² tia⁴ jian³ a⁴júan⁴i³ i⁴a⁴hma³⁴ yein³, jon³ ua⁵hag⁴³; i² a³maih² hain⁴ ra³quian³ tai³² la⁴jan³ a³jaun², i⁴jon³ a⁴juah⁴ jeun⁴³ i⁴ma³ra³jaun². ");
INSERT INTO cucNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","I² Jesús ne⁵, jon³ a⁴tang⁴i³ si¹cúa³ yein³, a⁴sion⁴³i³; jon³ a⁴no³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","I² con³ma²a⁴hei³⁴ Jesús jauh³², jon³ a⁴ŋang⁴ chie³ quian¹i³ jeu³ ta⁵co⁴³, a⁴juah⁴i³: ―¿E⁴le³⁴ sa⁴a⁴cangh³² jnie³² jm² ma²tyi² jnie³² m⁴tyi⁴ hlagh³² jon³? ");
INSERT INTO cucNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Quie¹ m⁴tyi⁴ hlagh³² la⁴jon³ sa⁴li⁴ua⁵hag⁴³ a¹juah⁴ne³ sa⁴mh²i³ Jon⁴dai¹ jian³ i⁴júan³i³ he² i⁴sa⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","I² con³ma²a⁴húan³i³ i²jon³, jon³ a⁴ŋeng⁴i³ ta⁵húa³⁴ Galilea tionh². I² sa⁴hnie³⁴ Jesús juah⁴ i⁴li⁴ñi³ chie³, ");
INSERT INTO cucNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","quie¹ a⁴heh³i³ chie³ quian¹, juah⁴i³: ―Cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ chie³ tionh², i² jon³ jŋangh³i³; i² tei⁴³i² ma³jaun²i³, jon³ hyon⁴³i³ tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","I² hei⁴i³ tionh², sa⁴ra⁵ŋang⁴i³ jau²³ jon³, jian³ ra⁵coh⁴³i³ ŋang³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jon³ a⁴tyie³⁴ Jesús je¹jeu³ Capernaum; i² con³ma²cua⁴³i³ jauh³², jon³ a⁴ŋang⁴i³ i²con²³ chie³ quian¹, a⁴juah⁴i³: ―¿Henh⁴ jau²³ ma²ti²jangh²ˉ³ ho³²jeu³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","I² hei⁴i³ tionh² i¹con³ sa⁴ŋang³i³, quie¹ a⁴jang²³i³ ho³²jeu³ nei² quieh¹ hain³ a³tyein². ");
INSERT INTO cucNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jon³ a⁴cua⁴ Jesús, a⁴teh³i³ quia⁵teun⁴ chie³ quian¹, a⁴juah⁴i³: ―A³hain⁴ a³hnie³⁴ lain⁴ a³tyein², hniah³ chie³⁴i³ ta³ra³pei¹ la⁴conh⁴a² la⁴jang³⁴, jian³ hniah³ cúa³⁴i³ cúa³tag³² i²con²³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jon³ a⁴tang⁴ Jesús jan³ yein³, a⁴sainh⁴i³ jen²i³ tionh²; i² con³ma²a⁴sanh³i³ yein³, jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ");
INSERT INTO cucNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―A³hain⁴ a³hyein⁴³ jan³ a³peih¹ a³la⁴la³ nei² quien⁴ˉ⁴, jnia⁴pa² hyei⁴³i³; jian³ a³hain⁴ a³hyei⁴³ jnia⁴, a⁵hei⁴³ jan³ jnia⁴ hyei⁴³i³, quie¹ hyein⁴³ a³a⁴sai⁴ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","I² jon³ a⁴juah⁴ Juan²³: ―Hnei³ A²teg²³, a⁴nia³² jnie³² jan³ chie³ a³ma²si²húa³ m⁴tyi⁴ hlagh³² con⁴juah⁴ jm³i⁴sainh³ˉ³; i⁴jon³ a⁴saih³²i³ jnie³² i⁴so⁵júan³⁴i³ la⁴jon³, quie¹ sa⁴ŋeng²³i³ jie³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","I² a⁴juah⁴ Jesús: ―Sa⁴hniah²ˉ³ juah⁴ i⁴sa⁴júan³⁴i³; quie¹ i¹jan³ a³júan³ ua³júah² con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴, sa⁴li⁴hleh³i³ jau²hlagh³² nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Quie¹ a³hain⁴ a³sa⁴hieh¹ i⁴júan³ˉ¹, a³hain⁴pa² jie³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jian³ la⁴jang³⁴ a³cúa²³ con³ a²va²so³ o¹jm³cuh⁵ i²conh²ˉ³ tionh²ˉ³ nei² quieh¹ jm³i⁴sain³⁴ˉ⁴, nei² quieh¹ i⁴langh⁴³ˉ³ chie³ quian¹ Cristo, i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, hyieh⁴i³ hmah¹ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Jian³ la⁴jang³⁴ a³júan³⁴ i⁴tianh⁵ jan³ si³peih¹ la³ chie³² a³ti²hain⁴ i²con²³ˉ⁵, eu⁴³a² re³ ma²hñei³⁴i³ lau² con³ a²hnai³² ya¹hñei⁴³ con³ a²caun² pa¹, jon³ si⁵tiah³i³ teg⁴ joh⁴³ jm³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jian³ juah⁴ne³ júan³⁴ si¹cúah³ˉ³ i⁴tianh⁵ˉ³ chie³², queih¹ hnei³; quie¹ eu⁴³ re³ quianh³ˉ³ i⁴hyeih²ˉ³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ i⁴langh⁴³ˉ³ a³leun²³, la⁴conh⁴a² cúah²ˉ³ qui⁴jeu⁵, je¹ o¹jyi³ loh⁴³ sa⁴ton³ jm² ua²a⁴au³, i⁴ni²hyan³² si¹cúah³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","I²jon³ sa⁴tyan³ a¹jah³² quian¹i³ jian³ sa⁴ai²³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jian³ juah⁴ne³ júan³⁴ si¹tagh¹ˉ³ i⁴tianh⁵ˉ³ chie³², queih¹ hnei³; quie¹ eu⁴³ re³ quianh³ˉ³ i⁴hyeih²ˉ³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ i⁴langh⁴³ˉ³ a³tein⁴, la⁴conh⁴a² i⁴si⁵hainh⁴ˉ³ qui⁴jeu⁵ je¹ o¹jyi³ loh⁴³ i⁴sa⁴ton³ jm² ua²a⁴au³, i⁴ni²hyan³² si¹tagh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","I²jon³ sa⁴tyan³ a¹jah³² quian¹i³ jian³ sa⁴ai²³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Conh⁴liah⁴ co⁴jon³ juah⁴ne³ júan³⁴ m⁴mah²ˉ³ i⁴tianh⁵ˉ³ chie³², tyi² hnei³; quie¹ eu⁴³ re³ quianh³ˉ³ i⁴cúah²ˉ³ i²ua²júan³ Jon⁴dai¹ heih⁴³ i⁴co³jo³² m⁴mah²ˉ³, la⁴conh⁴a² i⁴si⁵hainh⁴ˉ³ qui⁴jeu⁵, i⁴ni²hyan³² m⁴mah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","I²jon³ sa⁴tyan³ a¹jah³² quian¹i³ jian³ sa⁴ai²³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Quie¹ la⁴jang³⁴ hniah³ can³⁴ ma²eu⁴³ la⁴con³ i⁴con⁵i³ o¹jyi³ loh⁴³, jian³ i⁴sian³i³ jau²chie⁴³ la⁴con³ i⁴jang³i³ jah⁴ i²con²³ Jon⁴dai¹ i⁴sie³i³ o¹ñi². ");
INSERT INTO cucNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Quie¹ i⁴chie⁴³pa² i⁴tsei³⁴ o¹ñi². I² juah⁴ne³ a⁴chia³⁴ ua³pei⁴ quieh¹ ne⁵, ¿hain³liah⁴a² ma⁵li⁴ñih¹? Júan² hnei³ i⁴ma²teih³²ˉ³ tionh²ˉ³ jian³ i⁴tionh²ˉ³ tai³² i²con²³ a³jan³ a³jan³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jon³ ua⁵hag⁴³ Jesús i²jon³, ŋo³⁴i³ i²tei⁴³ Judea jian³ jo³² ta⁵hŋoh³ jm³ Jordán. I² jon³ a⁴ŋangh³ jeun⁴³ chie³ hlonh²i³ liah⁴ i⁴seg³⁴, jian³ a⁴he⁴ Jesús quieh¹i³ liah⁴ i⁴seg³⁴ liah⁴i² ma³júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","I² jon³ a⁴tyie³⁴ fariseo hlonh²i³ tionh² a³a⁴ŋang⁴ i⁴con²³i³ jau²chie⁴³ i²con²³i³, o⁴ ra³cúa²³ i⁴li⁴tyon⁴ a³ñih³ jian²³ a³m⁴ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―¿Liah⁴ heih⁴³ a⁴júan⁴ M³se²³ nei² ne³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jon³ a⁴juah⁴ a³hain⁴ tionh²: ―A⁴cúa⁴ M³se²³ jeu³ i⁴cúah³i³ a³m⁴ con³ ma²jyi³ i⁴ra³juah⁴ i⁴ma³a⁴tyon⁴i³, i² jon³ ton²³i³ a³m⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","I² jon³ a⁴juah⁴ Jesús: ―A⁴sag⁴i³ heih⁴³ la⁴ne³ i²conh²ˉ³ quie¹ i⁴eu⁴³ huah³ m⁴tyi⁴ quianh³pa² hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","I² liah⁴ma²ra⁴lie⁵ m⁵cu³ ne⁵, “a⁴júan⁴³ Jon⁴dai¹ a³ñih³ jian³ a³m⁴”. ");
INSERT INTO cucNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“I⁴jon³da³ quein²³ a³ñih³ i²con²³ jmai³sie²³ i⁴cua²³i³ jian²³ a³m⁴ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jon³ lain⁴ li⁵uan⁴i³ la⁴jon³ jan³ chie³.” I² la⁴ne³ a⁵sie⁴³ ma⁵lang⁴³i³ on³⁴, quie¹ lang⁴³i³ jan³pa² júah³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Quie¹ la⁴conh⁴ i⁴a⁴júan⁴ Jon⁴dai¹ i⁴a⁴sanh⁴i³, i¹jan³ chie³ sa⁴li⁴tyon³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","I² con³ma²tionh²i³ jauh³², jon³ a⁴ŋang⁴ chie³ quian¹i³ tionh² liah⁴ i⁴seg³⁴ nei² ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―La⁴jang³⁴ a³tyon⁴ jian²³ a³m⁴ quian¹ jian³ sanh⁴i³ jian²³i³ a³m⁴ sang³⁴, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ i³cúa³ chie³; ");
INSERT INTO cucNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","jian³ juah⁴ne³ tyon⁴ a³m⁴ jian²³ a³ñih³ quian¹ jian³ sanh⁴i³ jian²³ a³ñih³ sang²³, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ i³cúa³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","I² jon³ jian³i³ si³maih² peih¹ ta⁵nei² Jesús, canh⁴a² tei³⁴i³ si¹cúa³ i²con²³i³; i² chie³ quian¹ Jesús ne⁵, a⁴jain³⁴i³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","I² con³ma²a⁴je³⁴ Jesús i⁴júan³ chie³ quian¹i³ la⁴jon³, a⁴jain²³ tsei⁴³i³, jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―Cúa² hnei³ jeu³ i⁴ya⁴han² si³maih² peih¹ hlonh²ˉ⁵, a⁵hnia³ hnei³; quie¹ a³la⁴ne³ tionh² han⁵ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, a³hain⁴ a³sa⁴hyei³ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹ liah⁴i² hyei³ jan³ yein³, sa⁴li⁴si⁵hei⁴i³ naih⁵ heih⁴³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","I² con³ma²a⁴sanh³i³ si³yein³, jon³ a⁴tei³⁴i³ si¹cúa³, ma⁴cúanh¹i³ si³maih² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","I² con³ma²a⁴hei³⁴ Jesús jeu³ liah⁴ i⁴chie³⁴i³, jon³ a⁴tyie³⁴ jan³ jeu³ra³tyi⁴, a⁴si⁴jnei⁵i³ ta⁵nei²i³, a⁴ŋang⁴i³ i²con²³i³, juah⁴i³: ―Hnei³ A²teg²³ tsein²³, ¿henh⁴ hniah³ júan³²ˉ⁴ canh⁴a² li⁴sia³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quien⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿E⁴le³⁴ teh⁵ˉ³ jnia⁴ a³tsein²³? Quie¹ i¹jan³ a³tsein²³ sa⁴sian³, jan³ Jon⁴dai¹pa². ");
INSERT INTO cucNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Quie¹ ñih¹ hnei³ heih⁴³ quieh¹ Jon⁴dai¹ i⁴ra³juah⁴ la⁴la³: “A⁵hlenh⁴³ hnei³ a³sa⁴lang⁴³ i³cúah³ˉ³; a⁵jŋangh⁴³ hnei³ chie³; a⁵júan³ hang³; a⁵hleh³ hnei³ jau²ta³jau²³ nei² quieh¹ i¹jan³; jian³ a⁵qui⁴³ hnei³ i⁴quieh¹ chie³ i⁴ma⁵canh²i³ hnei³; jian³ ma⁵con³² hnei³ naih⁴³sieh³.” ");
INSERT INTO cucNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","I² con³ma²a⁴nau⁴i³, jon³ a⁴juah⁴i³: ―Hnei³ A²teg²³, la⁴jeg³⁴ heih⁴³ ne³ ma³ma⁵tei³²ˉ⁴ liah⁴ma²maih⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","I² jon³ a⁴je³ Jesús quieh¹i³, i⁴hnio³⁴i³, a⁴juah⁴i³: ―Sia³ pi¹ i²con³ i⁴si³hain⁴ quianh³ˉ³: cua³ ua⁴hnang² la⁴jeg³⁴ i⁴sia³ quianh³ˉ³, ma²jon³ cúah³²ˉ³ a³ti⁴ñei³ o¹cau³² jon³, canh⁴a² li⁴sia³ i⁴quein⁴³ hlion⁴ quianh³ˉ³ ñi⁴jeu⁵; ma²jon³ niah²ˉ³ si²tyeinh³²ˉ³ coh⁵cah³ˉ⁴, canh²ˉ³ ma²eu⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","I² hei⁴i³ ne⁵, ta² a⁴tanh⁴³ tsei⁴³i³, con³ma²a⁴nau⁴i³ jau²³ jon³, jon³ ŋah³i³ chionh⁴ tsei⁴³i³, quie¹ eu⁴³ hlion⁴ sia³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","I² jon³ a⁴je³⁴ Jesús co⁴la⁴lagh⁵, a⁴sagh⁴³i³ chie³ quian¹i³ tionh²: ―¡Ta² jeuh⁴³ nie⁴³ i⁴si⁵han² a³sia³ hlion⁴ quieh¹ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹! ");
INSERT INTO cucNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jon³ eu⁴³ co³ ŋo³⁴ tsei⁴³ chie³ quian¹i³ jau²³ jon³; i² Jesús a⁴juah⁴ liah⁴ i⁴seg³⁴: ―Hnei³ jon²³ quian³⁴ˉ⁴, ¡ta² jeuh⁴³ nie⁴³ i⁴si⁵han² a³hain³² tsei⁴³ o¹cau³² hlion⁴ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹! ");
INSERT INTO cucNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Eu⁴³a² sa⁴jeuh⁴³ i⁴si⁵hei⁴ jan³ a²ca³me²llo³ to³ a²ma³cau³² la⁴conh⁴a² i⁴hei⁴ jan³ a³jlanh² naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsei³⁴sa² co³ a⁴jainh⁴³i³ tionh², a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: ―Juah⁴ne³ la⁴ne³, ¿hain³ pi² lei⁴ li⁴lion⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jon³ a⁴je³ Jesús quieh¹i³, a⁴juah⁴i³: ―Quie¹ chie³ tionh² sa⁴tieh¹i³ li⁴júan³⁴i³, Jon⁴dai¹pa² tieh¹; quie¹ la⁴jeg³⁴pa² li⁴júan³⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","I² jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Jeh³², ma³a⁴tien² jnie³² la⁴jeg³⁴, jian³ ma²ya¹han² jnie³² coh⁵cah³²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³ma³a⁴teinh³ tsei⁴³ a²hnei⁴³ quieh¹, jian³ o⁴ si³reunh¹i³ si³ñih³ si³m⁴, o⁴ jmai³i³ o⁴ sie²³i³, jian³ o⁴ a³m⁴ quian¹i³, jian³ o⁴ jon⁴³segh³²i³, jian³ o⁴ húa³⁴ quieh¹i³, la⁴jang³⁴ a³júan³⁴ la⁴ne³ nei² quien⁴ˉ⁴ jian³ nei² quieh¹ jau²³ quien⁴ˉ⁴, ");
INSERT INTO cucNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hyei³⁴i³ nia⁴lo⁴ jeunh³ tieh²la³; hyei³⁴i³ a²hnei⁴³ quieh¹, jian³ hyein⁵i³ si³reunh¹i³ si³ñih³ si³m⁴, sie²³i³, si³jon⁴³i³, jian³ húa³⁴ quieh¹i³, ua²liah⁴a² hag²³ chie³ quieh¹i³; jian³ hyieh⁴i³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ m⁵cu³ con³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","I² jeun⁴³ a³ya¹jian⁴³ nei² tieh²la³ tang³⁴i³ ta³ra³pei¹; jian³ a³tionh² ta³ra³pei¹ tieh²la³ si⁵jian⁴³i³ nei². ");
INSERT INTO cucNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Con³ma²tionh²i³ jeu³ ŋo³⁴i³ Jerusalén, i² Jesús ya¹jian⁴³ nei². I² hei⁴i³ tionh² ya¹han² coh⁵, i⁴co³ a⁴jainh⁴³i³ tionh² jian³ coh⁴³i³. I² jon³ jian³i³ quia⁵teun⁴ chie³ quian¹ hain⁴ con³ ta⁵co⁴³, a⁴sagh⁴³i³ a³hain⁴ tionh² liah⁴ si⁵lei⁴ i²con²³i³ hña³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Jeh³², tieh²la³ tieh²ˉ¹ jeu³ chie²³ˉ¹ Jerusalén, i²jon³ cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³ tionh²; jian³ queih³i³ heih⁴³ i⁴jaun⁴i³. Jian³ cúanh⁴³i³ a³hain⁴ joh⁴³ cúa³ a³sa⁴lang⁴³ judío, ");
INSERT INTO cucNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","i⁴ji⁵ŋang⁴i³, jian³ po³⁴i³, jian³ hñi⁵i³ jm³teuh¹, jian³ jŋangh³i³; i² tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³, jon³ hyon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jon³ a⁴tyie³⁴ Jacobo jian³ Juan²³ i²con²³ Jesús, si³jon⁴³ Zebedeo, a⁴juah⁴i³: ―Hnei³ A²teg²³, hnie³ jnie³² júanh²ˉ³ i⁴m²³ jnie³² i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jon³ a⁴juah⁴ Jesús: ―¿Henh⁴ hnoh³ˉ³ júan³²ˉ⁴ i²conh²ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","I² jon³ a⁴juah⁴i³ tionh²: ―¿Sa¹ cúah²ˉ³ jeu³ i⁴hyie² jnie³² hlonh²ˉ³, jan³ jo³² ta⁵chie³⁴ jian³ jan³ jo³² ta⁵quegh³ quianh³ˉ³, la⁴teg⁴i² ma³ua²júanh³ˉ³ heih⁴³ nei² m⁵cu³ la³, i⁴eu⁴³ júanh⁴³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Ta² sa⁴ñih¹ˉ³ i⁴mh³ˉ³ tionh²ˉ³. ¿O⁴ tianh³²ˉ³ canh²ˉ³ ma²eu⁴³ liah⁴ can¹ˉ⁴, jian³ i⁴júanh¹i³ hnei³ liah⁴i² júanh¹i³ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jon³ a⁴juah⁴i³ tionh²: ―Tian⁴pa². I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² li⁴canh²ˉ³ ma²eu⁴³ liah⁴ can¹ˉ⁴, jian³ li⁴júanh¹i³ hnei³ liah⁴i² júanh¹i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","I² nei² quieh¹ i⁴mh³ˉ³ neih²ˉ³ jo³² ta⁵chie³⁴ jian³ jo³² ta⁵quegh³ quien⁴ˉ⁴ ne⁵, sa⁴tain⁴³ˉ⁴ cúa¹ˉ⁴, quie¹ cua³⁴ a³hain⁴pa² tionh² a³a⁴quianh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","I² con³ma²a⁴nau⁴ i²quian³⁴ chie³ quian¹i³ hain⁴, ta² a⁴jain²³ tsei⁴³i³ i²con²³ Jacobo jian³ Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","I² Jesús ne⁵, a⁴teh³i³ a³hain⁴ tionh², a⁴juah⁴i³: ―Quie¹ ñih¹ˉ³ liah⁴ tionh² la⁴jeg³⁴ nación a³sa⁴lang⁴³ judío, i⁴pain⁴ heih⁴³ júan³ gobierno quian¹i³ tionh², jian³ la⁴jang³⁴ a³ti²quian³ ta¹ liah⁴, queih²i³ heih⁴³ pain⁴ i⁴sa⁴hain²³i³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","I² jenh² hnei³ tionh²ˉ³ ne⁵, sa⁴hniah³ lei⁴ la⁴ne³. Quie¹ a³hain⁴ a³hnie³⁴ li⁴júanh⁴³ jenh²ˉ³ tionh²ˉ³, hniah³ cúa³⁴i³ cúa³tag³² i²conh²ˉ³ tionh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","jian³ a³hain⁴ a³hnie³⁴ lain⁴ a³tyein² jenh²ˉ³, hniah³ júan³⁴i³ i²conh²ˉ³ la⁴jan³ a³júan³ quianh³ˉ³ la⁴jangh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Quie¹ la⁴ne³pa² cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ i⁴cúa³⁴i³ cúa³tag³² i²con²³ chie³, a⁵jon⁴³ ta⁵cúa³⁴ chie³ cúa³tag³² i²con²³i³, jian³ cuan³⁴i³ i⁴cúa³⁴i³ m⁵cu³ quieh¹ i⁴lion⁴ jeun⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","I² jon³ a⁴tyie³⁴i³ Jericó tionh². I² con³ma²ua⁵hag⁴³ Jesús jian²³ chie³ quian¹ Jericó jon³ jian²³ jeun⁴³ chie³ sang²³, i²jon³ ua²cua⁴³ jan³ a³taun³² ho³²jeu³ a³sain³ Bartimeo, a³jon⁴³ Timeo, a³ua²m²³ o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","I² con³ma²a⁴nau⁴i³ i⁴ja³⁴ Jesús a³sian³ Nazaret, jon³ a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―¡Hnei³ Jesús, Sa¹jeun³ Da³vei²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ˉ⁵! ");
INSERT INTO cucNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","I² jon³ ne⁵, jeun⁴³ chie³ a⁴jai³⁴ quieh¹i³ canh⁴a² cua⁴³i³ tai³²; i² hei⁴i³ ne⁵, tsei³⁴sa² tia⁴ a⁴hleh⁴i³, juah⁴i³: ―¡Hnei³ Sa¹jeun³ Da³vei²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ˉ⁵! ");
INSERT INTO cucNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","I² jon³ a⁴jian⁴ Jesús, a⁴juah⁴i³ i⁴teh³i³ a³hain⁴; i² jon³ ua⁵teh³i³ a³taun³², a⁴juah⁴i³: ―Júan² hnei³ si³hyonh³, no³ hnei³, quie¹ te²³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jon³ a⁴ton³⁴i³ a²hmh³ ma²ua²lion³i³, ra⁴hang³²i³ i⁴hang³i³ ta⁵yeih³², ŋo³⁴i³ hlonh² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿Henh⁴ hnoh³ˉ³ júan³²ˉ⁴ i²conh²ˉ³? I² jon³ a⁴juah⁴ a³taun³² hain⁴: ―Hnei³ A²teg²³, hno⁵ˉ⁵ júanh²ˉ³ i⁴jnia⁵ m⁴nei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I² jon³ a⁴juah⁴ Jesús: ―Cua³; ma³a⁴huan⁴ quianh³ˉ³, quie¹ ra⁵hainh⁴ˉ³. Liah⁴ma²jon³ a⁴jnia⁵ m⁴nei²i³, jon³ ŋo³⁴i³ coh⁵cah³² Jesús ho³²jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","I² con³ma²a⁴tyie³⁴i³ tionh² hloh³² jeu³ Betfagé jian³ Betania, mah⁴ quieh¹ a²hma³ Olivos, hloh³² Jerusalén, i² jon³ a⁴sain⁴ Jesús on³⁴ chie³ quian¹, ");
INSERT INTO cucNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a⁴sagh⁴³i³: ―Cua³ jeu³ peih¹ nie⁴³ ta⁵nei² ne³ tionh²ˉ³; i² tei⁴³i² ma³a⁴cúah³ˉ³ i²jno³, jon³ tyanh³²ˉ³ jan³ a²lo¹siah³ a³si²hñih², jian³ i¹jan³ a⁵sian⁴³ ma³ua⁴tsain³². Jon³ sainh³²ˉ³ jian³ teh³²ˉ³ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jian³ juah⁴ne³ sian³ a³ŋang⁴ i²conh²ˉ³: “¿E⁴le³⁴ ti²sainh⁵ˉ³ a²lo¹siah³ ne³?” jon³ jeuh³²i³ hnei³ a³hniah³ quian¹ Se³ño²³pa², ma²jon³ jionh⁴i³ liah⁴ to⁴ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jon³ ua⁵han² chie³ quian¹i³, a⁴jen³i³ a²lo¹siah³ a³si²hñih² jeu³ i²ŋeng²³ chie³ coh⁵hnei³² hloh³² o²hnei³², jon³ a⁴sainh⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","I² a³tionh² i²jon³ a⁴sagh⁴³i³ a³hain⁴: ―¿E⁴le³⁴ ti²sainh⁵ˉ³ a²lo¹siah³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","I² jon³ a⁴juah⁴i³ tionh² liah⁴ jau²³ ma³a⁴juah⁴ Jesús; jon³ a⁴cúa⁴ a³hain⁴ jeu³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","I² jon³ jian³ chie³ quian¹i³ a²lo¹siah³ hain⁴ la⁴teg⁴ i²con²³i³, i² jon³ a⁴ja³⁴i³ a²cúan³ ma³cah³²i³, jon³ ua⁴tsei³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jian³ a⁴ja³⁴ jeun⁴³ a³sang²³ a²cúan³ ho³²jeu³ liah⁴, jian³ ca³chion²³ a⁴queih³ o¹cúah² hma³ i⁴a⁴ja³⁴i³ ho³²jeu³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jian³ jeun⁴³ chie³ ya¹han² ta⁵nei²i³ jian³ coh⁵cah³²i³ a³ti²hleh² tia⁴, juah⁴i³: ―¡Júanh⁴³ Jon⁴dai¹! ¡Ta² tsei³⁴ jm² ren³ a³ja²³ con⁴juah⁴ jm³i⁴sain³ Se³ño²³ Jon⁴dai¹! ");
INSERT INTO cucNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ta² tsei³⁴ jm² ren³ a³han⁵ naih⁵ heih⁴³ hm³⁴ liah⁴i² a⁴júan⁴ re¹ Da³vei²³ heih⁴³, sa¹jeun³ quian⁴ˉ¹! ¡Júanh⁴³ Jon⁴dai¹ a³cua⁴³ ñi⁴jeu⁵! ");
INSERT INTO cucNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jon³ a⁴hei³⁴ Jesús Jerusalén jian³ cuah³júah²; i² con³ma²a⁴je³⁴i³ co⁴la⁴lagh⁵ la⁴jeg³⁴, jon³ ŋo³⁴i³ ta⁵ Betania jian²³i³ quia⁵teun⁴ chie³ quian¹i³ hain⁴, con³ma²a⁴nai³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","I² con³ma²a⁴jnia³⁴, con³ma²a⁴húan³i³ Betania, ta² ra⁵cúanh⁴³ tsei⁴³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jon³ a⁴je³⁴i³ con³ a²hma³ m⁴jyi³ i²gm⁴ meih³ i⁴si²leg⁴³ o¹úan³², i² jon³ ŋo³⁴i³ ua⁵je⁴i³ sa¹ li⁴tyieh⁴³ o¹m⁴ quieh¹; i² con³ma²a⁴tyie³⁴i³ hloh³² ne⁵, i¹con³ o¹m⁴ quieh¹ sa⁴a⁴chieh¹i³, jmah³ o¹úan³²pa² si²leg⁴³, quie¹ sa⁴ma³a⁴teg⁴ jain³ quieh¹ o¹m⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","I² jon³ a⁴juah⁴ Jesús i²con²³ a²hma³ m⁴jyi³ jon³: ―I¹con³ jm² sa⁴jia²³ juah⁴ i⁴sian³ a³queuh⁴³ o¹m⁴ i⁴hag³⁴ hnei³, a²hma³. Jian³ a⁴nau⁴ chie³ quian¹i³ jau²³ jon³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jon³ a⁴tyie³⁴i³ Jerusalén tionh². I² con³ma²a⁴hei³⁴ Jesús cuah³júah², jon³ a⁴húan⁴³i³ a³ti²hnang³ jian³ a³ti²la²³ i²jon³. Jian³ a⁴quegh³i³ a²me²sa³ quieh¹ a³sag²³ o¹cau³² tionh² jian³ a²ma³sei² quieh¹ a³ti²hnang⁴³ a⁵ta³cuah³; ");
INSERT INTO cucNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","jian³ sa⁴cúa²³i³ i⁴ua⁵jeun³² chie³ i⁴quian³ lie²³ cuah³júah². ");
INSERT INTO cucNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jian³ a⁴heh³i³ chie³, a⁴juah⁴i³: ―¿O⁴ a⁵sia³ ra³sag² la⁴la³: “Jauh³² quien⁴ˉ⁴ jauh³² i²mh²i³ Jon⁴dai¹pa² teh²i³ i⁴quieh¹ a³sian³ la⁴jeg³⁴ nación”? I² hnei³ tionh²ˉ³ ne⁵, júanh³ˉ³ jauh³² la³ la⁴con³ to³hlo³ quieh¹ hang³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","I² jon³ a⁴nau⁴ a²teg²³ quian¹ lai²³ jian³ m³chie³ tyein² tionh², jian³ ma²hnoh³i³ tionh² liah⁴ ma²jŋangh³i³, quie¹ ta⁵la⁴ con⁴³i³ Jesús nei² quieh¹ a³jeu³, quie¹ co³ a⁴jainh⁴³ a³jeu³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","I² con³ma²a⁴nai³, jon³ ua⁵hag⁴³ Jesús jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","I² con³ma²a⁴jnia³⁴, jon³ a⁴je³⁴i³ a²hma³ m⁴jyi³ jon³ tionh² i⁴ma³si²quein³ la⁴teg⁴ o¹júan⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","I² jon³ a⁴tyon²³ tsei⁴³ Pe³², a⁴sagh⁴³i³ Jesús: ―Hnei³ A²teg²³, jeh³² ma³ra⁵quein³ a²hma³ m⁴jyi³ ne³ i⁴a⁴jainh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Ua²hainh⁴ hnei³ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Quie¹ i⁴chie⁴³pa² juah³ˉ⁴, a³hain⁴ a³sagh⁵ a²mah⁴ ne³: “Quein⁴³ hnei³ i²gm⁴; cua³ la⁴teg⁴ joh⁴³ jm³ñih¹”, juah⁴ne³ sa⁴júan³⁴i³ teun³⁴ co³hei²tsei³, juah⁴ne³ hain⁴i³ i⁴lei⁴ jau²³ i⁴juah⁴i³, jon³ lei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","I⁴jon³ juah³ˉ⁴, la⁴jeg³⁴ i⁴mh²ˉ³ i²con²³ Jon⁴dai¹ i⁴hainh⁴ˉ³ i⁴hyanh⁴ˉ³, jon³ lei⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jian³ tei⁴³i² mh³²ˉ³ Jon⁴dai¹, hniah³ hainh³²ˉ³ chie³² quieh¹ a³a⁴júan⁴ hlagh³² i²conh²ˉ³, canh⁴a² hain³⁴ Naih⁴³ˉ³ chie³² quianh³ˉ³ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Quie¹ juah⁴ne³ sa⁴hainh⁵ˉ³ chie³² quieh¹ chie³ liah⁴, jon³ sa⁴hain³⁴ Naih⁴³ˉ³ chie³² quianh³ˉ³, a³cua⁴³ ñi⁴jeu⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jon³ a⁴tyie³⁴i³ Jerusalén liah⁴ i⁴seg³⁴ tionh². I² con³ma²ŋeng²³ Jesús cuah³júah², jon³ ua⁵han² m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³ jian³ a³don⁵ ma⁴³teg²³ hlonh²i³, ");
INSERT INTO cucNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","a⁴juah⁴i³ tionh²: ―¿Hain³ heih⁴³ quianh²ˉ³ i⁴júanh³ˉ³ la⁴jeg³⁴ i⁴ne³? ¿Jian³ o⁴ hain³ a⁴cúa⁴ heih⁴³ ne³ i²conh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Hno⁵ jnia⁴ liah⁴ ŋang¹ˉ⁴ con³ i²conh²ˉ³ tionh²ˉ³; i² juah⁴ne³ a⁴jainh¹ˉ³ jau²³ ne⁵, jon³ jeu¹ˉ⁴ hnei³ liah⁴ hain³ heih⁴³ quian³²ˉ⁴ i⁴júan³⁴ˉ⁴ la⁴jeg³⁴ i⁴la³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","I² jon³ ne⁵, ¿hain³ a⁴júan⁴ heih⁴³ i²con²³ Juan²³ i⁴ua⁵sion⁴³ chie³ jm³? ¿O⁴ Jon⁴dai¹ jian³ o⁴ chie³, lainh⁴ˉ³? Ŋangh¹ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jon³ a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: ―Juah⁴ne³ juah²ˉ¹ i⁴ Jon⁴dai¹pa² a⁴júan⁴ heih⁴³ i²con²³i³, jon³ sag⁵i³ jnia¹: “¿E⁴le³⁴ sa⁴ra⁵hainh⁴ˉ³ jau²³ quieh¹i³ ne⁵?” ");
INSERT INTO cucNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jian³ juah⁴ne³ juah²ˉ¹ i⁴a⁴sai⁴ chie³pa² quieh¹i³, sa⁴re³ liah⁴. Quie¹ con⁴³i³ a³jeu³ tionh², quie¹ la⁴jang³⁴pa² ti²ñi³ i⁴ma²lang⁴³ Juan²³ a³sain² quian¹ Jon⁴dai¹ i⁴chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","I² jon³ a⁴jainh³i³ jau²³ i²con²³ Jesús, a⁴juah⁴i³: ―Sa⁴nia² jnie³². I² jon³ a⁴juah⁴ Jesús i²con²³i³ liah⁴: ―Jian³ jnia⁴ liah⁴, a⁵sia³ jeu¹ˉ⁴ hnei³ tionh²ˉ³ hain³ heih⁴³ quian³²ˉ⁴ i⁴júan³⁴ˉ⁴ la⁴jeg³⁴ i⁴la³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jon³ a⁴hleh⁴ Jesús i²con²³i³ tionh² con³ jau²³ i⁴a⁴can³⁴i³, a⁴juah⁴i³: ―Ma²sian³ jan³ chie³ a³jnia² o¹m⁴ ya¹gm³jeh² quieh¹, jian³ a⁴júan⁴i³ con³ a²ha⁴ co⁴la⁴lagh⁵; jian³ a⁴júan⁴i³ con³ i²jianh²i³ o¹m⁴ ya¹gm³jeh², jian³ a⁴júan⁴i³ con³ a²cuah³² ñei⁴³ i²hie³⁴i³ je¹. ’Ma²jon³ a⁴tonh³i³ je¹ jon³ joh⁴³ cúa³ co⁴meih³ a³júan³ ta¹, jon³ ŋo³⁴i³ ta⁵jeu³ gm⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","I² con³ma²a⁴tyie³⁴ jm² a⁴lo³, jon³ a⁴sain⁴i³ jan³ a³cúa²³ cúa³tag³² quian¹ i²con²³ a³júan³ ta¹ je¹ hain⁴ canh⁴a² ma²cúah³i³ co⁴meih³ o¹m⁴ ya¹gm³jeh² jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","I² a³júan³ ta¹ hain⁴ tionh² ne⁵, jon³ a⁴sanh³i³ a³cúa²³ cúa³tag³² hain⁴, a⁴po³⁴i³, jon³ a⁴saih³i³ to⁵lang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Conh⁴liah⁴ a⁴sain⁴ a³quieh¹ je¹ hain⁴ i²jan³ a³cúa²³ cúa³tag³² quian¹; i² a³júan³ ta¹ ne⁵, a⁴quinh⁴³i³ m⁴caun² a³hain⁴, a⁴hnia³⁴i³ ma³tyi²i³, jon³ a⁴saih³i³ con³ma²a⁴júanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Conh⁴liah⁴ a⁴sain⁴i³ i²jan³, i² a³júan³ ta¹ hain⁴, a⁴jŋangh⁴i³ a³hain⁴. Jian³ a⁴sain⁴i³ i²jeun⁴³ a³sang²³ liah⁴; i² a³júan³ ta¹ hain⁴ tionh² ne⁵, a⁴pan³⁴i³ ca³chion²³ jian³ a⁴jŋangh⁴i³ ca³chion²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’I² a⁴toh⁴ ne⁵, ma²sian³ a³jon⁴³ a³quieh¹ je¹ hain⁴, a³hnio⁴i³; i² jon³ a⁴sain⁴i³ a³jon⁴³ i²con²³ a³hain⁴ tionh², juah⁴i³: “Leg⁴³ re³pa² ma⁵con⁴³i³ a³jon³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","I² a³júan³ ta¹ ne⁵, a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: “A³ne³pa² li⁴quieh¹ je¹ la³; ma³²ˉ¹ ma⁵jŋangh¹i³ jnia¹ canh⁴a² li⁴quian⁴ˉ¹ je¹.” ");
INSERT INTO cucNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jon³ a⁴sanh³i³, a⁴jŋangh⁴i³, jon³ a⁴ton³⁴i³ ta⁴coh⁵ je¹ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’I² ne³ ne⁵, ¿henh⁴ júan³⁴ a³quieh¹ je¹ jon³, lainh⁴ˉ³? Jionh⁴i³, ya⁴ma⁴tyan²³i³ a³júan³ ta¹ hain⁴, jon³ tonh³i³ je¹ quieh¹ joh⁴³ cúa³ a³sang²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ i⁴ra³sag² jau²³ la³: A²caun² i⁴a⁴ton³⁴ teg³hyah³ tionh², a²caun² jon³pa² re³ a⁴seih³ ta³jmh¹ a²hnei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A⁴júan⁴ Se³ño²³ i⁴a⁴leg³⁴ la⁴ne³, jian³ ta² co³ a⁴jain⁴³ˉ¹ a⁴niah³²ˉ¹ i⁴jon³? ");
INSERT INTO cucNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","I² jon³ ma²hnoh³i³ hain³liah⁴ li⁴sanh³i³ Jesús, quie¹ ra⁵laih²i³ tionh² i⁴a⁴hleh⁴ Jesús nei² quieh¹i³ jau²³ i⁴a⁴can³⁴i³ jon³. I² con⁴³i³ a³jeu³ ne⁵, jon³ a⁴tain³⁴i³ Jesús, ua⁵han²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","I² jon³ a⁴sain⁴i³ co⁴meih³ chie³ fariseo jian²³ chie³ quian¹ Herodes i²con²³ Jesús canh⁴a² hnoh³i³ liah⁴ li⁴si⁵seun³i³ jau²³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","I² con³ma²a⁴tyie³⁴i³ tionh², jon³ a⁴sagh⁴³i³ Jesús: ―Hnei³ A²teg²³, nia² jnie³² i⁴hleh³ˉ³ jmah³ jau²³ tei⁴³, jian³ a⁵sia³ jm² si²quianh¹ˉ³ liah⁴ lang⁴³ chie³, quie¹ sa⁴roh³ˉ³ jeu³ liah⁴ jnia⁴ chie³ ta⁴coh⁵, quie¹ heh³ˉ³ jeu³ quieh¹ Jon⁴dai¹ con⁴juah⁴ jau²³ ni²tei⁴³. I² ne³ ne⁵, ¿o⁴ ra³cúa²³ i⁴ma²hmah³²ˉ¹ i²tain⁴³ gobierno, jian³ o⁴ a⁵sia³? ¿O⁴ cúa³²ˉ¹, jian³ o⁴ sa⁴cúa³²ˉ¹? ");
INSERT INTO cucNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","I² Jesús ne⁵, si²ñi³i³ re³ i⁴ma³co³i³ tionh² i⁴lonh⁵i³ tionh², jon³ a⁴juah⁴i³ i²con²³i³: ―¿E⁴le³⁴ jau²chie⁴³ conh⁴ˉ³ jnia⁴ tionh²ˉ³? Cua³ ua⁴quian³ hnei³ con³ o¹cau³² tie³, canh⁴a² je¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","I² jon³ ni²quian⁴i³, jon³ a⁴juah⁴ Jesús: ―¿Hain³ ma³nei² ra³ton³ o¹cau³² la³, jian³ hain³ jm³i⁴sain³ ra³sag²? Jon³ a⁴juah⁴i³ tionh²: ―Gobierno César pa². ");
INSERT INTO cucNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","I² jon³ a⁴juah⁴ Jesús: ―Juah⁴ne³ la⁴ne³, cúah³² hnei³ gobierno i²tain⁴³, jian³ cúah³² hnei³ Jon⁴dai¹ i²tain⁴³ liah⁴. Jon³ ta² co³ a⁴jainh⁴³ a³hain⁴ tionh² jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jon³ a⁴tyie³⁴ saduceo tionh² i²con²³ Jesús, a³hain⁴ tionh² a³juah⁴ i⁴sa⁴hyon⁴³ a³jaun²; i² jon³ a⁴ŋang⁴i³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Hnei³ A²teg²³, a⁴sag⁴ M³se²³ la⁴la³: juah⁴ne³ a⁴jaun³⁴ jan³ a³ñih³ a³sa⁴ra⁵sian³ si³jon⁴³ jian²³ i³cúa³, jon³ hniah³ sanh⁴ a³reunh¹ a³jaun² jian²³ a³m⁴ hain⁴, canh⁴a² li⁴sian³ si³jon⁴³i³ nei² quieh¹ a³jaun² reunh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","I² jon³ ne⁵, ma²sian³ quion³⁴ si³reunh¹i³ jmah³ a³ñih³. I² a³co⁴ra⁴lie⁵ hain⁴ a⁴sanh⁴i³ jian²³ a³m⁴, jian³ a⁴jaun³⁴i³ i⁴sa⁴ra⁵sian³ si³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jian³ la⁴jon³ a⁴sanh⁴ a²teg⁴ on³⁴ liah⁴ jian²³ a³m⁴ hain⁴, jon³ a⁴jaun³⁴i³ liah⁴ i⁴sa⁴ra⁵sian³ si³jon⁴³i³; conh⁴liah⁴ la⁴jon³pa² a⁴jainh⁴³ a²teg⁴ on³ hain⁴ liah⁴i² a⁴jainh⁴³ a³ma³jaun². ");
INSERT INTO cucNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jian³ la⁴ne³pa² a⁴jainh⁴³ li⁵quion³⁴, i¹jan³ si³jon⁴³ sa⁴ra⁵sian³. I² con³ma²a⁴chian³⁴ la⁴jang³⁴ a³hain⁴ ne⁵, jon³ jaun² a³m⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","I² jon³ ne⁵, tei⁴³i² hyon⁴³ la⁴jang³⁴ a³jaun², ¿hain³ li⁴quian¹ a³m⁴ hain⁴, quie¹ la⁴jang³⁴ la⁴jon³ pi²³ ra⁵jian²³i³? ");
INSERT INTO cucNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jon³ a⁴ŋangh³ Jesús i²con²³i³, juah⁴i³: ―¿O⁴ sa¹ chie⁴³ húanh⁴pa² hnei³ ma⁵canh²ˉ³ tionh²ˉ³, nei² quieh¹ i⁴sa⁴ŋangh⁴ˉ³ jau²³ quieh¹ Jon⁴dai¹ i⁴ra³sag², a⁵ga⁴ cmh²ˉ³ ua³pei⁴ quieh¹i³? ");
INSERT INTO cucNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quie¹ la⁴teg⁴i² ma³a⁴hyon²³ a³jaun² tionh², a⁵sie⁴³ sanh⁴i³ jian³ a⁵ga⁴ cúan⁵i³ si³jon⁴³ i⁴sanh⁴i³, quie¹ lain⁴i³ liah⁴i² lang⁴³ ángel a³tionh² ñi⁴jeu⁵pa². ");
INSERT INTO cucNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","I² nei² quieh¹ i⁴hyon⁴³ a³jaun² ne⁵, ¿o⁴ a⁵sia³ ma³a⁴heih³ˉ³ ma²jyi³ i⁴a⁴sag⁴ M³se²³ liah⁴ a⁴hleh⁴ Jon⁴dai¹ i²con²³i³ i²ma²si²co²³ con³ sieh³² hma³ ton⁴³ tsain⁴³, a⁴juah⁴i³: “Jnia⁴ lang⁴³ˉ⁴ Jon⁴dai¹ quian¹ A³brang²³, jian³ I³sa²³ jian³ Ja³co²³”? ");
INSERT INTO cucNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Quie¹ a⁵sia³ lang⁴³i³ Jon⁴dai¹ juah⁴ Jon⁴dai¹ quian¹ a³jaun², quie¹ Jon⁴dai¹ quian¹ a³sian³pa²; i² la⁴ne³ jon³ eu⁴³ can³ hoh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jon³ a⁴tyie³⁴ jan³ a²teg²³ quian¹ lai²³ hlonh²i³ a³ma³a⁴nau⁴ jau²³ i⁴a⁴jang²³i³ tionh² jian³ a³ñi³ i⁴a⁴jainh³ Jesús jau²³ re³ i²con²³i³, i² jon³ a⁴ŋang⁴i³ i²con²³ Jesús: ―¿Hain³ heih⁴³ tyein² quein⁴³ la⁴conh⁴a² la⁴jeg³⁴ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","I² jon³ a⁴juah⁴ Jesús: ―Heih⁴³ tyein² quein⁴³ la⁴conh⁴a² la⁴jeg³⁴ leg⁴³ la⁴la³: “Nai³ hnei³ jeu³ Israel tionh²ˉ³, Se³ño²³ Jon⁴dai¹ quian⁴ˉ¹, jan³pa² leg⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jian³ ma⁴hno³² hnei³ Se³ño²³ Jon⁴dai¹ quianh³ i⁴jang³⁴ hoh⁴³ˉ³, i⁴lie²³ m⁴tyi⁴ quianh³ˉ³, jian³ la⁴jeg³⁴ co³hei²tsei³ quianh³ˉ³, jian³ li⁵teun⁴ cúah³tagh¹ˉ³.” I⁴ne³pa² heih⁴³ tyein². ");
INSERT INTO cucNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jian³ a²teg⁴ teun³⁴ heih⁴³ meih³i² sa⁴co³nai² leg⁴³ i⁴ra³juah⁴: “Ma⁴hno³² hnei³ m⁵cu³ reunh³ liah⁴i² hnoh⁴ˉ³ húanh⁴³ˉ³.” A⁵sie⁴³ heih⁴³ seg³⁴ sia³ i⁴tyein² quein⁴³ la⁴conh⁴a² li⁵teun⁴ ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","I² jon³ a⁴juah⁴ a²teg²³ quian¹ lai²³ hain⁴: ―Re³ jau²³ quianh³ˉ³, hnei³ A²teg²³. I⁴chie⁴³ jau²³ ma³ra³juah¹ˉ³ ne³, quie¹ jan³pa² Jon⁴dai¹ leg⁴³, jian³ jan³ hei⁴ pi²³i³ sian³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jian³ i⁴hnio³⁴i³ Jon⁴dai¹ i⁴jang³⁴ tsei⁴³, jian³ la⁴jeg³⁴ co³hei²tsei³ quieh¹, i⁴lie²³ m⁴tyi⁴ quieh¹, jian³ li⁵teun⁴ cúa³tag³², jian³ i⁴hnio³⁴i³ a³m⁵cu³ reunh¹ liah⁴i² hnio³⁴i³ hña³, hlion⁴ quein⁴³ i⁴ne³ la⁴conh⁴a² la⁴jang³⁴ jah⁴ a³jang³i³ i²con²³ Jon⁴dai¹ jian³ la⁴jeg³⁴ i⁴cúa²³i³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","I² Jesús, con³ma²a⁴je³⁴i³ i⁴a⁴ŋangh³ a³hain⁴ con⁴juah⁴ co³hei²tsei³ tsei²³, jon³ a⁴juah⁴i³: ―A⁵sia³ gmh⁴ sainh⁴³ˉ³ i²han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. Jon³ so⁵tia⁴ tsei⁴³ i¹jan³ ŋang³⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","I² con³ma²he²³ Jesús jau²³ cuah³júah², jon³ a⁴juah⁴i³: ―¿Liah⁴ cúan²³ juah⁴ a²teg²³ quian¹ lai²³ tionh² i⁴lang⁴³ A³lion³ Chie³ hain⁴ sa¹jeun³ re¹ Da³vei²³? ");
INSERT INTO cucNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Quie¹ a⁴juah⁴ Da³vei²³ hña³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹: A⁴juah⁴ Se³ño²³ Jon⁴dai¹ i²con²³ Se³ño²³ quian³⁴ˉ⁴: “Nei⁴ hnei³ jo³² ta⁵chie³⁴ quien⁴ˉ⁴ la⁴conh⁴i² júan³²ˉ⁴ i⁴cangh³²ˉ³ jm² i²con²³ la⁴jang³⁴ a³hie²³ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","A⁴juah⁴ Da³vei²³ hña³ i⁴lang⁴³i³ Se³ño²³ quian¹i³. ¿Liah⁴ cúan²³ lang⁴³ A³ma²ya⁴lion³² Chie³ hain⁴ sa¹jeun³ quian¹i³ juah⁴ne³ la⁴ne³? Ta² jeun⁴³ chie³ a⁴nau⁴ jau²³ quieh¹i³ si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jon³ a⁴he⁴ Jesús jau²³ la³, juah⁴i³: ―Jianh³ˉ³ júan² hnei³ tionh²ˉ³ i²con²³ a²teg²³ quian¹ lai²³, quie¹ si³hyonh³i³ ŋeng²³i³ i⁴tionh²i³ a²hmh³ cúa³ la⁴conh⁴a² a³sang²³, jian³ hnie³⁴i³ ma⁵co⁴³ chie³ quieh¹i³ je¹hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jian³ si³hyonh³i³ cua²³i³ hien²³ a³tyein² cuah³ judío, jian³ cua²³i³ queuh³i³ a²hei⁴³ hien²³ a³canh² i²júan³i³ jm². ");
INSERT INTO cucNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jian³ qui²³i³ jauh³² quieh¹ a³don⁵ m⁴ hnang⁴, jian³ júan³i³ i⁴mh²i³ Jon⁴dai¹ i⁴úa⁴ i⁴ma³can³i³ chie³. I⁴jon³ hyieh⁴i³ ma²eu⁴³ pain⁴ la⁴conh⁴a² la⁴jang³⁴ tei⁴³i² gmh⁴ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","I² jon³ ua²cua⁴³ Jesús hloh³² a²cúa⁴³ quieh¹ o¹cau³² i⁴cúa²³ chie³ tionh² cuah³júah², ua²je²³i³ liah⁴ ti²tonh² chie³ o¹cau³² joh⁴³, jian³ jeun⁴³ a³jlanh² ti²ro³ hlion⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","I² jon³ a⁴tyie³⁴ jan³ a³don⁵ m⁴ hnang⁴ a³ti⁴ñei³ a³a⁴tonh³ teun³⁴ a²ñi²yein⁴ i⁴quein⁴³ ca³leuh² peih¹. ");
INSERT INTO cucNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jon³ a⁴teh³i³ chie³ quian¹, a⁴juah⁴i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³m⁴ hnang⁴ a³ti⁴ñei³ ne³, hlion⁴ pi¹ a⁴cúa⁴i³ la⁴conh⁴a² la⁴jang³⁴ a³ma³a⁴ro⁴ joh⁴³ a²cúa⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Quie¹ la⁴jang³⁴ a³hain⁴ tionh² a⁴cúa⁴i³ i⁴ti²sion⁴pa². I² a³m⁴ ne³ ne⁵, ua²liah⁴a² eu⁴³ ti⁴ñei³i³, a⁴cúa⁴i³ la⁴jeg³⁴ la⁴conh⁴ ma²sia³ quieh¹i³ i⁴ma²queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","I² con³ma²ua⁵hag⁴³ Jesús cuah³júah², jon³ a⁴juah⁴ jan³ chie³ quian¹i³: ―Hnei³ A²teg²³, ¡jeh³² ta² tsei³⁴ jnia⁴ a²caun² si²leg⁴³ cuah³ jian³ la⁴jeg³⁴ a²hnei⁴³ quieh¹! ");
INSERT INTO cucNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","I² Jesús ne⁵, a⁴sagh⁴³i³ a³hain⁴, juah⁴i³: ―¿Jeh⁴ˉ³ la⁴jeg³⁴ a²hnei⁴³ cah² ne³, liah²? I¹con³ a²caun² a⁵sie⁴³ ni²tsei¹ nei² a²caun² reunh¹ lei⁴ juah⁴ i⁴sa⁴si⁵cúan⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jon³ a⁴cua⁴ Jesús mah⁴ quieh¹ a²hma³ Olivos i⁴seih⁴³ jon³ ta⁵nei² cuah³júah². I² Pe³², Jacobo, Juan²³ jian³ Dre¹, jon³ a⁴ŋang⁴i³ i²con²³i³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Sai³² hnei³ jnie³² legh⁴ si⁵lei⁴ la⁴jeg³⁴ i⁴ne³. ¿Jian³ henh⁴ júan³⁴ lei³ la⁴teg⁴i² ma³o¹lei⁴ la⁴jeg³⁴ i⁴ne³? ");
INSERT INTO cucNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I² jon³ a⁴ŋangh³ Jesús i²con²³i³ tionh², a⁴juah⁴i³: ―Jianh³ˉ³ júan² hnei³ yo⁴ua²lainh²ˉ³ ca³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Quie¹ jeun⁴³ jia²³ con⁴juah⁴ jm³i⁴sain³⁴ jnia⁴, i⁴juah⁴i³: “Jnia⁴pa² lang⁴³ A³ua⁵lion³² Chie³ hain⁴”; jian³ ma⁵can³i³ jeun⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’I² tei⁴³i² a⁴naih³ˉ³ i⁴ma³si³tang⁴ nación jian³ a⁴naih³ˉ³ jau²³ i⁴sia³ hnai³ ta⁵seg³⁴, a⁵júan³ hnei³ canh⁴³, quie¹ ton³²nie⁴³ hniah³ si⁵lei⁴ i⁴ne³ ñeih³²; i² si³hain⁴ pi¹ i²tieh⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Quie¹ júan³⁴ con³ nación hnai³ i²con²³ nación seg³⁴, jian³ júan³⁴ re¹ hnai³ i²con²³ re¹ sang³⁴ liah⁴; jian³ qui³⁴ húa³⁴ hlion⁴ jeu³. Jian³ jia²³ ho³²cúan⁴, jian³ ra⁵hang³² a³jeu³ ma⁵quein²³ jeu³. La⁴jeg³⁴ i⁴ne³ leg⁴³ ma²eu⁴³ quieh¹ co⁴ra⁴lie⁵ pi¹. ");
INSERT INTO cucNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Jianh³ˉ³ júan² hnei³ tionh²ˉ³; quie¹ cúah⁴³i³ hnei³ joh⁴³ cúa³ si³ta¹, jian³ po³⁴i³ hnei³ cuah³ quieh¹i³ tionh². Jian³ si⁵jo⁴i³ hnei³ ta⁵nei² si²mah⁴ tyein² jian³ re¹ nei² quien⁴ˉ⁴, canh⁴a² li⁴hleh²ˉ³ nei² quien⁴ˉ⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jian³ hniah³ si⁵hleh² jau²³ quien⁴ˉ⁴ i²con²³ a³tionh² la⁴jeg³⁴ nación naih⁵i² tieh⁴ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","I² tei⁴³i² si⁵cúanh³²i³ hnei³ ta⁵nei² si³ta¹, sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ henh⁴ jau²³ jainh²ˉ³ i²con²³i³, a⁵ga⁴ hnoh²ˉ³ jau²³ ñeih³². Quie¹ hniah³ hleh²ˉ³ jau²³ i⁴jia²³ o²ra³ jon³pa², quie¹ a⁵hei⁴³ hnei³ hleh²ˉ³, M⁴tyi⁴ quieh¹ Jon⁴dai¹pa² hleh³ con⁴juah⁴ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Quie¹ cúanh⁴³ chie³ a³reunh¹ i⁴jŋangh³i³, jian³ cúanh⁴³ ca³chion²³ si³jon⁴³; jian³ ca³chion²³ li⁴hion²³ jmai³sie²³i³ i⁴cúanh⁴³i³ i⁴jŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Jian³ la⁴jang³⁴pa² li⁴hie²³ hnei³ tionh²ˉ³ nei² quien⁴ˉ⁴; i² a³hain⁴ a³tieh¹ liah⁴i² a⁴toh⁴, a³ne³pa² lion⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’I² jon³ ne⁵, liah⁴i² a⁴hleh⁴ Da³nie²³, a³sain² quian¹ Jon⁴dai¹ hain⁴ nei² quieh¹ i⁴jon³ i⁴hieh¹ Jon⁴dai¹ jian³ i⁴ma³tya³; la⁴teg⁴i² jeh²ˉ³ i⁴jon³ i⁴seih⁴³ cuah³ hen² ―a³hain⁴ a³heg³ i⁴la³, hniah³ li⁴ŋang⁴i³―, jon³ hniah³ cm³⁴ la⁴jang³⁴ a³tionh² húa³⁴ Judea la⁴teg⁴ mah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jian³ a³hain⁴ a³sainh⁴³ yeih³² cah³² a²hnei⁴³, sa⁴hniah³ jyon⁴³i³ juah⁴ i⁴si⁵quien²³i³ quieh¹ i⁴nie⁴³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Conh⁴liah⁴ a³sainh⁴³ je¹, sa⁴hniah³ chianh³i³ juah⁴ i⁴si⁵quien²³i³ a²cúan³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jian³ ¡ti⁴³ jeu²³ la⁴jang³⁴ a³m⁴ a³ti²chieh¹ jm² jon³ jian³ a³m⁴ a³sian³ yein³ teih⁴ quian¹! ");
INSERT INTO cucNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mh³² hnei³ Jon⁴dai¹ canh⁴a² sa⁴hniah³ jauh²ˉ³ jain³ cu⁴ i⁴cmh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Quie¹ eu⁴³ pain⁴ ma²eu⁴³ jia²³ jm² jon³ i⁴sa⁴ma³a⁴leg³⁴ i¹conh⁴ liah⁴ma²ra⁴lie⁵ m⁵cu³ i⁴a⁴júan⁴ Jon⁴dai¹ la⁴teg⁴ tieh²la³, jian³ a⁵sie⁴³ lei⁴ la⁴ne³ ta⁵cang³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jian³ juah⁴ne³ sa⁴júan³⁴ Se³ño²³ i⁴co⁴le⁴ jm² jon³, i¹jan³ sa⁴lion⁴; i² nei² quieh¹ a³quianh² ne⁵, júan³⁴i³ i⁴sa⁴si⁵úa⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’I⁴jon³ sa⁴hniah³ hainh⁴ˉ³ i²con²³ chie³ juah⁴ne³ juah⁴i³: “Jeh³², A³ua⁵lion³² Chie³ hain⁴ sainh⁴³ la³”, jian³ o⁴ “Jeh³²i³ sainh⁴³ jno³.” ");
INSERT INTO cucNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Quie¹ jeun⁴³ a³ma³co³ jia²³ a³juah⁴ lang⁴³i³ Cristo jian³ o⁴ jan³ a³sain² quian¹ Jon⁴dai¹; jian³ júan³⁴i³ ua³júah² pain⁴ i⁴co³ jnia⁴, canh⁴a² ma⁵can³i³ la⁴teg⁴ a³quianh² a¹juah⁴ li⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","I² hnei³ tionh²ˉ³ ne⁵, jianh³ˉ³ júan² hnei³, quie¹ ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ la⁴jeg³⁴ liah⁴ma²jia⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Jm² jon³ tei⁴³i² ma³ua⁴jeu³² ma²eu⁴³ pain⁴, jon³ liah⁴ hyie³, jian³ segh³ liah⁴ a⁵sie⁴³ ma⁵li⁴joh¹. ");
INSERT INTO cucNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jian³ jyinh³ jah⁴nai⁴³, jian³ jai⁴³ i⁴sia³ ta⁵ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jon³ jen⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ jionh⁴ jeu³ je¹ o¹jnai⁴³ i⁴quian³i³ hlion⁴ ua³pei⁴ jian³ i⁴eu⁴³ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jon³ sain³⁴i³ ángel quian¹ a³si⁵jaih² la⁴jang³⁴ a³quianh² quian¹i³ a³tionh² li⁵quin⁴ queih³² m⁵cu³ a³jo³² liah⁴ a³jo³². ");
INSERT INTO cucNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Júan² hnei³ i⁴li⁴ŋangh⁴ˉ³ tionh²ˉ³ jau²³ i⁴can¹ˉ⁴ la³ quieh¹ a²hma³ m⁴jyi³: La⁴teg⁴i² si²m²³ a²hma³ jian³ ma³si³hyie²³ o¹úan³² quieh¹, jon³ ñih¹ˉ³ tionh² i⁴ma³hloh³² jain³ jm⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jian³ la⁴ne³ liah⁴ tionh²ˉ³, la⁴teg⁴i² jeh⁴ˉ³ si³lei⁴ la⁴jeg³⁴ i⁴ne³, jon³ ñih¹ˉ³ ma³ja²³ hloh³², i⁴ma³si²sainh⁴³i³ o²hnei³². ");
INSERT INTO cucNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴jeg³⁴ i⁴la³ lei⁴ naih⁵i² tyan⁴³ chie³ a³sian³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Si⁵hain⁴ ñi⁴jeu⁵ jian³ cuah³²húa³⁴, i² jau²³ quien⁴ˉ⁴ ne⁵, liah⁴ma³li⁴tei⁴³pa². ");
INSERT INTO cucNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Jian³ i¹jan³ sa⁴ñi³ hain³ jm² jian³ o⁴ hain³ o²ra³ si⁵lei⁴, i¹ ángel a³tionh² ñi⁴jeu⁵ tionh² sa⁴ñi³, a⁵ga⁴ A³jon⁴³ Jon⁴dai¹. Jan³ Neih³ pe²³ˉ⁴ ñi³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’I⁴jon³ jianh³ˉ³ júan² hnei³, júan² hnei³ i⁴ti²naih²ˉ³, jian³ i⁴mh⁵ˉ³ Jon⁴dai¹, quie¹ sa⁴ñih¹ˉ³ legh⁴ lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Quie¹ leg⁴³ liah⁴i² lang⁴³ jan³ a³ñih³ a³chie³⁴ i²gm⁴, a³ua⁵hag⁴³ jauh³² quieh¹; i² naih⁵i² ua⁵hag⁴³i³ jauh³² quieh¹, a⁴cúa⁴i³ heih⁴³ i²con²³ a³cúa²³ cúa³tag³² quian¹, a⁴cúah³i³ ta¹ i²con²³ a³jan³ jan³ liah⁴ hniah³ júan³⁴i³, jian³ a⁴júan⁴i³ heih⁴³ i²con²³ a³hie²³ o²hnei³² i⁴júan³⁴i³ nai²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","I⁴jon³ júan² hnei³ i⁴naih²ˉ³ tionh²ˉ³, quie¹ sa⁴ñih¹ˉ³ hain³legh⁴ jionh⁴ a³quieh¹ jauh³², o⁴ tei⁴³i² ma³a⁴nai³, jian³ o⁴ je¹nai³ húa²³, jian³ o⁴ la⁴teg⁴i² hoh⁵ a¹hyie²³, jian³ o⁴ ta⁵a⁵jnia³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Júan² hnei³ i⁴naih²ˉ³ canh⁴a² sa⁴jo⁴i³ hnei³ i⁴ti²cmh²ˉ³ tionh² tei⁴³i² jionh⁴i³ la⁴conh⁴ sa⁴jianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jian³ liah⁴i² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, jeu³⁴ˉ⁴ la⁴jang³⁴ liah⁴: ¡Ua²tionh²ˉ³ i⁴ti²naih²ˉ³! ");
INSERT INTO cucNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","I² jon³ ne⁵, liah⁴i² yie⁴ teg³⁴ jm², jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, jm² jon³, jm² i⁴queuh³i³ a²hei⁴³ñih¹ i⁴sa⁴hei¹ o¹sieh³². I² jon³ hnoh³ la⁴jang³⁴ m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³ liah⁴ li⁴sanh³i³ Jesús con⁴juah⁴ jau²ta³jau²³ i⁴jŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","A⁴juah⁴i³: ―Sa⁴hniah³ júan³²ˉ¹ ta¹la⁴ jm², canh⁴a² sa⁴ra⁵hang³² a³jeu³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma²hein² Jesús jeu³ Betania jauh³² quieh¹ Si²úan¹ a³ma²lang⁴³ chie² i⁴jyih² o¹ŋeu⁴³ quieh¹, i²jon³ ma²ua²cua⁴³ a²me²sa³. I² jon³ a⁴tyie³⁴ jan³ a³m⁴ i²con²³i³ a³quian³ con³ m⁴tsai³² peih¹ i⁴leg⁴³ alabastro, i⁴tieh³² jmah³ o¹jm³no¹ ma³jeu³ i⁴leg⁴³ jmah³ nardo, i⁴quein⁴³ hlion⁴ mai²³. I² con³ma²a⁴nia³⁴i³ m⁴tsai³² peih¹, jon³ a⁴sie⁴i³ ma³tyi² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jian³ ca³chion²³ a⁴jain²³ tsei⁴³ liah⁴, a⁴juah⁴i³: ―¿Henh⁴le³⁴ ma⁴hain³i³ o¹jm³no¹ ma³jeu³ i⁴quein⁴³ hlion⁴ ne³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Quie¹ ma²li⁴hnang³⁴i³ leg⁴³ga² hneng³ nia⁴lo⁴ o¹cau³² denario i⁴li⁴ma²li⁴ma⁵hon³²i³ a³ti⁴ñei³. I² jon³ a⁴juah⁴i³ tionh² i⁴sa⁴re³ a⁴júan⁴ a³m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","I² a⁴juah⁴ Jesús ne⁵: ―A⁵hnia³ hnei³. ¿E⁴le³⁴ si⁵quianh³²ˉ³ tsei⁴³ a³m⁴ ne³? Quie¹ a⁴júan⁴i³ con³ i⁴tsei³⁴ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Quie¹ la⁴jeg³⁴ nie⁴³pa² tionh² a³ti⁴ñei³ jenh²ˉ³ tionh²ˉ³, jian³ li⁴ma²honh³²ˉ³ a³ti⁴ñei³ ua²hain³ legh⁴ hnoh³ˉ³; i² jnia⁴ ne⁵, a⁵sie⁴³ ma⁵jeh³²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Quie¹ a⁴júan⁴ a³m⁴ la³ la⁴conh⁴i² tieh¹i³; quie¹ a⁴sie⁴i³ o¹jm³no¹ ma³jeu³ ne³ i²con²³ˉ⁵ i⁴a⁴júanh³i³ he³⁴ˉ⁴ naih⁵i² ho³⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴tan² i²hleh³i³ jau²³ quien⁴ˉ⁴ la³, la⁴tan² m⁵cu³, jian³ tya³⁴i³ jau²³ liah⁴ a⁴júan⁴ a³m⁴ la³ i²con²³ˉ⁵, canh⁴a² tyon⁴³ tsei⁴³ chie³ tionh² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","I² Judas Iscariote, a³hein² jen² quia⁵teun⁴ hain⁴, jon³ ŋo³⁴i³ ua⁵jen³²i³ m³chie³ tyein² hain³liah⁴ li⁴cúanh⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","I² jon³ ta² si³hyonh³ a³hain⁴ tionh² a⁴leg³⁴, con³ma²a⁴nau⁴i³, jon³ a⁴tyie³⁴i³ con³ jau²re³ i⁴cúah³i³ Judas o¹cau³². I² jon³ a⁴hnoh³ Judas hain³liah⁴ li⁴tag³⁴ i⁴li⁴cúanh⁴³i³ Jesús joh⁴³ cúa³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","I² jon³ a⁴teg⁴ jm² co⁴ra⁴lie⁵ i⁴júan³i³ jm² i⁴queuh³i³ a²hei⁴³ñih¹ i⁴sa⁴hei¹ o¹sieh³², jian³ jang³i³ a⁵a³siah³ quieh¹ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, jon³ a⁴juah⁴ chie³ quian¹i³ i²con²³i³: ―¿Jainh¹ hnoh³ˉ³ si²júan²³ jnie³² co³jian¹ ma³⁴ i⁴queuh²ˉ³ jm² la³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","I² jon³ a⁴sain⁴i³ on³⁴ chie³ quian¹, a⁴juah⁴i³: ―Cua³ la⁴teg⁴ je¹jeu³, i²jon³ jainh⁴³ˉ³ jan³ a³ñih³ a³quian³ a²tsai³² tieh³² o¹jm³. Jon³ cúah²ˉ³ coh⁵cah³² a³hain⁴, ");
INSERT INTO cucNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","jian³ jauh³² i²hei⁴i³ jon³, i²jon³ jeuh³²ˉ³ a³quieh¹ jauh³²: “La⁴la³ juah⁴ A²teg²³: ¿Hain³ jauh³² i²leg⁴³ yeih³² queuh⁴³i³ ma³⁴ quieh¹ jm² la³ jian²³i³ chie³ quian¹? juah⁴i³.” ");
INSERT INTO cucNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma²jon³ he³⁴i³ hnei³ tionh²ˉ³ con³ jauh³² júah³ i²leg⁴³ yeih³² i²ma³leg⁴³ re³; i²jno³ júanh² hnei³ ma³⁴ quian⁴ˉ¹ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jon³ ua⁵han² chie³ quian¹i³, a⁴hei³⁴i³ je¹jeu³ jon³, jian³ ra⁵tei⁴³ la⁴conh⁴ ma²a⁴juah⁴ Jesús i²con²³i³; i² jon³ a⁴júan⁴i³ ma³⁴ quieh¹ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","I² con³ma²a⁴nai³, jon³ a⁴tyie³⁴ Jesús jian²³ quia⁵teun⁴ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","I² con³ma²a⁴cua⁴i³ a²me²sa³ tionh², jian³ ti²queuh³i³ a²hei⁴³, jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i⁴jan³ hnei³ a³ua²queuh³ a²hei⁴³ jian²³ˉ⁵ tionh²ˉ³, cúah⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jon³ ta² chionh⁴ tsei⁴³i³ tionh² a⁴leg³⁴, jon³ ma⁴lie⁵ con⁴jan³ a⁴sagh⁴³i³ Jesús: ―¿O⁴ jnia⁴? Conh⁴liah⁴ a⁴juah⁴ i²jan³: ―¿O⁴ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Jen³⁴, jan³ hnei³ tionh²ˉ³ la⁴conh⁴ quia⁵teunh⁴ˉ³ ne³, a³hain⁴ a³queuh⁴³ con³ a²gm⁴³ jian²³ˉ⁵, a³hain⁴pa² cúah⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","I⁴chie⁴³pa² hniah³ lei⁴ i²con²³ A³a⁴lang³⁴ Chie³ hain⁴ liah⁴i² ra³sag² nei² quieh¹i³. I² a³cúah⁴³ quieh¹i³ ne⁵, ¡ti⁴³ jeu²³ a³hain⁴! Eu⁴³ ma²re³ juah⁴ne³ sa⁴ma²ra⁵sian³ a³ñih³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","I² con³ma²ti²queuh³i³ a²hei⁴³, jon³ a⁴tang⁴ Jesús a²hei⁴³ñih¹, a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, a⁴jeun³⁴i³, jian³ a⁴cúah³i³ chie³ quian¹, a⁴juah⁴i³: ―Janh³ i⁴la³ tionh²ˉ³; quie¹ i⁴la³ leg⁴³ he³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jon³ a⁴tang⁴i³ a²va²so³ i⁴tieh³² o¹bein² jon³, a⁴cúa⁴i³ ti²hmah³², jon³ a⁴cúah³i³ chie³ quian¹ liah⁴, i² jon³ a⁴hangh³ la⁴jang³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jon³ a⁴juah⁴ Jesús: ―I⁴la³ leg⁴³ jm³yein⁴ quien⁴ˉ⁴ i⁴lei⁴ re³ con³ jau²³ hm³⁴, i⁴tain³⁴ nei² quieh¹ jeun⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ liah⁴, a⁵sie⁴³ ma⁵lauh³²ˉ⁴ o¹bein² quieh¹ o¹m⁴ ya¹gm³jeh², quie¹ lauh³²ˉ⁴ liah⁴ i⁴seg³⁴, la⁴teg⁴ jm² i⁴júan³⁴ Jon⁴dai¹ heih⁴³ nei² m⁵cu³ la³pa². ");
INSERT INTO cucNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","I² con³ma²a⁴he⁴i³ con³ seun²³ quieh¹ Jon⁴dai¹, jon³ ua⁵han²i³ mah⁴ quieh¹ a²hma³ Olivos tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Tonh³²ˉ³ jnia⁴ la⁴jangh³ˉ³ tionh²ˉ³ je¹nai³ ne³⁴; quie¹ ra³juah⁴ ra³sag² Ma²jyi³: “Júanh²ˉ⁵ jeu³² a⁵a³siah³. Jian³ ma⁵quein²³ so⁵jenh³ a⁵a³siah³.” ");
INSERT INTO cucNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","I² la⁴teg⁴i² ma³a⁴hyon²³ˉ⁵ ne⁵, jon³ naih²ˉ⁵ húa³⁴ Galilea naih⁵i² cuanh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Ua²liah⁴a² la⁴jang³⁴ ton³⁴ hnei³, i² jnia⁴ ne⁵, a⁵sian⁴³ hnei³ ton²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, je¹nai³ ne³⁴, naih⁵i² hoh⁵ a¹hyie²³ taun³⁴ nie⁴³, juah²ˉ³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ hnang²³ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","I² Pe³² ne⁵, tsei³⁴sa² a⁴juah⁴i³ jang³⁴ tsei⁴³: ―Ua²liah⁴a² hniah³ jaun⁴ˉ⁴ jian²³ˉ⁵ hnei³, sa⁴legh⁴ ua²a⁴jlian⁵ˉ⁵. Conh⁴liah⁴ la⁴jon³ a⁴juah⁴ la⁴jang³⁴ co³nai². ");
INSERT INTO cucNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jon³ a⁴tyie³⁴i³ tionh² con³ i²sain³ Getsemaní, i² jon³ a⁴sagh⁴³i³ chie³ quian¹: ―Nei⁴ hnei³ i²la³ tionh²ˉ³ ta¹la⁴ nai³²ˉ⁴ ni¹mh⁵ˉ⁵ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jon³ jian³i³ Pe³², Jacobo jian³ Juan²³, i² jon³ eu⁴³ chionh⁴ tsei⁴³ Jesús a⁴leg³⁴ jian³ so⁵ñi³i³ liah⁴ sian³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jon³ a⁴juah⁴ Jesús i²con²³ a³hain⁴ tionh²: ―Ta² chionh⁴ tsei³⁴ˉ⁴ hlion⁴ mai²³, ta² li⁴jaun⁴ˉ⁴, lain³⁴ˉ⁴. Jian² hnei³ i²la³ tionh²ˉ³, ua²ti²naih²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jon³ ŋo³⁴i³ ta⁵nei² i²co⁴meih³, a⁴quie³i³ húa³⁴ ta⁵ra³hain²³i³, a⁴mh³i³ Jon⁴dai¹ i⁴qui³⁴i³ ma²eu⁴³ i⁴ma³o¹jia²³ i²con²³i³ o²ra³ jon³, a¹juah⁴ li⁴lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Quie¹ a⁴juah⁴i³: ―Hnei³ Neih³ˉ⁴, a³cagh¹ jm² a³júan³ la⁴jeg³⁴; qui⁴³ hnei³ ma²eu⁴³ pain⁴ i⁴jia²³ i²con²³ˉ⁵; i² ua²lei⁴ liah⁴ hnoh³ hnei³, a⁵jon⁴³ liah⁴ hno⁵ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jon³ jonh² Jesús i²tionh² chie³ quian¹i³, a⁴jen³i³ i⁴ti²cm²i³; jon³ a⁴sagh⁴³i³ Pe³²: ―Si²úan¹, ¿o⁴ ra³cmh²ˉ³? ¿O⁴ sa⁴tianh³²ˉ³ i⁴naih²ˉ³ con³ o²ra³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Júan² hnei³ ti²naih²ˉ³ tionh²ˉ³ jian³ mh³² hnei³ Jon⁴dai¹ canh⁴a² sa⁴tianh⁵ˉ³ tei⁴³i² jia²³ jau²chie⁴³ i²conh²ˉ³. Quie¹ i⁴chie⁴³pa² hnie³⁴ m⁴tyi⁴ quianh³ˉ³ i⁴ma⁴tei⁵, i² heh³²ˉ³ ne⁵, sa⁴tieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jon³ ŋo³⁴i³ liah⁴ i⁴seg³⁴, ua⁵mh²i³ Jon⁴dai¹, jian³ la⁴jon³pa² a⁴hleh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jon³ jonh²i³ liah⁴ i⁴seg³⁴ i²tionh² chie³ quian¹, a⁴jen³i³ i⁴ti²cm²i³, quie¹ eu⁴³ si²canh³ sie⁴ nei²i³ tionh². Jian³ sa⁴ñi³i³ tionh² hain³ jau²³ li⁴jainh³i³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","I² jon³ a⁴tyanh³i³ i²con²³ chie³ quian¹ a²teg⁴ hnang²³ nie⁴³ ne⁵, a⁴juah⁴i³: ―Cm³ hnei³ quianh³ tionh²ˉ³ júah³, tai³² san⁴ hnei³. Ua²leg⁴³, quie¹ ma³a⁴teg⁴ o²ra³ i⁴cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ a³ti²ren³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ra⁴hang³², ma³²ˉ¹; jeh³², ma³ja²³ a³cúah⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","I² ma²si²hleh² pi¹ Jesús, con³ a⁴la³ a⁴tyie³⁴ Judas, a³hein² jen² quia⁵teun⁴ chie³ quian¹i³, jian³ jian²³i³ jeun⁴³ chie³ a³ti²quian³ a²ñi²tag⁴ jian³ a²hma³, a³sain² quian¹ m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³ jian³ a³don⁵ ma⁴³teg²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","I² Judas, a³cúah⁴³ hain⁴, a⁴júan⁴i³ re³ ñeih³² jian²³i³ a³hain⁴ tionh² i⁴júan³⁴i³ con³ lei³, juah⁴i³: ―A³hain⁴ a³seinh¹ˉ⁴ nei², a³hain⁴pa² hain⁴; sianh³² hnei³, te⁴³ hnei³ i⁴re³ hionh³²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","I² con³ma²a⁴tyie³⁴i³, jon³ ŋo³⁴i³ hlonh² Jesús, a⁴juah⁴i³: ―A²teg²³. Ma²jon³ a⁴seinh⁴i³ nei² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","I² jon³ a⁴sanh³ a³hain⁴ tionh², a⁴júan⁴i³ chion³². ");
INSERT INTO cucNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","I² jan³ a³jian²³ Jesús hain⁴, a⁴tyi³i³ a²ñi²tag⁴ quieh¹, a⁴júanh¹i³ jan³ a³cúa²³ cúa³tag³² i²con²³ jeu³² m³chie³, a⁴queih³i³ ta³ra³cua¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","I² jon³ a⁴juah⁴ Jesús i²con²³ chie³ jeun⁴³ hain⁴: ―¿O⁴ a⁴niah³ˉ³ i²la³ tionh²ˉ³ i⁴jmah³²ˉ³ jnia⁴ ti²quianh²ˉ³ a²ñi²tag⁴ jian³ a²hma³ liah⁴i² sanh²i³ hang³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Quie¹ la⁴jeg³⁴ jm² ma²he³⁴ˉ⁴ jau²³ jenh²ˉ³ tionh²ˉ³ cuah³júah², jian³ sa⁴a⁴sienh²ˉ³ jnia⁴. I² la⁴jeg³⁴ i⁴la³ lei⁴ tieh²la³ canh⁴a² li⁴tei⁴³ jau²³ ra³sag² Ma²jyi³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","I² la⁴jang³⁴ chie³ quian¹ Jesús ne⁵, a⁴ton³⁴ quieh¹i³, a⁴cm⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","I² jan³ a³maih² ñih³ ya¹tyein¹ coh⁵cah³² Jesús a³lion³ a²hmh³ tie³, i² jon³ a⁴sanh³ a³hain⁴ tionh² quieh¹i³; ");
INSERT INTO cucNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","i² a³maih² hain⁴ ne⁵, ua⁵hag⁴³i³ a²hmh³ i⁴ma²hein²i³, a⁴cm⁴i³ co⁴lon⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jon³ ni²jan³i³ Jesús i²con²³ jeu³² m³chie³; i² jon³ a⁴ŋangh³ la⁴jang³⁴ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³ jian³ a²teg²³ quian¹ lai²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","I² Pe³² ne⁵, ya¹tyein¹ coh⁵ i²ma³gm⁴ la⁴conh⁴i² a⁴hei³⁴i³ coh⁵hnei³² quieh¹ jeu³² m³chie³, i² jon³ a⁴cua⁴i³ jian²³ po³li³sei¹ tionh² hloh³² jyi³, ua²ma³húan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","I² la⁴jang³⁴ m³chie³ tyein² jian³ la⁴jang³⁴ si³ta¹ canh² sang³⁴, jon³ a⁴hnoh³i³ chie³² liah⁴ li⁴hnang⁵i³ Jesús canh⁴a² cúanh⁴³i³ i⁴jŋangh³i³; i² sa⁴a⁴chieh¹i³ ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Quie¹ jeun⁴³ a⁴cúa⁴ chie³² jau²ta³jau²³ i²con²³ Jesús, i² sa⁴co³nai² jau²³ a⁴juah⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","I² jon³ a⁴no³ co⁴meih³ a³a⁴cúa⁴ chie³² jau²ta³jau²³ liah⁴, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―A⁴nai² jnie³² a⁴juah⁴ a³ne³: “Quie¹ li⁴jeun²³ˉ⁵ cuah³júah² i⁴a⁴júan⁴ chie³, i² tei⁴³i² ma³a⁴teg⁴ hneng³ jm², jon³ júanh³²ˉ⁴ liah⁴ i²con³ i⁴sa⁴júan³⁴ chie³.” ");
INSERT INTO cucNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jian³ ua²liah⁴a² a⁴hleh⁴i³ la⁴ne³, sa⁴co³nai² a⁴hleh⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","I² jon³ a⁴no³ jeu³² m³chie³ jen²i³ tionh², a⁴ŋang⁴i³ i²con²³ Jesús, a⁴juah⁴i³: ―¿O⁴ i¹con³ jau²³ sa⁴li⁴jainh²ˉ³? Jeh³², ¿henh⁴ hleh²i³ nei² quianh³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","I² Jesús ne⁵, si²sainh⁴³i³ tai³²; i¹con³ sa⁴ŋang³i³. I² jon³ a⁴ŋang⁴ jeu³² m³chie³ i²con²³i³ liah⁴ i⁴seg³⁴, a⁴juah⁴i³: ―¿O⁴ hnei³ langh⁴³ˉ³ A³ma²ya⁴lion³² Chie³ hain⁴, A³jon⁴³ Jon⁴dai¹ Júanh⁴³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Jnia⁴pa² a³hain⁴. Jian³ jenh³²ˉ³ A³a⁴lang³⁴ Chie³ hain⁴ a³ua²cua⁴³ jo³² ta⁵chie³⁴ quieh¹ Jon⁴dai¹ a³li⁴júan³⁴ la⁴jeg³⁴, jian³ jionh⁴i³ jeu³ je¹ o¹jnai⁴³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jon³ a⁴cag³⁴ jeu³² m³chie³ a²cúan³ i⁴jain²³ tsei⁴³i³, a⁴juah⁴i³: ―¿Henh⁴a² ma⁵hniah³ a³hnang⁵ quieh¹i³ ton³²nie⁴³? ");
INSERT INTO cucNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Húanh⁴pa² hnei³ a⁴naih³ˉ³ tieh²la³ tionh²ˉ³ i⁴hieh¹ Jon⁴dai¹. I² ne³ ne⁵, ¿liah⁴ co³hei²tsei³ quianh³ˉ³? Jon³ a⁴juah⁴ la⁴jang³⁴ si³ta¹ hain⁴ tionh² i⁴hniah³ jaun⁴i³, a⁴juah⁴i³ i⁴ren³i³ chie³² pain⁴ i⁴hniah³ jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jon³ ma⁴lie⁵ co⁴meih³ i⁴hñi⁴³i³ Jesús jm³teuh¹, jian³ a⁴hñei⁴i³ con³ a²hmh³ ma³nei²i³, jian³ a⁴quein⁴i³ nei²i³, a⁴juah⁴i³: ―Tyi² hnei³ jau²³ hain³ júanh¹ hnei³. Conh⁴liah⁴ a⁴quein⁴ po³li³sei¹ nei²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","I² jon³ ne⁵, ua²cua⁴³ Pe³² coh⁵hnei³², i² jon³ a⁴tyie³⁴ jan³ a³m⁴ peih¹ a³júan³ ta¹ jauh³² quieh¹ jeu³² m³chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","I² con³ma²a⁴jen³i³ Pe³² a³ua²ma³húan⁴ jon³, jon³ a⁴juah⁴i³: ―Hnei³pa² ma²ŋengh³ jianh²ˉ³ Jesús a³sian³ Nazaret, liah². ");
INSERT INTO cucNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","I² Pe³² ne⁵, a⁴jlian³⁴i³, juah⁴i³: ―I¹ sa⁴cm⁴³i³ jnia⁴, sa⁴yan³²ˉ⁴ henh⁴ hleh³ˉ³. I² jon³ ŋo³⁴ Pe³² hloh³² o²hnei³² jeu³ si³hei⁴i³ a²jneng²³ hyah³. Jon³ a⁴hoh⁵ a¹hyie²³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","I² a³m⁴ peih¹ a³júan³ ta¹ jauh³² hain⁴, jon³ a⁴jen³i³ Pe³² liah⁴ i⁴seg³⁴, i² jon³ a⁴sagh⁴³i³ a³tionh² i²jon³: ―Jeh³², a³ne³pa² a³ma²jian²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","I² hei⁴i³ ne⁵, a⁴jlian³⁴i³ liah⁴. I² liah⁴ma³co⁴le⁴sa² jon³, jon³ a⁴juah⁴ a³ti²tionh² i²jon³ i²con²³ Pe³² liah⁴ i⁴seg³⁴: ―I⁴chie⁴³pa² hnei³ langh⁴³ jan³ chie³ quian¹i³ tionh², quie¹ sianh³ˉ³ Galilea, jian³ hleh³ˉ³ liah⁴ hleh² a³sian³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jon³ ma⁴lie⁵ Pe³² i⁴hen⁴³i³ Jon⁴dai¹ i⁴jang³⁴ tsei⁴³ i⁴he³⁴i³ ma²eu⁴³ i²con²³i³ a¹juah⁴ne³ sa⁴chie⁴³ jau²³ quieh¹i³, a⁴cúa⁴i³ jau²³ quieh¹, juah⁴i³: ―Sa⁴cm⁴³ˉ⁴ hain³ chie³ henh⁵ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","I² con³ma²a⁴hleh⁴i³ jon³, jon³ a⁴hoh⁵ a¹hyie²³ a²teg⁴ taun³⁴ nie⁴³. I² jon³ a⁴tyon²³ tsei⁴³ Pe³² jau²³ i⁴ma³a⁴juah⁴ Jesús i²con²³i³: “Naih⁵i² hoh⁵ a¹hyie²³ taun³⁴ nie⁴³, jlianh³²ˉ³ i⁴juah²ˉ³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ hnang²³ nie⁴³.” I² con³ma²a⁴júan⁴ Pe³² co³hei²tsei³ nei² ne³, jon³ a⁴hoh⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","I² con³ma²a⁴jnia³⁴, jon³ a⁴ŋangh³ m³chie³ tyein² jian³ a³don⁵ ma⁴³teg²³ jian³ a²teg²³ quian¹ lai²³ jian³ la⁴jang³⁴ si³ta¹ canh² sang³⁴, a⁴júan⁴i³ re³ nei² quieh¹ Jesús. Jon³ jian³i³ Jesús ya¹hñi⁴³, ni²cúanh³²i³ joh⁴³ cúa³ Pilato. ");
INSERT INTO cucNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","I² jon³ a⁴ŋang⁴ Pilato, juah⁴i³: ―¿O⁴ hnei³ langh⁴³ Re¹ quian¹ judío tionh²? I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Liah⁴ juah⁴ ne³pa² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jian³ la⁴jang³⁴ m³chie³ tyein² hlion⁴ nai² a⁴hnang⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","I² jon³ a⁴ŋang⁴ Pilato liah⁴ i⁴seg³⁴, juah⁴i³: ―¿O⁴ i¹con³ sa⁴i²jainh²ˉ³? Jeh³², ta² hlion⁴ chie³² cúa²³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","I² Jesús ne⁵, i¹con³ jau²³ sa⁴a⁴ŋangh³i³; i⁴jon³ ta² co³ ŋo³⁴ tsei⁴³ Pilato. ");
INSERT INTO cucNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","I² jon³ ne⁵, quie¹ la⁴jeg³⁴ jm² jon³, jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, tang²³ si²mah⁴ tyein² hain⁴ lion³ jan³ a³chion³², a³hain⁴ a³hen⁴³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jm² jon³ ma²hein² jan³ a³chion³² ni⁴ñi²³ a³sain³ Barrabás, jian²³ chie³ quian¹ a³ma²a⁴sion⁴³ a³jeu³ jian³ a⁴jŋangh⁴i³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","I² con³ma²a⁴ŋangh³ a³jeu³, jon³ a⁴mh³i³ Pilato i⁴júan³⁴i³ liah⁴ tang²³i³ júan³i³ la⁴jeg³⁴ jm² jon³, jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","I² jon³ a⁴juah⁴ Pilato i²con²³ a³jeu³: ―¿O⁴ hnoh³ˉ³ lion³²ˉ⁴ Re¹ quian¹ judío? ");
INSERT INTO cucNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Quie¹ ñi³ Pilato i⁴a⁴cúanh⁴³i³ joh⁴³ cúa³i³, quie¹ i⁴eu⁴³ tsei⁴³ m³chie³ tyein² tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","I² hei⁴i³ tionh² ne⁵, jon³ a⁴sion⁴³i³ a³jeu³ canh⁴a² lion⁴³ Pilato Barrabás niah¹ i⁴lion⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","I² jon³ a⁴juah⁴ Pilato i²con²³i³ tionh² liah⁴ i⁴seg³⁴: ―I² ne³ ne⁵, ¿henh⁴ hnoh³ˉ³ júan³²ˉ⁴ i²con²³ a³hain⁴ a³teh⁵ˉ³ Re¹ quian¹ judío tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","I² jon³ a⁴hleh⁴i³ tia⁴ tionh², juah⁴i³: ―¡Hniah³ tionh³²ˉ³ crau¹! ");
INSERT INTO cucNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","I² a⁴juah⁴ Pilato: ―¿Henh⁴ i⁴hlagh³² a⁴júan⁴i³ ne⁵? I² hei⁴i³ tionh² ne⁵, tsei³⁴sa² tia⁴ a⁴hleh⁴i³, a⁴juah⁴i³: ―¡Hniah³ tionh³²ˉ³ crau¹pa²! ");
INSERT INTO cucNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","I² Pilato hnie³⁴ sainh³i³ re³ i²con²³ a³jeu³. I⁴jon³ a⁴lion³i³ Barrabás; i² con³ma²a⁴júan⁴i³ heih⁴³ i⁴a⁴pan³⁴i³ Jesús jeu³ a²lo³, jon³ a⁴cúanh⁴³i³ i⁴si⁵tion⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","I² jon³ jie³ a²hlie⁴ tionh², jian³i³ Jesús coh⁵hnei³² i²si²jneng³ jauh³²tyie³, i²jon³ a⁴júan⁴i³ heih⁴³ a⁴ŋangh³ la⁴jang³⁴ a²hlie⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jon³ a⁴tanh³i³ con³ a²hmh³ sein³² cúa³, jian³ a⁴tonh³i³ con³ a²sag³ i⁴leg⁴³ a²ton⁴³ ma³tyi²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jon³ a⁴ma⁴co⁴³i³ quieh¹i³, juah⁴i³: ―¡Ta⁵yeih³² Re¹ quian¹ judío tionh²! ");
INSERT INTO cucNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jon³ a⁴pa³⁴i³ ma³tyi² con³ a²ma³cu⁴³, jian³ a⁴hñei³⁴i³ jm³teuh¹, jian³ a⁴si⁴jnei⁵i³ ta⁵nei²i³ a⁴júan⁴i³ la⁴con³ i⁴ma⁴co⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","I² con³ma²a⁴toh⁴ a⁴ji⁴ŋang⁴i³, jon³ a⁴tyi³i³ a²hmh³ sein³² cúa³ jon³, jian³ a⁴tonh³i³ a²cúan³ hña³ liah⁴ i⁴seg³⁴. Jon³ jian³i³ ua⁵tion⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","I² jon³ ne⁵, ma³ua³jeun³² jan³ i²jon³ a³sain³ Si²úan¹ a³sian³ Cirene a³ma²jonh³ i²nau³, jmai³ Alejandro jian²³ Rufo; i² jon³ a⁴júan⁴i³ ta⁵li⁴hnai³ i⁴jian³⁴ a³hain⁴ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","I² jon³ jian³i³ Jesús con³ i²sain³ Gólgota, hnie³⁴ ra³juah⁴, Hien²³ quieh¹ Ma³tyi² Húan³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","I² jon³ a⁴cúah³i³ o¹bein² hei¹ o¹jm³ ma³jeu³ mirra i⁴hangh³i³, i² Jesús ne⁵, a⁵sia³ a⁴hangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","I² con³ma²a⁴tion⁴i³ crau¹ tionh², jon³ a⁴tyonh⁴i³ a²cúan³ Jesús jen²i³ con⁴juah⁴ a⁴tyi³i³ jau²chie⁴³ niah²ˉ¹ henh⁴ teg³⁴ quieh¹ con⁴jan³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I² jon³ a⁴tion⁴i³ crau¹ con³ma²a⁴teg⁴ ni¹ñi³⁴ to⁵hie³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jian³ ra³ton³ con³ jo³²hma³ ma³tyi² crau¹ i⁴ra³hleh² hain³ chie³² a⁴cúah³i³, ra³juah⁴: A³LA³PA² RE¹ QUIAN¹ JUDÍO TIONH². ");
INSERT INTO cucNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jian³ a⁴tion⁴i³ on³⁴ a³júan³ hang³ hlonh² Jesús, jan³ jo³² ta⁵chie³⁴ jian³ jan³ jo³² ta⁵quegh³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","La⁴ne³ ra⁵tei⁴³ jau²³ i⁴ra³sag² Ma²jyi³: “Hein²i³ jen²i³ chie³ hlangh².” ");
INSERT INTO cucNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jian³ la⁴jang³⁴ a³ua³jeun³² jeu³ jon³, sagh⁴³i³ Jesús jau²hlagh³² i⁴jaih²i³ ma³tyi², juah⁴i³: ―¡Hai⁵! Hnei³ a³ma²jeunh³²ˉ³ cuah³júah² jian³ i⁴ma²júanh³²ˉ³ liah⁴ i⁴seg³⁴, tei⁴³i² ma³a⁴teg⁴ hneng³ jm², ");
INSERT INTO cucNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","lion³² hnei³ húanh⁴³, jyon²³ hnei³ si²tonh³ˉ³ crau¹ ne³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Conh⁴liah⁴ la⁴jon³ a⁴ji⁴ŋang⁴ m³chie³ tyein² jian²³ a²teg²³ quian¹ lai²³, a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―A³sang²³pa² a⁴lion³i³, i² hña³i³ ne⁵, sa⁴cagh¹i³ jm² lion⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Sa³juah⁴ hei⁴i³ lang⁴³ A³ma²ya⁴lion³² Chie³ hain⁴, Re¹ quian¹ a³jeu³ Israel, ua²jyon³ chie³ con³ hña³ si²ton³i³ crau¹ canh⁴a² niah³²ˉ¹, jon³pa² li⁴hain⁴ˉ¹ i²con²³i³. Conh⁴liah⁴ a³ti²ton³ jian²³i³ a⁴sagh⁴³i³ Jesús jau²hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Con³ma²a⁴teg⁴ i⁵hyie³, a⁴naih³ la⁴tan² m⁵cu³ la⁴teg⁴ ni¹hneng³ ta⁵hlo⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","I² con³ma²a⁴teg⁴ ni¹hneng³ ta⁵hlo⁴ jon³, a⁴hleh⁴ Jesús con³ i⁴tia⁴, juah⁴i³: ―Eloi, Eloi, ¿lama sabactani? ―hnie³⁴ ra³juah⁴: Jon⁴dai¹ quian³⁴ˉ⁴, Jon⁴dai¹ quian³⁴ˉ⁴, ¿henh⁴le³⁴ a⁴tienh³ˉ³ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","I² jon³ a⁴nau⁴ co⁴meih³ a³ti²tionh² i²jon³ jau²³ quieh¹i³, jon³ a⁴juah⁴i³: ―Jeh³², teh²i³ I³lie²³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Con³ a⁴la³ ra⁴hang³² jan³ a³hain⁴ tionh² jeu³ra³tyi⁴ ni²quian⁴i³ con³ i⁴nah³ i⁴a⁴yeinh³ o¹bein² jeinh³, jon³ si⁴tyi⁵i³ naih¹ a²ma³cu⁴³, a⁴cúah³i³ Jesús i⁴hangh³, a⁴juah⁴i³: ―A⁵conh⁴³; niah²ˉ¹ o⁴ jia²³ I³lie²³ ya⁴lie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","I² Jesús ne⁵, con³ma²a⁴hleh⁴i³ tia⁴ liah⁴ i⁴seg³⁴, jon³ a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jon³ a⁴cag³ a²hmh³ sai²³ quieh¹ cuah³júah² to⁵chieh³² teg⁴ yeih³² la⁴teg⁴ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","I² ne³ ne⁵, sainh⁴³ jan³ jeu³² a²hlie⁴ i²jon³ ta⁵nei² Jesús; i² con³ma²a⁴je³⁴i³ liah⁴ a⁴jaun³⁴ Jesús, ta⁵ma³a⁴hleh⁴i³ tia⁴, jon³ a⁴juah⁴i³: ―I⁴chie⁴³pa² li⁴ ma²lang⁴³ a³ñih³ ne³ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jian³ tionh² co⁴meih³ a³m⁴ i²gm⁴ a³ti²je²³; i² jen² a³m⁴ hain⁴ sainh⁴³ Ma³rei² Ma³da³len², jian³ Ma³rei² sie²³ Jacobo peih¹ jian²³ Se¹, jian³ Salomé. ");
INSERT INTO cucNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","A³m⁴ hain⁴ ma²ya¹han² coh⁵cah³² Jesús liah⁴ma²hein²i³ húa³⁴ Galilea jian³ ma²cúa²³i³ cúa³tag³² i²con²³i³. Jian³ tionh² jeun⁴³ a³m⁴ sang³⁴ liah⁴ a³a⁴tyie³⁴ jian²³ Jesús la⁴teg⁴ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jm² jon³ jm² i⁴júan³i³ co³jian¹, hlo⁴ jm² sa⁴júan³i³ ta¹ ta⁵a⁴nai³ jon³, ");
INSERT INTO cucNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","jon³ a⁴tyie³⁴ Se¹ a³sian³ jeu³ Arimatea, a³lang⁴³ jan³ si³ta¹ canh² quian¹ a³jeu³ Israel, jian³ a³ma²jian²³ jm² ma²júan³⁴ Jon⁴dai¹ heih⁴³ m⁵cu³ la³, a⁴tyie³⁴ a³hain⁴ i²con²³ Pilato i⁴sa⁴coh⁴³i³, ni²m¹i³ he³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","I² con³ma²a⁴nau⁴ Pilato jau²³ i⁴ma³jaun² Jesús, ta² co³ ŋo³⁴ tsei⁴³i³; i² jon³ a⁴teh³i³ jeu³² a²hlie⁴ hain⁴, a⁴ŋang⁴i³ i²con²³i³ o⁴ i⁴chie⁴³ ma³jaun² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","I² con³ma²ra⁵ñi³ Pilato con⁴juah⁴ jau²³ quieh¹ jeu³² a²hlie⁴ hain⁴, jon³ a⁴cúah³i³ he³² Jesús i²con²³ Se¹. ");
INSERT INTO cucNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","I² jon³ a⁴la³⁴ Se¹ con³ a²hmh³ tie³. I² con³ma²a⁴jyon²³i³, jon³ a⁴lion³i³ a²hmh³ tie³ jon³. I² jon³ a⁴quion³i³ con³ to³hlo³ i⁴a⁴cag³⁴i³, jian³ a⁴pa⁴legh³i³ con³ a²caun² ni²legh³, a⁴jleg³⁴i³ ho³²to³. ");
INSERT INTO cucNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jian³ ti²je²³ Ma³rei² tionh² i²a⁴quion³i³ Jesús, Ma³rei² Ma³da³len² jian³ Ma³rei² sie²³ Se¹. ");
INSERT INTO cucNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","I² con³ma²ua⁴jeu³² jm² sa⁴júan³i³ ta¹ jon³, i² jon³ Ma³rei² Ma³da³len² jian²³ Ma³rei² sie²³ Jacobo jian²³ Salomé a⁴la³⁴ o¹jeu² i⁴jia²³ ma³jeu³ i⁴si⁵jñei⁴³i³ he³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jm² ra⁴lie⁵ sa³ma², con³ma²a⁴jnia³⁴, to⁵hie³ hion²³, jon³ ua⁵han² a³m⁴ hain⁴ i²ra³hon³ Jesús, con³ma²ja³⁴ hyie³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","I² a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―¿Hain³ li⁴qui³⁴ a²caun² pa¹ si²jneng³ ho³² to³hlo³ ne³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","I² con³ma²a⁴sie³⁴i³ nei², jon³ a⁴je³⁴i³ i⁴ma³a⁴qui³ a²caun² jon³ i⁴júah³ don⁵. ");
INSERT INTO cucNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","I² con³ma²a⁴hei³⁴i³ to³hlo³, jon³ a⁴jen³i³ jan³ a³maih² ñih³ a³ua²cua⁴³ jo³² ta⁵chie³⁴, a³hein² con³ a²hmh³ tie³ cúa³; i² hei⁴i³ tionh², ta² yi⁴hang³²i³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","I² a³maih² hain⁴, a⁴juah⁴i³: ―A⁵júan³ hnei³ canh⁴³ tionh²ˉ³; quie¹ hnah⁵ˉ³ Jesús a³sian³ Nazaret a³ta⁴ton³² crau¹ hain⁴. A⁵sion⁴³ i³sian³ i²la³, quie¹ ma³a⁴hyon²³i³. Je¹ hnei³ i²ma³a⁴quion³i³ la³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jian³ ua⁴han² hnei³ ua⁴saih³² hnei³ chie³ quian¹i³ jian³ yi⁴saih³²ˉ³ Pe³² i⁴ñeih³² pi¹ tyanh¹i³ húa³⁴ Galilea naih⁵i² cuanh²ˉ³ tionh²ˉ³; i²jon³ jenh³²i³ hnei³ tionh²ˉ³ la⁴ne³ liah⁴i² ma³a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I² a³m⁴ hain⁴, jon³ ua⁵han²i³ i²tionh²i³ ho³²to³ jon³, a⁴cm⁴i³, quie¹ eu⁴³ jlen²³i³ i⁴yi⁴hang³²i³ tionh². Jian³ sa⁴a⁴sagh⁴³i³ i¹jan³ nei² ne³, quie¹ coh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","I² con³ma²a⁴hyon²³ Jesús jm² ra⁴lie⁵ sa³ma², to⁵hie³ jon³, jon³ ma⁴jnia³²i³ ñeih³²jia⁴³ i²con²³ Ma³rei² Ma³da³len², a³hain⁴ a³a⁴húa³i³ quie³⁴ m⁴tyi⁴ hlagh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","I² jon³ ŋo³⁴ a³m⁴ hain⁴ ua⁵júan⁴i³ jau²³ i²con²³ a³ma²tionh² jian²³ Jesús a³ti²chionh⁴ tsei⁴³ jian³ ti²hoh⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","I² hei⁴i³ tionh² ne⁵, con³ma²a⁴nau⁴i³ i⁴sian³pa² Jesús jian³ i⁴ma³a⁴je³⁴ a³m⁴ hain⁴, a⁵sia³ ra⁵hain⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","I² coh⁵ jon³ ma⁴jnia³² Jesús i²con²³ i²on³⁴ chie³ quian¹ i⁴sa⁴co³nai² jnia⁴i³, ma²tionh² a³hain⁴ ho³²jeu³ ŋo³⁴i³ i²nau³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","I² jon³ ua⁵han²i³ ua⁵júan⁴i³ jau²³ tionh² i²con²³ i²con³ hna² chie³ quian¹i³. I² hei⁴i³ tionh² ne⁵, sa⁴a⁴hain⁴i³ jau²³ quieh¹ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","I² i²a⁴toh⁴ ne⁵, ma⁴jnia³²i³ i²con²³ quia⁵con³ chie³ quian¹ a³ma²tionh² a²me²sa³; i² jon³ a⁴jain³⁴i³ a³hain⁴ tionh² nei² quieh¹ i⁴sa⁴hain⁴i³ jian³ i⁴huah³ m⁴tyi⁴ quieh¹i³, quie¹ sa⁴ra⁵hain⁴i³ jau²³ quieh¹ a³a⁴je³ quieh¹ Jesús, ta⁵ma³a⁴hyon²³i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Cua³ ua⁴han² hnei³ la⁴tan² m⁵cu³ ua⁴hleh² jau²³ quien⁴ˉ⁴ i²con²³ la⁴jang³⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","A³hain⁴ a³hain⁴ jian³ a³sion⁵i³ jm³, a³hain⁴pa² lion⁴; i² a³hain⁴ a³sa⁴hain⁴ ne⁵, ma³ua⁵hain⁴ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jian³ i⁴la³ ua³júah² lei⁴ i²con²³ a³ti²hain⁴ i²con²³ jnia⁴: Húa⁴³i³ m⁴tyi⁴ hlagh³² con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴; hleh³i³ jau²jm⁴³ seg³⁴; ");
INSERT INTO cucNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","jian³ juah⁴ne³ a⁴sanh³i³ a⁵mh³, jian³ juah⁴ne³ a⁴hangh³i³ m⁴³ hlagh³², i¹con³ a⁵sia³ i⁴jainh⁴³i³; jian³ tei³⁴i³ si¹cúa³ he³² a³chieh¹, jian³ huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","I² con³ma²a⁴hleh⁴ Se³ño²³ i²con²³i³, jon³ ŋah³i³ ta⁵yeih³² la⁴teg⁴ ñi⁴jeu⁵, i² jon³ a⁴cua⁴i³ jo³² ta⁵chie³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I² chie³ quian¹i³, ua⁵han²i³ tionh², ni²hleh³i³ jau²³ quieh¹ Jon⁴dai¹ la⁴tan². Jian³ ma⁴ho³² Se³ño²³ quieh¹i³, a⁴he⁴i³ i⁴chie⁴³ jau²³ quieh¹ con⁴juah⁴ la⁴jeg³⁴ ua³júah² i⁴a⁴leg³⁴ i²con²³i³ tionh². La⁴ne³pa².");
INSERT INTO cucNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Hnei³ Tio³², jeun⁴³ chie³ ma³a⁴sag⁴ ma²jyi³ ma⁵con³ la⁴conh⁴ con³ la⁴jeg³⁴ i⁴a⁴leg³⁴ jen² si³reunh⁴ˉ¹ nei² quieh¹ Jesucristo; ");
INSERT INTO cucNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","a⁴sag⁴ a³hain⁴ tionh² la⁴conh⁴ a⁴he⁴ a³a⁴teg⁴ nei² i²con²³ Jesús liah⁴ma²ra⁴lie⁵, jian³ a³a⁴hleh⁴ jau²³ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jon³ a⁴júan³⁴ˉ⁴ co³hei²tsei³ liah⁴ i⁴sag¹ˉ⁴ con³ ma²jyi³ i²conh²ˉ³, Tio³², ma⁵con³ la⁴conh⁴ con³ ta⁵ma³a⁴ŋang³⁴ˉ⁴ la⁴jeg³⁴ i⁴a⁴leg³⁴ liah⁴ma²ra⁴lie⁵ ta¹huan³². ");
INSERT INTO cucNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","A⁴sag³⁴ˉ⁴ i⁴la³ canh⁴a² li⁴ñih¹ˉ³ i⁴chie⁴³ jau²³ jon³ i⁴ra⁵tangh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jian³ liah⁴, con³ma²lang⁴³ Herodes re¹ húa³⁴ Judea, ma²sian³ jan³ m³chie³ a³sain³ Zacarías, a³hein² jen² co⁴hna³ a³ti²quian³ jm³i⁴sain³ Abías. I² a³don⁵ quian¹i³ ma²sain³ Be¹, a³lang⁴³ jeun³ Reun²³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Li⁵uan⁴i³ la⁴jon³ tsein³⁴i³ ta⁵nei² Jon⁴dai¹, ma³tei⁵i³ la⁴jeg³⁴ heih⁴³ quieh¹ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jian³ a⁵sian⁴³ a³jon⁴³i³ sian³, quie¹ sa⁴can²³ a³don⁵ Be¹ yein³, jian³ ma³a⁴yinh³ pi²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","I² jon³ ne⁵, con³ jm² ma²si²júan³ Zacarías ta¹ quieh¹ m³chie³ ta⁵nei² Jon⁴dai¹, quie¹ a⁴tyie³⁴ jm² a⁴teg⁴ hna³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Jian³ liah⁴i² tang²³ jm³chie³ tionh² coh²i³ jeu³ m⁴cm³², hain³ teg³⁴ quieh¹, jon³ a⁴teg⁴ quieh¹ Zacarías i⁴si⁵hei⁴i³ con³ je¹sieh³² i²hen² cuah³ i⁴si⁵jein³i³ sein³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","I² la⁴jang³⁴ a³jeu³ ne⁵, ti²tionh²i³ jo³² ta⁵ca³hna³² ti²mh²i³ Jon⁴dai¹ o²ra³ jeng³i³ sein³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jon³ a⁴ma⁴jnia³² jan³ ángel quian¹ Jon⁴dai¹ i²con²³ Zacarías, a³a⁴no³ jo³² ta⁵chie³⁴ ni²hyie⁴ i²jeng³i³ sein³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","I² con³ma²a⁴je³ Zacarías, ta² a⁴tanh⁴³ tsei⁴³i³, yi⁴hang³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jon³ a⁴juah⁴ ángel i²con²³i³: ―A⁵júan³ hnei³ canh⁴³, Zacarías; quie¹ ma³a⁴nau⁴ Jon⁴dai¹ jau²³ quianh³ˉ³. Jian³ tieh²la³ can³⁴ Be¹ i³cúah³ˉ³ jan³ a³jonh³ˉ³. I² jm³i⁴sain³ yein³ hain⁴ ma²sainh²ˉ³ Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jian³ ta² co³hyon²³tsei³ sianh³ˉ³ lei⁴ la⁴teg⁴i² ma³cuan²³i³, jian³ jeun⁴³ chie³ sang²³ liah⁴ lei⁴ si³hyonh³i³; ");
INSERT INTO cucNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","quie¹ eu⁴³ júanh⁴³i³ lei⁴ ta⁵nei² Jon⁴dai¹. Jian³ a⁵sia³ jm³ i⁴li⁴hain⁴³i³ hangh³i³, jian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ can³⁴i³ la⁴teg⁴i² ra⁴lie⁵ jie³ sie²³i³ jian³ coh⁵ jon³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Jian³ júan³⁴ hei⁴i³ i⁴jainh³ jeun⁴³ chie³ Israel nei² ta⁵i²con²³ Se³ño²³ Jon⁴dai¹ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Chie³⁴ Juan²³ ne³ ñeih³² naih⁵i² jia²³ Se³ño²³, i⁴lain⁴i³ liah⁴ ma²lang⁴³ I³lie²³, i⁴ma⁵tyan³i³ hnai³qui³ i²con²³ a³si²tang³ jian²³ jon⁴³segh³², jian³ i⁴júan³⁴i³ i⁴ma⁴tei⁵ a³sa⁴naih¹ tionh² i⁴hleh⁵i³, canh⁴a² ma²tionh² la⁴jang³⁴ a³jeu³ re³ i⁴hyein⁵i³ Se³ño²³ la⁴teg⁴i² ma³ja²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","I² jon³ a⁴ŋang⁴ Zacarías i²con²³ ángel: ―¿Liah⁴a² lei⁴ i⁴ne³ i²con²³ˉ⁵, lainh⁴ˉ³? Quie¹ ma³a⁴yinh³pa² jnia⁴, jian³ ma³a⁴yinh³pa² a³don⁵ quian³⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Conh⁴liah⁴ a⁴juah⁴ ángel liah⁴: ―Bie¹pa² sain³ jnia⁴, si²sainh⁴³ˉ⁴ ta⁵nei² Jon⁴dai¹, a³a⁴sai⁴ jnia⁴ i⁴ni³hlenh⁵ˉ⁵ hnei³ i⁴ni³jeu³⁴ˉ⁴ hnei³ jau²³ tsei²³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","I² jon³ ne⁵, nei² quieh¹ i⁴sa⁴hainh⁴ˉ³ jau²³ la³, jon³ li⁴conh²ˉ³ i⁴so⁵li⁴hleh²ˉ³ la⁴teg⁴ jm² i⁴li⁴tei⁴³ la⁴jeg³⁴ i⁴ne³. Quie¹ la⁴teg⁴i² ma³a⁴teg⁴ jm² quieh¹, hniah³ li⁴tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ta¹la⁴ jon³ ti²tionh² chie³ jeun⁴³ hain⁴ ti²jian⁴³i³ Zacarías, jian³ ta² co³ ŋo³⁴ tsei⁴³i³ tionh² quie¹ a⁴len⁴i³ i²hen² cuah³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","I² con³ma²ua⁵hag⁴³i³ ne⁵, a⁵sie⁴³ li⁴hlenh⁴³i³ a³hain⁴ tionh²; jon³ ra⁵laih² chie³ jeun⁴³ hain⁴ i⁴sia³ con³ i⁴ma⁴jnia³² i²con²³i³ i⁴a⁴je³⁴i³ i²hen² cuah³ jon³. Quie¹ hleh²i³ con⁴juah⁴ i⁴júan³i³ lei³ jeu³ si¹cúa³, i² la⁴ne³ ra⁵con²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","I² con³ma²a⁴tyie³⁴ jm² i⁴ua⁵hag⁴³ Zacarías ta¹ i⁴jeng³i³ sein³ cuah³ jon³, jon³ ŋah³i³ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","I² coh⁵ jon³ a⁴can³⁴ a³don⁵ Be¹ quian¹i³ yein³, jian³ ta¹la⁴ hña⁴ segh³ a⁴cua⁴ Be¹ jauh³² i⁴so⁵ua⁵hag⁴³i³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―A⁴júan⁴ Jon⁴dai¹ la⁴la³ i²con²³ˉ⁵ tieh²la³ canh⁴a² so⁵hleh³ chie³ hlagh³² i²con²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Liah⁴ma²jñi⁴ segh³ jon³, jon³ a⁴sain⁴ Jon⁴dai¹ ángel Bie¹ hain⁴ la⁴teg⁴ con³ jeu³ sain³ Nazaret, nie⁴³ húa³⁴ Galilea, ");
INSERT INTO cucNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","i²con²³ jan³ a³m⁴ yin³ a³sain³ Ma³rei², a³ma³a⁴leg³⁴ re³ i⁴sanh⁴i³ jian²³ jan³ a³ñih³ a³sain³ Se¹, a³lang⁴³ jeun³ re¹ Da³vei²³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jon³ a⁴hei³⁴ ángel i²cua⁴³ a³m⁴ hain⁴, a⁴cúa⁴i³ dai¹, a⁴juah⁴i³: ―¡Ta² hlion⁴ i⁴tsei³⁴ tsei⁴³ Jon⁴dai¹ a⁴júan⁴i³ i²conh²ˉ³! Quie¹ jianh²ˉ³ Se³ño²³; jian³ ta² tsei³⁴ jm² renh³ˉ³ la⁴conh⁴a² la⁴jang³⁴ a³m⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","I² con³ma²a⁴je³⁴ Ma³rei² jian³ a⁴nau⁴i³ jau²³ jon³, ta² co³ a⁴jainh⁴³i³, sa⁴ñi³i³ henh⁴ hnie³⁴ ra³juah⁴ i⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","I² jon³ a⁴juah⁴ ángel hain⁴: ―Hnei³ Ma³rei², a⁵júan³ hnei³ canh⁴³, quie¹ eu⁴³ teg³ tsei⁴³ Jon⁴dai¹ liah⁴ júanh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","I² jon³ ne⁵, quie¹ hlianh⁴ˉ³, i⁴li⁴sian³ jan³ a³jonh³ˉ³, a³hain⁴ a³ma²sainh²ˉ³ JESÚS. ");
INSERT INTO cucNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta² júanh⁴³ a³hain⁴ lei⁴, jian³ teh³i³ a³hain⁴ A³jon⁴³ Jon⁴dai¹ Júanh⁴³; jian³ júan³⁴ Se³ño²³ Jon⁴dai¹ i⁴lain⁴ a³hain⁴ re¹ liah⁴ ma²lang⁴³ re¹ Da³vei²³ sa¹jeun³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I² la⁴ne³ júan³⁴i³ heih⁴³ i²con²³ la⁴jang³⁴ sa¹jeun³ quian¹ Ja³co²³ i⁴sa⁴ton³ jm² ua²tya⁴³, jian³ sa⁴legh⁴ ua²a⁴toh⁴ heih⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","I² Ma³rei² ne⁵, a⁴ŋang⁴i³ i²con²³ ángel, a⁴juah⁴i³: ―¿Liah⁴a² lei⁴ i⁴ne³? Quie¹ a⁵sian⁴³ a³ñih³ ma³jian²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","I² jon³ a⁴juah⁴ ángel: ―Quie¹ lei⁴ con⁴juah⁴ i⁴jia²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²conh²ˉ³, jian³ con⁴juah⁴ ua³pei⁴ quieh¹i³ i⁴si⁵hei⁴ i²conh²ˉ³. I⁴jon³ teh³i³ A³peih¹ A³hen² a³li⁴sian³ hain⁴ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jian³ a³don⁵ Be¹ reunh³ˉ³ liah⁴, ma³ua²quian³i³ yein³ ta⁵a⁴yinh³i³; ma³han⁴³i³ segh³ jñi⁴ ua²chieh¹i³ tieh²la³, a³hain⁴ a³ma²teh²i³ a³sa⁴sian³ a³jon⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Quie¹ i¹con³ a⁵sia³ i⁴sia³ juah⁴ i⁴sa⁴li⁴júan³⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","I² jon³ a⁴juah⁴ Ma³rei²: ―Jnia⁴pa² a³cúa²³ cúa³tag³² i²con²³ Se³ño²³. Ua²lei⁴ i²con²³ jnia⁴ la⁴jeg³⁴ jau²³ si²quianh²ˉ³ ne³. Jon³ ŋah³ ángel hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jian³ ma²jon³ ŋo³⁴ Ma³rei² ta¹tia⁴ hion²³ con³ jeu³ ta⁵je¹sieh³² mah⁴ húa³⁴ Judea. ");
INSERT INTO cucNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jon³ a⁴tyie³⁴i³ jauh³² quieh¹ Zacarías, jian³ a⁴cúa⁴i³ dai¹ i²con²³ Be¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","I² con³ma²a⁴hyei⁴ Be¹ hain⁴ dai¹ i⁴a⁴cúa⁴ Ma³rei², ta² ua⁴nei³² yein³ hein²i³, jian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quian³ Be¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jon³ a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―Ta² tsei³⁴ jm² renh³ˉ³ la⁴conh⁴a² la⁴jang³⁴ a³m⁴, jian³ ta² tsei³⁴ jm² li⁴ren³ yein³ quianh³ˉ³ a³li⁴sian³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿I² hain³ jnia⁴ a⁴niah³ˉ³ ya³jeh³²ˉ³, quie¹ hnei³pa² langh⁴³ sie²³ Se³ño²³ quian³⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quie¹ con³ma²a⁴nau³⁴ˉ⁴ jau²³ quianh³ˉ³ i⁴a⁴cúah³²ˉ³ jnia⁴ dai¹, liah⁴ma²jon³ a⁴ua⁴nei³² yein³ hein³⁴ˉ⁴ i⁴si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jian³ ta² tsei³⁴ jm² renh³ˉ³ quie¹ ra⁵hainh⁴ˉ³, quie¹ li⁴tei⁴³ la⁴jeg³⁴ jau²³ i⁴ni²sai¹ hnei³ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","I² jon³ a⁴juah⁴ Ma³rei²: Júan³⁴ˉ⁴ júanh⁴³ Se³ño²³, ");
INSERT INTO cucNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","jian³ si³hyonh³ m⁴tyi⁴ quien⁴ˉ⁴ i²con²³ Jon⁴dai¹ A³lie³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Quie¹ a⁴je³i³ jnia⁴ i⁴cúa³⁴ˉ⁴ cúa³tag³⁴ i²con²³i³ i⁴ti⁴ñei³ˉ⁴. Jian³ ta⁵i²chie³⁴ la³ hleh³ la⁴jang³⁴ chie³ a³si⁵cúan³ i⁴eu⁴³ tsei³⁴ jm² ra⁵ren³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Quie¹ ta² pain⁴ ua³júah² a⁴júan⁴ Jon⁴dai¹ i²con²³ˉ⁵, a³hain⁴ a³li⁴júan³⁴ la⁴jeg³⁴. Eu⁴³ hen² jm³i⁴sain³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jian³ jieh⁴ ñei⁴ tsei⁴³i³ sa⁴ton³ jm² ua²tya⁴³ i²con²³ la⁴jang³⁴ a³ma³co⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Jian³ ma³a⁴júan⁴i³ ua³júah² pain⁴ con⁴juah⁴ ua³pei⁴ quieh¹i³; jian³ a⁴júan⁴i³ i⁴sa⁴quein⁴³ co³hei²tsei³ quieh¹ a³ti²ron⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jian³ a⁴húan⁴³i³ a³canh² a³ti²lang⁴³ ta¹, jian³ a⁴sionh³i³ a³ti⁴ñei³ ta⁵yeih³². ");
INSERT INTO cucNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jian³ a⁴cúa⁴i³ hlion⁴ i⁴tsei³⁴ i²con²³ a³sa⁴sia³ quieh¹, jian³ a⁴ton³⁴i³ pagh⁴³ a³jlanh². ");
INSERT INTO cucNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A⁴ma⁴hon³²i³ a³jeu³ Israel quian¹, a³lang⁴³ a³cúa²³ cúa³tag³² i²con²³i³, i⁴joh³ ñei⁴ tsei⁴³i³ i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","liah⁴ ma²a⁴cúa⁴i³ jau²³ ho³² i²con²³ A³brang²³ jmai³sie²³ˉ¹, jian³ i²con²³ sa¹jeun³ quian¹i³ i⁴sa⁴legh⁴ ua²ua⁴jeu³². ");
INSERT INTO cucNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","I² jon³ a⁴jian⁴ Ma³rei² hain⁴ on³ segh³ jauh³² quieh¹ Be¹, coh⁵ jon³ a²ma⁴ ŋah³i³ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","I² con³ma²a⁴teg⁴ segh³ yein³ quian¹ Be¹, jon³ ra⁵sian³ jan³ yein³ ñih³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I² con³ma²ra⁵ñi³ la⁴jang³⁴ a³tionh² hlonh²i³ jian³ jon²reunh¹i³ i⁴hlion⁴ i⁴tsei³⁴ tsei⁴³ Jon⁴dai¹ a⁴júan⁴ i²con²³ hei⁴i³, jon³ a⁴júan⁴i³ si³hyonh³i³ tionh² jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","I² con³ma²a⁴teg⁴ jña³⁴ jm² ra⁵sian³ yein³, jon³ ua⁵ma⁵tei³²i³ lai²³ i⁴gm² he³²i³, jian³ ma²hnie³⁴i³ ma⁵sain³ yein³ Zacarías, liah⁴i² sain³ jmai³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","I² a⁴juah⁴ sie²³ yein³ ne⁵: ―A⁵sia³ ma²sain²ˉ¹ la⁴ne³; Juan²³pa² li⁴sain³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","I² a⁴juah⁴ a³hain⁴ tionh² ne⁵: ―¿E⁴le³⁴? Jian³ i¹jan³ jon³reunh³ˉ³ sa⁴sain³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ma²jon³ a⁴ŋangh³i³ jmai³ yein³ i⁴júan³i³ lei³ jeu³ si¹cúa³i³ liah⁴ hnie³⁴i³ ma⁵sain³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jon³ a⁴m⁴ jmai³i³ con³ jo³²hma³ peih¹, a⁴sag⁴i³, a⁴juah⁴i³: “Juan²³pa² li⁴sain³i³.” Ta² co³ ŋo³⁴ tsei⁴³ la⁴jang³⁴ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jian³ liah⁴ma²jon³ a⁴hleh⁴ Zacarías liah⁴ i⁴seg³⁴, i⁴a⁴ra⁵hua³² o¹segh³²i³, a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ta² hlion⁴ joh³ tsei⁴³ la⁴jang³⁴ a³tionh² hlonh²i³, jian³ ra⁵sia³ jau²³ jon³ la⁴tan² je¹sieh³² mah⁴ húa³⁴ Judea. ");
INSERT INTO cucNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jian³ la⁴jang³⁴ a³a⁴nau⁴ jau²³ jon³, a⁴júan⁴i³ co³hei²tsei³ naih⁵ m⁴tyi⁴ quieh¹, a⁴juah⁴i³: ―¿Hain³ pi² chie³ a³peih¹ ne³, liah²? Jian³ chie⁴³pa² lei³ jnia⁴ ma³ho³² Jon⁴dai¹ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jian³ hlion⁴ ma⁴ho³² M⁴tyi⁴ quieh¹ Jon⁴dai¹ quieh¹ Zacarías, jmai³ yein³, i⁴a⁴hleh⁴i³ jau²³ la³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ta² júanh⁴³ Se³ño²³ Jon⁴dai¹ quian¹ a³jeu³ Israel, quie¹ cuan³⁴i³ i⁴lion⁴³i³ a³jeu³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quie¹ ma³a⁴cúan⁴³i³ jan³ a³júanh⁴³ A³lie³ jnia¹, a³ja²³ jeun³ re¹ Da³vei²³ a³a⁴cúa⁴ cúa³tag³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Liah⁴i² a⁴hleh⁴i³ con⁴juah⁴ jau²³ i⁴a⁴hleh⁴ a³sain² quian¹i³ a³a⁵han² liah⁴ma²ra⁴lie⁵: ");
INSERT INTO cucNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","i⁴lie⁴³i³ jnia¹ i²con²³ la⁴jang³⁴ a³hie²³ jian³ i²con²³ a³hnie³⁴ júanh¹ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I² la⁴ne³ joh³ ñei⁴ tsei⁴³i³ nei² quieh¹ jmai³sie²³ˉ¹, i⁴ma⁴tei⁵i³ jau²³ ho³² hen² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Quie¹ i⁴ne³pa² jau²³ ho³²i³ i⁴a⁴cúa⁴i³ i²con²³ A³brang²³ jmai³sie²³ˉ¹ i⁴ma⁴tei⁵i³ i²con²³ jnia¹, ");
INSERT INTO cucNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","i⁴lie⁴³i³ jnia¹ i²con²³ a³ti²hie²³, canh⁴a² la⁴jon³ li⁴ma²con³²i³ jnia¹ i⁴sa⁴can⁴³ˉ¹, ");
INSERT INTO cucNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","jian³ i⁴cúanh¹ˉ¹ jian³ i⁴júan³ˉ¹ i⁴tsei³⁴ ta⁵nei²i³ la⁴conh⁴ jm² i⁴sian³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jian³ hnei³ a³peih¹ quian³⁴ˉ⁴, te³⁴ hnei³ chie³ tionh² a³sain² quian¹ Jon⁴dai¹ Júanh⁴³, quie¹ cúah²ˉ³ ñeih³² ta⁵nei² Se³ño²³ i⁴júanh²ˉ³ re³ jeu³ quieh¹i³; ");
INSERT INTO cucNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","i⁴ua²saih³²ˉ³ la⁴jang³⁴ a³jeu³ quian¹i³ i⁴lie⁴³ Jon⁴dai¹ quieh¹i³, jian³ i⁴hain³⁴i³ chie³² quieh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","con⁴juah⁴ i⁴eu⁴³ joh³ ñei⁴ tsei⁴³ Jon⁴dai¹ quian⁴ˉ¹, quie¹ sain³⁴i³ jan³ i²con²³ˉ¹ a³lang⁴³ liah⁴i² leg⁴³ joh¹ hyie³ tei⁴³i² a⁴jnia³⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","canh⁴a² tagh³ joh¹ i²con²³ a³tionh² i²naih³ jian³ jeu³ jaun⁴, canh⁴a² han⁵ˉ¹ jeu³ tsei²³ i⁴si³hyonh³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jon³ ma³si³cúan³ yein³ jian³ i⁴ŋang⁴i³ nei² quieh¹ m⁴tyi⁴. Jon³ ua⁵cua³i³ con³ i²a⁵sian⁴³ a³sian³ liah⁴i² a⁴tyie³⁴ jm² i⁴ma⁵jnia³²i³ i²con²³ a³jeu³ Israel. ");
INSERT INTO cucNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jain³ jon³ a⁴júan⁴ gobierno Augusto César heih⁴³ i⁴si⁵hon¹ chie³ pa³dron²³ la⁴tan² m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jon³ pi¹ ra⁴lie⁵ censo a⁴júanh³i³, con³ma²lang⁴³ Cirenio si²mah⁴ tyein² quian¹ húa³⁴ Siria. ");
INSERT INTO cucNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jon³ ua⁵han² la⁴jang³⁴ ua⁵tion³²i³ jyi³ conh⁴ con³ jeu³ co²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I² jon³ ua⁵hag⁴³ Se¹ jeu³ Nazaret nie⁴³ húa³⁴ Galilea, ŋo³⁴i³ ta⁵húa³⁴ Judea teg⁴ jeu³ Belén, jeu³ co²³ re¹ Da³vei²³, quie¹ lang⁴³i³ sa¹jeun³ Da³vei²³, ");
INSERT INTO cucNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ua⁵han²i³ jian²³ Ma³rei² ua⁵tion³²i³ jyi³, quie¹ ma³a⁴leg³⁴ re³ i⁴sanh⁴i³ tionh². I² Ma³rei² ne⁵, ua²chieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jian³ con³ma²tionh²i³ i²jon³, jon³ a⁴teg⁴ segh³ i⁴li⁴sian³ yein³ quian¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jon³ ra⁵sian³ jan³ yein³ ñih³ a³nai² quian¹i³. I² jon³ a⁴lion³i³ a²hag²³, jian³ a⁴quion³i³ joh⁴³ a²úan⁴³ queuh³ a²cua³², quie¹ so⁵jo³ jauh³² i²jian²³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jian³ ma²ti²tionh² a³ti²hion⁴³ a⁵a³siah³ hloh³² jeu³ Belén jon³, je¹nai³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","I² con³ a⁴la³ ma⁴jnia³² jan³ ángel quian¹ Jon⁴dai¹ i²con²³i³ tionh², jian³ a⁴tangh⁴i³ joh¹ quieh¹ Se³ño²³ tionh²; jian³ ta² yi⁴hang³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","I² jon³ a⁴juah⁴ ángel: ―A⁵júan³ hnei³ canh⁴³ tionh²ˉ³, quie¹ quian³²ˉ⁴ jau²³ tsei²³ i²conh²ˉ³ tionh²ˉ³, i⁴jon³ lei⁴ si³hyonh³ la⁴jang³⁴ a³jeu³ hlion⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Quie¹ ne³⁴ ra⁵sian³ jan³ A³lion³ chie³, jeu³ co²³ re¹ Da³vei²³, a³hain⁴ a³lang⁴³ Re¹ CRISTO. ");
INSERT INTO cucNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jian³ canh⁴a² li⁴ñih¹ˉ³ tionh²ˉ³, la⁴la³ jenh³²ˉ³: jenh³²ˉ³ yein³ a³ra³hein² joh⁴³ a²úan⁴³ queuh³ a²cua³², a³ra³lion³ a²hag²³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jian³ con³ a⁴la³ ma⁴jnia³² jeun⁴³ lio⁴mai²³ ángel quian¹ ñi⁴jeu⁵ jian²³ ángel hain⁴, a³ti²júan³ júanh⁴³ Jon⁴dai¹, ti²hleh²i³: ");
INSERT INTO cucNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Ta² júanh⁴³ Jon⁴dai¹ si³lei⁴ ñi⁴jeu⁵, jian³ ua²tionh² chie³ tai³² a³tionh² nei² cuah³²húa³⁴ la³ con⁴juah⁴ i⁴tsei³⁴ tsei⁴³ Jon⁴dai¹ i²con²³i³! ");
INSERT INTO cucNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jian³ con³ma²ŋah³ la⁴jang³⁴ ángel hain⁴ ta⁵ñi⁴jeu⁵ tionh², jon³ a⁴juah⁴ a³ti²hion⁴³ a⁵a³siah³ hain⁴ i²con²³ a³jan³ jan³ jon²reunh¹: ―Ma³²ˉ¹ teg⁴ Belén, ma⁵niah³²ˉ¹ i⁴a⁴leg³⁴ i⁴ma⁴jnia³² Se³ño²³ i²con²³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jon³ ua⁵han²i³ ta¹tia⁴ hion²³ tionh², i² jon³ a⁴chianh¹i³ Ma³rei² jian²³ Se¹, jian³ yein³ a³ra³hein² joh⁴³ a²úan⁴³ queuh³ a²cua³². ");
INSERT INTO cucNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","I² con³ma²a⁴je³i³, jon³ a⁴tya⁴i³ jau²³ tionh² i⁴a⁴sag⁴³ ángel quieh¹i³ nei² quieh¹ yein³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jian³ ta² co³ ŋo³⁴ tsei⁴³ la⁴jang³⁴ a³a⁴nau⁴ jau²³ i⁴a⁴tya⁴ a³hion⁴³ a⁵a³siah³ hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","I² Ma³rei² hain⁴ ne⁵, hlion⁴ co³hei²tsei³ júan³i³ nei² la⁴jeg³⁴ i⁴jon³ naih⁵ m⁴tyi⁴ quieh¹ la⁴jeg³⁴ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jon³ ua⁵han² la⁴jang³⁴ jeu³² a⁵a³siah³ hain⁴, i⁴ti²júan³i³ júanh⁴³ Jon⁴dai¹ jian³ i⁴ti²cúa²³i³ ti²hmah³² i²con²³i³ jeu³ ŋah³i³, nei² quieh¹ la⁴jeg³⁴ i⁴a⁴je³⁴i³ jian³ i⁴a⁴nau⁴i³, liah⁴ ma²a⁴juah⁴ ángel i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Liah⁴ma²jña³⁴ jm² ra⁵sian³ yein³, jon³ a⁴ma⁴tei⁵i³ lai²³ i⁴gm² he³²i³, jian³ a⁴ma⁴sain³i³ yein³ JESÚS, quie¹ la⁴ne³ a⁴juah⁴ ángel liah⁴ma²ra⁴lie⁵ naih⁵i² can³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","I² con³ma²ua⁴jeu³² jm² i⁴júan³⁴i³ con⁴juah⁴ lai²³ quieh¹ M³se²³ canh⁴a² so⁴heinh⁵i³, jon³ jian³i³ yein³ ta⁵ Jerusalén ua⁵cúanh³²i³ i²con²³ Jon⁴dai¹, ");
INSERT INTO cucNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","la⁴jon³ liah⁴i² ra³sag² lai²³ quieh¹ Se³ño²³, ra³juah⁴: “La⁴jang³⁴ yein³ ñih³ a³ra⁴lie⁵ cuan⁴, hniah³ tanh⁴³i³ joh⁴³ cúa³ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jian³ jian³i³ jah⁴ a³ua⁵jain³i³ liah⁴i² ra³juah⁴ lai²³ quieh¹ Se³ño²³: “Hniah³ jang³⁴i³ on³⁴ a²jau³pe²³ jian³ o⁴ on³⁴ a⁵ta³cuah³.” ");
INSERT INTO cucNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","I² jon³ ne⁵, ma²sian³ jan³ a³don⁵ a³sain³ Simeón Jerusalén ma²jon³, jan³ chie³ tsein²³, a³ni²taih⁴³ a³jian²³ jm² i⁴lion⁴³ Jon⁴dai¹ a³jeu³ Israel; jian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quian³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jian³ ra⁵ñi³i³ con⁴juah⁴ co³hei²tsei³ i⁴a⁴cúa⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i⁴sa⁴jaun⁴i³ naih⁵i² sa⁴jen³i³ A³ya⁴lion³² Chie³ hain⁴ a³sain³⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jon³ a⁴tyie³⁴i³ cuah³júah² con⁴juah⁴ i⁴ya¹te²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹; con³ma²a⁴tyie³⁴ jmai³sie²³ yein³, jian³i³ yein³ Jesús cuah³júah² i⁴júan³⁴i³ con⁴juah⁴ lai²³ quieh¹ M³se²³, ");
INSERT INTO cucNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","jon³ a⁴tang⁴ Simeón yein³, a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","I² tieh²la³ ne⁵, hnei³ Se³ño²³, ma³li⁴cúah²ˉ³ jeu³ i⁴jaun⁴ˉ⁴ a³cúa²³ cúa³tag³² i²conh²ˉ³ i⁴si³hyonh³ˉ⁴, quie¹ ma³ra⁵tei⁴³ jau²³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Quie¹ ma³a⁴jen³²ˉ⁴ A³lion⁴³ chie³ ");
INSERT INTO cucNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a³a⁴sainh⁴ˉ³ i²con²³ la⁴jang³⁴ chie³, ");
INSERT INTO cucNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","a³lang⁴³ joh¹, canh⁴a² hoh³ m⁴nei² chie³ sang²³, jian³ a³júan³⁴ júanh⁴³ a³jeu³ Israel quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jian³ ta² co³ a⁴jainh⁴³ Se¹ jian²³ sie²³ yein³ la⁴jeg³⁴ jau²³ i⁴a⁴hleh⁴ Simeón nei² quieh¹ yein³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jon³ ma⁴cúah¹ Simeón quieh¹i³ tionh², jian³ a⁴sagh⁴³i³ Ma³rei², sie²³i³, a⁴juah⁴i³: ―Jeh³², i⁴hei¹ heih⁴³ i⁴júan³⁴ yein³ la³ i⁴jeun⁴³ chie³ Israel sonh⁴³ ta⁵yeih³² jian³ a³tianh⁵ ta⁵jeuh³ liah⁴; quie¹ lei³ jnia⁴ i⁴a⁴sain⁴ Jon⁴dai¹ quieh¹i³, jian³ jeun⁴³ chie³ ton³⁴ quieh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","canh⁴a² jñeih³ co³hei²tsei³ ti²júan³ chie³ naih⁵ m⁴tyi⁴ quieh¹ tionh². Jian³ hnei³, liah⁴, si⁵hei⁴ queuh³ hoh⁴³ˉ³ la⁴con³ i⁴ya¹tia³ ñi²tauh⁵ la⁴teg⁴i² jeh²ˉ³ i⁴jainh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jian³ ma²sainh⁴³ jan³ a³don⁵ m⁴ a³hleh² jau²³ i⁴cúa²³ Jon⁴dai¹ quieh¹ i²jon³ liah⁴ a³sain³ A¹han³², a³jon⁴³ Fanuel, a³lang⁴³ sa¹jeun³ a³quia⁵teun⁴ Aser. Jian³ ta² ma³a⁴yinh³i³. Jian³ quie³⁴ ñi³pa² a⁴cua⁴i³ jian²³ i³cúa³ liah⁴ma²maih⁴³i³, ");
INSERT INTO cucNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","jian³ quia⁵jñei⁴ a²sa⁴tei⁴³ nia⁴lo⁴ ñi³ liah⁴ma²ra⁵hnang⁴i³. Jian³ sa⁴ua³hag⁴³i³ cuah³júah² jon³ liah⁴, quie¹ cúa²³i³ cúa³tag³² la⁴húa²³ la⁴jm²³ i²con²³ Jon⁴dai¹, i⁴júan³i³ he² i⁴sa⁴queuh³i³ jian³ i⁴mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jon³ a⁴tyie³⁴i³ o²ra³ jon³ liah⁴, a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, jian³ a⁴hleh⁴i³ nei² quieh¹ yein³ Jesús i²con²³ la⁴jang³⁴ a³tionh² Jerusalén a³ti²jian²³ i⁴lie⁴³ Jon⁴dai¹ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Con³ma²ra⁵tei⁴³ la⁴jeg³⁴ la⁴conh⁴ ra³sag² lai²³ quieh¹ Se³ño²³, jon³ jonh³i³ ta⁵ Nazaret, nie⁴³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jon³ ma³si³cúan³ yein³, jian³ ma³si³li⁴huanh⁴³i³, jian³ hlion⁴ ma³si³li⁴ŋang⁴i³, jian³ hlion⁴ ma⁴ho³² Jon⁴dai¹ quieh¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","I² jon³ ne⁵, chie²³ jmai³sie²³ Jesús la⁴jeg³⁴ ñi³ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, i⁴júan³i³ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","I² con³ma²a⁴hei³⁴ Jesús quia⁵teun⁴ ñi³, jon³ ua⁵han²i³ Jerusalén tionh² liah⁴i² tang²³i³ chie²³i³ jm² i⁴teg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jon³ a⁵han²i³ tionh² con³ma²a⁴cúah³ jm². I² yein³ Jesús ne⁵, a⁴jian⁴i³ Jerusalén, i⁴sa⁴ñi³ Se¹ jian²³ Ma³rei² sie²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Quie¹ lain⁴i³ a³jonh² jen² chie³ jeun⁴³ a³ni²han² jm². I² con³ma²a⁴neih³i³ con³ jm² jeu³, jon³ a⁴hnah³i³ jen² a³tei⁴³ jau²³ quian¹ jian³ jen² a³cm²³i³ ho³²jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","I² sa⁴a⁴chianh¹i³ ne⁵. Jon³ a⁴jainh³i³ nei² liah⁴ ta⁵ Jerusalén, hnah³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","I² con³ma²ua⁴jeu³² hneng³ jm², jon³ pi¹ a⁴chianh¹i³ cuah³júah², a³ua²cua⁴³ jen² a²teg²³ quian¹ lai²³ ua²nau³i³ jau²³ quieh¹i³ tionh² jian³ ua²ŋang⁴i³ i²con²³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","I² la⁴jang³⁴ a³ti²nau³ jau²³ quieh¹i³, ta² co³ chie²³ tsei⁴³i³ tionh² i⁴ŋang⁴i³ jian³ la⁴jeg³⁴ jau²³ i⁴ua²jainh²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","I² con³ma²a⁴je³ jmai³sie²³i³, ta² co³ a⁴jainh⁴³i³ tionh²; jon³ a⁴juah⁴ sie²³i³: ―Peih¹ quian³⁴ˉ⁴, ¿e⁴le³⁴ la⁴ne³ a⁴júanh²ˉ³? Jeh³², jnie³² jie³ jnie³² naih⁴³ˉ³, hlion⁴ co³hei²tsei³ tieh² jnie³² i⁴a⁴hniah⁵ jnie³² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","I² jon³ a⁴ŋangh³ Jesús: ―¿E⁴le³⁴ jnia⁴ hnoh⁵ˉ³ tionh²ˉ³? ¿O⁴ sa⁴ñih¹ˉ³ i⁴hniah³ sainh⁴³ˉ⁴ ta¹ quieh¹ Neih³ˉ⁴ ton³²nie⁴³? ");
INSERT INTO cucNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","I² hei⁴i³ tionh² ne⁵, a⁵sia³ ra⁵ŋang⁴i³ jau²³ i⁴a⁴hleh⁴ Jesús jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jon³ a²ma⁴ a⁵han²i³ tionh² liah⁴ ta⁵ Nazaret, jian³ naih¹ yein³ i²con²³i³ tionh². I² sie²³i³ ne⁵, hlion⁴ co³hei²tsei³ júan³i³ nei² quieh¹ la⁴jeg³⁴ i⁴jon³ la⁴jeg³⁴ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jian³ tsei³⁴sa² hlion⁴ ma³si³li⁴ŋang⁴ Jesús jian³ i⁴ma³si³li⁴júanh⁴³i³, jian³ tsei³⁴sa² teg³ tsei⁴³ Jon⁴dai¹ i²con²³i³ jian³ si³hyonh³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Con³ma²a⁴teg⁴ quia⁵hña⁴ ñi³ júan³ gobierno Tiberio César heih⁴³, jian³ ma²jon³ lang⁴³ Poncio Pilato si²mah⁴ tyein² quian¹ húa³⁴ Judea, jian³ lang⁴³ Herodes ta¹ húa³⁴ Galilea, jian³ lang⁴³ Lei³² reunh¹i³ ta¹ húa³⁴ Iturea jian³ húa³⁴ Traconite, jian³ lang⁴³ Lisanias ta¹ húa³⁴ Abilinia, ");
INSERT INTO cucNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","jian³ lang⁴³ Anás jeu³² m³chie³ tyein² jian²³ Caifás, ma²jon³ ja³⁴ jau²³ quieh¹ Jon⁴dai¹ i²con²³ Juan²³, a³jon⁴³ Zacarías, con³ i²a⁵sian⁴³ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jon³ a⁴ŋeng⁴ Juan²³ hain⁴ la⁴tan² hloh³² jm³ Jordán, a⁴hleh⁴i³ i⁴hniah³ sag³⁴ chie³ co³hei²tsei³ quieh¹ jian³ i⁴hniah³ son⁵i³ jm³, canh⁴a² hain³⁴ Jon⁴dai¹ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lei⁴ la⁴ne³ liah⁴i² ra³sag² jau²³ quieh¹ Isaías a³sain² quian¹ Jon⁴dai¹, i⁴ra³juah⁴: Si²hleh² jan³ tia⁴ con³ i²a⁵sian⁴³ a³sian³, juah⁴i³: “Júanh¹ hnei³ jeu³ quieh¹ Se³ño²³ tionh²ˉ³; o³chie⁴³ ñeih¹ hnei³ jeu³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","La⁴jeg³⁴ húa³⁴ i²jenh⁴³ hniah³ si⁵ho¹; jian³ hniah³ tiah³ la⁴jeg³⁴ i²ñei⁴³; jian³ la⁴jeg³⁴ jeu³ ni²jlei³, hniah³ lai⁴³ jeu³ chie⁴³; jian³ la⁴jeg³⁴ jeu³ sah⁴, hniah³ júanh³i³ i⁴euh³; ");
INSERT INTO cucNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","jian³ jen⁴³ la⁴jang³⁴ A³lion⁴³ chie³ a³sain³⁴ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jian³ a⁴hlenh⁴³ Juan²³ chie³ jeun⁴³ a³ua⁵han² a³hnie³⁴ son⁵ jm³, a⁴juah⁴i³: ―¡Hnei³ tionh²ˉ³ jeun³ a⁵mh³! ¿Hain³ a⁴sag⁴³ hnei³ i⁴hnoh³ˉ³ lionh⁴ˉ³ ma²eu⁴³ pain⁴ i⁴jia²³? ");
INSERT INTO cucNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ma⁴jnia³² hnei³ liah⁴i² haih¹ ma⁵jnia³² a³ma³a⁴sag²³ co³hei²tsei³ quieh¹. Jian³ sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ naih⁵ m⁴tyi⁴ quianh³ˉ³ tionh²ˉ³, i⁴lainh⁴ˉ³: “Sa¹jeun³ A³brang²³pa² jnia¹.” Quie¹ juah³ jnia⁴, la⁴teg⁴ m⁴caun² la³ li⁴júan³⁴ Jon⁴dai¹ i⁴lain⁴³ sa¹jeun³ A³brang²³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jian³ ma³ya¹hei⁴³ re³ a²ñi²³ tyi² i⁴gmh⁴ a²hma³ la⁴teg⁴ o¹júan⁴³. I² la⁴jon³ ne⁵, la⁴jeg³⁴ a²hma³ i⁴sa⁴cúa²³ o¹m⁴ tsei³⁴ hniah³ gmh⁴, jian³ ton³⁴i³ joh⁴³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jon³ a⁴ŋang⁴ a³hain⁴ tionh², a⁴juah⁴i³: ―Juah⁴ne³ la⁴ne³ ne⁵, ¿henh⁴ hniah³ júan² jnie³²? ");
INSERT INTO cucNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon³ a⁴juah⁴ Juan²³: ―A³hain⁴ a³leg⁴³ teun³⁴ a²cúan³, ua²cúa⁴i³ con³ i²con²³ a³sa⁴sia³ quieh¹; jian³ a³hain⁴ a³ni²sion⁴ i⁴queuh⁴³, ua²cúah³i³ a³sa⁴sia³ quieh¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jon³ a⁴tyie³⁴ co⁴meih³ a³can²³ hmah¹ liah⁴, a³hnie³⁴ son⁵ jm³, jon³ a⁴ŋang⁴i³ tionh²: ―Hnei³ a²teg²³, ¿henh⁴ hniah³ júan² jnie³²? ");
INSERT INTO cucNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I² jon³ a⁴juah⁴ Juan²³: ―Sa⁴hniah³ canh²ˉ³ leg⁴³ hmah¹, la⁴conh⁴ ra³cúa²³ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jian³ a⁴ŋang⁴ co⁴meih³ a²hlie⁴ liah⁴, a⁴juah⁴i³: ―I² jnie³² ne⁵, ¿henh⁴ hniah³ júan² jnie³²? I² jon³ a⁴juah⁴ Juan²³ liah⁴: ―Sa⁴quih³²ˉ³ i⁴quieh¹ chie³ i⁴ta⁵li⁴hnai³, jian³ sa⁴hnangh³²ˉ³ chie³ i⁴sa⁴sia³ nei²; jian³ ma⁴hyon²³ hnei³ hoh⁴³ conh⁴ hlianh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jian³ la⁴jang³⁴ a³jeu³ ti²júan³ co³hei²tsei³ naih⁵ m⁴tyi⁴ quieh¹, sa⁴nia² o⁴ Juan²³ hain⁴ lang⁴³ A³ma²ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","I² a⁴juah⁴ Juan²³ i²con²³ la⁴jang³⁴ ne⁵: ―Quie¹ i⁴chie⁴³pa² jnia⁴ ne⁵, sion⁵ˉ⁵ hnei³ jm³ tionh²ˉ³ con⁴juah⁴ o¹jm³; i² a³jia²³ coh⁵ ne³ ne⁵, a³júanh⁴³ a⁵hei⁴³ lia⁴ jnia⁴, jian³ sa⁴haih¹ i⁴li⁴saih²ˉ⁵ a²lo³ tsei²³ tag³² hei⁴i³ i⁴tyi¹ˉ⁴. Hei⁴ pi²³i³ júan³⁴ i⁴hyeih² hnei³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ tionh²ˉ³ jian³ i⁴quie⁴ co³hei²tsei³ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jian³ sianh³i³ a²ñi²³ jleg³ cúa²³ quieh¹ i⁴quiah³i³ o¹m⁴ trigo i⁴qui³⁴i³ ma²qui³. Jon³ ro³⁴i³ o¹m⁴ trigo joh⁴³ a²quei³, jian³ jeng³⁴i³ ma²qui³ jeu³ o¹jyi³ loh⁴³ sa⁴legh⁴ ua²a⁴au³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","I² la⁴ne³ jian³ hlion⁴ jau²³ seg³⁴ a⁴hlenh⁴³ Juan²³ a³jeu³, a⁴hleh⁴i³ jau²³ tsei²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jian³ a⁴jain³⁴i³ si³ta¹ Herodes nei² quieh¹ i⁴jian²³i³ Herodías, a³m⁴ quian¹ Lei³² reunh¹i³, jian³ a⁴jai³⁴i³ nei² quieh¹ la⁴jeg³⁴ i⁴hlagh³² i⁴seg³⁴ i⁴ma³a⁴júan⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jian³ a⁵jon⁴³ jmah³ la⁴jeg³⁴ i⁴ne³, quie¹ a⁴ma⁴hlion⁴ pi¹i³, quie¹ a⁴tanh³i³ Juan²³ ni⁴ñi²³. ");
INSERT INTO cucNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Con³ma²si²sion⁴³ Juan²³ la⁴jang³⁴ a³jeu³ jm³ tionh², jon³ a⁴tyie³⁴ Jesús liah⁴ a⁴son⁴ jm³; jian³ ta¹la⁴ mh²i³ Jon⁴dai¹, jon³ a⁴na⁴ ñi⁴jeu⁵, ");
INSERT INTO cucNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","jon³ a⁴jyie²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³i³ la⁴jan³ a⁵ta³cuah³, jon³ ja³⁴ con³ jau²³ ho³² teg⁴ ñi⁴jeu⁵, i⁴juah⁴i³: ―Hnei³pa² langh⁴³ A³jon³⁴ˉ⁴ a³hno⁵ˉ⁵ a³eu⁴³ teg³ tsei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Con³ma²hein² Jesús la⁴conh⁴ qui⁴quia⁴ ñi³, jon³ ma⁴lie⁵i³ ta¹ quieh¹, a³hain⁴ a³ma²lain⁴i³ jon⁴³ Se¹, jian³ Se¹ hain⁴ a³jon⁴³ Elí, ");
INSERT INTO cucNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","jian³ Elí hain⁴, a³jon⁴³ Matat, jian³ Matat hain⁴, a³jon⁴³ Leví, jian³ Leví hain⁴, a³jon⁴³ Melqui, jian³ Melqui hain⁴, a³jon⁴³ Jana, jian³ Jana hain⁴, a³jon⁴³ Se¹, ");
INSERT INTO cucNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","jian³ Se¹ hain⁴, a³jon⁴³ Matatías, jian³ Matatías hain⁴, a³jon⁴³ Amós, jian³ Amós hain⁴, a³jon⁴³ Nahum, jian³ Nahum hain⁴, a³jon⁴³ Esli, jian³ Esli hain⁴, a³jon⁴³ Nagai, ");
INSERT INTO cucNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","jian³ Nagai hain⁴, a³jon⁴³ Maat, jian³ Maat hain⁴, a³jon⁴³ Matatías, jian³ Matatías hain⁴, a³jon⁴³ Semei, jian³ Semei hain⁴, a³jon⁴³ Se¹, jian³ Se¹ hain⁴, a³jon⁴³ Judá, ");
INSERT INTO cucNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","jian³ Judá hain⁴, a³jon⁴³ Joana, jian³ Joana hain⁴, a³jon⁴³ Resa, jian³ Resa hain⁴, a³jon⁴³ Zorobabel, jian³ Zorobabel hain⁴, a³jon⁴³ Salatiel, jian³ Salatiel hain⁴, a³jon⁴³ Neri, ");
INSERT INTO cucNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","jian³ Neri hain⁴, a³jon⁴³ Melqui, jian³ Melqui hain⁴, a³jon⁴³ Adi, jian³ Adi a³jon⁴³ Cosam, jian³ Cosam a³jon⁴³ Elmodam, jian³ Elmodam a³jon⁴³ Er, ");
INSERT INTO cucNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","jian³ Er a³jon⁴³ Josué, jian³ Josué a³jon⁴³ Eliezer, jian³ Eliezer a³jon⁴³ Jorim, jian³ Jorim a³jon⁴³ Matat, ");
INSERT INTO cucNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","jian³ Matat a³jon⁴³ Leví, jian³ Leví a³jon⁴³ Simeón, jian³ Simeón a³jon⁴³ Judá, jian³ Judá a³jon⁴³ Se¹, jian³ Se¹ a³jon⁴³ Jonán, jian³ Jonán a³jon⁴³ Eliaquim, ");
INSERT INTO cucNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","jian³ Eliaquim a³jon⁴³ Melea, jian³ Melea a³jon⁴³ Mainán, jian³ Mainán a³jon⁴³ Matata, jian³ Matata a³jon⁴³ Natán, ");
INSERT INTO cucNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","jian³ Natán a³jon⁴³ Da³vei²³, jian³ Da³vei²³ a³jon⁴³ Isaí, jian³ Isaí a³jon⁴³ Obed, jian³ Obed a³jon⁴³ Booz, jian³ Booz a³jon⁴³ Salmón, jian³ Salmón a³jon⁴³ Naasón, ");
INSERT INTO cucNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","jian³ Naasón a³jon⁴³ Aminadab, jian³ Aminadab a³jon⁴³ Aram, jian³ Aram a³jon⁴³ Esrom, jian³ Esrom a³jon⁴³ Fares, jian³ Fares a³jon⁴³ Judá, ");
INSERT INTO cucNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","jian³ Judá a³jon⁴³ Ja³co²³, jian³ Ja³co²³ a³jon⁴³ I³sa²³, jian³ I³sa²³ a³jon⁴³ A³brang²³, jian³ A³brang²³ a³jon⁴³ Taré, jian³ Taré a³jon⁴³ Nacor, ");
INSERT INTO cucNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","jian³ Nacor a³jon⁴³ Serug, jian³ Serug a³jon⁴³ Ragau, jian³ Ragau a³jon⁴³ Peleg, jian³ Peleg a³jon⁴³ Heber, jian³ Heber a³jon⁴³ Sala, ");
INSERT INTO cucNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","jian³ Sala a³jon⁴³ Cainán, jian³ Cainán a³jon⁴³ Arfaxad, jian³ Arfaxad a³jon⁴³ Sem, jian³ Sem a³jon⁴³ Noé, jian³ Noé a³jon⁴³ Lamec, ");
INSERT INTO cucNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","jian³ Lamec a³jon⁴³ Matusalén, jian³ Matusalén a³jon⁴³ Enoc, jian³ Enoc a³jon⁴³ Jared, jian³ Jared a³jon⁴³ Mahalaleel, jian³ Mahalaleel a³jon⁴³ Cainán, ");
INSERT INTO cucNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","jian³ Cainán a³jon⁴³ Enós, jian³ Enós a³jon⁴³ Set, jian³ Set a³jon⁴³ A³dang²³, jian³ A³dang²³ hain⁴ lang⁴³ a³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","I² Jesús ne⁵, hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quian³i³, jon³ ua⁵hag⁴³i³ jm³ Jordán, ŋo³⁴i³ jie³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quieh¹i³ ta⁵i²a⁵sian⁴³ a³sian³, ");
INSERT INTO cucNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","i²ñei²i³ to⁴lo⁵ jm², jian³ a⁴con²³ a³sa⁴tsein³⁴ jau²chie⁴³ i²con²³i³. Jian³ ta¹la⁴ jon³ sa⁴a⁴queuh³i³ i¹ca³leuh². I² con³ma²ua⁴jeu³² jon³, jon³ ja³⁴ ra⁵cúanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","I² jon³ a⁴juah⁴ a³sa⁴tsein³⁴ i²con²³i³: ―Juah⁴ne³ hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹, li⁴júanh²ˉ³ heih⁴³ a²caun² la³ i⁴lai⁴³ a²hei⁴³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","I² jon³ a⁴juah⁴ Jesús: ―Quie¹ ra³juah⁴ Ma²jyi³: “A⁵jon⁴³ con⁴juah⁴ jmah³ a²hei⁴³ñih¹ sian³ chie³, quie¹ con⁴juah⁴ la⁴jeg³⁴ jau²³ i⁴hleh² Jon⁴dai¹pa².” ");
INSERT INTO cucNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","I² jon³ a⁴te¹ a³sa⁴tsein³⁴ quieh¹i³ la⁴teg⁴ con³ nei² mah⁴ ñei⁴³, a⁴heh³i³ Jesús conh⁴ a⁴la³ la⁴jeg³⁴ nación quieh¹ cuah³²húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jian³ a⁴sag⁴³ a³sa⁴tsein³⁴ quieh¹i³: ―Jeh³², la⁴tan² nación jno³ cúa¹ˉ⁴ i⁴júanh²ˉ³ heih⁴³, jian³ cúa¹ˉ⁴ i⁴co³ jnia⁴ i⁴sia³ liah⁴, quie¹ ta⁵la⁴ hei¹ joh⁴³ cúa³⁴ˉ⁴ la⁴jeg³⁴ i⁴ne³, jian³ cúah²ˉ⁵ a³hain⁴ a³hno⁵ˉ⁵ cúah²ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","I² juah⁴ne³ si²jneih³²ˉ³ ta⁵nei³⁴ˉ⁴ i⁴ma²coh³²ˉ³ jnia⁴, la⁴jeg³⁴ i⁴jno³ li⁴quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","I² Jesús ne⁵, a⁴juah⁴i³: ―Cuanh³ hnei³ i²con²³ jnia⁴, a⁵lainh³², quie¹ ra³sag² Ma²jyi³ quieh¹ Jon⁴dai¹: “Jan³ Se³ño²³ Jon⁴dai¹pa² hniah³ ma⁵con⁴³ chie³, jian³ jan³ hain⁴pa² hniah³ cúa³⁴i³ cúa³tag³² i²con²³.” ");
INSERT INTO cucNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Conh⁴liah⁴ a⁴te¹ a³sa⁴tsein³⁴ quieh¹i³ la⁴teg⁴ Jerusalén, jon³ a⁴saih⁴i³ yeih³² hnei⁴³ cuah³júah², jian³ a⁴sagh⁴³i³: ―Juah⁴ne³ hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹, juan⁴³ hnei³ con³ i²la³ la⁴teg⁴ húa³⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","quie¹ ra³sag² Ma²jyi³ quieh¹ Jon⁴dai¹: Júan³⁴ Jon⁴dai¹ heih⁴³ i²con²³ ángel quian¹ tionh² i⁴hie⁵i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jian³ sieh⁴³i³ hnei³ jeu³ si¹cúa³, canh⁴a² sa⁴jainh⁴³ˉ³ eu⁴³ i⁴jnoh³ m⁴caun² si¹tagh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","I² a⁴ŋangh³ Jesús liah⁴, a⁴juah⁴i³: ―Quie¹ ra³juah⁴ liah⁴: “Sa⁴hniah³ con⁴³ chie³ jau²chie⁴³ i²con²³ Se³ño²³ Jon⁴dai¹ quian¹.” ");
INSERT INTO cucNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","I² con³ma²a⁴toh⁴ a⁴con²³ a³sa⁴tsein³⁴ jau²chie⁴³, jon³ a⁴quein³⁴i³ hlonh² Jesús ta¹la⁴ co⁴le⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jon³ ŋah³ Jesús ta⁵húa³⁴ Galilea i⁴quian³i³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, jian³ ta⁴tsei¹ jau²³ nei² quieh¹i³ la⁴tan² húa³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jian³ si²heh²i³ chie³ la⁴jeg³⁴ cuah³ judío, jian³ la⁴jang³⁴ júan³ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jon³ a⁴tyanh³ Jesús jeu³ Nazaret i²a⁴cúan³⁴i³ jon³. I² con³ma²a⁴teg⁴ jm² sa⁴júan³i³ ta¹, jon³ ŋo³⁴i³ cuah³ judío liah⁴i² ma³tang²³i³ chie²³i³, ma²jon³ a⁴no³i³ i⁴heg³⁴i³ Ma²jyi³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jon³ a⁴cúah³i³ ma²jyi³ quieh¹ Isaías, a³sain² hain⁴; con³ma²a⁴jan³⁴i³ ma²jyi³, jon³ a⁴chieh¹i³ i²ra³sag² jau²³ la³: ");
INSERT INTO cucNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Quian³²ˉ⁴ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, quie¹ ta⁵la⁴ ma³ma⁴cúah¹i³ jnia⁴ i⁴hleh¹ˉ⁴ jau²³ tsei²³ i²con²³ a³ti⁴ñei³; a⁴sai⁴i³ jnia⁴ i⁴júan³²ˉ⁴ i⁴lai⁴³ tsei⁴³ a³eu⁴³ chionh⁴ tsei⁴³, jian³ i⁴jeu¹ˉ⁴ a³chion³² i⁴ma³a⁴lon⁴i³, jian³ júan³²ˉ⁴ i⁴jnia⁵ m⁴nei² a³taun³², jian³ i⁴lion³²ˉ⁴ a³ua³tsain³² chie³; ");
INSERT INTO cucNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","jian³ i⁴hleh¹ˉ⁴ i⁴ma³a⁴tyie³⁴ jm² i⁴júan³⁴ Jon⁴dai¹ i⁴tsei³⁴ tsei⁴³ i²con²³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jon³ a⁴pan³⁴i³ ma²jyi³ jon³, a⁴cúah³i³ a³hie³ cuah³, ma²jon³ a⁴cua⁴i³. Jian³ ta² tia⁴ ti²je³ a³ti²tionh² cuah³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","I² jon³ ma⁴lie⁵ Jesús a⁴hleh⁴i³, a⁴juah⁴i³: ―Ne³⁴ ra⁵tei⁴³ la⁴conh⁴ ra³sag² Ma²jyi³ la³ ta⁵mah²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jian³ la⁴jang³⁴ ti²hleh² re³ nei² quieh¹i³, jian³ ta² co³ chie²³ tsei⁴³i³ tionh² la⁴jeg³⁴ jau²³ co³ naih⁵ i⁴hleh²i³. I² jon³ a⁴juah⁴i³ tionh²: ―¿A¹hei⁴ a³jon⁴³ Se¹ hain⁴ ne³? ");
INSERT INTO cucNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jon³ a⁴juah⁴ Jesús: ―Leg⁴³ re³pa² jeuh³²ˉ³ jnia⁴ jau²³ i⁴hleh² chie³ la³: “Hnei³ teg³m⁴³, júan² hnei³ i⁴huan⁴ quianh³ húanh⁴³”; jian³ li⁴juah²ˉ³: “A⁴nai² jnie³² i⁴a⁴júanh²ˉ³ hlion⁴ ua³júah² jeu³ Capernaum; hniah³ júanh²ˉ³ liah⁴ jeu³ coh³²ˉ³ la³.” ");
INSERT INTO cucNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jian³ a⁴juah⁴ pi¹i³: ―I⁴chie⁴³ pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, quie¹ i¹jan³ a³sain² quian¹ Jon⁴dai¹ sa⁴ron⁴³i³ jeu³ jeu³ co²³i³ hña³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Quie¹ i⁴chie⁴³pa² juah³ˉ⁴, jm² ma²sian³ I³lie²³ ya⁴jo³⁴, jeun⁴³ a³don⁵ m⁴ hnang⁴ ma²sian³ húa³⁴ Israel la³, con³ma²sa⁴a⁴tah⁴ o¹jm⁴³ ta¹la⁴ hneng³ ñi³ ton⁴, jian³ a⁴hei³⁴ ho³²cúan⁴ la⁴tan² húa³⁴ la³; ");
INSERT INTO cucNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","jian³ a⁵sia³ a⁴sai⁴ Jon⁴dai¹ quieh¹ I³lie²³ i²con²³ i¹jan³ a³hain⁴ tionh², quie¹ a⁴sain⁴i³ i²con²³ jan³ a³m⁴ hnang⁴ a³sian³ jeu³ Sarepta, jeu³ seg²³, nie⁴³ húa³⁴ Sidón. ");
INSERT INTO cucNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jian³ liah⁴ jeun⁴³ a³ma²lang⁴³ chie² jyih² o¹ŋeu⁴³ quieh¹ ma²sian³ húa³⁴ Israel jm² ma²sian³ Eliseo, a³sain² quian¹ Jon⁴dai¹, jian³ i¹jan³ hain⁴ sa⁴a⁴huan⁴ quieh¹, jan³ Naamán a³sian³ húa³⁴ Siria pa². ");
INSERT INTO cucNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Con³ma²a⁴nau⁴ la⁴jang³⁴ a³tionh² cuah³ judío jau²³ jon³, ta² a⁴jain³⁴ tsei⁴³i³, ");
INSERT INTO cucNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","a⁴ra⁴hang³²i³ tionh², a⁴tyein³i³ Jesús je¹jeu³ jon³, jian³i³ la⁴teg⁴ nei² mah⁴ nie⁴³ jeu³ Nazaret, hnie³⁴i³ juan⁴³i³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","I² Jesús ne⁵, ua⁵hag⁴³i³ jeu³ jen² a³hain⁴ tionh², ŋo³⁴i³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jon³ ŋo³⁴ Jesús jeu³ Capernaum, nie⁴³ húa³⁴ Galilea, i² jon³ a⁴heh³i³ chie³ la⁴jeg³⁴ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jian³ ta² co³ jainh⁴³ chie³ jau²³ i⁴he²³i³, quie¹ hleh²i³ i⁴quian³i³ heih⁴³ pain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jian³ ma²sainh⁴³ jan³ chie³ a³quian³ m⁴tyi⁴ hlagh³² cuah³ judío jon³, a³a⁴hleh⁴ con³ i⁴tia⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","juah⁴i³: ―¡A⁵coh⁴³ jnie³²! ¿Henh⁴ hnoh³ˉ³ júanh²ˉ³ i²con²³ jnie³², hnei³ Jesús a³sian³ jeu³ Nazaret? ¿O⁴ a⁴niah³ˉ³ i⁴ma²tyieh²ˉ³ jnie³²? Quie¹ cm⁴³ˉ⁴ hain³ hnei³, hnei³pa² A³hen², a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","I² Jesús ne⁵, jon³ a⁴jain³⁴i³, a⁴juah⁴i³: ―¡Cauh¹ lauh²! ¡Jau²³ i²con²³ a³ñih³ ne³! I² con³ a⁴la³ a⁴ton³⁴ m⁴tyi⁴ hlagh³² a³ñih³ hain⁴ húa³⁴ ta⁵nei² la⁴jang³⁴, ua⁵hag⁴³i³ i²con²³i³, jian³ a⁵sion⁴³ a²ma⁴ a⁴júanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","I⁴jon³ ta² co³ a⁴jainh⁴³ la⁴jang³⁴ a³hain⁴ tionh², a⁴hlenh⁴³i³ a³jan³ jan³, juah⁴i³: ―¿Hain³ ga⁴ jau²³ ne³, liah²? Quie¹ quian³i³ ua³pei⁴ jian³ heih⁴³ pain⁴ i⁴júan³i³ i²con²³ m⁴tyi⁴ hlagh³² tionh², jian³ húan⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","I² jon³ ta⁴tsei¹ jau²³ nei² quieh¹ Jesús la⁴tan² húa³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ma²jon³ a⁴no³ Jesús, ua⁵hag⁴³i³ cuah³ judío, a⁴tyie³⁴i³ jauh³² quieh¹ Si²úan¹ Pe³². I² a³don⁵ a¹sie²³i³, ta² ra³tyein⁴i³, jon³ a⁴mh³i³ Jesús i⁴ma⁵ho³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jon³ a⁴no³ Jesús ta⁵si²hain²³i³ hlonh²i³, jon³ a⁴júan⁴i³ heih⁴³ i⁴qui⁴ tyei⁴, jian³ a⁴qui³ tyei⁴. Jian³ liah⁴ma²jon³ a⁴no³ a³m⁴ hain⁴, a⁴cúa⁴i³ cúa³tag³² i²con²³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Con³ma²a⁴chia³⁴ hyie³, la⁴jang³⁴ a³ma²ra³han² a³chieh¹ quian¹ a³ti²lang⁴³ ma⁵quein²³ nai² chie², ua⁵jan³i³ i²con²³ Jesús; ma²jon³ a⁴tei³⁴i³ si¹cúa³ ma⁵jan³ a³hain⁴ tionh², a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jian³ jeun⁴³ a³ma²ti²quian³ m⁴tyi⁴ hlagh³² liah⁴, a⁴húan³, i⁴ti²hleh²i³ tia⁴, juah⁴i³: ―Hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹. I² Jesús ne⁵, a⁴cauh³i³ lau²i³, sa⁴cúa²³i³ i⁴hleh³i³, quie¹ ñi³i³ tionh² i⁴lang⁴³ hei⁴i³ A³ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Con³ma²a⁴jnia³⁴, jon³ ua⁵hag⁴³ Jesús jeu³ jon³, ŋo³⁴i³ con³ i²a⁵sian⁴³ a³sian³. Jian³ ta² a⁴hnoh³ a³jeu³ quieh¹i³ liah⁴a² a⁴tyie³⁴i³ i²cua⁴³i³. Sa⁴cúa²³i³ i⁴si⁴hag⁴³ Jesús jen²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","I² a⁴juah⁴ Jesús ne⁵: ―Ton³²nie⁴³ hniah³ nai³²ˉ⁴ jeu³ seg²³ ni¹hleh³ˉ⁴ jau²³ tsei²³ liah⁴ leg⁴³ i⁴tionh²i³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, quie¹ nei² ne³pa² a⁴sai⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jon³ a⁴ŋeng⁴ Jesús, a⁴hleh⁴ jau²³ quieh¹ Jon⁴dai¹ la⁴jeg³⁴ cuah³ judío húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Con³ jm² ma²hein² Jesús quien¹i²jm¹ jm³ñei³ Genesaret, ta² jeun⁴³ chie³ a⁴tyie³⁴ hlonh²i³ i⁴si³caunh⁵i³ ta⁵li⁴hnai³, a³hnie³⁴ nau³⁴ jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jon³ a⁴je³⁴ Jesús teun³⁴ a²úan⁴³ i⁴ra³ha¹ quien¹i²jm¹, quie¹ ma³a⁴húan³ a³jo³ a³ma²tionh² joh⁴³ jian³ ma²ti²raunh⁵i³ a²nai²³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","I² Jesús ne⁵, jon³ a⁴hei³⁴i³ joh⁴³ con³ a²úan⁴³ jon³, i⁴jon³ i⁴quieh¹ Si²úan¹, jian³ a⁴sagh⁴³i³ Si²úan¹ i⁴hag³⁴i³ meih³ jo³² ta⁵yi⁴jo²³. Jon³ a⁴cua⁴i³ joh⁴³, a⁴heh³i³ chie³ a³jeun⁴³ hain⁴ i⁴ua²cua⁴³i³ joh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Con³ma²a⁴toh⁴ a⁴hleh⁴i³, jon³ a⁴sagh⁴³i³ Si²úan¹: ―Yi⁴canh²ˉ³ a²úan⁴³ la³ ta⁵i²jeuh³, ma²jon³ tiah²ˉ³ a²nai²³ quianh³ i⁴jmah³²ˉ³ jah⁴ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","I² a⁴juah⁴ Si²úan¹: ―Hnei³ A²teg²³, la⁴tan² húa²³ ma³hm⁴ a⁴júan² jnie³² ta¹, i¹jan³ sa⁴a⁴jon⁴ jnie³²; a¹juah⁴ hnei³ juah⁴, ni¹hai³⁴ pe²³ˉ⁴ i²con³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","I² con³ma²a⁴júan⁴i³ la⁴jon³, ta² jeun⁴³ jah⁴ a⁴yanh⁵, jian³ ma³li⁴quei³⁴ júah³ a²nai²³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","I² jon³ a⁴júan⁴i³ lei³ jeu³ si¹cúa³ i²con²³ a³jian²³i³ a³tionh² a²úan⁴³ i²con³, i⁴jia²³ a³hain⁴ i⁴ma⁵ho³² quieh¹i³ tionh². Jon³ ua⁵han²i³ tionh², jian³ ma⁴canh³i³ li⁵teun⁴ a²úan⁴³ jon³ jon⁴³júa³², i⁴ma³li⁴hon³⁴ júah³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Con³ma²a⁴je³⁴ Si²úan¹ Pe³² i⁴jon³, jon³ a⁴si⁴jnei⁵i³ ta⁵nei² Jesús, a⁴juah⁴i³: ―Ta⁵co⁴³ quein⁴³ hnei³ i²con²³ jnia⁴, hnei³ Se³ño²³, quie¹ lang⁴³ˉ⁴ jan³ chie³ a³ren³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quie¹ ta² yi⁴hag³² tsei⁴³ Si²úan¹ jian³ la⁴jang³⁴ a³jian²³i³ nei² quieh¹ eu⁴³ jeun⁴³ jah⁴ a⁴jon⁴i³; ");
INSERT INTO cucNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","jian³ yi⁴hang³² Jacobo jian²³ Juan²³, si³jon⁴³ Zebedeo, a³júan³ ta¹ jian²³ Si²úan¹. Jon³ a⁴juah⁴ Jesús i²con²³ Si²úan¹: ―A⁵júan³ hnei³ canh⁴³; quie¹ tieh²la³ júan³²ˉ⁴ i⁴lainh⁴ˉ³ a³jo³ a³sanh² chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","I² con³ma²a⁴tien³⁴i³ a²úan⁴³ quien¹i²jm¹, jon³ a⁴ton³⁴i³ la⁴jeg³⁴ tionh², ua⁵han²i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jian³ con³ jm², con³ma²hein² Jesús con³ jeu³, jon³ a⁴tyie³⁴ jan³ a³ñih³ a³lang⁴³ chie² i⁴jyih² o¹ŋeu⁴³ quieh¹. I² con³ma²a⁴jen³i³ Jesús, jon³ a⁴si⁴jnei⁵i³, a⁴quie³i³ teg⁴ húa³⁴, jian³ a⁴m⁴i³ i²con²³i³, a⁴juah⁴i³: ―Hnei³ Se³ño²³, a¹juah⁴ne³ hyon³ hoh⁴³ˉ³, li⁴júanh²ˉ³ i⁴huan⁴ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jon³ a⁴ñeih³ Jesús si¹cúa³, a⁴tei³⁴i³ he³² a³hain⁴, juah⁴i³: ―Hno⁵ˉ⁵; ua²huan⁴ quianh³ˉ³. I² liah⁴ma²jon³ ua⁵conh⁴ chie² i⁴ma²jyih² o¹ŋeu⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³ i⁴sa⁴sagh⁵i³ i¹jan³ chie³, quie¹ a⁴juah⁴i³: ―Tyieh⁴ˉ³ yi⁴ma⁴jniah³²ˉ³ ta⁵nei² m³chie³, jian³ yi⁴cúah²ˉ³ i²con²³ Jon⁴dai¹ canh⁴a² so⁴heinh⁵ˉ³ i⁴jon³ i⁴a⁴júan⁴ M³se²³ heih⁴³, canh⁴a² li⁴ñi³i³ tionh² i⁴a⁴huan⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","I² jon³ ne⁵, tsei³⁴sa² ta³tsei¹ jau²³ nei² quieh¹ Jesús con⁴ conh⁴, jian³ jeun⁴³ ŋangh³ a³hnie³⁴ nau³⁴ jau²³ quieh¹i³ jian³ a³hnie³⁴ huan⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","I² Jesús ne⁵, quein²³i³ i²tionh² chie³, chie²³i³ ta⁵i²a⁵sian⁴³ a³sian³, si³mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jian³ liah⁴ con³ jm² ma²ua²he²³ Jesús, jian³ ma²tionh² fariseo jian³ a²teg²³ quian¹ lai²³, a³a⁵han² la⁴jeg³⁴ jeu³ nie⁴³ húa³⁴ Galilea, jian³ húa³⁴ Judea jian³ jeu³ Jerusalén liah⁴. I² Jesús ne⁵, quian³i³ hlion⁴ ua³pei⁴ quieh¹ Jon⁴dai¹ i⁴júan³i³ i⁴huan⁴ quieh¹ a³chieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","I² jon³ ti²jian³ co⁴meih³ chie³ jan³ a³chieh¹ a³lo³, a³hein² joh⁴³ a²hyei²³, ma²hnie³⁴i³ si⁵jan³i³ ta⁵jauh³² i⁴si⁵quion³i³ ta⁵nei² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","I² sa⁴sia³ liah⁴ li⁴chie³⁴i³ ne⁵, quie¹ eu⁴³ jeun⁴³ chie³. I² jon³ a⁴eu⁴i³ cah³² hnei⁴³, a⁴qui³⁴i³ co⁴meih³ a²cuah³², a⁴nia³⁴i³ to³ jeu³ a⁴jyon³i³ a³chieh¹ a³hein² a²hyei²³ hain⁴ to⁵chieh³² i²ti²tionh² chie³ ta⁵nei² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","I² con³ma²a⁴je³⁴ Jesús conh⁴ tei⁴³ i⁴hain⁴ a³hain⁴ tionh², jon³ a⁴sagh⁴³i³ a³chieh¹: ―Jeu³⁴ˉ⁴ hnei³, ma³a⁴hain³⁴ chie³² quianh³ˉ³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","I² jon³ a⁴júan⁴ a²teg²³ quian¹ lai²³ co³hei²tsei³ tionh² jian²³ chie³ fariseo, a⁴juah⁴i³: “¿Hain³ chie³ ne³ sa⁴jieh⁴ tsei⁴³ hleh² jau²³ i⁴hieh¹ Jon⁴dai¹? ¿Quie¹ hain³ ma⁵li⁴hain³⁴ chie³² quieh¹ chie³? Jan³ Jon⁴dai¹pa².” ");
INSERT INTO cucNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","I² Jesús ne⁵, ñi³i³ co³hei²tsei³ ti²júan³ a³hain⁴ tionh², jon³ a⁴sagh⁴³i³: ―¿E⁴le³⁴ co³hei²tsei³ ne³ ti²júanh³ˉ³ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","I² jon³ ne⁵, ¿henh⁴a² tyein² sa⁴jeuh⁴³ li⁴hleh¹ˉ⁴ li⁴tei⁴³ la⁴conh⁴a² li⁵teun⁴ la³, lainh⁴ˉ³? ¿O⁴ li⁴juah¹ˉ⁴: “Ma³a⁴hain⁵ˉ⁵ chie³² quianh³ˉ³”, jian³ o⁴: “No³ hnei³, ŋeng²”? ");
INSERT INTO cucNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","I² jon³ ne⁵, canh⁴a² li⁴ñih¹ˉ³ i⁴quian³ A³a⁴lang³⁴ Chie³ hain⁴ heih⁴³ i⁴hain³⁴i³ chie³² quieh¹ chie³ cuah³²húa³⁴ la³, ua²ma²jnia³²ˉ⁴ i⁴la³. Jon³ a⁴sagh⁴³i³ a³lo³ hain⁴: ―Jeu³⁴ˉ⁴ hnei³ tieh²la³, no³, quien²³ a²hyei²³ quianh³, cuanh³ quianh³ jauh³² quianh³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jian³ liah⁴ma²jon³ ra⁴hang³²i³ ta⁵nei² la⁴jang³⁴ a³hain⁴ tionh², quien²³i³ a²hyei²³ quieh¹ i⁴ma²ra³hein²i³, ŋah³i³ jauh³² quieh¹ i⁴ya¹júan³i³ júanh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jian³ ta² co³ a⁴jainh⁴³ la⁴jang³⁴ a³hain⁴ tionh², jian³ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹, jian³ ta² coh⁴³i³, a⁴juah⁴i³: ―Ne³⁴ a⁴niah¹ˉ¹ ua³júah² pain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","I² con³ma²a⁴leg³⁴ jon³, jon³ ua⁵hag⁴³ Jesús, i² jon³ a⁴jen³i³ jan³ a³can²³ hmah¹ a³sain³ Leví, a³ua²cua⁴³ jauh³² i²can²³i³ hmah¹, ma²jon³ a⁴sagh⁴³i³ a³hain⁴: ―Nia³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","I² liah⁴ma²jon³ ra⁴hang³²i³, a⁴ton³⁴i³ la⁴jeg³⁴, ŋo³⁴i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","I² coh⁵ jon³ a⁴júan⁴ Leví con³ jm² júah³ jauh³² quieh¹ i⁴ma⁴con⁴³i³ Jesús, jian³ tionh² jeun⁴³ a³can²³ hmah¹ jian³ jeun⁴³ a³sang²³ liah⁴, a³tionh² mesa jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","I² a²teg²³ quian¹ lai²³ jian²³ chie³ fariseo tionh², a⁴si⁴hen⁴³i³ chie³ quian¹ Jesús, a⁴juah⁴i³: ―¿E⁴le³⁴ queuh³ hauh⁴ˉ³ tionh²ˉ³ jianh²ˉ³ chie³ a³can²³ hmah¹ jian³ a³ti²ren³ chie³²? ");
INSERT INTO cucNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","I² jon³ a⁴ŋangh³ Jesús i²con²³i³ tionh², a⁴juah⁴i³: ―La⁴jang³⁴ a³hei⁴³ tsei⁴³, a⁵sian⁴³ teg³m⁴³ hniah³ quian¹i³, a³chieh¹pa² hniah³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jian³ la⁴ne³ liah⁴, a⁵sia³ cuan⁵ˉ⁵ juah⁴ i⁴ni³teh⁵ˉ⁵ a³ni²taih⁴³ tionh², a³ren³ chie³²pa², canh⁴a² sag³⁴i³ co³hei²tsei³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―¿I² e⁴le³⁴ queuh³ hangh² chie³ quianh³ˉ³ ne⁵? Quie¹ chie³ quian¹ Juan³ Tei³² jian³ fariseo tionh², con³ ta¹ júan³i³ he² i⁴sa⁴queuh³i³, jian³ hlion⁴ nie⁴³ mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―¿O⁴ li⁴júan³⁴ a³ten² quian¹ a³sanh⁴ he² ta¹la⁴ cua⁴³ a³ñih³ a³sanh⁴ jian²³i³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Quie¹ jia²³ jm² la⁴teg⁴i² te⁴³i³ a³sanh⁴; jon³ a²ma⁴ júan³⁴i³ he² tionh² i⁴sa⁴queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jian³ a⁴can³⁴i³ jau²³ la³ i⁴a⁴sagh⁴³i³: ―I¹jan³ a⁵sian⁴³ tei²³ ca³leuh² a²hmh³ hm²³ juah⁴ i⁴tien²³i³ con³ a²hmh³ ma³don⁵. Quie¹ juah⁴ne³ tei²³i³ la⁴ne³ i⁴tien³i³, jon³ si⁵hain⁴ a²hmh³ hm²³ jon³, jian³ sa⁴queunh² liah⁴ jian²³ a²hmh³ don⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jian³ la⁴jon³ liah⁴, i¹jan³ sa⁴ro³ o¹bein² hm³⁴ joh⁴³ a²lo³ don⁵; quie¹ juah⁴ne³ la⁴ne³, jon³ li⁴naih⁵ a²lo³, jon³ tain³⁴ o¹bein² jian³ si⁵hain⁴ a²lo³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","I⁴jon³ hniah³ ro³⁴i³ o¹bein² hm³⁴ joh⁴³ a²lo³ hm²³, canh⁴a² i¹con³ a⁵sia³ i⁴lei⁴ o¹bein² a⁵ga⁴ a²lo³. ");
INSERT INTO cucNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Conh⁴liah⁴ i¹jan³ a³hangh² o¹bein² don⁵ juah⁴ i⁴hnie³⁴a² chie³ o¹bein² hm³⁴, quie¹ juah⁴i³: “Eu⁴a² re³ o¹bein² don⁵.” ");
INSERT INTO cucNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jian³ liah⁴ con³ jm² sa⁴júan³i³ ta¹ hein² Jesús jeu³ je¹ i²ti²jnia², jian³ ti²queun²³ chie³ quian¹i³ o¹m⁴ trigo, jian³ ti²he²³i³ i⁴queuh³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","I² jon³ a⁴juah⁴ co⁴meih³ fariseo tionh²: ―¿E⁴le³⁴ ti²júanh³ˉ³ i⁴sa⁴haih¹ li⁴júanh²ˉ³ jm² ne³⁴, jm² sa⁴júan³i³ ta¹? ");
INSERT INTO cucNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―¿O⁴ a⁵sia³ ma³a⁴heih³ˉ³ liah⁴ a⁴júan⁴ re¹ Da³vei²³, con³ma²ra⁵cúanh⁴³i³ tionh² jian²³i³ a³ma²jian²³i³? ");
INSERT INTO cucNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Quie¹ a⁴hei³⁴i³ jauh³² quieh¹ Jon⁴dai¹, a⁴queuh³i³ a²hei⁴³ñih¹ hen² i⁴sa⁴ra³cúa²³ i⁴queuh⁴³ chie³ta²chie³, quie¹ jmah³ m³chie³pa² tain⁴³ queuh³; jian³ a⁴guenh⁴ Da³vei²³ la⁴jang³⁴ a³ma²jian²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jian³ a⁴juah⁴i³ liah⁴: ―Quie¹ A³a⁴lang³⁴ Chie³ hain⁴ lang⁴³ a³júan³ heih⁴³ liah⁴ ra³cúa²³ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Jian³ jm² seg³⁴, jm² sa⁴júan³i³ ta¹, jon³ a⁴hei³⁴ Jesús cuah³ judío i²a⁴heh³i³ chie³. Jian³ ua²cua⁴³ jan³ a³ñih³ a³lo³ si¹cúa³ jo³² ta⁵chie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jian³ a²teg²³ quian¹ lai²³ jian²³ fariseo tionh², ti²tan³i³ i²con²³ Jesús, niah³²ˉ¹ o⁴ júan³⁴i³ i⁴huan⁴ quieh¹ a³chieh¹ jm² sa⁴júan³i³ ta¹, canh⁴a² la⁴jon³ li⁴hnang⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","I² Jesús ne⁵, ñi³i³ co³hei²tsei³ i⁴ti²júan³ a³hain⁴ tionh², ma²jon³ a⁴sagh⁴³i³ a³ñih³ a³lo³ si¹cúa³ hain⁴, a⁴juah⁴i³: ―Ra⁴hang³², no³ to⁵chieh³² la³. Ma²jon³ ra⁴hang³² a³ñih³ hain⁴, a⁴no³i³ to⁵chieh³². ");
INSERT INTO cucNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma²jon³ a⁴juah⁴ Jesús i²con²³ a³hain⁴ tionh² liah⁴: ―Hno⁵ˉ⁵ ŋang¹ˉ⁴ con³ i²conh²ˉ³ tionh²ˉ³. ¿O⁴ ra³cúa²³ i⁴júan³⁴i³ i⁴tsei³⁴ jm² sa⁴júan³i³ ta¹, jian³ o⁴ i⁴hlagh³²? ¿Jian³ o⁴ ra³cúa²³ i⁴tainh⁴³i³ jan³ chie³, jian³ o⁴ i⁴jŋangh³i³? ");
INSERT INTO cucNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","I² con³ma²a⁴jen³ Jesús a³tionh² co⁴la⁴lagh⁵ hain⁴, jon³ a⁴sagh⁴³i³ a³ñih³ hain⁴: ―Sieh¹ si¹cúah³. I² con³ma²a⁴júan⁴i³ la⁴jon³, jon³ a⁴lag³⁴ si¹cúa³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","I² la⁴jang³⁴ a³hain⁴ tionh², ta² a⁴jain³⁴ tsei⁴³i³, jon³ a⁴júanh⁴i³ húan⁴i³ tionh²i³, a⁴hnoh³i³ liah⁴ li⁴júan³⁴i³ hlagh³² i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jian³ jm² jon³ ŋo³⁴ Jesús con³ mah⁴ i⁴ua⁵mh²i³ Jon⁴dai¹, jian³ la⁴tan² húa²³ jon³ a⁴mh³i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","I² con³ma²si⁵joh¹, jon³ a⁴teh³i³ la⁴jang³⁴ chie³ quian¹ jian³ a⁴quianh⁴³i³ quia⁵teun⁴ jen² a³hain⁴ tionh², a³a⁴teh³i³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","a³la³ tionh²: Si²úan¹, a³hain⁴ a³ma⁴sain³i³ Pe³², jian³ Dre¹ reunh¹i³, jian³ Jacobo liah⁴ jian²³ Juan²³, Lei³² jian²³ Bartolomé, ");
INSERT INTO cucNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","jian³ Ma³te³² ne³, To³ma²³ ne³, jian³ Jacobo a³jon⁴³ Alfeo ne³, jian³ Si²úan¹ a³hain⁴ a³teh²i³ A³tyeih⁴³, ");
INSERT INTO cucNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","jian³ Judas a³reunh¹ Jacobo, jian³ Judas Iscariote, a³hain⁴ a³a⁴cúanh³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","I² con³ma²jonh³ Jesús i⁴ñei²i³ mah⁴ jian²³ chie³ quian¹, jon³ a⁴jian⁴i³ con³ o⁵m³. Jian³ jeun⁴³ chie³ ti²tionh² jian²³ chie³ quian¹i³ a³a⁵han² la⁴tan² húa³⁴ Judea, jian³ jeu³ Jerusalén jian³ a³sian³ la⁴can²³ i²jm¹ jm³ñih¹ jeu³ Tiro jian³ Sidón, a³ma³a⁴tyie³⁴ i⁴nau³⁴i³ jau²³ quieh¹ Jesús, jian³ canh⁴a² júan³⁴i³ i⁴huan⁴ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jian³ a⁴huan⁴ quieh¹ la⁴jang³⁴ a³ti²can²³ ma²eu⁴³ i⁴júan³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jian³ la⁴jang³⁴ chie³ hnie³⁴ tei³⁴i³ si¹cúa³ he³² Jesús, quie¹ ta⁵la⁴ júan³ Jesús i⁴huan⁴ quieh¹ la⁴jang³⁴ con⁴juah⁴ ua³pei⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jon³ a⁴jen³ Jesús chie³ quian¹ tionh², a⁴sagh⁴³i³: ―Ta² tsei³⁴ jm² li⁴renh³ˉ³ tionh²ˉ³ a³ti⁴ñeih³ˉ³ tieh²la³, quie¹ hnei³pa² tainh⁴³ˉ³ tionh²ˉ³ hanh⁵ˉ³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Ta² tsei³⁴ jm² li⁴renh³ˉ³ a³cuanh⁴³ˉ³ tieh²la³, quie¹ li⁴canh⁴³ heinh¹ˉ³ ta⁵cang³. ’Ta² tsei³⁴ jm² li⁴renh³ˉ³ a³ti²hoh⁵ˉ³ tieh²la³, quie¹ jia²³ jm² lei⁴ si³hyonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Ta² tsei³⁴ jm² li⁴renh³ˉ³ la⁴teg⁴i² hie²³ hnei³ chie³, jian³ la⁴teg⁴i² húa⁵i³ hnei³ jen²i³ tionh², jian³ la⁴teg⁴i² sag⁵i³ hnei³ jau²hlagh³², jian³ tei⁴³i² so⁵jai¹i³ hnei³ nei² quieh¹ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jm² jon³ hniah³ júanh²ˉ³ si³hyonh³ˉ³ hlion⁴ mai²³ tionh²ˉ³, quie¹ eu⁴³ hlion⁴ ma⁵hmah³² Jon⁴dai¹ quianh³ˉ³ tionh²ˉ³ ñi⁴jeu⁵, quie¹ la⁴ne³ a⁴júan⁴ jmai³sie²³ a³hain⁴ tionh² i²con²³ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ jm² ma³ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Jian³ ta² jeuh²ˉ³, hnei³ tionh²ˉ³, a³jlanh², quie¹ ma³a⁴quianh³ˉ³ co³hyon²³tsei³ quianh³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Jian³ ta² jeuh²ˉ³ tionh²ˉ³ a³si²canh³ heinh¹ˉ³ tieh²la³, quie¹ li⁴cuanh⁴³ˉ³ ta⁵cang³. ’Jian³ ta² jeuh²ˉ³ tionh²ˉ³ a³ti²ŋengh⁴ˉ³ tieh²la³, quie¹ hoh³²ˉ³ i⁴hei¹ queuh³ hoh⁴³ˉ³ ta⁵cang³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Jian³ ta² jeuh²ˉ³ tionh²ˉ³ liah⁴ tei⁴³i² hleh² re³ la⁴jang³⁴ nei² quianh³ˉ³ tionh²ˉ³, quie¹ la⁴ne³ a⁴hleh⁴ jmai³sie²³i³ nei² quieh¹ la⁴jang³⁴ a³a⁴juah⁴ hleh² jau²³ quieh¹ Jon⁴dai¹ a³ta³jaun²³ ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Jian³ la⁴jang³⁴ hnei³ a³ti²nauh³ˉ³, jeu³⁴ˉ⁴ hnei³ tionh²ˉ³: Ma⁴hno³² hnei³ a³hnie³⁴ júanh¹ hnei³, jian³ júan² hnei³ i⁴tsei³⁴ i²con²³ a³hie²³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Saih³² hnei³ jau²³ tsei²³ a³sag⁵ hnei³ jau²hlagh³², jian³ mh³² hnei³ Jon⁴dai¹ nei² quieh¹ a³hleh² hlagh³² nei² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jian³ juah⁴ne³ quein³i³ co³jo³² ma³mah²ˉ³, hai⁴ hnei³ ta⁵ca³jo³² liah⁴; jian³ juah⁴ne³ sian³ a³hnie³⁴ qui³⁴ a²hmh³ tsei²³ coh⁵, cúah³²i³ hnei³ liah⁴ma³jian²³ a²hmh³ heinh²ˉ³ naih⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jian³ a³hain⁴ a³sia³ i⁴m²³ i²conh²ˉ³, cúah³²i³ hnei³; jian³ a³hain⁴ a³con²³ i⁴quianh³ˉ³, a⁵m⁴ hnei³ i⁴cúah³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jian³ liah⁴i² hnoh³ˉ³ júan³⁴ chie³ i⁴tsei³⁴ i²conh²ˉ³ tionh²ˉ³, la⁴ne³ hniah³ júanh²ˉ³ i²con²³i³ liah⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Quie¹ juah⁴ne³ ma⁵hnoh³²ˉ³ jmah³ a³hnie³⁴ hnei³ tionh²ˉ³, ¿o⁴ eu⁴³ re³ júanh³ˉ³, lainh⁴ˉ³? Quie¹ la⁴ne³ júan³ chie³ a³ti²ren³ chie³² tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Jian³ juah⁴ne³ júanh³ˉ³ i⁴tsei³⁴ i²con²³ jmah³ a³júan³ i⁴tsei³⁴ i²conh²ˉ³ tionh²ˉ³, ¿o⁴ eu⁴³ re³ júanh³ˉ³, lainh⁴ˉ³? Quie¹ la⁴ne³ júan³ chie³ a³ti²ren³ chie³² tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jian³ juah⁴ne³ tyih³ˉ³ o¹cau³² i²con²³ jmah³ chie³ a³hain³² hoh⁴³ˉ³ cúah³, ¿o⁴ eu⁴³ re³ júanh³ˉ³, lainh⁴ˉ³? Quie¹ la⁴ne³ tyi³ a³ti²ren³ chie³² liah⁴ i²con²³ a³ti²ren³ chie³² reunh¹, i⁴hain³² tsei⁴³i³ hyeih³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","I² la⁴ne³ ne⁵, hniah³ ma²hnoh³²ˉ³ a³hie²³ hnei³, jian³ júan² hnei³ i⁴tsei³⁴, jian³ tyi² hnei³, i⁴sa⁴hain³² hoh⁴³ˉ³ jieh⁴. Quie¹ Jon⁴dai¹pa² ma⁵hmah³² quianh³ˉ³ hlion⁴ mai²³, jian³ lei³ jnia⁴ la⁴ne³ langh⁴³ˉ³ jon⁴³segh³² Jon⁴dai¹ Júanh⁴³; quie¹ tsei³⁴ tsei⁴³i³ i²con²³ chie³ hlangh² jian³ i²con²³ a³sa⁴cúa²³ ti²hmah³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","I² la⁴ne³ jon³ júan² hnei³ i⁴ñeih⁴ hoh⁴³ˉ³ la⁴jon³ liah⁴i² ñeih⁴ tsei⁴³ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’A⁵tyan⁴³ hnei³ hei²³ chie³, canh⁴a² sa⁴can³⁴ Jon⁴dai¹ jau²chie⁴³ i²conh²ˉ³. A⁵queih⁴ hnei³ heih⁴³ i²con²³ chie³, canh⁴a² sa⁴gmh⁴ heih⁴³ i²conh²ˉ³. Hain⁴³ hnei³ chie³² quieh¹ chie³, canh⁴a² hain³⁴ Jon⁴dai¹ chie³² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cúa² hnei³ i²con²³ chie³, canh⁴a² cúa³⁴ Jon⁴dai¹ i²conh²ˉ³, ro³⁴i³ re³ joh⁴³ a²to³lo³ quianh³ˉ³ i⁴re³ si²tieh¹ jian³ i¹so⁵haih¹. Quie¹ cúa³⁴ Jon⁴dai¹ la⁴conh⁴ cúah³ˉ³ i²con²³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","I² jon³ a⁴can³⁴ Jesús con³ jau²³, a⁴juah⁴i³: ―¿O⁴ li⁴ua⁵jo³² jan³ a³taun³², i⁴ua⁵jan³²i³ a³taun³² sang³⁴, lainh⁴ˉ³? ¿O⁴ a⁵sia³ tianh⁵i³ to³ li⁵uan⁴i³ la⁴jon³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","I¹jan³ a³ma³tang²³ sa⁴ŋang⁴ liah⁴i² ŋang⁴ a²teg²³ quian¹i³. I² tei⁴³i² a⁴toh⁴ ma³tang²³i³, jon³ tyie¹i³ lang⁴³i³ liah⁴i² lang⁴³ a²teg²³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Liah⁴ cúan²³ jeh⁴ˉ³ con³ ma²qui³ peih¹ i⁴hei¹ m⁴nei² a³m⁵cu³ reunh³ˉ³, jian³ sa⁴jeh⁴ˉ³ con³ teinh³² hma³ pa¹ hei¹ m⁴mah²ˉ³ húanh⁴³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Jian³ liah⁴ li⁴jeuh³²ˉ³ a³m⁵cu³ reunh³: “Hnei³ goh³ quian³⁴ˉ⁴, cúa² jeu³ ua²tyi¹ˉ⁴ ma²qui³ hei¹ m⁴mah²ˉ³ ne³”? Jian³ sa⁴jeh⁴ˉ³ teinh³² hma³ pa¹ hei¹ quianh³ˉ³ húanh⁴³ˉ³ ne⁵. Hnei³ chie³ a³lain⁴ ni²taih⁴³, tyi² hnei³ ñeih³²jia⁴³ teinh³² hma³ i⁴hei¹ m⁴mah²ˉ³ húanh⁴³ˉ³, ma²jon³ li⁴jeh²ˉ³ re³ i⁴tyih²ˉ³ ma²qui³ i⁴hei¹ m⁴nei² a³m⁵cu³ reunh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Quie¹ a²hma³ tsei²³ sa⁴hag³ o¹m⁴ hlagh³², jian³ a²hma³ hlagh³² liah⁴ sa⁴hag³ o¹m⁴ tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Quie¹ conh⁴ con³ nai² a²hma³ li⁴cuh²i³ con⁴juah⁴ o¹m⁴ i⁴hag³; quie¹ sa⁴lo²³ o¹m⁴jyi³ juah⁴ i⁴hag³ a²hma³ ton⁴³, conh⁴liah⁴ sa⁴queun²³i³ o¹m⁴ ya¹gm³jeh² juah⁴ i⁴hag³ o¹sieh³² a²ton⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jian³ la⁴ne³ chie³ liah⁴, la⁴jang³⁴ chie³ tsein²³ hleh² jau²³ tsei²³ quie¹ ta⁵la⁴ júan³i³ co³hei²tsei³ tsei²³ naih⁵ ni²tsei⁴³i³; jian³ la⁴jang³⁴ chie³ hlangh² liah⁴, hleh²i³ jau²hlagh³² quie¹ ta⁵la⁴ júan³i³ co³hei²tsei³ hlagh³² naih⁵ ni²tsei⁴³i³. Quie¹ la⁴conh⁴ tei⁴³ i⁴jia²³ m⁴tyi⁴ quieh¹i³, húa²³ ho³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿E⁴le³⁴ teh⁵ˉ³ jnia⁴, “Se³ño²³ tyein²”, jian³ sa⁴júanh³ˉ³ i⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Quie¹ juah¹ˉ⁴ liah⁴ lang⁴³ a³hain⁴ a³jia²³ i²con²³ˉ⁵ a³nau³ jau²³ quien⁴ˉ⁴ i⁴ma³tei⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lang⁴³i³ liah⁴i² lang⁴³ jan³ chie³ a³júan³ a²hnei⁴³, a⁴cag³⁴i³ ñeih³² húa³⁴ i⁴jeuh³, a⁴seih⁴i³ ta³jmh¹ a²hnei⁴³ nei² a²caun². I² con³ma²ja³⁴ jm³ júah², jon³ a⁴hlia⁴ a²hnei⁴³ jon³, jian³ i¹ sa⁴a⁴jai³, quie¹ si²ho³ nei² a²caun². ");
INSERT INTO cucNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jian³ a³hain⁴ a³nau³ jau²³ quien⁴ˉ⁴ jian³ sa⁴ma³tei⁵i³, lang⁴³i³ liah⁴i² lang⁴³ jan³ chie³ a³a⁴júan⁴ a²hnei⁴³ quieh¹ nei² húa³⁴ lang³⁴ i⁴sa⁴si²quian³ ta³jmh¹. I² con³ma²a⁴hlia⁴ jm³ júah², jon³ a⁴quegh³ a²hnei⁴³ jon³, a⁴cúan⁴, ua⁵hain⁴ o³tan². ");
INSERT INTO cucNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Con³ma²a⁴toh⁴ a⁴hleh⁴ Jesús la⁴jeg³⁴ jau²³ jon³ i²con²³ a³jeu³ a³ti²nau³, jon³ a⁴tyie³⁴i³ jeu³ Capernaum. ");
INSERT INTO cucNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","I² jon³ ra³chieh¹ jan³ a³cúa²³ cúa³tag³² i²con²³ jan³ jeu³² a²hlie⁴, a³ma³o¹jaun⁴, a³hain⁴ a³eu⁴³ hnio³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","I² con³ma²a⁴nau⁴ jeu³² a²hlie⁴ i⁴tya²³i³ jau²³ nei² quieh¹ Jesús, jon³ a⁴sain⁴i³ co⁴meih³ a³don⁵ ma⁴³teg²³ quian¹ judío tionh² i⁴ua⁵mh²i³ Jesús i⁴chie³⁴i³ si⁵júan⁴i³ i⁴huan⁴ quieh¹ a³cúa²³ cúa³tag³² quian¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jon³ ua⁵han²i³ tionh² i²con²³ Jesús, jian³ a⁴mh³i³ i⁴jang³⁴ tsei⁴³i³, a⁴juah⁴i³: ―Eu⁴³ tsein³⁴ chie³ jeu³² a²hlie⁴ hain⁴. I⁴jon³ haih¹ ma²honh³²i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Quie¹ hnio³⁴i³ la⁴jang³⁴ a³co³²ˉ¹. Jian³ a⁴júan⁴i³ cuah³ quian⁴ jnie³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jon³ ŋo³⁴ Jesús jian²³ a³hain⁴ tionh². I² con³ma³o¹tyie¹i³ jauh³² quieh¹ a³hain⁴, jon³ a⁴sain⁴ jeu³² a²hlie⁴ hain⁴ co⁴meih³ a³ñi³reunh¹ a³ua⁵saih¹ Jesús jau²³ la³: ―Hnei³ Se³ño²³, ua²leg⁴³pa² júah³, quie¹ sa⁴haih¹ i⁴niah²ˉ³ jauh³² quien⁴ˉ⁴; ");
INSERT INTO cucNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","jian³ sa⁴haih¹ i⁴nai³²ˉ⁴ húan⁵ ni¹jen³²ˉ⁴ hnei³. Eu⁴³a² re³ heih⁴³pa² júanh²ˉ³, canh⁴a² huan⁴ quieh¹ a³cúa²³ cúa³tag³² quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quie¹ jnia⁴ liah⁴, sian³ a³júan³ heih⁴³ i²con²³ˉ⁵, jian³ tionh² a²hlie⁴ a³júan³⁴ˉ⁴ heih⁴³ i²con²³ liah⁴. Quie¹ tei⁴³i² jeu³⁴ˉ⁴ jan³, “cua³”, jon³ chie²³i³; jian³ tei⁴³i² jeu³⁴ˉ⁴ i²jan³, “nia³”, jon³ jia²³i³; jian³ tei⁴³i² jeu³⁴ˉ⁴ a³cúa²³ cúa³tag³² quian³⁴, “júan² i⁴ne³”, jon³ júan³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","I² con³ma²a⁴nau⁴ Jesús jau²³ jon³, ta² co³ a⁴jainh⁴³i³, jon³ a⁴jainh³i³ nei², a⁴sagh⁴³i³ la⁴jang³⁴ a³ya¹han² coh⁵cah³²i³: ―I⁴chie⁴³pa² juah³ˉ⁴, i¹ jen² a³jeu³ Israel sa⁴ma³a⁴chianh³²ˉ⁴ chie³ a³hain⁴ hlion⁴ i²con²³ jnia⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","I² con³ma²a⁴tyanh³ a³sain² hain⁴ tionh² jauh³², jon³ a⁴jen³i³ a³cúa²³ cúa³tag³² hain⁴ i⁴ma³a⁴huan⁴ quieh¹i³, i⁴ma²chieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jian³ con³ma²a⁴leg³⁴ jon³, jon³ ŋo³⁴ Jesús con³ jeu³ sain³ Naín, jian³ ua⁵han² jeun⁴³ chie³ quian¹i³ jian²³i³ liah⁴, jian³ jeun⁴³ chie³ sang²³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","I² con³ma²a⁴tyie³⁴ Jesús hloh³² o²hnei³² si³hei⁴i³ je¹jeu³ jon³, jon³ ti²jian³i³ jan³ a³jaun² a³si⁵hon⁴³i³, jan³ hain⁴ ma²sian³ i²con²³ sie²³, a³lang⁴³ a³m⁴ hnang⁴. Jian³ jeun⁴³ chie³ a³sian³ jeu³ jon³ liah⁴ ti²ma³reunh¹ quieh¹ a³m⁴ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","I² con³ma²a⁴je³ Se³ño²³ quieh¹ a³m⁴ hnang⁴ hain⁴, jon³ joh³ ñei⁴ tsei⁴³i³ i²con²³i³, a⁴sagh⁴³i³: ―A⁵hoh⁴³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jon³ ŋo³⁴ Jesús hlonh² a³jaun², a⁴sanh³i³ a²cúa⁴³; jian³ a⁴jian⁴ a³hain⁴ tionh² a³ma²ti²jian³ a³jaun². Jon³ a⁴sagh⁴³i³ a³jaun²: ―Hnei³ a³maih², jeu³⁴ˉ⁴ hnei³ i⁴noh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jon³ a⁴cua⁴ a³jaun², jian³ ma⁴lie⁵i³ a⁴hleh⁴i³, ma²jon³ a⁴cúanh³ Jesús i²con²³ sie²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ta² yi⁴hang³² la⁴jang³⁴ a³hain⁴ tionh², jian³ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹, a⁴juah⁴i³: ―Tieh²la³ ma³cuan²³ jan³ a³júanh⁴³, a³sain² quian¹ Jon⁴dai¹ jen² jnia¹. Conh⁴liah⁴ a⁴juah⁴i³: ―Ma³cuan²³ Jon⁴dai¹ i⁴ma⁵hon³²i³ a³jeu³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jian³ ta² ta⁴tsei¹ jau²³ nei² quieh¹ Jesús la⁴tan² húa³⁴ Judea jian³ la⁴tan² hloh³² jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon³ a⁴tya⁴ chie³ quian¹ Juan²³ jau²³ i²con²³i³ la⁴jeg³⁴ i⁴júan³ Jesús. Jon³ a⁴teh³i³ on³⁴ chie³ quian¹, ");
INSERT INTO cucNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a³a⁴sain⁴ i²con²³ Jesús a³ua⁵ŋang⁴: ―¿O⁴ hnei³ langh⁴³ A³lion³ Chie³ a³ma²jia²³ hain⁴, jian³ o⁴ hniah³ jian³² jnie³² a³sang²³? ");
INSERT INTO cucNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","I² con³ma²a⁴tyie³⁴ a³hain⁴ tionh² i²con²³ Jesús, jon³ a⁴juah⁴i³: ―Juan³ Tei³²pa² a⁴sai⁴ jnie³² i⁴ni³ŋangh³² jnie³² hnei³: ¿O⁴ hnei³ a³ma²jia²³, jian³ o⁴ hniah³ jian³² jnie³² a³sang²³? ");
INSERT INTO cucNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jian³ o²ra³ jon³ si²júan³ Jesús i⁴huan⁴ quieh¹ jeun⁴³ a³chieh¹ jian³ a³ti²can²³ ma²eu⁴³, jian³ a⁴húa⁴³i³ m⁴tyi⁴ hlagh³², jian³ a⁴júan⁴i³ a⁴jnia⁵ m⁴nei² jeun⁴³ a³taun³². ");
INSERT INTO cucNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jon³ a⁴juah⁴ Jesús i²con²³ a³hain⁴ tionh², a⁴jainh³i³ jau²³: ―Cua³ yi⁴saih³²ˉ³ Juan²³ la⁴jeg³⁴ i⁴a⁴jeh¹ˉ³ jian³ i⁴a⁴naih³ˉ³: i⁴jnia⁵ m⁴nei² a³taun³², i⁴ŋeng²³ a³tein⁴, i⁴huan⁴ quieh¹ a³lang⁴³ chie² i⁴jyih² o¹ŋeu⁴³, jian³ i⁴naih¹ a³teun³, jian³ i⁴jainh¹ a³jaun², jian³ i⁴si³hleh² jau²³ tsei²³ quieh¹ Jon⁴dai¹ i²con²³ a³ti⁴ñei³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jian³ ta² tsei³⁴ jm² ren³ a³sa⁴hieh¹ jau²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","I² con³ma²ua⁵han² a³sain² hain⁴ tionh² i²con²³ Juan²³, jon³ ma⁴lie⁵ Jesús a⁴hleh⁴ nei² quieh¹ Juan²³ i²con²³ a³jeu³, juah⁴i³: ―¿Henh⁴ ni²jeh¹ˉ³ tionh²ˉ³ ta⁵i²a⁵sian⁴³ a³sian³ jon³? ¿O⁴ con³ a²ma³cu⁴³ si²can⁵ tyi⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Jian³ o⁴ henh⁴ ñeih²ˉ³ ni²jeh¹ˉ³? ¿O⁴ ni²jenh³²ˉ³ jan³ a³ñih³ a³hein² a²hmh³ jlanh²? Quie¹ a³tionh² a²hmh³ jlanh² jian³ a³tsei³⁴ sian³, tionh² jauh³² quieh¹ re¹pa². ");
INSERT INTO cucNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","I² jon³ ne⁵, ¿henh⁴ ni²jeh¹ˉ³? ¿O⁴ ni²jenh³²ˉ³ jan³ a³sain² quian¹ Jon⁴dai¹? I⁴chie⁴³pa², quie¹ lang⁴³i³, jian³ eu⁴³ pi¹ júanh⁴³i³ la⁴conh⁴a² a³sain². ");
INSERT INTO cucNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Quie¹ lang⁴³ hei⁴i³ a³ra³sag² Ma²jyi³ quieh¹ Jon⁴dai¹ nei² quieh¹, ra³juah⁴: Jeh³², sain¹ˉ⁴ a³sain² quian³⁴ ta⁵mah²ˉ³, a³hain⁴ a³júanh³ jeu³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jian³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ liah⁴, eu⁴³ júanh⁴³ Juan³ Tei³² la⁴conh⁴a² la⁴jang³⁴ a³sain² a³ma³ra⁵sian³. I² a³hain⁴ a³peih¹ jen² a³tionh² naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, júanh⁴³i³ la⁴conh⁴a² Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","I² con³ma²a⁴nau⁴ la⁴jang³⁴ a³jeu³ jian²³ a³can²³ hmah¹ jau²³ i⁴a⁴hleh⁴ Juan²³, jon³ a⁴son⁴i³ jm³ i⁴a⁴sie⁴³ Juan²³, i⁴ma⁴jnia³i³ i⁴tsei³⁴ júan³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","I² chie³ fariseo tionh² jian³ a²teg²³ quian¹ lai²³, a⁵sia³ a⁴hyein⁴³i³ júan³⁴i³ i⁴hnie³⁴ Jon⁴dai¹, quie¹ sa⁴hnie³⁴i³ sie⁵ Juan²³ jm³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jon³ a⁴juah⁴ Se³ño²³ liah⁴: ―¿Liah⁴a² li⁴juah¹ˉ⁴ liah⁴ lang⁴³ chie³ a³sian³ tieh²la³? ");
INSERT INTO cucNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Quie¹ lang⁴³i³ liah⁴i² lang⁴³ si³maih² peih¹ a³ti²tionh² je¹hmah¹ a³ti²hlenh⁴³ jon²reunh¹, ti²hleh²i³ tia⁴: “Jeh³², a⁴jai³² jnie³² a²lau⁴³ i²conh²ˉ³ tionh²ˉ³, i² a⁵sia³ jan¹ ñeih²ˉ³ tionh²ˉ³; jian³ a⁴he² jnie³² seun²³ quieh¹ a³jaun², jian³ a⁵sia³ a⁴hoh³²ˉ³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Quie¹ cuan³⁴ Juan³ Tei³² i⁴sa⁴queuh³i³ a²hei⁴³, a⁵ga⁴ hangh²i³ o¹bein², i² juah⁴ˉ³ tionh²ˉ³ ne⁵: “A³quian³ m⁴tyi⁴ hlagh³².” ");
INSERT INTO cucNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jian³ cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ a³queuh³ a³hangh², i² juah⁴ˉ³ tionh²ˉ³: “Lang⁴³ a³ñih³ ne³ a³jlen⁴ a³hangh² jm³, a³ñi³reunh¹ a³can²³ hmah¹ jian³ a³ti²ren³ chie³² tionh².” ");
INSERT INTO cucNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Quie¹ lei³ jnia⁴ i⁴ŋang⁴ Jon⁴dai¹ con⁴juah⁴ i⁴ma³jnia³ si³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jon³ a⁴te⁴ jan³ fariseo, a⁴teh³i³ Jesús i⁴si⁵queuh³ a²hei⁴³ jian²³i³; i² con³ma²a⁴tyie³⁴ Jesús jauh³² quieh¹ fariseo hain⁴, jon³ a⁴cua⁴i³ mesa. ");
INSERT INTO cucNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","I² con³ma²ra⁵ñi³ jan³ a³m⁴ sa⁴jmh³ a³sian³ jeu³ jon³ i⁴ua²queuh³ Jesús hei⁴³ jauh³² quieh¹ fariseo, jon³ a⁴tyie³⁴i³, quian³i³ con³ m⁴tsai³² peih¹, i⁴leg⁴³ a²caun² alabastro, si²canh² o¹jm³no¹ ma³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jon³ a⁴cua⁴i³ coh⁵cah³² Jesús hloh³² he⁴³ tag³² i⁴hoh⁵i³, jian³ a⁴taun³ jm³hñieh³² quieh¹i³ nei² si¹tag³² Jesús, jian³ a⁴sei³⁴i³ jeu³ o¹tyi² hña³; jian³ a⁴seinh⁴i³ si¹tag³²i³, jian³ a⁴saih³i³ o¹jm³no¹ ma³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","I² con³ma²a⁴je³⁴ fariseo a³a⁴te⁴ quieh¹i³ hain⁴, jon³ a⁴júan⁴i³ co³hei²tsei³ hña³, lain⁴i³: “Juah⁴ne³ i⁴chie⁴³ ma²lang⁴³ a³ne³ jan³ a³sain² quian¹ Jon⁴dai¹, jon³ ma²ñi³i³ hain³ nai² a³m⁴ ne³ a³ua²sag²³ si¹tag³²i³, quie¹ a³m⁴ sa⁴jmh³pa² ne³.” ");
INSERT INTO cucNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","I² jon³ a⁴juah⁴ Jesús i²con²³ Si²úan¹: ―Hnei³ Si²úan¹, sia³ con³ jau²³ hno⁵ˉ⁵ jeu¹ˉ⁴ hnei³. I² jon³ a⁴juah⁴ Si²úan¹: ―Hnei³ A²teg²³, juah¹ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jon³ a⁴juah⁴ Jesús: ―On³⁴ chie³ ma²ren³ o¹cau³² quieh¹ jan³ a³tyi³ o¹cau³². Jan³ ma²ren³ co³jo³² mai²³ o¹cau³² tie³, jian³ i²jan³ ma²ren³ to⁴lo⁵quia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","I² sa⁴sia³ i⁴li⁴cúah³i³ tionh² ne⁵. I² a³a⁴tyi³ hain⁴ ne⁵, a⁴ai⁴i³ hmah¹ jon³ quieh¹ a³hain⁴ tionh² li⁵uan⁴. I² jon³ ne⁵, hno⁵ˉ⁵ juah²ˉ³, ¿hain³ conh⁴ li⁵uan⁴ hain⁴ tyein² hnie³⁴ quieh¹i³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","I² jon³ a⁴ŋang⁴ Si²úan¹, a⁴juah⁴i³: ―Lain³⁴ jnia⁴, a³hain⁴pa² a³a⁴ai⁴ hlion⁴ quieh¹. I² jon³ a⁴juah⁴ Jesús: ―Ta² re³ a⁴juah¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jon³ ua⁵lang⁴ Jesús, a⁴jen³i³ a³m⁴ hain⁴, jian³ a⁴sagh⁴³i³ Si²úan¹: ―¿Jenh⁵ˉ³ a³m⁴ la³, liah²? Quie¹ con³ma²a⁴heu³⁴ˉ⁴ jauh³² quianh³ˉ³, a⁵sia³ o¹jm³ a⁴cúah²ˉ³ juah⁴ i⁴raunh²ˉ⁵ si¹tag³⁴; i² a³m⁴ la³ ne⁵, ma³a⁴tain⁴i³ jm³hñieh³² quieh¹ nei² si¹tag³⁴ˉ⁴, jian³ a⁴ma⁴queinh⁴i³ jeu³ o¹tyi²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jian³ liah⁴ a⁵sia³ a⁴seinh²ˉ³ nei³⁴ˉ⁴ i⁴ma⁴coh³²ˉ³ jnia⁴; i² a³la³ ne⁵, liah⁴ma²a⁴heu³⁴ˉ⁴ jauh³² quianh³ˉ³, ua²seinh²i³ si¹tag³⁴ˉ⁴ i⁴sa⁴jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jian³ a⁵sia³ o¹jm³no¹ a⁴jñeih⁴³ˉ³ ma³tyi³⁴ˉ⁴; i² hei⁴i³ ne⁵, a⁴saih³i³ o¹jm³no¹ ma³jeu³ si¹tag³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","I⁴jon³ jeu³⁴ˉ⁴ hnei³ i²quie¹ i⁴hlion⁴ chie³² a⁴jlenh³ quieh¹i³, jon³ hnie³⁴i³ jnia⁴ hlion⁴; jian³ a³hain⁴ a³jlenh³ meih³ quieh¹, meih³pa² ma³jnia³i³ i⁴hnie³⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jon³ a⁴juah⁴ Jesús i²con²³ a³m⁴ hain⁴: ―Ma³a⁴jlenh³ chie³² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","I² jon³ a⁴júanh⁴ la⁴jang³⁴ a³tionh² mesa hain⁴ jian²³i³, a⁴júanh⁴i³ húan⁴i³: ―¿Hain³ ga⁴ chie³ ne³, liah²? Hleh²i³ jau²³ i⁴hain²³i³ chie³² quieh¹ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","I⁴jon³ a⁴juah⁴ Jesús i²con²³ a³m⁴ hain⁴: ―Ma³a⁴lonh⁴ˉ³ quie¹ ra⁵hainh⁴ˉ³; cuanh³ quianh³ si³hyonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Con³ma²ua⁴jeu³² jon³, jon³ a⁴ŋeng⁴ Jesús la⁴jeg³⁴ jeu³ cah² jian³ la⁴jeg³⁴ jeu³ peih¹ liah⁴, hleh²i³ jau²³ tsei²³ liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. Jian³ jian²³i³ quia⁵teun⁴ chie³ quian¹, ");
INSERT INTO cucNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","jian²³ co⁴meih³ a³m⁴ liah⁴ a³hain⁴ a³ma²a⁴júan⁴ Jesús i⁴a⁴huan⁴ quieh¹, a³ma²ti²quian³ m⁴tyi⁴ hlagh³² jian³ a³ma²ti²chieh¹: je¹ jon³ hein² Ma³rei², a³hain⁴ a³teh²i³ Ma³da³len², a³a⁴húa³ quie³⁴ m⁴tyi⁴ hlagh³² quieh¹, ");
INSERT INTO cucNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","jian³ A²juan² liah⁴, a³m⁴ quian¹ Chuza a³hie³ la⁴jeg³⁴ i⁴quieh¹ Herodes, jian³ hein² A¹san² liah⁴, jian³ jeun⁴³ a³m⁴ sang³⁴ a³ma³ho³² quieh¹ Jesús con⁴juah⁴ i⁴sia³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jon³ a⁴ŋangh³ jeun⁴³ lio⁴mai²³ chie³ a³a⁵han² conh⁴ con³ jeu³ i²con²³i³; jon³ a⁴can³⁴ Jesús con³ jau²³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jan³ chie³ ŋo³⁴ ua⁵jñi³ o¹m⁴. I² con³ma²si²jnei³i³, jon³ a⁴jyih³ co⁴meih³ o¹m⁴ hloh³² ho³²jeu³, jon³ a⁴he⁴soh³ chie³. I² jon³ a⁵han² jon⁴³tan²³, a⁴queuh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Conh⁴liah⁴ a⁴jyih³ co⁴meih³ je¹ a²caun²; jian³ a⁴hya³, jon³ ra⁵quein³ quie¹ sa⁴cuh⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Conh⁴liah⁴ a⁴jyih³ co⁴meih³ je¹ a²ton⁴³, jian³ ra⁵jang¹ co⁴chia³ jian²³ a²ton⁴³, a⁴loh⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Conh⁴liah⁴ i²co⁴meih³ a⁴jyih³ húa³⁴ tsei³⁴; jian³ a⁴hya³, jian³ a⁴cúa⁴ o¹m⁴ ma⁵nia⁴lo⁴ conh⁴ con³. Con³ma²a⁴hleh⁴ Jesús jau²³ ne³, jon³ a⁴juah⁴i³ con³ i⁴tia⁴: ―A³hain⁴ a³ho³ ta³ra³cua¹ i⁴nau³⁴i³, ua²nai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","I² jon³ a⁴ŋang⁴ chie³ quian¹i³ tionh², a⁴juah⁴i³: ―¿Henh⁴ hnie³⁴ ra³juah⁴ jau²³ i⁴a⁴quianh³ˉ³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jon³ a⁴juah⁴ Jesús: ―Quie¹ i²conh² hnei³pa² tionh²ˉ³ júan³ Jon⁴dai¹ i⁴li⁴ñih¹ˉ³ jau²³ ni²hma² liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹; i² a³sang²³ ne⁵, con⁴juah⁴ jmah³ jau²³ i⁴can³⁴ˉ⁴ la⁴ne³pa² hleh³ˉ⁴ i²con²³i³ tionh², quie¹ ua²liah⁴a² je²³i³, la⁴con³ sa⁴ho³ m⁴nei² pi²³i³, jian³ ua²liah⁴a² nau³i³, sa⁴li⁴ŋang⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’I⁴la³pa² hnie³⁴ ra³juah⁴ jau²³ sa⁴lei³ ne³: O¹m⁴ i⁴jnei³i³ jon³ leg⁴³ jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","O¹m⁴ i⁴a⁴jyih³ ho³²jeu³ jon³ leg⁴³ liah⁴i² lang⁴³ chie³ a³nau³ jau²³ quieh¹ Jon⁴dai¹, jon³ jia²³ a³sa⁴tsein³⁴, qui²³i³ jau²³ i⁴hei¹ naih⁵ ni²tsei⁴³i³, canh⁴a² sa⁴li⁴hain⁴i³ i⁴ma²lion⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jian³ i⁴a⁴jyih³ je¹ a²caun² leg⁴³ liah⁴i² lang⁴³ a³nau³ jau²³ quieh¹ Jon⁴dai¹ jian³ hyei³i³ si³hyonh³i³, i² sa⁴quian³ hlion⁴ o¹júan⁴³ ne⁵, hain⁴i³ ta¹la⁴ co⁴le⁴ pi²³; i² con³ma²ja²³ jau²chie⁴³ i²con²³i³, jon³ teinh³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jian³ o¹m⁴ i⁴a⁴jyih³ je¹ a²ton⁴³ leg⁴³ liah⁴i² lang⁴³ a³nau³ jau²³ quieh¹ Jon⁴dai¹ jian³ ŋeng²³i³ teinh³ tsei⁴³ ma⁵meih³ nei² quieh¹ i⁴júan³i³ hlion⁴ co³hei²tsei³ quieh¹ m⁵cu³ la³, jian³ i⁴hnie³⁴i³ o¹cau³², jian³ i⁴can³⁴i³ co³hyon²³tsei³ quieh¹ m⁵cu³ la³, jian³ sa⁴ma³jnia³i³ i⁴tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","I² o¹m⁴ i⁴a⁴jyih³ húa³⁴ tsei³⁴ ne⁵, leg⁴³ liah⁴i² lang⁴³ a³nau³ jau²³ quieh¹ Jon⁴dai¹, jian³ hie³i³ i⁴jang³⁴ tsei⁴³i³ con⁴juah⁴ co³hei²tsei³ tsei²³, jian³ ma³jnia³i³ i⁴tsei³⁴ i⁴sa⁴teinh³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’I¹jan³ sa⁴hainh² o¹jyi³ juah⁴ i⁴hma²³i³ naih⁵ a²teuh³, jian³ a⁵ga⁴ i⁴seih²i³ naih⁵ a²jain³², quie¹ seih²i³ yeih³²pa², canh⁴a² la⁴jang³⁴ a³si³hei⁴³ jauh³² je³⁴ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Quie¹ i¹con³ i⁴ni²hma² sa⁴sia³ juah⁴ i⁴sa⁴li⁴jñeih³; jian³ i¹con³ i⁴ni²jleg³ sa⁴sia³ juah⁴ i⁴sa⁴li⁴ñi³ chie³ jian³ o⁴ juah⁴ i⁴sa⁴jñeih³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’I² jon³ ne⁵, jianh³ˉ³ nai³ hnei³ jau²³ quien⁴ˉ⁴ tionh²ˉ³; quie¹ la⁴jang³⁴ a³ma³ñi³, hyieh⁴ pi¹i³ i⁴li⁴ŋang⁴i³, jian³ la⁴jang³⁴ a³sa⁴ñi³, jon³ qui³⁴ la⁴teg⁴ ca³leuh² peih¹ i⁴lain⁴i³ ŋang⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ma²jon³ ja³⁴ sie²³ Jesús jian²³ si³reunh¹i³ la⁴teg⁴ i²ua²cua⁴³i³, i¹ sa⁴li⁴tyie¹i³ teg⁴ hlonh²i³ quie¹ eu⁴³ jeun⁴³ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jon³ a⁴júan⁴ chie³ jau²³ i²con²³ Jesús, juah⁴i³: ―Jeh³², sieh³ˉ³ jian²³ si³reunh³ˉ³ ti²tionh² coh⁵hnei³² la³, hnie³⁴i³ je⁴³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","I² Jesús ne⁵, a⁴jainh³i³ jau²³ i²con²³ a³hain⁴ tionh², a⁴juah⁴i³: ―A³hain⁴pa² lang⁴³ sia³⁴ˉ⁴ jian³ si³reunh³ˉ⁴, a³nau³ jau²³ quieh¹ Jon⁴dai¹pa² jian³ ma³tei⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jian³ con³ jm² liah⁴ a⁴hei³⁴ Jesús a²úan⁴³ jian²³ chie³ quian¹ tionh², jon³ a⁴sagh⁴³i³ tionh²: ―Ma³²ˉ¹ ta⁵hŋoh³ jm³ñei³. Ma²jon³ ua⁵han²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","I² ta¹la⁴ ti²han³i³ jm³ tionh²i³ a²úan⁴³, jon³ a⁴cm³ Jesús. Con³ a⁴la³ ra⁴hag³² con³ tyi⁴ tia⁴ nei² jm³, jon³ a⁴ha⁵ jm³ joh⁴³ a²úan⁴³, i⁴co³ jia²³ ma²li⁴hon³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jon³ a⁴tyie³⁴i³ tionh² hlonh² Jesús, a⁴sion⁴³i³, a⁴juah⁴i³: ―Hnei³ A²teg²³, ¡jeh³², ma³o¹tyan⁴³ˉ¹! Con³ma²a⁴ñei³⁴i³, jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³ tyi⁴ jian³ jm³ñei³; jon³ a⁴jian⁴, jian³ a⁴nie³⁴ tai³². ");
INSERT INTO cucNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ma²jon³ a⁴sagh⁴³i³ chie³ quian¹: ―¿O⁴ a⁵sia³ li⁴hainh⁴ˉ³ tionh²ˉ³? I² hei⁴i³ tionh², ta² yi⁴hag³² tsei⁴³i³, co³ a⁴jainh⁴³i³, jon³ a⁴sagh⁴³i³ a³jan³ jan³ jon²reunh¹: ―¿Hain³ ne³, lainh⁴ˉ³, quie¹ júan³i³ heih⁴³ i²con²³ tyi⁴ jian³ jm³ñei³, jian³ ma³co⁴³ quieh¹i³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jon³ a⁴tyie³⁴i³ ta⁵húa³⁴ Gadara, nie⁴³ jo³² ta⁵hŋoh³ o³chie⁴³ lia⁴ nie⁴³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","I² con³ma²a⁴tyie³⁴ Jesús húa³⁴ jon³, jon³ ja³⁴ jan³ a³ñih³ a³sian³ je¹jeu³ jon³, a³a⁴tyie³⁴ hlonh² Jesús a³quian³ m⁴tyi⁴ hlagh³² ma³jon⁵ne³⁴. Jian³ i¹ so⁵hein²i³ a²cúan³, jian³ so⁵cua⁴³i³ jauh³², quie¹ cua⁴³i³ to³ quieh¹ a³jaun²pa². ");
INSERT INTO cucNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","I² con³ma²a⁴jen³i³ Jesús, jon³ a⁴hoh⁵i³ con³ i⁴tia⁴, jian³ a⁴si⁴jnei⁵i³ ta⁵nei²i³, a⁴hleh⁴i³ tia⁴: ―¿Henh⁴ hnoh³ˉ³ i²con²³ jnia⁴, hnei³ Jesús, A³jon⁴³ Jon⁴dai¹ Júanh⁴³? Mh⁵ˉ⁵ hnei³ i⁴sa⁴heh²ˉ³ ma²eu⁴³ pain⁴ i²con²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A⁴juah⁴i³ la⁴ne³ quie¹ si²júan³ Jesús heih⁴³ i⁴si⁵hag⁴³ m⁴tyi⁴ hlagh³², quie¹ ma³jon⁵ne³⁴ co³lieh³ m⁴tyi⁴ hlagh³² quieh¹i³; jian³ ua²liah⁴a² hñi³ chie³ quieh¹i³ jeu³ a²ca³den², i⁴hñei³i³ si¹cúa³ si¹tag³²; i² hei⁴i³ cag²³i³ a²ca³den², jian³ júan³ m⁴tyi⁴ hlagh³² i⁴cm³i³ ta⁵i²a⁵sian⁴³ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jon³ a⁴ŋang⁴ Jesús i²con²³i³, a⁴juah⁴i³: ―¿Henh⁴ sainh³ˉ³? I² a⁴juah⁴ a³hain⁴: ―Ta⁵la⁵mai²³ A²hlie⁴pa² sain³⁴ˉ⁴. Quie¹ ta⁵la⁴ jeun⁴³ m⁴tyi⁴ hlagh³² ma³a⁴han⁵ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jian³ ti²m²³ m⁴tyi⁴ hlagh³² jon³ i²con²³ Jesús i⁴sa⁴sain³⁴i³ to³ qui⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jian³ ma²tionh² jeun⁴³ a¹ñi⁴³ a³ti²queuh³ yi⁴jo²³ mah⁴, jon³ a⁴m⁴ m⁴tyi⁴ hlagh³² i⁴cúa³⁴i³ jeu³ i⁴si⁵han²i³ naih⁵ ni²tsei⁴³ a¹ñi⁴³ tionh², jon³ a⁴hyieh³i³ jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jon³ a⁴húa³ m⁴tyi⁴ hlagh³² a³ma²tionh² naih⁵ ni²tsei⁴³ a³ñih³ hain⁴, a⁴han⁵i³ naih⁵ ni²tsei⁴³ la⁴jang³⁴ a¹ñi⁴³, jon³ ua⁵han²i³ jeu³ra³tyi⁴ ta⁵si²jeg²³ mah⁴ la⁴teg⁴ joh⁴³ jm³ i²a⁴chian³⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","I² con³ma²a⁴je³⁴ a³ti²hion⁴³ a¹ñi⁴³ hain⁴ la⁴jeg³⁴ i⁴a⁴leg³⁴ jon³, jon³ ua⁵han²i³ jeu³ra³tyi⁴, ŋah³i³ je¹jeu³ ua⁵tya³i³ jau²³ i²con²³ chie³ jian³ la⁴tan² i²nau³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jon³ ua⁵han² chie³ tionh² ua⁵je⁴i³ i⁴a⁴leg³⁴, a⁴tyie³⁴i³ hlonh² Jesús. Jian³ a⁴jen³i³ a³ñih³ a³ma²quian³ m⁴tyi⁴ hlagh³² hain⁴, ua²cua⁴³ hloh³² si¹tag³² Jesús, ua²hein² a²cúan³ jian³ ma³tsein³⁴i³ o³tan². Jian³ ta² ra⁵coh⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jian³ la⁴jang³⁴ a³a⁴je³⁴ liah⁴ a⁴leg³⁴, a⁴tya⁴i³ jau²³ liah⁴ a⁴lon⁴ a³hain⁴ i⁴ma²jie³ m⁴tyi⁴ hlagh³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","I² jon³ la⁴jang³⁴ a³sian³ la⁴tan² hloh³² húa³⁴ Gadara jon³, a⁴mh³i³ Jesús i⁴ua⁵hag⁴³i³ jeu³ co²³i³ tionh², quie¹ ta⁵la⁴ eu⁴³ yi⁴hang³²i³. I² Jesús ne⁵, a⁴hei³⁴i³ a²úan⁴³ liah⁴ i⁴seg³⁴, jonh²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jian³ a³ñih³ a³a⁴húa³ m⁴tyi⁴ i²con²³ hain⁴, a⁴mh³i³ Jesús i⁴cúa³⁴i³ jeu³ i⁴chie³⁴i³ jian²³i³. I² Jesús ne⁵, a⁴saih³ pi²³i³, a⁴sagh⁴³i³: ");
INSERT INTO cucNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Cuanh³ hnei³ jauh³² quianh³, ua⁴tya² hnei³ jau²³ la⁴jeg³⁴ i⁴eu⁴³ co³ jnia⁴ i⁴a⁴júan⁴ Jon⁴dai¹ i²conh²ˉ³. Jon³ ŋah³i³ ya¹hleh²i³ la⁴tan² jeu³ jon³ la⁴jeg³⁴ i⁴co³ jnia⁴ i⁴a⁴júan⁴ Jesús i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Con³ma²jonh³ Jesús, ta² si³hyonh³ la⁴jang³⁴ chie³ jeun⁴³ a⁴hyeih³ quieh¹i³, quie¹ ma²ti²jien⁴³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","I² jon³ a⁴tyie³⁴ jan³ a³ñih³ a³sain³ Jairo, a³tyein² quian¹ cuah³ judío, a⁴si⁴jnei⁵i³ ta⁵nei² Jesús, a⁴mh³i³ i⁴chie³⁴i³ jauh³² quieh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","quie¹ ma³o¹jaun⁴ a³m⁴ jon⁴³i³, ra³can²³ tyi⁴, a³hein² quia⁵teun⁴ ñi³, a³jan³ hain⁴ leg⁴³pa² quian¹i³. I² ta¹la⁴ hein² Jesús jeu³, ta² jeun⁴³ chie³ ti²hlia²³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","I² je¹ jon³ ma³hein² jan³ a³m⁴ a³chieh¹ ma³quia⁵teun⁴ ñi³ a³lang⁴³ ua³pei⁴ quieh¹, jian³ ma³a⁴chia³⁴ la⁴jeg³⁴ i⁴quieh¹i³ i⁴júan³i³ hei²³ i²con²³ teg³m⁴³; jian³ i¹jan³ sa⁴a⁴tieh¹ júan³⁴ i⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jon³ a⁴tyie³⁴i³ jeu³ ta⁴coh⁵cah³² Jesús, jian³ a⁴tang⁴i³ he⁴³ a²cúan³i³, i² liah⁴ma²jon³ a⁴jian⁴ ua³pei⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jon³ a⁴juah⁴ Jesús: ―¿Hain³ a⁴tei³⁴ jnia⁴ si¹cúa³? I² a⁴juah⁴ la⁴jang³⁴: ―I¹jan³. Jon³ a⁴juah⁴ Pe³² jian²³i³ la⁴jang³⁴ a³jian²³i³: ―Hnei³ A²teg²³, chie³pa² si²hnauh⁴, hlie⁴³ hnei³, jian³ juah⁴ˉ³: “¿Hain³ a⁴tei³⁴ jnia⁴ si¹cúa³?” ");
INSERT INTO cucNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","I² a⁴juah⁴ Jesús ne⁵: ―Sian³ jan³ a³a⁴tei³⁴ jnia⁴ si¹cúa³, quie¹ ra⁵lai²³ˉ⁵ i⁴sian³ a³a⁴huan⁴ quieh¹ con⁴juah⁴ ua³pei⁴ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","I² con³ma²a⁴je³⁴ a³m⁴ hain⁴ i⁴sa⁴tian⁴ juah⁴ i⁴si⁵hma³²i³, jon³ ŋo³⁴i³ ta⁵hlonh² Jesús, a⁴si⁴jnei⁵i³, jon³ a⁴sagh⁴³i³ Jesús ta⁵nei² la⁴jang³⁴ chie³ jeun⁴³ hain⁴ hain³ nei² a⁴tei³⁴i³ si¹cúa³ he³² Jesús, jian³ liah⁴ a⁴huan⁴ quieh¹i³ liah⁴ma²jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Hnei³ jon²³ quian³⁴ˉ⁴, a⁴huan⁴ quianh³ˉ³ quie¹ ra⁵hainh⁴ˉ³. Cuanh³ quianh³ si³hyonh³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ma²si²hleh² pi¹ Jesús, con³ma²a⁴tyie³⁴ jan³ a³ja²³ jauh³² quieh¹ Jairo, a³tyein² quian¹ cuah³, a³a⁴sag⁴³ quieh¹i³: ―Ma³jaun²pa² a³jonh³ˉ³; a⁵ma⁵si⁵quian³² hnei³ tsei⁴³ A²teg²³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Con³ma²a⁴nau⁴ Jesús jau²³ jon³, jon³ a⁴juah⁴i³: ―A⁵júan³ hnei³ canh⁴³; júan² hnei³ i⁴hainh⁴, quie¹ jainh¹ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","I² con³ma²a⁴tyie³⁴ Jesús jauh³² quieh¹i³, a⁵sia³ a⁴cúa⁴i³ i⁴han⁵ chie³, quie¹ Pe³²pa² a⁴hei³⁴ jian³ Jacobo, jian³ Juan²³, jian³ jmai³sie²³ yein³pa². ");
INSERT INTO cucNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jian³ ta² ti²hoh⁵i³ la⁴jang³⁴i³ tionh², chionh⁴ tsei⁴³i³ nei² quieh¹ yein³. I² jon³ a⁴juah⁴ Jesús: ―Ma⁵hoh⁴³ hnei³ tionh²ˉ³; quie¹ a⁵sian⁴³ yein³ ra³jaun², ra³cm²pa². ");
INSERT INTO cucNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jon³ a⁴ji⁴ŋang⁴i³ Jesús tionh², quie¹ ti²ñi³i³ i⁴ma³ra³jaun². ");
INSERT INTO cucNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","I² Jesús ne⁵, a⁴tang⁴i³ si¹cúa³ a³m⁴ peih¹ hain⁴, a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―Hnei³ a³peih¹ m⁴, ra⁴hang³² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jon³ a⁴jainh¹i³, jian³ liah⁴ma²jon³ a⁴no³i³; jian³ a⁴júan⁴ Jesús heih⁴³ i⁴gueh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jian³ ta² co³ ŋo³⁴ tsei⁴³ jmai³sie²³i³; jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³ tionh² i⁴sa⁴sagh⁵i³ i¹jan³ i⁴a⁴leg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Con³ma²a⁴jaih³ Jesús quia⁵teun⁴ chie³ quian¹, jon³ a⁴cúah³i³ ua³pei⁴ jian³ a⁴cúah³i³ heih⁴³ i⁴húa³⁴i³ la⁴jeg³⁴ m⁴tyi⁴ hlagh³², jian³ i⁴júan³⁴i³ i⁴huan⁴ la⁴jeg³⁴ chie² ti²lang⁴³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","I² jon³ a⁴sain⁴i³ ua⁵hleh³i³ jau²³ liah⁴ han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, jian³ i⁴si⁵júan⁴i³ i⁴huan⁴ quieh¹ a³ti²chieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jon³ a⁴sagh⁴³i³: ―I¹con³ a⁵sia³ i⁴canh²ˉ³ quieh¹ ho³²jeu³, a⁵ga⁴ a²hma³heu¹, a⁵ga⁴ a²mo³ra², a⁵ga⁴ a²hei⁴³, a⁵ga⁴ o¹cau³²; jian³ sa⁴canh²ˉ³ a²cúanh³, conh⁴ heinh² ne³pa² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jian³ juah⁴ hain³ jauh³² i²a⁴cúah³ˉ³, jian² hnei³ i²jon³ la⁴conh⁴i² a⁴jauh²ˉ³ jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jian³ jeu³ i²sa⁴hyei⁴³i³ hnei³, jau²³ hnei³ jeu³ jon³, jian³ poh⁴³ hnei³ o¹hlie³ ti²quin⁴³ si¹tagh¹ˉ³ i⁴júan³ lei³ i⁴sa⁴jaih¹ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jon³ ua⁵han²i³ tionh², hleh²i³ jau²³ tsei²³ quieh¹ Jon⁴dai¹ la⁴jeg³⁴ jeu³ peih¹, jian³ júan³i³ i⁴huan⁴ quieh¹ a³chieh¹ la⁴tan² jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","I² jon³ ne⁵, a⁴nau⁴ re¹ Herodes nei² quieh¹ la⁴jeg³⁴ i⁴júan³ Jesús; ta² so⁵ñi³i³ liah⁴ sian³i³, quie¹ juah⁴ ca³chion²³: ―Ma³a⁴hyon²³ Juan³ Tei³² jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Conh⁴liah⁴ juah⁴ i²ca³chion²³: ―Ma³cúan²³ I³lie²³ liah⁴ i⁴seg³⁴. Conh⁴liah⁴ juah⁴ i²co⁴meih³: ―Jan³ a³sain² quian¹ Jon⁴dai¹ a³ma²sian³ ya⁴jo³⁴, ma³a⁴hyon²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","I² a⁴juah⁴ Herodes ne⁵: ―Quie¹ a⁴júan³⁴ˉ⁴ heih⁴³ a⁴gmh⁴ lau² Juan²³. ¿I² hain³ chianh² ne³ ne⁵ a³hain⁴ a³nau³⁴ˉ⁴ hlion⁴ jau²³ nei² quieh¹? Jian³ ta² hnoh³i³ liah⁴ li⁴jen⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","I² con³ma²a⁵han² la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹i³, jon³ a⁴tyieh³i³ Jesús jau²³ la⁴jeg³⁴ i⁴ni²júan⁴i³ tionh². I² jon³ jian³ Jesús a³hain⁴ tionh², ua⁵han²i³ con³ i²a⁵sian⁴³ a³sian³ hloh³² jeu³ i⁴sain³ Betsaida. ");
INSERT INTO cucNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Con³ma²ra⁵ñi³ chie³ tionh², jon³ ua⁵han²i³; jian³ a⁴hyei⁴³ Jesús quieh¹i³, jian³ a⁴hlenh⁴³i³ jau²³ liah⁴ tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, jian³ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ a³ma²hniah³ lei⁴ hei²³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","I² con³ma²a⁴hlo⁴, ua⁵han² quia⁵teun⁴ chie³ quian¹i³ hlonh²i³, a⁴sagh⁴³i³ Jesús tionh²: ―Sainh³² hnei³ chie³ ne³ tionh², ua²tyanh⁴i³ ua²yi⁴jian³i³ la⁴jeg³⁴ jeu³ peih¹ jian³ i²nau³ la⁴con³ hloh³² ne³, jian³ canh⁴a² li⁴tyieh¹i³ i⁴queuh⁴³i³, quie¹ i²tieh²ˉ¹ la³ i²a⁵sian⁴³ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","I² a⁴juah⁴ Jesús ne⁵: ―Guenh³²i³ hnei³ tionh²ˉ³. I² a⁴juah⁴i³ tionh²: ―Ta² sa⁴hlion⁴ le² jnie³² i²la³, hña⁴ a²hei⁴³ñih¹pa² jian³ on³⁴ jon⁴³júa³², juah⁴ne³ sa⁴chie² jnie³² si²lia³² jnie³² i⁴queuh⁴³ a³ne³ tionh² la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Quie¹ tain⁴³ a³hain⁴ tionh² conh⁴ hña⁴ mai²³ chie³. I² jon³ a⁴juah⁴ Jesús i²con²³ chie³ quian¹: ―Tyan³² a³ne³ tionh² co⁴lagh⁴³ ma⁵to⁴lo⁵quian⁴ conh⁴ con³ i²tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jon³ a⁴júan⁴ chie³ quian¹i³ la⁴jon³, a⁴tyan⁴³i³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ma²jon³ a⁴tang⁴ Jesús li⁵hña⁴ a²hei⁴³ñih¹ jian³ li⁵uan⁴ jon⁴³júa³², a⁴je³⁴i³ ta⁵ñi⁴jeu⁵, a⁴ma⁴cúah¹i³, ma²jon³ a⁴jeun³⁴i³, a⁴cúah³i³ chie³ quian¹ tionh² canh⁴a² tyieh⁵i³ i²con²³ la⁴jang³⁴ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jon³ a⁴queuh³ la⁴jang³⁴ a³hain⁴ tionh², jian³ a⁴canh³ hein²i³; ma²jon³ a⁴jaih³i³ la⁴jeg³⁴ i⁴a⁴sion³⁴, jon³ a⁴canh³ quia⁵teun⁴ a²mh³ta²³ o¹leuh². ");
INSERT INTO cucNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jian³ liah⁴ con³ jm² ma²si²mh² Jesús Jon⁴dai¹ Jmai³ i²a⁵sian⁴³ a³sian³ jian²³i³ chie³ quian¹, jon³ a⁴ŋang⁴i³ i²con²³ chie³ quian¹, a⁴juah⁴i³: ―¿Hain³ jnia⁴ juah⁴ chie³ tionh²? ");
INSERT INTO cucNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","I² a⁴juah⁴i³ tionh²: ―Juan³ Tei³²pa² hnei³ juah⁴ ca³chion²³; jian³ ca³chion²³ juah⁴ I³lie²³pa² hnei³, jian³ juah⁴i³ i²co⁴meih³ langh⁴³ˉ³ jan³ a³sain² quian¹ Jon⁴dai¹ a³a⁴hyon²³ a³ma²sian³ ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","I² a⁴juah⁴ Jesús liah⁴: ―I² hnei³ tionh²ˉ³ ne⁵, ¿hain³ jnia⁴ juah⁴ˉ³ tionh²ˉ³? I² jon³ a⁴ŋangh³ Pe³², a⁴juah⁴i³: ―Hnei³ langh⁴³ A³lion³ Chie³ hain⁴, a³a⁴sain⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jon³ a⁴júan⁴ Jesús pain⁴ heih⁴³ i²con²³i³ tionh² i⁴sa⁴sagh⁵i³ i¹jan³ chie³ jau²³ jon³, ");
INSERT INTO cucNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","jian³ a⁴juah⁴i³: ―Quie¹ ton³²nie⁴³ hniah³ can³⁴ A³a⁴lang³⁴ Chie³ hain⁴ hlion⁴ ma²eu⁴³, jian³ i⁴ton³⁴ a³don⁵ ma⁴³teg²³ quieh¹i³, jian³ m³chie³ tyein² tionh², jian³ a²teg²³ quian¹ lai²³; jian³ hniah³ jaun⁴i³, jian³ hyon⁴³i³ tei⁴³i² ma³a⁴teg⁴ hneng³ jm². ");
INSERT INTO cucNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jian³ a⁴sagh⁴³i³ la⁴jang³⁴: ―Juah⁴ne³ sian³ a³hnie³⁴ si⁴tyein⁵ coh⁵cah³ˉ⁴, hniah³ ma⁵hain³i³ tsei⁴³ i²con²³ hña³, jian³ hniah³ can³⁴i³ ma²eu⁴³ conh⁴ con³ jm², jian³ jia²³i³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Quie¹ la⁴jang³⁴ a³hnie³⁴ lion⁴ m⁵cu³ quieh¹, si⁵hain⁴i³; jian³ la⁴jang³⁴ a³si³hain⁴ m⁵cu³ quieh¹ nei² quien⁴ˉ⁴, hyieh⁴i³ m⁵cu³ quieh¹ i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Quie¹ ¿henh⁴ ta¹ tei⁴³ i²con²³ jan³ chie³ juah⁴ne³ laih⁴i³ la⁴tan² m⁵cu³ la³, jian³ ma²a⁴leg³⁴ jon³ si⁵hain⁴i³, so⁵lei³ jnia⁴i³ hña³i³? ");
INSERT INTO cucNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Quie¹ a³hain⁴ a³hyeih¹ nei² quien⁴ˉ⁴ jian³ nei² quieh¹ jau²³ quien⁴ˉ⁴, jon³ hyeih¹ A³a⁴lang³⁴ Chie³ hain⁴ jen⁴³i³ a³hain⁴ liah⁴, la⁴teg⁴i² jionh⁴i³ i⁴quian³i³ joh¹ jian³ joh¹ quieh¹ Jmai³i³, jian³ i⁴ti²quian³ ángel tsein²³ joh¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jian³ i⁴chie⁴³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ liah⁴: ca³chion²³ hnei³ a³tionh² i²la³ jeh²ˉ³ i⁴ua²júan³ Jon⁴dai¹ heih⁴³ m⁵cu³ la³, naih⁵i² jaunh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Liah⁴ma²jña³⁴ jm² a⁴hleh⁴ Jesús jau²³ jon³, jon³ ŋo³⁴ Jesús con³ nei² mah⁴ ua⁵mh²i³ Jon⁴dai¹, jian³i³ Pe³² jian²³ Juan²³ jian³ Jacobo liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","I² ta¹la⁴ si²mh²i³ Jon⁴dai¹, jon³ a⁴sag²³ ma³nei²i³, jian³ ra⁵tie³ a²cúan³i³, ra⁵joh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jian³ con³ a⁴la³ ma⁴jnia³² on³⁴ chie³ a³ti²tya²³ jau²³ jian²³i³, a³hain⁴ tionh² M³se²³ jian²³ I³lie²³, ");
INSERT INTO cucNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","a³hain⁴ a³ma⁴jnia³² i⁴ya¹taih³² joh¹ jian³ ti²hleh²i³ nei² quieh¹ i⁴jaun⁴ Jesús la⁴jon³ i⁴jainh⁴³i³ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jian³ Pe³² jian²³ a³hain⁴ tionh², ta² tieh³² sie⁴ nei²i³, i² ton³²nie⁴³ ti²cúah²i³ tsei⁴³ ti²nai²i³ tionh², a⁴je³⁴i³ joh¹ quieh¹ Jesús, jian³ li⁵uan⁴ chie³ ti²tionh² hlonh²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","I² con³ma²ma³quein²³ chie³ hain⁴ tionh² hlonh² Jesús, jon³ a⁴juah⁴ Pe³² i²con²³i³: ―¡Hnei³ A²teg²³, ta² re³ quie¹ tieh²ˉ¹ i²la³! Ua²júan³² jnie³² hneng³ cuah²hnei⁴³ peih¹; con³ quianh³ˉ³, con³ quieh¹ M³se²³, jian³ con³ quieh¹ I³lie²³ liah⁴. I¹ sa⁴ñi³ Pe³² henh⁴ hleh²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ta¹la⁴ si²hleh²i³ i⁴jon³, jon³ ja³⁴ con³ o¹jnai⁴³, a⁴quionh³i³, jian³ ta² yi⁴hag³² tsei⁴³i³ tionh², con³ma²a⁴han⁵i³ je¹ o¹jnai⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jian³ je¹ o¹jnai⁴³ jon³, ja³⁴ con³ jau²³ ho³² i⁴juah⁴i³: ―A³ne³pa² A³jon³⁴ˉ⁴ a³hno⁵ˉ⁵; nai³ hnei³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","I² con³ma²ua⁴jeu³² jau²³ jon³, jon³ a⁴quionh³ Jesús hña³pa² júah³. Jian³ hei⁴i³ tionh² i¹con³ sa⁴a⁴hleh⁴i³, jian³ jm² jon³ i¹jan³ a⁵sian⁴³ a³a⁴tyieh³i³ jau²³ i⁴a⁴je³⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Con³ma²a⁴jnia³⁴ jon³, con³ma²a⁴jyon²³i³ mah⁴, jon³ ua⁵han² jeun⁴³ chie³ ua⁵ma⁵jainh³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","I² con³ a⁴la³ a⁴hleh⁴ jan³ chie³ tia⁴ jen² chie³ jeun⁴³ hain⁴ tionh², a⁴juah⁴i³: ―Hnei³ A²teg²³, m³⁴ˉ⁴ i²conh²ˉ³ i⁴jenh³²ˉ³ a³jon³⁴ˉ⁴, quie¹ jan³ la³pa² leg⁴³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Quie¹ sonh² con³ m⁴tyi⁴ hlagh³² quieh¹i³, jian³ hoh⁵i³ la⁴conh⁴ sa⁴jian³, jian³ júan³i³ i⁴ma³huanh² i⁴hma²³i³, jian³ i⁴húah²i³ o¹jan³ liah⁴, jian³ júanh¹i³, la⁴ton³² tai²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jian³ a⁴mh⁵ˉ⁵ chie³ quianh³ˉ³ i⁴ma²tyi⁴³i³ m⁴tyi⁴ hlagh³²; a⁵sia³ a⁴cagh¹i³ jm². ");
INSERT INTO cucNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","I² Jesús ne⁵, a⁴juah⁴i³: ―¡Hnei³ a³sa⁴hain⁴ tionh² jian³ a³hlangh²! ¿Hain³ la⁴conh⁴a² sa⁴hniah³ tie³²ˉ⁴ jian²³ˉ⁵ hnei³ tionh²ˉ³, liah²? ¿Jian³ hain³ la⁴conh⁴a² sa⁴hniah³ cúah²ˉ⁵ tsei³⁴ i²conh²ˉ³ tionh²ˉ³? Jian⁴³ hnei³ a³jonh³ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","I² con³ma²ŋo³⁴ yein³ hloh³², jon³ a⁴júan⁴ m⁴tyi⁴ hlagh³² i⁴a⁴cangh³ yein³, a⁴hma³⁴i³; i² jon³ a⁴jain³⁴ Jesús m⁴tyi⁴ hlagh³², a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ a³maih² hain⁴, ma²jon³ a⁴cúanh³i³ i²con²³ jmai³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ta² co³ a⁴jainh⁴³ la⁴jang³⁴ a³hain⁴ tionh² la⁴conh⁴ tei⁴³ i⁴júanh⁴³ Jon⁴dai¹. Con³ma²eu⁴³ co³ ti²jainh⁴³i³ la⁴jang³⁴i³ la⁴jeg³⁴ i⁴júan³ Jesús, jon³ a⁴sagh⁴³i³ chie³ quian¹: ");
INSERT INTO cucNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Co³re³ ua²ta⁴ton³² hoh⁴³ˉ³ jau²³ la³ tionh²ˉ³, quie¹ cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","I² hei⁴i³ tionh², sa⁴ra⁵ŋang⁴i³ jau²³ jon³, quie¹ sa⁴a⁴cúa⁴ Jon⁴dai¹ i⁴ra⁵ŋang⁴i³ jm² jon³; jian³ ra⁵coh⁴³i³ ŋang³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","I² jon³ a⁴jang²³i³ tionh² húan⁴i³ nei² quieh¹ hain³ tyein² júanh⁴³ jen²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","I² Jesús ne⁵, si²ñi³ co³hei²tsei³ ti²júan³ a³hain⁴ tionh² naih⁵ ni²tsei⁴³i³. Jon³ a⁴tang⁴i³ jan³ yein³, a⁴sainh⁴i³ hlonh²i³, ");
INSERT INTO cucNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―A³hain⁴ a³hyein⁴³ jan³ a³peih¹ a³la⁴la³ nei² quien⁴ˉ⁴, jnia⁴pa² hyei⁴³i³; jian³ a³hain⁴ a³hyei⁴³ jnia⁴, hyein⁴³ a³a⁴sai⁴ jnia⁴. I² a³hain⁴ a³jnia⁴ a³sa⁴quein⁴³ jenh²ˉ³ tionh²ˉ³, a³hain⁴pa² tyein² júanh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","I² jon³ a⁴juah⁴ Juan²³, a⁴sagh⁴³i³ Jesús: ―Hnei³ A²teg²³, a⁴nia³² jnie³² jan³ chie³ a³ma²si²húa³ m⁴tyi⁴ hlagh³² con⁴juah⁴ jm³i⁴sainh³ˉ³; i⁴jon³ a⁴saih³²i³ jnie³² i⁴so⁵júan³⁴i³ la⁴jon³, quie¹ sa⁴ŋeng²³i³ jie³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","I² a⁴juah⁴ Jesús: ―Sa⁴hniah²ˉ³ juah⁴ i⁴sa⁴júan³⁴i³, quie¹ a³hain⁴ a³sa⁴hieh¹ i⁴júan³ˉ¹, a³hain⁴pa² jie³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Con³ma³o¹teg³⁴ jm² i⁴chianh³ Jesús ñi⁴jeu⁵, jon³ ŋo³⁴i³ ta⁵ Jerusalén i⁴júan³i³ con³ co³hei²tsei³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jon³ a⁴sain⁴i³ co⁴meih³ a³quian³ jau²³ ñeih³² a³ua⁵júan⁴ re³ i²jian³⁴i³ con³ jeu³ peih¹ i²tei⁴³ húa³⁴ Samaria. ");
INSERT INTO cucNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","I² a³tionh² húa³⁴ Samaria jon³ ne⁵, sa⁴hyei⁴³i³ quieh¹i³, quie¹ lei³ jnia⁴ hein²i³ jeu³ i⁴chie³⁴i³ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","I² con³ma²a⁴je³⁴ chie³ quian¹i³ i⁴ne³, Jacobo jian²³ Juan²³, jon³ a⁴juah⁴i³: ―Hnei³ Se³ño²³, ¿o⁴ hnoh³ˉ³ júan² jnie³² heih⁴³ i⁴tiah³ o¹jyi³ loh⁴³ ñi⁴jeu⁵ liah⁴a² a⁴júan⁴ I³lie²³, canh⁴a² tyan⁴³ chie³ la³ tionh²? ");
INSERT INTO cucNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jon³ ua⁵lang⁴ Jesús, a⁴jain³⁴i³ a³hain⁴, a⁴juah⁴i³: ―Ta² sa⁴ñih¹ˉ³ tionh²ˉ³ júanh³ˉ³ co³hei²tsei³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","A⁵jon⁴³ i⁴jon³ cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ juah⁴ i⁴ma⁵hain³i³ m⁵cu³ quieh¹ chie³, quie¹ i⁴jon³pa² i⁴ua⁵lion³² pi²³i³. I² jon³ ua⁵han²i³ tionh² i²con³ jeu³ peih¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Con³ma²tionh²i³ jeu³ ho³²jeu³, jon³ a⁴juah⁴ jan³ chie³ i²con²³ Jesús: ―Hnei³ Se³ño²³, hno⁵ˉ⁵ nai³²ˉ⁴ coh⁵cah³²ˉ³ ua²jainh¹ i²tyieh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","I² jon³ a⁴juah⁴ Jesús: ―Sia³pa² i²cm²³ a²hyah³, jian³ sia³pa² sag³² jon⁴³tan²³ liah⁴; i² A³a⁴lang³⁴ Chie³ hain⁴ ne⁵, a⁵sia³ i²li⁴quie⁴³i³ sia³. ");
INSERT INTO cucNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","I² jon³ a⁴juah⁴ Jesús i²con²³ i²jan³: ―Nia³ hnei³ coh⁵cah³ˉ⁴. I² a⁴juah⁴ a³hain⁴: ―Hnei³ Se³ño²³, cúa² hnei³ jeu³ ñeih³² naih²ˉ⁵ ni¹hon⁵ˉ⁵ neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","I² a⁴juah⁴ Jesús ne⁵: ―Ua²hon³⁴ a³ti²jaun² m⁴tyi⁴ quieh¹ a³jaun² quian¹; i² hnei³, cua³ ua⁴hleh² hnei³ liah⁴ leg⁴³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Conh⁴liah⁴ a⁴juah⁴ i²jan³ liah⁴: ―Hnei³ Se³ño²³, hno⁵ˉ⁵ si²tyein³²ˉ⁴ coh⁵cah³²ˉ³. Quie¹ cúa² hnei³ jeu³ ñeih³² ni¹hai³²ˉ⁴ jau²³ a³tionh² jauh³² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","I² a⁴juah⁴ Jesús liah⁴: ―I¹jan³ a³quiah³ húa³⁴ sa⁴jainh² nei² coh⁵cah³², a³la⁴ne³ sa⁴haih¹ i⁴li⁴si⁵hei⁴ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Con³ma²ua⁴jeu³² jon³, jon³ a⁴quianh⁴³ Jesús to⁴lo⁵quian⁴ ni²tsain¹ quion⁴ a³sang²³, a³a⁴sain⁴i³ ma⁵on³⁴ ma⁵on³⁴ ñeih³² la⁴jeg³⁴ jeu³ i²hniah³ chie³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jian³ a⁴sagh⁴³i³: ―Ta² hlion⁴ i⁴jnia² je¹, a³júan³ ta¹pa² co⁴meih³ leg⁴³. I⁴jon³ hniah³ mh³²ˉ³ A³don⁵ quieh¹ je¹ i⁴sain³⁴i³ mozo quian¹ i⁴si⁵queun³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ua⁴han² hnei³ tionh²ˉ³; jeh³², sain¹ˉ⁴ hnei³ tionh²ˉ³ la⁴jan³ a⁵a³siah³ jen² a¹tsai³nau²³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sa⁴canh²ˉ³ o¹cau³², jian³ sa⁴canh²ˉ³ a²mo³ra², jian³ sa⁴canh²ˉ³ i²con³ a²lo³ tsei²³ tagh¹, jian³ sa⁴tyah²ˉ³ jau²³ úa⁴ ho³²jeu³ tei⁴³i² a⁴jainh³ˉ³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jian³ jauh³² i²jon³ i²cúah¹ˉ³, co⁴ra⁴lie⁵ ñeih³² jeuh³²i³ hnei³: “Jon⁴dai¹ júan³⁴ i⁴tionh²ˉ³ hyon³ hoh⁴³ˉ³ jauh³² la³.” ");
INSERT INTO cucNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","I² juah⁴ne³ jauh³² jon³ tionh² chie³ a³hnie³⁴ ma⁵ho³² Jon⁴dai¹ quieh¹ la⁴ne³, jon³ ma⁵ho³² Jon⁴dai¹ quieh¹i³ liah⁴ ma³a⁴juah¹ˉ³ jon³. I² juah⁴ne³ sa⁴lang⁴³i³ la⁴ne³, jon³ sa⁴ta⁵sagh³² i²con²³i³ la⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jian³ con³ jauh³² jon³pa² jianh²ˉ³ liah⁴, jian³ cauh⁴³ hainh⁴ hnei³ i⁴cúa³⁴i³; quie¹ la⁴jang³⁴ a³júan³ ta¹ haih¹ li⁴hlianh²i³. A⁵nei⁴ hnei³ i⁴con³ i⁴con³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jian³ la⁴jeg³⁴ jeu³ i²cúah¹ˉ³ i²hyei⁴³i³ hnei³ tionh²ˉ³, cauh⁴³ hnei³ la⁴conh⁴ i⁴cúa³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jian³ júan² hnei³ i⁴huan⁴ quieh¹ a³ti²chieh¹ a³tionh² jeu³ jon³, jian³ saih³²i³ hnei³: “Ma³a⁴tyie³⁴ jm² i⁴hanh⁵ˉ³ tionh²ˉ³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jian³ la⁴jeg³⁴ jeu³ i²cúah¹ˉ³ i²sa⁴hyei⁴³i³ hnei³ tionh²ˉ³, húan³ hnei³ jeu³ jon³ i⁴hleh²ˉ³ jeu³júan²³, i⁴jeuh³²i³ hnei³: ");
INSERT INTO cucNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“La⁴teg⁴ o¹hlie³ quieh¹ jeu³ coh³²ˉ³ la³ i⁴a⁴quin⁵ ma³tag³² jnie³², poh⁵ jnie³² i⁴la³ i⁴júan³ lei³ i⁴sa⁴jainh³²ˉ³ tionh²ˉ³. Quie¹ hniah³ li⁴ñih¹ˉ³ i⁴la³, i⁴ma³a⁴tyie³⁴ jm² i⁴ma²li⁴hanh⁵ˉ³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jian³ jm² i⁴gmh⁴ heih⁴³, pain⁴ ma²eu⁴³ hyieh⁴ a³tionh² jeu³ jon³ la⁴conh⁴a² a³ma²tionh² jeu³ Sodoma. ");
INSERT INTO cucNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Ti⁴³ jeuh² hnei³ a³tionh² jeu³ Corazín! ¡Ti⁴³ jeuh² hnei³ a³tionh² jeu³ Betsaida! Quie¹ juah⁴ne³ ma²a⁴leg³⁴ ua³júah² la⁴ne³ jeu³ Tiro jian³ jeu³ Sidón liah⁴i² a⁴leg³⁴ i²conh²ˉ³, ma³jon⁵ne³⁴pa² ma²a⁴sag²³i³ co³hei²tsei³ quieh¹, i⁴ma³a⁴hei³⁴i³ a²hmh³ quieh¹ a³chionh⁴ tsei⁴³, jian³ i⁴ma³a⁴sie⁴i³ o¹jua³ ma³tyi². ");
INSERT INTO cucNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","I⁴jon³ jm² i⁴queih³ Jon⁴dai¹ heih⁴³ i²con²³ m⁵cu³, hyanh⁴ˉ³ pain⁴ ma²eu⁴³ tionh²ˉ³ la⁴conh⁴a² jeu³ Tiro jian³ Sidón. ");
INSERT INTO cucNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jian³ hnei³ jeu³ Capernaum, ¿o⁴ euh²ˉ³ ta⁵ñi⁴jeu⁵, lainh⁴ˉ³? Ta⁵jeuh³pa² cúah²ˉ³, la⁴teg⁴ I²tionh² A³jaun². ");
INSERT INTO cucNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’A³hain⁴ a³nau³ jau²³ quianh³ˉ³, jau²³ quien⁴ jnia⁴pa² nau³i³; jian³ a³hain⁴ a³ton²³ hnei³, jnia⁴pa² ton²³i³; jian³ a³hain⁴ a³ton²³ jnia⁴, ton²³i³ a³a⁴sai⁴ jnia⁴pa² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jon³ a⁴tyanh³ to⁴lo⁵quian⁴ ni²tsain¹ quion⁴ hain⁴ i⁴si³hyonh³i³ tionh², juah⁴i³: ―Hnei³ Se³ño²³, la⁴teg⁴ m⁴tyi⁴ hlagh³² ma³co⁴³ heih⁴³ quian⁴ jnie³² con⁴juah⁴ jm³i⁴sainh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","I² a⁴juah⁴ Jesús: ―I⁴chie⁴³pa², quie¹ a⁴je³⁴ˉ⁴ i⁴a⁴tanh⁴ a⁵lainh³² a³ma²hein² ñi⁴jeu⁵ la⁴con³ o¹jyi³ quieh¹ a²ñih³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jeh³², cúa¹ˉ⁴ ua³pei⁴ i⁴si²tyeinh³²ˉ³ jah⁴ hion²³ jian³ a¹hnei⁴³, jian³ i⁴cangh³²ˉ³ jm² la⁴jeg³⁴ ua³pei⁴ i⁴quian³ a³hie²³, jian³ i¹con³ a⁵sia³ i⁴jainh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jian³ a⁵júan³ hnei³ si³hyonh³ quie¹ i⁴ma³co⁴³ hnei³ m⁴tyi⁴ hlagh³² tionh²ˉ³, quie¹ hniah³ júanh²ˉ³ si³hyonh³ nei² quieh¹ i⁴ra³ton³ jm³i⁴sainh³ˉ³ ñi⁴jeu⁵pa². ");
INSERT INTO cucNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","I² o²ra³ jon³ a⁴júan⁴ Jesús si³hyonh³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹, a⁴juah⁴i³: ―Júan³⁴ jnia⁴ i⁴júanh⁴³ˉ³, hnei³ Neih³ˉ⁴, Se³ño²³ quian¹ ñi⁴jeu⁵ jian³ cuah³²húa³⁴ la³, quie¹ ma³ma⁴jniah³²ˉ³ la⁴jeg³⁴ i⁴ne³ nei² quien⁴ˉ⁴ i²con²³ chie³ peih¹, jian³ a⁴hmah²ˉ³ i²con²³ a³tang³ hlion⁴ jian³ a³ŋang⁴. I⁴chie⁴³, hnei³ Neih³ˉ⁴, quie¹ la⁴ne³ ra⁵hnoh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Jian³ ma³a⁴tonh³ Neih³ˉ⁴ joh⁴³ cúa³⁴ˉ⁴ la⁴jeg³⁴. I⁴jon³ i¹jan³ sa⁴cm²³ A³jon⁴³ Jon⁴dai¹, jan³ Jon⁴dai¹ Jmai³pa² cu²³, jian³ i¹jan³ sa⁴cm²³ Jmai³i³, jan³ A³jon⁴³ pi²³i³ cu²³, jian³ a³hain⁴pa² cu²³ a³hnie³⁴ A³jon⁴³i³ ma⁵jnia³²i³ Jmai³i³ i²con²³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","I² jon³ a⁴jen³i³ chie³ quian¹, a⁴sagh⁴³i³ con³ ta⁵i²sa⁴sian³ chie³: ―Ta² tsei³⁴ jm² ren³ a³je²³ i⁴ti²jeh⁴ˉ³ tionh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","quie¹ jeu³⁴ˉ⁴ hnei³ i⁴jeun⁴³ a³sain² quian¹ Jon⁴dai¹ jian³ re¹ tionh² ma²i²je³⁴ i⁴ti²jeh⁴ˉ³ tionh²ˉ³, jian³ a⁵sia³ a⁴teg⁴ nei²i³; jian³ ma²i²nau³⁴i³ i⁴nauh³ˉ³ tionh²ˉ³, jian³ a⁵sia³ a⁴tang⁴i³ a⁴nau⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jon³ a⁴no³ jan³ a²teg²³ quian¹ lai²³, a⁴con²³i³ jau²chie⁴³ Jesús, a⁴juah⁴i³: ―Hnei³ A²teg²³, ¿henh⁴ hniah³ júan³²ˉ⁴ canh⁴a² li⁴sia³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quien⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","I² a⁴juah⁴ Jesús: ―¿Henh⁴ ra³sag² lai²³ liah⁴a² hegh³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","I² jon³ a⁴jainh³i³ jau²³, a⁴juah⁴i³: ―Ra³hleh²: “Ma⁴hno³² hnei³ Se³ño²³ Jon⁴dai¹ quianh³ i⁴jang³⁴ hoh⁴³ˉ³, jian³ i⁴lie²³ m⁴tyi⁴ quianh³ˉ³, jian³ li⁵teun⁴ cúah³tagh¹ˉ³, jian³ la⁴jeg³⁴ co³hei²tsei³ quianh³ˉ³”; jian³ ra³hleh² liah⁴: “Ma⁴hno³² hnei³ m⁵cu³ reunh³ liah⁴i² hnoh⁴ˉ³ húanh⁴³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jon³ a⁴juah⁴ Jesús: ―Ta² re³ a⁴jainh¹ˉ³ jau²³. Ma⁴tei³² hnei³ i⁴ne³, jon³ li⁴sia³ m⁵cu³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","I² hei⁴i³ ne⁵, a⁴júan⁴i³ i⁴lonh⁵i³, a⁴sagh⁴³i³ Jesús: ―¿Hain³ a³hain⁴ a³m⁵cu³ reunh³ˉ⁴ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Jan³ chie³ ŋo²³ ta⁵jeu³ Jericó a³ja²³ Jerusalén, i² jon³ a⁴jainh³i³ chie³ a³júan³ hang³ ho³²jeu³ tionh², a³a⁴qui³⁴ la⁴jeg³⁴ i⁴quieh¹i³; jian³ a⁴júanh¹i³, co⁴meih³i² sa⁴a⁴jaun³⁴, ma²jon³ a⁴cm⁴i³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","I² jon³ ne⁵, jon³ ja³⁴ jan³ m³chie³ jeu³ jon³; i² con³ma²a⁴jen³i³ a³a⁴jainh⁴³ eu⁴³ hain⁴ ra³quian³, jon³ ua⁴jeun³² jeu³ chie⁴³ pi²³i³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Conh⁴liah⁴ la⁴jon³ liah⁴, ja³⁴ jan³ chie³ levita jeu³ jon³, con³ma²a⁴tyie³⁴i³ hloh³² i²ra³quian³ a³a⁴jainh⁴³ eu⁴³ hain⁴; i² con³ma²a⁴je³i³, ua⁴jeun³² jeu³ chie⁴³ pi²³i³ quieh¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","I² coh⁵ jon³ ja³⁴ jan³ a³sian³ húa³⁴ Samaria a³hein² jeu³ jon³, con³ma²a⁴tyie³⁴i³ hloh³², jon³ a⁴jen³i³, jian³ joh³ ñei⁴ tsei⁴³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jon³ ŋo³⁴i³ hlonh²i³, a⁴jñei³⁴i³ o¹a³sai²te³ jian²³ o¹bein² i⁴eu⁴³ quieh¹, jian³ a⁴lie⁴i³ o¹leuh² hmh³, jian³ a⁴tyan⁴³i³ cah³² a²lo¹ quian¹, te¹i³ teg⁴ jauh³² i²jian²³ chie³ i²a⁴hion⁴³i³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","I² con³ma²a⁴jnia³⁴, con³ma²a⁴teg⁴ i²chianh³i³, jon³ a⁴tyi³i³ teun³⁴ o¹cau³² tie³, a⁴cúah³i³ a³quieh¹ jauh³², jian³ a⁴sagh⁴³i³: “Hion³² hnei³ a³ne³ hno⁵ˉ⁵, i² juah⁴ne³ ra⁵hniah³ i²co⁴meih³, ma²jon³ ma²hmah³²ˉ⁴ quianh³ˉ³ la⁴teg⁴i² ma³a⁴nia³⁴ˉ⁴ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","I² jon³ ne⁵, ¿hain³ conh⁴ li⁵on³ hain⁴ a³ma⁴jnia³ i⁴lang⁴³i³ a³m⁵cu³ reunh¹i³ a³a⁴júanh¹ a³júan³ hang³ hain⁴ tionh², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","I² jon³ a⁴juah⁴ a²teg²³ quian¹ lai²³: ―A³hain⁴pa² a³joh³ ñei⁴ tsei⁴³ i²con²³i³. I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Cua³, jian³ la⁴ne³ hniah³ júanh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jian³ hein² pi¹ Jesús jeu³, jon³ a⁴tyie³⁴i³ con³ jeu³ peih¹, i² jon³ a⁴hyei⁴³ jan³ a³m⁴ a³sain³ Marta quieh¹i³ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jian³ Marta ne³ ma²sian³ jan³ a³m⁴ reunh¹ a³sain³ Ma³rei² liah⁴, a³hain⁴ a³a⁴cua⁴ hlonh² Jesús, i⁴a⁴nau⁴i³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","I² Marta ne⁵, ta² hlion⁴ sa⁴jen²i³, si²júan³i³ ta¹, jon³ ŋo³⁴i³ hlonh² Se³ño²³, a⁴sagh⁴³i³: ―Hnei³ Se³ño²³, ¿o⁴ a⁵sia³ co³hei²tsei³ júanh³ˉ³ i⁴sa⁴si²ma³ho³² Ma³rei² reunh³ˉ⁴ ta¹ i⁴si²júan³⁴ˉ⁴ la³? Saih³²i³ hnei³, hno⁵ˉ⁵ ua²ma⁴ho³²i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","I² a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Hnei³ Marta, ta² so⁵ñih¹ˉ³ henh⁴ sianh³ˉ³, hlion⁴ co³hei²tsei³ júanh³ˉ³ nei² quieh¹ i⁴hlion⁴ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Con³pa² i⁴hniah³ lei⁴ ton³²nie⁴³. I² Ma³rei² ne⁵, ma³a⁴hnoh³i³ con³ i⁴tyein² hniah³, jian³ i¹jan³ sa⁴li⁴qui³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jian³ liah⁴ con³ i²ma²hein² Jesús ma²si²mh²i³ Jon⁴dai¹, i² con³ma²a⁴toh⁴ a⁴mh³i³ Jon⁴dai¹, jon³ a⁴juah⁴ jan³ chie³ quian¹i³: ―Hnei³ Se³ño²³, he³² hnei³ jnie³² liah⁴ mh³² jnie³² Jon⁴dai¹, la⁴jon³ liah⁴i² a⁴heh³ Juan³ Tei³² chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","I² jon³ a⁴juah⁴ Jesús: ―La⁴teg⁴i² mh³²ˉ³ Jon⁴dai¹ tionh²ˉ³, la⁴la³ hleh²ˉ³: Hnei³ Jmai³ jnie³², a³cua⁴³ ñi⁴jeu⁵, ua²lei⁴ hen² jm³i⁴sainh³ˉ³. Jian³ ua²jia³ jm² i⁴han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quianh³ˉ³. Ua²lei⁴ liah⁴ hnoh³ˉ³ nei² cuah³²húa³⁴ la³, liah⁴i² leg⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cúa² hnei³ a²hei⁴³ i⁴hniah³ quian⁴ jnie³² ne³⁴ conh⁴ con³ jm². ");
INSERT INTO cucNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jian³ hain⁴³ hnei³ chie³² quian⁴ jnie³², quie¹ hain⁵ jnie³² chie³² quieh¹ la⁴jang³⁴ a³júan³ hlagh³² i²con²³ jnie³². Jian³ a⁵con⁴ hnei³ jnie³² jau²chie⁴³, eu⁴³a² re³ lie³² hnei³ jnie³² la⁴jeg³⁴ i⁴hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jian³ a⁴juah⁴i³ jau²³ la³ liah⁴: ―Júan³²ˉ¹, jan³ hnei³ tionh²ˉ³ sian³ jan³ a³ñi³reunh³ˉ³. I² jon³ tyieh⁴ˉ³ jauh³² quieh¹i³ je¹nai³ húa²³, jeuh⁵i³ hnei³: “Hnei³ ming³²go⁴ quian³⁴ˉ⁴, ¿sa¹ tyih²ˉ³ hneng³ a²hei⁴³? ");
INSERT INTO cucNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Quie¹ cuan³⁴ jan³ a³ñi³reunh³ˉ⁴ jauh³² quien⁴ˉ⁴ a³hein² jeu³, jian³ sa⁴sia³ i⁴li⁴guenh³²i³ jnia⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","I² jon³ ra³ŋangh² a³hain⁴ ra³quian³ ta⁵jauh³², juah⁴i³: “A⁵ni³si⁴quian³² tsei³⁴ˉ⁴; quie¹ ma³si²jnang¹pa² o²hnei³² quien⁴ˉ⁴, ma³ra³han²pa² jnie³² jie³ jnie³² jon³segh³ˉ⁴; a⁵sie⁴³ li⁴no¹ˉ⁴ juah⁴ i⁴cúah²a² jnia⁴ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","I² juah³ jnia⁴ ne⁵, i² ua²liah⁴a² sa⁴i²no³⁴i³ o⁴ quie¹ i⁴ma²lang⁴³i³ ñi³reunh¹i³ i⁴cúah³i³, a⁵sia³, quie¹ i⁴jon³pa² no³⁴i³ quie¹ i⁴si²júan³ a³hain⁴ hlenh⁴³ i²con²³i³, jian³ cúa³⁴i³ la⁴jeg³⁴ la⁴conh⁴ hniah³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","I² jon³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ ne⁵: M² hnei³ tionh²ˉ³, quie¹ cúa³⁴ Jon⁴dai¹; hnieh³ hnei³, jian³ tyanh³²ˉ³ liah⁴; te² hnei³ o²hnei³², quie¹ nia³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Quie¹ la⁴jang³⁴ a³m²³, hyei³i³; jian³ la⁴jang³⁴ a³hnoh³, tyieh¹i³; jian³ la⁴jang³⁴ a³te²³ o²hnei³², nia²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Jian³ hain³ hnei³ tionh²ˉ³ liah⁴, li⁴cúah³²ˉ³ a³jonh³ m⁴caun² juah⁴ne³ m²³i³ a²hei⁴³ i²conh²ˉ³? Jian³ juah⁴ne³ m⁴³i³ jon⁴³júa³², i⁴niah¹ jon⁴³júa³² ne⁵, ¿o⁴ li⁴cúanh³²i³ hnei³ jan³ a⁵mh³? ");
INSERT INTO cucNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Jian³ juah⁴ne³ m²³i³ con³ m⁴jlag³² a¹hyie²³, ¿o⁴ li⁴cúanh³²i³ hnei³ a¹hnei⁴³? ");
INSERT INTO cucNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Quie¹ ua²liah⁴a² hlangh² hnei³ tionh²ˉ³, ñih¹ˉ³ cúah⁵ˉ³ si³jonh³ i⁴tsei³⁴, ¿la⁴conh⁴a² sa⁴ Naih⁴³ˉ³ a³cua⁴³ ñi⁴jeu⁵, cúa³⁴i³ M⁴tyi⁴ quieh¹ i²con²³ la⁴jang³⁴ a³m²³ i²con²³i³? ");
INSERT INTO cucNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Con³ jm² ma²si²tyi³ Jesús con³ m⁴tyi⁴ hlagh³² i⁴ma²júan³ con² jan³ chie³; i² con³ma²ua⁵hag⁴³ m⁴tyi⁴ hlagh³² jon³, jon³ a⁴hleh⁴ a³ma²con² hain⁴. Jian³ ta² co³ a⁴jainh⁴³ la⁴jang³⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","I² ca³chion²³ a³hain⁴ tionh² a⁴juah⁴: ―Con⁴juah⁴ ua³pei⁴ quieh¹ Beelzebú, jeu³² m⁴tyi⁴ hlagh³²pa², húa³ a³ne³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jian³ i²ca³chion²³ a⁴m⁴ ua³júah² i⁴jia²³ ñi⁴jeu⁵ i⁴con²³i³ jau²chie⁴³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","I² Jesús ne⁵, si²ñi³i³ co³hei²tsei³ i⁴ti²júan³ a³hain⁴ tionh², jon³ a⁴sagh⁴³i³: ―La⁴jeg³⁴ nación i²si³tang⁴ chie³ i⁴tionh²i³ ma⁵quein²³ jo³², tyan⁴³i³, jian³ a³tionh² con³ jauh³² a³si³tang⁴ i⁴sa⁴tionh²i³ con³ co³hei²tsei³, so⁵jenh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jian³ la⁴ne³ liah⁴, juah⁴ne³ si³tang⁴ a⁵lainh³² jian²³ a³tionh² jian²³, ¿liah⁴a² li⁴úan⁴i³ heih⁴³ quieh¹i³, lainh⁴ˉ³? Quie¹ juah⁴ˉ³ tionh²ˉ³ i⁴húa³⁴ jnia⁴ m⁴tyi⁴ hlagh³² con⁴juah⁴ ua³pei⁴ quieh¹ a³sa⁴tsein³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Quie¹ juah⁴ne³ i⁴chie⁴³ húa³⁴ˉ⁴ m⁴tyi⁴ hlagh³² con⁴juah⁴ ua³pei⁴ quieh¹ a³sa⁴tsein³⁴, i² chie³ quianh³ˉ³ ne⁵, ¿hain³ con⁴juah⁴ ua³pei⁴ quieh¹ húa³i³ tionh²? I² la⁴jon³ hei⁴ pi²³i³ ma³jnia³ i⁴sa⁴re³ co³hei²tsei³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","I² juah⁴ne³ húa³⁴ˉ⁴ m⁴tyi⁴ hlagh³² con⁴juah⁴ ua³pei⁴ quieh¹ Jon⁴dai¹ ne⁵, lei³ jnia⁴ la⁴ne³ i⁴ma³a⁴tyie³⁴ jm² i⁴hanh⁵ˉ³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Júan³²ˉ¹, la⁴teg⁴i² jan³ chie³ re³ huanh⁴³ hie³i³ jauh³² júah³ quieh¹, i⁴sianh³i³ la⁴jeg³⁴ a²ñi²³ i⁴jainh²i³ jm² quieh¹, i⁴jon³ i¹jan³ sa⁴li⁴si⁵tian⁴³ juah⁴ i⁴si⁵qui⁴³i³ i⁴tieh³² jauh³². ");
INSERT INTO cucNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jian³ juah⁴ne³ ja³⁴ i²jan³ a³tyein² pain⁴ la⁴conh⁴a² a³hain⁴, jon³ li⁴cagh¹i³ jm² i²con²³i³, jian³ qui³⁴i³ la⁴jeg³⁴ a²ñi²³ i⁴ma²jainh²i³ jm² i⁴ma²hain³² tsei⁴³i³, jon³ qui³⁴i³ la⁴jeg³⁴ i⁴tieh³² jauh³² jon³, tyieh⁵i³ i²con²³ a³jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’A³hain⁴ a³sa⁴quein⁴³ tsei⁴³ jian²³ˉ⁵, a³hain⁴pa² hie²³ jnia⁴; a³hain⁴ a³sa⁴jaih² chie³ i²con²³ˉ⁵, júan³i³ i⁴so³jenh² chie³ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’La⁴teg⁴i² si³hag⁴³ con³ m⁴tyi⁴ hlagh³² naih⁵ ni²tsei⁴³ jan³ a³ñih³, jon³ ŋeng²³i³ ta⁵húa³⁴ quein³, hnoh³i³ i²jian³⁴i³; i² sa⁴tyieh¹i³ ne⁵, i² jon³ juah⁴i³: “Naih²ˉ⁵ jauh³² quien⁴ˉ⁴ i²ma²a⁴jau³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","I² tei⁴³i² a⁴tyanh³i³, jon³ jen³i³ a³ñih³ hain⁴ liah⁴i² leg⁴³ con³ jauh³² i⁴re³ si²hyah² jian³ si²lag¹. ");
INSERT INTO cucNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","I² jon³ chie²³i³ si⁵quian⁴i³ i²quie³⁴ m⁴tyi⁴ tyein² hlangh² la⁴conh⁴a² hei⁴i³, ma²jon³ han⁵i³ naih⁵ ni²tsei⁴³ a³ñih³ hain⁴, cua³⁴i³; i² jon³ eu⁴³ pi¹ hlagh³² hie⁴³ quionh⁴ a³ñih³ hain⁴ i²a⁴toh⁴ la⁴conh⁴a² ma²ra⁵lie⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Con³ma²si²hleh²i³ jau²³ ne³, con³ a⁴la³ a⁴hleh⁴ jan³ a³m⁴ i⁴tia⁴ jen² chie³ jeun⁴³ tionh², a⁴juah⁴i³: ―¡Ta² tsei³⁴ jm² ren³ a³m⁴ a³a⁴can³⁴ jian³ a³a⁴teinh⁴³ hnei³! ");
INSERT INTO cucNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","I² a⁴juah⁴ Jesús ne⁵: ―¡Eu⁴³a² tsei³⁴ jm² ren³ a³nau³ jau²³ quieh¹ Jon⁴dai¹, jian³ ma⁴tei⁵i³! ");
INSERT INTO cucNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Con³ma²a⁴ŋangh³ chie³ jeun⁴³ hlonh² Jesús, jon³ a⁴juah⁴i³: ―Ta² hlangh² chie³ a³sian³ tieh²la³; m²³i³ i⁴júan³²ˉ⁴ ua³júah²; quie¹ a⁵sie⁴³ ua³júah² ma⁵li⁴lei⁴ i⁴seg³⁴, con³ ua³júah² i⁴a⁴leg³⁴ i²con²³ Jonás, a³sain² hain⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Quie¹ a⁴leg³⁴ ua³júah² i²con²³ Jonás i⁴a⁴júan⁴ lei³ i²con²³ a³tionh² Nínive, jian³ la⁴ne³ lei⁴ ua³júah² i²con²³ A³a⁴lang³⁴ Chie³ hain⁴ i⁴júan³⁴ lei³ quieh¹ a³sian³ ne³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jian³ la⁴teg⁴i² can³⁴ Jon⁴dai¹ jau²chie⁴³ i²con²³ m⁵cu³, jon³ ra⁵hang³² a¹si²re¹ quian¹ Ta⁵ñei³⁴ jian²³ chie³ a³sian³ tieh²la³, jian³ hnang⁵i³ hnei³ tionh²ˉ³, quie¹ cuan³⁴ a¹si²re¹ i⁴ja³⁴i³ i²gm⁴ don⁵ i⁴ua⁵nai³i³ jau²³ i⁴ŋang⁴ re¹ Salomón; jian³ sainh⁴³ jan³ i²la³ a³júanh⁴³ a⁵hei⁴³ lia⁴ Salomón. ");
INSERT INTO cucNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Conh⁴liah⁴ co⁴jon³ ra⁵hang³² a³ma²sian³ Nínive tei⁴³i² can³⁴ Jon⁴dai¹ jau²chie⁴³ i²con²³ m⁵cu³ jian²³ chie³ a³sian³ tieh²la³, jian³ hnang⁵i³ hnei³ tionh²ˉ³; quie¹ ta⁵la⁴ a⁴sag²³ co³hei²tsei³ quieh¹i³ tionh² jau²³ i⁴a⁴hleh⁴ Jonás; jian³ sainh⁴³ jan³ i²la³ a³júanh⁴³ a⁵hei⁴³ lia⁴ Jonás. ");
INSERT INTO cucNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Jian³ sa⁴hainh²i³ con³ o¹jyi³ juah⁴ i⁴seih³i³ i²si²hma², jian³ o⁴ naih⁵ a²hma³ ca³jeun²³, quie¹ seih²i³ con³ i²leg⁴³ yeih³²pa², canh⁴a² la⁴jang³⁴ a³si³hei⁴ jauh³² je³⁴i³ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Quie¹ m⁴mah²ˉ³ leg⁴³ liah⁴i² leg⁴³ o¹jyi³ heh³²ˉ³; i² juah⁴ne³ tsei³⁴ m⁴mah²ˉ³, jon³ joh¹ heh³²ˉ³ la⁴tan² con³; i² juah⁴ne³ sa⁴tsei³⁴ m⁴mah²ˉ³, la⁴tan² heh³²pa² hnei³ naih³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jianh³ˉ³ júan² hnei³ canh⁴a² sa⁴liah⁴ joh¹ i⁴leg⁴³ m⁴mah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jian³ la⁴ne³ liah⁴, juah⁴ne³ joh¹ la⁴tan² janh³ˉ³ jian³ i¹con³ i²naih³ sa⁴sia³ i²conh²ˉ³, jon³ li⁴jeh²ˉ³ re³ la⁴jeg³⁴ liah⁴i² júan³ o¹jyi³ i⁴joh¹ la⁴tan² janh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Con³ma²a⁴toh⁴ a⁴hleh⁴ Jesús, jon³ a⁴m⁴ jan³ chie³ fariseo i⁴si⁵queuh³i³ a²hei⁴³ jian²³i³. Con³ma²a⁴tyie³⁴ Jesús jauh³², jon³ a⁴cua⁴i³ a²me²sa³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","I² con³ma²a⁴je³⁴ fariseo hain⁴ i⁴sa⁴a⁴raunh⁵i³ si¹cúa³ ñeih³² naih⁵i² queuh⁴³i³, i⁴jon³ ta² co³ a⁴jainh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","I² jon³ a⁴juah⁴ Se³ño²³: ―I² jon³ ne⁵, hnei³ tionh²ˉ³ fariseo, quie¹ raunh³ˉ³ jmah³ ta⁴coh⁵ a²va²so³ jian³ a²gm⁴³; i² naih⁵ m⁴tyi⁴ quianh³ˉ³ ne⁵, si²canh³ i⁴hang³ jian³ la⁴jeg³⁴ i⁴hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hnei³ chie³ hmengh² tsei⁴³, ¿o⁴ a⁵sia³ ñih¹ˉ³ i⁴ Jon⁴dai¹pa² a⁴júan⁴ la⁴jeg³⁴ i⁴quieh¹ ta⁴coh⁵ i⁴je²³i³, jian³ hei⁴ pi²³i³ a⁴júan⁴ m⁴tyi⁴ quieh¹ chie³ i⁴sa⁴lain³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma⁴hon³² hnei³ a³ti⁴ñei³ la⁴conh⁴ i⁴sia³ quianh³ˉ³, i² la⁴ne³ li⁴tsei³⁴ co³hei²tsei³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ fariseo! Quie¹ cúah³ˉ³ a²teg⁴ quia³⁴ chieh³² o¹a³siah³ jian³ o¹m⁴ ruda jian³ la⁴jeg³⁴ nai² o¹m⁴ seg³⁴ i⁴queuh³i³; i² i⁴tyein² quein⁴³ ne⁵, a⁵sia³ ma⁵teih³²ˉ³, i⁴júan³i³ i⁴tsei³⁴ jian³ i⁴hnio³⁴i³ Jon⁴dai¹. I⁴ne³pa² tyein² hniah³ júanh²ˉ³ ton³²nie⁴³. Jian³ liah⁴ma³cúah³ ne³pa² hnei³ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, fariseo! Quie¹ si³hyonh³ˉ³ neih²ˉ³ hien²³ chie³ canh² cuah³ judío, jian³ si³hyonh³ˉ³ i⁴ma³co⁴³ hnei³ chie³ je¹hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³ jian³ fariseo, a³júan³ ni²taih⁴³! Quie¹ langh⁴³ˉ³ liah⁴i² leg⁴³ to³ quieh¹ a³jaun² i⁴sa⁴lain³, jian³ a³hain⁴ a³ŋeng²³ nei² sa⁴laih²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","I² jon³ a⁴ŋangh³ jan³ a²teg²³ quian¹ lai²³, a⁴juah⁴i³: ―Hnei³ A²teg²³, i⁴hleh³ˉ³ ne³, ta² eu⁴³ jain⁴³ jnie³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","I² jon³ a⁴juah⁴ Jesús: ―¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³ liah⁴, hnei³ a²teg²³ quian¹ lai²³! Quie¹ cúah³ˉ³ heih⁴³ hyei³ i²con²³ chie³ i⁴sa⁴tieh¹i³ ma⁴tei⁵i³, la⁴con³ lie²³. I² hnei³ tionh²ˉ³ ne⁵, i¹ sa⁴i²teih³²ˉ³ si¹cúah³ i⁴ma²hoh³²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Jian³ ti⁴³ jeuh²ˉ³ tionh²ˉ³ liah⁴! Quie¹ júanh³ˉ³ hyah³ i⁴leg⁴³ a²hnei⁴³ peih¹ i²ti²hon³ a³sain² quian¹ Jon⁴dai¹, a³hain⁴ a³ma⁴tyan³ naih⁴³sieh³ˉ³ tionh²ˉ³ ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","I² la⁴ne³ ma⁵jniah³²ˉ³ i⁴hyon³ hoh⁴³ˉ³ i⁴a⁴júan⁴ naih⁴³sieh³ˉ³ la⁴jon³; quie¹ i⁴chie⁴³pa² ma⁴tyan³i³ a³sain² hain⁴ tionh², jian³ hnei³ tionh²ˉ³ júanh³ˉ³ hyah³ i²ra³han²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’I⁴jon³ ga² a⁴juah⁴ Jon⁴dai¹ con⁴juah⁴ i⁴re³ ŋang⁴i³: “Sain¹ˉ⁴ a³hleh² jau²³ quien⁴ˉ⁴ jian³ a³hei¹ joh⁴³ cúa³ ta¹ quien⁴ˉ⁴ i²con²³i³ tionh², ca³chion²³ hain⁴ tionh² jŋangh³i³, jian³ ca³chion²³ qui⁴hang³⁴i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","I² la⁴ne³ con⁴³ Jon⁴dai¹ hmah¹ i²con²³ chie³ a³sian³ tieh²la³ tionh² nei² quieh¹ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ a³a⁴jŋangh⁴i³ liah⁴ma²ra⁴lie⁵ m⁵cu³, ");
INSERT INTO cucNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","liah⁴ma²ra⁴lie⁵ a⁴tain³⁴i³ jm³yein⁴ quieh¹ Abel la⁴teg⁴ Zacarías a³a⁴jaun³⁴ hloh³² ni²hyie⁴ i²jang³i³ jah⁴ cuah³júah². I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, con⁴³ Jon⁴dai¹ hmah¹ i²conh² hnei³ tionh²ˉ³ a³sian³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ti⁴³ jeuh²ˉ³ tionh²ˉ³, hnei³ a²teg²³ quian¹ lai²³! Quie¹ sa⁴cúah³ˉ³ i⁴li⁴ŋang⁴ chie³; jian³ sa⁴i²heuh¹ˉ³ i⁴lionh⁴ˉ³ húanh⁴ˉ³, jian³ a⁵ga⁴ cúah³ˉ³ i⁴han⁵ a³sang²³ i⁴lion⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Con³ma²a⁴hleh⁴ Jesús jau²³ jon³ i²con²³ a²teg²³ quian¹ lai²³ jian³ fariseo tionh², ta² hlion⁴ a⁴jain³⁴ tsei⁴³i³ tionh², jon³ a⁴ŋang⁴i³ hlion⁴ jau²³ i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","i⁴con²³i³ jau²chie⁴³ i²con²³i³, i⁴hnie³⁴i³ si⁵seun³ Jesús jau²³ canh⁴a² la⁴jon³ li⁴hnang⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ta¹la⁴ jon³ a⁴ŋangh³ ta⁵la⁵mai²³ chie³, qui⁴hlian⁴³i³ jon²reunh¹, jon³ ma⁴lie⁵ Jesús a⁴hlenh⁴³i³ ñeih³² co⁴ra⁴lie⁵ chie³ quian¹, a⁴juah⁴i³: ―Jianh³ˉ³ júan² hnei³ o¹sieh³² a²hei⁴³ñih¹ quieh¹ chie³ fariseo tionh², i⁴ra³juah⁴ i⁴júan³i³ i⁴ni²taih⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Quie¹ i¹con³ i⁴ni²jleg³ sa⁴sia³ juah⁴ i⁴sa⁴li⁴jñeih³, jian³ i¹con³ i⁴ni²hma² juah⁴ i⁴sa⁴li⁴ñi³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jian³ la⁴ne³ liah⁴, la⁴jeg³⁴ i⁴hleh³ˉ³ ta⁵i²nai³ tionh²ˉ³, liah⁴ ma³tyie¹pa² i²li⁴ñi³ chie³ liah⁴i² leg⁴³ i⁴tagh³ joh¹; jian³ la⁴jeg³⁴ i⁴hleh³ˉ³ jauh³² si²jnang¹, liah⁴ ma³tyie¹pa² jm² i⁴hnai⁵ chie³ lau² tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Jian³ jeu³⁴ˉ⁴ hnei³ liah⁴, hnei³ ñi³reunh³ˉ⁴ tionh²ˉ³, a⁵júan³ hnei³ canh⁴³ a³jŋangh² heh³²ˉ³, quie¹ tei⁴³i² ma³a⁴leg³⁴ jon³, a⁵sie⁴³ i⁴ma⁵li⁴júan³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","I² jeu¹ˉ⁴ hnei³ ne⁵, hain³ hniah³ júanh²ˉ³ canh⁴³ˉ³ tionh²ˉ³: júan² hnei³ canh⁴³ a³hain⁴ a³tei⁴³i² ma³a⁴jŋangh⁴ hnei³, quian³i³ ua³pei⁴ i⁴li⁴ton³⁴i³ hnei³ qui⁴jeu⁵ liah⁴. I⁴chie⁴³pa² juah³ˉ⁴, a³ne³pa² hniah³ júanh²ˉ³ canh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿O⁴ sa¹ chie⁴³ hnang⁴³i³ hña⁴ jon⁴³tan²³ peih¹ conh⁴ teun³⁴ ñi²hña⁴, liah²? I² la⁴ne³ ne⁵, i¹jan³ jah⁴ peih¹ hain⁴ sa⁴si³hain⁴ tsei⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Quie¹ la⁴teg⁴ hmh⁴jñi³ tyih³ˉ³ ni²hei²³ la⁴jeg³⁴ i²con²³ Jon⁴dai¹. I² la⁴jon³ a⁵júan³ hnei³ canh⁴³, quie¹ eu⁴³a² hlion⁴ queinh⁴³ˉ³ tionh²ˉ³ la⁴conh⁴a² jeun⁴³ jon⁴³tan²³ peih¹. ");
INSERT INTO cucNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Jian³ juah³ˉ⁴ liah⁴, la⁴jang³⁴ a³ma³jnia³ i⁴lang⁴³i³ chie³ quian³⁴ˉ⁴ ta⁵nei² chie³ tionh², jon³ hleh³ A³a⁴lang³⁴ Chie³ hain⁴ liah⁴ i⁴lang⁴³i³ chie³ quian¹i³ ta⁵nei² la⁴jang³⁴ ángel quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jian³ a³hain⁴ a³sa⁴ma³jnia³ i⁴lang⁴³i³ chie³ quian³⁴ˉ⁴ ta⁵nei² chie³, jian³ la⁴ne³ liah⁴ si⁵hleh² i⁴sa⁴cu²³i³ ta⁵nei² la⁴jang³⁴ ángel quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Jian³ la⁴jang³⁴ a³hleh³ jau²hlagh³² nei² quieh¹ A³a⁴lang³⁴ Chie³ hain⁴, li⁴jlenh⁴³pa² chie³² quieh¹i³; i² a³hleh³ jau²hlagh³² nei² quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, sa⁴li⁴jlenh⁴³ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’La⁴teg⁴i² jie³i³ hnei³ teg⁴ cuah³ judío, jian³ o⁴ ta⁵nei² júa¹ jian³ o⁴ ta⁵nei² si³ta¹ sang³⁴, sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ ñeih³² henh⁴ jau²³ jainh²ˉ³ jian³ o⁴ henh⁴ hleh²ˉ³, ");
INSERT INTO cucNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","quie¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹pa² cúa³⁴ hnei³ jau²³ o²ra³ jon³ henh⁴ hniah³ hleh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jon³ a⁴juah⁴ jan³ chie³ a³hein² jen² a³jeun⁴³ hain⁴ tionh²: ―Hnei³ A²teg²³, saih³² a³reunh³ˉ⁴, hno⁵ˉ⁵ ua²tyon³⁴i³ i⁴tain⁴³ jnie³² jie³i³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","I² a⁴juah⁴ Jesús i²con²³i³ ne⁵: ―Hnei³ chie³, ¿o⁴ lainh⁴ˉ³ i⁴tain⁴³ˉ⁴ can¹ˉ⁴ jau²chie⁴³ nei² ne³ jian³ o⁴ i⁴tyieh²ˉ⁵ i⁴sia³ quianh³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jian³ a⁴juah⁴ pi¹i³ liah⁴: ―Jian³ jianh³ˉ³ júan² hnei³ la⁴jeg³⁴ i⁴tsainh³ chie³ i⁴hnie³⁴i³ hlion⁴, quie¹ a⁵sia³ re³ sian³ chie³ con⁴juah⁴ i⁴sia³ quieh¹i³ hlion⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jian³ a⁴can³⁴i³ con³ jau²³, a⁴sagh⁴³i³ a³hain⁴ tionh², juah⁴i³: ―Ma²sian³ jan³ chie³ jlanh² a³ma³jnia² húa³⁴ júah³ quieh¹ i⁴a⁴lo³ hlion⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I² hei⁴i³ ne⁵, a⁴júan⁴i³ co³hei²tsei³ hña³, lain⁴i³: “¿Liah⁴ júan³²ˉ⁴ tieh²la³? Quie¹ so⁵sia³ i²li⁴tya¹ˉ⁴ la⁴jeg³⁴ i⁴a⁴lo³ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","I² jon³ a⁴juah⁴i³: “La⁴la³pa² júan³²ˉ⁴: Eu⁴³a² re³ jeh²ˉ⁵ i⁴tieh³² i⁴quieh¹ liah⁴ma²jia⁴³, jon³ júan³²ˉ⁴ i⁴cah². I² jon³ tya¹ˉ⁴ la⁴jeg³⁴ i⁴a⁴lo³ quien⁴ˉ⁴ jian³ la⁴jeg³⁴ lie²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma²jon³ jeu¹ˉ⁴ m⁴tyi⁴ quien⁴ˉ⁴: Hnei³ m⁴tyi⁴ quien⁴ˉ⁴, ta² hlion⁴ sia³ quianh³ˉ³ i⁴nie⁴³, tieh¹ hlion⁴ ñi³; tai³² san⁴ hnei³ quianh³, cauh⁴³ hnei³, hainh⁴ hnei³, co³hyon²³tsei³ quian³ hnei³ quianh³.” ");
INSERT INTO cucNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","I² a⁴juah⁴ Jon⁴dai¹ i²con²³i³ ne⁵: “Hnei³ chie³ hmengh² tsei⁴³, je¹nai³ ne³⁴ tieh⁴ m⁵cu³ quianh³ˉ³; jian³ la⁴jeg³⁴ i⁴sia³ quianh³ˉ³ jon³, ¿hain³ chianh² li⁴quieh¹, lainh⁴ˉ³?” ");
INSERT INTO cucNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La⁴ne³ jainh⁴³ chie³ a³júan³ i⁴jlanh² hña³, jian³ i¹con³ sa⁴sia³ quieh¹i³ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jian³ ma²a⁴leg³⁴ jon³, a⁴sagh⁴³i³ chie³ quian¹: ―I² la⁴jon³ ne⁵, jeu³⁴ˉ⁴ hnei³ tionh²ˉ³: Sa⁴júanh²ˉ³ hlion⁴ co³hei²tsei³ liah⁴ sianh³ˉ³, henh⁴ queuh²ˉ³, jian³ o⁴ nei² quieh¹ heh³²ˉ³ henh⁴ heuh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Quie¹ hlion⁴ quein⁴³ m⁵cu³ quieh¹ chie³ la⁴conh⁴a² i⁴queuh³i³, jian³ hlion⁴ quein⁴³ he³² chie³ la⁴conh⁴a² i⁴hein²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jen³² hnei³ jon⁴³tan²³, quie¹ sa⁴jnei³i³ jian³ sa⁴jaih²i³ juah⁴ i⁴a⁴lo³, jian³ a⁵sia³ jauh³² sia³ quieh¹i³ jian³ o⁴ a²quei³ juah⁴ i²li⁴tya³⁴i³; i² la⁴jon³ ne⁵, Jon⁴dai¹pa² gueh⁴ quieh¹i³. ¿O⁴ a⁵sia³ queinh⁴³ˉ³ hlion⁴ tionh²ˉ³ la⁴conh⁴a² jon⁴³tan²³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Jian³ hain³ hnei³ li⁴si⁵cúanh³ˉ³ i²ca³leg³ nei² quieh¹ hlion⁴ co³hei²tsei³ i⁴sianh³ˉ³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Juah⁴ne³ sa⁴tian⁴ lei⁴ con³ i⁴peih¹ la⁴ne³, ¿i² e⁴le³⁴ ti²júanh³ˉ³ hlion⁴ co³hei²tsei³ nei² quieh¹ la⁴jeg³⁴ i⁴seg³⁴ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Je² hnei³ con³ o¹lei²³ liah⁴ si³cúan³. I¹ sa⁴júan³i³ ta¹, a⁵ga⁴ ta²³i³ liah⁴. I² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i¹ re¹ Salomón a³tyein² ma²jlanh², a⁵sia³ a²hmh³ a⁴hei³⁴i³ i⁴tyein² tsei³⁴ jnia⁴ liah⁴i² jnia⁴ o¹lei²³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Quie¹ juah⁴ne³ la⁴ne³ cúa²³ Jon⁴dai¹ a²cúan³ o¹nau³ i⁴tsei³⁴ jnia⁴ i⁴sia³ i²nau³ con³ ne³⁴, jian³ hie³⁴ jon³ co³⁴ joh⁴³ a²gm², ¿la⁴conh⁴a² sa⁴cúa³⁴i³ i²conh²ˉ³ tionh²ˉ³, hnei³ chie³ a³sa⁴hain⁴ hlion⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","I⁴jon³ sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ tionh²ˉ³ nei² quieh¹ henh⁴ hniah³ queuh²ˉ³, jian³ o⁴ henh⁴ hniah³ hauh²ˉ³, la⁴jan³ a³chionh⁴ tsei⁴³ i⁴sianh³ˉ³ co³hei²tsei³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Quie¹ la⁴jeg³⁴ i⁴ne³ hnoh³ chie³ quian¹ m⁵cu³ la³; i² Naih⁴³ hnei³ tionh²ˉ³ ne⁵, ñi³i³ i⁴hniah³ la⁴jeg³⁴ i⁴ne³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","I⁴jon³ tyein² hniah³ tonh²ˉ³ co³hei²tsei³ quianh³ nei² quieh¹ hain³liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, jian³ ma²jon³ hyeih²ˉ³ la⁴jeg³⁴ i⁴hniah³ quianh³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’A⁵júan³ hnei³ canh⁴³ tionh²ˉ³, a⁵a³siah³ quian³⁴ˉ⁴, quie¹ si³hyonh³ Naih⁴³ˉ³ cúa²³i³ i⁴júanh²ˉ³ heih⁴³ jianh²i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hnang² hnei³ i⁴sia³ quianh³ tionh²ˉ³, jian³ ma⁴hon³² hnei³ a³ti⁴ñei³; júan² hnei³ jlanh²ˉ³ i²con²³ Jon⁴dai¹ i²so⁵jeun⁴ a²to³hmh³ quieh¹ o¹cau³², i²jon³ i²jlanh² chie³ sa⁴legh⁴ ua²a⁴chia³⁴ ñi⁴jeu⁵, jian³ i²jon³ i²sa⁴li⁴si⁵hei⁴ a³júan³ hang³ jian³ i²so⁵toh² jah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Quie¹ i²jon³ i²nie⁴³ i⁴jlanh² quianh³ˉ³, i²jon³pa² ya¹queunh³ hoh⁴³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Júan² hnei³ co³jian¹ la⁴jan³ a³re³ hñih² a²cúan³ jian³ o³re³ hainh⁴³ hnei³ o¹jyi³ quianh³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Júan² hnei³ liah⁴i² júan³ a³cúa²³ cúa³tag³² a³ti²jian⁴³ jeu³² a³jionh⁴ a³hein² i²sanh⁴ chie³, canh⁴a² la⁴teg⁴i² ma³jonh²i³ si²te²³i³ o²hnei³², ma³sia² nia³⁴i³ liah⁴ma²jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ta² tsei³⁴ jm² li⁴ren³ a³cúa²³ cúa³tag³² hain⁴ tionh² i⁴la⁴teg⁴i² a⁴tyanh³ jeu³²i³, jen⁴³i³ i⁴ti²nai²i³. I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, hag⁵ jeu³²i³ a²hmh³ ta⁵nei², tyan⁵i³ a³hain⁴ mesa tionh², jian³ tya³⁴i³ ma³⁴ guenh⁴³i³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jian³ ta² tsei³⁴ jm² li⁴ren³ a³hain⁴ tionh² a¹juah⁴ne³ a⁴jen³i³ i⁴ti²nai²i³ i⁴jonh³i³ je¹nai³ húa²³ jian³ o⁴ ta⁵jnia³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jian³ ñih¹ˉ³ i⁴la³ liah⁴, juah⁴ne³ ma²ñi³ jan³ a³quieh¹ jauh³² hain³ o²ra³ ma²tyie¹ a³júan³ hang³ jauh³² quieh¹i³, jon³ ma²si²jian³i³, sa⁴ma²cúa³⁴i³ i⁴si⁵hei⁴i³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jian³ hnei³ tionh²ˉ³ liah⁴, júan² hnei³ co³jian¹, quie¹ jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴ jm² sa⁴jianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jon³ a⁴ŋang⁴ Pe³² i²con²³ Jesús: ―Hnei³ Se³ño²³, ¿o⁴ a⁴quianh³ˉ³ jau²³ ne³ i⁴jeuh⁵ˉ³ jnie³² jian³ o⁴ i⁴jeuh⁵ˉ³ la⁴jang³⁴pa²? ");
INSERT INTO cucNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","I² jon³ a⁴juah⁴ Se³ño²³: ―¿Hain³ hnei³ tionh²ˉ³ lang⁴³ la⁴jan³ a³cúa²³ cúa³tag³² a³ni²taih⁴³ jian³ a³sian³ tsei⁴³, a³a⁴ron⁴³ jeu³² joh⁴³ cúa³ la⁴jang³⁴ a³tionh² jauh³² quieh¹, canh⁴a² guenh⁴³i³ a³hain⁴ tionh² o²ra³ quieh¹? ");
INSERT INTO cucNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Eu⁴³ tsei³⁴ jm² li⁴ren³ a³cúa²³ cúa³tag³² a³ma³tei⁵ la⁴ne³, la⁴teg⁴i² ma³jonh² jeu³²i³, jian³ je⁴³i³ i⁴si²júan³i³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, jon³ tonh³i³ joh⁴³ cúa³ a³cúa²³ cúa³tag³² hain⁴ la⁴jeg³⁴ i⁴sia³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","I² juah⁴ne³ hlangh² a³cúa²³ cúa³tag³² hain⁴ jian³ júan³i³ co³hei²tsei³, lain⁴i³: “Len⁴ pi¹ jeu³²ˉ⁴ i⁴jionh⁴.” Jon³ ma⁴lie⁵i³ júanh¹i³ a³cúa²³ cúa³tag³² reunh¹ a³ñih³ a³m⁴ tionh², jian³ queuh³i³ hangh²i³ jian³ li⁴hain⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","I² jon³ jionh⁴ jeu³² a³cúa²³ cúa³tag³² hain⁴ jm² sa⁴si²jian²³i³ jian³ o²ra³ sa⁴ñi³i³; i² jon³ he³⁴ jeu³²i³ ma²eu⁴³ pain⁴ i²con²³i³, i⁴jainh⁴³i³ liah⁴i² jainh⁴³ a³sa⁴hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’I² a³cúa²³ cúa³tag³² a³ñi³ heih⁴³ quieh¹ jeu³² i⁴hniah³ i⁴ma²júan³⁴i³ jian³ sa⁴a⁴júan⁴i³, jian³ a⁵ga⁴ a⁴júan⁴i³ co³jian¹, jon³ po³⁴i³ hlion⁴ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","I² a³cúa²³ cúa³tag³² a³sa⁴ñi³ henh⁴ hniah³ júan³⁴i³ i²con²³ jeu³², jian³ a⁴júan⁴i³ i⁴hlagh³² i⁴haih¹ i⁴hyieh⁴i³ ma²eu⁴³, jon³ po³⁴ jeu³²i³ co⁴meih³. Quie¹ a³hain⁴ a³hei¹ hlion⁴ joh⁴³ cúa³, jon³ m⁴³ jeu³²i³ hlion⁴ i²con²³i³, jian³ a³hain⁴ a³hei¹ hlion⁴ lau², tsei³⁴sa² hlion⁴ m⁴³i³ i²con²³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Quie¹ cuan⁵ˉ⁵ ua⁵tya³⁴ˉ⁴ hnai³qui³ nei² cuah³²húa³⁴ la³ la⁴con³ i⁴ya¹tyi¹ jyi³ loh⁴³, jian³ ta² hno⁵ˉ⁵ a²juah⁴ ma²si²lei⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jian³ hniah³ can¹ˉ⁴ con³ ma²eu⁴³ pain⁴. ¡Jian³ ta² hlion⁴ co³hei²tsei³ sian³⁴ˉ⁴ la⁴conh⁴i² ra⁵tei⁴³ i⁴ne³! ");
INSERT INTO cucNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿O⁴ cuan⁵ˉ⁵ i⁴júan³²ˉ⁴ i⁴cua³⁴ chie³ tai³² cuah³²húa³⁴ la³, lainh⁴ˉ³ tionh²ˉ³? Jeu³⁴ˉ⁴ hnei³, a⁵sia³, quie¹ i⁴han⁵ chie³ ma⁵quein²³ co³hei²tsei³pa². ");
INSERT INTO cucNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Quie¹ tieh²la³ jian³ ta⁵i²chie³⁴ la³ tyon⁴ hña⁴ chie³ con³ jauh³²: on³ chie³ sa⁴cang³⁴ tsei⁴³ jian²³ on³⁴, jian³ on³⁴ sa⁴cang³⁴ tsei⁴³ jian²³ on³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jmai³i³ sa⁴cang³⁴ tsei⁴³ jian²³ a³jon⁴³, jian³ a³jon⁴³i³ jian²³ jmai³ liah⁴; jian³ sa⁴cang³⁴ tsei⁴³ sie²³ jian²³ a³m⁴ jon⁴³, jian³ a³m⁴ jian²³ sie²³; jian³ sa⁴cang³⁴ tsei⁴³ a³don⁵ a¹sie²³ jian²³ a³lo²³, jian³ a³lo²³ jian²³ a³don⁵ a¹sie²³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","I² jon³ a⁴hleh⁴ Jesús liah⁴ i²con²³ chie³ jeun⁴³, a⁴juah⁴i³: ―La⁴teg⁴i² jeh⁴ˉ³ i⁴so²³ o¹jnai⁴³ ta⁵tya³ hyie³, jon³ juah⁴ˉ³ tionh²ˉ³: “Jia²³ o¹jm⁴³”; jian³ si³lei⁴ la⁴jon³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jian³ la⁴teg⁴i² jia²³ tyi⁴ ta⁵ñei³⁴, juah⁴ˉ³ tionh²ˉ³: “Júan³⁴ hyie³”; jian³ teg³ jau²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Chie³ a³júan³ ni²taih⁴³ tionh²! Re³ ñih¹ˉ³ liah⁴ júan³⁴ jain³ i⁴jeh⁴ˉ³ ñi⁴jeu⁵ jian³ cuah³²húa³⁴. ¿Liah⁴ sa⁴lainh²ˉ³ tionh²ˉ³ hain³ jain³ sianh³ˉ³ tieh²la³? ");
INSERT INTO cucNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿E⁴le³⁴ sa⁴júanh³ˉ³ co³hei²tsei³ re³ liah⁴ hniah³ júanh²ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Juah⁴ne³ tyieh⁴ˉ³ nei²ta¹ jianh²ˉ³ a³si³tangh⁴ˉ³, júan² hnei³ re³ ton³²nie⁴³ jianh²i³ hnei³ ho³²jeu³ canh⁴a² sa⁴te³⁴i³ hnei³ ta⁵nei² júa¹, quie¹ júa¹ cúah⁴³i³ hnei³ i²con²³ po³li³sei¹, jian³ po³li³sei¹ liah⁴ tonh⁴³i³ hnei³ ni⁴ñi²³. ");
INSERT INTO cucNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jeu³⁴ˉ⁴ hnei³ i⁴sa⁴legh⁴ ua²a⁴jauh²ˉ³ i²jon³ la⁴conh⁴i² sa⁴ma⁴hmah³²ˉ³ la⁴jeg³⁴ o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jian³ jm² jon³ ma²tionh² co⁴meih³ chie³ a³a⁴tya⁴ jau²³ i²con²³ Jesús nei² quieh¹ co⁴meih³ a³sian³ húa³⁴ Galilea, a⁴jŋangh⁴ Pilato con³ma²ti²jŋangh² a³hain⁴ tionh² jah⁴, a⁴jang³⁴i³ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","I² jon³ a⁴juah⁴ Jesús liah⁴: ―¿O⁴ lainh⁴ˉ³ tionh²ˉ³ a⁴jainh⁴³ a³sian³ húa³⁴ Galilea hain⁴ la⁴ne³ quie¹ i⁴eu⁴³ hlion⁴ chie³² ren³i³ la⁴conh⁴a² la⁴jang³⁴ a³co²³i³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a⁵sia³; jian³ juah⁴ne³ sa⁴sagh²ˉ³ co³hei²tsei³ quianh³ tionh²ˉ³, la⁴ne³pa² tyanh⁴³ˉ³ la⁴jangh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Jian³ o⁴ lainh⁴ˉ³ tionh²ˉ³ liah⁴, a³quia⁵jña⁴ a³a⁴neh³ a²hnei⁴³ Siloé leg⁴³ hlion⁴ hna³, i⁴eu⁴³ ren³i³ chie³² la⁴conh⁴a² la⁴jang³⁴ a³tionh² Jerusalén, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a⁵sia³; jian³ juah⁴ne³ sa⁴sagh²ˉ³ co³hei²tsei³ quianh³ tionh²ˉ³, la⁴ne³pa² tyanh⁴³ˉ³ la⁴jangh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jian³ a⁴can³⁴i³ jau²³ la³ liah⁴, a⁴juah⁴i³: ―Jan³ chie³ ma²seih⁴³ con³ a²hma³ m⁴jyi³ je¹ quieh¹, jon³ ua⁵je⁴i³ o⁴ ti²tsei¹ o¹m⁴, i² sa⁴ti²tsei¹ ne⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jon³ a⁴sagh⁴³i³ a³hie³ je¹ quieh¹i³: “Ma³hneng³ ñi³ ne³⁴ cuan⁴ˉ⁴ hnoh³²ˉ⁴ o¹m⁴ quieh¹ a²hma³ m⁴jyi³ la³, jian³ i¹conh⁴ sa⁴ma³a⁴je³⁴ˉ⁴ i⁴ti²tsei¹. Eu⁴³a² re³ queih¹ hnei³ júah³, quie¹ i¹con³ a⁵sia³ ta¹ tei⁴³ i⁴seih⁴³ húa³⁴ la³.” ");
INSERT INTO cucNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","I² a⁴juah⁴ a³hie³ je¹ quieh¹i³: “Hnei³ a³don⁵, cúa² hnei³ jeu³ ua²seih⁴³ i²con³ ñi³ la³, canh⁴a² li⁴sieh³²ˉ⁴ o¹cuah³² ta³jmh¹ jian³ ro¹ˉ⁴ m⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","I² juah⁴ne³ a⁴cúa⁴ o¹m⁴ ne⁵, ta² re³; i² juah⁴ne³ sa⁴a⁴cúa⁴ liah⁴, ma²jon³ li⁴queih²ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Con³ jm² sa⁴júan³i³ ta¹ ma²si²heh² Jesús chie³ cuah³ judío. ");
INSERT INTO cucNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jian³ ma²hein² jan³ a³m⁴ i²jon³ a³chieh¹ ma³quia⁵jña⁴ ñi³ i⁴a⁴júan⁴ m⁴tyi⁴ hlagh³², i⁴ŋeng²³ a³hain⁴ jlein⁴³, jian³ i¹leuh² sa⁴li⁴ñeih³i³ o³chie⁴³ hna²³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","I² con³ma²a⁴je³ Jesús quieh¹i³, jon³ a⁴teh³i³ jian³ a⁴sagh⁴³i³: ―Hnei³ a³m⁴, ma³a⁴lonh⁴ˉ³ chie² i⁴langh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jon³ a⁴tang⁴ Jesús he³²i³, jian³ liah⁴ma²jon³ a⁴ñeih³ hna²³ a³m⁴ hain⁴, jian³ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","I² a³tyein² quian¹ cuah³ jon³ ne⁵, ta² a⁴jain³⁴ tsei⁴³ i²con²³ Jesús, quie¹ a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹ a³hain⁴ jm² sa⁴júan³i³ ta¹, jon³ a⁴sagh⁴³i³ la⁴jang³⁴ chie³: ―Jñei⁴ jm²pa² sia³ i⁴li⁴júan³⁴ chie³ ta¹; i² jon³ ne⁵, jm² jon³pa² li⁴niah²ˉ³ i⁴li⁴lei⁴ hei²³ quianh³ˉ³ tionh²ˉ³, a⁵jon⁴³ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","I² jon³ a⁴ŋangh³ Se³ño²³, a⁴juah⁴i³: ―Hnei³ chie³ a³júan³ ni²taih⁴³, con⁴janh³ˉ³ tionh²ˉ³, ¿o⁴ a⁵sia³ sainh⁵ˉ³ a²cua³²jeu²³ quianh³ jian³ o⁴ a²lo¹siah³ i⁴ua²hainh³²ˉ³ o¹jm³ jm² sa⁴júan³i³ ta¹? ");
INSERT INTO cucNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Conh⁴a² sa⁴hniah³ lion⁴³ a³m⁴ la³ jm² sa⁴júan³i³ ta¹ la³, a³lang⁴³ sa¹jeun³ A³brang²³ a³a⁴júan⁴ a⁵lainh³² la⁴jan³ a³hñi⁴³ i⁴chieh¹i³ ma³quia⁵jña⁴ ñi³? ");
INSERT INTO cucNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Con³ma²a⁴hleh⁴ Jesús jau²³ jon³, jon³ ta² ra⁵hyeih¹ la⁴jang³⁴ a³hie²³ hain⁴; i² la⁴jang³⁴ a³jeu³ ne⁵, si³hyonh³ pi²³i³ la⁴jeg³⁴ i⁴co³ jnia⁴ jon³ i⁴a⁴júan⁴ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jon³ a⁴juah⁴ Jesús liah⁴: ―¿Hain³liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, jian³ o⁴ hain³ jau²³ li⁴can¹ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Quie¹ leg⁴³ liah⁴i² leg⁴³ con³ o¹m⁴ mostaza i⁴a⁴can³⁴ jan³ chie³ i⁴a⁴jnei⁴i³ je¹ quieh¹, i² jon³ ua⁵cúan³, a⁴leg³⁴ con³ a²hma³ júah³, i² jon³ a⁴júan⁴ jon⁴³tan²³ sag³² je¹ o¹cúah² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jian³ a⁴juah⁴i³ liah⁴: ―¿Hain³ jau²³ li⁴can¹ˉ⁴ liah⁴i² leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Quie¹ leg⁴³ liah⁴i² leg⁴³ o¹sieh³² hei⁴³ñih¹ i⁴a⁴can³⁴ jan³ a³m⁴, jian³ a⁴conh³i³ hneng³ tieh³² hma³ ca³jeun²³ o¹a³ri²na³, jian³ a⁴yienh⁴ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ma²jon³ ua⁴jeun³² Jesús la⁴jeg³⁴ jeu³ júah² jian³ jeu³ peih¹, heh²i³ chie³ i⁴ŋo³⁴i³ ta⁵ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","I² jon³ a⁴juah⁴ jan³ chie³: ―Hnei³ Se³ño²³, ¿o⁴ co⁴meih³pa² chie³ lion⁴? I² jon³ a⁴juah⁴ Jesús: ");
INSERT INTO cucNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Cúah³² hnei³ pei⁴ i⁴heuh¹ˉ³ jeu³ o²hnei³² tsai³, quie¹ jeu³⁴ˉ⁴ hnei³ i⁴jeun⁴³ a³hnie³⁴ júan³⁴ si⁵hei⁴, jian³ sa⁴tieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Júan³²ˉ¹, tei⁴³i² ma³ra⁴hang³² a³quieh¹ jauh³², jian³ a⁴jnai³⁴i³ o²hnei³², ma²jon³ ma²lieh¹ˉ³ teh²ˉ³ tionh²ˉ³ coh⁵hnei³², juah²ˉ³: “A³don⁵, a³don⁵, nia¹ o²hnei³² ua²han⁵ jnie³².” I² si²ŋangh² a³hain⁴ ta⁵jauh³², sag⁵i³ hnei³ tionh²ˉ³: “Sa⁴yan³²ˉ⁴ jainh¹ a⁴niah³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","I² jon³ ma²lieh¹ˉ³ hleh²ˉ³ tionh²ˉ³: “Ma³a⁴quih² a⁴hneih²pa² jnia¹ jie³ˉ¹, jian³ hnei³pa² ni²heh³² jnie³² teg⁴ jeu³júan²³ quian⁴ jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","I² jon³ li⁴juah⁴ a³quieh¹ jauh³² hain⁴ i²conh²ˉ³ tionh²ˉ³: “Jian³ ma³a⁴jeu³⁴ˉ⁴ hnei³ sa⁴yan³²ˉ⁴ jainh¹ a⁴niah³ˉ³. Quein⁴³ hnei³ i²con²³ˉ⁵ la⁴jangh³ hnei³ a³júan³ jmah³ i⁴hlagh³²”, li⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","I²jon³ hoh³²ˉ³, queuh²ˉ³ m⁴janh² tei⁴³i² jenh³²ˉ³ A³brang²³, I³sa²³, Ja³co²³ jian³ la⁴jang³⁴ a³sain² a³tionh² naih⁵ heinh² quieh¹ Jon⁴dai¹, i² hnei³ tionh²ˉ³ ne⁵, ton³⁴i³ hnei³ ta⁵co⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Quie¹ yi⁴han² chie³ a³tionh² ta⁵jia²³ hyie³ jian³ ta⁵tyan³ hyie³, jian³ ta⁵ñei³⁴ jian³ ta⁵quian³⁴ i⁴cua³⁴i³ queuh⁴³i³ a²hei⁴³ naih⁵ heinh² quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jian³ jeun⁴³ a³tionh² ta³ra³pei¹ tieh²la³ si⁵jian⁴³i³ nei², jian³ jeun⁴³ a³ya¹jian⁴³ nei² tieh²la³ tang³⁴i³ ta³ra³pei¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jm² jon³ a⁴tyie³⁴ co⁴meih³ fariseo, a⁴sagh⁴³i³ Jesús, a⁴juah⁴i³: ―Cuanh³, jau²³ hnei³ i²la³, quie¹ hnie³⁴ Herodes jŋangh³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","I² a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Cua³ ua⁴saih³² hnei³ Herodes, a²hyah³ nei²³ tsei⁴³ hain⁴ la⁴la³: “Jeh³², ne³⁴ jian³ hie³⁴ húa¹ˉ⁴ m⁴tyi⁴ hlagh³² jian³ júan³²ˉ⁴ i⁴huan⁴ quieh¹ a³chieh¹, i² yie⁴ jon³, ma³a⁴toh⁴ ta¹ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","I² la⁴jon³ ne⁵, ton³²nie⁴³ hniah³ lei⁴ nai³²ˉ⁴ ne³⁴ jian³ hie³⁴, yie⁴ liah⁴, quie¹ sa⁴re³ juah⁴ne³ sa⁴jaun⁴ jan³ a³sain² quian¹ Jon⁴dai¹ Jerusalén.” ");
INSERT INTO cucNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Hnei³ tionh²ˉ³, a³tionh² Jerusalén, jŋangh⁵ hnei³ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹, jian³ quinh⁵ˉ³ m⁴caun² a³sain³i³ i²conh²ˉ³ tionh²ˉ³! ¡Ta² hlion⁴ nie⁴³ ma²hno⁵ˉ⁵ ma²jaih³²ˉ⁴ hnei³ tionh²ˉ³, liah⁴i² júan³ a¹si²hyie²³, tyan⁵i³ co⁴lagh⁴³ jon⁴³yein³ hyie²³ quian¹ naih⁵ ya¹cúa⁴³i³! ¡I² sa⁴ra⁵hnoh³ˉ³ tionh²ˉ³! ");
INSERT INTO cucNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Quie¹ ton³⁴ Jon⁴dai¹ i²tionh²ˉ³ ne³. Jian³ jeu³⁴ˉ⁴ hnei³ liah⁴ i⁴a⁵sie⁴³ jeh³²ˉ³ jnia⁴ la⁴conh⁴i² a⁴tyie³⁴ jm² i⁴juah²ˉ³: “Ta² tsei³⁴ jm² ren³ a³ja²³ con⁴juah⁴ jm³i⁴sain³ Se³ño²³.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jian³ liah⁴ con³ jm² sa⁴júan³i³ ta¹ a⁴tyie³⁴ Jesús jauh³² quieh¹ jan³ a³quian³ ma³tyi² quian¹ fariseo i⁴ua⁵queuh³i³ a²hei⁴³, jian³ la⁴jang³⁴ fariseo tionh² ti²tan³i³ i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","I² ta⁵nei² Jesús jon³ ma²ua²cua⁴³ jan³ a³chieh¹ a³yon³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","I² jon³ a⁴juah⁴ Jesús i²con²³ a²teg²³ quian¹ lai²³ tionh² jian³ fariseo: ―¿O⁴ ra³cúa²³ i⁴júan³⁴i³ i⁴huan⁴ quieh¹ a³chieh¹ jm² sa⁴júan³i³ ta¹, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","I² hei⁴i³ tionh², i¹con³ sa⁴a⁴juah⁴i³. I² Jesús ne⁵, a⁴tang⁴i³ a³yon³ hain⁴, a⁴júan⁴i³ i⁴a⁴huan⁴ quieh¹i³, ma²jon³ a⁴saih³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jian³ ma²jon³ a⁴sagh⁴³i³ a³hain⁴ tionh², a⁴juah⁴i³: ―¿Hain³ hnei³ tionh²ˉ³ juah⁴ne³ a⁴tanh⁴ jan³ a²lo¹siah³ quianh³ˉ³ jian³ o⁴ a²cua³²jeu²³ joh⁴³ to³, o⁴ a⁵sia³ si⁵te¹i³ si⁵tyein³i³ liah⁴ma²jon³, ua²liah⁴a² jm² sa⁴júan³i³ ta¹, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","I⁴jon³ i¹con³ a⁵sie⁴³ a⁴ŋang³ a³hain⁴ tionh² nei² ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","I² con³ma²a⁴je³⁴ Jesús i⁴ti²hnoh³ a³ten² hain⁴ hien²³ tyein² i⁴cua³⁴i³ mesa, jon³ a⁴can³⁴i³ con³ jau²³, a⁴sagh⁴³i³ a³ten² hain⁴ tionh²: ");
INSERT INTO cucNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Juah⁴ne³ sian³ a³te²³ hnei³ con³ i²sanh⁴ chie³, sa⁴neih²ˉ³ hien²³ tyein², quie¹ lei⁴ li⁴jia²³ i²jan³ a³ten² sang³⁴ a³júanh⁴³ a⁵hei⁴³ lia⁴ hnei³ a³a⁴teh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","I² tei⁴³i² a⁴je³ hnei³ a³a⁴te⁴ hnei³ i⁴jian³i³ a³hain⁴, jon³ li⁴sag⁵i³ hnei³: “Cúa² hien²³ ne³ ua²cua³ a³la³.” I² jon³ li⁴hyeinh³²ˉ³ queinh³²ˉ³ neih²ˉ³ hien²³ i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","I² la⁴teg⁴i² te²³i³ hnei³ la⁴ne³, cua³ hnei³ jian³ nei⁴ hien²³ i²a⁴toh⁴, canh⁴a² la⁴teg⁴i² a⁴je³⁴ a³a⁴te⁴ hnei³, jon³ li⁴sag⁵i³ hnei³: “Hnei³ a³ñi³reunh³ˉ⁴, teg⁴ ma³tyi² la³ ni³nei⁴ quian⁴ˉ¹.” I² la⁴jon³ li⁴júanh⁴³ˉ³ ta⁵nei² la⁴jang³⁴ a³ti²tionh² mesa jianh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Quie¹ la⁴jang³⁴ a³júan³ júanh⁴³, sainh³i³ o³hyeih², jian³ la⁴jang³⁴ a³júan³ ti⁴ñeih⁵, lei⁴ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jian³ a⁴juah⁴ Jesús liah⁴ i²con²³ a³a⁴te⁴ quieh¹i³: ―La⁴teg⁴i² júanh²ˉ³ con³ jm² júah³ i⁴guenh³²ˉ³ chie³, sa⁴hniah³ teh³²ˉ³ a³ñi³reunh³ tionh², a⁵ga⁴ si³reunh³ˉ³, a⁵ga⁴ a³tei⁴³ jau²³ quianh³ˉ³, a⁵ga⁴ a³jlanh² a³tionh² hlonh²ˉ³; quie¹ hei⁴i³ tionh² lei⁴ li⁴te³⁴i³ hnei³ tei⁴³i² júan³⁴i³ quieh¹, i² la⁴jon³ li⁴jainh³i³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","I² la⁴teg⁴i² júanh²ˉ³ jm² júah³ ne⁵, teh⁴³ hnei³ a³ti⁴ñei³ tionh², jian³ a³si¹jeu⁴, jian³ a³tein⁴ jian³ a³taun³². ");
INSERT INTO cucNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","I² la⁴jon³ tsei³⁴ jm² li⁴renh³ˉ³. Quie¹ hei⁴i³ tionh² sa⁴li⁴jainh³i³ quianh³ˉ³, i² ma²jon³pa² si⁵jainh² quianh³ˉ³ la⁴teg⁴i² hyon⁴³ la⁴jang³⁴ chie³ tsein²³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","I² con³ma²a⁴nau⁴ jan³ jen² a³tionh² mesa jian²³ Jesús jau²³ jon³, jon³ a⁴sagh⁴³i³ Jesús: ―Ta² tsei³⁴ jm² li⁴ren³ a³queuh⁴³ ma³⁴ naih⁵ heinh² quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Jan³ chie³ a⁴júan⁴ con³ jm² júah³ i⁴guenh⁴³i³ chie³, i² jon³ a⁴teh³i³ jeun⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","I² con³ma²a⁴teg⁴ o²ra³ i⁴queuh⁴³i³ ma³⁴ ne⁵, jon³ a⁴sain⁴i³ a³cúa²³ cúa³tag³² quian¹ i⁴ua⁵saih¹i³ a³ten² tionh², juah⁴i³: “Nia³ hnei³ tionh²ˉ³ to⁴ne⁵, quie¹ ma³ti²nie⁴³ la⁴jeg³⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","I² la⁴jang³⁴ a³hain⁴ tionh² a⁴juah⁴i³ i⁴sa⁴tian⁴. I² a³co⁴ra⁴lie⁵ a⁴juah⁴: “Húa³⁴ júah³pa² a⁴la³⁴ˉ⁴ con³, i⁴jon³ hniah³ ton³²nie⁴³ nai³²ˉ⁴ ni¹je³⁴ˉ⁴; mh⁵ˉ⁵ hnei³ i⁴júanh²ˉ³ júanh³ hoh⁴³.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jian³ a⁴juah⁴ i²jan³: “Hña⁴ ni²quein⁴³ a²cua³² quiah³ húa³⁴ ma³a⁴lan³⁴ˉ⁴, i⁴jon³ hniah³ ni¹quien³²ˉ⁴ jah⁴ jau²chie⁴³ ton³²nie⁴³; i⁴jon³ mh⁵ˉ⁵ hnei³ i⁴júanh²ˉ³ júanh³ hoh⁴³.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Conh⁴liah⁴ a⁴juah⁴ i²jan³ liah⁴: “Can¹ a⁴sanh⁴pa² jnia⁴, i⁴jon³ sa⁴tian⁴ nai³²ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I² jon³ jonh³ a³cúa²³ cúa³tag³² hain⁴, a⁴sagh⁴³i³ jeu³² la⁴jeg³⁴ i⁴jon³. I² jeu³²i³ ne⁵, ta² a⁴jain³⁴ tsei⁴³i³, jon³ a⁴sagh⁴³i³ a³cúa²³ cúa³tag³² quian¹ liah⁴: “Eu⁴³a² re³ cua³ ta¹tia⁴ la⁴tan² ñi⁵jeu³ jian³ la⁴tan² jeu³júan²³ quieh¹ je¹jeu³ la³, yi⁴quianh¹ˉ³ a³ti⁴ñei³, jian³ a³si¹jeu⁴, jian³ a³tein⁴ jian³ a³taun³² tionh².” ");
INSERT INTO cucNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","I² a⁴tyanh³ a³cúa²³ cúa³tag³², a⁴sagh⁴³i³ jeu³²: “Hnei³ a³don⁵, ra⁵tei⁴³pa² liah⁴ ma²a⁴saih³²ˉ³ jnia⁴, jian³ ra³sion⁴ pi¹ i²li⁴cua³⁴i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","I² jon³ a⁴juah⁴ jeu³²i³, a⁴sagh⁴³i³ a³cúa²³ cúa³tag³² liah⁴: “Cua³ tyieh⁴ˉ³ la⁴jeg³⁴ ho³²jeu³ jian³ i²nau³ la⁴conh⁴ hloh³² ne³, yi⁴jianh⁴³ˉ³ ta⁵li⁴hnai³, canh⁴a² canh⁴³ jauh³² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i¹jan³ a³a⁴teh⁵ˉ⁵ liah⁴ma²ra⁴lie⁵ hain⁴ tionh², sa⁴hyei⁴³i³ ma³⁴ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jian³ ta² jeun⁴³ chie³ ua⁴han² jian²³i³ Jesús, tionh²i³ jeu³; i² jon³ a⁴jainh³ Jesús nei², a⁴sagh⁴³i³: ");
INSERT INTO cucNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Jian³ a³hain⁴ a³jia²³ i²con²³ jnia⁴, sa⁴li⁴lain⁴i³ chie³ quian³⁴ˉ⁴ juah⁴ne³ sa⁴ma³hain³i³ tsei⁴³ i²con²³ hña³, jian³ nei² quieh¹ jmai³i³, sie²³i³, jian³ nei² quieh¹ i³cúa³i³, jian³ nei² quieh¹ si³jon⁴³i³, jian³ si³reunh¹i³ a³ñih³ a³m⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jian³ a³hain⁴ a³sa⁴hnie³⁴ can³⁴ ma²eu⁴³ i⁴jia²³i³ coh⁵cah³ˉ⁴, sa⁴li⁴lain⁴i³ chie³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Júan³²ˉ¹, juah⁴ne³ sian³ hnei³ tionh²ˉ³ a³hnie³⁴ júan³⁴ con³ a²hnei⁴³ leg⁴³ hlion⁴ hna³, ¿o⁴ a⁵sia³ cua³⁴i³ ñeih³² júan³⁴i³ co³hei²tsei³ conh⁴ o¹cau³² teg³⁴, nia³²ˉ¹ o⁴ nie⁴³ quieh¹i³ la⁴conh⁴ li⁴teg³⁴ tieh⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Quie¹ juah⁴ne³ con³ i⁴ma⁴lie⁵i³ ta³jmh¹ jian³ ma²a⁴leg³⁴ jon³ sa⁴tieh¹i³ ma⁵tieh⁴i³, i² la⁴jang³⁴ a³a⁴je³⁴ i⁴ma⁴lie⁵i³, ji⁵ŋang⁴i³ quieh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","li⁴juah⁴i³: “Jeh³² a³ñih³ ne³ ma⁴lie⁵ con³ a²hnei⁴³, jian³ sa⁴tieh¹i³ ma⁵tieh⁴i³”, li⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jian³ la⁴ne³ liah⁴, juah⁴ne³ jan³ re¹ hnie³⁴ júan³⁴ hnai³ i²con²³ re¹ sang³⁴, ¿o⁴ a⁵sia³ cua³⁴i³ ñeih³² júan³⁴i³ co³hei²tsei³ o⁴ li⁴cagh¹ quia³⁴ mai²³ a²hlie⁴ quian¹i³ jm² i²con²³ quie⁴ mai²³ a²hlie⁴ quian¹ re¹ sang³⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","I² juah⁴ne³ sa⁴tian⁴ ne⁵, i² ta¹la⁴ tionh²i³ i²gm⁴, jon³ sain³⁴i³ meih³ chie³ quian¹ i⁴si⁵mh²i³ re¹ hain⁴ i⁴tyan⁴³ hnai³. ");
INSERT INTO cucNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jian³ la⁴ne³ liah⁴ con⁴jan³ hnei³ tionh²ˉ³, a¹juah⁴ne³ sa⁴ma⁵hainh¹ˉ³ hoh⁴³ la⁴jeg³⁴ i⁴sia³ quianh³ˉ³, sa⁴li⁴lainh⁴ˉ³ chie³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Quie¹ i⁴chie⁴³pa² tsei³⁴ o¹ñi²; i² juah⁴ne³ a⁴chia³⁴ ua³pei⁴ quieh¹ ne⁵, ¿hain³liah⁴a² ma⁵li⁴ñih¹? ");
INSERT INTO cucNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jian³ so⁵ma⁵tsei³⁴ i⁴roh³i³ húa³⁴, jian³ a⁵ga⁴ i⁴li⁴conh³i³ m⁴³ quieh¹ húa³⁴, quie¹ hniah³ ton³⁴i³ o³tan². A³hain⁴ a³ho³ ta³ra³cua¹ i⁴nau³i³, ua²nai⁴i³ jau²³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","I² jon³ a⁴tyie³⁴ jeun⁴³ a³can²³ hmah¹ hlonh² Jesús jian³ a³ti²ren³ chie³² tionh² i⁴nau³⁴i³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","I⁴jon³ a⁴si⁴he⁴³ chie³ fariseo jian³ a²teg²³ quian¹ lai²³, a⁴si⁴hen⁴³i³ Jesús, a⁴juah⁴i³: ―Hyein⁴³ a³ne³ a³ren³ chie³² tionh², jian³ queuh³i³ jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","I² jon³ a⁴can³⁴ Jesús jau²³ la³, a⁴sagh⁴³i³ a³hain⁴ tionh²: ");
INSERT INTO cucNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―¿Hain³ jan³ hnei³ tionh²ˉ³ a³tionh² nia⁴lon⁴ a⁵a³siah³ quian¹, i² jon³ ua⁵conh⁴ jan³, i² ta¹la⁴ jon³ tain³⁴i³ ñeih³² jan³ a²sa⁴tain⁴³ nia⁴lon⁴ hain⁴ i²nau³ jon³, i⁴si⁵hniah³i³ a³ua⁵conh⁴ hain⁴ la⁴conh⁴i² a⁴chianh¹i³? ");
INSERT INTO cucNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","I² tei⁴³i² a⁴chianh¹i³ ne⁵, jon³ te⁴³i³ jeu³ co⁵lau²³i³ si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","I² tei⁴³i² a⁴tyanh³i³ jauh³² quieh¹, jon³ teh³i³ la⁴jang³⁴ a³ñi³reunh¹ jian³ a³tionh² hlonh²i³, sagh⁵i³ a³hain⁴ tionh²: “Júan² hnei³ si³hyonh³ˉ³ jianh²ˉ³ jnia⁴ tionh²ˉ³, quie¹ a⁴chianh³² pe²³ˉ⁴ a⁵a³siah³ ma²ua⁵hain⁴ hain⁴ quian³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jian³ jeu³⁴ˉ⁴ hnei³ liah⁴, la⁴ne³ lei⁴ si³hyonh³ a³tionh² ñi⁴jeu⁵ la⁴teg⁴i² jan³ a³ren³ chie³² sag²³ co³hei²tsei³ quieh¹, la⁴conh⁴a² jan³ a²sa⁴tain⁴³ nia⁴lon⁴ chie³ tsein²³ a³sa⁴hniah³ sag³⁴ co³hei²tsei³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’¿Jian³ o⁴ hain³ jan³ a³m⁴ ma²sia³ quia³⁴ o¹cau³² tie³ quieh¹, i² jon³ ua⁵hain⁴ con³, o⁴ a⁵sia³ hainh³i³ o¹jyi³, lainh⁴ˉ³, jian³ hyah³i³ jauh³², hnoh⁴³i³ ta¹huan³² la⁴conh⁴i² a⁴chieh¹i³? ");
INSERT INTO cucNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","I² tei⁴³i² a⁴chieh¹i³ ne⁵, jon³ teh³i³ a³m⁴reunh¹ jian³ a³m⁴ a³tionh² hlonh²i³, sagh⁵i³ tionh²: “Júan² hnei³ si³hyonh³ˉ³ jianh²ˉ³ jnia⁴ tionh²ˉ³, quie¹ ma³a⁴chieh³² pe²³ˉ⁴ o¹cau³² tie³ ma²ua⁵hain⁴ jon³ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jian³ jeu³⁴ˉ⁴ hnei³ liah⁴, la⁴ne³ sia³ co³hyon²³tsei³ i²con²³ ángel quian¹ Jon⁴dai¹ a³tionh² ñi⁴jeu⁵, la⁴teg⁴i² jan³ a³ren³ chie³² sag²³ co³hei²tsei³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jian³ a⁴juah⁴i³ liah⁴: ―Jan³ a³don⁵ ma²sian³ on³⁴ a³ñih³ jon⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","I² jan³ a³jon⁴³i³ a³maih⁴³ hain⁴, a⁴sagh⁴³i³ jmai³: “Pa²³ quian³⁴ˉ⁴, cúa² la⁴conh⁴ i⁴tain⁴³ˉ⁴ hyei¹ˉ⁴ i⁴sia³ quianh³ˉ³.” I² jon³ a⁴tyieh⁵ jmai³i³ i²con²³ li⁵uan⁴i³ i⁴sia³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","I² a⁵sia³ jm² ŋo³⁴ coh⁵ jon³, a⁴tya⁴ a³jon⁴³i³, a³maih² hain⁴, co⁴lagh⁴³ i⁴quieh¹, jon³ ŋo³⁴i³ con³ húa³⁴ gm⁴. I² jon³ ma⁴hain³i³ la⁴jeg³⁴ i⁴sia³ quieh¹ i²ni²ŋeng³i³ con³ m⁵cu³ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","I² con³ma²ma⁴hain³i³ la⁴jeg³⁴ i⁴ma²sia³ quieh¹, jon³ ja³⁴ con³ ho³²cúan⁴ húa³⁴ jon³, i² jon³ a⁴leg³⁴ i⁴ra⁵hniah³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","I² jon³ ŋo³⁴i³ ua⁵jen³²i³ jan³ a³sian³ húa³⁴ jon³ i⁴hnoh³i³ ta¹, i² jon³ a⁴sai⁴ a³hain⁴ teg⁴ i²nau³ quieh¹ i⁴si⁵hion⁴³i³ a¹ñi⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I² hei⁴i³ ne⁵, ta² i²cúanh⁴³i³ jian³ i²queuh⁴³i³ o¹cúah⁴³ a²hma³ i⁴queuh³ a¹ñi⁴³, jian³ i¹jan³ sa⁴gueh³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","I² jon³ a⁴júan⁴i³ co³hei²tsei³ hña³, lain⁴i³: “¡La⁴conh⁴a² sa⁴ni²sion⁴ i⁴queuh³ la⁴jang³⁴ a³júan³ ta¹ quieh¹ neih³ˉ⁴, i² jnia⁴ ne⁵, jaun⁴ pe²³ˉ⁴ i²la³ cúan⁴³ˉ⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Eu⁴³a² re³ ra²hang³²ˉ⁴, naih²ˉ⁵ i²con²³ neih³ˉ⁴, jian³ i²jon³ jeu¹i³ jnia⁴: Pa²³ quian³⁴ˉ⁴, ma³a⁴tanh⁴ˉ⁴ chie³² i²con²³ Jon⁴dai¹ jian³ i²conh² hnei³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A⁵sie⁴³ haih¹ juah⁴ ma⁵li⁴teh³²ˉ³ jnia⁴ a³jonh³ˉ³; eu⁴³a² re³ jeh³²ˉ³ jnia⁴ la⁴jan³ mozo quianh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","I² jon³ ra⁴hang³²i³, jonh³i³ i²cua⁴³ jmai³i³. ’I² con³ma²ma³jonh²i³ i²gm⁴, jon³ a⁴je³ jmai³i³ jian³ joh³ ñei⁴ tsei⁴³i³ i²con²³i³. Jon³ ŋo³⁴i³ jeu³ra³tyi⁴, a⁴rang⁴i³ lau²i³, a⁴seinh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","I² jon³ a⁴juah⁴ a³jon⁴³i³ hain⁴: “Pa²³ quian³⁴ˉ⁴, ma³a⁴tanh⁴ˉ⁴ chie³² i²con²³ Jon⁴dai¹ jian³ i²conh² hnei³ liah⁴. A⁵sie⁴³ ma⁵haih¹ li⁴jeuh³²ˉ³ jnia⁴ i⁴a³jonh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","I² jmai³i³ ne⁵, a⁴sagh⁴³i³ a³cúa²³ cúa³tag³² quian¹ tionh²: “Quian³ con³ a²hmh³ tyein² tsei³⁴, tanh³²ˉ³ a³jon³⁴ˉ⁴; jian³ tonh²ˉ³ con³ a²ñi²³ si¹cúa³i³ liah⁴, jian³ si⁵hei⁴ a²lo³ si¹tag³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Jian³ ua⁴te⁴³ hnei³ jan³ a²cua³²jeu²³ maih⁴³ a³re³ heunh³², jian³ jŋangh¹ˉ³ canh⁴a² quih³²ˉ¹ júan³²ˉ¹ jm². ");
INSERT INTO cucNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Quie¹ ma³jaun²pa² a³jon³⁴ˉ⁴, ma²lain³⁴ˉ⁴, i² li⁴sian³pa² chie³ ne⁵; ma³ua⁵hain⁴ pi²³i³ ma²leg⁴³, i² ma³cúan²³ pi²³i³ tieh²la³.” I² jon³ ma⁴lie⁵i³ tionh² a⁴júan⁴i³ i⁴si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’I² a³jon⁴³i³ a³don⁵ ne⁵, ma²hein² je¹ pi²³i³ quieh¹; i² con³ma²jonh³i³, jon³ a⁴tyanh³i³ hloh³² o²hnei³², i² jon³ a⁴nau⁴i³ i⁴ti²júan³i³ seun²³ jian³ ti²chie²³i³ jan¹. ");
INSERT INTO cucNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","I² jon³ a⁴teh³i³ jan³ mozo quian¹ jmai³i³ a³a⁴ŋangh³i³ henh⁴ si³lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","I² a⁴juah⁴ a³hain⁴: “A³reunh³pa² hnei³ cúan²³; i⁴jon³ a⁴júan⁴ naih⁴³ heih⁴³ i⁴jaun⁴ a²cua³²jeu²³ maih⁴³ a³re³ heunh³², quie¹ ta⁵la⁴ cúan³⁴i³ tsein³⁴i³ hei⁴³ tsei⁴³i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","I² hei⁴i³ ne⁵, a⁴jain³⁴ tsei⁴³i³, jian³ sa⁴i²si⁵hain²³i³ jauh³², jon³ ua⁵hag⁴³ jmai³i³, a⁴sagh⁴³i³ i⁴si⁵hain²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","I² hei⁴i³ ne⁵, a⁴sagh⁴³i³ jmai³, a⁴juah⁴i³: “Jeh³², hlion⁴ ñi³ ma³a⁴cúa³⁴ˉ⁴ cúa³tag³⁴ i²conh²ˉ³, jian³ i¹conh⁴ juah⁴ sa⁴ma³a⁴nau³⁴ˉ⁴ jau²³ quianh³ˉ³, jian³ i¹conh⁴ sa⁴ma³a⁴cúanh³²ˉ³ jan³ a²sain²ñih³ peih¹ juah⁴ i⁴júan¹ˉ⁴ jm² quien⁴ jian²³ˉ⁵ a³ñi³reunh³ˉ⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","I² con³ma²cúan³⁴ a³jonh³ˉ³ ne³, a³ma³ma⁴hain³ o¹cau³² quianh³ˉ³ jian²³i³ a³m⁴ sa⁴jmh³, jon³ a⁴júanh²ˉ³ heih⁴³ i⁴jaun⁴ a²cua³²jeu²³ maih⁴³ a³re³ heunh³² quian¹.” ");
INSERT INTO cucNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","I² a⁴juah⁴ jmai³i³ ne⁵: “Hnei³ peih¹ quian³⁴ˉ⁴, la⁴jeg³⁴ jm²pa² jianh²ˉ³ jnia⁴, jian³ la⁴jeg³⁴ i⁴sia³ quien⁴ˉ⁴ tainh⁴³ hnei³pa². ");
INSERT INTO cucNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","I⁴jon³ hniah³ ton³²nie⁴³ júan³²ˉ¹ jm² jian³ i⁴le²³ˉ¹ co³hyon²³tsei³, quie¹ a³reunh³ˉ³ ne³ ma²jaun²pa² ma²leg⁴³, li⁴sian³pa² li⁴ chie³; ma³ua⁵hain⁴ pi²³i³ ma²leg⁴³, i² ne⁵pi¹ cúan³⁴i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Conh⁴liah⁴ a⁴juah⁴ Jesús i²con²³ chie³ quian¹ tionh²: ―Ma²sian³ jan³ chie³ jlanh² a³ma²sian³ jan³ a³hei¹ joh⁴³ cúa³ lie²³ quieh¹, i² jon³ a⁴tya⁴ chie³ jau²³ i²con²³ a³jlanh² hain⁴ i⁴ma³hain³ a³hain⁴ lie²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","I² jon³ a⁴te⁴ jeu³²i³, a⁴sagh⁴³i³: “Ta² hlion⁴ jau²³ nau³⁴ˉ⁴ nei² quianh³ˉ³, sa⁴yan³²ˉ⁴ o⁴ i⁴chie⁴³. Cúah¹ hnei³ cuenta ta¹ i⁴quianh²ˉ³, quie¹ a⁵sie⁴³ ma⁵lainh⁴ˉ³ a³hie²³ lie²³ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","I² a³hei¹ joh⁴³ cúa³ lie²³ quieh¹ jeu³² hain⁴ a⁴júan⁴i³ co³hei²tsei³ hña³, lain⁴i³: “¿Liah⁴ júan³²ˉ⁴ tieh²la³? Quie¹ qui³⁴ jeu³²ˉ⁴ ta¹ i⁴hei¹ joh⁴³ cúa³⁴ˉ⁴. Jian³ sa⁴tie³²ˉ⁴ cag¹ˉ⁴ húa³⁴, jian³ hyeih³²ˉ⁴ ŋeng¹ˉ⁴ i⁴m¹ˉ⁴ i²con²³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ma³yan³²ˉ⁴ liah⁴ júan³²ˉ⁴ canh⁴a² li⁴hyei⁵ jnia⁴ chie³ sang²³, tei⁴³i² ma³a⁴qui³ ta¹ quien⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","I² a⁴te⁴ a³hain⁴ i²con²³ con⁴jan³ a³ren³ hmah¹ quieh¹ jeu³²i³, jon³ a⁴sagh⁴³i³ jan³ co⁴ra⁴lie⁵: “¿Conh⁴ renh³ˉ³ quieh¹ jeu³²ˉ⁴?” ");
INSERT INTO cucNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","I² a⁴juah⁴ a³ren³ hain⁴: “Nia⁴lo⁴ a²ba³rrei²³ o¹a³sai²te³pa².” Jian³ a⁴sagh⁴³i³ liah⁴: “I²la³pa² ra³ton³ conh⁴ renh³ˉ³; co⁴seih⁴³ ni³nei⁴, júan² hnei³ i²con³ i⁴hm³⁴, jon³ tienh³²ˉ³ to⁴lo⁵quia⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Con³ma²a⁴leg³⁴ jon³, a⁴sagh⁴³i³ i²jan³ liah⁴: “I² hnei³ ne⁵, ¿conh⁴ renh³ˉ³ liah⁴?” I² a⁴juah⁴ a³ren³ hain⁴: “Nia⁴lo⁴ a²to³tyie¹ o¹m⁴ trigo pa².” Jon³ a⁴sagh⁴³i³: “I²la³pa² ra³ton³ conh⁴ renh³ˉ³; júan² hnei³ i²con³ i⁴hm³⁴, jon³ tienh³²ˉ³ quie⁴ a²sa⁴tei⁴³ nia⁴lo⁴ i⁴renh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","I² a⁴juah⁴ jeu³²i³ i⁴chie⁴³pa² a⁴júan⁴ a³hlangh² hain⁴ a³hei¹ joh⁴³ cúa³ lie²³ con⁴juah⁴ re³ i⁴ŋang⁴i³ liah⁴ li⁴ta⁵sangh²i³. Quie¹ la⁴ne³ júan³ a³tionh² m⁵cu³ la³ con⁴juah⁴ i⁴re³ ŋang⁴i³ jen² jon²reunh¹ la⁴conh⁴a² júan³ a³tionh² je¹ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’I² jon³ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ ne⁵, júan³² hnei³ ñi³reunh³ chie³ o¹cau³² quieh¹ m⁵cu³ hlagh³² la³, canh⁴a² la⁴jon³ sian³ a³ñi³reunh³ˉ³ a³li⁴hyeih⁴³ hnei³ ñi⁴jeu⁵ i²sa⁴legh⁴ ua²a⁴toh⁴, la⁴teg⁴i² ma³a⁴chia³⁴ o¹cau³² jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Quie¹ a³hain⁴ a³ni²taih⁴³ i⁴quian³i³ con³ ta¹ peih¹, la⁴ne³pa² ma²ma⁴tei⁵i³ juah⁴ne³ ma²quian³i³ con³ ta¹ son²³ liah⁴; jian³ a³hain⁴ a³sa⁴ni²taih⁴³ con³ ta¹ peih¹ i⁴quian³i³, la⁴jon³pa² sa⁴ma²ni²taih⁴³i³ juah⁴ne³ ma²quian³i³ con³ ta¹ júah³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Quie¹ juah⁴ne³ sa⁴re³ júanh³ˉ³ nei² quieh¹ o¹cau³² quieh¹ m⁵cu³ hlagh³² la³, ¿hain³a² li⁴cúa³⁴ i²conh²ˉ³ i⁴jon³ i⁴tyein² quein⁴³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","I² juah⁴ne³ sa⁴re³ ma⁵teih³²ˉ³ nei² quieh¹ o¹cau³² i⁴sia³ m⁵cu³ la³, ¿liah⁴a² li⁴hyeih³²ˉ³ i⁴ma²tainh⁴³ˉ³ húanh⁴ˉ³ ñi⁴jeu⁵, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’I¹jan³ chie³ sa⁴li⁴cúa³⁴ cúa³tag³² i²con²³ on³⁴ jeu³²; quie¹ jan³pa² ma⁵hnio³⁴i³ jian³ jan³ li⁴hion²³i³ liah⁴, jian³ o⁴ jan³pa² ma⁵con⁴³i³ re³, jian³ jan³ sa⁴jain¹i³ liah⁴. Jian³ la⁴ne³ liah⁴, sa⁴tian⁴ juah⁴ i⁴li⁴cúa³⁴ chie³ cúa³tag³² i²con²³ Jon⁴dai¹ jian³ o¹cau³² liah⁴ co⁴chia³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jian³ la⁴jang³⁴ fariseo tionh² a⁴nau⁴i³ jau²³, a³ya¹queunh³ tsei⁴³ jmah³ o¹cau³², jon³ a⁴ji⁴ŋang⁴i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jian³ a⁴juah⁴ Jesús liah⁴: ―Hnei³ tionh²ˉ³, ma⁵jniah³²ˉ³ i⁴ni²tainh⁴³ˉ³ ta⁵nei² chie³, i² Jon⁴dai¹ ne⁵, ñi³i³ re³ m⁴tyi⁴ quianh³ˉ³ tionh²ˉ³; quie¹ a³lain⁴ chie³ a³eu⁴³ quein⁴³, i² ta⁵nei² Jon⁴dai¹ ne⁵, jen³i³ a³hain⁴ i⁴hianh¹ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Quie¹ lai²³ quieh¹ M³se²³, jian³ la⁴jeg³⁴ jau²³ i⁴a⁴sag⁴ a³sain² quian¹ Jon⁴dai¹, a⁴júan⁴ heih⁴³ la⁴teg⁴ jm² i⁴cuan³⁴ Juan³ Tei³²; i² liah⁴ma²jm² jon³ si³hleh² liah⁴ han⁵ chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, jian³ la⁴jang³⁴ a³cúah² pei⁴ han⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’I² la⁴jeg³⁴ i⁴ra³hleh² lai²³ ne⁵, i¹con³ juah⁴ne³ i⁴sa⁴li⁴tei⁴³; eu⁴³ pi¹ sa⁴jeuh⁴³ i⁴li⁴ua⁵jeu³² ñi⁴jeu⁵ jian³ cuah³²húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’La⁴jang³⁴ a³tyon⁴ jian²³ a³m⁴ quian¹ jian³ sanh⁴i³ jian²³i³ a³m⁴ sang³⁴, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ a³m⁴ sang³⁴; jian³ a³sanh⁴ jian²³ a³m⁴ a³ma³a⁴tyon⁴ jian²³ i³cúa³ hain⁴, ta³canh¹i³ chie³² i⁴hlenh⁴³i³ i³cúa³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Ma²sian³ jan³ a³jlanh² a³ma²hein² jmah³ a²hmh³ tsei²³ jian³ i⁴jlanh², jian³ la⁴jeg³⁴ jm² ma²júan³i³ jm² jauh³² quieh¹ i⁴co³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jian³ ma²sian³ jan³ a³ti⁴ñei³ liah⁴ a³sain³ La², a³tieh³² hmh⁴³ cah² he³² a³si³cua³ o²hnei³² quieh¹ a³jlanh² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jian³ ma²hnie³⁴ a³ti⁴ñei³ ne³ queuh⁴³i³ la⁴jeg³⁴ o¹leuh² i⁴jyih² i⁴queuh³ a³jlanh² hain⁴, jian³ tyie²³ a¹tsai³ hlonh²i³ a³hleih² nei² hmh⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","I² jon³ a⁴tyie³⁴ jm² i⁴a⁴jaun³⁴ a³ti⁴ñei³ hain⁴, jon³ a⁴te¹ ángel quieh¹i³ la⁴teg⁴ hlonh² A³brang²³. Jian³ a⁴jaun³⁴ a³jlanh² liah⁴, a⁴hon³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I² la⁴teg⁴ I²tionh² A³jaun² jon³, con³ma²si²can²³i³ ma²eu⁴³, jon³ a⁴je³⁴i³ ta⁵yeih³², a⁴jen³i³ A³brang²³ con³ i²gm⁴ jian³ La² a³sainh⁴³ hlonh²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","I² jon³ a⁴juah⁴ a³jlanh² hain⁴, a⁴hleh⁴i³ tia⁴: “Hnei³ a³don⁵ A³brang²³, neih³ˉ⁴, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnia⁴, sain⁴³ hnei³ La² ne³ canh⁴a² si⁵tia⁴³i³ naih¹ jon⁴³ si¹cúa³ joh⁴³ o¹jm³, jian³ sainh¹i³ hnei³ ta⁵la³ canh⁴a² ma⁵jñah⁴i³ leuh² o¹segh³²ˉ⁴, quie¹ ta² hlion⁴ ma²eu⁴³ si²can³⁴ˉ⁴ je¹ o¹jyi³ loh⁴³ la³.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","I² a⁴juah⁴ A³brang²³ ne⁵: “Hnei³ a³jon³⁴ˉ⁴, tyon¹ hnei³ hoh⁴³ la⁴conh⁴ tei⁴³ co³hyon²³tsei³ ni²quianh³ˉ³ m⁵cu³ quianh³ˉ³, jian³ La² la³ hlion⁴ ma²eu⁴³ ni²quian⁴i³ liah⁴. I² tieh²la³ ne⁵, can²³i³ co³hyon²³tsei³ i²la³ tieh²la³, i² hnei³ si²canh³ˉ³ ma²eu⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jian³ sia³ con³ nei² liah⁴, quie¹ hei¹ con³ ta³jeuh³ júah² to⁵chieh³² i²tieh²ˉ¹, jnie³² jian³ hnei³ tionh²ˉ³ liah⁴. I⁴jon³ sa⁴li⁴ŋang³⁴ a³tionh² i²la³ i⁴li⁴chie³⁴i³ i²ne³, jian³ a⁵ga⁴ a³tionh² i²ne³ li⁴jia²³ i²la³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","I² a⁴juah⁴ a³jlanh² liah⁴: “M³⁴ˉ⁴ i²conh²ˉ³ jon³, hnei³ a³don⁵ A³brang²³ neih³ˉ⁴, i⁴sainh¹ˉ³ La² ne³ jauh³² quieh¹ neih³ˉ⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","quie¹ tionh² pi¹ hña⁴ si³reunh³ˉ⁴ tionh², canh⁴a² si⁵hlenh³²i³ a³hain⁴, jian³ canh⁴a² sa⁴teg³⁴ quieh¹i³ jia²³i³ i²can²³ chie³ ma²eu⁴³ la⁴la³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","I² a⁴juah⁴ A³brang²³ ne⁵: “Quie¹ ra³quia³pa² jau²³ i⁴a⁴sag⁴ M³se²³ jian³ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹; lei⁴ li⁴ro³⁴i³ jeu³ jau²³ jon³.” ");
INSERT INTO cucNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","I² a⁴juah⁴i³ ne⁵: “Hnei³ a³don⁵ A³brang²³ neih³ˉ⁴, a⁵sia³ re³ la⁴ne³, i² juah⁴ne³ chie³⁴ jan³ a³si⁵hleh³² quieh¹i³ tionh² a³hyon⁴³ jen² a³jaun², leg⁴³ re³pa² li⁴sag³⁴i³ co³hei²tsei³ quieh¹ tionh².” ");
INSERT INTO cucNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","I² a⁴juah⁴ A³brang²³ liah⁴: “Juah⁴ne³ sa⁴i²nau³⁴i³ jau²³ i⁴a⁴sag⁴ M³se²³ jian³ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹, liah⁴ma³sa⁴ro³⁴ jon³ pi²³i³ jeu³, ua²liah⁴a² hyon⁴³ jan³ jen² a³jaun².” ");
INSERT INTO cucNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ chie³ quian¹: ―La⁴jeg³⁴ jm²pa² sia³ i⁴li⁴tianh⁵ chie³ chie³²; i² a³júan³ i⁴tianh⁵ chie³ chie³² ne⁵, ¡ta² jeu²³ a³hain⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Eu⁴³a² re³ ma²hñei³⁴i³ lau² con³ a²hnai³² ya¹hñei⁴³ con³ a²caun² pa¹, jon³ si⁵tiah³i³ teg⁴ joh⁴³ jm³ñih¹ la⁴conh⁴a² i⁴júan³⁴i³ i⁴tianh⁵ jan³ si³peih¹ la³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Jianh³ˉ³ júan² hnei³ tionh²ˉ³ la⁴ne³! ’Jian³ juah⁴ne³ a⁴tanh⁴ a³reunh³ˉ³ chie³² i²conh²ˉ³, jon³ hniah³ jainh¹i³ hnei³; i² juah⁴ne³ a⁴can³⁴i³ jau²³ ne⁵, jon³ hniah³ hainh³²ˉ³ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jian³ ua²liah⁴a² quie³⁴ nie⁴³ a⁴tanh⁴i³ chie³² con³ jm² i²conh²ˉ³, jian³ quie³⁴ nie⁴³ jon³ si⁵je³²i³ hnei³ con³ jm² liah⁴ i⁴juah⁴i³: “A⁵sie⁴³ ma⁵júan³²ˉ⁴”, jon³ hniah³ hainh³²ˉ³ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jon³ a⁴juah⁴ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Se³ño²³, a⁴juah⁴i³: ―Júan² hnei³ i⁴li⁴hain⁴ jnie³² re³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","I² a⁴juah⁴ Se³ño²³ i²con²³i³: ―Juah⁴ne³ ma²tei⁴³ i⁴hainh⁴ˉ³ tionh²ˉ³ conh⁴i² tei⁴³ con³ o¹m⁴ peih¹ quieh¹ mostaza, jon³ ma²li⁴jeuh³²ˉ³ a²hma³ sicómoro la³: “Ua²quei³ hnei³ i²si²seih⁴³ ne³, ua²seih³ hnei³ la⁴teg⁴ joh⁴³ jm³ñih¹”, i²jon³ ma²li⁴ro³⁴ a²hma³ jeu³ jau²³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Júan³²ˉ¹, jan³ hnei³ tionh²ˉ³, sian³ jan³ a³cúa²³ cúa³tag³² quian¹, a³hein² quiah³ húa³⁴ jian³ o⁴ a³hion⁴³ jah⁴, i² la⁴teg⁴i² ma³a⁴tyanh³i³, ¿o⁴ li⁴jeuh³²i³ hnei³: “Nia³ ni³nei⁴ ni³cauh⁴³”? ");
INSERT INTO cucNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Leg⁴³ re³pa², a⁵sia³, quie¹ jeuh³²i³ hnei³: “Júan² hnei³ ma³⁴ queuh¹ˉ⁴, hai⁴³ hnei³ a²hmh³ ta⁵mah²; tya² hnei³ ma³⁴ i⁴gueh³²ˉ³ jnia⁴ liah⁴a² a⁴leg³⁴ quien⁴ˉ⁴. Ma²jon³ a²ma⁴ queuh² hauh²ˉ³ quianh³.” ");
INSERT INTO cucNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Jian³ o⁴ cúah³²ˉ³ ti²hmah³² a³cúa²³ cúa³tag³² i²conh²ˉ³ tei⁴³i² ma³a⁴júan⁴i³ la⁴jeg³⁴ i⁴a⁴saih³²i³ hnei³, lainh⁴ˉ³? Leg⁴³ re³pa² a⁵sia³, lain³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","I² la⁴ne³pa² hnei³ tionh²ˉ³ liah⁴, tei⁴³i² ma³a⁴júanh²ˉ³ la⁴jeg³⁴ la⁴conh⁴ i⁴a⁴sag⁴³ hnei³ Jon⁴dai¹, jon³ li⁴juah²ˉ³: “Lang⁴³ jnie³² a³cúa²³ cúa³tag³² sa⁴quein⁴³, quie¹ co⁴jon³pa² a⁴júan² jnie³² conh⁴ ma²hniah³ júan² jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hein² pi¹ Jesús jeu³, ŋo³⁴i³ Jerusalén, jian³ ua⁴jeun³²i³ húa³⁴ Galilea jian³ húa³⁴ Samaria. ");
INSERT INTO cucNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jon³ a⁴tyie³⁴i³ con³ jeu³ peih¹, i²ua⁵ma⁵jainh³² quian³⁴ chie³ quieh¹i³ a³ti²lang⁴³ chie² i⁴jyih² o¹ŋeu⁴³ quieh¹, a³a⁴jian⁴ i²gm⁴ meih³, ");
INSERT INTO cucNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","jian³ a⁴hleh⁴i³ tia⁴ tionh², a⁴juah⁴i³: ―Hnei³ Jesús, A²teg²³, ¡ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnie³²! ");
INSERT INTO cucNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","I² con³ma²a⁴je³ Jesús quieh¹i³, jon³ a⁴sagh⁴³i³: ―Cua³ ua⁴han² tionh²ˉ³ yi⁴ma⁴jniah³²ˉ³ ta⁵nei² m³chie³ tionh². I² con³ma²ua⁵han²i³ tionh², ta¹la⁴ jon³ a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","I² jon³ ne⁵, jan³ a³hain⁴, con³ma²a⁴je³⁴i³ i⁴a⁴huan⁴ quieh¹i³, jon³ a⁴jainh³i³ nei² ya¹júan³i³ júanh⁴³ Jon⁴dai¹ ya¹hleh²i³ tia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jon³ a⁴si⁴jnei⁵i³ ta⁵nei² Jesús, a⁴jengh³i³ húa³⁴, a⁴cúa⁴i³ ti²hmah³² i²con²³i³. I² a³ne³ a³sian³ húa³⁴ Samaria. ");
INSERT INTO cucNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","I² a⁴juah⁴ Jesús, a⁴sagh⁴³i³ a³hain⁴: ―¿O⁴ a⁵hei⁴³ li⁵quian³⁴ a⁴huan⁴ quieh¹? ¿I² nah⁴³ i²ñi³⁴ hain⁴ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Quie¹ sa⁴a⁵han²i³ cúah³i³ Jon⁴dai¹ ti²hmah³², quie¹ jan³ a³sian³ ta⁵seg³⁴pa² a⁴cúa⁴ ti²hmah³². ");
INSERT INTO cucNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jon³ a⁴juah⁴ Jesús i²con²³ a³hain⁴: ―No³ hnei³, cuanh³ quianh³; ma³a⁴huan⁴ quianh³ˉ³ quie¹ ra⁵hainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jon³ a⁴ŋang⁴ fariseo tionh² i²con²³ Jesús hain³legh⁴ tyie¹ jm² júan³⁴ Jon⁴dai¹ heih⁴³ m⁵cu³ la³, i² a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Quie¹ i⁴júan³ Jon⁴dai¹ heih⁴³ m⁵cu³ la³ sa⁴lei³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jian³ a⁵ga⁴ sian³ a³li⁴juah⁴: “Jeh³² i²la³ júan³i³ heih⁴³”, jian³ o⁴ “I²jno³.” A⁵sia³, quie¹ ma³júan³ Jon⁴dai¹ heih⁴³ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jon³ a⁴sagh⁴³i³ chie³ quian¹: ―Jia²³ jm² i⁴hnoh³ˉ³ teg³⁴ mah²ˉ³ jm² i⁴jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴, i² hnei³ tionh²ˉ³, a⁵sia³ teg³⁴ mah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jian³ li⁴sag⁵i³ hnei³ ca³chion²³: “Jeh³² i²la³ sainh⁴³i³”, jian³ o⁴ “I²jno³ si²sainh⁴³i³.” Jon³ sa⁴hniah³ cúah²ˉ³ tionh²ˉ³, a⁵ga⁴ si²tyeinh³²ˉ³ coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Quie¹ liah⁴i² tagh³ joh¹ o¹jyi³ quieh¹ a⁵ñih³ la⁴teg⁴ ta⁵ca³jo³² m⁵cu³, la⁴ne³ lei⁴ la⁴teg⁴i² teg³⁴ jm² jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","I² ñeih³²jia⁴³ ne⁵, hniah³ can³⁴i³ ma²eu⁴³ hlion⁴, jian³ hniah³ ton³⁴ chie³ a³sian³ tieh²la³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Liah⁴i² a⁴leg³⁴ jm² ma²sian³ Noé, la⁴ne³ lei⁴ jm² i⁴jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Quie¹ ma²jon³ ti²queuh³i³ hangh²i³, ti²sanh⁴i³ jian³ ti²cúan⁴³i³ si³jon⁴³ i⁴sanh⁴, la⁴conh⁴i² a⁴tyie³⁴ jm² i⁴a⁴hei³⁴ Noé joh⁴³ a²úan⁴³ i⁴leg⁴³ a²hnei⁴³, ma²jon³ a⁴canh³ jm³ m⁵cu³, a⁴chian³⁴ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jian³ la⁴jon³ liah⁴ liah⁴i² a⁴leg³⁴ jm² ma²sian³ Lot, ma²queuh³i³ hangh²i³, ma²ti²la²³i³ jian³ ma²ti²hnang³i³, ma²ti²jnei³i³ jian³ ma²ti²júan³i³ a²hnei⁴³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","I² jm² i⁴ua⁵hag⁴³ Lot jeu³ Sodoma ne⁵, jon³ a⁴tah⁴ o¹jyi³ loh⁴³ jian³ o¹jeu² o¹jyi³ i⁴ma⁴tyan³i³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La⁴ne³ lei⁴ la⁴teg⁴i² a⁴teg⁴ jm² ma⁵jnia³² A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Jian³ a³hain⁴ a³sainh⁴³ yeih³² cah³² hnei⁴³ jm² jon³, sa⁴hniah³ jyon⁴³i³ juah⁴ i⁴si⁵quien²³i³ quieh¹ i⁴nie⁴³ jauh³²; jian³ a³hain⁴ a³sainh⁴³ je¹, sa⁴hniah³ chianh³i³ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tyon¹ hnei³ hoh⁴³ liah⁴ a⁴jainh⁴³ a³m⁴ quian¹ Lot. ");
INSERT INTO cucNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Quie¹ la⁴jang³⁴ a³hnie³⁴ lion⁴ m⁵cu³ quieh¹, si⁵hain⁴ pi²³i³, jian³ la⁴jang³⁴ a³si³hain⁴ m⁵cu³ quieh¹, hyieh⁴i³ liah⁴ i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, je¹nai³ jon³ ra³han² on³⁴ nei² jain³²; jan³pa² te⁴³i³, jian³ jan³ jian³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Jian³ on³⁴ a³m⁴ ti²húah² ti²tionh² nei² a²to²³; jan³pa² te⁴³i³, jian³ jan³ jian³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Jian³ on³⁴ chie³ ti²tionh² je¹; jan³pa² te⁴³i³, jian³ jan³ jian³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","I² jon³ a⁴juah⁴ chie³ quian¹i³ tionh², a⁴sagh⁴³i³ Jesús: ―¿Jainh¹ lei⁴ i⁴ne³, juah², Se³ño²³? I² a⁴juah⁴ Se³ño²³: ―I²jon³ i²ra³quian³ he³² jaun², i²jon³pa² ŋangh³ a¹teu³júa⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jian³ a⁴can³⁴ Jesús con³ jau²³ liah⁴, nei² quieh¹ i⁴hniah³ mh³i³ Jon⁴dai¹ la⁴jeg³⁴ nie⁴³ i⁴sa⁴quian¹ tsei⁴³i³, ");
INSERT INTO cucNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","juah⁴i³: ―Con³ jeu³ ma²sian³ júa¹ a³sa⁴ma³con⁴³ Jon⁴dai¹, jian³ a⁵sia³ jm² si²quian¹i³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Jian³ ma²sian³ jan³ a³don⁵ m⁴ hnang⁴ jeu³ jon³ liah⁴ a³con³ ta² ma²si³je³² quieh¹i³, i⁴sagh⁴³i³: “Júan² hnei³ re³ nei² quien⁴ˉ⁴, canh⁴a² sa⁴cagh¹ a³hie²³ jnia⁴ jm².” ");
INSERT INTO cucNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","I² júa¹ ne⁵, sa⁴i²ro³⁴i³ jeu³ jau²³ quieh¹ a³don⁵ m⁴, úa⁴ a⁴teg⁴, i² coh⁵ jon³, a⁴júan⁴i³ co³hei²tsei³ naih⁵ ni²tsei⁴³i³, juah⁴i³: “Ua²liah⁴a² sa⁴con⁴³ˉ⁴ Jon⁴dai¹, jian³ a⁵sia³ jm² si²quian¹ˉ⁴ chie³ liah⁴; ");
INSERT INTO cucNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","i² jon³ ne⁵, a³don⁵ m⁴ ne³ ŋeng²³ si³quian⁵ tsei³⁴ˉ⁴, eu⁴³a² re³ júan³²ˉ⁴ re³ nei² quieh¹i³, canh⁴a² sa⁴jia²³i³ i⁴lagh⁵, jian³ canh⁴a² sa⁴ua⁵jeu³² si³quian⁵ˉ⁵ tsei³⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jon³ a⁴juah⁴ Se³ño²³: ―A⁴naih³ˉ³ tionh²ˉ³ liah⁴ a⁴juah⁴ júa¹ hlangh². ");
INSERT INTO cucNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","I² la⁴ne³ ne⁵, ¿o⁴ a⁵sia³ li⁴júan³⁴ Jon⁴dai¹ re³ nei² quieh¹ a³quianh² quian¹i³, a³hleh⁴³ quieh¹i³ la⁴húa²³ la⁴jm²³, lainh⁴ˉ³? ¿Jian³ o⁴ lainh⁴ˉ³ si⁵le⁴ i⁴jainh³i³ jau²³? ");
INSERT INTO cucNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Juah³ jnia⁴ a⁵sia³ si⁵le⁴ i⁴júan³⁴i³ re³ nei² quieh¹ chie³ quian¹. I² la⁴teg⁴i² jionh⁴ A³a⁴lang³⁴ Chie³ hain⁴, ¿o⁴ tionh² pi¹ a³ti²hain⁴ i²con²³i³ cuah³²húa³⁴ la³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Conh⁴liah⁴ a⁴tya⁴ Jesús i²con³ jau²³ la³ i²con²³ chie³ a³lain⁴ a³eu⁴³ ni²taih⁴³ tionh² i⁴sa⁴ron⁴³i³ chie³ sang²³ jeu³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―On³⁴ chie³ ŋo³⁴ cuah³júah² ua⁵mh²i³ Jon⁴dai¹: jan³ a³hain⁴ lang⁴³ fariseo jian³ jan³ a³hain⁴ lang⁴³ a³can²³ hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","I² fariseo hain⁴, si²sainh⁴³i³, a⁴mh³i³ Jon⁴dai¹ la⁴la³: “Hnei³ Jon⁴dai¹, cúah⁵ˉ⁵ hnei³ ti²hmah³² quie¹ sa⁴lang⁴³ˉ⁴ liah⁴i² lang⁴³ chie³ sang²³ tionh², a³júan³ hang³, a³sa⁴ni²taih⁴³, a³hlenh⁴³i³ i³cúa³ chie³, a⁵ga⁴ lang⁴³ˉ⁴ liah⁴i² lang⁴³ a³can²³ hmah¹ ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jian³ taun³⁴ nie⁴³ júan³⁴ˉ⁴ he² i⁴sa⁴queuh³ˉ⁴ con³ sa³ma², jian³ cúa³⁴ˉ⁴ a²teg⁴ quia³⁴ chieh³² la⁴jeg³⁴ i⁴lai⁴ˉ⁴”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","I² a³can²³ hmah¹ ne⁵, i²gm⁴pa² si²sainh⁴³i³, i¹ sa⁴hnie³⁴i³ i²sieh³i³ ma³nei² ta⁵yeih³². Quie¹ con³ i⁴si²quein³i³ ni²tsei⁴³ pi²³i³, juah⁴i³: “Hnei³ Jon⁴dai¹, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnia⁴ i⁴lang⁴³ˉ⁴ a³ren³ chie³²”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","I² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, ŋah³i³ jauh³² quieh¹ i⁴a⁴jlenh³ chie³² quieh¹i³, i² fariseo ne⁵, a⁵sia³. Quie¹ la⁴jang³⁴ a³júan³ júanh⁴³, sainh³i³ o³hyeih²; jian³ a³hain⁴ a³júan³ ti⁴ñeih⁵, lei⁴ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jon³ ti²jian³i³ si³maih² peih¹ ta⁵nei² Jesús, canh⁴a² tei³⁴ Jesús si¹cúa³ i²con²³i³. I² con³ma²a⁴je³⁴ chie³ quian¹ Jesús, jon³ a⁴jain³⁴i³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","I² Jesús ne⁵, a⁴teh³i³ a³hain⁴ tionh², a⁴sagh⁴³i³: ―Cúa² hnei³ jeu³ i⁴ya⁴han² si³maih² peih¹ hlonh²ˉ⁵, a⁵hnia³ hnei³ tionh²ˉ³; quie¹ a³la⁴ne³ tionh² han⁵ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","I⁴chie⁴³pa² juah³ˉ⁴, a³hain⁴ a³sa⁴hyei³ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹ liah⁴i² hyei³ jan³ yein³, sa⁴li⁴si⁵hei⁴i³ naih⁵ heih⁴³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jon³ a⁴ŋang⁴ jan³ chie³ tyein² i²con²³ Jesús, a⁴juah⁴i³: ―Hnei³ A²teg²³ tsein²³, ¿henh⁴ hniah³ júan³²ˉ⁴ canh⁴a² li⁴sia³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quien⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿E⁴le³⁴ teh⁵ˉ³ jnia⁴ a³tsein²³? Quie¹ i¹jan³ a³tsein²³ sa⁴sian³, jan³ Jon⁴dai¹pa². ");
INSERT INTO cucNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Quie¹ ñih¹ hnei³ heih⁴³ quieh¹ Jon⁴dai¹ i⁴ra³juah⁴: “A⁵hlenh⁴³ hnei³ a³sa⁴lang⁴³ i³cúah³ˉ³; a⁵jŋangh⁴³ hnei³ chie³; a⁵júan³ hang³; a⁵hleh³ hnei³ jau²ta³jau²³ nei² quieh¹ i¹jan³; jian³ ma⁴con³² hnei³ naih⁴³sieh³.” ");
INSERT INTO cucNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","I² a⁴juah⁴i³ ne⁵: ―La⁴jeg³⁴ i⁴ne³ ma⁵tei³²ˉ⁴ liah⁴ma²maih⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","I² con³ma²a⁴nau⁴ Jesús jau²³ jon³, jon³ a⁴sagh⁴³i³ a³hain⁴: ―Sia³ pi¹ i²con³ i⁴si³hain⁴ quianh³ˉ³: cua³ ua⁴hnang² la⁴jeg³⁴ i⁴sia³ quianh³ˉ³, ma²jon³ cúah³²ˉ³ a³ti⁴ñei³ o¹cau³² jon³, canh⁴a² li⁴sia³ i⁴quein⁴³ hlion⁴ quianh³ˉ³ ñi⁴jeu⁵; ma²jon³ niah²ˉ³ si²tyeinh³²ˉ³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","I² hei⁴i³, con³ma²a⁴nau⁴i³ jau²³ ne³, ta² ra⁵chionh⁴ tsei⁴³i³ quie¹ eu⁴³ jlanh²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","I² con³ma²a⁴je³⁴ Jesús i⁴eu⁴³ chionh⁴ tsei⁴³i³ a⁴leg³⁴, jon³ a⁴juah⁴i³: ―¡Ta² jeuh⁴³ nie⁴³ i⁴si⁵han² a³sia³ hlion⁴ quieh¹ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹! ");
INSERT INTO cucNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Eu⁴³a² sa⁴jeuh⁴³ i⁴si⁵hei⁴ jan³ a²ca³me²llo³ to³ a²ma³cau³², la⁴conh⁴a² i⁴hei⁴ jan³ a³jlanh² naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","I² la⁴jang³⁴ a³a⁴nau⁴ jau²³ ne³ a⁴juah⁴i³ tionh²: ―Juah⁴ne³ la⁴ne³ ne⁵, ¿hain³ pi² lei⁴ li⁴lion⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―I⁴sa⁴tieh¹ chie³ li⁴júan³⁴ tionh², Jon⁴dai¹pa² tieh¹ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","I² jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Jeh³², ma³a⁴tien² jnie³² la⁴jeg³⁴ i⁴sia³ quian⁴ jnie³², jian³ ma³ya¹han² jnie³² coh⁵cah³²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","I² a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³ma³a⁴teinh³ tsei⁴³ a²hnei⁴³ quieh¹, jian³ o⁴ jmai³sie²³i³, si³reunh¹i³, jian³ o⁴ a³m⁴ quian¹i³, si³jon⁴³i³, nei² quieh¹ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, ");
INSERT INTO cucNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","jian³ hlion⁴ pi¹ hyei³⁴i³ cuah³²húa³⁴ la³, jian³ hyieh⁴i³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ m⁵cu³ con³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jon³ jian³ Jesús quia⁵teun⁴ chie³ quian¹ con³ ta⁵co⁴³, a⁴sagh⁴³i³: ―Jeh³², tieh²la³ tieh²ˉ¹ jeu³ chie²ˉ¹ Jerusalén, i² jon³ i²li⁴tei⁴³ la⁴jeg³⁴ i⁴ra³sag² nei² quieh¹ A³a⁴lang³⁴ Chie³ hain⁴ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Quie¹ cúanh⁴³i³ a³hain⁴ joh⁴³ cúa³ a³sa⁴lang⁴³ judío, i⁴ji⁵ŋang⁴i³, jian³ júanh¹i³, jian³ hñi⁵i³ jm³teuh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","I² tei⁴³i² ma³a⁴po³⁴i³, jon³ jŋangh³i³; i² tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³, jon³ hyon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","I² hei⁴i³ tionh² ne⁵, i¹leuh² sa⁴ra⁵ŋang⁴i³ jau²³ ne³, ra³hma²pa² jau²³ ne³ i²con²³i³, sa⁴quienh⁴ tyi²i³ la⁴jeg³⁴ i⁴hleh⁴³ Jesús quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jian³ con³ma³o¹tyie¹ Jesús je¹jeu³ Jericó, jon³ ua²cua⁴³ jan³ a³taun³² ho³²jeu³ a³ua²m²³ o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","I² con³ma²a⁴nau⁴i³ ua³jeun³² jeun⁴³ chie³, jon³ a⁴ŋang⁴i³ henh⁴ si³lei⁴ ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","I² jon³ a⁴juah⁴i³ tionh², Jesús a³sian³ jeu³ Nazaret pa² hein² jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","I² jon³ a⁴hleh⁴ a³taun³² hain⁴ tia⁴, a⁴juah⁴i³: ―¡Hnei³ Jesús, Sa¹jeun³ Da³vei²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnia⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","I² la⁴jang³⁴ a³ya¹jian⁴³ nei² a⁴jain³⁴i³ a³hain⁴ canh⁴a² cua³⁴i³ tai³²; i² hei⁴i³ ne⁵, tsei³⁴sa² tia⁴ a⁴hleh⁴i³: ―¡Hnei³ Sa¹jeun³ Da³vei²³, ua²jieh⁴ ñei⁴ hoh⁴³ˉ³ i²con²³ jnia⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","I² Jesús ne⁵, a⁴jian⁴i³, a⁴júan⁴i³ heih⁴³ i⁴si⁵quian⁴i³ a³hain⁴ teg⁴ hlonh²i³. I² con³ma²a⁴tyie³⁴i³, jon³ a⁴ŋang⁴ Jesús i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","a⁴juah⁴i³: ―¿Henh⁴ hnoh³ˉ³ júan³²ˉ⁴ i²conh²ˉ³? I² jon³ a⁴juah⁴ a³taun³² hain⁴: ―Hnei³ Se³ño²³, hno⁵ˉ⁵ júanh²ˉ³ i⁴jnia⁵ m⁴nei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jon³ a⁴juah⁴ Jesús i²con²³i³: ―Ua²jnia⁵ quianh³ˉ³, ma³a⁴huan⁴ quianh³ˉ³ quie¹ ra⁵hainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","I² liah⁴ma²jon³ a⁴jnia⁵ m⁴nei²i³, ŋo³⁴i³ coh⁵cah³² Jesús, ya¹júan³i³ júanh⁴³ Jon⁴dai¹. I² con³ma²a⁴je³⁴ la⁴jang³⁴ chie³ i⁴a⁴leg³⁴ jon³, a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","I² con³ma²a⁴hei³⁴ Jesús jeu³ Jericó jon³, jon³ hein²i³ jeu³, jeu³ to⁵chieh³² je¹jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Jian³ jeu³ jon³ cua⁴³ jan³ jeu³² a³can²³ hmah¹, a³sain³ Zaqueo, jan³ a³jlanh². ");
INSERT INTO cucNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I² hei⁴i³ hnie³⁴ jen⁴³ Jesús hain³ chianh². I² sa⁴tian⁴ je⁴³i³ ne⁵, quie¹ eu⁴³ jeun⁴³ chie³, jian³ la³ a²con³ teg³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","I² hei⁴i³ ne⁵, ŋo³⁴i³ jeu³ra³tyi⁴ ta⁵nei², jon³ a⁴eu⁴i³ con³ a²hma³ sicómoro canh⁴a² li⁴jen⁴³i³ Jesús, quie¹ jeu³ jon³ hniah³ ua⁵jeun³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","I² con³ma²a⁴tyie³⁴ Jesús o³chie⁴³ jon³, jon³ a⁴je³⁴i³ ta⁵yeih³², a⁴jen³i³ Zaqueo, jian³ a⁴sagh⁴³i³: ―Hnei³ Zaqueo, ta¹tia⁴ jyon²³ hnei³, quie¹ ne³⁴ hniah³ ton³²nie⁴³ ni¹jian³⁴ˉ⁴ jauh³² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","I² hei⁴i³ ne⁵, a⁴jyon²³i³ ta¹tia⁴, jian³ a⁴hyein⁴³i³ Jesús si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","I² con³ma²a⁴je³⁴ la⁴jang³⁴ chie³ sang²³, jon³ a⁴si⁴hen⁴³i³ Jesús, a⁴juah⁴i³ i⁴ua⁵jian³ Jesús jauh³² quieh¹ jan³ a³ren³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","I² Zaqueo ne⁵, a⁴no³i³ ta⁵nei² Se³ño²³, a⁴sagh⁴³i³: ―Hnei³ Se³ño²³, tieh²la³ cúah²ˉ⁵ a³ti⁴ñei³ to⁵chieh³² i⁴sia³ quien⁴ˉ⁴; jian³ juah⁴ne³ sian³ a³ma³a⁴qui⁵ˉ⁵ quieh¹ i⁴ma⁴can²i³ jnia⁴, jon³ cúah²ˉ⁵ quieh¹i³ quin⁴ ra³jeunh³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jon³ a⁴juah⁴ Jesús: ―Ne³⁴ pi¹ a⁴tyie³⁴ jm² i⁴lion⁴ a³tionh² jauh³² la³, quie¹ ta⁵la⁴ lang⁴³ hei⁴i³ sa¹jeun³ quian¹ A³brang²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Quie¹ cuan³⁴ A³a⁴lang³⁴ Chie³ hain⁴ i⁴ua⁵hniah³i³ a³ma³ua⁵hain⁴ i⁴ua⁵lion³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Con³ma²a⁴nau⁴ chie³ tionh² jau²³ jon³, jon³ a⁴can³⁴ Jesús con³ jau²³, quie¹ ma³o¹tyie¹i³ Jerusalén, jian³ ti²lain⁴ chie³ tionh² i⁴ma³a⁴tyie³⁴ jm² i⁴júan³⁴ Jon⁴dai¹ heih⁴³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jon³ a⁴juah⁴i³: ―Ma²sian³ jan³ chie³ a³júanh⁴³, a³ŋo²³ con³ jeu³ gm⁴ a³ua⁵hyei⁴ heih⁴³ i⁴lain⁴i³ re¹ jian³ jionh⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","I² naih⁵i² chie³⁴i³ ne⁵, a⁴teh³i³ quian³⁴ a³cúa²³ cúa³tag³² quian¹ a³a⁴cúah³i³ ma⁵con³ o¹cau³² tie³, jian³ a⁴sagh⁴³i³: “Júan² hnei³ ta¹ o¹cau³² la³ la⁴conh⁴i² a⁴nioh⁵ˉ⁵.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","I² a³co²³i³ a³sian³ jeu³ jon³, hion²³i³ chie³ júanh⁴³ hain⁴, jian³ a³tionh² jeu³ co²³i³ jon³, a⁴sain⁴i³ chie³ quian¹ a³ti²quian³ jau²³ la³: “Sa⁴hnio⁴³ jnie³² a³hain⁴ i⁴júan³⁴i³ heih⁴³ jen² jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’I² ton³²nie⁴³ ne⁵, a⁴lang³⁴i³ re¹, coh⁵ jon³ a⁴tyanh³i³ jeu³ co²³. Ma²jon³ a⁴teh³i³ la⁴jang³⁴ a³cúa²³ cúa³tag³² quian¹ a³ma³a⁴cúah³i³ o¹cau³², hnie³⁴i³ li⁴ñi³i³ la⁴conh⁴ ma³ta⁴tsain¹ quieh¹ con⁴jan³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","I² jon³ a⁴tyie³⁴ jan³ co⁴ra⁴lie⁵, a⁴juah⁴i³: “Hnei³ a³don⁵, o¹cau³² jon³ quianh³ˉ³ ma³ta⁴tsain¹ quia³⁴ jeunh³.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jon³ a⁴juah⁴ jeu³²i³: “Ta² tsei³⁴, hnei³ a³cúa²³ cúa³tag³² a³tsein²³; quie¹ re³ ma⁴teih³²ˉ³ ua²liah⁴a² co⁴meih³, jon³ cúa¹ˉ⁴ i⁴júanh²ˉ³ heih⁴³ quia³⁴ jeu³ júah².” ");
INSERT INTO cucNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jon³ a⁴tyie³⁴ i²jan³, a⁴juah⁴i³: “Hnei³ a³don⁵, o¹cau³² jon³ quianh³ˉ³ ma³ta⁴tsain¹ hña⁴ jeunh³.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Conh⁴liah⁴ a⁴juah⁴ jeu³²i³ i²con²³i³: “Hnei³ júanh²ˉ³ heih⁴³ i²con²³ hña⁴ jeu³ júah².” ");
INSERT INTO cucNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Conh⁴liah⁴ a⁴tyie³⁴ i²jan³ liah⁴, a⁴juah⁴i³: “Hnei³ a³don⁵, jeh³² o¹cau³² jon³ quianh³ˉ³ la³ i⁴a⁴hie³⁴ˉ⁴ ra³lie³ a²pan²; ");
INSERT INTO cucNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","quie¹ ra⁵con⁴³ˉ⁴ hnei³, quie¹ langh⁴³ hnei³ jan³ a³hyan³ tsei⁴³, jian³ lainh⁴ˉ³ ta¹ quieh¹ a³sang²³ jian³ jaih⁴ˉ³ i²sa⁴a⁴jñih⁴ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","I² a⁴juah⁴ jeu³²i³: “Hnei³ a³cúa²³ cúa³tag³² hlangh², con⁴juah⁴ jau²³ i⁴hleh³ ne³pa² hnei³ hnang²³ˉ⁵ hnei³. Quie¹ ma²ñih¹ˉ³ i⁴lang⁴³ˉ⁴ a³hyan³ tsei⁴³ i⁴lai⁴ˉ⁴ ta¹ quieh¹ a³sang²³ jian³ i⁴jaih³²ˉ⁴ i⁴sa⁴a⁴jan³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","I² jon³ ne⁵, ¿e⁴le³⁴ sa⁴a⁴tienh³ˉ³ o¹cau³² quien⁴ˉ⁴ banco ne⁵, canh⁴a² tei⁴³i² ma²ma³nioh⁵ˉ⁵, ma²hyeih³²ˉ⁴ i⁴ma²ta⁴tsain¹?” ");
INSERT INTO cucNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","I² jon³ a⁴juah⁴ re¹ i²con²³ a³tionh² ta⁵nei²i³: “Qui⁴³ hnei³ o¹cau³² tie³ i⁴quian³ a³ne³, cúah³² hnei³ a³quian³ quia³⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","I² a⁴juah⁴ a³hain⁴ tionh²: “Hnei³ a³don⁵, quie¹ ma³quian³ pi²³i³ quia³⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jon³ a⁴juah⁴ re¹ hain⁴: “Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴jang³⁴ a³ma³quian³, hyieh⁴ pi¹i³; i² a³hain⁴ a³sa⁴quian³ ne⁵, la⁴teg⁴ ca³leuh² i⁴quian³i³ jon³, qui⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jian³ a³hain⁴ a³sa⁴ma²hnie³⁴ lain⁴ˉ⁴ re¹ i²con²³i³ tionh², jian⁴³ hnei³ ta⁵la³, ni³queih¹ hnei³ lau²i³ tionh² ta⁵nei³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Con³ma²a⁴hleh⁴ Jesús jau²³ jon³, a⁴hei³⁴i³ jeu³ liah⁴, ŋo³⁴i³ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Con³ma²a⁴tyie³⁴i³ hloh³² jeu³ Betfagé jian³ jeu³ Betania, nie⁴³ hloh³² mah⁴ i⁴teh²i³ i⁴quieh¹ a²hma³ Olivos, i² jon³ a⁴sain⁴i³ on³⁴ chie³ quian¹, ");
INSERT INTO cucNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","a⁴sagh⁴³i³: ―Cua³ jeu³ peih¹ nie⁴³ ta⁵nei² ne³ tionh²ˉ³, i² tei⁴³i² ma³a⁴cúah³ˉ³ i²jno³, jon³ tyanh³²ˉ³ jan³ a²lo¹siah³ peih¹ a³si²hñih², jian³ i¹jan³ a⁵sian⁴³ ma³ua⁴tsain³². Jon³ sainh³²ˉ³ jian³ teh³²ˉ³ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jian³ juah⁴ne³ sian³ a³ŋang⁴ i²conh²ˉ³: “¿E⁴le³⁴ ti²sainh⁵ˉ³ a²lo¹siah³ ne³ tionh²ˉ³?” jon³ jeuh³²i³ hnei³ la⁴la³: “Quie¹ hniah³ quian¹ Se³ño²³pa².” ");
INSERT INTO cucNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jon³ ua⁵han² a³a⁴sain⁴ hain⁴ tionh², jian³ a⁴je³⁴i³ la⁴jeg³⁴ i⁴ra⁵tei⁴³ jau²³ liah⁴ a⁴juah⁴ Jesús i²con²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","I² con³ma²ti²sainh⁵i³ a²lo¹siah³, jon³ a⁴juah⁴ jeu³² jah⁴ i²con²³i³ tionh²: ―¿E⁴le³⁴ ti²sainh⁵ˉ³ a²lo¹siah³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","I² jon³ a⁴juah⁴i³ tionh²: ―Quie¹ hniah³ quian¹ Se³ño²³pa². ");
INSERT INTO cucNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jon³ jian³i³ i²con²³ Jesús. I² con³ma²a⁴ja³⁴ chie³ quian¹i³ a²cúan³ tionh² ma³cah³² a²lo¹, jon³ a⁴tyan⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","I² ta¹la⁴ hein² Jesús jeu³ ti²ja²³i³ a²cúan³ ho³²jeu³ tionh² jeu³ chie²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Con³ma²ma³a⁴tyie³⁴i³ hloh³² i²si²jeg²³ mah⁴ quieh¹ a²hma³ Olivos, jon³ a⁴hleh⁴ la⁴jang³⁴ chie³ quian¹i³ i⁴tia⁴ i⁴si³hyonh³i³, a⁴júan⁴i³ i⁴júanh⁴³ Jon⁴dai¹ nei² quieh¹ la⁴jeg³⁴ ua³júah² i⁴ma³a⁴je³⁴i³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","a⁴juah⁴i³: ―¡Ta² tsei³⁴ jm² ren³ re¹ a³ja²³ con⁴juah⁴ jm³i⁴sain³ Se³ño²³ Jon⁴dai¹! ¡Ua²lei⁴ si³hyonh³ a³tionh² ñi⁴jeu⁵, jian³ ua²lei⁴ júanh⁴³ Jon⁴dai¹ liah⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","I² jon³ a⁴juah⁴ co⁴meih³ chie³ fariseo a³tionh² jen² chie³ jeun⁴³ hain⁴, a⁴sagh⁴³i³ Jesús: ―Hnei³ A²teg²³, hlenh³² hnei³ chie³ quianh³ a⁵ua²hleh⁴³i³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","I² a⁴ŋangh³ Jesús ne⁵, a⁴juah⁴i³: ―Jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ juah⁴ne³ cauh³ a³ne³ lau² tionh², lei⁴ li⁴hleh³ a²caun² liah⁴ tia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","I² con³ma²a⁴tyie³⁴i³ hloh³² je¹jeu³ Jerusalén, jon³ a⁴je³⁴i³ i²jon³, jian³ a⁴hoh⁵i³ nei² quieh¹, ");
INSERT INTO cucNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","i⁴juah⁴i³: ―¡Ta² ma²re³ juah⁴ne³ ma²ra⁵ŋangh⁴ˉ³ i⁴sianh³ˉ³ jm² ne³⁴ liah⁴ ma²li⁴cúah¹ˉ³ i²cang³⁴ hoh⁴³ˉ³ jianh²ˉ³ Jon⁴dai¹! I² tieh²la³ ne⁵, ra³jleg³ i⁴jon³ i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Quie¹ jia²³ jm² tei⁴³i² júan³⁴ a³hie²³ hnei³ a²ha⁴ co⁴la⁴langh⁵ hnei³ tionh²ˉ³, jian³ jnei³⁴i³ co⁴la⁴lagh⁵, jian³ sonh³i³ hnei³ co⁴la⁴lagh⁵, ");
INSERT INTO cucNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","jian³ cúan³⁴i³ la⁴jeg³⁴ teg⁴ húa³⁴, jian³ i¹con³ m⁴caun² a⁵sie⁴³ ra³quia³ nei² m⁴caun² reunh¹ nei² lei⁴, jian³ ma⁵tyan³i³ la⁴jang³⁴ a³sian³ i²conh²ˉ³, quie¹ sa⁴ra⁵lainh²ˉ³ jm² i⁴cuan³⁴ Jon⁴dai¹ i⁴ma²lie⁴³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","I² con³ma²a⁴hei³⁴ Jesús cuah³júah², jon³ ma⁴lie⁵i³ a⁴húan⁴³i³ la⁴jang³⁴ a³ti²hnang³ jian³ a³ti²la²³ i²jon³, ");
INSERT INTO cucNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a⁴sagh⁴³i³ a³hain⁴ tionh²: ―Quie¹ ra³sag² Ma²jyi³: “Jauh³² quien⁴ˉ⁴, jauh³² i²mh²i³ Jon⁴dai¹ pi²³i³.” I² hnei³ tionh²ˉ³ júanh³ˉ³ jauh³² la³ la⁴con³ to³hlo³ quieh¹ hang³. ");
INSERT INTO cucNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jian³ conh⁴ con³ jm² a⁴heh³i³ chie³ cuah³júah²; i² m³chie³ tyein² tionh², jian³ a²teg²³ quian¹ lai²³, jian³ la⁴jang³⁴ a³tyein² quian¹ a³jeu³ tionh², hnoh³i³ liah⁴ li⁴jŋangh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","I² sa⁴tyieh¹i³ liah⁴ li⁴lei⁴, quie¹ la⁴jang³⁴ chie³ ti²nau³ tai³² jau²³ i⁴hleh² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Con³ jm² hein² Jesús cuah³júah², si²heh²i³ a³jeu³, si²hleh² jau²³ tsei²³ quieh¹ Jon⁴dai¹, i² jon³ a⁴tyie³⁴ m³chie³ tyein² tionh² jian³ a²teg²³ quian¹ lai²³, jian³ a³don⁵ ma⁴³teg²³ tionh² liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","a³hain⁴ a³a⁴hlenh⁴³ Jesús, a⁴juah⁴i³: ―Sai³² hnei³ jnie³² hain³ heih⁴³ quianh²ˉ³ i⁴júanh³ˉ³ la⁴jeg³⁴ i⁴ne³. ¿Jian³ o⁴ hain³ a⁴cúa⁴ heih⁴³ ne³ i²conh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Hno⁵ jnia⁴ liah⁴ ŋang¹ˉ⁴ con³ i²conh²ˉ³ tionh²ˉ³; jian³ jainh¹ hnei³ jau²³: ");
INSERT INTO cucNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿hain³ a⁴júan⁴ heih⁴³ i²con²³ Juan³ Tei³² i⁴ua⁵sion⁴³ chie³ jm³? ¿O⁴ Jon⁴dai¹ jian³ o⁴ chie³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jon³ a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: ―Juah⁴ne³ juah²ˉ¹ i⁴ Jon⁴dai¹pa² a⁴júan⁴ heih⁴³ i²con²³i³, jon³ sag⁵i³ jnia¹: “¿E⁴le³⁴ sa⁴ra⁵hainh⁴ˉ³ jau²³ quieh¹i³ ne⁵?” ");
INSERT INTO cucNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jian³ juah⁴ne³ saih³²i³ jnia¹ i⁴a⁴sai⁴ chie³pa² quieh¹i³, lei⁴ li⁴quih⁵ jnia¹ la⁴jang³⁴ a³jeu³ m⁴caun², quie¹ la⁴jang³⁴i³ ti²ñi³ i⁴ma²lang⁴³ Juan²³ hain⁴ jan³ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","I² jon³ a⁴ŋangh³i³ tionh² i⁴sa⁴ñi³i³ hain³ a⁴sai⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","I² a⁴juah⁴ Jesús liah⁴: ―Jian³ jnia⁴ liah⁴, a⁵sia³ jeu¹ˉ⁴ hnei³ tionh²ˉ³ hain³ heih⁴³ quian³²ˉ⁴ i⁴júan³⁴ˉ⁴ la⁴jeg³⁴ i⁴la³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Conh⁴liah⁴ a⁴hleh⁴ Jesús i²con²³ a³jeu³ jau²³ i⁴a⁴can³⁴i³ la³: ―Ma²sian³ jan³ chie³ a³jnia² o¹m⁴ ya¹gm³jeh² quieh¹, jon³ a⁴tonh³i³ je¹ jon³ joh⁴³ cúa³ co⁴meih³ a³júan³ ta¹, jon³ ua⁵hag⁴³i³ ta⁵seg³⁴ úa⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","I² con³ma²a⁴tyie³⁴ jm² a⁴lo³, jon³ a⁴sain⁴i³ jan³ a³cúa²³ cúa³tag³² quian¹ i²con²³ a³júan³ ta¹ je¹ hain⁴ canh⁴a² ma²cúah³i³ co⁴meih³ o¹m⁴ ya¹gm³jeh² jon³; i² a³júan³ ta¹ hain⁴ tionh² ne⁵, a⁴pan³⁴i³ a³hain⁴, a⁴sainh³i³ a³hain⁴ ti¹hag⁵ si¹cúa³ to⁵lang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Conh⁴liah⁴ a⁴sain⁴ a³quieh¹ je¹ hain⁴ i²jan³ a³cúa²³ cúa³tag³² quian¹; i² a³júan³ ta¹ hain⁴ tionh² liah⁴, a⁴júanh¹i³ a³ne³, jian³ a⁴sagh⁴³i³ jau²hlagh³², jian³ a⁴saih³i³ to⁵lang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I² jon³ a⁴sain⁴ a³quieh¹ je¹ hain⁴ a²teg⁴ on³ a³cúa²³ cúa³tag³² quian¹; i² a³júan³ ta¹ hain⁴ tionh² liah⁴, a⁴tyein³i³ a³hain⁴ ta⁴coh⁵ je¹ con³ma²a⁴júanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’I² a⁴juah⁴ a³quieh¹ je¹ hain⁴: “¿Liah⁴a² júah³ júan³²ˉ⁴? Eu⁴³a² re³ sain¹ˉ⁴ a³jon³⁴ a³eu⁴³ hno⁵ˉ⁵; jian³ canh⁴a² sa¹ li⁴ma⁵con⁴³i³ tei⁴³i² a⁴je³i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","I² a³júan³ ta¹ hain⁴ tionh², con³ma²a⁴jen³i³, jon³ a⁴júanh⁴i³ húan⁴i³ tionh², juah⁴i³: “A³ne³pa² li⁴quieh¹ je¹ la³. Ma³²ˉ¹ ma⁵jŋangh¹i³ jnia¹ canh⁴a² li⁴quian⁴ˉ¹ je¹ la³.” ");
INSERT INTO cucNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ma²jon³ a⁴tyein³i³ ta⁴coh⁵ je¹ jon³, jian³ a⁴jŋangh⁴i³. ’I² jon³ ne⁵, ¿henh⁴ júan³⁴ a³quieh¹ je¹ jon³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Quie¹ jionh⁴i³, ya⁴ma⁴tyan²³i³ a³júan³ ta¹ hain⁴, jon³ tonh³i³ je¹ quieh¹ joh⁴³ cúa³ a³sang²³ tionh². Con³ma²a⁴nau⁴i³ tionh² jau²³ ne³, jon³ a⁴juah⁴i³: ―¡Sa⁴ua²lei⁴ la⁴ne³! ");
INSERT INTO cucNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","I² jon³ a⁴je³⁴ Jesús, a⁴jen³i³ a³hain⁴ tionh², a⁴sagh⁴³i³: ―¿Henh⁴ hnie³⁴ ra³juah⁴ jau²³ i⁴ra³sag² ne⁵: A²caun² i⁴a⁴ton³⁴ teg³hyah³ tionh², a²caun² jon³pa² re³ a⁴seih³ ta³jmh¹ a²hnei⁴³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jian³ a³hain⁴ a³cangh³ nei² a²caun² jon³ jeun⁴i³ o¹leuh²; jian³ juah⁴ne³ sian³ a³neh³ a²caun² ne³, jon³ lain⁴i³ o¹jeu². ");
INSERT INTO cucNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","I² o²ra³ jon³ hnie³⁴ m³chie³ tyein² tionh² jian³ a²teg²³ quian¹ lai²³, hnie³⁴i³ sanh³i³ Jesús, quie¹ ra⁵laih²i³ tionh² i⁴a⁴hleh⁴ Jesús nei² quieh¹i³ jau²³ i⁴a⁴can³⁴i³ jon³; i² hei⁴i³ tionh² ne⁵, con⁴³i³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","I² jon³ a⁴sain⁴i³ meih³ chie³ quian¹ a³ma³jnia³ i⁴tsein³⁴, a³ua⁵quien²³ jau²chie⁴³ sa¹ si⁵seun³ Jesús jau²³, canh⁴a² sia³ liah⁴ li⁴cúanh⁴³i³ joh⁴³ cúa³ si²mah⁴ tyein². ");
INSERT INTO cucNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I² jon³ a⁴ŋang⁴i³ i²con²³ Jesús, a⁴juah⁴i³: ―Hnei³ A²teg²³, nia² jnie³² i⁴hleh³ˉ³ jian³ i⁴heh³ˉ³ jmah³ jau²³ ni²tei⁴³, jian³ co³nai² jenh⁵ˉ³ chie³ la⁴jang³⁴, quie¹ heh³ˉ³ jeu³ quieh¹ Jon⁴dai¹ con⁴juah⁴ jau²³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","I² ne³ ne⁵, ¿o⁴ ra³cúa²³ i⁴ma²hmah³²ˉ¹ hmah¹ i²tain⁴³ gobierno, jian³ o⁴ a⁵sia³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","I² Jesús ne⁵, si²laih²i³ re³ i⁴a⁴ŋang⁴ a³hain⁴ tionh² con⁴juah⁴ co³hei²tsei³ hlagh³², jon³ a⁴sagh⁴³i³: ―¿E⁴le³⁴ jau²chie⁴³ conh⁴ˉ³ jnia⁴ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","He³² hnei³ jnia⁴ con³ o¹cau³². I² jon³ ne⁵, ¿hain³ ma³nei² ne³ ra³ton³, jian³ hain³ jm³i⁴sain³ ra³sag²? I² jon³ a⁴ŋangh³i³ tionh², a⁴juah⁴i³: ―Gobierno César pa². ");
INSERT INTO cucNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Juah⁴ne³ la⁴ne³, cúah³² hnei³ gobierno i²tain⁴³, jian³ cúah³² hnei³ Jon⁴dai¹ i²tain⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","I² la⁴ne³ sa⁴a⁴cagh¹i³ jm² juah⁴ i⁴si⁵seun³ Jesús jau²³ i⁴si²hleh²i³ ta⁵nei² chie³, quie¹ co³ ŋo³⁴ tsei⁴³i³ tionh² jau²³ i⁴a⁴jainh³ Jesús, jon³ a⁴cauh³ lau²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ma²jon³ a⁴tyie³⁴ co⁴meih³ saduceo tionh², a³hain⁴ tionh² a³juah⁴ i⁴sa⁴hyon⁴³ a³jaun², a⁴ŋang⁴i³ i²con²³ Jesús, ");
INSERT INTO cucNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","juah⁴i³: ―Hnei³ A²teg²³, a⁴sag⁴ M³se²³ ma²jyi³ i⁴ra³hleh² la⁴la³: “Juah⁴ne³ a⁴jaun³⁴ jan³ a³ñih³ a³sa⁴ra⁵sian³ si³jon⁴³ jian²³ i³cúa³, jon³ hniah³ sanh⁴ a³reunh¹ a³jaun² jian²³ a³m⁴ hain⁴, canh⁴a² li⁴sian³ si³jon⁴³i³ nei² quieh¹ a³jaun² reunh¹i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","I² jon³ ne⁵, ma²sian³ quion³⁴ si³reunh¹i³ jmah³ a³ñih³. I² a³co⁴ra⁴lie⁵ hain⁴ a⁴sanh⁴i³ jian²³ a³m⁴ quian¹, jian³ a⁴jaun³⁴i³ i⁴sa⁴ra⁵sian³ si³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jian³ la⁴jon³ a⁴sanh⁴ a²teg⁴ on³⁴ liah⁴ jian²³ a³m⁴ hain⁴, jian³ a⁴jaun³⁴i³ i⁴sa⁴ra⁵sian³ si³jon⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jian³ la⁴jon³pa² liah⁴ a²teg⁴ on³, jian³ liah⁴a² a⁴teg⁴ li⁵quion³⁴i³, a⁴chian³⁴i³ tionh² i⁴sa⁴ra⁵sian³ jon⁴³segh³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jian³ i²a⁴toh⁴ a⁴jaun³⁴ a³m⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","I² jon³ ne⁵, tei⁴³i² hyon⁴³ la⁴jang³⁴ a³jaun², ¿hain³ li⁴quian¹ a³m⁴ hain⁴, quie¹ la⁴jang³⁴ la⁴jon³ pi²³ ra⁵jian²³i³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Quie¹ chie³ a³sian³ m⁵cu³ la³, a³ñih³ a³m⁴, sanh⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Quie¹ la⁴jang³⁴ a³haih¹ i⁴hyon⁴³ jen² a³jaun² jian³ i⁴tang³⁴i³ m⁵cu³ con³, a³ñih³ a³m⁴, i²jon³ a⁵sie⁴³ ma⁵sanh⁴i³, jian³ a⁵ga⁴ cúan⁵i³ si³jon⁴³ i⁴sanh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Quie¹ a⁵sie⁴³ ma⁵jaun⁴i³ i²jon³, quie¹ lang⁴³i³ liah⁴ lang⁴³ ángel jian³ lang⁴³i³ jon⁴³segh³² Jon⁴dai¹ quie¹ ta⁵la⁴ ma³a⁴hyon²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jian³ hña³ M³se²³ liah⁴ ma³jnia³i³ nei² quieh¹ i⁴hyon⁴³ a³jaun², con³ma²a⁴sag⁴i³ nei² quieh¹ sieh³² hma³ ton⁴³ tsain⁴³ ma²si²co²³, con³ma²a⁴teh³i³ Se³ño²³ Jon⁴dai¹, Jon⁴dai¹ quian¹ A³brang²³, Jon⁴dai¹ quian¹ I³sa²³ jian³ Jon⁴dai¹ quian¹ Ja³co²³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Quie¹ a⁵sia³ lang⁴³i³ Jon⁴dai¹ juah⁴ Jon⁴dai¹ quian¹ a³jaun², quie¹ Jon⁴dai¹ quian¹ a³sian³pa²; quie¹ i²con²³ hei⁴i³ sian³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","I² jon³ a⁴ŋangh³ co⁴meih³ a²teg²³ quian¹ lai²³, a⁴juah⁴i³: ―Hnei³ A²teg²³, ta² re³ a⁴hleh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","I⁴jon³ a⁵sie⁴³ tia⁴ tsei⁴³i³ ma⁵ŋang³⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","I² jon³ a⁴ŋang⁴ Jesús i²con²³i³ tionh²: ―¿Liah⁴ cúan²³ juah⁴ chie³ tionh² i⁴lang⁴³ A³ma²ya⁴lion³² Chie³ hain⁴ sa¹jeun³ re¹ Da³vei²³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","I² hña³pa² Da³vei²³ a⁴hleh⁴ nei² ma²jyi³ quieh¹ Salmo i⁴ra³juah⁴: A⁴juah⁴ Se³ño²³ Jon⁴dai¹ i²con²³ Se³ño²³ quian³⁴ˉ⁴: “Nei⁴ hnei³ jo³² ta⁵chie³⁴ quien⁴ˉ⁴ ");
INSERT INTO cucNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","la⁴conh⁴i² júan³²ˉ⁴ i⁴cangh³²ˉ³ jm² i²con²³ la⁴jang³⁴ a³hie²³ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","I² la⁴ne³ hña³pa² Da³vei²³ hleh² i⁴lang⁴³ a³hain⁴ Se³ño²³ quian¹i³; ¿liah⁴ cúan²³ lang⁴³ A³ma²ya⁴lion³² Chie³ hain⁴ sa¹jeun³ quian¹i³ juah⁴ne³ la⁴jon³? ");
INSERT INTO cucNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","La⁴jang³⁴ a³jeu³ hain⁴ tionh² ti²nau³ con³ma²a⁴sagh⁴³ Jesús chie³ quian¹, juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Jianh³ˉ³ júan² hnei³ tionh²ˉ³ i²con²³ a²teg²³ quian¹ lai²³, quie¹ si³hyonh³i³ ŋeng²³i³ i⁴tionh²i³ a²hmh³ cúa³ la⁴conh⁴a² a³sang²³, jian³ hnie³⁴i³ ma⁵co⁴³ chie³ quieh¹i³ je¹hmah¹, jian³ si³hyonh³i³ cua²³i³ hien²³ a³tyein² cuah³ judío, jian³ cua²³i³ queuh³i³ a²hei⁴³ hien²³ a³canh² i²júan³i³ jm². ");
INSERT INTO cucNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jian³ qui²³i³ jauh³² quieh¹ a³don⁵ m⁴ hnang⁴, jian³ júan³i³ i⁴mh²i³ Jon⁴dai¹ i⁴úa⁴ i⁴ma³can³i³ chie³. I⁴jon³ hyieh⁴i³ ma²eu⁴³ pain⁴ la⁴conh⁴a² la⁴jang³⁴ la⁴teg⁴i² gmh⁴ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jon³ a⁴je³⁴ Jesús i⁴ti²ro³ a³jlanh² o¹cau³² joh⁴³ a²cúa⁴³ i²tonh²i³ o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jian³ a⁴jen³i³ jan³ a³don⁵ m⁴ hnang⁴ a³eu⁴³ ti⁴ñei³ a³a⁴tonh³ teun³⁴ a²ñi²yein⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³m⁴ hnang⁴ a³ti⁴ñei³ ne³, hlion⁴ pi¹ a⁴cúa⁴i³ la⁴conh⁴a² la⁴jang³⁴ a³ma³a⁴ro⁴ joh⁴³ a²cúa⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Quie¹ la⁴jang³⁴ a³hain⁴ tionh² a⁴cúa⁴i³ o¹cau³² i²con²³ Jon⁴dai¹ i⁴ni²sion⁴pa²; i² a³m⁴ ne³ ne⁵, ua²liah⁴a² eu⁴³ ti⁴ñei³i³, a⁴cúa⁴i³ la⁴jeg³⁴ la⁴conh⁴ ma²sia³ quieh¹i³ i⁴ma²queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma²ti²tya²³ co⁴meih³ chie³ jau²³ nei² quieh¹ cuah³júah² i⁴eu⁴³ tsei³⁴ jnia⁴ si²leg⁴³ la⁴jeg³⁴ a²caun² i⁴tieh³² jian³ la⁴jeg³⁴ i⁴a⁴cúa⁴ chie³ tionh², jon³ a⁴juah⁴ Jesús: ");
INSERT INTO cucNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―La⁴conh⁴ tei⁴³ i⁴ti²jeh⁴ˉ³ ne³ tionh²ˉ³ tieh²la³, jia²³ jm² i⁴si⁵cúan⁴, i¹con³ a²caun² a⁵sie⁴³ ni²tsei¹ nei² a²caun² reunh¹ lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","I² jon³ a⁴ŋang⁴i³ tionh² i²con²³ Jesús: ―Hnei³ A²teg²³, ¿legh⁴ si⁵lei⁴ la⁴jeg³⁴ i⁴ne³? ¿Jian³ henh⁴ júan³⁴ lei³ la⁴teg⁴i² ma³o¹lei⁴ la⁴jeg³⁴ i⁴ne³? ");
INSERT INTO cucNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I² jon³ a⁴juah⁴ Jesús: ―Jianh³ˉ³ júan² hnei³ yo⁴ua²lainh²ˉ³ ca³ tionh²ˉ³; quie¹ jeun⁴³ jia²³ con⁴juah⁴ jm³i⁴sain³⁴ jnia⁴, i⁴juah⁴i³: “Jnia⁴pa² lang⁴³ A³lion³ Chie³ hain⁴”, jian³ “Ma³a⁴tyie³⁴pa² jm² jon³ tieh²la³.” Jian³ sa⁴hniah³ cúah²ˉ³ coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","I² tei⁴³i² a⁴naih³ˉ³ jau²³ i⁴ma³si³tang⁴ nación, jian³ i⁴ma³ra⁴hang³² a³jeu³ conh⁴ con³ jeu³, a⁵júan³ hnei³ canh⁴³; quie¹ ton³²nie⁴³ hniah³ si⁵lei⁴ i⁴ne³ ñeih³², i² si³hain⁴ pi¹ i²tieh⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jian³ a⁴juah⁴i³ liah⁴: ―Quie¹ júan³⁴ con³ nación hnai³ i²con²³ nación seg³⁴, jian³ júan³⁴ re¹ hnai³ i²con²³ re¹ sang³⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jian³ qui³⁴ húa³⁴ i⁴tia⁴, jian³ jia²³ ho³²cúan⁴ jian³ chie² pain⁴ ma⁵quein²³ jeu³, jian³ lei⁴ ua³júah² pain⁴ i⁴co³ jia²³ ta⁵ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’I² naih⁵i² lei⁴ la⁴jeg³⁴ i⁴ne³ ne⁵, sonh³i³ hnei³ tionh²ˉ³, jian³ hag³⁴i³ hnei³, jian³ si⁵jo⁴i³ hnei³ cuah³ judío i²queih³i³ heih⁴³ i²conh²ˉ³, jian³ tonh⁴³i³ hnei³ ni⁴ñi²³, jian³ si⁵jo⁴i³ hnei³ ta⁵nei² re¹ jian³ ta⁵nei² si²mah⁴ tyein² liah⁴ nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","I² la⁴ne³ cúa³⁴ jm² i⁴hleh²ˉ³ nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Jian³ sa⁴hniah³ júanh²ˉ³ la⁴la³ juah⁴ i⁴júanh²ˉ³ co³hei²tsei³ ñeih³² henh⁴ jau²³ hniah³ jainh²ˉ³, ");
INSERT INTO cucNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","quie¹ jnia⁴pa² cúa¹ jau²³ jian³ i⁴ŋangh⁴ˉ³ re³ i⁴sa⁴cagh¹ a³hie²³ hnei³ jm² juah⁴ i⁴li⁴juah⁴i³ i⁴sa⁴chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jian³ naih⁴³sieh³ˉ³, si³reunh³ˉ³, a³tei⁴³ jau²³ quianh³ˉ³ jian³ ñi³reunh³ˉ³, cúah⁴³i³ hnei³ i²con²³ si³ta¹; jian³ jŋangh³i³ hnei³ ca³chion²³, ");
INSERT INTO cucNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","jian³ la⁴jang³⁴ chie³ li⁴hie²³ hnei³ nei² quien⁴ˉ⁴; ");
INSERT INTO cucNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","jian³ i¹con³ hmh⁴ o¹tyih³ˉ³ sa⁴si⁵hain⁴ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Quie¹ con⁴juah⁴ i⁴júanh³ hoh⁴³ˉ³, lion⁴ m⁴tyi⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’I² tei⁴³i² jeh²ˉ³ Jerusalén i⁴ma³ti²lagh⁵ a²hlie⁴ tionh², jon³ ma³ñih¹ˉ³ i⁴ma³a⁴tyie³⁴ jm² i⁴si⁵cúan⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jian³ la⁴jang³⁴ a³tionh² húa³⁴ Judea tei⁴³i² jon³, hniah³ cm³⁴i³ ta⁵mah⁴; jian³ la⁴jang³⁴ a³tionh² Jerusalén jon³, hniah³ húan⁵i³, jian³ a³hain⁴ a³tionh² i²nau³, sa⁴hniah³ tyanh¹i³ je¹jeu³ tei⁴³i² jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Quie¹ jm² jon³ jm² he³⁴ Jon⁴dai¹ ma²eu⁴³ pain⁴, canh⁴a² li⁴tei⁴³ la⁴jeg³⁴ jau²³ i⁴ti²sag² ma²jyi³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jian³ a³m⁴ a³ti²chieh¹ tei⁴³i² jon³, ¡ti⁴³ jeu²³i³ jian³ a³ti²jian³ yein³ teih⁴ liah⁴! Quie¹ eu⁴³ pain⁴ jainh⁴³ chie³ húa³⁴ la³ jian³ ma²eu⁴³ i⁴hyei³⁴ a³jeu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Quie¹ tyan⁴³ ca³chion²³ jeu³ a²ñi²tag⁴, jian³ ca³chion²³ te⁴³i³ chion³² la⁴jeg³⁴ jeu³; jian³ han⁵ chie³ sang²³ Jerusalén la³ i⁴júan³⁴i³ heih⁴³ liah⁴a² a⁴tyie³⁴ jm² i⁴hei¹ heih⁴³ i⁴lei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Jian³ jm² jon³ lei⁴ lei³ hyie³, jian³ segh³ jian³ jah⁴nai⁴³ liah⁴, jian³ nei² cuah³²húa³⁴ la³ liah⁴ yi⁵hang³² chie³ tionh², so⁵ñi³i³ henh⁴ sian³i³ nei² quieh¹ i⁴tia⁴ hain³² jm³ñih¹ hlan³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jian³ coh⁴³i³ ma³li⁴jaun⁴i³ nei² quieh¹ i⁴júan³i³ co³hei²tsei³ la⁴jeg³⁴ i⁴lei⁴ m⁵cu³; quie¹ jai⁴³ i⁴sia³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","I² jon³ jen⁴³ chie³ tionh² A³a⁴lang³⁴ Chie³ hain⁴ jionh⁴ jeu³ je¹ o¹jnai⁴³ i⁴quian³i³ ua³pei⁴ jian³ i⁴eu⁴³ júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","La⁴teg⁴i² ma³ra⁴lie⁵ si³lei⁴ la⁴jeg³⁴ i⁴ne³, júan² hnei³ si³hyonh³ˉ³ tionh²ˉ³, jian³ je¹ hnei³ ta⁵yeih³², quie¹ ma³hloh³² lionh⁴ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jian³ a⁴can³⁴ Jesús con³ jau²³ liah⁴, juah⁴i³: ―¿Sa¹ jeh⁴ˉ³ a²hma³ m⁴jyi³ jian³ o⁴ hain³ a²hma³ seg³⁴ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","La⁴teg⁴i² ma³hyie²³ o¹úan³² quieh¹, jon³ ñih¹ˉ³ i⁴ma³o¹teg³⁴ jain³ jm⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Conh⁴liah⁴ la⁴ne³ hnei³ tionh²ˉ³ liah⁴, tei⁴³i² jeh⁴ˉ³ si³lei⁴ la⁴jeg³⁴ i⁴ne³, jon³ ñih¹ˉ³ i⁴ma³o¹teg³⁴ i⁴júan³⁴ Jon⁴dai¹ heih⁴³ nei² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, si⁵lei⁴ la⁴jeg³⁴ i⁴ne³ naih⁵i² tyan⁴³ chie³ a³sian³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Si⁵hain⁴ ñi⁴jeu⁵ jian³ cuah³²húa³⁴, i² jau²³ quien⁴ˉ⁴ ne⁵, liah⁴ma³li⁴tei⁴³pa². ");
INSERT INTO cucNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Jianh³ˉ³ júan² hnei³ tionh²ˉ³, canh⁴a² sa⁴li⁴huah³ m⁴tyi⁴ quianh³ˉ³ nei² quieh¹ i⁴jlenh⁴ˉ³ tionh²ˉ³ jian³ o⁴ i⁴hauh⁴ˉ³ o¹jm³ma⁴tyei⁴ jian³ nei² quieh¹ i⁴sianh³ˉ³ jeu³ la⁴jeg³⁴ i⁴sia³ m⁵cu³ la³, canh⁴a² sa⁴jia²³ jm² i⁴nioh²ˉ⁵ la⁴conh⁴ sa⁴jianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Quie¹ jia²³ jm² jon³ liah⁴i² tiah² con³ a²lia⁴ i²con²³ la⁴jang³⁴ a³tionh² cuah³²húa³⁴ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","I⁴jon³ ua²tionh²ˉ³ tionh²ˉ³ i⁴ti²naih²ˉ³ jian³ i⁴ti²mh⁵ˉ³ Jon⁴dai¹ la⁴jeg³⁴ nie⁴³, canh⁴a² haih¹ li⁴lionh⁴ˉ³ la⁴jeg³⁴ i⁴jia²³ jon³ jian³ i⁴ma²jniah³²ˉ³ ta⁵nei² A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jian³ he²³ Jesús i⁴jm²³ i²con²³ chie³ cuah³júah², jian³ je¹nai³ si³hag⁴³i³, chie²³i³ mah⁴ quieh¹ a²hma³ Olivos si³jian³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jian³ si³han² la⁴jang³⁴ a³jeu³ cuah³júah² la⁴jeg³⁴ hie³ a³si³nai³ jau²³ quieh¹ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ma³hloh³² jm² i⁴queuh³i³ a²hei⁴³ñih¹ i⁴sa⁴hei¹ o¹sieh³², jm² i⁴teh²i³ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","I² m³chie³ tyein² tionh² jian³ a²teg²³ quian¹ lai²³ hnoh³i³ hain³liah⁴ li⁴jŋangh³i³ Jesús i⁴sa⁴lei³, quie¹ con⁴³i³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","I² jon³ a⁴hei³⁴ a³sa⁴tsein³⁴ naih⁵ ni²tsei⁴³ Judas, a³hain⁴ a³ni²tsei¹ jm³i⁴sain³ Iscariote, a³hain⁴ a³hein² jen² a³quia⁵teun⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jon³ ŋo³⁴ a³ne³ ua⁵jen³²i³ m³chie³ tyein² tionh² jian³ la⁴jang³⁴ jeu³² po³li³sei¹ quian¹ cuah³júah², hain³liah⁴ li⁴cúanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","I² hei⁴i³ tionh² ne⁵, ta² si³hyonh³i³ a⁴leg³⁴, jian³ a⁴tyie³⁴i³ con³ jau²³ re³ i⁴cúah³i³ Judas o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I² Judas ne⁵, a⁴hyein⁴³i³, jon³ a⁴hnoh³i³ liah⁴ li⁴tag³⁴ i⁴li⁴cúanh⁴³i³ Jesús i⁴sa⁴li⁴laih² a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","I² jon³ ne⁵, a⁴tyie³⁴ jm² i⁴queuh³i³ a²hei⁴³ñih¹ i⁴sa⁴hei¹ o¹sieh³², jm² i⁴hniah³ jŋangh³i³ a⁵a³siah³ a³caunh⁴³i³ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jon³ a⁴sain⁴ Jesús Pe³² jian²³ Juan²³, a⁴sagh⁴³i³: ―Cua³ yi⁴júanh²ˉ³ re³ ma³⁴ quieh¹ jm² la³ tionh²ˉ³ canh⁴a² quih³²ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―¿Jainh¹ hnoh³ˉ³ si²júan²³ jnie³² ma³⁴ jon³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jon³ a⁴sagh⁴³i³ a³hain⁴: ―Quie¹ tei⁴³i² a⁴hanh⁵ˉ³ je¹jeu³, i²jon³ jainh⁴³ˉ³ jan³ a³ñih³ a³quian³ con³ a²tsai³² tieh³² o¹jm³, jon³ si²tyeinh³²ˉ³ coh⁵cah³²i³ la⁴teg⁴ jauh³² i²tyanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","I² jon³ jeuh³²ˉ³ a³quieh¹ jauh³² hain⁴: “La⁴la³ juah⁴ A²teg²³: ¿Hain³ jauh³² i²leg⁴³ yeih³² queuh⁴³i³ ma³⁴ quieh¹ jm² la³ jian²³i³ chie³ quian¹? juah⁴i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I² jon³ he³⁴i³ hnei³ tionh²ˉ³ con³ jauh³² júah³ i²leg⁴³ yeih³² i⁴ma³si²leg⁴³ re³; i² jon³ júanh²ˉ³ i⁴quih³²ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jon³ ua⁵han² li⁵uan⁴ a³hain⁴ tionh², jian³ a⁴je³⁴i³ i⁴ra⁵tei⁴³ la⁴jeg³⁴ la⁴conh⁴ ma²a⁴juah⁴ Se³ño²³, i² jon³ a⁴júan⁴i³ ma³⁴ quieh¹ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","I² con³ma²a⁴tyie³⁴ o²ra³ quieh¹, jon³ a⁴han⁵ Jesús mesa jian²³ la⁴jang³⁴ a³quian³ ta¹ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jian³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―¡Chie⁴³pa² ta² ma²hno⁵ˉ⁵ queuh¹ˉ⁴ jian²³ˉ⁵ hnei³ tionh²ˉ³ ma³⁴ quieh¹ jm² la³ naih⁵i² jaun⁴ˉ⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ i⁴a⁵sie⁴³ queuh¹ˉ⁴ ma³⁴ la³ naih⁵i² sa⁴tyie²³ jm² júan³⁴ Jon⁴dai¹ heih⁴³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jon³ a⁴tang⁴ Jesús a²va²so³ tieh³² o¹bein², a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, jian³ a⁴juah⁴i³: ―Janh³ i⁴la³ tionh²ˉ³, hainh⁴ la⁴jangh³ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a⁵sie⁴³ ma⁵lauh³²ˉ⁴ o¹bein² quieh¹ o¹m⁴ ya¹gm³jeh² naih⁵i² sa⁴tyie²³ jm² júan³⁴ Jon⁴dai¹ heih⁴³ nei² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jon³ a⁴tang⁴ Jesús a²hei⁴³ñih¹ liah⁴, a⁴cúah³i³ Jon⁴dai¹ ti²hmah³², a⁴jeun³⁴i³, jian³ a⁴cúah³i³ a³hain⁴ tionh², a⁴juah⁴i³: ―A²hei⁴³ñih¹ la³ leg⁴³ he³⁴ˉ⁴ i⁴jon³ i⁴cúanh³²ˉ⁴ i⁴jaun⁴ˉ⁴ nei² quianh³ˉ³ tionh²ˉ³; júanh¹ hnei³ i⁴la³ i⁴tyon²³ hoh⁴³ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Conh⁴liah⁴ la⁴jon³, con³ma²a⁴toh⁴ a⁴queuh³i³ a²hei⁴³, a⁴tang⁴ Jesús a²va²so³ o¹bein², a⁴juah⁴i³: ―O¹bein² tieh³² a²va²so³ la³ ra³he²³ i⁴lei⁴ re³ con³ jau²³ hm³⁴ con⁴juah⁴ jm³yein⁴ quien⁴ˉ⁴, i⁴tain³⁴ nei² quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’I² a³cúah⁴³ jnia⁴ ne⁵, a³ua²queuh³ nei² mesa la³pa² jian²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Quie¹ i⁴chie⁴³pa² hniah³ lei⁴ i²con²³ A³a⁴lang³⁴ Chie³ hain⁴ liah⁴i² ra³hei¹ heih⁴³ lei⁴, i² a³cúah⁴³ quieh¹i³ ne⁵, ¡ti⁴³ jeu²³ a³hain⁴! ");
INSERT INTO cucNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","I² jon³ a⁴júanh⁴ chie³ quian¹i³ húan⁴ tionh² hain³ pi² hain⁴ a³cúah⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jon³ a⁴jang²³ chie³ quian¹ Jesús húan⁴ tionh² nei² quieh¹ hain³ tyein² jen²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","I² a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Quie¹ la⁴jeg³⁴ nación i²tionh² chie³ sang²³, pain⁴ heih⁴³ júan³ gobierno quian¹i³ i²con²³i³ tionh², jian³ a³ti²quian³ heih⁴³ pain⁴, teh²i³ a³júan³ i⁴tsei³⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","I² jenh²ˉ³ tionh²ˉ³ ne⁵, sa⁴hniah³ lei⁴ la⁴ne³; a³hain⁴ a³tyein² jenh²ˉ³ tionh²ˉ³, hniah³ júan⁵i³ la⁴jan³ a³peih¹ la⁴conh⁴a² la⁴jang³⁴, jian³ a³hain⁴ a³quian³ ma³tyi², hniah³ júan⁵i³ la⁴jan³ a³cúa²³ cúa³tag³² i²conh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Júan³²ˉ¹, ¿hain³ a³tyein² lainh⁴ˉ³, o⁴ a³ua²cua⁴³ mesa jian³ o⁴ a³si²tya²³ ma³⁴? ¿O⁴ a⁵hei⁴³ a³ua²hein² mesa, lainh⁴ˉ³? I² jnia⁴ ne⁵, hein³²ˉ⁴ jenh²ˉ³ tionh²ˉ³ la⁴jan³ a³cúa²³ cúa³tag³². ");
INSERT INTO cucNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Jian³ hnei³pa² tionh²ˉ³ liah⁴, ma³a⁴cúah³²ˉ³ hoh⁴³ jianh²ˉ³ jnia⁴ la⁴jeg³⁴ ma²eu⁴³ ma³a⁴can³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","I⁴jon³ cúa¹ˉ⁴ con³ i²júanh²ˉ³ heih⁴³ la⁴jon³ liah⁴i² a⁴cúa⁴ Neih³ˉ⁴ i²con²³ jnia⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","jian³ canh⁴a² queuh²ˉ³ hauh²ˉ³ nei² mesa quien⁴ˉ⁴ tei⁴³i² júan¹ˉ⁴ heih⁴³, jian³ neih²ˉ³ tionh² a²ma³sei² jlanh² i²júanh²ˉ³ heih⁴³ i²con²³ quia⁵teun⁴ sa¹jeun³ Israel. ");
INSERT INTO cucNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Conh⁴liah⁴ a⁴juah⁴ Se³ño²³ liah⁴: ―Hnei³ Si²úan¹ Pe³², jeh³², ma³a⁴m⁴³ hnei³ a³sa⁴tsein³⁴ tionh²ˉ³ i⁴con⁴³i³ jau²chie⁴³ i²conh²ˉ³, liah⁴i² jua²³i³ o¹m⁴ trigo; ");
INSERT INTO cucNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","i² jnia⁴ ne⁵, ma³a⁴mh⁵ˉ⁵ Neih³ˉ⁴ nei² quianh³ˉ³ canh⁴a² sa⁴jlianh³²ˉ³ i⁴hainh⁴ˉ³. Jian³ hnei³ liah⁴ tei⁴³i² ma³a⁴tainh³²ˉ³ hoh⁴³ nei² quien⁴ˉ⁴, jon³ hniah³ ma²huanh³²ˉ³ si³reunh³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","I² a⁴juah⁴i³ ne⁵: ―Hnei³ Se³ño²³, sainh⁴³ re³pa² jnia⁴ nai³²ˉ⁴ jian²³ˉ⁵ hnei³ ni⁴ñi²³ jian³ jaun⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","I² a⁴juah⁴ Jesús ne⁵: ―Hnei³ Pe³², jeu³⁴ˉ⁴ hnei³ i⁴naih⁵i² hoh⁵ a¹hyie²³, jlianh³²ˉ³ i⁴juah²ˉ³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ hnang²³ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―Con³ma²a⁴sain³⁴ˉ⁴ hnei³ i⁴sa⁴quianh¹ˉ³ a²mo³ra², jian³ a²to³hmh³ quieh¹ o¹cau³², jian³ a²lo³ tsei²³ tagh¹ˉ³, ¿o⁴ sia³ i⁴ra⁵hniah³ i²conh²ˉ³ tionh²ˉ³, lainh⁴ˉ³? Jon³ a⁴juah⁴i³ tionh²: ―I¹con³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jian³ a⁴juah⁴i³ liah⁴: ―I² tieh²la³ ne⁵, a³hain⁴ a³ra³quia³ a²mo³ra² quieh¹, hniah³ can³⁴i³, jian³ a²to³hmh³ quieh¹ o¹cau³², hniah³ can³⁴i³; jian³ a³hain⁴ a³sa⁴sia³ a²ñi²tag⁴ quieh¹, ua²hnang⁴i³ a²cúan³ canh⁴a² li⁴la³⁴i³ a²ñi²tag⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quie¹ jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ i⁴hniah³ li⁴tei⁴³ ton³²nie⁴³ i²con²³ jnia⁴ la⁴jeg³⁴ i⁴ra³sag² ra³juah⁴: “Je⁴³i³ jnia⁴ i⁴ren³⁴ˉ⁴ chie³² co³nai² jian²³ˉ⁵ chie³ hlangh².” Quie¹ la⁴jeg³⁴ i⁴ra³sag² nei² quien⁴ˉ⁴, hniah³ li⁴tei⁴³ ton³²nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jon³ a⁴juah⁴i³ tionh²: ―Hnei³ Se³ño²³, i²la³ ra³quia³ teun³⁴ a²ñi²tag⁴. I² a⁴juah⁴i³ ne⁵: ―Ua²leg⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jon³ ua⁵hag⁴³ Jesús, ŋo³⁴i³ mah⁴ quieh¹ a²hma³ Olivos i²ma³tang²³i³ chie²³i³; jian³ ua⁵han² chie³ quian¹i³ coh⁵cah³²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","I² con³ma²a⁴tyie³⁴i³ i²jon³, jon³ a⁴sagh⁴³i³ chie³ quian¹: ―Mh³² hnei³ Jon⁴dai¹ tionh²ˉ³ canh⁴a² sa⁴tianh⁵ˉ³ tei⁴³i² jia²³ jau²chie⁴³ i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I² hei⁴i³ ne⁵, ŋo³⁴ pi¹i³ meih³ ta⁵co⁴³ i²tionh² a³hain⁴ tionh² la⁴conh⁴i² tei⁴³ con³ i²ton²³i³ m⁴caun², i² jon³ a⁴si⁴jnei⁵i³, a⁴mh³i³ Jon⁴dai¹, ");
INSERT INTO cucNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","juah⁴i³: ―Hnei³ Neih³ˉ⁴, a¹juah⁴ hnoh³ˉ³ li⁴quih³²ˉ³ ma²eu⁴³ pain⁴ i⁴jia²³ i²con²³ˉ⁵; i² ua²lei⁴ liah⁴ hnoh³ hnei³, a⁵jon⁴³ liah⁴ hno⁵ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","I² jon³ a⁴ma⁴jnia³² jan³ ángel quian¹ ñi⁴jeu⁵ a³ma⁴ho³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jian³ ta² hlion⁴ ma²eu⁴³ si²can²³i³, jian³ tsei³⁴sa² a⁴mh³i³ Jmai³ jang³⁴ tsei⁴³i³, jon³ a⁴jan⁵i³ jm³tyie³² cah² la⁴con³ jm³yein⁴, tain²³ teg⁴ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jon³ a⁴no³i³ con³ma²a⁴toh⁴ a⁴mh³i³ Jon⁴dai¹, jonh²i³ i²tionh² chie³ quian¹i³, jon³ a⁴jen³i³ i⁴ti²cm²i³ nei² quieh¹ i⁴chionh⁴ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jon³ a⁴sagh⁴³i³: ―¿Henh⁴le³⁴ ti²cmh²ˉ³ tionh²ˉ³? No³ hnei³, mh³² hnei³ Jon⁴dai¹ canh⁴a² sa⁴tianh⁵ˉ³ tei⁴³i² jia²³ jau²chie⁴³ i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","I² ma²si²hleh² pi¹ Jesús, con³ a⁴la³ a⁴tyie³⁴ jeun⁴³ chie³; i² a³hain⁴ a³teh²i³ Judas, a³lang⁴³ jan³ a³hein² jen² quia⁵teun⁴ chie³ quian¹i³, ya¹jian⁴³i³ nei² jian²³ a³hain⁴ tionh², jon³ a⁴tyie³⁴i³ teg⁴ hlonh² Jesús canh⁴a² seinh³i³ nei² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Judas, ¿o⁴ con³ i⁴seinh²ˉ³ nei²pa² hnei³ A³a⁴lang³⁴ Chie³ hain⁴ i⁴cúanh³²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","I² con³ma²a⁴je³⁴ la⁴jang³⁴ a³jian²³ Jesús i⁴si³lei⁴ jon³, jon³ a⁴juah⁴i³: ―Hnei³ Se³ño²³, ¿o⁴ ma²tyan²³ jnie³² a³ne³ jeu³ a²ñi²tag⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I² jan³ chie³ quian¹ Jesús hain⁴, a⁴júanh¹i³ a³cúa²³ cúa³tag³² i²con²³ jeu³² m³chie³ tyein², a⁴queih³i³ ta³ra³cua¹i³ jo³² ta⁵chie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","I² Jesús a⁴juah⁴i³: ―A⁵conh⁴³, ua²leg⁴³. I² jon³ a⁴tei³⁴ Jesús si¹cúa³ ta³ra³cua¹ a³hain⁴, a⁴júan⁴i³ i⁴a⁴huan⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","I² jon³ a⁴juah⁴ Jesús i²con²³ m³chie³ tyein² jian³ jeu³² po³li³sei¹ quian¹ cuah³júah² jian³ a³don⁵ ma⁴³teg²³ tionh² a³a⁵han² i⁴sonh³ quieh¹i³, a⁴sagh⁴³i³: ―¿O⁴ a⁴niah³ˉ³ tionh²ˉ³ i⁴jmah³²ˉ³ jnia⁴ ti²quianh²ˉ³ a²ñi²tag⁴ jian³ a²hma³, liah⁴i² sanh²i³ hang³? ");
INSERT INTO cucNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Quie¹ la⁴jeg³⁴ jm² ma²hein³²ˉ⁴ jenh²ˉ³ tionh²ˉ³ cuah³júah², jian³ sa⁴a⁴sienh²ˉ³ jnia⁴; i² ne⁵pi¹ a⁴tyie³⁴ jm² quianh³ˉ³ tionh²ˉ³, jian³ i⁴cagh¹ jm² heih⁴³ quieh¹ i²naih³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","I² con³ma²a⁴sanh³i³ Jesús, jon³ ni²jan³i³ teg⁴ jauh³² quieh¹ jeu³² m³chie³; jian³ Pe³² ya¹tyein¹ coh⁵ i²ma³gm⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jon³ a⁴tya⁴ a³hain⁴ o¹jyi³ tionh² to⁵chieh³² coh⁵hnei³² jon³, jian³ a⁴cua⁴i³ co⁴la⁴lagh⁵ tionh²; jian³ a⁴cua⁴ Pe³² liah⁴ jen²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","I² jan³ a³m⁴ a³júan³ ta¹ jauh³², con³ma²a⁴je³⁴i³ i⁴ua²cua⁴³ Pe³² hloh³² jyi³, tsei³⁴sa² tia⁴ a⁴je³i³, a⁴juah⁴i³: ―Jeh³², a³ne³pa² ma²jian²³ a³jno³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","I² Pe³² ne⁵, a⁴jlian³⁴i³, a⁴juah⁴i³: ―Hnei³ a³m⁴, sa⁴cm⁴³i³ jnia⁴, nah². ");
INSERT INTO cucNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","I² con³ma²ma³co⁴le⁴ jon³, a⁴je³ a³sang²³ quieh¹i³, a⁴juah⁴i³: ―Hnei³ liah⁴, langh⁴³ chie³ quian¹i³ tionh². I² a⁴juah⁴ Pe³²: ―A⁵sia³, a⁵hei⁴³ jnia⁴ a³hain⁴, a³don⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I² con³ma²ua⁴jeu³² la⁴conh⁴ con³ o²ra³ liah⁴, jon³ ma⁴chie⁴³i³ i²jan³, juah⁴i³: ―I⁴chie⁴³pa² ne³ liah⁴, a³ne³ ma²jian²³ hei⁴i³, quie¹ sian³i³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","I² a⁴juah⁴ Pe³² liah⁴: ―Hnei³ chie³, sa⁴yan³²ˉ⁴ henh⁴ hleh³ˉ³. I² liah⁴ma²jon³, to⁵si²hleh² pi¹ Pe³², con³ a⁴la³ a⁴hoh⁵ a¹hyie²³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","I² jon³ ne⁵, ua⁵lang⁴ Se³ño²³, a⁴jen³i³ Pe³²; i² jon³ a⁴tyon²³ tsei⁴³ Pe³² jau²³ i⁴ma³a⁴hleh⁴ Se³ño²³ i²con²³i³, i⁴juah⁴i³: “Naih⁵i² hoh⁵ a¹hyie²³, jlianh³²ˉ³ i⁴juah²ˉ³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ hnang²³ nie⁴³.” ");
INSERT INTO cucNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","I² Pe³² ne⁵, ua⁵hag⁴³i³ coh⁵hnei³², a⁴hoh⁵i³ i⁴hei¹ queuh³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","La⁴jang³⁴ a³ti²hie⁴³ quieh¹ Jesús a⁴ji⁴ŋang⁴ quieh¹i³ jian³ a⁴pan³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jian³ a⁴hñei⁴i³ con³ a²hmh³ ma³nei²i³, con³ma²a⁴leg³⁴ jon³, a⁴quein³⁴i³ jian³ ti²ŋangh²i³, juah⁴i³: ―¡Tyi² hnei³ con³ jau²³ hain³ a⁴quein⁴ ma³mah²ˉ³! ");
INSERT INTO cucNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jian³ hlion⁴ pi¹ jau²hlagh³² a⁴sagh⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","I² con³ma²a⁴jnia³⁴, jon³ a⁴ŋangh³ la⁴jang³⁴ a³don⁵ ma⁴³teg²³ quian¹ a³jeu³, jian³ m³chie³ tyein² tionh² jian³ la⁴jang³⁴ a²teg²³ quian¹ lai²³, ma²jon³ jian³i³ Jesús ta⁵nei² la⁴jang³⁴ si³ta¹ jon³, a⁴ŋangh³i³: ");
INSERT INTO cucNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Jeh³², ¿o⁴ langh⁴³ˉ³ A³ya⁴lion³² Chie³ hain⁴? Sai³² hnei³ jnie³². I² jon³ a⁴ŋangh³ Jesús: ―Juah⁴ne³ juah¹ˉ⁴, jnia⁴pa², a⁵sia³ ua²li⁴hainh⁴ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jian³ juah⁴ne³ ŋang¹ˉ⁴ i²conh²ˉ³ tionh²ˉ³ liah⁴, a⁵sia³ jau²³ ua²jainh²ˉ³, jian³ a⁵ga⁴ lieh³²ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","I² jon³ ne⁵, ne⁵a² a⁴teg⁴ jm² si⁵cua³ A³a⁴lang³⁴ Chie³ hain⁴ jo³² ta⁵chie³⁴ quieh¹ Jon⁴dai¹ a³li⁴júan³⁴ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","I² jon³ a⁴ŋang⁴ la⁴jang³⁴: ―¿I² la⁴ne³ jon³ hnei³pa² li⁴ langh⁴³ A³jon⁴³ Jon⁴dai¹, heh⁵ˉ³? I² jon³ a⁴ŋangh³ Jesús: ―Húanh⁴³pa² hnei³ tionh²ˉ³ juah⁴ˉ³ i⁴lang⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","I² jon³ a⁴júanh⁴i³ tionh²: ―¿Hain³a² ma⁵hniah³ a³hnang⁵ quieh¹i³ ton³²nie⁴³? Quie¹ húan⁴pa² jnia¹ ma³a⁴nai²ˉ¹ jau²³ ho³²i³ hña³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","I² jon³ ne⁵, ra⁴hang³² la⁴jang³⁴ si³ta¹ hain⁴ tionh², jian³i³ Jesús ta⁵nei² Pilato si²mah⁴ tyein². ");
INSERT INTO cucNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","I² jon³ ma⁴lie⁵ a³hain⁴ tionh², a⁴hnang⁴³i³ Jesús, a⁴juah⁴i³: ―Ra⁵nia² jnie³² nei² quieh¹ a³ne³ i⁴sion⁴³i³ a³jeu³, quie¹ hnia²³i³ i⁴ma³hmah³² chie³ hmah¹ i²tain⁴³ gobierno, jian³ juah⁴i³ hei⁴i³ hña³ pi²³i³ lang⁴³ A³ya⁴lion³² Chie³ hain⁴, hnie³⁴ ra³juah⁴, jan³ re¹. ");
INSERT INTO cucNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","I² jon³ a⁴ŋang⁴ Pilato i²con²³i³, a⁴sagh⁴³i³: ―¿O⁴ hnei³ langh⁴³ Re¹ quian¹ judío tionh²? Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Liah⁴ juah⁴ ne³pa² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","I² jon³ a⁴juah⁴ Pilato i²con²³ la⁴jang³⁴ m³chie³ tyein² tionh² jian³ i²con²³ a³jeu³: ―I¹con³ chie³² sa⁴sia³ quieh¹ a³ñih³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","I² hei⁴i³ tionh² ne⁵, ta² sa⁴can²³i³ jau²³, a⁴juah⁴i³: ―Ta² sion⁴³ a³ne³ a³jeu³ con⁴juah⁴ jau²³ i⁴heh²i³ chie³ la⁴tan² húa³⁴ Judea la³, liah⁴ma²ma⁴lie⁵i³ húa³⁴ Galilea jian³ la⁴teg⁴ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Con³ma²a⁴nau⁴ Pilato jau²³ jon³, jon³ a⁴ŋang⁴i³ o⁴ lang⁴³i³ a³sian³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","I² con³ma²ra⁵ñi³i³ i⁴sian³i³ húa³⁴ i²júan³ Herodes heih⁴³, jon³ a⁴sain⁴i³ Jesús i²con²³ Herodes, quie¹ cua⁴³i³ Jerusalén jm² jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","I² Herodes ne⁵, con³ma²a⁴jen³i³ Jesús, ta² si³hyonh³i³ a⁴leg³⁴, quie¹ ma³jon⁵ne³⁴ hnie³⁴i³ jen⁴³i³, jian³ quie¹ hlion⁴ jau²³ ma³a⁴nau⁴i³ nei² quieh¹i³, jian³ hnie³⁴i³ jen⁴³i³ i⁴júan³⁴i³ ua³júah² ta⁵nei²i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","I⁴jon³ ta² hlion⁴ a⁴ŋang⁴i³ i²con²³ Jesús, i² Jesús ne⁵, i¹con³ jau²³ sa⁴a⁴jainh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jian³ ti²tionh² m³chie³ tyein² jian³ a²teg²³ quian¹ lai²³ ti²hnang⁴³i³ jang³⁴ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","I² Herodes ne⁵, jian²³ a²hlie⁴ quian¹, co⁴lianh³i³ Jesús quie¹ a⁴tonh³i³ a²hmh³ jlanh² quieh¹ re¹ i⁴ji⁴ŋang⁴i³; jian³ ma²a⁴leg³⁴ jon³ a⁴saih³i³ i²con²³ Pilato. ");
INSERT INTO cucNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jian³ jm² jon³ a⁴jainh³ tsei⁴³ Pilato jian²³ Herodes, quie¹ liah⁴ma²jia⁴³ ma²tionh² hnai³qui³ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","I² jon³ a⁴júan⁴ Pilato i⁴a⁴ŋangh³ la⁴jang³⁴ m³chie³ tyein² jian³ la⁴jang³⁴ si³ta¹ quian¹ judío, jian³ a³jeu³ liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a⁴sagh⁴³i³: ―Ma³jianh⁴³ˉ³ a³ne³ i²con²³ jnia⁴ tionh²ˉ³, juah⁴ˉ³ i⁴sion⁴³i³ a³jeu³; i² ma³a⁴can³⁴ˉ⁴ jau²chie⁴³ i²con²³i³ ta⁵mah²ˉ³ tionh²ˉ³, i² i¹con³ chie³² sa⁴a⁴chieh³²ˉ⁴ quieh¹i³ nei² quieh¹ i⁴jon³ i⁴hnangh⁵i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jian³ Herodes liah⁴, sa⁴a⁴chieh¹i³ chie³² quieh¹i³, quie¹ ma²a⁴sain³⁴i³ jnia⁴ ta⁵nei² hei⁴i³. I² tieh²la³ ne⁵, i¹con³ chie³² sa⁴sia³ quieh¹i³ juah⁴ i⁴li⁴jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","I² jon³ ne⁵, lion³²i³ jnia⁴ tei⁴³i² ma³a⁴pan³⁴ˉ⁴ jeu³ a²lo³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Quie¹ ton³²nie⁴³ hniah³ lion⁴ jan³ a³chion³² jm² la³ conh⁴ con³ ñi³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","I² la⁴jang³⁴ a³jeu³ ne⁵, a⁴hleh⁴i³ tia⁴ co⁴chia³, juah⁴i³: ―¡Hniah³ jaun⁴pa² a³ñih³ ne³, lion³² hnei³ Barrabás! ");
INSERT INTO cucNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Quie¹ ma³a⁴tanh³i³ Barrabás ni⁴ñi²³ nei² quieh¹ i⁴a⁴sion⁴³i³ a³jeu³ Jerusalén jon³ jian³ i⁴a⁴jŋangh⁴i³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Conh⁴liah⁴ a⁴hleh⁴ Pilato i²con²³ a³jeu³ liah⁴ i⁴seg³⁴ i⁴hnie³⁴i³ lion⁴³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","I² hei⁴i³ tionh² ne⁵, conh⁴liah⁴ a⁴hleh⁴i³ tia⁴, juah⁴i³: ―¡Tion⁴³ hnei³ a³ne³ crau¹, tion⁴³ hnei³ a³ne³ crau¹! ");
INSERT INTO cucNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Conh⁴liah⁴ a⁴juah⁴ Pilato a²teg⁴ hnang²³ nie⁴³: ―¿I² henh⁴ hlagh³² ma³a⁴júan⁴ a³la³ ne⁵? Quie¹ i¹con³ chie³² sa⁴tyieh³²ˉ⁴ quieh¹i³ juah⁴ i⁴li⁴jaun⁴i³. Pan¹ pi²³i³ jnia⁴ jeu³ a²lo³, ma²jon³ lion³²i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","I² hei⁴i³ tionh², tsei³⁴sa² tia⁴ a⁴hleh⁴i³ i⁴m²³i³ ta⁵ton³²i³ crau¹; i² jau²³ quieh¹ a³jeu³ jian³ m³chie³ tyein² tionh², a⁴nau⁴ Pilato. ");
INSERT INTO cucNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","I² jon³ a⁴queih³ Pilato heih⁴³ i⁴lei⁴ liah⁴ ti²m²³i³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","jian³ a⁴lion³i³ a³hain⁴ a³ma²a⁴tanh³i³ ni⁴ñi²³ nei² quieh¹ i⁴a⁴sion⁴³i³ a³jeu³ jian³ i⁴a⁴jŋangh⁴i³ chie³, a³a⁴m⁴ a³jeu³ jau²³ quieh¹, jian³ a⁴cúanh³i³ Jesús i²con²³i³ canh⁴a² júan³⁴i³ liah⁴ hyon³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Con³ma²ma³jian³i³ Jesús ua⁵tion⁴i³ crau¹, jon³ a⁴sanh³i³ jan³ chie³ a³sain³ Si²úan¹ ho³²jeu³, a³sian³ je¹jeu³ Cirene, a³jonh³ i²nau³, a⁴júan⁴i³ heih⁴³ i⁴jian³⁴ a³hain⁴ crau¹, i⁴chie³⁴i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jian³ ta² jeun⁴³ a³jeu³ ya¹han² coh⁵ liah⁴, jian³ a³m⁴ a³ti²hoh⁵ a³ti²chionh⁴ tsei⁴³ nei² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","I² Jesús ne⁵, a⁴jainh³i³ nei², a⁴jen³i³ a³m⁴ hain⁴, a⁴sagh⁴³i³: ―Hnei³ a³m⁴ a³sian³ Jerusalén la³, a⁵hoh⁴³ hnei³ nei² quien⁴ˉ⁴ tionh²ˉ³, hoh³² hnei³ nei² quianh³ˉ³ húanh⁴ tionh²ˉ³ jian³ nei² quieh¹ si³jonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Quie¹ jia²³ jm² la⁴teg⁴i² hleh³ chie³: “Ta² tsei³⁴ jm² ren³ la⁴jang³⁴ a³m⁴ a³sa⁴sian³ a³jon⁴³, la⁴jang³⁴ a³sa⁴a⁴can³⁴ yein³, la⁴jang³⁴ a³sa⁴ma⁴cúan³ yein³ a³teih⁴.” ");
INSERT INTO cucNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jian³ ma²jon³ hleh³ chie³, sagh⁴³i³ a²mah⁴: “Ua²yi⁴cúan⁴ i²con²³ jnie³²”, jian³ sagh⁴³i³ nei²cuanh³: “Jlang³² hnei³ jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Quie¹ juah⁴ne³ júanh¹i³ jnia⁴ liah⁴i² queih²i³ con³ a²hma³ reh³, ¿liah⁴a² jainh⁴³ a³coh³²ˉ³ ne⁵, a³lang⁴³ liah⁴i² leg⁴³ a²hma³ quein³? ");
INSERT INTO cucNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jian³ jian³i³ jian²³ Jesús i²on³⁴ a³a⁴tanh⁴ chie³² a³lang⁴³ a³chion³², a³ua⁵jŋangh³i³ co⁴chia³ jian²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","I² con³ma²a⁴tyie³⁴i³ con³ i²teh²i³ Ma³tyi² Húan³⁴, jon³ a⁴tion⁴i³ Jesús crau¹ jian²³ a³chion³² hain⁴, jan³ jo³² ta⁵chie³⁴ jian³ jan³ jo³² ta⁵quegh³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","I² jon³ a⁴juah⁴ Jesús: ―Hnei³ Neih³ˉ⁴, hain⁴³ hnei³ chie³² quieh¹ a³ne³ tionh², quie¹ sa⁴ñi³i³ henh⁴ júan³i³. Jian³ a⁴tyonh⁴i³ a²cúan³ Jesús jen²i³ tionh² con⁴juah⁴ i⁴a⁴tyi³i³ jau²chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jian³ ti²je³ a³jeu³ quieh¹ Jesús, jian³ la⁴teg⁴ si³ta¹ a⁴ji⁴jŋang⁴i³ Jesús, a⁴juah⁴i³: ―A³sang²³pa² a⁴lion³i³; ¿e⁴le³⁴ sa⁴i²lion⁴³i³ hña³, juah⁴ne³ hei⁴i³ lang⁴³ A³ya⁴lion³² Chie³ a³a⁴hen⁴³ Jon⁴dai¹, a³a⁴sain⁴i³? ");
INSERT INTO cucNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Conh⁴liah⁴ co⁴jon³ a⁴ji⁴jŋang⁴ a²hlie⁴ quieh¹i³, chie²³i³ hlonh²i³ jian³ haih³i³ o¹bein² jeinh³, ");
INSERT INTO cucNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","jian³ sagh⁴³i³: ―Juah⁴ne³ hnei³ langh⁴³ Re¹ quian¹ judío tionh², lion³² hnei³ húanh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jian³ ra³ton³ con³ jo³²hma³ ma³tyi² crau¹ jau²³ la³ i⁴ra³sag² jau²³ griego, jau²³ la³tein²³ jian³ jau²³ hebreo i⁴ra³juah⁴: A³LA³PA² RE¹ QUIAN¹ JUDÍO TIONH². ");
INSERT INTO cucNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jian³ jan³ a³chion³² ya¹ton³ crau¹ hain⁴ a⁴hleh⁴i³ jau²hlagh³² i²con²³ Jesús, a⁴juah⁴i³: ―Juah⁴ne³ hnei³ langh⁴³ A³ya⁴lion³² Chie³ hain⁴, lion³² hnei³ con³ húanh⁴³ jian³ lie³² hnei³ jnie³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","I² jon³ a⁴ŋang⁴ a³chion³² i²jan³ hain⁴, a⁴jain³⁴i³ a³chion³² reunh¹, juah⁴i³: ―¿O⁴ a⁵sia³ canh⁴³ˉ³ Jon⁴dai¹? Quie¹ ma³ya¹canh²pa² hnei³ ma²eu⁴³ i⁴jaunh⁴ˉ³ liah⁴ ya¹can²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","I² jnia¹ ne⁵, ti²le⁴ˉ¹ ma²eu⁴³ la⁴conh⁴ ma²hniah³ jnia¹ nei² quieh¹ la⁴conh⁴ tei⁴³ i⁴a⁴júan²ˉ¹; i² a³ne³ ne⁵, i¹con³ hlagh³² sa⁴a⁴júan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","I² jon³ a⁴sagh⁴³i³ Jesús: ―Tyon¹ hnei³ hoh⁴³ jnia⁴ tei⁴³i² ma³nioh²ˉ³ júanh²ˉ³ heih⁴³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, ne³⁴pa² cuanh¹ˉ³ jianh²ˉ³ jnia⁴ i²tsei³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Con³ma²a⁴teg⁴ la⁴conh⁴ i⁵hyie³, jon³ a⁴naih³ la⁴tan² nei² cuah³²húa³⁴ la⁴teg⁴ ni¹hneng³ ta⁵hlo⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jian³ a⁴liah⁴ hyie³, jian³ a⁴sain⁴³ a²hmh³ sai²³ quieh¹ cuah³júah² to⁵chieh³². ");
INSERT INTO cucNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","I² jon³ a⁴hleh⁴ Jesús con³ i⁴tia⁴, a⁴juah⁴i³: ―Hnei³ Neih³ˉ⁴, tieh²la³ cúah³²ˉ⁴ m⁴tyi⁴ quien⁴ joh⁴³ cúah³ˉ³. I² con³ma²a⁴hleh⁴i³ jau²³ ne³, jon³ a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","I² jon³ ne⁵, con³ma²a⁴je³⁴ jeu³² a²hlie⁴ la⁴conh⁴ i⁴a⁴leg³⁴, jon³ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹, a⁴juah⁴i³: ―I⁴chie⁴³pa² li⁴ lang⁴³ a³ne³ jan³ chie³ tsein²³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jian³ la⁴jang³⁴ chie³ a³ti²tionh² i²jon³, con³ma²a⁴je³⁴i³ la⁴jeg³⁴ i⁴a⁴leg³⁴, a⁵han²i³ i⁴ti²quein³i³ ni²tsei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","I² la⁴jang³⁴ a³cu²³ quieh¹ Jesús, jian³ la⁴jang³⁴ a³m⁴ a³ma²ya¹han² coh⁵cah³²i³ liah⁴ma²ja³⁴i³ húa³⁴ Galilea, ti²tionh²i³ ti²je²³i³ i²gm⁴ la⁴jeg³⁴ i⁴a⁴leg³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ma²sian³ jan³ chie³ a³sain³ Se¹ a³sian³ jeu³ Arimatea, jeu³ nie⁴³ húa³⁴ Judea, jan³ a³hein² jen² a³ti²lang⁴³ ta¹ quian¹ a³jeu³ Israel tionh², jan³ chie³ tsein²³ a³ni²taih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jian³ ma²jian²³i³ jm² ma²júan³⁴ Jon⁴dai¹ heih⁴³ m⁵cu³ la³, jian³ sa⁴ra⁵hyon³ tsei⁴³i³ la⁴conh⁴ re³ i⁴a⁴tiah⁴ la⁴jang³⁴ si³ta¹ reunh¹i³ tionh², jian³ la⁴conh⁴ tei⁴³ i⁴a⁴júan⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jon³ ñei²i³ i²con²³ Pilato, ni²m¹i³ he³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","I² con³ma²a⁴jyon³i³, jon³ a⁴lion³i³ con³ a²hmh³ tie³. I² jon³ a⁴quion³i³ con³ to³hlo³ i²a⁴cag³⁴i³, i²sa⁴ma³a⁴quion³i³ i¹jan³ a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jian³ jm² jon³ hlo⁴ jm² quieh¹ jm² sa⁴júan³i³ ta¹, jm² i⁴ti²júan³i³ co³jian¹, quie¹ ma³o¹teg³⁴ i²li⁴lie⁵ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jian³ la⁴jang³⁴ a³m⁴ a³ma²a⁵han² jian²³ Jesús húa³⁴ Galilea, ua⁵han²i³ liah⁴ jian³ a⁴je³⁴i³ to³hlo³ jian³ liah⁴ a⁴quie³i³ he³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","I² con³ma²a⁵han²i³ tionh², jon³ a⁴júan⁴i³ re³ o¹jeu² i⁴jia²³ ma³jeu³ jian³ i⁴leg⁴³ o¹tai³² i⁴si⁵jñei⁴³i³ he³² Jesús. I² jon³ a⁴jian⁴i³ jm² sa⁴júan³i³ ta¹ jon³, liah⁴i² ra³juah⁴ lai²³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jm² ra⁴lie⁵ sa³ma², con³ma²a⁴jnia³⁴, to⁵hie³ hion²³, jon³ ua⁵han² a³m⁴ hain⁴ tionh² jian³ co⁴meih³ a³m⁴ sang³⁴ liah⁴, ti²quian³i³ o¹jeu² i⁴jia²³ ma³jeu³ i⁴ma³a⁴júan⁴i³ re³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","I² jon³ a⁴je³⁴i³ i⁴ma³a⁴qui³ a²caun² si²jneng³ ho³²to³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jon³ a⁴han⁵i³ tionh², i² he³² Re¹ Jesús ne⁵, a⁵sia³ a⁴chieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I² ta¹la⁴ ti²júan³i³ co³hei²tsei³ nei² jon³ i⁴so⁵ñi³i³ liah⁴ sian³i³, con³ a⁴la³ ma⁴jnia³² on³⁴ chie³ ta⁵nei²i³ a³tionh² a²hmh³ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","I² nei² quieh¹ yi⁴hang³²i³, jian³ i⁴a⁴tiah⁴i³ nei² ta⁵húa³⁴, jon³ a⁴sag⁴³ a³hain⁴ quieh¹i³ tionh²: ―¿E⁴le³⁴ ti²hnah⁵ˉ³ jan³ chie³ a³sian³ a³ma³a⁴jainh¹, jen² a³jaun²? ");
INSERT INTO cucNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A⁵sion⁴³i³ ma⁵sian³ i²la³ quie¹ ma³a⁴hyon²³ pi²³i³. Tyon¹ hnei³ hoh⁴³ la⁴jeg³⁴ jau²³ i⁴a⁴sag⁴³i³ hnei³ tionh²ˉ³, con³ma²cua⁴³i³ húa³⁴ Galilea, ");
INSERT INTO cucNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","i⁴a⁴juah⁴i³: “Quie¹ ton³²nie⁴³ hniah³ cúanh⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴ joh⁴³ cúa³ chie³ a³ti²ren³ chie³² canh⁴a² tion³⁴i³ crau¹, jian³ hniah³ hyon⁴³i³ tei⁴³i² ma³a⁴teg⁴ hneng³ jm² hon³i³.” ");
INSERT INTO cucNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","I² jon³ ne⁵, hei⁴i³ tionh², a⁴tyon²³ tsei⁴³i³ jau²³ quieh¹ Jesús jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","I² jon³ ua⁵han²i³ ma²tionh²i³ to³hlo³, ua⁵tya³i³ la⁴jeg³⁴ jau²³ jon³ i²con²³ quia⁵con³ chie³ quian¹ Jesús jian³ i²con²³ la⁴jang³⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","A³hain⁴ tionh² Ma³rei² Ma³da³len², jian³ a³teh²i³ A²juan², jian³ Ma³rei² sie²³ Jacobo, jian³ i²co⁴hna³ a³m⁴ sang³⁴ liah⁴, a³hain⁴ a³a⁴tya⁴ jau²³ i²con²³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo. ");
INSERT INTO cucNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","I² la⁴jang³⁴ a³hain⁴ tionh² ne⁵, ta² ŋo⁴³ jau²³ quieh¹ a³m⁴ hain⁴ tionh², lain⁴i³, sa⁴ra⁵hain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","I² Pe³² ne⁵, ra⁴hang³²i³, ŋo³⁴i³ jeu³ra³tyi⁴ la⁴teg⁴ to³hlo³; i² con³ma²a⁴je³⁴i³ naih⁵, jmah³ a²hmh³ tie³pa² júah³ ti²nie⁴³ hña³, jon³ jonh³i³ jauh³² liah⁴ i⁴co³ ya¹chie²³ tsei⁴³i³ la⁴conh⁴ i⁴a⁴leg³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jm² jon³ ŋo³⁴ on³⁴ chie³ quian¹ Jon⁴dai¹ con³ jeu³ peih¹ sain³ Emaús, i⁴nie⁴³ i²tei⁴³ la⁴conh⁴ quia⁵con³ mai²³ metro la⁴teg⁴ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Hein²i³ jeu³ tionh²i³ ti²tya²³i³ jau²³ la⁴jeg³⁴ la⁴conh⁴ i⁴a⁴leg³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","I² jainh¹ a⁵sia³, ta¹la⁴ ti²tya²³i³ jau²³ ti²júanh⁴i³ húan⁴i³, con³ a⁴la³ a⁴tyie³⁴ Jesús hlonh²i³, ŋo³⁴i³ jian²³ a³hain⁴ ya¹ŋeng²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jian³ ua²liah⁴a² ti²jen³i³ Jesús, i¹leuh² sa⁴cu²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jon³ a⁴juah⁴ Jesús: ―¿Hain³ pi² jau²³ ti²tyah³ˉ³ tionh²ˉ³, tionh²ˉ³ jeu³ la³? ¿E⁴le³⁴ ti²chionh⁴ hoh⁴³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","I² jon³ a⁴ŋangh³ jan³ a³hain⁴ tionh², a³sain³ Cleofas, a⁴juah⁴i³: ―¿O⁴ jan³ hnei³pa² li⁴ sa⁴ñih¹ˉ³ la⁴conh⁴ i⁴a⁴leg³⁴ Jerusalén tyie⁴ jo³⁴ ne³, quie¹ la⁴jang³⁴ a³ni²han² Jerusalén pa² ti²ñi³ i⁴a⁴leg³⁴? ");
INSERT INTO cucNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","I² jon³ a⁴ŋang⁴ hei⁴i³: ―¿Henh⁴ a⁴leg³⁴ ne⁵? I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―Quie¹ a⁴júan⁴i³ i²con²³ Jesús a³sian³ jeu³ Nazaret, a³ma²lang⁴³ jan³ a³sain² quian¹ Jon⁴dai¹ jian³ a³ma²quian³ hlion⁴ ua³pei⁴ i⁴a⁴júan⁴i³ hlion⁴ ua³júah² jian³ jau²³ i⁴a⁴hleh⁴i³ i⁴teg³ tsei⁴³ Jon⁴dai¹ jian³ a⁴teg⁴ tsei⁴³ a³jeu³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","I² la⁴jang³⁴ m³chie³ tyein² tionh² ne⁵ jian³ si³ta¹ quian⁴ˉ¹, a⁴cúanh³i³ i⁴a⁴queih³i³ heih⁴³ i²con²³i³ i⁴jaun⁴, jon³ a⁴tion⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","I² jnie³² ne⁵, ma²hain³² tsei⁴³ jnie³² i²con²³i³ i⁴hei⁴ pi²³i³ ma²lion⁴³ a³jeu³ Israel. I² jon³ ne⁵, ne³⁴ ma³hneng³ jm² liah⁴ma²a⁴leg³⁴ la⁴jeg³⁴ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jian³ la⁴la³ a⁴júah⁴ jnie³² co⁴meih³ a³m⁴ jie³ jnie³², con³ma²ñei²i³ to³hlo³ i²ma²ra³hon³i³ to⁵hie³ ni²can³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","I² a⁵sia³ he³² Jesús a⁴chieh¹i³, jon³ jonh²i³ jian³ a⁴tyie⁴i³ jnie³² jau²³ liah⁴ a⁴jen³i³ on³⁴ ángel a³a⁴juah⁴ sian³ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma²jon³ ua⁵han² co⁴meih³ a³jie³ jnie³² teg⁴ to³hlo³ jon³, jian³ a⁴je³⁴i³ la⁴jon³ la⁴conh⁴ jau²³ i⁴a⁴tya⁴ a³m⁴ hain⁴ tionh², jian³ a⁵sian⁴³ Jesús a⁴jen³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","I² jon³ a⁴juah⁴ Jesús i²con²³i³ tionh²: ―¡Ta² huah³ tyih³ˉ³ tionh²ˉ³! ¡Ta² úa⁴ teg³⁴ i⁴li⁴hainh⁴ˉ³ la⁴jeg³⁴ jau²³ i⁴a⁴sag⁴ a³sain² quian¹ Jon⁴dai¹! ");
INSERT INTO cucNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿O⁴ lainh⁴ˉ³ i⁴sa⁴ma²hniah³ can³⁴ A³ua⁵lion³² Chie³ hain⁴ ma²eu⁴³ la⁴jeg³⁴ i⁴ne³ naih⁵i² tyanh¹i³ ñi⁴jeu⁵ i⁴júanh⁴³i³? ");
INSERT INTO cucNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jian³ ma²jon³ ma⁴lie⁵i³ a⁴tya⁴i³ jau²³ la⁴jeg³⁴ Ma²jyi³ i²ra³sag² nei² quieh¹i³, la⁴teg⁴ ma²jyi³ i⁴a⁴sag⁴ M³se²³ jian³ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","I² jon³ a⁴tyie³⁴i³ jeu³ peih¹ jon³ i²ma²ŋah³i³; i² Jesús ne⁵, a⁴júan⁴i³ la⁴jan³ a³hein² jeu³ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","I² a³hain⁴ tionh² ne⁵, a⁴júan⁴i³ ton³²nie⁴³ i⁴jian³⁴i³, a⁴sagh⁴³i³: ―Jian² hnei³ jie³ jnie³², quie¹ ma³a⁴hlo⁴pa² tieh²la³, quie¹ ma³o¹nai⁴³pa². I² Jesús ne⁵, a⁴hei³⁴i³ jauh³² i⁴jian³⁴i³ jian²³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","I² con³ma²tionh²i³ tionh² mesa i⁴queuh⁴³i³ a²hei⁴³, jon³ a⁴tang⁴ Se³ño²³ a²hei⁴³ñih¹, a⁴ma⁴cúah¹i³, jian³ a⁴jeun³⁴i³, jon³ a⁴cúah³i³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","I² con³ma²a⁴leg³⁴ jon³, jon³ a⁴leg³⁴ la⁴con³ a⁴hoh³ m⁴nei²i³, ra⁵cm²³i³ Jesús; i² Jesús ne⁵, so⁵lei³ ta⁵ŋo³⁴i³ ta⁵nei² a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma²jon³ a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―¿O⁴ sa¹ chie⁴³ si³hyonh³ m⁴tyi⁴ quian⁴ˉ¹ a⁴leg³⁴, con³ma²ya¹hleh⁴³i³ jnia¹ jau²³ quieh¹ Jon⁴dai¹ ho³²jeu³, jian³ ma²ya¹he²³i³ la⁴jeg³⁴ i⁴ra³sag² Ma²jyi³? ");
INSERT INTO cucNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","I² liah⁴ma²jon³ ra⁴hang³²i³ tionh², ŋo³⁴i³ liah⁴ ta⁵ Jerusalén; i² con³ma²a⁴tyanh³i³, jon³ a⁴jen³i³ quia⁵con³ a³hain⁴ ti²ŋangh³ jian³ la⁴jang³⁴ a³tionh² jian²³i³ liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","a³ti²tya²³ jau²³, juah⁴i³: ―Jeh³², i⁴chie⁴³ ma³a⁴hyon²³ Se³ño²³ quian⁴ˉ¹, quie¹ ma³ma⁴jnia³²i³ i²con²³ Si²úan¹. ");
INSERT INTO cucNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","I² jon³ liah⁴ a⁴tya⁴ li⁵uan⁴ hain⁴ jau²³ la⁴jeg³⁴ i⁴a⁴leg³⁴ la⁴conh⁴ a⁴leg³⁴ ho³²jeu³, jian³ hain³liah⁴ ra⁵cm²³i³ Se³ño²³, con³ma²a⁴jeun³⁴i³ a²hei⁴³ñih¹. ");
INSERT INTO cucNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jian³ ta¹la⁴ ma²ti²tya²³i³ la⁴jeg³⁴ jau²³ jon³, con³ a⁴la³ ma⁴jnia³² Jesús, a⁴no³i³ to⁵chieh³² jen²i³ tionh², a⁴juah⁴i³: ―Ua²tionh²ˉ³ hyon³ hoh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","I² hei⁴i³ tionh² ne⁵, ta² yi⁴hang³²i³, coh⁴³i³, quie¹ lain⁴i³ ti²je²³i³ tyi⁴cuh⁴ quieh¹ a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","I² a⁴juah⁴ hei⁴i³ ne⁵: ―¿E⁴le³⁴ ti²canh⁴³ˉ³ tionh²ˉ³, jian³ i⁴ti²júanh³ˉ³ co³hei²tsei³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Je¹ hnei³ si¹cúa³⁴ˉ⁴ jian³ si¹tag³⁴ˉ⁴, jnia⁴pa² la³ la⁴conh⁴ lang⁴³ˉ⁴. Sianh³ hnei³ he³⁴ˉ⁴, je¹ hnei³; quie¹ i¹con³ m⁴tyi⁴ quieh¹ a³jaun² a⁵sia³ he³² quian³, jian³ a⁵sia³ hein² a²úan²³ liah⁴ liah⁴i² jeh⁴ˉ³ liah⁴ lang⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I² con³ma²a⁴hleh⁴i³ jau²³ jon³, jon³ a⁴he⁴i³ si¹cúa³ jian³ si¹tag³²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","I² hei⁴i³ tionh² ne⁵, sa⁴ma³ta⁴sagh³² pi¹ tsei⁴³i³ o³re³ jian³ ta² si³hyonh³i³ tionh², i⁴co³ jainh⁴³i³, jon³ a⁴sag⁴³ Jesús quieh¹i³ tionh²: ―¿Sa¹ sia³ i⁴li⁴quih² i²la³? ");
INSERT INTO cucNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma²jon³ a⁴cúah³i³ ca³leuh² i⁴quieh¹ jon⁴³júa³² i⁴cu²³ nei² jyi³ jian³ ca³leuh² cm⁴³ i⁴tieh³² o¹jm³ro⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","I² hei⁴i³ ne⁵, a⁴sanh³i³, a⁴queuh³i³ ta⁵nei² a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma²jon³ a⁴juah⁴i³: ―I⁴la³pa² jau²³ a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ liah⁴ ma²hein³²ˉ⁴ jenh²ˉ³ i⁴ton³²nie⁴³ hniah³ li⁴tei⁴³ la⁴jeg³⁴ i⁴ra³hleh² nei² quien⁴ˉ⁴ nei² ma²jyi³ quieh¹ lai²³ i⁴a⁴sag⁴ M³se²³, jian³ ma²jyi³ i⁴a⁴sag⁴ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹ jian³ ma²jyi³ salmo liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","I² ma²jon³ a²ma⁴ a⁴júan⁴ Jesús i⁴a⁴quienh³ tyi²i³ ra³jia⁵, canh⁴a² li⁴ŋang⁴i³ la⁴jeg³⁴ i⁴ti²sag², ");
INSERT INTO cucNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","jian³ a⁴sagh⁴³i³ tionh² liah⁴: ―La⁴ne³ ra³sag² jian³ la⁴ne³ ra⁵hniah³ i⁴can³⁴ A³ua⁵lion³² Chie³ hain⁴ ma²eu⁴³, i⁴jaun⁴i³, jian³ i⁴hniah³ hyon⁴³i³ jen² a³jaun² tei⁴³i² ma³a⁴teg⁴ hneng³ jm²; ");
INSERT INTO cucNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","jian³ i⁴hniah³ si⁵hleh² i⁴con⁴juah⁴ hei⁴i³ hniah³ sag³⁴ chie³ co³hei²tsei³ quieh¹ a³tionh² la⁴jeg³⁴ nación, canh⁴a² li⁴hain³⁴ Jon⁴dai¹ chie³² quieh¹i³, i⁴li⁴lie⁵ teg⁴ Jerusalén la³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jian³ hnei³pa² tionh²ˉ³ langh⁴³ a³a⁴teg⁴ nei² la⁴jeg³⁴ i⁴la³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jian³ ma²jon³ sain¹ˉ⁴ M⁴tyi⁴ quieh¹ Neih³ˉ⁴ i²conh²ˉ³ tionh²ˉ³ liah⁴ ma²a⁴juah⁴i³; i² jon³ ne⁵, ua²tionh²ˉ³ tionh²ˉ³ ñeih³² Jerusalén la³ la⁴conh⁴i² a⁴hyeih²ˉ³ ua³pei⁴ jia²³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jon³ a⁴húan⁴³ Jesús la⁴jang³⁴ a³hain⁴, te¹i³ la⁴teg⁴ jeu³ Betania, ma²jon³ a⁴sie⁴ Jesús si¹cúa³, a⁴ma⁴cúanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jian³ ta¹la⁴ ma⁴cúanh¹i³, jon³ ua⁵hag⁴³i³ jen²i³ tionh², a⁴son⁴i³ ta⁵yeih³², ŋah³i³ ta⁵ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","I² hei⁴i³ tionh², con³ma²ma⁴con⁴³i³ Se³ño²³, jon³ a⁵han²i³ liah⁴ Jerusalén i⁴eu⁴³ si³hyonh³i³. ");
INSERT INTO cucNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jian³ la⁴jeg³⁴ jm² ŋangh³i³ cuah³júah² júan³i³ júanh⁴³ Jon⁴dai¹ jian³ cúa²³i³ ti²hmah³² liah⁴. La⁴ne³pa².");
INSERT INTO cucNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Liah⁴ma²ra⁴lie⁵ m⁵cu³ ma³sian³pa² a³hain⁴ a³lang⁴³ Jau²³, jian³ a³lang⁴³ Jau²³ hain⁴ ma³sian³ jian²³ Jon⁴dai¹ Jmai³, jian³ lang⁴³i³ Jon⁴dai¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jian³ liah⁴ma²ra⁴lie⁵ ma³sian³ pi²³i³ jian²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","A⁴júan⁴ Jon⁴dai¹ la⁴jeg³⁴ i⁴sia³ con⁴juah⁴ a³hain⁴; i¹con³ a⁵sia³ i⁴ma²sia³ juah⁴ sa⁴ma²a⁴júan⁴i³ con⁴juah⁴ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hei⁴i³ quian³ m⁵cu³ quieh¹ chie³, jian³ m⁵cu³ jon³ leg⁴³ joh¹ quieh¹ la⁴jang³⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Joh¹ jon³ jnia⁵ i²tionh² chie³ i²naih³; i² i²naih³ jon³ sa⁴cagh¹ jm² i⁴ai³⁴ joh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jian³ ma²sian³ jan³ a³ñih³ a³sain³ Juan²³ a³a⁴sain⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Cuan³⁴ a³hain⁴ i⁴ua⁵hleh³i³ jau²³ nei² quieh¹ a³lang⁴³ joh¹, canh⁴a² li⁴hain⁴ la⁴jang³⁴ chie³ con⁴juah⁴ jau²³ i⁴hleh²i³ nei² quieh¹ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","I² Juan²³ hain⁴, a⁵sia³ joh¹ lang⁴³i³, quie¹ lang⁴³i³ jan³ a³ua⁵hleh³ nei² quieh¹ a³lang⁴³ joh¹pa². ");
INSERT INTO cucNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jian³ a³lang⁴³ joh¹ i⁴chie⁴³ hain⁴ cuan³⁴i³ m⁵cu³ la³ ua⁵hoh¹i³ m⁴nei² la⁴jang³⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jian³ cuan³⁴i³ m⁵cu³ la³, i² la⁴jang³⁴ a³tionh² nei² m⁵cu³ la³, sa⁴ra⁵cu²³ quieh¹i³, ua²liah⁴a² a⁴júan⁴ Jon⁴dai¹ Jmai³ m⁵cu³ la³ con⁴juah⁴ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cuan³⁴i³ m⁵cu³ quieh¹i³, i² a³co²³i³ ne⁵, sa⁴a⁴hyei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","I² la⁴jang³⁴ a³hain⁴ a³a⁴hyei⁴³ quieh¹i³, a³ra⁵hain⁴ i²con²³i³, a⁴cúa⁴i³ heih⁴³ i⁴lain⁴i³ si³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","A⁵sia³ lang⁴³i³ liah⁴i² lang⁴³ si³jon⁴³ chie³ a³li⁴sian³ con⁴juah⁴ jeun³ quieh¹ chie³, jian³ o⁴ con⁴juah⁴ si³hyonh³ jan³ chie³; a⁵sia³, quie¹ ra⁵sian³i³ con⁴juah⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jian³ a³hain⁴ a³lang⁴³ Jau²³ hain⁴ a⁴lang³⁴ chie³, jian³ a⁴cua⁴i³ jen² jnia¹; jian³ a⁴niah¹ jnie³² conh⁴ tei⁴³ i⁴júanh⁴³i³, i⁴júanh⁴³i³ i⁴lang⁴³ A³jon⁴³ Jon⁴dai¹ a³jan³ hain⁴, a³eu⁴³ tsei³⁴ tsei⁴³ jian³ a³a⁴hleh⁴ jmah³ jau²³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jian³ Juan²³ liah⁴ a⁴hleh⁴i³ nei² quieh¹ a³hain⁴, a⁴juah⁴i³: ―A³ne³pa² hain⁴ a⁴hleh³ˉ⁴ nei² quieh¹ con³ma²a⁴juah³ˉ⁴, a³hain⁴ a³jia²³ coh⁵cah³ˉ⁴ ne³, a³júanh⁴³ a⁵hei⁴³i² lia⁴ jnia⁴, quie¹ ma³sian³i³ naih⁵i² li⁴sian³⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ta² hlion⁴ i⁴tsei³⁴ sia³ quieh¹ a³hain⁴ i⁴a⁴hyan³⁴ˉ¹ la⁴jag³⁴ˉ¹, quie¹ eu⁴³ hlion⁴ tsei³⁴ tsei⁴³i³ i⁴ni²sion⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jian³ lai²³ jon³ ja³⁴ con⁴juah⁴ M³se²³; i² i⁴tsei³⁴ tsei⁴³ Jon⁴dai¹ i²con²³ chie³ jian³ jau²³ ni²tei⁴³, jñeih² con⁴juah⁴ Jesucristo. ");
INSERT INTO cucNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jian³ i¹jan³ a⁵sian⁴³ a³ma³a⁴jen³ Jon⁴dai¹ Jmai³; jan³ A³jon⁴³ hain⁴ pi²³i³ a⁴he⁴ jnia¹ hain³liah⁴ lang⁴³ Jon⁴dai¹ Jmai³, quie¹ cua⁴³i³ hlonh² Jmai³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","I⁴la³pa² jau²³ i⁴a⁴juah⁴ Juan²³, con³ma²a⁴sain⁴ judío a³tionh² je¹jeu³ Jerusalén m³chie³ jian³ chie³ levita i⁴ni²ŋangh²i³ Juan²³ hain³ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","I² jon³ a⁴hleh⁴ Juan²³ ra³jia⁵, a⁴juah⁴i³: ―A⁵hei⁴³ jnia⁴ A³ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Conh⁴liah⁴ a⁴ŋang⁴i³ tionh² liah⁴ i⁴seg³⁴: ―I² jon³ ne⁵, ¿o⁴ hnei³ I³lie²³ a³sain² hain⁴? I² a⁴juah⁴ Juan²³ ne⁵: ―A⁵hei⁴³ jnia⁴. Conh⁴liah⁴ a⁴ŋang⁴i³ i²con³: ―I² ne³ ne⁵, ¿o⁴ hnei³ jan³ a³sain² quian¹ Jon⁴dai¹ a³ma²jia²³? Jian³ a⁴juah⁴i³ liah⁴: ―A⁵sia³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―¿Hain³ chianh² hnei³ juah⁴ne³ la⁴jon³? Quie¹ hniah³ si²con²³ jnie³² jau²³ i²con²³ a³a⁴sai⁴ jnie³². ¿Sa¹ li⁴jeuh³²ˉ³ jnie³² hain³ chianh² hnei³? ");
INSERT INTO cucNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","I² jon³ a⁴juah⁴ Juan²³ liah⁴: ―Lang⁴³ jnia⁴ jan³ a³hleh² tia⁴ con³ i²a⁵sian⁴³ a³sian³, i⁴juah⁴i³: “Nia¹ hnei³ con³ jeu³ chie⁴³ quieh¹ Se³ño²³ tionh²ˉ³” ―la⁴jon³ liah⁴i² a⁴hleh⁴ Isaías, a³sain² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jian³ a³ni²han² a³ni²ŋangh² Juan²³ hain⁴, a³sain² quian¹ chie³ fariseo pa²; ");
INSERT INTO cucNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","jian³ a⁴ŋang⁴i³ tionh², a⁴sagh⁴³i³: ―¿I² e⁴le³⁴ jm³ sionh⁵ˉ³ chie³ ne⁵, juah⁴ a⁵hei⁴³ hnei³ A³ya⁴lion³² Chie³ hain⁴, juah⁴ a⁵hei⁴³ I³lie²³, jian³ juah⁴ a⁵hei⁴³ i²jan³ a³sain² quian¹ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I² jon³ a⁴ŋangh³ Juan²³, a⁴juah⁴i³: ―Jnia⁴ sion⁵ chie³ jm³ jeu³ o¹jm³; i² sian³ jan³ jenh²ˉ³ tionh²ˉ³, a³hain⁴ a³sa⁴cmh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jian³ jia²³ a³hain⁴ coh⁵cah³ˉ⁴ ne³, jian³ júanh⁴³i³ a⁵hei⁴³i² lia⁴ jnia⁴, jian³ sa⁴haih¹ li⁴saih²ˉ⁵ a²lo³ tsei²³ tag³²i³ i⁴tyi¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A⁴leg³⁴ la⁴jeg³⁴ i⁴ne³ jeu³ i²sain³ Betábara, nie⁴³ jo³² ta⁵hŋoh³ jm³ Jordán, ta⁵jia²³ hyie³, i²jon³ i²ma²si²sion⁴³ Juan²³ chie³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","I² con³ma²a⁴jnia³⁴ jon³, jon³ a⁴je³⁴ Juan²³, a⁴jen³i³ Jesús a³ja²³ hlonh²i³, a⁴juah⁴i³: ―Jeh³², a³ne³pa² A⁵a³siah³ quian¹ Jon⁴dai¹ a³qui²³ chie³² quieh¹ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nei² quieh¹ a³ne³pa² a⁴hleh³ˉ⁴ con³ma²a⁴juah³ˉ⁴ i⁴ja³⁴ jan³ coh⁵cah³ˉ⁴ ne³, jian³ júanh⁴³i³ a⁵hei⁴³i² lia⁴ jnia⁴, quie¹ sian³i³ naih⁵i² li⁴sian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jian³ sa⁴ma²cm⁴³ˉ⁴ hain³ hei⁴i³; i⁴jon³pa² a⁴nia³⁴ˉ⁴ ni³sion⁵ˉ⁵ chie³ jm³ jeu³ o¹jm³, canh⁴a² li⁴cu²³ a³jeu³ Israel quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jian³ a⁴hleh⁴ Juan²³ liah⁴, a⁴juah⁴i³: ―A⁴je³⁴ jnia⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ a³ja²³ ñi⁴jeu⁵ a³jnia⁴ liah⁴i² jnia⁴ a⁵ta³cuah³, a⁴jian⁴i³ la⁴teg⁴ i²con²³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","I² jnia⁴ ne⁵, sa⁴ma²cm⁴³ˉ⁴ hain³ hei⁴i³; i² a³hain⁴ a³a⁴sai⁴ jnia⁴ i⁴ua⁴sion⁵ˉ⁵ chie³ jm³ jeu³ o¹jm³ a⁴sag⁴³i³ jnia⁴, a⁴juah⁴i³: “La⁴teg⁴i² a⁴jeh¹ˉ³ M⁴tyi⁴ quien⁴ˉ⁴ i⁴jia²³ ñi⁴jeu⁵ cua⁴ la⁴teg⁴ i²con²³ jan³ chie³, hei⁴ pi²³i³ hain⁴ júan³⁴ i⁴hyei³⁴ chie³ M⁴tyi⁴ quien⁴ˉ⁴”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jian³ ma³a⁴je³⁴ˉ⁴ la⁴jeg³⁴ i⁴jon³, jian³ hleh³ˉ⁴ liah⁴ i⁴chie⁴³ lang⁴³ a³hain⁴ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jian³ con³ma²a⁴jnia³⁴ jon³, conh⁴liah⁴ i⁴seg³⁴ si²sainh⁴³ Juan²³ jian²³ on³⁴ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","I² con³ma²a⁴jen³i³ Jesús si²ŋeng²³ i²jon³, jon³ a⁴juah⁴i³: ―Jeh³², a³ne³pa² A⁵a³siah³ quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","I² con³ma²a⁴nau⁴ li⁵uan⁴ chie³ quian¹ Juan²³ hain⁴ i⁴a⁴juah⁴i³, jon³ ua⁵han²i³ coh⁵cah³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","I² jon³ a⁴jainh³ Jesús nei², a⁴jen³i³ a³hain⁴ a⁵han² coh⁵cah³²i³, jon³ a⁴sagh⁴³i³: ―¿Henh⁴ hnoh⁴ˉ³ tionh²ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―Hnei³ A²teg²³, ¿jainh¹ ñih⁴ hnei³? ");
INSERT INTO cucNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I² jon³ a⁴juah⁴ Jesús: ―Nia³, ni³je¹ hnei³. Jon³ ua⁵han²i³ ua⁵je⁴i³ jainh¹ cua⁴³i³, i² jon³ a⁴jian⁴i³ tionh² jian²³ Jesús jm² jon³, quie¹ ma³a⁴teg⁴ la⁴conh⁴ ni¹quin⁴ ta⁵hlo⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jian³ jan³ la⁴conh⁴ li⁵uan⁴ hain⁴, a³sain³ Dre¹, a³reunh¹ Si²úan¹ Pe³², a⁴si⁴tyein⁵i³ coh⁵cah³² Jesús, con³ma²a⁴nau⁴i³ jau²³ quieh¹ Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jian³ co⁴ra⁴lie⁵ ñeih³² ua⁵hniah³i³ Si²úan¹ reunh¹, jian³ a⁴sagh⁴³i³: ―Ma³a⁴chianh³² jnie³² a³hain⁴ a³lang⁴³ Mesías ―i⁴hnie³⁴ ra³juah⁴ A³ua⁵lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma²jon³ ua⁵jan³i³ la⁴teg⁴ i²con²³ Jesús, i² con³ma²a⁴je³ Jesús quieh¹i³, jon³ a⁴sagh⁴³i³: ―Hnei³ sainh³ˉ³ Si²úan¹, a³jon⁴³ Jonás, jian³ te³⁴i³ hnei³ Cefas ―i⁴hnie³⁴ ra³juah⁴, Pe³². ");
INSERT INTO cucNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","I² con³ma²a⁴jnia³⁴ jon³, jon³ ra⁵hnie³⁴ Jesús chie³⁴i³ húa³⁴ Galilea, i² jon³ a⁴jen³i³ Lei³², jian³ a⁴sagh⁴³i³: ―Nia³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jian³ Lei³² la³ a³sian³ je¹jeu³ Betsaida, jeu³ i²sian³ Dre¹ jian²³ Pe³². ");
INSERT INTO cucNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","I² Lei³² ŋo³⁴i³ ua⁵hniah³i³ Natanael, jian³ a⁴sagh⁴³i³: ―Ma³a⁴chianh³² jnie³² a³hain⁴ a³a⁴sag⁴ M³se²³ nei² quieh¹ nei² ma²jyi³ quieh¹ lai²³, jian³ la⁴jang³⁴ a³sain² liah⁴. Jesús a³sian³ jeu³ Nazaret hain⁴, a³jon⁴³ Se¹. ");
INSERT INTO cucNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","I² jon³ a⁴juah⁴ Natanael: ―¿Liah⁴ cúan²³ li⁴hyon⁴³ jan³ chie³ tsein²³ jeu³ Nazaret, lainh⁴ˉ³? I² jon³ a⁴juah⁴ Lei³²: ―Nia³, ni³je¹ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","I² jon³ a⁴je³⁴ Jesús i⁴ja³⁴ Natanael i²con²³i³, jon³ a⁴juah⁴i³ nei² quieh¹i³: ―Jeh³², a³ne³pa² jan³ chie³ Israel i⁴chie⁴³, a⁵sia³ ma³co³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","I² jon³ a⁴ŋang⁴ Natanael i²con²³ Jesús: ―¿Liah⁴ cúan²³ cuh⁴³ˉ³ jnia⁴ ne⁵? I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Naih⁵i² a⁴te⁴ hnei³ Lei³², a⁴jen³²ˉ⁴ hnei³ yi⁴ñih⁴ˉ³ jmh¹ a²hma³ m⁴jyi³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","I² jon³ a⁴ŋangh³ Natanael hain⁴, a⁴juah⁴i³: ―A²teg²³, hnei³ langh⁴³ A³jon⁴³ Jon⁴dai¹; jian³ hnei³ langh⁴³ Re¹ quian¹ a³jeu³ Israel liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―¿O⁴ ra⁵hainh⁴ˉ³ quie¹ a⁴jeu³⁴ˉ⁴ hnei³ i⁴a⁴jen³²ˉ⁴ hnei³ ma²yi⁴ñih⁴ˉ³ jmh¹ a²hma³ m⁴jyi³ jon³, lainh⁴ˉ³? I² ne⁵pi¹ jeh²ˉ³ i⁴tyein² júah³ la⁴conh⁴a² i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","I² jon³ a⁴juah⁴ Jesús: ―Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, tieh²la³ jian³ ta⁵i²chie³²ˉ¹ la³, jeh²ˉ³ si¹ja⁵ ñi⁴jeu⁵ jian³ jenh³²ˉ³ ángel quian¹ Jon⁴dai¹ a³ti²eu²³ jian³ a³ti²jyon²³ i²con²³ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Liah⁴ma²hneng³ jm² jon³, jon³ a⁴júan⁴i³ jm² i⁴sanh⁴ jeu³ Caná i²tei⁴³ húa³⁴ Galilea. Jian³ sie²³ Jesús liah⁴ hein² jon³, ");
INSERT INTO cucNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","jian³ ra⁵ten² Jesús liah⁴ jian²³ chie³ quian¹ i²sanh⁴ chie³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","I² con³ma²a⁴chia³⁴ o¹bein², jon³ a⁴juah⁴ sie²³ Jesús: ―A⁵sie⁴³ o¹bein² ma⁵sia³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","I² jon³ a⁴juah⁴ Jesús: ―Hnei³ a³m⁴, ¿e⁴le³⁴ jau²³ ne³ jeuh⁵ˉ³ jnia⁴? A⁵sia³ ma³a⁴tyie³⁴ jm² i⁴júan³²ˉ⁴ ta¹ quien⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","I² jon³ a⁴juah⁴ sie²³i³ i²con²³ a³ti²tyieh⁵ hain⁴: ―Ma⁴tei³² hnei³ la⁴jeg³⁴ i⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jian³ tieh³² i²jon³ jñei⁴ a²tsai³² cah² i⁴leg⁴³ a²caun² i⁴ro³i³ o¹jm³ i⁴raunh⁵ judío si¹cúa³ i⁴tang²³i³, canh⁴a² so⁴heinh⁵i³. Jian³ conh⁴ con³ a²tsai³² cah² haih¹ la⁴conh⁴ to⁴lo⁵quia⁴ jian³ o⁴ to⁴lo⁵quia⁴ ni²tsei¹ quie⁴ litro. ");
INSERT INTO cucNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ a³ti²tyieh⁵ hain⁴: ―Ma⁴canh² hnei³ o¹jm³ la⁴jeg³⁴ a²tsai³² ne³. Jon³ ma⁴canh³i³ la⁴teg⁴ ho³². ");
INSERT INTO cucNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Conh⁴liah⁴ a⁴juah⁴ Jesús: ―Ne³⁴ ne⁵, húa² hnei³, ua⁴cúah³² hnei³ a³sianh³ jm². Jon³ ni²can³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","I² a³sianh³ jm² hain⁴, a⁴con²³i³ jau²chie⁴³ o¹jm³ jon³ i⁴a⁴lag³⁴ o¹bein² i⁴sa⁴ñi³i³ jainh¹ ja³⁴; i² jmah³ a³ti²tyieh⁵ hain⁴pa² ñi³, quie¹ hei⁴ pi²³i³ a⁴húa⁴ o¹jm³. I² jon³ a⁴te⁴ a³sianh³ jm² hain⁴, a⁴teh³i³ a³sanh⁴, ");
INSERT INTO cucNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a⁴sagh⁴³i³: ―La⁴jang³⁴ chie³ tang²³ tionh² tyieh⁵ o¹bein² tsei³⁴ ñeih³², i² la⁴teg⁴i² ma³a⁴hangh³ la⁴jang³⁴ a³ten² hlion⁴, jon³ a²ma⁴ tyieh⁵i³ o¹bein² si¹jeu⁴. I² hnei³ ne⁵, a⁴hmah²ˉ³ o¹bein² i⁴tsei³⁴ jon³ la⁴teg⁴ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","I⁴la³pa² co⁴ra⁴lie⁵ ua³júah² i⁴a⁴júan⁴ Jesús jeu³ Caná nie⁴³ húa³⁴ Galilea, i² la⁴ne³ ma⁴jnia³i³ i⁴júanh⁴³i³, jian³ ra⁵hain⁴ chie³ quian¹i³ i²con²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","I² con³ma²a⁴leg³⁴ jon³, jon³ ŋo³⁴i³ ta⁵jeu³ Capernaum jian²³i³ sie²³ jian³ si³reunh¹i³ jian³ chie³ quian¹i³ liah⁴. I² jon³ a⁴jian⁴i³ tionh² co⁴meih³ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","I² con³ma²ma³hloh³², jm² quieh¹ judío tionh², jm² i⁴a⁴lon⁴ jmai³sie²³i³ húa³⁴ Egipto, jon³ ŋo³⁴ Jesús je¹jeu³ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","I² con³ma²a⁴hei³⁴i³ cuah³júah², jon³ a⁴jen³i³ a³ti²hnang⁴³ a²cua³²jeu²³, jian³ a⁵a³siah³, jian³ a⁵ta³cuah³, jian³ a⁴jen³i³ a³sag²³ o¹cau³² ti²tionh² i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I² jon³ a⁴júan⁴ Jesús con³ i⁴po³⁴i³ i⁴leg⁴³ a²hnai³², a⁴húan⁴³i³ la⁴jang³⁴ a³hain⁴ cuah³júah² jon³, liah⁴ma³jian²³ a⁵a³siah³ quian¹ jian³ a²cua³²jeu²³ ne³, jian³ a⁴jyih³i³ o¹cau³² quieh¹ a³sag²³, jian³ a⁴quegh³i³ a²me²sa³ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","I² jon³ a⁴sagh⁴³i³ a³ti²hnang⁴³ a⁵ta³cuah³ hain⁴: ―¡Qui⁴³ hnei³ la⁴jeg³⁴ i⁴ne³ jauh³² la³! ¡Sa⁴júanh²ˉ³ jauh³² quieh¹ Neih³ˉ⁴ i⁴leg⁴³ jauh³² hmah¹! ");
INSERT INTO cucNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","I² jon³ a⁴tyon²³ tsei⁴³ la⁴jang³⁴ chie³ quian¹i³ i⁴ra³sag² Ma²jyi³: “Ta² tyei⁴³ jnia⁴ nei² quieh¹ jauh³² quianh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","I² jon³ a⁴ŋang⁴ judío tionh², a⁴juah⁴i³: ―¿Henh⁴ ua³júah² li⁴júanh²ˉ³ ta⁵nei² jnie³² i⁴ra³he²³ i⁴chie⁴³ quianh²ˉ³ heih⁴³ i⁴júanh³ˉ³ la⁴ne³? ");
INSERT INTO cucNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Jeun³² hnei³ con³ cuah³ la³ tionh²ˉ³, jon³ júanh³²ˉ⁴ liah⁴ ta¹la⁴ hneng³ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","I² jon³ a⁴juah⁴ chie³ judío hain⁴ tionh²: ―Ta¹la⁴ to⁴lo⁵jñei⁴ ñi³ a⁴teg⁴ a⁴júan⁴i³ cuah³júah² la³. ¿I² liah⁴ cúan²³ tianh³²ˉ³ júanh³²ˉ³ ta¹la⁴ hneng³ jm² ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","I² Jesús ne⁵, a⁴hleh⁴i³ nei² quieh¹ cuah³ i⁴leg⁴³ he³² pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","I⁴jon³da³, con³ma²a⁴hyon²³ Jesús jen² a³jaun², jon³ a⁴tyon²³ tsei⁴³ chie³ quian¹i³ jau²³ jon³ i⁴ma²a⁴juah⁴i³ liah⁴ma²jia⁴³, jian³ ra⁵hain⁴i³ jau²³ i⁴ra³sag² Ma²jyi³ nei² quieh¹i³ jian³ jau²³ i⁴a⁴hleh⁴ Jesús liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","I² con³ma²hein² Jesús Jerusalén jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto jon³, ta² jeun⁴³ chie³ ra⁵hain⁴ i²con²³i³, con³ma²a⁴je³⁴i³ la⁴jeg³⁴ ua³júah² i⁴júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","I² Jesús ne⁵, sa⁴a⁴hang⁴i³ tsei⁴³ i²con²³ la⁴jang³⁴ a³hain⁴ tionh², quie¹ ñi³i³ liah⁴ lang⁴³ la⁴jang³⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jian³ sa⁴hniah³ juah⁴ sian³ a³juah⁴ liah⁴ lang⁴³ chie³ i²con²³i³, quie¹ hei⁴ pi²³i³ ñi³ co³hei²tsei³ quieh¹ con⁴jan³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jian³ ma²sian³ jan³ chie³ fariseo a³sain³ Nicodemo a³lang⁴³ jan³ a³tyein² jen² la⁴jang³⁴ judío. ");
INSERT INTO cucNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I² jon³ a⁴tyie³⁴ a³ne³ i²con²³ Jesús con³ to⁵hlo³⁴, jian³ a⁴sagh⁴³i³: ―Hnei³ A²teg²³, nia² jnie³² i⁴a⁴sai⁴ hnei³ Jon⁴dai¹ i⁴ni³heh³²ˉ³ jnie³², quie¹ i¹jan³ sa⁴tieh¹ júan³⁴ ua³júah² liah⁴ júanh³ˉ³ ne³, a¹juah⁴ne³ sa⁴jian²³i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, a³hain⁴ a³sa⁴li⁴sian³ i²conh⁴ i⁴seg³⁴, sa⁴li⁴si⁵hei⁴i³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","I² jon³ a⁴juah⁴ Nicodemo: ―¿Liah⁴a² cúan²³ li⁴sian³ jan³ a³ma³don⁵ liah⁴ i⁴seg³⁴? ¿O⁴ lei⁴ li⁴chianh³a² chie³ naih⁵ hein² sie²³i³ jian³ i⁴li⁴sian³i³ i²conh⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","I² jon³ a⁴ŋangh³ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, a¹juah⁴ hain³ sa⁴li⁴sian³ con⁴juah⁴ o¹jm³ jian³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹, sa⁴li⁴si⁵hei⁴i³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","A³hain⁴ a³ra⁵sian³ i²con²³ jmai³sie²³, quian³i³ he³² a³sian³ m⁵cu³; i² a³hain⁴ a³ra⁵sian³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹, lang⁴³i³ a³quian³ M⁴tyi⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Sa⁴hniah³ chie³⁴ ja³ co³ hoh⁴³ˉ³ i⁴juah³ˉ⁴ la³: “Quie¹ la⁴jang³⁴pa² hniah³ li⁴sian³ i²conh⁴ i⁴seg³⁴.” ");
INSERT INTO cucNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Quie¹ tyi⁴ ŋeng²³ tangh⁵ hnie³⁴ chie³⁴; jian³ nauh³ˉ³ con⁴juah⁴ i⁴hain³², jian³ sa⁴ñih¹ˉ³ tangh⁵ ja³⁴ jian³ tangh⁵ ŋo³⁴ liah⁴. Jian³ la⁴ne³ jainh⁴³ la⁴jang³⁴ chie³ la⁴teg⁴i² li⁴sian³i³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Conh⁴liah⁴ a⁴ŋang⁴ Nicodemo, a⁴juah⁴i³: ―¿Liah⁴a² li⁴lei⁴ la⁴ne³? ");
INSERT INTO cucNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jon³ a⁴juah⁴ Jesús: ―Hnei³ langh⁴³ a²teg²³ quian¹ a³jeu³ Israel, ¿i² liah⁴ cúan²³ sa⁴ŋangh⁴ˉ³ i⁴ne³? ");
INSERT INTO cucNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","I⁴chie⁴³pa² juah³ˉ⁴, hleh³ jnie³² la⁴conh⁴ i⁴nia² jnie³² jian³ la⁴conh⁴ i⁴a⁴niah¹ jnie³² liah⁴; i² hnei³ tionh²ˉ³ ne⁵, sa⁴hyeih³ˉ³ i⁴hlenh⁵ jnie³² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Quie¹ juah⁴ne³ sa⁴hainh⁴ˉ³ tei⁴³i² hleh³ˉ⁴ i⁴quieh¹ m⁵cu³ la³, ¿liah⁴a² li⁴hainh⁴ˉ³ juah⁴ne³ hleh¹ˉ⁴ i⁴quieh¹ ñi⁴jeu⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Jian³ i¹jan³ a³sang²³ sa⁴ma³ŋah² ñi⁴jeu⁵, jan³ hain⁴pa² a³ma²a⁴jyon²³ hain⁴, a³hain⁴ A³a⁴lang³⁴ Chie³ hain⁴, a³cua⁴³ ñi⁴jeu⁵. ");
INSERT INTO cucNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jian³ liah⁴i² a⁴sion⁴³ M³se²³ a⁵mh³ yeih³² i²a⁵sian⁴³ a³sian³ jon³, la⁴jon³ hniah³ son⁵ A³a⁴lang³⁴ Chie³ hain⁴ yeih³² liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","canh⁴a² la⁴jang³⁴ a³hain⁴ i²con²³i³, a⁵sia³ si⁵hain⁴i³, quie¹ hyieh⁴i³ con³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Quie¹ eu⁴³ ra⁵hnio³⁴ Jon⁴dai¹ a³m⁵cu³, i⁴jon³ a⁴sain⁴i³ A³jon⁴³, a³jan³ hain⁴, canh⁴a² sa⁴si⁵hain⁴ la⁴jang³⁴ a³hain⁴ i²con²³i³, quie¹ canh⁴a² hyieh⁴i³ con³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jian³ a⁵sia³ a⁴sain⁴ Jon⁴dai¹ A³jon⁴³ nei² m⁵cu³ la³ juah⁴ i⁴ua⁵tion⁴i³ chie³ i²hlagh³², quie¹ i⁴jon³pa² canh⁴a² lion⁴ a³m⁵cu³ con⁴juah⁴ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’A³hain⁴ a³hain⁴ i²con²³i³, a⁵sia³ si⁵hain⁴i³; i² la⁴jang³⁴ a³sa⁴hain⁴ ne⁵, ma³ua⁵hain⁴ pi²³i³, quie¹ ta⁵la⁴ sa⁴ra⁵hain⁴i³ i²con²³ A³jon⁴³ Jon⁴dai¹, a³jan³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jian³ nei² la³pa² si⁵hain⁴i³: quie¹ con³ma²cua³⁴ joh¹ m⁵cu³ la³, eu⁴³a² si³hyonh³ chie³ i²naih³ tionh² a⁴leg³⁴ la⁴conh⁴a² joh¹, quie¹ ta⁵la⁴ ti²júan³i³ jmah³ i⁴hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Quie¹ la⁴jang³⁴ a³júan³ i⁴hlagh³², hieh¹i³ joh¹, jian³ sa⁴hnie³⁴i³ tangh³i³ joh¹, canh⁴a² sa⁴hnie³⁴i³ jñeih³ i⁴hlagh³² i⁴ti²júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","I² la⁴jang³⁴ a³júan³ con⁴juah⁴ jau²³ ni²tei⁴³ hnie³⁴i³ tyie¹i³ i²con²³ joh¹, canh⁴a² li⁴jnia³ la⁴jeg³⁴ i⁴ti²júan³i³ i⁴leg⁴³ con⁴juah⁴ heih⁴³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","I² con³ma²a⁴leg³⁴ jon³, jon³ ŋo³⁴ Jesús jian²³ chie³ quian¹ ta⁵húa³⁴ Judea; jian³ a⁴jian⁴i³ i²jon³ jian²³ a³hain⁴ tionh², jian³ a⁴sion⁴³i³ chie³ jm³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jian³ Juan²³ liah⁴ si²sion⁴³i³ chie³ jm³ jeu³ Enón, hloh³² jeu³ Salim, quie¹ hlion⁴ jm³ ra³hei¹ i²jon³; jian³ tyie²³ jeun⁴³ chie³ i²con²³i³ a³sion⁴³i³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jian³ jon³ pi¹ chie³⁴ Juan²³ ni⁴ñi²³ a⁴leg³⁴ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma²jon³ a⁴jang²³ chie³ quian¹ Juan²³ jian²³ judío nei² quieh¹ i⁴júan³i³ i⁴a⁵sie⁴³ heinh⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma²jon³ a⁵han²i³ ua⁵saih¹i³ Juan²³, a⁴juah⁴i³: ―Hnei³ a²teg²³, jeh³², la⁴la³ júan³ a³hain⁴ a³ma²jianh²ˉ³ jo³² ta⁵hŋoh³ jm³ Jordán ta⁵jia²³ hyie³ jon³, a³ma²a⁴hleh²ˉ³ nei² quieh¹: si²sion⁴³i³ chie³ jm³, jian³ la⁴jang³⁴ si³han² coh⁵cah³²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","I² jon³ a⁴juah⁴ Juan²³: ―I¹con³ sa⁴li⁴hyei³⁴ chie³ juah⁴ne³ sa⁴a⁴cúa⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jian³ hnei³pa² tionh²ˉ³ liah⁴ ñih¹ˉ³ i⁴a⁴juah³ˉ⁴, a⁵hei⁴³ jnia⁴ A³ya⁴lion³² Chie³ hain⁴, quie¹ lang⁴³ jnia⁴ jan³ a³sain² ñeih³² nei² quieh¹ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Júan³²ˉ¹, nei² quieh¹ jan³ a³sanh⁴, a³m⁴ sanh⁴, a³quian¹ a³ñih³ sanh⁴pa². I² a³ñi³reunh¹ a³sanh⁴ hain⁴ si²sainh⁴³ hloh³² si²nau³i³ jau²³ quieh¹i³; jian³ ta² co³hyon²³tsei³ can²³i³ nau³i³. Jian³ la⁴ne³pa² liah⁴ hyan⁵ i⁴si³hyonh³ jnia⁴ i⁴si³lei⁴ ne³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jian³ hei⁴ pi²³i³ eu⁴³ júanh⁴³ hniah³ lei⁴ con⁴ conh⁴, jian³ jnia⁴ liah⁴, ta⁵jyon³⁴ pe²³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A³hain⁴ a³ja²³ ta⁵yeih³², tyein² la⁴conh⁴a² la⁴jang³⁴. Jian³ a³quian¹ cuah³²húa³⁴ la³, lang⁴³i³ a³sian³ cuah³²húa³⁴ la³pa², jian³ hleh²i³ jmah³ i⁴quieh¹ cuah³²húa³⁴ la³. I² a³hain⁴ a³ja²³ ñi⁴jeu⁵ ne⁵, tyein² la⁴conh⁴a² la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jian³ la⁴conh⁴ i⁴a⁴je³⁴i³ jian³ i⁴a⁴nau⁴i³, la⁴jon³pa² hleh²i³, jian³ i¹jan³ sa⁴hyei³ jau²³ i⁴hleh²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","I² a³hain⁴ a³hyei³ jau²³ i⁴hleh²i³ ne⁵, ma³jnia³i³ i⁴hleh² Jon⁴dai¹ jau²³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Quie¹ a³hain⁴ a³a⁴sain⁴ Jon⁴dai¹, hleh²i³ jmah³ jau²³ quieh¹ Jon⁴dai¹, quie¹ cúa²³ Jon⁴dai¹ M⁴tyi⁴ quieh¹ i²con²³ a³hain⁴ sa⁴nie⁴³ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jian³ Jon⁴dai¹ Jmai³, hnio³⁴i³ A³jon⁴³, jian³ a⁴toh³i³ joh⁴³ cúa³ a³hain⁴ la⁴jeg³⁴ i⁴sia³. ");
INSERT INTO cucNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A³hain⁴ a³hain⁴ i²con²³ A³jon⁴³ Jon⁴dai¹, sia³ m⁵cu³ quieh¹i³ sa⁴ton³ jm² ua²tya⁴³; i² a³hain⁴ a³sa⁴hnie³⁴ li⁴hain⁴ i²con²³ A³jon⁴³i³, sa⁴hyieh⁴i³ m⁵cu³ jon³, quie¹ hyieh⁴i³ ma²eu⁴³ pain⁴ i⁴he³⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Jon³ ra⁵ñi³ chie³ fariseo tionh² i⁴jeun⁴³ chie³ ya¹han² coh⁵cah³² Jesús, jian³ sion⁴³i³ jm³ la⁴conh⁴a² Juan²³; ua²liah⁴a² sa⁴sion⁴³ Jesús chie³ jm³, chie³ quian¹ pi²³i³ sie⁴³; con³ma²ra⁵ñi³ Se³ño²³ jau²³ jon³, ");
INSERT INTO cucNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","jon³ ua⁵hag⁴³i³ húa³⁴ Judea, ŋah³i³ ta⁵húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jian³ hniah³ ua⁵jeun³²i³ ton³²nie⁴³ húa³⁴ Samaria i⁴tyanh¹i³ jeu³ co²³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","I² jon³ a⁴tyie³⁴i³ con³ jeu³ nie⁴³ húa³⁴ Samaria, jeu³ sain³ Sicar, hloh³² húa³⁴ i⁴a⁴cúa⁴ Ja³co²³ i²con²³ a³jon⁴³ a³sain³ Se¹. ");
INSERT INTO cucNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","I²jon³ nie⁴³ con³ a²po²zo³, teh²i³ pozo quieh¹ Ja³co²³. I² Jesús ne⁵, a⁴húah⁴³i³ hein²i³ jeu³, jon³ a⁴cua⁴i³ ho³² a²po²zo³. Jian³ ma³a⁴teg⁴ la⁴conh⁴ yi⁵hyie³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","I² jon³ a⁴tyie³⁴ jan³ a³m⁴ a³sian³ húa³⁴ Samaria jon³ a³can³⁴ o¹jm³ pozo jon³, i² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Cúa² o¹jm³ lauh³²ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","I² chie³ quian¹i³ tionh² ne⁵, ma³ua⁵han²i³ ta⁵je¹jeu³ ñeih³² ma³ua⁵lia⁴³i³ i⁴queuh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","I² jon³ a⁴juah⁴ a³m⁴ a³sian³ Samaria hain⁴, a⁴sagh⁴³i³ Jesús: ―¿E⁴le³⁴ hnei³ mh³ o¹jm³ i²con²³ jnia⁴, quie¹ judío pa² hnei³, jian³ a³sian³ Samaria pa² jnia⁴? (Quie¹ sa⁴hnio⁴ judío jian²³ a³sian³ húa³⁴ Samaria tionh².) ");
INSERT INTO cucNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Juah⁴ne³ ma²ñih¹ hnei³ i⁴jon³ i⁴ta² cúa²³ Jon⁴dai¹, jian³ juah⁴ne³ ma²ñih¹ˉ³ hain³ jnia⁴ i⁴si²m³⁴ˉ⁴ o¹jm³, leg⁴³ re³pa² ma²mh²ˉ³ i²con²³ jnia⁴, jian³ ma²cúa¹ˉ⁴ o¹jm³ i⁴sian³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","I² jon³ a⁴juah⁴ a³m⁴: ―Hnei³ a³don⁵, i¹ sa⁴quianh² hnei³ i⁴li⁴tainh³²ˉ³ o¹jm³, jian³ la³a² con³ jeuh³ hei¹ liah⁴. ¿I² jainh¹ ua²quianh³ˉ³ o¹jm³ i⁴sian³ jon³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Quie¹ jmai³sie²³ jnie³², Ja³co²³ hain⁴, a⁴cúa⁴ a²po²zo³ la³ i²ma²hangh² hei⁴i³ jian³ si³jon⁴³i³ jian³ jah⁴ quian¹i³ liah⁴. ¿O⁴ júanh⁴³a² hnei³ la⁴conh⁴a² hei⁴i³ juah⁴ne³ la⁴jon³? ");
INSERT INTO cucNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―La⁴jang³⁴ a³hangh² o¹jm³ la³ liah⁴ma³li⁴quein³ jon³pa² tsei⁴³i³; ");
INSERT INTO cucNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","i² la⁴jang³⁴ a³hangh³ o¹jm³ i⁴cúa¹ jnia⁴, sa⁴legh⁴ ua²ra⁵quein³ tsei⁴³i³. Jian³ o¹jm³ i⁴cúa¹ˉ⁴ jon³ leg⁴³ liah⁴i² leg⁴³ con³ i⁴hya²³ naih⁵ ni²tsei⁴³ chie³ i⁴cúa²³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","I² jon³ a⁴juah⁴ a³m⁴ liah⁴: ―Hnei³ a³don⁵, cúa² o¹jm³ ne³ lauh³²ˉ⁴, canh⁴a² a⁵sie⁴³ li⁴queinh² tsei³⁴ˉ⁴, jian³ canh⁴a² a⁵sie⁴³ nia²³ˉ⁵ nia²húa³⁴ˉ⁴ o¹jm³ pozo la³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","I² jon³ a⁴juah⁴ Jesús: ―Cua³ ua⁴teh⁴³ i³cúah³, jon³ niah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","I² jon³ a⁴ŋangh³ a³m⁴, a⁴juah⁴i³: ―A⁵sian⁴³ i³cúa³⁴ˉ⁴ sian³. I² jon³ a⁴juah⁴ Jesús liah⁴: ―I⁴chie⁴³pa² a⁴juah¹ hnei³, a⁵sian⁴³ i³cúah³ˉ³ sian³; ");
INSERT INTO cucNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","quie¹ hña⁴ a³ñih³ ma³a⁴teg⁴ ra⁵jianh²ˉ³, jian³ a³jianh²ˉ³ tieh²la³, a⁵hei⁴³ i³cúah³ˉ³. I⁴chie⁴³pa² jau²³ ne³ a⁴juah¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jon³ a⁴juah⁴ a³m⁴ hain⁴: ―Hnei³ a³don⁵, lain³⁴ jnia⁴ i⁴langh⁴³ˉ³ jan³ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Quie¹ jmai³sie²³ jnie³² a³sian³ ya⁴jo³⁴, a⁴ma⁴con⁴³i³ Jon⁴dai¹ nei² mah⁴ la³; i² hnei³ tionh²ˉ³, judío, juah⁴ˉ³ i⁴la⁴teg⁴ Jerusalén pa² hniah³ si⁵han²i³, i²jon³ i²leg⁴³ i²ma³con⁴³i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","I² jon³ a⁴juah⁴ Jesús: ―Hnei³ a³m⁴, ua²li⁴hainh⁴ hnei³ jau²³ la³, quie¹ jia²³ jm² i⁴a⁵sie⁴³ hniah³ niah²ˉ³ nei² mah⁴ la³ i⁴ni²ma⁴conh³²ˉ³ Jon⁴dai¹ Jmai³ tionh²ˉ³, a⁵ga⁴ Jerusalén liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hnei³ tionh²ˉ³ sianh³ˉ³ i²la³, sa⁴ñih¹ˉ³ hain³ ma⁵conh³²ˉ³; i² jnie³² ne⁵, nia² jnie³² hain³ ma⁵con³² jnie³²; quie¹ con⁴juah⁴ judío pa² tionh² jia²³ i⁴lion⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Quie¹ ja³⁴ jm² jian³ ma³cua²³ tieh²la³pa² i⁴la⁴jang³⁴ a³ma³co⁴³ i⁴chie⁴³, ma⁵con⁴³i³ Jon⁴dai¹ Jmai³ con⁴juah⁴ m⁴tyi⁴ jian³ con⁴juah⁴ jau²³ ni²tei⁴³. Quie¹ Jon⁴dai¹ Jmai³ hnah³ chie³ a³la⁴ne³ i⁴ma⁵co⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Quie¹ Jon⁴dai¹ lang⁴³i³ M⁴tyi⁴, jian³ la⁴jang³⁴ a³ma³co⁴³ quieh¹i³, hniah³ ma⁵con⁴³i³ con⁴juah⁴ m⁴tyi⁴ jian³ con⁴juah⁴ jau²³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","I² jon³ a⁴juah⁴ a³m⁴ hain⁴: ―Yan³² jnia⁴ i⁴jia²³ Mesías ―jau²³ ne³ ra³juah⁴, A³lion³ Chie³ hain⁴―; jian³ tei⁴³i² cuan³⁴ hei⁴i³, he³⁴i³ la⁴jeg³⁴ i²con²³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","I² jon³ a⁴juah⁴ Jesús liah⁴: ―Jnia⁴pa² a³hain⁴ si²hlenh⁵ˉ⁵ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","I² con³ a⁴la³ a⁴tyanh³ chie³ quian¹i³ tionh², jian³ ta² co³ ŋo³⁴ tsei⁴³i³, quie¹ si²tya²³ Jesús jau²³ jian²³ jan³ a³m⁴. Jian³ i¹jan³ a³hain⁴ tionh² sa⁴a⁴juah⁴: “¿Henh⁴ pi¹ ma²ŋangh³ˉ³?”, jian³ o⁴ “¿Henh⁴ jau²³ ma²ti²tyah³ˉ³ tionh²ˉ³?” ");
INSERT INTO cucNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","I² a³m⁴ hain⁴, a⁴seih⁴i³ a²tsai³² quieh¹ i²jon³, jon³ ŋah³i³ ta⁵je¹jeu³, jian³ a⁴sagh⁴³i³ chie³ a³tionh² i²jon³: ");
INSERT INTO cucNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Nia³, ni³jen³² hnei³ tionh²ˉ³ jan³ chie³ a³a⁴sag⁴³ jnia⁴ la⁴jeg³⁴ i⁴ma³a⁴júan³⁴ˉ⁴. ¿O⁴ a¹hei⁴ a³ma²jia²³ Ya⁴lion³² Chie³ hain⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","I² jon³ a⁴húan³i³ je¹jeu³, ua⁵han²i³ i²sainh⁴³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","I² ta¹la⁴ jon³ ti²hleh⁴³ chie³ quian¹ Jesús i⁴ti²sagh⁴³i³: ―Hnei³ A²teg²³, cauh⁴³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","I² jon³ a⁴juah⁴ hei⁴i³: ―Sia³ con³ ma³⁴ quien⁴ˉ⁴ i⁴queuh³ˉ⁴ i⁴sa⁴ñih¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","I² jon³ a⁴júanh⁴ chie³ quian¹i³ la⁴can³ húan⁴ tionh²: ―¿O⁴ sian³ a³ma³li⁴ua⁵can³ i⁴queuh⁴³i³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","I² jon³ a⁴juah⁴ Jesús: ―Ma³⁴ quien⁴ˉ⁴ leg⁴³ i⁴ma²tei³²ˉ⁴ heih⁴³ quieh¹ a³a⁴sai⁴ jnia⁴, jian³ ma²tieh²ˉ⁵ ta¹ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","I² hnei³ tionh²ˉ³ juah⁴: “Quin⁴ segh³ a²júah³ si³hain⁴³ i⁴lo³⁴ o¹m⁴”; i² jnia⁴ juah³: Jeh³², je¹ hnei³ i⁴jnia², ma³don³, ma³li⁴queih³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jian³ la⁴jang³⁴ a³júan³ ta¹ i⁴jaih²i³ o¹m⁴, hyei³i³ hmah¹ quieh¹; i² o¹m⁴ i⁴jaih²i³ i⁴lo²³ jon³, i⁴quieh¹ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³, canh⁴a² lei⁴ si³hyonh³ a³jnei³ co⁴chia³ jian²³ a³jaih². ");
INSERT INTO cucNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quie¹ i⁴chie⁴³pa² jau²³ jon³ i⁴ra³juah⁴ la⁴la³: “Jan³ a³jnei³ jian³ a³sang²³pa² jaih².” ");
INSERT INTO cucNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Quie¹ sain¹ˉ⁴ hnei³ tionh²ˉ³ i⁴ua²jaih¹ˉ³ i²sa⁴a⁴jñih⁴ˉ³; quie¹ a³sang²³pa² a⁴jnei⁴, jian³ hnei³ re³ tangh³ˉ³ ta¹ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jian³ jeun⁴³ chie³ samaritano a³sian³ jeu³ jon³ ra⁵hain⁴ i²con²³ Jesús con⁴juah⁴ jau²³ i⁴a⁴tya⁴ a³m⁴ hain⁴, i⁴a⁴sagh⁴³i³ a³hain⁴ tionh², juah⁴i³: “I⁴a⁴jñeih³ a³hain⁴ la⁴jeg³⁴ i⁴ma³a⁴júan³⁴ jnia⁴.” ");
INSERT INTO cucNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","I² con³ma²a⁴tyie³⁴ a³hain⁴ tionh² i²con²³ Jesús, jon³ a⁴m⁴i³ i²con²³ Jesús i⁴jian³⁴i³ jen²i³ tionh². I² jon³ a⁴jian⁴ Jesús to⁴jm⁵ i²jon³, ");
INSERT INTO cucNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","jian³ jeun⁴³i³ tionh² ra⁵hain⁴, con³ma²a⁴nau⁴i³ jau²³ quieh¹ hña³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","I² jon³ a⁴sagh⁴³i³ a³m⁴ hain⁴: ―A⁵jon⁴³ con⁴juah⁴ jmah³ jau²³ i⁴a⁴tyah²ˉ³, ra⁵hain⁴ jnie³², quie¹ con⁴juah⁴ jau²³ i⁴a⁴nai² jnie³² húan⁴ jnie³² i²con²³i³ liah⁴; jian³ nia² jnie³² i⁴chie⁴³ lang⁴³ a³hain⁴ Cristo, a³hain⁴ A³ya⁴lion³² m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Liah⁴ma³jo³⁴ ua⁵hag⁴³ Jesús húa³⁴ Samaria, jon³ a⁴hei³⁴i³ jeu³, ŋah³i³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quie¹ a⁴juah⁴ Jesús hña³ liah⁴ i⁴sa⁴ron⁴³i³ jeu³ jan³ a³sain² quian¹ Jon⁴dai¹ jeu³ co²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","I² con³ma²a⁴tyanh³i³ húa³⁴ Galilea, ta² re³ a⁴hyei⁴³ a³sian³ i²jon³ quieh¹i³, quie¹ a⁴je³⁴ a³hain⁴ tionh² la⁴jeg³⁴ i⁴a⁴júan⁴ Jesús con³ma²a⁴júan⁴i³ jm² tionh² jeu³ Jerusalén, jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, quie¹ ni²han² a³hain⁴ tionh² jm² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jian³ a⁴tyanh³ Jesús liah⁴ jeu³ Caná nie⁴³ húa³⁴ Galilea i²a⁴júanh³i³ o¹jm³ i⁴a⁴lag³⁴ o¹bein². Jian³ jeu³ Capernaum ma²sian³ jan³ tyein² quian¹ re¹, a³hain⁴ a³chieh¹ a³jon⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","I² a³tyein² hain⁴, con³ma²ra⁵ñi³i³ i⁴a⁴tyanh³ Jesús húa³⁴ Galilea i⁴jonh³i³ húa³⁴ Judea, jon³ ni²jen³²i³ Jesús i⁴ni²mh²i³ i⁴chie³⁴i³ jauh³² quieh¹i³ i⁴si⁵júan⁴i³ i⁴huan⁴ quieh¹ a³jon⁴³i³, quie¹ ra³quian³i³ ma³o¹jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","I² jon³ a⁴juah⁴ Jesús: ―Sa⁴legh⁴ ua²ra⁵hainh⁴ˉ³ tionh²ˉ³ juah⁴ne³ sa⁴jeh²ˉ³ ua³júah² co³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Conh⁴liah⁴ a⁴juah⁴ a³tyein² quian¹ re¹ hain⁴: ―Hnei³ Se³ño²³, nia³ hnei³ ta¹tia⁴ naih⁵i² jaun⁴ a³jon³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jon³ a⁴juah⁴ Jesús: ―Cuanh³ hnei³, quie¹ ma³a⁴jainh¹pa² tsei⁴³ a³jonh³ˉ³. I² chie³ hain⁴ ra⁵hain⁴ jau²³ i⁴a⁴juah⁴ Jesús, jon³ ŋah³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","I² ta¹la⁴ ŋah³i³, jon³ ua⁵han² a³cúa²³ cúa³tag³² quian¹i³ a⁵ma⁵jainh³²i³; i² jon³ a⁴sagh⁴³i³ jeu³², a⁴juah⁴i³: ―Ma³a⁴lag³⁴ tsei⁴³ a³jonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I² jon³ a⁴ŋang⁴ hei⁴i³ hain³ o²ra³ a⁴lag³⁴ tsei⁴³i³; i² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―Tyie⁴ ni¹con³ ta⁵hlo⁴ a⁴qui³ tyei⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jon³ a⁴tagh³ tsei⁴³ jmai³i³ i⁴o²ra³ jon³ con³ma²a⁴juah⁴ Jesús i²con²³i³: “Ma³a⁴jainh¹ tsei⁴³ a³jonh³ˉ³”; i² jon³ ra⁵hain⁴ a³hain⁴ jian²³i³ la⁴jang³⁴ a³tionh² jauh³² quieh¹i³ i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","I⁴la³pa² a²teg⁴ teun³⁴ ua³júah² i⁴a⁴júan⁴ Jesús, con³ma²a⁴tyanh³i³ húa³⁴ Galilea i⁴jonh³i³ húa³⁴ Judea. ");
INSERT INTO cucNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Con³ma²a⁴leg³⁴ jon³, jon³ ti²júan³ judío jm² liah⁴ Jerusalén, i² jon³ ŋo³⁴ Jesús liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jian³ je¹jeu³ jon³ hloh³² o²hnei³² i⁴sain³ i⁴quieh¹ A⁵a³siah³, nie⁴³ con³ jm³ i⁴teh²i³ Betesda jau²³ hebreo, i⁴quian³ hña⁴ ho³²quie³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","I² ho³²quie³ jon³ ra³han² jeun⁴³ a³chieh¹: a³taun³², a³tein⁴, a³lo³, a³ti²jian²³ i⁴jaih³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Quie¹ ma²jyon²³ jan³ ángel legh⁴conh⁴ i²nie⁴³ jm³ jon³ i⁴si³jua⁴³i³, jian³ a³hain⁴ a³si³hei⁴ la⁴conh⁴ ra⁴lie⁵ joh⁴³ jm³, jon³ huan⁴ quieh¹i³ ua²hain³ˉ² chie² lang⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jian³ ma²hein² jan³ a³ñih³ je¹ jon³, a³chieh¹ ma³qui⁴quia⁵jña³⁴ ñi³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","I² con³ma²a⁴je³ Jesús, a⁴jen³i³ a³chieh¹ hain⁴ a³ra³quian³ i²jon³, jon³ ra⁵laih²i³ i⁴chieh¹ a³hain⁴ ma³jon⁵ne³⁴, i² jon³ a⁴sagh⁴³i³: ―¿O⁴ hnoh³ˉ³ huan⁴ quianh³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","I² jon³ a⁴ŋangh³ a³chieh¹ hain⁴: ―Hnei³ a³don⁵, a⁵sian⁴³ a³li⁴tonh⁴³ jnia⁴ joh⁴³ jm³ tei⁴³i² a⁴jaih³. Quie¹ la⁴jeg³⁴ nie⁴³ tei⁴³i² ma³ŋo⁵ˉ⁵ joh⁴³, a³sang²³pa² ñeih³² si³hei⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","I² jon³ a⁴juah⁴ Jesús: ―No³ hnei³, sieh¹ a²hyei²³ quianh³, ŋeng² hnei³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","I² liah⁴ma²jon³ a⁴huan⁴ quieh¹ a³ñih³ hain⁴, jon³ a⁴con²³ a²hyei²³ quieh¹, jian³ a⁴ŋeng⁴i³. I² jm² jon³ ne⁵, jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","I² jon³ a⁴juah⁴ judío tionh², a⁴sagh⁴³i³ a³a⁴huan⁴ quieh¹ hain⁴: ―Jm² sa⁴júan³ˉ¹ ta¹pa² jnia¹ ne³⁴; sa⁴ra³cúa²³ i⁴canh²ˉ³ a²hyei²³ quianh³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","I² jon³ a⁴ŋangh³ a³ñih³ hain⁴: ―A³hain⁴ a³a⁴júan⁴ a⁴huan⁴ quien⁴ˉ⁴, a⁴sag⁴³i³ jnia⁴: “Sieh¹ a²hyei²³ quianh³, jian³ ŋeng² liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Conh⁴liah⁴ a⁴ŋang⁴ a³hain⁴ tionh²: ―¿Hain³ a³a⁴juah⁴ la⁴ne³: “Sieh¹ a²hyei²³ quianh³, jian³ ŋeng²”? ");
INSERT INTO cucNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","I² hei⁴i³ ne⁵, sa⁴ñi³i³ hain³ hain⁴ a⁴júan⁴ a⁴huan⁴ quieh¹i³, quie¹ a⁵sian⁴³ Jesús ma⁵sian³ jen² chie³ a³tionh² i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","I² coh⁵ jon³ a⁴jainh³ Jesús a³hain⁴ cuah³júah², jian³ a⁴sagh⁴³i³: ―Jeh³², tieh²la³ ma³a⁴huan⁴ quianh³ˉ³; a⁵ma⁵ta⁵canh¹ chie³², canh⁴a² sa⁴quionh⁴ˉ³ si¹jeu⁴ la⁴conh⁴a² ma²jia⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","I² jon³ ŋah³ a³ñih³ hain⁴ quieh¹, jian³ a⁴júan⁴i³ jau²³ i²con²³ judío i⁴ Jesús pa² a³hain⁴ a³a⁴júan⁴ i⁴a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","I² nei² ne³ a⁴hag⁴ judío, a⁴hang⁴i³ Jesús i⁴hnie³⁴i³ jŋangh³i³, quie¹ júan³i³ la⁴jon³ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","I² Jesús ne⁵, a⁴juah⁴i³: ―Neih³ jnia⁴ júan³ ta¹ la⁴teg⁴ tieh²la³, jian³ jnia⁴ liah⁴ júan³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","I² la⁴ne³ jon³ tsei³⁴sa² hnie³⁴ judío tionh² jŋangh³ quieh¹i³, quie¹ júan³i³ lang⁴³i³ Jon⁴dai¹ i⁴juah⁴i³ Jmai³i³ Jon⁴dai¹, a⁵jon⁴³ jmah³ nei² quieh¹ i⁴ua³tsei³²i³ lai²³ quieh¹ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i¹con³ sa⁴li⁴júan³⁴ A³jon⁴³ Jon⁴dai¹ con⁴juah⁴ i⁴júan³i³ hña³; quie¹ júan³i³ la⁴conh⁴ je²³i³ i⁴júan³ Jmai³i³. Jian³ la⁴jeg³⁴ i⁴júan³ Jmai³i³, la⁴jon³ júan³ A³jon⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Quie¹ hnio³⁴ Jmai³i³ A³jon⁴³, jian³ heh²i³ A³jon⁴³ la⁴jeg³⁴ i⁴júan³i³ liah⁴; jian³ he³⁴ pi¹ Jmai³i³ i⁴tyein²ga² júah³, canh⁴a² chie³⁴ co³ hoh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Quie¹ liah⁴i² júan³ Jmai³i³ i⁴hyon⁴³ a³jaun² jian³ i⁴cúa²³i³ m⁵cu³ quieh¹, la⁴ne³pa² A³jon⁴³i³ liah⁴ cúa²³ m⁵cu³ quieh¹ la⁴jang³⁴ a³hnie³⁴i³ cúah³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jian³ a⁵sia³ can²³ Jmai³i³ jau²chie⁴³ i²con²³ i¹jan³, quie¹ ma³a⁴tonh³i³ joh⁴³ cúa³ A³jon⁴³i³ i⁴can³⁴i³ jau²chie⁴³, ");
INSERT INTO cucNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","canh⁴a² la⁴jang³⁴ ma⁵con⁴³ A³jon⁴³i³ liah⁴i² ma³con⁴³i³ Jmai³i³. A³hain⁴ a³sa⁴ma³con⁴³ A³jon⁴³i³, sa⁴ma³con⁴³i³ Jmai³i³ liah⁴ a³a⁴sai⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³nau³ jau²³ quien⁴ˉ⁴ jian³ hain⁴i³ i²con²³ a³a⁴sai⁴ jnia⁴, sia³ m⁵cu³ quieh¹i³ sa⁴ton³ jm² ua²tya⁴³; a⁵sia³ si⁵hain⁴i³, quie¹ ma³sian³i³ i⁴ma²jaun²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i⁴ja³⁴ jm² jian³ ma³a⁴tyie³⁴ tieh²la³pa², tei⁴³i² nau³⁴ la⁴jang³⁴ la⁴jan³ a³ti²jaun² jau²³ quieh¹ A³jon⁴³ Jon⁴dai¹; jian³ la⁴jang³⁴ a³ro³⁴ jeu³ jau²³ jon³, li⁴sia³ m⁵cu³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Quie¹ Jon⁴dai¹ Jmai³ lang⁴³ o¹sieh³² m⁵cu³ i⁴cúa²³i³ i²con²³ chie³, jian³ a⁴tonh³i³ joh⁴³ cúa³ A³jon⁴³i³ i⁴cúa³⁴i³ i²con²³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jian³ a⁴cúa⁴i³ heih⁴³ i⁴can³⁴i³ jau²chie⁴³ i²con²³ la⁴jang³⁴, quie¹ ta⁵la⁴ lang⁴³i³ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jian³ sa⁴hniah³ chie³⁴ ja³ co³ hoh⁴³ˉ³ tionh²ˉ³ jau²³ ne³, quie¹ jia²³ jm² la⁴teg⁴i² nau³⁴ la⁴jang³⁴ a³jaun² jau²³ ho³²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jian³ la⁴jang³⁴ a³a⁴júan⁴ i⁴tsei³⁴, hyon⁴³i³ i⁴hyieh⁴i³ m⁵cu³ quieh¹; i² la⁴jang³⁴ a³a⁴júan⁴ i⁴hlagh³², hyon⁴³i³ i⁴si⁵hain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Jian³ jnia⁴ húan⁵, i¹con³ a⁵sia³ i⁴li⁴júan³²ˉ⁴. Quie¹ can³⁴ˉ⁴ jau²chie⁴³ la⁴conh⁴ i⁴nau³⁴ˉ⁴ i²con²³ Neih³ˉ⁴, jian³ can³⁴ˉ⁴ jau²chie⁴³ la⁴conh⁴ ni²tei⁴³, quie¹ a⁵sia³ júan³⁴ˉ⁴ con⁴juah⁴ i⁴hno⁵ˉ⁵ húan⁵, quie¹ júan³⁴ˉ⁴ la⁴conh⁴ i⁴hnie³⁴ Neih³ pe²³ˉ⁴, a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jian³ juah⁴ne³ jan³ jnia⁴pa² ma²hleh³ˉ⁴ nei² quien⁴ˉ⁴ húan⁵, a⁵sia³ ma²quein⁴³ la⁴jeg³⁴ i⁴hleh³ˉ⁴ ne³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Quie¹ sian³ i²jan³ a³hleh² nei² quien⁴ˉ⁴, jian³ yan³²ˉ⁴ i⁴hleh² a³hain⁴ nei² quien⁴ˉ⁴ i⁴chie⁴³ quein⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jian³ hnei³ tionh²ˉ³ a⁴sainh⁴³ˉ³ chie³ a³ni²ŋangh² Juan²³ nei² quien⁴ˉ⁴; i² hei⁴i³ ne⁵, i⁴chie⁴³pa² jau²³ i⁴a⁴jainh³i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jian³ a⁵sia³ hniah³ hleh³ chie³ ton³²nie⁴³ nei² quien⁴ˉ⁴; jon³pa² juah³ˉ⁴ jau²³ la³ canh⁴a² lionh⁴ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan²³ hain⁴ ma²lang⁴³ liah⁴i² leg⁴³ con³ a²hma³ tyi¹ jyi³ i⁴ya¹co²³, ya¹júan³ joh¹, jian³ ta² si³hyonh³ˉ³ a⁴tangh³ˉ³ joh¹ quieh¹i³ co⁴le⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Quie¹ sia³ con³ i⁴júan³ lei³ nei² quien⁴ˉ⁴ la⁴conh⁴a² i⁴a⁴hleh⁴ Juan²³. Quie¹ la⁴jeg³⁴ i⁴a⁴juah⁴ Neih³ˉ⁴ i⁴hniah³ júan³²ˉ⁴, la⁴jeg³⁴ ne³, ra³he²³ nei² quien⁴ˉ⁴ i⁴chie⁴³ a⁴sai⁴ jnia⁴ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Conh⁴liah⁴ Neih³ˉ⁴, a³a⁴sai⁴ jnia⁴, júan³i³ lei³ i⁴ra³he²³ nei² quien⁴ˉ⁴, ua²liah⁴a² sa⁴ma³a⁴naih³ˉ³ jau²³ ho³²i³ jian³ sa⁴ma³a⁴jenh³²i³ hnei³ liah⁴ jnia⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Jian³ sa⁴ma³ta⁴ton³² hoh⁴³ˉ³ jau²³ quieh¹i³ tionh²ˉ³, quie¹ sa⁴hnoh³ˉ³ li⁴hainh⁴ˉ³ i²con²³ a³hain⁴ a³a⁴sain⁴ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Re³ ma⁴tang²³ hnei³ Ma²jyi³ ti²sag² jau²³ quieh¹ Jon⁴dai¹, quie¹ lainh⁴ˉ³ i⁴tyanh³²ˉ³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quianh³ˉ³ tionh²ˉ³ con⁴juah⁴ Ma²jyi³ jon³; jian³ Ma²jyi³ jon³pa² ti²hleh² nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","I² sa⁴hnoh³ˉ³ tionh²ˉ³ niah²ˉ³ i²con²³ jnia⁴ canh⁴a² tyanh³²ˉ³ m⁵cu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Jian³ a⁵sia³ hnoh³²ˉ⁴ i⁴sainh³ˉ⁴ re³ i²con²³ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Quie¹ cm⁴³ jnia⁴ hnei³ tionh²ˉ³, jian³ yan³²ˉ⁴ i⁴sa⁴hnoh⁴³ˉ³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Quie¹ cuan⁵ jnia⁴ nei² quieh¹ Neih³ˉ⁴, i² hnei³ tionh²ˉ³ sa⁴hyeih⁵ˉ³ jnia⁴; i² juah⁴ne³ ja³⁴ jan³ nei² quieh¹ hña³, a³hain⁴pa² hnoh³ˉ³ hyeinh³²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Liah⁴a² li⁴hainh⁴ˉ³ tionh²ˉ³, quie¹ hnoh⁴ˉ³ i⁴sainh³ˉ³ tsei³⁴ i²con²³ a³jan³ jan³, quie¹ sa⁴hnoh⁴ˉ³ i⁴sainh³ˉ³ re³ i²con²³ Jon⁴dai¹ a³jan³ hain⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sa⁴hniah³ júanh²ˉ³ co³hei²tsei³ juah⁴ i⁴jnia⁴pa² hnang²³ hnei³ i²con²³ Neih³ˉ⁴; quie¹ sian³pa² a³hnang⁵ hnei³, M³se²³ hain⁴, a³hain⁴ a³hangh⁵ˉ³ hoh⁴³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Quie¹ juah⁴ne³ ma²ra⁵hainh⁴ˉ³ i⁴a⁴juah⁴ M³se²³, la⁴jon³ ma²li⁴hainh⁴ˉ³ i²con²³ jnia⁴ liah⁴, quie¹ nei² quien⁴ jnia⁴pa² a⁴sag⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","I² juah⁴ne³ sa⁴hainh⁴ˉ³ la⁴conh⁴ i⁴a⁴sag⁴i³, ¿liah⁴a² li⁴hainh⁴ˉ³ jau²³ quien⁴ˉ⁴, juah⁴ne³ la⁴jon³? ");
INSERT INTO cucNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Con³ma²ua⁴jeu³² jon³, jon³ ŋo³⁴ Jesús ta⁵hŋoh³ jm³ñei³ Galilea i⁴teh²i³ jm³ñei³ Tiberias liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jian³ ta² jeun⁴³ chie³ si³han² coh⁵cah³²i³, quie¹ je²³i³ la⁴jeg³⁴ ua³júah² i⁴huan⁴ quieh¹ a³chieh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","I² jon³ ŋo³⁴ Jesús con³ mah⁴, jian³ a⁴cua⁴i³ i²jon³ jian²³ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jian³ ma³hloh³² jm² i⁴júan³ judío tionh², jm² i⁴a⁴lon⁴ jmai³sie²³i³ húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","I² con³ma²a⁴je³⁴ Jesús, a⁴jen³i³ jeun⁴³ chie³ a³ja²³ hlonh²i³, jon³ a⁴sagh⁴³i³ Lei³²: ―¿Jainh¹ si²lia³² jnia¹ i⁴queuh⁴³ la⁴jang³⁴ chie³ ne³ tionh²? ");
INSERT INTO cucNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quie¹ a⁴juah⁴ Jesús la⁴ne³ i⁴con²³i³ jau²chie⁴³ canh⁴a² hain³liah⁴ juah⁴ Lei³², quie¹ ma³ñi³ re³ pi²³i³ hain³liah⁴ júan³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","I² jon³ a⁴ŋangh³ Lei³²: ―Sa⁴teg³⁴ pi¹ teun³⁴ nia⁴lo⁴ o¹cau³² denario a²hei⁴³ñih¹ i⁴queuh⁴³i³ ma⁵ca³leuh² la⁴jang³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jon³ a⁴juah⁴ Dre¹, chie³ i²jan³ quian¹ Jesús, a³reunh¹ Si²úan¹ Pe³², a⁴sagh⁴³i³ Jesús: ");
INSERT INTO cucNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―I²la³ sainh⁴³ jan³ a³peih¹ ñih³ a³quian³ hña⁴ a²hei⁴³ñih¹ i⁴leg⁴³ cebada jian³ on³⁴ jon⁴³júa³²; jeh³², ¿liah⁴ li⁴teg³⁴ quieh¹ la⁴jang³⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","I² jon³ a⁴juah⁴ Jesús: ―Saih³² hnei³ la⁴jang³⁴ chie³ ua²cua⁴i³. Jian³ jmah³ o¹ñei³ peih¹ leg⁴³ i²jon³; i² jon³ a⁴cua⁴ la⁴conh⁴ hña⁴ mai²³ a³ñih³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jian³ ma²jon³ a⁴tang⁴ Jesús a²hei⁴³ñih¹ jon³, i² con³ma²a⁴cúa⁴i³ ti²hmah³² i²con²³ Jon⁴dai¹, jon³ a⁴cúah³i³ chie³ quian¹, i² chie³ quian¹i³ a⁴tyieh⁵ i²con²³ la⁴jang³⁴ a³ti²tionh² hain⁴. Jian³ la⁴jon³ a⁴júan⁴i³ jon⁴³júa³² hain⁴ liah⁴, a⁴cúah³i³ la⁴conh⁴ hnie³⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","I² con³ma²a⁴lag³⁴ tsei⁴³i³ a⁴queuh³i³, i² jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ chie³ quian¹: ―Jaih¹ hnei³ o¹leuh² i⁴a⁴sion³⁴, canh⁴a² sa⁴si⁵hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jon³ a⁴jaih³i³ o¹leuh² jon³, jian³ a⁴canh³ quia⁵teun⁴ a²mh³ta²³ o¹leuh² li⁵hña⁴ a²hei⁴³ñih¹ cebada jon³ i⁴a⁴sion³⁴ i⁴a⁴queuh³ la⁴jang³⁴ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","I² chie³ hain⁴ tionh², con³ma²a⁴je³⁴i³ ua³júah² i⁴a⁴júan⁴ Jesús, jon³ a⁴juah⁴i³: ―I⁴chie⁴³ lang⁴³ a³ne³ jan³ a³sain² quian¹ Jon⁴dai¹ a³ma²jia²³ m⁵cu³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","I² Jesús ne⁵, ra⁵laih²i³ i⁴ma²te⁴³ chie³ quieh¹i³ ta⁵li⁴hnai³ i⁴si⁵lain⁴i³ re¹, jon³ a⁴tain³⁴i³ a³hain⁴ tionh², ŋo³⁴i³ hña³ teg⁴ nei² mah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","I² con³ma²ma³si³naih³, jon³ a⁴jyon²³ chie³ quian¹ Jesús la⁴teg⁴ jm³ñei³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","I² jon³ a⁴han⁵i³ con³ joh⁴³ a²úan⁴³, ua⁵han²i³ ta⁵hŋoh³, i⁴tyie¹i³ jeu³ Capernaum. Jian³ ta² ma³naih³; i² Jesús ne⁵, a⁵sia³ ma³jonh² jen²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","I² jon³ a⁴hag⁴ tyi⁴ tia⁴ nei² jm³ jon³, a⁴hlan³⁴ jm³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","I² con³ma²a⁴ŋeng⁴i³ la⁴conh⁴ teun³⁴ mai²³ ton⁴ ñi⁴ jian³ o⁴ hneng³ mai²³ ñi⁴, jon³ a⁴jen³i³ Jesús ya¹ŋeng²³ jeu³ nei² jm³ i²ja¹i³ hloh³² a²úan⁴³; jian³ ta² yi⁴hag³² tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","I² jon³ a⁴juah⁴ hei⁴i³: ―¡Jnia⁴pa² la³, a⁵júan³ hnei³ canh⁴³ tionh²ˉ³! ");
INSERT INTO cucNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","I² hei⁴i³ tionh², ta² si³hyonh³i³ a⁴hyein⁴³i³ Jesús joh⁴³ a²úan⁴³, jian³ liah⁴ma²jon³ a⁴tyie³⁴i³ i²ma²hnie³⁴i³ chie³⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","I² con³ma²a⁴jnia³⁴, jon³ ra⁵laih² chie³ a³ma²a⁴jian⁴ ta⁵ca³jo³² jm³ñei³ hain⁴ tionh² i⁴ua⁵han² chie³ quian¹ Jesús húan⁴, jeu³ joh⁴³ a²úan⁴³, i⁴con³ jon³ ma²ra³quia³, i⁴sa⁴jian²³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ta¹la⁴ jon³ a⁴tyie³⁴ co⁴meih³ a²úan⁴³ seg³⁴ i⁴ja³⁴ ta⁵jeu³ Tiberias, i⁴a⁴tyie³⁴ hloh³² i²ma²a⁴queuh³i³ a²hei⁴³ñih¹ ta⁵ma³a⁴cúa⁴ Se³ño²³ ti²hmah³² i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","I² con³ma²a⁴je³⁴ chie³ hain⁴ tionh² i⁴a⁵sie⁴³ si²sainh⁴³ Jesús i²jon³ jian³ a⁵ga⁴ chie³ quian¹i³ liah⁴, jon³ a⁴han⁵i³ la⁴jeg³⁴ a²úan⁴³ seg³⁴ jon³, ua⁵han²i³ ta⁵jeu³ Capernaum ua⁵hniah³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","I² con³ma²a⁴chianh¹i³ Jesús jo³² ta⁵hŋoh³ jm³ñei³ jon³, jon³ a⁴sagh⁴³i³: ―Hnei³ A²teg²³, ¿ma³legh⁴ cuanh³ˉ³ ta⁵la³? ");
INSERT INTO cucNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, ti²hnoh⁵ˉ³ jnia⁴ tionh²ˉ³ quie¹ a⁴cauh⁴³ˉ³ liah⁴a² a⁴canh³ heinh¹ˉ³, a⁵jon⁴³ quieh¹ i⁴a⁴quienh³ hoh⁴³ˉ³ ua³júah² i⁴a⁴jeh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jian³ sa⁴hniah³ hnoh²ˉ³ ma³⁴ i⁴tya³ ta¹tia⁴; ma³⁴ jon³pa² hniah³ hnoh²ˉ³ i⁴sa⁴tya³ jian³ i⁴cúa²³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³, i⁴cúa³⁴ A³a⁴lang³⁴ Chie³ hain⁴, quie¹ Jon⁴dai¹ Jmai³ ma³a⁴júan⁴ lei³ i⁴quian³ a³hain⁴ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","I² jon³ a⁴juah⁴i³ tionh²: ―¿Henh⁴ hniah³ júan² jnie³² i⁴ma²tei³² jnie³² heih⁴³ quieh¹ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―I⁴la³pa² hnie³⁴ Jon⁴dai¹ júanh²ˉ³, i⁴hniah³ li⁴hainh⁴ˉ³ i²con²³ a³a⁴sain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","I² jon³ a⁴ŋang⁴i³ liah⁴: ―¿Henh⁴ júanh²ˉ³ lei³, canh⁴a² niah¹ jnie³² jian³ li⁴hain⁴ jnie³² i²conh²ˉ³ liah⁴? ¿Henh⁴ júanh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Quie¹ jmai³sie²³ jnie³² a⁴queuh³ maná i²a⁵sian⁴³ a³sian³ jon³ liah⁴i² ra³sag² Ma²jyi³: “A⁴cúa⁴ Jon⁴dai¹ a²hei⁴³ñih¹ quieh¹ ñi⁴jeu⁵ a⁴queuh³i³.” ");
INSERT INTO cucNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a⁵hei⁴³ M³se²³ a⁴cúa⁴ a²hei⁴³ñih¹ i⁴ja³⁴ ñi⁴jeu⁵, quieh¹ Neih³ pe²³ˉ⁴ cúa²³ a²hei⁴³ñih¹ i⁴ja³⁴ ñi⁴jeu⁵ i⁴chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Quie¹ a²hei⁴³ñih¹ i⁴cúa²³ Jon⁴dai¹ jon³ lang⁴³ a³hain⁴ a³ja²³ ñi⁴jeu⁵ jian³ júan³i³ i⁴sian³ a³tionh² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―Hnei³ Se³ño²³, cúa² hnei³ a²hei⁴³ñih¹ jon³ quian⁴ jnie³² la⁴jeg³⁴ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","I² jon³ a⁴juah⁴ Jesús: ―Jnia⁴pa² lang⁴³ a²hei⁴³ñih¹ i⁴cúa²³ m⁵cu³ quieh¹ chie³. A³hain⁴ a³jia²³ i²con²³ jnia⁴, sa⁴legh⁴ ua²ra⁵cúanh⁴³i³; jian³ a³hain⁴ a³hain⁴ i²con²³ jnia⁴, sa⁴legh⁴ ua²ra⁵quein³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jian³ liah⁴i² ma³a⁴jeu³⁴ˉ⁴ hnei³ liah⁴, ua²liah⁴a² ti²jeh⁵ˉ³ jnia⁴ tionh²ˉ³, sa⁴hainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","La⁴jang³⁴ a³cúan⁴³ Neih³ˉ⁴, jia²³i³ i²con²³ jnia⁴; jian³ a³hain⁴ a³ja²³ i²con²³ jnia⁴, a⁵sia³ ton²³ˉ⁵ ta⁵co⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Quie¹ a⁵jon⁴³ i⁴jon³ a⁴nia³⁴ jnia⁴ ñi⁴jeu⁵ juah⁴ i⁴júan¹ˉ⁴ i⁴hno⁵ˉ⁵ húan⁵, quie¹ i⁴jon³pa² i⁴júan¹ˉ⁴ i⁴hnie³⁴ a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jian³ i⁴la³pa² heih⁴³ quieh¹ Neih³ˉ⁴ a³a⁴sai⁴ jnia⁴, i⁴la⁴jang³⁴ a³cúan⁴³i³ i²con²³ˉ⁵, sa⁴si⁵hain⁴ i¹jan³, quie¹ hniah³ júan¹ˉ⁴ i⁴hyon⁴³i³ la⁴teg⁴ i²a⁴toh⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jian³ i⁴la³pa² heih⁴³ quieh¹ a³a⁴sai⁴ jnia⁴ liah⁴, i⁴la⁴jang³⁴ a³jen⁴³ A³jon⁴³i³ jian³ hain⁴i³ i²con²³i³, hyieh⁴i³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³, jian³ júan¹ jnia⁴ i⁴hyon⁴³i³ la⁴teg⁴ i²a⁴toh⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","I² judío tionh² ne⁵, a⁴si⁴hen⁴³i³ Jesús, quie¹ juah⁴i³: “Jnia⁴pa² lang⁴³ a²hei⁴³ñih¹ i⁴ja³⁴ ñi⁴jeu⁵.” ");
INSERT INTO cucNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jian³ a⁴júanh⁴i³ tionh²: ―¿O⁴ a⁵hei⁴³ Jesús a³jon⁴³ Se¹ hain⁴ ne³, lainh⁴ˉ³? Quie¹ cm⁴³ jnia¹ jmai³i³ jian³ sie²³i³ liah⁴. ¿I² liah⁴ cúan²³ juah⁴i³: “A⁴nia³⁴ jnia⁴ ñi⁴jeu⁵”? ");
INSERT INTO cucNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―A⁵si⁵he⁴³ jnia⁴ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","I¹jan³ sa⁴li⁴jia²³ i²con²³ jnia⁴, a¹juah⁴ne³ sa⁴a⁴te⁴ Neih³ˉ⁴ a³a⁴sai⁴ jnia⁴; jian³ júan³²ˉ⁴ i⁴hyon⁴³ a³hain⁴ la⁴teg⁴ i²a⁴toh⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Quie¹ ra³sag² ma²jyi³ quieh¹ a³sain² quian¹ Jon⁴dai¹: “Heh³ Jon⁴dai¹ la⁴jang³⁴.” I² la⁴ne³ la⁴jang³⁴ a³a⁴nau⁴ jau²³ quieh¹ Neih³ˉ⁴ jian³ ra⁵tang³i³ i²con²³i³, jia²³i³ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’A⁵jon⁴³ quie¹ i⁴sian³ a³ma³a⁴jen³ Neih³ˉ⁴; quie¹ a³hain⁴pa² a⁴je³, a³ja²³ i²con²³ Jon⁴dai¹pa². ");
INSERT INTO cucNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³hain⁴ i²con²³ jnia⁴, sia³ m⁵cu³ quieh¹i³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jnia⁴pa² lang⁴³ a²hei⁴³ñih¹ i⁴júan³ i⁴sian³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Quie¹ naih⁴³sieh³ˉ³ tionh²ˉ³, a⁴queuh³i³ a²hei⁴³ñih¹ maná i²a⁵sian⁴³ a³sian³ jon³, jian³ a⁴chian³⁴ pi²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Quie¹ hleh³ˉ⁴ nei² quieh¹ a²hei⁴³ñih¹ i⁴ja³⁴ ñi⁴jeu⁵ jon³, canh⁴a² la⁴jang³⁴ a³queuh³ a²hei⁴³ñih¹ jon³, sa⁴jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Húan⁵pa² jnia⁴ lang⁴³ a²hei⁴³ñih¹ sian³ i⁴ja³⁴ ñi⁴jeu⁵; la⁴jang³⁴ a³queuh³ a²hei⁴³ñih¹ la³, sian³i³ sa⁴ton³ jm² jaun⁴i³. Jian³ a²hei⁴³ñih¹ i⁴cúa¹ˉ⁴ jon³ leg⁴³ he³⁴ˉ⁴ húan⁵, i⁴cúa¹ˉ⁴ canh⁴a² li⁴sian³ a³tionh² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jon³ a⁴jang²³ judío húan⁴ tionh², a⁴juah⁴i³: ―¿Liah⁴ cúan²³ li⁴cúa³⁴ a³ne³ he³² hña³ i⁴quih³²ˉ¹, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a¹juah⁴ne³ sa⁴a⁴cauh⁴³ˉ³ he³² A³a⁴lang³⁴ Chie³ hain⁴, jian³ juah⁴ne³ sa⁴a⁴hainh⁴ˉ³ jm³yein⁴ quieh¹i³, sa⁴li⁴sia³ m⁵cu³ quianh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Quie¹ a³hain⁴ a³queuh³ he³⁴ˉ⁴ jian³ hangh²i³ jm³yein⁴ quien⁴ˉ⁴, sia³ m⁵cu³ quieh¹i³ sa⁴ton³ jm² ua²tya⁴³; jian³ júan³²ˉ⁴ i⁴hyon⁴³i³ i²a⁴toh⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quie¹ he³⁴ jnia⁴pa² leg⁴³ con³ ma³⁴ i⁴chie⁴³, jian³ jm³yein⁴ quien⁴ jnia⁴pa² leg⁴³ con³ i⁴hangh²i³ i⁴chie⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Quie¹ a³hain⁴ a³queuh³ he³⁴ jnia⁴ jian³ hangh²i³ jm³yein⁴ quien⁴ˉ⁴, hein²i³ naih⁵ ni²tsei³⁴ˉ⁴, jian³ hein³² jnia⁴ naih⁵ ni²tsei⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Quie¹ la⁴jon³ liah⁴i² a⁴sai⁴ jnia⁴ Neih³ˉ⁴ a³sian³, jian³ sian³⁴ jnia⁴ con⁴juah⁴ hei⁴i³, jian³ la⁴ne³pa² liah⁴, a³hain⁴ a³queuh³ he³⁴ˉ⁴, li⁴sian³i³ con⁴juah⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","I⁴ne³pa² a²hei⁴³ñih¹ ja³⁴ ñi⁴jeu⁵, a⁵jon⁴³ liah⁴ a²hei⁴³ñih¹ maná i⁴a⁴queuh³ naih⁴³sieh³ˉ³ tionh²ˉ³, jian³ a⁴chian³⁴i³; quie¹ a³hain⁴ a³queuh³ a²hei⁴³ñih¹ la³, sian³i³ sa⁴ton³ jm² jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","A⁴he⁴ Jesús jau²³ la³ cuah³ judío jeu³ Capernaum. ");
INSERT INTO cucNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","I² con³ma²a⁴nau⁴ jeun⁴³ chie³ a³ya¹han² coh⁵cah³² Jesús, jon³ a⁴juah⁴i³ tionh²: ―Ta² jeuh⁴³ nie⁴³ jau²³ i⁴hleh²i³ ne³. ¿Hain³ lei⁴ li⁴hyei³⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jon³ ra⁵laih² Jesús i⁴ti²he⁴³ chie³ quieh¹i³ nei² jon³, jon³ a⁴ŋang⁴i³: ―¿O⁴ hianh³² hnei³ jau²³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Jeh³², ¿liah⁴a² li⁴lainh⁴ˉ³ juah⁴ne³ jenh³²ˉ³ A³a⁴lang³⁴ Chie³ hain⁴ ŋah³i³ i²ma²cua⁴³i³ liah⁴ma²jia⁴³? ");
INSERT INTO cucNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Quie¹ m⁴tyi⁴pa² cúa²³ m⁵cu³; i¹con³ a⁵sia³ ta¹ tei⁴³ he³²ˉ¹. Quie¹ la⁴jeg³⁴ jau²³ i⁴ma³a⁴juah³ˉ⁴ ne³, leg⁴³ jmah³ i⁴tain⁴³ m⁴tyi⁴ jian³ i⁴cúa²³ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jian³ sian³ pi¹ co⁴meih³ jenh²ˉ³ tionh²ˉ³ a³sa⁴hain⁴. Quie¹ ñi³ Jesús liah⁴ma²ra⁴lie⁵ hain³ hain⁴ sa⁴li⁴hain⁴, jian³ hain³ hain⁴ a³cúah⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","I² jon³ a⁴juah⁴i³: ―I⁴jon³pa² a⁴juah³ˉ⁴ la⁴ne³, quie¹ i¹jan³ sa⁴li⁴jia²³ i²con²³ jnia⁴, juah⁴ne³ sa⁴a⁴te⁴ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jian³ liah⁴ma²jm² jon³, jeun⁴³ a³ma²ya¹han² coh⁵cah³²i³, a⁴ton³⁴ quieh¹i³, a⁵sie⁴³ a⁴ŋeng⁴i³ jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","I² jon³ a⁴ŋang⁴ Jesús i²con²³ quia⁵teun⁴ chie³ quian¹: ―¿O⁴ hnoh³ˉ³ jainh²ˉ³ mah² tionh²ˉ³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","I² jon³ a⁴ŋangh³ Si²úan¹ Pe³², a⁴juah⁴i³: ―Hnei³ Se³ño²³, ¿hain³ i²con²³ ma⁵li⁴chie² jnie³²? Quie¹ jau²³ quianh³ˉ³ leg⁴³ jau²³ quieh¹ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jian³ ma³ra⁵hain⁴ jnie³² jian³ nia² jnie³² i⁴langh⁴³ hnei³ A³ya⁴lion³² Chie³ hain⁴, A³jon⁴³ Jon⁴dai¹ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","I² jon³ a⁴juah⁴ Jesús liah⁴: ―¿Sa¹ chie⁴³ a⁴quianh³²ˉ⁴ quia⁵teun⁴ hnei³ tionh²ˉ³, liah²? I² jan³ hnei³ tionh²ˉ³ lang⁴³ jan³ a³sa⁴tsein³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Quie¹ a⁴hleh⁴ Jesús jau²³ ne³ i⁴a⁴hen⁴³i³ Judas Iscariote pa², a³jon⁴³ Si²úan¹, quie¹ a³ne³pa² hain⁴ a³cúah⁴³ quieh¹i³, ua²liah⁴a² lang⁴³i³ jan³ a³hein² jen² quia⁵teun⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Con³ma²a⁴leg³⁴ jon³, jon³ a⁴ŋeng⁴ Jesús húa³⁴ Galilea; quie¹ sa⁴hnie³⁴i³ chie³⁴i³ húa³⁴ Judea, quie¹ i²jon³ hnie³⁴ judío jŋangh³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jian³ ma³ja²³ jm² i⁴júan³ judío tionh², jm² quieh¹ cuah²hnei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","I² jon³ a⁴juah⁴ si³reunh¹i³: ―A⁵jian³ hnei³ i²la³; cua³ hnei³ teg⁴ húa³⁴ Judea, canh⁴a² la⁴jang³⁴ chie³ quianh³ˉ³ a³tionh² i²jno³ je³⁴i³ i⁴júanh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Quie¹ juah⁴ne³ hnie³⁴ jan³ chie³ li⁴cu²³ chie³ quieh¹i³, sa⁴júan³i³ i⁴ni²hma² la⁴jeg³⁴ i⁴júan³i³. Jian³ juah⁴ne³ júanh³ˉ³ la⁴ne³, hniah³ ma²jniah³²ˉ³ ta⁵nei² la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Quie¹ la⁴jang³⁴ si³reunh¹i³ sa⁴ra⁵hain⁴i³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","I² jon³ a⁴juah⁴ Jesús: ―A⁵sia³ ma³a⁴tyie³⁴ jm² quien⁴ˉ⁴, i² hnei³ tionh²ˉ³, la⁴jeg³⁴ jm²pa² tsei³⁴ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Quie¹ sa⁴li⁴ma⁵hie²³ hnei³ a³m⁵cu³ tionh²ˉ³; i² jnia⁴pa² ma³hie²³i³, quie¹ ta⁵la⁴ ma⁵jnia³²ˉ⁴ i⁴hlagh³² ti²júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cua³ ua⁴han² hnei³ tionh²ˉ³ jm²; i² jnia⁴ ne⁵, a⁵sia³ nai³²ˉ⁴, quie¹ sa⁴ma³a⁴teg⁴ i²tyie¹ jm² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","I² con³ma²a⁴sagh⁴³i³ a³hain⁴ tionh² jau²³ jon³, jon³ a⁴jian⁴i³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jian³ ta⁵ma³ua⁵han² si³reunh¹ Jesús, jon³ ŋo³⁴ Jesús liah⁴ jm²; i² a⁵sia³ ŋo³⁴i³ jeu³ ni²jnia³, quie¹ ŋo³⁴i³ jeu³ ta⁵si²hma². ");
INSERT INTO cucNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","I² judío tionh² ne⁵, ti²hnoh³i³ quieh¹i³ jm² jon³, ti²júanh⁴i³: ―¿Jainh¹ pi¹ sainh⁴³ a³hain⁴, liah²? ");
INSERT INTO cucNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jian³ jeun⁴³ chie³ ti²hleh² nei² quieh¹ hei⁴i³. Ca³chion²³ ti²hleh²: “Chie³ tsein²³pa² hain⁴”; conh⁴liah⁴ i²ca³chion²³ juah⁴: “A⁵sia³, quie¹ a³ma³can³ chie³pa² hain⁴.” ");
INSERT INTO cucNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","I² i¹jan³ sa⁴i²hleh³ ra³jia⁵ nei² quieh¹ hei⁴i³, quie¹ ta⁵la⁴ con⁴³i³ judío. ");
INSERT INTO cucNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I² con³ma²a⁴teg⁴ to⁵chieh³² jm² jon³, jon³ a⁴hei³⁴ Jesús cuah³júah², jian³ a⁴he⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jian³ ta² co³ ŋo³⁴ tsei⁴³ judío tionh², a⁴juah⁴i³: ―¿Liah⁴ na²o⁴ hlion⁴ ŋang⁴ a³ne³, jian³ a⁵sia³ ga⁴ ma⁴tang²³i³? ");
INSERT INTO cucNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I² jon³ a⁴juah⁴ Jesús: ―La⁴jeg³⁴ i⁴he³⁴ˉ⁴ ne³, a⁵jon⁴³ i⁴quien⁴ˉ⁴, i⁴quieh¹ a³hain⁴pa² a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","A³hain⁴ a³hnie³⁴ júan³⁴ i⁴teg³ tsei⁴³ Jon⁴dai¹, li⁴laih² tsei⁴³i³ i⁴he³⁴ˉ⁴ la³, juah⁴ i⁴leg⁴³ jau²³ quieh¹ Jon⁴dai¹ jian³ o⁴ jau²³ quien⁴ˉ⁴ húan⁵pa². ");
INSERT INTO cucNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Quie¹ a³hain⁴ a³hleh² con⁴juah⁴ co³hei²tsei³ quieh¹ hña³, hleh²i³ canh⁴a² júan³⁴ chie³ i⁴júanh⁴³i³; i² a³hain⁴ a³hnie³⁴ júan³⁴ júanh⁴³ a³a⁴sai⁴ quieh¹i³, a³hain⁴pa² hleh² conh⁴ ni²tei⁴³, jian³ i¹con³ i⁴hlagh³² sa⁴júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Sa¹ chie⁴³ a⁴cúa⁴ M³se²³ lai²³ i²conh²ˉ³ tionh²ˉ³? Jian³ i¹jan³ hnei³ sa⁴ma⁵teih³²ˉ³ lai²³. ¿Quie¹ e⁴le³⁴ hnoh³ˉ³ jŋangh¹ˉ³ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","I² jon³ a⁴ŋangh³ chie³ jeun⁴³ hain⁴ tionh², a⁴juah⁴i³: ―Quianh² m⁴tyi⁴ hlagh³²pa² hnei³. ¿Hain³ hnie³⁴ jŋangh³ hnei³? ");
INSERT INTO cucNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","I² jon³ a⁴juah⁴ Jesús: ―Quie¹ eu⁴³ co³ ŋo³⁴ hoh⁴³ˉ³ tionh²ˉ³ con³ ua³júah² i⁴a⁴júan³⁴ˉ⁴ jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","I⁴chie⁴³pa² a⁴júan⁴ M³se²³ heih⁴³ i⁴gm⁴³ he³² chie³ (jian³ a⁵jon⁴³ juah⁴ i⁴ma⁴lie⁵ M³se²³, quie¹ i⁴ma⁴lie⁵ jmai³sie²³pa² jnia¹ tionh²); jian³ ua²liah⁴a² jm² sa⁴júan³i³ ta¹ liah⁴, teih³ˉ³ he³² si³yein³ ñih³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","I² jon³ ne⁵, juah⁴ne³ gm³ he³² jan³ yein³ jm² sa⁴júan³i³ ta¹, canh⁴a² sa⁴hnoh³ˉ³ juah⁴ i⁴sa⁴li⁴tei⁴³ lai²³ quieh¹ M³se²³, ¿i² e⁴le³⁴ ti²conh³ˉ³ i²con²³ jnia⁴ nei² quieh¹ i⁴a⁴júan³⁴ˉ⁴ i⁴a⁴huan⁴ quieh¹ jan³ chie³ jm² sa⁴júan³i³ ta¹? ");
INSERT INTO cucNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","A⁵con⁴ hnei³ jau²chie⁴³ con⁴juah⁴ co³hei²tsei³ quieh¹ chie³ tionh², jian³ tei⁴³i² hnoh³ˉ³ hleh²ˉ³ henh⁴ hleh²ˉ³, júan² hnei³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","I² jon³ a⁴ŋang⁴ co⁴meih³ chie³ a³sian³ Jerusalén jon³, a⁴juah⁴i³: ―¿A¹hei⁴ a³ne³ hain⁴ ti²hnah³i³ a³hnie³⁴i³ jŋangh³i³? ");
INSERT INTO cucNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jeh³², si²sainh⁴³i³ i²ne³ si²hleh²i³ ta⁵nei² a³jeu³, jian³ i¹jan³ sa⁴hleh⁴³ quieh¹i³. ¿A¹ hain⁴pa² si³ta¹, liah², i⁴lang⁴³ a³ne³ A³ma²ya⁴lion³² Chie³ hain⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","I² a³ne³ ne⁵, nia²ˉ¹ jainh¹ ja³⁴i³; quie¹ la⁴teg⁴i² jia²³ A³lion³ Chie³ hain⁴, i¹jan³ a⁵sian⁴³ a³ñi³ jainh¹ jia²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","I² Jesús, con³ma²a⁴nau⁴i³ jau²³ jon³, i²si²he²³i³ cuah³júah², jon³ a⁴hleh⁴i³ con³ i⁴tia⁴: ―¡Ti²cuh⁴³ˉ³ jnia⁴ jian³ ñih¹ˉ³ jainh¹ a⁴nia³⁴ˉ⁴! Jian³ a⁵sia³ a⁴nia³⁴ˉ⁴ con⁴juah⁴ i⁴hno⁵ˉ⁵ húan⁵, quie¹ a⁴nia³⁴ˉ⁴ i⁴sain³²ˉ⁴ quieh¹ a³hain⁴ a³lang⁴³ ni²tei⁴³; i² hnei³ tionh²ˉ³, sa⁴cmh⁴³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","I² jnia⁴pa² cm⁴³i³, quie¹ a⁴nia³⁴ˉ⁴ i²con²³i³ i⁴a⁴sai⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","I² jon³ ma²hnie³⁴i³ júan³⁴i³ chion³² Jesús; i² i¹jan³ a⁵sian⁴³ a³a⁴sonh³ quieh¹i³, quie¹ a⁵sia³ jm² jon³ ma³a⁴tyie³⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jian³ jeun⁴³ a³jeu³ ra⁵hain⁴ i²con²³i³, jon³ a⁴júanh⁴i³: ―La⁴teg⁴i² jia²³ A³lion³ Chie³ hain⁴, ¿o⁴ hlion⁴ pi¹ ua³júah² júan³⁴i³ la⁴conh⁴a² a³ne³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","I² jon³ a⁴nau⁴ chie³ fariseo tionh² i⁴ti²hleh² chie³ nei² quieh¹ Jesús; i² hei⁴i³ liah⁴ma³jian²³ m³chie³ tyein², a⁴sain⁴i³ po³li³sei¹ quian¹ cuah³júah² i⁴ua⁵sianh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","I² jon³ a⁴juah⁴ Jesús: ―Co⁴le⁴ jm²pa² júah³ sainh⁴³ˉ⁴ jenh²ˉ³ tionh²ˉ³, quie¹ naih²ˉ⁵ i²con²³ a³hain⁴ a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jian³ hnoh³²ˉ³ jnia⁴ tionh²ˉ³, jian³ a⁵sian⁴³ jnia⁴ ma⁵tyanh³²ˉ³, quie¹ i²jon³ i²naih²ˉ⁵, sa⁴li⁴cúah¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","I² jon³ a⁴júanh⁴ judío húan⁴ tionh²: ―¿Jainh¹ pi² chianh³ a³ne³, lainh⁴ˉ³, i²jon³ i²sa⁴tyanh³²i³ jnia¹? ¿A¹ sa⁴chie³⁴i³ jen² a³co³²ˉ¹ a³ra³jan⁴ jen² chie³ griego tionh² i⁴si⁵heh²i³ a³sa⁴lang⁴³ judío tionh²? ");
INSERT INTO cucNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿I² henh⁴ ne³ ra³juah⁴ i⁴juah⁴i³: “Hnoh³²ˉ³ jnia⁴ tionh²ˉ³, jian³ a⁵sian⁴³ jnia⁴ ma⁵tyanh³²ˉ³ liah⁴, quie¹ i²jon³ i²naih²ˉ⁵ sa⁴li⁴cúah¹ˉ³ tionh²ˉ³”? ");
INSERT INTO cucNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jian³ jm² i²a⁴toh⁴ jm² jon³, ta² júah³ jm² júan³i³; i² jon³ a⁴no³ Jesús jm² jon³, a⁴hleh⁴i³ con³ i⁴tia⁴, a⁴juah⁴i³: ―Juah⁴ne³ hain³ a³quein³ tsei⁴³, ua²jia³i³ i²con²³ jnia⁴ ua²ya⁴hainh³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","La⁴jon³ liah⁴i² ra³juah⁴ ra³sag² Ma²jyi³, a³hain⁴ a³hain⁴ i²con²³ jnia⁴ lei⁴ la⁴teg⁴ m⁴tyi⁴ quieh¹i³ la⁴con³ i²hya²³ o¹jm³ i⁴sian³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","A⁴hleh⁴ Jesús jau²³ jon³ i⁴hyei³⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ la⁴jang³⁴ a³hain⁴ i²con²³i³; jian³ a⁵sia³ ma³cua²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³ chie³, quie¹ a⁵sia³ ma³a⁴júan⁴ Jon⁴dai¹ i⁴tyein² júanh⁴³ Jesús ma²jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","I² con³ma²a⁴nau⁴ co⁴meih³ a³tionh² jen² chie³ jeun⁴³ hain⁴ jau²³ jon³, jon³ a⁴juah⁴i³: ―I⁴chie⁴³pa² lang⁴³ a³ne³ a³sain² quian¹ Jon⁴dai¹ a³ma²jia²³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jian³ ca³chion²³ juah⁴: ―A³ne³pa² A³ya⁴lion³² Chie³ hain⁴. Conh⁴liah⁴ juah⁴ i²ca³chion²³: ―¿Liah⁴ cúan²³ li⁴sian³ A³ya⁴lion³² Chie³ hain⁴ húa³⁴ Galilea? ");
INSERT INTO cucNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Quie¹ ra³juah⁴ ra³sag² Ma²jyi³ i⁴hyon⁴³ A³ya⁴lion³² Chie³ hain⁴ jeun³ re¹ Da³vei²³, a³li⁴sian³ jeu³ Belén i²ma²sian³ Da³vei²³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","I² la⁴ne³ a⁴han⁵ a³jeu³ ma⁵quein²³ co³hei²tsei³ nei² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jian³ ca³chion²³ hnie³⁴ ma²júan³⁴i³ chion³², jian³ i¹jan³ sa⁴a⁴sonh³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","I² jon³ a⁵han² po³li³sei¹ a³hie³ cuah³ hain⁴ i²con²³ m³chie³ tyein² jian³ fariseo tionh², i² jon³ a⁴ŋang⁴ a³hain⁴ tionh²: ―¿E⁴le³⁴ sa⁴teh³²i³ hnei³? ");
INSERT INTO cucNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","I² jon³ a⁴ŋangh³ po³li³sei¹ hain⁴ tionh²: ―¡I¹jan³ a⁵sian⁴³ a³ma³a⁴hleh⁴ liah⁴i² hleh² a³hain⁴! ");
INSERT INTO cucNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","I² jon³ a⁴juah⁴ fariseo tionh²: ―¿A¹ sa⁴ma⁴co³i³ hnei³ liah⁴ tionh²ˉ³, liah²? ");
INSERT INTO cucNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿A¹ sa⁴ra⁵hain⁴ jan³ si³ta¹ quian⁴ˉ¹ i²con²³i³ jian³ o⁴ jan³ fariseo? ");
INSERT INTO cucNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Quie¹ a³jeun⁴³ a³sa⁴ŋang⁴ lai²³ hain⁴, ma³ua⁵hain⁴ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","I² jon³ a⁴ŋang⁴ Nicodemo, a³ma²ni²jen³² Jesús con³ to⁵hlo³⁴, jan³ a³hein² jen² a³hain⁴ tionh², a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿O⁴ ra³cúa²³ lai²³ quian⁴ˉ¹ i⁴queih³²ˉ¹ heih⁴³ i²con²³ jan³ chie³ juah⁴ne³ sa⁴nai³²ˉ¹ ñeih³² i²con²³i³, canh⁴a² li⁴nia²ˉ¹ henh⁴ a⁴júan⁴i³? ");
INSERT INTO cucNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I² jon³ a⁴ŋangh³i³ tionh², a⁴sagh⁴³i³ Nicodemo: ―¿O⁴ hnei³ liah⁴ sianh³ˉ³ húa³⁴ Galilea? Je¹ hnei³ Ma²jyi³ quieh¹ Jon⁴dai¹ re³, jon³ li⁴ñih¹ˉ³ i⁴i¹jan³ a³sain² quian¹ Jon⁴dai¹ sa⁴ma³a⁴hyon²³ húa³⁴ Galilea. ");
INSERT INTO cucNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jon³ ŋah³ a³jan³ jan³ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","I² Jesús ne⁵, ŋo³⁴i³ mah⁴ quieh¹ a²hma³ Olivos. ");
INSERT INTO cucNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","I² con³ma²si³jnia³⁴, to⁵hie³ jon³, jon³ ŋo³⁴ Jesús liah⁴ i⁴seg³⁴ cuah³júah², jian³ la⁴jang³⁴ a³jeu³ a⁴tyie³⁴ i²con²³i³; jon³ a⁴cua⁴i³, jian³ a⁴he⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","I² jon³ ne⁵, a⁴tyie³⁴ a²teg²³ quian¹ lai²³ jian²³ chie³ fariseo tionh², jian³i³ jan³ a³m⁴ a³a⁴jon⁴i³ jian²³ i³cúa³ chie³. I² jon³ a⁴sainh⁴i³ to⁵chieh³² jon³, ");
INSERT INTO cucNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","i² jon³ a⁴sagh⁴³i³ Jesús: ―Hnei³ A²teg²³, jeh³² a³m⁴ la³, a⁴jon⁴ jnie³² jian²³ i³cúa³ a³sang²³, a³a⁴jon⁴ jnie³² o³tan². ");
INSERT INTO cucNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Jian³ lai²³ quieh¹ M³se²³ ra³juah⁴ i⁴hniah³ quinh⁵i³ a³m⁴ la⁴la³ m⁴caun² canh⁴a² jaun⁴i³. I² hnei³, ¿henh⁴ juah⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Quie¹ a⁴juah⁴i³ i⁴ne³ tionh² i⁴con²³i³ jau²chie⁴³, canh⁴a² sia³ liah⁴ li⁴hnang⁵i³. I² Jesús ne⁵, a⁴júan⁴i³ ta⁵i²hain²³i³, a⁴sag⁴i³ húa³⁴ jeu³ jon⁴³ si¹cúa³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jian³ liah⁴ma²ti²ŋang³ jon³ pi²³i³ i²con²³ Jesús, i² Jesús ne⁵, a⁴no³i³ liah⁴, a⁴juah⁴i³: ―Juah⁴ hain³ hnei³ sa⁴renh³ˉ³ chie³² i¹con³, ua²ma⁴lie⁵i³ quinh⁵i³ a³m⁴ la³ m⁴caun². ");
INSERT INTO cucNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Conh⁴liah⁴ i⁴seg³⁴ a⁴júan⁴ Jesús ta⁵i²hain²³i³, a⁴sag⁴i³ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","I² a³hain⁴ tionh², con³ma²a⁴nau⁴i³ jau²³ jon³, jon³ ra⁵laih² tsei⁴³i³ i⁴ti²ren³i³ chie³²; jon³ a⁴húan³i³ ma⁵jan³i³, a³don⁵ ñeih³² ra⁴lie⁵ ŋah³ tionh², jon³ a²ma⁴ ŋah³ la⁴jang³⁴ a³si³maih² i²a⁴toh⁴; hña³pa² júah³ Jesús a⁴quionh³ jian²³ a³m⁴ hain⁴ si²sainh⁴³ to⁵chieh³² jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","I² jon³ a⁴no³ Jesús liah⁴, a⁴je³⁴i³ i⁴so⁵ma⁵sian³ chie³ i¹jan³, jan³ a³m⁴pa² júah³ si²sainh⁴³; i² jon³ a⁴sagh⁴³i³ a³m⁴: ―Hnei³ a³m⁴, ¿nah⁴³ a³hain⁴ tionh² a³ma²ti²hnang⁴³ hnei³ hain⁴? ¿O⁴ i¹jan³ sa⁴a⁴queih³i³ heih⁴³ i²conh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","I² jon³ a⁴ŋangh³ a³m⁴ hain⁴, a⁴juah⁴i³: ―Hnei³ Se³ño²³, i¹jan³pa². I² jon³ a⁴juah⁴ Jesús: ―A⁵ga⁴ jnia⁴ queih¹ˉ⁴ heih⁴³ i²conh²ˉ³; cuanh³ quianh³, a⁵ma⁵ta⁵canh¹ chie³². ");
INSERT INTO cucNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Conh⁴liah⁴ a⁴hleh⁴ Jesús i⁴seg³⁴ i²con²³ chie³, a⁴juah⁴i³: ―Jnia⁴pa² lang⁴³ joh¹ quieh¹ m⁵cu³; a³hain⁴ a³si³tyein⁵ coh⁵cah³ˉ⁴, a⁵sia³ ŋeng³⁴i³ i²naih³, quie¹ li⁴sia³ joh¹ i⁴cúa³⁴ m⁵cu³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","I² jon³ a⁴juah⁴ fariseo tionh²: ―Si²hleh³ˉ³ nei² quianh³ húanh⁴³pa² hnei³, jian³ i⁴hleh³ˉ³ húanh⁴³ˉ³ ne³, sa⁴quein⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Ua²liah⁴a² hleh³ˉ⁴ nei² quien⁴ húan⁵, i⁴hleh³ˉ⁴ ne³, quein⁴³pa². Quie¹ yan³²ˉ⁴ jainh¹ a⁴nia³⁴ jnia⁴ jian³ jainh¹ naih²ˉ⁵ liah⁴; i² hnei³ tionh²ˉ³ ne⁵, sa⁴ñih¹ˉ³ jainh¹ a⁴nia³⁴ˉ⁴, jian³ jainh¹ naih²ˉ⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Quie¹ hnei³ tionh²ˉ³ canh³ˉ³ jau²chie⁴³ con⁴juah⁴ co³hei²tsei³ quieh¹ m⁵cu³. Jian³ jnia⁴, a⁵sia³ can³⁴ˉ⁴ jau²chie⁴³ i²con²³ i¹jan³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","I² juah⁴ne³ can¹ˉ⁴ jau²chie⁴³, can¹ˉ⁴ la⁴conh⁴ ni²tei⁴³pa², quie¹ a⁵sia³ húan⁵ jnia⁴ leg⁴³, quie¹ jian²³ˉ⁵ Neih³ˉ⁴ a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Jian³ lai²³ quianh³ˉ³ ra³sag² tionh²ˉ³, jau²³ quieh¹ on³⁴ a³tei⁴³ nei², quein⁴³pa². ");
INSERT INTO cucNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","I² la⁴ne³ jon³ jnia⁴pa² hleh³ˉ⁴ nei² quien⁴ˉ⁴ húan⁵, jian³ Neih³ˉ⁴ a³a⁴sai⁴ jnia⁴ ma³jnia³i³ nei² quien⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","I² jon³ a⁴sagh⁴³i³ Jesús tionh²: ―¿Nah⁴³ Naih⁴³ˉ³ ne⁵? I² jon³ a⁴ŋangh³ Jesús: ―Hnei³ tionh²ˉ³ sa⁴cuh⁴³ˉ³ jnia⁴, jian³ a⁵ga⁴ Neih³ˉ⁴ liah⁴; quie¹ juah⁴ne³ ma²cuh⁴³ˉ³ jnia⁴, ma²cmh⁴³pa² hnei³ Neih³ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jau²³ la³ a⁴hleh⁴ Jesús ta¹la⁴ ua²he²³i³ cuah³júah² i²ua²cua⁴³i³ jon³ i²tieh³² a²cúa⁴³ o¹cau³². Jian³ i¹jan³ sa⁴a⁴sonh³ quieh¹i³, quie¹ sa⁴ma³a⁴tyie³⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Conh⁴liah⁴ a⁴juah⁴ Jesús: ―Tieh²la³ naih²ˉ⁵, i² hnei³ tionh²ˉ³ hnoh³²ˉ³ jnia⁴, jian³ jaunh⁴ˉ³ tionh²ˉ³ liah⁴ma³ti²renh³ˉ³ chie³²; jian³ i²jon³ i²naih²ˉ⁵, sa⁴li⁴cúah¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","I² jon³ a⁴júanh⁴ judío húan⁴: ―¿A¹ sa⁴jŋangh³i³ hña³, liah², quie¹ juah⁴i³: “I²jon³ i²naih²ˉ⁵, sa⁴li⁴cúah¹ˉ³ tionh²ˉ³”? ");
INSERT INTO cucNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Conh⁴liah⁴ a⁴juah⁴ Jesús i²con²³ a³hain⁴ tionh²: ―Hnei³ tionh²ˉ³ langh⁴³ˉ³ a³sian³ nei² cuah³²húa³⁴ la³, quie¹ jnia⁴ sian³⁴ ta⁵yeih³²; hnei³ tionh²ˉ³ langh⁴³ a³quian¹ m⁵cu³ la³, i² jnia⁴ a⁵sia³ lang⁴³ˉ⁴ a³sian³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","I⁴jon³pa² a⁴jeu³⁴ˉ⁴ hnei³ i⁴tyanh⁴³ˉ³ liah⁴ma³renh³ˉ³ chie³²; quie¹ juah⁴ne³ sa⁴hainh⁴ˉ³ i⁴lang⁴³ jnia⁴ a³hain⁴ a³ma²jia²³, jon³ tyanh⁴³ˉ³ liah⁴ma³renh³ˉ³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","I² jon³ a⁴sagh⁴³i³ Jesús liah⁴: ―¿Hain³ hnei³ ne⁵? I² jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―Quie¹ liah⁴ma²ra⁴lie⁵ ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hlion⁴pa² i⁴hno⁵ˉ⁵ hleh¹ˉ⁴ nei² quianh³ˉ³ jian³ i⁴can¹ˉ⁴ jau²chie⁴³ i²conh²ˉ³ liah⁴, jian³ a³hain⁴ a³a⁴sai⁴ jnia⁴ hleh² jau²³ ni²tei⁴³, jian³ la⁴conh⁴ i⁴a⁴nau³⁴ˉ⁴ i⁴a⁴hleh⁴ a³hain⁴, hleh³ˉ⁴ i²con²³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","I² a³hain⁴ tionh², sa⁴ra⁵ŋang⁴i³ i⁴a⁴hleh⁴ Jesús nei² quieh¹ Jmai³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","I⁴jon³ a⁴juah⁴ Jesús liah⁴: ―La⁴teg⁴i² sieh³²ˉ³ jnia⁴ yeih³² i⁴lang⁴³ˉ⁴ A³a⁴lang³⁴ Chie³ hain⁴, jon³ pi¹ li⁴ñih¹ˉ³ i⁴lang⁴³ˉ⁴ a³hain⁴ a³ma²jia²³, jian³ i¹con³ a⁵sia³ júan³⁴ˉ⁴ con⁴juah⁴ i⁴hno⁵ˉ⁵ húan⁵; jmah³ i⁴jon³pa² hleh³ˉ⁴ la⁴conh⁴ i⁴a⁴he⁴ Neih³ pe²³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Quie¹ a³hain⁴ a³a⁴sai⁴ jnia⁴ jian²³i³ jnia⁴, jian³ a⁵sia³ ma³a⁴ton³⁴ jnia⁴ Neih³ˉ⁴ juah⁴ i⁴húan⁵, quie¹ la⁴jeg³⁴ nie⁴³ júan³⁴ˉ⁴ i⁴teg³ tsei⁴³ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ta¹la⁴ a⁴hleh⁴ Jesús jau²³ ne³, jeun⁴³ chie³ ra⁵hain⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","I² jon³ a⁴juah⁴ Jesús i²con²³ judío a³ma²ra⁵hain⁴ i²con²³i³: ―Juah⁴ne³ sa⁴teinh³ hoh⁴³ˉ³ jau²³ quien⁴ˉ⁴, jon³ lainh⁴ hnei³ chie³ quian³⁴ˉ⁴ i⁴chie⁴³ tionh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","jian³ li⁴ñih¹ˉ³ jau²³ ni²tei⁴³, jian³ con⁴juah⁴ jau²³ ni²tei⁴³ jon³ lionh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","I² jon³ a⁴ŋangh³ a³hain⁴ tionh²: ―Jeun³ quieh¹ A³brang²³pa² lang⁴³ jnie³²; i¹jan³ jnie³² sa⁴ma³a⁴lang³⁴ a³júan³ quian¹ chie³. ¿Liah⁴ cúan²³ juah⁴ hnei³ lion⁴ jnie³²? ");
INSERT INTO cucNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","I² jon³ a⁴ŋangh³ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, la⁴jang³⁴ a³ta³canh¹ chie³², lang⁴³i³ a³júan³ quian¹ chie³². ");
INSERT INTO cucNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jian³ a³hain⁴ a³júan³ quian¹ chie³, a⁵sia³ juah⁴ i⁴cua⁴³i³ o³tan² jauh³² quieh¹ jeu³²; a³jon⁴³ jeu³² pi²³i³ cua⁴³ o³tan². ");
INSERT INTO cucNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","I² la⁴ne³ jon³, juah⁴ne³ A³jon⁴³ Jon⁴dai¹ lie⁴³ hnei³, jon³ lainh⁴ hnei³ tionh²ˉ³ a³lon² i⁴chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jian³ yan³²pa² jnia⁴ i⁴langh⁴³ˉ³ jeun³ quieh¹ A³brang²³; i² hnoh³ˉ³ jŋangh¹ˉ³ jnia⁴ tionh²ˉ³, quie¹ sa⁴i²hyeih²ˉ³ jau²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Quie¹ hleh³ jnia⁴ la⁴conh⁴ i⁴a⁴he⁴ Neih³ˉ⁴, i² hnei³ tionh²ˉ³ júanh³ˉ³ la⁴conh⁴ i⁴a⁴naih³ˉ³ i⁴a⁴juah⁴ naih⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","I² jon³ a⁴ŋangh³ a³hain⁴ tionh², a⁴juah⁴i³: ―A³brang²³pa² jmai³sie²³ jnie³². I² a⁴juah⁴ Jesús: ―Juah⁴ne³ i⁴chie⁴³ ma²langh⁴³ˉ³ jon⁴³segh³² A³brang²³ ma²júanh²ˉ³ liah⁴ a⁴júan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","I² hnei³ tionh²ˉ³ hnoh³ˉ³ jŋangh¹ˉ³ jnia⁴, ua²liah⁴a² a⁴hleh³ˉ⁴ jau²³ ni²tei⁴³ la⁴conh⁴ i⁴a⁴he⁴ Jon⁴dai¹. Jian³ A³brang²³, ¡a⁵sia³ la⁴ne³ a⁴júan⁴i³! ");
INSERT INTO cucNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Quie¹ júanh³ˉ³ tionh²ˉ³ liah⁴i² júan³ naih⁴³ˉ³. I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―¡A⁵sian⁴³ jnie³² lang⁴³ yein³ ta² sian³! Sian³ jan³ jmai³ jnie³², a³hain⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","I² jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ a³hain⁴: ―Juah⁴ne³ chie⁴³ ma²lang⁴³ naih⁴³ˉ³ Jon⁴dai¹, leg⁴³ re³ ma²ma²hnoh³²ˉ³ jnia⁴, quie¹ cuan⁵ jnia⁴, a⁴nia³⁴ˉ⁴ i²con²³ Jon⁴dai¹. A⁵sia³ a⁴nia³⁴ˉ⁴ i⁴nie⁴³ tsei³⁴ húan⁵, hei⁴ pi²³i³ a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿E⁴le³⁴ sa⁴ŋangh⁴ˉ³ tionh²ˉ³ i⁴hleh³ˉ⁴, lainh⁴ˉ³? Jon³pa² quie¹ ta⁵la⁴ sa⁴hnoh³ˉ³ nauh²ˉ³ jau²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Quie¹ langh⁴³ hnei³ tionh²ˉ³ quian¹ naih⁴³ˉ³, a³hain⁴ a³sa⁴tsein³⁴, jian³ hnoh³ˉ³ júanh²ˉ³ la⁴conh⁴ i⁴hnie³⁴ naih⁴³ˉ³. Quie¹ a³sa⁴tsein³⁴ hain⁴ lang⁴³ a³jŋangh² chie³ liah⁴ma²ra⁴lie⁵; jian³ sa⁴ma³a⁴júan⁴i³ con⁴juah⁴ jau²³ ni²tei⁴³, quie¹ sa⁴sia³ jau²³ ni²tei⁴³ i²con²³i³. Quie¹ tei⁴³i² hleh²i³ jau²ta³jau²³, hleh²i³ liah⁴ lang⁴³i³; quie¹ ta³jaun²³i³, jian³ lang⁴³i³ o¹sieh³² jau²ta³jau²³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quie¹ jnia⁴ hleh³ˉ⁴ jau²³ ni²tei⁴³, jon³ sa⁴hainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Hain³ hnei³ tionh²ˉ³ li⁴cúah³²ˉ³ jnia⁴ con³ chie³²? I² juah⁴ne³ jmah³ jau²³ ni²tei⁴³ ma³a⁴hleh³ˉ⁴ ne⁵, ¿i² e⁴le³⁴ sa⁴hainh⁴ˉ³ tionh²ˉ³ i²con²³ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Quie¹ a³hain⁴ a³lang⁴³ a³quian¹ Jon⁴dai¹, nau³i³ jau²³ quieh¹ Jon⁴dai¹; i⁴jon³pa²da³ sa⁴i²nauh²ˉ³ tionh²ˉ³ quie¹ sa⁴langh⁴³ˉ³ a³quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","I² jon³ a⁴ŋangh³ judío tionh², a⁴sagh⁴³i³: ―I⁴chie⁴³pa² li⁴juah² jnie³² i⁴langh⁴³ hnei³ jan³ chie³ samaritano jian³ i⁴quianh²ˉ³ m⁴tyi⁴ hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","I² jon³ a⁴ŋangh³ Jesús: ―A⁵sia³ m⁴tyi⁴ hlagh³² quian³²ˉ⁴, quie¹ júan³⁴ˉ⁴ júanh⁴³ Neih³ pe²³ˉ⁴; i² hnei³ tionh²ˉ³ sa⁴júanh³ˉ³ i⁴júanh⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jian³ a⁵sia³ hnoh³²ˉ⁴ i⁴júanh⁴³ˉ⁴ húan⁵ˉ⁵, quie¹ sian³ jan³ a³hnoh³ i⁴júanh⁴³ jnia⁴ jian³ a³can²³ jau²chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³ma³tei⁵ jau²³ quien⁴ˉ⁴, sa⁴legh⁴ ua²a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","I² jon³ a⁴juah⁴ judío tionh²: ―Ne⁵a² nia² jnie³² i⁴quianh²ˉ³ m⁴tyi⁴ hlagh³². Quie¹ a⁴jaun³⁴ A³brang²³ jian³ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹; i² hnei³ juah⁴ˉ³: “A³hain⁴ a³ma³tei⁵ jau²³ quien⁴ˉ⁴, sa⁴legh⁴ ua²a⁴jaun³⁴i³.” ");
INSERT INTO cucNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿O⁴ júanh⁴³ga² hnei³, lainh⁴ˉ³, la⁴conh⁴a² A³brang²³, jmai³sie²³ jnie³²? Quie¹ hei⁴i³ a⁴jaun³⁴ jian³ la⁴jang³⁴ a³sain² liah⁴ a⁴chian³⁴. I² hnei³ ne⁵, ¿hain³ júanh⁵ˉ³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","I² jon³ a⁴ŋangh³ Jesús: ―Quie¹ juah⁴ne³ júan³⁴ˉ⁴ i⁴júanh⁴³ˉ⁴ húan⁵ˉ⁵, i⁴júanh⁴³ˉ⁴ jon³ sa⁴quein⁴³. Neih³ pe²³ˉ⁴ júan³ i⁴júanh⁴³ jnia⁴, a³hain⁴ a³juah⁴ˉ³ tionh²ˉ³ lang⁴³ Jon⁴dai¹ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Jian³ a⁵sian⁴³ cmh⁴³i³ hnei³ tionh²ˉ³. Jnia⁴pa² cm⁴³ˉ⁴; jian³ juah⁴ne³ ma²juah³ jnia⁴ i⁴sa⁴cm⁴³i³ jnia⁴, ma²lang⁴³ jnia⁴ a³lia⁴ hnei³ tionh²ˉ³, a³ta³jaun²³. I² jnia⁴ ne⁵, cm⁴³i³ jnia⁴, jian³ ma⁵tei³²ˉ⁴ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Quie¹ A³brang²³ naih⁴³sieh³ˉ³ tionh²ˉ³, ta² si³hyonh³i³ a⁴júan⁴i³ quie¹ ma²i²je³⁴i³ jm² ma²nia²³ˉ⁵; jian³ a⁴je³⁴ pi²³i³, jian³ a⁴júan⁴i³ si³hyonh³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","I² jon³ a⁴juah⁴ judío tionh² i²con²³i³: ―I¹ sa⁴ma³heinh² hnei³ to⁴lo⁵quia⁴ ñi³. ¿Liah⁴ cúan²³ juah⁴ˉ³ i⁴a⁴jenh³²ˉ³ A³brang²³? ");
INSERT INTO cucNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","I² jon³ a⁴juah⁴ Jesús: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, naih⁵i² li⁴sian³ A³brang²³, ma³sian³pa² jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","I² jon³ a⁴tang⁴i³ m⁴caun² tionh² i⁴quinh⁵i³ Jesús; i² Jesús ne⁵, ua⁵conh⁴i³ jen² a³hain⁴ tionh², ua⁵hag⁴³i³ cuah³júah², a⁴ua⁴jeun³²i³ jeu³ jen² a³hain⁴ tionh², ŋo³⁴i³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","I² con³ i²ma²si²ŋeng²³ Jesús, jon³ a⁴jen³i³ jan³ a³ñih³ a³taun³² liah⁴ma²ra⁵sian³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","I² jon³ a⁴ŋang⁴ chie³ quian¹i³ i²con²³i³, juah⁴i³: ―Hnei³ A²teg²³, ¿e⁴le³⁴ taun³² a³ñih³ ne³ ra⁵sian³? ¿O⁴ quie¹ a⁴tanh⁴ jmai³sie²³i³ chie³² o⁴ quie¹ a⁴tanh⁴ hña³ pi²³i³? ");
INSERT INTO cucNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","I² jon³ a⁴ŋangh³ Jesús: ―A⁵jon⁴³ quie¹ a⁴tanh⁴ jmai³sie²³i³ chie³² jian³ o⁴ i⁴a⁴tanh⁴ hei⁴i³; a⁵sia³, jon³pa² canh⁴a² li⁴jnia³ i⁴tang³ Jon⁴dai¹ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Quie¹ hniah³ júan³²ˉ⁴ ta¹ quieh¹ a³hain⁴ a³a⁴sai⁴ jnia⁴ ta¹la⁴ i⁴jm²³; quie¹ tei⁴³i² ma³ja²³ je¹nai³, i¹jan³ a⁵sian⁴³ a³ma⁵li⁴júan³⁴ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quie¹ ta¹la⁴ sainh⁴³ˉ⁴ m⁵cu³ la³, lang⁴³ˉ⁴ joh¹ quieh¹ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","I² con³ma²a⁴juah⁴ Jesús jau²³ jon³, jon³ a⁴hñei³⁴i³ húa³⁴, a⁴júan⁴i³ o¹jain²³ jian²³ jm³teuh¹, jian³ o¹jain²³ jon³ a⁴jñei³⁴i³ m⁴nei² a³taun³². ");
INSERT INTO cucNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma²jon³ a⁴sagh⁴³i³: ―Cua³ ua⁴raunh³² mah² i²nie⁴³ jm³ Siloé ―jau²³ ne³ ra³juah⁴, A³sain². I² jon³ ŋo³⁴ a³taun³² hain⁴, jian³ a⁴raunh⁵i³, i² con³ma²ma³jonh²i³, jon³ ma³ya¹je²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jon³ a⁴juah⁴ a³tionh² hloh³² i²cua⁴³i³ jian³ la⁴jang³⁴ a³ma²a⁴je³ quieh¹i³ i⁴taun³²i³ liah⁴ma²jia⁴³, a⁴júanh⁴i³: ―¿A¹hei⁴ a³ne³ hain⁴ ma²cua²³ ma²m²³ o¹cau³²? ");
INSERT INTO cucNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","I² jon³ a⁴juah⁴ ca³chion²³: ―Hei⁴ pi²³i³ ne³. Conh⁴liah⁴ a⁴juah⁴ ca³chion²³: ―La⁴jan³ hei⁴ pi²³i³, la⁴jon³ jnia⁴i³. I² jon³ a⁴juah⁴i³ hña³i³: ―Jnia⁴pa² la³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","I² jon³ a⁴ŋang⁴ a³hain⁴ tionh² i²con²³i³: ―¿Liah⁴ a⁴leg³⁴ a⁴jnia⁵ m⁴mah²ˉ³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I² jon³ a⁴ŋangh³i³, a⁴juah⁴i³: ―Jan³ a³ñih³ a³sain³ Jesús pa² a⁴júan⁴ o¹jain²³, jian³ a⁴jñei³⁴i³ m⁴nei³⁴ˉ⁴, jian³ a⁴sag⁴³i³ jnia⁴: “Cua³ i²nie⁴³ jm³ Siloé, ya⁴raunh³²ˉ³ mah².” Jon³ ñei³²ˉ⁴ jian³ a⁴raunh⁵ˉ⁵, jian³ a⁴hoh³ m⁴nei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","I² jon³ a⁴ŋang⁴ a³hain⁴ tionh² liah⁴: ―¿Jainh¹ si²sainh⁴³ a³ñih³ hain⁴ ne⁵? I² jon³ a⁴juah⁴i³: ―Sa⁴yan³²ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","I² jon³ ni²jan³i³ a³ma²taun³² hain⁴ ta⁵nei² chie³ fariseo tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jian³ jm² i⁴a⁴júan⁴ Jesús o¹jain²³ jian³ i⁴a⁴na⁴ m⁴nei² a³ma²taun³² hain⁴, jm² sa⁴júan³ ta¹ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","I² jon³ a⁴ŋang⁴ fariseo liah⁴ i⁴seg³⁴ i²con²³i³ hain³liah⁴ a⁴hoh³ m⁴nei²i³. I² jon³ a⁴juah⁴ hei⁴i³: ―O¹jain²³pa² a⁴jñei³⁴i³ m⁴nei³⁴ˉ⁴, jian³ a⁴raunh⁵ˉ⁵, jian³ je³⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","I² jon³ a⁴juah⁴ ca³chion²³ fariseo hain⁴: ―A³ñih³ a³a⁴júan⁴ i⁴ne³ a⁵hei⁴³ a³quian¹ Jon⁴dai¹, quie¹ sa⁴hie³i³ jm² sa⁴júan³i³ ta¹. Conh⁴liah⁴ a⁴juah⁴ i²ca³chion²³: ―¿Liah⁴ cúan²³ li⁴júan³⁴ jan³ chie³ a³ren³ chie³² ua³júah² la⁴ne³, lainh⁴ˉ³? I² jon³ a⁴han⁵i³ ma⁵quein²³ co³hei²tsei³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Conh⁴liah⁴ a⁴ŋang⁴i³ i²con²³ a³ma²taun³² hain⁴: ―I² hnei³, ¿liah⁴ juah⁴ˉ³ nei² quieh¹ a³a⁴júan⁴ i⁴a⁴jnia⁵ m⁴mah²ˉ³ hain⁴? I² jon³ a⁴juah⁴i³: ―Lang⁴³ jan³ a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","I² judío tionh², sa⁴hain⁴i³ i⁴ma²lang⁴³ a³hain⁴ a³taun³² jian³ i⁴ma³a⁴hoh³ m⁴nei²i³ la⁴conh⁴ a⁴teh³i³ jmai³sie²³ a³hain⁴ a³a⁴jnia⁵ m⁴nei² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","I² jon³ a⁴ŋangh³i³, a⁴juah⁴i³: ―¿O⁴ a³ne³ a³jonh³ˉ³ tionh²ˉ³ a³juah⁴ˉ³ a³ra⁵sian³ taun³²? ¿I² liah⁴ cúan²³ ma³je²³i³ tieh²la³? ");
INSERT INTO cucNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","I² jon³ a⁴ŋangh³ jmai³sie²³i³, a⁴juah⁴i³: ―Jen³⁴, a³ne³pa² a³jon⁴³ jnie³² a³ra⁵sian³ taun³². ");
INSERT INTO cucNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","I² sa⁴nia² jnie³² tieh²la³ liah⁴ a⁴jnia⁵ m⁴nei²i³, jian³ sa⁴nia² jnie³² hain³ a⁴júan⁴ a⁴hoh³ m⁴nei²i³; i² ma³hein² ñi³ pi²³i³, lei⁴pa² li⁴ŋangh³²i³ hnei³ hña³, i² hei⁴ pi²³i³ li⁴juah⁴ liah⁴ a⁴leg³⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A⁴juah⁴ jmai³sie²³i³ la⁴jon³ quie¹ con⁴³i³ judío tionh², quie¹ ma³a⁴júan⁴ judío re³ i⁴húan⁵i³ chie³ cuah³ la⁴jang³⁴ a³hleh² i⁴lang⁴³ Jesús A³ya⁴lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","I⁴jon³pa² a⁴juah⁴ jmai³sie²³i³: “A³ma³hein² ñi³ pi²³i³, lei⁴pa² li⁴ŋangh³²i³ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","I² jon³ a⁴te⁴ judío liah⁴ i⁴seg³⁴, a⁴teh³i³ a³ma²taun³² hain⁴, a⁴sagh⁴³i³: ―Hniah³ júanh²ˉ³ júanh⁴³ Jon⁴dai¹pa², quie¹ nia² jnie³² i⁴lang⁴³ a³ñih³ hain⁴ jan³ a³ren³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","I² jon³ a⁴ŋangh³i³, a⁴juah⁴i³: ―Juah⁴ne³ lang⁴³i³ jan³ a³ren³ chie³², sa⁴yan³²ˉ⁴. Con³ i⁴la³pa² yan³²ˉ⁴, quie¹ ma²lang⁴³ jnia⁴ a³taun³², jian³ tieh²la³ ma³je³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Conh⁴liah⁴ a⁴ŋang⁴i³ tionh² i⁴seg³⁴: ―¿Henh⁴ a⁴júan⁴i³ ne⁵? ¿Liah⁴ a⁴júan⁴i³ i⁴a⁴jnia⁵ m⁴mah²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","I² jon³ a⁴ŋangh³i³ liah⁴: ―Ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, jian³ a⁵sia³ jeu³ roh³ˉ³. ¿E⁴le³⁴ hnoh³ˉ³ jeu¹ˉ⁴ hnei³ liah⁴ i⁴seg³⁴? ¿O⁴ quie¹ hnoh³ˉ³ liah⁴ lainh⁴ˉ³ chie³ quian¹i³? ");
INSERT INTO cucNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","I² jon³ a⁴sagh⁴³i³ a³hain⁴ jau²hlagh³², a⁴juah⁴i³: ―Hnei³ langh⁴³ chie³ quian¹ a³hain⁴, i² jnie³² lang⁴³ chie³ quian¹ M³se²³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Quie¹ nia² jnie³² i⁴a⁴hleh⁴ Jon⁴dai¹ i²con²³ M³se²³; i² a³ñih³ hain⁴, sa⁴nia² jnie³² jainh¹ ja³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","I² jon³ a⁴juah⁴ a³ma²taun³² hain⁴: ―¿O⁴ a⁵sia³ hniah³ chie³⁴ co³ tsei⁴³ˉ¹, lainh⁴ˉ³? Quie¹ sa⁴ñih¹ˉ³ jainh¹ ja³⁴ a³ñih³ hain⁴, i² hei⁴ pi²³i³ a⁴júan⁴ a⁴jnia⁵ m⁴nei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ti²nia² re³pa² jnia¹ i⁴sa⁴nau³ Jon⁴dai¹ jau²³ quieh¹ a³ti²ren³ chie³², quie¹ a³hain⁴pa² nau³i³ jau²³ quieh¹, a³ma³co⁴³ quieh¹ pi²³i³ jian³ a³ma³tei⁵ heih⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jian³ i¹conh⁴ sa⁴ma³a⁴nai² jnia¹ juah⁴ i⁴ma³a⁴nia³⁴ jan³ chie³ m⁴nei² jan³ a³taun³² liah⁴ma²ra⁵sian³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","I² juah⁴ne³ sa⁴ma²ja³⁴ a³ñih³ hain⁴ i²con²³ Jon⁴dai¹, i¹con³ a⁵sia³ i⁴ma²li⁴júan³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","I² jon³ a⁴ŋangh³i³ tionh², a⁴sagh⁴³i³ a³ma²taun³² hain⁴: ―Hnei³ langh⁴³ jan³ a³ren³ chie³² liah⁴ma²ra⁵sianh³ˉ³, ¿o⁴ ma²tagh²ˉ³ jnie³², lainh⁴ˉ³? I² jon³ a⁴tyein³i³ a³hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jon³ ra⁵ñi³ Jesús i⁴ma³a⁴tyein³i³ a³taun³² hain⁴; i² con³ma²a⁴jainh³i³, jon³ a⁴sagh⁴³i³: ―¿O⁴ hainh⁴ˉ³ i²con²³ A³jon⁴³ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I² jon³ a⁴ŋangh³ hei⁴i³, a⁴juah⁴i³: ―¿Hain³ hain⁴, a³don⁵, canh⁴a² li⁴hain⁴ jnia⁴ i²con²³i³? ");
INSERT INTO cucNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","I² jon³ a⁴juah⁴ Jesús liah⁴ i²con²³i³: ―Ma³si²jenh⁵ pi²³i³ hnei³, a³hain⁴ a³jianh²ˉ³ si²tyah³ˉ³ jau²³pa², jnia⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","I² jon³ a⁴juah⁴i³: ―Hain⁴ jnia⁴ i²conh²ˉ³, Se³ño²³. I² jon³ a⁴si⁴jnei⁵i³ ta⁵nei² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","I² jon³ a⁴juah⁴ Jesús liah⁴: ―Cuan⁵ jnia⁴ m⁵cu³ la³ i⁴ni³queih³ˉ⁴ heih⁴³, canh⁴a² jnia⁵ m⁴nei² a³taun³², jian³ taun⁴ a³ti²je²³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jian³ co⁴meih³ chie³ fariseo ma²ti²tionh² jian²³ Jesús, con³ma²a⁴nau⁴i³ jau²³ jon³, jon³ a⁴ŋang⁴i³: ―¿O⁴ taun³²a² jnie³² liah⁴, heh⁵ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","I² jon³ a⁴ŋangh³ Jesús: ―Juah⁴ne³ ma²taunh³²ˉ³ tionh²ˉ³, a⁵sia³ chie³² ma²renh³ˉ³. Quie¹ juah⁴ˉ³ tionh²ˉ³ i⁴ti²jeh⁴ˉ³, i⁴jon³ renh³ˉ³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³sa⁴si³hei⁴ jeu³ ho³² a²ha⁴ quieh¹ a⁵a³siah³, i² juah⁴ne³ si³hei⁴i³ jeu³ ta⁵seg³⁴, lang⁴³i³ jan³ a³hang³ pi²³, jian³ tian²³i³ ta⁵li⁴hnai³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","I² a³hain⁴ a³si³hei⁴ jeu³ o²hnei³² ne⁵, a³hain⁴pa² lang⁴³ jeu³² a⁵a³siah³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I² a³hie³ ho³² a²ha⁴ nia²³i³ o²hnei³² canh⁴a² si⁵hei⁴ jeu³² a⁵a³siah³, jian³ cuh² a⁵a³siah³ ho³²i³. Jian³ te²³ jeu³²i³ jm³i⁴sain³ a⁵a³siah³ quian¹, jian³ húan⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","I² tei⁴³i² ma³a⁴húan⁴³i³ la⁴jang³⁴ a⁵a³siah³ quian¹, jon³ si³jian⁴³i³ nei², jian³ coh⁵ ya¹han² jah⁴, quie¹ cuh²i³ ho³² jeu³²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","I² a³sa⁴cm²³i³ ne⁵, sa⁴si³han²i³ coh⁵cah³²i³, quie¹ cm³i³ i²con²³i³, quie¹ sa⁴cuh²i³ ho³² a³sa⁴cm²³i³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","A⁴can³⁴ Jesús jau²³ la³ i²con²³i³ tionh², i² hei⁴i³ tionh² sa⁴ra⁵ŋang⁴i³ henh⁴ hnie³⁴ ra³juah⁴ i⁴a⁴hleh⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Conh⁴liah⁴ a⁴hleh⁴ Jesús liah⁴ i⁴seg³⁴, a⁴sagh⁴³i³ a³hain⁴: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³: Jnia⁴pa² lang⁴³ o²hnei³² jeu³ si³hon¹ a⁵a³siah³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","La⁴jang³⁴ a³cuan²³ ñeih³² la⁴conh⁴a² jnia⁴ lang⁴³i³ hang³ jian³ tian²³i³ ta⁵li⁴hnai³; i² a⁵a³siah³ sa⁴a⁴ro⁴ jeu³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jnia⁴pa² lang⁴³ o²hnei³²; a³hain⁴ a³si³hei⁴ con⁴juah⁴ jnia⁴, lion⁴i³. Jian³ lang⁴³i³ liah⁴i² lang⁴³ jan³ a⁵a³siah³ a³si³hei⁴ jian³ si³hag⁴³i³ tyieh¹i³ o¹ñei³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’I² a³hang³ hain⁴, i⁴jon³pa² jia²³i³ i⁴yi⁴quian⁴i³, jian³ i⁴ya⁴jŋangh³i³, jian³ yi⁴jeun⁴³i³; i² jnia⁴ cuan⁵ ne⁵ canh⁴a² li⁴sia³ m⁵cu³ quieh¹i³, jian³ canh⁴a² sia³ quieh¹i³ i⁴ni²sion⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jnia⁴ lang⁴³ jan³ a³tsein²³ a³hion⁴³ a⁵a³siah³. Jan³ a³tsein²³ jeu³² a⁵a³siah³ a³cúa²³ m⁵cu³ nei² quieh¹ a⁵a³siah³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","I² a³hain⁴ a³hion⁴³ a⁵a³siah³ i⁴hlianh², a³sa⁴lang⁴³ jeu³² a⁵a³siah³, cm³i³ la⁴teg⁴i² je²³i³ i⁴ja³⁴ a¹tsai³nau²³ jian³ ton²³i³ a⁵a³siah³, quie¹ sa⁴quian¹i³. Jon³ sanh² a¹tsai³nau²³ a⁵a³siah³, ma²jon³ jenh²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","I² la⁴ne³ cm³ a³ñih³ a³júan³ ta¹ i⁴hlianh² hain⁴, quie¹ lang⁴³i³ mozo pi²³; i⁴jon³ sa⁴ron⁴³i³ jeu³ a⁵a³siah³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’I² jnia⁴ lang⁴³ jan³ a³tsein²³ a³hion⁴³ a⁵a³siah³, jian³ cm⁴³ jnia⁴ a⁵a³siah³ quian³⁴, jian³ a⁵a³siah³ quian³⁴ˉ⁴ cu²³ jnia⁴, ");
INSERT INTO cucNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","la⁴jon³ liah⁴i² cu²³ jnia⁴ Neih³ˉ⁴, jian³ cm⁴³ jnia⁴ Neih³ˉ⁴ liah⁴. Jian³ cúa¹ˉ⁴ m⁵cu³ quien⁴ nei² quieh¹ a⁵a³siah³ quian³⁴ˉ⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jian³ sian³ pi¹ a⁵a³siah³ quian³⁴ˉ⁴ a³sa⁴tionh² joh⁴³ a²ha⁴ la³; jian³ hniah³ ni¹quian⁵i³ jnia⁴, canh⁴a² nau³⁴i³ jau²³ quien⁴ˉ⁴. Jon³ lei⁴ con³pa² i²han⁵i³ jian³ jan³pa² jeu³²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Jian³ nei² jon³ hnie³⁴ jnia⁴ Neih³ˉ⁴, quie¹ cúa¹ˉ⁴ m⁵cu³ quien⁴, jian³ li⁴sian³⁴ˉ⁴ liah⁴ i⁴seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","I¹jan³ a⁵sian⁴³ a³li⁴qui³⁴, quie¹ cúa¹ˉ⁴ i⁴hyon³ tsei³⁴ húan⁵. Quie¹ quian³²ˉ⁴ heih⁴³ i⁴cúa¹ˉ⁴, jian³ quian³²ˉ⁴ heih⁴³ i⁴li⁴sian³⁴ˉ⁴ liah⁴. I⁴ne³ heih⁴³ a⁴júan⁴ Neih³ˉ⁴ i²con²³ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Con³ma²a⁴nau⁴ judío tionh² jau²³ jon³, jon³ a⁴han⁵i³ ma⁵quein²³ co³hei²tsei³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Quie¹ jeun⁴³ a³hain⁴ tionh² a⁴juah⁴: ―Quian³ a³ne³ m⁴tyi⁴ hlagh³², jian³ ŋo⁴³i³ liah⁴. ¿E⁴le³⁴ ti²nauh³ˉ³ jau²³ quieh¹i³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","I² ca³chion²³ a⁴juah⁴: ―A⁵sian⁴³ a³quian³ m⁴tyi⁴ hlagh³² hleh² jau²³ la⁴ne³. ¿O⁴ lei⁴ li⁴júan³⁴ a³quian³ m⁴tyi⁴ hlagh³² i⁴nia⁴ m⁴nei² a³taun³², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jian³ Jerusalén jon³ ti²júan³i³ jm² Jerusalén i⁴ti²tyon²³i³ tsei⁴³ i⁴ra⁵cúah¹ cuah³júah²; jian³ jain³ jon³, jain³ cu⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jian³ i²jon³ si²ŋeng²³ Jesús ho³²quie³ quieh¹ cuah³júah² i²teh²i³ quieh¹ Salomón. ");
INSERT INTO cucNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","I² jon³ a⁴tyie³⁴ judío tionh² co⁴la⁴lagh⁵ hlonh² Jesús, a⁴sagh⁴³i³: ―¿Ua²legh⁴ jon³ júanh³ˉ³ i⁴sian³ jnie³² co³hei²tsei³ nei² quianh³ˉ³? Juah⁴ne³ hnei³ langh⁴³ A³ma²ya⁴lion³² Chie³ hain⁴, sai³² hnei³ jnie³² ra³jia⁵. ");
INSERT INTO cucNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","I² jon³ a⁴ŋangh³ Jesús: ―Ma³a⁴jeu³⁴ jnia⁴ hnei³ tionh²ˉ³, i² sa⁴hainh⁴ˉ³. Quie¹ la⁴jeg³⁴ i⁴júan³⁴ˉ⁴ con⁴juah⁴ heih⁴³ quieh¹ Neih³ˉ⁴, ti²he²³ hain³ chianh² jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","I² hnei³ tionh²ˉ³ sa⁴hainh⁴ˉ³, quie¹ sa⁴langh⁴³ˉ³ a⁵a³siah³ quian³⁴ˉ⁴ liah⁴i² ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quie¹ cuh² a⁵a³siah³ quian³⁴ˉ⁴ ho³⁴ˉ⁴ jian³ cm⁴³i³ jnia⁴, jian³ si³tyein⁵i³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jian³ cúa¹ˉ⁴ m⁵cu³ quieh¹i³ i⁴sa⁴ton³ jm² ua²tya⁴³, jian³ sa⁴legh⁴ ua²si⁵hain⁴i³, jian³ i¹jan³ a⁵sian⁴³ a³li⁴húan⁵ joh⁴³ cúa³⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Jian³ Neih³ˉ⁴, a³hain⁴ a³a⁴cúan⁴³ i²con²³ˉ⁵, a³tyein² la⁴conh⁴a² la⁴jang³⁴pa²; jian³ i¹jan³ a⁵sian⁴³ a³tieh¹ húan⁵ joh⁴³ cúa³ hei⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jian³ jnia⁴ jian²³ˉ⁵ Neih³ˉ⁴, jan³pa² lang⁴³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","I² jon³ a⁴tang⁴ judío tionh² m⁴caun² liah⁴ i⁴seg³⁴ i⁴quinh⁵i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","I² jon³ a⁴juah⁴ Jesús: ―Ta² hlion⁴ i⁴tsei³⁴ ma³a⁴júan³⁴ˉ⁴ i²conh²ˉ³ tionh²ˉ³ con⁴juah⁴ ua³pei⁴ quieh¹ Neih³ˉ⁴. ¿Henh⁴ jon³ nei² quieh¹ i⁴tsei³⁴ jon³ quih³²ˉ³ jnia⁴ m⁴caun² tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","I² jon³ a⁴ŋangh³ judío tionh², a⁴juah⁴i³: ―A⁵sia³ quinh³² jnie³² hnei³ juah⁴ nei² quieh¹ con³ i⁴tsei³⁴ jon³, jon³pa² quie¹ ta⁵la⁴ hleh³ˉ³ jau²³ i⁴hieh¹ Jon⁴dai¹pa². Quie¹ júanh³ˉ³ langh⁴³ˉ³ Jon⁴dai¹, jian³ langh⁴³ jan³ chie³ta²chie³pa² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","I² jon³ a⁴ŋangh³ Jesús: ―¿Sa¹ chie⁴³ ra³sag² lai²³ quianh³ˉ³ tionh²ˉ³: “A⁴juah³ jnia⁴ i⁴langh⁴³ hnei³ jon⁴dai¹ tionh²ˉ³”? ");
INSERT INTO cucNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jian³ nia²ˉ¹ i⁴liah⁴ma³quein⁴³ jon³ la⁴conh⁴ ra³sag² Ma²jyi³ quieh¹ Jon⁴dai¹; quie¹ a⁴juah⁴ Jon⁴dai¹ Jmai³ i⁴la⁴jang³⁴ a³a⁴hyei⁴ jau²³ quieh¹i³ lang⁴³i³ jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","I² Jon⁴dai¹ Jmai³ ne⁵, ma⁴cúah¹i³ jnia⁴, jian³ a⁴sai⁴i³ jnia⁴ m⁵cu³ la³; i⁴jon³ ¿liah⁴ cúan²³ juah⁴ˉ³ tionh²ˉ³ i⁴a⁴hleh³ˉ⁴ jau²³ i⁴hieh¹ Jon⁴dai¹ quie¹ a⁴juah³ˉ⁴ i⁴lang⁴³ˉ⁴ A³jon⁴³ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Juah⁴ne³ sa⁴júan³⁴ˉ⁴ i⁴júan³ Neih³ˉ⁴, sa⁴hniah³ ma²hainh⁴ˉ³ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","I² juah⁴ne³ júan³⁴ˉ⁴ ne⁵, ua²liah⁴a² sa⁴hnoh³ˉ³ li⁴hainh⁴ˉ³ i²con²³ jnia⁴, ua²li⁴hainh⁴ˉ³ i⁴júan³⁴ˉ⁴ ne³, canh⁴a² li⁴ñih¹ˉ³ jian³ li⁴hainh⁴ˉ³ i⁴sian³ Neih³ˉ⁴ naih⁵ ni²tsei³⁴ˉ⁴ jian³ sian³⁴ jnia⁴ naih⁵ ni²tsei⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Conh⁴liah⁴ i⁴seg³⁴ ma²hnie³⁴i³ sanh³i³ Jesús tionh², i² Jesús, a⁴cm⁴i³ je¹ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","I² jon³ a⁴tyie³⁴i³ liah⁴ i⁴seg³⁴ ta⁵hŋoh³ jm³ Jordán ta⁵jia²³ hyie³ jon³, i²jon³ i²ma²a⁴sion⁴³ Juan²³ chie³ jm³ liah⁴ma²jia⁴³, jian³ a⁴jian⁴i³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jian³ ta² jeun⁴³ chie³ tyie²³ i²con²³i³, jian³ júanh⁴i³ tionh²: ―I⁴chie⁴³pa² Juan²³ hain⁴, i¹con³ ua³júah² sa⁴a⁴júan⁴i³; i² la⁴conh⁴ a⁴hleh⁴i³ nei² quieh¹ a³ne³ ne⁵, ni²tei⁴³ la⁴jeg³⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jian³ ta² jeun⁴³ chie³ ra⁵hain⁴ i²con²³ Jesús i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jian³ ma²sian³ jan³ chie³ a³chieh¹ a³sain³ La², a³sian³ jeu³ Betania, jeu³ sian³ Ma³rei² jian³ Marta reunh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jian³ Ma³rei² la³ a³reunh¹ La² a³chieh¹ hain⁴, jian³ hei⁴ pi²³i³ hain⁴ a⁴sie⁴ o¹jm³no¹ ma³jeu³ si¹tag³² Se³ño²³, jian³ a⁴sei³⁴i³ jeu³ o¹tyi²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","I² li⁵uan⁴ a³m⁴ reunh¹i³ hain⁴ a⁴sain⁴i³ jau²³ i²con²³ Jesús, a⁴juah⁴i³: ―Hnei³ Se³ño²³, ñi³reunh³ˉ³ ra³chieh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","I² con³ma²a⁴nau⁴ Jesús, jon³ a⁴juah⁴i³: ―Chie² jon³, a⁵sia³ leg⁴³ juah⁴ i⁴jaun⁴i³ o³tan²; i⁴jon³pa² canh⁴a² li⁴jnia³ i⁴júanh⁴³ Jon⁴dai¹ Jmai³, jian³ canh⁴a² li⁴jnia³ i⁴júanh⁴³ A³jon⁴³ Jon⁴dai¹ liah⁴ con⁴juah⁴ chie² jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","I² Jesús ne⁵, ta² ma²hnio³⁴i³ Marta, jian³ Ma³rei², jian³ La² reunh¹i³ tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","I² ta⁵ma³a⁴nau⁴ Jesús jau²³ i⁴ra³chieh¹ La² hain⁴, a⁴jian⁴ pi¹i³ i²to⁴jm⁵ i²ma²hein²i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","I² coh⁵ jon³ a²ma⁴ a⁴sagh⁴³i³ chie³ quian¹: ―Ma³²ˉ¹ liah⁴ i⁴seg³⁴ ta⁵húa³⁴ Judea. ");
INSERT INTO cucNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","I² jon³ a⁴sagh⁴³ chie³ quian¹i³: ―Hnei³ A²teg²³, a⁵sia³ jm² ma³ŋo²³ ma²hnie³⁴ judío ma²jŋangh³ hnei³ jeu³ m⁴caun²; ¿jian³ i⁴seg³⁴ hnoh³ˉ³ cúah²ˉ³ liah⁴ i²jon³? ");
INSERT INTO cucNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","I² jon³ a⁴juah⁴ Jesús: ―¿Sa¹ chie⁴³ hei¹ quia⁵teun⁴ o²ra³ con³ jm²? Jian³ a³hain⁴ a³ŋeng²³ i⁴jm²³, a⁵sia³ a²caun² ua²hyanh⁵i³, quie¹ je²³i³ jnia⁴ con⁴juah⁴ joh¹ hyie³; ");
INSERT INTO cucNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","i² a³hain⁴ a³ŋeng²³ je¹nai³, hyanh⁵i³ a²caun², quie¹ ta⁵la⁴ sa⁴jnia⁴ joh¹ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Con³ma²a⁴juah⁴ Jesús jau²³ jon³, ma²jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―Ma³ra³cm² La² ñi³reunh⁴ˉ¹ hain⁴; jon³ hniah³ nai³²ˉ⁴ ni¹ñei³⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","I² jon³ a⁴juah⁴ chie³ quian¹i³ tionh²: ―Hnei³ Se³ño²³, juah⁴ne³ ra³cm²i³, jon³ lei⁴ li⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Quie¹ a⁴hleh⁴ Jesús jau²³ jon³, hnie³⁴ ra³juah⁴ i⁴ma³ra³jaun²i³; i² hei⁴i³ tionh² a⁴júan⁴ co³hei²tsei³ nei² quieh¹ i⁴ra³cm²i³ sie⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","I² jon³ a⁴juah⁴ Jesús ra³jia⁵ i²con²³i³: ―Ma³a⁴jaun³⁴pa² La² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","I⁴jon³ si³hyonh³ˉ⁴ quie¹ sa⁴hein³²ˉ⁴ i²jon³; eu⁴³ re³ quianh³ˉ³ i⁴a⁴leg³⁴ la⁴jon³ canh⁴a² li⁴hainh⁴ˉ³ tionh²ˉ³. I² la⁴ne³ jon³ ma³²ˉ¹ ma⁵nia²ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","I² jon³ a⁴juah⁴ To³ma²³, a³teh²i³ A³cuan²³ On³⁴ hain⁴, a⁴sagh⁴³i³ jon²reunh¹: ―Ma³² jnia¹ liah⁴, ma⁵jaun⁴ˉ¹ jie³ˉ¹ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","I² con³ma²a⁴tyie³⁴ Jesús, jon³ ra⁵ñi³i³ i⁴ma³a⁴teg⁴ quin⁴ jm² hon³ La². ");
INSERT INTO cucNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jian³ jeu³ Betania jon³ nie⁴³ hloh³² Jerusalén la⁴conh⁴ con³ mai²³ ton⁴ ñi⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jian³ ta² jeun⁴³ judío ni²han² jauh³² quieh¹ Marta jian²³ Ma³rei² a³ni²júanh¹ tsei⁴³i³ i⁴jaun² a³reunh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","I² Marta hain⁴, con³ma²a⁴nau⁴i³ jau²³ i⁴ja³⁴ Jesús, jon³ ŋo³⁴i³ ua⁵ma⁵jainh³²i³; i² Ma³rei² reunh¹i³ ne⁵, sainh⁴³ jauh³² pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","I² jon³ a⁴juah⁴ Marta, a⁴sagh⁴³i³ Jesús: ―Hnei³ Se³ño²³, juah⁴ne³ ma²ñih⁴ˉ³ i²la³, a⁵sian⁴³ La² reunh³ˉ⁴ ma²a⁴jaun³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","I² tieh²la³ ne⁵, yan³² jnia⁴ i⁴cúa³⁴ Jon⁴dai¹ la⁴jeg³⁴ i⁴mh³ˉ³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―Jainh¹pa² a³reunh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","I² jon³ a⁴juah⁴ Marta: ―I⁴chie⁴³, yan³² jnia⁴ i⁴hyon⁴³i³ la⁴teg⁴i² hyon⁴³ la⁴jang³⁴ a³jaun² i²a⁴toh⁴ jm². ");
INSERT INTO cucNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","I² jon³ a⁴juah⁴ Jesús liah⁴: ―Jnia⁴pa² júan³⁴ i⁴hyon²³ a³jaun² jian³ i⁴sia³ m⁵cu³ quieh¹i³ liah⁴. Quie¹ a³hain⁴ a³hain⁴ i²con²³ jnia⁴, ua²liah⁴a² jaun²i³, li⁴sian³i³ liah⁴ i⁴seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jian³ la⁴jang³⁴ a³hain⁴ i²con²³ jnia⁴ jian³ sian³i³ con⁴juah⁴ jnia⁴, sa⁴legh⁴ ua²a⁴jaun³⁴i³. ¿O⁴ hainh⁴ˉ³ jau²³ la³? ");
INSERT INTO cucNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","I² jon³ a⁴juah⁴ a³m⁴ hain⁴: ―Jen³⁴, Se³ño²³, hain⁴ jnia⁴ i²conh²ˉ³ i⁴langh⁴³ hnei³ A³lion³ Chie³ hain⁴, A³jon⁴³ Jon⁴dai¹, i⁴a⁴niah³ˉ³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","I² con³ma²a⁴juah⁴i³ jau²³ jon³, jon³ ŋah³ Marta ua⁵teh³i³ Ma³rei² reunh¹, a⁴sagh⁴³i³ ta⁵si²hma², a⁴juah⁴i³: ―A²teg²³ hain⁴ ma³cuan²³ jian³ te²³i³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","I² Ma³rei², con³ma²a⁴nau⁴i³ jau²³ jon³, jon³ ra⁴hang³²i³ liah⁴ma²jon³, ja³⁴i³ i²sainh⁴³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","I² Jesús a⁵sia³ ma³a⁴hei³⁴i³ je¹jeu³, quie¹ si²jian²³ i²jon³ pi¹i³ i²a⁴jainh³ Marta quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","I² judío a³ma²tionh² jauh³² quieh¹ Ma³rei² a³ma²ti²júanh² tsei⁴³i³ hain⁴, con³ma²a⁴je³⁴i³ i⁴ra⁴hang³² Ma³rei² i⁴ua⁵hag⁴³i³ ta¹tia⁴ hion²³, jon³ ua⁵han²i³ coh⁵cah³²i³, a⁴júanh⁴i³: ―Ŋo³⁴ Ma³rei² ua⁵hoh⁴³ i²ra³quian³ La². ");
INSERT INTO cucNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","I² con³ma²a⁴tyie³⁴ Ma³rei² i²si²sainh⁴³ Jesús, jon³ a⁴jen³i³, jian³ a⁴si⁴jnei⁵i³ ta⁵nei²i³, a⁴sagh⁴³i³: ―Se³ño²³, juah⁴ne³ ma²ñih⁴ˉ³ i²la³, a⁵sian⁴³ La² reunh³ˉ⁴ ma²a⁴jaun³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","I² Jesús ne⁵, con³ma²a⁴je³⁴i³ i⁴hoh⁵ Ma³rei² jian³ la⁴jang³⁴ judío a³a⁵han² jian²³i³ liah⁴ ti²hoh⁵, jon³ ra⁵chionh⁴ tsei⁴³ Jesús, a⁴hei³⁴ queuh³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jon³ a⁴ŋang⁴i³: ―¿Jainh¹ a⁴honh⁴³i³ hnei³? I² jon³ a⁴sagh⁴³i³ Jesús: ―Se³ño²³, nia³, ni³je¹. ");
INSERT INTO cucNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","I² jon³ a⁴hoh⁵ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","I² jon³ a⁴juah⁴ judío hain⁴ tionh²: ―¡Ta² ma²li⁴hnio³⁴i³, liah²! ");
INSERT INTO cucNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","I² jon³ a⁴juah⁴ ca³chion²³i³: ―A³ne³pa² hain⁴ a⁴nia³⁴ m⁴nei² a³taun³². ¿Sa¹ ma²li⁴cagh¹i³ jm² i⁴ma²li⁴júan³⁴i³ i⁴sa⁴ma²jaun⁴ La², lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","I² con³ma²a⁴hei³⁴ queuh³ tsei⁴³ Jesús liah⁴ i⁴seg³⁴, jon³ a⁴tyie³⁴i³ i²ra³hon³ La², i²leg⁴³ con³ to³hlo³, jian³ si²jneng³ con³ a²caun² júah³ i²leg⁴³ ho³². ");
INSERT INTO cucNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","I² jon³ a⁴juah⁴ Jesús: ―Qui⁴³ a²caun² ne³ tionh²ˉ³. I² jon³ a⁴juah⁴ Marta, a³reunh¹ a³jaun² hain⁴: ―Hnei³ Se³ño²³, ma³jia²³ ma³jau²³pa² ne³, quie¹ ma³quin⁴ jm² ne³⁴ a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","I² jon³ a⁴juah⁴ Jesús liah⁴: ―¿O⁴ a⁵sia³ ma³a⁴jeu³⁴ˉ⁴ hnei³ juah⁴ne³ hainh⁴ˉ³, li⁴jeh²ˉ³ conh⁴ tei⁴³ júanh⁴³ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","I² jon³ a⁴qui³⁴i³ a²caun² jon³ tionh² to³ i²ma²a⁴quion³i³ a³jaun² hain⁴. I² jon³ a⁴je³⁴ Jesús ta⁵ñi⁴jeu⁵ a⁴juah⁴i³: ―Hnei³ Neih³ˉ⁴, cúa¹ˉ⁴ ti²hmah³² i²conh² hnei³ quie¹ ma³a⁴naih³ˉ³ jau²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Jian³ yan³²ˉ⁴ i⁴nauh³ˉ³ jau²³ quien⁴ˉ⁴ la⁴jeg³⁴ nie⁴³, jian³ a⁴juah³ˉ⁴ jau²³ ne³ nei² quieh¹ la⁴jang³⁴ a³ti²tionh² hloh³² la³, canh⁴a² li⁴hain⁴i³ i⁴hnei³pa² a⁴saih⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","I² con³ma²a⁴juah⁴ Jesús jau²³ ne³, jon³ a⁴hleh⁴i³ con³ i⁴tia⁴: ―¡La², jau²³ hnei³ i²ne³! ");
INSERT INTO cucNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","I² a³ma²jaun² hain⁴, jon³ ua⁵hag⁴³i³ si²ponh²i³ a²hmh³ si¹cúa³i³ si¹tag³²i³ jian³ ra³lie³ a²hmh³ ma³nei²i³. I² jon³ a⁴juah⁴ Jesús: ―Saih³² hnei³ a²hmh³ si²ponh²i³ ne³ canh⁴a² ua²ŋeng⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","I² jeun⁴³ judío a³ma²a⁵han² jian²³ Ma³rei² jian³ a⁴je³⁴i³ la⁴conh⁴ i⁴a⁴júan⁴ Jesús, jon³ ra⁵hain⁴i³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","I² ca³chion²³ a³hain⁴ tionh² ni²han² i²con²³ chie³ fariseo, ni²tya³i³ jau²³ la⁴conh⁴ i⁴a⁴júan⁴ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","I² jon³ a⁴ŋangh³ fariseo tionh² jian²³ m³chie³ tyein² i²a⁴júanh⁴i³: ―¿Liah⁴ júan³²ˉ¹ i²con²³ a³ñih³ hain⁴, lainh⁴ˉ³? Quie¹ ta² hlion⁴ ua³júah² júan³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Juah⁴ne³ con³ i⁴niah¹ˉ¹ la⁴ne³, la⁴jang³⁴pa² li⁴hain⁴ i²con²³i³, jian³ li⁴jia²³ a²hlie⁴ romano tionh² li⁴yi⁴jeun⁴³i³ cuah³júah² hen² quian⁴ˉ¹, jian³ li⁴ma⁵tyie³i³ jnia¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jan³ a³hain⁴ tionh² a³sain³ Caifás, a³lang⁴³ jeu³² m³chie³ ñi³ jon³, jon³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―Ta² sa⁴ñih¹ˉ³ tionh²ˉ³, ");
INSERT INTO cucNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","jian³ a⁵sia³ co³hei²tsei³ sianh³ˉ³ i⁴eu⁴³ga² re³ i⁴jaun⁴ jan³ chie³ nei² quieh¹ a³jeu³ la⁴conh⁴a² i⁴tyan⁴³ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I² jau²³ ne³ a⁵sia³ a⁴hleh⁴i³ con⁴juah⁴ co³hei²tsei³ quieh¹ hña³, i² quie¹ ta⁵la⁴ ma²lang⁴³i³ jeu³² m³chie³ ñi³ jon³, i⁴jon³ a⁴cúa⁴ Jon⁴dai¹ co³hei²tsei³ quieh¹i³ i⁴a⁴juah⁴i³ i⁴jaun⁴ Jesús nei² quieh¹ la⁴jang³⁴ a³jeu³; ");
INSERT INTO cucNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","jian³ a⁵jon⁴³ jmah³ nei² quieh¹ jeu³ jon³ jaun⁴i³, quie¹ jaun⁴i³ nei² quieh¹ la⁴jang³⁴ si³jon⁴³ Jon⁴dai¹ a³tionh² ma⁵quein²³ jeu³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","I² jon³ ne⁵, liah⁴ma²jm² jon³ ra⁴lie⁵ i⁴júan³ si³ta¹ re³ i⁴jŋangh³i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","I⁴jon³ a⁵sie⁴³ a⁴ŋeng⁴ Jesús i²ni¹jia⁵ nai² jen² judío, quie¹ ua⁵hag⁴³i³ húa³⁴ Judea jon³, quie¹ ŋo³⁴i³ hloh³² con³ i²a⁵sian⁴³ a³sian³, la⁴teg⁴ con³ jeu³ i²sain³ Efraín. I²jon³ a⁴jian⁴i³ jian²³ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jian³ ma³ja²³ hloh³² jm² i⁴júan³ judío tionh², jm² i⁴a⁴lon⁴ jmai³sie²³i³ húa³⁴ Egipto, jian³ ta² jeun⁴³ tyie²³ Jerusalén a³sian³ ma⁵quein²³ jeu³ i⁴júan³i³ i⁴so⁴heinh⁵i³ naih⁵i² teg³⁴ jm² jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jian³ i²jon³ ti²hnah³i³ Jesús; i² con³ma²tionh²i³ cuah³júah², jon³ a⁴ŋangh³i³ a³jan³ jan³, juah⁴i³: ―¿Liah⁴ lainh⁴ˉ³ tionh²ˉ³? ¿O⁴ jia²³ a³hain⁴ jm² la³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Quie¹ ta⁵la⁴ m³chie³ tyein² jian²³ chie³ fariseo ma³a⁴júan⁴i³ heih⁴³ i²con²³ chie³ juah⁴ne³ hain³ a³ñi³ i²sainh⁴³ Jesús, jon³ ma³sia² júan³⁴i³ jau²³, canh⁴a² júan³⁴i³ chion³². ");
INSERT INTO cucNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Liah⁴i² jñei⁴ jm², jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto, ŋo³⁴ Jesús jeu³ Betania, jeu³ i²sian³ La², a³ma²a⁴jaun³⁴ hain⁴, jian³ a³a⁴júan⁴i³ i⁴a⁴hyon²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","I² jon³ a⁴júan⁴i³ con³ ma³⁴ i⁴ma⁵con⁴³i³ Jesús; i² Marta si²tya²³ ma³⁴, jian³ ua²cua⁴³ La² jen² a³tionh² mesa a³ti²queuh³ jian²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jon³ a⁴can³⁴ Ma³rei² teun³⁴ cua² o¹jm³no¹ ma³jeu³ i⁴leg⁴³ jmah³ nardo i⁴tyein² húanh², jon³ a⁴sie⁴i³ si¹tag³² Jesús, ma²jon³ a⁴sei³⁴i³ jeu³ o¹tyi²i³. Jian³ la⁴tan² jauh³² a⁴hag⁴ ma³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","I² jon³ a⁴juah⁴ Judas Iscariote, a³jon⁴³ Si²úan¹, jan³ chie³ quian¹ Jesús, a³hain⁴ a³cúah⁴³ quieh¹i³: ");
INSERT INTO cucNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿E⁴le³⁴ sa⁴a⁴hnang⁴i³ o¹jm³no¹ ma³jeu³ ne³ hneng³ nia⁴lo⁴ o¹cau³² denario, canh⁴a² ma²ma⁵hon³²i³ a³ti⁴ñei³? ");
INSERT INTO cucNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jian³ a⁵sia³ a⁴juah⁴i³ i⁴ne³ o⁴ quie¹ i⁴júan³i³ co³hei²tsei³ nei² quieh¹ a³ti⁴ñei³ tionh², i⁴jon³pa², quie¹ lang⁴³i³ hang³, jian³ hei¹ joh⁴³ cúa³i³ a²to³hmh³ quieh¹ o¹cau³², jian³ qui²³i³ ma⁵meih³ la⁴jeg³⁴ o¹cau³² i⁴tonh² chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","I² jon³ a⁴juah⁴ Jesús: ―A⁵hnia³ hnei³, quie¹ a⁴júan⁴i³ i⁴ne³ quieh¹ jm² i⁴hon³⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Quie¹ la⁴jeg³⁴ jm²pa² sian³ a³ti⁴ñei³ jenh²ˉ³ tionh²ˉ³; i² jnia⁴ ne⁵, a⁵sia³ la⁴jeg³⁴ jm² jianh²ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","I² jon³ ta² jeun⁴³ chie³ judío ra⁵ñi³ i⁴hein² Jesús jeu³ Betania, i² jon³ ua⁵han²i³ ua⁵jen³²i³ Jesús, jian³ a⁵hei⁴³ jmah³ Jesús, quie¹ ua⁵jen³²i³ La² liah⁴, a³hain⁴ a³a⁴júan⁴ Jesús i⁴a⁴hyon²³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jian³ a⁴júan⁴ la⁴jang³⁴ m³chie³ tyein² re³ i⁴jŋangh³i³ La² liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","quie¹ nei² quieh¹ hei⁴ pi²³i³, jeun⁴³ chie³ judío ma³cm³ i²con²³i³ tionh² i⁴li⁴hain⁴ i²con²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jian³ ta² jeun⁴³ chie³ ma³a⁴tyie³⁴ Jerusalén jm² júah³ jon³; i² con³ma²a⁴jnia³⁴, jon³ ra⁵ñi³i³ tionh² i⁴ma³o¹tyie¹ Jesús je¹jeu³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","I² jon³ a⁴queih³i³ o¹cúah² hma³ seun⁴³ tionh², jian³ ua⁵han²i³ ua⁵hyeinh³²i³ Jesús, ti²hleh²i³ tia⁴: ―¡Júanh⁴³ Jon⁴dai¹! ¡Ta² tsei³⁴ jm² ren³ a³ja²³ con⁴juah⁴ jm³i⁴sain³ Se³ño²³ Jon⁴dai¹, a³hain⁴ a³lang⁴³ Re¹ quian¹ a³jeu³ Israel! ");
INSERT INTO cucNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","I² jon³ a⁴chianh¹ Jesús jan³ a²lo¹siah³, jian³ a⁴ua⁴tsain³²i³ liah⁴i² ra³sag² Ma²jyi³: ");
INSERT INTO cucNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","A⁵júan³ hnei³ canh⁴³, a³tionh² je¹jeu³ Sión; jeh³², ma³ja²³ Re¹ quianh³ˉ³, ua²tsain¹ jan³ a²lo¹siah³ peih¹. ");
INSERT INTO cucNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jian³ co⁴ra⁴lie⁵ jon³, sa⁴ra⁵ŋang⁴ chie³ quian¹i³ la⁴jeg³⁴ i⁴jon³; i² con³ma²a⁴leg³⁴ i⁴tyein² júanh⁴³ Jesús, jon³ pi¹ a⁴tyon²³ tsei⁴³ chie³ quian¹i³ tionh² la⁴conh⁴ i⁴ra³sag² nei² quieh¹i³, la⁴conh⁴ i⁴a⁴jainh⁴³i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jian³ a³hain⁴ a³ma²jian²³ Jesús tionh² con³ma²a⁴teh³i³ La² i²ra³hon³ i⁴a⁴júan⁴i³ i⁴a⁴hyon²³i³, tya²³i³ jau²³ la⁴jeg³⁴ i⁴a⁴je³⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","I⁴jon³ a⁴húan³i³ je¹jeu³ i⁴ua⁵hyeinh³²i³ Jesús, quie¹ a⁴nau⁴i³ jau²³ i⁴a⁴júan⁴ Jesús ua³júah² jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","I² jon³ a⁴júanh⁴ fariseo tionh²: ―Jeh⁴ˉ³ tionh²ˉ³, i¹con³ a⁵sie⁴³ liah⁴ li⁴lei⁴. Jeh³², la⁴jang³⁴ chie³ ma³ya¹han² coh⁵cah³²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jian³ ma²tionh² co⁴meih³ chie³ griego jen² chie³ a³ni²han² jm² júah³ jon³ jeu³ Jerusalén, a³ni²ma⁴con³² Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","I² chie³ ne³ tionh², a⁴tyie³⁴i³ i²con²³ Lei³², a³sian³ jeu³ Betsaida nie⁴³ húa³⁴ Galilea, a⁴mh³i³ Lei³², a⁴juah⁴i³: ―Hnei³ a³don⁵, hnie³⁴ jnie³² nia³² jnie³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","I² Lei³² ne⁵, ŋo³⁴i³ ua⁵saih¹i³ Dre¹ jau²³ jon³; i² jon³ ŋo³⁴i³ li⁵uan⁴i³ la⁴jon³ ua⁵tyieh²i³ Jesús jau²³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","I² jon³ a⁴juah⁴ Jesús: ―Ma³a⁴tyie³⁴ jm² tieh²la³ i⁴lei⁴ tyein² júanh⁴³ A³a⁴lang³⁴ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, juah⁴ne³ sa⁴a⁴hei³⁴ con³ m⁴cu³ húa³⁴ jian³ jyah³, sa⁴li⁴hlion⁴ juah⁴ne³ liah⁴ma³leg⁴³ jon³ con³ m⁴; i² juah⁴ne³ jyah³ ne⁵, hlion⁴ o¹jeun³ cúa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A³hain⁴ a³hnie³⁴ lion⁴ m⁵cu³ quieh¹ nei² cuah³²húa³⁴ la³, si⁵hain⁴i³; jian³ a³hain⁴ a³sa⁴ro³ jeu³ m⁵cu³ quieh¹ nei² cuah³²húa³⁴ la³, hyieh⁴i³ m⁵cu³ quieh¹ i⁴sa⁴ton³ jm² ua²tya⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jian³ a³hain⁴ a³hnie³⁴ cúa³⁴ cúa³tag³² i²con²³ jnia⁴, ua²jia³i³ coh⁵cah³ˉ⁴; jian³ i²jon³ i²cua³²ˉ⁴, si⁵cua³ a³cúa²³ cúa³tag³² i²con²³ jnia⁴ liah⁴. Jian³ juah⁴ne³ cúa²³ jan³ cúa³tag³² i²con²³ˉ⁵, jon³ júan³⁴ Neih³ˉ⁴ i⁴júanh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’¡Ta² sa⁴yan³²ˉ⁴ liah⁴ sian³⁴ˉ⁴ tieh²la³! ¿I² henh⁴a² li⁴juah¹ˉ⁴? ¿O⁴ li⁴juah¹ˉ⁴: “Hnei³ Neih³ˉ⁴, lie³² jnia⁴ la⁴jeg³⁴ i⁴jain⁴³ˉ⁴ tieh²la³”? A⁵sia³, i⁴jon³pa² cuan⁵ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Hnei³ Neih³ˉ⁴, júan² hnei³ i⁴júah³ jm³i⁴sainh³ˉ³. I² jon³ ja³⁴ con³ jau²³ teg⁴ ñi⁴jeu⁵, i⁴juah⁴i³: ―Ma³a⁴júan³⁴pa² jnia⁴ i⁴júah³ jm³i⁴sain³⁴ˉ⁴, jian³ júan¹ pi¹ jnia⁴ liah⁴ i⁴seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","I² la⁴jang³⁴ chie³ jeun⁴³ a³ti²tionh² i²jon³ jian³ a⁴nau⁴i³ jau²³ jon³, jon³ a⁴juah⁴i³ i⁴a⁴hain³² tia⁴ i⁴a⁴júan⁴ jan³ a⁵ñih³; i² ca³chion²³ a⁴juah⁴: ―Jan³ ángel pa² a⁴hleh⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","I² jon³ a⁴juah⁴ Jesús: ―A⁵sia³ ja³⁴ jau²³ ne³ juah⁴ nei² quien⁴ˉ⁴, quie¹ nei² quianh³ hnei³pa² tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","I² tieh²la³ ma³a⁴tyie³⁴ jm² i⁴can³⁴ Jon⁴dai¹ jau²chie⁴³ i²con²³ m⁵cu³, jian³ ma³a⁴tyie³⁴ jm² i⁴tyein⁵i³ a³sa⁴tsein³⁴ a³júan³ heih⁴³ i²con²³ a³tionh² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","I² tei⁴³i² ma³a⁴sie⁴³i³ jnia⁴ yeih³² nei² cuah³²húa³⁴ la³, ma²jon³ teh²ˉ⁵ la⁴jang³⁴ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","A⁴hleh⁴i³ jau²³ ne³, a⁴he⁴i³ hain³liah⁴ jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","I² jon³ a⁴ŋangh³ chie³ hain⁴ tionh²: ―Quie¹ ma³ti²nia² jnie³² con⁴juah⁴ i⁴ra³hleh² lai²³ i⁴li⁴sian³ A³ma²ya⁴lion³² Chie³ hain⁴ sa⁴ton³ jm² ua²tya⁴³. ¿I² liah⁴ cúan²³ juah⁴ hnei³ ne⁵ i⁴hniah³ sion⁵i³ yeih³² A³a⁴lang³⁴ Chie³ hain⁴? ¿Hain³ hain⁴ A³a⁴lang³⁴ Chie³ hain⁴ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","I² jon³ a⁴juah⁴ Jesús: ―Sia³ pi¹ i²co⁴le⁴ joh¹ jenh²ˉ³ tionh²ˉ³. I⁴jon³ hniah³ ŋengh²ˉ³ ta¹la⁴ sia³ joh¹ con³na¹a⁴nai³ la⁴conh⁴ sa⁴jianh³ˉ³; quie¹ a³hain⁴ a³ŋeng²³ i²naih³ sa⁴ñi³i³ tangh⁵ chie³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","I⁴jon³ hniah³ li⁴hainh⁴ˉ³ i²con²³ a³hain⁴ a³lang⁴³ joh¹, ta¹la⁴ sia³ joh¹ canh⁴a² lainh⁴ hnei³ chie³ quian¹ joh¹ tionh²ˉ³. Ta⁵ma³a⁴hleh⁴ Jesús jau²³ jon³, jon³ ua⁵hag⁴³i³, a⁵sie⁴³ ma⁴jnia³²i³ jen² a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jian³ ua²liah⁴a² a⁴júan⁴ Jesús hlion⁴ ua³júah² ta⁵nei²i³ tionh², a⁵sia³ ra⁵hain⁴i³ i²con²³i³; ");
INSERT INTO cucNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","canh⁴a² la⁴ne³ li⁴tei⁴³ jau²³ i⁴a⁴sag⁴ Isaías, a³sain² hain⁴, i⁴ra³juah⁴: Hnei³ Se³ño²³, ¿hain³ pi² ra⁵hain⁴ jau²³ i⁴a⁴hleh²ˉ¹? ¿Jian³ hain³ i²con²³ a⁴jñeih³ ua³pei⁴ quieh¹ Se³ño²³? ");
INSERT INTO cucNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","I⁴jon³da³ sa⁴li⁴hain⁴i³, quie¹ a⁴sag⁴ Isaías liah⁴: ");
INSERT INTO cucNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","A⁴júan⁴ Jon⁴dai¹ i⁴taun³²i³ jian³ i⁴huah³ m⁴tyi⁴ quieh¹i³, canh⁴a² sa⁴je³⁴i³ jeu³ m⁴nei²i³ tionh², jian³ sa⁴li⁴ŋang⁴i³ teg⁴ m⁴tyi⁴ quieh¹i³, jian³ sa⁴i²sag³⁴i³ co³hei²tsei³ quieh¹, canh⁴a² ma²júan³²ˉ⁴ i⁴huan⁴ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","A⁴hleh⁴ Isaías jau²³ ne³ con³ma²a⁴je³⁴i³ conh⁴ tei⁴³ júanh⁴³ Jesús jian³ a⁴hleh⁴i³ nei² quieh¹i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","I² la⁴jon³ ne⁵, jeun⁴³ judío ra⁵hain⁴ i²con²³ Jesús, jian³ la⁴teg⁴ a³tyein² a³ti²quian³ ma³tyi² jen²i³ tionh² liah⁴, ra⁵hain⁴i³; jian³ a⁵sia³ a⁴hleh⁴i³ ra³jia⁵ i⁴hain⁴i³ ta⁵nei² chie³, quie¹ con⁴³i³ fariseo, quie¹ con³na¹a⁴húa⁴³ a³hain⁴ cuah³ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Quie¹ eu⁴³ si³hyonh³i³ sainh³i³ re³ ta⁵nei² chie³, la⁴conh⁴a² i⁴sainh³i³ re³ ta⁵nei² Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jon³ a⁴hleh⁴ Jesús con³ i⁴tia⁴, a⁴juah⁴i³: ―A³hain⁴ a³hain⁴ i²con²³ jnia⁴, a⁵jon⁴³ jmah³ i²con²³ jnia⁴ hain⁴i³, quie¹ hain⁴i³ i²con²³ a³a⁴sai⁴ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jian³ a³hain⁴ a³je³ jnia⁴, jen³i³ a³a⁴sai⁴ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jnia⁴ a³lang⁴³ joh¹, cuan⁵ˉ⁵ m⁵cu³ la³ canh⁴a² la⁴jang³⁴ a³hain⁴ i²con²³ jnia⁴, a⁵sie⁴³ ma⁵tionh²i³ i²naih³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jian³ a³hain⁴ a³nau³ jau²³ quien⁴ˉ⁴ juah⁴ i⁴sa⁴ma³tei⁵i³, a⁵sian⁴³ jnia⁴ queih¹ heih⁴³ i²con²³i³; quie¹ a⁵sia³ cuan⁵ˉ⁵ juah⁴ i⁴ni³tion⁵ˉ⁵ a³m⁵cu³ i²hlagh³², quie¹ i⁴jon³pa² cuan⁵ˉ⁵ i⁴ua⁵lion³²i³ jnia⁴ pi²³. ");
INSERT INTO cucNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","A³hain⁴ a³ton²³ jnia⁴, jian³ sa⁴hyei³i³ jau²³ quien⁴ˉ⁴, sia³ con³ i⁴queih³ heih⁴³ i²con²³i³: quie¹ jau²³ i⁴ma³a⁴hleh³ˉ⁴ i⁴ne³pa² queih³ heih⁴³ i²con²³i³ jm² i²a⁴toh⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Quie¹ a⁵sia³ hleh³ˉ⁴ con⁴juah⁴ co³hei²tsei³ quien⁴ˉ⁴ húan⁵ˉ⁵; Neih³ˉ⁴ a³a⁴sai⁴ jnia⁴, hei⁴ pi²³i³ a⁴júan⁴ heih⁴³ henh⁴ hniah³ he¹ˉ⁴ jian³ henh⁴ hniah³ hleh¹ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jian³ yan³²ˉ⁴ heih⁴³ quieh¹ Neih³ˉ⁴ quian³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³. I² la⁴jon³ ne⁵, la⁴conh⁴ i⁴hleh³ˉ⁴, hleh³ˉ⁴ la⁴conh⁴ i⁴a⁴sag⁴³ jnia⁴ Neih³ pe²³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ma³a⁴teg⁴ hlo⁴ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto jon³. Jian³ ma³ñi³ Jesús i⁴ma³a⁴teg⁴ o²ra³ i⁴si⁵hag⁴³i³ m⁵cu³ la³ i⁴chianh³i³ i²con²³ Jmai³i³. Jian³ la⁴ne³ ra⁵hnio³⁴i³ la⁴jang³⁴ chie³ quian¹ a³tionh² m⁵cu³ la³, ra⁵hnio³⁴i³ la⁴conh⁴ jm² i⁴a⁴ŋeng⁴i³ jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Jian³ liah⁴ma²jia⁴³ ñeih³² a⁴cúa⁴ a³sa⁴tsein³⁴ co³hei²tsei³ i²con²³ Judas Iscariote, a³jon⁴³ Si²úan¹, i⁴cúanh⁴³i³ Jesús. Jian³ ma³ñi³ Jesús i⁴ja³⁴i³ i²con²³ Jon⁴dai¹ Jmai³, jian³ i⁴chianh³i³ liah⁴ i²con²³ Jon⁴dai¹, jian³ i⁴ma³a⁴tonh³ Jmai³i³ joh⁴³ cúa³i³ la⁴jeg³⁴; i² jon³ ne⁵, con³ma²ti²queuh³i³ a²hei⁴³, jon³ a⁴no³ Jesús i²ma²ua²queuh³i³, a⁴tyi³i³ con⁴jeu⁴ a²cúan³ i⁴hein²i³ coh⁵, i² jon³ a⁴tang⁴i³ con³ a²hmh³ jonh², a⁴hñih³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jon³ a⁴ro⁴i³ o¹jm³ joh⁴³ con³ a²heu⁴³, jian³ ma⁴lie⁵i³ raunh⁵i³ si¹tag³² chie³ quian¹ tionh², jian³ a⁴sei³⁴i³ jeu³ a²hmh³ jonh² i⁴hñih²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","I² con³ma²a⁴teg⁴ i²raunh⁵i³ tag³² Si²úan¹ Pe³², jon³ a⁴juah⁴ Pe³²: ―Hnei³ Se³ño²³, ¿liah⁴ cúan²³ hnei³ raunh³² si¹tag³⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","I² jon³ a⁴ŋangh³ Jesús, a⁴sagh⁴³i³: ―La⁴conh⁴ i⁴si²júan³⁴ jnia⁴, a⁵sia³ li⁴ŋangh⁴ˉ³ tieh²la³; ta⁵cang³ ne³pa² li⁴ŋangh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","I² jon³ a⁴juah⁴ Pe³²: ―Sa⁴cúan²³ juah⁴ i⁴raunh³²ˉ³ si¹tag³⁴ˉ⁴. I² jon³ a⁴ŋangh³ Jesús liah⁴: ―I² juah⁴ne³ sa⁴raunh²ˉ⁵ si¹tagh¹ˉ³, a⁵sie⁴³ ma⁵tainh⁴³ˉ³ i²con²³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","I² jon³ a⁴juah⁴ Si²úan¹ Pe³²: ―Hnei³ Se³ño²³, juah⁴ne³ la⁴jon³, a⁵sia³ raunh³²ˉ³ jmah³ si¹tag³⁴ˉ⁴, quieh¹ hniah³ raunh³²ˉ³ si¹cúa³⁴ˉ⁴ jian³ ma³tyi³⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","I² jon³ a⁴juah⁴ Jesús liah⁴: ―A³hain⁴ a³ma³ni²lieh³, a⁵sie⁴³ ma⁵hniah³ loh³i³, quie¹ jmah³ si¹tag³² pi²³i³ hniah³ quei⁴, quie¹ ma³si²cang⁴ pi²³i³ la⁴tan² jan³i³. Jian³ ma³ti²cangh⁴pa² hnei³ tionh²ˉ³, ua²liah⁴a² sa⁴la⁴jangh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Quie¹ ma³ñi³ Jesús hain³ cúah⁴³ quieh¹i³; i⁴jon³ a⁴juah⁴i³: “A⁵sia³ ti²cangh⁴ˉ³ la⁴jangh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","I² la⁴ne³ ne⁵, ta⁵ma³a⁴raunh⁵i³ si¹tag³² la⁴jang³⁴ chie³ quian¹, jon³ a⁴hei³⁴i³ a²cúan³ i⁴hein²i³ coh⁵ jon³, jian³ a⁴hei³⁴i³ liah⁴ i⁴seg³⁴ mesa, jian³ a⁴sagh⁴³i³ a³hain⁴ tionh²: ―¿O⁴ a⁴quienh³ tyih³ˉ³ i⁴ma³ra³júan³⁴ˉ⁴ ne³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","I² hnei³ tionh²ˉ³ ne⁵, teh⁵ˉ³ jnia⁴ A²teg²³ jian³ A³tyein² liah⁴; i² tsei³⁴pa² hleh³ˉ³ la⁴ne³, quie¹ lang⁴³ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Quie¹ lang⁴³ jnia⁴ A³tyein² jian³ A²teg²³, jian³ a⁴raunh⁵ˉ⁵ si¹tagh¹ˉ³ tionh²ˉ³, jian³ la⁴ne³ hniah³ raunh³²ˉ³ si¹tagh¹ la⁴jan³ jan³ hnei³ tionh²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Quie¹ ma⁴jnia³²ˉ⁴ liah⁴ hniah³ júanh²ˉ³ tionh²ˉ³ canh⁴a² liah⁴i² a⁴júan³⁴ˉ⁴ ne³, la⁴ne³ hniah³ júanh²ˉ³ tionh²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³cúa²³ cúa³tag³² a⁵sia³ júanh⁴³i³ la⁴conh⁴a² jeu³²i³, jian³ a⁵ga⁴ a³sain² liah⁴ juah⁴ júanh⁴³ pi¹i³ la⁴conh⁴a² a³a⁴sai⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jian³ ta² tsei³⁴ jm² renh³ˉ³ juah⁴ne³ ŋangh⁴ˉ³ jau²³ la³ jian³ ma⁵teih³²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’A⁵sia³ hleh³ˉ⁴ nei² quianh³ˉ³ la⁴jangh³ˉ³ tionh²ˉ³, quie¹ cm⁴³ˉ⁴ la⁴conh⁴ a³a⁴quianh⁵ˉ⁵, quie¹ hniah³ li⁴tei⁴³ la⁴conh⁴ ra³sag² Ma²jyi³ i⁴ra³juah⁴: “A³hain⁴ a³ua²queuh³ jian²³ˉ⁵, ra⁵hie²³i³ i⁴jainh²i³ i⁴hlagh³² i²con²³ˉ⁵.” ");
INSERT INTO cucNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jian³ teg⁴ to⁴ne⁵ la³ jeu³⁴ˉ⁴ hnei³ i⁴la³ tionh²ˉ³ i⁴ya¹jian⁴³ jau²³, canh⁴a² la⁴teg⁴i² jain⁴³ˉ⁴ i⁴jain⁴³ˉ⁴, jon³ li⁴hainh⁴ˉ³ i⁴jnia⁴pa² hain⁴ a³ma²jia²³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³hyein⁴³ a³sain¹ jnia⁴, hyei⁴³i³ jnia⁴ liah⁴; jian³ a³hain⁴ a³hyei⁴³ jnia⁴, hyein⁴³i³ a³a⁴sai⁴ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","I² con³ma²a⁴juah⁴ Jesús jau²³ jon³, jon³ a⁴hei³⁴ queuh³ tsei⁴³i³, jon³ a⁴hleh⁴i³ ra³jia⁵, a⁴juah⁴i³: ―I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i⁴jan³ hnei³ tionh²ˉ³ cúah⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","I² chie³ quian¹i³ tionh², a⁴jen³i³ la⁴jan³ jan³ jon²reunh¹ i⁴sa⁴ñi³i³ hain³ hen⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","I² jan³ chie³ quian¹ Jesús, a³hain⁴ a³eu⁴³ hnio³⁴ Jesús a³ua²cua⁴³ hlonh²i³, ");
INSERT INTO cucNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","i²con²³ a³ne³ a⁴júan⁴ Si²úan¹ Pe³² lei³ i⁴ŋangh³i³ Jesús hain³ chianh² hain⁴ hleh²i³ nei² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","I² a³ua²cua⁴³ hlonh²i³ hain⁴ ne⁵, jon³ ŋo³⁴i³ i²co⁴meih³ hlonh² Jesús, a⁴juah⁴i³: ―Hnei³ Se³ño²³, ¿hain³ chianh² hain⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jon³ a⁴ŋangh³ Jesús: ―A³hain⁴ a³cúah²ˉ⁵ a²hei⁴³ñih¹ ra³hyeih², a³hain⁴pa² hain⁴. Jon³ a⁴hyeih³i³ a²hei⁴³ñih¹, a⁴cúah³i³ Judas Iscariote, a³jon⁴³ Si²úan¹. ");
INSERT INTO cucNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","I² con³ma²a⁴queuh³i³ a²hei⁴³ñih¹ jon³, jon³ a⁴hei³⁴ a⁵lainh³² naih⁵ ni²tsei⁴³i³. I² jon³ a⁴juah⁴ Jesús: ―La⁴conh⁴ i⁴i²júanh²ˉ³, júan² hnei³ ta¹tia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jian³ i¹jan³ a³ti²queuh³ nei² a²me²sa³ jon³ sa⁴ra⁵ŋang⁴i³ e⁴le³⁴ a⁴hleh⁴ Jesús jau²³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","I² quie¹ ma²lang⁴³ Judas a³hei¹ joh⁴³ cúa³ a²to³hmh³ tieh³² o¹cau³², i⁴jon³ ra⁵lain⁴ ca³chion²³ i⁴a⁴juah⁴ Jesús i²con²³i³: “Cua³ ua⁴lia⁴³ hnei³ i⁴hniah³ quian⁴ˉ¹ jm² la³”; jian³ o⁴ ma²si⁵cúah²i³ a³ti⁴ñei³ meih³ o¹cau³². ");
INSERT INTO cucNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","I² con³ma²a⁴queuh³ Judas a²hei⁴³ñih¹ jon³, jon³ ua⁵hag⁴³i³; jian³ ma³nai³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","I² con³ma²ua⁵hag⁴³ Judas, jon³ a⁴juah⁴ Jesús: ―Tieh²la³ li⁴jnia³ i⁴júanh⁴³ A³a⁴lang³⁴ Chie³ hain⁴, jian³ li⁴jnia³ i⁴júanh⁴³ Jon⁴dai¹ con⁴juah⁴ hei⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","I² juah⁴ne³ li⁴jnia³ i⁴júanh⁴³ Jon⁴dai¹ con⁴juah⁴ hei⁴i³, jon³ ma⁵jnia³ Jon⁴dai¹ liah⁴ i⁴júanh⁴³ A³jon⁴³i³, jian³ ma⁵jnia³i³ i⁴júanh⁴³i³ ta¹tia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hnei³ tionh²ˉ³ jon²³ quian³⁴ˉ⁴, cua³² pi¹ jnia⁴ ta¹la⁴ co⁴le⁴ jenh²ˉ³ tionh²ˉ³. Jian³ hnoh³²ˉ³ jnia⁴ tionh²ˉ³; i² liah⁴i² a⁴jeu³⁴ˉ⁴ judío tionh², la⁴jon³ jeu³⁴ˉ⁴ hnei³ liah⁴ tionh²ˉ³ tieh²la³: I²jon³ i²naih²ˉ⁵ sa⁴li⁴cúah¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","I² cúa¹ˉ⁴ con³ heih⁴³ hm³⁴ i²conh²ˉ³ tionh²ˉ³: i⁴jon³ i⁴ma²hnoh³²ˉ³ a³jan³ jan³. La⁴jon³ liah⁴i² hno⁵ˉ⁵ hnei³ tionh²ˉ³, la⁴ne³ ma²hnoh³²ˉ³ a³jan³ jan³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Jian³ la⁴ne³ li⁴cu²³ hnei³ la⁴jang³⁴ i⁴langh⁴³ˉ³ chie³ quian³⁴ˉ⁴, juah⁴ne³ ma⁵jniah³²ˉ³ i⁴hnoh⁴³ˉ³ a³jan³ jan³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jon³ a⁴ŋang⁴ Si²úan¹ Pe³² i²con²³ Jesús: ―Hnei³ Se³ño²³, ¿jainh¹ cúah²ˉ³? I² jon³ a⁴ŋangh³ Jesús: ―I²jon³ i²naih²ˉ⁵, sa⁴li⁴si²tyeinh³²ˉ³ coh⁵cah³ˉ⁴ tieh²la³; i² ta⁵cang³pa² li⁴cúah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","I² jon³ a⁴juah⁴ Pe³²: ―Hnei³ Se³ño²³, ¿e⁴le³⁴ heh²ˉ³ sa⁴li⁴nai³²ˉ⁴ coh⁵cah³²ˉ³ tieh²la³? Sainh⁴³ re³pa² jnia⁴ cúa¹ˉ⁴ m⁵cu³ quien⁴ nei² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jon³ a⁴ŋangh³ Jesús: ―¿O⁴ i⁴chie⁴³ cúah²ˉ³ m⁵cu³ quianh³ nei² quien⁴ˉ⁴, lainh⁴ˉ³? Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ i⁴jlianh³²ˉ³ hnang²³ nie⁴³ i⁴sa⁴cuh⁴³ˉ³ jnia⁴ naih⁵i² hoh⁵ a¹hyie²³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’A⁵júan³ hnei³ hlion⁴ co³hei²tsei³ i⁴so⁵ñih¹ˉ³ liah⁴ sianh³ˉ³; quie¹ ti²hain³² hoh⁴³ˉ³ i²con²³ Jon⁴dai¹, jian³ la⁴ne³ hniah³ hangh³²ˉ³ hoh⁴³ i²con²³ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Quie¹ jauh³² quieh¹ Neih³ˉ⁴, ta² júah³ sia³ i²li⁴cua³⁴i³; i² juah⁴ne³ sa⁴ma²leg⁴³ la⁴ne³, liah⁴ma²jia⁴³pa² ma²a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³. I² la⁴ne³ jon³ naih²ˉ⁵ ni¹júanh³²ˉ⁴ re³ i²neih²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","I² tei⁴³i² ma³a⁴ñeih⁵ˉ⁵ i⁴ni¹júanh³²ˉ⁴ re³ i²neih²ˉ³ jon³, ma²jon³ nioh²ˉ⁵ liah⁴ i⁴seg³⁴ i⁴ni²te³²ˉ⁴ hnei³ tionh²ˉ³ i⁴chieh²ˉ¹ jie³ˉ¹, canh⁴a² ua²neih⁴ˉ³ i²jon³ i²ni¹nei³⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jian³ ma³ñih¹pa² hnei³ jainh¹ naih²ˉ⁵ jian³ hain³ jeu³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","I² jon³ a⁴juah⁴ To³ma²³: ―Hnei³ Se³ño²³, sa⁴nia² jnie³² jainh¹ cúah²ˉ³. ¿I² liah⁴ li⁴nia² jnie³² jeu³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","I² jon³ a⁴juah⁴ Jesús: ―Jnia⁴pa² lang⁴³ jeu³, jian³ jau²³ ni²tei⁴³, jian³ m⁵cu³ quieh¹ chie³ liah⁴. I¹jan³ sa⁴li⁴tyie¹ i²con²³ Jon⁴dai¹ Jmai³ juah⁴ne³ sa⁴ja³⁴i³ con⁴juah⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Juah⁴ne³ ma²cuh⁴³ˉ³ jnia⁴, ma²cmh⁴³pa² hnei³ Neih³ˉ⁴ tionh²ˉ³ liah⁴; tieh²la³ jian³ ta⁵i²chie³²ˉ¹ la³ ma³cmh⁴³ pi²³i³ hnei³ jian³ ma³a⁴jenh³²i³ hnei³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","I² jon³ a⁴juah⁴ Lei³²: ―Hnei³ Se³ño²³, ma⁴jnia³² hnei³ Naih⁴³ i²con²³ jnie³², canh⁴a² li⁴hyon³ tsei⁴³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jon³ a⁴juah⁴ Jesús: ―Hnei³ Lei³², hlion⁴pa² jm² ma³ŋo²³ i⁴ŋeng³⁴ˉ⁴ jian²³ˉ⁵ hnei³ tionh²ˉ³. ¿O⁴ i¹ ne³⁴ ma⁴sa⁴cuh⁴³ˉ³ jnia⁴? A³hain⁴ a³je³ jnia⁴, jen³i³ Neih³ˉ⁴ liah⁴. ¿I² e⁴le³⁴ juah⁴ˉ³ ne⁵: “Ma⁴jnia³² hnei³ Naih⁴³ i²con²³ jnie³²”? ");
INSERT INTO cucNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿O⁴ sa⁴hainh⁴ hnei³ i⁴sian³⁴ jnia⁴ naih⁵ ni²tsei⁴³ Neih³ˉ⁴, jian³ hei⁴i³ liah⁴ sian³ naih⁵ ni²tsei³⁴ˉ⁴? Quie¹ la⁴jeg³⁴ jau²³ i⁴hleh³ˉ⁴ i²conh²ˉ³ tionh²ˉ³, a⁵sia³ hleh³ˉ⁴ con⁴juah⁴ co³hei²tsei³ quien⁴ húan⁵, quie¹ Neih³ˉ⁴ a³sian³ naih⁵ ni²tsei³⁴ˉ⁴, hei⁴ pi²³i³ júan³ ta¹ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Hniah³ hainh⁴ hnei³ i⁴sian³⁴ jnia⁴ naih⁵ ni²tsei⁴³ Neih³ˉ⁴, jian³ sian³ hei⁴i³ naih⁵ ni²tsei³⁴ˉ⁴; i² juah⁴ne³ sa⁴hainh⁴ˉ³ la⁴ne³, ua²li⁴hainh⁴ˉ³ con⁴juah⁴ i⁴júan³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, a³hain⁴ a³hain⁴ i²con²³ jnia⁴, la⁴conh⁴ i⁴júan³⁴ jnia⁴, júan³⁴i³ liah⁴, jian³ eu⁴³ pi¹ co³ jnia⁴ i⁴júan³⁴i³, quie¹ ta⁵la⁴ naih²ˉ⁵ i²cua⁴³ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Jian³ la⁴jeg³⁴ i⁴mh²ˉ³ i²con²³ Neih³ˉ⁴ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴, cúa¹ˉ⁴ canh⁴a² li⁴jnia³ i⁴júanh⁴³ Jon⁴dai¹ Jmai³ con⁴juah⁴ A³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Juah⁴ sia³ con³ i⁴mh²ˉ³ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴, cúa¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Juah⁴ne³ hnoh⁴³ˉ³ jnia⁴ tionh²ˉ³, hniah³ ma²teih³²ˉ³ heih⁴³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Jian³ mh²ˉ⁵ Neih³ˉ⁴ i⁴cúan⁵i³ i²jan³ A³júanh² Tsei⁴³ Chie³, canh⁴a² hein²i³ jenh²ˉ³ tionh²ˉ³ la⁴jeg³⁴ jm²: ");
INSERT INTO cucNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","M⁴tyi⁴ hain⁴ a³he²³ jau²³ ni²tei⁴³, a³hain⁴ a³sa⁴li⁴hyein⁴³ chie³ quian¹ m⁵cu³ la³, quie¹ ta⁵la⁴ sa⁴jen³i³ jian³ sa⁴cm²³i³ liah⁴; i² hnei³ tionh²ˉ³ ma³cmh⁴³ˉ³, quie¹ hein²i³ jenh²ˉ³ jian³ li⁴sian³ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","A⁵sian⁴³ hnei³ si⁵hangh⁴³ o³tan² júan¹ˉ⁴; quie¹ nioh²ˉ⁵ ni²nei³⁴ˉ⁴ jenh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jian³ co⁴meih³pa² júah³ jm² sia³ i⁴a⁵sie⁴³ je⁴³ jnia⁴ chie³ quian¹ m⁵cu³ tionh², i² hnei³pa² tionh²ˉ³ jeh³²ˉ³ jnia⁴; jian³ quie¹ i⁴sian³⁴ jnia⁴, li⁴sia³ m⁵cu³ quianh³ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jian³ jm² jon³ li⁴ñih¹ˉ³ i⁴sian³⁴ jnia⁴ naih⁵ ni²tsei⁴³ Neih³ˉ⁴, jian³ i⁴sianh³ hnei³ tionh²ˉ³ naih⁵ ni²tsei³⁴ jnia⁴, jian³ i⁴sian³⁴ jnia⁴ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","A³hain⁴ a³hyei³ heih⁴³ quien⁴ˉ⁴ jian³ ma³tei⁵i³, a³ne³pa² hain⁴ a³hnie³⁴ jnia⁴. Jian³ a³hain⁴ a³hnie³⁴ jnia⁴ lang⁴³ a³hnio³² quian¹ Neih³ˉ⁴, jian³ ma²hno³²i³ jnia⁴ liah⁴, jian³ ma²jnia³² jnia⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","I² jon³ a⁴juah⁴ Judas (a⁵hei⁴³ Iscariote): ―Hnei³ Se³ño²³, ¿e⁴le³⁴ jmah³ i²con²³ jnie³²pa² ma²jniah³²ˉ³? ¿I² e⁴le³⁴ sa⁴i²ma²jniah³²ˉ³ i²con²³ a³m⁵cu³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jon³ a⁴ŋangh³ Jesús, a⁴juah⁴i³: ―A³hain⁴ a³hnie³⁴ jnia⁴, ma³tei⁵i³ jau²³ quien⁴ˉ⁴; jian³ ma⁵hnie³⁴ Neih³ˉ⁴ quieh¹i³ liah⁴, jian³ jie² jnie³² jie³ jnie³² Neih³ˉ⁴ i²con²³ a³hain⁴ i⁴hyie² jnie³² naih⁵ ni²tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","I² a³hain⁴ a³sa⁴hnie³⁴ jnia⁴, sa⁴ma³tei⁵i³ jau²³ quien⁴ˉ⁴. La⁴conh⁴ jau²³ i⁴ma³a⁴naih³ˉ³ tionh²ˉ³, a⁵jon⁴³ jau²³ quien⁴ˉ⁴ húan⁵ˉ⁵, quie¹ i⁴quieh¹ Neih³ pe²³ˉ⁴, a³hain⁴ a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’A⁴jeu³⁴ˉ⁴ hnei³ jau²³ la³ tionh²ˉ³ ta¹la⁴ sainh⁴³ˉ⁴ jenh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","I² M⁴tyi⁴ quieh¹ Jon⁴dai¹, A³júanh² Tsei⁴³ Chie³ hain⁴, a³hain⁴ a³sain³⁴ Neih³ˉ⁴ nei² quien⁴ˉ⁴, hei⁴ pi²³i³ he³⁴ hnei³ la⁴jeg³⁴ jian³ júan³⁴i³ i⁴tyon⁴³ hoh⁴³ˉ³ la⁴jeg³⁴ i⁴ma³a⁴jeu³⁴ˉ⁴ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Tieh²la³ júan¹ˉ⁴ i⁴nie⁴³ tai³² m⁴tyi⁴ quianh³ˉ³ la⁴jon³ liah⁴i² sian³⁴ˉ⁴, la⁴ne³ cúa¹ˉ⁴; a⁵sia³ cúa¹ˉ⁴ i⁴nie⁴³ tai³² la³ liah⁴i² cúa²³ m⁵cu³ liah⁴. A⁵júan³ hnei³ hlion⁴ co³hei²tsei³ juah⁴ i⁴so⁵ñih¹ˉ³ liah⁴ sianh³ˉ³, jian³ a⁵júan³ hnei³ canh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ma³a⁴naih³ˉ³ tionh²ˉ³ i⁴a⁴jeu³⁴ˉ⁴ hnei³, a⁴teg⁴ i²naih²ˉ⁵, jian³ nioh²ˉ⁵ liah⁴ i²conh²ˉ³ tionh²ˉ³. Juah⁴ne³ i⁴chie⁴³ ma⁵hnoh³²ˉ³ jnia⁴, jon³ ma²lei⁴ si³hyonh³ˉ³ i⁴a⁴juah³ˉ⁴ i⁴naih²ˉ⁵ i²con²³ Neih³ˉ⁴; quie¹ eu⁴³a² júanh⁴³ Neih³ˉ⁴ la⁴conh⁴a² jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","I² la⁴ne³ ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ naih⁵i² si⁵lei⁴ i⁴lei⁴, canh⁴a² tei⁴³i² ma³si³lei⁴, jon³ li⁴hainh⁴ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’A⁵sie⁴³ ma⁵hleh¹ˉ⁴ hlion⁴ i²conh²ˉ³ tionh²ˉ³; quie¹ jia²³ a³sa⁴tsein³⁴ a³júan³ heih⁴³ i²con²³ a³tionh² m⁵cu³ la³. Jian³ i¹con³ sa⁴li⁴júan³⁴i³ nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","I² canh⁴a² li⁴laih² a³m⁵cu³ i⁴hno⁵ˉ⁵ Neih³ˉ⁴, la⁴ne³ hniah³ si⁵lei⁴, jian³ la⁴conh⁴ heih⁴³ i⁴a⁴júan⁴i³, ma⁵tei³²ˉ⁴. Ra⁴hang³² hnei³ tionh²ˉ³ i²tieh²ˉ¹ la³, ma³²ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Jnia⁴ lang⁴³ o¹sieh³² ya¹gm³jeh² i⁴chie⁴³, jian³ Neih³ˉ⁴ lang⁴³ a³hie³ hei²³ a²hma³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","La⁴jeg³⁴ o¹cúah² i⁴quian³² jnia⁴ i⁴sa⁴hag³ o¹m⁴, queih³i³; jian³ la⁴jeg³⁴ o¹cúah² i⁴hag³ o¹m⁴, ma³jo²³i³ re³, canh⁴a² la⁴jon³ cúa³⁴ hlion⁴ pi¹ o¹m⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jian³ ma³ti²cangh⁴ˉ³ tionh²ˉ³ con⁴juah⁴ jau²³ i⁴a⁴hlenh⁵ˉ⁵ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ua²tionh²ˉ³ liah⁴ma³tionh²ˉ³ ne³ naih⁵ ni²tsei³⁴ jnia⁴, jian³ i⁴hein³²ˉ⁴ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³. Jian³ sa⁴li⁴hag³⁴ o¹m⁴ o¹cúah² hña³, juah⁴ne³ sa⁴ya¹quian³² la⁴teg⁴ o¹sieh³²; conh⁴liah⁴ la⁴ne³ hnei³ tionh²ˉ³ liah⁴, i¹con³ i⁴tsei³⁴ sa⁴li⁴ma²jniah³²ˉ³, juah⁴ne³ sa⁴tionh²ˉ³ naih⁵ ni²tsei³⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Jnia⁴ lang⁴³ o¹sieh³², hnei³ tionh²ˉ³ langh⁴³ o¹cúah². A³hain⁴ a³hein² naih⁵ ni²tsei³⁴ˉ⁴ jian³ hein³² jnia⁴ naih⁵ ni²tsei⁴³i³, a³la⁴ne³ ta² hlion⁴ i⁴tsei³⁴ ma³jnia³i³; i² juah⁴ne³ sa⁴jianh²ˉ³ jnia⁴ ne⁵, i¹con³ a⁵sia³ i⁴li⁴júanh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","A³hain⁴ a³sa⁴hein² naih⁵ ni²tsei³⁴ jnia⁴ i⁴li⁴úan⁴i³, si⁵hang⁴³i³ ta⁵co⁴³ liah⁴i² ton²³i³ o¹cúah² hma³, jian³ li⁴quin³i³ liah⁴i² li⁴quein³ o¹cúah² hma³ i⁴tya²³i³ co⁴lagh⁴³ i⁴jeng³i³ i⁴co³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’I² juah⁴ne³ liah⁴ma³sianh³ˉ³ ne³ naih⁵ ni²tsei³⁴ˉ⁴ jian³ i⁴quianh²ˉ³ jau²³ quien⁴ˉ⁴ liah⁴ma³quianh²ˉ³ ne³ tionh²ˉ³, m² hnei³ la⁴jeg³⁴ i⁴hnoh³ˉ³, jian³ hyanh⁴ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jian³ ta² lei³ i⁴júanh⁴³ Neih³ˉ⁴ la⁴teg⁴i² ma⁵jniah³²ˉ³ hlion⁴ i⁴tsei³⁴, jian³ la⁴ne³ lei³ i⁴langh⁴³ˉ³ chie³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","La⁴jon³ liah⁴i² hnie³⁴ jnia⁴ Neih³ˉ⁴, la⁴ne³ hno⁵ˉ⁵ hnei³ tionh²ˉ³; ua²tionh²ˉ³ liah⁴ma³tionh²ˉ³ ne³ liah⁴ ra⁴hno⁵ˉ⁵ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Jian³ juah⁴ne³ ma⁵teih³²ˉ³ heih⁴³ quien⁴ˉ⁴, jon³ sa⁴teinh³ hoh⁴³ˉ³ liah⁴ hno⁵ˉ⁵ hnei³ tionh²ˉ³, la⁴jon³ liah⁴i² ma⁵tei³²ˉ⁴ la⁴jeg³⁴ heih⁴³ quieh¹ Neih³ˉ⁴, jian³ sa⁴si³hain⁴ tsei³⁴ˉ⁴ liah⁴ hnie³⁴i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’A⁴jeu³⁴ˉ⁴ hnei³ jau²³ la³ canh⁴a² liah⁴i² si³hyonh³ jnia⁴, lei⁴ si³hyonh³ˉ³ liah⁴, jian³ canh⁴a² ni²hyan³² i⁴si³hyonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jian³ i⁴la³pa² heih⁴³ quien⁴ˉ⁴: i⁴ma²hnoh³²ˉ³ la⁴jan³ jan³ liah⁴i² ra⁴hno⁵ˉ⁵ hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A⁵sion⁴³ i²jan³ ma⁵hnio³⁴ chie³ i⁴chie⁴³ i⁴la⁴la³ i⁴cúa²³i³ m⁵cu³ quieh¹ nei² quieh¹ a³ñi³reunh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hnei³ tionh²ˉ³ langh⁴³ˉ³ a³ñi³reunh³ˉ⁴, juah⁴ne³ ma⁵teih³²ˉ⁴ la⁴conh⁴ heih⁴³ júan³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","A⁵sie⁴³ ma⁵teh²ˉ⁵ hnei³ a³cúa²³ cúa³tag³², quie¹ a³cúa²³ cúa³tag³² a⁵sia³ ñi³i³ la⁴conh⁴ júan³ jeu³²i³. Quie¹ ma³a⁴juah³ˉ⁴ i⁴langh⁴³ˉ³ a³ñi³reunh³ˉ⁴ tionh²ˉ³, quie¹ la⁴jeg³⁴ i⁴a⁴nau³⁴ˉ⁴ i²con²³ Neih³ˉ⁴, ma³ma⁴jnia³²ˉ⁴ i²conh²ˉ³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","A⁵sian⁴³ hnei³ a⁴hnieh² jnia⁴ tionh²ˉ³; jnia⁴pa² a⁴quianh⁵ˉ⁵ hnei³ jian³ ma³a⁴tonh³ˉ⁴ joh⁴³ cúah³ˉ³ i⁴ua²hanh²ˉ³ i⁴ma²jniah³²ˉ³ hlion⁴ i⁴tsei³⁴, jian³ i⁴tsei³⁴ i⁴ma²jniah³²ˉ³ jon³, tieh¹ úa⁴. Jian³ la⁴ne³ la⁴jeg³⁴ i⁴mh²ˉ³ i²con²³ Neih³ˉ⁴ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴, cúa³⁴ Neih³ˉ⁴ i²conh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jian³ júan³⁴ˉ⁴ heih⁴³ la³: i⁴ma²hnoh³²ˉ³ a³jan³ jan³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Juah⁴ne³ hie²³ hnei³ a³m⁵cu³ tionh²ˉ³, ñih¹ˉ³ i⁴jnia⁴pa² ñeih³² ra⁵hie²³i³ la⁴conh⁴a² hnei³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Juah⁴ne³ ma²langh⁴³ˉ³ a³quian¹ m⁵cu³, jon³ ma²ma⁵hnie³⁴i³ hnei³ liah⁴i² hnio³⁴i³ chie³ quian¹. Quie¹ a⁴quianh⁵ˉ⁵ hnei³ jen² a³m⁵cu³, i⁴jon³ hie²³ hnei³ a³m⁵cu³, quie¹ so⁵langh⁴³ˉ³ chie³ quian¹ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Tyon¹ hnei³ hoh⁴³ jau²³ la³ i⁴a⁴jeu³⁴ˉ⁴ hnei³: “I¹jan³ a³cúa²³ cúa³tag³² sa⁴tyein² la⁴conh⁴a² jeu³².” Juah⁴ne³ jnia⁴ ñeih³² a⁴hag⁴i³, leg⁴³ re³pa² hag³⁴i³ hnei³ tionh²ˉ³ liah⁴; juah⁴ne³ ma³tei⁵ chie³ jau²³ quien⁴ˉ⁴, jon³ ma⁴tei⁵i³ jau²³ quianh³ˉ³ tionh²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","I² la⁴jeg³⁴ i⁴ne³ júan³⁴i³ i²conh²ˉ³ nei² quien⁴ˉ⁴, quie¹ sa⁴cm²³i³ a³hain⁴ a³a⁴sai⁴ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Jian³ juah⁴ne³ sa⁴ma³cuan⁵ˉ⁵ m⁵cu³ la³ jian³ juah⁴ sa⁴ma²a⁴hleh³ˉ⁴ i²con²³i³, a⁵sia³ ma²li⁴juah⁴i³ i⁴ren³i³ chie³². I² tieh²la³ ne⁵, a⁵sie⁴³ li⁴juah⁴i³ juah⁴ i⁴sa⁴ren³i³ chie³². ");
INSERT INTO cucNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A³hain⁴ a³hie²³ jnia⁴, hion²³i³ Neih³ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jian³ juah⁴ne³ sa⁴ma²a⁴júan³⁴ˉ⁴ jen²i³ i⁴sa⁴ma³a⁴júan⁴ i¹jan³ chie³, a⁵sia³ chie³² ma²ren³i³; i² tieh²la³ ne⁵, ma³a⁴je³⁴i³ jian³ ra⁵hie²³i³ jnia⁴ jian³ ra⁵hion²³i³ Neih³ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","I² i⁴jon³ si³lei⁴ la⁴ne³ canh⁴a² li⁴tei⁴³ jau²³ i⁴ra³sag² lai²³ quieh¹i³ i⁴ra³juah⁴: “Ra⁵hie²³i³ jnia⁴ i⁴sa⁴sia³ nei².” ");
INSERT INTO cucNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’I² la⁴teg⁴i² jia²³ A³júanh² Tsei⁴³ Chie³ hain⁴, a³hain⁴ a³sain¹ˉ⁴ a³jia²³ con⁴juah⁴ Neih³ˉ⁴, M⁴tyi⁴ a³he²³ jau²³ ni²tei⁴³, hei⁴ pi²³i³ hleh³ nei² quien⁴ˉ⁴, quie¹ jia²³i³ i²con²³ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jian³ hnei³ tionh²ˉ³ liah⁴, hleh²ˉ³ nei² quien⁴ˉ⁴, quie¹ ta⁵la⁴ jianh²ˉ³ jnia⁴ liah⁴ma²ra⁴lie⁵. ");
INSERT INTO cucNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’A⁴jeu³⁴ˉ⁴ hnei³ la⁴jeg³⁴ jau²³ la³ canh⁴a² sa⁴teinh⁴³ hoh⁴³ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Quie¹ húa⁵i³ hnei³ cuah³ judío tionh², quie¹ jia²³ jm² la⁴teg⁴i² lain⁴ chie³ i⁴hnie³⁴i³ jŋangh³i³ hnei³, lain⁴i³ ma⁵con⁴³i³ Jon⁴dai¹ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Júan³i³ la⁴jon³ tionh² quie¹ sa⁴cm²³i³ Neih³ˉ⁴, jian³ a⁵ga⁴ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","I² jeu³⁴ˉ⁴ hnei³ i⁴la³ ñeih³², canh⁴a² la⁴teg⁴i² jia²³ jm² jon³, jon³ tyon⁴³ hoh⁴³ˉ³ la⁴jeg³⁴ la⁴conh⁴ ma³a⁴jeu³⁴ˉ⁴ hnei³. ’Jian³ jau²³ la³ a⁵sia³ a⁴jeu³⁴ˉ⁴ hnei³ liah⁴ma²ra⁴lie⁵, quie¹ ta⁵la⁴ ma²hein³²pa² jnia⁴ jenh²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","I² tieh²la³ naih²ˉ⁵ i²con²³ a³hain⁴ a³a⁴sai⁴ jnia⁴; jian³ i¹jan³ hnei³ tionh²ˉ³ sa⁴li⁴ŋangh²ˉ³: “¿Jainh¹ cúah²ˉ³?” ");
INSERT INTO cucNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","I² quie¹ ma³a⁴juah³ˉ⁴ la⁴jeg³⁴ i⁴ne³, i⁴jon³ ta² chionh⁴ hoh⁴³ˉ³ hlion⁴ mai²³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Quie¹ jeu³⁴ˉ⁴ hnei³ i⁴la³ i⁴chie⁴³pa²: i⁴eu⁴³a² re³ quianh³ˉ³ i⁴naih²ˉ⁵. Quie¹ juah⁴ne³ sa⁴naih²ˉ⁵, a⁵sia³ jia²³ A³júanh² Tsei⁴³ hain⁴ i²conh²ˉ³ tionh²ˉ³; i² juah⁴ne³ naih²ˉ⁵ ne⁵, ma²jon³ sainh³²i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","I² la⁴teg⁴i² ma³cuan²³i³, jon³ júan³⁴i³ i⁴laih² tsei⁴³ a³m⁵cu³ i⁴lang⁴³i³ a³ti²ren³ chie³², jian³ liah⁴ li⁴tsein³⁴i³ ta⁵nei² Jon⁴dai¹, jian³ liah⁴ queih³ Jon⁴dai¹ heih⁴³ i²con²³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Li⁴laih²i³ i⁴ti²ren³i³ chie³² tionh², quie¹ sa⁴hain⁴i³ i²con²³ jnia⁴; ");
INSERT INTO cucNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","jian³ li⁴ñi³i³ liah⁴ li⁴tsein³⁴i³, quie¹ naih²ˉ⁵ i²cua⁴³ Neih³ˉ⁴, jian³ a⁵sie⁴³ ma⁵jeh³²ˉ³ jnia⁴; ");
INSERT INTO cucNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","jian³ li⁴ñi³i³ liah⁴ queih³ Jon⁴dai¹ heih⁴³ i²con²³ chie³, quie¹ ma³a⁴queih³i³ heih⁴³ i²con²³ a³sa⁴tsein³⁴, a³júan³ heih⁴³ i²con²³ a³tionh² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Hlion⁴ pi¹ hno⁵ˉ⁵ jeu¹ˉ⁴ hnei³ tionh²ˉ³, i² tieh²la³ ne⁵, sa⁴tian⁴ li⁴ŋangh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","I² la⁴teg⁴i² ma³cuan²³ M⁴tyi⁴ a³he²³ jau²³ ni²tei⁴³, hei⁴ pi²³i³ he³⁴ hnei³ tionh²ˉ³ la⁴jeg³⁴ jau²³ ni²tei⁴³; jian³ a⁵sia³ hleh³i³ con⁴juah⁴ co³hei²tsei³ quieh¹ hña³, quie¹ hleh³i³ la⁴conh⁴ a⁴nau⁴i³, jian³ júan³⁴i³ i⁴li⁴ñih¹ˉ³ la⁴jeg³⁴ i⁴si⁵lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jian³ júan³⁴ hei⁴i³ i⁴júanh⁴³ jnia⁴, quie¹ hyei³⁴i³ la⁴jeg³⁴ nei² quien⁴ˉ⁴, jian³ júan³⁴i³ i⁴li⁴ñih¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Quie¹ la⁴jeg³⁴ i⁴sia³ quieh¹ Neih³ˉ⁴, i⁴quien⁴ jnia⁴pa²; i⁴jon³pa² a⁴juah³ˉ⁴ i⁴hyei³⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ la⁴jeg³⁴ nei² quien⁴ˉ⁴, jian³ júan³⁴i³ i⁴li⁴ñih¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jian³ co⁴meih³pa² júah³ jm² sia³ i⁴a⁵sie⁴³ jeh³²ˉ³ jnia⁴, jian³ sa⁴úa⁴pa² coh⁵ ne³, jeh³²ˉ³ jnia⁴ liah⁴ i⁴seg³⁴, quie¹ naih²ˉ⁵ i²cua⁴³ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","I² la⁴jon³ a⁴júanh⁴ co⁴meih³ chie³ quian¹i³ tionh², a⁴sagh⁴³i³ a³jan³ jan³: ―¿Henh⁴ ra³juah⁴ i⁴ne³ i⁴a⁴sag⁴³i³ jnia¹ i⁴juah⁴i³: “Co⁴meih³pa² júah³ jm² sia³ i⁴a⁵sie⁴³ jeh³²ˉ³ jnia⁴, jian³ sa⁴úa⁴pa² coh⁵ ne³, jeh³²ˉ³ jnia⁴ liah⁴ i⁴seg³⁴, quie¹ naih²ˉ⁵ i²cua⁴³ Neih³ˉ⁴”? ");
INSERT INTO cucNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","I² i⁴jon³ a⁴júanh⁴i³: ―¿Henh⁴ hnie³⁴ ra³juah⁴ jau²³ jon³, “co⁴meih³pa² júah³ jm²”? Quie¹ sa⁴ŋang⁴ jnia¹ henh⁴ si²hleh²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jon³ ra⁵laih² Jesús i⁴ma²hnie³⁴ chie³ quian¹i³ ŋang³⁴ i²con²³i³, jon³ a⁴sagh⁴³i³: ―¿O⁴ ti²júanh⁴ˉ³ tionh²ˉ³ húanh⁴ˉ³ nei² quieh¹ jau²³ i⁴a⁴juah³ˉ⁴: “Co⁴meih³pa² júah³ jm² sia³ i⁴a⁵sie⁴³ jeh³²ˉ³ jnia⁴, jian³ sa⁴úa⁴pa² coh⁵ ne³, jeh³²ˉ³ jnia⁴ liah⁴ i⁴seg³⁴”? ");
INSERT INTO cucNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, i⁴hoh³²ˉ³ jian³ li⁴chionh⁴ hoh⁴³ˉ³, i² a³m⁵cu³ ne⁵, lei⁴ si³hyonh³i³ tionh²; jian³ ua²liah⁴a² li⁴chionh⁴ hoh⁴³ˉ³ tionh²ˉ³, i⁴chionh⁴ hoh⁴³ˉ³ jon³, lei⁴ si³hyonh³ˉ³ hlion⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Quie¹ liah⁴i² lang⁴³ jan³ a³m⁴ tei⁴³i² cuan⁴ a³jon⁴³i³, si³hei⁴ queuh³ tsei⁴³i³, quie¹ ma³a⁴teg⁴ o²ra³ quieh¹i³; i² tei⁴³i² ma³cuan²³ yein³ ne⁵, a⁵sie⁴³ ma⁵tyon²³ tsei⁴³i³ ma²eu⁴³ i⁴a⁴can³⁴i³, nei² quieh¹ i⁴eu⁴³ si³hyonh³i³ i⁴ra⁵sian³ yein³ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jian³ la⁴ne³pa² hnei³ tionh²ˉ³ liah⁴, li⁴chionh⁴ hoh⁴³ˉ³ tieh²la³; i² nia²jen³² pe²³ˉ⁴ hnei³ liah⁴ i⁴seg³⁴, i² ma²jon³ lei⁴ si³hyonh³ˉ³ tionh²ˉ³ hlion⁴ mai²³, con³ i⁴si³hyonh³ˉ³, i¹jan³ sa⁴li⁴qui³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Jian³ jm² jon³ a⁵sie⁴³ ma⁵hniah³ ŋangh³²ˉ³ jnia⁴ i¹con³. Quie¹ i⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, la⁴jeg³⁴ i⁴mh²ˉ³ i²con²³ Neih³ˉ⁴ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴, cúa³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jian³ la⁴teg⁴ tieh²la³, i¹con³ a⁵sia³ i⁴ma³a⁴mh²ˉ³ tionh²ˉ³ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴; m² hnei³ jian³ hyanh⁴ˉ³, canh⁴a² hyan⁵ i⁴si³hyonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ma³a⁴jeu³⁴ˉ⁴ hnei³ la⁴jeg³⁴ i⁴la³ con⁴juah⁴ jau²³ sa⁴lei³; i² jia²³ jm² i⁴so⁵hlenh²ˉ⁵ hnei³ tionh²ˉ³ con⁴juah⁴ jau²³ sa⁴lei³, quie¹ hleh¹ˉ⁴ ra³jia⁵ o³tan² nei² quieh¹ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jian³ jm² jon³ mh³²i³ hnei³ con⁴juah⁴ jm³i⁴sain³⁴ˉ⁴; jian³ a⁵sia³ juah³ˉ⁴ juah⁴ jnia⁴pa² mh²ˉ⁵ Neih³ˉ⁴ nei² quianh³ˉ³, ");
INSERT INTO cucNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","quie¹ hña³pa² Neih³ˉ⁴ ma³hnie³⁴ hnei³, quie¹ ra⁵hnoh⁴³ˉ³ jnia⁴ tionh²ˉ³, jian³ ra⁵hainh⁴ˉ³ i⁴a⁴nia³⁴ˉ⁴ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A⁴nia³⁴ˉ⁴ i²con²³ Neih³ˉ⁴ i⁴cuan⁵ˉ⁵ m⁵cu³ la³, jian³ la⁴ne³ liah⁴ hniah³ jau¹ˉ⁴ m⁵cu³ la³, i⁴naih²ˉ⁵ i²con²³ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","I² jon³ a⁴juah⁴ chie³ quian¹i³ tionh²: ―Ne⁵a² si²hleh³ˉ³ ra³jia⁵ o³tan², a⁵sie⁴³ ma⁵hleh³ˉ³ con⁴juah⁴ jau²³ sa⁴lei³. ");
INSERT INTO cucNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jian³ nia² jnie³² tieh²la³ i⁴ñih¹ˉ³ la⁴jeg³⁴, jian³ a⁵sie⁴³ ma⁵hniah³ juah⁴ i⁴ŋang³⁴ chie³ i²conh²ˉ³ i¹jan³. I⁴jon³ hain⁴ jnie³² i⁴a⁴niah³ˉ³ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","I² jon³ a⁴ŋangh³ Jesús: ―¿O⁴ ne⁵pi¹ ra⁵hainh⁴ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Quie¹ ma³ja²³ jm², ma³a⁴tyie³⁴ tieh²la³pa² la⁴teg⁴i² so⁵jenh³ hnei³ ma⁵quein²³ la⁴jan³ jan³ hnei³ tionh²ˉ³ cm³⁴, jian³ tonh³²ˉ³ jnia⁴ húan⁵ˉ⁵. I² a⁵sia³ quionh⁴ˉ⁴ húan⁵ˉ⁵, quie¹ jian²³pa² jnia⁴ Neih³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","La⁴jeg³⁴ i⁴ne³ a⁴hlenh⁵ˉ⁵ hnei³ tionh²ˉ³ canh⁴a² sianh³ˉ³ hyon³ hoh⁴³ˉ³ con⁴juah⁴ jnia⁴. Jian³ m⁵cu³ la³ hniah³ canh²ˉ³ ma²eu⁴³; jian³ re³ tya² hnei³ hoh⁴³, quie¹ jnia⁴ ma³a⁴cagh³²ˉ⁴ jm² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Con³ma²a⁴hleh⁴ Jesús jau²³ jon³, jon³ a⁴je³⁴i³ ta⁵ñi⁴jeu⁵, a⁴juah⁴i³: ―Hnei³ Neih³ˉ⁴, ma³a⁴tyie³⁴ jm² tieh²la³. Ma⁴jnia³² hnei³ i⁴júanh⁴³ A³jonh³ˉ³, jian³ canh⁴a² la⁴ne³ ma⁵jnia³ A³jonh³ˉ³ i⁴júanh⁴³ hnei³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Quie¹ ma³a⁴cúah²ˉ³ i²con²³ A³jonh³ˉ³ i⁴júan³⁴i³ heih⁴³ i²con²³ la⁴jang³⁴, canh⁴a² cúa³⁴i³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ i²con²³ la⁴jang³⁴ a³a⁴cúanh³²ˉ³ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","I² i⁴la³pa² m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ i⁴li⁴cu²³ hnei³ chie³, i⁴jan³ hnei³pa² Jon⁴dai¹ sian³ i⁴chie⁴³, jian³ i⁴li⁴cm²³i³ Jesucristo, a³hain⁴ a³a⁴sainh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ma³a⁴júan³⁴ jnia⁴ i⁴júanh⁴³ˉ³ nei² cuah³²húa³⁴ la³, jian³ ma³ma⁴tieh²ˉ⁵ ta¹ i⁴ma²a⁴cúah³²ˉ³ jnia⁴ júan¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","I² tieh²la³ ne⁵, hnei³ Neih³ˉ⁴, ma⁴jnia³² hnei³ i⁴júanh⁴³ jnia⁴ la⁴teg⁴ hlonh²ˉ³, liah⁴i² ma²júanh⁴³ˉ⁴ hlonh²ˉ³ naih⁵i² lei⁴ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Jian³ ma³a⁴he³⁴ˉ⁴ hain³liah⁴ langh⁴³ˉ³ i²con²³ la⁴jang³⁴ a³a⁴cúanh³²ˉ³ jnia⁴, a³ma²lang⁴³ chie³ quian¹ m⁵cu³. Ma²lang⁴³i³ chie³ quianh³ˉ³, jian³ a⁴cúanh³²i³ hnei³ tionh² i²con²³ˉ⁵, jian³ ma³ma⁴tei⁵i³ jau²³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jian³ ma³ra⁵ñi³i³ i⁴la⁴jeg³⁴ i⁴a⁴cúah² hnei³ i²con²³ jnia⁴, ja³⁴ i²conh² hnei³pa²; ");
INSERT INTO cucNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","quie¹ la⁴jeg³⁴ i⁴a⁴cúah²ˉ³ i²con²³ jnia⁴, ma³a⁴cúah⁵i³ jnia⁴ tionh², jian³ ma³a⁴hyei⁴i³ liah⁴. Jian³ ma³ra⁵laih²i³ i⁴chie⁴³ i⁴a⁴nia³⁴ˉ⁴ i²conh² hnei³, jian³ ma³ra⁵hain⁴i³ tionh² i⁴hnei³pa² a⁴saih⁴ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’I² i⁴jon³ mh⁵ˉ⁵ hnei³ nei² quieh¹i³ tionh²; a⁵sia³ mh⁵ˉ⁵ hnei³ nei² quieh¹ a³m⁵cu³, quie¹ nei² quieh¹ a³a⁴cúanh³²ˉ³ i²con²³ˉ⁵ pe²³ˉ⁴; quie¹ ta⁵la⁴ lang⁴³i³ chie³ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Jian³ la⁴jang³⁴ a³quian³⁴ jnia⁴, quianh³ hnei³pa², jian³ la⁴jang³⁴ a³quianh³ hnei³, quian³⁴ jnia⁴ liah⁴; jian³ lei³ jnia⁴ i⁴júanh⁴³ jnia⁴ con⁴juah⁴ hei⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’I² jnia⁴ ne⁵, a⁵sie⁴³ ma⁵jian¹ˉ⁴ m⁵cu³ la³; hei⁴ pi²³i³ tionh² jian³⁴i³ m⁵cu³ la³, i² jnia⁴ naih²ˉ⁵ i²ñih⁴ˉ³. Hnei³ Neih³ˉ⁴ a³hen², hion³² hnei³ con⁴juah⁴ ua³pei⁴ quianh³ˉ³ la⁴conh⁴ a³a⁴cúanh³²ˉ³ i²con²³ˉ⁵, canh⁴a² tionh²i³ i⁴lang⁴³i³ jan³ chie³ la⁴jon³ liah⁴i² tieh² jnia¹. ");
INSERT INTO cucNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jian³ ta¹la⁴ ŋeng³⁴ˉ⁴ jian²³i³ jnia⁴ tionh² m⁵cu³ la³, a⁴hion⁵i³ jnia⁴ con⁴juah⁴ ua³pei⁴ quianh³ˉ³; jian³ la⁴conh⁴ a³a⁴cúanh³²ˉ³ ne³, a⁴hion⁵ˉ⁵. Jian³ i¹jan³ sa⁴ua⁵hain⁴, jan³ a³hain⁴pa² a³ma³ra³gmh⁴ heih⁴³ si⁵hain⁴ hain⁴, canh⁴a² li⁴tei⁴³ i⁴ra³sag² Ma²jyi³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’I² tieh²la³ ne⁵, naih²ˉ⁵ i²conh² hnei³; jian³ ta¹la⁴ hein³²ˉ⁴ m⁵cu³ la³ hleh³ˉ⁴ jau²³ la³, canh⁴a² lei⁴ si³hyonh³i³ ni²hyan³² tionh² liah⁴i² si³hyonh³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jian³ ma³a⁴cúah⁵i³ jnia⁴ jau²³ quianh³ˉ³, jian³ a³m⁵cu³ tionh² hie²³ quieh¹i³, quie¹ a⁵sie⁴³ lang⁴³i³ quian¹ m⁵cu³ la⁴jon³ liah⁴i² sa⁴lang⁴³ jnia⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A⁵sia³ mh⁵ˉ⁵ hnei³ juah⁴ne³ i⁴húanh³²i³ hnei³ m⁵cu³ la³, i⁴jon³pa² m³⁴ˉ⁴ i⁴hionh³²i³ hnei³ nei² quieh¹ i⁴hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A⁵sie⁴³ ma⁵lang⁴³i³ a³quian¹ m⁵cu³ la⁴jon³ liah⁴i² sa⁴lang⁴³ jnia⁴ a³quian¹ m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ma⁴cúanh¹i³ hnei³ tionh² con⁴juah⁴ ni²tei⁴³, jian³ jau²³ quianh³ˉ³ i⁴ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jian³ la⁴jon³ liah⁴i² a⁴saih⁴ˉ³ jnia⁴ m⁵cu³ la³, la⁴ne³ sain¹i³ jnia⁴ jen² a³m⁵cu³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jian³ nei² quieh¹ hei⁴i³ tionh², cúanh³² jnia⁴ i²conh² hnei³, canh⁴a² la⁴jon³ li⁴cúanh¹i³ con⁴juah⁴ jau²³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Jian³ a⁵sia³ mh⁵ˉ⁵ hnei³ jmah³ nei² quieh¹ a³ne³ tionh², quie¹ m³⁴ˉ⁴ liah⁴ nei² quieh¹ a³li⁴hain⁴ i²con²³ jnia⁴ ta⁵cang³ con⁴juah⁴ jau²³ i⁴hleh³ a³ne³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","jian³ canh⁴a² tionh²i³ i⁴lang⁴³i³ jan³ chie³ la⁴jang³⁴i³, la⁴jon³ liah⁴i² lang⁴³ jnia¹ jan³ chie³, hnei³ Neih³ˉ⁴, i⁴heinh²ˉ³ naih⁵ ni²tsei³⁴ˉ⁴ jian³ i⁴hein³²ˉ⁴ naih⁵ ni²hoh⁴³ˉ³ liah⁴, jian³ ua²lain⁴i³ tionh² jan³ chie³ i⁴tionh²i³ naih⁵ ni²tsei⁴³ˉ¹, canh⁴a² li⁴hain⁴ a³m⁵cu³ tionh², hnei³pa² a⁴saih⁴ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jian³ a⁴cúa³⁴ˉ⁴ i⁴júanh⁴³i³ tionh² liah⁴i² a⁴cúah²ˉ³ i⁴júanh⁴³ jnia⁴, canh⁴a² lain⁴i³ jan³ chie³ liah⁴i² lang⁴³ jnia¹ jan³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I⁴hein³² jnia⁴ naih⁵ ni²tsei⁴³i³ tionh², jian³ heinh² hnei³ naih⁵ ni²tsei³⁴ˉ⁴, canh⁴a² lain⁴i³ o³tan² jan³ chie³, jian³ la⁴ne³ li⁴ñi³ a³m⁵cu³ i⁴a⁴saih⁴ˉ³ jnia⁴, jian³ hnoh⁴³i³ hnei³ tionh² liah⁴i² ra⁵hnoh⁴³ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Hnei³ Neih³ˉ⁴, la⁴conh⁴ a³hain⁴ a³a⁴cúanh³²ˉ³ i²con²³ jnia⁴, hno⁵ˉ⁵ si⁵cua³i³ i²jon³ jian²³i³ jnia⁴ i²ni¹nei³⁴ˉ⁴, canh⁴a² li⁴je³⁴i³ conh⁴ tei⁴³ i⁴júanh⁴³ˉ⁴ i⁴a⁴cúah²ˉ³; quie¹ ma⁵hnoh³²ˉ³ jnia⁴ liah⁴ma²ra⁴lie⁵ naih⁵i² lei⁴ m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Hnei³ Neih³ˉ⁴ a³hen², sa⁴ra⁵cu²³ hnei³ a³m⁵cu³, i² jnia⁴pa² cm⁴³ hnei³, jian³ a³ne³pa² tionh² ra⁵ñi³ i⁴a⁴saih⁴ˉ³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jian³ ma³ma⁴jnia³²ˉ⁴ hain³ hnei³, jian³ ma²jnia³² pi¹ jnia⁴, canh⁴a² liah⁴i² hnoh⁴³ˉ³ jnia⁴, li⁴hnio³⁴i³ jon²reunh¹ tionh², jian³ canh⁴a² jian³i³ jnia⁴ naih⁵ ni²tsei⁴³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Con³ma²a⁴hleh⁴ Jesús jau²³ jon³, jon³ ua⁵han²i³ jian²³i³ chie³ quian¹ ta⁵hŋoh³ jm³cua³ Cedrón. I²jon³ i²ma²leg⁴³ con³ je¹ a²hma³ i²a⁴han⁵ Jesús jian²³ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jian³ Judas, a³cúah⁴³ quieh¹i³ hain⁴, ñi³i³ i²jon³, quie¹ hlion⁴ nie⁴³ ma³ñei² Jesús i²jon³ jian²³ chie³ quian¹ i⁴ŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","I² Judas ne⁵, a⁴tyie³⁴i³ jian³i³ co⁴hna³ a²hlie⁴ jian³ po³li³sei¹ quian¹ cuah³júah², a³sain² quian¹ m³chie³ tyein² jian³ chie³ fariseo tionh², a⁴tyie³⁴i³ i²jon³, ti²quian³i³ a²ñi²³ jian³ o¹jyi³ jm³co²³ jian³ a²hma³ tyi¹ jyi³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","I² Jesús ne⁵, ma³ñi³ pi²³i³ la⁴jeg³⁴ la⁴conh⁴ si⁵lei⁴ i²con²³i³, jon³ ŋo³⁴i³ ta⁵hloh³², a⁴juah⁴i³: ―¿Hain³ hnah⁵ˉ³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","I² jon³ a⁴ŋangh³ a³hain⁴ tionh²: ―Jesús a³sian³ jeu³ Nazaret pa² hniah⁵ jnie³². I² jon³ a⁴juah⁴ Jesús: ―Jnia⁴pa² a³hain⁴. Jian³ jen² a³hain⁴ tionh² si²sainh⁴³ Judas a³cúah⁴³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","I² con³ma²a⁴juah⁴ Jesús: “Jnia⁴pa² a³hain⁴”, jon³ ŋah³ a³hain⁴ tionh² ta⁴coh⁵cah³², a⁴cangh³i³ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","I² jon³ a⁴ŋang⁴ Jesús liah⁴ i⁴seg³⁴: ―¿Hain³ hnah⁵ˉ³ tionh²ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―Jesús a³sian³ jeu³ Nazaret pa² hniah⁵ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","I² jon³ a⁴ŋangh³ Jesús: ―Ma³a⁴jeu³⁴ˉ⁴ hnei³ tionh²ˉ³ i⁴jnia⁴pa² a³hain⁴. Juah⁴ne³ hnoh⁵ˉ³ jnia⁴, cúa² hnei³ jeu³ i⁴chianh³ a³ne³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","A⁴leg³⁴ la⁴ne³ canh⁴a² li⁴tei⁴³ jau²³ i⁴ma³a⁴hleh⁴ Jesús i⁴juah⁴i³: “Hnei³ Neih³ˉ⁴, la⁴conh⁴ a³a⁴cúanh³²ˉ³ ne³ i²con²³ˉ⁵, i¹jan³ sa⁴ua⁵hain⁴.” ");
INSERT INTO cucNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","I² Si²úan¹ Pe³² ne⁵, ma²quian³i³ con³ a²ñi²tag⁴, jon³ a⁴tyi³i³, a⁴júanh¹i³ jan³ a³sain³ Malco, a³cúa²³ cúa³tag³² i²con²³ jeu³² m³chie³ tyein², a⁴queih³i³ ta³ra³cua¹i³ jo³² ta⁵chie³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","I² jon³ a⁴juah⁴ Jesús, a⁴sagh⁴³i³ Pe³²: ―Tienh³ hnei³ a²ñi²tag⁴ quianh³ a²lo³. ¿O⁴ a⁵sia³ lainh⁴ˉ³ i⁴hniah³ can¹ˉ⁴ ma²eu⁴³ pain⁴ liah⁴ heih⁴³ a⁴tonh³ Neih³ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","I² jon³ ne⁵, co⁴hna³ a²hlie⁴ hain⁴ liah⁴ma³jian²³ jeu³², jian³ po³li³sei¹ quian¹ judío a³hie³ cuah³júah², a⁴sanh³i³ Jesús, a⁴hñi³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","I² jon³ ni²jan³i³ ñeih³² co⁴ra⁴lie⁵ ta⁵nei² Anás, quie¹ a³hain⁴ lang⁴³ a³don⁵ a⁵jmai³ Caifás, a³hain⁴ a³lang⁴³ jeu³² m³chie³ tyein² ñi³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I² Caifás hain⁴ a⁴cúa⁴i³ co³hei²tsei³ i²con²³ judío tionh² liah⁴ma²jia⁴³ i⁴juah⁴i³ i⁴eu⁴³ re³ i⁴jaun⁴ jan³ chie³ nei² quieh¹ la⁴jang³⁴ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","I² jon³ ua⁵han² Si²úan¹ Pe³² coh⁵cah³² Jesús jian²³ i²jan³ chie³ quian¹ Jesús. I² a³i²jan³ hain⁴ ne⁵, cu²³ jeu³² m³chie³ quieh¹i³, i² jon³ a⁴han⁵i³ jian²³ Jesús je¹sieh³² coh⁵hnei³² jauh³² quieh¹ jeu³² m³chie³ tyein². ");
INSERT INTO cucNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","I² Pe³² ne⁵, a⁴jian⁴i³ o²hnei³² jneng²³. I² jon³ ua⁵hag⁴³ chie³ quian¹ Jesús hain⁴ a³cm²³ jeu³² m³chie³, ni²hlenh³²i³ a³m⁴ a³hie³ o²hnei³² i⁴ni²saih¹i³ i⁴si⁵hei⁴ Pe³². ");
INSERT INTO cucNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","I² jon³ a⁴juah⁴ a³m⁴ a³hie³ o²hnei³² hain⁴, a⁴sagh⁴³i³ Pe³²: ―¿O⁴ a⁵hei⁴³ hnei³ langh⁴³ jan³ chie³ quian¹ a³ñih³ jno³, liah²? I² jon³ a⁴juah⁴ Pe³²: ―A⁵sia³ lang⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jian³ ta² cuh⁴ ma²jon³, i⁴jon³ a⁴tya⁴ a³cúa²³ cúa³tag³² hain⁴ tionh² o¹jyi³ jian²³ po³li³sei¹, i² jon³ ti²ma³húan⁴i³ tionh² hloh³² jyi³ jon³. Jian³ Pe³² liah⁴ si²sainh⁴³i³ jen² a³hain⁴ si²ma³húan⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","I² jon³ a⁴ŋang⁴ jeu³² m³chie³ i²con²³ Jesús nei² quieh¹ chie³ quian¹i³ jian³ nei² quieh¹ jau²³ i⁴he²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jon³ a⁴ŋangh³ Jesús: ―Ma³a⁴hleh³ˉ⁴ ni¹jia⁵ ta⁵nei² la⁴jang³⁴; quie¹ la⁴jeg³⁴ nie⁴³ a⁴he³⁴ˉ⁴ cuah³júah² jian³ la⁴jeg³⁴ cuah³ peih¹ liah⁴ i²ŋangh³ la⁴jang³⁴ judío; i¹conh⁴ sa⁴a⁴hleh³ˉ⁴ ta⁵ni²hma². ");
INSERT INTO cucNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿I² e⁴le³⁴ ŋangh⁵ˉ³ jnia⁴ ne⁵? Ŋangh³² hnei³ la⁴jang³⁴ a³a⁴nau⁴ tionh² henh⁴ jau²³ i⁴a⁴hleh³ˉ⁴. I² hei⁴i³ tionh² ñi³ re³ henh⁴ jon³ i⁴a⁴hleh³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","I² con³ma²a⁴hleh⁴ Jesús jau²³ jon³, con³ a⁴la³ a⁴quein⁴ jan³ po³li³sei¹ quian¹ cuah³júah² ma³nei²i³, a³ma²si²sainh⁴³ i²jon³, juah⁴i³: ―¿O⁴ la⁴la³ jainh²ˉ³ jau²³ i²con²³ jeu³² m³chie³? ");
INSERT INTO cucNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","I² jon³ a⁴ŋangh³ Jesús: ―Juah⁴ne³ a⁴hleh³ˉ⁴ jau²hlagh³², juah¹ hnei³ henh⁴ jon³; i² juah⁴ne³ a⁴hleh³ˉ⁴ jau²³ tsei²³ ne⁵, ¿e⁴le³⁴ nei³⁴ˉ⁴ a⁴queinh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","I² jon³ a⁴sai⁴ Anás ya¹hñi⁴³i³ i²con²³ Caifás a³lang⁴³ jeu³² m³chie³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","I² jon³ ne⁵, ta¹la⁴ si²ma³húan⁴ Pe³² hloh³² jyi³ jon³, i² jon³ a⁴sagh⁴³i³ tionh²: ―¿O⁴ a⁵hei⁴³ hnei³ langh⁴³ jan³ chie³ quian¹i³, liah²? I² hei⁴i³ ne⁵, a⁴jlian³⁴i³, a⁴juah⁴i³: ―A⁵sia³ lang⁴³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Conh⁴liah⁴ a⁴ŋang⁴ i²jan³ a³cúa²³ cúa³tag³² i²con²³ jeu³² m³chie³, a³hain⁴ a³tei⁴³ jau²³ quian¹ a³a⁴queih³ Pe³² ta³ra³cua¹ hain⁴, a⁴juah⁴i³: ―¿Sa¹ chie⁴³ a⁴jen³²ˉ⁴ hnei³ je¹ a²hma³ jon³ jianh²ˉ³ a³jno³, liah²? ");
INSERT INTO cucNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jon³ a⁴jlian³⁴ Pe³² liah⁴ i⁴seg³⁴, i² liah⁴ma²jon³ a⁴hoh⁵ jan³ a¹hyie²³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jon³ a⁴tyein³i³ Jesús jauh³² quieh¹ Caifás, ua⁵jan³i³ jauh³²tyie³ quieh¹ si²mah⁴ tyein², ma³hei¹ ta⁵jnia³; i² hei⁴i³ tionh², a⁵sia³ a⁴han⁵i³ jauh³²tyie³ canh⁴a² sa⁴lei⁴ heinh⁵i³, quie¹ canh⁴a² la⁴ne³ li⁴queuh⁴³i³ ma³⁴ quieh¹ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","I² jon³ ua⁵hag⁴³ si²mah⁴ tyein² Pilato ua⁵hlenh³²i³ a³hain⁴ tionh², a⁴sagh⁴³i³: ―¿Hain³ chie³² hnangh⁵ hnei³ a³ñih³ la³ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","I² jon³ a⁴ŋangh³i³ tionh², a⁴juah⁴i³: ―Juah⁴ne³ sa⁴ma²lang⁴³ a³ne³ jan³ a³ren³ chie³², a⁵sia³ ma²cúanh³²i³ jnie³² i²conh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","I² jon³ a⁴juah⁴ Pilato: ―Te⁴³i³ hnei³ tionh²ˉ³, ua⁴quian³ hnei³ jau²chie⁴³ i²con²³i³ con⁴juah⁴ lai²³ quianh³ˉ³. I² jon³ a⁴juah⁴ judío tionh²: ―Sa⁴ra³cúa²³ i²con²³ jnie³² i⁴jŋangh¹ jnie³² chie³ i¹jan³, quie¹ lang⁴³ jnie³² chie³ judío. ");
INSERT INTO cucNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","I² la⁴ne³ li⁴tei⁴³ jau²³ i⁴a⁴hleh⁴ Jesús liah⁴ma²jia⁴³ i⁴a⁴he⁴i³ hain³liah⁴ hniah³ jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","I² jon³ a⁴hei³⁴ Pilato liah⁴ i⁴seg³⁴ jauh³²tyie³, jian³ a⁴teh³i³ Jesús, a⁴sagh⁴³i³: ―¿O⁴ hnei³ langh⁴³ Re¹ quian¹ judío tionh²? ");
INSERT INTO cucNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","I² jon³ a⁴ŋangh³ Jesús: ―¿O⁴ a⁴juah¹ˉ³ i⁴ne³ con⁴juah⁴ co³hei²tsei³ quianh³ˉ³ húanh⁴³ˉ³, jian³ o⁴ quie¹ i⁴a⁴sag⁴³ hnei³ a³sang²³ nei² quien⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","I² jon³ a⁴ŋangh³ Pilato: ―¿O⁴ lainh⁴ˉ³ lang⁴³ jnia⁴ judío, heh⁵ˉ³? A³coh³²ˉ³ jian³ m³chie³ tyein² a⁴cúah³i³ hnei³ joh⁴³ cúa³⁴ jnia⁴. ¿I² henh⁴ a⁴júanh²ˉ³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","I² jon³ a⁴ŋangh³ Jesús: ―A⁵sia³ lang⁴³ˉ⁴ re¹ nei² m⁵cu³ la³. I² juah⁴ne³ ma²lang⁴³ˉ⁴, jon³ ma²jainh³ chie³ quian³⁴ˉ⁴ jm² tionh² i⁴sa⁴ma²cúah⁴³i³ jnia⁴ i²con²³ chie³ judío. I⁴jon³ a⁵sia³ lang⁴³ˉ⁴ re¹ cuah³²húa³⁴ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","I² jon³ a⁴juah⁴ Pilato liah⁴: ―¿O⁴ langh⁴³ˉ³ re¹, heh⁵ˉ³? I² jon³ a⁴ŋangh³ Jesús: ―Hnei³pa² juah⁴ˉ³ i⁴lang⁴³ˉ⁴ re¹. Nei² ne³pa² i⁴cuan⁵ˉ⁵, ra⁵sian³⁴ˉ⁴ m⁵cu³ la³, i⁴jon³ i⁴ni³hleh³ˉ⁴ jau²³ ni²tei⁴³. La⁴jang³⁴ a³júan³ con⁴juah⁴ jau²³ ni²tei⁴³ nau³i³ jau²³ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","I² jon³ a⁴juah⁴ Pilato: ―¿Henh⁴ jon³ i⁴ni²tei⁴³? I² con³ma²a⁴hleh⁴i³ jau²³ jon³, jon³ ua⁵hag⁴³i³ liah⁴ i⁴seg³⁴ ua⁵hlenh³²i³ judío, a⁴sagh⁴³i³: ―I¹con³ chie³² sa⁴tyieh³²ˉ⁴ quieh¹ a³ñih³ la³. ");
INSERT INTO cucNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","I² hnei³ tionh²ˉ³ tangh²ˉ³ i⁴lion³²ˉ⁴ jan³ a³chion³² jm² la³, jm² i⁴a⁴lon⁴ naih⁴³sieh³ˉ³ húa³⁴ Egipto. ¿O⁴ hnoh³ˉ³ lion³²ˉ⁴ Re¹ quian¹ judío tionh²? ");
INSERT INTO cucNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","I² jon³ a⁴hleh⁴ la⁴jang³⁴ i⁴tia⁴ i⁴seg³⁴, a⁴juah⁴i³: ―¡A⁵sia³ lionh³²ˉ³ a³ñih³ ne³! ¡Lion³² hnei³ Barrabás pa²! I² Barrabás hain⁴ lang⁴³ a³hang³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","I² jon³ jian³ Pilato Jesús, jian³ a⁴júan⁴i³ heih⁴³ i⁴pan³⁴i³ jeu³ a²lo³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Conh⁴liah⁴ a⁴júan⁴ a²hlie⁴ con³ a²sag³ i⁴leg⁴³ a²ton⁴³, a⁴tonh³i³ ma³tyi² Jesús, jian³ a⁴tanh³i³ con³ a²hmh³ sein³² cúa³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jon³ a⁴sagh⁴³i³ Jesús tionh²: ―¡Ta⁵yeih³² Re¹ quian¹ judío tionh²! Jon³ a⁴quein⁴i³ nei² Jesús liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","I² jon³ ua⁵hag⁴³ Pilato liah⁴ i⁴seg³⁴, a⁴juah⁴i³: ―Jeh³², tyein²³ˉ⁵ a³ñih³ ne³ ta⁵mah²ˉ³ tionh²ˉ³ canh⁴a² li⁴ñih¹ˉ³ i⁴sa⁴tyieh³²ˉ⁴ i¹con³ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jon³ ua⁵hag⁴³ Jesús ya¹hei¹ a²sag³ i⁴leg⁴³ a²ton⁴³ ma³tyi²i³, jian³ i⁴hein²i³ a²hmh³ sein³² liah⁴. I² jon³ a⁴juah⁴ Pilato i²con²³ a³jeu³: ―¡Jeh³² i²la³ si²sainh⁴³ a³ñih³ hain⁴! ");
INSERT INTO cucNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","I² con³ma²a⁴je³ la⁴jang³⁴ m³chie³ tyein² hain⁴ quieh¹i³, jian²³ po³li³sei¹ quian¹ cuah³júah², jon³ a⁴hleh⁴i³ tia⁴ tionh², a⁴juah⁴i³: ―¡Tion⁴³ hnei³ a³ne³ crau¹! ¡Tion⁴³ hnei³ a³ne³ crau¹! I² jon³ a⁴juah⁴ Pilato i²con²³i³ tionh²: ―Jian⁴³i³ hnei³ húanh⁴ˉ³ tionh²ˉ³, yi⁴tionh⁴³ˉ³ crau¹, quie¹ i¹con³ chie³² sa⁴tyieh³²ˉ⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","I² jon³ a⁴ŋangh³ judío tionh²: ―Sia³ con³ lai²³ quian⁴ jnie³², i² con⁴juah⁴ lai²³ jon³ hniah³ jaun⁴i³, quie¹ júan³i³ lang⁴³i³ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","I² con³ma²a⁴nau⁴ Pilato jau²³ i⁴a⁴juah⁴i³ jon³, tsei³⁴sa² ra⁵coh⁴³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jon³ a⁴hei³⁴i³ jauh³²tyie³ liah⁴ i⁴seg³⁴, jon³ a⁴sagh⁴³i³ Jesús: ―¿Jainh¹ sianh³ hnei³ ne⁵? I² Jesús ne⁵, i¹con³ sa⁴a⁴ŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","I² jon³ a⁴juah⁴ Pilato: ―¿E⁴le³⁴ jau²³ sa⁴jainh⁴ˉ³ i²con²³ jnia⁴? ¿O⁴ sa⁴ñih¹ˉ³ i⁴quian³²ˉ⁴ heih⁴³ i⁴li⁴tion²³ˉ⁵ hnei³ crau¹, jian³ quian³²ˉ⁴ heih⁴³ i⁴li⁴lion³²ˉ⁴ hnei³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","I² jon³ a⁴ŋangh³ Jesús: ―I¹con³ heih⁴³ sa⁴ma²quianh²ˉ³ i²con²³ jnia⁴, a¹juah⁴ne³ sa⁴ma²a⁴cúa⁴ A³cua⁴³ ñi⁴jeu⁵; i² jon³ ne⁵, eu⁴³a² pain⁴ chie³² quieh¹ a³a⁴cúah³ jnia⁴ i²conh²ˉ³ la⁴conh⁴a² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","I² liah⁴ma²jon³ ma²hnoh³ Pilato hain³liah⁴ li⁴lion⁴i³; i² judío tionh² ti²hleh²i³ tia⁴, juah⁴i³: ―¡Juah⁴ne³ lionh³²ˉ³ a³ne³, a⁵sia³ langh⁴³ˉ³ a³ñi³reunh¹ gobierno romano! ¡Quie¹ la⁴jang³⁴ a³júan³ lang⁴³ re¹, ua³tsain³²i³ gobierno! ");
INSERT INTO cucNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","I² Pilato ne⁵, con³ma²a⁴nau⁴i³ jau²³ jon³, jon³ a⁴tyein³i³ Jesús, jian³ a⁴cua⁴i³ i²can²³i³ jau²chie⁴³, i²sain³ Gabata jau²³ hebreo, i⁴ra³juah⁴: I²leg⁴³ Piso Leg⁴³ A²caun². ");
INSERT INTO cucNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jian³ ma³a⁴teg⁴ la⁴conh⁴ i⁵hyie³ hlo⁴ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto. I² jon³ a⁴juah⁴ Pilato i²con²³ judío liah⁴: ―¡Jeh³², a³la³ si²sainh⁴³ Re¹ quianh³ˉ³! ");
INSERT INTO cucNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","I² jon³ a⁴hleh⁴i³ tia⁴ la⁴jang³⁴i³ tionh²: ―¡Ua²jaun⁴i³! ¡Ua²jaun⁴i³! ¡Crau¹ tion⁴³i³ hnei³! I² jon³ a⁴juah⁴ Pilato: ―¿O⁴ tion²³ˉ⁵ crau¹ Re¹ quianh³ˉ³ tionh²ˉ³, lainh⁴ˉ³? I² jon³ a⁴ŋangh³ la⁴jang³⁴ m³chie³ tyein² hain⁴: ―A⁵sian⁴³ re¹ ma⁵sian³ quian⁴ jnie³² a³sang²³, jan³ re¹ romano pa², a³lang⁴³ gobierno. ");
INSERT INTO cucNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","I² jon³ a⁴cúanh³i³ Jesús i²con²³ a³hain⁴ tionh² canh⁴a² si⁵tion⁴i³ crau¹, ma²jon³ a⁴te¹i³, jian³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jon³ ŋo³⁴ Jesús ya¹quian³ crau¹ la⁴teg⁴ con³ i²sain³ Ma³tyi² Húan³⁴, jian³ jau²³ hebreo sain³ Gólgota. ");
INSERT INTO cucNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","I²jon³ a⁴tion⁴i³ Jesús crau¹, jian³ a⁴tion⁴i³ i²on³⁴ a³sang²³ jian²³i³, ma⁵jan³ la⁴conh⁴a² jo³², to⁵chieh³² hein² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","I² jon³ a⁴tien⁴ Pilato con³ jo³²hma³ ma³tyi² crau¹ i⁴ra³sag² la⁴la³: JESÚS A³SIAN³ JEU³ NAZARET, RE¹ QUIAN¹ JUDÍO TIONH². ");
INSERT INTO cucNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jian³ jeun⁴³ judío a⁴heg⁴ i⁴ra³sag² jon³, quie¹ i²a⁴tion⁴i³ Jesús crau¹ jon³, hloh³² je¹jeu³ jon³pa², jian³ jau²³ i⁴ra³sag² jon³ ra³hleh² jau²³ hebreo, jian³ jau²³ griego, jian³ jau²³ la³tein²³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","I² jon³ a⁴juah⁴ m³chie³ tyein² quian¹ judío, a⁴sagh⁴³i³ Pilato: ―A⁵sag³ hnei³ i⁴lang⁴³i³ “Re¹ quian¹ judío”; quie¹ hniah³ sagh²ˉ³ la⁴la³: “Juah⁴ a³la³, jnia⁴ lang⁴³ Re¹ quian¹ judío tionh².” ");
INSERT INTO cucNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","I² a⁴ŋangh³ Pilato ne⁵: ―Liah⁴ a⁴sag³⁴ˉ⁴, ma³ra³sag²pa². ");
INSERT INTO cucNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I² con³ma²a⁴tion⁴ a²hlie⁴ hain⁴ tionh² Jesús crau¹, ma²jon³ a⁴tang⁴i³ a²cúan³ Jesús, a⁴jeun³⁴i³ quin⁴ chieh³², ma⁵con³ queih³² la⁴jan³i³. Conh⁴liah⁴ a⁴tang⁴i³ a²hmh³ tsei²³ coh⁵ i⁴sa⁴ni²hm²³ hlion⁴ i⁴ra³hm²³ con³ ra³lang³² la⁴teg⁴ yeih³² la⁴teg⁴ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma²jon³ a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―A⁵sia³ jeun³²ˉ¹, eu⁴³a² re³ ua²tyi³²ˉ¹ jau²chie⁴³, niah²ˉ¹ hain³ teg³⁴ quieh¹. A⁴leg³⁴ la⁴ne³ i⁴ra⁵tei⁴³ i⁴ra³sag² Ma²jyi³ i⁴ra³juah⁴: “A⁴tyonh⁴i³ a²cúan³⁴ˉ⁴ jen²i³ tionh², nei² quieh¹ a²hmh³ quien⁴ˉ⁴ a⁴tyi³i³ jau²chie⁴³.” I² la⁴ne³ a⁴júan⁴ a²hlie⁴ hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jian³ hlonh² crau¹ i²ya¹ton³ Jesús jon³ si²sainh⁴³ sie²³i³, jian³ a³m⁴ reunh¹ sie²³i³ liah⁴, jian³ Ma³rei² i³cúa³ Cleofas, jian³ Ma³rei² Ma³da³len² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","I² con³ma²a⁴jen³ Jesús sie²³, jian³ chie³ quian¹i³ a³eu⁴³ ma²hnio³⁴i³ hain⁴ a³si²sainh⁴³, jon³ a⁴sagh⁴³i³ sie²³: ―I²ne³ si²sainh⁴³ a³jonh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","I² con³ma²a⁴hleh⁴i³ jon³, jon³ a⁴sagh⁴³i³ chie³ quian¹ liah⁴: ―I²ne³ si²sainh⁴³ sieh³ˉ³. I² liah⁴ma²jon³ a⁴te¹ chie³ quian¹ Jesús hain⁴ la⁴teg⁴ jauh³² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","I² con³ma²a⁴leg³⁴ jon³, jon³ a⁴juah⁴ Jesús jau²³ la³ canh⁴a² li⁴tei⁴³ i⁴ra³sag² Ma²jyi³, quie¹ ñi³i³ i⁴ma³ra⁵tei⁴³ la⁴jeg³⁴, a⁴juah⁴i³: ―Ta² quein³ tsei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","I²jon³ ma²seih⁴³ con³ a²tsai³² si²canh³ o¹bein² jeinh³; jon³ ma⁴jñah⁴i³ con³ i⁴nah³ joh⁴³ o¹bein² jeinh³, jian³ si⁴tyi⁵i³ con³ a²hma³ i⁴sain³ hisopo, jon³ a⁴sie³⁴i³ la⁴teg⁴ ho³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","I² con³ma²a⁴yeinh³ Jesús o¹bein² jon³, jon³ a⁴juah⁴i³: ―Ma³ra⁵tei⁴³ la⁴jeg³⁴. Con³ma²a⁴tah⁴ ma³tyi²i³, jon³ a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","I² hlo⁴ jm² jon³ a⁴leg³⁴ la⁴jeg³⁴ i⁴jon³, i⁴jon³ sa⁴hnie³⁴ judío i⁴ti²ton³i³ crau¹ la⁴teg⁴ hie³⁴, jm² sa⁴júan³i³ ta¹, quie¹ eu⁴³ hen² jm² sa⁴júan³i³ ta¹ jon³. I⁴jon³ ni²mh²i³ Pilato i⁴si⁵jie⁴i³ ma³tag³² a³ti²ton³ crau¹ hain⁴, jian³ i⁴si⁵jyon³²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","I² jon³ ne⁵, ua⁵han² a²hlie⁴ tionh², jian³ a⁴jie⁴i³ ma³tag³² jan³ ra⁴lie⁵, conh⁴liah⁴ a⁴jie⁴i³ ma³tag³² i²jan³ liah⁴ a³ti²ton³ jian²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","I² con³ma²a⁴tyie³⁴i³ hlonh² Jesús, i² quie¹ a⁴je³⁴i³ i⁴ma³ya¹jaun², i⁴jon³ a⁵sie⁴³ a⁴jie⁴i³ ma³tag³²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","I² jon³ ne⁵, a⁴toh³ jan³ a²hlie⁴ a²ñi²seinh³ co³jo³² ni²tsei⁴³ Jesús, jian³ liah⁴ma²jon³ a⁴húa³ jm³yein⁴ jian³ jm³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","I² a³hain⁴ a³a⁴je³⁴, tya²³i³ jau²³, jian³ jau²³ i⁴tya²³i³ jon³ ni²tei⁴³, jian³ ñi³i³ re³ i⁴hleh²i³ jau²³ ni²tei⁴³, canh⁴a² li⁴hainh⁴ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Quie¹ a⁴leg³⁴ la⁴jeg³⁴ i⁴la³ canh⁴a² li⁴tei⁴³ jau²³ i⁴ra³sag² Ma²jyi³ i⁴ra³juah⁴: “A⁵sia³ jie³⁴ a²úan²³ quieh¹i³.” ");
INSERT INTO cucNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jian³ ra³sag² i²con³ liah⁴ i⁴ra³juah⁴: “Jen⁴³i³ a³a⁴toh³i³ a²ñi²³.” ");
INSERT INTO cucNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","I² ta⁵ma³a⁴leg³⁴ la⁴jeg³⁴ i⁴jon³, jon³ ñei² jan³ chie³ a³sain³ Se¹ a³sian³ jeu³ Arimatea, a³lang⁴³ chie³ quian¹ Jesús ta⁵ni²hma², quie¹ con⁴³i³ judío, ni²mh²i³ Pilato i⁴cúa³⁴i³ jeu³ i⁴si⁵quien²³i³ he³² Jesús ton³ crau¹. Ma²jon³ a⁴cúa⁴ Pilato jeu³, jian³ ŋo³⁴ Se¹ hain⁴ ni²quien²³i³ he³² Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Conh⁴liah⁴ Nicodemo liah⁴, a³hain⁴ a³ni²jen³² Jesús con³ to⁵hlo³⁴ liah⁴ma²jia⁴³, a⁴tyie³⁴i³ quian³i³ qui⁴quia⁴ kilo o¹tai³² i⁴jia²³ ma³jeu³ i⁴ni²conh² mirra jian²³ áloes. ");
INSERT INTO cucNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ma²jon³ a⁴con²³i³ he³² Jesús li⁵uan⁴i³ jon³, jian³ a⁴lion³i³ a²hmh³ ta⁵ra³ponh² jian²³ o¹tai³² i⁴jia²³ ma³jeu³ jon³, liah⁴i² tang²³ chie³ judío tionh² hon²³i³ a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","I² o³chie⁴³ i²a⁴tion⁴i³ crau¹ jon³, leg⁴³ con³ je¹ a²hma³, jian³ je¹ a²hma³ jon³ ho³ con³ to³ i⁴can¹ a⁴cag³⁴i³, i²jon³ i²sa⁴ma³a⁴quion³i³ i¹jan³ a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","I² jon³ a⁴quie³i³ he³² Jesús to³ jon³ ta¹tia⁴ hion²³ quie¹ ta⁵la⁴ hloh³² ho³, quie¹ nei² quieh¹ ma³o¹si⁵hei⁴ jm² i⁴júan³ judío i⁴a⁴lon⁴ jmai³sie²³i³ húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jm² ra⁴lie⁵ sa³ma², jon³ ŋo³⁴ Ma³rei² Ma³da³len² to³ i²ra³hon³i³ to⁵hie³ hion²³, naih³ pi¹ co⁴meih³; i² jon³ a⁴je³⁴i³ i⁴a⁵sie⁴³ si²jneng³ a²caun² júah³ ho³²to³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","I² jon³ jonh³i³ jeu³ra³tyi⁴ la⁴teg⁴ i²cua⁴³ Si²úan¹ Pe³² jian²³ i²jan³ chie³ quian¹ Jesús a³sang²³, a³eu⁴³ ma²hnio³⁴i³ hain⁴, a⁴sagh⁴³i³ tionh²: ―Ma³a⁴te¹i³ Se³ño²³ to³ i²ma²ra³hon³i³, sa⁴nia² jainh¹ ni²quion³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","I² jon³ ua⁵hag⁴³ Pe³² jian²³ i²jan³ chie³ quian¹ Jesús hain⁴ la⁴teg⁴ ho³²to³, ua⁵han²i³ la⁴teg⁴ to³ i²ra³hon³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Li⁵uan⁴i³ la⁴jon³ ua⁵han²i³ jeu³ra³tyi⁴; jian³ i²jan³ hain⁴ tsei³⁴sa² tia⁴ ŋo³⁴i³ la⁴conh⁴a² Pe³², a⁴tyie³⁴i³ co⁴ra⁴lie⁵ ho³²to³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jon³ a⁴jeunh³i³ cah³², a⁴je³⁴i³ to³, jian³ a⁴je³⁴i³ a²hmh³ ma²lion³i³ jon³ ti²nie⁴³; i² a⁵sia³ a⁴hei³⁴i³ naih⁵ to³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","I² coh⁵ jon³, jon³ a⁴tyie³⁴ Si²úan¹ Pe³², jian³ a⁴hei³⁴i³ to³, jian³ a⁴je³⁴i³ a²hmh³ ma²lion³i³ i⁴ti²nie⁴³ i²jon³; ");
INSERT INTO cucNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","jian³ a⁴je³⁴i³ a²hmh³ i⁴ma²lie³ ma³tyi² Jesús i⁴sa⁴ti²nie⁴³ co⁴chia³ jian²³ a²hmh³ ma²lion³i³ jon³, quie¹ ra³pan³ nie⁴³ ta⁵co⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Conh⁴liah⁴ a⁴hei³⁴ chie³ quian¹ Jesús, i²jan³ hain⁴, a³hain⁴ a³ma²a⁴tyie³⁴ co⁴ra⁴lie⁵ ho³²to³; jon³ a⁴je³⁴i³ la⁴jon³ jian³ ra⁵chie⁴³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Quie¹ a⁵sia³ ma³ra⁵ŋang⁴i³ tionh² i⁴ra³sag² Ma²jyi³ i⁴hniah³ hyon⁴³ Jesús ton³²nie⁴³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","I² jon³ a⁵han² chie³ quian¹i³ hain⁴ i²con²³ jon²reunh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","I² Ma³rei² ne⁵, si²jian²³i³ ho³²to³, si²hoh⁵i³ hloh³². I² ta¹la⁴ si²hoh⁵i³, a⁴júan⁴i³ ta⁵i²hain²³i³ i⁴je³⁴i³ naih⁵ to³, ");
INSERT INTO cucNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","jian³ a⁴jen³i³ on³⁴ ángel a³tionh² a²hmh³ tie³ a³ti²tionh² i²ma²ra³quian³ Jesús, jan³ si²sainh⁴³ i²ma²leg⁴³ yeih³² tyi²i³ jian³ jan³ si²sainh⁴³ i²ma²leg⁴³ he⁴³ tag³²i³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A³a⁴juah⁴ tionh² i⁴sagh⁴³i³ Ma³rei²: ―A³m⁴, ¿e⁴le³⁴ si²hoh⁵ˉ³? I² jon³ a⁴juah⁴i³: ―Jon³pa² quie¹ a⁴te¹i³ Se³ño²³ quian³⁴ˉ⁴, sa⁴yan³²ˉ⁴ jainh¹ ni²quion³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Con³ma²a⁴juah⁴i³ jau²³ jon³, jon³ ua⁵lang⁴i³, a⁴jen³i³ Jesús a³si²sainh⁴³ i²jon³, ma⁵sa⁴ñi³ pi¹i³ o⁴ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","I² jon³ a⁴juah⁴ Jesús i²con²³i³: ―¿E⁴le³⁴ hoh⁵ˉ³, a³m⁴? ¿Hain³ hnah⁵ˉ³? I² a³m⁴ hain⁴, a⁴júan⁴i³ co³hei²tsei³, lain⁴i³, a³hie³ je¹ a²hma³ jon³pa², jian³ a⁴sagh⁴³i³: ―Hnei³ a³don⁵, juah⁴ne³ hnei³ la⁴teh⁴³ˉ³, juah¹ hnei³ jainh¹ ni²quionh²ˉ³, canh⁴a² ni¹te³²ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","I² jon³ a⁴juah⁴ Jesús: ―¡Ma³rei²! I² jon³ ua⁵lang⁴ Ma³rei², a⁴juah⁴i³ jau²jm⁴³ hebreo: ―¡Raboni! ―i⁴hnie³⁴ ra³juah⁴, A²teg²³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","I² jon³ a⁴juah⁴ Jesús: ―A⁵ñeih³² jmah⁴³ hnei³ jnia⁴, quie¹ a⁵sia³ ma³ŋah⁵ˉ⁵ i²cua⁴³ Neih³ˉ⁴. I² eu⁴³a² re³ tyieh⁴ˉ³ i²tionh² si³reunh³ˉ⁴ yi⁴saih³²i³ hnei³ i⁴naih²ˉ⁵ i²cua⁴³ Neih³ˉ⁴ jian³ Naih⁴³ˉ³ tionh²ˉ³, Jon⁴dai¹ quian³⁴ˉ⁴ jian³ Jon⁴dai¹ quianh³ˉ³ liah⁴ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","I² jon³ ŋo³⁴ Ma³rei² Ma³da³len² i⁴ua⁵saih¹i³ chie³ quian¹ Jesús jau²³ hm²³ ne³ i⁴a⁴jen³i³ Se³ño²³, jian³ i⁴a⁴hleh⁴i³ jau²³ la³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","I² con³ma²a⁴nai³ jm² ra⁴lie⁵ sa³ma² jon³, jon³ ti²ŋangh³ chie³ quian¹ Jesús i⁴tionh²i³ si²jnang¹ o²hnei³², quie¹ con⁴³i³ judío tionh². I² jon³ a⁴tyie³⁴ Jesús, a⁴no³i³ to⁵chieh³² jen²i³ tionh², a⁴juah⁴i³: ―Ua²tionh²ˉ³ hyon³ hoh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","I² con³ma²a⁴hleh⁴i³ jau²³ jon³, jon³ a⁴he⁴i³ si¹cúa³ jian³ co³jo³² ni²tsei⁴³i³. I² chie³ quian¹i³ tionh² ne⁵, ta² si³hyonh³i³ a⁴leg³⁴ i⁴jen³i³ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Conh⁴liah⁴ a⁴juah⁴ Jesús liah⁴ i⁴seg³⁴: ―Ua²tionh²ˉ³ hyon³ hoh⁴³ˉ³ tionh²ˉ³. La⁴jon³ liah⁴i² a⁴sai⁴ jnia⁴ Neih³ˉ⁴, la⁴ne³ sain¹ˉ⁴ hnei³ tionh²ˉ³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","I² con³ma²a⁴hleh⁴i³ jau²³ jon³, jon³ a⁴jai³⁴i³ tyi⁴ jen² a³hain⁴ tionh², a⁴juah⁴i³: ―Hyei² hnei³ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","A³hain⁴ a³hainh⁵ˉ³ chie³² quieh¹, ma³a⁴jlenh³ chie³² quieh¹i³; jian³ a³hain⁴ a³sa⁴hainh⁵ˉ³ chie³² quieh¹, liah⁴ma³ren³ jon³ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","I² To³ma²³ hain⁴ a³teh²i³ A³cuan²³ On³⁴, a³lang⁴³ jan³ a³hein² jen² quia⁵teun⁴ chie³ quian¹ Jesús, a³sa⁴si²sainh⁴³ con³ma²ma⁴jnia³² Jesús i²con²³ chie³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","I² jon³ a⁴tya⁴ chie³ quian¹ Jesús hain⁴ tionh² jau²³ i²con²³ To³ma²³, a⁴juah⁴i³: ―Ma³a⁴nia² jnie³² Se³ño²³. I² jon³ a⁴juah⁴ To³ma²³: ―Juah⁴ne³ sa⁴je³⁴ˉ⁴ si¹cúa³i³ i²a⁴toh³ a²jon⁴³ñi²³, jian³ tonh¹ˉ⁴ jon⁴³ si¹cúa³⁴ˉ⁴ o³chie⁴³ jon³ liah⁴, jian³ juah⁴ne³ sa⁴tonh¹ˉ⁴ si¹cúa³⁴ˉ⁴ jo³² ni²tsei⁴³i³ i²a⁴toh³ a²ñi²seinh³, sa⁴legh⁴ ua²ra⁵hain⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Liah⁴ma³jña³⁴ jm² jon³, jon³ si²ŋangh³ chie³ quian¹ Jesús liah⁴ i⁴seg³⁴ con³ jauh³², jian³ si²sainh⁴³ To³ma²³ jen²i³. Jian³ ua²liah⁴a² ma²si²jnang¹ o²hnei³², a⁴hei³⁴ Jesús jen²i³, a⁴no³i³ to⁵chieh³², a⁴juah⁴i³: ―Ua²tionh²ˉ³ hyon³ hoh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ma²jon³ a⁴sagh⁴³i³ To³ma²³: ―Tienh³ hnei³ jon⁴³ si¹cúah³ i²la³, je¹ hnei³ si¹cúa³⁴ˉ⁴; na⁴ŋang³² hnei³ si¹cúah³, tienh³ hnei³ si¹cúah³ co³jo³² ni²tsei³⁴ˉ⁴ ho³² ñi²³ la³. A⁵júan³ hnei³ i⁴sa⁴hainh⁴ˉ³, ua²li⁴hainh⁴ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","I² jon³ a⁴ŋangh³ To³ma²³, a⁴juah⁴i³: ―¡Se³ño²³ quian³⁴ˉ⁴, jian³ Jon⁴dai¹ quian³⁴ˉ⁴ liah⁴! ");
INSERT INTO cucNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","I² jon³ a⁴juah⁴ Jesús: ―To³ma²³, ne⁵pi¹ ra⁵hainh⁴ˉ³ quie¹ a⁴jeh³²ˉ³ jnia⁴. Eu⁴³ tsei³⁴ jm² ren³ la⁴jang³⁴ a³hain⁴ i²con²³ jnia⁴ i⁴sa⁴a⁴je³i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hlion⁴ pi¹ ua³júah² a⁴júan⁴ Jesús ta⁵nei² chie³ quian¹ tionh² i⁴jon³ i⁴sa⁴ra³sag² nei² ma²jyi³ libro la³. ");
INSERT INTO cucNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","I² i⁴la³pa² ua⁵sag² canh⁴a² li⁴hainh⁴ˉ³ i⁴lang⁴³ Jesús A³ua⁵lion³² Chie³ hain⁴, A³jon⁴³ Jon⁴dai¹, jian³ canh⁴a² con⁴juah⁴ i⁴hainh⁴ˉ³ i²con²³i³, li⁴sia³ m⁵cu³ quianh³ˉ³ con⁴juah⁴ hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Con³ma²ua⁴jeu³² jon³, jon³ a⁴ma⁴jnia³² Jesús liah⁴ i⁴seg³⁴ i²con²³ chie³ quian¹, quien¹i²jm¹ jm³ñei³ Tiberias. Ma⁴jnia³²i³ la⁴la³: ");
INSERT INTO cucNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ti²tionh² Si²úan¹ Pe³² co⁴chia³ jian²³ To³ma²³, a³hain⁴ a³teh²i³ A³cuan²³ On³⁴, jian³ Natanael, a³sian³ jeu³ Caná i⁴nie⁴³ húa³⁴ Galilea, jian³ si³jon⁴³ Zebedeo, jian³ i²on³⁴ chie³ quian¹ Jesús, a³sang²³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","I² jon³ a⁴juah⁴ Si²úan¹ Pe³²: ―Nai³²ˉ⁴ ni¹jmah⁵ˉ⁵ jah⁴ tieh²la³. I² jon³ a⁴juah⁴i³ tionh²: ―Chie²pa² jnie³² liah⁴ jie³ jnie³² hnei³. Jon³ ua⁵han²i³, a⁴han⁵i³ joh⁴³ a²úan⁴³, jian³ je¹nai³ jon³ i¹jan³ jah⁴ sa⁴a⁴jon⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","I² con³ma²ma³hei¹ ta⁵jnia³, jon³ a⁴ma⁴jnia³² Jesús quien¹i²jm¹ i²chie³²; i² chie³ quian¹i³ tionh² ne⁵, sa⁴ñi³i³ hain³ chianh² hei⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","I² jon³ a⁴juah⁴i³: ―Hnei³ tionh²ˉ³, si³maih², ¿a¹sian⁴³ jah⁴ ma³ra³jonh⁴ˉ³? I² jon³ a⁴juah⁴i³ tionh²: ―A⁵sian⁴³ sian³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","I² jon³ a⁴juah⁴ Jesús liah⁴: ―Yi⁴tiah²ˉ³ a²nai²³ jo³² ta⁵chie³⁴ a²úan⁴³, ma²jon³ jonh⁴ˉ³ jah⁴. Ma²jon³ ni²tiah³i³ a²nai²³, i² con³ma²a⁴leg³⁴ jon³, a⁵sie⁴³ ma⁵li⁴soh⁴³, quie¹ eu⁴³ jeun⁴³ jah⁴ ni²hñi⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","I² jon³ ne⁵, chie³ quian¹ Jesús, a³eu⁴³ ma²hnio³⁴i³ hain⁴, a⁴sagh⁴³i³ Pe³²: ―¡Se³ño²³pa² ne³! I² Si²úan¹ Pe³², con³ma²a⁴nau⁴i³ jau²³ i⁴ Se³ño²³ a³hain⁴, jon³ a⁴hei³⁴i³ a²cúan³, quie¹ ta⁵la⁴ ma²a⁴tyi³i³, ma²jon³ a⁴juan³⁴i³ joh⁴³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","I² la⁴jang³⁴ chie³ quian¹ Jesús i²co⁴hna³ hain⁴, ŋah³i³ ta⁵i²quein³ jeu³ joh⁴³ a²úan⁴³ ya¹cmh²i³ a²nai²³ ni²hñi⁴³ jah⁴, quie¹ la⁴conh⁴ teun³⁴ nia⁴lo⁴ leg³ tei⁴³ i²ma²ya¹hei⁴³ a²úan⁴³ la⁴teg⁴ i²jm¹. ");
INSERT INTO cucNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","I² con³ma²a⁴húan³i³ joh⁴³ a²úan⁴³ i²quein³, jon³ a⁴je³⁴i³ i⁴nie⁴³ jyi³ ni²co²³ o¹tah³ jian³ ra³tsain²³ jon⁴³júa³² nei² jyi³, jian³ a²hei⁴³ñih¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","I² jon³ a⁴juah⁴ Jesús: ―Jian⁴³ hnei³ co⁴meih³ jon⁴³júa³² a³jeu³ la⁴jon⁴ ne³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","I² jon³ a⁴hei³⁴ Si²úan¹ Pe³² joh⁴³ a²úan⁴³ jon³, a⁴cmh³i³ a²nai²³ la⁴teg⁴ i²quein³ si²canh³ ni²hñi⁴³ jon⁴³júa³² canh², a³tain⁴³ nia⁴lon⁴ ni²tsain¹ to⁴lo⁵quian⁴ ra³tsein²³ on³; jian³ ua²liah⁴a² eu⁴³ jeun⁴³, a⁵sia³ a⁴cag³ a²nai²³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","I² jon³ a⁴juah⁴ Jesús: ―Nia³ ni³cauh⁴³ tionh²ˉ³. Jian³ i¹jan³ chie³ quian¹i³ sa⁴tia⁴ tsei⁴³i³ ŋang³⁴ i²con²³i³: “¿Hain³ hnei³?” quie¹ ma³ti²ñi³ pi²³i³ tionh² i⁴ Se³ño²³pa². ");
INSERT INTO cucNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","I² jon³ ŋo³⁴ Jesús hlonh²i³, a⁴tang⁴i³ a²hei⁴³ñih¹, a⁴cúah³i³ a³hain⁴ tionh²; conh⁴liah⁴ la⁴jon³pa² a⁴júan⁴i³ jon⁴³júa³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ne³ i²ma³a⁴teg⁴ hnang²³ nie⁴³ ma³jnia³² Jesús i²con²³ chie³ quian¹ tionh², ta⁵ma³a⁴hyon²³i³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","I² con³ma²a⁴leg³⁴ ti²queuh³i³ a²hei⁴³ tionh², jon³ a⁴ŋang⁴ Jesús i²con²³ Si²úan¹ Pe³²: ―Hnei³ Si²úan¹, a³jon⁴³ Jonás, ¿o⁴ hnoh⁴³ˉ³ jnia⁴ la⁴conh⁴a² a³ne³? I² jon³ a⁴ŋangh³ Pe³²: ―Jen³⁴, Se³ño²³, ma³ñih¹pa² hnei³ i⁴hno⁵ˉ⁵ hnei³. I² jon³ a⁴juah⁴ Jesús: ―Guenh³² hnei³ a⁵a³siah³ quian³⁴ˉ⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Conh⁴liah⁴ a⁴ŋang⁴i³ a²teg⁴ taun³⁴ nie⁴³: ―Hnei³ Si²úan¹, a³jon⁴³ Jonás, ¿o⁴ hnoh⁴³ˉ³ jnia⁴? Jon³ a⁴ŋangh³ Pe³²: ―Jen³⁴, Se³ño²³, ñih¹pa² hnei³ i⁴hno⁵ˉ⁵ hnei³. Jon³ a⁴juah⁴i³: ―Hion³² hnei³ a⁵a³siah³ quian³⁴ˉ⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Conh⁴liah⁴ a⁴ŋang⁴ Jesús a²teg⁴ hnang²³ nie⁴³: ―Hnei³ Si²úan¹, a³jon⁴³ Jonás, ¿o⁴ hnoh⁴³ˉ³ jnia⁴? I² jon³ ra⁵chionh⁴ tsei⁴³ Pe³², quie¹ a⁴ŋang⁴i³ hnang²³ nie⁴³ i⁴juah⁴i³: “¿O⁴ hnoh⁴³ˉ³ jnia⁴?” I² jon³ a⁴ŋangh³ Pe³²: ―Hnei³ Se³ño²³, la⁴jeg³⁴pa² ñih¹ˉ³. Jian³ ñih¹pa² hnei³ i⁴hno⁵ˉ⁵ hnei³. Conh⁴liah⁴ a⁴juah⁴ Jesús: ―Guenh³² hnei³ a⁵a³siah³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","I⁴chie⁴³pa² jeu³⁴ˉ⁴ hnei³, liah⁴ma²maih⁴³ˉ³, ma²hñih⁵ hnei³ húanh⁴³ a²cúanh³, jian³ ma²cúah⁴ˉ³ jainh¹ i²hyon³ hoh⁴³ˉ³ cúah²ˉ³; i² la⁴teg⁴i² ma³a⁴yinh³ˉ³ ne⁵, jon³ ñeih²ˉ³ ma³cúah³ˉ³, jian³ a³sang²³pa² hñih⁴³ hnei³, jian³ si⁵jo⁴i³ hnei³ i²sa⁴hnoh³ˉ³ cúah²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","A⁴hleh⁴ Jesús i⁴ne³, a⁴he⁴i³ hain³liah⁴ jaun⁴ Pe³² i⁴júan³⁴i³ júanh⁴³ Jon⁴dai¹. I² con³ma²a⁴hleh⁴i³ jon³, jian³ a⁴juah⁴i³ liah⁴: ―Nia³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Con³ma²a⁴jainh³ Pe³² nei², jon³ a⁴jen³i³ chie³ quian¹ Jesús ya¹tyein¹ coh⁵, a³hain⁴ a³eu⁴³ ma²hnio³⁴ Jesús, a³ma²a⁴cua⁴ hlonh² Jesús con³ma²a⁴queuh³i³ a²hei⁴³, jian³ a³a⁴ŋang⁴: “Hnei³ Se³ño²³, ¿hain³ a³hain⁴ a³cúah⁴³ hnei³?” ");
INSERT INTO cucNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","I² con³ma²a⁴je³ Pe³² quieh¹i³, jon³ a⁴sagh⁴³i³ Jesús: ―Hnei³ Se³ño²³, ¿liah⁴a² jainh⁴³ a³ne³ ne⁵? ");
INSERT INTO cucNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","I² jon³ a⁴juah⁴ Jesús: ―Juah⁴ne³ hno⁵ˉ⁵ i⁴sian³i³ la⁴teg⁴i² ma³nioh⁵ˉ⁵, ¿henh⁴ jm² si²quianh¹ˉ³? Hnei³pa² hniah³ niah²ˉ³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","I² jau²³ ne³ ta⁴tsei¹ jen² si³reunh¹i³ tionh² i⁴sa⁴jaun⁴ chie³ quian¹ Jesús hain⁴. I² Jesús ne⁵, a⁵sia³ i⁴juah⁴i³ juah⁴ i⁴sa⁴jaun⁴ a³hain⁴, i⁴jon³pa² juah⁴i³: “Juah⁴ne³ hno⁵ˉ⁵ i⁴sian³i³ la⁴teg⁴i² ma³nioh⁵ˉ⁵, ¿henh⁴ jm² si²quianh¹ˉ³?” ");
INSERT INTO cucNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Chie³ hain⁴pa² ne³ tya²³ jau²³ la⁴jeg³⁴ i⁴la³, jian³ a⁴sag⁴i³ jau²³ la³ liah⁴. Jian³ nia² jnie³² jau²³ i⁴tya²³i³ jon³ leg⁴³ jau²³ ni²tei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jian³ hlion⁴ pi¹ i⁴a⁴júan⁴ Jesús, i² juah⁴ne³ ma²ua⁵sag² ma⁵con³ la⁴conh⁴ con³, lain³⁴ jnia⁴, i¹ sa⁴ma²haih¹ m⁵cu³ la⁴jeg³⁴ ma²jyi³ ma²si⁵sag². Ua²lei⁴ la⁴ne³.");
INSERT INTO cucNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Hnei³ Tio³², ma²jyi³ libro i⁴a⁴sag³⁴ˉ⁴ liah⁴ma²ra⁴lie⁵ jon³, a⁴tya³⁴ˉ⁴ jau²³ la⁴jeg³⁴ i⁴a⁴júan⁴ Jesús jian³ i⁴a⁴he⁴i³, ");
INSERT INTO cucNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","la⁴conh⁴i² a⁴tyie³⁴ jm² i⁴ŋah³i³ ñi⁴jeu⁵, ta⁵ma³a⁴júan⁴i³ heih⁴³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹, i²con²³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹i³, a³a⁴quianh⁴³i³ liah⁴ma²ra⁴lie⁵. ");
INSERT INTO cucNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jian³ ta⁵ma³a⁴can³⁴i³ ma²eu⁴³ liah⁴a² a⁴jaun³⁴i³ jon³, jon³ ma⁴jnia³²i³ i²con²³ a³hain⁴ tionh² hlion⁴ nai², i⁴sian³i³ i⁴chie⁴³ i⁴si²chion³i³, jian³ ma⁴jnia³²i³ la⁴ne³ liah⁴o⁵jleg³⁴ ta¹la⁴ to⁴lo⁵ jm², jian³ a⁴hlenh⁴³i³ a³hain⁴ liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","I² con³ma²tionh²i³ co⁴chia³, jon³ a⁴júan⁴ Jesús heih⁴³ i²con²³i³ i⁴sa⁴húan⁵i³ je¹jeu³ Jerusalén, a⁴juah⁴i³: ―Quie¹ hniah³ jianh²ˉ³ i⁴jon³ i⁴juah⁴ Jmai³²ˉ¹ cúa³⁴, liah⁴i² ma³a⁴naih³ˉ³ a⁴juah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Quie¹ chie⁴³pa² a⁴sion⁴³ Juan²³ chie³ jm³ con⁴juah⁴ o¹jm³; i² hnei³ tionh²ˉ³ ne⁵, hie³⁴ yie⁴ la³ jia²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ si⁵hei⁴ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","I² jon³ a⁴ŋang⁴ a³hain⁴ tionh², a³ma²tionh² co⁴chia³ jian²³i³, a⁴juah⁴i³: ―Hnei³ Se³ño²³, ¿o⁴ ma³a⁴tyie³⁴ jm² i⁴lain⁴ a³co³²ˉ¹ ta¹, a³júan³⁴ heih⁴³ la⁴tan² húa³⁴ Israel la³? ");
INSERT INTO cucNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","I² a⁴juah⁴ Jesús ne⁵: ―A⁵sia³ tainh⁴³ˉ³ li⁴ñih¹ˉ³ tionh²ˉ³ hain³ jm² jian³ hain³ hyieh² júan³⁴ Jmai³²ˉ¹ henh⁴ hnie³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","I² la⁴teg⁴i² jia²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ Jmai³ i²conh²ˉ³ tionh²ˉ³ ne⁵ jian³ i⁴hyeih²ˉ³ hlion⁴ ua³pei⁴, ma²jon³ húanh⁵ˉ³ ua²hleh²ˉ³ jau²³ quien⁴ˉ⁴, ma²lieh¹ˉ³ je¹jeu³ Jerusalén, jian³ la⁴tan² húa³⁴ Judea, jian³ húa³⁴ Samaria, jian³ ua²hanh²ˉ³ ua²hleh²ˉ³ la⁴tan² m⁵cu³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","I² con³ma²a⁴cúa⁴ Jesús jau²³ la³, to⁵ti²je²³i³ jon³ tionh², ŋah³i³ ñi⁴jeu⁵; i² jon³ ja³⁴ con³ o¹jnai⁴³, i² je¹ o¹jnai⁴³ jon³ a⁴quionh³i³, a⁵sie⁴³ ma⁵jnia⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","I² con³ma²ti²je²³i³ ta⁵ñi⁴jeu⁵ tionh², i⁴jen³i³ Jesús ŋah³, tyi¹ a⁴la³ a⁴no³ on³⁴ a³ñih³ ta⁵nei²i³ a³tionh² a²hmh³ tie³, ");
INSERT INTO cucNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a³a⁴juah⁴: ―Hnei³ a³sian³ húa³⁴ Galilea tionh², ¿e⁴le³⁴ ta⁵ñi⁴jeu⁵ ti²jeh⁴ˉ³ tionh²ˉ³? Jesús pa² ne³ ŋah³ ñi⁴jeu⁵ ta⁵mah²ˉ³ tionh²ˉ³, jian³ la⁴ne³pa² jionh⁴i³ liah⁴, liah⁴i² a⁴jeh¹ˉ³ ŋah³i³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","I² jon³ a⁴tyanh³i³ Jerusalén, i⁴jonh³i³ mah⁴ quieh¹ a²hma³ Olivos tionh², i⁴seih⁴³ hloh³² je¹jeu³ Jerusalén i²tei⁴³ la⁴conh⁴ con³ mai²³ metro. ");
INSERT INTO cucNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","I² con³ma²a⁴tyanh³i³ je¹jeu³, jon³ a⁴han⁵i³ con³ jauh³² a²teg⁴ teun³⁴ piso, jauh³² i²ma²jian²³ Pe³² jian³ Jacobo, Juan²³, Dre¹, Lei³², To³ma²³, Bartolomé, Ma³te³², Jacobo a³jon⁴³ Alfeo, jian³ Si²úan¹ Tyeih⁴³ jian³ Judas a³reunh¹ Jacobo. ");
INSERT INTO cucNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Jian³ la⁴jang³⁴ a³hain⁴ tionh², tionh² con³ co³hei²tsei³ i⁴ti²mh²i³ Jon⁴dai¹ i⁴sa⁴teinh³ tsei⁴³i³, jian³ a³m⁴, jian³ Ma³rei² sie²³ Jesús, jian³ si³reunh¹ Jesús liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Jian³ jm² jon³ a⁴no³ Pe³² jen² la⁴jang³⁴ si³reunh¹i³ a³ti²ŋangh³ hain⁴, a³tain⁴³ la⁴conh⁴ nia⁴lon⁴ ni²tsain¹ quion⁴, jon³ a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Goh³ quian³⁴ˉ⁴, ra⁵hniah³ li⁴tei⁴³ jau²³ i⁴ra³sag², i⁴a⁴hleh⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ liah⁴ma²jia⁴³, con⁴juah⁴ i⁴a⁴hleh⁴ Da³vei²³ nei² quieh¹ Judas a³a⁴heh³ chie³ jeu³ i⁴ni²sianh⁴i³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jian³ ma²hein² a³hain⁴ jen² jnie³², jian³ ma²hei¹ joh⁴³ cúa³i³ ta¹ liah⁴ le²³ jnie³² la³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jian³ o¹cau³² a⁴hyei⁴i³ i⁴a⁴tanh⁴i³ chie³² jon³, a⁴la³⁴i³ con³ húa³⁴; i² húa³⁴ jon³ ni²juan³²i³ ta⁵si²hyih¹, jian³ a⁴ŋoh⁴³ hein²i³, a⁴húa³ o¹co³hm³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","I² jon³ ra⁵ñi³ la⁴jang³⁴ a³tionh² je¹jeu³ Jerusalén, i² jon³ a⁴teh³i³ húa³⁴ jon³ jau²jm⁴³ quieh¹, Acéldama, hnie³⁴ ra³juah⁴, Húa³⁴ quieh¹ Jm³yein⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Quie¹ la⁴ne³ ra³sag² ma²jyi³ i⁴teh²i³ Salmo: Ua²seih⁴³ hlagh³² hie⁴³ jauh³² quieh¹i³; a⁵sion⁴³ a³cua⁴³ i¹jan³. Jian³ ra³juah⁴ liah⁴: Ua²júan⁴ a³sang²³ ta¹ nei² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’I² jon³ hniah³ jan³ a³jie³ˉ¹ liah⁴ma²ra⁴lie⁵, ta¹la⁴ jm² i⁴a⁴ŋeng⁴ Re¹ Jesús jie³ˉ¹, ");
INSERT INTO cucNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","liah⁴ma²ra⁴lie⁵ a⁴sion⁴³ Juan²³ chie³ jm³, jian³ la⁴conh⁴i² ŋah³ Jesús ñi⁴jeu⁵, jian³ a³a⁴teg⁴ nei² jie³ˉ¹ con³ma²a⁴hyon²³i³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","I² jon³ a⁴hen⁴³i³ on³⁴ chie³: Se¹ a³teh²i³ Barsabás, jian³ a³ma²teh²i³ Justo liah⁴, jian³ a⁴hen⁴³i³ Ma³tie²³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jon³ a⁴mh³i³ Jon⁴dai¹, a⁴juah⁴i³ tionh²: ―Hnei³ Se³ño²³, ñih¹ hnei³ m⁴tyi⁴ quieh¹ la⁴jang³⁴, he³² hnei³ jnie³² hain³ conh⁴ li⁵uan⁴ la³ ma³a⁴hniah²ˉ³, ");
INSERT INTO cucNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a³si⁵hei⁴ joh⁴³ cúa³ ta¹ liah⁴ le²³ jnie³² la³; quie¹ ua⁵hag⁴³ Judas ta¹ la³, con³ma²a⁴tanh⁴i³ chie³², jian³ ŋah³i³ i²a⁴teg⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jon³ a⁴coh³i³ m⁴cm³² tionh², i² jon³ a⁴teg⁴ quieh¹ Ma³tie²³; a⁴hei³⁴i³ jen² quia⁵con³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo. ");
INSERT INTO cucNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","I² con³ma²a⁴tyie³⁴ jm² i⁴sain³ jm² to⁴lo⁵quia⁴, jon³ ti²ŋangh³ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹ i⁴con³ co³hei²tsei³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Con³ a⁴la³ a⁴nau⁴i³ i⁴hain³² ñi⁴jeu⁵, hain³² la⁴con³ i²ja¹ tyi⁴ tia⁴, a⁴ŋangh³ la⁴tan² jauh³² i²ti²tionh²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","I² jon³ a⁴hag⁴ co⁴hyeih² a³jan³ jan³ la⁴con³ o¹segh³² chie³ i⁴leg⁴³ o¹jyi³ loh⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","I² jon³ a⁴ha⁵ M⁴tyi⁴ quieh¹ Jon⁴dai¹ naih⁵ ni²tsei⁴³i³, a³a⁴cúa⁴ hlion⁴ ua³pei⁴, i² jon³ ma⁴lie⁵i³ hleh²i³ jau²jm⁴³ ma⁵quein²³, liah⁴ hnie³⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ hleh³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jian³ jm² jon³ tionh² judío je¹jeu³ Jerusalén, a³sian³ la⁴tan² m⁵cu³, chie³ a³ni²taih⁴³ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","I² con³ma²a⁴hain³² ti³jan²³ jon³, jon³ a⁴ŋangh³ jeun⁴³ chie³, jian³ sa⁴ñi³i³ henh⁴ si³lei⁴, quie¹ nau³i³ con⁴jan³i³ i⁴ti²hleh² a³hain⁴ jau²jm⁴³ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jian³ con³ma²a⁴nau⁴i³, ta² co³ ŋo³⁴ tsei⁴³i³ tionh², a⁴juah⁴i³: ―¿A¹hei⁴ a³sian³ húa³⁴ Galilea la⁴jang³⁴ a³ti²hleh² ne³? ");
INSERT INTO cucNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Liah⁴ cúan²³ ne⁵, hleh² con⁴jan³ jau²jm⁴³ quian⁴ˉ¹ ma⁵quein²³, i⁴hleh⁴ˉ¹ liah⁴ma²maih⁴³ˉ¹? ");
INSERT INTO cucNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Quie¹ sian³ˉ¹ ta⁵seg³⁴, jian³ tionh² chie³ a³sian³ húa³⁴ Partia, jian³ a³sian³ húa³⁴ Media, jian³ húa³⁴ Elam, jian³ húa³⁴ Mesopotamia, jian³ a³sian³ húa³⁴ Judea la³, jian³ húa³⁴ Capadocia, jian³ húa³⁴ Ponto, jian³ Asia, ");
INSERT INTO cucNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","jian³ húa³⁴ Frigia, jian³ Panfilia, jian³ húa³⁴ Egipto, jian³ jeu³ i⁴nie⁴³ húa³⁴ Africa ta⁵jno³ a²lia⁴ jeu³ Cirene, jian³ tionh² a³sian³ je¹jeu³ Roma liah⁴, ca³chion²³ jnia¹ lang⁴³ judío, jian³ ca³chion²³ jnia¹ a⁴lang³⁴ˉ¹ con³ma²ma³don⁵ˉ¹; ");
INSERT INTO cucNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","jian³ tionh² i²la³ a³sian³ húa³⁴ Creta, jian³ húa³⁴ Arabia liah⁴, ti²nai⁴ˉ¹ ti²hleh²i³ ma⁵quein²³ jau²jm⁴³ quian⁴ˉ¹, la⁴jeg³⁴ ua³júah² i⁴a⁴júan⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","I⁴jon³ ta² co³ a⁴jainh⁴³ la⁴jang³⁴ a³hain⁴ tionh², sa⁴ñi³i³ henh⁴ si³lei⁴, a⁴júanh⁴i³ húan⁴i³ tionh², a⁴juah⁴i³: ―¿Henh⁴ júan³ i⁴hleh² a³ne³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","I² ca³chion²³ ne⁵, a⁴ji⁴ŋang⁴i³ quieh¹i³, a⁴juah⁴i³: ―Ti²hain⁴³pa² a³ne³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jon³ a⁴no³ Pe³² jian²³ quia⁵con³ hain⁴ tionh², a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―Hnei³ a³sian³ húa³⁴ Judea la³, jian³ hnei³ a³tionh² je¹jeu³ Jerusalén la³, nai³ hnei³ re³ jau²³ i⁴hleh¹ˉ⁴ canh⁴a² li⁴ñih¹ˉ³ henh⁴ si³lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Quie¹ a⁵sian⁴³ a³ne³ ti²hain⁴³ tionh² liah⁴i² co³hei²tsei³ ti²júanh³ˉ³, quie¹ a⁵sia³ ni¹ñi³⁴ ma³a⁴teg⁴ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Quie¹ i⁴ne³pa² ra⁵tei⁴³ jau²³ i⁴a⁴sag⁴ a³sain² quian¹ Jon⁴dai¹, Joel hain⁴, ra³juah⁴: ");
INSERT INTO cucNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Tei⁴³i² ma³o¹tieh⁴ jm², juah⁴ Jon⁴dai¹, cúa¹ˉ⁴ M⁴tyi⁴ quien⁴ i²con²³ la⁴jang³⁴; ma²jon³ hleh³ si³jonh³ˉ³, a³ñih³ a³m⁴, jau²³ quien⁴ˉ⁴; jian³ sia³ i⁴ma²jnia³²ˉ⁴ i²con²³ si³maih² ñih³ quianh³ˉ³ tionh²ˉ³, jian³ sia³ i⁴ma²jnia³²ˉ⁴ con⁴juah⁴ gui³sie⁴ i²con²³ a³don⁵ tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Quie¹ i⁴chie⁴³pa² cúa¹ˉ⁴ M⁴tyi⁴ quien⁴ jm² jon³ i²con²³ a³cúa²³ cúa³tag³² i²con²³ˉ⁵, a³ñih³ a³m⁴, jian³ hleh³i³ jau²³ quien⁴ˉ⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Júan¹ˉ⁴ ua³júah² ta⁵ñi⁴jeu⁵, jian³ júan¹ˉ⁴ ua³júah² cuah³²húa³⁴: tain³⁴ jm³yein⁴, hya³⁴ o¹jyi³ loh⁴³, canh⁴³ o¹ñi³² la⁴con³ o¹jnai⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jian³ liah⁴ hyie³, jian³ li⁴yein⁴ segh³ liah⁴i² jnia⁴ jm³yein⁴; lei⁴ la⁴ne³ naih⁵i² tyie¹ jm² i⁴jionh⁴ Se³ño²³, jm² júah³ i⁴lei³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","I² la⁴jang³⁴ a³teh² Se³ño²³ ne⁵, lion⁴ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Hnei³ tionh²ˉ³, chie³ Israel, nai³ hnei³ re³ jau²³ i⁴hleh¹ˉ⁴ la³: lei³ jnia⁴ i⁴a⁴sain⁴ Jon⁴dai¹, Jesús a³sian³ jeu³ Nazaret hain⁴, nei² quieh¹ la⁴jeg³⁴ nai² ua³júah² i⁴a⁴júan⁴ Jon⁴dai¹ jenh²ˉ³ tionh²ˉ³ con⁴juah⁴ hei⁴i³, liah⁴i² ma³ti²ñih¹ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","I² hei⁴i³ ne⁵, a⁴hei³⁴i³ joh⁴³ cúah³ˉ³ tionh²ˉ³ con⁴juah⁴ co³hei²tsei³ i⁴a⁴júan⁴ Jon⁴dai¹ liah⁴ma²ra⁴lie⁵, liah⁴i² heih⁴³ a⁴tonh³i³, jian³ a⁴sianh²ˉ³ a³hain⁴ jian³ a⁴jŋangh⁴³ˉ³, i⁴a⁴cúanh³²ˉ³ i²con²³ a³hlangh² tionh² a³a⁴tion⁴i³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","I² Jon⁴dai¹ ne⁵, a⁴júan⁴i³ i⁴a⁴hyon²³i³, con³ma²a⁴lion³i³ i²con²³ húan³⁴, quie¹ sa⁴haih¹ juah⁴ i⁴cagh¹ jm² húan³⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Quie¹ a⁴hleh⁴ Da³vei²³ nei² quieh¹i³ la⁴la³: La⁴jeg³⁴ jm² jen³²ˉ⁴ Se³ño²³ ta⁵nei³⁴ˉ⁴; i⁴jon³ a⁵sia³ jieh⁴ tsei³⁴ˉ⁴, quie¹ jian²³i³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","I⁴jon³ si³hyonh³ m⁴tyi⁴ quien⁴ˉ⁴, jian³ hleh² o¹segh³ˉ⁴ jau²³ i⁴si³hyonh³ˉ⁴. Jian³ quie⁴³ he³⁴ˉ⁴ la³ i⁴hain³² tsei³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Quie¹ sa⁴cúah²ˉ³ jian³⁴ m⁴tyi⁴ quien⁴ˉ⁴ I²tionh² A³jaun², jian³ a⁵ga⁴ cúah²ˉ³ i⁴hliah⁴ he³² a³cúanh¹ quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Quie¹ a⁴heh³²ˉ³ jnia⁴ jeu³ quieh¹ m⁵cu³ tsei²³, jian³ a⁴júanh²ˉ³ i⁴si³hyonh³ˉ⁴ hlion⁴ mai²³, nei² quieh¹ i⁴sainh⁴³ˉ³ hlonh²ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’I² jon³ ne⁵, hnei³ tionh²ˉ³, goh³ quian³⁴ˉ⁴, ti²nia²ˉ¹ la⁴jag³⁴ˉ¹ i⁴a⁴jaun³⁴ Da³vei²³, jmai³sie²³ˉ¹ hain⁴ a³sian³ ya⁴jo³⁴, jian³ a⁴hon³⁴i³, jian³ i²ra³hon³i³ jon³ ra³quia³ teg⁴ tieh²la³pa² jeu³ co³²ˉ¹ la³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Jian³ ma²lang⁴³i³ jan³ a³hleh² jau²³ quieh¹ Jon⁴dai¹, jian³ ra⁵ñi³i³ i⁴a⁴cúa⁴ Jon⁴dai¹ jau²³ ho³² i⁴hyon⁴³ jan³ jen² sa¹jeun³ quian¹i³ a³lain⁴ A³ya⁴lion³² Chie³, a³lain⁴ a³júan³ heih⁴³ liah⁴ ma²júan³ Da³vei²³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jian³ a⁴je³⁴ Da³vei²³ la⁴jeg³⁴ i⁴ne³ naih⁵i² lei⁴, i² la⁴jon³ a⁴hleh⁴i³ i⁴hyon⁴³ A³lion³ Chie³ hain⁴ jen² a³jaun², jian³ i⁴sa⁴jian³⁴ m⁴tyi⁴ quieh¹i³ I²tionh² A³jaun², jian³ a⁵ga⁴ hliah⁴ he³²i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","I⁴jon³ a⁴júan⁴ Jon⁴dai¹ i⁴a⁴hyon²³ Jesús ne³, jian³ a⁴teg⁴ nei² la⁴jag³⁴ jnie³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","I² la⁴ne³ jon³ a⁴júan⁴ Jon⁴dai¹ i⁴júanh⁴³i³ con⁴juah⁴ ua³pei⁴ quieh¹, jian³ a⁴cúa⁴ Jmai³i³ M⁴tyi⁴ quieh¹ i²con²³i³ liah⁴i² ma³a⁴cúa⁴i³ jau²³ ho³², jian³ la⁴jeg³⁴ i⁴jon³ ti²jeh⁴ˉ³ tieh²la³ jian³ ti²nauh³ˉ³, i⁴ja³⁴ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Quie¹ a⁵sian⁴³ Da³vei²³ ŋah³ ñi⁴jeu⁵; quie¹ hei⁴ pi²³ a⁴juah⁴i³: A⁴juah⁴ Se³ño²³ Jon⁴dai¹ i²con²³ Se³ño²³ quian³⁴ˉ⁴: “Nei⁴ hnei³ jo³² ta⁵chie³⁴ quien⁴ˉ⁴, ");
INSERT INTO cucNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","la⁴conh⁴i² júan³²ˉ⁴ i⁴cangh³²ˉ³ jm² i²con²³ la⁴jang³⁴ a³hie²³ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Jian³ ua²ti²ñih¹ hnei³ tionh²ˉ³, la⁴jangh³ˉ³, a³jeu³ Israel, i⁴a⁴júan⁴ Jon⁴dai¹ i⁴lang⁴³ Jesús hain⁴ Re¹ jian³ A³lion³ Chie³, a³hain⁴ a³a⁴tionh⁴³ˉ³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","I² con³ma²a⁴nau⁴i³ jau²³ jon³ tionh², ta² a⁴hei³⁴ queuh³ tsei⁴³i³, i² jon³ a⁴sagh⁴³i³ Pe³² jian³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, a⁴juah⁴i³ tionh²: ―Goh³ quian³⁴ˉ⁴, ¿henh⁴ hniah³ júan² jnie³²? ");
INSERT INTO cucNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","I² jon³ a⁴juah⁴ Pe³²: ―Hniah³ sagh² hnei³ co³hei²tsei³ quianh³ tionh²ˉ³, jian³ hniah³ sonh⁵ hnei³ jm³ con⁴jan³ hnei³ tionh²ˉ³, con⁴juah⁴ jm³i⁴sain³ Jesucristo, canh⁴a² hain³⁴i³ chie³² quianh³ˉ³; jian³ ma²jon³ hyeih²ˉ³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i⁴ta² tyieh⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Quie¹ tainh⁴³ hnei³pa² tionh²ˉ³ hyeih²ˉ³ i⁴ne³ liah⁴i² ma³a⁴cúa⁴i³ jau²³ ho³², jian³ tain⁴³ la⁴jang³⁴ a³tionh² i²gm⁴, la⁴conh⁴ a³quianh⁴³ Se³ño²³ Jon⁴dai¹ quian⁴ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jian³ hlion⁴ pi¹ jau²³ seg³⁴ a⁴hleh⁴ Pe³² i⁴jang³⁴ tsei⁴³, jian³ hain³liah⁴ hniah³ si⁵hei⁴i³ jeu³ tionh², a⁴juah⁴i³: ―Lion³² hnei³ tionh²ˉ³ jen² a³ti²júan³ i⁴hlagh³² a³tionh² m⁵cu³ la³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","I² la⁴ne³ jon³ a⁴son⁴ jm³ la⁴conh⁴ a³a⁴hyei⁴ jau²³ i⁴a⁴hleh⁴ Pe³², jian³ a⁴han⁵i³ jen² chie³ quian¹ Jon⁴dai¹ jm² jon³, jian³ tain⁴³ la⁴conh⁴ hneng³ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jian³ a⁴can³⁴i³ i⁴sa⁴teinh³ tsei⁴³i³ jau²³ i⁴he²³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ tionh²i³ i⁴quein⁴³ tsei⁴³i³ jian²³i³ a³jan³ jan³, jian³ ŋangh³i³ i⁴queuh³i³ a²hei⁴³ jian³ i⁴mh²i³ Jon⁴dai¹ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ta² jeun⁴³ chie³ ŋo³⁴ co³ tsei⁴³ nei² quieh¹ la⁴jeg³⁴ ua³júah² pain⁴ i⁴a⁴júan⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jian³ la⁴jang³⁴ a³ma³ra⁵hain⁴ hain⁴ con³pa² ti²ŋangh³i³, jian³ co³nai²pa² ra⁵quieh¹i³ la⁴jeg³⁴ i⁴ma²sia³ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jian³ a⁴hnang⁴i³ húa³⁴ quieh¹ tionh² jian³ la⁴jeg³⁴ i⁴ma²sia³ quieh¹i³, i⁴ma⁴hon³²i³ la⁴jang³⁴ a³ma²si³hain⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jian³ la⁴jang³⁴i³ la⁴jon³ si³han²i³ cuah³júah² i⁴tionh²i³ con³ co³hei²tsei³ i⁴sa⁴teinh³ tsei⁴³i³ conh⁴ con³ jm², jian³ jauh³² quieh¹ jon²reunh¹i³ liah⁴, ma²jeun²³i³ a²hei⁴³ñih¹ jian³ queuh³i³ si³hyonh³i³ jian³ i⁴ti⁴ñeih⁵ m⁴tyi⁴ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jian³ júan³i³ júanh⁴³ Jon⁴dai¹ liah⁴, i² la⁴jang³⁴ chie³ a³sang²³ ne⁵, hnio³⁴i³ a³hain⁴ tionh²; jian³ la⁴jeg³⁴ jm² júan³ Se³ño²³ i⁴li⁴jeun⁴³ cuah³ a³lion³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Con³ jm² ŋo³⁴ Pe³² jian²³ Juan²³ cuah³júah² tei⁴³ conh⁴ ni¹hneng³ ta⁵hlo⁴, o²ra³ tang²³ la⁴jang³⁴ i⁴si³mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jian³ la⁴jeg³⁴ jm² ma²si³jan³i³ jan³ a³ñih³ a³lo³ si¹tag³² liah⁴ma²ra⁵sian³, a³tyan⁴³i³ o²hnei³² cuah³ i⁴sain³ I⁴tsei³⁴ Jnia⁴, a³m²³ o¹cau³² i²con²³ la⁴jang³⁴ a³si³han² cuah³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","I² con³ma²a⁴je³ a³lo³ hain⁴ quieh¹ Pe³² jian²³ Juan²³ i⁴si⁵han² cuah³, jon³ a⁴m⁴i³ o¹cau³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","I² Pe³² jian²³ Juan²³ ne⁵, ta² tia⁴ a⁴jen³i³ a³hain⁴, a⁴juah⁴i³: ―Je³² hnei³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I² jon³ a⁴je³ a³lo³ hain⁴ quieh¹i³ tia⁴, lain⁴i³ i⁴hyei³⁴i³ o¹cau³² i⁴cúa³⁴ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","I² Pe³² ne⁵, a⁴juah⁴i³: ―I¹con³ o¹cau³² sa⁴quian³²ˉ⁴, a⁵ga⁴ o¹cau³² tie³ jian³ a⁵ga⁴ o¹cau³²nie¹, i² i⁴quian³²ˉ⁴ ma²hon³²ˉ⁴ hnei³: no³ hnei³ con⁴juah⁴ ua³pei⁴ quieh¹ jm³i⁴sain³ Jesucristo a³sian³ jeu³ Nazaret hain⁴, jian³ ŋeng² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","I² jon³ a⁴tang⁴ Pe³² si¹cúa³i³ jo³² ta⁵chie³⁴, a⁴sie⁴³i³, i² liah⁴ma²jon³ a⁴lag³⁴ si¹tag³² a³lo³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","A⁴no³i³, a⁴hang⁴i³ ta⁵yeih³², jian³ a⁴ŋeng⁴i³. I² con³ma²a⁴han⁵i³ cuah³ tionh², jon³ ya¹ŋeng²³ a³ma²lo³ hain⁴ jian³ hang³i³ ta⁵yeih³², jian³ júan³i³ júanh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","I² jon³ a⁴je³ la⁴jang³⁴ a³jeu³ i⁴ŋeng²³ a³hain⁴ jian³ i⁴júan³i³ júanh⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jian³ ra⁵cu²³i³, i⁴a³hain⁴pa² ma²cua²³ o²hnei³² cuah³, i⁴teh²i³ Tsei³⁴ Jnia⁴ jon³ a³ma²m²³ o¹cau³², i² jon³ ta² co³ ŋo³⁴ tsei⁴³i³ tionh² jian³ joh³ tsei⁴³i³ nei² quieh¹ i⁴a⁴leg³⁴ la⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I² a³lo³ a³a⁴huan⁴ quieh¹ hain⁴ ya¹ton³i³ hlonh² Pe³² jian²³ Juan²³, jian³ la⁴jang³⁴ a³jeu³ ta² co³ ŋo³⁴ tsei⁴³, jon³ a⁴ŋangh³i³ jeu³ra³tyi⁴ i²con²³ li⁵on³i³ tionh² ho³²quie³ i⁴sain³ quieh¹ Salomón cuah³júah² jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","I² con³ma²a⁴je³⁴ Pe³² i⁴si³lei⁴ jon³, jon³ a⁴sagh⁴³i³ a³jeu³, a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ sa¹jeun³ Israel, ¿e⁴le³⁴ eu⁴³ co³ ŋo³⁴ hoh⁴³ˉ³ i⁴a⁴leg³⁴ la³? ¿Jian³ e⁴le³⁴ jeh⁵ˉ³ jnie³² la⁴con³ i⁴a⁴júan² jnie³² húan⁴ i⁴a⁴ŋeng⁴ a³la³, jian³ lainh⁴ˉ³ con⁴juah⁴ ua³pei⁴ quian⁴ jnie³², jian³ con⁴juah⁴ i⁴ni²tain⁴³ jnie³²? ");
INSERT INTO cucNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Quie¹ Jon⁴dai¹ hña³pa² a⁴júan⁴ i⁴júanh⁴³ Jesús A³jon⁴³i³ i⁴a⁴leg³⁴ i⁴ne³, a³hain⁴ a³ma⁴con⁴³ A³brang²³, I³sa²³, jian³ Ja³co²³, Jon⁴dai¹ a³ma⁴con⁴³ la⁴jang³⁴ jmai³sie²³ˉ¹. I² hnei³ tionh²ˉ³ ne⁵, a⁴cúanh³²ˉ³ Jesús hain⁴ jian³ sa⁴ra⁵hnoh⁴³ˉ³ ta⁵nei² Pilato, con³ma²i²lion⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jian³ sa⁴ra⁵hnoh⁴³ˉ³ tionh²ˉ³ a³hain⁴ A³hen², A³tsein²³, quie¹ a⁴mh²ˉ³ i⁴lion⁴ jan³ a³jŋangh² chie³, ");
INSERT INTO cucNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","jian³ a⁴jŋangh⁴³ˉ³ a³hain⁴ A³cúa²³ m⁵cu³, a³hain⁴ a³a⁴júan⁴ Jon⁴dai¹ i⁴a⁴hyon²³i³ jen² a³jaun²; jian³ jnie³²pa² a⁴teg⁴ nei² i⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Quie¹ i⁴hain⁴ jnie³² i²con²³ Jesús pa² a⁴júan⁴ i⁴a⁴lang³⁴ a³ñih³ la³ a³ti²jenh⁵ˉ³ jian³ ti²cmh⁴³ˉ³, jian³ con⁴juah⁴ i⁴hain⁴ jnie³² i²con²³i³ ma³a⁴lang³⁴ a³la³ o³tan², liah⁴i² ti²jenh⁵i³ hnei³ la⁴jangh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’I² tieh²la³ ne⁵, goh³ quian³⁴ˉ⁴, yan³²ˉ⁴ i⁴a⁴júanh²ˉ³ la⁴jeg³⁴ i⁴ne³ i⁴sa⁴ñih¹ˉ³ tionh²ˉ³, jian³ a⁵ga⁴ si³ta¹ quianh³ˉ³ ñi³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","I² Jon⁴dai¹ ne⁵, a⁴júan⁴i³ i⁴ra⁵tei⁴³ la⁴jeg³⁴ jau²³ i⁴a⁴hleh⁴i³ con⁴juah⁴ la⁴jang³⁴ a³sain² quian¹i³, i⁴ra⁵hniah³ can³⁴ a³hain⁴ ma²eu⁴³ A³ua⁵lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","I² jon³ ne⁵, sag¹ hnei³ co³hei²tsei³ quianh³ jian³ jainh¹ hnei³ mah² jeu³ hlagh³² tionh²ˉ³, canh⁴a² jlenh⁴³ chie³² quianh³ˉ³; jian³ canh⁴a² sain³⁴ Jon⁴dai¹ jm² i⁴lai⁴³ hoh⁴³ˉ³ tionh²ˉ³, ");
INSERT INTO cucNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","jian³ sainh³i³ Jesucristo, a³hain⁴ a³a⁴hen⁴³i³ i²conh²ˉ³ liah⁴ma²jia⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Quie¹ i⁴chie⁴³pa² hniah³ cua³⁴i³ ñi⁴jeu⁵ ñeih³²jia⁴³ la⁴conh⁴i² tyie¹ jm² i⁴lai⁴³ m⁵cu³, liah⁴i² ma³a⁴hleh⁴ Jon⁴dai¹ con⁴juah⁴ la⁴jang³⁴ a³sain² tsein²³ quian¹, a³ma²sian³ ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Quie¹ a⁴juah⁴ M³se²³ i²con²³ jmai³sie²³ˉ¹: “Quie¹ júan³⁴ Se³ño²³ Jon⁴dai¹ i⁴hyon⁴³ jan³ jen² sa¹jeun³ quianh³ˉ³, liah⁴i² a⁴sai⁴i³ jnia⁴ a³hleh³ jau²³ quieh¹i³, jian³ la⁴jeg³⁴ jau²³ i⁴hleh³ a³hain⁴ i²conh²ˉ³ hniah³ nauh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","quie¹ la⁴jang³⁴ a³sa⁴ro³ jeu³ jau²³ quieh¹ a³sain² hain⁴, hniah³ si⁵hain⁴i³ i⁴so⁵sian³i³ jen² a³jeu³ quian¹ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Jian³ la⁴jang³⁴ a³sain² quian¹ Jon⁴dai¹, liah⁴ma²ra⁴lie⁵ Samuel jian³ a³a⁵han² coh⁵ jon³, a⁴hleh⁴i³ nei² quieh¹ jm² la³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jian³ la⁴jeg³⁴ jau²³ ho³² Jon⁴dai¹ i⁴a⁴cúa⁴i³ con⁴juah⁴ la⁴jang³⁴ a³sain² quian¹i³ tainh⁴³ hnei³pa² tionh²ˉ³, jian³ tainh⁴³ hnei³pa² liah⁴ jau²³ i⁴a⁴júan⁴ Jon⁴dai¹ re³ i²con²³ jmai³sie²³ˉ¹ jon³, con³ma²a⁴sagh⁴³i³ A³brang²³, i⁴a⁴juah⁴i³: “Con⁴juah⁴ jan³ jeun³ quianh³ˉ³ tsei³⁴ jm² li⁴ren³ la⁴jang³⁴ a³tionh² nei² cuah³²húa³⁴ la³.” ");
INSERT INTO cucNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jian³ con³ma²a⁴júan⁴ Jon⁴dai¹ i⁴a⁴hyon²³ A³jon⁴³, jon³ a⁴sain⁴i³ co⁴ra⁴lie⁵ i²conh²ˉ³, canh⁴a² júan³⁴i³ i⁴tsei³⁴ i²conh²ˉ³ tionh²ˉ³, jian³ canh⁴a² teih³²ˉ³ con⁴jan³ hnei³ i⁴júanh³ˉ³ i⁴hlagh³². ");
INSERT INTO cucNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ma²si²hleh² pi¹ Pe³² jian²³ Juan²³ i²con²³ a³jeu³, con³ a⁴la³ a⁵han² m³chie³, jian³ jeu³² a²hlie⁴ a³hie³ cuah³júah², jian³ chie³ saduceo tionh², ");
INSERT INTO cucNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","i⁴eu⁴³ jain²³ tsei⁴³i³, quie¹ ti²heh²i³ a³jeu³, jian³ quie¹ ti²hleh²i³ i⁴hyon⁴³ a³jaun² liah⁴i² a⁴hyon²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","I² jon³ a⁴sonh³i³ jian³ a⁴ron⁴³i³ ni⁴ñi²³ liah⁴i² a⁴jnia³⁴, quie¹ ta⁵la⁴ a⁴hlo⁴ ma²jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Quie¹ jeun⁴³ a³ma²tionh² jen² la⁴jang³⁴ a³a⁴nau⁴ jau²³ quieh¹ Jon⁴dai¹ hain⁴, ra⁵hain⁴i³; jian³ la⁴conh⁴ la⁴jang³⁴ jmah³ a³ñih³ a⁴teg⁴ la⁴conh⁴ hña⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","I² con³ma²a⁴jnia³⁴, jon³ a⁴ŋangh³ la⁴jang³⁴ si³ta¹ je¹jeu³ Jerusalén jon³, a³don⁵ ma⁴³teg²³ jian³ a²teg²³ quian¹ lai²³, ");
INSERT INTO cucNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","jian³ Anás jeu³² m³chie³ tyein², jian³ Caifás, jian³ A²juan²³ jian³ A²ja³², jian³ la⁴jang³⁴ a³tei⁴³ jau²³ quian¹ jeu³² m³chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","I² jon³ a⁴sainh⁴i³ Pe³² jian²³ Juan²³ to⁵chieh³² jen²i³ tionh², a⁴ŋangh³i³, a⁴juah⁴i³: ―¿Hain³ a⁴cúa⁴ heih⁴³ i⁴a⁴júanh²ˉ³ ua³júah² ne³, jian³ o⁴ hain³ a⁴cúa⁴ ua³pei⁴? ");
INSERT INTO cucNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","I² Pe³² ne⁵, quian³i³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, a⁴juah⁴i³: ―Hnei³ si³ta¹ tionh², jian³ a³don⁵ ma⁴³teg²³ quian¹ a³jeu³ Israel: ");
INSERT INTO cucNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tieh²la³ ti²ŋangh⁵ˉ³ jnie³² nei² quieh¹ con³ i⁴tsei³⁴ i⁴a⁴leg³⁴ i²con²³ jan³ a³ñih³ a³ma²lo³, liah⁴ a⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Hniah³ li⁴ñih¹ˉ³ la⁴jangh³ˉ³ tionh²ˉ³, jian³ hniah³ li⁴ñi³ la⁴jang³⁴ a³jeu³ Israel, i⁴a⁴huan⁴ quieh¹ a³ñih³ si²sainh⁴³ ta⁵mah²ˉ³ ne³ con⁴juah⁴ ua³pei⁴ quieh¹ jm³i⁴sain³ Jesucristo a³sian³ jeu³ Nazaret, a³hain⁴ a³a⁴júan⁴ Jon⁴dai¹ i⁴a⁴hyon²³ jen² a³jaun², a³a⁴tionh⁴³ˉ³ crau¹ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús hain⁴ lang⁴³ liah⁴i² leg⁴³ con³ a²caun² i⁴a⁴ton³⁴ teg³hyah³ tionh²; i² coh⁵ jon³ ne⁵, a²caun² jon³pa² re³ a⁴seih³ ta³jmh¹ a²hnei⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Quie¹ con⁴juah⁴ jan³ a³hain⁴pa² lion⁴ chie³; jian³ a⁵sian⁴³ a³sang²³ ma⁵sian³ m⁵cu³ la³ a³li⁴lie⁴³ˉ¹, jan³ hain⁴pa² a⁴cúan⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","I² con³ma²a⁴je³⁴ si³ta¹ tionh², i⁴sa⁴jieh⁴ tsei⁴³ Pe³² jian³ Juan²³, jian³ i⁴sa⁴ŋang⁴i³ hlion⁴ jyi³, jian³ quie¹ lang⁴³i³ chie³ta²chie³ liah⁴, i⁴jon³ ta² co³ ŋo³⁴ tsei⁴³i³; jian³ ra⁵cu²³i³ tionh² i⁴ma²ŋeng²³ a³hain⁴ jian²³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jian³ quie¹ i⁴si²sainh⁴³ a³ñih³ a³a⁴huan⁴ quieh¹ hain⁴ jian²³ Pe³² jian²³ Juan²³, i⁴jon³ i¹con³ sa⁴tag³ i⁴li⁴hleh³i³ hlagh³² nei² jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","I² jon³ a⁴júan⁴i³ heih⁴³ i⁴húan⁵i³ co⁴le⁴ tionh² nei²ta¹, ta¹la⁴ a⁴júanh⁴i³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","a⁴juah⁴i³: ―¿Liah⁴ júan³²ˉ¹ i²con²³ a³ne³ tionh²? Jian³ ti²ñi³ la⁴jang³⁴ a³tionh² Jerusalén liah⁴, i² jnia¹ ne⁵, sa⁴li⁴juah²ˉ¹ juah⁴ i⁴sa⁴chie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","I² jon³ ne⁵, canh⁴a² sa⁴ta⁵tsei¹ hlion⁴ jau²³ jen² a³jeu³, saih³²i³ jnia¹ i⁴júanh³²i³ jnia¹ a¹juah⁴ne³ hlenh⁵i³ chie³ con⁴juah⁴ jm³i⁴sain³ Jesús ta⁵i²chie³⁴ la³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","I² jon³ a⁴teh³i³ a³hain⁴ ta⁵jauh³² liah⁴, jian³ a⁴júan⁴i³ heih⁴³ i²con²³i³ i⁴so⁵hleh³i³ o³tan², jian³ a⁵ga⁴ ma⁵heh³i³ chie³ con⁴juah⁴ jm³i⁴sain³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","I² a⁴ŋangh³ Pe³² jian²³ Juan²³ ne⁵, a⁴juah⁴i³: ―Júan² hnei³ con³ co³hei²tsei³ tionh²ˉ³ henh⁴ tyein² tsei³⁴ júan² jnie³² ta⁵nei² Jon⁴dai¹, o⁴ hniah³ ro² jnie³² jeu³ jau²³ quianh³ˉ³, jian³ o⁴ jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Quie¹ sa⁴tian³² jnie³² juah⁴ i⁴so⁵hleh² jnie³² la⁴jeg³⁴ i⁴ma³a⁴niah¹ jnie³² jian³ la⁴jeg³⁴ i⁴ma³a⁴nai² jnie³² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jian³ a⁴juah⁴ si³ta¹ i⁴júanh¹i³ a³hain⁴ tionh² nei² jon³, ma²jon³ a⁴lion³i³, jian³ quie¹ ta⁵la⁴ con⁴³i³ a³jeu³, quie¹ la⁴jang³⁴pa² a⁴júan⁴ júanh⁴³ Jon⁴dai¹ nei² quieh¹ i⁴a⁴leg³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Quie¹ a³ñih³ a³a⁴leg³⁴ ua³júah² i⁴a⁴huan⁴ quieh¹ hain⁴, hein² leg⁴³ to⁴lo⁵ ñi³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","I² con³ma²a⁴lon⁴i³ tionh², jon³ a⁴tyanh³i³ i²tionh² si³reunh¹i³, i² jon³ a⁴tya⁴i³ la⁴jeg³⁴ jau²³ i⁴a⁴juah⁴ m³chie³ tyein², jian²³ a³don⁵ ma⁴³teg²³ hain⁴ tionh² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","I² con³ma²a⁴nau⁴ la⁴jang³⁴ si³reunh¹i³ jau²³ jon³, jon³ a⁴mh³i³ Jon⁴dai¹ con³ jau²³ co⁴chia³ la⁴jang³⁴i³, a⁴juah⁴i³: ―Hnei³ Se³ño²³ Jon⁴dai¹, jan³ hnei³pa² tyein² júanh⁴³, quie¹ hnei³pa² a⁴júanh² ñi⁴jeu⁵ jian³ cuah³²húa³⁴ jian³ jm³ñih¹ jian³ la⁴jeg³⁴ i⁴sia³ jian³ la⁴jang³⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jian³ con⁴juah⁴ jau²³ i⁴a⁴hleh⁴ Da³vei²³ a³a⁴cúa⁴ cúa³tag³² hain⁴ i²conh²ˉ³, a⁴juah¹ˉ³: ¿Henh⁴le³⁴ ra⁴hang³² a³tionh² la⁴jeg³⁴ nación, jian³ e⁴le³⁴ a⁴júan⁴ la⁴jang³⁴ jeu³ co³hei²tsei³ sa⁴quein⁴³? ");
INSERT INTO cucNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Quie¹ a⁴ŋangh³ re¹ quian¹ a³tionh² cuah³²húa³⁴ la³, jian³ a⁴ŋangh³ si³ta¹ liah⁴, a⁴ŋangh³i³ i⁴a⁴júan⁴i³ hlagh³² i²con²³ Jon⁴dai¹, jian³ i²con²³ A³ya⁴lion³² Chie³ a³a⁴sain⁴i³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Quie¹ i⁴chie⁴³ a⁴ŋangh³ a³jeu³ je¹jeu³ la³, re¹ Herodes jian³ Poncio Pilato, jian³ a³jeu³ Israel jian³ chie³ sang²³ liah⁴, i⁴a⁴júan⁴i³ hlagh³² i²con²³ Jesús A³jonh³ˉ³, a³tsein²³ hain⁴ a³ma⁴cúanh¹ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A⁴ŋangh³i³ la⁴ne³ i⁴ma⁴tei⁵i³ la⁴conh⁴ heih⁴³ ma³a⁴tienh³ˉ³ liah⁴ma²jia⁴³ con⁴juah⁴ ua³pei⁴ quianh³ˉ³, i⁴hniah³ si⁵lei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","I² tieh²la³ ne⁵, hnei³ Se³ño²³, je¹ hnei³ i⁴m³tsainh²i³, m²³ jnie³² i⁴ma²honh³²ˉ³ chie³ quianh³ i⁴hleh² jnie³² jau²³ quianh³ˉ³ i⁴sa⁴jieh⁴ tsei⁴³ jnie³² i⁴lang⁴³ jnie³² a³cúa²³ cúa³tag³² i²conh²ˉ³; ");
INSERT INTO cucNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","jian³ ta¹la⁴ jon³ júanh²ˉ³ i⁴huan⁴ quieh¹ a³chieh¹ i⁴teih³²ˉ³ si¹cúah³, jian³ ua³júah² seg³⁴ liah⁴, i⁴con⁴juah⁴ jm³i⁴sain³ Jesús A³jonh³ˉ³ a³ma⁴cúanh¹ˉ³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","I² con³ma²a⁴toh⁴ a⁴mh³i³ Jon⁴dai¹, jon³ a⁴jaih³ i²ti²tionh²i³ i⁴ti²ŋangh³i³; jian³ a⁴hyei⁴i³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, jian³ a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ i⁴sa⁴jieh⁴ tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jian³ la⁴conh⁴ la⁴jang³⁴ a³ma³ra⁵hain⁴ hain⁴, tionh²i³ con³ co³hei²tsei³, i⁴con³ quein⁴³ tsei⁴³i³. I⁴jon³ i¹jan³ a⁵sie⁴³ juah⁴ juah⁴ i⁴quieh¹i³ hña³ i⁴ma²sia³ quieh¹i³, quie¹ co³nai²pa² ra⁵quieh¹i³ la⁴jang³⁴i³ la⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jian³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, a⁴hleh⁴i³ con⁴juah⁴ hlion⁴ ua³pei⁴ i⁴quian³i³ i⁴a⁴hyon²³ Re¹ Jesús, jian³ hlion⁴ ma⁴jnia³² Jon⁴dai¹ i⁴tsei³⁴ tsei⁴³ i²con²³i³ la⁴jang³⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","I² la⁴ne³ jon³, i¹jan³ a⁵sion⁴³ a³ma⁵so⁵si³hain⁴ quieh¹ jen²i³ tionh², quie¹ la⁴jang³⁴ a³ma²ra³ha¹ húa³⁴ quieh¹ jian³ o⁴ a²hnei⁴³, a⁴hnang⁴i³; i² o¹cau³² jon³ ni²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a⁴cúah³i³ i²con²³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, ma²jon³ a⁴tyieh⁵i³ i²con²³ con⁴jan³ la⁴conh⁴ a³hniah³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jian³ la⁴ne³ a⁴júan⁴ Se¹, sa¹jeun³ Leví, a³sian³ o⁵tyieh⁴³ Chipre; jian³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, a⁴teh³i³ Be²³, hnie³⁴ ra³juah⁴, A³júanh² Tsei⁴³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Quie¹ ma²ra³quia³ con³ húa³⁴ quieh¹i³, a⁴hnang⁴i³ jian³ ni²con²³i³ o¹cau³² jon³, a⁴cúah³i³ i²con²³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jian³ ma²sian³ jan³ a³ñih³ a³sain³ Ananías jian²³ A¹sa³fi²ra³ a³m⁴ quian¹, jon³ a⁴hnang⁴i³ con³ húa³⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jian³ a⁴hma⁴i³ co⁴meih³ o¹cau³² jon³ jian²³i³ a³don⁵ quian¹, jian³ ua⁵con²³i³ co⁴meih³ i⁴a⁴cúah³i³ i²con²³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","I² jon³ a⁴juah⁴ Pe³²: ―Hnei³ Ananías, ¿e⁴le³⁴ a⁴hei³⁴ a³sa⁴tsein³⁴ naih⁵ ni²hoh⁴³ˉ³ i⁴ma⁵canh²ˉ³ M⁴tyi⁴ quieh¹ Jon⁴dai¹, i⁴a⁴hmah²ˉ³ co⁴meih³ o¹cau³² i⁴a⁴cang⁴ húa³⁴ jon³? ");
INSERT INTO cucNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Quie¹ húa³⁴ ma²ra³quia³ jon³, ¿o⁴ a⁵jon⁴³ i⁴ma²quianh³ˉ³, juah²? Jian³ con³ma²ua⁵hnang², ¿o⁴ a⁵jon⁴³ i⁴ma²quianh³ˉ³ o¹cau³², lainh⁴ˉ³? ¿Henh⁴le³⁴ co³hei²tsei³ hlagh³² ne³ a⁴júanh²ˉ³? Quie¹ a⁵jon⁴³ i²con²³ chie³ a⁴hleh²ˉ³ jau²ta³jau²³, i²con²³ Jon⁴dai¹pa² a⁴hleh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","I² con³ma²a⁴nau⁴ Ananías jau²³ jon³, jon³ a⁴cangh³i³ a⁴jaun³⁴i³. I⁴jon³ ta² ra⁵coh⁴³ la⁴jang³⁴ a³ra⁵ñi³ jau²³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","I² jon³ a⁵han² si³maih² ñih³, a⁴lion³i³ a³jaun² hain⁴ a²hmh³, jon³ a⁴te¹i³, ni²hon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","I² con³ma²ua⁴jeu³² la⁴conh⁴ hneng³ o²ra³, jon³ a⁴tyie³⁴ a³m⁴ quian¹i³, i¹leuh² sa⁴ñi³i³ henh⁴ si³lei⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","I⁴jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Hno⁵ˉ⁵ jeuh³²ˉ³ jnia⁴, ¿o⁴ conh⁴ la³ hmah¹ i⁴a⁴hnangh¹ˉ³ húa³⁴ jon³? I² a⁴juah⁴ hei⁴i³: ―Jen³⁴, co⁴ne³pa². ");
INSERT INTO cucNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","I² jon³ a⁴juah⁴ Pe³² liah⁴: ―¿E⁴le³⁴ con³ co³hei²tsei³ la⁴hanh⁵ˉ³ i⁴a⁴quienh²ˉ³ jau²chie⁴³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ tionh²ˉ³? Jeh³² ma³cúan²³ la⁴jang³⁴ a³ni²hon⁴³ i⁴cúah³ˉ³, jian³ te⁴³i³ hnei³ liah⁴ tionh² si⁵hon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Con³ a⁴la³ a⁴cangh³ a³m⁴ hain⁴ ta⁵nei² Pe³², a⁴jaun³⁴i³. I² con³ma²a⁴han⁵ si³maih² hain⁴ ta⁵jauh³², jon³ a⁴jen³i³ a³m⁴ hain⁴ ma³ra³jaun², ma²jon³ a⁴te¹i³ ni²hon⁴³i³ co⁴chia³ jian²³ i³cúa³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jian³ ta² ra⁵coh⁴³ la⁴jang³⁴ cuah³, jian³ la⁴jang³⁴ a³sang²³, con³ma²ra⁵ñi³i³ nei² jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jian³ ta² hlion⁴ ua³júah² i⁴co³ jnia⁴ a⁴júan⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo tionh² jen² a³jeu³; jian³ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹, tionh² con³ co³hei²tsei³ ti²ŋangh³i³ ho³²quie³ quieh¹ Salomón jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","I² la⁴jang³⁴ chie³ sang²³ ne⁵, sa⁴tia⁴ tsei⁴³i³ i⁴ma⁵reunh¹i³ a³hain⁴ tionh² i²jon³; i² la⁴jang³⁴ a³jeu³ ne⁵, ton³²nie⁴³ hleh²i³ re³ nei² quieh¹ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jian³ ta² ma³si³li⁴jeun⁴³ chie³ a³li⁴hain⁴ i²con²³ Se³ño²³, a³ñih³ jian³ a³m⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","I⁴jon³ a⁴húan⁴³i³ a³chieh¹ quian¹, a⁴quion³i³ jeu³júan²³, a³ra³han² nei² jain³² jian³ joh⁴³ a²hyei²³ liah⁴, canh⁴a² tangh³i³ leuh² heinh² quieh¹ Pe³² pi²³i³, tei⁴³i² ua⁵jeun³²i³, i⁴huan⁴ quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jian³ jeun⁴³ a³tionh² jeu³ la⁴con³ hloh³² Jerusalén jon³, ua⁵jan³i³ a³chieh¹ quian¹, jian³ a³ti²can²³ ma²eu⁴³ con⁴juah⁴ m⁴tyi⁴ hlagh³²; jian³ la⁴jang³⁴pa² a⁴huan⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","I² jon³ ne⁵, ra⁴hang³² jeu³² m³chie³ tyein² jian²³i³ la⁴jang³⁴ a³jian²³i³, hnie³⁴ ra³juah⁴, a³tionh² jo³² quieh¹ saduceo, ta² a⁴jain³⁴ tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","I⁴jon³ a⁴sanh³i³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a⁴ron⁴³i³ ni⁴ñi²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","I² jon³ a⁴tyie³⁴ jan³ ángel quian¹ Se³ño²³ je¹nai³ jon³, a⁴nia³⁴i³ o²hnei³² ni⁴ñi²³ jon³, a⁴húan⁴³i³ a³hain⁴ tionh², a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Cua³, tyieh⁴ˉ³ yi⁴noh³ˉ³ cuah³júah², yi⁴hleh²ˉ³ i²con²³ a³jeu³ la⁴jeg³⁴ jau²³ tsei²³ la³ i⁴quieh¹ m⁵cu³ hm²³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I² con³ma²a⁴nau⁴i³ jau²³ jon³ tionh², jon³ ua⁵han²i³ cuah³júah² to⁵hie³ hion²³, jian³ a⁴heh³i³ chie³ tionh². Jian³ ta¹la⁴ ma²ti²he²³i³ jon³, jon³ a⁵han² jeu³² m³chie³ tyein² jian²³i³ la⁴jang³⁴ a³ma²jian²³i³, a⁴júan⁴i³ heih⁴³ i⁴ŋangh⁴³ la⁴jang³⁴ si³ta¹ jian³ la⁴jang³⁴ a³don⁵ ma⁴³teg²³ quian¹ a³jeu³ Israel, i² jon³ a⁴sain⁴i³ po³li³sei¹ a³ua⁵húan⁴³ a³chion³² tionh² ni⁴ñi²³, i⁴ma⁵jnia³²i³ ta⁵nei²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","I² con³ma²a⁴tyie³⁴ po³li³sei¹ ni⁴ñi²³ tionh², i¹jan³ a³hain⁴ tionh² so⁵sian³; i² jon³ ŋah³i³ ua⁵con²³i³ jau²³, ");
INSERT INTO cucNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","a⁴juah⁴i³: ―Jeh³², re³pa² si²jnang¹ o²hnei³² ni⁴ñi²³ a⁴niah¹ jnie³², jian³ re³pa² ti²hie³ a²hlie⁴ o²hnei³² liah⁴; i² con³ma²a⁴nia² jnie³² o²hnei³² ne⁵, a⁵sion⁴³ a³sian³ i¹jan³ jauh³². ");
INSERT INTO cucNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","I² con³ma²a⁴nau⁴ la⁴jang³⁴ a³hain⁴ tionh² jau²³ jon³, jeu³² m³chie³ tyein², jian³ jeu³² a²hlie⁴ a³hie³ cuah³júah², jian³ la⁴jang³⁴ m³chie³ tyein², jon³ so⁵ñi³i³ liah⁴ lei⁴ jainh¹ tyie¹ la⁴jeg³⁴ i⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","I² jon³ a⁴tyie³⁴ jan³, a³quian³ jau²³ la³: ―Jeh³², a³ñih³ a³ma²a⁴ronh³²ˉ³ ni⁴ñi²³ hain⁴ tionh², ti²tionh² cuah³júah² ti²heh²i³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jon³ ŋo³⁴ jeu³² a²hlie⁴ jian²³ po³li³sei¹ tionh², ni²quian⁴i³ a³hain⁴ tionh² i⁴sa⁴júanh¹i³, quie¹ con⁴³i³ a³jeu³, con³na¹a⁴quih⁴i³ m⁴caun², lain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","I² con³ma²ma³jian³i³, jon³ ma⁴jnia³²i³ ta⁵nei² si³ta¹ a³ti²ŋangh³ hain⁴ tionh², i² jon³ a⁴ŋang⁴ jeu³² m³chie³ tyein², ");
INSERT INTO cucNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","a⁴juah⁴i³: ―¿O⁴ a⁵sia³ a⁴júan² jnie³² i²conh²ˉ³ heih⁴³ pain⁴ la³ i⁴so⁵heh²ˉ³ con⁴juah⁴ jm³i⁴sain³ ne³, liah²? Jeh³², ma³a⁴janh⁴³ˉ³ la⁴tan² je¹jeu³ Jerusalén la³ jau²³ ne³ quianh³ˉ³ tionh²ˉ³, jian³ hnoh³ˉ³ cúah³²ˉ³ jnie³² chie³² jm³yein⁴ quieh¹ a³ñih³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","I² jon³ a⁴ŋangh³ Pe³² jian²³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, a⁴juah⁴i³: ―Quie¹ hniah³ ron³² jnie³² jeu³ Jon⁴dai¹ ñeih³²jia⁴³ la⁴conh⁴a² chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Quie¹ Jon⁴dai¹ quian¹ jmai³sie²³ˉ¹ a⁴júan⁴ i⁴a⁴hyon²³ Jesús hain⁴, a³hain⁴ a³a⁴jŋangh⁴³ˉ³ tionh²ˉ³, a³a⁴tionh⁴³ˉ³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","I² Jon⁴dai¹ ne⁵, a⁴júan⁴i³ i⁴júanh⁴³ a³hain⁴ con⁴juah⁴ ua³pei⁴ quieh¹i³, i⁴lang⁴³i³ A³tyein² jian³ A³lion³ chie³; jian³ la⁴ne³ a⁴cúa⁴i³ jm² i⁴sag³⁴ a³jeu³ Israel co³hei²tsei³ quieh¹ jian³ i⁴hain³⁴ Jon⁴dai¹ chie³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jian³ hleh³ jnie³² nei² quieh¹ la⁴jeg³⁴ i⁴ne³, jian³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ liah⁴ he²³ jnie³² nei² ne³, i⁴cúa²³ Jon⁴dai¹ i²con²³ a³ma³tei⁵ i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","I² con³ma²a⁴nau⁴ si³ta¹ hain⁴ tionh² jau²³ jon³, ta² a⁴jain³⁴ tsei⁴³i³ hlion⁴ mai²³, hnie³⁴i³ jŋangh³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","I² jon³ a⁴no³ jan³ fariseo jen² si³ta¹ hain⁴, a³sain³ Gamaliel, lang⁴³ jan³ a²teg²³ quian¹ lai²³, a³ma³co⁴³ la⁴jang³⁴ a³jeu³ quieh¹, a³a⁴júan⁴ heih⁴³ i⁴húan⁵ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo co⁴le⁴ i²tionh²i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ma²jon³ a⁴juah⁴i³: ―Hnei³ tionh²ˉ³, chie³ Israel, jianh³ˉ³ júan² hnei³ tionh²ˉ³ henh⁴ i⁴júanh²ˉ³ i²con²³ a³ñih³ ne³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Quie¹ naih⁵i² tyie¹ jm² la³ ra⁴hang³² Teudas hain⁴ a³a⁴júan⁴ i⁴tyein², jian³ a⁴jaih³i³ la⁴conh⁴ quin⁴ nia⁴lon⁴ chie³ a³si⁴tyein⁵ coh⁵cah³²i³. I² con³ma²a⁴jaun³⁴i³ ne⁵, ma⁵quein²³ so⁴jenh³pa² chie³ a³ma²ma³co⁴³ quieh¹i³, a⁴au³pa². ");
INSERT INTO cucNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jian³ coh⁵ jon³ liah⁴, ra⁴hang³² Judas a³sian³ Galilea hain⁴, con³ma²a⁴roh³ gobierno censo, a⁴jaih³i³ jeun⁴³ chie³ a³si⁴tyein⁵ coh⁵cah³²i³; ma²jon³ a⁴jaun³⁴i³, jian³ la⁴jang³⁴ a³ma²ma³co⁴³ quieh¹i³ liah⁴ ma⁵quein²³ so⁴jenh³ pi²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","I² tieh²la³ ne⁵, jeu³⁴ˉ⁴ hnei³ tionh²ˉ³, quein⁴³ hnei³ i²con²³i³ tionh², yo⁴o³ conh⁴³ hnei³. Quie¹ juah⁴ne³ i⁴hleh²i³ ne³ jian³ la⁴jeg³⁴ i⁴júan³i³ ne³ i⁴quieh¹ a³ñih³, ai³⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","I² juah⁴ne³ i⁴quieh¹ Jon⁴dai¹ ne⁵, sa⁴cangh³²ˉ³ jm² li⁴jeunh³²ˉ³; quie¹ con³na¹a⁴tangh⁴ˉ³ jianh²ˉ³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jon³ ra⁵hyon³ tsei⁴³ la⁴jang³⁴ si³ta¹ hain⁴ tionh² jau²³ jon³. Jon³ a⁴teh³i³ liah⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo; i² con³ma²a⁴pan³⁴i³, jon³ a⁴júan⁴i³ heih⁴³ i²con²³i³ i⁴so⁵hleh³i³ con⁴juah⁴ jm³i⁴sain³ Jesús, ma²jon³ a⁴lie³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I² jon³ a⁴húan³i³ nei²ta¹ jon³, jian³ ta² si³hyonh³i³ tionh², quie¹ i⁴haih¹ li⁴can³⁴i³ ma²eu⁴³ la⁴jeg³⁴ i⁴ua³hyeih² jnia⁴ jon³, nei² quieh¹ jm³i⁴sain³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jian³ la⁴jeg³⁴ jm² a⁴hleh⁴i³ jau²³ quieh¹ Jesucristo, cuah³júah² jian³ jauh³² quieh¹ chie³, liah⁴ sa⁴jian²³i³ a⁴heh³i³ chie³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Jian³ ta² ma³si³li⁴jeun⁴³ chie³ quian¹ Jon⁴dai¹ jm² jon³, i⁴jon³ a⁴si⁴he⁴³ chie³ a³hleh² jau²³ griego, a⁴si⁴hen⁴³i³ chie³ a³hleh² jau²³ hebreo, nei² quieh¹ i⁴sa⁴ron⁴³i³ jeu³ a³don⁵ m⁴ hnang⁴ a³co²³i³, con³ma²tyieh⁵i³ ma³⁴ conh⁴ con³ jm². ");
INSERT INTO cucNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","I² jon³ a⁴júan⁴ a³quia⁵teun⁴ hain⁴ heih⁴³ i⁴a⁴ŋangh³ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹, jon³ a⁴juah⁴i³: ―Ta² sa⁴re³ juah⁴ne³ tei³² jnie³² i⁴hleh³ jnie³² jau²³ quieh¹ Jon⁴dai¹ juah⁴ i⁴guenh³² jnie³² a³tionh² mesa. ");
INSERT INTO cucNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","I⁴jon³ ne⁵, goh³ quian³⁴ˉ⁴, hniah³ hnah³²ˉ³ quion³⁴ si³reunh⁴ˉ¹, jmah³ a³ñih³ jenh²ˉ³ tionh²ˉ³, a³hleh² la⁴jang³⁴ re³ nei² quieh¹, a³quian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, jian³ a³ŋang⁴ hlion⁴ liah⁴, a³hain⁴ a³cúah³² jnie³² ta¹ la³. ");
INSERT INTO cucNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","I² jnie³² ne⁵, sa⁴hniah³ tei³² jnie³² i⁴mh⁵ jnie³² Jon⁴dai¹ jian³ i⁴hleh³ jnie³² jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jon³ ra⁵hyon³ tsei⁴³ la⁴jang³⁴ jau²³ jon³, i² jon³ a⁴hnah³i³ Te⁴, a³ñih³ a³hain⁴ hlion⁴, jian³ a³quian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, jian³ a⁴hnah³i³ Lei³², jian³ Pro², jian³ Nicanor, jian³ Timón, jian³ Parmenas, jian³ O³lia²³ a³sian³ je¹jeu³ Antioquía, a³a⁴can³⁴ jeu³ quieh¹ judío con³ma²ma³don⁵i³. ");
INSERT INTO cucNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","I² jon³ ma⁴jnia³²i³ a³hain⁴ tionh² ta⁵nei² a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ ta¹la⁴ ti²mh²i³ Jon⁴dai¹, jon³ a⁴sanh³i³ ma³tyi² a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jian³ ta² si³cúan³ jau²³ quieh¹ Se³ño²³, jian³ tsei³⁴sa² jeun⁴³ chie³ quian¹ Jon⁴dai¹ ma³si³lei⁴ Jerusalén, jian³ jeun⁴³ m³chie³ ra⁵hain⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Jian³ Te⁴ hain⁴, ta² hlion⁴ ma⁴ho³² Jon⁴dai¹ quieh¹i³, jian³ ta² hlion⁴ ua³pei⁴ quian³i³ liah⁴, i⁴jon³ pain⁴ ua³júah² co³ jnia⁴ júan³i³ jen² a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","I⁴jon³ ra⁴hang³² co⁴meih³ a³quian¹ cuah³ judío i²teh²i³ a³lon² a³ma²júan³ quian¹ chie³, jian³ ra⁴hang³² a³sian³ jeu³ Cirene, jian³ a³sian³ jeu³ Alejandría liah⁴, jian³ a³sian³ húa³⁴ Cilicia, jian³ a³sian³ húa³⁴ Asia liah⁴, a³a⁴jang²³ jian²³ Te⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","I² sa⁴cagh¹i³ jm² la⁴conh⁴ tei⁴³ ŋang⁴ Te⁴, jian³ jau²³ i⁴hleh²i³ con⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jon³ a⁴cúa⁴i³ o¹cau³² i²con²³ co⁴meih³ chie³ canh⁴a² juah⁴i³ i⁴a⁴nau⁴i³ a⁴hleh⁴ Te⁴ jau²hlagh³² nei² quieh¹ M³se²³ jian³ nei² quieh¹ Jon⁴dai¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jon³ a⁴sion⁴³i³ a³jeu³, jian³ a³don⁵ ma⁴³teg²³, jian³ a²teg²³ quian¹ lai²³; jon³ ua⁵han²i³ jeu³ra³tyi⁴, a⁴sanh³i³ Te⁴, ua⁵jan³i³ ta⁵nei² si³ta¹ a³ti²ŋangh³. ");
INSERT INTO cucNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","I² jon³ a⁴teh³i³ a³a⁴hnang⁴³ jau²ta³jau²³ a³a⁴juah⁴: ―Jeh³², a³ñih³ ne³ hleh² jau²hlagh³² liah⁴o⁵jleg³⁴ nei² quieh¹ cuah³júah² hen² la³, jian³ nei² quieh¹ lai²³ quieh¹ M³se²³. ");
INSERT INTO cucNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Quie¹ a⁴nai² jnie³² i⁴a⁴juah⁴i³ i⁴jeun³⁴ A²seuh² a³sian³ jeu³ Nazaret hain⁴ cuah³ la³, jian³ i⁴sag³⁴i³ la⁴jeg³⁴ i⁴tang²³ quian⁴ˉ¹ i⁴ma²a⁴cúa⁴ M³se²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","I² la⁴jang³⁴ si³ta¹ a³ti²tionh² i²jon³, con³ma²a⁴jen³i³ Te⁴, jon³ a⁴je³⁴i³ ma³nei²i³ i⁴jnia⁴ liah⁴i² jnia⁴ ma³nei² jan³ ángel. ");
INSERT INTO cucNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I² jon³ a⁴ŋang⁴ jeu³² m³chie³ tyein², a⁴juah⁴i³: ―¿O⁴ i⁴chie⁴³ jau²³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","I² jon³ a⁴juah⁴ Te⁴: ―Nai³ hnei³ tionh²ˉ³ la⁴jangh³ˉ³, a³ñih³ jon³reunh³ˉ⁴, jian³ hnei³ tionh²ˉ³ se³ño²³, nai³ hnei³ jau²³ la³. Quie¹ ma⁴jnia³² Jon⁴dai¹ júanh⁴³ i²con²³ A³brang²³ jmai³sie²³ˉ¹ con³ma²cua⁴³i³ húa³⁴ Mesopotamia, naih⁵i² si⁵cua³i³ jeu³ Harán. ");
INSERT INTO cucNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","I² jon³ a⁴sagh⁴³i³: “Jau²³ hnei³ jeu³ coh³²ˉ³ la³ jian³ jen² la⁴jang³⁴ a³tei⁴³ jau²³ quianh³ˉ³, cua³ hnei³ la⁴teg⁴ con³ húa³⁴ i²ni¹he³⁴ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","I² jon³ ua⁵hag⁴³i³ jeu³ co²³ i²tionh² chie³ caldeo, jon³ ua⁵cua³i³ jeu³ Harán. I² con³ma²a⁴jaun³⁴ jmai³i³ i²jon³, ma²jon³ a⁴te¹ Jon⁴dai¹ quieh¹ A³brang²³ ta⁵húa³⁴ la³ i²tionh²ˉ³ tieh²la³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","I² ma²jon³ ne⁵, a⁵sia³ a⁴cúa⁴ Jon⁴dai¹ húa³⁴ la³ i²con²³i³, i¹conh⁴ i²quienh⁴ tag³²i³ sa⁴a⁴hyieh³i³; i² jon³ ne⁵, quie¹ a⁴cúa⁴i³ jau²³ ho³² ton³²nie⁴³ i⁴cúa³⁴i³ i²con²³i³, jian³ i²con²³ sa¹jeun³ a³li⁴sian³ coh⁵ jon³, ua²liah⁴a² sa⁴ma²sian³ a³jon⁴³i³ i¹jan³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jian³ a⁴juah⁴ Jon⁴dai¹ la⁴la³ i²con²³i³ liah⁴: “Lain⁴ la⁴jang³⁴ sa¹jeun³ quianh³ˉ³ la⁴jan³ a³sian³ ta⁵seg³⁴, quie¹ si⁵cua³i³ húa³⁴ seg³⁴, jian³ júan³⁴ a³tionh² húa³⁴ jon³ i⁴lain⁴i³ a³júan³ quian¹i³ tionh², jian³ i⁴tionh²i³ hlagh³² hie⁴³ ta¹la⁴ quin⁴ nia⁴lo⁴ ñi³.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jian³ a⁴juah⁴ Jon⁴dai¹ liah⁴: “He¹ jnia⁴ ma²eu⁴³ i²con²³ a³jeu³ a³júan³ i⁴lang⁴³ sa¹jeun³ quianh³ˉ³ a³júan³ quian¹i³, jian³ coh⁵ jon³ húan⁵i³ jeu³ jon³ i⁴cúa³⁴i³ cúa³tag³² i²con²³ jnia⁴ i²la³.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ma²jon³ a⁴júan⁴i³ re³ con³ jau²³ jian²³ A³brang²³, jau²³ i⁴gm⁴³ he³²i³. I² la⁴jon³ ra⁵sian³ I³sa²³ i²con²³ A³brang²³, jian³ liah⁴ma³jña³⁴ jm² ra⁵sian³i³, jon³ a⁴tei⁴i³ he³²i³, jian³ la⁴jon³ a⁴júan⁴ I³sa²³ i²con²³ Ja³co²³, jian³ Ja³co²³ liah⁴ a⁴júan⁴ la⁴ne³ i²con²³ quia⁵teun⁴ jmai³sie²³ˉ¹ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’I² jmai³sie²³ˉ¹ hain⁴ ne⁵, a⁴hnang⁴³i³ Se¹ reunh¹ i⁴eu⁴³ tsei⁴³i³, a⁴te¹ chie³ quieh¹i³ ta⁵húa³⁴ Egipto. I² Jon⁴dai¹ ne⁵, jian²³i³ Se¹, ");
INSERT INTO cucNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a³a⁴lie³ quieh¹i³ la⁴jeg³⁴ ma²eu⁴³ i⁴a⁴can³⁴i³, jian³ a⁴júan⁴i³ i⁴sainh⁴³i³ re³ ta⁵nei² Faraón, re¹ quian¹ húa³⁴ Egipto, jian³ i⁴ŋang⁴i³ re³; i⁴jon³ a⁴júan⁴ re¹ i⁴lang⁴³i³ a²teg⁴ teun³⁴ a³júan³ heih⁴³ húa³⁴ Egipto jon³, jian³ jauh³² quieh¹ re¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Ma²jon³ ja³⁴ ho³²cúan⁴ la⁴tan² húa³⁴ Egipto jian³ húa³⁴ Canaán la³, jian³ a⁴can³⁴i³ hlion⁴ ma²eu⁴³ tionh², quie¹ a⁵sie⁴³ tyieh¹ jmai³sie²³ˉ¹ i⁴queuh⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","I² con³ma²ra⁵ñi³ Ja³co²³ i⁴sia³ i⁴queuh³i³ húa³⁴ Egipto, jon³ a⁴sain⁴i³ jmai³sie²³ˉ¹ hain⁴ tionh² co⁴ra⁴lie⁵ ñeih³² teg⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","I² con³ma²a⁴sai⁴i³ a²teg⁴ taun³⁴, jon³ a⁴júan⁴ Se¹ lei³ i⁴ra⁵cu²³ si³reunh¹i³ hain⁴ quieh¹i³, i² jon³ ra⁵ñi³ Faraón nei² quieh¹ sa¹jeun³ quian¹ Se¹. ");
INSERT INTO cucNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","I² jon³ a⁴sainh³ Se¹ a³hain⁴ tionh², a⁴júan⁴i³ heih⁴³ i⁴tyie¹ Ja³co²³ jmai³i³ tionh² jian²³ la⁴jang³⁴ a³tei⁴³ jau²³ quian¹i³, a³tain⁴³ to⁴lo⁵quian⁴ ni²tsain¹ qui⁴hña⁴ chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","La⁴ne³pa² a⁴tyie³⁴ Ja³co²³ húa³⁴ Egipto i²a⁴jaun³⁴i³ jian³ i²a⁴chian³⁴ jmai³sie²³ˉ¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jian³ coh⁵ jon³ a⁴te¹i³ la⁴jang³⁴ a³jaun² hain⁴ tionh² la⁴teg⁴ jeu³ Siquem, i²a⁴quion³i³ to³hlo³ hon²³i³ a³jaun², i²ma²a⁴la³⁴ A³brang²³ i²con²³ si³jon⁴³ Hamor húa³⁴ Siquem jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’I² con³ma³o¹tyie¹ jm² i⁴li⁴tei⁴³ jau²³ i⁴a⁴cúa⁴ Jon⁴dai¹ i²con²³ A³brang²³ jon³, jon³ ra⁵jeun⁴³ a³jeu³ hlion⁴ mai²³ húa³⁴ Egipto. ");
INSERT INTO cucNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jian³ coh⁵ jon³ ja³⁴ i²jan³ re¹ sang³⁴ a³sa⁴cu²³ quieh¹ Se¹. ");
INSERT INTO cucNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","I² re¹ hain⁴, a⁴júan⁴i³ con⁴juah⁴ i⁴nei²³ tsei⁴³i³ i²con²³ a³co³²ˉ¹, i⁴a⁴júan⁴i³ hlagh³² i²con²³ jmai³sie²³ˉ¹, i⁴a⁴ton³⁴i³ yein³ coh⁵hnei³² canh⁴a² tyan⁴³i³, canh⁴a² sa⁴li⁴jeun⁴³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","I² jm² jon³ ra⁵sian³ M³se²³, jan³ yein³ a³a⁴teg⁴ tsei⁴³ Jon⁴dai¹; i² jon³ a⁴ma⁴cúan³ jmai³sie²³i³ jauh³² quieh¹ ta¹la⁴ on³ segh³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","I² con³ma²ni²tion⁴i³ i⁴ma²jaun⁴, jon³ ni²te¹ a³m⁴ jon⁴³ re¹ Faraón, a⁴ma⁴cúan³i³ la⁴jan³ yein³ quian¹i³ hña³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","I² jon³ ra⁵tang³ M³se²³ la⁴jeg³⁴ i⁴ŋang⁴ a³tionh² húa³⁴ Egipto jon³, jian³ ta² júanh⁴³i³ con⁴juah⁴ jau²³ i⁴hleh²i³ jian³ la⁴jeg³⁴ i⁴júan³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’I² con³ma²hein² M³se²³ to⁴lo⁵ ñi³, jon³ ja³⁴ co³hei²tsei³ quieh¹i³ i⁴si⁵jen³²i³ jon²reunh¹, sa¹jeun³ Israel hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","I² con³ma²a⁴je³⁴ M³se²³ i⁴si²júanh¹ jan³ chie³ egipcio quieh¹ jan³ a³co²³i³, jon³ a⁴jainh³i³ jm² quieh¹, a⁴jŋangh⁴i³ a³hain⁴, la⁴ne³ a⁴con²³i³ hmah¹ quieh¹ a³ma²júanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Quie¹ a⁴júan⁴ M³se²³ co³hei²tsei³, lain⁴i³, i⁴li⁴ñi³ jon²reunh¹i³ i⁴a⁴sai⁴ Jon⁴dai¹ quieh¹i³ i⁴lion⁴³i³ tionh²; i² a³co²³i³ ne⁵, sa⁴ra⁵laih²i³ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","I² con³ma²a⁴jnia³⁴, jon³ a⁴jainh³i³ on³⁴ a³co²³ a³si³tang⁴ tionh², jian³ ma²hnie³⁴i³ ma⁵tyan³i³ hnai³, a⁴juah⁴i³: “¿Henh⁴le³⁴ si³tangh⁴ˉ³ tionh²ˉ³? Jeh³², la⁴can³ si³reunh³pa² hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","I² a³ma²si²júanh¹ a³m⁵cu³ reunh¹ hain⁴ ne⁵, a⁴hlian⁴³i³ M³se²³, a⁴juah⁴i³: “¿Hain³ a⁴juah⁴ i⁴júanh²ˉ³ heih⁴³ jian³ o⁴ i⁴langh⁴³ˉ³ júa¹ i²con²³ jnie³²? ");
INSERT INTO cucNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿O⁴ hnoh³ˉ³ jŋangh¹ˉ³ jnia⁴ liah⁴i² a⁴jŋangh⁴³ˉ³ chie³ egipcio hain⁴ tyie⁴?” ");
INSERT INTO cucNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","I² con³ma²a⁴nau⁴ M³se²³ jau²³ jon³, jon³ a⁴cm⁴i³ ta⁵húa³⁴ Madián, a⁴cua⁴i³ i²jon³ la⁴jan³ a³sian³ ta⁵seg³⁴, i²ra⁵sian³ on³⁴ si³jon⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’I² con³ma²ua⁴jeu³² to⁴lo⁵ ñi³, jon³ ma⁴jnia³² jan³ ángel i²con²³i³, a³si²hein² je¹ o¹jyi³ loh⁴³ si²co²³ a²hma³ ton⁴³ tsain⁴³ con³ i²a⁵sian⁴³ a³sian³ ta⁵i²seih⁴³ a²mah⁴ Sinaí. ");
INSERT INTO cucNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","I² con³ma²a⁴je³⁴ M³se²³ i⁴ma⁴jnia³² jon³, ta² co³ a⁴jainh⁴³i³, i² jon³ ŋo³⁴i³ hloh³² ma²hnie³⁴i³ je³⁴i³, con³ a⁴la³ ja³⁴ jau²³ ho³² Se³ño²³, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Jnia⁴pa² lang⁴³ Jon⁴dai¹ quian¹ naih⁴³sieh³ˉ³ a³ja²³ ma³ya⁴jo³⁴, Jon⁴dai¹ quian¹ A³brang²³, jian³ a³quian¹ I³sa²³, jian³ a³quian¹ Ja³co²³ liah⁴.” I² M³se²³ ne⁵, ta² a⁴jlen³⁴i³ so⁵i²je³⁴i³ i⁴jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jon³ a⁴juah⁴ Jon⁴dai¹ i²con²³i³: “Qui⁴³ hnei³ a²lo³ tsei²³ tagh¹ ne³, quie¹ húa³⁴ i²si²sainh⁴³ˉ³ ne³ hen². ");
INSERT INTO cucNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Quie¹ chie⁴³pa² je³⁴ˉ⁴ liah⁴ ma²eu⁴³ ti²can²³ chie³ quian³⁴ˉ⁴ húa³⁴ Egipto, jian³ nau³⁴ˉ⁴ ti²hien²³i³ tionh², i⁴jon³ a⁴jyon³²ˉ⁴ i⁴ni¹lion³²i³ jnia⁴. I² tieh²la³ ne⁵, nia³, quie¹ sain¹ˉ⁴ hnei³ ta⁵húa³⁴ Egipto.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’I² jon³ ne⁵, M³se²³ hain⁴ a³ma²a⁴ton³⁴i³ ñeih³², i⁴a⁴juah⁴i³: “¿Hain³ a⁴juah⁴ i⁴júanh²ˉ³ heih⁴³ jian³ o⁴ i⁴langh⁴³ˉ³ júa¹ i²con²³ jnie³²?” I² jon³ ne⁵, M³se²³ hain⁴pa² a⁴sain⁴ Jon⁴dai¹, a³a⁴júan⁴ heih⁴³ jian³ a³a⁴lion³ a³jeu³ con⁴juah⁴ ua³pei⁴ quieh¹ ángel hain⁴ a³ma²ma⁴jnia³² i²con²³i³, je¹ a²hma³ ton⁴³ tsain⁴³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jian³ M³se²³ hain⁴pa² a⁴húan⁴³ a³jeu³, con³ma²ta⁵ma³a⁴júan⁴i³ hlion⁴ nai² ua³júah² co³ jnia⁴ húa³⁴ Egipto jon³, jian³ Jm³ñih¹ Yein⁴, jian³ ta⁵i²a⁵sian⁴³ a³sian³ jon³, ta¹la⁴ to⁴lo⁵ ñi³, con³ma²a⁴húan³ a³jeu³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jian³ M³se²³ hain⁴pa² a⁴sagh⁴³ sa¹jeun³ Israel, con³ma²a⁴juah⁴i³: “Júan³⁴ Se³ño²³ Jon⁴dai¹ quianh³ˉ³ i⁴hyon⁴³ jan³ a³sain² quian¹i³ jen² jon³reunh³ˉ³ tionh²ˉ³ liah⁴i² a⁴sai⁴i³ jnia⁴. Jian³ nai³ hnei³ jau²³ quieh¹i³.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jian³ M³se²³ hain⁴pa² ma²hein² jen² a³jeu³ i²a⁵sian⁴³ a³sian³ jon³, con³ma²a⁴hleh⁴ ángel hain⁴ i²con²³i³ nei² mah⁴ Sinaí, jian³ ma²hein²i³ jen² jmai³sie²³ˉ¹ a³sian³ ya⁴jo³⁴; jian³ hei⁴ pi²³i³ a⁴hyei⁴ jau²³ tionh² i⁴cúa²³ m⁵cu³ i⁴a⁴ŋang³⁴i³ i²con²³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’I² jmai³sie²³ˉ¹ tionh² ne⁵, sa⁴ra⁵hnie³⁴i³ i⁴ma⁵co⁴³i³ jau²³ jon³, quie¹ a⁴ton³⁴i³ M³se²³, jian³ a⁴júan⁴i³ co³hei²tsei³ i⁴hnie³⁴i³ ma²tyanh¹i³ húa³⁴ Egipto, ");
INSERT INTO cucNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","con³ma²a⁴sagh⁴³i³ Reun²³: “Júan³² hnei³ neih³² quian⁴ˉ¹, canh⁴a² chie³⁴i³ ta⁵nei²ˉ¹ ho³²jeu³; quie¹ sa⁴nia²ˉ¹ henh⁴ a⁴jainh⁴³ A²m³se²³ a³a⁴húa⁴³ jnia¹ húa³⁴ Egipto hain⁴.” ");
INSERT INTO cucNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","I² jon³ a⁴júan⁴³i³ jan³ nioh⁵ a³lang⁴³ cua³²jeu²³ peih¹, ma²jon³ a⁴jang⁴i³ jah⁴ ta⁵nei² nioh⁵ hain⁴, ta² si³hyonh³i³ tionh² i⁴a⁴júan⁴i³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ma²jon³ a⁴quein³⁴ Jon⁴dai¹ i²con²³i³ tionh², a⁴cúanh³i³ i⁴ma⁵con⁴³i³ la⁴jang³⁴ jah⁴nai⁴³; liah⁴i² ra³juah⁴ ma²jyi³ i⁴a⁴sag⁴ a³sain² quian¹ Jon⁴dai¹: Hnei³ a³jeu³ Israel, ¿o⁴ ma⁴coh³²ˉ³ jnia⁴ con³ma²a⁴jainh²ˉ³ jah⁴, ta¹la⁴ ma²tionh²ˉ³ i²a⁵sian⁴³ a³sian³ jon³ ta¹la⁴ to⁴lo⁵ ñi³, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","A⁵sia³, quie¹ ua⁴canh³²ˉ³ a²hnei⁴³ a²lo³ quieh¹ nioh⁵ Moloc tionh²ˉ³, jian³ a⁴ma⁴conh³²ˉ³ jah⁴nai⁴³ quian¹ neih³² Renfán quianh³ˉ³, nioh⁵ a³a⁴júanh³²ˉ³ i⁴ma²conh³²ˉ³ tionh²ˉ³. I⁴jon³ ni¹tion⁵ˉ⁵ hnei³ tionh²ˉ³ teg⁴ coh⁵ jeu³ Babilonia i²gm⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Jian³ ua⁴can³² jmai³sie²³ˉ¹ a²hnei⁴³ a²lo³ i²ma²ŋangh³i³ i²a⁵sian⁴³ a³sian³ jon³, liah⁴ heih⁴³ a⁴júan⁴ Jon⁴dai¹ con³ma²a⁴sagh⁴³i³ M³se²³ i⁴júan³⁴i³ cuah²hnei⁴³ jon³ con⁴juah⁴ nioh⁵ i⁴a⁴je³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Jian³ ta⁵ma³a⁴hyei⁴ jmai³sie²³ˉ¹ a²hnei⁴³ a²lo³ jon³, jon³ quien²³i³ ta⁵húa³⁴ la³ jian²³i³ Josué, con³ma²a⁴qui³⁴i³ húa³⁴ la³ joh⁴³ cúa³ chie³ sang²³ tionh², quie¹ a⁴húan⁴³ Jon⁴dai¹ chie³ sang²³ hain⁴ jen² jmai³sie²³ˉ¹ tionh², quie¹ la⁴teg⁴ jm² i⁴a⁴lang³⁴ Da³vei²³ re¹, a⁴júan⁴ ta¹ a²hnei⁴³ a²lo³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","A³hain⁴ a³a⁴teg⁴ tsei⁴³ Jon⁴dai¹, jian³ a⁴mh³i³ Jon⁴dai¹ i⁴júan³⁴i³ con³ jauh³² quieh¹ Jon⁴dai¹ quian¹ Ja³co²³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Quie¹ Salomón pa² a⁴júan⁴ cuah³júah² jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Jian³ ua²liah⁴a² sa⁴cua⁴³ Jon⁴dai¹ júanh⁴³ cuah³ i⁴júan³ chie³, liah⁴i² a⁴juah⁴ jan³ a³sain² quian¹i³: ");
INSERT INTO cucNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ñi⁴jeu⁵pa² cua³²ˉ⁴ nei² a²ma³sei² tyein² quien⁴, jian³ cuah³²húa³⁴ la³ leg⁴³ la⁴con³ i²si⁵tyi³²ˉ⁴ si¹tag³⁴. ¿I² liah⁴ cúan²³ júanh²ˉ³ a²hnei⁴³ quien⁴ˉ⁴ ne⁵? juah⁴ Se³ño²³, ¿jian³ o⁴ jainh¹ lei⁴ li⁴jian¹ˉ⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿O⁴ a⁵sia³ a⁴júan³⁴ˉ⁴ la⁴jeg³⁴ i⁴ne³ con⁴juah⁴ ua³pei⁴ quien⁴, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","’Jian³ eu⁴³ huah³ tyih³ˉ³ tionh²ˉ³, jian³ langh⁴³ˉ³ liah⁴i² lang⁴³ a³sa⁴cm²³ Jon⁴dai¹ naih⁵ m⁴tyi⁴ quianh³ˉ³, jian³ sa⁴naih¹ˉ³, jian³ liah⁴ma³leg⁴³ jon³pa² sa⁴roh³ˉ³ jeu³ M⁴tyi⁴ quieh¹ Jon⁴dai¹. Quie¹ liah⁴i² a⁴júan⁴ naih⁴³sieh³ˉ³ ya⁴jo³⁴, la⁴jon³pa² júanh³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Hain³a² a³sain² quian¹ Jon⁴dai¹ sa⁴a⁴hang⁴ naih⁴³sieh³ˉ³ liah⁴? Quie¹ a⁴jŋangh⁴i³ a³a⁴hleh⁴ ñeih³² i⁴jia²³ A³tsein²³ hain⁴, a³hain⁴ a³a⁴cúanh³²ˉ³ tionh²ˉ³ can¹ ne³, a³a⁴jŋangh⁴³ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jian³ lai²³ i⁴a⁴hyeih²ˉ³ i⁴a⁴cúa⁴ ángel jon³, i¹ sa⁴ma⁴teih³²ˉ³ tionh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","I² con³ma²a⁴nau⁴i³ jau²³ jon³ tionh², ta² a⁴jain³⁴ tsei⁴³i³, i⁴queuh³i³ júah³ m⁴jan² jen³i³ Te⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","I² Te⁴ ne⁵, hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quian³i³, jon³ a⁴je³⁴i³ ta⁵ñi⁴jeu⁵ tia⁴, a⁴je³⁴i³ joh¹ quieh¹ Jon⁴dai¹, jian³ a⁴jen³i³ Jesús si²sainh⁴³ jo³² ta⁵chie³⁴ quieh¹ Jmai³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","I² jon³ a⁴juah⁴i³: ―¡Jeh³²! Tieh²la³ si²je³⁴ˉ⁴ si¹ja⁵ ñi⁴jeu⁵, jian³ si²jen³²ˉ⁴ A³a⁴lang³⁴ Chie³ hain⁴ si²sainh⁴³ jo³² ta⁵chie³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","I² hei⁴i³ tionh² ne⁵, ta² tia⁴ a⁴hoh⁵i³, a⁴jnei⁴i³ ta³ra³cua¹, jian³ ma²jon³ a⁴ua⁴tsain³²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jian³ a⁴tyei³i³ teg⁴ coh⁵ je¹jeu³, i² jon³ ni²quinh⁴³i³ m⁴caun²; jian³ a³ti²tei⁴³ nei² i²jon³, jon³ a⁴tya⁴i³ a²hmh³ tsei²³ coh⁵ quieh¹ hlonh² jan³ a³maih² a³sain³ Saulo. ");
INSERT INTO cucNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Jon³ a⁴quinh⁴³i³ Te⁴ m⁴caun², ta¹la⁴ jon³ si²hlenh⁴³ Te⁴ Re¹ Jesús, juah⁴i³: ―Hnei³ Re¹ Jesús, hyeih¹ hnei³ m⁴tyi⁴ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","I² jon³ a⁴si⁴jnei⁵i³, a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―Hnei³ Se³ño²³, a⁵ro³ hnei³ jeu³ chie³² ti²ta³canh¹ a³ne³ tionh². I² con³ma²a⁴hleh⁴i³ jau²³ jon³, jon³ a⁴jaun³⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","I² Saulo hain⁴ ra⁵hyon³ tsei⁴³ i⁴a⁴jaun³⁴ Te⁴ hain⁴. I² jm² jon³ ra⁴lie⁵ a⁴hag⁴ chie³ tionh², a⁴hang⁴i³ cuah³ a³tionh² je¹jeu³ Jerusalén. I⁴jon³ ua⁵jan⁴ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹ la⁴tan² húa³⁴ Judea, jian³ húa³⁴ Samaria; i² la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo ne⁵, a⁴jian⁴i³ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jian³ chie³ a³ni²taih⁴³ i²con²³ Jon⁴dai¹, a⁴te¹i³ Te⁴ hain⁴, ni²hon⁴³i³ jian³ ta² a⁴hoh⁵i³ tia⁴ tionh² nei² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","I² Saulo hain⁴, ta² hang²³i³ cuah³, jian³ i⁴nei² jauh³² tian²³i³, sanh²i³ ta⁵li⁴hnai³ a³ñih³ a³m⁴, si³ron⁴³i³ ni⁴ñi²³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","I² la⁴jang³⁴ a³ua⁵jan⁴ hain⁴ tionh², ua⁵han²i³ la⁴tan², hleh²i³ jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jian³ Lei³² liah⁴, ŋo³⁴ ta⁵je¹jeu³ Samaria, ua⁵hleh³i³ nei² quieh¹ Cristo. ");
INSERT INTO cucNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jian³ la⁴jang³⁴ a³jeu³, con³ma²a⁴nau⁴i³ jian³ a⁴je³⁴i³ la⁴jeg³⁴ ua³júah² i⁴júan³ Lei³², jon³ tionh²i³ con³ co³hei²tsei³ ti²nau³i³, ti²can²³i³ hei²³ la⁴jeg³⁴ jau²³ i⁴hleh²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Quie¹ húa³i³ m⁴tyi⁴ hlagh³² i⁴ti²quian³ jeun⁴³, jian³ ti²hoh⁵i³ húan⁵i³; jian³ júan³i³ i⁴huan⁴ quieh¹ jeun⁴³ a³lo³, jian³ a³tein⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","I² la⁴ne³ ta² hlion⁴ si³hyonh³ a³tionh² jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jian³ i²jon³ ma²sian³ jan³ a³ñih³ a³sain³ Si²úan¹, a³ma²júan³ ta¹ i³nah² jeu³ jon³, jian³ ma²ma³can³i³ a³tionh² húa³⁴ Samaria jon³, ma²júan³i³ i⁴júanh⁴³i³ hña³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jian³ la⁴jang³⁴ ma²ro³ jeu³ jau²³ quieh¹ a³hain⁴, la⁴teg⁴ a³peih¹ la⁴teg⁴ a³don⁵, ma²juah⁴i³ tionh²: ―A³ne³pa² quian³ hlion⁴ ua³pei⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jian³ ta² ma²ti²can²³i³ hei²³, quie¹ ma³jon⁵ne³⁴ ma³co³ a³hain⁴ quieh¹i³ tionh² con⁴juah⁴ ta¹ i³nah². ");
INSERT INTO cucNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","I² con³ma²ra⁵hain⁴i³ tionh² jau²³ i⁴hleh² Lei³², jau²³ quieh¹ Jesucristo hain³liah⁴ leg⁴³ i⁴tionh² chie³ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹, jon³ a⁴sion⁴³i³ chie³ jm³, a³ñih³ a³m⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jian³ ra⁵hain⁴ Si²úan¹ hña³ liah⁴; i² con³ma²a⁴son⁴i³ jm³, jon³ ma⁴reunh¹i³ Lei³² la⁴jeg³⁴ nie⁴³, jian³ ta² co³ a⁴jainh⁴³i³ con³ma²a⁴je³⁴i³ la⁴jeg³⁴ ua³júah² pain⁴ co³ jnia⁴ i⁴júan³ Lei³². ");
INSERT INTO cucNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","I² con³ma²ra⁵ñi³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo hain⁴, a³tionh² je¹jeu³ Jerusalén, i⁴ma³a⁴hyei⁴ a³tionh² húa³⁴ Samaria jau²³ quieh¹ Jon⁴dai¹, ma²jon³ a⁴sain⁴i³ Pe³² jian²³ Juan²³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","I² con³ma²a⁴tyie³⁴i³ tionh², jon³ a⁴mh³i³ Jon⁴dai¹ nei² quieh¹ a³hain⁴ tionh², canh⁴a² hyei³⁴i³ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Quie¹ i¹jan³ a³hain⁴ a⁵sia³ ma³a⁴hyei⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹; quie¹ con⁴hie³² ma³a⁴son⁴ jm³ pi²³i³ con⁴juah⁴ jm³i⁴sain³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jon³ a⁴sanh³i³ ma³tyi² a³hain⁴ tionh², ma²jon³ a⁴hyieh³i³ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","I² con³ma²a⁴je³⁴ Si²úan¹ hain⁴ i⁴hyieh⁴ chie³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ con⁴juah⁴ i⁴sanh² a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo ma³tyi² chie³ tionh², ma²jon³ a⁴jainh³i³ o¹cau³² i²con²³ a³hain⁴ tionh², ");
INSERT INTO cucNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","juah⁴i³: ―Cúa² hnei³ ua³pei⁴ ne³ i²con²³ˉ⁵ liah⁴, canh⁴a² la⁴jang³⁴ a³jmah¹ˉ⁴ ma³tyi² hyei³⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","I² jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Cúah² i²hlagh³²pa² hnei³ la⁴ne³ jianh²ˉ³ o¹cau³² ne³, quie¹ lainh⁴ˉ³ con⁴juah⁴ o¹cau³²pa² tag³ i⁴ta² cúa²³ Jon⁴dai¹ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Quie¹ i¹leuh² sa⁴tainh⁴³ˉ³ o³tan² nei² ne³, quie¹ a⁵sia³ re³ ma³leg⁴³ m⁴tyi⁴ quianh³ˉ³ ta⁵nei² Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Teinh³² hoh⁴³ co³hei²tsei³ hlagh³² ne³, jian³ mh³² Jon⁴dai¹, sa¹ li⁴hain³⁴i³ chie³² i⁴a⁴júanh²ˉ³ co³hei²tsei³ hlagh³² naih⁵ m⁴tyi⁴ quianh³ˉ³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Quie¹ ta² jia²³ eu⁴³ hoh⁴³ˉ³, jian³ langh⁴³ˉ³ la⁴jan³ a³chion³² nei² quieh¹ la⁴jeg³⁴ i⁴hlagh³² ne³, je³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","I² jon³ a⁴ŋangh³ Si²úan¹ hain⁴, a⁴juah⁴i³: ―Mh³² hnei³ Jon⁴dai¹ nei² quien⁴ˉ⁴ tionh²ˉ³, canh⁴a² sa⁴lei⁴ i²con²³ˉ⁵ liah⁴ ma³ra³juah¹ˉ³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","I² con³ma²a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ i⁴jang³⁴ tsei⁴³i³ tionh², jon³ ŋah³i³ liah⁴ ta⁵ Jerusalén, jian³ ta¹la⁴ jon³ a⁴hleh⁴i³ jau²³ tsei²³ quieh¹ Jesucristo hlion⁴ jeu³ i²tei⁴³ húa³⁴ Samaria jeu³ ŋah³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jian³ con³ma²a⁴leg³⁴ jon³, jon³ a⁴hleh⁴ jan³ ángel quian¹ Se³ño²³ i²con²³ Lei³², a⁴juah⁴i³: ―Ra⁴hang³² hnei³, cua³ la⁴teg⁴ ta⁵ñei³⁴, la⁴teg⁴ i²tyon⁴ jeu³ quieh¹ Jerusalén jian²³ jeu³ Gaza, i²leg⁴³ con³ i²a⁵sian⁴³ a³sian³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ma²jon³ ra⁴hang³² Lei³², ŋo³⁴i³; i² con³ma²hein²i³ jeu³, jon³ a⁴jainh³i³ jan³ a³sian³ húa³⁴ Etiopía, jan³ a³teh⁴³, a³jonh² Jerusalén a³ni²ma⁴con³² Jon⁴dai¹, jian³ a³quian³ ta¹ hie³ la⁴jeg³⁴ o¹cau³² quieh¹ a¹si²re¹ quian¹ húa³⁴ Etiopía a³sain³ A¹cang³da²ce³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","A³jonh² hein² joh⁴³ a²ma⁴legh⁴ quieh¹, jian³ ua²heg³i³ ma²jyi³ i⁴a⁴sag⁴ Isaías, a³sain² quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","I² jon³ a⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³ Lei³²: ―Cua³ hnei³ teg⁴ hloh³² a²ma⁴legh⁴ jno³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","I² con³ma²a⁴tyie³⁴ Lei³² hloh³², jon³ a⁴nau⁴i³ i⁴ua²heg³ a³hain⁴ ma²jyi³ i⁴a⁴sag⁴ Isaías, ma²jon³ a⁴juah⁴ Lei³²: ―Jeh³², ¿o⁴ ŋangh⁴ˉ³ i⁴ua²hegh³ˉ³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","I² a⁴ŋangh³ a³hain⁴: ―¿Liah⁴ li⁴ŋang⁴ˉ⁴ juah⁴ne³ a⁵sian⁴³ a³li⁴he³⁴? Jon³ a⁴mh³i³ Lei³² i⁴si⁵hei⁴i³ joh⁴³, i⁴cua³⁴i³ jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","I² i²ma²ua²heg³i³ jon³, ra³hleh² la⁴la³: Quie¹ a⁴jŋangh⁴i³ liah⁴i² jŋangh²i³ jan³ a⁵a³siah³; jian³ liah⁴i² lang⁴³ a⁵a³siah³ a³sa⁴hoh⁵ i¹con³ tei⁴³i² taih²i³ o¹jñi³², jian³ la⁴ne³ i¹con³ sa⁴a⁴hleh⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Jian³ a⁴co⁴lianh³i³ la⁴conh⁴i² tang³i³, liah⁴i² so⁵hei¹ heih⁴³; i² sa¹jeun³ quian¹i³ ne⁵, ¿hain³ ma⁵li⁴hang³⁴, lainh⁴ˉ³? Quie¹ a⁴jŋangh⁴i³ canh⁴a² so⁵sian³i³ nei² cuah³²húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","I² jon³ a⁴juah⁴ chie³ júanh⁴³ hain⁴ i²con²³ Lei³²: ―Júan² con³ i⁴tsei³⁴ hoh⁴³, tyie³² jnia⁴ jau²³, ¿hain³ nei² quieh¹ a⁴sag⁴ a³sain² hain⁴ jau²³ la³, o⁴ nei² quieh¹i³ hña³, jian³ o⁴ nei² quieh¹ a³sang²³? ");
INSERT INTO cucNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","I² Lei³² ne⁵, a⁴tya⁴i³, a⁴ma⁴lie⁵i³, a⁴hleh⁴i³ i⁴ra³sag² jon³ nei² quieh¹ jau²³ tsei²³ quieh¹ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","I² ta¹la⁴ tionh²i³ jeu³ ho³²jeu³ jon³, jon³ a⁴tyie³⁴i³ con³ i²ra³hei¹ jm³, i² jon³ a⁴juah⁴ a³ñih³ júanh⁴³ hain⁴: ―Jeh³², jm³ ra³hei¹ i²la³; ¿o⁴ sa¹ li⁴son⁵ˉ⁵, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jon³ a⁴juah⁴ Lei³²: ―Li⁴lei⁴pa² a¹juah⁴ne³ hainh⁴ˉ³ jang³⁴ hoh⁴³. I² jon³ a⁴juah⁴ a³hain⁴: ―Hain⁴pa² jnia⁴ i²con²³ Jesucristo i⁴lang⁴³i³ A³jon⁴³ Jon⁴dai¹ hña³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","I² jon³ a⁴júan⁴i³ heih⁴³ i⁴jian³⁴ a²ma⁴legh⁴; jon³ ua⁵han²i³ joh⁴³ jm³ tionh² li⁵uan⁴i³ la⁴jon³, Lei³² jian³ a³hain⁴, i² jon³ a⁴sie⁴³ Lei³² jm³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Con³ma²a⁴húan³i³ jm³ tionh², jon³ a⁴te¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ Lei³² hain⁴; i² chie³ teh⁴³ hain⁴, a⁵sie⁴³ ma⁵a⁴jen³i³ Lei³²; jon³ ŋah³i³ quieh¹ si³hyonh³i³ hlion⁴ mai²³. ");
INSERT INTO cucNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","I² Lei³² hain⁴ ne⁵, a⁴hyon²³i³ ta⁵je¹jeu³ Azoto, i² jon³ a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ la⁴tan² jeu³ ŋo³⁴i³ jon³, liah⁴i² a⁴tyie³⁴i³ je¹jeu³ Cesarea. ");
INSERT INTO cucNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jian³ ta¹la⁴ jon³ hleh² Saulo i⁴hniah³ sanh³i³ chie³ quian¹ Jon⁴dai¹ jian³ i⁴hniah³ jŋangh³i³. Jon³ a⁴tyie³⁴i³ i²con²³ jeu³² m³chie³ tyein², ");
INSERT INTO cucNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ni²m³i³ ma²jyi³ i⁴si⁵he³i³ la⁴jeg³⁴ cuah³ judío je¹jeu³ Damasco, ma²jyi³ i⁴ra³cúa²³ heih⁴³ i⁴si⁵sianh⁴i³, i⁴si⁵te¹i³ chion³² chie³ a³quian³ Jeu³ quieh¹ Jesucristo, a³ñih³ a³m⁴, a¹juah⁴ne³ a⁴chianh¹i³, i⁴si⁵jon⁴i³ teg⁴ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","I² con³ma²hein² Saulo jeu³, ho³²jeu³, con³ma³o¹tyie¹i³ jeu³ Damasco, con³ a⁴la³ ra⁵joh¹ con³ o¹jyi³ ta⁵ñi⁴jeu⁵, a⁴tagh⁴ la⁴tan² hlonh²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jon³ a⁴quionh³i³ húa³⁴, jian³ a⁴nau⁴i³ con³ jau²³ i⁴hleh²i³, i⁴juah⁴i³: ―Saulo, Saulo, ¿e⁴le³⁴ hagh⁵ˉ³ jnia⁴? ");
INSERT INTO cucNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","I² jon³ a⁴ŋangh³i³: ―¿Hain³ chianh² hnei³, a³don⁵? I² jon³ a⁴juah⁴ a³hain⁴: ―Jesús pa² jnia⁴, a³hain⁴ a³hangh⁵ˉ³. Quie¹ júanh³ˉ³ liah⁴i² júan³ a²cua³²jeu²³ a³quein³ a²hma³ tyi¹ a²jon⁴³ñi²³, i⁴júanh⁵ˉ³ húanh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","I² hei⁴i³ ne⁵, ta² a⁴jlen³⁴i³ coh⁴³i³, a⁴juah⁴i³: ―Hnei³ Se³ño²³, ¿henh⁴ hnoh³ˉ³ júan³²ˉ⁴? I² jon³ a⁴juah⁴ Se³ño²³: ―Ra⁴hang³² hnei³, cua³ ta⁵je¹jeu³ ne³, i²jon³ sag⁵i³ hnei³ henh⁴ hniah³ júanh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","I² la⁴jang³⁴ chie³ ma²tionh² jeu³ jian²³ Saulo hain⁴, ta² yi⁴hang³²i³, quie¹ a⁴nau⁴i³ jau²³ jon³, jian³ a⁵sian⁴³ a⁴jen³i³ i¹jan³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jon³ ra⁴hang³² Saulo i²ma²ra³quian³i³ húa³⁴, i² con³ma²a⁴hoh³i³ m⁴nei², i¹leuh² so⁵jnieh⁴³i³. I⁴jon³ a⁴sanh³ chie³ si¹cúa³i³, te¹i³ teg⁴ je¹jeu³ Damasco, ");
INSERT INTO cucNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","i²a⁴jian⁴i³ hneng³ jm², i⁴sa⁴jnieh⁴³i³, jian³ i⁴sa⁴a⁴queuh³i³, jian³ i⁴sa⁴a⁴hainh³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jian³ je¹jeu³ Damasco jon³, ma²sian³ jan³ chie³ quian¹ Jon⁴dai¹ a³sain³ Ananías, a³ma⁴jnia³² Se³ño²³ i²con²³, i⁴a⁴juah⁴i³: ―¡Ananías! I² jon³ a⁴ŋangh³i³: ―La³ si²sainh⁴³ˉ⁴, Se³ño²³ quian³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","I² jon³ a⁴juah⁴ Se³ño²³ liah⁴: ―Nia³, cua³ la⁴teg⁴ jeu³júan²³ sain³ Jeu³chie⁴³, tyieh⁴ˉ³ jauh³² quieh¹ Judas, i²tyanh³²ˉ³ jan³ a³sain³ Saulo, a³sian³ jeu³ Tarso; jian³ tieh²la³ ma³si²mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jian³ ma³si²jen³i³ jan³ a³ñih³ a³sain³ Ananías, a³ma⁴jnia³² i²con²³i³, a³a⁴hei³⁴ i²cua⁴³i³, jian³ a³a⁴tei³⁴ si¹cúa³ i²con²³i³, canh⁴a² jnia⁵ m⁴nei²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","I² a⁴juah⁴ Ananías i²con²³ Se³ño²³ ne⁵: ―Hnei³ Se³ño²³, ta² jeun⁴³ chie³ ma³a⁴tyie⁴ˉ⁴ jau²³ nei² quieh¹ a³ñih³ hain⁴, jian³ la⁴jeg³⁴ i⁴hlagh³² ma³a⁴júan⁴i³ i²con²³ chie³ quianh³ˉ³ a³tionh² Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jian³ i²la³ liah⁴, quian³i³ heih⁴³ i⁴a⁴cúa⁴ m³chie³ tyein² i⁴sanh³i³ la⁴jang³⁴ a³te²³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","I² a⁴juah⁴ Se³ño²³ ne⁵: ―Cua³ hnei³, quie¹ ma³a⁴hnah³² jnia⁴ a³hain⁴ i⁴júan³⁴i³ ta¹ quien⁴ˉ⁴, i⁴si⁵hleh³i³ nei² quien⁴ˉ⁴ ta⁵nei² a³sa⁴lang⁴³ judío, jian³ ta⁵nei² re¹ tionh² jian³ ta⁵nei² sa¹jeun³ Israel liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Quie¹ hno⁵ˉ⁵ he¹ˉ⁴ conh⁴ tei⁴³ ma²eu⁴³ i⁴hniah³ can³⁴i³ nei² quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","I² jon³ ŋo³⁴ Ananías hain⁴, a⁴hei³⁴i³ jauh³². I² con³ma²a⁴tei³⁴i³ si¹cúa³ i²con²³i³, jon³ a⁴juah⁴i³: ―Hnei³ Saulo, goh³ quian³⁴ˉ⁴, Re¹ Jesús, a³ma⁴jnia³² i²conh²ˉ³ ho³²jeu³ ma²a⁴niah³ˉ³ ma²jon³, a⁴sai⁴i³ jnia⁴ canh⁴a² jnia⁵ m⁴mah²ˉ³, jian³ canh⁴a² hyeih²ˉ³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","I² liah⁴ma²jon³ a⁴jyih³ la⁴con³ o¹seg²³ lo³ ma²ti²ton³ m⁴nei²i³, jian³ a⁴hoh³ liah⁴ma²jon³. I² con³ma²ra⁴hang³²i³, jon³ a⁴son⁴i³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","I² con³ma²a⁴queuh³i³ a²hei⁴³, jon³ a⁴lag³⁴ tsei⁴³i³, ma²jon³ a⁴cua⁴ Saulo úa⁴ meih³ jian²³ chie³ quian¹ Jon⁴dai¹ a³tionh² Damasco. ");
INSERT INTO cucNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","I² liah⁴ma²jon³ a⁴hleh⁴ Saulo jau²³ quieh¹ Cristo cuah³ judío tionh², a⁴juah⁴i³ i⁴lang⁴³ Jesús hain⁴ A³jon⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","I² la⁴jang³⁴ a³a⁴nau⁴ jau²³ i⁴hleh²i³, ta² co³ ŋo³⁴ tsei⁴³i³ tionh², a⁴juah⁴i³: ―¿O⁴ a⁵hei⁴³ a³ne³ hain⁴ a³ma²hang²³ a³tionh² Jerusalén a³hleh² jm³i⁴sain³ Jesús ne³, heh⁵ˉ³, jian³ i⁴jon³pa² cuan³⁴i³ i²la³ liah⁴, i⁴te⁴³i³ chion³² a³quian³ jeu³ ne³, i⁴si⁵jon⁴i³ ta⁵nei² m³chie³ tyein²? ");
INSERT INTO cucNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","I² Saulo ne⁵, tsei³⁴sa² re³ a⁴hleh⁴i³, i⁴quian³i³ hlion⁴ ua³pei⁴, a⁴júan⁴i³ i⁴a⁴ŋo³ la⁴jang³⁴ judío a³tionh² Damasco, quie¹ ma⁴jnia³i³ i⁴chie⁴³ lang⁴³ Jesús A³ua⁵lion³² Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","I² con³ma²ua⁴jeu³² hlion⁴ jm², jon³ a⁴júan⁴ judío re³ tionh² i⁴jŋangh³i³ Saulo hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","I² Saulo ne⁵, ra⁵ñi³i³ i⁴jon³. I² la⁴jang³⁴ a³hain⁴ tionh² ma²hie³ la⁴húa²³ la⁴jm²³ la⁴jeg³⁴ o²hnei³² quieh¹ jeu³ si³hei⁴i³ jeu³ jon³, i⁴hnie³⁴i³ jŋangh³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","I² jon³ a⁴jyie³ chie³ quian¹ Jon⁴dai¹ quieh¹ Saulo, hein²i³ joh⁴³ a²mh³ta²³, con³ je¹nai³ ta⁴coh⁵ a²cuah³² si²jneng³ jeu³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","I² con³ma²a⁴tyie³⁴i³ je¹jeu³ Jerusalén, jon³ ma²hnie³⁴i³ ma⁵reunh¹i³ chie³ quian¹ Jon⁴dai¹ a³tionh² i²jon³; i² la⁴jang³⁴ a³hain⁴ tionh² ne⁵, con⁴³i³, quie¹ sa⁴hain⁴i³ i⁴lang⁴³ Saulo jan³ chie³ quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","I² Be²³ ne⁵, jian³i³ Saulo hain⁴, ni²jan³i³ i²con²³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a⁴tya⁴i³ jau²³ liah⁴ a⁴jen³ Saulo Se³ño²³ ho³²jeu³ ma²ŋo³⁴i³ Damasco, jian³ i⁴a⁴hleh⁴ Se³ño²³ i²con²³i³, jian³ a⁴tya⁴i³ jau²³ liah⁴ a⁴hleh⁴ Saulo jau²³ quieh¹ Jesús i⁴sa⁴jieh⁴ tsei⁴³i³ je¹jeu³ Damasco liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","I² jon³ a⁴cua⁴ Saulo jian²³ a³hain⁴ tionh² Jerusalén jon³, jian³ a⁴ŋeng⁴i³ jian²³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jian³ a⁴hleh⁴i³ i⁴sa⁴jieh⁴ tsei⁴³ nei² quieh¹ Se³ño²³, jian³ a⁴jang²³i³ jian²³ chie³ griego; jian³ ma²hnie³⁴ a³hain⁴ tionh² jŋangh³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","I² con³ma²ra⁵ñi³ la⁴jang³⁴ si³reunh¹i³, jon³ ni²jan³i³ teg⁴ Cesarea, ma²jon³ a⁴sain⁴i³ jeu³ Tarso. ");
INSERT INTO cucNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","I² con³ma²a⁴leg³⁴ jon³, ta² a⁴han⁵ cuah³ tai³² tionh² la⁴tan² húa³⁴ Judea, jian³ húa³⁴ Galilea, jian³ húa³⁴ Samaria liah⁴; jian³ ta² ra⁵pain⁴i³, jian³ i⁴sian³i³ ma³con⁴³i³ Se³ño²³, jian³ ta² ma³si³li⁴jeun⁴³i³ liah⁴ con⁴juah⁴ i⁴ma³ho³² M⁴tyi⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","I² con³ma²ŋeng²³ Pe³² la⁴tan² jon³ i⁴si³jen³²i³ si³reunh¹, jon³ ŋo³⁴i³ ta⁵jeu³ Lida, ua⁵jen³²i³ chie³ quian¹ Jon⁴dai¹ a³tionh² i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","I² jon³ a⁴jen³i³ jan³ a³ñih³ a³sain³ Eneas, a³ra³quian³ nei² jain³² quieh¹ ma³jña³⁴ ñi³, chieh¹i³ i⁴lo³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","I² jon³ a⁴juah⁴ Pe³² i²con²³i³: ―Hnei³ Eneas, Jesucristo júan³⁴ i⁴huan⁴ quianh³ˉ³ to⁴ne⁵ la³. Ra⁴hang³² hnei³, sieh¹ a²jain³² quianh³. I² a³ñih³ hain⁴, liah⁴ma²jon³ a⁴no³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","I² la⁴jang³⁴ a³tionh² jeu³ Lida jian³ húa³⁴ Sarón, a⁴jen³i³ a³hain⁴, jon³ a⁴can³⁴i³ jeu³ quieh¹ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","I² jon³ ne⁵, ma²sian³ jan³ chie³ quian¹ Jon⁴dai¹, a³m⁴, je¹jeu³ Jope, a³teh²i³ Tabita, hnie³⁴ ra³juah⁴, A¹dor²cas³, jau²³ griego. Jian³ ta² ma²júan³i³ i⁴tsei³⁴, jian³ ma²ma³hon³²i³ a³ti⁴ñei³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","I² jm² jon³ ra⁵chieh¹ a³m⁴ hain⁴, jian³ a⁴jaun³⁴i³; i² con³ma²a⁴raun⁴³i³, jon³ a⁴quion³i³ jauh³² a²teg⁴ teun³⁴ piso. ");
INSERT INTO cucNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","I² jeu³ Lida jon³ ne⁵, nie⁴³ hloh³² jeu³ Jope. I² con³ma²ra⁵ñi³ chie³ quian¹ Jon⁴dai¹ a³tionh² jeu³ Jope jon³ i⁴cua⁴³ Pe³² jeu³ Lida, jon³ a⁴sain⁴i³ on³⁴ a³ñih³ a³ua⁵te³ quieh¹i³, a³a⁴juah⁴: ―Nia³ hnei³ ta¹tia⁴ to⁴ne⁵ i²con²³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","I² jon³ ra⁴hang³² Pe³², ŋo³⁴i³ jian²³i³ tionh²; i² con³ma²a⁴tyie³⁴i³, jon³ ni²jo³i³ teg⁴ jauh³² jon³, i²ti²tionh² a³don⁵ m⁴ hnang⁴ co⁴la⁴lagh⁵ ti²hoh⁵i³, jian³ ti²he²³i³ la⁴jeg³⁴ a²hmh³ i⁴a⁴júan⁴ A¹dor²cas³ hain⁴ liah⁴ma²sian³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ma²jon³ a⁴húan⁴³ Pe³² la⁴jang³⁴ a³hain⁴ tionh², jon³ a⁴si⁴jnei⁵i³ jian³ a⁴mh³i³ Jon⁴dai¹; jon³ ua⁵lang⁴i³, a⁴jen³i³ a³jaun² hain⁴, a⁴juah⁴i³: ―A¹ta³bi²ta³, no³ hnei³. Jon³ a⁴hoh³ a³m⁴ hain⁴ m⁴nei², i² con³ma²a⁴jen³i³ Pe³², jon³ a⁴cua⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","I² Pe³², a⁴tang⁴i³ si¹cúa³, a⁴sie⁴³i³; ma²jon³ a⁴teh³i³ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹, jian³ a³don⁵ m⁴ hnang⁴ hain⁴ tionh² liah⁴, a⁴ma⁴jnia³i³ a³m⁴ hain⁴ i⁴sian³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","I² jon³ ra⁵sia³ jau²³ jon³ la⁴tan² jeu³ Jope jon³, jian³ jeun⁴³ ra⁵hain⁴ i²con²³ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jon³ a⁴cua⁴ Pe³² úa⁴ Jope jon³, jauh³² quieh¹ jan³ a³sain³ Si²úan¹, a³lang⁴³ a²teg²³ a³júan³ a²lo³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma²sian³ jan³ a³ñih³ a³sain³ Cor³ne² jeu³ Cesarea, a³lang⁴³ jeu³² co⁴hna³ a²hlie⁴, a³teh²i³ Italiana. ");
INSERT INTO cucNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I² Cor³ne² hain⁴ ni²taih⁴³, ma³con⁴³i³ Jon⁴dai¹ jian²³i³ la⁴jang³⁴ a³tionh² jauh³² quieh¹, jian³ ma³hon³²i³ a³jeu³ Israel hlion⁴ mai²³ henh⁴ i⁴sian³i³, jian³ mh²i³ Jon⁴dai¹ la⁴jeg³⁴ nie⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","I² con³ jm² la⁴conh⁴ ni¹hneng³ ta⁵hlo⁴, sia³ con³ i⁴a⁴je³⁴i³ si¹jia⁵ o³tan², i⁴ma⁴jnia³² i²con²³i³, a⁴jen³i³ jan³ ángel quian¹ Jon⁴dai¹ a³a⁴hei³⁴ i²cua⁴³i³, a³a⁴juah⁴: ―¡Cor³ne²! ");
INSERT INTO cucNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","I² hei⁴i³ ne⁵, ta² tia⁴ a⁴je³⁴i³, jian³ to⁵o³jlen²³i³, a⁴juah⁴i³: ―¿Henh⁴ jau²³ juah²ˉ³, a³don⁵? I² jon³ a⁴juah⁴ a³hain⁴: ―Jon⁴dai¹pa² a⁴tyon²³ tsei⁴³ i²conh²ˉ³, nei² quieh¹ i⁴mh³ˉ³ i²con²³i³, jian³ la⁴jeg³⁴ i⁴tsei³⁴ i⁴ma⁵honh³²ˉ³ chie³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","I² tieh²la³ ne⁵, sain⁴³ hnei³ chie³ quianh³ teg⁴ jeu³ Jope i⁴si⁵quian⁴i³ jan³ a³sain³ Si²úan¹, a³hain⁴ a³teh²i³ Pe³² liah⁴, ");
INSERT INTO cucNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","a³cua⁴³ jauh³² quieh¹ jan³ a²teg²³ a³júan³ a²lo³ a³teh²i³ Si²úan¹ liah⁴, a³seih⁴³ a²hnei⁴³ quieh¹ quien¹i²jm¹ jm³ñih¹. I² hei⁴ pi²³i³ sag⁵ hnei³ henh⁴ hniah³ júanh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","I² con³ma²ŋah³ ángel hain⁴ a³a⁴hlenh⁴³ Cor³ne², jon³ a⁴teh³i³ on³⁴ mozo quian¹, jian³ jan³ a²hlie⁴ a³ma³con⁴³ Jon⁴dai¹, a³hein² jen² a²hlie⁴ a³cúa²³ cúa³tag³² quian¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jon³ a⁴sain⁴i³ a³hain⁴ tionh² ta⁵jeu³ Jope con³ma²a⁴tyieh³i³ a³hain⁴ jau²³ la⁴jeg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","I² con³ma²a⁴jnia³⁴, jon³ tionh²i³ jeu³ ho³²jeu³ i²ma³o¹tyie¹i³ o³tan² jeu³ jon³, jon³ a⁴eu⁴ Pe³² a²teg⁴ teun³⁴ hna³ jauh³², conh⁴ i⁵hyie³ tan², i⁴ua⁵mh²i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ta² ja³⁴ con³ i⁴ra⁵cúanh⁴³i³ i⁴i²queuh⁴³i³ a²hei⁴³; i² ta¹la⁴ ti²júan³i³ ma³⁴, jon³ a⁴je³⁴ Pe³² con³ i⁴ma⁴jnia³² i²con²³i³, ");
INSERT INTO cucNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","a⁴je³⁴i³ i⁴si¹ja⁵ ñi⁴jeu⁵, jian³ i⁴a⁴jyie³ la⁴con³ a²hmh³ júah² ni²quein⁴³ li⁵quin⁴ cua¹, ja³⁴ la⁴teg⁴ húa³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jian³ tionh² la⁴jang³⁴ nai² jah⁴ joh⁴³, jah⁴ quin⁴ cúa³tag³², jian³ la⁴jang³⁴ jah⁴ ŋeng²³ jeu³ ra³quian³ húa³⁴, jian³ jon⁴³tan²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jian³ ja³⁴ con³ jau²³, i⁴juah⁴: ―No³ Pe³², jŋangh⁴³ jah⁴ ne³, jian³ caunh⁴³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","I² Pe³² ne⁵, a⁴juah⁴i³: ―Hnei³ Se³ño²³, a⁵sia³ caunh²ˉ⁵; quie¹ i¹conh⁴ sa⁴ma³a⁴queuh³ˉ⁴ i⁴heinh⁵ la⁴ne³, jian³ o⁴ i⁴queh². ");
INSERT INTO cucNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","I² jon³ ja³⁴ jau²³ teg⁴ taun³⁴ nie⁴³, a⁴juah⁴: ―A⁵hleh³ hnei³ i⁴heinh⁵ la⁴jeg³⁴ i⁴ma³ma⁴tsei³⁴ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A⁴leg³⁴ la⁴ne³ hnang²³ nie⁴³, ma²jon³ ŋoh³ a²hmh³ júah² jon³ ñi⁴jeu⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","I² ta¹la⁴ so⁵ñi³ Pe³² liah⁴ sian³i³, i⁴si²júan³i³ co³hei²tsei³ henh⁴ hnie³⁴ ra³juah⁴ i⁴a⁴je³⁴i³ jon³, con³ a⁴la³ a⁴tyie³⁴ chie³ a³a⁴sain⁴ Cor³ne² hain⁴ tionh², a³ŋang³ jainh¹ seih⁴³ jauh³² quieh¹ Si²úan¹, jon³ a⁴tyie³⁴i³ o²hnei³² tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jon³ a⁴te⁴i³, a⁴ŋang⁴i³ o⁴ i²jon³ cua⁴³ a³sain³ Si²úan¹, a³hain⁴ a³teh²i³ Pe³². ");
INSERT INTO cucNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","I² ta¹la⁴ ua²júan³ Pe³² co³hei²tsei³ i⁴a⁴je³⁴i³ jon³, jon³ a⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³i³: ―Jeh³², on³ chie³ ma³cuan²³ a³noh³ hnei³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","I⁴jon³ no³ hnei³, jyon²³ húa³⁴, jian³ a⁵júan³ hnei³ teun³⁴ co³hei²tsei³ i⁴cúah²ˉ³ jianh²ˉ³ a³hain⁴ tionh², quie¹ jnia⁴pa² a⁴sain³⁴ a³hain⁴ ta⁵la³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ma²jon³ a⁴jyon²³ Pe³² i²tionh² chie³ a³sain² quian¹ Cor³ne² hain⁴, a⁴juah⁴i³: ―Jnia⁴pa² hain⁴ hnah⁵ˉ³ tionh²ˉ³; ¿henh⁴ nei² a⁴niah³ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","I² jon³ a⁴juah⁴ a³hain⁴ tionh²: ―Cor³ne²pa² a⁴sai⁴ jnie³², i⁴ni³teh³² jnie³² hnei³, con⁴juah⁴ heih⁴³ quieh¹ jan³ ángel tsein²³ a³ma⁴jnia³² i²con²³i³, i⁴cúah²ˉ³ jauh³² quieh¹i³, canh⁴a² nau³⁴i³ jau²³ quianh³ˉ³, a³hain⁴ a³lang⁴³ jeu³² co⁴hna³ a²hlie⁴, jian³ jan³ chie³ tsein²³ a³ma³con⁴³ Jon⁴dai¹, jian³ a³hleh² la⁴jang³⁴ a³jeu³ Israel re³ nei² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","I² jon³ ne⁵, a⁴te⁴ Pe³² ta⁵jauh³², a⁴teh³i³ a³hain⁴ tionh², jon³ a⁴jian⁴i³ con³ nai⁴³. I² con³ma²a⁴jnia³⁴ jon³, jon³ ra⁴hang³² Pe³², ŋo³⁴ jian²³ a³hain⁴ tionh², jian³ ua⁵han² co⁴meih³ si³reunh¹i³ a³tionh² jeu³ Jope jon³ jian²³i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jian³ con³ma²a⁴jnia³⁴ con³ jon³, jon³ a⁴tyie³⁴i³ je¹jeu³ Cesarea tionh², i² Cor³ne² ne⁵, ma³si²jien⁴³ quieh¹i³ tionh², jian³ tionh² chie³ a³ma³a⁴teh³i³ a³tei⁴³ jau²³ quian¹i³, jian³ ñi³reunh¹i³ hion²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","I² con³ma²a⁴tyie³⁴ Pe³² o²hnei³², jon³ ua⁵hag⁴³ Cor³ne² ua⁵hyeih³²i³, jian³ a⁴si⁴jnei⁵i³ ta⁵nei² a⁴ma⁴con⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","I² Pe³² ne⁵, a⁴sion⁴³i³, a⁴juah⁴i³: ―No³ hnei³, quie¹ chie³ lia⁴ hnei³pa² jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jian³ to⁵ti²tya²³i³ jau²³ a⁴han⁵i³ ta⁵jauh³², jian³ a⁴jen³i³ chie³ a³jeun⁴³ ti²tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","I² jon³ a⁴juah⁴ Pe³² i²con²³i³ tionh²: ―Quie¹ ñih¹ hnei³ tionh²ˉ³ i⁴eu⁴³ heinh⁵ quieh¹ jan³ judío i⁴ma⁵reunh¹i³ chie³ sang²³, jian³ o⁴ i⁴si⁵hei⁴i³ jauh³² quieh¹i³. I² Jon⁴dai¹ ne⁵, ma³a⁴he⁴i³ i²con²³ˉ⁵ i⁴sa⁴hniah³ júan¹ˉ⁴ i⁴heinh⁵ i²con²³ i¹jan³ chie³, jian³ o⁴ i⁴quenh²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","I⁴jon³ con³ma²a⁴teh⁴³ˉ³ jnia⁴ tionh²ˉ³, liah⁴ma²jon³ a⁴nia³⁴ˉ⁴, i¹con³ a⁵sie⁴³ juah³ˉ⁴ liah⁴. I² la⁴ne³ ne⁵, ŋang³⁴ˉ⁴ tieh²la³: ¿Hain³ nei² a⁴teh⁴³ˉ³ jnia⁴ tionh²ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","I² jon³ a⁴juah⁴ Cor³ne²: ―Ma³quin⁴ jm² ne³⁴ conh⁴ o²ra³ la³ ma²si²júan³⁴ˉ⁴ he², jian³ con³ma²a⁴teg⁴ ni¹hneng³ ta⁵hlo⁴, con³ma²si²mh⁵ˉ⁵ Jon⁴dai¹ jauh³² quien⁴ la³, jon³ a⁴je³⁴ˉ⁴ a⁴ma⁴jnia³² jan³ a³ñih³ ta⁵nei³⁴ˉ⁴ a³hein² con³ a²hmh³ joh¹, ");
INSERT INTO cucNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a³a⁴juah⁴: “Cor³ne², ma³a⁴nau⁴ Jon⁴dai¹ jau²³ quianh³ˉ³, jian³ ma³a⁴je³⁴i³ i⁴ma⁵honh³²ˉ³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","I⁴jon³ sain⁴³ hnei³ chie³ teg⁴ jeu³ Jope, i⁴si⁵teh²i³ Si²úan¹, a³hain⁴ a³teh²i³ Pe³², a³cua⁴³ jauh³² quieh¹ jan³ a²teg²³ a³júan³ a²lo³ a³sain³ Si²úan¹ a³cua⁴³ quien¹ jm³ñih¹. I² la⁴teg⁴i² ma³cuan²³i³, jon³ hleh⁵i³ hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","I² liah⁴ma²jon³ a⁴sain³⁴ˉ⁴ chie³ ua⁵te³i³ hnei³; i² ta² re³ ne⁵, quie¹ a⁴niah³ˉ³. Quie¹ tieh²la³ ti²tieh² la⁴jag³⁴ jnie³² ta⁵nei² Jon⁴dai¹ i²la³, jian³ i⁴nai² jnie³² jau²³ quianh³ˉ³, i⁴ma³a⁴júan⁴ Jon⁴dai¹ heih⁴³ i⁴hleh²ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","I² jon³ a⁴ma⁴lie⁵ Pe³² a⁴hleh⁴, a⁴juah⁴i³: ―I⁴chie⁴³ yan³²ˉ⁴ tieh²la³, i⁴so⁵júan³ Jon⁴dai¹ ni²hna³ chie³, ");
INSERT INTO cucNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","quie¹ co³nai² hnio³⁴i³ la⁴jang³⁴ a³tionh² ma⁵quein²³ nación, a³ma³co⁴³ quieh¹i³, jian³ a³júan³ i⁴tsei³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","I² Jon⁴dai¹ ne⁵, a⁴sain⁴i³ jau²³ tsei²³ quieh¹ i²con²³ sa¹jeun³ Israel, i⁴ua⁵hleh² jau²³ tsei²³ jon³ i⁴lain²³i³ jian²³i³ Jon⁴dai¹, con⁴juah⁴ Jesucristo, a³hain⁴ a³lang⁴³ A³tyein² quian¹ la⁴jang³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jian³ ñih¹ˉ³ tionh²ˉ³ i⁴ra⁵sia³ jau²³ nei² jon³ la⁴tan² húa³⁴ Judea, i⁴ra⁴lie⁵ Galilea, con³ma²ta⁵ma³a⁴sion⁴³ Juan²³ chie³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jau²³ jon³, jau²³ hain³liah⁴ ma⁴cúanh¹ Jon⁴dai¹ Jesús a³sian³ jeu³ Nazaret hain⁴, con⁴juah⁴ M⁴tyi⁴ quieh¹i³ jian³ i⁴hlion⁴ ua³pei⁴, jian³ hain³liah⁴ a⁴ŋeng⁴i³ a⁴júan⁴i³ i⁴tsei³⁴, jian³ i⁴a⁴huan⁴ quieh¹ la⁴jang³⁴ a³ma²ti²can²³ ma²eu⁴³ i⁴júan³ a³sa⁴tsein³⁴, quie¹ ta⁵la⁴ jian²³i³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jian³ jnie³²pa² a⁴teg⁴ nei² la⁴jeg³⁴ i⁴a⁴júan⁴ Jesús húa³⁴ Judea, jian³ je¹jeu³ Jerusalén liah⁴, a³hain⁴ a³a⁴jŋangh⁴i³ si²ton³ crau¹. ");
INSERT INTO cucNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","I² con³ma²a⁴teg⁴ hneng³ jm² jaun²i³, jon³ a⁴júan⁴ Jon⁴dai¹ i⁴a⁴hyon²³i³, jian³ i⁴ma⁴jnia³²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A⁵sia³ ma⁴jnia³²i³ i²con²³ la⁴jang³⁴ chie³, quie¹ jmah³ i²con²³ jnie³²pa², a³lang⁴³ a³tei⁴³ nei², a³a⁴quianh⁴³ Jon⁴dai¹ liah⁴ma²jia⁴³. Jnie³², a⁴quih² jnie³² jian³ a⁴hneih² jnie³² jie³ jnie³² ta⁵ma³a⁴hyon²³i³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jian³ a⁴júan⁴i³ heih⁴³ i⁴hleh² jnie³² jau²³ quieh¹i³ i²con²³ a³jeu³, jian³ i⁴si²saih³² jnie³² chie³, i⁴a⁴júan⁴ Jon⁴dai¹ i⁴lang⁴³ Jesús Júa¹ quian¹ a³sian³ jian³ a³jaun² tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jian³ a⁴hleh⁴ la⁴jang³⁴ a³sain² nei² quieh¹i³, a⁴juah⁴i³ i⁴la⁴jang³⁴ a³li⁴hain⁴ i²con²³ Cristo, jlenh⁴³ chie³² quieh¹i³ con⁴juah⁴ jm³i⁴sain³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jian³ ma²si²cúa²³ pi¹ Pe³² jau²³ ne³, con³ a⁴la³ ja³⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³ la⁴jang³⁴ a³ti²nau³ jau²³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","I² la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹ a³gm² he³² hain⁴ tionh², a³ma²a⁵han² jian²³ Pe³², ta² co³ ŋo³⁴ tsei⁴³i³ tionh², quie¹ li⁴cúa²³pa² li⁴ Jon⁴dai¹ M⁴tyi⁴ quieh¹ i²con²³ chie³ a³sa⁴lang⁴³ judío tionh², ");
INSERT INTO cucNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","quie¹ a⁴nau⁴i³ i⁴ti²hleh² a³hain⁴ jau²jm⁴³ seg³⁴, jian³ i⁴ti²júan³i³ júanh⁴³ Jon⁴dai¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","I² jon³ a⁴juah⁴ Pe³²: ―¿Hain³ li⁴hnia³⁴ juah⁴ i⁴sa⁴li⁴son⁵ a³ne³ jm³ tionh², a³ma³a⁴hyei⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ tieh²la³ liah⁴i² a⁴hyei²ˉ¹, lainh⁴ˉ³? ");
INSERT INTO cucNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ma²jon³ a⁴júan⁴ Pe³² heih⁴³, i⁴son⁵ a³hain⁴ jm³ tionh² con⁴juah⁴ jm³i⁴sain³ Re¹ Jesús. I² con³ma²a⁴leg³⁴ jon³, jon³ a⁴m⁴ a³hain⁴ tionh² i⁴jian³⁴ Pe³² úa⁴ meih³ jian²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jon³ ra⁵ñi³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹, a³tionh² húa³⁴ Judea, i⁴a⁴hyei⁴ chie³ a³sa⁴lang⁴³ judío hain⁴ tionh² jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","I² con³ma²a⁴tyanh³ Pe³² Jerusalén, jon³ a⁴jang²³i³ jian²³i³ co⁴meih³ jon²reunh¹ a³cmh² jo³² quieh¹ i⁴gm² he³²i³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","a³a⁴juah⁴: ―¿Henh⁴le³⁴ ñeih²ˉ³ jauh³² quieh¹ chie³ sa⁴gm² he³², jian³ i⁴a⁴cauh⁴³ˉ³ a²hei⁴³ jianh²ˉ³ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","I² Pe³² ne⁵, a⁴tya⁴i³ jau²³ ma⁵con³ henh⁴ a⁴leg³⁴, a⁴juah⁴i³: ");
INSERT INTO cucNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Con³ma²si²mh⁵ˉ⁵ Jon⁴dai¹ je¹jeu³ Jope, jon³ a⁴je³⁴ˉ⁴ con³ i⁴ma⁴jnia³² i²con²³ˉ⁵; a⁴je³⁴ˉ⁴ con³ a²hmh³ júah² ni²quein⁴³ li⁵quin⁴ cua¹, i⁴a⁴jyie²³ ta⁵ñi⁴jeu⁵, jian³ ja³⁴ teg⁴ hlonh²ˉ⁵. ");
INSERT INTO cucNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","I² con³ma²a⁴je³⁴ˉ⁴ re³ joh⁴³, jon³ a⁴jen³²ˉ⁴ jah⁴ a³sia³ quin⁴ cúa³tag³², jian³ a²hyah³, jian³ la⁴jang³⁴ jah⁴ ŋeng²³ jeu³ ra³quian³ húa³⁴, jian³ jon⁴³tan²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jon³ a⁴nau³⁴ˉ⁴ con³ jau²³ ho³², i⁴sag⁴³i³ jnia⁴, juah⁴i³: “Ra⁴hang³² hnei³ Pe³², jŋangh⁴³ jah⁴, jian³ caunh⁴³ liah⁴.” ");
INSERT INTO cucNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","I² jon³ a⁴jeu³⁴i³ jnia⁴: “Hnei³ Se³ño²³, a⁵sia³ caunh²ˉ⁵, quie¹ i¹conh⁴ sa⁴ma³a⁴caunh⁵ˉ⁵ a³heinh⁵ la⁴ne³, jian³ o⁴ a³quenh².” ");
INSERT INTO cucNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Conh⁴liah⁴ ja³⁴ jau²³ jon³ ta⁵ñi⁴jeu⁵ liah⁴, a²teg⁴ taun³⁴ nie⁴³ i⁴juah⁴: “A⁵hleh³ hnei³ i⁴heinh⁵ i⁴ma³ma⁴tsei³⁴ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A⁴leg³⁴ la⁴ne³ hnang²³ nie⁴³, ma²jon³ ŋoh³ la⁴jeg³⁴ i⁴jon³ ñi⁴jeu⁵ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Jian³ liah⁴ma²jon³ a⁴tyie³⁴ on³ chie³ jauh³² i²ma²cua³²ˉ⁴, a³a⁵han² i²con²³ jnia⁴ teg⁴ Cesarea. ");
INSERT INTO cucNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","I² M⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, a⁴sag⁴³i³ jnia⁴ i⁴hniah³ nai³²ˉ⁴ jian²³ˉ⁵ a³hain⁴ tionh² i⁴sa⁴júan¹ˉ⁴ teun³⁴ co³hei²tsei³, jian³ ñei² jñi⁴ si³reunh⁴ˉ¹ a³ti²tionh² la³ jian²³ˉ⁵; jon³ a⁴hei² jnie³² jauh³² quieh¹ jan³ a³ñih³, ");
INSERT INTO cucNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","a³a⁴tyie⁴ jnie³² jau²³, liah⁴ a⁴jen³i³ jan³ ángel jauh³² quieh¹, a³a⁴no³, jian³ a³a⁴juah⁴: “Sain⁴³ hnei³ chie³ quianh³ teg⁴ jeu³ Jope, i⁴si⁵quian⁴i³ jan³ a³sain³ Si²úan¹, a³hain⁴ a³teh²i³ Pe³²; ");
INSERT INTO cucNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","i² hei⁴ pi²³i³ hleh⁵ hnei³ jau²³ liah⁴ li⁴lionh⁴ˉ³, jian³ la⁴jang³⁴ a³tionh² jauh³² quianh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","I² con³ma²sa⁴ma³a⁴toh⁴ pi¹ a⁴hleh³ˉ⁴, jon³ ja³⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ i²con²³ a³hain⁴ tionh², liah⁴i² a⁴jain⁴³ jnia¹ liah⁴ma²ra⁴lie⁵. ");
INSERT INTO cucNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","I² jon³ a⁴tyon²³ tsei³⁴ˉ⁴ i⁴a⁴hleh⁴ Se³ño²³ con³ma²a⁴juah⁴i³: “Quie¹ chie⁴³pa² a⁴sion⁴³ Juan²³ chie³ jm³ con⁴juah⁴ o¹jm³, i² hnei³ tionh²ˉ³ ne⁵, jia²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹ si⁵hei⁴ naih⁵ ni²hoh⁴³ˉ³ tionh²ˉ³”, a⁴juah⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Quie¹ juah⁴ne³ la⁴ne³ a⁴cúa⁴ Jon⁴dai¹ M⁴tyi⁴ quieh¹ i²con²³ a³hain⁴ tionh², liah⁴i² a⁴cúa⁴i³ i²con²³ jnia¹ i⁴ra⁵hain⁴ˉ¹ i²con²³ Re¹ Jesucristo, ¿i² hain³ jnia⁴ ne⁵, li⁴hnia¹ˉ⁴ i²con²³ Jon⁴dai¹? ");
INSERT INTO cucNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","I² con³ma²a⁴nau⁴i³ tionh² jau²³ jon³, i¹con³ a⁵sie⁴³ i⁴juah⁴i³, quie¹ a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹, a⁴juah⁴i³: ―¡I² la⁴ne³ tieh²la³ cúa²³ Jon⁴dai¹ jeu³ i⁴sag³⁴ chie³ a³sa⁴lang⁴³ judío co³hei²tsei³ quieh¹ tionh², canh⁴a² li⁴sia³ m⁵cu³ quieh¹i³ liah⁴! ");
INSERT INTO cucNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Jian³ liah⁴, la⁴jang³⁴ a³ua⁵jan⁴ hain⁴ tionh² nei² quieh¹ i⁴a⁴hag⁴i³ liah⁴ma²a⁴jaun³⁴ Te⁴, ua⁵han²i³ tionh² la⁴teg⁴ húa³⁴ Fenicia, jian³ o⁵tyieh⁴³ Chipre, jian³ la⁴teg⁴ je¹jeu³ Antioquía, la⁴tan² jon³ a⁴hleh⁴i² jau²³ quieh¹ Jon⁴dai¹ tionh²i³, i²con²³ jmah³ chie³ judío, a⁵jon⁴³ i²con²³ chie³ sang²³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jian³ jen² chie³ a³ua⁵jan⁴ hain⁴ tionh², tionh² chie³ a³sian³ Chipre, jian³ a³sian³ jeu³ Cirene; i² con³ma²a⁴tyie³⁴i³ je¹jeu³ Antioquía, jon³ a⁴hlenh⁴³i³ chie³ griego tionh², a⁴hleh⁴i³ jau²³ tsei²³ quieh¹ Re¹ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jian³ hlion⁴ ma⁴ho³² Jon⁴dai¹ quieh¹i³ tionh², i⁴ra⁵hain⁴ jeun⁴³ chie³, a³a⁴can³⁴ jeu³ quieh¹ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I² jon³ ra⁵ñi³ cuah³ a³tionh² Jerusalén jau²³ i⁴si³lei⁴ jon³, jon³ a⁴sain⁴i³ Be²³ teg⁴ Antioquía. ");
INSERT INTO cucNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","I² con³ma²a⁴tyie³⁴i³, a⁴je³⁴i³ la⁴conh⁴ tei⁴³ i⁴júan³ Jon⁴dai¹, jian³ ta² a⁴leg³⁴ si³hyonh³i³. Jon³ a⁴hlenh⁴³i³ la⁴jang³⁴ i⁴júan³⁴i³ con³ co³hei²tsei³ i⁴ma⁴tei⁵i³ i²con²³ Se³ño²³ i⁴sa⁴teinh⁴³ tsei⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Quie¹ lang⁴³ Be²³ jan³ chie³ tsein²³, jian³ a³quian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹, jian³ i⁴hlion⁴ hain⁴i³ liah⁴. I⁴jon³ ta² jeun⁴³ chie³ ra⁵hain⁴ i²con²³ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Con³ma²a⁴leg³⁴ jon³, jon³ ŋo³⁴ Be²³ ta⁵jeu³ Tarso, ua⁵hniah³i³ Saulo; i² con³ma²a⁴chianh¹i³, jon³ te¹i³ ta⁵jeu³ Antioquía, ");
INSERT INTO cucNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","i²a⁴cua⁴i³ tionh² ta¹la⁴ con³ ñi³, i⁴a⁴ŋangh³i³ jian²³ cuah³, jian³ i⁴a⁴heh³i³ jeun⁴³ chie³. Jian³ je¹jeu³ Antioquía jon³ ra⁴lie⁵ teh²i³ chie³ quian¹ Jon⁴dai¹, juah⁴ chie³ tionh², chie³ quian¹ Cristo. ");
INSERT INTO cucNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jian³ jm² jon³ a⁵han² meih³ a³hleh² jau²³ quieh¹ Jon⁴dai¹, a³ma²tionh² Jerusalén, a³a⁴tyie³⁴ Antioquía. ");
INSERT INTO cucNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","I² jon³ ra⁴hang³² jan³ jen² a³hain⁴ tionh², jan³ a³sain³ Agabo, a³hleh² jau²³ i⁴cúa²³ M⁴tyi⁴ quieh¹ Jon⁴dai¹, a³a⁴juah⁴ i⁴jia²³ ho³²cúan⁴ pain⁴ la⁴tan² m⁵cu³; i² jau²³ ne³ ra⁵tei⁴³ con³ma²lang⁴³ Claudio gobierno. ");
INSERT INTO cucNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","I² chie³ quian¹ Jon⁴dai¹ a³tionh² i²jon³, a⁴júan⁴i³ re³ i⁴ma⁵hon³²i³ si³reunh¹ a³tionh² húa³⁴ Judea conh⁴ sia³ quieh¹ con⁴jan³. ");
INSERT INTO cucNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","I² jon³ a⁴júan⁴i³ la⁴jon³, jian³ a⁴sain⁴i³ o¹cau³² jon³ i²con²³ a³ti²quian³ ma³tyi² cuah³ húa³⁴ Judea, i⁴ni²can³ Be²³ jian²³ Saulo. ");
INSERT INTO cucNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Jian³ jm² jon³ liah⁴, a⁴sanh³ re¹ Herodes co⁴meih³ chie³ quian¹ Jon⁴dai¹ i⁴a⁴júanh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jian³ a⁴jŋangh⁴i³ Jacobo reunh¹ Juan²³ jeu³ a²ñi²tag⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","I² con³ma²a⁴je³⁴i³ a⁴teg⁴ tsei⁴³ judío tionh², jon³ a⁴sanh³i³ Pe³² liah⁴. I² jm² jon³, jm² i⁴queuh³i³ a²hei⁴³ñih¹ i⁴sa⁴hei¹ o¹sieh³². ");
INSERT INTO cucNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","I² con³ma²a⁴júan⁴i³ chion³², jon³ a⁴tonh³i³ ni⁴ñi²³, jian³ a⁴cúanh³i³ joh⁴³ cúa³ quin⁴ hna³ a²hlie⁴, a³leg⁴³ ma⁵quin⁴ conh⁴ hna³, canh⁴a² hie⁵i³. Quie¹ a⁴júan⁴ re¹ co³hei²tsei³ i⁴tyei⁵i³ ta⁵nei² a³jeu³ i⁴queih³i³ heih⁴³ i²con²³i³, tei⁴³i² ma³a⁴cúah³ jm² i⁴a⁴lon⁴ a³jeu³ Israel húa³⁴ Egipto jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","I² la⁴ne³ ti²hion⁴³i³ Pe³² ni⁴ñi²³; i² la⁴jang³⁴ cuah³ ne⁵, ti²mh²i³ Jon⁴dai¹ nei² quieh¹ Pe³² liah⁴sa⁴jian²³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","I² con³ma²a⁴teg⁴ jm² i⁴ma²tyei⁴³ Herodes quieh¹ Pe³², i² je¹nai³ jon³ ne⁵, ma²ra³cm² Pe³² jen² on³⁴ a²hlie⁴, jian³ re³ ra³hñi⁴³i³ teun³⁴ a²ca³den², jian³ tionh² a²hlie⁴ ti²hie³ o²hnei³² ni⁴ñi²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","I² con³ a⁴la³ ma⁴jnia³² jan³ ángel quian¹ Se³ño²³, jian³ ra⁵joh¹ la⁴tan² jauh³² ni⁴ñi²³ jon³, jon³ a⁴ñei³i³ Pe³², a⁴toh³i³ si¹cúa³ je¹úan³ta²³, a⁴juah⁴i³: ―¡Co⁴seih⁴³ no³ ta¹tia⁴! I² jon³ a⁴sagh⁴³ a²ca³den² ma²ti²hñei⁴³ si¹cúa³i³, ");
INSERT INTO cucNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","jian³ a⁴sagh⁴³i³: ―Co³re³ hñih³² hnei³ a²cúanh³, jian³ tienh³ hnei³ a²lo³ tagh¹. Ma²jon³ a⁴júan⁴i³ la⁴jon³, jian³ a⁴juah⁴ pi¹ ángel liah⁴: ―Jian³ heu²³ hnei³ a²hmh³ tsei²³ coh⁵ quianh³, jian³ nia³ hnei³ coh⁵cah³ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jon³ ŋo³⁴i³ coh⁵cah³², ua⁵hag⁴³i³; i² hei⁴i³ ne⁵, sa⁴ñi³i³ o⁴ i⁴chie⁴³ júan³ ángel la⁴ne³, lain⁴i³. Quie¹ lain⁴i³ je²³i³ con³ i⁴ma⁴jnia³² i²con²³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","I² con³ma²ua⁴jeun³²i³ co⁴hna³ jian³ a²teg⁴ teun³⁴ i²ti²hie³ a²hlie⁴ hain⁴, jon³ a⁴tyie³⁴i³ la⁴teg⁴ o²hnei³² júah¹ leg⁴³ a²ñi²³ i⁴quieh¹ jeu³júan²³, i² jon³ a⁴na⁴ o²hnei³² jon³ hña³. Jon³ a⁴húan³i³ tionh², jon³ ua⁴jeun³²i³ con³ jeu³júan²³, i² con³ma²ua⁴jeun³²i³ jon³, jon³ a⁴tai³⁴ ángel quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","I² con³ma²a⁴hoh³ nei² Pe³² re³, jon³ a⁴juah⁴i³: ―Tieh²la³ yan³²ˉ⁴ i⁴chie⁴³ a⁴sain⁴ Se³ño²³ ángel quian¹, i⁴a⁴lie³i³ jnia⁴ joh⁴³ cúa³ Herodes, jian³ la⁴jeg³⁴ i⁴ma²hnie³⁴ a³jeu³ judío ma²jain⁴³ jnia⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","I² con³ma²ra⁵laih²i³ nei² ne³, jon³ a⁴tyie³⁴i³ jauh³² quieh¹ a³don⁵ Ma³rei² sie²³ Juan²³, a³hain⁴ a³teh²i³ Marcos liah⁴, i²ti²ŋangh³ jeun⁴³ chie³ a³ti²mh² Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","I² con³ma²a⁴te⁴ Pe³² o²hnei³² quieh¹ jeu³júan²³, jon³ ua⁵hag⁴³ jan³ a³m⁴ peih¹ a³sain³ A¹ro²de³, ua⁵jen³²i³ hain³ si²te²³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","I² con³ma²ra⁵cuh²i³ ho³² Pe³², ta² si³hyonh³i³ a⁴leg³⁴, jon³ a⁵sia³ o²hnei³² ñeih³² a⁴nia³⁴i³, quie¹ ŋah³i³ jeu³ra³tyi⁴ ua⁵con²³i³ jau²³ i⁴si²te²³ Pe³² o²hnei³². ");
INSERT INTO cucNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","I² a⁴juah⁴ a³hain⁴ tionh² ne⁵: ―¡A¹ sa⁴ŋoh⁴³ˉ³, liah²! I² a³m⁴ peih¹ hain⁴ ne⁵, a⁴juah⁴i³ i⁴chie⁴³pa². I² a³hain⁴ tionh² a⁴juah⁴ liah⁴: ―¡A¹ sa⁴ ángel quian¹i³, liah²! ");
INSERT INTO cucNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","I² Pe³² ne⁵, liah⁴ma³si²te²³ jon³ pi²³i³. I² con³ma²a⁴nia³⁴i³ o²hnei³², jon³ a⁴jen³i³, ta² co³ ŋo³⁴ tsei⁴³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","I² con³ma²a⁴júan⁴ Pe³² si¹cúa³ i⁴han⁵ a³hain⁴ tai³² tionh², jon³ a⁴tya⁴i³ jau²³, liah⁴ a⁴lie³ Se³ño²³ quieh¹i³ ma²hein²i³ ni⁴ñi²³, jian³ a⁴juah⁴i³ liah⁴: ―Cua³ ua⁴saih³² Jacobo, jian³ la⁴jang³⁴ si³reunh⁴ˉ¹ tionh². Jian³ ma²jon³ ua⁵hag⁴³ Pe³², ŋo³⁴i³ ta⁵seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Jian³ con³ma²a⁴jnia³⁴ jon³, ta² a⁴júan⁴ a²hlie⁴ hain⁴ ti³jan²³ tionh², i⁴so⁵ñi³i³ liah⁴ sian³i³ tionh² nei² quieh¹ hain³liah⁴ a⁴jainh⁴³ Pe³². ");
INSERT INTO cucNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","I² re¹ Herodes ne⁵, con³ma²a⁴hnah³i³ re³ jian³ sa⁴a⁴chianh¹i³, jon³ a⁴júan⁴i³ heih⁴³ i⁴jŋangh³i³ a²hlie⁴, con³ma²ta⁵ma³a⁴ŋang⁴i³ i²con²³i³ tionh². I² con³ma²a⁴leg³⁴ jon³, jon³ ua⁵hag⁴³ re¹ húa³⁴ Judea, ŋo³⁴i³ ta⁵jeu³ Cesarea i²a⁴cua⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","I² jon³ ne⁵, ta² jain²³ tsei⁴³ re¹ Herodes hain⁴ jian²³ a³tionh² jeu³ Tiro, jian³ jeu³ Sidón; i² jon³ a⁴júan⁴i³ re³ tionh² i⁴ma⁵jnia³²i³ ta⁵nei² re¹. Jon³ a⁴m⁴i³ i⁴tyan⁴³ hnai³qui³, con³ma²a⁴cúa⁴i³ o¹cau³² i²con²³ Blasto, a³lang⁴³ jan³ a³cúa²³ cúa³tag³² quian¹ re¹, a³tyein², quie¹ ta⁵la⁴ jia²³ i⁴queuh³ a³hain⁴ tionh² jeu³ i²júan³ re¹ heih⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","I² con³ma²a⁴teg⁴ jm² ton³, jon³ a⁴cua⁴ re¹ a²ma³sei² tyein² quieh¹, hein²i³ a²hmh³ jlanh² quieh¹ re¹; i² jon³ a⁴hleh⁴i³ jau²³ i²con²³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","I² jon³ a⁴juah⁴ a³jeu³ tionh², a⁴hleh⁴i³ tia⁴: ―¡Jau²³ ho³² Jon⁴dai¹pa² ne³ ti²nai⁴ˉ¹, a⁵jon⁴³ jau²³ quieh¹ chie³! ");
INSERT INTO cucNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Con³ a⁴la³ a⁴júanh¹ jan³ ángel quian¹ Se³ño²³ quieh¹ re¹, quie¹ sa⁴a⁴júan⁴i³ júanh⁴³ Jon⁴dai¹, i⁴jon³ a⁴jaun³⁴i³ a⁴jie⁴ a²jah³². ");
INSERT INTO cucNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","I² jau²³ quieh¹ Se³ño²³ ne⁵, tsei³⁴sa² ua⁵cúan³, jian³ jeun⁴³ ra⁵hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jian³ con³ma²ra⁵tei⁴³ ta¹ i⁴ma²a⁴quien³ cuah³ quieh¹ Be²³ jian²³ Saulo Jerusalén jon³, jon³ ŋah³i³ liah⁴ Antioquía tionh², jian³ jian³i³ Juan²³, a³hain⁴ a³teh²i³ Marcos. ");
INSERT INTO cucNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","I² jon³ ne⁵, ma²tionh² a³hleh² jau²³ quieh¹ Jon⁴dai¹, jian³ a³lang⁴³ teg²³, cuah³ Antioquía: Be²³, jian³ Si²úan¹, a³hain⁴ a³teh²i³ A³lianh⁴³ liah⁴, jian³ Leu² a³sian³ jeu³ Cirene, jian³ Manaén a³a⁴cúan³⁴ jian²³ si²mah⁴ tyein² Herodes, jian³ Saulo liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Con³ jm², con³ma²ti²ma³con⁴³i³ Jon⁴dai¹, jian³ ma²ti²júan³i³ he² i⁴sa⁴queuh³i³, jon³ a⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹: ―Canh⁴ sainh⁴ hnei³ Be²³ jian²³ Saulo, a³ma³a⁴hnah³²ˉ⁴ a³si⁵júan⁴ ta¹ quien⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","I² con³ma²a⁴júan⁴i³ he², jian³ i⁴a⁴mh³i³ Jon⁴dai¹, jon³ a⁴sanh³i³ ma³tyi² a³hain⁴, ma²jon³ a⁴sai⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","I² hei⁴i³ tionh² ne⁵, a⁴sai⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quieh¹i³, ŋo³⁴i³ ta⁵jeu³ Seleucia, jian³ jeu³ jon³ a⁴can³⁴i³ a²úan⁴³, ŋo³⁴i³ o⁵tyieh⁴³ Chipre. ");
INSERT INTO cucNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","I² con³ma²a⁴tyie³⁴i³ Salamina, jon³ a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ la⁴jeg³⁴ cuah³ judío. Jian³ jian³i³ Juan²³ hain⁴ a³ma³ho³² quieh¹i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","I² con³ma²a⁴han³i³ la⁴tan² o⁵tyieh⁴³ jon³, liah⁴i² a⁴tyie³⁴i³ jeu³ Pafos, i²jon³ a⁴jainh³i³ jan³ judío a³júan³ ta¹ i³nah², a³sain³ Barjesús, a³juah⁴ hleh² jau²³ quieh¹ Jon⁴dai¹, a³ta³jaun²³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jian³ ma²cua⁴³i³ jian²³ si²mah⁴ tyein² a³sain³ Se² Pa³², jan³ chie³ a³ŋang⁴. I² jon³ a⁴te⁴ si³ta¹ hain⁴ quieh¹ Be²³ jian²³ Saulo, i⁴hnie³⁴i³ nau³⁴i³ jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","I² a³júan³ ta¹ i³nah² hain⁴, a³teh²i³ Elimas jau²³ griego, ma²hnia²³i³ i²con²³ a³hleh² jau²³ quieh¹ Jon⁴dai¹ hain⁴ tionh², i⁴sa⁴hnie³⁴i³ li⁴hain⁴ si³ta¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","I² Saulo ne⁵, a³hain⁴ a³teh²i³ Pa³² liah⁴, hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ quian³i³, jon³ a⁴jen³i³ a³hain⁴ tia⁴, ");
INSERT INTO cucNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","a⁴juah⁴i³: ―¡Hnei³ chie³ a³ma³can³ chie³, a³júan³ la⁴jeg³⁴ nai² i⁴hlagh³², a³jon⁴³ a³sa⁴tsein³⁴, a³sa⁴jaih¹ la⁴jeg³⁴ i⁴tsei³⁴! ¿E⁴le³⁴ sa⁴i²teinh³²ˉ³ hoh⁴³ i⁴hniah³ˉ³ jeu³ tsei²³ quieh¹ Se³ño²³? ");
INSERT INTO cucNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","I² tieh²la³ ne⁵, he³⁴ Se³ño²³ ma²eu⁴³ i²conh²ˉ³, i¹ hyie³ so⁵jnia⁴ jeh²ˉ³ lei⁴ úa⁴ meih³. I² liah⁴ma²jon³ a⁴au³ m⁴nei²i³, sainh⁴³i³ la⁴con³ je¹nai³ liah³, jon³ a⁴hnah³i³ a⁵la³ a⁵jno³ a³sanh³ si¹cúa³i³, a³ua⁵jo³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","I² con³ma²a⁴je³⁴ si²mah⁴ hain⁴ i⁴a⁴leg³⁴ jon³, jon³ ra⁵hain⁴i³ i⁴co³ jainh⁴³i³ jau²³ quieh¹ Se³ño²³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","I² jon³ a⁴húan³i³ jeu³ Pafos jon³ tionh², Pa³² jian³ la⁴jang³⁴ a³jian²³i³, a⁴han⁵i³ joh⁴³ a²úan⁴³, ŋo³⁴i³ ta⁵jeu³ Perge húa³⁴ Panfilia; i² con³ma²a⁴tyie³⁴i³ i²jon³, jon³ a⁴ton³⁴ Juan²³ hain⁴ quieh¹i³ tionh², ŋah³i³ ta⁵ Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","I² con³ma²a⁴húan³i³ jeu³ Perge, jon³ a⁴tyie³⁴i³ jeu³ Antioquía, húa³⁴ Pisidia. I² jon³ ŋo³⁴i³ cuah³ judío con³ jm² sa⁴júan³i³ ta¹, i²jon³ a⁴cua⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","I² con³ma²a⁴heg⁴i³ ma²jyi³ quieh¹ lai²³, jian³ ma²jyi³ i⁴a⁴sag⁴ a³sain² tionh², jon³ a⁴sain⁴ a³ti²quian³ ma³tyi² quian¹ cuah³ hain⁴ jau²³ i²con²³i³ tionh², juah⁴i³: ―Hnei³ tionh²ˉ³ goh³ quian³⁴ˉ⁴, a¹juah⁴ne³ sia³ con³ jau²³ i⁴hleh³²ˉ³ jnie³², hleh² hnei³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","I² con³ma²a⁴no³ Pa³², jon³ a⁴júan⁴i³ lei³ jeu³ si¹cúa³ i⁴han⁵ a³hain⁴ tai³² tionh², jon³ a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ sa¹jeun³ Israel, jian³ la⁴jangh³ hnei³ a³ma³con⁴³ Jon⁴dai¹, nai³ hnei³ tionh²ˉ³ re³ i⁴hleh¹ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Jon⁴dai¹ quian¹ chie³ Israel tionh² a⁴quianh⁴³i³ jmai³sie²³ˉ¹ a³sian³ ya⁴jo³⁴, jian³ a⁴sionh³i³ a³jeu³ hain⁴ ta⁵yeih³², con³ma²tionh²i³ húa³⁴ Egipto i⁴lang⁴³i³ a³sian³ ta⁵seg³⁴; ma²jon³ a⁴húan⁴³i³ a³hain⁴ tionh² con⁴juah⁴ ua³pei⁴ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jian³ ta¹la⁴ conh⁴ to⁴lo⁵ ñi³ ra⁵júanh³ tsei⁴³ Jon⁴dai¹ jian²³ a³hain⁴ tionh² i²a⁵sian⁴³ a³sian³ jon³, ");
INSERT INTO cucNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","jian³ con³ma²ma⁴tyan³ Jon⁴dai¹ quie³⁴ nación chie³, a³ma²tionh² húa³⁴ Canaán jon³, jon³ a²ma⁴ a⁴cúah³i³ húa³⁴ jon³ i²con²³ a³jeu³ quian¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Jian³ coh⁵ jon³, jon³ a⁴cúan⁴³ júa¹ a³a⁴júan⁴ heih⁴³ i²con²³ a³jeu³, ta¹la⁴ quin⁴ nia⁴lo⁴ ni²tsei¹ to⁴lo⁵quia⁴ ñi³, liah⁴i² cuan³⁴ Samuel a³sain² quian¹ Jon⁴dai¹ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","I² ma²jon³ a⁴m⁴³i³ re¹ tionh², ma²jon³ a⁴cúan⁴³ Jon⁴dai¹ jan³ re¹ a³sain³ Sa³u²³ i²con²³i³ tionh², a³jon⁴³ Cis, a³a⁴júan⁴ heih⁴³ ta¹la⁴ to⁴lo⁵ ñi³, a³lang⁴³ sa¹jeun³ Benjamín. ");
INSERT INTO cucNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jian³ con³ma²a⁴tyein³ Jon⁴dai¹ Sa³u²³ hain⁴, jon³ a⁴hen⁴³i³ Da³vei²³ a³a⁴lang³⁴ re¹, a³hain⁴ a³a⁴hleh⁴ Jon⁴dai¹ nei² quieh¹ i⁴juah⁴i³: “Ma³a⁴chianh³²ˉ⁴ jan³ a³júan³⁴ liah⁴ teg³ tsei³⁴ˉ⁴ jian³ a³ma⁴tei⁵ heih⁴³ quien⁴ˉ⁴, Da³vei²³ jon⁴³ Isaí.” ");
INSERT INTO cucNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jian³ con⁴juah⁴ jau²³ ho³² Jon⁴dai¹ a⁴sain⁴i³ Jesús hain⁴, a³lang⁴³ sa¹jeun³ quieh¹ Da³vei²³ i⁴lain⁴i³ A³lion³ a³jeu³ Israel. ");
INSERT INTO cucNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","I² naih⁵i² ma⁵jnia³²i³ ne⁵, a⁴hleh⁴ Juan³ Tei³² jau²³ i⁴sag²³i³ co³hei²tsei³, i²con²³ la⁴jang³⁴ a³jeu³ Israel, jian³ a⁴sion⁴³i³ chie³ jm³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","I² con³ma³o¹tieh⁴ ta¹ quieh¹i³, jon³ a⁴juah⁴i³: “¿Hain³ chianh² jnia⁴ lainh⁴ˉ³ tionh²ˉ³? Quie¹ a⁵hei⁴³ jnia⁴ A³ya⁴lion³² Chie³ hain⁴; quie¹ coh⁵ ne³pa² ja³⁴ a³hain⁴ a³sa⁴haih¹ li⁴saih²ˉ⁵ a²lo³ tsei²³ tag³² i⁴tyi¹ˉ⁴.” ");
INSERT INTO cucNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Hnei³ tionh²ˉ³ goh³ quian³⁴ˉ⁴, a³langh⁴³ˉ³ sa¹jeun³ A³brang²³, jian³ la⁴jangh³ hnei³ a³ma³con⁴³ Jon⁴dai¹, i²conh² hnei³pa² tionh²ˉ³ a⁴sain⁴ Jon⁴dai¹ jau²³ i⁴lion³i³ chie³ la³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Quie¹ la⁴jang³⁴ a³tionh² Jerusalén, jian³ la⁴jang³⁴ si³ta¹ quian¹ i²jon³, sa⁴ra⁵cm²³i³ hain³ Jesús, jian³ a⁵ga⁴ ra⁵ŋang⁴i³ jau²³ i⁴a⁴sag⁴ a³sain² tionh², i⁴jon³ i⁴heg³i³ la⁴jeg³⁴ jm² sa⁴júan³i³ ta¹, quie¹ a⁴júan⁴i³ i⁴ra⁵tei⁴³ jau²³ jon³ con³ma²a⁴queih³i³ heih⁴³ i⁴jaun⁴ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ua²liah⁴a² i¹con³ chie³² sa⁴a⁴chieh¹i³ i⁴li⁴jaun⁴ Jesús, a⁴mh³i³ Pilato ton³²nie⁴³ i⁴jaun⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","I² con³ma²ra⁵tei⁴³ la⁴jeg³⁴ i⁴ti²hleh² nei² quieh¹i³, jon³ a⁴jyon³i³ ton³ crau¹, ma²jon³ ni²quion³i³ to³ quieh¹ a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","I² Jon⁴dai¹ ne⁵, a⁴júan⁴i³ i⁴a⁴hyon²³i³ jen² a³jaun². ");
INSERT INTO cucNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jian³ hlion⁴ nie⁴³ ma⁴jnia³²i³ i²con²³ a³ma²ŋeng²³ jian²³i³ húa³⁴ Galilea, jian³ i⁴ua⁵han²i³ Jerusalén jian²³i³; i² a³hain⁴ tionh² lang⁴³ a³tei⁴³ nei² i⁴jon³, a³hleh² nei² jon³ i²con²³ a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Jian³ jnie³² liah⁴, hlenh⁵ jnie³² hnei³ tionh²ˉ³ jau²³ tsei²³ jon³, i⁴leg⁴³ jau²³ ho³² Jon⁴dai¹ i⁴a⁴cúa⁴i³ i²con²³ jmai³sie²³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jian³ a⁴ma⁴tei⁵ Jon⁴dai¹ jau²³ ho³² jon³ i²con²³ jnia¹, a³lang⁴³ sa¹jeun³ quian¹ a³hain⁴ tionh², con³ma²a⁴júan⁴i³ i⁴a⁴hyon²³ Jesús, liah⁴i² ra³sag² ma²jyi³ salmo teun³⁴: “Hnei³pa² langh⁴³ a³jon³⁴ˉ⁴; ne³⁴pa² a⁴cúa³⁴ˉ⁴ m⁵cu³ quianh³ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","I² nei² quieh¹ i⁴a⁴júan⁴i³ i⁴a⁴hyon²³i³ jen² a³jaun² i⁴so⁵legh⁴ ua²a⁴jaun³⁴i³, jon³ a⁴juah⁴i³ la⁴la³: “Tieh²la³ a⁴júan³⁴ˉ⁴ i⁴tsei³⁴ tsei³⁴ˉ⁴ i²conh²ˉ³ tionh²ˉ³ liah⁴i² ma³a⁴jeu³⁴ˉ⁴ Da³vei²³.” ");
INSERT INTO cucNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jian³ ra³hleh² i²con³ salmo la⁴la³ liah⁴: “Sa⁴cúah²ˉ³ i⁴hliah⁴ he³² a³hain⁴ a³ma⁴cúanh¹ˉ³.” ");
INSERT INTO cucNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Quie¹ i⁴chie⁴³pa² a⁴jaun³⁴ Da³vei²³, jian³ a⁴hon³⁴i³ liah⁴i² hon²³ la⁴jang³⁴ jmai³sie²³i³, jian³ a⁴hliah³ he³²i³ liah⁴, con³ma²ta⁵ma³a⁴cúa⁴i³ cúa³tag³² i²con²³ a³jeu³ liah⁴ teg³ tsei⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","I² a³hain⁴, a³a⁴júan⁴ Jon⁴dai¹ i⁴a⁴hyon²³i³ jen² a³jaun² ne⁵, a⁵sia³ he³²i³ a⁴hliah³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","I⁴jon³ hniah³ li⁴ñih¹ hnei³ tionh²ˉ³, goh³ quian³⁴ˉ⁴, i⁴con⁴juah⁴ Jesús pa² jlenh⁴³ chie³² quieh¹ chie³, i⁴hleh³ jnie³² tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Quie¹ con⁴juah⁴ hei⁴ pi²³i³, la⁴jang³⁴ a³hain⁴ i²con²³i³, ma³a⁴jlenh³ chie³² quieh¹i³, la⁴jeg³⁴ i⁴sa⁴ma²li⁴jlenh⁴³ quianh³ˉ³ con⁴juah⁴ lai²³ quieh¹ M³se²³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Júan² hnei³ jianh³ˉ³ tionh²ˉ³ liah⁴, con³na¹a⁴jainh⁴³ˉ³ liah⁴i² a⁴hleh⁴ a³sain²: ");
INSERT INTO cucNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Jeh³², hnei³ a³ji³ŋang⁴ tionh², ua²tyie⁴ co³ hoh⁴³ˉ³ jian³ ua²yi⁴hainh⁴ˉ³; quie¹ júan¹ˉ⁴ con³ i⁴co³ jnia⁴ jm² i⁴sianh³ˉ³ tionh²ˉ³, con³ i⁴co³ jnia⁴, i⁴sa⁴li⁴hainh⁴ˉ³ tionh²ˉ³, ua²liah⁴a² tyie²³i³ hnei³ jau²³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","I² con³ma²a⁴húan³ Pa³² jian²³ Be²³ cuah³ judío, jon³ a⁴m⁴ chie³ sang²³ hain⁴ tionh² i²con²³i³, i⁴hleh³i³ jau²³ ne³ i²jña³⁴ jm², jm² sa⁴júan³i³ ta¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","I² con³ma²a⁴jenh³ a³ma²tionh² cuah³, i⁴jon³ jeun⁴³ judío jian³ a³a⁴lang³⁴ judío con³ma²ma³don⁵ a³ma³con⁴³ Jon⁴dai¹ Jmai³, a⁴ma⁴reunh¹i³ Pa³² jian²³ Be²³. A³hain⁴ a³a⁴hleh⁴³ quieh¹i³ tionh² i⁴sa⁴teinh⁴³ tsei⁴³i³ jau²³ nei² quieh¹ i⁴tsei³⁴ tsei⁴³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jian³ con³ma²a⁴tyie³⁴ jm² sa⁴júan³i³ ta¹ liah⁴, jon³ a⁴ŋangh³ a³jeu³ meih³i² la⁴jang³⁴ tionh², i⁴nau³⁴i³ jau²³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","I² con³ma²a⁴je³ judío tionh², a⁴jen³i³ chie³ jeun⁴³ hain⁴, ta² a⁴jain³⁴ tsei⁴³i³, a⁴juah⁴i³ i⁴sa⁴chie⁴³ jau²³ i⁴hleh² Pa³², jian³ a⁴hleh⁴i³ jau²hlagh³² nei² ne³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","I² Pa³² jian²³ Be²³ ne⁵, a⁴hlenh⁴³i³ a³hain⁴ tionh² i⁴sa⁴jieh⁴ tsei⁴³i³, juah⁴i³: ―I⁴chie⁴³pa² ma²hniah³ ma²hleh² jnie³² jau²³ quieh¹ Jon⁴dai¹ i²conh² hnei³ tionh²ˉ³ ñeih³²jia⁴³; i² nei² quieh¹ i⁴sa⁴hyeih³ˉ³ ne⁵, jian³ i⁴ma⁵jniah³²ˉ³ i⁴sa⁴haih¹ li⁴sia³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quianh³ˉ³, jeh³², tieh²la³ chie² jnie³² i²con²³ chie³ sang²³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Quie¹ la⁴ne³ a⁴júan⁴ Se³ño²³ heih⁴³ i²con²³ jnie³², i⁴a⁴juah⁴i³: A⁴júan³⁴ˉ⁴ i⁴langh⁴³ˉ³ joh¹ quieh¹ a³sa⁴lang⁴³ judío tionh², canh⁴a² júanh²ˉ³ i⁴lion⁴ chie³ a³tionh² la⁴tan² m⁵cu³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","I² con³ma²a⁴nau⁴ la⁴jang³⁴ chie³ sang²³ hain⁴ tionh² jau²³ ne³, ta² si³hyonh³i³ a⁴leg³⁴, jian³ a⁴júan⁴i³ júah³ jau²³ quieh¹ Se³ño²³; i⁴jon³ ra⁵hain⁴ la⁴jang³⁴ a³ma³ra³quianh² a³li⁴sia³ m⁵cu³ sa⁴ton³ jm² ua²tya⁴³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","I⁴jon³ ra⁵sia³ jau²³ quieh¹ Se³ño²³ la⁴tan² húa³⁴ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","I² la⁴jang³⁴ judío a³tionh² jeu³ jon³, a⁴jaih³i³ la⁴jang³⁴ a³m⁴ jlanh² a³ma³con⁴³ Jon⁴dai¹ Jmai³, jian³ la⁴jang³⁴ a³ñih³ tyein² a³tionh² jeu³ jon³, a⁴hang⁴i³ Pa³² jian²³ Be²³, a⁴húan⁴³i³ jeu³ co²³. ");
INSERT INTO cucNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","I² Pa³² jian²³ Be²³ ne⁵, a⁴poh³i³ o¹hlie³ ti²quin⁴³ tag³²i³ i⁴júan³ lei³ i⁴sa⁴jaih¹ a³hain⁴ tionh², jon³ ua⁵han²i³ ta⁵jeu³ Iconio. ");
INSERT INTO cucNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","I² chie³ quian¹ Jon⁴dai¹ ne⁵, ta² hlion⁴ mai²³ si³hyonh³i³ tionh², jian³ hlion⁴ ua³pei⁴ quieh¹ M⁴tyi⁴ quieh¹ Jon⁴dai¹ ti²quian³i³ tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Jian³ jeu³ Iconio jon³ liah⁴, a⁴han⁵i³ cuah³ judío co⁴chia³, i²a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ i⁴co³ naih⁵, i⁴jon³ jeun⁴³ judío ra⁵hain⁴, jian³ chie³ griego liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","I² judío a³sa⁴hain⁴ hain⁴ tionh² ne⁵, a⁴jaih³i³ chie³ sang²³ i⁴a⁴cúah³i³ co³hei²tsei³ hlagh³², i⁴hion²³i³ chie³ quian¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","I⁴jon³ a⁴jian⁴i³ i²jon³ tionh² úa⁴ meih³, a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ i⁴sa⁴jieh⁴ tsei⁴³i³, i⁴hain³² tsei⁴³i³ i²con²³ Se³ño²³, a³ma⁴jnia³ i⁴chie⁴³ jau²³ quieh¹ nei² quieh¹ i⁴tsei³⁴ tsei⁴³i³, i⁴a⁴júan⁴i³ i⁴lei⁴ hlion⁴ ua³júah² co³ jnia⁴ con⁴juah⁴ hei⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","I² chie³ a³tionh² jeu³ jon³ ne⁵, tionh²i³ ma⁵quein²³ co³hei²tsei³, ca³chion²³ tionh² jo³² quieh¹ judío, jian³ ca³chion²³ tionh² jo³² quieh¹ chie³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo. ");
INSERT INTO cucNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","I² jon³ ra⁴hang³² judío jian²³ chie³ sang²³, jian³ si³ta¹ quian¹i³ liah⁴, hnie³⁴i³ júanh¹i³ chie³ quian¹ Jon⁴dai¹ i⁴quinh⁵i³ m⁴caun². ");
INSERT INTO cucNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","I² hei⁴i³ ne⁵, con³ma²ra⁵ñi³i³, jon³ a⁴cm⁴i³ ta⁵jeu³ Listra jian³ jeu³ Derbe, i⁴nie⁴³ húa³⁴ Licaonia, jian³ la⁴tan² hloh³² jon³; ");
INSERT INTO cucNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","jon³ a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","I² jon³ ne⁵, jeu³ Listra jon³, ma²ua²cua⁴³ jan³ a³ñih³ a³si¹jeu⁴ a³leg⁴³ tag³², a³lo³ liah⁴ma²ra⁵sian³, jian³ i¹conh⁴ sa⁴ma³a⁴ŋeng⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jon³ a⁴nau⁴i³ jau²³ i⁴hleh² Pa³², jon³ a⁴je³ Pa³² quieh¹i³ tia⁴, jian³ ra⁵laih²i³ i⁴hain⁴ a³hain⁴ hlion⁴ i⁴li⁴huan⁴ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jon³ a⁴hleh⁴i³ tia⁴, a⁴juah⁴i³: ―¡Ra⁴hang³² hnei³, o³chie⁴³ seih⁴ ma³tagh¹! I² con³ma²a⁴no³i³, con³ a⁴la³ a⁴hang⁴i³ jian³ a⁴ŋeng⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","I² con³ma²a⁴je³⁴ a³jeu³ i⁴a⁴júan⁴ Pa³² jon³, jon³ a⁴hleh⁴i³ tia⁴ jeu³ jau²jm⁴³ licaónico quieh¹i³ tionh², a⁴juah⁴i³: ―¡Jeh³², ma³a⁴jyon²³ neih³² a³jnia⁴ liah⁴i² jnia⁴ chie³ i²con²³ˉ¹! ");
INSERT INTO cucNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","I² Be²³ a⁴teh³i³ neih³² Júpiter, jian³ Pa³² a⁴teh³i³ neih³² Mercurio, quie¹ ta⁵la⁴ hei⁴i³ hlion⁴ jau²³ hleh²i³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","I² m³chie³ quian¹ neih³² Júpiter hain⁴, a³seih⁴³ cuah³ quieh¹ conh⁴ a⁴hei³⁴i³ je¹jeu³, jian³i³ a²cua³²jeu²³ tieh³² a²sag³ leg⁴³ o¹lei²³ ma³lau² la⁴teg⁴ o²hnei³² si²jneng³ jeu³ jon³, i⁴hnie³⁴i³ jang³⁴i³ jah⁴ i²con²³i³ jian²³i³ la⁴jang³⁴ a³jeu³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","I² con³ma²ra⁵ñi³ Pa³² jian²³ Be²³, a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo hain⁴, jon³ a⁴cag³⁴i³ a²cúan³ tionh², a⁴han⁵i³ jen² a³jeu³ jeu³ra³tyi⁴, a⁴hleh⁴i³ tia⁴, ");
INSERT INTO cucNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ a³jeu³, ¿henh⁴le³⁴ la⁴ne³ ti²júanh³ˉ³ tionh²ˉ³? Chie³ lia⁴ hnei³pa² jnie³², saih⁵ jnie³² hnei³ tieh²la³ i⁴teih³²ˉ³ i⁴hlagh³² ne³, ua²li⁴canh²ˉ³ jeu³ quieh¹ Jon⁴dai¹ a³sian³, a³hain⁴ a³a⁴júan⁴ ñi⁴jeu⁵ jian³ cuah³²húa³⁴, jm³ñih¹, jian³ la⁴jang³⁴ jian³ la⁴jeg³⁴ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jian³ liah⁴ma²jm² ma³ya⁴jo³⁴, a⁴cúa⁴ Jon⁴dai¹ jeu³ a⁴ŋeng⁴ la⁴jang³⁴ chie³ liah⁴ hyon³ tsei⁴³ tionh², ");
INSERT INTO cucNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","jian³ ua²liah⁴a² ma²tionh²i³ la⁴ne³, ton³²nie⁴³ ma⁴jnia³ Jon⁴dai¹ liah⁴ lang⁴³i³; quie¹ a⁴júan⁴i³ i⁴tsei³⁴ i²con²³ˉ¹, a⁴júan⁴i³ i⁴a⁴tah⁴ o¹jm⁴³, jian³ jain³ i⁴a⁴lo³, la⁴ne³ a⁴gueh⁴i³ jnia¹ jian³ a⁴júan⁴i³ i⁴si³hyonh³ˉ¹ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","I² ua²liah⁴a² a⁴hleh⁴i³ jau²³ ne³ tionh², la⁴ton³² a⁴cagh¹i³ jm² i²con²³ chie³ jeun⁴³ hain⁴ tionh² i⁴sa⁴a⁴jang⁴i³ jah⁴ i⁴ma²ma⁵co⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","I² jon³ a⁵han² meih³ chie³ judío, a³sian³ jeu³ Antioquía, jian³ jeu³ Iconio, a³a⁴hlenh⁴³ a³jeu³ liah⁴i² a⁴lang³⁴i³ ca³; i² con³ma²a⁴quinh⁴³i³ Pa³² m⁴caun² tionh², ma²jon³ ma⁴cmh³i³ la⁴teg⁴ coh⁵ je¹jeu³, lain⁴i³ a⁴jaun³⁴pa². ");
INSERT INTO cucNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","I² con³ma²a⁴tyie³⁴ chie³ quian¹ Jon⁴dai¹ co⁴la⁴langh⁵i³, jon³ a⁴no³i³, a⁴hei³⁴i³ liah⁴ i⁴seg³⁴ ta⁵je¹jeu³; i² con³ma²a⁴jnia³⁴, jon³ ŋo³⁴i³ ta⁵jeu³ Derbe jian²³ Be²³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Jian³ con³ma²a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ jeu³ Derbe jon³, jian³ ta² jeun⁴³ a⁴can³⁴ jeu³ quieh¹ Jon⁴dai¹; i² con³ma²a⁴leg³⁴ jon³, jon³ ŋo³⁴i³ liah⁴ i⁴seg³⁴ jeu³ Listra, jian³ jeu³ Iconio, jian³ jeu³ Antioquía liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Jian³ a⁴ma⁴huanh³i³ chie³ quian¹ Jon⁴dai¹, a⁴hlenh⁴³i³ i⁴tionh²i³ liah⁴ma³tionh²i³ jon³ i⁴hain⁴i³ re³, jian³ a⁴sagh⁴³i³: ―Ton³²nie⁴³ hniah³ le³²ˉ¹ hlion⁴ ma²eu⁴³ ñeih³² i⁴han⁵ˉ¹ naih⁵ heih⁴³ hm³⁴ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jian³ a⁴quianh⁴³i³ a³can³⁴ ma³tyi² quian¹ cuah³ conh⁴ con³ jeu³; i² con³ma²a⁴mh³i³ Jon⁴dai¹ jian³ i⁴a⁴júan⁴i³ he², jon³ a⁴ron⁴³i³ joh⁴³ cúa³ Se³ño²³, a³hain⁴ a³ra⁵hain⁴i³ i²con²³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Jian³ con³ma²a⁴leg³⁴ jon³, jon³ ua⁴jeun³²i³ húa³⁴ Pisidia, a⁴tyie³⁴i³ húa³⁴ Panfilia. ");
INSERT INTO cucNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Jian³ con³ma²a⁴hleh⁴i³ jau²³ quieh¹ Jon⁴dai¹ jeu³ Perge, jon³ ŋo³⁴i³ ta⁵jeu³ Atalia, ");
INSERT INTO cucNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","i²a⁴can³⁴i³ a²úan⁴³ i⁴ŋah³i³ jeu³ Antioquía, i²a⁴tonh³ cuah³ quieh¹i³ tionh² joh⁴³ cúa³ Jon⁴dai¹ a³ma⁵ho³² quieh¹i³, nei² quieh¹ ta¹ i⁴ma³ma⁴tei⁵i³ tieh²la³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","I² con³ma²a⁴tyanh³i³ tionh², jon³ a⁴júan⁴i³ i⁴a⁴ŋangh³ la⁴jang³⁴ cuah³, i² jon³ a⁴tya⁴i³ jau²³ la⁴conh⁴ tei⁴³ i⁴a⁴júan⁴ Jon⁴dai¹ con⁴juah⁴ hei⁴i³ tionh², jian³ liah⁴ a⁴nia³⁴ Jon⁴dai¹ jeu³ i⁴a⁴hain³⁴ chie³ sang²³ jau²³ quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jon³ a⁴jian⁴i³ úa⁴ tionh² jian²³ chie³ quian¹ Jon⁴dai¹ jeu³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ma²jon³ a⁴tyie³⁴ co⁴meih³ a³tionh² húa³⁴ Judea, i⁴heh²i³ chie³ quian¹ Jon⁴dai¹ tionh² i⁴juah⁴i³: ―Juah⁴ne³ sa⁴a⁴gm³ heh³²ˉ³ tionh²ˉ³ con⁴juah⁴ i⁴tang²³ quieh¹ M³se²³, sa⁴li⁴lionh⁴ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","I² Pa³² jian²³ Be²³ ne⁵, ta² a⁴jang²³i³ jian²³ a³hain⁴ tionh², a⁴tang⁴ jau²³ quieh¹i³, i⁴jon³ a⁴leg³⁴ re³ i⁴chie³⁴ Pa³² jian²³ Be²³ jian³ co⁴meih³ si³reunh¹i³ liah⁴, ta⁵ Jerusalén, i⁴si⁵jen³²i³ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a³ti²quian³ ma³tyi² cuah³ tionh², i⁴si⁵júan⁴i³ re³ nei² ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","I² con³ma²a⁴sai⁴ cuah³ quieh¹i³ tionh², jon³ ŋo³⁴i³, ua⁴jeun³²i³ húa³⁴ Fenicia jian³ húa³⁴ Samaria, i²a⁴tya⁴i³ jau²³ liah⁴ a⁴can³⁴ chie³ a³sa⁴lang⁴³ judío jau²³ quieh¹ Jon⁴dai¹, jian³ ta² si³hyonh³ la⁴jang³⁴ si³reunh¹i³ a⁴leg³⁴ nei² jon³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","I² con³ma²a⁴tyie³⁴ Pa³² jian²³ Be²³ jeu³ Jerusalén, jon³ a⁴hyei⁴³ cuah³ quieh¹i³, jian³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a³ti²quian³ ma³tyi² cuah³ liah⁴, jian³ ma²jon³ a⁴tya⁴i³ jau²³ la⁴jeg³⁴ i⁴a⁴júan⁴ Jon⁴dai¹ con⁴juah⁴ hei⁴i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","I² co⁴meih³ a³tionh² jo³² quieh¹ fariseo a³ra⁵hain⁴ hain⁴ tionh², a⁴no³i³, a⁴juah⁴i³: ―Hniah³ ton³²nie⁴³ gm⁴³ he³² a³sa⁴lang⁴³ judío tionh², jian³ hniah³ lei⁴ heih⁴³ i²con²³i³ i⁴hie³⁴i³ lai²³ quieh¹ M³se²³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","I² jon³ a⁴ŋangh³ la⁴jang³⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a³ti²quian³ ma³tyi² cuah³, a⁴je³⁴i³ tionh² liah⁴ li⁴lei⁴ nei² ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","I² con³ma²ta⁵ma³ŋo²³ hlion⁴ jau²³, jon³ a⁴no³ Pe³² je¹ jon³, a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ goh³ quian³⁴ˉ⁴, ma³ti²ñih¹ hnei³ tionh²ˉ³ i⁴a⁴hnoh³ jnia⁴ Jon⁴dai¹ liah⁴ma²jia⁴³, i⁴a⁴nau⁴ chie³ sang²³ hain⁴ con⁴juah⁴ jnia⁴ jau²³ quieh¹ Jesucristo i⁴ra⁵hain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","I² Jon⁴dai¹ a³hain⁴ a³cuh² m⁴tyi⁴ quieh¹ chie³ ne⁵, a⁴júan⁴i³ lei³ i⁴a⁴hyein⁴³i³ a³hain⁴ tionh², quie¹ a⁴cúa⁴i³ M⁴tyi⁴ quieh¹ i²con²³ a³hain⁴ tionh² liah⁴i² a⁴cúa⁴i³ jnia¹. ");
INSERT INTO cucNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Jian³ i¹con³ ni²hna³ sa⁴a⁴júan⁴i³ i²con²³ jnia¹ jian³ hei⁴i³ tionh², quie¹ a⁴ma⁴tsein³⁴i³ a³hain⁴ tionh² nei² quieh¹ i⁴ra⁵hain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tieh²la³ ne⁵, ¿henh⁴le³⁴ jau²chie⁴³ conh⁴ˉ³ Jon⁴dai¹ tionh²ˉ³ i⁴cúah⁵ˉ³ chie³ quian¹ Jon⁴dai¹ hain⁴ tionh² con³ lie²³ hyei³, i⁴sa⁴a⁴tieh¹ jmai³sie²³ˉ¹ can³⁴, jian³ a⁵ga⁴ jnia¹ liah⁴? ");
INSERT INTO cucNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Quie¹ hain⁴ jnia¹ i⁴con⁴juah⁴ i⁴tsei³⁴ tsei⁴³ Re¹ Jesús pa² lion⁴ˉ¹ jian³ la⁴ne³pa² a³i²co⁴hna³ hain⁴ tionh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","I⁴jon³ i¹con³ a⁵sie⁴³ i⁴juah⁴ chie³ jeun⁴³ hain⁴ tionh²; i² con³ma²a⁴leg³⁴ jon³, jon³ a⁴nau⁴i³ jau²³ quieh¹ Be²³ jian²³ Pa³², a³a⁴tya⁴ jau²³ conh⁴ tei⁴³ ua³júah² pain⁴ co³ jnia⁴ i⁴a⁴júan⁴ Jon⁴dai¹ con⁴juah⁴ hei⁴i³ tionh² jen² a³sa⁴lang⁴³ judío. ");
INSERT INTO cucNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jian³ con³ma²a⁴toh⁴ a⁴hleh⁴ Pa³² jian²³ Be²³, jon³ ra⁴hang³² Jacobo liah⁴, a⁴hleh⁴i³: ―Hnei³ tionh²ˉ³ goh³ quian³⁴ˉ⁴, nai³ hnei³ i⁴hleh¹ˉ⁴: ");
INSERT INTO cucNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Quie¹ ma³ra³tya⁴ Si²úan¹ Pe³² liah⁴ ma⁴jnia³ Jon⁴dai¹ i⁴tsei³⁴ tsei⁴³ co⁴ra⁴lie⁵ i²con²³ chie³ sang²³ hain⁴ tionh², i⁴a⁴quianh⁴³i³ i⁴lain⁴ chie³ quian¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jian³ la⁴ne³ ti²hleh² Ma²jyi³ i⁴a⁴sag⁴ a³sain² quian¹ Jon⁴dai¹ tionh², i⁴ra³juah⁴: ");
INSERT INTO cucNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Jian³ ta⁵cang³ ne³ liah⁴, nioh²ˉ⁵ sieh³²ˉ⁴ jau²³ ho³⁴ˉ⁴ i⁴a⁴cúah⁵ˉ⁵ Da³vei²³, liah⁴i² sieh² chie³ a²hnei⁴³ quieh¹ i⁴a⁴cúan⁴; liah⁴i² júanh²i³ i⁴hm³⁴ a²hnei⁴³ i⁴a⁴cúan⁴, la⁴ne³ júan¹ˉ⁴ i⁴hyon⁴³ jan³ sa¹jeun³ quian¹i³, a³tyein², ");
INSERT INTO cucNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","canh⁴a² hnoh⁴³ jnia⁴ la⁴jang³⁴ chie³ sang²³, la⁴jang³⁴ a³sa⁴lang⁴³ Israel, a³hain⁴ a³ma⁵co⁴³ jnia⁴, ");
INSERT INTO cucNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","a⁴juah⁴ Se³ño²³ Jon⁴dai¹, a³ma⁴jnia³ la⁴jeg³⁴ i⁴ne³ liah⁴ma²jm² ma³ya⁴jo³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’I⁴jon³ lain³⁴ˉ⁴, sa⁴re³ juah⁴ne³ si²quian³² jnia¹ tsei⁴³ chie³ sang²³ a³ma³a⁴can³⁴ jeu³ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Eu⁴³a² re³ hniah³ sag³²ˉ¹ i²con²³i³, i⁴sa⁴hniah³ queuh⁴³i³ o¹ŋeu⁴³ cúah¹ quieh¹ nioh⁵pa², jian³ jah⁴ a³cuh²i³ lau², jian³ sa⁴hniah³ queuh⁴³i³ jm³yein⁴, jian³ sa⁴hlenh⁵i³ a³sa⁴lang⁴³ i³cúa³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Quie¹ liah⁴ma²jm² ma³ya⁴jo³⁴ sian³ a³hleh² jau²³ quieh¹ M³se²³ la⁴jeg³⁴ jeu³ i⁴heg³i³ jm² sa⁴júan³i³ ta¹ cuah³ judío. ");
INSERT INTO cucNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","I² a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo hain⁴ tionh² jian³ a³quian³ ma³tyi² quian¹ cuah³, liah⁴ma³jian²³ la⁴jang³⁴ cuah³, a⁴júan⁴i³ re³ tionh², a⁴quianh⁴³i³ jen² jon²reunh¹i³, a³hain⁴ a³sain³⁴i³ ta⁵ Antioquía jian²³ Pa³² jian²³ Be²³. A⁴hnah³i³ Judas, a³teh²i³ Barsabás, jian³ Silas liah⁴ a³hain⁴ a³quein⁴³ jau²³ quieh¹ tionh² jen² jon²reunh¹i³, ");
INSERT INTO cucNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","jian³ a⁴júan⁴i³ re³ i⁴sain³⁴i³ con³ ma²jyi³ con⁴juah⁴ a³hain⁴ tionh², i⁴ra³juah⁴ la⁴la³: “Jnie³² a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a³ti²quian³ ma³tyi² quian¹ cuah³, jian³ la⁴jang³⁴ si³reunh⁴ˉ¹ a³tionh² i²la³, a⁴sag² jnie³² ma²jyi³ la³ i²conh² hnei³ tionh²ˉ³, goh³ quian³⁴ˉ⁴, a³langh⁴³ˉ³ chie³ sang²³, a³tionh² jeu³ Antioquía nie⁴³ húa³⁴ Siria, jian³ a³tionh² húa³⁴ Cilicia: Jon⁴dai¹ jie³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","I² jon³ ne⁵, quie¹ ma³ra⁵nia² jnie³² i⁴ni²han² co⁴meih³ a³sian³ i²la³, a³sa⁴a⁴sain¹ jnie³², a³a⁴júan⁴ i⁴a⁴hanh⁵ˉ³ hlion⁴ co³hei²tsei³, jian³ i⁴a⁴hag⁴ teun³⁴ hoh⁴³ˉ³ con⁴juah⁴ jau²³ i⁴a⁴hleh⁴i³, jian³ a⁴júan⁴i³ heih⁴³ i⁴gm⁴³ heh³²ˉ³, jian³ i⁴hieh²ˉ³ lai²³ quieh¹ M³se²³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","I⁴jon³ a⁴tyie³⁴ jnie³² con³ co³hei²tsei³ a⁴júan² jnie³² re³, i⁴a⁴hniah¹ jnie³² si³reunh⁴ˉ¹ la³, jian³ a³a⁴sain¹ jnie³² i²conh²ˉ³ jian²³ Be²³ jian³ Pa³² a³hnio⁴³ jnie³², ");
INSERT INTO cucNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","a³hain⁴ a³ma³ni²han² la⁴tan² i²co³ jia²³ li⁴jaun⁴, nei² quieh¹ jm³i⁴sain³ Re¹ Jesucristo quian⁴ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","I² la⁴ne³ jon³, sain³ jnie³² Judas la³ jian²³ Silas, a³hain⁴ a³li⁴tya³⁴ jau²³ tionh² i⁴ra³hleh² ma²jyi³ la³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Quie¹ la⁴la³ re³, a⁴juah⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹, jian³ jnie³² liah⁴ i⁴a⁵sie⁴³ lie²³ ma⁵hniah³ cúah³² jnie³² hnei³ tionh²ˉ³ i⁴seg³⁴, con³ i⁴la³pa² ya¹hniah³: ");
INSERT INTO cucNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","sa⁴hniah³ queuh²ˉ³ o¹ŋeu⁴³ cúah¹ quieh¹ nioh⁵, jian³ o¹ŋeu⁴³ quieh¹ jah⁴ cuh²i³ lau² jian³ jm³yein⁴, jian³ sa⁴hniah³ hlenh³²ˉ³ a³sa⁴lang⁴³ i³cúah³ˉ³, quie¹ juah⁴ne³ ma²teih³²ˉ³ la⁴ne³, ta² re³ júanh³ˉ³. Jon⁴dai¹ ma⁵ho³² hnei³.” ");
INSERT INTO cucNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","I² la⁴ne³ jon³, ua⁵han² a³a⁴sain⁴i³ hain⁴ ta⁵ Antioquía; i² con³ma²a⁴júan⁴i³ i⁴a⁴ŋangh³ cuah³, jon³ a⁴cúa⁴i³ ma²jyi³ jon³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","I² con³ma²a⁴heg⁴i³, ta² si³hyonh³i³ tionh² a⁴leg³⁴, a⁴lag³⁴ tsei⁴³i³ nei² jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","I² Judas jian²³ Silas ne⁵, lang⁴³i³ a³hleh² jau²³ quieh¹ Jon⁴dai¹ liah⁴, a⁴júanh³i³ tsei⁴³ si³reunh¹i³ hlion⁴ jau²³, jian³ a⁴ma⁴huanh³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Jian³ a⁴cua⁴i³ úa⁴ meih³ i²jon³, coh⁵ jon³ a²ma⁴ a⁴hag²³ si³reunh¹i³ jau²³ i²con²³i³ tionh² i⁴chianh³i³ si³hyonh³i³ i²con²³ a³hain⁴ a³a⁴sai⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","I² Silas ne⁵, a⁴júan⁴i³ co³hei²tsei³ i⁴jian³⁴i³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","I² Pa³² jian²³ Be²³ liah⁴, tionh² pi¹i³ Antioquía he²³i³ jau²³ quieh¹ Se³ño²³, jau²³ tsei²³ quieh¹ Jesucristo, jian³ jian²³i³ jeun⁴³ a³sang²³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Jian³ con³ma²ua⁴jeu³² hlion⁴ jm², jon³ a⁴juah⁴ Pa³², a⁴sagh⁴³i³ Be²³: ―Ma³²ˉ¹ ma⁵nia³²ˉ¹ si³reunh⁴ˉ¹ a³tionh² la⁴jeg³⁴ jeu³ i²ma³ni²hleh³²ˉ¹ jau²³ quieh¹ Se³ño²³, canh⁴a² li⁴nia²ˉ¹ liah⁴ sian³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","I² Be²³ ne⁵, hnie³⁴i³ chie³⁴ Juan²³ jian²³i³ tionh², a³hain⁴ a³teh²i³ Marcos; ");
INSERT INTO cucNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","i² Pa³² ne⁵, lain⁴i³ sa⁴re³ juah⁴ne³ chie³⁴ Marcos hain⁴ jian²³i³, quie¹ a⁴ton³⁴ a³hain⁴ quieh¹i³ tionh², con³ma²tionh²i³ húa³⁴ Panfilia, i⁴so⁵ñei²i³ jian²³i³ nei² ta¹ quieh¹ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","I⁴jon³ a⁵sie⁴³ a⁴tyie³⁴i³ con³ co³hei²tsei³ tionh², quie¹ ua⁵han²i³ ma⁵quein²³, Be²³ ŋo³⁴ ta⁵o⁵tyieh⁴³ Chipre jian²³ Marcos jeu³ a²úan⁴³, ");
INSERT INTO cucNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","jian³ Pa³² liah⁴ a⁴hnah³i³ Silas. I² con³ma²a⁴tonh³ cuah³ quieh¹i³ joh⁴³ cúa³ Se³ño²³ a³ma⁵ho³² quieh¹i³, ma²jon³ ŋo³⁴i³ ");
INSERT INTO cucNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ua⁴jeun³²i³ húa³⁴ Siria jian³ húa³⁴ Cilicia, a⁴ma⁴huanh³i³ cuah³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Jian³ con³ma²ua⁴jeu³² jon³, jon³ a⁴tyie³⁴i³ jeu³ Derbe jian³ jeu³ Listra; jeu³ jon³ ma²cua⁴³ jan³ chie³ quian¹ Jon⁴dai¹ a³sain³ Ti³mo³te³², a³jon⁴³ jan³ a³don⁵ m⁴ judía a³lang⁴³ chie³ quian¹ Jon⁴dai¹, i² jmai³i³ lang⁴³ chie³ griego. ");
INSERT INTO cucNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jian³ la⁴jang³⁴ chie³ quian¹ Jon⁴dai¹ a³tionh² jeu³ Listra jian³ jeu³ Iconio, hleh²i³ re³ nei² quieh¹ Ti³mo³te³² hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Jon³ ra⁵hnie³⁴ Pa³² i⁴chie³⁴i³ jian²³i³, jian³ a⁴tei⁴ Pa³² he³²i³ nei² quieh¹ judío a³tionh² hloh³² jon³, quie¹ la⁴jang³⁴ ti²ñi³ i⁴lang⁴³ jmai³i³ chie³ sang²³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","I² con³ma²a⁴han⁵i³ la⁴jeg³⁴ jeu³ jon³, jon³ a⁴cúa⁴i³ heih⁴³ jon³ i²con²³ cuah³, canh⁴a² ma⁴tei⁵i³ heih⁴³ i⁴a⁴leg³⁴ re³ con⁴juah⁴ a³hei¹ joh⁴³ cúa³ ta¹ quieh¹ Jesucristo, jian³ a³ti²quian³ ma³tyi² cuah³ a³tionh² Jerusalén. ");
INSERT INTO cucNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","I² la⁴ne³ ra⁵huanh³ la⁴jang³⁴ cuah³ nei² quieh¹ i⁴hain⁴i³ tionh², jian³ conh⁴ con³ jm² tsei³⁴sa² jeun⁴³ li⁴hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Jon³ a⁴han³i³ húa³⁴ Frigia, jian³ húa³⁴ Galacia, quie¹ sa⁴a⁴cúa⁴ M⁴tyi⁴ quieh¹ Jon⁴dai¹ juah⁴ i⁴hleh³i³ jau²³ quieh¹ Jon⁴dai¹ húa³⁴ Asia jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","I² con³ma²a⁴tyie³⁴i³ húa³⁴ Misia, jon³ ma²hnie³⁴i³ chie³⁴i³ ta⁵húa³⁴ Bitinia; i² M⁴tyi⁴ quieh¹ Jon⁴dai¹ ne⁵, sa⁴a⁴cúa⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","I⁴jon³ ua⁴jeun³²i³ la⁴tan² hloh³² i²ra³jainh³ húa³⁴ Misia liah⁴i² a⁴tyie³⁴i³ jeu³ Troas. ");
INSERT INTO cucNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","I² jon³ a⁴je³⁴ Pa³² con³ i⁴ma⁴jnia³² i²con²³i³ je¹nai³, a⁴jen³i³ jan³ a³ñih³ a³sian³ húa³⁴ Macedonia si²sainh⁴³ a³si²m²³ i²con²³i³ i⁴juah⁴i³: “Nia³ hnei³ ta⁵ Macedonia la³ i⁴ma²hoh³²ˉ³ jnie³².” ");
INSERT INTO cucNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","I² con³ma²a⁴je³⁴ Pa³² i⁴ma⁴jnia³² i²con²³i³ jon³, liah⁴ma²jon³ a⁴júan² jnie³² co³jian¹ i⁴chie³² jnie³² ta⁵húa³⁴ Macedonia jon³, quie¹ ra⁵chie⁴³ tsei⁴³ jnie³² i⁴te²³ Jon⁴dai¹ i⁴si²hleh² jnie³² jau²³ quieh¹i³ i²con²³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Con³ma²a⁴le¹ jnie³² a²úan⁴³ jeu³ Troas, jon³ ŋo³⁴ jnie³² jeu³chie⁴³ teg⁴ o⁵tyieh⁴³ Samotracia jeu³ nei² jm³, i² con³ma²a⁴jnia³⁴, jon³ ŋo³⁴ jnie³² teg⁴ jeu³ Neápolis. ");
INSERT INTO cucNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Jian³ ma²jon³ ŋo³⁴ jnie³² jeu³ Filipos, jeu³ tyein² quieh¹ la⁴tan² húa³⁴ Macedonia, jian³ i²tain⁴³ gobierno romano liah⁴. Jeu³ jon³ a⁴jian² jnie³² úa⁴ meih³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jian³ con³ jm² sa⁴júan³i³ ta¹, a⁴húa³ jnie³² coh⁵ o²hnei³² quieh¹ jeu³ jon³, ŋo³⁴ jnie³² quien¹i²jm¹ jm³júah¹ i²tang²³i³ ŋangh³i³ mh²i³ Jon⁴dai¹. I² con³ma²a⁴hyie³² jnie³², jon³ a⁴hleh² jnie³² jau²³ quieh¹ Jon⁴dai¹ i²con²³ a³m⁴ a³ti²ŋangh³ i²jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Jian³ jan³ a³don⁵ m⁴ a³sain³ A¹li²dia³ a³sian³ jeu³ Tiatira, a³hnang³ a²hmh³ sein³², a³ma³con⁴³ Jon⁴dai¹ Jmai³, ua²nau³i³ jau²³ i⁴si²hleh² Pa³², jian³ a⁴júan⁴ Se³ño²³ tsei⁴³ a³m⁴ hain⁴ i⁴a⁴ro⁴i³ jeu³ jau²³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Jon³ a⁴son⁴i³ jm³, jian³ la⁴jang³⁴ a³tionh² jauh³² quieh¹i³, jian³ ma²jon³ a⁴m⁴i³ i²con²³ jnie³², a⁴juah⁴i³: ―Juah⁴ne³ lainh⁴ˉ³ i⁴ma³lang⁴³ˉ⁴ jan³ chie³ quian¹ Se³ño²³ tieh²la³, lei⁴ li⁴niah²ˉ³ jauh³² quien⁴ˉ⁴ i⁴jianh²ˉ³. I² la⁴ne³ a⁴júan⁴ a³m⁴ hain⁴ i⁴a⁴jian² jnie³² ta⁵li⁴hnai³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Jian³ con³ jm², con³ma²ŋo³⁴ jnie³² i²tang²³i³ mh²i³ Jon⁴dai¹, jon³ a⁴jainh³ jnie³² jan³ a³m⁴ peih¹ a³quian³ con³ m⁴tyi⁴ hlagh³² a³tyi³ jau²chie⁴³, a³júan³ i⁴laih⁴ jeu³²i³ hlion⁴ o¹cau³² ta¹ i⁴tyi³i³ jau²chie⁴³ jon³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tyein¹ a³m⁴ ne³ coh⁵cah³² Pa³² jian³ jnie³² liah⁴, hleh²i³ tia⁴ juah⁴i³: ―¡Jeh³², a³ne³ tionh² cúa²³ cúa³tag³² i²con²³ Jon⁴dai¹ Júanh⁴³, jian³ hleh²i³ jau²³ liah⁴ li⁴lion⁴ chie³! ");
INSERT INTO cucNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Hlion⁴ jm² ja³⁴ i⁴júan³ a³m⁴ hain⁴ la⁴ne³, i² con³ma²si⁴quian⁵ tsei⁴³ Pa³², jon³ a⁴jen³i³ a³hain⁴, a⁴sagh⁴³i³ m⁴tyi⁴ hlagh³²: ―Júan³⁴ˉ⁴ heih⁴³ i²conh²ˉ³ con⁴juah⁴ jm³i⁴sain³ Jesucristo i⁴jauh¹ˉ³ i²con²³ a³m⁴ ne³. I² m⁴tyi⁴ hlagh³² ne⁵, liah⁴ma²jon³ ua⁵hag⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","I² con³ma²a⁴je³⁴ jeu³²i³ i⁴so⁵sia³ liah⁴ li⁴laih⁴i³ o¹cau³² con⁴juah⁴ a³m⁴ hain⁴, jon³ a⁴sanh³i³ Pa³² jian²³ Silas, jian³i³ teg⁴ jauh³²tyie³ ta⁵nei² si³ta¹. ");
INSERT INTO cucNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","I² con³ma²ma⁴jnia³ jeu³² a³m⁴ hain⁴ Pa³² jian²³ Silas ta⁵nei² si³ta¹, jon³ a⁴juah⁴i³: ―Jeh³², a³la³ tionh² sion⁴³ a³jeu³ quian⁴ˉ¹, quie¹ lang⁴³i³ judío, ");
INSERT INTO cucNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","quie¹ he²³i³ con³ i⁴tang²³ quieh¹i³ tionh² i⁴sa⁴haih¹ li⁴hyei³²ˉ¹, jian³ o⁴ li⁴júan³²ˉ¹ liah⁴, quie¹ lang⁴³ˉ¹ chie³ romano. ");
INSERT INTO cucNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","I² jon³ a⁴ŋangh³ jeun⁴³ a³jeu³ a³hnie³⁴ júanh¹ quieh¹i³; i² si³ta¹ tionh² ne⁵, a⁴cag³⁴i³ a²cúan³ Pa³² jian²³ Silas, a⁴cmh³i³, ma²jon³ a⁴júan⁴i³ heih⁴³ i⁴a⁴pan³⁴i³ jeu³ a²hma³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","I² con³ma²a⁴po³⁴i³ hlion⁴, jon³ a⁴ron⁴³i³ ni⁴ñi²³, jian³ a⁴júan⁴i³ heih⁴³ i²con²³ po³li³sei¹ i⁴hie³⁴i³ re³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","I² con³ma²a⁴hyei⁴i³ heih⁴³ ne³, jon³ a⁴ron⁴³i³ la⁴teg⁴ i²a⁴toh⁴ jauh³² i²naih³, jian³ a⁴tonh³i³ to³ a²hma³ si¹tag³²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","I² con³ma²a⁴teg⁴ i⁴húa²³, jon³ ti²mh² Pa³² Jon⁴dai¹ jian²³ Silas, jian³ ti²he²³i³ seun²³ i²con²³ Jon⁴dai¹, jian³ la⁴jang³⁴ a³chion³² a³tionh² ni⁴ñi²³ ti²nau³; ");
INSERT INTO cucNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","i² con³ a⁴la³ a⁴qui³⁴ con³ húa³⁴ i⁴tia⁴, a⁴jaih³ a²hnei⁴³ ni⁴ñi²³ la⁴con³ ta²seih⁴³, jian³ liah⁴ma²jon³ a⁴na⁴ la⁴jeg³⁴ o²hnei³², jian³ a⁴sagh⁴³ a²ca³den² ti²hñi⁴³ la⁴jang³⁴ a³chion³². ");
INSERT INTO cucNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","I² con³ma²a⁴ñei³⁴ a³hie³ ni⁴ñi²³ hain⁴, jian³ a⁴je³⁴i³ si¹ja⁵ la⁴jeg³⁴ o²hnei³², jon³ a⁴tyi³i³ a²ñi²tag⁴ quieh¹ i⁴ma²jŋangh³i³ hña³, quie¹ ma³a⁴cm⁴ la⁴jang³⁴ a³chion³², lain⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","I² jon³ a⁴hleh⁴ Pa³² con³ i⁴tia⁴, a⁴juah⁴i³: ―¡A⁵júanh⁴³ hnei³ húanh⁴³, quie¹ la⁴jag³⁴pa² jnie³² ti²tieh² jnie³² i²la³! ");
INSERT INTO cucNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","I² hei⁴i³ ne⁵, a⁴m⁴i³ o¹jyi³, a⁴hei³⁴i³ jauh³² jeu³ra³tyi⁴, jlen²³i³, jian³ a⁴si⁴jnei⁵i³ ta⁵nei² Pa³² jian²³ Silas. ");
INSERT INTO cucNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","I² con³ma²a⁴húan⁴³i³ a³hain⁴ tionh², jon³ a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ a³don⁵, ¿henh⁴ hniah³ júan³²ˉ⁴ canh⁴a² lion⁴ˉ⁴? ");
INSERT INTO cucNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","I² jon³ a⁴juah⁴i³ tionh²: ―Hniah³ li⁴hainh⁴ˉ³ i²con²³ Re¹ Jesucristo canh⁴a² lionh⁴ˉ³, hnei³ jian³ la⁴jang³⁴ a³tionh² jauh³² quianh³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jon³ a⁴hlenh⁴³i³ a³hain⁴ jau²³ quieh¹ Jon⁴dai¹ jian³ la⁴jang³⁴ a³tionh² jauh³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jian³ je¹nai³ jon³, o²ra³ jon³ a⁴raunh⁵i³ i²eu⁴³ quieh¹ Pa³² jian²³ Silas; jian³ con³ma²a⁴leg³⁴ jon³, a⁴son⁴i³ jm³ jian²³i³ la⁴jang³⁴ a³tionh² jauh³² quieh¹i³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ma²jon³ a⁴te¹i³ a³hain⁴ tionh² jauh³² quieh¹, a⁴guenh⁴i³, jian³ ta² si³hyonh³i³ tionh² la⁴jang³⁴i³ la⁴jon³ quie¹ ra⁵hain⁴i³ i²con²³ Jon⁴dai¹. ");
INSERT INTO cucNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","I² con³ma²a⁴jnia³⁴ jon³, jon³ a⁴sain⁴ si³ta¹ jan³ on³⁴ po³li³sei¹ i²con²³ a³hie³ ni⁴ñi²³ i⁴ua⁵saih¹i³: ―Lion³² hnei³ a³hain⁴ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","I² a³hie³ ni⁴ñi²³ hain⁴, a⁴sagh⁴³i³ Pa³² jau²³ jon³, a⁴juah⁴i³: ―Tieh²la³ a⁴sain⁴ si³ta¹ jau²³, a⁴juah⁴i³ i⁴lion³²ˉ⁴ hnei³ tionh²ˉ³; i² la⁴ne³ ne⁵, húan³ hnei³ tieh²la³, tyanh⁴ˉ³ quianh³ hyon³ hoh⁴³ˉ³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","I² Pa³² ne⁵, a⁴juah⁴i³: ―¿Liah⁴ cúan²³ hnie³⁴i³ húa⁵ jnie³² ta⁵si²hma², ta⁵ma³a⁴po³⁴i³ jnie³² ta⁵nei² a³jeu³ naih⁵i² can³⁴i³ jau²chie⁴³ jian³ a⁴tonh³i³ jnie³² ni⁴ñi²³, jian³ quie¹ lang⁴³ jnie³² chie³ romano liah⁴? A⁵sia³ húa⁵ jnie³² la⁴ne³. Eu⁴a² re³ ua²jia³i³ tionh² húan⁴ ya⁴húa⁴³i³ jnie³². ");
INSERT INTO cucNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","I² jon³ ua⁵con²³ po³li³sei¹ hain⁴ jau²³ jon³ i²con²³ si³ta¹ tionh²; i² con³ma²ra⁵ñi³i³ i⁴lang⁴³ a³hain⁴ chie³ romano tionh², ta² ra⁵coh⁴³i³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","I⁴jon³ a⁴tyie³⁴i³ tionh², a⁴m⁴i³ i⁴hain⁴ chie³² i²con²³i³, ma²jon³ a⁴húan⁴i³, jian³ a⁴sagh⁴³i³ i⁴húan⁴³i³ je¹jeu³. ");
INSERT INTO cucNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","I² con³ma²a⁴húan³i³ ni⁴ñi²³, jon³ a⁴tyie³⁴i³ jauh³² quieh¹ a³don⁵ A¹li²dia³, a⁴jen³i³ jon²reunh¹ i²jon³, a⁴júanh³i³ tsei⁴³ a³hain⁴ tionh²; con³ma²a⁴leg³⁴ jon³, jon³ ua⁵han²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Con³ma²ua⁵han²i³, jon³ ua⁴jeun³²i³ jeu³ Anfípolis jian³ jeu³ Apolonia, jon³ a⁴tyie³⁴i³ jeu³ Tesalónica, i²jon³ i²seih⁴³ con³ cuah³ judío. ");
INSERT INTO cucNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","I² jon³ ŋo³⁴ Pa³² cuah³ jon³ liah⁴i² tang²³i³ chie²³i³, a⁴tya⁴i³ jau²³ jian²³ a³hain⁴ tionh² hneng³ jm² sa², jm² sa⁴júan³i³ ta¹. ");
INSERT INTO cucNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","A⁴hleh⁴i³ ra³jia⁵ la⁴conh⁴ ra³sag² Ma²jyi³ quieh¹ Jon⁴dai¹ i⁴ra⁵hniah³ can³⁴ a³hain⁴ ma²eu⁴³, A³ua⁵lion³² Chie³ hain⁴, i⁴jaun⁴i³ jian³ i⁴hyon⁴³i³ jen² a³jaun². Jian³ a⁴juah⁴ Pa³²: ―Jian³ Jesús hain⁴ a³hleh³ˉ⁴ nei² quieh¹ i²conh²ˉ³ tionh²ˉ³, hei⁴ pi²³i³ lang⁴³ A³lion³ Chie³ hain⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jian³ ca³chion²³ a³hain⁴ tionh² ra⁵hain⁴, jian³ ma⁴reunh¹i³ Pa³² jian³ Silas. Jian³ ra⁵hain⁴ jeun⁴³ chie³ griego liah⁴ a³ma²ma³con⁴³ Jon⁴dai¹ Jmai³, jian³ jeun⁴³ a³m⁴ canh² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","I² la⁴jang³⁴ judío a³sa⁴ra⁵hain⁴ tionh² ne⁵, ta² a⁴jain³⁴ tsei⁴³i³; i² jon³ a⁴jaih³i³ chie³ hlangh² a³jeunh³; i² con³ma²a⁴jaih³i³ jeun⁴³ chie³, jon³ a⁴júan⁴i³ ti³jan²³, a⁴sion⁴³i³ a³jeu³. Jian³ ni²tian⁴³i³ jauh³² quieh¹ Jasón, ma²hnie³⁴i³ tyein⁵i³ Pa³² jian²³ Silas ta⁵nei² a³jeu³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","I² sa⁴a⁴chianh¹i³ ne⁵, i² jon³ jian³i³ Jasón jian²³ co⁴meih³ chie³ quian¹ Jon⁴dai¹ ta⁵nei² si³ta¹ je¹jeu³ jon³, ti²hleh²i³ tia⁴, a⁴juah⁴i³: ―A³ne³pa² tionh² sion⁴³ chie³ la⁴tan² m⁵cu³, i⁴jon³pa² cuan³⁴i³ i²la³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jian³ a⁴hyei⁴³ Jasón quieh¹i³ tionh². Jian³ la⁴jang³⁴ a³ne³ tionh² sa⁴ma³co⁴³ lai²³ quieh¹ gobierno César, quie¹ juah⁴i³ sian³ i²jan³ re¹ sang³⁴ a³sain³ Jesús. ");
INSERT INTO cucNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","I² con³ma²a⁴nau⁴ a³jeu³ jau²³ jon³ jian³ si³ta¹ quian¹ je¹jeu³ jon³, jon³ ra⁴hang³²i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","I² con³ma²a⁴cúa⁴ Jasón o¹cau³² i²con²³ si³ta¹ jian²³i³ la⁴jang³⁴ a³hain⁴ tionh², jon³ a⁴lon⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jian³ liah⁴ma²jon³ to⁵je¹nai³, a⁴sain⁴ chie³ quian¹ Jon⁴dai¹ Pa³² jian²³ Silas teg⁴ jeu³ Berea. I² hei⁴i³ tionh², con³ma²a⁴tyie³⁴i³, jon³ ŋo³⁴i³ cuah³ judío. ");
INSERT INTO cucNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jian³ a³ŋangh³ cuah³ jon³, ta² re³ júan³i³ la⁴conh⁴a² a³tionh² Tesalónica, quie¹ a⁴hyei⁴i³ jau²³ quieh¹ Jon⁴dai¹ i⁴si³hyonh³i³ jian³ je²³i³ Ma²jyi³ quieh¹ Jon⁴dai¹ conh⁴ con³ jm² canh⁴a² li⁴chie⁴³ tsei⁴³i³ o⁴ la⁴jon³ ra³leg⁴³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","I⁴jon³ ra⁵hain⁴ jeun⁴³ a³hain⁴ tionh², jian³ ra⁵hain⁴ jeun⁴³ chie³ griego, a³m⁴ canh² jian³ a³ñih³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Con³ma²ra⁵ñi³ judío a³tionh² Tesalónica hain⁴ i⁴hleh² Pa³² jau²³ quieh¹ Jon⁴dai¹ Berea, jon³ ua⁵han²i³ i²jon³, jian³ a⁴sion⁴³i³ jeun⁴³ chie³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","I² chie³ quian¹ Jon⁴dai¹ a³tionh² i²jon³ ne⁵, liah⁴ma²jon³ a⁴sain⁴i³ Pa³² teg⁴ i²jm¹ jm³ñih¹; i² Silas jian²³ Ti³mo³te³² ne⁵, a⁴jian⁴i³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jian³ a³quian³ jau²³ nei² quieh¹ Pa³² i⁴ua⁵jo³i³, jon³ ni²jan³i³ teg⁴ jeu³ Atenas. I² con³ma²a⁴cúa⁴ Pa³² heih⁴³ nei² quieh¹ Silas jian³ Ti³mo³te³² i²con²³ a³hain⁴ tionh² i⁴juah⁴i³ i⁴tyie¹i³ ta¹tia⁴, jon³ a²ma⁴ jonh³i³ tionh². ");
INSERT INTO cucNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Jian³ ta¹la⁴ ua²jian⁴³ Pa³² a³hain⁴ tionh² jeu³ Atenas, ta² ra⁵chionh⁴ tsei⁴³i³ con³ma²a⁴je³⁴i³ jeu³ jon³ i⁴eu⁴³ ma³con⁴³i³ nioh⁵. ");
INSERT INTO cucNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","I⁴jon³ a⁴hlenh⁴³i³ chie³ judío a³ŋangh³ cuah³ quieh¹ jian³ la⁴jang³⁴ chie³ sang²³ a³ma³con⁴³ Jon⁴dai¹ Jmai³, jian³ conh⁴ con³ jm² a⁴hlenh⁴³i³ la⁴jang³⁴ a³tionh² je¹hmah¹. ");
INSERT INTO cucNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jian³ co⁴meih³ a³ŋang⁴ a³tang³ jau²³ quieh¹ Epicuro jian³ a³tang³ jau²³ quieh¹ chie³ estoico liah⁴, a⁴jang²³i³ jian²³i³ Pa³², jon³ a⁴juah⁴ ca³chion²³: ―¿Henh⁴ hleh² a³hlenh⁴³ ne³? Jian³ i²ca³chion²³ a⁴juah⁴: ―La⁴con³ hleh² a³ne³ jau²³ quieh¹ neih³² sang³⁴. Quie¹ hleh² Pa³² jau²³ tsei²³ nei² quieh¹ Jesús, jian³ liah⁴ hyon⁴³ a³jaun² liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Jon³ a⁴te¹i³ Pa³² con³ i²tang²³i³ ŋangh³i³ i²sain³ Areópago, a⁴juah⁴i³: ―¿O⁴ haih¹ lei⁴ li⁴nia² jnie³² jau²³ hm²³ i⁴hleh³ˉ³ ne³? ");
INSERT INTO cucNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Quie¹ quianh²ˉ³ jau²³ i⁴sa⁴ma³a⁴nai² jnie³², i⁴jon³ hnie³⁴ jnie³² i⁴li⁴nia² jnie³² henh⁴ ra³juah⁴ i⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Quie¹ la⁴jang³⁴ a³sian³ Atenas jian³ a³sian³ ta⁵seg³⁴ a³tionh² i²jon³ liah⁴, con³ i⁴jon³pa² hnie³⁴i³ i⁴hleh³i³ con³ jau²³ hm²³ jian³ o⁴ i⁴nau³⁴i³ liah⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","I² jon³ a⁴no³ Pa³² to⁵chieh³² i²ti²ŋangh³i³ Areópago jon³, a⁴juah⁴i³: ―Hnei³ tionh²ˉ³ a³sian³ Atenas la³, ta² ma⁵conh³²ˉ³ neih³² tionh²ˉ³, je³⁴ˉ⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","I² con³ma²a⁴ŋeng³⁴ˉ⁴, a⁴je³⁴ˉ⁴ la⁴jeg³⁴ i²ma⁵conh³²ˉ³ neih³², jian³ a⁴je³⁴ˉ⁴ con³ ni²hyie⁴ i⁴ra³sag² jau²³ la³: “NI²HYIE⁴ QUIEH¹ JON⁴DAI¹ SA⁴CM⁴³ˉ¹.” I² a³hain⁴ a³ma⁵conh³²ˉ³ i⁴sa⁴cmh⁴³ˉ³ tionh²ˉ³, a³hain⁴pa² hleh³ˉ⁴ nei² quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Jon⁴dai¹ a³hain⁴ a³a⁴júan⁴ m⁵cu³ jian³ la⁴jeg³⁴ i⁴sia³, jian³ hei⁴i³ júan³ heih⁴³ ñi⁴jeu⁵ jian³ cuah³²húa³⁴. Jian³ sa⁴cua⁴³i³ cuah³ i⁴júan³ chie³, ");
INSERT INTO cucNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","jian³ i¹con³ a⁵sia³ i⁴si³hain⁴ quieh¹i³ juah⁴ i⁴li⁴cúa³⁴ chie³, quie¹ hei⁴ pi²³i³ cúa²³ m⁵cu³ quieh¹ la⁴jang³⁴, jian³ tyi⁴ con²³i³ jian³ la⁴jeg³⁴ i⁴seg³⁴. ");
INSERT INTO cucNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Jian³ con⁴juah⁴ jan³ chie³pa² a⁴júan⁴³i³ la⁴jang³⁴ sa¹jeun³ chie³, canh⁴a² han⁵i³ la⁴tan² m⁵cu³, jian³ a⁴júan⁴ Jon⁴dai¹ heih⁴³ conh⁴ jm² i⁴li⁴úan⁴ chie³ jeu³ co²³ jian³ la⁴conh⁴ tei⁴³ i²tionh²i³, ");
INSERT INTO cucNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","canh⁴a² hnah⁴³ chie³ tionh² Jon⁴dai¹ la⁴con³ li⁴sanh³i³ i⁴li⁴tyanh¹i³ a¹juah⁴ liah⁴ li⁴lei⁴, quie¹ a⁵sia³ gm⁴ sainh⁴³ Jon⁴dai¹ i²con²³ con⁴jan³ˉ¹. ");
INSERT INTO cucNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Quie¹ con⁴juah⁴ hei⁴ pi²³i³ sian³ˉ¹ jian³ ŋeng²³ˉ¹ jian³ i⁴lang⁴³ˉ¹ liah⁴; liah⁴i² a⁴juah⁴ co⁴meih³ a³coh³²ˉ³ a³sag³ ma²jyi³ libro: “Lang⁴³ jnia¹ a³a⁴júan⁴³ Jon⁴dai¹.” ");
INSERT INTO cucNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Juah⁴ne³ lang⁴³ jnia¹ a³a⁴júan⁴³ Jon⁴dai¹, i⁴jon³ sa⁴hniah³ júan³²ˉ¹ co³hei²tsei³ i⁴lang⁴³ Jon⁴dai¹ nioh⁵ i⁴júan³ chie³ con⁴juah⁴ co³hei²tsei³ quieh¹ jian³ o⁴ a³lang⁴³ o¹cau³²nie¹ jian³ o⁴ o¹cau³² tie³ jian³ o⁴ a²caun². ");
INSERT INTO cucNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Quie¹ i¹con³ hei²³ sa⁴a⁴can³⁴ Jon⁴dai¹ i²con²³ chie³ jm² ma³ya⁴jo³⁴ nei² quieh¹ i⁴sa⁴ma²ñi³i³; i² tieh²la³ ne⁵, júan³i³ heih⁴³ i²con²³ la⁴jang³⁴ chie³ ua²jainh¹ i²tionh²i³ i⁴sag³⁴i³ co³hei²tsei³ quieh¹. ");
INSERT INTO cucNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Quie¹ ma³a⁴tien⁴i³ con³ jm² i⁴queih³i³ heih⁴³ i²con²³ a³tionh² m⁵cu³ la³ con⁴juah⁴ jau²³ ni²tei⁴³, con⁴juah⁴ a³hain⁴ a³a⁴hnah³i³; jian³ a⁴júan⁴i³ i⁴a⁴hyon²³ a³hain⁴ jen² a³jaun², canh⁴a² li⁴chie⁴³ tsei⁴³ la⁴jang³⁴ i⁴lei⁴ la⁴ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","I² con³ma²a⁴nau⁴ a³hain⁴ tionh² nei² quieh¹ i⁴hyon⁴³ a³jaun², ca³chion²³ a⁴ji⁴ŋang⁴, jian³ ca³chion²³ juah⁴: ―Ma²jon³ nai² jnie³² liah⁴ jm² seg³⁴ jau²³ ne³. ");
INSERT INTO cucNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","I² jon³ ne⁵, ua⁵hag⁴³ Pa³² jen²i³ t