﻿USE sofia;
DROP TABLE IF EXISTS sofia.cubNT_vpl;
CREATE TABLE cubNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cubNT_vpl WRITE;
INSERT INTO cubNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yʉ toivaquijivʉ ne ãmiáre ina Jesucristo ʉ̃i jipocacavʉ bácavʉre, ʉ̃i jipoca põeteivʉ bácavʉre. Ʉ̃́tame ñai jabocʉ bácʉ David bácʉi pãramecʉ, aru Abraham mácʉi pãramecʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mácʉ Isaac bácʉi pacʉ barejaquémavʉ. Isaac bácʉ Jacob bácʉi pacʉ barejaquémavʉ. Jacob bácʉ Judájã mácavʉ népacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá bácʉ Fares bácʉ aru Zara bácʉ népacʉ barejaquémavʉ. Aru Tamar báco népaco barejaquémavʉ. Fares bácʉ Esrom mácʉi pacʉ barejaquémavʉ. Esrom mácʉ Aram mácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mácʉ Aminadab bácʉi pacʉ barejaquémavʉ. Aminadab bácʉ Naasón mácʉi pacʉ barejaquémavʉ. Naasón mácʉ Salmón mácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón mácʉ Booz bácʉi pacʉ barejaquémavʉ. Aru Rahab báco jípaco barejaquémavʉ. Booz bácʉ Obed bácʉi pacʉ barejaquémavʉ. Aru Rut báco jípaco barejaquémavʉ. Obed bácʉ Isaí bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí bácʉ David bácʉi pacʉ barejaquémavʉ. Ñai David bácʉ Israecavʉ bácavʉ ne jabocʉ barejaquémavʉ. David bácʉ Salomón mácʉi pacʉ barejaquémavʉ. Aru Urías bácʉi márepaco jípaco barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón mácʉ Roboam mácʉi pacʉ barejaquémavʉ. Roboam mácʉ Abías bácʉi pacʉ barejaquémavʉ. Abías bácʉ Asa bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa bácʉ Josafat bácʉi pacʉ barejaquémavʉ. Josafat bácʉ Joram mácʉi pacʉ barejaquémavʉ. Joram mácʉ Uzías bácʉi ñecu marejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías bácʉ Jotam mácʉi pacʉ barejaquémavʉ. Jotam mácʉ Acaz bácʉi pacʉ barejaquémavʉ. Acaz bácʉ Ezequías bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías bácʉ Manasés bácʉi pacʉ barejaquémavʉ. Manasés bácʉ Amón mácʉi pacʉ barejaquémavʉ. Amón mácʉ Josías bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías bácʉ Jeconíajã mácavʉ néñecu marejaquémavʉ. Dinʉmʉare, ne cʉrinʉmʉare, ina Babilonia ãmicʉrõcavʉ bácavʉ ne bʉorĩ nʉvaimara marejaquémavʉ maja Israecavʉ maje jipocacavʉ bácavʉ. Na mácavʉre nʉvarejaquemavʉ pʉ Babilonia ãmicʉrõita. ");
INSERT INTO cubNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Na mácavʉre ne bʉorĩ nʉvariburu yóboi, Jeconías bácʉ Salatiel bácʉi pacʉ barejaquémavʉ. Salatiel bácʉ Zorobabel bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel bácʉ Abiud bácʉi pacʉ barejaquémavʉ. Abiud bácʉ Eliaquim mácʉi pacʉ barejaquémavʉ. Eliaquim mácʉ Azor bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor bácʉ Sadoc bácʉi pacʉ barejaquémavʉ. Sadoc bácʉ Aquim mácʉi pacʉ barejaquémavʉ. Aquim mácʉ Eliud bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud bácʉ Eleazar bácʉi pacʉ barejaquémavʉ. Eleazar bácʉ Matán mácʉi pacʉ barejaquémavʉ. Matán mácʉ Jacob bácʉi pacʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob bácʉ Joséi pacʉ barejámed̶a. Ñai José Maríai márepacʉ barejámed̶a. Aru María Jesúi paco barejácod̶a. Ñai Jesús Jʉ̃menijicʉ ʉ̃i epeimʉ, Cristo, barejámed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Que baru Abraham mácʉi cʉrinʉmʉre, pʉ David bácʉi cʉrinʉmʉita, catorce paiyajuboa bácavʉ cʉrejaquemavʉ. Aru David bácʉi cʉrinʉmʉre, pʉ ina Babilonia ãmicʉrõcavʉ bácavʉ ne bʉorĩ nʉvaiyeta maja Israecavʉ maje jipocacavʉ bácavʉre Babiloniaita, apevʉ catorce paiyajuboa bácavʉ cʉrejaquemavʉ. Aru maja Israecavʉ maje jipocacavʉ bácavʉre ne bʉorĩ nʉvaiyede, pʉ ñai Cristoi põeteiyeta, apevʉ catorce paiyajuboa bácavʉ cʉrejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yópe barejávʉ̃ya Jesucristo ʉ̃i põeteino mácarõ. Jípaco bacod̶ó María ãmicʉco barejácod̶a. Joséi márepaco bacod̶ó barejácod̶a. Ṍre ʉ̃i nomicʉbedata cãreja, javeta õ micatedejaquemavʉ ñai Espíritu Santo ʉ̃i parʉéque. ");
INSERT INTO cubNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José boropatebecʉ barejámed̶a Jʉ̃menijicʉi jã́inore. Que baru María õi jʉed̶ojĩcʉre eaiyede coreóvarĩ, judíova ne d̶aicõjeiyepedeca d̶aiyʉrĩ, ṍre jarʉvacʉyʉ barejámed̶a. Ʉbenita Josécapũravʉ ye jarʉvaiyʉbedejamed̶a ṍre põeva ne jã́iyede, “Cʉyoje tede d̶aquijichʉvʉ yʉ ṍre” ayʉ. Que baru ṍre põeva ne jã́mene jarʉvaiyʉrĩdurejamed̶a ñai José. ");
INSERT INTO cubNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ʉ̃i nópe dápiarĩburu yóboi, cũinácʉ ángele, Jʉ̃menijicʉi daroimʉ, earejamed̶a vʉorʉ̃mʉi José yebai. Aru yópe arĩ, coyʉrejamed̶a ʉ̃́re: —Mʉ, José, David bácʉi pãramecʉ, jidʉbecʉva Maríare nomicʉjacʉ mʉ. Espíritu Santo ʉ̃i jʉed̶ojímo mácotame õ. ");
INSERT INTO cubNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ʉ̃mʉ jʉed̶ojĩcʉre cʉvacod̶ome õ. Ʉ̃ macʉyʉ́me mead̶acʉyʉ ʉ̃i põevare, ne ãmeina teiyede jarʉvarĩ. Que baru ʉ̃ macʉyʉ́ Jesús ãmicʉcʉyʉme ʉ̃, arejamed̶a ñai ángele Joséde. ");
INSERT INTO cubNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Caiye iye nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉ ʉ̃i coyʉicõjeiye báquepedeca cũinácʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: ");
INSERT INTO cubNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Nomió ʉ̃mʉcʉbecova jʉed̶oearĩ jʉed̶ocʉvacod̶ome õ. Emanuel ãmicʉcʉyʉme ʉ̃ macʉyʉ́, arejaquemavʉ ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ. Emanuel aiyʉrõ, “Jʉ̃menijicʉ majaque cʉbi”, aiyʉrõtamu. ");
INSERT INTO cubNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Que teni José coedarĩ, ángele ʉ̃i aiye báquepe d̶arejamed̶a. Maríare nʉvarejamed̶a ʉ̃i cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ʉbenita ṍque cʉbedejamed̶a cãreja, pʉ õi mácʉre jʉed̶ocʉvarĩburu yóboita. Aru õi jʉed̶ocʉvaede, “Jesús bájacʉ mʉ” arĩ, ãmidorejamed̶a José. ");
INSERT INTO cubNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Belén ãmicʉriĩmaroi, Judea ãmicʉrijoborõi, põetedejamed̶a Jesús. Ʉ̃i põeteiyede dijoborõcavʉ ne jabocʉ Herodes ãmicʉcʉ barejámed̶a. Ʉ̃ cʉrejamed̶a Jerusalén ãmicʉriĩmaroi. Dinʉmʉre aviá dainocavʉ, abiácovare bueipõeva, earejaimad̶a Herodes yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Earĩ, yópe arĩ, jẽniari jã́rejaimad̶a: —¿Mʉja judíova mʉje jabocʉ bacʉyʉ́, ã́ri põetecʉba ʉ̃? Cũinácʉ abiácorʉ ʉ̃i põeteiyede jã́d̶ovañʉre jã́ri, daivʉbu ñʉja, jínajivʉ mearore ʉ̃́re, arejaimad̶a ina abiácovare bueipõeva. ");
INSERT INTO cubNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Apevʉ diede ne coyʉiyede jápiarĩ, ãmei cãrijiñʉ marejámed̶a ñai jabocʉ. Ʉ̃i jabocʉ bae boje, apecʉ jabocʉ ʉ̃i põeteiyede jápiaiyʉbedejaquemavʉ. Aru obedivʉ Jerusalẽ́cavʉ máre cãrijivʉ barejáimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Cãrijiñʉ, ʉ̃́re memecaivʉre órejaicõjenejamed̶a Herodes apevʉ sacerdotevare jaboteipõevare aru Jʉ̃menijicʉi yávaiye báquede bueipõevare máre. Ne eaiyede, yópe arĩ, jẽniari jã́rejamed̶a ñai jabocʉ: —¿Ã́ri põeteyʉba Jʉ̃menijicʉi epeimʉ ijãravʉi, ñai Cristo? arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yópe arĩ, coyʉrejaimad̶a ʉ̃́re: —Belén ãmicʉriĩmaroi, Judeacarõi, põetecʉyʉme Jʉ̃menijicʉi epeimʉ, ñai Cristo. Yopedeca toivaicõjenejaquemavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉre: ");
INSERT INTO cubNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea ãmicʉrijoborõcarõ ĩmaro, Belén ãmicʉriĩmaroi, põetecʉyʉme ñai, Israecavʉ ne jabocʉ bacʉyʉ́, náre jipocatecʉyʉ. Que baru diĩmaro quĩ́jinovacari, parʉrõ maquiyébu, arĩ coyʉrejaquemavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉre, arejaimad̶a ina judíovai jabova Herodede. ");
INSERT INTO cubNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ne coyʉrĩburu yóboi, ʉ̃́re memecaivʉre yavenina órejaicõjenejamed̶a Herodes ina abiácovare bueipõevare, põeva ne jápiabenoi. Náque boroteni, coreóvarĩ majidejamed̶a aipiye bajure abiácorʉ ʉ̃i járorõ mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Majicʉ bácʉ, náre jarorejamed̶a pʉ Belén ãmicʉriĩmaroita. Yópe d̶aicõjenejamed̶a náre: —Vorãnʉjara mʉja jʉed̶ojĩcʉre. Vorĩ eaivʉ bácavʉ, coyʉrãdajarã yʉre cojedeca. Yʉ máre nʉcʉyʉmu ʉ̃i yebai, mearore jícʉyʉ ʉ̃́re, arejamed̶a borocʉcʉ ñai Herodes. ");
INSERT INTO cubNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jápiaivʉ bácavʉ ʉ̃i coyʉiyede, ina abiácovare bueipõeva mái nʉrejaimad̶a, yópe ñai jabocʉ ʉ̃i aiye báquepedeca. Que teni abiácorʉ, ne jã́imʉ mácʉ aviá dainocapũravʉi, náre jipocateni nʉrejamed̶a pʉ ʉ̃i eaiyede jʉed̶ojĩcʉi cʉriñamine. Aru diñami pʉenoi mautedejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ne jã́iyede abiácorʉ mauteyʉre cuibeda diñami pʉenoi, ʉrarõ torojʉrejaimad̶a ne ũmei. ");
INSERT INTO cubNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Diñami cʉ̃rami jívʉi ne ecoiyede, jã́rejaimad̶a jʉed̶ojĩcʉre jípaco Maríaque. Ñʉatutarĩ ʉ̃i yebai, jídejaimad̶a mearore ʉ̃́re. Que teni ne cʉve ĩmaritõcuare voarĩ, úrure, olíbano ãmicʉe mumijʉede, aru mirra ãmicʉe mumijʉede máre jídejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","No yóboi, vʉorʉ̃mʉi, Jʉ̃menijicʉ copainʉicõjemenejamed̶a náre Herodes yebai. Que baru ma apemamata copainʉrejaimad̶a ne cʉrõita. ");
INSERT INTO cubNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ina abiácovare bueipõeva ne nʉriburu yóboi, cũinácʉ ángele, Jʉ̃menijicʉi daroimʉ, cʉetedejamed̶a Joséde vʉorʉ̃mʉi. Yópe arĩ, coyʉrejamed̶a ʉ̃́re: —Coedarĩ, nacajari, nʉvajacʉ jʉed̶ojĩcʉre, jípacore máre, Egipto ãmicʉrijoborõita. Dupini nʉjara mʉja. Jʉed̶ojĩcʉre vorĩ, boarĩ́ jarʉvaicõjecʉyʉme Herodes. Que baru mautejarã mʉja nore pʉ “Nʉjara”, ji aiyeta cojedeca, arejamed̶a ñai ángele Joséde. ");
INSERT INTO cubNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Coedarĩ, jʉed̶ojĩcʉre, jípacore máre, nʉvarejamed̶a José. Diñamimareca Egipto ãmicʉrijoborõita dupini nʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aru nore, Herodes ʉ̃i yaibéde cãreja, mautedejaimad̶a na. Caiye iye nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉ ʉ̃i coyʉicõjeiye báquepedeca cũinácʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: “Jímacʉre cutucacʉ yʉ, ʉ̃i etaquiyepe ayʉ Egipto ãmicʉrijoborõre jocarĩ”, arejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ina abiácovare bueipõeva, ne copainʉmene Herodes yebai yópe ʉ̃i cõjeino mácarõpe, Herodecapũravʉ jorojĩnejamed̶a, ne jʉ abe boje ʉ̃́re. Ne jʉjovaiyede coreóvayʉ bácʉ, jorojĩñʉ, churaravare boarĩ́ jarʉvaicõjenejamed̶a caivʉ ina ʉ̃mʉ jʉed̶ojĩna pʉcaʉjʉa cʉvabevʉre cãreja. Yópe ʉ̃i corevaiyepe ina abiácovare bueipõeva ne coyʉiye báquepe, mamarʉmʉre ne jã́iye báquede abiácorʉre, Herodes boarĩ́ jarʉvaicõjenejamed̶a caivʉ ina ʉ̃mʉ jʉed̶ojĩnare, Belén ãmicʉriĩmaroi cʉrivʉre aru no ĩmaro joabenoi cʉrivʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Yópe Raquel báco õi oiye báquepe, nopedeca ina Belẽ́cavʉ máre orejaimad̶a. Caiye iye nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉ ʉ̃i coyʉicõjeiye báquepedeca ʉ̃i yávaiyede coyʉcaipõecʉ bácʉ Jeremías bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: ");
INSERT INTO cubNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá ãmicʉriĩmarore jápurateavʉ̃ya ʉrarõ ne chĩori oiye. Ico Raquedecabe od̶o mamara mácavʉre boje. Nárecabu yaivʉ bácavʉ. Que baru orĩ dajocabebico õ, arejaquemavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Apenʉmʉa vaiyede, Herodes bácʉ ʉ̃i yainíburu yóboi, José ʉ̃i cʉede Egipto ãmicʉrijoborõi, bedióva cojedeca vʉorʉ̃mʉi cʉetedejamed̶a ʉ̃́re cũinácʉ ángele, Jʉ̃menijicʉi daroimʉ. Yópe arĩ, coyʉrejamed̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Coedarĩ, nacajari, nʉvajacʉ jʉed̶ocʉre, jípacore máre. Mʉje joborõ, Israel ãmicʉrijoborõi, nʉjara cojedeca. Ñai boaiyʉcʉ bácʉ jʉed̶ocʉre jave yaibí, arejamed̶a ñai ángele Joséde. ");
INSERT INTO cubNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José coedarĩ, nʉvarejamed̶a jʉed̶ocʉre jípacoque. Aru copainʉrejaimad̶a Israel ãmicʉrijoborõita. ");
INSERT INTO cubNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Israecarõ Judea ãmicʉrijoborõi nʉ́jʉrorivʉ barejáimad̶a na. Ʉbenita Herodes bácʉi mácʉ, Arquelao ãmicʉcʉ, Judeacavʉre jaboteyʉ barejámed̶a jípacʉ bácʉ yóboi. Aru die borore jápiarĩ, jidʉcʉ, Josécapũravʉ cʉiyʉbedejamed̶a noi. Bedióva cojedeca vʉorʉ̃mʉi, Joséde nore nʉicõjemenejamed̶a Jʉ̃menijicʉ. Que baru apeno Israecarõ, Galilea ãmicʉrijoborõi, nʉrejaimad̶a Joséjã. ");
INSERT INTO cubNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret ãmicʉriĩmaroi nʉri, earĩ, cʉrejaimad̶a na. Nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca ina ʉ̃i yávaiyede coyʉcaipõeva mácavʉre. Yópe arĩ, “Ñai Cristo Nazarecacʉ bacʉyʉ́me”, arejaquemavʉ na mácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Obediʉjʉa yóboi, Juan Bautista coyʉrĩ bʉ́rejamed̶a Jʉ̃menijicʉi yávaiyede. Judea ãmicʉrijoborõcarõ põecʉbenoi, põeva vaivʉre coyʉre curejamed̶a nore. ");
INSERT INTO cubNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Yópe arĩ, coyʉrejamed̶a: —Chĩori dápiarĩ mʉje ãmeina teiyede, oatʉvajarã mʉje d̶aiyede. Mʉje nópe d̶aiyede, maumena mʉjare jabotecʉyʉme Jʉ̃menijicʉ, arejamed̶a, coyʉyʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ñai Juan Bautista barejaquémavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ Isaías ʉ̃i coyʉimʉ mácʉ. Javede yópe arĩ, Isaías bácʉre coyʉicõjenejaquemavʉ Jʉ̃menijicʉ Juan Bautista bacʉyʉ́rã: Jʉ̃menijicʉre coyʉcaipõecʉ cod̶oboboyʉre jápiarãjarama põecʉbenoi: “Mead̶ajarã mʉje ũmene copʉ etaburĩ maje jabocʉre, nopedeca mʉje mead̶aiyepe daimare ñai ʉ̃mʉ, mʉje pued̶aimʉ, ʉ̃i daquiye jipocai. Que d̶arĩ dajocajarã mʉje ãmeina teiyede Jʉ̃menijicʉi daroimʉ macʉyʉ́ ʉ̃i daquiye jipocai, Jʉ̃menijicʉi copʉ etaquiyepe ayʉ mʉjare”, arejaquemavʉ Isaías bácʉ, coyʉyʉ Juan Bautista bacʉyʉ́rã. ");
INSERT INTO cubNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan Bautista dorejamed̶a camello ãmicʉcʉi pod̶aque d̶aicajede ʉ̃i cuitótecaje. Aru ʉ̃i jãrióicãva máre ãimacajeque d̶aicãva marejávʉ̃ya. Ʉ̃ ãre curejamed̶a mujuñuvare aru mumicorore máre, yópe apevʉ nócavʉ cʉve cʉvabevʉpe. ");
INSERT INTO cubNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Obedivʉ põeva, Jerusalén ãmicʉriĩmarocavʉ, Judea ãmicʉrijoborõcavʉ, aru Jordán ãmicʉriya jia ẽcarʉacavʉ máre jápiarãnʉrejaimad̶a Juan Bautista yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Aru jiai, Jordán ãmicʉriyai, na coapa “Ãmecʉbu yʉ” ne arĩburu yóboi Jʉ̃menijicʉre, ne chĩori dápiaiye boje ne ãmeina teiyede, jã́d̶ovarejamed̶a Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Obedivʉ judíovai jabova, fariseo ãmicʉriyajubocavʉ aru saduceo ãmicʉriyajubocavʉ máre, jã́d̶ovaranʉrejaimad̶a Jʉ̃menijicʉque jiai. Ʉbenita na eaivʉre jã́ri, yópe arejamed̶a Juan Bautista: —¡Mʉja jʉjovaivʉbu, mʉje d̶aiye boje mearape! ¡Aru ãd̶avape paivʉbu mʉja, mʉje ãmed̶aiye boje apevʉre! Jʉ̃menijicʉi jorojĩquijãravʉ eaiyede, jãve dupini bʉojabenamu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","D̶ajarã mʉja yópe põeva chĩoivʉ ne ãmeina teiyede, oatʉvaivʉ ne d̶aiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yópe arĩ, “Majeñecu Abraham mácʉ meacʉ barejaquémavʉ. Jʉ̃menijicʉ yóvarejaquemavʉ ʉ̃ mácʉre. Que baru meara bajutamu maja Jʉ̃menijicʉi jã́inore. Aru ʉ̃i jorojĩquinore dupini bʉojarãjaramu maja”, arĩ dápiabejarã mʉja. Jãve coyʉyʉbu mʉjare: Mʉja oatʉvabevʉ baru, Jʉ̃menijicʉi jorojĩquijãravʉ eaiyede dupini bʉojabenamu mʉja. Jápiajarã. Jʉ̃menijicʉ ʉcʉ baru, bʉojaibi oatʉvayʉ iboá cʉ̃raboare Abraham mácʉi pãramena márajivʉre d̶acʉyʉ, ne d̶arãjiyepe ayʉ yópe ʉ̃i ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yópe jiore memeipõecʉ ʉ̃i jã́iyede jocʉcʉa jẽidʉa mearʉa cʉbecʉre ʉ̃i jioi, ʉ̃i jarʉvajʉroepe dicʉáre toaboi, nopedeca Jʉ̃menijicʉ jã́ñʉ mʉjare mearo d̶abevʉre, jarʉvacʉyʉme mʉjare toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Yʉ jãve mʉjare jã́d̶ovaivʉ Jʉ̃menijicʉre ocoque, mʉje chĩori dápiaiye boje mʉje ãmeina teiyede. Ʉbenita dacʉyʉme ji yóboi cũinácʉ, ji pʉeno parʉcʉ. Ʉ̃ macʉyʉ́me jã́d̶ovañʉ mʉjare Jʉ̃menijicʉque Espíritu Santoque, ʉ̃i cʉquiyepe ayʉ mʉjaque aru ʉ̃i cad̶atequiyepe ayʉ mʉjare máre. Aru ʉ̃ macʉyʉ́me jã́d̶ovañʉ mʉjare Jʉ̃menijicʉque toaque máre, mʉje meara tenajiyepe ayʉ yópe põeva ne mead̶aiyepe tãure toaque, aru ʉ̃i ñájine d̶aquiyepe ayʉ mʉjare, meara tebedu. Que baru caivʉ pʉeno meacʉ bajube ʉ̃. Yʉ́capũravʉ pare ʉ̃i cãchinocacʉbu. Que baru ʉ̃́re cad̶ateni bʉojabevʉ yʉ. Pʉ oarĩ bʉojabevʉ yʉ nʉvacayʉ ʉ̃́re ʉ̃i cʉraidoare. ");
INSERT INTO cubNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yópe oteiye memeipõecʉ ʉ̃i veoiyepe jaraboque, oteiyede epecʉyʉ ʉ̃i epeiñami, aru oteiye cajeáre juacʉyʉ, nopedeca Jʉ̃menijicʉ ʉ̃́re jʉ aivʉre epecʉyʉme ʉ̃i jaboteinoi aru ʉ̃́re jʉ abevʉre jarʉvacʉyʉme toabo cũiméboi, arĩ buedejamed̶a Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Dinʉmʉre Jesús nʉrejamed̶a, etacʉyʉ Galilea ãmicʉrijoborõre jocarĩ, pʉ Juan Bautista yebaita, Jordán ãmicʉriya jiai, ʉ̃i jã́d̶ovaquiyepe ayʉ ʉ̃́re Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan Bautistacapũravʉ ʉ̃́re jã́d̶ovaiyʉbedejamed̶a. Que baru arejamed̶a Jesúre: —Yʉre jaʉvʉ mi jã́d̶ovaino ocoi Jʉ̃menijicʉque, ji ãmeina teiye boje. Mʉrecabu meacʉ baju. Que baru mʉre jaʉbevʉ ji jã́d̶ovaino ocoi Jʉ̃menijicʉque, arejamed̶a Jesúre Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ʉbenita Jesúcapũravʉ arejamed̶a: —Yópe Jʉ̃menijicʉi d̶aicõjeiyepe d̶aiye jaʉvʉ majare. Que baru mʉre jaʉvʉ mi jã́d̶ovaino yʉre ocoi Jʉ̃menijicʉque, arejamed̶a ʉ̃́re Jesús. Que baru Juan Bautista jã́d̶ovarejamed̶a Jesúre Jʉ̃menijicʉque no jiai. ");
INSERT INTO cubNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ʉ̃i jã́d̶ovariburu yójĩboi, maumena marejamed̶a Jesús jiare jocarĩ. Dinʉmʉmiareca vorĩ nʉrejavʉ̃ya cavarõ mearo Jʉ̃menijicʉi cʉrõ. Aru Jʉ̃menijicʉi Espíritu jurecope ẽmeni tubacodad̶ore ʉ̃i pʉenora jã́rejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Aru ina cʉrivʉ noi jápiarejaimad̶a apeno yávainore, cavarõ mearo Jʉ̃menijicʉi cʉrõque aiyede yópe: “Ñainecabe jímacʉ, ji ʉmʉ. Me torojʉvʉ yʉ ʉ̃́re”, arejamed̶a Jesúre Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Dinʉmʉre ñai Espíritu Santo nʉvarejamed̶a Jesúre põecʉbenoi, ñai abujuvai jabocʉ ʉ̃i jʉjovarĩduquiyepe ayʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aru cuarenta paijãravʉa, cuarenta paiñamia yéde ãmenejamed̶a Jesús. Que baru no yóboi ãvʉé ijidejavʉ̃ya ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ñai jʉjovayʉ, Satanás ãmicʉcʉ, earĩ, Jesús ãuyaiyʉre coreóvarĩ, arejamed̶a ʉ̃́re: —Jãveneca Jʉ̃menijicʉi mácʉ baru, ãiye d̶ajacʉ iboá cʉ̃raboare, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ʉbenita Jesús arejamed̶a ñai abujuvai jabocʉre: —Mi aiyepe d̶abevʉ yʉ. Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ yópe: “Põeva cʉbenama ne ãiye matʉiyeda. Quénora cʉrãjarama caiye Jʉ̃menijicʉi yávaiyeque máre”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Que arĩburu yóboi, ñai abujuvai jabocʉ nʉvarejamed̶a Jesúre Jerusalén ãmicʉriĩmaroi. Ʉ̃́re mʉri nʉre d̶arejamed̶a Jʉ̃menijicʉi cʉ̃rami pʉenora. ");
INSERT INTO cubNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aru arejamed̶a ʉ̃́re: —Jãve Jʉ̃menijicʉi mácʉ baru, tʉrĩ nʉjacʉ yore jocarĩ, pʉ joborõita. Que baru Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ mi borore yópe: “Jʉ̃menijicʉ jarocʉyʉme ʉ̃i ángelevare, ne corenajiyepe ayʉ mʉre. Jãmʉórajarama mʉre ne pʉrʉáque mi ijié tebequiyepe aivʉ mi cʉbobare cʉ̃raboque”, arĩ toivarejaquemavʉ. Que baru mi tʉrĩ nʉru, yʉ jã́ñʉ bʉojacʉyʉmu Jʉ̃menijicʉ d̶ayʉre yópe ʉ̃i aiye báquepedeca, arejamed̶a Jesúre ñai abujuvai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Aru Jesúcapũravʉ arejamed̶a ʉ̃́re: —Mi aiyepe d̶abevʉ yʉ. Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ yópe: “Jʉjovabejacʉ mi jabocʉ Jʉ̃menijicʉre. Jã́d̶ovaicõjemejacʉ ʉ̃i parʉéde”, arĩ toivarejaquemavʉ. Que baru yéde d̶abevʉ yʉ, jã́d̶ovaicõjejʉrocʉ ʉ̃i parʉéde. Majivʉ yʉ parʉcʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aru bedióva cojedeca ñai abujuvai jabocʉcapũravʉ nʉvarejamed̶a Jesúre. Cʉ̃racũ ʉ̃mʉjʉricũ pʉenoi jã́d̶ovarejamed̶a caiye ijãravʉcarõa ĩmaroare aru caiye die cʉve méne máre. Aru arejamed̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Caiye iye jabocʉbu yʉ. Que baru jíquijivʉ mʉre caiye iyede, mi ñʉatutarĩ mearore jídu yʉre, arejamed̶a Jesúre ñai abujuvai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Dinʉmʉre Jesúcapũravʉ arejamed̶a ʉ̃́re: —Mi aiyepe d̶abevʉ yʉ. Aru mʉ, Satanás, maumena nʉjacʉ mʉ yʉre jocarĩ. Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ yópe: “Mearore jíjacʉ mi jabocʉ Jʉ̃menijicʉre aru ʉ̃́re cũinácʉra memecajacʉ yópe ʉ̃i ʉrõpe”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Que baru ñai abujuvai jabocʉ nʉrejamed̶a Jesúre jocarĩ. Aru ángeleva coreni cad̶atedejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Dinʉmʉre Herodes ãmicʉcʉ jabocʉ bʉoicõjenejamed̶a Juan Bautistare. Die borore jápiayʉ bácʉ Jesús, nʉrejamed̶a Galilea ãmicʉrijoborõi. ");
INSERT INTO cubNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret ãmicʉriĩmarore dajocarĩ, nʉri apeno joborõi, Zabulón aru Neftalí ãmicʉriyajuboa põeyajuboacavʉ ne cʉrijoborõi, nʉrejamed̶a Jesús. Capernaum ãmicʉriĩmaroi cʉcʉnʉrejamed̶a, macajitabʉ ʉrabʉ ẽcarʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉ ʉ̃i coyʉicõjeiye báquepedeca ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre, Isaías ãmicʉcʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: ");
INSERT INTO cubNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón aru Neftalí ãmicʉrijoborõai, Jordán ãmicʉriya apedʉve, jia ʉrad̶acapũravʉi, Galilea ãmicʉrõ, judíova ãmevʉ ne cʉrõtamu. ");
INSERT INTO cubNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ina põeva ñeminoi dobarivʉ bácavʉ ʉrarõ mearo miad̶árore jã́d̶ama. Ina põeva bótainope painoi dobarivʉ bácavʉre, ne ũme yaijʉroede, miad̶áe tʉivʉ náre, arejaquemavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ. Nópe ʉ̃i coyʉiyede, yópe aiyʉrejaquemavʉ: Ina judíova ãmevʉ Jʉ̃menijicʉi yávaiyede jãvene majibedejaquemavʉ aru jãravʉ cũiméjãravʉ baquinóre cʉvabedejaquemavʉ Cristoi daquiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dinʉmʉmiata bueni bʉ́rejamed̶a Jesús. Yópe arĩ, coyʉre curejamed̶a: —Chĩori dápiarĩ mʉje ãmeina teiyede, oatʉvajarã mʉje d̶aiyede. Mʉje nópe d̶aiyede, maumena mʉjare jabotecʉyʉme Jʉ̃menijicʉ, are nʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Que teniburu yóboi, Jesús cuyʉ macajitabʉ ʉrabʉ Galilea ãmicʉrijitabʉ ẽcarʉi, jã́rejamed̶a pʉcarã ʉ̃mʉvare, Simóre aru Andrés ĩmacʉmaquevʉre. Moa boarĩ́ bojed̶aipõeva marejáimad̶a na. Que baru dʉvaivʉ barejáimad̶a ne pápicʉ ʉracʉre dibʉ macajitabʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ne que teiyede, Jesús arejamed̶a náre: —Dajarã yʉ́que. Epequijivʉ mʉjare, mʉje davarãjiyepe põevare ji yebai, yópe mʉje moare davaiyepe pápicʉque, ji mead̶aquiyepe náre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Que ayʉre jápiarĩ, dajocarejaimad̶a ne pápicʉare, nʉrajivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aru cuyʉ cãreja, jipocai jã́rejamed̶a apevʉ pʉcarã ʉ̃mʉvare, Zebedeoi márare, Santiago aru ĩmacʉ Juan. Ĩmarejaimad̶a népacʉque ne jiad̶ocũi, mead̶aivʉ ne pápicʉare. Jã́rina, cuturejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Quénora cũiná dajocarejaimad̶a dicũre aru népacʉre máre, nʉrajivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús bueyʉ barejáme Jʉ̃menijicʉi yávaiyede caino Galilea ãmicʉrijoborõi judíovai cójijiñamiai. Coyʉyʉ barejáme iye yávaiye méne Jʉ̃menijicʉi jaboteiyede põevare. Aru mead̶ayʉ barejáme põevare caiye duica ijié coapa aru caino ijinore máre. ");
INSERT INTO cubNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Que baru caivʉ põeva Siria ãmicʉrijoborõcavʉ jápiarejaquemavʉ Jesúi borore. Aru obedivʉ põeva névʉ ijimarare mead̶arãnʉvarejaima Jesús yebai. Ina duica ijiéde cʉvarivʉre, ijiéde ñájivʉre, ijinore cʉrivʉre, abujuva ĩmamarare, bidivʉre aburi ne jijecamure etaiyeque, aru nacajaiye majibevʉre máre mead̶arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Aru obedivʉ põeva nʉrejaima ʉ̃i yóboi, Galilea ãmicʉrijoborõcavʉ, Decápolis ãmicʉrõcavʉ, Jerusalén ãmicʉriĩmarocavʉ, Judea ãmicʉrijoborõcavʉ, aru Jordán ãmicʉriya jia apedʉvecavʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesús jã́ñʉ ina obedivʉ põevare, mʉri nʉrejamed̶a cʉ̃racũi. Noi ʉ̃i dobacʉnʉiyede, buecʉyʉ ʉ̃i bueimarare, ina põeva nʉrejaimad̶a ʉ̃i yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Náre yópe arĩ bueni bʉ́rejamed̶a Jesús, ne majinajiyepe ayʉ aipe ãrojarivʉre ina põevare, Jʉ̃menijicʉi jaboteimara márajivʉre. Yópe arejamed̶a: ");
INSERT INTO cubNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Torojʉrãjarama ina cõmaje ãrojarivʉ ne ũmei, ne coreóvaiye boje ne baju ãmeina teivʉ. Jʉ̃menijicʉ ʉ̃i cad̶atebedu náre, bʉojabema d̶aivʉ mearore. Nárecabu Jʉ̃menijicʉi jaboteimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Torojʉrãjarama ina chĩoivʉ ne baju ãmeina teiye boje, aru ijãravʉcavʉ ne ãmeina d̶aiye boje máre. Nárecabu Jʉ̃menijicʉi torojʉre d̶aquimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Torojʉrãjarama ina “¿Meara márica ñʉja?” abevʉ, ne coreóvaiye boje Jʉ̃menijicʉ jíyʉre caiye náre jaʉéde, ne cʉvarãjiyepe ayʉ méne, aru ne d̶arãjiyepe ayʉ mearore. Mamajãravʉ edaquijãravʉ baquinóre, nárecabu Jʉ̃menijicʉi mearore jícaquimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Torojʉrãjarama ina teiyʉrivʉ boropatebevʉpe Jʉ̃menijicʉi jã́inore, yópe ãuyaivʉ ne ãiyʉepe aru náre cũiñóiyede ne ũcuiyʉepe. Nárecabu Jʉ̃menijicʉi boropatebede d̶aquimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Torojʉrãjarama ina cõmaje ãroje jã́ivʉ apevʉre, ne coreóvaiye boje Jʉ̃menijicʉi náre cõmaje ãroje jã́menu, na máre ñájijʉrorivʉre ne ãmeina teiye boje. Nárecabu Jʉ̃menijicʉi cõmaje ãroje jã́quimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Torojʉrãjarama ina pʉcaũmea cʉbevʉ, ne d̶aiyʉe boje caiyede yópe Jʉ̃menijicʉi ʉrõpe, ne baju ʉrõpe d̶aiyʉbevʉva. Nárecabu Jʉ̃menijicʉre jã́rajivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Torojʉrãjarama ina cãrijimene d̶aivʉ apevʉre, ne baju cãrijimevʉva cʉe boje Jʉ̃menijicʉque. Nárecabu Jʉ̃menijicʉ “Jímaramu”, ʉ̃i aquimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Torojʉrãjarama ina põeva apevʉ ne ñájine d̶aimara, ne d̶aiye boje mearore yópe Jʉ̃menijicʉi ʉrõpe dajocabevʉva. Nárecabu Jʉ̃menijicʉi jaboteimara. ");
INSERT INTO cubNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Torojʉrãjaramu mʉja põeva Jʉ̃menijicʉre jʉ abevʉ ne jaraiyede mʉjare, ne ñájine d̶aiyede mʉjare, aru ne borocʉrĩ ãmeina coyʉiyede mʉjara máre, mʉje yóvaiye boje yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Me torojʉrãjaramu mʉja. Que teni boje ʉrarõre cʉvarãjaramu mʉja cavarõ mearo Jʉ̃menijicʉi cʉrõi. Nopedeca ina javecavʉ bácavʉ, Jʉ̃menijicʉre jʉ abevʉ bácavʉ máre, ñájine d̶arejaquemavʉ ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre, mʉje jipocacavʉ bácavʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Bedióva Jesús, yópe arĩ, buedejamed̶a náre: —Mʉjarecabu yópe yuquirape paivʉ ijãravʉi. Mead̶aivʉbu maje ãiyede yuquiraque. Nopedeca mʉja meara d̶aivʉbu põevare. Yuquira maje ãiyede mead̶aivʉ. Ʉbenita yuquira ejʉé bíjaru, ãiyede mead̶arĩ bʉojabevʉ. Quédata põeva jarʉvad̶ama diede mára, dimai cuivʉ ne cʉrarãjiyepe aivʉ diena. ");
INSERT INTO cubNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mʉjarecabu yópe miad̶árope paivʉ ijãravʉi. Cũináro ĩmaro cʉ̃racũ pʉenoi cʉrõ maru, ye yaveni bʉojaino ãmevʉ. Que baru caivʉ põeva jã́rajarama diĩmarore. ");
INSERT INTO cubNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Põecʉ pẽoibʉre pẽoriburu yóboi, ñómemi dibʉre pʉebʉ cãchinoi. Quénora ñoimi dibʉre jocʉve pʉenora. Que baru caivʉ diñami cʉ̃rami cʉrivʉ jã́rajarama me. ");
INSERT INTO cubNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nopedecabu mʉje cʉe põeva ne jã́inore. Ména cʉjarã mʉja ijãravʉi, yócavʉ ne jã́rajiyepe aivʉ mʉje mearore d̶aiyede. Diede jã́ri, coreóvarãjarama aipe ãrojacʉre majepacʉ cavarõ mearocacʉre. Aru “Meacʉbu mʉ”, arãjarama ʉ̃́re, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Cojedeca Jesús, yópe arĩ, buedejamed̶a náre: —“Jarʉvacʉdayʉbe”, arĩ dápiabejarã yʉre iye d̶aicõjeiyede Jʉ̃menijicʉi coyʉiye báquede Moisés bácʉre, aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne coyʉiye báquede máre. Diede jarʉvacʉdabevʉ yʉ. Quénora mʉjare jã́d̶ovacʉdayʉbu aipe aiyʉrõre, aru aipe d̶aiye jaʉrõre caiye diede jaʉbevʉva. ");
INSERT INTO cubNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Que baru jãve coyʉyʉbu mʉjare: Cũinájãravʉ yo cavarõ aru yo joborõ máre cũiquíyebu. Ʉbenita caiye iye Jʉ̃menijicʉi yávaiye, ʉ̃i toivaicõjeiye báque, ye cũiméquiyebu. Quénora caiye vaiquíyebu yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃i yávaiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Caiye iye Jʉ̃menijicʉi yávaiye, ʉ̃i toivaicõjeiye báque, jaʉvʉ majare. Que baru caivʉ põevare jʉ are d̶aiye jaʉvʉ caiye diede. ’Ʉbenina yávabecʉbe Jʉ̃menijicʉ. Ácʉ põecʉ apejĩe ʉ̃i yávaiyede jʉ abede d̶abecʉ baru, aru apevʉre máre bueyʉ baru ne jʉ abede d̶abenajiyepe ayʉ, ʉ̃́recabe jaboteimʉ ãmecʉyʉ cavarõ mearo Jʉ̃menijicʉi cʉrõi. Ʉbenita ácʉ põecʉ caiye Jʉ̃menijicʉi yávaiyede jʉ are d̶ayʉ baru, aru apevʉre máre bueyʉ baru ne jʉ are d̶arãjiyepe ayʉ, ʉ̃́recabe Jʉ̃menijicʉi jaboteimʉ me pued̶aimʉ macʉyʉ́ cavarõ mearo Jʉ̃menijicʉi cʉrõi. ");
INSERT INTO cubNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Que baru coyʉyʉbu mʉjare: Mearore d̶aiye jaʉvʉ mʉjare ina Jʉ̃menijicʉi yávaiye báquede bueipõeva pʉeno aru ina fariseova pʉeno máre. Ne pʉeno Jʉ̃menijicʉi ʉrõpe d̶arĩ, mearore d̶abevʉ baru mʉja, ye Jʉ̃menijicʉi jaboteimara ãmenajaramu mʉja, aru cavarõ mearo ʉ̃i cʉrõi cʉbenajaramu mʉja, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yópe arĩ, buedejamed̶a Jesús: —Jápiad̶avʉ̃ mʉja ina javecavʉ jápiaivʉ bácavʉre iye coyʉiye báquede yópe arĩ: “Põevare boarĩ́ jarʉvabejarã mʉja. Ácʉ põecʉ apecʉre boarĩ́ jarʉvayʉ baru, ʉ̃́recabe ñájicʉyʉ”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare yópe: Ácʉ põecʉ jarayʉ baru apecʉre, ʉ̃́recabe ñájicʉyʉ. Ácʉ põecʉ “Ãrʉmecʉbu mʉ” ayʉ baru apecʉre, ʉ̃́recabe ñájicʉyʉ. Aru ácʉ põecʉ “Jʉ̃menijicʉre coreóvabecʉbu mʉ” ayʉ baru apecʉre, ʉ̃́recabe ñájicʉyʉ toabo cũiméboi. Põeva nópe ãmeina yávaivʉ apecʉre ãmeina d̶aivʉbu, yópe ne boarĩ́ jarʉvajʉroepe ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","’Que baru mʉ nʉvañʉ maru mi Jʉ̃menijicʉre jícaquiyede ʉ̃i cʉ̃rami, aru nore earĩ, dápiayʉ baru apecʉ chĩoñʉre mi ãmeina d̶aiye boje ʉ̃́re, epeni dajocajacʉ mi Jʉ̃menijicʉre jícaquiyede iva ʉ̃́re jícaiyede juaiva jipocai. Nʉjacʉ ñai mi ãmeina teimʉ yebai, jẽniacʉyʉ ʉ̃i ãrʉmetequiyepe ayʉ iye mi ãmeina teiye báquede ʉ̃́re copʉ. Mi cãrijimene d̶arĩburu yóboi ʉ̃́que, copainʉri Jʉ̃menijicʉi cʉ̃rami, mi jícaquiyede jíjacʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Apecʉ ʉ̃i ãmecororu mʉre, aru ʉ̃i nʉvaiyʉru mʉre jabova ne ãmeina teivʉre jẽniari jã́iñami, maumena “Mead̶arãjarevʉ” ajacʉ ʉ̃́re, ʉ̃i nʉvamequiyepe ayʉ mʉre jabova ne ãmeina teivʉre jẽniari jã́ipõecʉre, aru ʉ̃i jẽni jíbequiyepe ayʉ mʉre churaravare, aru ne jarʉvabenajiyepe aivʉ mʉre ãmeina teivʉre jẽni jacoiñami jívʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jãve coyʉyʉbu mʉre: Ne bʉoru mʉre ãmeina teivʉre jẽni jacoiñami, etabecʉyʉmu mʉ caiye iye mi bojecʉbe d̶aiyede bojed̶ayʉta, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Bedióva Jesús buedejamed̶a, yópe arĩ: —Jápiad̶avʉ̃ mʉja ina javecavʉ jápiaivʉ bácavʉre iye coyʉiye báquede yópe arĩ: “Ãmeina d̶abejarã mʉja apevʉ némarebʉcʉvaque”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare yópe: Ácʉ põecʉ jã́ñʉ maru nomióre, jẽiyʉrĩ dápiayʉ baru ṍre, ʉ̃́recabe ãmeina d̶ayʉ ṍque ʉ̃i que dápiaiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Que baru mʉ ãmeina teyʉ baru mi jã́iyede yacorʉ meapũravʉcarʉque, ĩni jarʉvajacʉ didʉre. Meaquiyebu bíjaru mʉre cũinárʉ yacorʉ, Jʉ̃menijicʉi jarʉvabequiyepe ayʉ mi baju caibajure toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Aru mʉ ãmeina teyʉ baru mi d̶aiyede pʉrʉ meapũravʉcapʉrʉque, burarĩ jarʉvajacʉ dipʉrʉre. Meaquiyebu bíjaru mʉre cũinápʉrʉ, Jʉ̃menijicʉi jarʉvabequiyepe ayʉ mi baju caibajure toabo cũiméboi, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Bedióva Jesús buedejamed̶a, yópe arĩ: —Jápiad̶avʉ̃ mʉja ina javecavʉ jápiaivʉ bácavʉre iye coyʉiye báquede yópe arĩ: “Ácʉ põecʉ jarʉvayʉ baru jímarepacore, ṍre jíjacʉrĩ cũináyoca ‘Mʉre jarʉvayʉbu yʉ’ aiyocare”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare yópe: Ácʉ põecʉ jarʉvayʉ baru jímarepacore ãmeina d̶abecoreca apecʉque, ʉ̃́recabe ãmeina d̶are d̶acʉyʉ ṍre, ʉ̃i jarʉvarĩburu yóboi cʉco baru apecʉque. Aru ácʉ põecʉ pʉrʉbʉoyʉ apecʉ ʉ̃i jarʉvaimo mácoque, ʉ̃́recabe ãmeina d̶ayʉ ṍque õi mamarʉmʉcacʉre jarʉvarĩ, arejamed̶a Jesús. Nópe ayʉ, “Nomi jarʉvainore ʉbevʉ yʉ”, aiyʉcʉ barejaquémavʉ Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yópe arĩ, buedejamed̶a Jesús: —Jápiad̶avʉ̃ mʉja ina javecavʉ jápiaivʉ bácavʉre iye coyʉiye báquede yópe arĩ: “Borocʉrĩ, ‘Jãve d̶acʉyʉmu yʉ ji coyʉiyepe’, abejarã mʉja. Quénora d̶acajarã Jʉ̃menijicʉre caiyede yópe mʉje coyʉiye báquepedeca ʉ̃́re”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare yópe: Mʉje yávaiyede ye jẽniamejara apecʉre, ʉ̃i jã́d̶ovaquiyepe aivʉ mʉje coyʉiye jãvene. Cavarõ mearotamu Jʉ̃menijicʉi dobarõ mearo cʉrõ. Que baru jẽniamejara cavarõ mearocacʉre, ʉ̃i jã́d̶ovaquiyepe aivʉ mʉje coyʉiye jãvene. ");
INSERT INTO cubNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ijãravʉtamu yópe Jʉ̃menijicʉi cʉboba tʉoinope, ʉ̃i cʉed̶aiye báque boje ijãravʉre aru ʉ̃i pʉrʉcʉvae boje caiyede. Que baru jẽniamejara ijãravʉcacʉre, ʉ̃i jã́d̶ovaquiyepe aivʉ mʉje coyʉiye jãvene. Jerusalén ãmicʉriĩmarotamu Jʉ̃menijicʉ, ñai jabocʉ parʉcʉ baju, ʉ̃i ĩmaro. Que baru jẽniamejara Jerusalẽ́cacʉre, ʉ̃i jã́d̶ovaquiyepe aivʉ mʉje coyʉiye jãvene. ");
INSERT INTO cubNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mʉja oarĩ d̶abevʉ cũináme mʉje pod̶amene boede aru ñemiéne máre. Jʉ̃menijicʉ cũinácʉrecabe oarĩ d̶ayʉ diede. Que baru jã́d̶ovamejara mʉje coyʉiye jãvene mi jipobʉque. ");
INSERT INTO cubNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Que baru mʉje yávaiyede jʉ ajarã aru bi ajarã quénora. Apejĩene coyʉivʉ baru, ãmeina d̶ajebu. Ina borocʉrĩ yávaivʉre jẽniaiye jaʉvʉ apecʉre, ʉ̃i jã́d̶ovariduquiyepe aivʉ ne coyʉiye jãvene. Ʉbenita mʉja jãvene yávaivʉre jaʉbevʉ diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Bedióva yópe arĩ, buedejamed̶a Jesús: —Jápiad̶avʉ̃ mʉja ina javecavʉ jápiaivʉ bácavʉre iye coyʉiye báquede yópe arĩ: “Ácʉ põecʉ ʉ̃i ãmed̶aru apecʉi yacorʉre, ʉ̃i yacorʉre máre ãmed̶ajarã mʉja. Aru ácʉ põecʉ ʉ̃i ãmed̶aru apecʉi cõpiyore, ʉ̃i cõpiyore máre ãmed̶ajarã mʉja”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare yópe: Maucʉvabejarã ina mʉjare ãmed̶aivʉre. Quénora cũinácʉ põecʉ ʉ̃i pẽvaru mʉje meapũravʉcaviobʉre, copedini pẽvaicõjejara mʉje cãcopũravʉcaviobʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aru cũinácʉ põecʉ ʉ̃i nʉvaicõjenu mʉjare jabova ne ãmeina teivʉre jẽniari jã́iñami, aru ʉ̃i ãmecororu mʉjare, jabocʉ ʉ̃i jícõjequiyepe ayʉ mʉjare mʉje camisare ñai põecʉre, ʉ̃i nʉvaicõjequiye jipocai, ʉ̃́re jíjarã dicajede aru mʉje pʉenocacajede máre. ");
INSERT INTO cubNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Cũinácʉ churara ʉ̃i nʉvacaicõjenu mʉjare ʉ̃i cʉvede cũinákilometro, yópe Romacavʉ ne jabova ne cõjeinope, nʉvacajarã diede pʉcakilometros, diede d̶aiyʉbevʉvacari. ");
INSERT INTO cubNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ñai mʉjare jẽniañʉre jíjarã ʉ̃i jẽniaiyede, bojed̶abecʉreca mʉjare. Aru ñai mʉjenore “Jíjarã cãreja” ʉ̃i aru, jʉ arĩ jíjarã mʉjare ʉ̃i jẽniaiyede máre, jacopaiyovabecʉreca mʉjare mʉje jíye báquede ʉ̃́re, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesús buedejamed̶a cojedeca: —Jápiad̶avʉ̃ mʉja ina javecavʉ jápiaivʉ bácavʉre iye coyʉiye báquede yópe arĩ: “Ʉjarã mʉjevʉre aru ʉbejarã mʉje mauvare”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare yópe: Ʉjarã mʉje mauvare. Ina mʉjare ñájine d̶aivʉre jẽniacajarã Jʉ̃menijicʉque, ʉ̃i mearo d̶acaquiyepe aivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Que d̶aivʉ baru, majepacʉ cavarõ mearocacʉ ʉ̃i mára marajáramu mʉja. Ʉ̃́pe paivʉ barãjáramu mʉja, mʉje mearo d̶aiyede mearare aru ãmenare máre. Ʉ̃́recabe aviáre bóre d̶ayʉ ina mearare aru ina ãmenare máre, aru ocare d̶ayʉ ina boropatebevʉre aru ina boropateivʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉja, Jʉ̃menijicʉi põeva, mʉje ʉru náre ina ʉrivʉre mʉjare, Jʉ̃menijicʉ ye bojed̶abecʉyʉme ména põevare ne que d̶aiyede. Ina máre, jabovare tãutʉra ĩcaipõeva, ãmeina d̶aivʉvacari, nópe d̶ad̶ama. ");
INSERT INTO cubNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mʉja, Jʉ̃menijicʉi põeva, jacoyʉivʉ baru mʉjevʉ quévʉra, mearore d̶abevʉ mʉja. Ina máre, judíova ãmevʉ, ãmeina d̶aivʉvacari, nópe d̶ad̶ama. ");
INSERT INTO cubNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Que baru mʉjacapũravʉ, cõmaje ãroje jã́ri, mearore d̶ajarã apevʉre jaʉbevʉva, yópe majepacʉ cavarõ mearocacʉ ʉ̃i d̶aiyepe, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Bedióva cojedeca Jesús, yópe arĩ, buedejamed̶a: —Me jã́jara mʉja mʉje d̶aiyede mearore, cad̶atenajivʉ ina cõmaje ãrojarivʉre. Náre cad̶atedu, jã́icõjenajivʉ apevʉre mʉje d̶aiyede mearore. meamejebu. Nópe d̶aru, majepacʉ cavarõ mearocacʉ ye bojed̶abecʉyʉme mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Que baru cainʉmʉa mʉje jícaiyede cad̶atenajivʉ ina cõmaje ãrojarivʉre, jíbejarã caivʉ ne jã́inoi, yópe ina jʉjovaivʉ ne jíyepe. Nácapũravʉ jíyaima maje cójijiñamiai aru mái máre, jã́icõjenajivʉ apevʉre, ne mearo yávarãjiyepe aivʉ nára. Jãve coyʉyʉbu mʉjare: Nácapũravʉ javede cʉvama ne boje caiyede. Apevʉ põeva ne mearore jíye náre, diebu ne boje matʉiye. Majepacʉ cavarõ mearocacʉ ye bojed̶abecʉyʉme náre. ");
INSERT INTO cubNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ʉbenita mʉjacapũravʉ, mʉje jícaiyede cad̶atenajivʉ ina cõmaje ãrojarivʉre, ñamene coyʉbejarã mʉje d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Quénora cainʉmʉa jíjarã yavenina, apevʉ ne coreóvabenajiyepe aivʉ. Nópe d̶aru, majepacʉ cavarõ mearocacʉ, ñai jã́ñʉ mʉje d̶aiyede yavenina, bojed̶acʉyʉme mʉjare ména, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yópe arĩ, buedejamed̶a Jesús: —Cainʉmʉa mʉje jẽniaiyede majepacʉ Jʉ̃menijicʉque, d̶abejarã yópe ina jʉjovaivʉ ne d̶aiyepe. Nácapũravʉ jẽniad̶aima Jʉ̃menijicʉque, núrivʉ maje cójijiñamiai aru tãibʉai máre, jã́icõjenajivʉ apevʉre, ne ména yávarãjiyepe aivʉ nára. Jãve coyʉyʉbu mʉjare: Nácapũravʉ javede cʉvama ne boje caiyede. Apevʉ põeva ne mearore jíye náre, diebu ne boje matʉiye. Majepacʉ cavarõ mearocacʉ ye bojed̶abecʉyʉme náre. ");
INSERT INTO cubNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ʉbenita mʉjacapũravʉ, mʉje jẽniaiyede Jʉ̃menijicʉque, ecorĩ mʉje cʉ̃ramiai, jedevacobede bieniburu, apevʉ ne jã́menoi, jẽniajara majepacʉque mʉja coapa. Nópe d̶aru, majepacʉ cavarõ mearocacʉ, ñai jã́ñʉ mʉje d̶aiyede yavenina, bojed̶acʉyʉme mʉjare ména. ");
INSERT INTO cubNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Mʉje jẽniaiyede majepacʉ Jʉ̃menijicʉque, cúpecare nʉmejara cũináromia borore mʉje coyʉiyede. Nópe d̶ad̶ama ina judíova ãmevʉ, Jʉ̃menijicʉre coreóvabevʉ, “Ʉrarõ ñʉje coyʉru Jʉ̃menijicʉre, jápiaquijichʉbi ñʉjare”, ne ʉbenina arĩ dápiaiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ne d̶aiyepe d̶abejarã mʉja. Mʉje jẽniarajiye jipocai javeta coreóvaibi majepacʉ cavarõ mearocacʉ aipe jaʉrõre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Que baru yópe arĩ, jẽniajara majepacʉ Jʉ̃menijicʉque: Mʉ, ñʉjepacʉ, cavarõ mearocacʉ, meacʉ bajubu mʉ. Que baru caivʉ põeva mʉre pued̶arĩ mearore jíjarãri. ");
INSERT INTO cubNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Bʉ́re d̶ajacʉ mʉ mi jabotequiyede põevare. Caivʉ ijãravʉcavʉ d̶ajarãri mearore yópe mi ʉrõpe, yópe ina cavarõ mearocavʉ ne d̶aiyepe mi ʉrõpe cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Jíjacʉ ñʉjare jãravʉa coapa ñʉje ãiyeva. ");
INSERT INTO cubNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aru ãrʉmetejacʉ ñʉje ãmeina teiyede, yópe ñʉja máre ñʉje ãrʉmeteiyepe caiye apevʉ ne ãmeina d̶aiyede ñʉjaque. ");
INSERT INTO cubNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ñai abujuvai jabocʉ ʉ̃i jʉjovajʉroede ñʉjare vainí tʉicõjemejacʉ ñʉjare, ñʉje d̶abenajiyepe ãmenore. Quénora ñʉjare ãmed̶are d̶aicõjemejacʉ ñai abujuvai jabocʉre, arejamed̶a Jesús, náre bueyʉ Jʉ̃menijicʉque jẽniaiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aru yópe arĩ, coyʉre nʉrejamed̶a Jesús: —Mʉjacapũravʉi ãrʉmetedu põevare ne ãmeina teiye báquede mʉjare, majepacʉ cavarõ mearocacʉcapũravʉ máre ãrʉmetecʉyʉme mʉje ãmeina teiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ʉbenita mʉjacapũravʉi ãrʉmetebedu põevare ne ãmeina teiye báquede mʉjare, majepacʉ cavarõ mearocacʉcapũravʉ máre ãrʉmetebecʉbe mʉje ãmeina teiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yópe arĩ, buedejamed̶a Jesús: —Mʉje ãmene ãiyede jẽniarajivʉ Jʉ̃menijicʉque, chĩore cubejarã põeva ne jã́inore, ne coreóvarãjiyepe aivʉ mʉja ãmevʉre ãiyede, mʉje jẽniarajiyepe aivʉ Jʉ̃menijicʉque. Nópe d̶ad̶ama ina jʉjovaivʉ. Nácapũravʉ chĩore cuyama, jã́icõjenajivʉ apevʉre ne ména yávarãjiyepe aivʉ nára, ne ãiyede ãme boje. Jãve coyʉyʉbu mʉjare: Nácapũravʉ javede cʉvama ne boje caiyede. Apevʉ põeva ne mearore jíye náre, diebu ne boje matʉiye. Majepacʉ cavarõ mearocacʉ ye bojed̶abecʉyʉme náre. ");
INSERT INTO cubNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ʉbenita mʉjacapũravʉ, mʉje ãiyede ãmene jẽniarajivʉ Jʉ̃menijicʉque, chĩore cubejarã. Quénora vaivéni mʉje pod̶are, cũitútujara mʉje jivare. ");
INSERT INTO cubNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mʉje nópe d̶aru, apevʉ põeva coreóvabenama mʉja ãmevʉre ãiyede. Quénora majepacʉ cavarõ mearocacʉ cũinácʉra coreóvacʉyʉme mʉja ãmevʉre ãiyede. Aru ñai jã́ñʉ mʉje d̶aiyede yavenina, bojed̶acʉyʉme mʉjare ména, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Cojedeca yópe arĩ, buedejamed̶a Jesús: —Vobejarã mʉja ʉrarõ mʉje cʉvae méne ijãravʉi. Diede bocomiva ãinomu, cʉra etainomu, aru ñavacʉrivʉ ecorĩ ñavainomu. ");
INSERT INTO cubNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ʉbenita vojarã mʉja ʉrarõ mʉje cʉvae méne cavarõ mearo Jʉ̃menijicʉi cʉrõi, bocomiva ne ãmenoi, cʉra etabenoi, aru ñavacʉrivʉ ne ĩmenoi máre. ");
INSERT INTO cubNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Que baru mʉje cʉvae cʉrõre dápiarãjaramu mʉje ũmeque máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Cojedeca Jesús buedejamed̶a náre, ʉ̃́que cʉrivʉre: —Põeva ne yacorʉa, pẽoinope, jã́re d̶aivʉ náre, ne memenajiyepe aino aru ne majinajiyepe aino ã́ri ne nʉiyede. Põeva ne yacorʉa ijetedu náre, ye ne memeiyede aru ne nʉiyede máre majibenama. Aru põeva ne ũme, yacorʉape paino, pẽore d̶aivʉ ne dápiaiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Que teni põecʉ cainʉmʉa dápiayʉ baru ijãravʉquede, ijetede d̶aibi ʉ̃i ũmene, ʉ̃i dápiabe boje cavarõ mearo Jʉ̃menijicʉi cʉrõquede. Aru ñai põecʉ ʉ̃i ũme bíjacʉyʉme. Que baru põeva ne jã́menu ne yacorʉaque ãmenotamu. Ʉbenita pʉeno ãmenotamu ne ũme ñemino maru, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yópe arĩ, buedejamed̶a Jesús cojedeca: —Jʉ̃menijicʉre aru tãutʉrare máre ãrʉmejara mʉja. Cũinácʉ põecʉ Jʉ̃menijicʉre ãrʉcʉ baru, pare ãrʉmemi tãutʉrare. Aru tãutʉrare pare ãrʉcʉ baru, ãrʉmemi Jʉ̃menijicʉre. Que baru ñai tãutʉrare ʉcʉ baru, Jʉ̃menijicʉre ʉbecʉyʉme, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Bedióva yópe arĩ, buedejamed̶a Jesús: —Que baru coyʉyʉbu mʉjare: Mʉja ãrʉrivʉ baru Jʉ̃menijicʉre, cãrijimejara mʉja apʉrivʉ mʉje ãrajiyede, mʉje ũcurajiyede máre. Aru cãrijimejara mʉja mʉje bajure, mʉje dorãjiyede máre. Jʉ̃menijicʉi apʉre d̶aiye boje mʉjare, jãve mʉje ãiyede máre cʉvare d̶acʉyʉme. Aru ʉ̃i cʉe d̶aiye boje mʉje bajuáre, jãve mʉje doiyede máre cʉvare d̶acʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jã́rijide apa mʉja ina míjinare. Majepacʉ cavarõ mearocacʉ jíbi náre ne ãiyeva, na otebevʉreca, aru oteiyede ĩmevʉreca, aru diede máre epebevʉreca oteiyede epeiñamia jívʉi. Aru caivʉ míjina obedivʉ pʉeno bojecʉrivʉtamu mʉja, Jʉ̃menijicʉi pʉeno ʉe boje mʉjare. Que baru mʉjare jaʉéde jícʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aru mʉjacacʉ cãrijiñʉ maru, cũináora cʉre d̶arĩ majibebi ʉ̃i cʉede ijãravʉi. Que baru cãrijiye meamevʉ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Que baru, ¿aipe teni cãrijivʉrʉ̃ mʉja mʉje dorãjiyede? Jã́rijide apa mʉja iye cóvʉare, dácarõre. Die bʉcʉiyavʉ̃, mememevacari, aru ne cuitótecajeare máre naremevacari. ");
INSERT INTO cubNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ʉbenita coyʉyʉbu mʉjare: Iye cóvʉa métamu, caiye icajea ñai jabocʉ bácʉ Salomón mácʉi cuitótecajea bojecʉricajea pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","¡Mʉja pare quĩ́jino jʉ aivʉbu Jʉ̃menijicʉre! Jʉ̃menijicʉ nópe mearo d̶aibi iye cõriáre, caride dái cʉede aru javenare põeva ne juarãjiyede. Nopedeca Jʉ̃menijicʉ jícʉyʉme mʉjare mʉje cuitótecajea meacajeare caiye iye cóvʉa pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Que baru cãrijimejara mʉja yéde mʉje ãrajiyede, mʉje ũcurajiyede, aru mʉje dorãjiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ina judíova ãmevʉ, Jʉ̃menijicʉre jʉ abevʉ, cãrijini vod̶ama caiye iyede, ne ãrajiyede, ne ũcurajiyede, aru ne dorãjiyede máre. Aru majepacʉ cavarõ mearocacʉ majibi caiye iye mʉjare jaʉéde. ");
INSERT INTO cubNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ʉbenita vojarã mʉja iye Jʉ̃menijicʉi jaboteinoquede, mʉje d̶aiyʉe boje mearore yópe ʉ̃i d̶aicõjeiyepe. Aru Jʉ̃menijicʉ jícʉyʉme mʉje ãrajiyede, mʉje ũcurajiyede, aru cuitótecajeare máre. ");
INSERT INTO cubNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Que baru cãrijimejara iye vaiquíyede mʉjare javenare. Caijãravʉa coapa põeva ñájiñama ãmenore. Que baru dápiajarã cari jãravʉque ãmenore, apejãravʉ edaquijãravʉque ãmenore dápiabevʉva, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesús, yópe arĩ, buedejamed̶a náre cojedeca: —“Ãmenatamu” arĩ, ãmecorobejarã mʉja apevʉre. Mʉje nópe aru, majepacʉ Jʉ̃menijicʉ ãmecororĩ, “Ãmenatamu mʉja” acʉyʉme mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yópe mʉje ãmecoroiyepe apevʉre, nopedeca mʉjare ãmecorocʉyʉme Jʉ̃menijicʉ. Nópe mʉje apevʉre jíyepedeca, jícʉyʉme mʉjare Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ʉrarõ ãmeina teino mʉje cʉvaru, ãmecoroiye jaʉbevʉ apevʉ quĩ́jino ãmeina teivʉre. Nópe d̶aiye yópe bájebu: Me jã́ivʉbu mʉja mʉjecʉ ʉ̃i docʉjĩe cʉrõre ʉ̃i yacorʉi. Ʉbenita jã́mevʉ mʉja mʉje ʉrarõ docʉcʉrõre mʉje yacorʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aru jã́mevʉvacari mʉja ʉrarõ docʉcʉrõre mʉje yacorʉi, mʉjecʉre “¿Mi docʉjĩene ĩnaji mi cʉvaede mi yacorʉi?” arĩ bʉojabevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Jʉjovaivʉtamu mʉja! Mamarʉmʉ ĩjara mʉja mʉje ʉrarõ docʉcʉrõre mʉje yacorʉre. No yóboi mearo jã́ivʉta, ĩjara mʉjecʉ ʉ̃i docʉjĩene ʉ̃i cʉvaede ʉ̃i yacorʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jʉ̃menijicʉi yávaiye pʉeno me bajure coyʉbejarã ina põeva ãmenare, diede jápiarĩ eabevʉre. Nópe d̶aru, yópe põeva ne jíjʉroepebu jiarʉare yavimivare. Jiarʉa méne aru ãmene máre coreóvabeni, copedini cũñaima náre jívʉre. Nopedeca ina põeva ãmena, Jʉ̃menijicʉi yávaiyede jápiaiyʉbevʉ, ãmed̶arãjarama mʉjare diede coyʉrĩduivʉre náre. Aru ji yávaiye méne, pʉeno bojecʉede põevare ne ũmei, buebejarã ina põeva ãmenare, diede jápiarĩ eabevʉre. Nópe d̶aru, yópe põeva ne dʉvajʉroepebu cʉ̃rajiboa bojecʉrijĩboa perla ãmicʉrijĩboare vã́riva ne jipocai. Nijiboare coreóvabeni, cʉrad̶aima nijiboare jobo jívʉi. Nopedeca ina põeva ãmena, ji yávaiye méne jápiaiyʉbevʉ, ãmed̶arãjarama mʉjare diede bueniduivʉre náre, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesús coyʉrejamed̶a náre yópe: —Jẽniare nʉjara Jʉ̃menijicʉque, aru jícʉyʉme mʉje jẽniainore ʉ̃́que. Vore nʉjara ʉ̃́re, aru earãjaramu. Mʉje órejare nʉiyede jedevacobei, Jʉ̃menijicʉ voacacʉyʉme mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Que baru caivʉ jẽniaivʉ Jʉ̃menijicʉque cʉvama ne jẽniainore. Caivʉ voivʉ ead̶ama ne voimʉre. Aru caivʉ órejaivʉre jedevacobei voaibi náre Jʉ̃menijicʉ, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aru cojedeca Jesús, yópe arĩ, buedejamed̶a náre: —¿Mʉja jʉed̶ocʉvarivʉ, mʉjemacʉ ʉ̃i jẽniaru mʉjare pã́ubore, jíje bárica mʉja ʉ̃́re cʉ̃rabore? ");
INSERT INTO cubNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Aru mʉjemacʉ ʉ̃i jẽniaru mʉjare moacʉre, jíje bárica mʉja ʉ̃́re ãd̶are? ¡Que ãmevʉ! ");
INSERT INTO cubNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Que baru mʉja ãmena méne cʉvaede jíni majiépedeca mʉjemarare, majepacʉ cavarõ mearocacʉ pʉeno méne cʉvaede jíni majibi mʉja jẽniaivʉre ʉ̃́que. ");
INSERT INTO cubNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Que baru d̶ajarã apevʉre yópe mʉje ʉepe d̶aivʉre mʉjaque me. Nopedeca d̶aicõjenejaquemavʉ Jʉ̃menijicʉ põevare ʉ̃i coyʉiye báquede ʉ̃i yávaiyede Moisés bácʉre aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yópe arĩ, náre buede nʉrejamed̶a Jesús: —Ecojarã Jʉ̃menijicʉi jaboteinoi, yópe mʉje ecoiyepe jedevacobe quĩ́jicobei. Yópe jedevacobe ʉracobepe aru ʉrama maiyójabe ne cuimape, obedivʉ põeva nʉivʉbu, ne bíjarãjiyede toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ʉbenita yópe jedevacobe quĩ́jicobepe aru quĩ́jima maiyójae ne cuima, obebejĩna nʉivʉbu, ne mead̶arãjiyede cavarõ mearo Jʉ̃menijicʉi cʉrõi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Cojedeca Jesús buedejamed̶a náre, ne majinajiyepe ayʉ aipe ãrojarivʉre bueipõevare: —Me jã́jara ina Jʉ̃menijicʉi yávaiyede coyʉcaipõevape teivʉ, ʉbenina ne buenajiyepe aivʉ borocʉede. Námu yópe ãimara jijecʉrivʉ lobova ãmicʉrivʉpe paivʉ. Ovejavape teni ina lobova ecod̶ama ne yebai, boarã́jivʉ náre. Nopedeca ina borocʉede bueivʉ, Jʉ̃menijicʉre jʉ aivʉpe yávad̶ama, ecorãjivʉ mʉje yebai. Ʉbenita ãmed̶aiyʉrivʉbu mʉjare mʉje ũmei. ");
INSERT INTO cubNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Náre coreóvarãjaramu mʉja ne d̶aiyeque, yópe maje coreóvaiyepe jocʉcʉre dicʉ jẽidʉaque. Miuñʉa jẽmevʉ ʉ́yaiboare. Nopedeca jẽmevʉ higo ãmicʉridʉa miuñʉare. ");
INSERT INTO cubNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jocʉcʉ meacʉ cʉvavʉ jẽidʉa mearʉare. Ʉbenita jocʉcʉ ãmecʉ, ãmedʉare cʉvavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jocʉcʉ meacʉ cʉbevʉ jẽiye ãmene jícʉ. Aru jocʉcʉ ãmecʉ cʉbevʉ jẽiye méne jícʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Caiye jocʉcʉa jẽidʉa mearʉa cʉbedu, jiore memeipõecʉ coení jarʉvajebu toaboi. Nopedeca Jʉ̃menijicʉ ina borocʉede bueivʉre ñájine d̶acʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nopedeca coreóvarãjaramu mʉja ina borocʉede bueivʉre aru ina yávaiyede jãvene bueivʉre máre ne d̶aiyeque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Bedióva buede nʉrejamed̶a Jesús: —Caivʉ ina yʉre aivʉ “mʉ, ñʉje jabocʉ”, ʉbenita d̶abevʉvacari yópe jipacʉ, cavarõ mearocacʉ, ʉ̃i ʉrõpe, ecobenama ʉ̃i jaboteinore. Quévʉra ina ʉ̃i ʉrõpe d̶aivʉ ecorãjarama nore. ");
INSERT INTO cubNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ãnijãravʉ daquijãravʉ baquinóre obedivʉ põeva, yópe arĩ, coyʉrãjarama yʉre: “Mʉ, ñʉje jabocʉ, ñʉjarecabu Jʉ̃menijicʉi yávaiyede coyʉcaivʉ bácavʉ, aru jarʉvaivʉ bácavʉ abujuvare, aru ʉre põeva ne d̶arĩ majibede máre d̶aivʉ bácavʉ mi ãmiái, mi parʉéque”, arãjarama. ");
INSERT INTO cubNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Dinʉmʉ maquinóre náre coyʉcʉyʉmu yʉ: “Jívʉ ãmevʉ mʉja. ¡Que baru caivʉ mʉja ãmeina teivʉ nʉjara yʉre jocarĩ!” acʉyʉmu, arejamed̶a Jesús, náre ecoicõjemecʉ Jʉ̃menijicʉi jaboteinore. ");
INSERT INTO cubNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Cojedeca Jesús, yópe arĩ, buedejamed̶a náre: —Ina jápiaivʉ yʉre aru d̶aivʉ ji cõjeiyepe d̶aivʉbu yópe ñai cʉ̃ramine d̶ayʉpe jãjaroi. ");
INSERT INTO cubNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ocarĩ, jia yaborĩ, oco eaquemavʉ diñamine. Ʉrarõ japuquemavʉ ũmevʉ. Ʉbenita cújibetequemavʉ diñami, jãjaroi núe boje. ");
INSERT INTO cubNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ʉbenita ina jápiaivʉvacari yʉre, d̶abevʉ baru ji cõjeiyepe d̶aivʉbu yópe ñai cʉ̃ramine d̶ayʉpe jãjamenoi. ");
INSERT INTO cubNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ocarĩ, jia yaborĩ, oco eaquemavʉ diñamine. Ʉrarõ japuquemavʉ ũmevʉ. Aru tʉquemavʉ diñami. Ʉrarõ bíjaino matequémavʉ, arĩ buedejamed̶a Jesús. Ʉ̃i nópe aiyede, yópe aiyʉcʉ barejaquémavʉ Jesús: Ina d̶aivʉ yópe ʉ̃i ʉrõpe bíjabenajarama, ʉbenita ina d̶abevʉ yópe ʉ̃i ʉrõpe bíjarãjarama. ");
INSERT INTO cubNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Aru Jesús ʉ̃i bueni bʉojaiyede, ina obedivʉ põeva, ʉ̃i coyʉiyede jápiaivʉ bácavʉ ʉrarõ dápiarĩ cuecumarejaimad̶a, ʉ̃i bueiye boje náre yópe parʉcʉpe ina Jʉ̃menijicʉi yávaiye báquede bueipõeva pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús ẽmeñʉ mácʉre dicũ cʉ̃racũre jocarĩ, obedivʉ põeva nʉrejaimad̶a ʉ̃i yóboi. ");
INSERT INTO cubNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Aru nʉrejamed̶a Jesús yebai cũinácʉ pojeyʉ. Ñʉatutarĩ, arejamed̶a ʉ̃́re: —Mʉ, ji jabocʉ, ʉcʉ baru, mead̶ajacʉ ji pojeiyede. Bʉojaivʉ mʉ mead̶ayʉ yʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Dinʉmʉre Jesús, ʉ̃i pʉrʉque jabióvarĩ tʉoyʉ, arejamed̶a ʉ̃́re: —Ʉvʉ yʉ. Caride meatejacʉ mʉ, arejamed̶a Jesús. Aru maumejiena Jesús ʉ̃i que aiyede, meatedejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús coyʉicõjemecʉ apevʉre arejamed̶a: —Cũiná, nʉri Jerusalén ãmicʉriĩmaroi, jã́d̶ovajacʉ sacerdotede. Aru jíjacʉ mi meateiye boje, yópe Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquepe Moisés bácʉre, põeva ne coreóvarãjiyepe ayʉ mi meateinore, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús ʉ̃i ecoiyede Capernaum ãmicʉriĩmaroi, cũinácʉ ʉ̃mʉ, cien paivʉ churaravai jabocʉ, nʉrejame ʉ̃i yebai. Yópe arĩ, jẽniañʉ marejáme, ʉ̃i cad̶atequiyepe ayʉ: ");
INSERT INTO cubNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Mʉ, ji jabocʉ, cũinácʉ ji yebacacʉ cʉbi cʉ̃rami, parayʉ, nacajaiye majibecʉ. Aru pare ñájiñʉme ʉ̃, arejame Jesúre ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aru Jesús arejame: —Yʉ́vacari ʉ̃́re mead̶acʉdaquijivʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ʉbenita ñai jabocʉ arejame Jesúre: —Mʉ, ji jabocʉ, meacʉbu mʉ. Ʉbenita yʉ́capũravʉ ãmecʉtamu. Que baru darĩ ecobejacʉ ji cʉ̃rami. Quénora coyʉjacʉ mi cõjeinore. Aru ji yebacacʉ meatecʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yʉrecabu cʉcʉ ne cõjeiyeque ina ji jabova. Aru cʉvavʉ churaravare, ji cõjeimarare. Nácacʉ cũinácʉre “Nʉjacʉ” ji arĩburu, nʉimi ʉ̃. Aru “Dajacʉ” ji arĩburu, daibi ʉ̃. Aru ji d̶aicõjenu apejĩene ji yebacacʉre, d̶aibi ʉ̃, arejame Jesúre. Ʉ̃i que aiyede, “Ijiéde cõjeipõecʉbu mʉ” aiyʉcʉ barejaquémavʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Que ayʉre jápiarĩ, pare dápiarejame Jesús. Aru jã́ri ina nʉivʉre ʉ̃i yóboi, arejame: —Jãve coyʉyʉbu mʉjare: Eabevʉ cãreja majacacʉre, Israecacʉre, me jʉ ayʉre yʉre yópe ñai churaravai jabocʉpe. ");
INSERT INTO cubNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Coyʉyʉbu mʉjare: Darãjarama põeva cainoa joborõacavʉ, yʉre jʉ aipõeva. Dobarãjarama tʉoiva yebai, ãrajivʉ Jʉ̃menijicʉi jaboteinoi ʉ̃i põevaque, Abrahãque, Isaaque, aru Jacoque máre. ");
INSERT INTO cubNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ʉbenita obedivʉ mʉjacavʉ, judíova, ina cʉ́jʉrorivʉ bácavʉ noi, jarʉvaimara marajárama ñeminoita, ne jʉ abe boje yʉre, ne coatenajiyepe ayʉ yʉre jarʉvarĩ. Chĩoivʉ orĩ mautenajarama nore. Aru jararĩ cõpi cũrajarama na, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Dinʉmʉ ñai jabocʉre arejame Jesús: —Copainʉjacʉ mʉ mi cʉ̃rami. Jave d̶acavʉ yʉ yópe mi jẽniaiyepe. Jave mi yebacacʉre mead̶avʉ yʉ, mi jʉ aiye boje yʉre, arejame Jesús. Aru dinʉmʉmareca meatedejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús nʉrejamed̶a Simón Pedroi cʉ̃rami. Ecoyʉ bácʉ noi, jã́rejamed̶a Pedroi vácore, moimo parad̶ore. ");
INSERT INTO cubNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Õi yebai nʉri, ṍre tʉorejamed̶a Jesús ʉ̃i pʉrʉque. Aru dajocarejavʉ̃ya moino ṍre. Dinʉmʉmia nacajari, ãiyede mead̶arĩ jídejacod̶a ina noi cʉrivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Dinainumica ñamijie baji, jabʉóvaijãravʉ vaiyede, ina ĩmarocavʉ nʉvarejaimad̶a Jesús yebai obedivʉ abujuva ne ĩmamarare. Ina abujuvare yávarĩ jaetovarejamed̶a Jesús. Aru caivʉ ina ijimarare máre mead̶arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Caiye iye nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca ʉ̃i yávaiyede coyʉcaipõecʉ bácʉ, Isaías ãmicʉcʉ, ʉ̃i aiye báquede Jʉ̃menijicʉi epequimʉra: “Ʉ̃́recabe maja parʉbevʉre mead̶ayʉ, aru majare ijiéde jarʉvayʉ”, arejaquemavʉ Isaías bácʉ Jesúrã. ");
INSERT INTO cubNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús ina obedivʉ põevare jã́ñʉ ʉ̃i yebai, jataicõjenejame ʉ̃i bueimarare. —Jã́rica, macajitabʉ ʉrabʉ apedʉvei nʉrevʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dinʉmʉ cũinácʉ Jʉ̃menijicʉi yávaiye báquede bueipõecʉ ʉ̃i yebai nʉri, arejame: —Mʉ, bueipõecʉ, mʉ́que nʉquijivʉ yʉ caino mi nʉinoita, arejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aru Jesús arejame ʉ̃́re: —Macayavimiva cʉvama ne cobeá. Aru míjina cʉvama ne juaiboa. Ʉbenita yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji cʉrõ cʉvabevʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Apecʉ, ʉ̃i bueimʉ, arejame ʉ̃́re: —Mʉ, ji jabocʉ, mamarʉmʉre jarʉvaquijivʉ cãreja jipacʉre cʉ̃racobei, ʉ̃i yaiyede. No yóboi mʉ́que nʉquijivʉ, arejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ʉbenita Jesúcapũravʉ arejame: —Dajacʉ yʉ́que. Ina yaivʉ bácavʉpe paivʉ, ne jápiabe boje Jʉ̃menijicʉi jaboteinoque yávaiyede, jarʉvajarãri ina yaivʉ bácavʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús jatuyʉ jiad̶ocũi, ñʉjare ʉ̃i bueimara máre jaturejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","No macajitabʉ ʉrabʉre jataivʉre japurejavʉ̃ ũmevʉ parʉrõ baju. Aru pãcaiboa coiyede jiad̶ocũi, buidéjavʉ̃ dicũre oco. ");
INSERT INTO cubNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ʉbenita Jesús cãñʉ marejáme. Que baru ʉ̃i yebai nʉri, yópe arĩ, coedavarejacarã ʉ̃́re: —¡Mʉ, ñʉje jabocʉ, mead̶ajacʉ ñʉjare! ¡Coivʉbu maja! ¡Bíjarãjivʉbu maja! arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aru Jesús arejame ñʉjare: —¿Aipe teni jidʉrivʉrʉ̃ mʉja? ¿Aipe teni “Jesús mead̶acʉyʉme ñʉjare”, abevʉrʉ̃ mʉja? arejame ñʉjare Jesús. Dinʉmʉre nacajari, jararejame ũmevʉre. Iboá ʉraboa pãcaiboa bíjarejavʉ̃. Aru cãrijimene d̶arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cuecumari, ʉrarõ dápiarejacarã. Aru arejacarã ñʉje bajumia: —¿Yécʉba ñai, yópe cõjeñʉ ũmevʉre aru macajitabʉre máre jʉ aimʉ? arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","No macajitabʉ ʉrabʉre jatarĩ nʉri, apedʉvei Gadara ãmicʉrõi earejacarã ñʉja. Ñʉje maiyede jiad̶ocũre jocarĩ, pʉcarã ʉ̃mʉva, abujuva ne ĩmamara, Jesúre copʉ nʉrejaima. Cʉ̃racobeai, põeva ne yaivʉ bácavʉre jarʉvainoi, cʉrivʉ barejaquémavʉ na. Ne pare jijecʉe boje, põeva ye oabedejaquemavʉ vaivʉ nore. ");
INSERT INTO cubNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Aru bʉjié cod̶oboborejaima: —Mʉ, Jesús, Jʉ̃menijicʉi mácʉ, ¿yéde ʉcʉrʉ̃ ñʉjaque? ¿Ñʉjare ñájine d̶acʉyʉrʉ̃ Jʉ̃menijicʉi abujuvare ñájiovaquijãravʉ jipocamia? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Joabenoi ãivʉ barejáima obedivʉ oteivãriva. ");
INSERT INTO cubNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Aru jẽniarejaima ina abujuva Jesúre: —Ñʉjare jaetovayʉ baru, coicõjejacʉ ina oteivãrivara, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Corãnʉjara nára, arejame Jesús. Aru etarĩ, corejaima ina oteivãrivara. Cúyarĩ nʉri, tʉrejaima cʉ̃racũ ẽmeinoi, macajitabʉ ʉrabʉi. Tʉrĩ, corĩ, bíjarejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Aru ina oteivãriva mácavʉre coreipõeva cúyarĩ nʉrejaima, coyʉrãjivʉ ʉraĩmarocavʉre caiye iye vaiye báquede ina pʉcarã abujuva ne ĩmamara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Caivʉ no ĩmarocavʉ copʉ nʉrejaima Jesúre. Aru ʉ̃́re jã́ri, “Nʉjacʉ mʉ” arĩ parʉrõque, etaicõjenejaima ʉ̃́re ne cʉrõre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","No yóboi Jesújã jiad̶ocũi jaturĩ, macajitabʉ ʉrabʉre jatarĩ, earejaimad̶a ʉ̃i ĩmarore. ");
INSERT INTO cubNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Apevʉ ʉ̃mʉva nʉvarejaimad̶a ʉ̃i yebai cũinácʉ ʉ̃mʉ, nacajaiye majibecʉre, ʉ̃i parainoque. Coreóvayʉ bácʉ Jesús náre jʉ aivʉre ʉ̃́re, arejamed̶a ñai nacajaiye majibecʉre: —Mʉ, ji ʉmʉ, chĩomejacʉ. Mi ãmeina teiyede jarʉvarĩ, diede ãrʉmeteivʉ yʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Apevʉ Jʉ̃menijicʉi yávaiye báquede bueipõevacavʉ nore cʉrivʉ, “Ñai ʉ̃mʉ Jʉ̃menijicʉi ʉbenore d̶aibi. Jʉ̃menijicʉpe páyʉ teibi ʉ̃”, arĩ dápiarejaimad̶a na ne ũmei. ");
INSERT INTO cubNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ʉbenita Jesús jã́ri, coreóvarĩ ne dápiaiyede ʉ̃́re, jẽniari jã́rejamed̶a náre: —¿Aipe teni ãmeno dápiaivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Maiyójabevʉ yópe aru apecʉre, “Mi ãmeina teiyede jarʉvarĩ, diede ãrʉmeteivʉ yʉ”, ji parʉéde jã́d̶ovame boje, ji que coyʉiyede. Ʉbenita maiyójarõtamu nacajari cuicõjenu nacajaiye majibecʉre. Ʉ̃́re cure d̶ayʉ baru, jã́d̶ovaquijivʉ ji parʉéde. “Mi ãmeina teiyede jarʉvaivʉ” ji aiyede, coreóvabevʉ mʉja Jʉ̃menijicʉi ãrʉmeteinore diede. Ʉbenita ñai cʉvacʉ Jʉ̃menijicʉi majié parʉéde, ʉ̃́rame yópe d̶arĩ jã́d̶ovaiye majicʉ. Quécʉra Jʉ̃menijicʉvacari mead̶arĩ majibi ijimarare. ");
INSERT INTO cubNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Que baru mʉje majinajiyepe ayʉ Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, yʉ, parʉéde cʉvacʉre ijãravʉre, jarʉvacʉyʉ ãmeina teiyede, yópe d̶aquijivʉ yʉ, arejamed̶a Jesús. Dinʉmʉ arejamed̶a nacajaiye majibecʉre: —Nacajari, mi parainore ĩni, nʉjacʉ mi cʉ̃rami, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dinʉmʉma, yópe Jesús ʉ̃i d̶aicõjeiyepedeca d̶arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ina obedivʉ põeva diede jã́ri, cuecumari, mearore jídejaimad̶a Jʉ̃menijicʉre, ʉ̃i nópe parʉre d̶aiye boje ʉ̃mʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús ʉ̃i vaiyede jã́rejame yʉre, Mateore, dobacʉre ji memeitucubʉi, põeva ne Roma ãmicʉrõ jaboteino bojed̶ainoi. Aru arejame yʉre, “Dajacʉ yʉ́que”. Que baru nacajari, nʉrejacacʉ ʉ̃́que. ");
INSERT INTO cubNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","No yóboi, Jesús ʉ̃i ãcʉnʉiyede ji cʉ̃rami, obedivʉ jabovare tãutʉra ĩcaipõeva, ãmeno d̶aipõeva, aru ʉ̃i bueimara máre dobarejaima, ãrajivʉ ʉ̃́que. ");
INSERT INTO cubNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Apevʉ judíova, d̶aicõjeiyede d̶aiye cõmajivʉ, fariseo ãmicʉriyajubocavʉ, cʉrejaima nore. Ina fariseovacavʉ, Jʉ̃menijicʉi yávaiye báquede bueipõeva, Jesús ãñʉre jã́rejaima ina jabovare tãutʉra ĩcaipõevaque aru ãmeno d̶aipõevaque. Aru arejaima ʉ̃i bueimarare: —¿Aipe teni ãñʉma jabovare tãutʉra ĩcaipõevaque aru ãmeno d̶aipõevaque máre? jẽniari jã́rejaima ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Que aivʉre jápiarĩ, Jesús arejame: —Meara põevare jʉoipõecʉi cad̶ateiye jaʉbevʉ. Quénora ijimarare ʉ̃i cad̶ateiye jaʉvʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Buejarã mʉja, coreóvarãjivʉ me cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉi toivaiye báquede. Yópe arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃ mácʉre: “Ʉvʉ yʉ mʉje cõmaje ãroje jã́rajiyepe ayʉ apevʉre, mʉje yʉre jícaiye pʉeno”, arĩ toivaicõjenejaquemavʉ. Dabedejacacʉ yʉ ijãravʉi, cutucʉyʉ mearare ne baju dápiainore. Quénora darejacacʉ yʉ, mead̶acʉyʉ ãmenare, ne chĩorajiyepe ayʉ ne ãmeina teiyede, Jʉ̃menijicʉi ãrʉmetequiyepe ayʉ diede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dinʉmʉ Juan Bautistai bueimara, Jesús yebai nʉri, jẽniari jã́rejaima ʉ̃́re judíova ne d̶arĩ cõmajiyede, ne jẽniaiyede Jʉ̃menijicʉque ãmevʉva ãiyede: —¿Aipe teni ñʉja aru ina fariseova máre ãmevʉba ãiyede, ʉbenita mi bueimara ãmevʉ ãmema ãiyede? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús jẽvari coyʉrĩ, arejame náre: —Ina pʉrʉbʉoyʉ ʉ̃i cutuimara ne torojʉve tenajiyepe ayʉ ʉ̃i pʉrʉbʉoiyede, ye chĩomenama ʉ̃i cʉede cãreja náque. Que baru ãmevʉ ãmema ãiyede. Nopedeca ji bueimara torojʉrivʉ ji cʉede náque, ãmevʉ ãmema ãiyede. Ʉbenita ji mauva ne nʉvarajiyede yʉre, ji bueimara chĩoivʉ ãmenajarama ãiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Cojedeca Jesús buedejame náre: —Põeva jẽomema cuitótecaje mamacaje joabecajei javecarõre. Nópe d̶aru, no jẽoicajeva mamacaje jad̶evajebu javecarõre. Que d̶aru, pʉeno baju járojebu cod̶eicobe. Quédeca ñame bʉojabema jʉ aivʉ ji bueiye mamaene aru javeque bueiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Põeva yuabema vino ʉ́yaicorore mamacorore ãimacaje curubʉ javecacurubʉque. Que d̶aru, cod̶eóvajebu dicurubʉre. Yurĩ bíjajebu dicoro. Aru bíjajebu dicurubʉ máre. Ʉbenita ne yuaru mamacorore mamacurubʉque, bíjabebu dicoro aru dicurubʉ máre. Quédeca ñame bʉojabema d̶aivʉ yópe ji bueiye mamaepe, d̶are nʉivʉ baru yópe ne jave d̶aiye báquepe, náre arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús ʉ̃i coyʉiyede náre, cũinácʉ maja judíova maje jabovacacʉ darĩ, pued̶arĩ, ñʉatutarejame Jesús jipocai. Que teni yópe arejame: —Carijĩe yaibíco jímaco. Ʉbenita yʉ́que darĩ, tʉojacʉ ṍre mi pʉrʉque, õi apʉcojiyepe ayʉ, arejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ʉ̃i que aiyede, Jesús nacajari, nʉrejame ʉ̃́que, ñʉja ʉ̃i bueimaraque. ");
INSERT INTO cubNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ñʉje vaivárĩ nʉiyede, obedivʉ põeva jẽneboi cʉrejaquemavʉ cũináco nomió, ijimo doce paiʉjʉa baju jive yuiyeque. Jesús yóboi nʉri, jẽni jã́rejaquemavʉ ʉ̃i doicaje tʉrʉvarã. ");
INSERT INTO cubNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yópe arĩ dápiarejaquemavʉ õ: “Yʉ jẽni jã́d̶o maru ʉ̃i doicajede, quénora ũmedacod̶omu yʉ”, arejaquemavʉ õ. ");
INSERT INTO cubNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ʉbenita Jesús copedini, ṍre jã́ri, arejame: —Mʉ, ji ʉmo, torojʉjaco. “Ʉ̃ mead̶aiye majibi yʉre”, arĩ dápiarebu mʉ. Que baru mi que arĩ dápiaiye boje, mead̶aivʉ mʉre, arejame ṍre Jesús. Aru dinʉmʉmareca ico nomió, ijimo máco, meatedejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús eayʉ ñai judíovai jabocʉi cʉ̃rami, pedu japuivʉre aru obedivʉ põeva bʉjié oivʉre jã́rejame. ");
INSERT INTO cubNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Náre etaicõjeñʉ arejame: —Etajarã mʉja. Ico jʉed̶oco yaiyó ãmemico. Quénora cãd̶otame, arejame Jesús. Náre nópe arejame Jesús, ʉ̃i majié boje ʉ̃i nacovaquinore ṍre yainore jarʉvarĩ. Ʉ̃i que aiyede, yʉridejaima ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ʉ̃i etavarĩburu yóboi ina põevare, ecorejame Jesús jʉed̶oco bácoi cʉritucubʉi. Õ mácoi pʉrʉre jẽnejamed̶a. Aru nacajarejacod̶a õ, apʉco cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aru ʉ̃i que d̶aiye borore jápiarejaimad̶a caivʉ põeva dijoborõcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús ʉ̃i dajocarĩ nʉiyede nore jocarĩ, pʉcarã ʉ̃mʉva, jã́ri eabevʉ, darejaima ʉ̃i yóboi. Bʉjié, yópe arĩ, cod̶oboborejaima: —Mʉ, David bácʉi pãramecʉ, Jʉ̃menijicʉi daroimʉ mácʉ, ñʉje jabocʉ bacʉyʉ́, ñʉjare cõmaje ãroje jã́jacʉ mʉ, cod̶oboborĩ are nʉrejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús ʉ̃i ecoiyede cʉ̃rami, ina pʉcarã jã́ri eabevʉ darejaima ʉ̃i yebai. Aru jẽniari jã́rejame náre: —¿Dápiaivʉrʉ̃ mʉja yʉre mead̶aiye majicʉre? arejame. —Jʉ̃́jʉ, ñʉje jabocʉ, majivʉ ñʉja mʉre mead̶aiye majicʉre, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dinʉmʉ ne yacorʉarã tʉorĩ, arejame: —Meatejarã mʉja. Yópe mʉje jʉ aiyepe d̶acaivʉ yʉ mʉjare, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Que d̶ayʉre, jã́rejaima ina jã́ri eabevʉ bácavʉ. Parʉrõreca Jesús apevʉre coyʉicõjemenidurejame náre: —Ñamene coyʉbejarã iye ji mead̶aiyede mʉjare, arĩdurejame. ");
INSERT INTO cubNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ʉbenita cũiná, etaivʉ bácavʉ diñamine jocarĩ, coyʉrejaimad̶a caivʉ dijoborõcavʉre Jesús ʉ̃i mead̶aiye báquede náre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ina pʉcarã jã́ri eabevʉ bácavʉ ne etaiyede, cũinácʉ ʉ̃mʉ, yávaiye majibecʉre, davarejaima apevʉ Jesús yebai. Ñai ʉ̃mʉ abujucʉ ʉ̃i ĩmamʉ marejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús ʉ̃i jaetovarĩburu yóboi ñai abujucʉre, yávaiye majidejame ñai abujucʉ ʉ̃i ĩmamʉ mácʉ. Caivʉ ina obedivʉ põeva Jesús ʉ̃i nópe d̶aiyede jã́ivʉ bácavʉ, cuecumari, ʉrarõ dápiarĩ aivʉ barejáima: —Javede pʉ cari jãravʉita ye jã́mevʉ ñʉja iyepe paiye d̶aiyede yore, ñʉje joborõ, Israel ãmicʉrijoborõi, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ʉbenita ina fariseova yópe are curejaima Jesúrã: —Abujuvai jabocʉi parʉéque jarʉvaibi abujuvare, arejaima ʉbenina. ");
INSERT INTO cubNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús buede nʉrejame cainoa ĩmaroai aru ĩmajinoai máre. Judíova ne cójijiñamiai bueni, coyʉyʉ barejáme iye yávaiye méne Jʉ̃menijicʉi jaboteiyede põevare. Aru mead̶ayʉ barejáme caiye duica ijié coapa aru caino ijinore máre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ʉ̃i jã́iyede põeva chĩoivʉre ne ñájiye boje aru ne baju cad̶ateiye majibe boje, cõmaje ãroje jã́rejame náre, yópe ovejava náre coreipõecʉ cʉbevʉpe paivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Que baru ñʉja ʉ̃i bueimarare arejame Jesús: —Obedivʉ põeva cʉrivʉbu, Jʉ̃menijicʉi yávaiye méne majibevʉ cãreja, mʉje buenajimara iye yávaiye méne, ʉ̃i mead̶aquiyepe aivʉ náre. Ʉbenita obebevʉ memecaivʉbu Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Que baru jẽniajara ʉ̃́que, ʉ̃i bueicõjequiyepe aivʉ apevʉre ʉ̃i yávaiye méne ina diede coreóvabevʉre cãreja, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","No yóboi Jesús órejarejame doce paivʉ ñʉjare ʉ̃i bueimarare. Aru parʉre d̶arejame ñʉjare, ñʉje jaetovarãjiyepe ayʉ abujuvare aru ñʉje mead̶arãjiyepe ayʉ caiye duica ijié coapa aru caino ijinore máre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Ñʉjare beorĩ epedejame ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare: Mamarʉmʉ Simón, ʉ̃i ãmidoimʉ mácʉ Pedro, aru Andrés, Simón Pedroi yócʉ; aru Zebedeoi mácʉ Santiago, aru Santiagoi yócʉ Juan; Felipe aru Bartolomé; Tomás aru yʉ, Mateo, jabovare tãutʉra ĩcaipõecʉ bácʉ; Santiago, Alfeoi mácʉ, aru Tadeo; Simón, ãmicʉcʉ Celote, aru Judas Iscariote máre. Ñai marejáme jẽni jícʉyʉ Jesúre ʉ̃i mauvare. Ñʉja marejacárã Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara. ");
INSERT INTO cubNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ñʉja doce paivʉre jarocʉyʉ barejáme Jesús, ñʉje coyʉrãjiyepe ayʉ Jʉ̃menijicʉi jaboteinoquede yávaiye méne. Yópe arĩ, majicarejame ñʉjare ʉ̃i jaroquiye jipocai: —Judíova ãmevʉ ne joborõai nʉmejara. Aru Samaria ãmicʉrijoborõque ĩmaroare ecobejarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Quénora coyʉrãnʉjara mʉja majevʉre, ina judíova, Israel bácʉi pãramenare. Jʉ̃menijicʉi yávaiyede jápiabeni, ʉ̃i ʉrõpe d̶abeni, ʉ̃́re jaboteicõjemema na. Que baru ovejava mamateivʉpe paivʉbu na. ");
INSERT INTO cubNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mʉje nʉiyede yópe arĩ: “Jʉ̃menijicʉ jabotecʉyʉme põevare maumejiena”, arĩ coyʉjarã náre. Mead̶ajarã ijimarare. Nacovajara yaivʉ bácavʉre yainore jarʉvarĩ. Mead̶ajarã pojeivʉre. Aru jaetovajarã abujuvare ne ĩmamarare jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Bojecʉbeda jívʉ yʉ mʉje parʉéva, mʉje mead̶arãjiyepe ayʉ põevare. Que baru mead̶ajarã náre bojecʉbeda. ");
INSERT INTO cubNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nʉvamejara tãutʉrare mʉje jãrióicãvai. Úrure, platare, aru cobrede máre nʉvamejara. ");
INSERT INTO cubNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Curubʉare máre, mʉje curãnʉri cʉve nʉvajʉroricurubʉare, nʉvamejara mʉja. Aru pʉcacajea mʉje cuitótecajeare, cʉraidoare, aru tuturiteiyoare máre nʉvamejara mʉja. Memecaipõecʉre bojed̶aiye jaʉvʉ ʉ̃i memeinore. Que baru ina mʉje mead̶aimara márajivʉre jíye jaʉvʉ mʉjare jaʉéde. ");
INSERT INTO cubNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ĩmaroi mʉje eaiyede, vorĩ eajarã cũinácʉ põecʉre, ne pued̶aimʉre, jápiaiyʉcʉre mʉje coyʉiyede. Ʉ̃́que cʉjarã mʉja ʉ̃i cʉ̃rami pʉ dajocarĩ nʉivʉta nore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mʉje ecoiyede cʉ̃rami, diñamicavʉre jacoyʉjarã mʉja, jẽniacaivʉ Jʉ̃menijicʉque ʉ̃i mearo d̶acaquiyepe aivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Na meara maru, náre mearo d̶acacʉyʉme Jʉ̃menijicʉ yópe mʉje jẽniaiyepe. Ʉbenita na ãmena maru, náre mearo d̶acabecʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Apecʉ ʉ̃i copʉ etabedu mʉjare, aru mʉje coyʉiyede jápiaiyʉbedu máre, pʉpejarã jobore mʉjare jẽiyede mʉje cʉboba cãchinoi ʉ̃i jã́iyede, mʉje etaiyede ʉ̃i cʉ̃ramine jocarĩ, no ĩmarore jocarĩ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jãve coyʉyʉbu mʉjare: Ina Sodomacavʉ bácavʉ aru ina Gomorracavʉ bácavʉ máre pare ãmeina d̶aivʉ barejaquémavʉ. Ʉbenita diĩmarocavʉ mʉjare copʉ etabevʉ ñájinajarama nócavʉ bácavʉ pʉeno baju, Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, arejame Jesús, ñʉjare jaroyʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús coyʉre nʉrejame ñʉjare, yópe arĩ: —Jã́jara. Jaroivʉ yʉ mʉjare ijãravʉcavʉ jẽneboi, yópe ovejava nʉiyepe ãimara jijecʉrivʉ jẽneboi. Ávaivʉbu maja judíova: Ãd̶a me majibi, aru jureco jijecʉbebico. Que baru ãd̶ape me majijarã, aru jurecope jijecʉbejarã põevaque, mʉje coyʉiyede náre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Me jã́jara mʉja. Mʉjare jẽni nʉvarajarama jabova ne ãmeina teivʉre jẽniari jã́iñami. Jara popenajarama mʉjare maja judíova maje cójijiñamiai. ");
INSERT INTO cubNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Aru mʉjare nʉvarajarama cõjeipõeva ne jipocai aru jabova ne jipocai máre, yʉre mʉje jʉ aiye boje, mʉje coyʉrãjiyepe aivʉ ji borore náre aru ina judíova ãmevʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ne jẽni nʉvaiyede mʉjare ãmeina teivʉre jẽniari jã́iñami, “¿Aipe coyʉrãjidi náre?” arĩ cãrijimejara mʉja. Dinʉmʉ maquinómareca majinajaramu mʉje coyʉrãjiye mʉjare jaʉéde. ");
INSERT INTO cubNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Coyʉjarã mʉja yópe majepacʉi Espíritu ʉ̃i dápiare d̶aquiyepe aivʉ dinʉmʉ maquinóre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Mʉjare, yʉre jʉ aivʉre, ina yʉre jʉ abevʉ ʉbenajarama. Que baru ʉ̃mʉ jẽni jícʉyʉme jíbʉcʉre o ĩmacʉre máre, jabova ne boarĩ́ jarʉvaicõjenajiyepe ayʉ ʉ̃́re. Aru nopedeca jípacʉ jẽni jícʉyʉme mamacʉre. Aru nopedeca némara jʉ abeni nébʉcʉvare maucʉvarĩ boarã́jarama náre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Caivʉ mʉjare, yʉre mʉje jʉ aiye boje, jorojĩni jã́rajarama cainoa joborõacavʉ. Ʉbenita ñai jʉ ayʉ yʉre ʉ̃i yainʉmʉita, ʉ̃ macʉyʉ́me ji mead̶aimʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cũináro ĩmarocavʉ ne ñájine d̶aiyede mʉjare, dupini nʉjara mʉja apeno ĩmaroi. Jãve coyʉyʉbu mʉjare: Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, copaidacʉyʉmu mʉje coyʉrĩ bubarãjiye jipocamia ji yávaiye méne cainoa maje ĩmaroa, Israeque ĩmaroai. ");
INSERT INTO cubNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Ina bueimara ñame majibema náre bueipõecʉ pʉeno. Aru ina memecaivʉ ñame parʉbema ne jabocʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ñai bueimʉre vaiye jaʉvʉ caiye iye ʉ̃́re bueipõecʉi vaiye báquede. Aru ñai memecayʉre vaiye jaʉvʉ caiye iye ʉ̃i jabocʉi vaiye báquede. Põeva ãmeina yávaivʉ baru cʉ̃rami upacʉre, pʉeno baju ãmeina yávarãjarama ʉ̃i cʉ̃ramicavʉre. Quédecabu ina yʉre jʉ abevʉ “Abujuvai jabocʉbu mʉ” aiyʉrĩ yʉre, ãmidoivʉ Beelzebúre. Que baru mʉjare majicayʉbu: Pʉeno baju ãmeina yávarĩ ñájine d̶arãjarama mʉjare, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ñʉjare coyʉre nʉrejame Jesús: —Põevareca jidʉbejarã mʉja. Caiye yaveiye báque jároquiyebu. Aru dupióvaiye báquede máre majinajarama caivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Caiye ji coyʉiyede mʉjare ñeminoi, põeva ne jápiabede, coyʉjarã põevare miad̶ároi, ne jápiaiyede. Aru caiye mʉje jápiaiyede, põeva ne jũjuvaiyede, coyʉjarã obedivʉ põevare ne cójijinoai. ");
INSERT INTO cubNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jidʉbejarã ina boarĩ́ jarʉvaivʉre mʉje bajure, ʉbenita mʉje ũmene boarĩ́ jarʉvaivʉ oabevʉre. Quénora jidʉjarã Jʉ̃menijicʉre, ñaine mʉje bajure aru mʉje ũmene máre, bíjarorĩ majicʉre toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Yócavʉ bojed̶aivʉ pʉcajĩna míjina quĩ́jinare cũinátʉrava tãutʉratʉrava bojecʉbetʉravaque. Ʉbenita cũinájicʉ nácacʉ tʉrĩburu joborõita ʉ̃i yaidú, majepacʉ Jʉ̃menijicʉ tʉicõjeimi ʉ̃́re. Jʉ̃menijicʉ ʉ̃i tʉicõjemenu cũinájicʉ nácacʉre joborõita, tʉbecʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aru caiye iye pod̶amea cʉede mʉje jipobʉi majibi majepacʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Que baru jidʉbejarã. Mʉja bojecʉrivʉtamu caivʉ míjina obedivʉ pʉeno. Que baru Jʉ̃menijicʉi cõjemenu, ãmeno vaibéquiyebu mʉjare, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yópe arĩ, coyʉre nʉrejame Jesús: —Caivʉ ina jʉ aivʉre yʉre põeva ne jã́iyede, yʉ máre náre jʉ acʉyʉmu jipacʉ, cavarõ mearocacʉ, ʉ̃i jã́inoi. ");
INSERT INTO cubNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ʉbenita caivʉ ina jʉ abevʉre yʉre põeva ne jã́iyede, yʉ máre náre jʉ abecʉbu jipacʉ, cavarõ mearocacʉ, ʉ̃i jã́inoi, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Cojedeca Jesús, yópe arĩ, buedejame ñʉjare: —Dápiabejarã mʉja yʉ dayʉ bácʉre, cãrijimene d̶acʉyʉ ijãravʉcavʉre. Dabedejacacʉ yʉ ijãravʉi, cãrijimene d̶acʉyʉ mʉjare. Quénora darejacacʉ yʉ, põevare coatede d̶acʉyʉ, apevʉ yʉre ne jʉ aiye boje ʉbenita apevʉ yʉre ne jʉ abe boje. ");
INSERT INTO cubNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ji daiye báque boje, mamacʉ maucʉvacʉyʉme jípacʉre, aru mamaco maucʉvacod̶ome jípacore, aru mamacʉi márepaco maucʉvacod̶ome õi vácore máre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Que baru põecʉ ʉ̃i cʉ̃ramicavʉvacaribu ʉ̃i mauva márajivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Ácʉ põecʉ jípacʉre o jípacore ʉcʉ baru ji pʉeno, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. Ácʉ põecʉ mamacʉre o mamacore ʉcʉ baru ji pʉeno, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ácʉ põecʉ daiyʉcʉ yʉ́que, dajocajacʉrĩ põeva ne mearo jã́iyede ʉ̃́re, cʉyebejacʉrĩ yʉre yóvaiyede, aru jidʉbejacʉrĩ ʉ̃i ñájiquiyede. Nópe d̶abecʉ baru, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ñai põecʉ ʉ̃i baju ʉrõpe d̶arĩ, mead̶aiyʉcʉ baru ʉ̃i bajure, coatecʉyʉme ʉ̃i bajure Jʉ̃menijicʉre jarʉvarĩ, yópe yaiyʉ́ bácʉpe ʉ̃i ũmei. Ʉbenita ñai põecʉ, “Ye baju ãmevʉ, ji yaidú Cristore boje” ayʉ, ʉ̃i baju ʉrõpe d̶abecʉva quénora ji ʉrõpe d̶arĩ, ʉ̃́recabe ji mead̶aquimʉ, cʉcʉyʉ Jʉ̃menijicʉque cainʉmʉa, ñʉjare arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesús buedejame ñʉjare cojedeca: —Ñai põecʉ copʉ etayʉ baru mʉjare mʉje coyʉrãnʉiyede ji yávaiye méne, yʉre máre copʉ etaibi ʉ̃. Aru ñai põecʉ copʉ etayʉ baru yʉre, copʉ etaibi ñai yʉre daroyʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ñame copʉ etaivʉ cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉre, Jʉ̃menijicʉ bojed̶acʉyʉme náre yópe ʉ̃i bojed̶aiyepedeca ñai ʉ̃i yávaiyede coyʉcaipõecʉre. Aru ñame copʉ etaivʉ cũinácʉ ʉ̃mʉ meacʉre, Jʉ̃menijicʉ bojed̶acʉyʉme náre yópe ʉ̃i bojed̶aiyepedeca ñai ʉ̃mʉ meacʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jãve coyʉyʉbu mʉjare: Ñai põecʉ jíyʉ cũinárʉ jororʉre ocoque, cad̶atecʉyʉ cũinácʉ ji bueimaracacʉre, parʉbecʉreca ʉ̃i yóvaiye boje yʉre, jãve bíjabecʉyʉme ʉ̃ Jʉ̃menijicʉi bojed̶aiyede ʉ̃́re, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús ñʉja doce paivʉ ʉ̃i bueimarare majicarĩ bʉojayʉ bácʉ, nore jocarĩ nʉrejame dijoborõcaĩmaroai, põevare buecʉyʉ aru coyʉcʉyʉ ʉ̃i yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Dinʉmʉre Juan Bautista ñai jabocʉ Herodes ʉ̃i bʉoimʉ marejámed̶a. Cʉrejamed̶a ãmeina teivʉre jẽni jacoiñami jívʉi. Noi cʉcʉ, jápiarejamed̶a Cristo ʉ̃i d̶aiye borore. Que baru jarorejamed̶a apevʉ ʉ̃i bueimarare Jesús yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jẽniari jã́icõjenejamed̶a náre yópe: —¿Jãveneca mʉ́rʉ Juan Bautista “Ji yóboi dacʉyʉme apecʉ coyʉipõecʉ” arĩ, ʉ̃i buevacamʉ? ¿Ʉ̃i que arĩ buevacamʉ ãmenu, corenajidi ñʉja apecʉre? aicõjenejamed̶a náre Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ne que arĩburu yóboi, Jesús jʉ ayʉ arejame náre: —Nʉri coyʉjarã Juan Bautistare mʉje jã́iyede aru mʉje jápiaiyede caride: ");
INSERT INTO cubNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ina jã́ri eabevʉ bácavʉ jã́ri ead̶ama aru ina cuiye majibevʉ bácavʉ cuyama caride. Ina pojeivʉ bácavʉ meama aru ina jápiabevʉ bácavʉ jápiad̶ama caride. Ina yaivʉ bácavʉ nacovaimara yainore jarʉvarĩ apʉma cojedeca caride. Aru cõmaje ãrojarivʉre coyʉyʉbu iye yávaiye méne, Jʉ̃menijicʉi mead̶aiyede põevare. ");
INSERT INTO cubNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aru torojʉbi ñai jʉ arĩ dajocabecʉ yʉre, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ina daroimara ne nʉriburu yóboi, Jesús Juan Bautistai borore yávarĩ bʉ́yʉ arejame ina obedivʉ põevare noi cʉrivʉre: —Jãve jã́ranʉmeteavʉ̃ mʉja cõriáre ũmevʉ japuiyede põecʉbenoi. ");
INSERT INTO cubNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aru jãve jã́ranʉmeteavʉ̃ mʉja põecʉ cuitótecaje meacajede doyʉre máre põecʉbenoi. Majivʉ mʉja ina doivʉre cuitótecajea meacajeare cʉrivʉre cainʉmʉa jabovai cʉ̃ramiai. ");
INSERT INTO cubNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Quénora jãve jã́ranʉavʉ mʉja cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉre. Jãve coyʉyʉbu mʉjare: Jã́quemavʉ mʉja Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉre pʉeno meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan Bautistabe ñai Jʉ̃menijicʉi toivaicõjeimʉ mácʉ ʉ̃́re coyʉcaipõecʉ bácʉre: Jaroivʉ yʉre coyʉcaipõecʉre mi jipocai, ʉ̃i mead̶aquiyepe ayʉ põevare, ne copʉ etarãjiyepe ayʉ mʉre, nopedeca põeva ne mead̶aiyepe cuimare ñai ʉ̃mʉ, ne pued̶aimʉ, ʉ̃i daquiye jipocai, arĩ coyʉicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jãve coyʉyʉbu mʉjare: Cʉbebi apecʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ meacʉ baju Juan Bautista pʉeno, ina ijãravʉre põeteivʉ jẽneboi. Ʉbenita caivʉ Jʉ̃menijicʉi jaboteimara ʉ̃i mearo d̶acaimaramu Juan Bautista pʉeno. Aru nácacʉ ʉbeni cʉcʉ máre Jʉ̃menijicʉi mearo d̶acaimʉme Juan Bautista pʉeno, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aru yópe arĩ, buede nʉrejame: —Ãnijãravʉ bácarõ Juan Bautista Jʉ̃menijicʉi yávaiyede ʉ̃i coyʉrĩ bʉijãravʉmata pʉ caride máre, obedivʉ põeva parʉrõ d̶ad̶ama, ecoiyʉrivʉ Jʉ̃menijicʉi jaboteinore. Aru põeva Jʉ̃menijicʉre jʉ abevʉ parʉrõ ãd̶amated̶ama, cũiné d̶aiyʉrivʉ ʉ̃i jaboteinore. ");
INSERT INTO cubNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juan Bautista ʉ̃i cʉrinʉmʉre cʉrejaquemavʉ Jʉ̃menijicʉi d̶aicõjeiye Moisés bácʉre toivaicõjeni bueiye báque aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ toivarĩ bueiye báque Jʉ̃menijicʉ jabotecʉyʉre ʉ̃i põevare. ");
INSERT INTO cubNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Aru ji coyʉiyede mʉje jʉ aiyʉru, coyʉyʉbu mʉjare: Juan Bautistarecabe ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ Elíape páyʉ dacʉyʉ Jʉ̃menijicʉi epequimʉ ʉ̃i daquiye jipocamia. ");
INSERT INTO cubNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Me jápiajarã mʉja iye ji bueiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Aru yópe arĩ, buede nʉrejame: —¿Yéque jẽvari coyʉji ina põeva ijãravʉcavʉre? ¿Aipe ãrojari na? Jʉed̶ova tãibʉi dobarivʉpebu, yajurãjivʉ nácavʉque. Aru yópe aivʉpebu: ");
INSERT INTO cubNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Japuvʉ ñʉja yʉriainore. Ʉbenita upabetevʉ mʉja. Yʉriavʉ ñʉja chĩore d̶aiyede. Ʉbenita obetevʉ mʉja”. Aru nópe ijãravʉcavʉ máre cãrijiñama na. ");
INSERT INTO cubNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Que baru Juan Bautista ʉ̃i daiyede, ʉ̃ ãmeni aru ũcumeni teiyede, “Abujucʉre cʉvabi”, ʉ̃́ra ʉbenina aivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aru Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji daiyede, ãri aru ũcuri teiyede yópe caivʉ apevʉpe, “Ñai ʉ̃mʉ ʉrarõ ãri ʉ̃i vainí tʉiyeta, aru ʉrarõ ũcuri ʉ̃i pacoteiyeta, yóvaibi ãmenare aru jabovare tãutʉra ĩcaipõevare máre”, yʉrã ʉbenina aivʉbu mʉja. Que baru mʉja máre, ijãravʉcavʉpedeca cãrijivʉbu. Ʉbenita Jʉ̃menijicʉi majiéde põeva jã́d̶ama ʉ̃́re jʉ aivʉque, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Apeĩmaroai ʉre põeva ne d̶arĩ majibede d̶arejame Jesús. Ʉbenita nócavʉ chĩomeni ne ãmeina teiyede, oatʉvabedejaima ne d̶aiyede. Que baru Jesús, yópe arĩ, jijateni bʉ́rejame ina ĩmaroacavʉre: ");
INSERT INTO cubNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Mʉja, judíova, Corazĩ́cavʉ, ãmeno ñájinajaramu mʉja! ¡Aru mʉja, judíova, Betsaidacavʉ máre, ãmeno ñájinajaramu mʉja! Põecʉ ʉ̃i d̶aru põeva ne d̶arĩ majibede yópe ji d̶aiyepe mʉje jã́iyede, judíova ãmevʉ Tirocavʉ aru Sidṍcavʉ máre ne jã́iyede, nócavʉ jave chĩori ne ãmeina teiyede, oatʉvajebu ne d̶aiyede. Ñeminicajeare dorĩ, ũapenare tʉorĩ ne jipobʉi, jã́d̶ovajebu ne chĩori dápiaiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ʉbenita yʉ coyʉyʉbu mʉjare: Mʉja ñájinajaramu Tirocavʉ aru Sidṍcavʉ pʉeno baju, Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aru mʉja, judíova, Capernaucavʉ, jãve nʉmenajaramu mʉja cavarõ mearo Jʉ̃menijicʉi cʉrõi. Quénora mʉja nʉrajaramu toabo cũiméboi. Ina Sodomacavʉ bácavʉ ãmena bajuvacari, jã́ivʉ bácavʉ baru põeva ne d̶arĩ majibede, yópe ji d̶aiye báquepe Capernaui, chĩori ne ãmeina teiyede, oatʉvajebu ne d̶aiyede. Aru na mácavʉre bíjare d̶abejebu Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ʉbenita yʉ coyʉyʉbu mʉjare: Ina Sodomacavʉ bácavʉ pare ãmeina teivʉreca, ne pʉeno ñájinajaramu mʉja, Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Dinʉmʉmareca Jesús, yópe arĩ, coyʉrejame Jʉ̃menijicʉre: —Mʉ, jipacʉ, cavarõ mearocavʉ ne jabocʉ aru ijãravʉcavʉ ne jabocʉ máre, mearore jívʉ mʉre, mi jã́d̶ovame boje caiye iye ji coyʉiyede ina majidivʉre aru mi jã́d̶ovaiye boje caiye iyede ina majibevʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mʉ, jipacʉ, mearore jívʉ mʉre mi nópe d̶aiye boje, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jʉ̃menijicʉre coyʉrĩ bʉojarĩ, Jesús arejame ñʉjare, ʉ̃́que cʉrivʉre: —Jipacʉ Jʉ̃menijicʉ yʉre majide d̶aibi caiyede, aru parʉre d̶aibi máre. Ñame majibema yʉre, quénora majibi jipacʉva. Ñame majibema jipacʉre quénora majivʉ yʉ, aru na máre ina ji majide d̶aimara. ");
INSERT INTO cubNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Caivʉ mʉja ʉetʉivʉ mʉje d̶arĩduiye boje yópe Jʉ̃menijicʉi d̶aicõjeiyepe, dajarã ji yebai. Jabʉóvare d̶aquijivʉ mʉjare diede jocarĩ, mʉje cãrijimenajiyepe ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jʉ ajarã yʉre aru ji coyʉiyede máre. Buejarã yʉ́que ji bueiyede. Majicaicõjejara mʉjare yʉre, d̶arãjivʉ ji d̶aiyepe. Yʉ cõmaje ãroje jã́ñʉmu põevare. “¿Meacʉ bárica yʉ?” arĩ dápiabevʉ. Que baru yʉ jabʉóvare d̶aquijivʉ mʉjare mʉje ũmene. ");
INSERT INTO cubNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jʉ arĩ yʉre, ji coyʉiyede máre, maiyójabevʉ mʉjare. Mʉje d̶aiye majibede d̶aicõjemevʉ mʉjare, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Apejãravʉ, judíovai jabʉóvaijãravʉ sábadoi, ñʉja Jesújã vaidéjacarã oteiye cʉrõi. Ñʉja ʉ̃i bueimarare ãvʉé ijidejavʉ̃. Que baru die oteiyede jẽni pʉyorĩ ãrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aru apevʉ fariseovacavʉ ñʉje nópe d̶aiyede jã́ri, arejaima Jesúre: —Jã́jacʉ. Mi bueimara maja judíova maje d̶aicõjemenope d̶arĩ, ãmeno d̶aivʉbu jabʉóvaijãravʉre, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ʉbenita Jesús, ʉ̃i dápiaiye boje ñʉja ãmeno d̶abevʉre, arejame náre: —¿Jãve ãrʉmetenarʉ mʉja yo David bácʉi d̶aino mácarõre ãvʉé ijiéde ʉ̃́re aru ʉ̃́que cʉrivʉre máre? ");
INSERT INTO cubNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ʉ̃ mácʉ ecorejaquemavʉ Jʉ̃menijicʉi cʉ̃rami. Aru ãrejaquemavʉ pã́ure, Jʉ̃menijicʉre jíye báquede, ina sacerdoteva ne ãiyede, sacerdote ãmecʉ bácʉvacari. Aru jídejaquemavʉ ʉ̃́que cʉrivʉre máre, sacerdoteva ãmevʉ bácavʉreca. Ʉbenita Jʉ̃menijicʉ ñájine d̶abedejaquemavʉ na mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Aru jãve ãrʉmetenarʉ mʉja Jʉ̃menijicʉi d̶aicõjeiyede sacerdotevare ʉ̃i toivaicõjeiye báquede Moisés bácʉre? Ina sacerdoteva memeivʉvacari Jʉ̃menijicʉi cʉ̃rami jabʉóvaijãravʉare, ãmeno d̶abema na. ");
INSERT INTO cubNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Yʉ coyʉyʉbu mʉjare: Ji cʉede mʉje jẽneboi mearotamu mʉjare, mʉje Jʉ̃menijicʉi cʉ̃ramine cʉvae pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mʉja ji bueimarara “Ãmeno d̶aivʉbu” abejebu, majidivʉ bácavʉ baru aipe aiyʉrõre iye Jʉ̃menijicʉi yávaiyede toivaicõjeiye báquede: “Ʉvʉ yʉ mʉje cõmaje ãroje jã́rajiyepe ayʉ apevʉre, mʉje yʉre jícaiye pʉeno”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, jabocʉbu yʉ. Que baru d̶aicõjeni bʉojaivʉ yʉ põevare ne d̶aiyede caijãravʉare aru jabʉóvaijãravʉare máre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nore jocarĩ nʉrejacarã ñʉja, Jesújã. Aru cũinád̶ami judíovai cójijiñami ecorejacarã. Noi cʉrejame cũinácʉ ʉ̃mʉ, ãmuve cũinápũravʉ jiacʉbecʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Apevʉ fariseovacavʉ jẽniari jã́rejaima Jesúre: —¿Mi dápiaru, mead̶aicõjeini Jʉ̃menijicʉ jabʉóvaijãravʉ sábadoi? arejaima na. Nópe arejaima, boro coyʉrĩ ad̶aiyʉrĩduivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús arejame náre: —¿Ácʉ mʉjacacʉ ʉ̃i oveja tʉru cobe jívʉi, cũiná jẽni ĩmeje bárica ʉ̃́re judíovai jabʉóvaijãravʉ, mʉjare memeicõjemejãravʉre? ¡Põecʉ bojecʉcʉtame oveja pʉeno! ");
INSERT INTO cubNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Que baru Jʉ̃menijicʉ mearore d̶aicõjeimi põevare jabʉóvaijãravʉ sábadoi. Aru yʉ mead̶ayʉ baru ñai ʉ̃mʉre caride, mearo d̶ajebu yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nópe ayʉva, ñai ʉ̃mʉ ãmuve jiacʉbecʉre arejame: —Jabióvajacʉ mi ãmuvede, arejame. Ʉ̃i jabióvaiyede, meatedejavʉ̃ ʉ̃i ãmuve, yópe apepũravʉcaãmuvepe. ");
INSERT INTO cubNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Que teni ina fariseova etaivʉ bácavʉ cójijidejaimad̶a. “Boarĩ́ jarʉvarãjarevʉ”, arĩ dápiaivʉ barejáimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús coreóvayʉ ina fariseova ne boarĩ́ jarʉvaiyʉede ʉ̃́re, náre dajocarĩ nʉrejame nore jocarĩ. Obedivʉ põeva cujurejaima ʉ̃i yóboi. Aru caivʉ nácavʉ ijimarare mead̶arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yávaicõjemenidurejame náre apevʉre, ne coreóvabenajiyepe ayʉ ʉ̃i d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Caiye iye nópe vaidéjavʉ̃ cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca ñai Isaías ãmicʉcʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: ");
INSERT INTO cubNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jápiajarã. Ñaime yʉre memecayʉ, ji beoimʉ mácʉ. Ʉ̃́recabe ji ʉmʉ. Ʉ̃́que torojʉvʉ yʉ ji ũmei. Ʉ̃́re darocʉyʉmu ji Espíriture, ʉ̃i cõjequiyepe ayʉ yʉre memecayʉ ʉ̃i dápiaiyede, ʉ̃i coyʉiyede, aru ʉ̃i d̶aiyede máre. Que baru coyʉcʉyʉme yʉre memecayʉ judíova ãmevʉre aipe d̶arĩ bʉojaivʉre, boropatebenajivʉva ji jã́inore. ");
INSERT INTO cubNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ʉ̃́recabe ãd̶amatebecʉ, cod̶obobobecʉ mái, aru órejabecʉ ĩmaroacarõ tãibʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Napiñʉ cad̶atecʉyʉme ina parʉbevʉre. Aru cõmaje ãroje jã́ñʉ mead̶acʉyʉme ina ijimara yaijʉrorivʉre. Nópe d̶acʉyʉme pʉ ʉ̃i vainí tʉrĩburu yóboita ãmenore jarʉvarĩ, ʉ̃i jaboteiyeta. ");
INSERT INTO cubNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ʉ̃́recabe põevare mead̶arĩ bʉojayʉ. Que baru ʉ̃́re napini corenajarama ina judíova ãmevʉ, ʉ̃i mead̶aquiyepe aivʉ náre, arĩ toivaicõjenejaquemavʉ Isaías bácʉre Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Dinʉmʉre apevʉ davarejaima cũinácʉ ʉ̃mʉre, abujucʉ ʉ̃i ĩmamʉre, Jesús yebai. Ñai ʉ̃mʉ jã́ri eabecʉ aru yávaiye majibecʉ barejáme. Aru ʉ̃́re mead̶arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ʉ̃i que d̶aiyede, caivʉ ina põeva, nócavʉ, cuecumari arejaima: —¿David bácʉi pãramecʉ, Jʉ̃menijicʉi epeimʉ mácʉ maje jabocʉ bacʉyʉ́ bárica ñai? jẽniari jã́rejaima ne bajumia. ");
INSERT INTO cubNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ʉbenita ina fariseova, jápiaivʉ põeva nópe ne coyʉiyede, yópe arejaima: —Ñai ʉ̃mʉ cʉvabi Beelzebúre. Que baru abujuvai jabocʉi parʉéque jaetovaibi abujuvare, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús coreóvayʉ ne dápiaiyede, arejame náre: —Cũináro jaborõcavʉ ãd̶amateivʉ baru ne bajumia, ina jaborõcavʉ cũinájarama na. Aru nopedeca cũináro ĩmarocavʉ o cũinád̶ami cʉ̃ramicavʉ máre ãd̶amateivʉ baru ne bajumia, diĩmarocavʉ o diñamicavʉ máre cũinájarama na. ");
INSERT INTO cubNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aru nopedeca bájebu ñai abujuvai jabocʉ, jaetovayʉ baru abujuvai jabocʉre. Ãd̶amateyʉ bájebu ʉ̃i bajuma. Aru jaetovayʉ baru abujuvare, joe parʉcʉ cʉbejebu ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿Ji jaetovaru abujuvare ne jabocʉi parʉéque, ñamei parʉéque jaetovaidi mʉjacavʉ abujuvare? Que baru mʉjacavʉ, abujuvare jaetovaivʉ, jã́d̶ovad̶ama mʉjare mʉje borocʉede yʉre ʉbenina. ");
INSERT INTO cubNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ʉbenita Jʉ̃menijicʉi Espíritu Santo ʉ̃i parʉéque jaetovayʉbu yʉ abujuvare. Que baru jã́d̶ovaivʉ yʉ Jʉ̃menijicʉ jaboteyʉre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ʉbenita bʉojaino ãmevʉ ecoivʉ ñai ʉ̃mʉ parʉcʉi cʉ̃ramine, ñavarajivʉ ʉ̃i cʉvaede. Mamarʉmʉre ʉ̃́re bʉorĩ, que d̶aivʉ bácavʉta bʉojaivʉ ñavaivʉ ʉ̃i cʉvaede, arejame Jesús. Nópe ayʉ, Jesús yópe aiyʉcʉ barejaquémavʉ: Ʉ̃́vacari parʉbi abujuvai jabocʉ pʉeno, ʉ̃i jaetovaiye boje abujuvare põevare jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Aru Jesús arejame: —Ñai yóvabecʉ maucʉvabi yʉre. Aru ñai apevʉre yóvare d̶abebi yʉre, náre maucʉvare d̶aibi yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Que baru coyʉyʉbu mʉjare: Jʉ̃menijicʉ ãrʉmetecʉyʉme caiye iye mʉje ãmeina teiyede, aru caiye iye ʉ̃́re ãmeina yávaiyede máre. Ʉbenita ácʉ põecʉ ʉ̃i yávaru ãmeina ñai Espíritu Santore, aipinʉmʉ Jʉ̃menijicʉ ãrʉmetebecʉbe ʉ̃i ãmeina teiyede. Quédata boropatecʉyʉme, bíjacʉyʉ Jʉ̃menijicʉre jocarĩ cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Que baru caivʉ ina ãmeina yávaivʉre yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, Jʉ̃menijicʉ ãrʉmetecʉyʉme ne ãmeina teiyede. Ʉbenita ina ãmeina yávaivʉre ñaine, Espíritu Santore, Jʉ̃menijicʉ ãrʉmetebecʉbe ne ãmeina teiyede, ijãravʉre aru daquijãravʉ baquinóre máre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Cojedeca Jesús, yópe arĩ, buedejame: —Jocʉcʉ meacʉ cʉvavʉ jẽidʉa mearʉare. Ʉbenita jocʉcʉ ãmecʉ, ãmedʉare cʉvavʉ. Que baru coreóvaivʉbu iye jocʉcʉare dicʉá jẽiyeque. Nopedeca mʉja coreóvarĩ bʉojaivʉbu yʉre ji d̶aiyeque. ");
INSERT INTO cubNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Mʉja, jʉjovaivʉ, ãd̶avape paivʉbu mʉja! Mʉjarecabu dápiaivʉ ãmene. Que baru ãme matʉiyede yávaivʉbu mʉja. Aru méne yávarĩ bʉojabevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ñai põecʉ meacʉ yávayʉbe méne, ʉ̃i ũmei mearo cʉe boje. Aru ñai põecʉ ãmecʉ yávayʉbe ãmene, ʉ̃i ũmei ãmeno cʉe boje. Que baru põecʉ yávaibi ʉ̃i jijecamuque ʉ̃́re cʉede ʉ̃i ũmei. ");
INSERT INTO cubNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Coyʉyʉbu mʉjare: Ãnijãravʉ daquijãravʉ baquinó Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, caivʉ ʉbenina yávaivʉ bácavʉre ñájine d̶acʉyʉme Jʉ̃menijicʉ, ne nópe yávaiye báque boje. ");
INSERT INTO cubNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mʉje yávaiyeque jã́d̶ovaivʉbu aipe mʉje dápiaiyede. Que baru Jʉ̃menijicʉ bojed̶acʉyʉme mʉjare yópe mʉje yávaiyepe. Mʉje ména yávaru, mʉjare boropatebevʉpe jã́cʉyʉme Jʉ̃menijicʉ. Ʉbenita mʉje ãmeina yávaru, mʉjare boropateivʉpe jã́cʉyʉme ʉ̃, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Dinʉmʉre apevʉ ina Jʉ̃menijicʉi yávaiye báquede bueipõevacavʉ aru apevʉ fariseovacavʉ máre yópe arĩdurejaima Jesúre: —Mʉ, bueipõecʉ, Jʉ̃menijicʉi majiéque d̶arĩ jã́d̶ovajacʉ põeva ne d̶arĩ majibenore, arĩdurejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ʉbenita Jesúcapũravʉ yópe arejame náre: —Ãmena bajutamu mʉja. Jʉ̃menijicʉre dajocaiyʉrivʉbu mʉja yópe nomió ãmeco õi dajocaiyepe jímarepacʉre jocarĩ. Que baru jẽniariduivʉbu ji jã́d̶ovaquiyepe aivʉ Jʉ̃menijicʉi majiéque d̶ainore, põeva ne d̶arĩ majibenore. Ʉbenita jã́menamu apenore Jʉ̃menijicʉi d̶ainore mʉjare, quénora yo Jonás mácʉre vaino mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yópe Jonás mácʉi cʉe báquepe moacʉ ʉracʉi yapibʉ jívʉi yóbecʉrijãravʉa aru yóbecʉriñamia máre, nopedeca yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, cʉcʉyʉmu joborõ jívʉi yóbecʉrijãravʉa aru yóbecʉriñamia máre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","’Aru Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, ina ʉ̃mʉva mácavʉ, Nínivecavʉ bácavʉ, nacajarajarama mʉja ijãravʉcavʉque, aru ãmecororãjarama mʉjare, yʉre mʉje jʉ abe boje. Aru ina Nínivecavʉ bácavʉ chĩori ne ãmeina teiye báquede oatʉvarejaquemavʉ, jápiaivʉ bácavʉ Jonás mácʉi coyʉiyede Jʉ̃menijicʉi yávaiyede. Ʉbenita Jonás mácʉi majié pʉeno baju bueyʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aru Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, ico jaboco, aviá daino cãcopũravʉcaco báco, nacajacod̶ome mʉja ijãravʉcavʉque aru ãmecorocod̶ome mʉjare, yʉre mʉje jʉ abe boje. Õ máco darejaquemavʉ joarõ joborõre jocarĩ, jápiacod̶o ñai Salomón mácʉi coyʉiye báquede ʉ̃i majiéque. Ʉbenita Salomón mácʉi majié pʉeno baju bueyʉbu yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Bedióva cojedeca Jesús, yópe arĩ, buedejame: —Abujucʉ etayʉ bácʉ ʉ̃mʉre jocarĩ, voibi ʉ̃i jabʉóvaino penenoi, põecʉbenoi. ");
INSERT INTO cubNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ʉbenita jabʉóvaino eabecʉ baru, copaiyʉbi ñai ʉ̃mʉ, ʉ̃i etaimʉ mácʉrecata. Aru copaini dayʉ, eaibi ñai ʉ̃mʉ meacʉre, yópe cʉ̃rami oeni mead̶aiñamipe páyʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Que teni nʉñʉ, nʉvaimi apevʉ siete paivʉ abujuva ʉ̃i pʉeno ãmenare. Aru ne ecoiyede ñai ʉ̃mʉre, ãmed̶ad̶ama ʉ̃́re pʉeno baju. Nopedeca vaiquíyebu ijãravʉcavʉ ãmenare. Ñájinajarama yóbocajãravʉare ne mamarʉmʉ ñájiye báque pʉeno, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ʉ̃i coyʉiyede ina põevare, jípaco aru ʉ̃i yóva máre ʉ̃́que boroteiyʉrivʉ edarejaimad̶a ʉ̃i cʉrõi. Ʉbenita jedevamia mautedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aru cũinácʉ nore cʉcʉ arejame Jesúre: —Mipaco aru míyova máre, mʉre jã́radaivʉ, jedevai núma, arejame. ");
INSERT INTO cubNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ʉbenita Jesúcapũravʉ arejame ʉ̃́re coyʉyʉ bácʉre: —¿Ñamema jipaco aru jíyova? jẽniari jã́rejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aru ʉ̃i pʉrʉre jabióvarĩ jã́d̶ovacʉñʉ ñʉjare, ʉ̃i bueimarare, arejame: —Yuibu jipacope paivʉ aru jíyovape paivʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Que baru caivʉ ina d̶aivʉ jipacʉ, cavarõ mearocacʉ, ʉ̃i ʉrõpe, nárecabu jíyocʉpe páyʉ, jíyocope pád̶o, aru jipacope pád̶o máre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Dijãravʉmareca cʉ̃ramine etarĩ, macajitabʉ ʉrabʉ ẽcarʉi nʉri, dobarejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Obedivʉ põeva cójijidejaima ʉ̃i yebai. Que baru jiad̶ocũ ẽcarʉ joabenoi cʉricũre jã́ri, jaturĩ, dobarejame dicũra, buecʉyʉ põevare. Aru caivʉ ina põeva cʉrejaima macajitabʉ ʉrabʉ ẽcarʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús buedejame ñʉjare jã́ri dápiarĩ ñʉje d̶arãjiyepe ayʉ caijĩe apejĩene. Yópe arĩ, buedejame: —Yui oteipõecʉ otecʉnʉquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ʉ̃i oteiyede, ape oteiye tʉquemavʉ ma ẽcarʉi. Aru míjina darĩ, ãradaquemavʉ caiye iye oteiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ape oteiye tʉquemavʉ joborõ edubenoi, cʉ̃raboa pʉenoi. Nore joborõ yaʉrijĩe cʉbeniburu, maumejiena pĩarí etaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ʉbenita aviá ʉ̃i boiyede, ẽ́quemavʉ. Aru nʉomua ʉ̃mʉjʉrimua cʉbeni, yaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ape oteiye tʉquemavʉ miucʉa jẽneboi. Aru yóboi miucʉa bʉcʉrĩ, chĩoquemavʉ iye oteiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aru ape oteiye tʉquemavʉ mearo joborõi. Aru die jẽquemavʉ, apeñʉ jẽiñʉ cien paivʉa, apeñʉ jẽiñʉ sesenta paivʉa, aru apeñʉ jẽiñʉ treinta paivʉa, caiye oteiyabea coapa. ");
INSERT INTO cubNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Me jápiajarã mʉja iye ji bueiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Dinʉmʉre ñʉja, ʉ̃i bueimara, ʉ̃i yebai nʉri, jẽniari jã́rejacarã Jesúre: —¿Aipe teni bueyʉrʉ̃ mʉ jã́ri dápiarĩ ñʉje d̶arãjiyepe ayʉ mi coyʉiyeque? arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aru Jesús coyʉrejame ñʉjare, yópe arĩ: —Mʉjare coyʉrĩ majide d̶ayʉbu iye Jʉ̃menijicʉ ʉ̃i coyʉicõjeme máquede. Ʉ̃ jaboteibi mʉjare, ʉ̃i põevare. Ʉbenita ina apevʉ, iyede majibevʉre, quéda jã́ri dápiarĩ ne d̶arãjiyepe ayʉ, bueyʉbu yʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nopedeca ina jápiaivʉre Jʉ̃menijicʉi yávaiyede, Jʉ̃menijicʉ pʉeno baju majide d̶acʉyʉme náre. Ʉbenita ina jápiabevʉre Jʉ̃menijicʉi yávaiyede, iye ne quĩ́jino majiéde, Jʉ̃menijicʉ náre ĩcʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jã́ivʉvacari ji d̶aiyede, coreóvaiyʉbema yʉre. Aru jápiaivʉvacari ji coyʉiyede, jʉ aiyʉbema yʉre. Yéde majibema na ji yávaiyede. Que baru jã́ri dápiarĩ ne d̶arãjiyeque coyʉyʉbu yʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ne d̶aiye nópe vaidéjaquemavʉ cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca ñai Isaías ãmicʉcʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre: Jãve jápiarĩdurãjaramu mʉja. Ʉbenita ye jápiarĩ eabenajaramu. Jãve jã́ridurãjaramu mʉja. Ʉbenita ye jã́ri eabenajaramu. ");
INSERT INTO cubNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mʉja coreóvaiyʉbevʉ, mʉje yávaiyede jãvene jápiarĩ eaiyʉbe boje. Mʉja jápiabevʉ, mʉje yávaiyede jãvene jápiaiyʉbe boje. Mʉja bieivʉ mʉje yacorʉare, mʉje jãvene jã́iyʉbe boje. Yʉre jã́ri coreóvaivʉ baru mʉje yacorʉaque, jʉ ajebu mʉja. Yʉre jápiaivʉ baru mʉje cámucobeaque, jʉ ajebu mʉja. Yʉre jápiarĩ ad̶aivʉ baru mʉje ũmeque, jʉ ajebu mʉja. Que d̶aivʉre, mead̶ajebu yʉ mʉjare, toivaicõjenejaquemavʉ Jʉ̃menijicʉ Isaías bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Ʉbenita torojʉrãjaramu mʉja, ji bueimara. Ji d̶aiyede jã́ri coreóvaivʉbu mʉje jã́iyede. Aru ji coyʉiyede jápiarĩ, jʉ aivʉbu diede. Que baru Jʉ̃menijicʉi mearo d̶acaimaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jãve coyʉyʉbu mʉjare: Obedivʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõeva aru meara põeva máre jã́iyʉrĩduquemavʉ caiye iye mʉje jã́iyede. Ʉbenita jã́metequemavʉ. Aru jápiaiyʉrĩduquemavʉ caiye iye mʉje jápiaiyede. Ʉbenita jápiabetequemavʉ, arĩ coyʉrejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yópe arĩ, Jesús coyʉrejame ñʉja ʉ̃i bueimarare: —Yo jã́ri dápiarĩ mʉje d̶arãjiyepe ayʉ ji aino mácarõ yópe coyʉiyʉrõmu mʉjare: Iye oteiye Jʉ̃menijicʉi yávaiyepe paiyebu ʉ̃i jaboteinoque yávaiye. Aru ñai oteipõecʉ Jʉ̃menijicʉi yávaiyede bueipõecʉpe páyʉbe. ");
INSERT INTO cubNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aru inamu ma ẽcarʉi oteiye tʉrĩduiye báquepe paivʉ. Náre coyʉiyede Jʉ̃menijicʉi yávaiyede jápiad̶ama, ʉbenita coreóvarĩ eabevʉva. Que baru ne jápiarĩburu yóboi, ñai abujuvai jabocʉ darĩ, ãrʉmetede d̶aibi Jʉ̃menijicʉi yávaiyede, ne jápiaiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Aru inamu joborõ edubenoi, cʉ̃raboa pʉenoi, oteiye tʉrĩduiye báquepe paivʉ. Jʉ̃menijicʉi yávaiyede jápiarĩ, torojʉma me. ");
INSERT INTO cubNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ʉbenita diede jʉ arĩduyama na. Que baru quĩ́jino yóboi, põeva ne cãrijovaru aru ñájine d̶aru náre, ne jʉ aiye boje, maumena dajocad̶ama ne jʉ aiyede Jʉ̃menijicʉi yávaiyede. Que teni jʉ abema na. ");
INSERT INTO cubNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aru inamu miucʉa jẽneboi oteiye tʉrĩduiye báquepe paivʉ. Na máre jápiaivʉ Jʉ̃menijicʉi yávaiyede, ʉbenita cãrijiñama ijãravʉquede. Aru torojʉma tãutʉraque. Que baru dápiad̶ama caiye diede. Ʉbenita dápiabema Jʉ̃menijicʉi yávaiyede. Que baru Jʉ̃menijicʉ cad̶atebebi náre ʉ̃i yávaiyeque yópe ʉ̃i ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ʉbenita inamu mearo joborõi oteiye tʉiye báquepe paivʉ. Jʉ̃menijicʉi yávaiyede jápiad̶ama. Aru diede jápiarĩ coreóvad̶ama. Nárecabu jʉ are d̶aivʉ apevʉ põevare, apevʉ cien paivʉre, aru apevʉ sesenta paivʉre, aru apevʉ treinta paivʉre, arĩ buedejame Jesús ñʉja ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Apeno jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Jʉ̃menijicʉi jaboteino yópe painomu. Cũinácʉ ʉ̃mʉ ʉ̃i oteiye méne, trigo ãmicʉede, otequemavʉ jioi. ");
INSERT INTO cubNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ʉbenita ñami, põeva ne cãiyede, ʉ̃i maucʉ dupini darĩ, otequemavʉ ãmecõriare ʉ̃i oteiye jẽneboi. Aru que d̶arĩ bʉojarĩ, nʉquemavʉ ñai ʉ̃i maucʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Que baru oteiye me pĩarí bʉcʉiyede, ãmecõria máre pĩarí bʉcʉquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dinʉmʉre ñai jio upacʉ ʉ̃́re memecaivʉ ʉ̃i yebai nʉri, aquemavʉ: “Mʉ, ñʉje jabocʉ, ¿otebetecʉrʉ̃ oteiye méne jioi? Jã́jacʉ. Mi oteiyeque ãmecõria máre cʉvʉ”, arĩ coyʉquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ñai jio upacʉ náre coyʉyʉ: “Ji maucʉ que d̶ayʉme”, aquemavʉ. Ʉ̃́re memecaivʉ jẽniari jã́quemavʉ: “¿Iye ãmecõriare ĩnajidi ñʉja?” aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ʉbenita ñai jio upacʉ aquemavʉ: “Bítamu. Mʉje ĩ́yede ãmene, méne máre ĩnajichʉvʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Bʉcʉicõjejara caiyede, oteiye méne aru ãmecõriare máre, pʉ jẽijãravʉ eaiyeta. Jẽijãravʉ eaiyede, yópe coyʉcʉyʉmu yʉ ji oteiyede ĩcaipõevare: ‘Mamarʉmʉ ĩjara mʉja iye ãmecõriare. Ĩni, tóroa d̶arĩ, ditoroa coapa bʉorĩ, juajarã mʉja. Ʉbenita iye oteiye méne trigo ãmicʉede ĩniburu, epejarã ji epeiñami jívʉi’, coyʉcʉyʉmu náre”, aquemavʉ ñai jio upacʉ, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Apeno jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Coyʉquijivʉ mʉjare aipe ãrojarore yo Jʉ̃menijicʉi jaboteinore. Yópe mostaza ãmicʉriyabe oteiyabepebu. Cũinácʉ ʉ̃mʉ diyabede ĩni, oteibi ʉ̃i jioi. ");
INSERT INTO cubNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Diyabedecabu oteiyabe quĩ́jiyabe caiye oteiye pʉeno. Ʉbenita ʉ̃i oteniburu yóboi, bʉcʉrĩ mʉivʉ ʉracʉ ape oteiye pʉeno. Aru dicʉ cavabʉa ʉracavabʉa nʉivʉ, dicʉ taino cãchinoi míjina ne juaiboa d̶ad̶ama, arejame Jesús. Nopedeca mamarʉmʉre Jʉ̃menijicʉi jaboteino quĩ́jinotamu, põeva obebevʉ ne cʉe boje noi. Ʉbenita Jʉ̃menijicʉi yávaiye méne coyʉrĩburu yóboi, ʉrarõtamu no Jʉ̃menijicʉi jaboteino, obedivʉ põeva ne cʉe boje noi. ");
INSERT INTO cubNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bedióva diede buedejame Jesús apeno jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque, yópe arĩ: —Jʉ̃menijicʉi jaboteino yópebu nomió õi pã́ure bʉcʉre d̶aiyepe. Diede ad̶arĩ jĩvaiyepebu yóbecʉricurubʉa pã́u d̶aicurubʉare. Aru caino jĩvaibore bʉcʉóvainopebu, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Caiye iye jã́ri dápiarĩ ne d̶arãjiyepe aiyede coyʉrejame Jesús ina obedivʉ põevare. Coyʉre curejame cainʉmʉa jã́ri dápiarĩ ne d̶arãjiyepe aiyeque ʉ̃i bueinore. ");
INSERT INTO cubNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nópe vaidéjavʉ̃ cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca cũinácʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: Jã́ri dápiarĩ ne d̶arãjiyepe ainoque coyʉcʉyʉmu yʉ põevare. Iye yávaiye jã́d̶ovame máquede Jʉ̃menijicʉi jãravʉre cʉed̶aquiye jipocamata coyʉcʉyʉmu yʉ náre, arĩ toivaicõjenejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dinʉmʉ ina obedivʉ põevare dajocarĩ, cʉ̃rami ecorejame Jesús. Aru noi ñʉja, ʉ̃i bueimara, ʉ̃i yebai nʉri, yópe arejacarã ʉ̃́re: —Mʉ, bueipõecʉ, coyʉjacʉ ñʉjare aipe aiyʉrõre yo jã́ri dápiarĩ ñʉje d̶arãjiyepe ayʉ mi aino mácarõre, ãmecõria oteiye jẽneboi, arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yópe arĩ, coyʉrejame ñʉjare Jesús: —Ñai jio upacʉ oteiye méne oteicõjeñʉpe páyʉbu yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe. ");
INSERT INTO cubNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ʉ̃i jio ijãravʉpe painomu. Iye trigo ãmicʉe oteiyebu Jʉ̃menijicʉi jaboteimarape paivʉ. Aru iye ãmecõriamu abujuvai jabocʉi jaboteimarape paivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ñai jio upacʉi maucʉbe, ãmecõriare oteyʉ, abujuvai jabocʉpe páyʉ. No jãravʉ oteiye jẽijãravʉ ijãravʉ cũiquíjãravʉpe painomu. Aru ina oteiyede ĩcaipõevamu ángelevape paivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yópe ne ĩni juaiyepe toaque iye ãmecõriare, nopedeca vaiquíyebu ijãravʉ cũiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","’Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, darocʉyʉmu ji ángelevare ji jaboteimara yebai. Ina ángeleva ĩnajarama caivʉ ina ji jaboteimara jẽneboi ãmeina d̶aivʉre aru apevʉre ãmeina d̶are d̶aivʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Náre ĩni jarorãjarama toabo cũiméboi. Chĩoivʉ orĩ cʉrãjarama nore. Aru jararĩ cõpi cũrajarama na. ");
INSERT INTO cubNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Dinʉmʉ maquinóre ina põeva meara, ina d̶aivʉ yópe Jʉ̃menijicʉi ʉrõpe, cʉrãjarama majepacʉ Jʉ̃menijicʉi jaboteinoi, miad̶áre d̶aivʉpe yópe aviá ʉ̃i boiyepe. Me jápiajarã mʉja iye ji bueiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Apeno jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Jʉ̃menijicʉi jaboteinomu yópe bojecʉede yaveiye báquepe jioi. Cũinácʉ ʉ̃mʉ memeñʉ, ʉ̃i ũiyede joborõ jívʉi eayʉ baru bojecʉede yaveiye báquede noi, epeni yaveyʉbe diede cojedeca. Aru jiore copainʉri, caiye ʉ̃i cʉvaede jíni bojed̶arĩ, no jiore bojed̶ayʉbe, cʉvacʉyʉ iye bojecʉede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Apeno jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Jʉ̃menijicʉi jaboteinomu yópe bojed̶aipõecʉi voiyepe cʉ̃rajiboa perla ãmicʉrijĩboa bojecʉrijĩboare. ");
INSERT INTO cubNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ñai ʉ̃mʉ eayʉ baru cũinájibo perla ãmicʉrijĩbo cʉ̃rajibore, bojecʉrijĩbo caiboa apeboa pʉeno, caiye ʉ̃i cʉvaede jíni bojed̶acʉnʉñʉme, ĩni bojed̶acʉyʉ nijibore, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Apeno jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Jʉ̃menijicʉi jaboteinomu yópe pápicʉ ʉracʉ ne jaboáicʉ jia ʉrad̶ai, obedivʉ moa ne coiyepe dicʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Dicʉ buiyede, ina moa boaipõeva dicʉre nʉvari, jabʉborĩ ẽcarʉita, noi dobarĩ, jã́ri beorĩ ad̶aivʉbu caivʉ ina moa mearare ne pʉeá jívʉi. Aru caivʉ ina ãmenare jarʉvaivʉbu na. ");
INSERT INTO cubNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nopedeca vaiquíyebu ijãravʉ cũiyede. Ina ángeleva darĩ, jã́ri beorĩ ĩnajarama ina põeva ãmenare ina meara jẽneboi. ");
INSERT INTO cubNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ina ãmenare jarorãjarama toabo cũiméboi. Chĩoivʉ orĩ cʉrãjarama nore. Aru jararĩ cõpi cũrajarama na, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yópe arĩ, jẽniari jã́rejame ñʉjare Jesús: —¿Caiye iye ji coyʉiyede mʉjare jápiarĩ eaivʉrʉ̃ mʉja? arejame ñʉjare. Aru arejacarã ʉ̃́re: —Jápiarĩ eaivʉbu ñʉja, arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Que arĩ, Jesús arejame ñʉjare: —Caivʉ ina Jʉ̃menijicʉi yávaiye báquede bueipõeva bueivʉ baru Jʉ̃menijicʉi jaboteiyede ʉ̃i põevare yópe ji coyʉiyepe, bueni bʉojarãjarama Jʉ̃menijicʉi yávaiye báque javede aru Jʉ̃menijicʉi yávaiye mamaene máre, cad̶atenajivʉ ina jápiaivʉre, ne majinajiyepe aivʉ aipe d̶aiye jaʉrõre. Nopedeca cʉ̃rami upacʉ davaibi ʉ̃i cʉvae javequede aru mamaene máre ʉ̃i epeiye báquede ʉ̃i cʉ̃rami jívʉi, cad̶atecʉyʉ diñamicavʉre ne d̶aiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Caiye iye jã́ri dápiarĩ ne d̶arãjiyepe aiyede coyʉrĩburu yóboi, nʉrejame Jesús nore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Copainʉrejame ʉ̃i joborõi. Aru judíovai cójijiñami buedejame põevare. Ʉ̃́re jápiaivʉ cuecumari arejaima: —¿Ã́roqueba caiye iye ʉ̃i majié aru iye ʉ̃i d̶aiye põeva ne d̶arĩ majibede? ");
INSERT INTO cubNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ñai ãmeni jocʉre memeipõecʉi mácʉ? ¿Ico María ãmicʉco ãmeni jípaco? ¿Ʉ̃i yóva ãmeni Santiago, José, Simón, aru Judas máre? ");
INSERT INTO cubNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Aru ʉ̃i yórõmiva máre cʉbedi majaque yui? Que baru, ¿ã́roqueba caiye iye ʉ̃i d̶aiye ñai ʉ̃mʉ, majape páyʉ? jẽniari jã́rejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Que arĩ, ãmeina jã́rejaima ʉ̃́re. Ʉbenita Jesúcapũravʉ náre arejame, ne jʉ abe boje ʉ̃́re: —Cʉbebi Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ ne pued̶aimʉ ʉ̃i joborõcavʉ aru ʉ̃i cʉ̃ramicavʉ máre, arejame. ");
INSERT INTO cubNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aru obebejĩe põeva ne d̶arĩ majibede d̶arejame nore, ne jʉ abe boje ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Dinʉmʉ ñai Herodes, ñʉja Galilea ãmicʉrijoborõcavʉ ñʉje jabocʉ, jápiarejamed̶a Jesúi borore. ");
INSERT INTO cubNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jápiayʉ, ʉ̃́re memecaivʉre arejamed̶a: —Ñaime Juan Bautista. Nacajacʉbe yainore jarʉvarĩ. Que baru yópe parʉcʉbe ʉ̃, ʉbenina arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Nópe dápiarejamed̶a Herodes, Juan Bautista bácʉ apʉcʉre cãreja, ʉ̃i yaiquíye jipocai, Herodes ʉ̃i bʉoicõjeiye báque boje ʉ̃́re. Aru bʉoicõjenejamed̶a, jacocʉyʉ ãmeina teivʉre jẽni jacoiñami, yópe Herodei márepaco Herodíai ʉrõpe. Nópe ʉrejacod̶a, õi jorojĩye boje ʉ̃i ãmecoroiye báquede Herodede, ʉ̃i cʉvae boje ṍre, ĩmacʉ Felipei márepacore. ");
INSERT INTO cubNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Javede Juan Bautista bácʉ ávarejamed̶a Herodede: “Jʉ̃menijicʉi d̶aicõjeiye Moisés bácʉ ʉ̃i coyʉiye báque cʉvaicõjemevʉ mʉre apecʉi márepacore”, ávarejamed̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodecapũravʉ Juan Bautista bácʉre boarĩ́ jarʉvaiyʉcʉvacari, jidʉrejamed̶a ina obedivʉ põevare, “Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉbe Juan Bautista”, arĩ dápiaivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ʉbenita cũinájãravʉ ʉ̃i ãrʉrijãravʉ eaiyede, Herodei põeteijãravʉ bácarõre, torojʉve teino d̶arejamed̶a ʉ̃. Dijãravʉre Herodíai máco nʉri, uparejacod̶a caivʉ ina Herodei cutuimara ne jã́iyede. Que teni Herodede pare cojʉyarejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Que baru parʉéque arejamed̶a ṍre: —Jíquijivʉ mʉre yéde mi ʉrõre. Yʉre ñájine d̶ajacʉrĩ Jʉ̃menijicʉ, ji d̶abedu yópe ji ainope, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jípaco jẽniaicõjenejacod̶a ṍre. Aru ico nomió bojʉyo arejacod̶a Herodede: —Jíjacʉ yʉre carijĩe Juan Bautistai jipobʉre jororʉque, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Õi jẽniainore jápiarĩ, chĩorejamed̶a ñai jabocʉ. Ʉbenita ʉ̃i aiye báque boje parʉéque ʉ̃i cutuimara ne jápiaiyede, jícaicõjenejamed̶a ṍre. ");
INSERT INTO cubNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Boaipõecʉre jarorejamed̶a ãmeina teivʉre jẽni jacoiñami jívʉi, ʉ̃i burarĩ jarʉvaquiyepe ayʉ Juan Bautistai jipobʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Burarĩ bʉojarĩ, jororʉque nʉvari, jídejamed̶a ico nomió bojʉyore. Aru jídejacod̶a jípacore, õi majicojiyepe ad̶o Juan Bautista bácʉ jãve yaiyʉ́ bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Aru Juan Bautista bácʉi bueimara nʉvarejaimad̶a ʉ̃i baju bácarõre, jarʉvarãjivʉ cʉ̃racobe jívʉi. Que teniburu yóboi, coyʉrãnʉrejaimad̶a Jesúre die borore. ");
INSERT INTO cubNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús diede jápiayʉ bácʉ, nore jocarĩ nʉrejame jiad̶ocũi, ina põeva obedivʉre dajocarĩ, pʉ põecʉbenoita. Ʉbenita nʉñʉre majidejaimad̶a na. Aru mái ʉ̃i yóboi nʉrejaima na, obedivʉ ĩmaroacavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ʉ̃i jataiyede, ẽcarʉi mari, ina obedivʉ põevare cõmaje ãroje jã́rejame Jesús. Nácavʉ ijimarare mead̶arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nainúta ñʉja ʉ̃i bueimara ʉ̃i yebai nʉri, coyʉrejacarã ʉ̃́re: —Nainútamu majare yui põecʉbenoi. Põeva ne ãrajiyede bojed̶arãnʉicõjejacʉ mʉ. Noi ĩmajinoai jarorĩ, náre “Ãranʉjara” ajacʉ mʉ, arĩdurejacarã Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ñʉjare arejame: —Ne ãrajiyede bojed̶arãnʉiye jaʉbevʉ náre. Jíjarã mʉja ne ãrajiyede, arejame ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ʉ̃́re arejacarã: —Pã́uboa cũinápʉrʉpe paiboa aru moa pʉcarã cʉvavʉ ñʉja, arejacarã Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Diede davajarã ji yebai, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dinʉmʉre cõriá pʉenora põevare dobaicõjenejame Jesús. Aru die pã́uboa cũinápʉrʉpe paiboa aru moa pʉcarãre jẽni, cavarõi jã́ñʉ, torojʉede jídejame Jʉ̃menijicʉre. Ʉ̃i cotʉvarĩburu yóboi pã́uboare, ñʉja ʉ̃i bueimara jídejacarã diede ina põevare, yópe Jesús ʉ̃i jícõjeiye báquepedeca ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Aru caivʉ ãri, yapidejaima na. Ãri bubarĩburu yóboi, iye cotʉvaiye báquede, ne ãri oabede, ĩni, mead̶arĩ, pʉebʉa doce paibʉa, judíovai pʉebʉare, buivárejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aru ina ãivʉ bácavʉ ʉ̃mʉva cũinápʉrʉpe paimil baju barejáima. Apevʉ, nomiva aru jʉed̶ova máre, ãrejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dinʉmʉ Jesús jatuicõjenejame ñʉja ʉ̃i bueimarare jiad̶ocũi, ñʉje nʉrajiyepe ayʉ ʉ̃i jipocai macajitabʉ ʉrabʉ apedʉvei. Que teni copaicõjenejamed̶a ina põevare ne cʉ̃ramiai. ");
INSERT INTO cubNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ne nʉriburu yóboi, Jʉ̃menijicʉre coyʉcʉnʉrejamed̶a cũinácʉva cʉ̃racũi. Noi ʉ̃i coyʉiyede Jʉ̃menijicʉque, ñami marejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dicũ, ñʉje jiad̶ocũ, macajitabʉ ʉrabʉ coricai cʉrejavʉ̃. Pãcaiboa ʉraboa jarʉrʉrejavʉ̃ dicũre. Aru ũmevʉ cobarejavʉ̃ ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aru jãravʉcapũravʉi aviá ʉ̃i daquiye jipocai, Jesús curĩ macajitabʉ ʉrabʉ pʉenora darejame ñʉje yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ʉbenita ñʉja jã́ivʉ ʉ̃ cuyʉre macajitabʉ ʉrabʉ pʉenora, jidʉrivʉ baju cod̶oboborejacarã: —¡Põe decocʉ bácʉtame! arĩ cod̶oboborejacarã ñʉja, jidʉrivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ʉbenita maumena ñʉjare coyʉrĩ, arejame Jesús: —Parʉéque dápiajarã. Yʉ́tamu Jesús. Jidʉbejarã mʉja, arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Dinʉmʉma Pedro arejame ʉ̃́re: —Mʉ, ji jabocʉ, jãve mʉ maru, yʉre daicõjejacʉ mi yebai, oco pʉenora, arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aru Jesús arejame ʉ̃́re: —Dajacʉ, arejame. Que jápiayʉ, Pedro etarejame dicũre jocarĩ. Aru vaivárejame oco pʉenora, nʉriducʉyʉ Jesús yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ʉbenita ũmevʉ pare japuiyede jã́ri, jidʉrejamed̶a ʉ̃. Jidʉcʉ, corĩ bʉ́rejame. Que baru cod̶oboborejame: —¡Mʉ, ji jabocʉ, cad̶atejacʉ yʉre! arejame. ");
INSERT INTO cubNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Maumejiena Jesús jabióvarejame Pedrore ʉ̃i pʉrʉi. Aru arejame ʉ̃́re: —¿Aipe teni jidʉcʉrʉ̃ mʉ? ¿Aipe teni “Jesús mead̶acʉyʉme yʉre”, abecʉrʉ̃ mʉ? arejame Pedrore. ");
INSERT INTO cubNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ne jatuiyede dicũ jiad̶ocũi, ũmevʉ bíjarejavʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Aru ñʉja dicũi cʉrivʉ mearore jídejacarã Jesúre. —Jãve mʉ́tamu Jʉ̃menijicʉi mácʉ, arejacarã ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jatarĩburu yóboi, earejacarã Genesaret ãmicʉrijoborõi. ");
INSERT INTO cubNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aru dicũre jocarĩ etaivʉ bácavʉre, obedivʉ põeva coreóvarejaima Jesúre. Que baru ʉ̃i borore jarorejaimad̶a caino ne ĩmaroai, ne davarãjiyepe aivʉ ijimarare. ");
INSERT INTO cubNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ʉ̃́re jẽniarejaima, jẽni jã́rajivʉ ʉ̃i cuitótecaje tʉrʉvarã. Aru caivʉ jẽni jã́ivʉ meateivʉ barejáima na, ijimara mácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dinʉmʉ fariseovacavʉ apevʉ Jʉ̃menijicʉi yávaiye báquede bueipõevaque, Jerusalén ãmicʉriĩmarore jocarĩ daivʉ bácavʉ, jã́radarejaima Jesúre. Aru ʉ̃́re yópe arĩ, jẽniari jã́rejaima: ");
INSERT INTO cubNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Aipe teni mi bueimara ne pʉrʉáre cojabedi ne ãrajiye jipocai, Jʉ̃menijicʉi me jã́quiyepe aivʉ náre? Yópe ne ãiyede, majeñecuva mácavʉ ne d̶aicõjeiye báquede vainí tʉyama na, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús náre yópe arĩ, coyʉrejame: —¿Mʉja máre, aipe teni vainí tʉivʉrʉ̃ Jʉ̃menijicʉi d̶aicõjeiyede, d̶arãjivʉ yópe mʉjeñecuva mácavʉ ne d̶aicõjeiye báquepe? ");
INSERT INTO cubNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jʉ̃menijicʉ yópe aicõjenejaquemavʉ: “Mipacʉre aru mipacore máre ʉrĩ, jʉ ajarã. Ʉbenita ñaine ãmeno coyʉyʉre jípacʉre o jípacore máre, mʉje jabova boarĩ́ jarʉvajarãri ʉ̃́re”, arejaquemavʉ Jʉ̃menijicʉ, ʉ̃i ʉe boje põeva ne cad̶atequiyepe ayʉ nébʉcʉvare. ");
INSERT INTO cubNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ʉbenita mʉja bueivʉbu yópe: “Cũinácʉ põecʉ jípacʉre o jípacore ayʉ baru, ‘Mʉre cad̶ateyʉ bʉojabevʉ. Ji tãutʉrare, mʉje jacopʉjʉroede, javeita jícacʉ yʉ Jʉ̃menijicʉre’, ayʉ bájebu ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ñai põecʉre cad̶ateiye jaʉbevʉ ʉ̃i bʉcʉvare”, aivʉbu mʉja. Que baru mʉje d̶aiye boje yópe mʉjeñecuva mácavʉ ne d̶aicõjeiye báquepe, Jʉ̃menijicʉi yávaiyede bojecʉbede d̶aivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mʉja, jʉjovaivʉ, jãve Jʉ̃menijicʉ, yópe arĩ, coyʉcaicõjenejaquemavʉ ʉ̃i yávaiyede Isaías bácʉre mʉjara: ");
INSERT INTO cubNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ina põeva yʉre jʉ ad̶ama ne jijecamuque. Ʉbenita d̶abema yópe ji ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Bojecʉbenoque mearore jíniduyama yʉre. Bueniduyama põeva ne bueinore Jʉ̃menijicʉi yávaiyepe, arejaquemavʉ. Que arejame Jesús ina fariseovare aru ina Jʉ̃menijicʉi yávaiye báquede bueipõevare. ");
INSERT INTO cubNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús órejarejame ina põevare ʉ̃i yebai. Aru arejame náre: —Caivʉ yʉre jápiaivʉ dápiajarã. ");
INSERT INTO cubNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Caiye iye ecoiye põeva ne jijecamui jedevaque ãmeina tede d̶abevʉ náre. Ʉbenita caiye iye etaiye põeva ne jijecamure jocarĩ ne ũmeque ãmeina tede d̶aivʉ náre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Dinʉmʉre ñʉja, ʉ̃i bueimara, ʉ̃i yebai nʉri, arejacarã Jesúre: —Ina fariseova jorojĩñama mʉre, ne jápiaiyede mi coyʉiyede, arejacarã ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yópe arĩ, coyʉrejame ñʉjare: —Yópe jio upacʉi ĩni jarʉvaiyepe caiye ãmene bʉcʉiyede ʉ̃i jioi, ʉ̃i oteiye báque ãmene, nopedeca jipacʉ, cavarõ mearocacʉ, ĩni jarʉvacʉyʉme ʉ̃́re jocarĩ caivʉ ina ʉ̃́re coyʉcaipõevape teivʉre ʉbenina. ");
INSERT INTO cubNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Náre cãrijovaicõjemejara mʉja. Námu jã́ri eabevʉpe paivʉ jipocateiyʉrivʉ apevʉre, ʉbenita jãve ñamene cad̶ateni majibevʉ. Cũinácʉ jã́ri eabecʉ bʉojabebi nʉñʉ mái apecʉ jã́ri eabecʉque. Que baru caipʉcarã jã́ri eabevʉ baru, tʉjebu na cobei, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedrocapũravʉ arejame ʉ̃́re: —Coyʉjacʉ ñʉjare aipe aiyʉrõre yo jã́ri dápiarĩ ñʉje d̶arãjiyepe ainore, arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Aru arejame: —¿Mʉja máre jápiarĩ coreóvabenarʉ? ");
INSERT INTO cubNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Coreóvabenarʉ caiye iye ecoiyede põeva ne jijecamui jedevaque, ne yapibʉi earĩ etaiyede ne bajure jocarĩ? ");
INSERT INTO cubNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ʉbenita caiye iye etaiye põeva ne jijecamure jocarĩ ne ũmeque, diedecabu, ne dápiaiye, ãmeina tede d̶aiye náre. ");
INSERT INTO cubNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ne ũmei ãmeina dápiad̶ama apevʉre. Boarĩ́ jarʉvad̶ama põevare. Nomicʉrivʉvacari apecoque cʉma. O nomiva máre ʉ̃mʉcʉrivʉvacari apecʉque cʉma. Nomicʉbevʉ, aru ʉ̃mʉcʉbevʉ máre, d̶ad̶ama caiyede ãmeina d̶aiyede apevʉque. Ñavad̶ama apevʉ ne cʉvaede. Borocʉma apevʉi borore. Aru coyʉyama ãmenore apevʉi borore caivʉ ne jápiaiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Caiye iye ãmene etaiye põeva ne ũme jívʉquede, ãmeũme cʉre d̶aivʉ náre. Ʉbenita ne ãiyede ne pʉrʉáre cojabevʉva, d̶abevʉ yópe mʉjeñecuva mácavʉ ne d̶aicõjeiye báquepe, ãmeina tede d̶abevʉ náre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Diĩmarore jocarĩ, Jesús nʉrejame apejoborõi, Tiro aru Sidón ãmicʉriĩmaroa yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aru cũináco nócaco, judíova ãmevʉcaco, Canaán ãmicʉriyajubocaco, ʉ̃i yebai darĩ, yópe arĩ, cod̶oboborejaco: —Mʉ, ji jabocʉ, David bácʉi pãramecʉ, judíovai jabocʉ bacʉyʉ́, cõmaje ãroje jã́jacʉ yʉre. Jímacobe abujucʉ ʉ̃i ĩmamo. Pare ñájiñome õ, arejaco õ. ");
INSERT INTO cubNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ʉbenita Jesúcapũravʉ bi ayʉ, yéde coyʉbedejame ṍre. Aru ñʉja ʉ̃i bueimaracapũravʉ Jesús yebai nʉri, ʉ̃́re jaroicõjenidurejacarã ṍre. —Maje yóboi cod̶oboborĩ daibico õ. Que baru ṍre copainʉre d̶ajacʉ mʉ, arĩdurejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús arejame: —Jipacʉ Jʉ̃menijicʉ daroibi yʉre, ji cad̶atequiyepe ayʉ ñʉja Israecavʉre quévʉra. Námu yópe ovejava mamateivʉpe paivʉ, náre coreipõecʉ cʉvabevʉpe, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ʉbenita õ darĩ, ñʉatutarĩ ʉ̃i jipocai, pued̶acod̶o ʉ̃́re, arejaco: —Mʉ, ji jabocʉ, cad̶atejacʉ yʉre, arejaco. ");
INSERT INTO cubNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesúcapũravʉ arejame ṍre: —Meamevʉ ĩnu jʉed̶ova ne ãiyede, jínajivʉ yavimivare, arejame ʉ̃. Que arĩ, aiyʉcʉ barejaquémavʉ judíovare Jʉ̃menijicʉi márape aru judíova ãmevʉre yavimivape. ");
INSERT INTO cubNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aru ṍcapũravʉ arejaco: —Mʉ, ji jabocʉ, jãve coyʉivʉ mʉ. Ʉbenita yavimiva máre ãd̶ama náre upacʉ jivʉ ne ãri jarʉvaiye tʉiye báquede tʉoivare jocarĩ, arejaco Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús arejame: —Mʉ, ji ʉmo, ʉrarõ jʉ ad̶obu yʉre. Que baru d̶acaivʉ mʉre yópe mi ʉrõpe, arejame ṍre Jesús. Aru cũiná meatedejaquemavʉ õi máco. ");
INSERT INTO cubNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús nʉrejame nore jocarĩ. Vaidéjame macajitabʉ ʉrabʉ Galilea ãmicʉrijitabʉ ẽcarʉi. Aru cʉ̃racũ ʉracũi mʉri nʉriburu yóboi, dicũ pʉenoi dobarejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Noi dobacʉre, obedivʉ põeva darejaima ʉ̃i yebai. Davarejaima cuiye majibevʉre, jã́ri eabevʉre, pʉrʉ ijimarare, yávaiye majibevʉre, aru apevʉre máre. Náre jũarejaima Jesúi cʉboba yebai. Aru náre mead̶arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Que teni caivʉ ina obedivʉ põeva cuecumarejaima ne jã́iyede ina yávaiye majibevʉ bácavʉ yávaivʉre, ina ijimara mácavʉ mead̶aimarare, ina cuiye majibevʉ bácavʉ vaiváivʉre, aru ina jã́ri eabevʉ bácavʉ jã́ivʉre. Aru caivʉ ina põeva mearore jídejaima Jʉ̃menijicʉre, maja Israecavʉ maje mearore jímʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dinʉmʉ Jesús órejarejame ñʉja ʉ̃i bueimarare ʉ̃i yebai. Aru arejame: —Cõmaje ãroje jã́ivʉ yʉ ina põevare. Ina obedivʉ cʉma yʉ́que yóbecʉrijãravʉa. Aru ãiyede cʉvabema. Apevʉ ne cʉ̃ramia joarõtamu. Que baru copaicõjeiyʉbevʉ yʉ náre. Mái nʉri, mamad̶ajebu, ne ãvʉé ñájiye boje, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ñʉjacapũravʉ jẽniari jã́rejacarã ʉ̃́re: —¿Ã́ri earãjidica ñʉja ãiyede yui põecʉbenoi, jínajivʉ caivʉ ina obedivʉ põevare? arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesúcapũravʉ jẽniari jã́rejame ñʉjare: —¿Aipino pã́uboare cʉvarãrʉ mʉja? arejame ʉ̃. Aru arejacarã: —Siete paiboabu. Aru obebejĩna moajinare máre cʉvavʉ, arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Que aiyede, ina põevare dobaicõjenejame joborõi. ");
INSERT INTO cubNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Diboá pã́uboa siete paiboare ĩni, aru ina moajinare máre ĩni, torojʉede jídejame Jʉ̃menijicʉre. Ʉ̃i cotʉvarĩburu yóboi pã́uboare, ñʉja ʉ̃i bueimara jídejacarã diede ina põevare, yópe Jesús ʉ̃i jícõjeiye báquepedeca ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Que d̶aiyede, ãri yapidejaima caivʉ. Aru ãri bubarĩburu yóboi, iye cotʉvaiye báque pã́u aru moa máre, põeva ne ãri oabede ĩni, mead̶arĩ, pʉeá siete paipʉea, judíova ãmevʉ ne pʉeáre, buivárejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ina ãivʉ bácavʉ ʉ̃mʉva yóvaicʉvaimil baju barejáima na. Aru apevʉ, nomiva aru jʉed̶ova máre, ãrejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús ʉ̃i copaicõjeniburu yóboi ina põevare ne cʉ̃ramiai, jiad̶ocũi jaturĩ, nʉrejacarã ʉ̃́que apejoborõi, Magadán ãmicʉrijoborõita. ");
INSERT INTO cubNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Apevʉ fariseovacavʉ aru saduceovacavʉ máre jʉjovaiyʉrãdarejaima Jesús yebai. Jẽniarejaima ʉ̃i jã́d̶ovaquiyepe aivʉ náre põeva ne d̶arĩ majibede, cavarõ mearo Jʉ̃menijicʉi cʉrõquede. ");
INSERT INTO cubNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús, yópe arĩ, coyʉrejame náre: —Aviá ʉ̃i doiyede, “Ocopenibobu jũaripenibo. Que baru javena meajãravʉ baquiyébu”, aiyavʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aru aviá ʉ̃i cõaiyede, “Ocopenibobu jũaripenibo. Que baru cari jãravʉ ocaquiyebu”, aiyavʉ̃ mʉja. Cavarõquede coreóvaivʉvacari, ʉbenita pare coreóvabevʉbu mʉja ijãravʉi vaiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mʉja ãmena bajutamu, dajocaiyʉrivʉ Jʉ̃menijicʉre yópe nomió ãmeco õi dajocaiyepe jímarepacʉre jocarĩ. Mʉjarecabu jẽniariduivʉ jã́d̶ovaiye põeva ne d̶arĩ majibede. Ʉbenita jã́menamu mʉja apenore Jʉ̃menijicʉi d̶ainore mʉjare, quénora yo Jonás mácʉre vaino mácarõre, arejame Jesús. Que arĩ, náre dajocarĩ nʉrejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jataivʉ bácavʉ macajitabʉ ʉrabʉ apedʉveita, ñʉja Jesúi bueimara coreóvarejacarã ãrʉmeteivʉ bácavʉ pã́ure. ");
INSERT INTO cubNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús arejame ñʉjare: —Me d̶ajarã. Me jã́jara ina fariseova aru ina saduceova máre ne pã́ure bʉcʉóvare d̶aiyede, arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Que teni yávarejacarã ñʉje bajumia: —Ʉ̃ yópe aibi, maje pã́ure cʉvabe boje, arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ʉbenita Jesús coreóvarejaquemavʉ ñʉje yávainore. Que baru arejame: —¿Aipe teni yʉre jʉ abenarʉ mʉja? ¿Aipe teni coyʉivʉrʉ̃ mʉja, “Pã́ure cʉvabevʉ maja” aivʉ? ");
INSERT INTO cubNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Coreóvabenarʉ mʉja? ¿Aru ãrʉmenarʉ mʉja? ¿Ji cotʉvacaiye báquede cũinápʉrʉpe paiboa pã́uboare ina cũinápʉrʉpe paimil baju ʉ̃mʉvare, doce paibʉa pʉebʉa baju cotʉvaiye báqueque ĩmetecarãrʉ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Aru ji cotʉvacaiye báquede siete paiboare ina yóvaicʉvaimil baju ʉ̃mʉvare, siete paipʉea baju cotʉvaiye báqueque ĩmetecarãrʉ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Que baru mʉjare jaʉéde, mʉje ãrajiyede, jíyʉ majivʉ yʉ. Ʉbenita, “Me jã́jara ina fariseova aru ina saduceova máre ne pã́ure bʉcʉóvare d̶aiyede” ji ainore, coyʉbetevʉ yʉ pã́ure. Quénora coyʉyʉbu yʉ ne dápiaiyede. Que baru me jã́jara, mʉje dápiabenajiyepe aivʉ yópe ne dápiaiyepe, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Dinʉmʉ coreóvarejacarã coyʉyʉre ina fariseova aru ina saduceova máre ne bueiyede. Yópe pã́ure bʉcʉre d̶aiye jĩvaiyepe, caiye iye pã́u d̶aiyede, nopedeca ne bueiye jãve ãmeque jʉjovad̶ama obedivʉ põevare, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús, ʉ̃i eaiyede Cesarea de Filipo ãmicʉrõi, ñʉja ʉ̃i bueimarare jẽniari jã́rejame: —¿Aipe aidi põeva yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe? arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ʉ̃́re arejacarã: —Apevʉ ad̶ama, “Juan Bautistabe”. Aru apevʉ ad̶ama, “Elíabe”. Aru apevʉ ad̶ama, “Jeremíame”. Aru apevʉ ad̶ama, “Cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉbe ʉ̃”, arejacarã ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aru arejame ñʉjare: —¿Ʉbenita aipe aivʉrʉ̃ mʉja yʉre? arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Aru Simón Pedro arejame ʉ̃́re: —Mʉ Jʉ̃menijicʉi daroimʉ mácʉbu, ñʉjare jabotecʉyʉ. Cristobu mʉ. Jʉ̃menijicʉ apʉcʉi mácʉbu mʉ, arejame Pedro Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Aru Jesúcapũravʉ, yópe arĩ, coyʉrejame Pedrore: —Mʉ, Simón, Jonái mácʉ, torojʉcʉyʉmu mʉ. Jʉ̃menijicʉi mearo d̶acaimʉmu mʉ. Põecʉ cʉbebi coreóvare d̶ayʉ mʉre diede. Quénora jipacʉ, cavarõ mearocacʉrecabe coreóvare d̶ayʉ mʉre diede. ");
INSERT INTO cubNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Coyʉyʉbu mʉre: Mi ãmiámu Pedro. No ãmiá cʉ̃ravacarõ aiyʉrõmu. Mi coyʉiyebu yʉre yópe cʉ̃rava ʉrava parʉrivape paiye cʉ̃rami cãchinoi. Caivʉ jʉ aivʉre yʉre, aru caivʉ jʉ arãjivʉre yʉre máre, coyʉiye jaʉvʉ yʉre mi coyʉiyepe paiye. Aru caivʉ ina yaibénajarama ne ũmei. Que baru coatebenajarama Jʉ̃menijicʉre jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yópe ñai cʉvacʉ cʉ̃ramine voainore, llavede, ʉ̃i ecoicõjeiyepe põevare diñamine, nopedeca coyʉicõjeivʉ mʉre ji yávaiye méne põevare, ne ecorãjiyepe ayʉ Jʉ̃menijicʉi jaboteinore, diede ne jʉ aru. Mi jacopʉbemarare ijãravʉi jacopʉbecʉyʉme Jʉ̃menijicʉ cavarõ mearo ʉ̃i cʉrõi. Aru mi jacopʉimarare ijãravʉi jacopʉcʉyʉme Jʉ̃menijicʉ cavarõ mearo ʉ̃i cʉrõi, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aru parʉéque ñʉjare “Jesúbe ñai Cristo, Jʉ̃menijicʉi daroimʉ mácʉ”, arĩ coyʉicõjemenejame apevʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dinʉmʉmata Jesús jã́d̶ovari bʉ́rejame ñʉja ʉ̃i bueimarare ñájicʉnʉcʉyʉre Jerusalén ãmicʉriĩmaroi. Yópe arĩ, buedejame ñʉjare: —Jaʉvʉ yʉre ʉrarõ ji ñájiquino. Ina judíova bʉcʉva, aru sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre yʉre ñájine d̶arãjarama. Yʉre boarĩ́ jarʉvarãjarama. Aru yóbecʉrijãravʉa yóboi nacajacʉyʉmu yʉ yainore jarʉvarĩ, arĩ coyʉrejame ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro ʉ̃́re nʉvarejame apevʉ ñʉjare jocarĩ. Aru yópe arĩ, jararĩdurejame Jesúre: —¡Mʉ, ji jabocʉ, mi que aiyepe vaicõjemejacʉrĩ mʉre Jʉ̃menijicʉ! arejame Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ʉbenita Jesús copedini, arejame Pedrore: —Mʉ, Satanás, jʉjovarĩdubejacʉ yʉre. Nʉjacʉ mʉ yʉre jocarĩ. Mʉrecabu maucʉvacʉ yʉre mi nópe aiyeque. Dápiaivʉ mʉ põevape. Aru dápiabevʉ mʉ Jʉ̃menijicʉ jiede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","No yóboi Jesús, yópe arĩ, coyʉrejame ñʉja ʉ̃i bueimarare: —Ácʉ põecʉ daiyʉcʉ yʉ́que, dajocajacʉrĩ põeva ne mearo jã́iyede ʉ̃́re, cʉyebejacʉrĩ yʉre yóvaiyede, aru jidʉbejacʉrĩ ʉ̃i ñájiquiyede. Nópe d̶abecʉ baru, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ñai põecʉ ʉ̃i baju ʉrõpe d̶arĩ, mead̶aiyʉcʉ baru ʉ̃i bajure, coatecʉyʉme ʉ̃i bajure Jʉ̃menijicʉre jarʉvarĩ, yópe yaiyʉ́ bácʉpe ʉ̃i ũmei. Ʉbenita ñai põecʉ, “Ye baju ãmevʉ, ji yaidú Cristore boje” ayʉ, ʉ̃i baju ʉrõpe d̶abecʉva quénora ji ʉrõpe d̶arĩ, ʉ̃́recabe ji mead̶aquimʉ, cʉcʉyʉ Jʉ̃menijicʉque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ñai põecʉ cʉvacʉ baru caiye ijãravʉquede, ʉbenita bíjayʉ baru ʉ̃i ũmene, ñájicʉyʉme cainʉmʉa toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Que teni yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, meacʉ baju dacʉyʉmu jipacʉi mearoque aru ji ángelevaque, bojed̶acʉyʉ caivʉ põevare yópe ne d̶aiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jãve coyʉyʉbu mʉjare: Apevʉ cʉrivʉ yui, ne yainájiye jipocai jã́rajarama yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jaboteyʉre, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis paijãravʉa yóboi, Jesús nʉvarejamed̶a Pedrore, aru Santiagore, ĩmacʉ Jũare máre. Jipocatedejamed̶a náre cʉ̃racũ ʉ̃mʉjʉricũ pʉenoi, apevʉre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aru na jã́rejaimad̶a ʉ̃i oatʉvaiye me bajure. Ʉ̃i jiva pẽorejavʉ̃ya, yópe aviá ʉ̃i pẽoiyepe. Ʉ̃i cuitótecaje máre pẽorejavʉ̃ya, pare boricaje yópe miad̶árope. ");
INSERT INTO cubNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aru járorejaimad̶a Elías Moisémaque. Núrejaimad̶a boroteivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aru Pedro arejamed̶a Jesúre: —Mʉ, ji jabocʉ, mearotamu ñʉje cʉru yui. Mi ʉru, d̶acaquijivʉ yʉ yóbecʉriñamia cʉ̃ramia quĩ́jiñamia maquiyéde. Cũinád̶ami míñami maquinóre, aru aped̶ãmi maquinóre Moiséde, aru aped̶ãmi maquinóre Elíare d̶acaquijivʉ yʉ, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ʉ̃i coyʉiyedeca, ocopenibo miad̶áripenibo ẽmeni, taorejavʉ̃ya náre. Aru jápiarejaimad̶a apeno yávainore, ocopeniboi etaiyede: “Ñaime jímacʉ, ji ʉmʉ. Me torojʉvʉ yʉ ʉ̃́re. Que baru jápiajarã ʉ̃i coyʉiyede”, arejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ina yóbecʉrã Jesúi bueimara ne jápiaiyede diede, jidʉrĩ, mori tʉrejaimad̶a joborõi. ");
INSERT INTO cubNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ʉbenita Jesús ne yebai nʉri, náre tʉorĩ, arejamed̶a: —Nacajajara mʉja. Jidʉbejarã, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ne jã́iyede, jã́rejaimad̶a Jesúre cũinácʉra. ");
INSERT INTO cubNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Aru ẽmeni daiyede dicũ cʉ̃racũre jocarĩ, Jesús apevʉre coyʉicõjemenejamed̶a náre ne jã́ino mácarõre. Yópe arejamed̶a: —Me jápiajarã mʉja. Coyʉbejarã apevʉre no mʉje jã́ino mácarõre cʉ̃racũ ʉ̃mʉjʉricũ pʉenoi pʉ ji nacajariburu yóboita yainore jarʉvarĩ. Yʉ́bu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Aru ina ʉ̃i bueimara, coreóvaivʉ ʉ̃́re Jʉ̃menijicʉi daroimʉ mácʉre, ʉ̃́re jẽniari jã́rejaimad̶a: —¿Aipe teni aivʉba ina Jʉ̃menijicʉi yávaiye báquede bueipõeva, “Mamarʉmʉ Elías dacʉyʉme, ñai Jʉ̃menijicʉi daroimʉ ʉ̃i daquiye jipocai”? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aru Jesús arejamed̶a náre: —Jãve Elíarecabe mead̶acʉdacʉyʉ caiyede, Jʉ̃menijicʉi daroimʉ ʉ̃i daquiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jave dáme Elías, ayʉbu yʉ mʉjare. Ʉbenita põeva ʉ̃́re coreóvabeteima na. Quénora ne ʉrõpe d̶aima ʉ̃́re. Quédecabu yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe. Yʉre máre põeva ñájine d̶arãjarama, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dinʉmʉre ina ʉ̃i bueimara coreóvarejaimad̶a ʉ̃i coyʉiyede náre Juan Bautista bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesújã ne eaiyede obedivʉ põeva yebai, cũinácʉ ʉ̃mʉ nʉrejame Jesús yebai. Ñʉatutarĩ ʉ̃i jipocai, pued̶acʉyʉ ʉ̃́re, arejame: ");
INSERT INTO cubNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Mʉ, ji jabocʉ, cõmaje ãroje jã́jacʉ jímacʉre. Bidini, aru aburi etarĩ ʉ̃i jijecamure, pare ñájimi ʉ̃. Apenʉmʉa tʉibi toaboi. Aru apenʉmʉa jiai tʉrĩ coibi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ʉ̃́re davavʉ yʉ mi bueimara yebai, ʉbenita mead̶aiye majibetema na, arejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús arejame: —Mʉja, ijãravʉcavʉ, Jʉ̃menijicʉre jʉ abevʉ aru ãmeina teivʉ máre, ¿aipijãravʉa cʉquidi yʉ mʉjaque? ¿Aru aipijãravʉa ñájiquidi yʉ mʉjaque, mʉje jʉ arãjiyepe ayʉ ji coyʉiyede? Davajacʉ mímacʉre ji yebai, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Que teni Jesús ñai abujucʉre jararĩ, jaetovarejame jʉed̶ocʉre jocarĩ. Aru maumejiena meatedejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Que d̶arĩburu yóboi, ñʉja ʉ̃i bueimara jẽniari jã́re nʉrejacarã Jesúre cũinácʉra, yópe arĩ: —¿Aipe teni ñʉja jaetovarĩ majibetedi ñai abujucʉre? arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aru Jesús arejame ñʉjare: —Quĩ́jino mʉje jʉ aiye boje yʉre, que baru jaetovarĩ majibetevʉ mʉja. Jãve coyʉyʉbu mʉjare: Oteiyabe mostaza ãmicʉriyabe quĩ́jiyabetamu. Ʉbenita pĩaríburu yóboi, jocʉcʉ ʉracʉtamu. Nopedeca mʉje jʉ aru yʉre quĩ́jino, nópe quĩ́jiyabe oteiyabepe, Jʉ̃menijicʉ ʉrarõ mearore d̶ajebu mʉjare. Mʉja me jʉ aivʉ Jʉ̃menijicʉre mʉje cõjenu icũ cʉ̃racũ ʉracũre yópe: “Nʉjacũ yore jocarĩ pʉ ãnoita”, dicũ jʉ ajebu mʉje cõjeiyede. Jãve jʉ aivʉ baru yʉre, caiye d̶aiyede majinajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jʉ̃menijicʉre jẽniaiye jaʉvʉ ãmevʉva ãiyede, abujucʉ ñaipe páyʉre mʉje jaetovarãjiyepe aivʉ, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Ñʉje cójijiyedeca Galilea ãmicʉrijoborõi, Jesús, yópe arĩ, buedejame ñʉjare: —Yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jẽni jínajivʉbu ji mauvare, ne boarĩ́ jarʉvarãjiyepe ayʉ yʉre. Aru yóbecʉrijãravʉa yóboi, Jʉ̃menijicʉ nacovacʉyʉme yʉre yainore jarʉvarĩ, arejame Jesús. Ʉ̃i nópe aiyede, pare cãrijivʉ barejacárã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ñʉje copaidaiyede Capernaum ãmicʉriĩmaroi, Pedro yebai darejaimad̶a ina Jʉ̃menijicʉi cʉ̃ramine tãutʉra ĩcaipõeva. Ʉ̃́re jẽniari jã́rejaimad̶a, yópe arĩ: —¿Jíbedi ñai mi bueipõecʉ tãutʉratʉravare, Jʉ̃menijicʉi cʉ̃ramine mead̶aiye boje? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aru Pedro jʉ arejamed̶a náre: —Jʉ̃́jʉ, jíbi ʉ̃, arejamed̶a. Aru cʉ̃rami copaiyede, mamarʉmʉre Jesús jẽniari jã́rejamed̶a ʉ̃́re, yópe arĩ: —Mʉ, Simón, ¿aipe dápiayʉrʉ̃ mʉ? ¿Ñamene jocarĩ tãutʉrare ĩni ijãravʉcavʉ jabova? ¿Ĩni ne jaboteimarare jocarĩ o apevʉre jocarĩ? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro arejamed̶a: —Tãutʉrare ĩñama apevʉre jocarĩ, arejamed̶a. Jesús arejamed̶a: —Que baru ne jaboteimarare jíye jaʉbevʉ tãutʉrare ne jabovare. Quédeca tãutʉrare jíye jaʉbevʉ yʉre, Jʉ̃menijicʉi mácʉre, ne mead̶arãjiyepe jipacʉi cʉ̃ramine. ");
INSERT INTO cubNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ʉbenita ne jorojĩmenajiyepe majare, jajovacʉnʉjacʉ mʉ macajitabʉ ʉrabʉ ẽcarʉi. Ñai mamarʉmʉ mi ĩ́mʉ moacʉ ʉ̃i jijecamure voarĩ, eacʉyʉmu mʉ cũinátʉrava tãutʉratʉravare, jícacʉyʉ yʉre aru mʉre máre. Ditʉrava cũinátʉrʉ baquiyébu maja pʉcarã majare jíye jaʉé Jʉ̃menijicʉi cʉ̃ramine mead̶aiyede, arejamed̶a Jesús. Aru yópe Jesús ʉ̃i d̶aicõjeiyepe d̶arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Dinʉmʉre ñʉja, ʉ̃i bueimara, nʉrejacarã Jesús yebai. Aru jẽniari jã́rejacarã ʉ̃́re: —¿Ñamema parʉcʉ apevʉ pʉeno Jʉ̃menijicʉi jaboteinore? arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús órejarejame cũinácʉ jʉed̶ocʉre. Núvarejame ʉ̃́re ñʉje coricai. ");
INSERT INTO cubNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aru arejame: —Jãve coyʉyʉbu mʉjare: Jʉed̶ova “¿Meara márica ñʉja?” arĩ dápiabevʉpe dápiajarã mʉja. Oatʉvabevʉ baru mʉje dápiaiyede, Jʉ̃menijicʉi jaboteimara teivʉ bʉojabenajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ácʉ põecʉ “¿Meacʉ bárica yʉ?” abecʉ baru, yópe ñai jʉed̶ocʉpe, ʉ̃́recabe parʉcʉ apevʉ pʉeno Jʉ̃menijicʉi jaboteinore. ");
INSERT INTO cubNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Cũinácʉ põecʉ copʉ etayʉ baru cũinácʉ jʉed̶ocʉre ji ãmiái, ji cõjeiyepe, que d̶ayʉ copʉ etaibi yʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ñʉjare yópe arĩ, buede nʉrejame Jesús: —Ácʉ põecʉ ʉ̃i ãmeina tede d̶aru apecʉ yʉre jʉ ayʉre parʉbecʉreca, ʉ̃i dajocaquiyepe ayʉ ʉ̃i jʉ aiyede yʉre, meajebu ʉ̃́re jarʉvaru ʉ̃i ñamemui bʉorĩ cũinábo cʉ̃rabo ʉraboque jia ʉrad̶ai. ");
INSERT INTO cubNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Chĩori ãmeno ñájinajarama ina ijãravʉcavʉ jʉjovaivʉ apevʉre, ne ãmeno d̶arãjiyepe aivʉ. Jãve jʉjovarãjarama mʉjare. Ʉbenita ñai jʉjovare d̶ayʉ apevʉre chĩori ãmeno ñájicʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Aru mʉ ãmeno d̶ayʉ baru mi pʉrʉque o mi cʉbobaque, burarĩ jarʉvajacʉ dipʉrʉre o dibare. Meaquiyebu mʉre, mi earu Jʉ̃menijicʉi cʉrõi cũinápʉrʉque o cũinába cʉbobaque. Ʉbenita meamequiyebu mʉre, mi nʉru toabo cũiméboi caipʉcapʉrʉaque o caipʉcaba cʉbobaque. ");
INSERT INTO cubNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Aru mʉ ãmeno d̶ayʉ baru mi yacorʉque, ĩni jarʉvajacʉ didʉre. Meaquiyebu mʉre, mi earu Jʉ̃menijicʉi cʉrõi cũinárʉ yacorʉque. Ʉbenita meamequiyebu mʉre, mi nʉru toabo cũiméboi caipʉcarʉa yacorʉaque, majicarĩ arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesús, yópe arĩ, buedejame bedióva cojedeca jʉed̶ovarã: —Cavarõ mearo Jʉ̃menijicʉi cʉrõi ina ángeleva jʉed̶ovare coreivʉ cʉma cainʉmʉa Jʉ̃menijicʉi jivateinoi. Que baru cũinájicʉ ina jʉed̶ovacacʉre ye ãmeina jã́mejara mʉja. Yéde ãmeina d̶abejarã cũinájicʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, mead̶acʉdaivʉ ina bíjare d̶aivʉre Jʉ̃menijicʉre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Aipe dápiaivʉrʉ̃ mʉja iye ji coyʉquiyede mʉjare? Cũinácʉ ʉ̃mʉ, ovejavare coreipõecʉ, cʉvacʉ baru cien paivʉ ovejavare, aru cũinácʉ nácacʉ ʉ̃i mamatedu, ñai dajocajebu ina noventa y nueve paivʉ ovejavare cʉ̃racũai, vocʉñʉ ñai bíjayʉ bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aru jãve coyʉyʉbu mʉjare: Eayʉ baru ñai mamateyʉ bácʉre, torojʉjebu ʉ̃́que ina noventa y nueve paivʉ mamatebevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Quédeca cũinájicʉ ina quĩ́jinacacʉ ʉ̃i bíjaiyede ʉbebi jipacʉ cavarõ mearocacʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yópe arĩ, buedejame ñʉjare Jesús: —Apecʉ ʉ̃i ãmeina d̶aru mʉre, apevʉ ne jápiabenoi coyʉjacʉ ʉ̃́re ʉ̃i ãmeina d̶aiyede. Mi coyʉiyede jápiaru, ãrʉmetejacʉ ʉ̃i ãmeina d̶aiyede. Aru cãrijimene d̶ajarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ʉbenita mi coyʉiyede jápiaiyʉbedu, nʉvajacʉ ʉ̃i yebai cũinácʉ mʉjecʉre, ʉ̃i majiquiyepe ayʉ, o pʉcarã mʉjevʉre, ne majinajiyepe ayʉ, aipe mi coyʉiyede ʉ̃́re aru aipe ʉ̃i coyʉiyede mʉre máre, ne majicarãjiyepe ayʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne coyʉiyede máre jápiaiyʉbedu, coyʉjacʉ ʉ̃i ãmeina d̶aiyede caivʉ ina yʉre jʉ aivʉre ne cójijinoi. Aru ne coyʉiyede máre jápiaiyʉbedu, d̶ajacʉ ʉ̃́re yópe mi d̶aiyepe ina judíova ãmevʉre aru ina jabovare tãutʉra ĩcaipõevare. ");
INSERT INTO cubNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jãve coyʉyʉbu mʉjare: Caivʉ mʉje jacopʉbemarare ijãravʉi jacopʉbecʉyʉme Jʉ̃menijicʉ cavarõ mearo ʉ̃i cʉrõi. Aru caivʉ mʉje jacopʉimarare ijãravʉi jacopʉcʉyʉme Jʉ̃menijicʉ cavarõ mearo ʉ̃i cʉrõi. ");
INSERT INTO cubNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Bedióva cojedeca coyʉyʉbu mʉjare: Pʉcarã mʉjacavʉ cũinátʉrʉ baru mʉje ũmei, mʉje jẽniaiyede jipacʉ cavarõ mearocacʉre, ʉ̃́capũravʉ d̶acʉyʉme yópe mʉje jẽniaiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉcarã o yóbecʉrã ne cójijidu, jẽniarajivʉ ji ãmiái, ji parʉéque, yʉ́vacari cʉvʉ ne jẽneboi, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Dinʉmʉre Pedro jẽniari jã́rejame Jesúre: —Mʉ, ji jabocʉ, ¿aipiye baju majecʉ ʉ̃i ãmeina d̶aiyede yʉre ãrʉmeteji? ¿Siete baju ʉ̃i ãmeina d̶aiyede ãrʉmeteji? arejame Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Aru Jesús arejame ʉ̃́re: —Siete baju abevʉ yʉ. Quénora corevabecʉva ãrʉmetejacʉ ʉ̃i ãmeina d̶aiyede cainʉmʉa, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yópe arĩ, buedejame Jesús, jã́ri dápiarĩ ne d̶arãjiyepe ayʉ, põeva ne ãrʉmetenajiyepe ayʉ apevʉre ne ãmeina d̶aiyede: —Jʉ̃menijicʉi jaboteino yópebu cũinácʉ jabocʉ mead̶aiyʉcʉ ʉ̃́re memecaivʉ ne bojecʉbe d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ʉ̃i corevarĩ bʉiyede, apevʉ davaquemavʉ ʉ̃i yebai cũinácʉ ʉ̃́re memecaipõecʉre, bojecʉbe d̶ayʉre obedimillones tãutʉrare. ");
INSERT INTO cubNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ʉ̃i bojecʉbe d̶aiyede ye bojed̶ayʉ bʉojabetequemavʉ. Que baru ñai jabocʉ, yebacavʉpe teni, bojed̶aicõjequemavʉ ʉ̃́re, aru jímarepacore, aru némarare máre. Caiye ne cʉvaede máre bojed̶aicõjequemavʉ, ĩcʉyʉ ʉ̃i bojecʉbe d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ñai memecaipõecʉ pued̶arĩ ñai jabocʉre, ñʉatutaquemavʉ ʉ̃i jipocai. “Mʉ, ji jabocʉ, napijacʉ yʉre. Aru caiyede bojed̶acʉyʉmu mʉre”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Que baru ñai jabocʉ, cõmaje ãroje jã́ri, ãrʉmetequemavʉ caiye iye ʉre bojecʉbe d̶aiyede. Aru jod̶eicõjequemavʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Ʉbenita ñai memecaipõecʉ etayʉ bácʉ, apecʉ memecaipõecʉ ʉ̃i yóvaimʉre copʉquemavʉ. Ñai ʉ̃i copʉimʉ majiéda bojecʉbe d̶aquemavʉ ʉ̃́re, obebecentenares tãutʉrare. Ñai ʉ̃i copʉimʉre ʉ̃i ñamemui jẽni, yaiváiyʉrĩduquemavʉ ʉ̃́re. “¡Mi bojecʉbe d̶aiyede jíjacʉ yʉre!” aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Que d̶ayʉre, apecʉ ñʉatutaquemavʉ ʉ̃i jipocai. “Napijacʉ yʉre. Caiyede bojed̶acʉyʉmu mʉre”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ʉbenita apecʉ jápiaiyʉbetequemavʉ ʉ̃́re. Quénora jarʉvaicõjequemavʉ ʉ̃́re ãmeina teivʉre jẽni jacoiñami jívʉi, pʉ ʉ̃i bojed̶aiyeta caiye iye bojecʉbe d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Apevʉ ñai jabocʉre memecaivʉ ʉ̃i d̶aiyede jã́ri, chĩori, coyʉrãnʉquemavʉ diede ne jabocʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ne coyʉiyede ʉ̃i jápiarĩburu yóboi, ñai jabocʉ órejaicõjequemavʉ ñai ʉ̃i ãrʉmeteimʉ mácʉre. Aru aquemavʉ: “¡Ãmecʉ bajutamu mʉ! Yʉ́capũravʉ ãrʉmetevʉ caiye iye mi bojecʉbe d̶aiye báque ʉrarõ bajure, mi jẽniaiye báque boje yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Que baru mʉre máre, cõmaje ãroje jã́iye jaʉvʉ mícʉre, yópe ji cõmaje ãroje jã́iyepe mʉre”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pare jarayʉ, ñai jabocʉ ãmeina teivʉre jẽni jacoiñami coreipõevare nʉvaicõjequemavʉ ʉ̃́re, ʉ̃i ñájiquiyepe ayʉ, pʉ ʉ̃i bojed̶aiyeta caiye iye bojecʉbe d̶aiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aru arejame Jesús: —Quédeca d̶acʉyʉme mʉjare jipacʉ, cavarõ mearocacʉ, mʉje ãrʉmetebedu mʉjecʉre ʉ̃i ãmeina d̶aiyede, arejame ñʉjare, majicayʉ Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús caiye iyede coyʉrĩ bʉojarĩ, nʉrejame Galilea ãmicʉrijoborõre jocarĩ. Aru ecorejame Judea ãmicʉrijoborõi, Jordán ãmicʉriya jia apedʉvei. ");
INSERT INTO cubNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Obedivʉ põeva darejaima ʉ̃i yóboi. Aru noi ijimarare mead̶arejame. ");
INSERT INTO cubNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fariseovacavʉ máre nʉrejaima ʉ̃i yebai. Ʉ̃́re jʉjovaiyʉrivʉ, jẽniari jã́rejaima: —¿Cũinácʉ ʉ̃mʉ jarʉvayʉ baru jímarepacore, apejĩe õi d̶aiye boje, d̶aidi yópe maje d̶aicõjeiyepe? arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús arejame náre: —Jãve bued̶avʉ̃ mʉja. Mamarʉmʉre Jʉ̃menijicʉ cʉed̶arejaquemavʉ caiyede, “Ʉ̃mʉ macʉyʉ́re aru nomió macod̶óre máre d̶arejaquemavʉ Jʉ̃menijicʉ”. ");
INSERT INTO cubNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aru arejaquemavʉ: “Que baru caride ácʉ põecʉ, jímarepaco bacod̶ó cʉvacʉyʉ, ʉ̃i bʉcʉvare dajocacʉyʉme. Aru jímarepacore cʉvarĩ, ṍmaque cũinávʉpetamu na Jʉ̃menijicʉi jã́inore”. ");
INSERT INTO cubNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Que baru pʉcarã ãmema. Quénora cũinávʉpetamu na. Que baru põecʉ Jʉ̃menijicʉi cójijovaimara mácavʉre coavabejacʉrĩ ʉ̃, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesúre jẽniari jã́rejaima na: —¿Aipe teni Moisés bácʉ jícõjenejaquemari jímarepacʉre cũináyoca, “Mʉre jarʉvayʉbu yʉ” aiyocare, jímarepacore? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Aru Jesús arejame náre: —Moisés bácʉ jarʉvaicõjenejaquemavʉ mʉjare mʉjemarepacore, mʉje Jʉ̃menijicʉi d̶aicõjeiyede jápiaiyʉbe boje. Ʉbenita mamarʉmʉmata nópe ãmenejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aru yʉ́capũravʉ coyʉyʉbu mʉjare: Ácʉ põecʉ jímarepacore ãmeina d̶abecoreca jarʉvarĩburu yóboi pʉrʉbʉoyʉ baru apecoque, ãmeina d̶aibi ṍre ʉ̃i mamarʉmʉcacore jarʉvarĩ, arejame Jesús. Nópe ayʉ, “Nomi jarʉvainore ʉbevʉ yʉ”, aiyʉcʉ barejaquémavʉ Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Que ayʉre, ñʉja ʉ̃i bueimara arejacarã ʉ̃́re: —Nópe mi coyʉiyepe baru, meamequiyebu pʉrʉbʉoiye majare, arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ʉbenita ñʉjare yópe arĩ, coyʉrejame Jesús: —Caivʉ põeva cũinácʉva cʉrivʉ majibema. Quénora na quévʉra Jʉ̃menijicʉi torojʉre d̶aimara cʉrivʉ cũinácʉva coapa majima na. ");
INSERT INTO cubNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Apevʉ põeva nomicʉrĩ, ʉ̃mʉcʉrĩ máre, bʉojabema, ne nópe põeteiye báque boje. Que baru pʉrʉbʉobema na. Aru apevʉ põeva ne baju buraicõjeiye boje, nomicʉrĩ bʉojabema na. Que baru pʉrʉbʉobema na. Aru apevʉ põeva ne baju burabevʉvacari, buraivʉ bácavʉpe paivʉ ted̶ama na, ne memecarãjiye boje Jʉ̃menijicʉre cainʉmʉa ʉ̃i jaboteinore. Que baru na máre pʉrʉbʉobema, ne baju nópe d̶aiyʉe boje. Ácʉ põecʉ Jʉ̃menijicʉre torojʉre d̶aimʉ cʉcʉ cũinácʉva, que d̶ajacʉrĩ ʉ̃, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Põeva davare cuivʉ barejáima némarare Jesús yebai, ʉ̃i tʉoquiyepe aivʉ náre ʉ̃i pʉrʉáque, ʉ̃i jẽniaiyede Jʉ̃menijicʉque náre boje. Que teni ñʉja ʉ̃i bueimara davaicõjemenidurejacarã némarare. ");
INSERT INTO cubNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ʉbenita Jesús arejame: —Ina jʉed̶ova dajarãri ji yebai. Jʉ̃menijicʉ jabotecʉyʉme põevare nápe paivʉre. Que baru, “Davabejarã jʉed̶ovare”, abejarã náre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aru náre coapa tʉorĩ ʉ̃i pʉrʉáque, jẽniarejame Jʉ̃menijicʉque náre boje. Que teniburu yóboi, nʉrejacarã ñʉja, Jesújã. ");
INSERT INTO cubNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cũinácʉ bojʉyo, Jesús yebai nʉri, jẽniari jã́rejame: —Mʉ, bueipõecʉ meacʉ, ¿aipe d̶aiye me jaʉri yʉre, cʉvacʉyʉ jãravʉ cũiméjãravʉ baquinóre cavarõ mearo Jʉ̃menijicʉi cʉrõi? arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús arejame ʉ̃́re: —¿Aipe teni jẽniari jã́ñʉrʉ mʉ yʉre d̶aiye ména? Cũinácʉrabe meacʉ baju. Jʉ̃menijicʉvacaribe. Cʉvaiyʉcʉ baru jãravʉ cũiméjãravʉ baquinóre, d̶ajacʉ yópe Jʉ̃menijicʉi d̶aicõjeiyepe, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ád̶eba d̶aicõjeiye? jẽniari jã́rejame. Aru Jesús arejame: —Põevare boarĩ́ jarʉvabejacʉ. Cʉvabejacʉ apecore mimarepacore jarʉvarĩ. Ñavamejacʉ apecʉ ʉ̃i cʉvaede. Borod̶abejacʉ apecʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Jʉ ajacʉ mipacʉre aru mipacore máre. Aru mícʉre, mi bajure jecʉépedeca, ʉ̃́re máre jecʉjacʉ mʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Que ayʉre, ñai bojʉyo arejame: —D̶aivʉ caiye iye mi coyʉiyede. ¿Ã́roma yʉre jaʉrõ cãreja? arejame. ");
INSERT INTO cubNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús ʉ̃́re arejame: —Jaʉbecʉva cʉiyʉcʉ baru Jʉ̃menijicʉi jã́inore, nʉjacʉ aru jíni bojed̶ajacʉ mi cʉvede. Aru mi ĩquiyede jíjacʉ ina cõmaje ãrojarivʉre. Que teni cʉvacʉyʉmu mʉ mi boje méne cavarõ mearo Jʉ̃menijicʉi cʉrõi. Aru dajacʉ yʉ́que, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ʉbenita iyede jápiarĩ, ʉrarõreca chĩorejame, dajocaiyʉbecʉ ʉ̃i ʉre cʉvede. ");
INSERT INTO cubNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Que baru Jesús arejame ñʉja ʉ̃i bueimarare: —Jãve coyʉyʉbu mʉjare: Ina põeva cʉve cʉvarivʉre pare maiyójavʉ ne jʉ aiye Jʉ̃menijicʉre, ʉ̃i mead̶aquiyepe aivʉ náre aru ne ecorãjiyepe aivʉ ʉ̃i jaboteinore, cavarõ mearo ʉ̃i cʉrõre. ");
INSERT INTO cubNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Bedióva cojedeca coyʉyʉbu mʉjare: Cũinácʉ ãimacʉ ʉracʉ, camello ãmicʉcʉ, ʉ̃i ecoru aviyo cobei, maiyójajebu ʉ̃́re. Aru pʉeno maiyójavʉ cʉve cʉvacʉre ʉ̃i ecoquino Jʉ̃menijicʉi jaboteinore, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Que ayʉre jápiaivʉ ñʉja, cuecumarejacarã pare. Aru arejacarã: —¿Ñame bʉojarĩ ecorãjidica Jʉ̃menijicʉi jaboteinore, cʉvarãjivʉ jãravʉ cũiméjãravʉ baquinóre? jẽniari jã́rejacarã Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ʉ̃́capũravʉ ñʉjare jã́ri, arejame: —Põeva ne d̶arĩ majibeno maiyójabevʉ Jʉ̃menijicʉre. Ʉ̃ cũinácʉra bʉojarĩ mead̶ayʉbe põevare, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Aru Pedro arejame: —Dajocacarã ñʉja caiye ñʉje cʉvaede, ñʉje daiye boje mʉ́que. ¿Yéde earãjidica ñʉja? arejame Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aru ñʉjare arejame Jesús: —Jãve coyʉyʉbu mʉjare: Mamajãravʉ daquijãravʉ baquinó yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, dobacʉyʉmu jabocʉi dobarõ mearoi, jabotecʉyʉ põevare. Aru mʉja máre, daivʉ bácavʉ yʉ́que, dobarãjaramu doce painoa jabovai dobarõa mearoa coapa, coyʉrãjivʉ ina doce paiyajuboacavʉ Israecavʉre méne o ãmene ne d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ácʉ põecʉ dajocayʉ baru ʉ̃i cʉ̃ramine, o jíbʉrãre, ĩmarare, jípacʉre, jípacore, mamarare, o ʉ̃i joborõre máre ji ãmiá boje, ʉ̃i daiye boje yʉ́que, memecacʉyʉ yʉre, eacʉyʉme pʉeno baju mearo bajure. Aru cʉvacʉyʉme jãravʉ cũiméjãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ʉbenita dinʉmʉ maquinóre apevʉ, jaboteivʉ bácavʉ ijãravʉre, jabotebenajarama na Jʉ̃menijicʉi jabotequiyede. Aru apevʉ, mʉjapedeca, jabotebevʉ bácavʉ ijãravʉre, jabotenajarama na Jʉ̃menijicʉi jabotequiyede, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús, yópe arĩ, buedejame: —Jʉ̃menijicʉi jaboteinomu yópe jio upacʉi memeipõevare vorĩ, earĩ bojed̶aiyepe náre ne memeiyede. Javejĩnara, seis baji, ñai jio upacʉ tãibʉi vocʉnʉquemavʉ memeipõevare, ne jẽnajiyepe ayʉ ʉ́yaiboare ʉ̃i jioi. ");
INSERT INTO cubNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Náre earĩ, “Cũinátʉrava tãutʉratʉrava, cũinájãravʉ memeiye bojed̶aitʉravare jíquijivʉ mʉjare coapa”, aquemavʉ ʉ̃. Aru ʉ̃i nópe aiyede, jʉ aquemavʉ na coapa. Ne jʉ arĩburu yóboi, ñai jio upacʉ náre jaroquemavʉ jioi. ");
INSERT INTO cubNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yóbecʉriora vainíburu yóboi, nueve baji, bedióva tãibʉi nʉquemavʉ ñai jio upacʉ. Noi jã́quemavʉ apevʉ memeipõevare, ne memeino cʉvabevʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aru náre máre, “Memenanʉjara mʉja ji jioi. Aru bojed̶acʉyʉmu mʉjare me, yópe jaʉépe”, aquemavʉ ʉ̃. Que baru memenanʉquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","No yóboi, jãravʉ corica baji, aru no yóboi tres baji máre, nopedeca d̶aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Bedióva cojedeca, cinco baji, cũináora ne memeiora jaʉéde cãreja, nʉquemavʉ ñai jio upacʉ tãibʉi. Noi jã́quemavʉ apevʉ memeipõevare, ne memeino cʉvabevʉre. Náre jẽniari jã́quemavʉ, “¿Aipe teni cʉrivʉrʉ̃ mʉja yui caijãravʉ mememevʉva?” aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ʉ̃́re aquemavʉ na, “Põecʉ cʉbebi memeicõjeñʉ ñʉjare”, aquemavʉ. Náre máre “Memenanʉjara ji jioi”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Aviá ʉ̃i doiyede, ñai jio upacʉ yópe arĩ, coyʉquemavʉ ʉ̃i cʉ̃ramine corecaipõecʉre: “Ina memeipõevare órejarĩ bojed̶ajacʉ náre. Ina memeni bʉivʉ bácavʉi yóbocavʉre bojed̶ajacʉ mamarʉmʉ. Aru no yóboi ina mamarʉmʉ memeni bʉivʉ bácavʉre bojed̶ajacʉ mʉ”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ina cũináora memeivʉ bácavʉ ne daiyede, cũinátʉrava tãutʉratʉrava, cũinájãravʉ memeiye bojed̶aitʉravare jacopʉquemavʉ na coapa. ");
INSERT INTO cubNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Diede jã́ri, ina javejĩnara memeni bʉivʉ bácavʉ dápiarĩduquemavʉ ne baju jacopʉrãjivʉpe pʉeno baju ne bojed̶aiyede. Ʉbenita na máre quédeca, cũinátʉrava tãutʉratʉrava, cũinájãravʉ memeiye bojed̶aitʉravare jacopʉquemavʉ na coapa. ");
INSERT INTO cubNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ne jacopʉiyede, jaraquemavʉ ñai jio upacʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ʉ̃́re aquemavʉ, “Nácapũravʉ cũináora quénora memema. Aru ñʉjacapũravʉ memevʉ caijãravʉ. Aviá ʉ̃i boiyede ñájivʉ ñʉja. Ʉbenita ñájimevʉ bácavʉreca, náre bojed̶aivʉ mʉ cũinátʉrʉreca mi bojed̶aiyepe ñʉjare, ñájivʉ bácavʉre”, aquemavʉ ina javejĩnara memeni bʉivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ʉbenita ñai jio upacʉ aquemavʉ cũinácʉ nácacʉre, “Pacomá, mʉre ãmeno d̶abevʉ yʉ. Mʉ́capũravʉ jʉ avʉ yʉre, ‘Cũinájãravʉ memeiye bojed̶aitʉravare jíquijivʉ mʉre’, ji aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Que baru ĩjacʉ iye mi bojede aru nʉjacʉ mʉ. Cũinátʉrʉ iye ji jíyepe mʉre, jíyʉvʉ yʉ ñai cũináora memecayʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Yʉre jícõjemeniduyʉrʉ̃ ji cʉvaequede yópe ji ʉrõpe? Ãmeina jã́mejacʉ yʉre, ji cad̶atequiyepe ayʉ põevare, ji mearo d̶aiye boje”, aquemavʉ ñai jio upacʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Põeva ne jã́ri dápiabede yópe maje jabocʉ Jʉ̃menijicʉi jã́ri dápiaiyepe arĩ coyʉrejame Jesús: —Apevʉ jabotebevʉ bácavʉ ijãravʉre jabotenajarama na Jʉ̃menijicʉi jabotequiyede. Aru apevʉ jaboteivʉ bácavʉ ijãravʉre jabotebenajarama na Jʉ̃menijicʉi jabotequiyede, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Mái nʉri, cuivʉ barejacárã Jerusalén ãmicʉriĩmaroi. Ñʉje nʉiyede, ñʉja ʉ̃i bueimarare nʉvarejame apevʉre jocarĩ. Aru yópe arĩ, coyʉrejame Jesús: ");
INSERT INTO cubNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalẽ́i nʉivʉbu. Nore cʉrĩ, yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, ji maucʉ jẽni jíquijibi sacerdotevare jaboteipõevare aru Jʉ̃menijicʉi yávaiye báquede bueipõevare máre. Ina põeva arãjivʉbu: “¡Boarĩ́ jarʉvaicõjejara ʉ̃́re! ¡Yaijácʉrĩ!” ");
INSERT INTO cubNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Que arĩ, jínajivʉbu yʉre ina judíova ãmevʉre. Que teni ina põeva yʉrinajivʉbu yʉre. Jara popenajivʉbu yʉre. Aru yʉre pẽvari jocʉcʉjaravena, boarĩ́ jarʉvarãjivʉbu. Ʉbenita yóbecʉrijãravʉa yóboi, jipacʉ, Jʉ̃menijicʉ, nacovacʉyʉme yʉre yainore jarʉvarĩ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","No yóboi Zebedeoi márai paco nʉrejacod̶a Jesús yebai mamaraque, Santiago aru Jũaque máre. Ʉ̃i jipocai ñʉatutarejacod̶a, õi jẽniaiyʉe boje apejĩene ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Aru Jesús jẽniari jã́rejamed̶a ṍre: —¿Yéde d̶acaji mʉre? arejamed̶a. Ʉ̃́re arejacod̶a: —Dobaicõjejacʉ ina jímara pʉcarãre mi yebai, cũinácʉre meapũravʉi aru apecʉre cãcopũravʉi, mi jabotequinʉmʉ maquinóre, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ʉbenita Jesúcapũravʉ arejamed̶a: —Mi jẽniaiyede coreóvabevʉ mʉ. Põecʉ dobaiyʉcʉ baru yʉ́que ji jabotequinʉmʉ maquinóre, mamarʉmʉ ñájiye jaʉvʉ ʉ̃́re yʉ́que. ¿Ũcuri bʉojarãjidica mʉja ji ũcuinore? arejamed̶a náre Jesús. Aru jʉ arejaimad̶a ʉ̃́re: —Bʉojaivʉbu ñʉja, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aru Jesús arejamed̶a náre: —Ji ũcuinore ũcurajivʉbu mʉja. Ji que aiyede, yópe ayʉbu: Ji ñájiyepedeca ñájinajivʉbu mʉja. Ʉbenita yʉ́vacari beobevʉ náre, dobarãjivʉre ji meapũravʉi aru ji cãcopũravʉi máre. Quénora dobarãjarama nore ina jipacʉi beoimara mácavʉ, javeta ʉ̃i mead̶aimara mácavʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","No yóboi, jápiarejacarã ne borore apevʉ ñʉja caipʉcapʉrʉape paivʉ Jesúi bueimara. Que baru jararejacarã inare. ");
INSERT INTO cubNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Dinʉmʉ Jesús órejarejame ñʉjare ʉ̃i yebai. Aru arejame ñʉjare: —Mʉja majivʉ ina jaboteivʉre judíova ãmevʉre ne d̶aiyede. Parʉéque cõjeivʉbu ina ne jaborõcavʉre, ne d̶acarãjiyepe aivʉ náre ne ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ʉbenita nápe d̶abejarã mʉja. Ñai mʉjacacʉ parʉcʉ baiyʉcʉ baru, memecajacʉrĩ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Aru nopedeca ñai mʉjacacʉ jabocʉ baiyʉcʉ baru, yebacatejacʉrĩ caivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nopedeca Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, yʉ, dabedejacacʉ, põeva ne memecarãjiyepe ayʉ yʉre. Quénora darejacacʉ yʉ, memecacʉyʉ apevʉre aru boarĩ́ jarʉvaicõjecʉyʉ ji bajure, mead̶acʉyʉ obedivʉ põevare, ji yaiquíyede náre boje, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó ãmicʉriĩmarore etarejacarã ñʉja, Jesújã. Obedivʉ põeva darejaima ñʉje yóboi. ");
INSERT INTO cubNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aru pʉcarã ʉ̃mʉva, jã́ri eabevʉ, ma ẽcarʉi dobarejaima. Põeva “Jesús Nazarecacʉbe ʉ̃”, aivʉre jápiaivʉ, cod̶oboborejaima na, jã́ri eabevʉ: —Mʉ, David bácʉi pãramecʉ, Jʉ̃menijicʉi daroimʉ mácʉ, ñʉje jabocʉ bacʉyʉ́, cõmaje ãroje jã́jacʉ ñʉjare, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ina obedivʉ põeva náre arĩdurejaima: —Bi ajarã mʉja, arĩdurejaima. Ʉbenita pʉeno baju cod̶oboborejaima cojedeca: —Mʉ, ñʉje jabocʉ, David bácʉi pãramecʉ, cõmaje ãroje jã́jacʉ ñʉjare, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Que teni ʉ̃́re cod̶oboboivʉre jápiayʉ Jesús, dajocarejame. Aru apevʉre cutuicõjenejame ina pʉcarã jã́ri eabevʉre ʉ̃i yebai. Eaivʉre, Jesús jẽniari jã́rejame náre: —¿Aipe d̶acaji yʉ mʉjare? arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ʉ̃́re arejaima na: —Mʉ, ñʉje jabocʉ, jã́ri eabevʉbu ñʉja. Ʉrarõ jã́iyʉrivʉbu ñʉja, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús cõmaje ãroje jã́ñʉ, ne yacorʉare tʉorejame ʉ̃. Aru cũiná jã́rejaima na, jã́ri eabevʉ bácavʉ. Que teni Jesúre yóvarĩ nʉrejaima na máre. ");
INSERT INTO cubNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén ãmicʉriĩmaro joabejĩnoi cʉrĩ, Betfajé ãmicʉriĩmajino baji, no cʉ̃racũ Olivocũ ãmicʉricũ ẽmeino baji, earejacarã ñʉja, Jesújã. Nore earĩ, pʉcarã ñʉja ʉ̃i bueimaracavʉre yópe arĩ, jarorejame Jesús: ");
INSERT INTO cubNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—No cõchinoi cʉriĩmajinoi nʉjara mʉja. Cũiná earãjaramu mʉja põevare ũmaiãimacʉre, burra ãmicʉco, mamacʉque, nácacʉi bʉoimarare. Náre bʉoimeare jod̶eni, davajarã yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Aru, “¿Aipe teni ina ãimarare náre bʉoimeare jod̶eni, náre nʉvaivʉrʉ̃ mʉja?” ne aruta, yópe ajarã: “Ñʉjare ĩ́cõjeni darobi maje jabocʉ. Ʉ̃́re ũmacayʉ ãimacʉ jaʉbi ʉ̃. Carijĩeneca mʉjare jacopaiyovacʉyʉme cojedeca”, ajarã, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Caiye iye nópe vaidéjavʉ̃ cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca cũinácʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: ");
INSERT INTO cubNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Coyʉjacʉ ina Jerusalén ãmicʉriĩmarocavʉre. Jã́jara. Mʉje jabocʉ bacʉyʉ́ mʉjare dacʉyʉme. “¿Meacʉ bárica yʉ?” abecʉbe. Burrore tubarĩ dacʉyʉme. Burro bojʉyovacari bacʉyʉ́me ʉ̃i tubamʉ macʉyʉ́, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesúi daroimara nʉrejaima. Aru d̶arejaimad̶a yópe ʉ̃i aiye báquepedeca náre. ");
INSERT INTO cubNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Davacarejaima Jesúre ico burrare mamacʉque. Aru ñʉje doicajea pʉenocacajeare burrare aru mamacʉre máre tʉorejacarã. Mamacʉre tubarejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dinʉmʉma ina obedivʉ põeva, ñʉjaque cʉrivʉ, ne pʉenocacajeare jũarejaima mára. Aru apevʉ jocʉcʉ cavabʉa yoca cʉricavabʉare burarĩ, jũarejaima mára, Jesúre mead̶aiyʉrivʉ, ne pued̶arĩ jacoyʉrãjiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ʉ̃́re jipocateivʉ aru ʉ̃i yóbocavʉ máre cod̶oboborejaima na: —David bácʉi pãramecʉ, maje jabocʉ bacʉyʉ́re torojʉe bajad̶éni. Jʉ̃menijicʉ mearo d̶acaimʉme ʉ̃, Jʉ̃menijicʉi daroimʉ mácʉ. Cari jabocʉ bacʉyʉ́re ména borotenajarevʉ, cod̶oboborĩ arejacarã ñʉja caivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús ʉ̃i eaiyede Jerusalén ãmicʉriĩmaroi, caivʉ nócavʉ etarĩ, jã́ri, jẽniari jã́rejaima na, “¿Ñamema ñai?” ");
INSERT INTO cubNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aru ina põeva ñʉjare yóvaivʉ arejaima náre: —Ʉ̃́tame ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ, Jesús Nazarecacʉ, Galileacarõcacʉ, arejaima ina põeva. ");
INSERT INTO cubNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús edarĩ Jʉ̃menijicʉi cʉ̃rami yebai, diñami tãibʉ ʉratãibʉi ecorejame ʉ̃. Aru nore diñami cʉrivʉ bojed̶aipõevare jarʉvarejame Jesús. Tãutʉra oatʉvaipõeva ne jã́d̶ovaivare moari najuárejame ʉ̃. Aru jurevare bojed̶aipõeva ne dobarõare máre moari najuárejame. ");
INSERT INTO cubNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Náre yópe arejame Jesús: —Yópe arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃i yávaiyede: “Ji cʉ̃rami caivʉ põeva ne yʉre, Jʉ̃menijicʉre, coyʉiñamimu”, arĩ toivaicõjenejaquemavʉ. Ʉbenita diñamine tatorĩ ĩ́vʉ ne dupiñamipe d̶aquemavʉ mʉja, mʉje pʉeno ʉrarõ tãutʉra ĩ́ye boje põevare jocarĩ, ne bojed̶aiyede mʉje cʉvaede, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jã́ri eabevʉ darĩ, aru cuiye majibevʉ máre daivʉ barejáima ʉ̃i yebai no Jʉ̃menijicʉi cʉ̃rami. Náre coapa mead̶arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Apevʉ fariseova aru Jʉ̃menijicʉi yávaiye báquede bueipõeva caiye iye põeva ne d̶arĩ majibede Jesús ʉ̃i d̶aiyede jã́rejaima. Aru ina jʉed̶ova noi cʉrivʉ, “David bácʉi pãramecʉ, maje jabocʉ bacʉyʉ́re torojʉe bajad̶éni”, ne arĩ cod̶oboboiyede jápiarejaima ina fariseovajã. Que baru jorojĩnejaima ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aru arĩdurejaima: —¿Jápiabecʉrʉ̃ mʉ ne aiyede? arĩdurejaima. Ʉbenita Jesús arejame náre: —Jápiaivʉ yʉ. ¿Ãrʉmetenarʉ mʉja? Jʉ̃menijicʉ ʉ̃i yávaiye báquede toivaicõjenejaquemavʉ cũinácʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre yópe arĩ yʉrã: Mʉ, ñʉje jabocʉ, jʉed̶ovare aru jʉed̶ojĩnare máre mearore jícõjeivʉ mʉre, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Que arĩburu yóboi, náre dajocarĩ etarejacarã ñʉja, Jesújã, diĩmarore jocarĩ. Cãranʉrejacarã Betania ãmicʉriĩmajinoi. ");
INSERT INTO cubNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cõmiáijãravʉ javejĩnara copainʉrejacarã Jerusalén ãmicʉriĩmaroita. Aru ãvʉé ijidejavʉ̃ya Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Que baru ʉ̃i jã́iyede cũinácʉ jocʉcʉ higuera ãmicʉricʉre ma ẽcarʉi, jẽidʉare vocʉnʉridurejame dicʉ yebai. Ʉbenita yoca matʉiyeda earejame. Aru arejame dicʉre: —Cainʉmʉa jẽmejad̶eni mi jẽidʉa cojedeca, arejame ʉ̃. Aru cũiná dicʉ yaidéjavʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ñʉja ʉ̃i bueimara diede jã́ri, cuecumarejacarã. Aru arejacarã: —¿Aipe teni cũiná yaidí dicʉ higueracʉ? arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aru Jesús, yópe arĩ, coyʉrejame ñʉjare: —Jãve coyʉyʉbu mʉjare: Mʉja me jʉ aivʉ baru Jʉ̃menijicʉre, aru “Jʉ̃menijicʉ iye d̶aiyede majibebi” arĩ dápiabevʉ baru, mʉja máre d̶arĩ bʉojarãjaramu yópe ji d̶aiye báquepe dicʉ higueracʉre. Aru pʉeno baju d̶arĩ bʉojarãjaramu mʉja. Icũ cʉ̃racũre “Nʉjacũ yore jocarĩ pʉ jia ʉrad̶aita, cocʉnʉjacũ” mʉje aru, nópe d̶aquiyebu dicũ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Caiye iye mʉje Jʉ̃menijicʉre jẽniaiyede, “Jãve Jʉ̃menijicʉ jícʉyʉme yʉre” arĩ dápiaru, Jʉ̃menijicʉ jícʉyʉme mʉjare mʉje ʉede, arĩ buedejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Diede coyʉyʉ bácʉ, Jesús Jʉ̃menijicʉi cʉ̃rami ecorejame cojedeca. Noi põevare bueyʉre, sacerdotevare jaboteipõeva aru judíova bʉcʉva máre ʉ̃i yebai nʉrejaima. Aru jẽniari jã́rejaima ʉ̃́re: —¿Ye parʉéque d̶ayʉrʉ̃ mʉ iye mi d̶aiyede? ¿Ñame jídi mʉre iye parʉéde mi nópe d̶aiyede? arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús arejame náre: —Yʉ máre jẽniari jã́quijivʉ mʉjare cũináro jẽniari jã́inore. Yʉre coyʉru, yʉ máre coyʉquijivʉ mʉjare ji parʉéque ji d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Juan Bautista bácʉ jã́d̶ovaquemari põevare Jʉ̃menijicʉ ʉ̃i parʉéque o põeva ne parʉéque? Coyʉjarã yʉre, arejame náre Jesús. Ʉ̃i que aiyede, ne bajumia boroteivʉ arejaimad̶a yópe: —Maje aru “Jʉ̃menijicʉque”, ʉ̃ aquijibi “¿Aipe teni jʉ abetecarãrʉ ʉ̃́re?” ");
INSERT INTO cubNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ʉbenita maje aru “põevaque”, jidʉé jaʉvʉ majare. Ina obedivʉ põeva coreóvad̶ama Juan Bautista bácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉre. Que baru nácapũravʉ ãmed̶ajebu majare, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Que baru arejaima Jesúre: —Majibevʉ ñʉja, arejaima. Dinʉmʉre Jesús arejame náre: —Yʉ máre coyʉbevʉ mʉjare ñamei parʉéque ji d̶aiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Bedióva yópe arĩ, buedejame Jesús: —¿Aipe dápiaivʉrʉ̃ mʉja iye ji coyʉquiyede mʉjare? Cũinácʉ ʉ̃mʉ pʉcarã mamarare cʉvacʉ yópe aquemavʉ cũinácʉre: “Mʉ, bʉcʉ, memecʉnʉjacʉ ʉ́yaimu jioi cari jãravʉ”, aquemavʉ jípacʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ʉbenita ʉ̃́capũravʉ “Nʉiyʉbevʉ”, aquemavʉ jípacʉre. Ʉbenita nópe arĩburu yóboi, chĩori dápiaquemavʉ ʉ̃i jʉ abe báquede jípacʉre. Aru jioi nʉquemavʉ ʉ̃, mamacʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Népacʉ ñai mamacʉre ʉ̃i coyʉrĩburu yóboi, apecʉ mamacʉre quédeca arĩduquemavʉ. Aru ñai mamacʉcapũravʉ “Báyʉ, memecʉnʉñʉmu yʉ”, jʉ arĩduyʉvacari, ʉbenita ye nʉmetequemavʉ ʉ̃, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Náre jẽniari jã́rejame Jesús: —¿Ácʉba ina pʉcarã mamaracacʉ jípacʉi ʉrõpe d̶ayʉ bácʉ? arejame Jesús. Arejaima Jesúre: —Ʉ̃i mamarʉmʉ jẽniaimʉ mácʉ ʉ̃i ʉrõpe d̶aquemavʉ, arejaima. Aru Jesús arejame náre: —Jãve coyʉyʉbu mʉjare: Ina jabovare tãutʉra ĩcaipõeva aru ina nomiva ãmena ne bajure bojed̶aivʉ ecorãjarama Jʉ̃menijicʉi jaboteinore mʉje jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Quédeca Juan Bautista bácʉ buecʉdame mʉjare aipe d̶arĩ Jʉ̃menijicʉ jã́ñʉre põevare boropatebevʉpe. Ʉbenita mʉjacapũravʉ ʉ̃ mácʉre jʉ abetequemavʉ. Quénora ina jabovare tãutʉra ĩcaipõeva aru ina nomiva ãmena ne bajure bojed̶aivʉ ʉ̃ mácʉre jʉ aquemavʉ, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús, yópe arĩ, buede nʉrejame náre: —Apeno jã́ri dápiarĩ mʉje d̶arãjiyepe aino ji coyʉquiyede jápiajarã mʉja. Cũinácʉ cʉ̃rami upacʉ doaicõjequemavʉ jiore ʉ́yaimuque. Doarĩ bʉojarĩ, d̶aicõjequemavʉ biaidore jio tʉrʉvai. Aru ũicõjequemavʉ cobede ʉ́yai pipoicobede. Aru d̶aicõjequemavʉ ʉ̃mʉjʉriñami cʉ̃ramine, jiore coreipõecʉ ʉ̃i jã́quiñamine máre. Caiye iyede mead̶arĩ bʉojarĩ, vorĩ earĩ jiore memeipõevare, epequemavʉ náre, ne memecarãjiyepe ayʉ ʉ̃́re. Ina memecaipõeva ĩnajivʉ batequémavʉ apeboa ʉ́yaiboare, ne memeiye boje. Aru nʉquemavʉ ñai jio upacʉ apeno joborõi. ");
INSERT INTO cubNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ʉ́yai jẽijãravʉ yóboi, ñai jio upacʉ jarorĩduquemavʉ apevʉ ʉ̃i yebacavʉre memecaipõeva yebai, ne ĩnajiyepe ayʉ apeboa ʉ́yaiboare, ñai jio upacʉ jiede. ");
INSERT INTO cubNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ʉbenita ina memecaipõeva ina yebacavʉ eaivʉre jẽni, cũinácʉre jara popequemavʉ, aru apecʉre boarĩ́ jarʉvaquemavʉ, aru apecʉre cʉ̃raboaque dʉvarĩ boarĩ́ jarʉvaquemavʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ñai jio upacʉ jarorĩduquemavʉ apevʉ yebacavʉre. Ʉbenita náre quédeca d̶aquemavʉ ina memecaipõeva. ");
INSERT INTO cubNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’No yóboi, ñai jio upacʉ jarorĩduquemavʉ mamacʉre memecaipõeva yebai. “Jímacʉre jã́ivʉ pued̶arãjichʉma na”, arĩ dápiarĩ, que d̶arĩduquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ʉbenita ina memecaipõeva jã́ivʉ ñai jio upacʉi mácʉre, aquemavʉ ne bajumia, “Ñai ñʉje jabocʉ bacʉyʉ́me. Jípacʉ ʉ̃i yainíburu yóboi, cʉvacʉyʉme caiye ʉ̃i cʉvaede. Jã́rica, boarĩ́ jarʉvarãjarevʉ ʉ̃́re, maja cʉvaburĩ caiye ʉ̃i cʉvaede”, aquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Que arĩ, ʉ̃́re jẽni jaetovaquemavʉ jiore jocarĩ. Aru boarĩ́ jarʉvaquemavʉ ʉ̃́re, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Na ʉ̃i coyʉiyede jápiaivʉre jẽniari jã́rejame Jesús: —¿Ñai jio upacʉ copaini dayʉ, aipe d̶aquidi ina memecaipõevare? arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ʉ̃́re jápiaivʉ arejaima: —Ina ãmenare pare ñájine d̶arĩ boarĩ́ jarʉvaicõjecʉyʉme ʉ̃. Aru epecʉyʉme apevʉ memecaipõevare noi, ʉ̃i jioi, ʉ̃́re jínajivʉre ʉ̃i jẽidʉare jẽijãravʉ eaiyeta, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús arejame náre: —¿Ãrʉmetenarʉ mʉja iye Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báquede? Yópe toivarejaquemavʉ yʉrã, Cristo ji borore: Iva cʉ̃ravare cʉ̃ramine d̶aipõeva ʉbeni jarʉvaquemavʉ. Caride iva cʉ̃rava caiva apeva pʉeno parʉrivabu. Nópe d̶aino mácarõre d̶aquemavʉ Jʉ̃menijicʉ. Que baru pare mearotamu majare, maje dápiaru, arĩ toivarejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Que baru coyʉyʉbu mʉjare: Mʉja judíova mʉje d̶abe boje mearore yópe Jʉ̃menijicʉi ʉrõpe ʉ̃i jaboteimarare d̶aiye jaʉépe, apevʉ põeva, judíova ãmevʉ, mearore d̶aivʉ yópe Jʉ̃menijicʉi ʉrõpe, ʉ̃i jaboteimara marajárama na mʉje pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ácʉ põecʉ tʉyʉ baru divarã, tʉrĩ yavacʉyʉme ʉ̃i bajure. Aru diva tʉiva baru põecʉ pʉenora chĩtoquiyebu ʉ̃́re, arejame náre Jesús. Yópe aiyʉrõtamu no: Põeva “Ãmecʉbe ʉ̃”, arĩdurãjarama Jesúi borore. Ʉbenita meacʉ bajube ʉ̃, Jesús, caivʉ apevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ina sacerdotevare jaboteipõeva aru ina fariseova jápiaivʉ bácavʉ Jesús ʉ̃i jã́ri dápiarĩ ne d̶arãjiyepe aiyede, coreóvarejaimad̶a coyʉyʉre nára, “Mʉja judíova mʉje d̶abe boje mearore yópe Jʉ̃menijicʉi ʉrõpe, judíova ãmevʉ ʉ̃i jaboteimara marajárama mʉje pʉeno” ʉ̃i aiye báque boje. Que baru jẽni nʉvaiyʉrĩdurejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ʉbenita ne jẽiyʉrĩduiyede ʉ̃́re, obedivʉ põeva “Jesúbe Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ” arĩ dápiaivʉre jidʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Bedióva cojedeca Jesús, yópe arĩ, buedejame náre apeno jã́ri dápiarĩ ne d̶arãjiyepe ainoque: ");
INSERT INTO cubNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Jʉ̃menijicʉi jaboteinomu yópe cũinácʉ jabocʉi mácʉ pʉrʉbʉoyʉre torojʉve tede d̶ainope. ");
INSERT INTO cubNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ñai torojʉve teino upacʉ jarorĩ, “Nʉjara” aicõjeniduquemavʉ ʉ̃i yebacavʉre ʉ̃i cutuimarare. Ʉbenita ina cutuimaracapũravʉ nʉiyʉbetequemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Bedióva cojedeca jarorĩ, aicõjeniduquemavʉ apevʉ ʉ̃i yebacavʉre yópe: “Coyʉjarã ina ji cutuimarare yópe: ‘Ji torojʉve teinore mead̶aivʉ yʉ. Boaicõjeivʉ oteivecʉva ʉrarãre aru ina mamara jiacʉrivʉre máre. Caiyede mead̶aivʉ yʉ. Que baru ãranʉjara cari’, ajarã ji cutuimarare”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ʉbenita ina cutuimara ñai jabocʉre ãmeina jã́ri, yʉrini, nʉmetequemavʉ ʉ̃i torojʉve teinore. Cũinácʉ memecʉnʉquemavʉ ʉ̃i jioi. Apecʉ memecʉnʉquemavʉ ʉ̃i bojed̶aitucubʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aru apevʉ ina yebacavʉre jẽni, cʉyojarõ d̶arĩ, boarĩ́ jarʉvaquemavʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Diede jápiarĩ, ñai jabocʉ jaraquemavʉ. Churaravare jaroquemavʉ, ne boarĩ́ jarʉvarãjiyepe ayʉ ina boarĩ́ jarʉvaivʉ bácavʉre ʉ̃i yebacavʉre aru ne juarãjiyepe ayʉ ne ĩmarore. ");
INSERT INTO cubNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","’Dinʉmʉre ñai jabocʉ aquemavʉ apevʉ ʉ̃i yebacavʉre, “Jímacʉ ʉ̃i pʉrʉbʉoiye torojʉve teino mead̶arĩ bʉojainomu. Ʉbenita ina ji cutuimara mácavʉ ãmena bajure daiye jaʉbetedebu. ");
INSERT INTO cubNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Que baru ma ʉramai nʉjara mʉja. Nore caivʉ mʉje eaimarare cutujarã, ne darãjiyepe aivʉ ji torojʉve teinoi”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ʉ̃i que arĩburu yóboi, ina yebacavʉ mái nʉri cójijovaquemavʉ caivʉ ne eaimarare, mearare aru ãmenare máre, ne torojʉve teitucubʉ buiquíyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ʉbenita ñai jabocʉ jã́cʉnʉri ina ʉ̃i cutuimarare no torojʉve teitucubʉi, jã́quemavʉ cũinácʉ põecʉre pʉrʉbʉoino doiyede dobecʉva. ");
INSERT INTO cubNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Que baru ʉ̃́re jẽniari jã́quemavʉ, “Pacomá, ¿aipe teni ecoyʉ bʉojacʉrʉ̃ yore pʉrʉbʉoino doiyede dobecʉva?” aquemavʉ. Ʉbenita ñai cutuimʉcapũravʉ bi aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Dinʉmʉre ñai jabocʉ ʉ̃́re cad̶ateipõevare yópe aquemavʉ, “Ʉ̃i pʉrʉáre, ʉ̃i cʉbobare máre bʉorĩ, jarʉvajarã ʉ̃́re joai, ñeminoi, ʉ̃i jʉ abe boje yʉre, ʉ̃i coatequiyepe aivʉ yʉre jarʉvarĩ. Chĩoivʉ orĩ cʉrãjarama põeva nore. Aru jararĩ cõpi cũrajarama na, aquemavʉ ñai jabocʉ”, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesús, yópe arĩ, buede nʉrejame: —Obedivʉ põevatamu ina Jʉ̃menijicʉ ʉ̃i cuturĩduimara. Ʉbenita obebejĩnatamu ina ʉ̃i beoimara, ʉ̃i jaboteimara márajivʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","No yóboi apevʉ fariseova ne bajumia borotedejaimad̶a aipe d̶arĩ ne jʉjovarĩ jacotʉjʉroede Jesúre ʉ̃i coyʉiyequede. ");
INSERT INTO cubNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Apevʉ ne bueimarare apevʉ Herodecavʉque jarorejaimad̶a na. Ʉ̃i yebai edarĩ, ʉ̃́re yópe arejaima, mamad̶aiyʉrivʉ: —Mʉ, bueipõecʉ, mʉre coreóvaivʉbu ñʉja. Nurié yávaivʉ mʉ. Jãveneca bueivʉ mʉ põevare, ne d̶arãjiyepe ayʉ mearore yópe Jʉ̃menijicʉi d̶aicõjeiyepe. Caivʉre cũinácamuara yávaivʉ mʉ. Coyʉbevʉ mʉ põevare yópe ne d̶aiyepe. Quénora jidʉbecʉva coyʉivʉ mʉ náre yópe ne dápiaiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Que baru coyʉjacʉ yéde mi dápiaiyede iye ñʉje jẽniaiyede mʉre caride. ¿Maje jabocʉ César ʉ̃i ĩ́cõjejʉroede, ʉ̃i jaboteiye boje, maje bojed̶aru, mearica die? ¿O bojed̶abejeba maja? arejaima na, ʉ̃́re jʉjovaiyʉrĩduivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ʉbenita ne ʉ̃́re ãmeina d̶ájʉroede majini, yópe arejame Jesús: —Mʉja, jʉjovaivʉ, ¿aipe teni yʉre jʉjovaiyʉrĩdurãrʉ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jã́d̶ovajara yʉre tãutʉratʉravare, arejame Jesús. Que ayʉre, nácacʉ cũinátʉrava tãutʉratʉravare davarejame ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ʉ̃́re ʉ̃i davarĩ jíyede, arejame Jesús: —¿Ñamema ñai, ditʉravare jẽñʉ? ¿Aru ñamei ãmiá cʉritʉravaba ditʉrava? arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Ñai jabocʉ Césai decocʉ aru ʉ̃i ãmiá máre cʉritʉravatamu, arejaima Jesúre. Que aivʉre arejame Jesús: —César jiede ʉ̃́re jacopaiyovajarã mʉja. Jíjarã ʉ̃́re tãutʉra yópe ʉ̃i bojed̶aicõjeiyepe mʉjare. Aru Jʉ̃menijicʉ jiede ʉ̃́re jacopaiyovajarã mʉja. D̶ajarã yópe ʉ̃i ʉrõpe, arejame náre, jẽniari jã́radaivʉre, Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ʉ̃i que aiyede jápiarĩ, pare dápiarĩ cuecumarejaimad̶a ina ʉ̃́re jʉjovaiyʉrĩduivʉ bácavʉ. Que baru ʉ̃́re dajocarĩ etarĩ nʉrejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dijãravʉmareca apevʉ saduceova darejaima Jesús yebai. Saduceo ãmicʉriyajubobu judíovacavʉ ne yajubo cũináyajubo. Caivʉ saduceova “Yainore jarʉvarĩ nacajaiye cʉbevʉ”, ad̶ama na. Jesúre jẽniari jã́rejaima ina saduceova yópe arĩ: ");
INSERT INTO cubNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Mʉ, bueipõecʉ, Jʉ̃menijicʉi cõjeiyede Moisés bácʉ coyʉrejaquemavʉ: “Cũinácʉ némamicʉ yaidú, jʉed̶ocʉvabecʉva, yaiyʉ́ bácʉi yócʉre pʉrʉbʉoiye jaʉvʉ nomiópecoque, jʉed̶ocʉvacʉyʉ. Aru ina jʉed̶ova bárãjivʉ yaiyʉ́ bácʉi ãmiáre cʉvarãjarama na”, coyʉicõjenejaquemavʉ Moisés bácʉre Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Javede cʉ́tequemavʉ siete paivʉ ʉ̃mʉva ñʉjacavʉ. Cũinácʉ ʉ̃mʉi mára matequémavʉ na. Aru némamicʉ pʉrʉbʉoquemavʉ. No yóboi yaiquémavʉ ʉ̃ mácʉ, jʉed̶ocʉvabecʉva. ");
INSERT INTO cubNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Que baru apecʉ, némamicʉ bácʉrã cutuyʉ, pʉrʉbʉoquemavʉ jíbʉcʉ bácʉi márepacoque. Aru jíbʉcʉ bácʉpedeca, yaiquémavʉ ʉ̃ mácʉ máre, jʉed̶ocʉvabecʉva. Aru apecʉ, ʉ̃ mácʉrã cutuyʉ máre, nopedeca, aru caivʉ ina siete paivʉ bácavʉ ṍque pʉrʉbʉorĩ, yaiquémavʉ na mácavʉ caivʉ jʉed̶ocʉvabevʉva. ");
INSERT INTO cubNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Caivʉ ne yóboi, ico nomió máco máre yaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Aru yainore jarʉvarĩ nacajaijãravʉ baquinóre, ñamei márepaco bacod̶óba ico? Ijãravʉi caivʉ ina siete paivʉ cʉvatequemavʉ ṍre, arejaima na Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ʉbenita Jesús arejame ina saduceovare: —Mamateivʉbu mʉja, mʉje majibe boje Jʉ̃menijicʉi yávaiyede. Aru Jʉ̃menijicʉi parʉéde máre majibevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yainore jarʉvarĩ nacajaijãravʉ baquinóre pʉrʉbʉobenajarama. Aru jíbenajarama némaromivare, ne pʉrʉbʉorãjiyepe aivʉ. Quénora ángeleva, ina pʉrʉbʉobevʉ, cavarõ mearo Jʉ̃menijicʉi cʉrõcavʉpe paivʉ, barãjárama ina yainore jarʉvarĩ nacajarajivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Iye yainore jarʉvarĩ nacajaiyede, jápiarĩ eabenarʉ mʉja iye Jʉ̃menijicʉi coyʉiye báquede Moisés bácʉre? ");
INSERT INTO cubNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yʉ́tamu Jʉ̃menijicʉ. Abraham, Isaac, aru Jacob ne mearore jímʉmu yʉ”, arejaquemavʉ Jʉ̃menijicʉ. Que arĩ, yaivʉ bácavʉ ne mearore jímʉ ãmemi Jʉ̃menijicʉ. Quénora apʉrivʉ ne mearore jímʉtame ʉ̃, arĩ coyʉrejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ina obedivʉ põeva Jesús ʉ̃i nópe coyʉiyede jápiaivʉ, pare dápiarĩ cuecumarejaimad̶a, ʉ̃i nópe aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Apevʉ fariseova ne jápiaiyede Jesús vainí tʉyʉ bácʉre ina saduceovare, bi are d̶ayʉ bácʉre náre, cójijidejaima ʉ̃i yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aru cũinácʉ nácacʉ, Jʉ̃menijicʉi d̶aicõjeiyede majicʉ, Jesúre jʉjovarĩ jacotʉiyʉrĩduyʉ jẽniari jã́rejame yópe: ");
INSERT INTO cubNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Mʉ, bueipõecʉ, ¿ã́roma majare Jʉ̃menijicʉi d̶aicõjeino pʉeno parʉrõ cõjeino? arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús arejame ʉ̃́re: —“Ʉjacʉ mi jabocʉ Jʉ̃menijicʉre caino mi ũmedʉque, caino mi ũmeque, aru caino mi majiéque”. ");
INSERT INTO cubNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nótamu Jʉ̃menijicʉi d̶aicõjeino pʉeno parʉrõ, pʉeno mearo máre. ");
INSERT INTO cubNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aru no yóbo cãchijino parʉrõ d̶aicõjeinotamu mamaro cõjeinope paino. “Mi bajure mi jecʉépedeca jecʉjacʉ mícʉre máre”. ");
INSERT INTO cubNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Caiye Jʉ̃menijicʉi d̶aicõjeiye ʉ̃i coyʉiye báquede Moisés bácʉre, aru caiye ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne bueiye báquede máre coyʉiyetamu cũinátʉrʉra iye pʉque d̶aicõjeiyeque. Põevare ʉe jaʉvʉ majepacʉ Jʉ̃menijicʉre aru jecʉé jaʉvʉ apevʉ põevare máre, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ina fariseovacavʉ cójijivʉreca cãreja Jesús yebai, náre yópe arĩ, jẽniari jã́rejame Jesús: ");
INSERT INTO cubNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Aipe dápiaivʉrʉ̃ mʉja ñai Cristore? ¿Ñamei mácʉba ñai? arejame. Ʉ̃́re arejaima: —David bácʉi pãramecʉbe ʉ̃, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Náre arejame Jesús: —Que baru, ¿aipe teni David bácʉvacari Espíritu Santoi parʉéque coyʉicõjeimʉ marejaquémari “mʉ, ji jabocʉ” Cristorã? David bácʉ, yópe arĩ, coyʉrejaquemavʉ Cristorã: ");
INSERT INTO cubNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jʉ̃menijicʉ aquemavʉ ji jabocʉre, “Dobajacʉ ji meapũravʉi, mi cʉvae boje parʉéde yʉpedeca. Aru yʉ epecʉyʉmu mi mauvare mi cʉboba cãchinoi. Que teni mʉre vainí jarʉvare d̶acʉyʉmu yʉ náre, mi jabotequiyepe ayʉ náre”, arĩ toivarejaquemavʉ David bácʉ Cristorã. ");
INSERT INTO cubNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David bácʉvacari Cristoi borore arejaquemavʉ, “Ʉ̃́recabe ji jabocʉ”. Que baru, ¿aipe teni David bácʉi pãramecʉba ʉ̃? arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ñame bʉojarĩ cũiná coyʉbeteima ʉ̃́re. Dijãravʉmata ñame yéde jẽniari jã́menejaima Jesúre bedióva cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","No yóboi Jesús, yópe arĩ, coyʉrejame ina obedivʉ põevare aru ñʉja ʉ̃i bueimarare máre: ");
INSERT INTO cubNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jʉ̃menijicʉi yávaiye báquede bueipõeva aru fariseova bued̶ama mʉjare Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquede Moisés bácʉre. Jʉ̃menijicʉi yávaiye jãvene bued̶ama na. Que baru d̶ajarã mʉja yópe ne bueiyepedeca. ");
INSERT INTO cubNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ʉbenita návacari d̶abenama yópe ne bueiyepe. Que baru d̶abejarã mʉja yópe ne d̶aiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ne baju dápiaiyepe d̶aicõjed̶ama põevare. Ʉbenita yópe Jʉ̃menijicʉi yávaiye báquepe dápiabenama na. Maiyójajebu iye d̶aicõjeiye ne baju dápiaiye báque. Návacari caiye iyede ye d̶abenama na. Aru ne d̶aicõjeimarare ye cad̶atebenama, ne d̶arãjiyepe aivʉ die maiyójae d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Caiye ne d̶aiyede d̶ad̶ama apevʉre jã́icõjenajivʉ, “¿Meara márica na?” ne arĩ dápiarãjiyepe aivʉ. Que baru Jʉ̃menijicʉi yávaiyequede ne toivaino mácarõ yocarã, ne ad̶aino mácarõ quĩ́jitõcua jívʉi bʉod̶ama na. Ditõcuare ne bʉoiyede ne tʉ̃tʉva coapa aru ne ãmuve cãcopũravʉcaãmuve coapa, ʉramea bʉoimeaque bʉod̶ama na, jã́icõjenajivʉ apevʉre. Aru ne cuitótecajea coapa nareicõjed̶ama tʉrʉvacajea ʉracajeare, jã́icõjenajivʉ apevʉre. Que teni apevʉre dápiare d̶aiyʉrĩduyama mearore jívaivʉre Jʉ̃menijicʉre aru jʉ ávaivʉre máre. Ʉbenita nópe dápiajebu põeva náre ʉbenina. ");
INSERT INTO cubNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Torojʉve teinore cʉiyʉma na ñai torojʉve teino upacʉ yebai, apevʉ ne pued̶arãjiyepe aivʉ náre. Judíovai cójijiñamiare ʉma na ne dobae mearoa baji, apevʉ ne jã́rajiyepe aivʉ náre parʉrivʉpe. ");
INSERT INTO cubNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Aru ʉma na põeva pued̶arĩ ne jacoyʉinore tãibʉi aru “mʉ, bueipõecʉ” ne ainore máre náre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Ʉbenita mʉjacapũravʉ “mʉ, bueipõecʉ” aicõjemejara apevʉre mʉja coapa, mʉje dápiaiye boje meara apevʉ pʉeno. Yʉ cũinácʉratamu mʉje bueipõecʉ. Aru cũinátʉrʉbu mʉja, caivʉ cũinávʉpe paivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Aru ijãravʉcacʉ cʉbebi “mʉ, ñʉjepacʉ, ñʉje jabocʉ” mʉje aimʉ. Nópe abejarã põecʉre. Majepacʉ cũinácʉratame cavarõ mearocacʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aru “mʉ, jabocʉ” aicõjemejara apevʉre mʉja coapa. Yʉ, Cristo, cũinácʉratamu mʉje jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Que baru ñai mʉjacacʉ parʉcʉ baiyʉcʉ baru, memecajacʉrĩ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ñai cʉiyʉcʉ me apevʉ pʉeno, parʉbecʉyʉme pʉeno baju. Aru ñai parʉbede d̶aiyʉcʉ ʉ̃i baju apevʉ cãchino, me cʉcʉyʉme pʉeno baju, Jʉ̃menijicʉi mearo d̶acaquiye boje ʉ̃́re, arĩ buedejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Aru yópe arĩ, coyʉre nʉrejame ʉ̃: —Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Mʉja d̶ad̶avʉ̃ yópe põecʉ ʉ̃i bieiyepe cʉ̃ramine, apevʉ ne ecobenajiyepe ayʉ, aru ʉ̃ máre ecobecʉyʉ. Mʉja coreóvad̶avʉ̃ Jʉ̃menijicʉi yávaiyede. Ʉbenita diede jʉ are d̶abevʉ apevʉre, ne ecobenajiyepe aivʉ Jʉ̃menijicʉi jaboteinore, aru mʉja máre jʉ abevʉ. Que baru ecobenajaramu nore. ");
INSERT INTO cubNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Jʉjovarĩ ñavad̶avʉ ina nomiópeva ne apejĩene. Aru jẽniad̶avʉ joe Jʉ̃menijicʉque, põeva ne dápiarãjiyepe aivʉ ʉbenina mʉja me Jʉ̃menijicʉre jʉ aivʉpe. Caiye iyede mʉje d̶aiye boje, pʉeno ʉrarõ ñájinajaramu mʉja, mʉje ãmeina teiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Joai curãnʉñavʉ mʉja jia ʉrad̶ai aru joborõi máre. Cũinácʉ põecʉre vorãnʉñavʉ, oatʉvarãjivʉ ʉ̃i dápiaiyede, ʉ̃i dápiaquiyepe aivʉ mʉje dápiaiyepe. Aru ʉ̃i d̶aiyede máre oatʉvad̶avʉ̃ mʉja, ʉ̃i d̶aquiyepe aivʉ pʉeno ãmenore, ʉ̃i ñájiquiyepe aivʉ toabo cũiméboi mʉje pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. “Jʉ̃menijicʉi yávaiye báquede bueni bʉojaivʉbu ñʉja”, ad̶avʉ̃ mʉja põevare ʉbenina. Yópe jã́ri eabevʉ ne jipocateiyepe põevare, mʉja Jʉ̃menijicʉi yávaiye báquede bueni bʉojabenamu. Yópe ʉbenina bued̶avʉ̃ mʉja: “Põecʉ ayʉ baru ‘Ji aiyepe d̶acʉyʉmu yʉ, Jʉ̃menijicʉi cʉ̃rami cʉe boje’, d̶aiye jaʉbevʉ ʉ̃́re. Ʉbenita ayʉ baru ‘Ji aiyepe d̶acʉyʉmu yʉ, úru cʉe boje Jʉ̃menijicʉi cʉ̃rami jívʉi’, d̶aiye jaʉvʉ ʉ̃́re”, ad̶avʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mʉjatamu jã́ri eabevʉpe paivʉ mʉje ũmei. Mʉjatamu ãrʉmevʉ. Coreóvabevʉ mʉja Jʉ̃menijicʉi cʉ̃ramine pʉeno parʉrõre caiye iye úru pʉeno. Iye úrubu pʉeno me, die cʉe boje Jʉ̃menijicʉi cʉ̃rami jívʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aru yópe ʉbenina bued̶avʉ̃ mʉja: “Põecʉ ayʉ baru ‘Ji aiyepe d̶acʉyʉmu yʉ, Jʉ̃menijicʉre jícaiyede jícaiva cʉe boje ʉ̃i cʉ̃rami jívʉi’, d̶aiye jaʉbevʉ ʉ̃́re. Ʉbenita ayʉ baru ‘Ji aiyepe d̶acʉyʉmu yʉ, Jʉ̃menijicʉre jícaiye boje jícaiva pʉenora ʉ̃i cʉ̃rami jívʉi’, d̶aiye jaʉvʉ ʉ̃́re”, ad̶avʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mʉjatamu jã́ri eabevʉpe paivʉ mʉje ũmei. Coreóvabevʉ mʉja Jʉ̃menijicʉre jícaivare pʉeno parʉrõre caiye iye jícaiye pʉeno. Iye jícaiyebu pʉeno me, die cʉe boje Jʉ̃menijicʉre jícaiva pʉenora. ");
INSERT INTO cubNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Que baru põecʉ ayʉ baru “Ji aiyepe d̶acʉyʉmu yʉ, Jʉ̃menijicʉre jícaiva cʉe boje ʉ̃i cʉ̃rami jívʉi”, jãve aiyʉrõ “Jʉ̃menijicʉre jícaiva aru caiye Jʉ̃menijicʉre jícaiye diva pʉenora”, aiyʉbi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aru põecʉ ayʉ baru “Ji aiyepe d̶acʉyʉmu yʉ, Jʉ̃menijicʉi cʉ̃rami cʉe boje”, jãve aiyʉrõ “Jʉ̃menijicʉi cʉ̃rami aru ñai cʉcʉ noi”, aiyʉbi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Aru põecʉ ayʉ baru “Ji aiyepe d̶acʉyʉmu yʉ, cavarõ mearo cʉe boje”, jãve aiyʉrõ “Jʉ̃menijicʉi dobarõ mearo aru ñai dobacʉ nore”, aiyʉbi ʉ̃, arejame Jesús. Ʉ̃i que aiyede, Jesús yópe aiyʉcʉ barejaquémavʉ: Cainʉmʉa d̶aiye jaʉvʉ põevare yópe ne aiye báquepedeca. ");
INSERT INTO cubNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Aru yópe arĩ, coyʉre nʉrejame Jesús: —Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Caiye mʉje oteiyoca, quĩ́jiyoca bojecʉbeyoca, caipʉcapʉrʉape paiyocare cʉvarivʉ, cũináyocare jíyavʉ̃ Jʉ̃menijicʉre. Ʉbenita mearo d̶aivʉre apevʉre, cõmaje ãroje jã́ivʉre apevʉre, aru jʉ aivʉre Jʉ̃menijicʉre máre ãrʉmevʉ mʉja. Caipʉcapʉrʉape paiye mʉje cʉvaede jocarĩ, cũinárore Jʉ̃menijicʉre jíye jaʉvʉ mʉjare. Ʉbenita pʉeno baju jaʉvʉ mʉjare mʉje mearo d̶aiye apevʉre, mʉje cõmaje ãroje jã́iye apevʉre, aru mʉje jʉ aiye Jʉ̃menijicʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mʉja d̶ad̶avʉ̃ yópe jã́ri eabevʉ ne jipocateiyepe põevare. Iye parʉbede dápiad̶avʉ̃ mʉja. Que teni d̶ad̶avʉ̃ yópe põecʉ ʉ̃i ĩ́yepe jujicʉre ʉ̃i ũcuidore jocarĩ, ʉbenita ʉ̃i jãrʉóiyepe camello ãmicʉcʉ ãimacʉ ʉracʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Mʉja joad̶avʉ̃ mʉje ũcuidoare aru jororʉare máre pʉenomia, põeva ne jã́inore. Ʉbenita mʉjavacari tatoiyʉrivʉbu apevʉ ne cʉvaede. Que teni ãmeno baju d̶ad̶avʉ̃ mʉja. Que baru mearo d̶aiye apevʉre mearotamu joare d̶aicõjeiye pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mʉja, fariseova, d̶ad̶avʉ̃ yópe jã́ri eabevʉpe paivʉ ne ũmei. Mʉje joaru mamarʉmʉre ũcuido jívʉi aru jororʉ jívʉi máre, ũcuido pʉeno aru jororʉ pʉeno máre docʉcʉbequiyebu. Quédeca dápiaivʉ baru me, d̶arãjaramu me máre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Mʉjatamu yópe yaivʉ bácavʉ ne epeiñamia boriñamiape paivʉ. Diñamiare põeva ne jã́ru jedevai, mead̶amiape ãrojariñamiamu. Ʉbenita diñamia jívʉi, buidíñamiamu yaivʉ bácavʉ ne cũad̶oaque, aru docʉcʉeque máre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Quédeca põeva ne jã́ru mʉjare, mearape aru mearore d̶aivʉpe ãrojarivʉbu mʉja ne jã́iyede. Ʉbenita mʉje ũmei dápiad̶avʉ̃ jʉjovaivʉpe paivʉ aru ãmenore d̶aivʉpe paivʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Mʉja, Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru mʉja, fariseova, jʉjovaivʉ, chĩorajaramu mʉja. Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare. Mʉja d̶ad̶avʉ̃ mead̶amia cʉ̃ramiare ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne jobocobea báque pʉenoi. Aru mʉja mead̶ad̶avʉ̃ ãrʉriñamia cʉ̃ramiare ina meara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yópe borocʉrĩ ad̶avʉ̃ mʉja: “Majeñecuva mácavʉ ne cʉrinʉmʉ cʉrivʉ baru maja, ne boarĩ́ jarʉvaiye báquede ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre cad̶atebejebu maja”, ad̶avʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ʉbenita mʉjavacari jã́d̶ovad̶avʉ ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre boarĩ́ jarʉvaivʉ bácavʉpe paivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Maumejiena iye ãmeina d̶aiyede mʉjeñecuva mácavʉ ne bʉiye báquede bubajarã mʉja, mʉje boarĩ́ jarʉvarãjiyede yʉre, Jʉ̃menijicʉi daroimʉ mácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Mʉja, jʉjovaivʉ, ãd̶avape paivʉbu mʉja! Mʉje toabo cũiméboi ñájinajiyede jocarĩ, dupini nʉivʉ bʉojabenamu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Que baru yʉ daroquijivʉ mʉje yebai Jʉ̃menijicʉi yávaiyede coyʉcaipõevare aru ʉ̃mʉva majidivʉre, aru Jʉ̃menijicʉi yávaiye báquede bueipõevare máre. Apevʉ nácavʉre boarĩ́ jarʉvarãjaramu mʉja. Apevʉre jocʉcʉjaravena pẽvari, boarĩ́ jarʉvarãjaramu. Apevʉre jara popenajaramu maja judíova maje cójijiñamiai. Aru apevʉre cujurãjaramu mʉja ĩmaroa coapa. ");
INSERT INTO cubNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Que baru Jʉ̃menijicʉ ñájine d̶acʉyʉme mʉjare, caivʉ meara mácavʉ ne yaiye báque boje ijãravʉre, apecʉ ʉ̃i boarĩ́ jarʉvaiye báque boje ñai Abel bácʉre, aru apevʉ ne boarĩ́ jarʉvaiye báque boje caivʉ Abel bácʉi yóbocavʉ bácavʉre máre, pʉ Zacarías bácʉ bajita, Berequías bácʉi mácʉ bácʉre, ñai mʉjacavʉ bácavʉ ne boarĩ́ jarʉvaimʉ mácʉre Jʉ̃menijicʉi cʉ̃rami tãibʉ coricai. ");
INSERT INTO cubNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jãve coyʉyʉbu mʉjare: Mʉja ijãravʉcavʉ ñájinajaramu, mʉje ãmeina d̶aiye boje, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yópe arejame Jesús: —¡Mʉja, Jerusalẽ́cavʉ, mʉjeñecuva mácavʉ boarĩ́ jarʉvarejaquemavʉ ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre! Cʉ̃raboaque dʉvarĩ boarĩ́ jarʉvarejaquemavʉ ina Jʉ̃menijicʉi daroimara mácavʉre ne yebai. Obedinʉmʉa cójijovaiyʉrĩduvʉ yʉ mʉjare ji yebai, yópe cáyuco õi cójijovaiyepe mamarare õi caveba cãchinoi. Ʉbenita ʉbeteavʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jã́jara. Dinʉmʉ maquinó mʉje cʉrõre Jʉ̃menijicʉ dajocarĩ jarʉvacʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Aru coyʉyʉbu mʉjare: Yʉre jã́menajaramu mʉja cojedeca pʉ jã́d̶ovacʉdayʉre meacʉ bajure jã́ivʉta. Dinʉmʉ maquinóre arãjaramu yópe: “Torojʉe bajad̶éni ñai dayʉre Jʉ̃menijicʉi ãmiái, ʉ̃i parʉéque”, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús etayʉ bácʉ Jʉ̃menijicʉi cʉ̃ramine jocarĩ, ñʉja ʉ̃i bueimara ʉ̃i yebai nʉri, jã́d̶ovarejacarã diñamia cʉ̃ramiare, Jʉ̃menijicʉi cʉ̃ramicad̶ãmiare. ");
INSERT INTO cubNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Aru ñʉjare arejame: —Caiñamia diñamia ʉrad̶ãmia cʉ̃ramiare jã́ivʉbu mʉja. Jãve coyʉyʉbu mʉjare: Cũináva cʉ̃rava mautebequiyebu apeva pʉenora. Caiye iva cʉ̃rava tʉquiyebu, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús dobarejame cʉ̃racũ Olivocũ ãmicʉricũ pʉenoi. Ʉ̃i dobaede noi, ñʉja, ʉ̃i bueimara, jẽniari jã́rejacarã ʉ̃́re yavenina, põevare jocarĩ: —Coyʉjacʉ ñʉjare: ¿Aipiyede tʉquidi caiye iye cʉ̃ramia ʉrad̶ãmia? ¿Aipe d̶arĩ coreóvarãjidica ñʉja mi copaidaquiyede? ¿Aipe d̶arĩ majinajidica ñʉja ijãravʉ cũiquíyede? jẽniari jã́rejacarã ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ñʉjare yópe arĩ, coyʉrejame Jesús: —Me jã́jara apecʉ jʉjovaiyʉcʉre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Obedivʉ ʉ̃mʉva darĩ arãjarama “Cristobu yʉ”, jʉjovarãjivʉ obedivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aru “Põeva boad̶áma apevʉ põevaque” ne borore jápiarĩ, aru “Põeva boarã́jarama apevʉ põevaque” ne borore máre jápiarĩ, jidʉbejarã mʉja. Que baru caiye iye vaiye jaʉvʉ, jãravʉ cũiquíye jipocai. Ʉbenita cũimébu cãreja. ");
INSERT INTO cubNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Cũináyajubo põeyajubocavʉ ãd̶amatenajarama apeyajubo põeyajubocavʉque. Aru cũináro jaboteinocavʉ ãd̶amatenajarama apeno jaboteinocavʉque. Joborõ cújiquiyebu obedicʉrõare. Ñájinajarama ãvʉéna. ");
INSERT INTO cubNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iye ñájiye baquiyébu yópe jʉed̶ocʉ põeteyʉre ñájiyepe. Yópe bʉ́quiyebu caiye iye ãmeina ñájinajiye. ");
INSERT INTO cubNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Mʉjare jẽni jínajarama, mʉje ñájinajiyepe aivʉ. Aru mʉjare boarĩ́ jarʉvarãjarama na. Mʉjare cainoa jaborõacavʉ jorojĩni jã́rajarama, yʉre mʉje jʉ aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Dinʉmʉ maquinóre obedivʉ yʉre jʉ aivʉ bácavʉ dajocarãjarama ne yʉre jʉ aiye báquede. Obedivʉ jẽni jínajarama névʉre ne mauvare. Aru obedivʉ jorojĩni jã́rajarama névʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Obedivʉ borocʉrivʉ “Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉbu yʉ” arĩ, ʉbenina coyʉcarĩduivʉ, põevare jʉjovarãdarãjarama. ");
INSERT INTO cubNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dinʉmʉ maquinóre obedivʉ põeva ʉrarõ baju ãmenore d̶arãjarama. Que baru obedivʉ põeva ʉbenajarama apevʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ʉbenita ñai jʉ ayʉ yʉre ʉ̃i yainʉmʉita, ʉ̃ macʉyʉ́me ji mead̶aimʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mamarʉmʉre yávaiye méne Jʉ̃menijicʉi jaboteinora coyʉiye jaʉvʉ cainoa joborõacavʉre, ne jápiarãjiyepe aivʉ diede. Que baru cainoa joborõacavʉ iye yávaiye méne coreóvaivʉ barãjárama. No yóboi jãravʉ cũiquíyebu. ");
INSERT INTO cubNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ʉbenita iye vaiquíye jipocai, ñai ʉ̃mʉ pare ãmecʉ núcʉyʉme nore, Jʉ̃menijicʉi cʉicõjemenore ʉ̃́re, yópe Daniel ãmicʉcʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ ʉ̃i coyʉiye báquepedeca. Caivʉ jã́ri boroteivʉ iye toivaiyede me dápiajarãri caiye iyede. Ñai ʉ̃mʉre jã́rajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judeacavʉ dupini nʉjarari cʉ̃racũai, ne jidʉé boje ñai ʉ̃mʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Aru ñai cʉ̃rami pʉenora cʉcʉyʉ, ʉ̃i dupini nʉiyede, ẽmeni, darĩ, nʉvariducʉyʉ ʉ̃i apejĩene, ecobejacʉrĩ ʉ̃i cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aru ñai jiore memecʉyʉ, ʉ̃i dupini nʉiyede, copainʉmejacʉrĩ, ĩniducʉyʉ ʉ̃i cuitótecaje pʉenocacajede. ");
INSERT INTO cubNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Cõmaje ãrojarajarama ina nomiva micava bárãjivʉ dijãravʉa baquiyéde! ¡Aru ina nomiva némajina nuri dajocabevʉre cʉvarãjivʉ máre pare ñájinajarama dijãravʉa baquiyéde! ");
INSERT INTO cubNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jẽniajara Jʉ̃menijicʉque iye vaibéquiyepe aivʉ ocorʉ̃mʉre aru jabʉóvaijãravʉ sábadore máre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","’Dijãravʉa baquiyéde põeva ʉrarõ ñájinajarama. Nópe paiye cʉbevʉ cãreja, mamarʉmʉmata Jʉ̃menijicʉ ʉ̃i cʉed̶arĩ bʉinʉmʉre pʉ caride máre. Aru cainʉmʉa cʉbequiyebu. ");
INSERT INTO cubNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jʉ̃menijicʉ ʉ̃i javaiyobedu dijãravʉa ñájiovaquijãravʉa baquiyéde, caivʉ yaijébu. Mead̶aimara cʉbejebu. Ʉbenita Jʉ̃menijicʉ javaiyocʉyʉme dijãravʉa ñájiovaquijãravʉa baquiyéde, ʉ̃i beoimara mácavʉre boje. ");
INSERT INTO cubNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Dijãravʉa baquiyéde apecʉ ʉ̃i aru mʉjare yópe, “Jã́jara. ¡Ñainecabe Cristo!” o apecʉ ʉ̃i aru mʉjare, “¡Ãñʉrecabe Cristo!” náre jʉ abejarã. ");
INSERT INTO cubNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Que teni obedivʉ borocʉrivʉ darĩ, coyʉrãjarama “Cristobu yʉ”. Aru apevʉ máre Jʉ̃menijicʉi yávaiyede coyʉcarĩdurãjarama. Ʉbenita Jʉ̃menijicʉi yávaiyede coyʉcaipõeva baju ãmenajarama na. Ʉrarõ põeva ne jã́mene aru ne d̶arĩ majibede máre d̶arãjarama, jʉjovaiyʉrĩduivʉ Jʉ̃menijicʉi beoimara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ʉbenita me jã́jara mʉja. Coyʉyʉbu mʉjare ne borore, mʉje majinajiyepe ayʉ, ne darãjiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Que baru apevʉ ne aru “Jã́jara. Ñai Cristo cʉbi põecʉbenoi”, nʉmejara mʉja nore. Aru apevʉ ne aru “Jã́jara. Ñai Cristo cʉbi tucubʉ jívʉi”, jʉ abejarã ne nópe coyʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","’Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, yaroinope nʉquiyebu ji copaidaquijãravʉ baquinóre. Yópe no yaroino pẽoiyepe cavarõi, aviá dainocapũravʉre jocarĩ pʉ aviá doinocapũravʉita, caivʉ põeva ne jã́rajiyepe ayʉ nore, nopedeca copaidacʉyʉmu yʉ. Aru caivʉ põeva jã́rajarama ji copaidaquiyede ijãravʉi. ");
INSERT INTO cubNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ã́ri yaiyʉ́ bácʉi cʉrõi, noi cójijinajarama cavava. Nopedeca caiye iye ji coyʉiyede jã́ivʉ, majinajaramu mʉja ji copaidaquino joabenore, ji ñájiovaquinore põevare, ne ãmeina teiye boje, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Bedióva cojedeca Jesús, yópe arĩ, coyʉrejame ñʉjare: —Cũinájãravʉ dijãravʉacajãravʉ baquinói, iye ʉrarõ ñájiniburu yóboi, aviá ñemitecʉyʉme. Aru aviá ñamicacʉ máre pẽomecʉyʉme. Na abiácova tʉrãjarama cavarõre jocarĩ. Aru caivʉ ina parʉrivʉ cʉrivʉ cavarõi cújinajarama. ");
INSERT INTO cubNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Dinʉmʉ maquinóre Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ji copaidaquiyede jã́d̶ovaiye jároquiyebu cavarõi. Aru caivʉ põeyajuboacavʉ ijãravʉcavʉ chĩori orãjarama. Dinʉmʉ maquinóre jã́rajarama yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, dayʉre ocopeniboai, ʉrarõ parʉéque, jã́d̶ovañʉre meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Que teni trompeta ãmicʉriyo japuiyore japuiye pare bʉjiéque, ji ángelevare darocʉyʉmu yʉ. Nácapũravʉ cójijovarãjarama Jʉ̃menijicʉi beoimara mácavʉre, caivʉ aviá dainocavʉre aru caivʉ aviá doinocavʉre máre, cainoa joborõacavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Majijarã yo mʉje jã́inore. Icʉ jocʉcʉ higueracʉ ãmicʉricʉre yoca yuiyede, majivʉ mʉja ʉjʉrʉ̃mʉ joabenore. ");
INSERT INTO cubNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nopedeca jã́ivʉ caiye iye teiyede, majinajaramu mʉja jãravʉ cũino joabenore. ");
INSERT INTO cubNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jãve coyʉyʉbu mʉjare: Apevʉ ijãravʉi cʉrivʉ yaibédeca cãreja, vaiquíyebu caiye iye yópe ji coyʉiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Caino cavarõ, aru caino joborõ máre cũiquíyebu. Yópe ji yávaiyepedeca jãve vaiquíyebu. ");
INSERT INTO cubNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Ʉbenita dijãravʉ baquinóre aru diora baquinóre ñame majibema. Ángeleva, ina cʉrivʉ Jʉ̃menijicʉque cavarõ mearoi, aru yʉ, Jʉ̃menijicʉi mácʉ máre, majibevʉ ñʉja. Quénora jipacʉ majibi dijãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Dijãravʉa baquiyéde, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ji copaidaquijãravʉ jipocai, cʉquiyebu nópe ãnijãravʉa Noé mácʉi cʉrijãravʉa báquepe. ");
INSERT INTO cubNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ãnijãravʉa báquede, muiváibo daquiye jipocai, caivʉ põeva ãivʉ barejaquémavʉ, aru ũcuivʉ barejaquémavʉ. Ʉ̃mʉva pʉrʉbʉoivʉ barejaquémavʉ. Aru jívʉ barejaquémavʉ némaromivare, ne pʉrʉbʉorãjiyepe aivʉ. Nópe tedejaquemavʉ, Noé mácʉi jiad̶ocũ ʉracũre ecoijãravʉ bácarõita. ");
INSERT INTO cubNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ʉbenita ne bíjarãjiyede coreóvabedejaquemavʉ, pʉ muiváibo daiyeta. Aru caivʉ ina põeva corĩ bíjarejaquemavʉ na mácavʉ. Nopedeca baquiyébu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ji copaidaquiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Dinʉmʉ maquinóre pʉcarã ʉ̃mʉva memenajarama ne jioi. Cũinácʉ nʉvaimʉ macʉyʉ́me, yʉre ʉ̃i jʉ aiye boje. Aru apecʉ mautecʉyʉme, yʉre ʉ̃i jʉ abe boje. ");
INSERT INTO cubNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pʉcarã nomiva jĩorajarama ne cʉ̃rami jívʉi. Cũináco nʉvaimo macod̶óme, yʉre õi jʉ aiye boje. Aru apeco mautecod̶ome, yʉre õi jʉ abe boje. ");
INSERT INTO cubNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Que baru me jã́jara mʉja. Mʉja majibevʉ ji copaidaquijãravʉre, ji jabotequiyede mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ñai cʉ̃rami upacʉ majibebi aipiyede ñavaipõecʉ dacʉyʉre. Majicʉ baru ñavaipõecʉ ʉ̃i daiyede, coreni, ecoicõjemeni, ñavaicõjemejebu ʉ̃i cʉ̃ramiquede. ");
INSERT INTO cubNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aru mʉjare máre mead̶aiye jaʉvʉ. Que baru yʉ máre, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, dacʉyʉmu mʉje corebeorai yʉre, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Bedióva jã́ri dápiarĩ ñʉje d̶arãjiyepe arĩ, buedejame Jesús: —Coyʉquijivʉ mʉjare ʉ̃i borore ñai memecaipõecʉre jʉ ayʉre ʉ̃i jabocʉre aru majicʉre máre. Ñai cʉ̃rami upacʉ coreicõjecʉyʉbe ñai memecaipõecʉ majicʉre, ʉ̃i jíquiyepe ayʉ yebacavʉre ne ãrajiyeva caijãravʉa. ");
INSERT INTO cubNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ñai cʉ̃rami upacʉ copaini dayʉ earu ʉ̃́re memecaipõecʉre d̶ayʉre yópe ʉ̃i cõjeinope, torojʉcʉyʉbe ñai memecaipõecʉ, cʉ̃rami upacʉ ʉ̃i jíquiye boje ʉ̃́re bojed̶aino mearore. ");
INSERT INTO cubNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jãve coyʉyʉbu mʉjare: Ñai cʉ̃rami upacʉ coreicõjecʉyʉbe ñai memecaipõecʉre caiye ʉ̃i cʉvaede. ");
INSERT INTO cubNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ʉbenita ñai memecaipõecʉ, jʉ abecʉ baru ʉ̃i jabocʉre, “Ji jabocʉ maume dabecʉbe” arĩ, aru ãmeina d̶ayʉ baru ʉ̃i yebacavʉre aru yebacarõmivare máre, ʉrarõ ãri aru ũcuri pacotecʉyʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Que teiyede ʉ̃i jabocʉ dacʉyʉbe ñai memecaipõecʉ ʉ̃i corebejãravʉ baquinói aru ʉ̃i majibeora baquinói máre. ");
INSERT INTO cubNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aru ñai jabocʉ jarʉvaicõjecʉyʉbe ʉ̃́re jʉjovaivʉre ne jarʉvainoi, ʉ̃i ñájiquiyepe ayʉ noi. Nore chĩoivʉ orĩ, cʉrãjarama põeva. Aru jararĩ cõpi cũrajarama na, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yópe arĩ, jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Dijãravʉ baquinói, ji copaidaquijãravʉi, Jʉ̃menijicʉi jaboteino yópe baquiyébu caipʉcapʉrʉape paivʉ bojʉrõmiva ne d̶aiye báquepe. Ina bojʉrõmiva, ne pẽoibʉare náre coapa ĩni, copʉ etaquemavʉ ñai pʉrʉbʉoyʉre ʉ̃i daiyede. ");
INSERT INTO cubNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cũinápʉrʉpe paivʉ nácavʉ majibevʉ batequémavʉ. Aru apevʉ cũinápʉrʉpe paivʉ nácavʉ majidivʉ batequémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ina majibevʉ, ne nʉvaiyede ne pẽoibʉare, neore nʉvametequemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ʉbenita ina majidivʉ, ne nʉvaiyede ne pẽoibʉare, nʉvaquemavʉ ne neobʉare máre neoque. ");
INSERT INTO cubNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ñai pʉrʉbʉoyʉ ʉ̃i dabe boje cãreja, caivʉ ina bojʉrõmiva cãquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Ʉbenita ñami corica baji cod̶oboboiyede jápiaquemavʉ na. “Jã́jara. Ñai pʉrʉbʉoyʉ daibi. Ʉ̃́re copʉ etajarã mʉja”. ");
INSERT INTO cubNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Diede jápiarĩ, caivʉ ina bojʉrõmiva coedaquemavʉ. Aru ne pẽoibʉare mead̶aquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Que teni ina majibevʉ, yópe arĩ, jẽniariduquemavʉ ina majidivʉre, “Ñʉje pẽoibʉa cod̶aibʉatamu. Que baru jíjarã ñʉjare majióvarijĩno mʉje neoquede”, arĩduquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ʉbenita ina majidivʉ, yópe arĩ, coyʉquemavʉ náre, “Bi, jíbevʉ mʉjare. Neo eabequiyebu ñʉjare aru mʉjare máre. Quénora neore bojed̶ainoi bojed̶arãnʉjara mʉja, ĩnajivʉ mʉjeva”, aquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ne neore bojed̶arãnʉiyede, ñai pʉrʉbʉoyʉ daquemavʉ. Ina bojʉrõmiva mead̶aivʉ bácavʉ ecoquemavʉ ʉ̃́que, ãrajivʉ torojʉve teinoi. Aru no cʉ̃rami jedevacobede biequemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","No yóboi ina bojʉrõmiva mead̶abevʉ bácavʉ edaquemavʉ torojʉve teiñami máre. Aru yópe arĩ, “Mʉ, ñʉje jabocʉ, voacajacʉ ñʉjare”, jẽniariduquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ʉbenita ñai pʉrʉbʉoyʉ yópe aquemavʉ náre: “Jãve coyʉyʉbu mʉjare: Jívʉ ãmevʉ mʉja. Mʉjare coreóvabevʉ yʉ”, aquemavʉ ʉ̃ ina bojʉrõmiva majibevʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aru buede nʉrejame Jesús: —Que baru mead̶aimara májara mʉja, mʉje majibe boje ye jãravʉre aru ye órare máre ji copaidaquiyede, mʉjare mead̶aiye jaʉquinore, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yópe arĩ, jã́ri dápiarĩ ñʉje d̶arãjiyepe ainoque buedejame Jesús: —Dijãravʉ, ji copaidaquijãravʉ baquinói, Jʉ̃menijicʉi jaboteino yópe baquiyébu cũinácʉ ʉ̃mʉ apeno jaborõi nʉcʉyʉ ʉ̃i d̶aiye báquepe. Ʉ̃i nʉquiye jipocai, órejaquemavʉ ʉ̃́re memecaipõevare, epecʉyʉ ʉ̃i cʉvaede náque, ne jã́ri corenajiyepe ayʉ diede. ");
INSERT INTO cubNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Cũinácʉ nácacʉre epequemavʉ cũinápʉrʉpe paimil tʉrava tãutʉratʉravare. Apecʉ nácacʉre epequemavʉ pʉcamil tʉrava tãutʉratʉravare. Aru apecʉre epequemavʉ cũinámil tʉrava tãutʉratʉravare. Ne majiépe epequemavʉ náre coapa. Caiye iyede epeniburu yóboi, nʉquemavʉ ñai ʉ̃mʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ñai memecaipõecʉ jacopʉyʉ bácʉ cũinápʉrʉpe paimil tʉrava tãutʉratʉravare bojed̶acʉnʉquemavʉ dieque. Aru eaquemavʉ ape cũinápʉrʉpe paimil tʉrava tãutʉratʉravare. ");
INSERT INTO cubNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Quédeca ñai memecaipõecʉ jacopʉyʉ bácʉ pʉcamil tʉrava tãutʉratʉravare bojed̶acʉnʉquemavʉ dieque. Aru eaquemavʉ ape pʉcamil tʉrava tãutʉratʉravare. ");
INSERT INTO cubNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ʉbenita ñai memecaipõecʉ jacopʉyʉ bácʉ cũinámil tʉrava tãutʉratʉravare ũcʉnʉquemavʉ joborõi, yavecʉyʉ ditʉrava, ʉ̃i jabocʉi tãutʉratʉravare. ");
INSERT INTO cubNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Obedijãravʉa yóboi, ñai jabocʉ copaidaquemavʉ. Corevacʉdaquemavʉ ne bojed̶aiyede ʉ̃i epeiye báqueque náre. ");
INSERT INTO cubNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ñai jacopʉyʉ bácʉ cũinápʉrʉpe paimil tʉrava tãutʉratʉravare nʉquemavʉ ʉ̃i jabocʉ yebai. Nʉvaquemavʉ caipʉcapʉrʉape paimil tʉrava tãutʉratʉravare. Aru aquemavʉ, “Mʉ, ji jabocʉ, mʉ epeávʉ̃ cũinápʉrʉpe paimil tʉrava tãutʉratʉravare yʉre. Diede bojed̶arĩ, ĩ́vʉ yʉ ape cũinápʉrʉpe paimil tʉrava tãutʉratʉravare”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Que baru ñai jabocʉ aquemavʉ ʉ̃́re, “Mearo d̶arebu mʉ. Memecaipõecʉ meacʉbu mʉ. D̶aivʉ mʉ yópe d̶aiye jaʉépe. Mi mearo d̶aiye boje quĩ́jinoque, epequijivʉ mʉre pʉeno baju. Caride torojʉcʉyʉmu mʉ, yópe ji torojʉepe”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Aru ñai jacopʉyʉ bácʉ pʉcamil tʉrava tãutʉratʉravare nʉquemavʉ ʉ̃i jabocʉ yebai. Ʉ̃i jabocʉre aquemavʉ, “Mʉ, ji jabocʉ, mʉ epeávʉ̃ pʉcamil tʉrava tãutʉratʉravare yʉre. Diede bojed̶arĩ, ĩ́vʉ yʉ ape pʉcamil tʉrava tãutʉratʉravare”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Que baru ñai jabocʉ aquemavʉ ʉ̃́re máre, “Mearo d̶arebu mʉ. Memecaipõecʉ meacʉbu mʉ. D̶aivʉ mʉ yópe d̶aiye jaʉépe. Mi mearo d̶aiye boje quĩ́jinoque, epequijivʉ mʉre pʉeno baju. Caride torojʉcʉyʉmu mʉ, yópe ji torojʉepe”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Ʉbenita ñai jacopʉyʉ bácʉ cũinámil tʉrava tãutʉratʉravare nʉquemavʉ ʉ̃i jabocʉ yebai. Ʉ̃i jabocʉre aquemavʉ, “Mʉ, ji jabocʉ, jidojacʉbu mʉ. Mʉ ĩñʉmu apecʉ ʉ̃i epeiye báquede. Aru mʉ jẽñʉmu apecʉ ʉ̃i oteiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Que baru jidʉvʉ yʉ mʉre. Aru yavecacʉ mi tãutʉrare joborõ jívʉi. Yui cʉvavʉ mi tãutʉrare”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","27","Ʉbenita ñai jabocʉ aquemavʉ ʉ̃́re, “Mʉ, memecaipõecʉ ãmecʉbu. Jũracʉcʉbu mʉ. Yʉ ĩñʉre apecʉ ʉ̃i epeiye báquede aru jẽñʉre apecʉ ʉ̃i oteiye báquede majicʉvacari, epecʉnʉri jaʉrĩdurebu mʉre ji tãutʉrare tãutʉra epeiñami. Mi que d̶aru, copaini dayʉ jacopʉjebu yʉ ji tãutʉrare pʉeno baju, diñamicavʉ ne bojed̶aiye báque cojiórĩ”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Que baru ñai jabocʉ apevʉre ĩ́cõjeni aquemavʉ, “Ĩjara ʉ̃́re jocarĩ yo cũinámil tʉrava tãutʉratʉravare. Aru jíjarã ñai caipʉcapʉrʉape paimil tʉrava cʉvacʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Caivʉ cʉvarivʉ jacopʉrãjarama pʉeno baju, cʉvarãjivʉ ʉrarõ baju. Ʉbenita caivʉ dápiaivʉre cʉvarivʉpe apevʉ pʉeno, caiyede náre ĩcʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aru ñai memecaipõecʉ yʉre cad̶atebecʉre jaetovajarã joai ñeminoi, ʉ̃i jʉ abe boje yʉre, ʉ̃i coatequiyepe aivʉ yʉre jarʉvarĩ. Noi põeva chĩoivʉ orĩ, cʉrãjarama. Aru jararĩ, cõpi cũrajarama na”, arĩ buedejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yópe arĩ, coyʉrejame Jesús: —Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, meacʉ baju dacʉyʉmu ijãravʉi. Aru caivʉ ina ángeleva darãjarama yʉ́que. Edarĩburu yóboi, dobacʉyʉmu jabocʉi dobarõ mearora. ");
INSERT INTO cubNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ji jipocai cójijinajarama caivʉ ijãravʉi joborõacavʉ. Yópe oteiãimarare coreipõecʉ ʉ̃i beoiyepe ovejavare ĩni cabravare jocarĩ, nopedeca beocʉyʉmu yʉ ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yópe ʉ̃i epeiyepe ina ovejavare ʉ̃i meapũravʉi aru ina cabravare ʉ̃i cãcopũravʉi, nopedeca beorĩ epecʉyʉmu yʉ ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Beorĩburu yóboi, acʉyʉmu yʉ, caivʉ ne jabocʉ, ina põeva meara ji meapũravʉi cʉrivʉre, “Dajarã mʉja. Mʉjamu jipacʉi mearo d̶acaimara. Ji jaboteimara májara mʉja. Jipacʉ Jʉ̃menijicʉ ʉ̃i cʉed̶aiye báquedata caiyede, mead̶acarejaquemavʉ yo jaboteinore mʉjare boje. ");
INSERT INTO cubNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉre ãvʉé ijiteavʉ̃. Aru ãiyede jiavʉ̃ mʉja yʉre. Yʉre cũiñóavʉ. Aru ũcuiyede jiavʉ̃ mʉja yʉre. Joai cucʉdacacʉ mʉje yebai. Aru yʉre copʉ etavʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cuitótecaje cʉvabetecacʉ yʉ. Aru ji doiyeva jiavʉ̃ mʉja yʉre. Ijimʉ matecácʉ yʉ. Aru ji yebai curãdavʉ̃ mʉja. Jabova ne bʉoimʉ matecácʉ yʉ ãmeina teivʉre jẽni jacoiñami jívʉi. Aru yʉre jã́radavʉ̃ mʉja noi”, acʉyʉmu mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Que ayʉre, ina põeva meara, ji meapũravʉcavʉ, yópe arãjarama yʉre: “Mʉ, ñʉje jabocʉ, ¿aipiyede mʉre ãuyaiyʉre jã́ri, ãiyede jiarĩ ñʉja? ¿Aipiyede mʉre cũiñóimʉre jã́ri, ũcuiyede jiarĩ ñʉja? ");
INSERT INTO cubNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Aipiyede mʉre joai cucʉdayʉre jã́ri, copʉ etarĩ ñʉja? ¿Aipiyede mʉre cuitótecaje cʉvabecʉre jã́ri, mi doiyeva jiarĩ ñʉja? ");
INSERT INTO cubNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Aipiyede mʉre ijimʉre aru mʉre ne bʉoimʉre jã́ri, jã́radarĩ ñʉja?” arãjarama yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aru yʉ, caivʉ ne jabocʉ, acʉyʉmu náre: “Jãve coyʉyʉbu mʉjare: Mʉje cad̶ateiyede cũinájicʉ ina jívʉcacʉre parʉbecʉreca, yʉre mʉje cad̶ateiyepebu”, acʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Dinʉmʉ maquinóre ina põeva ãmenare, ji cãcopũravʉi cʉrivʉre yópe acʉyʉmu yʉ: “Nʉjara mʉja yʉre jocarĩ. Mʉjamu jipacʉi ãmed̶aimara. Nʉjara mʉja toabo cũiméboi. No mead̶aino mácarõre abujuvai jabocʉi cʉrõre ʉ̃i ángelevaque. ");
INSERT INTO cubNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉre ãvʉé ijiteavʉ̃. Ʉbenita ãiyede jíbeteavʉ̃ mʉja yʉre. Yʉre cũiñóavʉ. Ʉbenita ũcuiyede jíbeteavʉ̃ mʉja yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Joai cucʉdacacʉ mʉje yebai. Ʉbenita yʉre copʉ etabeteavʉ̃ mʉja. Cuitótecaje cʉvabetecacʉ yʉ. Ʉbenita ji doiyeva jíbeteavʉ̃ mʉja yʉre. Ijimʉ matecácʉ yʉ. Aru jabova ne bʉoimʉ matecácʉ yʉ ãmeina teivʉre jẽni jacoiñami jívʉi. Ʉbenita yʉre jã́radabeteavʉ̃ mʉja”, acʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Que ayʉre, ina põeva ãmena, ji cãcopũravʉcavʉ, yópe arãjarama yʉre: “Mʉ, ñʉje jabocʉ, ¿aipiyede mʉre ãuyaiyʉre, o cũiñóimʉre, o joai cucʉdayʉre, o cuitótecaje cʉvabecʉre, o ijimʉre, o jabova ne bʉoimʉre jã́ri, ʉbenita mʉre cad̶atebetearĩ ñʉja?” arãjarama na. ");
INSERT INTO cubNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aru yʉ acʉyʉmu náre: “Jãve coyʉyʉbu mʉjare: Mʉje cad̶atebede cũinájicʉ ina jívʉcacʉre parʉbecʉreca, yʉre mʉje cad̶atebepedecabu”, acʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aru nácapũravʉ nʉrajarama toabo cũiméboi, ñájinajivʉ cainʉmʉa. Ʉbenita ina meara ecorãjarama ji jaboteinore, me cʉrãjivʉ cainʉmʉa, arĩ coyʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Caiye iyede Jesús coyʉrĩ bʉojarĩ, yópe arejame ñʉja ʉ̃i bueimarare: ");
INSERT INTO cubNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Majivʉ mʉja. Pascua ãmicʉrijãravʉ aru pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teinʉmʉ pʉcajãravʉa jipocai barejávʉ̃ cãreja. Aru dinʉmʉ maquinóre yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jẽni jínajarama ji mauvare, ji yaiquíyepe aivʉ jocʉcʉjaravena, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dinʉmʉre sacerdotevare jaboteipõecʉ Caifás ãmicʉrejame. Apevʉ sacerdotevare jaboteipõeva aru judíova bʉcʉva cójijidejaimad̶a ñai Caifás ʉ̃i cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Cójijivʉ, ne bajumia majicarejaimad̶a Jesúre jʉjovarĩ jẽni, boarĩ́ jarʉvarãjivʉ yavenina. ");
INSERT INTO cubNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ne bajumia arejaimad̶a: —Torojʉve teinʉmʉ ʉ̃́re jẽmenajarevʉ maja. Ʉ̃́re jẽnu torojʉve teinʉmʉ, põevacapũravʉ jorojĩni, majare boarĩ́ jarʉvaiyʉjebu, arejaimad̶a ina judíovai jabova. ");
INSERT INTO cubNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","7","Dinʉmʉre Jesús ʉ̃i cʉede Betania ãmicʉriĩmajinoi, Simón pojeyʉ bácʉi cʉ̃rami tʉoiva yebai ãivʉ barejacárã ñʉja. Que teni cũináco nomió darejaco Jesús yebai. Ico nomió davarejaco cũinábʉ ʉ̃mʉjʉribʉ boribʉre, mumijʉricoro cʉribʉre. Iye mumijʉe, nardo ãmicʉe, pare mearo corajʉrejavʉ̃. Aru pare bojecʉe barejávʉ̃ya. Que d̶arĩ ico nomió yuarejaco caiye iye mumijʉede Jesúi jipobʉrã. ");
INSERT INTO cubNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ʉbenita ñʉja Jesúi bueimara õi nópe d̶aiyede jã́ri, jorojĩni arejacarã: —¿Aipe teni iye mumijʉede jarʉvad̶oba õ? ");
INSERT INTO cubNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Diede bojed̶arĩ, ʉrarõ boje ĩni, jíye jaʉjebu ṍre cʉve cʉvabevʉre, arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ʉbenita Jesús, diede coreóvayʉ, arejame ñʉjare: —¿Aipe teni ico nomióre cãrijovaivʉrʉ̃ mʉja? Õi d̶aiye yʉre mearotamu. ");
INSERT INTO cubNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Cainʉmʉa ina cʉve cʉvabevʉ cʉrãjarama mʉjaque. Ʉbenita yʉ cʉbecʉbu mʉjaque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Õi yuaiyede dicorore yʉrã, mead̶acaibico ji bajure, ne jarʉvarãjiyepe ad̶o. ");
INSERT INTO cubNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Que baru jãve coyʉyʉbu mʉjare: Cainoa joborõai ijãravʉi põeva ne coyʉiyede iye yávaiye méne ji mead̶aiyede põevare, iye õi yʉre d̶acaiyede máre coyʉrãjarama, ne ãrʉrajiyepe aivʉ ṍre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","No yóboi cũinácʉ ñʉjacacʉ, doce paivʉ Jesúi bueimaracacʉ, ʉ̃i ãmiá Judas Iscariote, nʉrejamed̶a ina sacerdotevare jaboteipõeva yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ñai Judas náre jẽniari jã́rejamed̶a: —¿Ji Jesúre jẽni jídu mʉjare, aipino jínajivʉrʉ̃ mʉja yʉre? arejamed̶a ʉ̃. Aru treinta paitʉrava plataque d̶aitʉrava tãutʉratʉravare jídejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Que baru dinʉmʉmata Judas jã́ri, coreni bʉ́rejamed̶a yavenina, jẽni jícʉyʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teinʉmʉ mamabʉijãravʉ barejávʉ̃. Aru dijãravʉre Jesús yebai nʉri, jẽniari jã́rejacarã ñʉja, ʉ̃i bueimara: —¿Ã́ri nʉri, mʉre maje Pascua jãravʉque ãiyede mead̶acarãjidica ñʉja? arejacarã ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aru arejame Jesús: —Jerusalẽ́i nʉri, ñai ʉ̃mʉ, ji aimʉ mácʉ, ʉ̃i cʉ̃rami nʉjara mʉja. Ʉ̃́re yópe ajarã mʉja, “Maje bueipõecʉ aibi, ‘Joabejĩnotamu ji yaiquíno. Que baru mi cʉ̃rami ãquijivʉ yʉ Pascua jãravʉquede ji bueimaraque’, aibi maje bueipõecʉ”, ajarã mʉja, ñʉjare arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ʉ̃́re jʉ arĩ, ĩmaroi nʉri, d̶arejacarã ñʉja yópe Jesús ʉ̃i aiye báquepedeca. Noi Pascua jãravʉque ãiyede mead̶arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Que teni mead̶arĩ bʉojarĩ, nainú baji, aviá ʉ̃i dorĩburu yóboi, darĩ dobarejame Jesús tʉoiva yebai, ñʉja ʉ̃i bueimara doce paivʉque. ");
INSERT INTO cubNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ñʉje ãiyedeca, Jesús arejame ñʉjare: —Jãve coyʉyʉbu mʉjare: Mʉjacacʉ cũinácʉ yʉre ji mauvare jẽni jícʉyʉme ʉ̃, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Que baru chĩoivʉ barejacárã. Aru ñʉja coapa yópe arĩ bʉ́rejacarã Jesúre: —¡Mʉ, ji jabocʉ, que d̶abecʉbu yʉ! ¿Mʉ́carĩ? arejacarã ñʉja coapa. ");
INSERT INTO cubNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Que arĩ, Jesús arejame ñʉjare: —Cũinácʉ mʉjacacʉ jóyʉ pã́ure jororʉmica yʉ́que, ʉ̃ macʉyʉ́me ji mauvare yʉre jẽni jíyʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ijãravʉi, ji yaijãravʉi nʉcʉyʉmu yʉ, yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃i yávaiyede. Ʉbenita ãmeno vaicʉ́yʉme ʉ̃, ñai yʉre jẽni jíyʉ bacʉyʉ́. Ñai nópe d̶acʉyʉ, ʉ̃i põetebedu meajebu, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, ʉ̃́re jẽni jícʉyʉ, arejame ʉ̃́re: —Mʉ, bueipõecʉ, yʉ ãmevʉ mi coyʉimʉ nópe. ¿Mʉ́carĩ? arejame Judas. Ʉ̃́re arejame Jesús: —Mʉ́tamu ji coyʉimʉ nópe, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ñʉje ãiyedeca, pã́ure ĩni, Jʉ̃menijicʉre torojʉede jídejame Jesús. No yóboi, pã́ure cotʉvarejame. Aru ñʉjare coapa jídejame. —Pã́ure ãjara mʉja. Diedecabu ji bajupe, jã́d̶ovaiye ji yaiquínore mʉjare boje, arejame ñʉjare Jesús. Aru ãrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ũcuidore máre ĩni, torojʉede jíni Jʉ̃menijicʉre, ñʉjare jídejame Jesús, yópe arĩ: —Jẽni, ũcuri, veorĩ, ũcujara caivʉ mʉja coapa. ");
INSERT INTO cubNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Diedecabu ji jivepe, jã́d̶ovaiye ji yaiquínore mʉjare boje, Jʉ̃menijicʉi ãrʉmetequiyepe ayʉ mʉje ãmeina teiyede. Jʉ̃menijicʉ “Yópe d̶ajarã mʉja, boropatebenajivʉ ji jã́inoi”, ʉ̃i yóbocarõ coyʉino mácarõre põevare ãrʉrajaramu mʉja, mʉje ũcuiyede diede. ");
INSERT INTO cubNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Coyʉyʉbu mʉjare: Quénora vino ʉ́yaicorore ũcuñʉmu yʉ ijãravʉre. Ʉbenita ãnijãravʉ, jipacʉi jabotequinʉmʉ maquinóre, bedióva cojedeca ũcuri jã́cʉyʉmu yʉ, arejame Jesús ñʉja ʉ̃i bueimarare. Aru ũcurejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ñʉje ãriburu yóboi, Salmos ãmicʉe yʉriaiyede yʉriarejacarã ñʉja. Yʉriarĩ bʉojarĩ, no cʉ̃racũ Olivocũ ãmicʉricũi nʉrejacarã ñʉja, Jesújã. ");
INSERT INTO cubNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mái nʉri, arejame Jesús: —Yʉre dajocarĩ nʉrajaramu mʉja. Yʉre vaiquíyede Jʉ̃menijicʉ toivaicõjenejaquemavʉ, yópe arĩ: “Ovejavare coreipõecʉre boarĩ́ jarʉvacʉyʉmu yʉ. Aru coateni nʉrajarama na, ovejava”, arĩ toivaicõjenejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ʉbenita ji yainíburu yóboi, Jʉ̃menijicʉ ʉ̃i nacovaiyede yʉre yainore jarʉvarĩ, mʉje jipocai nʉcʉyʉmu Galileai, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Que ayʉre, Pedrocapũravʉ arĩdurejame ʉ̃́re: —Caivʉ apevʉ ne dajocarĩ nʉiyedeca, yʉ́capũravʉ mʉre jocarĩ nʉmecʉbu yʉ, arĩdurejame. ");
INSERT INTO cubNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aru Jesús arejame ʉ̃́re: —Jãve coyʉyʉbu mʉre: Cari ñami cáyu ʉ̃i órejaquiye jipocai, yóbecʉe baju “Jesúre yʉ coreóvabevʉ” acʉyʉmu mʉ, arejame Pedrore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ʉbenita Pedrocapũravʉ copʉ ayʉ barĩdurejame: —Mʉ́que yʉre ne boarĩ́ jarʉvaruta, “Jesúre yʉ coreóvabevʉ” abecʉbu yʉ, arĩdurejame Pedro. Aru ñʉja coapa nópe arĩdurejacarã. ");
INSERT INTO cubNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","No yóboi Jesús nʉrejame ñʉja ʉ̃i bueimaraque Getsemaní ãmicʉrõi. Nore earĩ, arejame ñʉjare: —Yui dobarĩ corejarã mʉja ji Jʉ̃menijicʉque boroteiyede ãnoi, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ñʉjacavʉ Pedrore aru ina pʉcarã Zebedeoi márare máre nʉvarejame Jesús. Chĩoñʉ baju ãmeno vaidéjamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Que teni arejamed̶a náre: —Yʉ ãmeno chĩori dápiaivʉ ji yaiquínore. Yui mauteni, jã́ri capʉjarã mʉja, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jipojĩca báque nʉñʉ Jesús, ñʉatutarĩ, mori tʉrejamed̶a joborõita. Aru Jʉ̃menijicʉque boroteyʉ barejámed̶a ʉ̃: —Mʉ, jipacʉ, yʉre cari vaiquíye vaibéjad̶eni. Caiyede d̶aiye majicʉtamu mʉ. Ʉbenita ji ʉrõpe d̶abejacʉ. Quénora mi ʉrõpe d̶ajacʉ mʉ, arejamed̶a jípacʉre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ina ʉ̃i bueimara yóbecʉrã ne yebai copainʉri, náre cãivʉre earejamed̶a Jesús. Aru arejamed̶a Pedrore: —¿Cũináorajĩe cãmevʉva coreiye majibenarʉ mʉja yʉ́que? arejamed̶a Pedrore. ");
INSERT INTO cubNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Caivʉ náre arejamed̶a: —Coreni, Jʉ̃menijicʉque borotejarã mʉja, abujuvai jabocʉ mʉjare jʉjovarĩ, ãmeina tede d̶abequiyepe aivʉ. Mʉje ũme ʉe parʉrõ mariduivʉ. Ʉbenita mʉje baju d̶aiye bajure parʉbevʉ mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cojedeca Jʉ̃menijicʉque borotecʉnʉrejamed̶a, yópe arĩ: —Mʉ, jipacʉ, yʉre cari vaiquíye jaʉru, mi ʉrõpe d̶ajacʉ mʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ʉ̃i bueimara yóbecʉrã ne yebai copainʉri, náre cãivʉre earejamed̶a Jesús cojedeca. Ãmei vʉo ijidejavʉ̃ya náre. ");
INSERT INTO cubNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Que baru Jʉ̃menijicʉque ʉ̃i boroteiye báquepedeca bedióva borotecʉnʉrejamed̶a, yóbecʉe borotecʉñʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Boroteni bʉojarĩ, ne yebai copainʉri, arejamed̶a náre: —¿Cãivʉrʉ̃ mʉja cãreja? Jede, quénoramu. Iora jave eaivʉ. Ijãravʉi dayʉ bácʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ãmeina teivʉ ne jẽni jínajimʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nacajajara mʉja. Copʉ nʉrajarevʉ. Yʉre ji mauvare jẽni jícʉyʉ daibi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ʉ̃i boroteiyedeca, edarejame Judas, ñʉjacacʉ, doce paivʉcacʉ. Obedivʉ põeva ʉ̃́que darĩ, boaicarovea aru boaidʉa dʉrʉrĩ edarejaima, sacerdotevare jaboteipõeva aru judíova bʉcʉva máre ne daroimara. ");
INSERT INTO cubNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, ñai Jesúre jẽni jícʉyʉ, ʉ̃i edaquiye jipocamia nore, javeta Jesúre boarĩ́ jarʉvaiyʉrivʉre coyʉrejamed̶a yópe: “Ji jacoyʉrĩ jiva nuimʉ macʉyʉ́me mʉje jẽnajimʉ. Ʉ̃́re jẽjara”, arejamed̶a náre Judas. ");
INSERT INTO cubNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jesús yebai nʉri, cũiná Judas ʉ̃́re earĩ, arejame: —Aru, bueipõecʉ, arejame Jesúre Judas. Que arĩ, ʉ̃́re jiva nuri jacoyʉrejame. ");
INSERT INTO cubNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Que teni Jesúcapũravʉ jẽniari jã́rejame Judare: —Mʉ, jícʉ, ¿aipe teni dacʉrʉ̃ mʉ? arejame Jesús. Que teiyede, Judaque edaivʉ bácavʉ Jesúre jẽnejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nópe teiyede jã́inata, ñʉjacacʉ cũinácʉ, Jesúque cʉrivʉcacʉ, ʉ̃i boaicarovede tatorĩ, duarĩ, ĩni, sacerdotevare jaboteipõecʉ ʉ̃i yebacacʉre juijórĩ, najuárejame ʉ̃i cámucare. ");
INSERT INTO cubNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nópe d̶ayʉre jã́ri, Jesús arejame ʉ̃́re: —Mi boaicarovede mead̶ajacʉ mʉ. Caivʉ boaicarovede ĩni, põevare boarã́jivʉ, yainájarama na boaicarovequedeca. ");
INSERT INTO cubNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Coreóvabenarʉ mʉja yʉre jipacʉ cad̶ateni bʉojayʉre? Ji jẽniaru jipacʉre, cũiná darojebu yʉre doce paiyajuboa ángeleva obedivʉ ne yajuboare, ne cad̶atenajiyepe ayʉ yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ʉbenita ji nópe d̶aru, vaibéjebu yópe Jʉ̃menijicʉi toivaicõjeiye báquepe ʉ̃i yávaiyede, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Dinʉmʉre Jesús arejame ina obedivʉ põevare: —¿Tatorĩ ñavaipõecʉre jẽivʉpe yʉre boaicaroveaque aru boaidʉaque jẽni jacorãdaivʉrʉ̃ mʉja? Jãravʉa coapa mʉje jẽneboi Jʉ̃menijicʉi cʉ̃rami bueyʉ batecácʉ yʉ. Apʉrĩ mʉjaque cʉcʉre, yʉre jẽni jacobeteavʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ʉbenita caiye iye vaivʉ yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ina ʉ̃i yávaiyede coyʉcaipõeva mácavʉre, arejame náre Jesús. Que tedurata ñʉja ʉ̃i bueimara ʉ̃́re jocarĩ, dupini nʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesúre Caifás yebai, ñai sacerdotevare jaboteipõecʉ yebai, nʉvarejaimad̶a na, ʉ̃́re jẽivʉ bácavʉ. Nore ina Jʉ̃menijicʉi yávaiye báquede bueipõeva aru judíova bʉcʉva ne baju cójijini borotenanʉrejaimad̶a ne jabova baju. ");
INSERT INTO cubNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Aru Pedrocapũravʉ joajĩenata Jesús yóboi nʉre nʉñʉ mácʉ, sacerdotevare jaboteipõecʉi tãibʉi ecorejamed̶a ʉ̃. Nore ecorĩ, Jʉ̃menijicʉi cʉ̃ramine coreipõevaque dobarejamed̶a ʉ̃, jã́cʉyʉ aipe vaiquíyede Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Na sacerdotevare jaboteipõeva aru caivʉ ne cójijinocavʉ Jesúre ãmecororãjivʉre vorĩdurejaimad̶a, ʉ̃́re boarĩ́ jarʉvaiyʉrivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ʉbenita obedivʉ Jesúre borocʉrĩ, ãmecororĩduivʉreca, eabedejaimad̶a na. No yóboi, pʉcarã darĩ, borocʉrĩ ãmecororejaimad̶a Jesúre: ");
INSERT INTO cubNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Ñai põecʉ yópe arĩ coyʉyʉre jápiacarã ñʉja: “Iñami Jʉ̃menijicʉi cʉ̃ramine jarʉvarĩ majivʉ yʉ. Yóbecʉrijãravʉa jarʉvarĩburu yóboi aped̶ãmi d̶acʉyʉmu”, áme Jesús, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Que teni ñai sacerdotevare jaboteipõecʉ nacajari, arejamed̶a Jesúre: —¿Coyʉrĩ majibecʉrʉ̃ mʉ? ¿Ne nópe ãmecoroiyede, aipe ayʉrʉ̃ mʉ? arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ʉbenita Jesúcapũravʉ bi arejamed̶a. Dinʉmʉ arejamed̶a Jesúre sacerdotevare jaboteipõecʉ: —Yʉ coyʉicõjeivʉ mʉre Jʉ̃menijicʉ apʉcʉ cʉe boje. ¿Mʉ́rʉ ñai Cristo, Jʉ̃menijicʉi mácʉ? Coyʉjacʉ ñʉjare, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Aru Jesús jʉ ayʉ arejamed̶a ʉ̃́re: —Quédeca mi aimʉtamu yʉ. Ʉbenita yʉ́capũravʉ coyʉyʉbu mʉjare: Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, yʉre, jã́rajaramu mʉja, Jʉ̃menijicʉ parʉcʉi meapũravʉi dobacʉre. Aru ji ocopeniboai jõd̶ari ẽmeiyede máre jã́rajaramu mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Que ayʉre, ñai sacerdotevare jaboteipõecʉ jorojĩni, ʉ̃i baju doiyede tatorĩ, jad̶evarĩ, arejamed̶a: —Ñai ʉ̃mʉ Jʉ̃menijicʉre copʉ ãmeina yávaibi. Quénora ʉ̃i ãmeina teiyede coyʉjarã mʉja. Apevʉ ne coyʉiye jaʉbevʉ. Javeta mʉja jápiad̶avʉ̃. Jʉ̃menijicʉ ʉbebi ñai yópe yávayʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Aipe ad̶arãrʉ mʉja? arejamed̶a ʉ̃. Aru arejaimad̶a na: —Boarĩ́ jarʉvaimʉ macʉyʉ́me ʉ̃, arejaimad̶a na caivʉ, ʉ̃́re boarĩ́ jarʉvaicõjeivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Que arĩ, ʉ̃i jivarã jẽcututurejaimad̶a na. Ʉ̃́re jara popedejaimad̶a. Aru pẽvavarejaimad̶a máre ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Aru arejaimad̶a: —Mʉ, Cristo, coyʉjacʉ ñʉjare. ¿Ñame matedí pẽvañʉ mʉre? ʉ̃́re pẽvavaivʉ arejaimad̶a na. Ʉbenita Jesúcapũravʉ ye coyʉbedejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro sacerdotevare jaboteipõecʉi tãibʉi dobacʉ barejámed̶a. Ʉ̃i noi dobaedeca, yebacarõmivacaco cũináco ʉ̃i yebai earejacod̶a. Aru arejacod̶a: —Mʉ máre ñai Jesús Galileacacʉque cʉ́tevʉ mʉ, arejacod̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ʉbenita caivʉ ne jápiaiyede, Pedrocapũravʉ jʉ abedejamed̶a ṍre: —¡Nácacʉ ãmevʉ! Jesúre yʉ coreóvabevʉ. ¿Aipe arĩ, mʉ que ad̶orʉ̃? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Que arĩ, tãibʉi etarĩ, jedevai nʉitenevei nʉrejamed̶a Pedro. Aru apeco yebacarõmivacaco ʉ̃́re jã́ri, arejacod̶a náre, nore cʉrivʉre coyʉyo: —Ñai cʉ́tebi Jesús Nazarecacʉque, arejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Aru bedióva cojedeca Pedrocapũravʉ jʉ abedejamed̶a: —¡Nácacʉ ãmevʉ! Jesúre yʉ coreóvabevʉ. Jʉ̃menijicʉ majibi jãve coyʉyʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","No yójĩboi ina nore cʉrivʉ Pedro yebai nʉri, arejaimad̶a ʉ̃́re: —Jãve mʉ máre nácacʉbu mʉ. Mi yávaiyeque majivʉ Galileacacʉre mʉre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Dinʉmʉma jãve ayʉpe, náre pare baju arĩ, coyʉrejamed̶a Pedro: —¡Jãveneca Jʉ̃menijicʉi jã́inoi yʉ mʉjare coyʉyʉtamu! ¡Jãve ji coyʉbedu, Jʉ̃menijicʉ ãmed̶ajacʉrĩ yʉre! Jesúre yʉ coreóvabevʉ, arejamed̶a. Ʉ̃i que aiye bajure, órejarejamed̶a cáyu. ");
INSERT INTO cubNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ʉ̃i órejaiyede, ãrʉrejamed̶a Pedro Jesús ʉ̃i coyʉiye báquede: “Cáyu ʉ̃i órejaquiye jipocai, yóbecʉe baju ‘Jesúre yʉ coreóvabevʉ’, acʉyʉmu mʉ”, arĩ coyʉiye báquede ãrʉrejamed̶a. Aru ãrʉcʉ, cũiná etarĩ, pare chĩori orejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Aviá ʉ̃i tucʉmʉiyede, caivʉ ina sacerdotevare jaboteipõeva aru judíova bʉcʉva cójijidejaimad̶a na, ne bajumia boroteni majicarãjivʉ aipe ne boarĩ́ jarʉvarãjiyede Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Boroteni bʉojarĩ, Jesúre bʉorĩ, nʉvari, jabocʉ ʉ̃i ãmiá Pilato yebai jacorãnʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, Jesúre jẽni jíyʉ bácʉ ʉ̃i mauvare, coreóvayʉ ne boarĩ́ jarʉvarãjiyede Jesúre, chĩoñʉ marejámed̶a ʉ̃. Chĩori dápiarĩ, oatʉvaiyʉrĩdurejamed̶a ʉ̃i d̶aiye báquede. Que baru iye tãutʉratʉrava treinta paitʉrava plataque d̶aitʉravare nʉvarejamed̶a ina sacerdotevare jaboteipõeva aru ina judíova bʉcʉva ne yebai. Diede náre nʉvari jacopaiyovacʉnʉridurejamed̶a Judas. ");
INSERT INTO cubNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ne yebai earĩ, arejamed̶a: —Yʉrecabu ãmeina teyʉ bácʉ. Jẽni jívʉ mʉjare põecʉ meacʉre, ãmeina d̶abecʉre. Que baru mʉje tãutʉrare, mʉje jíye báquede yʉre jẽni jíye bojede, jacopaiyovaquijivʉ mʉjare caride, arejamed̶a Judas. Ʉbenita nácapũravʉ arejaimad̶a ʉ̃́re: —Ye baquiyé ãmevʉ; míyetamura die, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Que aivʉre, Judacapũravʉ iye tãutʉrare dʉvarĩ jarʉvarejamed̶a Jʉ̃menijicʉi cʉ̃rami jívʉi. Aru etarĩ, nʉri, ʉ̃i ñamemure bʉorĩ, jocʉcʉ cavabʉi yuyurĩ boarĩ́ jarʉvarejamed̶a ʉ̃i baju. ");
INSERT INTO cubNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Die tãutʉrare ĩni, ina sacerdotevare jaboteipõeva arejaimad̶a ne bajumia: —Maje d̶aicõjeiyepe iye tãutʉrare epeicõjememaramu maja Jʉ̃menijicʉre jícaiyeque. Diedecabu bojed̶arĩ jíye báque põecʉre ʉ̃i boarĩ́ jarʉvare d̶aiyede apecʉ põecʉre. Que baru diede jíye jaʉbevʉ majare Jʉ̃menijicʉre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Que arĩ, ne baju boroteni majicarejaimad̶a. Boroteni bʉojarĩ, iye tãutʉraque jíni, jiore bojed̶arejaimad̶a. No jio jorod̶aipõecʉi jio bácarõ marejávʉ̃ya. “Apenocavʉ yaivʉ bácavʉre yore, ne yuarĩ jarʉvarãjinomu” arĩ, no jiore bojed̶arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","No jiore bojed̶arejaimad̶a tãutʉraque, põecʉ ʉ̃i jíye báque, apecʉ põecʉre boarĩ́ jarʉvaicõjecʉyʉ. Que baru aivʉbu maja “Jivecʉrõ” no jiore, pʉ caride máre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nópe vaidéjavʉ̃ya cũinátʉrʉ Jʉ̃menijicʉi coyʉicõjeiye báquepedeca ñai Jeremías ãmicʉcʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre. Yópe arĩ, toivaicõjenejaquemavʉ ʉ̃ mácʉre Jʉ̃menijicʉ: Ĩñama iye tãutʉratʉrava treinta paitʉrava plataque d̶aitʉravare. Apevʉ Israecavʉ bojed̶aicõjenejaquemavʉ nópe paiye bojede ʉ̃́re boje. ");
INSERT INTO cubNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iye tãutʉraque jíni bojed̶ad̶ama no jiore, jorod̶aipõecʉi jio bácarõre. Que teni yópe Jʉ̃menijicʉi d̶aicõjeino mácarõpedeca yʉre, d̶ad̶ama na, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús ʉ̃i eaiyede ñai jabocʉ Pilato yebai, núrejamed̶a ʉ̃i jipocai. Ñai jabocʉ jẽniari jã́rejamed̶a ʉ̃́re: —¿Mʉ́rʉ judíovai jabocʉ? arejamed̶a. Jesúcapũravʉ arejamed̶a: —Quédeca mi aimʉrecabu yʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ʉbenita ina sacerdotevare jaboteipõeva aru ina judíova bʉcʉva ne ãmecoroiyede ʉ̃́re, náre coyʉbedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dinʉmʉre Pilatocapũravʉ arejamed̶a ʉ̃́re: —¿Jápiabecʉrʉ̃ caiye ne ãmecoroiyede mʉre? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ʉbenita bi arejamed̶a Jesús. Caiye ne ãmecoroiyede ye coyʉbedejamed̶a ʉ̃. Aru ʉ̃i que yávabede cuecumañʉ ʉrarõ dápiarejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","No torojʉve teinʉmʉre, ñai jabocʉ Pilatocapũravʉ ʉjʉá coapa etavavarejamed̶a cũinácʉ jacoimʉ mácʉre, põeva ne etavaicõjeimʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dinʉmʉre, cũinácʉ ʉ̃i bʉoimaracacʉ, caivʉ ne coreóvaimʉ marejámed̶a, Barrabás ãmicʉcʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Que baru põeva obedivʉ ne cójijiyede Pilato yebai, náre yópe arĩ, jẽniari jã́rejamed̶a Pilato: —¿Ñamene etavaji yʉ? ¿Barrabáre ʉrivʉrʉ̃ mʉja? ¿O Jesúre, Cristo ne aimʉre, ʉrivʉrʉ̃ mʉja? arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ina sacerdotevare jaboteipõeva Jesúre ne jorojĩyede majini, obedivʉ põeva ne ʉe boje ʉ̃́re, nópe náre jẽniari jã́rejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato dobarejamed̶a nore, coyʉcʉyʉ ina põevare ñamene ʉ̃i etavaquimʉre. Coyʉbecʉ cãreja, ʉ̃i dobaedeca, jímarepaco ʉ̃́re yópe arĩ, boro jarorejacod̶a: “Ñai ʉ̃mʉ Jesúre ãmed̶abejacʉ mʉ. Ʉ̃́recabe meacʉ baju. Cari ñami marede decoboavʉ yʉ ʉ̃́re. Aru pare ʉrarõ cãrijivʉ yʉ, iye decoboaiye báque boje. Que baru me d̶ajacʉ mʉ” arĩ, boro jarorĩ majicarejacod̶a jímarepaco Pilatore. ");
INSERT INTO cubNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ina sacerdotevare jaboteipõeva aru ina judíova bʉcʉva máre ina obedivʉ põevare jẽniaicõjenejaimad̶a Pilatore, ʉ̃i etavaquiyepe aivʉ Barrabáre aru ʉ̃i boarĩ́ jarʉvaquiyepe aivʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Bedióva cojedeca ñai jabocʉ Pilato jẽniari jã́rejamed̶a ina põevare: —¿Ñamene ina pʉcarã bʉoimaracacʉre jaetovaji? arejamed̶a. Aru arejaimad̶a: —Barrabáre jaetovajacʉ mʉ, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ne que coyʉrĩburu, arejamed̶a náre Pilato: —¿Dinʉmʉ ñai Jesús, Cristo ne aimʉre, aipe d̶aji yʉ? arejamed̶a. Caivʉ ina põeva arejaimad̶a: —¡Ʉ̃́re jocʉcʉjaravena pẽvari boarĩ́ jarʉvaicõjejacʉ mʉ! arejaimad̶a ñai jabocʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Yéde ãmeina tearĩ ñai? jẽniari jã́rejamed̶a náre Pilato. Ʉbenita pʉeno baju cod̶oboborĩ, arejaimad̶a na: —¡Ʉ̃́re jocʉcʉjaravena pẽvari boarĩ́ jarʉvaicõjejacʉ mʉ! arĩ, cod̶oboborejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ne que aiyede, Pilato coreóvarejamed̶a ʉ̃́re jʉ abevʉre. Quédata pʉeno cãrijovari bʉ́rejaimad̶a na. Que baru ocoque joarejamed̶a ʉ̃i pʉrʉáre, yópe judíova ne d̶aiyepe, ne jã́d̶ovarajiyepe ayʉ boropatebevʉre. Ʉ̃i joaiyedeca arejamed̶a: —Yʉ́vacari boropatebecʉbu, mʉje boarĩ́ jarʉvaru ñai Jesúre, ʉ̃mʉ meacʉre ji jã́inoi. Mʉjemu die, arejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Aru caivʉ ina põeva arejaimad̶a: —Jaʉ, ñʉjavacari aru ñʉjemara máre boropatenajivʉbu ñai ʉ̃mʉ ʉ̃i yaiye boje, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ne que arĩburu yóboi, Barrabáre etavarĩ darorejamed̶a Pilato. Aru Jesúre jara popeicõjenejamed̶a. No yóboi, ina churaravare Jesúre jocʉcʉjaravena pẽvaicõjenejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Que teni ina churarava Jesúre ĩni, nʉvari, ecovarejaimad̶a ñai jabocʉ Pilatoi cʉ̃rami. Nore ecovarĩ, apevʉ churarava caivʉre cójijovarejaimad̶a Jesús jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ʉ̃i cuitótecajeare ʉ̃́re duarejaimad̶a. Jesúre pʉenocacaje, jabocʉi doicajepe paicaje ñemijuaricajede doarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Doarĩ bʉojarĩ, miumua cãteni, cainitarabʉ d̶arĩ, ʉ̃i jipobʉrã ditarabʉre tʉorejaimad̶a na. Aru jocʉyo, jabocʉi cõjeiyope paiyore, dʉrʉre d̶arejaimad̶a Jesúre ʉ̃i meapũravʉcapʉrʉi, yópe jabocʉi jẽiyepe. Ne que teimʉre yʉrivʉ, jacoyʉrejaimad̶a na: —Ména cʉjacʉ mʉ, judíovai jabocʉ, arejaimad̶a churarava Jesúre, ʉbenita ʉ̃́re yʉrivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ʉ̃́ra jẽcututuivʉ barejáimad̶a. Aru ʉ̃́re jipobʉrã iyo jocʉyoque jãd̶ovaivʉ barejáimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Que teni ʉ̃́re yʉrini bʉojarĩ, ʉ̃́re ne doicaje ñemijuaricaje bácarõre, no jabocʉi doicajepe paicajede ĩni, duarĩ, ʉ̃i doicaje bácarõre bedióva ʉ̃́re doarejaimad̶a cojedeca. Que teni, bʉojarĩ, ʉ̃́re nʉvari, jocʉcʉjaravena ʉ̃́re pẽvari jẽoranʉrejaimad̶a na, churarava. ");
INSERT INTO cubNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ina churarava Jesúque nʉivʉ, jocʉcʉjaravede ture nʉñʉ maridurejame Jesús. Nʉri, copʉrejaima cũinácʉ ʉ̃mʉre, Cirene ãmicʉriĩmarocacʉre, ʉ̃i ãmiá Simón. Ʉ̃́re Jesús ʉ̃i jocʉcʉjaravede tuino mácarõre tuicõjenejaima na, churarava. ");
INSERT INTO cubNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ina churarava nʉvarejaima Jesúre cʉ̃racũ Gólgota ãmicʉricũi. Põe jipobʉcũ aiyʉrõmu no. ");
INSERT INTO cubNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Noi ũcuiye upiáteiye báque cʉrijororʉ cʉrejavʉ̃ vino ʉ́yaicoro mirra ãmicʉe jocʉcʉ cuidóque, churarava ne nʉvaiye báquede. Die ũcuiyede jínidurejaima Jesúre, ʉ̃́re ijibequiyepe aivʉ. Ʉbenita ʉ̃ ũcuri jã́ri, ʉbecʉ, ũcumenejame. ");
INSERT INTO cubNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Que teni ʉ̃́re jocʉcʉjaravena pẽvari jẽorejaima. Aru ne yajuiyede dʉvarejaima. Cainijidʉa etaiyede jã́ri, Jesús ʉ̃i doiyede náre coapa ĩnejaima na, ʉ̃́re pẽvaivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Que teniburu yóboi, dobarejaima, jã́ri capʉrãjivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jocʉcʉjaravena ʉ̃i jipobʉ pʉenoi toivaino jẽnejavʉ̃, apevʉ ne majinajiyepe aino Jesúre boarĩ́ jarʉvaivʉ ne dápiainore, “¿Aipe teni ʉ̃́re boarĩ́ jarʉvarãma na?” ne aino. Yópe aiyʉrejavʉ̃ no toivaino: “Ñaime Jesús, judíovai jabocʉ”. ");
INSERT INTO cubNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ʉ̃́que máre pẽvari boarĩ́ jarʉvarejaima pʉcarã tatorĩ ñavaipõevare, ape pʉcarõa jocʉcʉjaravearã. Cũinácʉ Jesús ʉ̃i meapũravʉi aru apecʉ ʉ̃i cãcopũravʉi cʉrejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Ina vainánʉraivʉ jã́ri, ne jipobʉare cújiovarĩ, ãmeina yávarejaima ʉ̃́re, yópe arĩ: —Mʉ, Jʉ̃menijicʉi cʉ̃ramine jarʉvaiyʉvacacʉ aru yóbecʉrijãravʉa yóboi diñamine mead̶aiyʉvacacʉ, mi bajure mead̶ajacʉ mʉ. Mʉ Jʉ̃menijicʉi mácʉ baru, caride jocʉcʉjaravede dajocarĩ, ẽmeni, dajacʉ mʉ, arejaima Jesúre ina vainánʉraivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nopedeca ina sacerdotevare jaboteipõeva, ina Jʉ̃menijicʉi yávaiye báquede bueipõevaque, aru ina judíova bʉcʉvaque máre, ne baju yʉrivʉ Jesúre, yópe arejaima: ");
INSERT INTO cubNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Apevʉre mead̶avacacʉvacari, ʉbenita ʉ̃i bajure mead̶arĩ majibebi ʉ̃. Cristo, maja Israecavʉ maje jabocʉ baru, jocʉcʉjaravede dajocarĩ ẽmeni dajacʉrĩ ʉ̃. Que d̶aru, maja jʉ arãjaramu ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ʉ̃ “Yʉ́bu Jʉ̃menijicʉi mácʉ”, ayʉ bateáme. Ʉ̃́recabe jʉ ayʉ Jʉ̃menijicʉre aru “Jʉ̃menijicʉ yʉre cad̶atecʉyʉme”, arĩ dápiayʉ. Que baru Jʉ̃menijicʉ, ʉ̃́re ʉcʉ baru, cad̶atejacʉrĩ caride, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Aru ina pʉcarã tatorĩ ñavaipõeva pẽvaimara mácavʉ máre ʉ̃́que, nopedeca ãmeina yávarejaima ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jãravʉ corica baji ñemié tʉrĩ darejavʉ̃ caino joborõi. Pʉ yóbecʉriora yóboita vaidéjavʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aru yóbecʉriora bajita, iye ñemié tʉiyede dajocaiyede pare bʉjié cod̶oboborĩ, yávarĩ darorejame Jesús: —Elí, Elí, ¿lama sabactani? Nópe aino: “Mʉ, ji mearore jímʉ, mʉ, Jʉ̃menijicʉ, ¿aipe teni yʉre dajocarĩ, nʉñʉrʉ mʉ?” aiyʉrõ marejávʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Que ayʉre, apevʉ nore núrivʉcavʉ ʉ̃́re jápiarĩ, ʉbenita jápiarĩ eabeni, arejaima: —Jápiajarã. Elíare órejaibi ʉ̃, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dinʉmʉre maumena nácacʉ cúyarĩ, jaʉbore ĩni, ʉyovarejame vino ʉ́yaicoro upiáricoroque. Aru dijaʉ́bore abod̶orã bʉorĩ, jẽori, jarʉrʉrejame Jesús ʉ̃i ũcuquiyepe ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ʉbenita apevʉ arejaima: —Corejarã. Jã́rajarevʉ Elías jõd̶avacʉdayʉre ʉ̃́re, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cojedeca Jesús pare bʉjié cod̶oboborĩ, yaidéjame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dinʉmʉ ʉ̃i yaitʉ́vabomica Jʉ̃menijicʉi cʉ̃ramicacaje ʉracaje coricõpavaicaje bácarõ quéda corica baji jad̶eni nʉrejavʉ̃ya, pʉenocatʉrʉvai bʉ́rĩ pʉ cãchinocatʉrʉvaita. Joborõ cújidejavʉ̃. Aru cʉ̃raboa ʉraboa pãrejavʉ̃ máre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yaivʉ bácavʉ ne jarʉvainoa voarejavʉ̃ya. Obedivʉ Jʉ̃menijicʉi põeva yaivʉ bácavʉ nacovaimara marejáimad̶a na, apʉrãjivʉ bedióva cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aru ina nacovaimara mácavʉ ne jarʉvainoare jocarĩ etarejaimad̶a, Jesús ʉ̃i nacajariburu yóboi. Etarĩ bʉojarĩ, Jerusalén ãmicʉriĩmaroi ecorejaimad̶a. Obedivʉ põeva jã́rejaimad̶a náre, yaivʉ bácavʉ nacovaimara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nore Jesús bácʉre cocorĩ núrivʉ barejáima apevʉ churarava ne jabocʉque. No joborõ cújinore jã́ri, aru caiye iye vaiye jidojaede máre, pare dápiaivʉ cuecumarejaima. Aru arejaima: —Jãveneca Jʉ̃menijicʉi mácʉ baju batecʉ́be ñai, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Obedivʉ nomiva máre cocorĩ núrivʉ joajĩemia cʉrejaima. Ne jẽneboi cʉrejaima cũináco nomió, Magdala ãmicʉriĩmarocaco, õi ãmiá María, aru apeco nomió, õi ãmiá María máre, ico Santiago aru José népaco, aru apeco máre, Zebedeoi márai paco. Jesús ʉ̃i cʉede Galilea ãmicʉrõi cad̶ateivʉ barejáima ʉ̃́re. Aru apevʉ nomiva, ina daivʉ bácavʉ ʉ̃́que Jerusalén ãmicʉriĩmaroi, cʉrejaima nore. ");
INSERT INTO cubNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dijãravʉ bácarõ, nainú, aviá ʉ̃i dorĩburu yóboi, cũinácʉ ʉ̃mʉ nʉrejamed̶a Pilato yebai. Ʉ̃ marejámed̶a cʉve cʉvacʉ, Arimatea ãmicʉriĩmarocacʉ, ʉ̃i ãmiá José. Ʉ̃ máre Jesús bácʉi bueimaracacʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato yebai nʉri, Jesús bácʉi baju bácarõre jẽniacʉnʉrejamed̶a ʉ̃. Ʉ̃i jẽniaiyede Pilato churaravacavʉre jícõjenejamed̶a Jesús bácʉi baju bácarõre ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Aru Jesús bácʉre jocʉcʉjaravede jõd̶avari, ĩni, meacaje docʉcʉbecaje lino ãmicʉricajeque ʉ̃ mácʉre cũmarejaimad̶a Joséjã. ");
INSERT INTO cubNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ʉ̃ mácʉre nʉvari, cʉ̃racobe mamacobe, José jicobei, Jesús bácʉre jarʉvarejaimad̶a Joséjã. Nore jarʉvarĩburu yóboi, apetʉrava cʉ̃ratʉravare ĩni, jãturuvari, dicobede biedejaimad̶a. Aru bieniburu yóboi, nʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne Jesús bácʉre jarʉvaiyede cʉrejaimad̶a nore María Magdalacaco aru apeco María máre, dobarivʉ dicobe jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Dijãravʉ yóbocajãravʉi, maja judíova maje jabʉóvaijãravʉ sábadoi, ina sacerdotevare jaboteipõeva aru fariseovacavʉ cójijidejaimad̶a Pilato yebai. ");
INSERT INTO cubNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Aru ʉ̃́re arejaimad̶a: —Mʉ, ñʉje jabocʉ, ãrʉrivʉbu ñʉja ñai jʉjovayʉ bácʉ ʉ̃i aiyede apʉcʉ cãreja, yópe arĩ: “Yóbecʉrijãravʉa ji yainíburu yóboi nacajacʉyʉmu yʉ yainore jarʉvarĩ”, ayʉ bateáme. ");
INSERT INTO cubNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Que baru churaravare me jã́ri coreicõjejacʉ mʉ Jesús bácʉi baju bácarõre ne jarʉvainore yóbecʉrijãravʉa vaiyeta. Nópe d̶ajacʉ, ʉ̃i bueimara ne ñavamenajiyepe ayʉ ʉ̃ mácʉi baju bácarõre ñamine. Ʉ̃ mácʉi baju bácarõre ñavaivʉ baru, “Jesús nacajaimi yainore jarʉvarĩ”, arĩ coyʉrãjarama põevare. Nópe d̶aivʉ baru, ãmei jʉjovajebu põevare ne mamarʉmʉ jʉjovaiye báque pʉeno. Ʉ̃ mácʉi “Nacajacʉyʉmu” ʉ̃i aiye báqueque põevare jʉjovarĩduame. Ʉbenita “Nacajaimi” ne ájʉroeque, põevare jãve jʉjovajebu, arejaimad̶a na Pilatore. ");
INSERT INTO cubNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatocapũravʉ arejamed̶a náre: —Churaravare cʉvavʉ mʉja. Náre jarorĩ me coreicõjejara Jesús bácʉi baju bácarõre ne jarʉvainore, arejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Que baru churaravare jarorĩ, cʉ̃ratʉrava ʉratʉrava Jesús bácʉre jarʉvaicobede bieitʉravare me jãjare d̶aicõjenejaimad̶a na. Aru ditʉravare jãjare d̶arĩburu yóboi, no ne jarʉvainore me jã́ri coreicõjenidurejaimad̶a churaravare. ");
INSERT INTO cubNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","No judíovai jabʉóvaijãravʉ sábado yóbocajãravʉ, sumana bʉijãravʉ, domingo, miad̶áe tʉquiye jipocai, María Magdalacaco apeco Maríamaque jã́ranʉrejaimad̶a Jesús bácʉi baju bácarõre ne jarʉvainore. ");
INSERT INTO cubNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Aru ʉrarõ baju joborõ cújidejavʉ̃ya, ángele ʉ̃i ẽmeni daiye boje cavarõ mearo Jʉ̃menijicʉi cʉrõre jocarĩ. Ñai ángele, Jʉ̃menijicʉi daroimʉ, ẽmeni, darĩ jãturuvarejamed̶a diva cʉ̃rava ʉravare, no cʉ̃racobede bieitʉrava bácarõre. Ditʉravare ʉ̃i jãturuvariburu yóboi, dobarejamed̶a ditʉrava pʉenora. ");
INSERT INTO cubNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ñai ángele pẽoñʉpe páyʉ ãrojacʉ barejámed̶a, yópe yaroinope. Ʉ̃i cuitótecaje boricaje baju barejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ʉ̃́re jã́ivʉ, ina churarava dicobede jã́ri coreniduivʉ jidʉrivʉ bididejaimad̶a, ne jidʉé boje. Bidini, tʉrejaimad̶a joborõi, yópe yaivʉ bácavʉpe. ");
INSERT INTO cubNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Aru ñai ángele arejamed̶a ina nomivare: —Jidʉbejarã mʉja. Coreóvaivʉ yʉ voivʉre Jesúre, ne jocʉcʉjaravena pẽvaimʉ mácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yore cʉbebi ʉ̃. Javeta nacajami, yópe ʉ̃i aiye báquepedeca. Dajarã. Jã́rijide apa. Ʉ̃i baju bácarõre ne jarʉvaino mácarõre jã́jara mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Maumena nʉjara mʉja. Yópe arĩ, coyʉjarã ʉ̃i bueimarare: “Jesús nacajaimi yainore jarʉvarĩ. Nʉcʉyʉme mʉje jipocai Galilea ãmicʉrijoborõi. Noi jã́rajaramu mʉja ʉ̃́re”, coyʉjarã. Jede, quénoramu ji coyʉino mʉjare, arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Que arĩburu yóboi, maumejiena dicobede etarĩ, nʉrejaimad̶a ina nomiva, jidʉrivʉ ʉbenita pare torojʉrivʉ. Cúyarĩ coyʉrãnʉrejaimad̶a iye borore ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ne nʉiyede, Jesúvacari náre copʉrejamed̶a. Aru náre jacoyʉrejamed̶a. Ʉ̃i yebai nʉri, mori tʉrejaimad̶a joborõi ʉ̃i jipocai. Aru ʉ̃i cʉbobare jẽni, mearore jídejaimad̶a ʉ̃́re, yópe judíova ne d̶arĩ cõmajiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Que teni Jesús arejamed̶a náre: —Jidʉbejarã mʉja. Jívʉre yópe arĩ, coyʉrãnʉjara mʉja, “Galileai nʉri, noi yʉre jã́ranʉjara mʉja, aibi Jesús”, náre ajarã mʉja, arejamed̶a dinomivare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ina nomiva ne nʉiyedeca, apevʉ ina churarava, Jesús bácʉi baju bácarõre jã́ri coreniduivʉ bácavʉ, Jerusalén ãmicʉriĩmaroi nʉrejaimad̶a. Coyʉrãnʉrejaimad̶a ina sacerdotevare jaboteipõevare caiye iye vaiye báquede náre. ");
INSERT INTO cubNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ina churarava ne coyʉiyede jápiaivʉ bácavʉ, ina sacerdotevare jaboteipõeva ina judíova bʉcʉvaque cójijidejaimad̶a, majicarãjivʉ ne bajumia. Cójijini bʉojarĩ, ʉrarõ tãutʉrare jídejaimad̶a ina churaravare. ");
INSERT INTO cubNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Aru yópe arĩ, borocʉicõjenejaimad̶a náre: —Yópe ajarã mʉja põevare, “Jesús bácʉi bueimara ñamine darĩ, ñʉje cãiyede, ñavarama ʉ̃ mácʉi baju bácarõre”, ajarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aru ñai jabocʉ ʉ̃i jápiaru diede, “Ina churarava boropateivʉbu ne jã́ri corebe boje” arĩ dápiaru, ñʉjavacari mead̶arãjaramu caiyede ʉ̃́que, ʉ̃i ñájine d̶abequiyepe aivʉ mʉjare, arejaimad̶a ina judíovai jabova. ");
INSERT INTO cubNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Que baru iye tãutʉrare ĩni, borocʉrĩ coyʉrejaimad̶a ina churarava, yópe ina sacerdotevare jaboteipõeva ne coyʉicõjeiye báquepe. Aru no coyʉino borocʉrõre coyʉvaivʉbu judíova ne bajumia pʉ caride máre. ");
INSERT INTO cubNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ñʉja once paivʉ Jesúi bueimara Galilea ãmicʉrijoborõi nʉrejacarã. Yópe Jesús ʉ̃i nʉicõjeiye báquepe, cʉ̃racũi nʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Noi ʉ̃́re jã́ri, mearore jídejacarã. Ʉbenita apevʉ ñʉjacavʉ, “Jesús ãmemi” arĩ, jʉ abedejaima. ");
INSERT INTO cubNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aru Jesús arejame ñʉjare: —Caiye parʉéde cʉvavʉ yʉ. Jipacʉ Jʉ̃menijicʉ parʉre d̶aibi yʉre, ji cõjequiyepe ayʉ caivʉ cavarõ mearocavʉre aru caivʉ ijãravʉcavʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Que baru jaroivʉ yʉ mʉjare. Buenanʉjara caivʉ ijãravʉcavʉre ji yávaiye méne, ne jʉ arãjiyepe aivʉ diede, aru ne d̶arãjiyepe aivʉ ji ʉrõre. Ocoque jã́d̶ovajara ina jʉ aivʉre jipacʉ Jʉ̃menijicʉre; aru yʉre, Jʉ̃menijicʉi mácʉre; aru ñai Espíritu Santore máre. ");
INSERT INTO cubNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Buejarã náre, ne d̶arãjiyepe aivʉ caiyede yópe ji d̶aicõjeiye báquepe mʉjare. Aru yʉ́vacari cʉcʉyʉmu mʉjaque cainʉmʉa, pʉ ijãravʉ bʉojaiyeta, arejame ñʉjare Jesús. Quénoramu.");
INSERT INTO cubNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yópeda teni bʉ́rejaquemavʉ iye yávaiye me Jesucristo Jʉ̃menijicʉi mácʉrã coyʉiye. ");
INSERT INTO cubNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Javede toivarejaquemavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ ʉ̃i ãmiá Isaías, yópe Jʉ̃menijicʉi aiye báquede mamacʉre: Jaroivʉ yʉre coyʉcaipõecʉre mi jipocai, mi cuimare mead̶aquiyepe ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jʉ̃menijicʉre coyʉcaipõecʉ cod̶oboboyʉre jápiarãjarama põecʉbenoi: “Mead̶ajarã mʉje ũmene copʉ etaburĩ maje jabocʉre, nopedeca mʉje mead̶aiyepe daimare ñai ʉ̃mʉ, mʉje pued̶aimʉ, ʉ̃i daquiye jipocai”, arejaquemavʉ Jʉ̃menijicʉ, arĩ toivarejaquemavʉ Isaías bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nópe Jʉ̃menijicʉi yávaiyede coyʉcayʉ, Isaías bácʉ, ʉ̃i aiye báquepedeca tedejaquemavʉ Juan Bautista põecʉbenoi. Põeva vaivʉre coyʉre curejamed̶a nore. Ocoque jã́d̶ovacʉyʉ põevare Jʉ̃menijicʉque, coyʉyʉ barejámed̶a põevare, ne chĩori dápiarãjiyepe ayʉ ne ãmeina teiyede, Jʉ̃menijicʉi ãrʉmetequiyepe ayʉ diede. ");
INSERT INTO cubNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Obedivʉ põeva Judea ãmicʉrijoborõcavʉ aru Jerusalén ãmicʉriĩmarocavʉ máre jápiarãnʉrejaimad̶a Juan Bautista yebai. Aru na coapa “Ãmecʉbu yʉ” ne arĩburu yóboi Jʉ̃menijicʉre, ne chĩori dápiaiye boje ne ãmeina teiyede, jã́d̶ovarejamed̶a náre Jʉ̃menijicʉque Jordán ãmicʉriya jiai. ");
INSERT INTO cubNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan Bautista dorejamed̶a ãimacʉ camello ãmicʉcʉi pod̶aque d̶aicajede ʉ̃i cuitótecaje. Aru ʉ̃i jãrióicãva máre ãimacajeque d̶aicãva marejávʉ̃ya. Ʉ̃ ãre curejamed̶a mujuñuvare aru mumicorore máre, yópe apevʉ nócavʉ cʉve cʉvabevʉpe. ");
INSERT INTO cubNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yópe arĩ, coyʉrejamed̶a põevare: —Dacʉyʉme ji yóboi cũinácʉ, ji pʉeno parʉcʉ. Que baru caivʉ pʉeno meacʉ bajube ʉ̃. Bʉojabevʉ yʉ oarĩ nacachini duayʉ ʉ̃i cʉraidoa bʉoimeare. ");
INSERT INTO cubNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yʉ ocoque jã́d̶ovaivʉ mʉjare Jʉ̃menijicʉre. Ʉbenita ʉ̃ macʉyʉ́me jã́d̶ovañʉ mʉjare Jʉ̃menijicʉque, daroyʉ Espíritu Santore, arejamed̶a Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Dijãravʉai Jesús nʉrejamed̶a Nazaret ãmicʉriĩmarore jocarĩ, etacʉyʉ Galilea ãmicʉrijoborõre jocarĩ, nʉñʉ Juan Bautista yebai. Aru Juan Bautista jã́d̶ovarejamed̶a ʉ̃́re Jʉ̃menijicʉque Jordán ãmicʉriya jiai. ");
INSERT INTO cubNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Maumena ʉ̃i maiyede jiare jocarĩ, Jesús jã́rejamed̶a cavarõ mearo vorĩ nʉinore. Aru ñai Espíritu Santo jurecope ẽmeni darejamed̶a ʉ̃i pʉenora. ");
INSERT INTO cubNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aru jápiarejamed̶a apeno yávainore, cavarõ mearo Jʉ̃menijicʉi cʉrõque aiyede yópe: “Mʉ, jímacʉ, ji ʉmʉ, me torojʉvʉ yʉ mʉre”, arejamed̶a Jesúre Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","No yóboi ñai Espíritu Santo nʉvarejamed̶a Jesúre põecʉbenoi. ");
INSERT INTO cubNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cuarenta paijãravʉa Jesús cʉrejamed̶a nore, ãimara jijecʉrivʉ ne jẽneboi. Que teni ñai abujuvai jabocʉ, Satanás ãmicʉcʉ, jʉjovaiyʉrĩdurejamed̶a ʉ̃́re. Aru ángeleva coreni cad̶atedejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Dinʉmʉre Herodes ãmicʉcʉ jabocʉ bʉorejamed̶a Juan Bautistare. Ʉ̃́re bʉorĩburu yóboi, Jesús nʉrejamed̶a Galilea ãmicʉrijoborõi, coyʉcʉyʉ iye yávaiye méne, Jʉ̃menijicʉi coyʉicõjeiyede ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Que teni arejamed̶a põevare: —Jave eaivʉ dijãravʉ. Maumena Jʉ̃menijicʉ mʉjare jabotecʉyʉme. Que baru chĩojara mʉje ãmeina teiyede. Oatʉvajarã mʉje d̶aiyede. Aru jʉ ajarã iye yávaiye méne, Jʉ̃menijicʉi coyʉcaiyede mʉjare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","No yóboi Jesús cuyʉ macajitabʉ ʉrabʉ Galilea ãmicʉrijitabʉ ẽcarʉi, jã́rejamed̶a Simóre aru Andrés ĩmacʉmaquevʉre. Moa boarĩ́ bojed̶aipõeva marejáimad̶a na. Que baru dʉvaivʉ barejáimad̶a ne pápicʉre no macajitabʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ne que teiyede, Jesús arejamed̶a náre: —Dajarã yʉ́que. Aru epequijivʉ mʉjare, mʉje davarãjiyepe põevare ji yebai, yópe mʉje moare davaiyepe pápicʉque, ji mead̶aquiyepe náre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Que ayʉre jápiarĩ, dajocarejaimad̶a ne pápicʉare, nʉrajivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aru cuyʉ cãreja, jipocai jã́rejamed̶a Zebedeoi márare, ne ãmiá Santiago aru ĩmacʉ Juan. Ĩmarejaimad̶a ne jiad̶ocũi, mead̶aivʉ ne pápicʉare. ");
INSERT INTO cubNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jã́rina cuturejamed̶a náre. Quénora cũiná dajocarejaimad̶a népacʉre ʉ̃́re memecaipõevaque jiad̶ocũi, nʉrajivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús ʉ̃i bueimaraque earejaimad̶a Capernaum ãmicʉriĩmaroi judíovai jabʉóvaijãravʉ sábadoi. Judíovai cójijiñami ecorĩ, Jesús buedejamed̶a ina põeva noi cʉrivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ina Jʉ̃menijicʉi yávaiye báquede bueipõeva pʉeno buedejamed̶a náre, yópe parʉcʉpe. Que baru ina jápiaivʉ ʉ̃i bueiyede torojʉrĩ cuecumarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aru cʉrejamed̶a judíovai cójijiñami cũinácʉ ʉ̃mʉ, abujucʉ ʉ̃i ĩmamʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Cod̶oboborĩ arejamed̶a Jesúre: —Mʉ, Jesús Nazarecacʉ, ¿yéde ʉcʉrʉ̃ mʉ ñʉjaque? ¿Jarʉvacʉdayʉ dacʉrʉ̃ mʉ ñʉjare? Coreóvaivʉ yʉ mʉre. Jʉ̃menijicʉi mácʉ meacʉ bajubu mʉ, arĩ cod̶oboborejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ʉbenita Jesús bi aicõjenejamed̶a ʉ̃́re: —Mʉ, bída etajacʉ ñai ʉ̃mʉre jocarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Que baru abujucʉ bidióvarejamed̶a pare ñai ʉ̃mʉre. Cod̶oboborĩ pare, etarejamed̶a ʉ̃́re jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aru cuecumari jã́ivʉ ina põeva, arejaimad̶a ne bajumia: —¿Yéba yo? ¿Ye bueiye mamaema iye? Ʉ̃i yávaiye parʉéque jarʉvaibi abujuvare. Aru nácapũravʉ jʉ ad̶ama ʉ̃́re, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aru maumejiena majidejaimad̶a Jesúi borore caino Galilea ãmicʉrijoborõcavʉ caivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Etaivʉ bácavʉ judíovai cójijiñamine jocarĩ, ecorãnʉrejaimad̶a maumena ne cʉ̃rami ina Simón aru Andrés máre. Santiago aru Juan máre yóvarejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ico Simói váco moimo pararejacod̶a. Aru cũiná coyʉrejaimad̶a Jesúre õi borore. ");
INSERT INTO cubNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Que baru Jesús nʉrejamed̶a õi yebai. Jẽni õi pʉrʉre, ṍre nacovarejamed̶a. Aru maumejiena dajocarejavʉ̃ya moino ṍre. Dinʉmʉmia ãiyede mead̶arĩ jídejacod̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Dinainumica ñamijie baji aviá ʉ̃i dorĩburu yóboi, jabʉóvaijãravʉ vaiyede, ina ĩmarocavʉ nʉvarejaimad̶a Jesús yebai caivʉ ijimarare, aru abujuva ne ĩmamarare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Que teni caivʉ ina ĩmarocavʉ cójijidejaimad̶a jedevacobena. ");
INSERT INTO cubNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús mead̶arejamed̶a obedivʉ ijimarare. Caiye ijiéde jarʉvarejamed̶a. Jarorejamed̶a náre jocarĩ ina abujuvare máre. Aru yávare d̶abedejamed̶a, ne coreóvaiye boje ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesús coedarĩ nacajari ñeminomia, aviá ʉ̃i cõaquiye jipocai, nʉrejamed̶a põecʉbenoi. Jẽniare cuyʉ barejámed̶a Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Miad̶áe tʉiyede Simón ʉ̃́cavʉque vorejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Vorĩ earĩ, arejaimad̶a ʉ̃́re: —Caivʉ põeva vod̶ama mʉre, arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Náre arejamed̶a: —Jã́rica, apenoa ĩmaroa joabenoai nʉrevʉ, coyʉrãjivʉ Jʉ̃menijicʉi yávaiyede noi. Que baru daivʉ yʉ, coyʉcʉdayʉ diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Coyʉrejamed̶a Jʉ̃menijicʉi yávaiyede caino Galilea ãmicʉrijoborõi judíovai cójijiñamiai. Aru jaetovarejamed̶a abujuvare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Cũinácʉ pojeyʉ nʉrejamed̶a Jesús yebai. Aru ñʉatutarĩ, arejamed̶a ʉ̃́re: —Mʉ ʉcʉ baru, mead̶ajacʉ ji pojeiyede. Bʉojaivʉ mʉ mead̶ayʉ yʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Que ayʉre jápiarĩ, Jesús cõmaje ãroje jã́ri, ʉ̃i pʉrʉque jabióvarĩ tʉoyʉ, arejamed̶a ʉ̃́re: —Ʉvʉ yʉ. Caride meatejacʉ mʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Maumejiena Jesús ʉ̃i que aiyeda vaidéjavʉ̃ya ʉ̃́re. Meatedejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ʉbenita Jesús majicarejamed̶a parʉrõreca, “Nʉjacʉ” ayʉ ʉ̃́re, arejamed̶a majicarĩduyʉ: ");
INSERT INTO cubNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Coyʉbejacʉ apevʉre. Cũiná nʉri, jã́d̶ovajacʉ sacerdotede. Aru jíjacʉ mi meateiye boje, yópe Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquepe Moisés bácʉre, põeva ne coreóvarãjiyepe ayʉ mi meateinore, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ʉbenita coyʉre nʉrejamed̶a Jesúi borore. Que baru ecorĩ majibedejamed̶a Jesús põeva ne jã́inore. Quénora cʉrejamed̶a põecʉbenoi. Aru nʉrejaimad̶a põeva, cainoa ĩmaroacavʉ, ʉ̃i yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ecorejamed̶a Jesús cojedeca Capernaum ãmicʉriĩmaroi obedijãravʉa yóboi. Jápiarejaimad̶a cʉcʉre cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Que baru cójijidejaimad̶a obedivʉ põeva. Buiní jajidejaimad̶a jedevacobeita. Aru Jesús coyʉrejamed̶a Jʉ̃menijicʉi yávaiyede náre. ");
INSERT INTO cubNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Dinʉmʉ yóvaicʉvaivʉ ʉ̃mʉva nʉvarejaimad̶a ʉ̃i yebai cũinácʉ ʉ̃mʉ nacajaiye majibecʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ʉbenita ecoivʉ bʉojabedejaimad̶a Jesús yebai, põeva obedivʉ ne cʉe boje. Que baru mʉri nʉri cʉ̃rami pʉenora, voarejaimad̶a diede, ẽmeóvarajivʉ ñai nacajaiye majibecʉre ʉ̃i parainoque Jesús yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Náre coreóvayʉ jʉ aivʉre, Jesús arejamed̶a ñai nacajaiye majibecʉre: —Mʉ, ji ʉmʉ, mi ãmeina teiyede jarʉvarĩ ãrʉmeteivʉ yʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Noi dobarejaimad̶a obebevʉ Jʉ̃menijicʉi yávaiye báquede bueipõeva, dápiaivʉ ne d̶aiyʉrõre: “¿Aipe teni que yávayʉba ñai? Jʉ̃menijicʉi ʉbenore d̶aibi ʉ̃. ¿Ñamema bʉojarĩ jarʉvayʉ ãmeina teiyede, ãrʉmeteni diede? Quénora cũinácʉrabe Jʉ̃menijicʉ jarʉvayʉ diede” arĩ, dápiarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús jã́ri coreóvarĩ maumejiena ne baju ne dápiaiyede, jẽniari jã́rejamed̶a náre: —¿Aipe teni que arĩ dápiaivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Maiyójabevʉ yópe aru apecʉre, “Mi ãmeina teiyede jarʉvarĩ ãrʉmeteivʉ yʉ”, ji parʉéde jã́d̶ovame boje, ji que coyʉiyede. Ʉbenita maiyójarõtamu nacajari cuicõjenu nacajaiye majibecʉre. Ʉ̃́re cure d̶ayʉ baru, jã́d̶ovaquijivʉ ji parʉéde. “Mi ãmeina teiyede jarʉvaivʉ” ji aiyede, coreóvabevʉ mʉja Jʉ̃menijicʉi ãrʉmeteinore diede. Ʉbenita ñai cʉvacʉ Jʉ̃menijicʉi majié parʉéde, ʉ̃́rame yópe d̶arĩ jã́d̶ovaiye majicʉ. Quécʉra Jʉ̃menijicʉvacari mead̶arĩ majibi ijimarare. ");
INSERT INTO cubNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Que baru mʉje majinajiyepe ayʉ Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, yʉ, parʉéde cʉvacʉre ijãravʉre, jarʉvacʉyʉ ãmeina teiyede, yópe d̶aquijivʉ yʉ, arejamed̶a Jesús. Dinʉmʉ arejamed̶a nacajaiye majibecʉre: —Yópe aivʉ yʉ mʉre, nacajari, mi parainore ĩni, nʉjacʉ mi cʉ̃rami, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dinʉmʉma nacajari maumejiena, ʉ̃i parainore ĩni, etarejamed̶a ne jẽneboi. Caivʉ cuecumari, mearore jídejaimad̶a Jʉ̃menijicʉre. Aru, “Aipinʉmʉ jã́meteavʉ̃ maja yópe painore”, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","No yóboi Jesús nʉrejamed̶a cojedeca macajitabʉ ʉrabʉ ẽcarʉi. Caivʉ põeva nʉrejaimad̶a ʉ̃i yebai. Aru bueyʉ barejámed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Dinʉmʉre vainí nʉñʉ jã́rejamed̶a Levíde, Alfeoi mácʉre, dobacʉre ʉ̃i memeitucubʉi, põeva ne Roma ãmicʉrõ jaboteino bojed̶ainoi. Aru arejamed̶a ʉ̃́re: —Dajacʉ yʉ́que, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nacajari nʉrejamed̶a Jesúque. Aru obedivʉ põeva nʉrejaimad̶a ʉ̃i yóboi. Que teni Jesús ʉ̃i ãcʉnʉiyede Leví cʉ̃rami, obedivʉ jabovare tãutʉra ĩcaipõeva, ãmeno d̶aipõeva, aru ʉ̃i bueimara máre dobarejaimad̶a, ãrajivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Apevʉ judíova, d̶aicõjeiyede d̶aiye cõmajivʉ, fariseo ãmicʉriyajubocavʉ, cʉrejaimad̶a nore. Ina fariseovacavʉ, Jʉ̃menijicʉi yávaiye báquede bueipõeva, Jesús ãñʉre jã́ri, ina jabovare tãutʉra ĩcaipõevaque aru ãmeno d̶aipõevaque máre, arejaimad̶a ʉ̃i bueimarare: —¿Aipe teni ãñʉma jabovare tãutʉra ĩcaipõevaque aru ãmeno d̶aipõevaque máre? jẽniari jã́rejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Que aivʉre jápiarĩ, Jesús arejamed̶a: —Meara põevare jʉoipõecʉi cad̶ateiye jaʉbevʉ. Quénora ijimarare ʉ̃i cad̶ateiye jaʉvʉ. Dabedejacacʉ yʉ ijãravʉi, cutucʉyʉ mearare ne baju dápiainore. Quénora darejacacʉ yʉ, mead̶acʉyʉ ãmenare, ne chĩorajiyepe ayʉ ne ãmeina teiyede, Jʉ̃menijicʉi ãrʉmetequiyepe ayʉ diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Dinʉmʉ Juan Bautistai bueimara aru fariseovai bueimara máre ne jẽniaiyede Jʉ̃menijicʉque ãmenejaimad̶a ãiyede. Aru põeva earĩ, jẽniari jã́rejaimad̶a Jesúre: —¿Aipe teni Juan Bautistai bueimara aru fariseovai bueimara máre ãmevʉba ãiyede, ʉbenita mi bueimara ãmevʉ ãmema ãiyede? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús arejamed̶a náre: —Ina pʉrʉbʉoyʉ ʉ̃i cutuimara, ne torojʉve tenajiyepe ayʉ ʉ̃i pʉrʉbʉoiyede, ye ãmevʉ ãmema ãiyede ʉ̃i cʉede cãreja náque. Nopedeca ji bueimara torojʉrivʉ ji cʉede náque, ãmevʉ ãmema ãiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ʉbenita ji mauva ne nʉvarajiyede yʉre, ji bueimara chĩoivʉ ãmenajarama ãiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Cojedeca Jesús buedejamed̶a náre: —Põeva jẽomema cuitótecaje mamacaje joabecajei javecarõre. Nópe d̶aru, no jẽoicajeva mamacaje jad̶evajebu javecarõre. Que d̶aru, pʉeno baju járojebu cod̶eicobe. Quédeca ñame bʉojabema jʉ aivʉ ji bueiye mamaene aru javeque bueiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Põeva yuabema vino ʉ́yaicorore mamacorore ãimacaje curubʉ javecacurubʉque. Que d̶aru, cod̶eóvajebu dicurubʉre. Yurĩ bíjajebu dicoro. Aru bíjajebu dicurubʉ máre. Ʉbenita ne yuaru mamacorore mamacurubʉque bíjabebu dicoro. Quédeca ñame bʉojabema d̶aivʉ yópe ji bueiye mamaepe, d̶are nʉivʉ baru yópe ne jave d̶aiye báquepe, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Apejãravʉ, judíovai jabʉóvaijãravʉ sábadoi, Jesús vaidéjamed̶a oteiye cʉrõi ʉ̃i bueimaraque. Aru ʉ̃i bueimara jẽnejaimad̶a iye oteiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Apevʉ fariseova jẽniari jã́rejaimad̶a ʉ̃́re: —Jã́jacʉ. ¿Aipe teni mi bueimara d̶aivʉba ãmeno, maja judíova maje d̶aicõjemenope, jabʉóvaijãravʉre? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ʉbenita Jesús, ʉ̃i dápiaiye boje ʉ̃i bueimara ãmeno d̶abevʉre, arejamed̶a náre: —¿Jãve ãrʉmetenarʉ mʉja yo David bácʉi d̶aino mácarõre, ʉ̃́re jaʉéde aru ãvʉé ijiéde ʉ̃́re, ʉ̃́que cʉrivʉre máre? ");
INSERT INTO cubNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ʉ̃ mácʉ ecorejaquemavʉ Jʉ̃menijicʉi cʉ̃rami, Abiatar bácʉ ʉ̃i sacerdotevare jaboteiye báquede. Aru ãrejaquemavʉ pã́ure, Jʉ̃menijicʉre jíye báquede, ina sacerdoteva ne ãiyede, sacerdote ãmecʉ bácʉvacari. Aru jídejaquemavʉ ʉ̃́que cʉrivʉre máre, sacerdoteva ãmevʉ bácavʉreca. Ʉbenita Jʉ̃menijicʉ ñájine d̶abedejaquemavʉ na mácavʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Cojedeca Jesús arĩ buedejamed̶a: —Jʉ̃menijicʉ epedejaquemavʉ jabʉóvaijãravʉre põevare boje. Ʉbenita epebedejaquemavʉ põevare dijãravʉre boje. ");
INSERT INTO cubNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, jabocʉbu yʉ. Que baru d̶aicõjeni bʉojaivʉ yʉ põevare ne d̶aiyede caijãravʉare aru jabʉóvaijãravʉare máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Bedióva Jesús ecorejamed̶a cojedeca judíovai cójijiñami. Noi cʉrejamed̶a cũinácʉ ʉ̃mʉ, ãmuve cũinápũravʉ jiacʉbecʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aru fariseovacavʉ Jesúre coreni jã́rejaimad̶a. Jesús ʉ̃i mead̶aru ñai ʉ̃mʉre, ãmuve jiacʉbecʉre, judíovai jabʉóvaijãravʉ sábadoi, jã́iyʉrivʉ, boro coyʉrĩ ad̶aiyʉrĩduivʉ barejáimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Dinʉmʉma Jesús arejamed̶a ñai ʉ̃mʉ ãmuve jiacʉbecʉre: —Nacajari nújacʉ põeva jẽneboi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aru arejamed̶a apevʉ noi cʉrivʉre: —Jẽniari jã́quijivʉ cũináro mʉjare. ¿Yéde d̶aicõjeini Jʉ̃menijicʉ jabʉóvaijãravʉre, mearore o ãmenore; mead̶aru põevare o boarĩ́ jarʉvaru náre? arejamed̶a Jesús. Ʉbenita bi arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Que baru Jesús jararĩ chĩorejamed̶a, ne coreóvabe boje. Aru arejamed̶a ñai ʉ̃mʉ ãmuve jiacʉbecʉre: —Jabióvajacʉ mi ãmuvede, arejamed̶a Jesús. Ʉ̃i jabióvaiyede meatedejavʉ̃ya ʉ̃i ãmuve. ");
INSERT INTO cubNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Que teni ina fariseova etaivʉ bácavʉ cójijidejaimad̶a Herodede cad̶ateipõevaque. “Boarĩ́ jarʉvarãjarevʉ”, arĩ dápiaivʉ barejáimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesús apevʉre dajocarĩ nʉrejamed̶a macajitabʉ ʉrabʉ ẽcarʉi ʉ̃i bueimaraque. Obedivʉ põeva cujurejaimad̶a ʉ̃i yóboi, Galilea aru Judea ãmicʉrijoborõacavʉ, Jerusalén ãmicʉriĩmarocavʉ, Idumea ãmicʉrijoborõcavʉ, aru Jordán ãmicʉriya jia apedʉvecavʉ: Tiro aru Sidón ãmicʉriĩmaroacavʉ máre. Obediyajuboa põeyajuboa nʉrejaimad̶a ʉ̃i yebai, jápiaivʉ d̶ayʉre ʉrarõ põeva ne d̶arĩ majibede. ");
INSERT INTO cubNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Aru Jesús arejamed̶a ʉ̃i bueimarare: —Mead̶arĩ corejarã jiad̶ocũre, põeva obedivʉ ne darĩburu, jatujivarĩ, ne chĩtomenajiyepe yʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Obedivʉre ʉ̃i mead̶aiye báque boje, apevʉ ijimara ʉ̃́re chĩtorejaimad̶a, tʉoiyʉrĩduivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Aru ina abujuva ne ĩmamara máre Jesúre jã́ri, mori tʉrĩ cod̶oboborejaimad̶a ʉ̃́re: —Mʉrecabu Jʉ̃menijicʉi mácʉ, arĩ cod̶oboborejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ʉbenita Jesús yávaicõjemenejamed̶a parʉrõque, apevʉ ne coreóvabenajiyepe ayʉ ʉ̃i d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","No yóboi Jesús mʉri nʉrejamed̶a cʉ̃racũi. Aru órejarejamed̶a ʉ̃i ʉmarare. ");
INSERT INTO cubNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Beorejamed̶a doce paivʉre. Aru epedejamed̶a náre ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare, ne yóvarãjiyepe ayʉ ʉ̃́re aru jarocʉyʉ náre ne coyʉrãjiyepe ayʉ Jʉ̃menijicʉi yávaiyede. Parʉéde jídejamed̶a náre, ne jaetovarãjiyepe ayʉ abujuvare. ");
INSERT INTO cubNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesús epedejamed̶a ina doce paivʉre: Simón ãmicʉcʉ bácʉre ãmidorejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeoi mácʉ Santiago, aru Santiagoi yócʉ Juan máre, ãmidorejamed̶a náre Boanerges, õpo tʉinoi mára ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","19","Apevʉre máre beorejamed̶a Jesús: Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeoi mácʉ Santiago, Tadeo, Simón ãmicʉcʉ Celote, aru Judas Iscariote máre. Ñai marejámed̶a jẽni jícʉyʉ Jesúre ʉ̃i mauvare. Que teniburu yóboi, Jesús ecorejamed̶a cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Bedióva cójijidejaimad̶a obedivʉ põeva. Aru ãicõjemenejaimad̶a Jesúre, ʉ̃i bueimarare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Põeva “Ãrʉmemi” ne are cuiye boje ʉ̃́re, ʉ̃ jivʉ jápiarĩ, nʉrejaimad̶a, ʉ̃́re jẽnanʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ʉbenita ina Jʉ̃menijicʉi yávaiye báquede bueipõeva, ẽmeni daivʉ bácavʉ Jerusalén ãmicʉriĩmarore jocarĩ, arejaimad̶a: —Cʉvabi Beelzebúre. Que baru abujuvai jabocʉi parʉéque jaetovaibi abujuvare, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús náre órejayʉ bácʉ ʉ̃i yebai, yópe coyʉrejamed̶a: —¿Aipe teni bʉojaidica abujuvai jabocʉ jaetovayʉ ʉ̃i baju? ");
INSERT INTO cubNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Cũináro jaborõcavʉ ãd̶amateivʉ baru ne bajumia, ina jaborõcavʉ cũinájarama na. ");
INSERT INTO cubNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aru nopedeca cũinád̶ami cʉ̃ramicavʉ ãd̶amateivʉ baru ne bajumia, diñamicavʉ cũinájarama na. ");
INSERT INTO cubNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aru nopedeca bájebu ñai abujuvai jabocʉ, jaetovayʉ baru abujuvai jabocʉre. Ãd̶amateyʉ bájebu ʉ̃i bajuma. Aru jaetovayʉ baru abujuvare, joe parʉcʉ cʉbejebu ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ʉbenita bʉojaino ãmevʉ ecoivʉ ñai ʉ̃mʉ parʉcʉi cʉ̃ramine, ñavarajivʉ ʉ̃i cʉvaede. Mamarʉmʉre ʉ̃́re bʉorĩ, que d̶aivʉ bácavʉta bʉojaivʉ ñavaivʉ ʉ̃i cʉvaede, arejamed̶a Jesús. Nópe ayʉ, Jesús yópe aiyʉcʉ barejaquémavʉ: Ʉ̃́vacari parʉbi abujuvai jabocʉ pʉeno, ʉ̃i jaetovaiye boje abujuvare põevare jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aru Jesús arejamed̶a: —Jãve coyʉyʉbu mʉjare: Jʉ̃menijicʉ ãrʉmetecʉyʉme caiye iye mʉje ãmeina teiyede, aru caiye iye Jʉ̃menijicʉre ãmeina yávaiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ʉbenita ácʉ põecʉ ʉ̃i yávaru ãmeina ñai Espíritu Santore, aipinʉmʉ Jʉ̃menijicʉ ãrʉmetebecʉbe ʉ̃i ãmeina teiyede. Quédata boropatecʉyʉme, bíjacʉyʉ Jʉ̃menijicʉre jocarĩ cainʉmʉa, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nópe arejamed̶a Jesús, ina Jʉ̃menijicʉi yávaiye báquede bueipõeva “Ñai ʉ̃mʉ cʉvabi abujucʉre”, ne borocʉrĩ yávaiye boje ʉ̃i borore. ");
INSERT INTO cubNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Dinʉmʉre Jesúi yóva aru jípaco máre earĩ, jedevamia mauteni órejaicõjenejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Aru ina põeva obedivʉ dobarivʉ ʉ̃i cʉrõi arejaimad̶a ʉ̃́re: —Mipaco aru míyova máre jedevai cʉma. Aru vod̶ama mʉre, arejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aru Jesús arejamed̶a: —¿Ñamema jipaco aru jíyova? jẽniari jã́rejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ina põeva obedivʉ dobarivʉre ʉ̃i cʉrõi jã́ri, arejamed̶a: —Yuibu jipaco aru jíyova máre. ");
INSERT INTO cubNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Que baru caivʉ ina d̶aivʉ Jʉ̃menijicʉi ʉrõpe, nárecabu jíyocʉpe páyʉ, aru jíyocope pád̶o, aru jipacope pád̶o máre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Apejãravʉ Jesús buedejamed̶a cojedeca macajitabʉ ʉrabʉ ẽcarʉi. Aru obedivʉ põeva cójijidejaimad̶a ʉ̃i yebai. Que baru jiad̶ocũ ẽcarʉ joabenoi cʉricũre jã́ri, jaturĩ dobarejamed̶a dicũra, buecʉyʉ põevare. Aru caivʉ ina põeva cʉrejaimad̶a macajitabʉ ʉrabʉ ẽcarʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Náre buedejamed̶a jã́ri dápiarĩ ne d̶arãjiyepe ayʉ caijĩe apejĩene. Aru arejamed̶a ʉ̃i bueiyeque: ");
INSERT INTO cubNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Jápiajarã. Yui oteipõecʉ otecʉnʉquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ʉ̃i oteiyede ape oteiye tʉquemavʉ ma ẽcarʉi. Aru míjina darĩ, ãradaquemavʉ caiye iye oteiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ape oteiye tʉquemavʉ joborõ edubenoi cʉ̃raboa pʉenoi. Nore joborõ yaʉrijĩe cʉbeniburu, maumejiena pĩarí etaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ʉbenita aviá ʉ̃i boiyede ẽ́quemavʉ. Aru nʉomua ʉ̃mʉjʉrimua cʉbeni, yaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ape oteiye tʉquemavʉ miucʉa jẽneboi. Aru yóboi miucʉa bʉcʉrĩ, muiní, chĩoiyede, jẽiye jẽmetequemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aru ape oteiye tʉquemavʉ mearo joborõi. Aru jẽiye jẽquemavʉ, apeñʉ jẽiñʉ treinta paivʉa, aru apeñʉ jẽiñʉ sesenta paivʉa, aru apeñʉ jẽiñʉ cien paivʉa, caiye oteiyabea coapa, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Dinʉmʉ Jesús arejamed̶a náre: —Me jápiajarã mʉja iye ji bueiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesús ʉ̃i cʉede cũinácʉva, apevʉ ʉ̃i yebai joabenoi cʉrivʉ aru ʉ̃i bueimara máre jẽniari jã́rejaimad̶a ʉ̃́re: —¿Aipe teni bueyʉrʉ̃ mʉ jã́ri dápiarĩ ñʉje d̶arãjiyepe ayʉ mi coyʉiyeque? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Jesús arejamed̶a náre: —Mʉjare coyʉrĩ majide d̶ayʉbu yʉ Jʉ̃menijicʉ ʉ̃i coyʉicõjeme máquede. Ʉ̃ jaboteibi mʉjare, ʉ̃i põevare. Ʉbenita ina ʉ̃i jaboteimara ãmevʉ, yópe jedevai cʉrivʉpe, diede majibema. Quéda jã́ri dápiarĩ ne d̶arãjiyepe ayʉ bueyʉbu yʉ náre, jã́ivʉreca, ne jã́ri majibenajiyepe ayʉ aipe aiyʉrõre ne jã́iyede, aru jápiaivʉreca, ne jápiarĩ majibenajiyepe ayʉ aipe aiyʉrõre ne jápiaiyede. Na majidivʉ baru, chĩori oatʉvajebu ne d̶aiyede. Jʉ̃menijicʉre jʉ aru, ãrʉmetejebu ʉ̃ ne ãmeina teiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yópe arĩ, Jesús coyʉrejamed̶a ʉ̃i bueimarare: —¿Majibenarʉ yo jã́ri dápiarĩ mʉje d̶arãjiyepe ayʉ ji ainore? ¿Aipe d̶arĩ majinajivʉrʉ̃ caiye ji jã́ri dápiarĩ mʉje d̶arãjiyepe ayʉ arĩ bueiyede? ");
INSERT INTO cubNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Iye oteiye Jʉ̃menijicʉi yávaiyepe paiyebu. Aru ñai oteipõecʉ Jʉ̃menijicʉi yávaiyede coyʉipõecʉpe páyʉbe. ");
INSERT INTO cubNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aru inamu ma ẽcarʉi oteiye tʉrĩduiye báquepe paivʉ. Náre coyʉiyede Jʉ̃menijicʉi yávaiyede jápiad̶ama, ʉbenita coreóvarĩ eabevʉva. Que baru ne jápiarĩburu yóboi, ñai abujuvai jabocʉ darĩ, ãrʉmetede d̶aibi Jʉ̃menijicʉi yávaiyede, ne jápiaiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aru inamu joborõ edubenoi, cʉ̃raboa pʉenoi, oteiye tʉrĩduiye báquepe paivʉ. Jʉ̃menijicʉi yávaiyede jápiarĩ, torojʉma me. ");
INSERT INTO cubNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ʉbenita Jʉ̃menijicʉi yávaiyede jʉ arĩduyama. Que baru quĩ́jino yóboi, põeva ne cãrijovaru aru ñájine d̶aru náre, ne jʉ aiye boje, maumena dajocad̶ama ne jʉ aiyede Jʉ̃menijicʉi yávaiyede. Que teni jʉ abema na. ");
INSERT INTO cubNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Aru inamu miucʉa jẽneboi oteiye tʉrĩduiye báquepe paivʉ. Na máre jápiaivʉ Jʉ̃menijicʉi yávaiyede, ʉbenita cãrijiñama ijãravʉquede. Torojʉma tãutʉraque. Aru cʉvaiyʉma caijĩe apejĩene. Que baru dápiad̶ama caiye diede. Ʉbenita dápiabema Jʉ̃menijicʉi yávaiyede. Que baru Jʉ̃menijicʉ cad̶atebebi náre ʉ̃i yávaiyeque yópe ʉ̃i ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ʉbenita inamu mearo joborõi oteiye tʉiye báquepe paivʉ. Jʉ̃menijicʉi yávaiyede jápiad̶ama. Aru diede jʉ ad̶ama. Nárecabu jʉ are d̶aivʉ apevʉ põevare, apevʉ treinta paivʉre, apevʉ sesenta paivʉre, aru apevʉ cien paivʉre, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cojedeca Jesús, yópe arĩ, buedejamed̶a náre: —¿Põecʉ davaidi pẽoibʉre, ñócʉyʉ dibʉre pʉebʉ cãchinoi o paraino cãchinoi? Bi, quénora tʉoibi dibʉre jocʉve pʉenora. ");
INSERT INTO cubNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Que baru caiye yaveiye báque jároquiyebu. Aru dupióvaiye báquede máre jã́rajarama caivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Me jápiajarã mʉja iye ji bueiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aru cojedeca, yópe arĩ, buedejamed̶a náre: —Me dápiajarã mʉje jápiaiyede ji bueiyede. Yópe põeva ad̶ama: “Mi corevacaru apecʉre cũinárʉ jororʉque, didʉmica Jʉ̃menijicʉ corevacacʉyʉme mʉre. Aru jícʉyʉme pʉeno baju”. ");
INSERT INTO cubNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nopedeca ñai jápiayʉre Jʉ̃menijicʉi yávaiyede Jʉ̃menijicʉ pʉeno baju ʉ̃i majiéquede jícʉyʉme ʉ̃́re. Ʉbenita ñai jápiabecʉre Jʉ̃menijicʉi yávaiyede, iye ʉ̃i quĩ́jino majiéde Jʉ̃menijicʉ ʉ̃́re ĩcʉyʉme, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","27","Cojedeca Jesús arĩ coyʉrejamed̶a: —Jʉ̃menijicʉi jaboteino yópe painotamu. Cũinácʉ ʉ̃mʉ ʉ̃i oteiye epeiye joborõi, oteni bʉojarĩ cãimi ʉ̃ ñamiá coapa aru coedaibi jãravʉa coapa. Que teni ãrʉmemi diede, oteiye báquede. Ʉ̃i oteiye bʉcʉivʉ, ʉbenita ʉ̃i majibedeca. ");
INSERT INTO cubNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","No joborõ bʉcʉre d̶aivʉ no bajumia. Mamarʉmʉ etaivʉ cainiñʉ. No yóboi etaivʉ yoca. No yóbo baji etaivʉ diñʉ jẽiyoa. ");
INSERT INTO cubNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aru jẽijãravʉ eaiyede, jẽiyoa coboiyede, põeva jẽñaima divʉáre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús arejamed̶a: —¿Yépe ãrojari yo Jʉ̃menijicʉi jaboteino? ¿Yéque jã́ri coyʉrãjidi maja nore? ");
INSERT INTO cubNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yópe mostaza ãmicʉriyabe oteiyabepebu. Cũinácʉ ʉ̃mʉ diyabede ĩni, oteibi joborõi. Diyabedecabu oteiyabe quĩ́jiyabe caiye oteiye pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ʉbenita ʉ̃i oteniburu yóboi, bʉcʉrĩ mʉivʉ ʉracʉ ape oteiye pʉeno. Aru dicʉ cavabʉa ʉracavabʉa nʉivʉ. Dicʉ taino cãchinoi, míjina ne juaiboa d̶ad̶ama, arejamed̶a Jesús. Nopedeca mamarʉmʉre Jʉ̃menijicʉi jaboteino quĩ́jinotamu, põeva obebevʉ ne cʉe boje noi. Ʉbenita Jʉ̃menijicʉi yávaiye méne coyʉrĩburu yóboi, ʉrarõtamu no Jʉ̃menijicʉi jaboteino, obedivʉ põeva ne cʉe boje noi. ");
INSERT INTO cubNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yópe arĩ, buedejamed̶a Jesús Jʉ̃menijicʉi yávaiyede jã́ri dápiarĩ ne d̶arãjiyepe ayʉ. Ne jápiarĩ coreóvarãjiyepe ayʉ buedejamed̶a náre cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Coyʉre curejamed̶a cainʉmʉa jã́ri dápiarĩ ne d̶arãjiyepe aiyeque ʉ̃i bueinore. Ʉbenita coyʉrejamed̶a ʉ̃i bueimarare aipe aiyʉede iye jã́ri dápiarĩ ne d̶arãjiyepe aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Dijãravʉmica nainújie baji Jesús arejamed̶a ʉ̃i bueimarare: —Jã́rica, macajitabʉ ʉrabʉ apedʉvei nʉrevʉ, arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Quénora dajocarĩ nʉrejaimad̶a, nʉvaivʉ Jesúre põevare jocarĩ jiad̶ocũi. Apevʉ põeva nʉrejaimad̶a jiad̶ocũai, náre coapa yóvaivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aru jataivʉre japurejavʉ̃ya ũmevʉ parʉrõ baju. Pãcaiboa coiye boje jiad̶ocũi, buidéjavʉ̃ya dicũre oco. ");
INSERT INTO cubNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ʉbenita Jesús cãñʉ marejámed̶a japʉvaino yebai. Tʉorejamed̶a jabʉóvaiboi. Aru coedavarĩ, arejaimad̶a ʉ̃́re: —¿Mʉ jidʉbecʉrʉ̃ maje corãjinore? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús coedarĩ jararejamed̶a ũmevʉre. Aru arejamed̶a macajitabʉre: —Quénora, pãcamejabʉ, arejamed̶a Jesús. Que aiyede, ũmevʉ bíjacʉnʉri, pãcamenejavʉ̃ya dibʉ macajitabʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Que teni Jesús arejamed̶a ʉ̃i bueimarare: —¿Aipe teni jidʉrivʉrʉ̃ mʉja? ¿Aipe teni “Jesús mead̶acʉyʉme ñʉjare”, abevʉrʉ̃ mʉja? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jesús ʉ̃i que aiyede, cuecumari arejaimad̶a ne bajumia: —¿Yécʉba ñai yópe d̶ayʉ, ũmevʉ aru macajitabʉ máre jʉ aimʉ? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","No macajitabʉ ʉrabʉre jatarĩ nʉri, apedʉvei jatarejamed̶a Jesús ʉ̃i bueimaraque. Didʉvei cʉrejaimad̶a na, Gerasa ãmicʉrõcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aru Jesús ʉ̃i maiyede jiad̶ocũre jocarĩ, maumejiena copʉ nʉrejamed̶a cũinácʉ ʉ̃mʉ, abujuva ne ĩmamʉ. Yaivʉ bácavʉ ne baju bácarõre jaʉvainore jocarĩ etarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Cʉcʉ barejámed̶a noi. Aru ñame bʉojabedejaimad̶a bʉoivʉ ʉ̃́re tãumeaque. ");
INSERT INTO cubNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cainʉmʉa ʉ̃́re ʉ̃i ãrad̶oare aru ʉ̃i ãmuveare máre tãumeaque bʉorĩdurejaimad̶a. Ʉbenita die ʉ̃i ãmuveare ne bʉoiyede cobʉrʉrʉrĩ burarĩ, die ʉ̃i ãrad̶oare ne bʉoiyede máre pẽvari buravarejamed̶a ʉ̃. Tʉijĩbʉa d̶arĩ dajocavarejamed̶a ñai abujuva ne ĩmamʉ. Aru põeva ʉ̃́re jẽivʉ parʉbedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jãravʉa aru ñamiá coapa cuyʉ barejámed̶a cod̶oboborĩ cʉ̃racũai aru põeva ne yaivʉ bácavʉre jarʉvainoi. Ʉ̃i bajure jãd̶od̶ovari, churiá teni, jive copidejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ʉbenita Jesúre joai jã́ri, cúyarĩ nʉri, ñʉatutarejamed̶a ʉ̃i yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Aru bʉjié cod̶oboborĩ, arejamed̶a: —Mʉ, Jesús, Jʉ̃menijicʉi mácʉ, caivʉ pʉeno parʉcʉi mácʉ, ¿yéde ʉcʉrʉ̃ yʉ́que? Jẽniaivʉ mʉre Jʉ̃menijicʉque, ñájine d̶abejacʉ yʉre, arĩ cod̶oboborejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nópe arejamed̶a, Jesús ʉ̃i aiye báque boje jipocamia: “Mʉja, abujuva, etajarã ñai ʉ̃mʉre jocarĩ”, ayʉ barejámed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aru Jesús jẽniari jã́rejamed̶a: —¿Yécʉ ãmicʉcʉrʉ̃ mʉ? arejamed̶a. Jʉ arĩ arejamed̶a: —Obedivʉbu ñʉja. Que baru Obecʉ ãmicʉvʉ yʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Pare jẽniarejamed̶a Jesús ʉ̃i jarobequiyepe ayʉ náre ne cʉrõre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Cʉrejaimad̶a noi cʉ̃racũ yebai obedivʉ oteivãriva, ãre cuivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aru jẽniarejaimad̶a ina abujuva Jesúre: —Jarojacʉ ñʉjare ina oteivãrivara, ñʉje corãjiyepe nára, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Dinʉmʉma nʉicõjenejamed̶a náre Jesús. —Nʉjara, arejamed̶a. Aru ina abujuva etarĩ, corejaimad̶a ina oteivãrivara. Na marejáimad̶a pʉcamil paivʉ baju. Cúyarĩ nʉri, tʉrejaimad̶a cʉ̃racũ ẽmeinoi, macajitabʉ ʉrabʉi. Tʉrĩ, corĩ bíjarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Diede jã́ri, ina oteivãriva mácavʉre coreipõeva cúyarĩ nʉrejaimad̶a, coyʉivʉ ʉraĩmaroai aru ĩmaro cʉrõvaquede máre. Que baru obedivʉ põeva, “¿Aipe tenama?” arĩ, jã́ranʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús yebai nʉivʉ, jã́rejaimad̶a ñai ʉ̃mʉ abujuva ne ñájine d̶aimʉ mácʉ dobacʉre, cuitótecajede doyʉre, meacʉre cari. Aru jidʉrejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Coyʉrejaimad̶a ina jã́ivʉ bácavʉ Jesúi d̶aiye báquede aru aipe vaino mácarõre ñai ʉ̃mʉ abujuva ne ĩmamʉ mácʉre, ina oteivãrivare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Quénora “Nʉjacʉ”, arejaimad̶a Jesúre parʉrõque. Etaicõjenejaimad̶a ʉ̃́re ne cʉrõre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Aru Jesús ʉ̃i jatuiyede jiad̶ocũi, jaturĩdurejamed̶a ñai ʉ̃mʉ abujuva ne ĩmamʉ mácʉ. Jẽniaridurejamed̶a parʉrõreca cuiyʉcʉ ʉ̃́que. ");
INSERT INTO cubNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ʉbenita Jesús yóvaicõjemecʉ arejamed̶a ʉ̃́re: —Nʉjacʉ mi cʉ̃rami, mívʉ yebai. Aru coyʉjacʉ caiye iye ʉrarõ Jʉ̃menijicʉ ʉ̃i d̶aiyede mʉ́que, aru aipe ʉ̃i cõmaje ãroje jã́inore mʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nʉri, coyʉrĩ bʉ́rejamed̶a Decápolis ãmicʉrijoborõcaĩmaroai caiye iye Jesús ʉ̃i d̶aiye báquede ʉ̃́re. Aru caivʉ cuecumarejaimad̶a jápiaivʉ ʉ̃i que ainore. ");
INSERT INTO cubNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","No macajitabʉ ʉrabʉ Jesús jatayʉ bácʉ cojedeca apedʉvei jiad̶ocũi, cójijidejaimad̶a obedivʉ põeva ʉ̃i yebai. Aru ʉ̃ cʉrejamed̶a macajitabʉ ʉrabʉ ẽcarʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ʉ̃i yebai earejamed̶a cũinácʉ judíovai cójijiñamine coreipõecʉ, Jairo ãmicʉcʉ. Aru maumejie jã́rina ñʉatutarejamed̶a Jesúi cʉboba yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ʉrarõreca jẽniari, arejamed̶a Jesúre: —Jímaco yaiyóta tebico õ. Yʉ́que darĩ, tʉojacʉ ṍre mi pʉrʉque, õi yaibécojiyepe ayʉ. Aru cʉcod̶ome õ, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ʉ̃i que aiyede, Jesús nʉrejamed̶a ʉ̃́que. Cujurejaimad̶a náre obedivʉ põeva. Aru cojivare nʉrejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ne jẽneboi cũináco nomió cʉrejacod̶a. Doce paiʉjʉa baju ijimo marejácod̶a jive yuiyeque. ");
INSERT INTO cubNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Pare ñájiño mácore, obedivʉ jʉoipõeva jʉorĩdurejaimad̶a ṍre. Aru bojed̶arĩ jarʉvarejacod̶a caiye õi cʉvae báquede, bojed̶acod̶o ina jʉoipõevare. Ʉbenita ye meatebedejavʉ̃ya. Quédata pʉeno baju ijino nʉrejavʉ̃ya ṍre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesús ʉ̃i põevare ũmedavaiyede borore jápiad̶o báco, nʉrejacod̶a ʉ̃i yóboi obedivʉ põeva jẽneboi. Aru jẽni jã́rejacod̶a ʉ̃i doicajena. ");
INSERT INTO cubNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yópe arĩ dápiarejacod̶a õ: “Yʉ jẽni jã́d̶o maru ʉ̃i doicajede, quénora ũmedacod̶omu yʉ”, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Maumejiena õi jẽni jã́iyede, bíjarejavʉ̃ya õi jive yuino mácarõ. Aru dápiarejacod̶a caino õi baju meateni nʉinore. ");
INSERT INTO cubNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ʉbenita Jesús majicʉ ʉ̃i baju ʉ̃i parʉécarõre etaiyede ʉ̃́re jocarĩ, copedini, ina obedivʉ põevare arejamed̶a: —¿Ñame matedí yʉre jẽni jã́d̶o ji cuitótecajede? jẽniari jã́rejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ʉ̃i bueimara arejaimad̶a Jesúre: —¿Obedivʉ põeva cojivare daivʉre jã́ñʉvacari, “¿Ñame matedí yʉre jẽni jã́d̶o?” ayʉrʉ̃ mʉ? arejaimad̶a na Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ʉbenita jã́ridurejamed̶a caino ʉ̃i cʉrõvare, jã́iyʉcʉ ñame jẽni jã́d̶o mácore ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Que teni ico nomió bidini jidʉco, majico Jesús ʉ̃i ũmedavaino mácarõre ṍre, nʉri ñʉatutarejacod̶a ʉ̃i jipocai. Aru coyʉrejacod̶a jãve õi d̶aino mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesúcapũravʉ arejamed̶a ṍre: —Mʉ, ji ʉmo, “Ʉ̃ mead̶aiye majibi yʉre”, arĩ dápiarebu mʉ. Que baru mi que arĩ dápiaiye boje, mead̶aivʉ mʉre. Ména nʉri cʉjaco mʉ. Caride meateivʉ, arejamed̶a ṍre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ʉ̃i boroteiyede ṍque, earejaimad̶a ina judíovai cójijiñamine coreipõecʉi cʉ̃ramicavʉ. Jairore arejaimad̶a na: —Javeta mímaco yaibíco õ. Quénora cãrijovamejacʉ bueipõecʉre, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ʉbenita Jesús jápiayʉ bácʉ ne yávainore, jápiabecʉpe teni, arejamed̶a Jairore: —Jidʉbejacʉ mʉ. Quénora jʉ ajacʉ ji coyʉinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aru apevʉre nʉicõjemeni, nʉvarejamed̶a Pedrore, Santiagore, aru Jũare, Santiagoi yócʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Nʉrejaimad̶a Jairoi cʉ̃rami. Cójijivʉre jã́ri, aru cod̶oboborĩ oivʉre jã́ri, aru cõmaje ãroje teivʉre máre jã́ri, ecorĩ arejamed̶a Jesús: —¿Aipe teni cójijini bʉjiéque oivʉrʉ̃ mʉja? Õ yaiyó ãmemico. Quénora cãd̶otame, arejamed̶a. Náre nópe arejamed̶a Jesús, ʉ̃i majié boje ʉ̃i nacovaquinore ṍre yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ʉ̃i que aiyede, yʉridejaimad̶a ʉ̃́re. Ʉbenita Jesúcapũravʉ náre etavarĩ, jarorejamed̶a jedevai. Jípacʉre ĩni, aru jípacore ĩni, aru ʉ̃́que cʉrivʉre máre ĩni, ecorejamed̶a jʉed̶oco bácoi cʉritucubʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Õ mácoi pʉrʉre jẽni, “Talita cumi”, arejamed̶a ṍre Jesús. “Jʉed̶oco, nacajajaco”, ayʉ barejámed̶a, ṍre que ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Cũiná ico jʉed̶oco, doce paiʉjʉa cʉvaco, nacajari, vaivárejacod̶a. Aru ina jã́ivʉ bácavʉ pare cuecumari dápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ʉbenita Jesús apevʉre coyʉicõjemenejamed̶a náre iye ʉ̃i d̶aiye báquede. Aru “Ãiyede jíjarã ṍre”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús nʉrejamed̶a nore jocarĩ, copainʉñʉ ʉ̃i joborõi ʉ̃i bueimaraque. ");
INSERT INTO cubNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aru judíovai jabʉóvaijãravʉ sábadoi bueni bʉ́rejamed̶a judíovai cójijiñami. Ina obedivʉ põeva ʉ̃́re jápiaivʉ cuecumari arejaimad̶a: —¿Ã́roqueba caiye iye d̶aiye? ¿Yéba iye ʉ̃́re majide d̶aiye, aru iye d̶aiye põeva ne d̶arĩ majibede? ");
INSERT INTO cubNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ñai ãmeni jocʉre memeipõecʉi mácʉ? ¿Ñai ãmeni Maríai mácʉ? ¿Santiago, José, Judas, aru Simón máre némamicʉ ãmeni? ¿Ʉ̃i yórõmiva máre cʉbedi majaque yui? arejaimad̶a na. Que arĩ, ãmeina jã́rejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ʉbenita Jesúcapũravʉ arejamed̶a náre, ne jʉ abe boje: —Cʉbebi Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ ne pued̶aimʉ ʉ̃ jivʉ aru ʉ̃i cʉ̃ramicavʉ máre ʉ̃i joborõi, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Que baru d̶abedejamed̶a põeva ne d̶arĩ majibede nore. Quénora obebevʉ ijimarare ʉ̃i pʉrʉque tʉorĩ mead̶arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Chĩori dápiarejamed̶a pare ne jʉ abe boje ʉ̃́re. Jesús buede nʉrejamed̶a cainoa ĩmaroa coapa. ");
INSERT INTO cubNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Cũinájãravʉ ina doce paivʉ ʉ̃i bueimarare órejarejamed̶a ʉ̃i yebai. Jídejamed̶a ne parʉéva, ne jaetovarãjiyepe ayʉ abujuvare. Aru jarorejamed̶a pʉcarã matʉiyeda, ne coyʉrãjiyepe ayʉ Jʉ̃menijicʉi jaboteinoque yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nʉvaicõjemenejamed̶a apejĩene ne nʉinore, pã́uboare, aru curubʉare, aru tãutʉrare máre ne jãrióicãvai. Quénora nʉvaicõjenejamed̶a ne tuturiteiyoava ne nʉinoi. ");
INSERT INTO cubNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aru doicõjenejamed̶a ne cʉraidoare. Ʉbenita nʉvaicõjemenejamed̶a náre pʉcacajea cuitótecajeare. ");
INSERT INTO cubNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Que baru arejamed̶a náre: —Ã́ri mʉja ecoivʉre ĩmaroi, cʉjarã cũinácʉ cʉ̃rami upacʉque pʉ dajocarĩ nʉivʉta nore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Aru apenoi ne copʉ etabedu mʉjare, aru ne jápiaiyʉbedu iye yávaiye méne, etarĩ nʉjara. Aru pʉpejarã jobore mʉjare jẽiyede mʉje cʉboba cãchinoi ne jã́iyede, ne jápiaiyʉbe boje. Que teni diĩmarocavʉ coreóvarãjarama jʉ abevʉre Jʉ̃menijicʉre aru mʉjare máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Que arĩburu yóboi, etarĩ nʉrejaimad̶a ʉ̃i bueimara, yópe arĩ coyʉrãjivʉ põevare: “Chĩori dápiarĩ dajocajarã mʉje ãmeina teiyede, Jʉ̃menijicʉi ãrʉmetequiyepe aivʉ diede”. ");
INSERT INTO cubNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jaetovarejaimad̶a obedivʉ abujuvare. Aru obedivʉ ijimarare olivo ãmicʉricʉ jẽidʉa córoque yuarĩ mead̶arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dinʉmʉ ñai jabocʉ Herodes jápiarejamed̶a Jesúi borore, cainoacavʉ ne yávaiye boje ʉ̃́re. Aru arejamed̶a: —Juan Bautista, yaiyʉ́ bácʉ, nacajacʉbe yainore jarʉvarĩ. Que baru yópe parʉcʉbe ʉ̃, ʉbenina arejamed̶a Herodes. ");
INSERT INTO cubNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Apevʉ arejaimad̶a: “Ʉ̃́recabe Elías”. Aru apevʉ arejaimad̶a: “Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉbe. Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉpe páyʉbe ʉ̃”, ávarejaimad̶a põeva Jesúi borore. ");
INSERT INTO cubNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ʉbenita Herodes, jápiayʉ Jesúi borore, arejamed̶a: —Ñaime Juan Bautista, ji buravacamʉ ʉ̃i jipobʉre, nacajañʉ mácʉ yainore jarʉvarĩ, ʉbenina arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nópe dápiarejaquemavʉ Herodes, Juan Bautistare, apʉcʉre cãreja, ʉ̃i yaiquíye jipocai, Herodei bʉoicõjeiye báque boje ʉ̃́re. Bʉoicõjenejamed̶a, jacocʉyʉ ãmeina teivʉre jẽni jacoiñami, yópe Herodei márepaco Herodíai ʉrõpe. Nópe ʉrejacod̶a, õi jorojĩye boje, ʉ̃i ãmecoroiye báquede Herodede, ʉ̃i cʉvae boje ṍre, ĩmacʉ Felipei márepacore. ");
INSERT INTO cubNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Javede Juan Bautista bácʉ ávarejamed̶a Herodede: “Jʉ̃menijicʉi d̶aicõjeiye ʉ̃i coyʉiye báque Moisés bácʉre cʉvaicõjemevʉ mʉre apecʉi márepacore”, ávarejamed̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Que baru Herodías jararĩ pare ʉbedejacod̶a Juan Bautistare, apʉcʉre cãreja. Ʉ̃́re boarĩ́ jarʉvaiyʉrĩdurejacod̶a. Ʉbenita majibedejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Aru Herodes jidʉre curejamed̶a Juan Bautistare, apʉcʉre cãreja, ʉ̃i majié boje meacʉre aru mearo d̶ayʉre. Herodes cãrijiñʉ mácʉvacari Juan Bautistai coyʉiye báque boje, torojʉrĩ jápiarejamed̶a ʉ̃́re. Aru mead̶arejamed̶a ʉ̃́re, apʉcʉre cãreja. ");
INSERT INTO cubNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ʉbenita cũinájãravʉ, ʉ̃i ãrʉrijãravʉ eaiyede, Herodei põeteijãravʉ bácarõre torojʉve teino d̶arejamed̶a ʉ̃. Cuturejamed̶a caivʉ ina jabovare, churara jabovare, aru Galilea ãmicʉrijoborõcavʉ parʉrivʉre máre. Dijãravʉi Herodías coreóvarejaquemavʉ aipe boarĩ́ jarʉvarĩ bʉojacod̶ore Juan Bautistare. ");
INSERT INTO cubNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodíai máco nʉri, uparĩ, cojʉyarejacod̶a Herodede aru ʉ̃i cutuimarare máre. Que baru Herodes arejamed̶a ṍre: —Jíquijivʉ mʉre mi ʉrõre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Aru parʉéque arejamed̶a ṍre: —Jíquijivʉ mʉre yéde mi ʉrõre. Yʉre ñájine d̶ajacʉrĩ Jʉ̃menijicʉ, ji d̶abedu yópe ji ainope. Coricaita ji jaboteni cʉvarõre jíquijivʉ mʉre, arejamed̶a cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Náre jocarĩ, etarĩ nʉri, jẽniari jã́rejacod̶a jípacore: —¿Yéde jẽniaji ʉ̃́re? arejacod̶a. Aru jípaco jẽniaicõjenejacod̶a ṍre: —Juan Bautistai jipobʉre jẽniajaco, arejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Maumena copainʉri ñai jabocʉ yebai, arejacod̶a: —Jíjacʉ yʉre carijĩe Juan Bautistai jipobʉre jororʉque, arejacod̶a õ Herodede. ");
INSERT INTO cubNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Õi jẽniainore jápiarĩ, chĩorejamed̶a pare. Ʉbenita ʉ̃i aiye báque boje parʉéque, aru ʉ̃i cutuimarare cʉyeni, jʉ abeni majibedejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Que baru maumena boaipõecʉre jarorejamed̶a, ʉ̃i davaquiyepe ayʉ Juan Bautista bácʉi jipobʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ãmeina teivʉre jẽni jacoiñami nʉri, burarĩ bʉojarĩ nʉvarejamed̶a Juan Bautista bácʉi jipobʉre jororʉque. Jídejamed̶a ico nomió bojʉyore. Aru jídejacod̶a jípacore, õi majicojiyepe ad̶o Juan Bautista bácʉ jãve yaiyʉ́ bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aru cũiná jápiaivʉva iyede, Juan Bautista bácʉi bueimara nʉvarejaimad̶a ʉ̃i baju bácarõre, jarʉvarãjivʉ cʉ̃racobe jívʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dinʉmʉ Jesús ʉ̃i daroimara mácavʉ copainʉrejaimad̶a ʉ̃i yebai. Aru ʉ̃́re coyʉrejaimad̶a caino ne d̶aino mácarõre aru ne bueino mácarõre máre. ");
INSERT INTO cubNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aru obedivʉ põeva Jesújãre nʉri, jã́ri, copainʉrejaimad̶a. Que baru ina põevacapũravʉ ãicõjemenejaimad̶a Jesújãre. Que teni Jesús arejamed̶a ʉ̃i bueimarare: —Jã́rica, majapeda jabʉóvarãnʉrajarevʉ ne cãrijovamenoi, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Que teni jiad̶ocũi jaturĩ, nʉri põecʉbenoi, nʉridurejaimad̶a na, Jesújã, põevare jocarĩ nʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ʉbenita náre nʉivʉre jã́rejaimad̶a põeva obedivʉ. Nʉivʉre jã́ri, náre coreóvarĩ arejaimad̶a: “Jesújãmu”. Que arĩ, cúyarĩ nʉri, Jesújã ne earãjinoi ne jipocai ẽmeni, coredejaimad̶a na macajitabʉ ʉrabʉ ẽcarʉi cʉriĩmaroacavʉ obedivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Aru ʉ̃ jatayʉ bácʉ, ẽcarʉi mañʉ, ina obedivʉ põevare jã́ñʉ, náre cõmaje ãroje jã́rejamed̶a Jesús. “Ovejava ne coreipõecʉ cʉbevʉpebebu ina” arĩ, bueni bʉ́rejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ʉrarõ coyʉrĩ buedejamed̶a náre Jesús. Náre bueni, nainúta marejávʉ̃ya. Que baru coyʉrãearejaimad̶a na, ʉ̃i bueimara. —Javeta nainútamu. Aru yo põecʉbenotamu. ");
INSERT INTO cubNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mʉ, bueipõecʉ, põevare ne ãrajiye bojed̶aicõjejacʉ mʉ. Ẽcarʉcavʉ ne cʉ̃ramia coapa aru noi ĩmajinoai máre náre jarorĩ, “Ãranʉjara” ajacʉ mʉ, arĩdurejaimad̶a Jesúre ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Mʉja náre ãiyede jíjarã, arejamed̶a Jesús. Ʉ̃i bueimara arejaimad̶a ʉ̃́re: —Doscientos paijãravʉa memeiye báque bojeque obedivʉre ne ãrajiye pã́uboare ne bojed̶arãnʉru, eabequiyebu iye náre coapa, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Arejamed̶a náre: —¿Aipiboa pã́uboare cʉvarãrʉ mʉja? Jã́ranʉrijide apa, arejamed̶a. Aru na majidivʉ bácavʉ arejaimad̶a, ʉ̃́re coyʉivʉ: —Pã́uboa cũinápʉrʉpe paiboa aru moa pʉcarã cʉvavʉ ñʉja, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Dinʉmʉre cõriá pʉenora põevare dobaicõjenejamed̶a Jesús. Yajuboa teni, náre dobaicõjenejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ʉ̃i dobaicõjeiyede, dobarejaimad̶a ina põevacapũravʉ. Dobarĩ, yajuboa teni, cainimea teni, dobarejaimad̶a na. Cincuenta paivʉ cʉriyajuboa aru cien paivʉ cʉriyajuboa dobarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aru die pã́uboa cũinápʉrʉpe paiboare aru moa pʉcarãre jẽni, cavarõi jã́ñʉ, torojʉede jídejamed̶a Jʉ̃menijicʉre. Torojʉede jíni bʉojarĩ, pã́uboare cotʉvarĩ jebeni, põevare jícõjenejamed̶a Jesús ʉ̃i bueimarare. Aru moare máre quédeca põevare cotʉvarejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Aru caivʉ ãri yapidejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ãri bubarĩburu iye cotʉvaiye báque pã́u aru moa máre põeva ne ãri oabede ĩni, mead̶arĩ, pʉebʉa doce paibʉare, judíovai pʉebʉare, buivárejaimad̶a ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aru ina ãivʉ bácavʉ ʉ̃mʉva cũinápʉrʉpe paimil baju barejáimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Maumejiena Jesús jatuicõjenejamed̶a ʉ̃i bueimarare jiad̶ocũi, ne nʉrajiyepe ayʉ ʉ̃i jipocai apedʉvei, Betsaida ãmicʉriĩmaroi. Que teni copaicõjenejamed̶a ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ne nʉriburu yóboi, Jʉ̃menijicʉre coyʉcʉnʉrejamed̶a cʉ̃racũi. ");
INSERT INTO cubNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ñami marejávʉ̃ya. Ne jiad̶ocũ macajitabʉ ʉrabʉ coricai cʉrejavʉ̃ya. Aru Jesús cʉ̃racũi cʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nore cʉcʉ, jã́rejamed̶a ũmevʉ cobainore náre. Que baru jatabedejaimad̶a apedʉvei. Pare doarĩ ñájinejaimad̶a. Aru jãravʉcapũravʉi aviá ʉ̃i daquiye jipocai, Jesús curĩ macajitabʉ ʉrabʉ pʉenora nʉrejamed̶a ne yebai. Vaivárejamed̶a náre jocarĩ vaiyʉ́pe. ");
INSERT INTO cubNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ʉbenita ʉ̃ cuyʉre macajitabʉ ʉrabʉ pʉenora jã́ri, jidʉrivʉ cod̶oboborejaimad̶a na: —¿Põe decocʉ bácʉ bárica? cod̶oboborĩ arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Caivʉ ina ʉ̃́re jã́ri, pare cuecumarejaimad̶a. Ʉbenita maumena náre coyʉyʉ arejamed̶a: —Parʉéque dápiajarã. Yʉ́tamu Jesús. Jidʉbejarã mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Que arĩ, jaturejamed̶a ne yebai jiad̶ocũi. Aru ũmevʉ bíjarejavʉ̃ya. Que teni cuecumari pare dápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Coreóvabedejaimad̶a iye Jesús ʉ̃i d̶aiye báquede pã́uboaque, ʉ̃i ãre d̶aiye báquede ina cũinápʉrʉpe paimil baju ʉ̃mʉvare. Que baru ye coreóvarĩ majibedejaquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jatarĩburu yóboi, earejaimad̶a Genesaret ãmicʉrijoborõi. Aru bʉorejaimad̶a ne jiad̶ocũre ẽcarʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Dicũre jocarĩ etaivʉre, obedivʉ põeva coreóvarejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Que baru cúyarejaimad̶a caino ne ĩmaroai, nʉvarajivʉ ijimarare ne parainoai, caino cʉrõai, ne jápiaiyede Jesús cʉcʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Caino Jesús ʉ̃i nʉino, ĩmaroai, aru ĩmajinoai, aru cʉrõvaquei máre, ijimarare nʉvari epedejaimad̶a tãibʉi. Ʉ̃́re jẽniarejaimad̶a, ʉ̃i jẽni jã́icõjequiyepe aivʉ ʉ̃i cuitótecaje tʉrʉvarã. Aru caivʉ jẽni jã́ivʉ meateivʉ barejáimad̶a na, ijimara mácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Dinʉmʉ fariseovacavʉ apevʉ Jʉ̃menijicʉi yávaiye báquede bueipõevaque Jerusalén ãmicʉriĩmarore jocarĩ etaivʉ bácavʉ earĩ, cójijidejaimad̶a Jesús yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Aru jã́rejaimad̶a ʉ̃i bueimaracavʉre ãivʉre ne pʉrʉáre cojabevʉva. Ina fariseova dápiarejaimad̶a caivʉre ne cojaiye jaʉéde ne ãrajiye jipocai, Jʉ̃menijicʉi mearo jã́quiyepe aivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Que baru ina fariseova ãmeina jã́rejaimad̶a náre. Caivʉ fariseova aru caivʉ apevʉ judíova máre cainʉmʉa cojavarejaimad̶a, ne ãrajiye jipocai. Nópe d̶arejaimad̶a ñʉjeñecuva mácavʉ ne d̶aicõjeiye báquepe. ");
INSERT INTO cubNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aru ãiye bojed̶ainore jocarĩ copaivʉ bácavʉ cainʉmʉa cuyavarejaimad̶a ne bajure, ne ãrajiye jipocai. Aru ape ʉrarõ ñʉjeñecuva mácavʉ ne d̶aicõjeiye báquede d̶arejaimad̶a na. Quédeca joavarejaimad̶a ne jororʉare, ne cõaiñʉare, ne tãucõaiñʉare, aru ne paraiboare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Que baru ina fariseova aru Jʉ̃menijicʉi yávaiye báquede bueipõeva jẽniari jã́rejaimad̶a ʉ̃́re: —¿Aipe teni mi bueimara ne pʉrʉáre cojabedi ne ãrajiye jipocai? Yópe ãri majeñecuva mácavʉ ne d̶aicõjeiye báquepe d̶abema na, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesúcapũravʉ arejamed̶a náre: —Jãve Isaías bácʉ Jʉ̃menijicʉi yávaiyede coyʉcarejaquemavʉ mʉjare, jʉjovaivʉre. Yópe arĩ, Jʉ̃menijicʉ toivaicõjenejaquemavʉ ʉ̃ mácʉre: Ina põeva yʉre jʉ ad̶ama ne jijecamuque. Ʉbenita d̶abema yópe ji ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Bojecʉbenoque mearore jíniduyama yʉre. Bueniduyama põeva ne bueinore Jʉ̃menijicʉi yávaiyepe, arĩ toivarejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mʉja dajocarĩ jarʉvaivʉbu Jʉ̃menijicʉi d̶aicõjeiyede. Ʉbenita jʉ arĩ d̶aivʉbu mʉja põeva ne d̶aicõjeiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aru náre arejamed̶a cojedeca: —Jãve dajocarĩ jarʉvaivʉbu mʉja Jʉ̃menijicʉi d̶aicõjeiyede, d̶arãjivʉ yópe mʉjeñecuva mácavʉ ne d̶aicõjeiye báquepe. ");
INSERT INTO cubNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Que baru Jʉ̃menijicʉ coyʉrejaquemavʉ Moisés bácʉre, ʉ̃i toivaquiyepe ayʉ yópe: “Mipacʉre aru mipacore máre ʉrĩ, jʉ ajarã. Ʉbenita ñaine ãmeno coyʉyʉre jípacʉre o jípacore máre, mʉje jabova boarĩ́ jarʉvajarãri ʉ̃́re”, arejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ʉbenita mʉja bueivʉbu yópe, “Cũinácʉ põecʉ jípacʉre o jípacore ayʉ baru, ‘Mʉre cad̶ateyʉ bʉojabevʉ. Mʉ jacopʉjebu ji tãutʉrare. Ʉbenita jave jícacʉ yʉ Jʉ̃menijicʉre ji tãutʉrare’, ayʉ bájebu ʉ̃”, aivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mʉja ʉ̃́re cad̶ateicõjemevʉ bájebu jípacʉre o jípacore máre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Que teni Jʉ̃menijicʉi yávaiyede bojecʉbepe d̶arĩ, cõmajivʉbu mʉjeñecuva mácavʉ ne d̶aicõjeiye báquepe d̶aivʉ, ne bueiye báque Jʉ̃menijicʉi yávaiye pʉeno. Aru d̶aivʉbu mʉja cainʉmʉa iyepe paiyede, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cojedeca Jesús órejarejamed̶a ina põevare. Aru arejamed̶a náre: —Caivʉ yʉre jápiarĩ dápiajarã. ");
INSERT INTO cubNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Caiye iye ecoiye põevare jedevaque ãmeina tede d̶abevʉ náre. Ʉbenita caiye iye etaiye põeva ne ũmene ãmeina tede d̶aivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Me jápiajarã mʉja iye ji bueiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Que arĩ, dajocarĩ nʉri ina põevare jocarĩ, ecorejamed̶a cʉ̃rami. Ʉ̃i bueimara yore ʉ̃i coyʉino mácarõre jẽniari jã́rejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Aru náre arejamed̶a: —¿Mʉja máre jápiarĩ eabenarʉ? ¿Coreóvabenarʉ? Caiye iye ecoiye põevare jedevaque ãmeina tede d̶abevʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ecobevʉ ne ũmei. Ʉbenita ne yapibʉ jívʉi earĩ etaivʉ bajure jocarĩ, arejamed̶a. Caiye iye maje ãiye métamu aiyʉcʉ barejaquémavʉ Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cojedeca arejamed̶a: —Ʉbenita caiye iye etaiye põevare jocarĩ, ne dápiaiye, ãmeina tede d̶aivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ne ũmei ãmeina dápiad̶ama apevʉre. D̶ad̶ama ãmeina d̶aiyede apevʉque, némarebʉcʉva ãmevʉque. Ñavad̶ama apevʉ ne cʉvaede. Boarĩ́ jarʉvad̶ama põevare. ");
INSERT INTO cubNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nomicʉrivʉvacari apecoque cʉma aru nomiva máre ʉ̃mʉcʉrivʉvacari apecʉque cʉma némarebʉcʉvare jarʉvarĩ. Cʉvaiyʉma apevʉ ne cʉvaede. Ãmeina d̶aiyʉrĩ dápiad̶ama. Jʉjovad̶ama apevʉre. Ne baju ãmeno d̶ad̶ama. Jorojĩñama. Coyʉyama ãmenore apevʉi borore caivʉ ne jápiaiyede. “¿Meara márica?” ad̶ama. Aru ãrʉmevʉpe ãmeina d̶ad̶ama, coreóvaivʉvacari ñájinajivʉre ne que d̶aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Caiye iye ãmene etaiye põeva ne ũme jívʉquede, ãmeũme cʉre d̶aivʉ náre, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Diĩmarore jocarĩ Jesús nʉrejamed̶a apejoborõi, Tiro aru Sidón ãmicʉriĩmaroa yebai. Noi cũinád̶ami cʉ̃rami ecorejamed̶a. Aru apevʉ ne majinore ʉbedejamed̶a cʉcʉre noi. Ʉbenita dupini oabedejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Maumejie cũináco nomió ʉ̃i borore jápiarĩ, nʉri ʉ̃i yebai, ñʉatutarejacod̶a ʉ̃i cʉboba yebai. Cʉvarejacod̶a mamacore abujucʉ ʉ̃i ĩmamore. ");
INSERT INTO cubNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aru õ nomió judíovacaco ãmenejacod̶a. Sirofenicia ãmicʉrijoborõi põetedejacod̶a õ. Jesúre jẽniarejacod̶a, ʉ̃i etavaquiyepe ad̶o abujucʉre õi mácore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús arejamed̶a ṍre: —Meamevʉ ĩnu jʉed̶ova ne ãiyede, jínajivʉ yavimivare. Que baru jʉed̶ova ãjarari mamarʉmʉre, arejamed̶a Jesús. Que arĩ, aiyʉcʉ barejaquémavʉ judíovare Jʉ̃menijicʉi márape aru judíova ãmevʉre yavimivape. ");
INSERT INTO cubNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aru arejacod̶a ʉ̃́re: —Mʉ, ji jabocʉ, jãve coyʉivʉ mʉ. Ʉbenita yavimiva máre tʉoiva cãchinoi cʉrivʉ, jʉed̶ova ne ãri jarʉvaiyede ãd̶ama na, arejacod̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aru arejamed̶a ṍre: —Me copainʉjaco, mi que aiye boje. Abujucʉ jave etayʉme mímacore jocarĩ, arejamed̶a ṍre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cʉ̃rami copainʉri, earĩ, jã́rejacod̶a õi mácore õi parainoi meacore. Aru abujucʉ cʉbedejamed̶a ṍque. ");
INSERT INTO cubNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","No yóboi copainʉrejamed̶a Tiro ãmicʉriĩmaro cʉrijoborõre jocarĩ. Aru vaidéjamed̶a Sidón ãmicʉriĩmarore aru Decápolis ãmicʉrijoborõre máre, pʉ earĩta macajitabʉ ʉrabʉ Galilea ãmicʉrijitabʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Noi ʉ̃i cʉede, nʉvarejaimad̶a ʉ̃i yebai cũinácʉ ʉ̃mʉre, ñai jápiabecʉre aru yávarĩ majibecʉre. Aru jẽniarejaimad̶a Jesúre, ʉ̃i pʉrʉque tʉoquiyepe aivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Que baru Jesús nʉvarejamed̶a ʉ̃́re joajĩemaque apevʉre jocarĩ. Doarejamed̶a ʉ̃i ãmuyoare ñai ʉ̃mʉ ʉ̃i cámucobea jívʉi. Aru ʉ̃i ãmuyoare jẽcuturi tʉorejamed̶a ñai ʉ̃mʉ ʉ̃i jemedore. ");
INSERT INTO cubNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Cavarõre jã́ri, ũme dapurĩ, arejamed̶a: “Efata”. “Efata” aino, voajarõ aiyʉrõtamu no. ");
INSERT INTO cubNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Que arĩ, Jesús ñai jápiabecʉ bácʉre jápiare d̶arĩ, ñai yávabecʉ bácʉre yávare d̶arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Que teniburu Jesús apevʉre coyʉicõjemenejamed̶a náre pare, ne majibenajiyepe ayʉ. Ʉbenita cainʉmʉa ʉ̃i coyʉrĩduiyedeca yóboi, cainʉmʉa coyʉrejaimad̶a ʉ̃i borore pʉeno baju. ");
INSERT INTO cubNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Aru pare cuecumari arejaimad̶a ʉ̃́re: —Ʉ̃ d̶aibi cainʉmʉa méne. Jápiare d̶ayʉbe jápiabevʉ bácavʉre. Aru yávare d̶ayʉbe yávabevʉ bácavʉre máre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Apejãravʉi bedióva cójijidejaimad̶a obedivʉ põeva Jesús yebai. Aru ãiyede cʉvabedejaimad̶a na. Que baru Jesús órejarejamed̶a ʉ̃i bueimarare ʉ̃i yebai. Aru arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Cõmaje ãroje jã́ivʉ yʉ ina põevare. Ina obedivʉ cʉma yʉ́que yóbecʉrijãravʉa. Aru ãiyede cʉvabema. ");
INSERT INTO cubNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Apevʉ ne cʉ̃ramia joarõtamu. Que baru ji copaicõjenu náre ne cʉ̃ramiai, mái nʉri mamad̶ajebu, ne ãvʉé ñájiye boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ʉ̃i bueimara jẽniari jã́rejaimad̶a ʉ̃́re: —¿Ʉbenita aipe d̶arĩ jínajidi ãiyede caivʉ ina põevare, ne ãrajiyepe yui põecʉbenoi? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús jẽniari jã́rejamed̶a náre: —¿Aipiboa pã́uboare cʉvarãrʉ mʉja? arejamed̶a. Aru arejaimad̶a: —Siete paiboabu, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Que aiyede, ina põevare dobaicõjenejamed̶a joborõi. Aru diboá pã́uboa siete paiboare ĩni, torojʉede jíni Jʉ̃menijicʉre, diboáre cotʉvarĩ jídejamed̶a ʉ̃i bueimarare, ne jínajiyepe ayʉ põevare. Aru nópe d̶arĩ jídejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Obebejĩna moajinare máre cʉvarejaimad̶a. Jʉ̃menijicʉre torojʉede jíniburu yóboi, jícõjenejamed̶a náre máre. ");
INSERT INTO cubNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Que d̶aiyede, ãri yapidejaimad̶a caivʉ. Ãri bubarĩburu yóboi, iye cotʉvaiye báque pã́u aru moa máre, põeva ne ãri oabede ĩni, mead̶arĩ, pʉeá siete paipʉeare, judíova ãmevʉ ne pʉeáre, buivárejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Aru ina ãivʉ bácavʉ põeva yóvaicʉvaimil baju barejáimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesús copaicõjenejamed̶a náre, ʉ̃́re jocarĩ. No yóboi, maumejiena jaturejamed̶a jiad̶ocũi ʉ̃i bueimaraque. Aru nʉrejaimad̶a apejoborõi, Dalmanúta ãmicʉrijoborõita. ");
INSERT INTO cubNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Apevʉ fariseovacavʉ nʉrejaimad̶a Jesús yebai. Aru ãmeina boro coyʉrĩ bʉ́rejaimad̶a ʉ̃́re. Jã́iyʉrejaimad̶a ʉ̃i jã́d̶ovaiyede cavarõ mearo Jʉ̃menijicʉi cʉrõquede, jʉjovarĩdurãjivʉ ʉ̃́re. Yópe arĩ, põeva ne d̶arĩ majibede d̶aicõjenidurejaimad̶a ʉ̃́re: —Mʉ, Jesús, jã́d̶ovajacʉ ñʉjare apede mi d̶aiyede Jʉ̃menijicʉi parʉéque, ñʉje majinajiyepe aivʉ jãve mʉre Jʉ̃menijicʉi daroimʉ mácʉre, arĩdurejaimad̶a Jesúre. Nópe arĩ, ʉ̃́re jʉjovaiyʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aru chĩori, ũme dapurĩ pare, arejamed̶a: —¿Aipe teni ijãravʉcavʉ jã́d̶ovaiyede jã́iyʉri? Jãve coyʉyʉbu mʉjare: Ijãravʉcavʉ jã́menajarama jã́d̶ovaiye cavarõ mearo Jʉ̃menijicʉi cʉrõquede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Que arĩ, náre dajocarĩ, jiad̶ocũi jaturĩ cojedeca, jatarĩ nʉrejamed̶a apedʉvei. ");
INSERT INTO cubNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesúi bueimara ãrʉmeteivʉ bácavʉ pã́ure, quénora cʉvarejaimad̶a cũinábo pã́ubore náque jiad̶ocũi. ");
INSERT INTO cubNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aru Jesús cõjeñʉ arejamed̶a náre: —Me d̶ajarã. Me jã́jara ina fariseova aru ñai Herodes máre ne pã́ure bʉcʉóvare d̶aiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ʉ̃i que aiyede, arejaimad̶a ne bajumia: —Ʉ̃ yópe aibi, maje pã́ure cʉvabe boje, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ʉbenita Jesús coreóvarejamed̶a ne yávainore. Que baru arejamed̶a náre: —¿Aipe teni coyʉivʉrʉ̃ mʉja “Pã́ure cʉvabevʉ ñʉja” aivʉ? ¿Coreóvabenarʉ cãreja? ¿Majibenarʉ cãreja? ¿Dápiabeni coreóvabenarʉ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Yacorʉa cʉvarivʉvacari, jã́menarʉ? ¿Aru cámucobea cʉvarivʉvacari, jápiabenarʉ? ");
INSERT INTO cubNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Aru ãrʉmenarʉ? ¿Yʉ cotʉvacavʉ cũinápʉrʉpe paiboa pã́uboare ina cũinápʉrʉpe paimil baju ʉ̃mʉvare, aipipʉebʉa cotʉvaiye báqueque ĩcanarʉ mʉja? arejamed̶a náre Jesús. Na jʉ arejaimad̶a ʉ̃́re: —Doce paibʉa pʉebʉa baju ĩcarã ñʉja, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús arejamed̶a náre cojedeca: —¿Aru yʉ cotʉvacavʉ siete paiboare ina yóvaicʉvaimil baju ʉ̃mʉvare, aipipʉea cotʉvaiye báqueque ĩcanarʉ mʉja? arejamed̶a. Aru na jʉ arejaimad̶a ʉ̃́re: —Siete paipʉea baju ĩcarã ñʉja, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Dinʉmʉre arejamed̶a náre: —¿Aipe teni majibenarʉ cãreja? Coyʉyʉbu mʉjare: Me jã́jara ina fariseova aru Herodes máre ne dápiaiyede, mʉje dápiabenajiyepe ne dápiainope, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","No yóboi earejaimad̶a Betsaida ãmicʉriĩmaroi. Apevʉ põeva nʉvarejaimad̶a Jesús yebai cũinácʉ ʉ̃mʉ, jã́ri eabecʉre. Aru Jesúre jẽniarejaimad̶a, ʉ̃i pʉrʉque tʉoquiyepe aivʉ ñai ʉ̃mʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Que teni jã́ri eabecʉ ʉ̃i pʉrʉre jẽni, nʉvarejamed̶a ʉ̃́re diĩmarore jocarĩ. Aru jẽcuturi ʉ̃i yacorʉarã, ʉ̃́re tʉorĩ ʉ̃i pʉrʉáque, jẽniari jã́rejamed̶a ʉ̃́re: —¿Apejĩene jã́ñʉrʉ cari? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Quĩ́jino jã́ri, arejamed̶a: —Jã́ivʉ yʉ ʉ̃mʉvare. Ʉbenita jocʉcʉape ãrojama cuivʉ, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cojedeca Jesús tʉorejamed̶a ʉ̃i yacorʉarã. Que teni ñai ʉ̃mʉ cocorejamed̶a me. Jã́ri earejamed̶a cojedeca. Aru me jã́rejamed̶a caiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús copaicõjenejamed̶a ʉ̃́re ʉ̃i cʉ̃rami, yópe arĩ: —Diĩmaroi ecobejacʉ mʉ, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús nʉrejamed̶a ʉ̃i bueimaraque ĩmaroai Cesarea de Filipo ãmicʉriĩmaro joabejĩnoi. Aru mái nʉre nʉiyede jẽniari jã́rejamed̶a ʉ̃i bueimarare yópe: —¿Aipe aidi põeva yʉre? ¿“Yécʉbebu”, aidi yʉre? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Arejaimad̶a ʉ̃́re: —Apevʉ ad̶ama, “Juan Bautistabe”. Aru apevʉ ad̶ama, “Elíabe”. Aru apevʉ ad̶ama, “Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉbe ʉ̃”, ad̶ama mʉre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Aru jẽniari jã́rejamed̶a náre: —¿Ʉbenita aipe aivʉrʉ̃ mʉja yʉre? arejamed̶a Jesús. Aru Pedro arejamed̶a ʉ̃́re: —Mʉ Jʉ̃menijicʉi daroimʉ mácʉbu. Ñʉjare jabotecʉyʉmu mʉ, arejamed̶a Pedro Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aru náre coyʉicõjemenejamed̶a apevʉre ʉ̃i borore. ");
INSERT INTO cubNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús, yópe arĩ, bueni bʉ́rejamed̶a náre: —Jaʉvʉ yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, ʉrarõ ji ñájiquino. Ina judíova bʉcʉva, aru sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre yʉre boarĩ́ jarʉvarãjarama. Aru yóbecʉrijãravʉa yóboi nacajacʉyʉmu yʉ yainore jarʉvarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Caiye iyede coyʉrejamed̶a náre. Aru ʉ̃i coyʉiye báque maiyójabedejavʉ̃ya náre, ne jápiarĩ earãjiyepe aiye. Dinʉmʉre Pedro nʉvarejamed̶a ʉ̃́re apevʉ ina bueimarare jocarĩ. Aru parʉrõque jararĩ bʉ́rĩdurejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ʉbenita Jesús, copedini jã́rejamed̶a apevʉ ʉ̃i bueimarare. Aru Pedro cʉrejamed̶a ʉ̃i yóboi. Que teni jararĩ arejamed̶a ʉ̃́re: —Mʉ, Satanás, jʉjovarĩdubejacʉ yʉre. Nʉjacʉ yʉre jocarĩ. Dápiaivʉ mʉ põevape. Aru dápiabevʉ mʉ Jʉ̃menijicʉ jiede, arejamed̶a Pedrore. ");
INSERT INTO cubNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús órejarejamed̶a ʉ̃i yebai obedivʉ põevare ʉ̃i bueimaraque. Aru arejamed̶a náre: —Ácʉ põecʉ daiyʉcʉ yʉ́que, dajocajacʉrĩ põeva ne mearo jã́iyede ʉ̃́re, cʉyebejacʉrĩ yʉre yóvaiyede, aru jidʉbejacʉrĩ ʉ̃i ñájiquiyede. Nópe d̶abecʉ baru, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ñai põecʉ ʉ̃i baju ʉrõpe d̶arĩ, mead̶aiyʉcʉ baru ʉ̃i bajure, coatecʉyʉme ʉ̃i bajure Jʉ̃menijicʉre jarʉvarĩ, yópe yaiyʉ́ bácʉpe ʉ̃i ũmei. Ʉbenita ñai põecʉ, “Ye baju ãmevʉ, ji yaidú Cristore boje” ayʉ, ʉ̃i baju ʉrõpe d̶abecʉva quénora ji ʉrõpe d̶arĩ, ʉ̃́recabe ji mead̶aquimʉ, cʉcʉyʉ Jʉ̃menijicʉque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","37","Ñai põecʉ cʉvacʉ baru caiye ijãravʉquede, ʉbenita bíjayʉ baru ʉ̃i ũmene, ñájicʉyʉme cainʉmʉa toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aru ñai põecʉi cʉyedu yʉre aru ji yávaiyede máre ijãravʉcavʉ ãmeina teivʉ ne jã́iyede, yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, máre cʉyeni dápiacʉyʉmu ʉ̃́re ji jã́d̶ovaiyede jipacʉ meacʉ baju ʉ̃i mearore ji daiyede ina ángeleva mearaque máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Aru arejamed̶a náre cojedeca: —Jãve coyʉyʉbu mʉjare: Apevʉ cʉrivʉ yui, ne yainájiye jipocai jã́rajarama Jʉ̃menijicʉi jaboteino cʉrõre parʉéque, ji jaboteiyede põevare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis paijãravʉa yóboi, Jesús nʉvarejamed̶a Pedrore, Santiagore, aru Jũare máre. Jipocatedejamed̶a náre cʉ̃racũ ʉ̃mʉjʉricũ pʉenoi, apevʉre jocarĩ. Aru na jã́rejaimad̶a ʉ̃i oatʉvaiye me bajure. ");
INSERT INTO cubNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yópe barejávʉ̃ya. Ʉ̃i cuitótecaje pẽorejavʉ̃ya, pare boricaje ʉ̃i cuitótecaje. Ijãravʉre joaipõecʉ yópe boricaje d̶arĩ majibebi. ");
INSERT INTO cubNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Aru járorejaimad̶a Elías Moisémaque, boroteivʉ Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Dinʉmʉ Pedro arejamed̶a Jesúre: —Mʉ, bueipõecʉ, mearotamu ñʉje cʉru yui. Que baru d̶arãjivʉbu ñʉja yóbecʉriñamia cʉ̃ramia quĩ́jiñamia maquiyéde, cũinád̶ami míñami maquinóre, aped̶ãmi maquinóre Moiséde, aru aped̶ãmi maquinóre Elíare, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pare cuecumarejaimad̶a na. Que baru Pedro majibedejamed̶a aipe ʉ̃i ainore. ");
INSERT INTO cubNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dinʉmʉma ocopenibo ẽmeni taorejavʉ̃ya náre. Aru jápiarejaimad̶a apeno yávainore ocopeniboi etaiyede: “Ñaime jímacʉ, ji ʉmʉ. Que baru jápiajarã ʉ̃́re”, arejamed̶a Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aru yávarĩburu yóboi, jã́rejaimad̶a Jesúre cũinácʉra. ");
INSERT INTO cubNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ne ẽmeni daiyede dicũ cʉ̃racũre jocarĩ, Jesús apevʉre coyʉicõjemenejamed̶a náre ne jã́ino mácarõre. Yópe arejamed̶a: —Me jápiajarã mʉja. Coyʉbejarã apevʉre no mʉje jã́ino mácarõre cʉ̃racũ ʉ̃mʉjʉricũ pʉenoi, ji nacajariburu yóboita yainore jarʉvarĩ. Yʉ́bu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Que baru jʉ aivʉ ʉ̃́re, coyʉbedejaimad̶a apevʉre no ne jã́ino mácarõre. Aru jẽniari jã́rejaimad̶a ne bajumia, “¿Aipe aiyʉcʉba yo ʉ̃i aino nacajainore yainore jarʉvarĩ?” arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Que teni jẽniari jã́rejaimad̶a ʉ̃́re: —¿Aipe teni aivʉba ina Jʉ̃menijicʉi yávaiye báquede bueipõeva, “Mamarʉmʉ Elías dacʉyʉme, ñai Jʉ̃menijicʉi daroimʉ ʉ̃i daquiye jipocai”? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aru arejamed̶a náre: —Jãve Elías dacʉyʉme Jʉ̃menijicʉi daroimʉ ʉ̃i daquiye jipocai, mead̶acʉdayʉ caiyede. Toivarejaquemavʉ yópe yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe: “Pare ñájine d̶arãjarama põeva ʉ̃́re. Aru ʉbenama ʉ̃́re”, arĩ toivarejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ʉbenita jave dáme Elías, ayʉbu yʉ mʉjare. Aru põeva ne ʉrõpe d̶aima ʉ̃́re, yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃́re, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Apevʉ Jesúi bueimara yebai earĩ, jã́rejaimad̶a ina bueimarare obedivʉ põeva jẽneboi. Aru Jʉ̃menijicʉi yávaiye báquede bueipõeva jararĩ yávarejaimad̶a náque. ");
INSERT INTO cubNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús ʉ̃i eaiyede, ina põeva ʉ̃́re jã́ri, torojʉrĩ cúyarejaimad̶a ʉ̃i yebai, ʉ̃́re jacoyʉrãnʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús jẽniari jã́rejamed̶a náre: —¿Yéde yávaivʉrʉ̃ mʉja náque? arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cũinácʉ põecʉ põeyajubo jẽneboi arejamed̶a ʉ̃́re: —Mʉ, bueipõecʉ, jímacʉre abujucʉ ĩmami. Aru yávaicõjememi ʉ̃́re. Que baru ʉ̃́re davarĩduvʉ yʉ mi yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ñai abujucʉ cainʉmʉa bidióvarĩ tʉre d̶ávabi ʉ̃́re joborõi. Aru aburi etavavʉ ʉ̃́re. Cõpi cṹvabi ʉ̃. Aru ʉ̃i baju jãjatevabi ʉ̃. Que baru yʉ jẽniariduvʉ mi bueimarare, ne jaetovarãjiyepe ayʉ ñai abujucʉre. Ʉbenita na ñaine jarʉvarĩ majibema, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aru Jesús arejamed̶a náre: —Mʉja, ijãravʉcavʉ, Jʉ̃menijicʉre jʉ abevʉ, ¿aipijãravʉa cʉquidi yʉ mʉjaque? ¿Aru aipijãravʉa ñájiquidi yʉ mʉjaque, mʉje jʉ arãjiyepe ayʉ ji coyʉiyede? Davajarã ñai jʉed̶ocʉre ji yebai, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nʉvarejaimad̶a jʉed̶ocʉre Jesús yebai. Aru ñai abujucʉ Jesúre jã́ri, jʉed̶ocʉre bidióvarĩ, tʉre d̶arejamed̶a joborõi. Joborõi tʉrĩ, ñai jʉed̶ocʉ jãtururejamed̶a. Aru aburi etarejavʉ̃ya ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús jẽniari jã́rejamed̶a jípacʉre yópe: —¿Aipinʉmʉa baju abujucʉ ĩmari ʉ̃́re? arejamed̶a Jesús. Aru jípacʉ jʉ arejamed̶a: —Javeita, quĩ́jicʉrata. ");
INSERT INTO cubNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aru apenʉmʉa ʉ̃́re bidióvarĩ, tʉre d̶arĩ toaboi aru jiai, boarĩ́ jarʉvarĩduvabi ʉ̃́re. Ʉbenita bʉojayʉ baru cõmaje ãroje jã́ri, cad̶atejacʉ ñʉjare, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús arejamed̶a ʉ̃́re: —¿Bʉojayʉ baru, ayʉrʉ̃ mʉ? Yʉ caiyede d̶acarĩ majivʉ mʉre, yʉre mi jʉ aru, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Maumejie ñai jʉed̶ocʉi pacʉ cod̶oboborejamed̶a: —Mʉre jʉ aivʉ yʉ. Cad̶atejacʉ yʉre ji jʉ aiye parʉé baquiyépe, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Dinʉmʉre Jesús jã́ri obedivʉ põeva cúyaivʉre ʉ̃i yebai, parʉéque etaicõjenejamed̶a abujucʉre. Arejamed̶a: —Mʉ, abujucʉ, ñai jʉed̶ocʉre yávaicõjemecʉ aru jápiaicõjemecʉ, yʉ cõjeivʉ mʉre. Etajacʉ ʉ̃́re jocarĩ. Aru ĩmamejacʉ ʉ̃́re cojedeca, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Que ayʉ Jesús, ñai abujucʉ cod̶oboborĩ aru pare bidióvarĩ, tʉre d̶arĩ jʉed̶ocʉre, etarejamed̶a ʉ̃́re jocarĩ. Que teni ñai jʉed̶ocʉ yaiyʉ́ bácʉpe pararejamed̶a. Que baru ina põeva obedivʉ “Jave yaibí ʉ̃”, arĩdurejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ʉbenita Jesús, ʉ̃i pʉrʉre jẽni, nacovarejamed̶a ʉ̃́re. Aru ñai jʉed̶ocʉ nacajarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Que d̶arĩburu yóboi, Jesús ecorejamed̶a cʉ̃rami. Nore ʉ̃i bueimara jẽniari jã́rejaimad̶a ʉ̃́re cũinácʉra, yópe arĩ: —¿Aipe teni ñʉja jaetovarĩ majibetedi ñai abujucʉre? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Náre arejamed̶a: —Jʉ̃menijicʉre jẽniaiye jaʉvʉ ãmevʉva ãiyede, abujucʉ ñaipe páyʉre mʉje jaetovarãjiyepe aivʉ, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nore jocarĩ nʉivʉ, Jesújã vaidéjaimad̶a Galilea ãmicʉrijoborõre. Aru põeva ne majiéde ʉbedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ʉ̃ bueyʉ barejámed̶a ʉ̃i bueimarare. Que baru apevʉ põeva ne eaiyede ʉ̃i yebai ʉbedejamed̶a Jesús. Yópe arĩ, buedejamed̶a ʉ̃i bueimarare: —Yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jẽni jínajivʉbu ji mauvare, ne boarĩ́ jarʉvarãjiyepe ayʉ yʉre. Aru yóbecʉrijãravʉa yóboi, nacajacʉyʉmu yʉ yainore jarʉvarĩ, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ʉbenita jápiarĩ eabedejaimad̶a ʉ̃i coyʉino mácarõre. Aru jidʉrivʉ jẽniari jã́iyʉbedejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesújã earejaimad̶a Capernaum ãmicʉriĩmaroi. Aru ecorejaimad̶a cʉ̃rami. Cʉ̃rami jívʉi cʉrivʉ, Jesús jẽniari jã́rejamed̶a ʉ̃i bueimarare yópe: —¿Ye batedí mʉje borotede daiye mái? arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ʉbenita coyʉbedejaimad̶a ʉ̃́re, ne borotede daiye báque boje ñamene parʉcʉre ne jẽneboi apevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Dinʉmʉre Jesús dobacʉnʉrejamed̶a, buecʉyʉ. Órejarejamed̶a ina doce paivʉ ʉ̃i bueimarare. Aru arejamed̶a náre: —Ñai põecʉ ʉ̃i cõjeiyʉru apevʉre, dápiaiye jaʉvʉ ʉ̃́re yópe parʉbecʉpe. Aru caivʉ ne yebacacʉpe bacʉyʉ́me ʉ̃. Apevʉre bojecʉbe memecaiye jaʉvʉ ʉ̃́re, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Que arĩburu, Jesús jẽnejamed̶a cũinácʉ jʉed̶ocʉre. Aru núvari ʉ̃́re ne coricai, dʉrʉrĩ ʉ̃́re ʉ̃i ãmuveaque, arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Cũinácʉ põecʉ copʉ etayʉ baru cũinácʉ jʉed̶ocʉre ji ãmiái, ji cõjeiyepe, que d̶ayʉ nopedeca copʉ etaibi yʉre. Aru cũinácʉ põecʉ copʉ etayʉ baru yʉre, copʉ etaibi ñai yʉre daroyʉre máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan arejamed̶a Jesúre: —Mʉ, bueipõecʉ, jã́carã ñʉja cũinácʉ ʉ̃mʉ abujuvare jaetovayʉre mi ãmiái, mi parʉéque. Ʉbenita ñʉjaque ʉ̃i cʉbe boje, “D̶abejacʉ” acarã ñʉja ʉ̃́re, arejamed̶a Juan. ");
INSERT INTO cubNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ʉbenita Jesús arejamed̶a náre: —Ñai d̶ayʉ põeva ne d̶arĩ majibede ji ãmiái, ji parʉéque, no yóboi ãmeina yávabecʉbe yʉre. Que baru nópe abejarã mʉja ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ñai põecʉ maucʉvabecʉ majare quénora majacacʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Que baru jãve coyʉyʉbu mʉjare: Ácʉ põecʉ jíyʉ baru cũinárʉ jororʉre ocoque, cad̶atecʉyʉ cũinácʉ ji bueimaracacʉre, ʉ̃i yóvaiye boje yʉre, jãve bíjabecʉyʉme Jʉ̃menijicʉi me bojed̶aiyede ʉ̃́re, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Bedióva buedejamed̶a Jesús, yópe arĩ: —Ácʉ põecʉ ʉ̃i vainí tʉre d̶aru apecʉ yʉre jʉ ayʉre parʉbecʉreca, ʉ̃i dajocaquiyepe ayʉ ʉ̃i jʉ aiyede yʉre, meajebu ʉ̃́re jarʉvaru jia ʉrad̶ai ʉ̃i ñamemui bʉorĩ cũinábo cʉ̃rabo ʉraboque. ");
INSERT INTO cubNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Aru mʉ ãmeina teyʉ baru mi pʉrʉque, burarĩ jarʉvajacʉ dipʉrʉre. Meaquiyebu mʉre, mi earu cavarõ mearo Jʉ̃menijicʉi cʉrõi cũinápʉrʉque. Ʉbenita meamequiyebu mʉre, mi nʉru toabo cũiméboi caipʉcapʉrʉaque. ");
INSERT INTO cubNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Aru mʉ ãmeina teyʉ baru mi cʉbobaque, burarĩ jarʉvajacʉ dibare. Meaquiyebu mʉre, mi earu cavarõ mearo Jʉ̃menijicʉi cʉrõi cũinába cʉbobaque. Ʉbenita meamequiyebu mʉre, mi nʉru toabo cũiméboi caipʉcaba cʉbobaque. ");
INSERT INTO cubNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Aru mʉ ãmeina teyʉ baru mi yacorʉque, ĩni jarʉvajacʉ didʉre. Meaquiyebu mʉre, mi ecoru Jʉ̃menijicʉi jaboteinore cũinárʉ yacorʉque. Ʉbenita meamequiyebu mʉre, mi nʉru toabo cũiméboi pʉcarʉa yacorʉaque. ");
INSERT INTO cubNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nore toabo cũimébo cʉrõi cʉma júva yaibévʉ. Que baru põeva nore nʉivʉ baru cainʉmʉa ñájinajarama na, toabore aru júvare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Mead̶aivʉ maje ãiyede yuquiraque. Nopedeca ñájiye mead̶aivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yuquira maje ãiyede mead̶aivʉ. Ʉbenita yuquira vaijʉe bíjaru, ãiyede mead̶aiye bʉojabevʉ. Aru mʉja máre yuquirape bájarã. Nópe yuquira mead̶aiyepedeca maje ãiyede, cad̶atejarã mʉjevʉre. Aru cãrijimene d̶arĩ, me cʉjarã mʉjevʉque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Bueniburu yóboi, Jesús etarejamed̶a ne ĩmarore jocarĩ. Aru nʉrejamed̶a Judea ãmicʉrijoborõi aru Jordán ãmicʉriya jia apedʉvei máre. Bedióva cojedeca obedivʉ põeva cójijidejaimad̶a ʉ̃i yebai. Aru ʉ̃i d̶arĩ cõmajiyepe, bueyʉ barejámed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseovacavʉ máre nʉrejaimad̶a ʉ̃i yebai, jʉjovaiyʉrivʉ ʉ̃́re, jẽniari jã́rejaimad̶a: —¿Cũinácʉ ʉ̃mʉ jarʉvayʉ baru jímarepacore, d̶aidi yópe maje d̶aicõjeiyepe? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Náre arejamed̶a Jesús: —¿Aipe d̶aicõjenejaquemari Jʉ̃menijicʉ, ʉ̃i toivaicõjeiye báquede Moisés bácʉre? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aru arejaimad̶a: —Moisés bácʉ jícõjenejaquemavʉ põecʉre cũináyoca “Mʉre jarʉvayʉbu yʉ” aiyocare jímarepacore, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Aru Jesús arejamed̶a: —Moisés bácʉ jarʉvaicõjenejaquemavʉ mʉjare mʉjemarepacore, mʉje Jʉ̃menijicʉi d̶aicõjeiyede jápiaiyʉbe boje. ");
INSERT INTO cubNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ʉbenita mamarʉmʉre, Jʉ̃menijicʉ cʉed̶arejaquemavʉ caiyede. “Ʉ̃mʉ macʉyʉ́re aru nomió macod̶óre máre d̶arejaquemavʉ Jʉ̃menijicʉ”. ");
INSERT INTO cubNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Aru, “Que baru caride ácʉ põecʉ jímarepaco bacod̶ó cʉvacʉyʉ, ʉ̃i bʉcʉvare dajocacʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aru jímarepacore cʉvarĩ, ṍmaque cũinávʉpetamu na Jʉ̃menijicʉi jã́inore”. ");
INSERT INTO cubNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Que baru pʉcarã ãmema. Quénora cũinávʉpetamu na. Que baru põecʉ Jʉ̃menijicʉi cójijovaimara mácavʉre coavabejacʉrĩ ʉ̃, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","No yóboi, cʉ̃rami jívʉi ina ʉ̃i bueimara jẽniari jã́rejaimad̶a ʉ̃́re cojedeca aipe iye ʉ̃i coyʉiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Náre arejamed̶a: —Ácʉ põecʉ jímarepacore jarʉvarĩburu yóboi pʉrʉbʉoyʉ baru apecoque, nomicʉcʉvacari apecoque cʉcʉ baru, ãmeina d̶aibi ṍre ʉ̃i mamarʉmʉcacore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Aru áco põeco jímarepacʉre jarʉvarĩburu yóboi pʉrʉbʉod̶o baru apecʉque, ʉ̃mʉcʉcovacari apecʉque cʉco baru, ãmeina d̶aibico ʉ̃́re õi mamarʉmʉcacʉre jarʉvarĩ, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Põeva nʉvare cuivʉ barejáimad̶a némarare Jesús yebai, ʉ̃i tʉoquiyepe aivʉ náre ʉ̃i pʉrʉáque. Que teni ʉ̃i bueimara nʉvaicõjemenidurejaimad̶a némarare. ");
INSERT INTO cubNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ʉbenita Jesús jã́rejamed̶a náre ne que d̶aiyede. Pare cojʉbedejavʉ̃ya ʉ̃́re. Que baru arejamed̶a náre: —Ina jʉed̶ova dajarãri ji yebai. Jʉ̃menijicʉ jabotecʉyʉme põevare nápe paivʉre. Que baru, “Davabejarã jʉed̶ovare”, abejarã náre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ copʉ etabecʉ baru Jʉ̃menijicʉre jaboteyʉre ʉ̃́re, yópe jʉed̶ocʉ ʉ̃i copʉ etaiyepe, ecobecʉyʉme ʉ̃i jaboteinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Que arĩ, Jesús ĩni dʉrʉrejamed̶a ina jʉed̶ovare ʉ̃i ãmuveaque. Náre coapa dʉrʉrĩ, tʉorĩ ʉ̃i pʉrʉáque, mearore jídejamed̶a náre Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús ʉ̃i nʉiyede cojedeca, cũinácʉ ʉ̃mʉ cúyarĩ ñʉatutarejamed̶a ʉ̃i yebai. Aru jẽniari jã́rejamed̶a ʉ̃́re: —Mʉ, bueipõecʉ meacʉ, ¿aipe d̶aji yʉ, cʉvacʉyʉ jãravʉ cũiméjãravʉ baquinóre? arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús arejamed̶a ʉ̃́re: —¿Aipe teni “Meacʉbu mʉ”, ayʉrʉ̃ yʉre? Jʉ̃menijicʉ cũinácʉrabe meacʉ baju. ");
INSERT INTO cubNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Majivʉra mʉ Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquede Moisés bácʉre: “Põevare boarĩ́ jarʉvabejacʉ. Cʉvabejacʉ apecore mimarepacore jarʉvarĩ. Ñavamejacʉ apecʉ ʉ̃i cʉvaede. Borod̶abejacʉ apecʉre. Borocʉrĩ ĩmejacʉ apecʉ ʉ̃i cʉvede. Jʉ ajacʉ mipacʉre aru mipacore máre”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Que teni arejamed̶a Jesúre: —Mʉ, bueipõecʉ, d̶acacʉ caiye iye mi coyʉiyede jʉed̶ocʉ cãreja yʉ, aru caride máre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ʉ̃́re jã́ri, ʉrejamed̶a. Aru arejamed̶a ʉ̃́re: —Cũináro jaʉvʉ mʉre cãreja. Nʉjacʉ aru jíni bojed̶ajacʉ mi cʉvede. Aru mi ĩquiyede jíjacʉ ina cõmaje ãrojarivʉre. Que teni cʉvacʉyʉmu mʉ boje méne cavarõ mearo Jʉ̃menijicʉi cʉrõi. Aru dajacʉ yʉ́que, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Iyede jápiarĩ, ñai ʉ̃mʉ cojʉbeteni aru ʉrarõ baju chĩori nʉrejamed̶a Jesúre jocarĩ, dajocaiyʉbecʉ ʉ̃i ʉre cʉvede. ");
INSERT INTO cubNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Que teni Jesús ʉ̃i bueimarare jã́ri, arejamed̶a náre: —Ina põeva cʉve cʉvarivʉre pare maiyójavʉ ne jʉ aiye Jʉ̃menijicʉre, ʉ̃i mead̶aquiyepe aivʉ náre aru ne ecorãjiyepe aivʉ ʉ̃i jaboteinore, cavarõ mearo ʉ̃i cʉrõre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iye ʉ̃i coyʉiyede jápiaivʉ bácavʉ ʉ̃i bueimara, cuecumarejaimad̶a. Aru Jesús arejamed̶a náre cojedeca: —¡Mʉja, ji ʉmara, pare maiyójavʉ cʉve cʉvarivʉre ecoiyʉrivʉre Jʉ̃menijicʉi jaboteinore! ");
INSERT INTO cubNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cũinácʉ ãimacʉ ʉracʉ, camello ãmicʉcʉ, ʉ̃i ecoru aviyo cobei, maiyójajebu ʉ̃́re. Aru pʉeno maiyójavʉ cʉve cʉvacʉre ʉ̃i ecoquino Jʉ̃menijicʉi jaboteinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ʉrarõreca cuecumaivʉ, arejaimad̶a ʉ̃́re: —¿Ñame bʉojarĩ ecorãjidica Jʉ̃menijicʉi jaboteinore, cʉvarãjivʉ jãravʉ cũiméjãravʉ baquinóre? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesúcapũravʉ náre jã́ri, arejamed̶a: —Põeva ne d̶arĩ majibeno maiyójabevʉ Jʉ̃menijicʉre. Ʉ̃ cũinácʉra bʉojarĩ mead̶ayʉbe põevare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aru Pedro arejamed̶a ʉ̃́re: —Dajocacarã ñʉja caiye ñʉje cʉvaede, ñʉje daiye boje mʉ́que, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jesús arejamed̶a: —Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ dajocayʉ baru ʉ̃i cʉ̃ramine, o jíbʉrãre, ĩmarare, jípacore, jípacʉre, mamarare, o ʉ̃i joborõre máre, ʉ̃i daiye boje yʉ́que, aru Jʉ̃menijicʉi yávaiye méne coyʉiye boje máre, eacʉyʉme pʉeno baju caride ijãravʉi cʉ̃ramiare, aru jíbʉrãre, ĩmarare, jíbʉcʉrõmivare, mamarare, aru ʉ̃i joborõare máre apevʉ ñájine d̶aivʉreca ʉ̃́re, daquijãravʉ baquinói cʉvacʉyʉme jãravʉ cũiméjãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Dinʉmʉre apevʉ jaboteivʉ bácavʉ ijãravʉre, jabotebenajarama na Jʉ̃menijicʉi jabotequiyede. Aru apevʉ jabotebevʉ bácavʉ ijãravʉre, jabotenajarama na Jʉ̃menijicʉi jabotequiyede, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mái nʉre nʉivʉ barejáimad̶a Jerusalén ãmicʉriĩmaroi. Jesús nʉrejamed̶a ne jipocai. Ʉ̃i bueimara cuecumarejaimad̶a. Aru apevʉ máre, náre cujuivʉ, jidʉrejaimad̶a. Cojedeca Jesús nʉvarejamed̶a ina doce paivʉre apevʉre jocarĩ. Aru coyʉrĩ bʉ́rejamed̶a náre põeva ne d̶arãjiyede ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Coyʉrĩ arejamed̶a yópe: —Jerusalẽ́i nʉivʉbu. Nore cʉrĩ, yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, ji maucʉ jẽni jíquijibi sacerdotevare jaboteipõevare aru Jʉ̃menijicʉi yávaiye báquede bueipõevare máre. Ina põeva arãjivʉbu: “¡Boarĩ́ jarʉvajarã ʉ̃́re! ¡Yaijácʉrĩ!” Que arĩ, jínajivʉbu yʉre ina judíova ãmevʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Que teni ina põeva yʉrinajivʉbu yʉre. Jẽcututurajivʉbu yʉre. Jara popenajivʉbu yʉre. Aru boarĩ́ jarʉvarãjivʉbu yʉre. Ʉbenita yóbecʉrijãravʉa yóboi, jipacʉ, Jʉ̃menijicʉ, nacovacʉyʉme yʉre yainore jarʉvarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago aru Juan máre, Zebedeoi mára eare nʉrejaimad̶a Jesús yebai. Aru arejaimad̶a ʉ̃́re: —Mʉ, bueipõecʉ, d̶ajacʉ ñʉje ʉrõre, ñʉje jẽniarajiyede mʉre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús jẽniari jã́rejamed̶a náre: —¿Yéde d̶acaji mʉjare? arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aru arejaimad̶a ʉ̃́re: —Dobaicõjejacʉ ñʉjare mi yebai, cũinácʉ meapũravʉi aru apecʉ cãcopũravʉi, mi jabotequinʉmʉ maquinóre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ʉbenita Jesúcapũravʉ arejamed̶a náre: —Mʉje jẽniaiyede coreóvabevʉbu mʉja. Dobaiyʉrivʉ baru yʉ́que ji jabotequinʉmʉ maquinóre, mamarʉmʉ ñájiye jaʉvʉ mʉjare yʉ́que. ¿Ũcuri bʉojarãjidica mʉja ji ũcuinore? ¿Aru jã́d̶ovari bʉojarãjidica mʉja yópe ji jã́d̶ovainope Jʉ̃menijicʉque? arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na jʉ arejaimad̶a ʉ̃́re: —Bʉojaivʉbu ñʉja, arejaimad̶a. Aru Jesús arejamed̶a náre: —Ji ũcuinore ũcurajivʉbu mʉja. Que teni ji ñájiyepedeca ñájinajivʉbu mʉja. Aru ji Jʉ̃menijicʉque jã́d̶ovaiyepedeca jã́d̶ovarajivʉbu mʉja. Que teni ji d̶aiyepedeca d̶arãjivʉbu mʉja Jʉ̃menijicʉi ʉrõre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ʉbenita yʉ́vacari beobevʉ náre, dobarãjivʉre ji meapũravʉi aru ji cãcopũravʉi máre. Quénora dobarãjarama nore ina jipacʉi beoimara mácavʉ, javeta ʉ̃i mead̶aimara mácavʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","No yóboi, jápiarejaimad̶a ne borore apevʉ caipʉcapʉrʉape paivʉ Jesúi bueimara. Que baru jararejaimad̶a inare, Santiagore aru Jũare máre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Dinʉmʉ Jesús órejarejamed̶a ʉ̃i bueimarare ʉ̃i yebai. Aru arejamed̶a náre: —Mʉja majivʉ ina jaboteivʉre judíova ãmevʉre ne d̶aiyede. Parʉéque cõjeivʉbu ina ne jaborõcavʉre, ne d̶acarãjiyepe aivʉ náre ne ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ʉbenita nápe d̶abejarã mʉja. Ñai mʉjacacʉ parʉcʉ baiyʉcʉ baru, memecajacʉrĩ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aru nopedeca ñai mʉjacacʉ jabocʉ baiyʉcʉ baru, yebacatejacʉrĩ caivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nopedeca Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, yʉ, dabedejacacʉ, põeva ne memecarãjiyepe ayʉ yʉre. Quénora darejacacʉ yʉ, memecacʉyʉ apevʉre aru boarĩ́ jarʉvaicõjecʉyʉ ji bajure, mead̶acʉyʉ obedivʉ põevare, ji yaiquíyede náre boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericó ãmicʉriĩmaroi earejaimad̶a na Jesújã. Nore cʉrĩduivʉ bácavʉ nʉrejaimad̶a na cojedeca. Jesús ʉ̃i bueimaraque, obedivʉ põeva máre yóvarĩ nʉrejaimad̶a. Ne nʉimai, no ma ẽcarʉi, Bartimeo, Timeoi mácʉ, dobarejamed̶a. Jã́ri eabecʉ barejámed̶a. Que baru tãutʉrare jẽniavarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Aru põeva “Jesús Nazarecacʉbe ʉ̃”, aivʉre jápiayʉ, cod̶oboborejamed̶a Bartimeo: —Mʉ, Jesús, David bácʉi pãramecʉ, Jʉ̃menijicʉi daroimʉ mácʉ, ñʉje jabocʉ bacʉyʉ́, yʉre cõmaje ãroje jã́jacʉ mʉ, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","—Bi ajacʉ mʉ, arĩdurejaimad̶a Jesújãque nʉivʉ. Ʉbenita pʉeno baju cod̶oboborejamed̶a ʉ̃ cojedeca: —Mʉ, David bácʉi pãramecʉ, Jʉ̃menijicʉi daroimʉ mácʉ, ñʉje jabocʉ bacʉyʉ́, yʉre cõmaje ãroje jã́jacʉ mʉ, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Que teni ʉ̃́re cod̶oboboyʉre jápiayʉ Jesús, dajocarejamed̶a. Aru ʉ̃́que nʉivʉre cutuicõjenejamed̶a. —“Dajacʉrĩ”, aibi mʉre Jesús. Torojʉjacʉ mʉ, arejaimad̶a Bartimeore. ");
INSERT INTO cubNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aru cũiná nacajari, ʉ̃i pʉenocacajede quédata durĩ jarʉvarĩ, Jesús yebai earejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—¿Aipe d̶acaji yʉ mʉre? jẽniari jã́rejamed̶a ʉ̃́re Jesús. —Mʉ, bueipõecʉ, jã́ri eabevʉ yʉ. Ʉrarõ jã́iyʉvʉ yʉ, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Dinʉmʉ meavʉ. Ména nʉjacʉ. “Yʉre mead̶acʉyʉme Jesús”, arĩ dápiarebu mʉ. Que baru mi jã́ri eabede mead̶acaivʉ yʉ caride, arejamed̶a ʉ̃́re Jesús. Aru cũiná jã́rejamed̶a ʉ̃, jã́ri eabecʉ bácʉ. Que teni Jesúre yóvarĩ nʉrejamed̶a ʉ̃ máre, Bartimeo. ");
INSERT INTO cubNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén ãmicʉriĩmaro joabejĩnoi nʉri, Betfajé aru Betania ãmicʉriĩmajinoa baji, no cʉ̃racũ Olivocũ ãmicʉricũ ẽmeino baji, earejaimad̶a na, Jesús ʉ̃i bueimaraque. Nore earĩ ʉ̃i bueimaracavʉ pʉcarãre jarorejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Náre yópe arĩ: —No cõchinoi cʉriĩmajinoi nʉjara mʉja. Ma ẽmeinoi põevare ũmaiãimacʉre, burrore, earãjaramu mʉja, nócacʉ ʉ̃i bʉoimʉre. Põeva ne tubabemʉtame cãreja. Ʉbenita ʉ̃i bʉoimene jod̶eni, ʉ̃́re davacajarã yʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aru, “¿Aipe teni burrore ʉ̃i bʉoimene jod̶eni, ʉ̃́re nʉvaivʉrʉ̃ mʉja?” ne aruta, yópe ajarã: “Ñʉjare ĩ́cõjeni darobi maje jabocʉ. Ʉ̃́re ũmacayʉ ãimacʉ jaʉbi ʉ̃. Carijĩeneca mʉjare jacopaiyovacʉyʉme cojedeca”. Nópe ajarã, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Na jʉ arĩ ĩcarãnʉrejaimad̶a. Nʉri, burrore earejaimad̶a na. Cʉ̃rami jedevai, ma ẽcarʉi, bʉoimʉ núrejamed̶a ʉ̃, tubamʉ. Aru ʉ̃i bʉoimene jod̶enidurejaimad̶a na. Dinʉmʉma ina burro yebai núrivʉ arejaimad̶a: ");
INSERT INTO cubNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","—¿Aipe teni jod̶eivʉrʉ̃ mʉja ʉ̃i bʉoimene? arejaimad̶a tubamʉre ĩcaivʉre Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesús ʉ̃i aiye báquepedeca náre, nore núrivʉre coyʉrejaimad̶a tubamʉre ĩ́vʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Coyʉrĩ bʉojarĩ, nʉvaicõjenejaimad̶a náre nócavʉ. Nʉvari Jesúre burrore nʉvacarejaimad̶a ina pʉcarã. Ne doicajea, ne pʉenocacajeare tubamʉra tʉorĩ, Jesúi tubaquinore d̶arejaimad̶a ʉ̃i bueimara. Aru burrore tubarejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dinʉmʉma ne pʉenocacajeare jũarejaimad̶a ina obedivʉ põeva mára. Aru apevʉ jocʉcʉ cavabʉa yoca cʉricavabʉare burarĩ, jũarejaimad̶a mára, Jesúre mead̶aiyʉrivʉ ne pued̶arĩ jacoyʉrãjiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ʉ̃́re jipocateivʉ aru ʉ̃i yóbocavʉ máre cod̶oboborejaimad̶a na: —Jʉ̃menijicʉre torojʉe bajad̶éni. Jʉ̃menijicʉ mearo d̶acaimʉme ʉ̃, Jʉ̃menijicʉi daroimʉ mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Majeñecu mácʉ, David bácʉi jaboteino mácarõpedeca, cari jabotecʉyʉme. Ʉ̃i jabotequino meaquiyebu. Cari jabocʉ bacʉyʉ́re ména borotenajarevʉ. Jʉ̃menijicʉre torojʉe bajad̶éni, cod̶oboborĩ arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aru Jesús Jerusalén ãmicʉriĩmaroi earĩ, Jʉ̃menijicʉi cʉ̃rami nʉrejamed̶a. Nore earĩ, ecorejamed̶a Jesús. Nore cocorĩ jã́ridurejamed̶a Jesús. Ʉbenita nainúta marejávʉ̃ya. Que baru ʉ̃i bueimara doce paivʉque Betania ãmicʉriĩmajinoi nʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Cõmiáijãravʉ javejĩnara, Jesújã ne etaiyede Betania ãmicʉriĩmajinore jocarĩ, ãvʉé ijidejavʉ̃ya Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jã́rejamed̶a joai cũinácʉ jocʉcʉ higueracʉre yoca cʉricʉre. Que baru jẽidʉare vocʉnʉridurejamed̶a dicʉ yebai. Ʉbenita nore earĩ, yoca matʉiyeda jã́rejamed̶a. Jẽidʉa cʉbedejavʉ̃ya, jẽidʉa higo ãmicʉridʉa jẽijãravʉ eabe boje. ");
INSERT INTO cubNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aru arejamed̶a dicʉre: —Cainʉmʉa ãmejarari põeva mi jẽidʉare cojedeca, arejamed̶a Jesús. Aru nópe ʉ̃i aiyede jápiarejaimad̶a ina ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Bedióva Jerusalén ãmicʉriĩmaroi earejaimad̶a na Jesújã, Betania ãmicʉrõi nʉivʉ bácavʉ. Earĩ, Jʉ̃menijicʉi cʉ̃rami nʉri, diñami tãibʉi ecorejamed̶a Jesús. Nore diñami cʉrivʉ bojed̶aipõevare jarʉvarĩ jarorejamed̶a Jesús. Tãutʉra oatʉvaipõeva ne jã́d̶ovaivare moari najuárejamed̶a ʉ̃. Aru jurevare bojed̶aipõeva ne dobarõare máre moari najuárejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Diñami tãibʉi nʉvari jatajʉrorivʉre ye apejĩe paiyede nʉvaicõjemenejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Náre bueyʉ, yópe arejamed̶a ʉ̃: —Yópe arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃i yávaiyede: “Ji cʉ̃rami caivʉ põeva ne yʉre, Jʉ̃menijicʉre, coyʉiñamimu”, arĩ toivaicõjenejaquemavʉ. Ʉbenita diñamine tatorĩ ĩ́vʉ ne dupiñamipe d̶aquemavʉ mʉja, mʉje pʉeno ʉrarõ tãutʉra ĩ́ye boje põevare jocarĩ, ne bojed̶aiyede mʉje cʉvaede, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Sacerdotevare jaboteipõeva aru ina Jʉ̃menijicʉi yávaiye báquede bueipõeva diede, Jesús ʉ̃i d̶aiye báquede, jápiarĩ, ʉ̃́re boarĩ́ jarʉvaiyʉrĩdurejaimad̶a na. Ʉbenita ina põevacapũravʉ Jesús ʉ̃i bueiyede jápiarĩ, ʉrarõ dápiarejaimad̶a na. Que baru jidʉrĩ, ʉ̃́re ne boarĩ́ jarʉvarãjiyede borotedejaimad̶a ina sacerdotevare jaboteipõeva ina Jʉ̃menijicʉi yávaiye báquede bueipõevaque. ");
INSERT INTO cubNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aru nainíburu yóboi diĩmarore jocarĩ, nʉrejaimad̶a Jesújã. ");
INSERT INTO cubNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cõmiáijãravʉ javejĩnara vainánʉivʉ dicʉ higueracʉ yebai jã́rejaimad̶a. Aru caicʉ dicʉ aru caiye nʉo máre yaidéjavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dinʉmʉma Pedro, Jesús ʉ̃i yávaino mácarõre dicʉre ãrʉri, arejamed̶a ʉ̃́re: —¡Mʉ, bueipõecʉ, jã́jacʉ! Dicʉ, mi ẽnoare ãmecorovaricʉ, yaidébu, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aru Jesús arejamed̶a náre: —Jʉ ajarã mʉja Jʉ̃menijicʉre, ʉ̃i cad̶atequiyepe aivʉ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ icũ cʉ̃racũre ʉ̃i aru yópe: “Nʉjacũ yore jocarĩ pʉ jia ʉrad̶aita, cocʉnʉjacũ”, nópe d̶aquiyebu dicũ. Ácʉ põecʉ ʉ̃i me jʉ aru Jʉ̃menijicʉre aru “Jʉ̃menijicʉ iye d̶aiyede majibebi”, arĩ dápiabedu, caiye ʉ̃i cʉ̃racũre cõjeiyepe tequiyebu. ");
INSERT INTO cubNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Que baru coyʉyʉbu mʉjare: Caiye iye mʉje Jʉ̃menijicʉre jẽniaiyede, dápiajarã yópe: “Jãve Jʉ̃menijicʉ jícʉyʉme yʉre”, arĩ dápiajarã mʉja. Yópe dápiaru, Jʉ̃menijicʉ jícʉyʉme mʉjare mʉje ʉede. ");
INSERT INTO cubNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aru cainʉmʉa mʉje jẽniaiyede majepacʉque, jaraivʉ baru o chĩoivʉ baru apecʉ ʉ̃i ãmeina teiyede, ãrʉmetejarã diede. Cãrijimene d̶ajarã ʉ̃́que, majepacʉ cavarõ mearocacʉ ʉ̃i ãrʉmetequiyepe aivʉ mʉje ãmeina teiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ʉbenita apecʉ ʉ̃i ãmeina teiyede mʉjaque ãrʉru, majepacʉ cavarõ mearocacʉ ãrʉmetebecʉbe mʉje ãmeina teiyede máre, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Bedióva cojedeca earejaimad̶a Jerusalén ãmicʉriĩmaroi. Nore Jʉ̃menijicʉi cʉ̃rami tãibʉi cuyʉ barejámed̶a Jesús. Sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru judíova bʉcʉva máre nʉrejaimad̶a ʉ̃i yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jẽniari jã́rejaimad̶a ʉ̃́re: —¿Ye parʉéque d̶ayʉrʉ̃ mʉ iye mi d̶aiyede? ¿Ñame jídi mʉre iye parʉéde mi nópe d̶aiyede? arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús arejamed̶a náre: —Yʉ máre jẽniari jã́quijivʉ mʉjare cũináro jẽniari jã́inore. Coyʉjarã yʉre. Yʉre mʉje coyʉiyede, yʉ máre coyʉquijivʉ mʉjare ji parʉéque ji d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Juan Bautista bácʉ jã́d̶ovarejaquemari põevare Jʉ̃menijicʉ ʉ̃i parʉéque o põeva ne parʉéque? Coyʉjarã yʉre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ʉ̃i que aiyede, borotedejaimad̶a ne bajumia yópe: —Maje aru “Jʉ̃menijicʉque”, ʉ̃ aquijibi “¿Aipe teni jʉ abetecarãrʉ ʉ̃́re?” ");
INSERT INTO cubNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ʉbenita “põevaque” aiye jaʉbevʉ majare, ne bajumia arejaimad̶a. Caivʉ ina obedivʉ põeva coreóvarejaimad̶a Juan Bautista bácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bajure. Que baru ina jabova jidʉrejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Arejaimad̶a Jesúre: —Majibevʉ ñʉja, arejaimad̶a. Dinʉmʉre Jesús arejamed̶a náre: —Yʉ máre coyʉbevʉ mʉjare ñamei parʉéque ji d̶aiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Dinʉmʉre Jesús coyʉrĩ bʉ́rejamed̶a náre jã́ri dápiarĩ ne d̶arãjiyepe ainoque, yópe arĩ: —Cũinácʉ ʉ̃mʉ doaicõjequemavʉ jiore ʉ́yaimuque. Doarĩ bʉojarĩ, d̶aicõjequemavʉ biaidore jio tʉrʉvai. Aru ũicõjequemavʉ cobede ʉ́yai pipoicobede. Aru d̶aicõjequemavʉ ʉ̃mʉjʉriñami cʉ̃ramine, jiore coreipõecʉ ʉ̃i jã́quiñamine máre. Caiye iyede mead̶arĩ bʉojarĩ, vorĩ earĩ jiore memeipõevare, epequemavʉ náre ne memecarãjiyepe ayʉ ʉ̃́re. Ina memecaipõeva ĩnajivʉ batequémavʉ apeboa ʉ́yaiboare, ne memeiye boje. Aru nʉquemavʉ ñai ʉ̃mʉ apeno joborõi. ");
INSERT INTO cubNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ʉ́yai jẽijãravʉ yóboi, ñai ʉ̃mʉ jarorĩduquemavʉ cũinácʉ ʉ̃i yebacacʉre memecaipõeva yebai, ʉ̃i ĩquiyepe ayʉ apeboa ʉ́yaiboare, ñai jabocʉ jiede. ");
INSERT INTO cubNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ʉbenita ñai yebacacʉ ʉ̃i eaiyede nore, ina memecaipõeva ʉ̃́re jẽni, pare boarĩ́, copaide d̶aquemavʉ ʉ̃́re quédata. ");
INSERT INTO cubNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Cojedeca ñai ʉ̃mʉ, jio upacʉ, jarorĩduquemavʉ apecʉ ʉ̃i yebacacʉre memecaipõeva yebai. Ʉbenita churiá d̶aquemavʉ ʉ̃́re ʉ̃i jipobʉi. Aru cʉyojarõ d̶aquemavʉ ʉ̃́re máre. ");
INSERT INTO cubNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Cojedeca ñai ʉ̃mʉ, jio upacʉ, jarorĩduquemavʉ apecʉ ʉ̃i yebacacʉre nore, memecaipõeva yebai. Ʉbenita boarĩ́ jarʉvaquemavʉ ʉ̃́re. Apevʉre jio upacʉ ʉ̃i jaroimarare máre boaquémavʉ. Aru apevʉre boarĩ́ jarʉvaquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’No yóboi, mautequemavʉ ñai jio upacʉre cũinácʉ ʉ̃i mácʉ cũinácʉva, pare ʉ̃i ʉmʉ. Quénora jarorĩduquemavʉ mamacʉre. “Ʉ̃́re jã́ivʉ, pued̶arãjichʉma” ayʉ, que dápiaquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ʉbenita ina memecaipõeva jã́ivʉ ñai jio upacʉi mácʉre, aquemavʉ ne bajumia, “Ñai ñʉje jabocʉ bacʉyʉ́me. Jípacʉ ʉ̃i yainíburu yóboi, cʉvacʉyʉme caiye ʉ̃i cʉvaede. Jã́rica, boarĩ́ jarʉvarãjarevʉ ʉ̃́re, maja cʉvaburĩ caiye ʉ̃i cʉvaede”. ");
INSERT INTO cubNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Que arĩ, ʉ̃́re jẽni, boarĩ́ jarʉvaquemavʉ. Aru ʉ̃i baju bácarõre jaetovaquemavʉ jiore jocarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Na ʉ̃i coyʉiyede jápiaivʉre jẽniari jã́rejamed̶a Jesús: —¿Aipe d̶aquidi ñai jio upacʉ náre? Ʉ̃ boarĩ́ jarʉvacʉnʉcʉyʉme ina memecaipõevare. Aru epecʉyʉme apevʉ memecaipõevare noi, ʉ̃i jioi. ");
INSERT INTO cubNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Jã́ri borotebenarʉ mʉja iye Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báquede? Yópe toivarejaquemavʉ yʉrã, Cristo ji borore: Iva cʉ̃ravare cʉ̃ramine d̶aipõeva ʉbeni jarʉvaquemavʉ. Caride iva cʉ̃rava caiva apeva pʉeno parʉrivabu. ");
INSERT INTO cubNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nópe d̶aino mácarõre d̶aquemavʉ Jʉ̃menijicʉ. Que baru pare mearotamu majare, maje dápiaru, arĩ toivarejaquemavʉ, arejamed̶a Jesús. Yópe aiyʉrõtamu no: Põeva “Ãmecʉbe ʉ̃”, arĩdurãjarama Jesúi borore. Ʉbenita meacʉ bajube ʉ̃, Jesús, caivʉ apevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Que aiyede, Jesúre jẽni, nʉvaiyʉrĩdurejaimad̶a, ʉ̃i coyʉiye boje nára no jã́ri dápiarĩ ne d̶arãjiyepe ainore. Ʉbenita jidʉrejaimad̶a ina obedivʉ põevare. Que baru ʉ̃́re dajocarĩ etarĩ nʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Fariseova aru Herodecavʉ jarorejaimad̶a nácavʉre Jesús yebai, ʉ̃́re jʉjovarĩ, jacotʉjʉrorivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ʉ̃i yebai earĩ, ʉ̃́re yópe arejaimad̶a na, mamad̶aiyʉrivʉ: —Mʉ, bueipõecʉ, mʉre coreóvaivʉbu ñʉja. Nurié yávaivʉ mʉ. Caivʉre cũinácamuara yávaivʉ mʉ. Coyʉbevʉ mʉ põevare yópe ne d̶aiyepe. Quénora jidʉbecʉva coyʉivʉ mʉ náre yópe ne dápiaiyepe. Jãveneca bueivʉ mʉ põevare, ne d̶arãjiyepe ayʉ mearore yópe Jʉ̃menijicʉi d̶aicõjeiyepe. ¿Maje jabocʉ César ʉ̃i ĩ́cõjejʉroede, ʉ̃i jaboteiye boje, maje bojed̶aru, mearica die? ¿O bojed̶abejeba maja? ¿Bojed̶aje bárica maja? ¿O bojed̶aicõjeino ãmeni? arejaimad̶a Jesúre ina fariseova aru ina Herodecavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ʉbenita ne jʉjovajʉroede majicʉ, náre yópe arejamed̶a Jesús: —¿Aipe teni yʉre jʉjovaiyʉrĩdurĩ vainí tʉiyʉrãrʉ mʉja? Yʉre tãutʉratʉrava, ji jã́quitʉravare, davajacʉrĩ mʉjacacʉ, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ʉ̃́re tãutʉratʉravare nʉvarejamed̶a nácacʉ. Ʉ̃́re nʉvari jíyede, arejamed̶a Jesús: —¿Ñamema ñai, ditʉravare jẽñʉ? ¿Aru ñamei ãmiá cʉritʉravaba ditʉrava? arejamed̶a náre Jesús. Ʉ̃́re arejaimad̶a: —Ñai jabocʉ Césai decocʉ aru ʉ̃i ãmiá máre cʉritʉravatamu, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Que aivʉre arejamed̶a Jesús: —César jiede ʉ̃́re jacopaiyovajarã mʉja. Jíjarã ʉ̃́re tãutʉra yópe ʉ̃i bojed̶aicõjeiyepe mʉjare. Aru Jʉ̃menijicʉ jiede ʉ̃́re jacopaiyovajarã mʉja. D̶ajarã yópe ʉ̃i ʉrõpe, arejamed̶a náre, jẽniari jã́radaivʉre, Jesús. Aru jʉjovaiyʉrĩduivʉ bácavʉ Jesúre ʉ̃i que aiyede, ʉrarõ dápiarejaimad̶a ina fariseova aru ina Herodecavʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Apevʉ saduceova nʉrejaimad̶a Jesús yebai. Saduceo ãmicʉriyajubobu judíovacavʉ ne yajubo cũináyajubo. Caivʉ saduceova “Yainore jarʉvarĩ nacajaiye cʉbevʉ”, ad̶ama na. Jesúre jẽniari jã́rejaimad̶a ina saduceova yópe: ");
INSERT INTO cubNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Mʉ, bueipõecʉ, Jʉ̃menijicʉi d̶aicõjeiyede Moisés bácʉ toivarejaquemavʉ yópe: Cũinácʉ némamicʉ yaidú, jímarepacore jocarĩ jʉed̶ocʉvabecova, yaiyʉ́ bácʉi yócʉre pʉrʉbʉoiye jaʉvʉ ṍque, jʉed̶ocʉvacʉyʉ. Aru ina jʉed̶ova bárãjivʉ yaiyʉ́ bácʉi ãmiáre cʉvarãjarama na. Que arĩ, toivarejaquemavʉ Moisés bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","’Javede cʉ́tequemavʉ siete paivʉ ʉ̃mʉva. Cũinácʉ ʉ̃mʉi mára matequémavʉ na. Némamicʉ pʉrʉbʉoquemavʉ. No yóboi, yaiquémavʉ ʉ̃ mácʉ, jʉed̶ocʉvabecʉva. ");
INSERT INTO cubNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Que baru apecʉ, ʉ̃ mácʉrã cutuyʉ, pʉrʉbʉoquemavʉ jíbʉcʉ bácʉi márepacoque. Aru jíbʉcʉ bácʉpedeca, yaiquémavʉ ʉ̃ mácʉ máre, jʉed̶ocʉvabecʉva. Aru apecʉ, ʉ̃ mácʉrã cutuyʉ máre, nopedeca, aru caivʉ ina siete paivʉ bácavʉ ṍque pʉrʉbʉorĩ, yaiquémavʉ, jʉed̶ocʉvabevʉva. Caivʉ ne yóboi, ico nomió máco máre yaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Yainore jarʉvarĩ nacajaijãravʉ baquinóre, ñamei márepaco bacod̶óba ico? Ijãravʉi caivʉ ina siete paivʉ cʉvatequemavʉ ṍre, arejaimad̶a na Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aru Jesús arejamed̶a ina saduceovare: —Mamateivʉbu mʉja mʉje majibe boje Jʉ̃menijicʉi yávaiyede. Aru Jʉ̃menijicʉi parʉéde máre majibevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yainore jarʉvarĩ nacajaijãravʉ baquinóre pʉrʉbʉobenajarama. Aru jíbenajarama némaromivare, ne pʉrʉbʉorãjiyepe aivʉ. Quénora ángeleva, ina pʉrʉbʉobevʉ, cavarõ mearo Jʉ̃menijicʉi cʉrõcavʉpe paivʉ barãjárama ina yainore jarʉvarĩ nacajarajivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Iye yainore jarʉvarĩ nacajaiyede, jápiarĩ eabenarʉ mʉja iye Jʉ̃menijicʉi coyʉiye báquede Moisés bácʉ ʉ̃i toivaiye báquede, jocʉjĩcʉ uruijĩcʉre coyʉrĩ? “Yʉ́tamu Jʉ̃menijicʉ. Abraham, Isaac, aru Jacob ne mearore jímʉmu yʉ”, arejaquemavʉ Jʉ̃menijicʉ Moisés bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Que arĩ, yaivʉ bácavʉ ne mearore jímʉ ãmemi Jʉ̃menijicʉ. Quénora apʉrivʉ ne mearore jímʉtame ʉ̃. Que baru ina majeñecuva apʉrivʉbu. Que baru pare mamateivʉbu mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cũinácʉ Jʉ̃menijicʉi yávaiye báquede bueipõecʉ Jesús yebai earĩ, jápiarejamed̶a Jesús apevʉque ne copʉ boroteiyede. Jesús náre ʉ̃i copʉ aiyede cojʉrejavʉ̃ya ʉ̃́re. Dinʉmʉma Jesúre yópe jẽniari jã́rejamed̶a Jʉ̃menijicʉi yávaiye báquede bueipõecʉ: —¿Ã́roma majare Jʉ̃menijicʉi d̶aicõjeino mácarõ pʉeno parʉrõ cõjeino? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aru Jesús jʉ arejamed̶a ʉ̃́re: —Pʉeno parʉrõ d̶aicõjeinotamu yo: “Jápiajarã mʉja, Israecavʉ. Maje jabocʉ Jʉ̃menijicʉ cũinácʉratame. ");
INSERT INTO cubNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ʉjacʉ mi jabocʉ Jʉ̃menijicʉre caino mi ũmedʉque, caino mi ũmeque, caino mi majiéque, aru caino mi baju parʉéque máre”. ");
INSERT INTO cubNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aru no yóbo cãchijino parʉrõ d̶aicõjeino yópe ainomu: “Mi bajure mi jecʉépedeca jecʉjacʉ mícʉre máre”. Iye d̶aicõjeiyebu pʉeno parʉé. Apeno d̶aicõjeino pʉeno parʉrõ cʉbevʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Arejamed̶a Jesúre: —Mʉ, bueipõecʉ, jãvetamu. Mʉ jãve arĩ coyʉivʉ mʉ. Jʉ̃menijicʉ cũinácʉrabe ʉ̃. Apecʉ cʉbebi. ");
INSERT INTO cubNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Maje ãimacʉ caicʉre toaque juarĩ, Jʉ̃menijicʉre jíye o maje ape paiyede Jʉ̃menijicʉre jíye meavʉ. Ʉbenita Jʉ̃menijicʉre caiye maje ũmedʉque, caiye maje majiéque, aru caiye maje parʉéque máre jecʉé aru majecʉre maje bajure jecʉrõpe máre jecʉé, pʉeno mearotamu, arejamed̶a Jesúre ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús ʉ̃i jápiaiyede mearo ʉ̃i jʉ aiyede, yópe arejamed̶a: —Quĩ́jino baju jaʉrĩdurebu mi eaquino Jʉ̃menijicʉi jaboteinore, arejamed̶a Jesús. Que arĩburu jidʉrĩ, Jesúre ye jẽniari jã́menejaimad̶a na caivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús buede curejamed̶a Jʉ̃menijicʉi cʉ̃rami. Aru arejamed̶a: —¿Aipe teni “Cristobe David bácʉi pãramecʉ”, aivʉba Jʉ̃menijicʉi yávaiye báquede bueipõeva? ");
INSERT INTO cubNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David bácʉvacari Espíritu Santoi parʉéque coyʉicõjeimʉ arejaquemavʉ ʉ̃ mácʉ: Jʉ̃menijicʉ aquemavʉ ji jabocʉre, “Dobajacʉ ji meapũravʉi, mi cʉvae boje parʉéde yʉpedeca. Aru yʉ epecʉyʉmu mi mauvare mi cʉboba cãchinoi. Que teni mʉre vainí jarʉvare d̶acʉyʉmu yʉ náre, mi jabotequiyepe ayʉ náre”, arejaquemavʉ David bácʉ Cristorã. ");
INSERT INTO cubNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","’David bácʉvacari Cristoi borore “Ʉ̃́recabe ji jabocʉ”, arejaquemavʉ. Que baru, ¿aipe teni David bácʉi pãramecʉba ʉ̃? arejamed̶a Jesús. Aru caivʉ ina obedivʉ põeva torojʉrĩ jápiarejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús bueyʉ bácʉ arejamed̶a: —Me d̶ajarã ina Jʉ̃menijicʉi yávaiye báquede bueipõevare. Námu cuiyʉrivʉ cuitótecajea ʉ̃mʉjʉricajeaque. Aru ʉma na põeva pued̶arĩ ne jacoyʉinore náre tãibʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Judíovai cójijiñamiare ne dobae méne ʉma na, põeva ne jã́rajiyepe aivʉ náre. Aru torojʉve teinore, cʉiyʉma na ñai torojʉve teino upacʉ yebai. ");
INSERT INTO cubNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ʉbenita jʉjovarĩ ñavad̶ama ina nomiópevare ne apejĩene. Aru jẽniad̶ama joe ʉrarõ Jʉ̃menijicʉque, põeva ne dápiarãjiyepe aivʉ Jʉ̃menijicʉi yávaiye báquede bueipõeva me Jʉ̃menijicʉre jʉ aivʉpe. Caiye iyede ne d̶aiye boje, pʉeno ʉrarõ ñájinajarama na, ne ãmeina teiye boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nore, Jʉ̃menijicʉi cʉ̃rami, Jesús dobarejamed̶a joabejĩnoi cũinátõcu põeva ne Jʉ̃menijicʉre tãutʉra jíye epeitõcu yebai. Ditõcu cʉrejavʉ̃ya ʉ̃i jipocai. Noi dobarĩ, põeva obedivʉ ne ʉre tãutʉrare ditõcui jíni tʉoivʉre jã́ñʉ marejámed̶a Jesús. Aru obedivʉ cʉve cʉvarivʉ tʉorejaimad̶a ʉre tãutʉrare. ");
INSERT INTO cubNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Que teiyede cũináco nomiópeco, cʉve cʉvabeco, ditõcu yebai earĩ, tʉorejacod̶a pʉcatʉrava tãutʉratʉravare, me bojecʉbetʉravare. ");
INSERT INTO cubNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Õi que d̶aiyede jã́ñʉ Jesús, órejarejamed̶a ʉ̃i bueimarare ʉ̃i yebai. Aru arejamed̶a náre: —Jãve coyʉyʉbu mʉjare: Ico nomiópeco cʉve cʉvabeco, Jʉ̃menijicʉre jíbico apevʉ ne jíye pʉeno baju, õi jíye boje õi cʉvarõ cainore. Ʉbenita nácapũravʉ quénora quĩ́jino ne cʉvarõcarõre jíyama. ");
INSERT INTO cubNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Caivʉ ina põeva ne ʉrarõ cʉvaecarõre jíyama Jʉ̃menijicʉre náre jaʉbede. Ʉbenita ico nomió õi quĩ́jino cʉvarijĩno mácarõre cainore jíbico Jʉ̃menijicʉre. Caiye õi ijãravʉi cʉvajʉroede jíbico õ Jʉ̃menijicʉre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","No yóboi Jesús etayʉ bácʉre Jʉ̃menijicʉi cʉ̃ramine jocarĩ, cũinácʉ ʉ̃i bueimaracacʉ arejamed̶a ʉ̃́re: —Mʉ, bueipõecʉ, jã́jacʉ. ¡Pare meavabu iva cʉ̃rava! ¡Aru pare mead̶amiamu iñamia cʉ̃ramia! arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ʉ̃i que aiyede, Jesús arejamed̶a ʉ̃́re: —¿Jã́ñʉrʉ mʉ iñamia ʉrad̶ãmia cʉ̃ramiare? Cũináva cʉ̃rava mautebequiyebu apeva pʉenora. Caiye iva cʉ̃ravare najuárajarama. Que teni cũiquíyebu, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús dobarejamed̶a cʉ̃racũ Olivocũ ãmicʉricũ pʉenoi, Jʉ̃menijicʉi cʉ̃rami ʉ̃i jipocai jã́ñʉ mácʉ. Ʉ̃i dobaede noi Pedro, Santiago, Juan, aru Andrés máre jẽniari jã́rejaimad̶a ʉ̃́re yavenina, põevare jocarĩ: ");
INSERT INTO cubNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Coyʉjacʉ ñʉjare: ¿Aipiyede tʉquidi caiye iye cʉ̃ramia ʉrad̶ãmia? ¿Aipe d̶arĩ coreóvarãjidica ñʉja caiye iye bʉojaquiyede? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aru Jesús arĩ bʉ́rejamed̶a náre: —Me jã́jara apecʉ jʉjovaiyʉcʉre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Darãjarama obedivʉ ʉ̃mʉva. Aru arãjarama “Cristobu yʉ”. Jʉjovarãjarama obedivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Mʉje jápiaiyede boaino borore aru boaquíno borore máre, jidʉbejarã. Caiye iye vaiquíyebu jãravʉ cũiquíye jipocai. Ʉbenita cũimébu cãreja. ");
INSERT INTO cubNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Cũináyajubo põeyajubocavʉ ãd̶amatenajarama apeyajubo põeyajubocavʉque. Aru cũináro jaboteinocavʉ ãd̶amatenajarama apeno jaboteinocavʉque. Joborõ cújiquiyebu obedicʉrõare. Ñájinajarama ãvʉéna. Iye ñájiye baquiyébu yópe jʉed̶ocʉ põeteyʉre ñájiyepe. Yópe bʉ́quiyebu caiye iye ãmeina ñájinajiye. ");
INSERT INTO cubNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Ʉbenita mʉjacapũravʉ me jã́ri me d̶ajarã. Mʉjare jẽni jínajarama ne jabovare. Mʉjare jara popenajarama judíovai cójijiñamiai. Aru mʉja núrajaramu cõjeipõeva ne jipocai aru jabova ne jipocai máre, yʉre mʉje jʉ aiye boje, coyʉrãjivʉ ji borore. ");
INSERT INTO cubNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mamarʉmʉre yávaiye méne Jʉ̃menijicʉi jaboteinora coyʉiye jaʉvʉ, cainoa joborõacavʉ ne jápiarãjiyepe aivʉ diede. ");
INSERT INTO cubNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne jẽni nʉvaiyede mʉjare jabova ne ãmeina teivʉre jẽniari jã́iñami, “¿Aipe arĩ coyʉrãjidi náre?” arĩ, cãrijimejara mʉja. Ʉbenita coyʉjarã mʉja yópe ñai Espíritu Santo ʉ̃i dápiare d̶aquiyepe dinʉmʉ maquinóre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Que teni ʉ̃mʉ jẽni jícʉyʉme jíbʉcʉre o ĩmacʉre máre, jabova ne boarĩ́ jarʉvarãjiyepe ayʉ ʉ̃́re. Nopedeca jípacʉ jẽni jícʉyʉme mamacʉre. Aru nopedeca némara nébʉcʉvare jʉ abeni jẽni jínajarama, boarĩ́ jarʉvaicõjenajivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Caivʉ mʉjare mʉje yʉre jʉ aiye boje jorojĩni jã́rajarama. Ʉbenita ñai jʉ ayʉ yʉre pʉ ʉ̃i yainʉmʉita, ʉ̃ macʉyʉ́me ji mead̶aimʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aru Jesús buedejamed̶a náre, ʉ̃i bueimarare, cojedeca: —Ñai ʉ̃mʉ pare ãmecʉ núcʉyʉme nore, Jʉ̃menijicʉi cʉicõjemenore ʉ̃́re. Caivʉ iye toivaiyede jã́ri boroteivʉ me dápiajarãri caiye iyede. Ñai ʉ̃mʉre jã́rajaramu mʉja. Judeacavʉ dupini nʉjarari cʉ̃racũai. ");
INSERT INTO cubNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ñai cʉ̃rami pʉenora cʉcʉyʉ, ʉ̃i dupini nʉiyede, ẽmeni darĩ, nʉvariducʉyʉ ʉ̃i apejĩene, ecobejacʉrĩ ʉ̃i cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aru ñai jiore memecʉyʉ, ʉ̃i dupini nʉiyede, copainʉmejacʉrĩ ĩniducʉyʉ ʉ̃i cuitótecaje pʉenocacajede. ");
INSERT INTO cubNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Cõmaje ãrojarajarama ina nomiva micava bárãjivʉ dijãravʉa baquiyéde! ¡Aru ina nomiva némajina nuri dajocabevʉre cʉvarãjivʉ máre pare ñájinajarama dijãravʉa baquiyéde! ");
INSERT INTO cubNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Jẽniajara Jʉ̃menijicʉque iye vaibéquiyepe aivʉ ocorʉ̃mʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Dijãravʉa baquiyéde põeva ʉrarõ ñájinajarama. Nópe paiye cʉbevʉ cãreja, mamarʉmʉmata Jʉ̃menijicʉ ʉ̃i cʉed̶arĩ bʉinʉmʉre, pʉ caride máre. Aru cainʉmʉa cʉbequiyebu. ");
INSERT INTO cubNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jʉ̃menijicʉ ʉ̃i javaiyobedu dijãravʉa ñájiovaquijãravʉa baquiyéde, caivʉ yaijébu. Mead̶aimara cʉbejebu. Ʉbenita Jʉ̃menijicʉ javaiyocʉyʉme dijãravʉa ñájiovaquijãravʉa baquiyéde, ʉ̃i beoimara mácavʉre boje. ");
INSERT INTO cubNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Dijãravʉa baquiyéde apecʉ ʉ̃i aru mʉjare yópe, “Jã́jara. ¡Ñainecabe Cristo!” o apecʉ ʉ̃i aru mʉjare, “¡Ãñʉrecabe Cristo!” náre jʉ abejarã. ");
INSERT INTO cubNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Que teni obedivʉ borocʉrivʉ darĩ coyʉrãjarama “Cristobu yʉ”. Aru apevʉ máre Jʉ̃menijicʉi yávaiyede coyʉcarĩdurãjarama. Ʉbenita Jʉ̃menijicʉi yávaiyede coyʉcaipõeva baju ãmenajarama na. Ʉrarõ jã́d̶ovaiye aru põeva ne d̶arĩ majibede máre d̶arãjarama, jʉjovarĩduivʉ Jʉ̃menijicʉi beoimara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ʉbenita me jã́jara mʉja. Coyʉyʉbu mʉjare ne borore, mʉje majinajiyepe ayʉ, ne darãjiye jipocai, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Bedióva cojedeca Jesús coyʉrejamed̶a náre: —Cũinájãravʉ dijãravʉacajãravʉ baquinói, iye ʉrarõ ñájiniburu yóboi, aviá ñemitecʉyʉme. Aru aviá ñamicacʉ máre pẽomecʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Na abiácova tʉrãjarama cavarõre jocarĩ. Aru caivʉ ina parʉéque cʉrivʉ cavarõi cújinajarama. ");
INSERT INTO cubNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Dinʉmʉ maquinóre jã́rajarama yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, dayʉre ocopeniboai, ʉrarõ parʉéque, jã́d̶ovañʉre meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Que teni ina ángelevare darocʉyʉmu yʉ. Nácapũravʉ cójijovarãjarama Jʉ̃menijicʉi beoimara mácavʉre, caivʉ aviá dainocavʉre aru caivʉ aviá doinocavʉre máre, cainoa joborõacavʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Majijarã yo mʉje jã́inore. Icʉ jocʉcʉ higueracʉre yoca yuiyede, majivʉ mʉja ʉjʉrʉ̃mʉ joabenore. ");
INSERT INTO cubNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nopedeca jã́ivʉ caiye iye teiyede, majinajaramu mʉja jãravʉ cũino joabenore. ");
INSERT INTO cubNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jãve coyʉyʉbu mʉjare: Apevʉ ijãravʉi cʉrivʉ yaibédeca cãreja, vaiquíyebu caiye iye yópe ji coyʉiyepe. ");
INSERT INTO cubNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Caino cavarõ, aru caino joborõ máre cũiquíyebu. Yópe ji yávaiyepedeca jãve vaiquíyebu. ");
INSERT INTO cubNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ʉbenita dijãravʉ baquinóre aru diora baquinóre ñame majibema. Ángeleva, ina cʉrivʉ Jʉ̃menijicʉque cavarõ mearoi, aru yʉ, Jʉ̃menijicʉi mácʉ máre majibevʉ ñʉja. Quénora jipacʉ majibi dijãravʉ baquinóre, ji aijãravʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Que baru me jã́jara mʉja. Ãrʉjara. Mʉja majibevʉ ji copaidaquijãravʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jẽvari coyʉquijivʉ ji copaidaquinore yópe cũinácʉ ʉ̃mʉ ʉ̃i cucʉnʉquiyepe apejoborõi. Ʉ̃i etaquiye jipocai ʉ̃i cʉ̃ramine, memeicõjeimi ʉ̃i yebacavʉre náre coapa. Aru jedevacobede coreipõecʉre máre coreicõjeimi cãmecʉva. ");
INSERT INTO cubNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Quédeca memeni corejarã mʉja, cãmevʉva. Mʉja majibevʉ cʉ̃rami upacʉ ʉ̃i copaidaquinore. Daquijichʉbi nainúre, o ñami coricai, o cáyu ʉ̃i órejaiyede, o javejĩnare. ");
INSERT INTO cubNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ʉ̃i copaidaru maumejiena aru mʉjare cãivʉre earu, meamejebu mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nopedeca ji coyʉinore mʉjare, coyʉyʉbu quédeca caivʉre: Cãmevʉva memeni corejarãri, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pascua ãmicʉrijãravʉ aru pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teinʉmʉ pʉcajãravʉa jipocai barejávʉ̃ya cãreja. Yavenina Jesúre jʉjovarĩ jẽni, boarĩ́ jarʉvaiyʉrejaimad̶a sacerdotevare jaboteipõeva aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre. ");
INSERT INTO cubNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne bajumia arejaimad̶a: —Torojʉve teinʉmʉ ʉ̃́re jẽmenajarevʉ maja. Ʉ̃́re jẽnu torojʉve teinʉmʉ, põevacapũravʉ majare jorojĩni, majare boarĩ́ jarʉvaiyʉjebu, arejaimad̶a ina judíovai jabova. ");
INSERT INTO cubNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús ʉ̃i cʉede Betania ãmicʉriĩmajinoi, Simón pojeyʉ bácʉi cʉ̃rami tʉoiva yebai ãivʉ barejáimad̶a na, Jesújã. Que teni cũináco nomió earejacod̶a Jesús yebai. Ico nomió nʉvarejacod̶a cũinábʉ ʉ̃mʉjʉribʉ boribʉ mumijʉricoroque. Iye mumijʉe nardo ãmicʉe pare mearo corajʉrejavʉ̃ya. Aru pare bojecʉe barejávʉ̃ya. Ico nomió earĩ, dibʉre cobarĩ yuarejacod̶a caiye iye mumijʉede Jesúi jipobʉrã. ");
INSERT INTO cubNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ʉbenita nore cʉrivʉ apevʉ, jorojĩni, ne bajumia arejaimad̶a: ");
INSERT INTO cubNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","—¿Aipe teni iye mumijʉede jarʉvad̶oba õ? Diede bojed̶arĩ, ʉrarõ boje ĩni, cũinácʉ memeipõecʉ cũináʉjʉ ʉ̃i memeino bojede ĩni, jíye jaʉjebu ṍre cʉve cʉvabevʉre, arejaimad̶a na. Que baru jararejaimad̶a ṍre. ");
INSERT INTO cubNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ʉbenita Jesús arejamed̶a: —Yávabejarã ãmeno ṍre. ¿Aipe teni cãrijovaivʉrʉ̃ ṍre? Õi d̶aiye yʉre mearotamu. ");
INSERT INTO cubNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Cainʉmʉa ina cʉve cʉvabevʉ cʉrãjarama mʉjaque. Que baru mʉja cad̶ateiyʉrivʉ cainʉmʉa náre bʉojaivʉ. Ʉbenita yʉ cʉbecʉbu mʉjaque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Õ d̶acaibico yʉre õi oainope. Õ mead̶acaibico ji bajure, ne yʉre jarʉvarãjiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Que baru jãve coyʉyʉbu mʉjare: Cainoa joborõai ijãravʉi põeva ne coyʉiyede iye yávaiye méne ji mead̶aiyede põevare, iye õi yʉre d̶acaiyede máre coyʉrãjarama, ne ãrʉrajiyepe aivʉ ṍre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","No yóboi Judas Iscariote, cũinácʉ doce paivʉ Jesúi bueimaracacʉ, nʉrejamed̶a ina sacerdotevare jaboteipõeva yebai, náre jẽni jíyʉrejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ʉ̃i d̶aiyʉede jápiarĩ, torojʉrejaimad̶a na. Que baru arejaimad̶a ʉ̃́re: —Ñʉja jínajivʉbu mʉre tãutʉrare, mi yavenina jẽni jíye boje ʉ̃́re, arejaimad̶a na Judare. Que baru Judas jã́ri coreni bʉ́rejamed̶a yavenina, jẽni jícʉyʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teinʉmʉ mamabʉijãravʉ barejávʉ̃ya. Pascua jãravʉcacʉre, ovejajĩcʉre, boarĩ́, toaque juarĩ, ã́varejaimad̶a dijãravʉre. Aru dijãravʉre arejaimad̶a Jesúre ʉ̃i bueimara: —¿Ã́ri nʉri mʉre maje Pascua jãravʉque ãiyede mead̶acarãjidica ñʉja? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aru nácavʉ pʉcarã jarorĩ, arejamed̶a Jesús: —Ĩmaroi nʉri, ẽmeni, nócacʉre oco tuyʉre copʉrãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ʉ̃́que nʉri, cʉ̃ramine ʉ̃i ecoiyede cũinátʉrʉ mʉja máre ecojarã. Diñami upacʉre yópe ajarã mʉja: “ ‘¿Átucubʉba ji bueimaraque ji Pascua jãravʉre ji ãquitucubʉ?’ aibi bueipõecʉ”, ajarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Diñami upacʉcapũravʉ pʉenocatucubʉ jave majare jaʉéde mead̶aitucubʉ bácarõre mʉjare jã́d̶ovacʉyʉme ʉ̃. Noi ditucubʉi majare maje ãrajiyede mead̶ajarã mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ʉ̃́re jʉ arĩ, nʉri, ĩmaroi earejaimad̶a. Earĩ, nore Jesús ʉ̃i aiye báquepedeca ʉ̃i aitucubʉre earejaimad̶a na. Noi Pascua jãravʉque ãiyede mead̶arejaimad̶a na pʉcarã. ");
INSERT INTO cubNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Que teni mead̶arĩ bʉojarĩ, nainú baji, aviá ʉ̃i dorĩburu yóboi, ʉ̃i bueimara ina doce paivʉque no ditucubʉre earejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nore earĩ, dobarĩ ãivʉre, Jesús arejamed̶a ʉ̃i bueimarare: —Jãve coyʉyʉbu mʉjare: Cũinácʉ mʉjacacʉ yʉre ji mauvare jẽni jícʉyʉme ʉ̃. Ñai yʉre nópe d̶acʉyʉ, yʉ́que caride ãñʉme ʉ̃, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Que baru chĩorejaimad̶a. Aru na coapa yópe arejaimad̶a Jesúre: —¡Que d̶abecʉbu yʉ! ¿Mʉ́carĩ? arejaimad̶a na coapa. ");
INSERT INTO cubNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Que arĩ, Jesús arejamed̶a náre: —Cũinácʉ mʉjacacʉ, jóyʉ pã́ure jororʉmica yʉ́que, ʉ̃ macʉyʉ́me ji mauvare yʉre jẽni jíyʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ijãravʉi, ji yaijãravʉi nʉcʉyʉmu yʉ, yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃i yávaiyede. Ʉbenita ãmeno vaicʉ́yʉme ʉ̃, ñai yʉre jẽni jíyʉ bacʉyʉ́. Ñai nópe d̶acʉyʉ, ʉ̃i põetebedu meajebu, arejamed̶a ʉ̃i bueimarare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ne ãiyedeca, pã́ure ĩni, Jʉ̃menijicʉre torojʉede jídejamed̶a Jesús. Torojʉede jíni bʉojarĩ, pã́ure cotʉvarejamed̶a. Cotʉvarĩ bʉojarĩ, náre coapa jídejamed̶a. Aru arejamed̶a: —Pã́ure ãjara mʉja. Diedecabu ji bajupe, jã́d̶ovaiye ji yaiquínore mʉjare boje, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ũcuidore máre ĩni, torojʉede jíni Jʉ̃menijicʉre, náre jídejamed̶a Jesús. Didore jẽni, ũcuri, veorĩ, ũcurejaimad̶a na coapa. ");
INSERT INTO cubNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Aru Jesús arejamed̶a náre: —Dicorore ũcujara mʉja. Diedecabu ji jivepe, jã́d̶ovaiye ji yaiquínore mʉjare boje, Jʉ̃menijicʉi ãrʉmetequiyepe ayʉ mʉje ãmeina teiyede. Jʉ̃menijicʉ “Yópe d̶ajarã mʉja, boropatebenajivʉ ji jã́inoi”, ʉ̃i yóbocarõ coyʉino mácarõre põevare ãrʉrajaramu mʉja, mʉje ũcuiyede diede. ");
INSERT INTO cubNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jãve coyʉyʉbu mʉjare: Quénora vino ʉ́yaicorore ũcuñʉmu yʉ ijãravʉre. Ʉbenita ãnijãravʉ baquinói, Jʉ̃menijicʉi jabotequinʉmʉ maquinóre, bedióva cojedeca ũcuri jã́cʉyʉmu yʉ, arejamed̶a ʉ̃i bueimarare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ne ãriburu yóboi, Salmos ãmicʉe yʉriaiyede yʉriarejaimad̶a. Yʉriarĩ bʉojarĩ, no cʉ̃racũ Olivocũ ãmicʉricũi nʉrejaimad̶a na, Jesújã. ");
INSERT INTO cubNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mái nʉri, arejamed̶a Jesús: —Yʉre dajocarĩ nʉrajaramu mʉja. Yʉre vaiquíyede Jʉ̃menijicʉ toivaicõjenejaquemavʉ, yópe arĩ: “Ovejavare coreipõecʉre boarĩ́ jarʉvacʉyʉmu yʉ. Aru coateni nʉrajarama na, ovejava”, arĩ toivarejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ʉbenita ji yainíburu yóboi, Jʉ̃menijicʉ ʉ̃i nacovaiyede yʉre yainore jarʉvarĩ, mʉje jipocai nʉcʉyʉmu Galileai, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Que ayʉre, Pedrocapũravʉ arĩdurejamed̶a ʉ̃́re: —Caivʉ apevʉ ne dajocarĩ jocarĩ nʉiyedeca, yʉ́capũravʉ mʉre jocarĩ nʉmecʉbu yʉ, arĩdurejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aru Jesús arejamed̶a ʉ̃́re: —Jãve coyʉyʉbu mʉre: Cari ñami pʉque cáyu ʉ̃i órejaquiye jipocai, yóbecʉe baju “Jesúre yʉ coreóvabevʉ” acʉyʉmu mʉ, arejamed̶a Pedrore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ʉbenita Pedrocapũravʉ copʉ ayʉ barĩdurejamed̶a: —Mʉ́que yʉre ne boarĩ́ jarʉvaruta, “Jesúre yʉ coreóvabevʉ”, abecʉbu yʉ, arĩdurejamed̶a Pedro. Aru na coapa nópe arĩdurejaimad̶a, Jesúi bueimara. ");
INSERT INTO cubNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Getsemaní ãmicʉrõi nʉrejaimad̶a Jesújã. Nore earĩ, arejamed̶a ʉ̃i bueimarare Jesús: —Yui dobarĩ corejarã mʉja ji Jʉ̃menijicʉque boroteiyede ãnoi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nʉvarejamed̶a ʉ̃́que Pedrore, Santiagore, aru Jũare máre. Aru ʉrarõ ñájiñʉ ʉ̃i dápiaino, ãmeno vaidéjamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Que teni arĩdurejamed̶a náre: —Yʉ ãmeno chĩori dápiaivʉ ji yaiquínore. Yui mauteni, jã́ri capʉjarã mʉja, arĩdurejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jipojĩca báque nʉñʉ Jesús, ñʉatutarĩ, mori tʉrejamed̶a joborõita. Aru Jʉ̃menijicʉque boroteyʉ barejámed̶a ʉ̃: —Mʉ, jipacʉ, yʉre cari vaiquíye vaibéjad̶eni. Caiyede d̶aiye majicʉtamu mʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ʉbenita ji ʉrõpe d̶abejacʉ. Quénora mi ʉrõpe d̶ajacʉ mʉ, arejamed̶a jípacʉre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ʉ̃i bueimara yebai copainʉri, náre cãivʉre earejamed̶a Jesús. Aru arejamed̶a Pedrore: —Simón, ¿cãñʉtarʉ̃ mʉ? ¿Cũináorajĩe cãmecʉva coreiye majibecʉrʉ̃ mʉ? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Caivʉ ʉ̃i bueimarare arĩdurejamed̶a cojedeca: —Coreni, Jʉ̃menijicʉque borotejarã mʉja, abujuvai jabocʉ mʉjare jʉjovarĩ, ãmeina tede d̶abequiyepe aivʉ. Mʉje ũme ʉe parʉrõ mariduivʉ. Ʉbenita mʉje baju d̶aiye bajure parʉbevʉ mʉja, arĩdurejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cojedeca Jʉ̃menijicʉque borotecʉnʉrejamed̶a Jesús. Ʉ̃i Jʉ̃menijicʉque boroteiye báquepedeca bedióva borotecʉnʉrejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ʉ̃i bueimara yebai copainʉri, náre cãivʉre earejamed̶a Jesús cojedeca. Ãmei vʉo ijidejavʉ̃ya náre. Aru ʉ̃́re jʉ aiye majibedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bedióva Jʉ̃menijicʉque borotecʉnʉri, yóbecʉe borotecʉñʉ. Boroteni bʉojarĩ, ne yebai copainʉri, arejamed̶a náre: —¿Cãivʉrʉ̃ mʉja cãreja? Jede, quénoramu. Iora jave eaivʉ. Ijãravʉi dayʉ bácʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ãmeina teivʉre ne jẽni jínajimʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nacajajara mʉja. Copʉ nʉrajarevʉ. Yʉre ji mauvare jẽni jícʉyʉ daibi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ʉ̃i boroteiyedecata earejamed̶a Judas, nácacʉ, doce paivʉcacʉ. Obedivʉ põeva ʉ̃́que earĩ, boaicarovea aru boaidʉa dʉrʉrĩ earejaimad̶a, sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru judíova bʉcʉva máre ne daroimara. ");
INSERT INTO cubNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas, ñai Jesúre jẽni jícʉyʉ, ʉ̃i eaquiye jipocamia, javeta Jesúre boarĩ́ jarʉvaiyʉrivʉre coyʉrejamed̶a yópe: “Ji jacoyʉrĩ jiva nuimʉ macʉyʉ́me mʉje jẽnajimʉ. Ʉ̃́re jẽjara. Ʉ̃́re jẽni, ména ʉ̃́re jã́ri capʉrĩ nʉvajara mʉja”, arejamed̶a náre Judas. ");
INSERT INTO cubNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jesús yebai nʉri, cũiná Judas ʉ̃́re earĩ, arejamed̶a: —Aru, bueipõecʉ, arejamed̶a Jesúre Judas. Que arĩ, ʉ̃́re jiva nuri jacoyʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Que teni ina põeva ʉ̃́re jẽnejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nópe teiyede jã́ri, cũinácʉ Jesúi bueimaracacʉ ʉ̃i boaicarovede tatorĩ, duarĩ, ĩni, sacerdotevare jaboteipõecʉi yebacacʉre juijórĩ najuárejamed̶a ʉ̃i cámucare. ");
INSERT INTO cubNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ʉ̃́re jẽnaeaivʉre arejamed̶a Jesús: —¿Tatorĩ ñavaipõecʉre jẽivʉpe yʉre boaicaroveaque aru boaidʉaque jẽni jacorãdaivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jãravʉa coapa mʉje jẽneboi Jʉ̃menijicʉi cʉ̃rami bueyʉ batecácʉ yʉ. Apʉrĩ mʉjaque cʉcʉre, yʉre jẽni jacobeteavʉ̃ mʉja. Ʉbenita yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca, caiye iye vaivʉ, náre arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Que tedurata ʉ̃i bueimara ʉ̃́re jocarĩ, dupini nʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cũinácʉ bojʉyo, nore cʉcʉ, Jesús yóboi nʉñʉ, dorejamed̶a quénora cũinácaje doicaje meacajede, lino ãmicʉricajede. Jesúre jẽivʉ bácavʉ jẽnidurejaimad̶a ñai bojʉyore máre, ʉ̃i doicajede jẽni. ");
INSERT INTO cubNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ʉbenita dajocayʉ dicajede ne pʉrʉái, cúyarĩ, dupini nʉrejamed̶a cuitótecaje cʉbecʉva. ");
INSERT INTO cubNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesúre nʉvarejaimad̶a sacerdotevare jaboteipõecʉ yebai na, ʉ̃́re jẽivʉ bácavʉ. Nore ina sacerdotevare jaboteipõeva, aru ina judíova bʉcʉva, aru ina Jʉ̃menijicʉi yávaiye báquede bueipõeva máre ne baju cójijini borotenanʉrejaimad̶a ne jabova baju ne cójijiñami. ");
INSERT INTO cubNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Aru Pedro joajĩenata Jesús yóboi nʉre nʉñʉ mácʉ, sacerdotevare jaboteipõecʉi tãibʉi ecorejamed̶a ʉ̃. Nore ecorĩ, Jʉ̃menijicʉi cʉ̃ramine coreipõevaque toaboi cʉocarĩ dobarejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Na sacerdotevare jaboteipõeva aru caivʉ ne cójijinocavʉ Jesúre ãmecororãjivʉre vorĩdurejaimad̶a, ʉ̃́re boarĩ́ jarʉvaiyʉrivʉ. Ʉbenita eabedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Obedivʉ Jesúre borocʉrĩ ãmecororĩdurejaimad̶a. Ʉbenita cũinátʉrʉ boro coyʉbedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Apevʉ ne jẽneboi cʉrivʉ nacajari, núri, borocʉrĩ ãmecororejaimad̶a Jesúre, yópe arĩ: ");
INSERT INTO cubNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ʉ̃i yópe arĩ coyʉiyede jápiacarã ñʉja: “Iñami Jʉ̃menijicʉi cʉ̃rami, põevai d̶aiñamine, jarʉvacʉyʉmu yʉ. Yóbecʉrijãravʉa ji jarʉvarĩburu yóboi, aped̶ãmi d̶acʉyʉmu yʉ. Ʉbenita ji pʉrʉáque d̶abecʉbu yʉ”, áme Jesús, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ʉbenita yópe ne ãmecororĩduiyedeca cũinátʉrʉ abedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Dinʉmʉre ñai sacerdotevare jaboteipõecʉ nacajari ne coricai núri, arejamed̶a Jesúre: —¿Coyʉrĩ majibecʉrʉ̃ mʉ? ¿Ne nópe ãmecoroiyede, aipe ayʉrʉ̃ mʉ? arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ʉbenita Jesúcapũravʉ bi arejamed̶a. Dinʉmʉ bedióva cojedeca arejamed̶a Jesúre sacerdotevare jaboteipõecʉ: —¿Mʉ Cristo ãmecʉrʉ̃ mʉ? ¿Jʉ̃menijicʉ meacʉi mácʉrʉ̃ mʉ? arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aru Jesús arejamed̶a ʉ̃́re: —Quédeca mi aimʉtamu yʉ. Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, yʉre, jã́rajaramu mʉja, Jʉ̃menijicʉ parʉcʉi meapũravʉi dobacʉre. Aru ji ocopeniboai jõd̶ari ẽmeiyede máre jã́rajaramu mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Que ayʉre, ñai sacerdotevare jaboteipõecʉ jorojĩni, ʉ̃i doiyede tatorĩ, jad̶evarĩ, arejamed̶a: —Apevʉ ne coyʉiye jaʉbevʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Javeta mʉja jápiad̶avʉ̃. Jʉ̃menijicʉ ʉbebi ñai nópe yávayʉre. ¿Aipe ad̶arãrʉ mʉja? arejamed̶a ʉ̃. —Boarĩ́ jarʉvaimʉ macʉyʉ́me ʉ̃, arejaimad̶a na caivʉ, ʉ̃́re boarĩ́ jarʉvaicõjeivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Que arĩ, ʉ̃́ra jẽcututurejaimad̶a na. Aru ʉ̃i jivare moari, ʉ̃́re pẽvavarejaimad̶a na. Aru arejaimad̶a: —Coyʉjacʉ mʉ. ¿Ñame matedí mʉre pẽvañʉ? ʉ̃́re pẽvavaivʉ arejaimad̶a na. Ina Jʉ̃menijicʉi cʉ̃ramine coreipõeva máre ʉ̃́re totarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ʉ̃i cʉedeca tãibʉi, sacerdotevare jaboteipõecʉi yebacarõmivacaco cũináco nore earejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ʉ̃ cʉocayʉre jã́ri, ʉ̃́re me cocorejacod̶a õ. Aru arejacod̶a: —Mʉ máre ñai Jesús Nazarecacʉque cʉ́tevʉ mʉ, arejacod̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ʉbenita Pedrocapũravʉ arejamed̶a ṍre: —¡Nácacʉ ãmevʉ! Jesúre yʉ coreóvabevʉ. ¿Aipe arĩ, mʉ que ad̶orʉ̃? arejamed̶a. Que arĩ, tãibʉi etarĩ, jedevai nʉitenevei nʉrejamed̶a Pedro. Dinʉmʉ cáyu órejarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Aru bedióva cojedeca ʉ̃́re jã́ri, arejacod̶a ico yebacaco náre, nore cʉrivʉre coyʉyo: —Ñai nácacʉbe ʉ̃, arejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Aru Pedrocapũravʉ arejamed̶a cojedeca: —¡Nácacʉ ãmevʉ! Jesúre yʉ coreóvabevʉ, arejamed̶a. No yójĩboi ina nore cʉrivʉ Pedrore jã́ri, cocorĩ, arejaimad̶a ʉ̃́re cojedeca: —Mʉ máre nácacʉbu mʉ. Galileacacʉtamu mʉ, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Dinʉmʉma jãve ayʉpe, náre pare baju arĩ coyʉrejamed̶a Pedro: —¡Jãveneca Jʉ̃menijicʉi jã́inoi yʉ mʉjare coyʉyʉtamu! ¡Jãve ji coyʉbedu, Jʉ̃menijicʉ ãmed̶ajacʉrĩ yʉre! Mʉje aimʉre ye majibecʉtamu yʉ. Jesúre yʉ coreóvabevʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ʉ̃i que aiye bajure, bedióva cojedeca órejarejamed̶a cáyu. Ʉ̃i órejaiyede, Pedro ãrʉrejamed̶a Jesús ʉ̃i coyʉiye báquede: “Cáyu ʉ̃i pʉque órejaquiye jipocai, yóbecʉe baju, ‘Jesúre yʉ coreóvabevʉ’, acʉyʉmu mʉ”, arĩ coyʉiye báquede ãrʉrejamed̶a. Aru ãrʉcʉ, cũiná orejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aviá ʉ̃i tucʉmʉiyede ina sacerdotevare jaboteipõeva, judíova bʉcʉvaque, Jʉ̃menijicʉi yávaiye báquede bueipõevaque, aru caivʉ ne cójijinocavʉ diede boroteni cójijidejaimad̶a na. Boroteni bʉojarĩ, Jesúre bʉorĩ, nʉvari jabocʉ ʉ̃i ãmiá Pilato yebai jacorãnʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ne nʉvaiyede ʉ̃́re, Pilato arejamed̶a Jesúre: —¿Mʉ́rʉ judíovai jabocʉ? arejamed̶a. Jesúcapũravʉ arejamed̶a: —Quédeca, mi aimʉrecabu yʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Dinʉmʉma Jesúre caijĩe ãmene ãmecororejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Aru Pilatocapũravʉ arejamed̶a Jesúre: —¿Copʉ náre jʉ abecʉrʉ̃ mʉ? ¿Jápiabecʉrʉ̃ caijĩe ne ãmecoroiyede mʉre? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ʉbenita ye yávabedejamed̶a Jesús. Ʉ̃i yávabe boje, ʉrarõ dápiarejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","No torojʉve teinʉmʉre Pilatocapũravʉ jacoimʉ mácʉre põeva ne etavaicõjeimʉre etavavarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Roma ãmicʉrõ jaboteinore boainʉmʉre, põevare boarĩ́ jarʉvaivʉ bácavʉ jacoimara marejáimad̶a. Nácacʉ cũinácʉ Barrabás ãmicʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Obedivʉ põeva Pilato yebai mʉri nʉri, jẽniari jã́ranʉrejaimad̶a Pilatore: —Mi d̶arĩ cõmajiyepe d̶acajacʉ caride, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ne jẽniari jã́iyede arejamed̶a náre Pilato: —¿Dinʉmʉ mʉje jabocʉre jaetovaji yʉ? arĩdurejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ina sacerdotevare jaboteipõeva Jesúre ne jorojĩyede majini, obedivʉ põeva ne ʉe boje ʉ̃́re, nópe náre jẽniari jã́rejamed̶a Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ʉbenita ina põevare majicarĩ, aicõjenejaimad̶a sacerdotevare jaboteipõeva yópe: —“Barrabáre jaetovajacʉ mʉ”, arĩ coyʉjarã mʉja Pilatore, arejaimad̶a sacerdotevare jaboteipõeva. Que baru ina põeva náre jʉ arĩ, que arejaimad̶a Pilatore. ");
INSERT INTO cubNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne que coyʉrĩburu yóboi, arejamed̶a náre Pilato: —¿Dinʉmʉ ñai judíovai jabocʉ, mʉje aimʉre, aipe d̶aji yʉ? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—¡Ʉ̃́re jocʉcʉjaravena pẽvari, boarĩ́ jarʉvaicõjejacʉ mʉ! cod̶oboborĩ arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Yéde ãmeina tearĩ ñai? jẽniari jã́rejamed̶a náre Pilato. Ʉbenita pʉeno baju cod̶oboborĩ arejaimad̶a na: —¡Ʉ̃́re jocʉcʉjaravena pẽvari, boarĩ́ jarʉvaicõjejacʉ mʉ! arĩ cod̶oboborejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Que teiyede Barrabáre jaetovarejamed̶a Pilato, náre ne ʉrõpe d̶aiyʉcʉ. Aru Jesúre jara popeicõjenejamed̶a. No yóboi churaravare Jesúre jocʉcʉjaravena pẽvaicõjenejamed̶a ʉ̃, Pilato. ");
INSERT INTO cubNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Que teni ina churarava Jesúre ĩni, nʉvari jabocʉi cʉ̃rami, ʉ̃́re ecovarejaimad̶a diñami tãibʉi. Nore ecovarĩ, cójijicõjenejaimad̶a caivʉ apevʉ churaravare. ");
INSERT INTO cubNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesúre pʉenocacaje, jabocʉi doicajepe paicaje ñemijuaricajede doarejaimad̶a na. Doarĩ bʉojarĩ, miumua cãteni, cainitarabʉre d̶arĩ, ʉ̃i jipobʉrã ditarabʉre tʉorejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Que d̶arĩ ʉ̃́re jacoyʉrejaimad̶a na: —Ména cʉjacʉ mʉ, judíovai jabocʉ, arejaimad̶a churarava Jesúre, ʉbenita ʉ̃́re yʉrivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ʉ̃́re jipobʉrã jocʉyoque jãd̶ori, ʉ̃́ra jẽcututuri, ʉ̃́re jabocʉre jacoyʉivʉpe ñʉaturĩ tedejaimad̶a na coapa. ");
INSERT INTO cubNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ʉ̃́re yʉrini bʉojarĩ, ʉ̃́re ne doicaje ñemijuaricaje bácarõre, no jabocʉi doicajepe paicajede ĩni, duarĩ, ʉ̃i doicaje bácarõre bedióva ʉ̃́re doarejaimad̶a cojedeca. Que teni bʉojarĩ, ʉ̃́re nʉvari, jocʉcʉjaravena ʉ̃́re pẽvari jẽoranʉrejaimad̶a na, churarava. ");
INSERT INTO cubNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesús jocʉcʉjaravede ture nʉñʉ maridurejamed̶a. Aru cuyʉ bácʉ ĩmaroi earejamed̶a Simón, Cirene ãmicʉriĩmarocacʉ. Alejandro aru Rufo népacʉ barejámed̶a ʉ̃, Simón. Nore vaiyʉ́re, ʉ̃́re Jesús ʉ̃i jocʉcʉjaravede tuino mácarõre tuicõjenejaimad̶a na, churarava. ");
INSERT INTO cubNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ina churarava nʉvarejaimad̶a Jesúre cʉ̃racũ Gólgota ãmicʉricũi, Põe jipobʉcũ aiyʉrõmu. ");
INSERT INTO cubNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Noi ũcuiye upiáteiye báque cʉrijororʉ cʉrejavʉ̃ya, vino ʉ́yaicoro mirra ãmicʉe jocʉcʉ cuidóque. Die ũcuiyede jínidurejaimad̶a Jesúre, ʉ̃́re ijibequiyepe aivʉ. Ʉbenita ʉ̃ ũcuri jã́ri, ʉbecʉ, ũcumenejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Que teni ʉ̃́re jocʉcʉjaravena pẽvari jẽorejaimad̶a. Aru ne yajuiyede cainijidʉare dʉvarejaimad̶a. Didʉá etaiyede jã́ri, majidejaimad̶a ácʉ nácacʉ ĩcʉyʉre Jesús ʉ̃i doiye báque coapa. Que teni yajurĩ, coavarĩ Jesús ʉ̃i doiye báquede, ĩnejaimad̶a ʉ̃́re pẽvaivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Javejĩna nueve baji, pẽvari jẽorejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jocʉcʉjaravena, ʉ̃i jipobʉ pʉenoi, toivaino jẽnejavʉ̃ya, apevʉ ne majinajiyepe aino Jesúre boarĩ́ jarʉvaivʉ ne dápiainore, “¿Aipe teni ʉ̃́re boarĩ́ jarʉvarãma na?” ne aino. Yópe aiyʉrejavʉ̃ya no toivaino: “Judíovai jabocʉbe”. ");
INSERT INTO cubNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ʉ̃́que máre pẽvari jẽorejaimad̶a pʉcarã tatorĩ ñavaipõevare, ape pʉcarõa jocʉcʉjaravearã. Cũinácʉ Jesús ʉ̃i meapũravʉi aru apecʉ ʉ̃i cãcopũravʉi cʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Que teni d̶arejaimad̶a ina yópe Jʉ̃menijicʉ ʉ̃i toivaicõjeiye báquepedeca ʉ̃i yávaiyede: “Põeva ʉ̃́re d̶arãjarama yópe ne d̶aiyepe ãmeina teivʉre”, toivaicõjenejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Ina vainánʉraivʉ jã́ri, ne jipobʉare cújiovarĩ, ãmeina yávarejaimad̶a ʉ̃́re, yópe arĩ: —Mʉ, Jʉ̃menijicʉi cʉ̃ramine jarʉvaiyʉvacacʉ aru yóbecʉrijãravʉa yóboi diñamine mead̶aiyʉvacacʉ, caride jocʉcʉjaravede dajocarĩ, ẽmeni, mi bajure mead̶ajacʉ mʉ, arejaimad̶a Jesúre ina vainánʉraivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nopedeca ina sacerdotevare jaboteipõeva aru Jʉ̃menijicʉi yávaiye báquede bueipõevaque máre, ne baju yʉrivʉ Jesúre, yópe arejaimad̶a: —Apevʉre mead̶avacacʉvacari, ʉbenita ʉ̃i bajure mead̶arĩ majibebi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo, Israecavʉ ne jabocʉ, jocʉcʉjaravede dajocarĩ, ẽmeni, dajacʉrĩ ʉ̃. Que d̶aru, maja jʉ arãjaramu ʉ̃́re, arejaimad̶a na. Aru ina pʉcarã pẽvaimara mácavʉ máre ʉ̃́que, nopedeca ãmeina yávarejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jãravʉ corica baji ñemié tʉrĩ darejavʉ̃ya caino joborõi. Pʉ yóbecʉriora yóboita vaidéjavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aru yóbecʉriora bajita, iye ñemié tʉiyede dajocaiyede, pare bʉjié cod̶oboborĩ, yávarĩ darorejamed̶a Jesús: —Eloi, Eloi, ¿lama sabactani? Nópe aino: “Mʉ, ji mearore jímʉ, mʉ, Jʉ̃menijicʉ, ¿aipe teni yʉre dajocarĩ nʉñʉrʉ mʉ?” aiyʉrõ marejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Que ayʉre, apevʉ nore núrivʉcavʉ ʉ̃́re jápiarĩ, ʉbenita jápiarĩ eabeni, arejaimad̶a: —Jápiajarã. Elíare órejaibi ʉ̃, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dinʉmʉre cũinácʉ nácacʉ cúyarĩ, jaʉbore ĩni, ʉyovarejamed̶a vino ʉ́yaicoro upiáricoroque aru dijaʉ́bore abod̶orã bʉorĩ, jẽori, jarʉrʉrejamed̶a Jesús ʉ̃i ũcuquiyepe ayʉ. Aru arejamed̶a: —Corejarã. Jã́rajarevʉ Elías jõd̶avacʉdayʉre ʉ̃́re, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","38","Cojedeca Jesús pare bʉjié cod̶oboborĩ, “Quénoramu” arĩ, yaidéjamed̶a ʉ̃. Ʉ̃i yaiyeda, Jʉ̃menijicʉi cʉ̃ramicacaje ʉracaje coricõpavaicaje bácarõ quéda corica baji jad̶eni nʉrejavʉ̃ya, pʉenocatʉrʉvai bʉ́rĩ pʉ cãchinocatʉrʉvaita. ");
INSERT INTO cubNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nore Jesús bácʉre cocorĩ núcʉ barejámed̶a churaravai jabocʉ. Jesús yaiyʉ́re jã́ri, arejamed̶a ñai: —Jãveneca Jʉ̃menijicʉi mácʉ baju batecʉ́be ñai, arejamed̶a churaravai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nomiva máre cocorĩ núrivʉ joajĩemia cʉrejaimad̶a. Ne jẽneboi cʉrejaimad̶a cũináco nomió, Magdala ãmicʉriĩmarocaco, õi ãmiá María, aru apeco õi ãmiá Salomé, aru apeco õi ãmiá María máre, ico Santiago aru José népaco. Ñai Santiago bojʉyo barejámed̶a. Apecʉ Santiago bʉcʉcʉ ʉ̃i cãchinocacʉ barejámed̶a ʉ̃, Maríai mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Na Jesús ʉ̃i cʉede Galilea ãmicʉrõi cad̶ateivʉ barejáimad̶a ʉ̃́re. Aru apevʉ nomiva, ina eaivʉ bácavʉ ʉ̃́que Jerusalén ãmicʉriĩmaroi, cʉrejaimad̶a nore. ");
INSERT INTO cubNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Dijãravʉ, nainú, torojʉve teijãravʉ baquinóre mead̶aijãravʉ barejávʉ̃ya. Sábado baquinó jipocacajãravʉ barejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Pilato yebai nʉrejamed̶a José, Arimatea ãmicʉriĩmarocacʉ. Sacerdotevai cójijinore coyʉipõevacacʉ barejámed̶a ʉ̃. Ne pued̶aimʉ marejámed̶a José. Ʉ̃ máre Jʉ̃menijicʉi jabotequinʉmʉ maquinóre napini coreyʉ barejámed̶a. Jidʉrõ cʉbeno, parʉriũme cʉrĩ, Pilato yebai nʉri, Jesús bácʉi baju bácarõre jẽniacʉnʉrejamed̶a ʉ̃. José ʉ̃i jẽniaiyede, Pilato cuturejamed̶a churaravai jabocʉre. Aru jẽniari jã́rejamed̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","—¿Jave yaidíca ʉ̃? ¿Aipiye bajure yaidí? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aru churaravai jabocʉ jʉ arejamed̶a: —Jave yaibí ʉ̃ mácʉ, arejamed̶a. Aru aiyeta, Jesús bácʉi baju bácarõre ĩ́cõjenejamed̶a Pilato, Joséde ĩ́cõjeñʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Meacaje boricaje, lino ãmicʉricajede bojed̶arĩ, Jesús bácʉre jocʉcʉjaravede jõd̶avari, ĩni, dicajeque, ʉ̃ mácʉre cũmari bʉorejaimad̶a Joséjã. Ʉ̃ mácʉre nʉvari cʉ̃racobei, Jesús bácʉre jarʉvarejaimad̶a na. Nore ne jarʉvarĩburu yóboi, apetʉrava cʉ̃ratʉravare ĩni, jãturuvari, dicobede biedejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Aru Jesús bácʉre jarʉvainore jã́rejaimad̶a na, María Magdalacaco aru María, Joséi paco máre. ");
INSERT INTO cubNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","No judíovai jabʉóvaijãravʉ sábado, nainú vaiyede, María Magdalacaco, aru Salomé, aru Santiagoi paco mumijʉribʉre ĩni bojed̶arejaimad̶a na. Jesús bácʉre ne jarʉvainoi nʉri, die mumijʉeque ʉ̃ mácʉi baju bácarõre yuarãnʉivʉ barejáimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","No sumana bʉijãravʉ domingo javejĩnara, aviá ʉ̃i tucʉmʉiyede, Jesús bácʉre ne jarʉvainoi nʉrejaimad̶a ina nomiva. ");
INSERT INTO cubNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ne bajumia borotede nʉrejaimad̶a, yópe arĩ: —¿Ñame majare cʉ̃racobe bieitʉravare jãturuvari, cad̶atenajidica na? arejaimad̶a dinomiva. ");
INSERT INTO cubNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ne eaiyede nore, dicobe biebecobede jã́rejaimad̶a na. Ditʉrava bieitʉrava bácarõ ʉratʉrava baju barejávʉ̃ya. Ʉbenita joajĩeneca ditʉravare jã́ri earejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dicobede ecoivʉ nore meapũravʉi dobacʉre, bojʉyore jã́rejaimad̶a ina nomiva. Boricajede, ʉ̃mʉjʉricajede doyʉ barejámed̶a ʉ̃. Aru dinomiva cuecumarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Náre arejamed̶a: —Jidʉbejarã mʉja. Jesús Nazarecacʉre, ne jocʉcʉjaravena pẽvaimʉ mácʉre, vorĩduivʉbu mʉja. Yore cʉbebi ʉ̃. Javeta nacajami. Jã́rijide apa. Ʉ̃i bajure ne jarʉvaino mácarõre jã́jara mʉja. ");
INSERT INTO cubNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pedrore aru Jesúi bueimara mácavʉ apevʉre yópe coyʉrãnʉjara mʉja: “Mʉje jipocai Galileai nʉcʉyʉme Jesús. Nore mʉjare ʉ̃i ávarepe ʉ̃́re jã́rajaramu mʉja”, ajarã, arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aru dicobede etarĩ, cúyarĩ nʉrejaimad̶a ina nomiva. Jidʉrĩ bididejaimad̶a na. Nʉri, ne copʉimarare ye abedejaimad̶a dinomiva, cuecumaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús nacajañʉ mácʉ yainore jarʉvarĩ, sumana bʉijãravʉ domingo javejĩnara, cʉetedejamed̶a mamarʉmʉre María Magdalacacore, ico ʉ̃i jarʉvaimo máco siete paivʉ abujuvare. ");
INSERT INTO cubNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Õ nʉri, majide d̶arejacod̶a ina ʉ̃́que cʉrivʉ bácavʉre, chĩori oivʉre. ");
INSERT INTO cubNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Aru na jápiaivʉ nacajañʉre yainore jarʉvarĩ, aru õi jã́ino mácarõre máre jápiarĩ, “Jãve majʉvʉ́”, abedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","No yóboi cʉetedejamed̶a apecʉpeda ina pʉcarã ʉ̃i bueimaracavʉre ne nʉiyede mái ĩmarore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na nʉri coyʉrĩdurejaimad̶a nácavʉre. Ʉbenita jʉ abedejaimad̶a náre máre. ");
INSERT INTO cubNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yóbo baji Jesús cʉetedejamed̶a caivʉ once paivʉ ʉ̃i bueimarare ne dobaede tʉoiva yebai. Jʉ abevʉ barejáimad̶a ina jã́ivʉ bácavʉ Jesúre, nacajañʉ mácʉre yainore jarʉvarĩ, ne coyʉiyede ʉ̃́ra. Que baru jararejamed̶a ne jʉ abenore aru ne jápiarĩ coreóvabede máre. ");
INSERT INTO cubNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Arejamed̶a náre: —Buenanʉjara caivʉ ijãravʉcavʉre iye yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nácavʉ ne jʉ arĩ jã́d̶ovaru Jʉ̃menijicʉre ocoque mead̶acʉyʉmu yʉ. Ʉbenita nácavʉ jʉ abevʉ baru bíjarãjarama na. ");
INSERT INTO cubNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ina yʉre jʉ aivʉ põeva ne d̶arĩ majibede d̶arãjarama. Ji ãmiái, ji parʉéque, jaetovarãjarama abujuvare. Yávarãjarama apecamua yávaicamuare ne majibecamuare. ");
INSERT INTO cubNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Dʉrʉrãjarama ãd̶avare. Ne ũcuiyede ijede ye ãmed̶abequiyebu náre. Ijimarare tʉorãjarama, aru meatenajarama na, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesús yávayʉ bácʉ náre, mʉri nʉrejaquemavʉ ijãravʉre jocarĩ. Nʉrejaquemavʉ cavarõ mearo Jʉ̃menijicʉi cʉrõi. Dobarejaquemavʉ Jʉ̃menijicʉi meapũravʉi. ");
INSERT INTO cubNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aru ʉ̃i bueimara mácavʉ coyʉrãnʉrejaimad̶a iye yávaiye méne põevare cainoai. Que baru cainʉmʉa Jesús cad̶atedejamed̶a ʉ̃i põevare, ne coyʉrãjiyepe ayʉ Jʉ̃menijicʉi yávaiyede põeva ne d̶arĩ majibede d̶aiyeque. Quénoramu.");
INSERT INTO cubNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mʉ, Teófilo, obedivʉ põeva toivarĩ bʉ́quemavʉ caiye iye Jesúi d̶aiye báquede maje jẽneboi coyʉinore. ");
INSERT INTO cubNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yópe ina mamarʉmʉre jã́ivʉ bácavʉ caiye Jesúi d̶aiye báquede aru Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquede coyʉivʉ bácavʉ majare toivaquemavʉ. Návacari ʉ̃́que cʉrejaquemavʉ ʉ̃i mamabʉijãravʉi pʉ ʉ̃i jebeijãravʉita. ");
INSERT INTO cubNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aru yʉ máre jãve jã́ri coreóvacacʉ joe báque caiye iye d̶aiye báquede. Que baru dápiavʉ yʉ yópe, “Ji toivaru coyʉinore iye teiye báquepe Teófilore, meajebu ʉ̃́re”, arĩ dápiavʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Que baru toivaivʉ mʉre, mi majiquiyepe ayʉ jãveneca iye coyʉiye mi jápiaiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ãnijãravʉa báquei Herodes bácʉ Judea ãmicʉrijoborõcavʉ ne jabocʉ baede, cʉrejamed̶a cũinácʉ sacerdote, ʉ̃i ãmiá Zacarías. Abías ãmicʉriyajubocacʉ barejámed̶a ʉ̃. Jímarepaco máre Aarón ãmicʉcʉ bácʉ sacerdote bácʉi pãrameco barejácod̶a, õi ãmiá Isabel. ");
INSERT INTO cubNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ina pʉcarã meara marejáimad̶a Jʉ̃menijicʉi jã́inore. Aru d̶arejaimad̶a iye Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquede Moisés bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ʉbenita Isabel jʉed̶oeabedejacod̶a. Aru ina pʉcarã bʉcʉjĩna marejáimad̶a. Que baru jʉed̶ocʉvabedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Cũinájãravʉ Zacaríai yajubo, sacerdotevacavʉi yajubo, ne memeijãravʉ Jʉ̃menijicʉi cʉ̃rami jívʉi barejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Aru Zacaríare ne beoiye boje, ʉ̃i juacʉnʉino marejávʉ̃ya. Que baru sacerdoteva ne d̶arĩ cõmajiyepedeca d̶aiye jaʉrejavʉ̃ya ʉ̃́re. Mumijʉede juacʉecorejamed̶a ʉ̃ Jʉ̃menijicʉi cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Que teni obedivʉ põeva jẽniarejaimad̶a Jʉ̃menijicʉre ʉ̃i cʉ̃rami jedevacobei diora, mumijʉede juaiorai. ");
INSERT INTO cubNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías mumijʉede juayʉ bácʉ, ʉ̃́re cʉetedejamed̶a cũinácʉ ángele, Jʉ̃menijicʉi daroimʉ, núcʉ meapũravʉi ne juaino yebai. ");
INSERT INTO cubNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Aru ʉ̃́re jã́ri, cuecumarejamed̶a Zacarías. Jidʉcʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ʉbenita ñai ángele arejamed̶a ʉ̃́re: —Mʉ, Zacarías, jidʉbejacʉ mʉ. Jʉ̃menijicʉ jápiaibi mi jẽniaiye báquede. Aru caride Jʉ̃menijicʉ cad̶atecʉyʉme mʉre. Mimarepaco jʉed̶ocʉvacod̶ome. Aru Juan ãmidojacʉ mʉ ʉ̃ macʉyʉ́re. ");
INSERT INTO cubNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Torojʉcʉyʉmu mʉ mímacʉ bacʉyʉ́re boje. Aru obedivʉ põeva torojʉrãjarama ʉ̃i põeteiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mímacʉ bacʉyʉ́ parʉcʉ bacʉyʉ́me Jʉ̃menijicʉi jã́inore. Jʉ̃menijicʉi Espíritu Santo ʉ̃́que cʉcʉyʉme jípacoi yapibʉ jívʉmiareca. Que baru vino ʉ́yaicoro boqueicorore ũcumecʉyʉme ʉ̃. Aru apecoro boqueicorore máre ũcumecʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ñai mímacʉ bacʉyʉ́ obedivʉ põeva Israel bácʉi pãramena márajivʉre, ʉ̃i coyʉquiyede náre Jʉ̃menijicʉi yávaiye méne, chĩore d̶arĩ jʉ arãjarama ne jabocʉ Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jʉ̃menijicʉ nópe d̶are d̶acʉyʉme mímacʉ bacʉyʉ́re. Aru jipocatede d̶acʉyʉme mímacʉ bacʉyʉ́re maje jabocʉre ʉ̃i Espírituque, ʉ̃i parʉéque. Nopedeca Jʉ̃menijicʉ parʉre d̶arejaquemavʉ ʉ̃i yávaiyede coyʉcaipõecʉ bácʉre máre, ʉ̃i ãmiá Elías, ʉ̃i Espírituque, ina bʉcʉva ne jʉ arĩ jipocatenajiyepe ayʉ némarare ne cãrijimene d̶arãjiyepe ayʉ náque, aru ina jʉ abevʉ ne dápiarãjiyepe ayʉ jʉ aivʉ ne majiépedeca. Caiye iye d̶acʉyʉme mímacʉ bacʉyʉ́ põevare mead̶arĩ, ne jacopʉrãjiyepe ayʉ maje jabocʉre, Jʉ̃menijicʉi daroquimʉre, arejamed̶a ñai ángele Zacaríare. ");
INSERT INTO cubNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ñai ángele ʉ̃i arĩburu yóboi, Zacarías jẽniari jã́rejamed̶a ʉ̃́re: —¿Aipe d̶arĩ coreóvaji yʉ jimarepaco jʉed̶ocʉvacod̶ore? Bʉcʉcʉbu yʉ. Aru jimarepaco máre bʉcʉcobe õ, arejamed̶a Zacarías. ");
INSERT INTO cubNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aru ñai ángele arejamed̶a ʉ̃́re: —Yʉ́bu Gabriel. Yʉ núcʉbu cainʉmʉa Jʉ̃menijicʉ yebai, memecayʉ ʉ̃́re. Jʉ̃menijicʉi daroimʉmu yʉ. Mʉre coyʉcʉdayʉbu yʉ iye yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ʉbenita caride yávarĩ majibecʉbu mʉ. Aru yávabecʉyʉmu mʉ mímacʉ bacʉyʉ́ ʉ̃i põeteiyeta, mi jʉ abe boje ji coyʉiyede. Caiye vaiquíyebu yópe ji coyʉiyepe mʉre cari, arejamed̶a ñai ángele. ");
INSERT INTO cubNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aru ina nópe coyʉivʉ, caivʉ ina obedivʉ põeva Zacaríai etaiyede coredejaimad̶a na. Ʉrarõ coreni ʉ̃́re, pare dápiarejaimad̶a, “¿Aipe teni Zacarías etabedi Jʉ̃menijicʉi cʉ̃ramine jocarĩ?” aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Bʉojarĩ, etarejamed̶a Zacarías Jʉ̃menijicʉi cʉ̃ramine jocarĩ. Etayʉ bácʉ, yávarĩ majibedejamed̶a náre. Que baru ina põeva coreóvarejaimad̶a Zacarías jã́ñʉ mácʉre yópe decoboainope apʉcʉre diñami Jʉ̃menijicʉi cʉ̃rami jívʉi. Zacaríacapũravʉ yaredejamed̶a ʉ̃i pʉrʉque náre. Ʉbenita yávarĩ majibecʉ mautedejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","No yóboi, apejãravʉ ʉ̃i yajubo, sacerdotevacavʉi yajubo, ne Jʉ̃menijicʉi cʉ̃rami memeijãravʉa yóboi, Zacarías copainʉrejamed̶a ʉ̃i cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Aru dijãravʉa yóboi jímarepaco jʉed̶oearejacod̶a õ. Que teni cũinápʉrʉpe paiaviavare mautedejacod̶a õ cʉ̃rami jívʉi. Aru arejacod̶a: ");
INSERT INTO cubNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Yopedeca d̶acaquemavʉ Jʉ̃menijicʉ yʉre. Cõmaje ãroje jã́ri yʉre, ĩame ji cʉyeno mácarõre. Aru d̶acaibi yʉre põeva ne cõenímenajiyepe ayʉ, arejacod̶a õ, Isabel. ");
INSERT INTO cubNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Isabel õi seis paiaviava micaco baedata, dinʉmʉita bedióva cojedeca ñai ángele Gabriede darorejamed̶a Jʉ̃menijicʉ, Galilea ãmicʉrõi, Nazaret ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Diĩmaroi cũináco nomió cʉrejacod̶a, María ãmicʉco. Õ marejácod̶a David bácʉi pãramecʉ Joséi márepaco bacod̶ó. Õ ye cʉbedejacod̶a ʉ̃mʉque cãreja. Õi yebai darorejamed̶a Jʉ̃menijicʉ ñai ángelede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Õi yebai earĩ, yópe arejamed̶a Maríare ñai ángele: —¿Me cʉcorʉ̃ mʉ? Mʉ Jʉ̃menijicʉi beoimomu. Mʉ́que cʉbi Jʉ̃menijicʉ, arejamed̶a Maríare. ");
INSERT INTO cubNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ʉbenita ñai ángele ʉ̃i nópe aiyede cuecumari, “¿Aipe ayʉ bárica ʉ̃ yʉre?” arĩ dápiarejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aru ñai ángele arejamed̶a ṍre: —Ji coyʉiyede jidʉbejaco mʉ, María. Jʉ̃menijicʉ mʉre jecʉbi. ");
INSERT INTO cubNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Micateni, jʉed̶ocʉvacod̶omu mʉ. Mi jʉed̶ocʉvacojimʉ Jesús ãmicʉcʉyʉme ʉ̃ macʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jabocʉ parʉcʉ bacʉyʉ́me mímacʉ bacʉyʉ́. Aru põeva arãjarama ʉ̃i borore, “Jʉ̃menijicʉ parʉcʉi mácʉbe ʉ̃”. Ʉ̃i ñecu mácʉ, David bácʉpe, jabotede d̶acʉyʉme Jʉ̃menijicʉ mímacʉ bacʉyʉ́re. ");
INSERT INTO cubNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel bácʉi pãramena ne jabocʉ bacʉyʉ́me. Mímacʉ bacʉyʉ́ ʉ̃i jaboteiye ye cũiméquiyebu, arejamed̶a Maríare. ");
INSERT INTO cubNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríacapũravʉ arejacod̶a ʉ̃́re: —¿Aipe ayʉrʉ̃ mʉ, nópe ayʉ? Yʉ ye ʉ̃mʉque cʉbecotamu yʉ, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ñai ángelecapũravʉ arejamed̶a ṍre: —Mʉre dacʉyʉme Jʉ̃menijicʉi Espíritu Santo. Aru Jʉ̃menijicʉ caivʉ pʉeno parʉcʉ ʉ̃i parʉé cʉquiyebu mʉ́que. Que baru mi jʉed̶ocʉvacojimʉ meacʉ baju bacʉyʉ́me ʉ̃. Jʉ̃menijicʉi mácʉ bacʉyʉ́me ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aru miparĩmo Isabel, bʉcʉcovacari, micacobe õ máre. Caride “jʉed̶oeabeco”, ne aimo máco javeta seis paiaviava micacotamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jʉ̃menijicʉ caiyede d̶aiye majibi. Que baru ye cʉbevʉ ʉ̃i d̶abeno, arejamed̶a Maríare ñai ángele. ");
INSERT INTO cubNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Aru arejacod̶a Maríacapũravʉ: —Jʉ̃menijicʉi yebacacotamu yʉ. Mi aiyepe bajarṍri yʉre, arejacod̶a õ. Coyʉrĩ bʉojarĩ, nʉrejamed̶a ñai ángele ṍre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Dijãravʉai María nʉrejacod̶a maumejie cũináĩmaroi, cʉ̃racũai, Judea ãmicʉrijoborõi. ");
INSERT INTO cubNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ĩmaroi earĩ, Zacaríai cʉ̃rami ecorejacod̶a õ. Aru ecorĩ jacoyʉrejacod̶a Isabede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Õi jápiaiyede Maríai jacoyʉiyede, õi mácʉ cújidejamed̶a õi yapibʉi. Aru Espíritu Santo dápiaicõjenejamed̶a Isabede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Que baru Isabel, yópe arĩ, cod̶oboborejacod̶a Maríare: —¡Jʉ̃menijicʉ mʉre me jã́ri, mearo d̶acaquemavʉ mʉre caivʉ nomiva pʉeno! ¡Jʉ̃menijicʉ me jã́ri, mearo d̶acacʉyʉme mímacʉ bacʉyʉ́re máre pʉeno baju! ");
INSERT INTO cubNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Cuecumari dápiaivʉ yʉ ji jabocʉi paco ji yebai õi cucodaiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ji jápiaiyede mi jacoyʉiyede, jímacʉ torojʉcʉ cújibi ji yapibʉi. ");
INSERT INTO cubNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mʉ jʉ arebu ángele ʉ̃i coyʉiye báquede mʉre. Mʉ dápiarebu Jʉ̃menijicʉ d̶acʉyʉre mʉre ʉ̃i aiye báquepedeca. Que baru Jʉ̃menijicʉ me teyʉbe mʉre. Torojʉvʉ mʉ, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Aru María arejacod̶a: Ji ũmei coreóvaivʉ ji jabocʉi parʉéde. ");
INSERT INTO cubNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Aru ji decocʉi torojʉvʉ Jʉ̃menijicʉre, yʉre mead̶aipõecʉre, boje. ");
INSERT INTO cubNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jʉ̃menijicʉ cõmaje ãroje jã́quemavʉ yʉre, ʉ̃i yebacacore. Que baru caivʉ ijãravʉcavʉ “Jʉ̃menijicʉi torojʉre d̶aimome õ”, arãjarama yʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ñai parʉcʉ baju d̶ayʉbe yʉre mearo ʉrarõre. Aru meacʉ bajube. Caivʉ apevʉ pʉeno meacʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Cõmaje ãroje jã́ñʉme caivʉ ina pued̶aivʉre ʉ̃́re, javede aru caride máre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ʉ̃i d̶aiyeque jã́d̶ovañʉme ʉ̃i parʉéde. Ina põeva ne baju me dápiaivʉre, apevʉ pʉeno meara dápiaivʉre, coavayʉbe. ");
INSERT INTO cubNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ina jabova parʉrivʉre ne parʉéde ĩñʉme náre jocarĩ. Aru ina cõmaje ãrojarivʉre mearo d̶acayʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ina ãuyaivʉre yapide d̶ayʉbe me ãiyeque. Aru ina cʉve cʉvarivʉre jaroyʉbe cʉve cʉvabevʉva. ");
INSERT INTO cubNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cad̶ateyʉbe ʉ̃i põevare, maja Israecavʉre, ʉ̃i cõmaje ãroje jã́ri ãrʉé boje. ");
INSERT INTO cubNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Cũinátʉrʉ yávarejaquemavʉ majeñecuva mácavʉre, Abraham mácʉre aru ʉ̃i pãramenare máre, cainʉmʉa, arejacod̶a María. ");
INSERT INTO cubNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Cʉrejacod̶a Isabeque yóbecʉrã aviáva. Aru no yóboi copainʉrejacod̶a õi cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Dinʉmʉai Isabel jʉed̶ocʉvarejacod̶a ʉ̃mʉ jʉed̶ojĩcʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Aru õi cad̶ajĩecavʉ, õ jivʉ máre, ne jápiaiyede õi borore Jʉ̃menijicʉ cõmaje ãroje jã́ñʉre ṍre, torojʉrejaimad̶a ṍque. ");
INSERT INTO cubNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho paijãravʉa põeteniburu yóboi, sacerdoteva õi mácʉi cajede buraicõjeni judíova ne d̶arĩ cõmajiyepe, d̶arãearejaimad̶a na. Aru ãmidorãjivʉ barĩdurejaimad̶a ʉ̃́re Zacarías, jípacʉpe. ");
INSERT INTO cubNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ʉbenita jípaco arejacod̶a: —Bi, Zacarías ãmemi. Ʉ̃ ãmicʉcʉyʉme Juan, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Que teni ina põeva arejaimad̶a ṍre: —Cʉbebi apecʉ mívʉ jẽnebore Juan ãmicʉcʉ, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aru ina põeva yaredejaimad̶a ne pʉrʉque jípacʉre, jẽniari jã́ivʉ ʉ̃́re, “¿Yécʉ ãmidocʉyʉrʉ̃ ʉ̃́re?” ");
INSERT INTO cubNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Que teni Zacarías jabióvarĩ jẽniarejamed̶a toivaivede. Aru toivarejamed̶a yópe: “Juan ãmicʉbi ʉ̃”. Que baru caivʉ pare dápiarejaimad̶a caiye iyede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Aru cũiná yávarĩ bʉ́rĩ, torojʉrĩ, mearore jídejamed̶a Jʉ̃menijicʉre Zacarías. ");
INSERT INTO cubNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Que baru caivʉ ina põeva, ʉ̃i cad̶ajĩecavʉ, cuecumarejaimad̶a na. Caiye iye borore borotedejaimad̶a caivʉ caino dijoborõi, Judea ãmicʉrijoborõcacũa cʉ̃racũai. ");
INSERT INTO cubNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Aru caivʉ ina jápiaivʉ, me dápiarĩ arejaimad̶a: —¿Yécʉ baquidíca ñai jʉed̶ocʉ? arejaimad̶a na. Aru Jʉ̃menijicʉ cad̶atedejaquemavʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Dinʉmʉre Espíritu Santo dápiaicõjenejamed̶a Zacaríare. Que baru Jʉ̃menijicʉi yávaiyede coyʉrejamed̶a: ");
INSERT INTO cubNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Torojʉvʉ yʉ Jʉ̃menijicʉque. Que baru mearore jívʉ yʉ maje jabocʉre, Israecavʉ maje mearore jímʉre. Cõmaje ãroje jã́ri ʉ̃i põevare, mead̶aibi majare abujuvai jabocʉi parʉéde jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jʉ̃menijicʉ daroyʉbe majare cũinácʉ mead̶aipõecʉre, ʉ̃i põecʉ David bácʉi pãramecʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Javede Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ, yópe arĩ, coyʉrejaimad̶a: “Jʉ̃menijicʉ darocʉyʉme mead̶aipõecʉre, ʉ̃i põevare mead̶aquiyepe ayʉ”. ");
INSERT INTO cubNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Majare mead̶aipõecʉ mead̶acʉyʉme majare maucʉvarivʉ ne parʉéde jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Que d̶acʉyʉme ʉ̃i cõmaje ãroje jã́iye báque boje maje jipocacavʉ bácavʉre aru ʉ̃i ãrʉmetebe boje “Yópe d̶arãjarevʉ”, ʉ̃i aino mácarõpedeca na mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jãve d̶acacʉyʉme majare yópe ʉ̃i aiye báquepedeca majeñecu mácʉ Abraham mácʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Mead̶acʉyʉme majare maucʉvarivʉre jarʉvarĩ, maje memecarãjiyepe ayʉ Jʉ̃menijicʉi jaboteinore jidʉbevʉva maja, mearore dápiarĩ aru mearore d̶arĩ Jʉ̃menijicʉi jã́iyede cainʉmʉa, caride pʉ maje yainʉmʉita, arejamed̶a Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aru mamacʉre máre arejamed̶a Zacarías: Mʉ, jímacʉ, coreóvarãjarama mʉre Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉre caivʉ pʉeno parʉcʉre. Que baru mʉ nʉcʉyʉmu maje jabocʉ jipocai. Coyʉcʉyʉmu Jʉ̃menijicʉi yávaiye méne põeva chĩori ne ãmeina teiyede, ne oatʉvarãjiyepe ayʉ ne d̶aiyede ʉ̃i daquiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Coreóvare d̶acʉyʉmu mʉ ʉ̃i põevare, ne majinajiyepe ayʉ mead̶aquiyede náre. Ʉ̃́recabe ãrʉmetecʉyʉ ne ãmeina teiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nópe d̶acʉyʉmu mʉ Jʉ̃menijicʉi cõmaje ãroje jã́iye boje põevare ãnijãravʉ, majare mead̶aipõecʉ bacʉyʉ́ ʉ̃i daquijãravʉ baquinói. Yópe mamajãravʉ miad̶áepe baquiyébu majare. ");
INSERT INTO cubNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ãnijãravʉ baquinóre yávaiyede jãvene majide d̶acʉyʉme põevare majare mead̶aipõecʉ bacʉyʉ́, yópe pẽoiye jã́re d̶aiyepe ina ñeminoi dobarivʉre, ina yainore jidʉrivʉre. Yópe máre pẽori maje cuiyepe, nopedeca cʉre d̶acʉyʉme majare cãrijimenoque. Jʉ̃menijicʉ majide d̶acʉyʉme caivʉ ina coreóvabevʉre ʉ̃i yávaiyede jãvene. Aru caivʉ majare cʉre d̶acʉyʉme cãrijimevʉva, arejamed̶a Zacarías. ");
INSERT INTO cubNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Bʉcʉrejamed̶a Zacaríai mácʉ. Parʉriũme cʉrejamed̶a. Aru macarõi, põecʉbenoi, cʉrejamed̶a, ʉ̃i coyʉrĩ bʉijãravʉ baquinó eaiyeta Israel bácʉi pãramenare. ");
INSERT INTO cubNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Dinʉmʉre ʉ̃i jabod̶aimarare corevaicõjenejamed̶a César Augusto. ");
INSERT INTO cubNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","No mamarʉmʉ ne ãmiáre toivaicõjeinʉmʉre Siria ãmicʉrijoborõcavʉre cõjeipõecʉ barejámed̶a Cirenio. ");
INSERT INTO cubNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Que baru caivʉ corevaimara márajivʉ ne bʉcʉva bácavʉ ne cʉe báquei copaidejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aru José máre Galileacarõ ĩmaro, Nazaret ãmicʉriĩmaroi cʉcʉ bácʉ, Judea ãmicʉrõi nʉrejamed̶a ʉ̃. Noi nʉri, Belén ãmicʉriĩmaro, ʉ̃i ñecu mácʉi cʉrõ mácarõi earejamed̶a José, David bácʉi pãramecʉ. Que baru nʉrejamed̶a José noi. ");
INSERT INTO cubNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nʉri, jímarepaco bacod̶óre nʉvarejamed̶a José. Ne ãmiáre toivarĩ ĩ́cõjenanʉrejaimad̶a na. Aru dinʉmʉre micacota barejácod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Noi earĩ, cʉrĩ, jʉed̶ocʉvarejacod̶a María, ʉ̃mʉ jʉed̶ojĩcʉ, mama jʉed̶ocʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cuipõeva ne cãiñami buidíñami marejávʉ̃ya. Que baru ne cʉ́jʉrorõ eabeni, oteiãimara ne cʉriñami cʉrĩ, jʉed̶ocʉvarejacod̶a María. Jʉed̶ocʉvarĩ, mamacʉre pavaicajeaque cũmari, oteiãimara ne ãitõcui tʉorejacod̶a ʉ̃́re María, ʉ̃i cãquiyepe ad̶o. ");
INSERT INTO cubNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nore ovejavare coreipõeva cʉrejaimad̶a dáre ñami, ne oteiãimarare coreivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Cũiná, Jʉ̃menijicʉi daroimʉ, ángele, nore ẽmenejamed̶a ʉ̃ nára. Cojié nʉrejavʉ̃ya. Jʉ̃menijicʉi cojino pare cojidejavʉ̃ya. Nára pẽorejavʉ̃ya. Ãmei jidʉrejaimad̶a ina oteiãimarare coreipõeva. ");
INSERT INTO cubNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ʉbenita ñai ángele arejamed̶a náre: —Jidʉbejarã mʉja. Mʉjare yávaiye méne davayʉtamu yʉ. Mʉjare aru caivʉre mʉje torojʉrãjiyede davayʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Cari ñami David bácʉi cʉriĩmaro mácarõi põeteibi mʉje ãmeina téjʉroede mead̶acʉyʉ, Jʉ̃menijicʉi epeimʉ, Cristo, mʉje jabocʉ bacʉyʉ́. Jãvetamu. ");
INSERT INTO cubNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mʉjare ji coyʉimʉre noi earãjaramu mʉja, cũmaimʉre. Oteiãimara ne ãitõcui paraibi, arejamed̶a ñai ángele. ");
INSERT INTO cubNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Coyʉrĩ bʉojarĩ, obedivʉ Jʉ̃menijicʉi daroimara, ángeleva, járorejaimad̶a ñai ángeleque. Jʉ̃menijicʉre torojʉrĩ mearore jídejaimad̶a ina ángeleva. ");
INSERT INTO cubNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Mearore jínajarevʉ Jʉ̃menijicʉre, cavarõ mearocacʉre, caivʉ pʉeno parʉcʉre. Aru ijãravʉcavʉre, ijoborõcavʉre, Jʉ̃menijicʉre jʉ aivʉre, meaquiyebu, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Que arĩ bʉojarĩ, cavarõ mearo Jʉ̃menijicʉi cʉrõi copaidejaimad̶a ina ángeleva. Ne nʉriburu yóboita, ina oteiãimarare coreipõeva arejaimad̶a ne bajumia: —Jã́rica, Belẽ́i nʉri, Jʉ̃menijicʉi cari coyʉiyede jã́ranʉrajarevʉ, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Que arĩ, cũiná nʉrejaimad̶a. Nʉri pʉ Joséde aru Maríare earejaimad̶a na. Aru Maríai mácʉre máre, parayʉre, oteiãimara ne ãitõcui earejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Que teni jʉed̶ojĩcʉre jã́ri, Jʉ̃menijicʉi coyʉiye báquede náre coyʉrejaimad̶a ina oteiãimarare coreipõeva. ");
INSERT INTO cubNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne coyʉiyede jápiaivʉ bácavʉ cuecumari dápiarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Aru Maríacapũravʉ die caiyede jápiarĩ, me dápiarejacod̶a õi ũmei. ");
INSERT INTO cubNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Que teni ne cʉrõre copainʉrejaimad̶a ina oteiãimarare coreipõeva. Nópe ne jápiaiye báquepe, ñai ángele ʉ̃i coyʉiye báquepedeca, jã́rejaimad̶a na. Que baru torojʉrĩ arejaimad̶a ina oteiãimarare coreipõeva: —¡Mʉ, Jʉ̃menijicʉ, meacʉ bajutamu mʉ! are nʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho paijãravʉa ʉ̃i põeteniburu yóboi, sacerdotevare Maríai mácʉi cajede buraicõjenejaimad̶a, judíova ne d̶arĩ cõmajiyepe. Aru ãmidorejaimad̶a ʉ̃́re Jesús, yópe ñai ángele ʉ̃i coyʉiye báquepe Jesúi põetequiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","No yóboi náre d̶aiye jaʉéde nópe Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquepe Moisés bácʉre, ne meara marajiyépe ayʉ Jʉ̃menijicʉi jã́inore, Jesúi bʉcʉva, ʉ̃́re nʉvari, mʉri nʉrejaimad̶a Jerusalén ãmicʉriĩmaroi, jínajivʉ ʉ̃́re Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nópe d̶arĩ, d̶arejaimad̶a yópe Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i toivaicõjeiye báquepe: “Caivʉ ina ʉ̃mʉ jʉed̶ova népacore mamarʉmʉ põeteivʉ, Jʉ̃menijicʉi beoimara márajivʉbu. Que baru náre jíjarã Jʉ̃menijicʉre”. ");
INSERT INTO cubNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jʉ̃menijicʉi cʉ̃rami nʉrejaimad̶a. Aru míjinare jídejaimad̶a Jʉ̃menijicʉre, ne boarĩ́ juarãjiyepe aivʉ yópe Jʉ̃menijicʉi d̶aicõjeiyepe mamarʉmʉ põeteyʉ boje: “Pʉcarã jurevare o pʉcarã cõriájurevare jíjarã Jʉ̃menijicʉre”. ");
INSERT INTO cubNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Dinʉmʉre cũinácʉ ʉ̃mʉ cʉrejamed̶a Jerusalén ãmicʉriĩmaroi, ʉ̃i ãmiá Simeón. Ñai Simeón meacʉ barejámed̶a. Jʉ̃menijicʉre ʉrĩ, ʉ̃i d̶aicõjeiyepe d̶are nʉrejamed̶a cainʉmʉa. Napini coreni vore nʉrejamed̶a Israecavʉre cad̶atecʉyʉre. Aru ñai Espíritu Santo ʉ̃́que cʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ñai Espíritu Santo ʉ̃́re coreóvare d̶arejamed̶a yaibécʉyʉre jipocamia jã́mecʉva ñai Jʉ̃menijicʉi epeimʉ, Cristore. ");
INSERT INTO cubNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","Que baru ñai Espíritu Santo ecore d̶arejamed̶a ʉ̃́re Jʉ̃menijicʉi cʉ̃rami. Aru ina bʉcʉva ne nʉvaiyede diñami némacʉ Jesúre, ne d̶arãjiyepe ayʉ yópe Jʉ̃menijicʉi d̶aicõjeiyepe, ʉ̃́re dʉrʉrejamed̶a Simeón ʉ̃i ãmuveai. Aru torojʉrĩ mearore jíyʉ Jʉ̃menijicʉre arejamed̶a: ");
INSERT INTO cubNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Mʉ, ji jabocʉ, caride yʉ, mi põecʉ, yaiquíjivʉ cãrijimecʉva, yópe mi coyʉiye báquepe. ");
INSERT INTO cubNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jã́ivʉ yʉ ji baju ñai mi daroimʉ mácʉre, caivʉre mead̶aipõecʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mʉ daroivʉ ʉ̃́re caivʉ põeva ne meatenajiyepe ayʉ abujuvai jabocʉi parʉéde jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ʉ̃ macʉyʉ́me pẽoinope caivʉre ina põeva judíova ãmevʉre, ne majinajiyepe ayʉ Jʉ̃menijicʉre. Aru davacʉyʉme mearore mi põevare, Israecavʉre, arejamed̶a Simeón. ");
INSERT INTO cubNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Caiye iye ʉ̃i yávaiyede Jesúi borore jápiarĩ, Jesúi bʉcʉva cuecumari dápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aru Simeón torojʉrĩ mearore jíyʉ Jʉ̃menijicʉre náre boje, yópe arejamed̶a Maríare, Jesúi pacore: —Ñai jʉed̶ocʉ Jʉ̃menijicʉi epeimʉme. Obedivʉ Israecavʉ bíjarãjarama, ne ʉbe boje ʉ̃́re. Aru obedivʉ Israecavʉ mead̶aimara marajárama, ne ʉe boje ʉ̃́re. Ʉ̃ coreóvare d̶acʉyʉme obedivʉ põevare Jʉ̃menijicʉi dápiainore. Ʉbenita obedivʉ põeva ʉ̃́re jʉ abeni ʉbenajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Caiye iye põeva ne d̶arãjiye mímacʉre ñájine d̶aquiyebu mʉre yópe cũináve tãuve mi ũmene burarĩ cotʉvaiyepe. Que teni caivʉ majinajarama obedivʉ põeva ne dápiainore ne ũmei, arejamed̶a Simeón Maríare. ");
INSERT INTO cubNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aru diñamine máre cʉrejacod̶a cũináco Jʉ̃menijicʉi yávaiyede coyʉcaipõeco, õi ãmiá Ana, Fanuel bácʉi máco, Aser bácʉi yajubocaco. Pare bʉcʉco barejácod̶a õ. Bojʉyo cãreja, pʉrʉbʉod̶o báco siete paiʉjʉa cʉrejacod̶a jímarepacʉ bácʉque. ");
INSERT INTO cubNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Aru nomiópeco barejácod̶a õ ochenta y cuatro paiʉjʉaita cãreja. Jʉ̃menijicʉi cʉ̃ramine etabeni, nore cʉrĩ cainʉmʉa jíyo mearore Jʉ̃menijicʉre, ãmecova ãiyede jẽniarejacod̶a ʉ̃́re jãravʉre aru ñamine máre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Dinʉmʉmiareca Jesús yebai nʉri, jídejacod̶a mearore Jʉ̃menijicʉre. Aru Jesúi borore coyʉrejacod̶a caivʉ ina napini coreni vore cuivʉre Jʉ̃menijicʉi mead̶aquiyede Jerusalén ãmicʉriĩmarocavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jesúi bʉcʉva d̶aivʉ bácavʉ caiye iye Jʉ̃menijicʉi d̶aicõjeiyepe, copainʉrejaimad̶a Galileacarõ ĩmaro Nazaret ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Aru némacʉ me bʉcʉrejamed̶a. Parʉcʉ barejámed̶a. Ʉrarõ majidejamed̶a ʉ̃. Aru Jʉ̃menijicʉ me jã́rejamed̶a ʉ̃́re máre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ʉjʉá coapa Pascua ãmicʉrijãravʉre aru pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teinʉmʉre, Jesúi bʉcʉva mʉri nʉrejaimad̶a Jerusalén ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Que baru Jesúi cʉvaede doce paiʉjʉa nʉvarejaimad̶a ʉ̃́re noi, d̶arãjivʉ yópe ne d̶aiyepe ʉjʉá coapa. ");
INSERT INTO cubNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Torojʉve teniburu yóboi, obedivʉ ina põeva copainʉivʉ barejáimad̶a Jerusalén ãmicʉriĩmarore jocarĩ. Ʉbenita ñai jʉed̶ocʉ Jesús mautedejamed̶a noi. Aru ʉ̃i bʉcʉva coreóvabedejaimad̶a. Dápiarĩ arĩdurejaimad̶a ne baju yópe: ");
INSERT INTO cubNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Obedivʉ põeva mái nʉñama. Que baru Jesús nʉñʉme apevʉque”, arĩdurejaimad̶a na. Que dápiarĩ, nʉrejaimad̶a cũinájãravʉ baju. Aru yóboi vorĩdurejaimad̶a Jesúre névʉ jẽneboi. ");
INSERT INTO cubNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ʉbenita ʉ̃́re eabedejaimad̶a. Que baru Jerusalén ãmicʉriĩmaroi copaini vorãnʉrejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pare vore curejaimad̶a na. Yóbecʉrijãravʉa yóboita, ʉ̃́re earejaimad̶a Jʉ̃menijicʉi cʉ̃rami, dobacʉre bueipõeva majidivʉ jẽneboi. Náre jápiayʉ aru jẽniari jã́ñʉ marejámed̶a ʉ̃, Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Caivʉ ina jápiaivʉ ʉ̃́re pare dápiarejaimad̶a, ʉ̃i majié boje aru ʉ̃i yávaiye boje máre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ʉ̃i bʉcʉva jã́ivʉ ʉ̃́re noi, pare dápiarejaimad̶a. Que teni jípaco arejacod̶a ʉ̃́re: —Bʉcʉ, ¿aipe teni que d̶ayʉrʉ̃ ñʉjare? Jã́jacʉ, mipacʉ aru yʉ máre chĩori voivʉbu ñʉja mʉre, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús arejamed̶a náre: —¿Aipe teni vod̶arãrʉ yʉre? ¿Majibenarʉ mʉja jaʉrõre yʉre memecayʉre jipacʉre? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ʉbenita coreóvabedejaimad̶a na iye ʉ̃i aiyede náre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Náre yóvarĩ ẽmenejamed̶a Nazaret ãmicʉriĩmaroi. Aru náre jʉ arĩ, yópe ne ʉrõpe d̶ayʉ barejámed̶a. Jípaco caiye iyede me dápiarĩ, ãrʉrejacod̶a ʉ̃i yávaiye báquede aru ʉ̃i d̶aiye báquede máre. ");
INSERT INTO cubNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús me bʉcʉrejamed̶a ʉ̃i baju aru Jʉ̃menijicʉi majiéque máre. Jʉ̃menijicʉ aru põeva máre ʉ̃́que torojʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","No yóboi Roma ãmicʉrõ jaboteino jabocʉ cʉrejamed̶a, ʉ̃i ãmiá Tiberius César. Ʉ̃i jaboteiyede quince paiʉjʉa baju, Poncio Pilato jaboteyʉ barejámed̶a Judea ãmicʉrijoborõcavʉre. Aru Herodes jaboteyʉ barejámed̶a Galilea ãmicʉrijoborõcavʉre. Herodei yócʉ, Felipe, jaboteyʉ barejámed̶a Iturea aru Traconite ãmicʉrijoborõacavʉre. Aru Lisanias jaboteyʉ barejámed̶a Abilinia ãmicʉrijoborõcavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás aru Caifás máre sacerdotevare jaboteipõeva marejáimad̶a na. Dinʉmʉre Jʉ̃menijicʉ yávarejamed̶a Juan Bautistare, Zacarías bácʉi mácʉre, põecʉbenoi. Põeva vaivʉre coyʉre curejamed̶a nore. ");
INSERT INTO cubNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ʉ̃ nʉrejamed̶a caino Jordán ãmicʉriya jia yebai. Coyʉyʉ barejámed̶a põevare, ne Jʉ̃menijicʉre jã́d̶ovarajiyepe ayʉ ocoque, ne chĩori dápiarãjiyepe ayʉ ne ãmeina teiyede. Aru ne oatʉvarãjiyepe ayʉ ne d̶aiyede, “Jʉ̃menijicʉ ãrʉmetecʉyʉme” ayʉ barejámed̶a diede. ");
INSERT INTO cubNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yópe toivarejaquemavʉ javede ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ, ʉ̃i ãmiá Isaías: Jʉ̃menijicʉre coyʉcaipõecʉ cod̶oboboyʉre jápiarãjarama põecʉbenoi: “Mead̶ajarã mʉje ũmene copʉ etaburĩ maje jabocʉre, nopedeca mʉje mead̶aiyepe daimare, ñai ʉ̃mʉ, mʉje pued̶aimʉ, ʉ̃i daquiye jipocai. Que d̶arĩ dajocajarã mʉje ãmeina teiyede, Jʉ̃menijicʉi daroimʉ macʉyʉ́ ʉ̃i daquiye jipocai, Jʉ̃menijicʉi copʉ etaquiyepe ayʉ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Caino ẽmeino buiquíyebu. Aru caiye cʉ̃racũa jõd̶aquiyebu. Ma nurimema nuritequiyebu. Aru ma yaribema máre yaritequiyebu. Jabovare aru jabova ãmevʉre máre dajocarĩ ne ãmeina teiyede oatʉvaiye jaʉvʉ náre ñai Jʉ̃menijicʉi daroimʉ macʉyʉ́ ʉ̃i daquiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Caivʉ ijãravʉcavʉ jã́rajarama Jʉ̃menijicʉi daroquimʉre, põevare mead̶aipõecʉre”, arĩ toivarejaquemavʉ Isaías bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Obedivʉ põeva earejaimad̶a Juan Bautista yebai, ʉ̃i jã́d̶ovaquiyepe aivʉ náre Jʉ̃menijicʉque jiai. Ʉ̃i yebai eaivʉre, náre arejamed̶a: —¡Mʉja, jʉjovaivʉbu, mʉje d̶aiye boje mearape! ¡Aru ãd̶avape paivʉbu mʉja, mʉje ãmed̶aiye boje apevʉre! Jʉ̃menijicʉi jorojĩquijãravʉ edaiyede, jãve dupini bʉojabenamu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","D̶ajarã mʉja yópe põeva chĩoivʉ ne ãmeina teiyede, oatʉvaivʉ ne d̶aiyepe. Mʉje baju abejarã: “Majeñecu Abraham mácʉ barejaquémavʉ. Jʉ̃menijicʉ yóvarejaquemavʉ ʉ̃ mácʉre. Que baru meara bajutamu maja Jʉ̃menijicʉi jã́inore”, abejarã mʉja. Jãve coyʉyʉbu mʉjare: Jʉ̃menijicʉ bʉojaibi oatʉvayʉ cʉ̃raboare Abraham mácʉi pãramena márajivʉre d̶acʉyʉ, ne d̶arãjiyepe ayʉ yópe ʉ̃i ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yópe jiore memeipõecʉ ʉ̃i jã́iyede jocʉcʉa jẽidʉa mearʉa cʉbecʉre ʉ̃i jioi, ʉ̃i jarʉvajʉroepe dicʉáre toaboi, nopedeca Jʉ̃menijicʉ jã́ñʉ mʉjare mearo d̶abevʉre, jarʉvacʉyʉme mʉjare toabo cũiméboi, arejamed̶a Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Que teni ina obedivʉ põeva jẽniari jã́rejaimad̶a Juan Bautistare: —¿Aipe d̶arãjidi ñʉja? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan Bautista arejamed̶a náre: —Pʉcacajea cuitótecajea cʉvacʉ baru, jíjacʉ ñai cʉvabecʉre. Aru ãino cʉvacʉ baru máre, jíjacʉ ñai ãino cʉvabecʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ina jabovare tãutʉra ĩcaipõeva Juan Bautista yebai nʉrejaimad̶a, ʉ̃i jã́d̶ovaquiyepe aivʉ náre Jʉ̃menijicʉque jiai. Aru arejaimad̶a ʉ̃́re: —Mʉ, bueipõecʉ, ¿aipe d̶arãjidi ñʉja? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ʉ̃ arejamed̶a náre: —Ĩmejara pʉeno baju yo mʉje jabocʉi cõjeinore mʉjare. arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Apevʉ churarava máre jẽniari jã́rejaimad̶a ʉ̃́re: —¿Aipe d̶arãjidi ñʉja? arejaimad̶a. Ʉ̃ arejamed̶a náre: —Tatobejarã apevʉ ne cʉvaede. Boarĩ́ jarʉvaiyʉbejarã náre. Aru borocʉbejarã ʉbenina ne d̶abedeca, ne jínajiyepe aivʉ mʉjare tãutʉrare, mʉje borocʉbenajiyepe aivʉ. Torojʉjarã mʉje memeni cʉvae boje, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Obedivʉ põeva coreivʉ barejáimad̶a Jʉ̃menijicʉi epequimʉre. Que baru Juan Bautista ʉ̃i que aiye boje, caivʉ ina põeva dápiarĩ ne ũmei jẽniari jã́rejaimad̶a ne bajumia: “¿Cristo, Jʉ̃menijicʉi epeimʉ, márica ñai?” ");
INSERT INTO cubNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ʉbenita Juan Bautista arejamed̶a náre: —Yʉ jãve mʉjare jã́d̶ovaivʉ Jʉ̃menijicʉre ocoque, mʉje chĩori dápiaiye boje mʉje ãmeina teiyede. Ʉbenita dacʉyʉme ji yóboi cũinácʉ, ji pʉeno parʉcʉ. Ʉ̃ macʉyʉ́me jã́d̶ovañʉ mʉjare Jʉ̃menijicʉque Espíritu Santoque, ʉ̃i cʉquiyepe ayʉ mʉjaque aru ʉ̃i cad̶atequiyepe ayʉ mʉjare máre. Aru ʉ̃ macʉyʉ́me jã́d̶ovañʉ mʉjare Jʉ̃menijicʉque toaque máre, mʉje meara tenajiyepe ayʉ yópe põeva ne mead̶aiyepe tãure toaque, aru ʉ̃i ñájine d̶aquiyepe ayʉ mʉjare, meara tebedu. Que baru caivʉ pʉeno meacʉ bajube ʉ̃. Yʉ́capũravʉ pare ʉ̃i cãchinocacʉbu. Que baru ʉ̃́re cad̶ateni bʉojabevʉ yʉ. Pʉ oarĩ bʉojabevʉ yʉ duayʉ ʉ̃i cʉraidoa bʉoimeare. ");
INSERT INTO cubNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yópe oteiye memeipõecʉ ʉ̃i veoiyepe jaraboque, oteiyede epecʉyʉ ʉ̃i epeiñami jívʉi, aru oteiye cajeáre juacʉyʉ, nopedeca Jʉ̃menijicʉ ʉ̃́re jʉ aivʉre epecʉyʉme ʉ̃i jaboteinoi aru ʉ̃́re jʉ abevʉre jarʉvacʉyʉme toabo cũiméboi, arĩ buedejamed̶a Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nópe coyʉrejamed̶a Jʉ̃menijicʉi yávaiye méne mead̶aipõecʉre, darocʉyʉre ina põevare, náre mearo d̶aicõjeñʉ, ne ñájimenajiyepe ayʉ toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Aru Galilea ãmicʉrijoborõcavʉ ne jabocʉ Herodede jararejamed̶a Juan Bautista, ʉ̃i cʉvae boje ĩmacʉi márepacore, õi ãmiá Herodías, aru caiye ape ʉ̃i ãmeina teiye boje máre. ");
INSERT INTO cubNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ʉbenita Herodes Juan Bautistare jápiaiyʉbecʉ, jarʉvaicõjenejamed̶a ʉ̃́re ãmeina teivʉre jẽni jacoiñami. ");
INSERT INTO cubNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juan Bautista jã́d̶ovañʉ marejámed̶a Jʉ̃menijicʉque jiai caivʉ ina obedivʉ põevare. Aru Jesús máre nʉrejamed̶a ʉ̃i yebai, ʉ̃i jã́d̶ovaquiyepe ayʉ ʉ̃́re Jʉ̃menijicʉque jiai. Ʉ̃i jã́d̶ovariburu yóboi, Jesús jẽniañʉ marejámed̶a Jʉ̃menijicʉre. Dinʉmʉre cavarõ mearo Jʉ̃menijicʉi cʉrõ vorĩ nʉrejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Que teni jurecope Espíritu Santo ẽmeni darejamed̶a ʉ̃i pʉenora. Aru jápiarejaimad̶a apeno yávainore cavarõ mearo Jʉ̃menijicʉi cʉrõque aiyede yópe: “Mʉ, jímacʉ, ji ʉmʉ, me torojʉvʉ yʉ mʉre”, arejamed̶a Jesúre Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús treinta paiʉjʉa cʉvacʉ mamarʉmʉ bueni bʉ́rejamed̶a põevare. Ina marejáimad̶a Jesúi bʉcʉva: Põeva dápiarejaimad̶a ʉ̃́re Joséi mácʉpe. Aru José Elí bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Aru Elí bácʉ Matat bácʉi mácʉ barejaquémavʉ. Matat bácʉ Leví bácʉi mácʉ barejaquémavʉ. Leví bácʉ Melqui bácʉi mácʉ barejaquémavʉ. Melqui bácʉ Jana mácʉi mácʉ barejaquémavʉ. Jana mácʉ José bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Aru José bácʉ Matatías bácʉi mácʉ barejaquémavʉ. Matatías bácʉ Amós bácʉi mácʉ barejaquémavʉ. Amós bácʉ Nahúm mácʉi mácʉ barejaquémavʉ. Nahúm mácʉ Esli bácʉi mácʉ barejaquémavʉ. Esli bácʉ Nagai bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Aru Nagai bácʉ Maat bácʉi mácʉ barejaquémavʉ. Maat bácʉ Matatías bácʉi mácʉ barejaquémavʉ. Matatías bácʉ Semei mácʉi mácʉ barejaquémavʉ. Semei mácʉ Josec bácʉi mácʉ barejaquémavʉ. Josec bácʉ Judá bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Aru Judá bácʉ Joanán mácʉi mácʉ barejaquémavʉ. Joanán mácʉ Resa bácʉi mácʉ barejaquémavʉ. Resa bácʉ Zorobabel bácʉi mácʉ barejaquémavʉ. Zorobabel bácʉ Salatiel bácʉi mácʉ barejaquémavʉ. Salatiel bácʉ Neri bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Aru Neri bácʉ Melqui bácʉi mácʉ barejaquémavʉ. Melqui bácʉ Adi bácʉi mácʉ barejaquémavʉ. Adi bácʉ Cosam mácʉi mácʉ barejaquémavʉ. Cosam mácʉ Elmadam mácʉi mácʉ barejaquémavʉ. Elmadam mácʉ Er bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Aru Er bácʉ Josué bácʉi mácʉ barejaquémavʉ. Josué bácʉ Eliezer bácʉi mácʉ barejaquémavʉ. Eliezer bácʉ Jorim mácʉi mácʉ barejaquémavʉ. Jorim mácʉ Matat bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Aru Matat bácʉ Leví bácʉi mácʉ barejaquémavʉ. Leví bácʉ Simeón mácʉi mácʉ barejaquémavʉ. Simeón mácʉ Judá bácʉi mácʉ barejaquémavʉ. Judá bácʉ José bácʉi mácʉ barejaquémavʉ. José bácʉ Jonam mácʉi mácʉ barejaquémavʉ. Jonam mácʉ Eliaquim mácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Aru Eliaquim mácʉ Melea bácʉi mácʉ barejaquémavʉ. Melea bácʉ Mena mácʉi mácʉ barejaquémavʉ. Mena mácʉ Matata bácʉi mácʉ barejaquémavʉ. Matata bácʉ Natán mácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Aru Natán mácʉ David bácʉi mácʉ barejaquémavʉ. David bácʉ Isaí bácʉi mácʉ barejaquémavʉ. Isaí bácʉ Obed bácʉi mácʉ barejaquémavʉ. Obed bácʉ Booz bácʉi mácʉ barejaquémavʉ. Booz bácʉ Sala bácʉi mácʉ barejaquémavʉ. Sala bácʉ Naasón mácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aru Naasón mácʉ Aminadab bácʉi mácʉ barejaquémavʉ. Aminadab bácʉ Admin mácʉi mácʉ barejaquémavʉ. Admin mácʉ Arni mácʉi mácʉ barejaquémavʉ. Arni mácʉ Esrom mácʉi mácʉ barejaquémavʉ. Esrom mácʉ Fares bácʉi mácʉ barejaquémavʉ. Fares bácʉ Judá bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Aru Judá bácʉ Jacob bácʉi mácʉ barejaquémavʉ. Jacob bácʉ Isaac bácʉi mácʉ barejaquémavʉ. Isaac bácʉ Abraham mácʉi mácʉ barejaquémavʉ. Abraham mácʉ Taré bácʉi mácʉ barejaquémavʉ. Taré bácʉ Nacor bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Aru Nacor bácʉ Serug bácʉi mácʉ barejaquémavʉ. Serug bácʉ Ragau bácʉi mácʉ barejaquémavʉ. Ragau bácʉ Peleg bácʉi mácʉ barejaquémavʉ. Peleg bácʉ Heber bácʉi mácʉ barejaquémavʉ. Heber bácʉ Sala bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Aru Sala bácʉ Cainán mácʉi mácʉ barejaquémavʉ. Cainán mácʉ Arfaxad bácʉi mácʉ barejaquémavʉ. Arfaxad bácʉ Sem mácʉi mácʉ barejaquémavʉ. Sem mácʉ Noé mácʉi mácʉ barejaquémavʉ. Noé mácʉ Lamec bácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Aru Lamec bácʉ Matusalén mácʉi mácʉ barejaquémavʉ. Matusalén mácʉ Enoc, ñai yaibécʉ, ʉ̃i mácʉ barejaquémavʉ. Enoc Jared bácʉi mácʉ barejaquémavʉ. Jared bácʉ Mahalaleel bácʉi mácʉ barejaquémavʉ. Mahalaleel bácʉ Cainán mácʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Aru Cainán mácʉ Enós bácʉi mácʉ barejaquémavʉ. Enós bácʉ Set bácʉi mácʉ barejaquémavʉ. Set bácʉ Adán mácʉi mácʉ barejaquémavʉ. Aru Adán mácʉ Jʉ̃menijicʉi mácʉ barejaquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, Espíritu Santoi d̶aicõjeimʉ, copaidejamed̶a Jordán ãmicʉriya jiare jocarĩ. Ñai Espíritu Santo nʉvarejamed̶a ʉ̃́re põecʉbenoi. ");
INSERT INTO cubNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jesús cʉrejamed̶a nore cuarenta paijãravʉa. Yéde ãmenejamed̶a noi ʉ̃i cʉrijãravʉare. Aru abujuvai jabocʉ, Satanás ãmicʉcʉ, jʉjovaiyʉrĩdurejamed̶a ʉ̃́re. Que baru no yóboi ãvʉé ijidejavʉ̃ya ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Que baru ñai abujuvai jabocʉ arejamed̶a Jesúre: —Jãveneca Jʉ̃menijicʉi mácʉ baru, ãiye d̶ajacʉ ibo cʉ̃rabore, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús arejamed̶a ñai abujuvai jabocʉre: —Mi aiyepe d̶abevʉ yʉ. Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ yópe: “Põeva cʉbenama ne ãiye matʉiyeda. Quénora cʉrãjarama caiye Jʉ̃menijicʉi yávaiyeque máre”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Que arĩburu yóboi, ñai abujuvai jabocʉ nʉvarejamed̶a Jesúre cʉ̃racũ ʉ̃mʉjʉricũ pʉenoi. Jã́d̶ovarejamed̶a maumena caiye ijãravʉcarõa ĩmaroare. ");
INSERT INTO cubNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Aru arejamed̶a ʉ̃́re: —Yʉ jíquijivʉ mʉre ji jaboteinore aru caiye die cʉve méne máre, mi jabotequiyepe ayʉ diede ji parʉéque. Jíyebu caiye iye ijãravʉque. Que baru bʉojaivʉ jíyʉ ji ʉmʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jíquijivʉ mʉre caiye ijãravʉquede, mi ñʉatutarĩ mearore jídu yʉre, arejamed̶a ñai abujuvai jabocʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aru Jesúcapũravʉ arejamed̶a ʉ̃́re: —Mi aiyepe d̶abevʉ yʉ. Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ yópe: “Mearore jíjacʉ mi jabocʉ Jʉ̃menijicʉre aru cũinácʉra memecajacʉ ʉ̃i ʉrõpe”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Que teniburu yóboi, ñai abujuvai jabocʉcapũravʉ nʉvarejamed̶a Jesúre Jerusalén ãmicʉriĩmaroi. Ʉ̃́re mʉri nʉre d̶arejamed̶a Jʉ̃menijicʉi cʉ̃rami pʉenora. Aru arejamed̶a ʉ̃́re: —Jãve Jʉ̃menijicʉi mácʉ baru, tʉrĩ nʉjacʉ yore jocarĩ pʉ joborõita. ");
INSERT INTO cubNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ mi borore yópe: “Jʉ̃menijicʉ jarocʉyʉme ʉ̃i ángelevare, ne corenajiyepe ayʉ mʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jãmʉórajarama mʉre ne pʉrʉáque, mi ijié tebequiyepe aivʉ mi cʉbobare ibo cʉ̃raboque”, arĩ toivarejaquemavʉ. Que baru mi tʉrĩ nʉru, yʉ jã́ñʉ bʉojacʉyʉmu Jʉ̃menijicʉ d̶ayʉre yópe ʉ̃i aiye báquepedeca, arejamed̶a Jesúre ñai abujuvai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesúcapũravʉ arejamed̶a ʉ̃́re: —Mi aiyepe d̶abevʉ yʉ. Nopedeca Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque coyʉivʉ yópe: “Jʉjovabejacʉ mi jabocʉ Jʉ̃menijicʉre. Jã́d̶ovaicõjemejacʉ ʉ̃i parʉéde”, arĩ toivarejaquemavʉ. Que baru yéde d̶abevʉ yʉ, jã́d̶ovaicõjejʉrocʉ ʉ̃i parʉéde. Majivʉ yʉ parʉcʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nópe d̶arĩduyʉ ñai abujuvai jabocʉ jʉjovarĩ majibedejamed̶a Jesúre. Que baru nʉrejamed̶a Jesúre jocarĩ apenʉmʉita. ");
INSERT INTO cubNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús ʉ̃i copaiyede Galilea ãmicʉrijoborõi Espíritu Santoi d̶aicõjeiye parʉéde cʉvacʉ barejámed̶a. Aru põeva yávarejaimad̶a ʉ̃i borore caino ijoborõcarõi. ");
INSERT INTO cubNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús buedejamed̶a ne judíovai cójijiñamiai ĩmaroa coapa. Aru caivʉ torojʉrejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús nʉrejamed̶a Nazaret ãmicʉriĩmaroi, ʉ̃i bʉcʉiĩmaro mácarõi. Ecorejamed̶a judíovai cójijiñami ne jabʉóvaijãravʉ sábadoi, yópe ʉ̃i d̶aiyepe cainʉmʉa. Aru nacajari jã́ri borotedejamed̶a Jʉ̃menijicʉi yávaiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jídejaimad̶a ʉ̃́re Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ Isaías bácʉi toivaiye báquede. Aru voarĩ jã́ñʉ earejamed̶a yópe arĩ toivaino mácarõre: ");
INSERT INTO cubNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ji jabocʉ Jʉ̃menijicʉ ʉ̃i Espíritu cʉbi yʉ́que. Que baru ʉ̃i epeimʉmu yʉ, coyʉcʉyʉ ʉ̃i yávaiye méne ina cõmaje ãrojarivʉre. Daroibi yʉre, ji mead̶aquiyepe ayʉ ina chĩoivʉre ne ũmei. Aru coyʉicõjeimi yʉre, ji jod̶equiyepe ayʉ ina bʉoimarape paivʉre ne ãmeina teiye boje. Jã́re d̶acʉyʉmu ina jã́ri eabevʉre. Jod̶ede d̶acʉyʉmu ina ãmeina d̶aimarare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Coyʉcʉyʉmu ne coreóvaino eainore ne jabocʉi mead̶aquinore náre, jã́ri borotedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jã́ri boroteni bʉojarĩ, Jesús iye toivaiye báquede bieni, jídejamed̶a judíovai cójijiñami cad̶ateipõecʉre. Aru dobacʉnʉrejamed̶a, buecʉyʉ ina põevare. Que teiyede jã́rejaimad̶a ʉ̃́re pare caivʉ ina cʉrivʉ judíovai cójijiñami jívʉi. ");
INSERT INTO cubNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús yávarĩ bʉ́yʉ, arejamed̶a yópe: —Caride yʉ d̶ayʉbu mʉje jẽneboi yópe iye Isaías bácʉi toivaiye báquepe javede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Caivʉ coyʉrejaimad̶a mearo Jesúi borore. Aru pare dápiarejaimad̶a mearo ʉ̃i coyʉiyede jápiarĩ. Aru jẽniari jã́rejaimad̶a ne baju: —¿Joséi mácʉ ãmeni ñai? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Náre arejamed̶a Jesús: —Jãveneca arãjaramu mʉja yópe: “Mʉ, jʉoipõecʉ, jʉojacʉ mi bajuma, jã́d̶ovacʉyʉ põevare jʉorĩ majicʉre”. Aru arãjaramu mʉja yʉre: “Ñʉje jápiaiyede mi d̶aiye báquede Capernaui, nopedeca d̶ajacʉ yore, mi joborõ bajure”, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Aru yávare nʉrejamed̶a: —Jãve coyʉyʉbu mʉjare: Ácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ cʉbebi ne me copʉ etaimʉ ʉ̃i joborõre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Que baru jãve coyʉyʉbu mʉjare: Cʉrejaquemavʉ obedivʉ nomiópeva Israecavʉ bácavʉ Elíai cʉrijãravʉa báquede. (Ñai Elíare Jʉ̃menijicʉ nʉvarejaquemavʉ Paraíso ãmicʉrõi apʉcʉra.) Aru ocabedejaquemavʉ yóbecʉriʉjʉa corica baji. Que baru ãvʉéne ñájinejaquemavʉ caino joborõre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ʉbenita Elías cad̶atecʉnʉmenejaquemavʉ ina nomiópeva bácavʉ yebai. Quénora nʉrejaquemavʉ cũináco nomiópeco báco yebai, Sarepta ãmicʉriĩmaroi, Sidón ãmicʉriĩmaro joabenoi cʉco bácore. ");
INSERT INTO cubNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nopedeca cʉrejaquemavʉ obedivʉ pojeivʉ Israecavʉ bácavʉ Eliseo bácʉi cʉrijãravʉa báquede. Ʉbenita Eliseo bácʉ mead̶abedejaquemavʉ ina caivʉre. Cũinácʉrata mead̶arejaquemavʉ, Naamán ãmicʉcʉre, Siria ãmicʉrijoborõcacʉ bácʉre. Aru ina pʉcarã, ico nomiópeco báco aru Naamán mácʉ máre, judíova ãmenejaquemavʉ na, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ne jápiaiyede iye ʉ̃i coyʉiyede, caivʉ ina judíovai cójijiñami cʉrivʉ jorojĩnejaimad̶a pare Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nacajari jabʉborĩ nʉvarejaimad̶a Jesúre ĩmarore jocarĩ. Ʉ̃́re nʉvarejaimad̶a cʉ̃racũ pʉenoi, jarʉvarãjivʉ dicũ tʉ̃robʉ cãchinoi. ");
INSERT INTO cubNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ʉbenita Jesús vaicʉ́nʉrejamed̶a ne jẽneboi, náre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús ẽmeni nʉrejamed̶a Galileacarõ ĩmaroi, Capernaum ãmicʉriĩmaroi. Aru noi buedejamed̶a põevare judíovai jabʉóvaijãravʉ sábadoi. ");
INSERT INTO cubNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ina jápiaivʉ ʉ̃i bueiyede, torojʉrĩ cuecumarejaimad̶a ʉ̃i bueiyede, ʉ̃i yávaiye boje parʉéque. ");
INSERT INTO cubNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aru cʉrejamed̶a judíovai cójijiñami cũinácʉ ʉ̃mʉ, abujucʉ ʉ̃i ĩmamʉ. Cod̶oboborĩ arejamed̶a Jesúre: ");
INSERT INTO cubNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Mʉ, Jesús Nazarecacʉ, cãrijovamejacʉ ñʉjare. ¿Yéde ʉcʉrʉ̃ mʉ ñʉjaque? ¿Jarʉvacʉdayʉ dacʉrʉ̃ mʉ ñʉjare? Coreóvaivʉ yʉ mʉre. Jʉ̃menijicʉi mácʉ meacʉ bajubu mʉ, arĩ cod̶oboborejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ʉbenita Jesús bi aicõjenejamed̶a ʉ̃́re: —Mʉ, bída, etajacʉ ñai ʉ̃mʉre jocarĩ, arejamed̶a Jesús. Que baru ñai abujucʉ tʉre d̶arejamed̶a ʉ̃i ĩmamʉre joborõi ne jẽneboi. Etarejamed̶a ʉ̃́re jocarĩ, ãmeno d̶abecʉva ñai ʉ̃mʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Aru cuecumari jã́ivʉ ina põeva, arejaimad̶a ne baju: —Parʉéque yávaibi ñai ʉ̃mʉ. Ʉ̃i yávaiye parʉéque jarʉvaibi abujuvare. Aru etad̶ama ména, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Que baru yávarejaimad̶a Jesúi borore caino Galilea ãmicʉrijoborõi. ");
INSERT INTO cubNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Dinʉmʉ Jesús etarejamed̶a judíovai cójijiñamine jocarĩ. Aru ecorejamed̶a Simón Pedroi cʉ̃rami. Ico Simón Pedroi váco moimo marejácod̶a pare. Coyʉrejaimad̶a Jesúre õi borore. ");
INSERT INTO cubNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Que baru Jesús õi yebai nacachini, dajocaicõjenejamed̶a moinore ṍre jocarĩ. Maumejiena dajocarejavʉ̃ya moino ṍre. Dinʉmʉmia nacajari, ãiyede mead̶arĩ jídejacod̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Dinainumica ñamijie baji aviá ʉ̃i dorĩburu yóboi, jabʉóvaijãravʉ vaiyede, nʉvarejaimad̶a Jesús yebai obedivʉ ijimarare. Aru tʉorejamed̶a Jesús ʉ̃i pʉrʉque náre coapa. Que d̶arĩ mead̶arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Aru etarejaimad̶a ijimarare jocarĩ abujuva, cod̶oboborĩ arejaimad̶a Jesúre: —Mʉrecabu Jʉ̃menijicʉi mácʉ, arejaimad̶a Jesúre. Ʉbenita Jesús bi aicõjenejamed̶a náre, ne majié boje Jʉ̃menijicʉi daroimʉ mácʉ Cristore. ");
INSERT INTO cubNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Miad̶áe tʉiyede Jesús nʉrejamed̶a põecʉbenoi. Ʉbenita põeva vorĩ earejaimad̶a ʉ̃́re. Ʉ̃i yebai earĩ, jẽniarejaimad̶a ʉ̃́re, ʉ̃i nʉmequiyepe aivʉ náre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ʉbenita Jesús arejamed̶a náre: —Nʉiye jaʉvʉ yʉre, coyʉcʉyʉ apenoa ĩmaroare máre Jʉ̃menijicʉi jaboteiyede põevare. Que baru daivʉ yʉ, coyʉcʉdayʉ diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Que arĩ, coyʉre nʉrejamed̶a judíovai cójijiñamiai caino Galilea ãmicʉrijoborõi. ");
INSERT INTO cubNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Põeva obedivʉ nʉivʉ Jesús yebai, ʉ̃i cʉede macajitabʉ ʉrabʉ Genesaret ãmicʉrijitabʉ ẽcarʉi, pare copiporejaimad̶a ʉ̃́re, jápiaiyʉrivʉ Jʉ̃menijicʉi yávaiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús jã́rejamed̶a pʉcacũa jiad̶ocũare macajitabʉ ʉrabʉ ẽcarʉ yebai. Dicũái moa boaipõeva núrejaimad̶a dicũá yebai, joaivʉ ne pápicʉare. ");
INSERT INTO cubNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús jatuyʉ bácʉ cũinácũ jiad̶ocũi, Simón Pedro jicũi, jaroicõjenejamed̶a joajĩemaque ẽcarʉre jocarĩ. Aru dobacʉ dicũi, bueni bʉ́rejamed̶a ina obedivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yávarĩ bʉojayʉ bácʉ arejamed̶a Simón Pedrore: —Nʉvajacʉ mi jiad̶ocũre macajitabʉ ʉ̃mʉjʉrõ baji. Aru noi jaboájarã mʉje pápicʉare, moa boarã́jivʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón Pedro jʉ ayʉ, arejamed̶a Jesúre: —Mʉ, bueipõecʉ, caiñami memeniduvʉ ñʉja. Ʉbenita ye boabétevʉ. Ʉbenita mi cõjeiye boje, jaboáquijivʉ ji pápicʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Que teni d̶aivʉ bácavʉ yópe Jesúi coyʉiyepe, jẽnejaimad̶a obedivʉ moare. Cod̶edejaimad̶a ne pápicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Dinʉmʉ “Yareni dajarã”, arejaimad̶a ne yóvaimarare, apecũ jiad̶ocũcavʉre, ne cad̶atenaearãjiyepe aivʉ. Aru earĩ, buivárejaimad̶a caipʉcacũa jiad̶ocũare coicũa baju. ");
INSERT INTO cubNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yópe teiyede jã́ri, Simón Pedro ñʉatutarĩ Jesús yebai, arejamed̶a ʉ̃́re: —Mʉ, ji jabocʉ, nʉjacʉ yʉre jocarĩ, ji ãmeina teiye boje, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Que baru Simón Pedro aru ʉ̃́cavʉ máre cuecumarejaimad̶a, ʉrarõ ne moa boaiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Santiago aru Juan máre, Zebedeoi mára, Simón Pedroi yóvaimara marejáimad̶a. Cuecumarejaimad̶a na máre. Ʉbenita Jesús arejamed̶a Simón Pedrore: —Jidʉbejacʉ. Caride epequijivʉ mʉre, mi davaquiyepe põevare ji yebai yópe mi moare davaiyepe pápicʉque, ji mead̶aquiyepe náre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Que teni jiad̶ocũa eaiyede ẽcarʉi, dajocaivʉ bácavʉ caiyede nʉrejaimad̶a Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús ʉ̃i cʉede cũináro ĩmaroi, ʉ̃i yebai nʉrejamed̶a cũinácʉ pojeyʉ. Aru Jesúre jã́ri, ñʉatutarejamed̶a joborõi, pued̶acʉyʉ ʉ̃́re. Aru jẽniarejamed̶a: —Mʉ, ji jabocʉ, ʉcʉ baru, mead̶ajacʉ ji pojeiyede. Bʉojaivʉ mʉ mead̶ayʉ yʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Dinʉmʉre Jesús, ʉ̃i pʉrʉque jabióvarĩ tʉoyʉ, arejamed̶a ʉ̃́re: —Ʉvʉ yʉ. Caride meatejacʉ mʉ, arejamed̶a Jesús. Yópe ʉ̃i aiyede vaidéjavʉ̃ya ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús, coyʉicõjemecʉ apevʉre, arejamed̶a: —Cũiná nʉri, jã́d̶ovajacʉ sacerdotede. Aru jíjacʉ mi meateiye boje, yópe Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquepe Moisés bácʉre, põeva ne coreóvarãjiyepe ayʉ mi meateinore, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ʉbenita pʉeno baju coyʉivʉ barejáimad̶a Jesúi borore. Obedivʉ põeva cójijidejaimad̶a jápiaivʉ, aru ʉ̃́re mead̶aicõjeiyʉrivʉ náre ijiéde. ");
INSERT INTO cubNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Que baru ina obedivʉ cʉe boje, Jesús nʉrejamed̶a põecʉbenoi, jẽniacʉyʉ Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cũinájãravʉ Jesús ʉ̃i bueiyede põevare, dobarejaimad̶a noi fariseovacavʉ, ina Jʉ̃menijicʉi d̶aicõjeiyepe d̶aivʉ, aru Jʉ̃menijicʉi yávaiye báquede bueipõevacavʉ máre, eaivʉ bácavʉ cainoa ĩmaroa Galilea ãmicʉrõre, Judea ãmicʉrõre, aru Jerusalén ãmicʉriĩmarore jocarĩ máre. Jʉ̃menijicʉi parʉéde cʉrejamed̶a Jesús, mead̶acʉyʉ ijimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dinʉmʉ apevʉ ʉ̃mʉva nʉvarejaimad̶a ʉ̃i yebai cũinácʉ ʉ̃mʉ, nacajaiye majibecʉre, ʉ̃i parainoque. Ecoiyʉrejaimad̶a cʉ̃rami jívʉi Jesús yebai. ");
INSERT INTO cubNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ʉbenita eabedejaimad̶a ne ecorãjino, obedivʉ põeva cʉe boje. Que baru mʉri nʉri cʉ̃rami pʉenora, voarĩ diede, ẽmeóvarejaimad̶a ijimʉre ʉ̃i parainoque põeva jẽneboi Jesús yebai. ");
INSERT INTO cubNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Náre coreóvayʉ jʉ aivʉre, Jesús arejamed̶a ñai nacajaiye majibecʉre: —Mʉ, ji ʉmʉ, mi ãmeina teiyede jarʉvarĩ, ãrʉmeteivʉ yʉ diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dinʉmʉ ina Jʉ̃menijicʉi yávaiye báquede bueipõeva aru fariseova máre dápiarĩ bʉ́rejaimad̶a yópe: “¿Yécʉba ñai ʉ̃mʉ ãmeina yávayʉ Jʉ̃menijicʉre? Ñame bʉojabema jarʉvaivʉ ãmeina teiyede. Quénora cũinácʉrabe Jʉ̃menijicʉ bʉojarĩ jarʉvayʉ diede”, arĩ dápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aru Jesús, jã́ri coreóvarĩ ne baju ne dápiaiyede, arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—¿Aipe teni que arĩ dápiaivʉrʉ̃ mʉja? Maiyójabevʉ yópe aru apecʉre: “Mi ãmeina teiyede jarʉvarĩ, ãrʉmeteivʉ yʉ”, ji parʉéde jã́d̶ovame boje ji que coyʉiyede. Ʉbenita maiyójarõtamu nacajari cuicõjenu nacajaiye majibecʉre. Ʉ̃́re cure d̶ayʉ baru, jã́d̶ovaquijivʉ ji parʉéde. “Mi ãmeina teiyede jarʉvaivʉ”, ji aiyede, coreóvabevʉ mʉja Jʉ̃menijicʉi ãrʉmeteinore diede. Ʉbenita ñai cʉvacʉ Jʉ̃menijicʉi majié parʉéde, ʉ̃́rame yópe d̶arĩ jã́d̶ovaiye majicʉ. Quécʉra Jʉ̃menijicʉvacari mead̶arĩ majibi ijimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Que baru mʉje majinajiyepe ayʉ Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, yʉ, parʉéde cʉvacʉre ijãravʉre jarʉvacʉyʉ ãmeina teiyede, yópe d̶aquijivʉ yʉ, arejamed̶a Jesús. Dinʉmʉ arejamed̶a nacajaiye majibecʉre: —Yópe aivʉ yʉ mʉre: Nacajari, mi parainore ĩni, nʉjacʉ mi cʉ̃rami, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dinʉmʉma nacajari, ʉ̃i parainore ĩni, etarejamed̶a obedivʉ jẽneboi. Aru mearore jídejamed̶a Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Caivʉ ina põeva máre, pare dápiaivʉ, mearore jídejaimad̶a Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","No yóboi, Jesús etarĩ nʉñʉ jã́rejamed̶a cũinácʉ judíovacacʉ, Roma ãmicʉrõ jaboteino jabovare tãutʉra ĩcaipõecʉ, ʉ̃i ãmiá Leví, dobacʉre ne bojed̶ainoi. Aru arejamed̶a ʉ̃́re: —Dajacʉ yʉ́que, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Aru nacajari, dajocayʉ caiyede, nʉrejamed̶a Jesúque. ");
INSERT INTO cubNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Que teniburu yóboi, Leví torojʉve tedejamed̶a ãino ʉrarõque ʉ̃i cʉ̃rami, pued̶acʉyʉ Jesúre. Aru obedivʉ jabovare tãutʉra ĩcaipõeva aru apevʉ põeva máre dobarejaimad̶a Levíque aru Jesúque máre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ʉbenita Jʉ̃menijicʉi yávaiye báquede bueipõevacavʉ aru fariseovacavʉ máre ãmeina yávarĩ bʉ́rejaimad̶a Jesúi bueimarare. Arejaimad̶a: —¿Aipe teni ãri, ũcuri teivʉrʉ̃ mʉja ina jabovare tãutʉra ĩcaipõevaque aru ãmeno d̶aipõevaque máre? arejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús jʉ ayʉ, arejamed̶a náre: —Meara põevare jʉoipõecʉi cad̶ateiye jaʉbevʉ. Quénora ijimarare ʉ̃i cad̶ateiye jaʉvʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Dabedejacacʉ yʉ ijãravʉi, cutucʉyʉ mearare ne baju dápiainore. Quénora darejacacʉ yʉ, mead̶acʉyʉ ãmenare, ne chĩorajiyepe ayʉ ne ãmeina teiyede, Jʉ̃menijicʉi ãrʉmetequiyepe ayʉ diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Dinʉmʉre jẽniari jã́rejaimad̶a Jesúre ina fariseova: —¿Aipe teni Juan Bautistai bueimara aru ñʉje bueimara máre ãmevʉba ãiyede, ʉbenita mi bueimara ãmevʉ ãmema ãiyede? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús arejamed̶a náre: —Ina pʉrʉbʉoyʉ ʉ̃i cutuimara ne torojʉve tenajiyepe ayʉ ʉ̃i pʉrʉbʉoiyede, ye ãmevʉ ãmema ãiyede ʉ̃i cʉede cãreja náque. Nopedeca ji bueimara torojʉrivʉ ji cʉede náque, ãmevʉ ãmema ãiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ʉbenita ji mauva ne nʉvarajiyede yʉre, ji bueimara chĩoivʉ ãmenajarama ãiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jẽvari coyʉrejamed̶a náre: —Ñame bʉojabema buraivʉ cũinájeve cuitótecaje mamacajede, jẽorajivʉ cuitótecaje javecarõre. Nópe d̶aru, ãmed̶ajebu cuitótecaje mamarore. Aru mamajeve jẽmejebu cuitótecaje javecarõre. Quédeca ñame bʉojabema jʉ aivʉ ji bueiye mamaene aru javeque bueiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nopedeca bʉojabema yuaivʉ vino ʉ́yaicorore mamacorore ãimacaje curubʉ javecacurubʉque. Que d̶aru, cod̶eóvajebu dicurubʉre. Aru yurĩ bíjajebu dicoro. Bíjajebu dicurubʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ʉbenita ne yuaru vino ʉ́yaicorore mamacorore mamacurubʉque, bíjabejebu dicoro. Quédeca ñame bʉojabema d̶aivʉ yópe ji bueiye mamaepe, d̶are nʉivʉ baru yópe ne jave d̶aiye báquepe. ");
INSERT INTO cubNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aru ñai ũcuñʉ mácʉ icoro mamaboqueicorore ũcuiyʉbecʉ mamaene ajebu yópe: “Javequetamu me baju”. Nopedeca apevʉ põeva jápiaiyʉbevʉ Jʉ̃menijicʉi yávaiye mamaene, ne dápiaiye boje javeque yávaiye pʉeno me bajure, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Apejãravʉ, judíovai jabʉóvaijãravʉ sábadoi, Jesús ʉ̃i vaiyede oteiye cʉrõi, ʉ̃i bueimara diede jẽni, pʉrʉáque cõjʉñori, ãrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aru apevʉ fariseovacavʉ jẽniari jã́rejaimad̶a náre: —¿Aipe teni ãmeno d̶aivʉrʉ̃ mʉja, maja judíova maje d̶aicõjemenope, jabʉóvaijãravʉre? arejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ʉbenita Jesús, ʉ̃i dápiaiye boje ʉ̃i bueimara ãmeno d̶abevʉre, arejamed̶a náre: —¿Jãve ãrʉmetenarʉ mʉja yo David bácʉi d̶aino mácarõre ãvʉé ijiéde ʉ̃́re aru ʉ̃́que cʉrivʉre máre? ");
INSERT INTO cubNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ʉ̃ mácʉ ecorejaquemavʉ Jʉ̃menijicʉi cʉ̃rami. Aru ãrejaquemavʉ pã́ure, Jʉ̃menijicʉre jíye báquede ina sacerdoteva ne ãiyede, sacerdote ãmecʉ bácʉvacari. Aru jídejaquemavʉ ʉ̃́que cʉrivʉre máre, sacerdoteva ãmevʉ bácavʉreca. Ʉbenita Jʉ̃menijicʉ ñájine d̶abedejaquemavʉ na mácavʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Cojedeca Jesús arĩ buedejamed̶a: —Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, jabocʉbu yʉ. Que baru d̶aicõjeni bʉojaivʉ yʉ põevare ne d̶aiyede caijãravʉare aru jabʉóvaijãravʉare máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Apejãravʉi cojedeca, judíovai jabʉóvaijãravʉ sábadoi, Jesús ecorejamed̶a ne cójijiñami. Aru bueni bʉ́rejamed̶a põevare. Noi cʉrejamed̶a cũinácʉ ʉ̃mʉ, ãmuve meapũravʉcaãmuve jiacʉbecʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jʉ̃menijicʉi yávaiye báquede bueipõeva aru fariseova máre nore cʉrivʉ coreni jã́rejaimad̶a Jesúre. Jã́iyʉrivʉ barejáimad̶a mead̶ayʉre ʉ̃́re ne jabʉóvaijãravʉi, boro coyʉrĩ ad̶aiyʉrĩduivʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ʉbenita ʉ̃, majicʉ ne dápiaiyede, arejamed̶a ñai ʉ̃mʉ ãmuve jiacʉbecʉre: —Nacajari nújacʉ põeva jẽneboi, arejamed̶a Jesús. Jesús ʉ̃i que aiyede, ñai ʉ̃mʉ nacajari núrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dinʉmʉma Jesús arejamed̶a náre: —Jẽniari jã́quijivʉ cũináro mʉjare. ¿Yéde d̶aicõjeini Jʉ̃menijicʉ jabʉóvaijãravʉre, mearore o ãmenore; mead̶aru põevare o boarĩ́ jarʉvaru náre? arejamed̶a Jesús. Ʉbenita bi arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Que baru Jesús, jã́ñʉ ina cʉrivʉre ʉ̃i yebai, arejamed̶a ñai ʉ̃mʉ ãmuve jiacʉbecʉre: —Jabióvajacʉ mi ãmuvede, arejamed̶a Jesús. Ʉ̃i jabióvaiyede, meatedejavʉ̃ya ʉ̃i ãmuve. ");
INSERT INTO cubNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ʉbenita apevʉ, jorojĩni pare, jẽniari jã́rejaimad̶a ne bajumia: —¿Aipe d̶arãjidica maja ñaine? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cũinájãravʉ Jesús nʉrejamed̶a cʉ̃racũai, jẽniacʉñʉ. Aru noi jẽniarejamed̶a Jʉ̃menijicʉque caiñami. ");
INSERT INTO cubNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Miad̶áe tʉiyede órejarejamed̶a ʉ̃i bueimarare. Aru doce paivʉre beorĩ epedejamed̶a ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Na marejáimad̶a Simón, ʉ̃i ãmidoimʉ mácʉ Pedro; Andrés, Simón Pedroi yócʉ; Santiago, Juan, Felipe, Bartolomé, Mateo, Tomás; Santiago, Alfeoi mácʉ; Simón, ãmicʉcʉ Celote; Judas, Santiagoi mácʉ; aru Judas Iscariote. Ñai marejámed̶a jẽni jícʉyʉ Jesúre ʉ̃i mauvare. ");
INSERT INTO cubNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ẽmeñʉ mácʉ cʉ̃racũare jocarĩ, mautedejamed̶a dái ʉ̃i bueimaraque. Aru obedivʉ põeva cʉrejaimad̶a. Judea ãmicʉrijoborõcavʉ, Jerusalén ãmicʉriĩmarocavʉ, aru macajitabʉ ʉrabʉ ẽcarʉi ĩmarocavʉ máre: Tiro aru Sidón ãmicʉriĩmaroacavʉ máre cʉrejaimad̶a. Ina earejaimad̶a, jápiaiyʉrivʉ Jesúre aru ʉ̃i mead̶aquiyepe aivʉ náre ijiéde. ");
INSERT INTO cubNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ina abujuva ne ñájine d̶aimarare máre Jesús mead̶arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Caivʉ põeva tʉoiyʉrejaimad̶a Jesúre, ʉ̃i mead̶aiye boje ʉ̃i parʉéque. Aru mead̶arejamed̶a ina caivʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Dinʉmʉre Jesús, jã́ñʉ ʉ̃i bueimarare, arejamed̶a: —Mʉja cõmaje ãrojarivʉ, mʉjarecabu Jʉ̃menijicʉi jaboteimara. Que baru torojʉrãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mʉja ãvʉé yaivʉ caride, yapinajaramu. Que baru torojʉrãjaramu mʉja. Mʉja caride oivʉ yʉrinajaramu. Que baru torojʉrãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Torojʉrãjaramu mʉja põeva Jʉ̃menijicʉre jʉ abevʉ ne ãmeina jã́iye boje mʉjare aru ne jarʉvaiye boje mʉjare máre, mʉje yóvaiye boje yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe. Torojʉrãjaramu mʉja, põeva Jʉ̃menijicʉre jʉ abevʉ ne jaraiye boje mʉjare aru ne ʉbe boje mʉjare máre, mʉje yóvaiye boje yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe. ");
INSERT INTO cubNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Torojʉrãjaramu mʉja dijãravʉre. Aru cʉvarãjaramu mʉje boje ʉrarõ cavarõ mearo Jʉ̃menijicʉi cʉrõi. Nopedeca ãnina javecavʉ bácavʉ, mʉjeñecuva mácavʉ máre, ãmeina d̶arejaquemavʉ ãnina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Ʉbenita mʉja cʉve cʉvarivʉ ijãravʉre torojʉrĩ cʉvʉ mʉja. Que baru ãmeno ñájino cʉvarãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mʉja yapivʉ caride ãino ʉrarõque, ãmei ãvʉé yainájaramu mʉja. Que baru ãmeno ñájino cʉvarãjaramu mʉja. Mʉja yʉrivʉ caride chĩori orãjaramu mʉja. Que baru ãmeno ñájino cʉvarãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ãmeno ñájino cʉvarãjaramu mʉja, põeva ne me yávaiyede mʉjare. Nopedeca ãnina javecavʉ bácavʉ, mʉjeñecuva mácavʉ máre, me yávarejaquemavʉ ãnina borocʉrivʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõevape teniduivʉ bácavʉre, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesús, yópe arĩ, buedejamed̶a náre cojedeca: —Ʉbenita coyʉyʉbu mʉjare, jápiaivʉre ji coyʉiyede. Ʉjarã mʉje mauvare. Me d̶ajarã náre ina ãmeina jã́ivʉre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Torojʉrĩ mearore jíjarã náre ina ãmeina yávaivʉre mʉjare. Jẽniajara Jʉ̃menijicʉque ina borocʉrĩ yávaivʉre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Cũinácʉ põecʉ ʉ̃i pẽvaru mi cũinápũravʉcaviobʉre, copedini pẽvaicõjejacʉ apepũravʉre máre. Aru cũinácʉ põecʉ ʉ̃i ĩnu mi cuitótecaje pʉenocacajede, jíjacʉ mi camisare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Jíjacʉ caivʉre ne jẽniainore mʉre. Aru ne tatoru míyede, jẽniamejacʉ cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","D̶ajarã apevʉre yópe mʉje ʉepe d̶aivʉre mʉjaque. ");
INSERT INTO cubNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mʉje ʉru náre, ina ʉrivʉre mʉjare, Jʉ̃menijicʉ bojed̶abecʉbe põevare ne que d̶aiyede. Nopedeca ina ãmeina teivʉ máre ʉma ʉrivʉre náre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mʉje mearore d̶aru náre, ina mearore d̶aivʉre mʉjare, Jʉ̃menijicʉ bojed̶abecʉbe põevare ne que d̶aiyede. Nopedeca ina ãmeina teivʉ máre d̶ad̶ama nópe. ");
INSERT INTO cubNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mʉje jídu náre, ina jacopaiyovarãjivʉre mʉjare, Jʉ̃menijicʉ bojed̶abecʉbe põevare ne que d̶aiyede. Nopedeca ina ãmeina teivʉ máre jíyama apevʉ ãmeina teivʉre, ne jacopaiyovarãjiyepe aivʉ cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ʉbenita ʉjarã mʉje mauvare. Me d̶ajarã náre. Aru jíjarã jacopaiyovaiyede corebevʉva no boje. Nópe d̶aru, ʉrarõ meaquiyebu mʉje boje jẽino. Aru Jʉ̃menijicʉi mára marajáramu mʉja. Que baru ʉ̃ meacʉbe náque ina jíbevʉre mearore ʉ̃́re aru ina jíyʉbevʉre apevʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cõmaje ãroje jã́jara mʉja apevʉre, ñai majepacʉ Jʉ̃menijicʉ ʉ̃i cõmaje ãroje jã́iyepedeca, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús, yópe arĩ, buedejamed̶a náre cojedeca: —“Ãmenatamu” arĩ, ãmecorobejarã mʉja apevʉre. Mʉje nópe aru, majepacʉ Jʉ̃menijicʉ ãmecororĩ, “Ãmenatamu mʉja”, acʉyʉme mʉjare. Jarʉvabejarã mʉja apevʉre. Mʉje jarʉvabedu, Jʉ̃menijicʉ jarʉvabecʉbe mʉjare. Ãrʉmetejarã mʉja apevʉre ne ãmene. Mʉje ãrʉmetedu, Jʉ̃menijicʉ máre ãrʉmetecʉyʉme mʉje ãmeina teiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jíjarã mʉja apevʉre. Aru Jʉ̃menijicʉ jícʉyʉme mʉjare. Jícʉyʉme mʉje pʉeá buidípʉea, doaipʉea, aru jayuipʉeare. Nopedeca mʉje apevʉre jíyepedeca Jʉ̃menijicʉ jícʉyʉme mʉjare, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Aru yópe arĩ, jẽvari coyʉrejamed̶a Jesús: —Cũinácʉ jã́ri eabecʉ bʉojabebi nʉñʉ mái apecʉ jã́ri eabecʉque. Que baru caipʉcarã jã́ri eabevʉ baru tʉjebu na cobei. ");
INSERT INTO cubNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Bueimara ñame baju majibema ne bueipõecʉ pʉeno. Ʉbenita bueni bʉojaivʉ baru, ne bueipõecʉpe tenajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Me jã́ivʉbu mʉja mʉjecʉi docʉjĩe cʉrõre ʉ̃i yacorʉi. Ʉbenita jã́mevʉ mʉja mʉje ʉrarõ docʉcʉrõre mʉje yacorʉi. ");
INSERT INTO cubNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Aru jã́mevʉvacari mʉja ʉrarõ docʉcʉrõre mʉje yacorʉi, mʉjecʉre “¿Mi docʉjĩene ĩnaji mi cʉvaede mi yacorʉi?” arĩ bʉojabevʉ mʉja. ¡Jʉjovaivʉtamu mʉja! Mamarʉmʉ ĩjara mʉja mʉje ʉrarõ docʉcʉrõre mʉje yacorʉre. No yóboi, mearo jã́ivʉta, ĩjara mʉjecʉi docʉjĩene ʉ̃i cʉvaede ʉ̃i yacorʉi, arĩ buedejamed̶a náre Jesús. Yópe aiyʉrõtamu iye Jesúi aiye báque: Põecʉ ʉ̃i ʉrarõ ãmenore d̶aru, “Dajocajacʉ mi ãmeina teiyede” arĩ, coyʉiye jaʉbevʉ ʉ̃́re apecʉre, quĩ́jino ãmenore d̶ayʉre. Quénora mamarʉmʉ ñai ʉrarõ ãmenore d̶ayʉre dajocaiye jaʉvʉ ʉ̃i baju ãmeina teiyede cãreja. ");
INSERT INTO cubNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Cojedeca Jesús arĩ buedejamed̶a náre, ne majinajiyepe ayʉ aipe ãrojarivʉre põevare: —Cʉbevʉ jocʉcʉ meacʉ jẽiye ãmene jícʉ. Aru cʉbevʉ jocʉcʉ ãmecʉ jẽiye méne jícʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Que baru coreóvaivʉbu jocʉcʉare dicʉá jẽiyeque. Miuñʉa jẽmevʉ higo ãmicʉridʉare. Nopedeca jẽmevʉ ʉ́yai miuñʉara. ");
INSERT INTO cubNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ñai põecʉ meacʉ yávayʉbe méne, ʉ̃i ũmei mearo cʉe boje. Aru ñai põecʉ ãmecʉ yávayʉbe ãmene, ʉ̃i ũmei ãmeno cʉe boje. Que baru põecʉ yávaibi ʉ̃i jijecamuque ʉ̃́re cʉede ʉ̃i ũmei, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Cojedeca Jesús arĩ buedejamed̶a náre: —¿Aipe teni aivʉrʉ̃ yʉre “ñʉje jabocʉ”, ʉbenita d̶abevʉvacari ji coyʉiyede? ");
INSERT INTO cubNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Coyʉquijivʉ mʉjare ñamepe ãrojacʉre ñai yʉre darĩ jápiayʉre aru d̶ayʉre yópe ji coyʉiyepe. ");
INSERT INTO cubNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","D̶aibi yópe ñai põecʉ ʉ̃i d̶aiye báquepe ʉ̃i cʉ̃rami jãjaroi. Aru jia yaboiyede, oco eavʉ̃ya diñamine. Ʉbenita cújibeteavʉ̃ya diñami, jãjaro núe boje. ");
INSERT INTO cubNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ʉbenita ñai jápiayʉvacari yʉre, d̶abecʉ baru yópe ji coyʉiyepe, ñai põecʉ ʉ̃́pebe ñai d̶ayʉ bácʉpe ʉ̃i cʉ̃ramine jãjamenoi. Aru jia yaboiyede, oco eavʉ̃ya diñamine. Aru tʉavʉ̃ya diñami. Ʉrarõ mateávʉ̃ya diñami bíjaino, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús yávarĩ dajocayʉ bácʉ põevare, nʉrejamed̶a Capernaum ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Noi cʉrejamed̶a cien paivʉ churarava ne jabocʉ, cʉvacʉ ʉ̃i yebacacʉre pare ʉ̃i ʉmʉ. Ijimʉ baju barejámed̶a ñai yebacacʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ñai churaravai jabocʉ jápiayʉ bácʉ yávaivʉre Jesúi borore, jarorejamed̶a apevʉ judíova bʉcʉvare, ne órejarãjiyepe ayʉ Jesúre, ʉ̃i mead̶aquiyepe ayʉ ñai yebacacʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Jesús yebai eaivʉ, pare nʉicõjenejaimad̶a ʉ̃́re. Arejaimad̶a: —Ñai jabocʉ meacʉbe ʉ̃. Que baru mi cad̶ateiye jaʉvʉ ʉ̃́re, ʉ̃i ʉe boje maje cʉrijaborõre. Ʉ̃́vacari d̶aicõjeame cũinád̶ami maje cójijiñamiva, arejaimad̶a na Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Dinʉmʉmia Jesús nʉrejamed̶a náque. Ʉbenita joabenoi ne tʉvaiyede ʉ̃i cʉ̃rami yebai, ñai jabocʉ jarorejamed̶a ʉ̃i yóvaimarare, yópe arãnʉivʉ Jesúre: —Mʉ, ji jabocʉ, cãrijimejacʉ. Meacʉbu mʉ. Ʉbenita yʉ́capũravʉ ãmecʉtamu. Que baru darĩ ecobejacʉ ji cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bʉojarĩ vocʉnʉmetevʉ yʉ mʉre ji baju. Quénora coyʉjacʉ mi cõjeinore. Aru ji yebacacʉ meatecʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉrecabu cʉcʉ ne cõjeiyeque ina ji jabova. Aru cʉvavʉ churaravare, ji cõjeimarare. Nácacʉ cũinácʉre “Nʉjacʉ” ji arĩburu, nʉimi ʉ̃. Aru “Dajacʉ” ji arĩburu, daibi ʉ̃. Aru ji d̶aicõjenu apejĩene ji yebacacʉre, d̶aibi ʉ̃. Nópe aicõjemi ñʉjare daroyʉ, cien paivʉ churarava ne jabocʉ, arejamed̶a Jesúre ñai jabocʉi jaroimaracacʉ. Ʉ̃i que aiyede, “Ijiéde cõjeipõecʉbu mʉ” aiyʉcʉ barejaquémavʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Que ayʉre jápiarĩ, pare dápiarejamed̶a Jesús. Aru jã́ri ina põeva nʉivʉre ʉ̃i yóboi, arejamed̶a: —Jãve coyʉyʉbu mʉjare: Eabevʉ cãreja majacacʉre, Israecacʉre, me jʉ ayʉre yʉre yópe ñai churaravai jabocʉpe, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aru ne copaiyede jabovai cʉ̃rami, earejaimad̶a ñai yebacacʉre meacʉta. ");
INSERT INTO cubNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","No yóboi, Jesús nʉrejamed̶a Nain ãmicʉriĩmaroi. Ʉ̃́que nʉrejaimad̶a ʉ̃i bueimara aru apevʉ põeva máre, obedivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ʉ̃i eaiyede ĩmaro joabenoi, jã́rejamed̶a nʉvaivʉre yaiyʉ́ bácʉre, jarʉvarãnʉivʉ. Jípaco, nomiópeco caride, cũinácʉ õi mácʉ bácʉ barejámed̶a. Aru obedivʉ põeva diĩmarocavʉ yóvarejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús cõmaje ãroje jã́ri, arejamed̶a ṍre: —Obejaco, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Joabejĩnoi nʉri, icad̶ava paraicad̶ava, yaiyʉ́ bácʉi paraicad̶avare, tʉorejamed̶a Jesús ʉ̃i pʉrʉque. Ina nʉvaivʉ bácavʉ dicad̶avare mautedejaimad̶a. Dinʉmʉma Jesús arejamed̶a yaiyʉ́ bácʉre: —Mʉ, bojʉyo, coyʉyʉbu mʉre: Nacajajacʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Quénora ñai yaiyʉ́ bácʉ dobarĩ, yávarĩ bʉ́rejamed̶a. Aru Jesús jídejamed̶a ʉ̃́re jípacore. ");
INSERT INTO cubNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yópe d̶ayʉre jã́ivʉ, cuecumarejaimad̶a caivʉ. Aru torojʉrĩ, jívʉ mearore Jʉ̃menijicʉre arejaimad̶a: —Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ parʉcʉ edaibi maje jẽneboi. Jʉ̃menijicʉ daibi, cad̶atecʉdayʉ ʉ̃i põevare, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Que teni Jesúi boro earejavʉ̃ya caino Judea ãmicʉrijoborõi aru caiye cʉrõaquede máre. Jápiarejaimad̶a caivʉ Jesúi d̶aiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautistai bueimara, ʉ̃i yebai nʉri, coyʉrejaimad̶a ʉ̃́re caiye Jesúi d̶aiye báquede. Aru órejarejamed̶a Juan Bautista pʉcarã ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesús yebai jarorĩ, jẽniari jã́icõjenejamed̶a náre yópe: —¿Jãveneca mʉ́rʉ Juan Bautista “Ji yóboi dacʉyʉme apecʉ coyʉipõecʉ” arĩ, ʉ̃i buevacamʉ? ¿Ʉ̃i que arĩ buevacamʉ ãmenu, corenajidi ñʉja apecʉre? aicõjenejamed̶a náre Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ina daroimara, Jesús yebai earĩ, arejaimad̶a ʉ̃́re: —Juan Bautista darobi ñʉjare jẽniari jã́icõjeñʉ: “¿Jãveneca mʉ́rʉ Jʉ̃menijicʉi daroimʉ, ‘Ji yóboi dacʉyʉme apecʉ coyʉipõecʉ’ arĩ, ʉ̃i buevacamʉ? ¿Ʉ̃i que arĩ buevacamʉ ãmenu, corenajidi ñʉja apecʉre?” arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Aru dinʉmʉmareca Jesús mead̶are cuyʉ barejámed̶a obedivʉ põevare: ijimarare, ñájivʉre, aru abujuva ne ĩmamarare máre. Aru obedivʉ jã́ri eabevʉre cõmaje ãroje jã́ri mead̶arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Que teni Jesús jʉ ayʉ, arejamed̶a Juan Bautistai daroimarare: —Nʉri coyʉjarã Juan Bautistare mʉje jápiaiyede aru mʉje jã́iyede máre: Ina jã́ri eabevʉ bácavʉ jã́ri ead̶ama caride, aru ina cuiye majibevʉ bácavʉ cuyama caride. Ina pojeivʉ bácavʉ meama aru ina jápiabevʉ bácavʉ jápiad̶ama caride. Ina yaivʉ bácavʉ, nacovaimara yainore jarʉvarĩ, apʉma cojedeca caride. Aru cõmaje ãrojarivʉre coyʉyʉbu iye yávaiye méne, Jʉ̃menijicʉi mead̶aiyede põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Torojʉbi ñai jʉ arĩ dajocabecʉ yʉre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ina daroimara ne nʉriburu yóboi, Jesús Juan Bautistai borore yávarĩ bʉ́yʉ, arejamed̶a ina põevare: —Jãve jã́ranʉmeteavʉ̃ mʉja cõriáre ũmevʉ japuiyede põecʉbenoi. ");
INSERT INTO cubNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aru jãve jã́ranʉmeteavʉ̃ mʉja põecʉ cuitótecaje meacajede doyʉre máre põecʉbenoi. Majivʉ mʉja ina doivʉre cuitótecajea meacajeare cʉrivʉre torojʉve teni cainʉmʉa jabovai cʉ̃ramiai. ");
INSERT INTO cubNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Quénora jãve jã́ranʉavʉ mʉja cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉre. Jãve coyʉyʉbu mʉjare: Jã́quemavʉ mʉja Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ pʉeno meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan Bautistabe ñai Jʉ̃menijicʉi toivaicõjeimʉ mácʉ ʉ̃́re coyʉcaipõecʉ bácʉre: Jaroivʉ yʉre coyʉcaipõecʉre mi jipocai, ʉ̃i mead̶aquiyepe ayʉ põevare, ne copʉ etarãjiyepe ayʉ mʉre, nopedeca põeva ne mead̶aiyepe cuimare ñai ʉ̃mʉ, ne pued̶aimʉ, ʉ̃i daquiye jipocai, arĩ coyʉicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Jãve coyʉyʉbu mʉjare: Cʉbebi apecʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ meacʉ baju Juan Bautista pʉeno ina ijãravʉi põeteivʉ jẽneboi. Ʉbenita ñai ʉbeni cʉcʉ Jʉ̃menijicʉi jaboteinore Jʉ̃menijicʉi mearo d̶acaimʉme Juan Bautista pʉeno, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ʉ̃i que aiyede Juan Bautistai borore jápiarĩ, obedivʉ põeva aru ina jabovare tãutʉra ĩcaipõeva máre coreóvarejaimad̶a Jʉ̃menijicʉre jãve ayʉre. Que baru Juan Bautistare jã́d̶ovaicõjenejaimad̶a náre Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ʉbenita ina fariseova aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre ʉbedejaimad̶a Jʉ̃menijicʉi d̶aiyʉrõre náre boje. Que baru Juan Bautistare jã́d̶ovaicõjemenejaimad̶a náre Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Que teni Jesús arejamed̶a náre: —¿Yéque jẽvari coyʉji ina põeva ijãravʉcavʉre? ¿Aipe ãrojari na? ");
INSERT INTO cubNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Jʉed̶ova tãibʉi dobarivʉpebu, yajurãjivʉ nácavʉque. Aru yópe aivʉpebu: “Japuvʉ ñʉja yʉriainore. Ʉbenita upabetevʉ mʉja. Yʉriavʉ ñʉja chĩore d̶aiyede. Ʉbenita obetevʉ mʉja”. Aru nópe ijãravʉcavʉ máre cãrijiñama na. ");
INSERT INTO cubNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Que baru Juan Bautista ʉ̃i daiyede, ʉ̃ ãmeni aru ũcumeni teiyede, “Abujucʉre cʉvabi”, ʉ̃́ra ʉbenina aivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aru Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji daiyede, ãri aru ũcuri teiyede yópe caivʉ apevʉpe, “Ñai ʉ̃mʉ ʉrarõ ãri ʉ̃i vainí tʉiyeta, aru ʉrarõ ũcuri ʉ̃i pacoteiyeta, yóvaibi ãmenare aru jabovare tãutʉra ĩcaipõevare máre”, yʉrã ʉbenina aivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ʉbenita Jʉ̃menijicʉi majiéde põeva jã́d̶ama ʉ̃́re jʉ aivʉque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Cũinácʉ fariseovacacʉ cuturejamed̶a Jesúre, “Ãrevʉ” ayʉ, ʉ̃i cʉ̃rami. Aru Jesús jʉ arĩ, ecorĩ, dobarejamed̶a tʉoiva yebai. ");
INSERT INTO cubNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Aru cũináco nomió, diĩmarocaco, ãmeina teipõeco, majico Jesús dobacʉre ñai fariseoi cʉ̃rami, nʉvarejacod̶a cũinábʉ ʉ̃mʉjʉribʉ boribʉ mumijʉe cʉribʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Orĩ earejacod̶a Jesúi cʉboba yebai. Aru õi orique ẽnuvarejacod̶a ʉ̃i cʉbobare. Que teni popovarejacod̶a õi pod̶aque. Aru nuri ʉ̃i cʉbobare, õi pued̶aiye boje ʉ̃́re, yuarejacod̶a iye mumijʉede ʉ̃i cʉboba pʉenoi. ");
INSERT INTO cubNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Que teni ñai fariseo, Jesúre cutuyʉ bácʉ, “Ãrevʉ” arĩ ʉ̃́re, yópe teinore jã́ri, dápiarejamed̶a ʉ̃i baju: “Ñai ʉ̃mʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ baru, majijebu yéco põeco ico jẽni jã́d̶ore ʉ̃́re. Põeco ãmeina teipõecobe õ”, arĩ dápiarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Quénora Jesús arejamed̶a ñai fariseore: —Mʉ, Simón, apejĩno coyʉiyʉvʉ mʉre, arejamed̶a Jesús. Ñai fariseo jʉ arejamed̶a ʉ̃́re: —Mʉ, bueipõecʉ, coyʉjacʉ yʉre, arejamed̶a Simón. ");
INSERT INTO cubNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ʉ̃i nópe aiyede, Jesús yópe arĩ coyʉrejamed̶a ʉ̃́re: —Pʉcarã ʉ̃mʉva bojecʉbe d̶aquemavʉ tãutʉrare cũinácʉ tãutʉra jípõecʉre. Cũinácʉ bojecʉbe d̶aquemavʉ pʉcaʉjʉa memeiye bojede. Aru apecʉ bojecʉbe d̶aquemavʉ pʉcarã aviáva memeiye bojede. ");
INSERT INTO cubNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na yéque bʉojarĩ ne bojed̶abe boje, ñai tãutʉra jípõecʉ ãrʉmetequemavʉ ina pʉcarã ne bojecʉbe d̶aiyede. Coyʉjacʉ yʉre. ¿Ácʉ põecʉ ina pʉcarãcacʉ pʉeno baju ʉri ʉ̃́re? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aru Simón jʉ arejamed̶a: —Dápiaivʉ ʉcʉre pare ʉ̃́re ñai ʉ̃i ãrʉmeteimʉ mácʉ pʉeno bojecʉbe d̶ayʉre, arejamed̶a. Jesús arejamed̶a ʉ̃́re: —Jãve coyʉivʉ mʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús copedini, jã́ñʉ ico nomióre, arejamed̶a Simóre: —Jã́jacʉ ico nomióre. Ecovʉ yʉ mi cʉ̃rami, aru jíbetevʉ mʉ oco, joaquiye ji cʉbobare. Ʉbenita ico nomió ẽnuvaimico ji cʉbobare õi orique aru popovaibico õi pod̶aque. ");
INSERT INTO cubNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jacoyʉbetevʉ mʉ yʉre. Ʉbenita ico dajocabebico pued̶ad̶o yʉre, ji cʉbobare nuño. ");
INSERT INTO cubNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yuabetevʉ mʉ mumijʉeque ji jipobʉre. Ʉbenita õ yuarĩ mumijʉe d̶aibico ji cʉbobare. ");
INSERT INTO cubNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Que baru aivʉ yʉ, õi ãmeina teiye ʉrede Jʉ̃menijicʉi ãrʉmeteiye báque boje, ʉrarõ õi ʉrõre jã́d̶ovaimico õ. Ʉbenita ñai ʉ̃i ãmeina teiye obebeda Jʉ̃menijicʉi ãrʉmetedu, quĩ́jino ʉ̃i ʉrõre jã́d̶ovaimi ʉ̃, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aru arejamed̶a ico nomióre: —Mi ãmeina teiyede ãrʉmeteivʉ yʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ina Simói cutuimara, dobarivʉ ʉ̃́que, yávarĩ bʉ́rejaimad̶a ne bajumia: —¿Yécʉ bárica ñai ʉ̃mʉ ãmeina teiyede ãrʉmetede d̶ayʉ? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Aru Jesús arejamed̶a ico nomióre: —Mi jʉ aiye boje, meateivʉ mʉ. Que baru me nʉjaco cãrijimecova, arejamed̶a ṍre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","No yóboi, Jesús coyʉcʉnʉrejamed̶a ĩmaroai aru ĩmajinoa coapa, põeva ne majinajiyepe ayʉ Jʉ̃menijicʉi jaboteinoque borore. Aru ina doce paivʉ ʉ̃i bueimara yóvarejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Apevʉ nomiva máre yóvarejaimad̶a náre, Jesúi mead̶ainomiva mácavʉ. Apevʉre ina nomivare Jesús javei jaetovarejamed̶a abujuvare. Aru apevʉre javei mead̶arejamed̶a ʉ̃. Cũináco Magdala ãmicʉriĩmarocaco barejácod̶a, õi ãmiá María. Jipocamia Jesús jaetovarejamed̶a siete paivʉ abujuvare ṍre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apeco barejácod̶a, õi ãmiá Juana. Ñai jabocʉ Herodes ʉ̃i cʉ̃ramine coreipõecʉi márepaco barejácod̶a õ, ʉ̃i ãmiá Chuza. Aru apeco barejácod̶a, õi ãmiá Susana. Apevʉ obedivʉ nomiva, Jesúi mead̶ainomiva mácavʉ máre yóvarejaimad̶a ʉ̃́re. Ina nomiva Jesújãre jaʉéde jídejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Obedivʉ põeva cójijivʉ Jesús yebai ĩmaroa coapacavʉ. Que teni Jesús buedejamed̶a náre jã́ri dápiarĩ ne d̶arãjiyepe ainoque, yópe arĩ: ");
INSERT INTO cubNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Cũinácʉ oteipõecʉ otecʉnʉquemavʉ ʉ̃i oteiyede. Ʉ̃i oteiyede ape oteiye tʉquemavʉ ma ẽcarʉi. Aru ne cʉraiyede ina cuivʉ noi, míjina vʉivʉ darĩ, ãradaquemavʉ caiye iye oteiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ape oteiye tʉquemavʉ joborõ edubenoi cʉ̃raboa pʉenoi. Aru yóboi pĩarí etaquemavʉ. Ʉbenita yaiquémavʉ, no oco cʉbe boje. ");
INSERT INTO cubNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ape oteiye tʉquemavʉ miucʉa jẽneboi. Aru miucʉa bʉcʉrĩ chĩoiyede, jẽiye jẽmetequemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ape oteiye tʉquemavʉ mearo joborõi. Aru bʉcʉquemavʉ. Aru jẽquemavʉ jẽiñʉ cien paivʉa caiye oteiyabea coapa, arejamed̶a Jesús. Que yávayʉ bácʉ, Jesús pare bʉjino yávarĩ, arejamed̶a náre: —Me jápiajarã mʉja iye ji bueiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesúi bueimara jẽniari jã́rejaimad̶a ʉ̃́re: —¿Aipe teni bueyʉrʉ̃ mʉ jã́ri dápiarĩ ñʉje d̶arãjiyepe ayʉ mi coyʉiyeque? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Aru Jesús arejamed̶a náre: —Mʉjare coyʉrĩ majide d̶ayʉbu iye Jʉ̃menijicʉ ʉ̃i coyʉicõjeme máquede. Ʉ̃ jaboteibi mʉjare, ʉ̃i põevare. Ʉbenita ina apevʉ iyede majibevʉre quéda jã́ri dápiarĩ ne d̶arãjiyepe ayʉ bueyʉbu yʉ náre, jã́ivʉreca ne jã́ri majibenajiyepe ayʉ aipe aiyʉrõre ne jã́iyede, aru jápiaivʉreca ne jápiarĩ majibenajiyepe ayʉ aipe aiyʉrõre ne jápiaiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yópe arĩ, Jesús coyʉrejamed̶a ʉ̃i bueimarare: —Yo jã́ri dápiarĩ mʉje d̶arãjiyepe ayʉ ji aino yópe coyʉiyʉrõmu mʉjare: Iye oteiye Jʉ̃menijicʉi yávaiyepe paiyebu. ");
INSERT INTO cubNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aru inamu ma ẽcarʉi oteiye tʉrĩduiye báquepe paivʉ. Náre coyʉiyede Jʉ̃menijicʉi yávaiyede jápiad̶ama, ʉbenita coreóvarĩ eabevʉva. Que baru ne jápiarĩburu yóboi, ñai abujuvai jabocʉ darĩ, ãrʉmetede d̶aibi Jʉ̃menijicʉi yávaiye ne jápiaiye báquede, ne jʉ abeni majibenajiyepe ayʉ, meatebenajivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aru inamu joborõ edubenoi, cʉ̃raboa pʉenoi, oteiye tʉrĩduiye báquepe paivʉ. Jʉ̃menijicʉi yávaiyede jápiarĩ, torojʉma me. Ʉbenita Jʉ̃menijicʉi yávaiyede jʉ arĩduyama na. Que baru quĩ́jino yóboi, põeva ne cãrijovaru náre, ne jʉ aiye boje, maumena dajocad̶ama ne jʉ aiyede Jʉ̃menijicʉi yávaiyede. Que teni jʉ abema na. ");
INSERT INTO cubNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aru inamu miucʉa jẽneboi oteiye tʉrĩduiye báquepe paivʉ. Na máre jápiaivʉ Jʉ̃menijicʉi yávaiyede, ʉbenita cãrijiñama ijãravʉquede. Torojʉma tãutʉraque. Aru caiye iye ne torojʉve teiye ijãravʉque cojʉvʉ náre. Que baru Jʉ̃menijicʉ cad̶atebebi náre ʉ̃i yávaiyeque yópe ʉ̃i ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ʉbenita inamu mearo joborõi oteiye tʉiye báquepe paivʉ. Jʉ̃menijicʉi yávaiyede jápiaivʉ, jʉ ad̶ama jãve diede. Aru me ãrʉma dajocabevʉva. Que baru nárecabu d̶aivʉ Jʉ̃menijicʉi ʉrõpe cãrijimevʉva, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Cojedeca Jesús, yópe arĩ, buedejamed̶a náre: —Põecʉ cʉbebi pẽoibʉre pẽoriburu yóboi moañʉ dibʉre cõaiñʉque o ñóñʉ paraino cãchinoi. Quénora tʉoibi jocʉve pʉenora, pẽoquiyepe ayʉ caivʉ ecoivʉre nore. ");
INSERT INTO cubNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Que baru caiye yaveiye báque jároquiyebu. Aru dupióvaiye báquede máre jã́rajarama caivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Que baru me dápiajarã mʉje jápiaiyede ji bueiyede. Aru d̶ajarã yópe ji coyʉiyepe. Nopedeca ñai jápiayʉre Jʉ̃menijicʉi yávaiyede, Jʉ̃menijicʉ pʉeno baju ʉ̃i majiéque jícʉyʉme ʉ̃́re. Ʉbenita ñai jápiabecʉre Jʉ̃menijicʉi yávaiyede, iye ʉ̃i quĩ́jino majiéde dápiayʉ cʉvaede, Jʉ̃menijicʉ ʉ̃́re ĩcʉyʉme diede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Dinʉmʉre Jesúi paco aru ʉ̃i yóva earejaimad̶a ʉ̃i cʉrõi. Ʉbenita ʉ̃́re eabedejaimad̶a, obedivʉ põeva ne cʉe boje. ");
INSERT INTO cubNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Que baru apevʉ arejaimad̶a Jesúre: —Mipaco aru míyova máre jedevai núrivʉ, mʉre jã́radad̶ama, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ʉbenita Jesús arejamed̶a náre: —Caivʉ ina Jʉ̃menijicʉi yávaiyede jápiaivʉ aru Jʉ̃menijicʉi ʉrõpe d̶aivʉ, nárecabu jipacope pád̶o aru jíyovape paivʉ máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cũinájãravʉ Jesús, jatuyʉ jiad̶ocũi ʉ̃i bueimaraque, arejamed̶a náre: —Jã́rica, macajitabʉ ʉrabʉ apedʉvei nʉrevʉ, arejamed̶a náre. Que baru nʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ne jataiyede, Jesús cãrejamed̶a. Japurejavʉ̃ya ũmevʉ parʉrõ baju. Aru pãcaiboa ecorejavʉ̃ya jiad̶ocũre. Que baru dicũ buidéjavʉ̃ya. Pare jidojarejavʉ̃ya no. ");
INSERT INTO cubNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Que teni Jesús yebai nʉri, yópe arĩ, coedavarejaimad̶a ʉ̃́re: —¡Mʉ, bueipõecʉ, coivʉbu maja! ¡Bíjarãjivʉbu maja! arejaimad̶a na. Jesús coedarĩ, jararejamed̶a ũmevʉre. Iboá ʉraboa pãcaiboa bíjarejavʉ̃ya. Aru cãrijimene d̶arejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Que teni Jesús arejamed̶a ʉ̃i bueimarare: —¿Aipe teni “Jesús mead̶acʉyʉme ñʉjare”, abevʉrʉ̃ mʉja? arejamed̶a. Que aiyede, cuecumari ʉrarõ dápiarejaimad̶a. Aru arejaimad̶a ne bajumia: —¿Yécʉba ñai, yópe cõjeñʉ ũmevʉre aru macajitabʉre máre jʉ aimʉ? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesújã jatarejaimad̶a no macajitabʉ ʉrabʉre apedʉvei. Aru cʉrejaimad̶a na Gerasa ãmicʉrõcavʉ, Galilea ãmicʉrõ cõchinoi. ");
INSERT INTO cubNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús ʉ̃i maiyede jiad̶ocũre jocarĩ, copʉ nʉrejamed̶a cũinácʉ ĩmarocacʉ, abujuva ne ĩmamʉ. Joe baju cuitótecajede dobedejamed̶a. Aru cʉ̃rami cʉbedejamed̶a ʉ̃. Quénora põeva ne yaivʉ bácavʉre jarʉvainoi cʉcʉ barejámed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesúre jã́ri, ʉ̃i yebai nʉri, ñʉatutarĩ bʉjié cod̶oboborĩ, arejamed̶a: —Mʉ, Jesús, Jʉ̃menijicʉi mácʉ, caivʉ pʉeno parʉcʉi mácʉ, ¿yéde ʉcʉrʉ̃ yʉ́que? Jẽniaivʉ mʉre, ñájine d̶abejacʉ yʉre, arĩ cod̶oboborejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nópe arejamed̶a Jesús ʉ̃i etaicõjeiye báque boje jipocamia ina abujuvare ñai ʉ̃mʉre jocarĩ. Apenʉmʉa abujuva ʉ̃́re ĩmarejaimad̶a. Que baru nócavʉ ʉ̃́re coreni bʉorĩdurejaimad̶a tãumeaque, bʉoimeaque máre. Ʉbenita cobʉrʉrʉrĩ buravarejamed̶a dimeáre. Aru ina abujuva jarorejaimad̶a ʉ̃́re põecʉbenoi. ");
INSERT INTO cubNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Dinʉmʉre Jesús jẽniari jã́rejamed̶a ʉ̃́re: —¿Yécʉ ãmicʉcʉrʉ̃ mʉ? arejamed̶a. Jʉ arĩ arejamed̶a: —Obecʉ ãmicʉvʉ yʉ, arejamed̶a. Nópe arejamed̶a, obedivʉ abujuva ne ĩmae boje. ");
INSERT INTO cubNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ina abujuva pare jẽniarejaimad̶a, ʉ̃i jarobequiyepe aivʉ náre ʉ̃mʉjʉricobei, abujuva ne ñájinoi. ");
INSERT INTO cubNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Cʉrejaimad̶a noi cʉ̃racũ yebai obedivʉ oteivãriva, ãre cuivʉ. Aru jẽniarejaimad̶a ina abujuva Jesúre: —Jarojacʉ ñʉjare oteivãrivara, ñʉje corãjiyepe nára, arejaimad̶a. Dinʉmʉma, nʉicõjenejamed̶a náre Jesús: —Nʉjara, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Aru ina abujuva etarĩ, corejaimad̶a oteivãrivara. Cúyarĩ nʉri tʉrejaimad̶a cʉ̃racũ ẽmeinoi, macajitabʉ ʉrabʉi. Tʉrĩ corĩ bíjarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Aru ina oteivãriva mácavʉre coreipõeva cúyarĩ nʉrejaimad̶a, coyʉivʉ ʉraĩmaroai aru ĩmaro cʉrõvaquede máre. ");
INSERT INTO cubNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Que baru obedivʉ põeva “¿Aipe tenama?” arĩ, jã́ranʉrejaimad̶a. Nʉivʉ Jesús yebai, jã́rejaimad̶a ñai ʉ̃mʉ abujuva ne ñájine d̶aimʉ mácʉ dobacʉre, cuitótecajede doyʉre, meacʉre cari. Aru jidʉrejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Coyʉrejaimad̶a ina jã́ivʉ bácavʉ Jesúi mead̶aiye báquede ñai ʉ̃mʉ, abujuva ne ĩmamʉ mácʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Quénora “Nʉjacʉ”, arejaimad̶a Jesúre parʉrõque caivʉ Gerasa ãmicʉrõcavʉ, ne jidʉé boje. ");
INSERT INTO cubNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jiad̶ocũi jaturĩ, Jesús copainʉrejamed̶a. Ʉbenita ʉ̃i copaiquiye jipocamia ñai ʉ̃mʉ, abujuva ne ĩmamʉ mácʉ, jẽniarejamed̶a parʉrõreca cuiyʉcʉ ʉ̃́que. Ʉbenita Jesús yóvaicõjemecʉ arejamed̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Copainʉjacʉ mi cʉ̃rami. Aru coyʉjacʉ caiye iye ʉrarõ Jʉ̃menijicʉ ʉ̃i d̶aiyede mʉ́que, arejamed̶a Jesús. Nʉri, coyʉyʉ barejámed̶a caivʉ ĩmarocavʉre caiye iye Jesús ʉ̃i d̶aiye báquede ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús copaiyʉ bácʉre, obedivʉ põeva coreivʉ barejáimad̶a ʉ̃́re. Que baru cójijidejaimad̶a ʉ̃i yebai, ʉ̃́re jacoyʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aru earejamed̶a cũinácʉ judíovai cójijiñamine coreipõecʉ, Jairo ãmicʉcʉ. Jã́rina ñʉatutarejamed̶a Jesúi cʉboba yebai. Ʉrarõreca jẽniañʉ arejamed̶a Jesúre: —Mʉ, bueipõecʉ, dajacʉ ji cʉ̃rami, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cũinácova ʉ̃i máco, doce paiʉjʉa cʉvacore, cʉvarejamed̶a Jairo. Aru yaidé nʉño marejácod̶a õ. Que baru Jesús nʉrejamed̶a ʉ̃́que. Cujurejaimad̶a náre obedivʉ põeva. Aru cojivare nʉrejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ne jẽneboi cũináco nomió cʉrejacod̶a. Doce paiʉjʉa baju ijimo marejácod̶a jive yuiyeque. Aru põecʉ cʉbedejamed̶a jʉoiye majicʉ ṍre. ");
INSERT INTO cubNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nʉrejacod̶a ʉ̃i yóboi obedivʉ põeva jẽneboi. Aru jẽni jã́rejacod̶a ʉ̃i doicaje tʉrʉvarã. Cũiná õi jẽni jã́iyede, bíjarejavʉ̃ya õi jive yuino mácarõ. ");
INSERT INTO cubNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Dinʉmʉ Jesús arejamed̶a: —¿Ñame matedí yʉre jẽni jã́d̶o? arejamed̶a. Caivʉ “Yʉ ãmevʉ” ne aiyede, Pedro arejamed̶a: —¡Mʉ, bueipõecʉ, obedivʉ põeva cojivare daivʉbu mʉre! arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ʉbenita Jesús arejamed̶a: —Cũináco nomió jẽni jã́cobe yʉre. Que baru majivʉ yʉ. Ji baju ji majiéque mead̶aivʉ yʉ ṍre caride, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ʉ̃i que aiyede, ico nomió õi baju dupini majibe boje, bidini jidʉco, nʉri ñʉatutarejacod̶a ʉ̃i cʉboba yebai. Coyʉrejacod̶a caivʉ ina põeva ne jã́iyede õi jẽni jã́inore ʉ̃́re aru cũiná õi meateinore. ");
INSERT INTO cubNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aru Jesús arejamed̶a ṍre: —Mʉ, ji ʉmo, “Ʉ̃ mead̶aiye majibi yʉre”, arĩ dápiarebu mʉ. Que baru mi que arĩ dápiaiye boje, mead̶aivʉ mʉre. Ména nʉri cʉjaco mʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ʉ̃i boroteiyede ṍque, cũinácʉ ñai judíovai cójijiñamine coreipõecʉi cʉ̃ramicacʉ earĩ, arejamed̶a Jairore: —Javeta mímaco yaibíco õ. Quénora cãrijovamejacʉ bueipõecʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ʉbenita Jesús, jápiayʉ bácʉ ʉ̃i yávainore, arejamed̶a Jairore: —Jidʉbejacʉ mʉ. Quénora jʉ ajacʉ ji coyʉinore, aru meatecod̶ome õ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesús ʉ̃i eaiyede Jairoi cʉ̃rami, apevʉre ecoicõjemeni ʉ̃́que, nʉvarejamed̶a Pedrore, Jũare, Santiagore, aru ico jʉed̶oco bácoi pacʉre aru pacore máre. ");
INSERT INTO cubNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Caivʉ põeva nócavʉ ṍre oivʉ aru cõmaje ãroje jã́ivʉ barejáimad̶a. Ʉbenita Jesús arejamed̶a: —Obejarã. Õ yaiyó ãmemico. Quénora cãd̶otame, arejamed̶a. Náre nópe arejamed̶a Jesús, ʉ̃i majié boje ʉ̃i nacovaquinore ṍre yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ʉ̃i que aiyede, yʉridejaimad̶a ʉ̃́re, ne majié boje yaiyó bácore. ");
INSERT INTO cubNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Dinʉmʉ Jesús ecorejamed̶a jʉed̶oco bácoi cʉritucubʉi aru õi pʉrʉre jẽni, bʉjié yávarejamed̶a ṍre: —Mʉ, jʉed̶oco, nacajajaco, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Aru ũmedarejacod̶a õ. Que baru cũiná nacajarejacod̶a. Aru, “Ãiyede jíjarã ṍre”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Õi bʉcʉva cuecumari pare dápiarejaimad̶a. Ʉbenita Jesús apevʉre coyʉicõjemenejamed̶a náre iye ʉ̃i d̶aiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Órejarĩ ina doce paivʉ ʉ̃i bueimarare ʉ̃i yebai, Jesús jídejamed̶a ne parʉéva, ne jaetovarãjiyepe ayʉ abujuvare aru ne mead̶arãjiyepe ayʉ ijimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Aru jarorejamed̶a náre, ne coyʉrãjiyepe ayʉ Jʉ̃menijicʉi jaboteinoque yávaiye méne aru ne mead̶arãjiyepe ayʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús arejamed̶a náre: —Nʉvamejara mʉja apejĩene mʉje nʉinore. Tuturiteiyoava nʉvamejara, curubʉare máre, ãiyede máre, aru tãutʉrare máre. Nʉjara mʉje cuitótecaje doino cʉeda. ");
INSERT INTO cubNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ã́ri mʉja ecoivʉ ĩmaroi, cʉjarã cũinácʉ cʉ̃rami upacʉque pʉ dajocarĩ nʉivʉta nore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Apenoi ne copʉ etabedu mʉjare, aru ne jápiaiyʉbedu iye yávaiye méne, etarĩ nʉjara. Aru pʉpejarã jobore mʉjare jẽiyede mʉje cʉboba cãchinoi ne jã́iyede, ne jápiaiyʉbe boje. Que teni diĩmarocavʉ coreóvarãjarama jʉ abevʉre Jʉ̃menijicʉre aru mʉjare máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Que arĩburu yóboi, etarĩ nʉrejaimad̶a ĩmaroai aru ĩmajinoa coapa. Coyʉrejaimad̶a Jʉ̃menijicʉi yávaiye méne aru mead̶arejaimad̶a põevare caino. ");
INSERT INTO cubNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Dinʉmʉ ñai jabocʉ Herodes jápiarejamed̶a Jesúi borore, caiye ʉ̃i d̶aiyede. Aru cãrijinejamed̶a, põeva ne yávaiye boje. Apevʉ arejaimad̶a, “Juan Bautista bácʉ nacajacʉbe yainore jarʉvarĩ”. ");
INSERT INTO cubNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Apevʉ arejaimad̶a, “Elías járocʉbe cojedeca”. Aru apevʉ arejaimad̶a, “Cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ nacajacʉbe yainore jarʉvarĩ”. ");
INSERT INTO cubNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodecapũravʉ arejamed̶a: “Juan Bautista bácʉi jipobʉre buraicõjecacʉ yʉ. Que baru, ¿ñamema ñai ʉ̃i borore ji jápiaimʉ?” arejamed̶a. Aru pare jã́iyʉrejamed̶a Jesúre ñai jabocʉ Herodes. ");
INSERT INTO cubNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Dinʉmʉ Jesúi daroimara mácavʉ copainʉrejaimad̶a ʉ̃i yebai. Ʉ̃́re coyʉrejaimad̶a caino ne d̶aino mácarõre. Aru Jesús náre nʉvaridurejamed̶a põevare jocarĩ cũináĩmaro joabenoi, Betsaida ãmicʉrõi. ");
INSERT INTO cubNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ʉbenita náre nʉivʉre majidejaimad̶a põeva obedivʉ. Aru Jesújãre cujurejaimad̶a na. Jesúcapũravʉ torojʉcʉ jacoyʉrejamed̶a náre. Coyʉrejamed̶a Jʉ̃menijicʉi jaboteinoque yávaiyede. Aru mead̶arejamed̶a nácavʉ ijimarare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aru nainú tʉvaino marejávʉ̃ya. Que baru coyʉrãearejaimad̶a ina doce paivʉ ʉ̃i bueimara. Arejaimad̶a ʉ̃́re: —Põecʉbenotamu yo. Que baru nʉicõjejacʉ ina põevare, ne vorãjiyepe ayʉ ne jabʉóvarãjiyede aru ne bojed̶arãjiyepe ayʉ ne ãrajiyede ĩmaro joabenoi aru no cʉrõvaquei, arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ʉbenita Jesús arejamed̶a náre: —Mʉja náre ãiyede jíjarã, arejamed̶a. Na arejaimad̶a ʉ̃́re: —Pã́uboa cũinápʉrʉpe paiboa aru moa pʉcarã quénora cʉvavʉ ñʉja. ¿Ñʉja bojed̶acarãnʉrajidi ãiyede, jínajivʉ caivʉ ina põevare? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Aru nácavʉ ʉ̃mʉva cũinápʉrʉpe paimil baju barejáimad̶a na. Jesús arejamed̶a ʉ̃i bueimarare: —Dobaicõjejara mʉja ina põevare yajuboa teni, cainimea teni, cincuenta paivʉ cʉriyajuboa, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ʉ̃i aiye báquepedeca d̶arejaimad̶a na. Que teni dobaicõjenejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aru die pã́uboa cũinápʉrʉpe paiboa aru moa pʉcarãre jẽni, cavarõi jã́ñʉ, torojʉede jídejamed̶a Jʉ̃menijicʉre. Torojʉede jíni bʉojarĩ, pã́uboare aru moare máre cotʉvarĩ jebeni, põevare jícõjenejamed̶a Jesús ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aru caivʉ ãri yapidejaimad̶a na. Ãri bubarĩburu yóboi, iye cotʉvaiye báque pã́u aru moa máre põeva ne ãri oabede ĩni, mead̶arĩ, pʉebʉa doce paibʉare, judíova ne pʉebʉare, buivárejaimad̶a ʉ̃i bueimara cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesús coyʉyʉ barejámed̶a Jʉ̃menijicʉre cũinácʉva. Aru ʉ̃i bueimara cʉrejaimad̶a ʉ̃́que. Dinʉmʉre jẽniari jã́rejamed̶a náre yópe: —¿Aipe aidi põeva yʉre? ¿“Yécʉbebu”, aidi na? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Arejaimad̶a ʉ̃́re: —Apevʉ ad̶ama, “Juan Bautistabe”. Aru apevʉ ad̶ama, “Elíabe”. Aru apevʉ ad̶ama, “Cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ nacajañʉ mácʉbe”, ad̶ama mʉre, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aru Jesús jẽniari jã́rejamed̶a náre: —¿Ʉbenita aipe aivʉrʉ̃ mʉja yʉre? arejamed̶a Jesús. Pedro jʉ arejamed̶a ʉ̃́re: —Mʉ Jʉ̃menijicʉi daroimʉ mácʉbu. Ñʉjare jabotecʉyʉmu mʉ, arejamed̶a Pedro Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ʉbenita ʉ̃i borore apevʉre coyʉicõjemenejamed̶a náre, yópe arĩ: ");
INSERT INTO cubNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—Jaʉvʉ yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, ʉrarõ ji ñájiquino. Ina judíova bʉcʉva, aru sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre yʉre boarĩ́ jarʉvarãjarama. Aru yóbecʉrijãravʉa yóboi nacajacʉyʉmu yʉ yainore jarʉvarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Aru caivʉre arejamed̶a Jesús: —Ácʉ põecʉ daiyʉcʉ yʉ́que, dajocajacʉrĩ põeva ne mearo jã́iyede ʉ̃́re, cʉyebejacʉrĩ yʉre yóvaiyede, aru jidʉbejacʉrĩ ʉ̃i ñájiquiyede. Nópe d̶abecʉ baru, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ñai põecʉ ʉ̃i baju ʉrõpe d̶arĩ, mead̶aiyʉcʉ baru ʉ̃i bajure, coatecʉyʉme ʉ̃i bajure Jʉ̃menijicʉre jarʉvarĩ, yópe yaiyʉ́ bácʉpe ʉ̃i ũmei. Ʉbenita ñai põecʉ, “Ye baju ãmevʉ, ji yaidú Cristore boje” ayʉ, ʉ̃i baju ʉrõpe d̶abecʉva quénora ji ʉrõpe d̶arĩ, ʉ̃́recabe ji mead̶aquimʉ, cʉcʉyʉ Jʉ̃menijicʉque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ñai põecʉ cʉvacʉ baru caiye ijãravʉquede, ʉbenita bíjayʉ baru ʉ̃i ũmene, ñájicʉyʉme cainʉmʉa toabo cũiméboi. ");
INSERT INTO cubNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Aru ñai põecʉi cʉyedu yʉre aru ji yávaiyede máre, yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, máre cʉyeni dápiacʉyʉmu ʉ̃́re ji jã́d̶ovaiyede ji mearore, aru jipacʉ meacʉ baju ʉ̃i mearore, aru ina ángeleva meara ne mearore máre, ji daquijãravʉ baquinói. ");
INSERT INTO cubNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jãve coyʉyʉbu mʉjare: Apevʉ cʉrivʉ yui, ne yainájiye jipocai jã́rajarama Jʉ̃menijicʉi jaboteino cʉrõre, ji jaboteiyede põevare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocho paijãravʉa yóboi, Jesús nʉvarejamed̶a Pedrore, Jũare, aru Santiagore máre, jẽniarajivʉ Jʉ̃menijicʉque cʉ̃racũi. ");
INSERT INTO cubNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ʉ̃i jẽniaiyedeca, ʉ̃i jiva oatʉvarejavʉ̃ya. Aru ʉ̃i cuitótecaje boricaje pẽorejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pʉcarã ʉ̃mʉva járorejaimad̶a, boroteivʉ ʉ̃́que. Na marejáimad̶a Moisés aru Elías. ");
INSERT INTO cubNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Caino ne cʉrõ miad̶ári jajavʉ tedejavʉ̃ya. Borotedejaimad̶a Jesús ʉ̃i copaiquinore ijãravʉre jocarĩ aru ʉ̃́re vaiquínore máre Jerusalén ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro aru ʉ̃́cavʉ máre vʉocʉrivʉvacari, cãmenejaimad̶a. Quénora apʉrivʉ jã́rejaimad̶a Jesús meacʉ bajure aru náre máre, ina pʉcarã ʉ̃mʉva cʉrivʉre ʉ̃́que. ");
INSERT INTO cubNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moisés aru Elías ne dajocaiyede Jesúre, Pedro arejamed̶a: —Mʉ, bueipõecʉ, mearotamu ñʉje cʉru yui. Que baru d̶arãjivʉbu ñʉja yóbecʉriñamia cʉ̃ramia quĩ́jiñamia maquiyéde, cũinád̶ami maquinóre míñami, aru aped̶ãmi maquinóre Moiséde, aru aped̶ãmi maquinóre Elíare, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ʉbenita majibedejamed̶a ʉ̃i que ainore. Ʉ̃i coyʉiyedeca, ocopenibo ẽmeni taorejavʉ̃ya náre. Que baru jidʉrejaimad̶a pare. ");
INSERT INTO cubNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aru ocopenibo taoiyede náre, jápiarejaimad̶a apeno yávainore ocopeniboi etaiyede: “Ñaime jímacʉ, ji beoimʉ. Que baru jápiajarã ʉ̃́re”, arejamed̶a Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aru yávarĩburu yóboi, jã́rejaimad̶a Jesúre cũinácʉva. Ʉbenita ne jã́ino mácarõre bi arĩ coyʉbedejaimad̶a apevʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cõmiáijãravʉ, ẽmeivʉ bácavʉ dicũ cʉ̃racũre jocarĩ, obedivʉ põeva copʉ nʉrejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aru cũinácʉ põecʉ põeyajubo jẽneboi, yópe arĩ, cod̶oboborejamed̶a: —Mʉ, bueipõecʉ, jẽniaivʉ mʉre. Jã́jacʉ jímacʉre, cũinácʉra ji cʉvamʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Abujucʉ cainʉmʉa bidióvarĩ tʉre d̶ávabi ʉ̃́re joborõi. Ʉ̃́re ñájine d̶arĩ, cod̶obobore d̶ávabi. Aburi etavavʉ ʉ̃́re. Aru ñai abujucʉ dajocaiyʉbevabi ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yʉ jẽniariduvʉ mi bueimarare, ne jaetovarãjiyepe ayʉ ñai abujucʉre. Ʉbenita ñaine jaetovarĩ majibema na, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús arejamed̶a: —Mʉja, ijãravʉcavʉ, Jʉ̃menijicʉre jʉ abevʉ aru ãmeina teivʉ máre, ¿aipijãravʉa cʉquidi yʉ mʉjaque? ¿Aru aipijãravʉa ñájiquidi yʉ mʉjaque, mʉje jʉ arãjiyepe ayʉ ji coyʉiyede? Davajacʉ mímacʉre ji yebai, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Aru ñai jʉed̶ocʉ ʉ̃i eaiyedeca Jesús yebai, ñai abujucʉ bidióvarĩ tʉre d̶arejamed̶a ʉ̃́re. Ʉbenita Jesús jararĩ abujucʉre, jaetovarejamed̶a ʉ̃́re ñai jʉed̶ocʉre jocarĩ. Que d̶arĩ mead̶arejamed̶a ʉ̃́re. Aru jacopaiyovarejamed̶a jípacʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Aru caivʉ cuecumarejaimad̶a Jʉ̃menijicʉ ʉ̃i ʉrarõ parʉéde. Põeva ne ʉrarõ dápiaiyede caiye ʉ̃i d̶aiye báquede, Jesús arejamed̶a ʉ̃i bueimarare: ");
INSERT INTO cubNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Me jápiajarã caiye iye ji coyʉquiyede mʉjare. Ãrʉmetebejarã. Yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jẽni jínajivʉbu ji mauvare, Jesús arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jʉ̃menijicʉ jápiarĩ eaicõjemenejamed̶a náre iye Jesús ʉ̃i coyʉiyede. Que baru jápiarĩ coreóvabedejaimad̶a. Aru jidʉrivʉ jẽniari jã́iyʉbedejaimad̶a ʉ̃́re iye ʉ̃i coyʉino mácarõre náre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jesúi bueimara jararĩ bʉ́rejaimad̶a ne bajumia ñamene parʉcʉre ne jẽneboi apevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Ʉbenita Jesús coreóvayʉ bácʉ ne dápiaiyede ne ũmei, jẽnejamed̶a cũinácʉ jʉed̶ocʉre. Aru ʉ̃́re núvari ʉ̃i yebai, arejamed̶a náre: —Cũinácʉ põecʉ copʉ etayʉ baru ñai jʉed̶ocʉre ji ãmiái, ji cõjeiyepe, que d̶ayʉ nopedeca copʉ etaibi yʉre. Aru ñai copʉ etayʉ baru yʉre, copʉ etaibi ñai yʉre daroyʉre máre. Que baru ñai mʉjacacʉ parʉbecʉ caivʉ pʉeno, ñai cad̶ateiyʉcʉ apevʉre, ʉ̃́recabe jãve parʉcʉ Jʉ̃menijicʉi jã́inore. Põeva parʉrivʉbu, cad̶ateivʉ baru apevʉre Jʉ̃menijicʉi jã́inore. Ʉbenita ina jaboteiyʉrivʉ apevʉre, aru d̶aicõjeiyʉrivʉ náre máre, parʉbevʉbu Jʉ̃menijicʉi jã́inore, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan arejamed̶a Jesúre: —Mʉ, bueipõecʉ, jã́carã ñʉja cũinácʉ ʉ̃mʉ abujuvare jaetovayʉre mi ãmiái, mi parʉéque. Ʉbenita ñʉjaque ʉ̃i cʉbe boje, “D̶abejacʉ” acarã ñʉja ʉ̃́re, arejamed̶a Juan. ");
INSERT INTO cubNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ʉbenita Jesús arejamed̶a: —Ácʉ põecʉ maucʉvabecʉ baru majare, majacacʉbe ʉ̃. Que baru ʉ̃́re nópe aiye jaʉbeteavʉ̃ mʉjare, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Joabejĩno marejávʉ̃ya ʉ̃i mʉri nʉquijãravʉ baquinó cavarõ mearo Jʉ̃menijicʉi cʉrõita. Que baru Jesús, parʉéque dápiarĩ, bʉ́rejamed̶a ʉ̃i nʉiyede Jerusalén ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ʉ̃i jipocai jarorejamed̶a ʉ̃́re boro nʉvacaipõevare. Aru ina nʉri ecorejaimad̶a Samaria ãmicʉrijoborõcaĩmaroi. Noi Jesús ʉ̃i eaquinore mead̶arãnʉridurejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ʉbenita ina Samariacavʉ copʉ etaiyʉbedejaimad̶a Jesúre, ʉ̃i nʉiye boje Jerusalén ãmicʉriĩmaroita, ne ʉbe boje diĩmarocavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ʉ̃i bueimara pʉcarã, Santiago aru Juan, diede jã́ivʉ bácavʉ, jẽniari jã́rejaimad̶a Jesúre: —Mʉ, ñʉje jabocʉ, ¿jõd̶aicõjenajidi ñʉja toabore cavarõ mearo Jʉ̃menijicʉi cʉrõquede, ne ẽ́najiyepe aivʉ? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ʉbenita Jesús copedini jararejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aru nʉrejaimad̶a apeno ĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesújã mái nʉiyede, cũinácʉ ʉ̃mʉ arejamed̶a Jesúre: —Mʉ́que nʉquijivʉ yʉ caino mi nʉinoita, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Aru Jesús arejamed̶a ʉ̃́re: —Macayavimiva cʉvama ne cobeá. Aru míjina cʉvama ne juaiboa. Ʉbenita yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji cʉrõ cʉvabevʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aru apecʉre arejamed̶a: —Dajacʉ yʉ́que, arejamed̶a. Ʉbenita arejamed̶a Jesúre: —Mʉ, ji jabocʉ, mamarʉmʉre jarʉvaquijivʉ cãreja jipacʉre cʉ̃racobei, ʉ̃i yaiyede, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ʉbenita Jesúcapũravʉ arejamed̶a: —Ina yaivʉ bácavʉpe paivʉ, ne jápiabe boje Jʉ̃menijicʉi jaboteinoque yávaiyede, jarʉvajarãri ina yaivʉ bácavʉre. Ʉbenita mʉ́capũravʉ coyʉcʉnʉjacʉ Jʉ̃menijicʉi jaboteinoque yávaiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Aru apecʉ máre arejamed̶a Jesúre: —Mʉ, ji jabocʉ, mʉ́que nʉquijivʉ yʉ. Ʉbenita mamarʉmʉre, “Nʉñʉmu” aicõjejacʉ yʉre ji cʉ̃ramicavʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesúcapũravʉ arejamed̶a ʉ̃́re: —Põecʉ d̶aiyʉcʉ baru ji ʉrõre aru ʉ̃i baju ʉrõre máre, bʉojabebi memecayʉ yʉre. Põeva ʉ̃́pe paivʉre Jʉ̃menijicʉ jabotebecʉbe, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","No yóboi Jesús beorejamed̶a apevʉre setenta y dos paivʉre. Náre jarorejamed̶a ʉ̃i jipocai pʉcarã matʉiyeda cainoa ĩmaroai ʉ̃i nʉquinoai. ");
INSERT INTO cubNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Aru jaroyʉ, arejamed̶a náre: —Obedivʉ põeva cʉrivʉ, Jʉ̃menijicʉi yávaiye méne majibema na cãreja, mʉje buenajimara iye yávaiye méne, Jʉ̃menijicʉi mead̶arãjiyepe aivʉ náre, ne jʉ aiyede diede. Ʉbenita obebevʉbu memecaivʉ Jʉ̃menijicʉre. Que baru jẽniajara ʉ̃́re, ʉ̃i daroquiyepe aivʉ apevʉ buenajivʉre ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nʉri jã́jara mʉja. Jaroivʉ mʉjare ijãravʉcavʉ jẽneboi yópe ovejavai nʉiyepe ãimara jijecʉrivʉ jẽneboi. ");
INSERT INTO cubNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nʉvamejara mʉja tãutʉrare, curubʉare, aru cʉraidoare máre. Borotede númejara mʉje mái copʉimaraque. ");
INSERT INTO cubNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ã́ri mʉja ecoivʉ cũinád̶ami cʉ̃ramine, mamarʉmʉ ajarã yópe: “Iñamicavʉ, mearo cʉjarã mʉja”. ");
INSERT INTO cubNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aru diñamicavʉ mearoque ne cʉru, nópe ajarã náre. Ʉbenita mearoque ne cʉbedu, “Mearo cʉjarã mʉja”, abejarã náre. ");
INSERT INTO cubNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cʉjarã cũinád̶amima. Que teni ãri aru ũcuri tejarã ne jíyede mʉjare, mʉje náre cad̶ateiye boje. Mʉja memecaivʉpebu. Aru memecaipõecʉre bojed̶aiye jaʉvʉ ʉ̃i memeinore. Ʉbenita nʉmejara cʉ̃ramia coapa. ");
INSERT INTO cubNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Ecoivʉ baru mʉja ĩmaroi, aru ina ĩmarocavʉ ne copʉ etaru mʉjare me, ãjara apejĩene ne jíyede mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mead̶ajarã ijimarare. Aru coyʉjarã náre yópe: “Jʉ̃menijicʉ jabotecʉyʉme põevare maumejiena”. ");
INSERT INTO cubNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ʉbenita ecoivʉ baru mʉja ĩmaroi, ne copʉ etabenoi mʉjare diĩmarocavʉ põeva, cuimai nʉri, ajarã yópe: ");
INSERT INTO cubNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mʉje jobore ñʉjare jẽiyede ñʉje cʉboba cãchinoi pʉpeivʉbu ñʉja, mʉje copʉ etabe boje aru mʉje jápiabe boje ñʉjare. Ʉbenita majijarã iyede: Jʉ̃menijicʉ jabotecʉyʉme põevare maumejiena”, ajarã. ");
INSERT INTO cubNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Coyʉyʉbu mʉjare: Ina Sodomacavʉ bácavʉ pare ãmeina tedejaimad̶a. Ʉbenita diĩmarocavʉ, mʉjare copʉ etabevʉ bácavʉ, ñájinajarama ina Sodomacavʉ bácavʉ pʉeno baju Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesús arejamed̶a cojedeca: —¡Mʉja, judíova, Corazĩ́cavʉ, ãmeno ñájinajaramu mʉja! ¡Mʉja, judíova, Betsaidacavʉ máre, ãmeno ñájinajaramu mʉja! Põecʉ ʉ̃i d̶aru põeva ne d̶arĩ majibede yópe ji d̶aiyepe mʉje jã́iyede Tirocavʉ aru Sidṍcavʉ máre ne jã́iyede, jave chĩori ne ãmeina teiyede, oatʉvajebu ne d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ʉbenita mʉja ñájinajaramu Tirocavʉ aru Sidṍcavʉ pʉeno baju, Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aru mʉja, judíova, Capernaucavʉ, jãve nʉmenajaramu mʉja cavarõ mearo Jʉ̃menijicʉi cʉrõi. Quénora mʉja nʉrajaramu toabo cũiméboi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús arejamed̶a ʉ̃i bueimarare cojedeca: —Ñai põecʉ jápiayʉ baru mʉjare, jápiaibi yʉre máre. Ñai põecʉ ʉbecʉ baru mʉjare, ʉbebi yʉre máre. Aru ñai põecʉ ʉbecʉ baru yʉre, ʉbebi ñai yʉre daroyʉ bácʉ, Jʉ̃menijicʉre máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ina setenta y dos paivʉ, Jesúi jaroimara mácavʉ, copaidejaimad̶a torojʉrivʉ Jesús yebai. Aru yópe arejaimad̶a ʉ̃́re: —¡Mʉ, ñʉje jabocʉ, abujuva máre jʉ ama ñʉje cõjeiyede náre mi ãmiái, mi parʉéque! arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Aru Jesús arejamed̶a náre: —Jã́vʉ yʉ ñai abujuvai jabocʉre, ʉ̃i ãmiá Satanás, tʉyʉre cavarõre jocarĩ yópe yaroino tʉiyepe. ");
INSERT INTO cubNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mʉjare parʉre d̶aivʉ yʉ, mʉje jã́ru ãd̶avare aru murivare máre, mʉje cʉrarãjiyepe ayʉ náre. Aru mʉja parʉrivʉtamu ñai mʉje maucʉ, abujucʉ pʉeno. Que baru ãmeno d̶abenama mʉjare ãd̶ava aru muriva máre. ");
INSERT INTO cubNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ʉbenita mʉja, torojʉrivʉ ina abujuva ne jʉ aiye boje mʉjare, pʉeno baju torojʉjarã mʉje ãmiá toivaino cʉe boje cavarõ mearo Jʉ̃menijicʉi cʉrõi. Que baru mʉja cʉvarãjaramu jãravʉ cũiméjãravʉ baquinóre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dinʉmʉmiareca Jesús, torojʉrĩ ʉ̃i ũmei Espíritu Santoi parʉéque, yópe arĩ, coyʉrejamed̶a Jʉ̃menijicʉre: —Mʉ, jipacʉ, cavarõ mearocacʉ aru ijãravʉ jabocʉ máre, mearore jívʉ mʉre, mi jã́d̶ovame boje caiye iye ji coyʉiyede ina majidivʉre, aru mi jã́d̶ovaiye boje caiye iyede ina majibevʉre. Mʉ, jipacʉ, jívʉ mʉre mearore mi nópe d̶aiye boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jʉ̃menijicʉre coyʉrĩ bʉojarĩ, Jesús arejamed̶a ina ʉ̃́que cʉrivʉre: —Jipacʉ Jʉ̃menijicʉ jíbi yʉre caiye ji majiéde aru caiye ji parʉéde máre. Ñame majibema yʉre. Quénora majibi jipacʉ. Ñame majibema jipacʉre. Quénora majivʉ yʉ, aru na máre ina ji coyʉimara, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Dinʉmʉ apevʉre dajocarĩ, Jesús arejamed̶a ʉ̃i bueimarare: —¡Torojʉma ina põeva jã́ivʉ caiye iye mʉje jã́iyede! ");
INSERT INTO cubNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Coyʉyʉbu mʉjare: Obedivʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõeva aru jabova máre jã́iyʉrĩduquemavʉ caiye iye mʉje jã́iyede. Ʉbenita jã́metequemavʉ. Aru jápiaiyʉrĩduquemavʉ mʉje jápiaiyede. Ʉbenita jápiabetequemavʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cũinácʉ põecʉ, Jʉ̃menijicʉi d̶aicõjeiyede majicʉ, Jesúi majiéde majiyʉcʉ, nacajari, jẽniari jã́rejamed̶a ʉ̃́re: —Mʉ, bueipõecʉ, ¿aipe d̶aquidi yʉ, cʉvacʉyʉ jãravʉ cũiméjãravʉ baquinóre? arejamed̶a ʉ̃ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús arejamed̶a ʉ̃́re: —¿Aipe Jʉ̃menijicʉ toivaicõjenejaquemari ʉ̃i d̶aicõjeiyede Moisés bácʉre javede? ¿Aipe majicʉrʉ̃ iye mi bueiyede? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jʉ ayʉ arejamed̶a ʉ̃́re: —Ʉjacʉ mi jabocʉ Jʉ̃menijicʉre caino mi ũmedʉque, caino mi ũmeque, caino mi baju parʉéque, aru caino mi majiéque máre. Aru ʉjacʉ mícʉre yópe mi ʉepe mi baju, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Que teni Jesús arejamed̶a ʉ̃́re: —Meavʉ mi jʉ aino. D̶ajacʉ yópe mi coyʉinope, cʉvacʉyʉ jãravʉ cũiméjãravʉ baquinóre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ʉbenita ñai ʉ̃mʉ, apevʉre ne me jã́rajiyepe ayʉ ʉ̃́re, jẽniari jã́rejamed̶a Jesúre: —¿Ñamema ñai jícʉ? arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús jʉ ayʉ, arejamed̶a ʉ̃́re: —Cũinácʉ ʉ̃mʉ ẽmeni nʉquemavʉ Jerusalén ãmicʉriĩmarore jocarĩ, nʉñʉ Jericó ãmicʉriĩmaroi. Que teni ñavacʉrivʉ jẽquemavʉ ʉ̃́re, tatorãjivʉ ʉ̃i cʉvaede. Ĩquemavʉ ʉ̃i cuitótecajede aru caiye ʉ̃i apejĩene máre. Aru jara popequemavʉ ʉ̃́re. Pare churiá d̶aquemavʉ. Que teni dajocaquemavʉ ʉ̃́re, “¿Yaiyʉ́ bárica?” arĩ dápiaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nópe teniburu yóboi, cũinácʉ sacerdote ẽmeni nʉquemavʉ dimamica. Aru jã́quemavʉ ñai parayʉre joborõi, ma ẽcarʉi. Ʉbenita ʉ̃́re jã́ri, vaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nopedeca cũinácʉ Jʉ̃menijicʉi cʉ̃ramine memeipõecʉ, levita ãmicʉriyajubocacʉ, eaquemavʉ joabenoi ñai parayʉ yebai. Ʉbenita ʉ̃́re jã́ri, vaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’No yóboi, cũinácʉ apenocacʉ, Samaria ãmicʉrijoborõcacʉ, nʉñʉ dimamica, eaquemavʉ ñai parayʉ yebai. Aru cõmaje ãroje jã́quemavʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ʉ̃i yebai nʉri, ʉ̃i churiáre yuaquemavʉ olivo ãmicʉricʉ jẽidʉa córore aru vino ʉ́yaicorore máre. Aru cuitótecajecãvaque bʉorĩ jʉoquemavʉ ʉ̃́re. Que teni nacovari ñóquemavʉ ʉ̃i tubamʉra. Aru nʉvaquemavʉ ʉ̃́re cuipõeva ne cãiñami, mead̶acʉyʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cõmiáijãravʉ jíquemavʉ tãutʉratʉravare ñai cãiñami upacʉre, bojed̶acʉyʉ ʉ̃i mead̶aquiyede ñai tatoimʉ mácʉre. Aru aquemavʉ ʉ̃́re: “Mead̶ajacʉ ñai ʉ̃mʉre me. Que teni ji copainʉmʉta bojed̶aquijivʉ mʉre caiye mi jíye báquede ʉ̃́re”, aquemavʉ ñai Samariacacʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Coyʉrĩ bʉojarĩ, ñai majicʉre Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquede Moisés bácʉre jẽniari jã́rejamed̶a Jesús: —¿Ácʉ põecʉ ina yóbecʉrã ʉ̃mʉvacacʉ batequémari cad̶ateyʉ ñai ʉ̃mʉre, ñavacʉrivʉ ne tatoimʉ mácʉre? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ʉ̃ jʉ ayʉ arejamed̶a Jesúre: —Ñai cõmaje ãroje jã́ri, cad̶ateyʉ bácʉbe ʉ̃́re, arejamed̶a. Jesús arejamed̶a ʉ̃́re: —Caride nʉri d̶ajacʉ ʉ̃i d̶aiye báquepe. Cõmaje ãroje jã́ri, cad̶atejacʉ mʉ apevʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús nʉrejamed̶a mái ʉ̃i bueimaraque. Aru ĩmajinoi ecoiyede, cũináco nomió, õi ãmiá Marta, copʉ etarejacod̶a Jesúre õi cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martai yóco máre cʉrejacod̶a, õi ãmiá María. Ico dobaco Jesúi cʉboba yebai, nópe ina judíovai d̶arĩ cõmajiyepe ne buenajiyepe aivʉ, jápiad̶o barejácod̶a ʉ̃i bueiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ʉbenita Marta pare cãrijinejacod̶a, õi ãiyede memeiye boje. Que baru Jesús yebai nʉri, arejacod̶a ʉ̃́re: —Mʉ, ji jabocʉ, ¿ye baju ãmeni jíyocoi dajocaino yʉre, cũinácova memeivʉ yʉ? Cad̶ateicõjejacʉ ṍre yʉre, arejacod̶a õ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ʉbenita Jesús arejamed̶a ṍre: —Mʉ, Marta, cãrijivʉ mʉ caijĩe apejĩe boje. ");
INSERT INTO cubNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ʉbenita cũinárora jaʉvʉ mʉre. Yópe María õi d̶aiyepe paino mearotamu. Õi jápiaiye ji bueiyede mearotamu. Que baru põecʉ cʉbebi ĩcʉyʉ õi d̶aiyʉrõre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cũinájãravʉ Jesús jẽniañʉ marejámed̶a jípacʉ Jʉ̃menijicʉque. Aru ʉ̃i jẽniariburu yóboi, cũinácʉ ʉ̃i bueimaracacʉ arejamed̶a ʉ̃́re: —Juan Bautista bácʉ Jʉ̃menijicʉque jẽniainore buequemavʉ ʉ̃i bueimarare. Que baru mʉ máre buejacʉ ñʉjare Jʉ̃menijicʉque jẽniainore, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Aru Jesús arejamed̶a náre: Mʉja jẽniaivʉ Jʉ̃menijicʉque yópe ajarã: “Mʉ, ñʉjepacʉ, meacʉ bajubu mʉ. Que baru caivʉ põeva mʉre pued̶arĩ mearore jíjarãri. Bʉ́re d̶ajacʉ mʉ mi jabotequiyede põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jíjacʉ ñʉjare jãravʉa coapa ñʉje ãiyeva. ");
INSERT INTO cubNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Aru ãrʉmetejacʉ ñʉje ãmeina teiyede yópe ñʉja máre ñʉje ãrʉmeteiyepe caiye apevʉ ne ãmeina d̶aiyede ñʉjaque. Ñai abujuvai jabocʉi jʉjovajʉroede ñʉjare vainí tʉicõjemejacʉ ñʉjare, ñʉje d̶abenajiyepe ãmenore”, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","7","Aru Jesús coyʉrejamed̶a náre yópe: —Põecʉ ʉ̃i nʉru cũinácʉ ʉ̃i yóvaimʉ yebai, acʉyʉ ʉ̃́re yópe: “Yʉ́cacʉ, jíjacʉ yʉre yóbecʉriboa pã́uboare. Apecʉ ji yóvaimʉ edaibi ji cʉ̃rami cuyʉ. Aru ãiye cʉbevʉ yʉre. Que baru jíquiye ʉ̃́re eabevʉ yʉ” ayʉre, ñai ʉ̃i yóvaimʉ, ʉ̃i cʉ̃rami cʉcʉ, jʉ abejebu ʉ̃́re yópe: “Cãrijovamejacʉ yʉre. Jave bievʉ yʉ ji cʉ̃ramine. Aru jímara jave cãivʉtamu. Que baru mʉre nacajari jíyʉ bʉojabevʉ yʉ”. Ʉ̃i yóvaimʉ abejebu ʉ̃́re yópe. ");
INSERT INTO cubNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Coyʉyʉbu mʉjare: Ʉ̃i yóvaiye boje jíbecʉbe ʉ̃́re. Quénora ʉ̃i cãrijovaiye boje, nacajari jícʉyʉme caiye iye jaʉéde ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Que baru coyʉyʉbu mʉjare: Jẽniare nʉjara Jʉ̃menijicʉre, aru jícʉyʉme mʉje jẽniainore ʉ̃́re. Vore nʉjara ʉ̃́re, aru earãjaramu. Aru mʉje órejare nʉiyede jedevacobei, Jʉ̃menijicʉ voacacʉyʉme mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Que baru caivʉ jẽniaivʉ Jʉ̃menijicʉre cʉvama ne jẽniainore. Aru caivʉ voivʉ ead̶ama ne voimʉre. Aru caivʉ órejaivʉre jedevacobei voaibi, arejamed̶a Jesús, náre bueyʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Cojedeca Jesús, yópe arĩ, buedejamed̶a náre: —Mʉja jʉed̶ocʉvarivʉ, ¿mʉjemacʉ ʉ̃i jẽniaru mʉjare pã́ubore, jíje bárica mʉja ʉ̃́re cʉ̃rabore? ¿Aru mʉjemacʉ ʉ̃i jẽniaru mʉjare moacʉre, jíje bárica mʉja ʉ̃́re ãd̶are? ");
INSERT INTO cubNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Aru mʉjemacʉ ʉ̃i jẽniaru mʉjare jĩ́dʉre, jíje bárica mʉja ʉ̃́re murine? Nópe d̶abenamu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Que baru mʉja ãmena méne cʉvede jíni majiépedeca mʉjemarare, majepacʉ Jʉ̃menijicʉ cavarõ mearocacʉ pʉeno méne cʉvaede jíni majibi mʉja jẽniaivʉre ʉ̃́que. Ʉ̃́vacari darocʉyʉme ñai Espíritu Santore caivʉ jẽniaivʉre ʉ̃́re, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Dinʉmʉre Jesús jaetovayʉ barejámed̶a abujucʉ yávabecʉre cũinácʉ ʉ̃mʉre jocarĩ. Aru ñai abujucʉ ʉ̃i etarĩburu yóboi, ñai ʉ̃mʉ yávabecʉ bácʉ yávarejamed̶a. Que baru ina põeva jã́ivʉ bácavʉ, pare dápiaivʉ, cuecumarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ʉbenita apevʉ ina põevacavʉ arejaimad̶a: —Beelzebú, abujuvai jabocʉ, ĩmamʉme ʉ̃. Que baru ʉ̃i parʉéque jarʉvaibi abujuvare, boro coyʉrĩ ad̶arĩdurejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aru apevʉ jʉjovaiyʉrivʉ barejáimad̶a ʉ̃́re, ne majinajiyepe aivʉ jãve ʉ̃i d̶aru ʉ̃i d̶aiyede Jʉ̃menijicʉi parʉéque. Que baru jẽniarejaimad̶a ʉ̃i jã́d̶ovaquiyepe aivʉ põeva ne d̶arĩ majibenore. ");
INSERT INTO cubNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ʉbenita Jesús coreóvayʉ ne dápiaiyede, “Beelzebú ʉ̃i ĩmamʉ” aivʉre, arejamed̶a náre: —Cũináro jaborõcavʉ ãd̶amateivʉ baru ne bajumia, ina jaborõcavʉ cũinájarama na. Nopedeca cũinád̶ami cʉ̃ramicavʉ ãd̶amateivʉ baru ne bajumia, diñamicavʉ cũinájarama na. ");
INSERT INTO cubNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Nopedeca bájebu ñai abujuvai jabocʉ, jaetovayʉ baru abujuvai jabocʉre. Ãd̶amateyʉ bájebu ʉ̃i bajuma. Aru jaetovayʉ baru abujuvare, joe parʉcʉ cʉbejebu ʉ̃. “Abujuvai jabocʉi parʉéque jaetovaibi abujuvare”, mʉje aiye boje yʉre, yópe coyʉyʉbu mʉjare: ");
INSERT INTO cubNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Ji jaetovaru abujuvare abujuvai jabocʉi parʉéque, ñamei parʉéque jaetovaidi mʉjacavʉ abujuvare? Que baru mʉjacavʉ abujuvare jaetovaivʉ jã́d̶ovad̶ama mʉjare mʉje borocʉede yʉre ʉbenina. ");
INSERT INTO cubNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ʉbenita Jʉ̃menijicʉi parʉéque jaetovayʉbu yʉ abujuvare. Que baru jã́d̶ovaivʉ yʉ Jʉ̃menijicʉ jaboteyʉre mʉjare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Dinʉmʉre Jesús coyʉrejamed̶a náre yo jã́ri dápiarĩ ne d̶arãjiyepe ainore, ne majinajiyepe ayʉ parʉcʉre abujuvai jabocʉ pʉeno. —Ʉ̃mʉ parʉcʉ jã́ri coreyʉ ʉ̃i cʉ̃ramine ʉ̃i boaiyeque, me mead̶aquemavʉ ʉ̃i cʉvaede. ");
INSERT INTO cubNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ʉbenita apecʉ ʉ̃i pʉeno parʉcʉ earĩ, boarĩ́ tatoquemavʉ ʉ̃́re. Ʉ̃i boaiyede, aru ʉ̃i cʉvaede nʉvari, coavaquemavʉ diede apevʉ ʉ̃i yóvaimaraque. ");
INSERT INTO cubNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Que baru ñai yóvabecʉ maucʉvaibi yʉre. Aru ñai apevʉre yóvare d̶abebi yʉre, náre maucʉvare d̶aibi yʉre, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Bedióva cojedeca Jesús buedejamed̶a náre: —Abujucʉ etayʉ bácʉ ʉ̃mʉre jocarĩ, voibi ʉ̃i jabʉóvaino penenoi. Ʉbenita jabʉóvaino eabecʉ baru, copaiyʉbi ñai ʉ̃mʉ, ʉ̃i etaimʉ mácʉrecata. ");
INSERT INTO cubNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aru copaini nʉñʉ, eaibi ñai ʉ̃mʉ meacʉre, yópe cʉ̃rami oeni mead̶aiñamipe páyʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Que baru apevʉ siete paivʉ abujuva ʉ̃i pʉeno ãmenare vorĩ earĩ, nʉvaimi ʉ̃́que. Aru ina d̶aicõjeivʉ ñai ʉ̃mʉre, ãmed̶ad̶ama ʉ̃́re pʉeno baju, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús ʉ̃i yávaiyedeca, cũináco nomió ina obedivʉ põeva jẽneboi cod̶oboborĩ arejacod̶a ʉ̃́re: —Mʉre jʉed̶ocʉvaco báco, aru mʉre bʉcʉóvad̶o báco mearo torojʉjacorĩ õ, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ʉbenita Jesús arejamed̶a ṍre: —Õi pʉeno torojʉrãjarama ina põeva Jʉ̃menijicʉi yávaiyede jʉ arĩ, d̶aivʉ yópe die coyʉinope, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Obedivʉ põeva ne cójijiyede Jesús yebai, yávarĩ bʉ́rejamed̶a náre: —Ijãravʉcavʉ ãmena jã́iyʉrĩduyama põeva ne d̶arĩ majibenore. Ʉbenita jã́menama apenore Jʉ̃menijicʉi d̶ainore náre, quénora yo Jonás mácʉre vaino mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yópe Jʉ̃menijicʉ ʉ̃i jaroiye báquepe Jonás mácʉre, ʉ̃i coyʉcaquiyepe ayʉ ʉ̃i yávaiyede nócavʉ, Nínive ãmicʉriĩmarocavʉ bácavʉre, nopedeca Jʉ̃menijicʉ darorejame yʉre, ʉ̃i daroimʉ mácʉre ʉ̃mʉpe, ji coyʉcaquiyepe ayʉ ʉ̃i yávaiyede ijãravʉcavʉre. Aru yópe Jonás mácʉi cʉe báquepe moacʉ ʉracʉi yapibʉ jívʉi yóbecʉrijãravʉa aru yóbecʉriñamia máre, nopedeca yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, cʉcʉyʉmu joborõ jívʉi yóbecʉrijãravʉa aru yóbecʉriñamia máre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, ico jaboco aviá daino cãcopũravʉcaco báco nacajacod̶ome ina põeva ijãravʉcavʉque aru ãmecorocod̶ome náre, ne yʉre jʉ abe boje. Õ máco darejaquemavʉ joarõ joborõre jocarĩ, jápiacod̶o ñai Salomón mácʉi coyʉiye báquede majiéque. Ʉbenita Salomón mácʉi majié pʉeno baju bueyʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aru Jʉ̃menijicʉi ñájiovaquijãravʉ baquinóre põevare, ne ãmeina teiye boje, ina ʉ̃mʉva mácavʉ, Nínivecavʉ bácavʉ, nacajarajarama ijãravʉcavʉque aru ãmecororãjarama náre, ne yʉre jʉ abe boje. Ina Nínivecavʉ bácavʉ chĩori ne ãmeina teiye báquede oatʉvarejaquemavʉ, jápiaivʉ bácavʉ Jonás mácʉi coyʉiye báquede Jʉ̃menijicʉi yávaiyede. Ʉbenita Jonás mácʉi majié pʉeno baju bueyʉbu yʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Cojedeca Jesús buedejamed̶a ina ʉ̃́que cʉrivʉre: —Põecʉ pẽoibʉre pẽoriburu yóboi, ñómemi dibʉre cobe jívʉi aru pʉebʉ cãchinoi máre. Quénora ñoimi dibʉre jocʉve pʉenora, ina ecoivʉ nore ne jã́rajiyepe ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Põeva ne yacorʉa, pẽoinope, jã́re d̶aivʉ náre, ne memenajiyepe aino aru ne majinajiyepe aino ã́ri ne nʉiyede. Põeva ne yacorʉa ijetedu náre o ne jã́iye bíjaru náre, ye ne memeiyede aru ne nʉiyede máre majibenama. Aru põeva ne ũme, yacorʉape paino, pẽore d̶aivʉ ne dápiaiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Que baru põecʉ cainʉmʉa dápiayʉ baru ijãravʉquede, ijetede d̶aibi ʉ̃i ũmene, ʉ̃i dápiabe boje cavarõ mearo Jʉ̃menijicʉi cʉrõquede. Aru ñai põecʉ ʉ̃i ũmene bíjacʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Que baru põeva ne jã́menu ne yacorʉaque ãmenotamu. Ʉbenita pʉeno ãmenotamu ne ũme ñemino maru, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús ʉ̃i yávarĩburu yóboi, cũinácʉ fariseovacacʉ “Ãcʉdajacʉ” ayʉ, órejarejamed̶a ʉ̃́re ʉ̃i cʉ̃rami. Que baru Jesús ecorĩ, dobarejamed̶a tʉoiva yebai. ");
INSERT INTO cubNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Aru ñai fariseo ãmeina jã́rejamed̶a ʉ̃́re, ʉ̃i cojabe boje ʉ̃i ãquiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aru Jesús arejamed̶a ʉ̃́re: —Mʉja fariseova joaivʉbu mʉje ũcuidoare, aru jororʉare máre pʉenomia, põeva ne jã́iyede. Ʉbenita mʉja tatoiyʉrivʉbu apevʉ ne cʉvaede. Que teni ãmeno baju d̶aivʉbu mʉja. Mearo d̶aiye apevʉre mearotamu joare d̶aicõjeiye pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ãrʉmevʉ mʉja! Ñai Jʉ̃menijicʉ cʉed̶ayʉ maje baju pʉenocarõre cʉed̶arejaquemavʉ jívʉcarõre, maje ũmene máre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ʉbenita mʉje cʉvaede jívʉquede jíjarã cõmaje ãrojarivʉre. Nópe d̶aivʉ mearo dápiarĩ cʉrãjaramu mʉja. Que baru mearo baju d̶aivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Mʉja, fariseova, ãmeno ñájino cʉvarãjaramu mʉja! Caiye mʉje oteiyoca, quĩ́jiyoca, bojecʉbeyoca, caipʉcapʉrʉape paiyocare cʉvarivʉ, cũináyocare jíyavʉ̃ Jʉ̃menijicʉre. Ʉbenita mearo d̶aivʉre apevʉre aru jecʉéde Jʉ̃menijicʉre máre ãrʉmevʉ mʉja. Caipʉcapʉrʉape paiye mʉje cʉvede jocarĩ, cũinárore Jʉ̃menijicʉre jíye jaʉvʉ mʉjare. Ʉbenita pʉeno baju jaʉvʉ mʉjare mʉje mearo d̶aiye apevʉre aru mʉje jecʉé Jʉ̃menijicʉre máre. Que d̶aru me cojʉquiyebu Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Mʉja, fariseova, ãmeno ñájino cʉvarãjaramu mʉja! Mʉje ʉe boje dobae mearoa baji judíovai cójijiñamiare aru mʉje ʉe boje põeva ne jacoyʉiyede mʉjare tãibʉi, ñájinajaramu mʉja. Ñájinajaramu mʉje ʉe boje apevʉre ne dápiaiyede mʉjare mearape apevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ãmeno ñájino cʉvarãjaramu mʉja! Yaivʉ bácavʉ ne jobocobeape paivʉ. Põeva cuivʉbu dicobea pʉenora, jã́mevʉva. Que baru ne cuiyede jarʉvaino pʉenora majibema na. Nopedeca põeva cuivʉbu mʉje yóboi, ʉbenita mʉje ũmene jã́mevʉva. Que baru mʉje ãmeina dápiaiyede majibema na, arejamed̶a Jesús, náre bueyʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aru cũinácʉ põecʉ, Jʉ̃menijicʉi d̶aicõjeiyede majicʉ, arejamed̶a Jesúre: —Mʉ, bueipõecʉ, mi que aiye ãmecoroivʉ ñʉjare máre, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Aru Jesús arejamed̶a náre: —Mʉja, Jʉ̃menijicʉi d̶aicõjeiyede majidivʉ máre ãmeno ñájino cʉvarãjaramu mʉja, mʉje d̶aicõjeiye boje apevʉre ne d̶aivʉ bʉojabede. Ʉbenita mʉjavacari ye cad̶atebevʉ náre. Que baru mʉja máre ñájinajaramu. ");
INSERT INTO cubNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ãmeno ñájino cʉvarãjaramu mʉja! Mʉja d̶aivʉbu mead̶amia cʉ̃ramiare ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne jobocobea báque pʉenoi, pued̶arãjivʉ na mácavʉre. Ʉbenita mʉjeñecuva mácavʉ boarĩ́ jarʉvarejaquemavʉ na mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Mʉje d̶aiyede diñamiare, jã́d̶ovaivʉbu jʉ aivʉre ne ãmeina teiye báquede, ne boarĩ́ jarʉvaiye báquede Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Que baru Jʉ̃menijicʉ ʉ̃i majiéque arejaquemavʉ yópe: “Jarocʉyʉmu yʉre yávaiyede coyʉcaipõevare aru ji yávaiye méne beorĩ coyʉicõjeimarare máre. Apevʉ ina yʉre yávaiyede coyʉcaipõevacavʉre aru ina ji yávaiye méne beorĩ coyʉicõjeimaracavʉre máre ãmeina d̶arĩ, boarĩ́ jarʉvarãjarama náre”, arejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ne nópe d̶aiye boje, Jʉ̃menijicʉ yaicõjecʉyʉme ijãravʉcavʉre ijãravʉre d̶arĩ bʉiyedata. ");
INSERT INTO cubNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Apecʉ ʉ̃i boarĩ́ jarʉvaiye báque boje ñai Abel bácʉre, aru apevʉ ne boarĩ́ jarʉvaiye báque boje caivʉ Abel bácʉi yóbocavʉ bácavʉre máre pʉ Zacarías bácʉ bajita, ñai ne boarĩ́ jarʉvaimʉ mácʉ Jʉ̃menijicʉi cʉ̃rami tãibʉ coricai, jãve coyʉyʉbu mʉjare: Ijãravʉcavʉ ñájinajarama ne boarĩ́ jarʉvaiye báque boje. ");
INSERT INTO cubNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Mʉja, Jʉ̃menijicʉi d̶aicõjeiyede majidivʉ, ãmeno ñájino cʉvarãjaramu mʉja! Jʉ̃menijicʉi majiéde bueivʉvacari, coyʉiyʉbevʉbu mʉja apevʉre, ne majibenajiyepe aivʉ. Jãve Jʉ̃menijicʉi majiéde majibevʉ, majidivʉpe teivʉvacari, apevʉre máre majicõjemevʉbu, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Jesús ʉ̃i yávarĩburu yóboi nʉrejamed̶a nore jocarĩ. Aru no yóboi ina Jʉ̃menijicʉi yávaiye báquede bueipõeva aru ina fariseova máre pare cãrijovari jẽniari jã́rejaimad̶a ʉ̃́re, boro coyʉrĩ ad̶aiyʉrĩduivʉ ʉ̃i yávaiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dinʉmʉma obedivʉ põeva cójijivʉ ne baju cʉraraiyede, Jesús, yópe arĩ, coyʉrĩ bʉ́rejamed̶a ʉ̃i bueimarare: —Me d̶ajarã. Me jã́jara, mʉje dápiabenajiyepe yópe ina fariseova ne dápiaiyepe. Nácapũravʉ dápiavaivʉbu aipe d̶arĩ jʉjovarãjivʉ apevʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Caiye jã́d̶ovame máque jároquiyebu. Aru dupióvaiye báquede máre majinajarama caivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Que baru caiye mʉje aiye báquede ñeminoi, jápiarãjarama caivʉ põeva Jʉ̃menijicʉ coyʉre d̶ayʉre diede miad̶ároi. Caiye mʉje jũjuvaiye báquede máre tucubʉa jívʉi apevʉre jocarĩ, jápiarãjarama caivʉ põeva Jʉ̃menijicʉ coyʉre d̶ayʉre diede ne cójijinoi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús coyʉrejamed̶a náre cojedeca: —Mʉja, ji yóvaimarare, coyʉyʉbu mʉjare yópe: Jidʉbejarã ina boarĩ́ jarʉvaivʉre mʉje bajure aru apeno d̶arĩ bʉojabevʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ʉbenita coyʉquijivʉ mʉjare mʉje jidʉrãjimʉre: Jidʉjarã Jʉ̃menijicʉre, ñaine mʉje baju yainíburu yóboi jarʉvarĩ bʉojayʉre toabo cũiméboi. Jãve coyʉyʉbu mʉjare: ¡Jidʉjarã ʉ̃́re! arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Aru cojedeca Jesús arejamed̶a náre: —Yócavʉ bojed̶aivʉ cũinápʉrʉpe paivʉ míjina quĩ́jinare pʉcatʉrava tãutʉratʉrava bojecʉbetʉravaque. Aru Jʉ̃menijicʉ ãrʉmetebebi caivʉ ina míjinare. ");
INSERT INTO cubNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jʉ̃menijicʉ majibi caiye pod̶amea cʉede mʉje jipobʉi máre. Que baru jidʉbejarã. Mʉja bojecʉrivʉtamu caivʉ míjina obedivʉ pʉeno, mʉje ũme yaibé boje, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Bedióva cojedeca Jesús, yópe arĩ, coyʉrejamed̶a ina ʉ̃́que cʉrivʉre: —Coyʉyʉbu mʉjare: Caivʉ ina jʉ aivʉre yʉre põeva ne jã́iyede, yʉ máre, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, náre jʉ acʉyʉmu Jʉ̃menijicʉi ángeleva ne jã́iyede. ");
INSERT INTO cubNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ʉbenita caivʉ ina jʉ abevʉre yʉre põeva ne jã́iyede, yʉ máre náre jʉ abecʉbu Jʉ̃menijicʉi ángeleva ne jã́iyede. ");
INSERT INTO cubNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Caivʉ ina ãmeina yávaivʉre yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, Jʉ̃menijicʉ ãrʉmeteibi ne ãmeina teiyede. Ʉbenita ina ãmeina yávaivʉre ñai Espíritu Santore, Jʉ̃menijicʉ ãrʉmetebebi ne ãmeina teiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Aru ne jẽni nʉvaiyede mʉjare judíovai cójijiñamia yebai, aru ãmeina teivʉre jẽniari jã́ipõeva jipocai, aru jabova jipocai máre, “¿Aipe coyʉrãjidi náre?” arĩ cãrijimejara mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dinʉmʉ maquinómareca ñai Espíritu Santo majicacʉyʉme mʉjare iye mʉje coyʉrãjiyede náre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cũinácʉ ina põevacacʉ arejamed̶a Jesúre: —Mʉ, bueipõecʉ, ñʉjepacʉ yaiyʉ́ bácʉ, ʉ̃i cʉvaede dajocame. Aru jimamicʉ ĩame caiye diede. Que baru coavaicõjejacʉ jimamicʉre die ʉ̃i cʉvaede yʉ́que, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ʉbenita Jesús arejamed̶a ʉ̃́re: —¿Ñame yʉre epedi ãmeina teivʉre jẽniari jã́ipõecʉpe o coavaipõecʉpe mʉjare? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aru arejamed̶a ina obedivʉ põevare: —¡Me jã́jara! Ãujimejara mʉja. Põecʉ ʉ̃i apʉé ãmevʉ ʉ̃i ʉrarõ cʉvaeque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Que baru ne jápiarĩ earãjiyepe ayʉ, yópe arĩ, jã́ri dápiarĩ ne d̶arãjiyepe ainore coyʉrejamed̶a Jesús: —Cũinácʉ ʉ̃mʉ cʉve cʉvacʉ ʉrarõ oteiyede ĩquemavʉ ʉ̃i jiore. ");
INSERT INTO cubNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Que teni dápiaquemavʉ ʉ̃i baju: “¿Aipe d̶aji yʉ? Caiye iye ji ʉrarõ oteiye epeiñami cʉvabevʉ yʉ”. ");
INSERT INTO cubNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Que dápiarĩ, ʉ̃i baju yópe arĩ dápiaquemavʉ cojedeca: “Tʉvarĩ jarʉvaicõjequijivʉ ji cʉ̃ramia epeiñamiare. Aru tʉvarĩ jarʉvarĩburu yóboi, d̶aicõjequijivʉ aped̶ãmia pʉeno ʉrad̶ãmiare. Aru ʉrad̶ãmia jívʉi epeicõjequijivʉ caiye ji oteiyede aru caiye ji apejĩene máre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","20","Aru ji baju dápiarĩ aquijivʉ yópe: ‘Ʉrarõ cʉvaede cʉvavʉ yʉ. Yʉre apʉre d̶aiyede cʉvavʉ yʉ obediʉjʉaqueva. Que baru jabʉóvarĩ, ãri, ũcuri, torojʉve tequijivʉ yʉ dieque’, aquemavʉ”. Ʉbenita Jʉ̃menijicʉ aquemavʉ ʉ̃́re: “¡Mʉ, ãrʉmecʉ, cari ñamimareca yaiquíjivʉ mʉ! Que teni caiye iye mi cʉvae bíjaquiyebu mʉre”, aquemavʉ ʉ̃́re Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nopedeca vaivʉ ʉ̃́re, ñai põecʉ jẽñʉre ʉ̃ jieva ʉrarõ cʉvaede. Ʉbenita Jʉ̃menijicʉi jã́inoi ye cʉvabebi ʉ̃, arĩ coyʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","No yóboi Jesús arejamed̶a ʉ̃i bueimarare: —Coyʉyʉbu mʉjare: Cãrijimejara mʉja apʉrivʉ mʉje ãrajiyede, aru mʉje bajure, mʉje dorãjiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mʉje apʉrõ ãiye pʉeno bojecʉrõtamu. Aru mʉje baju máre doiye pʉeno bojecʉrõtamu, mʉje ũme yaibé boje. ");
INSERT INTO cubNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Jã́rijide apa ina míjinare. Na otebevʉreca, aru oteiyede máre ĩmevʉreca, aru ne oteiye epeiñamine máre cʉvabevʉreca, ʉbenita Jʉ̃menijicʉ jíbi náre ne ãiyeva. Aru caivʉ míjina obedivʉ pʉeno mʉja bojecʉrivʉtamu, Jʉ̃menijicʉi pʉeno ʉe boje mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aru mʉjacacʉ cãrijiñʉ maru cũináora cʉre d̶aiye majibebi ʉ̃i cʉede ijãravʉi. Que baru cãrijiye meamevʉ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¿Bʉojarĩ d̶abevʉvacari maiyójabenore, aipe teni cãrijivʉrʉ̃ mʉja mʉje d̶aiye majibede? ");
INSERT INTO cubNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Jã́rijide apa mʉja iye cóvʉare. Die bʉcʉiyavʉ̃, mememevacari, aru ne cuitótecajeare máre naremevacari. Ʉbenita coyʉyʉbu mʉjare: Iye cóvʉa métamu, caiye icaje ñai jabocʉ bácʉ Salomón mácʉi cuitótecajea bojecʉricajea pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","¡Mʉja pare quĩ́jino jʉ aivʉbu Jʉ̃menijicʉre! Jʉ̃menijicʉ nópe mearo d̶aibi iye cõriáre, caride dái cʉede aru javenare põeva ne juarãjiyede. Nopedeca Jʉ̃menijicʉ jícʉyʉme mʉjare mʉje cuitótecajea meacajeare caiye iye cóvʉa pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Que baru cãrijini vobejarã mʉje ãrajiyede aru mʉje ũcurajiyede máre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ina Jʉ̃menijicʉre jʉ abevʉ cãrijini vod̶ama caiye iyede, ne ãrajiyede, aru ne ũcurajiyede máre. Ʉbenita majepacʉ Jʉ̃menijicʉ majibi caiye iye mʉjare jaʉéde. ");
INSERT INTO cubNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ʉbenita vojarã mʉja Jʉ̃menijicʉi jaboteinoquede, mʉje d̶aiyʉe boje mearore yópe ʉ̃i d̶aicõjeiyepe. Aru Jʉ̃menijicʉ jícʉyʉme mʉje ãrajiyede, mʉje ũcurajiyede, aru cuitótecajeare máre, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Cojedeca yópe arĩ, buedejamed̶a Jesús: —Mʉja, jívʉ, obebejĩnavacari jidʉbejarã. Majepacʉ Jʉ̃menijicʉ, ʉ̃i me boje, epecʉyʉme mʉjare jabovava ʉ̃i jaboteinʉmʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jíni bojed̶ajarã mʉje cʉvaede aru tãutʉrare ĩniburu, jíjarã cʉve cʉvabevʉre. Que teni cʉvarãjaramu cainʉmʉa mʉje cʉvae me cũiméne cavarõ mearo Jʉ̃menijicʉi cʉrõi, ñavaipõeva ne ĩmenoi aru bocomiva ne ãmenoi. ");
INSERT INTO cubNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Que baru mʉje cʉvae cʉrõre dápiarãjaramu mʉje ũmeque máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús, yópe arĩ, buedejamed̶a ina ʉ̃́que cʉrivʉre: —Meatejarã mʉja yópe põeva ne memenajiye jipocamia ne meateiyepe. Bʉojarã mʉje jãrióicãvare aru pẽojara mʉje pẽoibʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","D̶ajarã yópe ina memecaipõeva ne d̶aiyepe coreivʉ ne jabocʉre, voarãjivʉ maumena ʉ̃i copaiyede pʉrʉbʉorĩ torojʉve teinore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ñai jabocʉ darĩ earu ina ʉ̃́re memecaipõeva coreivʉre, torojʉrãjarama na. Jãve coyʉyʉbu mʉjare: Ñai jabocʉ bʉocʉyʉme ʉ̃i jãrióicãvare. Aru náre dobaicõjeni tʉoiva yebai, jícʉyʉme ne ãrajiyeva. ");
INSERT INTO cubNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Que teni ñai jabocʉ ʉ̃i daiyede ñami coricai o miad̶áe tʉiyede, ina memecaipõeva coreivʉ baru ʉ̃́re, me torojʉrãjarama na, ʉ̃i mearo d̶acaquiye boje náre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Me dápiajarã iyede: Ñai cʉ̃rami upacʉ majibebi aipiyede ñavaipõecʉ dacʉyʉre. Majicʉ baru ñavaipõecʉi daquiyede, coreni, ecoicõjemeni, ñavaicõjemejebu ʉ̃i cʉ̃ramiquede. ");
INSERT INTO cubNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yʉ máre, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, dacʉyʉmu yʉre mʉje corebenʉmʉre. Que baru meateiye jaʉvʉ mʉjare máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro jẽniari jã́rejamed̶a Jesúre: —Mʉ, ñʉje jabocʉ, ¿coyʉcacʉrʉ̃ mʉ yo jã́ri dápiarĩ põeva ne d̶arãjiyepe aino mácarõre ñʉjare? ¿O coyʉcacʉrʉ̃ yore caivʉre? arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aru Jesús arejamed̶a ʉ̃́re: —Coyʉquijivʉ mʉjare ʉ̃i borore ñai memecaipõecʉre jʉ ayʉre ʉ̃i jabocʉre aru majicʉre máre. Ñai cʉ̃rami upacʉ coreicõjecʉyʉbe ñai memecaipõecʉ majicʉre, ʉ̃i jíquiyepe ayʉ yebacavʉre ne ãrajiyeva caijãravʉa. ");
INSERT INTO cubNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ñai cʉ̃rami upacʉ copaini dayʉ, earu ʉ̃́re memecaipõecʉre d̶ayʉre yópe ʉ̃i cõjeinope, torojʉcʉyʉbe ñai memecaipõecʉ, cʉ̃rami upacʉ ʉ̃i jíquiye boje ʉ̃́re bojed̶aino mearore. ");
INSERT INTO cubNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jãve coyʉyʉbu mʉjare: Ñai cʉ̃rami upacʉ coreicõjecʉyʉbe ñai memecaipõecʉre caiye ʉ̃i cʉvaede. ");
INSERT INTO cubNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ʉbenita apecʉ memecaipõecʉ, ñai jʉ abecʉ ʉ̃i jabocʉre, “Ji jabocʉ maume dabecʉbe” arĩ, ãmeina d̶ayʉ baru ʉ̃i yebacavʉre aru yebacarõmivare máre, ʉrarõ ãri aru ũcuri pacotecʉyʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Que teiyede, ʉ̃i jabocʉ dacʉyʉbe ñai memecaipõecʉ ʉ̃i corebejãravʉ baquinói aru ʉ̃i majibeora baquinói máre. Aru jarʉvaicõjecʉyʉbe ʉ̃́re noi, Jʉ̃menijicʉre jʉ abevʉre ne jarʉvainoi, ʉ̃i ñájiquiyepe ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Que baru ñai memecaipõecʉ majicʉreca ʉ̃i jabocʉi ʉrõre, ʉbenita ʉ̃i mememenu, aru jʉ abedu ʉ̃́re, ñai jabocʉ pare jara popeicõjecʉyʉbe ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ʉbenita ñai memecaipõecʉi majibedu ʉ̃i jabocʉi ʉrõre, aru ãmenore d̶aru, majiéda jara popeicõjecʉyʉbe ʉ̃́re. Ñai majicʉre ʉ̃i jabocʉi ʉrõre d̶aiye jaʉvʉ ʉ̃i majiépe. Aru ñai põeva ne jímʉ mácʉre ʉrarõ, jacopaiyovaiye jaʉvʉ náre coapa cojedeca, arejamed̶a Jesús, náre bueyʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Cojedeca Jesús coyʉrejamed̶a náre: —Darejacacʉ yʉ ijãravʉi, Espíritu Santo ʉ̃i daquiyepe ayʉ ijãravʉcavʉre. Aru pare ʉvʉ yʉ ʉ̃i daquiyede ʉ̃i ʉre parʉéque. ");
INSERT INTO cubNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ʉbenita mamarʉmʉ ʉrarõ ñájiye jaʉquiyebu yʉre. Ñájivʉ yʉ caride, aru ñájiquijivʉ ji ñájiye bʉojaiyeta. ");
INSERT INTO cubNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Dápiaivʉrʉ̃ mʉja yʉ dayʉ bácʉre cãrijimene d̶acʉyʉ ijãravʉcavʉre? Jãve coyʉyʉbu mʉjare: Ji daiye báque boje ijãravʉi, põeva coatenajarama ne baju. ");
INSERT INTO cubNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Que baru cũinápʉrʉpe paivʉ cũinád̶ami cʉ̃ramicavʉ maucʉvarãjivʉbu ne baju yʉre boje. Pʉcarã ãd̶amatenajivʉbu apevʉ yóbecʉrãque. ");
INSERT INTO cubNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Apevʉ nácavʉ jʉ arãjivʉbu yʉre. Ʉbenita apevʉ nácavʉ jʉ abenajivʉbu yʉre. Que baru népacʉ ãd̶amatequijibi mamacʉque. Aru mamacʉ ãd̶amatequijibi jípacʉque. Népaco ãd̶amatecojibico mamacoque. Aru mamaco ãd̶amatecojibico jípacoque. Mamacʉi márepaco ãd̶amatecojibico õi vácoque. Aru õi vácore ãd̶amatecojibico ṍque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús arejamed̶a ina obedivʉ põevare: —Mʉja jã́ivʉ ocopenibo nacajainore aviá doinoi, cũiná aiyavʉ̃ mʉja “Ocaquiyebu”. Aru nopedeca ocaiyavʉ̃ no. ");
INSERT INTO cubNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aru mʉja jã́ivʉ ũmevʉ japuinore aviá daino cãcopũravʉre jocarĩ, aiyavʉ̃ mʉja “Pare bo daivʉ. Meajãravʉ daivʉ”. Aru nopedeca boiyavʉ̃ no. ");
INSERT INTO cubNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Mʉja, jʉjovaivʉtamu! Joborõquede aru cavarõquede máre coreóvaivʉvacari, ʉbenita pare coreóvabevʉbu mʉja ijãravʉi vaiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús arejamed̶a náre cojedeca: —¿Aipe teni mead̶abenarʉ mʉje d̶aiyede caride mʉje majinomia? Mead̶ajarã mʉje d̶aiyede caride yópe mʉje majinope. ");
INSERT INTO cubNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mʉjacacʉ nʉñʉ maru ʉ̃́re ãmecoroyʉque jabova ne ãmeina teivʉre jẽniari jã́iñami, “Mead̶arãjarevʉ” ajacʉrĩ ʉ̃́re, ʉ̃i nʉvamequiyepe ayʉ ʉ̃́re jabova ne ãmeina teivʉre jẽniari jã́ipõecʉre, aru ʉ̃i jẽni jíbequiyepe ayʉ ʉ̃́re churaravare, aru ne jarʉvabenajiyepe ayʉ ʉ̃́re ãmeina teivʉre jẽni jacoiñami jívʉi. ");
INSERT INTO cubNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Coyʉyʉbu mʉjare: Ne bʉoru ʉ̃́re ãmeina teivʉre jẽni jacoiñami jívʉi, etabecʉbe pʉ bojed̶ayʉta caiye iye ʉ̃i bojecʉbe d̶aiyede, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Dinʉmʉ apevʉ põeva, Jesús yebai jã́ranʉri, ʉ̃́re coyʉrejaimad̶a ñai jabocʉ Pilato ãmicʉcʉ ʉ̃i boarĩ́ jarʉvaiyede apevʉ Galilea ãmicʉrijoborõcavʉre aru ʉ̃i jĩvaino mácarõre ne jivede ãimara jiveque, diede juaicõjeni pued̶arĩducʉyʉ Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Aru Jesús arejamed̶a náre: —¿Dápiaivʉrʉ̃ mʉja ina Galileacavʉre, Pilatoi boarĩ́ jarʉvaimara mácavʉ, ãmena mácavʉ bajure apevʉ Galileacavʉ pʉeno? ");
INSERT INTO cubNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Coyʉyʉbu mʉjare: ¡Que ãmevʉ! Mʉja chĩori dápiarĩ mʉje ãmeina teiyede jarʉvarĩ oatʉvabevʉ baru, napedeca ñájinajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Aru dápiaivʉrʉ̃ mʉja ina dieciocho paivʉ tʉimara mácavʉre cʉ̃rami ʉ̃mʉjʉriñami Siloé ãmicʉrõcad̶ãmi ãmena mácavʉ bajure caivʉ apevʉ Jerusalẽ́cavʉ pʉeno? ");
INSERT INTO cubNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Coyʉyʉbu mʉjare: ¡Que ãmevʉ! Mʉja chĩori dápiarĩ mʉje ãmeina teiyede jarʉvarĩ oatʉvabevʉ baru, napedeca ñájinajaramu mʉja, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Apeno jã́ri dápiarĩ ne d̶arãjiyepe ainoque, yópe arĩ, buedejamed̶a Jesús: —Cũinácʉ ʉ̃mʉ cʉvatequemavʉ higuera ãmicʉricʉre ʉ̃i jioi. Aru cũinájãravʉ nʉri vorĩduquemavʉ dicʉ jẽidʉare. Ʉbenita eabetequemavʉ didʉáre. ");
INSERT INTO cubNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Que teni aquemavʉ jiore memecaipõecʉre yópe: “Jã́jacʉ. Yóbecʉriʉjʉa coapa vocʉdarĩduivʉ yʉ jẽidʉare icʉ jocʉcʉre. Ʉbenita cainʉmʉa eabevʉ yʉ. Jẽidʉa cʉbevʉ dicʉ. Que baru icʉ higueracʉre coení jarʉvajacʉ mʉ. ¿Aipe teni bíjaji yʉ ji joborõre icʉ ãmecʉ boje?” aquemavʉ ñai jabocʉ memecaipõecʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ʉbenita ñai memecaipõecʉ aquemavʉ ʉ̃́re: “Mʉ, ji jabocʉ, dajocajacʉ icʉ higueracʉre iʉjʉ bajure cãreja. Ũiyʉvʉ yʉ icʉ yebai. Aru etejʉede máre epeiyʉvʉ yʉ dicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Que teni apeʉjʉ jẽidʉa bʉcʉru, meaquiyebu. Ʉbenita apeʉjʉ jẽidʉa bʉcʉbedu, coení jarʉvaicõjejacʉ icʉ higueracʉre”, aquemavʉ ñai memecaipõecʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Dinʉmʉ Jesús bueyʉ barejámed̶a cũinád̶ami judíovai cójijiñami jívʉi ne jabʉóvaijãravʉ sábadoi. ");
INSERT INTO cubNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aru nore cʉrejacod̶a cũináco nomió abujucʉ ʉ̃i ijide d̶aimo. Ñai abujucʉre cʉrejacod̶a õ dieciocho paiʉjʉa baju. Õ tũijidʉ barejácod̶a. Nurié núco oabedejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús ṍre jã́ñʉ, cuturejamed̶a ṍre ʉ̃i yebai. Aru arejamed̶a: —Mʉ, nomió, mead̶aimomu mʉ mi ijinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Que arĩ, tʉorejamed̶a ṍre ʉ̃i pʉrʉáque. Aru cũiná nurié núrejacod̶a õ. Que baru torojʉede jídejacod̶a Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ʉbenita ñai judíovai cójijiñamine coreipõecʉ Jesúre jarayʉ, ʉ̃i mead̶aiye boje jabʉóvaijãravʉi, arejamed̶a ina põevare: —Seis paijãravʉa cʉvʉ, mʉje memeijãravʉa. Memeijãravʉai meatenadajarã mʉja. Ʉbenita jabʉóvaijãravʉi meatenadabejarã, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Aru Jesús arejamed̶a ʉ̃́re: —¡Mʉja jʉjovaivʉtamu! Caivʉ mʉja mʉje oteivecʉre o mʉje burrore máre ʉ̃i ãitõcure jod̶eni jocarĩ, ocore jínanʉvaiyavʉ mʉja jabʉóvaijãravʉi. ");
INSERT INTO cubNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Quédeca ico nomióre, Abraham mácʉi pãramenacacore, abujuvai jabocʉ ʉ̃i d̶aicõjeimo mácore dieciocho paiʉjʉa baju, mead̶aiye jaʉvʉ ṍre jabʉóvaijãravʉi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ʉ̃ que ayʉre, caivʉ ʉ̃i mauva cʉyoje tedejaimad̶a na. Aru caivʉ ina obedivʉ põeva pare torojʉrejaimad̶a caiye iye ʉ̃i d̶arĩ majibede d̶aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bedióva Jesús arejamed̶a: —Coyʉquijivʉ mʉjare aipe ãrojarore yo Jʉ̃menijicʉi jaboteinore. Jã́ri dápiarĩ mʉje d̶arãjiyepe ainore coyʉquijivʉ mʉjare, mʉje majinajiyepe ayʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yópe mostaza ãmicʉriyabe oteiyabepebu. Cũinácʉ ʉ̃mʉ diyabede ĩni oteibi ʉ̃i jioi. Aru bʉcʉrĩ mʉivʉ jocʉcʉpe. Dicʉ cavabʉa ʉracavabʉa nʉivʉ. Aru dicʉ taino cãchinoi míjina ne juaiboa d̶ad̶ama, arejamed̶a Jesús. Nopedeca mamarʉmʉre Jʉ̃menijicʉi jaboteino quĩ́jinotamu, põeva obebevʉ ne cʉe boje noi. Ʉbenita Jʉ̃menijicʉi yávaiye méne coyʉrĩburu yóboi ʉrarõtamu no Jʉ̃menijicʉi jaboteino, obedivʉ põeva ne cʉe boje noi. ");
INSERT INTO cubNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bedióva cojedeca Jesús arejamed̶a: —Jã́ri dápiarĩ mʉje d̶arãjiyepe ainore coyʉquijivʉ yo Jʉ̃menijicʉi jaboteinore. Yópebu nomió õi pã́ure bʉcʉre d̶aiyepe. ");
INSERT INTO cubNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Diede ad̶arĩ jĩvaiyepebu yóbecʉricurubʉa pã́u d̶aicurubʉare. Aru caino jĩvaibore bʉcʉóvainopebu, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús ʉ̃i nʉiyede Jerusalén ãmicʉriĩmaroi, ʉ̃i vaiyede ĩmaroare aru ĩmajinoare máre, buedejamed̶a nócavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Aru cũinácʉ põecʉ jẽniari jã́rejamed̶a ʉ̃́re: —Mʉ, ñʉje jabocʉ, ¿obebevʉ bárãjidica na, Jʉ̃menijicʉi mead̶aimara márajivʉ? Jesúre arejamed̶a. Aru Jesús arejamed̶a caivʉ ina põevare: ");
INSERT INTO cubNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Ecojarã mʉja jedevacobe quĩ́jicobei. Norecabu Jʉ̃menijicʉi jaboteino. Coyʉyʉbu mʉjare: Obedivʉ ecoiyʉrĩdurãjarama nore. Ʉbenita bʉojabenajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Cũinácʉ cʉ̃rami upacʉ bieniburu yóboi ʉ̃i jedevacobede ñamine, voaiyʉbebi dicobede cojedeca. Nopedeca Jʉ̃menijicʉ ʉ̃i jaboteino ecoiyede bieniburu yóboi, voabecʉyʉme mʉja núrivʉre jedevai. Órejarãjaramu ʉ̃́re pare: “Mʉ, ñʉje jabocʉ, voajacʉ ñʉjare”. Ʉbenita Jʉ̃menijicʉ acʉyʉme mʉjare: “Jívʉ ãmevʉ mʉja. Mʉje dainore majibevʉ yʉ”, acʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Dinʉmʉre yópe arĩ bʉ́rãjaramu mʉja: “Ñʉja ãri aru ũcuri tecarã mʉ́que aru ñʉje ĩmaroa ma ẽcarʉi bueávʉ̃ mʉ ñʉjare”, arãjaramu. ");
INSERT INTO cubNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ʉbenita ʉ̃ acʉyʉme: “Coyʉyʉbu mʉjare: Jívʉ ãmevʉ mʉja. Mʉje dainore majibevʉ yʉ. ¡Que baru caivʉ mʉja ãmeina teivʉ nʉjara yʉre jocarĩ!” acʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chĩoivʉ orĩ cʉrãjaramu mʉja nore. Aru jararĩ cõpi cũrajaramu mʉja jã́ivʉ náre; Abrahãre, Isaare, Jacore, aru caivʉ ina Jʉ̃menijicʉi yávaiyede coyʉcaipõevare máre, cʉrivʉre Jʉ̃menijicʉi jaboteinoi. Ʉbenita mʉjacapũravʉ mautenajaramu jedevai. ");
INSERT INTO cubNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Aru darãjarama põeva, cainoa joborõacavʉ. Dobarãjarama ʉ̃i tʉoiva yebai, ãrajivʉ ʉ̃i torojʉve teinʉmʉre Jʉ̃menijicʉi jaboteinoi. ");
INSERT INTO cubNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Dinʉmʉ maquinóre apevʉ jabotebevʉ bácavʉ ijãravʉre jabotenajarama Jʉ̃menijicʉi jaboteino edaiyede. Aru apevʉ jaboteivʉ bácavʉ ijãravʉre jabotebenajarama Jʉ̃menijicʉi jaboteino edaiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Dinʉmʉ apevʉ ina fariseovacavʉ nʉrejaimad̶a Jesús yebai. Aru arejaimad̶a ʉ̃́re: —Herodes boarĩ́ yaiváiyʉbi mʉre. Que baru dupini nʉjacʉ mʉ yore jocarĩ, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ʉbenita Jesús arejamed̶a náre: —Yópe arãnʉjara ãñʉ borocʉcʉre: “Jesús ñʉjare aicõjeimi mʉre yópe, ‘Abujuvare jarʉvaivʉ yʉ aru põevare mead̶aivʉ yʉ caride aru javenare máre. Aru yóbecʉrijãravʉa yóboi ji d̶aiyede bʉojaquijivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ʉbenita mái nʉiye jaʉvʉ yʉre caride, javenare, aru javena cõmiáijãravʉre máre. Cũinácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ yainí bʉojabecʉbe Jerusalẽ́ne jocarĩ. Que baru nʉquijivʉ yʉ Jerusalẽ́i, ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre ne boarĩ́ jarʉvainoi, põeva ne boarĩ́ jarʉvarãjiyepe ayʉ yʉre’, ajarã Herodede”, náre aicõjenejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Aru arejamed̶a Jesús: —¡Mʉja, Jerusalẽ́cavʉ, mʉjeñecuva mácavʉ boarĩ́ jarʉvarejaquemavʉ ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉre! Cʉ̃raboaque dʉvarĩ boarĩ́ jarʉvarejaquemavʉ ina Jʉ̃menijicʉi daroimara mácavʉre. Aipiye baju cójijovaiyʉrĩduvʉ yʉ mʉjare ji yebai, yópe cáyuco õi cójijovaiyepe mamarare õi caveba cãchinoi. Ʉbenita ʉbeteavʉ̃ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jã́jara. Dinʉmʉ maquinóre mʉje cʉrõre Jʉ̃menijicʉ dajocarĩ jarʉvacʉyʉme. Aru coyʉyʉbu mʉjare: Yʉre jã́menajaramu mʉja cojedeca pʉ jã́d̶ovacʉdayʉre meacʉ bajure jã́ivʉta. Dinʉmʉ maquinóre arãjaramu yópe: “Torojʉe bajad̶éni ñai dayʉre Jʉ̃menijicʉi ãmiái, ʉ̃i parʉéque”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cũinájãravʉ, judíovai jabʉóvaijãravʉ sábadoi, Jesús ãcʉnʉrejamed̶a cũinácʉ jabocʉ, fariseovacacʉi cʉ̃rami. Ina jabova nore cʉrivʉ cocorejaimad̶a ʉ̃́re, ʉ̃i ãmeina tedu, boro coyʉrĩ ad̶arãjivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aru cũinácʉ ʉ̃mʉ pare ijimʉ járorejamed̶a nore, ʉ̃i ãmuvea aru ʉ̃i ãrad̶oa máre pare cocororejavʉ̃ya ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ʉ̃́re jã́ñʉ Jesús, jẽniari jã́rejamed̶a ina Jʉ̃menijicʉi yávaiye báquede bueipõevare aru ina fariseovare máre, noi cʉrivʉre, yópe arĩ: —¿Mead̶aiye jaʉri põevare judíovai jabʉóvaijãravʉ sábadoi? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ʉbenita bi arejaimad̶a na. Dinʉmʉma Jesús ñai ijimʉre jẽni mead̶arejamed̶a. Ʉ̃i mead̶arĩburu yóboi, nʉicõjenejamed̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Aru Jesús arejamed̶a náre: —¿Ácʉ mʉjacacʉ mamacʉ o ʉ̃i oteivecʉ máre tʉru cobe ʉ̃mʉjʉricobe jívʉi, cũiná ĩmeje bárica ʉ̃́re judíovai jabʉóvaijãravʉre? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ʉbenita bi arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Dinʉmʉre Jesús jã́rejamed̶a ina cutuimara voivʉre apevʉ pʉeno ne dobarõ mearova. Que baru coyʉrejamed̶a náre yo jã́ri dápiarĩ ne d̶arãjiyepe ainore: ");
INSERT INTO cubNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","—Apecʉ ʉ̃i cuturu mʉre ʉ̃i torojʉve teinoi, apevʉ pʉeno dobabejacʉ dobarõ mearoi. Que d̶aru, ñai torojʉve teino upacʉ cutuyʉ baru apecʉ ʉ̃mʉre, mi pʉeno ne majimʉre, acʉyʉme mʉre: “Jíjacʉ mi dobarõre ñai ʉ̃mʉre”. Que teni cʉyoje teni dobacʉnʉjebu mʉ tʉrʉvaita. ");
INSERT INTO cubNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ʉbenita apecʉ ʉ̃i cuturu mʉre ʉ̃i torojʉve teinoi, dobajacʉ tʉrʉvai. Que d̶aru, dacʉyʉme mi yebai ñai cutuyʉ bácʉ aru acʉyʉme mʉre: “Jícʉ, nʉjacʉ pʉenomaque. Vojacʉ mi dobarõ mearova”. Que teni torojʉrĩ jã́rajarama mʉre caivʉ dobarivʉ mʉ́que tʉoiva yebai. ");
INSERT INTO cubNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Que baru ñai cʉiyʉcʉ me apevʉ pʉeno, parʉbecʉyʉme pʉeno baju. Aru ñai parʉbede d̶aiyʉcʉ ʉ̃i baju apevʉ cãchino, me cʉcʉyʉme pʉeno baju, Jʉ̃menijicʉi mearo d̶acaquiye boje ʉ̃́re, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aru ñai ʉ̃́re cutuyʉ bácʉre máre arejamed̶a Jesús: —Mi torojʉve teinʉmʉ, cutubejacʉ mʉ mi yóvaimarare, aru mívʉre, aru mi cad̶ajĩecavʉ cʉve cʉvarivʉre máre. Que d̶aivʉ baru, nácapũravʉ ne cuturãjiyede mʉre máre ne torojʉve tenajiyede, cʉvacʉyʉmu mʉ mi bojeva. ");
INSERT INTO cubNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ʉbenita mi torojʉve teinʉmʉ cutujacʉ ina cõmaje ãrojarivʉre: cʉve cʉvabevʉre, ijimarare, cuiye majibevʉre, aru jã́ri eabevʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aru torojʉcʉyʉmu mʉ. Nácapũravʉ bʉojabenama bojed̶aivʉ mʉre. Ʉbenita eacʉyʉmu mʉ mi bojeva ina boropatebevʉ ne nacajarajijãravʉ baquinóre yainore jarʉvarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cũinácʉ ʉ̃́que cʉrivʉcacʉ, Jesús ʉ̃i que aiyede jápiayʉ bácʉ, arejamed̶a Jesúre: —¡Torojʉcʉyʉme ñai ãcʉyʉ Jʉ̃menijicʉi jaboteinore! arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús, ʉ̃́re buecʉyʉ, arejamed̶a: —Apenʉmʉ cũinácʉ ʉ̃mʉ torojʉve teinore mead̶aquemavʉ. Aru cutuquemavʉ obedivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Que teni ne ãiora joabejĩnoi ñai torojʉve teino upacʉ ʉ̃i yebacacʉre jaroyʉ, aicõjequemavʉ ʉ̃i cutuimarare yópe: “Jave mead̶acavʉ caiyede mʉjare, que baru ‘Ãradajarã’ aibi ji jabocʉ”, ajacʉ, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ʉbenita ina ʉ̃i cutuimara coapa coyʉrĩ bʉ́quemavʉ nʉiyʉbevʉ ʉ̃i torojʉve teinore. Cũinácʉ ʉ̃i cutuimaracacʉ aquemavʉ: “Mamajiore bojed̶avʉ yʉ. Que baru jã́cʉnʉiye jaʉvʉ yʉre no jiore. Que baru coyʉjacʉ mi jabocʉre, ʉ̃i corebequiyepe yʉre”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Aru apecʉ aquemavʉ: “Caipʉcapʉrʉape paivʉ oteivecʉvare bojed̶avʉ yʉ. Que baru jã́cʉnʉiye jaʉvʉ yʉre náre. Que baru coyʉjacʉ mi jabocʉre, ʉ̃i corebequiyepe yʉre”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Aru apecʉ aquemavʉ: “Pʉrʉbʉovʉ yʉ. Que baru daiye majibevʉ yʉ mi jabocʉi torojʉve teinoi”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Que teni ñai ʉ̃i yebacacʉ copaini coyʉquemavʉ caiye iyede ʉ̃i jabocʉre. ’Ʉ̃i coyʉiyede jápiayʉ bácʉ ñai jabocʉ, jararĩ dápiayʉ, aquemavʉ ʉ̃i yebacacʉre: “Maumejiena nʉjacʉ ĩmarocama ʉramai aru quĩ́jimai máre. Aru davajacʉ ina cõmaje ãrojarivʉre: cʉve cʉvabevʉre, ijimarare, jã́ri eabevʉre, aru cuiye majibevʉre máre”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ñai yebacacʉ ʉ̃i copaiyede, aquemavʉ ʉ̃i jabocʉre: “Mʉ, ji jabocʉ, yópe mi cõjeiyepe d̶avʉ yʉ. Ʉbenita mi ãitucubʉ buibévʉ cãreja”, aquemavʉ ñai yebacacʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Aru ñai jabocʉ aquemavʉ ʉ̃i yebacacʉre: “Ĩmarore jocarĩ nʉjacʉ mʉ. Ma nʉimai nʉjacʉ aru daicõjejacʉ põevare ji torojʉve teinoi, ji cʉ̃rami buiquíyepe. ");
INSERT INTO cubNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Coyʉyʉbu mʉre: Caivʉ ina ji cutuimara mácavʉ ãmenajarama ji torojʉve teinoque ãiyede”, aquemavʉ ñai jabocʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mái nʉiyede obedivʉ põeva yóvarejaimad̶a Jesúre. Aru ʉ̃ copedini, jã́ri, arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ácʉ põecʉ ʉ̃i daru ji yebai, ji bueimaracacʉ bacʉyʉ́, yʉre jecʉé jaʉvʉ ʉ̃́re caivʉ pʉeno baju. Que baru ʉjacʉrĩ yʉre jípacʉ, jípaco, jímarepaco, mamara, jíbʉrã, ĩmara, aru ʉ̃i baju máre pʉeno baju. ");
INSERT INTO cubNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ácʉ põecʉ daiyʉcʉ yʉ́que, dajocajacʉrĩ põeva ne mearo jã́iyede ʉ̃́re, cʉyebejacʉrĩ yʉre yóvaiyede, aru jidʉbejacʉrĩ ʉ̃i ñájiquiyede. Nópe d̶abecʉ baru, ʉ̃ bʉojabebi jícʉ bacʉyʉ́. ");
INSERT INTO cubNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ácʉ mʉjacacʉ cʉ̃rami ʉrad̶ãmi d̶aiyʉcʉ baru, dápiarĩ dobajebu, corevacʉyʉ aipino bojecʉrõre diñamine aru ʉ̃i bʉojaquinore máre. ");
INSERT INTO cubNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","Iñamine d̶arĩ bʉ́rĩburu yóboi, ñai cʉ̃ramine d̶ayʉ ʉ̃i bʉojabedu, caivʉ ina jã́ivʉ ʉ̃́re yʉrinajarama yópe aivʉ: “Ñai ʉ̃mʉ cʉ̃ramine d̶arĩ bʉ́cʉbe. Ʉbenita bʉojabebi caride”. ");
INSERT INTO cubNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Aru ácʉ jabocʉ dápiarĩ dobajebu, ʉ̃ jina caipʉcapʉrʉape paimil baju churaravaque boaiyʉcʉ baru apecʉ jabocʉ veinte mil paivʉ baju churarava cʉvacʉque ãd̶amatecʉdayʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aru boarĩ́ bʉojaiyʉbecʉ baru ʉ̃i boro nʉvaipõevare coyʉrĩ jarocʉyʉme ʉ̃i maucʉ joai cʉedeca cãreja, “Boaiyʉbevʉ yʉ” arĩ jaroyʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Que baru me dápiaiye jaʉvʉ mʉjare jipocamia, ji bueimara márajivʉ baru. Mʉja dajocabevʉ baru mʉje cʉvaede, ji bueimara teivʉ bʉojabenamu mʉja, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Bedióva cojedeca arĩ buedejamed̶a Jesús náre: —Mead̶aivʉ maje ãiyede yuquiraque. Nopedeca ñájiye mead̶aivʉ põevare. Yuquira maje ãiyede mead̶aivʉ. Ʉbenita yuquira vaijʉe bíjaru, ãiyede mead̶aiye bʉojabevʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Joborõre aru oteiye ʉ̃rojʉrõre máre mead̶aiye bʉojabevʉ. Quédata põeva jarʉvad̶ama iye yuquira meamene. Nopedeca Jʉ̃menijicʉi põeva ʉ̃i ʉrõpe d̶arĩ dajocaivʉ baru, mead̶arĩ bʉojabenama ijãravʉcavʉre. Me jápiajarã mʉja iye ji bueiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Apenʉmʉ earejaimad̶a Jesús yebai obedivʉ Roma ãmicʉrõ jaboteino jabovare tãutʉra ĩcaipõeva aru ãmeno d̶aipõeva máre, jápiarãeaivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseova aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre borotedejaimad̶a, ne bajumia aivʉ: —Ñai ʉ̃mʉ copʉ etaibi ãmeno d̶aipõevare aru ãimi náque, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ne que aiye boje, Jesús coyʉrejamed̶a náre yo jã́ri dápiarĩ ne d̶arãjiyepe ainore: ");
INSERT INTO cubNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Mʉjacacʉ ovejavare coreipõecʉ cʉvacʉ baru cien paivʉ ovejavare, aru cũinácʉ nácacʉ ʉ̃i mamatedu, ñai dajocajebu ina noventa y nueve paivʉ ovejavare põecʉbenoi, vocʉñʉ ñai bíjayʉ bácʉre ʉ̃́re earĩta. ");
INSERT INTO cubNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aru ʉ̃́re earĩ, ĩni, arʉboi tʉorĩ, torojʉrĩ nʉvajebu ñai ovejare ʉ̃i cʉ̃ramita. ");
INSERT INTO cubNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cʉ̃rami earĩ, órejajebu ʉ̃i yóvaimarare aru ʉ̃i cad̶ajĩecavʉre máre. Aru ajebu náre yópe: “Torojʉjarã yʉ́que, ji oveja bíjayʉ bácʉre ji eaiye boje”, ajebu. ");
INSERT INTO cubNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nopedeca coyʉyʉbu mʉjare: Ina cavarõ mearo Jʉ̃menijicʉi cʉrõcavʉ torojʉrãjarama cũinácʉ ãmeno d̶aipõecʉ chĩori, oatʉvaru ʉ̃i d̶aiyede, apevʉ noventa y nueve paivʉ pʉeno, ina “Chĩori oatʉvaiye jaʉbevʉ yʉre”, arĩ dápiaivʉ, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Cojedeca Jesús coyʉrejamed̶a apeno jã́ri dápiarĩ ne d̶arãjiyepe ainore, náre buecʉyʉ: —Cũináco nomió cʉvaco baru pʉcapʉrʉape paitʉrava tãutʉratʉravare aru cũinátʉrava bíjaru ṍre, ico nomió pẽoibʉre pẽori, õi cʉ̃ramine oeni, vojebu pʉ ditʉravare earĩta. ");
INSERT INTO cubNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ditʉravare earĩ, ĩni, epeni, torojʉrĩ órejajebu õi yóvaimarare aru õi cad̶ajĩecavʉre máre. Aru ajebu náre yópe: “Torojʉjarã yʉ́que, ji tãutʉratʉrava bíjaino mácarõre ji eaiye boje”, ajebu. ");
INSERT INTO cubNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nopedeca coyʉyʉbu mʉjare: Ina Jʉ̃menijicʉi ángeleva torojʉrãjarama cũinácʉ ãmeno d̶aipõecʉ chĩori, oatʉvaru ʉ̃i d̶aiyede, arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Cojedeca Jesús coyʉrejamed̶a apeno jã́ri dápiarĩ ne d̶arãjiyepe ainore, náre buecʉyʉ: —Cũinácʉ ʉ̃mʉ cʉvatequemavʉ pʉcarã mamara. ");
INSERT INTO cubNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Aru ñai ĩmacʉcapũravʉ pued̶abecʉ jípacʉre aquemavʉ: “Mʉ, jipacʉ, jíjacʉ yʉre, ‘Míye baquiyébu’, mi aiye báquede yʉre”, aquemavʉ. (Mamacʉ nópe ayʉ jípacʉre, “Mi yaiquínore ʉvʉ yʉ”, ayʉbe ʉ̃.) Dinʉmʉma népacʉ jíquemavʉ diede náre coapa. ");
INSERT INTO cubNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Obebejãravʉa yóboi, ñai ĩmacʉ caiye ʉ̃i apejĩene mead̶arĩ, ĩni, nʉquemavʉ joai, apeno joborõi. Aru noi jarʉvaquemavʉ caiye ʉ̃i cʉvaede ʉ̃i ʉrõpe d̶arĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aru ʉ̃i jarʉvarĩburu yóboi caiye ʉ̃i cʉvae báquede, ãvʉé daquemavʉ caino no ʉ̃i cʉrijoborõre. Que baru ʉ̃ ʉrarõ ñájiquemavʉ ãvʉéna. ");
INSERT INTO cubNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nʉri, memeino voquemavʉ apecʉ ʉ̃mʉ, dijoborõcacʉre. Que teni ñai jaroquemavʉ ʉ̃́re, coreicõjeñʉ oteivãrivare. ");
INSERT INTO cubNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aru ãiyʉtequemavʉ oteivãriva ne ãinore. Ʉbenita ñame jíbetequemavʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ãrʉri earĩ, dápiarĩ aquemavʉ ʉ̃i baju: “Caivʉ ina jipacʉre memecaivʉ cʉvarãma ʉrarõ ne ãiye méne aru pʉpʉiye máre. Ʉbenita yʉ yaiyʉ́tamu ãvʉéna. ");
INSERT INTO cubNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Caride copaiquijivʉ jipacʉ yebai. Coyʉquijivʉ ʉ̃́re yópe: ‘Mʉ, jipacʉ, ãmeno d̶avʉ yʉ Jʉ̃menijicʉre aru mʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Que baru “jímacʉ”, abejacʉ yʉre caride. Jã́jacʉ yʉre yópe mi jã́iyepe cũinácʉ memecayʉre mʉre’ ”, arĩ dápiaquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Que teni nacajari nʉquemavʉ jípacʉ yebai. Aru jípacʉ dayʉre jã́ri joamica, cõmaje ãroje jã́quemavʉ ʉ̃́re. Que baru cúyarĩ, copʉ nʉri, ʉ̃́re narióquemavʉ. Aru ʉ̃i viobʉrã nuquemavʉ mamacʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aru mamacʉ aquemavʉ ʉ̃́re: “Mʉ, jipacʉ, ãmeno d̶avʉ yʉ Jʉ̃menijicʉre aru mʉre máre. Que baru ‘jímacʉ’, abejacʉ mʉ yʉre caride”, aquemavʉ jípacʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ʉbenita jípacʉ aquemavʉ ʉ̃́re memecaivʉre: “Davacajarã maumejiena ʉ̃́re meacaje cuitótecajede. Doajarã ʉ̃́re. Ad̶ajarã ãmuyo ad̶aitarabʉre máre. Aru cʉraidoare máre doajarã ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Davajarã ñai oteivecʉ mamacʉ me jiacʉcʉre. Boajárã, ãmuri, torojʉve tenajivʉ caivʉ ĩmarocavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ñai jímacʉ yaiyʉ́ bácʉpe páyʉ ũmedayʉpebe cojedeca. Javede bíjame yʉre jocarĩ. Ʉbenita eaivʉ ʉ̃́re cojedeca”, aquemavʉ jípacʉ. Aru torojʉve teni bʉ́quemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Que teiyedeca, jíbʉcʉ memeñʉ matequémavʉ jioi. Copaini cʉ̃rami, joabejĩnoi jápiaquemavʉ ne upaiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Aru cũinácʉ memecaipõecʉre órejarĩ, jẽniari jã́quemavʉ ʉ̃́re, “¿Aipe teni upaivʉba na?” ");
INSERT INTO cubNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jʉ aquemavʉ ʉ̃́re: “Míyocʉ copaini dacʉbe. Que baru mipacʉ boaicõjemi ñai oteivecʉ me jiacʉcʉre, mamacʉ meacʉre copʉ etaiye boje”, aquemavʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ʉbenita ñai jíbʉcʉ jarayʉ, torojʉve teinoi ecoiyʉbetequemavʉ. Que baru jípacʉ, etarĩ ʉ̃i yebai, jẽniaquemavʉ ʉ̃́re: “Mʉ, bʉcʉ, ecorĩ, ãjacʉ”. ");
INSERT INTO cubNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ʉbenita aquemavʉ jípacʉre: “Obediʉjʉa memecaivʉ mʉre yebacacʉpe. Aru cainʉmʉa jʉ aivʉ mʉre aru mi cõjeiyede d̶aivʉ. Ʉbenita yʉre mʉ jíbevʉ cũinájieneca cũinácʉ oteiãimajicʉre, ñʉje ãrajiyepe ji yóvaimaraque torojʉve teinoi. ");
INSERT INTO cubNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ʉbenita ñai mímacʉ ʉ̃i eaiyede, mi jíye báquede ʉ̃́re jarʉvayʉ bácʉreca nomiva ãmenaque, boacáicõjenebu mʉ ʉ̃́re oteivecʉ me jiacʉcʉre”, aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aru jípacʉ aquemavʉ ʉ̃́re: “Mʉ, bʉcʉ, mʉ cʉvʉ yʉ́que cainʉmʉa. Aru caiye ji cʉvae míyetamu. ");
INSERT INTO cubNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ñai míyocʉ yaiyʉ́ bácʉpe páyʉ apʉcʉpebe cojedeca. Ñai bíjayʉ bácʉ eaimʉme caride. Que baru torojʉve teiye jaʉvʉ majare”, aquemavʉ népacʉ, arĩ coyʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús coyʉrejamed̶a ʉ̃i bueimarare, yópe arĩ: —Cʉ́tequemavʉ cũinácʉ ʉ̃mʉ cʉve cʉvacʉ. Cʉvatequemavʉ cũinácʉ ʉ̃i cʉvaede coreyʉre. Aru apevʉ coyʉquemavʉ ñai cʉve cʉvacʉre yópe: “Ñai mi coreipõecʉ jarʉvavaibi caiye mi cʉvaede”, aquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Que baru ñai cʉve cʉvacʉ órejaicõjeni ñai coreipõecʉre ʉ̃i yebai, aquemavʉ ʉ̃́re: “¿Aipe jápiayʉba yʉ mi borore? Jã́d̶ovajacʉ yʉre mi toivarĩ cʉvarõre, ji majiquiyepe aipino mi jacopʉiyede aru aipino mi jíyede ji cʉvede. Caride memecabecʉyʉmu mʉ yʉre cojedeca”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Que baru ñai coreipõecʉ ʉ̃i baju dápiarĩ aquemavʉ: “¿Aipe tequidi yʉ? Ji jabocʉ ĩ́mi yʉre ji memeinore jarʉvarĩ. Joborõre ũri bʉojabevʉ yʉ, ji parʉbe boje. Aru tãutʉrare jẽniari cʉyevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jave majivʉ yʉ ji d̶aquinore, cʉvacʉyʉ põeva ne copʉ etarãjiyepe ayʉ yʉre ne cʉ̃ramiai ji memeino cʉvabede”, arĩ dápiaquemavʉ ñai coreipõecʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Que baru ñai coreipõecʉ órejaquemavʉ náre coapa ina bojecʉbe d̶aivʉre ʉ̃i jabocʉre, coreóvabevʉreca ʉ̃́re memeino cʉvabecʉre. Aru ñai mamarʉmʉre ʉ̃i órejaimʉre jẽniari jã́quemavʉ: “¿Aipino bojecʉbe d̶ayʉrʉ̃ mʉ ji jabocʉre?” aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jʉ aquemavʉ ʉ̃: “Cien paibʉa jocʉbʉa olivocʉ ãmicʉricʉ jẽidʉare pipoicorore bojecʉbe d̶aivʉ yʉ ʉ̃́re”, aquemavʉ. Aru ñai coreipõecʉ aquemavʉ ʉ̃́re: “Ʉ̃jʉ, jẽjacʉ mi bojecʉbe d̶aino cʉriyocare. Maumejiena dobarĩ oatʉvarĩ toivajacʉ iyede: ‘Cincuenta paibʉa bajura’ ”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Dinʉmʉma ñai coreipõecʉ jẽniari jã́quemavʉ apecʉ bojecʉbe d̶ayʉre: “¿Aipino bojecʉbe d̶ayʉrʉ̃ mʉ ji jabocʉre?” aquemavʉ. Jʉ aquemavʉ ʉ̃: “Cien paipʉea trigo ãmicʉe oteiyede bojecʉbe d̶aivʉ yʉ ʉ̃́re”, aquemavʉ. Aru ñai coreipõecʉ aquemavʉ ʉ̃́re: “Ʉ̃jʉ, jẽjacʉ mi bojecʉbe d̶aino cʉriyocare. Aru oatʉvarĩ, toivajacʉ iyede: ‘Ochenta paipʉea bajura’ ”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Aru ñai jabocʉ, jã́ñʉ ʉ̃i borocʉrĩ majinore, aquemavʉ ñai coreipõecʉi borore: “Ñai ʉ̃mʉ borocʉcʉvacari me majibi ʉ̃”, aquemavʉ. Ina ijãravʉcavʉ Jʉ̃menijicʉre ʉbevʉ, ne cʉvae méne aru ne me cʉede máre ĩni majima, aru me bajura ne tãutʉrare earĩ majima ina Jʉ̃menijicʉre jʉ aivʉ pʉeno, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesús arĩ buedejamed̶a náre cojedeca: —Mʉje cʉvaede jíyede cõmaje ãrojarivʉre, na pued̶arãjarama mʉjare. Mʉje nópe d̶aru, Jʉ̃menijicʉ jícʉyʉme mʉjare mʉje cʉrõ cũiménore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Bedióva cojedeca Jesús coyʉrejamed̶a ina põevare: —Ñai mearo d̶arĩ epeyʉ baru quĩ́jinore, dinʉmʉre mearo d̶arĩ epecʉyʉme ʉrarõre máre. Aru ñai quĩ́jino ʉ̃i cʉvarõque borocʉcʉ baru, ʉrarõ ʉ̃i cʉvarõque máre borocʉcʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Que baru ijãravʉi cʉrivʉ mearo d̶abevʉbu mʉja mʉje cʉvaede. Que d̶aivʉ, mʉjare Jʉ̃menijicʉi jíyede mearo d̶abenamu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Que baru apecʉi jíyede mearo d̶abedu, ñame bʉojarĩ jíbenama mʉjeneca. ");
INSERT INTO cubNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Cũinácʉ Jʉ̃menijicʉre ãrʉcʉ baru, pare ãrʉmemi tãutʉrare. Aru tãutʉrare pare ãrʉcʉ baru, ãrʉmemi Jʉ̃menijicʉre. Que baru Jʉ̃menijicʉre aru tãutʉrare máre ãrʉmejara mʉja. Ñai tãutʉrare ʉcʉ baru, Jʉ̃menijicʉre ʉbecʉyʉme ʉ̃, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ina fariseova tãutʉrare pare ʉrejaimad̶a na. Que baru iye Jesús ʉ̃i coyʉiye báquede jápiaivʉ bácavʉ ʉ̃́re yʉridejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ʉbenita Jesús arejamed̶a náre: —Põeva ne jã́iyede mearape paivʉbu mʉja. Ʉbenita Jʉ̃menijicʉ majibi mʉje dápiainore. Põeva ne mearo jã́iyede Jʉ̃menijicʉ ʉbebi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesús, yópe arĩ, buedejamed̶a náre cojedeca: —Juan Bautista bácʉ ʉ̃i cʉrinʉmʉ mácarõ baji cʉrejaquemavʉ Jʉ̃menijicʉi d̶aicõjeiye Moisés bácʉre toivaicõjeni bueiye báque aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ toivarĩ bueiye báque máre. Dinʉmʉ mácarõre Juan Bautista bácʉ coyʉáme Jʉ̃menijicʉi jaboteinoquede aru ʉ̃i yóbore máre coyʉivʉbu iye yávaiye méne. Aru caivʉ põeva pare ted̶ama ecoiyʉrivʉ Jʉ̃menijicʉi jaboteinore. ");
INSERT INTO cubNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Caino cavarõ aru caino joborõ máre cũiye maiyójabevʉ. Ʉbenita caiye iye Jʉ̃menijicʉi d̶aicõjeiye cũiye maiyójavʉ. Quénora caiye jãve vaiquíyebu yópe Jʉ̃menijicʉi d̶aicõjeiyepe, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Bedióva cojedeca Jesús arĩ buedejamed̶a ina põevare: —Ácʉ põecʉ jímarepacore jarʉvarĩburu yóboi pʉrʉbʉoyʉ baru apecoque, nomicʉcʉvacari apecoque cʉcʉ baru, ãmeina d̶aibi ṍre ʉ̃i mamarʉmʉcacore jarʉvarĩ. Aru ácʉ põecʉ pʉrʉbʉoyʉ baru cũináco nomió jímarepacʉ mamarʉmʉcacʉ ʉ̃i jarʉvaimore ãmeina d̶aibi ṍque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús coyʉrejamed̶a ina põevare cojedeca: —Cũinácʉ ʉ̃mʉ cʉve cʉvacʉ cʉ́tequemavʉ. Pare meacaje cuitótecajede dorĩ torojʉve teni, javatequemavʉ jãravʉa coapa. ");
INSERT INTO cubNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Aru apecʉ ʉ̃mʉ cʉve cʉvabecʉ cʉ́tequemavʉ, ʉ̃i ãmiá Lázaro. Ʉ̃ pã́tequemavʉ ñai cʉve cʉvacʉ ʉ̃i cʉ̃rami jedevacobe yebai. Churiá ijié cʉ́tequemavʉ ñai Lázaro. ");
INSERT INTO cubNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ãiyʉrĩduquemavʉ ãiye tʉiye báquede ñai ʉ̃mʉ cʉve cʉvacʉ ʉ̃i tʉoivare jocarĩ. Aru yavimiva darĩ nenequemavʉ ʉ̃i churiáre. ");
INSERT INTO cubNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cũinájãravʉ ñai cʉve cʉvabecʉ, Lázaro bácʉ, yaiquémavʉ. Aru ángeleva nʉvaquemavʉ ʉ̃́re Abraham yebai. Ñai cʉve cʉvacʉ bácʉ máre yaiquémavʉ. Aru ʉ̃i bajure jarʉvaquemavʉ cʉ̃racobei. ");
INSERT INTO cubNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nʉquemavʉ ʉ̃ toabo cũiméboi. ’Noi pare ñájiñʉ, jã́quemavʉ joai Abrahãre aru Lázarore máre. ");
INSERT INTO cubNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Que baru órejaquemavʉ, ayʉ yópe: “Mʉ, jícʉ, Abraham, cõmaje ãroje jã́jacʉ yʉre. Darojacʉ Lázarore ji yebai ʉ̃i ocoque jórĩ neneóvaquiyepe ãmuyoque ji jemedore, cojʉjovacʉyʉ yʉre. Pare ñájivʉ yʉ yo toaboi”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ʉbenita Abraham aquemavʉ ʉ̃́re: “Mʉ, jícʉ, ãrʉjacʉ mʉ caiye iye méne mi cʉvavaquede apʉcʉ cãreja. Aru Lázaro apʉcʉ cãreja ñájiquemavʉ ʉrarõ ãmenore. Ʉbenita caride torojʉbi ʉ̃ yore, aru ñájivʉ mʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Maje coricai cʉvʉ ʉrarõ tʉ̃robʉ. Que baru ñʉjacavʉ jataiyʉrivʉ bʉojabema nʉivʉ nore. Nopedeca nócavʉ máre jataiyʉrivʉ bʉojabema daivʉ yore”, aquemavʉ Abraham. ");
INSERT INTO cubNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","’Dinʉmʉma aquemavʉ ñai cʉve cʉvacʉ: “Mʉ, jícʉ, jẽniaivʉ mʉre. Jarojacʉ Lázarore jipacʉ bácʉi cʉ̃rami, ʉ̃i coyʉquiyepe ayʉ jíyova cũinápʉrʉpe paivʉre, ne ñájimenajiyepe ayʉ yore”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ʉbenita Abraham aquemavʉ yópe: “Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i toivaicõjeiye báquede Moisés bácʉre aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivaiye báquede máre cʉvama na. Que baru míyova jápiajarãri diede”, aquemavʉ Abraham. ");
INSERT INTO cubNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ʉbenita aquemavʉ ñai cʉve cʉvacʉ: “Mʉ, jícʉ, Abraham, ina jápiabevʉvacari iye Jʉ̃menijicʉi yávaiyede, cũinácʉ yainore jarʉvarĩ copainʉru náre, chĩori oatʉvarãjarama ne d̶aiyede”, aquemavʉ Abrahãre. ");
INSERT INTO cubNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aru Abraham aquemavʉ ʉ̃́re: “Ina põeva jápiabevʉ baru Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i toivaicõjeiye báquede Moisés bácʉre aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivaiye báquede máre, jápiabenama cũinácʉ nacajañʉreca yainore jarʉvarĩ”, aquemavʉ Abraham, arĩ coyʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús buedejamed̶a ʉ̃i bueimarare, yópe arĩ: —Jãve jʉjovarãjarama mʉjare. Ʉbenita ñai jʉjovare d̶ayʉ apevʉre chĩori ãmeno ñájicʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ñai põecʉ ʉ̃i vainí tʉre d̶aru apecʉ yʉre jʉ ayʉre parʉbecʉreca, ʉ̃i dajocaquiyepe ayʉ ʉ̃i jʉ aiyede yʉre, meajebu ʉ̃́re jarʉvaru jia ʉrad̶ai ʉ̃i ñamemui bʉorĩ cũinábo cʉ̃rabo ʉraboque. ");
INSERT INTO cubNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Me jã́jara mʉja. Me dápiajarã mʉje d̶arãjiyede. Apecʉ ʉ̃i ãmeno d̶aru mʉre, majicajacʉ ʉ̃́re ména. Aru ʉ̃i chĩori oatʉvaru ʉ̃i d̶aiyede, ãrʉmetejacʉ iye ʉ̃i ãmeno d̶aiye báquede mʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aru ʉ̃i ãmeno d̶aru mʉre siete paiye baju cũinájãravʉre aru siete paiye bajureca, “Chĩoivʉ yʉ ji ãmeno d̶aiye báquede mʉre” ʉ̃i aru, ʉ̃i ãmeno d̶aiyede ãrʉmetejacʉ mʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ina Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara arejaimad̶a Jesúre yópe: —¡Cad̶atejacʉ ñʉjare, ñʉje jʉ arãjiyepe mʉre pʉeno baju! ʉ̃́re arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aru Jesús arejamed̶a: —Oteiye mostaza ãmicʉe oteiye quĩ́jietamu. Ʉbenita pĩaríburu yóboi jocʉcʉ ʉracʉtamu. Nopedeca mʉje jʉ aru yʉre quĩ́jino, nópe quĩ́jie oteiyepe, Jʉ̃menijicʉ ʉrarõ mearore d̶ajebu mʉjare. Mʉja me jʉ arĩ Jʉ̃menijicʉre, mʉje aru icʉ jocʉcʉ ʉracʉre yópe: “Nʉjacʉ caiye mi nʉoque. Aru nʉri nújacʉ jia ʉrad̶ai”, dicʉ jʉ ajebu mʉje cõjeinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesús arĩ buedejamed̶a cojedeca: —Mʉjare memeni coreyʉre jiore o coreyʉre ãimarare ʉ̃i copaidaiyede cʉ̃rami, “Maumena darĩ, ãcʉdajacʉ”, abevʉ mʉja ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Quédata, “Mead̶ajacʉ ji ãquiyede. Oatʉvajacʉ mi doiyede. Aru corejacʉ ji ãiyede cãreja. Ji ãriburu yóboita mʉ máre ãri ũcujacʉ”, aivʉbu mʉja ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Aru ñai jabocʉ jãve abecʉbe ʉ̃i yebacacʉre, “Meavʉ mi memecaino yʉre”, ʉ̃i d̶aicõjeiye báquepe d̶aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nopedeca mʉja máre, caiye iye d̶aicõjeiye báquepe mʉjare d̶arĩ bʉojaivʉ, ajarã mʉje baju yópe: “Bojecʉbevʉbu maja. Quénora d̶aivʉbu maja yópe Jʉ̃menijicʉi d̶aicõjeiyepe majare”, náre arĩ buedejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús nʉñʉ Jerusalén ãmicʉriĩmaroi, vaidéjamed̶a Samaria aru Galilea ãmicʉrijoborõa tʉrʉvare. ");
INSERT INTO cubNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cũináro ĩmajinoi ecoiyede, copʉ nʉrejaimad̶a ʉ̃́re caipʉcapʉrʉape paivʉ ʉ̃mʉva pojeivʉ. Núrejaimad̶a joai Jesúre jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Aru cod̶oboborejaimad̶a na: —Mʉ, Jesús, bueipõecʉ, cõmaje ãroje jã́jacʉ ñʉjare, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Náre jã́ri, arejamed̶a Jesús: —Nʉri jã́d̶ovajara sacerdotevare, arejamed̶a. Nópe arejamed̶a, judíova ne d̶aiye boje Jʉ̃menijicʉi d̶aicõjeiyepe. Aru ne nʉiyedeca mái, meatedejaimad̶a ne pojeiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Que teni cũinácʉ nácacʉ jã́ri coreóvarĩ meateyʉ ʉ̃i baju, copaini nʉri cod̶oboborĩ torojʉrejamed̶a Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Mori tʉrejamed̶a joborõi Jesús jipocai, jíyʉ mearore ʉ̃́re. Aru Samaria ãmicʉrijoborõcacʉ barejaquémavʉ ñai ʉ̃mʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Que teni Jesús arejamed̶a: —Caipʉcapʉrʉape paivʉ meatevʉ mʉja. ¿Ã́rima apevʉ, ina nueve paivʉ? ");
INSERT INTO cubNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Apevʉ cʉbema ina jínadajʉrorivʉ mearore Jʉ̃menijicʉre. Quénora ñai dacʉbe, apeno joborõcacʉvacari, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aru Jesús arejamed̶a ʉ̃́re: —Nacajari nʉjacʉ mʉ. “Ʉ̃ yʉre mead̶aiye majibi”, arĩ dápiarebu mʉ yʉre. Que baru, mi que dápiaiye boje, mead̶aivʉ mʉre, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Cũinájãravʉ apevʉ fariseovacavʉ jẽniari jã́rejaimad̶a Jesúre, yópe arĩ: —¿Aipiyede edaquidica yo Jʉ̃menijicʉi jaboteino maquinó? arejaimad̶a na. Jesús arejamed̶a náre: —Jʉ̃menijicʉi jaboteinore jã́ri majibevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Que baru abenajarama yópe: “¡Jã́jacʉ, yui cʉvʉ!” Aru abenajarama yópe: “¡Jã́jacʉ, noi cʉvʉ!” Quédata jave Jʉ̃menijicʉ jaboteyʉbe mʉje jẽneboi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Dinʉmʉre Jesús arejamed̶a ʉ̃i bueimarare: —Jãravʉa cʉquiyebu mʉje jã́iyʉrijãravʉa yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, cũinájãravʉra. Ʉbenita jã́menajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Aru arãjarama mʉjare yópe: “¡Jã́jara noi!” Aru arãjarama yópe: “¡Jã́jara yui!” Ʉbenita nʉmejara mʉja. Nʉmejara ne yóboi. ");
INSERT INTO cubNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe yaroinope nʉquiyebu ji copaidaquijãravʉ baquinó. Yópe no yaroino pẽoiyepe cavarõre cũinápũravʉ pʉ apepũravʉita, caivʉ põeva ne jã́rajiyepe nore, nopedeca copaidacʉyʉmu yʉ. Aru caivʉ põeva jã́rajarama ji copaidaiyede ijãravʉi. ");
INSERT INTO cubNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ʉbenita mamarʉmʉ ʉrarõ ñájiye jaʉvʉ yʉre. Aru ijãravʉcavʉ jʉ abenajarama yʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Dijãravʉa baquiyéi, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji copaidaquijãravʉ jipocai, cʉquiyebu nópe ãnijãravʉa Noé mácʉi cʉrijãravʉa báquepe. ");
INSERT INTO cubNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dinʉmʉ mácarõre caivʉ põeva ãivʉ barejaquémavʉ, aru ũcuivʉ barejaquémavʉ. Ʉ̃mʉva pʉrʉbʉoivʉ barejaquémavʉ. Aru jídejaquemavʉ némaromivare, ne pʉrʉbʉorãjiyepe aivʉ, Noé mácʉi jiad̶ocũ ʉracũre ecoijãravʉita. Muiváibo darejaquemavʉ. Aru caivʉ ina põeva corĩ bíjarejaquemavʉ na mácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nopedeca cʉrejaquemavʉ Lot bácʉi cʉrijãravʉa báquede máre. Caivʉ põeva ãivʉ barejaquémavʉ, aru ũcuivʉ barejaquémavʉ. Bojed̶aivʉ barejaquémavʉ. Oteivʉ barejaquémavʉ. Aru cʉ̃ramiare d̶aivʉ barejaquémavʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ʉbenita ãnijãravʉ bácarõ, Lot bácʉi etaiyede Sodomare jocarĩ, Jʉ̃menijicʉ maumena darorejaquemavʉ toabore aru cʉ̃raboa uruiboare máre. Ocainope tʉrejaquemavʉ cavarõre jocarĩ. Aru caivʉ ina diĩmarocavʉ bácavʉ yaidéjaquemavʉ na mácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nopedeca baquiyébu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji copaidaquijãravʉ baquinóre. Maumena, põeva yʉre ne corebede, copaidacʉyʉmu yʉ ijãravʉi cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Dijãravʉ baquinói ñai cʉ̃rami pʉenora cʉcʉ bacʉyʉ́ ẽmeni dabejacʉrĩ, nʉvacʉyʉ ʉ̃i apejĩene. Ecobejacʉrĩ ʉ̃i cʉ̃rami. Aru ñai jiore memeñʉ macʉyʉ́ copainʉmejacʉrĩ ʉ̃i cʉ̃rami. ");
INSERT INTO cubNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ãrʉjara mʉja iye Lot bácʉi márepaco bácore vaiye báquede. Õ mácoi jʉ abe boje Jʉ̃menijicʉi cõjeiye báquede, yuquirarʉ cainidʉ tedejaquemavʉ õ máco. ");
INSERT INTO cubNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ñai põecʉ ʉ̃i baju ʉrõpe d̶arĩ, mead̶aiyʉcʉ baru ʉ̃i bajure, coatecʉyʉme ʉ̃i bajure Jʉ̃menijicʉre jarʉvarĩ, yópe yaiyʉ́ bácʉpe ʉ̃i ũmei. Ʉbenita ñai põecʉ, “Ye baju ãmevʉ ji yaidú Cristore boje” ayʉ, ʉ̃i baju ʉrõpe d̶abecʉva quénora ji ʉrõpe d̶arĩ, ʉ̃́recabe ji mead̶aquimʉ, cʉcʉyʉ Jʉ̃menijicʉque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Coyʉyʉbu mʉjare, ji copaidaquijãravʉ baquinói pʉcarã ʉ̃mʉva cãrajarama ne cʉ̃rami jívʉi ñamine. Cũinácʉ nʉvaimʉ macʉyʉ́me, yʉre ʉ̃i jʉ aiye boje. Aru apecʉ mautecʉyʉme, yʉre ʉ̃i jʉ abe boje. ");
INSERT INTO cubNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Aru pʉcarã nomiva jĩorajarama ne cʉ̃rami jívʉi. Cũináco nʉvaimo macod̶óme, yʉre õi jʉ aiye boje. Aru apeco mautecod̶ome, yʉre õi jʉ abe boje. ");
INSERT INTO cubNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aru pʉcarã ʉ̃mʉva memenajarama ne jioi. Cũinácʉ nʉvaimʉ macʉyʉ́me, yʉre ʉ̃i jʉ aiye boje. Aru apecʉ mautecʉyʉme, yʉre ʉ̃i jʉ abe boje, arejamed̶a Jesús, náre bueyʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aru jẽniari jã́rejaimad̶a ʉ̃́re: —Mʉ, ñʉje jabocʉ, ¿ã́ri yópe vaiquídi caiye iye? arejaimad̶a Jesúre. Aru arejamed̶a náre majidivʉ ne aino mácarõque yópe: —Ã́ri yaiyʉ́ bácʉi cʉrõi, noi cójijinajarama cavava. Caiye iye ji coyʉiyede jã́ivʉ, majinajaramu mʉja ji copaidaquino joabenore, ji ñájiovaquinore põevare, ne ãmeina teiye boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús buedejamed̶a põevare jã́ri dápiarĩ ne d̶arãjiyepe ainoque ne jẽniarajiyepe ayʉ Jʉ̃menijicʉque cainʉmʉa dajocabevʉva. ");
INSERT INTO cubNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Aru arejamed̶a: —Cũináĩmaroi cʉ́tequemavʉ cũinácʉ jabocʉ, ãmeina teivʉre jẽniari jã́ipõecʉ. Ñai jabocʉ pued̶abetequemavʉ Jʉ̃menijicʉre. Aru pued̶abetequemavʉ põevare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Diĩmaromiareca cʉ́tequemavʉ cũináco nomiópeco máre. Õ nʉri, yávare nʉrejaquemavʉ ʉ̃́re: “Cad̶atejacʉ yʉre, ji maucʉ ʉ̃i ñájine d̶abequiyepe yʉre”, aquemavʉ õ. ");
INSERT INTO cubNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Obedijãravʉare ñai jabocʉ jápiabetequemavʉ ṍre. Ʉbenita no yóboi arĩ dápiaquemavʉ ʉ̃i baju: “Yʉ pued̶abecʉvacari Jʉ̃menijicʉre aru pued̶abecʉvacari põevare máre, ico nomió, ji yebai dad̶o jãravʉa coapa, õi pare cãrijovaiye boje yʉre, cad̶atequijivʉ ṍre, õi ʉetʉre d̶abecojiyepe yʉre”, aquemavʉ ʉ̃, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aru Jesús arejamed̶a: —Jápiajarã ñai ʉ̃mʉ ãmecʉ ʉ̃i aiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Aru jãve cad̶atecʉyʉme Jʉ̃menijicʉ ina ʉ̃i beoimarare jẽniaivʉre ʉ̃́re, ʉ̃i cad̶atequiyepe aivʉ náre jãravʉre aru ñamine máre. Corede d̶abecʉbe ʉ̃ joe baju, cad̶atecʉyʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Coyʉyʉbu mʉjare: Maumejiena cad̶atequijibi náre. Ʉbenita yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji copaidaiyede ijãravʉi, jãve obebejĩna põeva jʉ aivʉre Jʉ̃menijicʉre parʉriũmeque eacʉyʉmu, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Bedióva Jesús buedejamed̶a náre jã́ri dápiarĩ ne d̶arãjiyepe ainoque. Coyʉrejamed̶a ina põevare “¿Meara márica?” arĩ dápiaivʉre ne baju apevʉ pʉeno. Arejamed̶a: ");
INSERT INTO cubNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Pʉcarã ʉ̃mʉva Jʉ̃menijicʉque jẽniaranʉquemavʉ Jʉ̃menijicʉi cʉ̃rami. Cũinácʉ fariseovacacʉ batequémavʉ. Aru apecʉ jabovare tãutʉra ĩcaipõecʉ batequémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ñai fariseo núri jẽniari dápiaquemavʉ ʉ̃i baju yópe: “Mʉ, ji mearore jímʉ, torojʉede jívʉ mʉre, ji ãmed̶abe boje. Yʉ apevʉpe d̶abevʉ. Apevʉre jʉjovarĩ ĩmevʉ yʉ ne cʉvaede. Ãmeno d̶abevʉ yʉ apevʉre. Nomicʉcʉ, apecoque cʉbevʉ yʉ. Aru ñai jabovare tãutʉra ĩcaipõecʉpe d̶abevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pʉcajãravʉa sumana coapa ãmecʉva ãiyede jẽniavaivʉ yʉ mʉre. Aru caiye ji cʉvaede caipʉcapʉrʉape paiyede cʉvarĩ, cũináro jívavʉ yʉ mʉre”, aquemavʉ ñai fariseo. ");
INSERT INTO cubNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ʉbenita ñai jabovare tãutʉra ĩcaipõecʉ joai núri, jã́iyʉbecʉ cavarõre, totaquemavʉ ʉ̃i ñarebare, ʉ̃i chĩoiye boje. Aru aquemavʉ: “Mʉ, ji mearore jímʉ, cõmaje ãroje jã́jacʉ yʉre, ãmeina teyʉre”, aquemavʉ ñai jabovare tãutʉra ĩcaipõecʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Coyʉyʉbu mʉjare: Jʉ̃menijicʉ ãrʉmetequemavʉ ñai ʉ̃mʉ ʉ̃i ãmeina teiye báquede. Ʉbenita ãrʉmetebetequemavʉ ñai fariseo ʉ̃i ãmeina teiye báquede. Que baru ñai cʉiyʉcʉ me apevʉ pʉeno, parʉbecʉyʉme pʉeno baju. Aru ñai parʉbede d̶aiyʉcʉ ʉ̃i baju apevʉ cãchino, me cʉcʉyʉme pʉeno baju, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Põeva nʉvare cuivʉ barejáimad̶a némarare Jesús yebai, ʉ̃i tʉoquiyepe aivʉ náre ʉ̃i pʉrʉáque. Que teni Jesúi bueimara náre jã́ivʉ, nʉvaicõjemenejaimad̶a némarare. ");
INSERT INTO cubNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ʉbenita Jesús órejarejamed̶a náre ʉ̃i yebai. Aru arejamed̶a: —Ina jʉed̶ova dajarãri ji yebai. Jʉ̃menijicʉ jabotecʉyʉme põevare nápe paivʉre. Que baru, “Davabejarã jʉed̶ovare”, abejarã náre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ copʉ etabecʉ baru Jʉ̃menijicʉre jaboteyʉre ʉ̃́re, yópe jʉed̶ocʉ ʉ̃i copʉ etaiyepe, ecobecʉyʉme ʉ̃i jaboteinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cũinácʉ jabocʉ jẽniari jã́rejamed̶a Jesúre: —Mʉ, bueipõecʉ meacʉ, ¿aipe d̶aji yʉ, cʉvacʉyʉ jãravʉ cũiméjãravʉ baquinóre? arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús arejamed̶a ʉ̃́re: —¿Aipe teni “Meacʉbu mʉ”, ayʉrʉ̃ yʉre? Jʉ̃menijicʉ cũinácʉrabe meacʉ baju. ");
INSERT INTO cubNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Majivʉra mʉ Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i coyʉiye báquede Moisés bácʉre: “Cʉvabejacʉ apecore mimarepacore jarʉvarĩ. Põevare boarĩ́ jarʉvabejacʉ. Ñavamejacʉ apecʉ ʉ̃i cʉvaede. Borod̶abejacʉ apecʉre. Jʉ ajacʉ mipacʉre aru mipacore máre”, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Que teni arejamed̶a Jesúre: —D̶acacʉ caiye iye mi coyʉiyede jʉed̶ocʉ cãreja yʉ, aru caride máre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ʉ̃i jʉ aiyede jápiayʉ bácʉ Jesús, arejamed̶a ʉ̃́re: —Cũináro jaʉvʉ mʉre cãreja. Jíni bojed̶ajacʉ mi cʉvede. Aru mi ĩquiyede jíjacʉ ina cõmaje ãrojarivʉre. Que teni cʉvacʉyʉmu mʉ boje méne cavarõ mearo Jʉ̃menijicʉi cʉrõi. Aru dajacʉ yʉ́que, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ʉbenita iyede jápiarĩ ʉrarõreca chĩorejamed̶a, dajocaiyʉbecʉ ʉ̃i ʉre cʉvede. ");
INSERT INTO cubNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Que teni Jesús ʉ̃́re jã́ri, arejamed̶a: —Ina põeva cʉve cʉvarivʉre pare maiyójavʉ ne jʉ aiye Jʉ̃menijicʉre, ʉ̃i mead̶aquiyepe aivʉ náre aru ne ecorãjiyepe aivʉ ʉ̃i jaboteinore cavarõ mearo ʉ̃i cʉrõre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cũinácʉ ãimacʉ ʉracʉ, camello ãmicʉcʉ, ʉ̃i ecoru aviyo cobei, maiyójajebu ʉ̃́re. Aru pʉeno maiyójavʉ cʉve cʉvacʉre ʉ̃i ecoquino Jʉ̃menijicʉi jaboteinore, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ina ʉ̃́re jápiaivʉ bácavʉ arejaimad̶a: —¿Ñame bʉojarĩ ecorãjidica Jʉ̃menijicʉi jaboteinore, cʉvarãjivʉ jãravʉ cũiméjãravʉ baquinóre? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesúcapũravʉ arejamed̶a náre: —Põeva ne d̶arĩ majibeno maiyójabevʉ Jʉ̃menijicʉre. Ʉ̃ cũinácʉra bʉojarĩ mead̶ayʉbe põevare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Aru Pedro arejamed̶a: —Dajocacarã ñʉja caiye ñʉje cʉvaede, ñʉje daiye boje mʉ́que, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Aru Jesús arejamed̶a náre: —Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ dajocayʉ baru ʉ̃i cʉ̃ramine, o jímarepacore, jíbʉrãre, ĩmarare, ʉ̃i bʉcʉvare, o ʉ̃i márare máre, Jʉ̃menijicʉi jaboteino boje, ñai põecʉ eacʉyʉme pʉeno baju caride ijãravʉi. Aru daquijãravʉ baquinói cʉvacʉyʉme jãravʉ cũiméjãravʉ baquinóre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús nʉvarejamed̶a ina doce paivʉre. Aru yópe arĩ, coyʉrejamed̶a náre: —Jerusalẽ́i nʉivʉbu. Nore d̶arãjivʉbu na yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, caiye iye Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivaiye báquepe. ");
INSERT INTO cubNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jínajivʉbu yʉre ina judíova ãmevʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Que teni ina põeva yʉrinajivʉbu yʉre. Cʉyoje d̶arãjivʉbu yʉre. Jẽcututurajivʉbu yʉre. Jara popenajivʉbu yʉre. Aru boarĩ́ jarʉvarãjivʉbu yʉre. Ʉbenita yóbecʉrijãravʉa yóboi jipacʉ, Jʉ̃menijicʉ, nacovacʉyʉme yʉre yainore jarʉvarĩ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ʉbenita caiye iyede jápiarĩ eabedejaimad̶a na, ʉ̃i bueimara. Coreóvabedejaimad̶a aipe aiyʉrõ iye Jesús ʉ̃i coyʉiye báquede náre. Que baru majibedejaimad̶a ʉ̃i coyʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jericó ãmicʉriĩmaroi joabenoi earejamed̶a Jesús. No ma ẽcarʉi cũinácʉ ʉ̃mʉ, jã́ri eabecʉ, tãutʉrare jẽniañʉ dobarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ʉ̃ jápiayʉ bácʉ obedivʉ põeva vaivʉre mái, jẽniari jã́rejamed̶a: —¿Aipe teidi? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aru apevʉ arejaimad̶a ʉ̃́re: —Jesús Nazarecacʉ mái nʉimi, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ñai jã́ri eabecʉ cod̶oboborejamed̶a: —Mʉ, Jesús, David bácʉi pãramecʉ, Jʉ̃menijicʉi daroimʉ mácʉ, ñʉje jabocʉ bacʉyʉ́, yʉre cõmaje ãroje jã́jacʉ, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Aru ina ʉ̃i jipocai nʉivʉ, ʉ̃́re jaraivʉ, arĩdurejaimad̶a: —¡Bi ajacʉ mʉ! arĩdurejaimad̶a. Ʉbenita pʉeno baju cod̶oboborejamed̶a ʉ̃ cojedeca: —Mʉ, David bácʉi pãramecʉ, Jʉ̃menijicʉi daroimʉ mácʉ, ñʉje jabocʉ bacʉyʉ́, yʉre cõmaje ãroje jã́jacʉ mʉ, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Que teni ʉ̃́re cod̶oboboyʉre jápiayʉ Jesús, dajocarejamed̶a. Aru arejamed̶a: —Davajarã ʉ̃́re ji yebai, arejamed̶a. Ñai jã́ri eabecʉ ʉ̃i eaiyede, Jesús jẽniari jã́rejamed̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Aipe d̶acaji yʉ mʉre? arejamed̶a Jesús. Ñai jã́ri eabecʉ arejamed̶a: —Mʉ, ji jabocʉ, jã́ri eabevʉ yʉ. Ʉrarõ jã́iyʉvʉ yʉ, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús jʉ arejamed̶a ʉ̃́re: —Dinʉmʉ meavʉ. Jã́jacʉ mʉ cari. “Yʉre mead̶acʉyʉme Jesús”, arĩ dápiarebu mʉ. Que baru mi jã́ri eabede mead̶acaivʉ yʉ caride, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Aru cũiná jã́rejamed̶a ʉ̃, jã́ri eabecʉ bácʉ. Que teni Jesúre yóvarĩ nʉrejamed̶a ʉ̃ máre, mearore jíyʉ Jʉ̃menijicʉre. Que baru caivʉ ina põeva máre, ʉ̃́re jã́ri, mearore jídejaimad̶a Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jericó ãmicʉriĩmaroi Jesús ecorĩ vaiyʉ́ barejámed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Noi cũinácʉ ʉ̃mʉ cʉrejamed̶a, ʉ̃i ãmiá Zaqueo. Ʉ̃ jabovare tãutʉra ĩcaipõeva ne jabocʉ barejámed̶a. Aru cʉve cʉvacʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Obedivʉ põeva Jesúre jã́iyʉrĩ copʉrejaimad̶a. Zaqueo máre jã́iyʉrĩdurejamed̶a ʉ̃́re. Ʉbenita ñai Zaqueo ʉ̃mʉjʉbecʉ, aru obedivʉ põeva ne nʉiye boje ʉ̃i jipocai, jã́menejamed̶a ʉ̃ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Que baru cúyarĩ apevʉ jipocai, jocʉcʉ sicómoro ãmicʉricʉi mʉri, Jesúre jã́cʉnʉrejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Que teni Jesús mái vaiyʉ́ jocʉcʉ yebai, jã́ñʉ Zaqueo jocʉcʉi tubacʉre, arejamed̶a ʉ̃́re: —Mʉ, Zaqueo, jõd̶ajacʉ maumena. Mi cʉ̃rami mautecʉyʉbu yʉ caride, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Que teni Zaqueo maumena jõd̶ari, torojʉrĩ jacoyʉrejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Aru caivʉ ina põeva jã́ivʉ iyede, ãmeina yávarejaimad̶a. —Ñai Jesús mautecʉnʉimi ãmeina teipõecʉi cʉ̃rami, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ʉ̃i cʉ̃rami ecorĩburu yóboi, Zaqueo núri, yávayʉ arejamed̶a Jesúre: —Mʉ, ji jabocʉ, coricai ji cʉvaede jíquijivʉ yʉ cõmaje ãrojarivʉre. Aru jacopaiyovaquijivʉ yʉ ina ji jʉjovaimara mácavʉre yóvaicʉvaiye pʉeno baju ji ĩ́no mácarõre náre jocarĩ, arejamed̶a Zaqueo. ");
INSERT INTO cubNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Que ayʉre, Jesús arejamed̶a ʉ̃́re: —Mʉ máre Abraham mácʉi pãramecʉbu. Que baru caride iñami cʉ̃ramicavʉ mead̶aimaramu mʉja. Jʉ̃menijicʉ mead̶arejaquemavʉ Abraham mácʉre, ʉ̃i jʉ aiye báque boje ʉ̃́re. Nopedeca Jʉ̃menijicʉ mead̶aibi mʉre aru mi cʉ̃ramicavʉre, mʉje jʉ aiye boje ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, vocʉdaivʉ ina bíjaivʉre, mead̶acʉyʉ náre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Diede põeva ne jápiarĩburu yóboi, Jesús bueni bʉ́rejamed̶a náre jã́ri dápiarĩ ne d̶arãjiyepe ainoque, ʉ̃i Jerusalén ãmicʉriĩmaro joabejĩnoi cʉe boje, aru ne dápiaiye boje caivʉ põeva jã́rajivʉre Jʉ̃menijicʉi jaboteiyede põevare maumejiena. ");
INSERT INTO cubNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Que baru Jesús arejamed̶a: —Cũinácʉ ʉ̃mʉ, jabova jicʉ, nʉcʉyʉ batequémavʉ apeno joarõcajaborõi, ne epenajiyepe ayʉ ʉ̃́re jabocʉva. ");
INSERT INTO cubNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ñai jabocʉ bacʉyʉ́ órejaquemavʉ caipʉcapʉrʉape paivʉ ʉ̃́re memecaipõevare. Aru náre coapa tãutʉrare jíyʉ, caivʉre cũinátʉrʉ, “Bojed̶ajarã mʉja iye tãutʉraque ji copaidaiyeta”, aquemavʉ náre ñai jabocʉ. Que teni ñai jabocʉ ʉ́tequemavʉ ne ĩnajiyepe ayʉ tãutʉrare pʉeno baju. ");
INSERT INTO cubNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Coyʉrĩ bʉojarĩ, ñai jabocʉ nʉquemavʉ apeno joarõcajaborõi. Ʉbenita ʉ̃i jaborõcavʉ baju pare ʉbetequemavʉ ʉ̃́re. Que baru jaroquemavʉ boro nʉvacaipõevare ʉ̃i yóboi, ne jẽniarajiyepe aivʉ ãnijaborõ jabocʉre, ʉ̃i epebequiyepe aivʉ ñai ʉ̃mʉre ne jabocʉva. “Ʉbevʉ ñʉje jabocʉva ñai ʉ̃mʉre”, arĩduquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ʉbenita ñai ʉ̃mʉ copaiyʉ jabocʉ batequémavʉ ʉ̃. ’Aru órejaicõjequemavʉ ina ʉ̃́re memecaipõevare, ʉ̃i tãutʉrare jímara mácavʉre, majiyʉcʉ ne bojed̶arĩ ĩ́no mácarõ borore. ");
INSERT INTO cubNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Que teni cũinácʉ ina memecaipõevacacʉ ñai jabocʉ yebai nʉri, aquemavʉ: “Mʉ, ji jabocʉ, mi jíye báqueque bojed̶acacʉ yʉ. Que teni caride caipʉcapʉrʉape paitʉrava cʉvavʉ”, aquemavʉ ñai jabocʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Aru ñai jabocʉ aquemavʉ ʉ̃́re: “Mearo d̶arebu mʉ. Memecaipõecʉ meacʉbu mʉ. Mi mearo d̶aiye boje quĩ́jinoque, jíquijivʉ yʉ mʉre caipʉcapʉrʉape paiĩmaroare, mi jabotequiyepe diĩmaroacavʉre”, aquemavʉ ñai jabocʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aru apecʉ ina memecaipõevacacʉ ñai jabocʉ yebai nʉri, aquemavʉ: “Mʉ, ji jabocʉ, mi jíye báqueque bojed̶acacʉ yʉ. Que teni caride cũinápʉrʉpe paitʉrava cʉvavʉ”, aquemavʉ ñai jabocʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aru ñai jabocʉ aquemavʉ ʉ̃́re: “Mʉre máre jíquijivʉ yʉ cũinápʉrʉpe paiĩmaroare, mi jabotequiyepe diĩmaroacavʉre”, aquemavʉ ñai jabocʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Ʉbenita apecʉ ina memecaipõevacacʉ ñai jabocʉ yebai nʉri, aquemavʉ: “Mʉ, ji jabocʉ, yui cʉvavʉ mi tãutʉrare, mi jíye báquede yʉre. Epecacʉ yʉ diede cuitótecajeque, mead̶ayʉ diede. ");
INSERT INTO cubNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jidojacʉbu mʉ. Mʉ ĩñʉmu apecʉ ʉ̃i epeiye báquede. Aru mʉ jẽñʉmu apecʉ ʉ̃i oteiye báquede. Que baru jidʉtevʉ yʉ mʉre”, aquemavʉ ñai jabocʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Aru ñai jabocʉ aquemavʉ ʉ̃́re: “Mʉ, memecaipõecʉ ãmecʉbu. Mi que aiye boje ãmecoroimʉ macʉyʉ́mu mʉ. Yʉ jidojacʉre majicʉvacari, aru yʉ ĩñʉre apecʉ ʉ̃i epeiyede aru jẽñʉre apecʉ ʉ̃i oteiyede majicʉvacari, epebetequemavʉ mʉ ji tãutʉrare tãutʉra epeiñami. Mi que d̶aru, copaini dayʉ jacopʉjebu yʉ ji tãutʉrare pʉeno baju, diñamicavʉ ne bojed̶aiye báque cojiórĩ”, aquemavʉ ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","’Que baru ñai jabocʉ aquemavʉ ina núrivʉre nore: “Ĩjara ʉ̃́re jocarĩ yo cũinátʉrava tãutʉratʉravare. Aru jíjarã ñai caipʉcapʉrʉape paitʉrava cʉvacʉre”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Aru aquemavʉ na: “Mʉ, ñʉje jabocʉ, ʉ̃ jave cʉvabi caipʉcapʉrʉape paitʉrava tãutʉratʉravare”, aquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ʉbenita ñai jabocʉ aquemavʉ: “Coyʉyʉbu mʉjare: Caivʉ cʉvarivʉ jacopʉrãjarama pʉeno baju. Ʉbenita caivʉ dápiaivʉre cʉvarivʉpe apevʉ pʉeno, caiyede náre ĩcʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Aru ina ji mauvare, ji jaboteinore ʉbevʉre, davajarã náre yui. Aru boarĩ́ jarʉvajarã náre ji jã́inoi”, aquemavʉ ñai jabocʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús ʉ̃i coyʉrĩburu yóboi, nʉñʉ cojedeca mʉri nʉrejamed̶a Jerusalén ãmicʉriĩmaroi nʉimai. ");
INSERT INTO cubNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Aru Jerusalén ãmicʉriĩmaro joabejĩnoi nʉri, Betfajé aru Betania ãmicʉriĩmajinoa baji, no cʉ̃racũ Olivocũ ãmicʉricũ ẽmeino baji, earejamed̶a Jesús. Noi earĩ ʉ̃i bueimara pʉcarãre, yópe arĩ, jarorejamed̶a Jesús: ");
INSERT INTO cubNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—No cõchino cʉriĩmajinoi nʉjara mʉja. Ma ẽmeinoi põevare ũmaiãimacʉre, burrore, earãjaramu mʉja, nócacʉi bʉoimʉre. Põeva ne tubabemʉtame cãreja. Ʉbenita ʉ̃i bʉoimene jod̶eni, ʉ̃́re davacajarã yʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aru, “¿Aipe teni burrore ʉ̃i bʉoimene jod̶eni, ʉ̃́re nʉvaivʉrʉ̃ mʉja?” ne aruta, yópe ajarã mʉja: “Ñʉjare ĩ́cõjeni darobi maje jabocʉ. Ʉ̃́re ũmacayʉ ãimacʉ jaʉbi ʉ̃”, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ina ʉ̃i daroimara nʉrejaimad̶a. Aru vaidéjavʉ̃ya náre nópe Jesús ʉ̃i aiye báquepedeca. ");
INSERT INTO cubNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ne jod̶eiyede burrore, ʉ̃́re uparivʉ arejaimad̶a náre: —¿Aipe teni jod̶eivʉrʉ̃ mʉja ʉ̃i bʉoimene? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aru arejaimad̶a ina Jesúi bueimara: —Maje jabocʉre ũmacayʉ ãimacʉ jaʉbi ʉ̃, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne jʉ aiyede náre, nʉvarejaimad̶a burrore Jesúre. Ne doicajea pʉenocacajeare burrorã tʉorĩ, Jesúi tubaquinore d̶arejaimad̶a ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ʉ̃i nʉiyedeca ina obedivʉ põeva ma ẽcarʉi núrivʉ jũarejaimad̶a ne pʉenocacajeare mára Jesús jipocai, pued̶arãjivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aru Jerusalén ãmicʉriĩmaro joabejĩnoi, Jesús ʉ̃i ẽmeiyede cʉ̃racũ Olivocũ ãmicʉricũre jocarĩ, caivʉ ina obedivʉ põeva, Jesúi bueimara, torojʉrivʉ Jʉ̃menijicʉre mearore jíni bʉ́rejaimad̶a, ne jã́iye báque boje ʉ̃i d̶aiye báquede caiye iye põeva ne d̶arĩ majibede. ");
INSERT INTO cubNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Aru parʉrõreca arejaimad̶a: —Jʉ̃menijicʉre torojʉe bajad̶éni. Jʉ̃menijicʉi mearo d̶acaimʉme ñai jabocʉ Jʉ̃menijicʉi daroimʉ mácʉ. Cãrijimena cʉjarãri cavarõ mearocavʉ. Jʉ̃menijicʉre mearo majaróri. Jʉ̃menijicʉre torojʉe bajad̶éni, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Apevʉ fariseovacavʉ cʉrivʉ nore arĩdurejaimad̶a Jesúre: —Mʉ, bueipõecʉ, bi aicõjejacʉ mi bueimarare, arĩdurejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ʉbenita Jesús arejamed̶a: —Coyʉyʉbu mʉjare: Na bi aru, iboá cʉ̃raboavareca cod̶obobojebu, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén ãmicʉriĩmaro joabejĩnoi eayʉ Jesús, diĩmarore jã́ñʉ, orejamed̶a, ʉ̃i Jerusalén ãmicʉriĩmarocavʉre cõmaje ãroje jã́iye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Aru arejamed̶a: —Mʉja, Jerusalẽ́cavʉ, mʉje coreóvaru cãrijimene d̶aiyede, meajebu mʉjare. Ʉbenita coreóvarĩ majibevʉ mʉja diede. Jʉ̃menijicʉ majide d̶abebi mʉjare diede cãreja. ");
INSERT INTO cubNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Apejãravʉa baquiyéi jã́rajaramu mʉje mauva edaivʉre mʉje ĩmaro tʉrʉvai. Epenajarama jobore cʉ̃racũape. Etaino cʉbequiyebu mʉjare. Bienajaramu mʉjare ĩmaro jívʉi, mʉje dupibenajiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jarʉvarãjarama mʉje cʉ̃ramiare. Aru ye mautebequiyebu cũináva cʉ̃rava apeva cʉ̃rava pʉenora. Boarĩ́ jarʉvarãjarama mʉjare aru mʉjemarare máre. Caiye diede ñájinajaramu mʉja, mʉje coreóvabe boje cari jãravʉre, Jʉ̃menijicʉ ʉ̃i daroiyede yʉre, ji mead̶aquiyepe ayʉ mʉjare, mʉje nʉmenajiyepe arĩduyʉ toabo cũiméboi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","No yóboi Jesús earejamed̶a Jerusalén ãmicʉriĩmaroi. Jʉ̃menijicʉi cʉ̃rami tãibʉi ecorejamed̶a. Aru jaetovarejamed̶a ina bojed̶aipõeva cʉrivʉre nore jocarĩ. Arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—Yópe arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃i yávaiyede: “Ji cʉ̃rami caivʉ põeva ne yʉre, Jʉ̃menijicʉre, coyʉiñamimu”, arĩ toivaicõjenejaquemavʉ. Ʉbenita diñamine tatorĩ ĩ́vʉ ne dupiñamipe d̶aquemavʉ mʉja, mʉje pʉeno ʉrarõ tãutʉra ĩ́ye boje põevare jocarĩ, ne bojed̶aiyede mʉje cʉvaede, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Caijãravʉa Jesús bueyʉ barejámed̶a Jʉ̃menijicʉi cʉ̃rami jívʉi. Ina sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru ina judíova jabova máre boarĩ́ jarʉvaiyʉrivʉ barĩdurejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ʉbenita caivʉ ina obedivʉ põevacapũravʉ torojʉrĩ jápiaiyʉrejaimad̶a Jesús ʉ̃i bueiyede. Que baru ʉ̃́re boarĩ́ jarʉvarĩ bʉojabedejaimad̶a na, ʉ̃i mauva. ");
INSERT INTO cubNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Cũinájãravʉ Jesús bueyʉ barejámed̶a ina põevare, Jʉ̃menijicʉi cʉ̃rami cʉrivʉre. Coyʉyʉ barejámed̶a Jʉ̃menijicʉi yávaiye méne, ʉ̃i mead̶aquiyede põevare. Sacerdotevare jaboteipõeva, aru Jʉ̃menijicʉi yávaiye báquede bueipõeva, aru judíova bʉcʉva máre ʉ̃i yebai nʉri, arejaimad̶a ʉ̃́re: —Coyʉjacʉ ñʉjare. ¿Ye parʉéque d̶ayʉrʉ̃ mʉ iye mi d̶aiyede? ¿Ñame jídi mʉre iye parʉéde mi nópe d̶aiyede? arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús arejamed̶a náre: —Yʉ máre jẽniari jã́quijivʉ mʉjare cũináro jẽniari jã́inore. Coyʉjarã yʉre. Aru yʉre coyʉiyede, yʉ máre coyʉquijivʉ mʉjare ji parʉéde ji d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Juan Bautista bácʉ jã́d̶ovaquemari põevare Jʉ̃menijicʉ ʉ̃i parʉéque o põeva ne parʉéque? arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ʉ̃i que aiyede, ne bajumia boroteivʉ arejaimad̶a yópe: “Maje aru ‘Jʉ̃menijicʉque’, ʉ̃ aquijibi ‘¿Aipe teni jʉ abetecarãrʉ ʉ̃́re?’ ");
INSERT INTO cubNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ʉbenita maje aru ‘põevaque’, caivʉ ina põeva cʉ̃raboare dʉvarĩ boarĩ́ jarʉvarãjarama majare, ne majié boje Juan Bautista bácʉre Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉre jãve”, arejaimad̶a ne bajumia. ");
INSERT INTO cubNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Que baru arejaimad̶a Jesúre: —Majibevʉ ñʉja, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Dinʉmʉre Jesús arejamed̶a náre: —Yʉ máre coyʉbevʉ mʉjare ñamei parʉéque ji d̶aiyede, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","No yóboi Jesús coyʉrĩ bʉ́rejamed̶a ina ʉ̃́que cʉrivʉre jã́ri dápiarĩ ne d̶arãjiyepe ainoque, yópe arĩ: —Cũinácʉ ʉ̃mʉ doaicõjequemavʉ jiore ʉ́yaimuque. Aru epequemavʉ apevʉ ʉ̃́re memecaipõevare noi. Ina memecaipõeva ĩnajivʉ batequémavʉ apeboa ʉ́yaiboare, ne memeiye boje. Aru nʉquemavʉ apeno joborõi. Joe cʉcʉyʉ batequémavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ʉ́yai jẽijãravʉ yóboi, ñai jio upacʉ jarorĩduquemavʉ cũinácʉ ʉ̃i yebacacʉre memecaipõeva yebai, ʉ̃i ĩquiyepe ayʉ apeboa ʉ́yaiboare, ñai upacʉ jiede. Ʉbenita ñai yebacacʉ ʉ̃i eaiyede nore, ina memecaipõeva ʉ̃́re jẽni, pare boarĩ́ copaide d̶aquemavʉ ʉ̃́re quédata. ");
INSERT INTO cubNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Cojedeca ñai jio upacʉ jarorĩduquemavʉ apecʉ ʉ̃i yebacacʉre memecaipõeva yebai. Ʉbenita ʉ̃́re máre boaquémavʉ. Aru cʉyojarõ d̶arĩ, copaide d̶aquemavʉ ʉ̃́re máre quédata. ");
INSERT INTO cubNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Cojedeca ñai jio upacʉ jarorĩduquemavʉ apecʉ ʉ̃i yebacacʉre nore memecaipõeva yebai. Ʉbenita churiá d̶arĩ, jaetovaquemavʉ ʉ̃́re nore jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Dinʉmʉ ñai jio upacʉ aquemavʉ yópe: “¿Aipe d̶aji yʉ? Jave majivʉ yʉ ji d̶aquiyede. Jaroquijivʉ jímacʉ, ji ʉmʉre. ‘Ʉ̃́re jã́ivʉ pued̶arãjichʉma na’ ayʉ”. Que aquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ʉbenita ina memecaipõeva jã́ivʉ ñai jio upacʉi mácʉre, aquemavʉ ne bajumia: “Ñai ñʉje jabocʉ bacʉyʉ́me. Jípacʉ ʉ̃i yainíburu yóboi, cʉvacʉyʉme caiye ʉ̃i cʉvaede. Jã́rica, boarĩ́ jarʉvarãjarevʉ ʉ̃́re, maja cʉvaburĩ caiye ʉ̃i cʉvaede”, aquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Que arĩ, ʉ̃́re jẽni jaetovaquemavʉ jiore jocarĩ. Aru boarĩ́ jarʉvaquemavʉ ʉ̃́re, arejamed̶a Jesús. Coyʉrĩburu yóboi, Jesús yópe arĩ, jẽniari jã́rejamed̶a ina jápiaivʉre ʉ̃́re: —¿Aipe d̶aquidi ñai jio upacʉ náre? ");
INSERT INTO cubNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ʉ̃ boarĩ́ jarʉvacʉnʉcʉyʉme ina memecaipõevare. Aru epecʉyʉme apevʉ memecaipõevare ʉ̃i jioi, arejamed̶a Jesús. Diede jápiaivʉ arejaimad̶a: —¡Que ãmevʉ no! arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ʉbenita Jesús, jã́ñʉ náre, arejamed̶a: —¿Aipe aiyʉri iye Jʉ̃menijicʉi toivaicõjeiye báquede ʉ̃i yávaiye? Iva cʉ̃ravare cʉ̃ramine d̶aipõeva ʉbeni jarʉvaquemavʉ. Caride iva cʉ̃rava caiva apeva pʉeno parʉrivabu, arĩ toivaicõjenejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ácʉ põecʉ tʉyʉ baru divarã, tʉrĩ yavacʉyʉme ʉ̃i bajure. Aru diva tʉiva baru põecʉ pʉenora, chĩtoquiyebu ʉ̃́re, arejamed̶a náre Jesús. Yópe aiyʉrõtamu no: Põeva “Ãmecʉbe ʉ̃”, arĩdurãjarama Jesúi borore. Ʉbenita meacʉ bajube ʉ̃, Jesús, caivʉ apevʉ pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ina Jʉ̃menijicʉi yávaiye báquede bueipõeva aru ina sacerdotevare jaboteipõeva máre jẽni nʉvaiyʉrĩdurejaimad̶a Jesúre dinʉmʉmia, ʉ̃i coyʉiye boje no jã́ri dápiarĩ ne d̶arãjiyepe ainore, cʉ̃ravare coyʉino mácarõre, nára. Ʉbenita jidʉrejaimad̶a ina obedivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ina judíovai jabova cocorejaimad̶a Jesúre, meajãravʉi coreivʉ ne jẽni jínajinore ʉ̃́re ñai jabocʉ Pilatore. Que baru ãrojamena jarorejaimad̶a jʉjovaivʉre, d̶aivʉre mearape, ne earĩdurãjiyepe aivʉ ʉ̃i ãmeina tedu aru ʉ̃i borocʉru apevʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Que baru jẽniari jã́rejaimad̶a Jesúre: —Mʉ, bueipõecʉ, mʉre coreóvaivʉbu ñʉja. Nurié yávaivʉ mʉ. Caivʉre cũinácamuara yávaivʉ mʉ. Coyʉbevʉ mʉ põevare yópe ne d̶aiyepe. Quénora jidʉbecʉva coyʉivʉ mʉ náre yópe ne dápiaiyepe. Jãveneca bueivʉ mʉ põevare, ne d̶arãjiyepe ayʉ mearore yópe Jʉ̃menijicʉi d̶aicõjeiyepe. ");
INSERT INTO cubNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Maje jabocʉ César ʉ̃i ĩ́cõjejʉroede, ʉ̃i jaboteiye boje, maje bojed̶aru, mearica die? arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ʉbenita ne jʉjovajʉroede majicʉ, nácacʉre arejamed̶a Jesús: ");
INSERT INTO cubNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Jã́d̶ovajacʉ yʉre tãutʉratʉravare. ¿Ñamema ñai, ditʉravare jẽñʉ? ¿Aru ñamei ãmiá cʉritʉravaba ditʉrava? arejamed̶a náre Jesús. —Césai decocʉ aru ʉ̃i ãmiá máre cʉritʉravatamu, arejaimad̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—César jiede ʉ̃́re jacopaiyovajarã mʉja. Jíjarã ʉ̃́re tãutʉra yópe ʉ̃i bojed̶aicõjeiyepe mʉjare. Aru Jʉ̃menijicʉ jiede ʉ̃́re jacopaiyovajarã mʉja. D̶ajarã yópe ʉ̃i ʉrõpe, arejamed̶a náre, jẽniari jã́radaivʉre, Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ina jʉjovaiyʉrĩduivʉ bácavʉ Jesúre ʉ̃i que aiyede ʉrarõ dápiarejaimad̶a ʉ̃i coyʉiyede. Aru bi arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Apevʉ saduceova nʉrejaimad̶a Jesús yebai. Saduceo ãmicʉriyajubobu judíovacavʉ ne yajubo cũináyajubo. Caivʉ saduceova “Yainore jarʉvarĩ nacajaiye cʉbevʉ”, ad̶ama na. ");
INSERT INTO cubNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jesúre jẽniari jã́rejaimad̶a ina saduceova yópe: —Mʉ, bueipõecʉ, Jʉ̃menijicʉi d̶aicõjeiyede Moisés bácʉ toivarejaquemavʉ yópe: Cũinácʉ ʉ̃mʉ yaidú, jímarepacore jocarĩ jʉed̶ocʉvabecova, yaiyʉ́ bácʉi yócʉre pʉrʉbʉoiye jaʉvʉ ṍque, jʉed̶ocʉvacʉyʉ. Aru ina jʉed̶ova bárãjivʉ yaiyʉ́ bácʉi ãmiáre cʉvarãjarama na. ");
INSERT INTO cubNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Javede cʉ́tequemavʉ siete paivʉ ʉ̃mʉva. Cũinácʉ ʉ̃mʉi mára matequémavʉ na. Némamicʉ pʉrʉbʉoquemavʉ. No yóboi yaiquémavʉ ʉ̃ mácʉ, jʉed̶ocʉvabecʉva. ");
INSERT INTO cubNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Que baru apecʉ, ʉ̃ mácʉrã cutuyʉ, pʉrʉbʉoquemavʉ jíbʉcʉ bácʉi márepacoque. Aru jíbʉcʉ bácʉpedeca yaiquémavʉ, jʉed̶ocʉvabecʉva. ");
INSERT INTO cubNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Aru apecʉ, ʉ̃ mácʉrã cutuyʉ, máre nopedeca, aru caivʉ ina siete paivʉ bácavʉ ṍque pʉrʉbʉorĩ, yaiquémavʉ, jʉed̶ocʉvabevʉva. ");
INSERT INTO cubNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Caivʉ ne yóboi, ico nomió máco máre yaiquémavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Yainore jarʉvarĩ nacajaijãravʉ baquinóre, ñamei márepaco bacod̶óba ico? Ijãravʉre caivʉ ina siete paivʉ cʉvatequemavʉ ṍre, arejaimad̶a na Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aru Jesús arejamed̶a ina saduceovare: —Ijãravʉcavʉ pʉrʉbʉod̶ama aru némaromivare jíyama, ne pʉrʉbʉorãjiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ʉbenita ãnijãravʉcavʉ yaibénama na. Que baru Jʉ̃menijicʉi yainore jarʉvarĩ nacajaicõjeimara márajivʉ, pʉrʉbʉobenajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ãnijãravʉcavʉ ángelevape ãrojarajarama na. Que baru Jʉ̃menijicʉi máratamu na, ne yainore jarʉvarĩ nacajaiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","¿Iye yainore jarʉvarĩ nacajaiyede, jápiarĩ eabenarʉ mʉja Jʉ̃menijicʉi coyʉiye báquede, Moisés bácʉ ʉ̃i toivaiye báquede, jocʉjĩcʉ uruijĩcʉre coyʉrĩ? “Yʉ́tamu Jʉ̃menijicʉ. Abraham, Isaac, aru Jacob ne mearore jímʉmu yʉ”, arejaquemavʉ Jʉ̃menijicʉ Moisés bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yaivʉ bácavʉ ne mearore jímʉ ãmemi Jʉ̃menijicʉ. Quénora apʉrivʉ ne mearore jímʉtame ʉ̃. Que baru ina majeñecuva apʉrivʉbu. Caivʉ Jʉ̃menijicʉi beoimara apʉrivʉbu na, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aru apevʉ, Jʉ̃menijicʉi yávaiye báquede bueipõevacavʉ, jʉ arejaimad̶a ʉ̃́re: —Mʉ, bueipõecʉ, me yávaivʉ mʉ, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Que baru jidʉrivʉ jẽniari jã́iyʉbedejaimad̶a ʉ̃́re bedióva cojedeca, ʉ̃i me jʉ aiye boje ina ʉ̃́re jʉjovaiyʉrĩduivʉ bácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ʉbenita Jesús jẽniari jã́rejamed̶a náre: —¿Aipe teni “Cristobe David bácʉi pãramecʉ” aivʉba? ");
INSERT INTO cubNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David bácʉvacari Espíritu Santoi parʉéque coyʉicõjeimʉ toivarejaquemavʉ Salmos ãmicʉriyoca cãriáiyocarã yópe arĩ: Jʉ̃menijicʉ aquemavʉ ji jabocʉre, “Dobajacʉ ji meapũravʉi, mi cʉvae boje parʉéde yʉpedeca. ");
INSERT INTO cubNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Aru yʉ epecʉyʉmu mi mauvare mi cʉboba cãchinoi. Que teni mʉre vainí jarʉvare d̶acʉyʉmu yʉ náre, mi jabotequiyepe ayʉ náre”, arĩ toivarejaquemavʉ David bácʉ Cristorã. ");
INSERT INTO cubNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David bácʉvacari Cristoi borore “Ʉ̃́recabe ji jabocʉ”, arejaquemavʉ. Que baru, ¿aipe teni David bácʉi pãramecʉba ʉ̃? arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Caivʉ ina põeva ne jápiaiyede, Jesús arejamed̶a ʉ̃i bueimarare: ");
INSERT INTO cubNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Me d̶ajarã ina Jʉ̃menijicʉi yávaiye báquede bueipõevare. Námu cuiyʉrivʉ cuitótecajea ʉ̃mʉjʉricajeaque. Aru ʉma na põeva pued̶arĩ ne jacoyʉinore náre tãibʉi. Judíovai cójijiñamiare ne dobae méne ʉma na. Aru torojʉve teinore cʉiyʉma na ñai torojʉve teino upacʉ yebai. Caiye iyede ʉma na, põeva ne mearo jã́rajiyepe aivʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ʉbenita jʉjovarĩ ñavad̶ama ina nomiópevare ne apejĩene. Aru jẽniad̶ama joe ʉrarõ Jʉ̃menijicʉque, põeva ne dápiarãjiyepe aivʉ Jʉ̃menijicʉi yávaiye báquede bueipõeva me Jʉ̃menijicʉre jʉ aivʉpe. Caiye diede ne d̶aiye boje, pʉeno ʉrarõ ñájinajarama na, ne ãmeina teiye boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús jã́ñʉ marejámed̶a ina põeva cʉve cʉvarivʉre ne ʉre tãutʉrare Jʉ̃menijicʉi cʉ̃rami tãutʉra jíye epeitõcui jíni tʉoivʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jã́rejamed̶a cũináco nomiópecore cʉve cʉvabecore, pʉcatʉrava tãutʉratʉravare, me bojecʉbetʉravare tʉod̶ore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aru arejamed̶a: —Jãve coyʉyʉbu mʉjare: Ico nomiópeco cʉve cʉvabeco Jʉ̃menijicʉre jíbico apevʉ ne jíye pʉeno baju, õi jíye boje õi cʉvarõ cainore. Ʉbenita nácapũravʉ quénora quĩ́jino ne cʉvarõcarõre jíyama. ");
INSERT INTO cubNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Caivʉ ina põeva ne ʉrarõ cʉvaecarõre jíyama Jʉ̃menijicʉre náre jaʉbede. Ʉbenita ico nomió õi quĩ́jino cʉvarijĩno mácarõre jíbico cainore Jʉ̃menijicʉre. Caiye õi ijãravʉi cʉvajʉroede jíbico õ Jʉ̃menijicʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Apevʉ, Jʉ̃menijicʉi cʉ̃ramine jã́ri, arejaimad̶a: —¡Pare meavabu iva cʉ̃rava! ¡Aru pare mead̶amiamu iñamia cʉ̃ramia! ¡Aru pare mearomu põeva ne jíno mácarõre, cojʉyarãjivʉ diñamiare! arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ne que aiyede, Jesús arejamed̶a: —Apejãravʉ cʉquiyebu cũiné d̶aijãravʉ baquinó caiye iye mʉje jã́iyede. Cũináva cʉ̃rava mautebequiyebu apeva pʉenora. Caiye iva cʉ̃ravare tʉvarãjarama. Que teni cũiquíyebu die, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesúi bueimara jẽniari jã́rejaimad̶a ʉ̃́re: —Mʉ, bueipõecʉ, ¿aipiyede tʉquidi caiye iye cʉ̃ramia ʉrad̶ãmia? ¿Aipe d̶arĩ coreóvarãjidica ñʉja caiye iye bʉojaquiyede? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Aru Jesús arejamed̶a náre: —Me jã́jara apecʉ jʉjovaiyʉcʉre mʉjare. Darãjarama obedivʉ ʉ̃mʉva. Aru arãjarama “Cristobu yʉ” aru “Cristoi daquijãravʉ baquinó joabejĩnotamu”. Náre jʉ abejarã. Aru náque nʉmejara. ");
INSERT INTO cubNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mʉje jápiaiyede boaino borore aru boaquíno borore máre, jidʉbejarã. Caiye iye vaiquíyebu jãravʉ cũiquíye jipocai. Ʉbenita cũimébu cãreja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Dinʉmʉ arejamed̶a náre: —Cũináyajubo põeyajubocavʉ ãd̶amatenajarama apeyajubo põeyajubocavʉque. Aru cũináro jaboteinocavʉ ãd̶amatenajarama apeno jaboteinocavʉque. ");
INSERT INTO cubNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ʉrarõ joborõ cújiquiyebu obedicʉrõare. Ñájinajarama ãvʉéna aru duica ijiéde máre, yainájivʉ. Aru jã́rajarama ʉrarõ jã́d̶ovaino jidojarõre cavarõi. ");
INSERT INTO cubNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Ʉbenita iye vaiquíye jipocai põeva jẽnajarama mʉjare. Ãmeno d̶arãjarama mʉjare. Jẽni jínajarama mʉjare ina judíovai cójijiñamine coreipõevare aru ina ãmeina teivʉre jẽni jacoiñamine coreipõevare máre. Nʉvarajarama mʉjare, mʉje núrajiyepe aivʉ cõjeipõeva ne jã́inoi aru jabova ne jã́inoi máre, yʉre mʉje jʉ aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Dinʉmʉma mʉja coyʉrãjaramu ji borore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Que baru mʉje baju majijarã, dápiabenajivʉ aipe mʉje arãjinore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Que teni yʉ́vacari majide d̶acʉyʉmu mʉjare, mʉje coyʉrãjiyepe ayʉ méne. Que baru caivʉ ina mʉje mauva mʉjare copʉ yávarĩ aru mʉjare majibevʉpe jã́d̶ovari bʉojabenajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mʉjebʉcʉva máre, mʉjemamina, mʉjevʉ, aru mʉje yóvaimara máre jẽni jínajarama mʉjare, jabovare ne boarĩ́ jarʉvarãjiyepe aivʉ mʉjacavʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Aru caivʉ mʉjare, mʉje jʉ aiye boje yʉre, jorojĩni jã́rajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ʉbenita cũinájiyo mʉje pod̶ad̶o bíjabequiyebu. Que baru ye ãmeno d̶abenajarama mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mʉja jʉ aivʉ baru yʉre, mʉje yainʉmʉita, earãjaramu mʉja jãravʉ cũiméjãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ʉbenita mʉje jã́iyede ina mʉje mauva churarava jacotʉrãdaivʉre Jerusalẽ́ne, majinajaramu joabenore diĩmaro bíjaquinore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Dinʉmʉma ina Judeacavʉ dupini nʉjarari cʉ̃racũai. Aru ina ĩmarocavʉ cúyarĩ etajarãri ĩmarore jocarĩ. Aru ina jioi cʉrivʉ ecobejarãri ĩmarore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Dijãravʉa Jʉ̃menijicʉi ñájiovaquijãravʉa baquiyébu, eaquiyepe ayʉ caiye iye toivaiye báquede ãnijãravʉa baquiyéde. ");
INSERT INTO cubNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Cõmaje ãrojarajarama ina nomiva micava bárãjivʉ! ¡Aru ina nomiva némajina nuri dajocabevʉre cʉvarãjivʉ máre, pare ñájinajarama na! Dijãravʉa baquiyéde ʉrarõ ãmeno edaquiyebu ijoborõre. Aru ijãravʉcavʉ ñájinajarama ʉrarõ baju. ");
INSERT INTO cubNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ne mauva boarĩ́ jarʉvarãjarama nácavʉre. Aru bʉorĩ apevʉre, nʉvarajarama náre cainoa joborõai. Aru bíjarorãjarama Jerusalẽ́ne ina judíova ãmevʉ ne jaboteinʉmʉ bʉojaiyeta, arĩ buedejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús buede nʉrejamed̶a, yópe arĩ: —Jʉ̃menijicʉ jã́d̶ovacʉyʉme ʉ̃i parʉéde aviáque, aru aviá ñamicacʉque, aru abiácovaque máre. Ijãravʉcavʉ, cainoa joborõacavʉ, jidʉrivʉ cãrijinajarama jia ʉrad̶a pãcaiye pare bʉjié boje. ");
INSERT INTO cubNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Aru põeva cuecumarajarama, ne jidʉé boje, dápiaivʉ caino no ãmeno vaiquínore ijãravʉcavʉre. Que baru caivʉ ina parʉéque cʉrivʉvacari cavarõi cújinajarama. ");
INSERT INTO cubNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Dinʉmʉ jã́rajarama yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe. Dacʉyʉmu ocopeniboi, ʉrarõ parʉéque, jã́d̶ovacʉyʉ meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Que baru caiye iye bʉiyede yópe ji coyʉiyepe, jidʉbejarã. Dinʉmʉ maquinóre maumena Jʉ̃menijicʉ mead̶aquijibi mʉjare, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aru Jesús coyʉrejamed̶a náre jã́ri dápiarĩ ne d̶arãjiyepe ayʉ: —Jã́jara icʉ jocʉcʉ higueracʉre aru apecʉa jocʉcʉare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yoca yuiyede majivʉ mʉja ʉjʉrʉ̃mʉ joabenore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nopedeca jã́ivʉ caiye iye teiyede, majinajaramu mʉja Jʉ̃menijicʉi jabotequinʉmʉ joabenore. ");
INSERT INTO cubNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Jãve coyʉyʉbu mʉjare: Apevʉ ijãravʉi cʉrivʉ yaibédeca cãreja, vaiquíyebu caiye iye yópe ji coyʉiyepe. ");
INSERT INTO cubNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Caino cavarõ aru caino joborõ máre cũiquíyebu. Yópe ji yávaiyepedeca jãve vaiquíyebu. ");
INSERT INTO cubNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cãrijovamejara mʉje torojʉve teiyeque, aru ãiyeque, aru ũcuiyeque mʉje pacoteiyede, aru caiye ijãravʉ d̶aiyeque máre. Me jã́jara mʉja, ãnijãravʉ, ji copaidaquijãravʉ baquinó, edabequiyepe mʉjare mʉje corebede, yópe doriñʉ jẽiyepe moacʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ãnijãravʉ baquinó edaquiyebu caivʉ ijãravʉcavʉre maumejiena. ");
INSERT INTO cubNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ʉbenita ãrʉjara cainʉmʉa. Mʉje vaiyede caiye iye ñájiyede, jẽniajara Jʉ̃menijicʉre, ʉ̃i jíquiyepe aivʉ mʉjare ʉ̃i parʉéde, núrajivʉ jidʉbevʉva aru cʉyebevʉva máre Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji jã́inoi, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Caijãravʉa Jesús bueyʉ barejámed̶a Jʉ̃menijicʉi cʉ̃rami. Ʉbenita nainíburu yóboi, ĩmarore jocarĩ nʉri, Jesújã cãranʉvarejaimad̶a cʉ̃racũ Olivocũ ãmicʉricũi. ");
INSERT INTO cubNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Aru javejĩna coapa ĩmaroi copaini, Jʉ̃menijicʉi cʉ̃rami ecovarejamed̶a cojedeca Jesús. Aru obedivʉ põeva ʉ̃́re jápiarãnʉrejaimad̶a ʉ̃i yebai nore. ");
INSERT INTO cubNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pascua ãmicʉrijãravʉ, pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teinʉmʉ joabeno marejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ina sacerdotevare jaboteipõeva aru Jʉ̃menijicʉi yávaiye báquede bueipõeva jʉjovarĩ jẽni, boarĩ́ jarʉvaiyʉrejaimad̶a Jesúre. Ʉbenita jidʉrejaimad̶a ina obedivʉ põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Dinʉmʉre ñai abujuvai jabocʉ, Satanás, d̶aicõjenejaquemavʉ Judas Iscariotede, ñai cũinácʉ ina doce paivʉ Jesúi bueimaracacʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Que teni ñai Judas coyʉcʉnʉrejamed̶a ina sacerdotevare jaboteipõevare aru ina Jʉ̃menijicʉi cʉ̃ramine coreipõevare máre. Náre jẽni jíyʉrejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ʉ̃i d̶aiyʉede jápiarĩ, torojʉrejaimad̶a na. Que baru arejaimad̶a ʉ̃́re: “Ñʉja jínajivʉbu mʉre tãutʉrare, ñʉjare mi jẽni jíye boje ʉ̃́re yavenina”, arejaimad̶a Judare. ");
INSERT INTO cubNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas jʉ arejamed̶a náre. Que baru jã́ri coreni bʉ́rejamed̶a, jẽni jícʉyʉ Jesúre yavenina, ina obedivʉ põeva ne jã́menoi. ");
INSERT INTO cubNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pã́ure bʉcʉre d̶aiye cʉbe ãiye torojʉve teijãravʉ barejávʉ̃ya. Pascua jãravʉcacʉre, ovejajĩcʉre, boarĩ́, toaque juarĩ, ã́varejaimad̶a dijãravʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Que baru Jesús, Pedrore aru Jũare máre jarorĩ, arejamed̶a náre: —Mead̶arãnʉjara maje Pascua jãravʉque ãiyede maje ãrajiyede, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aru jẽniari jã́rejaimad̶a Jesúre: —¿Ã́ri nʉri mead̶acarãjidica ñʉja diede? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ʉ̃ arejamed̶a náre: —Mʉja ecoivʉ bácavʉ ĩmarore, ẽmeni, nócacʉre oco tuyʉre copʉrãjaramu mʉja. Ʉ̃́que nʉri, cʉ̃ramine ʉ̃i ecoiyede cũinátʉrʉ mʉja máre ecojarã. ");
INSERT INTO cubNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Diñami upacʉre yópe ajarã mʉja: “ ‘¿Átucubʉba ji bueimaraque ji Pascua jãravʉre ji ãquitucubʉ?’ aibi bueipõecʉ”, ajarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Diñami upacʉcapũravʉ pʉenocatucubʉ ʉratucubʉ jave majare jaʉéde mead̶aitucubʉ bácarõre mʉjare jã́d̶ovacʉyʉme ʉ̃. Noi ditucubʉi majare maje ãrajiyede mead̶ajarã mʉja, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ʉ̃́re jʉ arĩ, nʉri, ĩmaroi earejaimad̶a na. Earĩ, nore Jesús ʉ̃i aiye báquepedeca ʉ̃i aitucubʉre earejaimad̶a. Noi Pascua jãravʉque ãiyede mead̶arejaimad̶a na pʉcarã. ");
INSERT INTO cubNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Que teni ne Pascua ãiora barejávʉ̃ya. Jesús earĩ, dobarejamed̶a tʉoiva yebai ʉ̃i yávaiye méne beorĩ coyʉicõjeimaraque. ");
INSERT INTO cubNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Aru arejamed̶a náre: —Pare ãiyʉvʉ yʉ iye Pascua ãiyede mʉjaque ji ñájiquiye jipocai. ");
INSERT INTO cubNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Que baru coyʉyʉbu mʉjare: Ãmecʉbu yʉ Pascua jãravʉque ãiyede cojedeca, pʉ Jʉ̃menijicʉi jaboteino eaiyeta, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ũcuidore ĩni, Jʉ̃menijicʉre torojʉede jíniburu yóboi, arejamed̶a: —Ʉ̃jʉ, coapavajarã dicorore mʉje baju. ");
INSERT INTO cubNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Que baru coyʉyʉbu mʉjare: Quénora vino ʉ́yaicorore ũcuñʉmu yʉ ijãravʉre. Ũcumecʉbu dicorore cojedeca, pʉ Jʉ̃menijicʉi jaboteinʉmʉita, arejamed̶a ʉ̃i bueimarare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ne ãiyedeca, pã́ure ĩni, Jʉ̃menijicʉre torojʉede jídejamed̶a Jesús. Torojʉede jíni bʉojarĩ, pã́ure cotʉvarejamed̶a. Cotʉvarĩ bʉojarĩ, náre coapa jíni, arejamed̶a: —Dápiajarã iye pã́ure yópe mʉje dápiaiyepe ji bajure. Jíquijivʉ yʉ ji bajure, ne boarĩ́ jarʉvarãjiyepe yʉre, mʉjare ji mead̶aquiye boje. Que baru mʉje ãiyede iye pã́ure, ãrʉjara yʉre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aru nopedeca ũcuidore ĩni, ne ãri bubarĩburu yóboi, Jesús arejamed̶a: —Dápiajarã iye ũcuiyede yópe mʉje dápiaiyepe ji jivede. Jíquijivʉ yʉ ji jivede, ne boarĩ́ jarʉvarãjiyepe yʉre, mʉjare ji mead̶aquiye boje. Que baru yʉre mequiyebu ji jive obedivʉre boje. Jʉ̃menijicʉ “Yópe d̶ajarã mʉja, boropatebenajivʉ ji jã́inoi”, ʉ̃i yóbocarõ coyʉino mácarõre põevare ãrʉrajaramu mʉja, mʉje ũcuiyede diede. ");
INSERT INTO cubNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ʉbenita jã́jara. Ñai ʉ̃mʉ jẽni jícʉyʉ yʉre ji mauvare cʉbi yui tʉoiva yebai yʉ́que. ");
INSERT INTO cubNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ijãravʉi, ji yaijãravʉi nʉcʉyʉmu yʉ, yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃i yávaiyede. Ʉbenita ãmeno vaicʉ́yʉme ʉ̃, ñai yʉre jẽni jíyʉ bacʉyʉ́, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Que baru jẽniari jã́ri bʉ́rejaimad̶a ne bajumia: —¿Ñame maquidí jẽni jíyʉ Jesúre ʉ̃i mauvare? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jesúi bueimara yópe yávarejaimad̶a ne bajumia: —¿Ñamema majacacʉ parʉcʉ apevʉ pʉeno? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús arejamed̶a náre: —Ina judíova ãmevʉ ne jabova parʉéque cõjeivʉbu ne jaborõcavʉre, ne d̶acarãjiyepe aivʉ náre ne ʉrõpe. Aru ina jaborõcavʉ, “Ñʉjare cad̶ateipõevatamu”, aivʉbu ne jabovare. ");
INSERT INTO cubNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ʉbenita nápe d̶abejarã mʉja. Ñai mʉjacacʉ parʉcʉ baiyʉcʉ baru, mʉjeyocʉpe memecajacʉrĩ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Apevʉ dobarivʉbu tʉoiva yebai. Aru apevʉ, ne yebacavʉ, jíyama ina dobarivʉre ne ãiyede. ¿Ñamema parʉcʉ apevʉ pʉeno? ¿Ñai dobacʉ tʉoiva yebai o ñai yebacacʉ pʉeno parʉcʉba? Jãve ñai dobacʉ tʉoiva yebai pʉeno parʉcʉbe. Ʉbenita yʉ cʉvʉ mʉje jẽneboi yebacacʉpe. ");
INSERT INTO cubNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Mʉja dajocabevʉ yʉre ji ñájiyede, quénora ñájivʉ mʉja cũinátʉrʉ yʉ́que. ");
INSERT INTO cubNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Yópe jipacʉ ʉ̃i jíyepe yʉre ji jabotequinore, nopedeca yʉ máre jívʉ mʉjare mʉje jabotenajinore, mʉje dobarãjiyepe ayʉ ji tʉoiva yebai ji jabotequiyede, ãrajivʉ aru ũcurajivʉ yʉ́que, aru mʉje dobarãjiyepe ayʉ jabovai dobarõa mearoara, coyʉrãjivʉ mearare o ãmenare ina doce paiyajuboa Israecavʉre, arejamed̶a Jesús ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús arejamed̶a Simón Pedrore: —Mʉ, Simón, ñai abujuvai jabocʉ Satanáre Jʉ̃menijicʉ jʉjovaicõjeimi mʉjare, yópe põeva ne jajʉóiyepe matore. ");
INSERT INTO cubNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ʉbenita yʉ jẽniaivʉ Jʉ̃menijicʉque, mi dajocabequiyepe ayʉ mi jʉ aiyede ʉ̃́re. Ñai abujuvai jabocʉ mʉre jʉjovarĩburu yóboi, mi me cʉquiyede Jʉ̃menijicʉque cojedeca, cad̶atejacʉ apevʉ ʉ̃́re jʉ aivʉre, mi yóvaimarare, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Aru Simón Pedro arĩdurejamed̶a Jesúre: —Mʉ, ji jabocʉ, ãmeina teivʉre jẽni jacoiñami mʉ́que nʉñʉ bʉojaivʉ yʉ. Aru mʉ́que yaiyʉ́ máre bʉojaivʉ yʉ, arĩdurejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ʉbenita Jesús arejamed̶a ʉ̃́re: —Mʉ, Pedro, coyʉyʉbu mʉre: “Jesúre yʉ coreóvabevʉ”, acʉyʉmu mʉ cari ñami, cáyu ʉ̃i órejaquiye jipocai. Aru yóbecʉe nópe acʉyʉmu mʉ, arejamed̶a Pedrore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús arejamed̶a náre, ʉ̃i bueimarare: —Javede ji jaroiyede mʉjare nʉvameteavʉ̃ mʉja tãutʉrare, aru curubʉare, aru cʉraidoare máre. ¿Ye jaʉtearĩ mʉjare? arejamed̶a náre Jesús. Aru jʉ arejaimad̶a ʉ̃́re: —Jaʉbeteavʉ̃ ñʉjare, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ʉ̃ arejamed̶a náre cojedeca: —Ʉbenita caride ñai tãutʉrare cʉvacʉ baru, nʉvajacʉrĩ diede. Aru ñai curubʉre máre cʉvacʉ baru, nʉvajacʉrĩ dicurubʉre. Aru ñai boaicarovede cʉvabecʉ baru, ʉ̃i pʉenocacaje doicajede jíjacʉrĩ, bojed̶acʉyʉ boaicarovede. ");
INSERT INTO cubNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Coyʉyʉbu mʉjare: Javede Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ, yópe arĩ, toivarejaquemavʉ yʉrã: “Põeva ʉ̃́re d̶arãjarama yópe ne d̶aiyepe ãmeina teivʉre”, arĩ toivarejaquemavʉ. Aru ji mauva d̶arãjarama yʉre nópe iye toivaiye báque coyʉiyepe, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Arejaimad̶a na: —Mʉ, ñʉje jabocʉ, jã́jacʉ. Yuibu pʉcavea boaicarovea, maje boarã́jivea, arejaimad̶a. Aru Jesús jʉ arejamed̶a náre: —Quénora meaquiyebu, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","No yóboi Jesús etarejamed̶a ne Pascua ãitucubʉre jocarĩ. Aru ʉ̃i d̶arĩ cõmajiyepe nʉrejamed̶a cʉ̃racũ Olivocũ ãmicʉricũi. Ʉ̃i bueimara máre yóvarejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ne eaiyede ʉ̃i nʉiyʉrõ mácarõi, Jesús arĩdurejamed̶a náre: —Jʉ̃menijicʉque borotejarã mʉja, abujuvai jabocʉi mʉjare jʉjovarĩ, ãmeina tede d̶abequiyepe aivʉ, arĩdurejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Que ayʉ bácʉ, náre jocarĩ nʉrejamed̶a, yópe põecʉ cʉ̃rabore dʉvarĩ jaroinope paino baji. Aru ñʉatutarĩ joborõi borotedejamed̶a Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Mʉ, jipacʉ, yʉre cari vaiquíye vaibéjad̶eni. Caiyede d̶aiye majicʉtamu mʉ. Ʉbenita ji ʉrõpe d̶abejacʉ. Quénora mi ʉrõpe d̶ajacʉ mʉ, arejamed̶a jípacʉre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Dinʉmʉre cũinácʉ ángele, cavarõ mearo Jʉ̃menijicʉi cʉrõcacʉ, járorejamed̶a ʉ̃i yebai, cad̶atecʉdayʉ earejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús ʉ̃i ʉrarõ ñájiye boje, pʉeno parʉrõ borotedejamed̶a Jʉ̃menijicʉque. Que teni ijove darĩ, jivepe tʉrejavʉ̃ya joborõi. ");
INSERT INTO cubNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Aru boroteni bʉojarĩ, nacajari copainʉrejamed̶a, ʉ̃i bueimara yebai. Earejamed̶a náre cãivʉre, ʉetʉivʉre, ne chĩoiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dinʉmʉ Jesús arejamed̶a náre: —¿Aipe teni cãivʉrʉ̃ mʉja? Nacajajara. Jʉ̃menijicʉque borotejarã mʉja, abujuvai jabocʉi mʉjare jʉjovarĩ, ãmeina tede d̶abequiyepe aivʉ, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ʉ̃i boroteiyedecata earejaimad̶a obedivʉ põeva. Judas, ina doce paivʉcacʉ, jipocatedejamed̶a náre. Jesús yebai nʉri, ʉ̃́re jiva nuri jacoyʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ʉbenita Jesús arejamed̶a ʉ̃́re: —Mʉ, Judas, ¿jiva nuri jacoyʉyʉrʉ̃ mʉ yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jẽni jícʉyʉ yʉre ji mauvare? arejamed̶a Jesús ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ina Jesúi yóvaimara, jã́ivʉ iyede vaiyede, jẽniari jã́ridurejaimad̶a Jesúre: —Mʉ, ñʉje jabocʉ, ¿boarã́jidi ñʉja náre iveá boaicaroveaque? arĩdurejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Dinʉmʉma cũinácʉ Jesúi yóvaimaracacʉ ʉ̃i boaicarovede tatorĩ, duarĩ, ĩni, sacerdotevare jaboteipõecʉi yebacacʉre juijórĩ najuárejamed̶a ʉ̃, ʉ̃i meapũravʉcacamucare. ");
INSERT INTO cubNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ʉbenita Jesús arejamed̶a: —Dajocajarã diede quénora, arejamed̶a. Que ayʉva, ʉ̃i cámucare tʉorĩ, ʉ̃́re mead̶arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Dinʉmʉre Jesús arejamed̶a ina sacerdotevare jaboteipõevare, aru ina Jʉ̃menijicʉi cʉ̃ramine coreipõevare, aru ina judíova bʉcʉvare máre: —¿Tatorĩ ñavaipõecʉre jẽivʉpe yʉre boaicaroveaque aru boaidʉaque jẽni jacorãdaivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jãravʉa coapa mʉjaque Jʉ̃menijicʉi cʉ̃rami cʉ́tecacʉ yʉ. Apʉrĩ mʉjaque cʉcʉre, yʉre jẽni jacobeteavʉ̃ mʉja. Ʉbenita caride Jʉ̃menijicʉ mʉjare d̶aicõjeñʉme mʉje ʉrõpe yʉ́que. Aru caride abujuvai jabocʉ ãmeno d̶are d̶aibi yʉre, yópe mʉje ʉrõpe, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Que arurata Jesúre jẽni, sacerdotevare jaboteipõecʉi cʉ̃rami nʉvarejaimad̶a ʉ̃́re. Aru Pedro joajĩenata ʉ̃i yóboi nʉre nʉñʉ mácʉ, sacerdotevare jaboteipõecʉi tãibʉi ecorejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Apevʉ Jesúre nʉvaivʉ bácavʉcavʉ toabore dacuvarĩburu yóboi, dobarejaimad̶a toabo ẽcarʉi nore tãibʉ coricai. Aru Pedro máre dobarejamed̶a ne jẽneboi. ");
INSERT INTO cubNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ʉ̃i noi dobaedeca, yebacarõmivacaco cũináco jã́rejacod̶a Pedrore, toabo pẽoiyede ʉ̃i jivare. Ʉ̃́re me cocorĩ, arejacod̶a: —Ñai ʉ̃mʉ máre cʉ́tebi Jesúque, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ʉbenita Pedro jʉ abedejamed̶a õi yávaiyede: —Jesúre yʉ coreóvabevʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Que arĩburu yójĩboi, apecʉ, Pedrore jã́ñʉ, arejamed̶a: —Mʉ máre nácacʉbu, arejamed̶a. Ʉbenita Pedrocapũravʉ arejamed̶a cojedeca: —¡Nácacʉ ãmevʉ! Jesúre yʉ coreóvabevʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cũináora yóboi, apecʉ máre arejamed̶a parʉrõreca: —Jãve ñai ʉ̃mʉ cʉ́tebi Jesúque. Ʉ̃ máre Galileacacʉtame ʉ̃, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ʉbenita Pedrocapũravʉ jãve ayʉpe, pare baju arejamed̶a cojedeca: —¡Jãveneca Jʉ̃menijicʉi jã́inoi yʉ mʉre coyʉyʉtamu! ¡Jãve ji coyʉbedu, Jʉ̃menijicʉ ãmed̶ajacʉrĩ yʉre! Mi aimʉre ye majibecʉtamu yʉ. Ñai Jesúre yʉ coreóvabevʉ, arejamed̶a. Dinʉmʉma, ʉ̃i que aiye bajure, órejarejamed̶a cáyu. ");
INSERT INTO cubNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Que teiyedata, Jesús copedini jã́rejamed̶a Pedrore. Aru ʉ̃ ãrʉrejamed̶a Jesús ʉ̃i coyʉiye báquede: “Cari ñami, cáyu ʉ̃i órejaquiye jipocai, yóbecʉe baju ‘Jesúre yʉ coreóvabevʉ’, acʉyʉmu mʉ”, arĩ coyʉiye báquede ãrʉrejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Aru ãrʉcʉ, cũiná etarĩ, pare chĩori orejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ina Jesúre coreipõeva yʉridejaimad̶a ʉ̃́re. Aru totatarejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ʉ̃i yacorʉare moari, ʉ̃́re pẽvavari, arejaimad̶a: —Coyʉjacʉ mʉ. ¿Ñame matedí mʉre pẽvañʉ? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aru ʉrarõ yávarĩ, ãmeina yávarejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aviá ʉ̃i tucʉmʉiyede, ina judíova bʉcʉva, aru ina sacerdotevare jaboteipõeva, aru ina Jʉ̃menijicʉi yávaiye báquede bueipõeva máre cójijidejaimad̶a na. Nʉvarejaimad̶a Jesúre ne cójijinoi. Aru arejaimad̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Mʉ Cristo baru, coyʉjacʉ ñʉjare, arejaimad̶a na. Aru Jesús arejamed̶a náre: —Ji coyʉru, mʉja jʉ abenajaramu yʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aru ji jẽniari jã́ru, jʉ abenajaramu mʉja yʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ʉbenita yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jã́rajaramu mʉja caride pʉ cainʉmʉa Jʉ̃menijicʉ parʉcʉi meapũravʉi dobacʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Dinʉmʉ caivʉ ina jẽniari jã́rejaimad̶a: —¿Jʉ̃menijicʉi mácʉrʉ̃ mʉ? arejaimad̶a. Jesús jʉ ayʉ náre arejamed̶a: —Quédeca, mʉje aimʉrecabu yʉ, arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nácapũravʉ arejaimad̶a: —Apevʉ ne coyʉiye jaʉbevʉ. Javeta jápiad̶avʉ̃ maja ʉ̃i coyʉiyede ʉ̃i baju ãmeina teyʉre, jorojĩni arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","No yóboi caivʉ ina judíovai cójijinocavʉ nacajari, Jesúre nʉvari, jabocʉ ʉ̃i ãmiá Pilato yebai jacorãnʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aru ãmecororĩ bʉ́rejaimad̶a Jesúre. —Ñʉja eavʉ ñai ʉ̃mʉre jarʉvarĩduyʉre maje jaborõre, aru bojed̶aicõjemecʉre ñʉjare tãutʉrare maje jabocʉ Césare, aru ayʉre ʉ̃i baju “Cristobu yʉ” aru jabocʉ máre, arejaimad̶a na Pilatore. ");
INSERT INTO cubNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ne que aiyede, Pilato jẽniari jã́rejamed̶a Jesúre: —¿Mʉ́rʉ judíovai jabocʉ? arejamed̶a. Jesús jʉ arejamed̶a: —Quédeca, mi aimʉrecabu yʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato arejamed̶a ina sacerdotevare jaboteipõevare aru caivʉ ina obedivʉ põevare: —Ãmeina tebecʉtame ʉ̃ ji jã́ru, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ʉbenita parʉrõreca arejaimad̶a bedióva cojedeca: —Ñai cãrijovaimi caivʉ Judeacavʉre ʉ̃i bueiyeque. Bueni bʉ́quemavʉ Galileai. Aru edaibi yuita, jorojĩvʉ arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ne nópe ãmecoroiyede jápiarĩ Pilato, jẽniari jã́rejamed̶a: —¿Galileacacʉba ʉ̃? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ina Jesúre ãmecoroivʉ ne jʉ aiyede, Pilato majicʉ Jesúre Galileacacʉre, jarorejamed̶a ʉ̃́re Galileacavʉ ne jabocʉ Herodes yebai. Dinʉmʉ ñai Herodes Jerusalén ãmicʉriĩmaroi cʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesúre jã́ri, torojʉrejamed̶a Herodes, ʉ̃i jápiaiye báque boje Jesúi d̶aiye báque borore. Que baru ʉ̃́re pare jã́iyʉcʉ barejámed̶a. Jesús põeva ne d̶arĩ majibede d̶ayʉre pare jã́iyʉrejamed̶a Herodes. ");
INSERT INTO cubNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jesúre caijĩene jẽniari jã́ridurejamed̶a Herodes. Ʉbenita Jesúcapũravʉ bi arejamed̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Herodes ʉ̃i jẽniari jã́iyede Jesúre, pare ãmecoroivʉ barejáimad̶a ina sacerdotevare jaboteipõeva aru Jʉ̃menijicʉi yávaiye báquede bueipõeva máre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Dinʉmʉma Jesúre yʉrini, ãmeno baju ʉ̃́re d̶arejaimad̶a na, Herodes ʉ̃i churaravaque. Doicaje meacajede Jesúre doarĩ, ʉ̃́re yʉrini, Pilato yebai jacopaiyovarĩ jarorejamed̶a Herodes. ");
INSERT INTO cubNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jipocare ina jabova pʉcarã maucʉvarejaimad̶a ne baju. Ʉbenita ne que teijãravʉi, dijãravʉ baji, boroteni, mead̶arejaimad̶a ne baju, Herodes Pilatomaque. ");
INSERT INTO cubNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","No yóboi Pilato cójijovarejamed̶a ina sacerdotevare jaboteipõevare aru apevʉ judíova cójijinocavʉre máre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ne cójijiyede ʉ̃i yebai, arejamed̶a náre: —Ñai ʉ̃mʉre davaivʉbu mʉja ji yebai. Ʉ̃́re boro coyʉrĩ ad̶arĩ, “Ʉ̃ jarʉvarĩduibi maje jaborõre”, aivʉbu yʉre. Ʉbenita mʉje jã́inoi yʉ́vacari jẽniari jã́ivʉ ʉ̃́re ʉ̃i d̶aiye báquede. Aru ʉ̃i coyʉiyede jápiarĩburu, coyʉyʉbu mʉjare: Ãmeina tebecʉtame ʉ̃ ji jã́ru. ");
INSERT INTO cubNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes máre Jesús ʉ̃i ãmeina teiyede eabetecʉbe. Que baru jacopaiyovacʉbe ʉ̃́re ñʉje yebai cojedeca. Jápiajarã. Coreóvaivʉbu mʉja. Ʉ̃i ãmeno d̶aru, ʉ̃́re boarĩ́ jarʉvaicõjejebu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Que baru jara popeicõjeniburu yóboi, jaetovaquijivʉ ʉ̃́re, arejamed̶a náre Pilato. ");
INSERT INTO cubNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nópe d̶ayʉ Pilato, ʉ̃i d̶arĩ cõmajiye boje ʉjʉá coapa no torojʉve teinʉmʉre, cũinácʉ jacoimʉ mácʉre, põeva ne etavaicõjeimʉre, jaetovavarejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ʉbenita caivʉ ina põeva cod̶oboborejaimad̶a cũinátʉrʉ, boarĩ́ jarʉvaicõjeivʉ Jesúre. —¡Ñaine boarĩ́ jarʉvaicõjejacʉ mʉ! Barrabáre jaetovajacʉ mʉ, arĩ cod̶oboborejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ñai Barrabás ãmicʉcʉre jacorejaimad̶a ãmeina teivʉre jẽni jacoiñami ʉ̃i boarĩ́ jarʉvaiyʉe boje Romacavʉre, ne jaboteiye boje Jerusalén ãmicʉriĩmarore, aru põevare ʉ̃i boarĩ́ jarʉvaiye báque boje máre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ʉbenita Pilatocapũravʉ jaetovaiyʉrejamed̶a Jesúre. Que baru bedióva cojedeca coyʉrĩdurejamed̶a ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ʉbenita cojedeca cod̶oboborejaimad̶a ina põevacapũravʉ, boarĩ́ jarʉvaicõjeivʉ Jesúre. —¡Ʉ̃́re jocʉcʉjaravena pẽvari boarĩ́ jarʉvaicõjejacʉ mʉ! arĩ cod̶oboborejaimad̶a Pilatore. ");
INSERT INTO cubNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bedióva cojedeca Pilatocapũravʉ arĩdurejamed̶a náre: —¿Yéde ãmeina tearĩ ñai? Coreóvaivʉbu mʉja. Ʉ̃i ãmeno d̶aru, ʉ̃́re boarĩ́ jarʉvaicõjejebu yʉ. Que baru jara popeicõjeniburu yóboi, jaetovaquijivʉ ʉ̃́re, arĩdurejamed̶a Pilato náre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ʉbenita ina põevacapũravʉ parʉrõreca cod̶oboborĩ bʉjiéque boarĩ́ jarʉvaicõjenejaimad̶a Jesúre. Que baru Pilato jʉ arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Boarĩ́ jarʉvaicõjenejamed̶a ʉ̃́re ina põeva ne ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato jaetovarejamed̶a ñai boarĩ́ jarʉvayʉ bácʉre, ãmeina teivʉre jẽni jacoiñamicacʉre, ne jẽniaimʉre. Ʉbenita jídejamed̶a Jesúre náre, ne d̶arãjiyepe ayʉ ʉ̃́re yópe ne ʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesúre nʉvarejaimad̶a. Jocʉcʉjaravede ture nʉñʉ maridurejamed̶a ʉ̃. Aru cuyʉ bácʉ ĩmaroi earejamed̶a Simón, Cirene ãmicʉriĩmarocacʉ. Nore vaiyʉ́re, ʉ̃́re Jesús ʉ̃i jocʉcʉjaravede tuino mácarõre tuicõjenejaimad̶a na, churarava, Jesús yóboi. ");
INSERT INTO cubNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Obedivʉ põeva nʉrejaimad̶a ʉ̃i yóboi. Aru nácavʉ nomiva orejaimad̶a pare, ne chĩoiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ʉbenita Jesús copedini, náre jã́ri, arejamed̶a: —Mʉja, Jerusalẽ́cavʉ, obejarã yʉre. Quénora ojarã mʉje bajure, mʉjemarare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Apejãravʉa baquiyéde põeva arãjarama yópe: “Torojʉrãjarama ina jʉed̶ocʉvabevʉ, aru ina jʉed̶oeabevʉ máre”. ");
INSERT INTO cubNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Arãjarama cʉ̃racũa ʉracũare: “Tʉjacũari ñʉjare”. Aru arãjarama cʉ̃racũare: “Yavejacũari ñʉjare”. ");
INSERT INTO cubNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mʉja jã́ivʉ ne d̶aiyede yʉre, meacʉre, jocʉcʉpe páyʉre. Que baru jãve pʉeno ãmeno d̶arãjarama mʉjare, ãmenare, yópe pecacʉape paivʉre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Aru pʉcarã ãmeina teivʉre máre nʉvarejaimad̶a ina churarava, Jesúque ne boarĩ́ jarʉvarãjimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Põe jipobʉcũ ãmicʉricũ cʉ̃racũi eaivʉ, Jesúre jocʉcʉjaravena pẽvari jẽorejaimad̶a na. Aru ina pʉcarãre máre ne jocʉcʉjaravea coapa pẽvari jẽorejaimad̶a na, cũinácʉre meapũravʉi, apecʉre cãcopũravʉi, aru Jesúre ne coricai. ");
INSERT INTO cubNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ʉbenita Jesús arejamed̶a: —Mʉ, jipacʉ, ne ãmeina teiyede ãrʉmetejacʉ mʉ. Coreóvabema ne d̶ainore, arejamed̶a Jesús jípacʉre. Churarava ne yajuiyede dʉvarĩ, cainijidʉa etaiyede jã́ri, Jesús ʉ̃i doiyede náre coapa ĩnejaimad̶a na, ʉ̃́re pẽvaivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Põeva nore cocoivʉ barejáimad̶a. Aru nácavʉ judíovai jabova, Jesúre yʉrivʉ, yópe arejaimad̶a na: —Apevʉre mead̶avacacʉ. Caride jãve Jʉ̃menijicʉi beoimʉ maru, Cristo baju baru, ʉ̃i bajure mead̶ajacʉrĩ ʉ̃, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ina churarava máre ʉ̃́re yʉrivʉ barejáimad̶a na. Ʉ̃i yebai nʉri, ũcuiye upiáteiye báquede ʉ̃́re jínidurejaimad̶a na, ʉ̃́re ijibequiyepe aivʉ. Aru arejaimad̶a ʉ̃́re: ");
INSERT INTO cubNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Mʉ judíovai jabocʉ baru, mi baju mi yaiquínore mead̶ajacʉ, arejaimad̶a Jesúre ina churarava. ");
INSERT INTO cubNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jocʉcʉjaravena, ʉ̃i pʉenoi, toivaino jẽnejavʉ̃ya. “Judíovai jabocʉbe”, aiyʉrejavʉ̃ya no toivaino. Griegova ne yávaicamuaque, Romacavʉ ne yávaicamuaque, aru judíova ne yávaicamuaque máre toivarejaimad̶a nore. ");
INSERT INTO cubNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Aru cũinácʉ ina ãmeina teivʉcacʉ, jocʉcʉjaravena ne pẽvaimʉ mácʉ, Jesúre ãmeina yávarejamed̶a ʉ̃ máre. —Mʉ, ¿Cristo ãmecʉrʉ̃ mʉ? Cristo baju baru, mi baju mi yaiquínore mead̶arĩ, ñʉjare máre ñʉje yainájiyede mead̶acajacʉ mʉ, arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ʉbenita apecʉcapũravʉ Jesúre ãmeina ayʉre jã́ri, jararejamed̶a: —¿Jʉ̃menijicʉre jidʉbecʉrʉ̃ mʉ? Maja yaivʉtamu, maje ãmeina teiye báque boje. ");
INSERT INTO cubNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Que baru ãmeno vaivʉ majare. Ʉbenita ñai ãmeina tebecʉtame ʉ̃. Majacapũravʉ maje ãmeina teiye báquede bojed̶aivʉtamu maja, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Que ayʉva, arejamed̶a Jesúre: —Mʉ, Jesús, jabocʉ bacʉyʉ́, ãrʉjacʉ yʉre, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Aru Jesús jʉ arejamed̶a ʉ̃́re: —Jãve coyʉyʉbu mʉre: Cari jãravʉmica Paraíso ãmicʉrõi yʉ́que cʉcʉyʉmu mʉ, arejamed̶a Jesús ñai chĩoñʉre ʉ̃i ãmeina teiye báquede. ");
INSERT INTO cubNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jãravʉ corica baji ñemié tʉrĩ darejavʉ̃ya caino joborõi. Pʉ yóbecʉriora yóboita vaidéjavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Que baru yóbecʉriora baju ye aviá pẽomenejamed̶a. Aru Jʉ̃menijicʉi cʉ̃ramicacaje ʉracaje coricõpavaicaje bácarõ quéda corica baji jad̶eni nʉrejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Dinʉmʉre pare bʉjié cod̶oboborĩ, yávarĩ darorejamed̶a Jesús: —Mʉ, jipacʉ, ji ũmene mʉre jíyʉbu yʉ, arejamed̶a Jʉ̃menijicʉre. Que ayʉva, yaidéjamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nore Jesús bácʉre cocorĩ núcʉ barejámed̶a churaravai jabocʉ. Jesús yaiyʉ́re jã́ri, mearore jídejamed̶a Jʉ̃menijicʉre. —¡Jãveneca ñai ʉ̃mʉ ãmeina tebecʉ batecʉ́be! arejamed̶a churaravai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Aru caivʉ ina obedivʉ põeva cójijivʉ bácavʉ nore, Jesús yaiyʉ́ bácʉre jã́ivʉ, copainʉrejaimad̶a ne cʉ̃ramia coapa, totaivʉ ne ñarebare, ne chĩoiye boje. ");
INSERT INTO cubNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Caivʉ Jesús bácʉi coreóvaimara, aru ina nomiva, Galilea ãmicʉrõre jocarĩ daivʉ bácavʉ ʉ̃́que, na máre cocorĩ núrejaimad̶a joajĩemia. ");
INSERT INTO cubNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Cũinácʉ ʉ̃mʉ cʉrejamed̶a, ʉ̃i ãmiá José, Arimatea ãmicʉriĩmarocacʉ. Sacerdotevai cójijinore coyʉipõevacacʉ barejámed̶a ʉ̃. Ñai José meacʉ aru ãmeina tebecʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Que baru jʉ abedejamed̶a ina judíovai cójijinocavʉ ne d̶aiye báquede Jesúre. Ʉ̃ máre Jʉ̃menijicʉi jabotequinʉmʉ maquinóre napini coreyʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilato yebai nʉri, Jesús bácʉi baju bácarõre jẽniacʉnʉrejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato ʉ̃i jẽniaiyede jʉ arĩburu yóboi, Jesús bácʉre jocʉcʉjaravede jõd̶avari, ĩni, meacaje boricaje lino ãmicʉricajeque cũmari nʉvarejaimad̶a ʉ̃ mácʉre cʉ̃racobei. Põeva ne yaivʉ bácavʉ ne ĩmamecobe barejávʉ̃ya dicobe. Aru dicobei Joséjã jarʉvarejaimad̶a Jesús bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Dijãravʉ, nainú, torojʉve teijãravʉ baquinóre mead̶aijãravʉ barejávʉ̃ya. Sábado baquinó jipocacajãravʉ barejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ina nomiva Jesúque eaivʉ bácavʉ Galilea ãmicʉrõre jocarĩ, Joséjã yóboi nʉri, jã́rejaimad̶a dicobede aru ne jarʉvaiyede Jesús bácʉi baju bácarõre nore. ");
INSERT INTO cubNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jã́ri bʉojarĩ, copainʉrejaimad̶a na, mead̶arãjivʉ mumijʉede aru jĩjovaiyede máre, ne nʉvarajiyede sábado jãravʉ yóboi, mead̶arãjivʉ Jesús bácʉi baju bácarõre dieque. Aru judíovai jabʉóvaijãravʉ sábadoi, jabʉóvarejaimad̶a na yópe Jʉ̃menijicʉi d̶aicõjeiye báquepe. ");
INSERT INTO cubNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","No sumana bʉijãravʉ domingo javejĩnara, aviá ʉ̃i tucʉmʉiyede, ina nomiva nʉrejaimad̶a Jesús bácʉre ne jarʉvainoi, nʉvaivʉ mumijʉede, ne mead̶aiye báquede, yuarãjivʉ diede Jesús bácʉi baju bácarõre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Dicobe cʉ̃racobede cʉrejavʉ̃ya bieitʉrava cʉ̃ratʉrava ʉratʉrava. Dinomiva ne eaiyede ʉ̃ mácʉre ne jarʉvainore, earejaimad̶a dicobe biebecobede. ");
INSERT INTO cubNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ʉbenita ne ecoiyede dicobei, Jesús bácʉi baju bácarõre eabedejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Cãrijini dápiaivʉ, “¿Ã́ri cʉri Jesús bácʉi baju bácarõ?” arejaimad̶a ne bajumia. Ne nópe dápiaiyedeca, járorejaimad̶a pʉcarã ʉ̃mʉva, núrivʉ ne yebai. Aru ne doicajea boricajea pare pẽorejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Que baru ina nomiva, cuecumaivʉ, doco jã́rejaimad̶a na, ne jidʉé boje. Aru ina ʉ̃mʉva arejaimad̶a náre: —¿Aipe teni voivʉrʉ̃ mʉja apʉcʉre yaivʉ bácavʉre ne jarʉvainoi? ");
INSERT INTO cubNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús jave nacajami yainore jarʉvarĩ. Que baru cʉbebi yore. ¿Ãrʉmetenarʉ mʉja ʉ̃i coyʉiye báquede mʉjare nore Galileai? ");
INSERT INTO cubNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Coyʉquemavʉ mʉjare yópe: “Jaʉvʉ yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, ji ʉrarõ ñájiquino. Jẽni jínajarama yʉre ina ãmeina teivʉre, ne pẽvari boarĩ́ jarʉvarãjiyepe yʉre. Aru yóbecʉrijãravʉa yóboi yainore jarʉvarĩ nacajacʉyʉmu yʉ”, aquemavʉ mʉjare Jesús, arejaimad̶a na nomivare. ");
INSERT INTO cubNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ne que aiyede, ina nomiva ãrʉrejaimad̶a Jesús ʉ̃i coyʉiye báquede náre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Copainʉriburu yóboi Jesús bácʉre ne jarʉvaino mácarõre jocarĩ, caiye ne jã́iye báquede coyʉrejaimad̶a ina once paivʉre aru apevʉ Jesúi yóvaimarare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iye borore coyʉivʉ bácavʉ barejáimad̶a María Magdalacaco, aru Juana, aru apeco María, Santiagoi paco máre, aru apevʉ nomiva náque cʉrivʉ. Ina coyʉrĩdurejaimad̶a ne jã́ino mácarõre Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ʉbenita nácapũravʉ jʉ abedejaimad̶a ina nomiva ne coyʉiyede. “¿Ʉbeni márica?” arĩ dápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ʉbenita Pedro nacajari, cúyarĩ, earejamed̶a Jesús bácʉre ne jarʉvaino mácarõ yebai. Dicobei nacachini, jã́rejamed̶a Jesúi cũmaicajea báquede, lino ãmicʉricajea paraicajeare cũinároma. Que teni Pedro, pare dápiayʉ, cʉ̃rami copainʉrejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Dijãravʉmica Jesúi bueimaracavʉ pʉcarã Emaús ãmicʉriĩmaroi nʉivʉ barejáimad̶a na, Jerusalén ãmicʉriĩmaroi cʉrivʉ bácavʉ. Jerusalén joabejĩnoi, once paikilometros baju barejávʉ̃ya diĩmaro. ");
INSERT INTO cubNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nʉre nʉivʉvacari boroteivʉ barejáimad̶a na, yo Jesús bácʉi baju bácarõ bíjaino mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Diede boroteivʉ ne yávare nʉiyedeca mái, Jesús ʉ̃i baju nára earejamed̶a ʉ̃. Náque vaivárĩ nʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Vaivárĩ nʉñʉreca náque, ʉ̃́re coreóvabedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Aru náre arejamed̶a Jesús: —¿Aipe arĩ boroteivʉrʉ̃ mʉja, mái nʉivʉ? ¿Aipe teni chĩoivʉrʉ̃ mʉja? arejamed̶a. Ʉ̃i que aiyede, dajocarĩ, núranʉrejaimad̶a na, chĩoivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Aru nácacʉ cũinácʉ, Cleofas ãmicʉcʉ, arejamed̶a Jesúre: —¿Mʉ máre Jerusalẽ́i cʉcʉvacari, caiye vaiye báquede majibecʉrʉ̃ mʉ? arejamed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Yéde? jẽniari jã́rejamed̶a náre Jesús. Aru arejaimad̶a: —¿Jesús Nazarecacʉ bácʉre vaiye báquede jápiabetecʉrʉ̃? Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ baju bateáme ʉ̃. Jʉ̃menijicʉi jã́inoi aru põeva ne jã́iyede máre caiye ʉ̃i d̶aiye báque aru caiye ʉ̃i coyʉiye báque máre me mateávʉ̃. Coyʉrĩ parʉcʉ bateáme ʉ̃ mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aru ʉ̃́re boarĩ́ jarʉvaicõjeni, ʉ̃́re jocʉcʉjaravena pẽvaicõjeima na sacerdotevare jaboteipõeva ina maje jabovaque. ");
INSERT INTO cubNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ʉbenita, “Ʉ̃ majʉbí Israecavʉre mead̶aipõecʉ bacʉyʉ́”, aivʉ bateávʉ̃ ñʉja. Cari jãravʉque yóbecʉrijãravʉa nʉivʉ ʉ̃i yainíburu yóboi. ");
INSERT INTO cubNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ñʉjacavʉ nomiva ñʉjare cuavama caride. Cari jãravʉ javejĩnara ʉ̃ mácʉre ne jarʉvainoi nʉmad̶a na, ñʉje nomiva. ");
INSERT INTO cubNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ʉbenita ʉ̃ mácʉi baju bácarõ cʉbetevʉya. Eabetemad̶a na. Aru yópe arĩ, ñʉjare coyʉrãedama na nomiva: “Ángelevare jã́vʉ ñʉja. ‘Apʉbi ʉ̃ Jesús’, ama na”, ama ñʉjare dinomiva. ");
INSERT INTO cubNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Dinʉmʉma ñʉjacavʉ apevʉ, “¿Jãve márica no?” arĩ, jã́ranʉma na nomicata. Nomiva ne aiye báquepedeca jã́mad̶a na máre. Ʉbenita ʉ̃́re, Jesúre, jã́metemad̶a na, arĩ coyʉrejaimad̶a ina pʉcarã mái nʉipõeva. ");
INSERT INTO cubNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Náre arejamed̶a Jesús: —Dápiabevʉtamu mʉja. Coreóvabeni cʉrivʉtamu mʉja. Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivaiye báque caiyede jápiarĩ coreóvabevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nópe ãmeno vaijébu Cristo. Aru no yóboi, ãmeno vaiyʉ́ bácʉ, caiyede jaʉbeda jebeyʉ bácʉ, meacʉ baju nʉjebu cavarõ mearo Jʉ̃menijicʉi cʉrõi, arĩ coyʉrejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aru coyʉrĩ bʉ́rĩ Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i toivaicõjeiye báquede Moisés bácʉre, aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivaiye báquede coyʉrĩ jebedejamed̶a náre Jesús caiye ʉ̃i borore. ");
INSERT INTO cubNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ĩmaro ne earãjino joabejĩnoi eaiyede, nʉñʉpe tedejamed̶a Jesúcapũravʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ʉbenita ne yebai mauteicõjenejaimad̶a na: —Yui ñʉjaque cʉjacʉ mʉ. Jã́jacʉ, jave nainútamu. Jave ñemié tʉinotamu, arejaimad̶a Jesúre. Que teni ne yebai nʉrejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Náque cʉrĩ, dobarejamed̶a Jesús, ãcʉyʉ náque. Pã́ure ĩni, Jʉ̃menijicʉre torojʉede jíni, pã́ure cotʉvarĩ, náre jídejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ʉ̃i pã́ure cotʉvarĩ jíye bajure, ʉ̃́re coreóvarejaimad̶a na. Ne coreóvaiye bajure cũiná náre bíjarejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Que teiyede, arejaimad̶a na, ne bajumia boroteivʉ: —Jãvemu. Ʉ̃i boroteiyede majare mái Jʉ̃menijicʉi yávaiyede coyʉyʉ, maja meaũme cʉ́tevʉ, arejaimad̶a na, Jesús ʉ̃i bíjarĩburu yóboi. ");
INSERT INTO cubNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Que teninata, cũiná Jerusalén ãmicʉriĩmaroi copainʉrejaimad̶a na. Nore eaivʉ, ina Jesúi bueimara mácavʉ once paivʉ baju, aru apevʉ náque cʉrivʉ, cũinároi cójijivʉre earejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Aru ina Jesúi bueimara mácavʉ once paivʉcapũravʉ arejaimad̶a ina pʉcarã copaivʉ bácavʉre yópe: —Jãve bajubu. Maje jabocʉ yaiyʉ́ bácʉ bedióva cojedeca apʉbiya ʉ̃. Simón Pedro ʉ̃́re jã́miya, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Dinʉmʉma ina copaivʉ bácavʉ náre vaiye báque caiyede coyʉrejaimad̶a ina once paivʉre. Ʉ̃i coyʉiye báquede náre mái coyʉrejaimad̶a na. —Pã́ure ʉ̃i cotʉvaiye bajure ʉ̃́re coreóvavʉ ñʉja, arĩ coyʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ne nópe coyʉiyedeca, Jesúvacari cʉetedejamed̶a ne jẽneboi. Aru yópe arĩ, jacoyʉrejamed̶a náre: —¿Ména cʉrãrʉ mʉja? arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ʉbenita na cuecumari jidʉrivʉ, yópe arĩ dápiarejaimad̶a: “¿Põe decocʉ bácʉ bárica?” arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ʉbenita Jesús arejamed̶a náre: —¿Aipe teni jidʉrivʉrʉ̃ mʉja? ¿Aipe teni pʉcaũmea cʉrivʉrʉ̃ mʉja? ¿Aipe teni “¿Ñamema ñai?” aivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Jã́jara ji pʉrʉáre, ji cʉbobare máre. Jãve yʉrecabu. Jẽni jã́jara yʉre. Aru jã́jara yʉre máre. Que baru jiarʉ aru cũad̶o máre cʉvʉ. Põe decocʉ yópe cʉbebi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Que ayʉva, jã́d̶ovarejamed̶a náre ʉ̃i pʉrʉáre aru ʉ̃i cʉbobare máre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ʉbenita jʉ abedejaimad̶a cãreja, ne ʉrarõ torojʉe boje, aru ne pare dápiaiye boje máre. Jesús jẽniari jã́rejamed̶a náre: —¿Ãiyede cʉvabenarʉ mʉja yore? arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jʉ arĩ, jídejaimad̶a ʉ̃́re cũinátʉibʉ moacʉ joaimʉre, aru mumicorore máre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Aru ditʉibʉre ĩni, aru mumicorore máre ĩni, ãrejamed̶a ne jã́inore. ");
INSERT INTO cubNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Dinʉmʉ arejamed̶a náre: —Jave yʉ coyʉcacʉ mʉjare caiye iyede ji cʉede mʉjaque. Coyʉcacʉ mʉjare d̶aiye jaʉvʉ caiye iye Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i toivaicõjeiye báquepe Moisés bácʉre, aru Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivaiye báquepe, aru iye Salmos ãmicʉe toivaiye báquepe máre, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Que ayʉva, Jʉ̃menijicʉi yávaiyede coyʉrĩ majicarejamed̶a náre, ne me majinajiyepe ayʉ iye Jʉ̃menijicʉi yávaiyede. ");
INSERT INTO cubNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aru coyʉrĩ bʉojarĩ, arejamed̶a náre: —Yópe toivainotamu: “Cristore ʉ̃i ʉrarõ ñájiye jaʉvʉ ʉ̃́re. Aru yóbecʉrijãravʉa ʉ̃i yainíburu yóboi nacajacʉyʉme yainore jarʉvarĩ”. ");
INSERT INTO cubNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Aru, “Coyʉiye jaʉvʉ põevare ne ãmeina teiyede chĩori, ne oatʉvarãjiyepe aivʉ, Jʉ̃menijicʉi ãrʉmetequiyepe aivʉ náre ne ãmeina teiyede. Cristoi ãmiái, ʉ̃i parʉéque, coyʉiye jaʉvʉ náre caivʉ ijãravʉcavʉre, mamarʉmʉre Jerusalẽ́cavʉre aru yóboi caivʉ apevʉre máre”, arejamed̶a Jesús, Jʉ̃menijicʉi yávaiyede majicayʉ ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Bedióva cojedeca Jesús coyʉrejamed̶a náre: —Mʉjavacari jã́ivʉ bácavʉbu caiye iyede. Que baru coyʉiye jaʉvʉ mʉjare apevʉre, ne majinajiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yʉ daroquijivʉ mʉjare ñaine, jipacʉi daroquimʉre, Espíritu Santore. Que baru mautejarã mʉja cãreja yui ĩmaroi, pʉ mʉje jacopʉiyeta Jʉ̃menijicʉi parʉéde, cavarõ mearoquede, arĩ d̶aicõjenejamed̶a Jesús ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ʉ̃i que arĩburu yóboi, Jesús jipocatedejamed̶a ʉ̃i bueimarare pʉ Betania ãmicʉriĩmajinoita. Nore ʉ̃i pʉrʉáre jarʉrʉrĩ, “Jʉ̃menijicʉi jã́inoi me tejarã mʉja”, arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nópe ayʉvacari, mʉri nʉrejaquemavʉ náre jocarĩ pʉ cavarõ mearo Jʉ̃menijicʉi cʉrõita. ");
INSERT INTO cubNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","No yóboi, ñʉatutarĩ mearore jídejaimad̶a ʉ̃́re. Aru torojʉrivʉ copainʉrejaimad̶a Jerusalén ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Nore Jʉ̃menijicʉi cʉ̃rami jívʉi mauteni cainʉmʉa, mearore jídejaimad̶a Jʉ̃menijicʉre. Quénoramu.");
INSERT INTO cubNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mamarʉmʉre cãreja jãravʉre cʉed̶aquiye jipocai, cʉrejaquemavʉ majare Jʉ̃menijicʉi dápiainore coyʉcʉedacʉyʉ. Jʉ̃menijicʉque cʉrejaquemavʉ. Aru Jʉ̃menijicʉ baju barejaquémavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Mamarʉmʉmiata jãravʉre cʉed̶aquiye jipocamiata, Cristorecabe cʉcʉ bácʉ Jʉ̃menijicʉque. ");
INSERT INTO cubNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ʉ̃́recabe Jʉ̃menijicʉi caiyede cʉed̶are d̶aimʉ mácʉ. Ʉ̃́re põevare, ãimarare, aru caijĩe coapa cʉed̶are d̶arejaquemavʉ Jʉ̃menijicʉ. Ʉ̃i cʉed̶abedu, ye cʉbejebu. ");
INSERT INTO cubNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ʉ̃́recabe cʉre d̶ayʉ bácʉ põevare apʉrivʉre, ʉ̃i d̶aicõjeimarare. Yópe pẽoiye jã́re d̶aiyepe põevare, nopedeca Cristo põevare coreóvare d̶arejaquemavʉ jãve baju. ");
INSERT INTO cubNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yópe ñami jã́mene d̶aiyepe põevare, nopedeca ijãravʉcavʉ ne ãmeno d̶aiyeque jãvene coreóvabede d̶aimaramu. Ʉbenita Cristo, pẽoinope, darejaquemavʉ ijãravʉi, ñeminitucubʉpe, ãmecʉrijãravʉi, coreóvare d̶acʉyʉ põevare jãve bajure. Aru pẽoiyede cod̶avainope teino coyʉiye jãvene vainí tʉrĩduyama ijãravʉcavʉ ãmeno d̶aivʉ. Ʉbenita ʉ̃i coyʉiye jãvene vainí tʉiye majibenama. ");
INSERT INTO cubNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Põevare Jʉ̃menijicʉi dápiainore coyʉcʉedacʉyʉre Cristore jã́d̶ovaiyʉcʉ, Juan Bautistare coyʉicõjenejamed̶a Jʉ̃menijicʉ. Juan Bautista coyʉcʉdarejaquemavʉ ijãravʉi iye coyʉiyede, Jʉ̃menijicʉi coreóvare d̶aiye báquede ʉ̃́re Cristorã, caivʉ põevare ne jápiarĩ jʉ arãjiyepe ayʉ iye yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ñai Juan Bautista Jʉ̃menijicʉi dápiainore coyʉcʉedacʉyʉ baju, Cristo baju, ãmenejamed̶a ʉ̃. Quéda Cristorã, Jʉ̃menijicʉi dápiainore coyʉcʉedacʉyʉ bajura, coyʉcʉdayʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristorecabe dayʉ bácʉ ijãravʉi coreóvarĩ bʉojare d̶acʉyʉ caivʉ põevare Jʉ̃menijicʉi dápiainore jãve bajure. ");
INSERT INTO cubNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo cʉrĩdurejamed̶a ijãravʉi. Jʉ̃menijicʉi cʉed̶are d̶aimʉ mácʉvacari ijãravʉre, ʉ̃́re coreóvabedejaquemavʉ ijãravʉcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ʉ̃ jino dijãravʉ ʉ̃i cʉed̶aino mácarõi, darĩdurejaquemavʉ ʉ̃. Ʉbenita ʉ̃́re jacopʉbedejaimad̶a obedivʉ ʉ̃ jina mariduivʉvacari. ");
INSERT INTO cubNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ʉbenita apevʉ nácavʉ jãve coreóvarĩ jacopʉrĩ ʉ̃́re jʉ aivʉre Jʉ̃menijicʉi mára teicõjenejaquemavʉ Cristo. ");
INSERT INTO cubNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","“Yʉre jápiarĩ jʉ aivʉ Jʉ̃menijicʉi mára tejarãri na”, ʉ̃i que aino, maja põeva maje jʉed̶ocʉvarõpe ãmevʉ no. Aru maja põeva, “Jʉ̃menijicʉi mára teiyʉrĩ, ʉ̃i mára tenajaramu”, maje aiyepe ãmevʉ no. Aru nomiói márepacʉi jʉed̶ocʉvaiyʉepe máre ãmevʉ no. Quénora “Yʉre jãve baju jápiarĩ jʉ aivʉ Jʉ̃menijicʉi mára tejarãri na. Jʉ̃menijicʉi mára baju tejarãri na”, arejaquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Majare Jʉ̃menijicʉi dápiainore coyʉcʉedacʉyʉ põetedejaquemavʉ dijãravʉi. Majaque cʉrejame ʉ̃, põecʉpe páyʉ. Ʉrarõ baju ʉrĩ majare, d̶acaibi méne. Aru ʉ̃́vacari jã́d̶ovarejame majare aipe ãrojacʉre Jʉ̃menijicʉre jãve matʉiyede. Meacʉ bajube ʉ̃. Jʉ̃menijicʉ ʉ̃i parʉéde jímʉ mácʉi parʉéde jã́rejacarã ñʉja. Cũinácʉbe Jʉ̃menijicʉi mácʉ baju. Cũinácʉrabe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Bautista coyʉrejame ʉ̃i borore ʉ̃́re jã́riburu yóboi. Yópe arĩ, cod̶oboborejame põevare: —Ñaime mʉjare ji coyʉvaimʉ ji ávaiyepe: “Ji yóboi dacʉyʉme ʉ̃. Ʉbenita ji põetequiye jipocamiata cʉrejaquemavʉ ʉ̃, ji mʉjare ji coyʉvaimʉ. Ji jipocacacʉbe ʉ̃. Yʉre vainí tʉibi ʉ̃. Caiyede cʉed̶aquiye jipocai cʉrejaquemavʉ ʉ̃”, acacʉ yʉ mʉjare, arejame Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ʉrarõ ʉ̃i ʉe boje, mearo d̶acaibi caivʉ majare. Obedinʉmʉa ména cʉre d̶aibi majare. Obedinʉmʉa bedióva mearo d̶acavaibi, cad̶atecʉyʉ majare. ");
INSERT INTO cubNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jʉ̃menijicʉi coyʉrĩburu yóboi Moisés bácʉre ʉ̃i d̶aicõjeiyede põevare, ména cʉre d̶aicõjeino majare buenidurejaquemavʉ Moisés bácʉ. Ʉbenita Jesucristo barejáme majare Jʉ̃menijicʉi ʉede jã́d̶ovañʉ. Majare aipe ãrojacʉre Jʉ̃menijicʉre jãve jã́d̶ovarejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jã́imʉ ãmemi Jʉ̃menijicʉ. Ʉbenita Jʉ̃menijicʉi mácʉ cũinácʉra, ʉ̃́vacari Jʉ̃menijicʉ baju, majepacʉque cʉcʉ, majare coreóvare d̶acʉdarejame ʉ̃ Jʉ̃menijicʉre. Edarĩ, jípacʉ jiede coyʉcʉedarejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ina judíova Jerusalén ãmicʉriĩmarocavʉ jẽniari jã́icõjeni jarorejaimad̶a Juan Bautistare. Sacerdotevacavʉ aru Jʉ̃menijicʉi cʉ̃ramine memeipõevacavʉ, levita ãmicʉriyajubocavʉ, jarorejaimad̶a ina jabova, “¿Ñamenʉ mʉ?” ne arĩ jẽniari jã́rajiyepe aivʉ ʉ̃́re. Que arĩ, yécʉ põecʉpe páyʉre majiyʉrejaquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan Bautistacapũravʉ nuriéna coyʉrĩ jebedejame náre. —Cristo ãmevʉ yʉ. Jʉ̃menijicʉi epeimʉ, jabocʉ bacʉyʉ́, ãmevʉ yʉ, arejame náre. ");
INSERT INTO cubNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—¿Dinʉmʉ ñamenʉ mʉ? Cristo ãmevʉ mʉ. ¿Elíarʉ̃ mʉ? arejaima ina sacerdoteva. —Ʉ̃ ãmevʉ yʉ, arejame. —¿Ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bacʉyʉ́, majeñecuva mácavʉ “edacʉyʉ”, ne ávaimʉrʉ mʉ? arejaima ʉ̃́re cojedeca. —Ʉ̃ ãmevʉ yʉ, arejame náre. ");
INSERT INTO cubNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Dinʉmʉ ácʉpe páyʉrʉ̃ mʉ? Ñʉjare cũiná coyʉjacʉ mʉ, ñʉjare jẽniari jã́icõjeivʉre ñʉje coyʉrãjiyepe. ¿Aipe ayʉrʉ̃ mʉ? ¿Yécʉrʉ̃ mʉ? arejaima ʉ̃́re ina sacerdoteva. ");
INSERT INTO cubNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ʉ̃́capũravʉ coyʉrejame náre yópe arĩ, ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ, Isaías ãmicʉcʉ bácʉ ʉ̃i toivaiye báqueque: —Yʉrecabu Isaías bácʉ ʉ̃i toivaimʉ mácʉ: “Jʉ̃menijicʉre coyʉcaipõecʉ cod̶oboboyʉre jápiarãjarama põecʉbenoi: ‘Mead̶ajarã mʉje ũmene, copʉ etaburĩ maje jabocʉre, nopedeca mʉje mead̶aiyepe daimare, ñai ʉ̃mʉ, mʉje pued̶aimʉ, ʉ̃i daquiye jipocai. Que d̶arĩ dajocajarã mʉje ãmeina teiyede, Jʉ̃menijicʉi daroimʉ macʉyʉ́ ʉ̃i daquiye jipocai, Jʉ̃menijicʉ ʉ̃i copʉ etaquiyepe aivʉ mʉjare’ ”, arejame náre Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ina fariseovai jaroimara Juan Bautistare are nʉri jẽniari jã́rejaima: ");
INSERT INTO cubNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Mʉ Cristo ãmevʉ. Elías ãmevʉ mʉ. Aru ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bacʉyʉ́ ãmevʉ mʉ. ¿Dinʉmʉ aipe teni põevare Jʉ̃menijicʉque jã́d̶ovañʉrʉ mʉ ocoque? arejaima ina fariseovai jaroimara. ");
INSERT INTO cubNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan Bautista arejame náre: —Yʉrecabu põevare jã́d̶ovañʉ Jʉ̃menijicʉre ocoque. Ʉbenita cũinácʉ cʉbi mʉje jẽneboi, mʉje coreóvabemʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ji yóboi dacʉyʉme ʉ̃. Ʉbenita ji pʉeno parʉcʉ bacʉyʉ́me. Caivʉ pʉeno meacʉ bajube ʉ̃. Yʉ́capũravʉ pare ʉ̃i cãchinocacʉbu. Que baru ʉ̃́re cad̶ateni bʉojabevʉ yʉ. Pʉ oarĩ bʉojabevʉ yʉ duayʉ ʉ̃i cʉraidoa bʉoimeare, arejame náre. ");
INSERT INTO cubNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Caiye iye vaidéjavʉ̃ Betania ãmicʉrõi, Jordán ãmicʉriya jia aviá daidʉve ẽcarʉi, Juan Bautista ʉ̃i jã́d̶ovare cuiyede põevare Jʉ̃menijicʉque ocoi nore. ");
INSERT INTO cubNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cõmiáijãravʉi yópe barejávʉ̃. Juan Bautista jã́rejame Jesúre dayʉre ʉ̃i yebai. Ʉ̃́re jã́ri, arejame ñʉjare: —Jã́jara mʉja. Ʉ̃́recabe Jʉ̃menijicʉi daroimʉ mácʉ ijãravʉi, jarʉvacʉyʉ põeva ne ãmeina teiyede. Yópe sacerdoteva ne boaiyepe ovejajĩnare, jínajivʉ Jʉ̃menijicʉre ʉ̃i ãrʉmetequiyepe aivʉ põeva ne ãmeina teiyede, nopedeca ñai Jʉ̃menijicʉi daroimʉ mácʉre boarĩ́ jarʉvarãjarama põevare boje, Jʉ̃menijicʉi ãrʉmetequiyepe aivʉ põeva ne ãmeina teiyede. Que baru põeva ne ãmeina teiyede mead̶aipõecʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ñaime mʉjare ji coyʉvaimʉme ji ávaiyepe: “Ʉ̃ ji yóboi dacʉyʉme. Ʉbenita ji põetequiye jipocamiata cʉrejaquemavʉ. Que baru yʉre vainí tʉibi ʉ̃. Caiyede cʉed̶aquiye jipocamiata cʉrejaquemavʉ”, mʉjare acacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mamarʉmʉre yʉ máre coreóvabetecacʉ ʉ̃́re Jʉ̃menijicʉi mácʉre. Ʉbenita põevare Jʉ̃menijicʉque jã́d̶ovacʉdacacʉ yʉ ocoque, Israecavʉ ne coreóvarãjiyepe ayʉ ʉ̃́re, Jʉ̃menijicʉi mácʉre, arejame ñʉjare, ʉ̃́cavʉre, Israecavʉre, Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Yópe arĩ, ʉ̃i majiéde coyʉrejame ʉ̃: —Yʉ máre ʉ̃́re coreóvabecʉ cãreja, “Jʉ̃menijicʉi daroimʉ mácʉ bajʉbí ʉ̃”, abetecacʉ yʉ. Ʉbenita Jʉ̃menijicʉ, yʉre jã́d̶ovaicõjeñʉ mácʉ põeva Jʉ̃menijicʉ jina teiyʉrivʉre ʉ̃́re ocoque, yópe arĩ coyʉáme yʉre: “Jã́cʉyʉmu mʉ ji Espíritu Santo tubacʉẽmeñʉre cũinácʉ ʉ̃mʉra aru cʉcʉre ʉ̃́que. Ñai ʉ̃mʉ, ʉ̃́recabe põeva jina teiyʉrivʉre yʉre jã́d̶ovacʉyʉ Espíritu Santoque”, áme yʉre Jʉ̃menijicʉ. Quédeca ʉ̃i aiye báquepe, Jesúrã ñai Espíritu Santo tubacʉẽmeñʉre jurecope cavarõ mearo Jʉ̃menijicʉi cʉrõre jocarĩ jã́cacʉ yʉ. Aru ñai Espíritu Santo cʉ́teame ʉ̃́que. ");
INSERT INTO cubNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yʉ́capũravʉ majivʉ, ji jã́iye báque boje. Que baru coyʉyʉbu mʉjare. Ñai ʉ̃mʉ, mʉjare ji coyʉvacamʉ, Jʉ̃menijicʉi mácʉbe ʉ̃, arejame Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cõmiáijãravʉi Juan Bautista cʉrejame nore cojedeca ñʉja pʉcarã ʉ̃i bueimaraque. ");
INSERT INTO cubNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Que teni Jesús noi vaiyʉ́re jã́ri, arejame ñʉjare: —Ʉ̃́re jã́jara mʉja. Ʉ̃́recabe Jʉ̃menijicʉi daroimʉ mácʉ. Yópe sacerdoteva ne boaiyepe ovejajĩnare, jínajivʉ Jʉ̃menijicʉre, nopedeca ñai Jʉ̃menijicʉi daroimʉ mácʉre boarĩ́ jarʉvarãjarama põevare boje, arejame ñʉjare Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ʉ̃i que aiyede jápiaivʉ, Jesúque nʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús núcʉnʉri, copedini, ñʉjare jẽniari jã́rejame: —¿Aru mʉja yéde voivʉrʉ̃? arejame Jesús. —Mʉ, bueipõecʉ, ¿ã́ri cʉcʉrʉ̃ mʉ? arejacarã ñʉja Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Yʉ́que jã́radajarã mʉja, arejame ñʉjare Jesús. Ñʉje nʉiyede ʉ̃́que, yóvaicʉvaiora nainú marejávʉ̃. Ʉ̃́que nʉri, ʉ̃i cʉrõi jã́ri, cʉrejacarã ʉ̃́que dijãravʉ joarõ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Cũinácʉ ñʉja pʉcarã Juan Bautistare jápiaivʉ bácavʉcacʉ aru Jesúque nʉivʉ bácavʉcacʉ Andrés ãmicʉcʉ barejáme, Simón Pedroi yócʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Cũiná, Andrés vocʉnʉrejame ʉ̃i mamicʉ Simóre. Eayʉ bácʉ, arejamed̶a ʉ̃́re: —Mesíare, Jʉ̃menijicʉi epeimʉre, põevare mead̶aipõecʉre, eavʉ ñʉja, arejamed̶a Andrés. Mesías aino, Cristo aiyʉrõtamu. ");
INSERT INTO cubNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","No yóboi Andrés jíbʉcʉre nʉvarejamed̶a Jesús yebai. Jesús, Simóre jã́ri, yópe arĩ coyʉrejame: —Simómu mʉ. Mipacʉ ãmicʉbi Juan. Ʉbenita Cefas ãmidoimʉ macʉyʉ́mu mʉ, arejame Jesús. Cefas aino, Pedro ainotamu. Aru nóvacari cʉ̃rabo aiyʉrõtamu. ");
INSERT INTO cubNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cõmiáijãravʉi Galilea ãmicʉrijoborõi nʉcʉyʉ barejáme Jesús. Nʉñʉ, Felipede copʉrejame ʉ̃: —Yʉ́que dajacʉ mʉ, arejame Felipede Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Betsaida ãmicʉriĩmarocacʉ barejáme Felipe. Andrés aru Pedro ne ĩmarocacʉ barejáme. ");
INSERT INTO cubNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Dinʉmʉre Natanaene vocʉnʉrejamed̶a Felipe. Ʉ̃́re eayʉ, coyʉrejamed̶a: —Ñaine, Moisés bácʉ aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ ne toivarĩ coyʉvaimʉre eavʉ ñʉja. Moisés bácʉ ʉ̃i toivaiye báquede Jʉ̃menijicʉi d̶aicõjeiyede toivarejaquemavʉ ʉ̃́ra. Ʉ̃́tame Jesús Nazarecacʉ, Joséi mácʉ, arejamed̶a Natanaene Felipe. ");
INSERT INTO cubNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaecapũravʉ arejamed̶a: —No ĩmaro Nazarede põeva meara, apevʉre cad̶ateivʉ, cʉbema na, arejamed̶a Natanael. —Dinʉmʉ jã́cʉdajacʉ mʉ mi baju, arejamed̶a ʉ̃́re Felipe. Jã́radarejaima ina pʉcarã. ");
INSERT INTO cubNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Náre edaivʉre jã́ri Jesús, yópe arejame Natanaena: —Majecʉ, israevacacʉ baju, edaibi ʉ̃. Borocʉbecʉ bajube ʉ̃, arejame Jesús, Natanaene jã́ñʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Aipe teni yʉre majitecʉrʉ̃ mʉ? arejame Jesúre Natanael. —Mʉre Felipe ʉ̃i cutubede cãreja jã́vʉ yʉ. Higueracʉ cãchinoi dobatevʉ mʉ, arejame Natanaene Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Mʉ, bueipõecʉ, Jʉ̃menijicʉi mácʉbu mʉ. Ñʉja Israecavʉ ñʉje jabocʉbu mʉ, arejame Jesúre Natanael. ");
INSERT INTO cubNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Quénora Jesúcapũravʉ arejame ʉ̃́re: —¿“Jocʉcʉ cãchinoi mʉre jã́vʉ” ji aiyede, “Jʉ̃menijicʉi mácʉbu mʉ”, ayʉrʉ̃ yʉre? Pʉeno ji apejĩe parʉé ji d̶aquiyede jã́cʉyʉmu mʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jãve coyʉyʉbu mʉjare: Cavarõ mearo Jʉ̃menijicʉi cʉrõ vorĩ nʉinore jã́rajaramu mʉja. Nore Jʉ̃menijicʉi ángeleva, jõd̶aivʉre aru mʉivʉre jã́rajaramu mʉja. Aru ne coricai cʉcʉyʉmu yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pʉcajãravʉa yóboi, Galilea ãmicʉrõi, Caná ãmicʉriĩmaroi, pʉrʉbʉoivʉ ne torojʉve teino marejávʉ̃. Aru Jesúi paco cʉrejaco noi. ");
INSERT INTO cubNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús aru ñʉja ʉ̃i bueimara ina pʉrʉbʉoivʉ ne cutuimaracavʉ barejacárã. ");
INSERT INTO cubNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ñʉje ãiye bajure ũcuiye cũinéjavʉ̃ya. Jesúre coyʉcodarejaco jípaco: —Bʉcʉrʉ, javeta ũcuiye, vino ʉ́yaicoro, cũivʉ́ die, arejaco Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Báco, ¿aipe teni yʉre que ad̶orʉ̃? Ji memeinʉmʉ eabevʉ cãreja, arejame jípacore Jesús. Ãniñami cʉ̃ramicavʉ ne yebacavʉ yebai nʉri, yópe arejacod̶a õ: ");
INSERT INTO cubNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","—Jímacʉi cõjeiyepe d̶ajarã mʉja, arejacod̶a Jesúi paco. ");
INSERT INTO cubNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nore cʉrejavʉ̃ seis paibʉa jorobʉa, cʉ̃rajorobʉa. Ʉrabʉa jorobʉa baju, cũinábʉ cincuenta o setenta pailitros baju eaibʉ barejávʉ̃. Dibʉá ocoque buiváibʉare cʉvarejacarã ñʉja judíova, ñʉje cojarãjiyepe aivʉ, ñʉje nópe teni cõmajinope Jʉ̃menijicʉi me jã́quiyepe aivʉ ñʉjare. Que teni iñamicavʉ máre cʉvarejaima dibʉáre. ");
INSERT INTO cubNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","—Ocore ĩni, davarĩ, dibʉáre buivájarã mʉja, arejame nócacʉi yebacavʉre Jesús. Na jʉ arĩ, dibʉáre yuyeni, buivárejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—Que d̶arĩ quĩ́jinora doarĩ, torojʉve teino upacʉre nʉvajara mʉja. Ʉ̃i ũcuri dápiaquiyepe arĩ, jínanʉjara, arejame ina yebacavʉre. Jʉ arĩ, ñai torojʉve teino upacʉre diede nʉvari, jídejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Die oco báquede Jesús oatʉvarĩ, vino ʉ́yaicoro tede d̶arejame. Ñai torojʉve teino upacʉ die ũcuiyede ũcuri jã́rejame. Ʉ̃́capũravʉ majibedejame ã́roi ne ĩ́ye báquede diede. Ʉbenita ina yebacavʉcapũravʉ, ina ocoque dibʉáre yuyeivʉ bácavʉ, me majidejaima. Ũcuri jã́ri, pʉrʉbʉoyʉre cuturejame ñai torojʉve teino upacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Dayʉ bácʉre yópe arejame ñai torojʉve teino upacʉ: —Mamarʉmʉre ũcuiye me bajure jíyavʉ̃ maja maje cutuimarare. Aru yóbota, na ũcuri vainí tʉivʉre jã́ri, majiéda meacorore náre jíyavʉ̃ maja. Que d̶abetevʉra mʉ. Mamarʉmʉre meacorore yavedebu mʉ. Aru yóbota, méne ũcuiyede jívʉ mʉ, arejame pʉrʉbʉoyʉre ñai torojʉve teino upacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Que teni põeva ne d̶arĩ majibenore d̶arejame Jesús, jã́d̶ovacʉyʉ ʉ̃i majiéde. Galilea ãmicʉrõi, Caná ãmicʉriĩmaroi, ʉ̃i ocore oatʉvainoque, Jesús bʉ́rejame põeva ne d̶arĩ majibede ʉ̃i d̶aiyede. “Jʉ̃menijicʉi epeimʉme ʉ̃”, põevare are d̶ayʉ, nópe náre jã́d̶ovarejame Jesús. Aru “Cristo bajube ʉ̃” arĩ, me jʉ arejacarã ñʉja ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","No yóboi Capernaum ãmicʉriĩmaroi nʉrejame Jesús. Ʉ̃́re yóvarãnʉrejacarã jípaco, ʉ̃i yóva, aru ñʉja ʉ̃i bueimara. Nore obebejãravʉa cʉrejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua ãmicʉrijãravʉ torojʉve teijãravʉ baquinó eare nʉino marejávʉ̃. Ñʉja judíova ñʉje torojʉve teinʉmʉ marejávʉ̃ no, Jʉ̃menijicʉi etavaiye báque boje ñʉjeñecuva mácavʉre Egipto ãmicʉrijoborõre jocarĩ. Dinʉmʉre Jerusalén ãmicʉriĩmaroi nʉrejaima obedivʉ judíova. Que baru Jesús máre mʉri nʉrejame. ");
INSERT INTO cubNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mʉri nʉri, earĩ, Jʉ̃menijicʉi cʉ̃ramine jã́cʉnʉrejame Jesús. Diñami tãibʉrã earĩ, ecorĩ oteivecʉva, ovejava, aru jurevare bojed̶aivʉre jã́rejame. Nácapũravʉ põevare ʉrarõ ne tãutʉrare ĩnejaima. Apenoa joborõacavʉ ne tãutʉrare oatʉvaipõeva dobarivʉre máre jã́rejame nore. ");
INSERT INTO cubNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Que baru cainimea ĩni, ʉ̃i jara boaquímene cãriárejame. Cãriári bʉojarĩ, dimeque jara popeni, diñami cʉrivʉre jaetovarejame Jesús ina tãibʉi cʉrĩ bojed̶aivʉre ne ãimaraque. Tãutʉrare oatʉvaivʉre máre jararĩ, ne jã́d̶ovaivare japʉporĩ, moari najuárejame, jarʉvacʉyʉ ne tãutʉratʉravare joborõi. ");
INSERT INTO cubNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jurevare bojed̶aivʉre yópe arejame: —Nʉjara mʉja, mʉje bojed̶ajʉromarare ĩni. Jipacʉre mearore jíñamimu yo. Bojed̶aiñami d̶abejarã jipacʉi cʉ̃ramine, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesús ʉ̃i que aiyede, Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquede ãrʉrejacarã ñʉja, ʉ̃i bueimara. “Mʉ, Jʉ̃menijicʉ, apevʉ ãmeina d̶arãjivʉbu yʉre. Que baru mi cʉ̃ramine jecʉrĩ vaivʉ yʉ”, apecʉ bácʉ ʉ̃i aiye báquede toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ina judíova ñʉje jabova yávarãdarejaima Jesúre: —Jʉ̃menijicʉi mʉre que d̶aicõjenu, ñʉjare jã́d̶ovajacʉ põeva ne d̶arĩ majibede mi d̶ainore, arejaima ina jabova. ");
INSERT INTO cubNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús arejame náre: —Iñamine bíjarorĩ jarʉvajarã mʉja. Iñamine mʉje jarʉvarĩburu yóbecʉrijãravʉa yóboi, mʉje jarʉvaiñami mácarõre mead̶acʉyʉmu yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ina judíova arejaima ʉ̃́re: —Cuarenta y seis paiʉjʉa baju diñamine núvari ñájiquemavʉ memeipõeva. ¿Aru mʉ yóbecʉrijãravʉa memeni, diñamine mead̶ayʉ bʉojaje bárica mʉ? arejaima ñʉje jabova Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ʉbenita diñami bajure ayʉ ãmenejame Jesús. Ʉ̃i bajure cʉ̃ramipe ayʉ barejáme ʉ̃. Ʉbenita majibedejaquemavʉ na, jabovacapũravʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Majibenidurejacarã ñʉja máre, Jesús ʉ̃i que aiyede. Ʉbenita ʉ̃i nacajariburu yóboi yainore jarʉvarĩ, ʉ̃i que aiye báquede dápiarĩ, ãrʉrejacarã ñʉja, ʉ̃i bueimara. Ãrʉrivʉ ʉ̃i coyʉiye báquede aru Jʉ̃menijicʉi yávaiye báquede máre jʉ arejacarã ñʉja ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua torojʉve teinʉmʉ, Jesús ʉ̃i cʉedeca Jerusalén ãmicʉriĩmaroi, ʉ̃́re jʉ arĩdurejaima põeva obedivʉ. Ne jã́iye boje ʉ̃i jã́d̶ovaiyede põeva ne d̶arĩ majibede, “Jʉ̃menijicʉi epeimʉ Cristobe ʉ̃”, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ʉbenita Jesúcapũravʉ náre coreóvarĩ, “Jãve abema na”, arĩ dápiarejamed̶a. Me baju põevare coreóvarejaquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ʉ̃́re jaʉbevʉ apecʉ ʉ̃i coyʉiye aipe ãrojaene põevare. Me majidejaquemavʉ põeva ne dápiaiyede. Quénora ʉ̃i baju coreóvarejaquemavʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Cũinácʉ ʉ̃mʉ Nicodemo ãmicʉcʉ barejáme, ñʉja judíova ñʉje jabovacacʉ. Fariseo ãmicʉriyajubocacʉ barejáme Nicodemo. ");
INSERT INTO cubNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cũináñami Jesúre borotecʉearejamed̶a. —Mʉ, bueipõecʉ, coreóvaivʉbu ñʉja mʉre Jʉ̃menijicʉi daroimʉ mácʉre, buecʉyʉre ʉ̃ jiede. Que baru ácʉ põecʉ Jʉ̃menijicʉi parʉéde cʉvabecʉ baru, d̶aiye majibebi yópe põeva ne d̶arĩ majibede mi d̶aiyepe. Que baru mʉ́que cʉbi Jʉ̃menijicʉ, arejamed̶a Nicodemo Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Jãve coyʉyʉbu mʉre: Ácʉ põecʉ bedióva cojedeca ʉ̃i põetebedu mamaũmeque, ʉ̃́re jabotebecʉyʉme Jʉ̃menijicʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Aipe teni? ¿Bedióva cojedeca jʉed̶ocʉpe põeteiye majidi bʉcʉcʉ? Jãve bʉcʉcʉ jípacoi yapibʉrã ĩmari, põeteyʉ bʉojabebi, arejamed̶a Nicodemo. ");
INSERT INTO cubNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ʉ̃́re arejamed̶a Jesús: —Jãve coyʉyʉbu mʉre: Ácʉ põecʉ ʉ̃i põetebedu ocoque aru Espíritu Santoque máre, ʉ̃́re jabotebecʉyʉme Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Põevai mára põevatamu. Ʉbenita ñai Espíritu Santoi põed̶aimara mamaũmeque epeimaratamu na. Que baru Jʉ̃menijicʉi máramu. ");
INSERT INTO cubNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Ácʉ põecʉ bedióva cojedeca ʉ̃i põetebedu mamaũmeque, ʉ̃́re jabotebecʉyʉme Jʉ̃menijicʉ”, ji aiyede mʉre ʉrarõ baju dápiabejacʉ mʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ũmebo darĩ japuinopebu no. Ã́ri japurĩ nʉiyʉrõ nʉquiyebu. Ũmebo japuinore maja quéda jápiad̶avʉ̃. Jã́ino ãmevʉ no. Quédecabu Espíritu Santoi põed̶aimara mamaũmeque. Jã́ri majino ãmevʉ no, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Aipe aiyʉrõ márica no, mi que aino? arejamed̶a Jesúre Nicodemo. ");
INSERT INTO cubNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ʉ̃́re arejamed̶a Jesús: —Mʉrecabu judíova ne bueipõeva me majidivʉcacʉ. ¿Jápiarĩ eabecʉrʉ̃ mʉ iye ji mʉre coyʉiyede? ");
INSERT INTO cubNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jãve coyʉyʉbu mʉre: Ñʉje majiéde mʉjare coyʉrĩduyavʉ̃ ñʉja. Ñʉje jã́iye bajure coyʉrĩduyavʉ̃. Ʉbenita jʉ abevʉ mʉja ñʉje coyʉrĩduiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ijãravʉquede coyʉrĩduvʉ yʉ. Ʉbenita ji coyʉiyede jʉ abevʉ mʉja. Ijãravʉquede coyʉiyede jʉ abevʉ baru, cavarõ mearo Jʉ̃menijicʉi cʉrõquede ji coyʉquiyede jʉ abenajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Cavarõ mearo Jʉ̃menijicʉi cʉrõi mʉri nʉri, cojedeca ijãravʉi ẽmeni dayʉ bácʉ cʉbebi. Que baru ácʉ ijãravʉcacʉ cavarõ mearoquede coyʉiyede coyʉbebi. Yʉrecabu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe. Cavarõ mearo Jʉ̃menijicʉi cʉrõi cʉcʉ bácʉ ijãravʉi darejacacʉ yʉ. Que baru cavarõ mearo Jʉ̃menijicʉi cʉrõquede coyʉiyede coyʉiye majivʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Yópe Moisés bácʉi d̶aiye báquepe, ʉ̃i cʉede cãreja põecʉbenoi, ãd̶ape paino bronce ãmicʉrõ tãuque d̶aino mácarõque, nopedeca vaiquíyebu yʉre. Ʉ̃i d̶aimʉ mácʉre jocʉyo ʉ̃mʉjʉriyorã jẽori, jãmʉórejaquemavʉ Moisés bácʉ. Nopedeca yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, jocʉcʉrã jẽori, jãmʉórajarama põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yʉre yópe d̶aivʉre jã́ri, caivʉ põeva yʉre jʉ aivʉ baru, cʉvarãjarama jãravʉ cũiméjãravʉ baquinóre cavarõ mearoi, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Coyʉre nʉrejamed̶a Jesús: —Quécʉra, cũinácʉrabu yʉ Jʉ̃menijicʉi mácʉ. Pare baju ijãravʉcavʉre ʉcʉ, yʉre darorejame Jʉ̃menijicʉ yore. Jaʉrabeda toabo cũiméboi ne nʉmenajiyepe ayʉ, yʉre jʉ aivʉre jãravʉ cũiméjãravʉ baquinóre cʉre d̶aibi Jʉ̃menijicʉ cavarõ mearoi. ");
INSERT INTO cubNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jʉ̃menijicʉ darobedejame yʉre, ji ñájine d̶aquiyepe ayʉ ijãravʉcavʉre ne ãmeina teiye boje. Quénora darorejame yʉre, ji mead̶aquiyepe ayʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yʉre jʉ aivʉ bácavʉre ñájine d̶abecʉyʉme Jʉ̃menijicʉ. Ʉbenita yʉre jʉ abevʉre ñájine d̶acʉyʉme Jʉ̃menijicʉ, ne jʉ abe boje yʉre, Jʉ̃menijicʉi mácʉ cũinácʉra. ");
INSERT INTO cubNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yópe d̶arĩ Jʉ̃menijicʉ apevʉre “Boropatebevʉ mʉja ji jã́inoi”, aru apevʉre “Boropateivʉbu mʉja ji jã́inoi”, coyʉyʉbe. Ji daiye boje ijãravʉi, põevare majide d̶aivʉ Jʉ̃menijicʉi yávaiyede jãvene, yópe pẽoino jã́re d̶aiyepe náre. Aru ijãravʉcavʉ ne ãmeina teiye ñeminopebu. Põeva yʉre ʉbema. Quénora ne ãmeina teiyede ʉma na. Nárecabu Jʉ̃menijicʉ “Ñájinajaramu mʉja”, ʉ̃i arĩ coyʉimara, ne ʉbe boje yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Caivʉ ina ãmeina teivʉ yʉre jã́d̶ovaicõjeiyʉbema ne ãmeina teiyede. Que baru yʉre pẽoñʉpe, ne ãmeina teiyede jã́d̶ovañʉre, jã́iyʉbema. ");
INSERT INTO cubNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ʉbenita caivʉ ina jʉ aivʉ Jʉ̃menijicʉre, ñai ayʉre jãvene, yaveiyʉbema ne d̶aiyede. Quénora jã́d̶ovad̶ama ne d̶aiye caiyede yópe Jʉ̃menijicʉi ʉrõpe. Que baru yʉre pẽoñʉre vod̶ama, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","No yóboi Judea ãmicʉrijoborõi nʉrejame Jesús, ñʉja ʉ̃i bueimaraque. Nore cʉrejacarã ñʉja obedijãravʉa. Nócavʉre Jʉ̃menijicʉque jã́d̶ovaivʉ barejacárã ocoque. ");
INSERT INTO cubNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aru Enón ãmicʉriĩmaro baji, Salim ãmicʉrõ joabejĩno, cʉrejamed̶a Juan Bautista máre. Põeva ʉ̃́re eaivʉre Jʉ̃menijicʉque jã́d̶ovañʉ marejámed̶a, oco ʉrarõ cʉe boje nore. ");
INSERT INTO cubNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Dinʉmʉre cãreja Juan Bautistare jẽni, nʉvari, bʉobedejaimad̶a ñʉje jabova. ");
INSERT INTO cubNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Juan Bautista ʉ̃i bueimaracavʉ copʉ yávarĩ bʉ́rejaimad̶a cũinácʉ judíoque, ñʉje d̶arĩ cõmajiyede Jʉ̃menijicʉi me jã́quiyepe aivʉ ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Que teni yávarĩ bʉojarĩ, Juan Bautistare coyʉrãearejaimad̶a ina ʉ̃i bueimaracavʉ: —Mʉ, bueipõecʉ, ñai mʉ́que cʉ́vacacʉ Jordã́d̶a ãnidʉvei, mi coyʉvacamʉ Jʉ̃menijicʉi majiéque, ʉ̃́vacari põevare Jʉ̃menijicʉque jã́d̶ovaimi ocoque. Obedivʉ nʉñama ʉ̃́que caride, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yópe arĩ, náre coyʉrejamed̶a Juan Bautista: —Põecʉ cʉbebi ʉ̃i d̶aiyepe d̶arĩ bʉojayʉ, Jʉ̃menijicʉi ʉ̃́re parʉre d̶abedu. ");
INSERT INTO cubNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mʉjavacari jápiad̶avʉ̃ ji coyʉrĩduiye báquede. “Cristo ãmevʉ yʉ”, acacʉ yʉ mʉjare. Quéda ʉ̃́re coyʉrĩ jipocateicõjeimʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yópebu yʉ Cristoque. Pʉrʉbʉocʉyʉ nomicʉcʉyʉme. Aru ʉ̃i yóvaimʉ, ñai mead̶ayʉ bácʉ ne pʉrʉbʉoiyede, torojʉbi ʉ̃i jápiaiyede ñai pʉrʉbʉocʉyʉ ʉ̃i yávainore. Ñai yóvaimʉ ʉ̃i teinope teyʉbu yʉ. Que baru põeva Jesúque nʉivʉre jã́ñʉ, ʉrarõ torojʉvʉ yʉ ji ũmei. ");
INSERT INTO cubNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Pʉeno parʉcʉ nʉcʉyʉme Jesús. Ʉbenita parʉbecʉ nʉcʉyʉmu yʉ. Põeva ne pued̶aimʉ macʉyʉ́me ʉ̃. Ʉbenita pued̶abejarãri yʉre, arejamed̶a Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Coyʉre nʉrejamed̶a Juan Bautista: —Cavarõ mearo Jʉ̃menijicʉi cʉrõi cʉcʉ bácʉ, ijãravʉi ẽmeni darĩ, caivʉ ijãravʉcavʉ maje pʉeno majibi. Ijãravʉcacʉ yócacʉbe. Que baru majibi yóque majiéde. Ʉbenita cavarõ mearore ẽmeni dayʉ bácʉ yócavʉ maje pʉeno majibi. ");
INSERT INTO cubNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ñai cavarõ mearo Jʉ̃menijicʉi cʉrõi cʉcʉ bácʉ ʉ̃i jã́iye báquede coyʉrĩduibi. Ʉbenita ʉ̃i coyʉiyede jʉ abema obedivʉ yócavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Que baru ácʉ põecʉ jʉ ayʉ baru ʉ̃i coyʉiyede, Jʉ̃menijicʉi jãve aiyede, “Jãvemu”, ayʉtame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jecʉbecʉva Jʉ̃menijicʉ ʉ̃i Espíritu Santore cʉre d̶aibi Cristoque. Que baru Cristo, Jʉ̃menijicʉi daroimʉ mácʉ ijãravʉi, Jʉ̃menijicʉ jiede coyʉibi. ");
INSERT INTO cubNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamacʉre pare ʉbi majepacʉ Jʉ̃menijicʉ. Caiyede aru caivʉre pʉrʉcʉvaicõjeimi ʉ̃ mamacʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Caivʉ jʉ aivʉ mamacʉre, Cristore, jãravʉ cũiméjãravʉ baquinóre cavarõ mearoi cʉvama na. Ʉbenita caivʉ jápiabevʉ ʉ̃́re, Cristore, jãravʉ cũiméjãravʉ baquinóre cavarõ mearoi cʉvabema na. Quénora ne jápiaiyʉbe báque boje, náre ʉrarõ ñájine d̶acʉyʉme Jʉ̃menijicʉ, arejamed̶a Juan Bautista. ");
INSERT INTO cubNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Obedivʉ ʉ̃i bueimara cʉvarejamed̶a Juan Bautista. Ʉbenita pʉeno obedivʉ ʉ̃i bueimara cʉvarejame Jesús. Aru Jesúi Jʉ̃menijicʉre jã́d̶ovaimara mácavʉ ocoque obedivʉ barejáima Juan Bautista ʉ̃i Jʉ̃menijicʉre ocoque jã́d̶ovaimara mácavʉ pʉeno. Ʉbenita Jesúcapũravʉ põevare Jʉ̃menijicʉre jã́d̶ovamenejame ocoque. Quénora ñʉja, ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare jã́d̶ovaicõjenejame náre ocoque. Ina fariseo ãmicʉriyajubocavʉ, põeva “Jesús obedivʉ ʉ̃i bueimara cʉvabi Juan Bautista pʉeno”, ne arĩ boroteiyede jápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús jápiayʉ bácʉ ina fariseova ne coreóvaiyede iye borore ʉ̃́ra, Judea ãmicʉrõre dajocarĩ nʉri, Galilea ãmicʉrijoborõi nʉrejame. Aru ʉ̃́que nʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ñʉje nʉiyede Galileai, Samaria ãmicʉrijoborõi vaiye jaʉrejavʉ̃ ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Vaidé nʉri, Samariacarõ ĩmaro, Sicar ãmicʉriĩmaroi ẽmenejacarã ñʉja. Sicar bajita cʉrejaquemavʉ no joborõ, ñʉjeñecu mácʉ Jacob bácʉ ʉ̃i jíno mácarõ ʉ̃i mácʉ, José bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nore cʉvʉ ne oco doaicobe, Jacob bácʉi oco doaicobe. Jãravʉ corica baji barejávʉ̃. Joa baju mari, darĩ, ʉetʉrejame Jesús. Que baru no oco doaicobe ẽcarʉi dobarejame, jabʉóvacʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ʉ̃i jabʉóvaiyede, ĩmaroi ẽmeni nʉrejacarã ñʉja, ñʉje ãrajiyede bojed̶arãnʉivʉ. Ñʉje nʉriburu yóboi, oco doainore ẽmeni earejacod̶a cũináco Samariacaco. Oco doacodad̶o barejácod̶a. —Oco, ji ũcuquiye jíjaco yʉre, arejamed̶a oco doacodad̶ore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ʉbenita Samariacavʉre judíova ne pʉque ʉbe boje, cuecumari dápiarĩ yópe arejacod̶a Jesúre: —Judíobu mʉ. Aru yʉ Samariacacobu. ¿Aipe teni yʉre ũcuiye jẽniañʉrʉ mʉ? arejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ṍre arejamed̶a Jesús: —Jʉ̃menijicʉ mʉre jíjʉroede majibevʉ mʉ. Yʉ mʉre ocore jẽniañʉre, majibevʉ mʉ. Yʉre majico baru, “Ocore jíjacʉ”, yʉre ajebu mʉ. Aru nópe jẽniad̶ore apʉre d̶aiocore mʉre jíjebu yʉ, arejamed̶a ṍre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jesúre arejacod̶a: —¿Aipe ayʉrʉ̃ mʉ yʉre? Ʉ̃mʉjʉricobebu yo. Aru mi oco doaquino cʉvabevʉ mʉ. ¿Ã́ri apʉre d̶aicorore, mi ocore, ĩcʉyʉrʉ̃ mʉ? ");
INSERT INTO cubNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dicobede jídejaquemavʉ majeñecu mácʉ, Jacob bácʉ. Javede ʉ̃ mácʉ aru ʉ̃i mára mácavʉ yore ocore ĩni ũcurejaquemavʉ. Aru jídejaquemavʉ ne oteiãimara mácavʉre. ¿Jacob bácʉ pʉeno parʉcʉrʉ̃ mʉ? arejacod̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ṍre arejamed̶a Jesús: —Ácʉ põecʉ ũcuñʉre oco dicobequede, bedióva cojedeca cũiñóquiyebu ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ʉbenita ácʉ põecʉ iye ocore, ji jíquicorore, ũcuñʉ mácʉre cũinára, ye cũiñómequiyebu ʉ̃́re cojedeca. Ji jíquicoro oco pĩapóinope teni, jãravʉ cũiméjãravʉ baquinóre cʉvacʉyʉme ji jíquicorore ũcuñʉ mácʉ, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ico nomió arejacod̶a: —Jede, mi aicorore, iye ocore, jíjacʉ yʉre caride. Ji ũcucojiye jíjacʉ yʉre, bedióva cojedeca cũiñómequiyepe ayʉ yʉre aru ji oco doacodabecojiyepe ayʉ yore jãravʉa coapa, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Õi que arĩburuta, ṍre yávarejamed̶a Jesús: —Mimarepacʉre cutuconʉjaco mʉ. Ʉ̃́re davajaco yʉre, arejamed̶a ṍre. ");
INSERT INTO cubNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Jimarepacʉ cʉbebi, arejacod̶a õ. —Jãve ad̶obu mʉ. Mimarepacʉ baju cʉbebi. ");
INSERT INTO cubNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cũinápʉrʉpe paivʉ ʉ̃mʉva cʉrĩduavʉ̃ mʉ. Aru caricacʉ mi yóvaimʉ, mimarepacʉ baju ãmemi ʉ̃. Jãve baju ad̶obu mʉ, arejamed̶a ṍre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Yʉre Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ batedébu mʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yore, yócacũ cʉ̃racũre Jʉ̃menijicʉre mearore jídejaquemavʉ ñʉjeñecuva mácavʉ. Ʉbenita “Jerusalẽ́vacari Jʉ̃menijicʉre mearore jíye jaʉvʉ”, ad̶avʉ̃ mʉja judíova, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús arejamed̶a: —Ji coyʉiyede me jápiajaco. Jãvetamu ji coyʉiye. Apejãravʉa daquijãravʉa baquiyé põeva Jʉ̃menijicʉre mearore jínanʉmenajarama Jerusalẽ́i aru dicũ cʉ̃racũi máre. ");
INSERT INTO cubNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉja Samariacavʉ mʉje mearore jímʉre majibevʉ mʉja. Ʉbenita ñʉja judíova majivʉ. Jʉ̃menijicʉ ʉ̃i daroimʉ mácʉ põevare mead̶aipõecʉ ñʉjecʉbe. Que baru majinineca Jʉ̃menijicʉre mearore jívʉbu ñʉja judíova. ");
INSERT INTO cubNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ji aijãravʉa daquijãravʉa baquiyé jave eare nʉivʉ. Dinʉmʉ maquinóre põevare mearore jíde d̶acʉyʉme ñai Espíritu Santo Jʉ̃menijicʉre yópe jãve coyʉiyepe. Põeva nápe paivʉ quévʉra ʉ̃́re mearore jíyʉrivʉre ʉbi Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Jʉ̃menijicʉrecabe cʉre d̶ayʉ caivʉre. Põeva mearore jíni majidivʉbu ʉ̃́re, yópe jãve coyʉiyepe ñai Espíritu Santo ʉ̃i nópe majide d̶aiyede, ʉ̃i náre cʉre d̶aiyeque mamaũmeque, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ʉ̃́re arejacod̶a: —Majivʉ yʉ Mesíare, Jʉ̃menijicʉi epeimʉre, põeva ne aimʉre Cristo, dacʉyʉre. Aru ʉ̃i daquiyede, caiyede majare coyʉrĩ jebecʉyʉme, arejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Yʉ́bu Cristo, mʉre boroteyʉ, arejamed̶a ṍre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ico nomióre ʉ̃i que coyʉiye bajure copaidarejacarã ñʉja, ĩmaroi cuivʉ bácavʉ. Pare dápiaivʉ ñʉje jã́iye boje ʉ̃́re boroteyʉre nomióque, “¿Aipe teni ṍque boroteyʉrʉ̃ mʉ?” ájʉrorivʉ barejacárã ñʉja. Ʉbenita ʉ̃́re jẽniari jã́menejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ṍcapũravʉ õi oco doaibʉre noi ñóri, copainʉrejacod̶a õi cʉriĩmaroi. Noi nʉri, earĩ, nócavʉre coyʉrejacod̶a: ");
INSERT INTO cubNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Jã́radajarã mʉja. ¿Yʉre ji teiye báque caiyede coyʉyʉ, Cristo bárica ʉ̃? arejacod̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Õi que arĩburu yóboi, ṍque jã́radarejaquemavʉ diĩmarocavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ĩmarocavʉ ne edabede cãreja, ñʉje bojed̶aiye báque ãiyede Jesúre ãicõjenidurejacarã ñʉja. —Mʉ, bueipõecʉ, ãiyede ãjacʉ mʉ, arĩdurejacarã Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Mʉje majibede ãiye cʉvavʉ yʉ, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Aru ñʉje bajumica boroteivʉ, jẽniari jã́rejacarã: —¿Ʉ̃́re ãiye davarãma apevʉ? arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aru Jesús arejamed̶a: —Maja ãiyede ãri bʉojarĩburu ũmedaivʉ maja. Quédeca yʉ d̶ayʉ yópe yʉre daroyʉ bácʉ ʉ̃i ʉrõpe aru bʉojayʉ iye d̶aiyede ʉ̃i d̶aicõjeiye báquede yʉre, ũmedaivʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Yóvaicʉvaivʉ aviáva bʉcʉquiyebu maje ãiye”, majidivʉ ne coyʉino mácarõpe aiyavʉ̃ mʉja. Ʉbenita yʉ coyʉyʉbu mʉjare. Ãiye jẽinʉmʉ jave eaivʉ. Ãnina majare edaivʉre jã́jara mʉja. Ãiyede jẽiyepebu na. Vea coboiyede jã́ri, ĩ́ye jaʉvʉ no. Quédecabu ãnina, majare edaivʉ. Vea coboiyepedeca javeta yʉre jʉ aivʉ barãjárama na. ");
INSERT INTO cubNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Põevare yʉre jʉ are d̶ayʉ bácʉ ãiyede jẽñʉ mácʉpedeca torojʉbi. Ʉ̃i memeiye boje, yʉre ʉ̃i jʉ are d̶aimarare torojʉbi. Põevare jãravʉ cũiméjãravʉ baquinóre cʉvare d̶aibi. Que baru torojʉbi ʉ̃. Jʉ̃menijicʉi yávaiyede coyʉrĩ bʉ́yʉ bácʉre, oteipõecʉpe páyʉ, cad̶ateibi põevare yʉre jʉ are d̶aipõecʉ. Aru põeva ne jʉ aiyede torojʉma ina pʉcarã. ");
INSERT INTO cubNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Majidivʉ ne coyʉino mácarõpe, “Cũinácʉ oteibi aru apecʉta ãiyede ĩ́mi”, jãvetamu no caride. ");
INSERT INTO cubNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ãiyede jẽivʉpe paivʉre mʉjare jaroyʉtamu yʉ, põeva yʉre ne jʉ arãjiyepe ayʉ. Ʉbenita mʉja ãmeteavʉ̃ mamarʉmʉ Jʉ̃menijicʉi yávaiyede coyʉrĩ bʉivʉ náre. Mʉje jipocai Jʉ̃menijicʉi yávaiyede coyʉrĩ bʉ́quemavʉ apevʉ. Apevʉ ne coyʉimara mácavʉre yʉre jʉ are d̶ajarã mʉja caride. Jʉ̃menijicʉi yávaiyede jápiarĩduivʉ bácavʉ yʉre jʉ ajarãri na, arejame Jesús ñʉjare majicayʉ. Ʉ̃i que aiyedata edarejaima ĩmarocavʉ, Jesúque boroted̶o bácoi cutuimara mácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Õi aiye boje Jesúrã, “Ji teiye báque caiyede coyʉibi”, obedivʉ Samariacavʉ jʉ arejaquemavʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Que baru ne edaiyede ʉ̃i yebai, “Ñʉjaque cʉjacʉ cãreja”, arejaima Jesúre ina Samariacavʉ. Dinʉmʉ pʉcajãravʉa náque cʉrejame Jesús, náre bueyʉ ne ĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesúque boroted̶o báco õi coyʉiye boje náre, ʉ̃́re jʉ arejaquemavʉ apevʉ. Ʉbenita ʉ̃́que boroteivʉ obedivʉ baju barejáima ʉ̃́re jʉ aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Que baru Jesúque boroted̶o bácore õi cuturĩ davaimara mácavʉ arejaima: —Caride ʉ̃́re jʉ aivʉ ãmevʉ ñʉja mi coyʉiye báque boje. Quénora ʉ̃́re jʉ aivʉbu ñʉje baju jápiaiye báque boje ʉ̃i coyʉiyede. Me majivʉ ñʉja Jesúre caivʉ põevare mead̶aipõecʉre, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pʉcajãravʉa náque cʉrĩburu yóboi, Galilea ãmicʉrõi nʉrejacarã ñʉja cojedeca, Jesúque nʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Javede ʉ̃́vacari arejame ñʉjare: “Cʉbebi Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ ʉ̃i joborõcavʉ ne pued̶aimʉ”, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jipocamia, Pascua torojʉve teinʉmʉre, apevʉ Galileacavʉ nʉrejaquemavʉ Jerusalén ãmicʉriĩmaroi. Nore Jesúre põeva ne d̶arĩ majibede d̶ayʉre jã́ivʉ bácavʉ barejáima. Que baru Jesús ʉ̃i eaiyede ne joborõi cojedeca, ʉ̃́re torojʉrivʉ copʉ etarejaima nócavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Oco báquede Jesús ʉ̃i ũcuiye d̶aino mácarõi Caná ãmicʉriĩmaro, Galileacarõi, copainʉrejacarã ñʉja Jesújã cojedeca. Nore, Canái, cʉrejame cũinácʉ jabovacacʉ. Aru Capernaum ãmicʉriĩmaroi cʉrejamed̶a ʉ̃i mácʉ, pare ijeteyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Que baru ñai jabocʉ jápiayʉ bácʉ Jesúi copaiyede Galileaita, Judeare jocarĩ, jã́cʉdarejame ʉ̃i yebai. Jesús yebai edarĩ, yópe arĩ jẽniarejame Jesúre: —Jímacʉ pare baju ijeteyʉbe ʉ̃. Maumejieneca yaiquíjibi. Ʉ̃́re jã́cʉnʉri, ʉ̃́re mead̶acajacʉ yʉre, arejame Jesúre ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—Yʉre põeva ne d̶arĩ majibede d̶ayʉre jã́mevʉ baru, yʉre ye jʉ abenajaramu mʉja, arejame ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ʉbenita Jesúre nʉicõjenidurejame ñai jabocʉ. —Maumena dajacʉ. Yʉ́que jã́cʉdajacʉ mʉ, jímacʉi yaiquíye jipocai. Yaibécʉbe cãreja jímacʉ, arĩdurejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Aru Jesús arejame ʉ̃́re: —Meaquiyebu. Mi cʉrõi copainʉjacʉ mʉ caride. Mímacʉ yaibécʉbe, arejame. Jesús ʉ̃i coyʉiyede jʉ arĩ, cũiná copainʉrejamed̶a ñai jabocʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ʉ̃i cʉrõi eare nʉñʉre copʉrejaimad̶a ʉ̃́re memecaivʉ. —Mímacʉ ũmedabi ʉ̃, arejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—¿Aipiye bajure ũmedari ʉ̃? jẽniari jã́rejamed̶a ʉ̃́re memecaivʉre. —Ẽnoa marede, jãravʉ corica yójĩboi moino buruvʉ ʉ̃́re, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ne que aiyede, ñai jabocʉ coreóvarejamed̶a. Jesús “Mímacʉ meacʉbe caride”, ʉ̃i aiora bácarõre ñai jabocʉi mácʉ ũmedarejamed̶a. Dinʉmʉre ñai jabocʉ aru caivʉ ʉ̃i cʉ̃ramicavʉ máre Jesúre jʉ arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea ãmicʉrõi cʉcʉ bácʉ, Galilea ãmicʉrõi edarĩ, cʉcʉ, põeva ne d̶arĩ majibenore d̶arejame Jesús. Jabocʉi mácʉre ũmedavainoque, pʉque põeva ne d̶arĩ majibe bajure d̶arĩ jã́d̶ovarejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","No yóboi Jerusalén ãmicʉriĩmaroi ñʉja judíova ñʉje torojʉve teino cũináro cʉrejavʉ̃ cojedeca. Que baru ñʉja Jesújã máre no ĩmaroi jã́cʉnʉrejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Diĩmaro biaido jedevacobe bajita, ovejava ne ecoicobe jedevacobena cʉrejavʉ̃ cũinábʉ cuyaibʉ. Judíova ñʉje yávaiyeque dibʉ ãmicʉrejavʉ̃ Betesda. Dibʉ ẽcarʉi põeva ne earĩ cʉrãjinore cũinápʉrʉpe painoa jabʉóvainoa cʉrejavʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Die jabʉóvaiyena obedivʉ ijimara paraivʉ barejáima. Jã́ri eabevʉ, cuiye majibevʉ, nacajaiye majibevʉ máre, ijimara coapa noi cʉrejaima. Apenʉmʉa pãcarejavʉ̃ dibʉ. Dibʉ oco pãcaiyede coredejaima ina ijimara. Apenʉmʉa nore cũinácʉ ángele cavarõ mearo Jʉ̃menijicʉi cʉrõre jocarĩ ẽmeni darĩ, dibʉ ocore pãcovarejaquemavʉ. Ʉ̃i ocore pãcovaiye bajure dibʉre cuyarãemejʉrorivʉ barejáima ina ijimara. Mamarʉmʉcacʉ pãcovaiye bajure dibʉre cuyacʉẽmeñʉ, cũiná ũmedarejame, ád̶e ijiéde cʉvacʉ bácʉvacari. ");
INSERT INTO cubNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ijimaracacʉ cũinácʉ treinta y ocho paiʉjʉa baju corenidurejamed̶a, nore parayʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nomicata Jesús earĩ, ñai parayʉre jã́ri, coreóvarejamed̶a joe baju nore cʉcʉre. Que baru ʉ̃́re borotecʉnʉrejame. —¿Ũmedaiyʉcʉrʉ̃ mʉ? arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ñai ijimʉ arejame Jesúre: —Jápiajacʉ. Cainʉmʉa pãcovaiyede, ji cuyacʉẽmejʉroede, ji jipocai apecʉcapũravʉ nore ẽmeni, tʉrĩ cóvaibi. Yʉre ocore ẽmevacayʉ cʉbebi, arejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Nacajajacʉ mʉ, aru mi parainore cututurĩ, ĩni, vaivárĩ nʉjacʉ mʉ, arejame ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Quénora cũiná ũmedarejame ñai ijimʉ mácʉ. Ʉ̃i parainore cututurĩ, ĩni, vaivárĩ nʉrejame ʉ̃. Jesús ʉ̃i nópe d̶aijãravʉ ñʉja judíova ñʉje jabʉóvaijãravʉ barejávʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Que baru ʉ̃́re, ijimʉ mácʉre, coyʉrãearejaimad̶a judíovai jabovacavʉ: —¿Aipe d̶ayʉrʉ̃ mʉ, mi parainore nópe nʉvañʉ? Cari jãravʉ maje jabʉóvaijãravʉbu. Parainore nʉvaicõjemenotamu, arejaimad̶a ʉ̃́re ina jabova. ");
INSERT INTO cubNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—Ʉbenita yʉre mead̶aipõecʉ yópe abi: “Mi parainore cututurĩ, ĩni, vaivárĩ nʉjacʉ mʉ”, abi yʉre. Que barureca yʉ nʉvañʉmu, arejamed̶a ñai ijimʉ mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Ñame matedí mʉre que ayʉ? arĩ jẽniari jã́rejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ʉbenita coyʉiye majibedejamed̶a náre. Ʉ̃́re mead̶arĩ bʉojarĩnata, põeva ne jẽneboi bíjacʉnʉrejamed̶a Jesús, obedivʉ põeva ne cʉe boje nore. Que baru Jesúre coreóvabedejamed̶a ñai ijimʉ mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","No yóboi, Jʉ̃menijicʉi cʉ̃ramita ijimʉ mácʉre copʉrĩ, yópe arĩ, coyʉrejame Jesús: —Meabaju cʉcʉtamu mʉ. Caride mi ãmeina teiye báquede dajocajacʉ. Cojedeca mʉ ãmeina d̶ayʉ baru, pʉeno ãmeno ñájicʉyʉmu mʉ, arejame ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesús ʉ̃i que arĩburu yóboi, ʉ̃́re coreóvarejamed̶a ñai ijimʉ mácʉ. Cũiná, jabovare coyʉcʉnʉrejamed̶a: —Yʉre mead̶ayʉ bácʉ Jesúbe, arĩ coyʉrejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Que teni Jesúre pare cãrijovari bʉ́rejaima ñʉje jabova, ʉ̃́re ñájine d̶ájʉrorivʉ ʉ̃i mead̶aiye báque boje ijimʉ mácʉre ñʉje jabʉóvaijãravʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ne ñájine d̶ájʉroede ʉ̃́re, Jesús náre yópe arĩ, coyʉrejame: —Jipacʉ jabʉóvabebi. Quénora cainʉmʉa cad̶atevaibi põevare. Que baru yʉ máre cad̶ateyʉbu náre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jesús ʉ̃i que aiye boje, pʉeno ʉ̃́re boarĩ́ jarʉvaiyʉrejaima ñʉja judíova ñʉje jabova. Ʉ̃i d̶abe boje ne d̶aicõjeiyepe jabʉóvaijãravʉre, ʉ̃́re boarĩ́ jarʉvaiyʉrejaima. Ʉbenita pare boarĩ́ jarʉvaiyʉrejaima ʉ̃́re, “Jipacʉbe Jʉ̃menijicʉ”, ʉ̃i aiye boje. Ne dápiaru, ʉ̃i que aino, “Jʉ̃menijicʉpe majicʉbu yʉ”, ayʉ barejáme Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús, yópe arĩ, coyʉrejame náre: —Jãve coyʉyʉbu mʉjare: Yʉ, Jʉ̃menijicʉi mácʉ, ji baju jipacʉi coyʉbenore jaʉrabeda d̶ayʉ bʉojabevʉ. Quénora jipacʉ Jʉ̃menijicʉre jã́ñʉ, ʉ̃i d̶aiyepedeca d̶ayʉbu yʉ. Caiye iye jipacʉi d̶aiyede yʉ, mamacʉ, máre d̶aivʉ diede. ");
INSERT INTO cubNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pare ʉbi yʉre jipacʉ. Ʉ̃i d̶aiye caiyede majicaibi yʉre. Pʉeno parʉéde ji d̶aquiyede jã́d̶ovacʉyʉme yʉre jipacʉ. Mʉjavacari ʉrarõ cuecumarajaramu yʉre, jã́d̶ovaicõjecʉyʉre jipacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Yópe yaivʉ bácavʉre jipacʉi nacovaiyepe yainore jarʉvarĩ, nopedeca yʉ, mamacʉ, cʉre d̶ayʉbu ina ji ʉmarare. ");
INSERT INTO cubNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jipacʉ ãmemi coyʉcʉyʉ põevare ád̶e ne bojede ne d̶aiye boje ijãravʉi. Quénora yʉre, mamacʉre, coyʉicõjeimi diede náre. ");
INSERT INTO cubNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ʉ̃ que cõjeimi, caivʉ põeva ne pued̶arãjiyepe ayʉ yʉre ne pued̶aiyepedeca jipacʉre. Ácʉ põecʉ pued̶abecʉ yʉre, mamacʉre, pued̶abebi jipacʉre máre, yʉre daroyʉ bácʉre ijãravʉi, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Náre coyʉre nʉrejame Jesús: —Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ ji coyʉiyede jápiayʉ baru aru yʉre daroyʉ bácʉre jʉ ayʉ baru, jãravʉ cũiméjãravʉ baquinóre cʉvabi ʉ̃. Coatejʉrocʉ bácʉvacari Jʉ̃menijicʉre jarʉvarĩ, ñájiñʉ macʉyʉ́ ãmemi. Javeta jãravʉ cũiméjãravʉ baquinóre cʉvabi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jãve coyʉyʉbu mʉjare: Cũinájãravʉ daquijãravʉ baquinó jave eare nʉinotamu ina coateivʉ Jʉ̃menijicʉre jarʉvarĩ ne jápiarãjiyede ji coyʉiyede. Ina coateivʉ Jʉ̃menijicʉre jarʉvarĩ yaivʉ bácavʉpe paivʉtamu ne ũmei. Ʉbenita ne jápiaiyede yʉre, Jʉ̃menijicʉi mácʉre, jʉ aivʉ baru ji coyʉiyede, cʉrãjarama na. ");
INSERT INTO cubNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yópe jipacʉi apʉre d̶aiyepe põevare, nopedeca yʉre, mamacʉre, apʉre d̶aicõjeimi põevare. ");
INSERT INTO cubNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yʉrecabu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe. Que baru Jʉ̃menijicʉ pʉrʉcʉvaicõjeimi yʉre, ji coyʉquiyepe ayʉ caivʉ põevare ád̶e ne bojede ne d̶aiye boje ijãravʉi. ");
INSERT INTO cubNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Cuecumamejara mʉja. Apejãravʉ baquinó eare nʉinoi, caivʉ ina yaivʉ bácavʉ jápiarãjarama ji coyʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aru nacajarajarama yainore jarʉvarĩ. Ina meara mácavʉ nacajari, jãravʉ cũiméjãravʉ baquinóre cʉvarãjarama na cavarõ mearo Jʉ̃menijicʉi cʉrõi. Ʉbenita ina ãmeina teivʉ bácavʉ nacajari, ñájinajarama cainʉmʉa toabo cũiméboi, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Náre coyʉre nʉrejame Jesús: —Ji baju jipacʉi coyʉbenore jaʉrabeda d̶ayʉ bʉojabevʉ. Quénora jipacʉ Jʉ̃menijicʉre jápiayʉ, ʉ̃i coyʉiyepeda coyʉyʉbu yʉ põevare ád̶e ne bojede ne d̶aiye boje ijãravʉi. Que baru ji coyʉiyede nurié coyʉyʉbu yʉ. Ji nópe coyʉiye nuriétamu, ji d̶aiyʉbe boje yópe ji baju ʉrõpe. Quénora jipacʉ, ñai daroyʉ bácʉ yʉre ijãravʉi, ʉ̃i ʉrõpe d̶ayʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ji baju “Meacʉbu yʉ”, abevʉ. Ji que aru, “Ʉbeni que ayʉbe ʉ̃”, ajebu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ʉbenita yʉre apecʉcapũravʉ “Meacʉ bajutame Jesús”, aibi. Jãvetamu ʉ̃i que aino. ");
INSERT INTO cubNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","’Mʉjavacari mʉje daroimaraque jẽniari jã́icõjeniduquemavʉ Juan Bautista yebai, yʉre majiyʉrĩduivʉ. Aru Juan Bautista náre jãve coyʉquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Meavʉ no ʉ̃i coyʉino. Ʉbenita yʉre coyʉcaipõecʉ jaʉbevʉ, ji jã́d̶ovaquiyepe ayʉ ñamene yʉre. Juan Bautista ʉ̃i coyʉino mácarõre coyʉyʉ batevʉ́ yʉ, mʉje majinajiyepe ayʉ ñamene yʉre, ji mead̶aquiyepe ayʉ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yópe pẽoibʉ jã́re d̶aiyepe põevare, nopedeca yávaiyede jãvene majide d̶áme Juan Bautista. Nurinimare pẽoibʉ pẽoinope jã́d̶ovariduame. Ʉ̃i que teiyede torojʉteavʉ̃ mʉja mamarʉmʉre cãreja. ");
INSERT INTO cubNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ʉbenita ji baju d̶aiyeque jã́d̶ovaivʉ ñamene yʉre. Yʉ́tamu jã́d̶ovañʉ Juan Bautista ʉ̃i jã́d̶ovaino mácarõ pʉeno. ’Jipacʉi d̶aicõjeiyepeda yʉre, diedecabu ji d̶aiye. Iye d̶aiye jã́d̶ovaiyetamu yʉre jãve jipacʉi daroimʉ mácʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aru jipacʉvacari, ñai daroyʉ bácʉ yʉre, coyʉibi ji borore jãve. Ʉbenita jipacʉre jã́mevʉ mʉja. Aru jápiabevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yʉre, Jʉ̃menijicʉi daroimʉ mácʉre, jʉ abevʉ mʉja. “Jʉ̃menijicʉre coyʉcaipõecʉbu mʉ”, yʉre aiyʉbevʉ mʉja. Que baru ʉ̃i yávaiyede cʉvabevʉ mʉja mʉje ũmei. ");
INSERT INTO cubNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquede pare bueniduyavʉ̃ mʉja. “¿Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquede bueivʉ, aipe d̶arĩ jãravʉ cũiméjãravʉ baquinóre earãjidi maja?” arĩduyavʉ̃ mʉja. Aru diemiareca mʉje bueiyeque ji borore jãve toivaiyebu. ");
INSERT INTO cubNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ʉbenita yʉre jẽniaiyʉbevʉ ji cʉvare d̶aquiyepe aivʉ mʉjare jãravʉ cũiméjãravʉ baquinóre, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Náre coyʉre nʉrejame Jesús: —Põeva ne mearore jíyede yʉre vobevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mʉjare me majivʉ yʉ. Coreóvaivʉ mʉjare Jʉ̃menijicʉre ʉbevʉre mʉje ũmei. ");
INSERT INTO cubNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yore coyʉicõjeni darorejame yʉre jipacʉ. Ʉbenita yʉre ʉbeni, copʉ etabevʉ mʉja. Ʉbenita apecʉ ʉ̃i coyʉcʉdaru ʉ̃i baju, jaʉrabeda ʉ̃́re copʉ etad̶arãmu mʉja. Ʉ̃́re jápiad̶arãmu. Ʉbenita yʉre ye jápiaiyʉbevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Mʉje baju copʉ mearore jíyʉrivʉbu mʉja. Mʉje bajumia mearore jíyede vore cuivʉbu mʉja. Ʉbenita ye vobevʉ mʉja ñai Jʉ̃menijicʉ cũinácʉra ʉ̃i jíquiyepe aivʉ mearore mʉjare. Mʉje nópe d̶aiye boje, ji coyʉiyede jãve jʉ arĩ bʉojabevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ʉbenita dápiabejarã mʉja ʉbenina. Yʉ́vacari ãmevʉ boro coyʉrĩ ad̶acʉyʉ mʉjare jipacʉi jã́inore. Moisés bácʉ, ñai mʉje coreimʉ cad̶atecʉyʉre, ʉ̃́recabe boro coyʉrĩ ad̶ayʉ mʉjare, mʉje jápiabeni jʉ abe boje iye borore, ʉ̃i toivaino mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés bácʉ ji borore toivarejaquemavʉ. Que baru mʉja jãve jʉ aivʉ baru ʉ̃ mácʉre, yʉre máre jʉ ajebu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ʉbenita mʉje jʉ abe boje ʉ̃i toivarĩ coyʉiye báquede, ji coyʉiyede máre jʉ abevʉ mʉja, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","No yóboi jiad̶ocũi jaturĩ, macajitabʉ ʉrabʉ Galilea ãmicʉrijitabʉre jatarĩ nʉrejacarã ñʉja Jesújã pʉ apedʉveita. Dibʉvacari Tiberias máre ãmicʉvʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ñʉja jataivʉque darejaima põeva obedivʉ. Ne ijimarare mead̶ayʉre jã́iye báque boje, põeva ne d̶arĩ majibede jã́d̶ovaiyede jã́ivʉ bácavʉ Jesúque darejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Macajitabʉ ʉrabʉre jataivʉ bácavʉ, cʉ̃racũ pʉenoi mʉri dobacʉnʉrejame Jesús, ñʉja ʉ̃i bueimaraque. ");
INSERT INTO cubNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pascua ãmicʉrijãravʉ baquinó, ñʉja judíova ñʉje torojʉve teinʉmʉ maquinó eare nʉino marejávʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Dicũ pʉenoi dobacʉ, põeva obedivʉre ʉ̃́ra mʉre daivʉre jã́rejame Jesús. —Que põeva obedivʉ dare daivʉ jároma. ¿Ne ãrajiyede ã́ri bojed̶arãjidica maja? jẽniari jã́rejame Felipede Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Que arejame Felipede. Aipe ãrojae ʉ̃i jʉ ainore jápiaiyʉcʉ barejáme, ʉ̃́re que ayʉ. Felipede ʉ̃i jẽniari jã́quiye jipocamiata, jãve majidejaquemavʉ Jesús aipe ʉ̃i d̶aquiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe arejame: —Tãutʉraque doscientos paijãravʉa memeiye báque bojeque ne ãrajiye quĩ́jie baju pã́ure bojed̶arĩ bʉojabevʉ maja, arejame Felipe Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Apecʉ ñʉjacacʉ, Jesúi bueimaracacʉ, Simón Pedroi yócʉ Andrés, arejame Jesúre: ");
INSERT INTO cubNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Põevaque dayʉ bácʉ jʉed̶ocʉ pã́uboa cũinápʉrʉpe paiboa cebada ãmicʉe oteiyeque ne d̶aiboa báquede aru moajina pʉcajĩna ne joaimara mácavʉre cʉvabi ʉ̃. Ʉbenita põeva obedivʉre eabequiyebu ãru, arejame Jesúre Andrés. ");
INSERT INTO cubNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Põevare dobaicõjejara mʉja, arejame Jesús ñʉja ʉ̃i bueimarare. Cõriá meacõria cʉrejavʉ̃ nore. Que baru cõriá pʉenora dobarejaima na. Nácavʉ ʉ̃mʉvacari cũinápʉrʉpe paimil baju barejáima. Aru nomiva, jʉed̶ova máre, obedivʉ cʉrejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Põeva ne dobarĩburu yóboi, Jesús pã́uboare jẽni, torojʉede jídejame Jʉ̃menijicʉre. Torojʉede jíni bʉojarĩ, pã́uboare cotʉvarĩ jebeni, ina dobarivʉre jícõjenejame Jesús ñʉjare, ʉ̃i bueimarare. Aru moajinare máre quédeca d̶arejacarã ñʉja. Ne ʉrõpe ãrejaima ina põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ne ãriburu yóboi, Jesús arejame ñʉjare, ʉ̃i bueimarare: —Põeva ne ãri oabede ĩjara mʉja, maje bíjare d̶abenajiyepe aivʉ ãiyede, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Que baru ĩni, mead̶arĩ iye cebadaque ne d̶aiboa báque pã́uboajeveare põeva ne ãri oabe báquede pʉebʉa doce paibʉare buivárejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ina põeva jã́ivʉ bácavʉ no põeva ne d̶arĩ majibenore, Jesús ʉ̃i d̶aiyede, yópe arĩ bʉ́rejaima ne bajumia: —Jãve ñaime Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bacʉyʉ́, edacʉyʉ me ijãravʉre ne ávaimʉ, aivʉ barejáima na. ");
INSERT INTO cubNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ʉ̃́re que aivʉre majidejaquemavʉ Jesús. Aru ne jẽni jabojacoiyede máre majidejaquemavʉ ʉ̃. Que baru náre jocarĩ cũinácʉva mʉri nʉrejamed̶a cʉ̃racũ pʉenoi, dupiyʉ náre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ñemié tʉiyede macajitabʉ ʉrabʉi ẽmenejacarã ñʉja, Jesúi bueimara. ");
INSERT INTO cubNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nore jiad̶ocũi jaturĩ nʉri, macajitabʉre jatarĩdurejacarã, Capernaum ãmicʉriĩmaroi nʉ́jʉrorivʉ. Que teicavʉre nainéjavʉ̃. Aru Jesús dabedejame cãreja ñʉje yebai. ");
INSERT INTO cubNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ũmevʉ ñʉjare edarĩ, japurejavʉ̃. Pare pãcarejavʉ̃ macajitabʉ ʉrabʉ ñʉjare, jatajʉrorivʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ñʉja pare doarĩ, ñájini, cũinápʉrʉpe paikilometros baju nʉri, macajitabʉ ʉrabʉ pʉenora vaivárĩ darejame Jesús, ñʉje yebai dayʉ. Ʉ̃́re jã́ri, ʉrarõ jidʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Que teivʉre jã́ri, ñʉjare yávarejame Jesús: —Yʉ Jesútamu. Jidʉbejarã mʉja, arejame ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ʉ̃i que arĩburu, torojʉrĩ “Jatujacʉ”, arejacarã. Ʉ̃i jatuiyedata ẽcarʉi ñʉje earãjinore cũiná datʉórãearejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Cõmiáijãravʉ Jesúre vorĩdurejaimad̶a na macajitabʉ ʉrabʉ ẽcarʉi mauteivʉ bácavʉ, ʉ̃i ãoimara mácavʉ. Majidejaimad̶a jiad̶ocũ cũinácũva nore cʉricũ mácarõre no jipocacajãravʉre. Aru majidejaimad̶a ñʉja ʉ̃i bueimaraque nʉmecʉ bácʉre máre. Que baru apecũ ʉ̃i jatajʉroricũ cʉbedejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ne voiyede apevʉ jataivʉ bácavʉ Tiberias ãmicʉriĩmarocavʉ parãnʉrejaimad̶a. Jesús Jʉ̃menijicʉre torojʉede jíniburu yóboi põevare pã́uboa ne ãrajiboa jíno mácarõ joabejĩnoi tuijarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jesúre aru ñʉjare ʉ̃i bueimarare máre eabeni, edaicũa máquede jaturejaimad̶a ina ẽcaboi cʉrivʉ bácavʉ. Macajitabʉ ʉrabʉre jatarĩ nʉri, Capernaum ãmicʉriĩmaroi earejaima na, Jesúre voivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Dibʉre jataivʉ bácavʉ Jesúre earĩ, jẽniari jã́rejaima ʉ̃́re: —Mʉ, bueipõecʉ, ¿aipiye bajure idʉvei jatacʉrʉ̃ mʉ? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesúcapũravʉ, yópe arĩ, coyʉrejame náre: —Jãve coyʉyʉbu mʉjare: Yʉre vorãdabevʉ mʉja, mʉje jápiarĩ eaiye boje ji jã́d̶ovaiyede põeva ne d̶arĩ majibede ji d̶aiyeque. Quénora yʉre vorãdad̶avʉ̃ mʉja, mʉje ãri yapiye báque boje. ");
INSERT INTO cubNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Yóque ãiye pojeiyebu. Die matʉiyeda memeni vobejarã mʉja. Quénora iye ãiye cʉre d̶aiyede jãravʉ cũiméjãravʉ baquinóre pare vojarã mʉja. Diedecabu yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, ji jíquiye mʉjare, jipacʉ Jʉ̃menijicʉ ʉ̃i jã́d̶ovaiye boje ʉ̃i mearo jã́iyede yʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ʉ̃́re jẽniari jã́rejaima: —¿Aipe d̶aiye jaʉri ñʉjare, ñʉje d̶arãjiyepe aivʉ yópe Jʉ̃menijicʉi ʉrõpe? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús arejame: —Yo cũináro d̶aiye jaʉvʉ mʉjare, d̶arãjivʉ yópe Jʉ̃menijicʉi ʉrõpe. Jʉ ajarã yʉre, ʉ̃i daroimʉ mácʉre, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ʉ̃́re arejaima: —¿Yéde põeva ne d̶arĩ majibede d̶acʉyʉrʉ̃ mʉ, ñʉje jã́riburu yóboi ñʉje majinajiyepe ayʉ jãvene mi coyʉiyede? ¿Ád̶epe paiyeba mi d̶aiye? ");
INSERT INTO cubNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Majeñecuva mácavʉ ne cʉede põecʉbenoi maná ãmicʉe ãiyede ãrejaquemavʉ na mácavʉ. Que d̶arejaquemavʉ yópe Jʉ̃menijicʉi toivaicõjeiye báquepe ʉ̃i yávaiyede: “Cavarõ mearo Jʉ̃menijicʉi cʉrõre jocarĩ ãiyede jõd̶avari darorĩ jídejaquemavʉ náre”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ, arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aru Jesús jʉ ayʉ arejame náre: —Jãve coyʉyʉbu mʉjare: Moisés bácʉ ãmenejaquemavʉ ñai jõd̶avari daroyʉ bácʉ ãiyede cavarõ mearo Jʉ̃menijicʉi cʉrõquede. Quénora jipacʉrecabe ñai jõd̶avari daroyʉ bácʉ ãiye bajure cavarõ mearoquede. ");
INSERT INTO cubNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Cavarõ mearoque ãiye Jʉ̃menijicʉ ʉ̃i daroiye me bajutamu. Iyetamu põevare cʉre d̶aiye jãravʉ cũiméjãravʉ baquinóre, arĩ coyʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Ñʉje jabocʉ, iye ãiyede jíjacʉ ñʉjare cainʉmʉa, arejaima ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús arejame náre: —Yʉrecabu iye ãiye. Ãiyepe põevare jãve cʉre d̶ayʉbu yʉ jãravʉ cũiméjãravʉ baquinóre. Yópe põecʉi ãri bʉojarĩ, ʉ̃́re ãvʉé ijibepe, nopedeca ácʉ põecʉ yʉre yóvacʉdayʉ baru, ʉ̃́re ye jaʉbequiyebu cainʉmʉa ʉ̃i ũmei. Aru yópe põecʉi ũcuri bʉojarĩ, ʉ̃́re cũiñómepe, nopedeca ácʉ põecʉ yʉre jʉ ayʉ baru, ʉ̃́re jaʉbequiyebu cainʉmʉa ʉ̃i ũmei. ");
INSERT INTO cubNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ʉbenita yópe ji mʉjare ávarepe, yʉre jã́ivʉvacari jʉ abevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","’Yʉre jipacʉ ʉ̃i jʉ are d̶aimara coapa yʉre yóvarĩ cʉrãjarama. Aru jãve náre coapa jʉ arĩ jacopʉcʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Cavarõ mearo Jʉ̃menijicʉi cʉrõi cʉcʉ bácʉ yore ẽmecʉdarejacacʉ yʉ, d̶acʉyʉ jipacʉ, yʉre daroyʉ bácʉ, ʉ̃i ʉrõpe. Ji ʉrõpeda d̶acʉyʉ ãmenejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yópe ʉbi ñai yʉre daroyʉ bácʉ: Caivʉ ina yʉre ʉ̃i jʉ are d̶aimarare coreiye jaʉvʉ yʉre, ne bíjabenajiyepe ayʉ, aru ji nacovaquiyepe ayʉ náre coapa yainore jarʉvarĩ ãnijãravʉ bʉojaquijãravʉ baquinóre. Que d̶ainore ʉbi ñai daroyʉ bácʉ yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jipacʉ ʉbi caivʉ põeva yʉre jã́ri, coreóvarĩ, jʉ aivʉre ne cʉvarãjiyepe ayʉ jãravʉ cũiméjãravʉ baquinóre. Aru yʉ́vacari náre nacovacʉyʉmu yainore jarʉvarĩ ãnijãravʉ bʉojaquijãravʉ baquinó, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Cavarõ mearoque ãiye bajutamu yʉ”, ʉ̃i aiyede jápiarĩ, Jesúre jorojĩnejaimad̶a nócavʉ judíova, ne bajumia jũjuvaivʉre ṹra. ");
INSERT INTO cubNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—Ñai Jesús José bácʉi mácʉtame. Aru jípacore máre coreóvad̶avʉ̃ maja. ¿Aipe teni, “Cavarõ mearo Jʉ̃menijicʉi cʉrõre jocarĩ ẽmeni darejacacʉ yʉ”, arĩ bʉojaidi ʉ̃? arejaimad̶a na, ne bajumia boroteivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Quénomia Jesús arejame náre: —Mʉje bajumia jorojĩni ãmeina yávabejarã yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ñame dabenama ne baju yʉre yóvarãdaivʉ jipacʉ, yʉre daroyʉ bácʉi náre daicõjemenu. Jipacʉrecabe yʉre darocaipõecʉ, ji nacovaquiyepe ayʉ ina põevare yainore jarʉvarĩ bʉojaquijãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Javede Jʉ̃menijicʉ toivaicõjenejaquemavʉ ina ʉ̃i yávaiyede coyʉcaipõeva mácavʉre yópe arĩ: “Põeva caivʉre buecʉyʉme Jʉ̃menijicʉ”, arĩ toivaicõjenejaquemavʉ. Que baru caivʉ ina jipacʉi bueiyede jápiarĩ ad̶arĩ, jʉ aivʉ, yʉre yóvarãdaivʉbu na, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Náre coyʉre nʉrejame ʉ̃: —Ji nópe aiyeque, “Jʉ̃menijicʉre jã́d̶aima põeva”, aiyʉcʉ ãmevʉ yʉ. Yʉrecabu Jʉ̃menijicʉ yebai cʉcʉ bácʉ, ʉ̃i daroimʉ mácʉ, cũinácʉra ʉ̃́re jã́ñʉ mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jãve coyʉyʉbu mʉjare: Caivʉ põeva jʉ aivʉ yʉre jãravʉ cũiméjãravʉ baquinóre cʉvarãjarama. ");
INSERT INTO cubNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉ́tamu ãiyepe páyʉ. Jãve põevare cʉre d̶ayʉbu yʉ jãravʉ cũiméjãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉjeñecuva mácavʉ ne cʉede põecʉbenoi ã́varejaquemavʉ manáre. Aru diede ãivʉ bácavʉvacari bʉcʉteni yaidéjaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ʉbenita ji coyʉvare ãiyebu, cavarõ mearo Jʉ̃menijicʉi cʉrõi ẽmeni daiye ãiye. Ácʉ põecʉ ji coyʉvare ãiyede ãru, ʉ̃i ũme yaibéquiyebu. Coatebecʉyʉme Jʉ̃menijicʉre jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉ́tamu iye cavarõ mearore ẽmeni daiye báque ãiye. Ácʉ põecʉ iye ãiyede ãñʉ maru, cʉcʉyʉme cainʉmʉa. Iye ãiye ji jíquiye ji bajubu. Ji bajure jícʉyʉmu caivʉ põevare boje, ne cʉrãjiyepe ayʉ mamaũmeque, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesús ʉ̃i que aiyede, ina judíova ne bajumia boroteni bʉ́rejaima, ʉ̃́re jaraivʉ, ʉ̃i nópe aiye boje. —¿Aipe d̶arĩ majare ʉ̃i bajure ãicõjeni bʉojaquidica ñai? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yópe arĩ, jẽvari coyʉrejame náre Jesús: —Jãve coyʉyʉbu mʉjare: Yʉ́bu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe. Ji jiarʉre ãmevʉ baru mʉja, aru ji jivede máre ũcumevʉ baru, cʉbenajaramu mʉja mamaũmeque. ");
INSERT INTO cubNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ácʉ põecʉ ji jiarʉre ãñʉ mácʉ aru ji jivede máre ũcuñʉ mácʉ jãravʉ cũiméjãravʉ baquinóre cʉvacʉyʉme. Aru yʉ́vacari ʉ̃́re nacovacʉyʉmu yainore jarʉvarĩ ãnijãravʉ bʉojaquijãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ãiye bajutamu ji jia. Aru ji jive máre ũcuiye bajutamu. ");
INSERT INTO cubNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ácʉ põecʉ ji jiarʉre ãñʉ mácʉ aru ji jivede ũcuñʉ mácʉ cʉbi yʉ́que, aru ʉ̃́que cʉvʉ yʉ máre. Cũinávʉpe cʉvʉ ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jipacʉ, ñai põevare apʉre d̶ayʉ mamaũmeque, darorejame yʉre aru apʉre d̶arejame. Nopedeca ácʉ põecʉ yʉre ãñʉ mácʉre, ʉ̃́re apʉre d̶acʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Iye ji coyʉvare ãiyebu cavarõ mearo Jʉ̃menijicʉi cʉrõi ẽmeni daiye báque ãiye. Mʉjeñecuva mácavʉ ne ãiye báquepe paiye ãmevʉ die. Na mácavʉ ãivʉ bácavʉvacari bʉcʉteni yaidéjaquemavʉ. Ʉbenita ácʉ põecʉ ãñʉ ji cari coyʉvare ãiyede cʉcʉyʉme cainʉmʉa, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum ãmicʉriĩmaroi cʉcʉ, judíovai cójijiñami põevare bueyʉ, nópe coyʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesús ʉ̃i nópe bueiyede maiyójeda dápiarĩ, yópe arejaima ʉ̃i bueimara obedivʉ. —Maiyójarõ baju bueibi. Nore jápiarĩ coreóvabevʉ ñʉja, arejaima na Jesúre buejʉrorivʉ ne bajumia. ");
INSERT INTO cubNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús, coreóvayʉ jorojĩvʉre ne bajumia jũjuvaivʉre ʉ̃́ra, jẽniari jã́rejame náre: —¿Cari mʉjare ji bueiye boje ãmeina jã́ivʉrʉ̃ yʉre? ");
INSERT INTO cubNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, ji cʉrõ mácarõi ji mʉiyede jã́ivʉ baru, aipe dápiaje bárica mʉja? ");
INSERT INTO cubNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jʉ̃menijicʉi Espíriturecabe põevare cʉre d̶ayʉ jãravʉ cũiméjãravʉ baquinóre. Põeva ne baju apevʉ põevare cʉre d̶aiye majibema. Iye cari ji coyʉiyeque, yʉrecabu mʉjare cʉvare d̶ayʉ Jʉ̃menijicʉi Espíriture, ñai põevare cʉre d̶ayʉre mamaũmeque ne jʉ aiyede yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ʉbenita apevʉ mʉjacavʉ yʉre jʉ abema cãreja, arejame náre Jesús. Ʉ̃i bueni bʉijãravʉ bácarõre jipocamiata, Jesús coreóvarejamed̶a ñame ʉ̃́re jʉ abenajivʉre aru ácʉ põecʉre ʉ̃́re jẽne d̶acʉyʉre ʉ̃i mauvare máre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús arejame náre cojedeca: —Caivʉ ãmevʉ mʉja jʉ aivʉ yʉre. Que baru coyʉyʉbu mʉjare: Ácʉ põecʉ cʉbebi ʉ̃i baju yóvacʉdayʉ yʉre, jʉ acʉyʉ jipacʉi ʉ̃́re daicõjemenu. Jipacʉrecabe põevare ji yebai darorĩ jʉ are d̶ayʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Dinʉmʉmia Jesúque buejʉrorivʉ bácavʉ ʉ̃́re dajocarejaima. Quénora ʉ̃́que cubedejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Que teiyede jã́ri, ñʉjare, ʉ̃i bueimarare, ñʉja doce paivʉ bajure, yópe jẽniari jã́rejame: —¿Mʉja máre yʉre dajocaiyʉrivʉrʉ̃? arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yópe arĩ darorejame Jesúre ñʉjacacʉ Simón Pedro: —Mʉ, ñʉje jabocʉ, mʉ́tamu ñʉjare jãve baju bueiyede coyʉyʉ. Mi coyʉiyeque ñʉjare cʉre d̶aivʉ mʉ jãravʉ cũiméjãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Javeta mʉre jʉ ad̶avʉ̃ ñʉja. Mʉre coreóvaivʉbu Jʉ̃menijicʉi mácʉ meacʉ bajure, arejame Pedro Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús arejame ñʉjare: —Mʉjare doce paivʉre beocacʉ yʉ. Ʉbenita cũinácʉ mʉjacacʉ abujuvai jabocʉi cõjeimʉme ʉ̃, arejame ñʉjare ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús que ayʉ, Judas, Simón Iscariotei mácʉ, ʉ̃i d̶aquinore coyʉyʉ barejáme. Judas Jesúi bueimʉ mácʉvacari, Jesúre jẽne d̶acʉyʉ barejáme ʉ̃i mauvare. ");
INSERT INTO cubNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","No yóboi Galilea ãmicʉrõcarõa ĩmaroa coapa cucʉñʉ marejáme Jesús. Ʉbenita Judea ãmicʉrõi nʉiyʉbedejame, nócavʉ judíova ñʉje jabova jorojĩni ne boaiyʉe boje ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ñʉja judíova ñʉje torojʉve teinʉmʉ, úcũa d̶ainʉmʉ, eare nʉino marejávʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Que baru Jesúre nʉicõjeivʉ, ʉ̃i yóva arejaimad̶a: —Yui mautebejacʉ mʉ. Quénora nʉjacʉ Judeaita, ina nócavʉre mi bueimara máre ne jã́rajiyepe aivʉ mi d̶aiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Põecʉ ʉcʉ baru apevʉ ne coreóvaiyede ʉ̃́re, ʉ̃i d̶aiyede d̶abebi yavenina. Que baru na caivʉre mi parʉéque mi d̶aiyede jã́d̶ovacʉnʉjacʉ mʉ, ãmiyó, arĩ coyʉrejaimad̶a ʉ̃i yóva. ");
INSERT INTO cubNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Dinʉmʉre ʉ̃i yóva Jesúre, “Jʉ̃menijicʉi mácʉbu mʉ”, abedejaimad̶a. Que barureca Jesúre nópe arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Náre, yópe arĩ, coyʉrejamed̶a Jesús: —Yʉre ji nʉino eabevʉ cãreja. Ʉbenita mʉjare, mʉje nʉiyʉrinʉmʉ nʉru, meavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mʉjare cõenímema ina Jʉ̃menijicʉre jʉ abevʉ. Ʉbenita yʉre jã́iyʉbema Jʉ̃menijicʉre jʉ abe põeva. Náre ne ãmeina teiyena coyʉivʉ yʉ. Que baru yʉre jã́iyʉbema. ");
INSERT INTO cubNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉjavacari torojʉve teiyede jã́ranʉjara. Yʉ nʉmevʉ cãreja, ji nʉquino eabe boje, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nópe arĩ coyʉyʉ bácʉ ʉ̃i yóvare, Jesúcapũravʉ mautedejame apejãravʉa no Galilea ãmicʉrõmia. ");
INSERT INTO cubNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ʉ̃i yóva ne torojʉve teiyede jã́ranʉriburu yóbore, Jesús máre nore jã́cʉnʉrejame. Aru ãrojamejiena earejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Torojʉve teinʉmʉre Jesúre pare vorĩdurejaimad̶a ñʉja judíova ñʉje jabova. —¿Ã́ri cʉri ñai? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ʉbenita ina põevacapũravʉ ne bajumia boroteivʉ barejáimad̶a ʉ̃i borore: —Meacʉbe ʉ̃. Põevare cad̶ateibi, arejaimad̶a. Ʉbenita apevʉ põeva: —Ãmecʉbe ʉ̃. Jʉjovaibi majare, arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ñʉje jabovare jidʉrĩna, bídeca nʉri, borotedejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Torojʉve teino corica tʉvaiye bajure, Jʉ̃menijicʉi cʉ̃rami nʉrejame Jesús. Nore ecorĩ, põevare bueni bʉ́rejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ʉ̃́re jápiaivʉ, ñʉje jabova cuecumari arejaima: —¿Buebecʉ bácʉvacari, aipe teni caiye iye jaʉbeda majidi ñai? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús náre yópe arĩ, coyʉrejame: —Ji bueiyede ji bajuma majibevʉ yʉ. Quénora yʉre daroyʉ bácʉbe yʉre majide d̶ayʉ. Ʉ̃ jiede bueyʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ácʉ põecʉ Jʉ̃menijicʉi ʉrõpe d̶aiyʉcʉ baru, coreóvacʉyʉme ã́roque ji bueiyede. Ji buedu Jʉ̃menijicʉi majiéque o ji baju majiéque, coreóvacʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ácʉ põecʉ ʉ̃i baju majiéque yávayʉ vorĩduibi põeva ne pued̶arãjiyepe ayʉ ʉ̃́re. Ʉbenita ácʉ põecʉ voyʉ põeva ne pued̶arãjiyepe ayʉ ʉ̃́re daroyʉ bácʉre, ʉ̃́recabe coyʉyʉ jãve, ye borocʉbecʉva. ");
INSERT INTO cubNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés bácʉ barejaquémavʉ mʉjare Jʉ̃menijicʉi d̶aicõjeiyede coyʉyʉ. Ʉbenita ácʉ mʉjacacʉ ʉ̃i toivarĩ epeiye báquepe jʉ arĩ d̶ayʉ cʉbebi. ¿Aipe teni yʉre boarĩ́ jarʉvaiyʉrivʉrʉ̃ mʉja? arejame Jesús ñʉje jabovare. ");
INSERT INTO cubNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—Abujucʉ cʉbi mʉ́que. ¿Ñamema boaiyʉrivʉ mʉre? arejaima ina põeva obedivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús arejame náre: —Cũinájãravʉ mʉje jabʉóvaijãravʉi cũináro ji d̶aino mácarõre mʉje d̶arĩ majibenore cuecumavʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mʉja buraicõjevaivʉbu mʉjemara ʉ̃mʉ jʉed̶ovare ne cajede jabʉóvaijãravʉi, ocho paijãravʉa baru ne põeteniburu yóbore, yópe Moisés bácʉ ʉ̃i d̶aicõjeiye báquepe. Ʉbenita Moisés bácʉ ãmenejaquemavʉ buraicõjeni bʉ́yʉ. Quénora majeñecuva mácavʉ, Moisés bácʉi ñecuva mácavʉ barejaquémavʉ ʉ̃mʉvai cajede buraicõjeni bʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mʉja máre buraicõjeivʉ mʉjemara ʉ̃mʉ jʉed̶ovai cajede mʉje jabʉóvaijãravʉi, d̶arãjivʉ yópe Moisés bácʉ ʉ̃i d̶aicõjeiyepe. ¿Dinʉmʉ aipe teni jorojĩvʉrʉ̃ yʉre ji mead̶aiye báque boje cũinácʉ ijimʉ mácʉi bajure maje jabʉóvaijãravʉi? ");
INSERT INTO cubNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Coyʉrĩ dajocajarã mʉja apecʉ meacʉre o ãmecʉre ʉ̃i ãrojae bojeda. Quénora dápiajarã apecʉ meacʉre o ãmecʉre ʉ̃i jãve d̶aiye boje, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jesús nópe ayʉre jápiaivʉ, Jerusalén ãmicʉriĩmarocavʉ arejaima: —¿Ñai ãmeni maje jabova pare ne vóvaimʉ boarĩ́ jarʉvaiyʉrĩduivʉ? ");
INSERT INTO cubNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jã́rijide apa. Maje coricai majare bueyʉbe ʉ̃. Ʉbenita aipe abema maje jabova. “Cristo, Jʉ̃menijicʉi epeimʉ bajube ʉ̃”, ad̶arãma na. ");
INSERT INTO cubNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Cristoi daiyede ñame majibenajarama ã́rocacʉre. Ʉbenita ñai Jesús ʉ̃i cʉrõ mácarõre majivʉ maja, arejaima ĩmarocavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ne que aiyede coreóvayʉ Jesús, bueyʉvacari Jʉ̃menijicʉi cʉ̃rami, yópe arĩ darorejame bʉjié: —Yʉre aru ji daino mácarõre majivʉ mʉja. Ʉbenita ji bajuma ji majiéque dabedejacacʉ yʉ. Quénora darejacacʉ yʉ apecʉ ʉ̃i daroimʉ mácʉ. Ʉ̃́tame borocʉbecʉ. Ʉ̃́recabe mʉje coreóvabemʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ʉ̃́tame daroyʉ bácʉ yʉre, ʉ̃́que cʉcʉ bácʉre. Que baru yʉrecabu ʉ̃́re me coreóvayʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Dinʉmʉre Jesúre jẽni jacojʉrorivʉ barĩdurejaima ñʉje jabova. Ʉbenita ʉ̃́re ne jẽnajijãravʉ ãmenejaquemavʉ cãreja. Que baru Jesúre ñame jẽmenejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Obedivʉ ina põevacavʉ Jesúre jʉ aivʉ, yópe arĩ, coyʉivʉ barejáima: —Cristo, Jʉ̃menijicʉi daroimʉ macʉyʉ́, ʉ̃i daquiyede jãve põeva ne d̶arĩ majibede jã́d̶ovañʉ bʉojabejebu Jesús pʉeno. ¿Mʉ́carĩ? arejaima ina põeva obedivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ne que aiyede Jesúi borore jápiarĩ fariseovacavʉ, ina fariseova aru sacerdotevare jaboteipõeva máre Jʉ̃menijicʉi cʉ̃ramine coreipõevacavʉre jẽni jacoicõjenidurejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Dinʉmʉre Jesús yávayʉ, põevare arejame: —Majióvarõ bajura cʉcʉyʉmu mʉjaque. Quĩ́jino bajura jaʉvʉ yʉre ji copaini nʉquino yʉre daroyʉ bácʉ yebai. ");
INSERT INTO cubNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Dinʉmʉ maquinóre pare vorãjaramu mʉja yʉre. Ʉbenita ji nʉquinore nʉiye majibevʉ mʉja. Que baru eabenajaramu yʉre, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Que ayʉre, ina judíova ñʉje jabova ne bajumia yávaivʉ arejaima: —¿Ã́ri nʉquidica ñai, ñʉje eabenajiyepe ayʉ ʉ̃́re? ¿Apeno joborõi, majevʉ ne cʉrãnʉiĩmaro mácarõi, cʉcʉnʉquidica ʉ̃, buecʉyʉ nócavʉ judíova ãmevʉre? ");
INSERT INTO cubNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Yʉre pare vorĩdurãjaramu mʉja. Ʉbenita ji nʉquinore nʉiye majibevʉ mʉja”, aibi. ¿Aipe aiyʉrõ márica no ʉ̃i que aino? arejaima ne baju. ");
INSERT INTO cubNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","No torojʉve teino bʉojaijãravʉ pʉeno meajãravʉ barejávʉ̃. Dijãravʉre Jesús nacajari núcʉ, yópe arĩ darorejame bʉjié: —Ácʉ põecʉ pare cʉvaiyʉcʉ baru jãravʉ cũiméjãravʉ baquinóre yópe põecʉ cũiñóimʉ ʉ̃i pare ũcuiyepe ocore, jʉ ajacʉrĩ yʉre. Aru yópe ji jíjʉroepe ocore cũiñóimʉre, nopedeca ʉ̃́re cʉre d̶acʉyʉmu yʉ jãravʉ cũiméjãravʉ baquinóre. ");
INSERT INTO cubNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yópe arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃i yávaiyede: “Ácʉ põecʉ yʉre jʉ ayʉ bácʉre cʉre d̶acʉyʉmu yʉ mamaũmeque yópe cʉre d̶aioco pĩapóri daiyepe”, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nópe ayʉ, Espíritu Santo ʉ̃i borore ayʉ barejáme Jesús. Caivʉ Jesúre jʉ aivʉ jacopʉivʉ barãjárama ñai Espíritu Santore. Dinʉmʉre Jʉ̃menijicʉ Espíritu Santore darobedejaquemavʉ cãreja, Jesús ʉ̃i mʉri nʉme boje cãreja, mearore cʉvacʉyʉ cavarõ mearo Jʉ̃menijicʉi cʉrõi. ");
INSERT INTO cubNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Apevʉ ina obedivʉ põeva ne jápiarĩburu yóboi Jesús ʉ̃i que aiyede, ne bajumia boroteivʉ arejaima: —Jãve ñaime Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bacʉyʉ́, “edacʉyʉ” ne ávaimʉ, arejaima apevʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Apevʉ nácavʉ arejaima: —Ñai Jʉ̃menijicʉi daroimʉ mácʉbe Cristo baju, arejaima. Ʉbenita apevʉ nácavʉ arejaima: —Cristo baju Galileacacʉ ãmecʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","David bácʉi pãramecʉ bacʉyʉ́me Cristo baju. Belén ãmicʉriĩmarocacʉ, David bácʉi cʉriĩmaro mácarõcacʉ bacʉyʉ́me Cristo. Que arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃i yávaiyede, arejaima apevʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Que baru Jesúre cũinátʉrʉra yávabedejaima põeva. Cũinátʉrʉ ãmenejavʉ̃ ne ũme. ");
INSERT INTO cubNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jesúre jẽni jacoiyʉrejaima apevʉ nácavʉ. Ʉbenita ñame ʉ̃́re jẽmenejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Que teiyede Jʉ̃menijicʉi cʉ̃ramine coreipõevacavʉ Jesúre jẽni jacoicõjeniduimara mácavʉ copainʉrejaimad̶a fariseova aru sacerdotevare jaboteipõeva yebai. —¿Aipe teni Jesúre jẽmetenarʉ mʉja? arejaimad̶a náre ina fariseova aru sacerdotevare jaboteipõeva. ");
INSERT INTO cubNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—Ʉ̃i bueiyepe coyʉyʉre ñʉja ye jápiabevʉ. Que baru ʉ̃́re jẽni davabetevʉ ñʉja, arejaimad̶a ina coreipõeva. ");
INSERT INTO cubNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Quénomia ina fariseova arejaimad̶a: —Mʉja máre ʉ̃i jʉjovaiyede jʉ arebu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ñʉja fariseova aru ina jabova máre ye jʉ abevʉ Jesúre. Ye ñʉjacacʉ cũinácʉ ʉ̃́re jʉ abebi. ");
INSERT INTO cubNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ʉbenita põevacapũravʉ Jʉ̃menijicʉi d̶aicõjeiyede ʉ̃i toivaicõjeiye báquede Moisés bácʉre majibema na. Ne majibe boje, Jʉ̃menijicʉi ñájine d̶aimara marajárama na toabo cũiméboi, arejaimad̶a ina fariseova. ");
INSERT INTO cubNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Fariseovacacʉ Nicodemo, Jesúre boroteyʉ bácʉ jipocamia, cʉrejamed̶a náque. Aru apevʉ nore cʉrivʉre arejamed̶a ʉ̃: ");
INSERT INTO cubNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Jesús ʉ̃i boro bajure coyʉbebi cãreja. Nópe páyʉre põecʉre ñájine d̶aicõjemevʉ Jʉ̃menijicʉi d̶aicõjeiye ʉ̃i toivaicõjeiye báque majare. Ʉ̃i baju coyʉiyede jápiaiye jaʉvʉ majare, maje majinajiyepe aivʉ yéde ʉ̃i d̶aiyede, arĩdurejamed̶a Nicodemo. ");
INSERT INTO cubNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ʉ̃́re arejaimad̶a na: —¿Mʉ máre Galileacacʉrʉ̃? Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báquede me buejacʉ mʉ, majicʉyʉ. Ácʉ Galileacacʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ cʉbevaibi ʉ̃, arejaimad̶a Nicodemore ina fariseova. ");
INSERT INTO cubNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Que arĩ, ne cʉ̃ramia coapa copainʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Põevare coyʉrĩ bubarĩ cʉ̃racũ Olivocũ ãmicʉricũi mʉri nʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cõmiáijãravʉ javejĩna, Jʉ̃menijicʉi cʉ̃ramine copainʉrejame Jesús. Ʉ̃i yebai darejaima obedivʉ põeva. Que baru dobarĩ, ʉ̃́re edaivʉre bueni bʉ́rejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ʉ̃i bueiyede, Jʉ̃menijicʉi yávaiye báquede bueipõevacavʉ aru fariseovacavʉ máre cũináco nomió ne eaimo máco cʉcore apecʉque, jímarepacʉre jarʉvarĩ, davarejaima Jesús yebai. Ṍre núicõjenejaima ina obedivʉ põeva ne coricai. ");
INSERT INTO cubNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Aru arejaima Jesúre: —Mʉ, bueipõecʉ, ico nomió jímarepacʉre jarʉvarĩ apecʉque cʉcore eavʉ ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés bácʉ ṍpe pád̶ore cʉ̃raboaque dʉreni boarĩ́ jarʉvaicõjenejaquemavʉ, yópe Jʉ̃menijicʉi d̶aicõjeiyepe. ¿Aru mʉ́capũravʉ aipe ayʉrʉ̃ mʉ ṍre? arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Que aivʉ ʉ̃́re jʉjovarĩdurejaima, boro coyʉrĩ ad̶aiyʉrĩdurãjivʉ ʉ̃́re, ʉ̃i vainí tʉ́jʉroede ne d̶aicõjeiyede. Ʉbenita Jesús nacachini, joborõi ãmuyoque toivarejame. ");
INSERT INTO cubNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ʉ̃i que d̶aiyede, Jesúre jẽniari jã́ranʉrejaima na. Ne que teiyede nacajari, núri, arejame náre: —Jede, mʉjacacʉ ãmeina tebecʉ bácʉ bajacʉ́rĩ mamarʉmʉ dʉreni bʉ́yʉ ṍre cʉ̃raboaque, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Que arĩ, bedióva cojedeca nacachini, joborõi toivarejame. ");
INSERT INTO cubNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nópe ʉ̃i aiyede jápiaivʉva, cũinácʉ, cũinácʉ etarĩ nʉrejaima na, Jʉ̃menijicʉi yávaiye báquede bueipõeva aru fariseova máre. Ne pʉeno bʉcʉcʉ mamarʉmʉ aru ʉ̃i cãchinocavʉ ʉ̃i yóbo etarĩ nʉrejaima. Pʉ mautedejacarã ñʉja, Jesújã, ico nomióque. ");
INSERT INTO cubNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Cojedeca nacajari, núri, arejame ṍre Jesús: —¿Mʉre boro coyʉrĩ ad̶arĩduivʉ ã́ri cʉri na? ¿Mi ãmenore d̶aiye boje, põecʉ cʉbedi mʉre ñájine d̶ayʉ? arejame ṍre. ");
INSERT INTO cubNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Cʉbebi, ji jabocʉ, arejaco õ. —Yʉ máre mʉre ñájine d̶abevʉ. Nʉjaco mʉ caride. Aru ãmeina d̶abejaco cojedeca, arejame ṍre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Bedióva cojedeca põevare yávarejame Jesús: —Yʉrecabu pẽoinope páyʉ ijãravʉcavʉre ne ũmei, coreóvare d̶acʉyʉ Jʉ̃menijicʉi dápiaiye jãvene ji bueiyeque. Ácʉ põecʉ yʉre yóvacʉdayʉ, ʉ̃́recabe cʉvacʉyʉ iye pẽoiye apʉre d̶aiyede. Que baru mamaũmene cʉvacʉyʉme ʉ̃. Ʉ̃́recabe cʉcʉyʉ yópe miad̶ároi cuyʉpe, cainʉmʉa ñeminoi cubecʉyʉ. Ʉbenita põeva coreóvabevʉ Jʉ̃menijicʉi dápiaiye jãvene cʉrivʉbu yópe ñeminoi cuivʉpe, ne majibe boje ʉ̃i dápiaiye jãvene, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseovacavʉ arejaima ʉ̃́re: —Mʉrecabu mi borore coyʉyʉ mi baju. Que baru ʉbenina que ayʉbu. Bojecʉbevʉ mi que coyʉiye, arejaima ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yópe arĩ, coyʉrejame Jesús: —Ji borore ji coyʉiyevacari bojecʉetamu. Yʉ́vacari coreóvaivʉ ji cʉrõ mácarõre aru ji nʉquinore máre. Que baru ji coyʉiye jãvetamu. Ʉbenita ji cʉrõ mácarõre aru ji nʉquinore máre ye coreóvabevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉjacapũravʉ apevʉre ñájine d̶ávaivʉbu põevare mʉje coyʉiyeque. Ʉbenita yʉ́capũravʉ ñamene ñájine d̶abecʉbu. ");
INSERT INTO cubNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ʉbenita põevare ji ñájine d̶aru, ji nópe d̶aiye jãve májebu. Quénora cũinácʉ ji baju nópe d̶abejebu yʉ. Quénora jipacʉ, ñai daroyʉ bácʉ yʉre yui, nópe d̶ajebu yʉ́que. ");
INSERT INTO cubNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉje d̶aicõjeiyede yópe arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ: “Pʉcarã cũinátʉrʉ ne coyʉru ne jã́iye báquede, bojecʉvʉ ne que coyʉiye”, arĩ toivaicõjenejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉ́vacari ji borore coyʉyʉbu. Aru jipacʉ, ñai daroyʉ bácʉ yʉre, ʉ̃ máre coyʉcaibi ji borore, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Mipacʉ ã́ri cʉri ʉ̃? jẽniari jã́rejaima Jesúre fariseova. —Yʉre coreóvabevʉbu mʉja. Aru jipacʉre máre coreóvabevʉbu mʉja. Yʉre coreóvaivʉ baru, jipacʉre máre coreóvajebu mʉja, arejame Jesús náre. ");
INSERT INTO cubNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Caiye iyede coyʉrejame Jesús ʉ̃i bueiyede põevare Jʉ̃menijicʉi cʉ̃rami, Jʉ̃menijicʉre tãutʉra jíye epeitõcua yebai. Ʉbenita põecʉ cʉbedejame jẽni jacocʉyʉ ʉ̃́re, ʉ̃i mauva ʉ̃́re ne jẽnajijãravʉ baquinó eabe boje cãreja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bedióva cojedeca põevare yávarejame Jesús: —Yʉrecabu nʉcʉyʉ. Yʉre vorĩdurãjaramu mʉja. Ʉbenita yainájaramu mʉja boropateivʉ, mʉje ãmeina d̶aiyede dajocabe boje aru “Jesúbe Jʉ̃menijicʉi mácʉ aru majare mead̶aipõecʉ”, mʉje abe boje. Ji nʉquinore nʉri bʉojabenajaramu mʉja, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Que ayʉre, ina judíova ñʉje jabova ne bajumia yávaivʉ arejaima: —¿Ñʉjare “Ji nʉquinore nʉri bʉojabenajaramu mʉja” ʉ̃i ainoque, jãve ʉ̃i baju boarĩ́ jarʉvacʉyʉba? arejaima ne bajumia. ");
INSERT INTO cubNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Náre arejame Jesús: —Mʉjacapũravʉ ijoborõcavʉbu mʉja. Ʉbenita yʉrecabu ʉ̃mʉcacʉ, cavarõ mearo Jʉ̃menijicʉi cʉrõcacʉ. Mʉjacapũravʉ ijãravʉcavʉbu mʉja. Ʉbenita yʉ́capũravʉ ijãravʉcacʉ ãmevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Que baru “Yainájaramu mʉja boropateivʉ, mʉje ãmeina d̶aiyede dajocabe boje, ‘Jesúbe Jʉ̃menijicʉi mácʉ aru majare mead̶aipõecʉ’, mʉje abe boje”, avʉ mʉjare. Mʉje jʉ abe boje ji ávarede ji baju, “Jʉ̃menijicʉi mácʉbu yʉ, caivʉre mead̶aipõecʉ”, ji arĩ coyʉvarede, yainájaramu mʉja boropateivʉ, mʉje ãmeina d̶aiyede dajocabe boje, “Jesúbe Jʉ̃menijicʉi mácʉ aru majare mead̶aipõecʉ”, mʉje abe boje, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Yécʉrʉ̃ mʉ? jẽniari jã́rejaima ʉ̃́re. —Mamarʉmʉ ji bʉiyede aru carita ji coyʉvacamʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʉjare ji coyʉjʉroe ʉrarõ cʉvavʉ. Aru ʉrarõ mʉjare ji ñájine d̶ájʉroe máre cʉvavʉ. Ʉbenita ñai daroyʉ bácʉ yʉre borocʉbecʉbe aru jãve yávayʉbe ʉ̃. Que baru ʉ̃i coyʉicõjeino mácarõpeda mʉja ijãravʉcavʉre coyʉivʉ yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ʉbenita “yʉre daroyʉ bácʉ”, ʉ̃i aiyede, “jipacʉ”, ayʉre majibedejaquemavʉ na. ");
INSERT INTO cubNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Que baru yópe arĩ, coyʉrejame Jesús náre: —Mʉje jocʉcʉrã jẽori jãmʉórajiyede yʉre, Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe, majinajaramu jãvene ji ávarede ji baju, “Jʉ̃menijicʉi mácʉbu yʉ, caivʉre mead̶aipõecʉ”, ji arĩ coyʉvarede. Dinʉmʉ maquinóre majinajaramu mʉja. Ji baju jipacʉi coyʉbenore d̶ayʉ bʉojabevʉ. Quénora jipacʉ, Jʉ̃menijicʉ, ʉ̃i coyʉiyepedata, yópe ʉ̃i coyʉicõjeiye báquepe yʉre, coyʉyʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ñai daroyʉ bácʉ yʉre cʉbi yʉ́que. Yʉre cũinácʉra jocarĩ nʉmecʉbe jipacʉ, ji d̶aiye boje ʉ̃i ʉrõpe cainʉmʉa, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesús nópe ayʉre jápiarĩ, jʉ arejaima ʉ̃́re obedivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ina judíova Jesús yebai cójijivʉre, ʉ̃́re jʉ aivʉ bácavʉre yópe arĩ, coyʉrejame Jesús: —Mʉja jʉ aivʉ baru ji bueiyede, ji bueimara baju barãjáramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ji bueiye jãve bajure majinajaramu mʉja. Aru que baru apecʉi cõjeimarape ãmenajaramu mʉja, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ʉ̃́re arejaima ina judíovacavʉ: —Ñʉja Abraham mácʉi pãramenatamu. Que baru cainʉmʉa apecʉi cõjeimara ãmevʉ ñʉja. ¿Aipe teni “Apecʉi cõjeimarape ãmenajaramu mʉja”, ayʉrʉ̃ mʉ ñʉjare? arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Náre jʉ ayʉ arejame Jesús: —Jãve coyʉyʉbu mʉjare: Yópe cõjeimara ne baju ʉrõpe d̶abevʉ, quénora apecʉi ʉrõpe d̶aivʉ, nopedeca caivʉ ina ãmeina d̶aivʉ cõjeimarapebu, ne ãmeina d̶aiyʉe boje. ");
INSERT INTO cubNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cʉ̃rami upacʉi márape ãmema ʉ̃i cõjeimara. Mamara memeivʉ ne ʉe boje népacʉre. Ʉbenita cõjeimara memeivʉ ne jabocʉi cõjeiye boje náre. Quénora ʉbenina cʉrivʉtamu ina cõjeimara. Jabocʉi márape cainʉmʉa ména cʉbema ʉ̃i cõjeimara. Ʉbenita jívʉ bajutamu mamara baju. Que baru me cʉima népacʉque cainʉmʉa. Aru yʉ́vacari Jʉ̃menijicʉi mácʉ bajubu. ");
INSERT INTO cubNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Que baru yʉ, Jʉ̃menijicʉi mácʉ, mʉjare cõjeimarape ãmevʉre ji d̶aru, jãve bajureca cõjeimarape ãmevʉ barãjáramu mʉja. D̶arãjaramu mʉje d̶aiyede mʉje ʉe boje majepacʉ Jʉ̃menijicʉre. D̶abenajaramu mʉje d̶aiyede apecʉ ʉ̃i cõjeiye boje mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Coreóvaivʉ yʉ mʉjare Abraham mácʉi pãramenare. Ʉbenita ji bueiyede jʉ aiyʉbevʉbu mʉja. Que baru yʉre boarĩ́ jarʉvaiyʉrivʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉ́capũravʉ coyʉyʉbu jipacʉi jã́d̶ovaiye báquede yʉre. Ʉbenita mʉjacapũravʉ d̶aivʉbu yópe mʉjepacʉi coyʉiye báquepe mʉjare, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Ñʉjeñecu mácʉ barejaquémavʉ Abraham mácʉ, arejaima na. Ʉbenita Jesús arejame náre: —Abraham mácʉi pãramena baju baru, ʉ̃i d̶aiye báquepedeca d̶ajebu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ʉbenita iye yávaiye jãvene Jʉ̃menijicʉi bueiye báquede yʉre coyʉyʉ bácʉreca mʉjare, mʉjacapũravʉ boarĩ́ jarʉvaiyʉrivʉbu yʉre. Que d̶abedejaquemavʉ Abraham mácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉje que d̶aiyʉeque, yópe mʉjepacʉi d̶aiyepedeca d̶aiyʉrivʉbu mʉja, arejame náre Jesús. Nácapũravʉ arejaima ʉ̃́re: —Ñʉja ʉbenina eaimara ãmevʉ. Jʉ̃menijicʉvacaribe cũinácʉ ñʉjepacʉ baju, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Náre, yópe arĩ, coyʉrejame Jesús: —Jʉ̃menijicʉi cʉrõi cʉcʉ bácʉ yore ẽmeni darejacacʉ yʉ. Aru cʉvʉ caride yui. Que baru Jʉ̃menijicʉ mʉjepacʉ baju baru, yʉre ʉjebu mʉja. Ji bajuma ji majiéque dabedejacacʉ yʉ. Quénora Jʉ̃menijicʉi daroimʉ mácʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Aipe teni ji coyʉiyede jápiarĩ eabenarʉ mʉja? Yʉre ji coyʉiyede jápiaiyʉbevʉbu mʉja. Que baru jápiarĩ eabevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉjepacʉbe abujuvai jabocʉ. Ʉ̃́pe paivʉbu mʉja. Ʉ̃i ʉrõpe d̶aiyʉrivʉbu mʉja. Mamarʉmʉre aru caride máre, põevare boarĩ́ jarʉvaipõecʉbe ʉ̃. Jʉ̃menijicʉi yávaiyede jãvene jápiaiyʉbebi ʉ̃. Aru cainʉmʉa yávaiyede jãvene coyʉbebi ʉ̃. Ʉ̃i borocʉede coyʉyʉbe ʉ̃, “¿Jãve márica?” põeva ne arãjiyepe ayʉ. Aru mamarʉmʉcacʉ borocʉcʉbe ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ʉbenita yʉ́capũravʉ coyʉyʉbu yávaiyede jãvene. Mʉjacapũravʉ ji coyʉiyede jʉ abevʉbu. ");
INSERT INTO cubNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ñame mʉjacacʉ ji ãmeina d̶aiyede jã́d̶ovañʉ bʉojabebi, ji boropatebe boje. Jãvetamu ji coyʉiye. ¿Dinʉmʉ aipe teni diede jʉ abenarʉ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jʉ̃menijicʉ jicʉ jápiaibi ʉ̃i yávaiyede. Ʉbenita mʉjacapũravʉ Jʉ̃menijicʉ jina ãmevʉ. Que baru ʉ̃i yávaiyede jápiaiyʉbevʉbu mʉja, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Dinʉmʉ ina judíova arejaima Jesúre: —Jãve coyʉivʉbu ñʉja: Samariacacʉbu mʉ. Aru abujucʉ cʉbi mʉ́que, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Náre arejame Jesús: —Abujucʉ cʉbebi yʉ́que. Jipacʉre pued̶aivʉ yʉ. Ʉbenita yʉre pued̶abevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yʉre mearore jívʉre vobevʉ yʉ. Ʉbenita jipacʉ ʉbi põevare ne jínajiyepe ayʉ mearore yʉre. Aru ʉ̃́recabe coyʉyʉ põevare ne d̶aiye báque méne aru ãmene máre. ");
INSERT INTO cubNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ jʉ ayʉ ji coyʉiyede yaibécʉyʉme, arejame Jesús. Que ayʉ, põecʉi yaibéde ʉ̃i ũmei aiyʉcʉ barejaquémavʉ Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Arejaima na: —Caride jãve coreóvaivʉbu ñʉja. Abujucʉ cʉbi mʉ́que. Javede Abraham mácʉ aru ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ máre yaidéjaquemavʉ. Ʉbenita “Ácʉ põecʉ jʉ ayʉ ji coyʉiyede yaibécʉyʉme”, mʉ ayʉbu. ");
INSERT INTO cubNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Majeñecu Abraham mácʉ yaidéjaquemavʉ. ¿Ʉ̃i pʉeno parʉcʉrʉ̃ mʉ? Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ máre yaidéjaquemavʉ. ¿Yécʉpe páyʉrʉ̃ mʉ, mi dápiaru? arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Que aivʉre, yópe arejame Jesús: —Ji baju “Meacʉtamu yʉ” ji aru, bojecʉbejebu no. Ʉbenita jipacʉrecabe “Meacʉtamu mʉ” ayʉ yʉre. Ʉ̃́recabe “ñʉjepacʉ Jʉ̃menijicʉ”, mʉje aimʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉjacapũravʉ ʉ̃́re ye coreóvabevʉbu. Ʉbenita yʉrecabu coreóvayʉ. “Ʉ̃́re coreóvabevʉ yʉ” ayʉ baru, mʉjapedeca borocʉjebu yʉ. Ʉbenita ʉ̃́re coreóvaivʉ yʉ. Ʉ̃i coyʉiyede me jʉ aivʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aru dápiayʉ bácʉ ji edaquiyede ijãravʉi, torojʉrejaquemavʉ majeñecu Abraham mácʉ. Que teyʉ, ji edaiyede jã́ñʉ mácʉ, yʉre torojʉrejame ʉ̃ mácʉ, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ina judíova arejaima ʉ̃́re: —Cincuenta paiʉjʉa cʉvabevʉ mʉ. Aru Abraham mácʉ javeita yaidéjaquemavʉ. ¿Aipe teni “Jã́rejacacʉ ʉ̃ mácʉre”, ayʉrʉ̃ mʉ? arejaima Jesúre na. ");
INSERT INTO cubNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Jãve coyʉyʉbu mʉjare: Abraham mácʉ ʉ̃i põetequiye jipocai cʉrejacacʉ yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ʉ̃i que aiyede, Jesúre jorojĩvʉ, ina judíova boarĩ́ jarʉvaiyʉrivʉ ʉ̃́re ĩnejaima cʉ̃raboare, dʉrenajivʉ ʉ̃́re. Ʉbenita Jʉ̃menijicʉi cʉ̃ramine jocarĩ etarĩ, dupini nʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","No yóboi, Jesús ʉ̃i cuiyede, jã́rejame cũinácʉ ʉ̃mʉ, jã́ri eabecʉre. Nópe põetedejamed̶a ñai jã́ri eabecʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ñʉja Jesúi bueimara jẽniari jã́rejacarã ʉ̃́re: —Bueipõecʉ, ¿aipe teni jã́ri eabecʉ põetedejaquemari ñai? ¿Ʉ̃i baju ãmeina d̶aiye boje nópe põetedejaquemari? ¿O ʉ̃i bʉcʉva ne ãmeina d̶aiye boje nópe põetedejaquemari? arejacarã ñʉja Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ñʉjare, yópe arĩ, coyʉrejame: —Ʉ̃i baju ãmeina d̶aiye boje ãmevʉ aru ʉ̃i bʉcʉva ne ãmeina d̶aiye boje máre ãmevʉ nópe põeteyʉ bácʉ ʉ̃ jã́ri eabecʉ. Jʉ̃menijicʉi parʉéde jã́d̶ovaquiyepe ayʉ, nópe põetedejaquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Jãravʉre põeva memeivʉ bʉojad̶ama. Ʉbenita ñemié tʉiyede memeivʉ bʉojabema. Quédeca majare máre d̶aiye jaʉvʉ yʉre daroyʉ bácʉi d̶aicõjeiyede jãravʉre cãreja. Ʉbenita ji yainíburu yóboi quénora d̶arĩ bʉojabecʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ji cʉede cãreja ijãravʉi, pẽoinope páyʉ Jʉ̃menijicʉi dápiaiye jãvene majide d̶aivʉ ijãravʉcavʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Que ayʉ bácʉ, yebarã jẽcuturi, najuári joboque jĩvarejame. Ʉ̃i jĩvaiye báquede ĩni, jã́ri eabecʉi yacorʉare jobo jĩjovarejame. ");
INSERT INTO cubNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jĩjovañʉ mácʉ ʉ̃́re arejame Jesús: —Siloé ãmicʉriocobʉi mi yacorʉare joacʉnʉjacʉ mʉ, arejame jã́ri eabecʉre Jesús. Siloé aino, “Jaroicobe” aiyʉrõtamu. Dibʉi nʉri, ocoque ʉ̃i yacorʉare joarejame. Joarĩ bʉojarĩ, ʉ̃i cʉ̃rami copainʉrejame, jã́ñʉta. ");
INSERT INTO cubNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ʉ̃́re, tãutʉrare jẽniañʉre jipocamia, jã́ivʉ bácavʉ arejaima ne bajumia: —Jã́rijide apa. ¿Jã́ri eabecʉ bácʉ tãutʉrare jẽniari dobavayʉ bácʉ ãmeni ñai? arejaima ʉ̃i cʉrõcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Jʉ̃́jʉ, ʉ̃ baju apa, arejaima nácavʉ. —Ʉ̃ ãmemi. Ʉ̃́reca páyʉbe. Ʉbenita jã́ri eabecʉ bácʉ ãmemi ʉ̃, arejaima apevʉ. Ne que aiyede, ʉ̃i bajumareca arejame: —Jã́ri eabecʉ bácʉbu yʉ, arejame, náre coyʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Dinʉmʉ ʉ̃́re jẽniari jã́rejaima ʉ̃i cʉrõcavʉ: —¿Aipe d̶arĩ jã́ri eayʉrʉ̃ mʉ? arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Jesús ãmicʉcʉ yebarã jẽcuturi, joboque jĩvacʉbe. Die ʉ̃i joboque jĩvaiye báqueque ji yacorʉare jĩjovami ʉ̃. “Siloé ãmicʉriocobʉi joacʉnʉjacʉ mʉ”, abi yʉre. Que d̶acʉnʉvʉ yʉ. Diede joayʉ bácʉ, jã́vʉ yʉ, arĩ coyʉrejame ʉ̃i cʉrõcavʉre jã́ri eabecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Mi aimʉ ã́ri cʉri ʉ̃ caride? arejaima ʉ̃́re ʉ̃i cʉrõcavʉ. —Aidica, majibevʉ yʉ, arejame náre jã́ri eabecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Dinʉmʉre jã́ri eabecʉ bácʉre nʉvarejaimad̶a ʉ̃i cʉrõcavʉ fariseova yebai. ");
INSERT INTO cubNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Dijãravʉ, Jesúi joboque jĩjovari mead̶aijãravʉ bácarõ jã́ri eabecʉ bácʉre ñʉja judíova ñʉje jabʉóvaijãravʉ sábado barejávʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ina fariseova jã́ri eabecʉ bácʉre jẽniari jã́rejaimad̶a: —¿Aipe teni jã́ri eayʉrʉ̃ mʉ? arejaimad̶a. —Jobo ʉ̃i jĩvaiye báqueque ji yacorʉare jĩjovame. Joacʉnʉvʉ, ʉ̃i cõjeiyepe. Que teyʉ bácʉ jã́ivʉ caride, arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—Jʉ̃menijicʉi daroimʉ mácʉ ãmecʉbe ʉ̃, mʉre mead̶ayʉ bácʉ, ʉ̃i memeiye boje maje jabʉóvaijãravʉre, arejaimad̶a apevʉ ina fariseovacavʉ. Ʉbenita apevʉ arejaimad̶a: —¿Ãmeina d̶ayʉ baru, aipe teni põeva ne d̶arĩ majibede jã́d̶ovaiye majidi ʉ̃? arejaimad̶a nácavʉ. Que arĩ ne bajumia cũinátʉrʉra yávabedejaimad̶a. Aru cũinátʉrʉ ãmenejavʉ̃ya ne ũme. ");
INSERT INTO cubNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bedióva cojedeca ina fariseova jẽniari jã́rejaimad̶a ʉ̃́re: —¿Ñai mʉre mead̶ayʉ bácʉ mi aimʉ, mi dápiaru, ye põecʉ páyʉ bárica ʉ̃? arejaimad̶a. —Ji dápiaru, Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉbe ʉ̃, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ʉbenita ñʉje jabova judíova “Jã́ri eabecʉ bácʉbe jã́ñʉ”, abedejaimad̶a cãreja. Que baru ʉ̃i bʉcʉvare cutuicõjenejaimad̶a, ne darãjiyepe aivʉ ne yebai. Ne eaiyede fariseova jẽniari jã́rejaimad̶a: ");
INSERT INTO cubNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Mʉjemacʉba ñai? ¿Aru mʉjemacʉ baru, jã́ri eabecʉ põetedejarĩ ʉ̃? ¿Nópe põeteyʉ bácʉvacari, aipe teni jã́ñʉma caride? arejaimad̶a jã́ri eabecʉ bácʉi bʉcʉvare ina fariseova. ");
INSERT INTO cubNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ñʉjemacʉ bajube ñai. Jã́ri eabecʉ põetedejame. ");
INSERT INTO cubNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Aru caride jã́ri eaibi. Aipe teni jã́ñʉ mácʉre majibevʉbu ñʉja. Ʉ̃́re mead̶ayʉ bácʉre coreóvabevʉbu. Jẽniari jã́jara ñʉjemacʉre. Bʉcʉcʉbe ʉ̃. Ʉ̃i baju coyʉcʉyʉme mʉjare, arejaimad̶a ʉ̃i bʉcʉva. ");
INSERT INTO cubNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nópe arejaimad̶a, ne jidʉé boje ñʉja judíova ñʉje jabovare. Jipocamia yópe arĩ, coyʉrejaimad̶a ina fariseova: “Ácʉ põecʉ ‘Jesúbe Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃’ ayʉre, ñʉje cójijiñamine jaetovarãjaramu ñʉja, ʉ̃i cójijibequiyepe aivʉ ñʉjaque bedióva cojedeca”, aivʉ barejáimad̶a na jipocamia. ");
INSERT INTO cubNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Que baru, “Bʉcʉcʉbe ʉ̃. Ʉ̃́re jẽniari jã́jara mʉja”, arejaimad̶a ina fariseovare ʉ̃i bʉcʉva. ");
INSERT INTO cubNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Bedióva cojedeca jã́ri eabecʉ bácʉre cutuicõjenejaimad̶a ina fariseova. Eayʉ bácʉre arejaimad̶a: —Mʉre mead̶ayʉ bácʉre majivʉ ñʉja, ãmeina teipõecʉ bajure. Que baru Jʉ̃menijicʉi jã́inore jãve coyʉjacʉ mʉ caride, arejaimad̶a jã́ri eabecʉ bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Ãmeina d̶ayʉre o mearore majibevʉ yʉ. Ʉbenita jã́ri eabecʉ batevʉ́ yʉ. Caride que ãmevʉ. Jã́ivʉ yʉ. No quénoratamu ji majino, arejamed̶a ina fariseovare jã́ri eabecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—¿Aipe d̶ari ʉ̃ mʉre? ¿Aipe d̶ayʉ, mʉre jã́re d̶ari ʉ̃? arĩ jẽniari jã́rejaimad̶a ʉ̃́re cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Mʉjare coyʉivʉ yʉ. ¿Jápiabenarʉ mʉja? ¿Ʉ̃i bueimara teiyʉrivʉrʉ̃ mʉja? Que barureca burubeda yʉre jẽniari jã́ivʉbu mʉja, arejamed̶a fariseovare. ");
INSERT INTO cubNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ʉ̃́re, yópe arĩ, ãmeina yávarejaimad̶a: —Mʉ́tamu ʉ̃i bueimʉ. Moisés bácʉi bueimaramu ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisés bácʉre yávarejaquemavʉ Jʉ̃menijicʉ. Aru Moisés bácʉre majivʉ ñʉja. Ʉbenita mʉre mead̶ayʉ bácʉre ye majibevʉbu ñʉja. ¿Ã́rocacʉba ʉ̃? arejaimad̶a ina fariseova. ");
INSERT INTO cubNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—“¿Ã́rocacʉba ʉ̃?” aivʉbu mʉja. Ʉbenita ji jã́ri eabe báquede mead̶aibi yʉre. Mʉjacapũravʉ ʉ̃i cʉrõ mácarõre majibevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Me majivʉ maja: Ãmeina teivʉre jápiabebi Jʉ̃menijicʉ. Quénora ʉ̃́re mearore jívʉre, ʉ̃i ʉrõpe d̶aivʉre, jápiaibi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jã́ri eabecʉre mead̶aiyede maja jápiabevʉbu. Yʉreca páyʉ nópe ãmepeda põeteyʉ bácʉre mead̶aipõecʉ cʉbebi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Yʉre mead̶ayʉ bácʉ Jʉ̃menijicʉi daroimʉ mácʉ ãmenu, ji jã́ri eabe báquede mead̶abejebu ʉ̃, ayʉbu yʉ mʉjare, arejamed̶a náre jã́ri eabecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—Mipacoi yapibʉrã põetecʉyʉvacari javeta ãmeina d̶ayʉ barejaquémavʉ mʉ. ¿Quécʉvacari ñʉjare bueyʉrʉ̃ mʉ? arejaimad̶a jã́ri eabecʉ bácʉre ina fariseova. Que arĩ, ʉ̃́re ne cójijiñamine jaetovarejaimad̶a ina fariseova, ʉ̃i cójijibequiyepe aivʉ náque bedióva cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jã́ri eabecʉ bácʉre ne jaetovaiye báquede coreóvarejaquemavʉ Jesús. Coreóvayʉ bácʉ, jã́ri eabecʉ bácʉre vocʉnʉrejame. Aru eayʉ bácʉ ʉ̃́re, yópe arĩ, jẽniari jã́rejame Jesús: —¿Mʉ Jʉ̃menijicʉi daroimʉ mácʉre ʉ̃mʉpe jʉ ayʉrʉ̃? arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—Mʉ, ji jabocʉ, mi aimʉre coreóvare d̶ajacʉ yʉre. Ʉ̃́re majicʉ, jʉ acʉyʉmu yʉ, arejame Jesúre jã́ri eabecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Jave jã́ivʉ mʉ ʉ̃́re. Ʉ̃́mu yʉ, mʉ́que boroteyʉ caride, arejame ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ʉ̃i que aiyeda, ñʉatutarĩ Jesúre mearore jídejame jã́ri eabecʉ bácʉ: —Mʉ, ji jabocʉ, mʉre jʉ aivʉ yʉ, arejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Dinʉmʉre yópe arĩ, coyʉrejame Jesús: —Ijãravʉi darejacacʉ yʉ, beocʉyʉ jʉ aivʉre aru jʉ abevʉre máre. Põeva “Majibevʉbu ñʉja Jʉ̃menijicʉi dápiaiye jãvene” aivʉ, jã́ri eabevʉpe paivʉbu. Nápe paivʉre mead̶acʉdayʉbu yʉ, ne majinajiyepe ayʉ Jʉ̃menijicʉi dápiaiye jãvene jã́ivʉpe. Ʉbenita põeva “Majidivʉbu ñʉja Jʉ̃menijicʉi dápiaiye jãvene” aivʉ, jã́ivʉpe barĩduyama, ne dápiaru. Nópe ne dápiaiye boje, náre mead̶abecʉbu yʉ. Que baru jã́ri eabevʉpe teni, Jʉ̃menijicʉi dápiaiye jãvene ye majibenama na, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesús que ayʉre jápiarejaima fariseovacavʉ. —Que baru, ¿“Jã́ri eabevʉpe paivʉbu mʉja”, ayʉrʉ̃ mʉ ñʉjare? arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús jʉ ayʉ yópe arejame náre: —Mʉja jã́ri eabevʉpe majibevʉ baru aru mʉja coreóvaivʉ baru Jʉ̃menijicʉi cad̶ateiyede jaʉrõre mʉjare, boropatebejebu mʉja. Ʉbenita “Majidivʉbu ñʉja Jʉ̃menijicʉi dápiaiye jãvene” aivʉ, jã́ivʉpe paivʉtamu mʉja. Ʉbenina dápiad̶avʉ̃ mʉja majini bʉojaivʉre Jʉ̃menijicʉi dápiaiye jãvene ʉ̃ cad̶atebecʉva mʉjare. Que baru boropateivʉ mauteivʉbu mʉja cãreja, arejame náre. ");
INSERT INTO cubNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Dinʉmʉre náre yópe arĩ, coyʉrejame Jesús: —Jãve coyʉyʉbu mʉjare: Ñai põecʉ ovejavare biaido jedevacobei ecobecʉ, quénora biaidore mʉrina ecoyʉ baru, ʉ̃́recabe ñavaipõecʉ o tatorĩ ĩ́põecʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ʉbenita ñai ecoyʉ ovejavare biaido jedevacobe bajita, ʉ̃́recabe ovejavare coreipõecʉ aru náre upacʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ʉ̃́recabe biaido jedevacobede coreipõecʉi voacaimʉ jedevacobede. Aru ovejavare órejarĩ daroibi ne ãmiá coapa náre coreipõecʉ. Ʉ̃i órejaiyede jápiarĩ, coreóvarĩ, dad̶ama ʉ̃i yebai. Aru náre nʉvaimi ʉ̃, ãocʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ovejavare etavayʉ bácʉ biaidore jocarĩ, náre jipocateibi. Aru ʉ̃i yóboi cujuyama na, ne coreóvaiye boje ʉ̃i yávainore. ");
INSERT INTO cubNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ʉbenita ne coreóvabemʉque nʉmema na, ʉ̃i órejaiyede. Ʉ̃́re dupivʉ cúyanʉrinata bíjad̶ama na ovejava, ne coreóvabe boje ʉ̃i yávaicamure, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","No jã́ri dápiarĩ ne d̶arãjiyepe ainore coyʉrĩdurejame náre Jesús. Ʉbenita ye jápiarĩ majibedejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Bedióva cojedeca põevare yávarejame Jesús: —Jãve coyʉyʉbu mʉjare: Ovejavai biaido jedevacobepe páyʉtamu yʉ, põeva ne earãjiyepe ayʉ Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ji edaquiye jipocare apevʉ, ovejavare coreipõevape teni, edaquemavʉ. Caivʉ na ñavacʉrivʉpe paivʉ aru tatorĩ ĩ́põevape paivʉ batequémavʉ. Ʉbenita náre jápiarĩ ad̶abetequemavʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jedevacobedeca páyʉtamu yʉ. Yópe ovejava jedevacobe biaidoi ne ecorĩ bʉojaiyepe náre coreipõecʉ, ʉ̃i mead̶aquiyepe aivʉ náre, nopedeca põeva yʉ́que earĩ bʉojaivʉbu Jʉ̃menijicʉre, ʉ̃i mead̶aquiyepe aivʉ náre. Ne ãmeina vaijʉroede mead̶acʉyʉmu yʉ. Yópe ovejava ecorĩ, etarĩ jedevacobei bʉoimara ãmevʉpe, nopedeca põeva yʉ́que cʉrivʉ jidʉbevʉ bʉoimarape ãmema. Yópe ovejava ne ãiyede eaiyepe náre coreipõecʉque, nopedeca ina yʉ́que cʉrivʉ náre apʉre d̶aiyede earĩ, ména cʉrãjarama na ne ũmei, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Náre, yópe arĩ, coyʉre nʉrejame Jesús: —Ñavaipõecʉ quénora ñavacʉdaibi aru põevare boarĩ́ jarʉvacʉdaibi, náre bíjarocʉyʉ. Ʉbenita yʉ́capũravʉ apʉre d̶acʉdaivʉ põevare mamaũmeque, ne cʉrãjiyepe ayʉ ʉrarõ meaũmeque cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ovejavare coreipõecʉ meacʉ me baju jã́ri capʉibi ʉ̃i ovejavare pʉ ʉ̃i yaiyeta náre boje. Quédeca tecʉyʉmu yʉ máre. Põevare mead̶acʉyʉ, yaicʉ́yʉmu náre boje. ");
INSERT INTO cubNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ʉbenita nópe d̶abebi ovejava upacʉre memecaipõecʉ. Ʉ̃ ovejavare coreipõecʉ ãmemi. Ʉ̃ jina ãmema na. Que baru ãimacʉ jijecʉcʉ, lobo ãmicʉcʉ, ʉ̃i edaiyede jã́ñʉ, cũiná cúyarĩ dupibi ovejava upacʉre memecaipõecʉ, ovejavare jocarĩ nʉñʉ. Que baru corebemarape ovejavare cujurĩ jaroibi ñai lobo. Cũinácʉre jẽniburu, apevʉ coateni nʉñama. ");
INSERT INTO cubNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ñai memecaipõecʉ jecʉbebi ovejavare. Quénora ʉ̃i jabocʉi bojed̶aiyeda ʉbi ʉ̃. Que baru ovejavare jocarĩ, dupini nʉimi ʉ̃, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Náre, yópe arĩ, coyʉre nʉrejame Jesús: —Yʉ mearo coreyʉbu põevare yópe ovejavare coreipõecʉ meacʉi coreiyepe ovejavare. Jipacʉ coreóvaibi yʉre. Aru coreóvaivʉ yʉ ʉ̃́re máre. Quédeca coreóvaivʉ yʉ ji cʉvamara coapa. Aru yʉre coreóvama na máre. Yʉrecabu mead̶acʉyʉ põevare. Que baru yaicʉ́yʉmu náre boje. ");
INSERT INTO cubNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yópe apedoa biaidoacavʉ ovejavai cʉepe, nopedeca apevʉ põeva, yócavʉ ãmema, ʉbenita jína márajivʉ cʉma nore máre. Náre cuturĩ, jipocateni davacʉyʉmu yʉ. Ji cutuiyede jápiarĩ jʉ arãjarama na. Náre epecʉyʉmu jívʉque cũinávʉpe. Na caivʉ cʉrãjarama yʉ́que. Aru náre corecʉyʉmu yʉ. Que teni cũináyajubope teni, yʉ ne coreipõecʉ cũinácʉque cʉrãjarama caivʉ ina jívʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Náre coyʉre nʉrejame Jesús: —Ji mauvare boarĩ́ jarʉvaicõjeiyʉvʉ yʉ ji bajure, nacajari yainore jarʉvarĩ cʉcʉyʉ bedióva cojedeca. Que baru ʉbi yʉre jipacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Põecʉ cʉbebi yʉre boarĩ́ jarʉvacʉyʉ ji ʉbedu. Ji mauvare boarĩ́ jarʉvaicõjecʉyʉmu. Yʉ bʉojaivʉ boarĩ́ jarʉvaicõjeñʉ ji bajure aru nacajari cʉcʉyʉ bedióva cojedeca máre. Que d̶aicõjeimi yʉre jipacʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Que ayʉre jápiarĩ, ina judíova cũinátʉrʉ ãmevʉ cojedeca ne ũme, cũinátʉrʉra yávabema Jesúrã. ");
INSERT INTO cubNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Abujucʉ cʉbi ʉ̃́que. Que baru ãrʉmemi. ¿Aipe teni ʉ̃i coyʉiyede jápiaivʉrʉ̃ mʉja? arejaima nácavʉ obedivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ʉbenita apevʉ nácavʉ arejaima: —Abujucʉre cʉvacʉ nópe yávayʉ bʉojabebi. Aru jã́ri eabecʉre mead̶aiye bʉojabebi abujucʉ. ¿Mʉ́carĩ? arejaima ina judíova. ");
INSERT INTO cubNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Dinʉmʉre ʉracoro ocorʉ̃mʉ marejávʉ̃. Aru Jerusalén ãmicʉriĩmaroi torojʉve teinʉmʉ marejávʉ̃. Jʉ̃menijicʉi cʉ̃ramine mead̶aiye báquede ãrʉrivʉ, torojʉrejacarã ñʉja judíova. ");
INSERT INTO cubNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nore Jʉ̃menijicʉi cʉ̃rami Salomón mácʉi cuino mácarõ ãmicʉrõi vaiváre nʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nópe vaiváre nʉñʉre tarabʉd̶arĩ ʉ̃́re, jẽniari jã́rejaima judíovacavʉ: —Mʉre ʉrarõ chĩod̶avʉ ñʉja. ¿Yécʉrʉ̃ mʉ? Cristo, Jʉ̃menijicʉi daroimʉ mácʉ baru mʉ, cũiná coyʉjacʉ ñʉjare. Coreni ʉetʉyavʉ̃ ñʉja, arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Náre, yópe arĩ, coyʉrejame Jesús: —Jave coyʉrĩduvʉ mʉjare. Ʉbenita ji coyʉiyede jʉ abetevʉ mʉja. Mʉje jã́iyede põeva ne d̶arĩ majibede jipacʉi cõjeiye bajure d̶avʉ yʉ. Ʉbenita diede jã́ivʉvacari, yʉ Cristore jʉ abevʉ mʉja cãreja. Yʉ, Cristo, jã́d̶ovaivʉ jãve ji d̶aiyeque. ");
INSERT INTO cubNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ʉbenita mʉjacapũravʉ ji ovejavape paivʉcavʉ ãmevʉ. Ji põeva ãmevʉtamu mʉja. Que baru ji coyʉiyede jʉ abevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yópe ovejava ne jápiarĩ, jʉ arĩ d̶aiyepe náre coreipõecʉ bajui ʉrõpe, nopedeca ji põeva yʉre jápiarĩ, jʉ arĩ d̶aivʉbu yópe ji ʉrõpe. Jívʉre me coreóvaivʉ yʉ. Yʉre jápiarĩ, jʉ arĩ cʉma yʉ́que. ");
INSERT INTO cubNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Náre jãravʉ cũiméjãravʉ baquinóre cʉvare d̶aivʉ yʉ. Toabo cũiméboi nʉmenajarama na cainʉmʉa. Ji coreimarare yʉre tatojʉrocʉ cʉbebi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉre jipacʉi jímara bojecʉrivʉbu caiye pʉeno. Jipacʉre tatojʉrocʉ náre cʉbebi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉ jipacʉmaque cũinávʉpebu ñʉja, arejame Jesús ina judíovare. ");
INSERT INTO cubNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ʉ̃i que aiyede, Jesúre jorojĩvʉ ina judíova, boaiyʉrivʉ ʉ̃́re, ĩnejaima cʉ̃raboare cojedeca, dʉvarãjivʉ ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ʉbenita Jesúcapũravʉ arejame: —Jipacʉi ʉre d̶aicõjeiyede põeva ne d̶arĩ majibede jã́d̶ovavʉ yʉ, cad̶atecʉyʉ põevare. ¿Caiye die mʉje jã́iye báquede, ád̶e boje cʉ̃raboare dʉvarãjivʉrʉ̃ yʉre? arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jesúre arejaima na: —Mi d̶aiyede jã́ivʉ bácavʉ cʉ̃raboaque dʉreni, mʉre boabénamu ñʉja. Ʉbenita “Jʉ̃menijicʉque cũinávʉpebu ñʉja”, avʉra mʉ. Jʉ̃menijicʉre ãmeina yávaivʉ mʉ, que ayʉ. Quénora põecʉratamu mʉ. Que baru Jʉ̃menijicʉre mi ãmeina yávaiye boje, mʉre boarã́jaramu ñʉja, arejaima Jesúre ina judíova. ");
INSERT INTO cubNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Náre, yópe arĩ, coyʉrejame Jesús: —Mʉjeñecuva mácavʉ ne toivarĩ epeiyoca cãriáiyocai yópe arĩ, toivaicõjenejaquemavʉ Jʉ̃menijicʉ ʉ̃i yávaiyede: “Jʉ̃menijinape paivʉbu mʉja”, arejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Me coreóvaivʉbu maja Jʉ̃menijicʉi yávaiye ʉ̃i toivaicõjeiye báque jãve bajure cainʉmʉa. Ʉ̃i yávaino mácarõre oatʉvaino cʉbevʉ no. Aru Jʉ̃menijicʉvacari, “Jʉ̃menijinape paivʉbu mʉja”, arejaquemavʉ ina javecavʉ ʉ̃i yávaiyede coyʉimara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","’Yʉrecabu Jʉ̃menijicʉi beoimʉ mácʉ, memecacʉyʉ ʉ̃́re. Yʉre darorĩ epeibi ijãravʉi. Que baru, ¿“Jʉ̃menijicʉi mácʉbu yʉ” ji aiyede, aipe teni yʉre “Jʉ̃menijicʉre ãmeina yávaivʉ mʉ”, aivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Jipacʉi d̶aicõjeiyede ji d̶abedu, yʉre jʉ abejarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ʉbenita põeva ne d̶arĩ majibede jipacʉi d̶aicõjeiyede ji d̶aru, nópe d̶ayʉre mʉje jã́ri coreóvaiye boje, jʉ ajarã mʉja. Yʉre jʉ abevʉreca, ji d̶aiyede jʉ aiye jaʉvʉ mʉjare, mʉje cũiná majinajiyepe ayʉ jãve jipacʉ cʉcʉre yʉ́que aru yʉ cʉcʉre ʉ̃́que máre cũinávʉpe, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bedióva cojedeca Jesúre jẽni jacoiyʉrĩdurejaima na. Ʉbenita náre dupidejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Náre dupiyʉ bácʉ Jordán ãmicʉriya jia ãnidʉvei, Juan Bautista bácʉ ʉ̃i põevare Jʉ̃menijicʉque ocoi jã́d̶ovaino mácarõ yebai nʉrejame Jesús cojedeca. Noi cʉcʉnʉñʉ, ʉ̃́que nʉrejacarã ñʉja ʉ̃i bueimara. ");
INSERT INTO cubNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nore ñʉje cʉede põeva obedivʉ Jesúre jã́radarejaima. Ne bajumia yópe arĩ, borotedejaima: —Põeva ne d̶arĩ majibede d̶abeteame Juan Bautista bácʉ. Ʉbenita caino ʉ̃i coyʉino mácarõ Jesúi borore jãve baju batequémavʉ, arejaima ina Jesúre jã́radaivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aru nore cʉcʉre, Jesúre jʉ arejaima obedivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dinʉmʉre cũinácʉ ʉ̃mʉ ʉ̃i ãmiá Lázaro ijeteyʉ barejámed̶a. Jíbʉrõmivaque Betania ãmicʉriĩmajinoi cʉrejame ʉ̃. Marta aru María ãmicʉrejaima na, jíbʉrõmiva. ");
INSERT INTO cubNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ico María Lázaroi mamico barejácod̶a Jesúre mumijʉe yuad̶o bacod̶ó ʉ̃i cʉbobare aru õi yuarĩburu yóboi õi pod̶aque tʉ̃red̶o macod̶ó máre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jesúre boro jarorejaimad̶a na, Lázaroi maminomiva: —Ñʉje jabocʉ, mi yóvaimʉ, pare mi jecʉvamʉ, ijeteibi ʉ̃, arĩ boro jarorejaimad̶a Jesúre dinomiva. ");
INSERT INTO cubNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ne que aino mácarõre jápiayʉ bácʉ, yópe arejame Jesús: —Ijeteyʉvacari yaibécʉbe Lázaro. Quénora Jʉ̃menijicʉi parʉéde jã́d̶ovaquiyepe ayʉ põevare ijeteibi ʉ̃. Ʉ̃i ijeteiye boje põeva jã́rajarama yʉ, Jʉ̃menijicʉi mácʉ, ji parʉéde, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Martare, Maríare, aru néyocʉ Lázarore pare jecʉrejaquemavʉ Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ijimʉre jápiayʉ bácʉvacari, nomicata pʉcajãravʉa mautedejame cãreja. ");
INSERT INTO cubNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pʉcajãravʉa yóboi, Jesús arejame ñʉjare ʉ̃i bueimarare: —Jã́rica, Judeai nʉrajarevʉ maja cojedeca, arejame ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Mʉ, bueipõecʉ, javejĩeneca cʉ̃raboaque dʉreni, mʉre boajʉrorivʉ batemá nócavʉ. ¿Nore nʉcʉyʉrʉ̃ mʉ cojedeca? arejacarã Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","“Ji d̶ájʉroede bʉojajebu yʉ” ayʉ, yópe arĩ coyʉrejame Jesús: —Jãravʉa coapa doce paiora cʉvʉ. Ñai cuyʉ jãravʉre, aviá ʉ̃i boiyede, tobebi ʉ̃, aviá ʉ̃i boino cʉe boje jãravʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ʉbenita ñai cuyʉ ñamine, torĩ yavaibi ʉ̃, aviá ʉ̃i miad̶áre d̶aino cʉbe boje, arejame Jesús. Que ayʉre Jesús, yópe aiyʉrõ marejaquémavʉ: Jãravʉa cʉrejaquemavʉ ʉ̃́re cãreja, ʉ̃i bʉojaquiyepe ayʉ ʉ̃́re d̶aiye jaʉrõre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Que coyʉrĩburu yójĩboi, yópe arĩ coyʉrejame Jesús cojedeca: —Maje yóvaimʉ Lázaro cãñʉme. Ʉ̃́re coedavacʉnʉñʉmu yʉ, arejame ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Mʉ, ñʉje jabocʉ, jãve cãru, dinʉmʉ meaquiyebu. Meatecʉyʉme, arejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús ʉ̃i nópe aiyede majibedejacarã ñʉja. Ʉbenita “Cãñʉmebu”, arĩ dápiarejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ñʉje que dápiaiyede, yópe arejame Jesús yavebecʉva: —Jave yaicʉ́be Lázaro bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ji cʉbe báque boje ʉ̃́que, torojʉvʉ yʉ. Caride yʉre me baju coreóvarĩ jʉ arãjaramu mʉja, ji d̶aquiyede jã́ivʉ. Jã́rica, Lázaro bácʉ yebai nʉrajarevʉ maja, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ñʉjacacʉ Tomás, pẽjacʉ ñʉje aimʉ, arejame ñʉjare: —Jã́rica, Jesúque yainánʉrajarevʉ maja máre, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jã́ranʉrejacarã ñʉja, Jesújã. Earãnʉivʉ bajure Lázaro bácʉi yaino mácarõre coyʉrãdarejaima nócavʉ. Javeta Jesús ʉ̃i eaquiye jipocamia, yóvaicʉvaijãravʉa jipocamiata, ʉ̃ mácʉre jarʉvarejaimad̶a cʉ̃racobei, põe jarʉvaicobei. ");
INSERT INTO cubNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lázaro bácʉi cʉriĩmaro, Betania ãmicʉriĩmajino, joabejĩnoi yóbecʉrikilometros baji cʉrejavʉ̃ Jerusalén ãmicʉriĩmaro. ");
INSERT INTO cubNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Que baru Martare aru Maríare máre, yaiyʉ́ bácʉi maminomivare, jã́ranʉrejaimad̶a Jerusalẽ́cavʉ judíova obedivʉ. Na chĩoivʉque orãnʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús edayʉre majini, ʉ̃́re copʉ darejaco Marta. Ʉbenita Maríacapũravʉ dabedejaco. Quédata cʉ̃ramimia cʉrejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesúre copʉyo, yópe arejaco Marta: —Mʉ, ji jabocʉ, yui mi cʉru, jíyocʉ bácʉ yaibéjebu. ");
INSERT INTO cubNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ʉbenita coreóvaivʉ yʉ Jʉ̃menijicʉ d̶ayʉre caiyede yópe mi jẽniaiyepe ʉ̃́re, arejaco Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Míyocʉ bácʉ nacajacʉyʉme yainore jarʉvarĩ, arejame Martare. ");
INSERT INTO cubNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Jãvemu no. Nore majivʉ yʉ. Jãravʉ cũiyeta, nacajacʉyʉme jíyocʉ bácʉ yainore jarʉvarĩ, arejaco õ cojedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Dinʉmʉre Jesús arejame: —Yʉ́bu yaivʉ bácavʉre nacovañʉ yainore jarʉvarĩ. Jãve yaivʉ bácavʉre cainʉmʉa cʉre d̶ayʉbu yʉ. Põecʉ yaiyʉ́ bácʉvacari, yʉre jʉ ayʉ bácʉ baru, bedióva cojedeca apʉcʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yʉre jʉ ayʉ, ji nacovaquimʉ, apʉcʉyʉme cainʉmʉa. Ye nʉmecʉyʉme toabo cũiméboi. ¿Iye ji coyʉiyede jʉ ad̶orʉ̃ mʉ? arejame Martare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aru arejaco: —Mʉ, ji jabocʉ, jʉ aivʉ yʉ. Mʉ Cristobu, Jʉ̃menijicʉi mácʉ baju. Jʉ̃menijicʉ ʉ̃i epeimʉ mácʉ yore ʉ̃i daroimʉ mácʉbu mʉ, arejaco Jesúre Marta. ");
INSERT INTO cubNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ʉ̃́re que ad̶o báco copainʉri, ĩmacore, Maríare, cutuconʉrejaco Marta. Yavenijiena cuturejacod̶a Maríare, apevʉ ne jápiabenajiyepe ad̶o: —Bueipõecʉ dare daibi. “Dajacorĩ”, aibi mʉre, arejacod̶a Maríare Marta. ");
INSERT INTO cubNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jʉ arĩ, cũiná nacajari, Jesús yebai copʉ nʉrejacod̶a María. ");
INSERT INTO cubNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ĩmaro bajure eabedejacarã ñʉja cãreja. Martare ñʉje copʉino mácarõmiata cʉrejacarã cãreja. ");
INSERT INTO cubNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jũjujiena nʉñore jã́ivʉ, Maríare yóvarãdarejaima ina judíova. Ṍque orãdaivʉ barĩdurejaimad̶a. “Yaiyʉ́ bácʉre ne jarʉvaino mácarõi oconʉñome õ”, arĩ dápiarĩdurejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María ñʉje yebai edarĩna, Jesús yebamiata ñʉatutarĩ, arejaco ʉ̃́re: —Mʉ, ji jabocʉ, yui mi cʉru, jíyocʉ bácʉ yaibéjebu ʉ̃, arejaco Jesúre María. ");
INSERT INTO cubNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María od̶ore jã́ñʉ, aru ṍque edaivʉ oivʉre jã́ñʉ, ṍre cõmaje ãroje jã́ri, ʉrarõ chĩorejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—¿Ã́ri yaiyʉ́ bácʉre jarʉvarãrʉ mʉja? arejame Jesús. —Mʉ, ñʉje jabocʉ, jã́cʉdajacʉ, arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Dinʉmʉ orejame Jesús máre. ");
INSERT INTO cubNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—Ʉrarõ yaiyʉ́ bácʉre ʉ́teame Jesús, arejaima ne bajumia ʉ̃́re jã́ivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Apevʉ nácavʉ arejaima: —Jã́ri eabecʉre mead̶ame Jesús. ¿Aipe teni Lázaro bácʉre mead̶abetedi ʉ̃, ʉ̃i yaibéquiyepe ayʉ? arejaima na, ne bajumia yávaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yaiyʉ́ bácʉre jarʉvaino mácarõre eare nʉiye bajure bedióva cojedeca orejame Jesús, pare chĩoñʉ. Que teni ʉ̃ mácʉre ne jarʉvaino mácarõre earejacarã ñʉja, Jesúque daivʉ. Cʉ̃racobe, cainitʉravaque ne bieicobe barejávʉ̃ Lázaro bácʉre ne jajuidorĩ ad̶aicobe bácarõ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Cainitʉravare veojarã mʉja, arejame náre Jesús. —Mʉ, ji jabocʉ, yóvaicʉvaijãravʉa vaivʉ yaiyʉ́ bácʉre ñʉje jarʉvarĩburu yóbo. Javeta ʉ̃rojʉcʉbe ʉ̃ mácʉ, arejaco Jesúre Marta, yaiyʉ́ bácʉi mamico. ");
INSERT INTO cubNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Javede coyʉvʉ mʉre. Mʉ yʉre jʉ ad̶o baru, yʉre Jʉ̃menijicʉi parʉéde cʉvacʉre jã́cod̶omu mʉ, avʉ yʉ mʉre, arejame Martare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Dinʉmʉ dicobede bieitʉravare veorĩ ĩnejaima apevʉ. Ne que d̶arĩburu yóboi, nore núcʉ, cavarõi jã́ñʉ, arejame Jesús: —Mʉ, jipacʉ, yʉre jápiaivʉ mʉ cainʉmʉa. Que baru mʉre torojʉede jívʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yʉ me coreóvaivʉ jápiayʉre yʉre cainʉmʉa. Ʉbenita yore yʉ́que cʉrivʉ ne majinajiyepe ayʉ, mʉre que aivʉ yʉ. Ne “Jʉ̃menijicʉi daroimʉ mácʉbe Jesús”, ne arãjiyepe ayʉ, nópe mʉre yávaivʉ yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jípacʉque yávayʉ bácʉ cod̶oboborĩ, órejarejame Jesús: —Lázaro, etarĩ dajacʉ mʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jesús ʉ̃i que aiyedata, etarĩ darejame ʉ̃ yaiyʉ́ bácʉ. Cuitótecajeaque ʉ̃i cʉboba, ʉ̃i pʉrʉá, aru ʉ̃i jipobʉ máre, caicʉ ne cũmaimʉ mácʉ, Lázaro etarĩ darejame. —Cuitótecajea ʉ̃́re cũmaicajeare jod̶eni jarʉvajarã mʉja, cʉ̃rami ʉ̃i copaiquiyepe aivʉ, arejame náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Obedivʉ ina Maríaque yaiyʉ́ bácʉre orãdaivʉ bácavʉcavʉ, Jesúre nópe d̶ayʉre jã́ivʉ bácavʉ, ʉ̃́re jʉ arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ʉbenita fariseovacavʉre coyʉrãearejaimad̶a apevʉ. Caiye Jesús ʉ̃i d̶aiye báquede náre coyʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","48","Que teni sacerdotevare jaboteipõevaque cójijidejaimad̶a ñʉja judíova ñʉje jabova, ina fariseova. Aru arejaimad̶a, ne bajumia boroteivʉ: —Põeva ne d̶arĩ majibede ʉre d̶aibi Jesús. Que d̶ayʉ, parʉcʉ nʉñʉme ʉ̃. Jesúre nópe ñʉje d̶are nʉicõjenu, caivʉ põeva ʉ̃́que nʉjebu. Ʉ̃́que põeva ne nʉru, meamejebu majare. Ʉ̃́re jʉ arĩ, jabojacoiyʉma. Aru ne jabojacoru ʉ̃́re, majare boarã́daicõjejebu churaravare ina Romacavʉ, maje jabova baju. Jesúre jabojacojʉrorivʉre jã́ivʉ baru, Romacavʉi jabocʉre vainí tʉivʉpe majare jã́jebu nócavʉ. Dinʉmʉita maje Jʉ̃menijicʉi cʉ̃ramine vaivéni jarʉvarĩ, maje joborõre máre tatorĩ ĩjebu ina Romacavʉ. Que baru, ¿aipe d̶arãjidica maja? arejaimad̶a ñʉje jabova. ");
INSERT INTO cubNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ʉbenita cũinácʉ nácacʉ ʉ̃i ãmiá Caifás, sacerdotevai jabocʉ baju diʉjʉre, arejamed̶a: —Mʉja, jívʉ, jápiajarã. Majibevʉ mʉja nópe yávaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Coreóvabenarʉ mʉja? Cũinácʉva yaidú, majare meavʉ. Que teni caivʉ yainí bíjabejebu maja, arejamed̶a jabovare Caifás. ");
INSERT INTO cubNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ʉ̃ cũinácʉ nópe abedejaquemavʉ Caifás. Sacerdotevai jabocʉ baju boje, ʉ̃́re nópe are d̶arejaquemavʉ Jʉ̃menijicʉ, Jesús ʉ̃i yaiquíyede judíovare boje coyʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ʉbenita náre quévʉ bojeda yaicʉ́yʉ ãmenejame Jesús. Quénora cainoa joborõacavʉre boje máre, yaicʉ́yʉ barejáme Jesús, obedivʉ Jʉ̃menijicʉi mára márajivʉre cũináyajubope d̶acʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Sacerdotevare jaboteipõeva aru fariseova máre, “Dinʉmʉ Jesúre boarĩ́ jarʉvarãjarevʉ maja”, arĩ bʉ́rejaimad̶a na dijãravʉ, Caifás ʉ̃i nópe coyʉijãravʉmia. ");
INSERT INTO cubNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nore majicʉ Jesús, ʉraĩmaroai cubedejame. Judeacavʉre dupini nʉñʉ, ne joborõre jocarĩ, põecʉbenoi nʉrejame Jesús. Ñʉjare ʉ̃i bueimarare máre nʉvari, Efraín ãmicʉriĩmajinoi curãnʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ñʉja judíova ñʉje torojʉve teijãravʉ, Pascua ãmicʉrijãravʉ baquinó eare nʉino marejávʉ̃. Que baru Jerusalén ãmicʉriĩmaroi obedivʉ põeva, cainoa ĩmaroacavʉ, mʉri nʉrejaima na, d̶arãjivʉ ne torojʉve tenajiye jipocai yópe Jʉ̃menijicʉi d̶aicõjeiyepe ʉ̃i coyʉiye báquede Moisés bácʉre, meara márajivʉ Jʉ̃menijicʉi jã́inore. ");
INSERT INTO cubNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Que teivʉ, Jesúre vore cuivʉ barejáimad̶a ina põeva. Cójijivʉ Jʉ̃menijicʉi cʉ̃rami, ne bajumia boroteivʉ jẽniari jã́rejaimad̶a: —¿Mʉje dápiaru, Jesús máre edaquidica ʉ̃? arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jipocamia ina sacerdotevare jaboteipõeva aru ina fariseova máre caivʉre, yópe arĩ, coyʉicõjenejaimad̶a: —Jesúi cʉrõre majidivʉ baru, cũiná ñʉjare coyʉrãdajarã mʉja, ñʉje jẽni jacorãjiyepe aivʉ ʉ̃́re, arejaimad̶a ñʉje jabova. ");
INSERT INTO cubNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis paijãravʉa Pascua ãmicʉrijãravʉ jipocai, Betania ãmicʉriĩmajinoi nʉrejacarã ñʉja Jesúque cojedeca. Lázaro, yaiyʉ́ bácʉre Jesúi nacovaimʉ mácʉi cʉriĩmaroi nʉrejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ñʉja edaivʉre ʉrarõ ãiye tʉorejaima apevʉ nócavʉ, pued̶arãjivʉ Jesúre. Ãiyede tʉod̶o barejáco Marta. Aru Lázaro máre cʉrejame tʉoiva yebai apevʉ dobarivʉque. ");
INSERT INTO cubNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ãñʉre, María davarejaco trescientos paigramos baju mumijʉricorore Jesús yebai. Iye mumijʉe nardo ãmicʉe pare mearo corajʉe barejávʉ̃. Aru pare bojecʉe barejávʉ̃ya máre. Die mumijʉricorore yuarejaco Jesúi cʉbobarã. Yuad̶o báco, õi pod̶aque tʉ̃renejaco Jesúi cʉbobare. Aru caiñami cʉ̃ramine mumijʉrejavʉ̃ die. ");
INSERT INTO cubNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Dinʉmʉre jararejame Judas Iscariote, ñʉja Jesúi bueimaracacʉ, ʉ̃́re jẽne d̶acʉyʉ. Ṍre jararĩ, yópe arejame ʉ̃: ");
INSERT INTO cubNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Iye õi jarʉvaicorore, aipe teni apevʉre bojed̶abetedi õ? Tãutʉra ʉrarõ, trescientos paijãravʉare memeiye boje jíye jaʉrĩdurebu ṍre. Diede boje ĩni, cʉve cʉvabevʉre cad̶atejebu maja, arejame Judas. ");
INSERT INTO cubNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ʉbenina que ayʉ barejáme Judas. Cʉve cʉvabevʉre cõmaje ãroje jã́ñʉ ãmenejame, que ayʉ. Quénora ñavacʉcʉ barejáme. Ʉ̃ marejáme ñʉjare tãutʉra nʉvacaipõecʉ. Iyede ñʉje tãutʉra corecayʉ, ʉ̃i ʉrõmia ĩni, ñʉje tãutʉrare ñavavarejaquemavʉ ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ʉbenita Jesús arejame: —Ãmeno yávabejacʉ ṍre. Õ que d̶aibico, mead̶acod̶o ji bajure ne jarʉvarãjiyede cʉ̃racobeita. ");
INSERT INTO cubNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Cainʉmʉa ina cʉve cʉvabevʉ cʉrãjarama mʉjaque. Ʉbenita yʉ cʉbecʉbu mʉjaque cainʉmʉa, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dinʉmʉre Jesús Betania ãmicʉriĩmajinoi ʉ̃i cʉede boro jápiarejaimad̶a obedivʉ judíovacavʉ. Que baru Jesúre jã́radarejaima, aru Lázarore máre, Jesúi nacovaimʉ mácʉre yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lázarore máre boarĩ́ jarʉvaiyʉrejaimad̶a ina sacerdotevare jaboteipõeva. ");
INSERT INTO cubNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Náre jocarĩ nʉrejaima obedivʉ judíovacavʉ, Jesúre jʉ arãjivʉ ʉ̃i nacovaiye báque boje Lázarore yainore jarʉvarĩ. Que baru Lázarore máre boarĩ́ jarʉvaiyʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Apejãravʉ, Lázaroque Jesús ʉ̃i ãijãravʉ bácarõ yóbocajãravʉi, Jesús Jerusalẽ́i ʉ̃i edaquiyede jápiarejaquemavʉ na, Pascua torojʉve teijãravʉre jã́radaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Diede jápiarĩ, yapoporʉare burarĩ ĩni, ñʉja Jesújãre copʉ darejaima obedivʉ põeva. “Jʉ̃menijicʉre torojʉe bajad̶éni. Jʉ̃menijicʉi mearo d̶acaimʉme ʉ̃i daroimʉ mácʉ, maja judíova maje jabocʉ bacʉyʉ́”, arĩ cod̶oboborejaima ina judíova Jesúque nʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Põevare ũmaiãimacʉ, burro ãmicʉcʉre earĩ, ʉ̃́re tubarĩ nʉrejame Jesús. Nópe teyʉ, yópe Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquepe, teyʉ barejáme Jesús: ");
INSERT INTO cubNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mʉja Jerusalén ãmicʉriĩmarocavʉ, jidʉbejarã mʉja. Jã́jara mʉje jabocʉ bacʉyʉ́ dacʉyʉre, burrojĩcʉrã tubarĩ dacʉyʉre, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Que teinore majibedejacarã ñʉja Jesúi bueimara. Ʉbenita ʉ̃i yainí, nacajari, aru mʉri nʉriburu yóboi cavarõ mearo Jʉ̃menijicʉi cʉrõi, ãrʉrejacarã ñʉja. Dinʉmʉ maquinó “Jʉ̃menijicʉi toivaicõjeino mácarõpedeca Jesúre tequemavʉ maja, maje mearore jíyede ʉ̃́re burrojĩcʉrã tubarĩ dayʉre”, arãjivʉ barejacárã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ina põeva, Jesúque cʉrivʉ bácavʉ ʉ̃i órejaiye báquede Lázarore ʉ̃i etaquiyepe ayʉ cʉ̃racobede jocarĩ apʉcʉ cojedeca, coyʉre cuivʉ barejáimad̶a iye ne jã́iye báquede. ");
INSERT INTO cubNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ne nópe coyʉiye boje no Jesúi jã́d̶ovaino mácarõre põeva ne d̶arĩ majibede, Jesúre copʉrãdarejaima caivʉ ina obedivʉ põeva. ");
INSERT INTO cubNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Que baru ina fariseova ne bajumia arejaimad̶a: —Coyʉrĩ oabevʉ maja. Majare jápiabema ina põeva. Quédata Jesúque yóvarãnʉñama caivʉ, arejaimad̶a na, ne bajumia yávaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Apevʉ judíova ãmevʉ, Jʉ̃menijicʉre mearore jívaivʉ, ina obedivʉ põeva jẽneboi Jʉ̃menijicʉre mearore jínanʉrejaimad̶a Jerusalén ãmicʉriĩmaroita Pascua torojʉve teinʉmʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Na Felipede borotenanʉrejaimad̶a. Galilea ãmicʉrijoborõcarõ ĩmaro Betsaida ãmicʉriĩmarocacʉ barejáme Felipe. —Jesúque boroteiyʉrĩduivʉbu ñʉja, arejaimad̶a Felipede. ");
INSERT INTO cubNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Andrés yebai nʉri, coyʉrejamed̶a Felipe ne borore. No yóboi, ina pʉcarã nʉri, coyʉrãearejaimad̶a Jesúre ina judíova ãmevʉ ne borore. ");
INSERT INTO cubNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yópe arĩ, coyʉrejame ñʉjare Jesús: —Dijãravʉ ji ávaijãravʉ eaivʉ. Caride jipacʉ Jʉ̃menijicʉ jã́d̶ovacʉyʉme yʉre, ʉ̃i daroimʉ mácʉre ʉ̃mʉpe, meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jãve coyʉyʉbu mʉjare: Jaʉvʉ yʉre ji yaiquínore. Jẽvari coyʉrĩ coyʉquijivʉ. Yópe cũináyabe oteiyabede maje otebedu, quénora cũinárora mauteinomu no. Ʉbenita iyabe oteiyabede maje otedu, joborõ jívʉi cʉede cãreja, yainope teni, pĩarí cũpururi nʉiyavʉ. Nopedeca ji yaidú, obedivʉ põeva mamaũme cʉrivʉ bʉojarãjarama, ji yaiye boje. ");
INSERT INTO cubNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ñai põecʉ ʉ̃i baju jecʉcʉ baru, bíjacʉyʉme ʉ̃. Ʉbenita ñai põecʉ jecʉbecʉ baru ʉ̃i baju ijãravʉre, jãravʉ cũiméjãravʉ baquinóre cʉvacʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ácʉ põecʉ yʉre memecaiyʉcʉ baru, yʉre ʉ̃i jʉ aiye jaʉvʉ ʉ̃́re. Que baru yʉ́que ji cʉrõi cʉcʉyʉme ʉ̃. Aru ácʉ põecʉ yʉre memecaru, ʉ̃́re pued̶acʉyʉme jipacʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Náre coyʉre nʉrejame Jesús: —Caride ʉrarõ chĩoivʉ yʉ ji ũmei. ¿Aipe ajeba yʉ jipacʉre? ¿Yʉre ñájino vaijárõri no, ajeba yʉ jipacʉre? Abevʉ yʉ nópe. Ñájinore vaicʉ́yʉ darejacacʉ yʉ ijãravʉi, arejame Jesús ñʉjare, ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ñʉjare nópe coyʉrĩ bʉojarĩ, arejame jípacʉre Jesús: —Mʉ, jipacʉ, põevare jã́d̶ovajacʉ mi baju meacʉ bajure, arejame jípacʉre. Dinʉmʉma cavarõ mearo Jʉ̃menijicʉi cʉrõre jocarĩ yávarĩ darorejavʉ̃: “Meavʉ mi que aino. Que d̶acacʉ javeta. Aru que d̶acʉyʉmu yʉ cojedeca”, arejavʉ̃ no yávarĩ daroino. ");
INSERT INTO cubNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ina obedivʉ põeva ñʉjaque cʉrivʉ no bʉjinore jápiarejaima. —Õpo tʉinomebu, arejaima nácavʉ. —Que ãmevʉ. Cũinácʉ ángele yávarĩ daroyʉbebu ʉ̃́re, arejaima apevʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ʉbenita Jesús arejame: —No yávarĩ daroino yʉre boje ãmevʉ. Quénora mʉjare bojetamu no yávarĩ daroino. ");
INSERT INTO cubNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Caride ijãravʉcavʉre ne ãmene jã́d̶ovari, coreóvare d̶acʉyʉme Jʉ̃menijicʉ caivʉ yʉre jʉ abevʉ ñájinajivʉre cũinájãravʉ. Caride ijãravʉcavʉ ne jabocʉre, ñai abujuvai jabocʉre, jarʉvacʉyʉme Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ʉbenita yʉ ne jocʉcʉrã pẽvari jẽori jãmʉórajimʉ, yʉrecabu obedivʉ põevare jʉ are d̶acʉyʉ yʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nópe arĩ coyʉyʉ, aipe ãrojae teni ʉ̃i yaiquínore coyʉyʉ barejáme Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ʉ̃i que aiyede, yópe arejaima ʉ̃́re jápiaivʉ: —Jʉ̃menijicʉ ʉ̃i yávaiyede toivaicõjenejaquemavʉ, ñʉje majinajiyepe ayʉ ʉ̃i daroquimʉre yaibécʉ bacʉyʉ́re cainʉmʉa. ¿Aipe teni “Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ne jocʉcʉrã pẽvari jẽori jãmʉóimʉ macʉyʉ́mu yʉ”, ayʉrʉ̃ mʉ? ¿Yécʉ páyʉrʉ̃ mʉ? ¿Ñamema Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe? arejaima Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Náre yávarejame cojedeca Jesús: —Ñai cucʉnʉiyʉcʉre jãravʉre, aviá ʉ̃i boiyede, cuiye jaʉvʉ ʉ̃́re. Que baru ñemié tʉiyede, majibebi ã́ri ʉ̃i nʉinore. Quédeca quĩ́jino baju cʉcʉyʉmu yʉ mʉjaque pẽoipõecʉpe, jã́d̶ovañʉ Jʉ̃menijicʉi jãvene. Mʉjare majide d̶aivʉ Jʉ̃menijicʉi dápiaiye jãvene ji bueiyeque. Que baru mʉja diede majibevʉ baru caride, ji cʉede mʉje jẽneboi cãreja, ji nʉriburu yóbore apa ñeminoi cuivʉpe paivʉ barãjáramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Que baru ji cʉepe cãreja mʉje jẽneboi, ji bueiyede jʉ ajarã mʉja. Yʉ́cavʉ tenajaramu mʉja, ji bueiyede jʉ aivʉ baru, arejame náre Jesús. Nópe ayʉ bácʉ, náre dupini nʉrejame. ");
INSERT INTO cubNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Põeva ne jã́iyede ʉre ne d̶arĩ majibede d̶ayʉreca Jesús, ʉ̃́re jʉ abedejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Caiye iye vaidéjavʉ̃ yópe ñai Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ Isaías bácʉ “Yópe tequiyebu” arĩ, ʉ̃i toivaino mácarõpedeca. Mʉ, ji jabocʉ, obebejĩna baju jʉ ad̶ama ñʉje yávaiyede. Jʉ̃menijicʉ ʉ̃i parʉéde jã́d̶ovaimi obebejĩna bajure, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ Isaías bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Que baru nácapũravʉ jʉ aivʉ bʉojabedejaima. Bedióva cojedeca Jʉ̃menijicʉ, yópe arĩ, toivaicõjenejaquemavʉ Isaías bácʉre: ");
INSERT INTO cubNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Jã́ri eabevʉre d̶aibi náre Jʉ̃menijicʉ, ne jã́menajiyepe ayʉ. Aru dápiarĩ majibede d̶aibi náre, ne jápiarĩ eabenajiyepe ayʉ. Aru Jʉ̃menijicʉ yópe arĩ, coyʉibi: “Nópe d̶aivʉ yʉ, ne chĩori oatʉvabenajiyepe ayʉ ne d̶aiyede. Que baru náre mead̶abecʉyʉmu”, arĩ toivaicõjenejaquemavʉ Isaías bácʉre Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Nópe arejaquemavʉ Isaías bácʉ ʉ̃i jã́iye báque boje Jesucristoi mearore Jʉ̃menijicʉi jã́d̶ovaiye báquede nore aru ʉ̃i coyʉiye báque boje ʉ̃́ra. ");
INSERT INTO cubNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ʉbenita obedivʉ põeva ne jabovacavʉ Jesúre majini, jʉ arejaima ʉ̃́re. Ʉbenita fariseovare jidʉrĩ, “Jesúque nʉivʉbu ñʉja”, abedejaima ne jápiaiyede. Jipocamia “ ‘Jesúbe Jʉ̃menijicʉi daroimʉ mácʉ Cristo’, aivʉre maje cójijiñamine jaetovarãjaramu ñʉja, ne cójijibenajiyepe aivʉ ñʉjaque bedióva cojedeca”, arejaimad̶a ina fariseova. Que baru fariseovare jidʉrivʉ, bi arejaima na Jesúre jʉ aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jʉ̃menijicʉi mearo jã́iyede náre ʉbeni, pʉeno baju vorejaima põeva ne mearo jã́iyede náre. ");
INSERT INTO cubNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yópe arĩ, bʉjino yávarĩ darorejame Jesús: —Ácʉ põecʉ yʉre jʉ ayʉ baru, yʉre daroyʉ bácʉre máre jʉ aibi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aru quédecabu. Ácʉ põecʉ yʉre jã́ñʉ maru, yʉre daroyʉ bácʉre máre jã́imi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ijãravʉi darejacacʉ yʉ. Põeva ne majinajiyepe ayʉ Jʉ̃menijicʉre, yʉ pẽoñʉpe teyʉ buecʉdarejacacʉ náre. Yʉre que teyʉre jʉ aivʉ, ñeminoi ne mautebenajiyepe ayʉ yópe Jʉ̃menijicʉre majibevʉpe, darejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ʉbenita ácʉ põecʉ ji coyʉiyede jápiayʉvacari jʉ abedu, yʉ ʉ̃́re ñájine d̶abecʉbu ʉ̃i ãmeina teiye boje caride. Põevare ne ãmeina teiye boje ñájine d̶acʉyʉ dabedejacacʉ. Quénora põeva bíjajʉrorivʉre mead̶acʉdayʉ darejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ácʉ põecʉ yʉre ʉbecʉ baru aru ji coyʉiyede máre jʉ abecʉ baru, ʉ̃́recabe jãve ñájicʉyʉ. Ʉ̃i jʉ abe boje ji coyʉiyede, ñájicʉyʉme bʉojaquijãravʉ baquinói. ");
INSERT INTO cubNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ji baju ji majiéque coyʉbevʉ yʉ. Quénora jipacʉ, yʉre daroyʉ bácʉ, yʉre coyʉicõjeimi ji coyʉiye caiyede. Que baru põeva ñájinajarama, ne jʉ abe boje ji coyʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Coreóvaivʉ yʉ iyede: Põeva yʉre jʉ aivʉ baru yópe jipacʉi d̶aicõjeiyepe náre, cʉvarãjarama jãravʉ cũiméjãravʉ baquinóre. Que baru yópe jipacʉi coyʉicõjeiyepeda coyʉyʉbu mʉjare, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua torojʉve teijãravʉ jipocacajãravʉ barejávʉ̃. Coreóvarejaquemavʉ Jesús dijãravʉ eainore ʉ̃i nʉquinore ijãravʉre jocarĩ, copaicʉyʉ jípacʉ yebai. Ina ijãravʉcavʉre ʉ̃ jinare cainʉmʉa jecʉbi ʉ̃. Que teni ñʉjare jecʉrejaquemavʉ ʉ̃i yaiyeta. ");
INSERT INTO cubNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nainú baji ñʉja ʉ̃i bueimaraque ãñʉ marejáme Jesús. Javeta ñʉjacacʉ Judas, Simón Iscariotei mácʉre yópe arĩ, “Jesúre ʉ̃i mauvare jẽni jíquijivʉ yʉ”, dápiare d̶arejaquemavʉ ñai abujuvai jabocʉ, ʉ̃i jẽni jíquiyepe ayʉ Jesúre ʉ̃i mauvare. ");
INSERT INTO cubNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús coreóvarejaquemavʉ majepacʉ Jʉ̃menijicʉre caiyede aru caivʉre pʉrʉcʉvaicõjeñʉ mácʉre ʉ̃́re parʉéque. Aru coreóvarejaquemavʉ ʉ̃i baju Jʉ̃menijicʉi daroimʉ mácʉ aru copaicʉyʉ ʉ̃i yebai. ");
INSERT INTO cubNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Que baru coreóvayʉ, ñʉje ãiyedeca nacajari, ʉ̃i pʉenocacajede durĩ, epeni, tʉ̃reicajede ĩni, jãrióri jẽori bʉorejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Que teyʉ bácʉ oco doaibʉre yuarĩ buivárejame, ñʉje cʉbobare joacʉyʉ. Ñʉje cʉbobare joarĩ bʉ́rejame. Ñʉjacacʉ cũinácʉre joarĩburu yóboi, tʉ̃reicaje ʉ̃i bʉoicajeque tʉ̃renejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Joarĩ tʉ̃reni ñʉjare coapa, Simón Pedrore eacʉnʉrejame Jesús. Aru Pedro arejame ʉ̃́re: —Mʉ, ji jabocʉ, ¿yʉre ji cʉbobare joacʉyʉrʉ̃ mʉ? arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús arejame: —Ji cari d̶aiyede coreóvabevʉ mʉ. Ʉbenita no yóboi coreóvacʉyʉmu, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro arejame Jesúre: —Yʉre ji cʉbobare ye joaicõjemevʉ mʉre, arejame. Aru Jesús arejame ʉ̃́re: —Dinʉmʉ yʉre joaicõjemecʉ baru, yʉ́cacʉ ãmecʉyʉmu mʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pedro arejame: —Mʉ, ji jabocʉ, ji cʉboba matʉinora joarĩ dajocabejacʉ mʉ. Ji jipobʉre aru ji pʉrʉáre máre joajacʉ mʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Aru Jesús arejame ñʉjare: —Caibaju joaimʉ mácʉre bedióva cojedeca caibaju joaiye jaʉbevʉ. Quénora cʉbobare joaiye jaʉvʉ, docʉcʉru. Javeta caibaju joaimara mácavʉpe paivʉtamu mʉja, Jʉ̃menijicʉi ãrʉmeteiye báque boje mʉje ãmeina teiyede mʉje chĩori dápiarĩ, diede jarʉvarĩ, jʉ aiye báquede yʉre. Ʉbenita mʉjacacʉ cũinácʉ caibaju joaimʉ mácʉpe ãmemi ʉ̃, ʉ̃i chĩomeni jarʉvaiyʉbe boje ʉ̃i ãmeina teiyede, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ʉ̃́re jẽne d̶acʉyʉre coreóvarejaquemavʉ Jesús. Que baru “Mʉjacacʉ caibaju joaimʉ mácʉ ãmemi ʉ̃”, arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Que teni ñʉje cʉbobare joarĩ bʉojarĩ, ʉ̃i pʉenocacajede bedióva cojedeca ĩni, dorejame Jesús. Dorĩ bʉojarĩ, ãivarã dobacʉdarĩ, yópe ñʉjare arĩ coyʉrejame: —¿Ji cari d̶aiye báquede, coreóvad̶arãrʉ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yʉre “bueipõecʉ” aru “ñʉje jabocʉ” máre aivʉbu mʉja. Mʉje nópe aiye meavʉ yʉre. Quédecabu yʉ. Mʉjare bueipõecʉbu. Aru mʉje jabocʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yʉ mʉje jabocʉvacari aru mʉje bueipõecʉvacari yebacacʉpe mʉje cʉbobare joaivʉ yʉ. Que baru quédeca d̶ajarã mʉja. Apevʉ yʉre jʉ aipõeva ne cʉbobare joaiye jaʉvʉ mʉjare coapa. ");
INSERT INTO cubNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Que d̶aivʉ yʉ mʉjare jã́d̶ovacʉyʉ aipe d̶aiye jaʉrõre mʉjare. Que barureca ji d̶aiyepedeca d̶ajarã mʉja mʉjevʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jãve coyʉyʉbu mʉjare: Yebacacʉ cʉbebi ʉ̃i jabocʉre vainí tʉyʉ. Aru daroimʉ cʉbebi ʉ̃́re daroyʉre vainí tʉyʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Iye cari coyʉiyede coreóvaivʉbu mʉja caride. Que baru nopedeca d̶aivʉ baru, torojʉrãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ʉbenita ji beoimara mácavʉre coreóvaivʉ yʉ. Que baru “Torojʉrãjaramu”, ji aiyede mʉja caivʉre abevʉ yʉ. Yópe Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquepedeca vaiquíye jaʉvʉ yʉre: “Ñai ãñʉ mácʉ yʉ́que, yʉre boaiyʉbi”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Iye vaiquíye jipocamia nópe coyʉivʉ mʉjare, mʉje jʉ arãjiyepe ayʉ jãvene “Jʉ̃menijicʉi mácʉbu yʉ” ji aino mácarõre. Ji coyʉino mácarõpe vainíburu yóboi, coreóvarãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ ji jaroimarare me jacopʉyʉ baru, yʉre máre me jacopʉibi ʉ̃. Ácʉ põecʉ yʉre me jacopʉyʉ baru, yʉre daroyʉ bácʉre máre me jacopʉibi ʉ̃. Que arĩ, coyʉrejame Jesús ñʉja ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nópe arĩ coyʉyʉ bácʉ ʉrarõ chĩorejame Jesús ʉ̃i ũmei. Chĩori, ñʉjare yópe yávarĩ darorejame cojedeca ye yavebecʉva: —Jãve coyʉyʉbu mʉjare: Cũinácʉ mʉjacacʉ yʉre ji mauvare jẽni jícʉyʉme ʉ̃, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ʉ̃i que aiyede ñʉje bajumia jã́rejacarã ñʉja, cuecumaivʉ. Ácʉ ñʉjacacʉ ʉ̃i aimʉre majibedejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cũinácʉ ñʉjacacʉ pare Jesús ʉ̃i jecʉmʉ Jesús yebai ʉ̃i tʉcavai dobarejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yʉre ʉ̃i pʉrʉ jabióvarĩ, jẽniari jã́icõjenejame Simón Pedro: —“¿Ácʉba mʉre jẽni jícʉyʉ?” arĩ, Jesúre jẽniari jã́jacʉ mʉ, arejame yʉre Pedro. Ʉ̃i pʉrʉque nópe arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nópe d̶ayʉre jã́ñʉ, Jesúre pʉeno cad̶ajĩe nʉri, jẽniari jã́rejacacʉ yʉ yavenijiena: —Mʉ, ji jabocʉ, ¿ácʉba ʉ̃, mʉre jẽni jícʉyʉ? arejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ji nópe arura, jʉ arejame Jesús: —Ji pã́ujevede jórĩ, ji jímʉ, ʉ̃ macʉyʉ́me yʉre jẽni jíyʉ ji mauvare, arejame Jesús. Que arĩ, pã́ure cõpavari ĩni, jórĩ, Judare, Simón Iscariotei mácʉre, jídejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Dinʉmʉmiareca Judas diede ĩñʉva, cũiná Satanás d̶aicõjeni bʉ́rejaquemavʉ ʉ̃́re. Aru ʉ̃́re arejame Jesús: —Maumena mi d̶aiyʉede d̶acʉnʉjacʉ mʉ, arejame Judare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ʉbenita ñʉja náque dobarivʉ tʉoiva yebai aipe teni Jesús ʉ̃i que ainore Judare coreóvabedejacarã cãreja. ");
INSERT INTO cubNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ʉ̃i cʉvae boje ñʉje tãutʉrare, ñʉjacavʉ, “Ñʉje ãrajiyede torojʉve teinʉmʉ bojed̶aicõjeñʉme Jesús Judare”, arĩ dápiarejaquemavʉ. Aru apevʉ ñʉjacavʉ, “Cʉve cʉvabevʉre tãutʉrare jícʉnʉicõjeñʉme Jesús ʉ̃́re”, arĩ dápiarejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Iye pã́ure ĩñʉ mácʉ, cũiná etarĩ nʉrejame Judas. Ñami marejávʉ̃ ʉ̃i etarĩ nʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ʉ̃i etarĩburu yóboi, ñʉjare yópe arĩ, yávarejame Jesús: —Caride põeva jã́rajivʉbu Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe meacʉ bajure. Caride yʉ, Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe, põevare jã́re d̶aquijivʉ Jʉ̃menijicʉ meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jʉ̃menijicʉi daroimʉ mácʉ ʉ̃mʉpe ji jã́d̶ovaru Jʉ̃menijicʉ meacʉ bajure, Jʉ̃menijicʉvacari põevare jã́d̶ovacʉyʉme ʉ̃i daroimʉ mácʉ meacʉ bajure. Aru maumejieneca que d̶acʉyʉme Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mʉja, jímajinape paivʉ, majióvarõ bajura cʉcʉyʉmu mʉjaque. Yʉre vorãjaramu mʉja. Ʉbenita yópe ji coyʉino mácarõpe maje jabovare, mʉjare máre coyʉyʉbu yʉ: Ji nʉquinore nʉiye majibevʉ mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Caride d̶aicõjeino yóbocarõre d̶aicõjequijivʉ yʉ: Mʉje bajumia ʉjarã mʉja yópe ji ʉepedeca mʉjare. Mʉje bajumia jecʉjarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Que d̶aivʉre mʉje bajumia ʉrivʉre jã́ivʉ, majinajarama caivʉ ji bueimara bajure mʉjare, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jesús que ayʉre, yópe arejame Simón Pedro: —Mʉ, ji jabocʉ, ¿ã́ri nʉñʉrʉ mʉ? arejame. Jesús arejame: —Ji nʉquinore caride nʉri bʉojabevʉ mʉ. Ʉbenita ji nʉriburu yóboi, mʉ máre nʉcʉyʉmu, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro arejame: —Mʉ, ji jabocʉ, ¿aipe teni caride mʉ́que nʉri bʉojabedi yʉ? Jaʉru, mʉre cad̶ateni, yaiquíjivʉ yʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Aru Jesús arejame Pedrore: —¿“Mʉre boje yaiquíjivʉ yʉ”, ayʉrʉ̃ mʉ? Jãve coyʉyʉbu mʉre: “Jesúre yʉ coreóvabevʉ” acʉyʉmu mʉ cari ñami, cáyu ʉ̃i órejaquiye jipocai. Aru yóbecʉe nópe acʉyʉmu mʉ, arejame Pedrore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Que ayʉ bácʉ, ñʉjare yópe coyʉrejame Jesús: —Chĩomejara mʉja. Jʉ̃menijicʉre jʉ ajarã mʉja. Ʉ̃́re jʉ arĩ, yʉre máre jʉ ajarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Jipacʉi cʉrõi tucubʉa ʉre cʉvʉ. Que ãmenu, yópe arĩ mʉjare coyʉbejebu yʉ. Nore mʉje cʉrãjiyede mead̶acacʉnʉcʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nore nʉri, mead̶arĩburu yóboi, copaidacʉyʉmu yʉ cojedeca, mʉjare ĩni nʉvacʉdacʉyʉ, mʉje cʉrãjiyepe ayʉ yʉ́que. ");
INSERT INTO cubNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ji nʉquinore majivʉ mʉja, yópe põeva ne majiépe ma nʉimare, arejame Jesús, ñʉjare coyʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás arejame Jesúre: —Mʉ, ji jabocʉ, mi nʉquinore ye majibevʉ ñʉja. ¿Aipe ayʉrʉ̃ mʉ, “Ji nʉquinore majivʉ mʉja” ayʉ? arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús arejame: —Yʉrecabu põevare eare d̶ayʉ Jʉ̃menijicʉ yebai yópe ma nʉinope cavarõ mearoi. Yʉrecabu põevare majide d̶ayʉ Jʉ̃menijicʉi dápiaiye jãvene aru cʉre d̶ayʉ mamaũmeque máre. Ñame eabenama jipacʉ yebare, ji nʉvamenu náre. ");
INSERT INTO cubNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mʉja yʉre jãve coreóvaivʉ baru, jipacʉre máre coreóvajebu mʉja. Caride jãve ʉ̃́re coreóvaivʉbu mʉja cainʉmʉa. Aru ʉ̃́re jã́d̶avʉ mʉja máre, arĩ coyʉrejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ʉ̃i que aiyede, Felipe arejame Jesúre: —Mʉ, ji jabocʉ, majepacʉre jã́d̶ovajacʉ mʉ. Quénora meaquiyebu ñʉjare, arejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ʉ̃́re jʉ ayʉ arejame Jesús: —Mʉ, Felipe, ¿que joede mʉjaque ji cʉedeca, yʉre coreóvabecʉrʉ̃ cãreja? Ácʉ põecʉ jã́ñʉ yʉre, jã́imi jipacʉre máre. Que baru, ¿aipe teni “Majepacʉre jã́d̶ovajacʉ”, ayʉrʉ̃ mʉ yʉre? ");
INSERT INTO cubNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Yʉ cʉvʉ jipacʉque. Aru jipacʉ cʉbi yʉ́que cũinávʉpe. ¿Iye ji coyʉiyede, jʉ ayʉrʉ̃ mʉ? Iye mʉjare ji coyʉiye ji bajuma ji dápiaino ãmevʉ. Quénora jipacʉrecabe, ñai cʉcʉ yʉ́que cainʉmʉa, yʉre coyʉre d̶ayʉ yópe ʉ̃i ʉrõpe. Aru ji d̶aiyede máre ji bajuma d̶ayʉ ãmevʉ. Quénora jipacʉrecabe yʉre d̶aicõjeñʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ji coyʉino mácarõre, “Cʉvʉ yʉ jipacʉque aru jipacʉ cʉbi yʉ́que cũinávʉpe”, jʉ ajarã mʉja. Ʉbenita jʉ abevʉ baru ji coyʉino mácarõre, quénora jʉ ajarã yʉre ji d̶aiye báque boje. ");
INSERT INTO cubNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jãve coyʉyʉbu mʉjare: Ácʉ põecʉ yʉre jʉ ayʉ, ji d̶aiye báquepe paiyede d̶acʉyʉme ʉ̃. Aru ape paiye me pʉeno parʉéde d̶acʉyʉme, ji nʉquiye boje jipacʉ yebai. ");
INSERT INTO cubNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Caiye mʉje jẽniaiyede yʉre ji ãmiái d̶acacʉyʉmu. Yópe mʉje jẽniaiyepedeca d̶acʉyʉmu yʉ, jã́d̶ovacʉyʉ jipacʉ meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ád̶e mʉje jẽniarajiyede yʉre ji ãmiái, ji parʉéque, mʉjare d̶acacʉyʉmu yʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ñʉjare coyʉre nʉrejame Jesús: —Mʉja ʉrivʉ baru yʉre, caiye ji d̶aicõjeiyepe d̶arãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yʉrecabu jipacʉre jẽniacʉyʉ mʉjare boje, ʉ̃i daroquiyepe ayʉ apecʉ cad̶ateipõecʉre. Ʉ̃ cainʉmʉa cʉcʉyʉme mʉjaque, jipacʉi daroquimʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ʉ̃́recabe Jʉ̃menijicʉi Espíritu põevare coreóvare d̶acʉyʉ Jʉ̃menijicʉi dápiaiye jãvene. Ijãravʉcavʉ Jʉ̃menijicʉre jʉ abevʉ ʉ̃́re jacopʉivʉ bʉojabenama, ne jã́ri eabe boje ʉ̃i d̶aiyede aru ne coreóvaiye majibe boje aipe ãrojacʉre ʉ̃́re. Ʉbenita mʉjacapũravʉ coreóvarãjaramu aipe ãrojacʉre ʉ̃́re, ʉ̃i mautequiye boje mʉjaque. Mʉjaque cʉrĩ, dajocabecʉyʉme mʉjare cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tẽumarape d̶abecʉbu yʉ mʉjare. Mʉjare jocarĩ nʉmecʉbu yʉ. Bedióva cojedeca copaidacʉyʉmu, cʉcʉyʉ mʉjaque. ");
INSERT INTO cubNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","’Quĩ́jino baju yʉre jã́menajarama ijãravʉcavʉ yʉre jʉ abevʉ. Ʉbenita mʉjacapũravʉ yʉre jã́rajaramu. Bedióva cojedeca apʉcʉyʉmu yʉ. Que baru mʉja máre cainʉmʉa apʉrivʉ barãjáramu mʉja mamaũmeque. ");
INSERT INTO cubNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ãnijãravʉ, maje copʉrãjijãravʉ baquinóre, jipacʉque ji cʉede majinajaramu mʉja, aru yʉ́que mʉje cʉede, aru mʉjaque ji cʉede máre. Maja cũinávʉpe cʉrãjaramu maja. ");
INSERT INTO cubNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ácʉ põecʉ ji d̶aicõjeiye caiyede jʉ arĩ d̶ayʉ, ʉ̃́recabe yʉre ʉcʉ. Aru ñai yʉre ʉcʉ, ʉ̃́recabe jipacʉi ʉquimʉ. Yʉ máre ʉ̃́re, yʉre ʉcʉre, ʉcʉyʉmu. Aru ji bajure jã́d̶ovacʉyʉmu ʉ̃́re, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ʉ̃i que arĩburu yóboi, cũinácʉ ñʉjacacʉ, ʉ̃i ãmiá Judas, jẽniari jã́rejame Jesúre. (Judas Iscariote ãmenejame. Apecʉ Judas barejáme ʉ̃.) Yópe arĩ, jẽniari jã́rejame Jesúre: —Mʉ, ji jabocʉ, ¿aipe d̶arĩ ñʉja, mʉre ʉrivʉ, mi bajure jã́d̶ovacʉyʉrʉ̃, ʉbenita apevʉre, ijãravʉcavʉ mʉre jʉ abevʉre, mi bajure jã́d̶ovamecʉyʉrʉ̃ mʉ? arejame Judas. ");
INSERT INTO cubNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús, yópe arĩ, coyʉrejame: —Ácʉ põecʉ yʉre ʉcʉ, ji coyʉiyede jʉ acʉyʉme. Ʉ̃́recabe jipacʉi ʉquimʉ. Yʉ aru jipacʉmaque ʉ̃i yebai nʉri, ʉ̃́que cʉrãjaramu ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ácʉ põecʉ yʉre ʉbecʉ, ji coyʉiyede jʉ abebi. Ji coyʉiye ji bajuma ji dápiaino ãmevʉ. Quénora jipacʉ, yʉre daroyʉ bácʉ, jiede coyʉyʉtamu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Que arĩ, coyʉivʉ yʉ mʉjare, ji cʉede cãreja mʉjaque. ");
INSERT INTO cubNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ʉbenita mʉjaque ji cʉbenʉmʉre ñai Espíritu Santore, cad̶ateipõecʉre, darocʉyʉme mʉjare jipacʉ ji parʉéque. Ʉ̃́recabe caiyede mʉjare buecʉyʉ. Aru ji coyʉiye báque caiyede mʉjare ãrʉre d̶acʉyʉme ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Mʉjare, meaũme cãrijimeũme cʉrivʉre, epecʉyʉmu yʉ. Ji cãrijimeũmene mʉjare jíquijivʉ. Ijãravʉcavʉ mʉjare ji jíyepe paiyede jíye majibema. Que baru cãrijimevʉva chĩomejara aru jidʉbejarã mʉja, ayʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mʉjare ji coyʉino mácarõre, “Yʉ nʉcʉyʉmu. Ʉbenita mʉje yebai copaidacʉyʉmu yʉ” ainore, jápiad̶avʉ̃ mʉja. Yʉre ʉrivʉ baru, ji nʉquiyede jipacʉ yebai torojʉjebu mʉja. Jipacʉ ji pʉeno parʉcʉbe. Que baru ʉ̃i yebai nʉcʉyʉmu yʉ. Aru torojʉe jaʉvʉ mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nópe coyʉivʉ mʉjare caride, iye vaiquíye jipocamia, mʉje coreóvarãjiyepe ayʉ jãvene ji coyʉino mácarõre. ");
INSERT INTO cubNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Caride ijãravʉcavʉ ne jabocʉ, ñai abujuvai jabocʉ, daibi. Que baru ʉrarõ baju mʉjare coyʉbequijivʉ yʉ. Ʉ̃ yʉre ʉ̃i d̶aicõjeiye parʉé cʉvabecʉreca nʉcʉyʉmu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Vaiquíyebu yʉre yópe ji aiye báquepedeca, ijãravʉcavʉ ne coreóvarãjiyepe ayʉ ji ʉede jipacʉre. Que baru caiye jipacʉi d̶aicõjeiyede d̶aivʉ yʉ. Jã́rica, etarevʉ, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ñʉja ʉ̃i bueimarare, yópe arĩ, coyʉre nʉrejame Jesús: —Yʉrecabu oteiʉyaimu yobedope páyʉ. Aru jipacʉrecabe dimure coreipõecʉ, oteipõecʉreca páyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Aru dimu cavajĩbʉape paivʉtamu mʉja. Ãmecavabʉa, jẽmecavabʉare burarĩ jarʉvaibi jipacʉ. Meacavabʉa, jẽicavabʉare majié burarĩ, mead̶aibi jipacʉ, oteipõecʉ ʉ̃i d̶aiyepe d̶ayʉ. Que teni jẽicavabʉare ʉrarõ jẽne d̶aibi jipacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mʉje jʉ aiye boje ji coyʉiyede, javeta mʉjare mead̶acacʉ yʉ. Que baru jipacʉ ʉ̃i mead̶aimaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉ́que cʉjarã mʉja. Aru yʉ mʉjaque cʉcʉyʉmu. Cũinávʉpe cʉrãjaramu maja. Cavabʉ cʉbedu dimure, cainidʉa jẽmevʉ. Quédecabu mʉjare. Yʉ́que cʉbevʉ baru, Jʉ̃menijicʉi ʉrõpe d̶abenamu. Yʉ́que mautebevʉ baru, mearore, yópe ji memeiyepe, d̶abejebu mʉja. Põeva mearore d̶abevʉbu, yópe cavabʉa jẽidʉa cʉbepe. ");
INSERT INTO cubNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Oteiʉyaimu yobedope páyʉbu yʉ. Aru dimu cavabʉape paivʉbu mʉja. Ácʉ põecʉ cʉcʉ baru yʉ́que aru ji cʉru máre ʉ̃́que cũinávʉpe, ʉ̃́recabe ʉrarõ mearore d̶acʉyʉ yópe Jʉ̃menijicʉi ʉrõpe. Ʉbenita yʉ́que cʉbecʉ baru, Jʉ̃menijicʉi ʉrõpe d̶aiye majibebi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yʉ́que mautebecʉ, oteipõecʉ ʉ̃i burarĩ jarʉvaicavabʉpe paicavabʉbe ʉ̃. Dicavabʉ yaicavabʉ jarʉvaquicavabʉre apecʉ jevaiyame mead̶ayʉ. Dicavabʉre jevarĩ, pecatoro d̶arĩ, nʉvaiyame ʉ̃ nore jocarĩ, juarĩ jarʉvacʉñʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Mʉja yʉre dajocabevʉ baru, aru ji coyʉiyede jʉ are nʉivʉ baru, ád̶e mʉje jẽniaiyede mʉje ʉrõpe cʉvarãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mʉje ʉrarõ mearo d̶aiyede jãve ji bueimara d̶arĩ jã́d̶ovaivʉbu mʉja. Põeva mʉjare nópe d̶aivʉre jã́ivʉ, jipacʉre mearore jínajarama na. ");
INSERT INTO cubNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yʉre jipacʉi ʉepedeca ʉvʉ yʉ mʉjare. Que baru ji ʉmarape mautejarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ji d̶aicõjeiye caiyede jʉ arĩ d̶aivʉ baru, ji ʉmara mautenajaramu mʉja. Nopedeca jipacʉi d̶aicõjeiye caiyede jʉ arĩ d̶ayʉ, ʉ̃i ʉmʉ mauteivʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Que arĩ, coyʉivʉ yʉ mʉjare, mʉje torojʉrãjiyepe ayʉ ji torojʉepedeca, aru mʉje bʉojarãjiyepe ayʉ torojʉrivʉ mʉje ũme jaʉbevʉva. ");
INSERT INTO cubNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ji d̶aicõjeino mʉjare yópe ainotamu: Mʉje bajumia ʉjarã mʉja yópe mʉjare ji ʉepedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Põecʉ ʉ̃i yaidú ʉ̃i yóvaimarare boje, ape ʉ̃i d̶aiye cʉbevʉ, ʉ̃i jã́d̶ovaquiyepe náre ʉcʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ji d̶aicõjeiyede jʉ arĩ d̶aivʉ baru, ji ʉmaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Caride “yʉre memecaivʉ” abecʉbu mʉjare. Quénora “ji yóvaimara” acʉyʉmu mʉjare. Põecʉre memecaivʉ ne jabocʉi dápiainore majibema na. Ʉbenita põecʉi yóvaimara ʉ̃i dápiainore majima. Aru yʉre jipacʉi jápiad̶ovaiye báquede mʉjare coyʉiye jebeivʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Yʉre vobeteavʉ̃ mʉja. Yʉ batecácʉ mʉjare vorĩ beoyʉ. Jipacʉi ʉrõpe mʉje d̶arãjiyepe ayʉ, mʉjare beorĩ epecacʉ. Ji epeimaramu mʉja, ʉrarõ mearore d̶arãjivʉ yópe Jʉ̃menijicʉi ʉrõpe. Aru mʉje d̶arãjiye bíjabequiyebu. Quénora mautequiyebu. Que baru ád̶e mʉje jẽniaiyede jipacʉre ji ãmiái, d̶acacʉyʉme ʉ̃ yópe mʉje jẽniaiyepedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Que baru yópe arĩ, coyʉyʉbu yʉ mʉjare cojedeca: Mʉje bajumia ʉjarã mʉja, arĩ coyʉrejame Jesús, ñʉjare bueyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yópe arĩ, coyʉre nʉrejame Jesús: —Ijãravʉcavʉ Jʉ̃menijicʉre jʉ abevʉ mʉjare ʉbenajarama. Ʉbenita coreóvajarã iyede: Mʉjare ne ʉbenajiye jipocai, yʉre ʉbeteima na. ");
INSERT INTO cubNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mʉja ijãravʉcavʉ baju baru, mʉjare ʉjebu ijãravʉcavʉ Jʉ̃menijicʉre jʉ abevʉ, yópe ne ʉepedeca ne bajumia. Ʉbenita yʉ́vacari mʉjare beorĩ epecacʉ jívʉ barãjiyépe ayʉ ijãravʉcavʉre jocarĩ. Que baru náque cʉrivʉvacari, nácavʉ ãmevʉ mʉja. Que baru mʉjare ʉbema na. ");
INSERT INTO cubNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ji coyʉvarede me ãrʉjara mʉja. Yebacacʉ cʉbebi ʉ̃i jabocʉre vainí tʉyʉ. Apevʉ ñájine d̶aima yʉre. Que baru mʉjare máre ñájine d̶arãjarama. Ʉbenita apevʉ ji coyʉiyede jʉ aima. Que baru mʉjare máre jʉ arãjarama. ");
INSERT INTO cubNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yʉ́cavʉbu mʉja. Aru ina ijãravʉcavʉ yʉre daroyʉ bácʉre majibema na. Que baru mʉjare máre ñájine d̶arãjarama na. ");
INSERT INTO cubNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Náre ji coyʉcʉdabedu, boropatebejebu ne ãmeina teiye boje. Ʉbenita ji coyʉcʉdaiye báque boje ijãravʉcavʉre, ye bojed̶abemarava cʉma na ne ãmeina teiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ácʉ põecʉ ʉbecʉ yʉre, jipacʉre máre ʉbebi ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Põeva ne d̶arĩ majibe bajure jã́d̶ovacacʉ yʉ yócavʉre. Apecʉ cʉbebi ji d̶aiyepe paiyede d̶arĩ majicʉ. Ji que d̶abedu ne jã́iyede, boropatebejebu ne ãmeina teiye boje. Ʉbenita ji nópe d̶aiyede jã́d̶ama na. Aru jã́ivʉvacari, yʉre ʉbeni, jipacʉre máre ʉbema na. ");
INSERT INTO cubNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Caiye iye vaivʉ yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃i yávaiyede: “Jaʉrabeda yʉre ʉbema”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ʉbenita ñai Espíritu Santo, mʉjare cad̶ateipõecʉ, dacʉyʉme mʉje yebai. Ʉ̃́recabe põevare coreóvare d̶acʉyʉ Jʉ̃menijicʉi dápiaiye jãvene. Ʉ̃́re jipacʉi cʉrõre jocarĩ darocʉyʉmu yʉ mʉje yebai. Ʉ̃i edarĩburu yóboi, ʉ̃́recabe coyʉcʉyʉ ji borore ʉ̃i jã́iye báque boje. ");
INSERT INTO cubNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Aru mʉja mamarʉmʉre ji bueni bʉinʉmʉre yʉ́que cʉ́teavʉ̃ mʉja. Pʉ caride máre cʉrivʉbu yʉ́que. Que baru mʉja máre coyʉrãjivʉbu ji borore mʉje jã́iye báque boje, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yópe arĩ, coyʉre nʉrejame Jesús: —Nópe coyʉivʉ yʉ mʉjare, mʉje dajocabenajiyepe ayʉ mʉje jʉ aiyede yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judíovai jabova jaetovaicõjenajarama mʉjare ne cójijiñamiare jocarĩ. Apejãravʉa daquijãravʉa baquiyé põeva ne boarĩ́ jarʉvarãjiyede mʉjare, “Nópe d̶arĩ Jʉ̃menijicʉre memecaivʉbu maja”, arĩ dápiarãjarama ina mʉjare boarã́jivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Que d̶arãjarama, yʉre aru jipacʉre máre ne coreóvabe boje. ");
INSERT INTO cubNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nópe coyʉivʉ yʉ mʉjare, mʉje ãrʉrajiyepe ayʉ iye ji coyʉiye báquede ãnijãravʉa, ne nópe d̶arãjijãravʉa baquiyéde mʉjare, arĩ coyʉrejame Jesús. Yópe arĩ, coyʉre nʉrejame Jesús: —Ji bueni bʉinʉmʉre caiye iye ji cari coyʉiyede mʉjare coyʉbetecacʉ yʉ, ji cʉe boje mʉjaque. ");
INSERT INTO cubNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ʉbenita caride yʉre daroyʉ bácʉ yebai nʉcʉyʉmu yʉ. Nʉcʉyʉreca mʉjacacʉ cʉbebi, “¿Ã́ri nʉcʉyʉrʉ̃ mʉ?” arĩ jẽniari jã́ñʉ yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Quénora ʉrarõ chĩoivʉbu mʉja mʉje ũmei ji nópe arĩ coyʉiye boje. ");
INSERT INTO cubNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ʉbenita yʉ́capũravʉ mʉjare yávaiyede jãvene coyʉyʉbu yʉ. Ji nʉquino meaquiyebu mʉjare. Ji nʉmenu, mʉjare cad̶ateyʉ bacʉyʉ́ dabejebu. Ʉbenita yʉ nʉñʉ mácʉ darocʉyʉmu ʉ̃́re mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","’Dacʉyʉ edayʉ bácʉ ijãravʉcavʉ boropateivʉre ne ãmeina teiye boje coreóvare d̶acʉyʉme. Yʉre boropatebecʉre Jʉ̃menijicʉi jã́inore coreóvare d̶acʉyʉme. Jʉ̃menijicʉ ñájine d̶acʉyʉre põevare ne ãmeina teiye boje máre coreóvare d̶acʉyʉme ʉ̃, ji daroquimʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Náre coreóvare d̶acʉyʉme ãmeina teivʉ boropateivʉre ne jʉ abe boje yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Náre coreóvare d̶acʉyʉme yʉre boropatebecʉre Jʉ̃menijicʉi jã́inore, ji nʉquiye boje jipacʉ yebai. Que baru yʉre jã́menajaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Aru náre coreóvare d̶acʉyʉme Jʉ̃menijicʉ ñájine d̶acʉyʉre põevare ne ãmeina teiye boje, Jʉ̃menijicʉi “Ñájicʉyʉmu mʉ”, ʉ̃i jave coyʉiye báque boje ijãravʉcavʉ ne jabocʉre, ñai abujuvai jabocʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ʉrarõ mʉjare ji coyʉjʉroe cʉvavʉ. Ʉbenita cũiná caiyede jápiaiye majibevʉbu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ʉbenita ñai Espíritu Santo dacʉyʉme, põevare coreóvare d̶acʉyʉ Jʉ̃menijicʉi yávaiyede jãvene. Ʉ̃́recabe coreóvare d̶acʉyʉ mʉjare caiye Jʉ̃menijicʉi yávaiyede jãvene. Aru iye vaiquíyede coyʉcʉyʉme mʉjare. Ʉ̃i baju majiéque coyʉbecʉbe. ");
INSERT INTO cubNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ji majié matʉiyede jápiayʉ bácʉ, diede mʉjare coreóvare d̶acʉyʉme. Que baru yʉre mearore jícʉyʉme. ");
INSERT INTO cubNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Caiye jipacʉi majiéde majivʉ yʉ. Que baru “Ñai Espíritu Santo ji majié matʉiyede mʉjare coreóvare d̶acʉyʉme”, avʉ yʉ mʉjare, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yópe arĩ, coyʉre nʉrejame Jesús: —Quĩ́jino baju yʉre jã́menajaramu mʉja. Ʉbenita apeno quĩ́jino baju yójĩboi bedióva cojedeca yʉre jã́rajaramu mʉja, arejame Jesús ñʉja ʉ̃i bueimarare. ");
INSERT INTO cubNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ʉ̃i que aiyede, ñʉjacavʉ yópe arĩ, jẽniari jã́rejaima ne baju: —¿Aipe ayʉ bárica, “Quĩ́jino baju yʉre jã́menajaramu mʉja. Ʉbenita apeno quĩ́jino baju yójĩboi bedióva cojedeca yʉre jã́rajaramu mʉja” ayʉ? ¿Aru, “Jipacʉ yebai nʉcʉyʉmu yʉ” ayʉ, aipe ayʉba ʉ̃? ");
INSERT INTO cubNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Carijĩeneca ʉ̃i aiyeque aipe ayʉba Jesús? “Maiyójavʉ majare. Majino ãmevʉ ʉ̃i que coyʉino”, arejaima ñʉjacavʉ ne bajumia boroteivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ñʉje jẽniari jã́iyede ʉ̃́re coreóvayʉ, ñʉjare yópe arĩ, coyʉrejame Jesús: —¿Ji aiyede, “Quĩ́jino baju yʉre jã́menajaramu mʉja. Ʉbenita apeno quĩ́jino yójĩboi bedióva cojedeca yʉre jã́rajaramu mʉja” jẽniari jã́ivʉrʉ̃ mʉja, mʉje bajumia boroteivʉ? ");
INSERT INTO cubNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jãve coyʉyʉbu mʉjare: Mʉjacapũravʉ ʉrarõ chĩori orãjaramu. Ʉbenita ijãravʉcavʉ Jʉ̃menijicʉre jʉ abevʉcapũravʉ torojʉrãjarama na. Ʉbenita mʉja chĩoivʉvacari, no yóboi chĩoivʉ bácavʉ torojʉrãjaramu mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Maje nomiva jʉed̶ocʉvarivʉ ãmeno ñájiñama na. Ijiébu náre. Ʉbenita jʉed̶ocʉvarĩburu yóboi, ijino mácarõre ãrʉmenama jʉed̶ocʉvarivʉ bácavʉ. Némajicʉre jã́ri torojʉrivʉ, no mácarõ ãmeno ne ñájiye báquede ãrʉmenama na. ");
INSERT INTO cubNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nópebu mʉjare. Caride ʉrarõ ñájinajaramu. Ʉbenita mʉjare jã́cʉdacʉyʉmu cojedeca. Dinʉmʉ maquinóre ʉrarõ torojʉrãjaramu mʉja mʉje ũmei. Aru mʉjare ñame chĩore d̶aivʉ bʉojabenama cainʉmʉa. ");
INSERT INTO cubNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Dinʉmʉ maquinóre quénora yʉre ye apejĩene jẽniari jã́menajaramu mʉja. Jãve coyʉyʉbu mʉjare: Ád̶e mʉje jẽniarajiyede jipacʉre ji ãmiái, d̶acacʉyʉme yópe mʉje jẽniaiyepedeca ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Javede pʉ carita ye apejĩene jẽniamevʉ mʉja cãreja ji ãmiái. Jʉ̃menijicʉre jẽniajara cari. Mʉje jẽniaru, mʉje jẽniaiyepedeca d̶acacʉyʉme Jʉ̃menijicʉ, mʉje bʉojarãjiyepe ayʉ torojʉrivʉ mʉje ũmei jaʉbevʉva, arejame Jesús ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yópe arĩ, coyʉre nʉrejame Jesús: —Nópe coyʉivʉ yʉ mʉjare apejĩene jẽvari maiyójepeda. Ʉbenita apejãravʉa daquijãravʉa baquiyéde apejĩene jẽvari coyʉbecʉyʉmu mʉjare cojedeca. Quénora mʉjare coyʉcʉyʉmu nuriéne jipacʉi borore yavebecʉva. ");
INSERT INTO cubNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Dinʉmʉ maquinóre mʉjavacari ʉ̃́re jẽniarajaramu ji ãmiái, ji parʉéque. Que baru, “Jipacʉre jẽniacacʉyʉmu mʉjare”, abevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Jipacʉvacari ʉbi mʉjare. Mʉjare ʉbi, mʉje ʉe boje yʉre. Mʉjare ʉbi, mʉje jʉ aiye boje yʉre, ʉ̃i daroimʉ mácʉre. Que baru mʉje baju jẽniaiyede ʉ̃́re jápiacʉyʉme jipacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jipacʉque cʉcʉ bácʉ, ʉ̃i cʉrõre jocarĩ etarejacacʉ, ẽmeni dacʉyʉ yore ijãravʉi. Aru caride yore cʉcʉ, ijãravʉre jocarĩ dajocacʉyʉmu, cojedeca nʉcʉyʉ jipacʉ yebai, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Dinʉmʉre ñʉja ʉ̃i bueimara arejacarã Jesúre: —Caride me coyʉivʉ mʉ ñʉjare, apejĩene jẽvamecʉva. ");
INSERT INTO cubNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Caride mʉ caiyede coreóvayʉre majivʉ ñʉja. Mʉre jẽniari jã́iye ye jaʉbevʉ. Que baru mʉre, Jʉ̃menijicʉi daroimʉ mácʉ bajure, jʉ aivʉbu ñʉja, arejacarã ñʉja Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ñʉjare arejame Jesús: —¿Jãve “Jʉ aivʉbu mʉre”, aivʉrʉ̃ mʉja? ");
INSERT INTO cubNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jã́rijide apa. Ãnijãravʉ daquijãravʉ baquinó jave eare nʉinotamu no. Carijĩeneca yʉre jocarĩ nʉrajaramu mʉja mʉje cʉrõai coapa. Cũinácʉva mautecʉyʉmu yʉ. Ʉbenita jipacʉ yʉ́que cʉbi cainʉmʉa. Que baru cũinácʉ bajuva ãmevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Caiye iyede mʉjare coyʉivʉ yʉ, mʉje cãrijimenajiyepe ayʉ, mʉje cʉe boje yʉ́que cũinávʉpe. Mʉjare ñájine d̶arãjarama ijãravʉcavʉ Jʉ̃menijicʉre jʉ abevʉ. Ʉbenita jidʉbejarã mʉja. Ijãravʉque ãmene jave vainí tʉivʉ yʉ. Que baru jʉ ajarã yʉre, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Que arĩburu yóboi cavarõi jã́ñʉ, yópe arejame Jʉ̃menijicʉre Jesús. —Mʉ, jipacʉ, ji memeinʉmʉ jave eaivʉ yʉre. Põevare yʉre mímacʉ meacʉ bajure jã́d̶ovajacʉ mʉ, ji jã́d̶ovaquiyepe ayʉ mʉre meacʉ bajure. ");
INSERT INTO cubNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yʉre jaboteicõjeivʉ mʉ caivʉ põevare, ji cʉvare d̶aquiyepe ayʉ jãravʉ cũiméjãravʉ baquinóre caivʉ ina mi jʉ are d̶aimarare yʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mʉ́vacari Jʉ̃menijicʉ cũinácʉra jãvetamu mʉ. Aru yʉ, Jesucristo, mi daroimʉ mácʉbu yʉ. Ina majare coreóvaivʉ, nárecabu cʉvarãjivʉ jãravʉ cũiméjãravʉ baquinóre, ne coreóvaiye boje majare. ");
INSERT INTO cubNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Iye mi d̶aicõjeiye báquede yʉre d̶arĩ bʉojaivʉ yʉ. Que baru mʉre meacʉ bajure jã́d̶ovaivʉ yʉ yore ijãravʉi. ");
INSERT INTO cubNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mamarʉmʉre maje caiyede cʉed̶arãjiye jipocai, meacʉ baju barejacácʉ mi yebare. Caride bedióva yʉre meacʉ bajure epejacʉ mi yebai cojedeca, yópe ji mamarʉmʉre cʉe báquepedeca, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yópe arĩ, coyʉre nʉrejame Jesús jípacʉre: —Ijãravʉcavʉ mʉre jʉ abevʉre jarʉvarĩ, beorĩ, ĩni, coatede d̶ávʉ̃ mʉ ina yʉre jʉ arãjivʉre. Mamarʉmʉrata mívʉ bárãjivʉ barejáima na. Aru náre yʉre jʉ are d̶aivʉ mʉ. Nárecabu mʉre ji coyʉimara, majinajivʉ aipe ãrojacʉre mʉre. Aru mi yávaiyede jápiarĩ jʉ ad̶ama na. ");
INSERT INTO cubNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Caride caiye iye mi majié cʉvare d̶aiyede yʉre jãve míyede coreóvaivʉbu na. ");
INSERT INTO cubNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Iye mi coyʉicõjevarede yʉre, náre coyʉivʉ yʉ. Aru na jʉ ad̶ama diede. Yʉre, mi daroimʉ mácʉre, jãve coreóvaivʉbu. Aru mʉ yʉre daroyʉ bácʉre jʉ ad̶ama. ");
INSERT INTO cubNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ijãravʉcavʉ mʉre jʉ abevʉre jẽniacabevʉ yʉ mʉ́que. Quénora ina mi yʉre jʉ are d̶aimarare jẽniacaivʉ yʉ mʉ́que, ne mívʉ bae boje. ");
INSERT INTO cubNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Caivʉ yʉ́cavʉ mívʉbu na. Aru caivʉ mʉ́cavʉ jívʉbu na. Aru yʉ meacʉ bajure jã́d̶ovad̶ama na. ");
INSERT INTO cubNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Yʉ mautebecʉbu ijãravʉre caride. Quénora maumejieneca dacʉyʉmu mi yebai, cʉcʉyʉ mʉ́que. Ʉbenita nácapũravʉ mautenajivʉbu ijãravʉre. Mʉ, jipacʉ bajutamu mʉ. Que baru ina yore mautenajivʉre corejacʉ mʉ mi parʉéque, iye parʉé mi cʉvare d̶aiye báqueque yʉre. Corejacʉ náre, cũinávʉpeda ne tenajiyepe ayʉ yópe majapedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yore cʉcʉ baju coreivʉ yʉ náre mi parʉéque, iye parʉé mi cʉvare d̶aiyeque yʉre. Náre mead̶aivʉ yʉ. Aru bíjabema na. Cũinácʉ quécʉra, ñai bíjacʉyʉ ʉ̃i ãmeina teiye boje, yʉre bíjaibi ʉ̃, vaiquíyepe ayʉ yópe mi yávaiyede mi toivaicõjeiye báquepedeca. ");
INSERT INTO cubNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Caride mi yebai dacʉyʉmu yʉ. Nópe coyʉivʉ yʉ ji cʉede cãreja ijãravʉre ne jápiainoi, ne bʉojarãjiyepe ayʉ torojʉrivʉ ne ũmei jaʉbevʉva, yópe ji torojʉepedeca ji ũmei. ");
INSERT INTO cubNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Iye mi coyʉicõjevarede yʉre, náre coyʉivʉ yʉ. Na yʉ́pe dápiaivʉbu cari. Yópe ijãravʉcavʉ mʉre jʉ abevʉ ne dápiaiyepe dápiabema na. Que baru náre ʉbema ijãravʉcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Ina mi yʉre jʉ are d̶aimarare ĩni nʉvajacʉ ijãravʉre jocarĩ”, arĩ jẽniamevʉ yʉ mʉre. Quénora “Náre jã́ri corejacʉ me, abujuvai jabocʉ ʉ̃i ãmeina d̶are d̶abequiyepe ayʉ náre”, arĩ jẽniaivʉ yʉ mʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Yʉ dápiabevʉ yópe ijãravʉcavʉ mʉre jʉ abevʉ ne dápiaiyepe. Quédeca ina mi yʉre jʉ are d̶aimara máre ijãravʉcavʉ mʉre jʉ abevʉ ne dápiaiyepe dápiabema na. ");
INSERT INTO cubNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ijãravʉque ãmene jarʉvarĩ náre coavarĩ, epejacʉ mʉ́cavʉre, ne memecarãjiyepe ayʉ mʉre. Que d̶ajacʉ mi yávaiyeque. Jãvetamu mi yávaiye. ");
INSERT INTO cubNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mʉ darorejavʉ̃ yʉre, ji buequiyepe ayʉ ijãravʉcavʉre. Nopedeca yʉ máre jaroivʉ náre, ne buenajiyepe ayʉ ijãravʉcavʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ji baju epeivʉ yʉ, memecacʉyʉ mʉre yópe mi ʉrõpe. Que d̶aivʉ náre boje, na máre ne epenajiyepe ayʉ ne baju, memecarãjivʉ mʉre yópe mi ʉrõpe. Que d̶arãjivʉbu, ne majié boje jãvene mi yávaiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ina mi yʉre jʉ are d̶aimara, ji bueimarare, mʉre jẽniacaivʉ yʉ. Aru apevʉre máre, yʉre jʉ aivʉ bárãjivʉre, ji bueimara ne bueiye boje náre, jẽniacaivʉ yʉ mʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mʉre jẽniaivʉ yʉ, ne cʉrãjiyepe ayʉ cũinávʉpe. Mʉ cʉvʉ yʉ́que aru yʉ cʉvʉ mʉ́que cũinávʉpe. Quédeca na márajivʉ máre cʉjarãri majaque cũinávʉpe. Que teivʉre jã́ivʉ, yʉre, mi daroimʉ mácʉre, jʉ arãjarama ijãravʉcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yópe mi mead̶aiye báquepe yʉre, quédeca yʉ máre mead̶aivʉ náre, ne cʉrãjiyepe ayʉ cũinávʉpe yópe maje cʉepedeca cũinávʉpe. ");
INSERT INTO cubNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Náque cʉvʉ yʉ aru yʉ́que cʉvʉ mʉ, ne cʉrãjiyepe aivʉ majaque cũinávʉpeda. Que baru yʉ mi daroimʉ mácʉre aru na mi ʉmarare cũinátʉrʉ yʉre mi ʉepedeca ʉcʉre coreóvarãjarama ijãravʉcavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Mʉ, jipacʉ, mi yʉre jʉ are d̶aimara márajivʉre, ne cʉrãjiyepe yʉ́que ji cʉquinore ʉvʉ yʉ, ne jã́rajiyepe ayʉ yʉre meacʉ bajure, mʉ́pe páyʉre. Mamarʉmʉre maje caiyede cʉed̶arãjiye jipocai, yʉre ʉrejavʉ̃ mʉ. Que baru yʉ meacʉ bajure, mʉ́pe páyʉre, jã́d̶ovaivʉ mʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mʉ, jipacʉ, meacʉ baju, boropatebevʉ mʉ. Mʉre coreóvabema ijãravʉcavʉ mʉre jʉ abevʉ. Ʉbenita yʉ́capũravʉ coreóvaivʉ mʉre. Aru ina mi jʉ are d̶aimara yʉre, mi daroimʉ mácʉre, coreóvad̶ama na. ");
INSERT INTO cubNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉ aipe ãrojacʉre coreóvare d̶aivʉ yʉ náre. Aru mʉre ne coreóvaino pʉeno náre coreóvare d̶acʉyʉmu yʉ, ne ʉrãjiyepe ayʉ apevʉre yópe mi ʉepedeca yʉre. Que teni yʉ́vacari náque cʉcʉyʉmu cũinávʉpe. Que arĩ, jípacʉre coyʉrejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nópe coyʉrĩburu yóboi jípacʉque, Jesús aru ñʉja ʉ̃i bueimara etarĩ, nʉri jiajĩya Cedrón ãmicʉriyare jatarejacarã. Nore eaivʉ oteiye cʉrõi, ecorejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","No oteiye cʉrõi ñʉje nʉinore javede Jesúque nʉ́varejacarã ñʉja doce paivʉ ʉ̃i bueimara. Que baru noi ñʉje nʉiyede majidejaquemavʉ Judas, ñai Jesúre jẽni jícʉyʉ ʉ̃i mauvare. ");
INSERT INTO cubNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Majicʉ, no oteiye cʉrõre darejame Judas. Jipocateyʉ barejáme Jʉ̃menijicʉi cʉ̃ramine coreipõevacavʉre, sacerdotevare jaboteipõeva aru fariseova ne jaroimarare ʉ̃́que, aru churaravare máre. Ina ʉ̃i jipocateimara ne boarã́jiyede dʉrʉivʉ barejáima. Pẽoibʉaque aru cã́maveaque máre darejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ʉ̃́re vaiquíyede majicʉ, náre eaivʉre, copʉ nʉri yópe arĩ, jẽniari jã́rejame Jesús: —¿Ñamene voivʉrʉ̃ mʉja? arejame náre. ");
INSERT INTO cubNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Jesús Nazarecacʉre vorãdaivʉbu ñʉja, arejaima na. —Yʉ́bu, arejame náre Jesús. Ne nópe boroteiyede, ne coricai núrejame Judas, Jesúre jẽni jíyʉ ʉ̃i mauvare. ");
INSERT INTO cubNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesús ʉ̃i que aiyede, daruíni yebamia pʉaréva tʉrejaima na, Jesúre jẽnadaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bedióva cojedeca náre jẽniari jã́rejame Jesús: —¿Ñamene voivʉrʉ̃ mʉja? arejame náre. —Jesús Nazarecacʉre voivʉbu ñʉja, arejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—Javeta mʉjare “Yʉ́bu”, avʉ. Yʉre voivʉ baru, dinʉmʉ ji yóvaimarare nʉicõjejara, arejame ʉ̃́re voivʉre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Que arejame Jesús yópe ʉ̃i aino mácarõpedeca vaiquíyepe ayʉ, “Mʉ, jipacʉ, ina mi yʉre jʉ are d̶aimaracacʉ ye cũinácʉ bíjacabebi yʉre”, ʉ̃i aino mácarõpe. ");
INSERT INTO cubNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Dinʉmʉre Simón Pedro ʉ̃i boaicarovede tatorĩ, ĩni, duarĩ, sacerdotevare jaboteipõecʉ ʉ̃i yebacacʉre, Malco ãmicʉcʉre, juijórĩ najuárejame ʉ̃i meapũravʉcacamucare. ");
INSERT INTO cubNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nópe d̶ayʉre jã́ri, Jesús arejame ʉ̃́re: —Mi boaicarovede mead̶ajacʉ mʉ. Ãmenore yʉre jipacʉ ʉ̃i vaidé d̶aquiyede jãve vaicʉ́yʉmu yʉ, arejame Pedrore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Dinʉmʉ ina churarava aru ina Jʉ̃menijicʉi cʉ̃ramine coreipõeva máre, Jesúre jẽni, ʉ̃i pʉrʉáre bʉorĩ bʉojarĩ, nʉvarejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ʉ̃́re nʉvarejaima mamarʉmʉ Anás ãmicʉcʉ yebai. Caifás barejáme ʉ̃i vácʉ. Aru ñai Caifás sacerdotevare jaboteipõecʉ barejáme diʉjʉre. ");
INSERT INTO cubNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ñai Caifárecabe, “Cũinácʉva yaidú, majare meajebu. Que teni caivʉ yainí bíjabejebu maja”, ayʉ bácʉ barejámed̶a apevʉ judíovai jabovare. ");
INSERT INTO cubNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesúre ne jẽni nʉvaiyede, ne yójĩboi nʉre nʉrejacarã ñʉja, yʉ aru Simón Pedro. Sacerdotevare jaboteipõecʉi coreóvaimʉ marejacácʉ yʉ. Que baru ʉ̃i cʉ̃rami tãibʉre Jesúre ne ecovaiyede, yʉre máre ecoicõjenejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ʉbenita tãibʉcarõ biaido jedevai mautedejame Pedro. Que baru ecoinore coreipõecoque borotecʉnʉrejacacʉ, õi ecoicõjecojiyepe ayʉ ʉ̃́re máre. ");
INSERT INTO cubNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Pedro ecoyʉ bácʉre, jedevacobede coreipõeco jẽniari jã́rejaco ʉ̃́re: —¿Jesús ʉ̃i bueimaracacʉ ãmecʉrʉ̃ mʉ? arejaco. —¡Nácacʉ ãmevʉ! arejame ṍre Pedro. ");
INSERT INTO cubNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Diñami ãmei jʉjʉrejavʉ̃. Que baru nócacʉi yebacavʉ ina coreipõevaque nore toabore dacuvarĩ, cʉocarejaima. Aru Pedro máre náque cʉocarejame. ");
INSERT INTO cubNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sacerdotevare jaboteipõecʉ Jesús ʉ̃i bueiyede aru ñʉja ʉ̃i bueimarare máre jẽniari jã́rejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ʉ̃i jẽniari jã́iyede, Jesúcapũravʉ, yópe arĩ, coyʉrejamed̶a ʉ̃́re: —Yʉ caivʉ ne jápiaiyede buecacʉ yavebecʉva. Maja judíova maje cójijiñamiai aru Jʉ̃menijicʉi cʉ̃rami máre bueyʉ batecácʉ yʉ. Põeva ne cójijinoai buecacʉ yʉ cainʉmʉa. Ye yavenina buebetecacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Que baru, ¿aipe teni yʉre jẽniari jã́ñʉrʉ mʉ? Yʉre jápiaivʉ bácavʉre jẽniari jã́jacʉ. Náta ji coyʉiye báque caiyede majidivʉ coyʉrãjarama mʉre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesús ʉ̃i que aiyede, cũinácʉ ina coreipõevacacʉ ʉ̃i jijecamure pʉrʉque pẽvari, yópe arejamed̶a Jesúre: —Maje jabocʉre nópe arĩ, abejacʉ mʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Aru Jesús arejamed̶a: —Ãmene ji que aru, yʉre coyʉjacʉ mʉ caride, caivʉ ne jápiaiyede. ¿Ʉbenita méne ji que aru, aipe teni yʉre pẽvacʉrʉ̃? Pẽvaiye jaʉbevʉ mʉre, arejamed̶a ʉ̃́re Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Dinʉmʉre Anás Jesúre bʉoimʉre jarorejamed̶a Caifás, sacerdotevare jaboteipõecʉ yebai. ");
INSERT INTO cubNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nore toabo ẽcarʉi cʉocayʉ barejáme Pedro cãreja. Apevʉ nore cʉrivʉ ʉ̃́re jẽniari jã́rejaima: —¿Mʉ máre Jesúi bueimaracacʉ ãmecʉrʉ̃ mʉ? arejaima ʉ̃́re. —¡Nácacʉ ãmevʉ yʉ! arejame náre. ");
INSERT INTO cubNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Dinʉmʉre sacerdotevare jaboteipõecʉi yebacavʉcacʉ, Pedro ʉ̃i boaicaroveque ʉ̃i buraimʉ mácʉ jicʉ, Pedrore arejame: —Cari ñami marede oteiye cʉrõi Jesúque mʉre jã́vʉ yʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—¡Nácacʉ ãmevʉ yʉ! Jesúre yʉ coreóvabevʉ, arejame Pedro cojedeca. Ʉ̃i que aiye bajure, cáyu órejarejame. ");
INSERT INTO cubNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aviá ʉ̃i tucʉmʉiyede, Caifái cʉ̃ramine jocarĩ pʉ jabocʉi cʉ̃ramita Jesúre nʉvarejaima. Ñai jabocʉ, Roma ãmicʉrõ jaboteino jabocʉi epeimʉ marejáme, jabotecʉyʉ ina judíovare. Judío ãmenejame ñai jabocʉ, Pilato ãmicʉcʉ. Ʉ̃i cʉ̃rami ecoivʉ baru, Pascua torojʉve teinoque ãiyede ãicõjememara májebu judíova. Que baru iye ãiyede ãiyʉrivʉ, diñamine corĩ nʉmenejaima ina judíova, Jesúre nʉvaivʉ, Jʉ̃menijicʉi jã́mequiyepe aivʉ náre ãmenape. ");
INSERT INTO cubNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Que baru náre jẽniari jã́cʉetarejame Pilato. —¿Ye ãmenore boro coyʉrĩ ad̶aivʉrʉ̃ mʉja ñai ʉ̃mʉre? arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ina judíova arejaima: —Ʉ̃i ãmeno d̶abedu, ʉ̃́re davabejebu ñʉja mi yebai, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato arejame náre: —Dinʉmʉ ʉ̃́re nʉvari, majijarã mʉje baju. Mʉje d̶aicõjeiyepedeca coyʉjarã ʉ̃́re aipe ñájicʉyʉre, ʉ̃i bojed̶aquiyepe aivʉ ʉ̃i ãmeno d̶aiye báquede, arejame. Nácapũravʉ arejaima: —Mʉja Romacavʉ ñʉja judíovare boarĩ́ jarʉvaicõjemevʉ põevare. Que baru ʉ̃́re boarĩ́ jarʉvaivʉ bʉojabevʉ ñʉja, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nópe vaidéjavʉ̃, “Yópe vaiquíyebu” Jesús ʉ̃i aiye báquepedeca javede aipe ãrojae jocʉcʉjaravena ʉ̃i mauva ne pẽvaimʉ ʉ̃i yaiquínore. ");
INSERT INTO cubNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ʉ̃i cʉ̃ramine corĩ nʉri, Jesúre cutuicõjenejamed̶a Pilato. Ʉ̃i eaiyede ʉ̃i yebai ʉ̃́re jẽniari jã́rejamed̶a: —¿Mʉ́rʉ judíovai jabocʉ? arejamed̶a Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesúcapũravʉ arejamed̶a: —¿Mʉ mi baju majini, yópe jẽniari jã́ñʉrʉ mʉ, que ayʉ? ¿O apevʉ ne coyʉiyede jápiarĩ, yópe jẽniari jã́ñʉrʉ mʉ? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatocapũravʉ arejamed̶a: —¿Judíovacacʉ bárica yʉ, mi que aiyede? Mi joborõcavʉ aru sacerdotevare jaboteipõeva mʉre boro coyʉrĩ ad̶arãdama na. ¿Aipe d̶acʉrʉ̃ mʉ, ne que ãmecoroiyede? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús jʉ arejamed̶a: —Ijãravʉcarõ ãmevʉ ji jaboteino. Yore ji jabotedu, ãd̶amatejebu ji yóvaimara, ji mauva ne jẽni jíbenajiyepe aivʉ yʉre ina judíovai jabovare. Ijãravʉcarõ ãmevʉ ji jaboteino, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Dinʉmʉ jẽniari jã́rejamed̶a Pilato: —¿Jãve “Jabocʉbu yʉ”, ayʉrʉ̃ mʉ? arejamed̶a. Jʉ arejamed̶a Jesús: —Quédeca mi aimʉrecabu yʉ. Jabocʉbu yʉ. Que barureca ijãravʉi edarĩ, põetedejaquemavʉ yʉ, jabotecʉyʉ aru coyʉcʉyʉ yávaiyede jãve bajure. Yávaiyede jãve bajure majiyʉrivʉ, yʉre jápiarĩ ad̶arãjarama na, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Aru Pilato jẽniari jã́rejamed̶a: —¿Yéba yávaiye jãve baju? arejamed̶a ʉ̃. Que ayʉ bácʉ Jesúre, jedevai etarĩ, põevare borotecʉnʉrejame Pilato cojedeca: —Ãmeina tebecʉtame ñai ʉ̃mʉ ji jã́ru. ");
INSERT INTO cubNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ʉbenita Pascua jãravʉi ji d̶arĩ cõmajiyepedeca d̶aquijivʉ yʉ. Mʉjacacʉ ji bʉoimaracacʉ cũinácʉre jaetovaquijivʉ. ¿Ñai mʉje jabocʉre jaetovaji yʉ? arĩdurejame judíovare Pilato. ");
INSERT INTO cubNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pilato ʉ̃i que aiyede cũiná jorojĩni, cod̶oboborejaima: —Bi, ʉ̃́re jaetovabejacʉ mʉ. Barrabáre jaetovarĩ, darojacʉ mʉ, arejaima Pilatore ina judíova. Ñavacʉcʉ barejáme ñai Barrabás. ");
INSERT INTO cubNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Dinʉmʉre ina judíova ne que aiyede, churaravare jara popeicõjenejamed̶a Pilato Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Aru ʉ̃́re pʉenocacaje, jabocʉ doicajepe paicaje ñemijuaricajede doarejaimad̶a na. Jesúre que teivʉ, miumua cãteni, cainitarabʉre d̶arĩ, ʉ̃i jipobʉrã ditarabʉre tʉorejaimad̶a ina churarava. ");
INSERT INTO cubNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Que d̶arĩ Jesúre jacoyʉrejaimad̶a: —Ména cʉjacʉ mʉ, judíovai jabocʉ, arejaimad̶a churarava, ʉ̃́re yʉrivʉ. Que teivʉ, ʉ̃́re pẽvavarejaimad̶a ʉ̃i jivai ne pʉrʉáque. ");
INSERT INTO cubNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jesúre ne yʉriniburu yóboi, jedevai etarejame Pilato cojedeca. —Jã́jara. Jaetovaivʉ yʉ ʉ̃́re, mʉje coreóvarãjiyepe ayʉ: Ãmeina tebecʉ bajube ʉ̃ ji jã́ru, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pilato ʉ̃i que arĩburuta, etarĩ darejame Jesús. Jabocʉi doicajepe paicaje ñemijuaricajeque ne doaimʉ mácʉ, ne jipobʉrã miumua cãteni jacoimʉ mácʉ etarĩ darejame. —Jede, ʉ̃́re jã́jara caride, arejame Pilato. ");
INSERT INTO cubNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Cũiná Jesúre ne jã́iyede, cod̶oboborejaima ina sacerdotevare jaboteipõeva aru Jʉ̃menijicʉi cʉ̃ramine coreipõeva máre: —Ʉ̃́re jocʉcʉjaravena pẽvari boarĩ́ jarʉvaicõjejacʉ mʉ, arĩ cod̶oboborejaima. Pilato arejame: —Mʉje baju ʉ̃́re nʉvari, jocʉcʉjaravena pẽvari boarĩ́ jarʉvajarã. Yʉre ji jã́ru ãmeina tebecʉtame, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Arejaima Pilatore: —“Yʉ Jʉ̃menijicʉi mácʉbu yʉ”, ávaibi Jesús. Que baru yópe cũináro ñʉjare d̶aicõjeinope ñaipe páyʉre boarĩ́ jarʉvaiye jaʉvʉ ñʉjare, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ne que aiyede jápiayʉ, pʉeno baju cuecumarejaquemavʉ Pilato. ");
INSERT INTO cubNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Diñami ecorĩ cojedeca, Jesúre jẽniari jã́rejamed̶a: —¿Ã́rocacʉrʉ̃ mʉ? arĩdurejamed̶a Jesúre Pilato. Ʉbenita Jesúcapũravʉ bi arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Dinʉmʉma Pilato arejamed̶a ʉ̃́re: —¿Yʉre coyʉiyʉbecʉrʉ̃ mʉ? ¿Ji jaboede majibecʉrʉ̃ mʉ? Mʉre jocʉcʉjaravena pẽvaicõjeiyʉcʉ baru, jocʉcʉjaravena mʉre pẽvaicõjecʉyʉmu yʉ. O mʉre jaetovaiyʉcʉ baru, mʉre jaetovacʉyʉmu yʉ. ¿Majicʉrʉ̃ mʉ diede? arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús arejamed̶a ʉ̃́re: —Jʉ̃menijicʉ mʉre jaboteicõjeimi ʉ̃. Ʉ̃i que d̶abedu, yʉre yópe d̶abejebu mʉ. Que baru ñai yʉre jẽne d̶ayʉ bácʉ mʉre mi pʉeno boropateibi, ʉ̃i ãmeina teiye boje, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jesús ʉ̃i nópe coyʉiyede, pʉeno baju ʉ̃́re jaetovaiyʉrĩdurejamed̶a Pilato. Ʉbenita yópe arĩ, cod̶oboborejaima ina judíova: —Jesúre jaetovayʉ baru, ñai jabocʉ ijãravʉcacʉ pʉeno baju parʉcʉ, César maje aimʉ, ʉ̃i yóvaimʉ ãmejebu mʉ. Ácʉ põecʉ “Jabocʉbu yʉ” ayʉ, ñai jabocʉ ijãravʉcacʉ pʉeno baju parʉcʉre, César maje aimʉre, maucʉvaibi ʉ̃, arejaima ina judíova Pilatore. ");
INSERT INTO cubNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Que aivʉre jápiarĩ, ʉ̃i dobariborã dobacʉnʉrejame Pilato. Noi dobacʉ, Jesúre davaicõjenejame, boarĩ́ jarʉvaicõjecʉyʉ ʉ̃́re. Pilato ʉ̃i dobaribo cʉriva, cʉ̃raboaque ne tʉoiva, ne mead̶aiva ñʉja judíova ñʉje yávaicamuai Gabata ãmicʉrejavʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pascua ãmicʉrijãravʉ baquinó jipocacajãravʉ barejávʉ̃, jãravʉ corica baji. Ina obedivʉ judíovare, Jesúre ʉbevʉre, yávarĩ darorejame Pilato: —Jede, jã́jara caride mʉje jabocʉre, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ina judíovacapũravʉ ʉrarõ cod̶oboborejaima: —¡Yaijácʉrĩ! ¡Yaijácʉrĩ! ¡Jocʉcʉjaravena pẽvari boarĩ́ jarʉvaicõjejacʉ ʉ̃́re! arejaima na. Pilato arejame: —¿Mʉje jabocʉre boarĩ́ jarʉvaji yʉ, mʉje dápiaru? arejame. Ina sacerdotevare jaboteipõeva arejaima: —Cũinácʉrabe ñʉje jabocʉ, ñai jabocʉ ijãravʉcacʉ pʉeno baju parʉcʉ, César maje aimʉ, arejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Que baru ne ʉrõpe d̶arĩ, jocʉcʉjaravena Jesúre pẽvari, boarĩ́ jarʉvaicõjenejame Pilato. Que baru Jesúre ĩni, ne pẽvarajinoi nʉvarejaima churarava. ");
INSERT INTO cubNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesúvacari turĩ nʉrejame dijaravede Põe jipobʉcũ ñʉje aicũ cʉ̃racũita, Gólgota ãmicʉricũ ñʉje yávaicamuaque. ");
INSERT INTO cubNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Dicũre eaivʉ, jocʉcʉjaravena pẽvari jẽorejaima na. Ʉ̃́que apejaravearã apevʉ pʉcarãre máre pẽvari jẽorejaima, cũinácʉre Jesúi meapũravʉi, aru apecʉre Jesúi cãcopũravʉi, aru Jesúre ne coricai. ");
INSERT INTO cubNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yópe arĩ, “Jesús Nazarecacʉbe judíovai jabocʉ”, toivaicõjenejamed̶a Pilato jocʉvena, ne jẽorajiyepe ayʉ divede Jesúi jocʉcʉjaravena. ");
INSERT INTO cubNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jerusalén ãmicʉriĩmaro joabejĩnoi Jesúre jocʉcʉjaravena jẽorejaima. Que baru obedivʉ põeva nore jã́radaivʉ no toivaino mácarõre jã́ri borotedejaima. Yóbecʉricamua yávaicamuaque toivaicõjenejaquemavʉ Pilato. Ñʉje yávaicamuaque, Romacavʉ ne yávaicamuaque, aru griegova ne yávaicamuaque máre toivaicõjenejaquemavʉ Pilato. Que baru caivʉ divede jã́ri majidejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pilato ʉ̃i nópe toivaicõjeiyede ʉbeni, sacerdotevare jaboteipõeva coyʉrãnʉrejaimad̶a ʉ̃́re: —Nópe mi toivaicõjeino mácarõpe toivaicõjemejacʉ mʉ. Quénora “ ‘Judíovai jabocʉbu yʉ’, abi ʉ̃”, arĩ toivarĩ jẽojacʉ mʉ cojedeca, arĩdurejaimad̶a Pilatore sacerdotevacavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ʉbenita Pilato arejamed̶a náre: —Ji toivaicõjeino mácarõ nópeda bajarṍri no. Oatʉvabecʉbu yʉ, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesúre jocʉcʉjaravena pẽvari jẽori bubarĩburu yóboi, ʉ̃i doiye báquede coapa ĩnejaima ʉ̃́re pẽvaivʉ bácavʉ. Yóvaicʉvaivʉ barejáima na. Que baru náre coapa ĩnejaima. Ʉbenita dicaje pʉenocacaje nareimea cʉbecajede coapavaiyʉbedejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Cũinácʉ nácacʉ arejame: —Dicaje nareimea cʉbecajede jad̶evarĩ, coapa ĩnu, meamejebu. Yópe d̶arãjarevʉ. Dʉvarĩ yajuivʉpe tenajarevʉ maja. Ácʉ majacacʉ majare yajurĩ vainí tʉyʉ, dicajede ĩcʉyʉme ʉ̃, arejame. Na “jede” arĩ, nópe yajurejaima na. Ne nópe coapavaiye vaidéjavʉ̃ yópe Jʉ̃menijicʉi toivaicõjeiye báquepedeca ʉ̃i yávaiyede: “Ji doiye báquede ĩni, coapavarãjarama na. Aru dʉvarĩ yajurĩ vainí tʉyʉ apecajede, ji pʉenocacajede ĩcʉyʉme nácacʉ”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. Quédeca tedejaima ina Jesúre jocʉcʉjaravena pẽvaivʉ bácavʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús ʉ̃i jocʉcʉjarave joabejĩnoi núrejaima jípaco, jípacoi mamico Cleofai márepaco María ãmicʉco, aru María Magdalacaco máre. ");
INSERT INTO cubNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jípaco nore núcore aru nijinoi yʉre máre, pare ʉ̃i jecʉmʉre, jã́rejame ʉ̃. Aru yópe arĩ, yávarejame jípacore: —Jã́jaco. Mímacʉreca páyʉbe ʉ̃, arejame jípacore Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yʉre máre yópe arejame Jesús: —Jã́jacʉ. Mipacoreca pád̶obe õ, arejame yʉre. Que teni ji cʉ̃ramine ṍre nʉvari epeni, cʉvarejacacʉ yʉ ṍre jipacope. ");
INSERT INTO cubNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","No yóboi, caiye iye Jʉ̃menijicʉi d̶aicõjevarede d̶arĩ bubayʉ bácʉ coreóvarejaquemavʉ Jesús. Que baru yópe Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquepedeca vaiquíyepe ayʉ, yópe arejame Jesús: —Cũiñóivʉ yʉre, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nore jorobʉ, vino ʉ́yaicoro upiáricoroque jorobʉ cʉrejavʉ̃. Diede jaʉborã ʉyovarĩ hisopo ãmicʉricʉ jocʉjĩcʉ cavajĩbʉi jẽori jarʉrʉrejame cũinácʉ ina churaravacacʉ. Jesúre ʉ̃i jijecamura jĩjovarejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Die upiáteiye báquede neneniburu yóboi, yópe arejame Jesús: —Quénoramu, arejame Jesús. Que arĩ, ʉ̃i jipobʉ mori tʉrĩ, yuyurĩ, yaidéjame. ");
INSERT INTO cubNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Dijãravʉ torojʉve teijãravʉ baquinóre mead̶aijãravʉ barejávʉ̃. Sábado, Pascua ãmicʉrijãravʉ, judíovai pʉeno meajãravʉ, pued̶aijãravʉ baquinó jipocacajãravʉ barejávʉ̃. Que baru dijãravʉ baquinóre ne pẽvaimara mácavʉ jocʉcʉjaravearã ne mautebenajiyepe aivʉ, Pilatore coyʉrãnʉrejaimad̶a ñʉja judíova ñʉje jabovacavʉ. Ʉ̃́re jẽniarejaimad̶a, ʉ̃i boarĩ́ pʉyoicõjequiyepe aivʉ ina jocʉcʉjaravearã jẽivʉ ne ãrad̶oare, ne yainájiyepe aivʉ maumena, jõd̶avari ĩnajivʉ ne bajuá báquede torojʉve teijãravʉ baquinó jipocai. ");
INSERT INTO cubNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Que baru Pilato ʉ̃i cõjeniburu yóboi, ina jocʉcʉjaravearã yuyuivʉre ne ãrad̶oare boarĩ́, pʉyorãnʉrejaima churaravacavʉ. Mamarʉmʉcacʉre earĩ, ʉ̃i ãrad̶oare boarĩ́ pʉyorĩ, apecʉre máre quédeca boarĩ́ pʉyorejaima ina churarava, Jesúque jocʉcʉjaravearã pẽvaimara mácavʉre boaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ʉbenita Jesús yebai eaivʉ, jave yaiyʉ́ bácʉre jã́rejaima. Que baru yaiyʉ́ bácʉre jã́ri, ʉ̃i ãrad̶oare boarĩ́ pʉyobedejaima. ");
INSERT INTO cubNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ʉbenita quédeca cũinácʉ churaravacacʉ Jesúi tẽ́penaba cãchinoi ʉ̃i tãutedorʉque totarĩ cõajarorejame ʉ̃. Jive ocoque jĩvaiye etarejavʉ̃ dicobede, ʉ̃i totarĩ cõajaroiyede. ");
INSERT INTO cubNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yʉ́vacari jã́rejacacʉ. Que barureca ji jã́iye báquede toivarĩ epeyʉbu yʉ, mʉje jʉ arãjiyepe ayʉ Jesúre. Ji majié jãve bajure coyʉyʉbu yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Que vaidéjavʉ̃. Yópe Jʉ̃menijicʉi yávaiyede ʉ̃i toivaicõjeiye báquepedeca vaino marejávʉ̃: “Ʉ̃i cũad̶oare ye cũinád̶o pʉyobenajarama na”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Aru apeno Jʉ̃menijicʉi toivaicõjeino mácarõ aiyepedeca vaidéjavʉ̃: “Ne totaimʉ mácʉre jã́rajarama põeva”, arĩ toivaicõjenejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesús ʉ̃i yainíburu yóboi, ʉ̃ mácʉi baju bácarõre mead̶aiyʉcʉ, Pilatore jẽniacʉnʉrejamed̶a José Arimateacacʉ. Jesús bácʉ ʉ̃i bueimʉ mácʉ barĩdurejame. Ʉbenita sacerdotevare pare jidʉrejamed̶a. Que baru “Jesúcacʉbu yʉ”, arĩ coyʉbedejamed̶a José. Pilato Joséde jʉ arejamed̶a. Que baru Jesús bácʉi baju bácarõre ĩni, nʉvarejaimad̶a Joséjã. ");
INSERT INTO cubNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Joséde cad̶atecʉnʉrejamed̶a Nicodemo, ñai mamarʉmʉre ñami Jesús bácʉre borotecʉnʉñʉ mácʉ. Jesús bácʉi baju bácarõre mead̶acʉyʉ, Nicodemo me mumijʉripenaque jĩvaiyede nʉvarejamed̶a. Jocʉcʉ cuidó mirra ãmicʉricʉ yoca aru vecʉijichĩabo jẽicũcoro máre, treinta paikilos ĩni nʉvarejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesús bácʉi baju bácarõre ĩni, nʉvari, mead̶arejaimad̶a na. Meacaje lino ãmicʉricajeque aru iye mumijʉeque ʉ̃ mácʉi baju bácarõre cũmarejaimad̶a. Ñʉja judíova ñʉje d̶arĩ cõmajiyepe yaiyʉ́ bácʉre ñʉje jarʉvarãjiye jipocai mead̶arejaimad̶a Joséjã. ");
INSERT INTO cubNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús bácʉre ne pẽvari jẽoino mácarõ joabejĩno oteiye cʉrõi ʉ̃ mácʉre nʉvarejaimad̶a. Nore põe jarʉvaicobe mamacobe cʉrejavʉ̃. Cʉ̃racobei Jesús bácʉre nʉvarejaimad̶a. Põeva ne yaivʉ bácavʉ ne ĩmamecobe barejávʉ̃ dicobe. Nore Jesús bácʉre jarʉvarãnʉrejaimad̶a Joséjã. ");
INSERT INTO cubNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jabʉóvaijãravʉ baquinó jipojĩca barejávʉ̃ no. Aru dicobe joabejĩnoi marejávʉ̃. Que baru maumepeda Jesús bácʉi baju bácarõre mead̶arĩ, nore jarʉvarãnʉrejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","No sumana bʉijãravʉ domingo javejĩnara, aviá ʉ̃i tucʉmʉquiye jipocai, Jesús bácʉre ne jarʉvainoi jã́conʉrejacod̶a María Magdalacaco. Nore earĩ, no cʉ̃ratʉrava ʉratʉrava dicobede bieitʉrava bácarõ javeta veoitʉrava bácarõ marejávʉ̃ya ecoicobede jocarĩ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nópe jã́ri, cũiná cúyarĩ darĩ, Simón Pedrore aru yʉre máre coyʉcoearejaco María. Ñʉjare edarĩ, yópe arĩ, coyʉrejaco: —Maje jabocʉ bácʉi baju bácarõre dicobede jocarĩ ĩni, nʉvari, apenoi epenama apevʉ. Ne nʉvari epeinore majibevʉ ñʉja, arejaco ñʉjare María. ");
INSERT INTO cubNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Õi que aiyede, ĩmarore jocarĩ nʉrejacarã ñʉja, Pedromaque, Jesús bácʉre ne jarʉvainore jã́ranʉivʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Cúyarĩ nʉrejacarã ñʉja. Ʉbenita Pedrore jocarĩ nʉri, ʉ̃i jipocai earejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ʉ̃i jipocai earĩ, dicobe jívʉi nacachini jã́ridurejacacʉ yʉ. Nore Jesús bácʉre ne cũmaicajea báquede, nore paraicajeare, jã́rejacacʉ. Ʉbenita dicobede ecorĩ nʉmenejacacʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ji yóbo earĩ, dicobei cũiná ecorĩ nʉrejame Pedro. Dicajeare nore paraicajeare jã́rejamed̶a ʉ̃ máre. ");
INSERT INTO cubNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Aru yaiyʉ́ bácʉre ne jipobʉre moaicaje bácarõre jĩ́cua tubaricaje pẽpejeicajede máre jã́rejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Dinʉmʉ dicobede mamarʉmʉre eayʉ bácʉ nore ecorĩ nʉrejacacʉ yʉ máre. Nore ecorĩ, yʉ máre caiyede jã́rejacacʉ. —Jãve bajubu. Jave nacajacʉbe Jesús yainore jarʉvarĩ, arĩ dápiarejacacʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jʉ̃menijicʉi toivaicõjeiye báque jipocaquede, Cristo nacajacʉyʉre yainore jarʉvarĩ majibenidurejacarã ñʉja cãreja. ");
INSERT INTO cubNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Dinʉmʉma, jã́riduivʉ bácavʉ, ñʉje cʉ̃rami copainʉrejacarã ñʉja pʉcarã. ");
INSERT INTO cubNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalacaco copainʉri Jesús bácʉre ne jarʉvainoi, dicobe jedeva bajita núco barejácod̶a, od̶o. Orĩ, nacachini, dicobe jívʉi jã́rejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nore pʉcarã ángelevare, Jʉ̃menijicʉi daroimarare, jã́rejacod̶a María. Boricajeare doivʉ dobarejaimad̶a na Jesús bácʉi paraino mácarõi, cũinácʉ ʉ̃i jipobʉ bácarõi aru apecʉ ʉ̃i cʉboba bácarõi. ");
INSERT INTO cubNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aru arejaimad̶a ṍre: —Mʉ, nomió, ¿aipe teni od̶orʉ̃ mʉ? arejaimad̶a na. Õ arejacod̶a: —Ji jabocʉ bácʉi baju bácarõre nʉvarama apevʉ. Ã́ri ne nʉvainore majibevʉ yʉ, arejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Que ad̶ova, copedini, nore núcʉre Jesúre jã́ridurejacod̶a. Ʉbenita ʉ̃́re coreóvabedejacod̶a. ");
INSERT INTO cubNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ṍre arejamed̶a: —Mʉ, nomió, ¿aipe teni od̶orʉ̃ mʉ? ¿Ñamene vod̶orʉ̃ mʉ? arejamed̶a. Ʉbenita, “Yore oteiye cʉrõre coreipõecʉ bajʉbí ʉ̃, que ayʉ”, arĩ dápiarĩdurejacod̶a õ. —Mʉ, ʉ̃mʉ, ʉ̃ mácʉre nʉvañʉ mácʉ baru, mi epeinore coyʉjacʉ yʉre. Yʉ bácojivʉ ʉ̃́re ĩconʉño, arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús arejamed̶a ṍre: —María, arejamed̶a. Cũiná copedini õ, hebreo ãmicʉricamua yávaicamuaque: —Rabuni, arejacod̶a Jesúre. Rabuni aiyʉrõ, bueipõecʉ aiyʉrõtamu. ");
INSERT INTO cubNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yópe arĩ, coyʉre nʉrejamed̶a Jesús. —Jipacʉ yebai nʉmevʉ yʉ cãreja. Que baru yʉre jẽni jã́mejaco mʉ. Quénora jívʉre yópe coyʉcaconʉjaco yʉre: “Jipacʉ yebai, ji mearore jímʉ yebai, nʉñʉtamu yʉ. Aru jipacʉ mʉjepacʉbe ʉ̃. Mʉje mearore jímʉme ʉ̃ jipacʉ”, yópe arĩ, náre coyʉcajaco yʉre, arejamed̶a Maríare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Que arĩburu yóboi, ñʉja ʉ̃i bueimarare coyʉcodarejaco María: —Maje jabocʉre jã́vʉ yʉ, arejaco ñʉjare. Que arĩ, ʉ̃i aiye báquede coyʉrejaco õ ñʉjare. ");
INSERT INTO cubNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Dijãravʉ, sumana bʉijãravʉmica ñamine, ñʉje cʉ̃ramine bienina cʉrejacarã ñʉja, Jesúi bueimara, diñami jívʉi, ñʉje jidʉé boje ñʉja judíova ñʉje jabovare. Que jidʉrivʉre ñʉje coricai cʉetedejame Jesús. —¿Ména cʉrãrʉ mʉja? arejame ñʉjare Jesús, jacoyʉyʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Que ayʉva, ʉ̃i pʉrʉáre aru ʉ̃i tẽ́penaba cãchinoi ʉ̃i churiá báquede jã́d̶ovarejame Jesús. Ñʉje jabocʉre jã́ivʉ, ʉrarõ torojʉrejacarã ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Bedióva cojedeca ñʉjare arejame Jesús: —¡Cʉjarã mʉja cãrijimena! Yópe yʉre jipacʉ ʉ̃i daroiye báquepedeca caivʉre bueicõjeni, nopedeca yʉ máre mʉjare jaroyʉtamu yʉ, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Que arĩ, ñʉjare ũme japurejame. Aru arejame: —Espíritu Santore jacopʉjarã mʉja. ");
INSERT INTO cubNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ñamene “Jʉ̃menijicʉ ãrʉmemi mʉje ãmeina teiyede” mʉje aru, jãve diede ãrʉmemi Jʉ̃menijicʉ. Ʉbenita ñamene “Jʉ̃menijicʉ ãrʉmetebebi mʉje ãmeina teiyede” mʉje aru, jãve diede ãrʉmetebebi Jʉ̃menijicʉ, arejame ñʉjare Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesús ʉ̃i edaiyede ñʉjacacʉ Tomás, pẽjacʉ ñʉje aimʉ, ñʉjaque cʉbedejame ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Que baru Jesús ʉ̃i nʉriburu yóbo, Tomáre coyʉrĩdurejacarã Jesúre jã́ivʉ bácavʉ: —Maje jabocʉre jã́vʉ ñʉja, arejacarã ñʉja. Aru Tomás arejame: —Jãve ãmevʉ. Ʉ̃ baju ãmeteyʉme. Ʉ̃i pʉrʉáre ne pẽvaiye báquede yʉ ji baju jã́ñʉ maru, “jãve” acʉyʉmu yʉ. Ne pẽvaiyoa coiye báquede ji ãmuyoque yʉ ji baju doarĩ jã́ñʉ maru máre, “jãve” acʉyʉmu yʉ. Aru ʉ̃i tẽ́penabacachuri bácarõre yʉ ji baju doarĩ jacoyʉ baru, “Jãvetame ñai” acʉyʉmu, arejame ñʉjare Tomás. ");
INSERT INTO cubNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho paijãravʉa yóboi, nomica ñʉje cʉ̃ramine bienina cʉrejacarã ñʉja cojedeca. Dinʉmʉre ñʉjaque cʉrejame Tomás máre. Diñami bieiñamineca ecorĩ, ñʉje coricai cʉetedejame Jesús cojedeca. Aru arejame ñʉjare: —¿Ména cʉrãrʉ mʉja? arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Dinʉmʉre arejame Tomáre: —Mʉ, Tomás, mi ãmuyoque ji pʉrʉáre mʉ mi baju doarĩ jã́cʉdajacʉ. Aru ji tẽ́penabacachuri bácarõre máre mʉ mi baju doarĩ jã́jacʉ. Jʉ abecʉ tebejacʉ mʉ. “Jãvemu” arĩ, jʉ ayʉ tejacʉ, arejame Tomáre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás, ʉ̃i churiá báquede jã́ri majicʉ, arejame: —Ji jabocʉ bajubu mʉ. Yʉre Jʉ̃menijicʉ bajubu mʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Aru Jesús arejame: —Yʉre jã́ivʉ mʉ mi baju. Que baru mʉ yʉre jʉ aivʉ. Torojʉrivʉbu na jã́mevʉva yʉre jʉ aivʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Põeva ne d̶arĩ majibede ʉre d̶arejame Jesús ñʉje jã́iyede. Yore ijãravʉi ʉ̃i d̶aiye báque caiyede corevarĩ toivabevʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ʉbenita diede toivacaivʉ yʉ, Jesúre mʉje jʉ arãjiyepe ayʉ. “Jesucristobe Jʉ̃menijicʉi daroimʉ mácʉ. Jʉ̃menijicʉi mácʉbe Jesús” mʉje arãjiyepe ayʉ, iyede toivacaivʉ. Mʉje majini jʉ arãjiyepe ayʉ ʉ̃́re, iyede toivacaivʉ yʉ. Jesúre jʉ arĩ, mamaũme cʉvarãjaramu mʉja. Que baru mʉjare, yópe arĩ, toivacaivʉ yʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","No yóboi bedióva cojedeca ñʉjare cʉeteni, jã́d̶ovarejame Jesús macajitabʉ Tiberias ãmicʉrijitabʉ ẽcarʉi. Yópe barejávʉ̃ Jesús ʉ̃i cʉeteino mácarõ. ");
INSERT INTO cubNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro; Tomás, pẽjacʉ ñʉje aimʉ; Natanael, Galileacarõ ĩmarocacʉ, Canácacʉ; Zebedeoi mára pʉcarã, jimamicʉ aru yʉ; aru apevʉ pʉcarã Jesúi bueimara quévʉra cʉrejacarã ñʉja nore. ");
INSERT INTO cubNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro arejame ñʉjare: —Yʉ moa boacʉ́ñʉmu, arejame. Aru ñʉja arejacarã: —Jede, ñʉja máre daivʉbu, arejacarã. Que arĩ, jiad̶ocũi jaturãnʉrejacarã ñʉja. Jave nainúta marejávʉ̃. Ñami joarõ pápi boarĩ́durejacarã ñʉja. Ʉbenita boabédejacarã. Ye cũinájicʉ cʉvabedejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Javejĩna miad̶áe tʉiyede, dibʉ ẽcarʉi cucʉdarejaquemavʉ Jesús. Ʉbenita ñʉja moa boarĩ́duivʉ ʉ̃́re nore núcʉre jã́ri coreóvabedejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ñʉjare órejarejame, yópe arĩ: —¿Moa boabénarʉ mʉja? arĩ jẽniari jã́rejame ñʉjare. —Bítamu. Moa boabévʉ, arejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús arejame ñʉjare: —Jiad̶ocũi meapũravʉi dʉvarĩ, jaboájarã mʉja. Que d̶aivʉ boarã́jaramu mʉja, arejame. Ʉ̃i que aiyede, meapũravʉi dʉvarĩ, jaboárĩ, dabʉborĩ, ĩnidurejacarã. Moa pʉcajĩ́nare boaréjacarã. Dabʉborĩ oabedejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yʉ, Jesúi pare jecʉmʉ, arejacacʉ Pedrore: —Maje jabocʉvacaribe ñai, que ayʉ, arejacacʉ Pedrore. Simón Pedro ji que aiyede ʉ̃i pʉenocacajede duyʉ bácʉ ʉ̃i moa boarĩ́ memeiye boje, dorĩ, jãrióri, dibʉi biarárĩ corĩ Jesús yebai tarĩ nʉrejame. ");
INSERT INTO cubNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ʉ̃i yóboi jiad̶ocũi darejacarã ñʉja. Dicʉ pápicʉre moa buiní vaidéjaima na. Que baru dicʉre ĩni, ad̶aivʉ oabedejacarã. Quéda jabʉborĩ, ẽcarʉi mavaranʉrejacarã. Joabejĩno cien paimetros baju barejávʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ẽcarʉi eaivʉ, jiad̶ocũre datʉórĩ, mari nʉrejacarã pʉ Jesús yebai. Toaboi moa joayʉ́ barejáme ʉ̃. Aru pã́ure máre cʉvarejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Dinʉmʉre Jesús ñʉjare arejame: —Mʉje boaimara mácavʉ obebevʉre davajarã, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Que arĩ, jiad̶ocũi jatucʉnʉrejame Simón Pedro cojedeca. Pápicʉre jabʉborĩ, ẽpacũi jũarejame. Ʉrarã marejáima ñʉje boaimara mácavʉ. Ciento cincuenta y tres baju barejáima. Obedivʉvacari dicʉ pápicʉre cod̶ebedejaima na. ");
INSERT INTO cubNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús arejame ñʉjare: —Ãradajarã, arejame. Aru “¿Ñamenʉ mʉ?” abedejacarã ñʉja Jesúre. Ʉ̃́re majidejacarã. ");
INSERT INTO cubNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ñʉjare tʉorejame Jesús ñʉje ãiyede. Pã́ure jíni aru moa ʉ̃i joaimara mácavʉre máre ñʉjare jídejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nóque yóbecʉe ñʉja ʉ̃i bueimarare cʉetedejame Jesús ʉ̃i nacajariburu yóboi yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ñʉje ãri bʉojarĩburu yóboi, Simón Pedrore jẽniari jã́rejame Jesús: —Mʉ, Simón, Jũai mácʉ, ¿ʉcʉrʉ̃ mʉ yʉre ina apevʉ ne ʉe pʉeno? arejame. Aru Pedro jʉ arejame: —Mʉ, ji jabocʉ, mʉre ʉvʉ yʉ. Ji ʉede mʉre majivʉ mʉ, arejame. Ʉ̃i que aiyede, Jesús arejame: —Dinʉmʉ yʉre jʉ aivʉre, parʉbevʉre cãreja ne ũmei, mead̶acajacʉ yʉre. Mi coreiye inare jaʉvʉ yópe ovejava mamajinare coreiye jaʉépe. Ji coyʉiye báquede bueni, náre yʉre jʉ arĩduivʉre jʉ are d̶ajacʉ, arejame Pedrore. ");
INSERT INTO cubNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Bedióva cojedeca ʉ̃́re quédeca jẽniari jã́rejame Jesús: —Mʉ, Simón, Jũai mácʉ, ¿yʉre ʉcʉrʉ̃ mʉ? arejame. Jʉ arejame Jesúre cojedeca: —Mʉ, ji jabocʉ, mʉre ʉvʉ yʉ. Ji ʉede mʉre majivʉ mʉ, arejame. Ʉ̃i que aiyede, Jesús arejame: —Yópe ovejavare coreipõecʉ ʉ̃i mead̶aiyepe ovejavare, nopedeca yʉre jʉ aivʉre mead̶acajacʉ yʉre. Ʉ̃i ãoiyepe ovejavare, ji coyʉiye báquede buejacʉ mʉ yʉre jʉ aivʉre, arejame Pedrore. ");
INSERT INTO cubNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Que arĩ, bedióva cojedeca jẽniari jã́rejame ʉ̃́re Jesús: —Mʉ, Simón, Jũai mácʉ, ¿yʉre ʉcʉrʉ̃ mʉ? arejame. Yóbecʉe Jesús ʉ̃i que aiyede, ʉrarõ chĩorejame Pedro. Que baru arejame: —Mʉ, ji jabocʉ, caiye jaʉbeda majivʉra mʉ. Mʉre ʉvʉ yʉ. Majivʉra mʉ, arejame. Jesús arejame Simón Pedrore: —Yʉre jʉ aivʉre mead̶acajacʉ yʉre. Ovejavape paivʉbu na. Ji coyʉiye báquede náre majicajacʉ mʉ. ");
INSERT INTO cubNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jãve coyʉyʉbu mʉre: Mʉ mi bojʉrʉ̃mʉa doiye mi ʉede dorĩ, ã́ri nʉiyʉcʉ mʉ, nʉquemavʉ mʉ. Ʉbenita bʉcʉcʉta mʉre bʉorĩ nʉvacʉyʉme apecʉ. Mi ãmuveare dabʉborĩ, bʉorĩ, d̶acʉyʉme mʉre. Dinʉmʉ maquinó mi nʉiyʉbenoi mʉre nʉvacʉyʉme, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Nópe ayʉ, Pedro ʉ̃i yaiquínore coyʉyʉ barejaquémavʉ Jesús. “Mi yaiquínore mi d̶aiye boje ji ʉrõpe jã́ri, Jʉ̃menijicʉre mearore jínajarama põeva”, ayʉ barejaquémavʉ Jesús, Pedrore que ayʉ. Dinʉmʉ arejame Pedrore: —Ji bueimʉ májacʉ mʉ, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro copedini yʉre ʉ̃i yóboi dayʉre jã́rejame. Yʉ barejacácʉ, Jesúi bueimʉ ʉ̃i pare jecʉmʉ, ʉ̃i yebai ʉ̃i tʉcavai dobacʉ bácʉ ñʉje ãino mácarõre. “Mʉ, ji jabocʉ, ¿ñame maquidí mʉre jẽne d̶acʉyʉ mi mauvare?” jẽniari jã́ñʉ mácʉ barejacácʉ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ne yóboi dayʉre yʉre jã́ri, yópe arejame Jesúre Pedro: —Mʉ, ji jabocʉ, ¿ñaine aipe vaiquídica? jẽniari jã́ridurejame Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús arejame Pedrore: —Ji ʉru, bedióva cojedeca ji copaidaiyeta yaibécʉva cʉjebu ʉ̃. Ñaine vaiquíye míye ãmevʉ. Cãrijovamejacʉ ʉ̃́re vaiquíyede. Mʉ́capũravʉ quéda ji bueimʉ májacʉ mʉ, arejame. ");
INSERT INTO cubNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Que teni Jesús ʉ̃i aiye báque boro nʉrejaquemavʉ ʉ̃i bueimara jẽneboi: “Jesúi bueimʉ pare ʉ̃i jecʉmʉ yaibécʉyʉme ʉ̃”. No aino boro nʉrejaquemavʉ yʉrã. Que arĩdurejaima Jesúcavʉ. Ʉbenita nópe ayʉ ãmenejame Jesús. “Ye yaibécʉyʉme ʉ̃”, ayʉ ãmenejame Jesús. Quénora “Ji ʉru, bedióva cojedeca ji copaidaiyeta yaibécʉva ʉ̃i cʉru, míye ãmevʉ”, arejame Jesús. ");
INSERT INTO cubNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jesús ʉ̃i que aimʉmu yʉ. Que barureca nuriéna coyʉyʉbu yʉ. Iye caiye ji toivarĩ epeiye báque jãvetamu. Ji toivarĩ epeiye báque ñʉja majivʉ jãvene. ");
INSERT INTO cubNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús ʉ̃i d̶aiye báque caiye cʉvʉ. Ʉbenita caiye yore toivabevʉ yʉ. Caiye ʉ̃i teiye báquede paperare toivarĩ jẽoru, paperatucuboa ʉre baju nʉjebu. Caiye iye toivajʉroede epeino cʉbejebu ijãravʉi. Quénoramu.");
INSERT INTO cubNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Mʉ, Teófilo, ji mamarʉmʉ toivaiye báquede toivacacʉ yʉ, mi majiquiyepe ayʉ caiye iye Jesús ʉ̃i d̶aiye báquede aru caiye iye ʉ̃i bueiye báquede máre. Majicacacʉ yʉ mʉre caiyede Jesús ʉ̃i memeni bʉijãravʉre, aru pʉ ʉ̃i cavarõ mearo Jʉ̃menijicʉi cʉrõi mʉijãravʉita máre, jípacʉ Jʉ̃menijicʉ ʉ̃i jacopaiyovaiyede ʉ̃́re cavarõ mearo ʉ̃i cʉrõi. Aru ʉ̃i mʉri nʉquiye jipocai, Jesús d̶aicõjenejamed̶a ʉ̃i yávaiye méne beorĩ coyʉicõjeimara ʉ̃i beoimara mácavʉre, Espíritu Santoi parʉéque. ");
INSERT INTO cubNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aru caiye cuarenta paijãravʉa Jesús ʉ̃i yainíburu yóboi, ina ʉ̃i yávaiye méne beorĩ coyʉicõjeimara jã́varejaimad̶a ʉ̃́re cainʉmʉa. Que baru jãve majidejaimad̶a na Jesús apʉcʉre cojedeca, nacajañʉ mácʉre yainore jarʉvarĩ. Ʉ̃́re jã́rejaimad̶a. Aru coyʉrejamed̶a náre Jʉ̃menijicʉi jabotequiyede ʉ̃i põevare. ");
INSERT INTO cubNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jesús cʉcʉ bácʉ náque cãreja, yópe arĩ, cõjenejamed̶a náre: —Nʉmejara mʉja Jerusalẽ́ne jocarĩ cãreja. Quéda corejarã ñaine, jipacʉi daroquimʉre mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Bautista bácʉ jã́d̶ovame mʉjare Jʉ̃menijicʉre ocoque. Ʉbenita yʉ jã́d̶ovacʉyʉbu mʉjare Jʉ̃menijicʉre pʉeno mearo baju obebejãravʉa yóboi. Darocʉyʉbu mʉjare ñai Espíritu Santore, arejamed̶a náre Jesús. ");
INSERT INTO cubNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","No yóboi, Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara cójijidejaimad̶a ʉ̃́que cʉ̃racũ Olivocũ ãmicʉricũ pʉenoi. Aru jẽniari jã́rejaimad̶a ʉ̃́re: —Mʉ, ñʉje jabocʉ, ¿caride jaboteicõjequidica mʉ cojedeca majacavʉ, Israecavʉre? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús arejamed̶a náre: —Jipacʉ, ʉ̃i caivʉre jaboteiye boje, majibi aipijãravʉa vaiquíye jaʉrõre. Ʉbenita ʉ̃ majicõjememi mʉjare iyede. ");
INSERT INTO cubNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jʉ̃menijicʉ darocʉyʉbe ñai Espíritu Santore, ʉ̃i d̶aicõjequiyepe ayʉ mʉjare. Que baru mʉja coyʉrãjaramu ji yávaiye méne. Coyʉrãjaramu mʉje jã́iyede ji d̶aiye báquede aru mʉje jápiaiyede ji coyʉiye báquede máre. Coyʉrãjaramu caivʉ ijãravʉcavʉre: Jerusalẽ́cavʉre, Judeacavʉre, Samariacavʉre, aru pʉ caino joborõcavʉre máre, arejamed̶a Jesús. ");
INSERT INTO cubNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Que arĩ yávaiyeda, Jesúre jacopaiyovarejaquemavʉ Jʉ̃menijicʉ náre jocarĩ, cavarõ mearo ʉ̃i cʉrõita. Ʉ̃i mʉiyedeca ocopenibo darĩ, ʉ̃́re taorejavʉ̃ya. Quénora jã́menejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ne jã́riduiyedeca cavarõre Jesús mʉri bíjayʉre, cũiná, pʉcarã ʉ̃mʉva doivʉ boricajea cuitótecajeare núrejaimad̶a ne yebai. ");
INSERT INTO cubNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ina pʉcarã ángeleva jẽniari jã́rejaimad̶a náre: —Mʉja, Galileacavʉ, ¿aipe teni yui núri jã́ivʉrʉ̃ mʉja cavarõre? Ñai Jesús mʉñʉ mácʉ mʉjare jocarĩ cavarõ mearo Jʉ̃menijicʉi cʉrõi copaidacʉyʉbe cojedeca ijãravʉi cavarõ mearore jocarĩ yópe ʉ̃i mʉiyepedeca, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","No yóboi, Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara copainʉrejaimad̶a cʉ̃racũ Olivocũ ãmicʉricũre jocarĩ Jerusalén ãmicʉriĩmaroi. Cũinákilometro vaivárejaimad̶a na. Yópe judíova ne jabʉóvaijãravʉi nʉicõjeiyepe vaivárejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ne eaiyede diĩmaroi, ecorĩ, nʉri cũinád̶ami cʉ̃rami, ʉ̃mʉcatucubʉita, ne cʉritucubʉi, ecorejaimad̶a na: Pedro, aru Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo; apecʉ Santiago, Alfeoi mácʉ; Simón ãmicʉcʉ Celote, aru Judas, apecʉ Santiago jicʉ máre. ");
INSERT INTO cubNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Obedijãravʉa Jʉ̃menijicʉque jẽniari, cójijivʉ barejáimad̶a na nore. Jesúi yóva, María, Jesúi paco, aru apevʉ nomiva máre, caivʉ ina cũinátʉrʉ ne ũme Jʉ̃menijicʉque jẽniarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Obebejãravʉa yóboi, Jesúre jʉ aipõeva cójijidejaimad̶a. Ciento veinte paivʉ baju barejáimad̶a na. Aru Pedro nacajari arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Mʉja, jívʉ, jave vaivʉ́ yópe Jʉ̃menijicʉi toivaicõjeiye báquepe David bácʉre Espíritu Santoi parʉéque. Judas bácʉ jẽni jiame Jesúre ʉ̃i mauvare. ");
INSERT INTO cubNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ʉ̃ mácʉ, majacacʉ bácʉ, yóvayʉ bateáme majare. Que baru ʉ̃ mácʉ máre Jesús ʉ̃i beoimʉ mácʉ bateáme, ʉ̃i memequiyepe ayʉ majaque, arejamed̶a náre Pedro. ");
INSERT INTO cubNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jesúre ʉ̃i jẽni jíquiye jipocai, Judas bácʉ jacopʉrejamed̶a tãutʉrare, ʉ̃i Jesúre jẽni jíye boje, ʉ̃i ãmeina teiye boje. Iye tãutʉraque apevʉ bojed̶arejaimad̶a cũináro joborõre. No joborõre ʉ̃i baju boarĩ́ jarʉvaiyʉcʉ, ʉ̃mʉi tʉrĩ darĩ ʉ̃i baju bíjarejamed̶a Judas bácʉ. Aru ʉ̃i cʉrabo etarejavʉ̃ya joborõita. ");
INSERT INTO cubNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Caivʉ Jerusalén ãmicʉriĩmarocavʉ jápiarejaimad̶a ʉ̃ mácʉi borore. Que baru ne yávaicamuaque ãmidorejaimad̶a no joborõre Acéldama ãmicʉrõ, Jivecʉrõ aiyʉrõ. ");
INSERT INTO cubNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pedro are nʉrejamed̶a ina Jesúre jʉ aipõevare yópe: —Jave toivarejaquemavʉ iye toivaiye báque Salmos ãmicʉrõi yópe Judas bácʉi borore: Ʉ̃i cʉrõ mácarõ põecʉbeno majaróri. Ñame cʉbejarãri nore, arĩ toivarejaquemavʉ. ’Aru yópe toivarejaquemavʉ apeno Salmoi: Apecʉ d̶ajacʉrĩ ʉ̃i memeino mácarõre, arĩ toivarejaquemavʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","’Que baru apecʉ yóvajacʉrĩ ñʉjare, ʉ̃ máre coyʉcʉyʉ põevare ñʉjape: “Majivʉ yʉ Jesús apʉcʉre. Ʉ̃́re jã́cacʉ yʉ, nacajañʉre yainore jarʉvarĩ”, arĩ coyʉcʉyʉme ʉ̃. Ʉ̃ majacʉ́rĩ cũinácʉ nácacʉ ina ñʉjaque cʉrivʉ bácavʉ jãravʉa coapa Jesús ʉ̃i cuiyede ñʉjaque, Juan Bautista bácʉ ʉ̃i jã́d̶ovari bʉiyede põevare Jʉ̃menijicʉre ocoque, aru pʉ Jesús ʉ̃i mʉijãravʉita cavarõ mearo Jʉ̃menijicʉi cʉrõi, arĩ coyʉrejamed̶a náre Pedro. ");
INSERT INTO cubNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ʉ̃i coyʉrĩburu yóboi, ina põeva jã́d̶ovarejaimad̶a pʉcarã ʉ̃mʉvare, nácavʉre, cũinácʉ ʉ̃i ãmiá José, ne ãmidoimʉ Barsabás aru apenʉmʉa ne ãmidoimʉ Justo, aru apecʉ máre, ʉ̃i ãmiá Matías. ");
INSERT INTO cubNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Yópe arĩ, jẽniarejaimad̶a ina Jesúre jʉ aipõeva Jʉ̃menijicʉque: —Mʉ, ñʉje jabocʉ, me majivʉ mʉ caivʉ põeva ne dápiaiyede. Que baru jẽniaivʉbu mʉre. Majide d̶ajacʉ ñʉjare ñamene ina pʉcarã ʉ̃mʉvare mi beoimʉre, ʉ̃i memecaquiyepe cũinátʉrʉ ñʉjaque mi yávaiye méne beorĩ coyʉicõjeimaraque. Judas bácʉ dajocame mi yávaiye méne coyʉinore, ʉ̃i nʉiyede toabo cũiméboi, ʉ̃i ãmeina teiye báque boje. Que baru apecʉ mi yávaiye méne beorĩ coyʉicõjeimʉ jaʉbi, arĩ jẽniarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ne jẽniariburu yóboi, dʉvarejaimad̶a cʉ̃rayabeare, ina pʉcarã ʉ̃mʉva ne ãmiáque. Aru tʉrejavʉ̃ya diyabe Matías ʉ̃i ãmiáque. Que baru ʉ̃ máre, apevʉ once paivʉque, Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimʉ tedejamed̶a Matías. ");
INSERT INTO cubNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés ãmicʉrijãravʉ eaiyede, caivʉ ina Jesúre jʉ aipõeva cójijidejaimad̶a cũinád̶ami cʉ̃rami jívʉi. ");
INSERT INTO cubNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Cũiná jápiarejaimad̶a ʉrarõ bʉjinore yópe ũmevʉ parʉrõ japuinope. No bʉjino darejavʉ̃ya cavarõre jocarĩ. Aru caivʉ ina dobarivʉ diñami jívʉi jápiarejaimad̶a no bʉjinore. ");
INSERT INTO cubNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","No yóboi, jã́rejaimad̶a ʉre toa quĩ́jino uruino yópe jemedope. Tubarejavʉ̃ya caivʉre, náre coapa. ");
INSERT INTO cubNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Caivʉ ina põeva cʉvarejaimad̶a ñai Espíritu Santore. Náre yávaicõjenejamed̶a. Aru yávarejaimad̶a apecamua yávaicamua ne majibecamuare, yópe ñai Espíritu Santo yávare d̶aiyepe náre coapa. ");
INSERT INTO cubNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nore Jerusalén ãmicʉriĩmaroi judíova caino joborõcavʉ cʉrejaimad̶a dijãravʉare. Ina judíova cainʉmʉa jídejaimad̶a mearore Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ne jápiaiyede iye vaiyede, obedivʉ ina judíova cójijidejaimad̶a. Aru jápiarejaimad̶a caivʉ na coapa Jesúre jʉ aipõeva yávaivʉre ne yávaicamuaque. Que baru pare cuecumarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Cuecumari, pare dápiaivʉ arejaimad̶a na: —Jã́rijide apa. ¿Galileacavʉ ãmeni caivʉ ina yávaivʉ? ");
INSERT INTO cubNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Aipe teni caivʉ ñʉja jápiaivʉba náre yávaivʉre ñʉje yávaicamua coapa? ");
INSERT INTO cubNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Yui cʉrivʉbu apevʉ Partiacavʉ, aru apevʉ Mediacavʉ, apevʉ Elãcavʉ, apevʉ Mesopotamiacavʉ, apevʉ Judeacavʉ, apevʉ Capadociacavʉ, apevʉ Pontocavʉ, apevʉ Asiacavʉ, apevʉ Frigiacavʉ, apevʉ Panfiliacavʉ, apevʉ Egiptocavʉ, apevʉ Áfricacavʉ, aru apevʉ Cirenecavʉ máre. Aru apevʉ Romacavʉ máre cʉrivʉbu yui. Apevʉ majacavʉ judíovabu, ne põeteiye báque boje nópe, ne cʉvae boje nébʉcʉva judíova. Aru apevʉ majacavʉ judíova ãmevʉ, ʉbenita jʉ aivʉbu judíovai bueiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cʉrivʉbu apevʉ Cretacavʉ aru apevʉ Arabiacavʉ máre. Ʉbenita maja jápiaivʉbu náre yávaivʉre maje yávaicamua coapa. Coyʉivʉbu majare Jʉ̃menijicʉi ʉrarõ mearo d̶ainore ʉ̃i parʉéque, arejaimad̶a ne bajumia. ");
INSERT INTO cubNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Cuecumaivʉ aru jápiarĩ eabevʉ cãreja, jẽniari jã́re cuivʉ barejáimad̶a ne bajumia: —¿Aipe d̶arĩ jápiarĩ earãjidica maja caiye iyede? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ʉbenita apevʉ yʉrivʉ arejaimad̶a ina Jesúre jʉ aipõevare: —¡Ina ʉ̃mʉva pacovatamu! arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Dinʉmʉma Pedro nacajari, núri apevʉ once paivʉ Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimaraque parʉrõreca coyʉrejamed̶a caivʉ ina obedivʉ põevare, ne jápiarĩ earãjiyepe ayʉ iye ne jã́iye báquede aru ne jápiaiye báquede máre. —Mʉja, judíova, jívʉ, caivʉ mʉja Jerusalẽ́cavʉ, caride coreóvajarã diede, ñʉje majiéde. Jápiajarã yʉre. Aru me jápiarĩ ad̶ajarã ji coyʉquiyede mʉjare. ");
INSERT INTO cubNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Pacovabebu”, arĩ dápiaivʉbu apevʉ mʉjacavʉ ñʉjare. Ʉbenita javejĩnamu, nueve baji caride. Que baru pacova ãmevʉ ñʉja. ");
INSERT INTO cubNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“Pacovabebu”, arĩ dápiabejarã mʉja ñʉjare. Que baru põecʉ cʉbebi pacoteyʉ javejĩnare. Quénora ñʉje d̶aiyede yópe coyʉcarejaquemavʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ bácʉ, ʉ̃i ãmiá Joel. ");
INSERT INTO cubNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jʉ̃menijicʉ arejaquemavʉ: “Yópe d̶acʉyʉmu yʉ ãnijãravʉa bʉojaquijãravʉa baquiyéna. Darocʉyʉmu ji Espíriture caivʉ põevare. Mʉjemara, aru mʉjemaromiva máre, Jʉ̃menijicʉi yávaiyede coyʉcarãjarama. Mʉjacavʉ ʉ̃mʉva bojʉvʉ apʉrivʉre yópe decoboainope majide d̶acʉyʉmu yʉ. Aru mʉjacavʉ ʉ̃mʉva bʉcʉvare majide d̶acʉyʉmu yʉ decoboainoque. ");
INSERT INTO cubNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jãve ãnijãravʉa baquiyéna darocʉyʉmu ji Espíriture yʉre memecaipõevare, ʉ̃mʉvare aru nomivare máre, ne coyʉcarãjiyepe ayʉ ji yávaiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","D̶acʉyʉmu yʉ põeva ne jã́mene cavarõi aru ne d̶arĩ majibede joborõi. Aru põeva jã́rajarama jivede, toare, aru bicore máre, caino jidojarõ, ji jã́d̶ovaquiye jipocare náre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jʉ̃menijicʉi ñájiovaquijãravʉ baquinó jipocare põevare, ne ãmeina teiye boje, ñai aviá pẽomecʉyʉme. Quédata ñemitecʉyʉme ʉ̃. Aru aviá ñamicacʉ máre jũatecʉyʉme yópe jivepe. Yópe vaiquíyebu maje jabocʉ Cristo ʉ̃i daquijãravʉ baquinó jipocare. Põeva jã́rajarama ʉrarõ ne d̶arĩ majibede. Aru ne jã́iyede diede pare cuecumarajarama na. ");
INSERT INTO cubNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Dijãravʉa baquiyéna mead̶acʉyʉmu caivʉ ina órejaivʉre yʉre ji cad̶atequiyepe aivʉre náre. Ĩcʉyʉmu náre abujuvai jabocʉi parʉéde jocarĩ”, arejaquemavʉ Jʉ̃menijicʉ, coyʉcarejaquemavʉ Joel bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Mʉja, Israecavʉ, me jápiajarã ji coyʉquiyede mʉjare. Jʉ̃menijicʉ jãve jã́d̶ovaquemavʉ mʉjare ʉ̃i daroimʉ mácʉre, ʉ̃i me jã́imʉre, Jesús Nazarecacʉre. Que baru Jesús d̶áme ʉ̃i d̶aiye báquede Jʉ̃menijicʉi parʉéque, põeva ne jã́mene, aru ne d̶arĩ majibede, aru ape parʉéque d̶aiyede máre mʉje jẽneboi. Que baru mʉjavacari majidivʉbu caiye iye jãvene. ");
INSERT INTO cubNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ñai Jesúre Jʉ̃menijicʉ javede jẽni jícõjenejaquemavʉ, yópe ʉ̃i ʉrõpe aru ʉ̃i majiéque máre. Que baru jẽni jíquemavʉ ʉ̃́re mʉjare. Aru mʉja boarĩ́ jarʉvaicõjeavʉ ʉ̃́re, ãmeina teivʉre ne pẽvarajiyepe aivʉ ʉ̃́re jocʉcʉjaravena. ");
INSERT INTO cubNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ʉbenita Jʉ̃menijicʉ nacovaquemavʉ ʉ̃́re yainore jarʉvarĩ. Jesús yaiyʉ́ bácʉvacari, mautebeteame yaiyʉ́ bácʉpe. Que baru Jʉ̃menijicʉ jebequemavʉ ʉ̃i ñájiye báquede ʉ̃i yainore. ");
INSERT INTO cubNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Javede ñai jabocʉ David bácʉ, yópe arĩ, Jʉ̃menijicʉi yávaiyede coyʉcarejaquemavʉ Jesúrã: Cainʉmʉa jã́cacʉ yʉ ji jabocʉre ji jipocai. Ʉ̃ cʉbi ji yebai. Que baru apevʉ cãrijovari bʉojabenama yʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","27","Mʉ, Jʉ̃menijicʉ, dajocabecʉbu mʉ ji ũmene ina yaivʉ bácavʉ ne cʉrõi. Pojeicõjemecʉbu mʉ ji bajure, ji meacʉ baju boje, aru ji memecaiye boje mʉre. Que baru torojʉvʉ yʉ ji ũmei. Aru torojʉrĩ yávaivʉ yʉ. Caivʉ põevape páyʉ, yʉ máre yaicʉ́yʉmu. Ʉbenita apʉcʉ jabʉóvaivʉ yʉ, ji coreiye boje mi mearo d̶acaquiyede yʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mʉ jã́d̶ovaivʉ yʉre ye d̶aiye jaʉrõre cʉcʉyʉre mʉ́que. Aru mi cʉe boje yʉ́que cainʉmʉa, ʉrarõ torojʉvʉ yʉ mʉre, arĩ coyʉcarejaquemavʉ David bácʉ Jesús ʉ̃i coyʉiye báquede Jʉ̃menijicʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Mʉja, jívʉ, jãve coyʉiyʉvʉ mʉjare majeñecu mácʉ David bácʉi borore. Ʉ̃ mácʉ yaidéjaquemavʉ. Aru jarʉvarejaquemavʉ ʉ̃i baju bácarõre cʉ̃racobei. Maja cari cʉrivʉbu joabenoi dicobede. ");
INSERT INTO cubNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ñai David bácʉ apʉcʉ cãreja, Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ barejaquémavʉ. Majidejaquemavʉ Jʉ̃menijicʉ jãve d̶acʉyʉre yópe ʉ̃i aiye báquepedeca ʉ̃́re. Jʉ̃menijicʉ coyʉrejaquemavʉ David bácʉre, “Yópe jãve d̶acʉyʉmu” arĩ: “Mʉ, David, yópe mearo d̶acacʉyʉmu yʉ mʉre. Cũinácʉ mipãramenacacʉre jaboteicõjecʉyʉmu yʉ, yópe ji jaboteicõjeiyepedeca mʉre”, arejaquemavʉ Jʉ̃menijicʉ David bácʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David bácʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõecʉ barejaquémavʉ. Que baru majidejaquemavʉ Jʉ̃menijicʉi d̶aquiyede. Die majiéque coyʉrejaquemavʉ ñai Cristoi borore, yópe arĩ: “Jʉ̃menijicʉ dajocabecʉbe ʉ̃́re yaivʉ bácavʉ ne cʉrõi. Ʉ̃i bajure máre pojeicõjemecʉbe ʉ̃́re”, arĩ coyʉcarejaquemavʉ Jʉ̃menijicʉi yávaiyede David bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ñaineca Jesúre Jʉ̃menijicʉ nacovaquemavʉ yainore jarʉvarĩ. Aru caivʉ ñʉja ʉ̃́re jã́carã apʉcʉre cojedeca ʉ̃i yainíburu yóbore. ");
INSERT INTO cubNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jʉ̃menijicʉ nacovari Jesúre epequemavʉ ʉ̃́re ʉ̃i meapũravʉi. Ñai meapũravʉi cʉcʉ parʉéde cʉvabi. Aru jípacʉ Jʉ̃menijicʉ daroquemavʉ ʉ̃́re ñai Espíritu Santore, yópe ʉ̃i aiye báquepedeca. “Darocʉyʉmu mʉre ñai Espíritu Santore”, jipocamia aquemavʉ Jʉ̃menijicʉ Jesúre. Aru Jʉ̃menijicʉ Jesúre daroicõjeimi ñai Espíritu Santore ñʉjare máre. Que baru Jesús d̶aibi caiye iye mʉje jã́iyede, mʉje jápiaiyede máre cari jãravʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ʉbenita David bácʉ mʉri nʉmenejaquemavʉ cãreja cavarõ mearo Jʉ̃menijicʉi cʉrõi yópe Jesús ʉ̃i mʉiye báquepe. Que baru David bácʉ arejaquemavʉ yópe: Jʉ̃menijicʉ aquemavʉ ji jabocʉre: “Dobajacʉ ji meapũravʉi mi cʉvae boje parʉéde yʉpedeca. ");
INSERT INTO cubNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Aru yʉ epecʉyʉmu mi mauvare mi cʉboba cãchinoi. Que teni mʉre vainí jarʉvare d̶acʉyʉmu yʉ náre, mi jabotequiyepe ayʉ náre”, arejaquemavʉ David bácʉ Cristorã. ");
INSERT INTO cubNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Caivʉ mʉja Israecavʉ jãve majijarã iyede: Ñai Jesúvacaribe mʉje jocʉcʉjaravena pẽvaicõjeimʉ mácʉ, ji coyʉimʉ mʉjare. Ʉbenita Jʉ̃menijicʉ epeibi ñai Jesúre maje jabocʉva. Ʉ̃́recabe Jʉ̃menijicʉi daroimʉ mácʉ, arejamed̶a Pedro ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aru ina põeva, ne jápiaiyede caiye ʉ̃i coyʉiyede náre, cãrijinejaimad̶a. Que baru arejaimad̶a Pedrojãre: —Mʉja, ñʉjevʉ, ¿aipe d̶arãjidi ñʉja? arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro arejamed̶a náre: —Caivʉ mʉja jarʉvajarã mʉje ãmeina teiyede. Aru oatʉvajarã mʉje d̶aiyede. Jã́d̶ovajara Jʉ̃menijicʉre ocoque mʉje Jesúre jʉ aiye boje, Jʉ̃menijicʉ ʉ̃i ãrʉmetequiyepe aivʉ mʉje ãmeina teiyede, aru ʉ̃i daroquiyepe aivʉ mʉjare ñai Espíritu Santore. ");
INSERT INTO cubNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mʉjare, mʉjemarare, mʉjepãramenare máre, aru caivʉ ina joai cʉrivʉre máre darocʉyʉme cãreja Jʉ̃menijicʉ ñai Espíritu Santore yópe ʉ̃i aiye báquepedeca. Caivʉ ʉ̃i cutuiyʉmarare mead̶acʉyʉme ʉ̃, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Aru Pedro coyʉre nʉrejamed̶a náre parʉrõreca, ʉrarõ ʉ̃i coyʉiyede, ne jʉ arãjiyepe ayʉ Jesúre. —Ina ãmeina teivʉ pare ñájinajarama. Jʉ̃menijicʉ mead̶ajacʉrĩ mʉjare, mʉje ñájimenajiyepe ayʉ ne ñájinajiyepe, arĩ coyʉrejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Que ayʉre jápiarĩ, obedivʉ ina põevacavʉ jʉ arejaimad̶a iye ʉ̃i coyʉiyede. Aru Pedrojã jã́d̶ovarejaimad̶a náre Jʉ̃menijicʉre ocoque. Que teni, dijãravʉre cójijidejaimad̶a apevʉ yóbecʉrimil paivʉ baju Jesúre jʉ aipõevaque. ");
INSERT INTO cubNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yópe d̶are cuivʉ barejáimad̶a jãravʉa coapa. Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara bueivʉ barejáimad̶a náre. Cad̶ateivʉ barejáimad̶a ne bajumia. Ne cʉvaede jívʉ barejáimad̶a ne bajumia. Caivʉ ãivʉ barejáimad̶a cũináromia. Aru caivʉ jẽniaivʉ barejáimad̶a Jʉ̃menijicʉque máre cũinátʉrʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara d̶are cuivʉ barejáimad̶a ʉre põeva ne jã́mene, ne d̶arĩ majibede máre. Aru iye ne jã́d̶ovaiyede jã́ri, caivʉ cuecumarejaimad̶a pare. ");
INSERT INTO cubNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Caivʉ ina Jesúre jʉ aipõeva, cũinátʉrʉ ne ũme, cad̶ateivʉ barejáimad̶a ne bajumia. Nácavʉ cʉve cʉvarivʉ jívʉ barejáimad̶a apevʉ nácavʉre jaʉéde, cʉbenajiyepe aivʉ cõmaje ãrojarivʉ ne jẽneboi. ");
INSERT INTO cubNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Cũinácʉ nácacʉre jaʉru, apevʉ nácavʉ bojed̶arĩ ne cʉvaede, jívarejaimad̶a ñai cʉvabecʉre jaʉéde. ");
INSERT INTO cubNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Caijãravʉa cójijivarejaimad̶a Jʉ̃menijicʉi cʉ̃rami. Aru cójijivarejaimad̶a ne cʉ̃ramia coapa, ãrajivʉ. Torojʉrĩ ã́varejaimad̶a na ne ũme méque. ");
INSERT INTO cubNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jívarejaimad̶a mearore Jʉ̃menijicʉre. Que baru caivʉ apevʉ põeva me jã́rejaimad̶a náre. Pued̶arejaimad̶a náre, ina Jesúre jʉ aipõevare. Aru caijãravʉa Jʉ̃menijicʉ cójijovarejaquemavʉ apevʉ ʉ̃i mead̶aimarare. ");
INSERT INTO cubNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cũinájãravʉ, tres baji nainú, Pedro Jũamaque mʉri nʉivʉ barejáimad̶a Jʉ̃menijicʉi cʉ̃rami. Diora cũináora judíova ne Jʉ̃menijicʉque jẽniaiora barejávʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Cũinácobe Jʉ̃menijicʉi cʉ̃rami jedevacobe yebai, Meacobe ãmicʉrijedevacobe yebai, cʉrejamed̶a cũinácʉ ʉ̃mʉ, cuiye majibecʉ. Ñai ʉ̃mʉ põetedejamed̶a cuiye majibecʉ. Caijãravʉa apevʉ ʉ̃́re nʉvari epevarejaimad̶a yo jedevacobe yebai, ʉ̃i jẽniaquiyepe aivʉ tãutʉrare ina Jʉ̃menijicʉi cʉ̃rami ecoivʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ʉ̃ jã́ñʉ mácʉ Pedrore aru Jũare máre ecoivʉre, jẽniaridurejamed̶a tãutʉrare náre. ");
INSERT INTO cubNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ʉbenita ina pʉcarã pare jã́rejaimad̶a. Aru Pedro arejamed̶a ʉ̃́re: —Jã́jacʉ ñʉjare, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ʉ̃i que aiyede, ñai ʉ̃mʉ jã́rejamed̶a náre, “Jínajivʉbu yʉre”, arĩ dápiarĩduyʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Dinʉmʉ Pedro arejamed̶a ʉ̃́re: —Tãutʉrare cʉvabevʉ yʉ. Ʉbenita jíquijivʉ mʉre ji majié cʉvaede. Jesús Nazarecacʉ ʉ̃i ãmiái, ʉ̃i parʉéque, nacajari cuicõjeivʉ mʉre, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Que ayʉva, ʉ̃i pʉrʉ meapũravʉre jẽni, Pedro nacovarejamed̶a ʉ̃́re. Cũiná ʉ̃i cʉboba, ʉ̃i cʉbochĩarʉa máre, tututedejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Maumejiena biarárĩ, núri ʉ̃i cʉbobare, vaivárĩ bʉ́rejamed̶a ʉ̃, cuiye majibecʉ bácʉ. Ecorejamed̶a Jʉ̃menijicʉi cʉ̃rami náque. Vaiváyʉ barejámed̶a. Biaráyʉ barejámed̶a. Aru yópe arĩ, mearore jíyʉ barejámed̶a Jʉ̃menijicʉre: “Jʉ̃menijicʉ meacʉ bajube”, ayʉ barejámed̶a ñai cuiye majibecʉ bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Obedivʉ põeva jã́rejaimad̶a ʉ̃́re vaiváyʉre. Aru jápiarejaimad̶a ʉ̃́re, “Jʉ̃menijicʉ meacʉ bajube”, ayʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ne coreóvaiyede ʉ̃́re ñai tãutʉrare jẽniari dobacʉ bácʉre Jʉ̃menijicʉi cʉ̃rami jedevacobe yebai, pare cuecumarejaimad̶a na, ñai ʉ̃mʉ ʉ̃i meateiye boje. ");
INSERT INTO cubNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ñai ʉ̃mʉ jẽiyede Pedrore aru Jũare máre, ina obedivʉ põeva cuecumaivʉ cúyarejaimad̶a ne yebai Jʉ̃menijicʉi cʉ̃ramicacuino, Salomón mácʉi cuino ãmicʉrõi. ");
INSERT INTO cubNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro jã́ñʉ mácʉ ina põevare, arejamed̶a náre: —Mʉja, Israecavʉ, ¿aipe teni cuecumaivʉrʉ̃ mʉja? ¿Aipe teni jã́ivʉrʉ̃ ñʉjare? ¿Dápiaivʉrʉ̃ cure d̶aivʉre ñai ʉ̃mʉre ñʉje parʉéque, o ñʉje me boje Jʉ̃menijicʉi jã́inore? ");
INSERT INTO cubNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham mácʉ, Isaac bácʉ, aru Jacob bácʉ máre, majeñecuva mácavʉ ne jʉ aimʉ, Jʉ̃menijicʉ, jã́d̶ovaimi ʉ̃́re memecaipõecʉ Jesús ʉ̃i parʉéde. Ñai Jesúrecabe mʉje jẽni jícaimʉ mácʉ mʉje jabovare, ne boarĩ́ jarʉvarãjiyepe aivʉ ʉ̃́re. Aru ñai jabocʉ Pilato ʉ̃i jaetovaiyʉede, ʉbeteavʉ̃ mʉjavacari. ");
INSERT INTO cubNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ñai Jesús cainʉmʉa memecayʉ bateáme Jʉ̃menijicʉre. Aru cainʉmʉa d̶ayʉ bateáme mearore Jʉ̃menijicʉi jã́inore. Ʉbenita mʉja ʉbeteavʉ̃ ʉ̃́re. Quénora mʉja jẽniavʉ Pilatore, ʉ̃i jaetovacaquiyepe aivʉ mʉjare ñai boaipõecʉre, Jesúre jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Que teni mʉjavacari boarĩ́ jarʉvaicõjeavʉ ñai jíyʉre põevare jãravʉ cũiméjãravʉ baquinóre. Ʉbenita Jʉ̃menijicʉcapũravʉ nacovaquemavʉ ʉ̃́re yainore jarʉvarĩ. Ñʉjavacari jã́carã ʉ̃́re apʉcʉre cojedeca, ʉ̃i yainíburu yóbore. ");
INSERT INTO cubNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesúvacari, ʉ̃i parʉéque, mead̶acʉbe ñai cuiye majibecʉ bácʉre. Caride mʉja jã́ri majidivʉbu caiye iye vaiyede ʉ̃́re, ʉ̃i dápiaiye boje, yópe arĩ: “Jesús mead̶ayʉ majibi”, arĩ dápiacʉbe ʉ̃. Aru ʉ̃i jʉ aiye boje Jesúre, meateibi ñai ʉ̃mʉ mʉje jã́iyede. ");
INSERT INTO cubNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Mʉja, jívʉ, majivʉ yʉ. Mʉje d̶aiye báquede aru mʉje jabova ne d̶aiye báquede Jesúre boarĩ́ jarʉvaivʉ coreóvabeteavʉ̃ mʉja diede. ");
INSERT INTO cubNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Javede caivʉ ina Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ coyʉrejaimad̶a ʉ̃́ra, põeva ne coreóvarãjiyepe aivʉ ʉ̃i daroimʉ mácʉ Cristoi ʉrarõ ñájiquiyede. Aru nópe ne coyʉiye báquepedeca vaiávʉ̃ Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Que baru chĩojara mʉja mʉje ãmeina teiyede. Aru oatʉvajarã mʉje d̶aiyede. Vojarã Jʉ̃menijicʉre, ʉ̃i jarʉvaquiyepe aivʉ mʉje ãmeina teiyede, aru diede máre ʉ̃i ãrʉmetequiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mʉje yópe d̶aru, Jʉ̃menijicʉ parʉre d̶acʉyʉme mʉjare mʉje ũmei. Aru darocʉyʉme mʉjare Jesúre, ñai ʉ̃i beoimʉ mácʉre, mʉjare mead̶acʉyʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesús ʉ̃i mauteino jaʉvʉ cavarõ mearo Jʉ̃menijicʉi cʉrõi pʉ dijãravʉ baquinói, Jʉ̃menijicʉi caiyede mamaene cʉed̶aquijãravʉita bedióva cojedeca. Javede Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ, Jʉ̃menijicʉre cũinácʉra memecaivʉ, coyʉcarejaimad̶a Jʉ̃menijicʉre, põeva ne majinajiyepe aivʉ diede. ");
INSERT INTO cubNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nopedeca, Moisés bácʉ arejaquemavʉ: “Jʉ̃menijicʉ, mʉje jabocʉ, darocʉyʉme mʉjare cũinácʉ ʉ̃i yávaiyede coyʉcaipõecʉre, yópe ʉ̃i daroiyepe yʉre. Ʉ̃ macʉyʉ́me cũinácʉ mʉjacacʉ. Judío bacʉyʉ́me ʉ̃. Me jápiajarã ʉ̃́re. D̶ajarã yópe ʉ̃i coyʉiyepe. ");
INSERT INTO cubNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ácʉ põecʉ ʉ̃i jápiabedu ʉ̃́re, Jʉ̃menijicʉ coavacʉyʉme ʉ̃́re ʉ̃i põevare jarʉvarĩ”, arejaquemavʉ Moisés bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Samuel bácʉ aru ʉ̃i yóbocavʉ bácavʉ, aru apevʉ Jʉ̃menijicʉi yávaiyede coyʉcaipõeva mácavʉ máre coyʉrejaquemavʉ iye vaquíyede ãnijãravʉa baquiyéde. ");
INSERT INTO cubNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jʉ̃menijicʉ coyʉicõjenejaquemavʉ ʉ̃i yávaiyede coyʉcaipõeva mácavʉre, yópe arĩ: “Yʉ, Jʉ̃menijicʉ, mearo d̶acacʉyʉmu mʉjare”. Aru “mʉjare” ayʉ Jʉ̃menijicʉ, majeñecuva mácavʉre aru majare máre ayʉ barejaquémavʉ. Jʉ̃menijicʉ “Yʉ mearo d̶acacʉyʉmu mʉjare” ʉ̃i aiyede apecʉ oatʉvarĩ bʉojabebi diede. Aru Jʉ̃menijicʉ baju oatʉvabebi ʉ̃i que aiyede. Que baru mʉjavacari jãve jacopʉrãjaramu Jʉ̃menijicʉi mearo d̶acaquiyede. Mearo d̶acacʉyʉme mʉjare máre. Nopedeca arejaquemavʉ ʉ̃ Abraham mácʉre: “Mipãramena márajivʉre mearo d̶acacʉyʉmu yʉ. Mʉre mearo d̶acaiye báquepedeca ijãravʉcavʉ apevʉ caivʉre máre mearo d̶acacʉyʉmu yʉ”, arejaquemavʉ Jʉ̃menijicʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Aru beorejaquemavʉ Jesúre, ʉ̃́re memecaipõecʉre. Ʉ̃́re nacovariburu yóboi, daroquemavʉ maje yebai mamarʉmʉre. Que d̶arĩ Jʉ̃menijicʉ mearo d̶acaquemavʉ majare, ʉ̃i jarʉvaicõjeiye boje majare maje ãmeina teiyede, arejamed̶a Pedro ina põevare. ");
INSERT INTO cubNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro aru Juan máre yópe yávaiyedeca ina põevare, apevʉ sacerdotevacavʉ, aru Jʉ̃menijicʉi cʉ̃ramine coreipõevai jabocʉ, aru saduceovacavʉ máre nʉrejaimad̶a ne yebai. Saduceo ãmicʉriyajubo judíovacavʉ barejáimad̶a na. Dápiarejaimad̶a nacajaino cʉbenore yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jararejaimad̶a Pedrojãre ne bueiye boje. Pedrojã arĩ buedejaimad̶a: —Jesús nacajaquemavʉ yainore jarʉvarĩ. Aru maja máre nacajarajaramu yainore jarʉvarĩ, arejaimad̶a Pedrojã. ");
INSERT INTO cubNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jaraivʉ Pedrojãre, ina saduceovajã náre jẽni, ãmeina teivʉre jẽni jacoiñami nʉvaicõjenejaimad̶a churaravare. Jave nainú marejávʉ̃ya. Que baru cõmiáijãravʉita jabova ne ãmeina teivʉre jẽniari jã́iñami nʉvarajivʉ barejáimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ʉbenita obedivʉ põeva, ne bueiyede jápiaivʉcavʉ bácavʉ, jʉ arejaimad̶a Jesúre. Ina põeva mamarʉmʉ jʉ aivʉ Jesúre dijãravʉre cũinápʉrʉpe paimil paivʉ baju ʉ̃mʉva marejáimad̶a na. Obedivʉ nomiva máre jʉ arejaimad̶a ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Cõmiáijãravʉ ina judíovai jabova, aru bʉcʉva, aru Jʉ̃menijicʉi yávaiyede bueipõeva máre cójijidejaimad̶a Jerusalén ãmicʉriĩmaroi. ");
INSERT INTO cubNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Apevʉ ina jabovacavʉ barejáimad̶a sacerdotevare jaboteipõecʉ ʉ̃i ãmiá Anás, aru Caifás, Juan, Alejandro, aru apevʉ Anás jinacavʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Cójijivʉ bácavʉ, davaicõjenejaimad̶a Pedrojãre ne yebai aru núicõjenejaimad̶a náre ne coricai. Que teni cũinácʉ nácacʉ jẽniari jã́rejamed̶a Pedrojãre: —¿Ñamei parʉéque mead̶arãrʉ mʉja ñai cuiye majibecʉ bácʉre? arejamed̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dinʉmʉ ñai Espíritu Santo Pedrore d̶aicõjeñʉ, yávaicõjenejamed̶a ʉ̃́re ʉ̃i jʉ aiyede náre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","—Mʉja jabova, mʉja bʉcʉva máre, caride mʉja jẽniari jã́ivʉ ñʉjare ñʉje mead̶acaino mácarõre ñai cuiye majibecʉ bácʉre. Mʉja majiyʉvʉ aipe d̶arĩ mead̶aimʉ mácʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Que baru coyʉyʉbu mʉjare, mʉje majinajiyepe ayʉ, aru caivʉ Israecavʉ máre, ne majinajiyepe ayʉ. Jesús Nazarecacʉ ʉ̃i parʉé boje, ñai ʉ̃mʉ númi yui mʉje jã́inoi, meacʉ baju. Ñainecabe Jesús mʉje pẽvari boarĩ́ jarʉvaimʉ mácʉ. Ʉbenita Jʉ̃menijicʉ nacovaquemavʉ ʉ̃́re yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Aru Jʉ̃menijicʉ toivaicõjenejaquemavʉ ʉ̃i yávaiyede yópe Jesúi borore: “Iva cʉ̃ravare cʉ̃ramine d̶aipõeva ʉbeni jarʉvaquemavʉ. Caride iva cʉ̃rava caiva apeva pʉeno parʉrivabu”, arejaquemavʉ Jʉ̃menijicʉ. Nopedeca Jesús, mʉje ʉbemʉ mácʉ, Jʉ̃menijicʉi epeimʉme. Apevʉ pʉeno jabocʉ parʉcʉbe ñai Jesús. ");
INSERT INTO cubNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Que baru ʉ̃́recabe cũinácʉ põevare mead̶aipõecʉ. Ijãravʉre apecʉ cʉbebi. Quécʉra Jesús, Jʉ̃menijicʉi epeimʉ, põevare mead̶ayʉ bʉojaibi, ne ñájimenajiyepe ayʉ ne ãmeina teiye boje, arejamed̶a Pedro cójijinocavʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ʉ̃́re jápiaivʉ bácavʉ, ina cójijinocavʉ cuecumarejaimad̶a, ne jã́iyede Pedrore aru Jũare máre yávaivʉre jidʉbevʉva, ne coreóvaiye boje náre ʉbeni cʉrivʉre aru buebevʉ bácavʉre máre. Ʉbenita majidejaimad̶a Jesúi yóvaimara mácavʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jã́rejaimad̶a ñai ʉ̃mʉ mead̶aimʉ mácʉre ne jẽneboi Pedro aru Jũaque máre. Que baru coyʉrĩ majibeni, bi arejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Dinʉmʉ etaicõjenejaimad̶a Pedrojãre ne cójijitucubʉre jocarĩ. Ne etarĩburu yóboi, ina jabova yávaivʉ barejáimad̶a ne bajumia, yópe arĩ, jẽniari jã́rejaimad̶a: ");
INSERT INTO cubNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Aipe d̶arãjidica maja náre? D̶arãma na ʉrarõ põeva ne d̶arĩ majibede. Caivʉ Jerusalẽ́cavʉ majima ne d̶aiye báquede. Que baru maja jʉ abeni majibevʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ʉbenita ne buebenajiyepe aivʉ apevʉre ne bueiyede, aru ne d̶abenajiyepe aivʉ põeva ne d̶arĩ majibede cojedeca, yávaicõjemenajarevʉ cojedeca Jesúi borore, arejaimad̶a ina cójijinocavʉ, ne bajumia yávaivʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ne yávarĩburu yóboi, órejaicõjenejaimad̶a Pedrore aru Jũare máre ne cójijitucubʉi cojedeca. Aru parʉrõreca yávaicõjemenidurejaimad̶a náre Jesúi borore. —Bedióva cojedeca buebejarã mʉja Jesúi borore, arĩdurejaimad̶a na Pedrojãre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ʉbenita Pedrojãcapũravʉ arejaimad̶a ina judíovai jabovare: —Dápiarĩ majijarã mʉja. ¿Jʉ̃menijicʉi jã́inoi, jʉ arãjidi ñʉja mʉje d̶aicõjeiyede o Jʉ̃menijicʉi d̶aicõjeiyede? ");
INSERT INTO cubNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jave dápiarĩ majivʉ ñʉja aipe d̶aiye jaʉrõre ñʉjare. Jʉ aiye jaʉvʉ ñʉjare Jʉ̃menijicʉi d̶aicõjeiyede. Que baru apenore d̶aiye majibevʉ ñʉja. Quénora d̶aivʉbu yópe iye ñʉje jã́iye báquepe, aru yópe ñʉje jápiaiye báquepe máre, arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ina cójijinocavʉcapũravʉ cojedeca yávaicõjemenidurejaimad̶a náre parʉrõreca. —Jesúi borore mʉje buedu, ñájine d̶arãjivʉbu mʉjare, arejaimad̶a Pedrojãre. Ina põevacapũravʉ torojʉrĩ mearore jídejaimad̶a Jʉ̃menijicʉre, Pedrojã ne d̶aiye báque boje. Que baru ina cójijinocavʉ, yávaicõjemeniduivʉ, jaetovarejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Aru ñai ʉ̃mʉ, ne mead̶aimʉ mácʉ põeva ne d̶arĩ majibeno d̶aiyeque, cuarenta paiʉjʉa pʉeno baju bʉcʉcʉ barejámed̶a ʉ̃. ");
INSERT INTO cubNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Maumejiena etarĩburu yóboi cójijinore jocarĩ, Pedro aru Jũamaque copainʉrejaimad̶a ne yóvaimara yebai. Aru coyʉrejaimad̶a náre caiye ina sacerdotevare jaboteipõeva aru ina judíova bʉcʉva máre ne coyʉiye báquede náre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ina Jesúre jʉ aipõeva jápiaivʉ bácavʉ Pedrojãi borore, cũinátʉrʉ yópe arĩ, coyʉrejaimad̶a Jʉ̃menijicʉre: —Mʉ, ñʉje jabocʉ, caivʉ jabova pʉeno meacʉ, cʉed̶arejaquemavʉ mʉ cavarõre, aru joborõre, aru jia ʉrad̶are máre, aru caivʉ nócavʉre, aru noi cʉede máre. ");
INSERT INTO cubNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mʉ yávaicõjenejaquemavʉ ñʉjeñecu David bácʉre, mʉre memecaipõecʉ bácʉre, mi Espíritu Santo majiéque. Que teni David bácʉ arejaquemavʉ: Judíova ãmevʉ jorojĩnajarama. Põeva dápiarãjarama ʉbenina ne d̶arãjiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ijãravʉcavʉ jabova mead̶arãjarama na ne baju. Aru ina ĩmaroare cõjeipõeva cójijinajarama, maucʉvarãjivʉ Jʉ̃menijicʉre aru ʉ̃i epeimʉ Cristore máre, arejaquemavʉ David bácʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Yópe David bácʉ ʉ̃i Jʉ̃menijicʉi yávaiyede coyʉcaiye báquepe d̶aiyede jã́vʉ ñʉja. Yo ĩmaroi ina jabova Herodes aru Poncio Pilato cójijiquemavʉ judíova ãmevʉque aru apevʉ Israecavʉque máre, maucʉvarãjivʉ Jesúre, mʉre memecaipõecʉ meacʉ bajure, ñai mi epeimʉ Cristore. ");
INSERT INTO cubNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Cójijiquemavʉ, d̶arãjivʉ yópe “D̶arãjarama”, mi aino mácarõpe, mi majiéque, nópe arĩ, yávarejaquemavʉ mʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","’Aru mʉ, ñʉje jabocʉ, cõmaje ãroje jã́jacʉ ñʉjare, ne ñájine d̶aiyʉe boje ñʉjare. Jidʉbevʉva yávare d̶ajacʉ ñʉjare Jesús ʉ̃i yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ijimarare mead̶ajacʉ náre coapa. Parʉre d̶ajacʉ ñʉjare ñʉje ũmei, ñʉje d̶arãjiyepe ayʉ põeva ne jã́mene, ne d̶arĩ majibede máre, mʉre memecaipõecʉ Jesús ʉ̃i ãmiái, ʉ̃i parʉéque, arĩ jẽniarejaimad̶a Jʉ̃menijicʉre na, Jesúre jʉ aipõeva. ");
INSERT INTO cubNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jẽniari bʉojaiyede, ne cʉrõ cújidejavʉ̃ya pare Jʉ̃menijicʉi parʉéque. Aru ñai Espíritu Santo d̶aicõjeñʉ, yávaicõjenejaquemavʉ náre. Que teni jidʉbevʉva coyʉrejaimad̶a Jʉ̃menijicʉi yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Caivʉ Jesúre jʉ aipõeva ne ũme aru ne dápiaiye máre cũinátʉrʉ barejáimad̶a na. Nácacʉ cʉbedejamed̶a “Yo jínomu” ayʉ. Quénora caiye ne cʉvaede “Majemu”, arejaimad̶a na, Jesúre jʉ aipõeva. ");
INSERT INTO cubNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara parʉrõreca coyʉrejaimad̶a apevʉre: “Jã́carã ñʉja Jesúre nacajañʉre yainore jarʉvarĩ”, arejaimad̶a. Aru Jʉ̃menijicʉ mearo d̶acarejamed̶a náre pare. ");
INSERT INTO cubNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Nácacʉ cʉbedejamed̶a jaʉmʉ ʉ̃́re apejĩe. Apevʉ ina joborõre cʉvarivʉ, cʉ̃ramiare cʉvarivʉ máre, bojed̶aivʉ barejáimad̶a nénore. Aru ne bojed̶ainore nʉvari, jívʉ barejáimad̶a Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare, ne coavarãjiyepe aivʉ ina apejĩe jaʉmarare náre jaʉrõpe. ");
INSERT INTO cubNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Cũinácʉ nácacʉ yópe d̶arejamed̶a, ʉ̃i ãmiá José. Ñai José levita ãmicʉriyajubocacʉ barejámed̶a. Aru põetedejamed̶a Chipre ãmicʉrijiavʉi. Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara ãmidorejaimad̶a ʉ̃́re Bernabé, “cad̶ateipõecʉ” aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ʉ̃ cʉvacʉ bácʉ joborõare, aru cũináro ʉ̃i joborõre bojed̶arejamed̶a ʉ̃, Bernabé. Bojed̶arĩburu yóboi, bojed̶ainore nʉvari, jídejamed̶a diede Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare, ne coavarãjiyepe ayʉ. Que d̶arejamed̶a Bernabé. ");
INSERT INTO cubNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Apevʉ cʉrejaimad̶a, ʉ̃i ãmiá Ananías, aru jímarepaco máre, õi ãmiá Safira. Ñai bojed̶arĩ jídejamed̶a ʉ̃i joborõre. ");
INSERT INTO cubNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ne bojed̶ainore ĩni, apede ne bojed̶ainoquede yaveni epedejamed̶a nénova. Que teni apede ne bojed̶ainoquede jídejamed̶a Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare. —Ʉ̃́jʉ, yo caino ñʉje joborõ mácarõ bojetamu, ʉbenina arejamed̶a Ananías Pedrojãre. Jipocamia jímarepaco majidejacod̶a caiye iye ʉ̃i d̶aquiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ʉ̃i jíniburu yóboi, Pedro arejamed̶a ʉ̃́re: —Mʉ, Ananías, ¿aipe teni abujuvai jabocʉ dápiaicõjeni mʉre yópe mi d̶ainore, mi jʉjovarĩduquiyepe ayʉ ñai Espíritu Santore mi yaveni epeiyede apede yo bojed̶ainoquede? ");
INSERT INTO cubNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mi joborõre bojed̶arĩ jíquiye jipocai, míno cʉ́tevʉ dijoborõ. Aru bojed̶arĩburu yóboi, iye tãutʉra máre míye batevʉ́. Que baru, ¿aipe teni dápiacʉrʉ̃ mʉ mi ũmei iye ãmeina teiyede? Borocʉbevʉ mʉ põevare quévʉra. Quénora borocʉvʉ mʉ Jʉ̃menijicʉre, arejamed̶a Pedro ʉ̃́re. ");
INSERT INTO cubNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cũiná Ananías jápiayʉ bácʉ iye Pedro ʉ̃i coyʉiyede, yainí tʉrejamed̶a joborõi. Aru caivʉ ina jápiaivʉ ʉ̃i borore jidʉrejaimad̶a pare. ");
INSERT INTO cubNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Dinʉmʉ apevʉ bojʉvʉ earĩ, yaiyʉ́ bácʉi baju bácarõre cũmari, nʉvari, jarʉvarejaimad̶a ʉ̃ mácʉre cʉ̃racobei. ");
INSERT INTO cubNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Yóbecʉriora yóboi, Ananías bácʉi márepaco nʉrejacod̶a Pedrojã yebai. Ʉbenita majibedejacod̶a cãreja jímarepacʉ bácʉre jave yaiyʉ́re. ");
INSERT INTO cubNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro jẽniari jã́rejamed̶a ṍre: —Coyʉjaco yʉre. ¿Iyeba caiye tãutʉra mʉje bojed̶aino joborõ mácarõ boje? arejamed̶a Pedro. Õ jʉ arejacod̶a ʉ̃́re: —Jʉ̃́jʉ, quénora bojecʉvʉ, ʉbenina arejacod̶a õ. ");
INSERT INTO cubNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Õi que aiyede, Pedro arejamed̶a ṍre: —¿Aipe teni borocʉrĩdurãrʉ mʉja Jʉ̃menijicʉi Espíritu Santore? Jã́jaco daivʉre ina mimarepacʉ bácʉre jarʉvaivʉ bácavʉ, cʉrivʉre jedevacobei caride. Mʉre máre nʉvari, jarʉvarãjivʉbu, arejamed̶a Pedro. ");
INSERT INTO cubNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Aru cũiná õ máre yainí tʉrejacod̶a joborõi Pedro ʉ̃i cʉboba yebai. Ina bojʉvʉ ecorĩ, yaiyó bácore jã́ri, õ mácore máre nʉvari, jarʉvarejaimad̶a jímarepacʉ bácʉ yebai. ");
INSERT INTO cubNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Que teni caivʉ ina Jesúre jʉ aipõeva aru apevʉ máre, ne jápiaiyede Ananías bácʉ aru Safira báco ne borore, pare jidʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara d̶are nʉivʉ barejáimad̶a ʉre põeva ne jã́mene, ne d̶arĩ majibede máre. Aru caivʉ ina Jesúre jʉ aipõeva cójijide nʉivʉ barejáimad̶a Jʉ̃menijicʉi cʉ̃rami jívʉi, Salomón mácʉi cuino ãmicʉrõi. ");
INSERT INTO cubNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Caivʉ ina Jesúre jʉ abevʉ cójijibedejaimad̶a ina jʉ aipõevaque, ne jidʉé boje. Ʉbenita caivʉ ina jʉ abevʉ me jã́ivʉ aru me yávaivʉ barejáimad̶a ina Jesúre jʉ aivʉre, náre ne pued̶aiye boje. ");
INSERT INTO cubNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Apevʉ obedivʉ põeva, ʉ̃mʉva aru nomiva máre, jʉ arĩ Jesús ʉ̃i yávaiye méne, cójijide nʉivʉ barejáimad̶a Jesúre jʉ aipõevaque. ");
INSERT INTO cubNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara, ne d̶aiye boje põeva ne d̶arĩ majibede, obedivʉ põeva nʉvare nʉivʉ barejáimad̶a ijimarare ne parainoai, jũarajivʉ náre tãibʉai, Pedro nore vaiyʉ́, ʉ̃i decocʉque ʉ̃i taoquiyepe aivʉ apevʉ ijimaracavʉre, ne meatenajiyepe aivʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Aru apeno ĩmajinoacavʉ obedivʉ eare nʉivʉ barejáimad̶a Jerusalén ãmicʉriĩmaroi. Na máre ijimarare, aru abujuva ne ĩmamarare máre, nʉvare nʉivʉ barejáimad̶a. Aru caivʉ ne nʉvaimara mácavʉ mead̶aimara marejáimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Dinʉmʉ ñai sacerdotevare jaboteipõecʉ aru ʉ̃́re cad̶ateipõeva, caivʉ ina saduceo ãmicʉriyajubocavʉ, pare jorojĩnejaimad̶a Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare. Que baru ina saduceovacavʉ maucʉvarĩ bʉ́rejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Náre jẽicõjeni, bʉorejaimad̶a ãmeina teivʉre jẽni jacoiñami. ");
INSERT INTO cubNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ʉbenita diñamimiareca cũinácʉ Jʉ̃menijicʉi daroimʉ, ángele earĩ ne yebai, voacarĩ náre diñami jedevacobede, jipocatedejamed̶a náre nore jocarĩ. Que teni arejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Jʉ̃menijicʉi cʉ̃rami nʉjara mʉja. Aru coyʉjarã põevare nore caiye iye yávaiye méne jãravʉ cũiméjãravʉ baquinóre, arejamed̶a ñai ángele náre. ");
INSERT INTO cubNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ʉ̃́re jʉ arĩ, miad̶áe tʉiyede Jʉ̃menijicʉi cʉ̃rami ecorĩ, bueni bʉ́rejaimad̶a. Dinʉmʉmia ñai sacerdotevare jaboteipõecʉ ʉ̃́re cad̶ateipõevaque órejaicõjenejaimad̶a caivʉ judíova bʉcʉvare, ne cójijinajiyepe aivʉ caivʉre. Que teniburu, apevʉ ne coreipõevacavʉre davaicõjenidurejaimad̶a Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare ãmeina teivʉre jẽni jacoiñamine jocarĩ ne cójijinoita. ");
INSERT INTO cubNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ʉbenita ina coreipõeva ne eaiyede ãmeina teivʉre jẽni jacoiñami, nore eabedejaimad̶a ina Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare. Que teni cójijinoi copainʉri, yópe arĩ, coyʉrejaimad̶a ina cójijinocavʉre: ");
INSERT INTO cubNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Ñʉje eaiyede ãmeina teivʉre jẽni jacoiñami, jedevacobe me bieicobede eavʉ ñʉja. Aru churarava núrivʉ jedevacobe yebai coreivʉre máre eavʉ ñʉja. Ʉbenita jedevacobede ne voaiyede, eabetevʉ ina bʉoimara mácavʉre, arejaimad̶a ina coreipõeva. ");
INSERT INTO cubNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ne coyʉiyede jápiaivʉ bácavʉ Jʉ̃menijicʉi cʉ̃ramine coreipõevai jabocʉ aru sacerdotevare jaboteipõeva máre pare cãrijini, “¿Aipe tedica na cari?” arĩ dápiarejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Dinʉmʉmia cũinácʉ ʉ̃mʉ ecorĩ ne cójijitucubʉi arejamed̶a: —Jápiajarã yʉre. Ina mʉje ẽnoare bʉoimara mácavʉ caride Jʉ̃menijicʉi cʉ̃rami jívʉi núri bueivʉbu põevare noi, arejamed̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Aru coreóvarĩ ã́ri cʉrivʉre, ñai jabocʉ nʉrejamed̶a Jʉ̃menijicʉi cʉ̃rami ina coreipõevaque, ne nʉvarajiyepe ayʉ Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare cójijinoi. Ʉbenita náre ãmeno d̶abevʉva nʉvarejaimad̶a, põevare ne jidʉé boje. “Ñʉje ãmeno d̶aru náre, põeva cʉ̃raboaque dʉvarĩ boarã́jarama ñʉjare”, arĩ dápiarejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ne eaiyede ne cójijitucubʉi, núicõjenejaimad̶a ne bʉoimarare ina cójijinocavʉ ne coricai. Sacerdotevare jaboteipõecʉ, yópe arĩ, jararejamed̶a náre: ");
INSERT INTO cubNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ñʉjavacari parʉrõreca bueicõjemeniduvʉ mʉjare ãñʉ ʉ̃mʉ ʉ̃i borore. ¡Ʉbenita mʉja jʉ abevʉ ñʉjare! Bueivʉbu mʉja mʉje bueiyede obedivʉre, caino Jerusalẽ́cavʉre. Náre coyʉiyʉvʉ mʉja, “Sacerdoteva boarĩ́ jarʉvaicõjema Jesúre”, aivʉbu mʉja, põeva ne ãmeina jã́rajiyepe aivʉ ñʉjare, arejamed̶a sacerdotevare jaboteipõecʉ. ");
INSERT INTO cubNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedrocapũravʉ apevʉ Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimaraque arejaimad̶a ʉ̃́re: —Jʉ aiye jaʉvʉ ñʉjare Jʉ̃menijicʉ ʉ̃i d̶aicõjeiyede põeva ne d̶aicõjeiye pʉeno. ");
INSERT INTO cubNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mʉjavacari Jesúre pẽvari boarĩ́ jarʉvaicõjeavʉ jocʉcʉjaravena. Ʉbenita Jʉ̃menijicʉcapũravʉ, majeñecuva mácavʉ ne jabocʉ, nacovaquemavʉ ʉ̃́re yainore jarʉvarĩ. ");
INSERT INTO cubNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Aru nacovariburu yóboi, Jʉ̃menijicʉ epequemavʉ ʉ̃́re ʉ̃i meapũravʉi. Ñai meapũravʉi cʉcʉ parʉéde cʉvabi. Que baru Jesúrecabe maje jabocʉ aru majare mead̶aipõecʉ máre, Israecavʉ chĩori ne ãmeina teiyede, oatʉvarĩ bʉojarãjiyepe ayʉ ne d̶aiyede, aru Jʉ̃menijicʉ ʉ̃i ãrʉmetequiyepe ayʉ ne ãmeina teiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ñʉje jã́iye báque boje Jʉ̃menijicʉ ʉ̃i d̶aiye báquede Jesúre, coyʉivʉbu mʉjare iyede. Ñai Espíritu Santo máre coyʉyʉbe Jʉ̃menijicʉi d̶aiye báquede. Aru Jʉ̃menijicʉ daroyʉbe ñai Espíritu Santore caivʉ ina jʉ aivʉre ʉ̃́re, arejaimad̶a Pedrojã. ");
INSERT INTO cubNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ne coyʉiyede jápiaivʉ ina cójijinocavʉ, pare jararejaimad̶a Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare. Ne náre pare jaraiye boje, “Boarĩ́ jarʉvaicõjenajarevʉ náre”, arejaimad̶a ina cójijinocavʉ ne bajumia. ");
INSERT INTO cubNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ʉbenita cũinácʉ cójijinocacʉ, fariseovacacʉ, ʉ̃i ãmiá Gamaliel, nacajari, coreipõevare nʉvaicõjenejamed̶a Pedrojãre cójijitucubʉre jocarĩ. Caivʉ põeva me pued̶arejaimad̶a ʉ̃́re, Gamaliede. ");
INSERT INTO cubNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Pedrojã ne etarĩburu yóboi, Gamaliel yópe arĩ, coyʉrejamed̶a apevʉ cójijinocavʉre: —Mʉja, jívʉ, Israecavʉ, me dápiajarã mʉje d̶aiyʉede ina ʉ̃mʉvare. ");
INSERT INTO cubNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ãrʉjara mʉja ãñʉ Teudas bácʉ ʉ̃i d̶aino mácarõre obediʉjʉa jipocai. “Parʉcʉbu yʉ. Me jabotequijivʉ mʉjare”, arejamed̶a ʉ̃ mácʉ põevare. Aru cuatrocientos paivʉ ʉ̃mʉva baju nʉrejaimad̶a ʉ̃́que. Ʉbenita ne boarĩ́ jarʉvaiyede ʉ̃ mácʉre, ʉ̃́que nʉivʉ bácavʉ coateni nʉrejaimad̶a na. Que teni ʉ̃ mácʉi d̶aiye báque bíjarejavʉ̃ya. ");
INSERT INTO cubNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","No yóboi, nopedecabu apecʉ ʉ̃i d̶aino mácarõ, ãñʉ Galileacacʉ bácʉ, ʉ̃i ãmiá Judas. Jabocʉi toivaicõjeinʉmʉ põevare ne ãmiáre, corevaiyʉcʉ náre, obedivʉ põeva nʉrejaimad̶a ʉ̃́que máre. Aru ʉ̃́re máre ne boarĩ́ jarʉvaiyede, ʉ̃́que nʉivʉ bácavʉ coateni nʉrejaimad̶a na. ");
INSERT INTO cubNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nopedecabu caride ina ʉ̃mʉvaque. Coyʉyʉbu mʉjare: D̶abejarã ãmeno náre. Cãrijovamejara náre. Põeva ne d̶aicõjenu iye ne d̶aiyʉe aru ne bueiye máre, bíjaquiyebu die. ");
INSERT INTO cubNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ʉbenita Jʉ̃menijicʉ ʉ̃i d̶aicõjenu iye ne d̶aiyʉe aru ne bueiye máre, bíjabequiyebu die. Mʉja maucʉvarivʉ baru náre, maucʉvajebu Jʉ̃menijicʉre máre, arejamed̶a Gamaliel. Aru ina cójijinocavʉ jʉ arejaimad̶a ʉ̃i coyʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Que arĩ, ina coreipõevare davaicõjenejaimad̶a Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimarare cójijitucubʉi cojedeca. Ne eaiyede, ina coreipõevare jara popeicõjenejaimad̶a náre, Pedrojãre. Aru jara popeniburu yóboi, ina jabova yávaicõjemenidurejaimad̶a Pedrojãre cojedeca Jesúi borore. Que teniburu yóboi, jaetovarejaimad̶a náre. ");
INSERT INTO cubNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Aru Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimaracapũravʉ torojʉrivʉ baju etarejaimad̶a cójijinore jocarĩ. Torojʉrejaimad̶a ne cʉyoje teni ñájiye boje, ne jʉ aiye boje Jesúre. ");
INSERT INTO cubNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Aru caijãravʉa Jʉ̃menijicʉi cʉ̃rami aru ne cʉ̃ramiai máre buede nʉivʉ barejáimad̶a, aru coyʉre nʉivʉ barejáimad̶a na iye yávaiye méne Jesúrã, Jʉ̃menijicʉi epeimʉ mácʉrã. ");
INSERT INTO cubNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","No yóboi, apevʉ obedivʉ Jesúre jʉ aipõeva jararĩ jũjuvaivʉ barejáimad̶a ne bajumia. Nácavʉ griego ãmicʉricamuare yávaivʉ aru apevʉ nácavʉ hebreo ãmicʉricamuare yávaivʉ jaraivʉ barejáimad̶a ne baju. Ina judíova griegore yávaivʉ arejaimad̶a: —Ñʉjacavʉ nomiópeva jacopʉbema mʉje coavaiyede jãravʉa coapa. Que baru, “Mʉja coapavabevʉ”, chĩoivʉ arejaimad̶a. ");
INSERT INTO cubNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Que baru ina doce paivʉ Jesús ʉ̃i yávaiye méne beorĩ coyʉicõjeimara órejarĩ caivʉ ina Jesúre jʉ aipõevare ne yebai arejaimad̶a: —Ñʉje dajocaru Jʉ̃menijicʉi yávaiye méne coyʉiyede, jínajivʉ nomiópevare aru apevʉ cõmaje ãrojarivʉre máre náre jaʉéde, meamejebu no. ");
INSERT INTO cubNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Que baru mʉja, ñʉjevʉ, beojarã siete paivʉ mʉjacavʉre. Yópe bajarã́ri na: Põeva ne pued̶aimara, Espíritu Santo ʉ̃i d̶aicõjeimara, aru majiéde cʉvarivʉ bajarã́ri. Ñʉja náre coapavaicõjenajivʉbu cõmaje ãrojarivʉre. ");
INSERT INTO cubNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Que teni ñʉjacapũravʉ cũinátʉrʉ ñʉje ũme jẽniarajivʉbu Jʉ̃menijicʉque aru coyʉrãjivʉbu ʉ̃i yávaiye méne, arejaimad̶a na, Pedrojã. ");
INSERT INTO cubNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ne coyʉiye cojʉrejavʉ̃ya caivʉ ina Jesúre jʉ aipõevare. Que baru beorejaimad̶a Estebãre. Ʉ̃ parʉrõreca jʉ ayʉ barejámed̶a Jesúre. Aru ñai Espíritu Santo d̶aicõjenejamed̶a ʉ̃́re. Beorejaimad̶a apevʉre máre: Felipede, Prócorore, Nicanore, Timóre, Parmenare, aru Nicoláre máre. Ñai Nicolás Antioquía ãmicʉriĩmarocacʉ barejámed̶a. Ʉ̃ judío ãmenejamed̶a. Ʉbenita jipocamia jʉ arejamed̶a ina judíova ne bueiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Náre beorĩ bʉojarĩ, nʉvarejaimad̶a náre Jesús ʉ̃i yávaiye méne coyʉicõjeimara yebai, ne jẽniacarãjiyepe aivʉ náre Jʉ̃menijicʉque, tʉorĩ pʉrʉáque ne jipobʉrã náre coapa yópe judíova ne d̶arĩ cõmajiyepe, jã́d̶ovarajivʉ ne memeino bʉiyede. ");
INSERT INTO cubNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aru apevʉ põeva obedivʉ Jʉ̃menijicʉi yávaiye méne coyʉiyede jápiarĩ, jʉ arejaimad̶a diede. Caijãravʉa apevʉ ne jʉ aiyede pʉeno baju obedivʉ jʉ aivʉ nʉrejaimad̶a Jerusalén ãmicʉriĩmaroi. Aru apevʉ ina sacerdoteva máre jʉ arejaimad̶a Jesús ʉ̃i yávaiye méne. ");
INSERT INTO cubNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban Jʉ̃menijicʉi mearo d̶acaimʉ marejámed̶a. Jʉ̃menijicʉ me jã́rejaquemavʉ ʉ̃́re. Que baru parʉre d̶arejaquemavʉ ʉ̃́re. Aru majide d̶arejaquemavʉ ʉ̃́re máre. Esteban d̶are cuyʉ barejámed̶a ʉrarõ põeva ne jã́mene, ne d̶arĩ majibede máre, põeva jẽneboi. ");
INSERT INT