﻿USE sofia;
DROP TABLE IF EXISTS sofia.ctuBl_vpl;
CREATE TABLE ctuBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ctuBl_vpl WRITE;
INSERT INTO ctuBl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiñʌch jun ba' ts'ijbubil i c'aba' tac i ñojte'el Jesucristo. Jesucristo loq'uem ti' p'olbal David yic'ot ti' p'olbal Abraham. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I yalobil Abraham jiñʌch Isaac. I yalobil Isaac jiñʌch Jacob. I yalobilob Jacob jiñobʌch Judá yic'ot i yerañob. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","I yalobilob Judá yic'ot xTamar i yijñam Judá, jiñobʌch Fares yic'ot Zara. I yalobil Fares jiñʌch Esrom. I yalobil Esrom jiñʌch Aram. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","I yalobil Aram jiñʌch Aminadab. I yalobil Aminadab jiñʌch Naasón. I yalobil Naasón jiñʌch Salmón. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","I yalobil Salmón yic'ot xRahab, jiñʌch Booz. Jini xRahab i yijñam Salmón. I yalobil Booz yic'ot xRut jiñʌch Obed. Jini xRut i yijñam Booz. I yalobil Obed jiñʌch Isaí. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","I yalobil Isaí jiñʌch David jini ñuc bʌ yumʌl. Salomón jiñʌch i yalobil David yic'ot i yijñam yambʌ winic i c'aba' Urías. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","I yalobil Salomón jiñʌch Roboam. I yalobil Roboam jiñʌch Abías. I yalobil Abías jiñʌch Asa. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","I yalobil Asa jiñʌch Josafat. I yalobil Josafat jiñʌch Joram. I yalobil Joram jiñʌch Ozías. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","I yalobil Ozías jiñʌch Jotam. I yalobil Jotam jiñʌch Acaz. I yalobil Acaz jiñʌch Ezequías. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","I yalobil Ezequías jiñʌch Manasés. I yalobil Manasés jiñʌch Amón. I yalobil Amón jiñʌch Josías. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","I yalobil Josías jiñʌch Jeconías yic'ot i yijts'iñob ti' yorajlel che' bʌ tsa' wersa pʌjyiyob majlel ti Babilonia. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Che' bʌ pʌjyemobix majlel ti Babilonia, tsi' yila pañimil i yalobil Jeconías, jiñʌch Salatiel. I yalobil Salatiel jiñʌch Zorobabel. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","I yalobil Zorobabel jiñʌch Abiud. I yalobil Abiud jiñʌch Eliaquim. I yalobil Eliaquim jiñʌch Azor. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","I yalobil Azor jiñʌch Sadoc. I yalobil Sadoc jiñʌch Aquim. I yalobil Aquim jiñʌch Eliud. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","I yalobil Eliud jiñʌch Eleazar. I yalobil Eleazar jiñʌch Matán. I yalobil Matán jiñʌch Jacob. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","I yalobil Jacob jiñʌch José i ñoxi'al María, tsa' bʌ i yʌc'ʌ ti pañimil alʌl i c'aba' Jesús, jiñʌch Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Che' jini, ti pejtelel i ñojte'elob Cristo c'ʌlʌl ti' yorajlel Abraham c'ʌlʌl ti David an chʌnlujunlajm (14) i ñojte'el. C'ʌlʌl ti' yorajlel David c'ʌlʌl che' bʌ tsa' pʌjyiyob majlel ti Babilonia an chʌnlujunlajm i ñojte'el. C'ʌlʌl che' bʌ tsa' pʌjyiyob majlel ti Babilonia c'ʌlʌl ti' yorajlel Cristo an chʌnlujunlajm i ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Che' bajche' jini tsi' yila pañimil Jesucristo. C'ajtibilix María, i ña' Jesús, i cha'an José. Che' maxto anic tsi' pi'leyob i bʌ, cʌntʌbil i cha'an alʌl cha'an Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Toj i pusic'al jini José, i ñoxi'al María. Mach yomic i yʌc' ti quisin. Jini cha'an tsi' ña'ta i mucu cʌy. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Che' bʌ woli' ña'tan ti' pusic'al, awilan, tsa' tsictiyi i yángel lac Yum ti' ñajal. Jini ángel tsi' yʌlʌ: José i yalobilet bʌ David, mach ma' bʌc'ñan a pʌy María cha'an a wijñam, come jiñʌch Ch'ujul bʌ Espíritu tsa' bʌ i yʌq'ue i yalobil María mu' bʌ caj ti tsictiyel. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mi caj i yʌc' ti pañimil alʌ ch'iton. Yom ma' wotsʌben i c'aba' Jesús, come jini mi caj i coltan winicob x'ixicob i cha'año' bʌ cha'an mi' loq'uelob ti' p'ʌtʌlel i mul. Che' tsi' yʌlʌ jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Che'ʌch tsa' ujti cha'an mi' ts'ʌctiyel i t'an lac Yum tsa' bʌ i yʌlʌ ti' yej x'alt'an: ");
INSERT INTO ctuBl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Awilan, mi caj i cʌntan alʌl juntiquil xch'oc maxto bʌ pi'lebilic. Mi caj i yʌc' ti pañimil ch'iton bʌ i yalobil. Mi caj i yotsʌbentel i c'aba' Emanuel”. An i sujmlel Emanuel ti lac t'an: Jiñʌch Dios la quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Che' bʌ ch'ojyemix ti wʌyel, José tsi' cha'le che' bajche' tsi' sube ti mandar i yángel lac Yum. Tsi' pʌyʌ i yijñam. ");
INSERT INTO ctuBl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ma'anic tsi' pi'le jinto tsi' yila pañimil ch'iton bʌ i yalobil. Tsi' yotsʌbe i c'aba' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Che' bʌ tsi' yila pañimil Jesús ya' ti Belén ti Judea, che' yumʌl jini Herodes, awilan, tsa' tiliyob ti Jerusalén winicob año' bʌ cabʌl i ña'tʌbal, ch'oyolo' bʌ ti' pasibal q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tsi' yʌlʌyob: ¿Baqui an i yum judíojob tsa' bʌ i yila pañimil? Come tsaj q'uele lojon i yec' ti' pasibal q'uin. Tsa' tiliyon lojon cha'an mic ch'ujutesan lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jini yumʌl Herodes che' bʌ tsi' yubi, tsi' mele i pusic'al yic'ot pejtelel winicob x'ixicob ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Che' bʌ tsi' tempa pejtelel ñuc bʌ motomajob yic'ot sts'ijbayajob, tsi' c'ajtibeyob baqui mi caj i yilan pañimil jini Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tsi' jac'beyob: Ya' ti Belén ti Judea. Come che'ʌch ts'ijbubil i cha'an x'alt'an: ");
INSERT INTO ctuBl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Jixcu jatetla añet bʌ la ti Belén ya' ti' lumal Judá, mach yoque ch'o'ch'o'queticla ti' tojlel i yumob Judá. Come ti la' tojlel mi' caj ti loq'uel juntiquil yumʌl mu' bʌ caj i cʌntan israelob c cha'año' bʌ”. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jini Herodes mucul jach tsi' pʌyʌ tilel jini winicob año' bʌ cabʌl i ña'tʌbal. Tsi' c'ajtibeyob jinto tsi' na'ta baqui ora tsa' tsictiyi jini ec'. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tsi' chocoyob majlel ti Belén. Tsi' yʌlʌ: Cucula. Wersa sajcanla jini alʌl. Che' mi la' taj, yom mi la' cha' tilel la' subeñon cha'an mic majlel c ch'ujutesan ja'el, che'en Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Che' bʌ tsa' ujti i yubiñob i t'an tsa' majliyob. Awilan, jini ec' tsa' bʌ i q'ueleyob ti' pasibal q'uin tsi' cha'le xʌmbal majlel ti' wutob. Tsi' cʌyʌ i xʌmbal ec' ya' ti' chañelal ba'an jini alʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Che' bʌ tsi' q'ueleyob jini ec', c'ax tijicña jax i pusic'al tsi' yubiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Che' bʌ tsa' caji i yochelob ti otot, tsi' q'ueleyob alʌl yic'ot María i ña'. Tsi ñocchocoyob i bʌ. Tsi' ch'ujutesayob. Tsi' jamʌyob caxate'. Tsi yʌq'ueyob i majtan: oro, yic'ot xojocña bʌ pom, yic'ot mirra. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Subebilobix jini winicob ti' ñajal cha'an ma'anic mi' chʌn ñumelob ba'an Herodes, tsa' sujtiyob majlel ti' lumal ti yambʌ bij. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Che' sujtemobix jini winicob, awilan, tsa' tsictiyi i yángel lac Yum ti' ñajal José. Jini ángel tsi' yʌlʌ: Ch'ojyen. Pʌyʌ majlel jini alʌl yic'ot i ña'. Puts'en ti Egipto. Cʌlejen ya'i jinto mic subeñet, come Herodes mi caj i sajcan alʌl cha'an mi' tsʌnsan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tsa' ch'ojyi José. Tsi' pʌyʌ majlel alʌl yic'ot i ña' ti ac'ʌlel. Tsa' majli ti Egipto. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya'i tsa' cʌle jinto tsa' chʌmi Herodes. Che'ʌch tsa' ujti cha'an mi' ts'ʌctiyel i t'an lac Yum tsa' bʌ i yʌlʌ ti' yej x'alt'an: “Tsac pʌyʌ loq'uel calobil ti Egipto”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tsa' caji ti cabʌl mich'ajel jini Herodes che' bʌ tsi' ña'ta tsa'ix lotinti cha'an jini winicob año' bʌ cabʌl i ña'tʌbal. Tsi' yʌc'ʌ mandar cha'an mi' tsʌnsʌntelob pejtelel alʌ ch'itoñob maxto bʌ ts'ʌcʌlic cha'p'ejl i jabilel ya' bʌ añob ti Belén yic'ot ti' joytilel. Ña'tʌbilix i cha'an Herodes jayp'ejl i jabilel jini alʌl, come tsa' subenti cha'an jini winicob cabʌl bʌ i ña'tʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Che' jini tsa' ts'ʌctiyi i t'an jini x'alt'an Jeremías tsa' bʌ i yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tsa' ubinti c'am bʌ t'an ya' ti Ramá, cabʌl uq'uel yic'ot we'ecña bʌ uq'uel. xRaquel woli' chʌn uc'tan i yalobilob. Ma'anic tsi' jac'ʌ i ñʌch'chocontel i pusic'al come tsa' jiliyob i yalobil”. Che' tsi' yʌlʌ jini x'alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Che' bʌ tsa' chʌmi Herodes, awilan ya' ti Egipto tsa' tsictiyi i yángel lac Yum ti' ñajal José. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tsi' yʌlʌ: Ch'ojyen. Pʌyʌ majlel jini alʌl yic'ot i ña'. Cucu ti' lumal Israel come chʌmeñobix jini yomo' bʌ i tsʌnsan alʌl, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jini tsa' ch'ojyi. Tsi' pʌyʌ majlel alʌl yic'ot i ña'. Ya' tsa' c'oti ti' lumal Israel. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","José tsi' bʌc'ña majlel ya' ti Judea, come tsi' yubi woli ti yumʌntel Arquelao i yalobil Herodes. Jini Arquelao tsi' ch'ʌmbe i ye'tel i tat. Jini cha'an tsa' majli ti' lumal Galilea che' bajche' subebilix ti' ñajal. ");
INSERT INTO ctuBl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tsa' c'oti ti chumtʌl ti jump'ejl tejclum i c'aba' Nazaret cha'an mi' ts'ʌctiyel i t'an jini x'altañob: “Mi caj i sujbel ti nazareno, che'ob”. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti jim bʌ ora tsa' tili Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'. Woli' cha'len subt'an ti jochol bʌ lum ti Judea. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tsi' yʌlʌ: Cʌyʌx la' mul come lʌc'ʌlix i yumʌntel jini am bʌ ti panchan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Come jiñʌch jini Juan tsa' bʌ tajle ti' t'an jini x'alt'an Isaías che' bʌ tsi' yʌlʌ: “I t'an juntiquil winic mu' bʌ i cha'len c'am bʌ t'an ti jochol bʌ lum: Chajpanla i bijlel lac Yum. Pʌtʌla majlel mucubij i cha'an”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jini Juan lʌpʌl i cha'an i pʌchʌlel camello. An i cajchiñʌc' melbil bʌ ti pʌchi. Juan tsi' c'uxu sajc' yic'ot te'lechab. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tsa' loq'uiyob tilel ba'an Juan jini ch'oyolo' bʌ ti Jerusalén yic'ot ti pejtelel Judea yic'ot ti' joytilel Jordán ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Juan tsi' yʌq'ueyob ch'ʌmja' ya' ti Jordán ja'. Jini winicob x'ixicob tsi' subuyob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Che' bʌ tsi' q'uele woli' tilelob cabʌl fariseojob yic'ot saduceojob cha'an mi' ch'ʌmob ja', Juan tsi' subeyob: I yalobiletla xc'ʌñʌñej. ¿Majqui tsi' subeyetla cha'an mi la' puts'tan jini tojmulil mu' bʌ i tilel? ");
INSERT INTO ctuBl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Melela toj bʌ la' melbal mi woli la' cʌy la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mach mi la' wʌl ti la' pusic'al: “C tat lojon jiñʌch Abraham”, che'etla. Come mic subeñetla, Dios mi mejlel i pʌntesan jini xajlel tac ti' yalobilob Abraham. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Wʌle ac'bil hacha ti' yebal te'. Mi' sejq'uel pejtelel jini te' mach bʌ anic mi' yʌc' wen bʌ i wut. Mi' chojquel ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Joñon mi cʌq'ueñetla ch'ʌmja' cha'an mi la' cʌy la' mul. Tal to tic pat ñumen p'ʌtʌl bʌ. Joñon mach yoque ñuconic cha'an mic yeben majlel i xʌñʌb. Jiñʌch mu' bʌ caj i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ Espíritu yic'ot c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","An i wejlʌjib ti' c'ʌb. Mi' wen wejlan i yajñib trigo. Mi' lot jini trigo ti' yotlel. Mi caj i pulben i sujl ti c'ajc mach bʌ yujilic yajpel. Che' tsi' yʌlʌ Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tsa' loq'ui tilel Jesús ti Galilea. Tsa' c'oti ti Jordán ja' ba'an Juan cha'an mi' ch'ʌm ja' ti' c'ʌb Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan tsi' ñopo i tic'. Tsi' yʌlʌ: Yom ma' wʌq'ueñon ch'ʌmja' jatet. ¿Mu' ba a tilel a ch'ʌm ja' ba' añon? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús tsi' sube Juan: La' aq'uenticon ch'ʌmja' wʌle. Come che' yom mi lac cha'len cha'an mi lac ts'ʌctesan pejtelel chuqui toj, che'en. Tsi' jac'ʌ i yʌq'uen che' bajche' tsi' yʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Che' bʌ tsa'ix i ch'ʌmʌ ja' Jesús tsa' loq'ui ti ja'. Awilan, tsa' cajli panchan. Tsi' q'uele i yEspíritu Dios woli' jubel tilel che' bajche' x'ujcuts. Tsa' t'uchle ti Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Awilan, tsa' loq'ui tilel t'an ti panchan. Tsi' yʌlʌ: Jiñʌch Calobil mu' bʌ j c'uxbin. Wen uts'at mij q'uel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jini Espíritu tsi' pʌyʌ majlel Jesús ti colem bʌ i tiquiñal lum cha'an mi' yilʌbentel i pusic'al ti xiba. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma'anic chuqui tsi' c'uxu cha'c'al q'uin cha'c'al ac'ʌlel. Tsa' caji i yubin wi'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tsa' tili jini xpʌy mulil ya' ba'an Jesús. Tsi' sube: Mi i Yalobilet Dios, suben jini xajlel tac cha'an mi' pʌntʌyel ti waj, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús tsi' sube: Ts'ijbubil: “Mach cuxulobic winicob x'ixicob cha'an jach waj pero ti jujump'ejl t'an mu' bʌ i loq'uel ti' yej Dios”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jini xiba tsa' caji i pʌy majlel Jesús ti ch'ujul bʌ tejclum. Ya' tsi' pʌyʌ ti wa'tʌl ti' pam i jol Templo. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tsi' sube: Mi i Yalobilet Dios, choco jubel a bʌ come ts'ijbubil: “Mi caj i subeñob i yángelob cha'an mi' cʌntañet. Mi caj i chuquet ti' c'ʌb, ame a jats' a woc ti xajlel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús tsi' yʌlʌ: Ts'ijbubil ja'el: “Mach yomic ma' wilʌben i pusic'al a Yum Dios”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ti wi'il jini xiba tsi' pʌyʌ majlel ti wen chan bʌ wits. Tsi' laj pʌsbe pejtelel i yumʌntel tac jini yumʌlob ti pañimil yic'ot i ñuclel. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tsi' sube: Muq'uic a ñocchocon a bʌ a ch'ujutesañon, mi cʌq'ueñet ti pejtelel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jesús tsi' sube: Cucu, Satanás, come ts'ijbubil: “Yom ma' ch'ujutesan a Yum Dios. Cojach jini yom ma' yuman”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jini xiba tsi' cʌyʌ Jesús. Awilan, tsa' tili ángelob i coltañob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Che' bʌ tsi' yubi ya'an Juan ti mʌjquibʌl, Jesús tsa' majli ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Che' bʌ tsa' loq'ui ti Nazaret tsa' majli ti chumtʌl ti Capernaum am bʌ ti' ti' colem ñajb lʌc'ʌl ti Zabulón yic'ot ti Neftalí. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Che' jini tsa' ts'ʌctiyi jini tsa' bʌ i yʌlʌ jini x'alt'an Isaías: ");
INSERT INTO ctuBl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jini winicob x'ixicob año' bʌ ti' lumal Zabulón, yic'ot ya' ti' lumal Neftalí, yic'ot ya' ti' ti' colem ñajb, yic'ot ya' ti junwejl Jordán ja', yic'ot ti Galilea i lumal gentilob, ");
INSERT INTO ctuBl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","jini winicob x'ixicob año' bʌ ti ic'ch'ipan bʌ pañimil tsi' q'ueleyob colem bʌ i sʌclel pañimil. Tsa' caji ti tilel i sʌclel pañimil ba'an jini año' bʌ ti ac'ʌlel woli bʌ i chʌmelob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti jim bʌ ora tsa' caji ti subt'an Jesús. Tsi' yʌlʌ: Cʌyʌx la' mul come lʌc'ʌlix i yumʌntel jini am bʌ ti panchan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Che' woli ti xʌmbal ti' ti' ñajb i c'aba' Galilea, Jesús tsi' q'uele cha'tiquil winicob, Simón am bʌ i cha'chajplel i c'aba' Pedro, yic'ot i yijts'in Simón i c'aba' Andrés. Woli' chocob ochel i chimo'chʌy ya' ti ñajb, come xchuc chʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tsi' subeyob: La'la tsajcañon. Mi caj c meletla ti xchuc winicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsi' bʌc' cʌyʌyob i chimo'chʌy. Tsi' tsajcayob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Che' bʌ woli to i ts'ita' xʌn majlel Jesús, tsi' q'uele yambʌ cha'tiquilob, Jacobo i yalobil Zebedeo, yic'ot i yijts'in Jacobo i c'aba' Juan. Ya' añob ti barco yic'ot i tat i c'aba' Zebedeo. Woli' cha' ts'isob i chimo'chʌy. Jesús tsi' pʌyʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tsi' bʌc' cʌyʌyob i tat yic'ot jini barco. Tsi' tsajcayob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús tsa' ñumi majlel ti pejtelel Galilea. Tsi' cha'le cʌntesa ti' sinagoga tac judíojob. Tsi' subu jini wen t'an cha'an i yumʌntel Dios. Tsi' lu' lajmesa pejtelel c'amʌjel yic'ot chʌmel tsa' bʌ i yubiyob winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ya' ti pejtelel Siria tsa' caji i yubiñob ñuc bʌ i melbal Jesús. Tsi' pʌyʌyob tilel pejtelel xc'amʌjelob woli bʌ i yubiñob leco tac bʌ i chʌmel, yic'ot cabʌl i wocol yic'ot jini am bʌ i xibʌjlel yic'ot juquin chʌmel, yic'ot jini mach bʌ añobic i c'ʌjñibal i yoc i c'ʌb. Tsi' lu' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tsi' tsajcayob majlel Jesús cabʌl winicob x'ixicob ch'oyolo' bʌ ti Galilea, ti Decápolis, ti Jerusalén, ti Judea yic'ot jini ch'oyolo' bʌ ti junwejl Jordán ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Che' bʌ tsi' q'uele tempʌbilo' bʌ winicob x'ixicob, Jesús tsa' letsi majlel ti bujtʌl. Che' buchulix Jesús, tsa' tiliyob xcʌnt'añob i cha'an ba'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tsa' caji ti t'an. Tsa' caji i cʌntesañob. Tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tijicña jini mu' bʌ i ña'tañob ma'anic i bajñel wenlel ti' pusic'al, come i cha'añob i yumʌntel jini am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tijicñayob jini woliyo' bʌ ti uq'uel, come muq'uix i ñuq'uesʌbentelob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tijicñayob jini pec' bʌ mi' melob i bʌ, come mi caj i yʌq'uentelob pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tijicñayob jini año' bʌ i wi'ñal i pusic'al yic'ot i tiquin ti' cha'an chuqui toj, come mi caj i bujt'esʌntelob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tijicñayob mu' bʌ i cha'leñob p'untaya, come mi caj i p'untʌntelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tijicñayob jini sʌc bʌ i pusic'al, come mi caj i q'uelob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tijicñayob jini mu' bʌ i ñʌch'chocoñob xleto, come mi caj i sujbelob ti' yalobil Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tijicñayob jini mu' bʌ i tic'lʌntelob cha'an chuqui toj, come i cha'añob i yumʌntel jini am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tijicñayetla che' mi' ts'a'leñetla winicob che' mi' tic'lañetla, che' mi' pʌq'uetla ti jujunchajp jontolil cha'an tsa' la' ñopoyon. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","La' ñuc'ac la' pusic'al. Melela ti tijicña la' pusic'al, come ñuc la' chobejtʌbal ti panchan, come che' ja'el tsi' tic'layob x'alt'añob wajali. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jatetla i yʌts'miletla pañimil. Mi tsa' sajti i tsajel ats'am, ¿bajche' mi caj i cha' tsaj'esʌntel? Ma'anix i c'ʌjñibal. Mi lac choc ba' mi' t'uchtañob majlel winicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jatetla i sʌcleletla pañimil. Mach mejlic ti mʌjquel tejclum wa'chocobil bʌ ti' jol wits. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Che' mi lac tsuc' candil ma'anic mi lac ñup' ti chiquib. Mi lac joc'chocon ti' joc'lib cha'an mi' pʌsbeñob i sʌclel pejtelel año' bʌ ti' mal otot. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Che' yom mi la' pʌsbeñob winicob x'ixicob la' sʌclel yic'ot wen bʌ la' we'tel. Che' mi' q'uelob mi caj i tsictesañob i ñuclel la' Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mach mi la' wʌl ti la' pusic'al tsa' tiliyon cha'an mic jisan ts'ijbubil bʌ mandar yic'ot i t'an x'alt'añob. Ma'anic tsa' tiliyon cha'an mic jisan. Tsa' tiliyon cha'an mic ts'ʌctesan i sujmlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Come isujm mic subeñetla, mach mejlic ti sujcuntel loq'uel mi jump'ejlic jota mi jump'ejlic punto ti jini mandar c'ʌlʌl ti' jilibal pañimil yic'ot panchan, c'ʌlʌl jinto mi' ts'ʌctiyel pejtelel i subal. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jini cha'an mi an majch mi' ñusan jump'ejl ch'o'ch'oc bʌ mandar, mi tsi' cʌntesa winicob cha'an mi' ñusañob ja'el, ma'anic mi caj i taj i ñuclel ti' yumʌntel panchan. Pero jini mu' bʌ i jac' jini mandar, mu' bʌ i cʌntesañob cha'an mi' jac'ob, mi caj i taj i ñuclel ti' yumʌntel jini am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Come mic subeñetla, mi mach ñumen tojic la' pusic'al bajche' sts'ijbayajob yic'ot fariseojob, ma'anic mi caj la' wochel ti' yumʌntel jini am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tsa'ix la' wubi jini tsa' bʌ subentiyob winicob ti wajali. Tsa' subentiyob: “Mach mi la' cha'len tsʌnsa. Jini mu' bʌ i cha'len tsʌnsa mi caj i taj i mul ti' wut año' bʌ i ye'tel”. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero joñon mic subeñetla, pejtel mu' bʌ i mich'leñob i bʌ mi caj i tajob i mul ti' wut año' bʌ i ye'tel. Jini mu' bʌ i wajlen i pi'ʌl, mi caj i taj i mul ti' wut año' bʌ i ye'tel. Jini mu' bʌ i suben sojquem i jol, mi caj i toj i mul ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Che' wola' wʌq'uen i majtan Dios ti' yajñib, mi tsa' c'ajtiyi a cha'an an chuqui tsa' cha'le ti' contra a pi'ʌl, ");
INSERT INTO ctuBl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","cʌyʌ i majtan Dios ti' t'ejl i yajñib. Cucu, ñaxan mele a bʌ a wic'ot a pi'ʌl. Ti wi'il la' aq'uen i majtan Dios ti' yajñib. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yom ma' bʌc' pejcan ti uts'at jini woli bʌ i contrajiñet che' wola' majlel ba'an melobʌjʌl ame cajic i yʌq'uet ti' c'ʌb xmel mulil. Jini xmel mulil mi caj i yʌq'uet ti' c'ʌb xcʌnta cárcel. Mi caj a wochel ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Isujm mic subeñet ma'anic mi caj a loq'uel ya'i jinto ma' toj. Ma'anic mi caj a cʌybentel mi jump'ejlic centavo. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tsa'ix la' wubi tsa' bʌ ajli: “Mach ma' cha'len ts'i'lel”. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero joñon mic subeñetla, majqui jach mi' q'uel x'ixic ti' colosojlel i pusic'al tsa'ix i cha'le ts'i'lel ti' pusic'al yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mi woli' yʌsañet ti mulil jini a wut am bʌ ti a ñoj, loc'san. Choco. Uts'at mi tsa' sajti jump'ejl a wut. Mach uts'atic mi tsa' chojquiyet ti c'ajc che' ts'ʌcʌl a bʌc'tal. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mi woli' yʌsañet ti mulil a c'ʌb am bʌ ti a ñoj, tsepe loq'uel. Choco. Uts'at mi tsa' sajti a c'ʌb. Mach uts'atic mi tsa' chojquiyet ti c'ajc che' ts'ʌcʌl a bʌc'tal. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tsa' ajli ja'el: “Che' an majqui yom i cʌy i yijñam, la' i yʌq'uen i juñilel cha'an tsiquil cʌybilix i cha'an”. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero joñon mic subeñetla majqui jach mi' to'o cʌy i yijñam che' ma'anic tsi' cha'le ts'i'lel yic'ot yambʌ winic, woli' bajñel ac' i yijñam ti ts'i'lel. Che' ja'el, majqui mi' pʌy cʌybil bʌ x'ixic cha'an i yijñam woli' cha'len ts'i'lel yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tsa'ix la' wubi chuqui tsa' subenti winicob ti wajali: “Mach ma' lon tajben i c'aba' Dios cha'an ma' wa'chocon a t'an. Mele ti ts'ʌcʌl chuqui ma' wʌl ti' tojlel Dios”. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero joñon mic subeñetla mach yomic ma' lon wa'chocon a t'an. Mach ma' lon taj ti t'an panchan come jiñʌch i buchlib Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mach ma' lon taj ti t'an pañimil come jiñʌch i yajñib i yoc Dios, mi i c'aba'ic Jerusalén come i tejclumʌch jini ñuc bʌ yumʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Che' ja'el mach ma' lon taj ti t'an a jol cha'an ma' wa'chocon a t'an, come mach mejlic ma' sʌq'uesan ma' wiq'uesan mi junt'ujmic. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Che' ma' cha'len t'an, mi isujmʌch, “isujm cu”, che'et. Che' mach isujmic, “mach isujmic”, che'et. Mi tsa' wʌlʌ yambʌ t'an cha'an ma' wa'chocon, ch'oyolʌch ti jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tsa'ix la' wubi tsa' bʌ ajli: “Wutʌl i q'uexol wutʌl, i bʌquel ejʌl i q'uexol i bʌquel ejʌl”. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero joñon mic subeñetla: Mach mi la' q'uextan jontolil. Che' an majqui mi' jats'et ti ñoj bʌ a choj pʌsben yambʌ a choj. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Che' an majqui mi' pʌyet ba'an am bʌ i ye'tel cha'an mi' chilbeñet a bujc, aq'uen a chaqueta ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mi an majqui mi' wersa pʌyet ti cuchijel jump'ejl legua, cucu a wic'ot cha'p'ejl legua. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aq'uen chuqui mi' c'ajtibeñet. Che' an chuqui mi' c'ajtibeñet ti majan, mach ma' to'o ac' ti sujtel. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tsa'ix la' wubi tsa' bʌ ajli: “C'uxbin a pi'ʌlob, ts'a'len a contra”. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero joñon mic subeñetla: C'uxbin la' contrajob. Tajala ti oración jini mu' bʌ i contrajiñetla yic'ot jini mu' bʌ i tic'lañetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Che' jini mi' tsictiyel i yalobiletla la' Tat am bʌ ti panchan. Come Dios woli' chʌn ac' ti pasel q'uin ti' tojlel jini tojo' bʌ i pusic'al yic'ot jontolo' bʌ ja'el. Che' ja'el woli' chʌn chocbeñob tilel ja'al jini tojo' bʌ i pusic'al yic'ot jontolo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Come mi jini jach c'ux woli la' wubin jini c'ux bʌ mi' yubiñetla, ¿uts'at ba ma' q'uejlel che' jini? ¿Mach ba che'ic mi' melob xch'ʌm tojoñelob ja'el? ");
INSERT INTO ctuBl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi jini jach mi la' wʌq'uen cortesía la' wermanojob, ¿ñumen toj ba mi la' mel bajche' yaño' bʌ? ¿Mach ba che'ic mi' cha'leñob gentilob ja'el? ");
INSERT INTO ctuBl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jini cha'an yom ts'ʌcʌl i yutslel la' pusic'al che' bajche' ts'ʌcʌl i yutslel i pusic'al la' Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Chʌcʌ q'uele la' bʌ cha'an mi la' mel chuqui toj, pero mach cojic jach ti' wut la' pi'ʌlob cha'an mi' q'ueletla, come che' jini ma'anic mi' yʌq'ueñetla la' chobejtʌbal la' Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Che' mi la' wʌq'uen la' chubʌ'an p'ump'uño' bʌ, mach mi la' wʌc' ti wustʌl majlel trompeta ti' tojel la' wut che' bajche' mi' cha'leñob ti sinagoga tac yic'ot ti calle tac jini cha'p'ejax bʌ i pusic'al cha'an mi' q'uejlelob ti ñuc ti' wut winicob x'ixicob. Isujm mic subeñetla tsa'ix i tajayob i chobejtʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Che' ma' wʌq'uen a chubʌ'an p'ump'uño' bʌ, mach ma' wʌc' ti q'uejlel jini woli bʌ a wʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ti mucul yom ma' wʌc' a chubʌ'an. Jini a Tat woli bʌ i q'uel pejtelel mucul tac bʌ mi caj i yʌq'ueñet a chobejtʌbal ti jamʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Che' ma' cha'len oración, mach a cha'len che' bajche' jini cha'chajp jax bʌ i pusic'al mu' bʌ i mulan i cha'leñob oración che' wa'alob ti sinagoga tac yic'ot ti' xujc calle cha'an mi' q'uejlelob. Isujm mic subeñetla tsa'ix i tajayob i chobejtʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero jatet, che' ma' cha'len oración, ochen ti' mal a wotot. Mʌcʌ i ti' a wotot. Pejcan a Tat am bʌ ti mucul. Jini a Tat woli bʌ i q'uel pejtelel mucul tac bʌ mi caj i yʌq'ueñet a chobejtʌbal ti jamʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Che' mi la' cha'len oración, mach mi la' chʌn taj lajal bʌ t'an cha'an ma' tam'esan a woración che' bajche' mi' cha'leñob gentilob. Mi' lon ña'tañob mi' yubintel i yoración cha'an cabʌl i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mach mi la' cha'len lajal bajche' jini gentilob, come yujil la' Tat chuqui anto yom la' cha'an che' maxto anic tsa' la' c'ajtibe. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Cha'lenla oración che' bajche' jini: C Tat lojon añet bʌ ti panchan, la' ch'ujutesʌntic a c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","La' tilic a yumʌntel. La' mejlic chuqui a wom ti pañimil che' bajche' ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aq'ueñon lojon c waj cha'an ili q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ñusʌbeñon lojon c mul che' bajche' mic ñusʌbeñob i mul c pi'ʌlob lojon. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Mach ma' wʌc'on lojon ba' mic pʌjyel lojon ti mulil. Cʌntañon lojon ame yajlicon lojon ti jontolil. Come a cha'añʌch a yumʌntel yic'ot a p'ʌtʌlel yic'ot a ñuclel ti pejtelel ora. Amén. Che' yom mi la' mel oración. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Come mi woli la' ñusʌben i mul la' pi'ʌlob, la' Tat ti panchan mi' ñusʌbeñetla la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero mi mach mi la' ñusʌbeñob i mul la' pi'ʌlob, ma'anic mi' ñusʌbeñetla la' mul la' Tat ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Che' ja'el che' woliyetla ti ch'ajb, mach mi la' mel ti ch'ijiyem la' wut che' bajche' jini cha'chajp jax bʌ i pusic'al. Leco mi' melob i wut cha'an mi' q'uejlelob che' woliyob ti ch'ajb. Isujm mic subeñetla, tsa'ix i tajayob i chobejtʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero jatet, che' woliyet ti ch'ajb boño a jol. Poco a wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Che' jini ma'anic mi' tsictiyel ti' wut winicob x'ixicob mi woliyet ti ch'ajb. Pero mi' tsictiyel ti' wut a Tat am bʌ ti mucul. Jini a Tat, mu' bʌ i q'uel pejtelel mucul tac bʌ, mi caj i yʌq'ueñet a chobejtʌbal ti jamʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mach mi la' tempan la' chubʌ'an ti pañimil ba' mi' jisan motso', ba' mi' caj ti ta', ba' mi' yochelob xujch' i xujch'iñob loq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tempan la' chubʌ'an ti panchan ba' ma'anic mi' jisan motso', ba' ma'anic mi' caj ti ta', ba' ma'anic mi' yochelob xujch' i xujch'iñob loq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Baqui jach tempʌbil la' chubʌ'an, mi la' teñe ac' ti la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jini lac wut lámparajʌch cha'an lac bʌc'tal. Mi weñʌch la' wut, mi la' wen q'uel i sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mi mach wenic la' wut, añet jach la ti ac'ʌlel. Mi i'ic' jax mi la' q'uel i sʌclel pañimil, añetla ti ic'yoch'an bʌ pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ma'anic x'e'tel mu' bʌ mejlel i yuman cha'tiquil yumʌl. Mi' ts'a'len juntiquil yumʌl, mi' c'uxbin yambʌ. Mi' jac'ben i t'an juntiquil, mi' ñusʌben i t'an yambʌ. Mach mejlic la' yuman Dios che' woli la' yuman chubʌ'añʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jini cha'an mic subeñetla mach mi la' mel la' pusic'al cha'an la' cuxtʌlel wʌ' ti pañimil, mi cha'an chuqui mi la' c'ux, mi cha'an chuqui mi la' jap, mi cha'an chuqui mi la' xoj. ¿Mach ba ñumenic i c'ʌjñibal la' cuxtʌlel bajche' i bʌl la' ñʌc'? ¿Mach ba ñumenic i c'ʌjñibal la' bʌc'tal bajche' la' pislel? ");
INSERT INTO ctuBl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Q'uelela jini te'lemut. Ma'anic mi' cha'len pac' mi c'ajbal. Ma'anic mi' tempan i buc'bal ti' yotlel. La' Tat ti panchan mi' yʌq'uen i buc'bal te'lemut. ¿Mach ba ñumenic la' c'ʌjñibal bajche' te'lemut? ");
INSERT INTO ctuBl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Majqui mi' mejlel ti colel mi junxuc'ubʌyem cha'an ti cabʌl mel pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Chucoch mi la' mel la' pusic'al cha'an la' pislel? Ña'tanla bajche' mi' colel jini sʌsʌc bʌ i nich pimel am bʌ ti jamil. Ma'anic mi' cha'len e'tel mi ñoq'uijel. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero mic subeñetla, mach yoque i t'ojolic i pislel Salomón ti pejtelel i ñuclel bajche' jini sʌsʌc bʌ i nich pimel. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","I t'ojol jax mi' mel pimel Dios, jini pimel cuxul bʌ wʌle mu' bʌ i chojquel ti c'ajc ti yijc'ʌlal. Mi che'ʌch mi' mel, ¿mach ba muq'uic i yʌq'ueñetla chuqui mi la' xoj jatetla mach bʌ anic mi la' ñop ti pejtelel la' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jini cha'an mach mi la' mel la' pusic'al. Mach mi la' wʌl: “¿Chuqui mi caj laj c'ux? ¿Chuqui mi caj lac jap? ¿Chuqui mi caj lac xoj?” Mach che'ic yom mi la' wʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Come pejtelel ili tac mi' sʌclañob gentilob. Come la' Tat ti panchan yujil pejtelel chuqui tac yom la' cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ñaxan sajcanla i yumʌntel Dios yic'ot i tojel. Che' jini mi caj la' wʌq'uentel pejtelel chuqui tac anto yom la' cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mach mi la' mel la' pusic'al cha'an jini mu' to bʌ i yujtel ijc'ʌl. Ya'to tsiquil chuqui mi' yujtel ijc'ʌl. Jasʌl jach mi lac ña'tan ili wocol am bʌ wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mach mi la' wʌl ti la' pusic'al mi an i mul la' pi'ʌlob. Che' jini, ma'anic mi caj i yʌlob ti' pusic'al mi an la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Come che' mi la' wʌl ti la' pusic'al mi an i mul la' pi'ʌlob, mi caj i yʌlob ti' pusic'al mi an la' mul. Che' bajche' mi la' p'isben winicob, che'ʌch mi caj la' wʌq'uentel ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chucoch ma' q'uel ya wistʌl sajte' am bʌ ti' wut a pi'ʌl, pero ma'anic ma' q'uel cucujl am bʌ ti a wut? ");
INSERT INTO ctuBl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Bajche' mi mejlel a suben a pi'ʌl: “La' c loc'san sajte' ti a wut”, che'et, pero awilan an cucujl ti a wut? ");
INSERT INTO ctuBl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jatet cha'chajp jax bʌ a pusic'al, ñaxan loc'san jini cucujl am bʌ ti a wut. Ti wi'il mi mejlel a wen q'uel cha'an ma' loc'san jini sajte' am bʌ ti' wut a pi'ʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mach mi la' wʌq'uen ts'i' chuqui tac ch'ujul. Mach mi la' wejtuben chitam la' perla tac ame mi' t'uchtan, ame mi' sutq'uin i bʌ i lowetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","C'ajtinla. Mi caj la' wʌq'uentel. Sajcanla. Mi caj la' taj. Pejcanla i yum otot. Mi caj la' jambentel. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Come majqui jach mi' c'ajtin mi caj i yʌq'uentel. Jini mu' bʌ i sajcan mi' taj. Jini mu' bʌ i pejcan i yum otot mi caj i jambentel. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Am ba juntiquil winic ti a tojlel mu' bʌ caj i yʌq'uen xajlel i yalobil mi tsi' c'ajtibe waj? ");
INSERT INTO ctuBl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Mi tsi' c'ajtibe chʌy, ¿mu' ba i yʌq'uen lucum? ");
INSERT INTO ctuBl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anquese jontoletla la' wujil la' wʌq'uen la' walobilob chuqui uts'at. ¿Mach ba ñumenic yujil la' Tat am bʌ ti panchan? Mi' yʌq'ueñob chuqui uts'at jini mu' bʌ i c'ajtibeñob. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Melela chuqui uts'at ti' tojlel la' pi'ʌlob mi la' wom chuqui uts'at ti la' tojlel. Come jiñʌch jini mandar yic'ot i subal jini x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ochenla ti ch'o'ch'oc bʌ i ti', come colem i ti', ñuc i bijlel mu' bʌ i majlel ti tojmulil. Cabʌlob mi' yochelob ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Come ch'o'ch'oc i ti', ch'o'ch'oc i bijlel ba' mi la' taj la' cuxtʌlel. Ts'ita' jax jini mu' bʌ i yochelob i taj i cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Chʌcʌ q'uele la' bʌ cha'an lot bʌ x'alt'añob mu' bʌ i tilelob ba' añetla lʌpʌl i cha'añob i tsutsel tiñʌme' yilal, pero ti' pusic'al lajalob bajche' jontol bʌ bʌte'el ts'i'. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","¿Mu' ba i tujq'uel ts'usub ti ch'ixol, mi i wut te' i c'aba' higo ti ts'ʌbabol? Ti' wut jach mi la' cʌn lot bʌ x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Che' jini, pejtelel uts'at bʌ te' mi' yʌc' uts'at bʌ i wut. Jini mach bʌ wenic bʌ te' mi' yʌc' leco tac bʌ i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Mach mejlic i yʌc' leco bʌ i wut jini uts'at bʌ te'. Che' ja'el, ma'anic mi' yʌc' uts'at bʌ i wut jini te' mach bʌ wenic. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pejtelel jini te' mach bʌ anic mi' yʌc' uts'at bʌ i wut mi' sejq'uel. Mi' chojquel ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Che' jini, ti' wut jach mi la' cʌñob. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mach ti pejtelobic mu' bʌ i pejcañoñob ti' yum mi caj i yochelob ti' yumʌntel jini am bʌ ti panchan. Jini jach mu' bʌ i melob bajche' yom c Tat ti panchan mi caj i yochelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ti jini q'uin cabʌl mi caj i subeñoñob: “C Yum, c Yum, ¿mach ba anic tsac cha'le lojon subt'an ti a c'aba'? Ti a c'aba' tsac choco lojon loq'uel xibajob. Ti a c'aba' tsac cha'le lojon cabʌl ñuc bʌ c melbal”. Che' mi caj i yʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Che' jini mi caj c subeñob: “Mach j cʌñʌyeticla. Loq'uenla tic tojlel jatetla mu' bʌ la' cha'len jontolil”. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ti jujuntiquil mu' bʌ i yubibeñon c t'an, mu' bʌ i jac'beñon, lajalʌch bajche' winic am bʌ cabʌl i ña'tʌbal. Tsi' mele i yotot ti' pam xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tsa' yajli ja'al. Tsa' tili but'ja'. Tsa' ñumi cabʌl ic'. Tsi' jats'ʌ jini otot. Pero ma'anic tsa' bujchi come wen wa'chocobil jini otot ti' pam xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jini mu' bʌ i yubibeñon c t'an pero ma'anic mi' jac'beñon, lajalʌch bajche' winic mach bʌ anic i ña'tʌbal. Tsi' mele i yotot ti' pam ji'. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tsa' yajli ja'al. Tsa' tili but'ja'. Tsa' ñumi cabʌl ic'. Tsi' jats'ʌ jini otot. Tsa' bujchi. Tsa' lu' jejmi. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Che' bʌ tsa' ujti i sub jini t'an Jesús, tsa' toj sajtiyob i pusic'al winicob x'ixicob cha'an i cʌntesʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Come yic'ot i p'ʌtʌlel i ye'tel tsi' cʌntesayob, mach che'ic bajche' sts'ijbayajob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Che' bʌ tsa' jubi tilel Jesús ti bujtʌl, tsa' caji i tsajcañob majlel cabʌl winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Awilan, tsa' tili juntiquil winic am bʌ leco bʌ i tsoy. Tsi' ch'ujutesa Jesús. Tsi' yʌlʌ: C Yum, mi a wom, mi mejlel a lajmesañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús tsi' sʌts'ʌ i c'ʌb. Tsi' tʌlʌ. Tsi' yʌlʌ: Com cu. La' lajmiquet, che'en. Tsa' bʌc' lajmi leco bʌ i tsoy. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús tsi' sube: Chʌcʌ q'uele a bʌ. Mach ma' suben mi juntiquilic winic. Cucu pʌsʌ a bʌ ba'an motomaj. Aq'uen i majtan Dios che' bajche' tsi' yʌlʌ Moisés ti mandar cha'an mi' q'uelob sʌq'uesʌbilet, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Che' bʌ tsa' c'oti Jesús ti Capernaum, tsa' tili i yaj capitán jo'c'al soldadojob. Tsi' c'ajtibe wocol t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tsi' yʌlʌ: C Yum, ya' ñolol juntiquil x'e'tel c cha'an ti cotot. Ma'anic i c'ʌjñibal i yoc i c'ʌb. Wen cabʌl woli' yubin wocol, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús tsi' sube: Mic majlel c lajmesan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jini i yaj capitán jo'c'al soldadojob tsi' sube: C Yum, mach uts'aticon cha'an ma' wochel ti cotot. Jini jach yom ma' wʌc' a t'an. Che' jini mi' caj ti lajmel jini x'e'tel c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Come joñon añon ti' wenta yambʌ winic. An tic wenta cabʌl soldadojob. Mic suben juntiquil: “Cucu”, cho'on. Mi' majlel. Yambʌ mic suben: “La'”, cho'on. Mi' tilel. Mic suben c winic: “Mele jini”, cho'on. Mi' mel, che'en jini capitán. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús uts'at tsi' yubibe i t'an jini capitán. Tsi' subeyob jini woli bʌ i tsajcañob majlel: Isujm mic subeñetla ma'anic ba' tsac taja ti pejtelel Israel mi juntiquilic winic mu' bʌ i ñopon bajche' jini. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mic subeñetla, mi caj i tilelob cabʌl ch'oyolo' bʌ ti' pasibal q'uin yic'ot ti' bʌjlibal q'uin. Ya' mi caj i buchtʌlob yic'ot Abraham yic'ot Isaac yic'ot Jacob ti' yumʌntel jini am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jini tsa' bʌ pʌjyiyob ti' yumʌntel Dios mach bʌ anic mi' yumañob Dios mi' caj ti chojquelob ochel ti ic'ch'ipan bʌ pañimil. Ya' mi' cajelob ti uq'uel yic'ot quech'ecña bʌ i bʌquel i yej, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesús tsi' sube i yaj capitán soldadojob: Cucux. La' aq'uentiquet che' bajche' tsa' ñopo ti a pusic'al, che'en. Ti jini jach bʌ ora tsa' lajmi jini x'e'tel i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Che' bʌ tsa' ochi Jesús ti' yotot Pedro, tsi' q'uele ya' ñolol x'ixic, i ñij'al Pedro. Woli' yubin c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tsi' tʌlbe i c'ʌb. Tsa' bʌc' lajmi c'ajc. Tsa' ch'ojyi. Tsa' caji i bʌc' we'sañob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Che' yomix ic'an, tsi' pʌyʌyob tilel ba'an Jesús cabʌl año' bʌ i xibʌjlel. Ti' t'an jach Jesús tsi' choco loq'uel jini xibajob. Tsi' lu' lajmesa xc'amʌjelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Che'ʌch tsa' ujti cha'an mi' ts'ʌctiyel i t'an jini x'alt'an Isaías tsa' bʌ i yʌlʌ: “Jini tsi' ch'ʌmʌ lac chʌmel. Tsi' cuchu laj c'amʌjel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Che' bʌ tsi' q'uele cabʌl winicob x'ixicob ti' joytilel, Jesús tsi' yʌq'ueyob mandar xcʌnt'añob cha'an mi' bajñel c'axelob ti junwejl ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tsa' tili juntiquil sts'ijbaya. Tsi' sube: Maestro, mi caj c tsajcañet baqui jach ma' majlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús tsi' sube: An i met wax. An i c'u' te'lemut, pero ma'anic ba' mi' ñoltʌl i Yalobil Winic cha'an mi' c'aj i yo, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yambʌ xcʌnt'an tsi' sube: C Yum, ac'ʌyon ti ñaxan majlel c muc c tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús tsi' sube: Tsajcañon. La' i mucob chʌmeño' bʌ jini chʌmeño' bʌ i pi'ʌlob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Che' bʌ tsa' ochi Jesús ti barco, tsi' tsajcayob ochel xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Awilan, tsa' tili p'ʌtʌl bʌ ic' ti ñajb. Tsa' caji i wec'ulan i bʌ ja' c'ʌlʌl ti' pam barco. Wʌyʌl Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tsa' tiliyob xcʌnt'añob i cha'an cha'an mi' ñijcañob ch'ojyel. Tsi' yʌlʌyob: C Yum, coltañon lojon, wolic jilel lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús tsi' subeyob: ¿Chucoch woliyetla ti bʌq'uen, jatetla mach bʌ anic mi la' ñop ti pejtelel la' pusic'al? che'en. Tsa' ch'ojyi. Tsi' tiq'ui jini ic' yic'ot ñajb. Ñʌch'ʌcña tsa' lajmi. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tsa' toj sajtiyob i pusic'al winicob. Tsi' yʌlʌyob: ¿Majqui jini winic? Come jini ic' yic'ot ñajb mi' jac'ben i t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Che' bʌ tsa' c'oti ti junwejl ñajb, ti' lumal gadareñob, tsa' tiliyob ba'an Jesús cha'tiquil winicob año' bʌ i xibʌjlel. Ya' tsa' loq'uiyob ti' yotlel tac ch'ujlelʌl. C'ax jontolob. Jini cha'an ma'anic majch tsa' mejli ti ñumel ti ili bij. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Awilan, c'am tsi' cha'leyob t'an. Tsi' yʌlʌyob: ¿Chuqui i ye'tel ma' tilel ba' añon lojon jatet i Yalobilet bʌ Dios? ¿Tsa' ba tiliyet cha'an ma' tic'lañon lojon che' maxto i yorajlelic? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mero ñajt woli ti buc'bal bajc'ʌl chitam. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tsi' c'ajtibeyob Jesús ti wocol t'an jini xibajob: Mi a wom a chocon lojon loq'uel, subeñon lojon ochel ti chitam, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús tsi' subeyob: Cucula, che'en. Che' bʌ loq'uemobix xibajob tsa' ochiyob ti chitam. Awilan, ti pejtelel jini chitam ti ajñel tsa' jubi ti xitil bʌ wits. Tsi' lu' choco ochel i bʌ ti ñajb. Tsa' laj chʌmi ti ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jini xcʌnta chitamob ajñel tsa' majliyob ti tejclum. Tsi' laj subuyob chuqui tsa' ujti yic'ot chuqui tsa' tumbentiyob jini am bʌ i xibʌjlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Awilan jini xtejclumob tsa' laj loq'uiyob cha'an mi' q'uelob Jesús ya' ti bij. Che' bʌ tsi' tajayob, tsa' caji i c'ajtibeñob Jesús ti wocol t'an cha'an mi' loq'uel ti' lumal. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tsa' ochi Jesús ti barco. Tsa' c'axi ti colem ñajb. Tsa' c'oti ti' tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Awilan, tsi' ch'ʌmʌyob majlel juntiquil winic mach bʌ anic i c'ʌjñibal i yoc i c'ʌb. Ñolol ti' wʌyib. Che' bʌ tsi' ña'ta Jesús mi woli' ñopob jini winicob, tsi' sube jini mach bʌ anic i c'ʌjñibal i yoc i c'ʌb: Calobil, tijicñesan a pusic'al. Ñusʌbilix a mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Awilan, cha'tiquil uxtiquil sts'ijbayajob tsi' yʌlʌyob ti' pusic'al: Jini winic woli' p'aj Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ña'tʌbil i cha'an Jesús chuqui woli' yʌlob ti' pusic'al. Tsi' yʌlʌ: ¿Chucoch woli la' cha'len jontol bʌ t'an ti la' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Baqui bʌ ñumen wocol? ¿Jim ba wocol che' mic suben: “Ñusʌbilix a mul?” o ¿jim ba wocol che' mic suben: “Ch'ojyen, cha'len xʌmbal”? Subula. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero cha'an mi la' ña'tan an i p'ʌtʌlel i Yalobil Winic ilayi ti pañimil cha'an mi' ñusan mulil (tsi' sube jini mach bʌ anic i c'ʌjñibal i yoc i c'ʌb): Ch'ojyen. Teche a wʌyib. Cucu ti a wotot, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tsa' ch'ojyi. Tsa' majli ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tsa' cajiyob ti bʌq'uen jini winicob x'ixicob che' bʌ tsi' q'ueleyob. Tsi' tsictesʌbeyob i ñuclel Dios tsa' bʌ i yʌq'ueyob winicob ñuc bʌ i p'ʌtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Che' woli ti xʌmbal majlel Jesús, tsi' q'uele juntiquil winic i c'aba' Mateo, buchul ya' ba' mi' ch'ʌjmel tojoñel. Jesús tsi' sube: Tsajcañon, che'en. Mateo tsa' wa'le. Tsa' caji i tsajcan majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Che' buchul Jesús ti' t'ejl mesa ti otot, awilan, tsa' tiliyob cabʌl xch'ʌm tojoñelob yic'ot xmulilob. Tsa' buchleyob yic'ot Jesús yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Che' bʌ tsi' q'ueleyob jini fariseojob, tsi' c'ajtibeyob xcʌnt'añob i cha'an Jesús: ¿Chucoch woli' pi'len ti we'el jini xch'ʌm tojoñelob yic'ot xmulilob la' maestro? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Che' bʌ tsi' yubi Jesús, tsi' subeyob: Jini c'oc'o' bʌ mach yomobic ts'ʌcʌntel, jini jach jini c'amo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cucula. Ñopola i sujmlel jini t'an: “Com mi la' cha'len p'untaya, mach comic mi la' wʌq'ueñon c majtan”. Come ma'anic tsa' tili c pʌy jini tojo' bʌ i pusic'al. Tsa' tili c pʌy xmulilob cha'an mi' cʌyob i mul. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tsa' tiliyob xcʌnt'añob i cha'an Juan ba'an Jesús. Tsi' yʌlʌyob: Cabʌl mic cha'len lojon ch'ajb. Che' ja'el fariseojob. ¿Chucoch ma'anic mi' cha'leñob ch'ajb xcʌnt'añob a cha'an? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús tsi' jac'beyob: ¿Mejl ba i cha'leñob ch'ajb jini xmel q'uiñob che' temel añob yic'ot winic woli bʌ ti ñujpuñijel? Pero tal i yorajlel che' mi caj i pʌjyel majlel jini winic woli bʌ ti ñujpuñijel. Ti jini q'uin tac mi' cajelob ti ch'ajb xmel q'uiñob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ma'anic majqui mi' c'ʌn tsijib pisil cha'an mi' lʌw tsucul bʌ i pislel, come mu' jach i cha' tsijlel loq'uel, jinto ñumen colem i tsijlemal. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Che' ja'el, ma'anic majqui mi' yotsan tsijib vino ti tsucul bʌ i yajñib melbil bʌ ti pʌchi. Mi che'ʌch tsi' mele, mi' tojmel i yajñib, mi' bejq'uel vino, mi' jilel i yajñib. Pero mi' yotsañob tsijib vino ti tsijib to bʌ i yajñib. Che' jini, mi' jalijel i yajñib yic'ot jini vino ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Che' woli' subeñob jini t'an, awilan, tsa' tili juntiquil yumʌl. Tsi' ch'ujutesa Jesús. Tsi' yʌlʌ: Poj ujtel i chʌmel xch'oc bʌ calobil. La', ac'ʌ a c'ʌb ti jini xch'oc cha'an mi' cha' cuxtiyel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús tsa' wa'le. Tsi' tsajca majlel yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Awilan, ma'anic tsa' wis tijq'ui i bec' i ch'ich'el juntiquil x'ixic lajchʌmp'ejl jab. Tsa' tili ti' pat Jesús. Tsi' tʌlbe i yoc i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Come tsi' yʌlʌ ti' pusic'al: Mi tsa' jach c tʌlbe i pislel, mi caj j c'oc'an, che'en jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús tsi' sutq'ui i bʌ. Che' bʌ tsi' q'uele tsi' sube: Calobil, tijicñesan a pusic'al. Tsa' coltʌntiyet cha'an tsa' ñopoyon, che'en. Tsa' bʌc' lajmi jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Che' bʌ tsa' ochi Jesús ti' yotot jini yumʌl, tsi' q'uele jini x'amʌyob yic'ot jini winicob x'ixicob ju'ucñayob ti uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús tsi' subeyob: Loq'uenla. Mach chʌmenic jini xch'oc. Woli jach ti wʌyel, che'en. Tsi' wajleyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Che' loq'uemobix winicob x'ixicob tsa' ochi Jesús. Tsi' chucbe i c'ʌb xch'oc. Tsa' ch'ojyi jini xch'oc. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tsa' pujqui t'an ti pejtelel lum cha'an jini tsa' bʌ ujti. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Che' bʌ tsa' majli Jesús, tsi' tsajcayob majlel cha'tiquil xpots'. C'am tsi' yʌlʌyob: I Yalobil David, p'untañon lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Che' bʌ tsa' c'oti ti otot, tsa' tiliyob jini xpots'ob ba'an Jesús. Jesús tsi' subeyob: ¿Mu' ba la' ñop mi mejlel c mel jini? che'en. Tsi' jac'beyob: Mu' cu, c Yum, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesús tsi' tʌlbeyob i wut. Tsi' yʌlʌ: La' melbentiquetla che' bajche' tsa' la' ñopo, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tsa' c'otiyob i wut. Jesús tsi' wersa subeyob: Chʌcʌ q'uele la' bʌ cha'an ma'anic mi' yubin winic mi juntiquilic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero che' bʌ tsa' sujtiyob, tsi' pucuyob t'an ti pejtelel lum cha'an ñuc bʌ i melbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Che' bʌ tsa' majliyob, awilan, tsa' pʌjyi tilel ba'an Jesús juntiquil x'uma' winic am bʌ i xibʌjlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Che' bʌ tsa'ix chojqui loq'uel i xibʌjlel, tsa' caji ti t'an jini x'uma'. Tsa' toj sajtiyob i pusic'al jini winicob x'ixicob. Tsi' yʌlʌyob: Ma'anic ba' tsa' laj q'uele che' bajche' jini ti Israel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jini fariseojob tsi' yʌlʌyob: Ti' p'ʌtʌlel i yum xibajob, mi' choc loq'uel xibajob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús tsa' ñumi ti pejtelel tejclum tac yic'ot ti pejtelel xchumtʌl tac. Tsi' cha'le cʌntesa ti' sinagoga tac judíojob. Tsi' subu jini wen t'an cha'an i yumʌntel Dios. Tsi' lu' lajmesa c'amʌjel tac yic'ot chʌmel tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Che' bʌ tsi' q'uele tempʌbilob winicob x'ixicob, tsa' bujt'i i pusic'al Jesús ti p'untaya, come tsi' q'uele c'uñob jax, pujquemob jax che' bajche' tiñʌme' mach bʌ anic xcʌntaya i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tsi' sube xcʌnt'añob i cha'an: Isujm, wen cabʌl c'ajbal pero ma'anic cabʌl x'e'telob. ");
INSERT INTO ctuBl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jini cha'an c'ajtibenla i Yum c'ajbal ti wocol t'an cha'an mi' choc majlel x'e'telob ti' c'ajbal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús tsi' pʌyʌ tilel jini lajchʌntiquil xcʌnt'añob i cha'an. Tsi' yʌq'ueyob i p'ʌtʌlel ti' contra xibajob cha'an mi' chocob loq'uel, cha'an ja'el mi' lu' lajmesan c'amʌjel tac yic'ot chʌmel tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jiñʌch i c'aba' jini lajchʌntiquil xcʌnt'añob tsa' bʌ chojquiyob majlel ti subt'an: Ñaxan Simón i cha'p'ejlel i c'aba' Pedro, yic'ot Andrés i yijts'in Pedro, Jacobo i yalobil Zebedeo, yic'ot Juan i yijts'in Jacobo, ");
INSERT INTO ctuBl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo jini xch'ʌm tojoñel, Jacobo i yalobil Alfeo, yic'ot Lebeo, jini am bʌ i jol i c'aba' Tadeo, ");
INSERT INTO ctuBl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón jini cananista, yic'ot Judas Iscariote, jini tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús tsi' choco majlel jini lajchʌntiquil. Tsi' yʌq'ueyob mandar: Mach mi la' majlel ba'an gentilob. Mach mi la' wochel mi ti jump'ejlic i tejclum jini samaritanojob. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pero ya' yom mi la' majlel ba'an sajtemo' bʌ tiñʌme' i p'olbalo' bʌ Israel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Che' woli la' majlel, subula jini wen t'an: “Lʌc'ʌlix i yumʌntel jini am bʌ ti panchan”, che'etla. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lajmesanla xc'amʌjelob. Techela ch'ojyel chʌmeño' bʌ. Lajmesanla año' bʌ leco bʌ i tsoy. Chocola loq'uel xibajob. A majtan jach tsa' aq'uentiyetla. I majtan jach mi la' wʌq'ueñob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mach mi la' ch'ʌm majlel mi oro mi plata mi tsucu taq'uin ti' yajñib la' taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mach mi la' ch'ʌm majlel ti bij mi chim, mi cha'p'ejl la' bujc, mi xʌñʌbʌl, mi te' cha'an xʌmbal. Come yom mi' yʌq'uentel i bʌl i ñʌc' x'e'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Baqui jach mi la' wochel mi ti tejclum, mi ti xchumtʌl, yom mi la' c'ajtibeñob mi an uts'at bʌ i pusic'al. Ya' yom mi la' jijlel jinto mi la' loq'uel majlel ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Che' mi la' wochel ti jump'ejl otot, aq'ueñob cortesía. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi uts'atob jini año' bʌ ti otot, aq'ueñob i yutslel la' t'an cha'an mi' tajob i ñʌch'tilel i pusic'al. Mi mach uts'atobic ma'anic mi caj i tajob i ñʌch'tilel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Che' ma'anic majch mi' pʌyetla ochel ti' yotot, che' ma'anic mi' ñich'tʌbeñetla la' t'an, tijcanla loq'uel i ts'ubeñal la' woc. Cʌyʌla jini otot yic'ot jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Isujm mic subeñetla, ñumen mi caj i yubiñob wocol ti' q'uiñilel tojmulil jini winicob x'ixicob año' bʌ ti jini tejclum che' bajche' jini año' bʌ ti Sodoma yic'ot ti Gomorra. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Awilan, wolic choquetla majlel che' bajche' tiñʌme' joyol bʌ ti bʌte'el ts'i'. Yom p'ip'etla che' bajche' lucum. Yom utsetla che' bajche' x'ujcuts. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chʌcʌ q'uele la' bʌ cha'an winicob, come mi caj i pʌyetla ba'an año' bʌ i ye'tel. Mi caj i jats'etla ti asiyal ti sinagoga. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mi caj la' pʌjyel ti' tojlel yumʌlob yic'ot ti' tojlel reyob cha'an tij c'aba', cha'an mi la' wʌc'on ti cʌjñel ti' tojlelob yic'ot ti' tojlel gentilob. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Che' mi' yʌq'uetla ti' c'ʌb yumʌlob, mach mi la' mel la' pusic'al cha'an bajche' mi' caj ti loq'uel la' t'an mi chuqui mi caj la' sub. Come ti jim bʌ ora mi caj la' wʌq'uentel t'an mu' bʌ caj la' sub. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Come mach jateticla muq'uetla ti t'an, pero i yEspíritu la' Tat mi' c'ʌn la' wej ti t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Winicob mi caj i yʌc'ob ti chʌmel i yerañob. Tatʌl mi caj i yʌc' ti chʌmel i yalobil. Winicob x'ixicob mi caj i contrajiñob i tat i ña'. Mi caj i yʌc'ob ti tsʌnsʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mi caj la' ts'a'lentel cha'an pejtelel winicob x'ixicob cha'an tij c'aba'. Pero jini mu' bʌ i cuch i wocol c'ʌlʌl ti' jilibal mi caj i coltʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Che' mi' ts'a'leñetla ti jump'ejl tejclum, puts'enla majlel ti yambʌ tejclum. Come isujm mic subeñetla, che' maxto lu' ñumeñeticla ti pejtelel i tejclum tac israelob, mi caj i tilel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mach ñuquic xcʌnt'an bajche' i maestro. Mach ñuquic x'e'tel bajche' i yum. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","La' ajnic jini xcʌnt'an che' bajche' i maestro. La' ajnic jini x'e'tel che' bajche' i yum. Mi tsa' pejcʌnti i yum otot ti Beelzebub, ¿mach ba ñumen lecojic mi caj i pejcʌntelob jini año' bʌ ti' yotot? ");
INSERT INTO ctuBl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jini cha'an mach mi la' bʌc'ñañob, come ma'anic mosol tac bʌ mach bʌ anic mi caj i pʌstʌl. Ma'anic mucul tac bʌ mach bʌ anic mi caj i ña'tʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jini mu' bʌ c mucul subeñetla subula ti jamʌl. Jini mu' bʌ la' mucul ubin pam subula ti pejtelel otot tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mach mi la' bʌc'ñan jini mu' bʌ i tsʌnsañob la' bʌc'tal, come mach mejlic i tajob la' ch'ujlel. Yom mi la' bʌc'ñan jini mu' bʌ mejlel i jisan la' ch'ujlel yic'ot la' bʌc'tal ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Mach ba anic mi' chojñel cha'cojt xpuruwoc ti jump'ejl taq'uin? Pero mi mach yomic la' Tat, ma'anic mi' yajlel ti lum mi juncojtic. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Laj tsicbil i tsutsel la' jol. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jini cha'an, mach mi la' cha'len bʌq'uen. Come ñumen an la' c'ʌjñibal bajche' cabʌl xpuruwoc. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Majqui jach mi' suben winicob cha'an tsi' cʌñʌyon, joñon ja'el mi caj c sub ya' ti' tojlel c Tat am bʌ ti panchan cha'an tsa'ix j cʌñʌ jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Majqui jach mi' suben winicob x'ixicob mach i cʌñʌyonic, joñon ja'el mi caj c sub ya' ti' tojlel c Tat am bʌ ti panchan mach j cʌnʌyic jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mach mi la' lon ña'tan ti la' pusic'al tsa' tiliyon cha'an mic ñʌch'chocon jini año' bʌ ti pañimil. Ma'anic tsa' tili c ñʌch'chocoñob, pero cha'an mi cʌq'ueñob espada, cha'an mi' contrajiñob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tsa' tiliyon cha'an mi cʌq'ueñob i t'oxob i bʌ, winic ti' contra i tat, x'ixic ti' contra i ña', a'libʌl ti' contra i yʌ'lib. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Winicob mi caj i tajob i ts'a'lentel ti' tojlel i pi'ʌlob ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jini mu' bʌ i ñumen c'uxbin i tat i ña' bajche' mi' c'uxbiñon mach uts'atic mij q'uel. Jini mu' bʌ i ñumen c'uxbin i yalobil bajche' mi' c'uxbiñon mach uts'atic mij q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jini mach bʌ anic mi' ch'ʌm i cruz i tsajcañon mach uts'atic mij q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jini mu' bʌ i bajñel cʌntan i cuxtʌlel mi caj i sʌt. Majqui jach mi' yʌc' i cuxtʌlel cha'añon mi caj i taj. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jini mu' bʌ i pʌyetla ochel ti' yotot mi' pʌyon ochel. Jini mu' bʌ i pʌyon ochel mi' pʌy ochel jini tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jini mu' bʌ i pʌy ochel x'alt'an cha'an mero x'alt'añʌch mi caj i yʌq'uentel i chobejtʌbal x'alt'an. Jini mu' bʌ i pʌy ochel juntiquil toj bʌ i pusic'al cha'an tojʌch i pusic'al mi caj i yʌq'uentel i chobejtʌbal jini toj bʌ i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Majqui jach mi' yʌq'uen mi jump'ejlic vaso tsʌni ja' juntiquil ch'o'ch'oc bʌ cha'an xcʌnt'añʌch, isujm mic subeñetla, mi caj i yʌq'uentel i chobejtʌbal. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Che' bʌ tsa' ujti i cʌntesan jini lajchʌntiquil xcʌnt'añob i cha'an, Jesús tsa' loq'ui ya'i. Tsa' ñumi majlel ti cʌntesa ti subt'an ti' tejclum tac Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ñup'ul Juan ti mʌjquibʌl. Che bʌ tsi' yubi chuqui woli' cha'len Cristo, tsi' choco majlel t'an yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tsi' c'ajtibeyob Jesús: ¿Jatet ba jini mu' bʌ i tilel? ¿Yom ba mic pijtan lojon yambʌ? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús tsi' subeyob: Cucula. Subenla Juan chuqui woli la' wubin yic'ot chuqui woli la' q'uel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Wolix ti c'otel i wut xpots'ob. Woliyobix ti xʌmbal jini mach bʌ añobic i c'ʌjñibal i yoc. Lajmesʌbilob jini año' bʌ leco bʌ i tsoy. Jini xcojcob wolix i yubiñob t'an. Woli' tejchelob ch'ojyel jini chʌmeño' bʌ. Jini p'umpuño' bʌ woli' subentelob jini wen t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tijicña jini mach bʌ anic mi' lon tejchel tile bixel bʌ i pusic'al cha'an c melbal, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Che' majlemobix jini cha'tiquil, Jesús tsa' caji i suben tempʌbilo' bʌ winicob x'ixicob bajche' yilal Juan: ¿Chuqui tsajni la' q'uel ti jochol bʌ lum? ¿Jim ba jini chiquib jam woli bʌ i yujcun ic'? ");
INSERT INTO ctuBl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Majqui tsajni la' q'uel? ¿Jim ba juntiquil winic wen i t'ojol bʌ i pislel? La' wilan jini uts'at bʌ i pislel añob ti' yotlel reyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Majqui tsajni la' q'uel? ¿Mu' ba la' ña'tan jiñʌch x'alt'an? Isujm mic subeñetla jiñʌchi, pero ñumen ñuc i ye'tel Juan bajche' x'alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Come tsa' ña'tʌnti Juan ti jini t'an tsa' bʌ ts'ijbunti: “Awilan, mic ñaxan choc majlel subt'an mu' bʌ i chajpan a bijlel”. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Isujm mic subeñetla: Ti pejtelel i yalobilob x'ixicob ma'anic yambʌ ñuc bʌ bajche' Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'. Pero ñumen an i ñuclel jini c'ax ch'o'ch'oc bʌ ti' yumʌntel panchan bajche' Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ti' yorajlel Juan tsa' bʌ i yʌc'ʌ ch'ʌmja' c'ʌlʌl wʌle cabʌl winicob x'ixicob woli' tilelob ti pejtelel i pusic'al cha'an wersa yomob ochel ti' yumʌntel panchan. Jini mu' bʌ i cha'leñob wersa mi' yochelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Come ti pejtelel x'alt'añob yic'ot ts'ijbubil bʌ mandar c'ʌlʌl ti' yorajlel Juan tsi' wʌn subuyob jini woli bʌ ti ujtel. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mi la' wom la' ñop, jiñʌch Elías tsa' bʌ ajli mi caj i tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jini am bʌ i chiquin cha'an mi' yubin, la' i yubin. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Bajche' mic lajin jini winicob año' bʌ ti pañimil wʌle? Lajalob bajche' alobob buchulo' bʌ ba'an choñoñibʌl tac woli bʌ i pʌyob i pi'ʌlob ti alas. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Mi' yʌlob: “Tsac wusu lojon amʌy, ma'anic tsa' la' cha'le son. Tsa cuc'tʌbeyetla ch'ujlelʌl, ma'anic tsa' la' jats'ʌ la' c'ʌb”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Come tsa' tili Juan. Ma'anic chuqui tsi' c'uxu. Ma'anic chuqui tsi' japʌ. Woli' yʌlob: “An i xibʌjlel”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tsa' tili i Yalobil Winic. An chuqui tsi' c'uxu. An chuqui tsi' japʌ. Woli yʌlob: “Q'uele jini xwo'lel, jini xjap vino. Mi' pi'len ti xʌmbal jini xch'ʌm tojoñelob yic'ot xmulilob”, che'ob. I ña'tʌbal Dios mi' tsictiyel ti' yalobilob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tsa' caji i yʌ'len jini tejclum tac ba' tsi' mele ñuc tac bʌ i ye'tel, come ma'anic tsi' cʌyʌyob i mul. Tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Mi caj la' taj wocol añet bʌ la ti Corazín. Mi caj la' taj wocol añet bʌ la ti Betsaida. Come tsa'ic mejli ñuc bʌ e'tel ti Tiro yic'ot Sidón che' bajche' tsa' mejli ba' añetla, wajalix tsi' cʌyʌyob i mul. Tsa'ic ujti bajche' jini, tsi' xojoyob pisil melbil bʌ ti' tsutsel chivo, tsi' boñoyob i bʌ ja'el ti' tʌñil c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jini cha'an mic subeñetla: Ñumen wocol mi caj la' wubin ti' q'uiñilel tojmulil bajche' mi caj i yubiñob jini tsa' bʌ chʌmiyob ti Tiro yic'ot Sidón. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jixcu jatet Capernaum, mu' bʌ a q'uel a bʌ ti ñuc che' bajche' i chanlel panchan, mi caj a chojquel jubel ti c'ajc. Tsa'ic mejli ya' ti Sodoma jini ñuc bʌ e'tel tsa' bʌ mejli ba' añet, c'ʌlʌl anto wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jini cha'an mic subeñetla: Ñumen wocol mi caj la' wubin ti' q'uiñilel tojmulil bajche' mi caj i yubiñob jini tsa' bʌ jiliyob ti Sodoma, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti jim bʌ ora Jesús tsi yʌlʌ: Mic subeñet a ñuclel, c Tat, i Yumet Panchan yic'ot Pañimil. Come tsa' mucbeyob a t'an jini año' bʌ cabʌl i ña'tʌbal yic'ot jini p'ip'o' bʌ i pusic'al, pero tsa' wʌq'ueyob i ch'ʌmbeñob isujm alʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Uts'atʌch, c Tat, come che' yom a pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pejtelel chuqui tac an, aq'uebilon i cha'an c Tat. Ma'anic majqui mi' cʌñon, cojach c Tat. Che' ja'el ma'anic majqui mi' cʌn c Tat, cojach joñon yic'ot majqui jach mi cʌq'uen i cʌn, come i Yalobilon. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La' ba' añon pejteletla woliyet bʌ la ti wocol e'tel, al bʌ la' cuch. Joñon mi cʌq'ueñetla la' c'aj la' wo. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yu'u a bic' cha'an ma' wochel wʌ' tij q'uech. Ñopoyon come utson. Pec' mic mel c bʌ. Muq'uix caj la' taj c'aj o cha'an la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Come jini j q'uech mach wocolic ti q'uechol. Sejb a cuch mu' bʌ cʌq'ueñet, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Che' ti' q'uiñilel c'aj o, tsa' ñumi Jesús ti jamil. Tsi' yubiyob wi'ñal xcʌnt'añob i cha'an. Tsa' caji i tuc'ob jini c'uxbil bʌ i wut jam cha'an mi' c'uxob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jini fariseojob che' bʌ tsi' q'ueleyob, tsi' subeyob Jesús: Awilan, jini xcʌnt'añob a cha'an woli' melob ti' yorajlel c'aj o chuqui tic'bil ti mandar, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús tsi' subeyob: ¿Mach ba anic tsa' la' q'uele ti jun chuqui tsi' cha'le David che' bʌ tsi' yubi wi'ñal yic'ot i pi'ʌlob? ");
INSERT INTO ctuBl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tsa' ochi ti' yotot Dios, tsi' c'uxu jini waj tsa' bʌ ajq'ui ti mesa, anquese tic'bil mi' c'uxob winicob. Cojach jini motomajob mi mejlel i c'uxob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Mach ba anic tsa' la' q'uele ti mandar bajche' mi' cha'leñob e'tel ti Templo jini motomajob che' ti' yorajlel c'aj o? pero mach mulilic che' jini. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mic subeñetla, wʌ'an ñumen ñuc bʌ bajche' jini Templo. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Com i yutslel la' pusic'al, mach comic tsʌnsʌbil bʌ c majtan. Tsa'ic la' ch'ʌmbe isujm, ma'anic tsa' la' subu ti xmulil jini mach bʌ añobic i mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Come i Yalobil Winic i Yumʌch jini q'uin che' mi laj c'aj la co. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Che' bʌ tsi' cʌyʌyob, tsa' majli ti ochel ti sinagoga. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Awilan, ya'an juntiquil winic tiquin bʌ i c'ʌb. Cha'an yomob i jop'beñob i mul tsi' c'ajtibeyob Jesús: ¿Tic'bil ba lajmesaya che' ti' yorajlel c'aj o? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús tsi' subeyob: Mi an a cha'an tiñʌme', mi tsa' yajli ti ch'en ti' yorajlel c'aj o, ¿mach ba muq'uic a chuc loq'uel? ");
INSERT INTO ctuBl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ñumen ñuc i c'ʌjñibal winic bajche' tiñʌme'. Jini cha'an mach tic'bilic ti mandar i melol chuqui uts'at ti' yorajlel c'aj o, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesús tsi' sube jini winic: Sʌts'ʌ a c'ʌb, che'en. Tsi' sʌts'ʌ. Tsa' cha' wen'a. Lajal tsa' majli bajche' yambʌ i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jini fariseojob tsa' majliyob. Tsi' pejcayob i bʌ cha'an mi' ña'tañob bajche' mi caj i tsʌnsañob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Che' bʌ tsi' ña'ta Jesús tsa' loq'ui majlel. Cabʌl winicob x'ixicob tsi' tsajcayob majlel. Tsi' lu' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","17","Jesús tsi' subeyob cha'an ma'anic mi' yʌc'ob ti cʌjñel, cha'an mi' ts'ʌctiyel i t'an jini x'alt'an Isaías tsa' bʌ i yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Q'uelela x'e'tel c cha'an tsa' bʌ c yajca, jini mu' bʌ j c'uxbin. Tijicña c pusic'al mij q'uel. Mi caj c bujt'esan ti quEspíritu. Jini mi caj i subeñob gentilob chuqui toj. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma'anic mi caj i cha'len leto, mi c'am bʌ t'an. Ma'anic majqui mi caj i yubin i t'an ti calle tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ma'anic mi caj i c'ʌs jini pets' t'uchtʌbil bʌ chiquib jam. Ma'anic mi caj i junyajlel yʌp unjax bʌ ya wistʌl i c'ʌc'al i pislel cas jinto mi' yujtel ti uts'at toj bʌ i meloñel. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jini gentilob ti' xuc'tilel i pusic'al mi caj i cha'leñob pijt ti' c'aba'”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tsa' pʌjyi tilel ba'an Jesús juntiquil x'uma' xpots' am bʌ i xibʌjlel. Che' bʌ tsi' lajmesa jini x'uma' xpots' tsi' cha'le t'an. Tsa' c'oti i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tsa' toj sajtiyob i pusic'al pejtelel winicob x'ixicob. Tsi' yʌlʌyob: ¿Jim ba i Yalobil David? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Che' bʌ tsi' yubiyob fariseojob tsi' yʌlʌyob: Ti' p'ʌtʌlel jach Beelzebú, i yum xibajob, mi' choc loq'uel xibajob jini winic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yujil Jesús chuqui woli' yʌlob ti' pusic'al. Tsi' subeyob: Mi tsi' t'oxoyob i bʌ ti leto i winicob juntiquil yumʌl, mi caj i jisʌbeñob i yumʌntel. Ma'anic mi' caj ti jalijel jump'ejl tejclum mi otot ba' mi' t'oxob i bʌ ti leto. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Mi woli' bajñel choc loq'uel i bʌ Satanás, woli jach i bajñel contrajin i bʌ. Che' jini ¿bajche' mi' mejlel ti jalijel i yumʌntel? ");
INSERT INTO ctuBl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi wolic choc loq'uel xiba ti' p'ʌtʌlel Beelzebú, ¿baqui mi' tajob i p'ʌtʌlel la' walobilob cha'an mi' chocob loq'uel? Jini cha'an la' walobilob mi caj i tsictesañob la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mi wolic choc loq'uel xibajob ti' p'ʌtʌlel i yEspíritu Dios, isujmʌch tsa'ix juli i yumʌntel Dios ba' añetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Bajche' mi mejlel ti ochel juntiquil ti' yotot jini p'ʌtʌl bʌ winic cha'an mi' chilben loq'uel i chubʌ'an, mi ma'anic tsi' ñaxan cʌchʌ jini p'ʌtʌl bʌ winic? Che' mi' yujtel i cʌch mi mejlel i chilben i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jini mach bʌ anic quic'ot woli' contrajiñon. Jini mach bʌ anic mi' pʌy tilel tiñʌme' quic'ot woli jach i pam puc. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jini cha'an mic subeñetla, pejtelel mulil yic'ot p'ajoñel mi mejlel i ñusʌbentel winicob x'ixicob. Cojach jini p'ajoñel ti' contra Espíritu mach mejlic ti ñusʌbentel. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Majqui jach mi' cha'len t'an ti' contra i Yalobil Winic mi caj i ñusʌbentel i mul. Majqui jach mi' cha'len t'an ti' contra Ch'ujul bʌ Espíritu mach mejlic i taj i ñusʌbentel i mul, mi wʌle ti ili pañimil, mi ti yambʌ pañimil mu' bʌ i tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Che' c'oc' jini te', mi la' wʌl c'oc' i wut ja'el. Mi mach wenic jini te', mi la' wʌl mach wenic i wut. Come mi' cʌjñel jini te' ti' wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jatetla i yalobiletla xc'ʌñʌñej. ¿Bajche' mi mejlel la' cha'len t'an ti toj che' jontoletla? Come chuqui jach but'ul ti lac pusic'al mi' tsictiyel ti lac t'an mu' bʌ i loq'uel ti la quej. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jini uts'at bʌ winic mi' loc'san uts'at tac bʌ ti uts'at bʌ i pusic'al. Jini jontol bʌ winic mi' loc'san jontol tac bʌ ti jontol bʌ i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero mic subeñetla, mi caj i melob i bʌ winicob x'ixicob ti' q'uiñilel tojmulil cha'an jujump'ejl t'an tsa' bʌ i yʌlʌyob mach bʌ anic i c'ʌjñibal. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mi uts'at a t'an mi caj a sujbel ti toj. Mi mach uts'atic a t'an mi caj a sujbel ti xmulil. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Cha'tiquil uxtiquil sts'ijbayajob yic'ot fariseojob tsi' subeyob: Maestro, com lojon j q'uel i yejtal a p'ʌtʌlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús tsi' subeyob: Jini jontolo' bʌ cabʌlo' bʌ i ts'i'lel, woli' wersa c'ajtiñob i q'uel i yejtal c p'ʌtʌlel. Ma'anic mi caj i yʌq'uentelob i q'uel, jini jach i yejtal c p'ʌtʌlel tsa' bʌ pʌsle ti Jonás, jini x'alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Che' bajche' tsa' cʌle Jonás uxp'ejl q'uin uxp'ejl ac'ʌlel ti' ñʌc' colem chʌy, che' ja'el mi caj i cʌytʌl i Yalobil Winic ti' mal lum uxp'ejl q'uin uxp'ejl ac'ʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jini winicob ch'oyolo' bʌ ti Nínive mi caj i wa'tʌlob ti' q'uiñilel melo' mulil yic'ot jini winicob x'ixicob año' bʌ wʌle. Mi caj i subeñob i mul. Come tsi' cʌyʌyob i mul che' bʌ tsi' cha'le subt'an Jonás. Awilan, umba'an ñumen ñuc bʌ bajche' Jonás. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jini x'ixic tsa' bʌ i cha'le yumʌl ya' ti sur mi caj i wa'tʌl ti' q'uiñilel melo' mulil yic'ot jini winicob x'ixicob año' bʌ wʌle. Mi caj i subeñob i mul. Come jini x'ixic tsa' tili ti ñajtʌl cha'an mi' yubin i ña'tʌbal Salomón. Awilan, umba'an ñumen ñuc bʌ bajche' Salomón. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Che' mi' loq'uel i xibʌjlel ti' pusic'al winic, mi' cha'len xʌmbal ba'an tiquin pañimil. Mi' sajcan ba' mi' c'aj i yo. Ma'anic mi' taj. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Jini cha'an mi' yʌl: “Muq'uix c cha' majlel ti cotot ba' tsa' loq'uiyon”, che'en. Che' mi' c'otel, jocholix mi' taj. Wen misubilix. Wen chajpʌbilix. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mi' cha' majlel i pʌy tilel yambʌ wuctiquil espíritujob ñumen jontolo' bʌ. Mi' yochelob. Ya' mi' cajelob ti chumtʌl. Ñumen leco mi' caj ti ajñel jini winic ti wi'il bajche' ti ñaxan. Lajal mi caj i yujtelob jini jontolo' bʌ winicob x'ixicob año' bʌ ti pañimil wʌle, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Che' woli' pejcan winicob x'ixicob, awilan ya' wa'alob ti' pat otot i ña' yic'ot i yijts'iñob. Woli' c'ajtiñob cha'an mi' pejcañob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Juntiquil tsi' sube Jesús: Awilan, ya' wa'alob a ña' yic'ot a wijts'iñob ti' pat otot. Yomob i pejcañet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesús tsi' sube jini tsa' bʌ ujti ti t'an: ¿Majqui c ña'? ¿Majqui quijts'iñob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tsi' jʌmts'u i c'ʌb ba'an xcʌnt'añob i cha'an. Tsi' yʌlʌ: Wʌ' añob c ña' yic'ot quijts'iñob. ");
INSERT INTO ctuBl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Come majqui jach mi' cha'len chuqui yom c Tat am bʌ ti panchan jiñʌch quijts'in, quijti'an yic'ot c ña', che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti ili q'uin Jesús tsa' loq'ui ti otot. Tsa' buchle ti' t'ejl colem ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bajc'ʌl winicob x'ixicob tsa' caji i tempañob i bʌ ba'an. Jini cha'an tsa' ochi ti buchtʌl Jesús ti barco. Tsa' cʌleyob ti' ti' ja' pejtel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","An cabʌl chuqui tsi' subeyob ti lajiya tac. Tsi' yʌlʌ: Awilan, tsa' majli juntiquil winic ti wejch'uya pac'. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Che' woli' wejch'un majlel tsa' yajli ts'ita' ti' ti' bij. Tsa' tili te'lemut. Tsi' c'uxu. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yambʌ tsa' yajli ti xajlelol ba' ma'anic cabʌl lum. Tsa' bʌc' pasi come mach tamic i lumil. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Che' bʌ tsa' chan'a q'uin, c'ux tsi' yubi. Tsa' tiqui come ma'anic i wi'. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yambʌ tsa' yajli ti ch'ixol. Tsa' coli jini ch'ix. Tsi' tsʌnsa. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yambʌ tsa' yajli ti wen bʌ lum. Tsi' yʌc'ʌ i wut ti jo'c'al, ti uxc'al, ti lujump'ejl i cha'c'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jini am bʌ i chiquin cha'an mi' yubin, la' i yubin, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tsa' tiliyob xcʌnt'añob ba'an Jesús. Tsi' yʌlʌyob: ¿Chucoch ma' pejcañob ti lajiya? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús tsi' subeyob: Come aq'uebiletla cha'an mi la' cʌn i sujmlel cha'an i yumʌntel panchan mach bʌ tsictiyemic ti yambʌ ora. Pero mach aq'uebilobic. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Come majqui jach an i cha'an mi caj i yʌq'uentel yambʌ jinto mi' wen oñ'an. Majqui jach ma'anic i cha'an mi caj i lu' chilbentel chuqui an i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jini cha'an mic chʌn pejcañob ti lajiya come mi' q'uelob, pero ma'anic mi' c'otelob i wut. Mi' yubiñob, pero ma'anic mi' yochel ti' chiquin. Ma'anic mi' ch'ʌmbeñob isujm, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Che'i tsa' ts'ʌctiyi i t'an Isaías tsa' bʌ i yʌlʌ: “Mi caj la' wubin t'an pero ma'anic mi caj la' ch'ʌmben isujm. Mi caj la' q'uel pero ma'anic mi caj i c'otel la' wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Come tsa' ochi ti tonto i pusic'al jini winicob x'ixicob. Mach yomic i chʌn ubiñob t'an. Tsi' muts'uyob i wut ame i q'uelob ti' wut, ame i yubiñob ti' chiquin, ame i ch'ʌmbeñob isujm ti' pusic'al, ame i cha' sutq'uiñob i bʌ cha'an mic lajmesañob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Tijicñayetla come mi' c'otel la' wut. Mi la' wubin t'an ti la' chiquin. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Isujm mic subeñetla cabʌl x'alt'añob yic'ot winicob toj bʌ i pusic'alob wersa yomob i q'uel jini woli bʌ la' q'uel pero ma'anic tsi' q'ueleyob. Yomob i yubin jini woli bʌ la' wubin pero ma'anic tsi' yubiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ubinla i sujmlel jini lajiya cha'an jini winic tsa' bʌ majli ti wejch'uya pac'. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Che' an majqui mi' yubin jini wen t'an cha'an i yumʌntel Dios, mi ma'anic tsi' ch'ʌmbe isujm, ora mi' tilel jini xjontolil i chilben loq'uel jini pac' ti' pusic'al. Jiñʌch i sujmlel jini wejch'ubil bʌ ti' ti' bij. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jini wejch'ubil bʌ ti xajlelol jiñʌch mu' bʌ i yubin jini wen t'an. Tijicña i pusic'al mi' bʌc' jac'. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ma'anic i wi' ti' pusic'al. Ts'ita jach mi' jalijel. Che' mi' yubin wocol yic'ot i tic'lʌntel cha'an jini wen t'an, ti ora mi' tejchel tile bixel bʌ i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jini wejch'ubil bʌ ti ch'ixol jiñʌch mu' bʌ i jac' jini wen t'an. Cabʌl i c'ojo'ol cha'an pañimil yic'ot i lotintel cha'an chubʌ'añʌl. Mi' c'unte' jisan jini wen t'an ti' pusic'al cha'an ma'anic mi' yʌc' i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jini wejch'ubil bʌ ti wen bʌ lum jiñʌch mu' bʌ i yubin jini wen t'an, mu' bʌ i ch'ʌmben isujm. Mi' yʌc' i wut ti jo'c'al, ti uxc'al, ti lujump'ejl i cha'c'al. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tsi' subeyob yambʌ t'an ti lajiya. Tsi' yʌlʌ: I yumʌntel jini am bʌ ti panchan lajalʌch bajche' juntiquil winic tsa' bʌ i wejch'u wen bʌ pac' ti' lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Che' bʌ wʌyʌlob winicob, tsa' tili juntiquil i contra. Tsi' wejch'u mach bʌ wenic bʌ pac' ba' wejch'ubil jini trigo. Tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tsa' caji ti pasel i yopol. Tsa' caji i yʌc' i wut jini jam. Tsa' caji ti pasel jini mach bʌ wenic bʌ pac' ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tsa' tiliyob x'e'telob i cha'an i yum otot. Tsi' subeyob: “C Yum, ¿mach ba wenic jini pac' tsa' bʌ a wejch'u ti a lum? ¿Baqui ch'oyol jini mach bʌ wenic woli bʌ ti pasel?” che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tsi' subeyob: “Juntiquil xcontra tsi' cha'le jini”, che'en. Jini x'e'telob tsi' c'ajtibeyob: “¿A wom ba mic majlel c boc lojon loq'uel jini mach bʌ wenic bʌ jam?” che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","I yum tsi' yʌlʌ: “Mach comic, ame bojquic jini trigo che' mi la' boc loq'uel jini mach bʌ wenic. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","La' to tem colic jinto mi' lojtel trigo. Ti' yorajlel c'ajbal che' mi lac lot mi caj c suben x'e'telob cha'an mi' ñaxan tempañob jini mach bʌ wenic. Mi caj i tempañob cha'an mi' pulel. Pero jini trigo mi caj i cuchob tilel ti' yotlel”, che'en i yum otot. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Tsi' subeyob yambʌ t'an ti lajiya. Tsi' yʌlʌ: I yumʌntel jini am bʌ ti panchan lajalʌch bajche' i bʌc' pimel i c'aba' mostaza tsa' bʌ i ch'ʌmʌ winic. Tsi' wejch'u ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma'anic yambʌ pac' ñumen biq'uit bʌ bajche' jini. Che' mi' colel mi' ñusan jini pimel. Mi' colel bajche' te'. Mi' tilel te'lemut, mi' mel i c'u' ti' c'ʌb jini te', che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tsi' subeyob yambʌ t'an ti lajiya: I yumʌntel jini am bʌ ti panchan lajalʌch bajche' levadura. Tsi' ch'ʌmʌ juntiquil x'ixic. Tsi' yotsa ti uxp'is harina jinto tsi' xaxa ti pejtelel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús tsi' subeyob tempʌbilo' bʌ winicob x'ixicob pejtelel jini t'an ti lajiya tac. Cojach ti lajiya tsi' pejcayob ");
INSERT INTO ctuBl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","cha'an mi' ts'ʌctiyel i t'an jini x'alt'an tsa' bʌ i yʌlʌ: “Mi caj c cha'len t'an ti lajiya tac. Mi caj c sub jini maxto bʌ anic tsa' tsictiyi c'ʌlʌl ti' cajibal pañimil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Che' bʌ tsi' choco majlel jini tempʌbilo' bʌ, Jesús tsa' ochi ti otot. Tsa' tiliyob xcʌnt'añob i cha'an ba'an Jesús. Tsi' yʌlʌyob: Subeñon lojon i sujmlel jini lajiya. ¿Chuqui jini jam mach bʌ wenic ya' ti jamil? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús tsi subeyob: Jini winic mu' bʌ i wejch'un wen bʌ pac' jiñʌch i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jini jamil jiñʌch pañimil. Jini wen bʌ pac' jiñʌch i yalobilob i yumʌntel Dios. Jini jam mach bʌ wenic jiñʌch i yalobilob jini xjontolil. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jini xcontra tsa' bʌ i wejch'u pac' mach bʌ wenic jiñʌch xiba. I yorajlel c'ajbal che' mi' lojtel jini jam jiñʌch i jilibal pañimil. Jini x'e'telob jiñʌch ángelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Che' bajche' mi' tempʌyel jini mach bʌ wenic bʌ jam cha'an mi' pulel, che'ʌch mi' caj i yujtel ti' jilibal ili ora. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","I Yalobil Winic mi caj i choc tilel i yángelob. Mi caj i tempañob loq'uel ti' yumʌntel pejtelel mu' bʌ i yʌsañob ti mulil i pi'ʌlob yic'ot jini mu' bʌ i cha'leñob jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mi caj i chocob ochel ti c'ajc. Ya' mi' cajelob ti cabʌl uq'uel yic'ot quech'ecña bʌ i bʌquel i yej. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ti jim bʌ ora mi' caj ti tsictiyel i sʌclel jini tojo' bʌ i pusic'al che' bajche' q'uin ya' ti' yumʌntel i Tat. Jini am bʌ i chiquin cha'an mi' yubin, la' i yubin. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Che' yilal ja'el i yumʌntel jini am bʌ ti panchan bajche' jump'ejl chubʌ'añʌl wen letsem bʌ i tojol, mucul bʌ ti jamil. Tsi' taja juntiquil winic. Tsi' cha' mucu. Wen tijicña i pusic'al tsa' majli i chon pejtelel i chubʌ'an. Tsi' mʌñʌ jini jamil. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Che' yilal ja'el i yumʌntel panchan bajche' juntiquil xmʌñoñel woli bʌ i sajcan wen bʌ perla tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Che' bʌ tsi' taja jump'ejl wen letsem bʌ i tojol, tsa' majli i laj chon pejtelel i chubʌ'an. Tsi' mʌñʌ jini perla. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Che' yilal ja'el i yumʌntel jini am bʌ ti panchan bajche' chimo'chʌy tsa' bʌ chojqui ochel ti colem ñajb. Tsi' much'qui cabʌl chʌy ti chajp ti chajp. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Che' but'ulix tsi' tujc'ayob loq'uel winicob ti' ti' ñajb. Tsa' buchleyob. Tsi' yajcayob ochel wen bʌ chʌy ti chiquib tac. Tsi' chocoyob jini mach bʌ wenic. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Che' ja'el mi' caj ti ujtel ti' jilibal ili ora. Jini ángelob mi caj i tilelob. Parte mi caj i yʌc'ob jini tojo' bʌ. Parte mi caj i yʌc'ob jini jontolo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mi caj i chocob ochel ti c'ajc. Ya' mi' cajelob ti uq'uel, yic'ot quech'ecña bʌ i bʌquel i yej, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús tsi' subeyob: ¿Tsa' ba la' wen ch'ʌmbe isujm ti pejtelel? che'en. Tsi' jac'beyob: Tsa' cu, c Yum, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesús tsi' cha' subeyob: Jini cha'an jujuntiquil sts'ijbaya cʌntesʌbil bʌ ti' sujmlel i yumʌntel jini am bʌ ti panchan lajalʌch bajche' i yum otot mu' bʌ i loc'san ti' yajñib i chubʌ'an tsijib tac bʌ yic'ot oñiyix bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Che' bʌ tsa' ujti ti lajiya tac, Jesús tsa' loq'ui majlel ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Che' bʌ tsa' c'oti Jesús ti' lumal, tsi' cha'le cʌntesa ti' sinagoga judíojob. Tsa' toj sajtiyob i pusic'al winicob. Tsi' yʌlʌyob: ¿Baqui tsi' taja i ña'tʌbal yic'ot i p'ʌtʌlel cha'an ñuc bʌ i melbal? ");
INSERT INTO ctuBl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Mach ba jinic i yalobil jini xjuc'te'? ¿Mach ba jinic María i ña'? ¿Mach ba i yijts'iñobic Jesús jini Jacobo, yic'ot José, Simón yic'ot Judas? ");
INSERT INTO ctuBl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Mach ba i yijti'añobic ili año' bʌ la quic'ot? ¿Baqui tsi' taja pejtelel i ña'tʌbal? Che' tsi' yʌlʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tsa' caji i mich'leñob Jesús. Jesús tsi' subeyob: Mi' q'uejlel ti ñuc pejtel x'alt'an, pero ya' ti' lumal yic'ot ti' yotot ma'anic mi' q'uejlel ti ñuc, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesús ma'anic tsa' mejli i cha'len cabʌl ñuc bʌ i ye'tel ya'i, come ma'anic tsi' ñopoyob jini winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti jim bʌ ora jini yumʌl Herodes tsa' caji i yubin t'an cha'an ñuc bʌ i melbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes tsi' sube x'e'telob i cha'an: Jiñʌch Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'. Tsa' cha' tejchi ch'ojyel ba'an chʌmeño' bʌ. Jini cha'an woli' pʌstʌl ñuc bʌ i melbal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Come anix ora Herodes tsi' chucu Juan. Tsi' cʌchʌ. Tsi' yotsa ti mʌjquibʌl cha'an ti' t'an Herodías, i yijñam Felipe. Jini Felipe i yijts'in Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Come Juan tsi' sube Herodes: Tic'bil ti mandar ma' pʌyben i yijñam a wijts'in, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes yom i tsʌnsan Juan pero tsi' bʌc'ña winicob x'ixicob, come woli' yʌlob x'alt'añʌch jini Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Che' ti' q'uiñilel i jabilel Herodes, tsi' cha'le son xch'oc bʌ i yalobil Herodías ti yojlil xq'uiñijelob. Wen uts'at tsi' q'uele Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tsi' wersa wa'choco i t'an. Tsi' yʌlʌ mi caj i yʌq'uen jini xch'oc pejtelel mu' bʌ i c'ajtiben. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Xic'bil cha'an i ña' jini xch'oc tsi' yʌlʌ: Aq'ueñon ti colem latu i jol Juan tsa' bʌ i yʌc'ʌ ch'ʌmja', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jini rey tsi' mele i pusic'al. Pero wa'chocobilix i t'an ti' tojlel xq'uiñijelob. Jini cha'an Herodes tsi' yʌc'ʌ mandar cha'an mi' yʌq'uentel jini woli bʌ i c'ajtin. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tsi' choco majlel winic cha'an mi' set' t'ojben loq'uel i bic' Juan ya' ti cárcel. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tsa' pit ch'ʌjmi tilel i jol Juan ti colem latu. Tsa' aq'uenti jini xch'oc. Jini xch'oc tsi' yʌq'ue i ña'. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tsa' tiliyob xcʌnt'añob i cha'an Juan. Tsi' ch'ʌmbeyob majlel i bʌc'tal. Tsi' mucuyob. Tsa' majli i subeñob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Che' bʌ tsi' yubi Jesús, tsa' majli ti barco ti colem bʌ i tiquiñal lum ti' bajñelil. Che' bʌ tsi' yubiyob winicob x'ixicob, jomocña tsa' loq'uiyob ti tejclum tac cha'an mi' tsajcañob majlel ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús tsa' tili. Tsi' q'uele bajc'ʌl winicob x'ixicob. Tsi' p'untayob. Tsi' lajmesa jini xc'amʌjelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Che' wolix ti bʌjlel q'uin, tsa' tiliyob ba'an Jesús xcʌnt'añob i cha'an. Tsi' yʌlʌyob: Jiñʌch colem bʌ i tiquiñal pañimil. Tsa'ix ñumi q'uin. Subeñob majlel winicob x'ixicob ti tejclum tac cha'an mi' mʌñob i bʌl i ñʌc', che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús tsi' subeyob: Mach wersajic mi' sujtelob. Aq'ueñob jatetla chuqui mi' c'uxob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tsi' subeyob: Cojach an jo'q'uejl waj yic'ot cha'cojt chʌy, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús tsi' subeyob: Ch'ʌmʌla tilel ba' añon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús tsi' sube winicob x'ixicob cha'an mi' buchtʌlob ti jam. Tsi' ch'ʌmʌ jini jo'q'uejl waj yic'ot cha'cojt chʌy. Tsi' letsa i wut ti panchan. Tsi' cha'le oración. Tsi' xet'e jini waj. Tsi' yʌq'ue xcʌnt'añob i cha'an. Jini xcʌnt'añob tsi' pucbeyob winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tsi' c'uxuyob ti pejtelelob. Tsa' ñaj'ayob. Tsi' lotoyob lajchʌmp'ejl chiquib but'ul ti' xujt'il tsa' bʌ colobaji. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Che' bajche' jo'p'ejl mil winicob tsi' c'uxuyob waj. Ya'an ja'el x'ixicob yic'ot alobob mach bʌ anic tsa' tsijquiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesús tsi' subeyob ochel ti barco xcʌnt'añob i cha'an, cha'an mi' ñaxan c'axelob ti junwejl colem ñajb. I bajñel tsa' cʌle i subeñob sujtel jini winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Che' bʌ tsa' ujti i subeñob sujtel, tsa' letsi majlel ti' bajñelil ti bujtʌl cha'an mi' cha'len oración. Che' ti ic'ajel ya'an ti' bajñelil. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ya'an jini barco ti ojlil colem ñajb. Woli' xewulan i bʌ ti ja'. Come woli' jats' jini ic'. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Che' yomix sʌc'an tsa' tili Jesús. Woli ti xʌmbal ti pam ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jini xcʌnt'añob che' bʌ tsi' q'ueleyob woli ti xʌmbal ti pam ja', tsa' wen cajiyob ti bʌq'uen. Tsi' yʌlʌyob: I ch'ujlel jach winic, che'ob. Wen c'am tsi' cha'leyob oñel cha'an bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesús tsi' bʌc' pejcayob. Tsi' subeyob: Tijicñesan la' pusic'al come joñoñʌch. Mach mi la' cha'len bʌq'uen, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro tsi' sube: C Yum mi jatetʌch, subeñon tilel ba' añet ti' pam ja', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús tsi' sube: La', che'en. Che' bʌ tsa' loq'ui Pedro ti barco, tsa' caji ti xʌmbal ti pam ja' cha'an mi' majlel ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Che' bʌ tsi' q'uele ic' tsa' caji ti bʌq'uen. Tsa' caji ti ochel majlel ti ja'. C'am tsi' cha'le t'an. Tsi' yʌlʌ: C Yum, coltañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesús tsi' bʌc' choco majlel i c'ʌb. Tsi' chucu Pedro. Tsi' sube: Jatet mach bʌ anic ma' ñop ti pejtelel a pusic'al, ¿chucoch tsa' tejchi tile bixel bʌ a pusic'al? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Che' bʌ tsa' ochiyob ti barco tsa' lajmi ic'. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jini año' bʌ ti' mal barco tsa' tiliyob. Tsi' ch'ujutesayob Jesús. Tsi' yʌlʌyob: Isujm i Yalobilet Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Che' bʌ tsa' c'axiyob, tsa' c'otiyob ti' lumal Genesaret. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jini winicob ya'i che' bʌ tsi' cʌñʌyob Jesús, tsa' caji i pucob majlel t'an ti pejtelel i lumal. Tsi' pʌyʌyob tilel ba'an Jesús pejtelel xc'amʌjelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tsi' c'ajtibeyob cha'an mi' tʌlbeñob i yoc i pislel. Tsa' lu' c'oq'uesʌntiyob jini tsa' bʌ i tʌlbeyob i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jini sts'ijbayajob yic'ot fariseojob ch'oyolo' bʌ ti Jerusalén tsa' tiliyob ba'an Jesús. Tsi yʌlʌyob: ");
INSERT INTO ctuBl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Chucoch mi' ñusañob i subal lac ñojte'el jini xcʌnt'añob a cha'an? Come ma'anic mi' pocob i c'ʌb che' mi' cajelob ti c'ux waj, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús tsi' subeyob: ¿Chucoch mi la' ñusan i mandar Dios cha'an i subal la' ñojte'el? ");
INSERT INTO ctuBl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Come Dios tsi' yʌlʌ ti mandar: “Q'uele ti ñuc a tat a ña'”. Tsi yʌlʌ ja'el: “Jini mu bʌ i p'aj i tat i ña' la' wersa chʌmic”. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","An winicob mu' bʌ i subeñob i tat i ña' ma'anix chuqui mi mejlel i yʌq'ueñob, come tsa'ix i subeyob i cha'añʌch Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jatetla mi la' lon al mach i wentajobic cha'an mi' coltañob i tat i ña'. Che' jini tsa'ix la' jisʌbe i c'ʌjñibal i mandar Dios ti la' pusic'al cha'an mi la' jac'ben i subal la' ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Cha'p'ejl jax la' pusic'al. Isujmʌch bajche' tsi' tajayetla ti t'an Isaías che' bʌ tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ti' yej jach mi' subob c ñuclel jini winicob x'ixicob, pero ti' pusic'al mi' cʌyoñob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lolom jach mi' ch'ujutesañoñob, come jiñʌch i mandar tac winicob woli bʌ i cʌntesañob”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesús tsi' pʌyʌ tilel winicob x'ixicob. Tsi' subeyob: Ñich'tanla. Ch'ʌmbenla isujm. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chuqui tac mi' yochel ti' yej winic, ma'anic mi' bibesan. Pero chuqui tac mi' loquel ti' yej, jiñʌch mu' bʌ i bibesan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tsa' tiliyob xcʌnt'añob. Tsi' subeyob: ¿Ña'tʌbil ba a cha'an tsa' mich'ayob fariseojob che' bʌ tsi' yubiyob a t'an? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús tsi' subeyob: Pejtelel pimel mach bʌ pʌc'bilic cha'an c Tat am bʌ ti panchan mi' caj ti bojquel. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","La' to ajnicob. Xpots'ob jini xpʌs bijob. Mi xpots' jini mu' bʌ i toj'esan majlel xpots', ti' cha'ticlelob mi' yajlelob ti ch'en, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro tsi' sube: Subeñon lojon i sujmlel jini lajiya, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús tsi' yʌlʌ: Jixcu jatetla ja'el, ¿maxto ba anic mi la' ch'ʌmben isujm? ");
INSERT INTO ctuBl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mach ba la' wujilic, jini mu' bʌ i yochel ti la quej mi' majlel ti lac ñʌc'? Ñumel jach mi' ñumel. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero jini mu' bʌ i loq'uel ti' yej winic ch'oyolʌch ti' pusic'al. Jiñʌch mu' bʌ i bibesan. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Come ch'oyol ti' pusic'al winic mi' tilel jontol bʌ i ña'tʌbal, yic'ot tsʌnsa, yic'ot ts'i'lel, yic'ot jam otot, yic'ot xujch', yic'ot jop't'an, yic'ot p'ajoñel. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jiñʌch mu' bʌ i bibesan winic. Ma'anic mi' bibesʌntel winic che' mi' c'ux waj che' mach pocolic i c'ʌb, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús tsa' loq'ui ya'i. Tsa' majli ti' lumal Tiro yic'ot ti' lumal Sidón. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Awilan tsa' tili x'ixic cananea ya' bʌ chumul. C'am tsi' cha'le t'an. Tsi yʌlʌ: P'untañon, c Yum, i Yalobilet David. C'ax cabʌl woli' tic'lʌntel xch'oc bʌ calobil cha'an ti' xibʌjlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús ma'anic chuqui tsi' sube mi jump'ejlic t'an. Tsa' tili xcʌnt'añob i cha'an. Ti wocol t'an tsi' yʌlʌyob: Subenix majlel jini x'ixic come woli' cha'len c'am bʌ t'an ti lac pat, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús tsi' subeyob: Chocbilon tilel cha'an jach jini sajtemo' bʌ tiñʌme' ti Israel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jini x'ixic tsa' cha' tili. Tsi' ñocchoco i bʌ ba'an Jesús. Tsi' yʌlʌ: C Yum, coltañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús tsi' sube: Mach wenic mi lac chilben i waj alobob cha'an mi lac chocben alʌ ts'i', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jini x'ixic tsi' yʌlʌ: Isujm, c Yum. Pero jini alʌ ts'i' mi' c'ux i xejt'il mu' bʌ i p'ajtel ti yebal i mesa i yum, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús tsi' sube: X'ixic, tsa'ix a ñopo ti pejtelel a pusic'al. La' aq'uentiquet che' bajche' a wom, che'en. Tsa' bʌc' lajmi i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús tsa' loq'ui ya'i. Tsa' ñumi majlel ti' ti' colem ñajb i c'aba' Galilea. Tsa' letsi majlel ti bujtʌl. Ya'i tsa' caji ti buchtʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bajc'ʌl winicob x'ixicob tsa' tiliyob ba'an. Tsi' pʌyʌyob tilel jini mach bʌ añobic i c'ʌjñibal i yoc, yic'ot jini xpots'ob, yic'ot jini x'uma'ob, yic'ot jini xc'ʌscujelob, yic'ot cabʌl yaño' bʌ. Ya' tsi' yʌc'ʌyob ba' wa'al Jesús. Tsi' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jini cha'an tsa' toj sajtiyob i pusic'al che' bʌ tsi' q'ueleyob woliyob ti t'an x'uma'ob, lajmeñobix jini xc'ʌscujelob, woliyob ti xʌmbal jini mach bʌ añobic i c'ʌjñibal i yoc, woli' c'otelob i wut jini xpots'ob. Tsi' tsictesayob i ñuclel i Dios israelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús tsi' pʌyʌ tilel xcʌnt'añob i cha'an. Tsi' yʌlʌ: Mic p'untan jini winicob x'ixicob, come i yuxp'ejlelix q'uin wʌ' añob quic'ot. Ma'anic i bʌl i ñʌc'. Mach comic c subeñob sujtel che' wi'ñayobix ame c'uñ'acob ti bij, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jini xcʌnt'añob i cha'an tsi' subeyob: ¿Baqui mic taj lojon waj ilayi ti jochol bʌ lum cha'an mi' c'uxob? come cabʌlob jini winicob x'ixicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús tsi' subeyob: ¿Jayq'uejl waj an' la' cha'an? che'en. Tsi' yʌlʌyob: Wucq'uejl yic'ot cha'cojt alʌ chʌy, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jesús tsi' sube winicob x'ixicob cha'an mi' buchtʌlob ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tsi' ch'ʌmʌ jini wucq'uejl waj yic'ot jini chʌy. Che' bʌ tsa' ujti i suben Dios wocolix i yʌlʌ tsi' xet'e. Tsi' yʌq'ue xcʌnt'añob i cha'an. Jini xcʌnt'añob tsi' pucbeyob winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ti pejtelel tsi' c'uxuyob. Tsa' ñaj'ayob. Tsi' lotoyob wucp'ejl colem chiquib but'ul ti' xujt'il tac tsa' bʌ colobaji. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Che' bajche' lujumbajc' winicob tsi' c'uxuyob. An x'ixicob yic'ot alobob mach bʌ tsicbilobic. ");
INSERT INTO ctuBl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús tsi' subeyob sujtel winicob x'ixicob. Tsa' ochi ti barco. Tsa' majli ti lum i c'aba' Magdala. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tsa' tiliyob fariseojob yic'ot saduceojob cha'an mi' yilʌbeñob i pusic'al Jesús. Tsi' c'ajtibeyob cha'an mi' pʌsbeñob i yejtal i p'ʌtʌlel ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús tsi' subeyob: Che' woli ti bʌjlel q'uin mi la' wʌl: “Jamʌl pañimil ijc'ʌl come chʌchʌc i yebal panchan”, che'etla. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ti sʌc'ajel mi la' wʌl: “Talix ja'al come chʌchʌquix i yebal panchan. Wolix i mʌjquel”, che'etla. ¡Cha'p'ejl jax la' pusic'al! Mi la' ña'tʌben i sujmlel chuqui tac mi la' q'uel ti panchan. ¡Pero mach la' wujilic chuqui woli' yujtel wʌle! ");
INSERT INTO ctuBl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jini jontolo' bʌ winicob x'ixicob but'ulo' bʌ ti' ts'i'lel woli' sajcañob i yejtal c p'ʌtʌlel. Ma'anic mi caj i yʌq'uentelob i q'uel, jini jach i yejtal c p'ʌtʌlel tsa' bʌ pʌsle ti Jonás jini x'alt'an, che'en Jesús. Tsi' cʌyʌyob. Tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tsa' c'otiyob xcʌnt'añob i cha'an ti junwejl ja'. Tsa' ñajʌyi ti' pusic'al i ch'ʌmob tilel caxlan waj. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús tsi' subeyob: Chʌcʌ q'uele la' bʌ cha'an i levadura jini fariseojob yic'ot saduceojob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tsa' caji i pejcañob i bʌ. Tsi' yʌlʌyob: Ma'anic tsa' lac ch'ʌmʌ tilel caxlan waj, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ña'tʌbilix i cha'an Jesús tsi' subeyob: Winicob mach bʌ anic mi la' ñop ti pejtelel la' pusic'al, ¿chucoch woli la' cʌlʌx pejcan la' bʌ cha'an ma'anic la' caxlan waj? ");
INSERT INTO ctuBl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Maxto ba anic mi la' ch'ʌmben isujm? ¿Mach ba c'ajalic la' cha'an jini jo'q'uejl waj cha'an jo'p'ejl mil winicob? ¿Mach ba c'ajalic la' cha'an jayp'ejl chiquib tsa' la' loto? ");
INSERT INTO ctuBl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jixcu jini wucq'uejl waj cha'an jini chʌmp'ejl mil winicob, ¿mach ba c'ajalic la' cha'an jayp'ejl colem chiquib tsa' la' loto? ");
INSERT INTO ctuBl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chucoch ma'anic mi' la' ch'ʌmben isujm? Mach jiniqui caxlan waj tsac ña'ta che' bʌ tsac subeyetla cha'an mi la' chʌcʌ q'uel la' bʌ cha'an i levadura fariseojob yic'ot saduceojob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tsi' ch'ʌmbeyob isujm yom mi' chʌcʌ q'uelob i bʌ cha'an i cʌntesʌbal fariseojob yic'ot saduceojob, mach cha'anic jini levadura am bʌ ti caxlan waj. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Che' bʌ tsa' ochi Jesús ya' ti' lumal Cesarea Filipo, tsi' c'ajtibe xcʌnt'añob i cha'an: ¿Majqui i Yalobil Winic mi' yʌlob winicob x'ixicob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tsi' yʌlʌyob: Cha'tiquil uxtiquil mi' yʌlob jatet Juanet tsa' bʌ i yʌc'ʌ ch'ʌmja'. Yaño' bʌ mi' yʌlob Elíaset. Yaño' bʌ mi' yʌlob Jeremíaset. Yaño' bʌ mi' yʌlob juntiquil x'alt'añet, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús tsi' c'ajtibeyob: Jixcu jatetla, ¿Majquiyon mi la' wʌl? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro tsi' jac'ʌ: Jatet Cristojet, jini yajcʌbil bʌ. I Yalobilet jini cuxul bʌ Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús tsi' jac'ʌ: Tijicña a pusic'al Simón, i yalobilet bʌ Jonás, come mach tilemic ti winicob a ña'tʌbal, pero c Tat am bʌ ti panchan tsi' cʌntesayet. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mic subeñet Pedrojet. Ti' pam jini xajlel mi caj c wa'chocon xñopt'añob c cha'an. Jini mu' bʌ i yʌc'ob ti chʌmel mach mejlic i jisañob. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi caj cʌq'ueñet i llavejlel i yumʌntel jini am bʌ ti panchan. Pejtelel majqui ma' jamben ti pañimil mi caj i jambentel ti panchan. Pejtelel majqui ma' ñup'ben ti pañimil mi caj i ñup'bentel ti panchan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesús tsi' tiq'ui xcʌnt'añob cha'an ma'anic mi' subeñob i pi'ʌlob mi juntiquilic mi jiñʌch Cristo, jini yajcʌbil bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti jim bʌ ora, Jesús tsa' caji i cʌntesan xcʌnt'añob i cha'an. Tsi' yʌlʌ wersa mi' majlel ti Jerusalén i yubin cabʌl wocol ti' c'ʌb xñoxob año' bʌ i ye'tel yic'ot ñuc bʌ motomajob yic'ot sts'ijbayajob. Wersa mi' caj ti tsʌnsʌntel. Mi caj i cha' tejchel ch'ojyel ti yuxp'ejlel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro tsa' caji i pʌy Jesús ti' bajñelil cha'an mi' tic'. Tsi' yʌlʌ: C Yum, la' i p'untañet Dios. Mach che'ic mi caj a wujtel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús tsi' sutq'ui i bʌ. Tsi' sube Pedro: Tʌts'ʌ a bʌ ba' añon, Satanás. Jatet xmʌctayajet tic tojlel. Ma'anic ma' ch'ʌmben isujm chuqui yom Dios. Che' jach ma' ch'ʌmben isujm chuqui yom winicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesús tsi' sube xcʌnt'añob i cha'an: Mi an majqui yom i tsajcañon, la' i cʌy chuqui yom ti' bajñel pusic'al. La' i ch'ʌm i cruz. La' i tsajcañon. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Come majqui jach yom i bajñel cʌntan i ch'ujlel mi caj i sʌt. Majqui jach mi' yʌc' i ch'ujlel cha'an mi' tsajcañon mi caj i cʌntan. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Come ¿chuqui mi' taj winic mi tsi' lon ch'ʌmʌ pejtelel pañimil pero mi tsa' sajti i ch'ujlel? Mi tsa' sajti i ch'ujlel winic, ¿chuqui mi mejlel i yʌc' cha'an mi' cha' taj? ");
INSERT INTO ctuBl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Come mi caj i tilel i Yalobil Winic ti' ñuclel i Tat yic'ot i yángelob. Mi caj i yʌq'ueñob i tojol winicob x'ixicob ti jujuntiquil cha'an chuqui tac tsi' meleyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Isujm mic subeñetla: Lamital ili wa'alo' bʌ ma'anic mi caj i chʌmelob jinto tsa'ix i q'ueleyob i Yalobil Winic che' mi' tilel ti' yumʌntel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Che' ñumenix wʌcp'ejl q'uin, Jesús tsi' pʌyʌ majlel Pedro yic'ot Jacobo yic'ot Juan i yijts'in Jacobo c'ʌlʌl ti chan bʌ wits. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tsa' yʌjñi Jesús ti' wutob. Ts'ʌylaw i wut che' lajal bajche' q'uin. Wen sʌsʌc tsa' ajni i pislel lajal bajche' i sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Awilan, tsa' tsictiyi Moisés yic'ot Elías. Tsi' cha'leyob t'an yic'ot Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro tsi' sube Jesús: C Yum, uts'at mi laj cʌytʌl ilayi. Mi a wom, mi caj c mel uxp'ejl lejchempat, jump'ejl a cha'an, jump'ejl i cha'an Moisés, jump'ejl i cha'an Elías. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Che' woli to ti t'an, awilan, tsi' mosoyob wen sʌsʌc bʌ tocal. Tsa' loq'ui t'an ti tocal. Tsi' yʌlʌ: Jiñʌch Calobil mu' bʌ j c'uxbin. Tijicña c pusic'al mij q'uel. Ubinla i t'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Che' bʌ tsi' yubiyob xcʌnt'añob, tsa' ñuc yajliyob ti lum. Woliyob ti cabʌl bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tsa' tili Jesús. Tsi' tʌlʌyob. Tsi' yʌlʌ: Ch'ojyenla. Mach mi la' cha'len bʌq'uen, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Che' bʌ tsi' letsayob i wut tsi' q'ueleyob ma'anix majqui ya'an, jini jach Jesús ti' bajñelil. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Che' woli' jubelob tilel ti wits, Jesús tsi' wersa tiq'uiyob: Mach mi la' suben winic mi juntiquilic chuqui tsa' la' q'uele jinto mi' cha' ch'ojyel i Yalobil Winic ba'an chʌmeño' bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jini xcʌnt'añob i cha'an tsi' c'ajtibeyob: ¿Chucoch mi' yʌlob sts'ijbayajob ñaxan yom mi' tilel Elías? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús tsi' subeyob: Isujmʌch, ñaxan mi' tilel Elías cha'an mi' cha' toj'esan pejtelel chuqui an. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero mic subeñetla, tsa'ix tili Elías. Ma'anic tsi' cʌñʌyob, pero tsi' tic'layob bajche' jach yomob. Che' ja'el, mi caj i yubin wocol i Yalobil Winic ti' c'ʌbob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jini xcʌnt'añob tsa' caji i ch'ʌmbeñob isujm jiñʌch Juan tsa' bʌ i yʌc'ʌ ch'ʌmja' tsa' bʌ tili che' bajche' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Che' bʌ tsa' c'otiyob ba' tempʌbilob winicob x'ixicob, tsa' tili winic. Tsi' ñocchoco i bʌ ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tsi' yʌlʌ: C Yum, p'untan calobil. Come an i juquin chʌmel. Wen woli ti wocol. Cabʌl mi' yajlel ti c'ajc. Cabʌl mi' yajlel ti ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tsac pʌyʌ tilel ba'an xcʌnt'añob a cha'an, pero ma'anic tsa' mejli i lajmesañob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús tsi' jac'ʌ: Winicob x'ixicob año' bʌ wʌle, mach bʌ anic mi la' ñop, sojquemetla. ¿Jayp'ejl to q'uin wʌ' añon la' wic'ot? ¿Jayp'ejl to q'uin mi caj j cuchbeñetla la' sajtemal? Pʌyʌla tilel wʌ' ba' añon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús tsi' tic'be i xibʌjlel. Tsa' loq'ui ti' pusic'al. Tsa' bʌc' lajmi jini ch'iton. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tsa' tiliyob xcʌnt'añob cha'an mi' bajñel pejcañob Jesús. Tsi' yʌlʌyob: ¿Chucoch ma'anic tsa' mejli c choc lojon loq'uel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús tsi' subeyob: Come ma'anic mi la' ñop ti pejtelel la' pusic'al. Come isujm mic subeñetla, mi tsa' la' ñopo ti la' pusic'al mi che' jach ya wistʌl che' bajche' i bʌc' mostaza, che' jini muq'uix mejlel la' suben jini wits cha'an mi' tʌts' i bʌ ti yambʌ i yajñib. Mi caj i tʌts' i bʌ. Ma'anic chuqui mach bʌ mejlic la' cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero jini xibajob ma'anic mi' to'ol loq'uelob, che' jach mi' loq'uelob ti oración yic'ot ti ch'ajb, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Che' ya' añob ti Galilea Jesús tsi' subeyob: I Yalobil Winic mi caj i yʌjq'uel ti' c'ʌb winicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jini winicob mi caj i tsʌnsañob. Ti yuxp'ejlel q'uin mi caj i cha' tejchel ch'ojyel, che'en Jesús. Wen ch'ijiyem tsi' yubiyob xcʌnt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Che' bʌ tsa' c'otiyob ti Capernaum, jini xch'ʌm tojoñelob tsa' tiliyob ba'an Pedro. Tsi' yʌlʌyob: ¿Mach ba anic mi' yʌc' cha'p'ejl dracma tojoñel a Maestro? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro tsi' yʌlʌ: Mu' cu, che'en. Che' bʌ tsa' ochi Pedro ti otot, Jesús tsa' ñaxan caji i pejcan. Tsi' yʌlʌ: ¿Bajche' ma' wʌl, Simón? ¿Majqui mi' yʌq'ueñob tojoñel yumʌlob ti pañimil? ¿Jim ba i yalobilob o yaño' bʌ? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro tsi' sube: Jini yaño' bʌ, che'en. Jesús tsi' sube: Che' jini, mach i wentajic i yalobilob cha'an mi' yʌc'ob tojoñel. ");
INSERT INTO ctuBl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero cucu ti colem ñajb ame mi lac techbeñob i mich'ajel. Choco ochel luquijib. Ch'ʌmʌ jini ñaxan bʌ chʌy mu' bʌ a chuc. Che' ma' cawben i yej mi caj a taj jump'ejl estatero. Ch'ʌmʌ majlel. Aq'ueñob cha'añon cha'añet. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti jim bʌ ora tsa' tiliyob xcʌnt'añob ba'an Jesús. Tsi' c'ajtibeyob: ¿Majqui ñumen ñuc ti' yumʌntel panchan? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús tsi' pʌyʌ tilel juntiquil alob. Tsi' yʌc'ʌ ya' ti ojlil ba' añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Tsi' subeyob: Isujm, mic subeñetla, mi ma'anic mi la' sutq'uin la' bʌ cha'an lajaletla bajche' alobob, ma'anic mi caj la' wochel ti' yumʌntel panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Majqui jach mi' mel i bʌ ti pec' che' bajche' jini alob, c'ax ñuc mi caj i yajñel ti' yumʌntel panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Majqui jach mi' coltan tij c'aba' juntiquil alob, mi' coltañon. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Majqui jach mi' yʌsan ti mulil juntiquil ch'o'ch'oc bʌ woli bʌ i ñopon mach uts'atic. Ñumen uts'at tsa'ic ñaxan cʌjchi na'atun ti' bic' jini winic cha'an mi' chojquel ochel ti chʌmel ti ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mi caj i tajob wocol jini año' bʌ ti pañimil mu' bʌ i yʌsañob ti mulil winicob x'ixicob. Wersa mi' tilelob jini mu' bʌ i yʌsañob ti mulil, pero mi caj i tojob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mi woli' yʌsañet ti mulil a c'ʌb mi a woc, tsepe loq'uel. Choco. Uts'at mi tsa' taja a cuxtʌlel che' xbor c'ʌbet, che' xbor oquet. Mach uts'atic mi tsa' chojquiyet ti c'ajc mach bʌ anic mi' jilel che' cha'ts'ijt a c'ʌb a woc. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Che' ja'el, mi woli' yʌsañet ti mulil a wut, loc'san. Choco. Uts'at mi tsa' taja a cuxtʌlel che' jump'ejl a wut. Mach uts'atic mi tsa' chojquiyet ti infierno ti c'ajc che' an cha'p'ejl a wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Chʌcʌ q'uele la' bʌ cha'an ma'anic mi la' ts'a'len mi juntiquilic ch'o'ch'oc bʌ, come mic subeñetla, ya' ti panchan i yángelob jini ch'o'ch'oco' bʌ ti pejtelel ora mi' q'uelbeñob i wut c Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Come tsa' tili i Yalobil Winic cha'an mi' coltan sajtemo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Bajche' mi la' wʌl? Mi an juntiquil winic am bʌ jo'c'al i tiñʌme' mi tsa' sajti juncojt, ¿mach ba anic mi' cʌy jini bolonlujuncojt i jo'c'al cha'an mi' majlel i sajcan jini sajtem bʌ ya' ti bujtʌl? ");
INSERT INTO ctuBl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi tsi' taja, isujm mic subeñetla, ñumen tijicña i pusic'al mi' q'uel jini juncojt bajche' jini bolonlujuncojt i jo'c'al mach bʌ anic tsa' sajtiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Che' ja'el, la' Tat am bʌ ti panchan mach yomic mi' sajtel mi juntiquilic jini ch'o'ch'oco' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mi tsi' cha'le mulil ti a contra a wermano, cucu, bajñel suben i mul. Mi tsi' jac'beyet tsa'ix a taja a wermano. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mi ma'anic mi' jac'beñet, pʌyʌ majlel juntiquil cha'tiquil a wic'ot cha'an mi' tsictiyel ti' tojlel cha'tiquil uxtiquil testigo jujump'ejl t'an tsa' bʌ ajli. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mi mach yomic i jac'ben, subeñob xñopt'añob mu' bʌ i tempañob i bʌ. Mi ma'anic mi' jac'ben xñopt'añob jini winic, la'ix ajnic che' lajal bajche' gentil yic'ot xch'ʌm tojoñel. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Isujm mic subeñetla, chuqui jach mi la' cʌch ti pañimil cʌchbil ti panchan. Chuqui jach mi la' jit ti pañimil jitbil ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mic subeñetla ja'el, mi an cha'tiquilob ti pañimil mu' bʌ i temob i t'an cha'an chuqui mi' c'ajtiñob, che' jini mi caj i yʌq'uentelob cha'an c Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Come baqui jach an cha'tiquil uxtiquil tempʌbilo' bʌ cha'an tij c'aba' yʌ'ʌch añon quic'otob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tsa' tili Pedro ba'an Jesús. Tsi' yʌlʌ: C Yum, ¿jayyajl yom mic ñusʌben i mul quermano che' an chuqui mi' cha'len tij contra? ¿Yom ba c'ʌlʌl ti' wucyajlel mic ñusʌben i mul? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús tsi' sube: Mic subeñet, mach jasʌlic che' ti wucyajl jach, pero yom c'ʌlʌl ti lujump'ejl i chʌnc'al ti wucyajlel (77). ");
INSERT INTO ctuBl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jini cha'an, i yumʌntel jini am bʌ ti panchan lajalʌch bajche' juntiquil yumʌl woli bʌ i ña'tʌbeñob i bet x'e'telob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Che' bʌ tsa' caji i ña'tʌbeñob i bet jini x'e'telob, tsi' pʌyʌ tilel juntiquil am bʌ i bet lujump'ejl mil talento. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma'anic tsa' mejli i toj i bet. Jini cha'an i yum tsi' yʌc'ʌ mandar cha'an mi' chojñel jini winic yic'ot i yijñam yic'ot i yalobilob yic'ot pejtelel i chubʌ'an cha'an mi' toj i bet. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jini x'e'tel tsi' ñocchoco i bʌ. Tsi' c'ajti ti wocol t'an: “C yum, pijtan to. Mu' to caj c tojbeñet ti pejtelel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jini cha'an i yum tsi' p'unta jini x'e'tel. Tsi' colo. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Che' woli ti sujtel jini x'e'tel tsi' taja juntiquil i pi'ʌl ti e'tel am bʌ i bet jo'c'al denario. Tsi' chucu ti' bic'. Tsi' yʌlʌ: “Tojbeñon a bet”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jini i pi'ʌl t i e'tel tsi' ñocchoco i bʌ. Ti wocol t'an tsi' yʌlʌ: “Pijtan to. Mu' to c tojbeñet ti pejtelel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jini x'e'tel ma'anic tsi' jac'ʌ. Tsa' majli i yotsan ti mʌjquibʌl jinto mi' toj i bet. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","I pi'ʌlob ti e'tel tsi' q'ueleyob chuqui tsa' ujti. Tsa' caji i melob i pusic'al. Tsa' majli i subeñob i yum pejtelel chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jini i yum tsi' pʌyʌ tilel. Tsi' sube: “Jontol bʌ x'e'telet, tsac ñusʌbeyet a bet come ti wocol t'an tsa' c'ajtibeyon. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Mach ba yomic ma' p'untan a pi'ʌl ti e'tel, che' bajche' tsac p'untayet?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","I yum tsa' caji ti mich'ajel. Tsi' yʌc'ʌ ti' c'ʌb año' bʌ i ye'tel ti mʌjquibʌl jinto mi' lu' toj i bet. ");
INSERT INTO ctuBl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Che' ja'el mi caj i meletla c Tat ti panchan ti jujuntiquiletla, mi ma'anic mi la' ñusʌben i mul la' wermano ti jump'ejl la' pusic'al, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Che' bʌ tsa' ujti Jesús ti ili cʌntesa, tsa' loq'ui ti Galilea. Tsa' majli ti lum i c'aba' Judea ti junwejl Jordán ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Bajc'ʌl winicob x'ixicob tsi' tsajcayob majlel. Ya'i tsi' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tsa' tiliyob fariseojob ba'an Jesús, come yomob i yilʌben i pusic'al. Jini fariseojob tsi' c'ajtibeyob: ¿Tic'bil ba winic ti mandar cha'an mi' choc loq'uel i yijñam che' mach tijicñayic mi' q'uel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús tsi' subeyob: ¿Mach ba anic tsa' la' q'uele ti jun: “Dios tsa' bʌ i meleyob ti ñaxan tsi' mele winic yic'ot x'ixic”? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tsi' yʌlʌ: “Jini cha'an mi' cʌy i tat i ña' winic, mi' ñochtan i yijñam. Jini cha'tiquil mi' yochelob ti juntiquil jach”. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mach chʌn cha'tiquilix. Juntiquil jach. Jini cha'an mach i cha' t'ox winic chuqui tsi' tempa Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tsi' c'ajtibeyob: ¿Chucoch, che' jini, tsi' cha'le mandar Moisés cha'an mi la cʌq'uen la quijñam i juñilel ba' ts'ijbubil mi tsa'ix laj cʌyʌ? Tsi' yʌc'ʌ mandar cha'an mi lac junyajlel cʌy, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús tsi' jac'beyob: Cha'an i tsʌtslel la' pusic'al Moisés tsi' yʌq'ueyetla t'an cha'an mi mejlel la' choc loq'uel la' wijñam che' mi la' wʌq'uen i juñilel. Pero mach che'ic ti' cajibal pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mic subeñetla majqui jach mi' to'o cʌy i yijñam che' ma'anic i ts'i'lel cha'an mi' pʌy yambʌ, woli' cha'len ts'i'lel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jini xcʌnt'añob i cha'an tsi' subeyob: Mi wersa yom mi' yajñel winic yic'ot i yijñam, tic'ʌl mi mach wenic mi' pʌyob i yijñam winicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús tsi' subeyob: An winicob mach bʌ mejlic i ch'ʌmbeñob isujm jini t'an, cojach jini mu' bʌ i coltʌntelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","An winicob mach bʌ mejlic i pʌyob i yijñam, come che'ʌch tsi' q'ueleyob pañimil. Yaño' bʌ tic'bilob cha'an winicob. Yaño' bʌ che' jach mi' to'ol ajñelob cha'an i ye'tel ti' yumʌntel panchan. Majqui jach mi mejlel i ch'ʌmben isujm, la' i ch'ʌmben isujm, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tsa' pʌjyiyob tilel alobob ba'an Jesús cha'an mi' yʌc' i c'ʌb ti jini alobob yic'ot cha'an mi' cha'len oración. Jini xcʌnt'añob tsi' tiq'uiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús tsi' yʌlʌ: La' tilicob alobob ba' añon. Mach mi la' tic'ob, come pejtelel mu' bʌ i tilelob bajche' jini mi caj i yochelob ti' yumʌntel jini am bʌ ti panchan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Che' bʌ tsa' ujti i yʌc' i c'ʌb ti jini alobob tsa' caji ti majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Awilan, tsa' tili juntiquil ba'an Jesús. Tsi' yʌlʌ: Wen bʌ Maestro, ¿chuqui yom mic cha'len cha'an mic taj j cuxtʌlel mach bʌ anic mi' jilel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús tsi' sube: ¿Chucoch ma' pejcañon ti wen bʌ? An juntiquil jach wen bʌ, jiñʌch Dios. Mi a wom a taj a cuxtʌlel mach bʌ anic mi' jilel, jac'ben i mandar, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jini winic tsi' c'ajtibe: ¿Chuqui ti mandar? che'en. Jesús tsi' sube: Mach a cha'len tsʌnsa. Mach a cha'len ts'i'lel. Mach a cha'len xujch'. Mach a cha'len jop't'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Q'uele ti ñuc a tat a ña'. C'uxbin a pi'ʌlob che' bajche' ma' bajñel c'uxbin a bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jini ch'iton winic tsi' sube: Pejtel jini mandar tsac jac'ʌ c'ʌlʌl che' alobon to. ¿Chuqui to yom mic cha'len? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús tsi' sube: Mi a wom ts'ʌcʌl bʌ i yutslel a pusic'al, cucu, choño a chubʌ'an. Aq'uen jini mach bʌ añobic i chubʌ'an. Che' jini mi caj a taj cabʌl a chubʌ'an ti panchan. La' tsajcañon, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Che' bʌ tsi' yubi jini t'an, tsa' caji ti majlel. Wen ch'ijiyem i pusic'al come an cabʌl i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesús tsi' sube xcʌnt'añob i cha'an: Isujm mic subeñetla, wen wocol mi' yochel ti' yumʌntel panchan wen chumul bʌ winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Che' ja'el mic subeñetla, wocol mi' ñumel camello ti' yarcayojlel acuxan. Ñumen wocol mi' yochel ti' yumʌntel Dios wen chumul bʌ winic, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Che' bʌ tsi' yubiyob xcʌnt'añob i cha'an, tsa' toj sajtiyob i pusic'al. Tsi' yʌlʌyob: ¿Majqui mi mejlel i coltʌntel che' jini? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús tsi' q'ueleyob. Tsi' subeyob: Mach mejlicob winicob pero Dios mi mejlel i mel ti pejtelel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro tsi' jac'ʌ: Awilan, tsaj cʌyʌ lojon pejtelel chuqui an c cha'an lojon cha'an mic tsajcañet lojon. ¿Chuqui mi caj c taj lojon? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús tsi' subeyob: Isujm mic subeñetla, ti tsiji' bʌ pañimil che' buchul i Yalobil Winic ti' yumʌntel ti' ñuclel, jatetla tsa' bʌ la' tsajcayon mi caj la' buchtʌl ti lajchʌmp'ejl buchlibʌl cha'an mi la' mel jini lajchʌnmojt i p'olbal Israel. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jujuntiquil tsa' bʌ i cʌyʌ i yotot, mi i yʌscuñob, mi i yijts'iñob, mi i tat, mi i ña', mi i yalobilob, mi i lumal, cha'an tij c'aba' mi caj i taj yambʌ jo'c'al i ñumel bajche' jini tsa' bʌ i cʌyʌ. Mi caj i taj ja'el i cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Cabʌl jini ñaxaño' bʌ mi caj i cʌytʌlob ti wi'ipat. Cabʌl jini wi'ilobix bʌ mi caj i c'axelob majlel ti ñaxan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","I yumʌntel jini am bʌ ti panchan lajalʌch bajche' yumʌl tsa' bʌ majli ti sʌc'ajel cha'an mi' sʌclan x'e'telob cha'an i ts'usubil. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tsi' mele trato cha'an mi' tojtʌlob x'e'telob ti jujump'ejl denario ti jujump'ejl q'uin. Jini yumʌl tsi' chocoyob majlel ti' ts'usubil. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Che' ti uch'ijib q'uin tsa' cha' majli jini yumʌl. Tsi' q'uele yambʌ winicob to'o wa'alob jach ba'an choñoñibʌl tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tsi' subeyob: “Cucula ja'el tic ts'usubil. Mic tojetla ti uts'at”, che'en. Tsa' majliyob ti' ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Che' ja'el, tsa' cha' majli ti xinq'uiñil yic'ot ti och'ajel q'uin. Lajal tsi' mele. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Che' yomix bʌjlel q'uin tsi' taja yambʌ to'o wa'alo' bʌ. Tsi' subeyob: “¿Chucoch to'o wa'aletla ilayi c'ʌlʌl mi' ñumel q'uin?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tsi' jac'beyob: “Come ma'anic majqui tsi' pʌyʌyon lojon ti e'tel”, che'ob. Jini yumʌl tsi' subeyob: “Cucula ja'el tic ts'usubil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Che' iq'uix cajel, i yum ts'usubil tsi' sube xq'uel e'tel i cha'an: “Pʌyʌ tilel x'e'telob. Aq'ueñob i tojol. Ñaxan ma' toj jini wi'ilix bʌ tsa' juliyob. Ti wi'il ma' toj jini ñaxan bʌ tsa' juliyob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jini winicob tsa' bʌ tiliyob ti e'tel che' bʌ wolix ti bʌjlel q'uin tsa' aq'uentiyob jujump'ejl denario i tojol ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Che' bʌ tsa' tiliyob jini tsa' bʌ ñaxan cajiyob ti e'tel, tsi' lon ña'tayob ñumen mi caj i ch'ʌmob. Tsa' aq'uentiyob jujump'ejl denario i tojol ti jujuntiquil ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Che' bʌ tsi' ch'ʌmʌyob i tojol, tsa' cajiyob ti wulwul t'an ti' contra i yum ts'usubil. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tsi' yʌlʌyob: “Jini wi'ilobix bʌ tsi' cha'leyob e'tel jump'ejl jach ora. Joñon lojon, tsa cubi lojon cabʌl ticwal c'ʌlʌl tsa' ñumi q'uin. Wola' ña'tan lajalon lojon quic'otob”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jini yumʌl tsi' sube juntiquil: “Ma'anic chuqui tsac cha'le ti a contra. ¿Mach ba anic tsa' cha'le trato cha'an jump'ejl denario a tojol? ");
INSERT INTO ctuBl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ch'ʌmʌ a tojol. Cucux. Com c toj jini wi'ilobix bʌ lajal bajche' mic tojetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mach ba anic mi mejlel c cha'len chuqui jach com yic'ot c chubʌ'an? ¿Am ba i ts'i'lel la' wut cha'an chubʌ'añʌl come p'ewon?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Che' jini, jini wi'ilobix bʌ mi caj i c'axelob majlel ti ñaxan. Jini ñaxaño' bʌ mi caj i cʌytʌlob ti wi'ipat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Che' bʌ woli ti letsel majlel ti Jerusalén, Jesús tsi' pʌyʌ jini lajchʌntiquil xcʌnt'añob ti' bajñel. Ya' ti bij tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ña'tanla, woli lac letsel majlel ti Jerusalén. I Yalobil Winic mi caj i yʌjq'uel ti' c'ʌb ñuc bʌ motomajob yic'ot sts'ijbayajob. Mi caj i yʌc'ob ti chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mi caj i yʌc'ob ti' c'ʌb gentilob cha'an mi' wajleñob. Mi caj i jats'ob ti asiyal. Mi caj i ch'ijob ti cruz. Mi caj i cha' ch'ojyel ti' yuxp'ejlel q'uin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tsa' tili i yijñam Zebedeo yic'ot i yalobilob ba'an Jesús. Tsi' ñocchoco i bʌ ti' tojel. An chuqui tsi' c'ajtibe. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús tsi' sube: ¿Chuqui a wom? che'en. Jini x'ixic tsi' sube: Ac'ʌ a t'an cha'an mi' buchtʌlob jini cha'tiquil calobilob juntiquil ti a ñoj, juntiquil ti a ts'ej, ti a yumʌntel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús tsi' sube: Mach la' wujilic chuqui woli la' c'ajtin. ¿Mejl ba mi la' ñusan jini jach bʌ wocol mu' bʌ c ñusan? che'en. Tsi' jac'beyob. Mu' cu mejlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús tsi' subeyob: Isujm mi caj la' ñusan jini jach bʌ wocol mu' bʌ c ñusan. Pero mach c wentajic cha'an mic sub majqui mi' caj ti buchtʌl tic ñoj yic'ot tic ts'ej. Ya'i mi caj i buchchocontel jini yajcʌbilo' bʌ i cha'an c Tat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Che' bʌ tsi' yubiyob jini lujuntiquil, tsa' caji i mich'leñob jini cha'tiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús tsi' pʌyʌyob tilel. Tsi' yʌlʌ: La' wujil c'ax ñuc mi' pʌsob i bʌ i yumob gentilob ti' tojlelob i pi'ʌlob. Tsʌts mi' yʌc'ob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mach che'ic yom mi' la' cha'len jatetla. Majqui jach yom i taj i ñuclel ti la' tojlel la' i coltañetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Majqui jach yom i yajñel ti c'ax ñuc ti la' tojlel la' i coltañetla che' bajche' la' winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Che'ʌch mi' mel i Yalobil Winic. Come ma'anic tsa' tili cha'an mi' coltʌntel. Tsa' tili cha'an mi' coltan winicob x'ixicob, cha'an mi' yʌc' i bʌ ti chʌmel cha'an i tojol i mul cabʌlob. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Che' bʌ tsa' loq'uiyob majlel ti Jericó, bajc'ʌl winicob x'ixicob tsi' tsajcayob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ya' añob cha'tiquil xpots' buchulob ti' ti' bij. Che' bʌ tsi' yubiyob woli ti ñumel Jesús, c'am tsi' cha'leyob t'an. Tsi' yʌlʌyob: C Yum, i Yalobilet bʌ David, p'untañon lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jini winicob x'ixicob tsi' tiq'uiyob cha'an mi' cʌyob i t'an. Tsa' utsi cajiyob ti c'am bʌ t'an jini xpots'ob. Tsi' yʌlʌyob: C Yum, i Yalobilet bʌ David, p'untañon lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús tsi' cʌyʌ i xʌmbal. Tsi' pʌyʌyob tilel. Tsi' yʌlʌ: ¿Chuqui la' wom mic tumbeñetla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tsi' subeyob: C Yum, com lojon mi' c'otel c wut, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Cha'an ti' p'untaya Jesús tsi' tʌlbeyob i wut xpots'. Tsa' bʌc' c'otiyob i wut. Tsi' tsajcayob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Che' lʌc'ʌlix añob ti Jerusalén, tsa' c'otiyob ya' ti Betfagé ti Olivo wits. Jesús tsi' choco majlel cha'tiquil xcʌnt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tsi' subeyob: Cucula ti tejclum ya' ti' tojel la' wut. Ya' cʌchʌl mi caj la' bʌc' taj juncojt ña' burro. Ya'an yic'ot i yal. Jitila tilel ba' añon. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi an majqui mi' pejcañetla yom mi la' suben: “Yom i c'ʌn lac Yum”, che'etla. Mi caj i bʌc' choc tilel yic'ot i yal, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Che'ʌch tsa' ujti cha'an mi' ts'ʌctiyel i t'an x'alt'an tsa' bʌ i yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Subenla x'ixicob ya' ti Sion, awilan, la' Yum woli' tilel ba' añetla. Pec' mi' mel i bʌ. C'ʌchʌl ti burro woli' tilel, c'ʌchʌl ti' yal burro yujil bʌ cuchijel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jini xcʌnt'añob tsa' majliyob. Tsi' cha'leyob che' bajche' tsi' subeyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tsi' pʌyʌyob tilel jini burro yic'ot i yal. Jini xcʌnt'añob tsi' tasibeyob i pat burro yic'ot i yal ti' pislelob. Jesús tsi' buchta pisil. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Cabʌl winicob x'ixicob tsi' tasiyob majlel jini bij ti' pislel. Yaño' bʌ tsi' tsepeyob jubel i c'ʌb te'. Tsa' caji i lijlij ac'ob majlel ya' ti bij. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jini winicob x'ixicob woli bʌ i majlelob ti' tojel Jesús yic'ot jini woli bʌ i tilelob ti' pat c'am tsi' yʌlʌyob: ¡Cotañet i Yalobilet bʌ David! ¡La' sujbic a ñuclel, jatet mu' bʌ a tilel ti' c'aba' lac Yum! ¡Cotañet añet bʌ ti chan! che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Che' bʌ tsa' ochi ti Jerusalén Jesús, ti pejtelel winicob x'ixicob tsa' cajiyob ti t'an. Tsi' yʌlʌyob: ¿Majqui jini? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jini winicob x'ixicob tsi' yʌlʌyob: Jiñʌch Jesús jini x'alt'an ch'oyol bʌ ti Nazaret ti Galilea, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús tsa' ochi ti Templo. Tsa' caji i choc loq'uel jini woliyo' bʌ ti choñoñel yic'ot mʌñoñel ti Templo. Jesús tsi' ch'a' chocobeyob i mesa tac xq'uex taq'uiñob yic'ot i buchlib tac jini woli bʌ i choñob x'ujcuts. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesús tsi' subeyob: Ts'ijbubil ti jun: “Mi' caj ti ajlel cotot ti' yotlel oración”. Pero jatetla wolix la' sutq'uin ti' ch'eñal xujch'ob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tsa' tiliyob xpots'ob yic'ot jini mach bʌ weñobic i yoc ba'an Jesús ti' mal Templo. Tsi' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tsa' cajiyob ti mich'ajel ñuc bʌ motomajob yic'ot sts'ijbayajob che' bʌ tsi' q'ueleyob ñuc bʌ i ye'tel Jesús, che' bʌ tsi' yubibeyob i t'an jini alobob woliyo' bʌ ti c'am bʌ t'an ti Templo: Cotañet i Yalobilet bʌ David, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tsi' subeyob Jesús: ¿Mach ba wolic a wubin chuqui woli' yʌlob? che'ob. Jesús tsi' jac'beyob: Woli cu cubin. ¿Mach ba tsa'ic la' q'uele ti jun: “Ya' ti' yej alobob yic'ot ti' yej jini woliyo' bʌ ti chu', tsi' wen tsictesa i ñuclel Dios”? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesús tsi' cʌyʌyob. Tsa' loq'ui majlel ti tejclum. Tsa' c'oti ya' ti Betania. Ya' tsa' jijli. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ti sʌc'ajel che' woli' cha' majlel ti tejclum, Jesús tsi' yubi wi'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Che' bʌ tsi' q'uele te' i c'aba' higuera ya' lʌc'ʌl ti' ti' bij tsa' majli ba'an. Ma'anic chuqui tsi' taja. I yopol jach ya'an. Jesús tsi' sube: Mach ma' chʌn ac' a wut ti pejtelel ora, che'en. Ora jach tsa' caji ti tiquin jini te'. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Che' bʌ tsi' q'ueleyob jini xcʌnt'añob, tsa' toj sajtiyob i pusic'al. Tsi' yʌlʌyob: ¿Bajche' tsa' bʌc' tiqui jini higuera te'? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús tsi' subeyob: Isujm mic subeñetla, mi mux la' ñop, mi ma'anic tile bixel bʌ la' pusic'al, mach che'ic jach mi caj la' cha'len che' bajche' tsac melbe jini higuera te'. Mi mux la' ñop mi caj la' suben jini wits cha'an mi' ch'ujyel letsel cha'an mi' chojquel ochel ti colem ñajb. Che'ʌch mi' caj ti ujtel. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mi mux la' ñop mi caj la' wʌq'uentel pejtelel chuqui tac mi la' c'ajtin ti oración, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Che' bʌ tsa' ochi Jesús ti Templo, jini ñuc bʌ motomajob yic'ot jini xñoxob año' bʌ i ye'tel tsa' tiliyob ba' woli' cha'len cʌntesa. Tsi' c'ajtibeyob: ¿Baqui tsa' taja a we'tel cha'an ma' cha'len jini? ¿Majqui tsi' yʌq'ueyet a we'tel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús tsi' subeyob: An chuqui mij c'ajtibeñetla ja'el. Mi muc'ʌch la' jac'beñon, joñon ja'el mi caj c subeñetla baqui tsac taja que'tel cha'an jini mu' bʌ c mel. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Baqui ch'oyol i ye'tel Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'? ¿Ch'oyol ba ti panchan o ch'oyol ba ti winicob? che'en Jesús. Tsa' caji i bajñel pejcañob i bʌ. Tsi' yʌlʌyob: Mi tsa' lac sube: “Ch'oyol ti panchan”, mi cho'onla, muq'uix i cha' c'ajtibeñonla: “¿Chucoch che' jini, ma'anic tsa' la' ñopbe i t'an?” Che' mi caj i yʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mi tsa' lac sube: “Ch'oyol ti winic”, mi cho'onla, woli lac bʌc'ñan winicob x'ixicob, come ti pejtelelob mi' yʌlob x'alt'añʌch jini Juan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jini cha'an tsi' yʌlʌyob: Mach cujilic lojon, che'ob. Jesús tsi' subeyob ja'el: Che' ja'el, joñon ma'anic mic subeñetla baqui tsac taja que'tel cha'an jini mu' bʌ c mel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","¿Bajche' mi la' wʌl? An juntiquil winic am bʌ cha'tiquil i yalobil. Tsa' tili ba'an ñaxan bʌ i yalobil. Tsi' sube: “Calobil, cucu wʌle ti e'tel tic ts'usubil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","I yalobil tsi' sube: “Ma'anic mi caj c majlel”, che'en. Wi'il tsi' q'uexta i pusic'al. Tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jini winic tsa' tili ba'an yambʌ i yalobil. Lajal tsi' pejca. Jini i yalobil tsi' yʌlʌ: “Muc'ʌch c majlel, c tat”, che'en. Pero ma'anic tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Majqui tsi' mero mele bajche' yom i tat? ¿Jim ba ñaxan bʌ o jim ba wi'ilix bʌ? che'en Jesús. Tsi' subeyob: “Jini ñaxan bʌ”, che'ob. Jesús tsi' subeyob ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel: Isujm mic subeñetla, jini xch'ʌm tojoñelob yic'ot xmojajob mi caj i yochelob ti' yumʌntel Dios che' mach ochemeticla. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Come Juan tsa' tili ba' añetla. Tsa' ajni ti toj bʌ bij. Ma'anic tsa' la' ñopbe i t'an. Pero jini xch'ʌm tojoñelob yic'ot jini xmojajob tsi' ñopbeyob i t'an. Jatetla anquese q'uelelix la' cha'an bajche' tsi' cʌyʌyob i mul, ma'anic tsa' la' cʌyʌ la' mul cha'an mi la' ñopben i tan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ubinla yambʌ t'an ti lajiya: Juntiquil i yum otot tsi' pʌc'ʌ ts'usubil. Tsi' joy mʌcʌ ti corral. Tsi' piqui jini lum ba' mi' t'uchtʌben loq'uel i ya'lel ts'usub. Tsi' mele chan bʌ q'ueloñib. Tsi' yʌq'ueyob ti' wenta xcʌnta ts'usubilob. Tsa' majli ti yambʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Che' lʌc'ʌlix i yorajlel mi' cajel ti wut, tsi' choco majlel yambʌ x'e'telob i cha'an. Tsa' majliyob ba'an xcʌnta ts'usubilob cha'an mi' ch'ʌmbeñob tilel i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jini xcʌnta ts'usubilob tsi' chucuyob jini x'e'telob i cha'an. Tsi' lowoyob juntiquil. Tsi' tsʌnsayob yambʌ. Tsi' juluyob yambʌ ti xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","I yum ts'usubil tsi' cha' chocbeyob majlel yambʌ x'e'telob ñumen cabʌlob bajche' ti ñaxan. Jini xcʌnta ts'usubilob lajal tsi' tic'layob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ti wi'il i yum ts'usubil tsi' choco majlel i yalobil ba' añob. Tsi' yʌlʌ: “Mi caj i q'uelob calobil ti ñuc”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Che' bʌ tsi' q'ueleyob i yalobil jini yumʌl, jini xcʌnta ts'usubilob tsi' subeyob i bʌ: “Jiñʌch mu' bʌ caj i yochel ti yumʌl. Conla lac tsʌnsan. La' lac chilben pejtelel i chubʌ'an”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tsi' chucuyob. Tsi' chocoyob loq'uel ti ts'usubil. Tsi' tsʌnsayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Che' mi' tilel i yum ts'usubil, ¿chuqui mi caj i tumben xcʌnta ts'usubilob? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jini ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel tsi' subeyob Jesús: Mi caj i wersa jisan jini jontolo' bʌ winicob. Mi caj i yʌc' i ts'usubil ti' wenta yaño' bʌ xcʌnta ts'usubilob mu' bʌ caj i yʌq'ueñob i wut ti' yorajlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús tsi' subeyob: ¿Mach ba anic tsa' la' q'uele jini t'an ti' Ts'ijbujel Dios?: “Jini jach bʌ xajlel tsa' bʌ i chocoyob xmel ototob tsa'ix otsʌnti ti ñaxan bʌ i xujc otot. Jiñʌch i melbal lac Yum. Uts'atax mi laj q'uel”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jini cha'an mic subeñetla mi caj la' chilbentel i yumʌntel Dios. Mi caj i yʌq'uentelob jini winicob x'ixicob mu' bʌ i yʌc'ob wen bʌ i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jini mu' bʌ i yajlel ti' pam jini xajlel mi caj i c'ʌscujel. Jini mu' bʌ i tejñel ti jini xajlel mi caj i lu' bic'tiyel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Che' bʌ tsi' yubibeyob i lajiya tac Jesús, jini ñuc bʌ motomajob yic'ot fariseojob tsi' ña'tayob woli' tajtʌlob ti t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Che' bʌ woli' ña'tañob bajche' mi mejlel i chucob Jesús, tsi' bʌc'ñayob winicob x'ixicob come woli' yʌlob x'alt'añʌch. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús tsi' cha' pejcayob ti lajiya. Tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","I yumʌntel jini am bʌ ti panchan lajalʌch bajche' juntiquil rey tsa' bʌ i mele q'uin che' bʌ tsa' ñujpuni i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tsi' choco majlel x'e'telob i cha'an cha'an mi' pʌyob tilel jini pʌybilo' bʌ cha'an mi' melbeñob i q'uiñilel ñujpuñijel. Mach yomobic tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tsi' cha' choco majlel yambʌ x'e'telob. Tsi' yʌlʌ: Subenla jini pʌybilo' bʌ: “Awilan, tsa'ix c chajpa c we'el. Tsʌnsʌbilix jini tat wacax yic'ot jujp'em bʌ alʌc'ʌl. Laj chajpʌbilix. La'ix cu la cha'an mi la' melben i q'uiñilel ñujpuñijel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tsa' jach i tse'tayob. Tsa' majliyob, juntiquil ti' chol, yambʌ ti' choñoñel. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yaño' bʌ tsi' chucuyob x'e'telob i cha'an. Leco tsi' tic'layob. Tsi' tsʌnsayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mich' jini rey, tsi' choco majlel i soldadojob tsa' bʌ i jisayob jini stsʌnsajob. Tsi' pulbeyob i tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tsi' sube x'e'telob i cha'an: “Chajpʌbilix i q'uiñilel ñujpuñijel. Mach uts'atobic jini pʌybilo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cucula che' jini, ti pejtelel bij. Ti pejtelel mu' bʌ la' taj, pʌyʌla tilel cha'an mi' melob i q'uiñilel ñujpuñijel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Che' jini tsa' majliyob x'e'telob ti pejtelel bij. Tsi' tempayob tilel pejtelel jini tsa' bʌ i tajayob, jontolo' bʌ yic'ot uts'ato' bʌ i pusic'al. Che' jini tsa' bujt'i i yotot ti xmel q'uiñob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Che' bʌ tsa' ochi jini rey i q'uel jini xmel q'uiñob, tsi' q'uele juntiquil winic mach bʌ xojolic i cha'an wen bʌ i bujc cha'an ñujpuñijel. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsi' sube: “¿Bajche' tsa' mejli a wochel ilayi che' mach xojolic a cha'an wen bʌ a bujc cha'an ñujpuñijel?” che'en. Ma'anic chuqui tsa' mejli i yʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jini rey tsi' sube x'e'telob i cha'an: “Cʌchʌla ti' c'ʌb ti' yoc. Chocola ba'an ic'ch'ipan bʌ pañimil. Ya'i mi' cajelob ti uq'uel yic'ot quech'ecña i bʌquel i yej”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Come an cabʌl pʌybilo' bʌ, ma'anic jaytiquil yajcʌbilo' bʌ. Che' tsi yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tsa' majliyob fariseojob. Tsi' pejcayob i bʌ cha'an mi' ña'tañob bajche' mi caj i tajbeñob i mul Jesús ti' subal. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jini fariseojob tsi' chocoyob majlel xcʌnt'añob i cha'an yic'ot herodiañob ba'an Jesús. Tsi' yʌlʌyob: Maestro, cujil lojon isujmet. Wola' cʌntesañonla i bijlel Dios ti isujm. Ma'anic majch ma' bʌc'ñan. Junlajal ma' q'uel winicob mi an i ye'tel mi ma'anic i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Subeñon lojon che' jini. ¿Bajche' ma' wʌl? ¿Mu' ba i yʌl ti mandar yom mi la cʌq'uen César jini tojoñel o ma'anic? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús tsi' ña'ta jontolob i pusic'al. Tsi' yʌlʌ: ¿Chucoch mi la' wilʌbeñon c pusic'al? Cha'chajp jax la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pʌsbeñon jini taq'uin cha'an tojoñel, che'en Jesús. Tsi' ch'ʌmbeyob tilel jump'ejl denario. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús tsi' subeyob: ¿Majqui i cha'an ili i yejtal yic'ot i ts'ijbal ti' pam? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tsi' jac'beyob: I cha'an César, che'ob. Jesús tsi' subeyob: Jini cha'an aq'uenla César i cha'an bʌ César. Aq'uenla Dios i cha'an bʌ Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsa' toj sajtiyob i pusic'al che' bʌ tsi' yubibeyob i t'an. Tsi' cʌyʌyob Jesús. Tsa' majliyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti jim bʌ q'uin tsa' tiliyob saduceojob ba'an Jesús. Jiñobʌch mu' bʌ i yʌlob ma'anic mi' tejchelob ch'ojyel chʌmeño' bʌ. An chuqui tsi' c'ajtibeyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tsi' yʌlʌyob: Maestro, Moisés tsi' yʌlʌ: “Mi tsa' chʌmi winic che' maxto anic i yalobil, wersa yom jini ijts'iñʌl bʌ mi' pʌyben i yijñam i yʌscun cha'an mi' techben i p'olbal i yʌscun”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","An quic'ot lojon wuctiquil winicob i yerañob i bʌ. Jini ñaxan bʌ tsi' cha'le ñujpuñijel. Tsa' chʌmi. Ma'anic i yalobil. Tsa' cʌle i yijñam jini ascuñʌl bʌ. Tsi' pʌyʌ jini ijts'iñʌl bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Che' ja'el i cha'ticlel, yic'ot i yuxticlel, c'ʌlʌl ti' wucticlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ti wi'il tsa' chʌmi jini x'ixic ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ti' yorajlel che' mi' tejchelob ch'ojyel, ¿baqui bʌ winic i ñoxi'al jini x'ixic? Come ti pejtelel jini wuctiquil tsi' pʌyʌyob cha'an i yijñam, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús tsi' subeyob: Cabʌl la' sajtemal come mach cʌñʌlic la' cha'an i Ts'ijbujel Dios mi i p'ʌtʌlel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Come ti' yorajlel che' mi' tejchelob ch'ojyel, ma'anic mi' pʌyob i pi'ʌl, ma'anic mi' sijintelob. Come lajalob bajche' i yángelob Dios ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Mach ba anic tsa' la' q'uele jini tsa' bʌ i subeyetla Dios cha'an i sujmlel jini chʌmeño' bʌ mu' bʌ i tejchelob ch'ojiyel? ");
INSERT INTO ctuBl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Tsi' yʌlʌ: “Joñon I Dioson Abraham, I Dioson Isaac, I Dioson Jacob”, che'en. mach i Diosic chʌmeño' bʌ, pero i Diosʌch cuxulo' bʌ, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Che' bʌ tsi' yubiyob winicob x'ixicob, tsa' toj sajtiyob i pusic'al cha'an i cʌntesʌbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Che' bʌ tsi' yubiyob bajche' Jesús tsi' ñʌch'tesayob ti t'an saduceojob, jini fariseojob tsi' tempayob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Juntiquil xcʌntesa mandar tsa' caji i pejcan Jesús. Yom i yilʌben i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tsi' c'ajtibe: Maestro, ¿chuqui ti mandar c'ax ñuc ti' mandar Dios? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús tsi' sube: “C'uxbin a Yum Dios ti pejtelel a pusic'al, ti pejtelel a ch'ujlel, ti pejtelel a ña'tʌbal”. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jiñʌch jini ñaxan bʌ mandar, jini c'ax ñuc bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lajal jini wi'ilix bʌ mandar: “C'uxbin a pi'ʌlob che' bajche ma' c'uxbin a bʌ ti a bajñelil”. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ti jini cha'p'ejl ñuc bʌ mandar tsa' laj loq'ui pejtelel ts'ijbubil bʌ mandar yic'ot i subal x'alt'añob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Che' tempʌbilobix fariseojob, Jesús tsi' c'ajtibeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Majqui jini Cristo mi la' wʌl? ¿Majqui i Tat? che'en. Tsi' subeyob: I yalobilʌch David jini Cristo, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús tsi' subeyob: ¿Bajche' isujm tsi' pejca Cristo ti' Yum jini David che' cʌntesʌbil cha'an Espíritu? ");
INSERT INTO ctuBl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","David tsi' yʌlʌ: “Jini lac Yum tsi' sube c Yum: Buchi' tic ñoj jinto mi cʌq'ueñet a t'uchtan a contrajob”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Mi tsi' pejca Cristo ti' Yum jini David, ¿bajche' isujm mi i yalobilʌch David jini Cristo? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma'anic majqui tsa' mejli i wis jac'ben i t'an. Che' ja'el ma'anix majqui tsi' chʌn ñopo i c'ajtiben yan tac bʌ cha'an bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús tsa' caji i pejcan tempʌbilo' bʌ winicob x'ixicob yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Tsi' yʌlʌ: Jini sts'ijbayajob yic'ot fariseojob tsa' ochiyob ti cʌntesa mandar ti' q'uexol Moisés. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jini cha'an jac'benla i t'an. Melela chuqui jach mi' subeñetla. Pero mach mi la' tsajcan i melbalob. Come mi' lon cha'leñob subt'an. Ma'anic mi' melob chuqui mi' yʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mi' p'ʌtob wen al bʌ cuchʌl wocol bʌ ti q'uechol. Mi' c'ʌcchocobeñob ti' quejlab yaño' bʌ winicob. Pero i bajñelob ma'anic mi' wis tʌlob jini cuchʌl mi ti junts'ijtic i yal i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ti pejtelel i melbal tac mi' cha'leñob cha'an mi' q'uejlelob ti ñuc ti winicob. Mi' cʌchob ti' jol yic'ot ti' c'ʌb mero ñuc bʌ i yajñib ts'ijbubil bʌ i t'an Dios. Mi' melob wen tam bʌ i ch'ʌjlib rebozo mu' bʌ i xojob ti oración. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mi' mulañob ñaxan bʌ buchlibʌl ti q'uiñijel, yic'ot jini ñaxan bʌ buchlibʌl ti sinagoga. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mi' mulañob i yʌq'uentelob cortesía ba'an choñoñibʌl. Mi' mulañob che' mi' pejcʌntelob ti maestro cha'an winicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jatetla, mach yomic mi la' pejcʌntel ti maestro come an juntiquil jach la' maestro, jiñʌch Cristo. Ti pejteletla la' wermano la' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mach mi la' tatin yambʌ winic ti pañimil, come juntiquil jach la' Tat, jiñʌch am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Che' ja'el mach yomic mi la' pejcʌntel ti yumʌl come juntiquil jach la' yum, jiñʌch Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jini ñumen ñuc bʌ winic ti la' tojlel, la' i coltañetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Majqui jach chan mi' mel i bʌ mi caj i peq'uesʌntel. Majqui jach pec' mi' mel i bʌ, mi caj i chañ'esʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Mi caj la' taj wocol sts'ijbayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Come woli la' mʌctʌbeñob winicob x'ixicob i ti' ba' mi' yochelob ti' yumʌntel jini am bʌ ti panchan. Jatetla ma'anic mi la' wochel. Che' ja'el, ma'anic mi la' wʌc'ob ti ochel jini yomo' bʌ ochel. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Mi caj la' taj wocol sts'ijbayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Mi la' chilbeñob i yototob meba' x'ixicob. Mi la' mel tam bʌ oración cha'an mi' la' lon q'uejlel ti uts'at. Jini cha'an ñumen cabʌl mi caj la' taj tojmulil. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Mi caj la' taj wocol sts'ijbayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Mi la' ñumel ti xʌmbal ti lum yic'ot ti ñajb cha'an mi' sutq'uin i bʌ juntiquil winic. Che' bʌ tsa'ix i sutq'ui i bʌ, mi la' wutsi xic'ben ti jontolil jinto ñumen an i jontolil bajche' la' jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Mi caj la' taj wocol xpots' bʌ xpʌs bijetla! Mi la' lon al che' an majch mi' taj ti t'an jini Templo cha'an mi' wa'chocon i t'an, mach wersajic mi' mel chuqui tsi' yʌlʌ. Mi tsi' taja ti t'an jini oro am bʌ ti Templo, mi la' wʌl wersa yom mi' mel chuqui tsi' yʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tontojetla! ¡Xpots'etla! ¿Baqui bʌ ñumen ñuc ma' wʌl? ¿Jim ba jini oro? ¿Mach ba jinic Templo ba' mi' taj i c'ʌjñibal jini oro ti' ye'tel Dios? ");
INSERT INTO ctuBl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Che' ja'el, mi la' wʌl che' an majch mi' taj ti t'an jini pulʌntib che' mi' wa'chocon i t'an, mach wersajic mi' mel chuqui tsi' yʌlʌ. Pero che' mi' taj ti t'an i majtan Dios am bʌ ti pulʌntib, mi la' wʌl wersa yom mi' mel chuqui tsi' yʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tontojetla! ¡Xpots'etla! ¿Baqui bʌ ñumen ñuc? ¿Jim ba i majtan Dios o jim ba pulʌntib ba' mi' taj i c'ʌjñibal i majtan Dios? ");
INSERT INTO ctuBl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Majqui jach mi' taj ti t'an jini pulʌntib cha'an mi' wa'chocon i t'an, mi' taj ti t'an jini pulʌntib yic'ot pejtelel chuqui tac an ti' pam. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Majqui jach mi' taj ti t'an jini Templo che' mi' wa'chocon i t'an, mi' taj ti t'an Templo yic'ot jini am bʌ ti' mal Templo. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Majqui jach mi' taj ti t'an jini panchan che' mi' wa'chocon i t'an mi' taj ti t'an i buchlib Dios yic'ot jini ya' bʌ buchul. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Mi caj la' taj wocol sts'ijbayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Come mi la' loc'san i diezmojlel jini pimel i c'aba menta yic'ot yambʌ i c'aba' enelto yic'ot yambʌ i c'aba' comino. Pero mi la' ñusan ñumen ñuc tac bʌ i mandar Dios, jiñʌch toj bʌ meloñel yic'ot p'untaya yic'ot chuqui yom ñopol. Yom mi la' jac' ili mandar. Mach yomic mi la' cʌy la' wʌq'uen i diezmojlel la' chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Xpots' bʌ xpʌs bijetla, mi la' chic loq'uel jini us pero mi la' mʌsan camello! ");
INSERT INTO ctuBl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Mi caj la' taj wocol, sts'ijbayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Mi' la' wen pocben i pat jini vaso yic'ot latu. Ya' ti' mal but'ul ti xujch' yic'ot cabʌl jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Xpots' bʌ fariseojet, ñaxan poco i mal jini vaso yic'ot latu cha'an sʌc mi' yajñel i pat ja'el! ");
INSERT INTO ctuBl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Mi caj la' taj wocol sts'ijbayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Lajaletla bajche' i yotlel tac ch'ujlelʌl bombil bʌ ti tan. Wen i t'ojol jax yilal ti' pat pero ti' mal but'ul ti' bʌquel chʌmeño' bʌ yic'ot pejtelel i bibi'lel. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Che' ja'el jatetla, toj mi la' pʌs la' bʌ ti' wut winicob, pero ti la' mal but'uletla ti cabʌl lot yic'ot jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Mi caj la' taj wocol, sts'ibayajob yic'ot fariseojob! ¡Cha'p'ejl jax la' pusic'al! Come mi la' melbeñob i yotlel ch'ujlelʌl jini x'alt'añob. Mi la' ch'ʌl i yejtal tac ba' mucul jini tojo' bʌ i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mi la' lon ña'tan mach lajaleticla bajche' la' ñojte'el tsa' bʌ i bec'beyob i ch'ich'el x'altañob. Mi la' wʌl: “Cuxulonicla ti jim bʌ ora, mach che'ic tsa' lac mele”, lon che'etla. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Woli la' bajñel contrajin la' bʌ ti la' t'an che' mi la' sub la' bʌ ti' yalobilob jini tsa' bʌ i tsʌnsayob x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wolix la' chʌn mel che' bajche' tsa' caji' melob la' ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Lucumetla, i yalobiletla xc'ʌñʌñej! ¿Bajche' mi mejlel la' puts'tan tojmulil ti c'ajc? ");
INSERT INTO ctuBl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jini cha'an la' wilan, mi caj c chocbeñetla tilel x'alt'añob yic'ot winicob am bʌ cabʌl i ña'tʌbal, yic'ot sts'ijbayajob. Ojlil mi caj la' tsʌnsañob. Mi caj la' ch'ijob ti cruz. Ojlil mi caj la' jats'ob ti asiyal ti la' sinagoga. Mi caj la' tic'lañob ti cabʌl tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","36","Jini cha'an mi caj la' tojbeñob i mul jini tsa' bʌ i tsʌnsayob jini x'alt'añob c'ʌlʌl che' bʌ tsa' tsʌnsʌnti Abel, jini toj bʌ i pusic'al, c'ʌlʌl tsa' tsʌnsʌnti Zacarías (i yalobil Berequías). Zacarías tsa' tsʌnsʌnti ti' tojel pulʌntib ya' ti' t'ejl Templo. Isujm mic subeñetla, pejtel i mul mi caj i yotsʌbentelob ti' wenta jini winicob x'ixicob año' bʌ ti pañimil wʌle. Mi caj i tojob pejtel ili mulil. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Jerusalén, Jerusalén, jatet mu' bʌ a tsʌnsan x'alt'añob! ¡Ma' jul ti xajlel jini chocbilo' bʌ tilel ba' añetla! ¡Anix jayyajl com c tempan la' walobilob che' bajche' mi' luts' i yal jini ña' mut! ¡Pero mach la' womic! ");
INSERT INTO ctuBl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","La' wilan, jochol mi caj i cʌytʌl la' wotot. ");
INSERT INTO ctuBl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Come mic subeñetla, ma'anic mi caj la' cha' q'uelon jinto mi la' wʌl: “La' sujbic i ñuclel jini woli bʌ i tilel ti' c'aba' lac Yum”, che'etla. Che' tsi' subeyob sts'ijbayajob yic'ot fariseojob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús tsa' loq'ui ti Templo. Tsa' caji ti majlel. Tsa' tiliyob xcʌnt'añob i cha'an, cha'an mi' pʌsbeñob jini wa'chocobil tac cha'an Templo. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús tsi' subeyob: ¿Woli ba la' q'uel ti pejtelel jini? Isujm mic subeñetla, ma'anic mi caj i cʌytʌl mi jump'ejlic xajlel ti' pam yambʌ mach bʌ anic mi caj i chojquel jubel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Che' buchul Jesús ti' pam Olivo wits, tsa' tiliyob xcʌnt'añob i pejcañob ti' bajñelil. Tsi' yʌlʌyob: Subeñon lojon, ¿baqui ora mi' caj ti ujtel pejtelel jini? ¿Chuqui mi caj c pʌsbentel lojon che' lʌc'ʌl i yorajlel ma' cha' tilel yic'ot che' ti' jilibal pañimil? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús tsi' subeyob: Chʌcʌ q'uele la' bʌ ame anic majqui mi' soquetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Come talob cabʌl tij c'aba'. Mi caj i lon cuyob i bʌ ti Cristo. Mi caj i socob cabʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi caj la' wubin an cabʌl guerra yic'ot cabʌl t'an cha'an tal guerra. Mach mi la' cha'len bʌq'uen. Come wersa mi' tilel pejtelel jini, pero maxto tilemic i jilibal. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Come jini año' bʌ ti jumpejt lum mi caj i techob guerra ti' contra año' bʌ ti yambʌ lum. Jini año' bʌ ti' wenta juntiquil yumʌl mi caj i techob guerra ti' contra jini año' bʌ ti' wenta yambʌ yumʌl. Tal wocol yic'ot cabʌl wi'ñal yic'ot i yujquel lum ti cabʌl lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ti pejtelel iliyi i cajibal jach wocol. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mi cajelob i yʌq'uetla ti tic'lʌntel. Mi cajelob i tsʌnsañetla. Mi caj la' ts'a'lentel ti pejtelel lum cha'an tij c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti jim bʌ ora mi caj i tejchel tile bixelo' bʌ i pusic'al cabʌlob. Mi caj i yʌc'ob i pi'ʌlob ti' c'ʌb i contra. Mi caj i ts'a'leñob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mi caj i tejchelob cabʌl lot bʌ x'alt'añob mu' bʌ caj i socob cabʌl winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cabʌl mi' caj ti p'ojlel jontolil. Jini cha'an mi' caj ti lajmel i c'uxbiya cabʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jini mu' bʌ i cuch i wocol c'ʌlʌl ti' jilibal mi caj i coltʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jini wen t'an cha'an i yumʌntel Dios mi caj i sujbel ti pejtelel pañimil cha'an mi' yubintel ti pejtelel pañimil. Ti jim bʌ ora mi caj i tilel i jilibal. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mi caj la' q'uel wa'alix ti ch'ujul bʌ ajñibʌl jini c'ax bibi' jax bʌ mu' bʌ i jisan cabʌl chuqui tac an, jini tsa' bʌ ajli cha'an jini x'alt'an Daniel. (Jini mu' bʌ i q'uel jini jun, la' i ch'ʌmben isujm.) ");
INSERT INTO ctuBl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Che' mi la' q'uel jini, la' puts'icob majlel ti wits jini año' bʌ ti Judea. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jini am bʌ ti' jol otot mach jubic ochel cha'an mi' loc'san i chubʌ'an ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jini am bʌ ti cholel mach chʌn sujtic cha'an mi' lot i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti jim bʌ ora obolob jax i bʌ jini cʌntʌbilo' bʌ i cha'an alʌl yic'ot jini woli bʌ i tsu'sañob alʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Cha'lenla oración cha'an mach ti' yorajlelic tsʌñal mi la' puts'el mi ti jini q'uin che' mi laj c'aj la co. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Come ti jim bʌ ora mi caj i tilel cabʌl wocol, ñumen bajche' tsa' ñumi c'ʌlʌl ti' cajibal pañimil c'ʌlʌl wʌle, c'ʌlʌl ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Machic tsi' wʌn ña'ta i com'esan i yorajlel wocol, ma'anic majqui mi' coltʌntel mi juntiquilic. Pero cha'an i coltʌntel jini yajcʌbilo' bʌ mi caj i com'esʌntel i yorajlel wocol. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mi an majqui mi' subeñetla: “Awilan, wʌ'an Cristo”, che'en, o mi an majqui mi' subeñetla: “Ya'an Cristo ya'i”, mi che'en, mach mi la' ñopben i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mi caj i tejchelob lot bʌ x'alt'añob yic'ot xlotob mu' bʌ i cuyob i bʌ ti Cristo. Mi caj i pʌsob ñuc bʌ i yejtal i p'ʌtʌlel, yic'ot bʌbʌq'uen tac bʌ cha'an mi' socob jini yajcʌbilo' bʌ mi tsa' mejli. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Awilan, tsa'ix c wʌn subeyetla. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jini cha'an mi tsa' caji i subeñetla: “Awilan, ya'an Cristo ti colem bʌ i tiquiñal lum”, mi che'ob, mach mi la' majlel. Mi tsi' yʌlʌyob: “Awilan, ya'an Cristo ti' mal otot”, mi che'ob, mach mi la' ñopbeñob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Come che' lajal bajche' mi' tsictiyel i c'ʌc'al chajc ti' pasibal q'uin c'ʌlʌl ti' bʌjlibal q'uin, che' ja'el mi' caj ti tsictiyel i Yalobil Winic che' mi' tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Baqui jach an chʌmen bʌ, ya' mi caj i tempañob i bʌ xta'jol. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ti jim bʌ ora che' mi' yujtel jini wocol, mi caj i yiq'uesʌntel jini q'uin. Ma'anic mi caj i yʌc' i c'ʌc'al uw. Mi' caj ti yajlel jubel ec' ti panchan. Jini p'ʌtʌl tac bʌ ti panchan mi caj i wersa ñijcʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ti jim bʌ ora i Yalobil Winic mi caj i pʌs i yejtal i p'ʌtʌlel ti panchan. Mi' cajelob ti cabʌl uq'uel pejtelel winicob x'ixicob ti pañimil. Mi caj i q'uelob i Yalobil Winic che' mi' tilel ti tocal ti panchan ti' p'ʌtʌlel yic'ot ti' ñuclel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mi caj i choc tilel i yángelob yic'ot c'am bʌ i t'an trompeta. Mi caj i tempañob tilel ti chʌnwejlel pañimil jini yajcʌbilo' bʌ i cha'an ti junwejl panchan c'ʌlʌl ti yambʌ junwejl. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ñopola jini lajiya cha'an higuera te'. Che' c'unix i c'ʌb che' woli' pasel i yopol, la' wujil lʌc'ʌlix i yorajlel ticwal. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Che' ja'el, che' mi la' q'uel pejtelel jini, ña'tanla lʌc'ʌlix i tilel i Yalobil Winic. Mero wolix i julel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Isujm mic subeñetla, mi' caj ti ujtel ti pejtelel che' cuxulob to jini winicob x'ixicob año' bʌ wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mi' caj ti jilel pañimil yic'ot panchan pero mach jilic c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ma'anic majch yujil baqui bʌ q'uin baqui bʌ ora mi caj i yujtel jini, mi ángelob ti panchan, mi i Yalobil Dios. Jini jach c Tat yujil. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Che' bajche' ti' yorajlel Noé, che' lajal mi caj i yujtel che' mi' tilel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Che' maxto anic tsa' tili but'ja', tsi' cha'leyob we'el, tsi' cha'leyob uch'el, tsi' cha'leyob ñujpuñijel, tsi' sijiyob i yalobil, jinto ti jini q'uin che' bʌ tsa' ochi Noé ti barco. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ma'anic tsi' ña'tayob mi an chuqui mi' caj ti ujtel jinto tsa' tili but'ja'. Tsi' lu' jisayob. Che' ja'el mi' caj ti ujtel che' mi' tilel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Mi caj i yajñelob cha'tiquil winic ti cholel. Mi' pʌjyel majlel juntiquil. Yambʌ mi' cʌytʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Mi' cajelob ti juch'bal cha'tiquil x'ixic. Juntiquil mi' pʌjyel majlel. Yambʌ mi' cʌytʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Jini cha'an chʌcʌ q'uele la' bʌ, come mach ña'tʌbilic la' cha'an baqui bʌ q'uin mi' tilel la' Yum. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ña'tanla jini, tsa'ic i ña'ta i yum otot baqui ora mi' tilel xujch', tsi' chʌcʌ q'uele i yotot cha'an ma'anic mi' toc jamben i yotot xujch'. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jini cha'an yom chajpʌbiletla ja'el, come tal i Yalobil Winic ti' yorajlel che' mach yʌxʌlic la' wo. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","¿Majqui lajal bajche' jini xuc'ul bʌ x'e'tel am bʌ cabʌl i ña'tʌbal? Jini x'e'tel tsa' aq'uenti i ye'tel ti' yum cha'an mi' yʌq'ueñob i bʌl i ñʌc' jini año' bʌ ti' yotot che' ti' yorajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tijicña jini x'e'tel uts'at bʌ woli' mel i ye'tel che' mi' c'otel i taj i yum. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Isujm mic subeñetla, mi caj i yʌq'uen ñuc bʌ i ye'tel cha'an pejtelel i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mi tsi' yʌlʌ ti' pusic'al jini jontol bʌ x'e'tel: “Jal to tal c yum”, mi che'en, ");
INSERT INTO ctuBl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mi tsa' caji i jats' i pi'ʌlob ti e'tel, mi tsi' cha'le we'el, mi tsi' cha'le uch'el yic'ot xyʌc'ʌjelob, ");
INSERT INTO ctuBl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","che' jini mi caj i julel i yum jini x'e'tel ti jump'ejl q'uin che' mach yʌxʌlic i yo, che' ti' yorajlel mach ña'tʌbilic i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mi caj i yʌc' ti tojmulil. Mi caj i yotsan ba' añob jini cha'chajp jax bʌ i pusic'al. Ya'i mi' cajelob ti uq'uel yic'ot quech'ecña i bʌquel i yej. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","I yumʌntel jini am bʌ ti panchan mi caj i lajintel che' bajche' lujuntiquil xch'oc tsa' bʌ i ch'ʌmʌyob majlel candil. Tsa' majli i tajob xñujpuñijel. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jo'tiquil añob i ña'tʌbal. Jo'tiquil ma'añobic i ña'tʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jini mach bʌ añobic i ña'tʌbal tsi' ch'ʌmʌyob majlel candil. Ma'anic tsi' ch'ʌmʌyob majlel cas. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jini año' bʌ i ña'tʌbal tsi' ch'ʌmʌyob majlel cas ti' buxil yic'ot i candil. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Che' bʌ tsa' jale xñujpuñijel, tsi' cha'leyob ñʌcʌb. Tsa' cajiyob ti wʌyel. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ti ojlil ac'ʌlel tsi' yubiyob t'an: “Ubix tilel xñujpuñijel. Cucula, tajala”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Che' jini tsa' lu' ch'ojyiyob jini xch'oc. Tsi' ts'ita' wilts'ubeyob loq'uel i pislel candil. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jini mach bʌ añobic i ña'tʌbal tsi' subeyob i pi'ʌlob: “Aq'ueñon lojon ts'ita' a cas, come yomix yajpel j candil lojon”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jini año' bʌ i ña'tʌbal tsi' yʌlʌyob: “Ma'anic, ame mach jasʌlic cha'añon lojon cha'añetla ja'el. Cucula ba'an xchon casob. Mʌñʌ la' cha'an”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Che' woliyob ti mʌñoñel tsa' tili xñujpuñijel. Jini chajpʌbilobix bʌ tsa' ochiyob yic'ot xñujpuñijel ba' woliyob ti ñujpuñijel. Tsa' mʌjqui i ti' otot. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wi'il tsa' c'otiyob ja'el jini yambʌ xch'ocob. Tsi' yʌlʌyob: “C Yum, c Yum, jambeñon lojon”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jini Yumʌl tsi' subeyob: “Isujm mic subeñetla, mach j cʌñʌyeticla”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Chʌcʌ q'uele la' bʌ che' jini, come mach la' wujilic baqui bʌ q'uin baqui bʌ ora mi' tilel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Come i yumʌntel jini am bʌ ti panchan lajalʌch bajche' juntiquil winic mu' bʌ caj i majlel ti ñajt bʌ lum. Tsi' pʌyʌ tilel x'e'telob i cha'an. Tsi' yotsʌbeyob ti' wenta i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tsi' yʌq'ue juntiquil jo'p'ejl talento. Tsi' yʌq'ue yambʌ cha'p'ejl talento. Tsi' yʌq'ue yambʌ jump'ejl talento. Ti jujuntiquil tsa' aq'uentiyob che' bajche' añob i c'ʌjñibal. Tsa' majli ti ñajtʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jini tsa' bʌ i ch'ʌmʌ jo'p'ejl talento tsa' bʌc' majli. Tsi' wen c'ʌñʌ ti ganar. Tsi' cha'le ti ganar yambʌ jo'p'ejl talento. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Che' ja'el, jini tsa' bʌ i ch'ʌmʌ cha'p'ejl talento tsi' cha'le ti ganar yambʌ cha'p'ejl talento. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero jini tsa' bʌ i ch'ʌmʌ jump'ejl talento tsa' majli i pic lum. Ya' tsi' mucu i taq'uin i yum. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Che' bʌ tsa' ñumi cabʌl ora, tsa' cha' tili i yum jini x'e'telob cha'an mi' q'uel bajche' tsi' c'ʌñʌyob jini taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsa' tili jini tsa' bʌ aq'uenti jo'p'ejl talento. Tsi' ch'ʌmʌ tilel yambʌ jo'p'ejl talento. Tsi' yʌlʌ: “C yum, tsa' wʌq'ueyon jo'p'ejl talento. Umba'an. Tsac cha'le ti ganar yambʌ jo'p'ejl”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","I yum tsi' sube: “Uts'at bajche' tsa' cha'le. Uts'atet xuc'ul bʌ x'e'telet. Xuc'ul tsa' mele che' an ts'ita' ti a wenta. Cabʌl mi caj cotsʌbeñet ti a wenta. Tijicñesan a pusic'al che' bajche' tijicña i pusic'al a yum”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Che' ja'el, tsa' tili jini tsa' bʌ aq'uenti cha'p'ejl talento. Tsi' sube: “C yum, tsa' wʌq'ueyon cha'p'ejl talento. Umba'an. Tsac cha'le ti ganar yambʌ cha'p'ejl”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","I yum tsi' sube: “Uts'at bajche' tsa' cha'le. Uts'atet xuc'ul bʌ x'e'telet. Xuc'ul tsa' mele che' an ts'ita' ti a wenta. Cabʌl mi caj cotsʌbeñet ti a wenta. Tijicñesan a pusic'al che' bajche' tijicña i pusic'al a yum”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tsa' tili jini tsa' bʌ aq'uenti jump'ejl talento. Tsi' yʌlʌ: “C yum, tsac ña'ta bʌc'ñʌbilet. Ma' tsep jini jam ba' ma'anic tsa' wejch'u. Ma' lotben i wut ba' ma'anic tsa' wejlʌbe loq'uel i sujl. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tsac cha'le bʌq'uen. Tsa' majli c muc a taq'uin ti mal lum. Umba'an, a cha'añʌch”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","I yum tsi' sube: “Jontolet, ts'ub bʌ x'e'telet. Awujil mic tsep jam ba' ma'anic tsac wejch'u. Mic lotben i wut ba' ma'anic tsac wejlʌbe loq'uel i sujl. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Chucoch ma'anic tsa' wʌc'ʌ c taq'uin ba' mi' c'ʌjñel ti ganar? Actan che'ic jini, tsa' mejli c cha' ch'ʌm c taq'uin yic'ot i jol che' bʌ tsa' juliyon. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jini cha'an chilbenla jini taq'uin. Aq'uenla jini am bʌ lujump'ejl i talento. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Come jini am bʌ i cha'an mi caj i yʌq'uentel yambʌ. Che' jini wen on i cha'an. Majqui jach ma'anic i cha'an mi caj i lu' chilbentel pejtelel chuqui an i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chocola jini x'e'tel mach bʌ anic i c'ʌjñibal ti ic'ch'ipan bʌ pañimil ya' ti jumpat. Ya' mi' cajelob ti uq'uel yic'ot quech'ecña i bʌquel i yej”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Che' mi' tilel i Yalobil Winic ti' ñuclel yic'ot pejtelel i yángelob mi' caj ti buchtʌl ti' yumʌntel yic'ot i ñuclel. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ti' tojel i wut mi caj i tempʌntelob pejtelel winicob x'ixicob loq'uemo' bʌ ti pejtelel lum. Jini Xcʌnta tiñʌme' mi caj i t'oxob. Parte mi' yʌc' chivo, parte mi' yʌc' tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mi' yʌc' tiñʌme' ti' ñoj. Mi' yʌc' chivo ti' ts'ej. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jini Rey mi caj i suben jini año' bʌ ti' ñoj: “La' cu la, ochemet bʌ la ti' yutslel c Tat. Ch'ʌmʌ la' yumʌntel chajpʌbebiletla c'ʌlʌl ti' cajibal pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Come che' bʌ tsa cubi wi'ñal, tsa' la' wʌq'ueyon i bʌl c ñʌc'. Che' bʌ tsa cubi tiquin ti', tsa' la' wʌq'ueyon chuqui mic jap. Che' mach cʌmbilonic la' cha'an, tsa' la' pʌyʌyon ochel. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Che' pits'ilon, tsa' la' wʌq'ueyon chuqui mic xoj. Che' c'amon, tsa' la' jula'tayon. Che' añon ti cárcel, tsa' tili la' q'uelon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jini tojo' bʌ i pusic'al mi caj i subeñob: “C Yum, ¿am ba ba' tsaj q'ueleyet lojon che' wi'ñayet? ¿Tsa' ba cʌq'ueyet lojon i bʌl a ñʌc'? Che' an a tiquin ti', ¿tsa' ba cʌq'ueyet lojon chuqui ma' jap? ");
INSERT INTO ctuBl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Am ba ba' tsaj q'ueleyet lojon che' mach j cʌñʌyetic? ¿Tsa' ba c pʌyʌyet lojon ochel? ¿Tsa' ba cʌq'ueyet lojon chuqui ma' xoj che' pits'ilet? ");
INSERT INTO ctuBl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Am ba ba' tsaj q'ueleyet lojon che' c'amet? ¿Am ba ba' tsac jula'tayet lojon che' añet ti cárcel?” che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jini Rey mi caj i subeñob: “Isujm mic subeñetla, che' bʌ tsa' la' colta juntiquil quermano, anquese mach ñuquic, tsa' la' coltayon ja'el”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Che' ja'el, mi caj i subeñob año' bʌ ti' ts'ej: “Cucula, chojquemet bʌ la ti Dios. Ochenla ti c'ajc mach bʌ anic mi' jilel, jini c'ajc chajpʌbil bʌ cha'an xiba yic'ot i yángelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Come che' bʌ tsa cubi wi'ñal, ma'anic tsa' la' wʌq'ueyon i bʌl c ñʌc'. Che' bʌ tsa cubi tiquin ti', ma'anic tsa' la' wʌq'ueyon chuqui mic jap. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Che' mach cʌmbilonic la' cha'an ma'anic tsa' la' pʌyʌyon ochel. Che' pits'ilon ma'anic tsa' la' wʌq'ueyon chuqui mic xoj. Che' c'amon, che' añon ti cárcel, ma'anic tsa' la' jula'tayon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Mi caj i subeñob: “C Yum, ¿am ba ba' tsaj q'ueleyet lojon che' wi'ñayet, mi che' an a tiquin ti', mi che' pits'ilet, mi che' c'amet, mi che' añet ti cárcel? ¿Am ba ba' ma'anic tsaj coltayet lojon?” che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Che' jini, mi caj i subeñob: “Isujm mic subeñetla, che' bʌ ma'anic tsa' la' colta juntiquil c cha'an bʌ anquese mach ñuquic, ma'anic tsa' la' coltayon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jini cha'an mi caj i majlelob ti tojmulil mach bʌ anic mi' jilel. Jini tojo' bʌ i pusic'al mi caj i majlelob ba' ma'anic mi' jilel i cuxtʌlel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Che' bʌ tsa' ujti Jesús i sub pejtel jini t'an, tsi' sube xcʌnt'añob i cha'an: ");
INSERT INTO ctuBl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","La' wujil uxi i q'uiñilelix Pascua. I Yalobil Winic mi caj i yʌjq'uel ti' c'ʌb jini mu' bʌ i ch'ijob ti cruz, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jini ñuc bʌ motomajob yic'ot sts'ijbayajob yic'ot xñoxob año' bʌ i ye'tel ti tejclum tsi' tempayob i bʌ ti' pam i yotot jini ñuc bʌ motomaj i c'aba' Caifás. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tsi' temeyob i t'an cha'an mi' chucob Jesús ti mucul cha'an mi' tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tsi' yʌlʌyob: Mach ti' yorajlelic q'uiñijel ame tejchicob ti cabʌl a'leya winicob x'ixicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Che' ya'an Jesús ti Betania ti' yotot jini Simón tsa' bʌ lajmesʌbenti leco bʌ i tsoy, ");
INSERT INTO ctuBl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","tsa' tili juntiquil x'ixic ba'an Jesús. An i limetej melbil bʌ ti xajlel but'ul ti xojocña bʌ ts'ac, wen letsem bʌ i tojol. Tsi' mulbe ti' jol Jesús che' buchul ti' t'ejl mesa. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Che' bʌ tsi' q'ueleyob xcʌnt'añob i cha'an, tsa' cajiyob ti mich'ajel. Tsi' yʌlʌyob: ¿Chuqui i ye'tel tsi' lon jisa jini ts'ac? ");
INSERT INTO ctuBl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Come letsem i tojol. Tsa'ic i choño jini ts'ac tsa' mejli i yʌq'uen p'ump'uño' bʌ, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ña'tʌbilix i cha'an Jesús chuqui tsi' yʌlʌyob. Tsi' subeyob: ¿Chucoch mi la' techben i ch'ijiyemlel i pusic'al jini x'ixic? I t'ojol jax chuqui tsi' melbeyon. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Come ti pejtelel ora an jini p'ump'uño' bʌ la' wic'ot, pero mach ti pejtelelic ora wʌ' añon la' wic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Come tsi' mulu jini ts'ac tic bʌc'tal cha'an mi' chajpan c bʌc'tal cha'an mic mujquel. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Isujm mic subeñetla, baqui jach mi' sujbel jini wen t'an ti pejtelel pañimil, muq'uix i sujbel ja'el jini tsa' bʌ i mele jini x'ixic, cha'an mi' ña'tʌntel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Juntiquil i pi'ʌl jini junlujuntiquil, i c'aba' Judas Iscariote, tsa' majli ba'an ñuc bʌ motomajob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tsi' subeyob: ¿Chuqui mi caj la' wʌq'ueñon cha'an mi cʌc' Jesús ti la' c'ʌb? che'en. Tsi' tojoyob lujump'ejl i cha'c'al sʌsʌc taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti jim bʌ ora Judas Iscariote tsa' caji i chajpan i bʌ cha'an mi' yʌc' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti jini ñaxan bʌ q'uin che' ti' q'uiñilel che' mi' c'uxob caxlan waj mach bʌ anic i levadurajlel, jini xcʌnt'añob tsa' tiliyob ba'an Jesús. Tsi' yʌlʌyob: ¿Baqui a wom mic chajpan lojon cha'an ma' c'ux we'elʌl che' ti Pascua? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús tsi' yʌlʌ: Cucula ti tejclum ba' mi caj la' q'uel juntiquil winic. Subenla: “Lac Maestro woli' yʌl: I yorajlelix mic majlel. Muq'uix c cha'len Pascua ti a wotot yic'ot xcʌnt'añob c cha'an”. Che' yom mi la' suben, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jini xcʌnt'añob tsi' jac'beyob i t'an Jesús. Tsi' chajpayob Pascua. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Che' wolix i yic'an, tsa' buchle Jesús yic'ot jini lajchʌntiquil xcʌnt'añob ti' t'ejl mesa. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Che' woli' c'uxob we'elʌl, Jesús tsi' yʌlʌ: Isujm mic subeñetla, juntiquil ti la' tojlel mi caj i yʌc'on ti' c'ʌb j contra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wen ch'ijiyem i pusic'al tsa' caji i yubiñob. Quepecña tsa' caji' yʌlob ti junjuntiquil: C Yum, ¿joñon ba? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús tsi' subeyob: Jini tsa' bʌ i yotsa i c'ʌb ti latu quic'ot mi caj i yʌc'on ti' c'ʌb j contra. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","I Yalobil Winic mi caj i majlel che' bajche' ts'ijbubil. Mi caj i taj wocol jini winic mu' bʌ i yʌc' i Yalobil Winic ti' c'ʌb i contra. Uts'at machic tsi' yila pañimil jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jini Judas, tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra, tsi' yʌlʌ: Maestro, ¿joñon ba? che'en. Jesús tsi' sube: Jatet cu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Che' bʌ woliyob ti we'el, Jesús tsi' ch'ʌmʌ waj. Tsi' cha'le oración. Tsi' xet'e. Tsi' yʌq'ue xcʌnt'añob i cha'an. Tsi' yʌlʌ: Ch'ʌmʌla. C'uxula. Jiñʌch c bʌc'tal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Che' ja'el tsi' ch'ʌmʌ vaso. Che' bʌ tsi' sube Dios wocolix i yʌlʌ, tsi' yʌq'ueyob. Tsi' yʌlʌ: Japʌla ti pejteletla. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Jiñʌch c ch'ich'el cha'an jini xuc'ul bʌ t'an mu' bʌ i bejq'uel cha'an cabʌlob cha'an i ñusʌntel mulil. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero mic subeñetla, ma'anix mic chʌn jap i ya'lel ts'usub jinto che' temel quic'otetla mic jap jini tsiji' bʌ ti' yumʌntel c Tat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Che' bʌ tsa' ujti i c'ʌyiñob jump'ejl c'ay, tsa' majliyob ti Olivo wits. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús tsi' subeyob: Ti ili ac'ʌlel mi' caj ti tejchel tile bixel bʌ la' pusic'al ti la' pejtelel cha'an chuqui mi caj c tumbentel, come ts'ijbubil: “Mi caj c low xcʌnta tiñʌme'. Jini tiñʌme' mi caj i pam pujquel”. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Che' tejchemoñix ch'ojyel, mic majlel c pijtañetla ti Galilea, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro tsi' sube Jesús: Mi tsa' tejchi tile bixel bʌ i pusic'al yaño' bʌ cha'an chuqui mi caj a tumbentel, ma'anic ba' ora mi caj i tejchel tile bixel bʌ c pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús tsi' sube: Isujm mic subeñet, ti ili ac'ʌlel che' maxto anic tsi' cha'le uq'uel tat mut, uxyajl mi caj a wʌl mach a cʌñʌyonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro tsi' sube: Mi wersa yom mic chʌmel quic'otet, ma'anic mi caj cʌl mach j cʌñʌyetic, che'en. Che'i tsi' yʌlʌyob pejtelel xcʌnt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús tsi' pi'leyob majlel ti pʌc'ʌbʌl i c'aba' Getsemaní. Tsi' sube xcʌnt'añob i cha'an: Buchi'la ilayi che' mic majlel c cha'len oración ya'i, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tsi' pʌyʌ majlel Pedro yic'ot cha'tiquil i yalobil Zebedeo. Ch'ijiyem tsa' caji i yubin. Tsi' wen mele i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jesús tsi' subeyob: Wen ch'ijiyem jax c pusic'al. Comix chʌmel ti' ch'ijiyemlel c pusic'al. Pijtanla wʌ'i. Yom yʌxʌl la' wo quic'ot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsa' to i ts'ita' xʌñʌ majlel. Tsi' pʌcchoco i bʌ. Tsi' cha'le oración. Tsi' yʌlʌ: C Tat mi che'ʌch yom, tʌts'beñon ili wocol. Pero mach a mel che' bajche' com. Mele che' bajche' yom a pusic'al, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tsa' tili ba'an xcʌnt'añob i cha'an. Wʌyʌlob tsi' tajayob. Tsi' sube Pedro: ¿Mach ba anic tsa' mejli la' tic' la' wʌyel mi jump'ejlic ora? ");
INSERT INTO ctuBl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yom yʌxʌl la' wo. Cha'lenla oración cha'an ma'anic mi la' jac' la' pʌyol ti mulil. Come ch'ejl la' pusic'al, pero c'uñatax la' bʌc'tal, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti' cha'yajlel tsa' majli Jesús i cha'len oración. Tsi' yʌlʌ: C Tat mi mach mejlic ti tʌjts'el ili wocol, mi wersa yom mij cuch, mele bajche' yom a pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tsa' cha' tili. Wʌyʌlob tsi' cha' tajayob come suts'ob jax i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tsi' cha' cʌyʌyob. Tsa' cha' majli. Ti' yuxyajlel tsi' cha'le oración ti lajal bʌ t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tsa' cha' tili ba'an xcʌnt'añob i cha'an. Tsi' subeyob: Cha'lenla wʌyel. C'aja la' wo. Awilan, tsa'ix c'oti i yorajlel, i Yalobil Winic woli' yʌjq'uel ti' c'ʌb xmulilob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ch'ojyenla. Conixla. Awilan, lʌc'ʌl an jini mu' bʌ i yʌc'on ti' c'ʌb j contra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Che' bʌ woli to ti t'an Jesús, awilan tsa' tili jini Judas, i pi'ʌl jini junlujuntiquil. Tsa' tili yic'ot cabʌl año' bʌ i machit yic'ot i te' tac, chocbilo' bʌ tilel i cha'an ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel ti tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jini Judas tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra tsi' wʌn subeyob bajche' mi caj i cʌñob. Tsi' yʌlʌ: Jini mu' bʌ c ts'ujts'un, jiñʌch. Chucula, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Tsa' bʌc' tili ba'an Jesús. Tsi' yʌlʌ: Cotañet Maestro, che'en. Tsi' ts'ujts'u. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús tsi' pejca Judas ti' pi'ʌl. Tsi' sube: ¿Chucoch tsa' tiliyet ilayi? che'en. Ti ora tsa' tiliyob ba'an Jesús. Tsi' chucuyob. Tsi' pʌyʌyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Awilan, juntiquil ya' bʌ an yic'ot Jesús tsi' chucu i machit. Tsi' bots'o. Tsi' lowo jini x'e'tel i cha'an jini c'ax ñuc bʌ motomaj. Tsi' wel tsepbe loq'uel i chiquin. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús tsi' sube: Cha' otsan a machit ti' yotot come jini mu' bʌ i chucob machit mi caj i jilelob ti machit. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mi tsaj c'ajtibe c Tat, ¿mach ba anic ma' ña'tan mi' bʌc' chocbeñon tilel ñumen ti bolompic ángelob? ");
INSERT INTO ctuBl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero che' jini, ¿bajche' mi' ts'ʌctiyel i Ts'ijbujel Dios mu' bʌ i yʌl wersa mi' yujtel pejtelel jini? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ti jim bʌ ora Jesús tsi' sube jini winicob: ¿Tsa' ba tiliyetla cha'an mi la' chucon che' bajche' mi la' chuc xujch' ti machit yic'ot ti te'? Tsa' buchleyon ti cʌntesa quic'otetla ti jujump'ejl q'uin ti Templo. Ma'anic tsa' la' chucuyon. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero che'ʌch woli' yujtel cha'an mi' laj ts'ʌctiyel i Ts'ijbujel x'alt'añob, che'en Jesús. Ti pejtelel xcʌnt'añob tsi' cʌyʌyob Jesús. Tsa' puts'iyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jini tsa' bʌ i chucuyob Jesús tsi' pʌyʌyob majlel ba'an Caifás jini c'ax ñuc bʌ motomaj, ba' tsi' tempayob i bʌ sts'ijbayajob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro tsi' ñajti tsajca majlel Jesús c'ʌlʌl ti pam i yotot c'ax ñuc bʌ motomaj. Tsa' ochi. Tsa' buchle yic'ot xcʌntayajob cha'an mi' q'uel bajche' mi caj i yujtel. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jini ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel yic'ot pejtelel año' bʌ i ye'tel tsi' sajcayob jini mu' bʌ i cha'leñob jop't'an ti' contra Jesús cha'an mi' yʌc'ob ti chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tsa' tiliyob cabʌl xjop't'añob, pero ma'anic tsa' mejli i tajbeñob i mul Jesús. Ti wi'il tsa' tiliyob yambʌ cha'tiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tsi' yʌlʌyob: Jini Jesús tsi' yʌlʌ: “Mi mejlel c jisan jini Templo i cha'an Dios. Mi mejlel c cha' wa'chocon ti uxp'ejl q'uin”. Che' tsi' yʌlʌ, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tsa' wa'le jini c'ax ñuc bʌ motomaj. Tsi' sube Jesús: ¿Mach ba anic chuqui ma' jac'? ¿Chuqui jini mu' bʌ i subob winicob ti a contra? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ma'anic chuqui tsi' yʌlʌ Jesús. Jini c'ax ñuc bʌ motomaj tsi' sube: Mic subeñet ti' c'aba' jini cuxul bʌ Dios cha'an ma' subeñon lojon mi Cristojet. Subeñon lojon mi i Yalobilet Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús tsi' sube: Joñon cu. Pero mic subeñetla, wʌle c'ʌlʌl ti pejtelel ora i Yalobil Winic mi' caj ti buchtʌl ti' ñoj jini P'ʌtʌl bʌ Dios. Mi caj la' q'uel che' mi' tilel ti tocal ti panchan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jini c'ax ñuc bʌ motomaj tsi' tsili i pislel. Tsi' yʌlʌ: Tsa'ix i cha'le p'ajoñel. ¿Chuqui to i c'ʌjñibal xtoj'esa t'añob? Awilan, tsa'ix la' wubi i p'ajoñel. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Bajche' yom mi lac mel mi la' wʌl? che'en jini c'ax ñuc bʌ motomaj. Tsi' jac'ʌyob: Yom mi' yʌjq'uel ti chʌmel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tsa' caji i tujbʌbeñob i wut. Tsi' jats'ʌyob. Tsi' poch'iyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tsi' yʌlʌyob: Mi Cristojet subeñon lojon, ¿majqui tsi' jats'ʌyet? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ya' buchul Pedro ti jumpat ti pam otot. Tsa' tili juntiquil xch'oc. Tsi' yʌlʌ: Jatet ja'el tsa' pi'le ñumel jini Jesús ch'oyol bʌ ti Galilea, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ya' ti' tojel pejtelelob Pedro tsi' yʌlʌ mach isujmic. Tsi' yʌlʌ: Mach cujilic chuqui wola' wʌl, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Che' bʌ tsa' majli ti corredor, yambʌ xch'oc tsi' q'uele. Tsi' sube ya' bʌ añob: Jini ja'el tsi' pi'le ñumel jini Jesús ch'oyol bʌ ti Nazaret, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro tsi' taja yambʌ t'an cha'an mi' wa'chocon i t'an. Tsi' yʌlʌ: Mach j cʌñʌyic jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jumuc' jach tsa' tiliyob jini lʌc'ʌl bʌ wa'alob. Tsi' subeyob: Isujm jatet ja'el xcʌnt'añet i cha'an, come tsiquil ti a t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro tsa' caji i bajñel ch'ʌc i bʌ. Tsi' wersa wa'choco i t'an. Tsi' yʌlʌ: Mach j cʌñʌyic jini winic, che'en. Ti ora tsi' cha'le uq'uel tat mut. ");
INSERT INTO ctuBl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tsa' c'ajtiyi ti' pusic'al Pedro i t'an Jesús tsa' bʌ i sube: “Che' maxto anic mi' cha'len uq'uel tat mut, uxyajl mi caj a wʌl mach a cʌñʌyonic”. Tsa' loq'ui majlel. Tsʌts tsa' caji ti uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ti sʌc'ajel pejtelel ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel ti tejclum tsi' temeyob i t'an ti' contra Jesús cha'an mi' tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Che' bʌ tsa'ix i cʌchʌyob tsi' pʌyʌyob majlel. Tsi' yʌc'ʌyob ti' c'ʌb jini gobernador i c'aba' Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jini Judas, tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra, tsi' mele i pusic'al che' bʌ tsi' q'uele mux caj i yʌjq'uel ti chʌmel Jesús. Tsi' cha' sutq'ui jini lujump'ejl i cha'c'al sʌsʌc taq'uin ba'an ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tsi' yʌlʌ: Tsa'ix c cha'le mulil che' bʌ tsa cʌc'ʌ ti la' c'ʌb jini mach bʌ anic i mul, che'en Judas. Tsi' subeyob: Mach c wentajic lojon. Bajñel q'uele a bʌ, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas tsi' choco jini taq'uin ti Templo. Tsa' loq'ui majlel. Tsa' majli i jich' i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jini ñuc bʌ motomajob tsi' ch'ʌmʌyob jini taq'uin. Tsi' yʌlʌyob: Tic'bil ti mandar mi la cotsan ti' yajñib ofrenda, come jiñʌch i tojol i ch'ich'el winic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tsi' pejcayob i bʌ bajche' mi caj i c'ʌñob jini taq'uin. Tsi' mʌñʌyob jamil i cha'an xmel p'ejt cha'an ya'i mi' mucob jini ch'oyolo' bʌ ti yan tac bʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jini cha'an, an i c'aba' jini jamil c'ʌlʌl wʌle: Jamil mʌmbil ti' tojol i ch'ich'el winic, che'ʌch i c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Che' jini tsa' ts'ʌctiyi i t'an jini x'alt'an Jeremías tsa' bʌ i yʌlʌ: “Tsi' ch'ʌmʌyob jini lujump'ejl i cha'c'al sʌsʌc taq'uin i tojol juntiquil winic. Come che'ʌch i tojol jini winic tsi' yʌlʌyob i yalobilob Israel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tsi' yʌc'ʌyob jini taq'uin cha'an i tojol i jamil xmel p'ejt che' bajche' tsi' subeyon lac Yum”. Che' ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ya' wa'al Jesús ti' wut jini gobernador. Jini gobernador tsi' c'ajtibe: ¿Jatet ba i Reyet judíojob? che'en. Jesús tsi' sube: Joñon cu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Che' bʌ tsi' pʌc'ʌyob ti mulil Jesús jini ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel, ma'anic chuqui tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato tsi' sube: ¿Mach ba wolic a wubin jaychajp woli' yʌlob ti a contra? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesús ma'anic chuqui tsi' jac'be mi junyajlic ti pejtelel chuqui tsi' yʌlʌyob ti' contra. Jini cha'an tsa' toj sajti i pusic'al jini gobernador. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Che' ti' yorajlel q'uiñijel, i tilelʌch jini gobernador mi' yʌc' ti colel juntiquil xñujp'el majqui jach c'ajtibil i cha'an winicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ya' ñup'ul juntiquil winic i c'aba' Barrabás, wen cʌñʌl i cha'an winicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Che' bʌ tsi' tempayob i bʌ winicob, Pilato tsi' subeyob: ¿Majqui la' wom mi cʌc' ti colel? ¿Jim ba Barrabás, o jim ba Jesús mu' bʌ i pejcʌntel ti Cristo? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Come yujil Pilato tsa' jach i yʌc'ʌyob Cristo ti' c'ʌb cha'an tsʌytsʌyñayob jax i pusic'al cha'an i ñuclel Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Che' ja'el, che' buchul Pilato ti meloñibʌl, i yijñam tsi' chocbe tilel t'an. Tsi' yʌlʌ: Mach yomic chuqui ma' tumben jini toj bʌ winic, come sajmʌl tsa cubi cabʌl wocol tic ñajal cha'an jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jini ñuc bʌ motomaj yic'ot xñoxob año' bʌ i ye'tel tsi' wersa xic'beyob winicob cha'an mi' yʌc'ob ti colel Barrabás cha'an mi' tsʌnsʌntel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jini gobernador tsi' c'ajtibeyob: ¿Baqui bʌ la' wom mi cʌc' ti colel? che'en. Tsi' jac'ʌyob: Barrabás, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato tsi' subeyob: ¿Chuqui la' wom mic tumben jini Jesús mu' bʌ i pejcʌntel ti Cristo? che'en. Ti pejtelel tsi' subeyob: La' ch'ijlec ti cruz, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jini gobernador tsi' subeyob: ¿Chucoch? ¿Chuqui ti jontolil tsi' cha'le? che'en. Tsa' utsi cajiyob ti c'am bʌ t'an. Tsi' yʌlʌyob: La' ch'ijlec ti cruz, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato tsi' ña'ta ma'anic chuqui tsa' mejli i cha'an, come woli' tejchelob ti cabʌl leto. Jini cha'an tsi' ch'ʌmʌ ja'. Tsi' poco i c'ʌb ti' tojlelob. Tsi' yʌlʌ: Ma'anic c mul joñon cha'an i ch'ich'el jini toj bʌ winic. Anix ti la wenta, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tsi' jac'ʌyob winicob x'ixicob: La' c toj lojon quic'ot lojon calobilob i ch'ich'el jini winic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Che' jini tsi' colbeyob Barrabás. Che' bʌ tsa' ujti i jats' Jesús ti asiyal, tsi' yʌc'ʌ ti' c'ʌb soldadojob cha'an mi' ch'ijob ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jini soldadojob i cha'an jini gobernador tsi' pʌyʌyob majlel Jesús ti yambʌ colem bʌ i mal otot. Tsi' tempayob tilel soldadojob ti' joytilel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tsi' jochbeyob loq'uel i pislel. Tsi' lʌpbeyob chʌcts'eran bʌ pʌl bʌ bujcʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Che' bʌ tsi' xot jalʌyob ch'ix, tsi' joy ñet'eyob ti' jol Jesús. Tsi' yʌq'ueyob bastón ti ñoj bʌ i c'ʌb. Tsi' ñocchocoyob i bʌ ti' tojlel. Tsi' wajleyob. Tsi' yʌlʌyob: Cotañet i Reyet judíojob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tsi' tujbayob. Tsi' cha' ch'ʌmbeyob jini bastón. Tsi' jats'beyob i jol. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Che' bʌ tsa' ujti i wajleñob, tsi' jochbeyob jini pʌl bʌ bujcʌl. Tsi' cha' lʌpbeyob i pislel. Tsi' pʌyʌyob majlel cha'an mi' ch'ijob ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Che' bʌ woli' majlelob, tsi' tajayob juntiquil winic ch'oyol bʌ ti Cirene, i c'aba' Simón. Wersa tsi' yʌq'ueyob i q'uech majlel i cruz Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tsa' c'otiyob ti jump'ejl bujtʌl i c'aba' Gólgota. Mi' yʌl ti lac t'an: che' yilal jini lum bajche' i bʌquel jolʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tsi' yʌq'ueyob vinagre xʌbʌl yic'ot ch'aj bʌ cha'an mi' jap. Che' bʌ tsi' mits'ti'a, ma'anic tsi' japʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tsi' ch'ijiyob ti cruz. Tsi' pucbeyob i bʌ i pislel Jesús. Tsi' cha'leyob yajcaya ti alas cha'an mi' ña'tañob majqui mi caj i ch'ʌm. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tsa' buchleyob ba' mi' q'uelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tsi' ch'ijiyob te' ti' chañelal i jol Jesús ba' ts'ijbubil t'an ti' contra: JIÑɅCH JESÚS, I REY JUDIOJOB. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tsi' ch'ijiyob cha'tiquil xujch' yic'ot Jesús, juntiquil ti' ñoj, juntiquil ti' ts'ej. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jini woliyo' bʌ ti ñumel tsi' p'ajayob Jesús. Tsi' ñijcayob i jol. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tsi' yʌlʌyob: Jatet mu' bʌ a jisan Templo, mu' bʌ a cha' wa'chocon ti uxp'ejl q'uin, coltan a bʌ. Mi i Yalobilet Dios, juben ti cruz, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Che' ja'el ñuc bʌ motomajob tsi' wajleyob yic'ot sts'ijbayajob, yic'ot fariseojob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Tsi' yʌlʌyob: Tsi' colta yaño' bʌ. Mach mejlic i coltan i bʌ. Jiñʌch i Rey Israel mi' yʌl. La' jubic ti cruz. Che' jini mi caj lac ñop. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tsi' ñopo Dios. La' i coltan wʌle mi yom. Come tsi' yʌlʌ: “Joñon i Yalobilon Dios”, che'en. Che' tsi' yʌlʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jini xujch'ob ja'el, tsa' bʌ ch'ijleyob ti cruz yic'ot Jesús, lajal tsi' wajleyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ti xinq'uiñil tsa' ic'a pejtelel pañimil c'ʌlʌl ti och'ajel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Che' yom i taj och'ajel q'uin, Jesús tsi' cha'le c'am bʌ t'an. Tsi' yʌlʌ: Elí, Elí, lama sabactani, che'en. Mi' yʌl ti lac t'an: C Dios, C Dios, ¿chucoch tsa' cʌyʌyon? ");
INSERT INTO ctuBl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Che' bʌ tsi' yubiyob jini lʌc'ʌl bʌ wa'alob, lamital tsi' yʌlʌyob: Woli' pʌy tilel Elías, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Juntiquil tsa' bʌc' majli ti ajñel. Tsi' ch'ʌmʌ chʌyo' ja'. Tsi' yʌc'ʌ i chʌy vinagre. Tsi' yʌc'ʌ ti' ñi' te'. Tsi' yʌq'ue Jesús cha'an mi' ts'ujts'un. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yaño' bʌ tsi' yʌlʌyob: Pijtanla. La' laj q'uel mi tal Elías i coltan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Che' bʌ tsi' cha' cha'le c'am bʌ t'an, Jesús tsi' yʌc'ʌ ti majlel i ch'ujlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Awilan, jini pisil joc'ol bʌ ti Templo tsa' tsijli ti ojlil ya' ti' jol c'ʌlʌl ti' yoc. Tsa' tili i yujquel lum. Tsa' tojp'i xajlel tac. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tsa' jajmi i ti' tac i yotlel ch'ujlelʌl. Tsa' tejchiyob ch'ojyel cabʌl i cha'año' bʌ Dios tsa' bʌ chʌmiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tsa' loq'uiyob ti mucoñibʌl. Che' bʌ tejchemix ch'ojyel Jesús, tsa' majliyob ti jini ch'ujul bʌ tejclum. Tsa' tsictiyiyob ti' wut cabʌl winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","I yaj capitán jo'c'al soldadojob yic'ot i soldadojob ya' bʌ añob woli' q'uelob Jesús. Tsi' cha'leyob bʌq'uen che' bʌ tsi' q'ueleyob i yujquel lum yic'ot pejtelel tsa' bʌ ujti. Tsi' yʌlʌyob: Isujm jiñʌch i Yalobil Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ya' añob cabʌl x'ixicob ja'el woli' ñajtʌ q'uelob. Jiñobʌch tsa' bʌ i we'sayob majlel Jesús c'ʌlʌl che' bʌ tsa' loq'ui majlel ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ya'an María ch'ojol bʌ ti Magdala yic'ot i ña' i yalobilob Zebedeo yic'ot María i ña' Jacobo. Jiñʌch i ña' José ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Che' bʌjlemix q'uin, tsa' tili wen chumul bʌ winic i c'aba' José, ch'oyol bʌ ti Arimatea. Jiñʌch ja'el xcʌnt'an i cha'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Tsa' majli ba'an Pilato. Tsi' c'ajtibe i bʌc'tal Jesús. Pilato tsi' yʌc'ʌ mandar cha'an mi' yʌq'uentel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jini José che' bʌ tsi' ch'ʌmʌ i bʌc'tal Jesús, tsi' bʌc'ʌ ti sʌc bʌ i bʌjq'uil. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Tsi' ñolchoco ti tsiji' bʌ i yotlel ch'ujlelʌl tocbil bʌ i mal xajlel. Tsi' selc'uyob majlel colem xajlel ti' ti' i yotlel ch'ujlelʌl. Tsa' sujti majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ya' añob María ch'oyol bʌ ti Magdala yic'ot jini yambʌ María buchulob ti' tojel i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti yijc'ʌlal che' bʌ tsa' ñumi i q'uiñilel chajpaya, tsi' tempayob i bʌ ñuc bʌ motomajob yic'ot fariseojob ba'an Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tsi' yʌlʌyob: C yum, wolic ña'tan lojon chuqui tsi' yʌlʌ jini xlot che' cuxul to. Tsi' yʌlʌ: “Ti' yuxp'ejlel q'uin mic cha' ch'ojyel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cha'len mandar, che' jini, cha'an mi' wen q'uejlel i yotlel ch'ujlelʌl c'ʌlʌl ti yuxp'ejlel q'uin, ame majlicob xcʌnt'añob i cha'an ti ac'ʌlel i xujch'iñob majlel i bʌc'tal. Che' jini mi caj i subeñob winicob x'ixicob: “Tsa' cha' ch'ojyi ba' mucul”. Che' mi caj i yʌlob. Ñumen leco mi' majlel jini lot bajche' ti ñaxan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato tsi' subeyob: An ti la' wenta xcʌntayajob. Cucula. Wen ñup'ula, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Che' jini tsa' majliyob. Tsi' wen ñup'uyob i yotlel ch'ujlelʌl che' bʌ tsi' yotsayob i sellojlel xajlel. Tsi' subeyob xcʌntayajob cha'an mi' wen q'uelob. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Che' bʌ tsa' ñumi jini q'uin che' mi' c'ajob i yo, che' yomix sʌc'an jini ñaxan bʌ q'uin ti semana, tsa' majli María ch'oyol bʌ ti Magdala yic'ot jini yambʌ María cha'an mi' q'uelob i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Awilan, tsʌts tsa' ñumi i yujquel lum, come i yángel lac Yum tsa' jubi tilel ti panchan. Tsi' selc'u loq'uel jini xajlel jini ángel. Ya' tsa' buchle ti' pam xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Che'ʌch yilal bajche' i c'ʌc'al chajc. C'ax sʌsʌc i pislel che' bajche' i ña'al tsʌñal. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jini xcʌntayajob tsiltsilña tsi' bʌc'ñayob ángel. Lajalob tsa' majli bajche' chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jini ángel tsi' sube x'ixicob: Mach mi la' cha'len bʌq'uen. Cujil woli la' sajcan Jesús tsa' bʌ ch'ijle ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mach wʌ'ix an. Come tsa'ix ch'ojyi che' bajche' tsi' yʌlʌ. La'la. Q'uelela i yajñib ba' tsa' ñolchoconti lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cucula ti ora. Subenla xcʌnt'añob i cha'an: “Tsa'ix ch'ojyi Jesús ba'an chʌmeño' bʌ. Awilan, woli' majlel i pijtañetla ti Galilea. Ya' mi caj la' q'uel”. Awilan, tsa'ix c subeyetla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tsa' loq'uiyob ba'an i yotlel ch'ujlelʌl jini x'ixicob. Woliyob ti bʌq'uen. Wen tijicñayob i pusic'al. Ti ajñel tsa' majli i subeñob xcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Awilan, Jesús tsi' tajayob. Tsi' yʌlʌ: Cotañet, che'en. Tsa' tili i chucbeñob i yoc Jesús. Tsi' ch'ujutesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús tsi' subeyob: Mach mi la' cha'len bʌq'uen. Cucula. Subenla quermanojob cha'an mi' majlelob ti Galilea. Ya' mi caj i q'ueloñob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Che' woliyob ti majlel, cha'tiquil uxtiquil xcʌntayajob tsa' c'otiyob ti tejclum. Tsi' subeyob ñuc bʌ motomajob pejtelel chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Che' bʌ tsi' tempayob i bʌ yic'ot xñoxob año' bʌ i ye'tel, tsi' temeyob i t'an. Tsi' yʌq'ueyob soldadojob cabʌl taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tsi' yʌlʌyob: Subeñob winicob x'ixicob: “Tsa' tili xcʌnt'añob i cha'an ti ac'ʌlel. Tsi' xujch'iyob loq'uel i bʌc'tal che' wʌyʌlon lojon”. Che' yom mi la' subeñob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mi tsi' yubi jini gobernador, mi caj c wen pejcan lojon cha'an ma'anic mi la' taj la' mul, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tsi' ch'ʌmʌyob jini taq'uin jini soldadojob. Tsi' cha'leyob che' bajche' tsa' subentiyob. Tsa' pujqui jini t'an ba'an judíojob c'ʌlʌl wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jini junlujuntiquil xcʌnt'añob tsa' majliyob ti Galilea ti wits che' bajche' tsi' subeyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Che' bʌ tsi' q'ueleyob Jesús, tsi' ch'ujutesayob. Yaño' bʌ tile bixelob jax i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús tsa' tili. Tsi' subeyob: Aq'uebilon c p'ʌtʌlel cha'an mic mel pejtelel chuqui com ti panchan yic'ot ti pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cucula che' jini. Sutq'uiñob ti xcʌnt'añob winicob x'ixicob ti pejtelel pañimil. Aq'uenla ch'ʌmja' ti' c'aba' lac Tat, ti' c'aba' i Yalobil, ti' c'aba' Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cʌntesanla cha'an mi' laj ch'ujbiñob pejtelel chuqui tac tsac subeyetla. Awilan, añon quic'otetla ti pejtelel ora c'ʌlʌl ti' jilibal pañimil. Che' tsi' yʌlʌ Jesús.");
INSERT INTO ctuBl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jiñʌch i cajibal jini wen t'an mu' bʌ i yʌc' ti cʌjñel Jesucristo i Yalobil Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Come ts'ijbubil ti' jun jini x'alt'an Isaías: “Awilan, mic ñaxan choc majlel c winic ti' tojel a wut cha'an mi' chajpan a bijlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jiñʌch i t'an juntiquil mu' bʌ i cha'len c'am bʌ t'an: Chajpanla i bijlel lac Yum, pʌtʌla majlel mucu bij i cha'an”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Juan tsi' yʌc'ʌ ch'ʌmja' ti jochol bʌ lum. Tsi' subu t'an cha'an mi' ch'ʌmob ja' winicob x'ixicob che' mi' cʌyob i mul cha'an mi' ñusʌbentelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tsa' loq'uiyob tilel ba'an Juan jini ch'oyolo' bʌ ti' lumal Judea, yic'ot ti Jerusalén. Tsi' ch'ʌmʌyob ja' ti' c'ʌb Juan ya' ti Jordán ja'. Tsi' subuyob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Lʌpʌl i cha'an Juan i tsutsel camello. An i cajchiñʌc' melbil bʌ ti pʌchi. Jini Juan tsi' c'uxu xc'ajba sajc'. Tsi' japʌ te'lechab. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tsi' cha'le subt'an. Tsi' yʌlʌ: Tal tic pat jini ñumen p'ʌtʌl bʌ bajche' joñon. Mach ñucoñic cha'an mic wutstʌl c ticben i ch'ajñal i xʌñʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Isujm joñon tsa cʌq'ueyetla ch'ʌmja'. Jini mi caj i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ Espíritu, che'en Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ti jim bʌ ora tsa' tili Jesús loq'uem bʌ ti Nazaret ya' ti Galilea. Tsi' ch'ʌmʌ ja' ti' c'ʌb Juan ya' ti Jordán ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Che' bʌ tsa' loq'ui ti ja', tsi' bʌc' q'uele tsa' cajli panchan. Jini Espíritu tsa' jubi tilel ti' tojlel Jesús che' bajche' x'ujcuts. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tsa' loq'ui tilel t'an ti panchan tsa' bʌ i yʌlʌ: Calobilet, mij c'uxbiñet, wen uts'at mij q'uelet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ti ora jini Espíritu tsi' wersa choco majlel Jesús ti jochol bʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tsa' ajni cha'c'al q'uin ya' ti colem bʌ i tiquiñal lum. Tsa' ilʌbenti i pusic'al cha'an Satanás. Ya'an yic'ot bʌte'el. Jini ángelob tsi' coltayob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ti wi'il che' ñup'ul Juan ti cárcel tsa' tili Jesús ti Galilea. Tsi' subu jini wen t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tsi' yʌlʌ: Tsa'ix c'oti i yorajlel, lʌc'ʌlix i yumʌntel Dios. Cʌyʌ la' mul. Ñopola jini wen t'an, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Che' woli ti xʌmbal ti' ti' ñajb i c'aba' Galilea, tsi' q'uele Simón yic'ot Andrés i yijts'in Simón. Woli' chocob ochel chimo'chʌy ti ñajb, come xchuc chʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús tsi' subeyob: La' tsajcañon. Joñon mi caj c meletla ti xchuc winicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsi' bʌc' cʌyʌyob i chimo'chʌy. Tsi' tsajcayob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Che' bʌ tsi' xʌñʌ majlel ts'ita', Jesús tsi' q'uele Jacobo i yalobil Zebedeo yic'ot Juan i yijts'in Jacobo. Woli' ts'isob chimo'chʌy ti' mal barco. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ti ora Jesús tsi' pʌyʌyob. Tsi' cʌyʌyob i tat i c'aba' Zebedeo ya' ti' mal barco yic'ot xganarob. Tsi' tsajcayob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tsa' ochiyob ti Capernaum. Tsa' ochi Jesús ti sinagoga ti jini q'uin tac che' mi' c'ajob i yo. Tsi' cha'le cʌntesa. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tsa' toj sajtiyob i pusic'al cha'an i cʌntesʌbal Jesús, come tsi' cʌntesayob ti' p'ʌtʌlel i ye'tel, mach che'ic bajche' sts'ijbayajob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tsa' bʌc' ochi ti sinagoga juntiquil winic am bʌ i xibʌjlel. Tsi' cha'le c'am bʌ t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Tsi' yʌlʌ: ¿Chuqui i ye'tel tsa' tiliyet ba' añon lojon, Jesús ch'oyolet bʌ ti Nazaret? ¿Tsa' ba tiliyet cha'an ma' jisañon lojon? Cujil majquiyet. Jatet jini ch'ujulet bʌ ch'oyol bʌ ti Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús tsi' tiq'ui. Tsi' sube: Ñʌjch'en, loq'uen ti' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jini xiba tsi' yʌc'ʌ ti wersa juquin chʌmel. Wen c'am tsi' cha'le oñel. Tsa' loq'ui ti' pusic'al jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tsa' toj sajtiyob i pusic'al ti pejtelelob. Tsi' c'ajtibeyob i bʌ: ¿Chuqui jini? ¿Mach ba tsijibic i cʌntesʌbal? Come ti' p'ʌtʌlel cha'an i ye'tel mi' subeñob loq'uel xibajob. Mi' jac'beñob i t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tsa' bʌc' pujqui majlel t'an ti pejtelel lum ya' ti' joytilel Galilea cha'an ñuc bʌ i melbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tsa' bʌc' loq'ui ti sinagoga. Tsa' tili yic'ot Jacobo yic'ot Juan ti' yotot Simón ba' chumul Andrés ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ñolol ti c'amʌjel x'ixic bʌ i ñij'al Simón. Woli' yubin c'ajc. Tsi' bʌc' subeyob Jesús c'am jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tsa' tili Jesús. Tsi' chucbe i c'ʌb, tsi' teche ch'ojyel. Tsa' bʌc' lajmi jini c'ajc. Jini x'ixic tsa' caji i we'sañob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ti ic'ajel, che' bʌjlemix q'uin, jini winicob x'ixicob tsi' pʌyʌyob tilel ba'an Jesús pejtelel xc'amʌjelob yic'ot winicob chucbilo' bʌ cha'an cabʌl xibajob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ti pejtelelob tsi' tempayob i bʌ ti' ti' otot. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús tsi' lajmesa cabʌl xc'amʌjelob leco tac bʌ i chʌmel. Tsi' choco loq'uel cabʌl xibajob. Tsi' tiq'uiyob cha'an ma'anic mi' cajelob ti t'an, come jini xibajob tsi' cʌñʌyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Che' bʌ ñumenix ojlil ac'ʌlel che' jal to mi' sʌc'an, tsa' ch'ojiyi Jesús. Tsa' loq'ui majlel ti jochol bʌ lum. Ya'i tsi' cha'le oración. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón yic'ot i pi'ʌlob tsi' sajcayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tsi' tajayob. Tsi' subeyob: Ti pejtelelob woli' sajcañet, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús tsi' subeyob: Conla ti yan tac bʌ tejclum ba' lʌc'ʌl cha'an ya'i mic sub t'an ja'el, come jini cha'an tsa' loq'uiyon tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tsi' subu t'an ti sinagoga tac ti pejtelel Galilea. Tsi' choco loq'uel xibajob. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Juntiquil winic am bʌ leco bʌ i tsoy tsa' tili ba'an Jesús. Tsa' ñocle. Tsi' c'ajtibe ti wocol t'an: Mi a wom mi mejlel a lajmesañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús tsi' p'unta jini winic. Tsi' sʌts'ʌ i c'ʌb. Tsi' tʌlʌ. Tsi' sube: Com cu. La' lajmiquet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Che' bʌ tsa' ujti ti t'an, tsa' bʌc' lajmi leco bʌ i tsoy. Tsa' sʌq'uesʌnti jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús tsi' wersa sube bajche' yom mi' mel. Tsi' bʌc' choco majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jesús tsi' sube: Chʌcʌ q'uele a bʌ cha'an ma'anic majqui ma' suben chuqui tsa' ujti. Cucu. Pʌsʌ a bʌ ba'an motomaj. Ac'ʌ chuqui tsi' subu Moisés ti mandar cha'an mi' q'uelob winicob x'ixicob sʌq'esʌbilet, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Tsa' majli jini winic tsa' bʌ lajmesʌnti. Cabʌl tsa' caji i sub chuqui tsa' ujti. Tsi' pucu majlel jini t'an. Jini cha'an ma'anic tsa' mejli ti ochel Jesús ti tejclum che' bʌ woli' q'uelob winicob x'ixicob. Ya' jach tsa' ajni ti colem bʌ i tiquiñal pañimil. Tsa' tiliyob ba'an Jesús winicob x'ixicob ch'oyolo' bʌ ti pejtelel lum. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Che' bʌ tsa' ñumi cha'p'ejl uxp'ejl q'uin, tsa' cha' ochi Jesús ti Capernaum. Tsa' ubinti ya'an ti otot. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Cabʌlob tsi' tempayob i bʌ c'ʌlʌl che' mach jocholix ba' mi' yochelob mi ti' ti' otot. Jesús tsi' subeyob i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tsa' tiliyob winicob woli bʌ i pʌyob tilel ba'an Jesús juntiquil winic mach bʌ anix i c'ʌjñibal i yoc i c'ʌb. Woli' ch'uyob tilel chʌntiquil winicob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Che' bʌ ma'anic tsa' mejli i c'otelob ba'an Jesús cha'an cabʌl winicob, tsi' toc jamʌyob i jol otot ti' chañelal Jesús. Che' bʌ tsa'ix i jamʌyob tsi' ju'sayob i wʌyib ba' ñolol jini mach bʌ anix i c'ʌjñibal i yoc i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Come Jesús tsi' ña'ta wolix i ñopob winicob, tsi' sube jini mach bʌ anix i c'ʌjñibal i yoc i c'ʌb: Calobil ñusʌbilix a mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ya' buchulob cha'tiquil uxtiquil sts'ijbayajob. Woliyob ti t'an ti' pusic'al: ");
INSERT INTO ctuBl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Chucoch che'i mi' cha'len t'an jini winic? Woli ti p'ajoñel. ¿Majqui mi mejlel i ñusan mulil? Jini jach Dios. Che' tsi' yʌlʌyob ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús tsi' bʌc' ña'ta ti' pusic'al chuqui woli' ña'tañob. Tsi' subeyob: ¿Chucoch che'i mi la' cha'len t'an ti la' pusic'al? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Baqui bʌ ñumen wocol mic suben jini c'am bʌ? ¿Ñumen wocol ba mic suben: “Ñusʌbilix a mul” o ñumen wocol ba mic suben: “Ch'ojyen, teche a wʌyib, cha'len xʌmbal”? ");
INSERT INTO ctuBl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero cha'an mi la' ña'tan an i p'ʌtʌlel i Yalobil Winic ilayi ti pañimil cha'an mi' ñusan mulil (tsi' sube jini c'am bʌ): ");
INSERT INTO ctuBl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mic subeñet: Ch'ojyen, teche a wʌyib, cucu ti a wotot. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tsa' bʌc' ch'ojyi. Tsi' teche i wʌyib. Tsa' loq'ui majlel ti' wut pejtelelob. Che' jini, tsa' toj sajtiyob i pusic'al ti pejtelelob. Tsi' tsictesayob i ñuclel Dios. Tsi' yʌlʌyob: Ma'anic ba' tsa' laj q'uele bajche' jini, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Che' bʌ tsa' loq'ui Jesús tsa' cha' majli ti' ti' colem ñajb. Pejtelel winicob tsi' tempayob i bʌ ba'an Jesús. Tsi' cʌntesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Che' woli ti xʌmbal majlel tsi' q'uele Leví, i yalobil Alfeo, buchul ba' mi' ch'ʌjmel tojoñel. Jesús tsi' sube: Tsajcañon, che'en. Tsa' wa'le Leví. Tsi' tsajca majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús tsa' majli ti' yotot Leví. Tsa' buchle ti' t'ejl mesa yic'ot xcʌnt'añob i cha'an. Ya' buchulob ja'el cabʌl xch'ʌm tojoñelob yic'ot xmulilob. Come cabʌl winicob tsi' tsajcayob tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jini fariseojob yic'ot xcʌntesa mandarob tsi' q'ueleyob woli ti we'el Jesús yic'ot xch'ʌm tojoñelob yic'ot xmulilob. Tsi' c'ajtibeyob xcʌnt'añob i cha'an: ¿Chucoch mi' cha'len we'el uch'el yic'ot xch'ʌm tojoñelob yic'ot xmulilob? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Che' bʌ tsi' yubi Jesús tsi' subeyob: Jini c'oc'o' bʌ mach yomobic ts'ʌcʌntel, cojach jini c'amo' bʌ. Ma'anic tsa' tiliyon cha'an mic pʌy jini toj bʌ winicob. Tsa' tiliyon cha'an mic pʌy xmulilob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Woliyob ti ch'ajb jini xcʌnt'añob i cha'an Juan yic'ot i cha'año' bʌ fariseojob. Tsa' tili i c'ajtibeñob Jesús: ¿Chucoch mi' cha'leñob ch'ajb jini xcʌnt'añob i cha'an Juan yic'ot i cha'año' bʌ fariseojob? ¿Chucoch ma'anic mi' cha'leñob ch'ajb xcʌnt'añob a cha'an? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús tsi' subeyob: ¿Mu' ba mejlel i cha'leñob ch'ajb xmel q'uiñob che' ya'to añob yic'ot jini winic woli bʌ ti ñujpuñijel? Che' ya' to an jini winic woli bʌ ti ñujpuñijel mach mejlicob ti ch'ajb. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tal to i yorajlel che' mi caj i pʌjyel majlel xñujpuñel. Ti jim bʌ ora mi caj i cha'leñob ch'ajb. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ma'anic majqui mi' c'ʌn tsijib pisil cha'an mi' lʌw tsucul bʌ i pislel. Mi che' tsi' mele mi' tsijlel majlel tsucul bʌ pisil ba'an jini tsiji' bʌ i lʌjwil jinto ñumen colem i tsijlemal. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Che' ja'el ma'anic majqui mi' yotsan tsijib vino ti tsucul bʌ i yajñib melbil bʌ i pʌchi. Mi tsi' yotsa jini vino mi' tojmel i yajñib. Mi' jilel jini vino, che' ja'el mi' jilel i yajñib. Yom mi' yotsʌntel tsijib vino ti tsiji' bʌ i yajñib, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ti jump'ejl q'uin che' mi' c'ajob i yo, tsa' ñumi majlel Jesús ba' pʌc'bil jam c'uxbil bʌ i wut. Che' woliyob ti xʌmbal majlel jini xcʌnt'añob i cha'an, tsa' caji i tuc'beñob c'uxbil bʌ i wut jam. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jini fariseojob tsi' subeyob Jesús: Awilan, ¿chucoch mi' cha'leñob chuqui tic'bil ti jini q'uin che' mi laj c'aj la co? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús tsi' subeyob: ¿Mach ba anic tsa' la' q'uele ti jun chuqui tsi' cha'le David che' bʌ tsi' yubi wocol? Tsi' yubi wi'ñal yic'ot i pi'ʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tsa' ochi ti' yotot Dios che' ya'an Abiatar ti' ye'tel ti c'ax ñuc bʌ motomaj. David tsi' c'uxu jini waj tsa' bʌ ajq'ui ti mesa. Tic'bil ti mandar cha'an ma'anic mi' c'uxob. Cojach motomajob mi mejlel i c'uxob. David tsi' yʌq'ueyob i c'ux i pi'ʌlob ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús tsi' subeyob ja'el: Aq'uebilob winicob x'ixicob jini q'uin che' mi laj c'aj la co. Jini q'uin cha'añʌch i wenlel winicob x'ixicob. Mach melbilobic winicob x'ixicob cha'an mi' yʌq'ueñob i ñuclel i q'uiñilel c'aj o. ");
INSERT INTO ctuBl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jini cha'an i Yalobil Winic i Yumʌch ja'el i q'uiñilel c'aj o, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tsa' cha' ochi Jesús ti sinagoga. Ya'an juntiquil winic tiquin bʌ i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Woli' wen q'uelob cha'an mi' ña'tañob mi muc'ʌch i lajmesan jini winic ti jini q'uin che' mi' c'ajob i yo, come yomob i jop'ben i mul. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús tsi' sube jini winic tiquin bʌ i c'ʌb: La' ilayi. Ch'ojyen, ochen ilayi ti ojlil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús tsi' c'ajtibeyob: ¿Baqui bʌ tic'bil ti melol ti jini q'uin che' mi laj c'aj la co? ¿Jim ba chuqui uts'at? ¿O jim ba chuqui jontol? ¿Tic'bil ba coltaya cha'an jini woli bʌ ti chʌmel? ¿O tic'bil ba tsʌnsa? che'en. Ñʌch'ʌl tsa' cʌleyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Mich' tsi' joy q'ueleyob Jesús, come ch'ijiyem tsi' yubi cha'an i tsʌtslelob i pusic'al. Tsi' sube jini winic: Sʌts'ʌ a c'ʌb, che'en. Tsi' sʌts'ʌ. Tsa' wen'esʌnti i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tsa' loq'uiyob majlel fariseojob. Tsi' temeyob i t'an yic'ot jini herodiañob ti' contra Jesús cha'an yomob i tsʌnsan. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús tsi' tʌts'ʌ i bʌ. Tsa' majli ti colem ñajb yic'ot xcʌnt'añob i cha'an. Bajc'ʌl winicob x'ixicob ch'oyolo' bʌ ti Galilea tsi' tsajcayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Bajc'ʌl ch'oyolo' bʌ ti Judea, yic'ot ti Jerusalén, yic'ot ti Idumea, yic'ot ti junwejl Jordán ja', yic'ot ti' joytilel Tiro yic'ot Sidón, tsa' tiliyob ba'an Jesús che' bʌ tsi' yubiyob pejtelel chuqui tsi' mele. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tsi' sube xcʌnt'añob cha'an mi' chajpʌbeñob barco cha'an ma'anic mi' ñet'ob, come cabʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Come Jesús tsa'ix i lajmesa cabʌlob. Jini cha'an pejtelel año' bʌ i c'amʌjel tsi' wersa lʌc'tesayob i bʌ, come yomob i tʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jini xibajob che' bʌ tsi' q'ueleyob, tsi' pʌc chocoyob i bʌ ti' tojel Jesús. Ti c'am bʌ t'an tsi' yʌlʌyob: Jatet i Yalobilet Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús tsi' wersa tiq'ui xibajob cha'an ma'anic mi' yʌc'ob ti cʌjñel. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ti wi'il Jesús tsa' letsi majlel ti wits. Tsi' pʌyʌyob tilel majqui yom i pʌy. Tsa' tiliyob ba'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesús tsi' wa'choco lajchʌntiquil cha'an mi' yajñelob yic'ot, cha'an ja'el mi' chocob majlel ti subt'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tsi' yʌq'ueyob i p'ʌtʌlel cha'an mi' lajmesañob xc'amʌjelob, cha'an mi' chocob loq'uel xibajob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jiñʌch i c'aba'ob jini lajchʌntiquil: Simón tsa' bʌ otsʌbenti i c'aba' Pedro; ");
INSERT INTO ctuBl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo i yalobil Zebedeo, Juan i yijts'in Jacobo tsa' bʌ otsʌbenti i cha'chajplel i c'aba' Boanerges, am bʌ i sujmlel: “Winicob mu' bʌ i cha'leñob c'am bʌ t'an bajche' chajc”; ");
INSERT INTO ctuBl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, yic'ot Felipe, yic'ot Bartolomé, yic'ot Mateo, yic'ot Tomás, yic'ot Jacobo i yalobil Alfeo; yic'ot Tadeo, yic'ot Simón jini cananista, ");
INSERT INTO ctuBl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yic'ot Judas Iscariote, jini tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra. Tsa' sujtiyob ti otot. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tsi' cha' tempayob i bʌ cabʌl winicob x'ixicob. Ma'anic tsa' mejliyob ti c'ux waj. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Che' bʌ tsi' yubiyob i pi'ʌlob Jesús, tsa' tiliyob cha'an mi' chucob come tsi' yʌlʌyob: Sojquem i jol, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero jini sts'ijbayajob loq'uemo' bʌ ti Jerusalén tsi' yʌlʌyob: Ochem Beelzebú ti' pusic'al. Ti' p'ʌtʌlel i yum xibajob mi' choc loq'uel xibajob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jini cha'an Jesús tsi' pʌyʌyob tilel. Tsi' pejcayob ti lajiya tac. Tsi' yʌlʌ: ¿Bajche' mi mejlel i choc loq'uel i bʌ Satanás? ");
INSERT INTO ctuBl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mi tsi' t'oxoyob i bʌ ti leto jini año' bʌ ti' wenta juntiquil yumʌl, mach mejlic ti jalijel i yumʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mi tsi' t'oxoyob i bʌ ti leto jini chumulo' bʌ ti jump'ejl otot, mach mejlicob ti jalijel. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Che'i ja'el mi tsi' bajñel contraji i bʌ Satanás ti leto mach mejlic ti jalijel. Che' jini mux i jilel. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ma'anic majqui mi' mejlel ti ochel ti' yotot p'ʌtʌl bʌ winic cha'an mi' chilben loq'uel i chubʌ'an mi ma'anic tsi' ñaxan cʌchʌ jini p'ʌtʌl bʌ winic. Che' mi' yujtel i cʌch mi mejlel i chilben loq'uel i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Isujm mic subeñetla mi caj i ñusʌbentelob pejtelel i mul winicob yic'ot pejtelel mu' bʌ i subob ti p'ajoñel. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero majqui jach mi' cha'len p'ajoñel ti' contra jini Ch'ujul bʌ Espíritu ma'anic ba' ora mi caj i ñusʌbentel i mul. An i mul ti pejtelel ora, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Come tsi' yʌlʌyob: An i xibʌjlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tsa' tiliyob i yijts'iñob Jesús yic'ot i ña'. Ya' wa'alob ti jumpat. Tsi' chocoyob majlel t'an ba'an Jesús cha'an mi' pʌyob loq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ya' buchulob winicob x'ixicob ti' joytilel Jesús. Tsi' subeyob: Awilan, ya'an a ña' ti jumpat yic'ot a wijts'iñob. Woli' pʌyetob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús tsi' subeyob: ¿Majqui c ña'? ¿Majqui quijts'iñob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Che' bʌ tsi' joy q'uele jini buchulo' bʌ ti' joytilel, Jesús tsi' subeyob: Awilan, c ña'etla quijts'iñetla. ");
INSERT INTO ctuBl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Come majqui jach mi' cha'len chuqui yom Dios, jiñʌch quijts'in, quijti'an, yic'ot c ña', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús tsa' cha' caji ti cʌntesa ti' ti' colem ñajb. Tsi' tempayob i bʌ bajc'ʌl winicob x'ixicob ba'an. Jini cha'an tsa' ochi Jesús ti buchtʌl ti barco am bʌ ti colem ñajb. Ya' añob ti lum winicob x'ixicob ti' t'ejl colem ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","An cabʌl chuqui tsi' cʌntesayob ti lajiya tac. Tsi' subeyob ti cʌntesa: ");
INSERT INTO ctuBl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ubinla: Awilan, jini xpac' tsa' majli i wejch'un pac'. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Che' woli i wejch'un majlel tsa' yajli ts'ita' ti bij. Tsa' tili te'lemut. Tsi' c'uxu. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yambʌ tsa' yajli ti xajlelol ba' ma'anic cabʌl lum. Ti ora tsa' pasi come ma'anic i lumil. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Che' bʌ tsa' chañ'a jini q'uin, ticʌw q'uin tsi' yubi. Tsa' tiqui come ma'anic i wi'. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yambʌ tsa' yajli ti ch'ixol. Che' bʌ tsa' coli jini ch'ix, tsi' tsʌnsa. Ma'anic tsi' yʌc'ʌ i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yambʌ tsa' yajli ti wen bʌ lum. Tsa' pasi, tsa' coli. Tsi' yʌc'ʌ i wut. Jujump'ejl pac' tsi' yʌc'ʌ i wut ti lujump'ejl i cha'c'al, ti uxc'al, ti joc'al, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús tsi' subeyob: Jini am bʌ i chiquin cha'an mi' yubin, la' i yubin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Baqui ora an ti' bajñelil, jini año' bʌ ti' joytilel yic'ot jini lajchʌntiquil tsi' c'ajtibeyob i sujmlel jini lajiya. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús tsi' subeyob: Tsa'ix aq'uentiyetla la' cʌn i sujmlel cha'an i yumʌntel Dios mach bʌ tsictiyemic ti yambʌ ora. Pero mic lu' subeñob ti lajiya tac jini mach bʌ ochemobic, ");
INSERT INTO ctuBl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","cha'an ma'anic mi' c'otel i wut jini woli bʌ i q'uelob, cha'an ma'anic mi' ch'ʌmbeñob isujm jini woli bʌ i yubiñob, ame i sutq'uiñob i bʌ, ame ñusʌbenticob i mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús tsi' subeyob: ¿Mach ba anic mi la' ch'ʌmben isujm jini lajiya? ¿Bajche' che' jini, mi mejlel la' ch'ʌmben isujm pejtelel lajiya tac? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jini xwejch'uya pac', jiñʌch mu' bʌ i puc jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jini año' bʌ ti' ti' bij jiñobʌch jini otsʌbil bʌ jini t'an ti' pusic'al. Che' mi' yubiñob jini t'an, ti ora mi' tilel Satanás i chilbeñob loq'uel jini t'an tsa' bʌ ochi ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Che' ja'el, jini wejch'ubil bʌ ti xajlelol jiñobʌch mu' bʌ i yubiñob jini t'an. Tijicñayob mi' bʌc' jac'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero ma'anic i wi' ti' pusic'al. Jini cha'an ts'i'ta jach mi' jalijelob. Come che' mi' tilel wocol yic'ot i tic'lʌntel cha'an jini t'an, ti ora mi' tejchel tile bixel bʌ i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jini wejch'ubil bʌ ti ch'ixol jiñobʌch mu' bʌ i yubiñob jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero i ye'tel ti jini pañimil, yic'ot i mulʌntel chubʌ'añʌl, yic'ot i mulʌntel chuqui tac yomob, mi' yochel ti' pusic'al. Mi' jisan jini t'an cha'an ma'anic mi' yʌc' i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jini wejch'ubil bʌ ti wen bʌ lum jiñobʌch mu' bʌ i yubiñob jini t'an. Mi' jac'ob. Mi' yʌc'ob i wut ti lujump'ejl i cha'c'al, ti uxc'al, ti jo'c'al. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Che' ja'el tsi' subeyob: ¿Mu' ba la' ch'ʌm tilel candil cha'an mi la' ñup' ti chiquib mi ti' yebal ch'ac? ¿Mach ba anic mi la' joc'chocon ti' joc'lib? ");
INSERT INTO ctuBl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Come ma'anic mucul tac bʌ mach bʌ anic mi' caj ti pʌstʌl. Pejtelel jini mach bʌ tsictiyemic mi caj i yʌjq'uel ti tsictiyel. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mi an majqui an i chiquin cha'an mi' yubin, la' i yubin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús tsi' subeyob ja'el: Chʌcʌ q'uele la' bʌ cha'an jini mu' bʌ la' wubin. Che' bajche' mi la' p'isben winicob che'ʌch mi caj la' wʌq'uentel. Ñumen cabʌl mi caj la' p'isbentel jatetla mu' bʌ la' wubin. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Come jini am bʌ i cha'an mu' to caj i yʌq'uentel yambʌ. Jini mach bʌ anic i cha'an mi caj i lu' chilbentel chuqui an i cha'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús tsi' yʌlʌ: Lajalʌch i yumʌntel Dios bajche' winic mu' bʌ i wejch'un pac' ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mi' cha'len wʌyel. Mi' ch'ojyel. Che'ʌch mi' ñumel ac'ʌlel yic'ot q'uiñil. Jini pac' mi' bots'an, mi' colel. Jini winic ma'anic mi' ña'tan bajche' mi' colel. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Come jini lum mi' yʌc' ti colel jini pac' ti' bajñel, ñaxan i yopol, wi'il i te'el, wi'il colem bʌ i wut ti' te'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Che' c'ʌñix i wut, ti ora jini winic mi' tsep ti machit che' i yorajlelix mi' lojtel i wut, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús tsi' yʌlʌ: ¿Chuqui yic'ot mi mejlel lac lajin i yumʌntel Dios? ¿Chuqui ti lajiya yom mi lac sub? ");
INSERT INTO ctuBl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lajalʌch bajche' i bʌc' mostaza. Ma'anic yambʌ pac' ti pañimil ñumen biq'uit bʌ bajche' jini mu' bʌ i wejch'untel ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Che' wejch'ubilix, mi' colel jinto mi' ñusan i chanlel pejtelel yan tac bʌ pimel. Mi' yʌc' colem tac i c'ʌb. Jini cha'an te'lemut mi' mel i c'u' ti' yʌxñʌlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tsi' subeyob i t'an Dios ti cabʌl lajiya tac che' bajche' jini. I p'isol jach tsi' subeyob bajche' tsa' mejli i yubiñob. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jini jach ti lajiya tsi' pejcayob. Che' añob ti' bajñel yic'ot xcʌnt'añob i cha'an tsi' subeyob pejtelel i sujmlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ti jini jach bʌ q'uin ti ic'ajel Jesús tsi' subeyob: La' c'axiconla ti junwejl ñajb, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tsi' subeyob majlel winicob x'ixicob. Tsi' pʌyʌyob majlel Jesús che' ya'to an ti barco. Ya'an ja'el yambʌ barco tac yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tsa' tejchi wen p'ʌtʌl bʌ ic'. Tsa' caji i wec'ulan ochel ja' ti barco jinto wolix ti bujt'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wʌyʌlix Jesús ti c'ʌnjol ti wi'ipat ti' mal barco. Tsa' tili i ñijcañob. Tsi' subeyob: Maestro, ¿mach ba wolic a p'is ti wenta mi caj lac jilel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tsa' ch'ojyi Jesús. Tsi' tiq'ui ic'. Tsi' sube colem ñajb: Ñʌjch'en, lajmen, che'en. Tsa' lajmi ic'. Ñʌch'ʌcña pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús tsi' subeyob: ¿Chucoch woliyetla ti bʌq'uen? ¿Chucoch ma'anic mi la' ñop? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wen cabʌl woliyob ti bʌq'uen. Tsi' c'ajtibeyob i bʌ: ¿Majqui jini? come jini ic' ja'el yic'ot jini colem ñajb mi' jac'ben i t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tsa' c'otiyob ti junwejl colem ñajb ti' lumal jini geraseñob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Che' bʌ tsa' loq'ui Jesús ti barco, juntiquil winic am bʌ i xibʌjlel tsa' loq'ui ba'an i yotlel tac ch'ujlelʌl. Tsa' tili i taj Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jini winic tsa' chumle ba'an i yotlel tac ch'ujlelʌl. Ma'anix majqui tsa' mejli i wen cʌch mi ti cadena. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Come cabʌl tsa' wen cʌjchi i yoc i c'ʌb ti cadena yic'ot ti' ñejt'ib. Ti ora tsi' bic'ti ts'oco jini cadena. Tsi' top'o i ñejt'ib. Ma'anic majch tsa' mejli i chʌn tic'. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ti pejtelel ora, ti q'uiñil ti ac'ʌlel, woli ti oñel ya' ti wits yic'ot ya' ba'an i yotlel ch'ujlelʌl tac. Cabʌl tsi' lowo i bʌ ti xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Che' bʌ tsi' ñajti q'uele Jesús, tsa' tili ti ajñel. Tsi' ch'ujutesa. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Wen c'am tsi' cha'le t'an ti oñel. Tsi' yʌlʌ: ¿Chuqui i ye'tel ma' tilel ba' añon Jesús, i Yalobilet bʌ Dios jini C'ax Ñuc bʌ? Mij c'ajtibeñet ti wocol t'an ti' c'aba' Dios mach a tic'lañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Come Jesús tsi' sube: Loq'uen ti jini winic, xiba, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús tsi' c'ajtibe: ¿Chuqui a c'aba'? che'en. Tsi' jac'ʌ: J c'aba' Legión come cabʌlon lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jini xiba tsi' c'ajtibe ti wocol t'an cha'an ma'anic mi' chocob loq'uel ti' lumal. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ya' ti wits woliyob ti buc'bal bajc'ʌl chitam. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pejtelel jini xibajob tsi' c'ajtibeyob ti wocol t'an: Subeñon lojon majlel ba'an chitam. La' ochicon lojon ti' mal, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús tsi' bʌc' ac'ʌ i t'an cha'an mi' yochel. Jini xibajob tsa' loq'uiyob. Tsa' ochiyob ti chitam. Ti ajñel jini chitam tsa' laj jubi ti xitil bʌ wits. Tsa' ochi ti colem ñajb. Tsa' laj chʌmi ti ja'. An che' bajche' jo'bajc' chitam. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jini xcʌnta chitamob ti ajñel tsa' majliyob ya' ti tejclum yic'ot ti xchumtʌl tac. Tsi' subuyob chuqui tsa' ujti. Tsa' loq'uiyob tilel winicob x'ixicob cha'an mi' q'uelob chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tsa' tiliyob ba'an Jesús. Tsi' q'ueleyob jini tsa' bʌ tic'lʌnti cha'an xiba che' chucbil i cha'an cabʌl xibajob. Ya' buchul, lʌpʌl i bujc, anix i pusic'al. Tsi' cha'leyob bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jini winicob tsa' bʌ i q'ueleyob tsi' subeyob chuqui tsa' tumbenti jini chucbil bʌ i cha'an xibajob yic'ot jini chitam tac. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tsa' caji i c'ajtibeñob Jesús ti wocol t'an cha'an mi' loq'uel majlel Jesús ti' lumalob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Che' bʌ tsa' ochi Jesús ti barco, jini winic tsa' bʌ tic'lʌnti cha'an xibajob tsi' c'ajtibe wocol t'an come yom ajñel yic'ot Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús ma'anic tsi' pʌyʌ. Tsi' sube: Cucu ti a wotot ba'an a pi'ʌlob. Subeñob chuqui tac ñuc tsi' melbeyet a Yum. Subeñob bajche' tsi' p'untayet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tsa' majli jini winic. Tsa' caji i puc t'an ya' ti Decápolis. Tsi' subu chuqui tac ñuc tsi' melbe Jesús. Tsa' toj sajtiyob i pusic'al ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Che' bʌ tsa' cha' c'axi Jesús ti junwejl ja' ti barco, tsi' tempayob i bʌ cabʌl winicob x'ixicob ti' joytilel. Ya'an Jesús ti' ti' colem ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tsa' tili juntiquil i yum sinagoga, i c'aba' Jairo. Che' bʌ tsi' q'uele Jesús, Jairo tsi' ñocchoco i bʌ ba'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tsi' c'ajtibe wocol t'an. Tsi' sube: Wolix ti chʌmel xch'oc bʌ calobil. La' ac'ʌ a c'ʌb ti' tojlel jini xch'oc cha'an mi' lajmel cha'an mi' colel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús tsa' majli yic'ot. Cabʌl winicob x'ixicob tsi' tsajcayob majlel. Tsi' joy ñet'eyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pero an juntiquil x'ixic mach bʌ anic tsa' wis tijq'ui i bec' i ch'ich'el lajchʌmp'ejl jab. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cabʌl wocol tsi' yubi cha'an cabʌl sts'ʌcayajob. Tsi' laj jisa pejtelel i chubʌ'an cha'an i tojol i ts'ʌcʌntel. Ma'anic tsa' wis c'oc'a, pero tsa' utsi caji i c'amʌjel. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Che' bʌ tsi' yubi chuqui tsi' mele Jesús, tsa' tili jini x'ixic ti' pat Jesús ba' tempʌbilob winicob. Tsi' tʌlbe i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jini x'ixic tsi' yʌlʌ ti' pusic'al: Mi tsa jach c tʌlbe i pislel, mi caj j c'oc'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ti ora jach tsa' tijq'ui i bec' i ch'ich'el. Tsi' yubi ti' bʌc'tal lajmenix i c'amʌjel. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yujil Jesús tsa' c'ʌjñi i p'ʌtʌlel. Tsi' bʌc' sutq'ui i bʌ ba' joyol i cha'an winicob x'ixicob. Tsi' c'ajtibeyob: ¿Majqui tsi' tʌlʌ c pislel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jini xcʌnt'añob i cha'an tsi' jac'ʌyob: Awilan woli' joy ñet'et winicob x'ixicob. ¿Chucoch ma' c'ajtibeñon lojon majqui tsi' tʌlʌyet? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús tsi' can q'uele winicob x'ixicob cha'an mi' q'uel majqui tsi' tʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tsa' tili jini x'ixic, tsiltsilña ti bʌq'uen, come yujil chuqui tsi' mele Jesús ti' tojlel. Tsi' ñocchoco i bʌ ti' tojel Jesús. Tsi' sube pejtelel i sujmlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús tsi' sube: Calobil, tsa' lajmiyet cha'an tsa' ñopoyon. Cucu ti' ñʌch'tilel a pusic'al. Ajñen ti a c'oc'lel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Che' woli to ti t'an, tsa' tili cha'tiquil uxtiquil winicob loq'uemo' bʌ ti' yotot i yum sinagoga. Tsi' yʌlʌyob: Chʌmenix xch'oc bʌ a walobil. ¿Chucoch wola' chʌn mʌcben q'uin jini Maestro? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero che' bʌ tsi' yubi Jesús chuqui tsi' yʌlʌyob, tsi' sube i yum sinagoga: Mach a cha'len bʌq'uen, chʌn ñopo ti a pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús tsi' tiq'ui winicob x'ixicob cha'an ma'anic mi' tsajcañob majlel. Jini jach tsi' pʌyʌ majlel Pedro yic'ot Jacobo yic'ot Juan i yijts'in Jacobo. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsa' tili ti' yotot i yum sinagoga. Tsi' q'uele ju'ucñayob ti uq'uel winicob x'ixicob. C'am woliyob ti uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Che' bʌ tsa' ochi, tsi' c'ajtibeyob: ¿Chucoch ju'ucñayetla? ¿Chucoch woliyetla ti uq'uel? Jini xch'oc mach chʌmenic. Woli ti wʌyel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jini winicob x'ixicob tsi' tse'tayob. Pero Jesús tsi' chocoyob loq'uel ti pejtelel. Tsi' pʌyʌ i tat i ña' jini xch'oc yic'ot jini año' bʌ yic'ot. Tsa' ochi ba' ñolol jini xch'oc. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tsi' chucbe i c'ʌb xch'oc. Tsi' sube: Talita cumi, che'en. Mi' yʌl ti lac t'an: Xch'oc, mic subeñet, ch'ojyen. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ti ora tsa' ch'ojyi jini xch'oc. Tsi' cha'le xʌmbal come anix lajchʌmp'ejl i jabilel. Ti junyajlel tsa' toj sajtiyob i pusic'al ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús tsi' wersa subeyob cha'an ma'anic mi' subeñob i pi'ʌlob mi juntiquilic. Tsi' subeyob cha'an mi' we'sañob jini xch'oc. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús tsa' loq'ui ya'i. Tsa' tili ti' lumal. Jini xcʌnt'añob i cha'an tsi' tsajcayob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ti' q'uiñilel c'aj o Jesús tsa' caji ti cʌntesa ti sinagoga. Tsa' toj sajti i pusic'al cabʌlob che' bʌ tsi' yubibeyob i t'an. Tsi' yʌlʌyob: ¿Baqui tsi' taja pejtelel jini? ¿Chuqui i ña'tʌbal tsa' bʌ aq'uenti? Wen ñuc i ye'tel mu' bʌ i mel ti' c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Mach ba jinic xjuc'te', i yalobil María, i yʌscun Jacobo yic'ot José yic'ot Judas yic'ot Simón? ¿Mach ba wʌ'ic an i yijti'añob la quic'ot? che'ob. Tsa' caji i mich'leñob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús tsi' subeyob: Mi' q'uejlel ti ñuc pejtel x'alt'an. Pero ma'anic mi' q'uejlel ti ñuc ya' ti' lumal yic'ot ti' tojlel i pi'ʌlob yic'ot ti' yotot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma'anic tsa' mejli i mel ñuc bʌ i ye'tel ya'i. Tsa jach i yʌc'ʌ i c'ʌb ti cha'tiquil uxtiquil xc'amʌjelob. Tsi' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ch'ijiyem i pusic'al Jesús come ma'anic tsi' ñopoyob. Tsa' ñumi majlel ti tejclum tac ti cʌntesa. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tsi' pʌyʌ tilel jini lajchʌntiquil. Tsa' caji i chocob majlel ti cha'cha'tiquil. Tsi' yʌq'ueyob i p'ʌtʌlel ti' contra xibajob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tsi' yʌq'ueyob mandar cha'an mach yomic chuqui mi' ch'ʌmob majlel ti bij, cojach i te' ti xʌmbal. Ma'anic mi' ch'ʌmob majlel chim, mi waj, mi taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tsi' subeyob cha'an mi' lʌpob i cacte'. Mach yomic mi' lʌpob cha'p'ejl i bujc. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tsi' subeyob: Baqui jach mi la' wochel ti otot, jijlenla ya'i jinto mi la' loq'uel majlel ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Baqui jach ma'anic mi' pʌyetla ochel, mi ma'anic mi' jac'beñetla, tijcanla loq'uel i ts'ubeñal la' woc che' mi la' majlel, cha'an mi' q'uelob mach wenic bajche' tsi' meleyob. Isujm mic subeñetla, ñumen wocol mi caj i yubiñob winicob x'ixicob ti jini tejclum ti' yorajlel tojmulil bajche' jini ch'oyolo' bʌ ti Sodoma yic'ot ti Gomorra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tsa' majliyob jini xcʌnt'añob. Tsi' subuyob t'an cha'an mi' cʌyob i mul winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tsi' chocoyob loq'uel cabʌl xibajob. Tsi' bombeyob aceite cabʌl xc'amʌjelob. Tsi' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jini rey Herodes tsi' yubi t'an cha'an Jesús, come tsa' wen cʌjni i c'aba' Jesús. Woli' yʌlob: Tsa'ix tejchi ch'ojyel ba'an chʌmeño' bʌ jini Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'. Jini cha'an cabʌl mi' tsictiyel i p'ʌtʌlel ti' ye'tel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yaño' bʌ tsi' lon alʌyob: Jiñʌch Elías, che'ob. Yaño' bʌ tsi' lon alʌyob: Jiñʌch x'alt'an che' bajche' x'alt'añob ti wajali, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Che' bʌ tsi' yubi jini t'an Herodes tsi' yʌlʌ: Jiñʌch Juan tsa' bʌ c set' t'ojbe loq'uel i bic'. Tsa'ix ch'ojyi loq'uel ba'an chʌmeño' bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Come Herodes tsi' choco majlel winic cha'an mi' chuc Juan. Tsi' yotsa Juan ti cárcel cha'an ti' t'an Herodías, i yijñam Felipe, come Herodes tsi' pʌybe i yijñam i yijts'in. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan tsi' sube Herodes: Tic'bil ti mandar ma' pʌyben i yijñam a wijts'in. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jini cha'an Herodías tsi' loto i mich'ajel ti' pusic'al ti' contra Juan. Yom i tsʌnsan. Ma'anic tsa' mejli. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Come Herodes tsi' bʌc'ña Juan come yujil tojʌch, yujil ch'ujulʌch. Tsi' cʌnta ti uts'at. Che' bʌ tsi' yubibe i t'an Juan cabʌl tsa' caji ti t'an i pusic'al Herodes, pero yom i yubiben i t'an Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tsa' tili i yorajlel cha'an mi' mel q'uin Herodes ti' q'uiñilel i jabil. Tsi' pʌyʌ tilel yumʌlob yic'ot capitañob yic'ot jini wen chumulo' bʌ ya' ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Che' bʌ tsa' ochi i yalobil Herodías, tsi' cha'le son. Tsa' toj ñuc'a i pusic'al Herodes yic'ot jini año' bʌ ti mesa. Jini rey tsi' sube jini xch'oc: C'ajtibeñon chuqui jach a wom. Mi caj cʌq'ueñet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tsi' wersa wa'choco i t'an. Tsi' sube: Chuqui jach ma' c'ajtibeñon mi caj cʌq'ueñet c'ʌlʌl ti yojlil c yumʌntel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tsa' loq'ui majlel xch'oc, tsi' c'ajtibe i ña': ¿Chuqui yom mij c'ajtiben? che'en. I ña' tsi' sube: I jol Juan mu' bʌ i yʌc' ch'ʌmja', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tsa' bʌc' ochi ba'an jini rey. Tsi' sube: Ti jini jach bʌ ora com ma' pit aq'ueñon ti colem latu i jol Juan mu' bʌ i yʌc' ch'ʌmja', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wen ch'ijiyem i pusic'al jini rey, come mach yomic i bajñel ñusan i t'an cha'an tsa'ix i wersa wa'choco i t'an ti' tojlel xq'uiñijelob ti mesa. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ti ora jini rey tsi' choco majlel soldado. Tsi' yʌc'ʌ mandar cha'an mi' ch'ʌjmel tilel i jol Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsa' majli jini soldado. Tsi' set' t'ojbe loq'uel i bic' Juan ya' ti cárcel. Tsi' pit ch'ʌmʌ tilel i jol ti colem latu. Tsi' yʌq'ue jini xch'oc. Jini xch'oc tsi' yʌq'ue i ña'. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Che' bʌ tsi' yubiyob xcʌnt'añob i cha'an Juan, tsa' tiliyob, tsi' ch'ʌmʌyob majlel i bʌc'tal. Tsi' ñolchocoyob ti mucoñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jini chocbilo' bʌ majlel ti subt'an tsa' cha' tiliyob ba'an Jesús. Tsi' subeyob pejtelel chuqui tsi' cha'leyob yic'ot pejtelel chuqui tsi' cʌntesayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús tsi' subeyob: Conla ti lac bajñelil ti jochol bʌ lum cha'an mi laj c'aj la co ts'ita', che'en. Come an cabʌl tilel ñumelob jax bʌ. Ma'anic tsi' tajbeyob i q'uiñilel cha'an mi' cha'leñob we'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tsa' majliyob ti barco c'ʌlʌl ti jochol bʌ lum ti' bajñelilob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cabʌl winicob x'ixicob tsi' q'ueleyob Jesús yic'ot xcʌnt'añob che' bʌ tsa' majliyob. Tsi' cʌñʌyob. Jini cha'an ti ajñel tsa' majliyob ti' yoc, ch'oyolo' bʌ ti pejtelel tejclum tac ti' joytilel. Ñaxan tsa' c'otiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tsa' loq'ui ti barco Jesús. Tsi' q'uele bajc'ʌl winicob x'ixicob. Tsi' p'untayob come lajalob bajche' tiñʌme' mach bʌ anic xcʌntaya i cha'añob. An cabʌl chuqui tsa' caji i cʌntesañob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Che' wolix ti bʌjlel q'uin, tsa' tiliyob jini xcʌnt'añob i cha'an ba'an Jesús. Tsi' yʌlʌyob: Jochol jini lum. Wolix ti bʌjlel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chocoyob majlel cha'an mi' majlelob ti xchumtʌl tac yic'ot ti tejclum tac ti' joytilel cha'an mi' mʌñob waj, come ma'anic chuqui mi' c'uxob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús tsi' subeyob: Aq'ueñob jatetla chuqui mi' c'uxob, che'en. Tsi' c'ajtibeyob: ¿A wom ba mic majlel lojon cha'an mic mʌn lojon lujunc'al denario waj cha'an mi la cʌq'ueñob i c'ux? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús tsi' c'ajtibeyob: ¿Jayq'uejl waj an la' cha'an? Cucula, q'uelela, che'en. Che' yujilob, tsi' subeyob: Jo'q'uejl yic'ot cha'cojt chʌy, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús tsi' yʌq'ueyob mandar cha'an mi' subeñob buchtʌl ti pejtelelob ti jujunmojt ti yʌjyʌx bʌ jam. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tsa' buchleyob ti jujunmojt ti jo'jo'c'al tac yic'ot ti lujump'ejl i yuxc'al tac. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús tsi' ch'ʌmʌ jini jo'q'uejl waj yic'ot cha'cojt chʌy. Che' bʌ tsi' letsa i wut ti panchan tsi' cha'le oración. Tsi' xet'e jini waj. Tsi' yʌq'ue xcʌnt'añob i cha'an, cha'an mi' pucbeñob winicob x'ixicob. Tsi' xut'u ja'el jini cha'cojt chʌy cha'an mi' laj aq'uentelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ti pejtelelob tsi' cha'leyob we'el. Tsa' ñaj'ayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tsi' lotoyob lajchʌmp'ejl chiquib but'ul ti' xejt'il waj yic'ot chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jo'p'ejl mil winicob tsi' c'uxuyob waj. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesús tsi' bʌc' sube ochel xcʌnt'añob i cha'an ti barco cha'an ñaxan mi' majlelob ti Betsaida ti junwejl ja'. Tsa' bajñel cʌle i subeñob sujtel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Che' bʌ tsa' ujti i chocob majlel, tsa' letsi majlel ti bujtʌl cha'an mi' pejcan Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Che' ti ic'ajel, ya'an barco ti ojlil colem ñajb. Ya'an Jesús ti lum ti' bajñelil. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tsi' q'uele wocol woli' nijcañob majlel barco jini xcʌnt'añob come jini ic' woli' cujob. Che' yomix sʌc'an tsa' tili Jesús ba' añob. Woli ti xʌmbal tilel ti pam ja'. Tsi' ña'ta Jesús i ñusañob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Che' bʌ tsi' q'ueleyob woli ti xʌmbal Jesús ti pam ja' jini xcʌnt'añob tsi' lon ña'tayob i ch'ujlel jach winic. C'am tsi' cha'leyob oñel. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Come ti pejtelel xcʌnt'añob tsi' q'ueleyob. Tsi' wen cha'leyob bʌq'uen. Pero Jesús tsi' bʌc' pejcayob. Tsi' subeyob: Tijicñesan la' pusic'al. Come joñoñʌch, mach la' cha'len bʌq'uen, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tsa' ochi Jesús ba' añob ti barco. Tsa' lajmi ic'. Ti junyajlel tsa' toj sajtiyob i pusic'al xcʌnt'oñob cha'an bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Come maxto anic tsi' ch'ʌmbeyob isujm chuqui tsa' pʌsbentiyob ti waj, come tsʌtsob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Che' bʌ tsa' c'axiyob ti junwejl ja', tsa' c'otiyob ti lum ya' ti Genesaret. Tsi' cʌchʌyob barco. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Che bʌ tsa' loq'ui Jesús ti barco, ti ora tsi' cʌñʌyob jini winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ti ajñel tsa' majliyob ti pejtelel lum ti' joytilel. Baqui jach tsa' ñumi Jesús tsi' ch'uyuyob tilel xc'amʌjelob ti' wʌyib che' bʌ tsi' yubiyob ya'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Baqui jach tsa' ochi, mi ti alʌ tejclum mi ti colem tejclum mi ti xchumtʌl tac, tsa' tiliyob winicob i ñolchocoñob xc'amʌjelob ti calle. Tsi' c'ajtibeyob ti wocol t'an, come yomob i tʌlben anquese jini jach i ti' i pislel Jesús. Pejtelel tsa' bʌ i tʌlʌyob tsa' c'oc'ayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tsi' tempayob i bʌ fariseojob yic'ot cha'tiquil uxtiquil sts'ijbayajob ch'oyolo' bʌ ti Jerusalén. Tsa' tiliyob ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tsi' q'ueleyob an xcʌnt'añob i cha'an mu' bʌ i c'uxob waj che' mach pocbilic i c'ʌb. Tsi' ts'a'leyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Come fariseojob yic'ot pejtelel judíojob mi' yesmañob i subal i ñojte'el. Jini cha'an, ma'anic mi' cha'leñob we'el mi ma'anic mi' pocob i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Che' mi' sujtelob ti choñonibʌl tac, mi ma'anic mi' pocob i bʌ, ma'anic mi' cha'leñob we'el. An to cabʌl i subal i ñojte'el mu' bʌ i bej esmañob. I tilelʌch mi' pocob tsima yic'ot p'ejt, yic'ot latu melbil bʌ ti tsucu taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jini fariseojob yic'ot sts'ijbayajob tsi' c'ajtibeyob: ¿Chucoch mi' ñusʌbeñob i subal lac ñojte'el jini xcʌnt'añob a cha'an? ¿Chucoch mi' cha'leñob we'el che' bibi'ob i c'ʌb? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús tsi' subeyob: Cha'p'ejax la' pusic'al. Isujm chuqui tsi' subu Isaías che' bʌ tsi' tajayetla ti t'an che' bajche' ts'ijbubil: “Ti' yej jach mi' subob c ñuclel jini winicob x'ixicob, pero ti' pusic'al ma'anic mi' lʌc'oñoñob. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lolom jach mi' ch'ujutesañoñob, come jiñʌch i mandar tac winicob woli bʌ i cʌntesañob”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Come mi la' cʌyben i mandar Dios. Mi la' wen ñop i subal la' ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mi la' wʌl uts'at mi la' ñusʌben i mandar Dios cha'an mi la' wen ñop i subal la' ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés tsi' yʌlʌ: “Q'uele ti ñuc a tat a ña'. Jini mu' bʌ i p'aj i tat i ña' mi caj i wersa chʌmel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero jatetla mi la' wʌl uts'at mi subeñob i tat i ña' ma'anic chuqui mi mejlel i yʌq'ueñob cha'an mi' coltañob, come Corbán i chubʌ'an mi' yʌlob. (Jini Corbán mi' yʌl ti lac t'an: Jiñʌch mu' bʌ cʌq'uen Dios.) ");
INSERT INTO ctuBl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Che' jini, ma'anic mi la' wʌq'ueñob i coltan i tat i ña'. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mi la' jisʌben i c'ʌjñibal i t'an Dios cha'an jach i subal la' ñojte'el mu' bʌ la' cha' suben la' walobilob. An cabʌl chuqui leco mi la' cha'len che' bajche' jini, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús tsi' cha' pʌyʌ tilel pejtelel winicob x'ixicob. Tsi' subeyob: Ñich'tañon ti la' pejtelel. Ch'ʌmbenla isujm, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ti pañimil ma'anic chuqui c'uxbil bʌ mu' bʌ i bibesʌben i pusic'al winicob. Jini mu' bʌ i loq'uel ti' pusic'al winic, jiñʌch mu' bʌ i bibesan. Majqui jach an i chiquin cha'an mi yubin, la' i yubin. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús tsi' cʌyʌ winicob x'ixicob. Che' bʌ tsa' ochi ti otot, jini xcʌnt'añob i cha'an tsi' c'ajtibeyob i sujmlel jini lajiya. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús tsi' c'ajtibeyob: ¿Jatetla ja'el, mach ba anic mi la' ch'ʌmben isujm? ¿Mach ba anic mi la' ña'tan ma'anic mi' bibesan winic jini mu' tac bʌ i yochel ti' mal? ");
INSERT INTO ctuBl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Come ma'anic mi' yochel ti' pusic'al, jini jach ti' ñʌc'. Ñumel jach mi' ñumel, che'en Jesús. Che'ʌch tsi' cʌntesayob sʌc pejtelel i bʌl lac ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús tsi' yʌlʌ: Jini mu' bʌ i loq'uel ti winic mi' bibesan winic. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Come ch'oyol ti' pusic'al winicob x'ixicob mi' tilel cabʌl jontol bʌ i ña'tʌbal, yic'ot i ts'i'lel, yic'ot i tajol i yixic, yic'ot tsʌnsa, ");
INSERT INTO ctuBl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yic'ot xujch', yic'ot i mulʌntel chubʌ'añʌl, yic'ot jontolil, yic'ot lotiya, yic'ot i bibi'lel, yic'ot tsʌytsʌyna bʌ i pusic'al cha'an i wenlel yaño' bʌ, yic'ot p'ajoñel, yic'ot i p'isol i bʌ ti ñuc yic'ot i tontojlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Come ch'oyol ti' pusic'al winicob mi' tilel pejtelel jini jontolil. Mi' bibesan winicob x'ixicob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tsa' wa'le Jesús, tsa' loq'ui majlel c'ʌlʌl ti' lumal Tiro. Tsa' ochi ti otot. Mach yomic mi' ña'tañob mi ya'an, pero ma'anic ba' tsa' mejli ti mucul ajñel. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Juntiquil xch'oc an i xibʌjlel. I ña' jini xch'oc tsi' yubi ya'an Jesús. Tsa' bʌc' tili i ñocchocon i bʌ ti' tojel. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jini x'ixic griega, ch'oyol ti Sirofenicia. Tsi' c'ajtibe wocol t'an cha'an mi' choc loq'uel xiba ti' yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús tsi' sube: La' ñaxan we'sʌntic alobob, come mach uts'atic mi lac chilben i waj alobob cha'an mi lac chocben ts'i', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jini x'ixic tsi' jac'ʌ: Melelʌch c Yum. Pero jini ts'i' ti' yebal mesa mi' c'ux i xujt'il i waj alobob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús tsi' sube: Cha'an jini t'an tsa' bʌ a subeyon mi mejlel a majlel. Tsa'ix loq'ui xiba ti a walobil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Che' bʌ tsa' c'oti x'ixic ti' yotot tsi' taja i yalobil ñolol ti' wʌyib. Loq'uemix jini xiba. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús tsa' cha' loq'ui ti lum i c'aba' Tiro. Che' bʌ tsa' ñumi ti Sidón, tsa' c'oti ti Galilea ñajb. Woli' xʌn ñumel Decápolis. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Winicob x'ixicob tsi' pʌyʌyob tilel juntiquil xcojc. Wocol mi' cha'len t'an. Tsi' c'ajtibeyob cha'an mi' yʌc' i c'ʌb ti' jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús tsi' pʌyʌ tilel ti' bajñel, parte an winicob x'ixicob. Tsi' yotsa i yal i c'ʌb ti' chiquin. Tsi' cha'le tujb. Tsi' tʌlbe i yac'. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesús tsi' letsa i wut ti panchan, c'am tsi' jac'ʌ i yo. Tsi' sube: Efata, che'en, mu' bʌ i yʌl ti lac t'an: La' jajmic. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tsa' jajmi i chiquin winic. Tsa' jijti i yac'. Toj tsa' loq'ui i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús tsi' wersa subeyob cha'an ma'anic mi' subeñob yaño' bʌ mi juntiquilic. Ti jujunyajl che' bʌ tsi' tiq'uiyob, ñumen tsi' pucuyob t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","C'ax cabʌl tsa' toj sajtiyob i pusic'al winicob x'ixicob. Tsi' yʌlʌyob: Uts'at pejtelel chuqui tac tsi' mele. Mi' yʌq'uen i yubin t'an jini xcojc. Mi' yʌq'uen i cha'len t'an jini x'uma', che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti yambʌ q'uin, che' cha' tempʌbil bajc'ʌl winicob x'ixicob, che' ma'anic chuqui mi' c'uxob, Jesús tsi' pʌyʌ tilel xcʌnt'añob i cha'an. Tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Mic p'untan jini winicob x'ixicob, come uxp'ejlix q'uin wʌ' añob quic'ot. Ma'anic chuqui mi' c'uxob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Muq'uic c chocob majlel ti' yotot che' wi'ñayobix, mi' c'un'añob ti bij, come ojlil ch'oyolob ti ñajtʌl, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jini xcʌnt'añob i cha'an tsi' c'ajtibeyob: ¿Baqui mi mejlel i tajtʌl waj ilayi ti jochol bʌ lum cha'an mi' we'sʌntelob? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús tsi' c'ajtibeyob: ¿Jayq'uejl waj an la' cha'an? che'en. Tsi' subeyob: Wucq'uejl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesús tsi' sube winicob x'ixicob cha'an mi' buchtʌlob ti lum. Tsi' ch'ʌmʌ jini wucq'uejl waj. Che' bʌ tsi' sube Dios wocolix i yʌlʌ, tsi' xet'e. Tsi' yʌq'ue xcʌnt'añob i cha'an, cha'an mi' pucbeñob winicob x'ixicob. Jini xcʌnt'añob tsi' yʌq'ueyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","An i cha'añob ja'el ts'ita' chʌy. Jesús tsi' cha'le oración. Tsi' subeyob cha'an mi yʌq'ueñob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tsi' cha'leyob we'el. Tsa' ñaj'ayob. Tsi' lotoyob i xujt'il, wucp'ejl colem chiquib but'ul. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","An che' bajche' chʌmp'ejl mil tsa' bʌ i c'uxuyob. Ti wi'il Jesús tsi' subeyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tsa' bʌc' ochi ti barco yic'ot xcʌnt'añob i cha'an. Tsa' majli ya' ti Dalmanuta. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jini fariseojob tsa' bʌ tiliyob tsa' caji i contrajiñob ti t'an. Tsi' c'ajtibeyob Jesús cha'an mi' pʌsbeñob i yejtal i p'ʌtʌlel ti panchan. Che'i tsi' yilʌbeyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","C'am tsi' jac'ʌ i yo Jesús. Tsi' yʌlʌ: ¿Chucoch yomob i q'uel i yejtal c p'ʌtʌlel jini año' bʌ ti pañimil wʌle? Isujm mic subeñetla, ma'anic mi caj i yʌq'uentelob i q'uel i yejtal c p'ʌtʌlel jini winicob año' bʌ ti pañimil wʌle, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús tsi' cʌyʌyob. Tsa' cha' ochi ti barco. Tsa' c'axi ti junwejl ja'. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tsa' ñajʌyi i ch'ʌmob tilel waj. Ya' junq'uejl jach an i waj ti barco. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús tsi' subeyob: Chʌcʌ q'uele la' bʌ cha'an i levadura fariseojob yic'ot i levadura Herodes, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tsa' caji i pejcañob i bʌ. Tsi' yʌlʌyob: Ma'anic lac waj, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yujil Jesús chuqui woli' yʌlob. Tsi' subeyob: ¿Chucoch woliyetla ti t'an cha'an ma'anic la' waj? ¿Mach ba anic mi la' ña'tan? ¿Mach ba anic mi la' ch'ʌmben isujm? ¿Tsʌts to ba la' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","An la' wut. ¿Mach ba anic mi la' q'uel? An la' chiquin. ¿Mach ba anic mi la' wubin? ¿Mach ba c'ajalic la' cha'an? ");
INSERT INTO ctuBl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Che' bʌ tsac xet'e jini jo'q'uejl waj cha'an jo'p'ejl mil, ¿jayp'ejl chiquib but'ul ti' xujt'il tsa' la' loto? che'en. Tsi' subeyob: Lajchʌmp'ejl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Che' wucq'uejl waj cha'an chʌmp'ejl mil, ¿jayp'ejl colem chiquib but'ul ti' xujt'il tsa' la' loto? che'en. Tsi' subeyob: Wucp'ejl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús tsi' subeyob: ¿Maxto ba anic mi la' ch'ʌmben isujm? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ya' tsa' c'oti Jesús ti Betsaida. Winicob tsi' pʌyʌyob tilel xpots' ba'an Jesús. Tsi' c'ajtibeyob ti wocol t'an cha'an mi' tʌl jini xpots'. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús tsi' chucbe i c'ʌb jini xpots'. Tsi' pʌyʌ loq'uel ti tejclum. Tsi' tujbʌbe i wut. Tsi' yʌc'ʌ i c'ʌb ti jini xpots'. Tsi' c'ajtibe mi an chuqui woli' q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jini xpots' tsi' letsa i wut. Tsi' sube: Mij q'uel winicob che' yilalob bajche' te', woliyob ti xʌmbal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","26","Jesús tsi' cha' ac'ʌ i c'ʌb ti' wut. Tulul i wut tsa' caji i q'uel pañimil. Cha' c'oq'uix. Ñajt tsa' c'oti i wut. Wen tsiquil tsi' queleyob ti pejtelelob. Jesús tsi' choco majlel ti' yotot. Tsi' sube: Mach ma' wochel ti tejclum, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tsa' majli Jesús yic'ot xcʌnt'añob i cha'an. Tsa' ñumiyob ti tejclum tac ya' ti Cesarea Filipo. Che' añob to ti bij, Jesús tsi' c'ajtibe xcʌnt'añob i cha'an: ¿Majquiyon mi' yʌlob winicob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tsi' subeyob: Ojlil mi' yʌlob Juanet tsa' bʌ i yʌc'ʌ ch'ʌmja'. Yaño' bʌ mi' yʌlob Elíaset. Yaño' bʌ mi' yʌlob juntiquil x'alt'añet, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús tsi' c'ajtibeyob: Jixcu jatetla, ¿majquiyon mi la' wʌl? che'en. Pedro tsi' sube: Jatet Cristojet, jini yajcʌbil bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero Jesús tsi' wersa tiq'uiyob cha'an ma'anic mi' subeñob winicob mi juntiquilic. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús tsa' caji i cʌntesañob. Tsi' yʌlʌ wersa mi' yubin cabʌl wocol i Yalobil Winic, mi' ts'a'lentel cha'an xñoxob año' bʌ i ye'tel yic'ot ñuc bʌ motomajob yic'ot sts'ijbayajob. Mi' tsʌnsʌntel. Mi' ch'ojyel ti yuxp'ejlel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wen tsiquil i sujmlel i t'an Jesús tsa' bʌ i subeyob. Jini cha'an Pedro tsi' pʌyʌ majlel. Tsa' caji i tic'. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús tsi' sutq'ui i bʌ i q'uel xcʌnt'añob i cha'an. Tsa' caji i tic' Pedro. Jesús tsi' sube: Tʌts'ʌ a bʌ ba' añon Satanás, come ma'anic ma' ch'ʌmben isujm chuqui yom Dios, cojach ma' ch'ʌmben isujm chuqui yom winicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús tsi' pʌyʌ tilel tempʌbilo' bʌ winicob x'ixicob yic'ot xcʌnt'añob i cha'an. Tsi' subeyob: Mi an majqui yom i tsajcañon, la' i len cʌy chuqui yom i bajñel pusic'al. La' i ch'ʌm i cruz. La' i tsajcañon. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Majqui jach yom i bajñel cʌntan i ch'ujlel mi caj i sʌt. Jini mu' bʌ i yʌc' i ch'ujlel cha'añon yic'ot cha'an jini wen t'an mi caj i cʌntan. ");
INSERT INTO ctuBl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Come chuqui mi' taj winic mi tsi' lon ch'ʌmʌ pejtelel pañimil pero mi tsi' sʌtʌ i ch'ujlel? ");
INSERT INTO ctuBl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Chuqui mi mejlel i yʌc' winic cha'an mi' cha' taj i ch'ujlel che' tsa'ix i sʌtʌ? ");
INSERT INTO ctuBl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Majqui jach mi' cha'len quisin cha'añon yic'ot cha'an c t'an ti' tojlel winicob x'ixicob año' bʌ i ts'i'lel yic'ot i jontolil, i Yalobil Winic ja'el mi caj i cha'len quisin cha'an jini winic che' mi' tilel ti' ñuclel i Tat yic'ot jini ch'ujul bʌ ángelob. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús tsi' subeyob: Isujm mic subeñetla, lamital ili wa'alo' bʌ ma'anic mi caj i chʌmelob jinto mi' q'uelob i yumʌntel Dios che' mi' tilel ti' p'ʌtʌlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Che' ñumenix wʌcp'ejl q'uin Jesús tsi' pʌyʌ majlel Pedro yic'ot Jacobo yic'ot Juan. Tsi' toj'esayob majlel ti' bajñelob c'ʌlʌl ti chan bʌ wits. Tsa' yʌjñi Jesús ti' wutob i pi'ʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tsa' sʌc'a i pislel, ts'ʌylaw i sʌclel che' bajche' i ña'al tsʌñal. Ma'anic ti pañimil chuqui mi mejlel i sʌq'uesan bajche' jini. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tsa' tsictiyiyob Elías yic'ot Moisés. Woliyob ti t'an yic'ot Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro tsi' sube Jesús: Maestro, uts'at che' wʌ' añonla ilayi. La' c mel lojon uxp'ejl lejchempat, jump'ejl cha'añet, jump'ejl cha'an Moisés, jump'ejl cha'an Elías, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Come Pedro mach yujilic chuqui woli' yʌl, come woliyob ti cabʌl bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tsa' tili tocal. Tsi' mosoyob. Tsa' tili t'an ti tocal. Tsi' yʌlʌ: Jiñʌch calobil, c'ux bʌ mi cubin. Ñich'tanla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jini xcʌnt'añob che' bʌ tsi' joy q'ueleyob pañimil, tsi' q'ueleyob ma'anix majqui ya'an yic'otob, i bajñel jach Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Che' woli' jubelob tilel ti wits, Jesús tsi' tiq'uiyob cha'an ma'anic mi' subeñob winicob mi juntiquilic chuqui tsi' q'ueleyob jinto mi' cha' ch'ojyel i Yalobil Winic ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jini xcʌnt'añob tsi' cʌntayob jini t'an ti' pusic'al. Tsi' c'ajtibeyob i bʌ chuqui i sujmlel jini t'an “mi' cha' ch'ojyel ba'an chʌmeño' bʌ”. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsi' c'ajtibeyob: ¿Chucoch mi' yʌlob sts'ijbayajob wersa mi' ñaxan tilel Elías? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús tsi' subeyob: Isujmʌch ñaxan tal Elías. Mi caj i cha' toj'esan pejtelel chuqui an. ¿Mach ba ts'ijbubilic: “Wersa mi' ñusan cabʌl wocol i Yalobil Winic, wersa mi' ts'a'lentel ja'el”? ");
INSERT INTO ctuBl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mic subeñetla tsa'ix tili Elías. Winicob x'ixicob tsi' tic'layob bajche' jach yomob che' bajche' ts'ijbubil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Che' bʌ tsa' tili ba'an xcʌnt'añob, tsi' q'uele bajc'ʌl winicob x'ixicob ti' joytilel. Jini sts'ijbayajob woliyob ti cabʌl t'an yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ti ora tsa' toj sajtiyob i pusic'al pejtelel jini winicob x'ixicob che' bʌ tsi' q'ueleyob Jesús. Ti ajñel tsa' tiliyob ba'an. Tsi' yʌq'ueyob cortesía. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús tsi' c'ajtibeyob: ¿Chucoch woliyetla ti cabʌl t'an? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Juntiquil ya' bʌ an yic'otob tsi' sube: Maestro, tsac pʌyʌ tilel calobil ba' añet. An i xibʌjlel mu' bʌ i yotsan ti x'uma'. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Baqui jach mi' chuc, mi' choc jubel. Mi' loq'uel i lojc i yej. Quech'ecña mi' mel i bʌquel i yej. Mi' tsʌts'an i c'ʌb i yoc. Tsac sube xcʌnt'añob a cha'an, cha'an mi' chocob loq'uel. Ma'anic tsa' mejliyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús tsi' subeyob: ¡Winicob x'ixicob año' bʌ wʌle mach bʌ anic mi la' ñop! ¿Jayp'ejl to q'uin wʌ' añon la' wic'ot? ¿Jayp'ejl to q'uin mic wersa cuchbeñetla la' sajtemal? Pʌyʌla tilel ba' añon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tsi' pʌyʌyob tilel jini ch'iton ba'an Jesús. Jini xiba che' bʌ tsi' q'uele Jesús, tsi' bʌc' ac'ʌ jini ch'iton ti juquin chʌmel. Tsa' yajli jini ch'iton ti lum. Tsi' pach'i i bʌ. Tsa' loq'ui i lojc i yej. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús tsi' c'ajtibe i tat: ¿Jayp'ejlix jab tsa' caji jini? che'en. I tat tsi' sube: C'ʌlʌl che' alʌl to, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Cabʌl tsi' choco ochel ti c'ajc yic'ot ti ja' cha'an mi' tsʌnsan. Mi an chuqui mi mejlel a mel, p'untañon lojon, coltañon lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús tsi' sube: Mi tsa' mejli a ñop, jini mu' bʌ i ñop mi mejlel ti melbentel pejtelel chuqui tac yom, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ti ora i tat jini ch'iton tsi' cha'le c'am bʌ t'an. Tsi' yʌlʌ: Mic ñop. Chocbeñon loq'uel tile bixel bʌ c pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús tsi' tiq'ui xiba che' bʌ tsi' q'uele woli' tempañob i bʌ cabʌl winicob x'ixicob. Tsi' sube xiba: Mic subeñet xiba, mu bʌ a wotsan jini ch'iton ti x'uma' ti xcojc, loq'uen ti jini ch'iton. Mach ma' chʌn ochel ti pejtelel ora, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tsi' cha'le oñel xiba. Tsi' cha' ac'ʌ ti juquin chʌmel jini ch'iton che' bʌ tsa' loq'ui ti' pusical. Che' bajche' chʌmen tsa' cʌle jini ch'iton. Jini cha'an cabʌl tsi' yʌlʌyob: Chʌmenix, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús tsi' chucbe i c'ʌb jini ch'iton. Tsi' teche. Tsa' ch'ojyi jini ch'iton. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús tsa' ochi ti otot. Jini xcʌnt'añob i cha'an tsi' bajñel c'ajtibeyob: ¿Chucoch ma'anic tsa' mejli c choc lojon loq'uel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús tsi' subeyob: Mach mejlic ti chojquel loq'uel jini xiba, cojach ti oración, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tsa' loq'uiyob majlel ya'i. Tsa' ñumiyob ti Galilea. Mach yomic Jesús mi' ña'tañob mi ya'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Come woli' cʌntesan majlel xcʌnt'añob i cha'an. Tsi' subeyob: Mi caj i yʌjq'uel i Yalobil Winic ti' c'ʌb winicob mu' bʌ caj i tsʌnsañob. Che' chʌmenix mi caj i cha' ch'ojyel ti' yuxp'ejlel q'uin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ma'anic tsi' ch'ʌmbeyob isujm jini t'an. Ma'anic tsi' c'ajtibeyob i sujmlel come woliyob ti bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tsa' c'oti ya' ti Capernaum. Che' bʌ tsa' ochi ti otot, tsi' c'ajtibeyob: ¿Chuqui ti t'an tsa' la' wʌlʌ ti bij? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma'anic chuqui tsi' jac'ʌyob, come tsi' cʌlʌx pejcayob i bʌ ti bij cha'an woli' bajñel yajcañob majqui ñumen ñuc mi' caj ti ajñel ti' tojlelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tsa' buchle Jesús. Tsi' pʌyʌ tilel jini lajchʌntiquil. Tsi' subeyob: Majqui yom ajñel ti c'ax ñuc ti la' tojlel wersa mi' mel i bʌ ti c'ax ch'o'ch'oc. Wersa mi' coltañetla ti pejteleletla. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tsi' pʌyʌ tilel juntiquil alob. Tsi' yʌc'ʌ ti ojlil ba' añob. Che' bʌ tsi' meq'ue, tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Majqui jach mi' c'uxbin tij c'aba' juntiquil alʌl che' bajche' jini, mi' c'uxbiñon. Jini mu' bʌ i c'uxbiñon mach joñonic jach mi' c'uxbin. Mi' c'uxbin ja'el c Tat tsa' bʌ i chocoyon tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan tsi' sube: Maestro, tsaj q'uele lojon juntiquil mu' bʌ i choc loq'uel xibajob ti a c'aba', pero ma'anic mi' tsajcañon lojon. Tsac tiq'ui lojon come ma'anic mi' tsajcañon lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero Jesús tsi' sube: Mach mi la' tic' come ma'anic majch mi' cha'len p'ʌtʌl bʌ e'tel tij c'aba' mu' bʌ i p'ajon ti ora. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Come jini mach bʌ anic mi' contrajiñonla, mi' coltañonla. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Come majqui jach mi' yʌq'ueñetla jump'ejl tsima ja' tij c'aba' come i cha'añetla Cristo, isujm mic subeñetla, ma'anic mi caj i sʌt i chobejtʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Majqui jach mi' yʌsan ti mulil juntiquil ch'o'ch'oc bʌ mu' bʌ i ñopon, mach uts'atic mi caj i yujtel. Ñumen uts'at tsa'ic ñaxan cʌjchi ña'atun ti' bic' jini winic cha'an mi' chojquel ochel ti ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mi woli' yʌsañet ti mulil a c'ʌb, tsepe loq'uel. Uts'at mi tsa' taja a cuxtʌlel che' xbor c'ʌbet. Mach uts'atic mi ti cha'ts'ijt a c'ʌb ma' majlel ti infierno, ti jini c'ajc mach bʌ yujilic yajpel, ");
INSERT INTO ctuBl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ba' ma'anic mi' chʌmel i motso'lel, ba' ma'anic mi' yajpel jini c'ajc ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mi woli' yʌsañet ti mulil a woc, tsepe loq'uel. Uts'at mi tsa' taja a cuxtʌlel che' xbor oquet. Mach uts'atic mi ti cha'ts'ijt a woc ma' chojquel ochel ti c'ajc ");
INSERT INTO ctuBl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ba' ma'anic mi' chʌmel i motso'lel, ba' ma'anic mi' yajpel c'ajc ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mi woli' yʌsañet ti mulil a wut, loc'san. Uts'at che' ma' wochel ti' yumʌntel Dios yic'ot jump'ejl jach a wut. Mach uts'atic che' cha'p'ejl a wut ma' chojquel ochel ti c'ajc, ");
INSERT INTO ctuBl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ba' ma'anic mi' chʌmel i motso'lel, ba' ma'anic mi' yajpel c'ajc ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Come ti pejtelel pañimil mi caj i yotsʌbentelob i yʌts'mil che' mi' ñusañob wocol. Come pejtelel majtanʌl mu' bʌ i tsʌnsʌntel mi caj i yotsʌbentel i yʌts'mil ti ats'am. ");
INSERT INTO ctuBl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Uts'at ats'am. Pero mi tsa' sajti i tsajel, ¿bajche' mi mejlel la' cha' tsaj'esan? Yom chʌn tsaj la' wʌts'mil. Tem ajñenla ti' ñʌch'tilel la' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús tsa' loq'ui majlel ya'i. Tsa' tili ti Judea ti junwejl Jordán ja'. Tsi' cha' tempayob i bʌ cabʌl winicob x'ixicob ba'an Jesús. Tsi' cha' cʌntesayob come i tilelʌch. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tsa' tiliyob fariseojob ba'an Jesús cha'an mi' yilʌbeñob i pusic'al. Tsi' c'ajtibeyob: ¿Tic'bil ba winic ti mandar cha'an mi' choc loq'uel i yijñam? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús tsi' c'ajtibeyob: ¿Chuqui tsi' subeyetla Moisés ti mandar? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tsi' subeyob: Moisés tsi' yʌq'ue i t'an winicob cha'an mi' ts'ijbuñob jun ba' mi' tsictiyel tsa'ix i cʌyʌ i yijñam ti junyajlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús tsi' subeyob: Cha'an jach i tsʌtslel la' pusic'al tsi' ts'ijbubeyetla jini mandar. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ti' cajibal che' bʌ tsi' mele pañimil Dios, tsi' mele winic x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jini cha'an la' i cʌy i tat i ña' winic cha'an mi' yajñel yic'ot i yijñam. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Jini cha'tiquil mi' yochelob ti juntiquil jach i bʌc'tal. Mach chʌn cha'tiquilix. Juntiquil jach i bʌc'tal. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jini cha'an, mach i t'ox winic jini mu' bʌ i tempan Dios. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ti mal otot jini xcʌnt'añob tsi' cha' c'ajtibeyob i sujmlel jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús tsi' subeyob: Majqui jach mi' cʌy i yijñam, mi tsi' pʌyʌ yambʌ i yijñam, mi' cha'len ts'i'lel ti' contra. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jini x'ixic mu' bʌ i cʌy i ñoxi'al, mi tsi' jac'ʌ i pʌyol ti yambʌ winic, mi' cha'len ts'i'lel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsi' pʌyʌyob tilel alobob ba'an Jesús cha'an mi' mec'ob. Jini xcʌnt'añob tsi' tiq'uiyob jini tsa' bʌ i pʌyʌyob tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús tsa' mich'a che' bʌ tsi' q'uele. Tsi' subeyob: La' tilicob alobob ba' añon. Mach mi la' tic'ob, come i cha'añob i yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Isujm mic subeñetla, jini mach bʌ anic mi' yochel ti' yumʌntel Dios che' bajche' alʌl ma'anic mi caj i yochel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tsi' meq'ueyob. Tsi' yʌc'ʌ i c'ʌb ti jini alobob. Tsi' yʌq'ueyob i yutslel i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Che' bʌ tsa' loq'ui majlel ti bij, tsa' tili winic ti ajñel. Tsa' ñocle ba'an Jesús. Tsi' c'ajtibe: Wen bʌ Maestro, ¿chuqui yom mic cha'len cha'an mic taj j cuxtʌlel mach bʌ anic mi' jilel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús tsi' sube: ¿Chucoch ma' wʌl mi weñon? Ma'anic majqui wen, cojach Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A wujil jini mandar: “Mach a cha'len ts'i'lel, mach a cha'len tsʌnsa, mach a cha'len xujch', mach a cha'len jop't'an, mach a xujch'iben i chubʌ'an a pi'ʌl ti lot, q'uele ti ñuc a tat a ña'”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jini winic tsi' jac'ʌ: Maestro, pejtelel jini mandar tsac jac'ʌ c'ʌlʌl che' alobon to, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús tsi' q'uele. Tsi' c'uxbi. Tsi' sube: An to yom ma' mel yambʌ junchajp. Cucu, choño pejtelel a chubʌ'an, aq'uen jini mach bʌ anic i chubʌ'an. Che' jini, mi caj a taj cabʌl a chubʌ'an ti panchan. La', ch'ʌmʌ a cruz, tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jini winic tsi' mele i pusic'al cha'an jini t'an. Ch'ijiyem tsa' majli come an cabʌl i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","24","Jesús tsi' sutq'ui i wut ba'an xcʌnt'añob i cha'an. Tsi' subeyob: Wocol mi caj i yochelob ti' yumʌntel Dios jini wen chumulo' bʌ, che'en. Tsa' toj sajtiyob i pusic'al jini xcʌnt'añob cha'an i t'an. Jesús tsi' cha' subeyob: ¡Alobob, wocol mi' yochelob ti' yumʌntel Dios! ");
INSERT INTO ctuBl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wocol mi' ñumel camello ti' yarcayojlel acuxan. Ñumen wocol mi' yochel jini wen chumul bʌ winic ti' yumʌntel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ñumen tsa' toj sajtiyob i pusic'al cha'an jini t'an. Tsi' subeyob: ¿Majqui che' jini mi mejlel i coltʌntel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús tsi' q'ueleyob. Tsi' subeyob: Mach mejlicob winicob. Mi mejlel Dios. Ti pejtelel chuqui tac jach yom, mi mejlel i mel Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro tsa' caji i suben: Awilan, tsaj cʌyʌ lojon pejtelel chuqui an cha'an mic tsajcañet lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús tsi' subeyob: Isujm mic subeñetla, majqui jach mi' cʌy i yotot mi i yʌscun, mi i chich, mi i yijts'in, mi i tat, mi i ña', mi i yijñam, mi i yalobilob, mi i lumal cha'an joñon cha'an jini wen t'an, ");
INSERT INTO ctuBl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mi' taj wʌle ti ili ora yambʌ jo'c'al i ñumel i yotot tac, i yʌscuñob, i chichob, i yijts'iñob, i ña'ob, i yalobilob, i lum, yic'ot i tic'lʌntel. Ti jini tal to bʌ ora mi caj i taj i cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cabʌl jini ñaxaño' bʌ mi caj i cʌytʌlob ti wi'ipat. Cabʌl jini wi'ilobix bʌ mi caj i c'axelob majlel ti ñaxan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Woli' letselob majlel ti bij ti Jerusalén. Ñaxan tsa' majli Jesús ti bij. Tsa' toj sajtiyob i pusic'al xcʌnt'añob ti bʌq'uen che' bʌ tsi' tsajcayob majlel. Jesús tsi' cha' pʌyʌ tilel jini lajchʌntiquil. Tsa' caji i subeñob chuqui tac mi caj i tumbentel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Awilan, woli lac letsel majlel ti Jerusalén. I Yalobil Winic mi caj i yʌjq'uel ti' c'ʌb ñuc bʌ motomajob yic'ot sts'ijbayajob mu' bʌ caj i yʌc'ob ti chʌmel. Mi caj i yʌc'ob ti' c'ʌb gentilob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mi caj i wajleñob. Mi caj i jats'ob ti asiyal. Mi caj i tujbañob. Mi caj i tsʌnsañob. Ti yuxp'ejlel q'uin mi caj i cha' ch'ojyel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo yic'ot Juan i yalobilob Zebedeo, tsa' c'otiyob ba'an Jesús. Tsi' subeyob: Maestro, com lojon ma' melbeñon lojon chuqui mij c'ajtibeñet, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús tsi' c'ajtibeyob: ¿Chuqui la' wom mic melbeñetla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsi' subeyob: Com lojon ma' wʌc'on lojon ti buchtʌl, juntiquil ti a ñoj juntiquil ti a ts'ej ti a ñuclel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús tsi' subeyob: Mach la' wujilic chuqui woli la' c'ajtin. ¿Mejl ba mi la' ñusan jini wocol mu' bʌ c ñusan? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsi' subeyob: Muc'ʌch c mejlel lojon, che'ob. Jesús tsi' subeyob: Isujmʌch, jatetla mi caj la' ñusan jini wocol mu' bʌ caj c ñusan. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero mach c wentajic cha'an mic sub majqui mi caj i buchtʌl tic ñoj yic'ot tic ts'ej. Mi caj i yʌjq'uelob ti buchtʌl jini tsa' bʌ chajpʌbentiyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Che' yujilobix jini lujuntiquil, tsa' caji i mich'leñob Jacobo yic'ot Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús tsi' pʌyʌyob tilel. Tsi' subeyob: La' wujil c'ax ñuc mi' pʌsob i bʌ jini gentilob mu' bʌ i yumʌntelob. Jini ñuco' bʌ ti' tojlelob, tsʌts mi' yʌc'ob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mach che'ic yom mi la' cha'len jatetla. Majqui jach yom i taj i ñuclel ti la' tojlel, la' i coltañetla. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Majqui jach yom ajñel ti c'ax ñuc ti la' tojlel, la' i coltañetla che' bajche' la' winic ti la' pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Come tsa' tili i Yalobil Winic mach cha'anic mi' coltʌñtel, pero cha'an mi' coltan winicob x'ixicob, cha'an mi' yʌc' i bʌ ti chʌmel cha'an i tojol i mul cabʌlob. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tsa' tiliyob ti Jericó. Che' bʌ tsa' loq'ui majlel ti Jericó yic'ot xcʌnt'añob i cha'an yic'ot cabʌl winicob x'ixicob, tsi' taja jini xpots' Bartimeo i yalobil Timoteo, buchul ti' ti' bij. Woli' c'ajtin taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Che' bʌ tsi' yubi ya'an Jesús ch'oyol bʌ ti Nazaret, tsa' caji ti c'am bʌ t'an. Tsi' yʌlʌ: Jesús i Yalobilet David, p'untañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cabʌlob tsi' tiq'uiyob cha'an mi' cʌy i t'an. Tsa' utsi caji ti c'am bʌ t'an: I Yalobilet David, p'untañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús tsi' cʌyʌ i xʌmbal. Tsi' yʌlʌ: Pʌyʌla tilel, che'en. Che' bʌ tsi' pʌyʌyob tilel jini xpots', tsi' subeyob: Tijicñesan a pusic'al. Ch'ojyen. Woli' pʌyet Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jini xpots' tsi' welchoco i mosil. Tsa' ch'ojyi. Tsa' tili ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús tsi' sube: ¿Chuqui a wom mic tumbeñet? che'en. Jini xpots' tsi' sube: Maestro, com mi' cha' c'otel c wut, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús tsi' sube: Cucu, tsa'ix coltʌntiyet cha'an tsa' ñopo, che'en. Ti ora tsa' cha' c'oti i wut. Tsi' tsajca majlel Jesús ti bij. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Che' bʌ lʌc'ʌlix añob ti Jerusalén, lʌc'ʌl ti Betfagé yic'ot Betania ya' ti' tojel Olivo wits, Jesús tsi' choco majlel cha'tiquil xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Tsi' subeyob: Cucula ti tejclum ya' ti' tojel la' wut. Che' mi la' wochel, ya' cʌchʌl mi caj la' taj tsiji' burro, mach bʌ anic majch tsi' c'ʌchta. Jitila. Pʌyʌla tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mi an majch mi' subeñetla: “¿Chucoch che' mi la' mel jini?” subenla: “Yom i c'ʌn lac Yum. Ti ora mi caj i cha' sutq'uibeñet”. Che' yom mi la' suben, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsa' majliyob jini xcʌnt'añob. Tsi' tajayob jini burro cʌchʌl ti' ti' otot ya' ti calle. Tsi' jitiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jini ya' bʌ wa'alob tsi' subeyob: ¿Chuqui woli la' cha'len? ¿Chucoch woli la' jit burro? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jini xcʌnt'añob tsi' subeyob chuqui tsi' yʌlʌ Jesús. Jini winicob tsi' chocoyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jini xcʌnt'añob tsi' pʌyʌyob tilel jini tsijib burro ba'an Jesús. Tsi' tasibeyob i pat burro ti' pislelob. Jesús tsi' buchta. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","An cabʌl tsa' bʌ i tasiyob majlel jini bij ti' pislelob. Yaño' bʌ tsa' caji i lijlij ac'ob majlel ti bij i c'ʌb te' am bʌ i yopol tsa' bʌ i tsepeyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jini woli bʌ i majlelob ti' tojel Jesús yic'ot jini woli bʌ i tilelob ti' pat c'am tsi' yʌlʌyob: Cotañet. La' sujbic a ñuclel jatet mu' bʌ a tilel ti' c'aba' lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","La' sujbic i ñuclel i yumʌntel lac tat David woli bʌ i cajel. Cotañet añet bʌ ti chan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tsa' ochi Jesús ti Jerusalén ba' tsa' majlel ti Templo. Che' bʌ tsa'ix i joy q'uele pejtelel chuqui tac an, che' bʌ yomix ic'an, tsa' majli ti Betania yic'ot jini lajchʌntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ti yijc'ʌlal che' loq'uemobix ti Betania, tsi' yubi wi'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ñajt tsi' q'uele higuera te' am bʌ i yopol. Tsa' majli i q'uel mi an chuqui mi' taj. Che' bʌ tsa' c'oti ba'an te', i yopol jach tsi' taja come maxto i yorajlelic i wut. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús tsi' sube jini te': Mach i chʌn c'ux a wut winicob x'ixicob ti pejtelel ora, che'en. Jini xcʌnt'añob i cha'an tsi' yubiyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tsa' tiliyob ti Jerusalén. Jesús tsa' ochi ti Templo. Tsa' caji i choc loq'uel jini woliyo' bʌ ti choñoñel yic'ot woliyo' bʌ ti mʌñoñel ti Templo. Jesús tsi' ch'a' chocobeyob i mesa tac xq'uex taq'uiñob, yic'ot i buchlib tac jini woli bʌ i choñob x'ujcuts. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tsi' tiq'uiyob cha'an ma'anic chuqui mi' ch'ʌmob ñumel ti' mal Templo mi juntiquilic. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesús tsi' cʌntesayob. Tsi' subeyob: Ts'ijbubil ti jun: “Mi' caj ti ajlel cotot ti' yotlel oración cha'an winicob x'ixicob ti pejtelel lum tac”. Pero jatetla tsa'ix la' wotsa ti' ch'eñal xujch', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jini sts'ijbayajob yic'ot jini ñuc bʌ motomajob tsi' yubiyob. Tsi' sajcayob bajche' mi mejlel i tsʌnsañob come tsi' bʌc'ñayob Jesús. Come tsa' toj ñuc'ayob i pusic'al pejtelel winicob x'ixicob cha'an i cʌntesʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Che' wolix i yic'an tsa' loq'ui majlel ti tejclum Jesús yic'ot jini xcʌnt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ti sʌc'ajel che' bʌ tsa' cha' ñumiyob, tsi' q'ueleyob higuera te' tiquinix c'ʌlʌl ti' wi'. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tsa' c'ajtiyi i cha'an Pedro. Tsi' sube: Maestro, q'uele tsa'ix tiqui jini higuera te' tsa' bʌ a ch'ʌcʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús tsi' jac'ʌ: Ñopola Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Come isujm mic subeñetla: Majqui jach mi' suben jini wits cha'an mi' ch'ujyel letsel cha'an mi' chojquel ochel ti colem ñajb, mi mach tile bixelic i pusic'al wolix i ñop, mi caj i yujtel bajche' mi' yʌl, che'ʌch mi caj i melbentel. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jini cha'an mic subeñetla: Pejtelel chuqui mi la' c'ajtiben Dios ti oración, ñopola mi caj la' wʌq'uentel. Che' jini mi caj la' wʌq'uentel. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Che' woliyetla ti oración, mi an chuqui lotol ti la' pusic'al ti' contra juntiquil, ñusʌben i mul cha'an mi' ñusʌbeñetla la' mul la' Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Come mi ma'anic mi la' ñusʌben i mul, ma'anic mi caj i ñusʌbeñetla la' mul ja'el la' Tat am bʌ ti panchan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tsa' cha' tiliyob ti Jerusalén. Che' bʌ tsi' cha'le xʌmbal Jesús ti mal Templo, tsa' tiliyob ñuc bʌ motomajob yic'ot sts'ijbayajob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tsi' subeyob: ¿Baqui tsa' taja a we'tel cha'an ma' cha'len jini? ¿Majqui tsi' yʌq'ueyet a we'tel cha'an ma' mel chuqui tac ma' mel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús tsi' subeyob: An chuqui mij c'ajtibeñetla ja'el. Subeñon. Che' jini joñon mi caj c subeñetla baqui tsac taja que'tel cha'an jini mu' bʌ c mel. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Baqui ch'oyol i ye'tel Juan cha'an mi' yʌc' ch'ʌmja'? ¿Ch'oyol ba ti panchan o ch'oyol ba ti winicob? Subeñon, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tsa' caji i bajñel pejcañob i bʌ. Tsi' yʌlʌyob: Mi tsa' lac sube ch'oyol ti panchan, mi cho'onla, mi caj i yʌl: “¿Chucoch, che' jini, ma'anic tsa' la' ñopbe i t'an?” Che' mi caj i yʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Yom ba mi lac suben ch'oyol ti winicob? che'ob. Pero tsi' bʌc'ñayob winicob x'ixicob come ti pejtelelob tsi' yʌlʌyob mero x'alt'añʌch jini Juan. ");
INSERT INTO ctuBl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jini cha'an tsi' subeyob: Mach cujilic lojon, che'ob. Jesús tsi' subeyob: Joñon ja'el, ma'anic mic subeñetla baqui tsac taja que'tel cha'an jini mu' bʌ c mel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús tsa' caji i pejcañob ti lajiya tac: Juntiquil winic tsi' pʌc'ʌ ts'usubil, che'en. Tsi' joy mʌcʌ ti corral, tsi' piqui lum ba' mi' t'uchtʌben loq'uel i ya'lel ts'usub. Tsi' mele chan bʌ q'ueloñib. Tsi' yʌc'ʌ ti' wenta xcʌnta ts'usubilob. Tsa' majli ti yambʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Che' bʌ tsa' tili i yorajlel, tsi' choco majlel x'e'tel ba'an xcʌnta ts'usubilob cha'an mi' ch'ʌm i wut ts'usubil ti' c'ʌbob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero jini xcʌnta ts'usubilob tsi' chucuyob jini x'e'tel. Tsi' lowoyob. To'o che' jach tsi' chocoyob sujtel. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","I yum tsi' cha' choco majlel yambʌ x'e'tel ba' añob. Tsi' juluyob ti xajlel, tsi' lowbeyob i jol. Che' ja'el leco tsi' tic'layob che' bʌ tsi' cha' chocoyob sujtel. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","I yum tsi' cha' choco majlel yambʌ. Jini xcʌnta ts'usubilob tsi' tsʌnsayob. Che' ja'el, cabʌl yaño' bʌ x'e'telob, ojlil tsi' lowoyob, ojlil tsi' tsʌnsayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ya' to tsa' cʌle juntiquil yic'ot jini yumʌl, jiñʌch i yalobil tsa' bʌ i wen c'uxbi. Tsi' choco majlel i yalobil ja'el ya' ba' añob. Tsi' yʌlʌ: “Mux caj i q'uelob calobil ti ñuc”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Jini xcʌnta ts'usubilob tsi' subeyob i bʌ: “Jiñʌch mu' bʌ caj i yochel ti yumʌl. Conla, la' lac tsʌnsan. Che' jini, mux la cochel ti' yum pejtel i chubʌ'an”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tsi' chucuyob. Tsi' tsʌnsayob. Tsi' chocoyob loq'uel ti ts'usubil. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Chuqui mi caj i cha'len i yum ts'usubil che' jini? Mi caj i tilel. Mi caj i jisan xcʌnta ts'usubilob. Mi caj i yʌc' i ts'usubil ti' c'ʌb yaño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Mach ba anic tsa' la' q'uele jini t'an ti' ts'ijbujel Dios?: “Jini jach bʌ xajlel tsa' bʌ i chocoyob xmel ototob, tsa'ix otsʌnti ti ñaxan bʌ i xujc otot. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jiñʌch i melbal lac Yum. Uts'atax mi laj q'uel”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jini ñuc bʌ motomajob yic'ot sts'ijbayajob tsi' ña'tayob bajche' mi mejlel i chucob Jesús, come yujilob tsi' cha'le t'an ti lajiya ti' contrajob. Pero tsi' bʌc'ñayob winicob x'ixicob. Jini cha'an tsi' cʌyʌyob Jesús. Tsa' majliyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tsi' chocoyob majlel cha'tiquil uxtiquil fariseojob yic'ot herodiañob ya' ba'an Jesús cha'an mi' tajbeñob i mul Jesús ti' t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Che' bʌ tsa' tiliyob ba'an Jesús, tsi' subeyob: Maestro, cujil lojon isujmet. Ma'anic majqui ma' bʌc'ñan. Junlajal jach ma' q'uel winicob mi an i ye'tel mi ma'anic i ye'tel. Wola' cha'len cʌntesa ti isujm cha'an i bijlel Dios. ¿Mu' ba i yʌl ti mandar cha'an mi la cʌq'uen César jini tojoñel o ma'anic? ¿Yom ba mi la cʌq'uen o mach yomic? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús yujil cha'chajp jax i pusic'al jini winicob. Jini cha'an tsi' subeyob: ¿Chucoch mi la' wilʌbeñon c pusic'al? Ch'ʌmbeñon tilel junq'uejl taq'uin cha'an mij q'uel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tsi' ch'ʌmbeyob tilel. Jesús tsi' c'ajtibeyob: ¿Majqui i cha'an ili i yejtal yic'ot i ts'ijbal ti' pam? che'en. Tsi' subeyob: I cha'an César, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús tsi' subeyob: Aq'uenla César chuqui i cha'an César. Aq'uenla Dios chuqui i cha'an Dios, che'en. Tsa' toj sajtiyob i pusic'al cha'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tsa' tiliyob saduceojob ba'an Jesús. Jiñobʌch mu' bʌ i yʌlob ma'anic mi' tejchelob ch'ojyel chʌmeño' bʌ. Tsi' c'ajtibeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, Moisés tsi' ts'ijbubeyonla chuqui yom mi' mel winic mi tsa' chʌmi i yʌscun am bʌ i yijñam mach bʌ anic i yalobil. Jini ijts'iñʌl bʌ wersa mi' pʌyben i yijñam i yʌscun cha'an mi' techben i p'olbal i yʌscun. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","An wuctiquil winic i yerañob i bʌ. Jini ascuñʌl bʌ tsi' pʌyʌ i yijñam. Tsa' chʌmi. Ma'anic i p'olbal. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jini ijtsiñil bʌ tsi' pʌyʌ jini x'ixic cha'an i yijñam. Tsa' chʌmi ja'el che' ma'anic i yalobil. Lajal tsi' mele i yuxticlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ti' wucticlel tsi' pʌyʌ jini x'ixic cha'an i yijñam. Ma'anic i yalobil. Ti wi'il tsa' chʌmi ja'el jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ti' yorajlel che' mi' tejchelob ch'ojyel, ¿baqui bʌ winic i ñoxi'al jini x'ixic? come tsi' pʌyʌyob cha'an i yijñam ti' wucticlel. Che' tsi' yʌlʌyob jini saduceojob. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús tsi' subeyob: ¿Mach ba jinic la' sajtemal? che'en, come ma'anic mi la' cʌn i Ts'ijbujel Dios yic'ot i p'ʌtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Che' mi' ch'ojyelob ba'an chʌmeño' bʌ, ma'anix mi' chʌn pʌyob i pi'ʌl, ma'anic mi' sijintelob ja'el. Come lajalob bajche' ángelob ya' ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Cha'an i sujmlel jini chʌmeño' bʌ mu' bʌ i tejchelob ch'ojyel, ¿mach ba anic tsa' la q'uele ti' jun Moisés ba' Dios tsi' pejca ti alʌ te'? Dios tsi' sube: “Joñon i Dioson Abraham, i Dioson Isaac, i Dioson Jacob”. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jini Dios mach i Diosic chʌmeño' bʌ. I Diosʌch cuxulo' bʌ. Jini cha'an cabʌl la' sajtemal, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Che' lʌc'ʌl tsa' tili juntiquil sts'ijbaya, tsi' yubibeyob i t'an che' woli' pejcañob i bʌ. Jini sts'ijbaya tsi' ña'ta uts'at bajche' tsi' cha'le t'an Jesús. Jini cha'an tsi' c'ajtibe: ¿Baqui bʌ mandar ñumen ñuc ti pejtelel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús tsi' sube: Jini ñumen ñuc bʌ mandar ti pejtelel jiñʌch: “Ñich'tanla israelob, jini lac Yum Dios, juntiquil jach. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","C'uxbin a Yum Dios ti pejtelel a pusic'al, ti pejtelel a ch'ujlel, ti pejtelel a ña'tʌbal, ti pejtelel a p'ʌtʌlel”. Jiñʌch jini ñumen ñuc bʌ mandar. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lajalʌch jini cha'p'ejlel bʌ mandar: “C'uxbin a pi'ʌlob che' bajche' ma' bajñel c'uxbin a bʌ”. Ma'anic yambʌ mandar ñumen ñuc bʌ bajche' jini cha'p'ejl mandar, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jini sts'ijbaya tsi' sube: Melelʌch Maestro, tsa'ix a subu chuqui isujm. Dios juntiquil jach. Ma'anic yambʌ. Cojach jini. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mi tsa' laj c'uxbi Dios ti pejtelel lac pusic'al, ti pejtelel lac ña'tʌbal, ti pejtelel lac ch'ujlel, ti pejtelel lac p'ʌtʌlel, mi tsa' laj c'uxbi lac pi'ʌlob ja'el che' bajche' mi lac bajñel c'uxbin lac bʌ, jiñʌch ñumen ñuc bʌ bajche' pejtelel pulem bʌ i majtan Dios yic'ot tsʌnsʌbil bʌ i majtan Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús tsi' ña'ta uts'at bajche' tsi' jac'ʌ jini sts'ijbaya. Tsi' sube: Ts'ita' jax yom cha'an ma' wochel ti' yumʌntel Dios, che'en. Ti wi'il ma'anix majqui tsi' chʌn ñopo i c'ajtiben Jesús yan tac bʌ cha'an bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Che' woli ti cʌntesa ti Templo Jesús tsi' yʌlʌ: ¿Chucoch, mi' yʌlob sts'ijbayajob jini Cristo i yalobilʌch David? ");
INSERT INTO ctuBl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David tsi' yʌlʌ yic'ot Ch'ujul bʌ Espíritu: “Jini lac Yum tsi' sube c Yum: Buchi' tic ñoj, che'en Dios, jinto mi cʌq'ueñet a t'uchtan a contrajob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David tsi' pejca Cristo ti' Yum. ¿Bajche' isujm, che' jini, mi i yalobil? Che' tsi' yʌlʌ Jesús. Cabʌl tempʌbilo' bʌ winicob x'ixicob tijicña jax tsi' yubibeyob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús tsi' subeyob ja'el che' woli ti cʌntesa: Chʌcʌ q'uele la' bʌ cha'an sts'ijbayajob mu' bʌ i mulañob i lʌpob pʌl bʌ i bujc. Mi' mulañob i yʌq'uentel cortesía ba'an choñoñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mi' mulañob jini ñaxan bʌ buchlibʌl ti sinagoga yic'ot ñaxan bʌ buchlibʌl ti q'uiñijel. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mi' chilbeñob i yotot tac meba' x'ixicob. Cha'an mi' lon q'uejlelob ti uts'at mi' melob tam bʌ oración. Ñumen wocol mi caj i tajob tojmulil, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús tsa' buchle ti' tojel i yajñib ofrenda. Tsi' q'uele winicob x'ixicob woli bʌ i chocob ochel i taq'uin ti' yajñib. Cabʌl wen chumulo' bʌ tsi' chocoyob ochel cabʌl taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tsa' tili meba' x'ixic mach bʌ anic i chubʌ'an. Tsi' choco ochel cha'q'uejl taq'uin. Ti' cha'q'uejlel ts'ʌcʌl mi' loq'uel lujump'ejl centavo. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús tsi' pʌyʌ tilel xcʌnt'añob i cha'an. Tsi' subeyob: Isujm mic subeñetla, jini meba' x'ixic mach bʌ anic i chubʌ'an tsa'ix i choco ochel ñumen cabʌl bajche' pejtelel yaño' bʌ tsa' bʌ i chocoyob ochel taq'uin ti' yajñib. ");
INSERT INTO ctuBl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Come ti pejtelelob tsi' chocoyob ochel jini loc'sʌbil bʌ ti' yonlel i chubʌ'an, pero jini meba' x'ixic mach bʌ anic i chubʌ'an tsi' choco ochel pejtelel i tojol i bʌl i ñʌc'. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Che' wolix ti loq'uel Jesús ti Templo, juntiquil xcʌnt'an i cha'an tsi' sube: Maestro, q'uele wen uts'at tac jini xajlel, wen wa'chocobil jini otot tac, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús tsi' sube: ¿Mu' ba a q'uel jini colem tac bʌ otot? Ma'anic mi caj i cʌytʌl mi jump'ejlic xajlel ti pam yambʌ. Mi caj i laj chojquel jubel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tsa' buchle ti Olivo wits ti' tojel Templo. Pedro yic'ot Jacobo yic'ot Juan yic'ot Andrés ti' bajñelilob tsi' c'ajtibeyob: ");
INSERT INTO ctuBl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Subeñon lojon baqui ora mi caj i yujtel pejtelel jini. ¿Chuqui mi' caj ti pʌstʌl che' yom ujtel pejtelel ili tac? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús tsa' caji' subeñob: Chʌcʌ q'uele la' bʌ ame anic majch mi' soquetla. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Come talob cabʌl tij c'aba' mu' bʌ caj i lon cuyob i bʌ ti Cristo. Mi caj i socob cabʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ba' ora mi la' wubin an cabʌl guerra che' ja'el cabʌl t'an cha'an guerra, mach la' cha'len bʌq'uen come wersa mi' tilel, pero maxto i jilibalic. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Come jini año' bʌ ti jumpejt lum mi caj i techob guerra ti' contra año' bʌ ti yambʌ lum. Jini año' bʌ ti' wenta juntiquil yumʌl mi caj i techob guerra ti' contra jini año' bʌ ti' wenta yambʌ yumʌl. Tal i yujquel lum ti cabʌl lum. Tal cabʌl wi'ñal yic'ot leto. Jiñʌch i cajibal wocol. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Chʌcʌ q'uele la' bʌ come mi caj i yʌq'uetla ti' c'ʌb jini año' bʌ i ye'tel. Mi caj la' bajbentel ti sinagoga tac. Mi caj la' pʌjyel tilel ti' tojlel yumʌlob, ti' tojlel reyob cha'añon cha'an mi' tsictiyel c t'an ti' tojlelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wersa mi' ñaxan subentelob jini wen t'an ti pejtelel lum. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ba' ora mi' chuquetla majlel ti meloñel cha'an mi' yʌq'uetla ti' c'ʌb yumʌlob, mach mi la' wʌn mel la' pusic'al cha'an chuqui mi caj la' sub yic'ot chuqui mi caj la' ña'tan. Subula jini t'an mu' bʌ caj la' wʌq'uentel ti jini jach bʌ ora. Mach jateticla mi la' caj ti t'an pero mu' ti t'an jini Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Winicob mi caj i yʌc'ob ti chʌmel i yʌscun yic'ot i yijts'in. Jini tatʌl mi caj i yʌc' ti chʌmel i yalobil, jini i yalobilob mi caj i contrajiñob i tat i ña', mi caj i tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mi caj la' ts'a'lentel ti pejtelel pañimil cha'an tij c'aba'. Jini mu' bʌ i cuch i wocol c'ʌlʌl ti' jilibal mi caj i coltʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mi caj la' q'uel jini c'ax bibi' jax bʌ wa'al ba' tic'bil, mu' bʌ i jisan cabʌl chuqui an che' bajche' tsi' wʌn subu jini x'alt'an Daniel. (Jini mu' bʌ i q'uel jini jun la' i ch'ʌmben isujm.) Che' mi la' q'uel jini, la' puts'icob majlel ti wits jini año' bʌ ti Judea. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jini am bʌ ti' jol i yotot mach chʌn jubic cha'an mi' loc'san i chubʌ'an ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jini am bʌ ti cholel mach chʌn sujtic cha'an mi' lot i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Obol jax i bʌ jini cʌntʌbilo' bʌ i cha'an alʌl yic'ot jini woli bʌ i tsu'sañob alʌl ti jim bʌ ora. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cha'lenla oración cha'an mach ti' yorajlelic tsʌñal mi la' puts'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Come ti jim bʌ ora mi caj i tilel cabʌl wocol, ñumen bajche' tsa' ñumi c'ʌlʌl ti' cajibal jini pañimil tsa' bʌ i mele Dios, c'ʌlʌl wʌle, c'ʌlʌl ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Che' ti' yorajlel jini wocol, mi ma'anic tsi' com'esa i yorajlel wocol lac Yum, ma'anic majqui mi' coltʌntel mi juntiquilic. Cha'an mi' coltan jini yajcʌbilo' bʌ i cha'an tsi' com'esa i yorajlel wocol. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ti jini jach bʌ ora mi an majch mi' subeñetla: “Awilan, wʌ'an jini Cristo”, o mi an majch mi' subeñetla: “Awilan, ya'an Cristo”, mi che'en, mach mi la' ñop. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Come mi caj i tejchelob jini mu' bʌ i cuyob i bʌ ti Cristo yic'ot lot bʌ x'alt'añob. Mi caj i pʌsob cabʌl i yejtal i p'ʌtʌlel yic'ot bʌbʌq'uen tac bʌ cha'an mi' socob jini yajcʌbilo' bʌ mi tsa' mejli. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chʌcʌ q'uele la' bʌ. Tsa'ix c wʌn subeyetla ti pejtelel jini. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ti jim bʌ ora che' mi' yujtel jini wocol mi caj i yiq'uesʌntel jini q'uin. Ma'anic mi caj i yʌc' i c'ʌc'al uw. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mi caj i yajlel tac jini ec' ti panchan. Jini p'ʌtʌl tac bʌ ti panchan mi caj i ñijcʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ti wi'il mi caj i q'uelob i Yalobil Winic che' mi' tilel ti tocal yic'ot cabʌl i p'ʌtʌlel yic'ot i ñuclel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mi caj i choc majlel i yángelob cha'an mi' tempañob tilel ti' chʌnwejlel pañimil jini yajcʌbilo' bʌ i cha'an ch'oyolo' bʌ ti' ñajtlel pañimil c'ʌlʌl ti' ñajtlel panchan. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ñopola jini lajiya cha'an jini higuera te'. Che' c'unix i c'ʌb che' woli' pasel i yopol, la' wujil lʌc'ʌlix i yorajlel ticwal. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Che' ja'el jatetla, che' mi la' q'uel wolix i yujtel jini, ña'tanla lʌc'ʌlix i tilel i Yalobil Winic. Mero wolix i julel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Isujm mic subeñetla, ti pejtelel jini mi' caj ti ujtel che' wʌ' to an ti pañimil jini winicob x'ixicob año' bʌ wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mi caj i jilel jini panchan yic'ot pañimil, pero mach jilic c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ma'anic majch yujil baqui bʌ q'uin baqui bʌ ora mi' caj ti ujtel jini, mi ángelob ti panchan, mi i Yalobil Dios. Jini jach c Tat yujil. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Chʌcʌ q'uele la' bʌ. Yom yʌxʌl la' wo, come mach la' wujilic baqui ora mi caj i c'otel i yorajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lajalʌch bajche' winic tsa' bʌ majli ti ñajtʌl. Che' bʌ tsi' cʌyʌ i yotot tsi' yʌq'ueyob i ye'tel i winicob. Ti jujuntiquil tsi' subeyob chuqui yom mi' melob. Tsi' sube xcʌntaya cha'an mi' q'uel i ti' otot. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yom yʌxʌl la' wo, che' jini, come mach la' wujilic baqui ora tal i yum otot, mi ti ic'ajel, mi ti ojlil ac'ʌlel, mi che' wolix ti uq'uel mut, mi ti sʌc'ajel. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ame bʌc' julic i tajetla che' wʌyʌletla. ");
INSERT INTO ctuBl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jini mu' bʌ c subeñetla mic subeñob ti pejtelelob. Yom yʌxʌl la' wo. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yom to cha'p'ejl q'uin cha'an i q'uiñilel Pascua che' mi' c'uxob caxlan waj mach bʌ anic i levadurajlel. Jini ñuc bʌ motomajob yic'ot sts'ijbayajob tsi' pejcayob i bʌ cha'an bajche' mi mejlel i chucob Jesús ti lot cha'an mi' tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tsi' yʌlʌyob: Mach ti' yorajlelic q'uiñijel ame tejchicob ti cabʌl a'leya winicob x'ixicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Che' ya'an Jesús ti Betania ti' yotot jini Simón tsa' bʌ lajmesʌbenti leco bʌ i tsoy, che' buchul ti' t'ejl mesa, tsa' tili x'ixic am bʌ i limetej melbil bʌ ti xajlel, but'ul ti xojocña bʌ ts'ac wen letsem bʌ i tojol. Tsi' ts'ita' top'o jini limetej. Tsi' mulbe ti' jol Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ya' añob winicob tsa' bʌ mich'ayob. Tsi' yʌlʌyob: ¿Chucoch tsa' lon jisʌnti jini ts'ac? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Come tsa'ic chojñi jini ts'ac an i tojol ñumen ti jo'lujunc'al (300) denario cha'an mi' yʌq'uentelob jini p'ump'uño' bʌ, che'ob. Tsi' yʌ'leyob jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús tsi' subeyob: Cʌyʌx la' wʌ'len. ¿Chucoch mi la' techben i ch'ijiyemlel i pusic'al? I t'ojol jax jini tsa' bʌ i melbeyon. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Come ti pejtelel ora an jini p'ump'uño' bʌ la' wic'ot. Ba' ora la' wom mi mejlel la' coltañob. Mach ti pejtelelic ora wʌ' añon la' wic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jini x'ixic tsi' mele chuqui tsa' mejli i mel. Tsi' wʌn boño c bʌc'tal cha'an mic mujquel. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Isujm mic subeñetla, baqui jach mi' sujbel jini wen t'an ti pejtelel pañimil, mi caj i sujbel ja'el chuqui tsi' mele jini x'ixic cha'an mi' ña'tʌntel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, i pi'ʌl jini junlujuntiquil, tsa' majli ba'an ñuc bʌ motomajob cha'an mi' yʌc' Jesús ti' c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Che' bʌ tsi' yubiyob, tijicñayob i pusic'al motomajob. Tsi' yʌc'ʌyob i t'an cha'an mi' yʌq'ueñob taq'uin Judas. Che' jini tsa' caji i chajpan i pusic'al cha'an mi' yʌc' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti ñaxan bʌ q'uin che' mi' c'uxob caxlan waj mach bʌ anic i levadurajlel che' mi' tsʌnsañob tiñʌme' cha'an Pascua, jini xcʌnt'añob i cha'an tsi' subeyob: ¿Baqui a wom mic majlel lojon c chajpan cha'an ma' c'ux we'elʌl che' ti Pascua? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesús tsi' choco majlel cha'tiquil xcʌnt'añob i cha'an. Tsi' subeyob: Cucula ti tejclum. Mi caj i tajetla winic woli bʌ i q'uech majlel uc'um. Tsajcanla majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Baqui jach mi' yochel, subenla i yum otot: “Jini Maestro mi' yʌl: ¿Baqui an jump'ejl i mal otot ba' mi mejlel j c'ux we'elʌl cha'an Pascua yic'ot xcʌnt'añob c cha'an?” ");
INSERT INTO ctuBl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jini winic mi caj i pʌsbeñetla colem bʌ i mal otot ti chan, chajpʌbilix bʌ. An i bʌl. Chajpʌbeñonla chuqui tac yom, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tsa' majliyob jini xcʌnt'añob i cha'an. Tsa' ochiyob ti tejclum. Tsi' tajayob jini otot che' bajche' tsi' subeyob. Tsi' chajpayob we'elʌl cha'an Pascua. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Che bʌ wolix i yic'an, tsa' tili Jesús yic'ot jini lajchʌntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Che' buchulob ti' t'ejl mesa che' woliyob ti we'el, Jesús tsi' subeyob: Isujm mic subeñetla, juntiquil woli bʌ i c'ux waj quic'ot mi caj i yʌc'on ti' c'ʌb j contra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ch'ijiyem tsa' caji i yubiñob. Quepecña tsa' caji i yʌlob ti jujuntiquil: ¿Joñon ba? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Tsi' subeyob: Jiñʌch i pi'ʌl jini junlujuntiquil woli bʌ i ts'aj i waj ti ch'ejew quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Melelʌch, i Yalobil Winic mi caj i majlel che' bajche' ts'ijbubil. Jini winic mu' bʌ i yʌc' i Yalobil Winic ti' c'ʌb i contra mi caj i taj wocol. Uts'at machic tsi' yila pañimil jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Che' bʌ tsi' cha'leyob we'el, Jesús tsi' ch'ʌmʌ waj. Tsi' cha'le oración. Tsi' xet'e. Tsi' yʌq'ueyob. Tsi' yʌlʌ: Ch'ʌmʌla, jiñʌch c bʌc'tal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tsi' ch'ʌmʌ vaso. Che' bʌ tsi' sube Dios wocolix i yʌlʌ tsi' yʌq'ueyob. Tsi' japʌyob ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús tsi' subeyob: Jiñʌch c ch'ich'el cha'an jini trato bʌ t'an mu' bʌ i bejq'uel cha'an cabʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Isujm mic subeñetla, ma'anic mic chʌn jap i ya'lel ts'usub jinto mi' tilel jini q'uin che' mic jap jini tsiji' bʌ ti' yumʌntel Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Che' bʌ tsa' ujti i c'ʌyiñob jump'ejl c'ay, tsa' majliyob ti Olivo wits. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús tsi' subeyob: Mi caj i tejchel tile bixel bʌ la' pusic'al ti la' pejtelel cha'añon ti jini jach bʌ ac'ʌlel, come ts'ijbubil: “Mi caj c low xcʌntaya, che'en Dios. Jini tiñʌme' mi caj i pam pujquel”. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Che' tejchemonix ch'ojyel, mic majlel c pijtañetla ti Galilea, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro tsi' sube Jesús: Mi tsa' tejchi tile bixel bʌ i pusic'al pejtelelob, mach joñonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús tsi' sube: Isujm mic subeñet, ti ili ac'ʌlel che' maxto cha'yajlic tsi' cha'le uq'uel mut, mi caj a wʌl mach a cʌñʌyonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro tsi' wersa sube: Anquese wersa mic chʌmel quic'otet, ma'anic mi caj cʌl mach j cʌñʌyetic, che'en. Che' ja'el, tsi' yʌlʌyob ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tsa' tiliyob ti pʌc'ʌbʌl i c'aba' Getsemaní. Jesús tsi' sube xcʌnt'añob i cha'an: Buchi'la ilayi che' mic cha'len oración, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tsi' pʌyʌ majlel Pedro yic'ot Jacobo yic'ot Juan. Ch'ijiyem tsa' caji i yubin Jesús. Tsi' wen mele i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tsi' subeyob: Wen ch'ijiyem c pusic'al, comix chʌmel ti' ch'ijiyemlel c pusic'al. Pijtanla wʌ'i. Yom yʌxʌl la' wo, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tsa' to i ts'ita' xʌñʌ majlel. Tsi' pʌcchoco i bʌ ti lum. Tsi' c'ajtibe Dios cha'an ma'anic mi' c'otel i yorajlel jini wocol mi tsa' mejli ti tijq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jesús tsi' yʌlʌ: Papa, c Tat, ti pejtelel mi mejlel a mel. Loc'sʌbeñon ili wocol, pero mach ma' mel chuqui com, mele chuqui yom a pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tsa' tili Jesús, tsi' taja wʌyʌlob. Tsi' sube Pedro: ¿Simón, wʌyʌlet ba? ¿Mach ba anic tsa' mejli a tic' a wʌyel mi jump'ejlic ora? ");
INSERT INTO ctuBl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yom yʌxʌl la' wo. Cha'lenla oración cha'an ma'anic mi la' jac' la' pʌyol ti mulil. Come la' wom la' mel chuqui uts'at, pero c'uñatax la' bʌc'tal, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Tsa' cha' majli. Tsi' cha'le oración. Lajal tsi' cha'le t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tsa' cha' tili. Tsi' cha' tajayob, wʌyʌlob come suts'ob jax i wut. Ma'anic chuqui tsa' mejli i yʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ti' yuxyajlel tsa' tili Jesús. Tsi' subeyob: Cha'lenixla wʌyel, c'ajax la' wo. Jasʌlix. I yorajlelix wʌle. Awilan, i Yalobil Winic woli' yʌjq'uel ti' c'ʌb xmulilob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ch'ojyenla. Conixla. Awilan, lʌc'ʌl an jini mu' bʌ i yʌc'on ti' c'ʌb j contra, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Che' bʌ woli to ti t'an tsa' bʌc' tili Judas, i pi'ʌl jini junlujuntiquil. Tsa' tili yic'ot cabʌl año' bʌ i yespada yic'ot te' tac chocbilo' bʌ tilel i cha'an ñuc bʌ motomajob yic'ot sts'ijbayajob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jini Judas tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra tsi' wʌn subeyob bajche' mi caj i cʌñob: Jini mu' bʌ c ts'ujts'un, jiñʌch. Chucula, pʌyʌla majlel ti uts'at. Che' tsi' yʌlʌ Judas. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Che' bʌ tsa' tili ba'an Jesús tsi' bʌc' lʌc'tesa i bʌ. Tsi' yʌlʌ: Maestro, Maestro, che'en. Tsi' ts'ujts'u. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tsi' chucuyob. Tsi' pʌyʌyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Juntiquil ya' bʌ an tsi' bots'o i yespada. Tsi' lowo jini x'e'tel i cha'an jini c'ax ñuc bʌ motomaj. Tsi' wel tsepbe loq'uel i chiquin. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús tsi' subeyob: ¿Tsa' ba tiliyetla cha'an mi la' chucon che' bajche' mi la' chuc xujch' yic'ot espada yic'ot te'? ");
INSERT INTO ctuBl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Añon la' wic'ot ti jujump'ejl q'uin ti Templo. Tsac cha'le cʌntesa. Ma'anic tsa' la' chucuyon. Pero che'ʌch woli' yujtel cha'an mi' ts'ʌctiyel i Ts'ijbujel Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ti pejtelel xcʌnt'añob tsi' cʌyʌyob Jesús. Tsa' puts'iyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Juntiquil ch'iton winic tsa' bʌ i bʌc'ʌ i bʌ ti pisil tsi' tsajca majlel Jesús. Winicob tsi' chucuyob jini ch'iton. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jini tsi' cʌyʌ jini pisil. Pits'ilix tsa' puts'i. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tsi' pʌyʌyob majlel Jesús ba'an jini c'ax ñuc bʌ motomaj. Pejtelel ñuc bʌ motomajob yic'ot jini xñoxob am bʌ i ye'tel yic'ot sts'ijbayajob tsi' tempayob i bʌ ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro tsi' ñajti tsajca majlel Jesús. Tsa' ochi ti' pam i yotot jini c'ax ñuc bʌ motomaj. Tsa' buchle yic'ot xcʌntayajob. Tsi' q'uixñesa i bʌ ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jini ñuc bʌ motomajob yic'ot pejtelel año' bʌ i ye'tel tsi' sajcayob mu' bʌ i cha'leñob jop'tan ti' contra Jesús cha'an mi' yʌc'ob ti chʌmel. Ma'anic tsi' tajayob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Come cabʌlob tsi' jop'oyob t'an ti' contra Jesús. Mach junlajalic i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsa' wa'leyob winicob tsa' bʌ i jop'oyob t'an ti' contra. Tsi' yʌlʌyob: ");
INSERT INTO ctuBl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Tsa cubi lojon che' bʌ tsi' yʌlʌ: “Mi caj c jisan jini Templo melbil bʌ ti c'ʌbʌl. Ti uxp'ejl q'uin mi caj c wa'chocon yambʌ mach melbilic ti c'ʌbʌl”. Che' tsi' yʌlʌ Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero mach junlajalic i t'an tsa' bʌ i subuyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jini c'ax ñuc bʌ motomaj tsa' wa'le ti ojlil. Tsi' c'ajtibe Jesús: ¿Mach ba anic chuqui ma' jac'? ¿Chuqui jini mu' bʌ i subob winicob ti a contra? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ñʌch'ʌl tsa' cʌle. Ma'anic chuqui tsi' jac'ʌ. Jini c'ax ñuc bʌ motomaj tsi' cha' c'ajtibe: ¿Jatet ba Cristojet, jini Yajcʌbil bʌ, i Yalobilet ba jini Uts'at Bʌ? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús tsi' sube: Joñon cu. Mi caj la' q'uel i Yalobil Winic buchul ti' ñoj jini p'ʌtʌl bʌ Dios. Mi caj la' q'uel che' mi' tilel ti tocal ti panchan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jini c'ax ñuc bʌ motomaj tsi' tsili i pislel. Tsi' yʌlʌ: ¿Chuqui to i c'ʌjñibal xtoj'esa t'añob? ");
INSERT INTO ctuBl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tsa'ix la' wubi i p'ajoñel. ¿Chuqui mi la' wʌl? che'en jini c'ax ñuc bʌ motomaj. Ti pejtelel tsi' yʌlʌyob wersa yom mi' yʌjq'uel ti chʌmel cha'an i mul. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","An tsa' bʌ caji i tujbañob Jesús. Tsi' mosbeyob i wut. Tsi' jats'ʌyob. Tsi' subeyob: Pʌsbeñon lojon mi x'alt'añet, che'ob. Jini xcʌntayajob tsi' poch'iyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Che' ya'to an Pedro ti entʌl ti pam otot, tsa' tili juntiquil i criada jini c'ax ñuc bʌ motomaj. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Che' bʌ tsi' q'uele woli' q'uixñesan i bʌ Pedro, tsi' wen q'uele. Tsi' yʌlʌ: Jatet ja'el añet yic'ot Jesús ch'oyol bʌ ti Nazaret, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro tsi' yʌlʌ mach isujmic. Tsi' yʌlʌ: Mach cujilic chuqui ma' wʌl. Ma'anic mic ch'ʌmben isujm, che'en. Tsa' majli ti' ti' corredor. Tsi' cha'le jun'uq'uel tat mut. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jini criada tsi' cha' q'uele. Tsa' caji i suben jini lʌc'ʌl bʌ añob: Jini winic jiñʌch xcʌnt'an i cha'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro tsi' cha' alʌ mach isujmic. Ti jumuc' jach jini lʌc'ʌl bʌ añob tsi' cha' subeyob Pedro: Isujm jatet xcʌnt'añet i cha'an come ch'oyolet ti Galilea. Lajal a t'an che' bajche' i t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro tsa' caji i bajñel ch'ʌc i bʌ. Tsi' wersa wa'choco i t'an. Tsi' yʌlʌ: Ma'anic mij cʌn jini winic mu' bʌ la' taj ti t'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tsi' cha' cha'le uq'uel mut cha'yajlelix. Tsa' c'ajtiyi ti' pusic'al Pedro i t'an Jesús tsa' bʌ i sube: “Che' maxto i cha'yajlic mi' cha'len uq'uel tat mut, uxyajl mi caj a wʌl mach a cʌñʌyonic”. Che' bʌ tsi' ña'ta Pedro, tsi' cha'le uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ti sʌc'ajel tsi' tempayob i bʌ ti t'an jini ñuc bʌ motomajob yic'ot jini xñoxob am bʌ i ye'tel yic'ot sts'ijbayajob yic'ot pejtelel año' bʌ i ye'tel. Cʌchʌl tsi' pʌyʌyob majlel Jesús. Tsi' yʌc'ʌyob ti' c'ʌb Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato tsi' c'ajtibe: ¿Jatet ba i Reyet judíojob? che'en. Jesús tsi' sube: Isujm bajche' ma' wʌl, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jini ñuc bʌ motomajob cabʌl tsi' pʌc'ʌyob ti mulil Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato tsi' cha' c'ajtibe: ¿Mach ba anic chuqui ma' jac'? Ubin jaychajp woli' yʌlob ti a contra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma'anic tsi' chʌn jac'ʌ Jesús. Jini cha'an tsa' toj sajti i pusic'al Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","I tilelʌch jini gobernador mi' yʌc' ti colel juntiquil xñujp'el majqui jach c'ajtibil i cha'an winicob che' woli' melob q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ya' ñup'ulob winicob tsa' bʌ i cha'leyob tsʌnsa che' bʌ tsi' contrajiyob gobierno. Juntiquil i c'aba' Barrabás. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Che' bʌ tsa' tiliyob winicob tsa' caji i c'ajtibeñob Pilato cha'an mi' cha'len che' bajche' i tilel. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato tsi' jac'beyob: ¿La' wom ba mi cʌc' ti colel i Rey judíojob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Come Pilato yujil tsa' jach i yʌc'ʌyob Jesús ti' c'ʌb cha'an tsʌytsʌyñayob i pusic'al jini ñuc bʌ motomajob cha'an i ñuclel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jini ñuc bʌ motomajob tsi' xic'beyob winicob cha'an mi' c'ajtiñob ti colel Barrabás. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato tsi' cha' c'ajtibeyob: ¿Chuqui la' wom mic tumben jini mu' bʌ la' pejcan ti' Rey judíojob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tsa' cha' cajiyob ti c'am bʌ t'an: ¡Ch'iji ti cruz! che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato tsi' subeyob: ¿Chuqui ti jontolil tsi' cha'le? che'en. Tsa' utsi cajiyob ti c'am bʌ t'an: ¡Ch'iji ti cruz! che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato yom i mel bajche' yomob winicob. Jini cha'an tsi' yʌc'ʌ ti colel Barrabás. Che' bʌ tsa' ujti i jats' Jesús ti asiyal, tsi' yʌc'ʌ ti' c'ʌb soldadojob cha'an mi' ch'ijob ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jini soldadojob tsi' pʌyʌyob majlel. Tsa' ochiyob ti jump'ejl i mal colem otot i c'aba' pretorio. Tsi' pʌyʌyob tilel pejtelel soldadojob ti junmojtlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tsi' lʌpbeyob chʌcchojan bʌ i pislel. Che' bʌ tsi' xot jalʌyob ch'ix, tsi' joy ñet'beyob ti' jol Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsa' caji i yʌq'ueñob cortesía: Cotañet i Reyet judíojob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tsi' jats'beyob i jol ti sic'ʌb. Tsi' tujbayob. Tsi' ñocchocoyob i bʌ che' bajche' woli' ch'ujutesañob yilal. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Che' bʌ tsa' ujti i wajleñob, tsi' jochbeyob jini chʌccojan bʌ bujcʌl. Tsi' cha' lʌpbeyob i pislel. Tsi' pʌyʌyob majlel cha'an mi' ch'ijob ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simón ch'oyol bʌ ti Cirene woli' ñumel majlel, loq'uemix tilel ti xchumtʌl. Jiñʌch i tat Alejandro yic'ot Rufo. Wersa tsi' yʌq'ueyob i q'uechben majlel i cruz Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tsi' pʌyʌyob majlel c'ʌlʌl ti bujtʌl i c'aba' Gólgota, mi' yʌl ti lac t'an che' yilal bajche' i bʌquel jolʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tsi' yʌq'ueyob vino xʌbʌl yic'ot mirra cha'an mi' jap. Ma'anic tsi' ch'ʌmʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tsi' ch'ijiyob ti cruz. Tsi' pucbeyob i bʌ i pislel Jesús. Tsi' cha'leyob yajcaya ti alas cha'an mi' ña'tañob baqui bʌ mi' ch'ʌmob ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yom to uxp'ejl ora cha'an xinq'uiñil che' bʌ tsi' ch'ijiyob ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jiñʌch jini ts'ijbubil bʌ ti' contra Jesús: I REY JUDIOJOB. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tsi' ch'ijiyob ti cruz cha'tiquil xujch' yic'ot Jesús, juntiquil ti' ñoj, juntiquil ti' ts'ej. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Tsa' ts'ʌctiyi i Ts'ijbujel Dios mu' bʌ i yʌl: Tsa' tsijqui yic'ot xmulilob. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jini woliyo' bʌ ti ñumel tsi' p'ajayob. Tsi' ñijcayob i jol. Tsi' subeyob: Aja. Jatet, mu' bʌ a jisan i Templo Dios mu' bʌ a cha' wa'chocon ti uxp'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Coltan a bʌ, juben ti cruz, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Che' ja'el ñuc bʌ motomajob tsi' wajleyob yic'ot jini sts'ijbayajob. Tsi' subeyob i bʌ: Tsi' colta yaño' bʌ. Mach mejlic i coltan i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","La' jubic ti cruz jini Cristo, i Rey Israel, cha'an mi laj q'uel, cha'an mi lac ñop, che'ob. Jini tsa' bʌ ch'ijleyob ti cruz yic'ot Jesús tsi' wajleyob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ti xinq'uiñil tsa' ic'a pejtelel pañimil c'ʌlʌl ti och'ajel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ti och'ajel q'uin wen c'am tsi' cha'le t'an Jesús. Tsi' yʌlʌ: Eloi, Eloi, ¿lama sabactani? che'en. Mi' yʌl ti lac t'an: C Dios, c Dios, ¿chucoch tsa' cʌyʌyon? ");
INSERT INTO ctuBl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Che' bʌ tsi' yubiyob jini lʌc'ʌl bʌ añob, lamital tsi' yʌlʌyob: Awilan, woli' pʌy tilel Elías, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Juntiquil tsa' majli ti ajñel cha'an mi' yʌc' chʌyo'ja' i chʌy vinagre. Tsi' yʌc'ʌ ti' ñi' te'. Tsi' yʌq'ue cha'an mi' ts'ujts'un. Tsi' yʌlʌ: Pijtanla. La' laj q'uel mi tal Elías cha'an mi' ju'san, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús wen c'am tsi' cha'le t'an. Tsa' chʌmi. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jini pisil joc'ol bʌ ti Templo tsa' tsijli jubel ti' jol c'ʌlʌl ti yoc. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ya'an i yaj capitán jo'c'al soldadojob ti' tojel i wut Jesús. Che' bʌ tsi' q'uele woli ti t'an che' bʌ tsa' chʌmi, tsi' yʌlʌ: Isujmʌch i Yalobilʌch Dios jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ya' añob x'ixicob ja'el woli' ñajti q'uelob. Ya'an María ch'oyol bʌ ti Magdala yic'ot Salomé yic'ot María i ña' José, yic'ot Jacobo jini ijts'iñil bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jiñob tsi' tsajcayob Jesús che' an to ti Galilea. Tsi' we'sayob majlel. Ya' añob yic'ot cabʌl x'ixicob tsa' bʌ letsiyob tilel ti Jerusalén yic'ot Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","I q'uiñilelʌch chajpaya come ti yijc'ʌlal mi' c'ajob i yo. Tsa' bʌjli q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tsa' tili José ch'oyol bʌ ti Arimatea, am bʌ ñuc bʌ i ye'tel, yic'ot yaño bʌ. Jini ja'el woli' pijtan i yumʌntel Dios. Ch'ejl i pusic'al tsa' ochi ba'an Pilato. Tsi' c'ajtibe i bʌc'tal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato ma'anic tsi' ñopo mi tsa'ix chʌmi Jesús. Tsi' pʌyʌ tilel juntiquil capitán. Tsi' c'ajtibe mi chʌmenix Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Che' yujlix cha'an ti' t'an capitán chʌmenix Jesús, Pilato tsi' yʌq'ue José i bʌc'tal. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José tsi' mʌmbe i bʌjq'uil. Tsi' ju'sʌbe i bʌc'tal Jesús. Tsi' bʌc'ʌ ti' bʌjq'uil. Tsi' ñolchoco ti' yotlel ch'ujlelʌl tocbil bʌ i mal xajlel. Tsi' selc'u majlel xajlel ti' ti' i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María ch'oyol bʌ ti Magdala yic'ot María i ña' José tsi' q'ueleyob ba' tsa' ñolchoconti. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Che' bʌ tsa' ñumi jini q'uin che' mi' c'ajob i yo, María ch'oyol bʌ ti Magdala, yic'ot Salomé, yic'ot María i ña' Jacobo, tsi' mʌñʌyob xojocña bʌ ts'ac cha'an mi' majlel i boñob. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wen seb to ti jini ñaxan bʌ q'uin ti semana tsa' majliyob ti' yotlel ch'ujlelʌl che' pasemix q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tsi' pejcayob i bʌ: ¿Majqui mi caj i selc'ubeñonla loq'uel xajlel am bʌ ti' ti' i yotlel ch'ujlelʌl? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Che' bʌ tsi' yilayob, tsi' q'ueleyob selc'ubilix loq'uel jini xajlel. Wen colem jini xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Che' bʌ tsa' ochiyob ti' yotlel ch'ujlelʌl, tsi' q'ueleyob ch'iton winic buchul ti' ñoj, lʌpʌl i cha'an tam bʌ i pislel wen sʌsʌc bʌ. Tsa' toj sajtiyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jini winic tsi' subeyob: Mach la' cha'len bʌq'uen. Woli la' sajcan Jesús ch'oyol bʌ ti Nazaret jini tsa' bʌ ch'ijle ti cruz. Tsa'ix ch'ojyi. Mach wʌ'ix an. Q'uelela i yajñib ba' tsi' ñolchocoyob. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cucula, subenla xcʌnt'añob i cha'an yic'ot Pedro woli' majlel Jesús i pijtañetla ti Galilea. Ya'i mi caj la' q'uel che' bajche' tsi' subeyetla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jini x'ixicob tsa' loq'uiyob majlel ti ajñel ba'an i yotlel ch'ujlelʌl come tsiltsilñayob ti bʌq'uen. Ma'anic chuqui tsi' subeyob yaño' bʌ come woliyob ti bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Che' bʌ tsa' ch'ojyi Jesús ti sʌc'ajel ti ñaxan bʌ q'uin ti semana, tsa' ñaxan tsictiyi ti' wut María ch'oyol bʌ ti Magdala. Jiñʌch tsa' bʌ chocbenti loq'uel wuctiquil xiba ti' pusic'al ti' p'ʌtʌlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jini María tsa' majli i suben jini xcʌnt'añob tsa' bʌ i pi'leyob ti xʌmbal Jesús. Woliyob ti uq'uel, ch'ijiyemob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Che' bʌ tsi' yubiyob cha' cuxulix Jesús, q'uelelix i cha'an jini x'ixic, ma'anic tsi' ñopbeyob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ti wi'il tsa' tsictiyi Jesús ti' wut cha'tiquil woli bʌ i cha'leñob xʌmbal majlel ti bij. Mach che'ic tsi' pʌsʌ i bʌ bajche' ti ñaxan. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jini cha'tiquil tsa' majli i subeñob yaño' bʌ winicob, pero ma'anic tsi' ñopbeyob i t'an ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ti wi'il tsa' tsictiyi Jesús ti' wut jini junlujuntiquil che' buchulob ti' t'ejl mesa. Jesús tsi' yʌ'leyob cha'an i tsʌtslelob i pusic'al cha'an ma'anic tsi' ñopoyob. Come ma'anic tsi' ñopbeyob i t'an jini tsa' bʌ i q'ueleyob Jesús che' bʌ tejchemix ch'ojyel. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesús tsi' subeyob: Cucula ti pejtelel pañimil. Subenla jini wen t'an pejtelel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jini mu' bʌ i ñop mu' bʌ i ch'ʌm ja' mi caj i coltʌntel. Jini mach bʌ anic mi' ñop mi caj i yʌjq'uel ti tojmulil. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mi' caj ti tsictiyel i yejtal c p'ʌtʌlel ti jini mu' bʌ i ñopob: Tij c'aba' mi caj i chocob loq'uel xibajob. Mi' cajelob ti t'an ti yan tac bʌ t'an. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mi caj i chucob lucum. Mi an chuqui tac mi' japob am bʌ i venenojlel, ma'anic mi caj i yubiñob wocol. Mi caj i yʌc'ob i c'ʌb ti xc'amʌjelob. Mi caj i lajmelob. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lac Yum Jesús che' bʌ tsa' ujti i subeñob jini t'an, tsa' pʌjyi letsel ti panchan. Tsa' buchle ti' ñoj Dios. ");
INSERT INTO ctuBl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jini junlujuntiquil tsa' majliyob. Tsi' cha'leyob subt'an ti pejtelel lum. Lac Yum tsi' tem cha'le e'tel yic'otob. Tsi' pʌsʌ i yejtal tac i p'ʌtʌlel ti' tojlelob che' bʌ tsi' cha'leyob sub t'an.");
INSERT INTO ctuBl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Cabʌlob tsi' ts'ijbayob chuqui tac tsa' ts'ʌctiyi ti isujm ti lac tojlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Lajal tsi' ts'ijbayob bajche' tsi' cʌntesayonla jini tsa' bʌ i q'ueleyob c'ʌlʌl ti' cajibal. Jiñobʌch mu' bʌ i subob jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jini cha'an che' bʌ tsa' ujti c ña'tan ti toj i sujmlel pejtelel chuqui tsa' ujti c'ʌlʌl ti' cajibal, joñon ja'el tsac ña'ta uts'at mic ts'ijbubeñet ti quepecña, uts'at bʌ Teófilo. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wolic ts'ijbubeñet ili jun cha'an ma' wen cʌn i sujmlel jini tsa' bʌ subentiyet. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti' yorajlel Herodes, jini rey ti Judea, an motomaj i c'aba' Zacarías lajal bʌ i ye'tel bajche' Abías. An i yijñam Zacarías i c'aba' Elisabet, loq'uem bʌ ti' p'olbal Aarón. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tojob ti' tojlel Dios ti cha'ticlel. Ts'ʌcʌl tsi' jac'ʌyob pejtelel i subal lac Yum yic'ot i mandar. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ma'añobic i yalobil, come to'o wa'al jach bʌ x'ixic jini Elisabet. Cabʌlix i jabilel ti cha'ticlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zacarías tsi' cha'le i ye'tel ti motomaj ti' tojlel Dios che' an ti' wenta. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Come i tilel mi' cha'leñob yajcaya che' mi' q'uexob i bʌ jini motomajob. Tsa' ochi ti' wenta Zacarías cha'an mi' yochel ti' Templo lac Yum cha'an mi' pul pom. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pejtelel winicob x'ixicob añob ti jumpat. Woli' pejcañob Dios ti' yorajlel che' mi' pulel pom. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tsa' tsictiyi ti' wut Zacarías i yángel lac Yum, wa'al ti' ñoj ba'an i pulʌntib pom. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tsiltsilña Zacarías che' bʌ tsi' q'uele. Tsa' wen caji ti bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jini ángel tsi' sube: Mach a cha'len bʌq'uen Zacarías, come tsa' ubinti a woración. Mi caj i tsictiyel i yalobil a wijñam Elisabet. Mi caj i yilan pañimil ch'iton bʌ a walobil. Mi caj a wotsʌben i c'aba' Juan. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tijicña mi caj a wubin. Mi caj i ñuc'an a pusic'al. Tijicña jax mi caj i yubiñob cabʌlob che' mi yilan pañimil a walobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Come ñuc mi caj i q'uejlel a walobil ti' tojlel Dios. Ma'anic mi caj i jap vino mi lembal. C'ʌlʌl che' cʌntʌbil, but'ul ti Ch'ujul bʌ Espíritu mi caj i yajñel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Mi caj i yʌq'ueñob i sutq'uin i bʌ cabʌl israelob cha'an mi' ñopob i Yum Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mi caj i majlel a walobil ñaxan ti' tojlel Lac Yum. Lajal i ye'tel yic'ot i p'ʌtʌlel bajche' Elías. Mi caj i yʌq'ueñob i pusic'al tatʌlob cha'an mi' c'uxbiñob i yalobil. Mi caj i yʌq'ueñob i pusic'al xñusa mandarob cha'an mi' tajob i ña'tʌbal lajal bajche' jini tojo' bʌ. Che' jini mi caj i yʌq'ueñob winicob x'ixicob i chajpañob i pusic'al cha'an lac Yum. Che' tsi' yʌlʌ jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías tsi' sube jini ángel: ¿Bajche' mi caj c ña'tan mi isujm jini? Joñon ñoxonix. Anix cabʌl i jabilel quijñam ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jini ángel tsi' sube: Joñon Gabrielon. Añon ti' tojlel Dios. Chocbilon tilel cha'an mic pejcañet cha'an mic subeñet jini wen t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Awilan, mi caj a wochel ti uma'. Ma'anic mi caj a mejlel ti t'an c'ʌlʌl ti jini q'uin che' mi' yujtel jini tsa' bʌ c subeyet. Come ma'anic tsa' ñopo c t'an cha'an jini mu' bʌ caj ti ujtel che' ti' yorajlel, che'en jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Che' bʌ woli' chʌn pijtañob Zacarías jini winicob x'ixicob, tsi' c'ajtibeyob i bʌ chucoch tsa' chʌn jale Zacarías ti Templo. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Che' bʌ tsa' loq'ui tilel Zacarías, ma'anic tsa' mejli i pejcañob. Tsi' ña'tayob an chuqui tsi' q'uele Zacarías ti Templo ch'oyol bʌ ti panchan. Tsa' jach i pejcayob ti' c'ʌb. Tsa' cʌle ti x'uma'. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Che' bʌ tsa' ujti i mel i ye'tel, tsa' majli Zacarías ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ti wi'il tsa' caji i cʌntan i yalobil Elisabet. Jo'p'ejl uw ma'anic tsa' majli ba'an i pi'ʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tsi' yʌlʌ: Tsa'ix i coltayon c Yum. Tsi' yʌc'ʌ ti lajmel c wajlentel ti' tojlel winicob x'ixicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ti' wʌcp'ejlel uw Dios tsi' choco tilel jini ángel Gabriel ti jump'ejl tejclum ya' ti Galilea i c'aba' Nazaret. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tsa' tili jini ángel ba'an juntiquil tsijib xch'oc c'ajtibil bʌ i cha'an José. Jini José loq'uem ti' p'olbal David. I c'aba' jini xch'oc María. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Che' bʌ tsa' ochi ángel ya' ba'an María tsi' sube: Cotañet. Uts'at woli' q'uelet Dios. An lac Yum a wic'ot. X'ixicob mi caj i subob a ñuclel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tsiltsilña jax i pusic'al María che' bʌ tsi' q'uele jini ángel. Tsa' caji ti t'an ti' pusic'al cha'an jini tsa' bʌ i yʌlʌ ángel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jini ángel tsi' sube: Mach ma' cha'len bʌq'uen, María, come uts'at woli' q'uelet Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mi caj a cʌntan alʌl. Mi caj i yilan pañimil ch'iton bʌ a walobil. Mi caj a wotsʌben i c'aba' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mi caj i q'uejlel ti ñuc. Mi caj i pejcʌntel ti' Yalobil jini C'ax Ñuc bʌ. Lac Yum Dios mi caj i yʌq'uen i ye'tel ti Rey ti' q'uexol i ñojte'el, i c'aba' David. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mi caj i cha'len i ye'tel ti Rey ti' tojlel i p'olbal Jacob ti pejtelel ora. Ma'anic mi caj i jilel i yumʌntel, che'en jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María tsi' sube jini ángel: ¿Bajche' mi caj i yujtel jini? come maxto anic winic quic'ot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jini ángel tsi' sube: Mi caj i yochel jini Ch'ujul bʌ Espíritu ti a tojlel. I p'ʌtʌlel jini C'ax Ñuc Bʌ mi caj i moset. Jini cha'an jini ch'ujul bʌ alʌl mu' bʌ caj i yilan pañimil mux i pejcʌntel ti' Yalobil Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Awilan, a pi'ʌl Elisabet ja'el wolix i cʌntan ch'iton bʌ i yalobil, anquese cabʌlix i jabilel. Wʌcp'ejlix uw woli' cʌntan alʌl jini tsa' bʌ ajli ti to'o wa'al jach bʌ x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Come ma'anic chuqui mach mejlic i mel Dios. Che' tsi' yʌlʌ jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María tsi' yʌlʌ: Joñon x'e'telon i cha'an lac Yum. La' melbenticon che' bajche' tsa' wʌlʌ, che'en. Tsa' loq'ui majlel ángel ba'an María. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Che' ñumenix cha'p'ejl uxp'ejl q'uin tsa' caji ti xʌmbal María. Tsi' se'ñu majlel i bʌ ti wits c'ʌlʌl ti jump'ejl tejclum ya' ti Judá. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tsa' ochi ti' yotot Zacarías. Tsi' yʌq'ue cortesía Elisabet. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Che' bʌ tsi' yubibe i t'an María jini Elisabet, jini alʌl cʌntʌbil bʌ i cha'an Elisabet tsʌts tsi' ñijca i bʌ ti' ñʌc' i ña'. Tsa' bujt'i Elisabet ti Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tsa' caji i cha'len c'am bʌ t'an: Mi caj a sujbel ti ñuc cha'an x'ixicob. Mi caj i sujbel ti ñuc jini alʌl cʌntʌbil bʌ a cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ñucon ba cha'an mi' jula'tañon i ña' c Yum? ");
INSERT INTO ctuBl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Awilan che' bʌ tsa' ochi a t'an tic chiquin, jini alʌl cʌntʌbil bʌ c cha'an tsʌts tsi' ñijca i bʌ cha'an i tijicñʌyel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tijicñayet cha'an tsa' ñopbe i t'an lac Yum mu' bʌ caj i ts'ʌctiyel, che'en Elisabet. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María tsi' yʌlʌ: Mic sub i ñuclel lac Yum ti pejtelel c pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tijicña c ch'ujlel cha'an Dios Xcoltaya c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios tsi' q'uele mach ñuquic jini x'e'tel i cha'an. Come awilan, winicob x'ixicob yic'ot i p'olbalob ti lajm ti lajm mi caj i yʌlob tijicñayon. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Come jini Am bʌ i P'ʌtʌlel tsi' melbeyon chuqui tac ñuc. Ch'ujul i c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mi' p'untan winicob x'ixicob yic'ot i yalobilob mu' bʌ i bʌc'ñañob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsa'ix i pʌsʌ i p'ʌtʌlel i c'ʌb yic'ot ñuc bʌ i melbal. Tsi' pucu majlel jini tsa' bʌ i q'ueleyob i bʌ ti ñuc ti' bajñel ña'tʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tsi' chilbeyob i ye'tel jini tsa' bʌ buchleyob ti ñuc bʌ i ye'tel. Tsi' yʌq'ueyob i ñuclel jini mach bʌ ñucobic. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tsi' lajmesʌbeyob i wi'ñal jini wi'ñayo' bʌ yic'ot cabʌl chuqui tac wen. To'ol che jach tsi' choco majlel jini wen chumulo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tsi' colta israelob, i winicob, cha'an c'ajal i cha'an bajche' yom i p'untañob, ");
INSERT INTO ctuBl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","che' bajche' tsi' pejcayob lac ñojte'el Abraham yic'ot pejtelel i p'olbal, che'en María. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ya' to tsa' jal'a María che' bajche' uxp'ejl uw yic'ot Elisabet. Ti wi'il tsa' sujti ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsa' c'oti i yorajlel cha'an mi' yilan pañimil i yalobil Elisabet. Tsi' yʌc'ʌ ti pañimil ch'iton bʌ i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I pi'ʌlob ti chumtʌl yic'ot i pi'ʌlob Elisabet tsi' yubiyob bajche' Dios tsi' p'unta Elisabet. Tijicñayob i pusic'al yic'ot Elisabet. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ti' waxʌcp'ejlel q'uin tsa' tiliyob cha'an mi' tsepbentel i pʌchʌlel jini alʌl ch'iton. Yom i yotsʌbeñob i c'aba' Zacarías ti' q'uexol i tat. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero i ña' jini alʌl tsi' subeyob: Mach che'ic yom. Mi caj i yotsʌbentel i c'aba' Juan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","I pi'ʌlob tsi' subeyob Elisabet: Ma'anic a pi'ʌlob am bʌ i c'aba' ti Juan, mi juntiquilic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Tsa' caji i pejcañob Zacarías ti' c'ʌb cha'an mi' c'ajtibeñob bajche' yom i yotsʌben i c'aba' i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tsi' c'ajti jun. Tsi' ts'ijba: I c'aba'ʌch Juan. Che' tsi' ts'ijba. Tsa' toj sajtiyob i pusic'al ti pejtelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ti ora tsa' cha' caji ti t'an. Tsa' jijti i yac' Zacarías. Tsi' subu i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tsa' cajiyob ti bʌq'uen pejtelel i pi'ʌlob ti chumtʌl. Ti pejtelel wits ya' ti Judea tsa' caji ti sujbel pejtelel ili tsa' bʌ ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pejtelel tsa' bʌ i yubiyob tsi' lotoyob ti' pusic'al. Tsi' yʌlʌyob: ¿Chuqui mi caj i cha'len jini alʌl? che'ob. Tsa' tsictiyi i p'ʌtʌlel lac Yum yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, i tat jini alʌl, tsa' bujt'i ti Ch'ujul bʌ Espíritu. Tsa' caji ti subt'an. Tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","La' sujbic ti ñuc lac Yum Dios, i Dios Israel. Tsa'ix tili ba'an i cha'año' bʌ. Tsa'ix i mʌñʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tsa'ix i yʌq'ueyonla p'ʌtʌl bʌ Xcoltaya loq'uem bʌ ti' p'olbal David, x'e'tel bʌ i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Che'ʌch tsi' cha'le t'an Dios yic'ot ch'ujul bʌ x'alt'añob i cha'an ti wajali. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Dios tsi' yʌlʌ mi caj laj coltʌntel loq'uel ti' c'ʌb laj contrajob yic'ot ti' c'ʌb pejtelel mu' bʌ i ts'a'leñonla. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Che' jini mi caj i p'untañonla che' bajche' tsi' subeyob lac ñojte'el. Mi caj i ña'tan jini ch'ujul bʌ xuc'ul bʌ t'an ");
INSERT INTO ctuBl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","che' bajche' tsi' sube lac tat Abraham ba' ora tsi' wa'choco i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Mi caj i yʌq'ueñonla lac cha'liben i ye'tel che' coltʌbilonixla loq'uel ti' c'ʌb laj contrajob. Che' jini ma'anic bʌq'uen mi caj lac cha'liben i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Che' jini ch'ujulonla, tojonla ti' wut Dios mi mejlel lac melben i ye'tel ti pejtelel q'uin che' cuxulon to la. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jatet, alʌl, mi caj a pejcʌntel ti x'alt'an i cha'an jini C'ax Ñuc Bʌ. Come mi caj a majlel ñaxan ti' wut lac Yum cha'an ma' chajpʌben i bijlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mi caj a wʌq'ueñob winicob x'ixicob i cʌn bajche' mi caj i coltʌntelob che' mi' ñusʌbentelob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Come cabʌl tsi' p'untayonla lac Dios. Mi caj i chocbeñonla tilel i sʌclel pañimil ch'oyol bʌ ti chan. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Che' jini mi caj i yʌq'ueñob i sʌclel pañimil jini chumulo' bʌ ti ic'ch'ipan bʌ pañimil, jini mach bʌ jalic mi caj i chʌmelob. Mi caj i toj'esañonla majlel ba' ñʌch'ʌl mi la cajñel. Che' tsi' yʌlʌ Zacarías. ");
INSERT INTO ctuBl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tsa' coli jini alʌ Juan. Tsi' taja i p'ʌtʌlel i pusic'al. Tsa' ajni ti colem bʌ i tiquiñal pañimil jinto tsa' pʌsle ba'an israelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti jim bʌ ora tsi' cha'le mandar Augusto César cha'an mi' yʌc'ob tojoñel winicob ti pejtelel lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Tsi' yʌc'ʌyob tojoñel ñaxan che' woli' cha'len i ye'tel ti gobernador ya' ti Siria jini Cirenio. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ti pejtelelob tsa' letsiyob majlel ti tejclum tac ba' chucbil i c'aba' i tat i ña' cha'an mi' yʌc'ob tojoñel. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tsa' loq'ui José ti Nazaret ya' ti Galilea. Tsa' letsi majlel ti Judea ti' tejclum David i c'aba' Belén, come loq'uem ti' p'olbal David jini José. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ya' tsa' majli José cha'an mi' yʌc' tojoñel yic'ot i yijñam i c'aba' María tsa' bʌ i c'ajti. Cʌntʌbil i cha'an alʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Che' ya' añob tsa' c'oti i yorajlel cha'an mi' yilan pañimil i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tsi' yʌc'ʌ ti pañimil ch'iton bʌ yʌx alʌl. Tsi' bʌc'ʌ ti' majts. Tsi' ñolchoco ti' buc'ujib alʌc'ʌl, come ma'anic tsi' taja i yajñib ti' yotlel wʌyibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ti jini jach bʌ lum an xcʌnta tiñʌme'ob ti jamil. Woli' cʌntañob i tiñʌme' ti ac'ʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Awilan, tsa' tsictiyi i yángel lac Yum ba' añob. I ñuclel Dios tsi' yʌc'ʌ i c'ʌc'al ti' joytilelob. Tsa' cajiyob ti cabʌl bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jini ángel tsi' subeyob: Mach mi la' cha'len bʌq'uen come awilan, tsac ch'ʌmbeyetla tilel wen t'an cha'an pejtelel winicob x'ixicob, mu' bʌ caj i yʌq'ueñetla cabʌl i tijicñʌyel la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Come sajmʌl ti' tejclum David tsi' yila pañimil la' waj Coltaya, jiñʌch Cristo lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mi caj la' cʌn che' bajche' jini. Mi caj la' taj jini alʌl bʌc'ʌl ti majts, ñolol ti' buc'ujib alʌc'ʌl, che'en jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ti ora tsa' tsictiyi yic'ot jini ángel wen cabʌlob ch'oyolo' bʌ ti panchan, woli bʌ i subob i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Tsi' yʌlʌyob: Wen ñuc Dios am bʌ ti panchan. Wʌ' ti pañimil woli' yʌq'uentelob i ñʌch'tilel i pusic'al winicob x'ixicob mu' bʌ i q'uejlelob ti uts'at ti Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Che' bʌ tsa' cha' majliyob ángelob ti panchan, jini xcʌnta tiñʌme'ob tsi' subeyob i bʌ: Conixla ti Belén cha'an mi laj q'uel ili tsa' bʌ ujti tsa' bʌ subentiyonla cha'an lac Yum, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tsa' majliyob ti ora. Tsi' tajayob María yic'ot José yic'ot jini alʌl ñolol ti' buc'ujib alʌc'ʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Che' bʌ tsa' ujti i q'uelob, tsa' caji i subeñob pejtelel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pejtelel tsa' bʌ i yubiyob jini t'an tsa' toj sajtiyob i pusic'al cha'an chuqui tac tsa' subentiyob cha'an xcʌnta tiñʌme'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María ma'anic chuqui tsi' sube yambʌ. Tsa' jach i chʌn ña'ta ti' pusic'al pejtel chuqui tsi' yubi. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tsa' sujtiyob xcʌnta tiñʌme'ob. Tsi' chʌn tsictesayob i ñuclel Dios. Tsi' subuyob i ñuclel Dios cha'an pejtelel chuqui tsi' yubiyob yic'ot chuqui tsi' q'ueleyob che' bajche' tsa' subentiyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Che' bʌ tsa' ñumi waxʌcp'ejl q'uin che' bʌ tsa' tsepbenti i pʌchʌlel alʌ ch'iton, tsi' yotsʌbeyob i c'aba' Jesús. Jiñʌch i c'aba' tsa' bʌ i wʌn otsʌbe jini ángel che' maxto cʌntʌbilic. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Che' bʌ tsa' ts'ʌctiyi cha'c'al q'uin cha'an mi' sʌq'uesañob i bʌ che' bajche' mi' yʌl ti' mandar Moisés, tsi' pʌyʌyob majlel alʌl ti Jerusalén cha'an mi' yʌq'ueñob lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Che' bajche' ts'ijbubil ti' mandar lac Yum: “Mux caj la' ña'tan i cha'añʌch lac Yum pejtelel ch'iton bʌ yʌx alʌlob”. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tsa' majliyob cha'an mi' yʌq'ueñob Dios i majtan ja'el che' bajche' tsi' yʌc'ʌ mandar lac Yum: “Aq'uen cha'cojt xmucuy o mi cha'cojt x'ujcuts”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ya'an winic ti Jerusalén i c'aba' Simeón, toj bʌ i pusic'al, mu' bʌ i ch'ujutesan Dios. Tsi' pijta jini Mesías mu' bʌ caj i ñuq'uesʌbeñob i pusic'al israelob. Jini Ch'ujul bʌ Espíritu an ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jini Ch'ujul bʌ Espíritu tsi' sube Simeón ma'anic mi' caj ti chʌmel jinto che' q'uelbilix i cha'an jini Yajcʌbil bʌ cha'an lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ñijcʌbil cha'an Espíritu tsa' ochi ti Templo. I tat i ña' Jesús tsi' pʌyʌyob ochel jini alʌ Jesús ti Templo cha'an mi' melbeñob bajche' mi' yʌl ti mandar. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón tsi' meq'ue jini alʌl. Tsi' subu i ñuclel Dios. Tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","C Yum, x'e'telon a cha'an. La' pʌjyicon majlel ti' ñʌch'tʌlel c pusic'al che' bajche' tsa' wʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Come wʌle tsa'ix j q'uele tic wut jini Xcoltaya tsa' bʌ a wʌc'ʌ, ");
INSERT INTO ctuBl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","chocbil bʌ tilel ti' tojlel pejtelel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jiñʌch i sʌclel pañimil mu' bʌ caj i pʌstʌl ti' wut gentilob. Jiñʌch i ñuclel a cha'año' bʌ ti Israel, che'en Simeón. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tsa' toj sajtiyob i pusic'al José yic'ot María, i ña' Jesús, che' bʌ tsi' yubiyob jini t'an cha'an i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeón tsi' yʌq'ueyob i yutslel i t'an. Tsi' sube María, i ña' alʌl: Awilan, wa'chocobilix a walobil ti' tojlel cabʌl israelob. Lamital mi caj i yajlelob, lamital mi caj i xuc'chocontelob. Cabʌlob mi caj i cha'leñob t'an ti' contra che' mi' pʌs i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Wen ch'ijiyem a pusic'al mi caj a wubin che' mi' tsictiyel bajche' woli' ña'tañob ti' pusic'al cabʌlob, che'en Simeón. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ya'an x'ixic bʌ x'alt'an ja'el i c'aba' Ana (i yalobil Fanuel i p'olbal Aser). Wen cabʌl i jabilel. Che' xch'oc to tsa' chumle yic'ot i ñoxi'al wucp'ejl jab. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","C'ʌlʌl meba'ix che' bʌ tsi' taja chʌmp'ejl i jo'c'al (84) i jabilel. Ma'anic tsi' wis cʌyʌ i bʌ ti Templo ba' tsi' melbe i ye'tel Dios ti q'uiñil yic'ot ti ac'ʌlel yic'ot ch'ajb yic'ot oración. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti jini jach bʌ ora tsa' tili Ana ba'an alʌl. Tsi' sube wocolix i yʌlʌ Dios. Tsi' subeyob i sujmlel jini alʌl ti' tojlel pejtel año' bʌ ti Jerusalén woli bʌ i pijtañob i coltʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Che' bʌ tsa' ujti i melob pejtelel chuqui tac mi' yʌl i mandar lac Yum, tsa' sujtiyob ya' ti Galilea María yic'ot José. Tsa' c'otiyob ti' tejclum i c'aba' Nazaret. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tsa' coli jini alʌl. Tsa' p'ʌta. Tsa' bujt'i ti' ña'tʌbal. Tsa' q'uejli ti uts'at ti' wut Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ti jujump'ejl jab i tat i ña' tsa' majliyob ti Jerusalén cha'an i q'uiñilel Pascua. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Che' anix lajchʌmp'ejl i jabilel Jesús, tsa' majliyob ti q'uiñijel che' bajche i tilel. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Che' bʌ tsa' ujti i melob q'uin, tsa' cajiyob ti sujtel. Ya' tsa' cʌle ti Jerusalén jini ch'iton Jesús. Mach yujilobic José yic'ot i ña' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tsi' lon ña'tayob ti' pusic'al woli' sujtel i yalobil ja'el yic'ot motocña bʌ i pi'ʌlob. Tsi' xʌñʌyob majlel jump'ejl q'uin. Tsa' caji i sʌclañob ba'an i pi'ʌlob yic'ot ba'an i cʌñʌyo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Che' ma'anic tsi' tajayob i yalobil, tsa' cha' majliyob ti Jerusalén cha'an mi' sʌclañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Che' ñumenix uxp'ejl q'uin tsi' tajayob ti Templo buchul ti' tojlel jini xcʌntesa mandarob. Woli' ñich'tʌbeñob i t'an. Woli' yotsan i c'ajtibal tac ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tsa' toj sajtiyob i pusic'al pejtelel jini tsa' bʌ i yubibeyob i t'an jini ch'iton, come cabʌl i ña'tʌbal. Uts'at bajche' tsi' jac'beyob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tsa' toj sajtiyob i pusic'al i tat i ña' che' bʌ tsi' q'ueleyob. María tsi' sube: Calobil, ¿chucoch che' tsa' melbeyon lojon? Awilan, jini a tat yic'ot joñon ti' ch'ijiyemlel lojon c pusic'al tsac sʌclayet lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús tsi' subeyob: ¿Chucoch tsa' la' sʌclayon? ¿Mach ba la' wujilic yom mic melben i ye'tel c Tat? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ma'anic tsi' ch'ʌmbeyob isujm i t'an Jesús tsa' bʌ i subeyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tsa' jubi majlel Jesús yic'otob. Tsa' c'oti ti Nazaret. Tsi' wen ch'ujbibe i t'an i tat i ña'. Jini i ña' tsi' mucu ti' pusic'al pejtelel tsa' bʌ ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tsa' p'ojli i ña'tʌbal Jesús. Tsa' chañ'a. Tsa' p'ojli i yutslel i pusic'al ti' wut Dios yic'ot ti' wut winicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Che' bʌ tsi' cha'le yumʌl jo'lujump'ejl jab Tiberio César, an i ye'tel ti gobernador Poncio Pilato ya' ti Judea. Woli' yumʌntel Herodes ya' ti Galilea. I yijts'in Herodes i c'aba' Felipe, woli' cha'len yumʌl ya' ti Iturea yic'ot ya' ti Traconite. Lisanias woli' cha'len yumʌl ya' ti Abilinia. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jini ñuc bʌ motomajob jiñobʌch Anás yic'ot Caifás. Tsa' tili i t'an Dios ba'an Juan ya' ti jochol bʌ lum. Jini Juan i yalobil Zacarías. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tsa' ñumi Juan ti subt'an ti pejtelel lum ya' ti' joytilel Jordán ja'. Tsi' sube winicob x'ixicob cha'an mi' ch'ʌmob ja' che' mi' cʌyob i mul cha'an mi' ñusʌbentelob i mul, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","che' bajche' ts'ijbubil ti' juñilel i t'an jini x'alt'an Isaías. Tsi' yʌlʌ: “I t'an juntiquil winic mu' bʌ i cha'len c'am bʌ t'an ti jochol bʌ lum: Chajpanla i bijlel lac Yum. Pʌtʌla majlel mucubij i cha'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pejtelel jini c'omol tac bʌ lum mi' caj ti bujt'intel. Pejtelel wits yic'ot bujbujtʌl mi' cajel ti jubel. Jini xoyol tac bʌ bij mi caj i toj'an. Pejtelel jini bulul bexel bʌ bij pamacña mi caj i majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pejtelel winicob x'ixicob mi caj i yubiñob bajche' mi' coltʌntelob ti Dios”. Che'ʌch ts'ijbubil ti' juñilel Isaías. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Juan tsa' caji i subeñob winicob x'ixicob tsa' bʌ loq'uiyob tilel cha'an mi' ch'ʌmob ja': I yalobiletla xc'ʌñʌñej. ¿Majqui tsi' subeyetla cha'an mi la' puts'tan jini tojmulil mu' bʌ i tilel? ");
INSERT INTO ctuBl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Melela toj bʌ la' melbal mi woli la' cʌy la' mul. Mach mi la' wʌl ti la' pusic'al: “Jiñʌch c tat lojon Abraham”. Mach che'ic yom mi la' wʌl. Come mic subeñetla, Dios mi mejlel i pʌntesan jini xajlel tac ti' yalobilob Abraham. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wʌle ac'bil hacha ti' yebal te'. Pejtelel jini te' mach bʌ anic mi' yʌc' wen bʌ i wut mi' sejq'uel. Mi' chojquel ti c'ajc, che'en Juan. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jini winicob x'ixicob tsi' c'ajtiyob: ¿Chuqui yom mic mel lojon? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan tsi' jac'ʌ: Jini am bʌ i cha'an cha'p'ejl i bujc la' i yʌq'uen jump'ejl jini mach bʌ anic i cha'an. Jini am bʌ i we'el che'ʌch yom mi' mel ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tsa' tiliyob cha'tiquil uxtiquil xch'ʌm tojoñelob ja'el cha'an mi' ch'ʌmob ja'. Tsi' c'ajtibeyob: Maestro, ¿chuqui yom mic mel lojon? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan tsi' subeyob: Mach yomic mi la' c'ajtin tojoñel ñumen bajche tsa' subentiyetla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Cha'tiquil uxtiquil soldadojob ja'el tsi' c'ajtibeyob: Jixcu joñon lojon, ¿chuqui yom mic mel lojon? che'ob. Juan tsi' subeyob: Mach mi la' chilben i taq'uin winic mi juntiquilic. Mach mi la' pʌc' ti mulil mi juntiquilic. Yom contentojetla yic'ot i tojol la' we'tel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Che' woliyob to ti pijt, pejtelel winicob x'ixicob woli' pejcañob i bʌ: ¿Jim ba Cristo jini Juan? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan tsi' subeyob ti pejtelelob: Joñon ti isujm mi cʌq'ueñetla ch'ʌmja', pero tal jini ñumen p'ʌtʌl bʌ bajche'on. Mach ñuconic cha'an mic ticben i ch'ajñal i xʌñʌb. Jiñʌch mu' bʌ caj i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ Espíritu yic'ot c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","An i wejlʌjib ti' c'ʌb. Mi caj i wen wejlan i yajñib trigo. Mi caj i lot jini trigo ti' yotlel. Mi caj i pulben i sujl ti c'ajc mach bʌ yujilic yajpel ti pejtelel ora. Che' tsi' yʌlʌ Juan. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Che' bʌ tsi' subeyob winicob x'ixicob jini wen t'an, tsi' xiq'uiyob cha'an mi' jac'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juan tsi' sube i mul jini Herodes am bʌ i ye'tel ti yumʌl. Come Herodes tsi' pʌyʌ Herodías i yijñam Felipe i yijts'in. Juan tsi' sube pejtelel i jontolil tsa' bʌ i cha'le Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","An to yambʌ jontolil tsa' bʌ i mele Herodes. Tsi' mʌcʌ Juan ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Che' bʌ tsi' ch'ʌmʌyob ja' pejtelel winicob x'ixicob, tsi' ch'ʌmʌ ja' ja'el Jesús. Che' woli' pejcan Dios ti oración, tsa' cajli panchan. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tsa' jubi tilel jini Ch'ujul bʌ Espíritu ba'an Jesús. Che' yilal che' bajche' x'ujcuts. Tsa' tili t'an ch'oyol bʌ ti panchan. Tsi' subu: Jatet Calobilet mu' bʌ j c'uxbin. Wen uts'at mij q'uelet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","An che' bajche' lujump'ejl i cha'c'al i jabilel Jesús che' bʌ tsi' teche i ye'tel. Jini Jesús i yalobilʌch José, che' mi' lon alob winicob. José i ñij'al Elí. ");
INSERT INTO ctuBl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","I tat Elí jiñʌch Matat, i tat Matat jiñʌch Leví, i tat Leví jiñʌch Melqui, i tat Melqui jiñʌch Jana, i tat Jana jiñʌch José, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","i tat José jiñʌch Matatías, i tat Matatías jiñʌch Amós, i tat Amós jiñʌch Nahum, i tat Nahum jiñʌch Esli, i tat Esli jiñʌch Nagai, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","i tat Nagai jiñʌch Maat, i tat Maat jiñʌch Matatías, i tat Matatías jiñʌch Semei, i tat Semei jiñʌch José, i tat José jiñʌch Judá, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","i tat Judá jiñʌch Joana, i tat Joana jiñʌch Resa, i tat Resa jiñʌch Zorobabel, i tat Zorobabel jiñʌch Salatiel, i tat Salatiel jiñʌch Neri, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","i tat Neri jiñʌch Melqui, i tat Melqui jiñʌch Adi, i tat Adi jiñʌch Cosam, i tat Cosam jiñʌch Elmodam, i tat Elmodam jiñʌch Er, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","i tat Er jiñʌch Josué, i tat Josué jiñʌch Eliezer, i tat Eliezer jiñʌch Jorim, i tat Jorim jiñʌch Matat, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","i tat Matat jiñʌch Leví, i tat Leví jiñʌch Simeón i tat Simeón jiñʌch Judá, i tat Judá jiñʌch José, i tat José jiñʌch Jonán, i tat Jonán jiñʌch Eliaquim, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","i tat Eliaquim jiñʌch Melea, i tat Melea jiñʌch Mainán, i tat Mainán jiñʌch Matata, i tat Matata jiñʌch Natán, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","i tat Natán jiñʌch David, i tat David jiñʌch Isaí, i tat Isaí jiñʌch Obed, i tat Obed jiñʌch Booz, i tat Booz jiñʌch Salmón, i tat Salmón jiñʌch Naasón, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","i tat Naasón jiñʌch Aminadab, i tat Aminadab jiñʌch Aram, i tat Aram jiñʌch Esrom, i tat Esrom jiñʌch Fares, i tat Fares jiñʌch Judá, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","i tat Judá jiñʌch Jacob, i tat Jacob jiñʌch Isaac, i tat Isaac jiñʌch Abraham, i tat Abraham jiñʌch Taré, i tat Taré jiñʌch Nacor, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","i tat Nacor jiñʌch Serug, i tat Serug jiñʌch Ragau, i tat Ragau jiñʌch Peleg, i tat Peleg jiñʌch Heber, i tat Heber jiñʌch Sala, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","i tat Sala jiñʌch Cainán, i tat Cainán jiñʌch Arfaxad, i tat Arfaxad jiñʌch Sem, i tat Sem jiñʌch Noé, i tat Noé jiñʌch Lamec, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","i tat Lamec jiñʌch Matusalén, i tat Matusalén jiñʌch Enoc, i tat Enoc jiñʌch Jared, i tat Jared jiñʌch Mahalaleel, i tat Mahalaleel jiñʌch Cainán, ");
INSERT INTO ctuBl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","i tat Cainán jiñʌch Enós, i tat Enós jiñʌch Set, i tat Set jiñʌch Adán, Adán jiñʌch i yalobil Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús, but'ul ti jini Ch'ujul bʌ Espíritu, tsi' cʌyʌ Jordán ja'. Tsa' pʌjyi majlel cha'an Espíritu c'ʌlʌl ti colem bʌ i tiquiñal lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cha'c'al q'uin ya'an. Tsa' ilʌbenti i pusic'al cha'an xiba. Cha'c'al q'uin ma'anic chuqui tsi' wis c'uxu. Che' ñumenix, an i wi'ñal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jini xiba tsi' sube Jesús: Mi i Yalobilet Dios suben ili xajlel cha'an mi' pʌntʌyel ti waj, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús tsi' sube: Ts'ijbubil: “Mach ti wajic jach cuxulob winicob x'ixicob, pero ti pejtelel t'an ch'oyol bʌ ti Dios”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jini xiba tsi' pʌyʌ majlel ti chan bʌ wits. Ti poj jumuc' jach tsi' laj pʌsbe Jesús i yumʌntel tac jini yumʌlob ti pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jini xiba tsi' sube Jesús: Mi caj cʌq'ueñet pejtel iliyi yic'ot i p'ʌtʌlel yic'ot i ñuclel, come laj aq'uebilon tic wenta. Mi cʌq'uen majqui com. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Muq'uic a ñocchocon a bʌ a ch'ujutesañon, a cha'añʌch mi' majlel ti pejtelel, che'en jini xiba. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús tsi' sube: Cucu ti loq'uel wʌ' ba' añon, Satanás, come ts'ijbubil: “Yom ma' ch'ujutesan a Yum Dios. Cojach jini yom ma' yuman”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jini xiba tsi' pʌyʌ majlel Jesús ya' ti Jerusalén. Ya' tsi' pʌyʌ majlel ti wa'tʌl ti' pam i jol Templo. Tsi' sube: Mi i Yalobilet Dios, choco jubel a bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Come ts'ijbubil: “Mi caj i subeñob i yángelob cha'an mi' cʌntañet. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mi caj i chuquet ti' c'ʌb, ame a jats' a woc ti xajlel”, che'en xiba. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús tsi' sube: Albilix jini t'an: “Mach yomic ma' wilʌben i pusic'al a Yum Dios”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Che' bʌ tsa' ujti i yilʌben i pusic'al Jesús, jini xiba tsi' cʌyʌ cha'p'ejl uxp'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús tsa' cha' majli ti Galilea. An i p'ʌtʌlel jini Espíritu yic'ot. Tsa' pujqui t'an ti pejtelel lum ti' joytilel Galilea cha'an ñuc bʌ i melbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús tsi' cha'le cʌntesa ti sinagoga tac i cha'an judíojob. Pejtelel winicob x'ixicob tsi' tsictesayob i ñuclel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tsa' majli Jesús ya' ti Nazaret ba' tsa' coli. Tsa' ochi ti sinagoga ti' q'uiñilel c'aj o che' bajche' i tilel. Tsa' wa'le cha'an mi' q'uel jun. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Tsa' aq'uenti i jun jini x'alt'an Isaías. Che' bʌ tsi' tili jini bʌlbil bʌ jun tsi' taja ba' ts'ijbubil ili t'an: ");
INSERT INTO ctuBl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“An i yEspíritu lac Yum tic pusic'al. Tsi' yajcayon cha'an mic subeñob jini wen t'an p'umpuño' bʌ. Tsi' chocoyon tilel cha'an mic lajmesʌbeñob i ch'ijiyemlel jini ch'ijiyemo' bʌ, cha'an mic subeñob loq'uel jini ñup'ulo' bʌ, cha'an mij c'oq'uesʌbeñob i wut jini xpots'ob, cha'an mi cʌc' ti colel jini tic'lʌbilo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tsi' chocoyon tilel cha'an mic sub jiñʌch i jabilel i yutslel i pusic'al lac Yum”. Che'ʌch tsi' pejcʌbeyob i Ts'ijbujel Dios jini Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tsi' cha' bʌlʌ jini jun Jesús. Tsi' cha' aq'ue jini am bʌ i ye'tel ti sinagoga. Tsa' buchle. Pejtelel año' bʌ ti sinagoga tsi' ch'ujch'uj q'ueleyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesús tsa' caji i subeñob: Ts'ʌctiyemix wʌle i ts'ijbujel Dios, tsa' bʌ la' wubi, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ti pejtelelob uts'at tsi' tajayob ti t'an Jesús. Tsa' toj sajtiyob i pusic'al cha'an uts'at i t'an Jesús. Tsi' yʌlʌyob: ¿Mach ba jinic i yalobil José? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús tsi' subeyob: Isujm mi caj la' subeñon jini t'an mu' bʌ i c'ʌñob ti lajiya: “Sts'ʌcaya, ts'ʌcan a bʌ”, che'en. Mi caj la' subeñon c mel wʌ' tic lumal chuqui tsac mele ya' ti Capernaum che' bajche' tsa'ix la' wubi. che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesús tsi' yʌlʌ ja'el: Ti isujm mic subeñetla, ma'anic x'alt'an mu' bʌ i q'uejlel ti ñuc ti' lumal. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ti isujm mic subeñetla an cabʌl meba' x'ixicob ti Israel ti' q'uiñilel Elías che' wen jamʌl pañimil ojlil i chʌmp'ejl jab, che' bʌ tsa' tili cabʌl wi'ñal ti pejtelel lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma'anic tsa' chojqui majlel Elías ba' añob. Tsa' jach chojqui majlel ti Sarepta ya' ti Sidón ba'an juntiquil meba' x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","An ja'el cabʌl israelob año' bʌ leco bʌ i tsoy che' ti' yorajlel jini x'alt'an Eliseo. Ma'anic majqui tsa' lajmesʌnti, jini jach Naamán, ch'oyol bʌ ti Siria. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Che' bʌ tsi' yubiyob ili t'an, tsa' laj cajiyob ti mich'ajel ya' ti sinagoga. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tsa' wa'leyob. Tsi' pʌyʌyob loq'uel Jesús ti' ti' tejclum wa'chocobil bʌ ti wits. Tsi' pʌyʌyob majlel ba' jʌmʌl wits cha'an mi' xit chocob jubel. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús tsa' ñumi ti ojlil ba' añob. Tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tsa' jubi majlel Jesús ti jump'ejl tejclum ya' ti Galilea i c'aba' Capernaum. Tsi' cʌntesayob ti' q'uiñilel tac c'aj o. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tsa' toj sajtiyob i pusic'al cha'an i cʌntesa come tsi' cha'le t'an Jesús yic'ot i p'ʌtʌlel i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ya' ti sinagoga an winic am bʌ i xibʌjlel. C'am tsi' cha'le t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Tsi' yʌlʌ: Cʌyʌyon lojon. ¿Chuqui i ye'tel tsa' tiliyet ba' añon lojon, Jesús ch'oyolet bʌ ti Nazaret? ¿Tsa' ba tiliyet cha'an ma' jisañon lojon? Cujil majquiyet. Jatet jini Ch'ujulet Bʌ ch'oyol bʌ ti Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús tsi' tiq'ui. Tsi' sube: Ch'ʌbix. Loq'uen ti' pusic'al, che'en. Jini xiba tsi' choco jini winic ti lum ti' yojlilob. Tsa' loq'ui xiba. Ma'anic tsi' wis lowo jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tsa' toj sajtiyob i pusic'al ti pejtelelob. Tsa' caji i pejcañob i bʌ. Tsi' yʌlʌyob: ¿Baqui tilem i t'an? Come ti' p'ʌtʌlel yic'ot i ye'tel mi' choc loq'uel i xibʌjlel winic. Mi' loq'uelob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tsa' pujqui t'an ti pejtelel jini lum yic'ot ti yan tac bʌ lum ti' joytilel cha'an ñuc bʌ i melbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tsa' wa'le Jesús. Tsa' loq'ui ti sinagoga. Tsa' ochi ti' yotot Simón ba' woli' wen ubin c'ajc x'ixic bʌ i ñij'al Simón. Tsi' c'ajtibeyob Jesús ti wocol t'an cha'an mi' lajmesan. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ñuc wa'al Jesús ti' t'ejl x'ixic, tsi' tiq'ui jini c'ajc. Jini x'ixic tsa' lajmi. Tsa' ch'ojyi ti ora. Tsa' caji i we'sañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Che' woli ti bʌjlel q'uin tsi' pʌyʌyob majlel ba'an Jesús pejtel xc'amʌjelob leco tac bʌ i chʌmel. Jesús tsi' yʌc'ʌ i c'ʌb ti junjuntiquilob. Tsi' lajmesayob. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tsa' loq'uiyob xibajob ti' pusic'al cabʌlob. Tsi' cha'leyob c'am bʌ t'an. Tsi' yʌlʌyob: Jatet i Yalobilet Dios, che'ob. Jesús tsi' tiq'uiyob. Ma'anic tsi' yʌq'ueyob i cha'len t'an, come cʌñʌl i cha'añob jiñʌch Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Che' bʌ tsa' sʌc'a pañimil tsa' loq'ui majlel Jesús. Tsa' majli ti jochol bʌ lum. Winicob x'ixicob tsi' sʌclayob. Tsa' majliyob ba'an. Tsi' ñopoyob i jalitesan Jesús cha'an ya jach mi' cʌytʌl yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesús tsi' subeyob: Wersa mic sub jini wen t'an cha'an i yumʌntel Dios ti yambʌ tejclum tac ja'el, come jini cha'an chocbilon tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tsi' cha'le subt'an ti sinagoga tac ya' ti Judea. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Che' ya'an Jesús ti' t'ejl ñajb i c'aba' Genesaret, jini winicob x'ixicob tsi' jom ñet'eyob i bʌ ba' wa'al Jesús cha'an mi' ñich'tañob i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tsi' q'uele cha'p'ejl barco lʌc'ʌl ti' ti' jini ñajb. Loq'uemobix ti barco jini xchuc chʌyob, woli' sʌc'ob i chimo'chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tsa' ochi Jesús ti jump'ejl barco i cha'an Simón. Tsi' sube Simón cha'an mi' ts'ita' ñijcan majlel jini barco ya' ti' ti' ja'. Tsa' buchle Jesús ti barco. Ya' tsa' caji i cʌntesan jini tempʌbilo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Che' bʌ tsa' ujti ti t'an, Jesús tsi' sube Simón: Ñijcan majlel jini barco ba' tam jini ñajb. Choco ochel a chimo'chʌy, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón tsi' jac'ʌ: Maestro, tsa'ix c cha'le lojon e'tel ti pejtelel ac'ʌlel. Ma'anic chuqui tsac chucu lojon. Pero cha'an ti a t'an mic choc ochel chimo'chʌy, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Che' bʌ tsi' yotsayob tsi' chucuyob cabʌl chʌy. Tsa' caji ti ts'ojquel jini chimo'chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tsi' pʌyʌyob ti' c'ʌb i pi'ʌlob año' bʌ ti yambʌ barco cha'an mi' tilelob i coltan. Tsa' tiliyob. Tsi' but'uyob jini cha'p'ejl barco jinto che' yomix junyajlel ochel ti ja' jini barco tac. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Che' bʌ tsi' q'uele Simón Pedro, tsi' ñocchoco i bʌ ba'an Jesús. Tsi' sube: Loq'uen tic tojlel c Yum, come xmulilon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Come tsa' wen caji ti bʌq'uen Pedro yic'ot pejtelel ya' bʌ añob, come oñatax tsi' chucuyob chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Che' ja'el, tsa' cajiyob ti bʌq'uen Jacobo yic'ot Juan, i yalobilob Zebedeo, i pi'ʌlobʌch Simón ti e'tel. Jesús tsi' sube Simón: Mach a cha'len bʌq'uen. Wʌle, mux a wochel ti xchuc winicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Che' bʌ tsa' ujti i ñijcañob majlel barco tac ti' ti' ñajb, jini xchuc chʌyob tsi' cʌyʌyob pejtelel i chubʌ'an. Tsi' tsajcayob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Che' ya'an Jesús ti jump'ejl tejclum, awilan, tsa' tili winic wen pacal leco bʌ i tsoy. Che' bʌ tsi' q'uele Jesús, tsi' pʌcchoco i bʌ ti lum. Tsi' c'ajtibe ti wocol t'an: C Yum, mi a wom mi mejlel a lajmesañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús tsi' sʌts'ʌ i c'ʌb. Tsi' tʌlʌ. Tsi' yʌlʌ: Com cu. La' lajmiquet, che'en. Tsa' bʌc' lajmi leco bʌ i tsoy. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús tsi' tiq'ui cha'an ma'anic mi' suben mi juntiquilic. Cucu, che'en, pʌsʌ a bʌ ba'an motomaj. Ac'ʌ chuqui tsi' subu Moisés ti mandar cha'an mi' ña'tañob winicob x'ixicob sʌq'uesʌbilet, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ñumen cabʌl tsa' pujqui t'an cha'an ñuc bʌ i melbal Jesús. Tsi' tempayob i bʌ bajc'ʌlob cha'an mi' ñich'tʌbeñob i t'an Jesús yic'ot cha'an mi' lajmelob ti pejtelel i chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesús tsi' cʌyʌyob. Tsa' majli ti jochol bʌ lum. Tsi' pejca Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ti jump'ejl q'uin che' woli ti cʌntesa Jesús, ya' buchulob fariseojob yic'ot xcʌntesa mandarob ch'oyolo' bʌ ti pejtelel tejclum ti Galilea yic'ot ti Judea yic'ot ti Jerusalén. An i p'ʌtʌlel lac Yum yic'ot Jesús cha'an mi' lajmesañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Awilan, cha'tiquil uxtiquil winicob tsi' pʌyʌyob tilel winic mach bʌ anic i c'ʌjñibal i yoc i c'ʌb, ñolol ti' wʌyib. Tsi' ñopoyob i yotsan ti otot cha'an mi' yʌc'ob ti' tojel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ma'anic ba' tsa' mejli i yotsañob, come teñecña winicob x'ixicob. Tsa' letsiyob ti' jol otot ba' tsi' toc jamʌyob teja. Tsi' ju'sayob ti' wʌyib ti yojlil ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Che' bʌ tsi' ña'ta Jesús woli' ñopob jini winicob, tsi' sube jini c'am bʌ: Winic ñusʌbilix a mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jini fariseojob yic'ot sts'ijbayajob tsa' caji i yʌlob ti' pusic'al: ¿Chuqui i ye'tel jini winic mu' bʌ i p'aj Dios? ¿Majqui mi mejlel i ñusan mulil? ¿Mach ba cojic jach Dios? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ña'tʌbil i cha'an Jesús chuqui woli' yʌlob ti' pusic'al. Tsi' subeyob: ¿Chucoch woli la' cha'len t'an ti la' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Baqui bʌ ñumen wocol? ¿Wocol ba che' mic suben: “Ñusʌbilix a mul”, o jimba wocol che' mic suben: “Ch'oyen, cha'len xʌmbal”? ");
INSERT INTO ctuBl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero cha'an mi la' ña'tan an i p'ʌtʌlel i Yalobil Winic ilayi ti pañimil cha'an mi' ñusan mulil, (tsi' sube jini mach bʌ anic i c'ʌjñibal i yoc i c'ʌb): Mic subeñet ch'ojyen, teche a wʌyib, cucu ti a wotot, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ti ora tsa' ch'ojyi jini winic ti' tojel i wutob. Tsi' teche i wʌyib ba' tsa' ñole. Tsa' majli ti' yotot. Tsi' tsictesa i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tsa' toj sajtiyob i pusic'al ti pejtelelob. Tsi' tsictesʌbeyob i ñuclel Dios. Tsi' wen cha'leyob bʌq'uen. Tsi' yʌlʌyob: Tsa'ix laj q'uele bʌbʌq'uen tac bʌ, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ti wi'il tsa' loq'ui majlel Jesús. Tsi' q'uele xch'ʌm tojoñel, i c'aba' Leví, ya' buchul ba' mi' ch'ʌjmel tojoñel. Jesús tsi' sube: Tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví tsi' cʌyʌ pejtelel i chubʌ'an. Tsa' wa'le. Tsa' caji i tsajcan majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leví tsi' mele q'uin ti' yotot. Ya' tem buchulob cabʌl xch'ʌm tojoñelob yic'ot yaño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jini sts'ijbayajob yic'ot fariseojob tsa' cajiyob ti wʌlwʌl t'an ti' contra jini xcʌnt'añob i cha'an Jesús. Tsi' subeyob: ¿Chucoch woli la' pi'len ti we'el uch'el jini xch'ʌm tojoñelob yic'ot xmulilob? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús tsi' jac'beyob: Jini c'oc'o' bʌ mach yomobic ts'ʌcʌntel, cojach jini c'amo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma'anic tsa' tili c pʌy jini tojo' bʌ, jini jach xmulilob, cha'an mi' cʌyob i mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Winicob tsa' caji i subeñob: Cabʌl mi' cha'leñob ch'ajb yic'ot oración jini xcʌnt'añob i cha'an Juan. Che'ʌch mi' melob ja'el jini xcʌnt'añob i cha'an fariseojob. Pero jini xcʌnt'añob a cha'an mi' cha'leñob we'el uch'el, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús tsi' subeyob: ¿Mejl ba la' suben jini xmel q'uiñob wersa mi' cha'leñob ch'ajb che' ya'to an jini xñujpuñijel yic'otob? ");
INSERT INTO ctuBl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero tal i yorajlel che' mi caj i pʌjyel majlel jini woli bʌ ti ñujpuñijel. Ti jini q'uin tac mi' cajelob ti ch'ajb xmel q'uiñob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tsi' subeyob ja'el jini lajiya: Ma'anic majch mi' c'ʌn tsijib pisil cha'an mi' lʌw tsucul bʌ i pislel. Mi che'ʌch mi' mel, mi' tsijlel majlel tsucul bʌ pisil ba'an jini tsiji' bʌ i lʌjwil. Mach i t'ojolic tsiji' bʌ pisil yic'ot tsucul bʌ pisil. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Che' ja'el, ma'anic majch mi' yotsan tsiji' bʌ vino ti tsucul bʌ i yajñib melbil bʌ ti pʌchi. Mi tsi' yotsa jini vino mi' tojmel. Mi' bejq'uel vino. Mi' jilel i yajñib. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero mi' yotsañob tsiji' bʌ vino ti tsiji' bʌ i yajñib. Che' jini mi' jalijel jini pʌchi yic'ot jini vino ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jini mu' bʌ i jap wajalix bʌ vino ma'anic mi' mulan i jap jini tsiji' bʌ ti wi'il, come mi' yʌl ñumen uts'at jini wajalix bʌ. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ti' q'uiñilel c'aj o Jesús tsa' ñumi ti jamil. Jini xcʌnt'añob i cha'an tsi' tuc'uyob majlel jini c'uxbil bʌ i wut jam. Tsi' bilt'uyob ti' c'ʌb. Tsi' c'uxuyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Cha'tiquil uxtiquil fariseojob tsi' c'ajtibeyob: ¿Chucoch mi la' cha'len chuqui tic'bil ti' q'uiñilel c'aj o? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús tsi' subeyob: ¿Mach ba anic tsa' la' q'uele ti jun chuqui tsi' cha'le David che' bʌ tsi' yubi wi'ñal yic'ot i pi'ʌlob? ");
INSERT INTO ctuBl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tsa' ochi ti' yotot Dios. Tsi' ch'ʌmʌ jini waj tsa' bʌ ajq'ui ti mesa. Tsi' c'uxu. Tsi' yʌq'ue i pi'ʌlob ja'el. Tic'bil ti mandar mi' c'uxob winicob. Cojach motomajob mi mejlel i c'ux jini waj, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús tsi' subeyob: I Yalobil Winic i Yumʌch jini q'uin che' mi laj c'aj la co, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ti yambʌ i q'uiñilel c'aj o tsa' ochi Jesús ti sinagoga. Tsa' caji ti cʌntesa. Ya'an winic tiquin bʌ ñoj bʌ i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jini sts'ijbayajob yic'ot fariseojob tsi' wen q'ueleyob Jesús cha'an mi' jop'beñob i mul mi tsi' lajmesa jini winic che' ti' yorajlel c'aj o. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yujil Jesús chuqui woli' yʌlob ti' pusic'al. Tsi' sube jini winic tiquim bʌ i c'ʌb: Ch'ojyen. Wa'i' ti ojlil, che'en. Tsa' ch'ojyi jini winic. Tsa' wa'le. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús tsi' subeyob: Jini jach mij c'ajtibeñetla: ¿Baqui bʌ tic'bil ti melol ti jini q'uin che' mi laj c'aj la co? ¿Tic'bil ba chuqui uts'at o jim ba chuqui jontol? ¿Tic'bil ba coltaya o tic'bil ba tsʌnsa? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús tsi' joy q'ueleyob ti pejtelel. Tsi' sube jini winic: Sʌts'ʌ a c'ʌb, che'en. Tsi' sʌts'ʌ. Jini i c'ʌb tsa' cha' wen'a. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Cabʌl tsa' mich'ayob. Tsa' caji i pejcañob i bʌ cha'an mi' ña'tañob chuqui mi caj i tumbeñob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti ili q'uin tac tsa' letsi majlel Jesús ti wits cha'an mi' mel oración. Ti pejtelel ac'ʌlel tsi' pejca Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Che' bʌ tsa' sʌc'a, Jesús tsi' pʌyʌ tilel xcʌnt'añob i cha'an. Tsi' yajca lajchʌntiquil. Tsi' yotsʌbeyob i c'aba' ti apóstolob. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tsi' yajca Simón jini am bʌ i cha'chajplel i c'aba' Pedro, yic'ot Andrés i yijts'in Pedro; Jacobo yic'ot Juan, Felipe yic'ot Bartolomé, ");
INSERT INTO ctuBl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo yic'ot Tomás, Jacobo i yalobil Alfeo; yic'ot Simón jini Zelote; ");
INSERT INTO ctuBl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas i yijts'in Jacobo; yic'ot Judas Iscariote tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús tsa' jubi majlel yic'ot jini xcʌnt'añob. Tsa' wa'le ya' ti joctʌl yic'ot xcʌnt'añob i cha'an yic'ot bajc'ʌl winicob x'ixicob ch'oyolo' bʌ ti pejtelel Judea, ti Jerusalén, yic'ot ti' ti' ñajb ya' ti Tiro yic'ot ti Sidón. Tsa' tiliyob cha'an mi' yubibeñob i t'an Jesús yic'ot cha'an mi' lajmesʌbentelob i chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jini tic'lʌbilo' bʌ cha'an xibajob tsa' lajmesʌntiyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ti pejtelel winicob x'ixicob yomob i tʌl Jesús come tsa' tsictiyi i p'ʌtʌlel cha'an mi' c'oq'uesañob ti pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús tsa' caji i q'uel xcʌnt'añob i cha'an. Tsi' yʌlʌ: Tijicñayetla mach bʌ anic la' chubʌ'an, come la' cha'añʌch i yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tijicñayetla mu' bʌ la' wubin wi'ñal wʌle, come mi caj la' ñaj'an. Tijicñayetla mu' bʌ la' cha'len uq'uel, come mi caj la' cha'len tse'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tijicñayetla che' mi' ts'a'leñetla winicob, che' mi' choquetla, che' mi wajleñetla, che' mi' p'ajob la' c'aba' cha'an tsa' la' ñopo i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ti jimbʌ ora la' ñuc'ac la' pusic'al. Yom tijicñayetla come awilan, ñuc la' chobejtʌbal ya' ti panchan, come la' ñojte'elob lajal tsi' tic'layob x'alt'añob ti oñiyi. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mi caj la' taj wocol wen chumulet bʌ la, come tsa'ix la' taja la' chobejtʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mi caj la' taj wocol ñajetix bʌ la, come mi caj la' wubin wi'ñal. Mi caj la' taj wocol mu' bʌ la' cha'len tse'ñal wʌle, come mi caj la' tsic la' pusic'al. Mi caj la' cha'len uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mi caj la' taj wocol che' uts'at mi' tajetla ti t'an pejtelel winicob x'ixicob, come che'ʌch tsi' tajayob ti t'an jini lot bʌ x'alt'añob ti oñiyi. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero mic subeñetla mu' bʌ la' wubin c tan: C'uxbin la' contrajob, melbenla chuqui uts'at jini mu' bʌ i ts'a'leñetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aq'ueñob i yutslel la' t'an jini mu' bʌ i p'ajetla. Tajala ti oración jini mu' bʌ i tic'lañetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jini mu' bʌ i jats'et ti junwejl a choj, pʌsben yambʌ a choj. Jini mu' bʌ i chilbeñet a chaqueta la' i ch'ʌm a bujc ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Maqui jach mi' c'ajtibeñet, aq'uen chuqui yom. Mach a chʌn c'ajtiben. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Melbenla chuqui uts'at winicob x'ixicob che' bajche' la' wom mi' melbeñetla. Mi la' yom mi' melbeñetob chuqui uts'at winicob x'ixicob, che' yom mi la' melbeñob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mi jini jach mi la' c'uxbin jini c'ux bʌ mi' yubiñetla, ¿uts'at ba mi la' q'uejlel che' jini? Come xmulilob ja'el yujilob c'uxbiya che' c'uxbibilob. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mi jini jach mi la' coltan jini mu' bʌ i coltañetla, ¿uts'at ba mi la' q'uejlel, che' jini? Ma'anic. Come che'ʌch mi' melob xmulilob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mi jini jach mi la' wʌq'ueñob ti majan jini mu' bʌ caj i sutq'uibeñetla i q'uexol, ¿uts'at ba mi la' q'uejlel che' jini? Jini xmulilob mi yʌq'ueñob ti majan yambʌ xmulilob cha'an mi' sutq'uibentelob yic'ot i ñumel. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero c'uxbinla la' contrajob. Melela chuqui wen. Aq'uenla ti majan. Mach mi la' cha'len pensar cha'an mi la' cha' sutq'uibentel. Che' jini mi caj la' ch'ʌm la' chobejtʌbal. Che' jini tsiquil i yalobiletla jini C'ax Ñuc Bʌ, come mi' c'uxbin jini mach bʌ añobic i yutslel i pusic'al yic'ot jini jontolo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","P'untan la' pi'ʌlob che' bajche' mi' p'untañetla la' Tat ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mach mi la' wʌl ti la' pusic'al an i mul la' pi'ʌlob. Che' jini, ma'anic mi caj i yʌlob ti' pusic'al an la' mul. Mach mi la' sub ti xmulil la' pi'ʌlob. Che' jini, ma'anic mi la' sujbel ti xmulil. Ñusʌbenla i mul la' pi'ʌlob. Che' jini, mi caj i ñusʌntel la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aq'uenla. Che' jini, mi caj la' wʌq'uentel wen bʌ i p'isol, tsʌts tejñʌbil, chejpʌbil, che' wolix ti wejtuyel. Come che' bajche' mi la' p'isben winicob che'ʌch mi caj la' wʌq'uentel. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús tsi' subeyob lajiya: Jini xpots' ¿mejl ba i toj'esan majlel yambʌ xpots'? ¿Mach ba muq'uic i yajlelob ti ch'en ti cha'ticlel? ");
INSERT INTO ctuBl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mach ñuquic xcʌnt'an bajche' i maestro. Che' tsa'ix i laj ñopo, lajal mi yajñel bajche' i maestro. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Chucoch ma' q'uel che' bʌ ya wistʌl sajte' am bʌ ti' wut a pi'ʌl pero ma'anic ma' q'uel cucujl am bʌ ti a wut? ");
INSERT INTO ctuBl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Bajche' mi mejlel a suben a pi'ʌl: “C pi'ʌl, la' to c loc'san sajte' ti a wut”, che'et, pero ma'anic ma' q'uel jini cucujl am bʌ ti a wut? Jatet, cha'chajp jax bʌ a pusic'al, ñaxan loc'san jini cucujl am bʌ ti a wut. Ti wi'il mi mejlel a wen q'uel cha'an ma' loc'san jini sajte' am bʌ ti' wut a pi'ʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Mach wenic jini te' mu' bʌ i yʌc' leco bʌ i wut. Mach lecojic jini te' mu' bʌ i yʌc' uts'at bʌ i wut. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jujuntejc te' mi' cʌjñel ti' wut. Ma'anic mi lac tuc' higo ti ts'ʌbabol. Che' ja'el, ma'anic mi lac tuc' ts'usub ti ch'ixol. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jini uts'at bʌ winic mi' loc'san uts'at tac bʌ ti uts'at bʌ i pusic'al. Jini jontol bʌ winic mi' loc'san jontol tac bʌ ti jontol bʌ i pusic'al. Come chuqui jach but'ul ti lac pusic'al mi' tsictiyel che' mi lac cha'len t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Chucoch mi la' pejcañon ti la' Yum che' ma'anic mi la' mel chuqui mic subeñetla? ");
INSERT INTO ctuBl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mi caj j cʌntesañetla bajche' yilal jujuntiquil mu' bʌ i tilel ba' añon, mu' bʌ i yubibeñon c t'an, mu' bʌ i jac'beñon. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lajalʌch bajche' winic tsa' bʌ i mele otot. Tam tsi' top'o lum. Tsi' wa'choco i c'ʌclib otot ti pam xajlel. Tsa' tili but'ja'. Tsʌts tsi' jats'ʌ jini otot. Ma'anic tsa' mejli i ñijcan, come wen wa'chocobil jini otot. ");
INSERT INTO ctuBl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero jini mu' bʌ i yubibeñon c t'an che' ma'anic mi' jac'beñon lajalʌch bajche' winic tsa' bʌ i wa'choco i yotot ti pam lum. Ma'anic tsi' mele i c'ʌclib. Tsʌts tsa' tili but'ja' i jats' jini otot. Ti ora tsa' bujchi. Tsa' lu' jejmi jini otot. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Che' bʌ tsa' ujti i sub pejtelel jini t'an tsa' bʌ i yubiyob winicob x'ixicob, tsa' ochi Jesús ti Capernaum. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Woli ti c'amʌjel x'e'tel i cha'an juntiquil i yaj capitán joc'al soldadojob. Wen c'ux mi' yubin jini x'e'tel. Yomix chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Che' bʌ tsi' yubi jini capitán ya'ʌch an Jesús, tsi' choco majlel ba'an Jesús jini xñoxob cha'an judíojob cha'an mi' subeñob ti wocol t'an, cha'an mi' tilel i lajmesan jini x'e'tel i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Che' bʌ tsa' tiliyob ba'an Jesús tsi' xiq'uiyob ti wocol t'an. Tsi' yʌlʌyob: Uts'at i pusic'al jini capitán. Yom ma' melben jini woli bʌ i c'ajtibeñet. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Come c'ux mi' yubin lac lumal. Tsi' wa'chocobeyon lojon sinagoga, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tsa' majli Jesús yic'otob. Che' mach ñajtix añob ti' yotot, jini capitán tsi' choco majlel i pi'ʌlob ba'an Jesús. Tsi' sube: C Yum, mach ma' tic'lan a bʌ, come mach uts'aticon cha'an ma' wochel ti cotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jini cha'an tsac ña'ta mach uts'aticon cha'an mic tilel ba' añet. Cojach yom ma' wʌc' a t'an. Che' jini, mi' caj ti lajmel x'e'tel c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Come joñon ja'el añon ti' wenta yambʌ winic. An tic wenta cabʌl soldadojob. Mic suben juntiquil: “Cucu”. Mi' majlel. Yambʌ mic suben: “La'”. Mi' tilel. Mic suben c winic: “Cha'len jini”. Mi' mel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús uts'at tsi' yubibe i t'an jini capitán. Tsi' sutq'ui i bʌ. Tsi' subeyob jini woli bʌ i tsajcañob majlel: Mic subeñetla, ma'anic ba' tsac taja ti pejtelel Israel winic mu' bʌ i ñopon bajche' jini, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Che' bʌ tsa' sujtiyob ti' yotot jini capitán, c'oq'uix tsi' tajayob jini x'e'tel tsa' bʌ i cha'le c'amʌjel. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ti wi'il tsa' majli Jesús ti tejclum i c'aba' Naín. Tsi' pi'leyob majlel cabʌl xcʌnt'añob i cha'an yic'ot cabʌl winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Che' lʌc'ʌlix an ti' ti' tejclum, awilan, woli' ch'ʌmob majlel ch'ujlelʌl cha'an mi' mucob. Jini winic tsa' bʌ chʌmi cojachix bʌ i yalobil i ña'. Meba'ix i ña'. Tsi' pi'leyob majlel cabʌl winicob x'ixicob loq'uemo' bʌ ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Che' bʌ tsi' q'uele lac Yum, tsi' p'unta jini meba' x'ixic. Tsi' sube: Mach ma' cha'len uq'uel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Che' bʌ tsa' tili Jesús ba' añob, tsi' tʌlʌ i c'ʌclib ch'ujlelʌl. Tsi' cʌyʌyob i xʌmbal jini woli bʌ i q'uech majlel. Jesús tsi' yʌlʌ: Ch'iton, ch'ojyen, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jini tsa' bʌ chʌmi tsa' buchle. Tsa' caji ti t'an. Jesús tsi' cha' aq'ue i yalobil jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tsa' cajiyob ti bʌq'uen ti pejtelelob. Tsi' tsictesayob i ñuclel Dios. Tsi' yʌlʌyob: Tsa'ix tili ñuc bʌ x'alt'an ba' añonla. Dios tsa'ix i jula'ta winicob x'ixicob i cha'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tsa' pujqui t'an cha'an ñuc bʌ i melbal Jesús ti pejtelel Judea yic'ot ti pejtelel lum ti' joytilel. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jini xcʌnt'añob i cha'an Juan tsi' subeyob Juan pejtelel tsa' bʌ ujti. Juan tsi' pʌyʌ cha'tiquil. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tsi' chocoyob majlel ba'an lac Yum cha'an mi' c'ajtibeñob: ¿Jatet ba woli bʌ c pijtan lojon, o woli ba c pijtan lojon yambʌ? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Che' bʌ tsa' tiliyob jini winicob ba'an Jesús, tsi' subeyob: Tsi' chocoyon lojon tilel jini Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'. Juan woli' c'ajtin: “¿Jatet ba jini mu' bʌ i tilel o yom ba mic pijtan lojon yambʌ?” che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti jim bʌ ora Jesús tsi' lajmesa cabʌl xc'amʌjelob año' bʌ leco tac bʌ i chʌmel, yic'ot jini año' bʌ i xibʌjlel. Tsi' cambeyob i wut cabʌl xpots'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesús tsi' subeyob: Cucula. Subenla Juan chuqui tsa' la' q'uele yic'ot chuqui tsa' la' wubi, che'en. Wolix ti cha' c'otelob i wut jini xpots'ob. Woliyobix ti xʌmbal jini mach bʌ añobic i c'ʌjñibal i yoc. Lajmesʌbilobix jini año' bʌ leco bʌ i tsoy. Jini xcojcob wolix i yubiñob t'an. Woli' cha' tejchelob ch'ojyel jini chʌmeño' bʌ. Jini p'umpuño' bʌ woli' yubiñob jini wen t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tijicña jini mach bʌ anic mi' lon tejchel tile bixel bʌ i pusic'al cha'an c melbal, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Che' bʌ tsa' majliyob jini winicob chocbilo' bʌ tilel cha'an Juan, Jesús tsa' caji' suben jini tempʌbilo' bʌ bajche' yilal Juan: ¿Chuqui tsajni la' q'uel ti jochol bʌ lum? ¿Jim ba chiquib jam woli bʌ i yujcun ic'? ");
INSERT INTO ctuBl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Chuqui tsajni la' q'uel? ¿Jim ba juntiquil winic wen i t'ojol bʌ i pislel? La' wilan jini wen chumulo' bʌ mu' bʌ i lʌpob weñatax bʌ pisil añob ti' yototob reyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Chuqui tsajni la' q'uel? ¿Tsajni ba la' q'uel juntiquil x'alt'an? Isujm, mic subeñetla, ñumen ñuc jini Juan bajche' x'alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Come tsa' ña'tʌnti Juan ti jini t'an tsa' bʌ ts'ijbunti: “Awilan, mic ñaxan choc majlel subt'an mu' bʌ i chajpan a bijlel”, che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mic subeñetla: Ti pejtelel i yalobilob x'ixicob ma'anic yambʌ ñuc bʌ x'alt'an bajche' jini Juan tsa' bʌ i yʌc'ʌ ch'ʌmja'. Pero jini c'ax ch'o'ch'oc bʌ ti' yumʌntel Dios ñumen an i ñuclel bajche' Juan. Che' tsi yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pejtel winicob x'ixicob yic'ot xch'ʌm tojoñelob tsi' ña'tayob tojʌch Dios che' bʌ tsi' yubibeyob i t'an Juan. Tsi' ch'ʌmʌyob ja' ti' c'ʌb Juan. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero jini fariseojob yic'ot xcʌntesa mandarob tsi' ñusayob i pʌyol ti Dios yic'ot i coltʌntel. Come ma'anic tsi' ch'ʌmʌyob ja' ti' c'ʌb Juan. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","¿Bajche' mic lajin jini winicob x'ixicob año' bʌ ti pañimil wʌle? ¿Bajche' yilalob? ");
INSERT INTO ctuBl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lajalob bajche' alobob buchulo' bʌ ba'an choñoñibʌl woli bʌ i pʌyob i pi'ʌlob. Mi' yʌlob: “Tsac wusu lojon amʌy, ma'anic tsa' la' cha'le son. Tsa cuc'tʌbeyet lojon ch'ujlelʌl, ma'anic tsa' la' cha'le uq'uel”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Come Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja' tsa' tili. Ma'anic tsi' c'uxu waj, ma'anic tsi' japʌ vino. Mi la' wʌl: “An i xibʌjlel”. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","I Yalobil Winic tsa' tili. An chuqui mi' c'ux. An chuqui mi' jap. Woli la' wʌl: “Awilan, xwo'lel, jini xjap vino. Mi' pi'leñob ti xʌmbal jini xch'ʌm tojoñelob yic'ot xmulilob”, che'etla. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","I ña'tʌbal Dios mi' tsictiyel ti uts'at ti pejtel i yalobilob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Juntiquil fariseo tsi' sube Jesús ti wocol t'an cha'an mi' cha'len we'el yic'ot. Tsa' ochi Jesús ti' yotot jini fariseo. Tsa' buchle ti' t'ejl mesa. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Awilan, juntiquil x'ixic ti tejclum tsa' bʌ i cha'le mulil, che' bʌ tsi' ña'ta ya'an Jesús ti' t'ejl mesa ti' yotot jini fariseo, tsi' ch'ʌmʌ tilel jump'ejl alʌ limetej melbil bʌ ti xajlel but'ul ti xojocña bʌ ts'ac. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Che' ya' wa'al jini x'ixic ti' pat Jesús, tsa' caji ti uq'uel. Tsa' chʌjq'ui jubel i ya'lel i wut ti' yoc Jesús. Tsi' sujcube ti' tsutsel i jol. Tsi' ts'ujts'ube i yoc. Tsi' boño ti jini xojocña bʌ ts'ac. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jini fariseo tsa' bʌ i pʌyʌ tilel Jesús ti we'el tsi' q'uele. Tsi' ña'ta ti' pusic'al: X'alt'anic jini winic, tsa'ix i cʌñʌ ili x'ixic woli bʌ i tʌl. Tsa'ix i cʌmbe i melbal, come xmulilʌch jini x'ixic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús tsi' sube Simón: Simón, an chuqui mi caj c subeñet, che'en. Simón tsi' yʌlʌ: Subeñon, Maestro, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tsa' caji' yʌl Jesús: Juntiquil winic tsi' yʌq'ueyob taq'uin ti bet cha'tiquil xbetob. Juntiquil an i bet jo'c'al i cha'bajc' denario. Yambʌ an i bet lujump'ejl i yuxc'al denario. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma'añobic i chubʌ'an ili xbetob cha'an mi' tojob i bet. Jini winic tsi' ñusʌbeyob i bet ti cha'ticlelob. Ti cha'ticlel mi caj i c'uxbiñob jini winic tsa' bʌ i ñusʌbeyob i bet. Alʌ, che' jini ¿majqui mi caj i ñumen c'uxbin? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tsi' yʌlʌ Simón: Mi cʌl jini tsa' bʌ ñusʌbenti ñumen on bʌ i bet, che'en. Jesús tsi' cha' sube: Isujm bajche' tsa' ña'ta, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús tsi' sutq'ui i bʌ i q'uel jini x'ixic. Tsi' sube Simón: ¿Woli ba a q'uel jini x'ixic? Tsa' ochiyon ti a wotot. Ma'anic tsa' wʌq'ueyon ja' cha'an coc. Ili x'ixic tsa' chʌjq'ui jubel i ya'lel i wut ti coc. Tsi' sujcubeyon ti' tsutsel i jol. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma'anic tsa' ts'ujts'uyon. Pero ili x'ixic ma'anic tsi' cʌyʌ i ts'ujts'ubeñon coc c'ʌlʌl che' bʌ tsa' ochiyon. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma'anic tsa' boño c jol ti aceite. Pero ili x'ixic tsi' boño coc ti xojocña bʌ ts'ac. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jini cha'an mic subeñet, anquese cabʌl i mul ñusʌbilix ti pejtelel. Jini cha'an cabʌl mi' c'uxbiñon. Majqui mi' ñusʌbentel ts'ita' i mul ts'ita' jach mi' cha'len c'uxbiya, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tsi' sube x'ixic: Ñusʌbilix a mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jini buchulo' bʌ yic'ot Jesús ti' t'ejl mesa tsa' caji i yʌlob ti' pusic'al: ¿Ñuc ba jini winic cha'an mi' ñusan mulil? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús tsi' sube x'ixic: Coltʌbilet cha'an tsa' ñopo. Cucu ti' ñʌch'tilel a pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ti wi'il Jesús tsa' ñumi majlel ti pejtelel tejclum yic'ot ti pejtelel xchumtʌl. Tsi' subu jini wen t'an cha'an i yumʌntel Dios. Jini lajchʌntiquil xcʌnt'añob i cha'an tsi' pi'leyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tsi' pi'leyob majlel ja'el cha'tiquil uxtiquil x'ixicob tsa' bʌ lajmesʌntiyob cha'an i xibʌjlel yic'ot i chʌmel. Juntiquil x'ixic i c'aba' María, ch'oyol bʌ ti Magdala. Tsa' loq'uiyob wuctiquil xibajob ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ya'an ja'el Juana, i yijñam Chuza. Jini Chuza xq'uel e'tel i cha'an Herodes. Ya' an ja'el Susana, yic'ot cabʌl yaño' bʌ x'ixicob tsa' bʌ i c'ʌñʌyob i chubʌ'an cha'an mi' we'sañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tsi' tempayob i bʌ bajc'ʌl winicob x'ixicob. Tsa' tiliyob ba'an Jesús loq'uemo' bʌ ti cabʌl tejclum tac. Jesús tsi' pejcayob ti lajiya. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Tsi' yʌlʌ: Tsa' majli winic ti wejch'uya pac'. Che' woli' wejch'un majlel, tsa' yajli ts'ita' ti' ti' bij. Tsi' t'uchtayob winicob. Tsi' c'uxuyob te'lemut. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yambʌ tsa' yajli ti xajlelol. Che' bʌ tsa' coli, tsa' tiqui, come ma'anic ach'. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yambʌ tsa' yajli ti ch'ixol. Temel tsa' coli yic'ot jini ch'ix. Jini ch'ix tsi' tsʌnsa. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yambʌ tsa' yajli ti wen bʌ lum. Che' bʌ tsa' coli, tsi' yʌc'ʌ i wut jo'jo'c'al ti jujump'ejl. Che' tsi' yʌlʌ Jesús. Che' bʌ tsa' ujti i sub ili t'an, tsi' yʌlʌ ti c'am bʌ t'an: Jini am bʌ i chiquin cha'an mi' yubin, la' i yubin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jini xcʌnt'añob i cha'an tsi' c'ajtibeyob Jesús: ¿Chuqui i sujmlel jini lajiya? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús tsi' yʌlʌ: Aq'uebiletla cha'an mi la' cʌmben i sujmlel i yumʌntel Dios mach bʌ tsictiyemic ti yambʌ ora. Pero jini yaño' bʌ mic pejcañob ti lajiya cha'an mi' q'uelob, pero ma'anic mi' c'otelob i wut. Mi' yubiñob, pero ma'anic mi' ch'ʌmbeñob isujm. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jiñʌch i sujmlel jini lajiya: Jini pac' jiñʌch i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jini am bʌ ti' ti' bij jiñobʌch mu' bʌ i yubiñob t'an. Mi' tilel xiba. Mi' chilben loq'uel jini t'an ti' pusic'al cha'an ma'anic mi' ñopob ame mi' coltʌntelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jini año' bʌ ti xajlelol, jiñobʌch mu' bʌ i yubiñob jini t'an. Ti' tijicñʌyel i pusic'al mi' bʌc' jac'ob, pero ma'anic i wi' ti' pusic'al. Mi' poj ñopob, pero che' mi' yilʌbentelob i pusic'al mi' cha' cʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jini tsa' bʌ yajli ti ch'ixol jiñʌch tsa' bʌ i yubiyob jini t'an. Che' mi' majlelob, cabʌl i c'ojo'ol cha'an pañimil yic'ot chubʌ'añʌl yic'ot paxyal. Mi' c'unte' jisan jini am bʌ ti' pusic'al. Ma'anic mi' yʌc'ob i wut. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jini tsa' bʌ yajli ti wen bʌ lum jiñʌch mu' bʌ i yubiñob jini t'an. Toj i pusic'al. Uts'at i pusic'al. Mi' lotob jini t'an tsa' bʌ i yubiyob. Mi' yʌc'ob i wut ti' xuc'tilel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jini mu' bʌ i tsuc' candil ma'anic mi' mʌc ti p'ejt. Ma'anic mi' yʌc' ti yebal ch'ac. Mi' joc'chocon ti' joc'lib cha'an mi' pʌsbeñob i sʌclel jini mu' bʌ i yochelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ma'anic mucul tac bʌ mach bʌ anic mi' caj ti pʌstʌl. Ma'anic mucul tac bʌ mach bʌ anic mi' caj ti cʌjñel, come mi' caj ti tsictiyel ti' sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chʌcʌ q'uele la' bʌ cha'an mi la' wen ubin jini t'an, come majqui jach an i cha'an mi caj i yʌq'uentel yambʌ. Majqui jach ma'anic i cha'an mi caj i lu' chilbentel chuqui tac an i cha'an, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsa' tiliyob ba'an Jesús i ña' yic'ot i yerañob. Ma'anic tsa' mejliyob ti ochel ba'an Jesús cha'an cabʌl winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tsa' subenti Jesús: Ya' wa'alob a ña' a wijts'iñob ti' pat otot. Yomob i q'uelet, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús tsi' subeyob: Jini mu' bʌ i yubiñob i t'an Dios mu' bʌ i jac'ob jiñobʌch c ña' yic'ot quijts'iñob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ti yambʌ q'uin Jesús tsa' ochi ti barco yic'ot jini xcʌnt'añob i cha'an. Tsi' subeyob: La' c'axiconla ti junwejl ñajb, che'en. Tsa' cajiyob ti majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Che' woliyob ti xʌmbal majlel ti ja', tsa' caji ti wʌyel Jesús. Tsa' tili p'ʌtʌl bʌ ic' ti ñajb. Yom bujt'el ti ja' barco. Bʌbʌq'uen mi' chʌmelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tsa' tiliyob ba'an Jesús. Tsi' ñijcayob ch'ojyel. Tsi' subeyob: Maestro, Maestro, wolic jilel lojon, che'ob. Tsa' ch'ojyi Jesús. Tsi' tiq'ui jini ic' yic'ot jini wamlaw ch'inlaw bʌ ja'. Ñʌch'ʌcña pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús tsi' subeyob: ¿Bacan mi la' ñop? che'en. Tsi' cha'leyob bʌq'uen. Tsa' toj sajtiyob i pusic'al. Tsi' subeyob i bʌ: ¿Majqui jini? come jini ic' yic'ot ñajb mi' jac'ben i mandar, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Tsi' ñijcayob majlel barco c'ʌlʌl ti' lumal geraseñob ya' ti junwejl Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Che' bʌ tsa' c'oti ti lum Jesús, tsa' tili winic ch'oyol bʌ ti tejclum. Anix ora an i xibʌjlel. Ma'anic i pislel. Ma'anic mi' yajñel ti otot. Ya jach an ti' yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jini winic tsi' cha'le oñel che' bʌ tsi' q'uele Jesús. Tsi' yʌlʌ: ¿Chuqui i ye'tel ma' tilel ba' añon, Jesús, i Yalobilet bʌ Dios, jini C'ax Ñuc bʌ? Mic subeñet awocolic mach ma' tic'lañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Come Jesús tsi' sube loq'uel jini xiba ti' pusic'al winic. Anix ora chucul i cha'an. Tsi' cʌntayob ti cárcel jini winic. Tsi' cʌchʌyob ti cadena yic'ot ti' ñejt'il i c'ʌb i yoc. Pero jini winic tsi' ts'oco jini cadena tac. Jini xiba tsi' wersa ñijca majlel ti jochol bʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús tsi' c'ajtibe: ¿Chuqui a c'aba'? che'en. Tsi' yʌlʌ: J c'aba' Legión, che'en, come tsa' ochiyob cabʌl xibajob ti' pusic'al jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tsi' c'ajtibeyob ti wocol t'an cha'an ma'anic mi' chocob jubel ti ch'en mach bʌ anic i yebal. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ya'an bajc'ʌl chitam. Woli ti buc'bal ya' ti wits. Jini xibajob tsi' c'ajtibeyob Jesús ti wocol t'an cha'an mi' yʌc'ob ti ochel ti chitam. Jesús tsi' yʌc'ʌ i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jini xibajob tsa' loq'uiyob ti jini winic. Tsa' ochiyob ti chitam. Ti ajñel tsa' laj jubi chitam ti xitil bʌ wits. Tsa' ochi ti colem ñajb. Tsa' laj chʌmi ti ja'. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Che' bʌ tsi' q'ueleyob chuqui tsa' ujti, ti ajñel tsa' majliyob jini xcʌnta chitamob. Ya' ti tejclum yic'ot ti xchumtʌl tac tsi' subuyob chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tsa' loq'uiyob tilel winicob x'ixicob cha'an mi' q'uelob jini winic. Tsa' tiliyob ba'an Jesús. Ya' tsi' tajayob jini winic tsa' bʌ loq'ui i xibʌjlel, buchul ti' tojlel Jesús. Lʌpʌl i bujc. Anix i pusic'al. Tsi' cha'leyob bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jini tsa' bʌ i q'ueleyob tsi' subuyob bajche' tsa' coltʌnti jini winic am bʌ i xibʌjlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pejtelel winicob x'ixicob ch'oyolo' bʌ ti' joytilel i lumal geraseñob tsi' subeyob Jesús ti wocol t'an cha'an mi' loq'uel majlel ya' ba' añob. Come tsi' cha'leyob cabʌl bʌq'uen. Tsa' cha' ochi Jesús ti barco. Tsa' cha' majli. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jini winic tsa' bʌ chojqui loq'uel i xibʌjlel tsi' c'ajtibe Jesús ti wocol t'an cha'an mi' yʌc' i t'an cha'an mi yajñel yic'ot. Jesús tsi' choco majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Tsi' sube: Sujten ti a wotot. Suben a pi'ʌlob chuqui tac ñuc tsi' melbeyet Dios, che'en. Tsa' majli jini winic. Tsa' caji i puc t'an ti pejtelel tejclum cha'an chuqui tac ñuc tsi' melbe Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Che' bʌ tsa' cha' tili Jesús, tijicñayob tsi' q'ueleyob come tsi' pijtayob ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Awilan, tsa' tili winic i c'aba' Jairo, i yum sinagoga. Tsi' ñocchoco i bʌ ba'an Jesús. Tsi' c'ajtibe ti wocol t'an cha'an mi' yochel Jesús ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Come an jach juntiquil xch'oc bʌ i yalobil, yomix i taj lajchʌmp'ejl i jabilel. Wolix ti chʌmel. Che' bʌ tsa' majli Jesús, cabʌl winicob x'ixicob tsi' joy ñet'eyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","An juntiquil x'ixic mach bʌ anic tsa' wis tijq'ui i bec' i ch'ich'el lajchʌmp'ejl jab. Tsi' laj jisa pejtelel i chubʌ'an cha'an i tojol i ts'ʌcʌntel. Ma'anic majch tsa' mejli i lajmesan. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lʌc'ʌl tsa' tili ti' pat Jesús. Tsi' tʌlbe i yoc i pislel. Ti ora tsa' tijq'ui i bec' i ch'ich'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús tsa' caji' yʌl: ¿Majqui tsi' tʌlʌyon? che'en. Ti pejtelelob tsi' yʌlʌyob ma'anic tsi' tʌlʌyob. Pedro tsi' sube: Maestro, an cabʌl winicob x'ixicob ti a joytilel. Mi' ñet'etob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús tsi' yʌlʌ: An majqui tsi' tʌlʌyon. Ña'tʌbil c cha'an tsa' c'ʌjni c p'ʌtʌlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Che' yujilix jini x'ixic mach mejlix i muc i bʌ, tsiltsilña tsa' tili. Tsi' pʌcchoco i bʌ ti' tojlel i yoc Jesús. Tsi' subu ti' tojlel pejtelel winicob x'ixicob chucoch tsi' tʌlʌ. Che' bʌ tsi' tʌlʌ, tsa' lajmi ti ora. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús tsi' sube: Calobil, tsa' lajmiyet cha'an tsa' ñopoyon. Cucu ti' ñʌch'tilel a pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Che' bʌ woli to ti t'an, tsa' tili winic loq'uem bʌ ti' yotot i yum sinagoga. Tsi' yʌlʌ: Chʌmenix a walobil. Mach a chʌn mʌcben q'uin jini Maestro, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Che' bʌ tsi' yubi jini t'an, Jesús tsi' sube jini yumʌl: Mach a cha'len bʌq'uen. Chʌn ñopo ti a pusic'al. Che' jini, mi' caj i coltʌntel jini xch'oc, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Che' bʌ tsa' ochi Jesús ti' yotot jini yumʌl, ma'anic tsi' yʌc'ʌ ti ochel yaño' bʌ, jini jach Pedro yic'ot Jacobo yic'ot Juan yic'ot i tat i ña' jini xch'oc. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Woliyob ti uq'uel pejtelel winicob x'ixicob. Woli' yuc'tañob jini xch'oc. Jesús tsi' yʌlʌ: Cʌyʌx la' wuq'uel. Mach chʌmenic. Woli jach ti wʌyel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tsi' wajleyob come yujilob chʌmenix jini xch'oc. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús tsi' chucbe i c'ʌb jini xch'oc. Tsi' yʌlʌ ti c'am bʌ t'an: Xch'oc, ch'ojyen, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tsa' cha' ochi i ch'ujlel. Tsa' ch'ojyi ti ora. Jesús tsi' subeyob cha'an mi' we'sañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tsa' toj sajtiyob i pusic'al i tat i ña' jini xch'oc. Jesús tsi' subeyob mach yomic mi' subeñob i pi'ʌlob chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús tsi' pʌyʌ tilel jini lajchʌntiquil xcʌnt'añob i cha'an. Tsi' yʌq'ueyob i ye'tel yic'ot i p'ʌtʌlel ti' contra xibajob, yic'ot ti' contra pejtel c'amʌjel. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tsi' chocoyob majlel cha'an mi' subob jini wen t'an cha'an i yumʌntel Dios, cha'an mi' lajmesañob jini xc'amʌjelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús tsi' subeyob: Mach yomic chuqui mi la' ch'ʌm majlel ti bij, mi te' cha'an xʌmbal, mi chim, mi waj, mi taq'uin. Mach mi la' lʌp cha'p'ejl la' bujc. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Baqui jach bʌ otot mi la' wochel, ya' yom mi la' jijlel c'ʌlʌl mi la' loq'uel majlel ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Che' mi la' loq'uel ti tejclum ba' ma'anic mi' pʌyetla ochel ti' yotot, tijcanla loq'uel i ts'ubeñal la' woc cha'an mi' q'uelob, come mach wenic bajche' tsi' meleyob. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tsa' loq'uiyob majlel jini xcʌnt'añob. Tsi' pucuyob i bʌ ti pejtelel xchumtʌl tac. Tsi' subuyob jini wen t'an. Tsi' cha'leyob lajmesaya ti pejtelel lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tsa' caji' yubin jini yumʌl Herodes pejtelel chuqui tac tsi' mele Jesús. Cabʌl tsi' cha'le tsic pusic'al, come cha'tiquil uxtiquil tsi' yʌlʌyob tsa'ix tejchi ch'ojyel Juan ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yaño' bʌ tsi' yʌlʌyob tsa'ix cha' tsictiyi Elías. Yaño' bʌ tsi' yʌlʌyob tsa'ix cha' ch'ojyi juntiquil oñiyi bʌ x'alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tsi' yʌlʌ Herodes: Joñon tsa'ix c set' t'ojbe loq'uel i bic' Juan. ¿Majqui jini woli bʌ i mel ñuc bʌ i ye'tel? che'en. Yom i q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Che' bʌ tsa' cha' tiliyob jini chocbilo' bʌ majlel, tsi' subeyob Jesús pejtel chuqui tac tsi' cha'leyob. Jesús tsi' bajñel pʌyʌyob majlel ti colem bʌ i tiquiñal lum ti' tojel jini tejclum i c'aba' Betsaida. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Che' bʌ tsi' ña'tayob jini winicob x'ixicob, tsi' tsajcayob majlel. Jesús tsi' wen pejcayob. Tsi' subeyob t'an cha'an i yumʌntel Dios. Tsi' lajmesa jini año' bʌ i chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Che' wolix ti bʌjlel q'uin, tsa' tiliyob ba'an Jesús jini lajchʌntiquil. Tsi' subeyob: Subeñobix majlel ti xchumtʌl tac yic'ot ti tejclum cha'an mi' jijlelob ba' mi' tajob i bʌl i ñʌc', come wʌ' añonla ti jochol bʌ lum, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús tsi' subeyob: Aq'ueñob jatetla chuqui tac mi' c'uxob, che'en. Tsi' subeyob: Cojach an c cha'an lojon jo'q'uejl waj yic'ot cha'cojt chʌy. Mach jastʌyic. Yom mic majlel lojon c mʌn i bʌl ñʌc'ʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ya' añob jo'p'ejl mil winicob. Jesús tsi' sube xcʌnt'añob: Subeñob buchtʌl ti mojt ti mojt, che' bajche' lujuntiquil i yuxc'al ti jujunmojt, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Che'ʌch tsi' meleyob bajche' tsi' yʌlʌ. Tsi' subeyob buchtʌl ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús tsi' ch'ʌmʌ jini jo'q'uejl waj yic'ot cha'cojt chʌy. Tsi' letsa i wut ti panchan. Tsi' cha'le oración. Tsi' xet'e waj. Tsi' yʌq'ue xcʌnt'añob i cha'an cha'an mi' pucbeñob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tsi' c'uxuyob ti pejtelelob. Tsa' ñaj'ayob. Tsi' lotoyob lajchʌmp'ejl chiquib i xujt'il tac. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ti yambʌ q'uin che' bʌ tsi' bajñel pejca Dios Jesús, ya' añob xcʌnt'añob yic'ot. Jesús tsi' c'ajtibeyob: ¿Majquiyon mi' yʌlob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jini xcʌnt'añob tsi' subeyob: Cha'tiquil uxtiquil mi' yʌlob jatet Juanet, jini x'ac' ch'ʌmja'. Yaño' bʌ mi' yʌlob Elíaset. Yaño' bʌ mi' yʌlob juntiquil oñiyi bʌ x'alt'añet tsa' bʌ cha' ch'ojyi, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesús tsi' c'ajtibeyob: Jixcu jatetla, ¿majquiyon mi la' wʌl? che'en. Pedro tsi' jac'ʌ: Jatet Cristojet, yajcʌbil bʌ i cha'an Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús tsi' tiq'uiyob. Tsi' yʌq'ueyob mandar cha'an ma'anic mi' subeñob yambʌ mi juntiquilic. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Tsi' yʌlʌ: Wersa mi' yubin cabʌl wocol i Yalobil Winic. Wersa mi' ts'a'lentel cha'an xñoxob año' bʌ i ye'tel yic'ot ñuc bʌ motomajob yic'ot sts'ijbayajob. Mi caj i tsʌnsʌntel. Mi caj i cha' ch'ojyel ti yuxp'ejlel q'uin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesús tsi' subeyob ti pejtelelob: Mi an majqui yom i tsajcañon, la' i len cʌy chuqui yom ti' bajñel pusic'al, la' i ch'ʌm i cruz ti jujump'ejl q'uin, la' i tsajcañon. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Majqui jach yom i bajñel cʌntan i cuxtʌlel mi caj i sʌt. Jini mu' bʌ i yʌc' i cuxtʌlel cha'añon mi caj i cʌntan. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Come chuqui mi' taj winic mi tsi' lon ch'ʌmʌ pejtelel pañimil, mi tsa' sajti i ch'ujlel, mi tsi' jisa i bʌ? ");
INSERT INTO ctuBl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Majqui jach mi' quisniñon yic'ot c t'an, i Yalobil Winic ja'el mi caj i quisnin jini winic che' mi' tilel ti' ñuclel yic'ot i ñuclel i Tat yic'ot i ñuclel jini ch'ujul bʌ ángelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ti isujm mic subeñetla, lamital ili wa'alo' bʌ ma'anic mi caj i chʌmelob jinto che' mi' q'uelob i yumʌntel Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Che' bʌ tsa' ñumi che' bajche' waxʌcp'ejl q'uin che' ajlemix jini t'an, Jesús tsi' pʌyʌ majlel Pedro yic'ot Juan yic'ot Jacobo. Tsa' letsi majlel yic'otob ti wits cha'an mi' pejcan Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Che' woli ti oración, tsa' yʌjñi i wut Jesús. Tsa' sʌc'a i pislel. Ts'ʌylaw i sʌclel. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Awilan, cha'tiquil winicob tsi' pejcayob Jesús. Jiñobʌch Moisés yic'ot Elías. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tsa' tsictiyiyob yic'ot i ñuclel. Tsa' caji i subob bajche' mi caj i cʌy pañimil Jesús che' mi' yujtesan chuqui mi caj i mel ya' ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Suts'atax i wut Pedro yic'ot i pi'ʌlob cha'an yomob wʌyel. Che' cañal i wut tsi' q'ueleyob i ñuclel Jesús yic'ot jini cha'tiquil winicob ya' bʌ añob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Che' bʌ tsa' cajiyob ti majlel jini cha'tiquil, Pedro tsi' sube Jesús: Maestro, uts'at mi laj cʌytʌl ilayi. La' c mel lojon uxp'ejl lejchempat, jump'ejl cha'añet, jump'ejl cha'an Moisés, jump'ejl cha'an Elías, che'en. Ma'anic tsi' ña'ta Pedro chuqui woli yʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Che' woli to i yʌl jini t'an tsa' tili jump'ejl tocal. Tsi' mosoyob. Tsi' cha'leyob bʌq'uen jini xcʌnt'añob che' bʌ tsa' mosleyob ti tocal. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tsa' loq'ui t'an ti tocal. Tsi' yʌlʌ: Jiñʌch Calobil tsa' bʌ c yajca. Ubinla i t'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Che' bʌ tsa' ujti jini t'an, ya'ʌch an Jesús ti' bajñelil. Jini xcʌnt'añob ñʌch'ʌl tsa' cʌleyob. Cabʌl q'uin ma'anic tsi' wis subeyob yaño' bʌ chuqui tac tsi' q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti yijc'ʌlal che' bʌ tsa' jubiyob ti wits, cabʌl winicob x'ixicob tsa' tiliyob i taj Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Awilan, juntiquil tsa' bʌ tili tsi' yʌlʌ ti c'am bʌ t'an: Maestro, mij c'ajtibeñet awocolic q'uele calobil, come jiñʌch cojach bʌ calobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Awilan, jini xiba mi' choc. Mi' bʌc' cajel ti oñel. Jini xiba mi' yʌc' ti juquin chʌmel jinto mi' loq'uel i lojc i yej. Mi' chʌn tic'lan. Wocol mi' poj cʌy. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tsaj c'ajtibe xcʌnt'añob a cha'an ti wocol t'an cha'an mi' chocob loq'uel. Ma'anic tsa' mejliyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús tsi' jac'ʌ: Winicob x'ixicob año' bʌ wʌle mach bʌ anic mi la' ñop, sojquemetla. ¿Jayp'ejl to q'uin wʌ' añon la' wic'ot? ¿Jayp'ejl to q'uin mij cuchbeñetla la' sajtemal? Pʌyʌ tilel a walobil wʌ' ba' añon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Che' woli to i tilel i tat jini ch'iton, jini xiba tsi' wersa ñijca jini ch'iton. Tsi' yʌc'ʌ ti juquin chʌmel. Jesús tsi' tiq'ui jini xiba. Tsi' lajmesa jini ch'iton. Tsi' cha' ac'ʌ ti' wenta i tat. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tsa' toj sajtiyob i pusic'al ti pejtelelob che' bʌ tsi' q'ueleyob i ñuclel i p'ʌtʌlel Dios. Che' bʌ tsa' toj sajtiyob i pusic'al cha'an chuqui tac tsi' cha'le Jesús, tsa' caji i suben xcʌnt'añob i cha'an: ");
INSERT INTO ctuBl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","La' ochic ti la' chiquin jini c t'an, come i Yalobil Winic mi caj i yʌjq'uel ti' c'ʌb winicob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ma'anic tsi' ch'ʌmbeyob isujm jini t'an, come mucbil i sujmlel i t'an cha'an ma'anic mi' ch'ʌmbeñob isujm. Ma'anic tsi' c'ajtiyob i sujmlel come woliyob ti bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tsa' caji i cʌlʌx pejcañob i bʌ cha'an mi' bajñel yajcañob majqui ñumen ñuc ti' tojlelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús tsi' ña'ta chuqui woli' yʌlob ti' pusic'al. Tsi' pʌyʌ tilel juntiquil alob. Tsi' yʌc'ʌ ti' t'ejl. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tsi' subeyob: Majqui jach mi' c'uxbin jini alob tij c'aba' mi' c'uxbiñon. Majqui jach mi' c'uxbiñon mi' c'uxbin c Tat tsa' bʌ i chocoyon tilel. Come jini ñumen ch'o'ch'oc bʌ ti la' tojlel jiñʌch ñumen ñuc bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan tsi' sube: Maestro, tsaj q'uele lojon juntiquil mu' bʌ i choc loq'uel xibajob ti a c'aba'. Tsac tiq'ui lojon come ma'anic mi' tsajcañon lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús tsi' sube: Mach mi la' tic', come jini mach bʌ anic mi' contrajiñonla woli' coltañonla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Che' i yorajlelix che' mux caj i pʌjyel majlel ti panchan, ti jump'ejl jach i pusic'al tsa' caji ti majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Tsi' choco majlel winicob ti' tojel i wut. Tsa' ochiyob ti jump'ejl i tejclum samaritanojob cha'an mi' chajpʌbeñob ba' mi' jijlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero jini winicob x'ixicob ma'anic tsi' pʌyʌyob ochel come tsiquil wersa yom majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","55","Che' bʌ tsi' ña'tayob Jacobo yic'ot Juan, xcʌnt'añob i cha'an, tsi' subeyob: C Yum, ¿a wom ba mic cha'len lojon mandar cha'an mi' jubel tilel c'ajc ti panchan cha'an mic jisañob che' bajche' tsi' mele Elías? che'ob. Jesús tsi' sutq'ui i bʌ i q'uelob. Tsi' tiq'uiyob: ");
INSERT INTO ctuBl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma'anic tsa' tili i Yalobil Winic cha'an mi' jisan winicob x'ixicob, pero cha'an mi' coltañob, che'en. Tsa' majliyob ti yambʌ xchumtʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Che' woli' majlelob ti bij, juntiquil winic tsi' sube Jesús: C Yum, mi caj c tsajcañet baqui jach ma' majlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús tsi' sube: An i met wax. An i c'u' te'lemut, pero ma'anic i yajñib ba' mi' c'aj i yo i Yalobil Winic che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús tsi' sube yambʌ winic: Tsajcañon, che'en. Jini winic tsi' sube: C Yum, la' ñaxan majlicon c muc c tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús tsi' sube: La' i mucob chʌmeño' bʌ jini chʌmeño' bʌ i pi'ʌlob. Pero jatet, cucu, subu i yumʌntel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yambʌ winic tsi' sube Jesús: Mi caj c tsajcañet, c Yum. Pero la' ñaxan majlicon c subeñob jini año' bʌ ti cotot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús tsi' sube: Jini mu' bʌ i q'uel i pat che' woli' top' lum, ma'anic i c'ʌjñibal ti' yumʌntel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Che' ujtemix iliyi, lac Yum tsi' yʌq'ueyob i ye'tel yambʌ lajchʌntiquil i chʌnc'al (72). Tsi' chocoyob majlel ti cha'cha'tiquil cha'an mi' majlelob ti ñaxan ti pejtelel tejclum yic'ot xchumtʌl ba' mi caj i majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tsi' subeyob: Isujm, cabʌl jini c'ajbal pero ma'anic jaytiquil x'e'telob. Jini cha'an c'ajtibenla i yum c'ajbal cha'an mi' choc majlel x'e'telob ti c'ajbal. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cucula. Awilan, mic choquetla majlel che' bajche' tiñʌme' joyol bʌ ti bʌte'el ts'i'. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mach mi la' ch'ʌm majlel i yajñib taq'uin, mi chim, mi xʌñʌbʌl. Mach mi la' wʌq'ueñob cortesía jini xñumelob ti bij. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Baqui jach mi la' wochel ti otot ñaxan subula: La' tilic i ñʌch'tilel i pusic'al jini año' bʌ ti jini otot. Che' yom mi la' sub. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mi ya'an juntiquil yom bʌ i taj i ñʌch'tilel i pusic'al, aq'uenla i yutslel la' t'an cha'an mi' taj i ñʌch'tilel i pusic'al. Mi mach yomic, ma'anic mi caj i taj. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ya' yom mi la' jijlel ti jini jach bʌ otot ba' pʌybilet. C'uxula, japʌla chuqui mi la' wʌq'uentel. Come uts'at mi' yʌq'uentelob i tojol x'e'telob. Mach mi la' c'axel ti jujump'ejl otot. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Che' mi la' wochel ti colem tejclum ba' uts'at mi' pʌyetla ochel, c'uxula chuqui jach mi' yʌq'ueñetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mi an xc'amʌjelob ya' ba' mi la' wochel, c'oq'uesañob. Subeñob: “Tsa'ix juli i yumʌntel Dios wʌ' ba' añetla”, che'etla. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Che' mi la' wochel ti colem tejclum ba' ma'anic mi' pʌyetla ochel, ñumenla ti calle tac. Subula jini t'an: ");
INSERT INTO ctuBl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Jini ts'ubejn tsa' bʌ i toybeyon lojon coc ti la' tejclum mic tijcan loq'uel cha'an i yejtal la' contrajintel. Ña'tanla lʌc'ʌlix i yumʌntel Dios”. Che' yom mi la' sub. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mic subeñetla: Ñumen wocol mi caj i yubiñob ti jini tejclum bajche' jini ch'oyolo' bʌ ti Sodoma che' ti' q'uiñilel tojmulil. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mi caj la' taj wocol añet bʌ la ti Corazín. Mi caj la' taj wocol añet bʌ la ti Betsaida. Come tsa'ic mejli ñuc bʌ e'tel ti Tiro yic'ot Sidón che' bajche' tsa' mejli ba' añetla tsi' cʌyʌyob i mul. Tsa' buchleyob, tsi' xojoyob i tsutsel chivo. Tsi' mujlayob i bʌ yic'ot i tʌñil c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jini cha'an, ñumen wocol mi caj i yubiñob ti' q'uiñilel tojmulil jini chumulo' bʌ ti jini tejclum bajche' jini ch'oyolo' bʌ ti Tiro yic'ot Sidón. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jixcu jatet Capernaum, mu' bʌ a q'uel a bʌ ti ñuc che' bajche' i ñuclel panchan, mi caj a chojquel jubel ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jini c'ux bʌ mi yubiñetla c'ux mi' yubiñon. Jini mu' bʌ i ts'a'leñetla, mi' ts'a'leñon. Jini mu' bʌ i ts'a'leñon mi' ts'a'len jini tsa' bʌ i chocoyon tilel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tsa' cha' tiliyob jini lajchʌntiquil i chʌnc'al. Tijicñayob, tsi' subeyob: C Yum, jini xibajob mi' loq'uelob che' mic subeñob loq'uel ti a c'aba', che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús tsi' subeyob: Tsaj q'uele Satanás che' bʌ tsa' yajli ti panchan che' bajche' i xu'il chajc. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","La' wilan, mi cʌq'ueñetla la' p'ʌtʌlel cha'an mi la' t'uchtan lucum yic'ot siñan yic'ot pejtelel i p'ʌtʌlel la' contra. Ma'anic chuqui mi caj i tumbeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mach yomic tijicñayetla cha'an woli' loq'uelob xibajob cha'an ti la' t'an. Pero yom tijicñayetla cha'an ts'ijbubil la' c'aba' ti panchan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti jim bʌ ora tijicña i pusic'al Jesús cha'an jini Espíritu. Tsi' yʌlʌ: Mic subeñet a ñuclel, c Tat, i Yumet panchan yic'ot pañimil. Come tsa' mucbeyob a t'an jini año' bʌ cabʌl i ña'tʌbal yic'ot jini p'ip'o' bʌ i pusic'al, pero tsa' wʌq'ueyob i ch'ʌmbeñob isujm alʌlob. Uts'atʌch, c Tat, come che'ʌch yom a pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pejtelel chuqui tac an, aq'uebilon i cha'an c Tat. Ma'anic majqui mi' cʌñon cojach c Tat. Che' ja'el, ma'anic majqui mi' cʌn c Tat cojach joñon come i Yalobilon. Mi' cʌñob c Tat ja'el majqui jach mi cʌq'uen i cʌn. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tsa' caji i suben xcʌnt'añob che' i bajñel añob: Tijicñayob jini mu' bʌ i q'uelob chuqui tac mi la' q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Come mic subeñetla, cabʌl x'alt'añob yic'ot reyob wersa yomob i q'uel jini woli bʌ la' q'uel pero ma'anic tsi' q'ueleyob. Yomob i yubiñob jini woli bʌ la' wubin pero ma'anic tsi' yubiyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Awilan, tsa' wa'le juntiquil xcʌntesa mandar cha'an mi' yilʌben i pusic'al Jesús. Tsa' caji i c'ajtiben: Maestro, ¿chuqui yom mic cha'len cha'an mic taj j cuxtilel mach bʌ anic mi' jilel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús tsi' sube: ¿Chuqui ts'ijbubil ti mandar? ¿Chuqui ma' q'uel ti jun? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tsi' jac'ʌ: “C'uxbin a Yum Dios ti pejtelel a pusic'al, ti pejtelel a ch'ujlel, ti pejtelel a p'ʌtʌlel, ti pejtelel a ña'tʌbal. C'uxbin a pi'ʌlob che' bajche' ma' bajñel c'uxbin a bʌ”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús tsi' sube: Weñʌch bajche' tsa' jac'ʌ. Che'ʌch yom ma' mel. Che' jini, mi caj a taj a cuxtʌlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jini winic yom i q'uel i bʌ ti toj, jini cha'an tsi' sube: ¿Majqui c pi'ʌlob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús tsi' jac'ʌ: Juntiquil winic tsa' loq'ui ti Jerusalén cha'an mi' majlel ti Jericó. Tsi' chucuyob xujch'ob. Tsi' lu' chilbeyob i chubʌ'an yic'ot i pislel. Tsi' lowoyob. Tsa' majliyob. Ts'ita jax yom chʌmel che' bʌ tsi' cʌyʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tsa' tili juntiquil motomaj ya' ti jini bij. Che' bʌ tsi' q'uele jini lojwem bʌ, tsa' ñumi ti junwejl i ti' bij. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Che'ʌch tsi' mele juntiquil leví ja'el che' bʌ tsa' tili ba'an. Tsa jach i q'uele. Tsa' ñumi ti junwejl i ti' bij. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero juntiquil samaritano, che' woli ti xʌmbal ti bij, tsa' c'oti ba'an jini lojwem bʌ. Che' bʌ tsi' q'uele tsi' p'unta. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tsa' tili i pixben i lojwel. Tsi' yotsʌbe aceite yic'ot vino. Tsi' c'ʌchchoco ti' c'ʌchlib. Tsi' pʌyʌ majlel ti' yotlel wʌyibʌl ba' tsi' cʌnta. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ti yijc'ʌlal che' yomix majlel, tsi' loc'sa cha'p'ejl denario. Tsi' yʌq'ue i yum otot. Tsi' sube. “Cʌntʌbeñon jini winic. Mi ñumen ma' jisan taq'uin mu' to c tojbeñet che' mic cha' tilel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","¿Bajche' ma' wʌl? che'en Jesús. Tsa' ñumiyob uxtiquil winicob. ¿Majqui tsi' pʌsʌ i bʌ ti' pi'ʌl jini tsa' bʌ chujqui cha'an xujch'ob? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jini winic tsi' yʌlʌ: Jini tsa' bʌ i p'unta, che'en. Jesús tsi' sube: Cucu. Che'ʌch yom ma' mel ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Che' bʌ tsa' majli ti bij, Jesús tsa' c'oti ti xchumtʌl. Juntiquil x'ixic i c'aba' Marta tsi' pʌyʌ ochel ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","An i yijts'in jini Marta, i c'aba' María. María tsa' buchle ti' tojel Jesús. Tsi' ñich'tʌbe i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta tsa' caji i mel i pusic'al, come cabʌl i ye'tel. Tsa' tili ba'an Jesús. Tsi' yʌlʌ: C Yum, ¿mach ba anic ma' q'uel bajche' mi' cʌyon quijts'in cha'an mic bajñel cha'len e'tel? Suben cha'an mi' coltañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesús tsi' sube: Marta, Marta, cabʌl ma' tsic a pusic'al, cabʌl ma' mel a pusic'al cha'an a we'tel. ");
INSERT INTO ctuBl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Junchajp jach yom. María tsi' yajca jini wem bʌ. Ma'anic mi caj i chilbentel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tsa' majli Jesús ba' tsi' pejca Dios. Che' bʌ tsa' ujti ti oración, juntiquil xcʌnt'an i cha'an tsi' sube: C Yum, cʌntesañon lojon bajche' yom mic pejcan lojon Dios, che' bajche' Juan tsi' cʌntesa xcʌnt'añob i cha'an ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús tsi' subeyob: Che' mi la' pejcan Dios, yom mi la' wʌl: C Tat lojon añet bʌ ti panchan, la' ch'ujutesʌntic a c'aba', la' tilic a yumʌntel, la' mejlic chuqui a wom ti pañimil che' bajche' ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aq'ueñon lojon wʌle c waj cha'an ili q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ñusʌbeñon lojon c mul che' bajche' mic ñusʌbeñob i mul c pi'ʌlob lojon. Mach ma' wʌc'on lojon ba' mic pʌjyel lojon ti mulil. Cʌntañon lojon ame yajlicon lojon ti jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús tsi' subeyob ja'el: Mi an a cʌñʌ bʌ, ¿mach ba muq'uic a majlel ti ojlil ac'ʌlel a suben: “C pi'ʌl, la' c majñan uxq'uejl a waj? ");
INSERT INTO ctuBl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Come juntiquil c pi'ʌl tsa' tili i jula'tañon. Ma'anic chuqui mi cʌq'uen i c'ux”, che'et. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jini am bʌ ti' mal otot mi' subeñet: “Mach a tic'lañon. Ñup'ulix i ti' cotot. Wʌyʌlonix quic'ot calobilob. Mach mejlicon ti ch'ojyel cha'an mi cʌq'ueñet”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mic subeñetla: Anquese cʌñʌlet i cha'an, mach yomic ch'ojyel i yʌq'ueñet jini waj, pero che' ma' chʌn c'ajtiben mi caj i ch'ojyel i yʌq'ueñet chuqui yom. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Joñon mic subeñetla: C'ajtinla, mi caj la' wʌq'uentel. Sajcanla, mi caj la' taj. Pejcanla i yum otot, mi caj la' jambentel. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Come jujuntiquil mu' bʌ i c'ajtin mi' yʌq'uentel. Jini mu' bʌ i sajcan mi' taj. Jini mu' bʌ i pejcan i yum otot mi caj i jambentel. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Am ba juntiquil mu' bʌ i yʌq'uen xajlel i yalobil che' mi' c'ajtiben waj? ¿Mu' ba a wʌq'uen lucum che' mi' c'ajtibeñet chʌy? ");
INSERT INTO ctuBl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Mu' ba a wʌq'uen siñan che' mi' c'ajtibeñet tumut? ");
INSERT INTO ctuBl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jatetla jontolet bʌ la, la' wujil la' wʌq'uen la' walobil chuqui uts'at. La' Tat am bʌ ti panchan, ¿mach ba ñumen yujilic i yʌq'ueñob jini Ch'ujul bʌ Espíritu jini mu' bʌ i c'ajtibeñob? Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tsa' caji i choc loq'uel ti winic juntiquil xiba tsa' bʌ i yotsa winic ti x'uma'. Che' bʌ tsa'ix chojqui loq'uel i xibʌjlel tsa' caji ti t'an jini x'uma'. Tsa' toj sajtiyob i pusic'al winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Cha'tiquil uxtiquil tsi' yʌlʌyob: Ti' p'ʌtʌlel Satanás, i yum xibajob, mi' choc loq'uel xibajob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yaño' bʌ tsi' c'ajtibeyob cha'an mi' pʌsbeñob i yejtal i p'ʌtʌlel ti panchan, cha'an mi' yilʌbeñob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yujil Jesús chuqui woli' yʌlob ti' pusic'al. Tsi' subeyob: Mi tsi' t'oxoyob i bʌ ti leto i winicob juntiquil yumʌl, mi' jilel i yumʌntel. Mi' jilel jump'ejl otot ba' mi' t'oxob i bʌ ti leto. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Che' ja'el, mi woli' bajñel contrajin i bʌ Satanás, ¿bajche' mi' mejlel ti jalijel i yumʌntel? Come mi la' wʌl wolic choc loq'uel xibajob ti' p'ʌtʌlel Satanás. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mi wolic choc loq'uel xibajob ti' p'ʌtʌlel Satanás, ¿baqui mi' tajob i p'ʌtʌlel la' walobilob cha'an mi' chocob loq'uel? Jini cha'an la' walobilob mi caj i tsictesañob la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mi wolic choc loq'uel xibajob ti' p'ʌtʌlel i c'ʌb Dios, isujm tsa'ix juli i yumʌntel Dios ba' añetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Che' p'ʌtʌl i yum otot che' chajpʌbil yic'ot juloñib, ma'anic mi' tic'lʌbentel i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Che' mi' tilel ñumen p'ʌtʌl bʌ i chuc i yum otot, mi' mʌjlel i cha'an. Mi' chilben i juloñib tsa' bʌ i lon ña'ta i c'ʌn i coltan i bʌ. Mi' puc jini tsa' bʌ i chili. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jini mach bʌ anic quic'ot woli' contrajiñon. Jini mach bʌ anic mi' pʌy tilel tiñʌme' ba' añon woli jach i pam puc. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Che' mi' loq'uel i xibʌjlel ti' pusic'al winic, mi' cha'len xʌmbal ba' tiquin pañimil. Mi' sajcan ba' mi' c'aj i yo. Che' ma'anic mi' taj, mi' yʌl: “Muq'uix c cha' majlel ti cotot ba' tsa' loq'uiyon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Che' mi' c'otel, misubil mi' taj, chajpʌbilix. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mi' majlel i pʌy tilel yambʌ wuctiquil espíritujob ñumen jontolo' bʌ. Mi' yochelob ti chumtʌl. Ñumen leco mi' caj ti ajñel jini winic ti wi'il bajche' ti ñaxan. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Che' bʌ tsa' ujti i sub ili t'an Jesús, juntiquil x'ixic ya' ti' yojlil winicob x'ixicob tsi' cha'le c'am bʌ t'an. Tsi' yʌlʌ: Tijicña jini x'ixic tsa' bʌ i cʌntayet, tijicña jini tsa' bʌ i tsu'sayet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús tsi' sube: Ñumen tijicñayob mu' bʌ i yubibeñob i t'an Dios mu' bʌ i jac'ob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Che' bʌ tsi' tempayob i bʌ ba'an Jesús tsa' caji i yʌl: Jontolob jini winicob x'ixicob año' bʌ wʌle. Woli' sʌclañob i yejtal c p'ʌtʌlel. Ma'anic mi caj i yʌq'uentelob i q'uel, jini jach i yejtal c p'ʌtʌlel tsa' bʌ pʌsle ti Jonás. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Che' bajche' tsa' pʌsbentiyob nínivejob i yejtal c p'ʌtʌlel ti Jonás, che' ja'el mi caj i pʌstʌl i Yalobil Winic cha'an mi' ñopob año' bʌ ti pañimil wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jini x'ixic tsa' bʌ i cha'le yumʌl ya' ti Sur mi caj i wa'tʌl ti' q'uiñilel melo'mulil yic'ot jini winicob año' bʌ ti pañimil wʌle. Mi caj i subeñob i mul. Come jini x'ixic tsa' tili ti ñajtʌl cha'an mi' cʌmben i ña'tʌbal Salomón. Awilan, wʌ'an ñumen ñuc bʌ bajche' Salomón. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jini winicob ch'oyolo' bʌ ti Nínive, mi caj i wa'tʌlob ti' q'uiñilel melo'mulil yic'ot jini año' bʌ ti pañimil wʌle. Mi caj i subeñob i mul. Come tsi' cʌyʌyob i mul che' bʌ tsi' cha'le subt'an Jonás. Awilan, wʌ'an ñumen ñuc bʌ bajche' Jonás. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ma'anic majqui mi' muc candil che' tsuc'bilix. Ma'anic mi' ñup' ti chiquib. Mi' joc'chocon ti' joc'lib cha'an mi' pʌsbeñob i c'ʌc'al jini mu' bʌ i yochelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jini a wut lámparajʌch cha'an a bʌc'tal. Mi weñʌch a wut ma' wen q'uel i sʌclel pañimil. Mi mach wenic a wut añet ti ac'ʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Q'uele che' jini, ame i'ic'ic ma' q'uel i sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mi añet ti' sʌclel pañimil mi mach i cha'añetic ac'ʌlel, puro i sʌclel pañimil ma' pʌs che' bajche' lámpara. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Che' bʌ tsi' cha'le t'an Jesús, juntiquil fariseo tsi' pʌyʌ cha'an mi' cha'len we'el yic'ot. Tsa' ochi Jesús. Tsa' buchle ti' t'ejl mesa. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jini fariseo leco tsi' q'uele Jesús come ma'anic tsi' ñaxan poco i c'ʌb che' bʌ tsa' caji ti we'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lac Yum tsi' sube: Jatetla, fariseojet bʌ la, mi la' wen pocben i pat jini vaso yic'ot latu, pero but'ul la' pusic'al ti xujch' yic'ot cabʌl jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tontojetla. Jini tsa' bʌ i mele la' bʌc'tal, ¿mach ba anic tsi' mele la' pusic'al ja'el? ");
INSERT INTO ctuBl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aq'ueñob p'ump'uño' bʌ chuqui an la' cha'an, che' jini, sʌc pejtelel chuqui mi caj a q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Mi caj la' taj wocol, fariseojob! Mi la' wʌq'uen Dios i diezmojlel jini pimel i c'aba' menta, yic'ot ruda, yic'ot jujunchajp pimel, pero mi la' junyajlel ñusan toj bʌ meloñel yic'ot i c'uxbiya Dios. Mach yomic mi la' cʌy la' wʌq'uen i diezmojlel tac la' chubʌ'an, pero yom mi la' p'is ti wenta ili ñuc tac bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Mi caj la' taj wocol fariseojob! come mi la' mulan ñaxan bʌ buchlibʌl ti sinagoga. Mi la' mulan la' wʌq'uentel cabʌl cortesía ba'an choñoñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Mi caj la' taj wocol sts'ijbayajob, fariseojob, cha'p'ejl jach la' pusic'al! Lajaletla bajche' mucoñibʌl mach bʌ tsiquilic. Winicob mi' cha'leñob xʌmbal ti' pam che' mach yujilobic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Juntiquil xcʌntesa mandar tsi' sube Jesús: Maestro, che' ma' cha'len t'an bajche' jini wolix a wʌ'leñon lojon ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús tsi' yʌlʌ: ¡Mi caj la' taj wocol ja'el, xcʌntesa mandaret bʌla! Mi la' wʌq'ueñob winicob al bʌ i cuch mach bʌ mejlic i lʌt'ob. Pero jatetla, ma'anic mi la' tʌl jini cuchʌl mi ti junts'ijtic i yal la' c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Mi caj la' taj wocol! Come mi la' melbeñob i yotlel ch'ujlelʌl jini x'alt'añob tsʌnsʌbilo' bʌ i cha'an la' ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Woli la' tsictesan la' bʌ. Woli la' lon ña'tan uts'at bajche' tsi' meleyob la' ñojte'el. Come isujm la' ñojte'el tsi' tsʌnsayob x'alt'añob. Jatetla mi la' melbeñob jini x'alt'añob i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jini cha'an, Dios ja'el tsa'ix i yʌlʌ ti' ña'tʌbal: “Mi caj c chocbeñetla majlel x'alt'añob yic'ot apóstolob. Ojlil mi caj la' tsʌnsañob. Ojlil mi caj la' tic'lañob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Jini cha'an jini año' bʌ ti pañimil wʌle mi caj i tojbeñob i mul jini tsa' bʌ i tsʌnsayob x'alt'añob c'ʌlʌl ti' cajibal pañimil che' bʌ tsa' tsʌnsʌnti Abel, c'ʌlʌl tsa' tsʌnsʌnti Zacarías. Zacarías tsa' tsʌnsʌnti ya' ti' tojel Templo ti junwejl jini pulʌntib. Isujm mic subeñetla, jini año' bʌ ti pañimil wʌle mi caj i tojob. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Mi caj la' taj wocol, xcʌntesa mandarob! Come mach la' womic la' wʌq'ueñob i tajob i ña'tʌbal. Jatetla, ma'anic tsa' ochiyetla. Che' ja'el, tsa' la' mʌcta jini woliyo' bʌ ti ochel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Che' bʌ tsa' ujti ti t'an Jesús, jini sts'ijbayajob yic'ot fariseojob, maña jax tsi' pejcayob. Cabʌl chuqui tsa' caji i c'ajtibeñob Jesús cha'an mi' yʌquiñob ti' t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tsi' chʌcʌ ñich'tʌbeyob i t'an cha'an mi' jop'beñob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ti jim bʌ ora tsi' tempayob i bʌ wen cabʌl winicob x'ixicob jinto che' wolix i t'uchtʌbeñob i bʌ i yoc. Jesús tsa' caji i ñaxan pejcan xcʌnt'añob i cha'an. Tsi' yʌlʌ: Chʌcʌ q'uele la' bʌ cha'an i levadura fariseojob, jiñʌch i cha'p'ejlel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Come ma'anic mosol tac bʌ mach bʌ anic mi' caj ti pʌstʌl. Ma'anic mucul tac bʌ mach bʌ anic mi' caj ti ña'tʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mi caj i yubintel ti jamʌl chuqui tac tsa' la' subu ti mucul. Chuqui tac tsa' la' wʌlʌ mi' caj ti sujbel ti pejtelel otot. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mic subeñetla, c pi'ʌlob, mach mi la' bʌc'ñan jini mu' bʌ i tsʌnsan la' bʌc'tal pero ti wi'il ma'anix chuqui mi mejlel i tumbeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi caj c wʌn subeñetla majqui yom mi la' bʌc'ñan. Yom mi la' bʌc'ñan jini am bʌ i p'ʌtʌlel cha'an mi' choquetla ochel ti c'ajc che' mi' yʌq'uetla ti chʌmel. Isujm mic subeñetla, jini jach yom mi la' bʌc'ñan. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Mach ba mi' chojñel jo'cojt xpuruwoc ti cha'p'ejl taq'uin? Mach ñajʌyemic mi juncojtic ti' pusic'al Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Che' ja'el, tsicbil i tsutsel la' jol. Jini cha'an mach mi la' cha'len bʌq'uen. Come jatetla, ñumen an la' c'ʌjñibal bajche' cabʌl xpuruwoc. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Mic subeñetla: Majqui jach mi' sub i bʌ ti' tojlel winicob x'ixicob cha'an i cʌñʌyʌch i Yalobil Winic joñon ja'el mi caj c sub ya' ti' tojlel i yángel Dios j cʌñʌyʌch jini winic ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Majqui jach mi' subeñob winicob x'ixicob mach i cʌñʌyonic, mi' caj ti sujbel ya' ti' tojlel i yángelob Dios cha'an mach cʌñʌlic jini winic ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Majqui jach mi' cha'len t'an ti' contra i Yalobil Winic mi caj i ñusʌbentel i mul. Majqui jach mi' cha'len p'ajoñel ti' contra jini Ch'ujul bʌ Espíritu ma'anic mi caj i ñusʌbentel i mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Che' mi' pʌyetla majlel ti sinagoga tac ti' tojlel yumʌlob yic'ot año' bʌ i ye'tel, mach la' mel la' pusic'al cha'an bajche' mi' caj ti loq'uel la' t'an yic'ot bajche' mi caj la' jac', yic'ot chuqui mi caj la' sub. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Come jini Ch'ujul bʌ Espíritu mi caj i cʌntesañetla ti jim bʌ ora chuqui yom mi la' sub. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Che' motocñayob winicob x'ixicob juntiquil tsi' sube Jesús: Maestro, suben jini cʌscun cha'an mi' t'oxbeñon i chubʌ'an c tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús tsi' sube jini winic: ¿Am ba que'tel ti meloñel cha'an mic t'oxbeñetla la' chubʌ'an? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tsi' subeyob: Chʌcʌ q'uele la' bʌ cha'an ma'anic chuqui tac mi la' tsʌjyun. Mach cuxulobic winicob cha'an ti cabʌl i chubʌ'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesús tsi' subeyob ja'el jini lajiya. Tsi' yʌlʌ: Awilan, tsi' wen ac'ʌ i wut pejtelel chuqui tsi' pʌc'ʌ ti lum juntiquil wen chumul bʌ winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jini winic tsa' caji i bajñel ña'tan ti' pusic'al: “¿Chuqui mi caj c mel? Come ma'anix i yotlel ba' mic lot i wut c pʌc'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","An chuqui mi caj c mel. Mi caj c jem i yotlel tac. Mi caj c cha' mel ñumen colem bʌ. Ya' mi caj c lot pejtelel i wut c pʌc'ʌb yic'ot c chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi caj c bajñel ña'tan tic pusic'al: Cabʌl jax c chubʌ'an lotbil cha'an mij c'ʌn ti cabʌl jab. La' j c'aj co. La' j c'ux c waj. La' c jap chuqui com. La' cubin i tijicñʌyel c pusic'al”. Che' tsi' yʌlʌ jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Dios tsi' sube jini winic: “Tontojet, ti jini jach bʌ ac'ʌlel talob i pʌy majlel a ch'ujlel. Che' jini, ¿majqui i cha'an pejtelel a chubʌ'an tsa' bʌ a tempa?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Junlajal jini mu' bʌ i p'ojlesan cabʌl i chubʌ'an cha'an mi' bajñel c'ʌn, pero ma'anic chuqui mi' taj ti Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús tsi' sube xcʌnt'añob i cha'an: Jini cha'an mic subeñetla, mach mi la' mel la' pusic'al cha'an la' cuxtʌlel wʌ' ti pañimil, mi cha'an chuqui mi la' c'ux, mi cha'an chuqui mi la' xoj. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ñumen i c'ʌjñibal la' bʌc'tal bajche' la' pislel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ña'tanla jini xwachin. Ma'anic mi' cha'len pac' mi c'ajbal. Ma'anic i yotlel ba' mi' tempan i buc'bal. Dios mi yʌq'uen i buc'bal. ¿Mach ba ñumen c'uxbibiletic la bajche' te'lemut? ");
INSERT INTO ctuBl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Am ba majch mi mejlel i ñumen chan'an cha'an ti cabʌl mel pusic'al? Ma'anic. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mach mejlic la' mel chuqui tac mach ñuquic ti' melol. ¿Chucoch che' jini, mi la' mel la' pusic'al cha'an jini yan tac bʌ? ");
INSERT INTO ctuBl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ña'tanla bajche' mi' colel jini sʌsʌc bʌ i nich pimel. Ma'anic mi' cha'len e'tel, mi ñoq'uijel. Pero mic subeñetla, mach yoque i t'ojolic i pislel Salomón ti pejtelel i ñuclel bajche' i nich jini pimel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","I t'ojol jax mi' mel pimel Dios, jini pimel cuxul bʌ wʌle ti jamil mu' bʌ caj i chojquel ti c'ajc ti yijc'ʌlal. Mi che' mi' mel, ¿mach ba muq'uic i yʌq'ueñetla chuqui mi la' xoj jatetla mach bʌ anic mi la' ñop ti pejtelel la' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mach la' mel la' pusic'al cha'an chuqui mi caj la' cu'x mi chuqui mi caj la' jap. Mach mi la' tsic la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Come pejtelel ili tac mi' sʌclañob ti pañimil. Yujil la' Tat pejtelel chuqui tac yom la' cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jini cha'an sajcanla i yumʌntel Dios. Che' jini mi caj la' wʌq'uentel pejtelel chuqui tac yom. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mach mi la' cha'len bʌq'uen anquese mach cabʌleticla come la' Tat tsi' pʌyʌyetla ti' yumʌntel, come che'ʌch yom i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Choño la' chubʌ'an. Aq'uen la' chubʌ'an p'umpuño' bʌ. Melela i yajñib la' taq'uin mach bʌ anic mi' ñox'an. Tempan la' chubʌ'an ti panchan ba' ma'anic mi' jilel, ba' ma'anic mi' yochelob xujch', ba' ma'anic mi' jisan motso'. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Baqui jach tempʌbil la' chubʌ'an ya' mi la' teñe ac' la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yom chajpʌbiletla. Yom tsuc'bil la' lámpara. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ajñenla bajche' mi' yajñelob x'e'telob woli bʌ i pijtañob i yum mu' bʌ i cha' tilel ti' yotot che' mi' yujtel i q'uiñilel ñujpuñijel. Che' jini, che' mi' c'otel i pejcañob ti' yotot, mi' jambeñob ti ora. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tijicñayob jini x'e'telob woli bʌ i pijtañob i yum che' mi' tilel. Isujm mic subeñetla, i yum mi caj i chajpan i bʌ. Mi caj i subeñob buchtʌl ti c'ux waj jini x'e'telob i cha'an. Mi caj i tilel i yʌq'ueñob i bʌl i ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mi tsa' tili i yum che' yomix i taj ojlil ac'ʌlel o mi che' ñumenix ti ojlil ac'ʌlel, tijicñayob jini x'e'telob mu' bʌ i tajtʌlob che' woliyob ti pijt. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pero ña'tanla yom yʌxʌl la' wo. Tsa'ic i ña'ta i yum otot baqui ora mi' tilel xujch', isujm tsi' chʌcʌ q'uele i yotot cha'an ma'anic mi' jambentel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yom chajpʌbiletla ja'el, come tal i Yalobil Winic ti' yorajlel che' mach yʌxʌlic la' wo. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro tsa' caji i c'ajtiben: C Yum, jini t'an mu' bʌ a sub ti lajiya, ¿woli ba a subeñon lojon, o woli ba a suben pejtelel winicob x'ixicob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lac Yum tsi' yʌlʌ: ¿Majqui jini xuc'ul bʌ xq'uel e'tel am bʌ cabʌl i ña'tʌbal? Jini xq'uel e'tel tsa' aq'uenti i ye'tel ti' yum cha'an mi' yʌq'ueñob i bʌl i ñʌc' jini año' bʌ ti' yotot che' ti' yorajlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tijicña jini x'e'tel uts'at bʌ woli' mel che' mi' sujtel i yum. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Isujm mic subeñetla, i yum mi caj i yʌq'uen ti' wenta pejtelel i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mi tsi' yʌlʌ ti' pusic'al jini x'e'tel: “Jal to tal c yum”, mi che'en, mi tsa' caji i jats' jini x'e'telob, winicob yic'ot x'ixicob, mi tsi' bajñel cha'le we'el uch'el, mi tsa' caji ti yʌc'ʌjel, ");
INSERT INTO ctuBl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","che' jini mi caj i c'otel i yum jini x'e'tel ti jump'ejl q'uin che' mach yʌxʌlic i yo, che' ti yorajlel mach ña'tʌbilic i cha'an. Mi caj i yʌc' ti tojmulil. Mi caj i yotsan ba' añob jini mach bʌ xuc'ulobic. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Come jini x'e'tel tsi' ña'ta chuqui yom i yum, pero ma'anic tsi' chajpa i bʌ cha'an mi' mel. Jini cha'an cabʌl mi caj i jajts'el ti asiyal. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jini x'e'tel mach bʌ cʌñʌlic i cha'an chuqui yom i yum, mi tsi' mele chuqui mach wenic, ts'ita jach mi caj i jajts'el ti asiyal. Jini cabʌl bʌ mi' yʌq'uentel ti' majtan, cabʌl an ti' wenta cha'an mi' c'ʌn ti uts'at. Che' cabʌl mi' yʌq'uentel ti' wenta, ñumen cabʌl mi caj i c'ajtibentel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tsa' tiliyon cha'an mic choc tilel c'ajc ti pañimil. Tijicñayon tsa'ic tsujq'ui. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","An wocol mu' bʌ c wersa ñusan mu' bʌ caj i tilel che' bajche' but'ja'. Cabʌl wolic cha'len tsic pusic'al jinto mi' yujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Woli ba la' lon ña'tan tsa' tiliyon cha'an mic ñʌch'chocon jini año' bʌ ti pañimil? Mic subeñetla mach cha'anic jini. Tsa' tiliyon cha'an mi cʌq'ueñob i t'oxob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Wʌle, c'ʌlʌl ti' jilibal mi caj i t'oxob i bʌ año' bʌ ti jujump'ejl otot. Mi an jo'tiquil, mi' t'oxob i bʌ uxtiquil ti' contra cha'tiquil, cha'tiquil ti' contra uxtiquil. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mi caj i t'oxob i bʌ i tat ti' contra i yalobil, i yalobil ti' contra i tat, i ña' ti' contra i yixic'al, i yixic'al ti' contra i ña', i yʌ'lib ti' contra i yʌ'lib, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tsi' sube winicob x'ixicob ja'el: Che' mi la' q'uel jump'ejl tocal mu' bʌ i loq'uel tilel ba' mi' bʌjlel q'uin, ti ora mi la' wʌl tal ja'al. Isujm, che'ʌch mi' yujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Che' mi' tilel ic' loq'uem bʌ ti sur, mi la' wʌl mux i tilel ticwal. Che'ʌch mi yujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Cha'p'ejl jach la' pusic'al! Mi la' ña'tʌben i sujmlel chuqui tac mi la' q'uel ti pañimil yic'ot ti panchan. ¿Chucoch mach mejlic la' ña'tʌben i sujmlel jini woli bʌ ti ujtel wʌle? ");
INSERT INTO ctuBl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Chucoch ma'anic mi la' ña'tan ti la' bajñelil chuqui toj? ");
INSERT INTO ctuBl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Che' ma' majlel ba'an jini am bʌ i ye'tel, ñopo a mel a bʌ yic'ot a contra che' temel añetla ti bij cha'an ma'anic mi' wersa pʌyet majlel ba'an xmel mulil. Che' jini, jini xmel mulil mi caj i yʌq'uet ti' c'ʌb xcʌnta cárcel. Jini xcʌnta cárcel mi caj i yotsañet ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mic subeñet, ma'anic mi caj a loq'uel ya'i jinto ma' toj. Ma'anic mi caj a cʌybentel mi jump'ejlic centavo. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti jim bʌ ora ya' añob cha'tiquil uxtiquil tsa' bʌ i subeyob Jesús chuqui tsi' mele Pilato che' bʌ tsi' tsʌnsa galileojob. Tsi' xʌbeyob i ch'ich'el galileojob yic'ot i ch'ich'el jini tsʌnsʌbil bʌ i majtan tsa' bʌ i yʌq'ueyob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús tsi' c'ajtibeyob: ¿Mu' ba la' wʌl ñumen cabʌl i mul ili galileojob bajche' i mul pejtelel i pi'ʌlob cha'an che'ʌch tsa' ujtiyob bajche' jini? ");
INSERT INTO ctuBl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mic subeñetla, ma'anic. Mi ma'anic mi la' cʌy la' mul che'ʌch mi caj la' jilel ja'el ti la' pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jixcu jini waxʌclujuntiquilob tsa' bʌ chʌmiyob che' bʌ tsa' tejñiyob ti chan bʌ ts'ajc che' bʌ tsa' yajli ya' ti Siloé. ¿Mu' ba la' wʌl ñumen cabʌl i mul bajche' pejtelel chumulo' bʌ ti Jerusalén? ");
INSERT INTO ctuBl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mic subeñetla, ma'anic. Mi ma'anic mi la' cʌy la' mul che'ʌch mi caj la' jilel ja'el ti la' pejtelel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tsi' subeyob ti lajiya: Juntiquil winic an i cha'an higuera te' pʌc'bil ti' ts'usubil. Tsa' tili i q'uel mi anix i wut. Ma'anic tsi' taja. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tsi' sube xcʌnta ts'usubil: “Awilan, uxp'ejlix jab wolic tilel cha'an mij q'uel mi anix i wut higuera te'. Ma'anic tsac tajbe. Seq'uex. ¿Chuqui to i ye'tel mi' chʌn mʌctan lum?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jini xcʌnta tsi' jac'be i yum: “La' to ajñic yambʌ jab jinto mic joy picben i yebal. Mi caj cotsʌben i ta' alʌc'ʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mi tsi' yʌc'ʌ i wut, uts'at. Mi ma'anic mi' yʌc' i wut, ti wi'il mi caj a sec'”. Che' tsi' yʌlʌ jini winic, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti' q'uinilel c'aj o tsa' caji ti cʌntesa Jesús ti sinagoga. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Awilan, ya'an x'ixic am bʌ i c'amʌjel. Waxʌclujump'ejl (18) jab ma'anic tsa' mejli i toj'esan i pat cha'an i xibʌjlel. C'uchucña tsi' cha'le xʌmbal. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús tsi' pʌyʌ tilel jini x'ixic che' bʌ tsi' q'uele. Tsi' sube: X'ixic lajmesʌbiletix ti a c'amʌjel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tsi' yʌc'ʌ i c'ʌb ti jini x'ixic. Ti ora, tsa' toj'esʌbenti i pat. Tsi' tsictesa i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tsa' mich'a i yum sinagoga, come Jesús tsi' cha'le lajmesaya ti' q'uiñilel c'aj o. Tsi' subeyob winicob x'ixicob: Wʌcp'ejl q'uin mi lac cha'len e'tel. Ti jim bʌ ora yom mi la' tilel cha'an mi la' lajmesʌntel, mach ti' q'uiñilelic c'aj o, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lac Yum tsi' sube: Cha'chajp jax la' pusic'al ti jujuntiquiletla. ¿Mach ba muq'uic a tic jini tat wacax yic'ot a burro ba' cʌchʌl ti' buc'ujib che' ti' q'uiñilel c'aj o cha'an ma' pʌy majlel ba' mi' jap ja'? ");
INSERT INTO ctuBl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Mach ba yomic mi' yʌjq'uel ti colel ti' q'uiñilel c'aj o ili x'ixic, i yalobil Abraham chucbil bʌ i cha'an Satanás waxʌclujump'ejl jab? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Che' bʌ tsi' subu ili t'an, tsi' cha'leyob quisin pejtelel i contrajob. Pejtelel winicob x'ixicob tijicña jax tsi' yubiyob cha'an pejtelel jini ñuc tac bʌ i melbal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús tsi' yʌlʌ: ¿Bajche' yilal i yumʌntel Dios? ¿Chuqui yic'ot mi mejlel c lajin? ");
INSERT INTO ctuBl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lajalʌch bajche' i bʌc' mostaza tsa' bʌ i ch'ʌmʌ winic. Tsi' wejch'u ti lum. Tsa' coli. Tsa' ochi ti colem te'. Tsa' tili te'lemut. Tsi' meleyob i c'u' tac ti' c'ʌb jini te', che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tsi' cha' alʌ: ¿Chuqui yic'ot mi mejlel c lajin i yumʌntel Dios? ");
INSERT INTO ctuBl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lajalʌch bajche' levadura tsa' bʌ i ch'ʌmʌ juntiquil x'ixic. Tsi' yotsa ti uxp'is harina, jinto tsi' xaxa ti pejtelel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tsa' ñumi majlel Jesús ti pejtelel tejclum yic'ot ti xchumtʌl tac. Tsi' cha'le cʌntesa che' woli' majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Juntiquil tsi' sube: C Yum, ¿mach ba anic jaytiquilob mu' bʌ i coltʌntelob? che'en. Jesús tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Cha'lenla wersa cha'an mi la' wochel ti ch'o'ch'oc bʌ i ti'. Come mic subeñetla cabʌlob mi caj i ñopob ochel pero ma'anic mi caj i mejlelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","I yum otot mi caj i ch'ojyel i ñup'ben i ti' otot. Ti wi'il mi caj la' wa'tʌl ti' pat otot. Mi caj la' pejcan i yum ya' ti' ti' otot. Mi caj la' wʌl: “C Yum, c Yum, jambeñon lojon”, che'etla. I yum otot mi caj i subeñetla: “Mach cujilic baqui ch'oyoletla”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Mi caj la' wʌl: “Tsac cha'le lojon we'el uch'el ti a tojlel. Jatet tsa' cha'le cʌntesa ti yojlil c tejclum tac lojon”, che'etla. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","I yum otot mi caj i subeñetla: “Mic subeñetla, mach cujilic baqui ch'oyoletla. Loq'uenla tic tojlel pejteleletla mu' bʌ la' cha'len jontolil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ya' mi la' caj ti cabʌl uq'uel yic'ot quech'ecña i bʌquel la' wej, che' mi la' q'uel Abraham yic'ot Isaac yic'ot Jacob yic'ot pejtelel x'alt'añob ti' yumʌntel Dios che' chocbiletixla. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mi caj i tilelob cabʌl ch'oyolo' bʌ ti' pasibal q'uin yic'ot ti' bʌjlibal q'uin yic'ot ti norte yic'ot ti sur. Mi caj i buchtʌlob ti' t'ejl mesa ya' ti' yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Awilan, an wi'ilobix bʌ mu' bʌ caj i c'axelob majlel ti ñaxan. An ñaxaño' bʌ mu' bʌ caj i cʌytʌlob ti wi'ipat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti jini jach bʌ q'uin tsa' tiliyob fariseojob. Tsi' subeyob Jesús: Cucu, loq'uen wʌ'i come Herodes yom i tsʌnsañet, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús tsi' subeyob: Cucula, subenla jini wax: “Awilan, mic choc loq'uel xibajob. Mic cha'len lajmesaya wʌle yic'ot ijc'ʌl. Ti yuxp'ejlel q'uin mi cujtesan que'tel”. Che'ʌch yom ma' suben. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wersa mic cha'len xʌmbal wʌle, yic'ot ijc'ʌl, yic'ot chabi come mach mejlic ti tsʌnsʌntel x'altan ti yambʌ tejclum, ya' jach ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén, Jerusalén, mu' bʌ a tsʌnsan x'alt'añob, mi la' jul ti xajlel jini chocbilo' bʌ tilel ba' añetla. Anix jayyajl com c tempan la' walobilob che' bajche' mi' luts' i yal jini ña'a mut, pero mach la' womic. ");
INSERT INTO ctuBl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","La' wilan, jocholix tsa' cʌle la' wotot. Mic subeñetla ma'anic mi caj la' q'uelon jinto mi' tilel i yorajlel che' mi caj la' wʌl: “La' sujbic i ñuclel jini woli bʌ i tilel ti' c'aba' lac Yum”. Che'ʌch mi caj la' wʌl, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ti jump'ejl i q'uiñilel c'aj o che' bʌ tsa' ochi Jesús ti c'ux waj ti' yotot fariseo am bʌ i ye'tel ti yumʌl, jini winicob tsi' chʌcʌ q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Awilan, ya'an juntiquil winic ti' tojel Jesús, sijt'em i bʌc'tal. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús tsi' sube fariseojob yic'ot xcʌntesa mandarob: ¿Chuqui mi' yʌl mandar? ¿Tic'bil ba lajmesaya che' ti' yorajlel c'aj o? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ma'anic tsi' jac'ʌyob. Jesús tsi' pʌyʌ tilel jini winic. Tsi' lajmesa. Tsi' sube majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesús tsi' pejcayob. Tsi' subeyob: Mi an la' walobil, o mi an la' cha'an tat wacax, mi tsa' yajli ti ch'en, ¿mach ba muq'uic la' bʌc' chuc loq'uel anquese i yorajlel c'aj o? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma'anic tsa' mejli i jac'beñob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Che' bʌ tsi' q'uele wolix i yajcañob ñaxan bʌ buchlibʌl ti mesa jini pʌybilo' bʌ ti q'uiñijel, Jesús tsa' caji i subeñob ti lajiya: ");
INSERT INTO ctuBl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Che' pʌybilet majlel ti c'ux waj ba' woliyob ti q'uinijel cha'an ñujpuñijel, mach ma' buchtʌl ti ñaxan bʌ buchlibʌl. Ma'tica an yambʌ pʌybil bʌ ñumen ñuc bajche'et. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Che' mi' tilel i yum q'uin tsa' bʌ i pʌyʌyetla tilel ti la' cha'ticlel, mi caj i subeñet cha'an ma' wʌq'uen a buchlib ili winic. Che' jini quisintic mi caj a wubin che' ma' majlel ti buchtʌl ti jini cojix bʌ buchlibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Che' pʌybilet majlel ti q'uiñijel, cucu, buchi' ti wi'ilix bʌ buchlibʌl. Che' julemix jini tsa' bʌ i pʌyʌyet tilel ti q'uiñijel tic'ʌl mi' subeñet: “Queran, la' ti buchtʌl ti ñumen uts'at bʌ buchlibʌl”, che'en. Che' jini, ñuc mi caj a q'uejlel ti' wut jini buchulo' bʌ ti' t'ejl mesa. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Majqui jach chan mi' mel i bʌ mi caj i peq'uesʌntel. Majqui pec' mi' mel i bʌ mi caj i chañ'esʌntel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús tsi' sube ja'el jini winic tsa' bʌ i pʌyʌ tilel ti q'uiñijel: Che' ma' mel q'uin, mach ma' pʌy tilel a cʌñʌyo' bʌ, mi a wijts'iñob, mi a pi'ʌlob, mi jini wen chumulo' bʌ, ame i cha' pʌyetob majlel ti q'uiñijel. Che' jini ma' cha' q'uextʌbentel. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Che' ma' mel q'uin, pʌyʌ tilel jini mach bʌ añobic i chubʌ'an, yic'ot mach bʌ weñobic i c'ʌb, yic'ot mach bʌ weñobic i yoc yic'ot xpots'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mi caj a taj i tijicñʌyel a pusic'al come mach mejlic i cha' q'uextʌbeñet. Mi caj a q'uextʌbentel che' mi' cha' ch'ojyelob jini tojo' bʌ, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Che' bʌ tsi' yubi juntiquil buchul bʌ ti' t'ejl mesa ba'an Jesús, tsi' sube: Tijicña jini mu' bʌ i c'ux waj ti' yumʌntel panchan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús tsi' sube: Juntiquil winic tsi' mele colem q'uin. Tsi' pʌyʌ tilel cabʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ti' yorajlel q'uin tsi' choco majlel x'e'tel i cha'an cha'an mi' suben jini pʌybilo' bʌ: “La'ix cula. Laj chajpʌbilix”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tsa' cajiyob ti t'an cha'an mach yomobic majlel. Jini ñaxan bʌ tsi' yʌlʌ: “Tsac mʌñʌ lum. Wersa mic majlel j q'uel c lum. Awocolic mach mejlicon ti majlel j q'uel q'uin”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yambʌ tsi' yʌlʌ: “Tsac mʌñʌ lujuncojt tat wacax. Sami j q'uel mi wen yujil e'tel. Awocolic mach mejlicon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yambʌ tsi' yʌlʌ: “Tsa' ujtiyon ti ñujpuñel. Jini cha'an mach mejlicon ti majlel j q'uel q'uin”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tsa' sujti jini x'e'tel. Tsi' laj sube i yum bajche' tsa' ujti. Mich'ix i yum otot, tsi' sube x'e'tel i cha'an: “Cucu ti ora ti choñoñibʌl yic'ot ti calle ya' ti tejclum. Pʌyʌ tilel jini mach bʌ añobic i chubʌ'an, yic'ot mach bʌ weñobic i c'ʌb, yic'ot mach bʌ weñobic i yoc, yic'ot xpots'ob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jini x'e'tel tsi' sube i yum: “Che'ʌch tsac cha'le bajche' tsa' subeyon. An to jochol bʌ buchlibʌl tac”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","I yum tsi' sube: “Cucu ti colem bij yic'ot ti mucu bij. Yom ma' wersa pʌyob tilel cha'an mi' bujt'el cotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Come jini ñaxan pʌybilo' bʌ tilel ti q'uiñijel ma'anic mi caj i wis c'uxob jini we'elʌl tsa' bʌ c mele, mi juntiquilic”, che'en. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Motocñayob tsa' majliyob yic'ot Jesús. Tsi' sutq'ui i bʌ Jesús i q'uelob. Tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mi an majqui mi' ñochtañon mach bʌ anic mi' ts'a'len i tat, i ña', i yijñam, i yalobilob, i yijts'iñob, i yʌscuñob, i chichob, yic'ot i cuxtʌlel ja'el, mach mejlic ti ochel ti xcʌnt'an c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jini mach bʌ anic mi' ch'ʌm i cruz i tsajcañon, mach mejlic ti ochel ti xcʌnt'an c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Mi an majqui yom i mel chan bʌ q'ueloñib, ¿mach ba ñaxanic mi' buchtʌl i tsicben i tojol cha'an mi' ña'tan mi jasʌl i taq'uin cha'an mi' yujtel i mel? ");
INSERT INTO ctuBl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mi tsi' mele i c'ʌclib pero mi ma'anic tsa' mejli i yujtesan, mi caj i wajleñob pejtelel mu' bʌ i q'uelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mi caj i yʌlob: “Jini winic tsa' caji i wa'chocon chan bʌ q'ueloñib, pero ma'anic tsa' mejli i yujtesan”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Che' ja'el mi an juntiquil rey mu' bʌ i majlel ti guerra ti' contra yambʌ rey, ¿mach ba ñaxanic mi' buchtʌl i ña'tan mi jasʌl lujump'ejl mil soldadojob cha'an mi' contrajin junc'al mil mu' bʌ i tilelob ti' contra? ");
INSERT INTO ctuBl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mi tsi' ña'ta mach mejlic i cha'an, mi' choc majlel winic ba'an i contrajob che' ñajt to añob. Mi' c'ajtibeñob ti wocol t'an cha'an ma'anic mi' techob guerra. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Che' ja'el, mi an juntiquil mach bʌ yomic i len cʌy pejtelel i chubʌ'an, mach mejlic ti ochel ti xcʌnt'an c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Uts'at ats'am. Mi tsa' sajti i tsajel ats'am, ¿bajche' mi caj i cha' tsaj'esʌntel? ");
INSERT INTO ctuBl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mi tsa' sajti i tsajel ma'anic i c'ʌjñibal cha'an lum, mi cha'anic mi' xʌbob yic'ot i ta' alʌc'ʌl. Winicob mi' chocob. Jini am bʌ i chiquin cha'an mi' yubin, la' i yubin. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tsa' caji i tilelob pejtelel xch'ʌm tojoñelob yic'ot xmulilob ba'an Jesús cha'an mi yubibeñob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jini fariseojob yic'ot sts'ijbayajob tsa' cajiyob ti wulwul a'leya. Tsi' yʌlʌyob: Jesús mi' pʌy tilel xmulilob. Mi' c'ux waj yic'otob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús, tsi' subeyob ili t'an ti lajiya: ");
INSERT INTO ctuBl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Mi an juntiquil winic am bʌ jo'c'al i tiñʌme', mi tsa' sajti juncojt, ¿mach ba muq'uic i cʌy bolonlujuncojt i jo'c'al ti jochol bʌ lum cha'an mi' majlel i sajcan jini sajtem bʌ jinto mi' taj? ");
INSERT INTO ctuBl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Che' bʌ tsa'ix i taja, tijicña i pusic'al mi' yʌc' ti' quejlab. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Che' mi' c'otel ti' yotot, mi' pʌy tilel i cʌñʌyo' bʌ yic'ot i pi'ʌlob ti chumtʌl. Mi' subeñob: “Yom tijicñayetla quic'ot, come tsac taja c tiñʌme' tsa' bʌ sajti”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mic subeñetla, ñumen tijicñayob i pusic'al mi' yubiñob jini año' bʌ ti panchan che' mi' cʌy i mul juntiquil xmulil. Ts'ita jach mi' yubiñob cha'an bolonlujuntiquil i jo'c'al tojo' bʌ mach bʌ añobic i mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Mi tsi' sʌtʌ jump'ejl dracma juntiquil x'ixic anquese lujump'ejl dracma i cha'an, ¿mach ba anic mi' tsuc' c'ajc? ¿Mach ba anic mi' misun otot? ¿Mach ba anic mi' wen sʌclan jinto mi' taj? ");
INSERT INTO ctuBl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Che' bʌ tsa'ix i taja mi' pʌy tilel i cʌñʌyo' bʌ yic'ot i pi'ʌlob ti chumtʌl. Mi' subeñob: “Yom tem tijicñayetla quic'ot, come tsac taja jini taq'uin tsa' bʌ c sʌtʌ”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Che' ja'el mic subeñetla, tijicñayob i yángelob Dios cha'an juntiquil xmulil mu' bʌ i cʌy i mul. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tsi' yʌlʌ ja'el: Juntiquil winic an cha'tiquil i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jini ijts'iñʌl bʌ tsi' sube i tat: “C tat, aq'ueñon a chubʌ'an che' bajche' c'amel yom mic ch'ʌm”, che'en. I tat tsi' t'oxbeyob i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Che' ñumenix cha'p'ejl uxp'ejl q'uin, jini ijts'iñʌl bʌ i yalobil tsi' ch'ʌmʌ pejtelel i chubʌ'an. Tsa' majli ti ñajt bʌ lum. Ya'i tsi' lon jisa pejtelel i chubʌ'an. Tsi' to'o ñusa q'uin ti mulil. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Che' lu' jilemix i taq'uin tsa' tejchi cabʌl wi'ñal ti jini lum. Tsa' caji i yubin wi'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tsa' majli ti e'tel ba'an juntiquil winic ti jini lum. Jini winic tsi' choco majlel ti jamil cha'an mi' buc'san chitam. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jini ch'iton yom i c'uxben i buc'bal chitam, come ma'anic majqui tsi' yʌq'ue i bʌl i ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Che' bʌ tsa' caji i ña'tan pañimil tsi' yʌlʌ: “An x'e'telob ya' ti' yotot c tat año' bʌ cabʌl i waj. Pero joñon wolic chʌmel ti wi'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi caj c ch'ojyel. Muq'uix c majlel ba'an c tat. Mi caj c suben c tat: Tsac cha'le mulil ti' contra jini am bʌ ti panchan yic'ot ti a tojlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mach uts'aticon cha'an mic pejcʌntel ti a walobil. Otsañon ti x'e'tel a cha'an”. Che' tsi' ña'ta i suben i tat. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tsa' ch'ojyi. Tsa' majli ba'an i tat. Che' ñajt to i tilel, i tat tsi' q'uele. Tsi' p'unta. Ti ajñel tsa' majli i taj i yalobil. Tsi' meq'ue. Tsi' ts'ujts'u. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","I yalobil tsi' sube: “C tat, tsac cha'le mulil ti' contra jini am bʌ ti panchan yic'ot ti a tojlel. Mach uts'aticon cha'an mic pejcʌntel ti a walobil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","I tat tsi' sube x'e'telob i cha'an: “Ch'ʌmʌla tilel jini ñumen uts'at bʌ bujcʌl. Xojbenla. Otsʌbenla mʌtc'ʌbʌl ti' c'ʌb yic'ot xʌñʌbʌl ti' yoc. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pʌyʌla tilel jini jujp'em bʌ alʌ tat wacax. Tsʌnsanla. La' laj c'ux. La' lac mel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Come ili calobil chʌmen yubil ti yambʌ ora, pero wʌle tsa'ix cha' cuxtiyi yubil. Jini sajtem bʌ tsa'ix cha' tajle”, che'en. Tsa' caji i yubiñob i tijicñʌyel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ya'an jini ascuñʌl bʌ i yalobil ti jamil. Che' bʌ wolix i tilel ti' yotot che' lʌc'ʌlix an, tsi' yubi música yic'ot son. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tsi' pʌyʌ juntiquil x'e'tel. Tsi' c'ajtibe chuqui woli ti ujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jini x'e'tel tsi' sube: “Tsa'ix juli a wijts'in. Tsa'ix i tsʌnsa jujp'em bʌ alʌ wacax a tat come c'oc' tsi' cha' taja a wijts'in”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jini ascuñʌl bʌ tsa' caji ti mich'ajel. Mach yomic ochel. Jini cha'an tsa' loq'ui tilel i tat. Tsi' sube ti wocol t'an cha'an mi' yochel. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jini ascuñʌl bʌ tsi' sube i tat: “Awilan cabʌl jab tsac melbeyet a we'tel. Ma'anic tsac ñusʌbeyet a t'an. Ma'anic ba' tsa' wʌq'ueyon mi jinic jach alʌ chivo cha'an mic mel q'uin quic'ot c pi'ʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Che' bʌ tsa' tili a walobil tsa' bʌ i jisʌbeyet a chubʌ'an ti' ts'i'lel yic'ot i yixicob, tsa' tsʌnsʌbe jini jujp'em bʌ alʌ wacax”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","I tat tsi' sube: “Calobil, ti pejtelel q'uin wʌ' añet quic'ot. Pejtelel c chubʌ'an a cha'añʌch. ");
INSERT INTO ctuBl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yom mi lac mel q'uin. Yom mi la cubin i tijicñʌyel lac pusic'al, come chʌmen yubil a wijts'in ti yambʌ ora. Wʌle cha' cuxulix yubil. Jini sajtem bʌ tsa'ix cha' tajle”, che'en. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús tsi' sube xcʌnt'añob i cha'an ja'el: An wen chumul bʌ winic am bʌ i cha'an juntiquil xq'uel e'tel. Tsa' subenti i yum cha'an woli jach i to'o asin i chubʌ'an i yum. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jini i yum tsi' pʌyʌ tilel jini i yaj choñoñel. Tsi' sube: “¿Chuqui woli a mel? Subeñon bajche' tsa' c'ʌñʌ jini tsa' bʌ cotsa ti a wenta come mach chʌn mejlic a cha'libeñon que'tel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jini i yaj choñoñel tsa' caji i yʌl ti' pusic'al: “¿Chuqui mi caj c mel? C yum mi caj i loc'sañon ti que'tel. Mach mejlicon ti top' lum, mij quisñin j c'ajtin taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cujil chuqui mi caj c mel cha'an mi' pʌyoñob ochel ti' yotot c pi'ʌlob ba' ora loq'uemonix ti que'tel”, che'en jini xchoñoñel ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tsi' pʌyʌ tilel pejtelel winicob año' bʌ i bet yic'ot i yum. Tsi' sube ñaxan bʌ winic: “¿Bajche' c'amel an a bet yic'ot c yum?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jini winic tsi' jac'be: “An c bet jo'c'al barril aceite”, che'en. Jini xchoñoñel tsi' sube: “Ch'ʌmʌ i juñilel a bet. Buchi' ti ora. Yom ma' cha' ts'ijban ti lujump'ejl i yuxc'al”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ti wi'il tsi' sube yambʌ: “Jixcu jatet, ¿bajche' c'amel an a bet?” che'en. Tsi' jac'ʌ: “An c bet jo'c'al ti p'is jini trigo”, che'en. Jini xchoñoñel tsi' sube: “Ch'ʌmʌ i juñilel a bet. Cha' ts'ijban ti chʌnc'al”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","I yum tsa' caji i sub i ñuclel jini jontol bʌ i yaj choñoñel, come maña jax bajche' tsi' mele. Come i cha'año' bʌ pañimil ñumen maña i melbal ti' tojlel i pi'ʌlob bajche' i cha'año' bʌ i sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mic subeñetla: C'ʌñʌ la' chubʌ'an ti pañimil cha'an mi' p'ojlelob la' cʌñʌyo' bʌ ya' ti panchan, cha'an mi' pʌyetla ochel ti' yotot tac mach bʌ anic mi' jilel che' bʌ tsa'ix jili la' chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jini mu' bʌ i c'ʌn i chubʌan ti xuc'ul che' ts'ita', xuc'ul mi caj i c'ʌn che' cabʌl. Jini mach bʌ tojic mi' c'ʌn che' ts'ita', mach tojic mi caj i c'ʌn cabʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mi mach xuc'ulic mi la' c'ʌn i chubʌ'an pañimil, ¿majqui mi caj i yʌq'ueñetla jini mero isujm bʌ chubʌ'añʌl? ");
INSERT INTO ctuBl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mi mach xuc'ulic mi la' c'ʌmben i chubʌ'an yambʌ winic, ¿majqui mi caj i yʌq'ueñetla la' bajñel cha'an bʌ? ");
INSERT INTO ctuBl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ma'anic x'e'tel mu' bʌ mejlel i yuman cha'tiquil yumʌl. Mi' ts'a'len juntiquil, mi' c'uxbin yambʌ. Mi' jac'ben i t'an juntiquil, mi' ñusʌben i t'an yambʌ. Mach mejlic la' yuman Dios che' woli la' yuman chubʌ'añʌl. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jini fariseojob ja'el mu' bʌ i mulañob taq'uin tsi' yubiyob pejtelel jini t'an. Tsa' caji i wajleñob. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús tsi' subeyob: Jatetla, la' wom la' q'uejlel ti toj cha'an winicob. Dios mi' cʌn la' pusic'al. Chuqui tac mi' q'uelob ti ñuc winicob x'ixicob, ts'a' mi' q'uel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Tsa' sujbi mandar yic'ot i t'an tac x'alt'añob jinto tsa' tili Juan. Wʌle wolix i sujbel i yumʌntel Dios. Pejtelel winicob x'ixicob mi' cha'leñob wersa cha'an mi' yochelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mi' mejlel ti jilel panchan yic'ot pañimil, pero mach mejlic ti jilel i c'ʌjñibal mandar mi jump'ejlic punto. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Majqui jach mi' to'o cʌy i yijñam cha'an mi' pʌy yambʌ woli' cha'len i ts'i'lel. Majqui jach mi' pʌy cʌybil bʌ x'ixic woli' cha'len i ts'i'lel yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","An wen chumul bʌ winic, lʌpʌl bʌ i cha'an chʌccojan bʌ i pislel, wen uts'at bʌ. Ti jujump'ejl q'uin tsi' mele ñuc bʌ q'uiñijel. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","An ja'el juntiquil xc'ajtiya taq'uin i c'aba' Lázaro tsa' bʌ ajq'ui ti' ti' i yotot jini wen chumul bʌ. Cabʌl jax i tsoy. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yom i yʌq'uentel i colobal waj tsa' bʌ yajli ti' mesa jini wen chumul bʌ. Tsa' tili cabʌl ts'i' i lemben i tsoy tac. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ti wi'il tsa' chʌmi jini xc'ajtiya taq'uin. Jini ángelob tsi' pʌyʌyob majlel Lázaro ya' ti' tajn Abraham. Tsa' chʌmi ja'el jini wen chumul bʌ winic. Tsa' mujqui. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ya' ti' yajñib chʌmeño' bʌ c'ax cabʌl i wocol. Tsi' letsa i wut. Tsi' q'uele Abraham ti ñajtʌl yic'ot Lázaro ya' ti' tajn Abraham. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tsi' yota. Tsi' sube: “Tat Abraham, p'untañon. Choco tilel Lázaro cha'an mi' ts'aj i ñi' i yal i c'ʌb ti ja' cha'an mi' tsʌñesʌbeñon cac' come tic'lʌbilon ti wocol ti ili c'ajc”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham tsi' sube: “Calobil, ña'tan bajche' tsa' taja chuqui tac wen che' cuxulet to ti pañimil. Lázaro tsi' yubi wocol. Wʌle ñuq'uesʌbil i pusic'al ilayi. Jatet tic'lʌbilet ti wocol. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Awilan, an colem jajp ch'en mu' bʌ i t'oxonla cha'an ma'anic mi' mejlel ti ñumel majlel ya' ba' añet jini yomo' bʌ loq'uel ilayi. Jatetla ja'el mach mejliquetla ti c'axel tilel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jini wen chumul bʌ tsi' yʌlʌ: “Awocolic, tat, choco majlel Lázaro ti' yotot c tat. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","An jo'tiquil quijts'iñob. La' i subeñob ame tilicob ja'el quijts'iñob wʌ' ba' añon ti wocol”, che'en jini wen chumul bʌ winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham tsi' sube: “An i cha'añob i jun Moisés yic'ot x'alt'añob. La' i yubibeñob i t'an”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jini winic tsi' yʌlʌ: “Mach jasʌlic, tat Abraham, pero mi tsa' majli juntiquil loq'uem bʌ ba'an chʌmeño' bʌ cha'an mi' pejcañob, mux caj i cʌyob i mul”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham tsi' sube: “Mi ma'anic mi' jac'beñob i t'an Moisés yic'ot x'alt'añob, mach muq'uic i ñopob ja'el anquese mi' ch'ojyel loq'uel juntiquil ba'an chʌmeño' bʌ”, che'en. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús tsa' caji i suben xcʌnt'añob i cha'an: Wersa mi' tilelob jini mu' bʌ i yʌsañob ti mulil winicob x'ixicob. Pero mi caj i tajob wocol. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Uts'at tsa'ic ñaxan cʌjchi ña'tun ti' bic' cha'an mi' chojquel ochel ti chʌmel ti ñajb majqui jach mi' yʌsan ti mulil juntiquil ch'o'ch'oc bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Chʌcʌ q'uele la' bʌ. Mi tsi' cha'le mulil ti a contra a wermano, tiq'ui. Mi' tsi' cʌyʌ i mul, ñusʌben i mul. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Anquese wucyajl ti jujump'ejl q'uin mi' cha'len mulil ti a contra, ñusʌben i mul mi ti jujunyajl mi' cha' tilel ba' añet cha'an mi' subeñet tsa'ix i mele i pusic'al. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jini apóstolob tsi' subeyob lac Yum: Coltañon lojon cha'an xuc'ul mic ñopet lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lac Yum tsi' yʌlʌ: Muq'uic la' ñop ti la' pusic'al, mi che' jach ya wistʌl bajche' i bʌc' mostaza, mi mejlel la' suben ili sicómoro te': “La' bojquiquet. La' pʌjq'uiquet ti colem ñajb”. Mi caj i jac'beñet la' t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mi an juntiquil x'e'tel a cha'an, mi xtop' lum o mi xcʌnta tiñʌme', mi tsa' sujti ti otot che' loq'uemix ti jamil, ¿mu' ba a bʌc' suben: “La' ti buchtʌl. C'uxu a waj?” ¿Che' ba ma' suben? ");
INSERT INTO ctuBl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Mach ba muq'uic a suben: “Chajpʌbeñon i bʌl c ñʌc'. Chajpan a bʌ. Aq'ueñon c we'el yic'ot chuqui mic jap. Jinto mi cujtel, mi caj a cha'len we'el uch'el ja'el”. Che'ʌch ma' suben x'e'tel a cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Mu' ba a suben x'e'tel a cha'an wocolix i yʌlʌ, che' mi' yujtel i mel chuqui tsa' sube? Mi cʌl, ma'anic. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Che' ja'el jatetla, che' bʌ tsa'ix la' mele pejtelel chuqui tsac subeyetla, subula: “X'e'telon lojon jach. Mach cabʌlic j c'ʌjñibal. Tsa jach c mele lojon jini am bʌ tic wenta cha'an mic mel lojon”. Che'ʌch yom mi la' wʌl, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Che' woli' majlel Jesús ti Jerusalén, tsa' ñumi majlel ti yojlil Samaria yic'ot ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Che' bʌ tsa' ochi ti jump'ejl tejclum, awilan tsa' tili i tajob Jesús lujuntiquil winicob año' bʌ leco bʌ i tsoy. Ñajt to tsa' wa'leyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","C'am tsi' yʌlʌyob: Jesús, Maestro, p'untañon lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús tsi' q'ueleyob. Tsi' subeyob: Cucula, pʌsʌ la' bʌ ba'an motomajob, che'en. Che' woliyob ti majlel tsa' lamesʌntiyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Juntiquil tsa' cha' tili ba'an Jesús che' bʌ tsi' q'uele lajmenix i tsoy. C'am tsi' subu i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tsi' pʌcchoco i bʌ ti' tojel Jesús. Tsi' sube wocolix i yʌlʌ. Ch'oyol ti Samaria ili winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús tsi' yʌlʌ: ¿Mach ba lujuntiquilic tsa' bʌ lajmesʌntiyob? Jixcu jini bolontiquil, ¿baqui añob? ");
INSERT INTO ctuBl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ma'anic majqui tsa' cha' tili i sub i ñuclel Dios, cojach jini juntiquil ch'oyol bʌ ti yambʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesús tsi' sube: Ch'ojyen. Cucu. Tsa' coltʌntiyet cha'an tsa' ñopoyon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jini fariseojob tsi' c'ajtibeyob Jesús baqui ora mi caj i tilel i yumʌntel Dios. Jesús tsi' subeyob: Mach tsiquilic mi caj i tilel i yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma'anic mi caj i yʌlob: “Q'uele ya'an ya'i”, mi “q'uele wʌ'an ilayi”, come awilan, wʌ'ʌch an ti la' tojlel i yumʌntel Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsi' sube xcʌnt'añob: Tal to i yorajlel che' mi caj la' pijtan jump'ejl i q'uiñilel i Yalobil Winic, pero ma'anic mi caj la' q'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Winicob mi caj i subeñetla: “Q'uele wʌ'an ilayi, q'uele ya'an ya'i”, che'ob. Mach mi la' majlel. Mach la' tsajcañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Come che' bache' mi' tsictiyel i c'ʌc'al chajc c'ʌlʌl ti junwejl panchan c'ʌlʌl ti yambʌ junwejl, che' ja'el mi' caj ti tsictiyel i Yalobil Winic che' ti' q'uiñilel. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wersa mi' ñaxan ubin cabʌl wocol i Yalobil Winic. Wersa mi' ts'a'lentel cha'an winicob x'ixicob año' bʌ ti pañimil wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Che' bajche' tsa' ujti ti' yorajlel Noé, che' ja'el mi caj i yujtel ti' yorajlel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tsi' cha'leyob we'el. Tsi' cha'leyob uch'el. Tsi' cha'leyob ñujpuñijel. Tsi' sijiyob i yalobilob c'ʌlʌl ti jini q'uin che' bʌ tsa' ochi Noé ti barco. Tsa' tili but'ja'. Tsi' lu' jisayob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Che' ja'el tsa' ujti ti' yorajlel Lot. Tsi' cha'leyob we'el uch'el. Tsi' cha'leyob mʌñoñel. Tsi' cha'leyob choñoñel. Tsi' cha'leyob pac'. Tsi' wa'chocoyob i yotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ti jini jach bʌ q'uin che' bʌ tsa' loq'ui Lot ti Sodoma, tsa' loq'ui tilel c'ajc yic'ot azufre ti panchan. Tsi' laj jisayob. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Che' ja'el mi' caj ti ujtel ti jini q'uin che' mi' tsictiyel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ti jini jach bʌ q'uin jini am bʌ ti' jol otot mach jubic cha'an mi' loc' i chubʌ'an am bʌ ti' mal otot. Che' ja'el mach sujtic jini am bʌ ti cholel. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ña'tanla i yijñam Lot. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Majqui jach mi' ñop i bajñel cʌntan i cuxtʌlel mi caj i sʌt i ch'ujlel. Majqui jach mi' yʌc' i cuxtʌlel cha'añon ma'anic mi caj i sʌt i ch'ujlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mi' cajelob ti wʌyel cha'tiquil winicob ti jump'ejl wʌyibʌl ti jim bʌ ac'ʌlel. Mi caj i pʌjyel majlel juntiquil, yambʌ mi caj i cʌytʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Temel mi' cajelob ti juch'bal cha'tiquil x'ixicob. Juntiquil mi caj i pʌjyel majlel, yambʌ mi caj i cʌytʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cha'tiquil winicob mi caj i yajñelob ti cholel. Juntiquil mi caj i pʌjyel majlel, yambʌ mi caj i cʌytʌl. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jini xcʌnt'añob tsi' c'ajtibeyob Jesús: ¿Baqui mi caj i yujtel, c Yum? che'ob. Jesús tsi' subeyob: Baqui jach an i bʌc'tʌl chʌmen bʌ ya' mi caj i tempañob i bʌ xta'jol, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús tsi' sube xcʌnt'añob jini lajiya ti cʌntesa cha'an mi' cha'leñob oración ti pejtelel ora. Mach yomic mi' lujb'añob. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tsi' yʌlʌ: An xmel mulil ti jump'ejl tejclum. Ma'anic tsi' bʌc'ña Dios. Ma'anic tsi' c'uxbi winicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ya'an juntiquil meba' x'ixic ja'el ti jini tejclum. Tsa' tili ba'an jini xmel mulil. Tsi' yʌlʌ: “Coltañon. Melbeñon i mul jini woli bʌ i contrajiñon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tsa' ñumi cabʌl ora cha'an mach yomic i coltan jini x'ixic. Ti wi'il tsa' caji i bajñel al ti' pusic'al: “Ma'anic mic bʌc'ñan Dios. Ma'anic mij c'uxbin winicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero jini meba' x'ixic cabʌl woli' mʌctʌbeñon q'uin. Jini cha'an mux caj c melben i mul i contra ame chʌn tilic jini x'ixic i lujbesañon”, che'en jini xmel mulil. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tsi' yʌlʌ lac Yum: Ubinla chuqui mi' yʌl jini mach bʌ tojic bʌ xmel mulil. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Jixcu Dios, ¿mach ba muq'uic i melben i mul jini mu' bʌ i contrajin jini yajcʌbilo' bʌ i cha'an, mu' bʌ i chʌn pejcañob ti q'uiñil yic'ot ti ac'ʌlel? ¿Jal ba mi' jac'beñob? ");
INSERT INTO ctuBl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mic subeñetla, ti ora mi caj i melbeñob i mul i contra. Che' mi' tilel i Yalobil Winic, ¿mu' ba caj i taj ti pañimil jini mu' bʌ i ñopob? Che' tsi' yʌlʌ lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús tsi' subeyob ili t'an ti lajiya jini tsa' bʌ i ña'tayob toj i pusic'al cha'an ti' bajñel p'ʌtʌlel. Pero tsi' lon ña'tayob mach tojic i pusic'al yaño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jesús tsi' yʌlʌ: Cha'tiquil winicob tsa' letsiyob majlel ti Templo ti oración. Juntiquil fariseo, yambʌ xch'ʌm tojoñel. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Wa'al jini fariseo woli ti oración ti' bajñelil. Tsi' yʌlʌ: “Wocolix a wʌlʌ Dios, come mach lajalonic bajche' yaño' bʌ. Xujch'ob, mach tojobic i pusic'al. Mi' cha'leñob i ts'i'lel. Mach lajalonic ja'el bajche' jini xch'ʌm tojoñel. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cha'yajl ti semana mic cha'len ch'ajb. Mi cʌq'uen Dios i diezmojlel pejtel c chubʌ'an mu' bʌ c taj”. Che' tsi' yʌlʌ jini fariseo. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jini xch'ʌm tojoñel ñajt to an. Mach yomic i letsan i wut ti panchan. Tsi' jats'ʌ i tajn. Tsi' yʌlʌ: “Dios, p'untañon, xmulilon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mic subeñetla: Dios tsi' q'uele ti toj ili winic che' bʌ tsa' jubi majlel ti' yotot. Pero ma'anic tsi' q'uele ti toj jini yambʌ. Come majqui jach chan mi' mel i bʌ mi caj i peq'uesʌntel. Majqui jach pec' mi' mel i bʌ, mi caj i chan'esʌntel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsi' pʌyʌyob tilel alʌlob ba'an Jesús cha'an mi' yʌc' i c'ʌb ti' jol. Jini xcʌnt'añob tsi' tiq'uiyob che' bʌ tsi' q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús tsi' pʌyʌyob tilel. Tsi' subeyob: La' tilicob alʌlob ba' añon. Mach mi la' tic'ob come pejtelel mu' bʌ i tilelob che' bajche' alʌl mi caj i yochelob ti' yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ti isujm mic subeñetla, jini mach bʌ anic mi' yochel ti' yumʌntel Dios che' bajche' alʌl, ma'anic mi caj i yochel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juntiquil yumʌl tsi' c'ajtibe: Wem bʌ Maestro, ¿chuqui yom mic cha'len cha'an mic taj j cuxtilel mach bʌ anic mi' jilel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús tsi' sube: ¿Chucoch ma' wʌl weñon? Ma'anic majch wen, jini jach Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A cʌñʌyʌch mandar: “Mach a cha'len tsʌnsa. Mach a cha'len ts'i'lel. Mach a cha'len xujch'. Mach a cha'len jop't'an. Q'uele ti ñuc a tat a ña'”, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jini yumʌl tsi' jac'ʌ: Ti pejtelel jini mandar tsac jac'ʌ c'ʌlʌl che' alobon to, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Che' bʌ tsi' yubi jini t'an, Jesús tsi' sube: An to yom ma' mel yambʌ junchajp. Choño pejtelel a chubʌ'an. Aq'uen jini mach bʌ añobic i chubʌ'an. Che' jini, mi caj a taj cabʌl a chubʌ'an ti panchan. La' tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Che' bʌ tsi' yubi ili t'an jini yumʌl, wen ch'ijiyem i pusic'al, come wen cabʌl i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Che' bʌ tsi' q'uele Jesús ch'ijiyem i pusic'al jini yumʌl, tsi' yʌlʌ: Wocol mi yochelob ti' yumʌntel Dios jini wen chumulo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wocol mi' ñumel camello ti' yarcayojlel acuxan. Ñumen wocol mi' yochel ti' yumʌntel Dios jini wen chumul bʌ, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jini tsa' bʌ i yubiyob tsi' c'ajtibeyob: ¿Majqui mi mejlel i coltʌntel, che' jini? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús tsi' subeyob: Jini mach bʌ anic mi mejlel i mel winicob mi mejlel i mel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro tsa' caji i suben: Awilan, tsaj cʌyʌ lojon c chubʌ'an. Tsac tsajcayet lojon, che'en Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús tsi' subeyob: Isujm mic subeñetla: majqui jach mi' cʌy i yotot, mi i tat, mi i ña', mi i yʌscuñob, mi i yijts'iñob, mi i yijñam, mi i yalobilob cha'an i yumʌntel Dios, ");
INSERT INTO ctuBl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","mi caj i taj ñumen cabʌl ti ili ora yic'ot i cuxtʌlel mach bʌ anic mi' jilel ti jini ora mu' bʌ caj i tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús tsi' pʌyʌ tilel jini lajchʌntiquil. Tsi' subeyob: Awilan, woli lac letsel majlel ti Jerusalén. Mi caj i ts'ʌctiyel pejtelel chuqui tac ts'ijbubil i cha'an x'alt'añob cha'an i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Come mi caj i yʌjq'uel ti' c'ʌb gentilob. Mi caj i wajlentel. Leco mi caj i tic'lʌntel. Mi caj i tujbʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Che' mi' yujtel i jats'ob ti asiyal mi caj i tsʌnsañob. Pero ti yuxp'ejlel q'uin mi caj i cha' ch'ojyel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ma'anic tsi' ch'ʌmbeyob isujm ili t'an mi ts'ita'ic. Ma'anic tsa' aq'uentiyob i ña'tan i sujmlel. Ma'anic tsi' ch'ʌmbeyob isujm chuqui tac tsi' subeyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Che' lʌc'ʌlix an Jesús ti Jericó, ya'an juntiquil xpots' buchul ti' ti' bij. Woli' c'ajtin taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jini xpots' che' bʌ tsi' yubi woliyob ti ñumel cabʌl winicob x'ixicob, tsi' c'ajtibeyob chuqui woli' yujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Tsi' subeyob: Wolix ti ñumel Jesús ch'oyol bʌ ti Nazaret, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","C'am tsi' cha'le t'an jini xpots'. Tsi' yʌlʌ: Jesús, i Yalobilet bʌ David, p'untañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jini woli bʌ i majlelob ti ñaxan tsi' tiq'uiyob. Tsa' utsi caji ti c'am bʌ t'an jini xpots': I Yalobilet bʌ David, p'untañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús tsi' sube i pi'ʌlob cha'an mi' pʌyob tilel. Che' bʌ tsa' c'oti xpots', Jesús tsi' c'ajtibe: ");
INSERT INTO ctuBl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Chuqui a wom mic tumbeñet? che'en. Tsi' jac'ʌ xpots': C Yum, com mi' cha' c'otel c wut, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús tsi' sube: La' c'otic a wut. Tsa' coltʌntiyet cha'an tsa' ñopoyon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tsa' bʌc' c'oti i wut. Tsi' tsajca majlel Jesús. Tsi' tsictesa i ñuclel Dios. Pejtelel tsa' bʌ i q'ueleyob, tsi' subuyob i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tsa' ochi Jesús ti Jericó. Ñumel jach woli. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Awilan, ya'an winic i c'aba' Zaqueo. I yumʌch jini xch'ʌm tojoñelob. Wen chumul. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tsi' ñopo i q'uel Jesús cha'an mi' cʌn. Ma'anic tsa' mejli come joyol ti cabʌl winicob x'ixicob. Pec'atax Zaqueo. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ti ajñel tsa' majli ti ñaxan. Tsa' letsi ti sicómoro te' cha'an mi' q'uel Jesús ya' ba' mi' caj ti ñumel Jesús ti bij. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Che' bʌ tsa' c'oti Jesús ba'an Zaqueo, tsi' letsa i wut, tsi' q'uele. Tsi' sube: Zaqueo, juben ti ora come wersa mic jijlel ti a wotot wʌle, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ora jach tsa' jubi Zaqueo. Tijicña i pusic'al tsi' pʌyʌ majlel Jesús ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pejtel tsa' bʌ i q'ueleyob tsa' cajiyob ti wulwul a'leya. Tsi' yʌlʌyob: Tsa'ix majli ti jijlel ba'an xmulil, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Che' wa'al Zaqueo ba'an lac Yum, tsi' sube: Awilan, c Yum, mi caj cʌq'ueñob ojlil c chubʌ'an jini mach bʌ añobic i chubʌ'an. Mi tsac chilbe i chubʌ'an winic mi caj c cha' sutq'uiben uxyajl i ñumel, che'en Zaqueo. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús tsi' sube: Wʌle tsa'ix juli i coltʌntel jini año' bʌ ti ili otot, come jiñʌch i yalobil Abraham ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Come i Yalobil Winic tsa' tili i sʌclan jini sajtem bʌ. Tsa' tili i coltan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Che' bʌ tsi' yubibeyob i t'an Jesús che' lʌc'ʌlix an ti Jerusalén, Jesús tsa' caji i subeñob lajiya, come tsi' lon ña'tayob mux caj i tsictiyel i yumʌntel Dios ti ora. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jini cha'an Jesús tsi' yʌlʌ: Juntiquil yumʌl tsa' majli ti ñajt bʌ lum cha'an ya' mi' ch'ʌm i ye'tel ti yumʌl. Tsi' ña'ta sujtel che' ujtel i ch'ʌm. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tsi' pʌyʌ tilel lujuntiquil x'e'telob i cha'an. Tsi' t'oxbeyob taq'uin. Tsi' subeyob: “C'ʌñʌla ti ganar jini taq'uin jinto mic cha' tilel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jini xchumtʌlob ti' lumal jini yumʌl tsi' ts'a'leyob. Tsi' chocoyob majlel winicob ti' pat jini yumʌl cha'an mi' subob: “Mach la comic lac yuman ili winic”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Che' bʌ tsa' ujti i ch'ʌm i ye'tel ti yumʌl, tsa' cha' sujti ti' yotot. Tsi' yʌc'ʌ mandar cha'an mi' pʌjyelob tilel jini x'e'telob tsa' bʌ aq'uentiyob taq'uin, cha'an mi' q'uel bajche tsi' c'ʌñʌyob ti ganar ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tsa' tili jini ñaxan bʌ. Tsi' yʌlʌ: “C yum tsa cʌc'ʌ a taq'uin ti ganar. Tsac taja yambʌ lujump'ejl”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I yum tsi' sube: “Uts'at bajche' tsa' cha'le, xuc'ul bʌ x'e'telet. Xuc'ul tsa' mele che' an ts'ita' ti a wenta. Mi caj cotsʌbeñet ti a wenta lujump'ejl tejclum”. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tsa' tili yambʌ x'e'tel. Tsi' sube: “C yum, tsaj c'ʌñʌ a taq'uin ti ganar. Tsac taja yambʌ jo'p'ejl”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I yum tsi' sube jini x'e'tel ja'el: “Jatet ja'el, mi caj cʌc' ti a wenta jo'p'ejl tejclum”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tsa' tili yambʌ x'e'tel. Tsi' sube: “C yum, wʌ'ʌch an a taq'uin tsa' bʌ c pixi ti jump'ejl pisil. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Come tsac bʌc'ñayet, come bʌc'ñʌbilet. Ma' ch'ʌm chuqui tac ma'anic tsa' pʌc'ʌ. Ma' tsep jini jam ba' ma'anic tsa' wejch'u pac'”, che'en jini x'e'tel. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","I yum tsi' sube: “Jontol bʌ x'e'telet, mi caj c melet cha'an ti a t'an tsa' bʌ a wʌlʌ. A wujil bʌc'ñʌbilon. Awujil mic ch'ʌm chuqui tac ma'anic tsac pʌc'ʌ. Awujil mic tsep jam ba' ma'anic tsac wejch'u. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Chucoch che' jini, ma'anic tsa' wʌc'ʌ c taq'uin ba' mi' c'ʌjñel ti ganar? Che'ic jini tsa' mejli c cha' ch'ʌm c taq'uin yic'ot i jol che' bʌ tsa' juliyon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","I yum tsi' subeyob jini ya' bʌ añob: “Chilbenla jini taq'uin. Aq'uenla jini am bʌ i cha'an lujump'ejl”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tsi' subeyob: “C yum, anix i cha'an lujump'ejl”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jini yumʌl tsi' subeyob: “Joñon mic subeñetla: Majqui jach an i cha'an mi caj i yʌq'uentel yambʌ. Majqui jach ma'anic i cha'an mi caj i lu' chilbentel chuqui an i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pʌyʌla tilel jini mu' bʌ i contrajiñoñob mach bʌ yomobic i yumañoñob. Tsʌnsañob wʌ' tic tojel”, che'en. Che' tsi' yʌlʌ. Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús tsa' ujti i sub ili t'an. Tsa' caji ti letsel majlel ti ñaxan ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Che' bʌ lʌc'ʌl an ti Betfagé yic'ot ti Betania ti Olivo wits, tsi' choco majlel cha'tiquil xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tsi' yʌlʌ: Cucula ti tejclum ya' ti' tojel la' wut. Che' mi la' wochel, ya' cʌchʌl mi caj la' taj tsiji' burro maxto bʌ anic majqui tsi' c'ʌchta. Jitila, chucula tilel. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mi an majqui mi' c'ajtibeñetla: “¿Chucoch woli la' jit?” mi che'en, yom mi la' suben: “Yom i c'ʌn lac Yum”, che'etla. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tsa' majliyob. Tsi' tajayob che' bajche' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Che' bʌ tsi' jitiyob jini burro, i yum tsa' caji i subeñob: ¿Chucoch mi la' jit jini burro? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jini xcʌnt'añob tsi' yʌlʌyob: Come yom i c'ʌn lac Yum, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Tsi' pʌyʌyob tilel ba'an Jesús. Tsi' tasibeyob i pat burro ti' pislelob. Tsi' c'ʌchchocoyob Jesús ti' pam jini pisil. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Che' bʌ woli ti majlel Jesús tsi' tasiyob majlel jini bij ti' pislelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Che' lʌc'ʌl añob ya' ti yebal Olivo wits, tijicñayob i pusic'al pejtelel jini motocña bʌ xcʌnt'añob. Tsa' caji i subeñob i ñuclel Dios ti c'am bʌ t'an cha'an ñuc pejtelel i melbal Jesús tsa' bʌ i q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tsi' yʌlʌyob: La' sujbic a ñuclel, Reyet mu' bʌ a tilel ti' c'aba' lac Yum. Ñʌch'ʌl i pusic'al jini am bʌ ti panchan. Ñuc jini am bʌ ti chan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Cha'tiquil uxtiquil fariseojob ya' bʌ añob ti' tojlelob tsi' subeyob Jesús: Maestro, tiq'ui jini xcʌnt'añob a cha'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesús tsi' subeyob: Mic subeñetla, mi tsa' ñʌjch'iyob mi' caj ti c'am bʌ t'an jini xajlel tac, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Che' lʌc'ʌlix an, che' wolix i q'uel jini tejclum, Jesús tsi' cha'le uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tsi' yʌlʌ: Uts'at tsa'ic la' ña'ta bajche' tsa' mejli la' taj i ñʌch'tilel la' pusic'al ti jini jach bʌ ora. Pero ma'anic tsa' la' ña'ta. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Mi caj i tajetla yan tac bʌ q'uin che' mi caj i top'ob lum ti la' joytilel la' contrajob. Mi caj i joyetla. Mi caj i mʌctañetla ti jujunwejl. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mi caj i choquetla jubel ti lum yic'ot la' walobilob año' bʌ ti tejclum. Ma'anic mi caj la' cʌybentel mi jump'ejlic xajlel ti' pam yambʌ, come ma'anic tsa' la' ña'ta che' i yorajlelix la' coltʌntel ti Dios. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tsa' ochi Jesús ti Templo. Tsa' caji i choc loq'uel ti Templo pejtelel jini woliyo' bʌ ti choñoñel yic'ot mʌñoñel. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús tsi' subeyob: Ts'ijbubil: “Mi' caj ti ajlel cotot ti' yotlel oración. Pero jatetla tsa'ix la' sutq'ui ti' ch'eñal xujch'”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ti jujump'ejl q'uin tsi' cha'le cʌntesa Jesús ti Templo. Jini ñuc bʌ motomajob yic'ot sts'ijbayajob yic'ot jini ñuco' bʌ i ye'tel yomob i tsʌnsan Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma'anic tsa' mejliyob come ti pejtelel tejclum tsi' wen ñich'tʌbeyob i t'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ti jump'ejl q'uin Jesús woli' cʌntesan jini winicob x'ixicob ti Templo. Che' woli' sub jini wen t'an, tsa' c'otiyob ñuc bʌ motomajob yic'ot sts'ijbayajob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tsa' caji i pejcañob Jesús: Tsi' yʌlʌyob: Subeñon lojon, ¿baqui tsa' taja a we'tel cha'an chuqui ma' mel? ¿Majqui tsi' yʌq'ueyet a we'tel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús tsi' subeyob: An chuqui mij c'ajtibeñetla ja'el. Subeñonla. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Baqui ch'oyol i ye'tel Juan cha'an mi' yʌc' ch'ʌmja'? ¿Ch'oyol ba ti panchan o ch'oyol ba ti winicob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tsa' caji i bajñel pejcañob i bʌ. Tsi' yʌlʌyob: Mi tsa' lac sube: “Ch'oyol ti panchan”, mi cho'onla, muq'uix i cha' c'ajtibeñonla: “¿Chucoch ma'anic tsa' la' ñopbe i t'an?” ");
INSERT INTO ctuBl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mi tsa' lac sube: “Ch'oyol ti winicob”, mi cho'onla, pejtelel winicob mi caj i julonla ti xajlel, come mi' ña'tañob ti isujm x'alt'añʌch jini Juan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Tsi' yʌlʌyob: Mach cujilic lojon baqui ch'oyol i ye'tel Juan. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús tsi' subeyob: Joñon ja'el, ma'anic mic subeñetla baqui tsac taja que'tel cha'an jini mu' bʌ c mel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús tsa' caji i suben winicob x'ixicob ili lajiya: Juntiquil winic tsi' pʌc'ʌ ts'usubil. Tsi' yʌc'ʌ ti' wenta xcʌnta ts'usubilob. Tsa' majli ti yambʌ lum. Jal tsa' cʌle ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Che' bʌ tsa' tili i yorajlel, tsi' choco majlel juntiquil x'e'tel i cha'an ba'an xcʌnta ts'usubilob cha'an mi' ch'ʌm lamital i wut ts'usubil. Pero jini xcʌnta ts'usubilob tsi' lowoyob jini x'e'tel. To'o che jach tsi' cha' chocoyob sujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","I yum tsi' cha' choco majlel yambʌ x'e'tel. Jini xcʌnta ts'usubilob tsi' lowoyob ja'el. Leco tsi' tic'layob. To'o che jach tsi' cha' chocoyob sujtel. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I yum tsi' cha' choco majlel i yuxticlel. Jini xcʌnta ts'usubilob tsi' lowoyob ja'el. Tsi' chocoyob loq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","I yum ts'usubil tsi' yʌlʌ: “¿Chuqui yom mic mel? Mi caj c choc majlel c'uxbibil bʌ calobil. Tic'ʌl che' mi' q'uelob calobil mi caj i q'uelob ti ñuc”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jini xcʌnta ts'usubilob che' bʌ tsi' q'ueleyob i yalobil jini yumʌl, tsi' pejcayob i bʌ. Tsi' yʌlʌyob: “Jiñʌch mu' bʌ caj i yochel ti yumʌl. La' lac tsʌnsan. Che' jini, mux caj la cochel ti' yum pejtelel i chubʌ'an”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Tsi' chocoyob loq'uel ti ts'usubil. Tsi' tsʌnsayob. ¿Chuqui mi caj i tumbeñob xcʌnta ts'usubilob jini i yum? ");
INSERT INTO ctuBl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mi caj i tilel. Mi caj i wersa jisan jini xcʌnta ts'usubilob. Mi caj i yʌc' i ts'usubil ti' c'ʌb yaño' bʌ. Che' tsi' yʌlʌ Jesús. Che' bʌ tsi' yubiyob ili t'an tsi' yʌlʌyob: Mach i sujmic mi caj cujtel lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús tsi' q'ueleyob. Tsi' subeyob: ¿Chuqui i sujmlel ili ts'ijbubil bʌ che' jini? “Jini jach bʌ xajlel tsa' bʌ i chocoyob xmel ototob tsa'ix otsʌnti ti ñaxan bʌ i xujc otot”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jujuntiquil mu' bʌ i yajlel ti' pam ili xajlel mi caj i c'ʌscujel. Jini mu' bʌ i tejñel ti jini xajlel mi caj i lu' bic'tiyel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ti jim bʌ ora jini ñuc bʌ motomajob yic'ot sts'ijbayajob tsa' caji i ña'tañob bajche' mi mejlel i chucob Jesús, come yujilob tsi' cha'le jini t'an ti lajiya ti' contrajob. Pero tsi' bʌc'ñayob winicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tsi' chʌcʌ q'ueleyob Jesús. Tsi' chocoyob majlel xñich'ta t'añob tsa' bʌ i lon pʌsʌyob i bʌ ti toj. Tsi' chocoyob majlel cha'an mi' yʌquiñob ti' t'an cha'an mi' yʌc'ob ti melol ti' tojlel jini gobernador. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jini xñich'ta t'añob tsi' subeyob Jesús: Maestro, cujil lojon ma' wʌl chuqui uts'at, ma' cʌntesan chuqui uts'at ja'el. Junlajal jach ma' q'uel winicob. Wola' cʌntesañon lojon ti' bijlel Dios ti isujm. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Mu' ba i yʌl ti mandar yom mi la cʌq'uen César jini tojoñel o ma'anic? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús tsi' ña'ta maya jax i t'an. Tsi' subeyob: ¿Chucoch mi la' wilʌbeñon c pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Pʌsbeñon jini taq'uin. ¿Majqui i cha'an i yejtal yic'ot i ts'ijbal ti' pam? che'en. Tsi' jac'beyob: I cha'an César, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús tsi' subeyob: Jini cha'an, aq'uenla César chuqui i cha'an César. Aq'uenla Dios chuqui i cha'an Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma'anic tsa' mejli i tajbeñob i mul Jesús, come toj i t'an ti' tojlel winicob x'ixicob. Tsa' toj sajtiyob i pusic'al cha'an uts'at tsi' jac'ʌ Jesús. Ñʌch'ʌl tsa' cʌleyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tsa' tiliyob saduceojob ba'an Jesús. Jiñobʌch mu' bʌ i yʌlob ma'anic mi' cha' ch'ojyelob chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tsi' c'ajtibeyob Jesús: Maestro, Moisés tsi' ts'ijbubeyonla: “Mi tsa' chʌmi juntiquil ascuñʌl bʌ am bʌ i yijñam mach bʌ anic i yalobil, che' jini an ti' wenta jini ijts'inʌl bʌ cha'an mi' pʌyben i yijñam i yʌscun cha'an mi' techben i p'olbal i yʌscun”. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","An wuctiquil winicob i yerañob i bʌ. Jini ñaxan bʌ tsi' pʌyʌ i yijñam. Tsa' chʌmi jini winic. Ma'anic i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jini i cha'ticlel winic tsi' pʌyʌ jini x'ixic. Tsa' chʌmi ja'el. Ma'anic i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","I yuxticlel winic tsi' pʌyʌ. Che' ja'el, tsa' lu' ujtiyob jini wuctiquilob. Tsa' laj chʌmiyob. Ma'añobic i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ti wi'il tsa' chʌmi jini x'ixic ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ti' yorajlel che' mi' cha' ch'ojyelob, ¿baqui bʌ winic i ñoxi'al jini x'ixic? Come ti' wucticlelob tsi' pʌyʌyob cha'an i yijñam, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús tsi' subeyob: Jini cuxulo' bʌ ti ili ora mi' pʌyob i pi'ʌl. Mi' sijintelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero jini mu' bʌ i q'uejlelob ti uts'at cha'an mi' tajob i cuxtʌlel ti jini yambʌ ora yic'ot cha'an mi' cha' ch'ojyelob ba'an chʌmeño' bʌ ma'anic mi' pʌyob i pi'ʌl. Ma'anic mi' sijintelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mach chʌn mejlobix ti chʌmel, come lajalob bajche' ángelob. I yalobilobʌch Dios. Mi tejchelob ch'ojyel ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jini chʌmeño' bʌ mi caj i cha' ch'ojyelob. Che' tsi' yʌlʌ Moisés che' bʌ tsi' tsictesa chuqui tsa' ujti ti alʌ te'. Tsi' pejca lac Yum ti' Dios Abraham, i Dios Isaac, i Dios Jacob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Come Dios mach i Diosic chʌmeño' bʌ, pero i Diosʌch cuxulo' bʌ, come laj cuxulob cha'an mi' ñuq'uesañob Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cha'tiquil uxtiquil sts'ijbayajob tsi' subeyob: Maestro, tsa'ix a subu chuqui isujm, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ti wi'il ma'anic majch tsi' chʌn ñopo i c'ajtiben yan tac bʌ cha'an bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús tsi' subeyob: ¿Chucoch mi la' wʌl i Yalobilʌch David jini Cristo? ");
INSERT INTO ctuBl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Jini David tsi' yʌlʌ ti' juñilel Salmos: “Lac Yum tsi' sube c Yum, buchi' tic ñoj ");
INSERT INTO ctuBl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jinto mi cʌq'ueñet a t'uchtan a contrajob”. Che' tsi' yʌlʌ David, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tsi' pejca Cristo ti' yum jini David. ¿Bajche' isujm che' jini mi i yalobil David jini Cristo? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesús tsi' sube xcʌnt'añob i cha'an ili t'an ba' tsa' mejli i yubiñob pejtelel winicob x'ixicob: ");
INSERT INTO ctuBl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Chʌcʌ q'uele la' bʌ cha'an sts'ijbayajob mu' bʌ i mulañob i lʌpob pʌl bʌ i bujc. Mi' mulañob i yʌq'uentelob cortesía ba'an choñoñibʌl tac. Mi' mulañob jini ñaxan bʌ buchlibʌl ti sinagoga tac, yic'ot ñaxan bʌ buchlibʌl ti q'uiñijel. ");
INSERT INTO ctuBl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mi' chilbeñob i yotot meba' x'ixicob. Mi' melob tam bʌ oración cha'an mi' lon q'uejlelob ti uts'at. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús tsi' ts'ita' letsa i wut. Tsi' q'uele jini wen chumulo' bʌ che' bʌ tsi' chocoyob ochel ofrenda ti' yajñib. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsi' q'uele juntiquil meba' x'ixic mach bʌ anic i chubʌ'an tsa' bʌ i choco ochel cha'p'ejl taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús tsi' yʌlʌ: Ti isujm mic subeñetla, jini meba' x'ixic mach bʌ anic i chubʌ'an tsa'ix i choco ochel ñumen cabʌl bajche' pejtelel yaño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Come ti pejtelelob tsi' yʌq'ueyob Dios ofrenda loq'uem bʌ ti' yonlel i chubʌ'an. Jini meba' x'ixic mach bʌ anic i chubʌ'an tsi' choco ochel pejtelel i taq'uin, i tojol i bʌl i ñʌc'. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Cha'tiquil uxtiquil tsa' cajiyob ti t'an cha'an wen i t'ojol jax jini xajlel tac am bʌ ti templo yic'ot i ch'ʌjlib tsa' bʌ i yʌc'ʌyob winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tsi' yʌlʌ Jesús: Ti pejtelel ili woli bʌ la' q'uel mi caj i jilel. Tal jini q'uin che' ma'anic mi caj i cʌytʌl mi jump'ejlic xajlel ti' pam yambʌ mach bʌ anic mi caj i chojquel jubel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tsi' c'ajtibeyob Jesús: Maestro, ¿baqui ora mi caj i yujtel pejtelel jini? ¿Chuqui mi' caj ti pʌstʌl che' yom ujtel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús tsi' yʌlʌ: Chʌcʌ q'uele la' bʌ ame anic majqui mi' soquetla, come talob cabʌl tij c'aba' mu' bʌ caj i cuyob i bʌ ti Cristo. Mi caj i yʌlob lʌc'ʌlix i yumʌntel. Jini cha'an mach mi la' tsajcañob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ba' ora mi la' wubin an cabʌl guerra yic'ot leto, mach mi la' cha'len bʌq'uen. Come wersa mi' ñaxan ujtel pejtelel jini, pero maxto i jilibalic. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús tsi' subeyob: Jini año' bʌ ti jump'ejl lum mi caj i techob guerra ti' contra jini año' bʌ ti yambʌ lum. Jini año' bʌ ti' wenta juntiquil yumʌl mi caj i techob guerra ti' contra jini año' bʌ ti' wenta yambʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tal p'ʌtʌl bʌ i yujquel lum. Tal wi'ñal ti cabʌl lum yic'ot c'amʌjel mu' bʌ i pam pujquel. Tal bʌbʌq'uen tac bʌ yic'ot chuqui tac ñuc mu' bʌ caj i pʌstʌl ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Che' maxto ujtemic ili tac winicob mi caj i chuquetla. Mi caj i tic'lañetla. Mi caj i pʌyetla majlel ti sinagoga yic'ot ti cárcel. Muq'uix la' pʌjyel majlel ti' wut reyob yic'ot ti' wut gobernadorob cha'an tij c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ti jim bʌ ora mi mejlel la' wen ac'on ti cʌjñel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Chʌn ña'tanla mach yomic mi la' wʌn mel la' pusic'al cha'an bajche' mi caj la' jac' cha'an mi la' coltan la' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Come joñon mi caj cʌq'ueñetla t'an mu' bʌ caj la' sub yic'ot la' ña'tʌbal mach bʌ mejlic i contrajintel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","La' tat, la' wʌscuñob, la' chichob, la' wijts'iñob, la' pi'ʌlob, la' cʌñʌyo' bʌ mi caj i yʌq'uetla ti' c'ʌb la' contra. Lamitaletla mi caj la' tsʌnsʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mi caj la' ts'a'lentel cha'an pejtelel winicob x'ixicob cha'an tij c'aba. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ma'anic mi caj i sajtel mi junt'ujmic i tsutsel la' jol. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Che' xuc'ul la' pusic'al ti wocol ma'anic mi caj i sajtel la' ch'ujlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Che' mi la' q'uel Jerusalén joyol bʌ ti soldadojob, ña'tanla che' jini, lʌc'ʌlix i yorajlel i jisʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ti jim bʌ ora, la' puts'icob majlel ti wits jini año' bʌ ti Judea. La' loq'uicob jini año' bʌ ti Jerusalén. Jini año' bʌ ti jamil mach chʌn sujticob ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Jiñʌch q'uin tac che' mi caj i q'uextʌbentelob i jontolil, cha'an mi' yujtel ti pejtelel che' bajche' ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti jim bʌ ora obolob jax i bʌ jini cʌntʌbilo' bʌ i cha'an alʌl yic'ot jini woli bʌ i tsu'sañob alʌl. Tal cabʌl wocol ti pañimil yic'ot i mich'lel Dios ti' tojlel ili winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mi caj i yajlelob cha'an ti' yej machit. Mi caj i chujquelob majlel ti pejtelel lum. Jerusalén mi caj i t'uchtʌntel cha'an gentilob c'ʌlʌl mi' ts'ʌctiyel i yorajlel gentilob. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","An chuqui tac mi' caj ti pʌstʌl ti q'uin, yic'ot ti uw, yic'ot ti ec'. Jini winicob x'ixicob ti pañimil cabʌl mi caj i tsicob i pusic'al. Mi caj i sʌc sojquelob i pusic'al cha'an ju'ucña jini colem ñajb, wʌlʌcña jini ja'. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mi caj i cʌn chʌmelob winicob cha'an bʌq'uen yic'ot pensar cha'an chuqui mi' caj ti ujtel ti pañimil. Jini p'ʌtʌl tac bʌ ti panchan mi caj i wersa ñijcʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ti jim bʌ ora mi caj i q'uelob i Yalobil Winic che' mi' tilel ti tocal yic'ot i p'ʌtʌlel yic'ot cabʌl i ñuclel. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Che' mi' cajel ti ujtel ili tac, letsan la' wut, letsan la' jol, come lʌc'ʌlix la' coltʌntel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús tsi' subeyob jini t'an ti lajiya: Q'uelela jini higuera te' yic'ot pejtelel te' tac. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Che' mi la' q'uel woli' pasel i yopol te' mi la' ña'tan lʌc'ʌlix i yorajlel ticwal. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Che' ja'el, che' mi la' q'uel woli ti ujtel ili tac, ña'tanla lʌc'ʌlix i yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Isujm mic subeñetla, ti pejtelel mi' caj ti ujtel che' wʌ' to añob ti pañimil jini winicob x'ixicob año' bʌ wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mi' caj ti jilel panchan yic'ot pañimil. Pero mach jilic c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Chʌcʌ q'uele la' bʌ ame tsʌts'ac la' pusic'al cha'an la' wo'lel yic'ot yʌc'ʌjel che' mi la' c'ojo'tan chuqui tac an ti pañimil, ame i bʌc' tajetla ili q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ili q'uin che' bajche yac mi caj i taj pejtelel winicob x'ixicob chumulo' bʌ ti' petol pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yom yʌxʌl la' wo che' jini. Chʌn cha'lenla oración ti pejtelel ora, cha'an mi la' q'uejlel ti uts'at, cha'an ma'anic mi' tajetla ili wocol mu' bʌ caj ti ujtel, cha'an uts'at mi la' wa'tʌl ti' tojel i Yalobil Winic, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ti q'uiñil tsi' cha'le cʌntesa Jesús ti Templo. Ti ac'ʌlel tsa' majli ti wits i c'aba' Olivo. ");
INSERT INTO ctuBl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Che' ti sʌc'ajel tsa' tiliyob pejtelel winicob x'ixicob ba'an Jesús ti Templo cha'an mi yubibeñob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lʌc'ʌlix i q'uiñilel Pascua che' mi' c'uxob caxlan waj mach bʌ anic i levadurajlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jini ñuc bʌ motomajob yic'ot sts'ijbayajob tsi' temeyob i t'an cha'an mi' mucul tsʌnsañob Jesús, come tsi' bʌc'ñayob winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tsa' ochi Satanás ti Judas, am bʌ i cha'chajplel i c'aba' Iscariote, i pi'ʌlʌch jini junlujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tsa' majli Judas i pejcan jini ñuc bʌ motomajob yic'ot xcʌnta Templojob cha'an mi' yʌc' Jesús ti' c'ʌbob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tijicñayob i pusic'al che' bʌ tsi' yubiyob. Tsi' cha'leyob trato cha'an mi' yʌq'ueñob taq'uin Judas. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas tsi' yʌc'ʌ i t'an. Tsa' caji i wʌn ña'tan baqui ora mi caj i yʌc' Jesús ti' c'ʌb motomajob che' mach ña'tʌbilic i cha'an winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tsa' c'oti ili q'uin che' mi' c'uxob caxlan waj mach bʌ anic i levadurajlel. Jiñʌch i q'uiñilel Pascua che' mi' tsʌnsañob tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús tsi' choco majlel Pedro yic'ot Juan. Tsi' subeyob: Cucula. Chajpanla jini we'elʌl cha'an Pascua cha'an mi laj c'ux. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tsi' c'ajtibeyob Jesús: ¿Baqui a wom mic chajpan lojon? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús tsi' subeyob: Awilan, che' ochemetixla ti tejclum, mi caj i tajetla winic woli bʌ i q'uech majlel uc'um but'ul bʌ ti ja'. Tsajcanla che' mi' yochel ti otot. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Subenla i yum otot: “Jini Maestro mi' c'ajtibeñet: ¿Baqui an jump'ejl i mal otot ba' mi mejlel j c'ux we'elʌl cha'an Pascua yic'ot xcʌnt'añob c cha'an?” Che' yom mi la' suben, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Mi caj i pʌsbeñet colem bʌ i mal otot ti chan am bʌ i bʌl. Chajpanla ya'i chuqui tac yom, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tsa' majliyob. Tsi' tajayob jini otot che' bajche' tsi' subeyob Jesús. Tsi' chajpayob jini we'elʌl cha'an Pascua. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Che' i yorajlelix, Jesús tsa' buchle ti' t'ejl mesa yic'ot jini lajchʌntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús tsi' subeyob: Ti pejtelel c pusic'al com j c'ux jini we'elʌl cha'an Pascua quic'otetla che' maxto anic woli cubin wocol. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Come mic subeñetla, ma'anix mi caj c chʌn c'ux jinto mi lac cha' c'ux ti' yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesús tsi' ch'ʌmʌ vaso. Tsi' sube wocolix i yʌlʌ Dios. Tsi' yʌlʌ: Ch'ʌmʌla. Aq'uen la' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Come mic subeñetla ma'anix mic chʌn jap i ya'lel ts'usub jinto mi' tilel i yumʌntel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesús tsi' ch'ʌmʌ waj. Tsi' sube wocolix i yʌlʌ Dios. Tsi' xet'e. Tsi' yʌq'ueyob. Tsi' yʌlʌ: Jiñʌch c bʌc'tal, mu' bʌ cʌc' cha'añetla. Che'ʌch yom mi la' mel cha'an c ña'tʌntel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Che' ja'el tsi' ch'ʌmʌ jini vaso che' bʌ tsa' ujtiyob ti we'el. Tsi' yʌlʌ: Jini vaso jiñʌch tsiji' bʌ trato cha'an c ch'ich'el mu' bʌ i bejq'uel cha'añetla. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Awilan, wʌ'ʌch an quic'ot ti mesa jini mu' bʌ i yʌc'on ti' c'ʌb j contra. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ti isujm, i Yalobil Winic mi caj i majlel che' bajche' wʌn ña'tʌbil. Pero cabʌl mi caj i taj wocol jini winic mu' bʌ i yʌc' i Yalobil Winic ti' c'ʌb i contra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tsa' caji i c'ajtibeñob i bʌ majqui mi caj i yʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tsa' caji i cʌlʌx pejcañob i bʌ cha'an woli' bajñel yajcañob majqui ñumen ñuc ti' tojlelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús tsi' subeyob: I yumob jini tejclumob c'ax ñuc mi' pʌsob i bʌ ti' tojlelob. Jini año' bʌ i ye'tel ti' tojlelob mi' pejcʌntelob ti xcʌnta pañimilob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mach che'ic yom mi la' mel. Jini ñumen ñuc bʌ ti la' tojlel la' i mel i bʌ bajche' alob. Jini am bʌ i ye'tel la' i mel i bʌ ti x'e'tel la' cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Come ¿majqui ñumen ñuc ma' wʌl? ¿Jim ba mu' bʌ i buchtʌl ti c'ux waj, o jim ba x'e'tel mu' bʌ i ñusʌben waj? Pero joñon che'ʌch añon ti la' tojlel bajche' x'e'tel la' cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jatetla, tsa' chʌn ajniyetla quic'ot che' ti' yorajlel i yilʌbentel c pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Joñon mi caj cʌq'ueñetla la' yumʌntel che' bajche c tat tsi' yʌq'ueyon c yumʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Che' jini mi mejlel la' cha'len we'el uch'el tic mesa tic yumʌntel. Mi caj la' buchtʌl ti la' we'tel cha'an mi la' mel jini lajchʌnmojt i p'olbal Israel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Lac Yum tsi' yʌlʌ ja'el: Simón, Simón, awilan, Satanás tsi' c'ajtiyetla cha'an mi' chijcañetla che' bajche' mi' chijcañob loq'uel i sujl trigo. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Joñon tsac tajayet ti oración ame a cʌy a ñopon. Che' ma' cha' sutq'uin a bʌ, p'ʌtesan a wermanojob, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro tsi' sube: C Yum chajpʌbilonix cha'an mic majlel quic'otet, anquese ma' majlel ti mʌjquibʌl, anquese mic chʌmel awic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús tsi' sube: Pedro, mic subeñet, che' maxto anic mi' cha'len uq'uel jini tat mut ti ili ac'ʌlel, uxyajl mi caj a wʌl mach a cʌñʌyonic. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús tsi' subeyob: Che' bʌ tsac chocoyetla majlel ma'anic i yajñib la' taq'uin, ma'anic la' chim, ma'anic la' xʌñʌb. ¿Mach ba anic tsa' la' taja pejtelel chuqui yom la' cha'an? che'en Jesús. Tsi' yʌlʌyob: Tsa' cu, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús tsi' subeyob: Wʌle jini am bʌ i yajñib i taq'uin la' i ch'ʌm majlel yic'ot i chim. Jini mach bʌ anic i yespada, la' i chon i chaqueta cha'an mi' mʌn. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Come mic subeñetla. Wersa mi caj cujtel bajche' mi yʌl ti' ts'ijbujel Dios. Mi yʌl: “Tsa' tsijqui yic'ot xmulilob”. Che'ʌch ts'ijbubil. Ts'ʌcʌl mi' caj ti ujtel chuqui tac ts'ijbubil cha'añon, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jini xcʌnt'añob tsi' yʌlʌyob: C Yum, awilan wʌ'an cha'ts'ijt espada, che'ob. Jesús tsi' subeyob: Jasʌl jini, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús tsa' loq'ui ti tejclum. Tsa' majli ti Olivo wits come i tilel che' mi' mel. Xcʌnt'añob i cha'an tsa' caji i tsajcañob majlel ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Che' bʌ tsa' c'oti Jesús ya' ba' yom ajñel, Jesús tsi' subeyob: Cha'lenla oración cha'an ma'anic mi la' jac' la' pʌyol ti mulil. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tsi' ts'ita' xʌñʌ majlel che' i ñajtlel bajche' mi' chojquel xajlel. Tsa' ñocle. Tsi' cha'le oración. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tsi' yʌlʌ: C Tat, mi a wom, loc'sʌbeñon jini vaso i yejtal bʌ wocol. La' mejlic bajche' yom a pusic'al, mach che'ic bajche' com, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tsa' tili ángel ch'oyol bʌ ti panchan cha'an mi' p'ʌtesan Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Che' bʌ woli ti wocol Jesús, ñumen wersa tsa' caji i pejcan Dios. Tsa' caji ti bu'lich. Lajal bajche' ch'ich' tsa' chʌc' p'ajti ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Che' bʌ tsa' ujti ti oración tsa' ch'ojyi. Tsa' cha' tili ba'an xcʌnt'añob i cha'an. Tsi' tajayob wʌyʌlob cha'an i ch'ijiyemlel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús tsi' c'ajtibeyob: ¿Chucoch wʌyʌletla? Ch'ojyenla. Cha'lenla oración cha'an ma'anic mi la' jac' la' pʌyol ti mulil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Che' woli to ti t'an Jesús, awilan tsa' tiliyob cabʌl winicob yic'ot Judas, i pi'ʌl jini junlujuntiquil. Ñaxan woli' tilel Judas. Tsa' c'oti i ts'ujts'un Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús tsi' sube: Judas, ¿mu' ba a wʌc' i Yalobil Winic yic'ot ts'ujts'uya? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jini año' bʌ yic'ot Jesús che' bʌ tsi' ña'tayob chuqui mi' caj ti ujtel tsi' subeyob: C Yum, ¿a wom ba mic bajben lojon ti espada? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Juntiquil xcʌnt'an tsi' lowo jini x'e'tel i cha'an jini c'ax ñuc bʌ motomaj. Tsi' wel tsepbe loq'uel jini ñoj bʌ i chiquin. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús tsi' yʌlʌ: La' to ajnic. Cʌyʌx, che'en. Tsi' tʌlbe i chiquin. Tsi' lajmesa. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús tsi' sube jini ñuc bʌ motomajob yic'ot xcʌnta templojob yic'ot xñoxob año' bʌ i ye'tel tsa' bʌ tiliyob ti' contra: ¿Tsa' ba tiliyetla cha'an mi la' chucon yic'ot espada yic'ot te' che' bajche' mi la' chuc xujch'? ");
INSERT INTO ctuBl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Che' ya' añon quic'otetla jujump'ejl q'uin ti Templo ma'anic tsa' la' chucuyon. Wʌle la' cha'añʌch ili ora. I yorajlelix mi' pʌstʌl i p'ʌtʌlel ic'ch'ipan bʌ pañimil. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tsi' chucuyob Jesús. Tsi' pʌyʌyob majlel ti' yotot jini ñuc bʌ motomaj. Pedro tsi' ñajti tsajca majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jini ya' bʌ añob tsi' xiq'uiyob c'ajc ti' pam otot. Tsa' buchleyob ti' joytilel c'ajc ti pejtelelob. Pedro tsa' buchle yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Juntiquil xch'oc tsi' q'uele Pedro che' buchul ti' t'ejl c'ajc. Tsi' ch'ujch'u q'uele. Tsi' yʌlʌ: Ili winic ja'el tsi' pi'le ñumel Jesús, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro tsi' yʌlʌ: Mach isujmic. X'ixic, mach j cʌñʌyic jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ti jumuc' an yambʌ tsa' bʌ i q'uele Pedro. Tsi' yʌlʌ: Jatet ja'el i pi'ʌlet ili winicob, che'en. Pedro tsi' yʌlʌ: Winic, mach i pi'ʌlonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ñumenix jump'ejl ora yambʌ winic tsi' yʌlʌ: Isujmʌch jini winic ja'el tsi' pi'le ñumel Jesús, come ch'oyol ti Galilea, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro tsi' yʌlʌ: Winic, mach cujilic chuqui wola' wʌl, che'en. Ti ora che' woli to ti t'an Pedro, tsi' cha'le uq'uel tat mut. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Che' bʌ tsi' sutq'ui i bʌ lac Yum, tsi' q'uele Pedro. Tsa' c'ajtiyi ti' pusic'al Pedro i t'an lac Yum tsa' bʌ i wʌn sube: “Che' maxto anic mi' cha'len uq'uel tat mut, uxyajl mi caj a wʌl mach a cʌñʌyonic”. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro tsa' loq'ui majlel. Tsʌts tsa' caji ti uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jini winicob woli bʌ i cʌntañob Jesús tsi' wajleyob. Tsi' jats'ʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tsi' mʌc cʌchbeyob i wut. Tsi' poch'iyob. Tsi' c'ajtibeyob: Subeñon lojon, ¿majqui tsi' jats'ʌyet? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Anto cabʌl chuqui tsi' yʌlʌyob ti p'ajoñel jini winicob ti' contra Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Che' bʌ tsa' sʌc'a pañimil tsi' tempayob i bʌ xñoxob año' bʌ i ye'tel ti' tojlel i pi'ʌlob yic'ot ñuc bʌ motomajob yic'ot sts'ijbayajob. Tsi' pʌyʌyob majlel Jesús ba'an jini año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tsi' c'ajtibeyob: ¿Cristojet ba, yajcʌbilet ba? Subeñon lojon, che'ob. Jesús tsi' subeyob: Mi tsac subeyetla, mach muq'uic la' ñop. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Che' ja'el mi an chuqui mij c'ajtibeñetla, ma'anic mi la' jac'beñon. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wʌle yic'ot ti pejtelel ora mi' caj ti buchtʌl i Yalobil Winic ti' ñoj jini P'ʌtʌl bʌ Dios, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ti pejtelelob tsi' subeyob: ¿Jatet ba i Yalobilet Dios? che'ob. Jesús tsi' subeyob: Joñoñʌch che' bajche' woli la' wʌl, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tsi' c'ajtibeyob i bʌ: ¿Mach ba jasʌlic ili t'an cha'an mi' tsictiyel i mul? Tsa'ix la cubibe i t'an tsa' bʌ i subu, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tsa' tejchiyob pejtelel jini tempʌbilo' bʌ winicob. Tsi' pʌyʌyob majlel Jesús ba'an Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tsa' caji i jop'beñob i mul. Tsi' yʌlʌyob: Tsac taja lojon ili winic mu' bʌ i soc pejtelel winicob x'ixicob ti lac lumal. Mi' tic'ob winicob cha'an ma'anic mi yʌq'ueñob César tojoñel. Mi' sub i bʌ ti Cristo. Mi' sub i bʌ ti rey, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato tsi' c'ajtibe Jesús: ¿Jatet ba i Reyet judíojob? che'en. Jesús tsi' jac'be: Joñon cu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato tsi' sube jini ñuc bʌ motomaj yic'ot jini winicob: Joñon mi cʌl ma'anic i mul jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ñumen tsʌts tsi' yʌlʌyob: Woli' ñijcan winicob x'ixicob ti cabʌl t'an. Mi' cha'len cʌntesa ti pejtelel Judea c'ʌlʌl ti Galilea c'ʌlʌl ilayi, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Che' bʌ tsi' yubi Pilato woli' tajob ti t'an Galilea tsi' c'ajtibeyob mi ya' ch'oyol Jesús ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Che' bʌ tsi' ña'ta isujm ya' ch'oyol Jesús ba' woli ti yumʌntel Herodes, Pilato tsi' choco majlel ba'an Herodes. Ya'an Herodes ja'el ti Jerusalén ti jim bʌ ora. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Wen tijicña Herodes che' bʌ tsi' q'uele Jesús, come anix ora yom i q'uel come tsa'ix i yubi t'an cha'an Jesús. Yom i q'uel i yejtal i p'ʌtʌlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","An cabʌl chuqui tsi' c'ajtibe Jesús jini Herodes. Ma'anic chuqui tsi' jac'ʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ya' wa'alob ñuc bʌ motomajob yic'ot sts'ijbajob. Ti wersa tsi' jop'beyob i mul Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes yic'ot i soldadojob tsi' p'ajayob. Tsi' wajleyob. Tsi' lʌpbeyob wen i t'ojol bʌ i pislel. Herodes tsi' cha' choco majlel ba'an Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti jini jach bʌ q'uin Pilato yic'ot Herodes tsa' caji i cha' uts'esañob i bʌ, come ti yambʌ ora ts'a' woli' q'uelob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato tsi' tempa tilel jini ñuc bʌ motomajob yic'ot jini yumʌlob yic'ot winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tsi' subeyob: Tsa'ix la' pʌyʌ tilel ili winic ba' añon, come mi la' wʌl woli' soc winicob x'ixicob. Awilan, joñon tsa'ix j c'ajtibe ti' la' tojlel chuqui tac tsi' mele. Tsac ña'ta ma'anic mi junchajpic i mul woli bʌ la' wʌl ti' contra ili winic. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Che' ja'el Herodes, come tsa'ix i cha' choco tilel ili winic. Awilan, ma'anic chuqui tsi' mele ili winic cha'an mi' yʌjq'uel ti chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jini cha'an che' mic jats' ti asiyal mi caj j col, che'en Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Come wersa mi' yʌc' ti colel juntiquil xñujp'el ti jujunyajl che' mi' melob q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pejtelel jini winicob x'ixicob junlajal tsi' yʌlʌyob ti c'am bʌ t'an: La' chʌmic ili winic. Ac'ʌ ti colel Barrabás, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Jini Barrabás jiñʌch tsa' bʌ ñujp'i ti cárcel, come tsi' ñijca i pi'ʌlob ti' contra gobierno. Tsi' cha'le tsʌnsa ja'el.) ");
INSERT INTO ctuBl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato tsi' cha' pejcayob come yom i col Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Jini winicob tsi' cha' cha'leyob c'am bʌ t'an: Ch'iji ti cruz, ch'iji ti cruz, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ti' yuxyajlel Pilato tsi' c'ajtibeyob: ¿Chucoch? ¿Chuqui ti jontolil tsi' cha'le ili winic? Tsaj q'uele ma'anic i mul cha'an mi' yʌjq'uel ti chʌmel. Mi caj c jats' ti asiyal. Mi caj cʌc' ti colel, che'en Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tsi' wersa c'ajtibeyob ti c'am bʌ t'an cha'an mi' ch'ijtʌl ti cruz. Tsa' mʌjliyob i cha'an winicob yic'ot ñuc bʌ motomajob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato tsi' yʌc'ʌ i t'an cha'an mi' yujtel bajche' tsi' c'ajtiyob winicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tsi' yʌc'ʌ ti colel jini c'ajtibil bʌ i cha'añob, tsa' bʌ ñujp'i ti cárcel cha'an tsi' ñijca winicob ti' contra gobierno. Tsi' cha'le tsʌnsa ja'el. Pilato tsi' yʌc'ʌ Jesús ti' c'ʌb winicob cha'an mi' melbeñob bajche' yomob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Che' bʌ tsi' pʌyʌyob majlel tsi' chucuyob winic i c'aba' Simón ch'oyol bʌ ti Cirene. Loq'uem ti xchumtʌl woli' tilel ti tejclum. Tsi' yʌq'ueyob i q'uech majlel cruz ti' pat Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Cabʌl winicob x'ixicob tsi' tsajcayob. X'ixicob woli yuc'tañob, ch'ijiyemob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesús tsi' sutq'ui i bʌ cha'an mi' q'uelob. Tsi' subeyob: X'ixicob añet bʌ la ti Jerusalén, mach mi la' wuc'tañon. Uc'tan la' bʌ. Uc'tan la' walobilob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Come awilan, tal jini q'uin tac che' mi caj i yʌlob: “Tijicñayob jini to'ol wa'al jach bʌ x'ixic yic'ot jini mach bʌ anic tsi' cʌntayob i yalobil yic'ot jini mach bʌ anic tsi' tsu'sayob alʌl”. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti jim bʌ ora mi caj i pejcañob wits: “Yajlen ti joñon lojon”, che'ob. Mi caj i subeñob bujtʌl: “Mujlañon lojon”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mi che'ʌch mi la' tic'lañon che' ma'anic c mul, ñumen mi caj la' tic'lʌntel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tsi' pʌyʌyob majlel ja'el cha'tiquil xjontolilob yic'ot Jesús cha'an mi' tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Che' bʌ tsa' c'otiyob ti jini bujtʌl i c'aba' I Bʌquel Jolʌl, ya' tsi' ch'ijiyob ti cruz Jesús yic'ot jini xjontolilob, juntiquil ti' ñoj, yambʌ ti' ts'ej. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús tsi' yʌlʌ: C Tat ñusʌbeñob i mul come mach yujilobic chuqui woli' cha'leñob, che'en. Tsi' pucbeyob i bʌ i pislel Jesús che' bʌ tsi' cha'leyob yajcaya ti alas. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jini winicob x'ixicob woli' q'uelob. Jini yumʌlob tsi' wajleyob Jesús. Tsi' yʌlʌyob: Tsi' colta yaño' bʌ. La' i coltan i bʌ mi jiñʌch Cristo, jini Yajcʌbil bʌ i cha'an Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jini soldadojob ja'el tsi' wajleyob. Tsa' tili i yʌq'ueñob vinagre che' tiquin i ti'. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jini soldadojob tsi' yʌlʌyob: Mi i Reyet judíojob coltan a bʌ, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","An ti' chañelal i jol Jesús ili t'an ts'ijbubil bʌ: JIÑɅCH I REY JUDIOJOB. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Juntiquil xjontolil tsa' bʌ ch'ijle ti cruz yic'ot Jesús tsi' wajle. Tsi' yʌlʌ: Mi Cristojet, coltan a bʌ. Coltañon lojon ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jini yambʌ xjontolil tsi' tiq'ui. Tsi' yʌlʌ: ¿Mach ba anic ma' bʌc'ñan Dios? Come junlajal woli lac chʌmel ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ti isujm che'ʌch yom mi lac chʌmel cha'an jontol lac melbal. Pero ili winic ma'anic chuqui jontol tsi' cha'le, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jini winic tsi' sube Jesús: C Yum ña'tañon che' ma' tilel ti a yumʌntel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús tsi' sube: Ti isujm mic subeñet: Wʌle mux caj a wochel quic'ot ti paraíso, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Che' ti xinq'uiñil tsa' ic'a pejtelel pañimil c'ʌlʌl ti och'ajel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Come tsa' wen mʌjqui q'uin. Jini pisil joc'ol bʌ ti Templo tsa' tsijli ti ojlil. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús wen c'am tsi' cha'le t'an. Tsi' yʌlʌ: C Tat, mi cʌq'ueñet c ch'ujlel ti a c'ʌb, che'en. Che' ujtemix i yʌl, tsa' chʌmi. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Che' bʌ tsi' q'uele chuqui tsa' ujti i yaj capitán jo'c'al soldadojob, tsi' subu i ñuclel Dios. Tsi' yʌlʌ: Isujm tojʌch ili winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Che' bʌ tsi' q'ueleyob pejtelel winicob x'ixicob ya' bʌ tempʌbilob, ch'ijiyemob i pusic'al cha'an chuqui tsa' ujti. Tsa' sujtiyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pejtelel i cʌñʌyo' bʌ Jesús yic'ot x'ixicob tsa' bʌ i tsajcayob tilel c'ʌlʌl che' bʌ tsa' loq'uiyob ti Galilea, ñajt wa'alob woli' q'uelob. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ya'an José ch'oyol bʌ ti colem tejclum ti Judea i c'aba' Arimatea. An ñuc bʌ i ye'tel ti' tojlel i pi'ʌlob. Weñʌch jini winic. Toj i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Woli' pijtan i yumʌntel Dios. Ma'anic tsi' teme i t'an yic'ot jini año' bʌ i ye'tel tsa' bʌ i contrajiyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tsa' majli José ba'an Pilato. Tsi' c'ajtibe i bʌc'tal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tsi' ju'sʌbe i bʌc'tal ti cruz. Tsi' bʌc'ʌ ti wen bʌ i bʌjq'uil. Tsi' ñolchoco ti' yotlel ch'ujlelʌl, tocbil bʌ i mal xajlel ba' maxto ac'bilic ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tsa' ujti i mucob ti' q'uiñilel chajpaya che' yomix cajel i q'uiñilel caj o. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jini x'ixicob ja'el tsa' bʌ i tsajcayob majlel Jesús c'ʌlʌl che' bʌ tsa' loq'ui ti Galilea tsi' q'ueleyob bajche' tsa' ñolchoconti i bʌc'tal Jesús ti' yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tsa' sujtiyob. Tsi' chajpayob xojocña bʌ perfume yic'ot c'o'ol bʌ ts'ac. Tsi' c'ajayob i yo ti' q'uiñilel c'aj o che' bajche' mi yʌl mandar. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ti ñaxan bʌ q'uin ti semana che' woli' sʌc'an, tsa majliyob x'ixicob ti mucoñibʌl. Tsi' ch'ʌmʌyob majlel xojocña bʌ perfume tsa' bʌ i chajpayob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Che' bʌ tsa' c'otiyob, selc'ubilix loq'uel jini xajlel ti' ti' i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tsa' ochiyob ti mal. Ma'anic tsi' tajbeyob i bʌc'tal lac Yum Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tsa' caji i melob i pusic'al cha'an ma'anic tsiquil. Awilan ya' ti' t'ejl tsa' wa'leyob cha'tiquil winicob ts'ʌylaw bʌ i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jini x'ixicob tsi' ju'sayob i wut ti lum cha'an bʌq'uen. Jini winicob tsi' subeyob: ¿Chucoch mi la' sajcan jini cuxul bʌ ba'an chʌmeño' bʌ? ");
INSERT INTO ctuBl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Mach wʌ'ix an. Tsa'ix ch'ojyi. Ña'tanla chuqui tsi' subeyetla Jesús che' ya'to an ti Galilea: ");
INSERT INTO ctuBl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Wersa mi' yʌjq'uel i Yalobil Winic ti' c'ʌb jontol bʌ winicob. Wersa mi' ch'ijtʌl ti cruz. Wersa mi' cha' ch'ojyel ti' yuxp'ejlel q'uin”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Tsa' cha' c'ajtiyi i cha'añob i t'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tsi' cʌyʌyob mucoñibʌl. Tsa' majli i laj subeñob jini junlujuntiquil yic'ot pejtel i pi'ʌlob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jiñobʌch María, ch'oyol bʌ ti Magdala, yic'ot Juana, yic'ot María i ña' Jacobo, yic'ot yambʌ x'ixicob tsa' bʌ i subeyob jini apóstolob chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jini junlujuntiquil tonto jax tsi' yubibeyob i t'an. Ma'anic tsi' ñopbeyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tsa' wa'le Pedro. Ajñel tsa' majli ti mucoñibʌl. Che' bʌ tsi' q'uele i mal, cojach tsi' q'uelbe i bʌjq'uil Jesús. Tsa' cha' majli ti' yotot. Tsa' toj sajti i pusic'al cha'an jini tsa' bʌ ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Awilan, ti jini jach bʌ q'uin woli' majlelob cha'tiquil xcʌnt'añob ti jump'ejl tejclum i c'aba' Emaús, che' bajche' uxp'ejl legua i ñajtlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Che' woli' majlelob tsi' pejcayob i bʌ cha'an pejtelel chuqui tac tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Che' woliyob ti t'an, che' woli' pejcañob i bʌ, Jesús tsi' lʌc'tesa i bʌ. Tsi' pi'leyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ma'anic tsa' aq'uentiyob i cʌñob Jesús che' bʌ tsi' q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús tsi' c'ajtibeyob: ¿Chuqui ti t'an woli la' wʌl che' woliyetla ti xʌmbal majlel? ¿Chucoch ch'ijiyemetla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Juntiquil i c'aba' Cleofas tsi' c'ajtibe: ¿Xjula'et jach ba ti Jerusalén? ¿Mach ba anic tsa' wubi chuqui tsa' ujti ya'i ti jini q'uin tac? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús tsi' yʌlʌ: ¿Chuqui jini tsa' bʌ ujti? che'en. Jini xcʌnt'añob tsi' subeyob: ¿Mach ba anic tsa' wubi bajche' tsa' ujti Jesús ch'oyol bʌ ti Nazaret? X'alt'añʌch jini Jesús. Tsi' pʌsʌ i p'ʌtʌlel ti wen bʌ i melbal yic'ot ti' t'an ti' wut Dios yic'ot ti' wut pejtelel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","¿Mach ba anic tsa' wubi? Jini ñuc bʌ motomajob yic'ot jini yumʌlob lac cha'an tsi' yʌc'ʌyob ti' c'ʌb yaño' bʌ cha'an mi' yʌjq'uel ti chʌmel. Tsi' ch'ijiyob ti cruz. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tsa cʌlʌ lojon jiñʌch mu' bʌ caj i coltan israelob. Mach cojic jach, pero wʌle i yuxp'ejlelix q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","An x'ixic bʌ c pi'ʌlob lojon tsa' bʌ i yʌc'ʌ ti toj sajtel c pusic'al lojon. Ti sʌc'ajel tsa' majliyob ti mucoñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma'anic tsi' tajbeyob i bʌc'tal Jesús. Tsa' cha' tili i subeñon lojon tsi' q'ueleyob ángelob tsa' bʌ i yʌlʌyob cuxul Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Cha'tiquil uxtiquil c pi'ʌlob lojon tsa' majliyob ti mucoñibʌl. Che'ʌch tsi' tajayob bajche' tsi' yʌlʌyob x'ixicob. Pero ma'anic tsi' q'ueleyob Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús tsi' subeyob: Tontojetla, jal mi la' ñop ti la' pusic'al pejtelel chuqui tsi' yʌlʌyob x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mach ba wersajic tsi' ñaxan ubi ili wocol jini Cristo cha'an mi yochel ti' ñuclel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jesús tsa' caji i subeñob i sujmlel pejtelel i Ts'ijbujel Dios ba' tsa' tajle ti t'an c'ʌlʌl ti' jun Moisés c'ʌlʌl ti' jun pejtelel x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tsa' c'otiyob ti alʌ tejclum ba' woli' majlelob. Che' bajche' yom to i xʌn majlel tsi' mele Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero tsi' wersa subeyob cʌytʌl. Tsi' yʌlʌyob: Cʌlejen quic'ot lojon come yomix ic'an. Wolix i bʌjlel q'uin, che'ob. Tsa' ochi ti jijlel yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Che' bʌ buchul yic'otob ti' t'ejl mesa Jesús tsi' ch'ʌmʌ waj. Tsi' sube wocolix i yʌlʌ Dios. Tsi' xut'u jini waj. Tsi' yʌq'ueyob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ti ora tsa' aq'uentiyob i wen cʌn Jesús. Pero Jesús tsi' bʌc' sʌtʌ i bʌ ti' wutob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsi' subeyob i bʌ: ¿Mach ba uts'atic jax lac pusic'al tsa' la cubi che' bʌ tsi' pejcayonla Jesús ti bij, che' bʌ tsi' subeyonla i sujmlel i Ts'ijbujel Dios? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tsa' ch'ojyiyob ti jini jach bʌ ora. Tsa' cha' majliyob ti Jerusalén ba' tsi' tajayob jini junlujuntiquil tsa' bʌ i tempayob i bʌ yic'ot yaño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tsi' yʌlʌyob: Isujmʌch tsa'ix cha' ch'ojyi lac Yum. Tsa'ix i pʌsʌ i bʌ ba'an Simón, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jini cha'tiquil tsi' subeyob chuqui tsa' ujti ti bij. Tsa' caji i yʌlob bajche' tsi' cʌñʌyob Jesús che' bʌ tsi' xut'u waj. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Che' woliyob ti t'an cha'an chuqui tsa' ujti, tsa' wa'le Jesús ti ojlil ba' añob. Tsi' subeyob: La' ñʌch'lec la' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tsa' toj sajtiyob i pusic'al xcʌnt'añob. Tsi' cha'leyob bʌq'uen. Tsi' lon ña'tayob woli' q'uelob espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús tsi' subeyob: ¿Chucoch woli la' mel la' pusic'al? ¿Chucoch woli ti t'an la' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Q'uelela j c'ʌb yic'ot coc. Awilan, joñoñʌch. Tʌlʌyon. Q'ueleyon. Come ma'anic i bʌc'tal ma'anic i bʌquel espíritu che' bajche' woli la' q'uelon, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Che' bʌ tsa' ujti i sub jini t'an, tsi' pʌsbeyob i c'ʌb i yoc. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Maxto anic tsa' mejli i ñopob mi isujm cha'an i tijicñʌyel i pusic'al. Tsi' c'ajtibeyob i bʌ bajche' isujm. Jesús tsi' c'ajtibeyob: ¿Am ba chuqui mi laj c'ux? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jini xcʌnt'añob tsi' yʌq'ueyob ts'ita' pojpobil bʌ chʌy yic'ot chab. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús tsi' ch'ʌmʌ. Tsi' c'uxu ti' tojel i wut. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesús tsi' subeyob: Jiñʌch tsa' bʌ c subeyetla che' añon to quic'otetla cha'an wersa mi' yujtel pejtelel chuqui tac ts'ijbubil cha'añon ti' mandar Moisés yic'ot ti' jun x'alt'añob yic'ot ti Salmos, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Che' jini tsi' yʌq'ueyob i ña'tʌbal cha'an mi' ch'ʌmbeñob isujm i Ts'ijbujel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tsi' subeyob: Wersa mi' yubin wocol jini Cristo. Wersa mi' cha' ch'ojyel ba'an chʌmeño' bʌ ti yuxp'ejlel q'uin che' bajche' ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Wersa mi' subentelob winicob x'ixicob ti pejtelel lum cha'an mi' cʌyob i mul ti' c'aba' Cristo cha'an mi' ñusʌbentelob i mul. Ya' ti Jerusalén mi caj i tejchel ti sujbel jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jatetla mi caj la' sub chuqui tac tsa' la' q'uele. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Awilan, mi caj c chocbeñetla tilel chuqui subebiletla i cha'an c Tat mu' bʌ caj i yʌq'ueñetla. Jalijenla wʌ' ti Jerusalén jinto mi la' wʌq'uentel la' p'ʌtʌlel ch'oyol bʌ ti chan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesús tsi' pʌyʌyob majlel c'ʌlʌl ti Betania. Tsi' letsa i c'ʌb. Tsi' yʌq'ueyob i yutslel i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Che' bʌ tsa' ujti i yʌq'ueñob i yutslel i t'an tsi' cʌyʌyob. Tsa' pʌjyi letsel ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jini xcʌnt'añob tsi' ch'ujutesayob. Tsa' cha' majliyob ti Jerusalén, wen tijicñayob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tsa' chʌn majliyob ti Templo. Tsi' subuyob i ñuclel Dios. Tsi' yʌlʌyob uts'at Dios.");
INSERT INTO ctuBl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ti' cajibal pañimil an jini T'an. Añʌch jini T'an yic'ot Dios. Jini T'an Diosʌch. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","An yic'ot Dios ti' cajibal pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jini T'an tsi' mele pejtelel chuqui tac an. Ma'anic chuqui mach melbilic i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","An i p'ʌtʌlel cha'an mi' yʌq'ueñob winicob x'ixicob i cuxtʌlel. I cuxtʌlel mi' yʌq'ueñob i yajñel ti' sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I sʌclel pañimil mi' pʌs i bʌ ti ic'ch'ipan bʌ pañimil. Jini ic'ch'ipan bʌ pañimil ma'anic tsi' yʌpbe i sʌclel. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","An winic chocbil bʌ tilel i cha'an Dios. I c'aba' Juan. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tsa' tili Juan i sub chuqui isujm. Tsa' tili i yʌc' ti cʌjñel i sʌclel pañimil cha'an mi' ñopob pejtelel winicob x'ixicob cha'an ti' t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mach jinic i sʌclel pañimil Juan. Tsa' jach chojqui tilel cha'an mi' yʌc' ti cʌjñel i sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","I sʌclel pañimil jiñʌch Cristo ti isujm. Tsa' tili ti pañimil i yʌq'ueñob i sʌclel pañimil pejtelel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo tsa' ajni ti pañimil. Jini pañimil i melbalʌch. Jini año' bʌ ti pañimil ma'anic tsi' cʌñʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tsa' tili ti' tejclum. I pi'ʌlob ma'anic tsi' ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pejtelel tsa' bʌ i ñopoyob tsa' aq'uentiyob i p'ʌtʌlel ti Cristo ti jujuntiquil cha'an mi' yochelob ti' yalobilob Dios. Jiñobʌch tsa' bʌ i ñopbeyob i c'aba' Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tsi' cha' ilayob pañimil, come che' yom Dios. Ma'anic tsi' cha' ilayob pañimil cha'an ti' tat i ña', mi cha'an yomob i tat i ña', mi cha'an che'ʌch yomob ti' bajñel pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jini T'an tsi' ch'ʌmʌ i bʌc'tal. Tsa' chumle la quic'ot, but'ul ti' yutslel i pusic'al yic'ot i sujmlel. Tsaj q'uele lojon i ñuclel tilem bʌ ti' Tat. Jiñʌch i ñuclel cojach bʌ i Yalobil Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan tsa' tili i yʌc' ti cʌjñel Cristo. C'am tsi' cha'le t'an. Tsi' yʌlʌ: Jiñʌch mu' bʌ i tilel tic pat che bajche' tsac subeyetla. Ñumen ñuc bajche' joñon come an ti ñaxan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ti pejtelonla an chuqui tsa' aq'uentiyonla ti' bujt'emal Cristo. Jiñʌch i yutslel mu' bʌ i p'ojlesʌbeñonla. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Come tsa' c'oti jini mandar ti' tojlel Moisés. Pero ti' caj Jesucristo tsa' tili i yutslel i pusic'al Dios yic'ot i sujmlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma'anic majqui tsi' q'uele Dios ti pejtelel ora, jini jach cojach bʌ i Yalobil am bʌ ti' t'ejl i Tat. Jini tsi' yʌc'ʌ ti cʌjñel i Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jiñʌch i t'an Juan tsa' bʌ i subu ti isujm che' bʌ tsa' tiliyob motomajob yic'ot levíjob ba'an. Jini motomajob yic'ot levíjob tsa' chojquiyob majlel cha'an judíojob ya' ti Jerusalén. Tsi' c'ajtibeyob: ¿Majquiyet? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan tsi' subu i bʌ. Ma'anic tsi' mucu i sujmlel. Tsi' subeyob ti isujm: Mach Cristojonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tsi' c'ajtibeyob: ¿Majquiyet, che' jini? ¿Jatet ba Elías? che'ob. Juan tsi' yʌlʌ: Mach joñonic, che'en. ¿Jatet ba jini x'alt'an? che'ob. Juan tsi' subeyob: Ma'anic. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tsi' c'ajtibeyob: Subu a bʌ: ¿Majquiyet, che' jini? cha'an mi mejlel c suben lojon jini tsa' bʌ i chocoyoñob tilel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan tsi' yʌlʌ: Joñonʌch mu' bʌ c cha'len c'am bʌ t'an ti jochol bʌ lum. “Pʌtʌla majlel i bijlel lac Yum”, cho'on, che' bajche' tsi' yʌlʌ jini x'alt'an Isaías, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jini winicob tsa' chojquiyob tilel cha'an fariseojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tsi' c'ajtibeyob: ¿Chucoch ma' wʌc' ch'ʌmja' che' jini, mi mach Cristojetic, mi mach Elíasetic, mi mach x'alt'añetic? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan tsi' jac'beyob: Joñon mi cʌc' ch'ʌmja' ti ja'. An juntiquil wa'al bʌ ba' añetla mach bʌ anic mi la' cʌn. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jiñʌch am bʌ ti ñaxan mu' bʌ i tilel tic pat. Mach yoque ñuconic cha'an mic ticben i ch'ajñal i xʌñʌb, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tsa' ujti iliyi ti Betania ti junwejl Jordán ja' ya' ba' tsi' yʌc'ʌ ch'ʌmja' Juan. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ti yijc'ʌlal Juan tsi' q'uele wolix i tilel Jesús. Tsi' yʌlʌ: Awilan, jiñʌch i Tiñʌme Dios mu' bʌ i ch'ʌm majlel i mul pejtel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jiñʌch tsa' bʌ c ña'ta che' bʌ tsac subu: “Tal tic pat juntiquil winic ñumen ñuc bʌ bajche' joñon come an ti ñaxan”, cho'on. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Joñon ma'anic tsaj cʌñʌ. Tsa' tili cʌc' ch'ʌmja' cha'an mi cʌq'ueñob i cʌn jini winic jini israelob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan tsi' subu ti isujm chuqui tsi' q'uele. Tsi' yʌlʌ: Tsaj q'uele che' bʌ tsa' jubi tilel Espíritu che' bajche' x'ujcuts loq'uem bʌ ti panchan. Tsa' cʌle yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Joñon ma'anic tsaj cʌñʌ, che'en Juan. Jini tsa' bʌ i chocoyon tilel cha'an mi cʌc' ch'ʌmja' tsi' subeyon: “Mi caj a cʌn che' ma' q'uel Espíritu che' mi' jubel tilel ti' jol. Jini mu' bʌ i cʌytʌl Espíritu ti' jol jiñʌch mu' bʌ i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ Espíritu”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Joñon tsaj q'uele. Tsac subu che' bajche' tsaj q'uele. Jiñʌch i Yalobil Dios. Che' tsi' yʌlʌ Juan. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti yijc'ʌlal cha' ya'an Juan yic'ot cha'tiquil xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Juan tsi' q'uele Jesús woli bʌ ti xʌmbal ñumel ti lʌc'ʌl. Tsi' yʌlʌ: Q'uelela i Tiñʌme' Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jini cha'tiquil xcʌnt'añob tsi' yubibeyob i t'an Juan. Tsi' tsajcayob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús tsi' sutq'ui i bʌ. Tsi' q'uele woli' tsajcañob majlel. Tsi' subeyob: ¿Chuqui woli la' sajcan? che'en. Tsi' subeyob: Rabí, ¿baqui jijlemet? che'ob. (Rabí mi' yʌl ti lac t'an, Maestro.) ");
INSERT INTO ctuBl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús tsi' subeyob: La' q'uelela, che'en. Tsa' tiliyob. Tsi' q'ueleyob baqui jijlem. Tsa' ajniyob yic'ot ti jini q'uin, come och'ajelix q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juntiquil tsa' bʌ i yubibe i t'an Juan, i c'aba' Andrés, tsi' tsajca majlel Jesús. Andrés jiñʌch i yijts'in Simón Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés tsi' ñaxan taja i yʌscun i c'aba' Simón. Tsi' sube: Tsac taja lojon jini Mesías, che'en. (Mi' yʌl ti lac t'an, jini Cristo, jini Yajcʌbil bʌ.) ");
INSERT INTO ctuBl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés tsi' pʌyʌ tilel Simón ba'an Jesús. Che' bʌ tsi' q'uele Jesús, tsi' sube: Jatet, Simón, i yalobilet Juan. Mi caj a wotsʌbentel a c'aba' ti Cefas, che'en. (Mi' yʌl ti lac t'an, xajlel.) ");
INSERT INTO ctuBl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti yijc'ʌlal Jesús yom majlel ti Galilea. Tsi' taja Felipe. Tsi' sube: Tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ya' ch'oyol Felipe ti Betsaida ti jini tejclum ba' ch'oyolob Andrés yic'ot Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe tsi' taja Natanael. Tsi' sube: Tsa'ix c taja lojon jini Cristo, ña'tʌbil bʌ ti jini mandar tsa' bʌ i ts'ijba Moisés, yic'ot ti' ts'ijbujel jini x'alt'añob. Jiñʌch Jesús ch'oyol bʌ ti Nazaret, i yalobil José, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael tsi' sube: ¿Am ba chuqui wen ch'oyol bʌ ti Nazaret? che'en. Felipe tsi' sube: La' q'uele, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús tsi' q'uele Natanael che' wolix i tilel ba'an. Tsi' subu: Awilan, isujm jiñʌch juntiquil israel mach bʌ yujilic lot, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael tsi' sube: ¿Bajche' ma' cʌñon? che'en. Jesús tsi' jac'be: Tsaj q'ueleyet che' maxto anic tsi' pʌyʌyet Felipe, che' ya'to añet ti yebal higuera te', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael tsi' jac'be: Maestro, i Yalobilet Dios, i Reyet Israel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús tsi' jac'be: Woli a ñopon come tsac subeyet tsaj q'ueleyet ti yebal higuera te'. Mu' to caj a q'uel ñumen ñuc tac bʌ bajche' jini, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús tsi' sube Natanael: Isujm, isujm mic subeñetla, mi caj la' q'uel che' jajmenix panchan. Mi caj la' q'uel i yángelob Dios che' mi' letselob che' mi' jubelob ti' tojlel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ti yuxp'ejlel q'uin woli' melob q'uiñijel cha'an ñujpuñijel ya' ti Caná ti Galilea. Ya'an i ña' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Tsa' pʌjyi majlel Jesús ja'el yic'ot xcʌnt'añob i cha'an ba' woli' melob q'uiñijel. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Che' bʌ tsa' jili jini vino, i ña' Jesús tsi' sube i yalobil: Ma'anix i cha'añob vino, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús tsi' sube: X'ixic, ¿chuqui i ye'tel ma' tilel ba' añon? Max to i yorajlelic que'tel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","I ña' tsi' sube xñusa vinojob: Laj melela chuqui mi' subeñetla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ya'an wʌcp'ejl colem bʌ i yajñib ja' melbil bʌ ti xajlel, come i tilelʌch judíojob mi' c'ʌñob ti pocoñel. Mi' yochel i bʌl cha'p'ejl uxp'ejl uc'um ti jujump'ejl. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús tsi' subeyob: Laj but'ula ti ja' jini wʌcp'ejl i yajñib ja', che'en. Tsi' but'uyob jinto che' laj pampaña tsa' cʌle. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Tsi' subeyob: Luchuxla wʌle. Ch'ʌmʌla majlel ba'an xcʌntaya q'uin, che'en. Tsi' ch'ʌmʌyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jini xcʌntaya q'uin tsi' mits'ti'a jini ja' tsa' bʌ pʌntʌyi ti vino. Mach yujilic baqui ch'oyol. Jini jach xñusa vinojob yujilob, come tsi' luchuyob ja'. Jini xcʌntaya q'uin tsi' pʌyʌ tilel jini winic woli bʌ ti ñujpuñijel. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Tsi' sube: I tilel mi' yʌc'ob wen bʌ vino ti ñaxan. Ti wi'il che' ñajobix xq'uiñijelob, mi' yʌq'ueñob jini mach bʌ yoque sumuquic. Pero jatet mach che'iqui tsa' cha'le. Tsa' loto jini wem bʌ. Wola' wʌc' ti wi'il, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús tsi' mele jini ñaxan bʌ i yejtal i p'ʌtʌlel ya' ti Caná ti Galilea. Tsi' pʌsʌ i ñuclel. Jini xcʌnt'añob i cha'an tsi' ñopoyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tsa' jubi tilel ti Capernaum Jesús yic'ot i ña' yic'ot i yijts'iñob yic'ot xcʌnt'añob i cha'an. Ya' tsa' jijliyob cha'p'ejl uxp'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lʌc'ʌlix i q'uiñilel Pascua mu' bʌ i melob judíojob. Jesús tsa' letsi majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tsi' taja xq'uex taq'uiñob yic'ot xchoñoñelob buchulob ya' ti Templo. Woli' choñob tat wacax yic'ot tiñʌme' yic'ot x'ujcuts. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Che' bʌ tsa' ujti i pʌculan lazo cha'an asiyal, Jesús tsi' chocoyob loq'uel ti Templo ti pejtelelob yic'ot tiñʌme' yic'ot tat wacax. Tsi' wejch'ubeyob i taq'uin xq'uex taq'uiñob. Tsi' ch'a' chocobeyob i mesa tac. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesús tsi' sube jini woli bʌ i choñob x'ujcuts: Ch'ʌmʌla majlel. Mach mi la' sutq'uin ti choñoñibʌl i yotot c Tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jini xcʌnt'añob i cha'an tsi' cha' ña'tayob jini ts'ijbubil bʌ mu' bʌ i yʌl: “Mi caj c jisʌntel cha'an c bʌxlel ti a a wotot”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jini judíojob tsi' c'ajtibeyob: ¿Chuqui i yejtal a p'ʌtʌlel mu' bʌ caj a pʌsbeñon lojon cha'an jini e'tel woli bʌ a mel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús tsi' jac'beyob: Jemela jini templo. Ti uxp'ejl q'uin mi caj c cha' wa'chocon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jini judíojob tsi' yʌlʌyob: Ti wʌcp'ejl i yuxc'al (46) jab tsa' mejli jini Templo. ¿Mu' ba caj a cha' wa'chocon ti uxp'ejl q'uin? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús tsi' laji i bʌc'tal che' bajche' Templo. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jini cha'an che' bʌ tsa' tejchi ch'ojyel Jesús ba'an chʌmeño' bʌ, jini xcʌnt'añob i cha'an tsi' ña'tayob jini t'an tsa' bʌ i yʌlʌ Jesús. Tsi' ñopoyob i Ts'ijbujel Dios yic'ot i t'an Jesús tsa' bʌ i yʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Che' ya'an Jesús ti Jerusalén ti' q'uiñilel Pascua, cabʌl winicob x'ixicob tsi' ñopbeyob i c'aba' che' bʌ tsi' q'ueleyob i yejtal i p'ʌtʌlel tsa' bʌ i pʌsʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesús ma'anic tsi' q'uele ti ñuc winicob x'ixicob, come tsi' laj cʌmbeyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mach wersajic mi' subentel Jesús chuqui an ti' pusic'al winicob x'ixicob, come yujilʌch. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","An juntiquil fariseo, i c'aba' Nicodemo, i yum judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo tsa' tili ba'an Jesús ti ac'ʌlel. Tsi' sube: Rabí, cujil lojon maestrojet, chocbilet tilel i cha'an Dios. Come ma'anic majqui mi mejlel i pʌs i yejtal i p'ʌtʌlel che' bajche' jatet mi ma'anic Dios yic'ot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús tsi' jac'be Nicodemo: Isujm, isujm mic subeñet, jini mach bʌ anic mi' cha' ilan pañimil, mach mejlic i q'uel i yumʌntel Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo tsi' sube: ¿Bajche' mi mejlel i cha' ilan pañimil winic che' ñoxix? ¿Mejl ba i cha' ochel ti' ñʌc' i ña' cha'an mi' yilan pañimil? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús tsi' yʌlʌ: Isujm, isujm mic subeñet, jini mach bʌ anic mi' yilan pañimil yic'ot ja' yic'ot jini Espíritu mach mejlic ti ochel ti' yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jini mu' bʌ i yilan pañimil ti' ña', mi' yʌq'uentel i bʌc'tal. Jini mu' bʌ i yilan pañimil ti Espíritu, mi' yʌq'uentel i cuxtʌlel ti' ch'ujlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mach yomic mi' toj sajtel a pusic'al cha'an tsac subeyet: Wersa yom mi la' cha' ilan pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jini ic' mi' ñumel majlel baqui jach yom. Jatet ma' wubin ic', mach a wujilic baqui ch'oyol mi baqui mi' majlel. Che'ʌch ja'el jini Espíritu ti jujuntiquil mu' bʌ i cha' ilan pañimil. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo tsi' c'ajtibe Jesús: ¿Bajche' mi' mejlel jini? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús tsi' jac'ʌ: Jatet maestrojet ti Israel. ¿Mach ba anic ma' ch'ʌmben isujm? ");
INSERT INTO ctuBl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Isujm, isujm mic subeñet, mic cha'len lojon t'an cha'an chuqui tac cujil lojon. Mic sub lojon ti toj chuqui tsaj q'uele lojon. Ma'anic mi la' jac'beñon lojon c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mi ma'anic mi la' ñop che' mic subeñetla chuqui tac an ti pañimil, ¿bajche' mi caj la' ñop che' mic subeñetla chuqui tac an ti panchan? ");
INSERT INTO ctuBl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma'anic majch tsa' letsi ti panchan, cojach jini tsa' bʌ jubi tilel ti panchan, jiñʌch i Yalobil Winic am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Che' bajche' Moisés tsi' joc'choco lucum ti te' ti jochol bʌ lum, che' ja'el mi caj i wersa letsʌntel i Yalobil Winic, ");
INSERT INTO ctuBl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","cha'an ma'anic mi' sajtel majqui jach mi' ñop. Mi' taj i cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Come che'i tsi' wen c'uxbi jini año' bʌ ti pañimil Dios. Tsi' yʌc'ʌ cojach bʌ i Yalobil. Majqui jach mi' ñop i Yalobil, ma'anic mi' sajtel. Mi' taj i cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Come Dios ma'anic tsi' choco tilel i Yalobil ti pañimil cha'an mi' yotsan ti tojmulil. Tsi' choco tilel cha'an mi' taj i coltʌntel ti' Yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jini mu' bʌ i ñop ma'anic mi' yochel ti tojmulil. Jini mach bʌ anic mi' ñop, ochemix ti tojmulil, come ma'anic tsi' ñopbe i c'aba' jini cojach bʌ i Yalobil Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jiñʌch i mul winicob. Tsa' tili i sʌclel pañimil pero winicob tsi' c'uxbiyob ic'ch'ipan bʌ pañimil. Ma'anic tsi' c'uxbiyob i sʌclel pañimil, come jontol i melbalob. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Come pejtelel mu' bʌ i cha'leñob jontolil ts'a' mi' q'uelob i sʌclel pañimil. Ma'anic mi' tilelob ba'an i sʌclel pañimil ame tsictiyic i melbal. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jini mu' bʌ i mel chuqui isujm, mi' ñochtan i sʌclel pañimil cha'an mi' tsictiyel i melbal come mi' mel ti' p'ʌtʌlel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Che' bʌ tsa' ujti ti t'an, tsa' tili Jesús yic'ot xcʌnt'añob i cha'an ti Judea ba' tsa' jale yic'otob. Tsi' yʌc'ʌ ch'ʌmja'. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan ja'el woli' yʌc' ch'ʌmja' ya' ti Enón lʌc'ʌl ti Salim, come ya'an cabʌl ja'. Tsa' tiliyob winicob x'ixicob i ch'ʌmob ja'. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Come maxto otsʌbilic Juan ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tsa' caji i pejcañob i bʌ judíojob yic'ot xcʌnt'añob i cha'an Juan. Ti chajp ti chajp woliyob ti t'an cha'an bajche' yom mi' pocob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tsa' tiliyob ba'an Juan. Tsi' subeyob: Maestro, woli' yʌc' ch'ʌmja' jini tsa' bʌ tili ba' añet ti junwejl Jordán ja', jini tsa' bʌ a wʌc'ʌ ti cʌjñel che' bʌ tsa' cha'le subt'an. Pejtelel winicob x'ixicob mi' tsajcañob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan tsi' jac'ʌ: Ma'anic chuqui mi' tajob winicob, cojach mu' bʌ i tilel ti Dios am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jatetla tsa'ix la' wubi c t'an. La' wujil tsac subu mach Cristojonic. Tsa' jach chojquiyon tilel ti ñaxan ti' wut Cristo jini Yajcʌbil bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jini mu' bʌ i pʌy i yijñam, jiñʌch xñujpuñijel. Wen tijicña i pusic'al i cʌñʌ bʌ che' an ti' t'ejl jini xñujpuñijel che' mi' yubiben i t'an. Che' jini woli' ts'ʌctiyel i tijicñʌyel c pusic'al ti' tojlel Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wersa mi' ñuq'uesʌntel Cristo. Wersa mic ch'o'ch'ocʌyel, che'en Juan. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jini ch'oyol bʌ ti chan i Yumʌch pejtelel chuqui an. Jini ch'oyol bʌ ti pañimil mu' jach i ña'tan chuqui an ti pañimil. Jini ch'oyol bʌ ti panchan lac Yumʌch ti lac pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Mi' sub chuqui tac tsi' q'uele yic'ot chuqui tac tsi' yubi. Ma'anic majqui mi' ñopben i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jini mu' bʌ i ñopben i t'an mi' sub isujmʌch Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Come jini tsa' bʌ chojqui tilel cha'an Dios mi' sub i t'an Dios. Ma'anic i p'isol bajche' mi' yʌc' i yEspíritu. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lac Tat mi' c'uxbin i Yalobil. Tsa'ix i yʌc'ʌ ti' wenta i Yalobil pejtelel chuqui tac an. ");
INSERT INTO ctuBl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jini mu' bʌ i ñop i Yalobil Dios, an i cha'an i cuxtʌlel mach bʌ anic mi' jilel. Jini mach bʌ anic mi' ñop i Yalobil Dios mach mejlic i yʌq'uentel i cuxtʌlel. Mi' yajñel ti' mich'lel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Lac Yum tsi' yubi chuqui tsi' yʌlʌyob fariseojob. Tsi' yʌlʌyob: Ñumen woli' yotsan winicob ti xcʌnt'añob Jesús bajche' Juan. Ñumen woli' yʌc' ch'ʌmja' Jesús bajche' Juan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Anquese ma'anic tsi' yʌc'ʌ ch'ʌmja' Jesús. Jini xcʌnt'añob i cha'an tsi' yʌc'ʌyob ch'ʌmja'.) ");
INSERT INTO ctuBl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jini cha'an Jesús tsi' cʌyʌ Judea. Tsa' cha' majli ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ya' tsa' caji ti ñumel majlel ti Samaria. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tsa' tili ti jump'ejl tejclum ti Samaria, i c'aba' Sicar, lʌc'ʌl ti' lum Jacob tsa' bʌ i yʌq'ue i yalobil, i c'aba' José. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ya'an pozo tsa' bʌ i mele Jacob. Lujbeñix Jesús ti xʌmbal. Jini cha'an tsa' buchle ti' ti' pozo. Xinq'uiñilix. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tsa' tili x'ixic ch'oyol bʌ ti Samaria cha'an mi' luch ja'. Jesús tsi' sube: Aq'ueñon cha'an mic jap, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Come majlemobix xcʌnt'añob i cha'an ti tejclum cha'an mi' mʌñob i bʌl i ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jini x'ixic ch'oyol bʌ ti Samaria tsi' sube Jesús: Jatet judíojet. ¿Chucoch ma' c'ajtibeñon ja'? come samaritanojon. Judíojob ts'a' mi q'uelob samaritanojob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús tsi' jac'be: Tsa'ic a cʌñʌ a majtan ch'oyol bʌ ti Dios, tsa'ic a cʌñʌ jini woli' bʌ i c'ajtibeñet ja', tsa'ix a c'ajtibeyon ja' cha'an mi cʌq'ueñet cuxul bʌ ja', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jini x'ixic tsi' sube: Maestro, ma'anic a lucho' ja'. Tam i ch'eñal ja'. ¿Baqui ma' taj jini cuxul bʌ ja'? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ñumen ñuquet ba bajche' lac tat Jacob tsa' bʌ i yʌq'ueyonla jini pozo? Wʌ' tsi' japʌ ja' Jacob yic'ot i yalobilob yic'ot pejtelel i yʌlac', che'en jini x'ixic. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús tsi' jac'be: Majqui jach mi' jap jini ja' mi caj i cha' tiquin i ti'. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Majqui jach mi' jap ja' mu' bʌ cʌq'uen, ma'anix mi caj i chʌn tiquin i ti', come jini ja' mu' bʌ cʌq'uen mi' caj ti ajñel ti' pusic'al che' bajche' bulux ja' cha'an mi' yʌq'uen i cuxtʌlel mach bʌ anic mi' jilel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jini x'ixic tsi' sube: Maestro, aq'ueñon jini ja' cha'an ma'anic mi' chʌn tiquin c ti', cha'an mach mic chʌn tilel ti luch ja' ilayi, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús tsi' sube: Cucu, pʌyʌ tilel a ñoxi'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jini x'ixic tsi' jac'be: Ma'anic c ñoxi'al, che'en. Jesús tsi' sube: Melel chuqui ma' wʌl, ma'anic a ñoxi'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Come tsa'ix ajniyob a wic'ot jo'tiquil a ñoxi'al. Jini winic am bʌ a wic'ot wʌle mach a ñoxi'alic. Isujm bajche' tsa' wʌlʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jini x'ixic tsi' sube: Maestro, mic ña'tan x'alt'añet. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","C tat lojon tsi' ch'ujutesayob Dios ila ti wits. Jatetla mi la' wʌl ya' yom mi lac ch'ujutesan Dios ti Jerusalén, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús tsi' sube: X'ixic, ñopoyon. Tal jini ora che' mach wʌ'ic ti wits mi ya'ic ti Jerusalén mi caj la' ch'ujutesan lac Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jatetla mach la' wujilic chuqui mi la' ch'ujutesan. Joñon lojon cujil chuqui mic ch'ujutesan lojon, come ch'oyol i coltʌntel winicob x'ixicob ti judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tal i yorajlel, i yorajlelix wʌle, che' mi caj i ch'ujutesañob lac Tat ti' Espíritu che' ja'el ti isujm jini mero xch'ujutesayajob. Come lac Tat ja'el mi' sajcan jini mu' bʌ i ch'ujutesañob che' bajche' jini. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Espíritujʌch. Jini mu' bʌ i ch'ujutesañob Dios, wersa mi' ch'ujutesañob ti espíritu ti isujm. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jini x'ixic tsi' sube: Cujil tal jini Mesías, jiñʌch jini Cristo, jini Yajcʌbil bʌ. Che' tilemix mi caj i subeñonla pejtelel chuqui tac an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús tsi' sube: Joñoñʌch woli bʌ c pejcañet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tsa' tiliyob xcʌnt'añob i cha'an. Tsa' toj sajtiyob i pusic'al xcʌnt'añob cha'an woli ti t'an Jesús yic'ot jini x'ixic. Ma'anic majch tsi' c'ajtibe: ¿Chuqui wola' c'ajtiben? ¿Chucoch woliyet ti t'an yic'ot? ");
INSERT INTO ctuBl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jini x'ixic tsi' cʌyʌ i yuc'um. Tsa' majli ti tejclum. Tsi' sube winicob x'ixicob: ");
INSERT INTO ctuBl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","La' cu la. Q'uelela winic tsa' bʌ i subeyon pejtel chuqui tac tsac mele ti pejtelel q'uin. ¿Mach ba jinic jini Cristo, jini Yajcʌbil bʌ? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tsa' cajiyob ti loq'uel majlel ti tejclum. Tsa' tiliyob ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Che' woli' tilelob, jini xcʌnt'añob tsi' subeyob Jesús ti wocol t'an: Maestro, cha'len we'el, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesús tsi' subeyob: An c we'el mach bʌ anic mi la' cʌñe', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jini cha'an jini xcʌnt'añob tsi' subeyob i bʌ: ¿Am ba majch tsi' ch'ʌmbe tilel chuqui mi' c'ux? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesús tsi' subeyob: Jiñʌch c we'el che' mic mel chuqui yom c Tat tsa' bʌ i chocoyon tilel. Jiñʌch c we'el che' ts'ʌcʌl mic melben i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Mach ba anic mi la' wʌl: “Anto yom chʌmp'ejl uw cha'an mi' cajel c'ajbal?” che'etla. Awilan, mic subeñetla: Letsan la' wut, q'uelela jini cholel. Come tiquinix. C'ajolix yom. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jini mu' bʌ i cha'len c'ajbal mi' taj i tojol. Mi' tempan i chobejtʌbal cha'an i cuxtʌlel mach bʌ anic mi' jilel. Che' jini junlajal tijicña mi' yubin jini mu' bʌ i cha'len pac' yic'ot jini mu' bʌ i cha'len c'ajbal. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","I' sujm bajche' mi' yʌlob winicob: “Juntiquil mi' cha'len pac', yambʌ mi' cha'len c'ajbal”. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tsa'ix c chocoyetla majlel cha'an mi la' c'aj ba' ma'anic tsa' la' cha'le e'tel. Yaño' bʌ tsi' cha'leyob e'tel. Jatetla wolix la' c'ajben i ye'tel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Cabʌl samaritanojob ya' ti Sicar tsi' ñopoyob Jesús cha'an i subal jini x'ixic che' bʌ tsi' yʌlʌ: “Jini Winic tsi' subeyon pejtelel chuqui tsac mele ti pejtelel q'uin”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Che' tilemobix samaritanojob ba'an Jesús, tsi' c'ajtibeyob ti wocol t'an cha'an mi' jalijel yic'otob. Ya' tsa' cʌle Jesús cha'p'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","An to cabʌlob tsa' bʌ i ñopoyob Jesús cha'an ti' t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tsi' subeyob jini x'ixic: Wʌle mic ñop lojon, mach cha'anic jach tsa' subeyon lojon, pero cha'an tsa cubi lojon i t'an ja'el. Cujil lojon ti isujm jiñʌch jini Cristo, jini Yajcʌbil bʌ, i yaj Coltaya winicob x'ixicob año' bʌ ti pañimil, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ñumenix cha'p'ejl q'uin tsa' loq'ui Jesús ya'i. Tsa' majli ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Come Jesús tsi' yʌlʌ ma'anic mi' c'uxbintel x'alt'an ti' lumal. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Che' bʌ tsa' tili Jesús ti Galilea, jini galileojob tsi' pʌyʌyob ochel, come tsi' q'ueleyob pejtel i melbal Jesús ti Jerusalén che' woli' q'uiñijel, come tsajniyob ja'el i q'uel q'uiñijel. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tsa' cha' tili Jesús ti Caná ti Galilea, ya' ba' tsi' pʌntesa ja' ti vino. Ya' ti Capernaum an juntiquil winic am bʌ i ye'tel. C'am i yalobil jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Che' bʌ tsi' yubi loq'uem Jesús ti Judea woli' tilel ti Galilea, tsa' majli ba'an Jesús. Tsi' c'ajtibe ti wocol t'an cha'an mi' tilel i lajmesan i yalobil, come yomix chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús tsi' sube: Mi ma'anic mi la' q'uel i yejtal c p'ʌtʌlel, ma'anic mi caj la' ñop, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jini am bʌ i ye'tel tsi' sube: C Yum, conla ti ora ame chʌmic calobil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús tsi' sube: Sujtenix. Cha' c'oq'uix a walobil, che'en. Jini winic tsi' ñopbe i t'an Jesús. Tsa' sujti majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Che' woli ti sujtel, tsa' tili i tajob i winicob ti bij. Tsi' subeyob cha' c'oq'uix i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jini am bʌ i ye'tel tsi' c'ajtibeyob baqui ora tsa' caji ti c'oc'an. Tsi' subeyob: Ac'bi che' ts'ita' ñumen ti xinq'uiñil, tsa' lajmi jini c'ajc, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tsa' caji i ña'tan i tat cha'an tsa' c'oc'a i yalobil ti jini jach bʌ ora che' bʌ tsi' sube Jesús: “Cha' cuxul a walobil”. Tsi' ñopo Jesús jini winic yic'ot pejtelel año' bʌ ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiñʌch i cha'yajlel i yejtal i p'ʌtʌlel Jesús tsa' bʌ i pʌsʌ ti Galilea che' loq'uemix ti Judea. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ti wi'il tsa' caji i melob q'uin judíojob. Jesús tsa' letsi majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lʌc'ʌl ti' yochib tiñʌme' ti Jerusalén an ts'ʌmibʌl i c'aba' Betesda ti' t'an hebreojob. An jo'p'ejl corredor ti' joytilel ts'ʌmibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ya' ñololob cabʌl xc'amʌjelob, xpots'ob yic'ot mach bʌ weñobic i yoc, yic'ot jini tiquin bʌ i c'ʌb. Woli' pijtañob i ñijcʌntel ja'. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Come i tilel mi' jubel ochel ángel ti ts'ʌmibʌl cha'an mi' ñijcan ja'. Maqui ñaxan mi' yochel che' mi' yujtel i ñijcan, mi' lajmel pejtelel i chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ya'an juntiquil winic am bʌ i c'amʌjel waxʌclujump'ejl i cha'c'al (38) jab. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús tsi' q'uele jini xc'amʌjel. Tsi' ña'ta anix cabʌl ora ya' ñolol. Tsi' sube: ¿A wom ba ma' c'oc'an? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jini xc'amʌjel tsi' sube: C Yum, ma'anic majch mi' yotsañon ti ts'ʌmibʌl che' ñijcʌbil ja'. Che' woli to c ñochtan ja', mi' bʌc' ochel yambʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús tsi' sube: Ch'ojyen, q'ueche a wʌyib, cha'len xʌmbal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ti ora jini winic tsa' c'oq'uesʌnti. Tsi' q'ueche i wʌyib. Tsi' cha'le xʌmbal. Jiñʌch jini q'uin che' mi' c'ajob i yo judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jini cha'an jini judíojob tsi' subeyob jini tsa' bʌ lajmesʌnti: Jiñʌch i q'uiñilel c'aj o. Tic'bil ti mandar cha'an ma' q'uech majlel a wʌyib, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tsi' jac'beyob: Jini winic tsa' bʌ i c'oq'uesayon tsi' subeyon: “Q'ueche a wʌyib, cha'len xʌmbal”. Che' tsi' subeyon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tsi' c'ajtibeyob: ¿Majqui jini winic tsa' bʌ i subeyet: “Q'ueche a wʌyib, cha'len xʌmbal”? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jini tsa' bʌ lajmesʌnti mach yujilic majqui, come Jesús tsi' tʌts'ʌ i bʌ ba' tempʌbilob winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ti wi'il Jesús tsi' taja jini winic ti Templo. Tsi' sube: Awilan, c'oq'uetix. Mach a chʌn cha'len mulil ame mi' cha' tajet ñumen wocol bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tsa' majli jini winic. Tsi' sube judíojob cha'an jiñʌch Jesús tsa' bʌ i c'oq'uesa. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jini cha'an jini judíojob tsi' tic'layob Jesús. Yomob i tsʌnsan, come tsi' cha'le lajmesaya ti' q'uiñilel c'aj o. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús tsi' subeyob: C'ʌlʌl wʌle mi' cha'len e'tel c Tat. Joñon ja'el mic cha'len e'tel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jini cha'an judíojob ñumen cabʌl tsa' caji i ña'tañob i tsʌnsan Jesús, come mach cojic jach tsi' ñusa i q'uiñilel c'aj o Jesús, pero tsi' pejca Dios ti' tat ja'el. Che' jini tsi' laji i bʌ bajche' Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús tsa' caji i subeñob: Isujm, isujm mic subeñetla: Ma'anic chuqui mi mejlel i bajñel mel i Yalobil Dios. Mi' q'uel chuqui tac woli' mel i Tat, jiñʌch chuqui mi' mel ja'el. Pejtelel chuqui tac mi' mel i Tat, mi' mel i Yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Come c Tat mi' c'uxbin i Yalobil. Mi' pʌsbeñon pejtelel chuqui tac mi' mel. Mu' to caj i pʌsbeñon ñumen ñuc bʌ i ye'tel cha'an mi' toj sajtel la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Come che' bajche' mi' tech ch'ojyel Dios jini chʌmeño' bʌ, che' bajche' mi' yʌq'ueñob i cuxtʌlel, che' ja'el i Yalobil mi' yʌq'uen i cuxtʌlel majqui yom i yʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","C Tat ma'anic mi' mel winicob. Tsi' yʌq'ue i Yalobil i p'ʌtʌlel ti meloñel cha'an mi' melob, ");
INSERT INTO ctuBl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","cha'an mi' q'uelob ti ñuc i Yalobil Dios pejtel winicob x'ixicob che' bajche' mi' q'uelob ti ñuc c Tat. Jini mach bʌ anic mi' q'uel ti ñuc i Yalobil Dios mach ñuquic mi' q'uel c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Isujm, isujm mic subeñetla: Jini mu' bʌ i yubin c t'an, mu' bʌ i ñop jini tsa' bʌ i chocoyon tilel, anix i cuxtʌlel mach bʌ anic mi' jilel. Ma'anic mi' yʌjq'uel ti tojmulil, come mach chʌn chʌmenix. Tsa'ix aq'uenti i cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Isujm, isujm mic subeñetla: Tal i yorajlel, i yorajlelix wʌle, che' mi caj i yubibeñob i t'an i Yalobil Dios jini chʌmeño' bʌ. Pejtelel mu' bʌ i yubiñob mi caj i yʌq'uentelob i cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Come an i p'ʌtʌlel c Tat cha'an mi' yʌq'ueñob i cuxtʌlel. Che' ja'el tsi' yʌq'ue i p'ʌtʌlel i Yalobil cha'an mi' yʌq'ueñob i cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Dios tsi' yʌq'ue ja'el i p'ʌtʌlel ti meloñel come i Yalobilʌch Winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mach yomic mi' toj sajtel la' pusic'al cha'an jini c t'an, come tal i yorajlel che' mi caj i yubibeñob i t'an i Yalobil Winic jini año' bʌ ti mucoñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Jini tsa' bʌ i cha'leyob chuqui wen mi caj i ch'ojyelob loq'uel ti mucoñibʌl cha'an mi' yochelob ti' cuxtʌlel. Jini tsa' bʌ i cha'leyob jontolil mi caj i ch'ojyelob loq'uel ti mucoñibʌl cha'an mi' yochelob ti tojmulil. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tic bajñelil ma'anic chuqui mi mejlel c mel. Che' bajche' mi cubin, che'i mic cha'len meloñel. Tojʌch c meloñel, come ma'anic mic mel chuqui com tic bajñelil. Mic mel chuqui yom c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mi tsac bajñel subu c bʌ, mach isujmic c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","An yambʌ mu' bʌ i yʌc'on ti cʌjñel. Cujil isujm i t'an jini mu' bʌ i yʌc'on ti cʌjñel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jatetla tsa' la' choco majlel winicob ba'an Juan. Tsi' yʌc'ʌyon ti cʌjñel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mach comic j coltʌntel ti winicob. Cojach cha'an mi la' coltʌntel mic subeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Lajalʌch Juan bajche' jump'ejl c'ajc woli bʌ ti lejmel mu' bʌ i yʌc' i sʌclel. Poj tijicñayetla che' bʌ tsa' la' q'uele i sʌclel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Anto yan tac bʌ mu' bʌ i yʌc'on ti cʌjñel. Ñumen ñuc jini bajche' i t'an Juan. Jiñʌch que'tel tsa' bʌ i yʌq'ueyon c Tat cha'an mic mel ti ts'ʌcʌl. Jini que'tel mu' bʌ c cha'len, mi' yʌc'on ti cʌjñel cha'an mi la' ña'tan tsi' chocoyon tilel c Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","C Tat ja'el tsa' bʌ i chocoyon tilel tsa'ix i yʌc'ʌyon ti cʌjñel. Jatetla ma'anic tsa' la' wis ubibe i t'an ti pejtelel ora. Ma'anic tsa' la' q'uele bajche' yilal Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ma'anic mi' yajñel i t'an ti la' pusic'al, come ma'anic mi la' ñopon anquese chocbilon tilel i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Cabʌl woli la' lon q'uel i Ts'ijbujel Dios, come ya' mi la' ña'tan la' taj la' cuxtʌlel mach bʌ anic mi' jilel. Pero wen q'uelela come jiñʌch mu' bʌ i yʌc'on ti cʌjñel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jatetla mach la' womic la' tilel ba' añon cha'an mi la' taj la' cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mach ti winiquic ch'oyol c ñuclel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mij cʌñetla. Ma'anic mi la' c'uxbin Dios ti la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Joñon tsa' tiliyon ti' c'aba' c Tat. Ma'anic mi la' ñopon. Mi tsa' tili yambʌ tij c'aba', jini mi caj la' ñop. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Bajche' mi mejlel la' ñop? Mi la' taj la' ñuclel ti winicob. Ma'anic mi la' sajcan la' ñuclel ch'oyol bʌ ti jini cojach bʌ Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mach mi la' wʌl ti la' pusic'al mi joñon mi caj c sub la' mul ti' tojlel c Tat. Jini Moisés, mu' bʌ la' ñop, jiñʌch mu' bʌ caj i sub la' mul. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tsa'ic la' ñopo Moisés, tsa' la' ñopoyon ja'el, come tsi' tajayon ti t'an ti' ts'ijbujel. ");
INSERT INTO ctuBl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mi ma'anic mi la' ñop chuqui tsi' ts'ijba Moisés, ¿bajche' mi caj la' ñop c t'an? Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ti wi'il Jesús tsa' c'axi ti Galilea ñajb, i c'aba' ja'el Tiberias. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cabʌlob tsi' tsajcayob majlel Jesús, come tsi' q'ueleyob i yejtal i p'ʌtʌlel tsa' bʌ i pʌsʌ ti xc'amʌjelob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesús tsa' letsi majlel ti wits. Ya'i tsa' buchle yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lʌc'ʌlix i q'uiñilel jini Pascua mu' bʌ i melob judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesús tsi' ts'ita' letsa i wut. Tsi' q'uele cabʌl winicob x'ixicob woli bʌ i tilelob ba'an. Jesús tsi' sube Felipe: ¿Baqui mi mejlel lac mʌn waj cha'an mi' c'uxob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tsi' sube jini t'an cha'an yom i q'uelben i pusic'al Felipe, come yujil Jesús ti' bajñelil chuqui yom i mel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe tsi' jac'be: Mach jasʌlic lujunc'al denario cha'an mic mʌn lojon waj cha'an mi' ts'ita' c'uxob ti jujuntiquil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Juntiquil xcʌnt'an i c'aba' Andrés, i yijts'in Simón Pedro, tsi' sube: ");
INSERT INTO ctuBl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Wʌ'an juntiquil ch'iton am bʌ i cha'an jo'q'uejl waj melbil bʌ ti cebada yic'ot cha'cojt chʌy. ¿Jasʌl ba che' cabʌlonla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús tsi' sube: Subenla buchtʌl winicob x'ixicob, che'en. Ya'an jam. Tsa' buchleyob ti pejtelelob. Añob che' bajche' jo'p'ejl mil winicob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús tsi' ch'ʌmʌ jini waj. Che' bʌ tsi' sube wocolix i yʌl Dios, tsi' xet'e. Tsi' yʌq'ueyob xcʌnt'añob. Jini xcʌnt'añob tsi' pucbeyob jini buchulo' bʌ. Che' ja'el jini chʌy. Tsi' c'uxuyob bajche' c'amel yomob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Che' ñajobix, Jesús tsi' sube xcʌnt'añob i cha'an: Laj tempanla i xujt'il tac tsa' bʌ colobaji cha'an ma'anic mi' sajtel mi ts'ita'ic. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jini cha'an tsi' tempayob. Tsi' bujt'esayob lajchʌmp'ejl chiquib i xujt'il tac jini jo'q'uejl waj tsa' bʌ colobaji che' bʌ tsa' ujti i c'uxob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jini winicob tsa' bʌ i q'ueleyob i yejtal i p'ʌtʌlel tsa' bʌ i pʌsʌ Jesús, tsi' yʌlʌyob: Isujm jiñʌch jini x'alt'an mu' bʌ i tilel ti pañimil, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Che' bʌ tsi' ña'ta Jesús woli' tilel i chucob ti wersa cha'an mi' yotsañob ti rey, tsa' cha' majli ti wits ti' bajñel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Che' wolix i yic'an, tsa' jubiyob majlel xcʌnt'añob i cha'an c'ʌlʌl ti ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tsa' ochiyob ti barco. Tsa' ñumiyob ti colem ñajb cha'an yomob majlel ti Capernaum. Che' iq'uix, maxto tilemic Jesús ba' añob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tsa' caji i cabʌl ñijcan i bʌ ñajb come cabʌl ic' tsi' wec'ula ja'. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Che' bʌ tsa'ix i ñijcayob majlel barco tic'ʌl mi jump'ejl legua, jini xcʌnt'añob tsi' q'ueleyob Jesús. Woli' cha'len xʌmbal ti pam ja'. Wolix i ñochtan tilel barco. Tsi' cha'leyob bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús tsi' subeyob: Joñoñʌch. Mach la' cha'len bʌq'uen, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jini cha'an tijicñayob xcʌnt'añob tsi' pʌyʌyob ochel ti barco. Ti ora tsa' c'oti barco ti lum ba' yomob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti yijc'ʌlal ya' to an winicob x'ixicob ti junwejl colem ñajb ba' tsi' c'uxuyob waj. Yujilob an jump'ejl jach barco ba' tsa' bajñel ochiyob jini xcʌnt'añob, come ma'anic tsa' ochi Jesús yic'otob. I bajñelob jach tsa' majliyob xcʌnt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tsa' tili barco tac ch'oyol bʌ ti Tiberias, lʌc'ʌl ba' tsi' c'uxuyob waj che' bʌ tsa' ujti i suben wocolix i yʌlʌ lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Che' bʌ tsi' q'ueleyob winicob mach ya'ic an Jesús, mach ya'ic añob xcʌnt'añob i cha'an ja'el, tsa' ochiyob ti barco tac. Tsa' tiliyob ti Capernaum cha'an mi' sajcañob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Che' bʌ tsi' tajayob Jesús ti junwejl colem ñajb, tsi' c'ajtibeyob: Maestro, ¿baqui ora tsa' juliyet wʌ'i? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús tsi' jac'beyob: Isujm, isujm mic subeñetla, mi la' sajcañon cha'an jach tsa' ñaj'ayetla ti waj, mach cha'anic tsa' la' q'uele i yejtal c p'ʌtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mach mi la' cha'len e'tel cha'an jini we'elʌl mu' bʌ i jilel. Cha'lenla e'tel cha'an jini we'elʌl mu' bʌ i jalijel cha'an mi la' taj la' cuxtʌlel mach bʌ anic mi' jilel. I Yalobil Winic mi caj i yʌq'ueñetla jini we'elʌl, come Dios c Tat tsa'ix i yʌq'ueyon c p'ʌtʌlel cha'an ili e'tel. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jini tempʌbilo' bʌ tsi' c'ajtibeyob: ¿Chuqui yom mic cha'len lojon cha'an mic mel lojon i ye'tel Dios? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús tsi' jac'beyob: Jiñʌch i ye'tel Dios, che' mi la' ñop i Yalobil tsa' bʌ i choco tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Tsi' c'ajtibeyob: ¿Chuqui i yejtal a p'ʌtʌlel ma' pʌs cha'an mij q'uel lojon, cha'an mic ñopet lojon? ¿Chuqui a we'tel mu' bʌ a cha'len? ");
INSERT INTO ctuBl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lac ñojte'el tsi' c'uxuyob maná ti colem bʌ i tiquiñal lum che' bajche' ts'ijbubil: “Dios tsi' yʌq'ueyob waj ch'oyol bʌ ti panchan cha'an mi' c'uxob”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús tsi' subeyob: Isujm, isujm mic subeñetla: Jini tsa' bʌ i yʌq'ueyetla jini waj ch'oyol bʌ ti panchan mach jinic Moisés. C Tat mi' yʌq'ueñetla jini isujm bʌ waj ch'oyol bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Come jini Waj ch'oyol bʌ ti Dios, jiñʌch tsa' bʌ jubi tilel ti panchan mu' bʌ i yʌq'ueñob i cuxtʌlel jini año' bʌ ti pañimil, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tsi' subeyob: C Yum, aq'ueñon lojon jini waj ti pejtelel ora, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús tsi' subeyob: Joñon Wajon mu' bʌ i yʌq'ueñetla la' cuxtʌlel. Jini mu' bʌ i tsajcañon ma'anic ba' ora mi caj i yubin wi'ñal. Jini mu' bʌ i ñopon ma'anic ba' ora mi caj i tiquin i ti'. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero jatetla, che' bajche' tsac subeyetla, ma'anic mi la' ñopon anquese tsa' la' q'ueleyon. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pejtelel winicob x'ixicob mu' bʌ i yʌq'ueñon c Tat mi caj i tilelob ba' añon. Majqui jach mi' tilel ma'anic mi caj c choc sujtel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Come tsa' jubiyon tilel ti panchan cha'an mic mel chuqui yom c Tat tsa' bʌ i chocoyon tilel. Ma'anic tsa' tili c mel chuqui com tic bajñel pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jiñʌch chuqui yom c Tat tsa' bʌ i chocoyon tilel. Yom mic techob ch'ojyel ti jini cojix bʌ q'uin pejtelel winicob x'ixicob tsa' bʌ i yʌq'ueyon Dios. Mach yomic mi' sajtel mi juntiquilic. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jiñʌch chuqui yom c Tat tsa' bʌ i chocoyon tilel. Yom mi' tajob i cuxtʌlel mach bʌ anic mi' jilel pejtelel mu' bʌ i q'uelob i Yalobil, mu' bʌ i ñopob. Joñon mi caj c techob ch'ojyel ti jini cojix bʌ q'uin, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jini judíojob tsa' cajiyob ti wulwul a'leya come tsi' yʌlʌ Jesús: “Joñon jini Wajon tsa' bʌ jubi tilel ti panchan”. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Tsi' yʌlʌyob: ¿Mach ba jinic Jesús? ¿Mach ba i yalobilic José? Cʌmbil lac cha'an i tat i ña'. ¿Bajche' mi' yʌl: “Tsa' jubiyon tilel ti panchan”? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jini cha'an Jesús tsi' jac'beyob: Cʌyʌx la' pejcan la' bʌ ti wulwul a'leya. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma'anic majch mi mejlel i tilel ba' añon, jini jach mu' bʌ i wersa pʌjyel tilel cha'an c Tat tsa' bʌ i chocoyon tilel. Joñon mi caj c tech ch'ojyel ti jini cojix bʌ q'uin mu' bʌ caj i tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ts'ijbubil ti' jun x'alt'añob: “Dios mi caj i cʌntesan pejtelel winicob x'ixicob”. Che'ʌch ts'ijbubil. Che' jini mi' tilelob ba' añon pejtel tsa' bʌ i yubibeyob i t'an c Tat, tsa' bʌ i ñopbeyob i cʌntesʌbal. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma'anic majch tsi' q'uele c Tat mi juntiquilic, jini jach jini ch'oyol bʌ ti Dios. Jini tsa'ix i q'uele c Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Isujm, isujm mic subeñetla, jini mu' bʌ i ñopon, anix i cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Joñon jini Wajon mu' bʌ cʌq'ueñetla la' cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","La' ñojte'el tsi' c'uxuyob maná ti jochol bʌ lum pero tsa' chʌmiyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yambʌyʌch jini Waj mu' bʌ i jubel tilel ti panchan cha'an mi' c'uxob winicob x'ixicob cha'an ma'anic mi' chʌmel majqui jach mi' c'ux. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Joñon cuxul bʌ Wajon tsa' bʌ jubiyon tilel ti panchan. Mi an majqui mi' c'ux jini Waj, chʌn cuxul ti pejtelel ora. Jini Waj mu' bʌ cʌc' jiñʌch c bʌc'tal mu' bʌ cʌc' cha'an i cuxtʌlel jini año' bʌ ti pañimil. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jini cha'an judíojob cʌlʌx jax tsi' pejcayob i bʌ. Tsi' yʌlʌyob: ¿Bajche' mi mejlel i yʌq'ueñonla i bʌc'tal cha'an mi laj c'ux? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús tsi' subeyob: Isujm, isujm mic subeñetla, mi ma'anic mi la' c'uxben i bʌc'tal i Yalobil Winic, mi ma'anic mi la' jap i ch'ich'el, ma'anic la' cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jini mu' bʌ i c'ux c bʌc'tal, mu' bʌ i jap c ch'ich'el anix i cuxtʌlel mach bʌ anic mi' jilel. Joñon mi caj c tech ch'ojyel ti jini cojix bʌ q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Come c bʌc'tal jiñʌch mero we'elʌl, c ch'ich'el jiñʌch mero japbil bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jini mu' bʌ i c'ux c bʌc'tal, mu' bʌ i jap c ch'ich'el, mi' yajñel ti joñon. Joñon ja'el mi cajñel ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Che' bajche' cuxul c Tat tsa' bʌ i chocoyon tilel, che' bajche' an j cuxtʌlel tic Tat, che' ja'el jini mu' bʌ i c'uxon mi caj i taj i cuxtʌlel ti joñon. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jiñʌch Waj tsa' bʌ jubi tilel ti panchan. Mach che'ic jini maná tsa' bʌ i c'uxuyob la' ñojte'el tsa' bʌ chʌmiyob. Jini mu' bʌ i c'uxob jini Waj mu' bʌ cʌq'ueñob, chʌn cuxul mi' yajñelob ti pejtelel ora, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Che'ʌch tsi' cha'le cʌntesa Jesús ti sinagoga ya' ti Capernaum. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Cabʌl xcʌnt'añob i cha'an, che' bʌ tsi' yubiyob jini t'an, tsi' yʌlʌyob: Leco i cʌntesʌbal. ¿Majqui mi mejlel i chʌn ubin? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yujil Jesús ti' bajñelil woliyob ti wulwul t'an xcʌnt'añob i cha'an cha'an i cʌntesa. Tsi' c'ajtibeyob: ¿Tile bixel jax ba la' pusic'al cha'an c t'an? ");
INSERT INTO ctuBl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Chuqui mi caj la' wʌl, che' jini, mi tsa' la' q'uele i Yalobil Winic che' mi' letsel majlel ya' ba' tsa' chumle ti ñaxan? ");
INSERT INTO ctuBl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jini Espíritu mi' yʌq'ueñonla laj cuxtʌlel. Lac bʌc'tal ma'anic chuqui mi' yʌq'ueñonla. Jini c t'an tsa' bʌ c subeyetla i cha'añʌch la' ch'ujlel. Mi' yʌq'ueñetla la' cuxtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lamitaletla ma'anic mi la' ñopon, che'en. Come c'ʌlʌl ti' cajibal yujil Jesús jini mach bʌ anic tsi' ñopoyob. Yujil majqui mi caj i yʌc' ti' c'ʌb i contra. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tsi' yʌlʌ: Jini cha'an tsac subeyetla, ma'anic majch mi mejlel i tilel ba' añon mi ma'anic tsa' aq'uenti i p'ʌtʌlel tic Tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Cabʌl xcʌnt'añob i cha'an tsa' caji i tʌts'ob i bʌ. Ma'anix tsi' chʌn cha'leyob xʌmbal yic'ot Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús tsi' c'ajtibeyob jini lajchʌntiquil: ¿Jatetla la' wom ba la' cʌyon ja'el? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro tsi' jac'ʌ: C Yum, ¿am ba yambʌ mu' bʌ mejlel i coltañon lojon? Ma'anic. Come jatet jach ma' sub jini t'an cha'an mic taj lojon j cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Mic ñopet lojon. Cujil lojon jatetʌch jini Ch'ujul bʌ tilem bʌ ti Dios, che'en Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús tsi' jac'be: ¿Mach ba tsa'ic c yajcayetla? Lajchʌntiquiletla. Juntiquil i cha'añʌch xiba, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús tsi' taja ti t'an Judas Iscariote, i yalobil Simón. Come jiñʌch Judas tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra. Jini Judas i pi'ʌlʌch jini junlujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ti wi'il Jesús tsa' caji ti xʌmbal ti Galilea. Tsi' cʌyʌ i xʌmbal ti Judea, come judíojob woli' ña'tañob i chuc cha'an mi' tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lʌc'ʌlix i yorajlel che' mi' melob q'uin judíojob che' mi' melob lejchempat tac. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jini cha'an i yijts'iñob Jesús tsi' subeyob: Loq'uen wʌ'i. Cucux ti Judea cha'an mi' q'uelob a melbal xcʌnt'añob a cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma'anic majch mi' cha'len i ye'tel ti mucul che' yom i yʌc' i bʌ ti cʌjñel. Mi wolix a mel ili e'tel, pʌsʌ a bʌ ti' wut jini año' bʌ ti pañimil, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Come i yijts'iñob ja'el ma'anic tsi' ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús tsi' subeyob: Maxto c'otemic i yorajlel cha'an mic majlel. Jatetla ti pejtelel ora mi la' mel bajche' jach la' wom. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Winicob x'ixicob i cha'año bʌ pañimil mach mejlic i ts'a'leñetla. Mi' ts'a'leñoñob come mic tsictesʌbeñob jontol bʌ i melbal. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jatetla cucuxla ti letsel ba' woli' melob q'uin. Joñon maxto anic mic letsel majlel come maxto i yorajlelic, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Che' bʌ tsa' ujti i yʌl jini t'an, tsa' cʌle Jesús ti Galilea. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Che' majlemobix i yijts'iñob, tsa' letsi majlel Jesús ja'el ba' woli' melob q'uin. Mucul jach tsa' majli. Ma'anic tsi' pʌsʌ i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judíojob tsi' sajcayob Jesús ba' woli' melob q'uin. Tsi' c'ajtibeyob i bʌ: ¿Baqui an jini Jesús? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Cabʌl tsi' cha'leyob wulwul t'an cha'an Jesús, come cabʌl tsi' yʌlʌyob: Uts'at i pusic'al, che'ob. Yaño' bʌ tsi' yʌlʌyob: Mach uts'atic, come woli' soc winicob x'ixicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mucul jach tsi' tajayob ti t'an Jesús come tsi' bʌc'ñayob judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Che' ojlil to jini q'uiñijel, tsa' letsi majlel Jesús ti Templo. Tsa' caji ti cʌntesa. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tsa' toj sajtiyob i pusic'al judíojob. Tsi' yʌlʌyob: ¿Bajche' tsi' ñopo jun jini winic che' mach cabʌlic tsa' cʌntesʌnti? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús tsi' jac'beyob: Jini j cʌntesʌbal mach c cha'anic. I cha'añʌch c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Majqui jach yom i mel chuqui yom c Tat, mi caj i ña'tan mi ch'oyol j cʌntesʌbal ti Dios, o mi ch'oyol tic bajñel pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jini mu' bʌ i cha'len t'an ch'oyol bʌ ti' bajñel pusic'al mi' sʌclan i bajñel ñuclel. Jini mu' bʌ i tsictesan i ñuclel c Tat tsa' bʌ i chocoyon tilel, jiñʌch isujm bʌ. Ma'anic chuqui mach tojic ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Mach ba anic tsi' yʌq'ueyetla mandar Moisés? Pero ma'anic mi la' jac' jini mandar mi juntiquileticla. ¿Chucoch la' wom la' tsʌnsañon? Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tsi' jac'beyob: An a xibʌjlel. ¿Majqui yom i tsʌnsañet? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús tsi' yʌlʌ: Tsa'ix c cha'le junchajp que'tel. Mi' toj sajtel la' pusic'al ti la' pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Isujm, Moisés tsi' yʌq'ueyetla tsep pʌchʌlel. Mach ch'oyolic ti Moisés, ch'oyol ti la' ñojte'el. Mi la' wʌc' tsep pʌchʌlel ti' q'uiñilel c'aj o. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mi uts'at mi' tsepbentel i pʌchʌlel winic ti' q'uiñilel c'aj o cha'an ma'anic mi' ñusʌntel i mandar Moisés, ¿chucoch mi la' mich'leñon cha'an tsac lajmesa winic ti pejtelel i chʌmel ti' q'uiñilel c'aj o? ");
INSERT INTO ctuBl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mach mi la' lon ña'tan woli la' cʌmbeñob i pusic'al la' pi'ʌlob cha'an chuqui jach mi la' q'uel. Ña'tanla ti toj chuqui mi la' ña'tan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ya' añob ti Jerusalén winicob tsa' bʌ i yʌlʌyob: ¿Mach ba jinic Jesús? ¿Mach ba yomobic i tsʌnsan Jesús jini judíojob? ");
INSERT INTO ctuBl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Awilan, ya' woli ti t'an Jesús ti' wut pejtelel winicob. Ma'anic chuqui mi' subeñob. Tic'ʌl woli' yʌlob jini yumʌlob jiñʌch Cristo ti isujm. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero la cujil baqui ch'oyol jini winic. Che' mi' tilel jini mero Cristo ma'anic majqui yujil baqui ch'oyol, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","C'am tsa' caji ti t'an Jesús ti Templo. Tsi' cha'le cʌntesa. Tsi' yʌlʌ: Mi woli la' cʌñon, la' wujil ja'el baqui ch'oyolon. Ma'anic tsac bajñel ña'ta tilel. Jini tsa' bʌ i chocoyon tilel isujm Diosʌch. Pero ma'anic mi la' cʌn. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Joñon mij cʌn come ch'oyolon ya' ba'an. Tsi' chocoyon tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jini cha'an tsi' ña'tayob i ñup' Jesús. Ma'anic majch tsi' chucu come maxto c'otemic i yorajlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Cabʌl winicob x'ixicob tsi' ñopoyob. Tsi' yʌlʌyob: Jini mero Cristo mu' bʌ i tilel, ¿mejl ba i pʌs ñumen ñuc bʌ i yejtal i p'ʌtʌlel bajche' tsi' pʌsʌ Jesús? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseojob tsi' yubiyob jini t'an tsa' bʌ i yʌlʌyob winicob. Jini cha'an jini ñuc bʌ motomajob yic'ot fariseojob tsi' chocoyob tilel i winicob cha'an mi' ñup'ob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús tsi' yʌlʌ: Jumuc' jax wʌ' añon la' wic'ot. Mic cha' majlel ya' ba'an jini tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mi caj la' sajcañon, ma'anic mi caj la' tajon. Ya' ba' mic majlel, ma'anic mi mejlel la' c'otel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jini cha'an jini judíojob tsi' subeyob i bʌ: ¿Baqui sami jini winic ba' ma'anic mi caj lac taj, mi' yʌl? ¿Mu' ba caj i majlel ba'an lac pi'ʌlob ti' lumal griegojob cha'an mi' cʌntesan griegojob? ");
INSERT INTO ctuBl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Chuqui i sujmlel jini t'an tsa' bʌ i yʌlʌ Jesús?: “Mi caj la' sʌclañon, ma'anic mi caj la' tajon. Ya' ba' mic majlel, ma'anic mi mejlel la' c'otel”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Che' ti' xojt'ibal q'uin, ti jini ñuc bʌ q'uin, Jesús tsa' wa'le. C'am tsi' cha'le t'an. Tsi' yʌlʌ: Mi an majqui an i tiquin ti', la' ba' añon, la' i jap. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jini mu' bʌ i ñopon, che' bajche' mi' yʌl i Ts'ijbujel Dios, on mi' caj ti wʌjlel loq'uel cuxul bʌ ja' ti' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Jini ja' jiñʌch jini Espíritu mu' bʌ caj i yʌq'uentelob jini mu' bʌ i ñopob, come maxto anic tsa' aq'uentiyob Ch'ujul bʌ Espíritu, come maxto anic tsa' aq'uenti i ñuclel Jesús.) ");
INSERT INTO ctuBl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cabʌl winicob che' bʌ tsi' yubibeyob i t'an, tsi' yʌlʌyob: Isujm, jiñʌch jini x'alt'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yaño' bʌ tsi' yʌlʌyob: Jiñʌch jini Cristo, jini Yajcʌbil bʌ, che'ob. Yaño' bʌ tsi' yʌlʌyob: ¿Ch'oyol ba jini Cristo ti Galilea? ");
INSERT INTO ctuBl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Mach ba anic tsi' yʌlʌ i Ts'ijbujel Dios tal jini Cristo ti' p'olbal David ya' ti Belén, jini tejclum ba' tsa' ajni David? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Che' jini, cha'chajp tsa' cajiyob ti' t'an cha'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lamital yomob i chuc pero ma'anic majch tsi' chucu, mi juntiquilic. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jini xcʌntayajob i cha'an ñuc bʌ motomajob yic'ot fariseojob tsa' tiliyob ba'an i yumob. Jini yumʌlob tsi' c'ajtibeyob: ¿Chucoch ma'anic tsa' la' pʌyʌ tilel Jesús? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jini xcʌntayajob tsi' jac'beyob: Ma'anic winic ti pejtelel ora mu' bʌ i cha'len t'an che' bajche' jini winic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jini fariseojob tsi' subeyob: ¿Tsa' ba la' ñopo lot jatetla ja'el? ");
INSERT INTO ctuBl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Am ba juntiquil yumʌl mi juntiquil fariseo tsa' bʌ i ñopo Jesús? ");
INSERT INTO ctuBl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jini jach mi' ñopob Jesús jini winicob mach bʌ cʌntesʌbilobic ti mandar. Chocbilobix ti Dios, che'ob fariseojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Juntiquil yumʌl i c'aba' Nicodemo, jiñʌch tsajni bʌ i pejcan Jesús ti ac'ʌlel, tsa' caji i subeñob: ");
INSERT INTO ctuBl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿Chuqui mi' yʌl jini mandar? ¿Mejl ba mi lac sub mi an i mul winic, che' maxto ubibilic i t'an jini winic, che' maxto ña'tʌbilic chuqui tsi' cha'le? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jini fariseojob tsi' c'ajtibeyob: ¿Jatet ch'oyolet ba ti Galilea ja'el? Q'uele ti uts'at jini ts'ijbubil bʌ. Ma'anic x'alt'an ch'oyol bʌ ti Galilea, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Tsa' sujtiyob ti' yotot tac ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús tsa' majli ti Olivo wits. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ti sʌc'ajel tsa' cha' majli ti Templo. Pejtelel winicob x'ixicob tsa' tiliyob ba'an. Tsa' buchle Jesús. Tsa' caji i cʌntesañob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jini sts'ijbayajob yic'ot fariseojob tsi' pʌyʌyob tilel juntiquil x'ixic tsa' bʌ tajle ti' ts'i'lel. Tsi' yʌc'ʌyob jini x'ixic ti ojlil ba' añob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tsi' subeyob: Maestro, jini x'ixic tsa' tajle ti mulil che' woli' mel i ts'i'lel. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés tsi' subeyonla ti mandar cha'an mi lac jul ti xajlel juntiquil am bʌ i mul che' bajche' jini. ¿Bajche' ma' wʌl jatet? ");
INSERT INTO ctuBl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Che'i tsi' cha'leyob t'an cha'an mi' q'uelob bajche' mi caj i jac' Jesús cha'an mi' tajbeñob i mul. Jesús tsa' wutsle ti lum. Tsa' caji i ts'ijban lum ti' yal i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Che' bʌ tsi' chʌn c'ajtibeyob Jesús jini winicob, tsa' wa'le Jesús. Tsi' subeyob: Jini mach bʌ anic i mul, la' i ñaxan jul ti xajlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tsa' cha' wutsle Jesús. Tsa' cha' caji i ts'ijban lum ti' yal i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Che' bʌ tsi' yubibeyob i t'an Jesús, tsa' loq'uiyob majlel ti jujuntiquil, ñaxan jini ñoxobix bʌ, ti wi'il jini ch'iton winicob jinto tsa' laj majliyob. Jesús tsa' cʌle ti' bajñel yic'ot jini x'ixic tsa' bʌ wa'le ti ojlil. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesús tsa' cha' wa'le. Che' bʌ tsi' q'uele i bajñel ya'an jini x'ixic, tsi' c'ajtibe: X'ixic, ¿baqui an jini tsa' bʌ i subuyob a mul? ¿Mach ba anic majch yom i julet cha'an a mul? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jini x'ixic tsi' sube: C Yum, ma'anic mi juntiquilic, che'en. Jesús tsi' sube: Joñon ja'el ma'anic mic julet cha'an a mul. Cucux. Mach ma' chʌn cha'len mulil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús tsi' cha' subeyob: Joñon i sʌclelon pañimil. Jini mu' bʌ i tsajcañon ma'anic mi' caj ti xʌmbal ti ic'ch'ipan bʌ pañimil. An i cha'an i sʌclel pañimil cha'an i cuxtʌlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jini fariseojob tsi' subeyob: Ti a bajñel t'an jach wola' sub a bʌ. Mach isujmic chuqui wola' wʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús tsi' jac'beyob: Anquese mic bajñel sub c bʌ, isujmʌch c t'an, come cujil baqui ch'oyolon, cujil baqui mic majlel. Jatetla mach la' wujilic baqui ch'oyolon, mi baqui mic majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jatetla mi la' to'ol ña'tʌbeñon c pusic'al cha'an chuqui jach mi la' q'uel. Joñon ma'anic majch mic to'ol ña'tʌben i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Che' mic ña'tʌbeñob i pusic'al winicob x'ixicob, mij cʌñob ti isujm, come mach tic bajñelic mic ña'tʌbeñob i pusic'al, come jump'ejl jach c pusic'al quic'ot c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ts'ijbubil ti la' mandar ja'el: “Isujmʌch jini t'an mu' bʌ i yʌlob cha'tiquilob”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Joñon mic sub c bʌ cha'an mi la' cʌñon. C Tat ja'el tsa' bʌ i chocoyon tilel mi' yʌc'on ti cʌjñel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tsi' c'ajtibeyob: ¿Baqui an a Tat? che'ob. Jesús tsi' jac'beyob: Ma'anic mi la' cʌñon. Ma'anic mi la' cʌn c Tat ja'el. Tsa'ic la' cʌñʌyon tsa' la' cʌñʌ c Tat ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús tsi' cha'le jini t'an ya' ba' mi' yotsañob taq'uin ti Templo. Tsi' cha'le cʌntesa ti Templo. Ma'anic majch tsi' chucu come maxto tilemic i yorajlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús tsi' cha' subeyob fariseojob: Mic majlel. Mi caj la' sʌclañon. Mi caj la' chʌmel che' añet to la ti la' mul. Ya' ba' mic majlel, mach mejliquetla ti majlel jatetla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judíojob tsa' caji' c'ajtibeñob i bʌ: ¿Mu' ba caj i tsʌnsan i bʌ? come mi' yʌl: “Baqui mic majlel mach mejliquetla ti majlel”. Che' mi' yʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús tsi' subeyob: Jatetla ch'oyoletla ti yebal. Joñon ch'oyolon ti chan. I cha'añetla jini pañimil. Joñon mach i cha'añonic jini pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jini cha'an mic subeñetla mi caj la' chʌmel che' añet to la ti la' mul. Mi ma'anic mi la' ñopon, mi caj la' chʌmel che' añet to la ti la' mul, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Judíojob tsi' c'ajtibeyob: ¿Majquiyet? che'ob. Jesús tsi' subeyob: Joñoñʌch jini mero tsa' bʌ c subeyetla ti ñaxan. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","An to cabʌl chuqui tac mi caj c subeñetla cha'an mic tsictesan la' melbal. Jini tsa' bʌ i chocoyon tilel isujm Diosʌch. Joñon mic subeñob ti pañimil chuqui tac tsi' subeyon c Tat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma'anic tsi' ch'ʌmbeyob isujm mi woli' taj ti t'an i Tat am bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jini cha'an Jesús tsi' subeyob: Che' bʌ tsa'ix la' letsa i Yalobil Winic, mi caj la' ch'ʌmben isujm majquiyon. Mi caj la' ch'ʌmben isujm ma'anic chuqui mic cha'len tic bajñelil. Chuqui tac tsi' cʌntesayon c Tat, jini jach mic sub. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Jini tsa' bʌ i chocoyon tilel an quic'ot. Ma'anic tsi' cʌyʌyon c Tat tic bajñelil come ti pejtelel ora mic mel chuqui tac mi' mulan, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Che' bʌ tsi' subu jini t'an cabʌl tsi' ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jini cha'an Jesús tsi' subeyob judíojob tsa' bʌ i ñopoyob: Mi ma'anic mi la' cʌy c t'an, mero xcʌnt'añetla c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mi caj la' cʌn i sujmlel c t'an. I sujmlel c t'an mi caj i yʌq'uetla ti colel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tsi' jac'beyob: I p'olbalon lojon Abraham. Ma'anic ba' tsa' chojñiyon lojon ti e'tel. ¿Chucoch ma' wʌl mi caj cʌjq'uel lojon ti colel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús tsi' jac'beyob: Isujm, isujm mic subeñetla, pejtelel mu' bʌ i cha'leñob mulil, chombilobix ti mulil. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jini winic chombilix bʌ ti e'tel mach ti pejtelic ora mi' yajñel ti' yotot i yum. Jini i yalobil yumʌl mi' yajñel ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Che' jini, mi tsi' yʌc'ʌyetla ti colel i Yalobil Dios, colbiletla ti isujm. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cujil i p'olbaletla Abraham. Anquese i p'olbaletla, woli la' ña'tan la' tsʌnsañon come ma'anic mi' yochel c t'an ti la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Joñon mic sub chuqui tac tsaj q'uele quic'ot c Tat. Jatetla mi la' cha'len chuqui tac tsa' la' wubi ti la' tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jini judíojob tsi' jac'beyob: C tat lojon jiñʌch Abraham, che'ob. Jesús tsi' subeyob: I yalobileticla Abraham, mux la' tsajcʌben i melbal Abraham. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Woli la' ña'tan la' tsʌnsañon, joñon tsa' bʌ c subeyetla chuqui isujm che' bajche' tsi' subeyon Dios. Mach che'ic tsi' mele Abraham. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mi la' cha'len i melbal la' tat, che'en Jesús. Jini judíojob tsa' caji i subeñob: Joñon lojon mach lajalonic lojon bajche' jini tsa' bʌ i yilayob pañimil cha'an ti' ts'i'lel winicob. Juntiquil jach c tat lojon, jiñʌch Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús tsi' subeyob: La' tatic Dios, mux la' c'uxbiñon. Come ch'oyolon ti Dios. Ma'anic tsa' tiliyon tic bajñel pusic'al. Dios tsi' chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chucoch ma'anic mi la' ch'ʌmben isujm c t'an? Cha'an mach la' womic la' wubin c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Jatetla i cha'añetla xiba. Jiñʌch la' tat. La' wom la' mel chuqui yom la' tat. Stsʌnsayajʌch jini xiba c'ʌlʌl ti' cajibal. Ma'anic tsa' chʌn ajni ti' sujmlel Dios, come ma'anic chuqui isujm ti' pusic'al xiba. Che' mi' cha'len lot i tilelʌch come xlot. Ya' ch'oyol ti xiba pejtelel lot. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Joñon mic subeñetla chuqui isujm. Jini cha'an ma'anic mi la' ñopon. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Am ba juntiquil mu' bʌ mejlel i sub an c mul? ¿Chucoch ma'anic mi la' ñopon mi tsac subeyetla chuqui isujm? ");
INSERT INTO ctuBl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jini i cha'an bʌ Dios mi' yubiben i t'an Dios. Jini cha'an ma'anic mi la' wubin come mach i cha'añeticla Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jini judíojob tsi' jac'beyob: ¿Mach ba isujmic tsa' bʌ c subu lojon, samaritanojet? An a xibʌjlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús tsi' jac'beyob: Ma'anic c xibʌjlel. Joñon mic sub i ñuclel c Tat. Jatetla ts'a' mi la' q'uelon. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma'anic mic bajñel sʌclan c ñuclel. An juntiquil mu' bʌ i yʌq'ueñon c ñuclel, mu' bʌ caj i tsictesan. Jini mi' ña'tan ñucon. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Isujm, isujm mic subeñetla, mi an majqui mi' ch'ujbibeñon c t'an, ma'anic mi' caj ti chʌmel ti pejtelel ora, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jini judíojob tsi' subeyob: Wʌle cujilix lojon an a xibʌjlel. Abraham tsa' chʌmi, che' ja'el x'alt'añob. Jatet wola' wʌl mi an majqui mi' ch'ujbibeñet a t'an, ma'anic mi' caj ti chʌmel ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ñumen ñuquet ba bajche' lac tat Abraham tsa' bʌ chʌmi, yic'ot x'alt'añob ja'el tsa' bʌ chʌmiyob? ¿Majquiyet ma' wʌl? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús tsi' jac'beyob: Mi tsac bajñel subu c bʌ ti ñuc, ma'anic c ñuclel. C Tat mi' tsictesan c ñuclel. Jiñʌch c Tat mu' bʌ la' pejcan ti la' Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mach cʌmbilic la' cha'an. Joñon mij cʌn. Mi tsac subeyetla ma'anic mij cʌn Dios, che'ic jini xloton, lajalon jach bajche'etla. Joñon mij cʌn Dios. Mic jac'ben i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tijicña la' tat Abraham che' bʌ tsi' ña'ta j q'uiñilel ti pañimil. Abraham tsi' ch'ʌmbe isujm. Tijicña tsi' yubi, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jini judíojob tsi' subeyob: Maxto anic lujump'ejl i yuxc'al (50) a jabilel. ¿Tsa' ba a q'uele Abraham? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús tsi' subeyob: Isujm, isujm mic subeñetla, che' maxto anic Abraham añoñix, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jini cha'an tsi' lotoyob xajlel cha'an mi' julob. Jesús tsi' mʌcʌ i bʌ. Tsa' loq'ui ti Templo. Che' bʌ tsa' ñumi ti ojlil ba' añob tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Che' bʌ tsa' majli Jesús tsi' q'uele winic. Xpots' jini winic c'ʌlʌl che' bʌ tsi' yila pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jini xcʌnt'añob i cha'añob tsi' c'ajtibeyob: Maestro, ¿chucoch xpots' jini winic che' bʌ tsi' yila pañimil? ¿Majqui tsi' cha'le mulil? ¿Jim ba jini winic? ¿Jim ba i tat i ña'? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús tsi' jac'beyob: Ma'anic tsi' cha'le mulil jini winic, mi i tat, mi i ña'. Xpots'ʌch cha'an mi' tsictiyel i ye'tel Dios ti' bʌc'tal. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Wersa mic cha'len i ye'tel jini tsa' bʌ i chocoyon tilel che' q'uiñil to, come tal ac'ʌlel che' ma'anic majch mi mejlel i cha'len e'tel. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Che' wʌ'to añon ti pañimil i sʌclelon pañimil cha'an mi' q'uelob jini año' bʌ ti pañimil, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Che' bʌ tsa' ujti i sub jini t'an, tsi' tujba lum. Tsi' mele oc'ol yic'ot i tujb. Tsi' bombe i wut xpots' ti jini oc'ol. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Tsi' sube: Cucu poco a wut ti ts'ʌmibʌl i c'aba' Siloé, che'en. (Jini Siloé mi' yʌl ti lac t'an, chocbil majlel.) Jini cha'an tsa' majli xpots'. Tsi' poco i wut. Che' c'otemix i wut tsa' cha' tili. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","I pi'ʌlob ti chumtʌl yic'ot jini tsa' bʌ i cʌñʌyob che' xpots' to tsa' caji i yʌlob: ¿Mach ba jinic tsa' bʌ i c'ajti taq'uin ya' ba' buchul? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lamital tsi' yʌlʌyob: Jincuyi, che'ob. Yaño' bʌ tsi' yʌlʌyob: Mach jiniqui pero ts'ita' lajal i wut yic'ot, che'ob. Jini xpots' tsi' subeyob: Joñoñʌch, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jini cha'an jini winicob tsi' c'ajtibeyob: ¿Bajche' tsa' cajni a wut? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tsi' jac'beyob: Juntiquil winic i c'aba' Jesús tsi' mele oc'ol. Tsi' bombeyon tic wut. Tsi' subeyon majlel cha'an mic poc ti ts'ʌmibʌl i c'aba' Siloé. Tsa'ix majli c poc c wut. Wʌle cañalix, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tsi' c'ajtibeyob: ¿Baqui an jini winic? che'ob. Tsi' subeyob: Mach cujilic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tsi' pʌyʌyob majlel ba'an fariseojob jini mach bʌ anic tsa' c'oti i wut ti yambʌ ora. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","I q'uiñilelʌch c'aj o che' bʌ tsi' mele oc'ol Jesús, che' bʌ tsi' cambe i wut jini xpots'. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jini fariseojob tsi' cha' c'ajtibeyob jini xpots' bajche' tsa' c'oti i wut. Jini xpots' tsi' subeyob: Tsi' bombeyon c wut ti oc'ol. Tsac poco. Wʌle mi' c'otel c wut, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jini cha'an jini fariseojob tsi' yʌlʌyob: Jini Jesús mach chocbilic tilel ti Dios, come ma'anic mi' ch'ujbin i q'uiñilel c'aj o, che'ob. Yaño' bʌ tsi' yʌlʌyob: Anic i mul Jesús, ¿mejl ba i pʌs i yejtal i p'ʌtʌlel che' bajche' mi' pʌs? che'ob. Cha'chajp tsi' cha'leyob t'an jini winicob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tsi' cha' subeyob xpots': ¿Chuqui ma' wʌl jatet? ¿Majqui jini tsa' bʌ i cambeyet a wut? che'ob. Jini xpots' tsi' subu: Jiñʌch x'alt'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jini judíojob ma'anic tsi' ñopoyob mi xpots'ʌch che' bʌ tsa' tili Jesús i camben i wut jinto tsi' pʌyʌyob tilel i tat i ña' jini winic tsa' bʌ c'oti i wut. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tsi' c'ajtibeyob: ¿Jim ba la' walobil, xpots' bʌ tsi' yila pañimil? ¿Bajche' tsa' cajni i wut? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","I tat i ña' tsi' subeyob: Cujil lojon jiñʌch calobil xpots' bʌ tsi' yila pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mach cujilic lojon bajche' tsa' caji ti c'otel i wut. Mach cujilic lojon majqui tsi' cambe i wut. Winiquix calobil. C'ajtibenla. Mi mejlel i bajñel sub, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Che'i tsi' cha'leyob t'an i tat i ña' come tsi' bʌc'ñayob judíojob. Come jini judíojob tsi' yʌlʌyob wersa mi' chojquelob loq'uel winicob x'ixicob ti sinagoga mi tsi' subuyob Cristojʌch jini Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jini cha'an tsi' yʌlʌyob i tat i ña': “Winiquix. C'ajtibenla”. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jini cha'an jini judíojob tsi' cha' pʌyʌyob tilel jini mach bʌ anic tsa' c'oti i wut ti yambʌ ora. Tsi' subeyob: Subu i ñuclel Dios. Cujil lojon xmulilʌch jini Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jini winic tsi' subeyob: Mach cujilic mi xmulil. Cujil ti isujm xpots'on ti yambʌ ora, wʌle c'otemix c wut, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tsi' cha' c'ajtibeyob: ¿Chuqui tsi' tumbeyet? ¿Bajche' tsi' cambeyet a wut? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jini winic tsi' jac'beyob: Tsa'ix c subeyetla. Ma'anic tsa' la' wubi. ¿Chococh la' wom la' cha' ubin? ¿La' wom ba la' sutq'uin la' bʌ ti xcʌnt'an i cha'an ja'el? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tsa' caji i wajleñob. Tsi' subeyob: Jatet xcʌnt'añet i cha'an. Joñon lojon xcʌnt'añon lojon i cha'an Moisés. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Cujil lojon, Dios tsi' pejca Moisés. Mach cujilic lojon baqui ch'oyol jini Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jini winic tsi' jac'beyob: ¿Bajche' isujm jini? ¿Chucoch mach la' wujilic baqui ch'oyol Jesús? Come jini tsi' cambeyon c wut. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","La cujil ma'anic mi' yubiben i t'an xmulilob Dios. Mi an winic mu' bʌ i bʌc'nan Dios, mu' bʌ i cha'len chuqui yom Dios, Dios mi' yubiben i t'an jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","C'ʌlʌl ti' cajibal pañimil ma'anic majch tsa' mejli i camben i wut xpots' che' xpots' tsi' yila pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Machic chocbil tilel ti Dios jini winic, ma'anic chuqui mi mejlel i mel. Che' tsi' yʌlʌ jini tsa' bʌ c'oti i wut. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jini judíojob tsi' jac'beyob: Jatet cabʌl jax a mul tsa' wila pañimil. ¿Mu' ba a cʌntesañon lojon? che'ob. Tsi' chocoyob loq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tsi' yubi Jesús chocbilix loq'uel jini winic. Tsa' majli i taj. Tsi' sube: ¿Mu' ba a ñop i Yalobil Dios? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jini winic tsi' yʌlʌ: Maestro, ¿majqui jini, cha'an mic ñop? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús tsi' sube: Tsa'ix a q'uele. Jiñʌch woli bʌ i pejcañet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jini winic tsi' yʌlʌ: Mic ñopet, c Yum, che'en. Tsi' ch'ujutesa Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús tsi' sube: Tsa' tiliyon ti melojel ti pañimil cha'an mi' c'otelob i wut jini mach bʌ weñobic i wut, yic'ot cha'an mi' yochelob ti xpots' jini weño' bʌ i wut, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ya' añob fariseojob yic'ot Jesús. Tsi' yubibeyob i t'an. Tsi' subeyob: ¿Xpots'on ba lojon ja'el? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús tsi' subeyob: Xpots'eticla, ma'anic la' mul. Pero mi la' lon al woli' c'otel la' wut. Jini cha'an chʌn an la' mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Isujm, isujm mic subeñetla: Jini mach bʌ anic mi' yochel ti' ti' corral ba'an tiñʌme', jini mu' bʌ i letsel ochel ti pam corral jiñʌch xujch', jiñʌch xchiloñel. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jini mu' bʌ i yochel ti' ti' corral jiñʌch xcʌnta tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jini xcʌnta corral mi' jamben jini xcʌnta tiñʌme'. Jini tiñʌme' mi' yubiben i t'an i yaj cʌntaya. Mi' pejcan i tiñʌme' ti' c'aba'. Mi' pʌy loq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Che' mi' yujtel i pʌy loq'uel mi' majlel ti ñaxan. Jini tiñʌme' mi' tsajcan jini xcʌnta tiñʌme' come mi' cʌmben i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma'anic mi' tsajcan yambʌ winic. Mi' puts'tan, come ma'anic mi' cʌmben i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Che' tsi' cha'le t'an Jesús ti lajiya. Jini fariseojob ma'anic tsi' ch'ʌmbeyob isujm i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jini cha'an Jesús tsi' cha' subeyob: Isujm, isujm mic subeñetla: Joñon i Ti'on ba' mi' yochel tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pejtelel tsa' bʌ tiliyob ti ñaxan xujch'ob, xchiloñelob. Jini tiñʌme' ma'anic tsi' jac'beyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Joñon i Ti'on ba' mi' yochel tiñʌme'. Jini mu' bʌ i yochel ti joñon mi caj i coltʌntel. Mi' caj ti ochel. Mi' caj ti loq'uel. Mi caj i taj wen bʌ jam. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mi' tilel xujch' cha'an mi' xujch'in. Mi' tilel i tsʌnsan. Mi' tilel i jisan. Joñon tsa' tiliyon cha'an mi' tajob i cuxtʌlel, cha'an on mi' tajob pejtelel chuqui wen. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Joñon jini wen bʌ Xcʌnta tiñʌme'on. Jini wen bʌ Xcʌnta tiñʌme' mi' yʌc' i bʌ ti chʌmel cha'an i tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jini mu' bʌ i cʌntan tiñʌme' cha'an ganar mach i yumic tiñʌme'. Ma'anic mi' cʌntan. Che' mi' q'uel bʌte'el ts'i' mu' bʌ i tilel, mi' cʌy tiñʌme', mi' cha'len puts'el. Jini bʌte'el ts'i' mi' chuc. Mi' pam puc. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jini mu' bʌ i cha'len ganar mi' puts'el come woli jach ti ganar. Ma'anic mi' c'uxbin tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Joñon jini wen bʌ Xcʌnta tiñʌme'on. Mij cʌn c tiñʌme'. C tiñʌme' mi' cʌñon. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Che' ja'el mi' cʌñon c Tat. Mij cʌn c Tat. Mi cʌc' c bʌ ti chʌmel cha'an jini tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Anto yambʌ c tiñʌme' mach bʌ ochemic ti jini corral. Wersa mic pʌy tilel ja'el. Mi caj i yubin c t'an. Junmojt jach mi caj i lu' ajñelob yic'ot juntiquil Xcʌnta tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jini cha'an c Tat mi' c'uxbiñon come mi cʌc' c bʌ ti chʌmel cha'an mic cha' cuxtiyel. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma'anic majch mi' yʌc'on ti chʌmel. Mic bajñel ac' c bʌ ti chʌmel. An c p'ʌtʌlel cha'an mi cʌc' c bʌ, an ja'el c p'ʌtʌlel cha'an mic cha' cuxtiyel. Jiñʌch que'tel tsa' bʌ aq'uentiyon cha'an c Tat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Cha'chajp tsa' cha' cajiyob ti t'an cha'an i t'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Cabʌl winicob tsi' yʌlʌyob: An i xibʌjlel. Sojquem i jol. ¿Chucoch mi la' chʌn ubin? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yaño' bʌ tsi' yʌlʌyob: Mach che'ic mi' cha'len t'an winic am bʌ i xibʌjlel. ¿Mejl ba i camben i wut xpots' jini xiba? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Woli' melob i q'uiñilel Templo ya' ti Jerusalén. I yorajlelix tsʌñal. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús tsa' ñumi ti Templo. Tsa' tili ti corredor i melbal bʌ Salomón. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jini judíojob tsi' joyoyob Jesús. Tsi' c'ajtibeyob: ¿Jayp'ejl to ora mi caj la wʌc'on lojon ti tsic pusic'al? Mi Cristojet, jini Yajcʌbil bʌ, subeñon lojon ti jamʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús tsi' jac'beyob: Tsa'ix c subeyetla. Ma'anic mi la' ñop. Que'tel mu' bʌ c cha'len ti' c'aba' c Tat mi' yʌc'on ti cʌjñel cha'an mi la' ña'tan majquiyon. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ma'anic mi la' ñop, come jatetla mach c tiñʌme'eticla che' bajche' tsac subeyetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","C tiñʌme'ob mi' yubibeñon c t'an. Joñon mij cʌñob. Mi' tsajcañoñob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi cʌq'ueñob i cuxtʌlel mach bʌ anic mi' jilel. Ma'anic mi caj i jilelob ti pejtelel ora. Ma'anic majch mi caj i chilbeñoñob tij c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ma'anic majch ñumen ñuc bajche' c Tat tsa' bʌ i yʌq'ueyoñob. Ma'anic majch mi mejlel i chil c tiñʌme' ti' c'ʌb c Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Joñon quic'ot c Tat junlajalon lojon, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jini cha'an jini judíojob tsi' cha' lotoyob xajlel cha'an mi' julob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús tsi' subeyob: Tsac pʌsbeyetla cabʌl wen bʌ c melbal ch'oyol bʌ tic Tat. ¿Cha'an ba jini wen bʌ c melbal la' wom la' julon? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jini judíojob tsi' jac'beyob: Ma'anic mic julet lojon ti xajlel cha'an wen bʌ a melbal, pero cha'an tsa' cha'le p'ajoñel. Come ma' cuy a bʌ ti Dios che' winiquet jach, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús tsi' subeyob: ¿Mach ba ts'ijbubilic ti la' mandar: “Tsac subu: Jatetla diosetla”? ");
INSERT INTO ctuBl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dios tsi' pejca ti diosob jini winicob tsa' bʌ i yubibeyob i t'an Dios. Melelʌch mach mejlic ti jejmel i Ts'ijbujel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mi che'ʌch tsi' pejca winicob Dios, ¿chucoch, che' jini, mi la' wʌl tsac cha'le p'ajoñel cha'an tsac subeyetla i Yalobilon Dios? Chocbilon tilel i cha'an c Tat. Tsi' yajcayon. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mi ma'anic mic melben i ye'tel c Tat, mach mi la' ñopon. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mi wolic melben i ye'tel c Tat, anquese ma'anic mi la' ñopon, ñopola que'tel cha'an mi la' cʌñon, cha'an mi la' ña'tan ti isujm c Tat an ti joñon, joñon añon tic Tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jini judíojob tsi' cha' ñopoyob i chuc, pero tsa' puts'i loq'uel ti' tojlelob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tsa' cha' majli ti junwejl Jordán ja' ba' tsa' caji i yʌc' ch'ʌmja' Juan. Tsa' jale Jesús ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cabʌl winicob x'ixicob tsa' tiliyob ba'an. Tsi' yʌlʌyob: Isujm ma'anic tsi' pʌsʌ i yejtal i p'ʌtʌlel Juan mi junyajlic. Pejtelel chuqui tac tsi' subu Juan cha'an Jesús puro isujm, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Cabʌl tsi' ñopoyob Jesús ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","C'am juntiquil winic i c'aba' Lázaro. Ya'an ti Betania, ti' tejclum María yic'ot Marta, i chich María. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Jiñʌch María tsa' bʌ i boño lac Yum ti perfume, tsa' bʌ i sujcube i yoc ti' tsutsel i jol. C'am i yʌscun.) ");
INSERT INTO ctuBl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jini cha'an i yijti'añob Lázaro tsi' chocoyob majlel winic ba'an Jesús. Tsi' subeyob: C Yum awilan, c'am jini mu' bʌ a c'uxbin, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Che' bʌ tsi' yubi Jesús, tsi' yʌlʌ: Tsa' c'am'a cha'an mi' tsictiyel i ñuclel Dios, mach cha'anic mi' chʌmel. Cha'añʌch mi' tsictiyel i ñuclel i Yalobil Dios ti' c'amʌjel Lázaro, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús tsi' c'uxbi Marta yic'ot i yijts'in yic'ot Lázaro. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Che' bʌ tsi' yubi c'am Lázaro, tsa' to jale Jesús yambʌ cha'p'ejl q'uin ya' ba'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ti wi'il Jesús tsi' sube xcʌnt'añob: Cha' conla ya' ti Judea, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jini xcʌnt'añob tsi' subeyob: Maestro, maxto jali tsi' ñopo i juletob ti xajlel. ¿Mu' ba a cha' majlel ya'i? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús tsi' jac'beyob: ¿Mach ba anic lajchʌmp'ejl ora ti jump'ejl q'uin? Jini mu' bʌ i cha'len xʌmbal ti q'uiñil ma'anic mi' yajlel, come mi' q'uel i sʌclel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jini mu' bʌ i cha'len xʌmbal ti ac'ʌlel mi' yajlel, come ma'anic woli' yajñel ti' sʌclel pañimil, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Che' bʌ tsa' ujti i sub jini t'an tsi' subeyob: Wʌyʌlix lac pi'ʌl Lázaro. Mic majlel c ñijcan cha'an mi' ch'oyjel ti wʌyel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jini xcʌnt'añob i cha'an tsi' subeyob: C Yum, mi wʌyʌlix mi' caj ti lajmel i chʌmel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús tsi' cha'le lajiya che' bʌ tsi' yʌlʌ wʌyʌl Lázaro che' chʌmenix. Jini xcʌnt'añob tsi' lon ña'tayob ti' pusic'al wolix i c'aj i yo Lázaro ti wʌyel. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jini cha'an Jesús tsi' subeyob ti toj cha'an mi' ch'ʌmbeñob isujm: Chʌmenix Lázaro, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tijicñayon cha'an mach ya'ic añon, come che' jini mi caj la' ñop. Conixla ya' ba'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás, mu' bʌ i pejcʌntel ti xloj cha'an i pi'ʌlob, tsa' caji i subeñob: Conla ja'el cha'an mi lac chʌmel yic'ot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Che' bʌ tsa' c'oti Jesús, tsi' subeyob chʌmp'ejlix q'uin mucul Lázaro. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lʌc'ʌl Betania ti Jerusalén, che' bajche' jump'ejl legua. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","An cabʌl judíojob tsa' bʌ tiliyob ba'an Marta yic'ot María cha'an mi' ñuq'uesʌbeñob i pusic'al che' chʌmenix Lázaro. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Che' bʌ tsi' yubi Marta woli' tilel Jesús, tsa' loq'ui majlel i taj. Buchul tsa' cʌle María ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta tsi' sube Jesús: C Yum, wʌ'ic añet ma'anic tsa' chʌmi cʌscun. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero cujil mi caj i yʌq'ueñet Dios pejtelel mu' bʌ a c'ajtiben, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús tsi' sube: Mi caj i cha' ch'ojyel a wʌscun, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta tsi' sube: Cujil mi caj i cha' ch'ojyel ti jini cojix bʌ q'uin, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús tsi' sube: Joñon Xtech Ch'ujlelʌlon, i cuxtʌlelon jini año' bʌ ti pañimil. Jini mu' bʌ i ñopon, anquese mi' chʌmel, mi caj i cha' cuxtiyel. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pejtelel año' bʌ i cuxtʌlel mu' bʌ i ñopoñob, ma'anic mi' cajelob ti chʌmel ti pejtelel ora. ¿Mu' ba a ñop jini? che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta tsi' sube: Mu' cu, c Yum. Tsa'ix c ñopo Cristojet, i Yalobilet Dios tsa' bʌ tiliyet ti pañimil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tsa' ujti ti t'an Marta, tsa' majli. Tsi' mucul pʌyʌ majlel María i yijts'in. Tsi' sube: Wʌ'an lac Maestro. Woli' pʌyet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Che' bʌ tsi' yubi María, tsa' ch'ojyi ti ora. Tsa' majli ba'an Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Maxto ochemic Jesús ti tejclum. Ya'to an ba' tsi' taja Marta. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jini judíojob woli bʌ i ñuq'uesʌbeñob i pusic'al María ya' ti' yotot tsi' q'ueleyob che' bʌ tsa' bʌc' ch'ojyi María, che' bʌ tsa' loq'ui majlel. Tsa' caji i tsajcañob majlel come tsi' yʌlʌyob: Mi' caj ti uq'uel ya' ti mucoñibʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María tsa' c'oti ba'an Jesús. Che' bʌ tsi' q'uele, tsi' ñocchoco i bʌ ti' tojel Jesús. Tsi' sube: C Yum, wʌ'ic añet ma'anic tsa' chʌmi cʌscun, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús tsi' q'uele woli ti uq'uel María, woliyob ti uq'uel judíojob ja'el tsa' bʌ tiliyob yic'ot. Tsi' p'unta ti' pusic'al. Tsi' mele i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesús tsi' c'ajtibeyob: ¿Baqui tsa' la' wʌc'ʌ? che'en. Tsi' subeyob: C Yum, la' q'uele, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tsi' cha'le uq'uel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jini judíojob tsi' yʌlʌyob: La' wilan c'uxatax tsi' yubi, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lamital tsi' yʌlʌyob: Jini tsa' bʌ i cambe i wut xpots', ¿mach ba anic tsa' mejli i coltan Lázaro cha'an ma'anic mi' chʌmel? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús tsi' cha' mele i pusic'al. Tsa' tili ti mucoñibʌl. Ch'en jini mucoñibʌl. An jump'ejl xajlel ñʌcʌl ti' ti'. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús tsi' yʌlʌ: Loc'sanla jini xajlel, che'en. Marta, i yijti'an jini tsa' bʌ chʌmi tsi' sube: C Yum, tuwix, come chʌmp'ejlix q'uin mucul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús tsi' sube: ¿Mach ba anic tsac subeyet mu' to caj a q'uel i ñuclel Dios mi wola' ñop? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tsi' loc'sayob xajlel ti' ti' ba' tsa' ajq'ui chʌmen bʌ. Jesús tsi' letsa i wut ti chan. Tsi' subu: Wocolix a wʌlʌ c Tat, come tsa' wubibeyon c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Cujil ma' wubibeñon c t'an ti pejtelel ora. Tsa' jach c subeyet jini t'an cha'an mi' yubiñob jini año' bʌ tic joytilel, cha'an mi' ñopob tsa' chocoyon tilel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Che' bʌ tsa'ix ujti i sub, c'am tsi' cha'le t'an Jesús: Lázaro, la' ti loq'uel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jini tsa' bʌ chʌmi tsa' loq'ui tilel, bʌc'ʌl i c'ʌb i yoc ti pisil. Mosol i wut ti pisil. Jesús tsi' subeyob: Tiquila. La' majlic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Cabʌl judíojob tsa' bʌ tiliyob ba'an María tsi' q'ueleyob chuqui tsi' cha'le Jesús. Tsi' ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lamital tsa' majli i subeñob fariseojob chuqui tsi' mele Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jini cha'an tsi' tempayob i bʌ ñuc bʌ motomajob yic'ot fariseojob. Tsi' yʌlʌyob: ¿Chuqui yom mi lac mel? che'ob. Come cabʌl mi' pʌs i yejtal i p'ʌtʌlel jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mi ma'anic mi lac tic', mi caj i ñopob pejtelel winicob x'ixicob. Mi caj i tilelob romanojob, mi caj i chilob la que'tel yic'ot lac lumal, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Juntiquil motomaj i c'aba' Caifás, tsa' bʌ i cha'le i ye'tel ti c'ax ñuc bʌ motomaj ti jini jach bʌ jabil, tsi' subeyob: Ma'anic chuqui la' wujil jatetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ma'anic mi la' ña'tan uts'at mi' chʌmel juntiquil winic cha'an i q'uexol pejtelel winicob x'ixicob cha'an ma'anic mi lac laj jilel ti lac lumal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mach tilemic jini t'an ti' bajñel pusic'al. Pero cha'an tsi' cha'le i ye'tel ti ñuc bʌ motomaj ti jini jabil, jini cha'an tsi' yʌlʌ mi caj i chʌmel Jesús cha'an i q'uexol winicob x'ixicob ti' lumal. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Come wersa mi' chʌmel Jesús, mach cha'anic jach jini año' bʌ ti' lumal, pero cha'an mi' tempañob ti junmojt i yalobilob Dios tsa' bʌ pam pujquiyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ti jini jach bʌ ora tsa' caji i comol pejcañob i bʌ ti jujump'ejl q'uin cha'an mi' ña'tañob bajche' mi mejlel i tsʌnsañob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jini cha'an Jesús ma'anic tsi' chʌn cha'le xʌmbal ya' ba'an judíojob. Tsa' loq'ui ya'i. Tsa' majli ti tejclum i c'aba' Efraín lʌc'ʌl ti jochol bʌ lum. Ya'i tsa' ajni yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lʌc'ʌlix i q'uiñilel Pascua mu' bʌ i melob judíojob. Che' maxto tilemic jini Pascua, bajc'ʌl winicob x'ixicob tsa' loq'uiyob ti' lumal ba' chumulob cha'an mi' majlelob ti Jerusalén, cha'an mi' pocob i bʌ cha'an Pascua. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jini judíojob tsa' caji i sʌclañob Jesús. Tsi' pejcayob i bʌ che' wa'alob ti Templo: ¿Chuqui mi la' wʌl? ¿Mach ba anic mi caj i tilel Jesús i q'uel q'uin? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jini ñuc bʌ motomajob yic'ot fariseojob tsi' yʌc'ʌyob mandar cha'an mi' tilel winic i subeñob mi an majch yujil baqui an Jesús, come yomob i ñup'. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Che' yom to wʌcp'ejl q'uin cha'an mi' cajel i q'uiñilel Pascua, Jesús tsa' tili ti Betania ba'an jini Lázaro tsa' bʌ chʌmi, tsa' bʌ cha' tejchi ch'ojyel ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ya'i tsi' melbeyob q'uin. Marta tsi' we'sayob. Ya' buchul Lázaro yic'ot Jesús yic'ot yaño' bʌ ti' t'ejl mesa. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María tsi' ch'ʌmʌ ojlil kilo perfume i c'aba' nardo wen letsem bʌ i tojol. Tsi' bombe i yoc Jesús. Tsi' sujcube i yoc ti' tsutsel i jol. Tsa' wen pujqui i yujts'il perfume ti pejtelel i mal otot. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Juntiquil xcʌnt'an i cha'an Jesús, i c'aba' Judas Iscariote, i yalobil Simón, jiñʌch mu' bʌ caj i yʌc' Jesús ti' c'ʌb i contra, tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Chucoch ma'anic tsa' chojni jini perfume ti jo'lujunc'al denario cha'an mi la cʌq'uen taq'uin jini mach bʌ añobic i chubʌ'an? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Che' tsi' yʌlʌ Judas. Pero ma'anic tsi' p'unta jini mach bʌ añobic i chubʌ'an. Che' jach tsi' yʌlʌ come xujch'. Cʌntʌbil i cha'an jini bolsa ba' tsi' yotsayob taq'uin. Tsi' bajñel c'ʌñʌ lamital. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús tsi' sube: Mach a tic' jini x'ixic. Lotol i cha'an jini perfume cha'an i yorajlel che' mic mujquel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Come ti pejtelel ora añob la' wic'ot jini mach bʌ añobic i chubʌ'an. Joñon mach ti pejtelelic ora wʌ' añon la' wic'ot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cabʌl judíojob tsi' yubiyob ya'ʌch an Jesús. Tsa' tiliyob, mach cha'anic jach mi' q'uelob Jesús pero cha'an mi' q'uelob Lázaro ja'el tsa' bʌ i teche ch'ojyel ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jini ñuc bʌ motomajob tsi' comol pejcayob i bʌ cha'an yomob i tsʌnsan Lázaro ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Come cabʌl judíojob tsa' bʌ i q'ueleyob Lázaro tsi' cʌyʌ i tsajcañob jini motomajob. Tsi' ñopoyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ti yijc'ʌlal cabʌlob tsa' tiliyob ti q'uiñijel. Tsi' yubiyob wolix i tilel Jesús ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Tsi' ch'ʌmʌyob i yopol ch'ib. Tsa' majli i tajob tilel Jesús. C'am tsi' cha'leyob t'an: Cotañet. La' sujbic a ñuclel, jatet mu' bʌ a tilel ti' c'aba' lac Yum, i Reyet Israel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús tsi' taja tsiji' bʌ burro. C'ʌchʌl tsa' tili che' bajche' ts'ijbubil: ");
INSERT INTO ctuBl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mach mi la' cha'len bʌq'uen, x'ixicob ya' bʌ añetla ti Sion. Awilan, tal la' Rey c'ʌchʌl ti tsiji' burro”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jini xcʌnt'añob i cha'an ma'anic tsi' ñaxan ch'ʌmbeyob isujm chuqui woli' yujtel. Ti wi'il che' bʌ tsa' aq'uenti i ñuclel Jesús, tsi' ña'tayob chuqui tac ts'ijbubil cha'an Jesús yic'ot chuqui tac tsa' tumbenti ti pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Cabʌl winicob tsa' bʌ i pi'leyob majlel Jesús che' bʌ tsi' pʌyʌ loq'uel Lázaro ti mucoñibʌl che' bʌ tsi' teche ch'ojyel ba'an chʌmeño' bʌ, tsa' caji i subob chuqui tsi' q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jini cha'an cabʌl tsa' majliyob i taj tilel Jesús ti bij, come tsi' yubiyob bajche' tsi' pʌsʌ i yejtal i p'ʌtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jini fariseojob tsa' caji i subeñob i bʌ: La' wilan, ma'anic chuqui tsa' mejli lac cha'an. Ti pejtelel pañimil woli' tsajcañob Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","An griegojob ja'el tsa' bʌ tiliyob ti q'uiñijel cha'an mi' cha'leñob ch'ujutesaya. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tsa' tiliyob ba'an Felipe ch'oyol bʌ ti Betsaida ya' ti Galilea. Tsi' subeyob: Maestro, com j q'uel lojon Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tsa' majli Felipe i suben Andrés. Andrés yic'ot Felipe tsa' majli i subeñob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús tsi' jac'beyob: I yorajlelix mi caj i yʌq'uentel i ñuclel i Yalobil Winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Isujm, isujm mic subeñetla: Mi ma'anic mi' yajlel ti lum i bʌc' trigo, mi ma'anic mi' pʌjq'uel, to'ol che' jach mi' yajñel. Mi tsa' mʌjcuyi ti lum, mi' pasel. Mi' yʌc' cabʌl i wut. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jini mu' bʌ i bajñel c'uxbin i cuxtʌlel mi caj i sʌt. Jini mu' bʌ i ts'a'len i cuxtʌlel ti pañimil woli' cʌntan i cuxtʌlel mach bʌ anic mi' jilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Majqui jach yom i cha'libeñon que'tel, la' i tsajcañon. Ya' ba' añon mi caj i yajñel c winic ja'el. Mi an majch mi' cha'libeñon que'tel, ñuc mi caj i q'uejlel cha'an c Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wen ch'ijiyem jax woli cubin tic pusic'al wʌle. ¿Chuqui yom mic sub? ¿Yom ba mic sub: “C Tat coltañon cha'an ma'anic chuqui mi' yujtel ti ili ora”? Mach che'iqui come tsa' tiliyon cha'an mic chʌmel ti ili ora. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","C Tat, pʌsʌ i ñuclel a c'aba', che'en Jesús. Jini cha'an tsa' tili t'an ch'oyol bʌ ti panchan. Tsi' yʌlʌ: Tsa'ix c pʌsʌ i ñuclel j c'aba'. Mi caj c cha' pʌs, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jini año' bʌ yic'ot Jesús tsi' yubiyob t'an. Tsi' yʌlʌyob: I t'añʌch chajc, che'ob. Yaño' bʌ tsi' yʌlʌyob: Juntiquil ángel tsi' pejca Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús tsi' subeyob: Ma'anic tsa' tili jini t'an cha'añon, pero tsa' tili cha'añetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wʌle mi caj i mejlelob winicob x'ixicob ti pañimil cha'an i mul. Wʌle mi caj i chojquel loq'uel i yum jini pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Joñon che' mic letsʌntel ti pañimil, mi caj c pʌy tilel pejtelel winicob x'ixicob ba' añon. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tsi' subeyob jini t'an cha'an mi' ch'ʌmbeñob isujm bajche' mi' caj ti chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jini ya' bʌ añob tsi' jac'beyob: Tsa cubi lojon mi caj i yajñel jini Cristo ti pejtelel ora. ¿Chucoch ma' wʌl wersa yom mi' letsʌntel i Yalobil Winic? ¿Majqui jini i Yalobil Winic? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús tsi' subeyob: Mach jalix wʌ'an i sʌclel pañimil la' wic'ot. Cha'lenla xʌmbal che' anto i sʌclel pañimil la' wic'ot ame mi' tajet ic'ch'ipan bʌ pañimil, come jini mu' bʌ i cha'len xʌmbal ti ic'ch'ipam bʌ pañimil mach yujilic baqui mi' majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Che' anto i sʌclel pañimil la' wic'ot, ñopola i sʌclel pañimil. Che' jini, i yalobiletla i sʌclel pañimil. Tsa' ujti ti t'an Jesús. Tsa' majli. Tsi' mʌcʌ i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Anquese cabʌlix i yejtal i p'ʌtʌlel tsa' bʌ i pʌsʌ ti' wutob, ma'anic tsi' ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Che' jini, tsa' ts'ʌctiyi jini t'an subil bʌ i cha'an jini x'alt'an Isaías: “C Yum, ¿majqui tsi' ñopo lac t'an? ¿Majqui tsi' q'uelbe i p'ʌtʌlel lac Yum?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jini cha'an ma'anic tsa' mejli i ñopob, come Isaías tsi' subu: ");
INSERT INTO ctuBl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Lac Yum tsi' yotsayob ti xpots'. Tsi' tsʌts'esʌbeyob i pusic'al, ame i q'uelob ti' wut, ame i ch'ʌmbeñob isujm ti' pusic'al, cha'an mi' sutq'uiñob i bʌ, cha'an mic lajmesañob”. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Che'i tsi' cha'le t'an Isaías cha'an tsi' wʌn q'uelbe i ñuclel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","An yumʌlob ja'el tsa' bʌ i ñopoyob Jesús. Ma'anic tsi' subuyob i bʌ ame chojquicob loq'uel ti sinagoga, come tsi' bʌc'ñayob fariseojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Come tsa' jach i mulayob i ñuclel ti' tojlel winicob. Ma'anic tsi' mulayob i ñuclel ti Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","C'am tsi' cha'le t'an Jesús: Jini mu' bʌ i ñopon, mach cojic jach mi' ñopon. Mi' ñop c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jini mu' bʌ i q'uelon mi' q'uel c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Joñon i sʌclelon pañimil. Tsa' tiliyon ti pañimil cha'an ma'anic mi' cʌytʌl ti ic'ch'ipan bʌ pañimil jini mu' bʌ i ñopon. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma'anic mic mel jini mu' bʌ i yubibeñon c t'an mach bʌ anic mi' jac'. Ma'anic tsa' tiliyon cha'an mic mel jini año' bʌ ti pañimil. Tsa' tiliyon cha'an mij coltañob. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jini mach bʌ yomic i ñopon, mach bʌ anic mi' jac'beñon c t'an, mi caj i toj. Jiñʌch c t'an mu' bʌ caj i tsictesʌben i mul ti jini cojix bʌ q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Come mach tilemic c t'an tic bajñel pusic'al. C Tat tsa' bʌ i chocoyon tilel tsi' yʌq'ueyon mandar cha'an chuqui yom mic sub. ");
INSERT INTO ctuBl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Cujil jiñʌch i mandar Dios cha'an mi cʌq'ueñob winicob x'ixicob i cuxtʌlel mach bʌ anic mi' jilel. Jini cha'an che'ʌch mic sub che' bajche' tsi' subeyon c Tat, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Che' maxto tilemic i q'uiñilel Pascua, yujilix Jesús tsa'ix tili i yorajlel cha'an mi' cʌy pañimil, cha'an mi' majlel ba'an i Tat. Tsi' c'uxbi i cha'año' bʌ ti pañimil. Ma'anic tsi' cʌyʌ i c'uxbiñob. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tsa' ujtiyob ti we'el. Jini xiba tsi' ñijcʌbe i pusic'al Judas, i yalobil Simón Iscariote, cha'an mi' yʌc' Jesús ti' c'ʌb i contra. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yujil Jesús anix ti' wenta pejtelel chuqui tac an come i Tat tsi' yʌq'ue. Yujil ja'el tsa' tili ti Dios, yujil ya' mi' cha' majlel ba'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Tsa' ch'ojyi ti mesa. Tsi' jocho i bujc. Tsi' wel cʌchʌ sujco' c'ʌbʌl ti' ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tsi' jebe ja' ti poc'. Tsa' caji i pocbenob i yoc xcʌnt'añob. Tsi' sujcubeyob ti jini pisil tsa' bʌ i cʌchʌ ti' ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tsa' tili Jesús ba'an Simón Pedro. Pedro tsi' sube: C Yum, ¿mu' ba' caj a pocbeñon coc? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús tsi' sube: Jini mu' bʌ c cha'len, ma'anic ma' ch'ʌmben isujm wʌle. Ti wi'il mi caj a ch'ʌmben isujm, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro tsi' sube: Ma'anic mi caj a pocbeñon coc ti pejtelel ora, che'en. Jesús tsi' sube: Mi ma'anic mic poquet, mach c cha'añetic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro tsi' sube: C Yum, mach jinic jach coc yom ma' poc. Poco ja'el j c'ʌb yic'ot c jol, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesús tsi' sube: Jasʌl mi' pocbentel i yoc jini pocbilix bʌ. Che' jini, sʌquix ti pejtelel. Jatetla sʌquetla, pero mach pejteleticla, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Come yujil Jesús majqui mi caj i yʌc' ti' c'ʌb i contra. Jini cha'an tsi' subu: “Mach pejteleticla”. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Che' bʌ tsa' ujti i pocbeñob i yoc, tsi' cha' ch'ʌmʌ i bujc. Tsa' cha' buchle. Tsi' c'ajtibeyob: ¿La' wujil ba chuqui tsac melbeyetla? ");
INSERT INTO ctuBl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mi la' pejcañon ti la' Maestro yic'ot ti la' Yum. Uts'at chuqui mi la' wʌl, come isujm joñonʌch. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mi tsa'ix c pocbeyet la' woc joñon, la' Yumon, la' Maestrojon, che'ʌch yom mi la' pocben la' bʌ la' woc. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tsac pʌsbeyetla chuqui wen cha'an che'ʌch yom mi la' mel jatetla ja'el che' bajche' tsac melbeyetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Isujm, isujm mic subeñetla: Jini mu' bʌ i melben i ye'tel i yum, mach ñumen ñuquic bajche' i yum. Jini chocbil bʌ majlel mach ñumen ñuquic bajche' jini tsa' bʌ i choco majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mi la' wujilʌch chuqui tsac subeyetla, tijicñayetla che' mi la' mel. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ma'anic mic pejcañetla ti la' pejtelel. Cujil majqui tsac yajca cha'an mi' ts'ʌctiyel i Ts'ijbujel Dios mu' bʌ i yʌl: “Jini tsa' bʌ i c'uxu waj quic'ot tsi' contrajiyon”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tsa'ix c subeyetla che' maxto ujtemic. Che' mi' yujtel mi caj la' ñop Cristojon. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Isujm, isujm mic subeñetla: Jini mu' bʌ i pʌy ochel c winic mu' bʌ c choc majlel, woli' pʌyon ochel ja'el. Jini mu' bʌ i pʌyon ochel woli' pʌy ochel c Tat ja'el tsa' bʌ i chocoyon tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Che' bʌ tsa' ujti i sub jini t'an Jesús, wen ch'ijiyem tsa' caji i yubin ti' pusic'al. Tsi' subu: Isujm, isujm mic subeñetla, juntiquil wʌ' bʌ an la' wic'ot mi caj i yʌc'on ti' c'ʌb j contra, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jini xcʌnt'añob tsi' q'ueleyob i bʌ. Mach yujilobic majqui. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesús c'uxatax tsi' yubi juntiquil xcʌnt'an i cha'an ya' bʌ buchul, lʌc'ʌl ti' t'ejl. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro tsi' pʌsbe i c'ʌb jini xcʌnt'an buchul bʌ ti' t'ejl Jesús cha'an mi' c'ajtiben majqui jini mu' bʌ caj i yʌc' ti' c'ʌb i contra. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jini ya' bʌ buchul ti' t'ejl Jesús tsi' sube: C Yum, ¿majqui? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús tsi' jac'be: Jiñʌch mu' bʌ cʌq'uen ts'ajbil bʌ waj, che'en. Che' bʌ tsa' ujti i ts'aj waj, tsi' yʌq'ue Judas i yalobil Simón Iscariote. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Che' bʌ tsi' ch'ʌmʌ jini ts'ajbil bʌ waj Judas, tsa' ochi Satanás ti' pusic'al. Jesús tsi' sube: Jini mu' bʌ caj a cha'len, cha'len ti ora, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jini año' bʌ ti' t'ejl mesa mi juntiquilic tsi' ch'ʌmbe isujm chucoch tsi' sube jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Come ojlil tsi' yʌlʌyob ti' pusic'al, tic'ʌl mi Jesús tsi' sube Judas i mʌn chuqui tac yom cha'an q'uin, come jini Judas woli' cʌntan jini bolsa. Tsi' cha' ña'tayob, tic'ʌl mi tsi' sube i yʌq'uen taq'uin jini mach bʌ anic i chubʌ'an. Che' tsi' yʌlʌyob ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Che' bʌ tsa' ujti i ch'ʌm ts'ajbil bʌ waj Judas, tsa' loq'ui ti ora. Ac'ʌlelix. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Che' loq'uemix Judas, Jesús tsi' yʌlʌ: Wʌle tsa'ix aq'uenti i ñuclel i Yalobil Winic. Tsa'ix pʌsle i ñuclel Dios ti' Yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Mi tsa'ix pʌsle i ñuclel Dios ti' Yalobil, mi caj i pʌstʌl i ñuclel i Yalobil ti Dios. Dios mi' caj i bʌc' tsictesan i ñuclel i Yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Calobilob, jumuc' jach wʌ' añon la' wic'ot. Mi caj la' sajcañon. Che' bajche' tsac sube judíojob, che' ja'el mic subeñetla: Ya' ba' mic majlel, mach mejlic la' majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi cʌq'ueñetla tsijib mandar: C'uxbin la' bʌ. Che' bajche' tsaj c'uxbiyetla, che' yom mi' la' c'uxbin la' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Che' jini, pejtelel winicob mi caj i ña'tañob xcʌnt'añetla c cha'an che' mi la' c'uxbin la' bʌ, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro tsi' c'ajtibe: C Yum, ¿baqui ma' majlel? che'en. Jesús tsi' jac'be: Ya' ba' mic majlel maxto anic mi mejlel a tsajcañon majlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro tsi' sube: C Yum, ¿chucoch maxto mejlic c tsajcañet majlel? Mi caj cʌc' c bʌ ti chʌmel cha'añet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús tsi' sube: ¿Mu' ba a wʌc' a bʌ ti chʌmel cha'añon? Isujm, isujm mic subeñet, che' maxto anic tsi' cha'le uq'uel tat mut, uxyajl mi caj a sub mach a cʌñʌyonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mach la' mel la' pusic'al. Mi la' ñop Dios. Ñopoyon ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti' yotot c Tat an cabʌl chumlibʌl. Machic an chumlibʌl, tsac subeyetla, come mic majlel c chajpʌbeñetla la' wajñib. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Mi tsa'ix majli c chajpan la' wajñib, cha' talon c pʌyetla majlel ba' añon, cha'an ya' ba' añon, ya' añetla ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","La' wujil baqui mic majlel. Cʌñʌl la' cha'an i bijlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás tsi' sube: C Yum, mach cujilic lojon baqui ma' majlel. ¿Bajche' mi mejlel j cʌn lojon i bijlel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús tsi' sube: Joñon i bijlelon isujmlelon, i cuxtʌlelon. Ma'anic majch mi' c'otel ba'an c Tat, jini jach am bʌ tic wenta. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tsa'ic la' cʌñʌyon, tsa' la' cʌñʌ c Tat ja'el. Wʌle cʌñʌlix la' cha'an c Tat. Tsa'ix la' q'uele, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe tsi' sube: C Yum, pʌsbeñon lojon a Tat. Jasʌl mi tsa' pʌsʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús tsi' sube: Cabʌlix ora wʌ' añon la' wic'ot. ¿Mach ba anic tsa' cʌñʌyon, Felipe? Jini tsa' bʌ i q'ueleyon, tsa'ix i q'uele c Tat. ¿Chucoch ma' wʌl, che' jini: “Pʌsbeñon lojon a Tat”? che'et. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mach ba anic ma' ñop añon tic Tat, c Tat an ti joñon? Jini t'an mu' bʌ c subeñetla, ma'anic mic sub tic bajñelil. C Tat mu' bʌ i yajñel ti joñon woli' mel jini e'tel quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ñopoyon, añon tic Tat, c Tat an ti joñon. Mi ma'anic mi la' ñop c t'an, ñopoyon cha'an que'tel. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Isujm, isujm mic subeñetla, jini mu' bʌ i ñopon, mi caj i cha'len jini e'tel mu' bʌ c cha'len ja'el. Ñumen ñuc bajche' tsac cha'le mi caj i cha'len, come mic majlel ba'an c Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pejtelel chuqui tac mi la' c'ajtiben c Tat tij c'aba', mi caj c cha'len cha'an mi' tsictiyel i ñuclel c Tat ti' Yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mi an chuqui mi la' c'ajtin tij c'aba', joñon mi caj c jac'. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mi c'ux mi la' wubiñon, mi caj la' jac'beñon c mandar. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Joñon mi caj j c'ajtiben c Tat. Mi caj i yʌq'ueñetla yambʌ la' waj Pi'leya, cha'an mi' yajñel la' wic'ot ti pejtelel ora. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jiñʌch jini Espíritu mu' bʌ i pʌs i sujmlel Dios. Jini i cha'año' bʌ pañimil mach mejlic i yʌq'uentelob, come ma'anic mi' q'uelob, ma'anic mi' cʌñob ja'el. Jatetla mi la' cʌn, come mi' yajñel la' wic'ot. Mi caj i yajñel ti la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ma'anic mi caj j cʌyetla ti meba'. Cha' talon ba' añetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jumuc' jach, ma'anic mi caj i chʌn q'ueloñob jini año' bʌ ti pañimil. Jatetla mi la' q'uelon. Cha'an cuxulon, mi caj la' taj la' cuxtʌlel ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ti jini jach bʌ q'uin mi caj la' ña'tan añon tic Tat, añetla ti joñon, añon ti jatetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jini mu' bʌ i cʌn c mandar, mu' bʌ i jac', jiñʌch mu' bʌ i c'uxbiñon. Jini mu' bʌ i c'uxbiñon, mi caj i c'uxbintel cha'an c Tat. Joñon mi caj j c'uxbin ja'el. Mi caj cʌq'ueñetla la' wen cʌñon. Che' tsi' yʌlʌ Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yañʌch bʌ Judas, mach jinic Judas Iscariote, tsi' sube: C Yum, ¿chucoch mi caj a wʌq'ueñon lojon c wen cʌñet, che' ma'anic ma' wʌq'ueñob i cʌñet jini i cha'año' bʌ pañimil? che'en Judas. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús tsi' sube: Jini mu' bʌ i c'uxbiñon mi caj i jac'beñon c t'an. Mi caj i c'uxbintel cha'an c Tat. Mi caj c tilel lojon ba'an. Mi caj c cha'len lojon chumtʌl quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jini mach bʌ anic mi' c'uxbiñon ma'anic mi' jac'beñon c t'an. Jini t'an tsa' bʌ la' wubi mach c cha'anic. I cha'añʌch c Tat tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tsac subeyetla jini t'an che' wʌ'to añon la' wic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","C Tat mi caj i choc tilel la' waj Pi'leya tij c'aba'. Jiñʌch Ch'ujul bʌ Espíritu. Jini mi caj i cʌntesañetla pejtelel chuqui an. Mi caj i yʌq'ueñetla la' cha' ña'tan pejtelel chuqui tsac subeyetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mic ñʌch'chocobeñetla la' pusic'al. Jiñʌch i ñʌch'tilel c pusic'al mu' bʌ cʌq'ueñetla. Mach lajalic bajche' mi la' taj ti pañimil. Mach la' mel la' pusic'al. Mach la' cha'len bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tsa' la' wubi chuqui tsac subeyetla: “Mic majlel, pero mic cha' tilel ba' añetla”. Tsa'ic la' wen c'uxbiyon, tijicña la' pusic'al cha'an tsac subeyetla mic majlel ba'an c Tat, come ñumen ñuc c Tat bajche' joñon. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Wʌle tsa'ix c subeyetla che' maxto anic tsa' ujti, cha'an mi la' ñopon ba' ora mi' yujtel. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mach chʌn cabʌlix mic pejcañetla, come tal i yum pañimil. Ma'anic i p'ʌtʌlel tij contra. ");
INSERT INTO ctuBl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Mic cha'len che' bajche' tsi' subeyon c Tat ti mandar cha'an mi' ña'tañob ti pejtelel pañimil, c'ux mi cubin c Tat. Ch'ojyenla. Conla. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Joñon jini Isujm bʌ Ac'on. C Tat jiñʌch Xpora. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jini mi' tsep loq'uel pejtelel j c'ʌb mach bʌ anic mi' yʌc' i wut. Pejtelel mu' bʌ i yʌc' i wut, mi caj i porajin cha'an ñumen cabʌl mi' yʌc' i wut. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sʌquetixla cha'an jini t'an tsa' bʌ c subeyetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ajñenla ti joñon. Joñon ja'el mi caj cajñel ti jatetla. I c'ʌb ac' ma'anic mi mejlel i yʌc' i wut ti' bajñelil, che' ma'anic mi' yajñel ti' yʌq'uil. Che' ja'el jatetla mach mejlic la' wʌc' la' wut, che' ma'anic mi la' wajñel ti joñon. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Joñon jini Ac'on, jatetla j c'ʌbetla. Jini mu' bʌ i yajñel ti joñon che' woli cajñel ti jini winic, jiñʌch mu' bʌ i yʌc' cabʌl i wut. Ma'anic chuqui mi mejlel la' mel mi ma'anic mi la' wajñel ti joñon. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jini mach bʌ anic mi' yajñel ti joñon, mi caj i chojquel loq'uel che' bajche' mach bʌ wenic bʌ i c'ʌb ac'. Mi' tiquin. Mi caj i tempʌyel cha'an mi' chojquel ti c'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mi woli la' wajñel ti joñon, mi woli' yajñel c t'an ti jatetla, c'ajtinla chuqui tac jach la' wom, mi caj la' jac'bentel. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi' caj ti pʌstʌl i ñuclel c Tat, che' mi la' wʌc' cabʌl la' wut. Che' jini, xcʌnt'añetla c cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Che' bajche' tsi' c'uxbiyon c Tat, che' ja'el tsaj c'uxbiyetla. Chʌn ajñenla tij c'uxbiya. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Mi woli la' jac'beñon c mandar, mi caj c chʌn c'uxbiñetla. Che' ja'el tsac jac'be i mandar c Tat. Wolic chʌn c'uxbintel tic Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Jini t'an tsac subeyetla cha'an mi' yajñel ti la' pusic'al i tijicñʌyel c pusic'al, cha'an mi' ts'ʌctiyel i tijicñʌyel la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jiñʌch c mandar: C'uxbin la' bʌ che' bajche' tsaj c'uxbiyetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jiñʌch ñuc bʌ c'uxbiya che' an majch mi' yʌc' i bʌ ti chʌmel cha'an i pi'ʌlob. Ma'anic majch ñumen cabʌl i c'uxbiya bajche' jini. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jatetla c pi'ʌletla che' mi la' cha'len chuqui mic subeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma'anic mic chʌn pejcañetla tic winic, come jini winic am bʌ ti' yum mach yujilic chuqui mi' cha'len i yum. Mic pejcañetla tic pi'ʌl, come pejtelel chuqui tsa cubi tic Tat, tsa'ix cʌq'ueyetla la' ñop. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jatetla ma'anic tsa' la yajcayon. Joñon tsac yajcayetla. Tsa cʌq'ueyetla la' we'tel cha'an mi la' majlel la' wʌc' la' wut mu' bʌ caj i jalijel, cha'an mi' yʌq'ueñetla c Tat pejtelel chuqui mi la' c'ajtiben tij c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jiñʌch c mandar cha'an mi la' chʌn c'uxbin la' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mi ts'a' mi' q'ueletla jini i cha'año' bʌ pañimil, ña'tanla ts'a' tsi' q'ueleyoñob ti ñaxan. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","I cha'año' bʌ pañimil mi' c'uxbiñob i bʌ. I cha'añeticla pañimil, mi' c'uxbiñetla. Mach i cha'añeticla pañimil, come tsac yajcayetla. Jini cha'an jini año' bʌ ti pañimil mi' ts'a'leñetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ña'tanla jini t'an tsa' bʌ c subeyetla: “Jini mu' bʌ i melben i ye'tel i yum mach ñumen ñuquic bajche' i yum”. Mi tsi' tic'layoñob, mi caj i tic'lañetla ja'el. Mi tsi' jac'ʌyob c t'an, mi caj i jac'ob la' t'an ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Che'ʌch mi caj i melbeñetla i cha'año' bʌ pañimil cha'an ti' caj j c'aba', come ma'anic mi' cʌñob jini tsa' bʌ i chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Machic tsa' tiliyon, machic tsac pejcayob, ma'añobic i mul. Wʌle añob i mul. Mach mejlic i subob ma'añobic i mul. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jini mu' bʌ i ts'a'leñon, mi' ts'a'len c Tat ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma'anic majch tsi' mele ñuc bʌ i ye'tel che' bajche' tsac mele ti' tojlelob. Machic tsac mele, ma'añobic i mul. Wʌle tsa'ix i q'ueleyob. Mi' ts'a'leñoñob quic'ot c Tat ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Che' jini, mi' ts'ʌctiyel jini t'an ts'ijbubil bʌ ti mandar: “Tsi' ts'a'leyoñob cha'an jach yomob”. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mi caj c chocbeñetla tilel la' waj Pi'leya ch'oyol bʌ tic Tat. Jiñʌch jini Espíritu ch'oyol bʌ tic Tat mu' bʌ i ts'ʌctesan i sujmlel c t'an. Che' mi' tilel mi caj i yʌc'on ti cʌjñel. ");
INSERT INTO ctuBl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jatetla ja'el mi caj la' wʌc'on ti cʌjñel, come añetla quic'ot c'ʌlʌl ti' cajibal j cʌntesa. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tsac subeyetla jini t'an cha'an ma'anic mi' tejchel tile bixel bʌ la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jini judíojob mi caj i choquetla loq'uel ti sinagoga. Mi caj i c'otel i yorajlel che' mi caj i lon ña'tañob uts'at woli' melbeñob i ye'tel Dios che' mi' tsʌnsañetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Che'ʌch mi caj i cha'leñob, come mach i cʌñʌyobic c Tat. Ma'anic tsi' cʌñʌyoñob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tsac subeyetla chuqui tac tal cha'an mi la' ña'tan ba' ora mi' yujtel, jiñʌch tsa' bʌ c wʌn subeyetla. Ma'anic tsac subeyetla che' ti' cajibal, come wʌ' to añon la' wic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wʌle mic majlel ba'an jini tsa' bʌ i chocoyon tilel. Mi juntiquileticla woli' c'ajtibeñon baqui mic majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero wen ch'ijyem jax la' pusic'al cha'an c t'an tsa' bʌ c subeyetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mic subeñetla ti isujm: Ñumen uts'at cha'añetla mi tsa' majliyon. Mi ma'anic mic majlel, mach talic la' waj Pi'leya ba' añetla. Che' majlemonix mi caj c chocbeñetla tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Che' julemix la' waj Pi'leya, mi caj i jec'beñob i pusic'al winicob x'ixicob ti pañimil cha'an mi' tsictesʌbeñob i mul yic'ot toj bʌ c pusic'al yic'ot tojmulil. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mi caj i ña'tañob añob i mul cha'an ma'anic tsi' ñopoyoñob. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mi caj i ña'tañob toj c pusic'al, come mic majlel ba'an c Tat. Ma'anix mi caj la' chʌn q'uelon. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mi caj i ña'tañob an tojmulil, come otsʌbilix ti tojmulil i yum pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","An to cabʌl chuqui com c subeñetla. Maxto mejlic la' lu' ch'ʌmben i sujmlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Che' julemix jini Espíritu mu' bʌ i pʌs i sujmlel, mi caj i yʌq'ueñetla la' cʌn pejtelel i sujmlel. Come ma'anic mi' c'ʌn i bajñel pusic'al i tsictesan chuqui tac mi' sub. Mi' sub pejtelel chuqui tac mi' yubin. Mi' caj i subeñetla chuqui tac tal. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mi caj i pʌs c ñuclel, come mi caj i lu' ch'ʌm ti' wenta. Mi caj i yʌq'ueñetla la' cʌn. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pejtelel chuqui an i cha'an c Tat, c cha'añʌch. Jini cha'an tsac subeyetla mi caj i lu' ch'ʌm ti' wenta. Mi caj i yʌq'ueñetla la' cʌn. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jumuc' jax ma'anix mi caj la' q'uelon. Ti yambʌ jumuc' to mi caj la' cha' q'uelon, come mic majlel ba'an c Tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jini cha'an jini xcʌnt'añob i cha'an tsa' caji i c'ajtibeñob i bʌ: ¿Chuqui jini mu' bʌ i subeñonla Jesús? “Jumuc' jax”, che'en, “ma'anic mi caj la' q'uelon. Ti yambʌ jumuc' to mi caj la' cha' q'uelon, come mic majlel ba'an c Tat”. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Jini cha'an tsi' yʌlʌyob: ¿Chuqui i sujmlel che' mi' yʌl Jesús, jumuc' to? Ma'anic mi lac ch'ʌmben isujm chuqui mi' yʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tsi' ña'ta Jesús chuqui yom i c'ajtibeñob. Tsi' subeyob: ¿Mu' ba la' c'ajtiben la' bʌ chuqui i sujmlel c t'an tsa' bʌ cʌlʌ: “Jumuc' ma'anic mi caj la' q'uelon. Ti yambʌ jumuc' to mi caj la' cha' q'uelon”? ");
INSERT INTO ctuBl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Isujm, isujm mic subeñetla: Jatetla mi caj la' cha'len uq'uel, mi caj la' mel la' pusic'al. Jini año' bʌ ti pañimil tijicña mi caj i yubiñob. Jatetla ch'ijyem jax mi caj la' wubin. Ti wi'il mi caj i q'uextʌyel i ch'ijiyemlel la' pusic'al ti' tijicñʌyel. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Che' i yorajlelix mi caj i yilan pañimil alʌl, mi' yubin wocol i ña' cha'an bajq'uel. Ti wi'il, che' tsa'ix i meq'ue alʌl, ma'anix chʌn c'ajal i cha'an i wocol, come tijicñayix i pusic'al cha'an tsi' yila pañimil i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jatetla ja'el wocol mi la' wubin wʌle. Joñon mi caj c cha' q'ueletla. Tijicña mi caj la' wubin. Ma'anic majch mi mejlel i yʌc' ti jilel i tijicñʌyel la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ti jini q'uin ma'anic mi caj la' c'ajtibeñon i sujmlel c t'an. Isujm, isujm mic subeñetla, pejtelel chuqui mi la' c'ajtiben c Tat tij c'aba', mi caj i yʌq'ueñetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","C'ʌlʌl wʌle ma'anic chuqui tsa' la' c'ajti tij c'aba'. C'ajtinla. Mi caj la' wʌq'uentel cha'an mi' ts'ʌctiyel i tijicñʌyel la' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jini t'an tsac subeyetla ti lajiya. Tal i yorajlel che' ma'anic mic chʌn pejcañetla ti lajiya. Mi caj c subeñetla i sujmlel c Tat ti wen tsiquil bʌ t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti jini q'uin mi caj la' cha'len c'ajtiya tij c'aba'. Ma'anic wolic subeñetla mi caj j c'ajtiben lac Tat cha'añetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Come c Tat ja'el mi' c'uxbiñetla, come jatetla mi la' c'uxbiñon. Tsa'ix la' ñopo tilemon ti Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tsa' loq'uiyon tilel ba'an c Tat. Tsa' tiliyon ti pañimil. Ti yambʌ ora mi caj j cʌy pañimil. Mi caj c cha' majlel ba'an c Tat, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jini xcʌnt'añob i cha'an tsi' subeyob: Awilan, tsiquilʌch i sujmlel a t'an wʌle. Mach ti lajiyajic woliyet ti t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cujilix lojon a wujilʌch pejtelel chuqui tac an. Mach yomic ma' cʌntesʌntel ti winicob. Jini cha'an mic ñop lojon tilemet ti Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús tsi' c'ajtibeyob: ¿Mu' ba la' ñop wʌle? ");
INSERT INTO ctuBl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Awilan, tal i yorajlel, i yorajelix wʌle, mi caj la' pam pujquel. Ti jujuntiquiletla mi caj la' sujtel ti la' wotot. Mi caj la' cʌyon tic bajñelil. Pero mach c bajñelic, come an quic'ot c Tat. ");
INSERT INTO ctuBl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tsac subeyetla jini t'an cha'an mi la' taj i ñʌch'tilel la' pusic'al ti joñon. Ti pañimil mi caj la' taj wocol. La' ñuc'ac la' pusic'al, come tsac jisʌbe i yumʌntel pañimil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesús tsi' subeyob jini t'an. Tsi' letsa i wut ti panchan. Tsi' yʌlʌ: C Tat, i yorajlelix wʌle. Pʌsʌ i ñuclel a Walobil, cha'an mi' pʌs a ñuclel a Walobil ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Come tsa' wotsa pejtelel winicob x'ixicob tic p'ʌtʌlel cha'an mi cʌq'ueñob i cuxtʌlel mach bʌ anic mi' jilel ti pejtelelob tsa' bʌ a wʌq'ueyon. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jiñʌch i cuxtʌlel mach bʌ anic mi' jilel, che' mi' cʌñetob jini mero Dios, jini cojach bʌ, yic'ot Jesucristo, tsa' bʌ a choco tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tsac pʌsʌ a ñuclel ila ti pañimil. Tsa'ix c ts'ʌctesa jini e'tel tsa' bʌ a wʌq'ueyon cha'an mic mel. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wʌle, c Tat, pʌsʌ c ñuclel che' bajche' an c cha'an quic'otet che' maxto anic pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Tsac tsictesʌbeyob a c'aba' jini winicob tsa' bʌ a wʌq'ueyon ti pañimil. A cha'añob, tsa' wʌq'ueyoñob. Tsi' jac'ʌyob a t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yujilobix ya' ch'oyol ba' añet pejtelel tsa' bʌ a wʌq'ueyon. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Come tsa cʌq'ueyob ili t'an tsa' bʌ a wʌq'ueyon. Tsi' ñopoyob. Yujilobix, isujm tsa' loq'uiyon tilel ba' añet. Tsi' ñopoyob chocbilon tilel a cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mij c'ajtibeñet i wenlel. Ma'anic mij c'ajtibeñet i wenlel i cha'año' bʌ pañimil. Pero mij c'ajtibeñet i wenlel jini winicob tsa' bʌ a wʌq'ueyon, come a cha'añob. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A cha'añobʌch pejtelel c cha'año' bʌ. C cha'añobʌch pejtelel a cha'año' bʌ ja'el. Woli' tsictiyel c ñuclel ti jini xñopt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mach chʌn añonix ti pañimil pero añob to ti pañimil. Joñon cha' talon ba' añet. C Ch'ujutat, cʌntañob ti a c'aba' jini xñopt'añob tsa' bʌ a wʌq'ueyon cha'an mi' yajñelob ti jump'ejl jach i pusic'al che' bajche' joñonla. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Che' wʌ'to añon quic'otob ti pañimil, tsaj cʌntayob ti a c'aba'. Tsaj cʌnta jini xñopt'añob tsa' bʌ a wʌq'ueyon. Ma'anic tsa' sajti mi juntiquilic, jini jach mu' bʌ i majlel ti tojmulil cha'an mi' ts'ʌctiyel i Ts'ijbujel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Wʌle talon ba' añet. Wolic sub jini t'an ti pañimil cha'an mi' ts'ʌctiyel i tijicñʌyel i pusic'al che' bajche' i tijicñʌyel c pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tsa cʌq'ueyob a t'an. Jini i cha'año' bʌ pañimil tsi' ts'a'leyob c cha'año' bʌ, come mach i cha'añobic pañimil che' bajche' joñon ja'el mach i cha'añonic pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma'anic mij c'ajtibeñet cha'an ma' pʌyob loq'uel ti pañimil. Mij c'ajtibeñet cha'an ma' chʌcʌ q'uelob ame yajlicob ti jontolil. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Mach i cha'añobic pañimil che' bajche' joñon mach i cha'añonic pañimil ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sʌq'uesañob ti a sujmlel. Isujmʌch jini a t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Che' bajche' tsa' chocoyon tilel ti pañimil, che' ja'el tsac chocoyob majlel ti pejtelel pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi cʌq'ueñet c bʌ cha'an mi' yʌq'ueñetob i bʌ ja'el cha'an ti' sujmlel a t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Mach cojic jach ili winicob x'ixicob mic tajob ti oración, pero ti pejtelelob mu' bʌ caj i ñopoñob cha'an ti' t'an ili wʌ' bʌ añob, ");
INSERT INTO ctuBl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","cha'an mi' yajñelob ti jump'ejl jach i pusic'al pejtelel xñopt'añob. Che' bajche' añet ti joñon, c Tat, añon ja'el ti jatet, la' ajñicob ja'el ti joñonla cha'an mi' ñopob jini año' bʌ ti pañimil jatet tsa' chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Joñon tsa cʌq'ueyob c ñuclel tsa' bʌ a wʌq'ueyon cha'an mi' yajñelob ti jump'ejl jach i pusic'al, che' bajche' jump'ejl lac pusic'al ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Añon ti' tojlelob, añet ti joñon, cha'an mero jump'ejlob jach i pusic'al. Che' jini, jini año' bʌ ti pañimil mi caj i ña'tañob jatet tsa' chocoyon tilel. Mi mejlel i ña'tañob ja'el c'ux tsa' wubiyob, che' bajche' c'ux tsa' wubiyon. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","C Tat, ya' ba' añon com temel mi' yajñelob jini tsa' bʌ a wʌq'ueyon cha'an mi' q'uelob c ñuclel tsa' bʌ a wʌq'ueyon, come c'ux tsa' wubiyon che' maxto melbilic pañimil. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Toj bʌ c Tat, ma'anic tsi' cʌñʌyet año' bʌ ti pañimil. Joñon tsaj cʌñʌyet. Yujilob xñopt'añob ja'el tsa' chocoyon tilel. ");
INSERT INTO ctuBl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tsa cʌq'ueyob i cʌn a c'aba'. Mu' to caj c chʌn ac' ti cʌjñel cha'an lajal mi' c'uxbiñoñob che' bajche' tsa' c'uxbiyon, cha'an mi cajñel ti' pusic'alob. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Che' bʌ tsa' ujti ti t'an Jesús, tsa' c'axi yic'ot xcʌnt'añob i cha'an ti junwejl pa' i c'aba' Cedrón ba'an pʌc'ʌbʌl. Ya' tsa' ochi yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Cʌmbil jini pʌc'ʌbʌl i cha'an Judas ja'el, jini tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra, come cabʌl tsa' ajni ya'i Jesús yic'ot xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas tsi' pʌyʌ tilel junmojt soldadojob yic'ot xcʌntayajob i cha'an motomajob yic'ot fariseojob. Tsa' tiliyob yic'ot c'ajc yic'ot taj yic'ot espada. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ña'tʌbilix i cha'an Jesús pejtelel chuqui tac mi caj i tumbentel. Tsa' majli ba' añob. Tsi' c'ajtibeyob: ¿Majqui woli la' sajcan? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tsi' jac'beyob: Jesús, jini ch'oyol bʌ ti Nazaret, che'ob. Jesús tsi' subeyob: Joñoñʌch, che'en. Ya'an Judas ja'el yic'otob. Jiñʌch tsa' bʌ i yʌc'ʌ Jesús ti' c'ʌb i contra. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Che' bʌ tsi' subeyob: “Joñoñʌch”, wʌlʌc pat tsi' chocoyob majlel i bʌ. Tsa' yajliyob ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús tsi' cha' c'ajtibeyob: ¿Majqui woli la' sajcan? che'en. Tsi' subeyob: Jesús, jini ch'oyol bʌ ti Nazaret, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tsi' jac'ʌ Jesús: Tsa'ix c subeyetla joñoñʌch. Mi woli la' sajcañon, la' sujticob ili xcʌnt'añob c cha'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Che'ʌch tsa' ujti cha'an mi' ts'ʌctiyel jini t'an tsa' bʌ i yʌlʌ Jesús: “Ma'anic tsa' sajti mi juntiquilic xcʌnt'an tsa' bʌ a wʌq'ueyon”. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wʌle Simón Pedro tsi' bots'o i yespada. Tsi' wel tsepbe loq'uel ñoj bʌ i chiquin i winic jini ñuc bʌ motomaj. I c'aba' jini winic Malco. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús tsi' sube: Pedro, otsan a wespada ti' yotot. ¿Mach ba yomic mic laj ñusan ili wocol tsa' bʌ i yʌq'ueyon c Tat? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jini soldadojob yic'ot i capitán yic'ot xcʌntayajob i cha'an judíojob tsi' chucuyob Jesús. Tsi' cʌchʌyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tsi' ñaxan pʌyʌyob majlel ba'an Anás, i ñij'al Caifás, jini ñuc bʌ motomaj ti jini jabil. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","(Jiñʌch Caifás tsa' bʌ i sube judíojob uts'at mi' chʌmel juntiquil winic cha'an i q'uexol winicob x'ixicob.) ");
INSERT INTO ctuBl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro tsi' tsajca majlel Jesús yic'ot yambʌ xcʌnt'an. Jini yambʌ xcʌnt'an cʌmbilʌch i cha'an jini ñuc bʌ motomaj. Tsa' ochi yic'ot Jesús ya' ti' pam i yotot jini ñuc bʌ motomaj. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro tsa' cʌle ti jumpat, wa'al ti' ti' otot. Jini cha'an jini yambʌ xcʌnt'an, cʌmbil bʌ i cha'an jini ñuc bʌ motomaj, tsi' pejca jini xch'oc tsa' bʌ i cʌnta i ti' otot. Jini xch'oc tsi' pʌyʌ ochel Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jini xch'oc tsa' bʌ i cʌnta i ti' otot tsi' c'ajtibe Pedro: ¿Mach ba xcʌnt'añetic i cha'an ja'el? che'en. Pedro tsi' yʌlʌ: Mach joñonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Wa'alob x'e'telob yic'ot xcʌntayajob ya' ba' tsi' meleyob c'ajc come an tsʌñal. Woli' q'uixñesañob i bʌ. Ya' wa'al Pedro ja'el yic'otob. Woli' q'uixñesan i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jini ñuc bʌ motomaj tsa' caji i c'ajtiben Jesús: ¿Majqui xcʌnt'añob a cha'an? ¿Chuqui a cʌntesa? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús tsi' jac'be: Joñon tsac pejcayob ti jamʌl jini año' bʌ ti pañimil. C tilelʌch mic cha'len cʌntesa ti sinagoga yic'ot ti Templo ba' mi' tempañob i bʌ pejtelel judíojob. Ma'anic tsac subu t'an ti mucul jach. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chucoch wola' c'ajtibeñon, che' jini? C'ajtibeñob jini tsa' bʌ i yubiyob chuqui tsac subeyob. Yujilob chuqui tsac subu, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Che' bʌ tsa' ujti i sub jini t'an, juntiquil winic wa'al bʌ ti' t'ejl tsi' poch'i Jesús. Tsi' yʌlʌ: ¿Mu' ba a jac'ben i t'an jini ñuc bʌ motomaj che' bajche' jini? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús tsi' jac'be: Mi jontol chuqui tsac subu, tsictesan c jontolil. Mi weñʌch chuqui tsac subu, ¿chucoch ma' poch'iñon? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Che' cʌchʌl to Jesús, Anás tsi' choco majlel ba'an Caifás jini ñuc bʌ motomaj. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wa'al to Simón Pedro, woli' q'uixñesan i bʌ. Tsi' c'ajtibeyob: ¿Jatet ba ja'el xcʌnt'añet i cha'an? che'en. Pedro tsi' yʌlʌ: Mach joñonic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Juntiquil i winic jini c'ax ñuc bʌ motomaj, i pi'ʌlʌch jini tsa' bʌ tsepbenti loq'uel i chiquin, tsi' yʌlʌ: ¿Mach ba tsa'ic j q'ueleyet ya' ti pʌc'ʌbʌl a wic'ot jini Jesús? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro tsi' cha' alʌ mach i cʌñʌyic Jesús. Ti ora jini tat mut tsi' cha'le uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tsa' caji i pʌyob loq'uel Jesús ti' yotot Caifás. Tsi' pʌyʌyob majlel ti meloñibʌl. Wolix i sʌc'an pañimil. Ma'anic tsa' ochiyob ti meloñibʌl judíojob ame bib'acob, come yom i cha'leñob we'el che' ti Pascua. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jini cha'an Pilato tsa' loq'ui i pejcañob. Tsi' c'ajtibeyob: ¿Chuqui i mul jini winic? Subula, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tsi' jac'beyob: Machic xjontolil jini winic, ma'anic tsa cʌc'ʌ lojon ti a c'ʌb, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato tsi' subeyob: Pʌyʌla majlel jatetla. Melela che' bajche' ts'ijbubil ti la' mandar, che'en. Jini judíojob tsi' yʌlʌyob: Tic'bilon lojon ti mandar cha'an mach yomic mic tsʌnsan lojon winic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Che'i tsi' yʌlʌyob judíojob cha'an mi' ts'ʌctiyel i t'an Jesús tsa' bʌ i yʌlʌ bajche' mi' caj ti chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jini cha'an Pilato tsa' cha' ochi ti meloñibʌl. Tsi' pʌyʌ tilel Jesús. Tsi' c'ajtibe: ¿Jatet ba i Reyet judíojob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús tsi' jac'ʌ: ¿Tilem ba jini t'an ti a bajñel pusic'al, o am ba majch tsi' ñaxan subeyet? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato tsi' jac'ʌ: ¿Judíojon ba? A pi'ʌlob ti a lumal yic'ot ñuc bʌ motomajob tsi' yʌc'ʌyetob tij c'ʌb. ¿Chuqui tsa' cha'le? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús tsi' jac'ʌ: Mach wʌ'ic ch'oyol c yumʌntel ti pañimil. Wʌ'ic ch'oyol tsa'ʌch i cha'leyob guerra c winicob cha'an ma'anic mi cʌjq'uel ti' c'ʌb judíojob. Pero mach wʌ'ic ch'oyol c yumʌntel, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jini cha'an Pilato tsi' c'ajtibe: ¿Reyet ba che' jini? che'en. Jesús tsi' jac'ʌ: Reyon cu, che' bajche' wola' wʌl. Jini cha'an tsa quila pañimil. Jini cha'an tsa' tiliyon ti pañimil cha'an mi cʌc' ti cʌjñel i sujmlel Dios. Pejtelel majqui mi' ñop i sujmlel mi' yubin c t'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato tsi' sube: ¿Chuqui i sujmlel? che'en. Che' bʌ tsa' ujti i sub jini t'an, tsa' cha' loq'ui i pejcan judíojob. Tsi' subeyob: Tsaj q'uele ma'anic i mul jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","C tilelʌch che' ti' yorajlel Pascua mi cʌc' ti colel juntiquil xñujp'el. ¿La' wom ba mi cʌc' ti colel i Rey judíojob? che'en Pilato. ");
INSERT INTO ctuBl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jini cha'an tsi' cha' cha'leyob c'am bʌ t'an. Tsi' yʌlʌyob: Mach jiniqui. La' colic Barrabás, che'ob. Xujch' jini Barrabás. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jini cha'an Pilato tsi' chucu majlel Jesús. Tsi' jats'ʌ ti asiyal. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jini soldadojob tsi' xot jalʌyob ch'ix. Tsi' joy ñet'beyob ti' jol Jesús. Tsi' lʌpbeyob chʌccojan bʌ pʌl bʌ bujcʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tsi' subeyob: Cotañet, i Reyet judíojob, che'ob. Tsi' poch'iyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato tsa' cha' loq'ui i pejcañob. Tsi' subeyob: La' wilan wolic pʌybeñetla tilel jini winic cha'an mi la' ña'tan ma'anic i mul che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tsa' loq'ui tilel Jesús ñet'el ti' jol jini xotol bʌ ch'ix. Lʌpʌl i cha'an chʌccojan bʌ pʌl bʌ bujcʌl. Pilato tsi' subeyob: Q'uelela jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jini ñuc bʌ motomajob yic'ot jini xcʌntayajob che' bʌ tsi' q'ueleyob, c'am tsi' yʌlʌyob: Ch'iji ti cruz, ch'iji ti cruz, che'ob. Pilato tsi' subeyob: Pʌyʌla majlel jatetla. Ch'ijila ti cruz. Mi cʌl ma'anic i mul jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jini judíojob tsi' jac'ʌyob: An lojon c mandar. Ts'ijbubil tic mandar wersa mi' chʌmel, come tsi' subu i bʌ ti' Yalobil Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ñumen cabʌl tsi' cha'le bʌq'uen Pilato che' bʌ tsi' yubi jini t'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tsa' cha' ochi Pilato ti meloñibʌl. Tsi' c'ajtibe Jesús: ¿Baqui ch'oyolet? che'en. Jesús ma'anic tsi' jac'be. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato tsi' sube: ¿Mach ba anic ma' jac'beñon c t'an? ¿Mach ba a wujilic an c p'ʌtʌlel cha'an mic ch'ijet ti cruz? An c p'ʌtʌlel ja'el cha'an mi cʌq'uet ti colel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús tsi' jac'ʌ: Machic tsi' yʌq'ueyet a p'ʌtʌlel jini am bʌ ti chan, ma'anic a p'ʌtʌlel cha'an ma' contrajiñon. Jini cha'an jini tsa' bʌ i yʌc'ʌyon ti a c'ʌb ñumen an i mul, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jini cha'an Pilato tsi' ñopo i col. Jini judíojob c'am tsi' yʌlʌyob: Mi tsa' colo Jesús, mach i pi'ʌletic César. Jini mu' bʌ i sub i bʌ ti Rey, mi' contrajin César, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Che' bʌ tsi' yubi jini t'an Pilato, tsi' pʌyʌ tilel Jesús. Tsa' buchle ti' buchlib cha'an meloñel, ac'bil bʌ ya' ti ts'ajc i c'aba' Gabata ti' t'an hebreo. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","I q'uiñilelix chajpaya che' mi caj i melob Pascua. Che' bajche' ti xinq'uiñil. Pilato tsi' sube judíojob: Q'uele la' Rey, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Wen c'am tsi' cha'leyob t'an: ¡La' chʌmic, la' chʌmic, ch'iji ti cruz! che'ob. Pilato tsi' c'ajtibeyob: ¿Yom ba mic ch'ij ti cruz la' Rey? che'en. Jini ñuc bʌ motomajob tsi' jac'ʌyob: Ma'anic lojon c rey, jini jach César, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jini cha'an Pilato tsi' yʌc'ʌ Jesús cha'an mi' ch'ijtʌl ti cruz. Tsi' chucuyob majlel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Tsi' q'ueche majlel i cruz. Tsa' c'oti ti bujtʌl i c'aba' Calavera. Ti' t'an hebreojob jiñʌch Gólgota. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ya'i tsi' ch'ijiyob ti cruz yic'ot cha'tiquil, jujuntiquil ti jujunwejl. Xinlʌpʌl Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato tsi' cha'le ts'ijb. Tsi' yʌc'ʌ ti' jol cruz. Jiñʌch jini ts'ijbubil bʌ: JESUS CH'OYOL BɅ TI NAZARET, I REY JUDIOJOB. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Cabʌl judíojob tsi' q'ueleyob jini ts'ijbubil bʌ, come jini bujtʌl ba' tsa' ch'ijle ti cruz Jesús lʌc'ʌl jach an ti tejclum. Ts'ijbubil ti' t'an hebreo, yic'ot ti t'an griego, yic'ot ti' t'an latín. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jini ñuc bʌ motomajob cha'an judíojob tsi' subeyob Pilato: Mach a ts'ijban jini t'an, “I Rey judíojob”. Ts'ijban, “Tsi' subu i bʌ ti' Rey judíojob”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato tsi' jac'beyob: Jini tsa' bʌ c ts'ijba, ts'ijbubilix, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Che' bʌ tsa' ujti i ch'ijob Jesús ti cruz, jini soldadojob tsi' ch'ʌmbeyob i pislel. Tsi' t'oxoyob ti chʌmp'ejl, jujump'ejl cha'an jujuntiquil soldado. Tsi' ch'ʌmʌyob ja'el pʌl bʌ i bujc Jesús. Mach ts'isbilic. Jalbil jach ti pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tsi' subeyob i bʌ: Mach yomic mi lac tsil. La' lac cha'len yajcaya ti alas cha'an mi lac ña'tan majqui mi caj i ch'ʌm, che'ob. Che'ʌch tsi' yʌlʌyob cha'an mi' ts'ʌctiyel i Ts'ijbujel Dios mu' bʌ i yʌl: “Tsi' pucbeyob i bʌ c pislel. Tsi' cha'leyob yajcaya ti alas cha'an c bujc”. Che'i tsi' meleyob soldadojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ya' wa'alob ti' t'ejl cruz i ña' Jesús yic'ot i yijts'in i ña', yic'ot i yijñam Cleofas, i c'aba' María, yic'ot María ch'oyol bʌ ti Magdala. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús che' bʌ tsi' q'uele i ña' yic'ot jini xcʌnt'an c'uxbibil bʌ i cha'an, tsi' sube i ña': X'ixic, q'uele a walobil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ti wi'il tsi' sube jini xcʌnt'an: Q'uele a ña', che'en. Ti jini jach bʌ ora jini xcʌnt'an tsi' pʌyʌ majlel i ña' Jesús ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yujilix Jesús ts'ʌctiyemix ti pejtelel. Tsi' yʌlʌ cha'an mi' ts'ʌctiyel i Ts'ijbujel Dios: Tiquinix c ti', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ya'an jump'ejl tsima but'ul ti vinagre. Tsi' ts'ajayob chʌyo'ja' ti vinagre. Tsi' yʌc'ʌyob ti' ñi' te' i c'aba' hisopo. Tsi' yʌq'ueyob ti' yej. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Che' bʌ tsa'ix i ch'ʌmʌ jini vinagre Jesús, tsi' yʌlʌ: Tsa'ix ts'ʌctiyi, che'en. Tsi' ju'sa i jol. Tsi' yʌc'ʌ ti loq'uel i ch'ujlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","I q'uiñilelix chajpaya che' woli' melob Pascua. Jini cha'an mach yomobic judíojob mi' cʌytʌl i bʌc'tal jini chʌmeño' bʌ ti cruz che' ti' q'uiñilel c'aj o, come jiñʌch ñuc bʌ q'uin. Jini cha'an tsi' c'ajtibeyob Pilato cha'an mi' yʌc' ti c'ʌsbentelob i ya' cha'an mi' ch'ʌjmelob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tsa' tiliyob soldadojob. Tsi' c'ʌsbeyob i ya' jini ñaxan bʌ, yic'ot i ya' yambʌ winic ch'ijbil bʌ ti cruz yic'ot Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Che' bʌ tsa' tiliyob ba'an Jesús, tsi' q'ueleyob chʌmenix. Jini cha'an ma'anic tsi' c'ʌsbeyob i ya'. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Juntiquil soldado tsi' jeq'ue ti yebal i ch'i'lat yic'ot i lanza. Ti ora jach tsa' loq'ui i ch'ich'el yic'ot ja'. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jini tsa' bʌ i q'uele woli' cha' sub. Isujmʌch i t'an. Yujil isujm chuqui mi' yʌl cha'an mi la' ñop jatetla ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tsa' ujti ti pejtelel cha'an mi' ts'ʌctiyel i Ts'ijbujel Dios: “Ma'anic mi caj i c'ʌscujel mi junts'ijtic i bʌquel”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","I Ts'ijbujel Dios mi' yʌl ja'el: “Jini tsa' bʌ i jeq'ueyob mi caj i cha' q'uelob”. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Juntiquil xcʌnt'an i cha'an Jesús, i c'aba' José ch'oyol bʌ ti Arimatea, tsi' ñopo Jesús ti mucul jach, come tsi' bʌc'ña judíojob. Che' bʌ tsa' ujti ili tac, José tsi' c'ajtibe Pilato i bʌc'tal Jesús. Pilato tsi' yʌc'ʌ i t'an. Tsa' majli José. Tsi' ch'ʌmʌ majlel i bʌc'tal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tsa' tili Nicodemo ja'el, tsa' bʌ tili ba'an Jesús ti ac'ʌlel. Tsi' ch'ʌmʌ tilel mirra xʌbʌl yic'ot áloes, che' bajche' juncujch. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tsi' ch'ʌmʌyob majlel i bʌc'tal Jesús. Tsi' bʌc'ʌyob ti wen bʌ pisil yic'ot xojocña bʌ ts'ac, come i tilel che'ʌch mi' cha'leñob mucoñel judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ya' ba' tsa' ch'ijle ti cruz Jesús an pʌc'ʌbʌl. Ya' ti pʌc'ʌbʌl an tsiji' bʌ i yotlel ch'ujlelʌl ba' maxto ac'bilic winic. ");
INSERT INTO ctuBl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","I yorajlelix chajpaya che' mi' melob Pascua judíojob. Lʌc'ʌl jach an i yotlel ch'ujlelʌl, jini cha'an ya' tsi' ñolchocoyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ti ñaxan bʌ q'uin ti semana che' ic' to, tsa' tili María ch'oyol bʌ ti Magdala ti' yotlel ch'ujlelʌl. Tsi' q'uele loc'sʌbilix xajlel ti' yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tsa' majli ti ajñel. Tsa' tili ba'an Simón Pedro yic'ot yambʌ xcʌnt'an, jini c'uxbibil bʌ ti Jesús. María tsi' subeyob: Tsa'ix i ch'ʌmʌyob loq'uel lac Yum ti' yotlel ch'ujlelʌl. Mach cujilic lojon baqui tsi' yʌc'ʌyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tsa' loq'ui majlel Pedro yic'ot jini yambʌ xcʌnt'an. Tsa' majliyob ti' yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Temel tsi' cha'leyob ajñel. Jini yambʌ xcʌnt'an tsi' ñusa Pedro ti ajñel. Tsa' c'oti ti ñaxan ba'an i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tsi' c'uchchoco i bʌ cha'an mi' q'uel. Tsi' q'uele ya' ac'bil jini wen bʌ i pislel Jesús. Ma'anic tsa' ochi. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ti ora tsa' c'oti Simón Pedro ti wi'ipat. Tsa' ochi ti' yotlel ch'ujlelʌl. Tsi' q'uele ya' ac'bil jini wen bʌ i pislel Jesús ");
INSERT INTO ctuBl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yic'ot i tejp'il i jol. Mach ya'ic an i tejp'il i jol yic'ot i pislel. Partejʌch an. Bʌlbil. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tsa' ochi jini yambʌ xcʌnt'an ja'el, tsa' bʌ c'oti ti ñaxan ti' yotlel ch'ujlelʌl. Tsi' q'uele, tsi' ñopo. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Come maxto anic tsi' ch'ʌmbeyob isujm i Ts'ijbujel Dios cha'an wersa mi' cha' ch'ojyel loq'uel Jesús ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jini xcʌnt'añob tsa' cha' sujtiyob ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ya' wa'al María ti jumpat ti' yotlel ch'ujlelʌl, woli ti uq'uel. Tsi' c'uchchoco i bʌ cha'an mi' q'uel i mal i yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Tsi' q'uele cha'tiquil ángelob lʌpʌl i cha'añob sʌsʌc bʌ i pislel. Juntiquil buchul ti' jol, yambʌ buchul ti' yoc baqui tsa' ajq'ui i bʌc'tal Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jini ángelob tsi' subeyob: X'ixic, ¿chucoch woliyet ti uq'uel? che'ob. María tsi' subeyob: Cha'an tsi' ch'ʌmʌyob majlel c Yum. Mach cujilic baqui tsi' yʌc'ʌyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Che' bʌ tsa' ujti i sub jini t'an, tsi' sutq'ui i bʌ María. Tsi' q'uele Jesús. Ya' wa'al. Mach yujilic María mi jiñʌch Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús tsi' sube: X'ixic, ¿chucoch woliyet ti uq'uel? ¿Majqui wola' sajcan? che'en. María tsi' yʌlʌ ti' pusic'al, tic'ʌl mi jiñʌch x'e'tel cha'an pʌc'ʌbʌl. Tsi' sube: Mi tsa' ch'ʌmʌ majlel, subeñon baqui tsa' wʌc'ʌ cha'an mic ch'ʌm majlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús tsi' yʌlʌ: María, che'en. Tsi' sutq'ui i bʌ i q'uel. Tsi' sube: Raboni, che'en. (Jini mi' yʌl ti lac t'an, Maestro.) ");
INSERT INTO ctuBl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús tsi' sube: Mach a chʌn chucon, come maxto anic tsa' letsiyon majlel ba'an c Tat. Cucu ba'an quermanojob. Subeñob: “Mic letsel majlel ba'an c Tat, jiñʌch la' Tat ja'el. Mic letsel majlel ba'an c Dios, jiñʌch la' Dios ja'el”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María ch'oyol bʌ ti Magdala tsa' majli i subeñob xcʌnt'añob cha'an tsa'ix i q'uele lac Yum. Tsi' subeyob chuqui tsi' yʌlʌ lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Che' wolix i yic'an ti ñaxan bʌ q'uin ti semana, tsa' tili Jesús ba'an xcʌnt'añob. Ñup'ul i ti' otot ba' temel añob xcʌnt'añob, come woli' bʌc'ñañob judíojob. Tsa' c'oti Jesús. Ya' wa'al ti yojlilob, tsi' subeyob: La' ñʌch'lec la' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Che' bʌ tsa' ujti i sub jini t'an, tsi' pʌsbeyob i c'ʌb yic'ot i yebal i ch'i'lat. Tijicña tsi' yubiyob xcʌnt'añob che' bʌ tsi' q'ueleyob lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús tsi' cha' subeyob: La' ñʌch'lec la' pusic'al. Che' bajche' c Tat tsi' chocoyon tilel, che' ja'el mic choquetla majlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Che' bʌ tsa' ujti i sub jini t'an, tsi' wujtayob. Tsi' subeyob: Ch'ʌmʌla jini Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Majqui jach mi la' ñusʌben i mul, ñusʌbilʌch. Majqui jach ma'anic mi la' ñusʌben i mul, mach ñusʌbilic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Che' bʌ tsa' tili Jesús, mach ya'ic an Tomás yic'otob. Tomás, i pi'ʌl jini junlujuntiquil. Mi' pejcʌntel ti xloj. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jini cha'an tsi' subeyob yambʌ xcʌnt'añob: Tsa'ix j q'uele lojon lac Yum, che'ob. Tomás tsi' subeyob: Mi ma'anic mij q'uel i yejtal lawux ti' c'ʌb, mi ma'anic mi cotsan i yal j c'ʌb ti' yejtal lawux, mi ma'anic mi cotsan j c'ʌb ti' yebal i ch'i'lat, ma'anic mi caj c ñop, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tsa' ñumi waxʌcp'ejl q'uin. Cha' ya'ix añob xcʌnt'añob i cha'an ti' mal otot, ya'an Tomás yic'otob. Tsa' ochi Jesús che' ñup'ul i ti' otot. Ya' tsa' wa'le ti yojlilob. Jesús tsi' subeyob: La' ñʌch'lec la' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jesús tsi' sube Tomás: Otsan i yal a c'ʌb ilayi. Q'uele j c'ʌb. Sʌts'ʌ a c'ʌb, otsan ti' yebal c ch'i'lat. Mach yomic tsʌts a pusic'al. Ñopoyon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomás tsi' jac'be: C Yum, c Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús tsi' sube: Cha'an jach tsa' q'ueleyon, tsa' ñopoyon. Tijicñayob jini tsa' bʌ i ñopoyoñob che' maxto anic tsi' q'ueleyoñob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","An to cabʌl i yejtal i p'ʌtʌlel tsa' bʌ i pʌsʌ Jesús ti' tojlel xcʌnt'añob i cha'an. Mach ts'ijbubilic ti jini jun. ");
INSERT INTO ctuBl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Tsa' ts'ijbunti ili i yejtal tac i p'ʌtʌlel cha'an mi la' ñop Cristojʌch jini Jesús. I Yalobilʌch Dios. Tsa' ts'ijbunti cha'an, mi la' wʌq'uentel la' cuxtʌlel ti' c'aba' che' mi la' ñop. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ti wi'il Jesús tsi' cha' pʌsʌ i bʌ ti' wut xcʌnt'añob i cha'an ti ñajb ya' ti Tiberias. Che'ʌch tsi' pʌsʌ i bʌ bajche' wolic ts'ijbubeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Temelobix Simón Pedro yic'ot Tomás, jini mu' bʌ i pejcʌntel ti xloj, yic'ot Natanael, jini ch'oyol bʌ ti Caná ya' ti Galilea, yic'ot i yalobilob Zebedeo yic'ot yambʌ cha'tiquil xcʌnt'añob i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón tsi' subeyob: Mic majlel ti chuc chʌy, che'en. I pi'ʌlob Simón tsi' subeyob: Mic majlel lojon quic'otet ja'el, che'ob. Tsa' majliyob. Tsa' ochiyob ti barco. Ti pejtelel ac'ʌlel ma'anic chuqui tsi' chucuyob. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Che' bʌ tsa' sʌc'a, tsa' wa'le Jesús ti' ti' ja'. Jini xcʌnt'añob mach yujilobic mi jiñʌch Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús tsi' subeyob: Calobilob, ¿am ba chuqui mi laj c'ux? che'en. Tsi' jac'beyob: Ma'anic, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús tsi' subeyob: Chocola ochel la' chim ti la' ñoj ti' ts'ejtʌlel barco. Ya'i mi caj la' taj, che'en. Ti ora tsi' chocoyob ochel. Ma'anic tsa' mejli i cha' chucob loq'uel, come wen cabʌl jini chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jini xcʌnt'an c'uxbibil bʌ i cha'an Jesús, tsi' sube Pedro: Jiñʌch lac Yum, che'en. Simón Pedro che' bʌ tsi' yubi ya'an i Yum, tsi' lʌpʌ i bujc, come jochol i cha'an. Tsi' choco ochel i bʌ ti ñajb. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yambʌ xcʌnt'añob tsa' tiliyob ti barco, come mach ñajtic añob ti' ti' ñajb. Tic'ʌl mi an uxc'al jach ti jajl. Woli' tujc'añob tilel jini chim but'ul ti chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Che' bʌ tsa' c'otiyob ti' ti' ñajb, tsi' q'ueleyob xic'bilix c'ajc. Ya' c'ʌcʌl chʌy yic'ot waj. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús tsi' subeyob: Ch'ʌmʌla tilel lamital jini chʌy tsa' bʌ ujti la' chuc, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Tsa' ochi ti barco Simón Pedro. Tsi' tujc'a loq'uel chim ti' ti' ñajb. But'ul jini chim ti colem chʌy, uxlujuncojt i waxʌcc'al (153). Anquese wen on, ma'anic tsa' ts'ojqui jini chim. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús tsi' subeyob: La' cu la ti we'el, che'en. Jini xcʌnt'añob ma'anic tsi' c'ajtibeyob: ¿Majquiyet? come yujilobix jiñʌch lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tsa' tili Jesús. Tsi' ch'ʌmʌ waj. Tsi' yʌq'ueyob. Che' ja'el chʌy. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jiñʌch i yuxyajlel tsi' pʌsʌ i bʌ Jesús ti' wut xcʌnt'añob i cha'an che' ch'ojyemix loq'uel ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Che' bʌ tsa' ujtiyob ti we'el, Jesús tsi' sube Simón Pedro: Simón, i yalobilet bʌ Juan, ¿ñumen c'ux ba ma' wubiñon bajche' jini? Pedro tsi' sube: Ñumen cu, c Yum, a wujil mij c'uxbiñet. Jesús tsi' sube: Aq'uen i buc'bal calʌ tiñʌme', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús tsi' cha' c'ajtibe Simón ti' cha'yajlel: Simón, i yalobilet bʌ Juan, ¿c'ux ba ma' wubiñon? che'en. Tsi' jac'be: C'ux cu, c Yum. A wujil mij c'uxbiñet, che'en. Tsi' cha' sube: Cʌntan c tiñʌme' che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesús tsi' cha' c'ajtibe ti' yuxyajlel: Simón, i yalobilet bʌ Juan, ¿mu' ba a c'uxbiñon? che'en. Pedro tsa' caji i mel i pusic'al come tsi' c'ajtibe ti' yuxyajlel: “¿Mu' ba a c'uxbiñon?” Tsi' sube: C Yum, a wujil pejtelel chuqui tac an. A wujil mij c'uxbiñet. Jesús tsi' sube: Aq'uen i buc'bal c tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Isujm, isujm mic subeñet: Che' bʌ ch'itoñet to, tsa' lʌpʌ a bujc, tsa' majliyet baqui jach yom a pusic'al. Che' ñoxetix mi caj a sʌts' a c'ʌb. Yambʌ mi caj i lʌpbeñet a bujc. Mi caj i pʌyet majlel ba' mach a womic majlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jesús tsi' sube jini t'an cha'an mi' ch'ʌmben isujm bajche' mi caj i pʌs i ñuclel Dios Pedro che' mi' chʌmel.) Subilix jini t'an, Jesús tsi' cha' sube: Tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tsi' sutq'ui i bʌ Pedro. Tsi' q'uele jini xcʌnt'an woli bʌ i tsajcañob, jini c'uxbibil bʌ i cha'an Jesús tsa' bʌ buchle ti' t'ejl Jesús che' bʌ tsi' c'uxuyob waj. Jiñʌch tsa' bʌ i sube: “C Yum, ¿majqui mi caj i yʌq'uet ti' c'ʌb a contra?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Che' bʌ tsi' q'uele jini xcʌnt'an, Pedro tsi' sube Jesús: C Yum, ¿jixcu jini winic chuqui mi caj i yubin? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús tsi' sube: Mi com mi' cʌytʌl ili winic jinto mic cha' tilel, mach a wentajic. Tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jini cha'an tsa' caji i yʌlob i pi'ʌlob, ma'anic mi' cajel ti chʌmel jini xcʌnt'an. Pero Jesús ma'anic tsi' sube jini xcʌnt'an ma'anic mi' cajel ti chʌmel. Tsa' jach i yʌlʌ: “Mi com mi' cʌytʌl jinto mic cha' tilel, mach a wentajic”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jiñʌch jini xcʌnt'an woli bʌ i tsictesan ili tac. Tsi' ts'ijba pejtelel ili tac. La cujil isujm i t'an mu' bʌ i sub. ");
INSERT INTO ctuBl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","An to cabʌl chuqui tsi' cha'le Jesús. Mi tsa' laj ts'ijbunti ti pejtelel i melbal, mi cʌl mach ochic wʌ' ti pañimil pejtelel jini jun mu' bʌ i ts'ijbuntel.");
INSERT INTO ctuBl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ti yambʌ jun, Teófilo, tsac ts'ijbubeyet pejtelel chuqui tac tsa' caji i mel Jesús, yic'ot chuqui tsa' caji i cʌntesan ");
INSERT INTO ctuBl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","c'ʌlʌl ti jini q'uin che' bʌ tsa' pʌjyi letsel. Che' bʌ tsa' ujti i yʌq'ueñob mandar jini apóstolob yajcʌbilo' bʌ i cha'an, Jesús tsi' yʌq'ueyob mandar ti' p'ʌtʌlel jini Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Che' cha' cuxulix Jesús, che' bʌ tsa' ujti i yubin wocol, tsi' cha' pʌsʌ i bʌ ti' tojlel jini chocbilo' bʌ majlel ti subt'an. Wen tsiquil i sujmlel. Cha'c'al q'uin tsi' pʌsʌ i bʌ ti' tojlel ili winicob. Tsi' subeyob bajche' an i yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Che' temel añob tsi' subeyob: Mach yomic mi la' loq'uel ti Jerusalén. Yom ya'i mi la' pijtan jini subil bʌ i cha'an lac Tat mu' bʌ caj i yʌq'ueñetla. Joñon tsac subeyetla ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan tsi' yʌq'ueyetla ch'ʌmja'. Pero Dios mach jalix mi caj i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ Espíritu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jini cha'an jini tempʌbilo' bʌ tsi' c'ajtibeyob: C Yum, ¿mu' ba caj a cha' wa'chocon i yumʌntel Israel ti ili ora? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús tsi' subeyob: Mach la' wentajic baqui bʌ ora mi baqui bʌ q'uin mi caj i yujtel jini, come lac Tat tsi' yotsa ti' bajñel wenta. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero mi caj la' wʌq'uentel la' p'ʌtʌlel che' mi' yochel jini Ch'ujul bʌ Espíritu ti la' pusic'al. Ya' ti Jerusalén yic'ot ti pejtelel Judea yic'ot ti Samaria c'ʌlʌl ti ñajt bʌ pañimil mi caj la' sub chuqui tsa' la' q'uele, che'en Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Che' bʌ tsa' ujti i sub jini t'an Jesús, che' woli to i q'uelob, tsa' pʌjyi letsel. Tsa' mʌjqui ti tocal. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Che' woli' chʌn q'uelob panchan, che' woli ti letsel Jesús, tsa' wa'leyob ti lʌc'ʌl cha'tiquil winicob sʌsʌc bʌ i pislel. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tsi' subeyob: Winicob, ch'oyolet bʌ la ti Galilea, ¿chucoch woli la' chʌn q'uel panchan? Jini Jesús, tsa' bʌ pʌjyi letsel ti panchan loq'uem bʌ ti la' tojlel, mi caj i cha' tilel che' bajche' tsa' la' q'uele che' bʌ tsa' majli ti panchan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tsa' sujtiyob winicob ti Jerusalén. Tsi' cʌyʌyob wits i c'aba' Olivos lʌc'ʌl ti Jerusalén. Che'ʌch i ñajtlel bajche' ojlil legua. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Che' ochemobix ti otot, tsa' letsiyob ti yambʌ junlajm i mal otot ti chan ba' woli' jijlelob Pedro yic'ot Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo i yalobil Alfeo, yic'ot Simón Zelotes, yic'ot Judas i yijts'in Jacobo. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ti pejtelelob ti jump'ejl jach i pusic'al woli' chʌn pejcañob Dios yic'ot x'ixicob yic'ot María, i ña' Jesús, yic'ot i yijts'iñob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ti jim bʌ ora Pedro tsa' wa'le ti ojlil ba'an hermanojob. (Tic'ʌl mi wʌcc'alob ya' añob.) Pedro tsi' subu: ");
INSERT INTO ctuBl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Quermanojob, wersa mi' ts'ʌctiyel i Ts'ijbujel Dios che' bajche' tsi' yʌlʌ jini Ch'ujul bʌ Espíritu ti wajali ti' yej David cha'an Judas. Jiñʌch Judas tsa' bʌ i toj'esa majlel winicob tsa' bʌ i chucuyob Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Come jini Judas tsa' tsijqui quic'ot lojon. Tsa' aq'uenti i ye'tel ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tsa' mʌjñi jamil yic'ot i tojol i mul. Xitil tsa' yajli. Tsa' tojmi i ñʌc', tsa' loq'ui i soyta'. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Pejtelel año' bʌ ti Jerusalén tsi' yubiyob chuqui tsa' ujti. Jini cha'an jini jamil tsa' otsʌbenti i c'aba' Acéldama, jiñʌch jamil mʌmbil bʌ ti' tojol i ch'ich'el winic. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Come ts'ijbubil ti' juñilel Salmo tac: “La' jochtiyic i chumlib, mach mi' chʌn ajñel winic ya'i”. Ts'ijbubil ja'el: “Jini i ye'tel la' to i ch'ʌm yambʌ winic”. Che'ʌch ts'ijbubil. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Yom wa'chocontic juntiquil tsa' bʌ i pi'leyonla ti xʌmbal c'ʌlʌl che' bʌ tsa' ochi lac Yum Jesús ti lac tojlel c'ʌlʌl che' bʌ tsa' loq'ui ti lac tojlel, ");
INSERT INTO ctuBl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","juntiquil tsa' bʌ i pi'leyonla ti xʌmbal c'ʌlʌl che' bʌ tsi' yʌc'ʌ ch'ʌmja' Juan, c'ʌlʌl ti jini q'uin che' bʌ tsa' pʌjyi letsel Jesús ti lac tojlel. Juntiquil ili wʌ' bʌ an la quic'ot wersa mi' yʌq'uentel i ye'tel testigo quic'ot lojon cha'an mi' sub ti isujm tsa' cha' ch'ojyi Jesús. Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Tsi' yajcayob cha'tiquil: José yic'ot Matías. I cha'chajplel i c'aba' José jiñʌch Justo. I jol i c'aba' jiñʌch Barsabás. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Tsi' pejcayob Dios. Tsi' yʌlʌyob: Jatet, c Yum, ma' cʌmben i pusic'al pejtelel winicob. Wʌ'an cha'tiquil. Pʌsʌ baqui bʌ ma' yajcan ");
INSERT INTO ctuBl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","cha'an mi' ch'ʌm i ye'tel ti apóstol tsa' bʌ i cʌyʌ Judas cha'an i mul cha'an mi' majlel ti' yajñib, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Tsi' cha'leyob yajcaya ti alas. Tsa' yajcʌnti Matías. Jini cha'an tsa' tsijqui yic'ot jini junlujuntiquil chocbilo' bʌ majlel ti subt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Che' i yorajlelix i q'uiñilel Pentecostés, temel añob ti pejtelel ti jump'ejl jach ajñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ti ora jach tsa' loq'ui t'an ti panchan che' bajche' ju'ucña bʌ ic'. Tsa' ubinti ti pejtelel jini otot ba' buchulob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ya' ti' tojlel tsa' tsictiyi cabʌl pujquem bʌ alʌ c'ajc. Che' yilal bajche' la cac'. Tsa' c'oti ti' pamob i jol ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Tsa' laj bujt'iyob ti Ch'ujul bʌ Espíritu. Tsa' cajiyob ti t'an ti yan tac bʌ t'an che' bajche' tsi' yʌq'ueyob t'an jini Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ya' añob ti Jerusalén judíojob mu' bʌ i ch'ujutesañob Dios. Ch'oyolob ti jujump'ejl lum tac ti yebal panchan. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Che' bʌ tsi' yubiyob jini ju'ucña bʌ t'an, cabʌl winicob x'ixicob tsi' tempayob i bʌ. Ma'anic tsi' ña'tayob chuqui woli' yujtel, come ti jujuntiquilob tsi' yubiyob i bajñel t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tsa' toj sajtiyob i pusic'al. Tsi' yʌlʌyob: Awilan, ¿mach ba ch'oyolobic ti Galilea pejtelel ili winicob woliyo' bʌ ti t'an? ");
INSERT INTO ctuBl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Bajche' che' jini ti jujuntiquilonla woli la cubin lac t'an tsa' bʌ lac ñopo ti lac ñojte'el? ");
INSERT INTO ctuBl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ch'oyolonla ti Partia, yic'ot ti Media, yic'ot ti Elam, yic'ot ti Mesopotamia, yic'ot ti Judea, yic'ot ti Capadocia, ti Ponto, ti Asia, ");
INSERT INTO ctuBl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ti Frigia, ti Panfilia, ti Egipto, ya' ti yan tac bʌ pañimil ti Africa ti yambʌ junwejl Cirene. Wʌ' añob ja'el romanojob ti lac tojlel. Lamital tsi' q'ueleyob pañimil tic lumal lojon. Yaño' bʌ tsi' sutq'uiyob i bʌ ti judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wʌ' añob ja'el tilemo' bʌ ti Creta yic'ot ti Arabia. Ti pejtelelonla mi la cubin ti lac t'an jini ñuc bʌ i ye'tel Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tsa' toj sajtiyob i pusic'al. Ma'anic tsi' ch'ʌmbeyob isujm chuqui woli' yujtel. Tsa' caji i c'ajtibeñob i bʌ: ¿Chuqui i sujmlel jini? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yaño' bʌ tsi' wajleyob: Yʌcobix ti lembal, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pedro tsa' wa'le yic'ot jini junlujuntiquil. C'am tsi' chale t'an. Tsi' subeyob: Winicob israelob yic'ot pejtelel añet bʌ la ti Jerusalén, ubinla c t'an, ñopola. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Come ili winicob mach yʌcobic che' bajche' mi la' ña'tan ti la' pusic'al, come bolomp'ejl jax to ora. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jiñʌch chuqui tsi' subu jini x'alt'an Joel: ");
INSERT INTO ctuBl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Dios mi' yʌl: Ti jini cojix bʌ q'uin tac mi caj cʌq'ueñob quEspíritu pejtelel winicob x'ixicob. La' walobilob mi caj i cha'leñob alt'an. Ch'iton winicob mi caj i q'uelob chuqui mi' pʌsbentelob ti espíritu. Xñoxob la' cha'an mi caj i ñajleñob chuqui tac tal. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Isujm ti jim bʌ ora mi caj cʌq'ueñob quEspíritu c winicob. Mi caj i cha'leñob alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi caj c pʌs bʌbʌq'uen tac bʌ ti panchan yic'ot i yejtal tac c p'ʌtʌlel ti pañimil, ch'ich' yic'ot c'ajc yic'ot buts'. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jini q'uin mi cajel i yiq'uesʌntel, jini uw mi caj i chʌc'an che' bajche' ch'ich', che' maxto tilemic i q'uiñilel lac Yum, jini ñuc bʌ q'uin mu' bʌ caj i tilel. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mi caj i yujtel che' an majqui mi' pejcan lac Yum ti' c'aba, mi caj i coltʌntel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Winicob ti Israel, ubinla jini t'an. Dios tsi' pʌsbeyetla uts'at jini Jesús ch'oyol bʌ ti Nazaret. Come Dios tsi' c'ʌñʌ cha'an mi' cha'len ñuc bʌ i melbal yic'ot bʌbʌq'uen tac bʌ yic'ot i yejtal tac i p'ʌtʌlel ti la' tojlel che' bajche' la' wujil. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jini Jesús tsa' ajq'ui ti' c'ʌb winicob che' bajche' tsi' yʌlʌ Dios ti wajali. Dios tsi' wʌn ña'ta chuqui mi' caj ti ujtel. Jatetla tsa'ix la' xic'be xñusa mandarob cha'an mi' chucob Jesús. Tsi' ch'ijiyob ti cruz. Tsi' tsʌnsayob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Che' chʌmenix Jesús, Dios tsi' teche ch'ojyel, come ma'anic tsa' mejli ti cʌytʌl ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Come David tsi' yʌlʌ jini t'an cha'an Jesús: “Tsaj q'uele c Yum ti pejtelel ora ti' tojel c wut, come an tic ñoj cha'an xuc'ul mi cajñel. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jini cha'an tijicña c pusic'al tsa cubi, tijicña mic cha'len t'an. C bʌc'tal mi caj i yajñel ti pijtaya, ");
INSERT INTO ctuBl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","come ma'anic mi caj a cʌy c ch'ujlel ba'an chʌmeño' bʌ, ma'anic mi caj a wʌc' ti oc'mʌl jini Ch'ujul Bʌ a cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tsa'ix a pʌsbeyon i bijlel j cuxtʌlel. Mi caj a ñuq'uesan c pusic'al cha'an añet quic'ot”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Winicob c pi'ʌlob, mic subeñetla ti isujm, lac tat David tsa' chʌmi. Tsa' mujqui ti' yotlel ch'ujlelʌl. C'ʌlʌl wʌle wʌ'an la quic'ot i yotlel ba' tsa' mujqui. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David tsi' subu jini t'an come x'alt'añʌch. Tsi' ña'ta isujm i t'an Dios tsa' bʌ i sube cha'an juntiquil i p'olbal, come loq'uem ti' p'olbal David jini Cristo mu' bʌ caj i buchchocontel ti' yumʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David tsi' wʌn ña'ta mi caj i cha' ch'ojyel Cristo. Tsi' wʌn ña'ta ma'anic mi caj i cʌytʌl Cristo ba'an chʌmeño' bʌ. Ma'anic mi caj i yoc'mʌl i bʌc'tal ja'el. Jini cha'an David tsi' subu pejtelel jini. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios tsi' teche ch'ojyel Jesús. Tic pejtelel lojon testigojon lojon, tsa'ix j q'uele lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tsa'ix aq'uenti Jesús i ñuclel ti' ñoj Dios. Tsa' ts'ʌctiyi i t'an i Tat tsa' bʌ subenti Jesús cha'an mi caj i yʌc' Ch'ujul bʌ Espíritu. Tsa'ix i yʌc'ʌ che' bajche' woli la' q'uel woli la' wubin. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ma'anic tsa' letsi majlel David ti panchan. Pero tsi' yʌlʌ: “Jini lac Yum tsi' sube c Yum: Buchi' tic ñoj ");
INSERT INTO ctuBl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","jinto mi cʌq'ueñet a t'uchtan a contrajob”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Che' jini, la' i ñopob ti isujm pejtelel winicob ti Israel, Dios tsi' yotsa Jesús ti lac Yum. Jiñʌch Cristo, jini yajcʌbil bʌ, jini Jesús tsa' bʌ la' ch'iji ti cruz. Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Che' bʌ tsa'ix ujti i yubiñob jini t'an, ch'ijiyem i pusic'al tsa' cʌleyob. Tsi' c'ajtibeyob Pedro yic'ot yambʌ apóstolob: Winicob, c pi'ʌlob, ¿chuqui yom mic cha'len lojon? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro tsi' subeyob: Cʌyʌ la' mul, ch'ʌmʌla ja' ti jujuntiquiletla ti' c'aba' Jesucristo, cha'an mi' ñusʌntel la' mul. Che'i mi caj la' wʌq'uentel Ch'ujul bʌ Espíritu ti la' majtan. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Albilix, mi caj la' wʌq'uentel jini Espíritu jatetla yic'ot la' walobilob yic'ot año' bʌ ti ñajtʌl, che' bajche' jaytiquil mi' pʌjyelob tilel cha'an lac Yum Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Anto cabʌl t'an tsa' bʌ i subu Pedro. Tsi' xic'beyob. Tsi' subeyob: Taja la' coltʌntel cha'an mi la' cʌy la' mel che' bajche' sajtemo' bʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jini tsa' bʌ i jac'beyob i t'an tsi' ch'ʌmʌyob ja'. Ti jini jach bʌ q'uin tsa' ochiyob che' bajche' uxp'ejl mil winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tsi' chʌn ubibeyob i cʌntesʌbal jini apóstolob. Tsi' wen c'uxbiyob i bʌ. Tsi' chʌn xet'eyob waj. Tsi' chʌn pejcayob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tsa' cajiyob ti bʌq'uen ti jujuntiquil. Cabʌl ñuc tac bʌ i ye'tel tsi' meleyob jini apóstolob. Tsi' pʌsʌyob cabʌl i yejtal tac i p'ʌtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pejtelel tsa' bʌ i ñopoyob, temel añob. Pejtelel i chubʌ'an i tem cha'añob jach. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tsi' choñoyob i chubʌ'an yic'ot i lum. Tsi' t'oxbeyob i bʌ cha'an mi' yʌq'uentelob jini mach bʌ añobic i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Temel tsa' chʌn ajniyob ti Templo ti jujump'ejl q'uin. Tsi' xet'eyob waj ti' yotot tac. Temel tsi' cha'leyob we'el. Tijicña i pusic'al ti jujuntiquil. Jump'ejlob jach i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tsi' subuyob i ñuclel Dios. Ti pejtelel tejclum uts'at tsi' q'ueleyob winicob x'ixicob. Ti jujump'ejl q'uin lac Yum tsi' p'ojlesa xñopt'añob woli bʌ i coltʌntelob. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Temel tsa' letsiyob majlel Pedro yic'ot Juan ti Templo ti' yorajlel oración ti och'ajel q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Juntiquil winic mach bʌ wenic i yoc c'ʌlʌl che' bʌ tsi' yila pañimil tsa' pʌjyi tilel. Ti jujump'ejl q'uin tsi' yʌc'ʌyob ti' ti' Templo, i c'aba' I T'ojol Bʌ, cha'an mi' c'ajtibeñob taq'uin jini mu' bʌ i yochelob ti Templo. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jini winic, che' bʌ tsi' q'uele Pedro yic'ot Juan woli bʌ i yochelob ti Templo, tsi' c'ajtibeyob taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro yic'ot Juan tsi' q'ueleyob. Pedro tsi' sube: Q'ueleyon lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jini winic tsa' caji i wen q'uelob. Woli' pijtan mi an chuqui mi caj i yʌq'uentel. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Pedro tsi' sube: Ma'anic c taq'uin. Ma'anic c cha'an oro. Jini jach mi cʌq'ueñet chuqui an c cha'an. Ti' c'aba' Jesucristo, jini ch'oyol bʌ ti Nazaret, ch'ojyen, cha'len xʌmbal, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro tsi' chucbe ñoj bʌ i c'ʌb. Tsi' teche ch'ojyel. Ti ora jach tsa' p'ʌt'a i yoc yic'ot i bic' i yoc. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Tsa' xijt'i ch'ojyel. Tsa' wa'le. Tsa' caji ti xʌmbal. Tsa' ochi ti Templo yic'otob. Tsi' cha'le xʌmbal, tsi' cha'le tijp'el. Tsi' subu i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pejtelel winicob x'ixicob tsi' q'ueleyob wolix ti xʌmbal jini winic. Woli' sub i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Tsi' cʌñʌyob jiñʌch tsa' bʌ buchle i c'ajtin taq'uin ya' ti' ti' Templo, i c'aba' I T'ojol Bʌ. Tsa' toj sajtiyob i pusic'al. Tsi' cha'leyob bʌq'uen cha'an jini tsa' bʌ melbenti jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Che' chucbil Juan yic'ot Pedro i cha'an jini winic tsa' bʌ lajmesʌnti, ti ajñel tsa' tiliyob pejtelel winicob x'ixicob ya' bʌ añob ti corredor i cha'an Salomón. Tsa' toj sajtiyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro che' bʌ tsi' q'ueleyob tsi' subeyob: Winicob ti Israel, ¿chucoch mi' toj sajtel la' pusic'al cha'an tsa'ix p'ʌt'a i yoc jini winic? ¿Chucoch mi la' ch'ujch'uj q'uelon lojon che' bajche' mi tic bajñel p'ʌtʌlel, tic bajñel uts'atlel, tsa cʌq'ue lojon i p'ʌtʌlel ti xʌmbal ili winic? ");
INSERT INTO ctuBl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","I Dios Abraham, i Dios Isaac, i Dios Jacob, i Dios lac ñojte'el tsa'ix i tsictesa i ñuclel i Yalobil, jiñʌch Jesús. Jatetla tsa'ix la' wʌc'ʌ ti' c'ʌb i contra. Tsa' la' ts'a'le ti' tojlel Pilato, che' bʌ tsi' ña'ta i yʌc' ti colel. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jatetla tsa' la' ts'a'le jini Ch'ujul Bʌ, jini Toj Bʌ. Tsa' la' c'ajtibe Pilato cha'an mi' yʌc' ti colel stsʌnsa. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tsa' la' tsʌnsa jini mu' bʌ i yʌq'ueñonla laj cuxtʌlel. Testigojon lojon, Dios tsi' teche loq'uel ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Cha'an ti' c'aba' Jesús mu' bʌ c ñop lojon tsi' taja i p'ʌtʌlel jini winic mu' bʌ la' q'uel mu' bʌ la' cʌn. Jesús tsi' yʌq'ueyonla lac ñop. Jini cha'an tsa' c'oq'uesʌnti jini winic ti la' tojlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Wʌle c pi'ʌlob, cujil tsa' la' tsʌnsa Jesús cha'an i tontojlel la' pusic'al che' bajche' la' yumob. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero Dios tsi' ts'ʌctesa i t'an tsa' bʌ i wʌn subu ti' yej pejtelel x'alt'añob i cha'an, cha'an wersa mi' yubin wocol Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Jini cha'an cʌyʌ la' mul. Sutq'uin la' bʌ cha'an mi' yajpel la' mul, cha'an mi la' taj la' p'ʌtʌlel ti Espíritu yic'ot tijicña bʌ la' pusic'al ti lac Yum. Dios mi caj i chocbeñetla tilel Jesús jini Cristo wa'chocobil bʌ i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Come isujm mi' wersa ajñel Jesucristo ti panchan c'ʌlʌl ti' yorajlel che' mi' cha' mel pejtelel chuqui tac an, che' bajche' tsi' subu Dios yic'ot ch'ujul bʌ x'alt'añob i cha'an ti wajali. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Come Moisés tsi' subeyob la' ñojte'el: “La' Yum Dios mi caj i techbeñetla juntiquil x'alt'an che' bajche' joñon loq'uem bʌ ti la' pi'ʌlob. Mi caj la' jac'ben pejtelel chuqui tac mi' subeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Majqui jach mi' ñusʌben i t'an jini x'alt'an, mi caj i chojquel loq'uel ti' tojlel i pi'ʌlob cha'an mi' jilel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ti pejtelel x'alt'añob, c'ʌlʌl ti Samuel yic'ot jini tsa' bʌ tiliyob ti wi'ipat che' bajche' jaytiquil tsi' cha'leyob t'an, tsi' wʌn subuyob chuqui woli' yujtel ti ili q'uin tac. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jatetla i yalobiletla x'alt'añob. I cha'añetla jini trato bʌ t'an subebilo' bʌ lac ñojte'el cha'an Dios che' bʌ tsi' sube Abraham: “Ti pejtelel año' bʌ ti pañimil mi caj i tajob i wenlel cha'an a p'olbal”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios tsi' teche ch'ojyel i Yalobil. Tsi' ñaxan choco tilel ba' añetla cha'an mi' yʌq'ueñetla la' wenlel cha'an mi' ñijcañetla la' cʌy la' mul ti jujuntiquiletla. Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Che' woli' pejcañob winicob x'ixicob Pedro yic'ot Juan, tsa' tiliyob motomajob yic'ot saduceojob, yic'ot i yaj capitán jini xcʌntayajob ti Templo. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tsʌytsʌyñayob i pusic'al come woli' cʌntesañob winicob x'ixicob, come Pedro woli' subeñob mi caj i tech ch'ojyel chʌmeño' bʌ jini Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tsi' chucuyob. Tsi' yotsayob ti mʌjquibʌl c'ʌlʌl ti yijc'ʌlal come ic'ajelix. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Cabʌl tsa' bʌ i yubiyob jini t'an tsi' ñopoyob. An che' bajche' jo'p'ejl mil winicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ti' yijc'ʌlal tsi' tempayob i bʌ ti Jerusalén jini yumʌlob yic'ot xñoxob año' bʌ i ye'tel yic'ot sts'ijbayajob. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ya'an ja'el Anás jini ñuc bʌ motomaj yic'ot Caifás yic'ot Juan yic'ot Alejandro yic'ot yambʌ i pi'ʌlob jini ñuc bʌ motomaj. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Che' bʌ tsa'ix i yʌc'ʌyob Pedro ti ojlil, tsi' c'ajtibeyob: ¿Baqui tsa' la' taja la' p'ʌtʌlel? ¿Majqui tsi' subeyetla cha'an mi la' mel jini? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Che' jini Pedro, but'ul ti Ch'ujul bʌ Espíritu, tsi' subeyob: Jatetla yumʌletla, anix bʌ la' jabilel yic'ot la' we'tel ti Israel, ");
INSERT INTO ctuBl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mi woli la' c'ajtibeñon lojon cha'an jini wen bʌ e'tel tsa' bʌ c melbe lojon ili winic, ubinla bajche' tsa' mejli ti p'ʌt'esʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ña'tanla ti la' pejtelel. La' i ñopob ja'el pejtelel winicob x'ixicob ti Israel. Tsa'ix lajmi cha'an i c'aba' Jesucristo, jini ch'oyol bʌ ti Nazaret, jini tsa' bʌ la' ch'iji ti cruz, pero Dios tsi' teche ch'ojyel ba'an chʌmeño' bʌ. Cha'an i p'ʌtʌlel Jesucristo tsa'ix p'ʌt'a i yoc jini winic am bʌ ti la' tojlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús jiñʌch jini Xajlel tsa' bʌ la' choco, xmel ototet bʌ la. Tsa' otsʌnti ti ñaxan bʌ i xujc otot. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ma'anic laj coltʌntel ti yambʌ, cojach ti' c'aba' Jesús. Ma'anic yambʌ ti yebal panchan aq'uebilo' bʌ winicob mu' bʌ mejlel i coltañonla. Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Che' bʌ tsi' q'uelbeyob i ch'ejlel i pusic'al Pedro yic'ot Juan, tsa' toj sajtiyob i pusic'al winicob x'ixicob come yujilob mach cʌntesʌbilobic ti jun, ma'añobic i ye'tel. Tsi' ña'tayob i pi'ʌlobʌch Jesús jini Pedro yic'ot Juan. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Che' bʌ tsi' q'ueleyob lajmenix jini winic wa'al bʌ yic'otob, ma'anic chuqui tsa' mejli i subob ti' contra. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Tsi' subeyob loq'uel ti' tojlelob. Tsa' caji i pejcañob i bʌ jini año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tsi' yʌlʌyob: ¿Chuqui mi caj lac tumben jini winicob? Come cʌmbil i cha'an pejtel chumulo' bʌ ti Jerusalén, tsi' pʌsʌyob ñuc bʌ i yejtal i p'ʌtʌlel ti isujm. Mach mejlic la cʌl mach isujmic. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ame chʌn p'ojlic jini t'an ti lac tejclum, la' lac tic' jini winicob cha'an mach mi' chʌn cha'leñob t'an ti' c'aba' Jesús, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Tsi' pʌyʌyob tilel Pedro yic'ot Juan. Tsi' tiq'uiyob cha'an ma'anic mi' chʌn cha'leñob t'an yic'ot cʌntesa ti' c'aba' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro yic'ot Juan tsi' jac'beyob: Subula jatetla mi toj ti' wut Dios mi tsac ñusʌbe lojon i t'an Dios cha'an mic jac'beñetla. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mach mejlic mij cʌy lojon ili t'an. Wersa mic sub lojon chuqui tsaj q'uele lojon yic'ot chuqui tsa cubi lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jini yumʌlob che' bʌ tsa' ujti i subeñob chuqui mi' caj ti ujtel mi ma'anic tsi' jac'ʌyob, tsi' chocoyob sujtel. Ma'anic tsi' yʌq'ueyob i toj i mul, come tsi' bʌc'ñayob winicob x'ixicob. Ti pejtelelob woli' subob i ñuclel Dios cha'an jini tsa' bʌ ujti. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Come ñumenix ti cha'c'al i jabilel jini winic tsa' bʌ p'ʌt'esʌnti cha'an ñuc bʌ i p'ʌtʌlel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Che' bʌ tsa' ajq'uiyob ti colel Pedro yic'ot Juan, tsa' majliyob ba'an i pi'ʌlob. Tsi' subeyob pejtelel chuqui tsi' yʌlʌyob ñuc bʌ motomajob yic'ot xñoxob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Che' bʌ tsa'ix ujti i yubiñob jini t'an, ti pejtelelob tsi' tem pejcayob Dios. Tsi' subeyob: C Yum, jatet Dioset tsa' bʌ a mele panchan yic'ot pañimil yic'ot colem ñajb yic'ot pejtelel i bʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tsi' cha'le t'an jini Ch'ujul bʌ Espíritu ti' yej David jini a winic. Tsi' yʌlʌ: “¿Chucoch tsi' cha'leyob mich'ajel ti mojt ti mojt? ¿Chucoch to'ol lolom jach chuqui tac tsi' ña'tayob ti' pusic'al? ");
INSERT INTO ctuBl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jini reyob ti pañimil tsi' chajpayob i bʌ, jini yumʌlob tsi' tempayob i bʌ cha'an mi' contrajiñob lac Yum yic'ot Cristo, jini yajcʌbil bʌ i cha'an Dios”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Isujm ti jini tejclum, tsi' tempayob i bʌ Herodes yic'ot Poncio Pilato yic'ot jini gentilob yic'ot israelob ti' contra Jesús, jini ch'ujul bʌ a Walobil, jini yajcʌbil bʌ a cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tsi' tempayob i bʌ cha'an mi' cha'leñob pejtelel chuqui tsa' wʌn ña'ta mi' caj ti ujtel. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wʌle, c Yum, q'uele bajche' mi' yʌ'leñon lojon. A winicon lojon. Aq'ueñon lojon i ch'ejlel c pusic'al cha'an mic sub lojon a t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ac'ʌ a c'ʌb ti lajmesaya cha'an mi' pʌstʌl i yejtal a p'ʌtʌlel yic'ot ñuc tac bʌ a melbal ti' c'aba' a Walobil Jesús, jini Ch'ujul Bʌ. Che' tsi' cha'le oración. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Che' bʌ tsa' ujti i pejcañob Dios, tsa' ñijcʌnti jini otot ba' tsi' tempayob i bʌ. Ti pejtelelob but'ulob ti Ch'ujul bʌ Espíritu. Tsi' subuyob i t'an Dios ti' ch'ejlel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jump'ejlob jach i pusic'al, junchajpob jach i ña'tʌbal jini bajc'ʌl winicob x'ixicob tsa' bʌ i ñopoyob. Ma'anic majqui tsi' yʌlʌ mi i bajñel cha'añʌch i chubʌ'an. I tem cha'añob jach pejtelel i chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Testigojob jini apóstolob. Ti cabʌl i p'ʌtʌlel tsi' subuyob tsa' cha' ch'ojyi lac Yum Jesús. Pejtelel jini xñopt'añob tsa' aq'uentiyob i yutslel i pusic'al Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Laj añob i chubʌ'an, come jini año' bʌ i lum yic'ot i yotot tsi' choñoyob. Tsi' ch'ʌmʌyob tilel i tojol jini tsa' bʌ chojni. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tsi' p'ulchocoyob lʌc'ʌl ti' yoc jini apóstolob. Tsa' t'oxbentiyob xñopt'añob, majqui jach anto yom i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","José, juntiquil leví ch'oyol bʌ ti Chipre, tsa' aq'uenti yambʌ i c'aba' cha'an jini apóstolob. Jiñʌch Bernabé. (Mi' yʌl ti lac t'an, jini mu' bʌ i ñuq'uesan lac pusic'al.) ");
INSERT INTO ctuBl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","An i lum jini Bernabé. Tsi' choño. Tsi' ch'ʌmʌ tilel i tojol. Tsi' p'ulchoco lʌc'ʌl ti' yoc jini apóstolob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Juntiquil winic, i c'aba' Ananías yic'ot i yijñam, i c'aba' Safira, tsi' choño jumpejt lum. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Tsi' loto lamital i tojol. Yujil ja'el i yijñam. Tsi' ch'ʌmʌ tilel lamital, tsi' p'ulchoco lʌc'ʌl ti' yoc jini apóstolob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro tsi' sube Ananías: ¿Chucoch but'ul a pusic'al ti Satanás? Tsa' loti jini Ch'ujul bʌ Espíritu che' bʌ tsa' loto lamital i tojol a lum. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Che' bʌ maxto anic tsa' choño, ¿mach ba a cha'anic? Che' bʌ tsa'ix a choño, ¿mach ba a wentajic jini i tojol? ¿Chucoch tsa' tejchi lot ti a pusic'al? Ma'anic tsa' loti winicob, tsa' loti Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Che' bʌ tsi' yubi jini t'an Ananías, tsa' yajli. Tsa' chʌmi. Tsi' wen cha'leyob bʌq'uen pejtelel jini tsa' bʌ i yubiyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ch'iton winicob tsa' ch'ojyiyob. Tsi' bʌc'ʌyob. Che' bʌ tsi' ch'ʌmʌyob loq'uel, tsi' mucuyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tsa' ñumi che' bajche' uxp'ejl ora, tsa' ochi tilel i yijñam Ananías. Maxto yujilic chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro tsi' sube: Subeñon mi che'i tsa' ch'ʌmʌ i tojol a lum che' bʌ tsa' la' choño, che'en. Tsi' sube: Che'cuyi tsac ch'ʌmʌ lojon i tojol, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro tsi' sube: ¿Bajche' tsa' la' teme la' t'an cha'an mi la' wilʌben i pusic'al i yEspíritu lac Yum? Awilan, jini tsa' bʌ i mucuyob a ñoxi'al añob ti' ti' otot. Mi caj i ch'ʌmetob loq'uel ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ti ora tsa' yajli lʌc'ʌl ti' yoc Pedro. Tsa' chʌmi. Che' bʌ tsa' ochiyob ch'iton winicob, chʌmenix tsi' tajayob. Tsi' ch'ʌmʌyob loq'uel. Tsi' mucuyob ti' t'ejl i ñoxi'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tsi' wen cha'leyob bʌq'uen pejtelel jini xñopt'añob, yic'ot pejtelel tsa' bʌ i yubiyob chuqui tsa' ujti. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jini apóstolob tsi' meleyob cabʌl ñuc tac bʌ i melbal. Tsi' pʌsʌyob i yejtal i p'ʌtʌlel ti' tojlel winicob x'ixicob. Ti pejtelelob ya' añob ti jump'ejl i pusic'al ti' corredor Salomón. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Yaño' bʌ ma'anic tsi' ñopo i lʌc'tesañob i bʌ cha'an bʌq'uen. Pero jini xñopt'añob tsi' q'ueleyob ti ñuc. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Cabʌl tsa' p'ojliyob jini tsa' bʌ i ñopoyob lac Yum, winicob yic'ot x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tsi' ch'ʌmʌyob majlel xc'amʌjelob ti bij. Tsi' ñolchocoyob ti' wʌyib yic'ot pojp tac cha'an mi' tajob anquese jinic jach i yʌxñʌlel Pedro che' woli' ñumel majlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Cabʌlob tsi' tempayob i bʌ ti Jerusalén ch'oyolo' bʌ ti yambʌ tejclum tac ti' joytilel. Tsi' pʌyʌyob tilel xc'amʌjelob yic'ot jini tic'lʌbilo' bʌ cha'an xibajob. Tsa' lajmesʌntiyob ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tsa' tili jini ñuc bʌ motomaj yic'ot pejtelel jini saduceojob. Tsʌytsʌyñayob jax i pusic'al cha'an jini tsa' bʌ ujti. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tsi' chucuyob jini apóstolob. Tsi' yotsayob ti mʌjquibʌl yic'ot jini woli bʌ i tojob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ti ac'ʌlel i yángel lac Yum tsi' jambeyob i ti' jini mʌjquibʌl. Tsi' loc'sayob. Tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Cucula ti wa'tʌl ti Templo. Suben winicob x'ixicob bajche' yom mi' tajob i cuxtilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Che' bʌ tsi' yubiyob jini t'an, tsa' ochiyob ti Templo ti sʌc'ajel. Tsi' cha'leyob cʌntesa. Tsa' tili jini ñuc bʌ motomaj yic'ot yaño' bʌ. Tsi' pʌyʌyob tilel jini año' bʌ i ye'tel yic'ot jini ñoxobix bʌ israelob. Tsi' choco majlel i winicob cha'an mi' pʌyob tilel Pedro yic'ot Juan. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Che' bʌ tsa' c'otiyob i winicob, ma'anic tsi' tajayob ti mʌjquibʌl. Tsa' cha' sujtiyob i sub. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tsi' yʌlʌyob: Isujmʌch, wen mʌcbil tsac taja lojon jini mʌjquibʌl. Ya' añob jini xcʌntayajob ti' ti'. Che' bʌ tsac jamʌ lojon, ma'anic majqui tsac taja lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Che' bʌ tsi' yubiyob jini t'an, jini ñuc bʌ motomaj yic'ot i capitán jini Templo yic'ot ñuc bʌ motomajob mach yujilobic chuqui mi' caj ti ujtel mi tsa' tsictiyi jini. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tsa' tili juntiquil. Tsi' subeyob: Awilan, ya' wa'alob ti Templo jini winicob tsa' bʌ la' ñup'u. Woli' cha' cʌntesañob winicob x'ixicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jini cha'an tsa' majli jini capitán yic'ot i winicob. Tsi' pʌyʌyob tilel Pedro yic'ot Juan. Pero utsob jax come woliyob ti bʌq'uen ame jujlicob ti xajlel cha'an winicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Che' bʌ tsa'ix i pʌyʌyob tilel, tsi' yʌc'ʌyob ba'an jini año' bʌ i ye'tel. Jini ñuc bʌ motomaj tsi' subeyob: ");
INSERT INTO ctuBl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","¿Mach ba tsa'ic c tiq'uiyetla cha'an ma'anic mi la' chʌn cha'len cʌntesa ti' c'aba' Jesús? Awilan, tsa'ix ubinti la' cʌntesa ti pejtelel Jerusalén. La' wom la' tsictesan lojon c mul cha'an tsac bec'be lojon i ch'ich'el jini winic, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro yic'ot jini apóstolob tsi' jac'beyob: Wersa mic jac'ben lojon i mandar Dios anquese mi' ñusʌntel i mandar winicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","I Dios lac ñojte'el tsi' teche ch'ojyel Jesús, tsa' bʌ la' tsʌnsa che' bʌ tsa' la' ch'iji ti te'. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios tsi' yʌq'ue i ñuclel ya' ti' ñoj. Colem yumʌlʌch, Xcoltayajʌch. Mi' yʌq'ueñob i cʌy i mul jini israelob cha'an mi' ñusʌbeñob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mic sub lojon jini tsa' bʌ ujti. Jini Ch'ujul bʌ Espíritu mi' sub ja'el, come Dios mi' yʌq'ueñob i yEspíritu jini mu' bʌ i jac'beñob i t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tsa' wen mich'ayob che' bʌ tsi' yubibeyob i t'an. Yomob i tsʌnsan jini apóstolob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tsa' ch'ojyi juntiquil fariseo am bʌ i ye'tel, i c'aba' Gamaliel. Jiñʌch mu' bʌ i cʌntesan winicob ti mandar. Ti pejtelelob tsi' q'ueleyob ti ñuc. Tsi' yʌc'ʌ mandar cha'an mi' poj pʌjyelob loq'uel jini apóstolob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Che' majlemobix, Gamaliel tsi' sube i pi'ʌlob: Israelob, chʌcʌ q'uele la' bʌ cha'an chuqui tac mi la' tumben jini winicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Come wajalix tsa' tili Teudas. Tsi' lon subu i bʌ ti ñuc. Tsi' tsajcayob che' bajche' jumbajc' winicob, pero tsa' tsʌnsʌnti. Tsa' pujquiyob jini tsa' bʌ i tsajcayob. Che' jach tsa' lajmi. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ti wi'il tsa' tili Judas ch'oyol bʌ ti Galilea. Che' ti' yorajlel censo, jini Judas tsi' pʌyʌ majlel cabʌl winicob. Tsa' tsʌnsʌnti ja'el. Tsa' pam pujquiyob pejtelel tsa' bʌ i tsajcayob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Wʌle mic subeñetla, chʌcʌ q'uele la' bʌ cha'an ma'anic mi la' tic'lan jini winicob. Mi ch'oyol ti' bajñel pusic'al jini t'an yic'ot jini e'tel, mi' caj ti jilel. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mi ch'oyolʌch ti Dios, mach mejlic la' jisʌben i ye'tel ame che'ic mi la' contrajin Dios. Che' tsi' yʌlʌ Gamaliel. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Tsi' jac'beyob i t'an. Che' bʌ tsi' pʌyʌyob ochel jini apóstolob, tsi' bajbeyob. Tsi' subeyob cha'an ma'anic mi' chʌn cha'leñob t'an ti' c'aba' Jesús. Tsi' coloyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Che' bʌ tsa'ix loq'uiyob ti' tojlel año' bʌ i ye'tel, tijicñayob jax i pusic'al, come Dios tsi' yʌq'ueyob i xuc'tilel i pusic'al cha'an mi' ñusañob i ts'a'lentel ti' c'aba' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ti jujump'ejl q'uin tsi' chʌn cha'leyob cʌntesa ti Templo yic'ot ti jujump'ejl otot. Tsi' chʌn subuyob i t'an Jesucristo. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Che' woli' p'ojlelob xcʌnt'añob, jini griegojob tsi' yʌ'leyob hebreojob, come jini meba' x'ixicob i cha'añob ma'anic tsa' aq'uentiyob chuqui anto yom i cha'an ti jujump'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jini cha'an jini lajchʌntiquil tsi' tempayob pejtelel jini xcʌnt'añob. Tsi' subeyob: Mach wenic mij cʌy lojon c sub i t'an Dios cha'an mic puc lojon waj. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jini cha'an hermanojob, yajcanla wuctiquil winicob uts'at bʌ i pusic'al but'ulob ti Ch'ujul bʌ Espíritu, yic'ot wen bʌ i ña'tʌbal, cha'an mi la' wa'chocoñob cha'an jini e'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Joñon lojon mi caj c chʌn pejcan lojon Dios. Mi caj c chʌn cha'len lojon subt'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Uts'at tsi' yubibeyob i t'an ti pejtelelob. Tsi' yajcayob Esteban, ñopol bʌ i cha'an i t'an Dios ti jump'ejl i pusic'al, but'ul bʌ ti Ch'ujul bʌ Espíritu. Tsi' yajcayob Felipe ja'el yic'ot Prócoro yic'ot Nicanor yic'ot Timón yic'ot Parmenas yic'ot Nicolás, jini tsa' bʌ ochi i ñop ti Antioquía. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tsi' pʌyʌyob ba'an jini apóstolob. Che' bʌ tsa'ix ujti i pejcañob Dios, tsi' yʌc'ʌyob i c'ʌb ti' jol. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tsa' pujqui i t'an lac Yum. Wen cabʌl tsa' p'ojliyob xcʌnt'añob ti Jerusalén. Cabʌl motomajob ja'el tsi' jac'beyob i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban, but'ul ti' yutslel i pusic'al yic'ot i p'ʌtʌlel, tsi' pʌsʌ ñuc tac bʌ i yejtal i p'ʌtʌlel yic'ot ñuc tac bʌ i ye'tel ti' tojlel winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jini cha'an tsa' tiliyob winicob mu' bʌ i yajñelob ti sinagoga. Tsa' caji i yʌ'leñob Esteban. Jini winicob i c'aba' librejo' bʌ yic'ot cirenejob, yic'ot alejandríajob, yic'ot judíojob ch'oyolo' bʌ ti Cilicia yic'ot ti Asia tsa' caji' contrajiñob Esteban. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma'anic tsa' mejli i contrajiñob i ña'tʌbal yic'ot jini Espíritu tsiquil bʌ ti' t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tsi' xic'beyob winicob ti mucul jach cha'an mi' jop'beñob i mul. Tsi' yʌlʌyob: Tsa'ix cubibe lojon i t'an che' bʌ tsi' cha'le p'ajoñel ti' contra Moisés yic'ot ti' contra Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tsi' ñijcayob winicob x'ixicob yic'ot xñoxob año' bʌ i ye'tel yic'ot sts'ijbayajob. Tsa' tiliyob, tsi' chucuyob Esteban. Tsi' pʌyʌyob majlel ba'an jini año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Tsi' wa'chocoyob xjop't'añob tsa' bʌ i yʌlʌyob: Jini winic mi' cha'len p'ajoñel ti pejtelel ora. Mi' p'aj jini Ch'ujul bʌ Ajñibʌl yic'ot jini mandar. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Come tsa'ix cubi lojon che' bʌ tsi' yʌlʌ jini Esteban: “Jini Jesús ch'oyol bʌ ti Nazaret mi caj i jisan jini Ajñibʌl. Mi caj i q'uextan i cʌntesʌbal Moisés tsa' bʌ lac ñopo ti lac tat”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pejtelel jini buchulo' bʌ año' bʌ i ye'tel tsi' q'uelbeyob i wut Esteban lajal bajche' i wut ángel. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jini ñuc bʌ motomaj tsi' c'ajtibe: ¿Isujm ba jini? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban tsi' yʌlʌ: Winicob c pi'ʌlob, ñich'tanla. Jini Dios am bʌ i ñuclel tsa' tsictiyi ti' wut lac tat Abraham che' ya'to an ti Mesopotamia che' maxto anic tsa' majli ti Harán. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios tsi' sube: “Loq'uen ti a lumal ba'an a pi'ʌlob. Cucu ti ochel ti lum mu' bʌ caj c pʌsbeñet”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tsa' loq'ui ti' lumal caldeojob. Tsa' caji ti chumtʌl ti Harán. Che' bʌ tsa' chʌmi i tat Abraham, Dios tsi' c'axtesa ti yambʌ lum wʌ' ba' chumulonla wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Dios ma'anic chuqui tsi' yʌq'ue Abraham ilayi, mi ts'ita'ic lum, pero tsi' yʌq'ue i t'an. Tsi' sube mi caj i yotsan ti' yum jini lum yic'ot i p'olbal ja'el anquese maxto anic i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios tsi' sube Abraham ja'el: “Mi caj i majlel ti chumtʌl a p'olbal ti yambʌ lum mach bʌ i cha'añobic, ba' mi caj i yʌjq'uelob ti to'ol e'tel. Jumbajc' jab mi caj i cha'leñob majtan e'tel yic'ot wocol. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mi caj cʌq'ueñob i toj i mul jini winicob x'ixicob mu' bʌ i yotsañob ti to'o e'tel. Ti wi'il mi caj i loq'uelob tilel a p'olbal. Mi caj i ch'ujutesañoñob ilayi”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios tsi' yʌq'ue Abraham jini xuc'ul bʌ t'an cha'an tsep pʌchʌlel. I yalobil Abraham jiñʌch Isaac. Abraham tsi' tsepbe i pʌchʌlel che' waxʌcp'ejl jax to i q'uiñilel Isaac. I yalobil Isaac jiñʌch Jacob. I yalobilob Jacob jiñobʌch lajchʌntiquil lac ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Tsʌytsʌyñayob jax i pusic'al jini lac ñojte'el cha'an José. Jini cha'an tsi' choñoyob cha'an mi' pʌjyel majlel ti Egipto pero ya'an Dios yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios tsi' loc'sa ti pejtelel i wocol. Tsi' ñijcʌbe i pusic'al Faraón cha'an mi' q'uel José ti uts'at. Dios tsi' yʌq'ue José i ña'tʌbal ti' tojlel jini rey Faraón ya' ti Egipto. Dios tsi' yʌq'ue i ye'tel ti yumʌl ti' tojlel egiptojob yic'ot ti' yotot Faraón ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Tsa' caji wi'ñal ti' lumal egiptojob yic'ot ti Canaán ja'el. An cabʌl wocol. Lac ñojte'el ma'anic tsi' tajayob i bʌl i ñʌc'. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Che' bʌ tsi' yubi Jacob an trigo ya' ti Egipto, tsi' choco majlel lac ñojte'elob che' ti' cajibal wi'ñal. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Che' bʌ tsa' majliyob ti' cha'yajlel, José tsi' yʌc'ʌ i bʌ ti cʌjñel ti' tojlel i yʌscuñob. Tsi' yʌc'ʌ i pi'ʌlob ti cʌjñel ti' tojlel Faraón. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José tsi' chocoyob majlel cha'an mi' pʌyob tilel Jacob, i tat, yic'ot pejtelel i pi'ʌlob, jo'lujuntiquil i chʌnc'al (75). ");
INSERT INTO ctuBl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tsa' jubi majlel Jacob ya' ti Egipto. Ya' tsa' chʌmi yic'ot lac ñojte'elob. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Tsa' q'uejchiyob majlel c'ʌlʌl ti Siquem ba' tsa' mujquiyob ti' yotlel ch'ujlelʌl mʌmbil bʌ i cha'an Abraham. Abraham tsi' tojbeyob ti taq'uin i yalobilob Hamor ya' ti Siquem. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Che' bʌ yomix c'otel i yorajlel cha'an mi' ts'ʌctiyel i t'an Dios che' bajche' tsi' sube Abraham, tsa' wen p'ojli i p'olbal Abraham ya' ti Egipto ");
INSERT INTO ctuBl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","jinto tsa' wa'choconti yambʌ rey ti Egipto mach bʌ anic tsi' cʌñʌ José. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Mach tojic chuqui tsi' tumbe lac pi'ʌlob jini rey. Tsi' tic'la lac ñojte'elob cha'an mi' wersa ac'ob i yalobilob ti chʌmel cha'an mi' jilel i p'olbal Israel. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti jim bʌ ora che' woli to i tic'lañob, tsi' yila pañimil Moisés. Wen uts'atax tsi' q'uele Dios. Tsa' tsu'sʌnti uxp'ejl uw ti' yotot i tat. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Che' bʌ tsa' ajq'ui Moisés ba' bʌbʌq'uen mi' chʌmel, tsa' tili i yalobil Faraón. Tsi' loto. Tsi' cosa che' bajche' i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tsa' cʌntesʌnti Moisés ti pejtelel i ña'tʌbal egiptojob. Wen ch'ejl ti t'an yic'ot ti e'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Che' cha'c'alix i jabilel, Moisés tsi' ña'ta ti' pusic'al yom majlel i jula'tan i pi'ʌlob, jiñobʌch i yalobilob Israel. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Che' bʌ tsi' q'uele woli' tic'lʌntel juntiquil i pi'ʌl, Moisés tsi' colta jini woli bʌ i tic'lʌntel. Tsi' q'uextʌbe i jontolil jini egipto. Tsi' jats'ʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Come Moisés tsi' lon ña'ta woli' ch'ʌmbeñob isujm i pi'ʌlob, cha'an jiñʌch yajcʌbil bʌ ti Dios cha'an mi' coltañob. Pero ma'anic tsi' ch'ʌmbeyob isujm. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ti yijc'ʌlal Moisés tsi' pʌsʌ i bʌ ba'an i pi'ʌlob che' woliyob ti leto. Yom i lajmesan leto. Tsi' yʌlʌ: “Winicob, la' pi'ʌl la' bʌ. ¿Chucoch mi la' tic'lan la' bʌ?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jini tsa' bʌ i tic'la i pi'ʌl tsi' tʌjcʌx choco majlel Moisés. Tsi' sube: “¿Majqui tsi' yʌq'ueyet a we'tel ti yumʌl cha'an ma' melon lojon? ");
INSERT INTO ctuBl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A wom ba a tsʌnsañon che' bajche' tsa' tsʌnsa jini egipto ac'bi?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Che' bʌ tsi' yubi jini t'an, tsa' puts'i majlel Moisés. Tsa' majli ti chumtʌl ti yambʌ lum i c'aba' Madián. Ya'i tsi' yilayob pañimil cha'tiquil ch'iton bʌ i yalobil. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Che' ñumenix cha'c'al jab, tsa' tsictiyi juntiquil ángel ti colem bʌ i tiquiñal pañimil lʌc'ʌl ti Sinaí wits. Tsa' tsictiyi ti c'ajc woli bʌ ti lejmel ti alʌte'. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Che' bʌ tsi' q'uele Moisés, tsa' toj sajti i pusic'al cha'an jini tsa' bʌ i q'uele. Che' bʌ tsa' majli i q'uel jini alʌte', tsa' tili i t'an lac Yum: ");
INSERT INTO ctuBl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Joñon i Dioson a ñojte'el, i Dioson Abraham, i Dioson Isaac, i Dioson Jacob”, che'en Dios. Mach yomic i chʌn q'uel Moisés, come tsiltsilña jax ti bʌq'uen. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lac Yum tsi' sube: “Loc'san a xʌñʌb ti a woc come ch'ujul jini lum ba' wa'alet. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Isujm, tsa'ix j q'uele i tic'lʌntel c cha'año' bʌ ya' ti Egipto. Tsa'ix cubibeyob i yuq'uel. Tsa'ix jubiyon tilel cha'an mic loc'sañob. La'ix cu, che' jini. Mi caj c choquet majlel ti Egipto”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Jini Moisés tsa' ts'a'lenti cha'an i pi'ʌlob. Tsi' yʌlʌyob i pi'ʌlob: “¿Majqui tsi' yʌq'ueyet a we'tel ti yumʌl yic'ot ti meloñel?” che'ob. Jini Moisés ts'a'lebil bʌ i cha'añob, Dios tsi' choco tilel. Jini ángel tsa' bʌ tsictiyi ti alʌte' tsi' yʌq'ue i ye'tel ti yumʌl yic'ot ti xcoltaya. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisés tsi' pʌyʌ loq'uel i yalobilob Israel che' bʌ tsa' ujti i pʌs bʌbʌq'uen tac bʌ yic'ot i yejtal i p'ʌtʌlel cha'c'al jab ya' ti Egipto yic'ot ti Chʌchʌc bʌ Ñajb yic'ot ti jochol bʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jiñʌch Moisés tsa' bʌ i sube i yalobilob Israel: “Lac Yum Dios mi caj i techbeñetla juntiquil x'alt'an che' bajche' joñon loq'uem bʌ ti la' pi'ʌlob. Jini mi caj la' wubin”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jiñʌch Moisés am bʌ yic'ot jini tempʌbilo' bʌ ti jochol bʌ lum. Jini ángel tsi' pejca ya' ti Sinaí wits yic'ot lac ñojte'el. Tsi' yubi jini t'an cha'an laj cuxtʌlel cha'an mi' cha' aq'ueñonla. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Lac ñojte'el ma'anic tsi' jac'beyob Moisés. Tsi' ts'a'leyob. Tsi' chʌn ña'tayob i cha' sujtel ti Egipto. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tsi' subeyob Aarón: “Mele lac dios tac cha'an ñaxan mi' majlel ti lac tojlel. Come ma'anic mi lac ña'tan chuqui tsa' tumbenti jini Moisés tsa' bʌ i pʌyʌyonla loq'uel ti Egipto”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Che' jini tsi' meleyob alʌ wacax. Tsi' tsʌnsʌbeyob i majtan jini dios taq'uin. Tsa' ñuc'ayob i pusic'al cha'an jini dios tsa' bʌ i meleyob ti' c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jini cha'an Dios tsi' cʌyʌyob cha'an mi' ch'ujutesañob jini q'uin yic'ot uw yic'ot ec'. Ts'ijbubil ti' jun x'alt'añob ja'el: “Jatetla israelob, ¿tsa' ba la' tsʌnsʌbeyon la' wʌlac' cha'c'al jab ti jochol bʌ lum? ¿Tsa' ba la' pulbeyon c majtan? ");
INSERT INTO ctuBl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tsa'ix la' q'uechbe pisil bʌ i yotlel Moloc, yic'ot jini ec', i yejtal bʌ a dios Renfán. Tsa' la' mele cha'an mi la' ch'ujultesan. Joñon mi caj j c'axtesañetla ti junwejl Babilonia”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","An i cha'an lac ñojte'elob jini pisil bʌ otot ti jochol bʌ lum ba' tsa' pʌsle i sujmlel Dios. Come che' bʌ tsi' yʌc'ʌ mandar Dios, tsi' sube Moisés cha'an mi' mel otot che' bajche' tsa' pʌsbenti. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Che' bʌ tsa' ujti i ch'ʌmbeñob i lum gentilob lac ñojte'el yic'ot Josué, tsi' q'uecheyob ochel jini pisil bʌ otot ti' lumal. Come Dios tsi' choco loq'uel jini gentilob ti' tojel i wutob lac ñojte'el c'ʌlʌl ti' yorajlel David. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios tsi' pʌsbe David i yutslel. Jini David yom i melben i chumlib Dios tsa' bʌ i ñopo Jacob. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero tsi' mele Salomón. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Jini C'ax Ñuc Bʌ ma'anic mi' chumtʌl ti templo tac melbil bʌ ti c'ʌbʌl. Che' ja'el tsi' yʌlʌ jini x'alt'an: ");
INSERT INTO ctuBl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Jini panchan c buchlib, jini pañimil i yajñib coc. ¿Chuqui ti otot la' wom la' melbeñon? che'en lac Yum. ¿Chuqui jini cajñib ba' mij c'aj co? ");
INSERT INTO ctuBl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Mach ba c melbalic pejtelel ili tac?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tsʌtsatax la' pusic'al. Mach sʌq'uesʌbilic la' pusic'al. Mʌcʌl la' chiquin. Ti pejtelel ora jatetla mi la' mʌctan jini Ch'ujul bʌ Espíritu. Che' bajche' tsi' mele la' ñojte'el, che' ja'el mi la' mel jatetla. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ma'anic mi juntiquilic x'alt'an mach bʌ anic tsa' tic'lʌnti cha'an la' ñojte'el. Tsi' tsʌnsayob jini tsa' bʌ i wʌn subuyob tal jini Toj bʌ. Wʌle jatetla tsa'ix la' wʌc'ʌ jini Toj bʌ ti' c'ʌb i contra. Tsa'ix la' tsʌnsa. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jini ángelob tsi' yʌq'ueyetla i mandar Dios. Jatetla ma'anic tsa' la' jac'ʌ. Che' tsi' yʌlʌ Esteban. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Che' bʌ tsi' yubiyob ili t'an tsa' wen mich'ayob. Quech'ecñayob i bʌquel i yej tsi' meleyob cha'an mich' tsi' q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","But'ul Esteban ti Ch'ujul bʌ Espíritu. Tsi' letsa i wut ti panchan. Tsi' q'uele i ñuclel Dios. Tsi' q'uele Jesús ya' wa'al ti' ñoj Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Tsi' yʌlʌ: Awilan, wolij q'uel calal jini panchan. Ya' wa'al i Yalobil Winic ti' ñoj Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tsi' cha'leyob c'am bʌ t'an. Tsi' mʌcʌyob i chiquin. Temel tsa' majliyob ti ajñel cha'an mi' chucob Esteban. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tsi' chocoyob loq'uel ti colem tejclum. Tsi' juluyob ti xajlel. Jini tsa' bʌ i yubibeyob i t'an Esteban tsi' chocoyob jubel i bujc tac ti' yoc juntiquil winic i c'aba' Saulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Che' bʌ tsi' juluyob ti xajlel, Esteban tsi' pejca Dios. Tsi' yʌlʌ: C Yum Jesús, ch'ʌmbeñon c ch'ujlel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tsa' ñocle. C'am tsi' cha'le t'an: C Yum, mach a wʌq'ueñob ti' wenta ili i mul, che'en. Che' bʌ tsa' ujti i sub jini t'an tsa' chʌmi. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo uts'at tsi' yubi che' bʌ tsi' tsʌnsayob. Ti jim bʌ ora tsa' tejchi cabʌl tic'laya ti' contra jini xñopt'añob tsa' bʌ i tempayob i bʌ ti Jerusalén. Ti pejtelelob tsa' pam pujquiyob ti pejtelel Judea yic'ot ti Samaria. Cojach jini apóstolob ma'anic tsa' pujquiyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Winicob mu' bʌ i ch'ujutesañob Dios tsi' q'uecheyob majlel Esteban cha'an mi' mucob. Cabʌl tsi' yuc'tayob. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo tsi' ñopo i jisan jini xñopt'añob. Tsa' ochi ti jujump'ejl otot. Tsi' wersa chucu majlel winicob x'ixicob. Tsi' yotsayob ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jini tsa' bʌ pujquiyob, tsa' pam ñumiyob ti subt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe tsa' caji' jubel majlel ti tejclum i c'aba' Samaria. Ya' tsi' subu i t'an Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Bajc'ʌl winicob x'ixicob ti jump'ejlob jach i pusic'al tsi' jac'beyob i t'an Felipe che' bʌ tsi' yubiyob, che' bʌ tsi' q'ueleyob i yejtal i p'ʌtʌlel tsa' bʌ i pʌsʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Come cabʌl tsa' loq'uiyob i xibʌjlel. Wen c'am tsi' cha'leyob t'an jini xibajob che' bʌ tsa loq'uiyob. Cabʌl tsa' lajmesʌntiyob jini mach bʌ weñobic i yoc i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jini cha'an wen tijicña tsa' caji i yubiñob ya' ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Juntiquil winic i c'aba' Simón, tsa' bʌ i cha'le wujt ti yambʌ ora, cabʌl tsi' loti tejclumob ti Samaria. Tsi' subu i bʌ ti ñuc. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ti pejtelelob tsi' wen ubibeyob i t'an, jini ch'o'ch'oco' bʌ yic'ot jini ñuco' bʌ. Tsi' yʌlʌyob: Jiñʌch jini ñuc bʌ i p'ʌtʌlel Dios, lon che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Tsi' wen jac'beyob come c'ʌlʌl ti wajali tsa' toj sajtiyob i pusic'al cha'an leco tac bʌ i melbal. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Tsa' caji i ñopbeñob i t'an Felipe che' bʌ tsi' subeyob jini wen t'an cha'an i yumʌntel Dios ti' c'aba' Jesucristo. Wʌle cabʌl winicob x'ixicob tsi' ch'ʌmʌyob ja'. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón tsi' ñopo ja'el. Che' bʌ tsa'ix i ch'ʌmʌ ja', tsa' jale yic'ot Felipe. Tsa' toj sajti i pusic'al che' bʌ tsi' q'uele i yejtal i p'ʌtʌlel yic'ot ñuc bʌ i melbal tsa' bʌ i cha'le Felipe. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jini apóstolob añob ti Jerusalén. Che' yujilobix wolix i ñopob i t'an Dios ya' ti Samaria, tsi' chocoyob majlel Pedro yic'ot Juan ya' ba' añob. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Che' bʌ tsa' c'otiyob ti Samaria, tsi' c'ajtibeyob Dios ti oración cha'an mi' yʌq'uen winicob x'ixicob jini Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Come maxto anic tsa' aq'uentiyob Ch'ujul bʌ Espíritu jini año' bʌ ti Samaria. Cojax to tsi' ch'ʌmʌyob ja' ti' c'aba' Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pedro yic'ot Juan tsi' yʌc'ʌyob i c'ʌb ti' jol. Tsa' aq'uentiyob Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Che' bʌ tsi' q'uele Simón aq'uebilobix Ch'ujul bʌ Espíritu cha'an tsi' yʌq'ueyob i c'ʌb jini apóstolob, Simón tsi' pʌsbeyob taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tsi' subeyob: Aq'ueñon ja'el a p'ʌtʌlel cha'an mi cʌq'uen Ch'ujul bʌ Espíritu majqui jach com che' mi cʌq'ueñob j c'ʌb ti' jol, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro tsi' sube: La' jilic a taq'uin a wic'ot, come wola' lon ña'tan ti a pusic'al mi mejlel a mʌn yic'ot taq'uin a majtan ch'oyol bʌ ti Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Maxto ochemetic ti jini e'tel. Mach a cha'anic. Come mach tojic a pusic'al ti' wut Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cʌyʌ a jontolil. C'ajtiben Dios cha'an mi' ñusʌbeñet jini tsa' bʌ a ña'ta ti a pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Come mij q'uel an ch'aj bʌ i tsʌytsʌyñʌyel a pusic'al. Chucbilet ti jontolil, che'en Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón tsi' jac'ʌ: C'ajtiben lac Yum cha'an ma'anic mi' wis tajon jini tsa' bʌ a wʌlʌ, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro yic'ot Juan, che' bʌ tsi' subeyob i t'an lac Yum yic'ot chuqui tac tsi' q'ueleyob ti' tojlel lac Yum, tsa' sujtiyob ti Jerusalén. Tsi' subuyob jini wen t'an ti cabʌl tejclum tac ya' ti Samaria. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","I yángel lac Yum tsi' pejca Felipe. Tsi' sube: Ch'ojyen, cucu ti sur ba'an colem bʌ i tiquiñal pañimil ti' bijlel Gaza mu' bʌ i jubel loq'uel ti Jerusalén, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Tsa' ch'ojyi Felipe, tsa' majli. Awilan, ya'an juntiquil eunuco ch'oyol bʌ ti Etiopía. An ñuc bʌ i ye'tel cha'an x'ixic bʌ yumʌl ti Etiopía i c'aba' Candace. Jini winic tsi' cʌntʌbe pejtelel i chubʌ'an. Tsajni jini winic ti Jerusalén cha'an mi' ch'ujutesan Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Wolix ti cha' sujtel, buchul ti carreta mu' bʌ i tujc'ʌntel majlel. Woli' q'uel i jun jini x'alt'an Isaías. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jini Espíritu tsi' sube Felipe: Cucu ba'an jini carreta. Yom ma' majlel yic'ot, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Felipe tsa' majli ti lʌc'ʌl. Tsi' yubibe i t'an jini winic che' bʌ woli' pejcan i jun jini x'alt'an Isaías. Felipe tsi' sube: ¿Mu' ba a ch'ʌmben isujm jini t'an woli bʌ a q'uel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jini winic tsi' yʌlʌ: ¿Bajche' mi mejlel c ch'ʌmben isujm mi ma'anic majqui mi' cʌntesañon? che'en. Tsi' sube letsel Felipe cha'an mi' buchtʌl yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ya' ba' woli' q'uel i Ts'ijbujel Dios an jini t'an: “Tsa' pʌjyi majlel cha'an mi' chʌmel che' bajche' tiñʌme'. Che' bajche' alʌ tat tiñʌme' ñʌch'ʌl bʌ ti' tojlel jini mu' bʌ i tsepben i tsutsel, ma'anic tsi' cha'le t'an jini winic. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Pec' tsi' mele i bʌ. Jini año' bʌ i ye'tel ma'anic tsi' meleyob ti toj. ¿Majqui mi mejlel i tsicben i yalobilob jini winic? Come tsa' tsʌnsʌnti ila ti pañimil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jini eunuco tsi' c'ajtibe Felipe: Awocolic subeñon, ¿majqui jini tsa' bʌ ña'tʌnti ti' t'an jini x'alt'an? ¿Jim ba jini x'alt'an Isaías o jim ba yambʌ winic? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Felipe tsa' caji ti t'an. Tsa' caji i suben jini wen t'an cha'an Jesús che' bajche' ts'ijbubil i cha'an Isaías. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Che' woli' majlelob ti bij, tsa' c'otiyob ba'an ja'. Jini eunuco tsi' sube: Q'uele, wʌ'an ja'. ¿Am ba chuqui mi' mʌctañon cha'an mic ch'ʌm ja? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe tsi' sube: Mi wola' ñop ti pejtelel a pusic'al, mi mejlel a ch'ʌm ja', che'en. Jini eunuco tsi' jac'be: Mic ñop i Yalobilʌch Dios jini Jesucristo, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jini eunuco tsi' yʌc'ʌ mandar cha'an mi' cʌy i xʌmbal jini carreta. Tsa' jubiyob ti ja' ti' cha'ticlelob, Felipe yic'ot jini eunuco. Felipe tsi' yʌq'ue ch'ʌmja'. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Che' bʌ tsa' loq'uiyob ti ja', i yEspíritu lac Yum tsi' jʌm chucu majlel Felipe. Jini eunuco ma'anix tsi' chʌn q'uele. Tijicña i pusic'al tsa' majli ti bij. ");
INSERT INTO ctuBl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ya' tsa' tajle Felipe ti Azoto. Che' bʌ tsa' ñumi majlel, tsi' subu jini wen t'an ti pejtelel tejclum tac c'ʌlʌl ti Cesarea. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo woli to ti a'leya ti' contra xcʌnt'añob i cha'an lac Yum. Yom i tsʌnsañob. Tsa' tili ba'an ñuc bʌ motomaj. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tsi' c'ajtibe jun cha'an mi' pʌs ti sinagoga tac ya' ti Damasco. Jini jun tsi' yʌq'ue i ye'tel cha'an cʌchbil mi' pʌyob majlel ti Jerusalén pejtelel woli bʌ i ñopbeñob i bijlel Cristo, mi tsi' tajayob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Che' woli' majlel ti bij, che' yomix c'otel ti Damasco, ora jach tsa' tili i sʌclel c'ajc ch'oyol bʌ ti panchan ti' joytilel Saulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tsa' yajli ti lum. Tsi' yubi t'an tsa' bʌ i sube: Saulo, Saulo, ¿chucoch ma' tic'lañon? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo tsi' yʌlʌ: ¿Majquiyet c Yum? che'en. Tsi' sube: Joñoñʌch Jesús woli bʌ a tic'lan, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo, tsiltsilña ti bʌq'uen, tsi' sube: C Yum, ¿chuqui a wom mic cha'len? che'en. Lac Yum tsi' sube: Ch'ojyen. Ochen ti tejclum. Mi caj a subentel chuqui yom ma' cha'len, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Winicob woli bʌ i pi'leñob Saulo ti xʌmbal ñʌch'ʌl tsa' cʌleyob cha'an bʌq'uen. Come ti isujm tsi' yubiyob t'an, pero ma'anic tsi' q'ueleyob majqui woli ti t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo tsa' ch'ojyi ti lum. Che' cañalix i wut, ma'anic chuqui tsa' mejli i q'uel. Jini i pi'ʌlob tsi' toj'esayob majlel ti' c'ʌb. Tsi' pʌyʌyob majlel ti Damasco. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Uxp'ejl q'uin tsa' cʌle ti xpots'. Ma'anic chuqui tsi' c'uxu. Ma'anic chuqui tsi' japʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","An juntiquil xcʌnt'an ti Damasco, i c'aba' Ananías. Tsi' q'uele chuqui tsa' pʌsbenti ti lac Yum. Lac Yum tsi' sube: Ananías, che'en. Ananías tsi' jac'ʌ: Wʌ' añon c Yum, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Lac Yum tsi' sube: Ch'ojyen. Cucu ti bij, i c'aba' Toj. Ya' ti' yotot Judas, sajcan juntiquil winic i c'aba' Saulo, ch'oyol bʌ ti Tarso. Awilan, woli' pejcan Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saulo tsa'ix i q'ueleyet che' bajche' ti ñajal, Ananías. Tsi' q'uele tsa' wʌc'ʌ a c'ʌb ti' jol cha'an mi' cha' c'otel i wut, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananías tsi' jac'ʌ: C Yum, cabʌl tsa cubi t'an cha'an jini winic. Cabʌl i jontolil tsa' bʌ i cha'le ti' contra a cha'año' bʌ ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","An i ye'tel ilayi aq'uebil cha'an ñuc bʌ motomajob cha'an mi' cʌch pejtelel mu' bʌ i pejcañob a c'aba', che'en Ananías. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lac Yum tsi' sube: Cucu, come yajcʌbilʌch c cha'an, cha'an mi' sub majlel j c'aba' ti' tojlel gentilob yic'ot reyob yic'ot israelob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Come mi caj c pʌsben bajche' c'amel mi caj i yubin wocol cha'an tij c'aba', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías tsa' majli. Tsa' ochi ti otot. Che' bʌ tsi' yʌc'ʌ i c'ʌb ti' jol Saulo, tsi' yʌlʌ: Hermano Saulo, c Yum Jesús tsa' bʌ tsictiyi ti bij che' bʌ tsa' tiliyet, tsi' chocoyon tilel cha'an mi' cha' c'otel a wut, cha'an ma' bujt'el ti Ch'ujul bʌ Espíritu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ti ora jach tsa' c'ajli loq'uel i sujl i wut. Tsa' cha' c'oti i wut. Tsa' ch'ojyi Saulo. Tsi' ch'ʌmʌ ja'. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Che' ujtemix ti we'el tsi' cha' taja i p'ʌtʌlel. Cha'p'ejl uxpejl q'uin tsa' jale Saulo yic'ot xcʌnt'añob ti Damasco. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tsi' bʌc' subu t'an cha'an Cristo ti sinagoga tac. Tsi' yʌlʌ: I Yalobilʌch Dios jini Cristo, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tsa' toj sajtiyob i pusic'al pejtelel tsa' bʌ i yubiyob. Tsi' yʌlʌyob: ¿Mach ba jinic tsa' bʌ i tic'la jini mu' bʌ i pejcañob i c'aba' Cristo ya' ti Jerusalén? Jini cha'an tsa' tili wʌ'i cha'an cʌchbil mi' pʌyob majlel ti' tojlel ñuc bʌ motomajob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ñumen cabʌl tsa' p'ojli i p'ʌtʌlel Saulo. Ma'anic chuqui tsa' mejli i jac'ob jini judíojob chumulo' bʌ ti Damasco, come Saulo tsi' wen tsictesʌbeyob Cristojʌch jini Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Che' bʌ tsa' ñumi cabʌl q'uin, jini judíojob tsi' comol pejcayob i bʌ. Tsi' ña'tayob bajche' mi caj i tsʌnsañob Saulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ubibilix i cha'an Saulo che' woli' chijtañob. Ti q'uiñil ti ac'ʌlel tsi' chijtayob ya' ti' ti' tac tejclum cha'an mi' tsʌnsañob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jini cha'an jini xcʌnt'añob tsi' pʌyʌyob majlel ti ac'ʌlel. Tsi' ju'sayob ti colem chiquib ti' ñʌc' jini chan bʌ ts'ajc. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Che' bʌ tsa' c'oti Saulo ti Jerusalén, tsi' ñopo i tem ajñel yic'ot xcʌnt'añob. Ti pejtelel tsi' bʌc'ñayob. Ma'anic tsi' ñopoyob mi xcʌnt'an Saulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bernabé tsi' taja. Tsi' pʌyʌ majlel ba'an jini apóstolob. Tsi' subeyob: Jiñʌch Saulo. Tsi' q'uele lac Yum ti bij. Lac Yum tsi' pejca. Ya' ti Damasco ch'ejl i pusic'al tsi' cha'le subt'an ti' c'aba' Jesús, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jini cha'an temel tsa' ajni Saulo yic'otob ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ch'ejl i pusic'al tsi' cha'le subt'an ti' c'aba' lac Yum. Tsi' subeyob jini griegojob jini wen t'an. Tsi' contrajiyob i bʌ ti t'an. Jini griegojob yomob i tsʌnsan Saulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Che' yujilobix jini hermanojob, tsi' pʌyʌyob majlel ti Cesarea. Tsi' chocoyob majlel ti Tarso. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tsa' ñʌjch'i i tic'lʌntel jini xñopt'añob ti pejtelel Judea yic'ot ti Galilea yic'ot ti Samaria. Tsa' p'ʌtesʌntiyob. Tsi' chʌn bʌc'ñayob lac Yum. Tsa' ñuc'ayob i pusic'al cha'an Ch'ujul bʌ Espíritu. Tsa' wen p'ojliyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Che' bʌ tsa' ñumi majlel Pedro ti pejtelel lum, tsa' c'oti i jula'tan i cha'año' bʌ lac Yum ya' bʌ chumulob ti Lida. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ya' tsi' taja juntiquil winic, i c'aba' Eneas. Ñolol ti' wʌyib waxʌcp'ejl jab. Mach wenic i yoc i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro tsi' sube: Eneas, Jesucristo woli' lajmesañet. Ch'ojyen. Teche a wʌyib, che'en. Ti ora jach tsa' ch'ojyi. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pejtelel jini ya' bʌ chumulob ti Lida yic'ot ti Sarón tsi' q'ueleyob. Tsi' sutq'uiyob i bʌ cha'an mi' ñopob lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ya' ti Jope an xcʌnt'an i c'aba' Tabita, jiñʌch Dorcas. Jini x'ixic bʌxatax ti wen bʌ i ye'tel tsa' bʌ i cha'le. Tsi' yʌq'ueyob i chubʌ'an jini mach bʌ añobic i cha'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ti jini jach bʌ semana tsa' c'am'a. Tsa' chʌmi. Che' bʌ tsa'ix ujti i pocob, tsi' yʌc'ʌyob ti jump'ejl i mal otot. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lʌc'ʌl an Lida ti Jope. Jini xcʌnt'añob che' bʌ tsi' yubiyob ya'an Pedro ti Jope, tsi' chocoyob majlel cha'tiquil winicob ba'an. Tsi' subeyob: Awocolic mach ma' chʌn jalijel ilayi. La' ti ora ba' añon lojon, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jini cha'an Pedro tsa' ch'ojyi, tsa' majli yic'otob. Che' bʌ tsa' c'oti, tsi' pʌyʌyob ochel. Ya' wa'alob pejtelel jini meba' x'ixicob ti' joytilel Pedro, woliyob ti uq'uel. Tsi' pʌsbeyob cabʌl chaqueta yic'ot bujcʌl tsa' bʌ i mele Dorcas che' anto yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro tsi' subeyob cha'an mi' loq'uelob ti pejtelelob. Tsa' ñocle. Tsi' pejca Dios. Ti wi'il tsi' sutq'ui i bʌ cha'an mi' q'uel jini ch'ujlelʌl. Tsi' sube: Ch'ojyen, Tabita, che'en. Tsa' cajni i wut. Che' bʌ tsi' q'uele Pedro, tsa' buchle. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro tsi' yʌq'ue i c'ʌb. Tsi' teche. Che' bʌ tsa'ix i cha' pʌyʌ ochel i cha'año' bʌ lac Yum yic'ot jini meba' x'ixicob, tsi' pʌsbeyob cha' cuxulix Dorcas. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tsa' caji ti cʌjñel ti pejtelel Jope. Cabʌl tsi' ñopoyob lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ya' tsa' jale Pedro cabʌl q'uin ti Jope ti' yotot Simón, jini sts'aj pʌchi. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ya'an winic ti Cesarea, i c'aba' Cornelio. An ti' wenta Cornelio jo'c'al soldadojob i c'aba' Italiana. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tsi' ch'ujutesa Dios jini winic. Tsi' bʌc'ña Dios yic'ot pejtelel año' bʌ ti' yotot. Tsi' yʌq'ueyob cabʌl i majtan jini p'ump'uño' bʌ. Pejtelel ora tsi' pejca Dios ti oración. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Che' ti och'ajel q'uin an chuqui tsi' q'uele tilem bʌ ti panchan. Juntiquil i yángel Dios tsa' ochi ba'an. Jini ángel tsi' pejca: Cornelio, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio tsi' cha'le bʌq'uen che' bʌ tsi' q'uele jini ángel. Tsi' sube: ¿Chuqui a wom c Yum? che'en. Jini ángel tsi' sube: A woración yic'ot i majtan tac p'ump'uño' bʌ mu' bʌ a wʌq'ueñob woli' ña'tʌntel ti Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Choco majlel winicob ti Jope. Pʌyʌ tilel Simón, jini am bʌ i cha'chajplel i c'aba' Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ya' jijlem Pedro ti' yotot Simón, jini sts'aj pʌchi. Lʌc'ʌl an i yotot ti' ti' colem ñajb. Pedro mi caj i subeñet chuqui yom ma' cha'len, che'en jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Che' majlemix jini ángel tsa' bʌ i pejca, Cornelio tsi' pʌyʌ tilel cha'tiquil i winicob yic'ot juntiquil soldado tsa' bʌ i coltayob ti' ye'tel. Jini soldado tsi' ch'ujutesa Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Che' bʌ tsi' subeyob chuqui tsa' ujti, Cornelio tsi' chocoyob majlel ti Jope. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ti yijc'ʌlal, che' woliyob ti xʌmbal majlel ti bij, che' lʌc'ʌlix añob ti tejclum, Pedro tsa' letsi ti' jol otot cha'an mi' pejcan Dios. Ts'ita jax yom i taj xinq'uiñil. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Anix cabʌl i wi'ñal. Yomix i cha'len we'el. Che' woli to i chajpañob we'elʌl an chuqui tsi' q'uele Pedro ti espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Tsi' q'uele calal jini panchan. Woli' jubel tilel che' bajche' colem pisil cʌchbil ti chʌmp'ejlel i xujc. Tsa' ju'sʌnti c'ʌlʌl ti lum. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ya' ti mal jini pisil an cabʌl alʌc'ʌl, yic'ot bʌte'el ti chajp ti chajp, yic'ot jini jʌlʌcña bʌ, yic'ot te'lemut. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Tsa' c'oti t'an, tsi' sube: Ch'ojyen, Pedro. Tsʌnsan. C'uxu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro tsi' sube: Mach che'iqui c Yum, come ma'anic ba' ora tsaj c'uxu chuqui tac tic'bil mi chuqui tac bibi', che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ti' cha'yajlel tsa' c'oti jini t'an ba'an Pedro: Mach a ts'a'len jatet, chuqui tac tsa'ix i sʌq'uesa Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Uxyajl tsa' c'oti jini t'an. Ti wi'il jini pisil tsa' cha' chujqui letsel ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Che' woli' chʌn ña'tan Pedro chuqui i sujmlel jini tsa' bʌ ujti i q'uel, awilan, tsa' tiliyob jini winicob chocbilo' bʌ tilel i cha'an Cornelio. Tsi' c'ajtibeyob baqui an i yotot Simón. Tsa' c'otiyob ti' ti'. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Che' bʌ tsi' cha'leyob pʌyoñel, tsi' c'ajtibeyob mi ya' jijlem Simón jini am bʌ i cha'chajplel i c'aba' Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Che' woli to i ña'tan Pedro chuqui i sujmlel jini tsa' bʌ ujti i q'uel, jini Espíritu tsi' sube: Awilan, uxtiquil winicob woli' sajcañetob. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ch'ojyen, che' jini. Juben. Cucu yic'otob. Mach yomic tile bixel a pusic'al, come joñon tsac chocoyob tilel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro tsa' jubi majlel ba'an jini winicob chocbilo' bʌ tilel i cha'an Cornelio. Tsi' subeyob: Awilan joñoñʌch, woli la' sajcañon. ¿Chucoch tsa' tiliyetla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tsi' subeyob: Jini Cornelio, i yaj capitán jo'c'al soldadojob, jini wen toj bʌ, mi' bʌc'ñan Dios. Cʌmbil i cha'an pejtelel israelob weñʌch i melbal. Juntiquil ch'ujul bʌ ángel tsi' sube Cornelio cha'an mi' pʌyet majlel ti' yotot cha'an mi' yubin chuqui ti t'an ma' sub, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pedro tsi' subeyob ochel. Tsi' we'sayob. Ti yijc'ʌlal tsa' ch'ojyi, tsa' majli yic'otob. Lamital jini hermanojob ti Jope tsi' pi'leyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ti yijc'ʌlal tsa' ochiyob ti Cesarea. Cornelio wolix i pijtañob. Tsa'ix i tempa cabʌl i pi'ʌlob yic'ot i cʌñʌyo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Che' bʌ tsa' ochi Pedro ti otot, tsa' tili Cornelio i taj. Cornelio tsi' ñocchoco i bʌ ti' tojel. Tsa' caji i ch'ujutesan. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro tsi' teche ch'ojyel. Tsi' sube: Ch'ojyen. Winicon ja'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Che' bʌ woli' pejcañob i bʌ, tsa' ochi Pedro ti' mal otot. Tsi' taja cabʌl tempʌbilo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tsi' subeyob: La' wujil tic'bil ti mandar mi' yajñel judío yic'ot winic ch'oyol bʌ ti yambʌ lum. Tic'bil mi' jula'tan. Dios tsi' pʌsbeyon mach wenic mic ts'a'len winicob mi juntiquilic. Mach mejlic c bi'leñob. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jini cha'an tsa' tiliyon che' bʌ tsa' pʌyʌyon tilel. Ma'anic tsac ñusa c pʌyol. Jini cha'an mij c'ajtibeñetla, ¿chucoch tsa' la' pʌyʌyon tilel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio tsi' sube: Anix chʌmp'ejl q'uin che' bajche' ti ili ora woliyon ti oración. Che' ti och'ajel q'uin, awilan juntiquil winic tsa' wa'le ti' tojel c wut. Wen sʌcxowan i bujc. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Jini winic tsi' subeyon: “Cornelio, ubibilix a woración i cha'an Dios. Ña'tʌbil i cha'an Dios, tsa'ix a wʌq'ue i majtan jini p'ump'uño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jini cha'an, choco majlel winicob c'ʌlʌl ti Jope. Pʌyʌ tilel Simón, jini am bʌ i cha'chajplel i c'aba' Pedro. Ya jijlem ti' yotot Simón jini sts'aj pʌchi lʌc'ʌl bʌ ti' ti' colem ñajb. Che' tilemix mi caj i pejcañet”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Jini cha'an ti ora jach tsac chocoyob majlel ba' añet. Uts'at tsa' tiliyet. Wʌle wʌ' temel añon lojon ti' wut Dios tic pejtelel lojon cha'an mi cubin lojon pejtelel chuqui tsi' subeyet Dios. Che' tsi' yʌlʌ Cornelio. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro tsa' caji ti t'an. Tsi' yʌlʌ: Mic ña'tan ti isujm, junlajal mi' q'uel winicob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ti pejtelel lum Dios mi' q'uel ti uts'at jini mu' bʌ i bʌc'ñañob, mu' bʌ i cha'leñob chuqui toj. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios tsi' choco tilel i t'an ba'an israelob. Tsi' subeyob jini wen t'an cha'an mi' tajob i ñʌch'tilel i pusic'al ti Jesucristo, jiñʌch i Yum pejtelel winicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ubibil la' cha'an jini t'an tsa' bʌ pujqui ti pejtelel Judea. Ya' tsa' tejchi ti Galilea che' bʌ tsi' subu Juan cha'an mi' ch'ʌmob ja'. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dios tsi' yajca Jesús, jini loq'uem bʌ ti Nazaret. Tsi' yʌq'ue Ch'ujul bʌ Espíritu yic'ot i p'ʌtʌlel. Baqui jach tsa' ñumi tsi' cha'le uts'at bʌ i ye'tel. Tsi' lajmesa pejtelel jini tic'lʌbilo' bʌ cha'an xiba, come an Dios yic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Joñon lojon tsaj q'uele lojon pejtelel chuqui tsi' mele Jesús ti Judea yic'ot ti Jerusalén. Jini judíojob tsi' tsʌnsayob. Tsi' ch'ijiyob ti te'. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Dios tsi' teche ch'ojyel ti' yuxp'ejlel q'uin. Tsi' yʌc'ʌ ti q'uejlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mach ti' wutic pejtelel winicob x'ixicob, cojach tic wut lojon tsa' bʌ c cha'le lojon we'el, uch'el yic'ot Jesús che' ch'ojyemix loq'uel ba'an chʌmeño' bʌ. Dios tsi' wa'chocoyon lojon ti testigo cha'an mic laj sub chuqui tsaj q'uele lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesús tsi' yʌq'ueyon lojon mandar cha'an mic subeñob winicob x'ixicob jiñʌch Jesús jini yajcʌbil bʌ i cha'an Dios mu' bʌ caj i cha'len meloñel. Mi caj i mel jini cuxulo' bʌ yic'ot chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pejtel x'alt'añob tsi' yʌlʌyob mi caj i ñusʌbentelob i mul ti' c'aba' Jesús pejtelel mu' bʌ i ñopob. Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Che' woli to i sub jini t'an Pedro, tsa' aq'uentiyob Ch'ujul bʌ Espíritu pejtelel tsa' bʌ i yubibeyob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jini hermanojob tsepbilo' bʌ i pʌchʌlel, tsa' bʌ i pi'leyob majlel Pedro, tsa' toj sajtiyob i pusic'al, come tsa' aq'uentiyob gentilob ja'el jini Ch'ujul bʌ Espíritu ti' majtan jach. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Come tsi' yubiyob woliyob ti t'an ti yan tac bʌ t'an. Woli' subob i ñuclel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pedro tsi' c'ajtibeyob: ¿Mejl ba mi lac tic'ob ti ch'ʌmja' jini tsa' bʌ aq'uentiyob jini Ch'ujul bʌ Espíritu che' bajche' tsa' aq'uentiyonla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Tsi' subeyob cha'an mi' ch'ʌmob ja' ti' c'aba' Jesucristo. Jini gentilob tsi' subeyob Pedro ti wocol t'an cha'an mi' jalijel yic'otob cha'p'ejl uxp'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jini apóstolob yic'ot jini hermanojob año' bʌ ti Judea tsi' yubiyob tsa'ix i jac'beyob i t'an Dios jini gentilob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Che' bʌ tsa' tili Pedro ti Jerusalén, jini woli bʌ i ñopob tsep pʌchʌlel tsi' yʌ'leyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tsi' subeyob: ¿Chucoch tsa' ochiyet ti' yotot winicob mach bʌ tsepbilobic i pʌchʌlel? ¿Chucoch tsa' cha'le we'el yic'otob? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Quepecña tsa' caji i sub Pedro chuqui tsa' ujti. Tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Che' ya' añon ti tejclum i c'aba' Jope che' wolic pejcan Dios, an chuqui tsaj q'uele tilem bʌ ti panchan. Tsa' jubi tilel ti panchan che' bajche' colem pisil ju'sʌbil ti chʌmp'ejlel i xujc. Tsa' c'oti ba' añon. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Che' bʌ tsac wen q'uele, ya'an alac'ʌl, yic'ot jontol tac bʌ bʌte'el, yic'ot lucum yic'ot te'lemut. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Tsa cubi t'an. Tsi' subeyon: “Ch'ojyen, Pedro. Tsʌnsan, c'uxu”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Tsac subu: “Ma'anic, c Yum, come ma'anic ba' ora tsa' ochi ti quej chuqui tac tic'bil, mi chuqui tac bibi”, cho'on tsac sube. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jini t'an ch'oyol bʌ ti panchan tsi' jac'beyon ti' cha'yajlel: “Mach a ts'alen chuqui tac tsa'ix i sʌq'uesa Dios”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Uxyajl tsa' c'oti jini t'an. Ti wi'il tsa' cha' chujqui letsel ti panchan ti pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Awilan, tsa' bʌc' tiliyob uxtiquil winicob ti jini otot ba' añon. Chocbilob tilel ti Cesarea tsa' tiliyob ba' añon. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jini Espíritu tsi' subeyon mach yomic tile bixel c pusic'al. Yom abi mic majlel ti ora yic'otob. Ili wʌctiquil hermanojob tsa' majliyob quic'ot ja'el. Tsa' ochiyon lojon ti' yotot Cornelio. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Tsi' subeyon lojon bajche' tsi' q'uele juntiquil ángel wa'al ti' yotot. Jini ángel tsi' sube: “Choco majlel winicob ti Jope. Pʌyʌ tilel Simón, jini am bʌ i cha'chajplel i c'aba' Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mi caj i subeñet t'an cha'an mi la' coltʌntel, jatet yic'ot pejtelel año' bʌ ti a wotot”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Che' bʌ tsa' cajiyon ti t'an, tsa' aq'uentiyob Ch'ujul bʌ Espíritu ja'el che' bajche' tsa' aq'uentiyonla ti ñaxan. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tsac ña'ta i t'an lac Yum tsa' bʌ i yʌlʌ: “Isujm, Juan tsi' yʌq'ueyetla ch'ʌmja' ti ja', pero mi caj la' wʌq'uentel la' ch'ʌm Ch'ujul bʌ Espíritu”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dios tsi' yʌq'ueyob i majtan che' bajche' tsi' yʌq'ueyonla che' bʌ tsa' lac jac'be i t'an lac Yum Jesucristo. Mi che'ʌch tsi' mele Dios, ¿mejl ba mic tic' joñon? Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Che' bʌ tsi' yubibeyob i t'an, ñʌch'ʌl tsa' cʌleyob. Tsi' subuyob i ñuclel Dios. Tsi' yʌlʌyob: Dios tsa'ix i yʌq'ueyob gentilob ja'el i cʌyob i mul cha'an mi' tajob i cuxtʌlel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Che' bʌ tsa' chʌmi Esteban tsa' tejchi cabʌl tic'laya. Jini winicob tsa' bʌ pam pujquiyob cha'an i tic'lʌntel tsa' majliyob c'ʌlʌl ti Fenicia yic'ot ti Chipre, yic'ot ti Antioquía. Jini jach judíojob tsa' subentiyob jini wen t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","An ja'el winicob ch'oyolo' bʌ ti Chipre yic'ot ti Cirene tsa' bʌ ochiyob ti Antioquía. Tsi' pejcayob griegojob ja'el. Tsi' subeyob jini wen t'an cha'an lac Yum Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","An i p'ʌtʌlel lac Yum yic'otob. Wen cabʌl tsi' sutq'uiyob i bʌ cha'an mi' ñopob lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jini xñopt'añob mu' bʌ i tempañob i bʌ ti Jerusalén tsi' yubiyob chuqui tsa' ujti. Tsi' chocoyob majlel Bernabé c'ʌlʌl ti Antioquía. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Che' bʌ tsa' c'oti Bernabé ya' ti Antioquía, tijicña i pusic'al come tsi' q'uele añob ti' yutslel i pusic'al Dios. Tsi' xic'beyob ti pejtelelob cha'an mi' chʌn ñopob lac Yum ti' xuc'tilel i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Uts'at i pusic'al Bernabé. But'ul ti Ch'ujul bʌ Espíritu. Ñopol i cha'an i t'an Dios ti jump'ejl i pusic'al. Cabʌl winicob x'ixicob tsi' ñopoyob lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ti wi'il tsa' majli Bernabé ti Tarso cha'an mi' sʌclan Saulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Che' bʌ tsi' taja, tsi' pʌyʌ majlel ti Antioquía. Jump'ejl jab tsa' tem ajniyob ya'i yic'ot jini xñopt'añob mu' bʌ i tempañob i bʌ. Tsi' cʌntesayob cabʌl winicob x'ixicob. Ya' ti Antioquía tsa' tejchi i pejcʌntelob ti cristianojob jini xcʌnt'añob cha'an tsi' tsajcayob Cristo. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tsa' cajiyob ti jubel majlel ti Antioquía x'alt'añob ch'oyolo' bʌ ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Tsa' wa'le juntiquil i c'aba' Agabo. Ti' p'ʌtʌlel jini Espíritu tsi' subeyob tal wi'ñal ti pejtelel pañimil. Jini wi'ñal tsa' caji che' ochemix Claudio ti' ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jini xcʌnt'añob tsi' ña'ta i chocbeñob majlel i majtan jini hermanojob año' bʌ ti Judea che' bajche' c'amel tsa' mejli i yʌc'ob ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Che'i tsi' cha'leyob. Tsi' chocoyob majlel ti' c'ʌb Bernabé yic'ot Saulo cha'an mi' yʌq'ueñob jini ancianojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ti jini jach bʌ ora jini rey Herodes tsa' caji i wersa tic'lan lamital jini xñopt'añob mu' bʌ i tempañob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Tsi' set' t'ojbe loq'uel i bic' Jacobo, i yʌscun Juan. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Che' bʌ tsi' q'uele Herodes tijicñayob judíojob cha'an tsi' tsʌnsa Jacobo, tsa' caji i chuc Pedro ja'el. I q'uiñilelix caxlan waj mach bʌ anic i levadurajlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Che' bʌ tsa'ix i chucu Pedro, tsi' yotsa ti mʌjquibʌl. Tsi' yʌc'ʌ ti cʌntʌntel cha'an wʌclujuntiquil (16) soldadojob. Ti chʌnchʌntiquilob tsi' cʌntayob. Herodes tsi' ña'ta i loc'san Pedro che' ñumenix Pascua cha'an mi' mel ti' wut xtejclumob. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jini cha'an cʌntʌbil Pedro ti mʌjquibʌl. Jini xñopt'añob mu' bʌ i tempañob i bʌ tsi' c'ajtibeyob Dios ti oración ti pejtelel ora cha'an Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ti jini jach bʌ ac'ʌlel che' yomix Herodes i pʌy loq'uel Pedro, ya'an Pedro xinlʌpʌl i cha'an cha'tiquil soldadojob, cʌchʌl ti cha't'ujm cadena. Jini xcʌntayajob woli' cʌntañob i ti' mʌjquibʌl ti jumpat. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Awilan, tsa' tili i yángel lac Yum ba'an Pedro. Tsa' tsictiyi c'ajc ti mʌjquibʌl. Jini ángel tsi' ñijca Pedro ti' ts'ejtʌl. Tsi' sube: Ch'ojyen ti ora, che'en. Tsa' tujq'ui jini cadena am bʌ ti' c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jini ángel tsi' sube: Cʌchʌ a bʌ ti a cajchiñʌc'. Lʌpʌ a xʌñʌb, che'en. Che'i tsi' mele Pedro. Jini ángel tsi' cha' sube: Lʌpʌ pʌl bʌ a bujc. La' tsajcañon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro tsi' tsajca loq'uel jini ángel. Mach yujilic Pedro mi isujm chuqui tsi' cha'le jini ángel. Woli jach ti ñajal tsi' lon ña'ta ti' pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Che' bʌ tsa'ix i ñusayob jini ñaxan bʌ xcʌntaya yic'ot jini wi'il bʌ tsa' tiliyob ba'an colem bʌ i ti' cárcel melbil bʌ ti tsucul taq'uin, ya' ba' mi' loq'uelob majlel ti tejclum. Yilol jach tsa' jajmi ti' wutob. Che' bʌ tsa' loq'uiyob ti mʌjquibʌl, che' bʌ tsi' xʌñʌyob majlel calle, tsi' bʌc' sʌtʌ i bʌ jini ángel. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Tsa' toj juli i pusic'al Pedro. Tsi' yʌlʌ: Wʌle mic ña'tan isujmʌch. Jini c Yum tsi' choco tilel i yángel. Tsi' coloyon ti' c'ʌb Herodes yic'ot ti' c'ʌb pejtelel judíojob tsa' bʌ i chijtayoñob. Che' tsi' yʌlʌ ti' pusic'al Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Che' bʌ tsa'ix i ña'ta, tsa' c'oti ti' yotot María, i ña' Juan, jini xcʌnt'an am bʌ i cha'chajplel i c'aba' Marcos. Ya' temel añob cabʌl xñopt'añob. Woli' pejcañob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pedro tsi' jats'ʌ i ti' corredor. Tsa' majli juntiquil xch'oc i c'aba' Rode i yubin majqui ya'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Che' bʌ tsi' cʌmbe i t'an Pedro, tijicña jax tsi' yubi. Ma'anic tsi' jambe i ti' corredor. Ajñel tsa' cha' ochi ti mal otot. Tsi' subeyob: Ixix wa'al Pedro ti' ti' corredor, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Tsi' subeyob: Sojquem a jol, che'ob. Rode tsi' chʌn subeyob: Ixʌch an, che'en. Tsi' yʌlʌyob: Jiñʌch i yángel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro tsa' to i chʌn jats'ʌ i ti' corredor. Che' bʌ tsi' jambeyob tsi' q'ueleyob. Tsa' toj sajtiyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro tsi' pʌsbeyob ti' c'ʌb cha'an mi' cʌyob i t'an. Tsi' tsictesʌbeyob bajche' lac Yum tsi' loc'sa ti mʌjquibʌl. Tsi' subeyob: Subenla Jacobo yic'ot jini hermanojob chuqui tsa' ujti, che'en. Tsa' loq'ui majlel. Tsa' majli ti yambʌ tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Che' bʌ tsa' sʌc'a, cabʌl tsi' cha'leyob t'an soldadojob cha'an mach tsiquilix Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes tsi' sʌcla Pedro. Tsi' c'ajtibeyob xcʌntayajob baqui an. Che' ma'anic tsi' tajayob tsi' yʌc'ʌ mandar cha'an mi' tsʌnsʌntelob. Pedro tsa' loq'ui ti Judea. Tsa' jubi majlel ti Cesarea. Ya' tsa' jale ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes tsa' caji i mich'len winicob año' bʌ ti Tiro yic'ot ti Sidón. Tsa' tiliyob jini winicob ba'an Herodes. Tsi' ñaxan mucul pejcayob Blasto, jini i yaj q'uel wʌyib Herodes. Tsi' c'ajtibeyob ti wocol t'an cha'an mi' cʌy i mich'leñob, come ya' woli' tajob i bʌl i ñʌc' ti' lumal Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Che' bʌ tsa' c'oti i yorajlel, tsa' buchle Herodes ti' buchlib ti meloñel. Lʌpʌl i cha'an i pislel rey. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Winicob tsi' cha'leyob c'am bʌ t'an: ¡Jiñʌch Dios woli bʌ ti t'an! ¡Mach winiquic woli bʌ ti t'an! che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ti ora i yángel lac Yum tsi' yotsʌbe i chʌmel, come ma'anic tsi' yʌc'ʌ ti ñuc Dios. Tsa' c'uxle ti motso'. Tsa' chʌmi. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tsa' ñojpi i t'an Dios, tsa' pujqui. ");
INSERT INTO ctuBl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé yic'ot Saulo tsa' loq'uiyob ti Jerusalén che' bʌ tsa' ujti i ye'tel. Tsi' pʌyʌyob majlel Juan yic'otob, jini am bʌ i cha'chajplel i c'aba' Marcos. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ya' añob x'alt'añob yic'ot xcʌntesajob ti' tojlel jini xñopt'añob mu' bʌ i tempañob i bʌ ti Antioquía: i c'aba'ob Bernabé, yic'ot Simón, jini am bʌ i cha'chajplel i c'aba' Niger, yic'ot Lucio ch'oyol bʌ ti Cirene, yic'ot Saulo, yic'ot Manaén, jini tsa' bʌ tem coli yic'ot jini yumʌl Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Che' woli' ch'ujutesañob lac Yum, che' woliyob ti ch'ajb, jini Ch'ujul bʌ Espíritu tsi' subeyob: Wa'choconla Bernabé yic'ot Saulo cha'an mi' melob jini e'tel tsa' bʌ c chajpʌbeyob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Che' bʌ tsa' ujtiyob ti ch'ajb yic'ot oración, tsi' yʌc'ʌyob i c'ʌb ti' jol. Tsi' subeyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jini cha'an tsa' majliyob ti Seleucia, come chocbilob majlel cha'an Ch'ujul bʌ Espíritu. Ya'i tsa' ochiyob ti barco cha'an mi' majlelob ti Chipre. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Che' bʌ tsa' c'otiyob ti Salamina tsa' caji i subob i t'an Dios ti' sinagoga tac judíojob. Juan ja'el tsi' pi'leyob majlel cha'an mi' coltañob ti' ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Che' bʌ tsa'ix i xʌñʌyob ñumel ti pejtelel Chipre, jini lum joyol bʌ ti ja', tsa' c'otiyob ti Pafos ti Chipre ba' tsi' tajayob juntiquil xwujt. Jiñʌch lot bʌ x'alt'an i c'aba' Barjesús, judíojʌch. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ya'an Barjesús yic'ot Sergio am bʌ i jol i c'aba' Paulo. An i ye'tel ti gobierno jini Sergio Paulo. Wen p'ip' i pusic'al. Tsi' pʌyʌ tilel Bernabé yic'ot Saulo come yom i yubin i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jini xwujt Elimas (come jiñʌch i c'aba' ti yambʌ t'an) tsi' contrajiyob. Woli' mʌctan i t'an Dios ame i ñop jini am bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jini cha'an Saulo, i c'aba'ʌch Pablo ja'el, but'ul ti Ch'ujul bʌ Espíritu, tsi' ch'ujch'uj q'uele. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Tsi' sube: But'ulet ti cabʌl lot yic'ot cabʌl jontolil. I yalobilet xiba. I contrajet pejtelel chuqui tac toj. ¿A wom to ba a chʌn xoyben jini toj bʌ i bijlel lac Yum? ");
INSERT INTO ctuBl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Wʌle mi' cajel i contrajiñet lac Yum. Awilan mi caj a wochel ti xpots'. Cabʌl ora ma'anic mi caj a q'uel i c'ʌc'al q'uin, che'en Pablo. Ti ora tsa' yajpi i wut, tsa' ochi ti ac'ʌlel yilal. Tsa' majli i sajcan majqui mi' toj'esan majlel ti' c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jini am bʌ i ye'tel, che' bʌ tsi' q'uele chuqui tsa' ujti, tsi' ñopo i t'an Dios. Tsa' toj sajti i pusic'al cha'an i cʌntesa lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Che' bʌ tsa' loq'uiyob ti Pafos, Pablo yic'ot i pi'ʌlob tsa' majliyob ti barco c'ʌlʌl ti Perge ti Panfilia. Juan tsi' cʌyʌyob. Tsa' cha' sujti ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo yic'ot i pi'ʌlob tsa' ñumiyob ti Perge. Tsa' c'otiyob ti Antioquía ti Pisidia. Ya'i tsa' ochiyob ti sinagoga che' ti' q'uiñilel c'aj o. Tsa' buchleyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Che' bʌ tsa' ujti i q'uelob jini ts'ijbubil bʌ mandar yic'ot i ts'ijbujel x'alt'añob, jini yumʌlob ti sinagoga tsi' chocoyob majlel winicob ba' añob. Tsi' subeyob: Winicob, c pi'ʌlob, mi an chuqui la' wom la' subeñob winicob x'ixicob cha'an mi la' ñuq'uesʌbeñob i pusic'al, subula, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jini cha'an Pablo tsa' wa'le. Ñaxan tsi' pʌsbeyob i c'ʌb cha'an mi' ñʌjch'elob. Tsi' yʌlʌ: Winicob, israelob, yic'ot pejtel mu' bʌ la' bʌc'ñan Dios, ñich'tanla. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","I Dios israelob tsi' yajca lac ñojte'el. Tsi' yʌq'ueyob i ñuclel che' ya' añob ti' lumal Egipto mach bʌ i cha'añobic. Tsi' pʌyʌyob loq'uel ti Egipto ti' p'ʌtʌlel i c'ʌb. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Cha'c'al jab Dios tsi' chʌn cuchbeyob i sajtemal ya' ti jochol bʌ lum. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tsi' jisʌbeyob i p'ʌtʌlel wuctiquil yumʌlob ya' ti' lumal Canaán. Dios tsi' t'oxbeyob lac ñojte'el i lumal Canaán. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ti wi'il tsi' yʌq'ueyob cabʌl juezob lujump'ejl i yuxc'al i cha'bajc' (450) jab c'ʌlʌl ti' yorajlel jini x'alt'an Samuel. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ti wi'il, tsi' c'ajtiyob i rey. Dios tsi' wa'chocobeyob Saúl cha'c'al jab. Jini Saúl i yalobilʌch Cis, loq'uem bʌ ti' p'olbal Benjamín. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Dios tsi' choco loq'uel ti' ye'tel. Tsi' wa'choco David ti' rey israelob. Dios tsi' yʌc'ʌ ti cʌjñel David che' bʌ tsi' yʌlʌ: “Jini David, i yalobil Isaí, jiñʌch mu' bʌ j q'uel ti uts'at. Mi caj i mel pejtelel chuqui com”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Dios tsi' ts'ʌctesa i t'an che' bʌ tsi' choco tilel ti Israel juntiquil xcoltaya, loq'uem bʌ ti' p'olbal David, jiñʌch Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Che' maxto tilemic Jesús, Juan tsi' subeyob pejtelel israelob cha'an mi' cʌyob i mul cha'an mi' ch'ʌmob ja'. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Che' wolix i ts'ʌctiyel i ye'tel, Juan tsi' yʌlʌ: “¿Majquiyon mi la' wʌl? Mach joñonic jini tal bʌ. Tal to juntiquil tic pat. Mach uts'atonic cha'an mic ticben i xʌñʌb am bʌ ti' yoc”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Winicob, c pi'ʌlob, i p'olbalet bʌ la Abraham, jatetla, mu' bʌ la' bʌc'ñan Dios, tsa' chocbentiyetla tilel jini t'an cha'an mi la' coltʌntel. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jini chumulo' bʌ ti Jerusalén yic'ot i yumob ma'anic tsi' cʌñʌyob Jesús. Ma'anic tsi' ch'ʌmbeyob isujm i t'an jini x'altañob mu bʌ i q'uejlel ti jujump'ejl i q'uiñilel c'aj o. Tsi' ts'ʌctesʌbeyob i t'an x'alt'añob che' bʌ tsi' yʌc'ʌyob ti chʌmel Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ma'anic chuqui tsi' wis tajayob ti' contra cha'an mi' tsʌnsañob, pero tsi' c'ajtibeyob Pilato cha'an mi' yʌc' ti chʌmel. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Che' bʌ tsa'ix i ts'ʌctesayob pejtelel chuqui tsi'ijbubil, tsi' ju'sayob ti te', tsi' yʌc'ʌyob ti' yotlel ch'ujlelʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Dios tsi' teche ch'ojyel ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Cabʌl q'uin tsi' q'ueleyob Jesús jini tsa' bʌ i pi'leyob majlel ti bij ti Galilea c'ʌlʌl ti Jerusalén. Testigojob jini tsa' bʌ i q'ueleyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Joñon lojon ja'el mic subeñet lojon jini wen t'an tsa' bʌ wʌn subentiyob lac ñojte'el che' bʌ tsi' yʌc'ʌ i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jini jach bʌ t'an Dios tsi' ts'ʌctesʌbeyonla, i yalobilon bʌ la Israel che' bʌ tsi' cha' teche Jesús. Che'ʌch tsi'ijbubil ja'el ti' cha'p'ejlel salmo: “Jatet calobilet. Sajmʌl tsac techeyet calobil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios tsi' teche ch'ojyel ba'an chʌmeño' bʌ. Ma'anic tsi' yʌc'ʌ ti oc'mʌl. Tsi' yʌlʌ: “Mi caj c pʌsbeñetla i yutslel c pusic'al mach bʌ mejlic ti q'uextiyel che' bajche' tsac pʌsbe David”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jini cha'an mi' yʌl ja'el ti yambʌ salmo: “Ma'anic mi caj a wʌc' ti oc'mʌl Ch'ujul bʌ a Walobil”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Che' bʌ tsa' ujti i coltan i pi'ʌlob che' bajche' yom Dios, melel tsa' chʌmi David. Tsa' mujqui ba' mucul i ñojte'el. Tsa' oc'mi. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero ma'anic tsa' oc'mi jini tsa' bʌ i teche ch'ojyel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ña'tanla, che' jini, winicob c pi'ʌlob, cha'añʌch ti' ye'tel Jesús mi' ñusʌntel lac mul che' bajche' wolic subeñetla. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Cha'an ti' ye'tel Jesucristo, pejtelel mu' bʌ i ñopob mi' ch'ʌjmelob ti' wenta Dios che' ñusʌbilix i mul. Ma'anic tsa' mejli la' ch'ʌjmel ti' wenta cha'an ti' jac'ol i mandar Moisés. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Chʌcʌ q'uele la' bʌ, che' jini, ame mi' tajetla jini ts'ijbubil bʌ ti' jun x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Mi' yʌl: “Q'uelela sts'a'leyajet bʌ la. La' toj sajtic la' pusic'al. La' jiliquetla. Come joñon wolic mel junchajp e'tel ti a wut, mach bʌ anic mi caj la' ñop anquese an majqui mi' subeñetla”. Che' ts'ijbubil, che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Che' woli' loq'uelob ti sinagoga Pablo yic'ot Bernabé, jini gentilob tsi' c'ajtibeyob cha'an mi' cha' subeñob jini t'an ti yambʌ semana. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Che' bʌ tsa' loq'uiyob jini tempʌbilo' bʌ, cabʌl judíojob yic'ot jini tsa' bʌ i ñopbeyob i t'an, mu' bʌ i ch'ujutesañob Dios, tsi' tsajcayob majlel. Pablo yic'ot Bernabé tsi' pejcayob. Tsi' xic'beyob cha'an mi' chʌn ajñelob ti' yutslel i pusic'al Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Che' bʌ tsa' cha' c'oti i q'uiñilel c'aj o, colel i lu' tempañob i bʌ pejtelel jini winicob x'ixicob ti jini tejclum cha'an mi' yubibeñob i t'an lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tsʌytsʌyñayob jini judíojob che' bʌ tsi' q'ueleyob motocñayob winicob x'ixicob. Tsi' cha'leyob t'an ti' contra i cʌntesa Pablo. Tsi' p'ajbeyob i bijlel lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ch'ejl i pusic'al Pablo yic'ot Bernabé, tsi' subuyob: Wersa tsa' ñaxan subentiyetla i t'an Dios. Tsa'ix la' to'ol juch'teq'ue jini t'an. Woli la' ñusan la' cuxtʌlel mach bʌ anic mi' jilel. Jini cha'an mic majlel lojon ba'an gentilob. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Come che'ʌch tsi' yʌq'ueyon lojon mandar lac Yum. Tsi' yʌlʌ: “Tsa'ix c wa'chocoyet cha'an ma' pʌsbeñob i sʌclel pañimil jini gentilob, cha'an mi' tajob i coltʌntel c'ʌlʌl ti' petol pañimil”. Che' tsi' subeyon lojon lac Yum, che'ob Pablo yic'ot Bernabé. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tijicñayob gentilob che' bʌ tsi' yubiyob jini t'an. Tsi' subuyob wen ñuc i t'an lac Yum. Jini tsa' bʌ yajcʌntiyob cha'an mi' tajob i cuxtʌlel mach bʌ anic mi' jilel, tsi' laj ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Tsa' pujqui i t'an lac Yum ti pejtelel jini lum. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Judíojob tsi' xic'beyob jini x'ixicob mu' bʌ i ch'ujutesañob Dios, mu' bʌ i q'uejlelob ti ñuc, yic'ot jini ñuco' bʌ ti tejclum cha'an mi' tic'lañob Pablo yic'ot Bernabé. Tsi' chocoyob loq'uel ti' lumal. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Che' bʌ tsi' tijcayob loq'uel i ts'ubeñal i yoc ti' contra, tsa' majliyob ti Iconio. ");
INSERT INTO ctuBl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jini xcʌnt'añob wen tijicñayob i pusic'al. But'ulob ti Ch'ujul bʌ Espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Temel tsa' ochiyob ti' sinagoga judíojob ya' ti Iconio. Tsi' wen cha'leyob subt'an. Jini cha'an wen cabʌl tsi' ñopoyob judíojob yic'ot griegojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Jini judíojob mach bʌ anic tsi' ñopoyob tsi' xic'beyob gentilob ti' contra jini hermanojob. Tsi' socbeyob i pusic'al jini gentilob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Jini cha'an tsa' jal'ayob ya'i. Ch'ejlob i pusic'al tsi' cha'leyob t'an come xuc'ulob ti lac Yum. Lac Yum tsi' yʌq'ueyob i pʌs i yejtal i p'ʌtʌlel yic'ot bʌbʌq'uen tac bʌ cha'an mi' tsictesan i sujmlel i t'an Dios yic'ot i yutslel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jini tejclumob tsi' t'oxoyob i bʌ. Ojlil tsi' jac'beyob i t'an judíojob. Ojlil tsi' jac'beyob i t'an jini apóstolob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Tsi' chajpayob i bʌ gentilob yic'ot judíojob yic'ot yumʌlob i cha'an, cha'an mi' tic'lañob yic'ot cha'an mi' julob ti xajlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Che' ña'tʌbilix i cha'an Pablo yic'ot Bernabé tsa' puts'iyob majlel ti Listra yic'ot ti Derbe, cha'p'ejl tejclum ya' ti Licaonia, yic'ot pejtelel jini lum ti' joytilel. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ya'i tsi' subuyob majlel jini wen t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ya' buchul ti Listra an winic mach bʌ wenic i yoc c'ʌlʌl che' bʌ tsi' yila pañimil. Ma'anic ba' ora tsa' mejli ti xʌmbal. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Jini winic tsi' yubibe i t'an Pablo. Pablo tsi' ch'ujch'uj q'uele. Tsi' ña'ta ñopol i cha'an jini winic mi caj i c'oc'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Wen c'am i t'an tsi' sube: Ch'ojyen. Wa'i', che'en. Jini winic tsa' tijp'i. Tsi' cha'le xʌmbal. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Che' bʌ tsi' q'ueleyob winicob x'ixicob chuqui tsi' cha'le Pablo, c'am tsi' cha'leyob t'an. Tsi' yʌlʌyob ti' t'an licaoniajob: Tsa'ix jubiyob tilel diosob ti lac tojlel che' bajche' winicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Tsi' pejcayob Bernabé ti Júpiter. Tsi' pejcayob Pablo ti Mercurio, come jiñʌch Pablo tsa' bʌ i subu t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jini motomaj ya' ti' yotlel jini dios i c'aba' Júpiter am bʌ ti' yochib tejclum, tsi' ch'ʌmbeyob tilel ti' ti' tejclum tat wacax yic'ot i ch'ʌjlil i jol. Jini motomaj yic'ot winicob x'ixicob yomob i tsʌnsʌbeñob i majtan Pablo yic'ot Bernabé. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jini apóstolob, Bernabé yic'ot Pablo, tsi' tsiliyob i pislel che' bʌ tsi' yubiyob. Ti ajñel tsa' ñumiyob ba' motocñayob. Wen c'am tsi' cha'leyob t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Tsi' yʌlʌyob: Winicob, ¿chucoch mi la' cha'len che' bajche' jini? Joñon lojon winicon lojon ja'el che' bajche'etla. Mic subeñetla yom mi la' cʌy jini lolom jach bʌ cha'an mi la' ñop jini cuxul bʌ Dios tsa' bʌ i mele panchan yic'ot pañimil yic'ot colem ñajb yic'ot pejtelel i bʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ti yambʌ ora Dios tsi' yʌq'ueyob gentilob i melob bajche' jach yomob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ma'anic tsi' cʌyʌ i tsictesan i bʌ ti wen bʌ i ye'tel. Tsi' yʌq'ueyonla ja'al tilem bʌ ti panchan yic'ot c'ajbal cha'an mi lac ñaj'an. Tsi' tijicñesʌbeyonla lac pusic'al. Che' tsi' yʌlʌ Pablo yic'ot Bernabé. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero colel ma'anic tsa' mejli i tic'ob jini winicob x'ixicob cha'an ma'anic mi' tsʌnsʌbeñob i majtan. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Tsa' tiliyob judíojob ch'oyolo' bʌ ti Antioquía yic'ot ti Iconio. Tsi' xic'beyob winicob x'ixicob ti' contra. Tsi' juluyob Pablo ti xajlel. Tsi' tujc'ayob loq'uel ti tejclum come tsi' lon ña'tayob chʌmenix. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Che' bʌ tsa' tiliyob xcʌnt'añob ti' joytilel, tsa' ch'ojyi Pablo, tsa' ochi ti tejclum. Ti yijc'ʌlal tsa' majli yic'ot Bernabé ti Derbe. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Che' bʌ tsa'ix i subuyob jini wen t'an ya' ti Derbe ba' tsi' cʌntesayob cabʌl winicob x'ixicob, tsa' cha' majliyob ti Listra yic'ot ti Iconio yic'ot ti Antioquía. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Tsi' xuc'chocobeyob i pusic'al xcʌnt'añob. Tsi' xic'beyob cha'an mi' chʌn ñopob i t'an Dios. Tsi' subeyob: Che' bʌ tsa'ix lac ñusa cabʌl wocol, mi caj la cochel ti' yumʌntel Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Tsi' wa'chocoyob ancianojob ti jujump'ejl tejclum ba'an xñopt'añob. Tsi' cha'leyob oración yic'ot ch'ajb. Tsi' yʌc'ʌyob ti' c'ʌb lac Yum jini tsa' bʌ i ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Tsa' ñumiyob majlel ti Pisidia, tsa' c'otiyob ti Panfilia. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Che' bʌ tsa'ix i subuyob jini t'an ya' ti Perge, tsa' jubiyob tilel ti Atalia. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ya'i tsa' ochiyob ti barco cha'an mi' cha' sujtelob ti Antioquía ba' tsa' tejchi i ye'tel che' ti' cajibal. Come ya' ti Antioquía jini hermanojob tsi' wʌn c'ajtibeyob i yutslel i pusic'al Dios cha'an jini e'tel tsa' bʌ ujti i melob Pablo yic'ot Bernabé. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Che' bʌ tsa' c'otiyob, tsi' tempayob i bʌ xñopt'añob. Pablo tsi' subeyob pejtelel chuqui tac wen ñuc tsi' cha'le Dios yic'otob, che' bʌ tsi' jambeyob gentilob i ti' otot cha'an mi' yochelob i ñop. ");
INSERT INTO ctuBl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jal tsa' ajniyob Pablo yic'ot Bernabé yic'ot xcʌnt'añob ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tsa' jubiyob tilel winicob ch'oyolo' bʌ ti Judea. Tsa' caji i cʌntesañob jini hermanojob ya' ti Antioquía. Tsi' subeyob: Mi ma'anic mi la' ch'ʌm tsep pʌchʌlel che' bajche' tsi' yʌlʌ Moisés, mach mejlic mi la' coltʌntel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo yic'ot Bernabé tsa' caji i cʌlʌx pejcañob i bʌ yic'ot judíojob. Tsi' contrajiyob i bʌ ti t'an. Jini cha'an jini hermanojob tsi' wa'chocoyob Pablo yic'ot Bernabé yic'ot cha'tiquil uxtiquil yaño' bʌ cha'an mi' majlelob ti Jerusalén cha'an mi' c'ajtibeñob i sujmlel tsep pʌchʌlel jini apóstolob yic'ot jini ancianojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jini xñopt'añob tsa' majli i cʌyob ti bij. Pablo yic'ot Bernabé tsa' ñumiyob majlel ti Fenicia yic'ot ti Samaria. Tsi' subuyob bajche' tsi' sutq'uiyob i bʌ gentilob. Tsi' wen ñuq'uesʌbeyob i pusic'al pejtelel hermanojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Che' c'otemobix ti Jerusalén, tsa' pʌjyiyob ochel ti' tojlel jini apóstolob yic'ot ancianojob yic'ot jini xñopt'añob. Tsi' subeyob pejtelel chuqui tac tsi' cha'le Dios yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Lamital jini xñopt'añob woli bʌ i jac'beñob i t'an fariseojob tsa' ch'ojyiyob. Tsi' yʌlʌyob: Wersa yom mi' ch'ʌmob tsep pʌchʌlel. Wersa yom mi' subentelob cha'an mi' jac'beñob i mandar Moisés, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jini apóstolob yic'ot ancianojob tsi' tempayob i bʌ cha'an mi' wen ña'tañob bajche' yom. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Che' bʌ tsa'ix i cha'leyob cabʌl t'an tsa' ch'ojyi Pedro. Tsi' subeyob: Hermanojob, la' wujil anix ora Dios tsi' yajcayon cha'an mic subenob gentilob jini wen t'an cha'an mi' ñopob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios mu' bʌ i cʌmben i pusic'al winic tsi' pʌyʌyob ti' yalobil ti isujm che' bʌ tsi' yʌq'ueyob Ch'ujul bʌ Espíritu che' bajche' tsi' yʌq'ueyonla. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Lajal tsi' q'ueleyob che' bajche' tsi' q'ueleyonla. Tsi' sʌq'uesʌbeyob i pusic'al che' bʌ tsi' ñopoyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Chucoch che' jini, woli la' wilʌben i pusic'al Dios? ¿Chucoch mi la' wʌq'ueñob jini xcʌnt'añob i cuch jini wocol tac bʌ? Ma'anic tsa' mejli lac lʌt' joñonla mi lac ñojte'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pero mi lac ñop mi caj laj coltʌntel cha'an i yutslel i pusic'al lac Yum Jesús. Che' ja'el mi caj i coltʌntelob jini gentilob. Che' tsi' yʌlʌ Pedro. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ñʌch'ʌl tsa' cʌleyob ti pejtelelob. Tsi' yubibeyob i t'an Bernabé yic'ot Pablo che' bʌ tsi' subeyob chuqui tac ñuc tsi' mele Dios ti' c'ʌb come tsi' pʌsʌ i yejtal tac i p'ʌtʌlel yic'ot bʌbʌq'uen tac bʌ ti' tojlel gentilob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Che' bʌ tsa' ujtiyob ti t'an, Jacobo tsi' yʌlʌ: Winicob hermanojob, ñich'tʌbeñon c t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón tsa' ujti i subeñetla bajche' Dios tsa' caji i pʌsbeñob gentilob i yutslel i pusic'al che' bʌ tsi' yajca winicob x'ixicob cha'an mi' tsictesan i ñuclel i c'aba'. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Che' ja'el mi' yʌlob x'alt'añob, che' bajche' ts'ijbubil: ");
INSERT INTO ctuBl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Ti wi'il mi caj c cha' tilel, che'en Dios. Mi caj c wa'chocon i yotot David tsa' bʌ yajli. Mi caj c cha' mel jini p'ulul bʌ tsa' bʌ cʌle. Mi caj c cha' wa'chocon ");
INSERT INTO ctuBl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","cha'an mi' sʌclañob lac Yum i colojbal winicob yic'ot pejtelel gentilob mu' bʌ i yubiñob j c'aba'”. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Che' woli' yʌl lac Yum tsa' bʌ i laj ac'ʌ ti cʌjñel c'ʌlʌl ti wajali. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jini cha'an mi cʌl mach wenic mi' tic'lʌntelob gentilob mu' bʌ i sutq'uiñob i bʌ cha'an mi' ñopob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Cojach yom mi la' ts'ijbubeñob ti jun cha'an mi' cʌyob i c'ux chuqui tac aq'uebil dioste', yic'ot chuqui tac milbil yic'ot i ch'ich'el, cha'an mi' cʌyob i ts'i'lel ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Come c'ʌlʌl ti wajali an ti jujump'ejl tejclum jini mu' bʌ i subob i t'an Moisés ti sinagoga ba' mi' q'uejlel i jun Moisés ti jujump'ejl i q'uiñilel c'aj o. Che' tsi' yʌlʌ Jacobo. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jini cha'an jini apóstolob yic'ot ancianojob yic'ot pejtelel jini xñopt'añob mu' bʌ i tempañob i bʌ, tsi' ña'tayob uts'at mi' yajcañob winicob ti' tojlel hermanojob cha'an mi' chocob majlel ti Antioquía yic'ot Pablo yic'ot Bernabé. Tsi' yajcayob Silas yic'ot Judas, jini am bʌ i cha'chajplel i c'aba' Barsabás, ñuc bʌ winicob ti' tojlel hermanojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Tsi' meleyob carta. Tsi' yʌlʌyob: “Joñon lojon apóstolon lojon quic'ot ancianojob quic'ot hermanojob, wolic melbeñetla jini jun hermanojob, gentilet bʌ la ya' ti Antioquía yic'ot ti Siria yic'ot ti Cilicia. Cotañetla. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tsa'ix cubi lojon an winicob tsa' bʌ loq'uiyob tic tojlel lojon tsa' bʌ i tic'layetla ti' t'an. Tsi' socbeyetla la' pusic'al, come tsi' yʌlʌyob wersa mi la' ch'ʌm tsep pʌchʌlel, wersa mi la' jac' jini mandar. Mach che'iqui tsac subeyob lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jini cha'an che' tempʌbilon lojon tsac ña'ta lojon uts'at mic yajcan lojon winicob cha'an mic chocob majlel ba' añetla yic'ot Bernabé yic'ot Pablo mu' bʌ j c'uxbin lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ili winicob tsi' yʌc'ʌyob i bʌ ba' bʌbʌq'uen mi' chʌmelob cha'an ti' c'aba' lac Yum Jesucristo. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jini cha'an wolic choc lojon majlel Judas yic'ot Silas ja'el mu' bʌ caj i subeñetla jini jach bʌ t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Come joñon lojon quic'ot jini Ch'ujul bʌ Espíritu tsac ña'ta lojon mach yomic mi cʌq'ueñetla la' cuch chuqui tac wocol ti' jac'ol. Cojach jini yom: ");
INSERT INTO ctuBl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Cʌyʌ la' c'ux jini tsʌnsʌbil bʌ i majtan dioste' yic'ot i ch'ich'el yic'ot jini milbil bʌ. Mach mi la' cha'len ts'i'lel. Mi uts'at mi la' cʌntan la' bʌ cha'an pejtelel jini, uts'at mi la' mel. Ajñenla ti la' wenlel”. Che'ʌch tsi' ts'ijbayob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Che' jini tsi' chocoyob majlel ti Antioquía. Che' bʌ tsi' tempayob i bʌ jini xñopt'añob, jini apóstolob tsi' yʌq'ueyob jini jun. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Che' bʌ tsa' ujti i q'uelob, tijicña tsi' yubiyob come tsa' ñuq'uesʌbentiyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas yic'ot Silas, x'alt'añob ja'el, tsi' ñuq'uesʌbeyob i pusic'al jini hermanojob ti cʌntesa. Tsi' xuc'chocobeyob i pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tsa' jaleyob ya'i. Ti' wi'il jini hermanojob ñʌch'ʌlob i pusic'al tsi' chocoyob sujtel ba'an i pi'ʌlob tsa' bʌ i yʌq'ueyob i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas tsi' ña'ta uts'at mi' cʌytʌl ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo yic'ot Bernabé tsa' cʌleyob ti Antioquía. Tsi' chʌn cʌntesayob ti' t'an lac Yum. Tsi' subeyob jini wen t'an. Cabʌl winicob tsi' pi'leyob majlel ti subt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Che' ñumenix cha'p'ejl uxp'ejl q'uin, Pablo tsi' sube Bernabé: Conla c jula'tan la quermanojob ti pejtelel tejclum ba' tsa' lac subeyob i t'an lac Yum cha'an mi laj q'uel bajche' yilalob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé yom i pʌy majlel Juan, jini am bʌ i cha'chajplel i c'aba' Marcos. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pablo mach yomic i pʌy majlel yic'otob, come Marcos tsi' cʌyʌyob ya' ti Panfilia che' ma'anic tsa' majli ti e'tel yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Cha'chajp i pensar. Jini cha'an tsi' t'oxoyob i bʌ. Bernabé tsi' pʌyʌ majlel Marcos ti barco. Tsa' majli ti Chipre. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo tsi' yajca Silas, tsi' pʌyʌ majlel. Jini hermanojob tsi' yʌc'ʌyob ti' c'ʌb lac Yum cha'an mi' yajñelob ti' yutslel i pusic'al lac Yum. ");
INSERT INTO ctuBl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pablo tsa' ñumi majlel ya' ti Siria yic'ot ti Cilicia. Tsi' xuc'choco xñopt'añob baqui jach tsi' tempayob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ti wi'il tsa' c'oti ti Derbe yic'ot ti Listra. Awilan, ya'an xcʌnt'an i c'aba' Timoteo. Judía i ña', hermanajʌch ti Cristo. Griegojʌch i tat. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Jini hermanojob ti Listra yic'ot ti Iconio uts'at tsi' tajayob ti t'an Timoteo. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo yom i pʌy majlel Timoteo. Tsi' pʌyʌ i tsepben i pʌchʌlel come ti pejtelel judíojob ya' bʌ añob yujilob griego i tat. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Che' bʌ tsa' ñumiyob ti tejclum tac, tsi' subeyob cha'an mi' jac'ob jini mandar tsa' bʌ i comol ña'tayob jini apóstolob yic'ot ancianojob año' bʌ ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Jini cha'an tsa' p'ʌtesʌntiyob ti' t'an Dios jini xñopt'añob tsa' bʌ i tempayob i bʌ. Tsa' p'ojliyob ti jujump'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tsa' ñumiyob majlel ti Frigia yic'ot ti jini lum Galacia. Tic'bilob cha'an Ch'ujul bʌ Espíritu ma'anic tsi' subuyob t'an ya' ti Asia. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Che' bʌ tsa' c'otiyob ti Misia tsi' ñopoyob majlel ti Bitinia. Pero jini i yEspíritu Jesús tsi' tiq'uiyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Che' bʌ tsa' ñumiyob ti Misia tsa' jubiyob majlel ti Troas. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ti ac'ʌlel an chuqui tsi' q'uele Pablo. Juntiquil winic ya' ti Macedonia tsa' wa'le ti' tojel. Tsi' c'ajtibe ti wocol t'an: La' ti Macedonia. Coltañon lojon, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Che' q'uelbilix i cha'an Pablo, ti ora tsac chajpa lojon c bʌ cha'an mic majlel lojon ti Macedonia, come tsac ña'ta lojon isujm tsi' pʌyʌyon lojon Dios cha'an mic subeñob lojon jini wen t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Jini cha'an tsa' ochiyon lojon ti barco ti Troas. Toj tsa' majliyon lojon c'ʌlʌl ti Samotracia, ti yijc'ʌlal c'ʌlʌl ti Neápolis. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ti wi'il tsa' majliyon lojon ti Filipos, jini ñuc bʌ tejclum ti' lumal Macedonia, jump'ejl colonia cha'an Roma. Ya' añon lojon waxʌcp'ejl q'uin ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ti' q'uiñilel c'aj o tsa' loq'uiyon lojon ti' ti' tejclum. Tsajniyon lojon ti' ti' colem ja' ba' i tilel mi' pejcañob Dios. Tsa' buchleyon lojon. Tsac pejca lojon x'ixicob tsa' bʌ i tempayob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ya'an x'ixic i c'aba' Lidia, mu' bʌ i chon chʌccojan bʌ pisil. Ch'oyol ti tejclum i c'aba' Tiatira. Lidia tsi' bʌc'ña Dios. Che' bʌ tsi' ñich'ta Pablo, lac Yum tsi' jambe i pusic'al cha'an mi' jac'ben i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Che' bʌ tsa' ujti i ch'ʌm ja' yic'ot jini año' bʌ ti yotot, tsi' subeyon lojon: Conla ti cotot mi tsa' la' q'uele xuc'ulon quic'ot lac Yum. Jijlenla ya' ti cotot, che'en. Tsi' wersa pʌyʌyon lojon ochel. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ti yambʌ q'uin che' tsajniyon lojon ba' mi' cha'leñob oración, juntiquil xch'oc am bʌ i xibʌjlel tsa' bʌ mejli i subeñob winicob chuqui tac tal, tsi' tajayon lojon ti bij. I yumob tsi' wen cha'leyob ganar cha'an i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jini xch'oc tsi' tsajcayon lojon quic'ot Pablo. Tsi' cha'le c'am bʌ t'an. Tsi' yʌlʌ: Jiñobʌch i winicob Dios am bʌ ti chan. Mi' subeñetob i bijlel la' coltʌntel, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Che'ʌch tsi' cha'le t'an cabʌl q'uin. Pablo mach chʌn yomix i cuchben. Tsi' sutq'ui i bʌ i pejcan. Tsi' sube i xibʌjlel: Mic subeñet ti' c'aba' Jesucristo, loq'uen ti' pusic'al, che'en. Ti jini jach bʌ ora tsa' loq'ui. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Che' bʌ tsi' ña'tayob i yumob jini xch'oc mach chʌn mejlobix i c'ʌñob ti ganar, tsi' chucuyob Pablo yic'ot Silas. Tsi' chucuyob majlel ba'an choñoñibʌl ti' tojlel año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Tsa' caji' jop'beñob i mul ti' tojlel año' bʌ i ye'tel. Tsi' yʌlʌyob: Jini judíojob cabʌl mi' ñijcañob ti t'an jini chumulo' bʌ ti lac tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Mi' subeñob yom mi lac mel chuqui tac tic'bebilonla come romanojonla. Tic'bil mi lac ñop come mach che'ic yom mi lac mel, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jini winicob x'ixicob tsa' caji i yotsañob i bʌ ti' contra. Jini año' bʌ i ye'tel tsi' tsilbeyob i pislel Pablo yic'ot Silas. Tsi' yʌc'ʌyob mandar cha'an mi' jajts'elob ti asiyal. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Che' cabʌl tsi' jats'ʌyob, tsi' yotsayob ti mʌjquibʌl. Tsi' subeyob xcʌntaya cha'an mi' wen cʌntañob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Che' bʌ tsa' aq'uenti jini mandar jini xcʌntaya tsi' yotsayob ya' ti cojix bʌ i mal mʌjquibʌl. Tsi' ñet'beyob i yoc ti tocol bʌ te'. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ti ojlil ac'ʌlel woli' pejcañob Dios Pablo yic'ot Silas. Woli' c'ʌyiñob Dios. Jini xñujp'elob woli' yubiñob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ti ora tsa' ñumi i yujquel lum. I c'ʌclib jini mʌjquibʌl tsi' ñijca i bʌ. Ti ora tsa' lu' jajmi i ti' tac mʌjquibʌl. Tsa' jijti i cʌjchil pejtel jini xñujp'elob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Che' bʌ tsa' cajni i wut jini xcʌntaya, tsi' q'uele jajmenix i ti' tac mʌjquibʌl. Tsi' bots'o i yespada cha'an mi' tsʌnsan i bʌ, come tsi' lon ña'ta puts'emobix jini xñujp'elob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","C'am tsi' cha'le t'an Pablo. Tsi' sube: Mach a tic'lan a bʌ. Umba'añon lojon tic pejtelel lojon che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Jini xcʌntaya tsi' c'ajti c'ajc. Tsa' ochi ti mal. Tsiltsilña ti bʌq'uen tsi' ñocchoco i bʌ ti' tojel Pablo yic'ot Silas. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Tsi' pʌyʌyob loq'uel. Tsi' c'ajtibeyob: Winicob, ¿chuqui yom mic cha'len cha'an mij coltʌntel? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Pablo yic'ot Silas tsi' subeyob: Ñopo lac Yum Jesucristo. Che' jini mi caj a coltʌntel, jatet yic'ot jini año' bʌ ti a wotot, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Tsi' subeyob i t'an lac Yum yic'ot pejtelel año' bʌ ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Jini xcʌntaya tsi' pʌyʌyob ti jini jach bʌ ora ti ac'ʌlel. Tsi' pocbeyob i lojwel tac. Tsi' bʌc' ch'ʌmʌ ja' yic'ot pejtelel jini año' bʌ ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tsi' pʌyʌyob ochel ti' yotot. Tsi' we'sayob. Wen tijicña i pusic'al yic'ot pejtelel año' bʌ ti' yotot come tsi' ñopoyob Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Che' bʌ tsa' sʌc'a, jini año' bʌ i ye'tel tsi' chocoyob majlel wasilob tsa' bʌ i subeyob xcʌntaya: Ac'ʌ ti colel jini winicob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Jini xcʌntaya tsi' sube Pablo: Jini año' bʌ i ye'tel tsi' chocoyob tilel mandar cha'an mi cʌq'uetla ti colel. Loq'uenixla, che' jini. Cucuxla ti' ñʌch'tilel la' pusic'al, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pablo tsi' subeyob: Romanojon lojon. Ti' wutob winicob x'ixicob tsi' jats'ʌyon lojon che' maxto melbilonic lojon. Tsi' chocoyon lojon ochel ti mʌjquibʌl. ¿Mu' ba caj i chocon lojon loq'uel ti mucul jach? Isujm mach che'ic yom. La' tilicob i pʌyon lojon loq'uel, che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Jini wasilob tsa' cha' majliyob ba'an año' bʌ i ye'tel cha'an mi' cha' subeñob. Jini año' bʌ i ye'tel tsi' cha'leyob bʌq'uen che' bʌ tsi' yubiyob romanojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Tsa' tiliyob ba'an Pablo yic'ot Silas. Tsi' pejcayob ti wocol t'an. Tsi' pʌyʌyob loq'uel ti mʌjquibʌl. Tsi' subeyob cha'an mi' loq'uelob ti jini tejclum. ");
INSERT INTO ctuBl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Che' loq'uemobix ti mʌjquibʌl tsi' jula'tayob Lidia. Che' bʌ tsi' q'ueleyob jini hermanojob, tsi' ñuq'uesʌbeyob i pusic'al. Tsa' loq'uiyob majlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Che' bʌ tsa' ñumiyob ti Anfípolis yic'ot ti Apolonia, tsa' c'otiyob ti Tesalónica ya' ba'an i sinagoga judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tsa' ochi Pablo yic'otob che' bajche' i tilelʌch che' ti' q'uiñilel c'aj o. Uxp'ejl q'uin tsi' tsictesʌbeyob i Ts'ijbujel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Tsiquil wersa mi' yubin wocol jini Cristo. Wersa mi' tejchel loq'uel ba'an chʌmeño' bʌ. Tsi' yʌlʌ: Jiñʌch Cristo, jini Jesús mu' bʌ c subeñetla, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Lamital tsi' ñopoyob. Tsi' tempayob i bʌ yic'ot Pablo yic'ot Silas, che' ja'el griegojob tsa' bʌ i ch'ujutesayob Dios, yic'ot cabʌl x'ixicob tsa' bʌ q'uejliyob ti ñuc. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Tsʌytsʌyñayob i pusic'al jini judíojob mach bʌ anic tsi' ñopoyob. Tsi' pʌyʌyob cha'tiquil uxtiquil jontolo' bʌ winicob. Tsi' tempayob cabʌl winicob. Tsi' ñijcayob ti cabʌl t'an pejtelel año' bʌ ti tejclum. Ti ajñel tsa' majliyob ti' yotot Jasón cha'an mi' loc'sañob Pablo yic'ot Silas ti' wut winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Che' ma'anic tsi' tajayob tsi' chucuyob majlel Jasón yic'ot yaño' bʌ hermanojob ba'an jini año' bʌ i ye'tel ti tejclum. C'am tsi' yʌlʌyob: Jini winicob tsa' bʌ i socoyob winicob x'ixicob ti pejtelel pañimil, wʌ' tsa' tiliyob ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jini Jasón tsi' pʌyʌyob ochel ti' yotot. Ti pejtelelob woli' contrajiñob i t'an César come mi' yʌlob an yambʌ rey, i c'aba' Jesús, che'ob. Che' tsi' jop'beyob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Che' bʌ tsi' yubiyob winicob x'ixicob yic'ot año' bʌ i ye'tel tsa' cajiyob ti cabʌl t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Che' bʌ tsi' ch'ʌmʌyob multa ti' c'ʌb Jasón yic'ot i pi'ʌlob, tsi' coloyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Jini hermanojob tsi' bʌc' chocoyob majlel Pablo yic'ot Silas ti ac'ʌlel c'ʌlʌl ti Berea. Che' bʌ tsa' c'otiyob ya'i, tsa' ochiyob ti' sinagoga judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jini año' bʌ ti Berea ñumen weñob bajche' jini año' bʌ ti Tesalónica come ti jump'ejl jach i pusic'al tsi' jac'ʌyob jini t'an. Ti jujump'ejl q'uin tsi' wen q'ueleyob i Ts'ijbujel Dios cha'an mi' ña'tañob mi isujm chuqui tsa' subentiyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jini cha'an cabʌl judíojob tsi' ñopoyob yic'ot cabʌl griegojob, yic'ot x'ixicob tsa' bʌ q'uejliyob ti ñuc. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Che' bʌ tsi' ña'tayob judíojob ya' ti Tesalónica wolix i pujquel i t'an Dios ya' ti Berea ja'el cha'an Pablo, ya' tsa' majliyob ja'el. Tsi' ñijcayob winicob x'ixicob ti' contra. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Jini hermanojob tsi' bʌc' chocoyob majlel Pablo c'ʌlʌl ti colem ñajb. Silas yic'ot Timoteo tsa' cʌleyob ya' ti Berea. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Jini hermanojob tsi' pi'leyob majlel Pablo c'ʌlʌl ti Atenas. Tsa' cha' juliyob i subeñob majlel Silas yic'ot Timoteo ti ora ba'an Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Che' bʌ tsi' pijtayob ya' ti Atenas wen ch'ijiyem i pusic'al Pablo, come tsi' q'uele but'ul jini tejclum ti dioste'. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Jini cha'an ya' ti sinagoga tsi' pejcayob i bʌ Pablo yic'ot judíojob yic'ot gentilob tsa' bʌ i ch'ujutesayob Dios. Ti jujump'ejl q'uin tsi' pejcayob jini tsa' bʌ ajniyob ti choñoñibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ya'an epicúreojob yic'ot estoicojob mu' bʌ i sʌclañob i sujmlel tac pañimil. Tsi' pejcayob i bʌ yic'ot Pablo. Lamital tsi' yʌlʌyob: To'ol t'an jach mi' cha'len, che'ob. Lamital tsi' yʌlʌyob: Woli' sub yambʌ dios yilal, che'ob. Come Pablo tsi' subu Jesús tsa' bʌ cha' ch'ojyi ba'an chʌmeño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Tsi' chucuyob. Tsi' pʌyʌyob tilel ti Areópago. Tsi' yʌlʌyob: Com cubin lojon jini tsijib cʌntesa mu' bʌ a sub. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Come jini woli bʌ a sub maxto ubibilic c cha'an lojon. Com c ña'tan lojon i sujmlel jini t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Come ti pejtelel jini chumulo' bʌ ti Atenas yic'ot jini tilemo' bʌ ti yambʌ lum tsa' jach i ñusayob q'uin ti t'an. Chuqui tac tsijib ubibil i cha'añob mi' cha' subob.) ");
INSERT INTO ctuBl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Che' ya' wa'al Pablo ti ojlil Areópago, tsi' yʌlʌ: Winicob wʌ' ti Atenas mij q'uel cabʌl la' dios mu' bʌ la' ch'ujutesan. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Come che' bʌ tsa' ñumiyon ba' tsaj q'uele i yotlel tac diosob, tsac taja jump'ejl pulʌntib ba' ts'ijbubil jini t'an: JINI DIOS MACH BɅ CɅMBILIC. Jini cha'an mi caj c tsictesʌbeñetla jini Dios mach bʌ cʌmbilic la' cha'an mu' bʌ la' ch'ujutesan. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Jini Dios tsa' bʌ i mele pañimil yic'ot pejtelel i bʌl, jiñʌch i Yum Panchan yic'ot Pañimil. Ma'anic mi' chumtʌl ti templo tac melbil bʌ ti c'ʌbʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Dios ma'anic mi' taj i coltʌntel ti winicob, come ma'anic chuqui anto yom i cha'an. Mi' yʌq'ueñonla laj cuxtʌlel yic'ot la quiq'uilel yic'ot pejtelel lac chubʌ'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Loq'uem jach ti juntiquil winic Dios tsi' laj mele winicob ti jujunchajp cha'an mi' pam chumtʌlob ti pejtelel pañimil. Tsi' yʌq'ueyob i yorajlel. Tsi' melbeyob i cayajonlel i lumal. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tsi' meleyonla cha'an mi lac sajcan cha'an mi lac taj ti isujm che' mi lac ñop, come mach ñajtic an Dios ti lac tojlel ti jujuntiquilonla. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Come tilem ti Dios laj cuxtʌlel yic'ot lac p'ʌtʌlel ti xʌmbal. Ti' p'ʌtʌlel Dios añonla. Che' bajche' tsi' yʌlʌyob ja'el jini sts'ijbayajob la' cha'an: “Come joñonla ja'el i p'olbalonla”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","I p'olbalonla. Jini cha'an mach yomic mi la cʌl lajalʌch Dios bajche' oro mi plata, mi xajlel mu' bʌ i melob winicob ti' bajñel pusic'al i wenta i yejtal Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Dios tsi' ñusʌbeyob i sajtemal winicob ti yambʌ ora che' ma'añobic i ña'tʌbal. Wʌle mi' subeñob pejtelel winicob x'ixicob baqui jach añob cha'an mi' cʌyob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tsa'ix i wʌn ña'ta jini q'uin che' mi caj i cha'len meloñel ti toj. Tsa'ix i wa'choco jini winic mu' bʌ caj i mel año' bʌ ti pañimil che' bajche' tsi' tsictesʌbeyonla che' bʌ tsi' teche ch'ojyel Jesús ba'an chʌmeño' bʌ cha'an mi lac ñop. Che' tsi' yʌlʌ Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Che' bʌ tsi' yubiyob mi' cha' ch'ojyelob chʌmeño' bʌ, lamital tsi' wajleyob. Yaño' bʌ tsi' yʌlʌyob: Ti yanto bʌ ora mi caj cubin lojon a t'an, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jini cha'an tsa' loq'ui majlel Pablo ti' tojlelob. ");
INSERT INTO ctuBl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Cha'tiquil uxtiquil tsi' tsajcayob Pablo. Tsi' ñopoyob Dionisio ch'oyol bʌ ti Areópago, yic'ot x'ixic i c'aba' Dámaris yic'ot yaño' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ti yambʌ ora Pablo tsa' loq'ui majlel ti Atenas. Tsa' c'oti ti Corinto. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Tsi' taja judío i c'aba' Aquila, ch'oyol bʌ ti Ponto. Maxto anic cabʌl ora i loq'uel ti Italia yic'ot Priscila i yijñam, come Claudio tsi' yʌc'ʌ mandar cha'an mi' loq'uelob pejtelel judíojob ti Roma. Tsa' majli Pablo i cʌñob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Cha'an lajalob i ye'tel, tsa' chumle yic'otob. Temel tsi' cha'leyob e'tel come xmel pisil bʌ ototob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pablo tsi' cha'le t'an ti sinagoga ti jujump'ejl i q'uiñilel c'aj o. Tsi' cha'le wersa cha'an mi' ñopob judíojob yic'ot griegojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Che' bʌ tsa' c'otiyob Silas yic'ot Timoteo, loq'uemo' bʌ ti Macedonia, Pablo woli' cha'len wersa subt'an ti Corinto. Tsi' chʌn sube judíojob Cristojʌch jini Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Jini judíojob tsi' contrajiyob Pablo. Tsi' p'ajayob. Jini cha'an tsi' tijca i pislel, tsi' subeyob: Anix ti la' bajñel wenta la' cuxtʌlel. Mach c wentajetixla. Mux c majlel ba'an gentilob, che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Tsa' loq'ui ya'i. Tsa' ochi ti' yotot juntiquil winic, i c'aba' Tito Justo, tsa' bʌ i bʌc'ña Dios. An i yotot ti' t'ejl sinagoga. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispo, i yum sinagoga, tsi' ñopo lac Yum yic'ot pejtelel año' bʌ ti' yotot. Cabʌl corintiojob che' bʌ tsi' yubibeyob i t'an Pablo tsi' ñopoyob. Tsi' ch'ʌmʌyob ja'. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Lac Yum tsi' sube Pablo ti ac'ʌlel: Mach a cha'len bʌq'uen. Chʌn cha'len t'an. Mach yomic ma' ñʌjch'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Come añon quic'otet. Ma'anic majch mi mejlel i tic'lañet, come an cabʌl c cha'año' bʌ ti jini tejclum, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ya'i tsa' jale ojlil i cha'p'ejl jab. Tsi' cʌntesayob ti' t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Che' woli ti yumʌl Galión ya' ti Acaya, jini judíojob tsi' tem chucuyob Pablo. Tsi' pʌyʌyob majlel ba'an melobʌjʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Tsi' yʌlʌyob: Jini winic mi' bajñel suben tejclumob bajche' yom mi' ch'ujutesañob Dios. Mach che'ic bajche' ts'ijbubil ti mandar mi' subeñob, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Che' yomix cajel ti t'an Pablo, jini Galión tsi' sube judíojob: Mi an i mul, mi an chuqui jontol tsi' cha'le, wersa mic ñich'tʌbeñetla la' t'an, judíojet bʌ la. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero woliyetla ti' a'leya cha'an to'o t'an jach yic'ot cha'an i c'aba' tac winicob yic'ot cha'an la' mandar. Jini cha'an la' wentajʌch jatetla. Joñon mach comic c cha'len meloñel cha'an i t'an. Che' tsi' yʌlʌ jini yumʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Tsi' chocoyob loq'uel ti melobʌjʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Jini griegojob tsi' chucuyob Sóstenes, i yum sinagoga. Tsi' jats'ʌyob ti' tojel melobʌjʌl. Galión ma'anic chuqui tsi' yʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ya' to tsa' jale Pablo cabʌl q'uin. Ti wi'il tsi' subeyob hermanojob adiós. Ti barco tsa' majli ti Siria. Priscila yic'ot Aquila tsi' pi'leyob majlel. Ya' ti Cencrea, Pablo tsi' laj loc'sa i jol come tsi' sube Dios chuqui mi caj i wersa mel. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Tsa' c'oti ti Efeso ba' tsi' cʌyʌ Priscila yic'ot Aquila. I bajñel tsa' ochi ti sinagoga Pablo. Tsi' pejcayob i bʌ Pablo yic'ot judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Che' bʌ tsi' c'ajtibeyob Pablo cha'an mi' jalijel yic'otob, ma'anic tsi' jac'beyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Che' bʌ tsi' cʌyʌyob i bʌ Pablo tsi' yʌlʌ: Wersa mic majlel ti Jerusalén cha'an mic mel jini q'uin che' mi' cajel. Mu' to c cha' tilel ba' añetla mi che' yom Dios, che'en Pablo. Tsa' loq'ui ti Efeso ti barco. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Che' bʌ tsa' c'oti ti lum ya' ti Cesarea, tsa' letsi majlel i yʌq'ueñob cortesía jini xñopt'añob mu' bʌ i tempañob i bʌ ti Jerusalén. Ti wi'il tsa' jubi majlel ti Antioquía. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Che' bʌ tsa' ts'ita' jale ya'i tsa' cha' majli. Tsa' ñumi ti pejtelel lum ti Galacia yic'ot ti Frigia. Tsi' xuc'choco pejtelel jini xcʌnt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tsa' c'oti ti Efeso juntiquil judío, i c'aba' Apolos, ch'oyol bʌ ti Alejandría. Wen yujil t'an. Wen cʌñʌl i cha'an i Ts'ijbujel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Cʌntesʌbilix Apolos ti' bijlel lac Yum. Ch'ejl i pusic'al. Tsi' cha'le t'an cha'an mi' ñopob lac Yum. Anquese jini jach cʌmbil i cha'an jini ch'ʌmja' tsa' bʌ i yʌc'ʌ Juan, tsi' cha'le cʌntesa. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ch'ejl i pusic'al tsa' caji ti sub t'an ti sinagoga. Che' bʌ tsi' yubiyob Priscila yic'ot Aquila, tsi' pʌyʌyob cha'an mi' tsictesʌbeñob i bijlel Dios ti toj. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Che' yomix majlel Apolos ti Acaya, jini hermanojob tsi' coltayob ti majlel. Tsi' ts'ijbubeyob xcʌnt'añob cha'an mi' pʌyob ochel. Tsa' c'oti Apolos ya'i. Tsi' wen colta jini tsa' bʌ i ñopoyob cha'an ti' yutslel i pusic'al Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tsi' pʌsbeyob judíojob ti' Ts'ijbujel Dios Cristojʌch jini Jesús. Ti cabʌl i p'ʌtʌlel tsi' subu ti' wutob winicob x'ixicob. Ma'anic tsa' mejli i jac'ob jini judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Che' ya'to an Apolos ti Corinto, Pablo tsa' ñumi ba'an wits. Tsa' c'oti ti Efeso. Tsi' taja cha'tiquil uxtiquil xcʌnt'añob ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Tsi' c'ajtibeyob: ¿Tsa' ba aq'uentiyetla Ch'ujul bʌ Espíritu che' bʌ tsa' la' ñopo? che'en. Tsi' subeyob: Maxto anic tsa cubi lojon mi an Ch'ujul bʌ Espíritu, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo tsi' subeyob: ¿Chuqui ti ch'ʌmja' tsa' aq'uentiyetla? che'en. Tsi' subeyob: Jini tsa' bʌ i yʌc'ʌ Juan, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo tsi' subeyob: Juan tsi' yʌq'ueyob ch'ʌmja' jini tsa' bʌ i cʌyʌyob i mul. Tsi' subeyob winicob x'ixicob cha'an mi' ñopob jini tal bʌ ti' pat, jiñʌch Jesús jini Cristo, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Che' bʌ tsi' yubiyob jini t'an, tsi' ch'ʌmʌyob ja' ti' c'aba' lac Yum Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Che' bʌ tsi' yʌc'ʌ i c'ʌb Pablo ti' jol winicob x'ixicob, tsa' ochi jini Ch'ujul bʌ Espíritu ti' pusic'al. Tsa' cajiyob ti yan tac bʌ t'an. Tsi' cha'leyob alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Añob che' bajche' lajchʌntiquil winicob ti pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tsa' ochi Pablo ti sinagoga. Ch'ejl i pusic'al, tsi' cha'le t'an uxp'ejl uw. Tsi' pejcayob i bʌ. Tsi' xic'beyob cha'an mi' ñopob i sujmlel i yumʌntel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tsa' tsʌts'a i pusic'al lamital winicob. Ma'anic tsi' ñopoyob. Tsi' p'ajayob i bijlel Dios ti' tojlel winicob x'ixicob. Jini cha'an Pablo tsa' loq'ui ya' ba' añob. Tsi' pʌyʌ majlel xcʌnt'añob ja'el. Tsi' cʌntesayob ti jujump'ejl q'uin ti escuela i cha'an Tiranno. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tsi' cha'le cʌntesa cha'p'ejl jab. Jini cha'an tsi' yubibeyob i t'an lac Yum Jesús pejtelel jini chumulo' bʌ ti Asia, judíojob yic'ot griegojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios tsi' c'ʌmbe i c'ʌb Pablo cha'an mi' pʌs wen ñuc tac bʌ i melbal. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Jini cha'an tsi' ch'ʌmʌyob majlel ba'an xc'amʌjelob jini pañuelo tac yic'ot welñʌc'ʌl tac tsa' bʌ i tʌlʌ Pablo. Tsa' lajmi i chʌmel xc'amʌjelob. Tsa' loq'uiyob i xibʌjlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jini xʌn pañimil bʌ judíojob tsa' bʌ i cha'leyob wujt tsi' lon ñopo i c'ʌmben i c'aba' lac Yum Jesús cha'an mi' chocob loq'uel xibajob. Tsi' yʌlʌyob: Mic subeñet loq'uel ti' c'aba' jini Jesús mu' bʌ i sub Pablo, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Che' lajal tsi' meleyob wuctiquil winicob, i yalobilob juntiquil judío, i c'aba' Esceva. I yum motomajob jini Esceva. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","I xibʌjlel jini winic tsi' jac'beyob: Mij cʌn Jesús. Mij cʌn Pablo ja'el. Pero jatetla, ¿majquiyetla? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Jini winic am bʌ i xibʌjlel tsa' tijp'i i chuc jini xwujtob. Tsi' ñolch'iyob ti pejtelob. Tsa' mʌjli i cha'an jini am bʌ i xibʌjlel. Tsa' puts'iyob loq'uel ti otot, pits'ilobix, lojwemobix. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Tsa' caji i yubiñob pejtelel judíojob yic'ot griegojob chumulo' bʌ ti Efeso. Ti pejtelob tsi' cha'leyob bʌq'uen. Tsa' ñuq'uesʌnti i c'aba' lac Yum Jesús. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Cabʌl tsa' bʌ i ñopoyob tsa' tili i subob i mul. Tsi' bajñel tsictesayob i bʌ cha'an chuqui tac tsi' cha'leyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Cabʌl tsa' bʌ i cha'leyob wujt tsi' tempayob i jun. Tsi' puluyob ti' wut winicob x'ixicob. Tsi' tsicbeyob i tojol, lujump'ejl i yuxc'al mil sʌsʌc taq'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Jini cha'an cabʌl tsa' ñojpi i t'an Dios. Tsa' wen tsictiyi i p'ʌtʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Che' bʌ tsa' ujti pejtelel jini, Pablo tsi' ña'ta ti Espíritu yom ñumel ti Macedonia yic'ot ti Acaya cha'an mi' majlel ti Jerusalén. Tsi' yʌlʌ: Wersa yom mic majlel ti Roma ja'el che' bʌ ñumeñonix ti Jerusalén, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Jini cha'an tsi' choco majlel ti Macedonia cha'tiquil tsa' bʌ i coltayob ti' ye'tel, jiñobʌch Timoteo yic'ot Erasto. I bajñel tsa' jale ts'ita ya' ti Asia. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Jini efesojob tsa' cajiyob ti cabʌl t'an cha'an i bijlel Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Come an juntiquil xten plata, i c'aba' Demetrio, tsa' bʌ i melbe ti sʌsʌc taq'uin i yotot tac jini dios i c'aba' Diana. Cabʌl tsi' cha'leyob ganar i yaj e'telob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio tsi' tempa jini x'e'telob yic'ot yaño' bʌ lajal bʌ i ye'tel. Tsi' subeyob: Winicob, la' wujil cabʌl mi lac cha'len ganar cha'an la que'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","La' wujil chuqui woli' mel Pablo, come tsa'ix la' q'uele. Tsa'ix la' wubibe i t'an. Tsa'ix i xic'beyob cabʌl winicob x'ixicob cha'an mi' cʌyob Diana, mach wʌ'ic jach ti Efeso, pero colel i ñumel ti pejtelel Asia ja'el. Mi' yʌl mach diosic jini melbil tac bʌ ti c'ʌbʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Jini cha'an bʌbʌq'uen mi' jilel la que'tel yic'ot i yotlel jini x'ixic dios, Diana, jini ñuc bʌ. Bʌbʌq'uen mi' jisʌntel i ñuclel jini dios mu' bʌ i ch'ujutesañob pejtelel año' bʌ ti Asia yic'ot ti pejtelel pañimil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Che' bʌ tsa'ix i yubiyob jini t'an cabʌl tsa' mich'ayob. Tsi' cha'leyob c'am bʌ t'an. Tsi' yʌlʌyob: ¡Ñuc lac dios Diana wʌ' ti Efeso! che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wen ju'ucñayob ti pejtelel tejclum. Ti ajñel tsi' tempayob i bʌ ti parque, chuculobix i cha'an Gayo yic'ot Aristarco ch'oyolo' bʌ ti Macedonia, i pi'ʌlob Pablo ti xʌmbal. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo yom ochel ba' añob pero jini xcʌnt'añob tsi' tiq'uiyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Cha'tiquil uxtiquil winicob año' bʌ i ye'tel ti Asia, i cʌñʌyo' bʌ Pablo, tsi' chocbeyob majlel winicob cha'an mi' subeñob ti wocol t'an mach yomic mi' yochel ti parque. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Jelchojc jax i t'an jini tempʌbilo' bʌ ti parque. Ju'uc'ñayob jax ti t'an. Cabʌlob mach yujilobic chucoch tsi' tempayob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jini judíojob tsi' pʌyʌyob loq'uel Alejandro ba' p'ululob winicob x'ixicob cha'an mi' pejcañob. Alejandro tsi' pʌsbeyob i c'ʌb cha'an mi' ñʌjch'elob, come yom i yʌq'ueñob i ch'ʌmben isujm. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Che' yujilobix judíojʌch jini Alejandro, cha'p'ejl ora tsi' chʌn cha'leyob c'am bʌ t'an ti pejtelelob. C'am tsi' yʌlʌyob: ¡Ñuc lac dios Diana wʌ' ti Efeso! che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Jini sts'ijbaya cha'an tejclum tsi' ñʌch'tesayob. Tsi' subeyob: Winicob, ¿baqui an juntiquil winic mach bʌ yujilic mi ti pejtelel lac tejclum Efeso mi' cʌntʌbentel i yotlel jini x'ixic dios Diana yic'ot i yejtal tsa' bʌ i choco jubel Júpiter? ");
INSERT INTO ctuBl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Actan, che' jini, ma'anic majch mi mejlel i contrajin jini t'an. Jini cha'an yom mi la' ñʌjch'el. Yom mi la' ch'ʌmben isujm chuqui yom mi la' mel. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Come jini winicob tsa' bʌ la' pʌyʌ tilel ma'anic mi' xujch'iñob jini templo. Ma'anic mi' p'ajob la' dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","La' tilicob Demetrio yic'ot i pi'ʌlob ti e'tel mi an chuqui yom i yʌlob ti' contra juntiquil winic. An melobʌjʌl, an xmeloñelob. La' i melob i bʌ cha'an i mul. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mi anto chuqui woli la' ña'tan, jini año' bʌ i ye'tel mi mejlel i yubiñob che' mi' tempañob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Come bʌbʌq'uen mi' caj ti sujbel lac mul cha'an jini leto tsa' bʌ ujti sajmʌl. Ma'anic mi mejlel lac sub chucoch tsa' tejchi jini ju'ucña bʌ t'an, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Che' bʌ tsa' ujti ti t'an, tsi' subeyob sujtel jini tempʌbilo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Che' bʌ tsa'ix lajmi jini ju'ucña bʌ t'an, Pablo tsi' pʌyʌ tilel xcʌnt'añob. Tsi' xic'beyob ti jini wen t'an. Tsi' lajlaj jats'beyob i pat. Tsi' subeyob i bʌ adiós. Pablo tsa' loq'ui cha'an mi' majlel ti Macedonia. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Che' bʌ woli' ñumel majlel ti' bijlel Grecia tsi' wen xic'beyob ti jini wen t'an. Tsa' c'oti ti Grecia. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ya'i tsa' jale uxp'ejl uw. Che' bʌ yomix majlel ti Siria ti barco, woli' chijtañob judíojob. Tsa' caji i ña'tan uts'at mi' cha' ñumel ti Macedonia. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tsi' pi'leyob majlel c'ʌlʌl ti Asia jini Sópater ch'oyol bʌ ti Berea, yic'ot Aristarco yic'ot Segundo ch'oyol bʌ ti Tesalónica, yic'ot Gayo ch'oyol bʌ ti Derbe, yic'ot Timoteo, yic'ot Tíquico, yic'ot Trófimo ch'oyolo' bʌ ti Asia. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Jiñob tsa' ñaxan majliyob i pijtañon lojon ti Troas. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Che' bʌ tsa' ñumi i q'uiñilel caxlan waj mach bʌ anic i levadurajlel, tsa' ochiyon lojon ti barco ya' ti Filipos. Jo'p'ejl q'uin tsac xʌñʌ lojon majlel. Ya' ti Troas tsac cha' taja lojon c bʌ. Ya'i tsa' jaleyon lojon wucp'ejl q'uin. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ti ñaxan bʌ q'uin ti semana che' bʌ tsi' tempayob i bʌ xcʌnt'añob cha'an mi' xet'ob waj, Pablo tsi' cʌntesayob. Come yomix majlel ti yijc'ʌlal, tsa' jale ti t'an c'ʌlʌl ti ojlil ac'ʌlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ya'an cabʌl lámpara ti' mal otot ti cha' lajmlel otot ba' tsi' tempayob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Juntiquil ch'iton, i c'aba' Eutico, buchul ti q'ueloñibʌl, woli ti wen wʌyel. Tsa' ñucle ti wʌyel come jal woli ti cʌntesa Pablo. Tsa' yajli ti lum. Chʌmenix tsi' lotoyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pablo tsa' jubi majlel. Tsa' bʌc' c'oti i mec'. Tsi' yʌlʌ: Mach la' mel la' pusic'al. Cuxul to, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Che' bʌ tsa'ix cha' letsi Pablo, tsi' xet'eyob waj, tsi' c'uxuyob. Jalto tsi' cha'le t'an c'ʌlʌl tsa' sʌc'a. Tsa' majli. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Cuxul tsi' pʌyʌyob majlel jini ch'iton. Jini cha'an tsa' ñuq'uesʌbentiyob i pusic'al jini hermanojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tsa' ochiyon lojon ti barco. Tsa' majliyon lojon ti Asón ba' com lojon c pʌy ochel Pablo, che' bajche' tsi' subeyon lojon. Come ti' yoc tsa' majli che' bajche' tsi' ña'ta. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Che' bʌ tsi' tajayon lojon ti Asón, tsac pʌyʌ lojon ochel ti barco. Tsa' c'otiyon lojon ti Mitilene. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tsa' cha' majliyon lojon ti barco. Ti yijc'ʌlal tsa' c'otiyon lojon ti' tojel Quío. Ti' cha'p'ejlel q'uin tsa' c'otiyon lojon ti Samos. Tsac ñusa lojon ac'ʌlel ti Trogilio. Ti' yuxp'ejlel q'uin tsa' c'otiyon lojon ti Mileto. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo mach yomic majlel ti Efeso, come mach yomic jalijel ya' ti Asia. Woli' se'ñun i bʌ, come yom c'otel ti Jerusalén cha'an i q'uiñilel Pentecostés mi muc'ʌch i mejlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Che' anto ti Mileto, Pablo tsi' choco majlel winicob ti Efeso. Tsi' pʌyʌ tilel jini ancianojob año' bʌ i ye'tel ti' tojlel xñopt'añob ya' ti Efeso. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Che' bʌ tsa' c'otiyob, Pablo tsi' subeyob: La' wujil bajche' añon la' wic'ot ti pejtelel ora c'ʌlʌl ti ñaxan bʌ q'uin che' bʌ tsa' ochiyon ti Asia. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tsac mele c bʌ ti pec' che' bʌ tsac melbe i ye'tel lac Yum. Tsi' tajayon cabʌl wocol. Tsac cha'le uq'uel cha'an judíojob tsa' bʌ i chijtayoñob. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ma'anic tsac bʌc'ña c subeñetla jini am bʌ i c'ʌjñibal la' cha'an. Tsaj cʌntesayetla ti' wut winicob x'ixicob yic'ot ti jujump'ejl la' wotot. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Tsa'ix c subeyob judíojob yic'ot gentilob cha'an mi' cʌyob i mul cha'an mi' ñopob Dios. Tsac subeyob cha'an mi' ñopob lac Yum Jesucristo. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Awilan, samiyonix ti Jerusalén come pʌybilonix majlel cha'an jini Espíritu. Mach cujilic chuqui mi caj c tumbentel ya'i. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Pero jini Ch'ujul bʌ Espíritu mi' subeñon ti jujump'ejl tejclum, mi caj i tajon wocol. Mi caj cochel ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ma'anic mij q'uel j cuxtʌlel ti ñuc. Anquese mi cʌjq'uel ti chʌmel, tijicña c pusic'al mi uts'at mic ts'ʌctesan que'tel tsa' bʌ aq'uentiyon ti lac Yum Jesús cha'an mic sub jini wen t'an cha'an i yutslel i pusic'al Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Awilan, tsa'ix c subu i yumʌntel Dios ti la' tojlel. Wʌle cujil ma'anix mi caj la' chʌn q'uel c wut. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Jini cha'an mic subeñetla ti jini jach bʌ ora, mach chʌn c wentajix la' cuxtʌlel ti la' pejtelel. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ma'anic tsac cha'le bʌq'uen, pero ts'ʌcʌl tsac subeyetla i t'an Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Chʌcʌ q'uele la' bʌ che' jini. Cʌntanla pejtelel jini tiñʌme', come jini Ch'ujul bʌ Espíritu tsi' yʌq'ueyetla la' we'tel ti xcʌntaya cha'an mi la' we'san jini xñopt'añob i cha'año' bʌ Dios tsa' bʌ i mʌñʌ ti' bajñel ch'ich'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Come cujil che' majlemonix mi caj i yochelob ti la' tojlel jontol bʌ bʌte'el ts'i'. Ma'anic mi caj i p'untan tiñʌme'. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Mi caj i wa'tʌlob winicob ti la' tojlel mu' bʌ i yʌlob sojquem bʌ t'an cha'an mi' pʌyob xcʌnt'añob cha'an mi' tsajcañob. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yom yʌxʌl la' wo che' jini. Ña'tanla, uxp'ejl jab ma'anic tsaj cʌyʌ c xic'beñetla ti jujuntiquiletla ti q'uiñil yic'ot ti ac'ʌlel. Tsac cha'le uq'uel. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Wʌle, hermanojob, mi cʌq'uetla ti' c'ʌb Dios yic'ot ti' wenta jini t'an mu' bʌ i tsictesan i yutslel i pusic'al. An i p'ʌtʌlel jini t'an cha'an mi' xuc'chocon la' pusic'al, cha'an mi la' wʌq'uentel chuqui tac la' tem cha'an jach la' wic'ot pejtelel jini sʌq'uesʌbilo' bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ma'anic tsac mulʌbeyetla chuqui an la' cha'an, mi plata, mi oro, mi pisil. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","La' wujil, tsac cha'le e'tel tij c'ʌb cha'an i bʌl c ñʌc'. Tsac we'sa c pi'ʌlob ja'el año' bʌ quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ti pejtelel tsa' bʌ c mele tsac pʌsbeyetla bajche' yom mi lac cha'len e'tel cha'an mi laj coltan jini mach bʌ p'ʌtʌlobic. Yom mi la' ña'tan i t'an lac Yum Jesús tsa' bʌ i yʌlʌ: “Ñumen tijicña jini mu' bʌ i yʌc' majtañʌl bajche' jini mu' bʌ i ch'ʌm i majtan”. Che' tsi' yʌlʌ Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Che' bʌ tsa' ujti ti jini t'an tsa' ñocle. Pablo tsi' como pejca Dios yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ti pejtelelob tsi' cha'leyob cabʌl uq'uel. Tsi' meq'ueyob Pablo. Tsi' ts'ujts'uyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Wen ch'ijiyem tsi' yubiyob cha'an tsi' subeyob ma'anix mi caj i chʌn q'uelbeñob i wut. Tsi' pi'leyob majlel c'ʌlʌl ti barco. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Che' bʌ tsaj cʌyʌyob lojon tsa' ochiyon lojon ti barco. Toj tsa' majliyon lojon ti Cos, ti yijc'ʌlal c'ʌlʌl ti Rodas, ti wi'il c'ʌlʌl ti Pátara. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ya' tsac taja lojon barco woli bʌ i majlel ti Fenicia. Tsa' ochiyon lojon. Tsa' majliyon lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Che' bʌ tsaj q'uele lojon Chipre, tsaj cʌyʌ lojon tic ts'ej. Tsa' ñumiyon lojon majlel c'ʌlʌl ti Siria. Tsa' c'otiyon lojon ti Tiro, come ya' yom i cʌy i cuch jini barco. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Che' bʌ tsac taja lojon xcʌnt'añob tsa' jaleyon lojon ya'i wucp'ejl q'uin. Tsi' subeyob Pablo ti jini Espíritu mach yomic mi' letsel majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Che' ñumenix jump'ejl semana tsa' majliyon lojon. Ti pejtelelob tsi' pi'leyon lojon majlel yic'ot x'ixicob yic'ot i yalobilob, c'ʌlʌl che' bʌ tsa' loq'uiyon lojon ti tejclum. Ya' ti' ti' ja' tsa' cajiyon lojon ti ñoctʌl, tsac pejca lojon Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Che' bʌ tsa'ix j cʌyʌ lojon c bʌ, tsa' ochiyon lojon ti barco. Jini xcʌnt'añob tsa' sujtiyob ti' yotot. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Che' loq'uemonix lojon ti Tiro ti barco, tsa' c'otiyon lojon ti Tolemaida. Ya'i tsa cʌq'ue lojon cortesía hermanojob. Tsa' jaleyon lojon jump'ejl q'uin yic'otob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ti yijc'ʌlal che' bʌ tsa' majliyon lojon, tsa' c'otiyon lojon ti Cesarea. Ya' tsa' ochiyon lojon ti' yotot Felipe, jini subt'an, jini tsa' bʌ aq'uenti i ye'tel yic'ot jini wʌctiquil. Tsa' jijliyon lojon quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","An chʌntiquil i yixic'al mach bʌ anic i ñoxi'al. Tsi' cha'leyob alt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Che' bʌ tsa' jaleyon lojon ya'i cha'p'ejl uxp'ejl q'uin, tsa' jubi tilel juntiquil x'alt'an loq'uem bʌ ti Judea, i c'aba' Agabo. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Che' bʌ tsa' c'oti ba' añon lojon, tsi' ch'ʌmbe i cajchiñʌc' Pablo. Tsi' bajñel cʌchʌ i yoc i c'ʌb. Tsi' subu: Jini Ch'ujul bʌ Espíritu mi' yʌl: “Che'i mi caj i cʌchob i yum jini cajchiñʌc'ʌl jini judíojob año' bʌ ti Jerusalén. Mi caj i yʌc'ob ti' c'ʌb gentilob”. Che' mi' yʌl Ch'ujul bʌ Espíritu, che'en Agabo. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Che' bʌ tsa'ix cubi lojon jini t'an, joñon lojon quic'ot jini ya' bʌ añob tsac sube lojon Pablo ti wocol t'an cha'an ma'anic mi' letsel majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pablo tsi' subeyon lojon: ¿Chucoch mi la' cha'len uq'uel? ¿Chucoch mi la' wʌq'ueñon i ch'ijiyemlel c pusic'al? Joñon chajpʌbilon, mach cojic jach cha'an mij cʌjchel, pero cha'an mic chʌmel ja'el ti Jerusalén cha'an ti' c'aba' lac Yum Jesús, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Che' bʌ ma'anic tsi' jac'beyon lojon c t'an, tsaj cʌyʌ lojon c suben. Tsac sube lojon: La' mejlic chuqui yom lac Yum, cho'on lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ti wi'il tsac chajpa lojon c chubʌ'an. Tsa' letsiyon lojon majlel ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Cha'tiquil uxtiquil xcʌnt'añob ch'oyolo' bʌ ti Cesarea tsi' pi'leyon lojon majlel. Tsi' pʌyʌyon lojon majlel ti' yotot juntiquil xcʌnt'an i c'aba' Mnasón, ch'oyol bʌ ti Chipre. Jini Mnasón wajalix tsi' ñopo. Ya' tsa' jijliyon lojon quic'ot. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Che' bʌ tsa' c'otiyon lojon ti Jerusalén, tijicñayob i pusic'al jini hermanojob, tsi' pʌyʌyon lojon ochel. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ti yijc'ʌlal tsa' ochi Pablo quic'ot lojon ba'an Jacobo. Tsi' tempayob i bʌ pejtelel jini ancianojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Che' bʌ tsi' yʌq'ueyob i bʌ cortesía, Pablo quepecña tsa' caji i subeñob pejtelel chuqui tac tsi' cha'le Dios ti' tojlel gentilob ya' ba' tsi' cha'le subt'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Che' bʌ tsi' yubiyob, tsi' subuyob i ñuclel Dios. Jini ancianojob tsi' subeyob Pablo: Hermano, tsa'ix a wubi jayp'ejl mil judíojob tsi' ñopoyob. Ti pejtelelob wen bʌxob cha'an jini mandar. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tsa'ix lon subentiyob jini wʌ' bʌ añob, wola' cʌntesan judíojob ya' ti' tojlel gentilob cha'an mi' cʌyob i mandar Moisés. Wola' sub mach yomic mi' tsepbeñob i pʌchʌlel i yalobilob, yic'ot mach yomic mi' cha'leñob che' bajche' i tilel judíojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Jini cha'an, ¿chuqui yom mi lac cha'len? Mi caj i yubiñob tsa'ix tiliyet. Isujm, mi caj i tempañob i bʌ cabʌl winicob x'ixicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Jini cha'an, mele chuqui mic subeñet lojon. Wʌ' añob chʌntiquil winicob tsa' bʌ i subeyob Dios chuqui mi caj i wersa melob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pʌyʌyob majlel. Sʌq'uesan a bʌ yic'otob. Tojbeñob chuqui yom cha'an mi' set'bentelob i jol. Che'i mi caj i ña'tañob ti pejtelelob mach isujmic jini tsa' bʌ subentiyob, come mach che'ic wola' mel. Mi caj i ña'tañob jatet ja'el wolix a jac' jini mandar. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Jixcu jini gentilob tsa' bʌ i ñopoyob, tsa'ix c ts'ijbubeyob lojon chuqui tsac ña'ta lojon. Tsac subeyob lojon cha'an mi' cʌyob i c'ux jini tsʌnsʌbil bʌ i majtan dioste' yic'ot i ch'ich'el yic'ot milbil tac bʌ. Tsac sube lojon cha'an ma'anic mi' cha'leñob ts'i'lel. Che' tsi' subeyob Pablo jini ancianojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pablo tsi' pʌyʌyob jini winicob. Ti yijc'ʌlal tsi' sʌq'uesa i bʌ yic'otob. Tsa' ochi ti Templo cha'an mi' subeñob baqui bʌ q'uin mi caj i yujtel i sʌq'uesañob i bʌ, yic'ot baqui bʌ q'uin mi caj i yʌq'uentel i majtan Dios am bʌ ti' wenta ti jujuntiquil. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Che' yomix ts'ʌctiyel jini wucp'ejl q'uin, cha'tiquil uxtiquil judíojob ch'oyolo' bʌ ti Asia tsi' q'ueleyob Pablo ti Templo. Tsi' ñijcayob winicob cha'an mi' chucob Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Jini winicob c'am tsi' yʌlʌyob: Winicob israelob la'la ti coltaya. Umba'an jini winic mu' bʌ i cha'len cʌntesa ti' contra i cha'año' bʌ Dios yic'ot ti' contra jini mandar yic'ot ti' contra jini Templo. Che'ʌch woli' pam cʌntesan winicob x'ixicob. Mach cojic jach jini, pero tsa'ix i pʌyʌ ochel griegojob ja'el ti' mal Templo. Tsa'ix i bibesa jini Ch'ujul bʌ Ajñibʌl, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Come tsi' lon ña'tayob tsa'ix i pʌyʌ ochel ti' mal Templo juntiquil winic ch'oyol bʌ ti Efeso, i c'aba' Trófimo, come anix ora tsi' q'ueleyob yic'ot Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jini cha'an tsa' tejchiyob ti a'leya pejtelel winicob año' bʌ ti jini tejclum. Ti ajñel tsi' tempayob i bʌ. Tsi' chucuyob Pablo. Tsi' tujc'ayob loq'uel ti Templo. Ti ora tsa' ñujp'i i ti' Templo. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Che' bʌ woli' ñopob i tsʌnsan Pablo, tsa' subenti jini am bʌ ñuc bʌ i ye'tel ti' tojlel jump'ejl mil soldadojob cha'an woliyob ti leto pejtelel winicob ti Jerusalén. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Jini am bʌ i ye'tel tsi' pʌyʌ majlel soldadojob yic'ot i yaj capitañob. Ti ajñel tsa' majliyob ba' añob. Jini winicob tsi' cʌyʌyob i jats' Pablo che' bʌ tsi' q'ueleyob jini am bʌ ñuc bʌ i ye'tel yic'ot soldadojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tsa' c'oti jini am bʌ ñuc bʌ i ye'tel. Tsi' chucu Pablo. Tsi' yʌc'ʌ mandar cha'an mi' cʌjchel ti cha't'ujm cadena. Tsi' c'ajtibe i c'aba' yic'ot chuqui tsi' cha'le. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ti pejtelelob woliyob ti c'am bʌ t'an. Jelchojc jax chuqui tsi' yʌlʌyob. Ma'anic tsa' mejli i ch'ʌmben isujm chuqui tsa' ujti come ju'ucñayob ti cabʌl t'an. Jini cha'an tsi' yʌq'ueyob mandar cha'an mi' pʌyob majlel Pablo ti' yotot soldadojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Che' bʌ tsa' c'otiyob ba' quejpʌctic ts'ajc, jini soldadojob tsi' ch'uyuyob majlel Pablo, come wen mich'ob winicob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Woli' tsajcañob majlel. C'am tsi' yʌlʌyob: Tsʌnsanla, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Che' bʌ tsa' caji i pʌyob ochel Pablo ti' yotot soldadojob, Pablo tsi' sube jini ñuc bʌ i ye'tel: ¿Mejl ba c pejcañet? che'en. Jini ñuc bʌ i ye'tel tsi' sube: ¿A cʌñʌ ba i t'an griegojob? ");
INSERT INTO ctuBl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Mach ba jatetic jini egipto tsa' bʌ i teche leto ti' contra gobierno maxto jali? ¿Mach ba jatetic tsa' pʌyʌ majlel ti jochol bʌ lum lujumbajc' stsʌnsajob? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo tsi' sube: Mach joñonic. Mero judíojon. Ch'oyolon ti Tarso ya' ti Cilicia. Ya' chucbil j c'aba' ti ñuc bʌ tejclum. Awocolic, la' c pejcan jini winicob, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Che' bʌ tsi' yʌc'ʌ i t'an, che' wa'alix Pablo ba' quejpʌctic, tsi' pʌsbeyob i c'ʌb jini winicob. Che' bʌ tsa' wen ñʌjch'iyob, Pablo tsa' caji i pejcañob ti' t'an hebreojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pablo tsi' yʌlʌ: Winicob c pi'ʌlob, ñich'tanla chuqui mic subeñetla wʌle, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Che' bʌ tsi' yubiyob woli' pejcañob ti' t'an hebreojob, tsa' wen ñʌjch'iyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Pablo tsi' subeyob: Isujm judíojon. Tsa quila pañimil ti Tarso ya' ti Cilicia. Wʌ' tsa' coliyon ilayi ti ili tejclum. Cʌntesʌbilon i cha'an Gamaliel. Tsa' cʌntesʌntiyon ti' sujmlel jini mandar che' bajche' tsi' ñopoyob lac ñojte'el. Wen bʌxon cha'an Dios che' bajche'etla ti la' pejtelel wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Tsac tic'la jini año' bʌ ti' bijlel Dios. Tsa cʌcʌ'yob ti chʌmel. Tsac chucu winicob yic'ot x'ixicob. Tsa cotsayob ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jini ñuc bʌ motomaj ja'el yic'ot pejtelel xñoxob año' bʌ i ye'tel yujilob isujm c t'an, come tsi' yʌq'ueyoñob jun cha'an mic pʌsbeñob lac pi'ʌlob. Ya' tsa' majliyon ti Damasco cha'an mic chuc jini ya' bʌ añob cha'an cʌchʌl mic pʌyob tilel ti Jerusalén cha'an mi' tojob i mul. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Che' bʌ woliyon ti xʌmbal majlel, che' lʌc'ʌlix añon ti Damasco ti xinq'uiñil, tsa' bʌc' tsictiyi tic joytilel i c'ʌc'al c'ajc ch'oyol bʌ ti panchan. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Tsa' yajliyon ti lum. Tsa cubi t'an. Tsi' subeyon: “¿Saulo, Saulo, cucoch wola' tic'lañon?” che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Tsac jac'ʌ: “C Yum, ¿majquiyet?” cho'on. Tsi' subeyon: “Joñon Jesúson ch'oyolon bʌ ti Nazaret. Woli a tic'lañon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Jini año' bʌ quic'ot, ti isujm tsi' q'ueleyob i c'ʌc'al c'ajc. Tsi' cha'leyob bʌq'uen. Ma'anic tsi' yubibeyob chuqui woli' yʌl jini tsa' bʌ i pejcayon. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Tsac sube: “¿Chuqui yom mic cha'len c Yum?” cho'on. Lac Yum tsi' subeyon: “Ch'ojyen. Cucu ti Damasco. Ya'i mi caj a subentel pejtelel chuqui wʌn ña'tʌbil c cha'an mu' bʌ caj a mel”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Che' bʌ ma'anic tsa' c'oti c wut cha'an i sʌclel jini c'ajc, tsi' toj'esayoñob majlel tij c'ʌb jini ya' bʌ añob quic'ot. Tsa' c'otiyon ti Damasco. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ya' an winic, i c'aba' Ananías, mu' bʌ i ch'ujutesan Dios, che' bajche' cʌntesʌbilonla ti mandar. Wen uts'at tsa' q'uejli cha'an pejtelel judíojob ya' bʌ chumulob. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tsa' tili ba' añon. Tsa' wa'le tic t'ejl. Tsi' subeyon: “Hermano Saulo, la' c'otic a wut”, che'en Ananías. Ti jini jach bʌ ora tsa' c'oti c wut. Tsaj q'uele Ananías. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Tsi' subeyon: “I Dios lac ñojte'el tsi' yajcayet cha'an ma' cʌn chuqui yom i pusic'al Dios. Tsi' yajcayet cha'an ma' q'uel jini Toj bʌ, yic'ot cha'an ma' wubiben i t'an che' mi' pejcañet. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Come mi caj a wʌc' ti cʌjñel Cristo ti' tojlel pejtelel winicob x'ixicob. Mi caj a subeñob chuqui tac tsa' q'uele yic'ot chuqui tsa' wubi. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Wʌle, ¿chucoch woliyet ti pijt? Ch'ojyen. Pejcan Dios ti' c'aba' Jesús. Ch'ʌmʌ ja', la' pojquic loq'uel a mul”. Che' tsi' subeyon Ananías. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Che' bʌ tsa' cha' tiliyon ti Jerusalén, woliyon ti oración ti Templo. An chuqui tsa' caji j q'uel ti espíritu. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Tsaj q'uele Jesús tsa' bʌ i subeyon: “Se'ñun a bʌ, loq'uen ti Jerusalén ti ora come ma'anic mi caj i jac'ob chuqui wola' subeñob cha'añon”, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Tsac sube: “C Yum, yujlilob joñon tsa cotsa ti mʌjquibʌl jini tsa' bʌ i ñopoyet. Tsac bajbeyob ti sinagoga tac. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Che' bʌ tsa' bejq'ui i ch'ich'el Esteban, jini subt'an a cha'an, ya' lʌc'ʌl wa'alon ja'el. Ma'anic tsac tiq'uiyob. Tsaj cʌntʌbeyob i pislel jini tsa' bʌ i tsʌnsayob”, cho'on tsac sube. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Jesús tsi' subeyon: “Cucu come joñon mi caj c choquet majlel ti ñajtʌl ba'an gentilob”. Che' tsi' subeyon Jesús, che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tsi' ñich'tayob judíojob jinto tsa' ujti i sub jini t'an. Jini winicob tsa' cajiyob ti c'am bʌ t'an. Tsi' yʌlʌyob: “La' chʌmic jini winic. Mach uts'atic che' chʌn cuxul”, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Wen c'am tsi' cha'leyob t'an. Tsi' tijcayob i bujc. Tsi' wejch'uyob letsel ts'ubejn. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Jini ñuc bʌ i ye'tel tsi' yʌc'ʌ mandar cha'an mi' pʌjyel ochel Pablo ti' yotot soldadojob. Tsi' yʌc'ʌ mandar cha'an mi' jajts'el ti asiyal cha'an mi' tsictesan i mul, come yom i ña'tan chucoch tsi' cha'leyob cabʌl t'an ti' contra. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Che' bʌ tsa'ix i cʌchʌyob Pablo ti pʌchi, Pablo tsi' c'ajtibe i yaj capitán soldadojob wa'al bʌ ti' t'ejl: ¿Mach ba tic'bilic ti mandar mi' jajts'el ti asiyal juntiquil winic chucbil bʌ i c'aba' ya' ti Roma, che' maxto ña'tʌbilic mi an i mul? che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Che' bʌ tsi' yubibe i t'an Pablo, i yaj capitán soldadojob tsa' majli ba'an jini ñuc bʌ i ye'tel. Tsi' sube: ¿Chuqui mi caj a cha'len? Chucbil i c'aba' jini winic ya' ti Roma, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Jini ñuc bʌ i ye'tel tsa' tili ba'an Pablo. Tsi' sube: Subeñon, ¿chucbil ba a c'aba' ya' ti Roma? che'en. Pablo tsi' jac'ʌ: Chucbil cu, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Jini ñuc bʌ i ye'tel tsi' yʌlʌ: Cabʌl taq'uin tsac jisa cha'an mi' chujquel j c'aba' ya' ti Roma, che'en. Pablo tsi' sube: Pero tsa' chujqui j c'aba' ya' ti Roma che' bʌ tsa quila pañimil, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Jini cha'an jini yomo' bʌ i jats' Pablo cha'an mi' tsictesan i mul tsi' bʌc' cʌyʌyob. Che' bʌ tsi' ña'ta ya' chucul i c'aba' Pablo ti Roma, jini ñuc bʌ i ye'tel tsi' cha'le bʌq'uen ja'el, come an i mul cha'an tsi' cʌchʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ti yijc'ʌlal yom i ñop ti isujm chucoch tsi' cha'leyob t'an jini judíojob ti' contra Pablo. Tsi' jiti. Tsi' subeyob tilel pejtelel ñuc bʌ motomajob yic'ot jini año' bʌ i ye'tel. Tsi' pʌyʌ tilel Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo tsi' wen q'uele jini año bʌ i ye'tel. Tsi' yʌlʌ: Winicob, c pi'ʌlob, ti pejtelel chuqui tac tsac mele, Dios tsi' q'uele. C'ʌlʌl wʌle ma'anic mi' tejchel t'an tic pusic'al cha'an uts'at pejtelel chuqui tsac cha'le ti' wut Dios, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Jini c'ax ñuc bʌ motomaj, i c'aba' Ananías, tsi' sube jini wa'alo' bʌ ti' t'ejl cha'an mi' jats'beñob i yej Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Pablo tsi' sube: Mi caj i jats'et Dios. Pajq'uet bombil bʌ ti tan. Buchulet cha'an ma' c'ʌn jini mandar a melon, pero wola' ñusan mandar che' ma' wʌc'on ti jajts'el, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Jini wa'alo' bʌ tsi' yʌlʌyob: ¿Mu' ba a p'aj jini ñuc bʌ motomaj i cha'an Dios? che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo tsi' yʌlʌ: C pi'ʌlob, ma'anic tsaj cʌñʌ mi jiñʌch ñuc bʌ motomaj. Come ts'ijbubil: “Mach a p'aj jini yumʌl am bʌ i ye'tel ti la' tojlel”, che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pablo tsi' ña'ta ya' añob cha'chajp winicob, saduceojob yic'ot fariseojob. Jini cha'an c'am tsi' cha'le t'an ba'an jini año' bʌ i ye'tel. Tsi' yʌlʌ: Winicob c pi'ʌlob, fariseojon, i yalobilon fariseo. Mic ñop an i pijtaya jini chʌmeño' bʌ come mi' cha' ch'ojyelob chʌmeño' bʌ. Jini cha'an pʌybilonix tilel cha'an mi la' melon, che'en Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Che' bʌ tsa' ujti i sub jini t'an, tsa' caji i cʌlʌx pejcañob i bʌ fariseojob yic'ot saduceojob. Cha'chajp tsa' cajiyob ti t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Come jini saduceojob mi' yʌlob ma'anic mi lac cha' ch'ojyel, ma'anic ángel, ma'anic espíritu. Pero mach che'ic mi' yʌlob jini fariseojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wen ju'ucña tsa' cajiyob ti t'an. Jini sts'ijbayajob i cha'an fariseojob tsa' wa'leyob. Tsi' wersa alʌyob: Mi cʌl lojon ma'anic i mul jini winic. Tic'ʌl mi tsi' pejca Pablo juntiquil espíritu o juntiquil ángel. Mach yomic mi laj contrajin Dios, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Che' wen mich'ob woli' cʌlʌx pejcañob i bʌ, jini ñuc bʌ i ye'tel tsi' cha'le bʌq'uen ame mi' tsʌnsañob Pablo. Tsi' cha'le mandar cha'an mi' tilelob soldadojob cha'an mi' wersa chucob loq'uel Pablo ba' añob, cha'an mi' pʌyob ochel ti' yotot soldadojob. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ti jini ac'ʌlel lac Yum tsa' wa'le ti' t'ejl Pablo. Tsi' sube: Xuc'chocon a pusic'al Pablo. Che' bajche' tsa' wʌc'ʌyon ti cʌjñel ti Jerusalén, che' ja'el mi caj a wʌc'on ti cʌjñel ya' ti Roma, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ti sʌc'ajel cabʌl judíojob tsi' tempayob i bʌ. Tsi' temeyob i t'an cha'an mi' tsʌnsañob Pablo. Tsi' bajñel ch'ʌcʌyob i bʌ cha'an ma'anic chuqui mi caj i c'uxob, ma'anic chuqui mi caj i japob jinto mi' tsʌnsañob Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ñumen ti cha'c'al tsa' bʌ i temeyob i t'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Tsa' majliyob ba'an i yumob motomajob yic'ot xñoxob año' bʌ i ye'tel. Tsi' yʌlʌyob: Tsa'ix c wersa wa'choco lojon c t'an che' bʌ tsac bajñel ch'ʌcʌ lojon c bʌ. Ma'anic mi caj c wis c'ux lojon i bʌl lojon c ñʌc' jinto mic tsʌnsan lojon Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jatetla, che' jini, yic'ot jini año' bʌ i ye'tel, c'ajtibenla jini am bʌ ñuc bʌ i ye'tel cha'an ijc'ʌl mi' cha' pʌy tilel Pablo ba' añetla. Subenla an chuqui la' wom la' cha' c'ajtiben. Chajpʌbilon lojon cha'an mic tsʌnsan lojon che' maxto c'otemic ba' añetla, che'ob. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Che' bʌ tsi' yubi i yichac' Pablo bajche' mi caj i chijtañob, tsa' majli, tsa' ochi ti' yotot soldadojob. Tsi' sube Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pablo tsi' pʌyʌ tilel juntiquil i yaj capitán soldadojob. Tsi' yʌlʌ: Pʌyʌ majlel jini ch'iton ba'an jini ñuc bʌ i ye'tel, come an chuqui yom i suben, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","I yaj capitán soldadojob tsi' pʌyʌ majlel. Tsa' majliyob ba'an jini ñuc bʌ i ye'tel. Tsi' sube: Tsi' pʌyʌyon jini xñujp'el Pablo. Tsi' c'ajtibeyon cha'an mic pʌy tilel jini ch'iton ba' añet come an chuqui yom i subeñet, che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Jini ñuc bʌ i ye'tel tsi' chucbe i c'ʌb jini ch'iton. Tsi' mucu pʌyʌ majlel. Tsi' c'ajtibe: ¿Chuqui a wom a subeñon? che'en. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tsi' sube: Tsa'ix i tempayob i bʌ judíojob cha'an mi' c'ajtibeñet cha'an ma' pʌy jubel Pablo ijc'ʌl ba'an jini año' bʌ i ye'tel. Mi caj i lon alob an chuqui yomob i cha' c'ajtiben Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mach a jac'beñob i t'an, come ñumen ti cha'c'al winicob woli' chijtañob. Tsi' bajñel ch'ʌcʌyob i bʌ cha'an ma'anic chuqui mi caj i c'uxob, ma'anic chuqui mi caj i japob jinto mi' tsʌnsañob Pablo. Tsa'ix i chajpayob i bʌ. Woli jach i pijtañob a t'an, che'en jini ch'iton. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Jini ñuc bʌ i ye'tel tsi' sube majlel jini ch'iton. Tsi' tiq'ui ame i suben yambʌ chuqui tsa'ix i tsictesʌbe. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Tsi' pʌyʌ tilel cha'tiquil i yaj capitán soldadojob. Tsi' subeyob cha'an mi' chajpañob lujunc'al soldadojob cha'an mi' majlelob ti Cesarea ti bolomp'ejl ora i yic'an yic'ot lujuntiquil i chʌnc'al (70) c'ʌchʌlo' bʌ yic'ot lujunc'al año' bʌ i lanza. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Tsi' subeyob cha'an mi' chajpʌbeñob i c'ʌchlib Pablo ja'el cha'an c'ʌchʌl mi' pʌyob majlel ti uts'at ba'an Félix, jini gobernador. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Tsi' ts'ijba jun. Tsi' yʌlʌ: ");
INSERT INTO ctuBl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Joñon Claudio Lisiason. Mic chocbeñet tilel cortesía, c'ax uts'at bʌ gobernador Félix. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jini winic tsa' chujqui cha'an judíojob. Colelix i tsʌnsañob. Tsa' majliyon quic'ot soldadojob cha'an mij coltan, come tsac ña'ta chucbil i c'aba' ya' ti Roma. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Che' bʌ tsaj c'ajtibeyob chuqui i mul woli' subob ti' contra Pablo, tsac pʌyʌ majlel Pablo ba' tsi' tempayob i bʌ jini judíojob año' bʌ i ye'tel. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Tsaj q'uele woli' tajtʌl i mul cha'an jach i mandar judíojob. Tsac ña'ta ma'anic i mul cha'an mi' tsʌnsʌntel, mi cha'an mi' yochel ti mʌjquibʌl. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Che' bʌ tsa cubi woli' chijtañob jini winic jini judíojob, tsac bʌc' choco majlel ba' añet. Tsac subeyob i contrajob cha'an mi' majlelob i subeñet i mul. Cojach mic subeñet jini”. Che' tsi' ts'ijba jini Claudio Lisias. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Ti ac'ʌlel jini soldadojob tsi' pʌyʌyob majlel Pablo ti Antípatris che' bajche' tsa' subentiyob. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ti yijc'ʌlal tsa' sujtiyob ti' yotot. Pero jini c'ʌchʌlo' bʌ tsa' majliyob yic'ot Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Che' bʌ tsa' c'otiyob ya' ti Cesarea, tsi' yʌq'ueyob jun jini gobernador. Tsi' pʌyʌyob majlel Pablo ba'an. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Che' bʌ tsa' ujti i q'uel jini jun jini gobernador, tsi' c'ajtibe baqui ch'oyol. Tsa' subenti ya' ch'oyol ti Cilicia. ");
INSERT INTO ctuBl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Jini gobernador tsi' sube: Che' mi' julelob a contrajob mi caj cubin a t'an, che'en. Tsi' yʌc'ʌ mandar cha'an mi' cʌntʌntel Pablo ya' ti' yotot Herodes. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Che' bʌ tsa' ñumi jo'p'ejl q'uin, tsa' jubi majlel jini ñuc bʌ motomaj i c'aba' Ananías yic'ot cha'tiquil uxtiquil xñoxob año' bʌ i ye'tel yic'ot juntiquil i c'aba' Tértulo wen yujil bʌ t'an. Tsa' majli i pejcañob jini gobernador ti' contra Pablo. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Che' bʌ tsa' pʌjyi tilel Pablo ba' añob, Tértulo tsa' caji i jop'ben i mul Pablo. Tsi' yʌlʌ: Cha'an ti a we'tel ti yumʌl ñʌch'ʌl añon lojon tic lumal. Cha'an ti a ña'tʌbal uts'at woli' cʌntʌntelob c pi'ʌlob tic lumal. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Uts'atet Félix, ti pejtelel ora uts'at mij q'uel lojon a melbal ti pejtelel c lumal. Mic subeñet lojon wocolix a wʌlʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mach comic c jalitesañet ti cabʌl t'an. Jini cha'an mic subeñet poj ubibeñon lojon ts'ita' c t'an ti' yutslel a pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Come tsa'ix j q'uele lojon cabʌl woli' tic'lañon lojon jini winic. Mi' tech leto ti pejtelel pañimil baqui jach an judíojob. Jini winic ñumen ch'ejl mi' mel i bʌ bajche' yaño' bʌ tsa' bʌ i tsajcʌbeyob i cʌntesʌbal jini winic ch'oyol bʌ ti Nazaret. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Tsa'ix i ñopo i bib'esan jini Templo ja'el, pero tsac chucu lojon. Tsac ña'ta c mel lojon che' bajche' mi' yʌl tic mandar lojon, ");
INSERT INTO ctuBl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","pero tsa' tili jini Lisias am bʌ ñuc bʌ i ye'tel. Wersa tsi' chili loq'uel Pablo tij c'ʌb lojon. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jini Lisias tsi' subeyob i contrajob Pablo cha'an mi' tilelob ba' añet. Che' ma' c'ajtiben jini winic mi mejlel a ña'tan isujm pejtelel i mul tsa' bʌ c subeyet lojon. Che' tsi' yʌlʌ jini Tértulo. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Lajal tsi' cha'leyob t'an judíojob ja'el. Che' tsi' yʌlʌyob ti pejtelelob. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Che' bʌ tsi' pʌsʌ i c'ʌb jini gobernador cha'an mi' cha'len t'an, Pablo tsi' yʌlʌ: Cabʌl jab gobernadoret tic lumal. Jini cha'an tijicña mic sub c bʌ ti a tojlel. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Majqui jach ma' pejcan mi mejlel i subeñet an jaxto lajchʌmp'ejl q'uin tsa' letsiyon majlel ti Jerusalén cha'an mic ch'ujutesan Dios. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tsi' q'ueleyoñob. Ma'anic majqui wolij cʌlʌx pejcan mi ti Templo, mi ti sinagoga mi ti jini tejclum. Ma'anic tsac xic'beyob winicob x'ixicob cha'an mi' tempañob i bʌ. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ma'anic mi mejlel i tsictesañob ti isujm i t'an woli bʌ i jop'ob tij contra wʌle. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mic subeñet ti isujm, mic ñop i bijlel Dios. Mi' yʌlob sojquem bajche' mic ch'ujutesan jini Dios tsa' bʌ i ñopoyob c ñojte'el. Mic ñop pejtelel mu' bʌ i yʌl jini mandar yic'ot chuqui tac ts'ijbubil ti' t'an x'alt'añob. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Añʌch c pijtaya ti Dios, jini jach mu' bʌ i ñopob ja'el, come tal i yorajlel che' mi caj i ch'ojyelob jini chʌmeño' bʌ, jini tojo' bʌ yic'ot jini mach bʌ tojobic. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Jini cha'an mic chʌn cha'len wersa c mel chuqui toj ti' wutob winicob yic'ot ti' wut Dios cha'an ma'anic mi' cajel ti t'an c pusic'al. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Che' bʌ tsa' ñumi cha'p'ejl uxp'ejl jab, tsa' tiliyon cha'an mi cʌq'ueñob taq'uin jini p'umpuño' bʌ tic lumal, cha'an mi cʌq'uen Dios i majtan ja'el. ");
INSERT INTO ctuBl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Che' bʌ woli cʌq'uen Dios i maj